/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b4c0ULL, 0x000000000001b140ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x0000000000019580ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x0000000000019700ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x0000000000019740ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x0000000000019790ULL, 0x00000000000000f0ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019880ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001958000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x0063f00400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001958000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880809d082880ULL, 0x8080a1082880809fULL,
0xa508288080a30828ULL, 0x288080ea08288080ULL, 0x80f008288080ec08ULL, 0x08288080f2082880ULL,
0x80828016288080d2ULL, 0x0000000000031028ULL, 0x288080d292000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001970000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880809d082880ULL, 0x8080a1082880809fULL,
0xa608288080a30828ULL, 0x288080d208288080ULL, 0x80ec08288080ea08ULL, 0x08288080f0082880ULL,
0x8080a508288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001974000000000ULL, 0x0000005000000000ULL,
0x0000040400000000ULL, 0x80ea288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL,
0x082880809d082880ULL, 0x8080a1082880809fULL, 0xa508288080a30828ULL, 0x288080d208288080ULL,
0x80ec08288080ea08ULL, 0x08288080f0082880ULL, 0x8080a608288080f2ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL,
0x0001979000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000daULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x0000001600080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500009ULL,
0x00000000000c1704ULL, 0x0021f00000480008ULL, 0x00000000000c1704ULL, 0x0011f00000400007ULL,
0x00000000000c1704ULL, 0x0061f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x019c290400000b00ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x019c2804ffffffffULL,
0x000002e000000110ULL, 0x000026d000000580ULL, 0x0000289000002780ULL, 0x00002b7000002a00ULL,
0x0000315000002cd0ULL, 0x000031a000003190ULL, 0x00005b30000031d0ULL, 0x00005ce000005bd0ULL,
0x00005fc000005e50ULL, 0x0000659000006120ULL, 0x000065e0000065d0ULL, 0x00008ee000006610ULL,
0x0000909000008f80ULL, 0x0000937000009200ULL, 0x00009940000094d0ULL, 0x0000999000009980ULL,
0x0000c130000099c0ULL, 0x0000c2e00000c1d0ULL, 0x0000c5c00000c450ULL, 0x0000cb800000c720ULL,
0x0000cbd00000cbc0ULL, 0x0000e8f00000cc00ULL, 0x0000e9100000e900ULL, 0x000174000000e920ULL,
0x0001745000017440ULL, 0x000174b000017460ULL, 0x000174f0000174d0ULL, 0x0001890000017500ULL,
0x0001899000018950ULL, 0x000189f0000189c0ULL, 0x00018a6000018a20ULL, 0x00018ae000018aa0ULL,
0x00018b7000018b20ULL, 0x00018c0000018bc0ULL, 0x00018c6000018c30ULL, 0x00018cd000018c90ULL,
0x00018d5000018d10ULL, 0x00018de000018d90ULL, 0x00018e7000018e30ULL, 0x00018ed000018ea0ULL,
0x00018f4000018f00ULL, 0x00018fc000018f80ULL, 0x0001905000019000ULL, 0x000190e0000190a0ULL,
0x0001914000019110ULL, 0x000191b000019170ULL, 0x00019230000191f0ULL, 0x000192c000019270ULL,
0x0001938000019320ULL, 0x00019440000193e0ULL, 0x00019500000194a0ULL, 0x0440390400019560ULL,
0x000000ff000003b0ULL, 0x003f010000012600ULL, 0x0000000b00000430ULL, 0x003f012000012608ULL,
0x0000000b000004f0ULL, 0x003f012000012688ULL, 0x0000000b00000520ULL, 0x003f0120000126a8ULL,
0x0000000b00000550ULL, 0x003f0120000126c8ULL, 0x000000ff00000b10ULL, 0x003f010700012600ULL,
0x0000001400000c70ULL, 0x003f01020001268cULL, 0x0000001400000d00ULL, 0x003f010100012688ULL,
0x000000ff00001630ULL, 0x0004010700000000ULL, 0x000000ff000016b0ULL, 0x0004010100000000ULL,
0x0000000200001710ULL, 0x003f010100000020ULL, 0x0000000c00001880ULL, 0x003f0105000126ccULL,
0x0000000c00001a50ULL, 0x003f0105000126ccULL, 0x0000001f00002270ULL, 0x003f0107000126b0ULL,
0x0000001f00002330ULL, 0x003f0101000126b0ULL, 0x0000001c00002390ULL, 0x003f010100012608ULL,
0x00000023000023d0ULL, 0x003f01050001260cULL, 0x00000023000025b0ULL, 0x003f01050001260cULL,
0x0000001f00002e80ULL, 0x003f0105000126acULL, 0x0000001f00003070ULL, 0x003f0105000126acULL,
0x0000006800004d50ULL, 0x003f010100000000ULL, 0x0000001f00004db0ULL, 0x003f010100012688ULL,
0x0000000d00004de0ULL, 0x003f010500000004ULL, 0x0000000d00004fa0ULL, 0x003f010500000004ULL,
0x00000008000056f0ULL, 0x003f010700000000ULL, 0x00000008000057d0ULL, 0x003f010100000000ULL,
0x0000002300005830ULL, 0x003f010100012628ULL, 0x0000006a00005890ULL, 0x003f01050001262cULL,
0x0000006a00005a60ULL, 0x003f01050001262cULL, 0x0000006a000062f0ULL, 0x003f0105000126b4ULL,
0x0000006a000064c0ULL, 0x003f0105000126b4ULL, 0x0000006a00008120ULL, 0x003f010100000000ULL,
0x0000002600008180ULL, 0x003f010100012690ULL, 0x0000000d000081b0ULL, 0x003f010500000004ULL,
0x0000000d00008370ULL, 0x003f010500000004ULL, 0x000000ff00008af0ULL, 0x0004010700000008ULL,
0x0000006800008b80ULL, 0x003f0101000126b0ULL, 0x0000002300008be0ULL, 0x003f010100012648ULL,
0x0000002300008c40ULL, 0x003f01050001264cULL, 0x0000002300008e10ULL, 0x003f01050001264cULL,
0x00000008000096a0ULL, 0x003f010500000004ULL, 0x0000000800009870ULL, 0x003f010500000004ULL,
0x000000260000b390ULL, 0x003f010100000000ULL, 0x000000200000b3f0ULL, 0x003f010100012698ULL,
0x0000000d0000b420ULL, 0x003f010500000004ULL, 0x0000000d0000b5e0ULL, 0x003f010500000004ULL,
0x000000ff0000bd80ULL, 0x0004010700000000ULL, 0x000000080000be30ULL, 0x003f010100000000ULL,
0x0000000c0000be90ULL, 0x003f010100012668ULL, 0x0000000c0000beb0ULL, 0x003f01050001266cULL,
0x0000000c0000c080ULL, 0x003f01050001266cULL, 0x000000260000c8e0ULL, 0x003f0105000126b4ULL,
0x000000260000cab0ULL, 0x003f0105000126b4ULL, 0x0000000d0000e640ULL, 0x003f010100000000ULL,
0x0000000a0000e6c0ULL, 0x003f010100000000ULL, 0x000000ff00010490ULL, 0x003f010100012600ULL,
0x000000ff00011040ULL, 0x003f010500012604ULL, 0x000000ff00011210ULL, 0x003f010500012604ULL,
0x000000ff00011590ULL, 0x003f010100012600ULL, 0x000000ff000115c0ULL, 0x003f010500012604ULL,
0x000000ff00011780ULL, 0x003f010500012604ULL, 0x0000006a000148c0ULL, 0x003f010100000000ULL,
0x0000006a000149f0ULL, 0x003f010500000004ULL, 0x0000006a00014bc0ULL, 0x003f010500000004ULL,
0x0000006900018760ULL, 0x003f010100000000ULL, 0x00000069000187c0ULL, 0x003f010100000008ULL,
0x0000006900018820ULL, 0x003f010100000010ULL, 0x0000006900018890ULL, 0x003f010100000018ULL,
0x00301c0400053803ULL, 0x0000f8a00000f870ULL, 0x0000fbd00000fa70ULL, 0x0000fe900000fd30ULL,
0x000101500000fff0ULL, 0x000103e0000102e0ULL, 0x000188d0000117e0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL, 0x000000000000025cULL,
0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL, 0x00000000000000ccULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000308ULL,
0x0000001900000002ULL, 0x0000000000000238ULL, 0x0000001900000002ULL, 0x0000000000000173ULL,
0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL, 0x0000000000012700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0010757a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f280000002100ULL,
0x00000000000e7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff1a7819ULL, 0x010fc80000011607ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff1a1a7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000400031b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a1bULL,
0x0000040003007624ULL, 0x000fca00078e0210ULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x000000011b1b0810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x000000011b1b1810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff1baa12ULL, 0x000fc800078e33ffULL, 0x0000001b00007306ULL, 0x000e620000209000ULL,
0x000000ff1b00720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000031b047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603127227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a12ULL, 0x000000001b007224ULL, 0x000fca00078e0206ULL,
0x0000001b0000720cULL, 0x000fe20003f46070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000e6400000e0000ULL, 0x00000000020b7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003fa5270ULL, 0x0000000100002824ULL, 0x000fe200078e0a1bULL,
0x0000000112122810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000001b0000720cULL, 0x000fe40003f66070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL, 0xff317217ff088424ULL, 0x000fe400078e00ffULL,
0x0000000112123810ULL, 0x000fe20007ffe0ffULL, 0x01260002ff00d388ULL, 0x0005e20000000a00ULL,
0x0000001bff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f64070ULL, 0x012400080b008388ULL, 0x0007e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00005a0012187a19ULL, 0x000fe200000006ffULL,
0x000000ffff007224ULL, 0x000fc600078e0a12ULL, 0x012608040b009388ULL, 0x0009e20000008a00ULL,
0x000000001b1b7224ULL, 0x000fe400078e0206ULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x000000201b007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x0000000400087c10ULL, 0x048fe2000fffe1ffULL,
0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x3fffff80ff04a424ULL, 0x010fe200078e00ffULL, 0x0000002008087817ULL, 0x000fe20003800000ULL,
0x7fffff80ff05a424ULL, 0x000fe200078e00ffULL, 0x012688020b00a388ULL, 0x0005e40000008a00ULL,
0x000000ff08197207ULL, 0x000fe20000000000ULL, 0x0000000409087824ULL, 0x002fe200078e021aULL,
0x0126a8040b00a388ULL, 0x000fe40000008a00ULL, 0x000000201900780cULL, 0x000fe20003f05270ULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x0126c8060b00b388ULL, 0x000fe20000008a00ULL,
0x000058000e027a24ULL, 0x004fc800078e02ffULL, 0x0000007502027224ULL, 0x000fe200078e0218ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000819037217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x00000004ff047819ULL, 0x002fc80000011617ULL, 0x00000002040b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0204ULL, 0x000000030400720cULL, 0x080fe20003f06070ULL,
0x0000001017047824ULL, 0x000fe200078e00ffULL, 0x000000030b00720cULL, 0x000fe20003f26070ULL,
0x00000001080c7824ULL, 0x000fe400078e020bULL, 0x0000000100057824ULL, 0x040fe400078e020aULL,
0x00000001000d7824ULL, 0x000fe400078e020cULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x0000000405077c12ULL, 0x000fc4000f8e30ffULL, 0x000000040d0f7c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011605ULL, 0x0000000102077824ULL, 0x040fe200078e0207ULL,
0x00005a00ff087a19ULL, 0x000fe2000001160dULL, 0x00000001020f7824ULL, 0x000fe200078e020fULL,
0x000000f004057812ULL, 0x000fe200078ec0ffULL, 0x0000007506027224ULL, 0x080fe400078e0207ULL,
0x0000007508067224ULL, 0x000fe400078e020fULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000502027212ULL, 0x000fc600078efcffULL,
0x000000010a087824ULL, 0x100fe200078e0217ULL, 0x0000000506057212ULL, 0x000fe200078efcffULL,
0x000000010c0a7824ULL, 0x000fe200078e0217ULL, 0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff00b087812ULL, 0x000fe400078ee208ULL,
0x00005e0005067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000001008057824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000c101c48ULL,
0x00000000060b7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000817087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x00000010080c7824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe40000011603ULL, 0x0000000406077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0x00005a00ff067a19ULL, 0x000fc60000011606ULL,
0x0000000102077824ULL, 0x000fe400078e0207ULL, 0x0000007504027224ULL, 0x080fe400078e0205ULL,
0x0000001017047824ULL, 0x000fe400078e00ffULL, 0x0000007506067224ULL, 0x000fe400078e0207ULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000f0040b7812ULL, 0x000fc600078ec0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000b02027212ULL, 0x000fc600078efcffULL,
0x0000000108057824ULL, 0x100fe200078e0217ULL, 0x0000000b06067212ULL, 0x000fe200078efcffULL,
0x000000010a087824ULL, 0x000fe200078e0217ULL, 0x00005e0002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee208ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000b901c48ULL,
0x00000000060b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000057806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000500027300ULL, 0x000e7000000e0000ULL, 0x0000000500067309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x00000004ff037424ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x004fe400078e0a06ULL, 0x000064000e027625ULL, 0x000fd000078e0003ULL,
0x01260406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01260000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000802167981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x000000ff16057810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff157819ULL, 0x000fce0000011605ULL, 0x0000f7b000008947ULL, 0x000fea0003800000ULL,
0x000000081a147824ULL, 0x000fe400078e00ffULL, 0x00000003ff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01268c0314ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x000000020e007824ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe2000001161aULL,
0x0126880014ff7f8cULL, 0x0007e2000c80043fULL, 0x000000011a117812ULL, 0x000fe200078ec0ffULL,
0x0000590000037624ULL, 0x004fe400078e0210ULL, 0x00000020136e7824ULL, 0x000fc400078e00ffULL,
0x0000000112127824ULL, 0x000fc800078e0203ULL, 0x0000660012007a24ULL, 0x000fe200078e026eULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000006e16037217ULL, 0x008fe20007800000ULL,
0x0000001011027824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc60000011617ULL,
0x0000000103037824ULL, 0x000fe200078e0a6eULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x0000000102067824ULL, 0x002fc600078e0205ULL, 0x0000000203037217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x040fe400078e0217ULL, 0x00000008060c7824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a02ULL, 0x0000000100067824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL, 0x0000000805077810ULL, 0x000fc40007ffe0ffULL,
0x000000030500720cULL, 0x0c0fe40003f66070ULL, 0x0000000c05057810ULL, 0x000fe40007ffe0ffULL,
0x000000030800720cULL, 0x080fe20003f46070ULL, 0x0000000102087824ULL, 0x040fe200078e0208ULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x0000000102077824ULL, 0x040fe200078e0207ULL,
0x000000030500720cULL, 0x000fe20003f06070ULL, 0x00000001020a7824ULL, 0x000fe400078e0205ULL,
0x0000008006027825ULL, 0x000fc800078e00ffULL, 0x0000000100067824ULL, 0x000fe200078e0208ULL,
0x00000070020b7812ULL, 0x000fe200078ef804ULL, 0x0000000108057824ULL, 0x040fe400078e0217ULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x0000000100087824ULL, 0x000fe400078e0207ULL,
0x0000000107097824ULL, 0x040fe400078e0217ULL, 0x0000000807107824ULL, 0x000fc400078e00ffULL,
0x00000001000d7824ULL, 0x000fe200078e020aULL, 0xfffffff80e007812ULL, 0x000fe200078ee205ULL,
0x000000010a027824ULL, 0x000fe200078e0217ULL, 0xfffffff8100e7812ULL, 0x000fe200078ee209ULL,
0x000000080a077824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe40007f9e0ffULL,
0x0000e00013057811ULL, 0x000fe400078e68ffULL, 0xfffffff807107812ULL, 0x000fe400078ee202ULL,
0x00006300030b7a10ULL, 0x000fe200027fe4ffULL, 0x0000008006027825ULL, 0x000fc800078e00ffULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x0000007002027812ULL, 0x000fc600078ef804ULL,
0x000000800d087825ULL, 0x000fe200078e00ffULL, 0x0000620002027a10ULL, 0x000fc60007f9e0ffULL,
0x00000010000f7824ULL, 0x100fe200078e0205ULL, 0x0000007006007812ULL, 0x100fe200078ef804ULL,
0x000000100c0d7824ULL, 0x100fe200078e0205ULL, 0x0000007008067812ULL, 0x000fe200078ef804ULL,
0x000000100e1d7824ULL, 0x100fe200078e0205ULL, 0x0000620000047a10ULL, 0x000fe20007fbe0ffULL,
0x00000010101f7824ULL, 0x000fe200078e0205ULL, 0x0000620006067a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000d901c48ULL,
0x0000630003037a10ULL, 0x000fe400027fe4ffULL, 0x0000630007057a10ULL, 0x000fc40002ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200037fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000d101c48ULL,
0x00000000041d7faeULL, 0x0003e8000c901c48ULL, 0x00000000061f7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011027824ULL, 0x008fe200078e00ffULL,
0x0000e000131f7811ULL, 0x000fc800078e68ffULL, 0x0000000217027211ULL, 0x000fc800078fe8ffULL,
0x0000000402067810ULL, 0x002fe20007ffe0ffULL, 0x0000000100037824ULL, 0x000fe200078e0202ULL,
0x0000000802097810ULL, 0x040fe20007ffe0ffULL, 0x0000000102057824ULL, 0x040fe200078e0217ULL,
0x0000000c020a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000802087824ULL, 0x000fe400078e00ffULL,
0x0000008003027825ULL, 0x000fc600078e00ffULL, 0xfffffff808057812ULL, 0x000fe200078ee205ULL,
0x0000000100077824ULL, 0x000fe400078e0206ULL, 0x0000000106087824ULL, 0x040fe400078e0217ULL,
0x00000008060f7824ULL, 0x000fe400078e00ffULL, 0x0000000100067824ULL, 0x040fe400078e0209ULL,
0x00000001000d7824ULL, 0x000fe200078e020aULL, 0x0000007002007812ULL, 0x000fe200078ef804ULL,
0x00000001090b7824ULL, 0x000fc400078e0217ULL, 0x00000008090c7824ULL, 0x000fe400078e00ffULL,
0x000000010a027824ULL, 0x040fe400078e0217ULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0x00006200000a7a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee20bULL,
0xfffffff8090e7812ULL, 0x000fe400078ee202ULL, 0x00006300030b7a10ULL, 0x000fe200007fe4ffULL,
0x0000008007027825ULL, 0x000fe200078e00ffULL, 0xfffffff80f007812ULL, 0x000fc600078ee208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000007002027812ULL, 0x000fc600078ef804ULL,
0x000000800d087825ULL, 0x000fe200078e00ffULL, 0x0000620002027a10ULL, 0x000fc60007f1e0ffULL,
0x00000010050d7824ULL, 0x100fe200078e021fULL, 0x0000007006057812ULL, 0x100fe200078ef804ULL,
0x00000010000f7824ULL, 0x100fe200078e021fULL, 0x0000007008067812ULL, 0x000fe200078ef804ULL,
0x000000100c1d7824ULL, 0x100fe200078e021fULL, 0x0000620005047a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e1f7824ULL, 0x000fe200078e021fULL, 0x0000620006067a10ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c48ULL,
0x0000630003037a10ULL, 0x000fe400007fe4ffULL, 0x0000630007057a10ULL, 0x000fc40000ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200017fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000b901c48ULL,
0x00000000041d7faeULL, 0x0003e8000b901c48ULL, 0x00000000061f7faeULL, 0x0003e4000b901c48ULL,
0x00000000130473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000126a813027811ULL, 0x002fe200078e18ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x000126a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x000000ffff557224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff6c7f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000cf4000008947ULL, 0x000fea0003800000ULL,
0x00000010130e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff107819ULL, 0x000fe2000001161aULL,
0x000000ffff007224ULL, 0x004fc400078e0003ULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x000000100e0e7812ULL, 0x000fe200078ee2ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff1c7224ULL, 0x00afca00078e00ffULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x000000041a0a7824ULL, 0x000fca00078e00ffULL,
0xfffffff80a0c7812ULL, 0x000fc800078ec0ffULL, 0x000126c80c0d7810ULL, 0x000fe20007ffe0ffULL,
0x0126cc000c0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000001d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc000c0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f007810ULL, 0x040fe20007ffe0ffULL,
0x000001000f0c7824ULL, 0x000fc600078e026eULL, 0x000000150000720cULL, 0x000fe40003f46070ULL,
0x000000400c037810ULL, 0x000fca0007ffe0ffULL, 0x00006600121f7a24ULL, 0x000fcc00078e0203ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x00000003ff0a7819ULL, 0x000fe20000011617ULL,
0x00000010110b7824ULL, 0x000fe200078e00ffULL, 0x0000000316007217ULL, 0x000fe40007800000ULL,
0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b027824ULL, 0x040fe200078e020aULL,
0x0000000c0a247810ULL, 0x000fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x00000001021c7824ULL, 0x040fe400078e0217ULL, 0x0000000802237824ULL, 0x000fe200078e00ffULL,
0x000000000b007217ULL, 0x000fe20007800000ULL, 0x0000001017037824ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e021fULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b207824ULL, 0x000fe200078e021dULL, 0x0000007003217812ULL, 0x000fe200078ec0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x000000000a00720cULL, 0x080fe40003fa6070ULL,
0x000000001c00720cULL, 0x080fe20003f86070ULL, 0x000000010b1e7824ULL, 0x040fe200078e021cULL,
0x00000021021c7212ULL, 0x000fe200078efcffULL, 0x000000010b267824ULL, 0x000fe200078e0224ULL,
0x000000001d00720cULL, 0x080fe20003f66070ULL, 0x000000011e0a7824ULL, 0x000fe200078e021fULL,
0x000000002400720cULL, 0x000fe20003f06070ULL, 0x000000011e007824ULL, 0x000fe200078e0217ULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x00006300031d7a10ULL, 0x000fe200037fe4ffULL, 0x000000081e257824ULL, 0x000fe200078e00ffULL,
0x000000210a1e7212ULL, 0x080fe200078efcffULL, 0x0000000120027824ULL, 0x100fe400078e021fULL,
0x00000001260a7824ULL, 0x000fe200078e021fULL, 0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe400078ee200ULL,
0x000063000b1f7a10ULL, 0x000fe200037fe4ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002102027212ULL, 0x000fc400078efcffULL, 0x0000f00013007811ULL, 0x000fe200078e68ffULL,
0x0000000120247824ULL, 0x100fe200078e0217ULL, 0x0000620002027a10ULL, 0x000fe20007fde0ffULL,
0x0000000820277824ULL, 0x000fe200078e00ffULL, 0x000000210a0a7212ULL, 0x000fe200078efcffULL,
0x0000000126207824ULL, 0x040fe200078e0217ULL, 0x0000630003037a10ULL, 0x000fe200037fe4ffULL,
0x0000000826697824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee224ULL,
0x0000001023217824ULL, 0x100fe200078e0200ULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001025237824ULL, 0x000fe200078e0200ULL, 0xfffffff869697812ULL, 0x000fe200078ee220ULL,
0x0000001027257824ULL, 0x100fe200078e0200ULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0005e4000e901c48ULL,
0x0000001069277824ULL, 0x000fc400078e0200ULL, 0x000000001e237faeULL, 0x0005e8000e101c48ULL,
0x0000000002257faeULL, 0x0005e8000d901c48ULL, 0x000000000a277faeULL, 0x0005e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001011007824ULL, 0x000fe400078e00ffULL,
0x0000001017027824ULL, 0x000fc600078e00ffULL, 0x0000000017007211ULL, 0x000fe400078fe8ffULL,
0x0000007002257812ULL, 0x000fe400078ec0ffULL, 0x0000000c00247810ULL, 0x040fe20007ffe0ffULL,
0x0000000100037824ULL, 0x040fe200078e0217ULL, 0x0000000800207810ULL, 0x040fe20007ffe0ffULL,
0x00000008000a7824ULL, 0x040fe400078e00ffULL, 0x0000000100027824ULL, 0x000fe400078e021fULL,
0x0000000824697824ULL, 0x000fe200078e00ffULL, 0xfffffff80a217812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x00000004000a7810ULL, 0x000fc60007ffe0ffULL,
0x00000001201d7824ULL, 0x000fe200078e0217ULL, 0x00000025021e7212ULL, 0x000fe200078efcffULL,
0x000000010a007824ULL, 0x040fe400078e021fULL, 0x000000010a0b7824ULL, 0x100fe200078e0217ULL,
0x000062001e1e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000080a267824ULL, 0x000fe400078e00ffULL,
0x0000000124027824ULL, 0x000fe400078e0217ULL, 0x00000001200a7824ULL, 0x000fe200078e021fULL,
0xfffffff826237812ULL, 0x000fe200078ee20bULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee202ULL, 0x00000001241c7824ULL, 0x000fe200078e021fULL,
0x00006300031f7a10ULL, 0x000fe200007fe4ffULL, 0x0000008000027825ULL, 0x000fe200078e00ffULL,
0xfffffff820277812ULL, 0x000fc400078ee21dULL, 0x0000f00013207811ULL, 0x000fe200078e68ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002502027212ULL, 0x000fc600078efcffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000250a0a7212ULL, 0x080fe400078efcffULL,
0x0000620002027a10ULL, 0x000fe20007f1e0ffULL, 0x0000001021217824ULL, 0x100fe200078e0220ULL,
0x000000251c1c7212ULL, 0x000fe200078efcffULL, 0x0000001023237824ULL, 0x100fe200078e0220ULL,
0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001027257824ULL, 0x100fe200078e0220ULL,
0x000062001c1c7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001069277824ULL, 0x000fe200078e0220ULL,
0x0000630003037a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e217faeULL, 0x0005e2000b901c48ULL, 0x000063000b0b7a10ULL, 0x000fc40001ffe4ffULL,
0x000063001d1d7a10ULL, 0x000fe200027fe4ffULL, 0x0000000002237faeULL, 0x0005e8000b901c48ULL,
0x000000000a257faeULL, 0x0005e8000b901c48ULL, 0x000000001c277faeULL, 0x0005e4000b901c48ULL,
0xfffffff0141f7812ULL, 0x044fe400078ec0ffULL, 0xffffffe014007812ULL, 0x000fc400078ec0ffULL,
0x000000001f0573c2ULL, 0x000ea200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001014037812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fc800078e0203ULL,
0x00000008111c7824ULL, 0x000fe200078e0200ULL, 0x000126b005057890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126b0001f207f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012608001c1c7f8cULL, 0x000ea4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x00000008140b7812ULL, 0x000fca00078ec0ffULL,
0x0000000100237824ULL, 0x000fca00078e020bULL, 0x01260c00230b7984ULL, 0x000f240000000800ULL,
0x800000000bff7812ULL, 0x014fe4000780481dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a02257210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140bULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000200007819ULL, 0x000fc8000000120bULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01260c00230b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010170b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x000000201a007824ULL, 0x000fe400078e00ffULL,
0xffffffffff6f7424ULL, 0x000fe200078e00ffULL, 0x000000700b0b7812ULL, 0x000fc400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000000a007210ULL, 0x000fca0007ffe00bULL, 0x0120000000037984ULL, 0x000ea80000000800ULL,
0x0122000000027984ULL, 0x0006620000000800ULL, 0x000000080300720bULL, 0x004fe20003f1d000ULL,
0x000162127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800000e0100ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x0000001fff777424ULL, 0x000fe400078e00ffULL, 0xffffffffff747424ULL, 0x000fca00078e00ffULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x0000001a1000720cULL, 0x000fe40003f05270ULL,
0x000000080300720bULL, 0x000fe20003f74000ULL, 0x000161b27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x00000008031e7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x0124001e25008388ULL, 0x0005e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x000000081e087221ULL, 0x004fe20000010100ULL, 0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x0000000800277308ULL, 0x000ea40000000800ULL, 0x0000002722227220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000160f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x00015fb27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x00015e727f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x00015d427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000001d00ff7212ULL, 0x000fda00078030ffULL,
0x8000001e03030221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x0000000300090308ULL, 0x000ea40000000800ULL,
0x0000000902020220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002202227221ULL, 0x002fc40000010000ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x0126ac001f007984ULL, 0x000e620000000800ULL, 0x000126a81f087810ULL, 0x000fe40007ffe0ffULL,
0x8000000000ff7812ULL, 0x002fe2000780486dULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c02257210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001141dULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x0000000200007819ULL, 0x000fc8000000121dULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126ac001f007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991024007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff027819ULL, 0x000fe40000011617ULL, 0x0000541000277816ULL, 0x000fe20000000000ULL,
0x000158f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0227077589ULL, 0x0002a400000e0000ULL,
0x0000000802267810ULL, 0x000fe20007ffe0ffULL, 0x000159127f007947ULL, 0x000fea000b800000ULL,
0x0000001002007810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0027057589ULL, 0x0006a400000e0000ULL, 0x0000001802267810ULL, 0x008fe20007ffe0ffULL,
0x000159427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004136c7824ULL, 0x000fe200078e00ffULL,
0x0000000817007812ULL, 0x000fe200078ec0ffULL, 0x000004001a1d7824ULL, 0x000fe200078e00ffULL,
0x00000004ff767819ULL, 0x100fe20000011617ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000046c6c7812ULL, 0x000fe200078ec0ffULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000000700037812ULL, 0x000fc400078ef817ULL, 0x0000006c17007211ULL, 0x000fe400078fe0ffULL,
0x0000001003027812ULL, 0x042fe200078efcffULL, 0x00000008031f7824ULL, 0x000fe200078e00ffULL,
0xfffff0001d1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001031c7824ULL, 0x000fe400078e0200ULL,
0x0000000100007824ULL, 0x000fe200078e0202ULL, 0x0000a0001d6d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000802257824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x00000004111f7824ULL, 0x000fc400078e0276ULL, 0x0000000803277824ULL, 0x008fe200078e00ffULL,
0xfffffff8251d7812ULL, 0x000fe200078ee200ULL, 0x0000000103787824ULL, 0x000fe200078e021fULL,
0x0000e00013007811ULL, 0x000fe200078e68ffULL, 0x000000101c687824ULL, 0x100fe400078e026dULL,
0x000000101d247824ULL, 0x000fe200078e026dULL, 0xfffffff827257812ULL, 0x000fc600078ee278ULL,
0x000000006868783bULL, 0x000e640000000200ULL, 0x0000001025707824ULL, 0x000fe400078e0200ULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000768687231ULL, 0x086fe400003400ffULL, 0x000000076a6a7231ULL, 0x000fe400003400ffULL,
0x0000000669697231ULL, 0x080fe400003400ffULL, 0x000000066b6b7231ULL, 0x000fc400003400ffULL,
0x0000000524247231ULL, 0x088fe400003400ffULL, 0x0000000526267231ULL, 0x000fe400003400ffULL,
0x0000000425257231ULL, 0x080fe400003400ffULL, 0x0000000427277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000803797824ULL, 0x000fe200078e00ffULL,
0x0000000278787810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000f220000004200ULL,
0x00000001021f7824ULL, 0x000fe200078e021fULL, 0x00000cd000007945ULL, 0x000fe20003800000ULL,
0xfffffff879797812ULL, 0x000fca00078ee278ULL, 0x0000001079797824ULL, 0x000fcc00078e0200ULL,
0x000000007978783bULL, 0x000ee20000004200ULL, 0x00000010ff7d7819ULL, 0x110fe40000011670ULL,
0x000000ff707e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011670ULL,
0x0000ffff70947812ULL, 0x000fe400078ec0ffULL, 0x000000ff71707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x000fc40000011671ULL, 0x00000018ff807819ULL, 0x000fe40000011671ULL,
0x0000ffff71957812ULL, 0x000fe400078ec0ffULL, 0x00000070ff71723eULL, 0x000fe400020006ffULL,
0x0000007cff70723eULL, 0x000fe400020006ffULL, 0x00000018ff8c7819ULL, 0x008fe40000011679ULL,
0x00000010ff827819ULL, 0x000fc40000011672ULL, 0x000000ff72837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe40000011672ULL, 0x0000ffff72967812ULL, 0x000fe400078ec0ffULL,
0x00000010ff857819ULL, 0x100fe40000011673ULL, 0x000000ff73847812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fc40000011673ULL, 0x0000ffff73977812ULL, 0x000fe200078ec0ffULL,
0x20000070ff737230ULL, 0x000fe20000004100ULL, 0x0000008cff70723eULL, 0x000fe400020006ffULL,
0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe20000011678ULL,
0x20000070ff907230ULL, 0x000fe20000004100ULL, 0x0000007dff70723eULL, 0x000fe400020006ffULL,
0x000000ff788a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff897819ULL, 0x000fe40000011678ULL,
0x0000ffff78987812ULL, 0x000fe200078ec0ffULL, 0x20000071ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe20000011679ULL, 0x20000070ff717230ULL, 0x000fe20000004100ULL,
0x000000ff798d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff79997812ULL, 0x000fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fc4000001167aULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000008ff707819ULL, 0x000fe40000011694ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000072ff887230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000008ff727819ULL, 0x000fe40000011695ULL, 0x00000070ff70723eULL, 0x000fc400020006ffULL,
0x00000010ff917819ULL, 0x000fe4000001167aULL, 0x000000ff7a8e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7a9a7812ULL, 0x000fe200078ec0ffULL, 0x20000080ff7a7230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x20000079ff807230ULL, 0x000fe20000004100ULL,
0x00000072ff79723eULL, 0x000fe200020006ffULL, 0x20000070ff727230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff82827812ULL, 0x000fe200078ec0ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x000fc40000011697ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x20000089ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff87877812ULL, 0x000fe200078ec0ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000018ff8f7819ULL, 0x000fc4000001167bULL,
0x000000ff85857812ULL, 0x000fe400078ec0ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000087ff89723eULL, 0x000fe200020006ffULL, 0x20000070ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe20000011673ULL, 0x20000084ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fc400020006ffULL, 0x00000010ff927819ULL, 0x000fe4000001167bULL,
0x000000ff7b937812ULL, 0x040fe200078ec0ffULL, 0x20000081ff847230ULL, 0x000fe20000004100ULL,
0x0000ffff7b7c7812ULL, 0x000fe400078ec0ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe4000001167eULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff7b7819ULL, 0x000fc40000011696ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x2000008fff7d7230ULL, 0x000fe20000004100ULL,
0x00000008ff7e7819ULL, 0x000fe4000001169aULL, 0x000000ff91917812ULL, 0x000fe200078ec0ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x0000105473727816ULL, 0x000fe40000000072ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff737819ULL, 0x000fc40000011679ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff797819ULL, 0x000fe40000011682ULL, 0x0000008eff81723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000007eff82723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x000000ff8b8e7812ULL, 0x000fe200078ec0ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000008ff8b7819ULL, 0x000fe40000011698ULL, 0x00000008ff8f7819ULL, 0x000fe20000011699ULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x0000105471707816ULL, 0x000fe40000000070ULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001167cULL,
0x000010547f717816ULL, 0x000fc40000000078ULL, 0x00000010ff7f7819ULL, 0x000fe20000011684ULL,
0x20000082ff847230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x000000706864723cULL, 0x002f620000041864ULL,
0x00000010ff787819ULL, 0x000fe20000011683ULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000093ff93723eULL, 0x000fc400020006ffULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fe20000011686ULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x000000702444723cULL, 0x000f620000041844ULL,
0x0000007cff82723eULL, 0x000fc400020006ffULL, 0x000010547a737816ULL, 0x000fe20000000073ULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x0000105479787816ULL, 0x000fe40000000078ULL,
0x0000105485797816ULL, 0x000fe20000000086ULL, 0x20000082ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe2000001167bULL, 0x000000726860723cULL, 0x000f620000041860ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff7c7819ULL, 0x000fc40000011691ULL,
0x000010547f7a7816ULL, 0x000fe4000000007aULL, 0x00000010ff7f7819ULL, 0x000fe2000001168dULL,
0x00000078685c723cULL, 0x000f62000004185cULL, 0x000010547c827816ULL, 0x000fe40000000081ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff7b7819ULL, 0x000fe40000011687ULL,
0x00000010ff7e7819ULL, 0x000fe2000001168aULL, 0x000000722440723cULL, 0x000f620000041840ULL,
0x00000010ff897819ULL, 0x000fc40000011689ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff8b7819ULL, 0x000fe2000001168bULL,
0x00000078243c723cULL, 0x000f62000004183cULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff8d7819ULL, 0x000fe4000001168fULL, 0x00000010ff837819ULL, 0x000fc40000011693ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff817819ULL, 0x000fe40000011680ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167dULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00001054887b7816ULL, 0x000fc4000000007bULL,
0x00001054897e7816ULL, 0x000fe4000000007eULL, 0x000010548e7f7816ULL, 0x000fe4000000007fULL,
0x000010548c8c7816ULL, 0x000fe2000000008bULL, 0x0000007a6858723cULL, 0x000f620000041858ULL,
0x00001054908d7816ULL, 0x000fe4000000008dULL, 0x0000105492837816ULL, 0x000fe40000000083ULL,
0x0000105481847816ULL, 0x000fc40000000084ULL, 0x000010547c857816ULL, 0x000fe20000000085ULL,
0x0000007e6854723cULL, 0x040f700000041854ULL, 0x0000008c6850723cULL, 0x040f700000041850ULL,
0x00000082684c723cULL, 0x040f70000004184cULL, 0x000000846848723cULL, 0x000b6e0000041848ULL,
0x000000026c697812ULL, 0x020fe200078efcffULL, 0x00000008036b7824ULL, 0x000fe200078e00ffULL,
0x0000007a2438723cULL, 0x000f620000041838ULL, 0x00000008026a7824ULL, 0x000fc400078e00ffULL,
0x0000000176697824ULL, 0x000fe400078e0269ULL, 0x00000008026c7824ULL, 0x040fe400078e00ffULL,
0x0000000103687824ULL, 0x100fe200078e0269ULL, 0x0000007e2434723cULL, 0x000f620000041834ULL,
0x0000000102697824ULL, 0x000fc600078e0269ULL, 0xfffffff86b687812ULL, 0x000fe400078ee268ULL,
0xfffffff86a6a7812ULL, 0x000fe400078ee269ULL, 0xfffffff86c697812ULL, 0x000fe200078ee21fULL,
0x0000001068687824ULL, 0x100fe200078e026dULL, 0x0000008c2430723cULL, 0x040f620000041830ULL,
0x000000106a6d7824ULL, 0x000fe400078e026dULL, 0x0000001069707824ULL, 0x000fe400078e0200ULL,
0x000000006868783bULL, 0x000e660000000200ULL, 0x00000082242c723cULL, 0x040f70000004182cULL,
0x000000842428723cULL, 0x000b640000041828ULL, 0x000000006d24783bULL, 0x0206a20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000768687231ULL, 0x086fe400003400ffULL, 0x000000076a6a7231ULL, 0x000fc400003400ffULL,
0x0000000669697231ULL, 0x080fe400003400ffULL, 0x000000066b6b7231ULL, 0x000fe400003400ffULL,
0x0000000524247231ULL, 0x080fe400003400ffULL, 0x0000000526267231ULL, 0x000fe400003400ffULL,
0x0000000425257231ULL, 0x080fe400003400ffULL, 0x0000000427277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008026c7824ULL, 0x000fe200078e00ffULL,
0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000f260000004200ULL,
0xfffffff86c1f7812ULL, 0x000fca00078ee21fULL, 0x000000101f1f7824ULL, 0x000fca00078e0200ULL,
0x000000001f78783bULL, 0x0006a20000004200ULL, 0x00000010ff6c7819ULL, 0x110fe40000011670ULL,
0x000000ff70767812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x008fe40000011670ULL,
0x0000ffff70917812ULL, 0x000fe400078ec0ffULL, 0x00000018ff707819ULL, 0x000fe40000011671ULL,
0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7c7819ULL, 0x000fe40000011671ULL,
0x000000ff717d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff71927812ULL, 0x000fe400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000018ff717819ULL, 0x000fe40000011672ULL,
0x0000006dff1f723eULL, 0x000fc400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff817819ULL, 0x100fe40000011673ULL, 0x000000ff73827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe40000011673ULL, 0x0000ffff73947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x004fc40000011678ULL, 0x000000ff78857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff737819ULL, 0x000fe40000011678ULL, 0x0000ffff78957812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x100fe40000011679ULL, 0x000000ff79877812ULL, 0x000fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fc40000011679ULL, 0x0000ffff79967812ULL, 0x000fe200078ec0ffULL,
0x20000070ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe20000011672ULL,
0x2000006cff707230ULL, 0x000fe20000004100ULL, 0x000000ff727f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff72937812ULL, 0x000fe200078ec0ffULL, 0x2000001fff727230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000080ff1f723eULL, 0x000fc400020006ffULL,
0x00000008ff6c7819ULL, 0x000fe20000011691ULL, 0x20000071ff807230ULL, 0x000fe20000004100ULL,
0x000000ff7a887812ULL, 0x000fe200078ec0ffULL, 0x2000001fff847230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000008ff717819ULL, 0x000fe40000011692ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000088ff1f723eULL, 0x000fe200020006ffULL,
0x20000073ff887230ULL, 0x000fe20000004100ULL, 0x00000071ff73723eULL, 0x000fe200020006ffULL,
0x2000006cff717230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000001fff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff6c7819ULL, 0x000fc40000011694ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x20000087ff897230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x000000ff7b8b7812ULL, 0x000fe200078ec0ffULL,
0x20000078ff8c7230ULL, 0x000fe20000004100ULL, 0x00000018ff8a7819ULL, 0x000fe2000001167aULL,
0x20000076ff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x20000073ff787230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x000000ff86877812ULL, 0x000fe400078ec0ffULL, 0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff867819ULL, 0x000fe40000011695ULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000010ff8d7819ULL, 0x000fe4000001167aULL, 0x0000ffff7a977812ULL, 0x000fe200078ec0ffULL,
0x2000008bff907230ULL, 0x000fe20000004100ULL, 0x0000008aff76723eULL, 0x000fc400020006ffULL,
0x00000083ff73723eULL, 0x000fe200020006ffULL, 0x2000006cff837230ULL, 0x000fe20000004100ULL,
0x00000018ff7a7819ULL, 0x000fe2000001167bULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x000000ff81817812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8a7819ULL, 0x000fe40000011696ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fc400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000086ff6c723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x0000007aff1f723eULL, 0x000fe200020006ffULL,
0x20000073ff867230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000008aff8b723eULL, 0x000fe200020006ffULL,
0x20000087ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe20000011693ULL,
0x2000006cff877230ULL, 0x000fe20000004100ULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fe2000001166dULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe20000011670ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x00000010ff737819ULL, 0x000fe40000011672ULL, 0x00000010ff707819ULL, 0x000fe20000011671ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fc4000001167bULL,
0x0000ffff7b7b7812ULL, 0x000fe400078ec0ffULL, 0x0000105473707816ULL, 0x000fe40000000070ULL,
0x00000010ff717819ULL, 0x000fe40000011678ULL, 0x000010546d6c7816ULL, 0x000fe4000000006cULL,
0x00000010ff737819ULL, 0x000fe40000011682ULL, 0x00000010ff787819ULL, 0x000fc40000011681ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x000010547c6d7816ULL, 0x000fe4000000007dULL,
0x00000008ff7c7819ULL, 0x000fe20000011697ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x0000006c2444723cULL, 0x000f620000041844ULL, 0x00000008ff7b7819ULL, 0x000fc4000001167bULL,
0x0000105478737816ULL, 0x000fe40000000073ULL, 0x00000010ff787819ULL, 0x000fe4000001167aULL,
0x00000010ff727819ULL, 0x000fe20000011679ULL, 0x0000006c6864723cULL, 0x002f620000041864ULL,
0x0000007cff7a723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000105472717816ULL, 0x000fe40000000071ULL, 0x000010547e727816ULL, 0x000fe2000000007fULL,
0x2000008fff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe20000011685ULL,
0x2000007bff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fe20000011686ULL,
0x000000702440723cULL, 0x000f620000041840ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x000010547d7c7816ULL, 0x000fe4000000007cULL,
0x00000010ff797819ULL, 0x000fe20000011680ULL, 0x00000072243c723cULL, 0x000f62000004183cULL,
0x000010548a7d7816ULL, 0x000fe40000000089ULL, 0x00000010ff7b7819ULL, 0x000fe40000011676ULL,
0x00000010ff7a7819ULL, 0x000fc4000001167aULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x0000007c2434723cULL, 0x000f620000041834ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff8c7819ULL, 0x000fe2000001168cULL, 0x000000706860723cULL, 0x000f620000041860ULL,
0x00000010ff897819ULL, 0x000fc4000001168bULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff8f7819ULL, 0x000fe20000011690ULL,
0x00000072685c723cULL, 0x000f62000004185cULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff767819ULL, 0x000fe2000001161fULL, 0x000000021a1f7824ULL, 0x000fe200078e00ffULL,
0x00000010ff7f7819ULL, 0x000fc4000001167fULL, 0x0000105479787816ULL, 0x000fe20000000078ULL,
0x0000007c6854723cULL, 0x000f620000041854ULL, 0x000010547b7a7816ULL, 0x000fe4000000007aULL,
0x0000105484797816ULL, 0x000fe40000000083ULL, 0x0000105488887816ULL, 0x000fe40000000087ULL,
0x000010548c897816ULL, 0x000fe40000000089ULL, 0x000010548d8e7816ULL, 0x000fe2000000008eULL,
0x000000782438723cULL, 0x000f620000041838ULL, 0x000010547e8f7816ULL, 0x000fc4000000008fULL,
0x00001054767b7816ULL, 0x000fe4000000007fULL, 0xfffffff81f1f7812ULL, 0x000fc600078ec0ffULL,
0x000000882430723cULL, 0x040f700000041830ULL, 0x0000008e242c723cULL, 0x040f70000004182cULL,
0x0000007a2428723cULL, 0x000f700000041828ULL, 0x000000786858723cULL, 0x040f700000041858ULL,
0x000000886850723cULL, 0x040f700000041850ULL, 0x0000008e684c723cULL, 0x040f70000004184cULL,
0x0000007a6848723cULL, 0x000b6e0000041848ULL, 0x000126c813687811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000068687f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012688001fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6a7224ULL, 0x000fc600078e00ffULL, 0x0000000000247805ULL, 0x000fc80000015200ULL,
0x000004000d1f7984ULL, 0x004ea40000000800ULL, 0x800000001fff7812ULL, 0x006fc40007804869ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000800c257810ULL, 0x000fca0007ffe0ffULL,
0x00006600126c7a24ULL, 0x000fe200078e0225ULL, 0x000003d00000a947ULL, 0x000fea0003800000ULL,
0x00000025161f7217ULL, 0x000fe20007800000ULL, 0x0000001011707824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x000fc60000011617ULL, 0x000000011f1f7824ULL, 0x000fe200078e0a25ULL,
0x0000000427697810ULL, 0x040fe20007ffe0ffULL, 0x0000000170247824ULL, 0x040fe200078e0227ULL,
0x00000008276b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001f701f7217ULL, 0x000fe20007800000ULL,
0x0000000124257824ULL, 0x040fe200078e0217ULL, 0x0000000c27737810ULL, 0x000fe20007ffe0ffULL,
0x0000000824267824ULL, 0x000fe400078e00ffULL, 0x0000000170717824ULL, 0x000fc400078e0269ULL,
0x0000000124247824ULL, 0x000fe200078e026cULL, 0xfffffff8266d7812ULL, 0x000fe200078ee225ULL,
0x000000011f1f7824ULL, 0x000fe400078e0a70ULL, 0x0000000171267824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000001f2700720cULL, 0x080fe40003f06070ULL,
0x0000001f6900720cULL, 0x000fe20003f86070ULL, 0x0000000170727824ULL, 0x000fe200078e026bULL,
0x0000000b246a7212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000001f6b00720cULL, 0x000fc40003f66070ULL, 0x000062006a6a7a10ULL, 0x000fe20007fbe0ffULL,
0x0000000170707824ULL, 0x000fe200078e0273ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x0000000172687824ULL, 0x100fe200078e026cULL, 0x00006300256b7a10ULL, 0x000fe20002ffe4ffULL,
0x0000000170247824ULL, 0x000fe200078e026cULL, 0x0000620026267a10ULL, 0x000fe20007fde0ffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x0000001f7300720cULL, 0x000fe40003fa6070ULL,
0x0000630027277a10ULL, 0x000fe200037fe4ffULL, 0x00000001716c7824ULL, 0x040fe200078e0217ULL,
0x0000000b68687212ULL, 0x000fe200078efcffULL, 0x0000000871717824ULL, 0x000fc400078e00ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000620068687a10ULL, 0x000fe40007fde0ffULL,
0xfffffff8711f7812ULL, 0x000fe200078ee26cULL, 0x00000001726c7824ULL, 0x100fe200078e0217ULL,
0x0000000b24247212ULL, 0x000fe200078efcffULL, 0x0000000872717824ULL, 0x000fe200078e00ffULL,
0x0000630069697a10ULL, 0x000fe200037fe4ffULL, 0x0000000170727824ULL, 0x000fe200078e0217ULL,
0x0000620024247a10ULL, 0x000fe20007fde0ffULL, 0x0000000870737824ULL, 0x000fe200078e00ffULL,
0xfffffff871717812ULL, 0x000fe200078ee26cULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x0000630025257a10ULL, 0x000fe200037fe4ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0xfffffff873737812ULL, 0x000fe200078ee272ULL, 0x0000001071717824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a6d7faeULL, 0x0003e6000c101c48ULL,
0x0000001073737824ULL, 0x000fe200078e0200ULL, 0x00000000261f7faeULL, 0x0003e8000e101c48ULL,
0x0000000068717faeULL, 0x0003e8000d901c48ULL, 0x0000000024737faeULL, 0x0003e2000e901c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001011247824ULL, 0x000fca00078e00ffULL,
0x00000024171f7211ULL, 0x000fc800078fe8ffULL, 0x000000041f267810ULL, 0x040fe20007ffe0ffULL,
0x000000011f247824ULL, 0x140fe200078e0217ULL, 0x000000081f687810ULL, 0x040fe20007ffe0ffULL,
0x000000081f6d7824ULL, 0x000fe400078e00ffULL, 0x0000000126257824ULL, 0x140fe400078e0217ULL,
0x00000008266a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee224ULL,
0x000000011f247824ULL, 0x040fe200078e026cULL, 0x0000000c1f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000168277824ULL, 0x000fe200078e0217ULL, 0xfffffff86a717812ULL, 0x000fe200078ee225ULL,
0x0000000868707824ULL, 0x000fc400078e00ffULL, 0x0000000126267824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0xfffffff870737812ULL, 0x000fc600078ee227ULL,
0x0000000168687824ULL, 0x100fe200078e026cULL, 0x0000000b24247212ULL, 0x000fe200078efcffULL,
0x000000011f6a7824ULL, 0x000fe400078e026cULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620024247a10ULL, 0x000fc60007f1e0ffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000630025257a10ULL, 0x000fe200007fe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b68687212ULL, 0x080fe400078efcffULL,
0x0000620026267a10ULL, 0x000fe20007f7e0ffULL, 0x000000011f6c7824ULL, 0x040fe200078e0217ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000620068687a10ULL, 0x000fe20007f1e0ffULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee26cULL, 0x0000001073737824ULL, 0x100fe200078e0200ULL,
0x0000630027277a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000246d7faeULL, 0x0003e2000b901c48ULL, 0x0000630069697a10ULL, 0x000fe200007fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026717faeULL, 0x0003e8000b901c48ULL, 0x0000000068737faeULL, 0x0003e8000b901c48ULL,
0x000000006a1f7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000080503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126280023687f8cULL, 0x000664000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL,
0x0000001014267812ULL, 0x000fca00078ec0ffULL, 0x000000011f267824ULL, 0x000fc800078e0226ULL,
0x00000008116a7824ULL, 0x000fca00078e0226ULL, 0x01262c006a1f7984ULL, 0x000f240000000800ULL,
0x800000001fff7812ULL, 0x012fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016b6b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01262c006a1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a1f7824ULL, 0x000fca00078e00ffULL,
0xffffff801f247812ULL, 0x000fc800078ec0ffULL, 0x000000800b1f7810ULL, 0x000fca0007ffe024ULL,
0x000000010a1f7824ULL, 0x000fca00078e021fULL, 0x012000001f697984ULL, 0x000e680000000800ULL,
0x012200001f687984ULL, 0x0006a20000000800ULL, 0x0000001e6900720bULL, 0x002fe20003f1d000ULL,
0x000130227f007947ULL, 0x000fd8000b800000ULL, 0x00000000001f7806ULL, 0x008fc800000e0100ULL,
0x000000ff1f00720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e001eULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000110257810ULL, 0x000fe40007ffe0ffULL,
0x0000001e6900720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x00012fd27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000707806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x0000001e69247209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x0124002425008388ULL, 0x0003e20000000800ULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001e241e7221ULL, 0x002fe20000010100ULL,
0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e00277308ULL, 0x000e640000000800ULL,
0x0000002722227220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x00012f127f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x00012dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00066400000e0000ULL,
0x0000002666667220ULL, 0x086fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x00012c927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000070ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x00012b627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000701fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fd800078e00ffULL,
0x8000002469690221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL, 0x0000006900090308ULL, 0x000e640000000800ULL,
0x0000000968680220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002268227221ULL, 0x004fc20000010000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL, 0x0126b4006a277984ULL, 0x008e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x000000261e697210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e1fULL,
0x003d09006900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b4006a277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910251e7816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff1e7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x000127227f007947ULL, 0x000fea000b800000ULL, 0x00001f1e27077589ULL, 0x0002a400000e0000ULL,
0x000000081e267810ULL, 0x000fe20007ffe0ffULL, 0x000127427f007947ULL, 0x000fea000b800000ULL,
0x000000101e047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000181e267810ULL, 0x008fe20007ffe0ffULL,
0x000127727f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000041a1e7824ULL, 0x042fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a207824ULL, 0x040fe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000010001a1f7824ULL, 0x000fe200078e00ffULL,
0x000000041e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000803267824ULL, 0x008fe200078e00ffULL,
0xfffff00020207812ULL, 0x000fc400078ec0ffULL, 0x0000001e171e7211ULL, 0x000fe400078fe0ffULL,
0x0000b00020207810ULL, 0x000fe40007ffe0ffULL, 0xffffe0001f217812ULL, 0x000fe200078ec0ffULL,
0x00000001031f7824ULL, 0x000fe400078e021eULL, 0x000000101c707824ULL, 0x100fe200078e0220ULL,
0x0000f00021257810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0220ULL,
0xfffffff8261c7812ULL, 0x000fc600078ee21fULL, 0x000000007070783bULL, 0x000e640000000200ULL,
0x000000101c787824ULL, 0x000fe400078e0225ULL, 0x000000001d68783bULL, 0x0006a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707231ULL, 0x086fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x0000000568687231ULL, 0x080fe400003400ffULL,
0x000000056a6a7231ULL, 0x000fe400003400ffULL, 0x0000000469697231ULL, 0x080fe400003400ffULL,
0x000000046b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000803267824ULL, 0x000fe200078e00ffULL, 0x000000021f217810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000d1000007945ULL, 0x000fe40003800000ULL,
0xfffffff826217812ULL, 0x000fca00078ee221ULL, 0x00000010217c7824ULL, 0x000fcc00078e0225ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000010ff807819ULL, 0x110fe4000001167aULL,
0x000000ff7a827812ULL, 0x040fe400078ec0ffULL, 0x00000018ff817819ULL, 0x000fe4000001167aULL,
0x0000ffff7a947812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001167bULL,
0x00000010ff767819ULL, 0x000fc40000011679ULL, 0x000000ff78257812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x000fe4000001167bULL, 0x000000ff7b847812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7b957812ULL, 0x000fe400078ec0ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000018ff7b7819ULL, 0x008fc4000001167cULL, 0x000000ff76767812ULL, 0x000fe200078ec0ffULL,
0x2000007aff867230ULL, 0x000fe20000004100ULL, 0x000000ff79267812ULL, 0x000fe400078ec0ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x000000ff7e8a7812ULL, 0x000fe400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000010ff1d7819ULL, 0x000fc40000011678ULL,
0x00000018ff1f7819ULL, 0x000fe40000011678ULL, 0x0000ffff78927812ULL, 0x000fe400078ec0ffULL,
0x00000076ff7a723eULL, 0x000fe400020006ffULL, 0x00000026ff78723eULL, 0x000fe200020006ffULL,
0x20000025ff267230ULL, 0x000fe20000004100ULL, 0x00000018ff277819ULL, 0x000fe40000011679ULL,
0x0000008aff25723eULL, 0x000fe200020006ffULL, 0x2000007bff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x100fe2000001167eULL, 0x2000007aff7b7230ULL, 0x000fe20000004100ULL,
0x00000018ff8c7819ULL, 0x000fe2000001167eULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x0000ffff7e987812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001167fULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x00000008ff7a7819ULL, 0x000fe40000011694ULL,
0x00000010ff877819ULL, 0x000fe4000001167cULL, 0x000000ff7c857812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7c967812ULL, 0x000fc400078ec0ffULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x000000ff7d887812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001167dULL,
0x0000ffff79937812ULL, 0x000fe200078ec0ffULL, 0x20000078ff797230ULL, 0x000fe20000004100ULL,
0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL, 0x2000001fff787230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000010ff897819ULL, 0x000fe4000001167dULL, 0x0000ffff7d977812ULL, 0x000fe200078ec0ffULL,
0x20000027ff7d7230ULL, 0x000fe20000004100ULL, 0x00000088ff1f723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x000000ff7f8d7812ULL, 0x000fe200078ec0ffULL,
0x2000001fff8b7230ULL, 0x000fe20000004100ULL, 0x0000001dff27723eULL, 0x000fe200020006ffULL,
0x2000007eff1d7230ULL, 0x000fe20000004100ULL, 0x00000008ff767819ULL, 0x000fe20000011692ULL,
0x2000007aff7e7230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x2000007cff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe20000011696ULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x0000008cff1f723eULL, 0x000fe200020006ffULL,
0x2000008dff917230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe20000011693ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000008ff8c7819ULL, 0x000fe20000011697ULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fc400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000008cff8d723eULL, 0x000fe200020006ffULL, 0x20000089ff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff767819ULL, 0x000fe20000011676ULL, 0x2000007aff897230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe20000011679ULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fe20000011678ULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fc400078ec0ffULL, 0x000000ff83837812ULL, 0x000fe400078ec0ffULL,
0x0000105479787816ULL, 0x000fe40000000076ULL, 0x00000010ff767819ULL, 0x000fe4000001167dULL,
0x00000010ff797819ULL, 0x000fe4000001167cULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000082ff82723eULL, 0x000fc400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fe2000001167fULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000105476797816ULL, 0x000fe20000000079ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x0000ffff7f7f7812ULL, 0x000fc400078ec0ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000008ff767819ULL, 0x000fe20000011698ULL, 0x000000787060723cULL, 0x082f620000041860ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x20000085ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x000000786840723cULL, 0x004f620000041840ULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x00000008ff7f7819ULL, 0x000fe4000001167fULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000105427267816ULL, 0x000fe40000000026ULL, 0x000010547b277816ULL, 0x000fe2000000007aULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000008ff857819ULL, 0x000fe40000011695ULL,
0x000000ff87877812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7a7819ULL, 0x000fe20000011682ULL,
0x20000076ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe20000011680ULL,
0x000000267064723cULL, 0x080f620000041864ULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7c7819ULL, 0x000fe4000001167eULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff837819ULL, 0x000fe20000011683ULL, 0x000000266844723cULL, 0x000b620000041844ULL,
0x0000007fff7e723eULL, 0x000fc400020006ffULL, 0x00000010ff257819ULL, 0x000fe40000011625ULL,
0x00000010ff767819ULL, 0x000fe4000001168fULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x0000000102277824ULL, 0x020fe200078e021eULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x000010547b7a7816ULL, 0x000fe2000000007aULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00001054837b7816ULL, 0x000fe20000000084ULL, 0x2000007eff837230ULL, 0x000fe20000004100ULL,
0x00001054767e7816ULL, 0x000fe20000000025ULL, 0x000000021a257824ULL, 0x000fe200078e00ffULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000010ff767819ULL, 0x000fe2000001161dULL, 0x0000007a705c723cULL, 0x000f62000004185cULL,
0x00001054817c7816ULL, 0x000fc4000000007cULL, 0x00000010ff817819ULL, 0x000fe4000001168bULL,
0x00000004251d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x000fe20000011686ULL,
0x0000007a683c723cULL, 0x000f62000004183cULL, 0x00000010ff7d7819ULL, 0x000fe40000011685ULL,
0x00000010ff807819ULL, 0x000fe40000011688ULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8b7819ULL, 0x000fe4000001168dULL, 0x00000010ff7f7819ULL, 0x000fc40000011691ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff1f7819ULL, 0x000fe4000001161fULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x000000021d267812ULL, 0x000fe400078efcffULL, 0x00001054867d7816ULL, 0x000fc4000000007dULL,
0x0000105487807816ULL, 0x000fe40000000080ULL, 0x000010548c817816ULL, 0x000fe40000000081ULL,
0x000010548a8a7816ULL, 0x000fe20000000089ULL, 0x0000007c7058723cULL, 0x040f620000041858ULL,
0x000010548e8b7816ULL, 0x000fe4000000008bULL, 0x00001054907f7816ULL, 0x000fe4000000007fULL,
0x000010541f827816ULL, 0x000fe20000000082ULL, 0x00000008021f7824ULL, 0x000fe200078e00ffULL,
0x0000105476837816ULL, 0x000fe20000000083ULL, 0x000000807054723cULL, 0x000f620000041854ULL,
0x0000002617267211ULL, 0x000fca00078fe0ffULL, 0x00000001031d7824ULL, 0x100fe400078e0226ULL,
0x0000008a7050723cULL, 0x000f620000041850ULL, 0x0000000102267824ULL, 0x000fca00078e0226ULL,
0xfffffff81f1e7812ULL, 0x000fe400078ee226ULL, 0x0000007e704c723cULL, 0x000f62000004184cULL,
0x0000100000267810ULL, 0x000fce0007ffe0ffULL, 0x000000827048723cULL, 0x000b6e0000041848ULL,
0x0000000803707824ULL, 0x020fe200078e00ffULL, 0x0000007c6838723cULL, 0x000f620000041838ULL,
0x0000000802727824ULL, 0x000fc600078e00ffULL, 0xfffffff8701d7812ULL, 0x000fe400078ee21dULL,
0xfffffff8721f7812ULL, 0x000fe400078ee227ULL, 0x000000806834723cULL, 0x040f620000041834ULL,
0x000000101d707824ULL, 0x100fe400078e0220ULL, 0x000000101e207824ULL, 0x000fe400078e0220ULL,
0x000000101f787824ULL, 0x000fe400078e0226ULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0x0000008a6830723cULL, 0x040f700000041830ULL, 0x0000007e682c723cULL, 0x040f70000004182cULL,
0x000000826828723cULL, 0x000b640000041828ULL, 0x000000002068783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707231ULL, 0x082fe400003400ffULL, 0x0000000772727231ULL, 0x000fc400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fe400003400ffULL,
0x0000000568687231ULL, 0x088fe400003400ffULL, 0x000000056a6a7231ULL, 0x000fe400003400ffULL,
0x0000000469697231ULL, 0x080fe400003400ffULL, 0x000000046b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008027d7824ULL, 0x000fe200078e00ffULL,
0x0000000227207810ULL, 0x004fe20007ffe0ffULL, 0x000000007878783bULL, 0x000ea60000004200ULL,
0xfffffff87d207812ULL, 0x000fca00078ee220ULL, 0x00000010207c7824ULL, 0x000fcc00078e0226ULL,
0x000000007c7c783bULL, 0x000f220000004200ULL, 0x00000010ff267819ULL, 0x104fe40000011678ULL,
0x000000ff78767812ULL, 0x040fe400078ec0ffULL, 0x00000018ff277819ULL, 0x000fe40000011678ULL,
0x0000ffff78947812ULL, 0x000fe400078ec0ffULL, 0x000000ff79787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x000fc40000011679ULL, 0x00000018ff817819ULL, 0x000fe40000011679ULL,
0x0000ffff79977812ULL, 0x000fe400078ec0ffULL, 0x00000078ff79723eULL, 0x000fe400020006ffULL,
0x00000027ff78723eULL, 0x000fe400020006ffULL, 0x00000018ff857819ULL, 0x000fe4000001167bULL,
0x000000ff26267812ULL, 0x000fc400078ec0ffULL, 0x00000010ff847819ULL, 0x100fe4000001167aULL,
0x000000ff7a837812ULL, 0x040fe400078ec0ffULL, 0x00000018ff827819ULL, 0x000fe4000001167aULL,
0x0000ffff7a987812ULL, 0x000fe200078ec0ffULL, 0x20000078ff7a7230ULL, 0x000fe20000004100ULL,
0x00000085ff78723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000078ff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x110fe2000001167cULL, 0x20000076ff277230ULL, 0x000fe20000004100ULL,
0x000000ff7c8c7812ULL, 0x040fe200078ec0ffULL, 0x20000026ff787230ULL, 0x000fe20000004100ULL,
0x00000018ff8a7819ULL, 0x000fe4000001167cULL, 0x0000ffff7c9a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fc4000001167dULL, 0x00000010ff8d7819ULL, 0x000fe4000001167dULL,
0x000000ff7d8e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7d9b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001167eULL, 0x00000010ff867819ULL, 0x000fe4000001167bULL,
0x000000ff7b877812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7b997812ULL, 0x000fe200078ec0ffULL,
0x20000079ff7b7230ULL, 0x000fe20000004100ULL, 0x00000083ff76723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000008ff267819ULL, 0x000fe20000011694ULL,
0x20000076ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe2000001167eULL,
0x2000007cff937230ULL, 0x000fe20000004100ULL, 0x000000ff7e8f7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff7e9c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001167fULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000008ff797819ULL, 0x000fe40000011697ULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x0000007eff76723eULL, 0x000fe200020006ffULL, 0x2000007dff7e7230ULL, 0x000fe20000004100ULL,
0x00000079ff7c723eULL, 0x000fe200020006ffULL, 0x20000026ff797230ULL, 0x000fe20000004100ULL,
0x000000ff86867812ULL, 0x000fe200078ec0ffULL, 0x20000081ff837230ULL, 0x000fe20000004100ULL,
0x00000008ff7d7819ULL, 0x000fe20000011698ULL, 0x2000007cff817230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000008ff267819ULL, 0x000fc40000011699ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x20000087ff887230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000082ff877230ULL, 0x000fe20000004100ULL,
0x000000ff897c7812ULL, 0x000fe200078ec0ffULL, 0x20000086ff897230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000007dff867230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fc400078ec0ffULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x000000ff7f927812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x2000008eff907230ULL, 0x000fe20000004100ULL, 0x0000008fff82723eULL, 0x000fe200020006ffULL,
0x2000008aff8f7230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000026ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff7d7819ULL, 0x000fe2000001169aULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000008dff26723eULL, 0x000fe200020006ffULL,
0x2000007cff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe2000001169bULL,
0x20000092ff967230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fc400020006ffULL,
0x000000ff917c7812ULL, 0x000fe200078ec0ffULL, 0x20000026ff917230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x0000008eff92723eULL, 0x000fe200020006ffULL,
0x2000007dff8e7230ULL, 0x000fe20000004100ULL, 0x0000007cff94723eULL, 0x000fe400020006ffULL,
0x00000010ff267819ULL, 0x000fe20000011627ULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe2000001167bULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000010ff277819ULL, 0x000fc40000011678ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167aULL,
0x00000010ff7d7819ULL, 0x000fe40000011680ULL, 0x00000010ff787819ULL, 0x000fe40000011679ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000010ff957819ULL, 0x000fe4000001167fULL,
0x0000ffff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000105427267816ULL, 0x000fc40000000026ULL, 0x000010547d277816ULL, 0x000fe4000000007cULL,
0x000010547b787816ULL, 0x000fe40000000078ULL, 0x00000010ff7b7819ULL, 0x000fe40000011688ULL,
0x00000010ff7c7819ULL, 0x000fe20000011689ULL, 0x000000267064723cULL, 0x002f620000041864ULL,
0x00000010ff797819ULL, 0x000fe40000011681ULL, 0x000000ff95957812ULL, 0x000fc400078ec0ffULL,
0x00000008ff817819ULL, 0x000fe4000001169cULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x000000266844723cULL, 0x008b620000041844ULL, 0x000010547c7b7816ULL, 0x000fe4000000007bULL,
0x00000010ff7a7819ULL, 0x000fe40000011683ULL, 0x00000010ff7c7819ULL, 0x000fe40000011686ULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff847819ULL, 0x000fe20000011684ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fe400020006ffULL, 0x00000081ff83723eULL, 0x000fe400020006ffULL,
0x0000007fff86723eULL, 0x000fe200020006ffULL, 0x20000095ff957230ULL, 0x000fe20000004100ULL,
0x000010547a797816ULL, 0x000fc40000000079ULL, 0x00001054847a7816ULL, 0x000fe20000000085ULL,
0x20000083ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x000fe2000001168bULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fe2000001168aULL,
0x000000787060723cULL, 0x000f620000041860ULL, 0x00000010ff817819ULL, 0x000fe40000011690ULL,
0x00000010ff847819ULL, 0x000fe40000011691ULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff7f7819ULL, 0x000fe20000011694ULL, 0x0000007a705c723cULL, 0x000f62000004185cULL,
0x00001054807d7816ULL, 0x000fe4000000007dULL, 0x0000105484817816ULL, 0x000fe40000000081ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff8e7819ULL, 0x000fe2000001168eULL,
0x000000786840723cULL, 0x000f620000041840ULL, 0x000010547f827816ULL, 0x000fc40000000082ULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff807819ULL, 0x000fe4000001168cULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x0000007a683c723cULL, 0x000f62000004183cULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff837819ULL, 0x000fc40000011696ULL, 0x00000010ff847819ULL, 0x000fe40000011695ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff7f7819ULL, 0x000fe40000011686ULL,
0x000010548f8e7816ULL, 0x000fc4000000008eULL, 0x00001054877c7816ULL, 0x000fe4000000007cULL,
0x000010548d807816ULL, 0x000fe40000000080ULL, 0x00001054938f7816ULL, 0x000fe40000000092ULL,
0x0000105484837816ULL, 0x000fe20000000083ULL, 0x0000007c7058723cULL, 0x000f620000041858ULL,
0x000010547e7e7816ULL, 0x000fe40000000085ULL, 0x00001054767f7816ULL, 0x000fc4000000007fULL,
0xfffffff825267812ULL, 0x020fc600078ec0ffULL, 0x000000807054723cULL, 0x040f700000041854ULL,
0x0000008e7050723cULL, 0x040f700000041850ULL, 0x00000082704c723cULL, 0x040f70000004184cULL,
0x0000007e7048723cULL, 0x000f700000041848ULL, 0x0000007c6838723cULL, 0x040f700000041838ULL,
0x000000806834723cULL, 0x040f700000041834ULL, 0x0000008e6830723cULL, 0x040f700000041830ULL,
0x00000082682c723cULL, 0x040f70000004182cULL, 0x0000007e6828723cULL, 0x000b6e0000041828ULL,
0x000126c8136a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900026ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff257224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x004fc80000015200ULL, 0x000004000d697984ULL, 0x000ea40000000800ULL,
0x8000000069ff7812ULL, 0x006fc4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000687805ULL, 0x000fcc0000015200ULL, 0x0000006826717210ULL, 0x000fca0007f1e1ffULL,
0x0000000169697824ULL, 0x000fe200000e0e27ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff687819ULL, 0x000fc80000011469ULL,
0x0000007168687211ULL, 0x000fca00078110ffULL, 0x000000ffff697224ULL, 0x000fca00000e0669ULL,
0x0000000268687819ULL, 0x000fc80000001269ULL, 0x000000680000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d697984ULL, 0x000e640000000800ULL,
0x8000000069ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c00c277810ULL, 0x000fca0007ffe0ffULL, 0x0000660012717a24ULL, 0x000fe200078e0227ULL,
0x000003e00000a947ULL, 0x000fea0003800000ULL, 0x0000002716257217ULL, 0x000fe20007800000ULL,
0x0000001011707824ULL, 0x000fe200078e00ffULL, 0x00000003ff687819ULL, 0x000fe40000011617ULL,
0x00001000007b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a27ULL,
0x0000000468697810ULL, 0x000fe20007ffe0ffULL, 0x0000000170267824ULL, 0x000fe200078e0268ULL,
0x00000008686b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002570257217ULL, 0x000fe20007800000ULL,
0x0000000126277824ULL, 0x000fc400078e0217ULL, 0x0000000826727824ULL, 0x040fe400078e00ffULL,
0x0000000125257824ULL, 0x000fe400078e0a70ULL, 0x0000000126267824ULL, 0x000fe200078e0271ULL,
0xfffffff872727812ULL, 0x000fe200078ee227ULL, 0x0000000170767824ULL, 0x000fe200078e0269ULL,
0x000000256900720cULL, 0x080fe20003f86070ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000c68697810ULL, 0x040fe40007ffe0ffULL, 0x000000256800720cULL, 0x080fe20003fa6070ULL,
0x0000000176687824ULL, 0x000fe200078e0271ULL, 0x000000256900720cULL, 0x000fe20003f06070ULL,
0x00000001707a7824ULL, 0x000fe200078e0269ULL, 0x0000000b266a7212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x000000256b00720cULL, 0x000fc40003f66070ULL,
0x000062006a6a7a10ULL, 0x000fe20007fde0ffULL, 0x0000000170787824ULL, 0x000fe200078e026bULL,
0x0000000b68707212ULL, 0x000fe200078efcffULL, 0x0000000176257824ULL, 0x000fe200078e0217ULL,
0x00006300276b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000178267824ULL, 0x000fe200078e0271ULL,
0x0000620070707a10ULL, 0x000fe20007fde0ffULL, 0x0000000876767824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff876767812ULL, 0x000fe200078ee225ULL,
0x000000017a687824ULL, 0x000fe200078e0271ULL, 0x0000630069717a10ULL, 0x000fe200037fe4ffULL,
0x0000000178737824ULL, 0x000fe200078e0217ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fc600078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007fde0ffULL,
0x0000000878787824ULL, 0x000fe200078e00ffULL, 0x0000000b68687212ULL, 0x000fe200078efcffULL,
0x000000017a257824ULL, 0x040fe200078e0217ULL, 0x0000630027277a10ULL, 0x000fe200037fe4ffULL,
0x000000087a7a7824ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee273ULL,
0x0000001076737824ULL, 0x000fe200078e027bULL, 0x0000620068687a10ULL, 0x000fe40007fde0ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee225ULL, 0x0000001072257824ULL, 0x100fe200078e027bULL,
0x0000630069697a10ULL, 0x000fe200037fe4ffULL, 0x0000001078797824ULL, 0x000fc400078e027bULL,
0x000000107a7b7824ULL, 0x000fe200078e027bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a257faeULL, 0x0003e8000e901c48ULL, 0x0000000070737faeULL, 0x0003e8000e101c48ULL,
0x0000000026797faeULL, 0x0003e8000d901c48ULL, 0x00000000687b7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011267824ULL, 0x000fe200078e00ffULL,
0x00001000007b7810ULL, 0x000fc80007ffe0ffULL, 0x0000002617687211ULL, 0x000fc800078fe8ffULL,
0x00000004686a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000168267824ULL, 0x040fe200078e0271ULL,
0x0000000868767810ULL, 0x040fe20007ffe0ffULL, 0x0000000168257824ULL, 0x040fe200078e0217ULL,
0x0000000c68787810ULL, 0x040fe20007ffe0ffULL, 0x0000000868727824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x000000016a257824ULL, 0x000fe200078e0271ULL, 0x0000000b26707212ULL, 0x000fe200078efcffULL,
0x000000016a697824ULL, 0x040fe400078e0217ULL, 0x000000086a7a7824ULL, 0x000fe200078e00ffULL,
0x0000620070707a10ULL, 0x000fe20007f1e0ffULL, 0x0000000176687824ULL, 0x100fe400078e0271ULL,
0x00000001786a7824ULL, 0x040fe400078e0271ULL, 0x0000000178267824ULL, 0x000fc400078e0217ULL,
0x0000000878717824ULL, 0x000fe400078e00ffULL, 0x00000001766b7824ULL, 0x040fe400078e0217ULL,
0x00000008767c7824ULL, 0x000fe200078e00ffULL, 0xfffffff87a767812ULL, 0x000fe200078ee269ULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0xfffffff8717a7812ULL, 0x000fe400078ee226ULL,
0x0000630027717a10ULL, 0x000fe200007fe4ffULL, 0x0000008025267825ULL, 0x000fe200078e00ffULL,
0xfffffff87c787812ULL, 0x000fc400078ee26bULL, 0x0000000b68687212ULL, 0x080fe200078efcffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000620068687a10ULL, 0x000fe20007f7e0ffULL, 0x0000001072257824ULL, 0x100fe200078e027bULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x0000001076737824ULL, 0x100fe200078e027bULL,
0x0000620026267a10ULL, 0x000fe20007f1e0ffULL, 0x0000001078797824ULL, 0x100fe200078e027bULL,
0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x000000107a7b7824ULL, 0x000fe200078e027bULL,
0x0000630027277a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000070257faeULL, 0x0003e2000b901c48ULL, 0x0000630069697a10ULL, 0x000fc40001ffe4ffULL,
0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026737faeULL, 0x0003e8000b901c48ULL,
0x0000000068797faeULL, 0x0003e8000b901c48ULL, 0x000000006a7b7faeULL, 0x0003e4000b901c48ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff014687812ULL, 0x000fce00078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b00068687f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480023707f8cULL, 0x0004e4000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0xffffffe014237812ULL, 0x044fe400078ec0ffULL, 0x00000010146a7812ULL, 0x040fe400078ec0ffULL,
0x0000000814257812ULL, 0x000fc800078ec0ffULL, 0x0000002325237210ULL, 0x000fca0007ffe06aULL,
0x01264c0023257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x00cfe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006a7805ULL, 0x000fcc0000015200ULL, 0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL,
0x000000016b6b7824ULL, 0x000fe200000e0e27ULL, 0x003d09006a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001146bULL,
0x0000006a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff6a7224ULL, 0x000fca00000e066bULL,
0x0000000225257819ULL, 0x000fc8000000126aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c0023257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a237824ULL, 0x000fca00078e00ffULL, 0xffffff8023267812ULL, 0x000fc800078ec0ffULL,
0x000001000b237810ULL, 0x000fca0007ffe026ULL, 0x000000010a237824ULL, 0x000fca00078e0223ULL,
0x0120000023717984ULL, 0x000ea80000000800ULL, 0x0122000023707984ULL, 0x0006620000000800ULL,
0x000000247100720bULL, 0x004fe20003f1d000ULL, 0x0000fee27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000727806ULL, 0x008fc800000e0100ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e0024ULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x0000000210237810ULL, 0x000fe40007ffe0ffULL, 0x000000247100720bULL, 0x000fe40003f74000ULL,
0x0000001a2300720cULL, 0x000fe20003f05270ULL, 0x0000fe927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000237806ULL, 0x000fc400018e0100ULL, 0x000000801a278824ULL, 0x000fe200078e020bULL,
0x0000002471257209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a268824ULL, 0x000fca00078e0227ULL, 0x0124002526008388ULL, 0x0005e20000000800ULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x8000002524257221ULL, 0x004fe20000010000ULL, 0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500277308ULL, 0x000ea40000000800ULL, 0x0000002722227220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x0000fdd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x0000fc927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x0000fb527f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000023ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x0000fa227f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000002372ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff6a7424ULL, 0x000fe200078e00ffULL, 0x0000002471237209ULL, 0x000fd60007810000ULL,
0x8000002371710221ULL, 0x000fe20000010000ULL, 0x00007610ff6a0816ULL, 0x000fc6000000006aULL,
0x3fb8aa3b71710820ULL, 0x000fc80000410000ULL, 0x0000007100090308ULL, 0x000ea40000000800ULL,
0x0000000970700220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002270227221ULL, 0x002fc20000010000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x0000040008277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026246b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000006b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040008277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106a247816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff247819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000f5e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2427077589ULL, 0x0002a400000e0000ULL, 0x0000000824267810ULL, 0x000fe20007ffe0ffULL,
0x0000f6027f007947ULL, 0x000fea000b800000ULL, 0x0000001024047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x0000001824267810ULL, 0x008fe20007ffe0ffULL, 0x0000f6327f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021a6a7824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a267824ULL, 0x008fe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000008036c7824ULL, 0x000fe200078e00ffULL, 0x000000046a247812ULL, 0x002fe200078ec0ffULL,
0x0000000802277824ULL, 0x000fe200078e00ffULL, 0xfffff000266b7812ULL, 0x000fe200078ec0ffULL,
0x000000101c787824ULL, 0x000fe200078e0200ULL, 0x0000002417247211ULL, 0x000fc400078fe0ffULL,
0x0000c0006b6b7810ULL, 0x000fc60007ffe0ffULL, 0x0000000103257824ULL, 0x100fe400078e0224ULL,
0x0000000102267824ULL, 0x000fc600078e0224ULL, 0xfffffff86c247812ULL, 0x000fe400078ee225ULL,
0xfffffff827267812ULL, 0x000fc600078ee226ULL, 0x0000001024707824ULL, 0x100fe400078e026bULL,
0x0000001026267824ULL, 0x000fc800078e026bULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002624783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707231ULL, 0x086fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x0000000524247231ULL, 0x088fe400003400ffULL, 0x0000000526267231ULL, 0x000fe400003400ffULL,
0x0000000425257231ULL, 0x080fe400003400ffULL, 0x0000000427277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000010217c7824ULL, 0x000fe200078e0200ULL, 0x00000c1000007945ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff6c7819ULL, 0x010fc40000011678ULL,
0x00000018ff837819ULL, 0x000fe4000001167bULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff217819ULL, 0x000fe40000011678ULL, 0x000000ff786d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff78957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x000fc40000011679ULL,
0x000000ff79817812ULL, 0x040fe400078ec0ffULL, 0x00000018ff807819ULL, 0x000fe40000011679ULL,
0x0000ffff79967812ULL, 0x000fe400078ec0ffULL, 0x00000010ff827819ULL, 0x100fe4000001167aULL,
0x000000ff7a797812ULL, 0x000fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fc4000001167aULL,
0x0000ffff7a977812ULL, 0x000fe200078ec0ffULL, 0x2000006cff7a7230ULL, 0x000fe20000004100ULL,
0x00000083ff6c723eULL, 0x000fe400020006ffULL, 0x000000ff7b857812ULL, 0x000fe400078ec0ffULL,
0x000000ff7d8a7812ULL, 0x008fe200078ec0ffULL, 0x2000006cff897230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fc400020006ffULL,
0x0000008aff6c723eULL, 0x000fe200020006ffULL, 0x20000085ff867230ULL, 0x000fe20000004100ULL,
0x000000ff21217812ULL, 0x000fe200078ec0ffULL, 0x20000078ff857230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x2000006cff8e7230ULL, 0x000fe20000004100ULL,
0x00000021ff6c723eULL, 0x000fe400020006ffULL, 0x000000ff76787812ULL, 0x000fe200078ec0ffULL,
0x20000079ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fc4000001167bULL,
0x0000ffff7b987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff887819ULL, 0x100fe4000001167cULL,
0x000000ff7c877812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001167cULL,
0x0000ffff7c997812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001167dULL,
0x00000078ff79723eULL, 0x000fe200020006ffULL, 0x2000006cff787230ULL, 0x000fe20000004100ULL,
0x00000008ff6c7819ULL, 0x000fe40000011695ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000007bff8d7230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe2000001167dULL,
0x2000007cff917230ULL, 0x000fe20000004100ULL, 0x0000ffff7d9a7812ULL, 0x000fe200078ec0ffULL,
0x20000079ff7c7230ULL, 0x000fe20000004100ULL, 0x00000018ff7d7819ULL, 0x000fe2000001167eULL,
0x2000006cff797230ULL, 0x000fe20000004100ULL, 0x00000008ff7b7819ULL, 0x000fc40000011696ULL,
0x00000018ff8f7819ULL, 0x000fe4000001167fULL, 0x000000ff7e8c7812ULL, 0x040fe400078ec0ffULL,
0x00000008ff6c7819ULL, 0x000fe40000011698ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000010ff927819ULL, 0x000fe2000001167eULL,
0x2000007dff767230ULL, 0x000fe20000004100ULL, 0x0000ffff7e9b7812ULL, 0x000fe200078ec0ffULL,
0x2000007bff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff7f907812ULL, 0x000fc400078ec0ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x0000008cff7e723eULL, 0x000fe400020006ffULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x2000008fff217230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff8b8c7812ULL, 0x000fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x00000008ff8b7819ULL, 0x000fe40000011699ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000088ff7b723eULL, 0x000fe200020006ffULL, 0x2000006cff887230ULL, 0x000fe20000004100ULL,
0x00000008ff8f7819ULL, 0x000fe2000001169aULL, 0x20000090ff947230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x0000008bff6c723eULL, 0x000fe200020006ffULL, 0x2000007bff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff82827812ULL, 0x000fc400078ec0ffULL, 0x0000008fff90723eULL, 0x000fe200020006ffULL,
0x2000008cff8f7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000006cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fe2000001166dULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe20000011678ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff7c7819ULL, 0x000fc4000001167cULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x000010546d6c7816ULL, 0x000fe4000000006cULL, 0x00000010ff7b7819ULL, 0x000fe2000001167aULL,
0x20000087ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fe40000011679ULL,
0x000010547c6d7816ULL, 0x000fe40000000081ULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x00000008ff817819ULL, 0x000fe4000001169bULL, 0x00000010ff937819ULL, 0x000fe2000001167fULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000ffff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x0000006c7064723cULL, 0x002f620000041864ULL, 0x000000ff84877812ULL, 0x000fe400078ec0ffULL,
0x000010547b787816ULL, 0x000fe40000000078ULL, 0x00000010ff7a7819ULL, 0x000fc40000011683ULL,
0x00000008ff847819ULL, 0x000fe20000011697ULL, 0x0000006c2444723cULL, 0x000f620000041844ULL,
0x00000010ff7b7819ULL, 0x000fe40000011682ULL, 0x00000081ff83723eULL, 0x000fe400020006ffULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff817819ULL, 0x000fe2000001168eULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff827819ULL, 0x000fc4000001168fULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7f7819ULL, 0x000fe4000001167fULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000105482817816ULL, 0x000fe20000000081ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000010ff797819ULL, 0x000fe2000001167dULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x0000007fff82723eULL, 0x000fe400020006ffULL, 0x0000105480797816ULL, 0x000fe20000000079ULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x000fe20000011689ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fc40000011688ULL,
0x00000010ff7c7819ULL, 0x000fe20000011684ULL, 0x000000787060723cULL, 0x080f620000041860ULL,
0x00001054807d7816ULL, 0x000fe4000000007dULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x000000782440723cULL, 0x000b620000041840ULL, 0x00000010ff7f7819ULL, 0x000fc40000011692ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff847819ULL, 0x000fe20000011621ULL, 0x000000101f787824ULL, 0x020fe200078e0200ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff857819ULL, 0x000fc40000011685ULL, 0x00000010ff807819ULL, 0x000fe4000001168aULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000010ff937819ULL, 0x000fc40000011693ULL, 0x00000010ff217819ULL, 0x000fe40000011682ULL,
0x000010547b7a7816ULL, 0x000fe4000000007aULL, 0x000010548d8c7816ULL, 0x000fe4000000008cULL,
0x000010547f7e7816ULL, 0x000fe4000000007eULL, 0x0000105476827816ULL, 0x000fe40000000083ULL,
0x00001054877b7816ULL, 0x000fc40000000086ULL, 0x00001054857c7816ULL, 0x000fe4000000007cULL,
0x000010548b807816ULL, 0x000fe40000000080ULL, 0x00001054918d7816ULL, 0x000fe20000000090ULL,
0x0000007a705c723cULL, 0x000f62000004185cULL, 0x00001054937f7816ULL, 0x000fe40000000094ULL,
0x0000105484837816ULL, 0x000fca0000000021ULL, 0x0000007c7058723cULL, 0x040f700000041858ULL,
0x000000807054723cULL, 0x040f700000041854ULL, 0x0000008c7050723cULL, 0x040f700000041850ULL,
0x0000007e704c723cULL, 0x040f70000004184cULL, 0x000000827048723cULL, 0x000b6e0000041848ULL,
0x000000101d707824ULL, 0x120fe200078e026bULL, 0x0000007a243c723cULL, 0x000f62000004183cULL,
0x000000101e6b7824ULL, 0x000fc800078e026bULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007c2438723cULL, 0x040f700000041838ULL, 0x000000802434723cULL, 0x040f700000041834ULL,
0x0000008c2430723cULL, 0x040f700000041830ULL, 0x0000007e242c723cULL, 0x040f70000004182cULL,
0x000000822428723cULL, 0x000b640000041828ULL, 0x000000006b24783bULL, 0x0206a20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707231ULL, 0x086fe400003400ffULL, 0x0000000772727231ULL, 0x000fc400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fe400003400ffULL,
0x0000000524247231ULL, 0x080fe400003400ffULL, 0x0000000526267231ULL, 0x000fe400003400ffULL,
0x0000000425257231ULL, 0x080fe400003400ffULL, 0x0000000427277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000010207c7824ULL, 0x000fcc00078e0200ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000010ff207819ULL, 0x110fe40000011678ULL, 0x000000ff796c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fe40000011678ULL, 0x000000ff20207812ULL, 0x000fe400078ec0ffULL,
0x000000ff786b7812ULL, 0x048fe400078ec0ffULL, 0x0000ffff78937812ULL, 0x000fc400078ec0ffULL,
0x0000006cff78723eULL, 0x000fe400020006ffULL, 0x00000021ff6c723eULL, 0x000fe400020006ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000010ff6d7819ULL, 0x100fe40000011679ULL,
0x00000018ff767819ULL, 0x000fe40000011679ULL, 0x0000ffff79947812ULL, 0x000fe200078ec0ffULL,
0x20000078ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x100fe2000001167aULL,
0x2000006cff787230ULL, 0x000fe20000004100ULL, 0x000000ff7a827812ULL, 0x000fe200078ec0ffULL,
0x20000020ff6c7230ULL, 0x000fe20000004100ULL, 0x00000018ff817819ULL, 0x000fc4000001167aULL,
0x0000ffff7a957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff847819ULL, 0x100fe4000001167bULL,
0x000000ff7b837812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001167bULL,
0x0000ffff7b967812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fc4000001167cULL,
0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff207819ULL, 0x000fe40000011693ULL,
0x000000ff7e8b7812ULL, 0x000fe400078ec0ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000007aff877230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fc400020006ffULL,
0x000000ff7d8a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff907819ULL, 0x100fe4000001167eULL,
0x00000018ff8d7819ULL, 0x000fe4000001167eULL, 0x0000ffff7e997812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fe4000001167cULL, 0x000000ff7c887812ULL, 0x000fc400078ec0ffULL,
0x0000ffff7c977812ULL, 0x000fe400078ec0ffULL, 0x0000008bff7e723eULL, 0x000fe200020006ffULL,
0x2000007bff8b7230ULL, 0x000fe20000004100ULL, 0x00000018ff7c7819ULL, 0x000fe2000001167dULL,
0x2000006dff7b7230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe20000011694ULL,
0x20000020ff6d7230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff207819ULL, 0x000fc40000011696ULL,
0x00000010ff897819ULL, 0x000fe2000001167dULL, 0x2000008aff8c7230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x2000007cff8f7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x2000006bff217230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000083ff857230ULL, 0x000fe20000004100ULL,
0x000000ff86867812ULL, 0x000fe200078ec0ffULL, 0x2000007aff7c7230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe200020006ffULL, 0x20000081ff837230ULL, 0x000fe20000004100ULL,
0x0000ffff7d987812ULL, 0x000fc400078ec0ffULL, 0x000000ff898a7812ULL, 0x000fe400078ec0ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000008ff897819ULL, 0x000fe40000011697ULL,
0x00000018ff8e7819ULL, 0x000fe2000001167fULL, 0x20000076ff7d7230ULL, 0x000fe20000004100ULL,
0x0000008dff6b723eULL, 0x000fe400020006ffULL, 0x00000086ff7a723eULL, 0x000fe200020006ffULL,
0x20000020ff867230ULL, 0x000fe20000004100ULL, 0x00000008ff817819ULL, 0x000fe20000011695ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff8d7819ULL, 0x000fc40000011698ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x00000089ff20723eULL, 0x000fe200020006ffULL, 0x2000007aff897230ULL, 0x000fe20000004100ULL,
0x0000008eff76723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000008dff8e723eULL, 0x000fe200020006ffULL, 0x2000008aff8d7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000020ff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff207819ULL, 0x000fe20000011621ULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe20000011679ULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe2000001166cULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fe20000011678ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fc4000001167bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166dULL,
0x00000010ff787819ULL, 0x000fe4000001167dULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000008ff7d7819ULL, 0x000fe40000011699ULL, 0x00000010ff917819ULL, 0x000fe2000001167fULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x000000ff7f927812ULL, 0x000fc400078ec0ffULL,
0x0000105421207816ULL, 0x000fe40000000020ULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x000010547b217816ULL, 0x000fe4000000007aULL, 0x00001054796c7816ULL, 0x000fe4000000006cULL,
0x00000010ff7a7819ULL, 0x000fe40000011681ULL, 0x00000010ff797819ULL, 0x000fe20000011680ULL,
0x000000207064723cULL, 0x002f620000041864ULL, 0x0000007dff81723eULL, 0x000fc400020006ffULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x000fe2000001168cULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x000fe2000001168dULL,
0x000000202444723cULL, 0x004b620000041844ULL, 0x000000ff84847812ULL, 0x000fe400078ec0ffULL,
0x000000ff91917812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7f7819ULL, 0x000fc4000001167fULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000010ff6d7819ULL, 0x000fe4000001167cULL,
0x00001054807d7816ULL, 0x000fe2000000007dULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000007fff80723eULL, 0x000fc400020006ffULL, 0x00001054786d7816ULL, 0x000fe2000000006dULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x0000105479787816ULL, 0x000fe20000000082ULL,
0x20000080ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe40000011687ULL,
0x00000010ff7b7819ULL, 0x000fe20000011686ULL, 0x0000006c7060723cULL, 0x000f620000041860ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x000010547c7b7816ULL, 0x000fc4000000007bULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x0000006c2440723cULL, 0x000f620000041840ULL, 0x00000010ff7f7819ULL, 0x000fe40000011690ULL,
0x00000010ff807819ULL, 0x000fe4000001166bULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff857819ULL, 0x000fc40000011685ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff7c7819ULL, 0x000fe40000011688ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff8e7819ULL, 0x000fc4000001168eULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff6b7819ULL, 0x000fe40000011676ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x000010548b8a7816ULL, 0x000fe4000000008aULL,
0x000010547f7e7816ULL, 0x000fc4000000007eULL, 0x0000105480807816ULL, 0x000fe40000000081ULL,
0x0000105484797816ULL, 0x000fe40000000085ULL, 0x00001054837a7816ULL, 0x000fe4000000007aULL,
0x00001054897c7816ULL, 0x000fe4000000007cULL, 0x000010548f8b7816ULL, 0x000fe2000000008eULL,
0x00000078705c723cULL, 0x000f62000004185cULL, 0x00001054917f7816ULL, 0x000fc40000000092ULL,
0x000010546b817816ULL, 0x000fe40000000082ULL, 0xfffffff86a207812ULL, 0x020fc600078ec0ffULL,
0x0000007a7058723cULL, 0x040f700000041858ULL, 0x0000007c7054723cULL, 0x040f700000041854ULL,
0x0000008a7050723cULL, 0x040f700000041850ULL, 0x0000007e704c723cULL, 0x040f70000004184cULL,
0x000000807048723cULL, 0x000f700000041848ULL, 0x00000078243c723cULL, 0x040f70000004183cULL,
0x0000007a2438723cULL, 0x040f700000041838ULL, 0x0000007c2434723cULL, 0x040f700000041834ULL,
0x0000008a2430723cULL, 0x040f700000041830ULL, 0x0000007e242c723cULL, 0x040f70000004182cULL,
0x000000802428723cULL, 0x000b6e0000041828ULL, 0x000126c813267811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000026267f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126980020ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6a7224ULL, 0x000fc600078e00ffULL, 0x0000000000207805ULL, 0x004fc80000015200ULL,
0x000004000d257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc40007804827ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024206b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011425ULL, 0x0000006b24247211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000224247819ULL, 0x000fc80000001225ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f207810ULL, 0x000fc80007ffe0ffULL,
0x000000152000720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x000000020f207810ULL, 0x000fe40007ffe0ffULL, 0x000001000c217810ULL, 0x000fe40007ffe0ffULL,
0x000000152000720cULL, 0x000fc60003f06070ULL, 0x00006600126c7a24ULL, 0x000fd400078e0221ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x00000021160c7217ULL, 0x000fe20007800000ULL,
0x0000001011277824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x000fc60000011617ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a21ULL, 0x00000004256b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127207824ULL, 0x000fe200078e0225ULL, 0x0000000825717810ULL, 0x000fe40007ffe0ffULL,
0x0000000c270c7217ULL, 0x000fe20007800000ULL, 0x0000000120217824ULL, 0x040fe200078e0217ULL,
0x0000000c25737810ULL, 0x000fe20007ffe0ffULL, 0x0000000820247824ULL, 0x000fe400078e00ffULL,
0x0000000127707824ULL, 0x000fc400078e026bULL, 0x0000000120207824ULL, 0x100fe200078e026cULL,
0xfffffff8246d7812ULL, 0x000fe200078ee221ULL, 0x000000010c0c7824ULL, 0x000fe400078e0a27ULL,
0x0000000170247824ULL, 0x000fe400078e026cULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000c2500720cULL, 0x080fe40003f06070ULL, 0x0000000c7100720cULL, 0x080fe20003f66070ULL,
0x0000000127727824ULL, 0x000fe200078e0271ULL, 0x0000000b206a7212ULL, 0x000fe200078efcffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000000c6b00720cULL, 0x000fc40003f86070ULL,
0x000062006a6a7a10ULL, 0x000fe20007fbe0ffULL, 0x0000000172267824ULL, 0x100fe200078e026cULL,
0x0000000b24247212ULL, 0x080fe200078efcffULL, 0x0000000127767824ULL, 0x000fe200078e0273ULL,
0x00006300216b7a10ULL, 0x000fe20002ffe4ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620024247a10ULL, 0x000fe40007fde0ffULL, 0x0000000c7300720cULL, 0x000fe20003fa6070ULL,
0x0000000176207824ULL, 0x000fe200078e026cULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x00000001706c7824ULL, 0x040fe200078e0217ULL, 0x0000630025257a10ULL, 0x000fe200037fe4ffULL,
0x0000000870717824ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007fde0ffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee26cULL,
0x00000001720c7824ULL, 0x100fe200078e0217ULL, 0x0000000b20207212ULL, 0x000fe200078efcffULL,
0x0000000872737824ULL, 0x000fe200078e00ffULL, 0x0000630027277a10ULL, 0x000fe200037fe4ffULL,
0x00000001766c7824ULL, 0x000fe200078e0217ULL, 0x0000620020207a10ULL, 0x000fe20007fde0ffULL,
0x0000000876797824ULL, 0x000fe200078e00ffULL, 0xfffffff873737812ULL, 0x000fe200078ee20cULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x0000630021217a10ULL, 0x000fe200037fe4ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff879797812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a6d7faeULL, 0x0003e6000c101c48ULL, 0x0000001079797824ULL, 0x000fe200078e0200ULL,
0x0000000024717faeULL, 0x0003e8000e101c48ULL, 0x0000000026737faeULL, 0x0003e8000d901c48ULL,
0x0000000020797faeULL, 0x0003e2000e901c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010110c7824ULL, 0x000fca00078e00ffULL, 0x0000000c170c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c247810ULL, 0x040fe20007ffe0ffULL, 0x000000010c207824ULL, 0x140fe200078e0217ULL,
0x000000080c267810ULL, 0x040fe20007ffe0ffULL, 0x000000080c6d7824ULL, 0x000fe400078e00ffULL,
0x0000000124217824ULL, 0x140fe400078e0217ULL, 0x00000008246a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee220ULL, 0x000000010c207824ULL, 0x040fe200078e026cULL,
0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000126257824ULL, 0x000fe200078e0217ULL,
0xfffffff86a717812ULL, 0x000fe200078ee221ULL, 0x0000000826707824ULL, 0x000fc400078e00ffULL,
0x0000000124247824ULL, 0x000fe400078e026cULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0xfffffff870737812ULL, 0x000fc600078ee225ULL, 0x0000000126267824ULL, 0x100fe200078e026cULL,
0x0000000b20207212ULL, 0x000fe200078efcffULL, 0x000000010c6a7824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000620020207a10ULL, 0x000fc60007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000b24247212ULL, 0x080fe400078efcffULL,
0x0000630021217a10ULL, 0x000fe200007fe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000620024247a10ULL, 0x000fe20007f7e0ffULL,
0x000000010c6c7824ULL, 0x000fe200078e0217ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000080c797824ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007f1e0ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff879797812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x0000630025257a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000206d7faeULL, 0x0003e2000b901c48ULL,
0x0000630027277a10ULL, 0x000fe200007fe4ffULL, 0x0000001079797824ULL, 0x000fe200078e0200ULL,
0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000024717faeULL, 0x0003e8000b901c48ULL,
0x0000000026737faeULL, 0x0003e8000b901c48ULL, 0x000000006a797faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000814217812ULL, 0x000fe200078ec0ffULL,
0x00000020100c7824ULL, 0x000fc400078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x00000001210c7824ULL, 0x000fe200078e020cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012668000c267f8cULL, 0x000664000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01266c000c257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024206b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011425ULL, 0x0000006b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000208087819ULL, 0x000fc80000001225ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c000c257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018010087811ULL, 0x000fc800078e38ffULL,
0x000000080a087210ULL, 0x000fca0007ffe00bULL, 0x01200000080c7984ULL, 0x008e680000000800ULL,
0x0122000008207984ULL, 0x0006a20000000800ULL, 0x000000230c00720bULL, 0x002fe20003f1d000ULL,
0x0000cf027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x008fc800000e0100ULL,
0x000000ff2100720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fd200078e0023ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000310257810ULL, 0x000fe40007ffe0ffULL,
0x000000230c00720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x0000ceb27f007947ULL, 0x000fd4000b800000ULL, 0x00000000006c7806ULL, 0x004fc400018e0100ULL,
0x000000801a0b8824ULL, 0x000fe200078e020bULL, 0x000000230c087209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a0b8824ULL, 0x000fca00078e020bULL,
0x012400080b008388ULL, 0x0003e20000000800ULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000023080a7221ULL, 0x002fe20000010100ULL,
0x000000ff6cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00277308ULL, 0x000e640000000800ULL,
0x0000002722227220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x0000cdf27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002a400000e0000ULL, 0x0000002664647220ULL, 0x084fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x0000ccb27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x0000cb727f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x0000ca427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006c21ff7212ULL, 0x000fda00078030ffULL, 0x0000000c080c0221ULL, 0x000fe20000010100ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b0c0c0820ULL, 0x000fc80000410000ULL,
0x0000000c00090308ULL, 0x000e640000000800ULL, 0x0000000920200220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002220227221ULL, 0x004fc20000010000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0xfffffff014267812ULL, 0x000fca00078ec0ffULL,
0x0126b40026217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000200a237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e0bULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011421ULL,
0x000000230c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x000000020c0c7819ULL, 0x000fc80000001221ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b40026217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910240a7816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff0a7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000c6127f007947ULL, 0x000fea000b800000ULL,
0x00001f0a27077589ULL, 0x0002a400000e0000ULL, 0x000000080a267810ULL, 0x000fe20007ffe0ffULL,
0x0000c6327f007947ULL, 0x000fea000b800000ULL, 0x000000100a047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000180a267810ULL, 0x008fe20007ffe0ffULL, 0x0000c6627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001130a7812ULL, 0x002fe200078ec0ffULL, 0x0000000803207824ULL, 0x000fe200078e00ffULL,
0x00000004ff0b7819ULL, 0x000fe20000011617ULL, 0x0000000802217824ULL, 0x000fe200078e00ffULL,
0x0000100000007810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x000000040a0a7824ULL, 0x000fc400078e020bULL,
0x000000101c707824ULL, 0x000fe400078e0200ULL, 0x00000001030b7824ULL, 0x100fe400078e020aULL,
0x00000001020c7824ULL, 0x000fc600078e020aULL, 0xfffffff8200a7812ULL, 0x000fe200078ee20bULL,
0x000000041a207824ULL, 0x000fe200078e00ffULL, 0x0000d000100b7811ULL, 0x000fe400078e60ffULL,
0xfffffff8210c7812ULL, 0x000fe400078ee20cULL, 0x0000000420207812ULL, 0x000fe200078ec0ffULL,
0x000000100a0a7824ULL, 0x100fe400078e020bULL, 0x000000100c0c7824ULL, 0x000fe200078e020bULL,
0x00000002201c7812ULL, 0x000fc400078efcffULL, 0x000000000a68783bULL, 0x0002e80000000200ULL,
0x000000000c24783bULL, 0x0082e20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000768687231ULL, 0x084fe400003400ffULL, 0x000000076a6a7231ULL, 0x000fe400003400ffULL,
0x0000000669697231ULL, 0x080fe400003400ffULL, 0x000000066b6b7231ULL, 0x000fc400003400ffULL,
0x0000000524247231ULL, 0x088fe400003400ffULL, 0x0000000526267231ULL, 0x000fe400003400ffULL,
0x0000000425257231ULL, 0x080fe400003400ffULL, 0x0000000427277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001c170a7211ULL, 0x002fe200078fe0ffULL,
0x00000008030c7824ULL, 0x040fe200078e00ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x000000101e1e7824ULL, 0x000fe200078e020bULL, 0x00000c3000007945ULL, 0x000fe20003800000ULL,
0x0000000103037824ULL, 0x000fca00078e020aULL, 0xfffffff80c037812ULL, 0x000fca00078ee203ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000378783bULL, 0x0008e20000004200ULL,
0x000000ff71217812ULL, 0x002fe400078ec0ffULL, 0x00000018ff1c7819ULL, 0x100fe40000011670ULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000010ff0c7819ULL, 0x000fe40000011670ULL,
0x000000ff70207812ULL, 0x040fe200078ec0ffULL, 0x20000021ff6f7230ULL, 0x000fe20000004100ULL,
0x0000ffff708b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff237819ULL, 0x100fe40000011671ULL,
0x00000018ff6c7819ULL, 0x000fe40000011671ULL, 0x0000ffff718c7812ULL, 0x000fe400078ec0ffULL,
0x0000001cff1c723eULL, 0x000fe400020006ffULL, 0x00000010ff707819ULL, 0x100fe40000011672ULL,
0x000000ff72717812ULL, 0x000fe200078ec0ffULL, 0x2000001cff217230ULL, 0x000fe20000004100ULL,
0x00000018ff037819ULL, 0x010fc40000011672ULL, 0x0000ffff728d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe40000011673ULL, 0x00000003ff03723eULL, 0x000fe400020006ffULL,
0x00000072ff1c723eULL, 0x000fe400020006ffULL, 0x00000018ff807819ULL, 0x008fe20000011679ULL,
0x20000003ff777230ULL, 0x000fe20000004100ULL, 0x000000ff7a847812ULL, 0x000fe200078ec0ffULL,
0x2000001cff7c7230ULL, 0x000fe20000004100ULL, 0x00000080ff03723eULL, 0x000fc400020006ffULL,
0x00000084ff1c723eULL, 0x000fe400020006ffULL, 0x000000ff23237812ULL, 0x000fe200078ec0ffULL,
0x20000003ff847230ULL, 0x000fe20000004100ULL, 0x000000ff73767812ULL, 0x000fe200078ec0ffULL,
0x2000001cff857230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x2000006cff727230ULL, 0x000fe20000004100ULL, 0x00000008ff037819ULL, 0x000fe2000001168bULL,
0x20000023ff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff1c7819ULL, 0x000fc4000001168cULL,
0x00000010ff747819ULL, 0x000fe40000011673ULL, 0x00000010ff7d7819ULL, 0x100fe40000011678ULL,
0x000000ff787f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011678ULL,
0x0000ffff788f7812ULL, 0x000fe200078ec0ffULL, 0x20000076ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fc40000011679ULL, 0x000000ff79827812ULL, 0x040fe400078ec0ffULL,
0x0000ffff79907812ULL, 0x000fe400078ec0ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000018ff797819ULL, 0x000fe4000001167aULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x00000003ff03723eULL, 0x000fc400020006ffULL, 0x0000001cff23723eULL, 0x000fe400020006ffULL,
0x000000ff74767812ULL, 0x000fe200078ec0ffULL, 0x20000003ff1c7230ULL, 0x000fe20000004100ULL,
0x0000ffff738e7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fe2000001168dULL, 0x20000023ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff837819ULL, 0x000fe4000001167aULL, 0x0000ffff7a917812ULL, 0x000fc400078ec0ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001167bULL, 0x20000079ff887230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000074ff03723eULL, 0x000fe200020006ffULL,
0x20000070ff747230ULL, 0x000fe20000004100ULL, 0x00000008ff237819ULL, 0x000fe2000001168eULL,
0x20000076ff797230ULL, 0x000fe20000004100ULL, 0x000000ff0c0c7812ULL, 0x000fe200078ec0ffULL,
0x20000003ff767230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x00000008ff707819ULL, 0x000fe20000011690ULL,
0x2000007aff8a7230ULL, 0x000fe20000004100ULL, 0x0000000cff0c723eULL, 0x000fe200020006ffULL,
0x20000023ff7a7230ULL, 0x000fe20000004100ULL, 0x00000008ff037819ULL, 0x000fe4000001168fULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000000cff0c7230ULL, 0x000fe20000004100ULL,
0x000000ff7b867812ULL, 0x000fc400078ec0ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000003ff03723eULL, 0x000fe400020006ffULL, 0x000000ff83237812ULL, 0x000fe200078ec0ffULL,
0x20000070ff837230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe200020006ffULL,
0x2000007eff807230ULL, 0x000fe20000004100ULL, 0x00000010ff877819ULL, 0x000fe2000001167bULL,
0x20000003ff7e7230ULL, 0x000fe20000004100ULL, 0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x0000ffff7b7b7812ULL, 0x000fc400078ec0ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000023ff70723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x20000086ff897230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000070ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fe20000011621ULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff037819ULL, 0x000fe2000001160cULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fc4000001161cULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0c7819ULL, 0x000fe40000011691ULL,
0x00000008ff7b7819ULL, 0x000fe4000001167bULL, 0x0000105423707816ULL, 0x000fe4000000001cULL,
0x00000082ff82723eULL, 0x000fc400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000010ff207819ULL, 0x000fe20000011620ULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fe2000001166fULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000000cff23723eULL, 0x000fc400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x20000023ff237230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x0000105403207816ULL, 0x000fc40000000020ULL, 0x000010546c217816ULL, 0x000fe2000000006fULL,
0x20000087ff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff777819ULL, 0x000fe20000011677ULL,
0x000000206864723cULL, 0x000f620000041864ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff037819ULL, 0x000fc4000001167cULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x000000202444723cULL, 0x000f620000041844ULL,
0x00000010ff0c7819ULL, 0x000fe4000001167dULL, 0x0000105472717816ULL, 0x000fe40000000071ULL,
0x0000105474727816ULL, 0x000fe40000000073ULL, 0x0000105479737816ULL, 0x000fc40000000078ULL,
0x0000105477767816ULL, 0x000fe20000000076ULL, 0x000000706860723cULL, 0x040f620000041860ULL,
0x0000105403777816ULL, 0x000fe4000000007aULL, 0x000010540c787816ULL, 0x000fe4000000007fULL,
0x00000010ff797819ULL, 0x000fe40000011682ULL, 0x00000010ff1c7819ULL, 0x000fe20000011681ULL,
0x00000072685c723cULL, 0x000f62000004185cULL, 0x00000010ff037819ULL, 0x000fc40000011680ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff7f7819ULL, 0x000fe20000011683ULL, 0x000000766858723cULL, 0x000f620000041858ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff877819ULL, 0x000fc40000011689ULL, 0x00000010ff6c7819ULL, 0x000fe2000001166cULL,
0x000000702440723cULL, 0x040f620000041840ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff7b7819ULL, 0x000fe2000001167bULL, 0x00000072243c723cULL, 0x000f62000004183cULL,
0x000010541c797816ULL, 0x000fc40000000079ULL, 0x00001054037e7816ULL, 0x000fe2000000007eULL,
0x000000101d037824ULL, 0x000fe200078e020bULL, 0x00001054847f7816ULL, 0x000fe4000000007fULL,
0x0000105486867816ULL, 0x000fe20000000085ULL, 0x000000786854723cULL, 0x000f620000041854ULL,
0x000010546c877816ULL, 0x000fe40000000087ULL, 0x0000105488887816ULL, 0x000fe40000000023ULL,
0x000010548a897816ULL, 0x000fc6000000007bULL, 0x0000007e6850723cULL, 0x040f700000041850ULL,
0x00000086684c723cULL, 0x040f70000004184cULL, 0x000000886848723cULL, 0x000b6e0000041848ULL,
0x000000101f687824ULL, 0x020fe200078e0200ULL, 0x000000762438723cULL, 0x040f620000041838ULL,
0x000000001e1c783bULL, 0x000e6e0000000200ULL, 0x000000782434723cULL, 0x040f700000041834ULL,
0x0000007e2430723cULL, 0x040f700000041830ULL, 0x00000086242c723cULL, 0x040f70000004182cULL,
0x000000882428723cULL, 0x000b640000041828ULL, 0x000000000324783bULL, 0x0206a20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000724247231ULL, 0x084fe400003400ffULL, 0x0000000726267231ULL, 0x000fc400003400ffULL,
0x0000000625257231ULL, 0x080fe400003400ffULL, 0x0000000627277231ULL, 0x000fe400003400ffULL,
0x000000051c1c7231ULL, 0x082fe400003400ffULL, 0x000000051e1e7231ULL, 0x000fe400003400ffULL,
0x000000041d1d7231ULL, 0x080fe400003400ffULL, 0x000000041f1f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802037824ULL, 0x048fe200078e00ffULL,
0x000000006868783bULL, 0x000ee20000004200ULL, 0x0000000102027824ULL, 0x000fca00078e020aULL,
0xfffffff803037812ULL, 0x000fca00078ee202ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000370783bULL, 0x0008a20000004200ULL, 0x00000018ff027819ULL, 0x108fe40000011668ULL,
0x00000010ff007819ULL, 0x000fe40000011668ULL, 0x000000ff680a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff68837812ULL, 0x000fe400078ec0ffULL, 0x00000002ff02723eULL, 0x000fe400020006ffULL,
0x00000010ff237819ULL, 0x000fc4000001166aULL, 0x000000ff6a687812ULL, 0x040fe200078ec0ffULL,
0x20000002ff037230ULL, 0x010fe20000004100ULL, 0x00000018ff217819ULL, 0x000fe4000001166aULL,
0x0000ffff6a857812ULL, 0x000fe400078ec0ffULL, 0x000000ff6b6a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff0c7819ULL, 0x000fe40000011669ULL, 0x0000006aff02723eULL, 0x000fc400020006ffULL,
0x00000018ff787819ULL, 0x004fe40000011671ULL, 0x00000010ff0b7819ULL, 0x000fe40000011669ULL,
0x000000ff69207812ULL, 0x040fe400078ec0ffULL, 0x0000ffff69847812ULL, 0x000fe400078ec0ffULL,
0x00000018ff697819ULL, 0x000fe4000001166bULL, 0x00000010ff747819ULL, 0x000fc40000011670ULL,
0x000000ff70777812ULL, 0x040fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe40000011670ULL,
0x0000ffff70877812ULL, 0x000fe200078ec0ffULL, 0x20000002ff707230ULL, 0x000fe20000004100ULL,
0x0000000cff0c723eULL, 0x000fe400020006ffULL, 0x000000ff727c7812ULL, 0x000fe400078ec0ffULL,
0x00000078ff02723eULL, 0x000fc400020006ffULL, 0x00000010ff6c7819ULL, 0x000fe4000001166bULL,
0x0000ffff6b867812ULL, 0x000fe400078ec0ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000069ff6b723eULL, 0x000fe200020006ffULL, 0x2000000cff697230ULL, 0x000fe20000004100ULL,
0x0000007cff0c723eULL, 0x000fe200020006ffULL, 0x20000002ff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x20000021ff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff027819ULL, 0x000fe20000011683ULL, 0x2000000cff7d7230ULL, 0x000fe20000004100ULL,
0x00000008ff217819ULL, 0x000fc40000011684ULL, 0x00000010ff797819ULL, 0x000fe40000011671ULL,
0x000000ff717a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff71887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7b7819ULL, 0x100fe40000011672ULL, 0x00000018ff717819ULL, 0x000fe40000011672ULL,
0x0000ffff72897812ULL, 0x000fc400078ec0ffULL, 0x0000000bff0b723eULL, 0x000fe400020006ffULL,
0x00000010ff7f7819ULL, 0x100fe40000011673ULL, 0x000000ff737e7812ULL, 0x040fe200078ec0ffULL,
0x2000000bff0c7230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe40000011673ULL,
0x0000ffff738a7812ULL, 0x000fe200078ec0ffULL, 0x2000006bff737230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fc400020006ffULL, 0x00000002ff02723eULL, 0x000fe400020006ffULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x20000068ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000002ff0b7230ULL, 0x000fe20000004100ULL,
0x00000008ff6b7819ULL, 0x000fe20000011685ULL, 0x20000021ff687230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x000000ff23237812ULL, 0x000fc400078ec0ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000071ff807230ULL, 0x000fe20000004100ULL,
0x0000006bff02723eULL, 0x000fe400020006ffULL, 0x00000008ff217819ULL, 0x000fe20000011686ULL,
0x2000006cff717230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x20000002ff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff00007812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000023ff6b7230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fc400020006ffULL, 0x0000000aff0a723eULL, 0x000fe200020006ffULL,
0x20000072ff827230ULL, 0x000fe20000004100ULL, 0x00000008ff027819ULL, 0x000fe20000011687ULL,
0x20000021ff727230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x2000000aff0a7230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000008ff237819ULL, 0x000fe20000011688ULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000020ff207230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x00000002ff02723eULL, 0x000fe200020006ffULL,
0x20000076ff787230ULL, 0x000fe20000004100ULL, 0x000000ff7b217812ULL, 0x000fe200078ec0ffULL,
0x2000007eff817230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x20000002ff767230ULL, 0x000fe20000004100ULL, 0x000000ff79797812ULL, 0x000fe400078ec0ffULL,
0x00000021ff7e723eULL, 0x000fe200020006ffULL, 0x20000023ff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff027819ULL, 0x000fc4000001160aULL, 0x00000010ff217819ULL, 0x000fe20000011603ULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff037819ULL, 0x000fe40000011600ULL,
0x00000010ff0a7819ULL, 0x000fe4000001160bULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000010ff207819ULL, 0x000fe20000011620ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff237819ULL, 0x000fe2000001160cULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fc40000011669ULL,
0x00000010ff0b7819ULL, 0x000fe40000011668ULL, 0x0000105403027816ULL, 0x000fe40000000002ULL,
0x0000105423037816ULL, 0x000fe40000000020ULL, 0x00001054000b7816ULL, 0x000fe4000000000bULL,
0x00000010ff207819ULL, 0x000fe4000001166aULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000022464723cULL, 0x000b620000041864ULL, 0x00000010ff007819ULL, 0x000fc40000011673ULL,
0x00000010ff697819ULL, 0x000fe40000011672ULL, 0x00001054210a7816ULL, 0x000fe4000000000aULL,
0x000010546b207816ULL, 0x000fe20000000020ULL, 0x000000021c44723cULL, 0x002b620000041844ULL,
0x0000105400697816ULL, 0x000fe40000000069ULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff217819ULL, 0x000fc40000011670ULL, 0x00000010ff0c7819ULL, 0x000fe20000011671ULL,
0x0000000a2460723cULL, 0x080b620000041860ULL, 0x00000010ff6b7819ULL, 0x000fe4000001167aULL,
0x00000010ff007819ULL, 0x000fe40000011679ULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x0000000a1c40723cULL, 0x000b620000041840ULL,
0x000010540c217816ULL, 0x000fe20000000021ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00001054006b7816ULL, 0x000fe2000000006bULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000008ff0c7819ULL, 0x000fc40000011689ULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x00000020245c723cULL, 0x080b62000004185cULL, 0x00000008ff007819ULL, 0x000fe4000001168aULL,
0x0000000cff0c723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x2000000cff0c7230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fe2000001166cULL, 0x2000007fff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x000000201c3c723cULL, 0x000b62000004183cULL,
0x00000010ff237819ULL, 0x000fc40000011678ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00001054746a7816ULL, 0x000fe40000000077ULL, 0x0000105423767816ULL, 0x000fe40000000076ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x0000006a2454723cULL, 0x000b620000041854ULL, 0x00000010ff777819ULL, 0x000fc4000001167bULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff7f7819ULL, 0x000fe20000011681ULL, 0x0000006a1c34723cULL, 0x000b620000041834ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff237819ULL, 0x000fe40000011680ULL,
0x00000010ff0c7819ULL, 0x000fc4000001160cULL, 0x00000010ff717819ULL, 0x000fe40000011682ULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x000010546f687816ULL, 0x000fe40000000068ULL,
0x000010547c777816ULL, 0x000fe40000000077ULL, 0x000010547e7e7816ULL, 0x000fe4000000007dULL,
0x000010546c7f7816ULL, 0x000fe2000000007fULL, 0x000000682458723cULL, 0x000b620000041858ULL,
0x0000105423707816ULL, 0x000fc4000000000cULL, 0x0000105471717816ULL, 0x000fca0000000000ULL,
0x000000762450723cULL, 0x040b700000041850ULL, 0x0000007e244c723cULL, 0x040b70000004184cULL,
0x000000702448723cULL, 0x000b700000041848ULL, 0x000000681c38723cULL, 0x040b700000041838ULL,
0x000000761c30723cULL, 0x040b700000041830ULL, 0x0000007e1c2c723cULL, 0x040b70000004182cULL,
0x000000701c28723cULL, 0x000b620000041828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x000000000d027f8cULL, 0x0202a2000c80043fULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x000126a0100a7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000aff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x004fe200078e0003ULL,
0x0000001000002944ULL, 0x000fe20003c00000ULL, 0xffff313000007947ULL, 0x000fea000383ffffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff0f7224ULL, 0x000fe400078e002bULL,
0x000000ffff687224ULL, 0x000fe400078e002aULL, 0x000000ffff0d7224ULL, 0x002fe400078e002fULL,
0x000000ffff247224ULL, 0x000fc400078e002eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0033ULL,
0x000000ffff207224ULL, 0x000fe400078e0032ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000e7f000047802ULL, 0x000fc40000000f00ULL,
0x0000ad9000007944ULL, 0x00cfea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002200037308ULL, 0x004e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000022ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006b00ff037624ULL, 0x000fe400078e00ffULL,
0x00006a00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000087919ULL, 0x000e680000000000ULL, 0x0000000000047919ULL, 0x000ee20000000000ULL,
0x0000001808057811ULL, 0x042fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x008fe40000011604ULL, 0x0000001008157811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x014fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f1506027589ULL, 0x000f2200000e0000ULL, 0x0000006400647220ULL, 0x042fe20000410000ULL,
0x0000006500657220ULL, 0x040fe20000410000ULL, 0x0000006000607220ULL, 0x040fe20000410000ULL,
0x0000006100617220ULL, 0x040fe20000410000ULL, 0x0000005c005c7220ULL, 0x040fe20000410000ULL,
0x0000005d005d7220ULL, 0x040fe20000410000ULL, 0x0000005800587220ULL, 0x040fe20000410000ULL,
0x0000005900597220ULL, 0x040fe20000410000ULL, 0x0000005400547220ULL, 0x040fe20000410000ULL,
0x0000005500557220ULL, 0x040fe20000410000ULL, 0x0000005000507220ULL, 0x040fe20000410000ULL,
0x0000005100517220ULL, 0x040fe20000410000ULL, 0x0000004c004c7220ULL, 0x040fe20000410000ULL,
0x0000004d004d7220ULL, 0x040fe20000410000ULL, 0x0000004800487220ULL, 0x040fe20000410000ULL,
0x0000004900497220ULL, 0x000fe20000410000ULL, 0x0000004605467220ULL, 0x044fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000000b050b7220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000006805687220ULL, 0x040fe20000410000ULL,
0x0000000f050f7220ULL, 0x000fe20000410000ULL, 0x0000000466667220ULL, 0x088fe20000410000ULL,
0x0000000467677220ULL, 0x080fe20000410000ULL, 0x0000000462627220ULL, 0x080fe20000410000ULL,
0x0000000463637220ULL, 0x080fe20000410000ULL, 0x000000045e5e7220ULL, 0x080fe20000410000ULL,
0x000000045f5f7220ULL, 0x080fe20000410000ULL, 0x000000045a5a7220ULL, 0x080fe20000410000ULL,
0x000000045b5b7220ULL, 0x080fe20000410000ULL, 0x0000000456567220ULL, 0x080fe20000410000ULL,
0x0000000457577220ULL, 0x080fe20000410000ULL, 0x0000000452527220ULL, 0x080fe20000410000ULL,
0x0000000453537220ULL, 0x080fe20000410000ULL, 0x000000044e4e7220ULL, 0x080fe20000410000ULL,
0x000000044f4f7220ULL, 0x080fe20000410000ULL, 0x000000044a4a7220ULL, 0x080fe20000410000ULL,
0x000000044b4b7220ULL, 0x000fe20000410000ULL, 0x0000000244447220ULL, 0x090fe20000410000ULL,
0x0000000245457220ULL, 0x080fe20000410000ULL, 0x0000000240407220ULL, 0x080fe20000410000ULL,
0x0000000241417220ULL, 0x080fe20000410000ULL, 0x000000023c3c7220ULL, 0x080fe20000410000ULL,
0x000000023d3d7220ULL, 0x080fe20000410000ULL, 0x0000000238387220ULL, 0x080fe20000410000ULL,
0x0000000239397220ULL, 0x080fe20000410000ULL, 0x0000000234347220ULL, 0x080fe20000410000ULL,
0x0000000235357220ULL, 0x080fe20000410000ULL, 0x0000000230307220ULL, 0x080fe20000410000ULL,
0x0000000231317220ULL, 0x080fe20000410000ULL, 0x000000022c2c7220ULL, 0x080fe20000410000ULL,
0x000000022d2d7220ULL, 0x080fe20000410000ULL, 0x0000000228287220ULL, 0x080fe20000410000ULL,
0x0000000229297220ULL, 0x000fc20000410000ULL, 0x0000000000037919ULL, 0x004e620000000000ULL,
0x000000666766723eULL, 0x000fc400000010ffULL, 0x000000626333723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000005e5f5e723eULL, 0x000fe400000010ffULL,
0x0000005a5b2f723eULL, 0x000fe400000010ffULL, 0x000000565756723eULL, 0x000fc400000010ffULL,
0x00000052532b723eULL, 0x000fe400000010ffULL, 0x0000004e4f4e723eULL, 0x000fe400000010ffULL,
0x0000004a4b27723eULL, 0x000fe400000010ffULL, 0x0000541066327816ULL, 0x000fe40000000033ULL,
0x0000000803057811ULL, 0x042fe400078ff0ffULL, 0x0000001003097811ULL, 0x000fc400078ff0ffULL,
0x0000000203007812ULL, 0x000fe200078ec0ffULL, 0x0000000805177824ULL, 0x000fe200078e00ffULL,
0x00000002ff077819ULL, 0x000fe20000011603ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000001803157811ULL, 0x000fe400078ff0ffULL, 0x0000000500047211ULL, 0x040fe200078ff8ffULL,
0x00000008070e7824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x040fe400078ff8ffULL,
0x0000000900057211ULL, 0x040fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000001500067211ULL, 0x000fe200078ff8ffULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x0000000202007810ULL, 0x000fc40007ffe0ffULL, 0xfffffff812127812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe200078ee200ULL,
0x0000200011007824ULL, 0x000fe200078e00ffULL, 0xfffffff8170a7812ULL, 0x008fe400078ee204ULL,
0xfffffff815147812ULL, 0x000fe400078ee206ULL, 0xfffffff805047812ULL, 0x000fe200078ee202ULL,
0x0000100013057824ULL, 0x000fe200078e0200ULL, 0x0000000402067810ULL, 0x000fc40007ffe0ffULL,
0x0000000602077810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff8090c7812ULL, 0x000fe200078ee206ULL, 0x0000001004067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x000000100a107824ULL, 0x100fe200078e0205ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x000000646502723eULL, 0x000fe200000010ffULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0x000000606104723eULL, 0x000fe200000010ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000505106723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x00005410021c7816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x00007632021d7816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x0000005c5d02723eULL, 0x000fe200000010ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000585904723eULL, 0x000fe200000010ffULL, 0x0000001c08007388ULL, 0x0003e20000000a00ULL,
0x000000545505723eULL, 0x000fe200000010ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x000000444544723eULL, 0x000fe200000010ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000404122723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000763266337816ULL, 0x000fe20000000033ULL, 0x00000001070c7824ULL, 0x040fe200078e020cULL,
0x000054105e2e7816ULL, 0x000fe2000000002fULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x0000004c4d07723eULL, 0x000fc400000010ffULL, 0x000000484908723eULL, 0x002fe400000010ffULL,
0x00005410021c7816ULL, 0x140fe40000000004ULL, 0x00007632021d7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000001c0a007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040c007388ULL, 0x000fe20000000a00ULL,
0x0000003c3d3c723eULL, 0x000fe400000010ffULL, 0x00000038391e723eULL, 0x000fe200000010ffULL,
0x000000060e007388ULL, 0x0003e20000000a00ULL, 0x000076325e2f7816ULL, 0x000fe4000000002fULL,
0x00005410562a7816ULL, 0x140fe2000000002bULL, 0x0000003210007388ULL, 0x000fe20000000a00ULL,
0x00007632562b7816ULL, 0x000fc4000000002bULL, 0x000054104e267816ULL, 0x140fe20000000027ULL,
0x0004002e0a007388ULL, 0x000fe20000000a00ULL, 0x000076324e277816ULL, 0x000fe40000000027ULL,
0x000054103c087816ULL, 0x000fe2000000001eULL, 0x0004002a0c007388ULL, 0x000fe20000000a00ULL,
0x0000541044067816ULL, 0x142fe40000000022ULL, 0x0000763244077816ULL, 0x000fe20000000022ULL,
0x000400260e007388ULL, 0x000fe20000000a00ULL, 0x000076323c097816ULL, 0x000fc4000000001eULL,
0x000000343534723eULL, 0x000fe200000010ffULL, 0x0000000612007388ULL, 0x0003e20000000a00ULL,
0x00000030311a723eULL, 0x000fe400000010ffULL, 0x0000002c2d2c723eULL, 0x000fe200000010ffULL,
0x000800080a007388ULL, 0x0005e20000000a00ULL, 0x000000282916723eULL, 0x000fe400000010ffULL,
0x000000464702723eULL, 0x000fe400000010ffULL, 0x000000424304723eULL, 0x000fc400000010ffULL,
0x0000003e3f05723eULL, 0x000fe200000010ffULL, 0x000000016e077824ULL, 0x002fe200078e0203ULL,
0x0000003a3b06723eULL, 0x000fe400000010ffULL, 0x0000541034087816ULL, 0x044fe2000000001aULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x0000763234097816ULL, 0x000fca000000001aULL,
0x000800080c007388ULL, 0x0003e40000000a00ULL, 0x000054102c087816ULL, 0x142fe40000000016ULL,
0x000076322c097816ULL, 0x000fca0000000016ULL, 0x000800080e007388ULL, 0x0003e40000000a00ULL,
0x0000541002087816ULL, 0x142fe40000000004ULL, 0x0000763202097816ULL, 0x000fe40000000004ULL,
0x000000363702723eULL, 0x000fe400000010ffULL, 0x000000200b04723eULL, 0x000fe200000010ffULL,
0x0000000814007388ULL, 0x0003e60000000a00ULL, 0x00005410021c7816ULL, 0x000fc40000000004ULL,
0x00007632021d7816ULL, 0x000fe40000000004ULL, 0x000000ff00027306ULL, 0x000fe20000205400ULL,
0x0000541005087816ULL, 0x142fe40000000006ULL, 0x0000763205097816ULL, 0x000fe40000000006ULL,
0x000000240d05723eULL, 0x000fe400000010ffULL, 0x000000680f06723eULL, 0x000fe200000010ffULL,
0x000c00080a007388ULL, 0x000fe60000000a00ULL, 0x00007632050d7816ULL, 0x140fe20000000006ULL,
0x000c001c0c007388ULL, 0x0003e40000000a00ULL, 0x00005410050c7816ULL, 0x002fc40000000006ULL,
0x000000ff00057306ULL, 0x000e660000209400ULL, 0x000c000c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000007087984ULL, 0x000ea20000000c00ULL,
0x000000020500720bULL, 0x002fc60003f1d000ULL, 0x00040000071c7984ULL, 0x000e620000000c00ULL,
0x000000ff00027245ULL, 0x000fc6000020d400ULL, 0x0008000007247984ULL, 0x000ee80000000c00ULL,
0x000c0000072c7984ULL, 0x000f280000000c00ULL, 0x0010000007147984ULL, 0x000ee20000000c00ULL,
0x0000000102020812ULL, 0x000fe400078efcffULL, 0x000000ff1300720cULL, 0x000fe20003f05270ULL,
0x0014000007207984ULL, 0x000f220000000c00ULL, 0x000000020204723eULL, 0x000fc600000010ffULL,
0x0018000007287984ULL, 0x000f280000000c00ULL, 0x001c0000070c7984ULL, 0x000f220000000c00ULL,
0x3f803f80040b7831ULL, 0x044fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fc40000200008ULL,
0x3f803f80041f7831ULL, 0x042fe4000020001fULL, 0x3f803f80041e7831ULL, 0x040fe4000020001eULL,
0x3f803f80041d7831ULL, 0x040fe4000020001dULL, 0x3f803f80041c7831ULL, 0x040fe4000020001cULL,
0x3f803f8004277831ULL, 0x048fe40000200027ULL, 0x3f803f8004267831ULL, 0x000fc40000200026ULL,
0x3f803f8004257831ULL, 0x040fe40000200025ULL, 0x3f803f8004247831ULL, 0x040fe40000200024ULL,
0x3f803f80042f7831ULL, 0x050fe4000020002fULL, 0x3f803f80042e7831ULL, 0x040fe4000020002eULL,
0x3f803f80042d7831ULL, 0x040fe4000020002dULL, 0x3f803f80042c7831ULL, 0x000fc4000020002cULL,
0x3f803f800b0b7831ULL, 0x000fe40000200017ULL, 0x3f803f800a0a7831ULL, 0x000fe40000200016ULL,
0x3f803f8009097831ULL, 0x000fe40000200015ULL, 0x3f803f8008087831ULL, 0x000fe40000200014ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000000807007388ULL, 0x000fe20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fc40000200021ULL,
0x3f803f801c1c7831ULL, 0x000fe40000200020ULL, 0x3f803f8027277831ULL, 0x000fe4000020002bULL,
0x3f803f8026267831ULL, 0x000fe2000020002aULL, 0x0004001c07007388ULL, 0x000fe20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200029ULL, 0x3f803f8024247831ULL, 0x000fe40000200028ULL,
0x3f803f802f2f7831ULL, 0x000fc4000020000fULL, 0x3f803f802e2e7831ULL, 0x000fe2000020000eULL,
0x0008002407007388ULL, 0x000fe20000000c00ULL, 0x3f803f802d2d7831ULL, 0x000fe4000020000dULL,
0x3f803f802c2c7831ULL, 0x000fca000020000cULL, 0x000c002c07007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x000000190400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x0000000104027824ULL, 0x000fe200078e0203ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00000007030e7812ULL, 0x000fe200078ec0ffULL, 0x00005a0000067ab9ULL, 0x000fe40000000800ULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fc6000800063fULL,
0x0ffffff802057812ULL, 0x000fe200078ef803ULL, 0x000000201b027824ULL, 0x000fe200078e0204ULL,
0x0000580000067ab9ULL, 0x000fc60000000800ULL, 0x0000001005057824ULL, 0x000fe200078e0200ULL,
0x0000000502077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000005087984ULL, 0x0004e20000000c00ULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0x00000006040472a4ULL, 0x002fc6000f8e023fULL, 0x0000007502077224ULL, 0x000fe200078e0207ULL,
0x0000002003027810ULL, 0x000fe40007ffe0ffULL, 0x0000000475067c24ULL, 0x000fca000f8e02ffULL,
0x0000000706077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0007047a11ULL, 0x000fc800078040ffULL, 0x00005d0007057a11ULL, 0x004fe200000f440cULL,
0x0000000811077824ULL, 0x000fe200078e020eULL, 0x00000003ff0c7819ULL, 0x000fc60000011602ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190c00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0083f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x102fe400078e020cULL, 0x000000201b0c7824ULL, 0x000fc600078e020cULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x000000050c057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000750c057224ULL, 0x000fe200078e0205ULL, 0x00000040030c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000811077824ULL, 0x002fc600078e0202ULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x00000060030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x002fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001005027824ULL, 0x000fe200078e0200ULL, 0x000000050e057c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000750e057224ULL, 0x000fe200078e0205ULL, 0x00000003ff027819ULL, 0x002fc8000001160dULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000190200720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e0202ULL, 0x00000080030c7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b027824ULL, 0x000fc600078e0202ULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804057812ULL, 0x000fca00078ef80dULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x0000007502057224ULL, 0x000fe200078e0205ULL, 0x000000070d027812ULL, 0x000fc800078ec0ffULL,
0x0000000506057210ULL, 0x000fe20007f1e0ffULL, 0x0000000811077824ULL, 0x002fc800078e0202ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x000000a0030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x002fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001005027824ULL, 0x000fe200078e0200ULL, 0x000000050e057c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000750e057224ULL, 0x000fe200078e0205ULL, 0x00000003ff027819ULL, 0x002fc8000001160dULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000190200720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e0202ULL, 0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b027824ULL, 0x000fc600078e0202ULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804057812ULL, 0x000fca00078ef80dULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x0000007502057224ULL, 0x000fe200078e0205ULL, 0x000000070d027812ULL, 0x000fc800078ec0ffULL,
0x0000000506057210ULL, 0x000fe20007f1e0ffULL, 0x0000000811077824ULL, 0x002fc800078e0202ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x000000e003047810ULL, 0x002fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x000000050e077c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x00005a00ff0e7a19ULL, 0x000fe2000001160eULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x000fe400078e0200ULL,
0x000000750e077224ULL, 0x000fe200078e0207ULL, 0x00000003ff0e7819ULL, 0x000fc40000011604ULL,
0x0000000005087984ULL, 0x0002a40000000c00ULL, 0x0000000706077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fe200078040ffULL,
0x0000000811057824ULL, 0x002fc600078e020cULL, 0x00005d0007037a11ULL, 0x000fe200000f4410ULL,
0x0000000104077824ULL, 0x000fe200078e020eULL, 0x000000190e00720cULL, 0x000fc60003f06070ULL,
0x0000001005027825ULL, 0x000fe200078e0002ULL, 0x0000000707077812ULL, 0x000fc800078ec0ffULL,
0xfffffff807077812ULL, 0x000fe200078ef804ULL, 0x0000000802007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000007087984ULL, 0x002e620000000c00ULL, 0x0000000811117824ULL, 0x000fe200078e0204ULL,
0x000000050e037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0e7a19ULL, 0x000fc6000001160eULL,
0x0000000118037824ULL, 0x000fc800078e0203ULL, 0x000000750e037224ULL, 0x000fca00078e0203ULL,
0x0000000306037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x0000001011027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006a00ff027624ULL, 0x000fe400078e00ffULL,
0x00006b00ff037624ULL, 0x000fca00078e00ffULL, 0x00000008026b7981ULL, 0x000522000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x000000020e097824ULL, 0x000fe200078e00ffULL, 0x01260000ff067f8cULL, 0x002e62000c80043fULL,
0x000000401a037824ULL, 0x004fe400078e00ffULL, 0x0000590009027a24ULL, 0x000fc800078e0212ULL,
0x0000660002147a24ULL, 0x000fc800078e0203ULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x000fe40000011617ULL, 0x0000001717127211ULL, 0x000fe400078fe8ffULL,
0x0000000821137810ULL, 0x040fe20007ffe0ffULL, 0x0000000114087824ULL, 0x000fe200078e0221ULL,
0x0000001821237810ULL, 0x040fe40007ffe0ffULL, 0x0000001021227810ULL, 0x040fe20007ffe0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x00000020211d7810ULL, 0x000fc40007ffe0ffULL,
0x00000003121c7812ULL, 0x000fe200078ec0ffULL, 0x00000001140a7824ULL, 0x000fe200078e0213ULL,
0x0000003008107812ULL, 0x000fe200078ef804ULL, 0x00000001140e7824ULL, 0x000fe200078e0223ULL,
0x0000000316087217ULL, 0x000fe20007800000ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe40007f1e0ffULL, 0x00000028211f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001140c7824ULL, 0x040fe200078e0222ULL, 0x0000630009117a10ULL, 0x000fe200007fe4ffULL,
0x0000000114097824ULL, 0x000fe200078e021dULL, 0x000000300a0a7812ULL, 0x000fe200078ef804ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000020001a1e7811ULL, 0x000fc400078e68ffULL,
0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000108057824ULL, 0x000fe200078e0a03ULL,
0x000000300e0e7812ULL, 0x100fe200078ef804ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000063000b0b7a10ULL, 0x000fe40000ffe4ffULL, 0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x100fe400078ef804ULL,
0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000413197824ULL, 0x000fe200078e00ffULL,
0x0000003008127812ULL, 0x000fe200078ef804ULL, 0x0000000114087824ULL, 0x000fe200078e021fULL,
0x000062000c0c7a10ULL, 0x000fc40007f1e0ffULL, 0x0000620012127a10ULL, 0x000fe40007f5e0ffULL,
0x000000051300720cULL, 0x080fe40003f26070ULL, 0x000063000d0d7a10ULL, 0x000fe400007fe4ffULL,
0x0000630009137a10ULL, 0x000fe200017fe4ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000052100720cULL, 0x000fe40003f06070ULL, 0x0ffffffc1c177812ULL, 0x000fc400078ef817ULL,
0xfffffffc19197812ULL, 0x000fe400078ee21cULL, 0x0000003021207810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e021eULL, 0x0000003008187812ULL, 0x000fe200078ef804ULL,
0x00000010191b7824ULL, 0x000fe200078e021eULL, 0x0000003821217810ULL, 0x000fe20007ffe0ffULL,
0x0000000114087824ULL, 0x000fe200078e0220ULL, 0x0000620018187a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0005e2000c101c48ULL,
0x000000052200720cULL, 0x000fc40003fa6070ULL, 0x0000630009197a10ULL, 0x000fe200037fe4ffULL,
0x000000000a1b7faeULL, 0x0007e2000c901c48ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000052300720cULL, 0x080fe40003f86070ULL, 0x000000051d00720cULL, 0x080fe40003f66070ULL,
0x000000051f00720cULL, 0x080fe40003f46070ULL, 0x000000052000720cULL, 0x080fe20003f26070ULL,
0x0000000423177824ULL, 0x004fe200078e00ffULL, 0x000000052100720cULL, 0x000fe20003f06070ULL,
0x0000000422057824ULL, 0x000fe200078e00ffULL, 0x0000003008087812ULL, 0x000fe200078ef804ULL,
0x00000001140a7824ULL, 0x008fe200078e0221ULL, 0xfffffffc17177812ULL, 0x100fe200078ee21cULL,
0x000000041d1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc05057812ULL, 0x000fe200078ee21cULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000620008087a10ULL, 0x000fc40007fde0ffULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee21cULL, 0x000000041f1d7824ULL, 0x000fe200078e00ffULL,
0x000000300a047812ULL, 0x000fe200078ef804ULL, 0x00000004201f7824ULL, 0x000fe200078e00ffULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x0000000421217824ULL, 0x000fe200078e00ffULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee21cULL, 0x0000001005117824ULL, 0x000fe200078e021eULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee21cULL, 0x0000001017177824ULL, 0x000fe200078e021eULL,
0xfffffffc21217812ULL, 0x000fe200078ee21cULL, 0x000000101b1b7824ULL, 0x100fe200078e021eULL,
0x0000620004047a10ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e021eULL,
0x000000000c117faeULL, 0x0005e2000e901c48ULL, 0x000000101f1f7824ULL, 0x100fe200078e021eULL,
0x000063000b057a10ULL, 0x000fe200037fe4ffULL, 0x0000001021217824ULL, 0x000fe200078e021eULL,
0x000000000e177faeULL, 0x0005e8000e101c48ULL, 0x00000000121b7faeULL, 0x0005e8000d901c48ULL,
0x00000000181d7faeULL, 0x0005e8000d101c48ULL, 0x00000000081f7faeULL, 0x0005e8000c901c48ULL,
0x0000000004217faeULL, 0x0005e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000001017117811ULL, 0x040fe400078ff0ffULL, 0x0000001817137811ULL, 0x000fc400078ff0ffULL,
0x00000017170a7211ULL, 0x040fe200078fe8ffULL, 0x00000001140c7824ULL, 0x040fe200078e0211ULL,
0x00000008170f7811ULL, 0x000fe200078ff0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x00000030170b7811ULL, 0x040fe200078ff0ffULL, 0x00000001140e7824ULL, 0x040fe200078e0213ULL,
0x0000002017057811ULL, 0x000fe200078ff0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x00000038170d7811ULL, 0x040fe200078ff0ffULL, 0x0000000114227824ULL, 0x000fe200078e020bULL,
0x000000030a127812ULL, 0x000fe200078ec0ffULL, 0x00000001140a7824ULL, 0x000fe200078e020fULL,
0x0000002817097811ULL, 0x000fe200078ff0ffULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x0000001417087211ULL, 0x000fe200078ff0ffULL, 0x0000000405197824ULL, 0x000fe200078e00ffULL,
0xfffffffc11107812ULL, 0x100fe200078ee212ULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc12177812ULL, 0x000fe200078ef817ULL, 0x0000000114247824ULL, 0x000fe200078e020dULL,
0xfffffffc13117812ULL, 0x100fe200078ee212ULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0x000020001a267811ULL, 0x000fe200078e68ffULL, 0x00000001141e7824ULL, 0x040fe200078e0205ULL,
0xfffffffc0f057812ULL, 0x100fe200078ee212ULL, 0x0000000114207824ULL, 0x000fe200078e0209ULL,
0xfffffffc19137812ULL, 0x100fe200078ee212ULL, 0x00000004091b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b187812ULL, 0x100fe200078ee212ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc0d197812ULL, 0x000fc400078ee212ULL, 0xfffffffc1b147812ULL, 0x000fe200078ee212ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008127812ULL, 0x000fc600078ef804ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc60007f1e0ffULL,
0x0000001017297824ULL, 0x000fe200078e0226ULL, 0x000000300c1c7812ULL, 0x000fe200078ef804ULL,
0x0000001005177824ULL, 0x000fe200078e0226ULL, 0x000000300a057812ULL, 0x000fe200078ef804ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000062001c1c7a10ULL, 0x000fc60007f5e0ffULL,
0x0000001018257824ULL, 0x100fe200078e0226ULL, 0x0000620005187a10ULL, 0x000fe20007f3e0ffULL,
0x0000001013217824ULL, 0x100fe200078e0226ULL, 0x0000630009137a10ULL, 0x000fe200007fe4ffULL,
0x0000001019277824ULL, 0x000fe200078e0226ULL, 0x000000300e0e7812ULL, 0x100fe200078ef804ULL,
0x000000801e087825ULL, 0x000fe200078e00ffULL, 0x000063000b197a10ULL, 0x000fe20000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012297faeULL, 0x0005e2000b901c48ULL,
0x000063000d1d7a10ULL, 0x000fe200017fe4ffULL, 0x00000080200a7825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000018177faeULL, 0x0005e2000b901c48ULL,
0x0000003008057812ULL, 0x000fe200078ef804ULL, 0x00000010101b7824ULL, 0x000fe200078e0226ULL,
0x000000300a087812ULL, 0x000fe200078ef804ULL, 0x00000010111f7824ULL, 0x000fe200078e0226ULL,
0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x00000080220c7825ULL, 0x000fe200078e00ffULL,
0x0000620008087a10ULL, 0x000fe20007f3e0ffULL, 0x000000001c1b7faeULL, 0x0005e4000b901c48ULL,
0x0000008024107825ULL, 0x000fe200078e00ffULL, 0x000000300c0a7812ULL, 0x000fe200078ef804ULL,
0x000000000e1f7faeULL, 0x0005e4000b901c48ULL, 0x0000001014237824ULL, 0x000fe200078e0226ULL,
0x00000030100c7812ULL, 0x000fc400078ef804ULL, 0x0000620005047a10ULL, 0x000fe40007f1e0ffULL,
0x000062000a0a7a10ULL, 0x000fe40007f5e0ffULL, 0x000062000c0c7a10ULL, 0x000fe40007f7e0ffULL,
0x0000630009057a10ULL, 0x000fe400007fe4ffULL, 0x000063000b097a10ULL, 0x000fe40000ffe4ffULL,
0x000063000d0b7a10ULL, 0x000fe200017fe4ffULL, 0x0000000004217faeULL, 0x0005e2000b901c48ULL,
0x00006300110d7a10ULL, 0x000fc60001ffe4ffULL, 0x0000000008237faeULL, 0x0005e8000b901c48ULL,
0x000000000a257faeULL, 0x0005e8000b901c48ULL, 0x000000000c277faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x004fc40000015200ULL,
0x01260400ff097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x000000201a047824ULL, 0x002fca00078e0205ULL,
0x00000004ff057819ULL, 0x000fe40000011604ULL, 0x0000000104067810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe05077812ULL, 0x000fe400078ec0ffULL, 0x0000001f04057812ULL, 0x000fc600078ec0ffULL,
0x0000000107097824ULL, 0x040fe400078e0206ULL, 0x0000000104087824ULL, 0x000fe200078e0207ULL,
0x0000000807077810ULL, 0x000fe20007ffe0ffULL, 0x00000010050a7824ULL, 0x000fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x00000010050b7824ULL, 0x000fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000001f00a097812ULL, 0x000fe200078ee209ULL, 0x0000000104047824ULL, 0x000fe200078e0207ULL,
0x000001f00b087812ULL, 0x000fe200078ee208ULL, 0x0000001005077824ULL, 0x040fe200078e00ffULL,
0x0000000f06067812ULL, 0x000fe200078ec0ffULL, 0x00000000090c7984ULL, 0x000e62000000cc00ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000f04047812ULL, 0x000fc400078ec0ffULL,
0x0000000008107984ULL, 0x000ea4000000cc00ULL, 0x000001f005067812ULL, 0x000fe400078ee206ULL,
0x000001f007047812ULL, 0x000fe200078ee204ULL, 0x000000ffff1e7224ULL, 0x002fe400078e000cULL,
0x000000ffff1f7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0012ULL, 0x000000ffff227224ULL, 0x000fe400078e000dULL,
0x000000ffff237224ULL, 0x000fe200078e000fULL, 0x0000001c08007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff217224ULL, 0x000fca00078e0013ULL,
0x0000002009007388ULL, 0x000fe8000000cc00ULL, 0x00000000060c7984ULL, 0x000e68000000cc00ULL,
0x0000000004107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002404007388ULL, 0x0003e8000000cc00ULL, 0x0000000c06007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01260000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01260400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000000006d7919ULL, 0x000e620000000000ULL,
0x0000001fff047424ULL, 0x000fe200078e00ffULL, 0x8000580016177a10ULL, 0x000fe20007ffe0ffULL,
0x00000001ff197424ULL, 0x000fe200078e00ffULL, 0x3db504f36b6b7820ULL, 0x010fe20000410000ULL,
0x00005800ff187624ULL, 0x000fe200078e00ffULL, 0x0000580004047a10ULL, 0x000fe20007ffe0ffULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x000126881a6a7811ULL, 0x000fe200078e18ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x000126081a697811ULL, 0x000fe400078e28ffULL, 0x0000580019197a10ULL, 0x000fe40007ffe1ffULL,
0x0000000918187810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff177819ULL, 0x000fe40000011617ULL,
0x0ffffffe04147812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff6f7224ULL, 0x000fe200078e001bULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff6c7224ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x00cfc4000001ff00ULL,
0x000000016c00780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x00000001680c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6e7224ULL, 0x000fe200078e006cULL,
0x000000016c0d7810ULL, 0x000fc40007ffe0ffULL, 0x000000016f1b7812ULL, 0x000fe400078e0cffULL,
0x000000020d00780cULL, 0x000fe20003f06070ULL, 0x000000ffff6c7224ULL, 0x000fc800078e000dULL,
0x000000ffff0c1224ULL, 0x000fc800078e0268ULL, 0x000001000c1f7824ULL, 0x040fe200078e0203ULL,
0x000000010c0e7810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0d0c7207ULL, 0x000fe20000800000ULL,
0x00006600025c7a24ULL, 0x020fe200078e021fULL, 0x000000150e00720cULL, 0x000fda0003f46070ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x000000106d0d7824ULL, 0x002fe200078e00ffULL,
0x00000002ff637819ULL, 0x000fe2000001166dULL, 0x000000021a5b7824ULL, 0x000fe200078e021bULL,
0x0000001f161c7217ULL, 0x000fe40007800000ULL, 0x000000300d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001630f7824ULL, 0x140fe200078e025cULL, 0x0000001863657810ULL, 0x040fe20007ffe0ffULL,
0x000000011c5a7824ULL, 0x000fe200078e0a1fULL, 0x0000000863597810ULL, 0x040fe20007ffe0ffULL,
0x000000400c0c7824ULL, 0x000fe200078e020dULL, 0x00000010635d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000002063677810ULL, 0x000fe20007ffe0ffULL,
0x00000001651d7824ULL, 0x000fe200078e025cULL, 0x000020005b5b7811ULL, 0x000fe200078e60ffULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x0000002863717810ULL, 0x000fc40007ffe0ffULL,
0x0000003063737810ULL, 0x000fe20007ffe0ffULL, 0x0000000159117824ULL, 0x000fe200078e025cULL,
0x000062000e1e7a10ULL, 0x000fe20007f3e0ffULL, 0x000000801d1c7825ULL, 0x000fe200078e000cULL,
0x0000006d6d0e7211ULL, 0x000fe400078fe8ffULL, 0x000063000f1f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000015c137824ULL, 0x000fe200078e025dULL, 0x000062001c1c7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008011107825ULL, 0x000fe200078e000cULL, 0x000000030e5e7812ULL, 0x000fc400078ec0ffULL,
0x000063001d1d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000008013127825ULL, 0x000fe200078e000cULL,
0x0000620010107a10ULL, 0x000fe40007f5e0ffULL, 0x0000005a6300720cULL, 0x080fe20003f26070ULL,
0x00000001670f7824ULL, 0x000fe200078e025cULL, 0x0000620012127a10ULL, 0x000fe20007f7e0ffULL,
0x000000045d5f7824ULL, 0x000fe200078e00ffULL, 0x0000630011117a10ULL, 0x000fe200017fe4ffULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x0000005a5900720cULL, 0x000fc40003f46070ULL,
0x0ffffffc5e607812ULL, 0x000fe200078ef86dULL, 0x0000000459597824ULL, 0x000fe200078e00ffULL,
0x0000630013137a10ULL, 0x000fe40001ffe4ffULL, 0x000062000e587a10ULL, 0x000fe40007f9e0ffULL,
0x0000005a5d00720cULL, 0x000fe20003f66070ULL, 0x00000010605d7824ULL, 0x100fe200078e025bULL,
0xfffffffc590e7812ULL, 0x000fe400078ee25eULL, 0x000063000f597a10ULL, 0x000fe200027fe4ffULL,
0x00000001710f7824ULL, 0x000fe200078e025cULL, 0xfffffffc5f607812ULL, 0x000fe200078ee25eULL,
0x000000100e5f7824ULL, 0x000fe200078e025bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e5d7faeULL, 0x0003e2000c901c48ULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x0000003863637810ULL, 0x000fc40007ffe0ffULL, 0x00000000105f7faeULL, 0x0005e2000d101c48ULL,
0x0000001060617824ULL, 0x000fe200078e025bULL, 0x0000005a6500720cULL, 0x0c0fe20003fa6070ULL,
0x0000000465657824ULL, 0x000fe200078e00ffULL, 0x0000005a6700720cULL, 0x0c0fe20003f86070ULL,
0x0000000467677824ULL, 0x000fe200078e00ffULL, 0x0000000012617faeULL, 0x0007e2000d901c48ULL,
0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x00000001731f7824ULL, 0x102fe200078e025cULL,
0x0000005a7100720cULL, 0x080fe20003f66070ULL, 0x00000001635d7824ULL, 0x000fe200078e025cULL,
0x0000005a7300720cULL, 0x080fe20003f46070ULL, 0x000000801f107825ULL, 0x004fe200078e000cULL,
0x0000005a6300720cULL, 0x000fc40003f26070ULL, 0x000063000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x0000000471717824ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x0000000473737824ULL, 0x000fe200078e00ffULL, 0xfffffffc65127812ULL, 0x108fe200078ee25eULL,
0x0000000463637824ULL, 0x000fe200078e00ffULL, 0xfffffffc671e7812ULL, 0x000fe200078ee25eULL,
0x000000805d0c7825ULL, 0x000fe200078e000cULL, 0xfffffffc715a7812ULL, 0x100fe400078ee25eULL,
0xfffffffc735c7812ULL, 0x100fe200078ee25eULL, 0x0000001012137824ULL, 0x100fe200078e025bULL,
0xfffffffc635e7812ULL, 0x000fe200078ee25eULL, 0x000000101e1f7824ULL, 0x100fe200078e025bULL,
0x0000630011117a10ULL, 0x000fe200037fe4ffULL, 0x000000105a5d7824ULL, 0x100fe200078e025bULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000105c5f7824ULL, 0x100fe200078e025bULL,
0x000000001c137faeULL, 0x0003e2000e901c48ULL, 0x000000105e5b7824ULL, 0x000fe200078e025bULL,
0x000063000d0d7a10ULL, 0x000fc400037fe4ffULL, 0x00000000581f7faeULL, 0x0003e8000e101c48ULL,
0x000000000e5d7faeULL, 0x0003e8000d901c48ULL, 0x00000000105f7faeULL, 0x0003e8000d101c48ULL,
0x000000000c5b7faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x000000106d0d7824ULL, 0x042fe200078e00ffULL, 0x000000106d137811ULL, 0x040fe200078ff0ffULL,
0x000000021a0f7824ULL, 0x000fe200078e021bULL, 0x000000186d1d7811ULL, 0x000fc400078ff0ffULL,
0x000000300d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000113117824ULL, 0x100fe200078e025cULL,
0x000000206d1f7811ULL, 0x000fe200078ff0ffULL, 0x00000004135d7824ULL, 0x000fe200078e00ffULL,
0x000000286d597811ULL, 0x040fe200078ff0ffULL, 0x000000400c5a7824ULL, 0x000fe200078e020dULL,
0x000000086d0d7811ULL, 0x000fe200078ff0ffULL, 0x000000011d137824ULL, 0x100fe200078e025cULL,
0x000000306d5b7811ULL, 0x000fe200078ff0ffULL, 0x000000041d5f7824ULL, 0x000fe200078e00ffULL,
0x000000386d717811ULL, 0x000fe200078ff0ffULL, 0x000000011f1d7824ULL, 0x100fe200078e025cULL,
0x0000006d6d0e7211ULL, 0x000fe200078fe8ffULL, 0x000000041f617824ULL, 0x000fe200078e00ffULL,
0x000020000f737811ULL, 0x000fe200078e60ffULL, 0x000000010d0f7824ULL, 0x100fe200078e025cULL,
0x000000030e0e7812ULL, 0x000fe200078ec0ffULL, 0x00000001591f7824ULL, 0x000fc400078e025cULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc5d107812ULL, 0x100fe200078ee20eULL,
0x0000000459597824ULL, 0x000fe200078e00ffULL, 0xfffffffc5f127812ULL, 0x100fe200078ee20eULL,
0x000000045b637824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d0c7812ULL, 0x100fe200078ee20eULL,
0x0000000471657824ULL, 0x000fe200078e00ffULL, 0xfffffffc611c7812ULL, 0x100fe200078ee20eULL,
0x00000010105f7824ULL, 0x100fe200078e0273ULL, 0xfffffffc591e7812ULL, 0x000fe200078ee20eULL,
0x000000015b597824ULL, 0x000fe200078e025cULL, 0xfffffffc63587812ULL, 0x100fe200078ee20eULL,
0x000000ffff5b7224ULL, 0x000fe200078e00ffULL, 0xfffffffc655e7812ULL, 0x000fe200078ee20eULL,
0x000000100c5d7824ULL, 0x000fe200078e0273ULL, 0x0ffffffc0e0e7812ULL, 0x000fe200078ef86dULL,
0x0000001012617824ULL, 0x000fe200078e0273ULL, 0x0000005c6d0d7211ULL, 0x000fe200078ff0ffULL,
0x0000008011107825ULL, 0x000fc800078e005aULL, 0x000000100e757824ULL, 0x000fe200078e0273ULL,
0x0000620010107a10ULL, 0x000fe20007f7e0ffULL, 0x000000800d0c7825ULL, 0x000fc600078e005aULL,
0x0000630011117a10ULL, 0x000fe20001ffe4ffULL, 0x000000800f0e7825ULL, 0x000fe200078e005aULL,
0x000062000c0c7a10ULL, 0x000fc60007f3e0ffULL, 0x0000008013127825ULL, 0x000fe200078e005aULL,
0x000062000e0e7a10ULL, 0x000fe40007f5e0ffULL, 0x000063000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000000171717824ULL, 0x000fe200078e025cULL, 0x0000620012127a10ULL, 0x000fe20007f9e0ffULL,
0x000000101c637824ULL, 0x100fe200078e0273ULL, 0x000063000f0f7a10ULL, 0x000fe200017fe4ffULL,
0x000000101e657824ULL, 0x000fe200078e0273ULL, 0x0000630013137a10ULL, 0x000fe200027fe4ffULL,
0x000000801d1c7825ULL, 0x000fe200078e005aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c757faeULL, 0x0003e6000b901c48ULL, 0x0000001058677824ULL, 0x000fe200078e0273ULL,
0x000062001c1c7a10ULL, 0x000fe20007f3e0ffULL, 0x000000801f1e7825ULL, 0x100fe200078e005aULL,
0x000000000e5d7faeULL, 0x0003e4000b901c48ULL, 0x000063001d1d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000008059587825ULL, 0x100fe200078e005aULL, 0x000062001e1e7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000105f7faeULL, 0x0003e4000b901c48ULL, 0x00000080715a7825ULL, 0x000fe200078e005aULL,
0x0000620058587a10ULL, 0x000fe20007f7e0ffULL, 0x0000000012617faeULL, 0x0003e2000b901c48ULL,
0x000063001f1f7a10ULL, 0x000fe200017fe4ffULL, 0x000000105e737824ULL, 0x000fe200078e0273ULL,
0x000062005a5a7a10ULL, 0x000fe20007f9e0ffULL, 0x000000001c637faeULL, 0x0003e2000b901c48ULL,
0x0000630059597a10ULL, 0x000fc40001ffe4ffULL, 0x000063005b5b7a10ULL, 0x000fe200027fe4ffULL,
0x000000001e657faeULL, 0x0003e8000b901c48ULL, 0x0000000058677faeULL, 0x0003e8000b901c48ULL,
0x000000005a737faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000086e737824ULL, 0x002fc400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x00000010ff717424ULL, 0x000fe200078e00ffULL,
0x0000001273727810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x0000000273737810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff86d0c7812ULL, 0x040fe200078ec0ffULL, 0x000000021a617824ULL, 0x000fe200078e026fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000086d107812ULL, 0x020fe400078ec0ffULL,
0x000000070c0e7812ULL, 0x000fc400078ef86dULL, 0x0000200061617811ULL, 0x000fe400078e60ffULL,
0x00000001ff137819ULL, 0x000fe2000001160eULL, 0x000000040e0f7824ULL, 0x040fe200078e00ffULL,
0x000000076d117812ULL, 0x000fe200078ec0ffULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0x0000000170627810ULL, 0x000fe20007ffe0ffULL, 0x00000001130c7824ULL, 0x000fe200078e0270ULL,
0x0000000710127812ULL, 0x000fc600078ef86dULL, 0x0000000113137824ULL, 0x000fe200078e0262ULL,
0xfffffffc0f0c7812ULL, 0x000fe200078ee20cULL, 0x000000086e0f7824ULL, 0x000fe200078e020dULL,
0x00000010121c7812ULL, 0x040fe200078efcffULL, 0x00000010121e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee213ULL, 0x000000100c5c7824ULL, 0x100fe200078e0261ULL,
0x000000106d0c7211ULL, 0x000fe200078fe0ffULL, 0x0000001012137824ULL, 0x000fe400078e00ffULL,
0x000000100e0e7824ULL, 0x000fc400078e0261ULL, 0x000000005c5c783bULL, 0x000e620000000200ULL,
0x00000001110c7824ULL, 0x000fe400078e020cULL, 0x000000086e117824ULL, 0x000fe200078e0271ULL,
0x000000000e64783bULL, 0x0004e20000000200ULL, 0x000000010c0f7824ULL, 0x040fe200078e020fULL,
0x000000730c107210ULL, 0x040fe20007ffe00dULL, 0x000000010c117824ULL, 0x040fe200078e0211ULL,
0x000000720c0d7210ULL, 0x000fe20007ffe00dULL, 0x000000101c587824ULL, 0x040fe200078e00ffULL,
0x000000206d0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff013127812ULL, 0x000fc400078ee210ULL, 0xfffffff80c0c7812ULL, 0x000fe400078ec0ffULL,
0xfffffff01e0f7812ULL, 0x000fe200078ee20fULL, 0x0000001012127824ULL, 0x000fe200078e00ffULL,
0x000000070c607812ULL, 0x000fe400078ef86dULL, 0xfffffff058117812ULL, 0x000fe200078ee211ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff637819ULL, 0x000fe20000011660ULL,
0x0000000460757824ULL, 0x000fe200078e00ffULL, 0xfffffff01c137812ULL, 0x000fe200078ee20dULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x000000000f58783bULL, 0x000fe20000000200ULL,
0x0000000163627824ULL, 0x000fc600078e0262ULL, 0x00000000111c783bULL, 0x000fe20000000200ULL,
0x00000018ff0c7819ULL, 0x102fe4000001165fULL, 0x00000018ff8a7819ULL, 0x100fe4000001165cULL,
0x0000000cff10723eULL, 0x000fe400020006ffULL, 0x00000010ff0c7819ULL, 0x000fe4000001165fULL,
0x00000010ff847819ULL, 0x000fe2000001165cULL, 0x20000010ff107230ULL, 0x000fe20000004100ULL,
0x000000ff0c0e7812ULL, 0x004fe200078ec0ffULL, 0x00000001630c7824ULL, 0x000fe200078e0270ULL,
0x0000ffff5c8d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8b7819ULL, 0x008fe40000011664ULL,
0xfffffffc750c7812ULL, 0x000fe400078ee20cULL, 0x0000008aff8c723eULL, 0x000fe400020006ffULL,
0x000000ff848a7812ULL, 0x000fe200078ec0ffULL, 0x000000100c747824ULL, 0x000fe200078e0261ULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff847819ULL, 0x000fe2000001168dULL,
0x2000008cff8d7230ULL, 0x000fe20000004100ULL, 0x0000ffff5f0d7812ULL, 0x000fe200078ec0ffULL,
0x000000007474783bULL, 0x000e620000000200ULL, 0x0000008bff94723eULL, 0x000fc400020006ffULL,
0x0000008aff8b723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000084ff8a723eULL, 0x000fe200020006ffULL, 0x2000008bff8c7230ULL, 0x000fe20000004100ULL,
0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL, 0x2000005cff847230ULL, 0x000fe20000004100ULL,
0x00000008ff0d7819ULL, 0x000fe2000001160dULL, 0x2000008aff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff64917812ULL, 0x000fe200078ec0ffULL, 0x20000094ff5c7230ULL, 0x000fe20000004100ULL,
0x0000000eff0e723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe200020006ffULL, 0x2000000eff0e7230ULL, 0x000fe20000004100ULL,
0x00000091ff94723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe20000011684ULL, 0x2000000dff0d7230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fe2000001168cULL, 0x20000094ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fc4000001160eULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff0e7819ULL, 0x000fe2000001160dULL, 0x00000010130d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011667ULL, 0x000010540e787816ULL, 0x000fe4000000005fULL,
0x00000010ff5f7819ULL, 0x000fe20000011667ULL, 0x000000000d0c783bULL, 0x000fe20000000200ULL,
0x0000ffff677b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8f7819ULL, 0x002fe40000011674ULL,
0x000000ff74907812ULL, 0x000fe400078ec0ffULL, 0x0000008fff91723eULL, 0x000fe400020006ffULL,
0x00000010ff8f7819ULL, 0x000fe4000001168dULL, 0x00000010ff8d7819ULL, 0x000fe2000001168bULL,
0x20000091ff957230ULL, 0x000fe20000004100ULL, 0x000010548f8b7816ULL, 0x000fc4000000008cULL,
0x000010548d8a7816ULL, 0x000fe4000000008aULL, 0x00000018ff987819ULL, 0x000fe40000011676ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000098ff8d723eULL, 0x000fe200020006ffULL,
0x0000008a5828723cULL, 0x000fe20000041828ULL, 0x000000ff677a7812ULL, 0x000fe200078ec0ffULL,
0x20000090ff947230ULL, 0x000fe20000004100ULL, 0x00000018ff8c7819ULL, 0x000fe2000001165dULL,
0x2000008dff9a7230ULL, 0x000fe20000004100ULL, 0x0000ffff5d907812ULL, 0x000fc400078ec0ffULL,
0x00000063ff67723eULL, 0x000fe200020006ffULL, 0x0000008a1c24723cULL, 0x000be20000041824ULL,
0x000000ff5f637812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5f7819ULL, 0x000fe2000001167bULL,
0x00000004607b7824ULL, 0x000fe200078e00ffULL, 0x00000010ff8d7819ULL, 0x000fe2000001165eULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x020fe4000001165dULL,
0x000000ff5d8b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001165eULL,
0x000000ff5e8f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5e917812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5e723eULL, 0x000fe400020006ffULL, 0x00000008ff5d7819ULL, 0x000fe40000011690ULL,
0x00000018ff927819ULL, 0x000fc40000011675ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0xfffffffc7b627812ULL, 0x000fe400078ee262ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL,
0x0000001062627824ULL, 0x000fe200078e0261ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fc400020006ffULL,
0x00000010ff107819ULL, 0x000fe20000011610ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x20000092ff987230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000005eff927230ULL, 0x000fe20000004100ULL,
0x000000ff8d907812ULL, 0x000fe200078ec0ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8d7819ULL, 0x000fe20000011691ULL, 0x2000008aff5e7230ULL, 0x000fe20000004100ULL,
0x0000105410797816ULL, 0x000fc40000000079ULL, 0x000000001210783bULL, 0x000e620000000200ULL,
0x00000010ff7b7819ULL, 0x000fe40000011663ULL, 0x00000090ff91723eULL, 0x000fe200020006ffULL,
0x000000006260783bULL, 0x000ea20000000200ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x000000785808723cULL, 0x080f620000041808ULL, 0x0000008dff90723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168bULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x0000ffff749d7812ULL, 0x000fe200078ec0ffULL,
0x000000781c04723cULL, 0x000f620000041804ULL, 0x00000010ff8d7819ULL, 0x000fc4000001168cULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x000010545d8a7816ULL, 0x000fe4000000008aULL,
0x00000008ff5d7819ULL, 0x000fe4000001169dULL, 0x00000010ff937819ULL, 0x000fe40000011674ULL,
0x000010548d8b7816ULL, 0x000fe4000000005eULL, 0x0000005dff5e723eULL, 0x000fc400020006ffULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff8d7819ULL, 0x000fe20000011691ULL,
0x0000008a5838723cULL, 0x080fe20000041838ULL, 0x00000010ff8c7819ULL, 0x000fe2000001168fULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe40000011690ULL,
0x0000ffff76887812ULL, 0x000fe400078ec0ffULL, 0x000000ff93937812ULL, 0x000fe200078ec0ffULL,
0x0000008a1c54723cULL, 0x000be20000041854ULL, 0x0000ffff758e7812ULL, 0x000fc400078ec0ffULL,
0x00001054928d7816ULL, 0x000fe4000000008dULL, 0x000010545d8c7816ULL, 0x000fe4000000008cULL,
0x00000010ff897819ULL, 0x000fe40000011677ULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x0000008c5840723cULL, 0x000f620000041840ULL,
0x000000ff75977812ULL, 0x000fc400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe20000011676ULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x000000ff76997812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8e7819ULL, 0x000fe2000001168eULL, 0x0000008c1c30723cULL, 0x000b620000041830ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff967819ULL, 0x000fe20000011675ULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x0000ffff77867812ULL, 0x000fe200078ec0ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff898a7812ULL, 0x020fc400078ec0ffULL, 0x00000088ff5d723eULL, 0x000fe400020006ffULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000099ff99723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x000000ff87877812ULL, 0x000fe200078ec0ffULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x00000018ff9b7819ULL, 0x000fe20000011677ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff779c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff96967812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8c7819ULL, 0x000fe40000011686ULL, 0x0000008aff8b723eULL, 0x000fe200020006ffULL,
0x2000005dff8a7230ULL, 0x000fe20000004100ULL, 0x00000087ff89723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x000fe2000001165eULL, 0x2000008bff8f7230ULL, 0x000fe20000004100ULL,
0x0000009bff9b723eULL, 0x000fe200020006ffULL, 0x20000089ff8d7230ULL, 0x000fe20000004100ULL,
0x0000009cff9c723eULL, 0x000fc400020006ffULL, 0x00000096ff96723eULL, 0x000fe200020006ffULL,
0x2000009bff9b7230ULL, 0x000fe20000004100ULL, 0x00000010ff887819ULL, 0x000fe20000011695ULL,
0x2000009cff9c7230ULL, 0x000fe20000004100ULL, 0x00000010ff877819ULL, 0x000fe20000011693ULL,
0x20000096ff967230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe40000011694ULL,
0x0000008cff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff787819ULL, 0x000fc40000011667ULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff807819ULL, 0x000fe40000011666ULL,
0x0000ffff66817812ULL, 0x000fe400078ec0ffULL, 0x0000105488877816ULL, 0x000fe40000000087ULL,
0x000010545d867816ULL, 0x000fc40000000086ULL, 0x00000010ff887819ULL, 0x000fe40000011697ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168eULL, 0x00000010ff8c7819ULL, 0x000fe20000011699ULL,
0x000000861c2c723cULL, 0x000f62000004182cULL, 0x00000010ff5d7819ULL, 0x000fe4000001168aULL,
0x00001054787b7816ULL, 0x000fe4000000007bULL, 0x000010545f7a7816ULL, 0x000fc4000000007aULL,
0x00000018ff857819ULL, 0x000fe20000011666ULL, 0x000000865850723cULL, 0x000fe20000041850ULL,
0x000000ff66837812ULL, 0x000fe400078ec0ffULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x00000008ff817819ULL, 0x000fe40000011681ULL, 0x000010548b887816ULL, 0x000fe20000000088ULL,
0x0000007a1008723cULL, 0x002fe20000041808ULL, 0x000010545d8c7816ULL, 0x000fc4000000008cULL,
0x00000010ff987819ULL, 0x000fe40000011698ULL, 0x00000010ff897819ULL, 0x000fe40000011696ULL,
0x00000010ff9a7819ULL, 0x000fe2000001169aULL, 0x0000007a0c04723cULL, 0x000be20000041804ULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff8e7819ULL, 0x000fe4000001169bULL,
0x00000010ff8a7819ULL, 0x000fc4000001169cULL, 0x00000010ff8b7819ULL, 0x000fe4000001168fULL,
0x00000010ff5d7819ULL, 0x000fe4000001165eULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000085ff5e7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff827819ULL, 0x000fe20000011664ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000ffff647f7812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fc40000011665ULL,
0x00000018ff677819ULL, 0x000fe40000011665ULL, 0x000000ff65647812ULL, 0x040fe400078ec0ffULL,
0x0000ffff65747812ULL, 0x000fe400078ec0ffULL, 0x00000010ff667819ULL, 0x104fe40000011660ULL,
0x00000018ff7c7819ULL, 0x000fe40000011660ULL, 0x000000ff607b7812ULL, 0x020fc400078ec0ffULL,
0x0000ffff60767812ULL, 0x000fe400078ec0ffULL, 0x0000105498897816ULL, 0x000fe40000000089ULL,
0x000010549a8d7816ULL, 0x000fe4000000008dULL, 0x000010548e8b7816ULL, 0x000fe4000000008bULL,
0x000010545d8a7816ULL, 0x000fe2000000008aULL, 0x000000881c3c723cULL, 0x000f62000004183cULL,
0x00000010ff757819ULL, 0x000fc40000011661ULL, 0x00000018ff7d7819ULL, 0x000fe40000011661ULL,
0x000000ff617e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x100fe20000011662ULL,
0x0000008c1c44723cULL, 0x000f620000041844ULL, 0x00000018ff797819ULL, 0x000fe40000011662ULL,
0x000000ff627a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff657819ULL, 0x000fc40000011663ULL,
0x00000018ff787819ULL, 0x000fe20000011663ULL, 0x0000008a1c20723cULL, 0x000b620000041820ULL,
0x000000ff63777812ULL, 0x000fe400078ec0ffULL, 0x0000ffff61617812ULL, 0x000fe400078ec0ffULL,
0x0000ffff62627812ULL, 0x000fe400078ec0ffULL, 0x0000ffff63637812ULL, 0x000fe200078ec0ffULL,
0x00000088584c723cULL, 0x000f62000004184cULL, 0x00000008ff7f7819ULL, 0x000fc4000001167fULL,
0x00000008ff767819ULL, 0x000fe40000011676ULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL, 0x0000008c5848723cULL, 0x000f620000041848ULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x000000ff75757812ULL, 0x000fc400078ec0ffULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x0000008a5834723cULL, 0x000b620000041834ULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x000000ff65657812ULL, 0x000fe400078ec0ffULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff1d7819ULL, 0x020fe40000011680ULL,
0x00000010ff1c7819ULL, 0x000fe40000011681ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x000010545e1d7816ULL, 0x000fe2000000001dULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010541c1c7816ULL, 0x000fe20000000083ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff857819ULL, 0x000fe2000001165cULL, 0x20000077ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x0000001c1040723cULL, 0x080f620000041840ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff587819ULL, 0x000fe20000011667ULL, 0x0000001c0c30723cULL, 0x000b620000041830ULL,
0x00000010ff5b7819ULL, 0x000fc4000001165fULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff597819ULL, 0x000fe40000011674ULL, 0x00000010ff777819ULL, 0x000fe4000001167cULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff1c7819ULL, 0x020fe4000001167dULL,
0x00000010ff757819ULL, 0x000fc40000011675ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff1d7819ULL, 0x000fc40000011662ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff5d7819ULL, 0x000fe40000011665ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x000010547f847816ULL, 0x000fe40000000084ULL,
0x0000105476767816ULL, 0x000fc4000000007bULL, 0x0000105485857816ULL, 0x000fe40000000082ULL,
0x00001054585b7816ULL, 0x000fe4000000005bULL, 0x00001054595a7816ULL, 0x000fe40000000064ULL,
0x0000105477777816ULL, 0x000fe20000000066ULL, 0x000000840c24723cULL, 0x000f620000041824ULL,
0x000010541c7f7816ULL, 0x000fe40000000075ULL, 0x00001054617e7816ULL, 0x000fc4000000007eULL,
0x00001054797b7816ULL, 0x000fe40000000060ULL, 0x000010541d7a7816ULL, 0x000fe2000000007aULL,
0x0000005a0c54723cULL, 0x000f620000041854ULL, 0x00001054785d7816ULL, 0x000fe4000000005dULL,
0x00001054635c7816ULL, 0x000fe4000000005cULL, 0x0000000270707810ULL, 0x000fc60007ffe0ffULL,
0x000000760c2c723cULL, 0x040f70000004182cULL, 0x0000007e0c3c723cULL, 0x040f70000004183cULL,
0x0000007a0c44723cULL, 0x040f700000041844ULL, 0x0000005c0c20723cULL, 0x000b6e0000041820ULL,
0x00000004710c7810ULL, 0x060fe20007ffe0ffULL, 0x000000841028723cULL, 0x000b620000041828ULL,
0xfffffff4710d7810ULL, 0x000fc40007ffe0ffULL, 0x000000180c00780cULL, 0x000fe20003f25270ULL,
0x000000ffff717224ULL, 0x000fc800078e000cULL, 0x0000005a1038723cULL, 0x040b700000041838ULL,
0x000000761050723cULL, 0x040b700000041850ULL, 0x0000007e104c723cULL, 0x040b70000004184cULL,
0x0000007a1048723cULL, 0x040b700000041848ULL, 0x0000005c1034723cULL, 0x000b620000041834ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe5e000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff6f7224ULL, 0x000fe200078e001bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd94000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000006b42107220ULL, 0x0a0fe20000410000ULL,
0x0000006b43117220ULL, 0x080fe20000410000ULL, 0x0000006b41417220ULL, 0x080fe20000410000ULL,
0x0000006b34437220ULL, 0x080fe20000410000ULL, 0x0000006b35427220ULL, 0x080fe20000410000ULL,
0x0000006b325c7220ULL, 0x080fe20000410000ULL, 0x0000006b335d7220ULL, 0x080fe20000410000ULL,
0x0000006b28287220ULL, 0x080fe20000410000ULL, 0x0000006b29297220ULL, 0x080fe20000410000ULL,
0x0000006b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000006b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000006b38387220ULL, 0x080fe20000410000ULL, 0x0000006b39397220ULL, 0x080fe20000410000ULL,
0x0000006b3a3a7220ULL, 0x080fe20000410000ULL, 0x0000006b40407220ULL, 0x080fe20000410000ULL,
0x0000006b0a127220ULL, 0x080fe20000410000ULL, 0x0000006b0b137220ULL, 0x080fe20000410000ULL,
0x0000006b36367220ULL, 0x080fe20000410000ULL, 0x0000006b37377220ULL, 0x080fe20000410000ULL,
0x0000006b24347220ULL, 0x080fe20000410000ULL, 0x0000006b25357220ULL, 0x080fe20000410000ULL,
0x0000006b565a7220ULL, 0x080fe20000410000ULL, 0x0000006b04327220ULL, 0x080fe20000410000ULL,
0x0000006b05337220ULL, 0x080fe20000410000ULL, 0x0000006b065e7220ULL, 0x080fe20000410000ULL,
0x0000006b075f7220ULL, 0x080fe20000410000ULL, 0x0000006b3b3b7220ULL, 0x080fe20000410000ULL,
0x0000006b08087220ULL, 0x080fe20000410000ULL, 0x0000006b09097220ULL, 0x080fe20000410000ULL,
0x0000006b500a7220ULL, 0x080fe20000410000ULL, 0x0000006b510b7220ULL, 0x080fe20000410000ULL,
0x0000006b52527220ULL, 0x080fe20000410000ULL, 0x0000006b53537220ULL, 0x080fe20000410000ULL,
0x0000006b4c0c7220ULL, 0x080fe20000410000ULL, 0x0000006b4d0d7220ULL, 0x080fe20000410000ULL,
0x0000006b4e1c7220ULL, 0x080fe20000410000ULL, 0x0000006b4f1d7220ULL, 0x080fe20000410000ULL,
0x0000006b480e7220ULL, 0x080fe20000410000ULL, 0x0000006b490f7220ULL, 0x080fe20000410000ULL,
0x0000006b4a1e7220ULL, 0x080fe20000410000ULL, 0x0000006b4b1f7220ULL, 0x080fe20000410000ULL,
0x0000006b54547220ULL, 0x080fe20000410000ULL, 0x0000006b55557220ULL, 0x080fe20000410000ULL,
0x0000006b2c047220ULL, 0x080fe20000410000ULL, 0x0000006b2d057220ULL, 0x080fe20000410000ULL,
0x0000006b3c067220ULL, 0x080fe20000410000ULL, 0x0000006b3d077220ULL, 0x080fe20000410000ULL,
0x0000006b45567220ULL, 0x080fe20000410000ULL, 0x0000006b20207220ULL, 0x080fe20000410000ULL,
0x0000006b575b7220ULL, 0x080fe20000410000ULL, 0x0000006b3e627220ULL, 0x080fe20000410000ULL,
0x0000006b21577220ULL, 0x080fe20000410000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0041ULL,
0x0000006b26587220ULL, 0x080fe20000410000ULL, 0x0000006b27597220ULL, 0x080fe20000410000ULL,
0x0000006b2e607220ULL, 0x080fe20000410000ULL, 0x0000006b2f617220ULL, 0x080fe20000410000ULL,
0x0000006b3f637220ULL, 0x080fe20000410000ULL, 0x0000006b443e7220ULL, 0x080fe20000410000ULL,
0x0000006b46647220ULL, 0x080fe20000410000ULL, 0x0000006b47657220ULL, 0x080fe20000410000ULL,
0x0000006b23677220ULL, 0x080fe20000410000ULL, 0x000000ffff517224ULL, 0x000fe200078e0028ULL,
0x0000006b30307220ULL, 0x080fe20000410000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e0029ULL,
0x0000006b31317220ULL, 0x080fe20000410000ULL, 0x000000ffff4f7224ULL, 0x000fe200078e0038ULL,
0x0000006b22667220ULL, 0x000fe20000410000ULL, 0x000000ffff4b7224ULL, 0x000fc400078e0039ULL,
0x000000ffff507224ULL, 0x000fe400078e0040ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff417224ULL, 0x000fe400078e002bULL, 0x000000ffff217224ULL, 0x000fe400078e003aULL,
0x000000ffff3d7224ULL, 0x000fe400078e0036ULL, 0x000000ffff3c7224ULL, 0x000fc400078e0037ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0034ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0035ULL,
0x000000ffff497224ULL, 0x000fe400078e0008ULL, 0x000000ffff4d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff4e7224ULL, 0x000fe400078e000aULL, 0x000000ffff487224ULL, 0x000fc400078e000bULL,
0x000000ffff477224ULL, 0x000fe400078e000cULL, 0x000000ffff467224ULL, 0x000fe400078e000dULL,
0x000000ffff457224ULL, 0x000fe400078e000eULL, 0x000000ffff447224ULL, 0x000fe400078e000fULL,
0x000000ffff257224ULL, 0x000fe400078e003bULL, 0x000000ffff237224ULL, 0x000fc400078e0010ULL,
0x000000ffff407224ULL, 0x000fe400078e0011ULL, 0x000000ffff267224ULL, 0x000fe400078e0012ULL,
0x000000ffff287224ULL, 0x000fe400078e0013ULL, 0x000000ffff277224ULL, 0x000fe400078e0052ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0053ULL, 0x000000ffff297224ULL, 0x000fc400078e001cULL,
0x000000ffff387224ULL, 0x000fe400078e001dULL, 0x000000ffff2a7224ULL, 0x000fe400078e001eULL,
0x000000ffff2b7224ULL, 0x000fe400078e001fULL, 0x000000ffff2e7224ULL, 0x000fe400078e0054ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0055ULL, 0x000000ffff347224ULL, 0x000fc400078e0004ULL,
0x000000ffff357224ULL, 0x000fe400078e0005ULL, 0x000000ffff367224ULL, 0x000fe400078e0006ULL,
0x000000ffff377224ULL, 0x000fe400078e0007ULL, 0x000000ffff397224ULL, 0x000fe400078e0056ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000006a087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff3b7224ULL, 0x000fc400078e0057ULL,
0x000000ffff227224ULL, 0x000fe400078e0058ULL, 0x000000ffff207224ULL, 0x000fe400078e0059ULL,
0x000000ffff1f7224ULL, 0x000fe400078e005aULL, 0x000000ffff1e7224ULL, 0x000fe400078e005bULL,
0x000000ffff1d7224ULL, 0x000fe400078e005cULL, 0x000000ffff1c7224ULL, 0x000fc400078e005dULL,
0x000000ffff137224ULL, 0x000fe400078e005eULL, 0x000000ffff117224ULL, 0x000fe400078e005fULL,
0x000000ffff127224ULL, 0x000fe400078e0060ULL, 0x000000ffff107224ULL, 0x000fe400078e0061ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0062ULL, 0x000000ffff0b7224ULL, 0x000fc400078e0063ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0064ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0065ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0066ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0067ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x000004006a077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000105200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604537210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09005300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c405300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000005306067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000152527810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004006a077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000046d087824ULL, 0x000fe200078e00ffULL,
0x000000176800720cULL, 0x000fc80003f06070ULL, 0xfffffff008097812ULL, 0x000fca00078ec0ffULL,
0x000000801a097824ULL, 0x000fca00078e0209ULL, 0x0124000009047984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x0000010068537824ULL, 0x000fe200078e0203ULL,
0x000000006d547211ULL, 0x040fe200078ff0ffULL, 0x000000026d557824ULL, 0x000fe400078e00ffULL,
0x00000002ff727424ULL, 0x000fe200078e00ffULL, 0x0000005316527217ULL, 0x000fe40007800000ULL,
0x00005a00ff567a19ULL, 0x000fe40000011654ULL, 0x00000010545b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000152527824ULL, 0x000fe200078e0a53ULL, 0x0000000655537812ULL, 0x000fc400078ec0ffULL,
0x0000000854557810ULL, 0x040fe40007ffe0ffULL, 0x00000018545c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000118577824ULL, 0x000fe200078e0253ULL, 0x00005a00ff5a7a19ULL, 0x000fe40000011655ULL,
0x0000580053557a10ULL, 0x000fe20007ffe0ffULL, 0x0000000157587824ULL, 0x140fe200078e0a52ULL,
0x000000525700720cULL, 0x000fe40003f26070ULL, 0x0000005619577217ULL, 0x000fe20003800000ULL,
0x0000000155547824ULL, 0x000fe200078e0a52ULL, 0x0000005819587217ULL, 0x000fc40003800000ULL,
0x000000525500720cULL, 0x000fe20003f06070ULL, 0x0000005714857224ULL, 0x000fe200078e02ffULL,
0x0000005419547217ULL, 0x040fe40003800000ULL, 0x00000004ff587819ULL, 0x000fe40000011658ULL,
0x0000005a19597217ULL, 0x000fe40003800000ULL, 0x00005a00ff5c7a19ULL, 0x000fe4000001165cULL,
0x000000ff546c7207ULL, 0x000fe20000000000ULL, 0x0000005914877224ULL, 0x000fe200078e02ffULL,
0x000000ff585e7207ULL, 0x000fc40000800000ULL, 0x00005a00ff547a19ULL, 0x000fe4000001165bULL,
0x0000005c195f7217ULL, 0x000fe20003800000ULL, 0x00000001855b7824ULL, 0x000fe200078e025eULL,
0x000000856c597211ULL, 0x040fe400078fe0ffULL, 0x000000876c5d7211ULL, 0x000fe200078fe0ffULL,
0x0000005f148b7224ULL, 0x000fe200078e02ffULL, 0x0000005419577217ULL, 0x000fe20003800000ULL,
0x0000600059587625ULL, 0x000fe200078e0072ULL, 0x00000010535f7812ULL, 0x000fc600078efcffULL,
0x000060005b5a7625ULL, 0x080fe200078e0072ULL, 0x000058005f617a10ULL, 0x000fe20007ffe0ffULL,
0x0000000858547981ULL, 0x000724000c1e9500ULL, 0x000060005d5c7625ULL, 0x000fc800078e0072ULL,
0x0000005714897224ULL, 0x000fe200078e02ffULL, 0x000000085c567981ULL, 0x0042a2000c1e9500ULL,
0x0000000118737824ULL, 0x000fc600078e025fULL, 0x000000085a577981ULL, 0x000722000c1e9500ULL,
0x000000896c657211ULL, 0x000fe200078fe0ffULL, 0x000000015e637824ULL, 0x040fe400078e0287ULL,
0x000000015e677824ULL, 0x040fe400078e0289ULL, 0x00000001615c7824ULL, 0x102fe400078e0a52ULL,
0x000000015e717824ULL, 0x000fe400078e028bULL, 0x00000001735e7824ULL, 0x000fe200078e0a52ULL,
0x000000526100720cULL, 0x000fe20003f06070ULL, 0x0000600065647625ULL, 0x000fe200078e0072ULL,
0x0000005c195c7217ULL, 0x000fc60003800000ULL, 0x0000600063627625ULL, 0x000fe200078e0072ULL,
0x0000005e195e7217ULL, 0x000fe20003800000ULL, 0x0000000864587981ULL, 0x0082e4000c1e9500ULL,
0x0000600067667625ULL, 0x000fe200078e0072ULL, 0x000000ff5c787207ULL, 0x000fe20000000000ULL,
0x00000008625b7981ULL, 0x0002a2000c1e9500ULL, 0x000000527300720cULL, 0x000fc60003f26070ULL,
0x00000008665d7981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff5e7819ULL, 0x000fe4000001165eULL,
0x0000008b6c6f7211ULL, 0x000fe400078fe0ffULL, 0x000000ff5e607207ULL, 0x000fe20000800000ULL,
0x0000600071707625ULL, 0x000fe200078e0072ULL, 0x0000008778677211ULL, 0x002fc600078fe0ffULL,
0x000060006f6e7625ULL, 0x080fe200078e0072ULL, 0x00000008705a7981ULL, 0x0002e6000c1e9500ULL,
0x0000600067667625ULL, 0x000fe200078e0072ULL, 0x000000086e597981ULL, 0x0002e6000c1e9500ULL,
0x0000000160757824ULL, 0x000fe200078e028bULL, 0x0000008578657211ULL, 0x000fe200078fe0ffULL,
0x00000008665e7981ULL, 0x0002e2000c1e9500ULL, 0x0000000185637824ULL, 0x000fc400078e0260ULL,
0x00000001606f7824ULL, 0x002fe400078e0287ULL, 0x0000600075667625ULL, 0x000fe200078e0072ULL,
0x0000002053757812ULL, 0x000fc600078efcffULL, 0x0000600065647625ULL, 0x000fc800078e0072ULL,
0x0000600063627625ULL, 0x080fe200078e0072ULL, 0x00000008645c7981ULL, 0x0002e6000c1e9500ULL,
0x0000000160737824ULL, 0x000fe200078e0289ULL, 0x0000008978717211ULL, 0x000fe200078fe0ffULL,
0x000060006f6e7625ULL, 0x000fe200078e0072ULL, 0x0000580075777a10ULL, 0x000fe20007ffe0ffULL,
0x0000000862637981ULL, 0x0002e4000c1e9500ULL, 0x00000001187f7824ULL, 0x000fc400078e0275ULL,
0x0000600073647625ULL, 0x002fe200078e0072ULL, 0x0000008b787d7211ULL, 0x000fe200078fe0ffULL,
0x000000086e737981ULL, 0x0002e4000c1e9500ULL, 0x000000017f767824ULL, 0x100fe400078e0a52ULL,
0x0000000177747824ULL, 0x040fe200078e0a52ULL, 0x000000527700720cULL, 0x000fe20003f06070ULL,
0x0000600071707625ULL, 0x000fe200078e0072ULL, 0x0000007619767217ULL, 0x040fe20003800000ULL,
0x0000000864797981ULL, 0x0002e2000c1e9500ULL, 0x0000007419747217ULL, 0x000fe20003800000ULL,
0x000060007d7c7625ULL, 0x000fe200078e0072ULL, 0x000000527f00720cULL, 0x000fe20003f26070ULL,
0x0000000870607981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff767819ULL, 0x000fc40000011676ULL,
0x000000ff747a7207ULL, 0x000fe20000000000ULL, 0x000000087c627981ULL, 0x0002e4000c1e9500ULL,
0x000000ff76647207ULL, 0x002fe40000800000ULL, 0x00000008667b7981ULL, 0x0002e2000c1e9500ULL,
0x000000877a837211ULL, 0x000fe400078fe0ffULL, 0x0000000164717824ULL, 0x000fc600078e0287ULL,
0x0000600083827625ULL, 0x000fc800078e0072ULL, 0x0000600071707625ULL, 0x080fe200078e0072ULL,
0x000000857a677211ULL, 0x042fe200078fe0ffULL, 0x0000000882767981ULL, 0x0002e4000c1e9500ULL,
0x00000001857f7824ULL, 0x000fe400078e0264ULL, 0x0000000870cd7981ULL, 0x0002e2000c1e9500ULL,
0x0000600067667625ULL, 0x080fe200078e0072ULL, 0x000000897a6f7211ULL, 0x040fe400078fe0ffULL,
0x0000008b7a657211ULL, 0x000fe200078fe0ffULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x0000003053b37812ULL, 0x000fe200078efcffULL, 0x0000000866747981ULL, 0x0002e4000c1e9500ULL,
0x00000001647d7824ULL, 0x000fc400078e0289ULL, 0x00000001648d7824ULL, 0x000fe200078e028bULL,
0x000000087e817981ULL, 0x0002e2000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x00005800b3b57a10ULL, 0x000fc60007ffe0ffULL, 0x0000600065647625ULL, 0x080fe200078e0072ULL,
0x000000086ed17981ULL, 0x0002e6000c1e9500ULL, 0x000060007d7c7625ULL, 0x080fe200078e0072ULL,
0x0000000864d57981ULL, 0x0002e6000c1e9500ULL, 0x000060008d667625ULL, 0x002fe200078e0072ULL,
0x000000087c887981ULL, 0x0002e6000c1e9500ULL, 0x00000001187f7824ULL, 0x000fe200078e02b3ULL,
0x00000008668c7981ULL, 0x0002e6000c1e9500ULL, 0x000000017f807824ULL, 0x000fc400078e0a52ULL,
0x00000001b57e7824ULL, 0x000fc600078e0a52ULL, 0x0000008019807217ULL, 0x000fe40003800000ULL,
0x000000527f00720cULL, 0x080fe40003f26070ULL, 0x00000052b500720cULL, 0x000fe40003f06070ULL,
0x0000007e197e7217ULL, 0x000fe40003800000ULL, 0x00000004ff647819ULL, 0x000fe40000011680ULL,
0x000000ff7e807207ULL, 0x000fc40000000000ULL, 0x000000ff64827207ULL, 0x000fe40000800000ULL,
0x00000085807d7211ULL, 0x042fe400078fe0ffULL, 0x0000008980677211ULL, 0x000fe200078fe0ffULL,
0x00000001857f7824ULL, 0x000fe400078e0282ULL, 0x00000001826f7824ULL, 0x000fe400078e0289ULL,
0x000060007d7c7625ULL, 0x000fc800078e0072ULL, 0x000060007f7e7625ULL, 0x080fe200078e0072ULL,
0x000000087cb77981ULL, 0x0002e6000c1e9500ULL, 0x0000600067667625ULL, 0x080fe200078e0072ULL,
0x000000087e847981ULL, 0x0002e6000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x0000000866d37981ULL, 0x0002e2000c1e9500ULL, 0x0000008780657211ULL, 0x000fc600078fe0ffULL,
0x000000086e8a7981ULL, 0x0002e2000c1e9500ULL, 0x0000000182717824ULL, 0x000fe400078e0287ULL,
0x0000600065647625ULL, 0x000fc800078e0072ULL, 0x0000600071707625ULL, 0x080fe200078e0072ULL,
0x0000000864cf7981ULL, 0x0002e4000c1e9500ULL, 0x0000008b807d7211ULL, 0x002fe400078fe0ffULL,
0x0000000870867981ULL, 0x0002e2000c1e9500ULL, 0x00000001827f7824ULL, 0x000fe400078e028bULL,
0x000060007d7c7625ULL, 0x000fc800078e0072ULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x000000087cd77981ULL, 0x0002e8000c1e9500ULL, 0x000000087e8e7981ULL, 0x0002e2000c1e9500ULL,
0xfffffff06c657812ULL, 0x000fe200078ec0ffULL, 0x00000001ffcb7424ULL, 0x000fc800078e00ffULL,
0x0000000152647824ULL, 0x000fc800078e0265ULL, 0x0000000155657824ULL, 0x000fe200078e0a64ULL,
0x0000000153837812ULL, 0x000fc800078efcffULL, 0x00000065cb657219ULL, 0x000fe400000006ffULL,
0x0000580083677a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0786f7812ULL, 0x000fc600078ec0ffULL,
0x0000000167667824ULL, 0x100fe200078e0a64ULL, 0x0000000853857812ULL, 0x040fe200078efcffULL,
0x00000001526e7824ULL, 0x000fe200078e026fULL, 0x0000000953877812ULL, 0x000fe400078efcffULL,
0x00000066cb6f7219ULL, 0x000fe400000006ffULL, 0x0000580085717a10ULL, 0x002fe40007ffe0ffULL,
0x00005800877f7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff07a7d7812ULL, 0x000fe200078ec0ffULL,
0x00000001716c7824ULL, 0x100fe200078e0a64ULL, 0xfffffff080897812ULL, 0x000fe200078ec0ffULL,
0x000000017f647824ULL, 0x000fe200078e0a64ULL, 0x00000011538d7812ULL, 0x000fe200078efcffULL,
0x0000000152707824ULL, 0x040fe200078e027dULL, 0x0000006ccb7d7219ULL, 0x040fe200000006ffULL,
0x00000001527c7824ULL, 0x000fe200078e0289ULL, 0x00000064cb897219ULL, 0x000fc400000006ffULL,
0x000058008d8f7a10ULL, 0x000fe20007ffe0ffULL, 0x0000000161647824ULL, 0x000fe200078e0a6eULL,
0x0000001853937812ULL, 0x000fc600078efcffULL, 0x000000018f667824ULL, 0x000fe200078e0a6eULL,
0x0000541054547816ULL, 0x010fc80000000057ULL, 0x0000005465ff7212ULL, 0x000fc800078ac0ffULL,
0x000000525500720cULL, 0x000fc80002fa1470ULL, 0x000000525300720cULL, 0x000fe40002fa1070ULL,
0x000000546fff7212ULL, 0x000fe4000782c0ffULL, 0xff80000051517808ULL, 0x000fe40002800000ULL,
0x0000541056567816ULL, 0x004fe4000000005bULL, 0x0000541058587816ULL, 0x008fe4000000005dULL,
0x0000005665ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005865ff7212ULL, 0x000fe4000788c0ffULL,
0x000000566fff7212ULL, 0x000fe400078ac0ffULL, 0x000000525500720cULL, 0x0c0fe40001741470ULL,
0x000000525500720cULL, 0x080fe40002781470ULL, 0x000000526700720cULL, 0x0c0fe40000f21470ULL,
0x000000526700720cULL, 0x000fc40002fa1470ULL, 0x000000525300720cULL, 0x0c0fe40001741070ULL,
0x000000525300720cULL, 0x080fe40002781070ULL, 0x000000528300720cULL, 0x0c0fe40000f21070ULL,
0x000000528300720cULL, 0x000fe40002fa1070ULL, 0x00005410595a7816ULL, 0x000fe4000000005aULL,
0xff80000024247808ULL, 0x000fc40001000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff8000004a4a7808ULL, 0x000fe40000800000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0x000000547dff7212ULL, 0x000fe4000786c0ffULL, 0x0000005a65ff7212ULL, 0x000fe4000780c0ffULL,
0x000000586fff7212ULL, 0x000fc4000784c0ffULL, 0x0000005a6fff7212ULL, 0x000fe4000788c0ffULL,
0x0000005689ff7212ULL, 0x000fe4000782c0ffULL, 0x000000587dff7212ULL, 0x000fe400078ac0ffULL,
0x000000525500720cULL, 0x080fe40000701470ULL, 0x000000526700720cULL, 0x0c0fe40001741470ULL,
0x000000526700720cULL, 0x000fc40002781470ULL, 0x000000527100720cULL, 0x0c0fe40001f61470ULL,
0x000000527100720cULL, 0x080fe40002fa1470ULL, 0x000000527f00720cULL, 0x080fe40000f21470ULL,
0x0000001953997812ULL, 0x040fe400078efcffULL, 0x000000525300720cULL, 0x080fe40000701070ULL,
0x000000528300720cULL, 0x000fc40001741070ULL, 0x000000528300720cULL, 0x080fe40002781070ULL,
0x000000528500720cULL, 0x0c0fe40001f61070ULL, 0x000000528500720cULL, 0x080fe40002fa1070ULL,
0x000000528700720cULL, 0x000fe40000f21070ULL, 0x00000064cb8b7219ULL, 0x040fe400000006ffULL,
0x00000066cb917219ULL, 0x000fc400000006ffULL, 0x000054105c5c7816ULL, 0x000fe40000000063ULL,
0x000054105e5e7816ULL, 0x000fe40000000073ULL, 0x0000580093957a10ULL, 0x000fe40007ffe0ffULL,
0x00005800999b7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000022227808ULL, 0x000fe40000000000ULL,
0xff8000002c2c7808ULL, 0x000fc40001000000ULL, 0xff80000020207808ULL, 0x000fe40002000000ULL,
0xff8000004f4f7808ULL, 0x000fe40001800000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0x000000567dff7212ULL, 0x000fe4000780c0ffULL,
0x0000005889ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005a7dff7212ULL, 0x080fe4000788c0ffULL,
0x0000005a89ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005c91ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005e8bff7212ULL, 0x000fe2000782c0ffULL, 0x00000001956c7824ULL, 0x100fe200078e0a6eULL,
0x000000527100720cULL, 0x080fe20000701470ULL, 0x000000019b6e7824ULL, 0x000fe200078e0a6eULL,
0x000000527100720cULL, 0x000fc40002781470ULL, 0x000000527f00720cULL, 0x0c0fe40001741470ULL,
0x000000527f00720cULL, 0x080fe40001f61470ULL, 0x000000526100720cULL, 0x080fe40000f21470ULL,
0x000000528f00720cULL, 0x080fe40002fa1470ULL, 0x000000528500720cULL, 0x0c0fe40000701070ULL,
0x000000528500720cULL, 0x000fc40002781070ULL, 0x000000528700720cULL, 0x0c0fe40001741070ULL,
0x000000528700720cULL, 0x080fe40001f61070ULL, 0x000000525f00720cULL, 0x080fe40000f21070ULL,
0x000000528d00720cULL, 0x000fe40002fa1070ULL, 0x0000006ccb977219ULL, 0x040fe400000006ffULL,
0x0000006ecb9d7219ULL, 0x000fc400000006ffULL, 0x0000541060607816ULL, 0x000fe40000000079ULL,
0x0000541062627816ULL, 0x000fe4000000007bULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0xff8000001f1f7808ULL, 0x000fe40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40001000000ULL,
0xff8000001e1e7808ULL, 0x000fc40001800000ULL, 0xff80000023237808ULL, 0x000fe40000800000ULL,
0xff8000004c4c7808ULL, 0x000fe40002800000ULL, 0x0000005c8bff7212ULL, 0x080fe4000780c0ffULL,
0x0000005c97ff7212ULL, 0x000fe4000788c0ffULL, 0x000000608bff7212ULL, 0x040fe4000784c0ffULL,
0x000000628bff7212ULL, 0x000fc4000786c0ffULL, 0x0000006091ff7212ULL, 0x000fe4000782c0ffULL,
0x0000005e9dff7212ULL, 0x000fe200078ac0ffULL, 0x0000000177727824ULL, 0x000fe200078e0a70ULL,
0x000000526100720cULL, 0x0c0fe40000701470ULL, 0x000000526100720cULL, 0x0c0fe40001741470ULL,
0x000000526100720cULL, 0x080fe40001f61470ULL, 0x000000528f00720cULL, 0x000fc40000f21470ULL,
0x000000529500720cULL, 0x080fe40002781470ULL, 0x000000529b00720cULL, 0x080fe40002fa1470ULL,
0x0000002153a17812ULL, 0x000fe400078efcffULL, 0x000000525f00720cULL, 0x0c0fe40000701070ULL,
0x000000525f00720cULL, 0x0c0fe40001741070ULL, 0x000000525f00720cULL, 0x000fc40001f61070ULL,
0x000000528d00720cULL, 0x080fe40000f21070ULL, 0x000000529300720cULL, 0x080fe40002781070ULL,
0x000000529900720cULL, 0x000fe40002fa1070ULL, 0x00000072cb9f7219ULL, 0x000fe400000006ffULL,
0x0000541076767816ULL, 0x000fe400000000cdULL, 0x00005800a1a37a10ULL, 0x000fc40007ffe0ffULL,
0xff80000050507808ULL, 0x000fe40000000000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fe40000800000ULL,
0xff80000049497808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fc40002800000ULL,
0x0000005e91ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006291ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005e97ff7212ULL, 0x000fe4000786c0ffULL, 0x000000609dff7212ULL, 0x040fe4000782c0ffULL,
0x000000629dff7212ULL, 0x000fe4000788c0ffULL, 0x000000769fff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a3787824ULL, 0x000fe200078e0a70ULL, 0x000000528f00720cULL, 0x000fc40000701470ULL,
0x000000528f00720cULL, 0x080fe40001741470ULL, 0x000000529500720cULL, 0x080fe40001f61470ULL,
0x000000529b00720cULL, 0x0c0fe40000f21470ULL, 0x000000529b00720cULL, 0x080fe40002781470ULL,
0x000000527700720cULL, 0x000fe40002fa1470ULL, 0x0000002853a77812ULL, 0x000fc400078efcffULL,
0x0000002953ad7812ULL, 0x000fe400078efcffULL, 0x000000528d00720cULL, 0x0c0fe40000701070ULL,
0x000000528d00720cULL, 0x080fe40001741070ULL, 0x000000529300720cULL, 0x080fe40001f61070ULL,
0x000000529900720cULL, 0x0c0fe40000f21070ULL, 0x000000529900720cULL, 0x000fc40002781070ULL,
0x000000527500720cULL, 0x000fe40002fa1070ULL, 0x00000078cba57219ULL, 0x000fe400000006ffULL,
0x0000541074747816ULL, 0x000fe40000000081ULL, 0x00005410d1887816ULL, 0x000fe40000000088ULL,
0x00005410d58c7816ULL, 0x000fe4000000008cULL, 0x00005800a7a97a10ULL, 0x000fc40007ffe0ffULL,
0x00005800adaf7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000040407808ULL, 0x000fe40000000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40000800000ULL, 0xff80000011117808ULL, 0x000fc40002000000ULL,
0xff80000027277808ULL, 0x000fe40002800000ULL, 0x0000005489ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006097ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006297ff7212ULL, 0x000fe4000784c0ffULL,
0x000000749fff7212ULL, 0x040fe4000786c0ffULL, 0x000000889fff7212ULL, 0x000fc4000782c0ffULL,
0x0000008c9fff7212ULL, 0x000fe4000788c0ffULL, 0x00000088a5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a97a7824ULL, 0x100fe200078e0a70ULL, 0x000000527f00720cULL, 0x080fe200037c1470ULL,
0x00000001af707824ULL, 0x000fe200078e0a70ULL, 0x000000529500720cULL, 0x0c0fe40000701470ULL,
0x000000529500720cULL, 0x080fe40001741470ULL, 0x000000527700720cULL, 0x000fc40001f61470ULL,
0x000000527700720cULL, 0x0c0fe40000f21470ULL, 0x000000527700720cULL, 0x080fe40002781470ULL,
0x00000052a300720cULL, 0x080fe40002fa1470ULL, 0x000000528700720cULL, 0x080fe400037c1070ULL,
0x000000529300720cULL, 0x0c0fe40000701070ULL, 0x000000529300720cULL, 0x000fc40001741070ULL,
0x000000527500720cULL, 0x0c0fe40001f61070ULL, 0x000000527500720cULL, 0x0c0fe40000f21070ULL,
0x000000527500720cULL, 0x080fe40002781070ULL, 0x00000052a100720cULL, 0x000fe40002fa1070ULL,
0x0000007acbab7219ULL, 0x040fe400000006ffULL, 0x00000070cbb17219ULL, 0x000fc400000006ffULL,
0xff8000004b4b7808ULL, 0x000fe40003000000ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff80000013137808ULL, 0x000fe40001000000ULL, 0xff8000004e4e7808ULL, 0x000fe40001800000ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000012127808ULL, 0x000fc40002000000ULL,
0xff80000035357808ULL, 0x000fe40002800000ULL, 0x0000005c9dff7212ULL, 0x000fe400078cc0ffULL,
0x00000074a5ff7212ULL, 0x080fe4000780c0ffULL, 0x00000074abff7212ULL, 0x000fe4000784c0ffULL,
0x00000076a5ff7212ULL, 0x040fe4000786c0ffULL, 0x0000008ca5ff7212ULL, 0x000fc4000782c0ffULL,
0x00000076abff7212ULL, 0x000fe4000788c0ffULL, 0x00000088b1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b57e7824ULL, 0x000fe200078e0a7cULL, 0x000000529b00720cULL, 0x080fe400037c1470ULL,
0x00000052a300720cULL, 0x0c0fe40000701470ULL, 0x00000052a300720cULL, 0x0c0fe40001f61470ULL,
0x00000052a300720cULL, 0x000fc40000f21470ULL, 0x00000052a900720cULL, 0x0c0fe40001741470ULL,
0x00000052a900720cULL, 0x080fe40002781470ULL, 0x00000052af00720cULL, 0x000fe40002fa1470ULL,
0x0000003153bb7812ULL, 0x040fe400078efcffULL, 0x0000003853c17812ULL, 0x040fe400078efcffULL,
0x0000003953c77812ULL, 0x000fc400078efcffULL, 0x000000529900720cULL, 0x080fe400037c1070ULL,
0x00000052a100720cULL, 0x0c0fe40000701070ULL, 0x00000052a100720cULL, 0x0c0fe40001f61070ULL,
0x00000052a100720cULL, 0x080fe40000f21070ULL, 0x00000052a700720cULL, 0x0c0fe40001741070ULL,
0x00000052a700720cULL, 0x000fc40002781070ULL, 0x00000052ad00720cULL, 0x000fe40002fa1070ULL,
0x0000007ecbb97219ULL, 0x000fe400000006ffULL, 0x00005410b7847816ULL, 0x000fe40000000084ULL,
0x00005410d38a7816ULL, 0x000fe4000000008aULL, 0x00005800bbbd7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c1c37a10ULL, 0x000fc40007ffe0ffULL, 0x00005800c7c97a10ULL, 0x000fe40007ffe0ffULL,
0xff8000004d4d7808ULL, 0x000fe40003000000ULL, 0xff80000048487808ULL, 0x000fe40000000000ULL,
0xff8000003f3f7808ULL, 0x000fe40001800000ULL, 0xff80000010107808ULL, 0x000fe40000800000ULL,
0xff80000047477808ULL, 0x000fc40001000000ULL, 0xff80000029297808ULL, 0x000fe40002000000ULL,
0xff80000037377808ULL, 0x000fe40002800000ULL, 0x00000074b1ff7212ULL, 0x040fe400078cc0ffULL,
0x00000076b1ff7212ULL, 0x000fe4000780c0ffULL, 0x00000088abff7212ULL, 0x040fe4000786c0ffULL,
0x0000008cabff7212ULL, 0x000fc4000782c0ffULL, 0x0000008cb1ff7212ULL, 0x000fe4000784c0ffULL,
0x00000084b9ff7212ULL, 0x040fe4000788c0ffULL, 0x0000008ab9ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bd807824ULL, 0x100fe200078e0a7cULL, 0x00000052a900720cULL, 0x080fe20001f61470ULL,
0x00000001c3827824ULL, 0x100fe200078e0a7cULL, 0x00000052a900720cULL, 0x080fe20000f21470ULL,
0x00000001c97c7824ULL, 0x000fe200078e0a7cULL, 0x00000052af00720cULL, 0x000fc400037c1470ULL,
0x00000052af00720cULL, 0x0c0fe40000701470ULL, 0x00000052af00720cULL, 0x080fe40001741470ULL,
0x00000052b500720cULL, 0x0c0fe40002781470ULL, 0x00000052b500720cULL, 0x000fe40002fa1470ULL,
0x00000080cbbf7219ULL, 0x040fe400000006ffULL, 0x00000082cbc57219ULL, 0x000fc400000006ffULL,
0x00000052a700720cULL, 0x0c0fe40001f61070ULL, 0x00000052a700720cULL, 0x080fe40000f21070ULL,
0x00000052ad00720cULL, 0x0c0fe400037c1070ULL, 0x00000052ad00720cULL, 0x0c0fe40000701070ULL,
0x00000052ad00720cULL, 0x080fe40001741070ULL, 0x00000052b300720cULL, 0x000fc40002781070ULL,
0x00000052b300720cULL, 0x000fe40002fa1070ULL, 0x0000007ccbcb7219ULL, 0x000fe400000006ffULL,
0x00005410cf867816ULL, 0x000fe40000000086ULL, 0xff80000036367808ULL, 0x000fe40001800000ULL,
0xff8000000a0a7808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000038387808ULL, 0x000fe40000000000ULL, 0xff8000000b0b7808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x00000084bfff7212ULL, 0x080fe4000786c0ffULL, 0x00000084c5ff7212ULL, 0x000fc4000782c0ffULL,
0x00000084cbff7212ULL, 0x000fe400078cc0ffULL, 0x00000086b9ff7212ULL, 0x080fe4000780c0ffULL,
0x00000086bfff7212ULL, 0x080fe4000784c0ffULL, 0x00000086c5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008abfff7212ULL, 0x000fe400078ac0ffULL, 0x00000052b500720cULL, 0x000fc40000701470ULL,
0x00000052bd00720cULL, 0x0c0fe40001f61470ULL, 0x00000052bd00720cULL, 0x0c0fe40001741470ULL,
0x00000052bd00720cULL, 0x080fe40002fa1470ULL, 0x00000052c300720cULL, 0x080fe40000f21470ULL,
0x00000052c900720cULL, 0x080fe400037c1470ULL, 0x00000052c300720cULL, 0x000fc40002781470ULL,
0x00000052b300720cULL, 0x080fe40000701070ULL, 0x00000052bb00720cULL, 0x0c0fe40001f61070ULL,
0x00000052bb00720cULL, 0x0c0fe40001741070ULL, 0x00000052bb00720cULL, 0x080fe40002fa1070ULL,
0x00000052c100720cULL, 0x080fe40000f21070ULL, 0x00000052c700720cULL, 0x000fc400037c1070ULL,
0x00000052c100720cULL, 0x000fe40002781070ULL, 0x00005410d78e7816ULL, 0x000fe4000000008eULL,
0xff8000002a2a7808ULL, 0x000fe40000000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000039397808ULL, 0x000fc40002800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000042427808ULL, 0x000fe40003000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002000000ULL, 0x00000086cbff7212ULL, 0x000fe4000780c0ffULL,
0x0000008ac5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008acbff7212ULL, 0x000fc4000784c0ffULL,
0x0000008eb9ff7212ULL, 0x080fe400078ac0ffULL, 0x0000008ebfff7212ULL, 0x080fe4000782c0ffULL,
0x0000008ec5ff7212ULL, 0x080fe400078cc0ffULL, 0x0000008ecbff7212ULL, 0x000fe4000788c0ffULL,
0x00000052b500720cULL, 0x080fe40002fa1470ULL, 0x00000052bd00720cULL, 0x000fc40000f21470ULL,
0x00000052c300720cULL, 0x0c0fe40001f61470ULL, 0x00000052c300720cULL, 0x080fe400037c1470ULL,
0x00000052c900720cULL, 0x0c0fe40000701470ULL, 0x00000052c900720cULL, 0x0c0fe40001741470ULL,
0x00000052c900720cULL, 0x080fe40002781470ULL, 0x00000052b300720cULL, 0x000fc40002fa1070ULL,
0x00000052bb00720cULL, 0x080fe40000f21070ULL, 0x00000052c700720cULL, 0x080fe40000701070ULL,
0x00000052c100720cULL, 0x0c0fe40001f61070ULL, 0x00000052c100720cULL, 0x080fe400037c1070ULL,
0x00000052c700720cULL, 0x0c0fe40001741070ULL, 0x00000052c700720cULL, 0x000fc40002781070ULL,
0xff8000003c3c7808ULL, 0x000fe40000000000ULL, 0xff8000003a3a7808ULL, 0x000fe40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40001000000ULL, 0xff8000000c0c7808ULL, 0x000fe40002800000ULL,
0xff8000000d0d7808ULL, 0x000fe40000800000ULL, 0xff8000000e0e7808ULL, 0x000fc40003000000ULL,
0xff8000000f0f7808ULL, 0x000fc40002000000ULL, 0x000000510400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff5a7424ULL, 0x000fe200078e00ffULL, 0x000000240500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff5b7424ULL, 0x000fe200078e00ffULL, 0x0000002d0600720bULL, 0x000fe40003f5e000ULL,
0x000000220700720bULL, 0x000fe40003f7e000ULL, 0x0000000451537208ULL, 0x000fe40004000000ULL,
0x0000000524047208ULL, 0x000fc40004800000ULL, 0x000000062d057208ULL, 0x000fe40005000000ULL,
0x0000000722077208ULL, 0x000fe40005800000ULL, 0x0000004a5300720bULL, 0x000fe40003f1e000ULL,
0x000000410400720bULL, 0x000fe40003f3e000ULL, 0x0000002c0500720bULL, 0x000fe40003f5e000ULL,
0x000000200700720bULL, 0x000fc40003f7e000ULL, 0x000000534a067208ULL, 0x000fe40004000000ULL,
0x0000000441047208ULL, 0x000fe40004800000ULL, 0x000000052c057208ULL, 0x000fe40005000000ULL,
0x0000000720527208ULL, 0x000fe40005800000ULL, 0x0000004f0600720bULL, 0x000fe40003f1e000ULL,
0x000000210400720bULL, 0x000fc40003f3e000ULL, 0x0000002e0500720bULL, 0x000fe40003f5e000ULL,
0x0000001f5200720bULL, 0x000fe40003f7e000ULL, 0x000000064f067208ULL, 0x000fe40004000000ULL,
0x0000000421047208ULL, 0x000fe40004800000ULL, 0x000000052e547208ULL, 0x000fe40005000000ULL,
0x000000521f057208ULL, 0x000fc40005800000ULL, 0x0000004b0600720bULL, 0x000fe40003f1e000ULL,
0x000000250400720bULL, 0x000fe40003f3e000ULL, 0x0000002f5400720bULL, 0x000fe40003f5e000ULL,
0x0000001e0500720bULL, 0x000fe40003f7e000ULL, 0x000000064b077208ULL, 0x000fe40004000000ULL,
0x0000000425047208ULL, 0x000fc40004800000ULL, 0x000000542f537208ULL, 0x000fe40005000000ULL,
0x000000051e067208ULL, 0x000fe40005800000ULL, 0x000000500700720bULL, 0x000fe40003f1e000ULL,
0x000000230400720bULL, 0x000fe40003f3e000ULL, 0x000000305300720bULL, 0x000fe40003f5e000ULL,
0x0000001d0600720bULL, 0x000fc40003f7e000ULL, 0x0000000750077208ULL, 0x000fe40004000000ULL,
0x0000000423057208ULL, 0x000fe40004800000ULL, 0x0000005330047208ULL, 0x000fe40005000000ULL,
0x000000061d537208ULL, 0x000fe40005800000ULL, 0x0000004c0700720bULL, 0x000fe40003f1e000ULL,
0x000000400500720bULL, 0x000fc40003f3e000ULL, 0x000000310400720bULL, 0x000fe40003f5e000ULL,
0x0000001c5300720bULL, 0x000fe40003f7e000ULL, 0x000000074c067208ULL, 0x000fe40004000000ULL,
0x0000000540057208ULL, 0x000fe40004800000ULL, 0x0000000431077208ULL, 0x000fe40005000000ULL,
0x000000531c047208ULL, 0x000fc40005800000ULL, 0x000000490600720bULL, 0x000fe40003f1e000ULL,
0x000000260500720bULL, 0x000fe40003f3e000ULL, 0x000000320700720bULL, 0x000fe40003f5e000ULL,
0x000000130400720bULL, 0x000fe40003f7e000ULL, 0x0000000649067208ULL, 0x000fe40004000000ULL,
0x0000000526057208ULL, 0x000fc40004800000ULL, 0x0000000732527208ULL, 0x000fe40005000000ULL,
0x0000000413047208ULL, 0x000fe40005800000ULL, 0x0000004d0600720bULL, 0x000fe40003f1e000ULL,
0x000000280500720bULL, 0x000fe40003f3e000ULL, 0x000000335200720bULL, 0x000fe40003f5e000ULL,
0x000000110400720bULL, 0x000fc40003f7e000ULL, 0x000000064d077208ULL, 0x000fe40004000000ULL,
0x0000000528067208ULL, 0x000fe40004800000ULL, 0x0000005233057208ULL, 0x000fe40005000000ULL,
0x0000000411537208ULL, 0x000fe40005800000ULL, 0x0000004e0700720bULL, 0x000fe40003f1e000ULL,
0x000000270600720bULL, 0x000fc40003f3e000ULL, 0x000000340500720bULL, 0x000fe40003f5e000ULL,
0x000000125300720bULL, 0x000fe40003f7e000ULL, 0x000000074e077208ULL, 0x000fe40004000000ULL,
0x0000000627067208ULL, 0x000fe40004800000ULL, 0x0000000534047208ULL, 0x000fe40005000000ULL,
0x0000005312537208ULL, 0x000fc40005800000ULL, 0x000000480700720bULL, 0x000fe40003f1e000ULL,
0x0000003f0600720bULL, 0x000fe40003f3e000ULL, 0x000000350400720bULL, 0x000fe40003f5e000ULL,
0x000000105300720bULL, 0x000fe40003f7e000ULL, 0x0000000748527208ULL, 0x000fe40004000000ULL,
0x000000063f067208ULL, 0x000fc40004800000ULL, 0x0000000435057208ULL, 0x000fe40005000000ULL,
0x0000005310537208ULL, 0x000fe40005800000ULL, 0x000000475200720bULL, 0x000fe40003f1e000ULL,
0x000000290600720bULL, 0x000fe40003f3e000ULL, 0x000000360500720bULL, 0x000fe40003f5e000ULL,
0x0000000a5300720bULL, 0x000fc40003f7e000ULL, 0x0000005247077208ULL, 0x000fe40004000000ULL,
0x0000000629557208ULL, 0x000fe40004800000ULL, 0x0000000536047208ULL, 0x000fe40005000000ULL,
0x000000530a067208ULL, 0x000fe40005800000ULL, 0x000000460700720bULL, 0x000fe40003f1e000ULL,
0x000000385500720bULL, 0x000fc40003f3e000ULL, 0x000000370400720bULL, 0x000fe40003f5e000ULL,
0x0000000b0600720bULL, 0x000fe40003f7e000ULL, 0x0000000746527208ULL, 0x000fe40004000000ULL,
0x0000005538557208ULL, 0x000fe40004800000ULL, 0x0000000437057208ULL, 0x000fe40005000000ULL,
0x000000060b077208ULL, 0x000fc40005800000ULL, 0x000000455200720bULL, 0x000fe40003f1e000ULL,
0x0000002a5500720bULL, 0x000fe40003f3e000ULL, 0x0000003e0500720bULL, 0x000fe40003f5e000ULL,
0x0000000c0700720bULL, 0x000fe40003f7e000ULL, 0x0000005245537208ULL, 0x000fe40004000000ULL,
0x000000552a047208ULL, 0x000fc40004800000ULL, 0x000000053e067208ULL, 0x000fe40005000000ULL,
0x000000070c527208ULL, 0x000fe40005800000ULL, 0x0000002b0400720bULL, 0x000fe40003f3e000ULL,
0x000000445300720bULL, 0x000fe40003f1e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x0000000d5200720bULL, 0x000fc40003f7e000ULL, 0x000000042b047208ULL, 0x000fe40004800000ULL,
0x0000005344547208ULL, 0x000fe40004000000ULL, 0x0000000639057208ULL, 0x000fe40005000000ULL,
0x000000520d077208ULL, 0x000fe40005800000ULL, 0x0000003d0400720bULL, 0x000fe40003f3e000ULL,
0x000000435400720bULL, 0x000fc40003f1e000ULL, 0x0000003a0500720bULL, 0x000fe40003f5e000ULL,
0x0000000e0700720bULL, 0x000fe40003f7e000ULL, 0x000000043d557208ULL, 0x000fe40004800000ULL,
0x0000005443537208ULL, 0x000fe40004000000ULL, 0x000000053a047208ULL, 0x000fe40005000000ULL,
0x000000070e067208ULL, 0x000fc40005800000ULL, 0x000000425300720bULL, 0x000fe40003f1e000ULL,
0x0000003c5500720bULL, 0x000fe40003f3e000ULL, 0x0000003b0400720bULL, 0x000fe40003f5e000ULL,
0x0000000f0600720bULL, 0x000fe40003f7e000ULL, 0x0000005342077208ULL, 0x000fe40004000000ULL,
0x000000553c547208ULL, 0x000fc40004800000ULL, 0x000000043b587208ULL, 0x000fe40005000000ULL,
0x000000060f577208ULL, 0x000fe20005800000ULL, 0x00001ea27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704597208ULL, 0x000fe20004000000ULL, 0x00001eb27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0054047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0058057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0057067f89ULL, 0x000e6200000e0000ULL, 0x000000045400720bULL, 0x008fc40003f1e000ULL,
0x000000055800720bULL, 0x010fe40003f3e000ULL, 0x0000005404077208ULL, 0x006fe40004000000ULL,
0x0000005805527208ULL, 0x000fe20004800000ULL, 0x0c201f0059047f89ULL, 0x000e6200000e0000ULL,
0x000000065700720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007567f89ULL, 0x000ea200000e0000ULL,
0x0000005706547208ULL, 0x000fc60004000000ULL, 0x0c201f0052537f89ULL, 0x000ee800000e0000ULL,
0x0c201f0054557f89ULL, 0x0002e400000e0000ULL, 0x000000045900720bULL, 0x002fe40003f1e000ULL,
0x000000560700720bULL, 0x004fe40003f3e000ULL, 0x0000005904047208ULL, 0x000fc40004000000ULL,
0x000000535200720bULL, 0x008fe40003f5e000ULL, 0x0000000756057208ULL, 0x000fe40004800000ULL,
0x0000005253067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x000000555400720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c08087812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b49567823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4e497823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b42427823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL,
0x0000004c00537308ULL, 0x0003e60000000800ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe20000010807ULL, 0x0000005455077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b054c7820ULL, 0x002fe20000410000ULL, 0x0000004b00527308ULL, 0x000fe20000000800ULL,
0x00000002ff547819ULL, 0x000fc4000001166dULL, 0x3fb8aa3b07637820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b41417823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010863ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010863ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010863ULL,
0x00000041004e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010863ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b40407823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001084cULL, 0x0000000854717824ULL, 0x000fe200078e00ffULL,
0x0000002800417308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b3c3c7823ULL, 0x000fe2000001084cULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010863ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010863ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010863ULL,
0x00000029005d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010863ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010863ULL, 0x3fb8aa3b10107823ULL, 0x000fe20000010863ULL,
0x000000036dff7812ULL, 0x000fc8000780c0ffULL, 0x0000002a005e7308ULL, 0x000ff00000000800ULL,
0x0000003000287308ULL, 0x000ff00000000800ULL, 0x0000003100297308ULL, 0x000e700000000800ULL,
0x0000005100517308ULL, 0x000ff00000000800ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x000000282928723eULL, 0x002fce00000010ffULL, 0x0000004f004f7308ULL, 0x000ff00000000800ULL,
0x00000024004b7308ULL, 0x0002b00000000800ULL, 0x0000002100577308ULL, 0x0007e20000000800ULL,
0x0000000854247824ULL, 0x002fce00078e00ffULL, 0x0000002500587308ULL, 0x000fe20000000800ULL,
0x0000000154217810ULL, 0x008fc80007ffe0ffULL, 0xfffffff824657812ULL, 0x000fe400078ee221ULL,
0x0000000254217810ULL, 0x000fe20007ffe0ffULL, 0x00000032002a7308ULL, 0x000fe60000000800ULL,
0xfffffff824677812ULL, 0x000fe400078ee221ULL, 0x0000004b4e21723eULL, 0x004fe200000010ffULL,
0x00000008544e7824ULL, 0x040fe400078e00ffULL, 0x0000002200307308ULL, 0x0003e20000000800ULL,
0x00000008544b7824ULL, 0x000fca00078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe400078ee254ULL,
0x0000002000317308ULL, 0x0005e20000000800ULL, 0x0000000454227810ULL, 0x002fc80007ffe0ffULL,
0xfffffff871717812ULL, 0x000fe400078ee222ULL, 0x0000004f5222723eULL, 0x000fe200000010ffULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x000000514a20723eULL, 0x004fe200000010ffULL,
0x00000008544a7824ULL, 0x000fcc00078e00ffULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e700000000800ULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000001e00327308ULL, 0x0002b00000000800ULL,
0x0000003f005c7308ULL, 0x000fe20000000800ULL, 0x0000002e2f1e723eULL, 0x002fce00000010ffULL,
0x00000034003f7308ULL, 0x0003e20000000800ULL, 0x0000001f321f723eULL, 0x004fce00000010ffULL,
0x0000002300597308ULL, 0x0005e20000000800ULL, 0x00000004ff347e24ULL, 0x002fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0x3f8000003434783eULL, 0x000fe400000010ffULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0x0000000354237810ULL, 0x004fe40007ffe0ffULL,
0x000000ffff527224ULL, 0x000fca00078e0034ULL, 0x00000026005a7308ULL, 0x0005f00000000800ULL,
0x0000002b005f7308ULL, 0x000fe20000000800ULL, 0x0000000854267824ULL, 0x004fe200078e00ffULL,
0x000000594025723eULL, 0x002fc800000010ffULL, 0xfffffff8266f7812ULL, 0x000fe400078ee223ULL,
0x00000033002b7308ULL, 0x0002a20000000800ULL, 0x000000575823723eULL, 0x000fe400000010ffULL,
0x0000001054577810ULL, 0x000fca0007ffe0ffULL, 0x00000035004c7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b1d337823ULL, 0x002fe20000010863ULL, 0x00000030311d723eULL, 0x000fe200000010ffULL,
0x000000ffff307224ULL, 0x100fe400078e0034ULL, 0x000000ffff317224ULL, 0x000fc600078e0034ULL,
0x0000003a00607308ULL, 0x0003e20000000800ULL, 0x000000ffff357224ULL, 0x008fe200078e0034ULL,
0x0000002a2b2a723eULL, 0x004fcc00000010ffULL, 0x0000005000507308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1c3a7823ULL, 0x002fe20000010863ULL, 0x0000002d2c1c723eULL, 0x000fe400000010ffULL,
0x00000034202c723cULL, 0x000b6800000418ffULL, 0x0000003900617308ULL, 0x000fe60000000800ULL,
0x0000000554357810ULL, 0x020fca0007ffe0ffULL, 0x0000003300397308ULL, 0x0003e20000000800ULL,
0x000000505324723eULL, 0x004fe200000010ffULL, 0x0000000854507824ULL, 0x000fe400078e00ffULL,
0x000000ffff537224ULL, 0x000fc800078e0034ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x000000301c30723cULL, 0x002f6e00000418ffULL, 0x0000001100407308ULL, 0x000e700000000800ULL,
0x0000005600567308ULL, 0x000ff00000000800ULL, 0x0000004d004d7308ULL, 0x000ea20000000800ULL,
0x00000013402b723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b0c407823ULL, 0x000fe20000010863ULL,
0x000000ffff0c7224ULL, 0x000fca00078e0034ULL, 0x0000003a003a7308ULL, 0x000e700000000800ULL,
0x00000027005b7308ULL, 0x0007e20000000800ULL, 0x000000564d26723eULL, 0x004fe400000010ffULL,
0xfffffff84a4d7812ULL, 0x000fe200078ee235ULL, 0x3fb8aa3b0e4a7823ULL, 0x000fe20000010863ULL,
0x000000393a29723eULL, 0x002fc600000010ffULL, 0x0000003800387308ULL, 0x000e620000000800ULL,
0x0000005a4127723eULL, 0x008fe200000010ffULL, 0x000000ffff397224ULL, 0x000fe200078e0034ULL,
0xffffffff54417810ULL, 0x000fc80007ffe0ffULL, 0xfffffff850517812ULL, 0x000fe200078ee241ULL,
0x3fb8aa3b0d417823ULL, 0x100fe20000010863ULL, 0x000000ffff0d7224ULL, 0x100fe200078e0034ULL,
0x00000052242c723cULL, 0x000be2000004182cULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0f637823ULL, 0x000fe20000010863ULL, 0x0000005d380f723eULL, 0x002fe200000010ffULL,
0x000000ffff387224ULL, 0x000fc800078e0034ULL, 0x0000000c2830723cULL, 0x020b620000041830ULL,
0x0000004800487308ULL, 0x000e620000000800ULL, 0x0000000854537810ULL, 0x000fca0007ffe0ffULL,
0x0000005b5c0d723eULL, 0x020fe400000010ffULL, 0x0000004700477308ULL, 0x000ff00000000800ULL,
0x0000004600467308ULL, 0x000ea20000000800ULL, 0x00000049480c723eULL, 0x002fce00000010ffULL,
0x0000001200357308ULL, 0x0003f00000000800ULL, 0x00000010003a7308ULL, 0x0007220000000800ULL,
0x0000000857127824ULL, 0x002fe200078e00ffULL, 0x00000047460e723eULL, 0x004fc800000010ffULL,
0xfffffff812577812ULL, 0x000fe400078ee257ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x0000003f4c10723eULL, 0x008fce00000010ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000353a11723eULL, 0x010fe200000010ffULL, 0x000000ffff357224ULL, 0x000fcc00078e0034ULL,
0x0000000a000a7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x000000363712723eULL, 0x002fce00000010ffULL, 0x0000003b00557308ULL, 0x0003e20000000800ULL,
0x0000000a0b13723eULL, 0x004fce00000010ffULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x00000006543b7810ULL, 0x002fe40007ffe0ffULL, 0x0000a0001a0a7811ULL, 0x000fe400078e60ffULL,
0xfffffff84e4f7812ULL, 0x000fe200078ee23bULL, 0x000000341030723cULL, 0x000fe20000041830ULL,
0x0000001854547810ULL, 0x000fe20007ffe0ffULL, 0x0000003c003c7308ULL, 0x000e620000000800ULL,
0x00000008534e7824ULL, 0x000fe400078e00ffULL, 0x000000104b4b7824ULL, 0x000fc400078e020aULL,
0x0000000854477824ULL, 0x000fe200078e00ffULL, 0x000000380c38723cULL, 0x000b62000004182cULL,
0x0000001065657824ULL, 0x100fe200078e020aULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x0000001067677824ULL, 0x100fe200078e020aULL, 0xfffffff84e537812ULL, 0x000fe200078ee253ULL,
0x000000106f6f7824ULL, 0x000fe200078e020aULL, 0xfffffff847477812ULL, 0x000fe200078ee254ULL,
0x0000001071717824ULL, 0x000fe200078e020aULL, 0x0000005e5f2d723eULL, 0x020fe200000010ffULL,
0x000000014b4b7824ULL, 0x000fe200078e0208ULL, 0x0000004400447308ULL, 0x000ea20000000800ULL,
0x0000003d3c2f723eULL, 0x002fe200000010ffULL, 0x000000104d4d7824ULL, 0x000fc400078e020aULL,
0x0000000108657824ULL, 0x040fe200078e0265ULL, 0x000000204b007388ULL, 0x0003e20000000800ULL,
0x000000104f4f7824ULL, 0x100fe400078e020aULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x0000000108677824ULL, 0x040fe200078e0267ULL, 0x0000002265007388ULL, 0x0003e20000000800ULL,
0x0000001051517824ULL, 0x100fe400078e020aULL, 0x00000001086f7824ULL, 0x000fe200078e026fULL,
0x0000002467007388ULL, 0x0003e20000000800ULL, 0x0000001053537824ULL, 0x000fe200078e020aULL,
0x0000004200427308ULL, 0x000ee20000000800ULL, 0x00000045442c723eULL, 0x004fe200000010ffULL,
0x0000000108717824ULL, 0x040fe200078e0271ULL, 0x000000266f007388ULL, 0x0003e20000000800ULL,
0x00000001084d7824ULL, 0x000fc400078e024dULL, 0x00000001084f7824ULL, 0x040fe200078e024fULL,
0x0000000c71007388ULL, 0x0003e20000000800ULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x0000001057577824ULL, 0x100fe400078e020aULL, 0x0000001047477824ULL, 0x000fe200078e020aULL,
0x0000000e4d007388ULL, 0x0003e20000000800ULL, 0x0000000108517824ULL, 0x040fe400078e0251ULL,
0x00000001080a7824ULL, 0x000fe200078e0253ULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x00000043422e723eULL, 0x008fe200000010ffULL, 0x0000002c4f007388ULL, 0x0003e20000000800ULL,
0x0000000108577824ULL, 0x000fc400078e0257ULL, 0x0000000108087824ULL, 0x000fe200078e0247ULL,
0x0000002e51007388ULL, 0x0003e40000000800ULL, 0x0000004100417308ULL, 0x000ee20000000800ULL,
0x0000003e613c723eULL, 0x004fe200000010ffULL, 0x000000342c38723cULL, 0x000f620000041838ULL,
0x00000060553e723eULL, 0x000fe200000010ffULL, 0x000000210a007388ULL, 0x0003e80000000800ULL,
0x0000004a004a7308ULL, 0x000fe20000000800ULL, 0x0004002365007388ULL, 0x0003e80000000800ULL,
0x0004002567007388ULL, 0x0003e60000000800ULL, 0x0000006300637308ULL, 0x000ea20000000800ULL,
0x00000040413d723eULL, 0x008fe200000010ffULL, 0x000400276f007388ULL, 0x0003e80000000800ULL,
0x0004000d71007388ULL, 0x0003e80000000800ULL, 0x0004000f4d007388ULL, 0x0003e20000000800ULL,
0x000000ffff397224ULL, 0x020fc600078e003aULL, 0x0004002d4f007388ULL, 0x0003e20000000800ULL,
0x0000004a633f723eULL, 0x004fc600000010ffULL, 0x0004002f51007388ULL, 0x0003e80000000800ULL,
0x0000001c57007388ULL, 0x0003e20000000800ULL, 0x000000343c30723cULL, 0x000f660000041830ULL,
0x0008001e65007388ULL, 0x0003e80000000800ULL, 0x0008002867007388ULL, 0x0003e80000000800ULL,
0x0008002a6f007388ULL, 0x0003e80000000800ULL, 0x0008001071007388ULL, 0x0003e80000000800ULL,
0x000800124d007388ULL, 0x0003e80000000800ULL, 0x0008003c4f007388ULL, 0x0003e20000000800ULL,
0x000000ffff3a7224ULL, 0x020fc400078e0030ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0032ULL,
0x0008003e51007388ULL, 0x0003e80000000800ULL, 0x0000001d08007388ULL, 0x0003e80000000800ULL,
0x000c001f65007388ULL, 0x0003e80000000800ULL, 0x000c002967007388ULL, 0x0003e80000000800ULL,
0x000c002b6f007388ULL, 0x0003e80000000800ULL, 0x000c001171007388ULL, 0x0003e80000000800ULL,
0x000c00134d007388ULL, 0x0003e80000000800ULL, 0x000c003d4f007388ULL, 0x0003e80000000800ULL,
0x000c003f51007388ULL, 0x0003e80000000800ULL, 0x0120000409008388ULL, 0x0003e80000000c00ULL,
0x0122003809008388ULL, 0x0003e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000069ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080069ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100069ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000168687810ULL, 0x000fe20007ffe0ffULL, 0x0000180069ff7f8cULL, 0x0003e6000c80043fULL,
0x000000156800720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff902000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x0001891000267802ULL, 0x000fc40000000f00ULL,
0x00000e8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0025ULL,
0xfffe9db000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001896000267802ULL, 0x000fc40000000f00ULL, 0x00000e3000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0025ULL, 0xfffe9e1000007947ULL, 0x000fea000383ffffULL,
0x000189a000257802ULL, 0x000fc40000000f00ULL, 0x00000da000007944ULL, 0x002fea0003c00000ULL,
0xfffe9ef000007947ULL, 0x000fea000383ffffULL, 0x000189d000257802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x002fea0003c00000ULL, 0xfffea03000007947ULL, 0x000fea000383ffffULL,
0x00018a0000257802ULL, 0x000fc40000000f00ULL, 0x00000d4000007944ULL, 0x002fea0003c00000ULL,
0xfffea17000007947ULL, 0x000fea000383ffffULL, 0x00018a3000257802ULL, 0x000fc40000000f00ULL,
0x00000d1000007944ULL, 0x002fea0003c00000ULL, 0xfffea2a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x00018a7000257802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffea6d000007947ULL, 0x000fea000383ffffULL, 0x00018ab000257802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001002267810ULL, 0x000fe40007ffe0ffULL, 0x00018af000257802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffea6a000007947ULL, 0x000fea000383ffffULL, 0x00018b3000257802ULL, 0x000fc40000000f00ULL,
0x00000c1000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffea69000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x00018b8000267802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0025ULL, 0xfffecfa000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x00018bd000267802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff707224ULL, 0x000fe200078e0025ULL,
0xfffecff000007947ULL, 0x000fea000383ffffULL, 0x00018c1000257802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x004fea0003c00000ULL, 0xfffed0d000007947ULL, 0x000fea000383ffffULL,
0x00018c4000257802ULL, 0x000fc40000000f00ULL, 0x00000b0000007944ULL, 0x006fea0003c00000ULL,
0xfffed21000007947ULL, 0x000fea000383ffffULL, 0x00018c7000257802ULL, 0x000fc40000000f00ULL,
0x00000ad000007944ULL, 0x00efea0003c00000ULL, 0xfffed35000007947ULL, 0x000fea000383ffffULL,
0x00018ca000257802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x00efea0003c00000ULL,
0xfffed48000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001eULL,
0x00018ce000257802ULL, 0x000fc40000000f00ULL, 0x00000a6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffed8a000007947ULL, 0x000fea000383ffffULL,
0x00018d2000257802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000101e267810ULL, 0x000fc40007ffe0ffULL,
0x00018d6000257802ULL, 0x000fc40000000f00ULL, 0x000009e000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffed87000007947ULL, 0x000fea000383ffffULL,
0x00018da000257802ULL, 0x000fc40000000f00ULL, 0x000009a000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffed86000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x00018df000267802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0025ULL,
0xffff00e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x00018e4000267802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff237224ULL, 0x000fe200078e0025ULL, 0xffff013000007947ULL, 0x000fea000383ffffULL,
0x00018e8000257802ULL, 0x000fc40000000f00ULL, 0x000008c000007944ULL, 0x002fea0003c00000ULL,
0xffff021000007947ULL, 0x000fea000383ffffULL, 0x00018eb000257802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x002fea0003c00000ULL, 0xffff035000007947ULL, 0x000fea000383ffffULL,
0x00018ee000257802ULL, 0x000fc40000000f00ULL, 0x0000086000007944ULL, 0x002fea0003c00000ULL,
0xffff049000007947ULL, 0x000fea000383ffffULL, 0x00018f1000257802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x002fea0003c00000ULL, 0xffff05c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0024ULL, 0x00018f5000257802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xffff09e000007947ULL, 0x000fea000383ffffULL, 0x00018f9000257802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001024267810ULL, 0x000fc40007ffe0ffULL, 0x00018fd000257802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xffff09b000007947ULL, 0x000fea000383ffffULL, 0x0001901000257802ULL, 0x000fc40000000f00ULL,
0x0000073000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xffff09a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x0001906000267802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0025ULL, 0xffff30c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x000190b000267802ULL, 0x000fc40000000f00ULL,
0x000006e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x000fe200078e0025ULL,
0xffff311000007947ULL, 0x000fea000383ffffULL, 0x000190f000257802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x000fea0003c00000ULL, 0xffff31f000007947ULL, 0x000fea000383ffffULL,
0x0001912000257802ULL, 0x000fc40000000f00ULL, 0x0000062000007944ULL, 0x002fea0003c00000ULL,
0xffff333000007947ULL, 0x000fea000383ffffULL, 0x0001915000257802ULL, 0x000fc40000000f00ULL,
0x000005f000007944ULL, 0x002fea0003c00000ULL, 0xffff347000007947ULL, 0x000fea000383ffffULL,
0x0001918000257802ULL, 0x000fc40000000f00ULL, 0x000005c000007944ULL, 0x002fea0003c00000ULL,
0xffff35a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000aULL,
0x000191c000257802ULL, 0x000fc40000000f00ULL, 0x0000058000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xffff39b000007947ULL, 0x000fea000383ffffULL,
0x0001920000257802ULL, 0x000fc40000000f00ULL, 0x0000054000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000100a267810ULL, 0x000fc40007ffe0ffULL,
0x0001924000257802ULL, 0x000fc40000000f00ULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xffff398000007947ULL, 0x000fea000383ffffULL,
0x0001928000257802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xffff397000007947ULL, 0x000fea000383ffffULL,
0x00000002ff567424ULL, 0x000fe200078e00ffULL, 0x000192d000527802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0055ULL,
0xffffe12000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e0054ULL,
0x0001933000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x000000555400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0058ULL, 0x0001939000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fe200078e00ffULL, 0x0000005455067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000555800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0057ULL, 0x000193f000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fe200078e00ffULL, 0x0000005855587208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000555700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0059ULL, 0x0001945000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005755547208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000555900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x000194b000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005955047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000550600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0058ULL, 0x0001951000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000000655057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000555800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x0001957000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005855067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffdff000007947ULL, 0x000fea000383ffffULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000022027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe690002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000005b00007348ULL, 0x000fe80003800000ULL,
0x0c00005607557389ULL, 0x0002a200000e005aULL, 0xfffe68c052007950ULL, 0x000fea0003c3ffffULL,
0x000000ffff6a7224ULL, 0x000fe200078e0025ULL, 0x0000007400007348ULL, 0x000fe80003800000ULL,
0x00000000ff6b7424ULL, 0x000fe200078e00ffULL, 0x0000002627267389ULL, 0x0002a600000e0077ULL,
0xfffe68706a007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f65070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000006f00007348ULL, 0x000ff60003800000ULL,
0x0000000000257806ULL, 0x000fc800058e0100ULL, 0x0000006f25257212ULL, 0x000fe200078ec0ffULL,
0xfffe681026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x000000000000089cULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001678ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000167cULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000019880ULL, 0xda00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b100ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b140ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001b4c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001678ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019a88ULL,
0x0000000000019a88ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001b100ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001b4c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_89_cubin_len = 112032;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
