/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001a528ULL, 0x000000000001a1a8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL,
0x2400000000000000ULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b00010000020cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000299ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b000100000383ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000003d1ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000042cULL, 0x0000000000018b30ULL,
0x0000000000000250ULL, 0x00040003000004a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000018d80ULL, 0x000d0003000004d2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00018b3000000000ULL,
0x00010c0400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x00018b3000000000ULL, 0x0000025000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000b9ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0050000900000000ULL, 0x000c17040021f000ULL,
0x0048000800000000ULL, 0x000c17040021f000ULL, 0x0040000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040061f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000001c000dc2804ULL, 0x0000096000000260ULL,
0x000029d000002960ULL, 0x00002be000002ab0ULL, 0x00002e5000002d10ULL, 0x000033e0000033d0ULL,
0x00003400000033f0ULL, 0x000059a000005930ULL, 0x00005bc000005a90ULL, 0x00005e3000005cf0ULL,
0x00006300000062f0ULL, 0x0000632000006310ULL, 0x00008940000088d0ULL, 0x00008b6000008a30ULL,
0x00008dd000008c90ULL, 0x000092b0000092a0ULL, 0x000092d0000092c0ULL, 0x0000b7500000b6e0ULL,
0x0000b9700000b840ULL, 0x0000bbe00000baa0ULL, 0x0000c0e00000c0d0ULL, 0x0000c1000000c0f0ULL,
0x0000db800000db70ULL, 0x0000dba00000db90ULL, 0x0001733000017280ULL, 0x000176f000017600ULL,
0x00017c0000017b10ULL, 0x00017f5000017e80ULL, 0x0000048004303904ULL, 0x0001a600000000ffULL,
0x0000056000040100ULL, 0x0001a60800000007ULL, 0x00000670003f0100ULL, 0x0001a68800000007ULL,
0x00000790003f0100ULL, 0x0001a6a800000003ULL, 0x000008a0003f0100ULL, 0x0001a6c800000002ULL,
0x00000fe0003f0100ULL, 0x0001a60000000009ULL, 0x00001100003f0107ULL, 0x0001a68800000000ULL,
0x00001a50003f0101ULL, 0x00000000000000ffULL, 0x00001ad000040107ULL, 0x00000000000000ffULL,
0x00001b5000040101ULL, 0x0000002000000003ULL, 0x00001c70003f0101ULL, 0x0001a6c800000041ULL,
0x00001df0003f0109ULL, 0x0001a6c800000041ULL, 0x00002650003f0109ULL, 0x0001a6b000000042ULL,
0x000026b0003f0107ULL, 0x0001a6b000000042ULL, 0x000026c0003f0101ULL, 0x0001a60800000040ULL,
0x00002700003f0101ULL, 0x0001a60800000075ULL, 0x00002870003f0109ULL, 0x0001a60800000075ULL,
0x00002fe0003f0109ULL, 0x0001a6a800000042ULL, 0x00003170003f0109ULL, 0x0001a6a800000042ULL,
0x00004d20003f0109ULL, 0x0001a6c80000003dULL, 0x00004d50003f0101ULL, 0x0001a6880000003eULL,
0x00004da0003f0101ULL, 0x0000000000000006ULL, 0x00004f10003f0109ULL, 0x0000000000000006ULL,
0x00005660003f0109ULL, 0x00000000000000ffULL, 0x000056a000050107ULL, 0x00000000000000ffULL,
0x000056b000050101ULL, 0x0001a62800000075ULL, 0x00005710003f0101ULL, 0x0001a62800000041ULL,
0x00005880003f0109ULL, 0x0001a62800000041ULL, 0x00005ff0003f0109ULL, 0x0001a6b00000003fULL,
0x00006160003f0109ULL, 0x0001a6b00000003fULL, 0x00007c70003f0109ULL, 0x0001a6c80000003cULL,
0x00007c90003f0101ULL, 0x0001a69000000080ULL, 0x00007cf0003f0101ULL, 0x0000000000000006ULL,
0x00007e60003f0109ULL, 0x0000000000000006ULL, 0x000085e0003f0109ULL, 0x00000008000000ffULL,
0x0000864000040107ULL, 0x0000000800000084ULL, 0x00008650003f0101ULL, 0x0001a64800000075ULL,
0x000086c0003f0101ULL, 0x0001a64800000041ULL, 0x00008830003f0109ULL, 0x0001a64800000041ULL,
0x00008f90003f0109ULL, 0x00000000000000ffULL, 0x0000910000050109ULL, 0x00000000000000ffULL,
0x0000aad000050109ULL, 0x0001a6c80000003cULL, 0x0000aaf0003f0101ULL, 0x0001a6980000003eULL,
0x0000ab50003f0101ULL, 0x0000000000000006ULL, 0x0000acc0003f0109ULL, 0x0000000000000006ULL,
0x0000b460003f0109ULL, 0x00000000000000ffULL, 0x0000b4a000040107ULL, 0x00000000000000ffULL,
0x0000b4b000050101ULL, 0x0001a66800000008ULL, 0x0000b4d0003f0101ULL, 0x0001a66800000008ULL,
0x0000b640003f0109ULL, 0x0001a66800000008ULL, 0x0000bd90003f0109ULL, 0x0001a6b00000003fULL,
0x0000bf00003f0109ULL, 0x0001a6b00000003fULL, 0x0000d980003f0109ULL, 0x0000000000000006ULL,
0x0000d9c0003f0101ULL, 0x0001a6a000000006ULL, 0x0000f6b0003f0101ULL, 0x0001a60000000009ULL,
0x00010ee0003f0101ULL, 0x0001a60000000009ULL, 0x00011050003f0109ULL, 0x0001a60000000009ULL,
0x000113b0003f0109ULL, 0x0001a60000000009ULL, 0x000113d0003f0101ULL, 0x0001a60000000009ULL,
0x00011540003f0109ULL, 0x0001a60000000009ULL, 0x00014b30003f0109ULL, 0x0001a6880000005aULL,
0x00014f30003f0101ULL, 0x0001a6880000005aULL, 0x000150a0003f0109ULL, 0x0001a6880000005aULL,
0x00018ad0003f0109ULL, 0x0001a60800000059ULL, 0x00018ae0003f0101ULL, 0x0001a61000000059ULL,
0x00018af0003f0101ULL, 0x0001a61800000059ULL, 0x00018b00003f0101ULL, 0x0001a62000000059ULL,
0x00053803003f0101ULL, 0x0000eaa000301c04ULL, 0x0000ecb00000eb00ULL, 0x0000ef700000ee10ULL,
0x0000f2300000f0d0ULL, 0x0000f5200000f390ULL, 0x000115700000f620ULL, 0x000c050400018b20ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL, 0x0000001600080a04ULL,
0x0000000000580210ULL, 0x00000000000000bcULL, 0x0000001500000002ULL, 0x0000000000018b30ULL,
0x0000000000000044ULL, 0x0000001500000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001500000002ULL, 0x0000000000000000ULL, 0x000000000001a700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff047b82ULL, 0x000ea20000000a00ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x00000000000f7919ULL, 0x000ee20000002300ULL,
0x0000010000057ab9ULL, 0x000fe20000000800ULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x0000000000087919ULL, 0x000ee60000002200ULL, 0x00008600ff197b82ULL, 0x000f220000000800ULL,
0x0000000000177919ULL, 0x000f220000002700ULL, 0x0000000500007306ULL, 0x004ea20000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00027836ULL, 0x004fcc0000000000ULL, 0x0000000200037305ULL, 0x000564000021f000ULL,
0x000000ffff027224ULL, 0x004fe400078e00ffULL, 0x000000ffff067224ULL, 0x020fc800078e0a03ULL,
0x0000000506077224ULL, 0x000fc800078e02ffULL, 0x0000000703037227ULL, 0x000fe400078e0002ULL,
0x0000000000077919ULL, 0x000ea80000002100ULL, 0x0000000403717c27ULL, 0x000fc8000f8e00ffULL,
0x000000ffff067224ULL, 0x000fc800078e0a71ULL, 0x0000000405007e24ULL, 0x000fe2000f8e0206ULL,
0x00000000000479c3ULL, 0x000f680000002600ULL, 0x000000050000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a05ULL, 0x0000000171710836ULL, 0x000fe20000000000ULL,
0x00000005ff787819ULL, 0x004fe40000011607ULL, 0x000000050000720cULL, 0x000fc80003f26070ULL,
0x00001fff78787589ULL, 0x000f3200000e0000ULL, 0x0000000171711836ULL, 0x000fe20000000000ULL,
0x00000005ff71a212ULL, 0x000fc800078e33ffULL, 0x0000007100007306ULL, 0x000ea20000209000ULL,
0x000000ff7100720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x006e640000001000ULL,
0x0ffffffe00027836ULL, 0x002fe40000000000ULL, 0x000000050f007c24ULL, 0x008fe2000f8e0208ULL,
0x0000000000057ab9ULL, 0x000fc60000000800ULL, 0x0000000200037305ULL, 0x0002a2000021f000ULL,
0x00001fff0f0f7589ULL, 0x000f2200000e0000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000371067224ULL, 0x004fc800078e02ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a06ULL,
0x0000000903037227ULL, 0x000fc800078e0002ULL, 0x0000000500027c24ULL, 0x000fe4000f8e0207ULL,
0x0000000403087c27ULL, 0x020fc6000f8e00ffULL, 0x0000007f0200780cULL, 0x040fe20003f64070ULL,
0x000000ffff007224ULL, 0x000fe200078e0a08ULL, 0x000000030200780cULL, 0x000fc60003f84070ULL,
0x0000000471007e24ULL, 0x000fca000f8e0200ULL, 0x000000710000720cULL, 0x000fc60003f06070ULL,
0x000000000003b919ULL, 0x000e620000008800ULL, 0xff317217ff06b424ULL, 0x000fd200078e00ffULL,
0x0000000100000824ULL, 0x000fe400078e0a71ULL, 0x0000000108080836ULL, 0x000fe20000000000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000710000720cULL, 0x000fe40003f26070ULL,
0x000004000000b802ULL, 0x000fd60000000f00ULL, 0x0000000108081836ULL, 0x000fe20000000000ULL,
0x00000071ff08a212ULL, 0x000fe400078e33ffULL, 0x0000000f0200780cULL, 0x040fe40003f24070ULL,
0x000006540303b816ULL, 0x002fe20000000000ULL, 0x000000ffff007224ULL, 0x000fe200078e0a08ULL,
0x000000010200780cULL, 0x000fc60003f44070ULL, 0x0000000471717e24ULL, 0x000fe4000f8e0200ULL,
0x000000040203b824ULL, 0x000fe400078e0203ULL, 0x0000002071007824ULL, 0x000fe200078e00ffULL,
0x0000000000240947ULL, 0x010fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01a60006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402077c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000070612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a60804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402077c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000070612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a68804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01a400060300b388ULL, 0x0003e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000030612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a6a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a00ULL, 0x0000001904037219ULL, 0x082fe200000006ffULL,
0x0000000417047224ULL, 0x000fe200078e02ffULL, 0x00000019050b7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x00000020036d7446ULL, 0x000fe20003800002ULL,
0x000000040f027824ULL, 0x000fe200078e0278ULL, 0x0000001908767219ULL, 0x000fc400000006ffULL,
0x000000ff6d6d7207ULL, 0x000fe20000000000ULL, 0x0000000402027824ULL, 0x000fe400078e00ffULL,
0x0000000b04047224ULL, 0x000fe200078e0276ULL, 0x000000206d00780cULL, 0x000fda0003f05270ULL,
0x0000000000c48947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0xffffffffff0c7424ULL, 0x000fe200078e00ffULL, 0x000000026d037248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000127919ULL, 0x000ea20000008800ULL,
0x0000040000097802ULL, 0x000fe40000000f00ULL, 0x000000190c077219ULL, 0x000fe200000006ffULL,
0x0000000103037824ULL, 0x000fe200078e0a02ULL, 0x00000004ff067819ULL, 0x002fc8000001160aULL,
0x000000030600720cULL, 0x080fe20003f06070ULL, 0x00000002060e7836ULL, 0x000fe20000000000ULL,
0x0000065412097816ULL, 0x004fe20000000009ULL, 0x0000000102137824ULL, 0x040fe400078e0206ULL,
0x0000000102157824ULL, 0x000fe200078e020eULL, 0x000000030e00720cULL, 0x000fe20003f26070ULL,
0x00000001000c7824ULL, 0x040fe400078e0213ULL, 0x0000000100107824ULL, 0x000fe400078e0215ULL,
0x000000100a037824ULL, 0x000fe200078e00ffULL, 0x000000070c0d7212ULL, 0x080fe200078e30ffULL,
0x0000000113027824ULL, 0x040fe200078e020aULL, 0x0000000710077212ULL, 0x000fe200078e30ffULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0x00000019ff0c7219ULL, 0x080fe2000001160cULL,
0x00000001040d7824ULL, 0x040fe200078e020dULL, 0x00000019ff107219ULL, 0x000fe20000011610ULL,
0x0000000104077824ULL, 0x000fe200078e0207ULL, 0x000000f003117812ULL, 0x000fe200078ec0ffULL,
0x0000000b0c067224ULL, 0x080fe200078e020dULL, 0xfffffff013027812ULL, 0x000fe200078ee202ULL,
0x0000000b100c7224ULL, 0x000fc400078e0207ULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001106067212ULL, 0x000fc600078efcffULL,
0x0000000115047824ULL, 0x040fe200078e020aULL, 0x000000110c0c7212ULL, 0x000fe200078efcffULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001002117824ULL, 0x100fe200078e0209ULL, 0x000000040c0c7c10ULL, 0x000fe4000ff7e0ffULL,
0xfffffff015047812ULL, 0x000fe400078ee204ULL, 0x0000000507077c10ULL, 0x000fe400097fe4ffULL,
0x000000050d0d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000001004137824ULL, 0x000fc400078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e8000c101c46ULL,
0x000000000c137faeULL, 0x0003e2000c901c46ULL, 0x0000000000a87947ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000e620000000000ULL, 0x0000040000097802ULL, 0x000fe20000000f00ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000c7919ULL, 0x000ea20000008800ULL,
0x000000020a117211ULL, 0x002fe200078fe0ffULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0x000006540c097816ULL, 0x004fc60000000009ULL, 0x0000000211137836ULL, 0x000fe20000000000ULL,
0x0000001902077219ULL, 0x000fe200000006ffULL, 0x0000000100027824ULL, 0x040fe400078e0211ULL,
0x0000000100067824ULL, 0x000fc600078e0213ULL, 0x0000000702037212ULL, 0x080fe400078e30ffULL,
0x0000000706077212ULL, 0x000fe400078e30ffULL, 0x00000019ff027219ULL, 0x080fe20000011602ULL,
0x0000000104037824ULL, 0x040fe200078e0203ULL, 0x00000019ff067219ULL, 0x000fe20000011606ULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x0000000b02027224ULL, 0x000fe400078e0203ULL,
0x000000100a037824ULL, 0x000fc400078e00ffULL, 0x0000000b060c7224ULL, 0x000fe400078e0207ULL,
0x0000010002067825ULL, 0x000fe200078e00ffULL, 0x000000f003157812ULL, 0x000fc600078ec0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001506067212ULL, 0x000fc600078efcffULL,
0x0000000111027824ULL, 0x140fe200078e020aULL, 0x000000150c0c7212ULL, 0x000fe200078efcffULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000113047824ULL, 0x040fe200078e020aULL, 0x000000040c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0xfffffff011027812ULL, 0x000fe400078ee202ULL,
0x0000000507077c10ULL, 0x000fe400087fe4ffULL, 0xfffffff013047812ULL, 0x000fe200078ee204ULL,
0x0000001002117824ULL, 0x000fe200078e0209ULL, 0x000000050d0d7c10ULL, 0x000fc60008ffe4ffULL,
0x0000001004137824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e8000b901c46ULL, 0x000000000c137faeULL, 0x0003e4000b901c46ULL,
0x00000000090472caULL, 0x000fe200000e0000ULL, 0x00009000ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001a60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000417067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606617981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x000000ff61027836ULL, 0x004fca0000000000ULL, 0x00000008ff5b7819ULL, 0x000fce0000011602ULL,
0x000000e400688947ULL, 0x000fea0003800000ULL, 0x00000008786c7824ULL, 0x000fe200078e00ffULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff607819ULL, 0x000fe20000011678ULL, 0x0000000109007824ULL, 0x000fe200078e026cULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000000178707812ULL, 0x000fe400078ec0ffULL,
0x01a6880700ff79a7ULL, 0x0003e2000850003fULL, 0x00000020605a7824ULL, 0x000fe400078e00ffULL,
0x0000000217007824ULL, 0x002fc800078e00ffULL, 0x0000000500597224ULL, 0x000fc800078e0205ULL,
0x0000000108597824ULL, 0x000fc800078e0259ULL, 0x0000000459007c24ULL, 0x000fe2000f8e025aULL,
0x0000000400000947ULL, 0x000fec0003800000ULL, 0x0000005a61057248ULL, 0x000fe20007fe0000ULL,
0x0000001070027824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fe2000001160aULL,
0x00008e0000047ab9ULL, 0x000fe40000000a00ULL, 0x0000000105057824ULL, 0x000fe400078e0a5aULL,
0x0000000102077824ULL, 0x000fe400078e0204ULL, 0x00000004040c7836ULL, 0x000fe20000000000ULL,
0x0000000205057248ULL, 0x000fe20007fe0000ULL, 0x0000000107067824ULL, 0x000fc400078e020aULL,
0x00000008070d7824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x000fe400078e0a02ULL,
0x00000008040e7836ULL, 0x000fe20000000000ULL, 0xfffffff80d087812ULL, 0x000fe200078ee206ULL,
0x00000001020d7824ULL, 0x000fe200078e020cULL, 0x000000050c00720cULL, 0x080fe20003f46070ULL,
0x0000000c040c7836ULL, 0x000fe20000000000ULL, 0x000000050400720cULL, 0x080fe20003f66070ULL,
0x0000000100047824ULL, 0x000fe200078e0207ULL, 0x000000050e00720cULL, 0x080fe20003f26070ULL,
0x000000010d067824ULL, 0x000fe200078e020aULL, 0x000000050c00720cULL, 0x000fe20003f06070ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x000000080d117824ULL, 0x000fe400078e00ffULL,
0x00000001020f7824ULL, 0x040fe400078e020cULL, 0x0000000102077824ULL, 0x000fe200078e020eULL,
0x00000070040e7812ULL, 0x000fe200078ef803ULL, 0x0000000100127824ULL, 0x000fe200078e020fULL,
0xfffffff811027812ULL, 0x000fe200078ee206ULL, 0x000000010f047824ULL, 0x040fe200078e020aULL,
0x000000040e0e7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000080f0f7824ULL, 0x000fc400078e00ffULL,
0x0000000100067824ULL, 0x040fe400078e0207ULL, 0x00000001070c7824ULL, 0x040fe200078e020aULL,
0xfffffff80f147812ULL, 0x000fe200078ee204ULL, 0x00000001000d7824ULL, 0x000fe200078e020dULL,
0x00000005050f7c10ULL, 0x000fe2000a7fe4ffULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000200060007824ULL, 0x000fe400078e0209ULL, 0x000000800d047825ULL, 0x000fe200078e00ffULL,
0xfffffff807107812ULL, 0x000fc600078ee20cULL, 0x0001600000117836ULL, 0x000fe40000000000ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x00000080120c7825ULL, 0x000fc800078e00ffULL,
0x0000001002157824ULL, 0x100fe200078e0211ULL, 0x0000007004027812ULL, 0x000fe200078ef803ULL,
0x0000001008137824ULL, 0x100fe200078e0211ULL, 0x0000007006047812ULL, 0x000fe200078ef803ULL,
0x0000001010177824ULL, 0x100fe200078e0211ULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x0000001014117824ULL, 0x000fe200078e0211ULL, 0x0000000402027c10ULL, 0x000fe2000ff9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e137faeULL, 0x0003e2000d901c46ULL,
0x0000000404047c10ULL, 0x000fe4000ffbe0ffULL, 0x0000000403067c10ULL, 0x000fc4000ffde0ffULL,
0x0000000505037c10ULL, 0x000fe4000a7fe4ffULL, 0x0000000507057c10ULL, 0x000fe4000affe4ffULL,
0x000000050d077c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000002157faeULL, 0x0003e8000d101c46ULL,
0x0000000004177faeULL, 0x0003e8000c901c46ULL, 0x0000000006117faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000001070057824ULL, 0x000fe200078e00ffULL,
0x00008e0000047ab9ULL, 0x000fc80000000a00ULL, 0x000000050a057211ULL, 0x000fca00078fe8ffULL,
0x0000000405077836ULL, 0x000fe40000000000ULL, 0x0000000105027824ULL, 0x140fe400078e020aULL,
0x00000008050d7824ULL, 0x000fe400078e00ffULL, 0x0000000107067824ULL, 0x040fe400078e020aULL,
0x00000008070f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d027812ULL, 0x000fe200078ee202ULL,
0x0000000100047824ULL, 0x000fc400078e0205ULL, 0x00000008050d7836ULL, 0x000fe20000000000ULL,
0xfffffff80f087812ULL, 0x000fe200078ee206ULL, 0x0000000c050f7836ULL, 0x000fe40000000000ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x00000001000c7824ULL, 0x040fe200078e020fULL,
0x00000070040e7812ULL, 0x000fe200078ef803ULL, 0x000000010f047824ULL, 0x140fe400078e020aULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x000000040e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000100077824ULL, 0x040fe400078e0207ULL, 0x0000000100067824ULL, 0x000fe200078e020dULL,
0xfffffff80f107812ULL, 0x000fe200078ee204ULL, 0x000000010d007824ULL, 0x040fe200078e020aULL,
0x00000005050f7c10ULL, 0x000fe200087fe4ffULL, 0x000000080d117824ULL, 0x000fc400078e00ffULL,
0x00002000600d7824ULL, 0x000fe400078e0209ULL, 0x0000008007047825ULL, 0x000fe200078e00ffULL,
0xfffffff811007812ULL, 0x000fc600078ee200ULL, 0x000160000d177836ULL, 0x000fe40000000000ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000001002117824ULL, 0x100fe200078e0217ULL, 0x0000007004027812ULL, 0x000fe200078ef803ULL,
0x0000001008137824ULL, 0x100fe200078e0217ULL, 0x0000007006047812ULL, 0x000fe200078ef803ULL,
0x0000001000157824ULL, 0x100fe200078e0217ULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x0000001010177824ULL, 0x000fe200078e0217ULL, 0x0000000402027c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e2000b901c46ULL,
0x0000000404047c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000403067c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000505037c10ULL, 0x000fe400087fe4ffULL, 0x0000000507057c10ULL, 0x000fe40008ffe4ffULL,
0x000000050d077c10ULL, 0x000fe200097fe4ffULL, 0x0000000002137faeULL, 0x0003e8000b901c46ULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0000000006177faeULL, 0x0003e4000b901c46ULL,
0x0001a6a809037836ULL, 0x002fe20000000000ULL, 0x00000000600472caULL, 0x000fe200000e0000ULL,
0x00000001ff027424ULL, 0x000fe200078e00ffULL, 0x000000ff5b00720cULL, 0x000fe20003f05270ULL,
0x000000ffff7d7224ULL, 0x000fe200078e00ffULL, 0x00000000030572caULL, 0x000fe400000e0000ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000ffff317224ULL, 0x000fe400078e00ffULL, 0x0000000860037824ULL, 0x000fe200078e0203ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000002ff8079a7ULL, 0x0002a20008500004ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x0000000000527805ULL, 0x000fc4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00002002030279a7ULL, 0x002e62000850003fULL,
0x0000000000567805ULL, 0x000fc4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x000000bc009c8947ULL, 0x000fec0003800000ULL, 0x00000002ff587819ULL, 0x000fe20000011678ULL,
0x000000ffff407224ULL, 0x002fe200078e0003ULL, 0x0000000160007812ULL, 0x000fe200078ec0ffULL,
0xff317217ff7c7424ULL, 0x000fe200078e00ffULL, 0x000000086c087812ULL, 0x000fe200078ec0ffULL,
0x0000002058057824ULL, 0x000fe400078e0209ULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x0000001000057824ULL, 0x000fe400078e0205ULL, 0x000000ffff377224ULL, 0x000fc400078e00ffULL,
0x0000000108087824ULL, 0x000fce00078e0205ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000000478067824ULL, 0x000fca00078e00ffULL, 0xfffffff806067812ULL, 0x000fca00078ec0ffULL,
0x0000000109417824ULL, 0x000fc800078e0206ULL, 0x01a6c840410075a7ULL, 0x000e62000800017fULL,
0x0001a6c841067836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff427224ULL, 0x000fce00078e00ffULL, 0x000000104200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fce0000015200ULL,
0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000433e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000142427836ULL, 0x000fce0000000000ULL, 0x01a6c840410075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001073c7836ULL, 0x000fe20000000000ULL,
0x0000920000057ab9ULL, 0x000fe20000000800ULL, 0x00000100076f7824ULL, 0x000fc600078e025aULL,
0x0000005b3c00720cULL, 0x000fe20003f26070ULL, 0x000000406f3e7836ULL, 0x000fc80000000000ULL,
0x0000000559427c24ULL, 0x000fd0000f8e023eULL, 0x0000000400089947ULL, 0x000fea0003800000ULL,
0x0000003e613c7248ULL, 0x000fe20007fe0000ULL, 0x00000010703d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff3f7819ULL, 0x000fe2000001160aULL, 0x00008e0000087ab9ULL, 0x000fe40000000a00ULL,
0x000000013c3c7824ULL, 0x000fe400078e0a3eULL, 0x000000013d417824ULL, 0x000fe400078e023fULL,
0x000000043f407836ULL, 0x000fe20000000000ULL, 0x0000003c3d3c7248ULL, 0x000fe20007fe0000ULL,
0x00000001413e7824ULL, 0x000fc400078e020aULL, 0x0000000841477824ULL, 0x000fe400078e00ffULL,
0x000000013c3c7824ULL, 0x000fe400078e0a3dULL, 0x000000013d437824ULL, 0x000fe200078e0240ULL,
0xfffffff847477812ULL, 0x000fe400078ee23eULL, 0x0000003c4000720cULL, 0x080fe20003f66070ULL,
0x000000083f407836ULL, 0x000fe20000000000ULL, 0x0000003c3f00720cULL, 0x000fe20003f86070ULL,
0x0000000c3f3f7836ULL, 0x000fc40000000000ULL, 0x00000001433e7824ULL, 0x040fe200078e020aULL,
0x0000003c4000720cULL, 0x080fe20003f46070ULL, 0x00000008435d7824ULL, 0x000fe200078e00ffULL,
0x0000003c3f00720cULL, 0x000fe20003f06070ULL, 0x000000013d457824ULL, 0x040fe400078e0240ULL,
0x000000013d3d7824ULL, 0x000fe200078e023fULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee23eULL,
0x000000100a3f7824ULL, 0x000fe400078e00ffULL, 0x00000001413c7824ULL, 0x000fc400078e0242ULL,
0x00000001433e7824ULL, 0x100fe400078e0242ULL, 0x0000000145407824ULL, 0x100fe400078e0242ULL,
0x000000013d427824ULL, 0x000fe400078e0242ULL, 0x0000000145417824ULL, 0x140fe400078e020aULL,
0x0000000845447824ULL, 0x000fe200078e00ffULL, 0x000000703f457812ULL, 0x000fe200078ec0ffULL,
0x000000013d437824ULL, 0x000fc400078e020aULL, 0x000000083d467824ULL, 0x000fe200078e00ffULL,
0xfffffff8445f7812ULL, 0x000fe200078ee241ULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff846637812ULL, 0x000fe200078ee243ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000453c3c7212ULL, 0x000fc600078efcffULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x000000453e3e7212ULL, 0x080fe400078efcffULL, 0x000000083c3c7c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008042427825ULL, 0x000fe200078e00ffULL, 0x000000083e3e7c10ULL, 0x000fe4000ffde0ffULL,
0x0000004540407212ULL, 0x080fe200078efcffULL, 0x0000200060447824ULL, 0x000fe200078e0209ULL,
0x0000004542427212ULL, 0x000fe400078efcffULL, 0x000000093d3d7c10ULL, 0x000fe2000affe4ffULL,
0x0001700044447836ULL, 0x000fe20000000000ULL, 0x000000093f3f7c10ULL, 0x000fc4000b7fe4ffULL,
0x0000000840407c10ULL, 0x000fe2000ffbe0ffULL, 0x0000001047457824ULL, 0x100fe200078e0244ULL,
0x0000000842427c10ULL, 0x000fe2000ffde0ffULL, 0x000000105d477824ULL, 0x100fe200078e0244ULL,
0x0000000941417c10ULL, 0x000fe2000affe4ffULL, 0x000000105f5d7824ULL, 0x100fe200078e0244ULL,
0x0000000943437c10ULL, 0x000fe2000b7fe4ffULL, 0x00000010635f7824ULL, 0x000fe200078e0244ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000e101c46ULL,
0x000000003e477faeULL, 0x0003e8000d901c46ULL, 0x00000000405d7faeULL, 0x0003e8000d101c46ULL,
0x00000000425f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d47947ULL, 0x000fea0003800000ULL,
0x00000010703d7824ULL, 0x000fe200078e00ffULL, 0x00008e0000087ab9ULL, 0x000fe20000000a00ULL,
0x000000100a3e7824ULL, 0x000fc600078e00ffULL, 0x0000003d0a3d7211ULL, 0x000fe400078fe8ffULL,
0x000000703e5d7812ULL, 0x000fc600078ec0ffULL, 0x000000043d3f7836ULL, 0x000fe40000000000ULL,
0x000000013d3c7824ULL, 0x140fe400078e020aULL, 0x000000083d457824ULL, 0x000fe400078e00ffULL,
0x000000013f407824ULL, 0x040fe400078e020aULL, 0x000000083f477824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee23cULL, 0x000000083d417836ULL, 0x000fc40000000000ULL,
0x000000013d3c7824ULL, 0x000fe200078e0242ULL, 0xfffffff847477812ULL, 0x000fe200078ee240ULL,
0x0000000c3d5f7836ULL, 0x000fe40000000000ULL, 0x0000000141437824ULL, 0x040fe400078e020aULL,
0x0000000841447824ULL, 0x000fe400078e00ffULL, 0x000000013f3e7824ULL, 0x100fe400078e0242ULL,
0x0000000141407824ULL, 0x000fc400078e0242ULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x000000015f417824ULL, 0x040fe200078e020aULL, 0x0000005d3c3c7212ULL, 0x000fe200078efcffULL,
0x000000085f467824ULL, 0x040fe400078e00ffULL, 0x00002000603f7824ULL, 0x000fe200078e0209ULL,
0x000000083c3c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000015f427824ULL, 0x000fe200078e0242ULL,
0xfffffff8445f7812ULL, 0x000fe200078ee243ULL, 0x000170003f447836ULL, 0x000fe20000000000ULL,
0xfffffff846637812ULL, 0x000fe200078ee241ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000093d3d7c10ULL, 0x000fc600087fe4ffULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x0000005d3e3e7212ULL, 0x000fc600078efcffULL, 0x0000008042427825ULL, 0x000fe200078e00ffULL,
0x0000005d40407212ULL, 0x080fe400078efcffULL, 0x000000083e3e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001045457824ULL, 0x100fe200078e0244ULL, 0x0000005d42427212ULL, 0x000fe200078efcffULL,
0x0000001047477824ULL, 0x100fe200078e0244ULL, 0x0000000840407c10ULL, 0x000fe2000ff5e0ffULL,
0x000000105f5d7824ULL, 0x100fe200078e0244ULL, 0x0000000842427c10ULL, 0x000fe2000ff7e0ffULL,
0x00000010635f7824ULL, 0x000fe200078e0244ULL, 0x000000093f3f7c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x0000000941417c10ULL, 0x000fc400097fe4ffULL, 0x0000000943437c10ULL, 0x000fe20009ffe4ffULL,
0x000000003e477faeULL, 0x0003e8000b901c46ULL, 0x00000000405d7faeULL, 0x0003e8000b901c46ULL,
0x00000000425f7faeULL, 0x0003e4000b901c46ULL, 0xfffffff06c3c7812ULL, 0x042fe200078ec0ffULL,
0x00000001ff417424ULL, 0x000fe200078e00ffULL, 0x000000106c3d7812ULL, 0x000fc600078ec0ffULL,
0x0000000109427824ULL, 0x000fe200078e023cULL, 0xffffffe06c3c7812ULL, 0x000fc800078ec0ffULL,
0x00000000420572caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000093d3f7210ULL, 0x000fca0007ffe03cULL, 0x0000000870407824ULL, 0x000fcc00078e023fULL,
0x0001a6b005057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01a6b041428479a7ULL, 0x0002e4000850003fULL,
0x01a60841404079a7ULL, 0x002e64000850003fULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x000000086c3e7812ULL, 0x000fca00078ec0ffULL, 0x000000013f757824ULL, 0x000fc800078e023eULL,
0x01a60841750075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff447224ULL, 0x000fce00078e00ffULL, 0x000000104400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fce0000015200ULL,
0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000433e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000144447836ULL, 0x000fce0000000000ULL, 0x01a60841750075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000100a727824ULL, 0x000fe200078e00ffULL,
0x00000001ff737819ULL, 0x000fe2000001160aULL, 0x00000020783c7824ULL, 0x000fe400078e00ffULL,
0x00000001ff407424ULL, 0x000fe200078e00ffULL, 0x0000007072727812ULL, 0x000fe200078ec0ffULL,
0x000000ffff7a7224ULL, 0x000fe200078e007cULL, 0xffffff803c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c73737812ULL, 0x000fe400078ec0ffULL, 0x00000009723c7210ULL, 0x000fca0007ffe03cULL,
0x000000013c3c7824ULL, 0x000fca00078e0273ULL, 0x01a000003c3d7984ULL, 0x000e680000000800ULL,
0x01a200003c3e7984ULL, 0x0009220000000800ULL, 0x0000007c3d00720bULL, 0x002fda0003f1d000ULL,
0x0000000000417806ULL, 0x000fc800000e0100ULL, 0x000000ff4100720cULL, 0x000fda0003f05270ULL,
0x00000004008c8947ULL, 0x01cfea0003800000ULL, 0x000000785800720cULL, 0x000fe40003f45270ULL,
0x0000007c3d00720bULL, 0x0c0fe40003f14000ULL, 0x0000007c3d7a7209ULL, 0x000fd20007810000ULL,
0x00000080783ca824ULL, 0x000fe400078e0209ULL, 0x0000000000447806ULL, 0x000fc600000e0100ULL,
0x0000003c733fa210ULL, 0x000fe40007ffe072ULL, 0x000000ff4400720cULL, 0x000fc60003f05270ULL,
0x01a4007a3f00a388ULL, 0x0003f40000000800ULL, 0x0000000400508947ULL, 0x002fea0003800000ULL,
0x0000007c7a3c7221ULL, 0x000fe20000010100ULL, 0x000000ff44ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0044ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b3c3c7820ULL, 0x000fe20000410000ULL,
0x00ff000044ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000044ff7812ULL, 0x000fe2000788c0ffULL,
0x0000003c003f7308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff3c7819ULL, 0x002fcc000001160aULL, 0x00001f3c3f3c7589ULL, 0x004e6400000e0000ULL,
0x0000003c54547220ULL, 0x082fe20000410000ULL, 0x0000003c55557220ULL, 0x080fe20000410000ULL,
0x0000003c48487220ULL, 0x080fe20000410000ULL, 0x0000003c49497220ULL, 0x080fe20000410000ULL,
0x0000003c4c4c7220ULL, 0x080fe20000410000ULL, 0x0000003c4d4d7220ULL, 0x080fe20000410000ULL,
0x0000003c50507220ULL, 0x080fe20000410000ULL, 0x0000003c51517220ULL, 0x080fe20000410000ULL,
0x0000003c30307220ULL, 0x080fe20000410000ULL, 0x0000003c31317220ULL, 0x080fe20000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000003c28287220ULL, 0x080fe20000410000ULL, 0x0000003c29297220ULL, 0x080fe20000410000ULL,
0x0000003c24247220ULL, 0x080fe20000410000ULL, 0x0000003c25257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a3c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c3f3c7589ULL, 0x004e6400000e0000ULL, 0x0000003c56567220ULL, 0x082fe20000410000ULL,
0x0000003c57577220ULL, 0x080fe20000410000ULL, 0x0000003c4a4a7220ULL, 0x080fe20000410000ULL,
0x0000003c4b4b7220ULL, 0x080fe20000410000ULL, 0x0000003c4e4e7220ULL, 0x080fe20000410000ULL,
0x0000003c4f4f7220ULL, 0x080fe20000410000ULL, 0x0000003c52527220ULL, 0x080fe20000410000ULL,
0x0000003c53537220ULL, 0x080fe20000410000ULL, 0x0000003c32327220ULL, 0x080fe20000410000ULL,
0x0000003c33337220ULL, 0x080fe20000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000003c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000003c26267220ULL, 0x080fe20000410000ULL,
0x0000003c27277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a3c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f3c3f3c7589ULL, 0x004e6400000e0000ULL,
0x0000003c0c0c7220ULL, 0x082fe20000410000ULL, 0x0000003c0d0d7220ULL, 0x080fe20000410000ULL,
0x0000003c10107220ULL, 0x080fe20000410000ULL, 0x0000003c11117220ULL, 0x080fe20000410000ULL,
0x0000003c14147220ULL, 0x080fe20000410000ULL, 0x0000003c15157220ULL, 0x080fe20000410000ULL,
0x0000003c18187220ULL, 0x080fe20000410000ULL, 0x0000003c19197220ULL, 0x080fe20000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003c20207220ULL, 0x080fe20000410000ULL, 0x0000003c21217220ULL, 0x080fe20000410000ULL,
0x0000003c38387220ULL, 0x080fe20000410000ULL, 0x0000003c39397220ULL, 0x080fe20000410000ULL,
0x0000003c34347220ULL, 0x080fe20000410000ULL, 0x0000003c35357220ULL, 0x000fce0000410000ULL,
0x0000003f7d7d7220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a3c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f3c3f3c7589ULL, 0x000e6400000e0000ULL,
0x0000003c0e0e7220ULL, 0x082fe20000410000ULL, 0x0000003c0f0f7220ULL, 0x080fe20000410000ULL,
0x0000003c12127220ULL, 0x080fe20000410000ULL, 0x0000003c13137220ULL, 0x080fe20000410000ULL,
0x0000003c16167220ULL, 0x080fe20000410000ULL, 0x0000003c17177220ULL, 0x080fe20000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003c22227220ULL, 0x080fe20000410000ULL, 0x0000003c23237220ULL, 0x080fe20000410000ULL,
0x0000003c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000003c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000003c36367220ULL, 0x080fe20000410000ULL, 0x0000003c37377220ULL, 0x000fce0000410000ULL,
0x0000004441ff7212ULL, 0x000fda00078030ffULL, 0x8000007a3d3d0221ULL, 0x000fe20000010000ULL,
0x00007610ff400816ULL, 0x000fc60000000040ULL, 0x3fb8aa3b3d3d0820ULL, 0x000fc80000410000ULL,
0x0000003d00040308ULL, 0x000ea40000000800ULL, 0x000000043e3e0220ULL, 0x004fce0000410000ULL,
0x0000007d3e7d7221ULL, 0x000fe20000010000ULL, 0x00000000003c7805ULL, 0x002fe20000015200ULL,
0x01a6a881420075a7ULL, 0x000ea2000800017fULL, 0x0001a6a842417836ULL, 0x000fca0000000000ULL,
0x00000000410572caULL, 0x000fe200000e0000ULL, 0x0000000000600947ULL, 0x006fdc0003800000ULL,
0x000000ffff447224ULL, 0x000fce00078e00ffULL, 0x000000104400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000433e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000144447836ULL, 0x000fce0000000000ULL, 0x01a6a881420075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000000410572caULL, 0x000fde00000e0000ULL,
0x0000000460817824ULL, 0x000fe200078e00ffULL, 0x000000080a3d7812ULL, 0x000fe200078ec0ffULL,
0x00002000606e7824ULL, 0x000fe200078e0209ULL, 0x0000991040407816ULL, 0x000fe400000000ffULL,
0x0000000481817812ULL, 0x000fe200078ec0ffULL, 0x000160006e6b7836ULL, 0x000fe20000000000ULL,
0x000000073d6a7812ULL, 0x000fe200078ef80aULL, 0x000000ffff3d7224ULL, 0x000fe200078e0040ULL,
0x000000810a3c7211ULL, 0x000fe400078fe0ffULL, 0x00000004ff7f7819ULL, 0x000fe2000001160aULL,
0x000000086a3e7824ULL, 0x040fe200078e00ffULL, 0x000000ff3d00720cULL, 0x000fe20003f05270ULL,
0x000000016a797824ULL, 0x040fe200078e023cULL, 0x000000106a777812ULL, 0x000fe200078efcffULL,
0x00000400783d7824ULL, 0x000fc400078e00ffULL, 0x00000004707c7824ULL, 0x000fe200078e027fULL,
0xfffffff83e797812ULL, 0x000fe200078ee279ULL, 0x000000086a3f7824ULL, 0x040fe200078e00ffULL,
0xfffff0003d3e7812ULL, 0x000fe200078ec0ffULL, 0x000000016a5c7824ULL, 0x000fe400078e027cULL,
0x000000013c747824ULL, 0x000fe200078e0277ULL, 0x00012000097b7810ULL, 0x000fe20007ffe03eULL,
0x00000008773d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3c7812ULL, 0x000fc600078ee25cULL,
0x00000010793e7824ULL, 0x000fe200078e027bULL, 0xfffffff83d747812ULL, 0x000fe200078ee274ULL,
0x000000103c407824ULL, 0x000fc800078e026bULL, 0x0000001074447824ULL, 0x000fe200078e027bULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x00005410003c7816ULL, 0x000fe20000000000ULL, 0x00000008033d7836ULL, 0x000fe40000000000ULL,
0x00000018033f7836ULL, 0x000fe40000000000ULL, 0x00001f053c057589ULL, 0x0002a800000e0000ULL,
0x00001f3d3c027589ULL, 0x0002e800000e0000ULL, 0x00001f033c037589ULL, 0x00026800000e0000ULL,
0x00001f3f3c007589ULL, 0x00026400000e0000ULL, 0x000000003e3c783bULL, 0x002e680000000200ULL,
0x000000004444783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x088fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000544447232ULL, 0x084fe40000200000ULL, 0x0000000546467232ULL, 0x000fc40000200000ULL,
0x0000000045457232ULL, 0x080fe40000200000ULL, 0x0000000047477232ULL, 0x000fce0000200000ULL,
0x000000086a5d7824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x000000025c5c7836ULL, 0x000fe40000000000ULL, 0x00000001777c7824ULL, 0x000fc600078e027cULL,
0xfffffff85d5c7812ULL, 0x000fca00078ee25cULL, 0x000000105c5c7824ULL, 0x000fcc00078e026bULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000ff40627812ULL, 0x050fe400078ec0ffULL,
0x00000010ff917819ULL, 0x000fe40000011641ULL, 0x00000062ff66723eULL, 0x000fe400020006ffULL,
0x0000ffff418e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff907819ULL, 0x000fe20000011640ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000ffff408f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8d7819ULL, 0x000fe40000011642ULL, 0x00000008ff8e7819ULL, 0x000fe4000001168eULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8a7819ULL, 0x128fe4000001165cULL,
0x000000ff5c947812ULL, 0x000fe400078ec0ffULL, 0x00000018ff937819ULL, 0x000fc4000001165cULL,
0x0000ffff5c867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x100fe4000001165dULL,
0x000000ff5e627812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001165dULL, 0x000000ff5d957812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff927819ULL, 0x100fe4000001165fULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff827819ULL, 0x000fe4000001165fULL, 0x0000ffff5f807812ULL, 0x000fc400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000063ff5f723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x0000005dff63723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fe20000011643ULL,
0x20000062ff5c7230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000092ff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff91927812ULL, 0x000fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000008ff917819ULL, 0x000fc4000001168fULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x0000ffff42887812ULL, 0x040fe400078ec0ffULL,
0x00000090ff8f723eULL, 0x000fe400020006ffULL, 0x00000018ff647819ULL, 0x000fe40000011640ULL,
0x0000ffff438b7812ULL, 0x000fe200078ec0ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000091ff90723eULL, 0x000fe200020006ffULL, 0x20000092ff917230ULL, 0x000fe20000004100ULL,
0x000000ff42677812ULL, 0x000fc400078ec0ffULL, 0x0000008dff92723eULL, 0x000fe200020006ffULL,
0x2000008eff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x000000ff41657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x000000ff43687812ULL, 0x000fc400078ec0ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fe2000001168bULL, 0x20000092ff8b7230ULL, 0x000fe20000004100ULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000018ff427819ULL, 0x000fc40000011643ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000010ff7e7819ULL, 0x000fe4000001165eULL,
0x0000ffff5e837812ULL, 0x000fe400078ec0ffULL, 0x00000068ff43723eULL, 0x000fe200020006ffULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x0000008eff92723eULL, 0x000fe200020006ffULL,
0x20000067ff647230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL,
0x20000088ff8e7230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000092ff887230ULL, 0x000fe20000004100ULL, 0x00000093ff5e723eULL, 0x000fc400020006ffULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000041ff677230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff8c937812ULL, 0x000fe200078ec0ffULL, 0x20000089ff8c7230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000094ff417230ULL, 0x000fe20000004100ULL,
0x0000008aff89723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe20000011687ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000065ff697230ULL, 0x000fe20000004100ULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x20000043ff657230ULL, 0x000fe20000004100ULL, 0x000000ff82927812ULL, 0x000fc400078ec0ffULL,
0x00000008ff827819ULL, 0x000fe20000011683ULL, 0x20000086ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000008ff807819ULL, 0x000fe40000011680ULL, 0x00000093ff8a723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000092ff93723eULL, 0x000fe200020006ffULL,
0x20000087ff867230ULL, 0x000fe20000004100ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x2000007eff877230ULL, 0x000fe20000004100ULL, 0x00000082ff92723eULL, 0x000fe200020006ffULL,
0x20000093ff827230ULL, 0x000fe20000004100ULL, 0x000010548b647816ULL, 0x000fe20000000064ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000095ff43723eULL, 0x000fe200020006ffULL,
0x20000092ff7e7230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x00000010ff8b7819ULL, 0x000fe20000011641ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe40000011688ULL, 0x00000010ff887819ULL, 0x000fe40000011689ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff8f7819ULL, 0x000fc4000001168fULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x0000105442417816ULL, 0x000fe40000000041ULL, 0x00000010ff937819ULL, 0x000fe40000011668ULL,
0x0000105488427816ULL, 0x000fe4000000008bULL, 0x00000010ff897819ULL, 0x000fc4000001165cULL,
0x000010548f687816ULL, 0x000fe40000000066ULL, 0x00000010ff887819ULL, 0x000fe4000001165dULL,
0x000010545e5c7816ULL, 0x000fe40000000083ULL, 0x00000010ff8f7819ULL, 0x000fe40000011667ULL,
0x00000010ff5d7819ULL, 0x000fe40000011686ULL, 0x00000010ff837819ULL, 0x000fc40000011662ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff677819ULL, 0x000fe4000001168dULL,
0x00000010ff867819ULL, 0x000fe40000011687ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff627819ULL, 0x000fe4000001167eULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff927819ULL, 0x000fe40000011691ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff437819ULL, 0x000fc40000011643ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff877819ULL, 0x000fe4000001165fULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x0000105440677816ULL, 0x000fe40000000067ULL, 0x0000105463627816ULL, 0x000fc40000000062ULL,
0x0000105492697816ULL, 0x000fe40000000069ULL, 0x0000105493667816ULL, 0x000fe40000000090ULL,
0x000010548c657816ULL, 0x000fe40000000065ULL, 0x000010548f407816ULL, 0x000fe2000000008eULL,
0x000000683c54723cULL, 0x002fe20000041854ULL, 0x000010548a437816ULL, 0x000fe40000000043ULL,
0x00001054885d7816ULL, 0x000fc4000000005dULL, 0x00001054865e7816ULL, 0x000fe20000000089ULL,
0x000000663c48723cULL, 0x000fe20000041848ULL, 0x00001054825f7816ULL, 0x000fe40000000083ULL,
0x0000105487637816ULL, 0x000fc60000000080ULL, 0x000000643c4c723cULL, 0x000fec000004184cULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005c3c2c723cULL, 0x000fec000004182cULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000623c24723cULL, 0x000fec0000041824ULL, 0x000000404418723cULL, 0x000fe20000041818ULL,
0x00000002813c7812ULL, 0x000fe200078efcffULL, 0x00000008773f7824ULL, 0x000fc800078e00ffULL,
0x000000017f3c7824ULL, 0x000fe200078e023cULL, 0x00000068440c723cULL, 0x000fe2000004180cULL,
0x000000086a407824ULL, 0x040fe400078e00ffULL, 0x000000016a3d7824ULL, 0x100fe400078e023cULL,
0x00000001773e7824ULL, 0x040fe200078e023cULL, 0x000000664410723cULL, 0x000fe20000041810ULL,
0x0000000877417824ULL, 0x000fe200078e00ffULL, 0xfffffff8403c7812ULL, 0x000fe400078ee23dULL,
0xfffffff83f3e7812ULL, 0x000fc400078ee23eULL, 0x000000644414723cULL, 0x000fe20000041814ULL,
0x000000103c3c7824ULL, 0x100fe200078e027bULL, 0xfffffff841407812ULL, 0x000fe200078ee27cULL,
0x000000103e7b7824ULL, 0x000fc600078e027bULL, 0x00000042441c723cULL, 0x000fe2000004181cULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x0000001040407824ULL, 0x000fc800078e026bULL,
0x0000005c4420723cULL, 0x000fec0000041820ULL, 0x0000005e4438723cULL, 0x000fec0000041838ULL,
0x000000624444723cULL, 0x000fe20000041834ULL, 0x000000007b34783bULL, 0x0006a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x084fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000008775d7824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x000000027c7c7836ULL, 0x000fca0000000000ULL, 0xfffffff85d7c7812ULL, 0x000fca00078ee27cULL,
0x000000107c5c7824ULL, 0x000fcc00078e026bULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000ff40627812ULL, 0x050fe400078ec0ffULL, 0x00000018ff637819ULL, 0x100fe40000011640ULL,
0x00000062ff66723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000ffff418a7812ULL, 0x000fe200078ec0ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff8d7819ULL, 0x000fe20000011640ULL, 0x20000063ff807230ULL, 0x000fe20000004100ULL,
0x0000ffff408b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff41647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x000fe40000011642ULL, 0x00000010ff867819ULL, 0x128fe4000001165cULL,
0x000000ff5c8f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001165cULL,
0x0000ffff5c7f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff887819ULL, 0x100fe4000001165dULL,
0x000000ff5d917812ULL, 0x040fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fe4000001165dULL,
0x0000ffff5d817812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165eULL,
0x00000018ff5d7819ULL, 0x000fc4000001165fULL, 0x00000010ff687819ULL, 0x000fe4000001165eULL,
0x000000ff5e927812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5e7b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7c7819ULL, 0x000fe4000001165fULL, 0x000000ff5f627812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5f697812ULL, 0x000fc400078ec0ffULL, 0x0000008eff5e723eULL, 0x000fe400020006ffULL,
0x0000005cff5f723eULL, 0x000fe400020006ffULL, 0x0000005dff8e723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000062ff63723eULL, 0x000fe200020006ffULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x00000018ff407819ULL, 0x000fe20000011641ULL,
0x2000008eff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168aULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x000000ff89897812ULL, 0x000fe200078ec0ffULL, 0x20000064ff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff837819ULL, 0x000fe40000011643ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x000fc40000011641ULL, 0x0000ffff43877812ULL, 0x000fe200078ec0ffULL,
0x20000040ff647230ULL, 0x000fe20000004100ULL, 0x000000ff42657812ULL, 0x040fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x0000ffff42827812ULL, 0x000fe400078ec0ffULL,
0x0000008dff8a723eULL, 0x000fe400020006ffULL, 0x00000018ff427819ULL, 0x000fc40000011643ULL,
0x00000089ff8d723eULL, 0x000fe200020006ffULL, 0x2000008eff897230ULL, 0x000fe20000004100ULL,
0x000000ff83837812ULL, 0x000fe200078ec0ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff8e7819ULL, 0x000fe20000011687ULL, 0x2000008dff877230ULL, 0x000fe20000004100ULL,
0x00000041ff40723eULL, 0x000fe400020006ffULL, 0x00000008ff8b7819ULL, 0x000fe4000001168bULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000042ff41723eULL, 0x000fc400020006ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x0000008fff42723eULL, 0x000fe200020006ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000008eff8f723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000083ff8e7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000008fff837230ULL, 0x000fe20000004100ULL, 0x00000008ff7b7819ULL, 0x000fe2000001167bULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL,
0x20000082ff8d7230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fc400020006ffULL,
0x00000008ff697819ULL, 0x000fe40000011669ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000068ff827230ULL, 0x000fe20000004100ULL, 0x000000ff43677812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000007cff8f723eULL, 0x000fe200020006ffULL,
0x2000007bff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fc4000001167fULL,
0x00000069ff68723eULL, 0x000fe200020006ffULL, 0x2000008fff7b7230ULL, 0x000fe20000004100ULL,
0x00000067ff43723eULL, 0x000fe200020006ffULL, 0x20000065ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff697819ULL, 0x000fe2000001168aULL,
0x20000043ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff8b7819ULL, 0x000fc4000001168bULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000010ff8f7819ULL, 0x000fe2000001167eULL, 0x20000068ff7e7230ULL, 0x000fe20000004100ULL,
0x0000105469687816ULL, 0x000fe20000000066ULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x0000105480667816ULL, 0x000fe2000000008bULL, 0x20000092ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x00000008ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff807819ULL, 0x000fe40000011667ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff677819ULL, 0x000fe40000011689ULL,
0x00000091ff43723eULL, 0x000fc400020006ffULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000090ff5d7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x0000105464677816ULL, 0x000fe20000000067ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x0000105487647816ULL, 0x000fe20000000080ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x000000663c48723cULL, 0x002fe20000041848ULL,
0x00000010ff807819ULL, 0x000fe40000011641ULL, 0x00000010ff417819ULL, 0x000fe40000011683ULL,
0x00000010ff837819ULL, 0x000fe2000001165cULL, 0x000000663410723cULL, 0x004fe20000041810ULL,
0x000010545e5c7816ULL, 0x000fe4000000007fULL, 0x00000010ff7f7819ULL, 0x000fc40000011662ULL,
0x00000010ff877819ULL, 0x000fe40000011643ULL, 0x0000105480417816ULL, 0x000fe40000000041ULL,
0x00000010ff627819ULL, 0x000fe4000001167cULL, 0x00000010ff8b7819ULL, 0x000fe40000011640ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff437819ULL, 0x000fc40000011686ULL,
0x00000010ff807819ULL, 0x000fe4000001165dULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167bULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff8e7819ULL, 0x000fc4000001168eULL,
0x00000010ff407819ULL, 0x000fe4000001168dULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff5d7819ULL, 0x000fe40000011681ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff7b7819ULL, 0x000fe4000001165fULL, 0x00000010ff7e7819ULL, 0x000fc4000001167eULL,
0x0000105443427816ULL, 0x000fe40000000042ULL, 0x000010547c5f7816ULL, 0x000fe40000000063ULL,
0x000010548c697816ULL, 0x000fe4000000008fULL, 0x000010548e657816ULL, 0x000fe40000000065ULL,
0x000010548b407816ULL, 0x000fe40000000040ULL, 0x0000105488437816ULL, 0x000fe20000000087ULL,
0x000000683c54723cULL, 0x000fe20000041854ULL, 0x00001054805d7816ULL, 0x000fc4000000005dULL,
0x00001054825e7816ULL, 0x000fe40000000083ULL, 0x000010547f627816ULL, 0x000fe20000000062ULL,
0x000000643c4c723cULL, 0x000fe2000004184cULL, 0x000010547b637816ULL, 0x000fca000000007eULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005c3c2c723cULL, 0x000fec000004182cULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000623c24723cULL, 0x000fec0000041824ULL, 0x00000068340c723cULL, 0x000fe2000004180cULL,
0x00000002783c7824ULL, 0x000fc400078e00ffULL, 0x00000008603d7824ULL, 0x000fe400078e0209ULL,
0x00000001ff3f7424ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ec0ffULL,
0x000000643414723cULL, 0x000fe80000041814ULL, 0x00000001093e7824ULL, 0x000fe400078e023cULL,
0x01a6c83f3d3c79a7ULL, 0x000e62000850003fULL, 0x000000403418723cULL, 0x000fec0000041818ULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x01a6883f3eff79a7ULL, 0x0005ea000850003fULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000623444723cULL, 0x000fee0000041844ULL, 0x0000000000347805ULL, 0x000fe20000015200ULL,
0x0000003d060075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x006fdc0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000806f367836ULL, 0x000fe20000000000ULL,
0x0000920000087ab9ULL, 0x000fc60000000800ULL, 0x00000008593d7c24ULL, 0x000fe2000f8e0236ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000003661347248ULL, 0x000fe20007fe0000ULL,
0x0000001070377824ULL, 0x000fe200078e00ffULL, 0x00000003ff357819ULL, 0x000fe2000001160aULL,
0x00008e0000087ab9ULL, 0x000fe40000000a00ULL, 0x0000000134347824ULL, 0x000fe400078e0a36ULL,
0x0000000137367824ULL, 0x000fe400078e0235ULL, 0x00000004353e7836ULL, 0x000fe20000000000ULL,
0x0000003437347248ULL, 0x000fe20007fe0000ULL, 0x00000001363c7824ULL, 0x000fc400078e020aULL,
0x00000008363f7824ULL, 0x000fe400078e00ffULL, 0x0000000134347824ULL, 0x000fe400078e0a37ULL,
0x0000000c35417836ULL, 0x000fe20000000000ULL, 0xfffffff83f407812ULL, 0x000fe200078ee23cULL,
0x00000008353c7836ULL, 0x000fe20000000000ULL, 0x000000343e00720cULL, 0x080fe20003f66070ULL,
0x00000001373e7824ULL, 0x000fe200078e023eULL, 0x000000343500720cULL, 0x080fe20003f86070ULL,
0x0000000136357824ULL, 0x000fe200078e023dULL, 0x000000343c00720cULL, 0x080fe20003f46070ULL,
0x000000013e367824ULL, 0x040fe200078e020aULL, 0x000000344100720cULL, 0x000fe20003f06070ULL,
0x000000083e5d7824ULL, 0x000fc400078e00ffULL, 0x0000008035347825ULL, 0x000fc600078e00ffULL,
0xfffffff85d427812ULL, 0x000fe200078ee236ULL, 0x000000013e367824ULL, 0x000fe200078e023dULL,
0x0000007234347212ULL, 0x000fe200078efcffULL, 0x00000001373f7824ULL, 0x040fe400078e023cULL,
0x0000000137437824ULL, 0x000fe200078e0241ULL, 0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0x0000000935357c10ULL, 0x000fe2000affe4ffULL,
0x000000013f3c7824ULL, 0x100fe200078e023dULL, 0x0000007236367212ULL, 0x000fe200078efcffULL,
0x00000001433e7824ULL, 0x000fe400078e023dULL, 0x000000013f417824ULL, 0x040fe200078e020aULL,
0x0000000836367c10ULL, 0x000fe2000ffbe0ffULL, 0x000000083f5c7824ULL, 0x000fe400078e00ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000000937377c10ULL, 0x000fc4000affe4ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee241ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000723c3c7212ULL, 0x000fc600078efcffULL, 0x0000000143417824ULL, 0x040fe200078e020aULL,
0x000000723e3e7212ULL, 0x000fe200078efcffULL, 0x00000008435e7824ULL, 0x000fe200078e00ffULL,
0x000000083c3c7c10ULL, 0x000fe2000ffbe0ffULL, 0x0000001042437824ULL, 0x100fe200078e026bULL,
0x000000083e3e7c10ULL, 0x000fe2000ffde0ffULL, 0x000000105c5d7824ULL, 0x100fe200078e026bULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee241ULL, 0x0000001040417824ULL, 0x100fe200078e026bULL,
0x000000093d3d7c10ULL, 0x000fe4000affe4ffULL, 0x000000093f3f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000105e5f7824ULL, 0x000fe200078e026bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e8000e101c46ULL, 0x0000000036437faeULL, 0x0003e8000d901c46ULL,
0x000000003c5d7faeULL, 0x0003e8000d101c46ULL, 0x000000003e5f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001070357824ULL, 0x000fe200078e00ffULL,
0x00008e0000087ab9ULL, 0x000fc80000000a00ULL, 0x000000350a357211ULL, 0x000fca00078fe8ffULL,
0x0000000135367824ULL, 0x040fe400078e020aULL, 0x00000008353f7824ULL, 0x040fe400078e00ffULL,
0x0000000135347824ULL, 0x000fe400078e023dULL, 0x0000000435377836ULL, 0x000fe20000000000ULL,
0xfffffff83f407812ULL, 0x000fe200078ee236ULL, 0x0000000835417836ULL, 0x000fe40000000000ULL,
0x0000000c35357836ULL, 0x000fc40000000000ULL, 0x00000001373e7824ULL, 0x140fe400078e023dULL,
0x00000001373f7824ULL, 0x140fe400078e020aULL, 0x0000000837427824ULL, 0x000fe400078e00ffULL,
0x0000000141367824ULL, 0x100fe400078e023dULL, 0x00000001353c7824ULL, 0x000fe200078e023dULL,
0xfffffff842427812ULL, 0x000fe200078ee23fULL, 0x0000000141377824ULL, 0x000fc400078e020aULL,
0x00000008415c7824ULL, 0x000fe400078e00ffULL, 0x00000001353d7824ULL, 0x040fe400078e020aULL,
0x00000008355e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee237ULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee23dULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000007234347212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000723e3e7212ULL, 0x080fe400078efcffULL,
0x0000000834347c10ULL, 0x000fe2000ff1e0ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000007236367212ULL, 0x080fe400078efcffULL, 0x000000083e3e7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001040417824ULL, 0x100fe200078e026bULL, 0x000000723c3c7212ULL, 0x000fe200078efcffULL,
0x0000001042437824ULL, 0x100fe200078e026bULL, 0x0000000935357c10ULL, 0x000fe200087fe4ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026bULL, 0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e026bULL, 0x000000083c3c7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x000000093f3f7c10ULL, 0x000fc400097fe4ffULL, 0x0000000937377c10ULL, 0x000fe400087fe4ffULL,
0x000000093d3d7c10ULL, 0x000fe20009ffe4ffULL, 0x000000003e437faeULL, 0x0003e8000b901c46ULL,
0x00000000365d7faeULL, 0x0003e8000b901c46ULL, 0x000000003c5f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff367424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000036ff8279a7ULL, 0x0002a40008500005ULL, 0x01a62836753679a7ULL, 0x0022e4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0xffffffe06c3c7812ULL, 0x040fe400078ec0ffULL,
0x000000106c3d7812ULL, 0x000fc800078ec0ffULL, 0x000000093d3d7210ULL, 0x000fca0007ffe03cULL,
0x0000000870417824ULL, 0x000fc800078e023dULL, 0x01a62837410075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000003c343f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a62837410075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000002078347824ULL, 0x000fe400078e00ffULL, 0x00000001ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff7f7224ULL, 0x000fe200078e007aULL, 0xffffff8034347812ULL, 0x000fc800078ec0ffULL,
0x0000008009347810ULL, 0x000fc80007ffe034ULL, 0x0000003473347210ULL, 0x000fca0007ffe072ULL,
0x01a0000034357984ULL, 0x000ee80000000800ULL, 0x01a2000034367984ULL, 0x0009220000000800ULL,
0x0000007a3500720bULL, 0x008fda0003f1d000ULL, 0x00000000003d7806ULL, 0x000fc800000e0100ULL,
0x000000ff3d00720cULL, 0x000fda0003f05270ULL, 0x0000000400948947ULL, 0x016fea0003800000ULL,
0x0000000158377836ULL, 0x000fe20000000000ULL, 0x0000007a3500720bULL, 0x0c0fe40003f14000ULL,
0x0000007a357f7209ULL, 0x000fe40007810000ULL, 0x000000783700720cULL, 0x000fd20003f45270ULL,
0x00000000003c7806ULL, 0x000fc800000e0100ULL, 0x000000807834a824ULL, 0x000fe200078e0209ULL,
0x000000ff3c00720cULL, 0x000fc80003f05270ULL, 0x000000347334a210ULL, 0x000fca0007ffe072ULL,
0x01a4007f3400a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x0000007a7f347221ULL, 0x002fe20000010100ULL, 0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL,
0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL, 0xff0000003cff7812ULL, 0x000fe2000788c0ffULL,
0x00000034003e7308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff377819ULL, 0x000fca000001160aULL, 0x00001f373e347589ULL, 0x006e6400000e0000ULL,
0x0000005434547220ULL, 0x042fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a377811ULL, 0x000fca00078ff0ffULL,
0x00001f373e347589ULL, 0x006e6400000e0000ULL, 0x0000005634567220ULL, 0x042fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a377811ULL, 0x000fca00078ff0ffULL, 0x00001f373e347589ULL, 0x006e6400000e0000ULL,
0x0000000c340c7220ULL, 0x042fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003e7d7d7220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a377811ULL, 0x000fca00078ff0ffULL, 0x00001f373e347589ULL, 0x002e6400000e0000ULL,
0x0000000e340e7220ULL, 0x042fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003c3dff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fd800078e00ffULL,
0x8000007f35350221ULL, 0x000fe20000010000ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x0000003500040308ULL, 0x000ea40000000800ULL,
0x0000000436360220ULL, 0x004fce0000410000ULL, 0x0000007d367d7221ULL, 0x000fe20000010000ULL,
0x0000000000347805ULL, 0x002fe40000015200ULL, 0xfffffff06c367812ULL, 0x000fca00078ec0ffULL,
0x00000001093f7824ULL, 0x000fc800078e0236ULL, 0x01a6b0853f0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6b0853f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099103c367816ULL, 0x000fe200000000ffULL, 0x0000000478357824ULL, 0x040fe400078e00ffULL,
0x0000040078377824ULL, 0x000fe200078e00ffULL, 0x000000ff3600720cULL, 0x000fe20003f05270ULL,
0x0000100078347824ULL, 0x000fe200078e00ffULL, 0x0000000435357812ULL, 0x000fe400078ec0ffULL,
0xfffff000377c7812ULL, 0x000fe400078ec0ffULL, 0x000000350a7a7211ULL, 0x000fe200078fe0ffULL,
0x000000086a357824ULL, 0x000fe200078e00ffULL, 0xffffe00034347812ULL, 0x000fc400078ec0ffULL,
0x00013000097c7810ULL, 0x040fe20007ffe07cULL, 0x000000016a5c7824ULL, 0x000fe200078e027aULL,
0x00017000095d7810ULL, 0x000fc60007ffe034ULL, 0x0000001074347824ULL, 0x100fe200078e027cULL,
0xfffffff835747812ULL, 0x000fe200078ee25cULL, 0x00000010793c7824ULL, 0x000fe200078e027cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff367819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000000836027836ULL, 0x000fe20000000000ULL,
0x0000541000357816ULL, 0x000fe20000000000ULL, 0x00000010363e7836ULL, 0x000fe40000000000ULL,
0x0000001836407836ULL, 0x000fe40000000000ULL, 0x00001f0235027589ULL, 0x0002a800000e0000ULL,
0x00001f3e35057589ULL, 0x0002e800000e0000ULL, 0x00001f3635037589ULL, 0x00026800000e0000ULL,
0x00001f4035007589ULL, 0x00026400000e0000ULL, 0x000000003c3c783bULL, 0x002e620000000200ULL,
0x0000001074407824ULL, 0x000fc600078e025dULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000086a5f7824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f220000004200ULL, 0x000000025c7e7836ULL, 0x000fca0000000000ULL,
0xfffffff85f7e7812ULL, 0x000fca00078ee27eULL, 0x000000107e5d7824ULL, 0x000fcc00078e025dULL,
0x000000005d5c783bULL, 0x000f620000004200ULL, 0x000000ff40627812ULL, 0x050fe400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fe40000011641ULL, 0x00000062ff69723eULL, 0x000fe400020006ffULL,
0x0000ffff408c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff418d7812ULL, 0x000fe200078ec0ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fc40000011640ULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff8b7819ULL, 0x000fe40000011642ULL, 0x00000010ff897819ULL, 0x128fe4000001165cULL,
0x000000ff5c927812ULL, 0x000fe400078ec0ffULL, 0x00000018ff917819ULL, 0x000fc4000001165cULL,
0x0000ffff5c847812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x100fe4000001165dULL,
0x000000ff5e627812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8a7819ULL, 0x000fe4000001165dULL, 0x000000ff5d937812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff907819ULL, 0x100fe4000001165fULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff807819ULL, 0x000fe4000001165fULL, 0x0000ffff5f7b7812ULL, 0x000fc400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000063ff5f723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x0000005dff63723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000062ff5c7230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000090ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe2000001168dULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000ffff42857812ULL, 0x000fc400078ec0ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8d723eULL, 0x000fe200020006ffULL, 0x2000008eff8f7230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x2000008cff8e7230ULL, 0x000fe20000004100ULL,
0x0000008bff8c723eULL, 0x000fe200020006ffULL, 0x20000090ff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff89907812ULL, 0x000fe200078ec0ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fe20000011643ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000ffff43887812ULL, 0x000fc400078ec0ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000010ff797819ULL, 0x000fe4000001165eULL, 0x0000ffff5e817812ULL, 0x000fe400078ec0ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000091ff5e723eULL, 0x000fe400020006ffULL,
0x000000ff86867812ULL, 0x000fc400078ec0ffULL, 0x00000008ff887819ULL, 0x000fe20000011688ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff8a917812ULL, 0x000fe200078ec0ffULL,
0x20000085ff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff41657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011640ULL, 0x000000ff43687812ULL, 0x000fe400078ec0ffULL,
0x00000008ff847819ULL, 0x000fc40000011684ULL, 0x00000008ff857819ULL, 0x000fe20000011687ULL,
0x20000090ff877230ULL, 0x000fe20000004100ULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000086ff897230ULL, 0x000fe20000004100ULL,
0x000000ff79797812ULL, 0x000fc400078ec0ffULL, 0x000000ff80907812ULL, 0x000fe200078ec0ffULL,
0x20000088ff867230ULL, 0x000fe20000004100ULL, 0x000000ff42667812ULL, 0x000fe400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe40000011643ULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000008ff807819ULL, 0x000fc40000011681ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000091ff887230ULL, 0x000fe20000004100ULL,
0x00000068ff43723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000084ff817230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000085ff847230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x00000066ff42723eULL, 0x000fe200020006ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000043ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff917819ULL, 0x000fe2000001167bULL,
0x20000079ff857230ULL, 0x000fe20000004100ULL, 0x00000067ff43723eULL, 0x000fe200020006ffULL,
0x20000041ff677230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000080ff797230ULL, 0x000fe20000004100ULL, 0x00000091ff80723eULL, 0x000fe200020006ffULL,
0x20000042ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe20000011668ULL,
0x20000090ff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fe2000001168dULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000093ff42723eULL, 0x000fe200020006ffULL,
0x20000092ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff8d7819ULL, 0x000fe20000011667ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe20000011666ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff407819ULL, 0x000fc40000011640ULL,
0x00000010ff677819ULL, 0x000fe4000001168bULL, 0x00000010ff667819ULL, 0x000fe4000001168eULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff8e7819ULL, 0x000fe40000011665ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff657819ULL, 0x000fc4000001168cULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x0000105440677816ULL, 0x000fe40000000067ULL,
0x000010548d407816ULL, 0x000fe4000000008aULL, 0x00000010ff8a7819ULL, 0x000fe40000011643ULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x00000010ff437819ULL, 0x000fc40000011641ULL,
0x0000105489657816ULL, 0x000fe4000000008eULL, 0x00000010ff417819ULL, 0x000fe40000011686ULL,
0x00000010ff897819ULL, 0x000fe40000011642ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x000000643c4c723cULL, 0x002fe2000004184cULL, 0x00000010ff867819ULL, 0x000fe4000001165dULL,
0x00000010ff817819ULL, 0x000fc40000011681ULL, 0x00000010ff427819ULL, 0x000fe20000011687ULL,
0x000000643414723cULL, 0x000fe20000041814ULL, 0x00000010ff5d7819ULL, 0x000fe40000011684ULL,
0x00000010ff877819ULL, 0x000fe4000001165cULL, 0x00000010ff847819ULL, 0x000fe40000011685ULL,
0x000010545e5c7816ULL, 0x000fe40000000081ULL, 0x00000010ff817819ULL, 0x000fc40000011662ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00001054845e7816ULL, 0x000fe40000000087ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fe40000011679ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x00000010ff847819ULL, 0x000fe4000001167bULL, 0x00000010ff797819ULL, 0x000fe4000001165fULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x0000105468687816ULL, 0x000fe40000000069ULL,
0x0000105442427816ULL, 0x000fe40000000043ULL, 0x0000105463627816ULL, 0x000fc40000000062ULL,
0x000010548f697816ULL, 0x000fe40000000090ULL, 0x0000105491667816ULL, 0x000fe40000000066ULL,
0x000010548a417816ULL, 0x000fe40000000041ULL, 0x0000105488437816ULL, 0x000fe20000000089ULL,
0x000000683c54723cULL, 0x000fe20000041854ULL, 0x00001054865d7816ULL, 0x000fe4000000005dULL,
0x00001054845f7816ULL, 0x000fc40000000081ULL, 0x0000105479637816ULL, 0x000fe20000000080ULL,
0x0000000278807824ULL, 0x000fe200078e00ffULL, 0x000000663c48723cULL, 0x000fec0000041848ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005c3c2c723cULL, 0x000fec000004182cULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000623c24723cULL, 0x000fec0000041824ULL, 0x0000005c3420723cULL, 0x000fe20000041820ULL,
0x00000004803c7812ULL, 0x000fe200078ec0ffULL, 0x00000008773e7824ULL, 0x000fc600078e00ffULL,
0x000000023c3d7812ULL, 0x000fe200078efcffULL, 0x000000086a3c7824ULL, 0x000fe200078e00ffULL,
0x00000068340c723cULL, 0x000fe2000004180cULL, 0x00000001775c7824ULL, 0x000fe200078e027aULL,
0x0000003d0a3d7211ULL, 0x000fe200078fe0ffULL, 0x000170006e5d7836ULL, 0x000fc60000000000ULL,
0x000000663410723cULL, 0x000fe20000041810ULL, 0x000000016a7b7824ULL, 0x100fe400078e023dULL,
0x0000000177797824ULL, 0x040fe400078e023dULL, 0x00000008773d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c7b7812ULL, 0x000fe200078ee27bULL, 0x000000403418723cULL, 0x000fe20000041818ULL,
0xfffffff83e797812ULL, 0x000fe400078ee279ULL, 0xfffffff83d7a7812ULL, 0x000fe200078ee25cULL,
0x000000107b3c7824ULL, 0x000fc400078e027cULL, 0x00000010797c7824ULL, 0x000fe200078e027cULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x000000107a407824ULL, 0x000fe400078e025dULL,
0x000000003c3c783bULL, 0x000e660000000200ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000623444723cULL, 0x000fe20000041844ULL, 0x000000007c34783bULL, 0x0006a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x084fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x080fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000008775f7824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x000000025c7c7836ULL, 0x008fe20000000000ULL, 0xfffffff880807812ULL, 0x000fc800078ec0ffULL,
0xfffffff85f7c7812ULL, 0x000fe200078ee27cULL, 0x0000000109807824ULL, 0x000fc800078e0280ULL,
0x000000107c5c7824ULL, 0x000fcc00078e025dULL, 0x000000005c5c783bULL, 0x000ee20000004200ULL,
0x000000ff40627812ULL, 0x050fe400078ec0ffULL, 0x00000010ff927819ULL, 0x000fe40000011641ULL,
0x00000062ff66723eULL, 0x000fe400020006ffULL, 0x0000ffff41907812ULL, 0x000fe400078ec0ffULL,
0x0000ffff40917812ULL, 0x000fe200078ec0ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x000000ff92927812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fe40000011642ULL,
0x00000008ff917819ULL, 0x000fe40000011691ULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000010ff8b7819ULL, 0x108fe4000001165cULL, 0x000000ff5c957812ULL, 0x000fe400078ec0ffULL,
0x00000018ff947819ULL, 0x000fc4000001165cULL, 0x0000ffff5c877812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x000000ff5e637812ULL, 0x040fe400078ec0ffULL,
0x00000010ff817819ULL, 0x100fe4000001165eULL, 0x00000018ff627819ULL, 0x000fe4000001165eULL,
0x0000ffff5e857812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff937819ULL, 0x100fe4000001165fULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000010ff867819ULL, 0x000fe4000001165fULL,
0x0000ffff5f847812ULL, 0x000fc400078ec0ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005eff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000063ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL, 0x20000062ff637230ULL, 0x000fe20000004100ULL,
0x0000ffff42897812ULL, 0x000fe200078ec0ffULL, 0x2000005fff627230ULL, 0x000fe20000004100ULL,
0x0000ffff438c7812ULL, 0x000fe200078ec0ffULL, 0x20000093ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fc40000011690ULL, 0x00000091ff90723eULL, 0x000fe200020006ffULL,
0x20000092ff917230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x0000008eff92723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x20000093ff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe2000001168cULL, 0x20000092ff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fc40000011640ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000ffff5d887812ULL, 0x000fe400078ec0ffULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000089ff927230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe20000011640ULL, 0x20000093ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fc40000011643ULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x000000ff41657812ULL, 0x000fe400078ec0ffULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff86937812ULL, 0x000fe200078ec0ffULL,
0x20000064ff697230ULL, 0x000fe20000004100ULL, 0x000000ff43687812ULL, 0x000fe400078ec0ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x000000ff42677812ULL, 0x000fe200078ec0ffULL, 0x20000087ff867230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x00000010ff8d7819ULL, 0x000fe2000001165dULL,
0x20000088ff877230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000018ff427819ULL, 0x000fe40000011643ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000081ff887230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fc400020006ffULL,
0x000000ff5d967812ULL, 0x000fe400078ec0ffULL, 0x00000068ff43723eULL, 0x000fe200020006ffULL,
0x20000065ff687230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000093ff817230ULL, 0x000fe20000004100ULL, 0x00000094ff5d723eULL, 0x000fe200020006ffULL,
0x20000043ff657230ULL, 0x000fe20000004100ULL, 0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL,
0x20000067ff647230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff8d947812ULL, 0x000fe200078ec0ffULL,
0x2000008aff8d7230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000041ff677230ULL, 0x000fe20000004100ULL, 0x00000008ff857819ULL, 0x000fc40000011685ULL,
0x00000010ff667819ULL, 0x000fe20000011666ULL, 0x20000095ff417230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x0000008bff8a723eULL, 0x000fe400020006ffULL,
0x00000008ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff937819ULL, 0x000fe20000011669ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x00000094ff8b723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000096ff43723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff947819ULL, 0x000fe20000011668ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x000010548f687816ULL, 0x000fe20000000066ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x0000105493667816ULL, 0x000fe40000000090ULL,
0x00000010ff907819ULL, 0x000fe20000011665ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff657819ULL, 0x000fc4000001168cULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff8c7819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fe40000011689ULL, 0x0000105465647816ULL, 0x000fc40000000064ULL,
0x00000010ff897819ULL, 0x000fe4000001165cULL, 0x000010548d657816ULL, 0x000fe40000000090ULL,
0x000010545d5c7816ULL, 0x000fe40000000086ULL, 0x00000010ff8f7819ULL, 0x000fe40000011667ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x000000643c4c723cULL, 0x002fe2000004184cULL,
0x00000010ff8d7819ULL, 0x000fc40000011643ULL, 0x00000010ff867819ULL, 0x000fe40000011662ULL,
0x00000010ff407819ULL, 0x000fe20000011640ULL, 0x000000643414723cULL, 0x004fe20000041814ULL,
0x00000010ff677819ULL, 0x000fe4000001168eULL, 0x00000010ff437819ULL, 0x000fe4000001168aULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fe40000011685ULL,
0x00000010ff697819ULL, 0x000fe40000011691ULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168bULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff857819ULL, 0x000fe4000001165fULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x0000105440677816ULL, 0x000fe40000000067ULL, 0x0000105443427816ULL, 0x000fc4000000008cULL,
0x000010545e5d7816ULL, 0x000fe40000000087ULL, 0x0000105463627816ULL, 0x000fe20000000062ULL,
0x000000663c48723cULL, 0x000fe20000041848ULL, 0x0000105469697816ULL, 0x000fe40000000094ULL,
0x000010548f407816ULL, 0x000fe40000000092ULL, 0x000010548a437816ULL, 0x000fe2000000008dULL,
0x0000005c3c2c723cULL, 0x000fe2000004182cULL, 0x00001054885e7816ULL, 0x000fc40000000089ULL,
0x00001054815f7816ULL, 0x000fe40000000086ULL, 0x0000105485637816ULL, 0x000fe20000000084ULL,
0x000000683c54723cULL, 0x000fec0000041854ULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000623c24723cULL, 0x000fec0000041824ULL, 0x00000068340c723cULL, 0x000fe2000004180cULL,
0x00000008603c7824ULL, 0x000fc400078e0209ULL, 0x00000001ff3f7424ULL, 0x000fc600078e00ffULL,
0x000000663410723cULL, 0x000fe20000041810ULL, 0x01a6c83f3c3c79a7ULL, 0x000e6a000850003fULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x01a6903f80ff79a7ULL, 0x0005ea000850003fULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005c3420723cULL, 0x000fec0000041820ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000623444723cULL, 0x000fee0000041844ULL,
0x0000000000347805ULL, 0x000fe20000015200ULL, 0x0000003d060075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x006fdc0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000c06f367836ULL, 0x000fe20000000000ULL, 0x0000920000087ab9ULL, 0x000fc60000000800ULL,
0x00000008593e7c24ULL, 0x000fe2000f8e0236ULL, 0x0000000000fc9947ULL, 0x000fec0003800000ULL,
0x0000003661347248ULL, 0x000fe20007fe0000ULL, 0x0000001070357824ULL, 0x000fe200078e00ffULL,
0x00000003ff377819ULL, 0x000fe2000001160aULL, 0x00008e0000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000134347824ULL, 0x000fe400078e0a36ULL, 0x00000001353d7824ULL, 0x000fe400078e0237ULL,
0x00000004373c7836ULL, 0x000fe20000000000ULL, 0x0000003435347248ULL, 0x000fe20007fe0000ULL,
0x000000013d367824ULL, 0x000fc400078e020aULL, 0x000000083d417824ULL, 0x000fe400078e00ffULL,
0x0000000134347824ULL, 0x000fe400078e0a35ULL, 0x0000000c37407836ULL, 0x000fe20000000000ULL,
0xfffffff841417812ULL, 0x000fe200078ee236ULL, 0x0000000837367836ULL, 0x000fe20000000000ULL,
0x000000343700720cULL, 0x080fe20003f86070ULL, 0x0000000135377824ULL, 0x040fe200078e023cULL,
0x000000343c00720cULL, 0x080fe20003f66070ULL, 0x00000001353f7824ULL, 0x040fe200078e0236ULL,
0x000000343600720cULL, 0x080fe20003f46070ULL, 0x00000001355f7824ULL, 0x000fe200078e0240ULL,
0x000000344000720cULL, 0x000fe20003f06070ULL, 0x0000000137357824ULL, 0x000fc400078e020aULL,
0x00000008373c7824ULL, 0x000fe400078e00ffULL, 0x000000013f367824ULL, 0x040fe400078e020aULL,
0x000000083f5d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c437812ULL, 0x000fe200078ee235ULL,
0x000000013d347824ULL, 0x100fe400078e023eULL, 0x00000001373c7824ULL, 0x000fe200078e023eULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL, 0x000000015f377824ULL, 0x000fc400078e020aULL,
0x000000085f407824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000013f367824ULL, 0x000fe200078e023eULL, 0x0000007234347212ULL, 0x000fe200078efcffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL,
0x000000015f3e7824ULL, 0x000fe200078e023eULL, 0xfffffff8405f7812ULL, 0x000fe200078ee237ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000723c3c7212ULL, 0x080fe400078efcffULL,
0x0000000935357c10ULL, 0x000fe2000affe4ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000083c3c7c10ULL, 0x000fe4000ffde0ffULL, 0x0000007236367212ULL, 0x080fe200078efcffULL,
0x000170006e407836ULL, 0x000fe20000000000ULL, 0x000000723e3e7212ULL, 0x000fc400078efcffULL,
0x000000093d3d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001041417824ULL, 0x100fe200078e0240ULL,
0x0000000836367c10ULL, 0x000fe2000ffbe0ffULL, 0x0000001043437824ULL, 0x100fe200078e0240ULL,
0x000000083e3e7c10ULL, 0x000fe2000ffde0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0240ULL,
0x0000000937377c10ULL, 0x000fe2000affe4ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0240ULL,
0x000000093f3f7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e8000e101c46ULL, 0x000000003c437faeULL, 0x0003e8000d901c46ULL,
0x00000000365d7faeULL, 0x0003e8000d101c46ULL, 0x000000003e5f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x0000001070357824ULL, 0x000fe200078e00ffULL,
0x00008e0000087ab9ULL, 0x000fc80000000a00ULL, 0x000000350a357211ULL, 0x000fca00078fe8ffULL,
0x0000000135367824ULL, 0x040fe400078e020aULL, 0x0000000835417824ULL, 0x040fe400078e00ffULL,
0x0000000435377836ULL, 0x000fe40000000000ULL, 0x00000008353f7836ULL, 0x000fe20000000000ULL,
0xfffffff841417812ULL, 0x000fe200078ee236ULL, 0x0000000135347824ULL, 0x000fe400078e023eULL,
0x0000000c35437836ULL, 0x000fc40000000000ULL, 0x0000000137367824ULL, 0x040fe400078e023eULL,
0x00000001373d7824ULL, 0x140fe400078e020aULL, 0x0000000837407824ULL, 0x000fe400078e00ffULL,
0x000000013f377824ULL, 0x040fe400078e020aULL, 0x000000083f427824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff8425d7812ULL, 0x000fe200078ee237ULL,
0x000000013f3c7824ULL, 0x000fe200078e023eULL, 0x0000007234347212ULL, 0x000fe200078efcffULL,
0x00000001433f7824ULL, 0x040fe400078e020aULL, 0x00000008435c7824ULL, 0x040fe200078e00ffULL,
0x0000000834347c10ULL, 0x000fe2000ff1e0ffULL, 0x00000001433e7824ULL, 0x000fe200078e023eULL,
0xfffffff840437812ULL, 0x000fe200078ee23dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff85c5f7812ULL, 0x000fc400078ee23fULL, 0x0000000935357c10ULL, 0x000fe200087fe4ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000007236367212ULL, 0x000fc600078efcffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000723c3c7212ULL, 0x080fe400078efcffULL,
0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL, 0x000170006e407836ULL, 0x000fe20000000000ULL,
0x000000723e3e7212ULL, 0x000fe400078efcffULL, 0x000000083c3c7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001041417824ULL, 0x100fe200078e0240ULL, 0x000000083e3e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001043437824ULL, 0x100fe200078e0240ULL, 0x0000000937377c10ULL, 0x000fe200087fe4ffULL,
0x000000105d5d7824ULL, 0x100fe200078e0240ULL, 0x000000093d3d7c10ULL, 0x000fe200097fe4ffULL,
0x000000105f5f7824ULL, 0x000fe200078e0240ULL, 0x000000093f3f7c10ULL, 0x000fe20009ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034417faeULL, 0x0003e8000b901c46ULL,
0x0000000036437faeULL, 0x0003e8000b901c46ULL, 0x000000003c5d7faeULL, 0x0003e8000b901c46ULL,
0x000000003e5f7faeULL, 0x0003e4000b901c46ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff06c847812ULL, 0x000fe200078ec0ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0x0001a6a884847810ULL, 0x000fc60007ffe009ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000834848479a7ULL, 0x0002a4000850003fULL, 0x01a64834753479a7ULL, 0x0022e4000850003fULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0xffffffe06c3c7812ULL, 0x040fe400078ec0ffULL,
0x000000106c3d7812ULL, 0x040fe400078ec0ffULL, 0x000000086c3e7812ULL, 0x000fe400078ec0ffULL,
0x000000093d3d7210ULL, 0x000fca0007ffe03cULL, 0x000000013d417824ULL, 0x000fc800078e023eULL,
0x01a64835410075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c363f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e37ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a64835410075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000002078347824ULL, 0x000fe400078e00ffULL,
0x00000001ff3c7424ULL, 0x000fc600078e00ffULL, 0xffffff8034347812ULL, 0x000fc800078ec0ffULL,
0x0000010009347810ULL, 0x000fc80007ffe034ULL, 0x0000003473347210ULL, 0x000fca0007ffe072ULL,
0x01a0000034367984ULL, 0x000ee80000000800ULL, 0x01a2000034357984ULL, 0x0009220000000800ULL,
0x0000007f3600720bULL, 0x008fda0003f1d000ULL, 0x00000000003d7806ULL, 0x000fc800000e0100ULL,
0x000000ff3d00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x016fea0003800000ULL,
0x0000000258377836ULL, 0x000fe20000000000ULL, 0x0000007f3600720bULL, 0x000fc80003f14000ULL,
0x000000783700720cULL, 0x000fe40003f45270ULL, 0x0000007f36377209ULL, 0x000fce0007810000ULL,
0x00000000003c7806ULL, 0x000fc800000e0100ULL, 0x000000807834a824ULL, 0x000fe200078e0209ULL,
0x000000ff3c00720cULL, 0x000fc80003f05270ULL, 0x000000347334a210ULL, 0x000fca0007ffe072ULL,
0x01a400373400a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x800000377f7f7221ULL, 0x000fe20000010000ULL, 0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003cff7812ULL, 0x040fe2000784c0ffULL, 0x3fb8aa3b7f7f7820ULL, 0x000fe20000410000ULL,
0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL, 0xff0000003cff7812ULL, 0x000fe2000788c0ffULL,
0x0000007f003e7308ULL, 0x0004ec0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff3f7819ULL, 0x000fca000001160aULL, 0x00001f3f3e347589ULL, 0x00ae6400000e0000ULL,
0x0000005434547220ULL, 0x042fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a3f7811ULL, 0x000fca00078ff0ffULL,
0x00001f3f3e347589ULL, 0x00ae6400000e0000ULL, 0x0000005634567220ULL, 0x042fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a3f7811ULL, 0x000fca00078ff0ffULL, 0x00001f3f3e347589ULL, 0x00ae6400000e0000ULL,
0x0000000c340c7220ULL, 0x042fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003e7d7d7220ULL, 0x008fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a3f7811ULL, 0x000fca00078ff0ffULL, 0x00001f3f3e347589ULL, 0x002e6400000e0000ULL,
0x0000000e340e7220ULL, 0x042fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003c3dff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff7f7224ULL, 0x004fd400078e0037ULL, 0x8000003736360221ULL, 0x100fe20000010000ULL,
0x000000ffff7f0224ULL, 0x000fe200078e0037ULL, 0x00007610ff3c0816ULL, 0x000fe4000000003cULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600040308ULL, 0x000ea40000000800ULL,
0x0000000435350220ULL, 0x004fce0000410000ULL, 0x0000007d357d7221ULL, 0x000fe20000010000ULL,
0x0000000000347805ULL, 0x002fe20000015200ULL, 0x00000083ff0075a7ULL, 0x000ea40008000145ULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x00000083ff0075a7ULL, 0x000e640008000145ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000278757824ULL, 0x000fe200078e00ffULL, 0x000099103c367816ULL, 0x000fe200000000ffULL,
0x0000040078377824ULL, 0x000fe400078e00ffULL, 0x000000086a3c7824ULL, 0x000fe200078e00ffULL,
0x0000000475357812ULL, 0x000fe200078ec0ffULL, 0x00000008773d7824ULL, 0x000fe200078e00ffULL,
0x000000ff3600720cULL, 0x000fe20003f05270ULL, 0x0000001074407824ULL, 0x000fe200078e026bULL,
0x000000350a347211ULL, 0x000fe400078fe0ffULL, 0xfffff00037807812ULL, 0x000fc600078ec0ffULL,
0x000000016a357824ULL, 0x000fe200078e0234ULL, 0x0001400009807810ULL, 0x000fe20007ffe080ULL,
0x0000000177347824ULL, 0x000fc600078e0234ULL, 0xfffffff83c357812ULL, 0x000fe400078ee235ULL,
0xfffffff83d377812ULL, 0x000fc600078ee234ULL, 0x00000010353c7824ULL, 0x100fe400078e0280ULL,
0x0000001037377824ULL, 0x000fe200078e0280ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x0000541000347816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x00000018033d7836ULL, 0x000fe40000000000ULL,
0x00001f0534057589ULL, 0x0002a800000e0000ULL, 0x00001f3534027589ULL, 0x0002e800000e0000ULL,
0x00001f0334037589ULL, 0x00026800000e0000ULL, 0x00001f3d34007589ULL, 0x00026400000e0000ULL,
0x000000003c3c783bULL, 0x002e680000000200ULL, 0x000000003734783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x088fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x084fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000107e5c7824ULL, 0x000fe200078e026bULL,
0x000000004040783bULL, 0x000f2a0000004200ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000ff40627812ULL, 0x010fe400078ec0ffULL, 0x00000010ff897819ULL, 0x000fe40000011643ULL,
0x000000ff43697812ULL, 0x000fc400078ec0ffULL, 0x00000018ff937819ULL, 0x000fe40000011643ULL,
0x0000ffff438b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8a7819ULL, 0x128fe4000001165cULL,
0x000000ff5c947812ULL, 0x040fe400078ec0ffULL, 0x00000018ff437819ULL, 0x000fe4000001165cULL,
0x0000ffff5c867812ULL, 0x000fc400078ec0ffULL, 0x00000062ff66723eULL, 0x000fe400020006ffULL,
0x00000018ff5c7819ULL, 0x100fe4000001165dULL, 0x00000010ff8c7819ULL, 0x000fe2000001165dULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x000000ff5d957812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e627812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x00000018ff927819ULL, 0x100fe4000001165fULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff837819ULL, 0x000fe4000001165fULL,
0x000000ff5f637812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f817812ULL, 0x000fc400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000005dff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000062ff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe20000011641ULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x0000ffff418e7812ULL, 0x000fe200078ec0ffULL,
0x20000092ff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fc40000011640ULL,
0x0000ffff408f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff91927812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x000fe40000011642ULL, 0x00000008ff8e7819ULL, 0x000fe4000001168eULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x00000008ff917819ULL, 0x000fc4000001168fULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000018ff647819ULL, 0x000fe40000011640ULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff42687812ULL, 0x040fe400078ec0ffULL, 0x0000ffff42887812ULL, 0x000fc400078ec0ffULL,
0x00000090ff8f723eULL, 0x000fe400020006ffULL, 0x00000091ff90723eULL, 0x000fe200020006ffULL,
0x20000092ff917230ULL, 0x000fe20000004100ULL, 0x000000ff41677812ULL, 0x000fe200078ec0ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000018ff657819ULL, 0x000fe20000011641ULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x0000008dff92723eULL, 0x000fe200020006ffULL,
0x2000008eff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x00000068ff42723eULL, 0x000fe200020006ffULL, 0x20000064ff687230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe40000011688ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168bULL,
0x20000092ff8b7230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000042ff647230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000008eff92723eULL, 0x000fe200020006ffULL,
0x20000088ff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000092ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe4000001165eULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x00000093ff42723eULL, 0x000fe400020006ffULL, 0x0000ffff5e827812ULL, 0x000fe400078ec0ffULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff8c937812ULL, 0x000fe200078ec0ffULL, 0x20000089ff8c7230ULL, 0x000fe20000004100ULL,
0x00000065ff40723eULL, 0x000fe400020006ffULL, 0x00000069ff65723eULL, 0x000fe200020006ffULL,
0x20000067ff697230ULL, 0x000fe20000004100ULL, 0x00000043ff5e723eULL, 0x000fe200020006ffULL,
0x20000041ff677230ULL, 0x000fe20000004100ULL, 0x0000008aff89723eULL, 0x000fe200020006ffULL,
0x20000094ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe20000011687ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000000ff83927812ULL, 0x000fe200078ec0ffULL,
0x20000086ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff817819ULL, 0x000fc40000011681ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000087ff867230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x2000007eff877230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000093ff8a723eULL, 0x000fe200020006ffULL, 0x20000092ff7e7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000095ff437230ULL, 0x000fe20000004100ULL,
0x000010548b647816ULL, 0x000fe20000000064ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe20000011641ULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fc40000011642ULL, 0x00000010ff417819ULL, 0x000fe40000011688ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff887819ULL, 0x000fe40000011689ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff837819ULL, 0x000fc40000011683ULL, 0x00000010ff937819ULL, 0x000fe40000011668ULL,
0x0000105442417816ULL, 0x000fe40000000041ULL, 0x00000010ff897819ULL, 0x000fe4000001165cULL,
0x000010548f687816ULL, 0x000fe40000000066ULL, 0x0000105488427816ULL, 0x000fe4000000008bULL,
0x000010545e5c7816ULL, 0x000fc40000000083ULL, 0x00000010ff8f7819ULL, 0x000fe40000011667ULL,
0x00000010ff887819ULL, 0x000fe4000001165dULL, 0x00000010ff837819ULL, 0x000fe40000011662ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff677819ULL, 0x000fe4000001168dULL,
0x00000010ff5d7819ULL, 0x000fc40000011686ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff627819ULL, 0x000fe40000011682ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff927819ULL, 0x000fe40000011691ULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff867819ULL, 0x000fc40000011687ULL, 0x00000010ff827819ULL, 0x000fe4000001165fULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x0000105440677816ULL, 0x000fe40000000067ULL,
0x000010547e5f7816ULL, 0x000fe40000000063ULL, 0x0000105492697816ULL, 0x000fe40000000069ULL,
0x0000105493667816ULL, 0x000fc40000000090ULL, 0x000010548c657816ULL, 0x000fe40000000065ULL,
0x000010548f407816ULL, 0x000fe2000000008eULL, 0x000000683c54723cULL, 0x002fe20000041854ULL,
0x000010548a437816ULL, 0x000fe40000000043ULL, 0x00001054885d7816ULL, 0x000fe4000000005dULL,
0x00001054865e7816ULL, 0x000fe20000000089ULL, 0x000000663c48723cULL, 0x000fe20000041848ULL,
0x0000105483627816ULL, 0x000fc40000000062ULL, 0x0000105482637816ULL, 0x000fc60000000081ULL,
0x000000643c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005c3c2c723cULL, 0x000fec000004182cULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000623c24723cULL, 0x000fec0000041824ULL,
0x00000068340c723cULL, 0x000fe2000004180cULL, 0x000000107b3c7824ULL, 0x000fc400078e0280ULL,
0x0000001079807824ULL, 0x000fc600078e0280ULL, 0x000000663410723cULL, 0x000fe20000041810ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x000000643414723cULL, 0x000fec0000041814ULL,
0x000000403418723cULL, 0x000fec0000041818ULL, 0x00000042341c723cULL, 0x000fe2000004181cULL,
0x000000107a407824ULL, 0x000fca00078e026bULL, 0x0000005c3420723cULL, 0x000fec0000041820ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000623444723cULL, 0x000fe20000041844ULL,
0x000000008034783bULL, 0x0006a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x080fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x084fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000107c5c7824ULL, 0x000fe200078e026bULL,
0x000000004040783bULL, 0x000f2a0000004200ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000ff40627812ULL, 0x010fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fe40000011641ULL,
0x000000ff41667812ULL, 0x000fc400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe40000011641ULL,
0x0000ffff418c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe40000011642ULL,
0x000000ff42677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x0000ffff42837812ULL, 0x000fc400078ec0ffULL, 0x00000010ff867819ULL, 0x100fe40000011643ULL,
0x000000ff43687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe40000011643ULL,
0x0000ffff43887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff897819ULL, 0x028fe4000001165cULL,
0x000000ff5c917812ULL, 0x000fc400078ec0ffULL, 0x00000018ff437819ULL, 0x000fe4000001165cULL,
0x0000ffff5c827812ULL, 0x000fe400078ec0ffULL, 0x00000062ff69723eULL, 0x000fe400020006ffULL,
0x00000018ff5c7819ULL, 0x100fe4000001165dULL, 0x00000010ff8a7819ULL, 0x000fe2000001165dULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x000000ff5d927812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x00000018ff907819ULL, 0x100fe4000001165fULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff817819ULL, 0x000fc4000001165fULL,
0x000000ff5f637812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f7e7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000005dff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000062ff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fe20000011640ULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x0000ffff408d7812ULL, 0x000fe200078ec0ffULL,
0x20000090ff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff8e907812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe4000001168cULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8e7819ULL, 0x000fe4000001168dULL,
0x0000008fff8d723eULL, 0x000fe400020006ffULL, 0x00000018ff647819ULL, 0x000fc40000011640ULL,
0x00000090ff8f723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000008bff90723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000008cff8b7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000090ff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff837819ULL, 0x000fc40000011683ULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000065ff40723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x000000ff89907812ULL, 0x000fe200078ec0ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000068ff65723eULL, 0x000fe200020006ffULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000067ff647230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000041ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe2000001165eULL,
0x20000091ff417230ULL, 0x000fe20000004100ULL, 0x000000ff8a917812ULL, 0x000fe200078ec0ffULL,
0x20000083ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff837819ULL, 0x000fe20000011687ULL,
0x20000090ff877230ULL, 0x000fe20000004100ULL, 0x000000ff7c7c7812ULL, 0x000fc400078ec0ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x000000ff81907812ULL, 0x000fe200078ec0ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000082ff817230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011688ULL, 0x20000083ff827230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x2000007cff837230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fc400020006ffULL, 0x0000ffff5e807812ULL, 0x000fe200078ec0ffULL,
0x20000086ff897230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000090ff7c7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x20000088ff867230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000091ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fc40000011666ULL, 0x00000010ff667819ULL, 0x000fe2000001168eULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe40000011665ULL,
0x00000043ff5e723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc4000001168cULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000008ff917819ULL, 0x000fe2000001167eULL, 0x20000080ff7e7230ULL, 0x000fe20000004100ULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000105489657816ULL, 0x000fe4000000008eULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000091ff80723eULL, 0x000fc400020006ffULL,
0x00000010ff897819ULL, 0x000fe20000011641ULL, 0x20000092ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe20000011686ULL, 0x000000643c4c723cULL, 0x002fe2000004184cULL,
0x00000010ff867819ULL, 0x000fe40000011687ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x000000643414723cULL, 0x004fe20000041814ULL,
0x0000105442417816ULL, 0x000fc40000000041ULL, 0x00000010ff917819ULL, 0x000fe40000011668ULL,
0x0000105486427816ULL, 0x000fe40000000089ULL, 0x00000010ff687819ULL, 0x000fe4000001168dULL,
0x00000010ff867819ULL, 0x000fe4000001165dULL, 0x00000010ff877819ULL, 0x000fe4000001165cULL,
0x00000010ff8d7819ULL, 0x000fc40000011667ULL, 0x00000010ff5d7819ULL, 0x000fe40000011682ULL,
0x000010545e5c7816ULL, 0x000fe40000000081ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff677819ULL, 0x000fe4000001168bULL,
0x00000010ff827819ULL, 0x000fc40000011683ULL, 0x00000010ff817819ULL, 0x000fe40000011662ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff437819ULL, 0x000fc40000011643ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff627819ULL, 0x000fe4000001167eULL, 0x00000010ff837819ULL, 0x000fe4000001165fULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x0000105468687816ULL, 0x000fe40000000069ULL,
0x0000105440677816ULL, 0x000fc40000000067ULL, 0x000010547c5f7816ULL, 0x000fe40000000063ULL,
0x000010548f697816ULL, 0x000fe40000000090ULL, 0x0000105491667816ULL, 0x000fe40000000066ULL,
0x000010548d407816ULL, 0x000fe4000000008aULL, 0x0000105488437816ULL, 0x000fe20000000043ULL,
0x000000683c54723cULL, 0x000fe20000041854ULL, 0x00001054865d7816ULL, 0x000fc4000000005dULL,
0x00001054825e7816ULL, 0x000fe40000000087ULL, 0x0000105481627816ULL, 0x000fe20000000062ULL,
0x000000663c48723cULL, 0x000fe20000041848ULL, 0x0000105483637816ULL, 0x000fca0000000080ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005c3c2c723cULL, 0x000fec000004182cULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000623c24723cULL, 0x000fec0000041824ULL, 0x00000068340c723cULL, 0x000fe2000004180cULL,
0xfffffff8753e7812ULL, 0x000fe200078ec0ffULL, 0x00000008603c7824ULL, 0x000fc400078e0209ULL,
0x00000001ff3f7424ULL, 0x000fe400078e00ffULL, 0x00000001093e7824ULL, 0x000fe200078e023eULL,
0x000000663410723cULL, 0x000fe20000041810ULL, 0x01a6c83f3c3c79a7ULL, 0x000e6a000850003fULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x01a6983f3eff79a7ULL, 0x0005ea000850003fULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005c3420723cULL, 0x000fec0000041820ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000623444723cULL, 0x000fee0000041844ULL,
0x0000000000347805ULL, 0x000fe20000015200ULL, 0x0000003d060075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x006fdc0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000107347836ULL, 0x000fca0000000000ULL, 0x0000005b3400720cULL, 0x000fda0003f06070ULL,
0x0000000400d40947ULL, 0x000fea0003800000ULL, 0x0000000207347836ULL, 0x000fe20000000000ULL,
0x0000920000087ab9ULL, 0x000fe20000000800ULL, 0x000001006f367836ULL, 0x000fc60000000000ULL,
0x0000005b3400720cULL, 0x000fe20003f06070ULL, 0x00000008593f7c24ULL, 0x000fd8000f8e0236ULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x0000003661347248ULL, 0x000fe20007fe0000ULL,
0x0000001070357824ULL, 0x000fe200078e00ffULL, 0x00000003ff377819ULL, 0x000fe2000001160aULL,
0x00008e0000087ab9ULL, 0x000fe40000000a00ULL, 0x0000000134347824ULL, 0x000fe400078e0a36ULL,
0x0000000135367824ULL, 0x000fe400078e0237ULL, 0x00000004373d7836ULL, 0x000fe20000000000ULL,
0x0000003435347248ULL, 0x000fe20007fe0000ULL, 0x00000001363c7824ULL, 0x000fc400078e020aULL,
0x0000000836417824ULL, 0x000fe400078e00ffULL, 0x0000000134347824ULL, 0x000fe400078e0a35ULL,
0x00000008373e7836ULL, 0x000fe20000000000ULL, 0xfffffff841407812ULL, 0x000fe200078ee23cULL,
0x00000001353c7824ULL, 0x000fe200078e023dULL, 0x000000343700720cULL, 0x080fe20003f86070ULL,
0x0000000c37377836ULL, 0x000fe20000000000ULL, 0x000000343d00720cULL, 0x080fe20003f66070ULL,
0x0000000136367824ULL, 0x000fe200078e023fULL, 0x000000343e00720cULL, 0x080fe20003f46070ULL,
0x0000000135417824ULL, 0x000fe200078e0237ULL, 0x000000343700720cULL, 0x000fe20003f06070ULL,
0x000000013c347824ULL, 0x000fc400078e020aULL, 0x000000083c377824ULL, 0x040fe400078e00ffULL,
0x00000001353e7824ULL, 0x000fe400078e023eULL, 0x000000013c3c7824ULL, 0x000fe200078e023fULL,
0xfffffff837427812ULL, 0x000fe200078ee234ULL, 0x000000013e357824ULL, 0x040fe400078e020aULL,
0x000000083e5c7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee235ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000007236367212ULL, 0x000fc600078efcffULL, 0x000000013e347824ULL, 0x100fe200078e023fULL,
0x000000723c3c7212ULL, 0x080fe200078efcffULL, 0x00000001413e7824ULL, 0x040fe200078e023fULL,
0x0000000836367c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000083c3c7c10ULL, 0x000fe4000ffde0ffULL, 0x0000000937377c10ULL, 0x000fe2000affe4ffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000007234347212ULL, 0x080fe400078efcffULL,
0x000000093d3d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000141437824ULL, 0x040fe200078e020aULL,
0x000000723e3e7212ULL, 0x000fe200078efcffULL, 0x00000008415e7824ULL, 0x000fe200078e00ffULL,
0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL, 0x0000001040417824ULL, 0x100fe200078e026bULL,
0x000000083e3e7c10ULL, 0x000fe2000ffde0ffULL, 0x000000105c5d7824ULL, 0x100fe200078e026bULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee243ULL, 0x0000001042437824ULL, 0x100fe200078e026bULL,
0x0000000935357c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036417faeULL, 0x0003e2000e101c46ULL, 0x000000093f3f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000105e6b7824ULL, 0x000fc400078e026bULL, 0x000000003c437faeULL, 0x0003e8000d901c46ULL,
0x00000000345d7faeULL, 0x0003e8000d101c46ULL, 0x000000003e6b7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001070357824ULL, 0x000fe200078e00ffULL,
0x00008e0000087ab9ULL, 0x000fc80000000a00ULL, 0x000000350a357211ULL, 0x000fca00078fe8ffULL,
0x0000000135367824ULL, 0x040fe400078e020aULL, 0x0000000835377824ULL, 0x040fe400078e00ffULL,
0x0000000835417836ULL, 0x000fe40000000000ULL, 0x0000000c35427836ULL, 0x000fe20000000000ULL,
0xfffffff837407812ULL, 0x000fe200078ee236ULL, 0x0000000435377836ULL, 0x000fe40000000000ULL,
0x0000000135347824ULL, 0x000fc400078e023fULL, 0x0000000137367824ULL, 0x140fe400078e023fULL,
0x00000001373d7824ULL, 0x140fe400078e020aULL, 0x00000008375c7824ULL, 0x000fe400078e00ffULL,
0x00000001413e7824ULL, 0x140fe400078e023fULL, 0x00000001423c7824ULL, 0x000fe400078e023fULL,
0x0000000141377824ULL, 0x000fc400078e020aULL, 0x00000008415e7824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x00000001423f7824ULL, 0x000fe200078e020aULL,
0x0000007234347212ULL, 0x080fe200078efcffULL, 0x0000000842627824ULL, 0x000fe200078e00ffULL,
0xfffffff85c427812ULL, 0x000fe200078ee23dULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0xfffffff85e5c7812ULL, 0x000fe400078ee237ULL, 0xfffffff8625e7812ULL, 0x000fe200078ee23fULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000834347c10ULL, 0x000fe4000ff1e0ffULL,
0x000000723c3c7212ULL, 0x080fe200078efcffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000007236367212ULL, 0x000fc400078efcffULL, 0x0000000935357c10ULL, 0x000fe200087fe4ffULL,
0x0000001040417824ULL, 0x100fe200078e026bULL, 0x000000723e3e7212ULL, 0x000fe200078efcffULL,
0x0000001042437824ULL, 0x100fe200078e026bULL, 0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026bULL, 0x000000083e3e7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000105e6b7824ULL, 0x000fe200078e026bULL, 0x000000083c3c7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x0000000937377c10ULL, 0x000fc400087fe4ffULL, 0x000000093f3f7c10ULL, 0x000fe400097fe4ffULL,
0x000000093d3d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000000036437faeULL, 0x0003e8000b901c46ULL,
0x000000003e5d7faeULL, 0x0003e8000b901c46ULL, 0x000000003c6b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff3d7424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000003dff8079a7ULL, 0x0002a40008500005ULL, 0x01a6683d083c79a7ULL, 0x0022e4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a6683d080075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6683d080075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000008058357824ULL, 0x000fe400078e0209ULL, 0x00000001ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff7c7224ULL, 0x000fe200078e007fULL, 0x0000018072347810ULL, 0x000fca0007ffe035ULL,
0x0000000173347824ULL, 0x000fca00078e0234ULL, 0x01a0000034367984ULL, 0x000ee80000000800ULL,
0x01a2000034357984ULL, 0x0009220000000800ULL, 0x0000007f3600720bULL, 0x008fda0003f1d000ULL,
0x00000000003d7806ULL, 0x000fc800000e0100ULL, 0x000000ff3d00720cULL, 0x000fda0003f05270ULL,
0x0000000400908947ULL, 0x016fea0003800000ULL, 0x0000000358377836ULL, 0x000fe20000000000ULL,
0x0000007f3600720bULL, 0x0c0fe40003f14000ULL, 0x0000007f367c7209ULL, 0x000fe40007810000ULL,
0x000000783700720cULL, 0x000fd20003f45270ULL, 0x00000000003e7806ULL, 0x000fc800000e0100ULL,
0x000000807834a824ULL, 0x000fe200078e0209ULL, 0x000000ff3e00720cULL, 0x000fc80003f05270ULL,
0x000000347373a210ULL, 0x000fca0007ffe072ULL, 0x01a4007c7300a388ULL, 0x0003e80000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x0000007f7c347221ULL, 0x000fe20000010100ULL,
0x000000ff3eff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003eff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff00003eff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003eff7812ULL, 0x000fe2000788c0ffULL, 0x0000003400407308ULL, 0x0004ec0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff377819ULL, 0x000fca000001160aULL,
0x00001f3740347589ULL, 0x00cea400000e0000ULL, 0x0000005434547220ULL, 0x044fe20000410000ULL,
0x0000005534557220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004c344c7220ULL, 0x040fe20000410000ULL,
0x0000004d344d7220ULL, 0x040fe20000410000ULL, 0x0000005034507220ULL, 0x040fe20000410000ULL,
0x0000005134517220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002434247220ULL, 0x040fe20000410000ULL,
0x0000002534257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a377811ULL, 0x000fca00078ff0ffULL, 0x00001f3740347589ULL, 0x00cea400000e0000ULL,
0x0000005634567220ULL, 0x044fe20000410000ULL, 0x0000005734577220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004e344e7220ULL, 0x040fe20000410000ULL, 0x0000004f344f7220ULL, 0x040fe20000410000ULL,
0x0000005234527220ULL, 0x040fe20000410000ULL, 0x0000005334537220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002634267220ULL, 0x040fe20000410000ULL, 0x0000002734277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a377811ULL, 0x000fca00078ff0ffULL,
0x00001f3740347589ULL, 0x00cea400000e0000ULL, 0x0000000c340c7220ULL, 0x044fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x040fe20000410000ULL, 0x0000003834387220ULL, 0x040fe20000410000ULL,
0x0000003934397220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x000fce0000410000ULL, 0x000000407d7d7220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a377811ULL, 0x000fca00078ff0ffULL,
0x00001f3740347589ULL, 0x004ea400000e0000ULL, 0x0000000e340e7220ULL, 0x044fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x040fe20000410000ULL, 0x0000003a343a7220ULL, 0x040fe20000410000ULL,
0x0000003b343b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x000fce0000410000ULL, 0x0000003e3dff7212ULL, 0x000fda00078030ffULL,
0x000000367c360221ULL, 0x000fe20000010100ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600040308ULL, 0x000ee40000000800ULL,
0x0000000435350220ULL, 0x008fce0000410000ULL, 0x0000007d357d7221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x004fce0000015200ULL, 0xfffffff06c367812ULL, 0x000fca00078ec0ffULL,
0x00000001093f7824ULL, 0x000fc800078e0236ULL, 0x01a6b0853f0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6b0853f0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000000160347812ULL, 0x000fe200078ec0ffULL, 0x0000000478377824ULL, 0x000fe200078e00ffULL,
0x00000004ff357819ULL, 0x000fe2000001160aULL, 0x00000008773f7824ULL, 0x000fe200078e00ffULL,
0x000099103c367816ULL, 0x000fe200000000ffULL, 0x000000086a3c7824ULL, 0x000fe200078e00ffULL,
0x00000004373d7812ULL, 0x000fe200078ec0ffULL, 0x0000000434347824ULL, 0x000fe200078e0235ULL,
0x000000ff3600720cULL, 0x000fe20003f05270ULL, 0x0000100058367824ULL, 0x000fe200078e0209ULL,
0x000000023d3d7812ULL, 0x000fe200078efcffULL, 0x000000016a357824ULL, 0x000fc400078e0234ULL,
0x0000000177347824ULL, 0x000fe400078e0234ULL, 0x000170006e7f7836ULL, 0x000fe20000000000ULL,
0xfffffff83c357812ULL, 0x000fe200078ee235ULL, 0x0001500036627836ULL, 0x000fe20000000000ULL,
0xfffffff83f377812ULL, 0x000fe200078ee234ULL, 0x0000001074347824ULL, 0x000fe400078e027fULL,
0x0000001035357824ULL, 0x100fe400078e0262ULL, 0x0000001037377824ULL, 0x000fe200078e0262ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x0000541000367816ULL, 0x000fe20000000000ULL, 0x00000008033f7836ULL, 0x000fe40000000000ULL,
0x0000001803417836ULL, 0x000fe40000000000ULL, 0x00001f0536057589ULL, 0x0004e800000e0000ULL,
0x00001f3f36027589ULL, 0x00046800000e0000ULL, 0x00001f0336037589ULL, 0x00046800000e0000ULL,
0x00001f4136007589ULL, 0x00046400000e0000ULL, 0x00000000355c783bULL, 0x0008e80000000200ULL,
0x000000003740783bULL, 0x0044620000000200ULL, 0x0000000000200947ULL, 0x010fea0003800000ULL,
0x000000035c5c7232ULL, 0x08afe40000200000ULL, 0x000000035e5e7232ULL, 0x000fe40000200000ULL,
0x000000025d5d7232ULL, 0x080fe40000200000ULL, 0x000000025f5f7232ULL, 0x000fe40000200000ULL,
0x0000000540407232ULL, 0x080fe40000200000ULL, 0x0000000542427232ULL, 0x000fc40000200000ULL,
0x0000000041417232ULL, 0x080fe40000200000ULL, 0x0000000043437232ULL, 0x000fce0000200000ULL,
0x0000003d0a7e7211ULL, 0x000fe200078fe0ffULL, 0x000000086a3d7824ULL, 0x040fe200078e00ffULL,
0x000000003434783bULL, 0x004ea20000004200ULL, 0x000000107b7b7824ULL, 0x000fe400078e0262ULL,
0x000000016a6a7824ULL, 0x000fe400078e027eULL, 0x0000001079797824ULL, 0x000fc600078e0262ULL,
0xfffffff83d6a7812ULL, 0x000fca00078ee26aULL, 0x000000106a3c7824ULL, 0x000fcc00078e027fULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0x00000018ff647819ULL, 0x104fe40000011635ULL,
0x000000ff34637812ULL, 0x000fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011634ULL,
0x00000010ff867819ULL, 0x000fe40000011635ULL, 0x000000ff35657812ULL, 0x040fe400078ec0ffULL,
0x0000ffff35857812ULL, 0x000fc400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe40000011634ULL,
0x00000018ff357819ULL, 0x100fe40000011636ULL, 0x00000010ff827819ULL, 0x000fe40000011637ULL,
0x00000010ff807819ULL, 0x000fe40000011636ULL, 0x00000010ff6e7819ULL, 0x010fe4000001163cULL,
0x000000ff36667812ULL, 0x000fc400078ec0ffULL, 0x0000ffff36837812ULL, 0x000fe400078ec0ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000010ff727819ULL, 0x000fe4000001163dULL,
0x0000ffff34347812ULL, 0x000fe200078ec0ffULL, 0x20000064ff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff37887812ULL, 0x000fe400078ec0ffULL, 0x00000018ff367819ULL, 0x000fc40000011637ULL,
0x0000ffff37847812ULL, 0x000fe400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001163fULL,
0x20000063ff697230ULL, 0x000fe20000004100ULL, 0x000000ff3c897812ULL, 0x000fe200078ec0ffULL,
0x20000062ff6a7230ULL, 0x000fe20000004100ULL, 0x00000018ff377819ULL, 0x000fc4000001163cULL,
0x0000ffff3c737812ULL, 0x002fe400078ec0ffULL, 0x00000035ff35723eULL, 0x000fe400020006ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x20000035ff637230ULL, 0x000fe20000004100ULL, 0x000000ff3d8a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001163dULL, 0x0000ffff3d757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff747819ULL, 0x100fe4000001163eULL, 0x000000ff3e8c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e687812ULL, 0x000fe400078ec0ffULL,
0x000000ff82827812ULL, 0x000fc400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fe4000001163fULL,
0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fc40000011634ULL, 0x0000ffff3f6f7812ULL, 0x000fe400078ec0ffULL,
0x00000089ff64723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x000000ff80807812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000088ff62723eULL, 0x000fc400020006ffULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x00000008ff897819ULL, 0x000fe20000011685ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x000000ff74747812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000003eff35723eULL, 0x000fe200020006ffULL, 0x20000037ff3e7230ULL, 0x000fe20000004100ULL,
0x00000086ff88723eULL, 0x000fe200020006ffULL, 0x20000065ff677230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x20000035ff377230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000088ff857230ULL, 0x000fe20000004100ULL,
0x000000ff3d3d7812ULL, 0x000fc400078ec0ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000034ff86723eULL, 0x000fe200020006ffULL, 0x2000008dff347230ULL, 0x000fe20000004100ULL,
0x00000008ff757819ULL, 0x000fe20000011675ULL, 0x2000006eff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff687819ULL, 0x000fe20000011668ULL, 0x20000036ff657230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x0000008aff3f723eULL, 0x000fe200020006ffULL, 0x20000087ff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x20000082ff877230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000072ff827230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fc40000011673ULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000003dff6e723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000068ff3d723eULL, 0x000fe200020006ffULL,
0x2000006eff687230ULL, 0x000fe20000004100ULL, 0x0000008bff35723eULL, 0x000fe200020006ffULL,
0x20000080ff8b7230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000074ff807230ULL, 0x000fe20000004100ULL, 0x0000006fff72723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x0000008cff36723eULL, 0x000fe200020006ffULL,
0x20000089ff8c7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000083ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fe20000011669ULL,
0x20000075ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe20000011667ULL,
0x2000003dff697230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe2000001168aULL,
0x20000084ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe2000001166aULL,
0x20000072ff3d7230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fe20000011666ULL,
0x20000073ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011686ULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x0000003cff3c723eULL, 0x000fc400020006ffULL,
0x00000010ff6a7819ULL, 0x000fe4000001166bULL, 0x00000010ff667819ULL, 0x000fe20000011685ULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe4000001168cULL,
0x000010546f747816ULL, 0x000fe40000000074ULL, 0x0000105467727816ULL, 0x000fe40000000072ULL,
0x0000105466757816ULL, 0x000fc40000000075ULL, 0x000010546a737816ULL, 0x000fe40000000073ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff677819ULL, 0x000fe20000011664ULL,
0x00000074400c723cULL, 0x000fe2000004180cULL, 0x00000010ff6f7819ULL, 0x000fe40000011687ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff667819ULL, 0x000fe20000011665ULL,
0x000000724010723cULL, 0x000fe20000041810ULL, 0x00000010ff647819ULL, 0x000fc40000011689ULL,
0x00000010ff6a7819ULL, 0x000fe4000001168dULL, 0x00000010ff657819ULL, 0x000fe20000011688ULL,
0x000000745c54723cULL, 0x008fe20000041854ULL, 0x000010546f6f7816ULL, 0x000fe40000000062ULL,
0x0000105463647816ULL, 0x000fe40000000064ULL, 0x000010546a627816ULL, 0x000fe20000000067ULL,
0x000000725c48723cULL, 0x000fe20000041848ULL, 0x0000105466657816ULL, 0x000fc40000000065ULL,
0x00000010ff637819ULL, 0x000fe4000001163fULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff677819ULL, 0x000fe20000011683ULL, 0x000000644018723cULL, 0x000fe20000041818ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163eULL, 0x00000010ff667819ULL, 0x000fe40000011684ULL,
0x000010543c677816ULL, 0x000fe20000000067ULL, 0x000000645c50723cULL, 0x000fe20000041850ULL,
0x000010543f667816ULL, 0x000fc40000000066ULL, 0x00000010ff3c7819ULL, 0x000fe40000011637ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff827819ULL, 0x000fe20000011682ULL,
0x000000664020723cULL, 0x000fe20000041820ULL, 0x00000010ff367819ULL, 0x000fe40000011636ULL,
0x00000010ff377819ULL, 0x000fe40000011680ULL, 0x00000010ff3f7819ULL, 0x000fe20000011668ULL,
0x000000665c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff357819ULL, 0x000fc40000011635ULL,
0x00000010ff6a7819ULL, 0x000fe40000011669ULL, 0x00000010ff807819ULL, 0x000fe40000011634ULL,
0x00000010ff6b7819ULL, 0x000fe4000001163dULL, 0x000010548b6e7816ULL, 0x000fe4000000006eULL,
0x0000105482637816ULL, 0x000fe40000000063ULL, 0x0000105437687816ULL, 0x000fc40000000036ULL,
0x000010543f697816ULL, 0x000fe2000000003cULL, 0x0000006e4014723cULL, 0x000fe20000041814ULL,
0x00001054356a7816ULL, 0x000fe2000000006aULL, 0x000000007b3c783bULL, 0x0002620000000200ULL,
0x00001054806b7816ULL, 0x000fc6000000006bULL, 0x00000062401c723cULL, 0x000fe2000004181cULL,
0x000000007934783bULL, 0x0002ea0000000200ULL, 0x000000684038723cULL, 0x000fec0000041838ULL,
0x0000006e5c4c723cULL, 0x000fec000004184cULL, 0x000000625c30723cULL, 0x000fec0000041830ULL,
0x000000685c28723cULL, 0x000fec0000041828ULL, 0x0000006a5c24723cULL, 0x000fec0000041824ULL,
0x0000006a4040723cULL, 0x000fe20000041844ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000200947ULL, 0x002fde0003800000ULL, 0x000000033c3c7232ULL, 0x080fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x080fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x00000001777e7824ULL, 0x040fe400078e027eULL,
0x0000000877777824ULL, 0x000fe400078e00ffULL, 0x000000107a447824ULL, 0x000fe400078e027fULL,
0x0000000107077836ULL, 0x000fe20000000000ULL, 0xfffffff8777e7812ULL, 0x000fc600078ee27eULL,
0x000000004444783bULL, 0x000e640000004200ULL, 0x000000107e5c7824ULL, 0x000fcc00078e027fULL,
0x000000005c5c783bULL, 0x000ea20000004200ULL, 0x00000018ff747819ULL, 0x102fe40000011645ULL,
0x000000ff46797812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fe40000011645ULL,
0x000000ff45777812ULL, 0x040fe400078ec0ffULL, 0x0000ffff45857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff457819ULL, 0x004fc4000001165cULL, 0x000000ff5c677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe4000001165cULL, 0x0000ffff5c697812ULL, 0x000fe400078ec0ffULL,
0x000000ff44737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fe4000001165dULL,
0x000000ff5d5c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165dULL,
0x0000ffff5d6a7812ULL, 0x000fe400078ec0ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000079ff5d723eULL, 0x000fe400020006ffULL, 0x00000010ff6b7819ULL, 0x000fe20000011644ULL,
0x20000074ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff7f7819ULL, 0x100fe20000011646ULL,
0x2000005dff747230ULL, 0x000fe20000004100ULL, 0x00000018ff7a7819ULL, 0x000fc40000011646ULL,
0x0000ffff46867812ULL, 0x000fe400078ec0ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011644ULL, 0x000000ff47837812ULL, 0x000fe200078ec0ffULL,
0x20000073ff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe4000001165eULL,
0x000000ff5e667812ULL, 0x000fc400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe4000001165eULL,
0x0000ffff5e647812ULL, 0x000fe400078ec0ffULL, 0x000000ff755e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff6b5d7812ULL, 0x000fe400078ec0ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fc400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000077ff7b7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000006eff777230ULL, 0x000fe20000004100ULL, 0x0000005eff73723eULL, 0x000fe200020006ffULL,
0x20000083ff757230ULL, 0x000fe20000004100ULL, 0x0000ffff44847812ULL, 0x000fe200078ec0ffULL,
0x2000007aff6b7230ULL, 0x000fe20000004100ULL, 0x00000018ff807819ULL, 0x000fe20000011647ULL,
0x20000073ff837230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x00000010ff827819ULL, 0x000fe40000011647ULL, 0x00000080ff6e723eULL, 0x000fe200020006ffULL,
0x2000005dff807230ULL, 0x000fe20000004100ULL, 0x00000008ff5e7819ULL, 0x000fe40000011684ULL,
0x00000008ff7a7819ULL, 0x000fe20000011685ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff82737812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5d7819ULL, 0x000fc40000011686ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x2000005eff827230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000007aff847230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000073ff7a7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x0000ffff47727812ULL, 0x000fe200078ec0ffULL, 0x2000005dff737230ULL, 0x000fe20000004100ULL,
0x000000ff5f477812ULL, 0x000fe200078ec0ffULL, 0x20000068ff5c7230ULL, 0x000fe20000004100ULL,
0x00000067ff5d723eULL, 0x000fc400020006ffULL, 0x00000066ff68723eULL, 0x000fe400020006ffULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fe20000011672ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff677819ULL, 0x000fc40000011680ULL, 0x00000010ff667819ULL, 0x000fe40000011683ULL,
0x00000018ff447819ULL, 0x000fe4000001165fULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x00000046ff80723eULL, 0x000fe400020006ffULL,
0x00000047ff83723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000105467467816ULL, 0x000fe2000000007eULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x0000105466477816ULL, 0x000fe2000000007bULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000044ff7e723eULL, 0x000fe200020006ffULL,
0x20000080ff667230ULL, 0x000fe20000004100ULL, 0x000000ff457b7812ULL, 0x000fe200078ec0ffULL,
0x20000083ff677230ULL, 0x000fe20000004100ULL, 0x0000105477447816ULL, 0x000fe20000000082ULL,
0x000000463c54723cULL, 0x000fe20000041854ULL, 0x0000105479457816ULL, 0x000fe20000000084ULL,
0x2000007eff777230ULL, 0x000fe20000004100ULL, 0x00000008ff697819ULL, 0x000fc40000011669ULL,
0x00000008ff6a7819ULL, 0x000fe2000001166aULL, 0x00000046340c723cULL, 0x008fe2000004180cULL,
0x00000010ff657819ULL, 0x000fe4000001165fULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x000000443c48723cULL, 0x000fe20000041848ULL,
0x00000010ff467819ULL, 0x000fe40000011674ULL, 0x00000010ff477819ULL, 0x000fc40000011675ULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x000000443410723cULL, 0x000fe20000041810ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x0000ffff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff447819ULL, 0x000fe40000011673ULL,
0x00000010ff457819ULL, 0x000fe20000011672ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fc400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x000010547f467816ULL, 0x000fe20000000046ULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x000010547a477816ULL, 0x000fe20000000047ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x000010546b447816ULL, 0x000fe40000000044ULL, 0x000010546e457816ULL, 0x000fe40000000045ULL,
0x00000008ff647819ULL, 0x000fe20000011664ULL, 0x000000463c4c723cULL, 0x000fe2000004184cULL,
0x000000ff6f747812ULL, 0x000fc400078ec0ffULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x000000ff65657812ULL, 0x000fe200078ec0ffULL, 0x000000463414723cULL, 0x000fe20000041814ULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x000000443c50723cULL, 0x000fe20000041850ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x2000007bff6f7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x000000443418723cULL, 0x000fe20000041818ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe20000011662ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fe20000011669ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe2000001165dULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fc4000001165cULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x0000105447467816ULL, 0x000fe40000000046ULL, 0x00000010ff457819ULL, 0x000fe4000001165eULL,
0x000010545d477816ULL, 0x000fe4000000006aULL, 0x00000010ff5d7819ULL, 0x000fe40000011666ULL,
0x00000010ff5e7819ULL, 0x000fc40000011664ULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x000000463c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff5c7819ULL, 0x000fe40000011668ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x000000463420723cULL, 0x000fe20000041820ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff627819ULL, 0x000fc40000011665ULL, 0x00000010ff647819ULL, 0x000fe40000011677ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x000010545d5e7816ULL, 0x000fe4000000005eULL,
0x000010546f447816ULL, 0x000fe40000000044ULL, 0x0000105474457816ULL, 0x000fe40000000045ULL,
0x00001054635c7816ULL, 0x000fc4000000005cULL, 0x00001054625d7816ULL, 0x000fe40000000067ULL,
0x00001054645f7816ULL, 0x000fe2000000005fULL, 0x000000443c30723cULL, 0x000fec0000041830ULL,
0x0000005c3c28723cULL, 0x000fec0000041828ULL, 0x0000005e3c24723cULL, 0x000fec0000041824ULL,
0x00000044341c723cULL, 0x000fe2000004181cULL, 0x00000001ff3f7424ULL, 0x000fc800078e00ffULL,
0x0000003f063c79a7ULL, 0x0002a2000850003fULL, 0x0000005c3438723cULL, 0x000fec0000041838ULL,
0x0000005e3434723cULL, 0x000fe20000041840ULL, 0x0000000858067824ULL, 0x002fc800078e0209ULL,
0x01a6a03f06ff79a7ULL, 0x0003e4000850003fULL, 0x000000ffff407224ULL, 0x004fe200078e003dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff40008c9947ULL, 0x002fde000383ffffULL,
0x000000ff5b00720cULL, 0x000fda0003f05270ULL, 0x0000000400648947ULL, 0x000fea0003800000ULL,
0x018000007d007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000da9000047802ULL, 0x000fce0000000f00ULL,
0x000000b000287944ULL, 0x006fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000007d00007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc8000000007dULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009600ff027b82ULL, 0x000f240000000a00ULL,
0x0000000602037981ULL, 0x010f22000c1e9900ULL, 0x0000000000057919ULL, 0x000f640000000000ULL,
0x0000001805077811ULL, 0x062fe400078ff0ffULL, 0x00000002ff3d7819ULL, 0x000fe40000011605ULL,
0x00000008053f7811ULL, 0x040fe400078ff0ffULL, 0x0000001005417811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f3d00047589ULL, 0x000e6800000e0000ULL,
0x00001f3f00067589ULL, 0x000ea800000e0000ULL, 0x00001f4100057589ULL, 0x000ee800000e0000ULL,
0x00001f0700077589ULL, 0x000f2200000e0000ULL, 0x0000005404547220ULL, 0x042fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x000fe20000410000ULL, 0x0000005606567220ULL, 0x044fe20000410000ULL,
0x0000005706577220ULL, 0x040fe20000410000ULL, 0x0000004a064a7220ULL, 0x040fe20000410000ULL,
0x0000004b064b7220ULL, 0x040fe20000410000ULL, 0x0000004e064e7220ULL, 0x040fe20000410000ULL,
0x0000004f064f7220ULL, 0x040fe20000410000ULL, 0x0000005206527220ULL, 0x040fe20000410000ULL,
0x0000005306537220ULL, 0x040fe20000410000ULL, 0x0000003206327220ULL, 0x040fe20000410000ULL,
0x0000003306337220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x000fe20000410000ULL, 0x0000000c050c7220ULL, 0x048fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000001105117220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000003805387220ULL, 0x040fe20000410000ULL,
0x0000003905397220ULL, 0x040fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000003505357220ULL, 0x000fe20000410000ULL, 0x0000000e070e7220ULL, 0x050fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000003a073a7220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x000fce0000410000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000200070097824ULL, 0x000fe200078e0209ULL, 0x000000303130723eULL, 0x000fe400000010ffULL,
0x0000002c2d2c723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000282928723eULL, 0x000fc400000010ffULL, 0x000000242524723eULL, 0x000fe400000010ffULL,
0x000000565757723eULL, 0x000fe400000010ffULL, 0x0000004a4b4a723eULL, 0x000fe400000010ffULL,
0x0000004e4f4e723eULL, 0x000fe400000010ffULL, 0x000000525352723eULL, 0x000fe400000010ffULL,
0x0000541057567816ULL, 0x000fc4000000004aULL, 0x0000763257577816ULL, 0x000fe4000000004aULL,
0x000076324e257816ULL, 0x000fe40000000052ULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe200000010ffULL, 0x000000015a5a7824ULL, 0x002fe200078e0203ULL,
0x0000000803057811ULL, 0x040fe400078ff0ffULL, 0x00000010033d7811ULL, 0x040fe200078ff0ffULL,
0x000000105a5a7824ULL, 0x000fe200078e0209ULL, 0x0000000203007812ULL, 0x000fe200078ec0ffULL,
0x0000000805417824ULL, 0x000fe200078e00ffULL, 0x00000002ff077819ULL, 0x000fe20000011603ULL,
0x000000083d3e7824ULL, 0x000fe200078e00ffULL, 0x00000018033f7811ULL, 0x000fc400078ff0ffULL,
0x0000000500047211ULL, 0x040fe200078ff8ffULL, 0x00000008070a7824ULL, 0x040fe200078e00ffULL,
0x0000000700027211ULL, 0x040fe400078ff8ffULL, 0x0000003d00057211ULL, 0x040fe200078ff8ffULL,
0x00000008073d7824ULL, 0x000fe200078e00ffULL, 0x0000003f00067211ULL, 0x000fe200078ff8ffULL,
0x000000083f3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee205ULL,
0x0000000202007836ULL, 0x000fe20000000000ULL, 0xfffffff8413c7812ULL, 0x000fe200078ee204ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0xfffffff83f407812ULL, 0x000fe200078ee206ULL,
0x0000000402047836ULL, 0x000fe20000000000ULL, 0xfffffff83d067812ULL, 0x000fe200078ee200ULL,
0x0000000602077836ULL, 0x000fe20000000000ULL, 0xfffffff805007812ULL, 0x000fe200078ee202ULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff83d087812ULL, 0x000fe200078ee204ULL,
0x0000100060057824ULL, 0x000fe200078e0209ULL, 0xfffffff80a0a7812ULL, 0x000fc400078ee207ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x0000001000047824ULL, 0x100fe200078e0205ULL,
0x000000545500723eULL, 0x000fe200000010ffULL, 0x000000103c3c7824ULL, 0x100fe200078e0205ULL,
0x000000484902723eULL, 0x000fe200000010ffULL, 0x000000103e3e7824ULL, 0x100fe200078e0205ULL,
0x0000002a2b2a723eULL, 0x000fe200000010ffULL, 0x0000001040407824ULL, 0x100fe200078e0205ULL,
0x0000541000427816ULL, 0x100fe20000000002ULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x0000763200437816ULL, 0x000fe20000000002ULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000004c4d00723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x000000505102723eULL, 0x000fe200000010ffULL, 0x00000001073d7824ULL, 0x000fe200078e023cULL,
0x000000262726723eULL, 0x000fe200000010ffULL, 0x0000000104047824ULL, 0x000fe200078e0207ULL,
0x0000000c0d0c723eULL, 0x000fe200000010ffULL, 0x00000001073e7824ULL, 0x000fe200078e023eULL,
0x000000141514723eULL, 0x000fe200000010ffULL, 0x0000000107407824ULL, 0x040fe200078e0240ULL,
0x0000004204007388ULL, 0x000fe20000000a00ULL, 0x0000000107057824ULL, 0x040fe200078e0206ULL,
0x0000541000067816ULL, 0x040fe20000000002ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x0000001c1d1c723eULL, 0x000fe200000010ffULL, 0x00000001073c7824ULL, 0x000fe200078e020aULL,
0x0000763200077816ULL, 0x000fc40000000002ULL, 0x00000018190a723eULL, 0x000fe200000010ffULL,
0x000000ff00007306ULL, 0x000e620000202400ULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x0000000605007388ULL, 0x0007e20000000a00ULL, 0x00007632140d7816ULL, 0x000fe4000000000aULL,
0x000000383938723eULL, 0x000fe400000010ffULL, 0x000000343534723eULL, 0x000fe400000010ffULL,
0x0000000e0f0e723eULL, 0x000fc400000010ffULL, 0x000000161716723eULL, 0x000fe400000010ffULL,
0x0000001a1b1a723eULL, 0x000fe400000010ffULL, 0x0000541030067816ULL, 0x148fe4000000002cULL,
0x0000763230077816ULL, 0x000fe4000000002cULL, 0x0000001e1f1e723eULL, 0x000fe400000010ffULL,
0x00000022230f723eULL, 0x000fe200000010ffULL, 0x0000000608007388ULL, 0x0007e20000000a00ULL,
0x0000003a3b3a723eULL, 0x000fc400000010ffULL, 0x00000036371d723eULL, 0x000fe400000010ffULL,
0x000076321e217816ULL, 0x000fe4000000000fULL, 0x000076323a297816ULL, 0x000fe4000000001dULL,
0x000000ff6000720cULL, 0x000fe40003f05270ULL, 0x0000541028067816ULL, 0x148fe40000000024ULL,
0x0000763228077816ULL, 0x000fc40000000024ULL, 0x000054104e247816ULL, 0x000fe40000000052ULL,
0x000054103a287816ULL, 0x000fe2000000001dULL, 0x000000063c007388ULL, 0x0007e80000000a00ULL,
0x000000563d007388ULL, 0x000fe80000000a00ULL, 0x0004002405007388ULL, 0x0009e20000000a00ULL,
0x000000101106723eULL, 0x008fc400000010ffULL, 0x000054102a107816ULL, 0x140fe40000000026ULL,
0x000076322a117816ULL, 0x000fe40000000026ULL, 0x000000121307723eULL, 0x000fe400000010ffULL,
0x0000541032247816ULL, 0x150fe4000000002eULL, 0x0000763232257816ULL, 0x000fca000000002eULL,
0x0004002408007388ULL, 0x000fe80000000a00ULL, 0x000400103c007388ULL, 0x0007e40000000a00ULL,
0x000054100c107816ULL, 0x148fe40000000006ULL, 0x000076320c117816ULL, 0x000fe40000000006ULL,
0x00005410140c7816ULL, 0x000fc4000000000aULL, 0x000054100e067816ULL, 0x140fe20000000007ULL,
0x000000103e007388ULL, 0x000fe20000000a00ULL, 0x000076320e077816ULL, 0x000fc60000000007ULL,
0x0008000c05007388ULL, 0x0007e40000000a00ULL, 0x000054101c0c7816ULL, 0x148fe40000000020ULL,
0x000076321c0d7816ULL, 0x000fe40000000020ULL, 0x000054101e207816ULL, 0x000fc6000000000fULL,
0x0008000c08007388ULL, 0x0007e40000000a00ULL, 0x00005410380c7816ULL, 0x148fe40000000034ULL,
0x00007632380d7816ULL, 0x000fca0000000034ULL, 0x0008000c3c007388ULL, 0x000fe80000000a00ULL,
0x0000000640007388ULL, 0x0007e40000000a00ULL, 0x0000541016067816ULL, 0x148fe4000000001aULL,
0x0000763216077816ULL, 0x000fca000000001aULL, 0x000c000605007388ULL, 0x000fe80000000a00ULL,
0x000c002008007388ULL, 0x000fe80000000a00ULL, 0x000c00283c007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000005a0c7984ULL, 0x000e680000000c00ULL,
0x000400005a107984ULL, 0x000ee80000000c00ULL, 0x000800005a187984ULL, 0x000f280000000c00ULL,
0x000c00005a207984ULL, 0x000f680000000c00ULL, 0x001000005a047984ULL, 0x000f280000000c00ULL,
0x001400005a147984ULL, 0x000f680000000c00ULL, 0x001800005a1c7984ULL, 0x000f680000000c00ULL,
0x001c00005a247984ULL, 0x000f620000000c00ULL, 0x0000000f000f7230ULL, 0x002fc40000200800ULL,
0x0000000e000e7230ULL, 0x040fe40000200800ULL, 0x0000000d000d7230ULL, 0x040fe40000200800ULL,
0x0000000c000c7230ULL, 0x040fe40000200800ULL, 0x0000001300137230ULL, 0x048fe40000200800ULL,
0x0000001200127230ULL, 0x040fe40000200800ULL, 0x0000001100117230ULL, 0x000fc40000200800ULL,
0x0000001000107230ULL, 0x040fe40000200800ULL, 0x0000001b001b7230ULL, 0x050fe40000200800ULL,
0x0000001a001a7230ULL, 0x040fe40000200800ULL, 0x0000001900197230ULL, 0x040fe40000200800ULL,
0x0000001800187230ULL, 0x040fe40000200800ULL, 0x0000002300237230ULL, 0x024fc40000200800ULL,
0x0000002200227230ULL, 0x040fe40000200800ULL, 0x0000002100217230ULL, 0x040fe40000200800ULL,
0x0000002000007230ULL, 0x000fe40000200800ULL, 0x000000070f0f7230ULL, 0x000fe40000200000ULL,
0x000000060e0e7230ULL, 0x000fe40000200000ULL, 0x000000050d0d7230ULL, 0x000fc40000200000ULL,
0x000000040c0c7230ULL, 0x000fe40000200000ULL, 0x0000001713137230ULL, 0x000fe40000200000ULL,
0x0000001612127230ULL, 0x000fe20000200000ULL, 0x0000000c5a007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000200000ULL, 0x0000001410107230ULL, 0x000fe40000200000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000200000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000200000ULL,
0x000400105a007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000200000ULL,
0x0000001c18187230ULL, 0x000fe40000200000ULL, 0x0000002723237230ULL, 0x000fe40000200000ULL,
0x0000002622227230ULL, 0x000fe20000200000ULL, 0x000800185a007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000200000ULL, 0x0000002400207230ULL, 0x000fca0000200000ULL,
0x000c00205a007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011603ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x0000006d0400720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104007824ULL, 0x000fe200078e0203ULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000a05057299ULL, 0x000fe2000800063fULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0000000703077812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800007812ULL, 0x000fc600078ef803ULL, 0x0000000870077824ULL, 0x000fe400078e0207ULL,
0x0000001000027824ULL, 0x000fe400078e0209ULL, 0x0000002071007824ULL, 0x000fc600078e0204ULL,
0x00000000020c7984ULL, 0x0022a40000000c00ULL, 0x0000000500057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff047c19ULL, 0x000fe20008011600ULL, 0x000000040b007c24ULL, 0x000fe4000f8e02ffULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000002003027836ULL, 0x002fe40000000000ULL,
0x0000000b04057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x0000006d0600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002071067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000870117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x0000004003027836ULL, 0x000fe20000000000ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe400078e0209ULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x000e620000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x0000006d0600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0023f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002071067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000870117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x0000006003027836ULL, 0x000fe20000000000ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe400078e0209ULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x000e620000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x0000006d0600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0023f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002071067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000870117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x0000008003027836ULL, 0x000fe20000000000ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe400078e0209ULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x000e620000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x0000006d0600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0023f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002071067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000870117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe200078ef802ULL,
0x000000a003027836ULL, 0x000fe20000000000ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe400078e0209ULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x000e620000000c00ULL,
0x0000000b06057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x0000006d0600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0023f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000002071067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x0000000870117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fe400078ef802ULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000001004077824ULL, 0x000fe400078e0209ULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x000e620000000c00ULL, 0x0000000b06057224ULL, 0x000fca00078e0205ULL,
0x0000000500057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x000000c003067836ULL, 0x000fe40000000000ULL, 0x0000001011047825ULL, 0x000fc600078e0004ULL,
0x00000003ff027819ULL, 0x000fc80000011606ULL, 0x0000006d0200720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0023d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe400078e0202ULL, 0x0000002071027824ULL, 0x000fe400078e0202ULL,
0x000000e003077836ULL, 0x000fe20000000000ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff027c19ULL, 0x000fe20008011602ULL, 0x0000001004047824ULL, 0x000fe200078e0209ULL,
0x00000003ff087819ULL, 0x000fe20000011607ULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000040c7984ULL, 0x0002a20000000c00ULL, 0x0000000b02057224ULL, 0x000fca00078e0205ULL,
0x00000005000a7210ULL, 0x000fe40007f1e0ffULL, 0x0000000706057812ULL, 0x000fe200078ec0ffULL,
0x0000000107047824ULL, 0x002fe400078e0208ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x000000080a027c11ULL, 0x000fe2000f8040ffULL, 0x0000000870057824ULL, 0x000fe200078e0205ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000090a037c11ULL, 0x000fc400080f4403ULL,
0x0000006d0800720cULL, 0x000fe40003f06070ULL, 0xfffffff804047812ULL, 0x000fe200078ef807ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x0043ea000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001004047824ULL, 0x000fe200078e0209ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000002071087824ULL, 0x000fc600078e0208ULL,
0x00000000040c7984ULL, 0x002e620000000c00ULL, 0x0000000870077824ULL, 0x000fe200078e0207ULL,
0x0000000508037c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff087c19ULL, 0x000fc60008011608ULL,
0x0000000176037824ULL, 0x000fc800078e0203ULL, 0x0000000b08037224ULL, 0x000fca00078e0203ULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fc600080f4400ULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00009600ff0c7b82ULL, 0x000e620000000a00ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x0000000217177824ULL, 0x000fe200078e00ffULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x000000060c047981ULL, 0x002322000c1e9900ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x0000004078637824ULL, 0x000fe400078e00ffULL,
0x0000000517027224ULL, 0x000fe400078e0208ULL, 0x01a60006090679a7ULL, 0x0002a4000850003fULL,
0x0000000402057c24ULL, 0x000fe2000f8e0263ULL, 0x0000000c00240947ULL, 0x000fec0003800000ULL,
0x00000003ff377819ULL, 0x000fe2000001160aULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000006361087248ULL, 0x000fc60007fe0000ULL, 0x00000004370f7836ULL, 0x000fe40000000000ULL,
0x0000000837137836ULL, 0x000fe40000000000ULL, 0x000000010f0b7824ULL, 0x140fe400078e020aULL,
0x000000080f0c7824ULL, 0x002fe400078e00ffULL, 0x0000000108087824ULL, 0x000fe400078e0a63ULL,
0x00000001130d7824ULL, 0x040fe200078e020aULL, 0xfffffff80c217812ULL, 0x000fe200078ee20bULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x000000080f00720cULL, 0x000fe20003fa6070ULL,
0x00000001050e7824ULL, 0x000fc400078e020fULL, 0x00000001050c7824ULL, 0x000fe200078e0237ULL,
0xfffffff810237812ULL, 0x000fe200078ee20dULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700e187812ULL, 0x000fc600078ef803ULL,
0x0000001037117836ULL, 0x000fe20000000000ULL, 0x000000700c167812ULL, 0x000fe200078ef803ULL,
0x0000000c37157836ULL, 0x000fe20000000000ULL, 0x0000000418187c10ULL, 0x000fe2000ff3e0ffULL,
0x00000001110c7824ULL, 0x040fe200078e020aULL, 0x0000000416167c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000811277824ULL, 0x000fe200078e00ffULL, 0x000000050f197c10ULL, 0x000fe20008ffe4ffULL,
0x00000001050e7824ULL, 0x040fe200078e0215ULL, 0x000000050d177c10ULL, 0x000fe200087fe4ffULL,
0x00000018372b7836ULL, 0x000fe20000000000ULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x00000001050c7824ULL, 0x000fe200078e0213ULL, 0x000000081500720cULL, 0x080fe20003f46070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000081100720cULL, 0x000fc40003f06070ULL,
0x000000081300720cULL, 0x000fe20003f26070ULL, 0x0000000105147824ULL, 0x000fe200078e022bULL,
0x000000700e1c7812ULL, 0x000fe200078ef803ULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x000000041c1c7c10ULL, 0x000fe2000ff9e0ffULL, 0x00000001150b7824ULL, 0x040fe200078e020aULL,
0x000000700c1a7812ULL, 0x000fe200078ef803ULL, 0x0000000815107824ULL, 0x000fe200078e00ffULL,
0x000000050f1d7c10ULL, 0x000fe2000a7fe4ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000041a1a7c10ULL, 0x000fe4000ff7e0ffULL, 0xfffffff810257812ULL, 0x000fe200078ee20bULL,
0x0000000105117824ULL, 0x000fe200078e0211ULL, 0x0000007014147812ULL, 0x000fe200078ef803ULL,
0x00000014371f7836ULL, 0x000fe20000000000ULL, 0x000000050d1b7c10ULL, 0x000fe20009ffe4ffULL,
0x0000001c372d7836ULL, 0x000fe20000000000ULL, 0x0000000414147c10ULL, 0x000fe2000ff9e0ffULL,
0x0000008011107825ULL, 0x000fc600078e00ffULL, 0x0000000515157c10ULL, 0x000fe2000a7fe4ffULL,
0x0000000105127824ULL, 0x040fe200078e021fULL, 0x0000007010107812ULL, 0x000fe200078ef803ULL,
0x00000001050c7824ULL, 0x000fe200078e022dULL, 0x000000083700720cULL, 0x040fe20003f86070ULL,
0x00000001370e7824ULL, 0x000fe200078e020aULL, 0x0000000410107c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x00004000780b7824ULL, 0x000fe200078e0209ULL, 0x0000007012127812ULL, 0x000fe200078ef803ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0ffffff80f0f7812ULL, 0x000fe400078ef80aULL,
0x0000000511117c10ULL, 0x000fe20009ffe4ffULL, 0x000020000b227836ULL, 0x000fe20000000000ULL,
0x000000700c1e7812ULL, 0x000fe200078ef803ULL, 0x000000011f0b7824ULL, 0x040fe200078e020aULL,
0x0000000412127c10ULL, 0x000fe2000ff7e0ffULL, 0x000000081f0e7824ULL, 0x000fe200078e00ffULL,
0x000000041e1e7c10ULL, 0x000fe2000ffde0ffULL, 0x00000020372f7836ULL, 0x000fe20000000000ULL,
0x0000000513137c10ULL, 0x000fe20009ffe4ffULL, 0x0000002437317836ULL, 0x000fe20000000000ULL,
0xfffffff80e297812ULL, 0x000fe200078ee20bULL, 0x00000001050c7824ULL, 0x000fe200078e022fULL,
0x000000081f00720cULL, 0x000fe20003f66070ULL, 0x000000100f0b7824ULL, 0x000fe200078e0222ULL,
0x000000050d1f7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000001050e7824ULL, 0x000fc400078e0231ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000160b7faeULL, 0x0003e2000e101c46ULL, 0x000000082b00720cULL, 0x000fe40003f86070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c207812ULL, 0x000fc600078ef803ULL,
0x0000002837337836ULL, 0x000fe20000000000ULL, 0x0000000420207c10ULL, 0x000fe2000ffde0ffULL,
0x000000012b0c7824ULL, 0x040fe400078e020aULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x000000700e167812ULL, 0x002fe200078ef803ULL, 0x00000010210b7824ULL, 0x000fe200078e0222ULL,
0x000000050d217c10ULL, 0x000fe2000b7fe4ffULL, 0x000000012d0e7824ULL, 0x000fe200078e020aULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL, 0x0000000105247824ULL, 0x000fe200078e0233ULL,
0x00000000180b7faeULL, 0x0003e2000e901c46ULL, 0x000000082d00720cULL, 0x040fe20003fa6070ULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x0000000416167c10ULL, 0x000fe2000ffde0ffULL,
0x0000001023237824ULL, 0x000fc400078e0222ULL, 0x0000002c37357836ULL, 0x000fe20000000000ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x0000001025257824ULL, 0x100fe200078e0222ULL,
0x000000001a237faeULL, 0x0007e2000c901c46ULL, 0x00000080240c7825ULL, 0x000fe200078e00ffULL,
0x000000050f177c10ULL, 0x000fe4000b7fe4ffULL, 0x000000001c257faeULL, 0x000fe2000d101c46ULL,
0x0000001027277824ULL, 0x000fe200078e0222ULL, 0x000000082f00720cULL, 0x080fe20003f26070ULL,
0x00000001050e7824ULL, 0x000fe200078e0235ULL, 0x000000700c0c7812ULL, 0x000fe200078ef803ULL,
0x000000012f0b7824ULL, 0x102fe200078e020aULL, 0x000000083100720cULL, 0x000fe20003f46070ULL,
0x000000082f247824ULL, 0x000fe200078e00ffULL, 0x0000000010277faeULL, 0x0003e2000c101c46ULL,
0x00000030371b7836ULL, 0x008fe20000000000ULL, 0x000000040c0c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000131187824ULL, 0x040fe200078e020aULL, 0xfffffff8240b7812ULL, 0x000fe200078ee20bULL,
0x0000000831197824ULL, 0x000fe200078e00ffULL, 0x000000050d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee218ULL,
0x0000001029297824ULL, 0x100fe200078e0222ULL, 0x000000700e0e7812ULL, 0x000fe200078ef803ULL,
0x0000000105107824ULL, 0x002fe400078e021bULL, 0x000000102b2b7824ULL, 0x100fe200078e0222ULL,
0x0000000012297faeULL, 0x0003e2000d901c46ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000040e0e7c10ULL, 0x000fe4000ffde0ffULL, 0x00000000142b7faeULL, 0x0007e2000e101c46ULL,
0x000000102d2d7824ULL, 0x100fe200078e0222ULL, 0x000000050f0f7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000034371d7836ULL, 0x004fe20000000000ULL, 0x000000083500720cULL, 0x080fe20003f86070ULL,
0x000000100b0b7824ULL, 0x100fe200078e0222ULL, 0x000000001e2d7faeULL, 0x000fe2000e901c46ULL,
0x0000001019197824ULL, 0x000fe200078e0222ULL, 0x000000083300720cULL, 0x080fe20003fa6070ULL,
0x0000000105127824ULL, 0x002fe200078e021dULL, 0x00000000200b7faeULL, 0x0003e2000c901c46ULL,
0x0000003837237836ULL, 0x000fe20000000000ULL, 0x0000007010147812ULL, 0x008fe200078ef803ULL,
0x0000003c37257836ULL, 0x000fe20000000000ULL, 0x0000000016197faeULL, 0x0005e2000d101c46ULL,
0x0000000133157824ULL, 0x040fe200078e020aULL, 0x0000000414147c10ULL, 0x000fe2000ffde0ffULL,
0x0000000833187824ULL, 0x000fe200078e00ffULL, 0x000000081b00720cULL, 0x080fe20003f66070ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000081d00720cULL, 0x000fc40003f46070ULL,
0x000000082300720cULL, 0x080fe20003f26070ULL, 0x000000011b0b7824ULL, 0x102fe200078e020aULL,
0x000000082500720cULL, 0x000fe20003f06070ULL, 0x0000000105107824ULL, 0x000fe200078e0223ULL,
0xfffffff818177812ULL, 0x004fe200078ee215ULL, 0x000000081b167824ULL, 0x000fe200078e00ffULL,
0x0000000511157c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000135087824ULL, 0x040fe200078e020aULL,
0x0000007012127812ULL, 0x000fe200078ef803ULL, 0x0000000835197824ULL, 0x000fe200078e00ffULL,
0xfffffff8161b7812ULL, 0x000fe200078ee20bULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000412127c10ULL, 0x000fc4000ffde0ffULL, 0xfffffff819197812ULL, 0x000fe200078ee208ULL,
0x00000001050b7824ULL, 0x000fe200078e0225ULL, 0x0000007010107812ULL, 0x000fe200078ef803ULL,
0x000000011d087824ULL, 0x100fe200078e020aULL, 0x0000000513137c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000123167824ULL, 0x100fe200078e020aULL, 0x0000000410107c10ULL, 0x000fe2000ffde0ffULL,
0x0000000125187824ULL, 0x000fe400078e020aULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000000511117c10ULL, 0x000fc6000b7fe4ffULL, 0x000000081d1d7824ULL, 0x000fe200078e00ffULL,
0x000000700a037812ULL, 0x000fe200078ef803ULL, 0x0000000823237824ULL, 0x000fe400078e00ffULL,
0x00000008251f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d057812ULL, 0x000fe200078ee208ULL,
0x0000001017177824ULL, 0x100fe200078e0222ULL, 0xfffffff8231d7812ULL, 0x000fe200078ee216ULL,
0x0000001019197824ULL, 0x100fe200078e0222ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee218ULL,
0x000000101b1b7824ULL, 0x100fe200078e0222ULL, 0x00000004030a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000001005057824ULL, 0x100fe200078e0222ULL, 0x000000000c177faeULL, 0x0003e2000e901c46ULL,
0x000000101d1d7824ULL, 0x100fe200078e0222ULL, 0x000000050b0b7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0222ULL, 0x000000000e197faeULL, 0x0003e8000e101c46ULL,
0x00000000141b7faeULL, 0x0003e8000d901c46ULL, 0x0000000012057faeULL, 0x0003e8000d101c46ULL,
0x00000000101d7faeULL, 0x0003e8000c901c46ULL, 0x000000000a1f7faeULL, 0x0003e2000c101c46ULL,
0x0000000800d47947ULL, 0x000fea0003800000ULL, 0x000000040a0c7811ULL, 0x042fe200078fe8ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x000000140a157811ULL, 0x040fe400078fe8ffULL,
0x000000080a0e7811ULL, 0x000fe200078fe8ffULL, 0x000000010c087824ULL, 0x100fe200078e020aULL,
0x000000100a137811ULL, 0x000fe200078fe8ffULL, 0x000000080c0b7824ULL, 0x000fe200078e00ffULL,
0x000000240a1d7811ULL, 0x040fe200078fe8ffULL, 0x0000000115167824ULL, 0x140fe200078e020aULL,
0x0000000c0a0f7811ULL, 0x000fe200078fe8ffULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0xfffffff80b107812ULL, 0x000fe200078ee208ULL, 0x000000010e087824ULL, 0x100fe200078e020aULL,
0x000000200a1b7811ULL, 0x000fe200078fe8ffULL, 0x000000080e117824ULL, 0x000fe200078e00ffULL,
0xfffffff817167812ULL, 0x000fe200078ee216ULL, 0x00000001130d7824ULL, 0x140fe200078e020aULL,
0x000000180a177811ULL, 0x040fe200078fe8ffULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee208ULL, 0x000000011d1e7824ULL, 0x100fe200078e020aULL,
0x000000280a207811ULL, 0x040fe200078fe8ffULL, 0x0000000117087824ULL, 0x140fe200078e020aULL,
0x0000001c0a197811ULL, 0x040fe200078fe8ffULL, 0x00000008171f7824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x000000300a277811ULL, 0x040fe200078fe8ffULL, 0x000000010f0b7824ULL, 0x140fe200078e020aULL,
0xfffffff81f187812ULL, 0x000fe200078ee208ULL, 0x000000080f127824ULL, 0x000fe200078e00ffULL,
0xfffffff8211e7812ULL, 0x000fe200078ee21eULL, 0x000000011b0d7824ULL, 0x140fe200078e020aULL,
0x0000002c0a257811ULL, 0x000fe200078fe8ffULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x0000000120087824ULL, 0x100fe200078e020aULL,
0x000000340a297811ULL, 0x000fe200078fe8ffULL, 0x0000000820217824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL, 0x00000001190b7824ULL, 0x140fe200078e020aULL,
0x000000380a2b7811ULL, 0x040fe200078fe8ffULL, 0x00000008191a7824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee208ULL, 0x00000001270d7824ULL, 0x140fe200078e020aULL,
0x0000000a0a087211ULL, 0x040fe200078fe8ffULL, 0x0000000827287824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL, 0x00000001250b7824ULL, 0x140fe200078e020aULL,
0x0000003c0a2d7811ULL, 0x000fe200078fe8ffULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee20dULL, 0x00000001291f7824ULL, 0x040fe200078e020aULL,
0x00000007080d7812ULL, 0x000fe200078ec0ffULL, 0x00000008292e7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x0000000105087824ULL, 0x040fe200078e020fULL,
0x000000050a0b7211ULL, 0x000fe200078fe8ffULL, 0x0000000105247824ULL, 0x000fe200078e0220ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee21fULL, 0x000000012b0f7824ULL, 0x000fc400078e020aULL,
0x000000082b207824ULL, 0x000fe400078e00ffULL, 0x00000001050c7824ULL, 0x040fe400078e020cULL,
0x00000001050e7824ULL, 0x040fe400078e020eULL, 0x0000000105137824ULL, 0x040fe400078e0213ULL,
0x0000000105157824ULL, 0x040fe400078e0215ULL, 0x0000000105177824ULL, 0x000fc400078e0217ULL,
0x00000001051f7824ULL, 0x040fe200078e0219ULL, 0xfffffff820197812ULL, 0x000fe200078ee20fULL,
0x0000000105227824ULL, 0x040fe400078e021bULL, 0x0000000105237824ULL, 0x040fe400078e021dULL,
0x0000000105257824ULL, 0x040fe400078e0225ULL, 0x00000001052a7824ULL, 0x040fe400078e0227ULL,
0x00000001052c7824ULL, 0x000fc400078e0229ULL, 0x0000000105307824ULL, 0x040fe400078e022bULL,
0x0000000105327824ULL, 0x000fe200078e022dULL, 0x0ffffff80d057812ULL, 0x000fe200078ef80aULL,
0x000000012d0d7824ULL, 0x000fe400078e020aULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x00004000780f7824ULL, 0x000fe200078e0209ULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x000000082d347824ULL, 0x000fe400078e00ffULL, 0x000020000f477836ULL, 0x000fe20000000000ULL,
0x000000040a0a7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff8341b7812ULL, 0x000fe400078ee20dULL, 0x000000050b0b7c10ULL, 0x000fe200087fe4ffULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x00000010102b7824ULL, 0x100fe200078e0247ULL,
0x000000700c0c7812ULL, 0x000fe200078ef803ULL, 0x00000010112d7824ULL, 0x100fe400078e0247ULL,
0x0000001018357824ULL, 0x100fe200078e0247ULL, 0x000000700e187812ULL, 0x000fe200078ef803ULL,
0x0000008008107825ULL, 0x000fe200078e00ffULL, 0x000000040c0c7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000418187c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010122f7824ULL, 0x100fe200078e0247ULL,
0x000000050d0d7c10ULL, 0x000fe20008ffe4ffULL, 0x0000001014317824ULL, 0x000fc400078e0247ULL,
0x000000101a377824ULL, 0x000fe200078e0247ULL, 0x00000070101a7812ULL, 0x000fe200078ef803ULL,
0x0000008013127825ULL, 0x000fc800078e00ffULL, 0x0000008015147825ULL, 0x000fc800078e00ffULL,
0x0000001019457824ULL, 0x100fe200078e0247ULL, 0x000000050f197c10ULL, 0x000fe200087fe4ffULL,
0x000000101c397824ULL, 0x100fe200078e0247ULL, 0x00000070121c7812ULL, 0x000fe200078ef803ULL,
0x000000101e3b7824ULL, 0x100fe200078e0247ULL, 0x000000041a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001016337824ULL, 0x100fe200078e0247ULL, 0x00000070141e7812ULL, 0x000fe200078ef803ULL,
0x0000001005057824ULL, 0x100fe200078e0247ULL, 0x000000041c1c7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000010213d7824ULL, 0x000fc400078e0247ULL, 0x00000010263f7824ULL, 0x100fe200078e0247ULL,
0x00000005131d7c10ULL, 0x000fe20008ffe4ffULL, 0x0000001028417824ULL, 0x100fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a057faeULL, 0x0003e2000b901c46ULL,
0x000000102e437824ULL, 0x100fe400078e0247ULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x000000000c2b7faeULL, 0x0003e6000b901c46ULL, 0x000000101b477824ULL, 0x000fe200078e0247ULL,
0x00000005111b7c10ULL, 0x000fe200087fe4ffULL, 0x000000801f0e7825ULL, 0x000fe200078e00ffULL,
0x000000041e1e7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000000182d7faeULL, 0x0003e2000b901c46ULL,
0x0000007016207812ULL, 0x000fe200078ef803ULL, 0x0000008022107825ULL, 0x000fe200078e00ffULL,
0x00000005151f7c10ULL, 0x000fe200087fe4ffULL, 0x000000001a2f7faeULL, 0x0003e2000b901c46ULL,
0x000000700e227812ULL, 0x000fe200078ef803ULL, 0x0000008023127825ULL, 0x000fe200078e00ffULL,
0x0000000420207c10ULL, 0x000fe2000ff5e0ffULL, 0x000000001c317faeULL, 0x0003e2000b901c46ULL,
0x0000000422227c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008024147825ULL, 0x000fe200078e00ffULL,
0x0000007010247812ULL, 0x000fe200078ef803ULL, 0x000000001e337faeULL, 0x0003e2000b901c46ULL,
0x0000007012267812ULL, 0x000fc400078ef803ULL, 0x0000000517217c10ULL, 0x000fe200097fe4ffULL,
0x0000008025167825ULL, 0x000fe200078e00ffULL, 0x0000007014287812ULL, 0x000fe400078ef803ULL,
0x0000000424247c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000020357faeULL, 0x0003e2000b901c46ULL,
0x000000050f237c10ULL, 0x000fe200087fe4ffULL, 0x000000802a0e7825ULL, 0x000fe200078e00ffULL,
0x0000000426267c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000428287c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000022377faeULL, 0x0003e2000b901c46ULL, 0x0000000511257c10ULL, 0x000fe20008ffe4ffULL,
0x000000802c107825ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x000fc400078ef803ULL,
0x0000000513277c10ULL, 0x000fe200087fe4ffULL, 0x0000008030127825ULL, 0x000fe200078e00ffULL,
0x0000000515297c10ULL, 0x000fe200097fe4ffULL, 0x0000000024397faeULL, 0x0003e2000b901c46ULL,
0x0000000416167c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008032147825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fe200078ef803ULL, 0x00000000263b7faeULL, 0x0003e2000b901c46ULL,
0x0000007010107812ULL, 0x000fe400078ef803ULL, 0x0000007012127812ULL, 0x000fe200078ef803ULL,
0x00000000283d7faeULL, 0x0003e2000b901c46ULL, 0x0000000517177c10ULL, 0x000fc400087fe4ffULL,
0x0000007014037812ULL, 0x000fe400078ef803ULL, 0x000000040e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000163f7faeULL, 0x0003e2000b901c46ULL, 0x0000000410107c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000412127c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000403147c10ULL, 0x000fe4000ff7e0ffULL,
0x000000050f0f7c10ULL, 0x000fc400087fe4ffULL, 0x0000000511117c10ULL, 0x000fe40008ffe4ffULL,
0x0000000513137c10ULL, 0x000fe200097fe4ffULL, 0x000000000e417faeULL, 0x0003e2000b901c46ULL,
0x0000000515157c10ULL, 0x000fc60009ffe4ffULL, 0x0000000010437faeULL, 0x0003e8000b901c46ULL,
0x0000000012457faeULL, 0x0003e8000b901c46ULL, 0x0000000014477faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01a60007090075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff057224ULL, 0x000fce00078e00ffULL, 0x000000100500780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fce0000015200ULL,
0x0000000c0a087210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e0bULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140cULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060cULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000105057836ULL, 0x000fce0000000000ULL, 0x01a60007090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002078037824ULL, 0x002fc800078e0203ULL, 0x0000000103077836ULL, 0x000fe20000000000ULL,
0x00000004ff057819ULL, 0x000fc80000011603ULL, 0x0ffffffe05067812ULL, 0x000fe400078ec0ffULL,
0x0000001f03057812ULL, 0x000fc600078ec0ffULL, 0x00000001060a7824ULL, 0x000fe400078e0207ULL,
0x0000000103087824ULL, 0x000fe400078e0206ULL, 0x00000010050d7824ULL, 0x040fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000010050b7824ULL, 0x040fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x0000000806067836ULL, 0x000fe20000000000ULL,
0x000001f00d0a7812ULL, 0x000fe200078ee20aULL, 0x0000001005147824ULL, 0x000fe200078e00ffULL,
0x000001f00b087812ULL, 0x000fe200078ee208ULL, 0x0000000103037824ULL, 0x000fc400078e0206ULL,
0x000000100a0a7824ULL, 0x100fe400078e0209ULL, 0x0000001008087824ULL, 0x000fe200078e0209ULL,
0x0000000f03037812ULL, 0x000fe200078ec0ffULL, 0x0000000107067824ULL, 0x000fe200078e0206ULL,
0x000000000a0c7984ULL, 0x000e620000000c00ULL, 0x0000001005167824ULL, 0x000fc600078e00ffULL,
0x0000000008107984ULL, 0x000ea20000000c00ULL, 0x0000000f06057812ULL, 0x000fe400078ec0ffULL,
0x000001f014067812ULL, 0x000fe400078ee203ULL, 0x000001f016147812ULL, 0x000fc600078ee205ULL,
0x0000001006067824ULL, 0x100fe400078e0209ULL, 0x0000001014147824ULL, 0x000fe400078e0209ULL,
0x000000ffff1a7224ULL, 0x002fe400078e000cULL, 0x000000ffff1b7224ULL, 0x000fe400078e000eULL,
0x000000ffff187224ULL, 0x004fe400078e0010ULL, 0x000000ffff197224ULL, 0x000fc400078e0012ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fe200078e000fULL,
0x0000001808007388ULL, 0x000fe20000000c00ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fca00078e0013ULL, 0x0000001c0a007388ULL, 0x000fe80000000c00ULL,
0x00000000140c7984ULL, 0x000e680000000c00ULL, 0x0000000006107984ULL, 0x000ea20000000c00ULL,
0x000000ffff227224ULL, 0x002fe400078e000cULL, 0x000000ffff237224ULL, 0x000fc400078e000eULL,
0x000000ffff207224ULL, 0x004fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fe400078e0012ULL,
0x000000ffff267224ULL, 0x000fe400078e000dULL, 0x000000ffff277224ULL, 0x000fe200078e000fULL,
0x0000002006007388ULL, 0x0003e20000000c00ULL, 0x000000ffff247224ULL, 0x000fe400078e0011ULL,
0x000000ffff257224ULL, 0x000fc400078e0013ULL, 0x00000001ff0c7424ULL, 0x000fc600078e00ffULL,
0x0000002414007388ULL, 0x0003e60000000c00ULL, 0x01a6000c090c79a7ULL, 0x0002a4000850003fULL,
0x0000000000067805ULL, 0x002fce0000015200ULL, 0x01a6000d090075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff057224ULL, 0x000fce00078e00ffULL,
0x000000100500780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a06087210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140aULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e060aULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000105057836ULL, 0x000fce0000000000ULL,
0x01a6000d090075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff5b00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x0000010063637836ULL, 0x000fe20000000000ULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x8000000961077c36ULL, 0x000fe40008000000ULL, 0x3db504f304047820ULL, 0x010fe20000410000ULL,
0x00000008785a7824ULL, 0x140fe200078e0209ULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x0000002078597824ULL, 0x000fe200078e0209ULL, 0x00000008ff077819ULL, 0x000fe20000011607ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0xffffffff09057890ULL, 0x000fe2000fffe03fULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000000909087890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fd8000f8ec03fULL, 0x0000000206087836ULL, 0x008fe20000000000ULL,
0x0000920000097ab9ULL, 0x000fe20000000800ULL, 0x00000001050a7812ULL, 0x000fc600078e0cffULL,
0x0000005b0800720cULL, 0x000fe20003f06070ULL, 0x0000010006087824ULL, 0x000fc800078e0263ULL,
0x00000009020c7c24ULL, 0x000fd0000f8e0208ULL, 0x0000000c00308947ULL, 0x000fea0003800000ULL,
0x00000003ff2d7819ULL, 0x002fe20000011603ULL, 0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000008610b7248ULL, 0x000fc60007fe0000ULL, 0x000000042d0f7836ULL, 0x000fe40000000000ULL,
0x000000082d137836ULL, 0x000fe40000000000ULL, 0x000000010f0d7824ULL, 0x140fe400078e0203ULL,
0x000000080f267824ULL, 0x000fe400078e00ffULL, 0x00000001130e7824ULL, 0x040fe400078e0203ULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20dULL,
0x000000010b247824ULL, 0x000fc400078e0a08ULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0xfffffff811287812ULL, 0x000fe200078ee20eULL, 0x000000012d0e7824ULL, 0x100fe200078e020cULL,
0x000000240f00720cULL, 0x040fe20003fa6070ULL, 0x000000010f107824ULL, 0x000fe200078e020cULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000102d177836ULL, 0x000fe20000000000ULL, 0x0000000d0e1c7212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000001170e7824ULL, 0x140fe200078e0203ULL, 0x0000000d10147212ULL, 0x000fe200078efcffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0x0000000b0f1d7c10ULL, 0x000fe200087fe4ffULL,
0x0000000c2d0b7836ULL, 0x000fe20000000000ULL, 0x0000000a14147c10ULL, 0x000fe2000ff3e0ffULL,
0x000000142d217836ULL, 0x000fe20000000000ULL, 0xfffffff8192c7812ULL, 0x000fe200078ee20eULL,
0x000000010b127824ULL, 0x000fe200078e0203ULL, 0x000000241700720cULL, 0x080fe20003f06070ULL,
0x000000080b157824ULL, 0x040fe200078e00ffULL, 0x000000240b00720cULL, 0x000fe20003f46070ULL,
0x00000001130e7824ULL, 0x000fc400078e020cULL, 0x000000010b107824ULL, 0x100fe200078e020cULL,
0xfffffff8152a7812ULL, 0x000fe200078ee212ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000b11157c10ULL, 0x000fe40008ffe4ffULL, 0x000000241300720cULL, 0x000fe20003f26070ULL,
0x0000000117127824ULL, 0x000fe200078e020cULL, 0x0000000d0e187212ULL, 0x000fe200078efcffULL,
0x000000182d237836ULL, 0x000fe40000000000ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000a18187c10ULL, 0x000fc6000ff7e0ffULL, 0x0000000121167824ULL, 0x100fe200078e020cULL,
0x0000000d101e7212ULL, 0x080fe200078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b0f197c10ULL, 0x000fe40009ffe4ffULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ff9e0ffULL,
0x00000001231a7824ULL, 0x000fe200078e020cULL, 0x0000000d120e7212ULL, 0x080fe200078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000b111f7c10ULL, 0x000fe4000a7fe4ffULL,
0x0000000a0e0e7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000d16107212ULL, 0x000fc400078efcffULL, 0x0000000b130f7c10ULL, 0x000fe20009ffe4ffULL,
0x0000001c2d2b7836ULL, 0x000fe20000000000ULL, 0x0000000d1a167212ULL, 0x000fe200078efcffULL,
0x00004000780b7824ULL, 0x000fe200078e0209ULL, 0x0000000a10107c10ULL, 0x000fe2000ff9e0ffULL,
0x000000012b127824ULL, 0x000fe200078e020cULL, 0x0000000a16167c10ULL, 0x000fe2000ff7e0ffULL,
0x000020000a1a7824ULL, 0x000fe200078e020bULL, 0x0000000b17117c10ULL, 0x000fe2000a7fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000b1b177c10ULL, 0x000fc40009ffe4ffULL,
0x000000242d00720cULL, 0x0c0fe20003f86070ULL, 0x000000012d1b7824ULL, 0x100fe200078e0203ULL,
0x0000000d12207212ULL, 0x000fe200078efcffULL, 0x000020001a257836ULL, 0x000fe20000000000ULL,
0x000000242100720cULL, 0x000fe20003f66070ULL, 0x000000202d2f7836ULL, 0x000fe20000000000ULL,
0x000000071b227812ULL, 0x000fe200078ec0ffULL, 0x00000001211a7824ULL, 0x040fe200078e0203ULL,
0x0000000a20207c10ULL, 0x000fe2000ffde0ffULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x0ffffff822227812ULL, 0x000fe200078ef803ULL, 0x000000012f127824ULL, 0x000fc400078e020cULL,
0x000000242d317836ULL, 0x000fe20000000000ULL, 0xfffffff8212e7812ULL, 0x000fe200078ee21aULL,
0x0000001022277824ULL, 0x000fe200078e0225ULL, 0x0000000b13217c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c277faeULL, 0x0003e2000e101c46ULL, 0x00000001311a7824ULL, 0x000fe200078e020cULL,
0x0000000d12227212ULL, 0x000fe200078efcffULL, 0x000000282d337836ULL, 0x000fe20000000000ULL,
0x000000242300720cULL, 0x000fe20003f86070ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000a22227c10ULL, 0x000fc6000ffde0ffULL, 0x0000000133127824ULL, 0x000fe200078e020cULL,
0x0000000d1a1a7212ULL, 0x000fe200078efcffULL, 0x0000002c2d357836ULL, 0x000fe40000000000ULL,
0x00000010261d7824ULL, 0x102fe400078e0225ULL, 0x0000001028277824ULL, 0x000fe400078e0225ULL,
0x000000012f267824ULL, 0x100fe200078e0203ULL, 0x00000000141d7faeULL, 0x0003e2000e901c46ULL,
0x0000000123297824ULL, 0x000fe200078e0203ULL, 0x000000242b00720cULL, 0x080fe20003fa6070ULL,
0x0000000823307824ULL, 0x000fe200078e00ffULL, 0x0000000018277faeULL, 0x0005e2000c901c46ULL,
0x000000242f00720cULL, 0x040fe20003f26070ULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x0000000b13237c10ULL, 0x000fe2000b7fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fc400078ee229ULL, 0xfffffff82f267812ULL, 0x000fe200078ee226ULL,
0x000000102a1d7824ULL, 0x102fe200078e0225ULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000135147824ULL, 0x000fe200078e020cULL, 0x0000000d12127212ULL, 0x000fe200078efcffULL,
0x000000102c197824ULL, 0x004fe200078e0225ULL, 0x000000001e1d7faeULL, 0x0003e2000d101c46ULL,
0x000000302d2f7836ULL, 0x000fe20000000000ULL, 0x000000243100720cULL, 0x000fe20003f46070ULL,
0x000000012b1c7824ULL, 0x100fe200078e0203ULL, 0x000000000e197faeULL, 0x0005e2000c101c46ULL,
0x0000000131287824ULL, 0x000fe200078e0203ULL, 0x0000000b1b1b7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL,
0x0000000831317824ULL, 0x000fc400078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff82b1c7812ULL, 0x000fe400078ee21cULL, 0xfffffff831287812ULL, 0x000fe200078ee228ULL,
0x000000102e1d7824ULL, 0x102fe200078e0225ULL, 0x0000000d14147212ULL, 0x000fe200078efcffULL,
0x000000012f0e7824ULL, 0x044fe200078e020cULL, 0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL,
0x00000010301f7824ULL, 0x000fe200078e0225ULL, 0x00000000101d7faeULL, 0x0003e2000d901c46ULL,
0x000000342d317836ULL, 0x000fe20000000000ULL, 0x0000000a14147c10ULL, 0x000fe2000ffde0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000000161f7faeULL, 0x0005e2000e101c46ULL,
0x000000242f00720cULL, 0x000fc40003f66070ULL, 0x000000101c277824ULL, 0x100fe200078e0225ULL,
0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001026297824ULL, 0x100fe200078e0225ULL,
0x000000243500720cULL, 0x080fe20003f86070ULL, 0x00000010282b7824ULL, 0x000fe200078e0225ULL,
0x0000000020277faeULL, 0x0007e2000e901c46ULL, 0x0000000131107824ULL, 0x002fe200078e020cULL,
0x000000243300720cULL, 0x040fe20003fa6070ULL, 0x0000000833187824ULL, 0x040fe200078e00ffULL,
0x0000000d0e167212ULL, 0x004fe200078efcffULL, 0x0000000133177824ULL, 0x000fe200078e0203ULL,
0x0000000022297faeULL, 0x000fe2000c901c46ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fc4000ffde0ffULL, 0x000000001a2b7faeULL, 0x0003e2000d101c46ULL,
0x000000382d1d7836ULL, 0x000fe20000000000ULL, 0x000000243100720cULL, 0x080fe20003f46070ULL,
0x00000008351c7824ULL, 0x000fe400078e00ffULL, 0x000000011d0e7824ULL, 0x040fe200078e020cULL,
0x000000241d00720cULL, 0x080fe20003f26070ULL, 0x0000003c2d2d7836ULL, 0x000fe40000000000ULL,
0x0000000831207824ULL, 0x008fe400078e00ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8181a7812ULL, 0x002fe200078ee217ULL, 0x00000001311b7824ULL, 0x100fe200078e0203ULL,
0x0000000b0f177c10ULL, 0x000fe2000b7fe4ffULL, 0x00000001350f7824ULL, 0x100fe200078e0203ULL,
0x0000000d10187212ULL, 0x000fe200078efcffULL, 0x000000012f107824ULL, 0x000fe200078e0203ULL,
0x000000242d00720cULL, 0x000fe20003f06070ULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000a18187c10ULL, 0x000fc4000ffde0ffULL, 0xfffffff82f1e7812ULL, 0x000fe200078ee210ULL,
0x000000012d107824ULL, 0x000fe200078e020cULL, 0x0000000b11197c10ULL, 0x000fe2000b7fe4ffULL,
0x000000011d0c7824ULL, 0x100fe200078e0203ULL, 0x0000000d0e0e7212ULL, 0x080fe200078efcffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe400078ee21bULL,
0x0000000a0e0e7c10ULL, 0x000fe2000ffde0ffULL, 0x000000012d1d7824ULL, 0x040fe200078e0203ULL,
0x0000000d100d7212ULL, 0x000fe200078efcffULL, 0x000000082d247824ULL, 0x000fe200078e00ffULL,
0xfffffff81f227812ULL, 0x000fe200078ee20cULL, 0x000000101a1b7824ULL, 0x100fe200078e0225ULL,
0x0000000b0f0f7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000101e1f7824ULL, 0x100fe200078e0225ULL,
0xfffffff824247812ULL, 0x000fe200078ee21dULL, 0x000000101c1d7824ULL, 0x100fe200078e0225ULL,
0x0000000a0d0c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000001020217824ULL, 0x100fe200078e0225ULL,
0x00000000121b7faeULL, 0x0003e2000e901c46ULL, 0x0000001022237824ULL, 0x100fe200078e0225ULL,
0x0000000b110d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001024257824ULL, 0x000fe200078e0225ULL,
0x00000000141d7faeULL, 0x0003e8000e101c46ULL, 0x00000000161f7faeULL, 0x0003e8000d901c46ULL,
0x0000000018217faeULL, 0x0003e8000d101c46ULL, 0x000000000e237faeULL, 0x0003e8000c901c46ULL,
0x000000000c257faeULL, 0x0003e2000c101c46ULL, 0x0000000800e07947ULL, 0x000fea0003800000ULL,
0x00000004030e7811ULL, 0x042fe200078fe8ffULL, 0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000803107811ULL, 0x040fe400078fe8ffULL, 0x0000000c03127811ULL, 0x040fe200078fe8ffULL,
0x000000010e0b7824ULL, 0x140fe200078e0203ULL, 0x0000001003147811ULL, 0x040fe200078fe8ffULL,
0x000000080e207824ULL, 0x000fe200078e00ffULL, 0x0000001403167811ULL, 0x040fe200078fe8ffULL,
0x00000001100d7824ULL, 0x140fe200078e0203ULL, 0x0000001c031a7811ULL, 0x040fe200078fe8ffULL,
0x0000000810227824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x00000001120b7824ULL, 0x140fe200078e0203ULL, 0x0000001803187811ULL, 0x040fe200078fe8ffULL,
0x0000000812267824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20dULL,
0x00000001140d7824ULL, 0x140fe200078e0203ULL, 0x00000020031b7811ULL, 0x040fe200078fe8ffULL,
0x0000000814287824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20bULL,
0x00000001160f7824ULL, 0x140fe200078e0203ULL, 0x00000024031c7811ULL, 0x040fe200078fe8ffULL,
0x00000008162a7824ULL, 0x000fe200078e00ffULL, 0x0000002c03247811ULL, 0x040fe200078fe8ffULL,
0x000000011a0b7824ULL, 0x140fe200078e0203ULL, 0xfffffff828287812ULL, 0x000fe200078ee20dULL,
0x000000081a367824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20fULL,
0x0000000118117824ULL, 0x140fe200078e0203ULL, 0x00000028031d7811ULL, 0x000fe200078fe8ffULL,
0x0000000818347824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee20bULL,
0x000000011b0d7824ULL, 0x100fe200078e0203ULL, 0x00000030032c7811ULL, 0x000fe200078fe8ffULL,
0x000000081b387824ULL, 0x000fe200078e00ffULL, 0x00000034032e7811ULL, 0x040fe200078fe8ffULL,
0x000000011c0f7824ULL, 0x140fe200078e0203ULL, 0xfffffff834347812ULL, 0x000fe200078ee211ULL,
0x000000081c3a7824ULL, 0x000fe200078e00ffULL, 0x0000003c03327811ULL, 0x000fe200078fe8ffULL,
0x00000001240b7824ULL, 0x140fe200078e0203ULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x00000008243e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL,
0x000000011d117824ULL, 0x100fe200078e0203ULL, 0x0000003803307811ULL, 0x000fe200078fe8ffULL,
0x000000081d3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20bULL,
0x000000012c0d7824ULL, 0x000fc400078e0203ULL, 0x000000082c407824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x000000012e0f7824ULL, 0x140fe400078e0203ULL,
0x000000082e427824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee20dULL,
0x00000001320b7824ULL, 0x140fe200078e0203ULL, 0x00000003030d7211ULL, 0x000fe200078fe8ffULL,
0x0000000832467824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee20fULL,
0x0000000130117824ULL, 0x040fe200078e0203ULL, 0x000000070d1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000830447824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee20bULL,
0x000000010e0e7824ULL, 0x100fe200078e020cULL, 0x0ffffff81e1e7812ULL, 0x000fe200078ef803ULL,
0x0000000110107824ULL, 0x100fe200078e020cULL, 0xfffffff844447812ULL, 0x000fe200078ee211ULL,
0x0000000112127824ULL, 0x000fc400078e020cULL, 0x0000000114147824ULL, 0x100fe400078e020cULL,
0x0000000116167824ULL, 0x100fe400078e020cULL, 0x0000000118187824ULL, 0x100fe400078e020cULL,
0x000000011a1a7824ULL, 0x100fe400078e020cULL, 0x000000011b1b7824ULL, 0x100fe400078e020cULL,
0x000000011c1c7824ULL, 0x000fc400078e020cULL, 0x000000011d1d7824ULL, 0x100fe400078e020cULL,
0x0000000124247824ULL, 0x100fe400078e020cULL, 0x000000012c2c7824ULL, 0x100fe400078e020cULL,
0x000000012e2e7824ULL, 0x100fe400078e020cULL, 0x0000000130307824ULL, 0x100fe400078e020cULL,
0x0000000132327824ULL, 0x000fe200078e020cULL, 0x0000000c030c7211ULL, 0x040fe200078fe8ffULL,
0x00000010030f7824ULL, 0x000fc400078e00ffULL, 0x00004000780b7824ULL, 0x000fe400078e0209ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700f4d7812ULL, 0x000fc600078ec0ffULL,
0x000020000a0f7824ULL, 0x000fe200078e020bULL, 0x0000004d0c0c7212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000a0c0c7c10ULL, 0x000fe2000ff1e0ffULL,
0x000020000f4b7836ULL, 0x000fe20000000000ULL, 0x0000004d10107212ULL, 0x080fe200078efcffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000b0d0d7c10ULL, 0x000fe400087fe4ffULL,
0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004d0e0e7212ULL, 0x000fe400078efcffULL, 0x0000000b11117c10ULL, 0x000fe200087fe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fc4000ff3e0ffULL,
0x0000004d12127212ULL, 0x080fe200078efcffULL, 0x000000101e2d7824ULL, 0x100fe200078e024bULL,
0x0000004d141e7212ULL, 0x080fe200078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000b0f0f7c10ULL, 0x000fe40008ffe4ffULL, 0x0000000a12127c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c2d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b13137c10ULL, 0x000fe200087fe4ffULL, 0x00000010202f7824ULL, 0x100fe200078e024bULL,
0x0000004d16207212ULL, 0x080fe200078efcffULL, 0x0000001022317824ULL, 0x100fe200078e024bULL,
0x0000004d18227212ULL, 0x080fe200078efcffULL, 0x0000001026337824ULL, 0x100fe200078e024bULL,
0x0000000a20207c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001028357824ULL, 0x000fe200078e024bULL,
0x0000000b151f7c10ULL, 0x000fe20008ffe4ffULL, 0x000000801a147825ULL, 0x000fe200078e00ffULL,
0x0000000a22227c10ULL, 0x000fe2000ff5e0ffULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000b17217c10ULL, 0x000fe200087fe4ffULL, 0x000000801b167825ULL, 0x000fe200078e00ffULL,
0x0000000b19237c10ULL, 0x000fe200097fe4ffULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x0000004d14257212ULL, 0x080fe200078efcffULL, 0x000000801c187825ULL, 0x000fe200078e00ffULL,
0x0000004d16267212ULL, 0x080fe200078efcffULL, 0x0000000012337faeULL, 0x0003e4000b901c46ULL,
0x000000801d1a7825ULL, 0x000fe200078e00ffULL, 0x0000004d18287212ULL, 0x000fe200078efcffULL,
0x000000001e357faeULL, 0x0003e2000b901c46ULL, 0x0000000a26267c10ULL, 0x000fe2000ff3e0ffULL,
0x00000080241c7825ULL, 0x000fe200078e00ffULL, 0x0000000a25247c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000b17277c10ULL, 0x000fe20008ffe4ffULL, 0x000000102a377824ULL, 0x100fe200078e024bULL,
0x0000004d1a2a7212ULL, 0x080fe200078efcffULL, 0x000000802e167825ULL, 0x000fe200078e00ffULL,
0x0000000b15257c10ULL, 0x000fe400087fe4ffULL, 0x0000000a28287c10ULL, 0x000fe2000ff1e0ffULL,
0x000000802c147825ULL, 0x000fe200078e00ffULL, 0x0000000a2a2a7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000020377faeULL, 0x0003e2000b901c46ULL, 0x0000004d1c1c7212ULL, 0x000fe200078efcffULL,
0x0000001034397824ULL, 0x000fe200078e024bULL, 0x0000000b19297c10ULL, 0x000fe200087fe4ffULL,
0x0000008030187825ULL, 0x000fe200078e00ffULL, 0x0000000b1b2b7c10ULL, 0x000fc400097fe4ffULL,
0x0000000a1c1c7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000080321a7825ULL, 0x000fe200078e00ffULL,
0x0000004d14147212ULL, 0x080fe200078efcffULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x0000004d16167212ULL, 0x080fe200078efcffULL, 0x00000010363b7824ULL, 0x100fe200078e024bULL,
0x0000004d18187212ULL, 0x080fe200078efcffULL, 0x00000010383d7824ULL, 0x100fe200078e024bULL,
0x0000000b1d1d7c10ULL, 0x000fe200087fe4ffULL, 0x000000103a3f7824ULL, 0x100fe200078e024bULL,
0x0000004d1a1a7212ULL, 0x000fe200078efcffULL, 0x000000103c417824ULL, 0x100fe200078e024bULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x000000103e437824ULL, 0x100fe200078e024bULL,
0x0000000a16167c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001040457824ULL, 0x100fe200078e024bULL,
0x0000000a18187c10ULL, 0x000fe2000ff5e0ffULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001042477824ULL, 0x100fe200078e024bULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x00000000263d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b17177c10ULL, 0x000fe20008ffe4ffULL, 0x0000001044497824ULL, 0x100fe200078e024bULL,
0x0000000b19197c10ULL, 0x000fe200097fe4ffULL, 0x00000000283f7faeULL, 0x0003e2000b901c46ULL,
0x00000010464b7824ULL, 0x000fe200078e024bULL, 0x0000000b1b1b7c10ULL, 0x000fc40009ffe4ffULL,
0x000000002a417faeULL, 0x0003e8000b901c46ULL, 0x000000001c437faeULL, 0x0003e8000b901c46ULL,
0x0000000014457faeULL, 0x0003e8000b901c46ULL, 0x0000000016477faeULL, 0x0003e8000b901c46ULL,
0x0000000018497faeULL, 0x0003e8000b901c46ULL, 0x000000001a4b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff587224ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x002fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fc4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fe4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fc4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fcc0000000000ULL, 0xfffffff803147812ULL, 0x000fe200078ec0ffULL,
0x0000200005607824ULL, 0x000fe200078e020bULL, 0x00000004ff197819ULL, 0x000fe20000011603ULL,
0x0000000158627836ULL, 0x000fe20000000000ULL, 0x0000000714157812ULL, 0x000fe200078ef803ULL,
0x0000200060607836ULL, 0x000fe20000000000ULL, 0x0000000803167812ULL, 0x000fe200078ec0ffULL,
0x0000002003187836ULL, 0x000fe40000000000ULL, 0x0000000115147824ULL, 0x040fe200078e0258ULL,
0x00000007161a7812ULL, 0x000fe200078ef803ULL, 0x0000000815177824ULL, 0x040fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ec0ffULL, 0x0000000115167824ULL, 0x040fe200078e0262ULL,
0x000000101a6c7812ULL, 0x040fe200078efcffULL, 0x000000101a1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee214ULL, 0x0000000258147824ULL, 0x000fe200078e0219ULL,
0x0000000718737812ULL, 0x000fe200078ef803ULL, 0x0000000815197824ULL, 0x000fc400078e00ffULL,
0x0000001017177824ULL, 0x000fe400078e0260ULL, 0x000000011a157824ULL, 0x000fe400078e0214ULL,
0x000000106c187824ULL, 0x000fe200078e00ffULL, 0x000000001764783bULL, 0x0002a20000000200ULL,
0x000000101a1b7824ULL, 0x000fe400078e00ffULL, 0x0000000173627824ULL, 0x000fe200078e0262ULL,
0xfffffff819177812ULL, 0x002fe200078ee216ULL, 0x0000000214197836ULL, 0x000fe20000000000ULL,
0xfffffff01c167812ULL, 0x000fe200078ee215ULL, 0x000000016c157824ULL, 0x000fc400078e0214ULL,
0x0000001017687824ULL, 0x000fe400078e0260ULL, 0x000000011a1a7824ULL, 0x000fe200078e0219ULL,
0xfffffff018187812ULL, 0x000fe200078ee215ULL, 0x0000000173177824ULL, 0x040fe400078e0258ULL,
0x000000006868783bULL, 0x000e620000000200ULL, 0x00000008731c7824ULL, 0x000fe200078e00ffULL,
0xfffffff01b1a7812ULL, 0x000fe200078ee21aULL, 0x0000001016167824ULL, 0x100fe400078e0209ULL,
0x0000001018187824ULL, 0x000fe200078e0209ULL, 0xfffffff81c177812ULL, 0x000fe200078ee217ULL,
0x000000016c197824ULL, 0x040fe200078e0219ULL, 0x00000000165c783bULL, 0x000ee20000000200ULL,
0x000000106c6c7824ULL, 0x000fc400078e00ffULL, 0x0000000873737824ULL, 0x000fe200078e00ffULL,
0x00000000181c783bULL, 0x0009620000000200ULL, 0x000000101a1a7824ULL, 0x000fe400078e0209ULL,
0x0000000258587836ULL, 0x000fe20000000000ULL, 0xfffffff06c187812ULL, 0x010fe200078ee219ULL,
0x00000010176c7824ULL, 0x000fe200078e0260ULL, 0x00000010ff147819ULL, 0x104fe40000011667ULL,
0x00000018ff157819ULL, 0x000fe40000011667ULL, 0x000000ff14147812ULL, 0x000fe200078ec0ffULL,
0x000000006c6c783bULL, 0x000ea20000000200ULL, 0x00000015ff15723eULL, 0x000fc400020006ffULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x0000ffff671b7812ULL, 0x040fe200078ec0ffULL,
0x20000015ff167230ULL, 0x000fe20000004100ULL, 0x000000ff67677812ULL, 0x000fe200078ec0ffULL,
0x20000014ff157230ULL, 0x000fe20000004100ULL, 0x00000008ff147819ULL, 0x000fe4000001161bULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fc400020006ffULL,
0x0000ffff6b757812ULL, 0x002fe200078ec0ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe20000011616ULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe40000011615ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff707819ULL, 0x000fe40000011614ULL, 0x0000105416717816ULL, 0x000fe20000000015ULL,
0x0000001018157824ULL, 0x000fe200078e0209ULL, 0x0000105470707816ULL, 0x000fe20000000067ULL,
0x000000001a18783bULL, 0x000e620000000200ULL, 0x00000018ff677819ULL, 0x000fc4000001166bULL,
0x000000ff69967812ULL, 0x000fe200078ec0ffULL, 0x000000001514783bULL, 0x000f220000000200ULL,
0x00000067ff72723eULL, 0x000fe200020006ffULL, 0x000000705c10723cULL, 0x008fe20000041810ULL,
0x00000010ff677819ULL, 0x000fe4000001166bULL, 0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL,
0x20000072ff747230ULL, 0x000fe20000004100ULL, 0x000000ff67727812ULL, 0x000fe200078ec0ffULL,
0x000000701c0c723cULL, 0x020fe2000004180cULL, 0x00000008ff677819ULL, 0x000fc40000011675ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000010ff757819ULL, 0x000fe20000011674ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000067ff707230ULL, 0x000fe20000004100ULL,
0xfffffff873677812ULL, 0x000fe400078ee262ULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe20000011670ULL,
0x0000001067707824ULL, 0x000fe200078e0260ULL, 0x0000105475757816ULL, 0x000fc40000000072ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff8d7819ULL, 0x004fe2000001166cULL,
0x000000007070783bULL, 0x000ea20000000200ULL, 0x0000105462747816ULL, 0x000fe4000000006bULL,
0x00000018ff6b7819ULL, 0x000fe40000011668ULL, 0x00000018ff677819ULL, 0x000fe4000001166cULL,
0x000000ff6c777812ULL, 0x040fe200078ec0ffULL, 0x000000741810723cULL, 0x002fe20000041810ULL,
0x0000ffff6c947812ULL, 0x000fc400078ec0ffULL, 0x000000ff686c7812ULL, 0x000fe400078ec0ffULL,
0x0000006bff8e723eULL, 0x000fe200020006ffULL, 0x00000074140c723cULL, 0x010fe2000004180cULL,
0x000000ff64627812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6b723eULL, 0x000fe200020006ffULL,
0x2000008eff6c7230ULL, 0x000fe20000004100ULL, 0x00000018ff607819ULL, 0x100fe40000011664ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fc40000011664ULL, 0x00000010ff927819ULL, 0x100fe4000001166eULL,
0x00000018ff897819ULL, 0x000fe4000001166eULL, 0x000000ff6e887812ULL, 0x040fe400078ec0ffULL,
0x0000ffff6e8f7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff64647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff907819ULL, 0x000fc4000001166fULL, 0x00000018ff757819ULL, 0x000fe4000001166fULL,
0x000000ff6f6e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff6f917812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001166aULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff6f7819ULL, 0x000fc40000011668ULL, 0x00000010ff797819ULL, 0x104fe40000011671ULL,
0x00000018ff867819ULL, 0x000fe40000011671ULL, 0x000000ff71857812ULL, 0x040fe400078ec0ffULL,
0x0000ffff717c7812ULL, 0x000fe200078ec0ffULL, 0x20000062ff717230ULL, 0x000fe20000004100ULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff957819ULL, 0x000fc40000011669ULL,
0x000000ff6a8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x100fe4000001166dULL,
0x00000018ff7b7819ULL, 0x000fe4000001166dULL, 0x000000ff6d877812ULL, 0x040fe400078ec0ffULL,
0x0000ffff6d937812ULL, 0x000fe400078ec0ffULL, 0x00000096ff62723eULL, 0x000fc400020006ffULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff7e7819ULL, 0x100fe20000011670ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000018ff847819ULL, 0x000fe40000011670ULL,
0x000000ff70837812ULL, 0x040fe400078ec0ffULL, 0x0000ffff706d7812ULL, 0x000fe200078ec0ffULL,
0x20000060ff707230ULL, 0x000fe20000004100ULL, 0x0000008aff96723eULL, 0x000fc400020006ffULL,
0x0000ffff687a7812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL, 0x00000095ff60723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000064ff95723eULL, 0x000fe200020006ffULL,
0x20000096ff647230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x2000008eff967230ULL, 0x000fe20000004100ULL, 0x00000067ff8a723eULL, 0x000fe200020006ffULL,
0x2000008bff677230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe2000001167aULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x2000007bff8b7230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000008aff8e7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000007aff7b723eULL, 0x000fe200020006ffULL,
0x2000006fff7a7230ULL, 0x000fe20000004100ULL, 0x00000088ff8a723eULL, 0x000fe200020006ffULL,
0x20000087ff887230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x2000006eff877230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe20000011670ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe20000011696ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fc40000011671ULL,
0x00000010ff957819ULL, 0x000fe40000011695ULL, 0x0000008dff71723eULL, 0x000fe400020006ffULL,
0x00001054706f7816ULL, 0x000fe4000000006fULL, 0x000000ff8c707812ULL, 0x000fe200078ec0ffULL,
0x20000071ff8c7230ULL, 0x000fe20000004100ULL, 0x00001054956e7816ULL, 0x000fe4000000006eULL,
0x00000008ff947819ULL, 0x000fc40000011694ULL, 0x00000070ff71723eULL, 0x000fe400020006ffULL,
0x00000094ff8d723eULL, 0x000fe200020006ffULL, 0x0000006e5c54723cULL, 0x000fe20000041854ULL,
0x00000018ff707819ULL, 0x000fe40000011665ULL, 0x00000008ff947819ULL, 0x000fe20000011693ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff92937812ULL, 0x000fe200078ec0ffULL,
0x0000006e1c50723cULL, 0x000fe20000041850ULL, 0x20000071ff927230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fc400020006ffULL, 0x00000018ff717819ULL, 0x000fe40000011666ULL,
0x0000ffff65977812ULL, 0x040fe400078ec0ffULL, 0x000000ff656f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x000fe20000011665ULL, 0x20000070ff657230ULL, 0x000fe20000004100ULL,
0x000000ff66967812ULL, 0x000fe400078ec0ffULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x000000ff6e707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff957819ULL, 0x000fe40000011666ULL, 0x0000ffff66987812ULL, 0x000fe200078ec0ffULL,
0x2000006fff667230ULL, 0x000fe20000004100ULL, 0x00000096ff96723eULL, 0x000fe200020006ffULL,
0x20000071ff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fc40000011697ULL,
0x00000070ff71723eULL, 0x000fe400020006ffULL, 0x0000006eff70723eULL, 0x000fe200020006ffULL,
0x20000096ff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff95967812ULL, 0x000fe200078ec0ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff957819ULL, 0x000fe20000011698ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000096ff97723eULL, 0x000fe400020006ffULL,
0x00000095ff95723eULL, 0x000fc400020006ffULL, 0x00000010ff967819ULL, 0x000fe20000011665ULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff657819ULL, 0x000fe40000011670ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x0000105465707816ULL, 0x000fe20000000066ULL, 0x20000094ff657230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fc400020006ffULL, 0x0000105496717816ULL, 0x000fe40000000071ULL,
0x00000008ff8f7819ULL, 0x000fe2000001168fULL, 0x20000093ff667230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000000ff90967812ULL, 0x000fe200078ec0ffULL,
0x000000705c4c723cULL, 0x000fe2000004184cULL, 0x00000010ff947819ULL, 0x000fe2000001166fULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000008ff917819ULL, 0x000fc40000011691ULL,
0x00000010ff6f7819ULL, 0x000fe20000011697ULL, 0x000000701c48723cULL, 0x000fe20000041848ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x0000008fff90723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000090ff707230ULL, 0x000fe20000004100ULL,
0x00000096ff8f723eULL, 0x000fe200020006ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff767819ULL, 0x000fe2000001166aULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000091ff93723eULL, 0x000fe200020006ffULL, 0x2000008fff917230ULL, 0x000fe20000004100ULL,
0x00001054946f7816ULL, 0x000fc4000000006fULL, 0x00001054956e7816ULL, 0x000fe2000000006eULL,
0x20000093ff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fe40000011669ULL,
0x0000ffff69697812ULL, 0x000fe400078ec0ffULL, 0x000000ff76767812ULL, 0x000fe200078ec0ffULL,
0x0000006e5c44723cULL, 0x000fe20000041844ULL, 0x00000010ff717819ULL, 0x000fe40000011689ULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x000000ff68687812ULL, 0x000fe200078ec0ffULL,
0x0000006e1c40723cULL, 0x000fe20000041840ULL, 0x00000008ff697819ULL, 0x000fe40000011669ULL,
0x00000076ff90723eULL, 0x000fe400020006ffULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff6e7819ULL, 0x000fe40000011688ULL, 0x00000010ff897819ULL, 0x000fc40000011670ULL,
0x0000ffff6a747812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x000fe40000011677ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x0000105471717816ULL, 0x000fc40000000066ULL,
0x00000010ff887819ULL, 0x000fe40000011675ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff777819ULL, 0x000fe4000001168cULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff757819ULL, 0x000fc40000011691ULL,
0x00000010ff667819ULL, 0x000fe4000001168fULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x0000105489707816ULL, 0x000fe2000000008aULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x000010548b6f7816ULL, 0x000fe20000000092ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00001054656e7816ULL, 0x000fe2000000006eULL,
0x20000090ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff897819ULL, 0x000fe20000011674ULL,
0x000000701c24723cULL, 0x000fe20000041824ULL, 0x000010548e777816ULL, 0x000fc40000000077ULL,
0x000010548d767816ULL, 0x000fe40000000076ULL, 0x0000105488757816ULL, 0x000fe20000000075ULL,
0x0000006e5c38723cULL, 0x000fe20000041838ULL, 0x0000105466747816ULL, 0x000fe40000000087ULL,
0x000000ff79797812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6d7819ULL, 0x000fe2000001166dULL,
0x0000006e1c28723cULL, 0x000fe20000041828ULL, 0x00000010ff7d7819ULL, 0x000fc40000011672ULL,
0x00000018ff807819ULL, 0x000fe40000011672ULL, 0x000000ff727f7812ULL, 0x000fe200078ec0ffULL,
0x000000761c2c723cULL, 0x000fe2000004182cULL, 0x00000079ff6f723eULL, 0x000fe400020006ffULL,
0x00000010ff6a7819ULL, 0x100fe40000011673ULL, 0x00000018ff827819ULL, 0x000fe20000011673ULL,
0x000000741c20723cULL, 0x000fe20000041820ULL, 0x000000ff73817812ULL, 0x000fe200078ec0ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fc4000001166cULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x000000765c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff1e7819ULL, 0x000fe40000011662ULL,
0x00000010ff1f7819ULL, 0x000fe20000011668ULL, 0x000000705c34723cULL, 0x000fe20000041834ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x0000ffff72727812ULL, 0x000fc400078ec0ffULL,
0x0000ffff73737812ULL, 0x000fe200078ec0ffULL, 0x000000745c30723cULL, 0x000fe20000041830ULL,
0x00000083ff66723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000010ff6c7819ULL, 0x000fe2000001166bULL,
0x20000066ff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe2000001167cULL,
0x2000006dff707230ULL, 0x000fe20000004100ULL, 0x00001054796b7816ULL, 0x000fe2000000007aULL,
0x20000086ff5d7230ULL, 0x000fe20000004100ULL, 0x00001054601f7816ULL, 0x000fc4000000001fULL,
0x00001054691e7816ULL, 0x000fe4000000001eULL, 0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff727819ULL, 0x000fe20000011672ULL,
0x0000001e184c723cULL, 0x000fe2000004184cULL, 0x000000ff6a797812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fc40000011673ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x0000001e1448723cULL, 0x000fe20000041848ULL, 0x00000010ff1c7819ULL, 0x000fe40000011664ULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x20000085ff5e7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000007fff5f723eULL, 0x000fe400020006ffULL,
0x0000007cff6e723eULL, 0x000fe200020006ffULL, 0x20000080ff777230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000082ff66723eULL, 0x000fe200020006ffULL, 0x20000089ff837230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000081ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fe2000001167bULL, 0x2000007eff717230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x2000007dff6d7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x000010541c657816ULL, 0x000fe20000000065ULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe2000001165cULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff1f7819ULL, 0x000fe40000011670ULL, 0x000010547b6a7816ULL, 0x000fe2000000006cULL,
0x20000072ff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165dULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x000010541f1c7816ULL, 0x000fe2000000001cULL,
0x0000006a1854723cULL, 0x000fe20000041854ULL, 0x00000010ff1e7819ULL, 0x000fe4000001165eULL,
0x000010545c1f7816ULL, 0x000fe4000000006fULL, 0x00000010ff5e7819ULL, 0x000fe20000011677ULL,
0x0000006a1450723cULL, 0x000fe20000041850ULL, 0x00000010ff5d7819ULL, 0x000fc4000001166eULL,
0x00000010ff5c7819ULL, 0x000fe4000001165fULL, 0x000000085800780cULL, 0x000fe40003f05270ULL,
0x00000010ff647819ULL, 0x000fe40000011667ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff1d7819ULL, 0x000fc40000011671ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff5f7819ULL, 0x000fe4000001166cULL, 0x00000010ff777819ULL, 0x000fe40000011679ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff737819ULL, 0x000fc40000011673ULL,
0x000010545d1e7816ULL, 0x000fe4000000001eULL, 0x0000105483647816ULL, 0x000fe40000000064ULL,
0x00001054841d7816ULL, 0x000fe4000000001dULL, 0x000010545e5d7816ULL, 0x000fe2000000006dULL,
0x0000001e1838723cULL, 0x000fe20000041838ULL, 0x000010545f5c7816ULL, 0x000fe4000000005cULL,
0x0000105466777816ULL, 0x000fc40000000077ULL, 0x0000105473767816ULL, 0x000fe20000000076ULL,
0x000000641844723cULL, 0x000fec0000041844ULL, 0x000000641440723cULL, 0x000fec0000041840ULL,
0x0000001c183c723cULL, 0x000fec000004183cULL, 0x0000005c1834723cULL, 0x000fec0000041834ULL,
0x000000761830723cULL, 0x000fec0000041830ULL, 0x0000001c142c723cULL, 0x000fec000004182cULL,
0x0000001e1428723cULL, 0x000fec0000041828ULL, 0x0000005c1424723cULL, 0x000fec0000041824ULL,
0x000000761420723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe400980947ULL, 0x000fde000383ffffULL, 0x00000001ff197424ULL, 0x000fe400078e00ffULL,
0x000000040c147220ULL, 0x080fe20000410000ULL, 0x000000040d157220ULL, 0x080fe20000410000ULL,
0x0000000454057220ULL, 0x080fe20000410000ULL, 0x01a688195a0c79a7ULL, 0x000e62000850003fULL,
0x0000000455557220ULL, 0x080fe20000410000ULL, 0x0000000456567220ULL, 0x080fe20000410000ULL,
0x0000000457577220ULL, 0x080fe20000410000ULL, 0x000000044c4c7220ULL, 0x080fe20000410000ULL,
0x000000044d4d7220ULL, 0x080fe20000410000ULL, 0x000000044e4e7220ULL, 0x080fe20000410000ULL,
0x000000044f4f7220ULL, 0x080fe20000410000ULL, 0x0000000444447220ULL, 0x080fe20000410000ULL,
0x0000000445457220ULL, 0x080fe20000410000ULL, 0x0000000446467220ULL, 0x080fe20000410000ULL,
0x0000000447477220ULL, 0x080fe20000410000ULL, 0x0000000410107220ULL, 0x080fe20000410000ULL,
0x0000000411117220ULL, 0x080fe20000410000ULL, 0x0000000412127220ULL, 0x080fe20000410000ULL,
0x0000000413137220ULL, 0x080fe20000410000ULL, 0x000000043c3c7220ULL, 0x080fe20000410000ULL,
0x000000043d3d7220ULL, 0x080fe20000410000ULL, 0x000000043e3e7220ULL, 0x080fe20000410000ULL,
0x000000043f3f7220ULL, 0x080fe20000410000ULL, 0x0000000438387220ULL, 0x080fe20000410000ULL,
0x0000000439397220ULL, 0x080fe20000410000ULL, 0x000000043a3a7220ULL, 0x080fe20000410000ULL,
0x000000043b3b7220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x0000000430307220ULL, 0x080fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x00000004500b7220ULL, 0x080fe20000410000ULL,
0x0000000451517220ULL, 0x080fe20000410000ULL, 0x0000000452527220ULL, 0x080fe20000410000ULL,
0x0000000453537220ULL, 0x080fe20000410000ULL, 0x0000000448487220ULL, 0x080fe20000410000ULL,
0x0000000449497220ULL, 0x080fe20000410000ULL, 0x000000044a4a7220ULL, 0x080fe20000410000ULL,
0x000000044b4b7220ULL, 0x080fe20000410000ULL, 0x0000000440407220ULL, 0x080fe20000410000ULL,
0x0000000441417220ULL, 0x080fe20000410000ULL, 0x0000000442427220ULL, 0x080fe20000410000ULL,
0x0000000443437220ULL, 0x080fe20000410000ULL, 0x000000040e167220ULL, 0x080fe20000410000ULL,
0x000000040f177220ULL, 0x080fe20000410000ULL, 0x000000042c2c7220ULL, 0x080fe20000410000ULL,
0x000000042d2d7220ULL, 0x080fe20000410000ULL, 0x000000042e2e7220ULL, 0x080fe20000410000ULL,
0x000000042f2f7220ULL, 0x080fe20000410000ULL, 0x0000000428287220ULL, 0x080fe20000410000ULL,
0x0000000429297220ULL, 0x080fe20000410000ULL, 0x000000042a2a7220ULL, 0x080fe20000410000ULL,
0x000000042b2b7220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x0000000426267220ULL, 0x080fe20000410000ULL,
0x0000000427277220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x080fe20000410000ULL, 0x0000000422227220ULL, 0x080fe20000410000ULL,
0x0000000423237220ULL, 0x000fe20000410000ULL, 0x0000000703187812ULL, 0x000fc400078ec0ffULL,
0x00000000001a7805ULL, 0x000fe20000015200ULL, 0x01a6880d5a0075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e1a197210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e1bULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000190e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01a6880d5a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000004030c7824ULL, 0x000fe200078e00ffULL, 0x000000070600720cULL, 0x000fe20003f06070ULL,
0x0000008078197824ULL, 0x000fc600078e0209ULL, 0xfffffff00c0c7812ULL, 0x000fca00078ec0ffULL,
0x0000000119197824ULL, 0x000fca00078e020cULL, 0x01a40000190c7984ULL, 0x0002a20000000c00ULL,
0x0000001c00c48947ULL, 0x000fea0003800000ULL, 0xffffff0008087836ULL, 0x000fe20000000000ULL,
0x00008c00ff887b82ULL, 0x000ee20000000a00ULL, 0x00000002031c7824ULL, 0x040fe200078e00ffULL,
0x00000000031a7211ULL, 0x000fe200078ff0ffULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x00000008611b7248ULL, 0x000fe20007fe0000ULL, 0x00008400000a7ab9ULL, 0x000fe40000000800ULL,
0x000000081a1d7836ULL, 0x000fe40000000000ULL, 0x000000011ba67824ULL, 0x000fe200078e0a08ULL,
0x000000061c087812ULL, 0x000fe200078ec0ffULL, 0x000000101a1e7836ULL, 0x000fe20000000000ULL,
0x00000009ff1b7c19ULL, 0x000fe2000801161aULL, 0x000000ffff837224ULL, 0x000fe200078e0aa6ULL,
0x00000009ff1d7c19ULL, 0x000fe2000801161dULL, 0x00000008081c7c36ULL, 0x000fe20008000000ULL,
0x000000051b1b7c48ULL, 0x000fe2000bfe0000ULL, 0x000000181a1f7836ULL, 0x000fe20000000000ULL,
0x00000009ff1e7c19ULL, 0x000fe2000801161eULL, 0x0000000a081a7c36ULL, 0x000fe20008000000ULL,
0x000000a61c00720cULL, 0x000fe20003f26070ULL, 0x000000041b817c24ULL, 0x000fe2000f8e02ffULL,
0x000000051c1c7e46ULL, 0x000fc4000b800083ULL, 0x000000a61a00720cULL, 0x000fe40003f06070ULL,
0x00000004ff1c7819ULL, 0x000fe4000001161cULL, 0x000000051a997e46ULL, 0x000fe4000b800083ULL,
0x000000ff1c507207ULL, 0x000fe40000800000ULL, 0x000000ff99997207ULL, 0x000fe40000000000ULL,
0x00000009ff1b7c19ULL, 0x000fe2000801161fULL, 0x00000001811f7824ULL, 0x000fe200078e0250ULL,
0x00000081995d7211ULL, 0x000fc400078fe0ffULL, 0x000000051d1d7c48ULL, 0x000fe4000bfe0000ULL,
0x000000051e807c48ULL, 0x000fe2000bfe0000ULL, 0x000000021f1e7825ULL, 0x008fe200078e0088ULL,
0x000000051b1b7c48ULL, 0x000fc6000bfe0000ULL, 0x000000025d5c7825ULL, 0x000fe400078e0088ULL,
0x000000061e1e7981ULL, 0x000ee4000c1e9500ULL, 0x000000041d797c24ULL, 0x000fe4000f8e02ffULL,
0x0000000480807c24ULL, 0x000fe4000f8e02ffULL, 0x000000041b867c24ULL, 0x000fe2000f8e02ffULL,
0x00000079991d7211ULL, 0x040fe200078fe0ffULL, 0x000000065c1b7981ULL, 0x0008e2000c1e9500ULL,
0x00000080996b7211ULL, 0x000fe200078fe0ffULL, 0x0000000150677824ULL, 0x000fe200078e0279ULL,
0x0000001008587812ULL, 0x000fe200078efcffULL, 0x0000000150657824ULL, 0x000fc400078e0280ULL,
0x000000021d1c7825ULL, 0x000fc800078e0088ULL, 0x000000026b6a7825ULL, 0x100fe400078e0088ULL,
0x000000061c1c7981ULL, 0x000ae4000c1e9500ULL, 0x0000000267667825ULL, 0x000fc800078e0088ULL,
0x0000000265647825ULL, 0x000fe200078e0088ULL, 0x00000006665d7981ULL, 0x012326000c1e9500ULL,
0x0000000a585c7c36ULL, 0x000fe20008000000ULL, 0x000000066a1d7981ULL, 0x024ea2000c1e9500ULL,
0x0000000858607c36ULL, 0x000fe40008000000ULL, 0x00000001505f7824ULL, 0x000fe200078e0286ULL,
0x000000a65c00720cULL, 0x000fe20003f06070ULL, 0x0000000664507981ULL, 0x000aa2000c1e9500ULL,
0x000000055c987e46ULL, 0x000fc4000b800083ULL, 0x0000000560627e46ULL, 0x000fe4000b800083ULL,
0x0000008699697211ULL, 0x000fe400078fe0ffULL, 0x000000ff98987207ULL, 0x000fe40000000000ULL,
0x000000a66000720cULL, 0x000fe40003f26070ULL, 0x00000004ff627819ULL, 0x000fe20000011662ULL,
0x0000000269687825ULL, 0x000fe200078e0088ULL, 0x0000007998677211ULL, 0x002fc600078fe0ffULL,
0x000000025f5e7825ULL, 0x100fe200078e0088ULL, 0x000000ff62627207ULL, 0x000fe20000800000ULL,
0x00000006681f7981ULL, 0x0002a4000c1e9500ULL, 0x0000000267667825ULL, 0x000fe400078e0088ULL,
0x000000065e547981ULL, 0x0002a4000c1e9500ULL, 0x0000000181657824ULL, 0x020fe400078e0262ULL,
0x00000001626f7824ULL, 0x000fe200078e0279ULL, 0x0000008198697211ULL, 0x002fe200078fe0ffULL,
0x0000000265647825ULL, 0x100fe200078e0088ULL, 0x00000006665f7981ULL, 0x000366000c1e9500ULL,
0x0000000269687825ULL, 0x000fc400078e0088ULL, 0x0000000664657981ULL, 0x000364000c1e9500ULL,
0x000000026f6e7825ULL, 0x000fe400078e0088ULL, 0x00000006685e7981ULL, 0x000364000c1e9500ULL,
0x0000002008667812ULL, 0x002fe400078efcffULL, 0x000000066e647981ULL, 0x000366000c1e9500ULL,
0x0000000866747c36ULL, 0x000fe20008000000ULL, 0x0000008098737211ULL, 0x040fe200078fe0ffULL,
0x0000000a66687c36ULL, 0x000fe20008000000ULL, 0x0000008698717211ULL, 0x000fe200078fe0ffULL,
0x00000001626d7824ULL, 0x040fe200078e0280ULL, 0x0000000574757e46ULL, 0x000fe2000b800083ULL,
0x00000001626b7824ULL, 0x000fe200078e0286ULL, 0x000000a66800720cULL, 0x000fe20003f06070ULL,
0x0000000273727825ULL, 0x000fe200078e0088ULL, 0x0000000568967e46ULL, 0x000fc4000b800083ULL,
0x000000a67400720cULL, 0x000fe20003f26070ULL, 0x0000000271707825ULL, 0x000fe200078e0088ULL,
0x00000004ff757819ULL, 0x000fe20000011675ULL, 0x0000000672607981ULL, 0x000f64000c1e9500ULL,
0x000000026d6c7825ULL, 0x100fe200078e0088ULL, 0x000000ff96967207ULL, 0x000fe20000000000ULL,
0x0000000670627981ULL, 0x000364000c1e9500ULL, 0x000000026b6a7825ULL, 0x000fe200078e0088ULL,
0x000000ff75757207ULL, 0x000fe20000800000ULL, 0x000000066c677981ULL, 0x000f62000c1e9500ULL,
0x00000079966f7211ULL, 0x002fc600078fe0ffULL, 0x000000066a697981ULL, 0x000362000c1e9500ULL,
0x0000008196717211ULL, 0x000fe200078fe0ffULL, 0x00000001757b7824ULL, 0x000fe400078e0279ULL,
0x000000026f6e7825ULL, 0x000fc800078e0088ULL, 0x0000000271707825ULL, 0x100fe200078e0088ULL,
0x000000066e6b7981ULL, 0x002f66000c1e9500ULL, 0x000000027b7a7825ULL, 0x000fe200078e0088ULL,
0x00000006706a7981ULL, 0x000362000c1e9500ULL, 0x00000080967f7211ULL, 0x040fe400078fe0ffULL,
0x00000001816d7824ULL, 0x000fe200078e0275ULL, 0x00000086967d7211ULL, 0x000fe200078fe0ffULL,
0x0000000175777824ULL, 0x040fe200078e0280ULL, 0x000000067a707981ULL, 0x002f62000c1e9500ULL,
0x0000000175757824ULL, 0x000fe200078e0286ULL, 0x0000003008727812ULL, 0x000fe200078efcffULL,
0x000000026d6c7825ULL, 0x000fc800078e0088ULL, 0x000000027f7e7825ULL, 0x100fe400078e0088ULL,
0x000000066c6d7981ULL, 0x000364000c1e9500ULL, 0x000000027d7c7825ULL, 0x000fc800078e0088ULL,
0x0000000277767825ULL, 0x100fe200078e0088ULL, 0x000000067c6e7981ULL, 0x000366000c1e9500ULL,
0x0000000275747825ULL, 0x000fe200078e0088ULL, 0x000000067e6c7981ULL, 0x002f66000c1e9500ULL,
0x0000000872827c36ULL, 0x000fe20008000000ULL, 0x00000006766f7981ULL, 0x000f62000c1e9500ULL,
0x0000000a72737c36ULL, 0x000fc60008000000ULL, 0x0000000674717981ULL, 0x000362000c1e9500ULL,
0x0000000582847e46ULL, 0x000fe4000b800083ULL, 0x000000a68200720cULL, 0x080fe40003f26070ULL,
0x00000004ff847819ULL, 0x000fe40000011684ULL, 0x000000a67300720cULL, 0x000fe40003f06070ULL,
0x0000000573977e46ULL, 0x000fe4000b800083ULL, 0x000000ff84877207ULL, 0x000fc40000800000ULL,
0x000000ff97977207ULL, 0x000fc60000000000ULL, 0x00000001817b7824ULL, 0x000fe200078e0287ULL,
0x00000081977d7211ULL, 0x000fe200078fe0ffULL, 0x0000000187837824ULL, 0x000fe200078e0280ULL,
0x0000008097857211ULL, 0x000fe200078fe0ffULL, 0x000000027b7a7825ULL, 0x000fc800078e0088ULL,
0x000000027d7c7825ULL, 0x100fe200078e0088ULL, 0x000000067a757981ULL, 0x002366000c1e9500ULL,
0x0000000285847825ULL, 0x100fe200078e0088ULL, 0x000000067c747981ULL, 0x000366000c1e9500ULL,
0x0000000283827825ULL, 0x000fe200078e0088ULL, 0x0000000684777981ULL, 0x000362000c1e9500ULL,
0x00000079977f7211ULL, 0x000fc600078fe0ffULL, 0x00000006827a7981ULL, 0x002f62000c1e9500ULL,
0x0000000187817824ULL, 0x000fe400078e0279ULL, 0x000000027f7e7825ULL, 0x000fc800078e0088ULL,
0x0000000281807825ULL, 0x000fe200078e0088ULL, 0x000000067e767981ULL, 0x000f62000c1e9500ULL,
0x00000086977b7211ULL, 0x000fc600078fe0ffULL, 0x0000000680797981ULL, 0x000f62000c1e9500ULL,
0x00000001877d7824ULL, 0x000fe400078e0286ULL, 0x000000027b867825ULL, 0x000fc800078e0088ULL,
0x000000027d887825ULL, 0x000fe200078e0088ULL, 0x00000006867b7981ULL, 0x000368000c1e9500ULL,
0x00000006887c7981ULL, 0x000562000c1e9500ULL, 0xfffffff099997812ULL, 0x000fe400078ec0ffULL,
0x0000002108847812ULL, 0x040fe400078efcffULL, 0x0000002808857812ULL, 0x000fe200078efcffULL,
0x00000001a6997824ULL, 0x000fe200078e0299ULL, 0x0000002908867812ULL, 0x002fc400078efcffULL,
0xfffffff0969d7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff7d7424ULL, 0x000fe200078e00ffULL,
0xfffffff0979f7812ULL, 0x000fe200078ec0ffULL, 0x0000000a84907c36ULL, 0x000fe40008000000ULL,
0x0000000a85917c36ULL, 0x000fe40008000000ULL, 0x0000000a86927c36ULL, 0x000fe40008000000ULL,
0x00000001a6977824ULL, 0x000fe400078e029dULL, 0x000000011ab67824ULL, 0x000fe200078e0a99ULL,
0x00000001087e7812ULL, 0x000fe200078efcffULL, 0x0000000168ae7824ULL, 0x000fc400078e0a97ULL,
0x0000000190a07824ULL, 0x100fe400078e0a97ULL, 0x0000000191ac7824ULL, 0x100fe400078e0a97ULL,
0x0000000192a27824ULL, 0x000fe200078e0a97ULL, 0x000000b67d977219ULL, 0x000fe200000006ffULL,
0x0000000a7e8a7c36ULL, 0x000fe20008000000ULL, 0xfffffff0989b7812ULL, 0x000fc600078ec0ffULL,
0x000000018a987824ULL, 0x100fe200078e0a99ULL, 0x00000008087f7812ULL, 0x040fe400078efcffULL,
0x0000000908807812ULL, 0x000fe400078efcffULL, 0x000000987d987219ULL, 0x000fe200000006ffULL,
0x0000000a7f8b7c36ULL, 0x000fe40008000000ULL, 0x0000000a808c7c36ULL, 0x000fe40008000000ULL,
0x000000018bb47824ULL, 0x000fc400078e0a99ULL, 0x000000018c9a7824ULL, 0x000fe200078e0a99ULL,
0x0000001108817812ULL, 0x040fe400078efcffULL, 0x000000b47d997219ULL, 0x040fe400000006ffULL,
0x0000009a7d9a7219ULL, 0x000fe200000006ffULL, 0x0000000a818d7c36ULL, 0x000fe20008000000ULL,
0x0000001808827812ULL, 0x000fe200078efcffULL, 0x00000001a69b7824ULL, 0x000fe200078e029bULL,
0x0000001908837812ULL, 0x000fe400078efcffULL, 0x000054101b1b7816ULL, 0x008fc8000000001eULL,
0x0000001b97ff7212ULL, 0x000fc800078ac0ffULL, 0x000000a61a00720cULL, 0x000fc80002fa1470ULL,
0x000000a60800720cULL, 0x000fe40002fa1070ULL, 0x0000001b98ff7212ULL, 0x000fe4000788c0ffULL,
0xff80000005057808ULL, 0x000fe40002800000ULL, 0x000054101c1c7816ULL, 0x010fc8000000005dULL,
0x0000001c97ff7212ULL, 0x080fe4000784c0ffULL, 0x000054101d1d7816ULL, 0x004fe40000000050ULL,
0x0000001c98ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001d97ff7212ULL, 0x000fe4000782c0ffULL,
0x000000a61a00720cULL, 0x0c0fe40001741470ULL, 0x000000a61a00720cULL, 0x000fc40000f21470ULL,
0x000000a68a00720cULL, 0x0c0fe40002781470ULL, 0x000000a68a00720cULL, 0x080fe40002fa1470ULL,
0x000000a60800720cULL, 0x0c0fe40001741070ULL, 0x000000a60800720cULL, 0x080fe40000f21070ULL,
0x000000a67e00720cULL, 0x0c0fe40002781070ULL, 0x000000a67e00720cULL, 0x000fc40002fa1070ULL,
0x000054101f1f7816ULL, 0x000fe40000000054ULL, 0xff80000056567808ULL, 0x000fe40001000000ULL,
0xff8000000b0b7808ULL, 0x000fe40000800000ULL, 0xff80000055557808ULL, 0x000fe40002000000ULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x0000001b99ff7212ULL, 0x000fc4000786c0ffULL,
0x0000001f97ff7212ULL, 0x000fe4000780c0ffULL, 0x0000001d98ff7212ULL, 0x040fe4000784c0ffULL,
0x0000001f98ff7212ULL, 0x000fe4000782c0ffULL, 0x0000001c9aff7212ULL, 0x000fe4000788c0ffULL,
0x0000001d99ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000a828e7c36ULL, 0x000fe20008000000ULL,
0x000000a61a00720cULL, 0x080fe20000701470ULL, 0x0000000a838f7c36ULL, 0x000fe20008000000ULL,
0x000000a68a00720cULL, 0x080fe20001741470ULL, 0x000000015cb27824ULL, 0x100fe200078e0a9bULL,
0x000000a68a00720cULL, 0x080fe20000f21470ULL, 0x000000018d9c7824ULL, 0x000fe200078e0a9bULL,
0x000000a68b00720cULL, 0x000fc40001f61470ULL, 0x000000a68b00720cULL, 0x080fe40002fa1470ULL,
0x000000a68c00720cULL, 0x080fe20002781470ULL, 0x000000018eb07824ULL, 0x100fe200078e0a9bULL,
0x000000a60800720cULL, 0x080fe20000701070ULL, 0x000000018f9e7824ULL, 0x000fe200078e0a9bULL,
0x000000a67e00720cULL, 0x0c0fe40001741070ULL, 0x000000a67e00720cULL, 0x080fe40000f21070ULL,
0x000000a67f00720cULL, 0x000fc40001f61070ULL, 0x000000a67f00720cULL, 0x080fe40002fa1070ULL,
0x000000a68000720cULL, 0x000fe40002781070ULL, 0x000000b27d9b7219ULL, 0x040fe400000006ffULL,
0x0000009c7d9c7219ULL, 0x000fe400000006ffULL, 0x000054105e5e7816ULL, 0x020fe40000000065ULL,
0x000054105f5f7816ULL, 0x000fc40000000064ULL, 0xff80000052527808ULL, 0x000fe40000000000ULL,
0xff80000051517808ULL, 0x000fe40001000000ULL, 0xff80000053537808ULL, 0x000fe40000800000ULL,
0xff8000004c4c7808ULL, 0x000fe40001800000ULL, 0xff80000048487808ULL, 0x000fe40002800000ULL,
0xff8000004f4f7808ULL, 0x000fc40002000000ULL, 0x0000001c99ff7212ULL, 0x040fe4000780c0ffULL,
0x0000001d9aff7212ULL, 0x040fe4000784c0ffULL, 0x0000001f99ff7212ULL, 0x080fe4000782c0ffULL,
0x0000001f9aff7212ULL, 0x000fe4000786c0ffULL, 0x0000005e9cff7212ULL, 0x000fe400078ac0ffULL,
0x0000005f9bff7212ULL, 0x000fc4000788c0ffULL, 0x000000a68b00720cULL, 0x0c0fe40000701470ULL,
0x000000a68b00720cULL, 0x080fe40000f21470ULL, 0x000000a68c00720cULL, 0x0c0fe40001741470ULL,
0x000000a68c00720cULL, 0x080fe40001f61470ULL, 0x000000a65c00720cULL, 0x080fe40002781470ULL,
0x000000a68d00720cULL, 0x000fc40002fa1470ULL, 0x000000a67f00720cULL, 0x0c0fe40000701070ULL,
0x000000a67f00720cULL, 0x080fe40000f21070ULL, 0x000000a68000720cULL, 0x0c0fe40001741070ULL,
0x000000a68000720cULL, 0x080fe40001f61070ULL, 0x000000a65800720cULL, 0x080fe40002781070ULL,
0x000000a68100720cULL, 0x000fc40002fa1070ULL, 0x000000b07d9d7219ULL, 0x040fe400000006ffULL,
0x0000009e7d9e7219ULL, 0x000fe400000006ffULL, 0x0000541060607816ULL, 0x000fe40000000067ULL,
0x0000541062627816ULL, 0x000fe40000000069ULL, 0xff8000004e4e7808ULL, 0x000fe40000000000ULL,
0xff8000004a4a7808ULL, 0x000fc40000800000ULL, 0xff80000049497808ULL, 0x000fe40001000000ULL,
0xff8000004b4b7808ULL, 0x000fe40001800000ULL, 0xff80000046467808ULL, 0x000fe40002000000ULL,
0xff80000045457808ULL, 0x000fe40002800000ULL, 0x0000005e9bff7212ULL, 0x080fe4000780c0ffULL,
0x0000005e9dff7212ULL, 0x000fc4000782c0ffULL, 0x000000609bff7212ULL, 0x040fe4000784c0ffULL,
0x000000629bff7212ULL, 0x000fe4000786c0ffULL, 0x000000609cff7212ULL, 0x000fe4000788c0ffULL,
0x0000005f9eff7212ULL, 0x000fe400078ac0ffULL, 0x000000a65c00720cULL, 0x0c0fe40000701470ULL,
0x000000a65c00720cULL, 0x000fc40001741470ULL, 0x000000a65c00720cULL, 0x080fe40001f61470ULL,
0x000000a68d00720cULL, 0x080fe40002781470ULL, 0x000000a68e00720cULL, 0x080fe40000f21470ULL,
0x000000a68f00720cULL, 0x080fe20002fa1470ULL, 0x00000001a6967824ULL, 0x000fe200078e029fULL,
0x000000a65800720cULL, 0x0c0fe40000701070ULL, 0x000000a65800720cULL, 0x000fc40001741070ULL,
0x000000a65800720cULL, 0x080fe40001f61070ULL, 0x000000a68100720cULL, 0x080fe40002781070ULL,
0x000000a68200720cULL, 0x080fe40000f21070ULL, 0x000000a68300720cULL, 0x000fe40002fa1070ULL,
0x000000ae7d9f7219ULL, 0x000fe400000006ffULL, 0x000054106b6b7816ULL, 0x000fc40000000070ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff80000040407808ULL, 0x000fe40001000000ULL,
0xff80000042427808ULL, 0x000fe40001800000ULL, 0xff80000041417808ULL, 0x000fe40002000000ULL,
0xff80000010107808ULL, 0x000fe40000800000ULL, 0xff80000013137808ULL, 0x000fc40002800000ULL,
0x0000005f9cff7212ULL, 0x0c0fe4000780c0ffULL, 0x000000629cff7212ULL, 0x000fe4000784c0ffULL,
0x0000005f9dff7212ULL, 0x000fe4000786c0ffULL, 0x000000609eff7212ULL, 0x040fe4000788c0ffULL,
0x000000629eff7212ULL, 0x000fe4000782c0ffULL, 0x0000006b9fff7212ULL, 0x000fc400078ac0ffULL,
0x000000a68d00720cULL, 0x0c0fe40000701470ULL, 0x000000a68d00720cULL, 0x080fe40001741470ULL,
0x000000a68e00720cULL, 0x080fe40001f61470ULL, 0x000000a68f00720cULL, 0x0c0fe40002781470ULL,
0x000000a68f00720cULL, 0x080fe40000f21470ULL, 0x000000a66800720cULL, 0x000fc40002fa1470ULL,
0x000000a68100720cULL, 0x0c0fe40000701070ULL, 0x000000a68100720cULL, 0x080fe40001741070ULL,
0x000000a68200720cULL, 0x080fe40001f61070ULL, 0x000000a68300720cULL, 0x0c0fe40002781070ULL,
0x000000a68300720cULL, 0x080fe40000f21070ULL, 0x000000a66600720cULL, 0x000fc40002fa1070ULL,
0x000000a07da07219ULL, 0x000fe400000006ffULL, 0x000054106a6a7816ULL, 0x000fe4000000006dULL,
0x000054106c6c7816ULL, 0x000fe4000000006fULL, 0x000054106e6e7816ULL, 0x000fe40000000071ULL,
0xff80000047477808ULL, 0x000fe40000000000ULL, 0xff80000043437808ULL, 0x000fc40001000000ULL,
0xff80000012127808ULL, 0x000fe40001800000ULL, 0xff80000015157808ULL, 0x000fe40002000000ULL,
0xff80000017177808ULL, 0x000fe40000800000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x0000001b9aff7212ULL, 0x000fe400078cc0ffULL, 0x000000609dff7212ULL, 0x000fc4000780c0ffULL,
0x000000629dff7212ULL, 0x000fe4000784c0ffULL, 0x0000006a9fff7212ULL, 0x040fe4000786c0ffULL,
0x0000006c9fff7212ULL, 0x040fe4000788c0ffULL, 0x0000006e9fff7212ULL, 0x000fe4000782c0ffULL,
0x0000006ca0ff7212ULL, 0x000fe400078ac0ffULL, 0x000000a68c00720cULL, 0x000fc400037c1470ULL,
0x000000a68e00720cULL, 0x0c0fe40000701470ULL, 0x000000a68e00720cULL, 0x080fe40001741470ULL,
0x000000a66800720cULL, 0x0c0fe40001f61470ULL, 0x000000a66800720cULL, 0x0c0fe40002781470ULL,
0x000000a66800720cULL, 0x080fe40000f21470ULL, 0x000000a69000720cULL, 0x000fc40002fa1470ULL,
0x000000a68000720cULL, 0x080fe400037c1070ULL, 0x000000a68200720cULL, 0x0c0fe40000701070ULL,
0x000000a68200720cULL, 0x080fe40001741070ULL, 0x000000a66600720cULL, 0x0c0fe40001f61070ULL,
0x000000a66600720cULL, 0x0c0fe40002781070ULL, 0x000000a66600720cULL, 0x000fc40000f21070ULL,
0x000000a68400720cULL, 0x000fe40002fa1070ULL, 0x000000ac7da17219ULL, 0x040fe400000006ffULL,
0x000000a27da27219ULL, 0x000fe400000006ffULL, 0xff8000004d4d7808ULL, 0x000fe40003000000ULL,
0xff80000014147808ULL, 0x000fe40000000000ULL, 0xff80000016167808ULL, 0x000fc40001000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001800000ULL, 0xff8000002c2c7808ULL, 0x000fe40002000000ULL,
0xff8000002e2e7808ULL, 0x000fe40000800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0x0000005e9eff7212ULL, 0x000fe400078cc0ffULL, 0x0000006aa0ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006aa1ff7212ULL, 0x040fe4000784c0ffULL, 0x0000006ba0ff7212ULL, 0x0c0fe4000786c0ffULL,
0x0000006ea0ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006ba1ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006ca2ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000173aa7824ULL, 0x000fe200078e0a96ULL,
0x000000a68f00720cULL, 0x000fc400037c1470ULL, 0x000000a69000720cULL, 0x0c0fe40000701470ULL,
0x000000a69000720cULL, 0x0c0fe40001f61470ULL, 0x000000a69000720cULL, 0x080fe40002781470ULL,
0x000000a69100720cULL, 0x0c0fe40001741470ULL, 0x000000a69100720cULL, 0x080fe40000f21470ULL,
0x000000a69200720cULL, 0x000fc40002fa1470ULL, 0x0000003108877812ULL, 0x040fe400078efcffULL,
0x0000003808887812ULL, 0x040fe400078efcffULL, 0x0000003908897812ULL, 0x000fe400078efcffULL,
0x000000a68300720cULL, 0x080fe400037c1070ULL, 0x000000a68400720cULL, 0x0c0fe40000701070ULL,
0x000000a68400720cULL, 0x000fc40001f61070ULL, 0x000000a68400720cULL, 0x080fe40002781070ULL,
0x000000a68500720cULL, 0x0c0fe40001741070ULL, 0x000000a68500720cULL, 0x080fe40000f21070ULL,
0x000000a68600720cULL, 0x000fe40002fa1070ULL, 0x000000aa7da37219ULL, 0x000fe400000006ffULL,
0x0000541074747816ULL, 0x000fc40000000075ULL, 0x0000541077777816ULL, 0x000fe2000000007aULL,
0x0000000a87937c36ULL, 0x000fe20008000000ULL, 0xff80000011117808ULL, 0x000fe20003000000ULL,
0x0000000a88947c36ULL, 0x000fe20008000000ULL, 0xff8000003d3d7808ULL, 0x000fe20000000000ULL,
0x0000000a89957c36ULL, 0x000fe20008000000ULL, 0xff8000003f3f7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000038387808ULL, 0x000fc40001000000ULL,
0xff8000003a3a7808ULL, 0x000fe40000800000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x0000006aa2ff7212ULL, 0x040fe400078cc0ffULL, 0x0000006ba2ff7212ULL, 0x000fe4000780c0ffULL,
0x0000006ca1ff7212ULL, 0x040fe4000786c0ffULL, 0x0000006ea1ff7212ULL, 0x000fc4000788c0ffULL,
0x0000006ea2ff7212ULL, 0x000fe4000784c0ffULL, 0x00000074a3ff7212ULL, 0x040fe4000782c0ffULL,
0x00000077a3ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000193a47824ULL, 0x100fe200078e0a96ULL,
0x000000a69100720cULL, 0x0c0fe20001f61470ULL, 0x0000000194a87824ULL, 0x100fe200078e0a96ULL,
0x000000a69100720cULL, 0x080fe20002781470ULL, 0x0000000195967824ULL, 0x000fe200078e0a96ULL,
0x000000a69200720cULL, 0x000fc400037c1470ULL, 0x000000a69200720cULL, 0x0c0fe40000701470ULL,
0x000000a69200720cULL, 0x080fe40001741470ULL, 0x000000a67300720cULL, 0x0c0fe40000f21470ULL,
0x000000a67300720cULL, 0x080fe40002fa1470ULL, 0x000000a68500720cULL, 0x0c0fe40001f61070ULL,
0x000000a68500720cULL, 0x000fc40002781070ULL, 0x000000a68600720cULL, 0x0c0fe400037c1070ULL,
0x000000a68600720cULL, 0x0c0fe40000701070ULL, 0x000000a68600720cULL, 0x080fe40001741070ULL,
0x000000a67200720cULL, 0x0c0fe40000f21070ULL, 0x000000a67200720cULL, 0x000fe40002fa1070ULL,
0x000000a47da47219ULL, 0x000fc400000006ffULL, 0x000000a87da57219ULL, 0x040fe400000006ffULL,
0x000000967d967219ULL, 0x000fe400000006ffULL, 0x0000541076767816ULL, 0x000fe40000000079ULL,
0xff80000028287808ULL, 0x000fe40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40002000000ULL,
0xff80000039397808ULL, 0x000fc40003000000ULL, 0xff8000003b3b7808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff80000024247808ULL, 0x000fe40002800000ULL, 0x00000074a4ff7212ULL, 0x080fe4000786c0ffULL,
0x00000074a5ff7212ULL, 0x000fc4000788c0ffULL, 0x0000007496ff7212ULL, 0x000fe400078cc0ffULL,
0x00000076a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000076a4ff7212ULL, 0x0c0fe4000784c0ffULL,
0x00000076a5ff7212ULL, 0x000fe4000782c0ffULL, 0x00000077a4ff7212ULL, 0x000fe400078ac0ffULL,
0x000000a67300720cULL, 0x000fc40000701470ULL, 0x000000a69300720cULL, 0x0c0fe40001f61470ULL,
0x000000a69300720cULL, 0x0c0fe40001741470ULL, 0x000000a69300720cULL, 0x080fe40002fa1470ULL,
0x000000a69400720cULL, 0x0c0fe40002781470ULL, 0x000000a69500720cULL, 0x080fe400037c1470ULL,
0x000000a69400720cULL, 0x000fc40000f21470ULL, 0x000000a67200720cULL, 0x080fe40000701070ULL,
0x000000a68700720cULL, 0x0c0fe40001f61070ULL, 0x000000a68700720cULL, 0x0c0fe40001741070ULL,
0x000000a68700720cULL, 0x080fe40002fa1070ULL, 0x000000a68800720cULL, 0x0c0fe40002781070ULL,
0x000000a68800720cULL, 0x000fc40000f21070ULL, 0x000000a68900720cULL, 0x000fe400037c1070ULL,
0x000054107b7b7816ULL, 0x000fe4000000007cULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff80000035357808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fc40002800000ULL, 0xff80000030307808ULL, 0x000fe40002000000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000031317808ULL, 0x000fe40003000000ULL,
0x0000007696ff7212ULL, 0x040fe4000780c0ffULL, 0x00000077a5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000007796ff7212ULL, 0x000fc4000784c0ffULL, 0x0000007ba3ff7212ULL, 0x080fe400078ac0ffULL,
0x0000007ba4ff7212ULL, 0x080fe4000788c0ffULL, 0x0000007ba5ff7212ULL, 0x080fe4000782c0ffULL,
0x0000007b96ff7212ULL, 0x000fe400078cc0ffULL, 0x000000a67300720cULL, 0x080fe40002fa1470ULL,
0x000000a69300720cULL, 0x000fc40002781470ULL, 0x000000a69400720cULL, 0x0c0fe40001f61470ULL,
0x000000a69400720cULL, 0x080fe40000f21470ULL, 0x000000a69500720cULL, 0x0c0fe40000701470ULL,
0x000000a69500720cULL, 0x0c0fe40001741470ULL, 0x000000a69500720cULL, 0x080fe400037c1470ULL,
0x000000a67200720cULL, 0x000fc40002fa1070ULL, 0x000000a68700720cULL, 0x080fe40002781070ULL,
0x000000a68900720cULL, 0x0c0fe40000701070ULL, 0x000000a68800720cULL, 0x0c0fe40001f61070ULL,
0x000000a68800720cULL, 0x080fe40000f21070ULL, 0x000000a68900720cULL, 0x0c0fe40001741070ULL,
0x000000a68900720cULL, 0x000fc400037c1070ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff80000020207808ULL, 0x000fe40001800000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0xff80000027277808ULL, 0x000fe40002000000ULL,
0xff80000022227808ULL, 0x000fc40000800000ULL, 0xff80000023237808ULL, 0x000fce0003000000ULL,
0x000000050c00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000097882ULL, 0x000fe20000000000ULL,
0x0000000106067836ULL, 0x000fe40000000000ULL, 0x0000000c050c7208ULL, 0x000fc80004000000ULL,
0x000000550c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c551b7208ULL, 0x000fc80004000000ULL,
0x0000004c1b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b4c087208ULL, 0x000fc80004000000ULL,
0x0000004d0800720bULL, 0x000fc80003f1e000ULL, 0x000000084d1b7208ULL, 0x000fc80004000000ULL,
0x000000441b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b44087208ULL, 0x000fc80004000000ULL,
0x000000450800720bULL, 0x000fc80003f1e000ULL, 0x00000008451b7208ULL, 0x000fc80004000000ULL,
0x000000101b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b10087208ULL, 0x000fc80004000000ULL,
0x000000110800720bULL, 0x000fc80003f1e000ULL, 0x00000008111b7208ULL, 0x000fc80004000000ULL,
0x0000003c1b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b3c087208ULL, 0x000fc80004000000ULL,
0x0000003d0800720bULL, 0x000fc80003f1e000ULL, 0x000000083d1b7208ULL, 0x000fc80004000000ULL,
0x000000381b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b38087208ULL, 0x000fc80004000000ULL,
0x000000390800720bULL, 0x000fc80003f1e000ULL, 0x00000008391b7208ULL, 0x000fc80004000000ULL,
0x000000341b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b34087208ULL, 0x000fc80004000000ULL,
0x000000350800720bULL, 0x000fc80003f1e000ULL, 0x00000008351b7208ULL, 0x000fc80004000000ULL,
0x000000301b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b30087208ULL, 0x000fe40004000000ULL,
0x000000560d00720bULL, 0x000fe40003f1e000ULL, 0x000000310800720bULL, 0x000fc80003f3e000ULL,
0x00000008310c7208ULL, 0x000fe40004800000ULL, 0x0000000d56087208ULL, 0x000fc60004000000ULL,
0x0c401f000c1b7f89ULL, 0x000ea200000e0000ULL, 0x000000570800720bULL, 0x000fc80003f1e000ULL,
0x00000008570d7208ULL, 0x000fc80004000000ULL, 0x0000004e0d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d4e087208ULL, 0x000fc80004000000ULL, 0x0000004f0800720bULL, 0x000fc80003f1e000ULL,
0x000000084f0d7208ULL, 0x000fe40004000000ULL, 0x0000001b0c00720bULL, 0x004fe40003f3e000ULL,
0x000000460d00720bULL, 0x000fe40003f1e000ULL, 0x0000000c1b1b7208ULL, 0x000fe40004800000ULL,
0x0000000d46087208ULL, 0x000fc60004000000ULL, 0x0c201f001b0c7f89ULL, 0x000ea200000e0000ULL,
0x000000470800720bULL, 0x000fc80003f1e000ULL, 0x00000008470d7208ULL, 0x000fc80004000000ULL,
0x000000120d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d12087208ULL, 0x000fc80004000000ULL,
0x000000130800720bULL, 0x000fc80003f1e000ULL, 0x00000008130d7208ULL, 0x000fe40004000000ULL,
0x0000000c1b00720bULL, 0x004fe40003f3e000ULL, 0x0000003e0d00720bULL, 0x000fe40003f1e000ULL,
0x0000001b0c0c7208ULL, 0x000fe40004800000ULL, 0x0000000d3e087208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b0c507820ULL, 0x000fe20000410000ULL, 0x0000003f0800720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b051a7823ULL, 0x100fe20000010850ULL, 0x000000083f057208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b441e7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b10447823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b451f7823ULL, 0x100fe20000010850ULL, 0x0000003a0500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b4c1c7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b551b7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b4d1d7823ULL, 0x100fe20000010850ULL, 0x000000053a087208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010850ULL, 0x0000003b0800720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b304c7823ULL, 0x000fe20000010850ULL, 0x000000083b057208ULL, 0x000fe20004000000ULL,
0x0000001a001a7308ULL, 0x000fe60000000800ULL, 0x000000360500720bULL, 0x000fc80003f1e000ULL,
0x0000000536087208ULL, 0x000fe20004000000ULL, 0x0000001b001b7308ULL, 0x000fe60000000800ULL,
0x000000370800720bULL, 0x000fc80003f1e000ULL, 0x0000000837057208ULL, 0x000fe20004000000ULL,
0x0000001c001c7308ULL, 0x000fe60000000800ULL, 0x000000320500720bULL, 0x000fc80003f1e000ULL,
0x0000000532087208ULL, 0x000fe20004000000ULL, 0x0000001d001d7308ULL, 0x000fe60000000800ULL,
0x000000330800720bULL, 0x000fc80003f1e000ULL, 0x00000008330d7208ULL, 0x000fe20004000000ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x0000000b0e00720bULL, 0x000fc60003f1e000ULL,
0x0c401f000d107f89ULL, 0x000ea200000e0000ULL, 0x0000000e0b0e7208ULL, 0x000fc60004000000ULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000510e00720bULL, 0x000fc80003f1e000ULL,
0x0000000e51057208ULL, 0x000fc60004000000ULL, 0x0000004400447308ULL, 0x000fe20000000800ULL,
0x000000480500720bULL, 0x000fc80003f1e000ULL, 0x0000000548087208ULL, 0x000fc60004000000ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x000000490800720bULL, 0x000fe40003f1e000ULL,
0x000000100d00720bULL, 0x004fe40003f3e000ULL, 0x0000000849057208ULL, 0x000fe40004000000ULL,
0x0000000d10107208ULL, 0x000fe20004800000ULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x000000400500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0010457f89ULL, 0x000ea200000e0000ULL,
0x0000000540087208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b34057823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b35347823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b31507823ULL, 0x000fe20000010850ULL,
0x000000410800720bULL, 0x000fe20003f1e000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x00000008410d7208ULL, 0x000fc80004000000ULL, 0x000000140d00720bULL, 0x000fe20003f1e000ULL,
0x0000003800387308ULL, 0x000fe60000000800ULL, 0x0000000d14087208ULL, 0x000fc80004000000ULL,
0x000000150800720bULL, 0x000fe20003f1e000ULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x000000451000720bULL, 0x004fe40003f3e000ULL, 0x0000000815357208ULL, 0x000fe40004000000ULL,
0x00000010450d7208ULL, 0x000fe40004800000ULL, 0x0000002c3500720bULL, 0x000fe20003f1e000ULL,
0x0000004c00087308ULL, 0x0005e40000000800ULL, 0x3fb8aa3b0d557820ULL, 0x000fe20000410000ULL,
0x000000352c0e7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b13547823ULL, 0x100fe20000010855ULL,
0x0000002d0e00720bULL, 0x000fe20003f1e000ULL, 0x0000005000357308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b3b4c7823ULL, 0x104fe20000010855ULL, 0x3fb8aa3b323b7823ULL, 0x100fe20000010855ULL,
0x0000000e2d317208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4e4d7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b56307823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b4f4e7823ULL, 0x100fe20000010855ULL,
0x000000283100720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b47507823ULL, 0x108fe20000010855ULL, 0x3fb8aa3b12477823ULL, 0x100fe20000010855ULL,
0x00000031280e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3a127823ULL, 0x100fe20000010855ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b464f7823ULL, 0x100fe20000010855ULL,
0x000000290e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b33467823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b363a7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010855ULL,
0x0000000e29457208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010855ULL,
0x000000520f00720bULL, 0x000fe20003f1e000ULL, 0x0000005700317308ULL, 0x000fe20000000800ULL,
0x000000244500720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b37377823ULL, 0x000fe20000010855ULL,
0x0000000f520e7208ULL, 0x000fc40004000000ULL, 0x0000004524107208ULL, 0x000fe40004800000ULL,
0x000000530e00720bULL, 0x000fe20003f1e000ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x000000251000720bULL, 0x000fe40003f3e000ULL, 0x0000000e530f7208ULL, 0x000fe40004000000ULL,
0x0000001025457208ULL, 0x000fe40004800000ULL, 0x0000004a0f00720bULL, 0x000fe20003f1e000ULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x000000204500720bULL, 0x000fc40003f3e000ULL,
0x0000000f4a0e7208ULL, 0x000fe40004000000ULL, 0x0000004520107208ULL, 0x000fe40004800000ULL,
0x0000004b0e00720bULL, 0x000fe20003f1e000ULL, 0x0000004700477308ULL, 0x000fe20000000800ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000000e4b0f7208ULL, 0x000fe40004000000ULL,
0x0000001021107208ULL, 0x000fc40004800000ULL, 0x000000420f00720bULL, 0x000fe20003f1e000ULL,
0x0000005400547308ULL, 0x000fe40000000800ULL, 0x0c401f0010457f89ULL, 0x000ea200000e0000ULL,
0x0000000f420e7208ULL, 0x000fc80004000000ULL, 0x000000430e00720bULL, 0x000fe20003f1e000ULL,
0x0000004f004f7308ULL, 0x000fe60000000800ULL, 0x0000000e430f7208ULL, 0x000fc80004000000ULL,
0x000000160f00720bULL, 0x000fe20003f1e000ULL, 0x0000005000507308ULL, 0x000fe60000000800ULL,
0x0000000f160e7208ULL, 0x000fc80004000000ULL, 0x000000170e00720bULL, 0x000fe20003f1e000ULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x000000451000720bULL, 0x004fe40003f3e000ULL,
0x0000000e170f7208ULL, 0x000fe40004000000ULL, 0x0000001045107208ULL, 0x000fe40004800000ULL,
0x0000002e0f00720bULL, 0x000fe20003f1e000ULL, 0x0000001200457308ULL, 0x0005e40000000800ULL,
0x0c201f0010137f89ULL, 0x000ee200000e0000ULL, 0x0000000f2e0e7208ULL, 0x000fc80004000000ULL,
0x0000002f0e00720bULL, 0x000fe20003f1e000ULL, 0x0000003f003f7308ULL, 0x000fe60000000800ULL,
0x0000000e2f0f7208ULL, 0x000fc80004000000ULL, 0x0000002a0f00720bULL, 0x000fe20003f1e000ULL,
0x0000004c004c7308ULL, 0x000fe60000000800ULL, 0x0000000f2a0e7208ULL, 0x000fc80004000000ULL,
0x0000002b0e00720bULL, 0x000fe20003f1e000ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x000000131000720bULL, 0x008fe40003f3e000ULL, 0x0000000e2b0f7208ULL, 0x000fe40004000000ULL,
0x00000010130e7208ULL, 0x000fe40004800000ULL, 0x000000260f00720bULL, 0x000fe20003f1e000ULL,
0x0000003700377308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b0e127820ULL, 0x004fe20000410000ULL,
0x0000000f26107208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b0b0f7823ULL, 0x100fe20000010812ULL,
0x000000271000720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b49137823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b41497823ULL, 0x100fe20000010812ULL, 0x0000000f00327308ULL, 0x000fe20000000800ULL,
0x00000010270b7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b20417823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010812ULL,
0x000000220b00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b15577823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b40367823ULL, 0x100fe20000010812ULL, 0x0000005100337308ULL, 0x0004e20000000800ULL,
0x0000000b22107208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b14567823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b2c557823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b2d5c7823ULL, 0x100fe20000010812ULL,
0x000000231000720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b29587823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b25407823ULL, 0x100fe20000010812ULL, 0x00000048005d7308ULL, 0x0009e20000000800ULL,
0x0000001023107208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b28517823ULL, 0x004fc80000010812ULL,
0x0c401f00100b7f89ULL, 0x000ea200000e0000ULL, 0x000000323314723eULL, 0x008fe200000010ffULL,
0x00000013005e7308ULL, 0x0007620000000800ULL, 0x3fb8aa3b21487823ULL, 0x010fce0000010812ULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x0000004d4e13723eULL, 0x008fce00000010ffULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x0000000b1000720bULL, 0x004fce0003f1e000ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x000000100b0f7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b240b7823ULL, 0x000fe20000010812ULL, 0x0000001c1d12723eULL, 0x000fe400000010ffULL,
0x0000001e1f1c723eULL, 0x000fe200000010ffULL, 0x0c201f000f107f89ULL, 0x000ea200000e0000ULL,
0x00000044111e723eULL, 0x000fe200000010ffULL, 0x0000005700577308ULL, 0x000fe20000000800ULL,
0x000000303111723eULL, 0x000fe400000010ffULL, 0x00000047541f723eULL, 0x000fc400000010ffULL,
0x0000004f501d723eULL, 0x000fc600000010ffULL, 0x0000005100517308ULL, 0x000ff00000000800ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x000000100f00720bULL, 0x004fce0003f1e000ULL,
0x0000005500557308ULL, 0x000fe20000000800ULL, 0x0000000f100f7208ULL, 0x000fe40004000000ULL,
0x0000001a1b10723eULL, 0x000fe200000010ffULL, 0x00000009ff1a7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b0f207820ULL, 0x000fe40000410000ULL,
0x0000005c005c7308ULL, 0x000fe20000000800ULL, 0x3f8000001a1a783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010820ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010820ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010820ULL, 0x3fb8aa3b4b4b7823ULL, 0x000fe20000010820ULL,
0x000000ffff1b7224ULL, 0x000fc400078e001aULL, 0x0000005200157308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010820ULL, 0x3fb8aa3b16257823ULL, 0x000fe20000010820ULL,
0x0000005d5e16723eULL, 0x022fe200000010ffULL, 0x000000ffff2c7224ULL, 0x000fe400078e001aULL,
0x3fb8aa3b2e2e7823ULL, 0x000fe20000010820ULL, 0x0000001a1030723cULL, 0x000fec00000418ffULL,
0x000000ffff2d7224ULL, 0x000fe200078e001aULL, 0x0000005300247308ULL, 0x0002e20000000800ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010820ULL, 0xfffffff8ff527812ULL, 0x004fe200078ee218ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010820ULL, 0x00000003ff5e7819ULL, 0x000fe20000011603ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010820ULL, 0x3fb8aa3b234f7823ULL, 0x000fe20000010820ULL,
0x0000001052547836ULL, 0x000fe20000000000ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x0000000852537836ULL, 0x002fe20000000000ULL, 0x0000000403187810ULL, 0x000fe20007ffe05eULL,
0x00000018525d7836ULL, 0x000fc40000000000ULL, 0x0000000853477824ULL, 0x000fe200078e00ffULL,
0x0000000718187812ULL, 0x000fe200078ec0ffULL, 0x000000085d4d7824ULL, 0x000fe200078e00ffULL,
0x0000004b004b7308ULL, 0x000e620000000800ULL, 0x000000152415723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b17247823ULL, 0x100fe20000010820ULL, 0xfffffff847447812ULL, 0x000fe200078ee218ULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0x0000001a1c30723cULL, 0x000fe20000041830ULL,
0x000000085d5d7824ULL, 0x000fe400078e00ffULL, 0x0000004200217308ULL, 0x000fe80000000800ULL,
0x3fb8aa3b261b7823ULL, 0x000fe20000010820ULL, 0x000000383926723eULL, 0x000fe200000010ffULL,
0x0000000852397824ULL, 0x000fe200078e00ffULL, 0x0000004a4b17723eULL, 0x002fe200000010ffULL,
0x0000002400427308ULL, 0x0003e20000000800ULL, 0x00000008544b7824ULL, 0x000fca00078e00ffULL,
0xfffffff84b477812ULL, 0x000fe200078ee218ULL, 0x3fb8aa3b274b7823ULL, 0x100fe20000010820ULL,
0x0000002e00297308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b2f247823ULL, 0x002fe20000010820ULL,
0x000000454c27723eULL, 0x000fcc00000010ffULL, 0x0000004300287308ULL, 0x0002e20000000800ULL,
0x0000002c142c723cULL, 0x004fee00000418ffULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x0000000852437824ULL, 0x002fca00078e00ffULL, 0xfffffff8434a7812ULL, 0x000fe400078ee218ULL,
0x00000024004e7308ULL, 0x0003220000000800ULL, 0xfffffff84d187812ULL, 0x000fe200078ee218ULL,
0x3fb8aa3b224d7823ULL, 0x000fe20000010820ULL, 0x000000364920723eULL, 0x000fe400000010ffULL,
0x000000565722723eULL, 0x000fe400000010ffULL, 0x000000212821723eULL, 0x008fe200000010ffULL,
0x0000002a00437308ULL, 0x0007e20000000800ULL, 0x0000003c3d24723eULL, 0x002fe200000010ffULL,
0x000000ffff3c7224ULL, 0x100fe200078e001aULL, 0x000000254223723eULL, 0x004fe200000010ffULL,
0x000000ffff3d7224ULL, 0x100fe200078e001aULL, 0x0000003e3f25723eULL, 0x000fe200000010ffULL,
0x000000ffff3e7224ULL, 0x100fe200078e001aULL, 0x000000555c28723eULL, 0x000fe200000010ffULL,
0x0000002b00507308ULL, 0x000e620000000800ULL, 0x000000ffff3f7224ULL, 0x100fe200078e001aULL,
0x00000051582a723eULL, 0x008fe200000010ffULL, 0x0000003c202c723cULL, 0x000fe2000004182cULL,
0x000000294e29723eULL, 0x010fe200000010ffULL, 0x000000ffff517224ULL, 0x000fe200078e001aULL,
0x000000035e367812ULL, 0x000fc400078ec0ffULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000003e2430723cULL, 0x000fe20000041830ULL, 0x00000008543d7824ULL, 0x000fe400078e00ffULL,
0x0000000136367824ULL, 0x000fe200078e0203ULL, 0x00000043502b723eULL, 0x002fe200000010ffULL,
0x000000ffff507224ULL, 0x000fe400078e001aULL, 0x0000004600467308ULL, 0x000e620000000800ULL,
0x0000000736367812ULL, 0x000fc800078ec0ffULL, 0xfffffff839397812ULL, 0x000fe400078ee236ULL,
0xfffffff8533e7812ULL, 0x000fe200078ee236ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0xfffffff83d4c7812ULL, 0x000fe400078ee236ULL, 0x00000050282c723cULL, 0x000fe2000004182cULL,
0xfffffff85d4e7812ULL, 0x000fe400078ee236ULL, 0x000000083536723eULL, 0x000fe400000010ffULL,
0x0000003a3735723eULL, 0x000fe200000010ffULL, 0x0000004800487308ULL, 0x000ea20000000800ULL,
0x0000003b4637723eULL, 0x002fe200000010ffULL, 0x000000ffff3a7224ULL, 0x000fc400078e001aULL,
0x000000ffff3b7224ULL, 0x000fe400078e001aULL, 0x000000ffff507224ULL, 0x000fe400078e0024ULL,
0x0000000500057308ULL, 0x000fe20000000800ULL, 0x000000ffff517224ULL, 0x000fe400078e0026ULL,
0x000000ffff537224ULL, 0x000fe400078e0036ULL, 0x000000ffff247224ULL, 0x000fe200078e0014ULL,
0x000000414842723eULL, 0x004fc400000010ffULL, 0x0000003400347308ULL, 0x000e620000000800ULL,
0x000000ffff267224ULL, 0x000fe400078e0020ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff177224ULL, 0x000fe200078e0023ULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x000000ffff207224ULL, 0x000fe200078e0029ULL,
0x000000053434723eULL, 0x002fcc00000010ffULL, 0x0000004b00387308ULL, 0x000e620000000800ULL,
0x0000100078057824ULL, 0x000fe400078e0209ULL, 0x000000ffff527224ULL, 0x000fe200078e0034ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x0001200005057836ULL, 0x000fc60000000000ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x0000001039087824ULL, 0x000fe400078e0205ULL,
0x000000ffff397224ULL, 0x000fe200078e0012ULL, 0x0000001b3841723eULL, 0x002fc800000010ffULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0x000000ffff1b7224ULL, 0x000fe400078e001aULL,
0x000000ffff387224ULL, 0x000fe400078e0010ULL, 0x000000ffff3a7224ULL, 0x000fe400078e001cULL,
0x000000ffff3b7224ULL, 0x000fe200078e001eULL, 0x0000004d00437308ULL, 0x000fe20000000800ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000104a4a7824ULL, 0x000fe200078e0205ULL,
0x0000003808007844ULL, 0x0005e20000000200ULL, 0x000000ffff117224ULL, 0x000fe200078e0013ULL,
0x0000000b4040723eULL, 0x002fc400000010ffULL, 0x0000004f003c7308ULL, 0x000e620000000800ULL,
0x000000103e3e7824ULL, 0x000fe200078e0205ULL, 0x000000504a007844ULL, 0x0007e20000000200ULL,
0x000000ffff127224ULL, 0x000fe400078e001dULL, 0x000000ffff137224ULL, 0x000fe400078e001fULL,
0x0000001044447824ULL, 0x000fe400078e0205ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0025ULL,
0x000000103e007844ULL, 0x0007e20000000200ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0027ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0035ULL, 0x000000433c43723eULL, 0x002fe200000010ffULL,
0x000000ffff1f7224ULL, 0x000fe400078e0037ULL, 0x000000104c4c7824ULL, 0x100fe400078e0205ULL,
0x000000ffff257224ULL, 0x000fe200078e0016ULL, 0x0000001c44007844ULL, 0x0007e20000000200ULL,
0x0000001a402c723cULL, 0x000fe2000004182cULL, 0x000000ffff277224ULL, 0x000fe400078e0022ULL,
0x0000001047477824ULL, 0x000fc400078e0205ULL, 0x000000ffff347224ULL, 0x000fe200078e0028ULL,
0x000000244c007844ULL, 0x0007e20000000200ULL, 0x000000ffff357224ULL, 0x000fe400078e002aULL,
0x000000ffff367224ULL, 0x000fe400078e0040ULL, 0x000000ffff377224ULL, 0x000fe400078e0042ULL,
0x000000104e4e7824ULL, 0x000fe400078e0205ULL, 0x000000ffff167224ULL, 0x000fe200078e0021ULL,
0x0000003447007844ULL, 0x0007e20000000200ULL, 0x0000001018187824ULL, 0x000fc400078e0205ULL,
0x000000ffff217224ULL, 0x000fe200078e002bULL, 0x000000144e007844ULL, 0x0007e20000000200ULL,
0x000000ffff227224ULL, 0x000fe400078e0041ULL, 0x000000ffff237224ULL, 0x000fe400078e0043ULL,
0x000000ffff317224ULL, 0x000fe400078e0032ULL, 0x000000ffff327224ULL, 0x000fe200078e002cULL,
0x0000002018007844ULL, 0x0007e20000000200ULL, 0x000000ffff337224ULL, 0x000fc400078e002eULL,
0x00000001ff087424ULL, 0x004fe200078e00ffULL, 0x01a0000c19008388ULL, 0x0007e20000000c00ULL,
0x000000ffff057224ULL, 0x000fc600078e000aULL, 0x01a2003019008388ULL, 0x0007e20000000c00ULL,
0x0000005b0600720cULL, 0x000fe20003f06070ULL, 0x01a6080859ff79a7ULL, 0x0007e2000850003fULL,
0x01a6100859ff79a7ULL, 0x0007e2000850003fULL, 0x01a6180859ff79a7ULL, 0x0007e2000850003fULL,
0x01a6200859ff79a7ULL, 0x0007f2000850003fULL, 0xffffff8800d48947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x018000007d007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000007d00008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff7dff7812ULL, 0x040fe4000780c0ffULL,
0x800000007d027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000007d00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe7002d47950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x00000000000004ebULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000668ULL, 0x0000000000000228ULL, 0x0000001500000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000890ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000970ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000009c4ULL, 0x0000000000000700ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010c8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010c8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000001110ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001180ULL, 0x0000000000018d80ULL, 0x0000001500000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000019f00ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000019f40ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000019f40ULL, 0x0000000000000268ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x000000000001a528ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x000000000001a528ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000001110ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000018d80ULL, 0x0000000000018d80ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019f00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000019f40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000268ULL, 0x0000000000000268ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_90_cubin_len = 108152;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
