/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000155d0ULL, 0x0000000000015250ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x00000000000135d0ULL,
0x0000000000000180ULL, 0x000b0022000004c4ULL, 0x0000000000013750ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000013790ULL, 0x0000000000000050ULL, 0x000b002200000519ULL,
0x00000000000137e0ULL, 0x0000000000000120ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000013900ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000135d000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x004c340400288080ULL, 0x0000000000000000ULL,
0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080820828ULL, 0x2880808a08288080ULL,
0x8090082880808e08ULL, 0x0828808093082880ULL, 0x8080950828808094ULL, 0x9708288080960828ULL,
0x2880809b08288080ULL, 0x809d082880809c08ULL, 0x082880809e082880ULL, 0x8080a108288080a0ULL,
0xa308288080a20828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL, 0x08288080a7082880ULL,
0x8080c808288080bdULL, 0x8608288080c90828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808086920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x000135d000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808086ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8908288080820828ULL, 0x2880808a08288080ULL, 0x8090082880808e08ULL, 0x0828808093082880ULL,
0x8080950828808094ULL, 0x9708288080960828ULL, 0x2880809b08288080ULL, 0x809d082880809c08ULL,
0x082880809e082880ULL, 0x8080a108288080a0ULL, 0xa408288080a20828ULL, 0x288080a508288080ULL,
0x80a708288080a608ULL, 0x08288080b2082880ULL, 0x8080c808288080bdULL, 0xb008288080c90828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b0920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000018000000000ULL, 0x0001375000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000bcffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080820828ULL,
0x2880808a08288080ULL, 0x8090082880808e08ULL, 0x0828808093082880ULL, 0x8080950828808094ULL,
0x9708288080960828ULL, 0x2880809b08288080ULL, 0x809d082880809c08ULL, 0x082880809e082880ULL,
0x8080a108288080a0ULL, 0xa308288080a20828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL,
0x08288080a7082880ULL, 0x8080c808288080bdULL, 0x8016288080c90828ULL, 0x0000000310288082ULL,
0x80c9920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000027800000000ULL,
0x0001379000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL, 0x809e288080c90900ULL,
0x0000000000002880ULL, 0x000000b4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080820828ULL,
0x2880808a08288080ULL, 0x8090082880808e08ULL, 0x0828808093082880ULL, 0x8080950828808094ULL,
0x9708288080960828ULL, 0x2880809b08288080ULL, 0x809d082880809c08ULL, 0x08288080a0082880ULL,
0x8080a208288080a1ULL, 0xa508288080a40828ULL, 0x288080a608288080ULL, 0x80bd08288080a708ULL,
0x08288080c8082880ULL, 0x80809e08288080c9ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809e92ULL, 0x0000001cffffffffULL, 0x0000037800000000ULL, 0x000137e000000000ULL,
0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001a00082f04ULL, 0x0008230400000095ULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL,
0x0048190300480160ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL, 0x00000000000c1704ULL,
0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL, 0x00000000000c1704ULL,
0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x0134290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x000000e0000000d0ULL, 0x00001eb000000410ULL, 0x0000208000001f70ULL, 0x00002650000021f0ULL,
0x000026d000002680ULL, 0x00004f4000002720ULL, 0x0000511000004fe0ULL, 0x0000573000005270ULL,
0x000057b000005760ULL, 0x00007d3000005800ULL, 0x00007ef000007dc0ULL, 0x000084c000008050ULL,
0x00008540000084f0ULL, 0x0000ab1000008590ULL, 0x0000acd00000aba0ULL, 0x0000b2b00000ae30ULL,
0x0000b3300000b2e0ULL, 0x0000cc300000b380ULL, 0x00011db00000cc40ULL, 0x00011e0000011df0ULL,
0x00011e6000011e10ULL, 0x00011ea000011e80ULL, 0x00012b5000011eb0ULL, 0x00012bf000012ba0ULL,
0x00012ca000012c40ULL, 0x00012d5000012d00ULL, 0x00012de000012da0ULL, 0x00012e9000012e30ULL,
0x00012f3000012ee0ULL, 0x00012fd000012f80ULL, 0x0001308000013020ULL, 0x00013120000130d0ULL,
0x000131c000013170ULL, 0x0001327000013210ULL, 0x00013310000132c0ULL, 0x000133d000013370ULL,
0x0001349000013430ULL, 0x00013550000134f0ULL, 0x04403904000135b0ULL, 0x000000ff00000220ULL,
0x003f01000000f600ULL, 0x0000000b000002a0ULL, 0x003f01200000f608ULL, 0x0000000b00000390ULL,
0x003f01200000f688ULL, 0x0000000b000003c0ULL, 0x003f01200000f6a8ULL, 0x0000000b000003f0ULL,
0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000000300000560ULL,
0x003f01020000f68cULL, 0x00000003000005f0ULL, 0x003f01010000f688ULL, 0x0000000800000d60ULL,
0x003f01070000f6a8ULL, 0x0000000800000e70ULL, 0x003f01010000f6a8ULL, 0x0000000a00000ed0ULL,
0x003f010100000020ULL, 0x0000000d00001030ULL, 0x003f010500000004ULL, 0x0000000d00001210ULL,
0x003f010500000004ULL, 0x0000004600001a30ULL, 0x003f01070000f6a8ULL, 0x0000004600001b20ULL,
0x003f01010000f6a8ULL, 0x0000001000001b80ULL, 0x003f01010000f608ULL, 0x0000000a00001bd0ULL,
0x003f01050000f60cULL, 0x0000000a00001da0ULL, 0x003f01050000f60cULL, 0x00000022000023b0ULL,
0x003f01050000f6acULL, 0x0000002200002580ULL, 0x003f01050000f6acULL, 0x0000000d00003ff0ULL,
0x003f010100000000ULL, 0x0000005600004070ULL, 0x003f01010000f688ULL, 0x0000000d000040f0ULL,
0x003f010500000004ULL, 0x0000000d000042c0ULL, 0x003f010500000004ULL, 0x0000005300004b10ULL,
0x003f01070000f6a8ULL, 0x0000005300004c00ULL, 0x003f01010000f6a8ULL, 0x0000002200004c60ULL,
0x003f01010000f628ULL, 0x0000004800004cc0ULL, 0x003f01050000f62cULL, 0x0000004800004e90ULL,
0x003f01050000f62cULL, 0x0000001e00005460ULL, 0x003f01050000f6acULL, 0x0000002200005650ULL,
0x003f01050000f6acULL, 0x0000000d00006f00ULL, 0x003f010100000000ULL, 0x0000005600006f70ULL,
0x003f01010000f690ULL, 0x0000000d00006fd0ULL, 0x003f010500000004ULL, 0x0000000d000071a0ULL,
0x003f010500000004ULL, 0x00000054000078f0ULL, 0x003f010700000000ULL, 0x0000001e00007a30ULL,
0x003f01010000f6a8ULL, 0x0000001d00007a90ULL, 0x003f01010000f648ULL, 0x0000001d00007ab0ULL,
0x003f01050000f64cULL, 0x0000001d00007c80ULL, 0x003f01050000f64cULL, 0x0000005300008220ULL,
0x003f01050000f6acULL, 0x00000053000083f0ULL, 0x003f01050000f6acULL, 0x0000000d00009cd0ULL,
0x003f010100000000ULL, 0x0000005600009d40ULL, 0x003f01010000f698ULL, 0x0000000f00009dd0ULL,
0x003f01050000f6ccULL, 0x0000000f00009fa0ULL, 0x003f01050000f6ccULL, 0x000000520000a6f0ULL,
0x003f010700000000ULL, 0x000000530000a810ULL, 0x003f01010000f6a8ULL, 0x0000001b0000a870ULL,
0x003f01010000f668ULL, 0x0000001b0000a890ULL, 0x003f01050000f66cULL, 0x0000001b0000aa60ULL,
0x003f01050000f66cULL, 0x000000550000b010ULL, 0x003f01050000f6acULL, 0x000000550000b1e0ULL,
0x003f01050000f6acULL, 0x0000000d0000c9f0ULL, 0x003f010100000000ULL, 0x000000560000ca50ULL,
0x003f01010000f6a0ULL, 0x000000ff0000d820ULL, 0x003f01010000f600ULL, 0x000000ff0000e310ULL,
0x003f01050000f604ULL, 0x000000ff0000e4e0ULL, 0x003f01050000f604ULL, 0x000000ff0000e710ULL,
0x003f01010000f600ULL, 0x000000ff0000e740ULL, 0x003f01050000f604ULL, 0x000000ff0000e900ULL,
0x003f01050000f604ULL, 0x00000034000111d0ULL, 0x003f010100000000ULL, 0x00000034000112e0ULL,
0x003f010500000004ULL, 0x00000034000114b0ULL, 0x003f010500000004ULL, 0x00000036000129b0ULL,
0x003f010100000000ULL, 0x0000003600012a10ULL, 0x003f010100000008ULL, 0x0000003600012a70ULL,
0x003f010100000010ULL, 0x0000003600012ae0ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL,
0x0000d7700000d500ULL, 0x0000ea100000e960ULL, 0x0000040100012b20ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000044cULL, 0x0000001a00000002ULL, 0x0000000000000354ULL, 0x0000001a00000002ULL,
0x0000000000000264ULL, 0x0000001a00000002ULL, 0x0000000000000154ULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000428ULL, 0x0000001a00000002ULL,
0x000000000000032dULL, 0x0000001a00000002ULL, 0x000000000000023aULL, 0x0000001a00000002ULL,
0x000000000000012aULL, 0x0000001a00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x00000004ff1b7424ULL, 0x000fe400078e00ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x0000000000037919ULL, 0x000ee80000002200ULL, 0x0000000000047919ULL, 0x000f280000000000ULL,
0x0000000000187919ULL, 0x000f280000002600ULL, 0x0000000000107919ULL, 0x000f220000002700ULL,
0x00000005ff197819ULL, 0x002fc6000001160bULL, 0x00001fff020a7589ULL, 0x0043e800000e0000ULL,
0x00001fff19197589ULL, 0x000ea200000e0000ULL, 0x0000010002007a24ULL, 0x008fe400078e0203ULL,
0x0000001300037300ULL, 0x000ee400000e0000ULL, 0x00000000000b7a24ULL, 0x000fe400078e020bULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x0000000818067824ULL, 0x010fc400078e00ffULL,
0x000000ff0b00720cULL, 0x040fe20003f45270ULL, 0x0000001300137309ULL, 0x000f220000000000ULL,
0x0000007f0b00780cULL, 0x000fe20003f84070ULL, 0x0000001007087224ULL, 0x000fe200078e0206ULL,
0x0000000f0b00780cULL, 0x040fe20003f64070ULL, 0x00006000101a7625ULL, 0x000fe200078e001bULL,
0x000000030b00780cULL, 0x000fe40003f24070ULL, 0x000000040300720cULL, 0x008fca0003f02070ULL,
0x3fffff80ff02a424ULL, 0x002fe400078e00ffULL, 0x000000040a097824ULL, 0x004fe400078e0219ULL,
0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL, 0x0000000209097824ULL, 0x000fe200078e00ffULL,
0x00000004ff0d7819ULL, 0x000fe20000011600ULL, 0xff317217ff12c424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e40000000a00ULL, 0x00000008090c7817ULL, 0x000fe20007800000ULL,
0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x7fffffc0ff05b424ULL, 0x000fe200078e00ffULL, 0x00f400120b00c388ULL, 0x0005e20000004800ULL,
0x000000010c0c7824ULL, 0x000fc400078e0a09ULL, 0x0000000109097824ULL, 0x000fe200078e020dULL,
0x00f608040b00b388ULL, 0x0007e20000008a00ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x0000000c0d00720cULL, 0x000fe20003f66070ULL, 0x00000100ff037424ULL, 0x002fe400078e00ffULL,
0x0000000108027824ULL, 0x000fe200078e0209ULL, 0x000000f00e117812ULL, 0x000fe200078ec0ffULL,
0x00000001090f7824ULL, 0x040fe400078e0200ULL, 0x0000001009127824ULL, 0x004fc400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0xfffffff0120f7812ULL, 0x000fe200078ee20fULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x0000001102027210ULL, 0x000fe20007f9e0ffULL,
0x7fffff60ff079424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff049424ULL, 0x008fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe200078e00ffULL, 0x00f688060b009388ULL, 0x0009e20000008a00ULL,
0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f6a8040b009388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fc400020e0603ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x00f6c8080b00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff067224ULL, 0x010fc600078e0a13ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020f7faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000061a1a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0a00720cULL, 0x000fc40003f05270ULL,
0x000000ff1a067810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff027819ULL, 0x000fce0000011606ULL,
0x0000d25000008947ULL, 0x000fea0003800000ULL, 0x0000000819037824ULL, 0x000fe400078e00ffULL,
0x00000003ff047424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f68c0403ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000210077824ULL, 0x000fe200078e00ffULL,
0x0000580018087a10ULL, 0x000fe20007ffe0ffULL, 0x00f6880003ff7f8cULL, 0x0005e2000c80043fULL,
0x00000001ff047819ULL, 0x002fc60000011619ULL, 0x0000580007067a24ULL, 0x000fe200078e0208ULL,
0x0000000119077812ULL, 0x000fe200078ec0ffULL, 0x0000002004057824ULL, 0x000fc800078e00ffULL,
0x0000620006087a24ULL, 0x000fe200078e0205ULL, 0x000003c000000947ULL, 0x000fea0003800000ULL,
0x000000051a0a7217ULL, 0x004fe20007800000ULL, 0x0000001007097824ULL, 0x000fe200078e00ffULL,
0x00000003ff0b7819ULL, 0x100fe20000011600ULL, 0x00000080ff157424ULL, 0x000fe200078e00ffULL,
0x000000700e1b7812ULL, 0x000fe200078ec0ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a05ULL,
0x000000040b0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001090d7824ULL, 0x000fe200078e020bULL,
0x0000000c0b107810ULL, 0x000fe40007ffe0ffULL, 0x000000090a0a7217ULL, 0x000fe20007800000ULL,
0x000000010d0c7824ULL, 0x000fc400078e0200ULL, 0x000000080d137824ULL, 0x000fe400078e00ffULL,
0x000000010a0a7824ULL, 0x000fe400078e0a09ULL, 0x0000000109117824ULL, 0x000fe200078e020fULL,
0xfffffff8130c7812ULL, 0x000fe200078ee20cULL, 0x0000000109137824ULL, 0x000fe200078e0210ULL,
0x0000000a0f00720cULL, 0x080fe20003f46070ULL, 0x0000000811127824ULL, 0x000fe200078e00ffULL,
0x000000080b0f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108147824ULL, 0x000fe200078e0213ULL,
0x0000000a0b00720cULL, 0x080fe20003f66070ULL, 0x00000001110b7824ULL, 0x000fe200078e0200ULL,
0x0000000a0f00720cULL, 0x080fe20003f26070ULL, 0x00000001090f7824ULL, 0x000fe200078e020fULL,
0x0000000a1000720cULL, 0x000fe20003f06070ULL, 0x0000000108097824ULL, 0x000fe200078e020dULL,
0xfffffff812107812ULL, 0x000fe200078ee20bULL, 0x00000001080a7824ULL, 0x000fe200078e0211ULL,
0x0000b00004117811ULL, 0x000fe200078e68ffULL, 0x00000001080b7824ULL, 0x000fc400078e020fULL,
0x00005e0009087625ULL, 0x000fc800078e0015ULL, 0x000000010f0d7824ULL, 0x140fe200078e0200ULL,
0x0000001b080e7210ULL, 0x000fe20007f9e0ffULL, 0x000000080f127824ULL, 0x000fe400078e00ffULL,
0x00000001130f7824ULL, 0x040fe400078e0200ULL, 0x0000000813167824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20dULL, 0x000000100c137824ULL, 0x000fe400078e0211ULL,
0x00005e00140c7625ULL, 0x000fe200078e0015ULL, 0xfffffff816167812ULL, 0x000fc600078ee20fULL,
0x000000ffff0f7224ULL, 0x000fe200020e0609ULL, 0x0000001b0c0c7210ULL, 0x000fe20007fde0ffULL,
0x00005e000a087625ULL, 0x000fc600078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e137faeULL, 0x0003e2000d901c46ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0015ULL,
0x0000001b08087210ULL, 0x000fc60007f9e0ffULL, 0x0000001010157824ULL, 0x000fe200078e0211ULL,
0x0000001b0a0a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe400020e0609ULL,
0x0000001012177824ULL, 0x000fe400078e0211ULL, 0x000000ffff0b7224ULL, 0x000fe200028e060bULL,
0x0000000008157faeULL, 0x0003e2000d101c46ULL, 0x0000001016117824ULL, 0x000fe400078e0211ULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x000000000a177faeULL, 0x0003e8000c901c46ULL,
0x000000000c117faeULL, 0x0003e2000c101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x0000001007097824ULL, 0x004fe200078e00ffULL, 0x000000700e177812ULL, 0x000fe200078ec0ffULL,
0x00000080ff157424ULL, 0x000fc600078e00ffULL, 0x0000000900097211ULL, 0x000fc800078fe8ffULL,
0x00000008090f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x040fe200078e0200ULL,
0x0000000c09117810ULL, 0x040fe20007ffe0ffULL, 0x00000008090b7824ULL, 0x000fe400078e00ffULL,
0x000000080f1b7824ULL, 0x000fe400078e00ffULL, 0x0000000108137824ULL, 0x040fe200078e0211ULL,
0xfffffff80b107812ULL, 0x000fe200078ee20aULL, 0x00000001080a7824ULL, 0x000fe200078e0209ULL,
0x00000004090b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811167824ULL, 0x000fc800078e00ffULL,
0x00000001080c7824ULL, 0x040fe400078e020bULL, 0x000000010b0d7824ULL, 0x040fe400078e0200ULL,
0x000000080b127824ULL, 0x000fe400078e00ffULL, 0x00000001080b7824ULL, 0x000fe400078e020fULL,
0x00005e000a087625ULL, 0x000fe200078e0015ULL, 0xfffffff812127812ULL, 0x000fc600078ee20dULL,
0x000000010f0a7824ULL, 0x100fe200078e0200ULL, 0x00000017080e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001110f7824ULL, 0x000fc600078e0200ULL, 0xfffffff81b147812ULL, 0x000fe200078ee20aULL,
0x00005e000b0a7625ULL, 0x000fe200078e0015ULL, 0xfffffff816167812ULL, 0x000fe400078ee20fULL,
0x0000b000041b7811ULL, 0x000fe200078e68ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0609ULL,
0x000000170a0a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e000c087625ULL, 0x000fc800078e0015ULL,
0x00005e00130c7625ULL, 0x000fe200078e0015ULL, 0x0000001708087210ULL, 0x000fc60007f1e0ffULL,
0x0000001010117824ULL, 0x100fe200078e021bULL, 0x000000170c0c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001012137824ULL, 0x000fe400078e021bULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e2000b901c46ULL,
0x0000001014157824ULL, 0x000fe400078e021bULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000000008137faeULL, 0x0003e2000b901c46ULL, 0x0000001016177824ULL, 0x000fc400078e021bULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000000a157faeULL, 0x0003e8000b901c46ULL,
0x000000000c177faeULL, 0x0003e4000b901c46ULL, 0x0000001004087824ULL, 0x002fe200078e00ffULL,
0x000000ff0200720cULL, 0x000fe20003f05270ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x0000f6a8040a7811ULL, 0x000fe200078e18ffULL, 0x00000000080473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a80008587f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000020000a0a7f8cULL, 0x000ee2000c80043fULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000bb4000008947ULL, 0x000fea0003800000ULL,
0x000000ffff207224ULL, 0x008fe400078e000bULL, 0xff317217ff5c7424ULL, 0x000fc400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc400078e00ffULL, 0x000001000b0d7824ULL, 0x002fca00078e00ffULL,
0x0000001a0d00720cULL, 0x000fda0003f06070ULL, 0x0000ba8000000947ULL, 0x004fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e001dULL, 0x00000000000e7805ULL, 0x000fca0000015200ULL,
0x0000f6c8040d7811ULL, 0x000fca00078e18ffULL, 0x000004000d117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x008fe40007804820ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e137210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc80000011411ULL,
0x000000130a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x000000020a0a7819ULL, 0x000fc80000001211ULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x000004000d117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x008fe40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010b0f7810ULL, 0x040fe20007ffe0ffULL,
0x000001000b0e7824ULL, 0x000fc600078e0205ULL, 0x000000020f00720cULL, 0x000fe40003f06070ULL,
0x000000400e117810ULL, 0x000fe40007ffe0ffULL, 0x000000011d0f7812ULL, 0x000fc600078e0cffULL,
0x0000620006187a24ULL, 0x000fcc00078e0211ULL, 0x000003e000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1c7819ULL, 0x000fe20000011600ULL, 0x00000010071f7824ULL, 0x000fe200078e00ffULL,
0x000000111a0a7217ULL, 0x000fe20007800000ULL, 0x00000080ff237424ULL, 0x000fe200078e00ffULL,
0x000000041c127810ULL, 0x040fe20007ffe0ffULL, 0x000000011f137824ULL, 0x000fe200078e021cULL,
0x000000081c207810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0a7824ULL, 0x000fe400078e0a11ULL,
0x0000000113107824ULL, 0x040fe400078e0200ULL, 0x00000008131b7824ULL, 0x000fe200078e00ffULL,
0x0000000a1f0a7217ULL, 0x000fe20007800000ULL, 0x0000001000117824ULL, 0x000fc400078e00ffULL,
0x0000000204147824ULL, 0x000fe200078e020fULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee210ULL,
0x0000000113107824ULL, 0x000fe200078e0218ULL, 0x0000007011457812ULL, 0x000fe200078ec0ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a1fULL, 0x0000b00014147811ULL, 0x000fe200078e60ffULL,
0x00005e0010107625ULL, 0x000fc600078e0023ULL, 0x0000000a1200720cULL, 0x080fe20003f06070ULL,
0x000000011f137824ULL, 0x040fe200078e0212ULL, 0x0000004510127210ULL, 0x000fe20007fde0ffULL,
0x000000011f477824ULL, 0x000fe200078e0220ULL, 0x0000000a1c00720cULL, 0x040fe20003fa6070ULL,
0x0000000113107824ULL, 0x040fe200078e0218ULL, 0x0000000c1c1c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001131e7824ULL, 0x040fe400078e0200ULL, 0x0000000813217824ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fc400030e0611ULL, 0x00005e0010107625ULL, 0x000fe200078e0023ULL,
0xfffffff821217812ULL, 0x000fc600078ee21eULL, 0x000000101b1b7824ULL, 0x000fe200078e0214ULL,
0x00000045101e7210ULL, 0x000fe20007fde0ffULL, 0x0000000147107824ULL, 0x000fe400078e0218ULL,
0x000000011f497824ULL, 0x000fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121b7faeULL, 0x0007e2000e901c46ULL, 0x000000ffff1f7224ULL, 0x000fe200030e0611ULL,
0x0000000a2000720cULL, 0x080fe20003fa6070ULL, 0x0000001021217824ULL, 0x000fe200078e0214ULL,
0x0000000a1c00720cULL, 0x000fe20003fc6070ULL, 0x00005e0010107625ULL, 0x000fc600078e0023ULL,
0x000000001e217faeULL, 0x0009e2000c101c46ULL, 0x00000001490a7824ULL, 0x000fe200078e0218ULL,
0x0000004510107210ULL, 0x000fe20007f1e0ffULL, 0x0000000147187824ULL, 0x040fe400078e0200ULL,
0x00000008471b7824ULL, 0x008fe400078e00ffULL, 0x00005e000a127625ULL, 0x000fc600078e0023ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee218ULL, 0x00000001490a7824ULL, 0x040fe400078e0200ULL,
0x0000000849237824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000004512127210ULL, 0x000fe20007f1e0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e0214ULL,
0xfffffff823237812ULL, 0x000fc600078ee20aULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x00000000101b7faeULL, 0x0007e2000e901c46ULL, 0x00000010231f7824ULL, 0x010fca00078e0214ULL,
0x00000000121f7faeULL, 0x0007e2000f101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001007117824ULL, 0x000fe400078e00ffULL, 0x00000080ff1f7424ULL, 0x000fc600078e00ffULL,
0x0000001100117211ULL, 0x000fc800078fe8ffULL, 0x0000000411137810ULL, 0x040fe20007ffe0ffULL,
0x00000001110a7824ULL, 0x140fe200078e0200ULL, 0x0000000811217810ULL, 0x040fe20007ffe0ffULL,
0x00000008111b7824ULL, 0x040fe200078e00ffULL, 0x0000000c11477810ULL, 0x000fe20007ffe0ffULL,
0x0000000113107824ULL, 0x040fe400078e0200ULL, 0x0000000813237824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL, 0x00000010000a7824ULL, 0x000fe400078e00ffULL,
0x0000000147147824ULL, 0x000fe200078e0200ULL, 0xfffffff823237812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x000fe200078e0218ULL, 0x000000700a457812ULL, 0x000fe200078ec0ffULL,
0x0000000847497824ULL, 0x000fc400078e00ffULL, 0x00005e0010107625ULL, 0x000fc600078e001fULL,
0xfffffff849497812ULL, 0x000fe200078ee214ULL, 0x00000001130a7824ULL, 0x100fe200078e0218ULL,
0x0000004510207210ULL, 0x000fe20007f1e0ffULL, 0x0000000121127824ULL, 0x100fe400078e0218ULL,
0x00000001471e7824ULL, 0x000fe400078e0218ULL, 0x0000000204107824ULL, 0x000fe400078e020fULL,
0x0000000121137824ULL, 0x040fe400078e0200ULL, 0x0000000821187824ULL, 0x000fe200078e00ffULL,
0x0000b00010147811ULL, 0x000fe200078e60ffULL, 0x000000ffff217224ULL, 0x000fc400000e0611ULL,
0x00005e000a107625ULL, 0x000fe200078e001fULL, 0xfffffff818477812ULL, 0x000fc600078ee213ULL,
0x00005e0012127625ULL, 0x000fe200078e001fULL, 0x0000004510107210ULL, 0x000fc60007f1e0ffULL,
0x00005e001e1e7625ULL, 0x000fe200078e001fULL, 0x0000004512127210ULL, 0x000fc60007fbe0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0214ULL, 0x000000451e1e7210ULL, 0x000fe20007fde0ffULL,
0x0000001023237824ULL, 0x100fe400078e0214ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000201b7faeULL, 0x0007e2000b901c46ULL,
0x0000001047457824ULL, 0x100fe400078e0214ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x0000000010237faeULL, 0x0007e2000b901c46ULL, 0x0000001049477824ULL, 0x000fc400078e0214ULL,
0x000000ffff1f7224ULL, 0x000fe200030e061fULL, 0x0000000012457faeULL, 0x0007e8000b901c46ULL,
0x000000001e477faeULL, 0x0007e4000b901c46ULL, 0xfffffff0030a7812ULL, 0x040fe200078ec0ffULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000001003117812ULL, 0x008fe400078ec0ffULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x000000080f467824ULL, 0x000fe200078e020aULL,
0xffffffe0030a7812ULL, 0x000fc800078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000010a107824ULL, 0x000fe200078e0211ULL, 0x0000f6a846547810ULL, 0x000fc60007ffe0ffULL,
0x0000000807107824ULL, 0x000fc400078e0210ULL, 0x00000000540403c2ULL, 0x000ee40000060000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20001f0f070ULL,
0xffffff8000003947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80046467f8cULL, 0x000ee2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60800101e7f8cULL, 0x0002e4000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x0000001008137812ULL, 0x000fca00078ec0ffULL, 0x000000010a0a7824ULL, 0x000fc800078e0213ULL,
0x00000008070a7824ULL, 0x000fca00078e020aULL, 0x00f60c000a137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x00afe4000780481fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012101b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001b12127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c000a137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x0000002019107824ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fe200078e00ffULL, 0x000000700a207812ULL, 0x000fc400078ec0ffULL,
0xffffff8010107812ULL, 0x000fe400078ec0ffULL, 0x0000000c11117812ULL, 0x000fc800078ec0ffULL,
0x00000010110a7210ULL, 0x000fca0007ffe020ULL, 0x00f000000a1b7984ULL, 0x000e680000000800ULL,
0x00f200000a187984ULL, 0x0006a20000000800ULL, 0x0000005c1b00720bULL, 0x002fe20003f1d000ULL,
0x00010c827f007947ULL, 0x000fd8000b800000ULL, 0x00000000000a7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0a217812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff517224ULL, 0x000fc400078e005cULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff147424ULL, 0x000fca00078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x000fe40000011619ULL,
0x0000005c1b00720bULL, 0x000fe40003f14000ULL, 0x000000191c00720cULL, 0x000fe20003fa5270ULL,
0x00010c127f007947ULL, 0x000fd4000b800000ULL, 0x00000000001c7806ULL, 0x000fc400000e0100ULL,
0x00000080191ed824ULL, 0x000fe200078e0220ULL, 0x0000001b5c517209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099101c1f7816ULL, 0x000fe200000000ffULL,
0x00000001111ed824ULL, 0x000fc600078e021eULL, 0x000000ff1f00720cULL, 0x000fe40003f05270ULL,
0x00f400511e00d388ULL, 0x0003f60000000800ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000515c1e7221ULL, 0x002fe20000010000ULL, 0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00457308ULL, 0x0002ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x002fe20000011600ULL, 0x00010b527f007947ULL, 0x000fea000b800000ULL,
0x00001f1e451e7589ULL, 0x0082e400000e0000ULL, 0x0000001e28287220ULL, 0x088fe20000410000ULL,
0x0000001e29297220ULL, 0x080fe20000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001e30307220ULL, 0x080fe20000410000ULL,
0x0000001e31317220ULL, 0x080fe20000410000ULL, 0x0000001e34347220ULL, 0x080fe20000410000ULL,
0x0000001e35357220ULL, 0x080fe20000410000ULL, 0x0000001e38387220ULL, 0x080fe20000410000ULL,
0x0000001e39397220ULL, 0x080fe20000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001e3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001e40407220ULL, 0x080fe20000410000ULL,
0x0000001e41417220ULL, 0x080fe20000410000ULL, 0x0000001e24247220ULL, 0x080fe20000410000ULL,
0x0000001e25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000004509097220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x002fe200078ff0ffULL,
0x00010a327f007947ULL, 0x000fea000b800000ULL, 0x00001f1e451e7589ULL, 0x0002e400000e0000ULL,
0x0000001e2a2a7220ULL, 0x088fe20000410000ULL, 0x0000001e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001e32327220ULL, 0x080fe20000410000ULL, 0x0000001e33337220ULL, 0x080fe20000410000ULL,
0x0000001e36367220ULL, 0x080fe20000410000ULL, 0x0000001e37377220ULL, 0x080fe20000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001e42427220ULL, 0x080fe20000410000ULL, 0x0000001e43437220ULL, 0x080fe20000410000ULL,
0x0000001e26267220ULL, 0x080fe20000410000ULL, 0x0000001e27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff21ff7812ULL, 0x000fda000780601cULL,
0x800000511b1b0221ULL, 0x000fe20000010000ULL, 0x00007610ff0a0816ULL, 0x000fc6000000000aULL,
0x3fb8aa3b1b1b0820ULL, 0x000fc80000410000ULL, 0x0000001b00150308ULL, 0x000e640000000800ULL,
0x0000001518180220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000918097221ULL, 0x004fc20000010000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x000000081d227824ULL, 0x000fca00078e0208ULL, 0x00f6ac0022187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e1b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000121207824ULL, 0x000fe200000e0e1fULL,
0x003d09001b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011420ULL, 0x0000001b18187211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e0620ULL, 0x0000000218187819ULL, 0x000fc8000000121bULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0022187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100a187816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000015ff16723eULL, 0x000fe400000010ffULL,
0x00000002ff187819ULL, 0x000fe40000011600ULL, 0x00005410161b7816ULL, 0x000fe20000000016ULL,
0x000106227f007947ULL, 0x000fea000b800000ULL, 0x00001f181b177589ULL, 0x0002a400000e0000ULL,
0x0000000818167810ULL, 0x000fe20007ffe0ffULL, 0x000106527f007947ULL, 0x000fea000b800000ULL,
0x00001f161b167589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010181e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200078e001bULL,
0x000026e000497802ULL, 0x000fc40000000f00ULL, 0x000110b000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018181e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x004fe200078e001bULL, 0x0000273000497802ULL, 0x000fc40000000f00ULL,
0x0001106000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007001b7812ULL, 0x00afe200078ec0ffULL, 0x0000020019187824ULL, 0x000fe200078e00ffULL,
0x00000004ff577819ULL, 0x100fe20000011600ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000081b447812ULL, 0x000fc400078ef800ULL, 0xfffff800184d7812ULL, 0x000fe200078ec0ffULL,
0x00000004041b7824ULL, 0x000fc800078e0257ULL, 0x0000000144487824ULL, 0x040fe400078e021bULL,
0x00000008441b7824ULL, 0x000fca00078e00ffULL, 0xfffffff81b187812ULL, 0x000fe400078ee248ULL,
0x00000008001b7812ULL, 0x000fc600078ec0ffULL, 0x0000001018187824ULL, 0x000fc400078e024dULL,
0x000000071b587812ULL, 0x000fe200078ef800ULL, 0x0000000407577824ULL, 0x000fe200078e0257ULL,
0x0000000248487810ULL, 0x000fe20007ffe0ffULL, 0x00000002041c7824ULL, 0x000fe200078e021dULL,
0x00000010584a7812ULL, 0x040fe200078efcffULL, 0x00000001581b7824ULL, 0x000fe200078e0257ULL,
0x000099100a4f7816ULL, 0x000fe200000000ffULL, 0x00000008581e7824ULL, 0x000fe200078e00ffULL,
0x0000b0001c4e7811ULL, 0x000fe200078e60ffULL, 0x00000001574c7824ULL, 0x000fe200078e024aULL,
0x000000021b457810ULL, 0x000fe20007ffe0ffULL, 0x0000000858207824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1c7812ULL, 0x000fe200078ee21bULL, 0x000000084a1b7824ULL, 0x000fe200078e00ffULL,
0x000000ff4f00720cULL, 0x000fe20003fa5270ULL, 0x00000008444b7824ULL, 0x000fe200078e00ffULL,
0xfffffff820457812ULL, 0x000fe200078ee245ULL, 0x000000101c1c7824ULL, 0x000fe200078e024eULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee24cULL, 0x000000084a537824ULL, 0x000fe200078e00ffULL,
0xfffffff84b0a7812ULL, 0x000fe200078ee248ULL, 0x0000001045207824ULL, 0x100fe200078e024eULL,
0x000000024c447810ULL, 0x000fe20007ffe0ffULL, 0x000000101b497824ULL, 0x000fe200078e024eULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0x000000100a0a7824ULL, 0x000fe200078e024dULL,
0xfffffff853447812ULL, 0x000fc400078ee244ULL, 0x000000002020783bULL, 0x004ea60000004200ULL,
0x00000010444c7824ULL, 0x000fe200078e024eULL, 0x000000004948783bULL, 0x000eea0000004200ULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x00000010ff6a7819ULL, 0x002fc4000001161cULL,
0x00000018ff7b7819ULL, 0x000fe4000001161eULL, 0x000000ff226d7812ULL, 0x004fe400078ec0ffULL,
0x00000018ff747819ULL, 0x000fe40000011623ULL, 0x00000010ff627819ULL, 0x108fe40000011649ULL,
0x000000ff49667812ULL, 0x000fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fc40000011649ULL,
0x0000ffff49687812ULL, 0x000fe400078ec0ffULL, 0x000000ff6a497812ULL, 0x000fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe4000001161fULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000018ff767819ULL, 0x000fe40000011620ULL, 0x00000018ff6c7819ULL, 0x000fe20000011621ULL,
0x20000049ff877230ULL, 0x000fe20000004100ULL, 0x00000018ff717819ULL, 0x000fc40000011622ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000010ff5f7819ULL, 0x100fe4000001164bULL,
0x000000ff4b6f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe4000001164bULL,
0x0000ffff4b607812ULL, 0x000fe400078ec0ffULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000080ff4b723eULL, 0x000fe200020006ffULL,
0x2000007bff6a7230ULL, 0x000fe20000004100ULL, 0x0000ffff1d7d7812ULL, 0x000fe400078ec0ffULL,
0x00000076ff49723eULL, 0x000fe200020006ffULL, 0x2000004bff7b7230ULL, 0x000fe20000004100ULL,
0x0000ffff1c827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff817819ULL, 0x000fe2000001161dULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x0000ffff1f797812ULL, 0x000fc400078ec0ffULL,
0x000000ff20757812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000071ff76723eULL, 0x000fe200020006ffULL, 0x2000006dff717230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe2000001161eULL, 0x20000074ff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe4000001161fULL, 0x0000ffff1e777812ULL, 0x000fc400078ec0ffULL,
0x000000ff1f857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x000fe40000011620ULL,
0x00000010ff5a7819ULL, 0x000fe40000011621ULL, 0x000000ff21787812ULL, 0x040fe400078ec0ffULL,
0x0000ffff21697812ULL, 0x000fe400078ec0ffULL, 0x000000ff4a677812ULL, 0x000fc400078ec0ffULL,
0x00000008ff7d7819ULL, 0x000fe4000001167dULL, 0x00000066ff74723eULL, 0x000fe400020006ffULL,
0x0000ffff20207812ULL, 0x000fe400078ec0ffULL, 0x00000010ff217819ULL, 0x000fe40000011622ULL,
0x00000008ff827819ULL, 0x000fe40000011682ULL, 0x000000ff81817812ULL, 0x000fc400078ec0ffULL,
0x00000008ff797819ULL, 0x000fe40000011679ULL, 0x00000075ff4b723eULL, 0x000fe200020006ffULL,
0x2000006cff757230ULL, 0x000fe20000004100ULL, 0x000000ff48557812ULL, 0x000fe200078ec0ffULL,
0x20000076ff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fc4000001164aULL, 0x00000008ff777819ULL, 0x000fe40000011677ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000067ff76723eULL, 0x000fe200020006ffULL, 0x20000074ff677230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fe20000011669ULL, 0x20000085ff807230ULL, 0x000fe20000004100ULL,
0x0000ffff22227812ULL, 0x000fe200078ec0ffULL, 0x2000007dff867230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fc40000011623ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000082ff857230ULL, 0x000fe20000004100ULL, 0x00000008ff207819ULL, 0x000fe20000011620ULL,
0x20000081ff887230ULL, 0x000fe20000004100ULL, 0x000000ff21217812ULL, 0x000fe200078ec0ffULL,
0x20000079ff7d7230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fc400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x2000007cff817230ULL, 0x000fe20000004100ULL, 0x0000006fff74723eULL, 0x000fe200020006ffULL,
0x2000007aff827230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x20000055ff667230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x000000ff59597812ULL, 0x000fe200078ec0ffULL, 0x20000077ff7c7230ULL, 0x000fe20000004100ULL,
0x0000005bff6f723eULL, 0x000fe200020006ffULL, 0x20000056ff557230ULL, 0x000fe20000004100ULL,
0x000000ff23727812ULL, 0x000fe200078ec0ffULL, 0x20000076ff567230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x000000ff5a5b7812ULL, 0x000fe200078ec0ffULL,
0x2000006fff5a7230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000ffff23237812ULL, 0x000fe400078ec0ffULL, 0x00000020ff20723eULL, 0x000fe200020006ffULL,
0x20000069ff777230ULL, 0x000fe20000004100ULL, 0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x20000020ff767230ULL, 0x000fe20000004100ULL,
0x00000008ff227819ULL, 0x000fc40000011622ULL, 0x00000059ff79723eULL, 0x000fe200020006ffULL,
0x20000074ff597230ULL, 0x000fe20000004100ULL, 0x0000005bff7a723eULL, 0x000fe200020006ffULL,
0x20000073ff5b7230ULL, 0x000fe20000004100ULL, 0x0000006eff74723eULL, 0x000fe200020006ffULL,
0x20000021ff737230ULL, 0x000fe20000004100ULL, 0x00000022ff6e723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000008ff697819ULL, 0x000fe20000011623ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x009000001820783bULL, 0x000e620000000200ULL,
0x00000010ff5c7819ULL, 0x000fe20000011648ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x0000ffff485d7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fc400078ec0ffULL, 0x000000ff1d617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1f7819ULL, 0x000fe4000001164aULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5d7819ULL, 0x000fe2000001165dULL,
0x20000069ff6f7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x00000008ff687819ULL, 0x000fe40000011668ULL, 0x000000ff1c527812ULL, 0x000fe200078ec0ffULL,
0x20000062ff697230ULL, 0x000fe20000004100ULL, 0x00000018ff507819ULL, 0x000fe4000001161cULL,
0x0000ffff4a5e7812ULL, 0x000fe400078ec0ffULL, 0x00000061ff64723eULL, 0x000fe400020006ffULL,
0x000000ff1f1f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001161dULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000068ff89723eULL, 0x000fe200020006ffULL,
0x2000005cff687230ULL, 0x000fe20000004100ULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x2000005dff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff627819ULL, 0x000fe20000011660ULL,
0x20000089ff5d7230ULL, 0x000fe20000004100ULL, 0x0000001fff1f723eULL, 0x000fe200020006ffULL,
0x0000001720208231ULL, 0x082fe200003400ffULL, 0x00000050ff83723eULL, 0x000fe200020006ffULL,
0x0000001722228231ULL, 0x000fe200003400ffULL, 0x0000001cff84723eULL, 0x000fe200020006ffULL,
0x0000001621218231ULL, 0x080fe200003400ffULL, 0x000000ff4c617812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000018ff1d7819ULL, 0x000fe2000001164cULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000052ff63723eULL, 0x000fe200020006ffULL,
0x0000001623238231ULL, 0x000fe200003400ffULL, 0x0000005eff60723eULL, 0x000fe200020006ffULL,
0x2000001fff5e7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000061ff89723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000001dff1d723eULL, 0x000fe200020006ffULL,
0x20000062ff617230ULL, 0x000fe20000004100ULL, 0x000000ff1e7f7812ULL, 0x000fe200078ec0ffULL,
0x20000089ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff1f7819ULL, 0x000fe20000011664ULL,
0x2000001dff647230ULL, 0x000fe20000004100ULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x000000ff4d1e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001164dULL,
0x00001054881f7816ULL, 0x000fe4000000001fULL, 0x0000001eff89723eULL, 0x000fe400020006ffULL,
0x00000010ff887819ULL, 0x000fe40000011683ULL, 0x00000010ff857819ULL, 0x000fc40000011685ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff1d7819ULL, 0x000fe40000011686ULL,
0x00000010ff1e7819ULL, 0x000fe20000011663ULL, 0x20000089ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000001cff83723eULL, 0x000fc400020006ffULL, 0x00001054881c7816ULL, 0x000fe20000000085ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00001054841d7816ULL, 0x000fe4000000001dULL,
0x00001054871e7816ULL, 0x000fe4000000001eULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x0000001c202c723cULL, 0x000b62000004182cULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x000000ff4f4a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x020fe2000001166aULL,
0x0000001e2028723cULL, 0x000be20000041828ULL, 0x00000010ff1c7819ULL, 0x000fe2000001167cULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe2000001167bULL,
0x20000083ff6a7230ULL, 0x000fe20000004100ULL, 0x000010541d1c7816ULL, 0x000fc4000000001cULL,
0x00000010ff1e7819ULL, 0x020fe4000001167fULL, 0x00000010ff1f7819ULL, 0x000fe40000011680ULL,
0x00001054811e7816ULL, 0x000fe4000000001eULL, 0x00001054821f7816ULL, 0x000fe4000000001fULL,
0x000010547c1d7816ULL, 0x000fe4000000007dULL, 0x0000004aff7c723eULL, 0x000fc400020006ffULL,
0x00000018ff537819ULL, 0x000fe20000011648ULL, 0x0000001e2030723cULL, 0x040f620000041830ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164bULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000018ff487819ULL, 0x000fe4000001164eULL, 0x00000010ff4b7819ULL, 0x000fe20000011678ULL,
0x0000001c2034723cULL, 0x000b620000041834ULL, 0x00000010ff497819ULL, 0x000fe20000011649ULL,
0x009000000a1c783bULL, 0x020e620000000200ULL, 0x00000010ff767819ULL, 0x000fc40000011676ULL,
0x00000010ff787819ULL, 0x000fe20000011675ULL, 0x2000007cff757230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00001054794a7816ULL, 0x000fe4000000004aULL, 0x00000048ff79723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x0000105449487816ULL, 0x000fe40000000076ULL,
0x0000105478497816ULL, 0x000fe20000000077ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x000010547a4b7816ULL, 0x000fe4000000004bULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x00000048203c723cULL, 0x000be2000004183cULL,
0x00000010ff6f7819ULL, 0x000fc4000001166fULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff497819ULL, 0x020fe2000001166cULL,
0x0000004a2038723cULL, 0x000b620000041838ULL, 0x00000010ff487819ULL, 0x000fe2000001166eULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166dULL,
0x0000105449487816ULL, 0x000fc40000000048ULL, 0x00000010ff4a7819ULL, 0x020fe20000011671ULL,
0x000000171c1cd231ULL, 0x082fe200003400ffULL, 0x00000010ff4b7819ULL, 0x000fe20000011672ULL,
0x000000171e1ed231ULL, 0x000fe200003400ffULL, 0x00001054734a7816ULL, 0x000fe2000000004aULL,
0x000000161d1dd231ULL, 0x080fe200003400ffULL, 0x00001054744b7816ULL, 0x000fe2000000004bULL,
0x000000161f1fd231ULL, 0x000fe200003400ffULL, 0x000010546c497816ULL, 0x000fe2000000006fULL,
0x20000079ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fc4000001164cULL,
0x0000ffff4c4c7812ULL, 0x000fe200078ec0ffULL, 0x0000004a2040723cULL, 0x040f620000041840ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff657819ULL, 0x000fe2000001164dULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000ffff4d507812ULL, 0x000fe200078ec0ffULL, 0x000000482024723cULL, 0x000b620000041824ULL,
0x00000010ff4d7819ULL, 0x000fc4000001164eULL, 0x000000ff4e7e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x000fe4000001164fULL, 0x00000010ff227819ULL, 0x020fe40000011655ULL,
0x00000010ff207819ULL, 0x000fe4000001165cULL, 0x00000010ff217819ULL, 0x000fe4000001165dULL,
0x00000018ff707819ULL, 0x000fc4000001164fULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x0000ffff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x0000105453207816ULL, 0x000fe40000000020ULL, 0x0000105422217816ULL, 0x000fe40000000021ULL,
0x00000070ff72723eULL, 0x000fc400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x000000ff6b707812ULL, 0x000fe200078ec0ffULL, 0x000000201c2c723cULL, 0x000b62000004182cULL,
0x000000ff656c7812ULL, 0x000fe200078ec0ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000008ff507819ULL, 0x000fe20000011650ULL, 0x20000072ff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff52527812ULL, 0x000fc400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff227819ULL, 0x000fe20000011656ULL, 0x0000000219567824ULL, 0x000fe200078e00ffULL,
0x00000010ff237819ULL, 0x000fe4000001165eULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff487819ULL, 0x000fc4000001165fULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000007eff7b7230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x20000070ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x020fe2000001165aULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fc4000001165bULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fe20000000022ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x0000105448237816ULL, 0x000fe20000000059ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000105421607816ULL, 0x000fc40000000060ULL, 0x0000105420617816ULL, 0x000fe20000000061ULL,
0x2000004dff207230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe20000011664ULL,
0x000000221c30723cULL, 0x040b620000041830ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff4a7819ULL, 0x000fe40000011666ULL, 0x00000010ff4b7819ULL, 0x000fe40000011668ULL,
0x00001054214c7816ULL, 0x000fe2000000004cULL, 0x000000601c34723cULL, 0x000b620000041834ULL,
0x00000010ff677819ULL, 0x000fc40000011667ULL, 0x00000010ff667819ULL, 0x000fe40000011669ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x00000010ff4d7819ULL, 0x000fe40000011650ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff207819ULL, 0x000fe40000011620ULL,
0x00000010ff217819ULL, 0x000fe40000011675ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff227819ULL, 0x020fe4000001166bULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x000010544b4a7816ULL, 0x000fe4000000004aULL, 0x00001054664b7816ULL, 0x000fe40000000067ULL,
0x0000105465627816ULL, 0x000fc40000000062ULL, 0x000010546c637816ULL, 0x000fe40000000063ULL,
0x000010546a4d7816ULL, 0x000fe2000000004dULL, 0x0000004a1c28723cULL, 0x040b620000041828ULL,
0x0000105420207816ULL, 0x000fe4000000007bULL, 0x0000105452217816ULL, 0x000fe40000000021ULL,
0x00001054714e7816ULL, 0x000fe4000000004eULL, 0x00001054224f7816ULL, 0x000fe2000000004fULL,
0x000000621c38723cULL, 0x040b700000041838ULL, 0x0000004c1c3c723cULL, 0x040b70000004183cULL,
0x000000201c40723cULL, 0x040b700000041840ULL, 0x0000004e1c24723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000d1c7f8cULL, 0x0202a2000c80043fULL,
0xfffffff856567812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000400b1f7811ULL, 0x000fe200078e40ffULL, 0x00f6880056ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff207224ULL, 0x004fc400078e001dULL, 0x0000001a1f00720cULL, 0x000fe20003f06070ULL,
0x000000ffff5c7224ULL, 0x000fe400078e0051ULL, 0x000000ffff597224ULL, 0x000fe400078e0047ULL,
0x000000ffff1d7224ULL, 0x000fd000078e000fULL, 0x000089a000000947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x008fc40000015200ULL, 0x000004000d1f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x004fe40007804820ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x004fe40007804820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010b1d7810ULL, 0x000fc80007ffe0ffULL,
0x000000021d00720cULL, 0x000fe40003f06070ULL, 0x000000800e1d7810ULL, 0x000fca0007ffe0ffULL,
0x00006200064a7a24ULL, 0x000fcc00078e021dULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x00000003ff227819ULL, 0x000fe20000011600ULL, 0x00000010074c7824ULL, 0x000fe200078e00ffULL,
0x0000001d1a1c7217ULL, 0x000fe20007800000ULL, 0x0000001000207824ULL, 0x000fe400078e00ffULL,
0x000000014c217824ULL, 0x000fe400078e0222ULL, 0x000000011c1d7824ULL, 0x000fe400078e0a1dULL,
0x000010000c1c7824ULL, 0x000fe400078e00ffULL, 0x00000001211e7824ULL, 0x040fe200078e0200ULL,
0x0000001d4c1d7217ULL, 0x000fe20007800000ULL, 0x0000000821497824ULL, 0x000fe200078e00ffULL,
0x000010001c1f7812ULL, 0x000fe200078ec0ffULL, 0x00000080ff4d7424ULL, 0x000fe200078e00ffULL,
0x00000070201c7812ULL, 0x000fe200078ec0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0a4cULL,
0xfffffff849497812ULL, 0x000fe200078ee21eULL, 0x00000001211e7824ULL, 0x000fe200078e024aULL,
0x0000000422217810ULL, 0x000fe20007ffe0ffULL, 0x0000200004207824ULL, 0x000fe200078e021fULL,
0x0000001d2200720cULL, 0x000fe20003fa6070ULL, 0x00005e001e1e7625ULL, 0x000fe200078e004dULL,
0x0000001d2100720cULL, 0x000fc40003f06070ULL, 0x0000b00020487810ULL, 0x000fe20007ffe0ffULL,
0x000000014c237824ULL, 0x000fe200078e0221ULL, 0x0000001c1e207210ULL, 0x000fc60007fde0ffULL,
0x00000001231e7824ULL, 0x040fe400078e024aULL, 0x00000001234b7824ULL, 0x040fe400078e0200ULL,
0x00000008234e7824ULL, 0x000fe200078e00ffULL, 0x0000000822237810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe400030e061fULL, 0x00005e001e1e7625ULL, 0x000fe200078e004dULL,
0xfffffff84e4b7812ULL, 0x000fe400078ee24bULL, 0x0000000c224e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0x0000001c1e227210ULL, 0x000fe20007fde0ffULL,
0x000000014c4f7824ULL, 0x000fc400078e0223ULL, 0x000000014c537824ULL, 0x000fe200078e024eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020497faeULL, 0x0005e2000e901c46ULL,
0x000000014f1e7824ULL, 0x000fe200078e024aULL, 0x0000001d2300720cULL, 0x080fe20003fa6070ULL,
0x000000ffff237224ULL, 0x000fe200030e061fULL, 0x0000001d4e00720cULL, 0x000fe20003fc6070ULL,
0x000000104b4b7824ULL, 0x000fe400078e0248ULL, 0x00005e001e1e7625ULL, 0x000fc600078e004dULL,
0x00000000224b7faeULL, 0x0007e2000c101c46ULL, 0x00000001531d7824ULL, 0x000fe200078e024aULL,
0x0000001c1e1e7210ULL, 0x000fe20007f1e0ffULL, 0x000000014f497824ULL, 0x144fe400078e0200ULL,
0x000000084f4c7824ULL, 0x000fe400078e00ffULL, 0x00000001534a7824ULL, 0x000fe400078e0200ULL,
0x00005e001d207625ULL, 0x000fe200078e004dULL, 0xfffffff84c1d7812ULL, 0x000fc600078ee249ULL,
0x0000000853537824ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000001c20207210ULL, 0x000fe20007f1e0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0248ULL,
0xfffffff853497812ULL, 0x000fc600078ee24aULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x000000001e1d7faeULL, 0x0005e2000e901c46ULL, 0x0000001049237824ULL, 0x008fca00078e0248ULL,
0x0000000020237faeULL, 0x0005e2000f101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010071d7824ULL, 0x000fe400078e00ffULL, 0x00000080ff237424ULL, 0x000fc600078e00ffULL,
0x0000001d001f7211ULL, 0x040fe200078fe8ffULL, 0x00000010001d7824ULL, 0x000fc600078e00ffULL,
0x000000041f497810ULL, 0x040fe20007ffe0ffULL, 0x000000011f1c7824ULL, 0x140fe200078e0200ULL,
0x000000081f4f7810ULL, 0x040fe20007ffe0ffULL, 0x000000081f4b7824ULL, 0x040fe200078e00ffULL,
0x0000000c1f537810ULL, 0x000fe20007ffe0ffULL, 0x00000001491e7824ULL, 0x040fe400078e0200ULL,
0x00000008494d7824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee21cULL,
0x000010000c1c7824ULL, 0x000fe400078e00ffULL, 0x0000000149207824ULL, 0x000fe200078e024aULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee21eULL, 0x000000011f1e7824ULL, 0x000fe200078e024aULL,
0x000010001c217812ULL, 0x000fe200078ec0ffULL, 0x000000014f497824ULL, 0x000fe200078e0200ULL,
0x000000701d1c7812ULL, 0x000fe200078ec0ffULL, 0x00005e001e1e7625ULL, 0x000fc800078e0023ULL,
0x000000084f4e7824ULL, 0x040fe200078e00ffULL, 0x0000001c1e487210ULL, 0x000fe20007f1e0ffULL,
0x00002000041d7824ULL, 0x000fe400078e0221ULL, 0x000000014f217824ULL, 0x100fe200078e024aULL,
0xfffffff84e4f7812ULL, 0x000fe200078ee249ULL, 0x0000000153227824ULL, 0x000fe200078e024aULL,
0x0000b0001d4a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe400000e061fULL,
0x00005e00201e7625ULL, 0x000fc800078e0023ULL, 0x00000001534c7824ULL, 0x000fe200078e0200ULL,
0x0000001c1e1e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0021207625ULL, 0x000fc800078e0023ULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0x0000001c20207210ULL, 0x000fe20007fbe0ffULL,
0x00005e0022227625ULL, 0x000fc600078e0023ULL, 0xfffffff853537812ULL, 0x000fe200078ee24cULL,
0x000000104b1d7824ULL, 0x100fe200078e024aULL, 0x0000001c22227210ULL, 0x000fe20007fde0ffULL,
0x000000104d4b7824ULL, 0x100fe400078e024aULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000481d7faeULL, 0x0005e2000b901c46ULL,
0x000000104f4d7824ULL, 0x100fe400078e024aULL, 0x000000ffff217224ULL, 0x000fe200028e0621ULL,
0x000000001e4b7faeULL, 0x0005e2000b901c46ULL, 0x00000010534f7824ULL, 0x000fc400078e024aULL,
0x000000ffff237224ULL, 0x000fe200030e0623ULL, 0x00000000204d7faeULL, 0x0005e8000b901c46ULL,
0x00000000224f7faeULL, 0x0005e4000b901c46ULL, 0x000000080c1d7824ULL, 0x004fe200078e00ffULL,
0xfffffff0031e7812ULL, 0x000fe200078ec0ffULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x000000081d1d7812ULL, 0x000fca00078ec0ffULL,
0x000000011e537824ULL, 0x000fe200078e021dULL, 0xffffffe0031d7812ULL, 0x040fe400078ec0ffULL,
0x00000010031e7812ULL, 0x000fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a853527810ULL, 0x000fe40007ffe0ffULL, 0x000000011d1e7824ULL, 0x000fc800078e021eULL,
0x0000000807227824ULL, 0x000fc400078e021eULL, 0x00000000520403c2ULL, 0x000ea40000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800531e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280022227f8cULL, 0x000e62000c80043fULL, 0x000000ffff597224ULL, 0x008fc600078e001fULL,
0x00000000001e7805ULL, 0x000fc80000015200ULL, 0x0000001008207812ULL, 0x000fca00078ec0ffULL,
0x000000011d207824ULL, 0x000fc800078e0220ULL, 0x0000000807487824ULL, 0x000fca00078e0220ULL,
0x00f62c00481d7984ULL, 0x000ee40000000800ULL, 0x800000001dff7812ULL, 0x00afe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e207210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1fULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc80000011421ULL,
0x000000201d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x000000021d1d7819ULL, 0x000fc80000001220ULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000149497810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c00481d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000801c1e7810ULL, 0x000fca0007ffe010ULL, 0x00000001111e7824ULL, 0x000fca00078e021eULL,
0x00f000001e207984ULL, 0x000e680000000800ULL, 0x00f200001e227984ULL, 0x0006a20000000800ULL,
0x000000512000720bULL, 0x002fe20003f1d000ULL, 0x0000ddf27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff1dff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff217424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x000fd200078e0051ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000001191e7811ULL, 0x000fe400078ff0ffULL, 0x000000512000720bULL, 0x000fe40003f14000ULL,
0x000000191e00720cULL, 0x000fe20003fa5270ULL, 0x0000dda27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000487806ULL, 0x000fc400000e0100ULL, 0x00000080191ed824ULL, 0x000fe200078e021cULL,
0x00000051201cd209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001111fd824ULL, 0x000fe200078e021eULL, 0x00009910481e7816ULL, 0x000fc800000000ffULL,
0x00f4001c1f00d388ULL, 0x0003e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000051201c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff48ff7812ULL, 0x000fc6000780c0ffULL,
0x000000511c1c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c004a7308ULL, 0x000e640000000800ULL, 0x0000004a09097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x0000dcb27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e4a1c7589ULL, 0x0002e400000e0000ULL,
0x0000001c28287220ULL, 0x088fe20000410000ULL, 0x0000001c29297220ULL, 0x080fe20000410000ULL,
0x0000001c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001c30307220ULL, 0x080fe20000410000ULL, 0x0000001c31317220ULL, 0x080fe20000410000ULL,
0x0000001c34347220ULL, 0x080fe20000410000ULL, 0x0000001c35357220ULL, 0x080fe20000410000ULL,
0x0000001c38387220ULL, 0x080fe20000410000ULL, 0x0000001c39397220ULL, 0x080fe20000410000ULL,
0x0000001c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001c40407220ULL, 0x080fe20000410000ULL, 0x0000001c41417220ULL, 0x080fe20000410000ULL,
0x0000001c24247220ULL, 0x080fe20000410000ULL, 0x0000001c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0048ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x002fe200078ff0ffULL,
0x0000dba27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e4a1c7589ULL, 0x0002e400000e0000ULL,
0x0000001c2a2a7220ULL, 0x088fe20000410000ULL, 0x0000001c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001c32327220ULL, 0x080fe20000410000ULL, 0x0000001c33337220ULL, 0x080fe20000410000ULL,
0x0000001c36367220ULL, 0x080fe20000410000ULL, 0x0000001c37377220ULL, 0x080fe20000410000ULL,
0x0000001c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001c42427220ULL, 0x080fe20000410000ULL, 0x0000001c43437220ULL, 0x080fe20000410000ULL,
0x0000001c26267220ULL, 0x080fe20000410000ULL, 0x0000001c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff48ff7812ULL, 0x000fe2000780081dULL,
0x00000001ff217424ULL, 0x000fe200078e00ffULL, 0x00000051205c7209ULL, 0x000fd60007810000ULL,
0x8000005c20200221ULL, 0x000fe20000010000ULL, 0x00007610ff210816ULL, 0x000fc60000000021ULL,
0x3fb8aa3b20200820ULL, 0x000fc80000410000ULL, 0x0000002000150308ULL, 0x000e640000000800ULL,
0x0000001522220220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000922097221ULL, 0x004fc20000010000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x000000080f557824ULL, 0x000fc800078e00ffULL, 0x00000001081e7824ULL, 0x000fca00078e0255ULL,
0x00f6ac001e1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x0000000108227824ULL, 0x000fc400078e0255ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c237210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000231e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6ac00221f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910211c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000015ff16723eULL, 0x000fe400000010ffULL,
0x00000002ff1d7819ULL, 0x000fe40000011600ULL, 0x00005410161c7816ULL, 0x000fe20000000016ULL,
0x0000d7327f007947ULL, 0x000fea000b800000ULL, 0x00001f1d1c177589ULL, 0x0002a400000e0000ULL,
0x000000081d1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000d7627f007947ULL, 0x000fea000b800000ULL,
0x00001f1e1c167589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101d1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x000057c000497802ULL, 0x000fc40000000f00ULL, 0x0000dfd000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181d1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x004fe200078e001cULL, 0x0000581000497802ULL, 0x000fc40000000f00ULL,
0x0000df8000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001581c7824ULL, 0x04afe200078e0257ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000858517824ULL, 0x000fc400078e00ffULL, 0x00000002045a7824ULL, 0x000fc600078e020fULL,
0xfffffff851517812ULL, 0x000fe400078ee21cULL, 0x0000b0005a5a7811ULL, 0x000fca00078e60ffULL,
0x0000001051517824ULL, 0x100fe400078e025aULL, 0x0000001045507824ULL, 0x100fe400078e025aULL,
0x000000101b477824ULL, 0x100fe200078e025aULL, 0x00000000511c783bULL, 0x000e620000004200ULL,
0x0000001044467824ULL, 0x000fc600078e025aULL, 0x000000005020783bULL, 0x004ea80000004200ULL,
0x000000004748783bULL, 0x000ee80000004200ULL, 0x00000000464c783bULL, 0x000f220000004200ULL,
0x000000ff1c5f7812ULL, 0x002fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fc4000001161cULL,
0x000000ff1d637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x000fe4000001161cULL,
0x0000ffff1c697812ULL, 0x000fe400078ec0ffULL, 0x00000018ff797819ULL, 0x004fe40000011621ULL,
0x000000ff237e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1c7819ULL, 0x008fc4000001164aULL,
0x000000ff4a5d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe4000001164aULL,
0x0000ffff4a747812ULL, 0x000fe400078ec0ffULL, 0x0000005fff89723eULL, 0x000fe400020006ffULL,
0x00000010ff807819ULL, 0x000fe40000011621ULL, 0x000000ff217a7812ULL, 0x040fe200078ec0ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x0000ffff21847812ULL, 0x000fc400078ec0ffULL,
0x0000005bff87723eULL, 0x000fe400020006ffULL, 0x00000010ff4a7819ULL, 0x110fe4000001164cULL,
0x000000ff4c667812ULL, 0x040fe200078ec0ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fe4000001164cULL, 0x0000ffff4c737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7b7819ULL, 0x000fc40000011620ULL, 0x000000ff208f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe40000011620ULL, 0x0000ffff207f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6b7819ULL, 0x100fe40000011622ULL, 0x000000ff227d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff677819ULL, 0x000fc40000011622ULL, 0x0000ffff22787812ULL, 0x000fe400078ec0ffULL,
0x00000063ff8a723eULL, 0x000fe400020006ffULL, 0x00000010ff4c7819ULL, 0x100fe4000001164eULL,
0x000000ff4e6a7812ULL, 0x040fe200078ec0ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000018ff217819ULL, 0x000fe4000001164eULL, 0x0000ffff4e5b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4e7819ULL, 0x100fe4000001164fULL, 0x000000ff4f227812ULL, 0x040fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fe4000001164fULL, 0x0000ffff4f637812ULL, 0x000fe400078ec0ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x0000007eff4f723eULL, 0x000fc400020006ffULL,
0x00000018ff6e7819ULL, 0x000fe20000011648ULL, 0x20000079ff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff49767812ULL, 0x000fe200078ec0ffULL, 0x2000004fff797230ULL, 0x000fe20000004100ULL,
0x00000018ff607819ULL, 0x000fe40000011649ULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000010ff5e7819ULL, 0x100fe4000001161dULL, 0x00000018ff6c7819ULL, 0x000fc4000001161dULL,
0x0000ffff1d857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x100fe4000001161fULL,
0x000000ff1f8e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff837819ULL, 0x000fe4000001161fULL,
0x0000ffff1f7c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fc40000011623ULL,
0x00000018ff687819ULL, 0x000fe40000011623ULL, 0x0000ffff23777812ULL, 0x000fe400078ec0ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000010ff1f7819ULL, 0x000fe40000011649ULL,
0x0000ffff491d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff237819ULL, 0x000fc4000001164bULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000007aff49723eULL, 0x000fe400020006ffULL,
0x00000076ff4f723eULL, 0x000fe400020006ffULL, 0x0000007dff7a723eULL, 0x000fe200020006ffULL,
0x20000075ff7d7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000067ff757230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x2000006eff677230ULL, 0x000fe20000004100ULL, 0x00000018ff657819ULL, 0x000fe2000001164dULL,
0x2000004fff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff1e827812ULL, 0x000fe200078ec0ffULL,
0x20000060ff4f7230ULL, 0x000fe20000004100ULL, 0x00000066ff60723eULL, 0x000fe200020006ffULL,
0x20000023ff667230ULL, 0x000fe20000004100ULL, 0x00000065ff23723eULL, 0x000fe200020006ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000018ff717819ULL, 0x100fe2000001161eULL,
0x20000060ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe2000001161eULL,
0x20000023ff607230ULL, 0x000fe20000004100ULL, 0x00000022ff23723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000021ff22723eULL, 0x000fc400020006ffULL,
0x000000ff61217812ULL, 0x000fe200078ec0ffULL, 0x20000023ff617230ULL, 0x000fe20000004100ULL,
0x00000020ff23723eULL, 0x000fe400020006ffULL, 0x0000ffff1e8b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e207812ULL, 0x000fe200078ec0ffULL, 0x20000023ff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011648ULL, 0x000000ff486d7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff481e7812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000071ff48723eULL, 0x000fe200020006ffULL,
0x2000006cff887230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x20000082ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff697819ULL, 0x000fe20000011669ULL,
0x20000048ff827230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe200020006ffULL,
0x2000008fff487230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fc400020006ffULL,
0x0000008eff6c723eULL, 0x000fe200020006ffULL, 0x20000021ff8f7230ULL, 0x000fe20000004100ULL,
0x00000069ff8e723eULL, 0x000fe200020006ffULL, 0x20000022ff697230ULL, 0x000fe20000004100ULL,
0x000000ff4b647812ULL, 0x000fe200078ec0ffULL, 0x20000020ff917230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x009800001820783bULL, 0x000e620000000200ULL,
0x000000ff4d8d7812ULL, 0x000fe200078ec0ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000068ff767230ULL, 0x000fe20000004100ULL,
0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000005dff687230ULL, 0x000fe20000004100ULL,
0x000000ff86867812ULL, 0x000fc400078ec0ffULL, 0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL,
0x20000064ff5d7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000008ff8b7819ULL, 0x000fe4000001168bULL, 0x00000008ff7c7819ULL, 0x000fe2000001167cULL,
0x20000062ff647230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000008ff787819ULL, 0x000fe40000011678ULL,
0x0000007cff7c723eULL, 0x000fc400020006ffULL, 0x00000008ff777819ULL, 0x000fe40000011677ULL,
0x0000005fff62723eULL, 0x000fe200020006ffULL, 0x2000008dff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff927819ULL, 0x000fe20000011684ULL, 0x2000007bff847230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000086ff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x2000006bff7b7230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x2000008bff867230ULL, 0x000fe20000004100ULL,
0x000000ff70707812ULL, 0x000fe200078ec0ffULL, 0x2000007cff8b7230ULL, 0x000fe20000004100ULL,
0x00000077ff6b723eULL, 0x000fe200020006ffULL, 0x2000006fff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff1f1f7812ULL, 0x000fe200078ec0ffULL, 0x20000078ff777230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x2000006bff787230ULL, 0x000fe20000004100ULL,
0x00000008ff1e7819ULL, 0x000fe2000001161eULL, 0x0000001720208231ULL, 0x082fe200003400ffULL,
0x00000070ff6f723eULL, 0x000fe200020006ffULL, 0x20000085ff907230ULL, 0x000fe20000004100ULL,
0x0000001fff70723eULL, 0x000fe200020006ffULL, 0x0000001722228231ULL, 0x000fe200003400ffULL,
0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL, 0x0000001621218231ULL, 0x080fe200003400ffULL,
0x00000010ff1f7819ULL, 0x000fe2000001168aULL, 0x0000001623238231ULL, 0x000fe200003400ffULL,
0x0000001eff6b723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe20000011691ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fe20000011689ULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fe2000001168fULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x000010548a1f7816ULL, 0x000fe4000000001fULL,
0x000010548f1e7816ULL, 0x000fe2000000001eULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe4000001161dULL, 0x000000ff1c8a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x0000001e2028723cULL, 0x000b620000041828ULL,
0x00000010ff887819ULL, 0x000fc40000011688ULL, 0x00000010ff1c7819ULL, 0x000fe4000001168eULL,
0x00000010ff1d7819ULL, 0x000fe40000011690ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00001054871c7816ULL, 0x000fe4000000001cULL, 0x00001054881d7816ULL, 0x000fe2000000001dULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff80807812ULL, 0x000fc400078ec0ffULL,
0x00000010ff817819ULL, 0x000fe4000001164bULL, 0x00000010ff1e7819ULL, 0x020fe20000011671ULL,
0x0000001c202c723cULL, 0x000b62000004182cULL, 0x00000010ff1f7819ULL, 0x000fe4000001166cULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x000010548d1e7816ULL, 0x000fe4000000001eULL,
0x000010548c1f7816ULL, 0x000fe2000000001fULL, 0x20000080ff857230ULL, 0x000fe20000004100ULL,
0x000000ff81877812ULL, 0x000fe400078ec0ffULL, 0x00000008ff817819ULL, 0x000fe40000011674ULL,
0x00000010ff1d7819ULL, 0x020fe20000011682ULL, 0x0000001e2030723cULL, 0x000b620000041830ULL,
0x00000010ff1c7819ULL, 0x000fc40000011686ULL, 0x00000010ff747819ULL, 0x000fe40000011683ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x00001054741d7816ULL, 0x000fe4000000008bULL, 0x00000010ff1f7819ULL, 0x020fe40000011684ULL,
0x00000010ff1e7819ULL, 0x000fc40000011685ULL, 0x00000010ff487819ULL, 0x000fe20000011648ULL,
0x0000001c2034723cULL, 0x000b620000041834ULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x000010541f487816ULL, 0x000fe40000000048ULL, 0x000010541e497816ULL, 0x000fe40000000049ULL,
0x009800000a1c783bULL, 0x020e620000000200ULL, 0x00000008ff7f7819ULL, 0x000fe4000001167fULL,
0x00000092ff80723eULL, 0x000fc400020006ffULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x000000482038723cULL, 0x000b620000041838ULL, 0x00000081ff82723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000ffff4b4b7812ULL, 0x000fe200078ec0ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x000000ff4a837812ULL, 0x000fe200078ec0ffULL,
0x20000082ff747230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe4000001164bULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff4a7819ULL, 0x000fe4000001167fULL, 0x00000010ff4b7819ULL, 0x000fe40000011680ULL,
0x000010547d4a7816ULL, 0x000fe4000000004aULL, 0x000010547e4b7816ULL, 0x000fe4000000004bULL,
0x00000010ff487819ULL, 0x020fc4000001167aULL, 0x00000010ff497819ULL, 0x000fe40000011679ULL,
0x00000010ff7b7819ULL, 0x000fe2000001167bULL, 0x0000004a203c723cULL, 0x040b62000004183cULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x000010547b487816ULL, 0x000fe40000000048ULL, 0x000010547c497816ULL, 0x000fe20000000049ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x000000171c1c8231ULL, 0x082fe200003400ffULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x000000171e1e8231ULL, 0x000fe200003400ffULL, 0x00000010ff4a7819ULL, 0x020fe20000011677ULL,
0x000000482040723cULL, 0x000b620000041840ULL, 0x00000010ff4b7819ULL, 0x000fe20000011678ULL,
0x000000161d1d8231ULL, 0x080fe200003400ffULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x000000161f1f8231ULL, 0x000fe200003400ffULL, 0x00001054754a7816ULL, 0x000fc4000000004aULL,
0x00001054764b7816ULL, 0x000fe2000000004bULL, 0x20000089ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x020fe4000001166dULL, 0x00000010ff497819ULL, 0x000fe4000001166eULL,
0x00000010ff6f7819ULL, 0x000fe2000001166fULL, 0x0000004a2024723cULL, 0x000b620000041824ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x000010546f487816ULL, 0x000fe20000000048ULL,
0x2000008aff6c7230ULL, 0x000fe20000004100ULL, 0x0000105470497816ULL, 0x000fe20000000049ULL,
0x20000087ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe4000001164dULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff227819ULL, 0x020fe2000001164fULL,
0x000000481c28723cULL, 0x000b620000041828ULL, 0x00000010ff207819ULL, 0x000fc4000001166bULL,
0x00000010ff217819ULL, 0x000fe40000011671ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x0000105467207816ULL, 0x000fe20000000020ULL,
0x20000082ff7a7230ULL, 0x000fe20000004100ULL, 0x0000105422217816ULL, 0x000fe40000000021ULL,
0x00000010ff227819ULL, 0x000fc40000011668ULL, 0x00000010ff237819ULL, 0x000fe4000001166cULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x000000201c2c723cULL, 0x000b64000004182cULL,
0x00000010ff487819ULL, 0x020fe40000011681ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000105423227816ULL, 0x000fe20000000022ULL,
0x20000083ff797230ULL, 0x000fe20000004100ULL, 0x0000105448237816ULL, 0x000fe2000000005dULL,
0x20000072ff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fc40000011664ULL,
0x00000010ff207819ULL, 0x000fe40000011674ULL, 0x00000010ff497819ULL, 0x000fe20000011666ULL,
0x000000221c30723cULL, 0x000b620000041830ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x0000105421207816ULL, 0x000fe40000000020ULL,
0x0000ffff4d4d7812ULL, 0x000fc400078ec0ffULL, 0x0000105449217816ULL, 0x000fe4000000007aULL,
0x00000010ff227819ULL, 0x020fe40000011665ULL, 0x00000010ff237819ULL, 0x000fe4000001165fULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x000000201c34723cULL, 0x000b620000041834ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x0000006aff6a723eULL, 0x000fc400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000008ff737819ULL, 0x000fe20000011673ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000008ff4d7819ULL, 0x000fe2000001164dULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x00000008ff637819ULL, 0x000fc40000011663ULL,
0x0000105479227816ULL, 0x000fe40000000022ULL, 0x000010546e237816ULL, 0x000fe40000000023ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x000000221c38723cULL, 0x000b620000041838ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000073ff6d7230ULL, 0x000fe20000004100ULL,
0x00000063ff20723eULL, 0x020fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe2000001164cULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe20000011662ULL, 0x20000020ff227230ULL, 0x000fe20000004100ULL,
0x00001054216a7816ULL, 0x000fc4000000006aULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff207819ULL, 0x000fc40000011669ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff217819ULL, 0x000fe40000011622ULL,
0x0000105462627816ULL, 0x000fe4000000006dULL, 0x0000105460637816ULL, 0x000fe4000000004dULL,
0x000010544e6b7816ULL, 0x000fc40000000061ULL, 0x0000105420207816ULL, 0x000fe4000000005bULL,
0x000010545e217816ULL, 0x000fe20000000021ULL, 0x000000621c3c723cULL, 0x040b70000004183cULL,
0x0000006a1c40723cULL, 0x040b700000041840ULL, 0x000000201c24723cULL, 0x000b620000041824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000000d1c7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000800b1f7811ULL, 0x000fe200078e40ffULL, 0x00f6900056ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff207224ULL, 0x004fe200078e001dULL, 0x000000010c1d7812ULL, 0x000fc400078ec0ffULL,
0x0000001a1f00720cULL, 0x000fda0003f06070ULL, 0x00005ac000000947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x008fc40000015200ULL, 0x000004000d1f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x004fe40007804820ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x004fe40007804820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010b1d7810ULL, 0x000fc80007ffe0ffULL,
0x000000021d00720cULL, 0x000fe40003f06070ULL, 0x000000c00e1d7810ULL, 0x000fca0007ffe0ffULL,
0x0000620006487a24ULL, 0x000fcc00078e021dULL, 0x000003c000008947ULL, 0x000fea0003800000ULL,
0x0000001d1a1c7217ULL, 0x000fe20007800000ULL, 0x00000010074a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff227819ULL, 0x000fe20000011600ULL, 0x00000010001e7824ULL, 0x000fe400078e00ffULL,
0x000000011c1d7824ULL, 0x000fe200078e0a1dULL, 0x0000000422217810ULL, 0x000fe20007ffe0ffULL,
0x000000014a1f7824ULL, 0x000fe200078e0222ULL, 0x000000701e1c7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff4d7424ULL, 0x000fe200078e00ffULL, 0x0000001d4a1d7217ULL, 0x000fe20007800000ULL,
0x000000011f1e7824ULL, 0x000fc400078e0248ULL, 0x000000011f207824ULL, 0x040fe400078e0200ULL,
0x000000081f497824ULL, 0x000fe400078e00ffULL, 0x00005e001e1e7625ULL, 0x000fc600078e004dULL,
0xfffffff849497812ULL, 0x000fe200078ee220ULL, 0x000000011d1d7824ULL, 0x000fe200078e0a4aULL,
0x0000001c1e207210ULL, 0x000fe20007fde0ffULL, 0x000000014a237824ULL, 0x000fe400078e0221ULL,
0x0000001049497824ULL, 0x000fe200078e025aULL, 0x0000001d2200720cULL, 0x0c0fe20003fa6070ULL,
0x00000001231e7824ULL, 0x000fe200078e0248ULL, 0x0000001d2100720cULL, 0x000fe20003f06070ULL,
0x00000001234b7824ULL, 0x040fe400078e0200ULL, 0x00000008234c7824ULL, 0x000fe200078e00ffULL,
0x0000000822237810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x000fc400030e061fULL,
0x00005e001e1e7625ULL, 0x000fe200078e004dULL, 0xfffffff84c4b7812ULL, 0x000fe400078ee24bULL,
0x0000000c224c7810ULL, 0x000fe20007ffe0ffULL, 0x000000014a4f7824ULL, 0x000fe200078e0223ULL,
0x0000001c1e227210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020497faeULL, 0x0005e2000e901c46ULL, 0x0000001d2300720cULL, 0x000fe20003fa6070ULL,
0x000000014f1e7824ULL, 0x000fe400078e0248ULL, 0x000000014a5b7824ULL, 0x000fc400078e024cULL,
0x000000ffff237224ULL, 0x000fe200030e061fULL, 0x0000001d4c00720cULL, 0x000fe20003fc6070ULL,
0x000000104b4b7824ULL, 0x000fe400078e025aULL, 0x00005e001e1e7625ULL, 0x000fc600078e004dULL,
0x00000000224b7faeULL, 0x0007e2000c101c46ULL, 0x000000015b1d7824ULL, 0x000fe200078e0248ULL,
0x0000001c1e1e7210ULL, 0x000fe20007f1e0ffULL, 0x000000014f487824ULL, 0x040fe400078e0200ULL,
0x000000084f4f7824ULL, 0x000fe400078e00ffULL, 0x00005e001d207625ULL, 0x004fc600078e004dULL,
0xfffffff84f1d7812ULL, 0x000fe200078ee248ULL, 0x000000015b497824ULL, 0x040fe400078e0200ULL,
0x000000085b4a7824ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000001c20207210ULL, 0x000fe20007f1e0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e025aULL,
0xfffffff84a497812ULL, 0x000fc600078ee249ULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x000000001e1d7faeULL, 0x0005e2000e901c46ULL, 0x0000001049237824ULL, 0x008fca00078e025aULL,
0x0000000020237faeULL, 0x0005e2000f101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x00000010071d7824ULL, 0x000fe400078e00ffULL, 0x00000010001c7824ULL, 0x040fe400078e00ffULL,
0x00000080ff497424ULL, 0x000fe200078e00ffULL, 0x0000001d001d7211ULL, 0x000fe400078fe8ffULL,
0x000000701c1c7812ULL, 0x000fe400078ec0ffULL, 0x000000041d1f7810ULL, 0x040fe20007ffe0ffULL,
0x000000011d1e7824ULL, 0x040fe200078e0200ULL, 0x000000081d237810ULL, 0x040fe20007ffe0ffULL,
0x000000081d217824ULL, 0x040fe200078e00ffULL, 0x0000000c1d4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011f207824ULL, 0x000fc400078e0248ULL, 0x000000081f4c7824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee21eULL, 0x000000011d1e7824ULL, 0x000fe400078e0248ULL,
0x000000011f1d7824ULL, 0x000fe400078e0200ULL, 0x0000000123227824ULL, 0x000fe400078e0248ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0049ULL, 0x00000001234a7824ULL, 0x140fe200078e0200ULL,
0x0000001c1e1e7210ULL, 0x000fe20007f1e0ffULL, 0x00000008234d7824ULL, 0x000fe400078e00ffULL,
0x000000014b237824ULL, 0x040fe400078e0200ULL, 0x000000084b4e7824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee24aULL, 0x000000014b487824ULL, 0x000fe200078e0248ULL,
0xfffffff84c4b7812ULL, 0x000fe200078ee21dULL, 0x00000010211d7824ULL, 0x000fe200078e025aULL,
0xfffffff84e4f7812ULL, 0x000fe200078ee223ULL, 0x00005e0020207625ULL, 0x000fc800078e0049ULL,
0x00005e0022227625ULL, 0x000fc800078e0049ULL, 0x00005e0048487625ULL, 0x000fe200078e0049ULL,
0x0000001c22227210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000001c20207210ULL, 0x080fe20007f1e0ffULL, 0x000000104b4b7824ULL, 0x100fe200078e025aULL,
0x0000001c48487210ULL, 0x000fe20007fde0ffULL, 0x000000104d4d7824ULL, 0x100fe200078e025aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e1d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff217224ULL, 0x000fe400000e0621ULL, 0x000000ffff237224ULL, 0x000fe400028e0623ULL,
0x000000104f4f7824ULL, 0x000fe200078e025aULL, 0x00000000204b7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff497224ULL, 0x000fc600030e0649ULL, 0x00000000224d7faeULL, 0x0005e8000b901c46ULL,
0x00000000484f7faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0xfffffff0031e7812ULL, 0x040fe200078ec0ffULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0xffffffe003207812ULL, 0x040fe400078ec0ffULL, 0x00000010031f7812ULL, 0x000fe200078ec0ffULL,
0x000000080f1e7824ULL, 0x000fe200078e021eULL, 0x00000008031d7812ULL, 0x000fc400078ec0ffULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x000000201d1d7210ULL, 0x000fd60007ffe01fULL,
0x00000000540403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8001e5a7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f648001d227f8cULL, 0x0002a4000c80043fULL,
0x00000000001e7805ULL, 0x004fc40000015200ULL, 0x00f64c001d217984ULL, 0x000ea40000000800ULL,
0x8000000021ff7812ULL, 0x004fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e497210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1fULL,
0x003d09004900780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404900780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011421ULL, 0x0000004920207211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000220207819ULL, 0x000fc80000001221ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c001d217984ULL, 0x000ea40000000800ULL, 0x8000000021ff7812ULL, 0x004fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001001c1e7810ULL, 0x000fca0007ffe010ULL,
0x00000001111e7824ULL, 0x000fca00078e021eULL, 0x00f000001e1d7984ULL, 0x002e680000000800ULL,
0x00f200001e207984ULL, 0x0004e20000000800ULL, 0x0000005c1d00720bULL, 0x002fe20003f1d000ULL,
0x0000b1e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x004fc800000e0100ULL,
0x0000ffff21ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff487424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000002191e7811ULL, 0x000fe400078ff0ffULL, 0x0000005c1d00720bULL, 0x000fe40003f14000ULL,
0x000000191e00720cULL, 0x000fe20003fa5270ULL, 0x0000b1a27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400000e0100ULL, 0x00000080191ed824ULL, 0x000fe200078e021cULL,
0x0000001d5c1cd209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001111fd824ULL, 0x000fe200078e021eULL, 0x00009910221e7816ULL, 0x000fc800000000ffULL,
0x00f4001c1f00d388ULL, 0x0003e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000001d5c1f7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL,
0x8000001f5c1c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c00487308ULL, 0x000e640000000800ULL, 0x0000004809097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x0000b0c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e481c7589ULL, 0x0002a400000e0000ULL,
0x0000001c28287220ULL, 0x084fe20000410000ULL, 0x0000001c29297220ULL, 0x080fe20000410000ULL,
0x0000001c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001c30307220ULL, 0x080fe20000410000ULL, 0x0000001c31317220ULL, 0x080fe20000410000ULL,
0x0000001c34347220ULL, 0x080fe20000410000ULL, 0x0000001c35357220ULL, 0x080fe20000410000ULL,
0x0000001c38387220ULL, 0x080fe20000410000ULL, 0x0000001c39397220ULL, 0x080fe20000410000ULL,
0x0000001c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001c40407220ULL, 0x080fe20000410000ULL, 0x0000001c41417220ULL, 0x080fe20000410000ULL,
0x0000001c24247220ULL, 0x080fe20000410000ULL, 0x0000001c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0022ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x002fe200078ff0ffULL,
0x0000afb27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e481c7589ULL, 0x0002a400000e0000ULL,
0x0000001c2a2a7220ULL, 0x084fe20000410000ULL, 0x0000001c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001c32327220ULL, 0x080fe20000410000ULL, 0x0000001c33337220ULL, 0x080fe20000410000ULL,
0x0000001c36367220ULL, 0x080fe20000410000ULL, 0x0000001c37377220ULL, 0x080fe20000410000ULL,
0x0000001c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001c42427220ULL, 0x080fe20000410000ULL, 0x0000001c43437220ULL, 0x080fe20000410000ULL,
0x0000001c26267220ULL, 0x080fe20000410000ULL, 0x0000001c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff22ff7812ULL, 0x000fe20007800821ULL,
0x00000001ff487424ULL, 0x000fe200078e00ffULL, 0x0000001d5c5c7209ULL, 0x000fd60007810000ULL,
0x8000005c1d1d0221ULL, 0x000fe20000010000ULL, 0x00007610ff480816ULL, 0x000fc60000000048ULL,
0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL, 0x0000001d00150308ULL, 0x000e640000000800ULL,
0x0000001520200220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000920097221ULL, 0x008fc20000010000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x00f6ac00531e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00531e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910481c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000015ff16723eULL, 0x000fe400000010ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011600ULL,
0x00005410161c7816ULL, 0x000fe20000000016ULL, 0x0000ab927f007947ULL, 0x000fea000b800000ULL,
0x00001f1d1c177589ULL, 0x0002a400000e0000ULL, 0x000000081d1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000abc27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e1c167589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101d1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x0000855000497802ULL, 0x000fc40000000f00ULL,
0x0000b24000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181d1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x004fe200078e001cULL,
0x000085a000497802ULL, 0x000fc40000000f00ULL, 0x0000b1f000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000010000c1c7824ULL, 0x00afe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000158577824ULL, 0x000fc400078e0257ULL,
0x0000000858587824ULL, 0x000fe200078e00ffULL, 0x000010001c1d7812ULL, 0x000fc800078ec0ffULL,
0xfffffff858577812ULL, 0x000fe200078ee257ULL, 0x00002000041d7824ULL, 0x000fca00078e021dULL,
0x0000b0001d547810ULL, 0x000fca0007ffe0ffULL, 0x00000010571c7824ULL, 0x100fe400078e0254ULL,
0x0000001045207824ULL, 0x100fe400078e0254ULL, 0x000000101b497824ULL, 0x100fe200078e0254ULL,
0x00009910481b7816ULL, 0x000fe200000000ffULL, 0x00000010444c7824ULL, 0x000fe200078e0254ULL,
0x000000001c1c783bULL, 0x000e640000004200ULL, 0x000000ff1b00720cULL, 0x000fe40003fa5270ULL,
0x000000002020783bULL, 0x004ea80000004200ULL, 0x000000004948783bULL, 0x000ee80000004200ULL,
0x000000004c4c783bULL, 0x000f220000004200ULL, 0x000000ff1d5e7812ULL, 0x002fc400078ec0ffULL,
0x00000010ff657819ULL, 0x000fe4000001161dULL, 0x00000018ff697819ULL, 0x004fe40000011623ULL,
0x00000018ff457819ULL, 0x000fe4000001161dULL, 0x000000ff49707812ULL, 0x008fe400078ec0ffULL,
0x0000ffff1d857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x000fc4000001161fULL,
0x000000ff1f777812ULL, 0x040fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe4000001161fULL,
0x0000ffff1f767812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011649ULL,
0x00000010ff6a7819ULL, 0x000fe40000011623ULL, 0x000000ff23737812ULL, 0x000fc400078ec0ffULL,
0x0000ffff23717812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1f7819ULL, 0x000fe40000011649ULL,
0x0000ffff491d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b5d7812ULL, 0x000fe400078ec0ffULL,
0x0000005eff84723eULL, 0x000fe400020006ffULL, 0x00000018ff237819ULL, 0x000fc4000001164bULL,
0x00000010ff497819ULL, 0x110fe2000001164cULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x000000ff4c5f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001164cULL,
0x0000ffff4c6e7812ULL, 0x000fe400078ec0ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000070ff4c723eULL, 0x000fc400020006ffULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000069ff707230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000004cff697230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x20000058ff4c7230ULL, 0x000fe20000004100ULL, 0x000000ff4d607812ULL, 0x000fe200078ec0ffULL,
0x2000005dff587230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000023ff5d7230ULL, 0x000fe20000004100ULL, 0x00000060ff23723eULL, 0x000fc400020006ffULL,
0x00000010ff667819ULL, 0x100fe40000011622ULL, 0x000000ff228b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe40000011622ULL, 0x0000ffff22727812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f227812ULL, 0x000fe400078ec0ffULL, 0x0000005eff60723eULL, 0x000fe200020006ffULL,
0x2000005fff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x100fe20000011621ULL,
0x20000023ff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff218a7812ULL, 0x000fe200078ec0ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000018ff897819ULL, 0x000fc40000011621ULL,
0x0000ffff217f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff217819ULL, 0x000fe4000001164eULL,
0x00000010ff637819ULL, 0x000fe4000001161cULL, 0x00000022ff23723eULL, 0x000fe400020006ffULL,
0x00000010ff757819ULL, 0x000fe40000011620ULL, 0x000000ff207e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe40000011620ULL, 0x0000ffff20797812ULL, 0x000fe400078ec0ffULL,
0x000000ff1e6c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff207819ULL, 0x000fe4000001164fULL,
0x00000021ff22723eULL, 0x000fe400020006ffULL, 0x000000ff63217812ULL, 0x000fe200078ec0ffULL,
0x20000023ff637230ULL, 0x000fe20000004100ULL, 0x00000018ff677819ULL, 0x000fc4000001161eULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000020ff23723eULL, 0x000fe400020006ffULL,
0x0000ffff1c647812ULL, 0x000fe400078ec0ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x000000ff65207812ULL, 0x000fe200078ec0ffULL, 0x20000023ff657230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fc400020006ffULL, 0x00000067ff7d723eULL, 0x000fe200020006ffULL,
0x2000006cff677230ULL, 0x000fe20000004100ULL, 0x00000008ff647819ULL, 0x000fe20000011664ULL,
0x20000077ff6c7230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe200020006ffULL,
0x20000045ff827230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000078ff77723eULL, 0x000fe400020006ffULL,
0x00000089ff78723eULL, 0x000fe200020006ffULL, 0x20000020ff8c7230ULL, 0x000fe20000004100ULL,
0x0000008aff45723eULL, 0x000fe200020006ffULL, 0x20000021ff8a7230ULL, 0x000fe20000004100ULL,
0x00000064ff89723eULL, 0x000fe200020006ffULL, 0x20000022ff647230ULL, 0x000fe20000004100ULL,
0x000000ff1c447812ULL, 0x000fe200078ec0ffULL, 0x00a000001820783bULL, 0x000e620000000200ULL,
0x0000ffff1e867812ULL, 0x000fe200078ec0ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000000ff75757812ULL, 0x000fe200078ec0ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x000000ff66667812ULL, 0x000fe200078ec0ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fc40000011685ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000044ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe40000011686ULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000008ff767819ULL, 0x000fe40000011676ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fc400020006ffULL,
0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff807819ULL, 0x000fe4000001161eULL, 0x00000010ff6b7819ULL, 0x000fc40000011648ULL,
0x0000007eff44723eULL, 0x000fe200020006ffULL, 0x20000074ff7e7230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000008ff8d7819ULL, 0x000fe2000001167fULL,
0x20000075ff7f7230ULL, 0x000fe20000004100ULL, 0x0000ffff481e7812ULL, 0x040fe200078ec0ffULL,
0x20000066ff757230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x0000001720208231ULL, 0x082fe200003400ffULL, 0x00000073ff74723eULL, 0x000fe200020006ffULL,
0x2000008bff737230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000085ff8b7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x20000086ff857230ULL, 0x000fe20000004100ULL, 0x00000018ff1b7819ULL, 0x000fe2000001161cULL,
0x20000076ff867230ULL, 0x000fe20000004100ULL, 0x00000071ff66723eULL, 0x000fe200020006ffULL,
0x2000006aff767230ULL, 0x000fe20000004100ULL, 0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL,
0x20000072ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff1e7819ULL, 0x000fe2000001161eULL,
0x20000066ff727230ULL, 0x000fe20000004100ULL, 0x000000ff1f1f7812ULL, 0x000fe200078ec0ffULL,
0x0000001722228231ULL, 0x000fe200003400ffULL, 0x0000001bff81723eULL, 0x000fe200020006ffULL,
0x0000001621218231ULL, 0x080fe200003400ffULL, 0x0000006bff6a723eULL, 0x000fe200020006ffULL,
0x0000001623238231ULL, 0x000fe200003400ffULL, 0x0000001eff66723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x0000001fff6b723eULL, 0x000fe200020006ffULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe20000011683ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff1f7819ULL, 0x000fe2000001168aULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fe2000001168cULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff486f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1c7819ULL, 0x000fe4000001164aULL, 0x00000018ff887819ULL, 0x000fe40000011648ULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x000010541f1e7816ULL, 0x000fe4000000001eULL,
0x00000010ff7c7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b487812ULL, 0x000fc400078ec0ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x00001054831f7816ULL, 0x000fe40000000084ULL, 0x0000006fff4b723eULL, 0x000fe200020006ffULL,
0x20000068ff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff837819ULL, 0x000fe4000001161dULL,
0x000000ff1c847812ULL, 0x000fe200078ec0ffULL, 0x2000004bff687230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x0000001e2028723cULL, 0x000b620000041828ULL,
0x00000010ff817819ULL, 0x000fc40000011681ULL, 0x00000010ff827819ULL, 0x000fe20000011682ULL,
0x20000088ff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe40000011689ULL,
0x00000010ff1d7819ULL, 0x000fe4000001168bULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00001054811c7816ULL, 0x000fe2000000001cULL,
0x20000080ff887230ULL, 0x000fe20000004100ULL, 0x00001054821d7816ULL, 0x000fe2000000001dULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x020fc40000011667ULL,
0x00000010ff1f7819ULL, 0x000fe40000011688ULL, 0x00000010ff817819ULL, 0x000fe2000001166cULL,
0x0000001c202c723cULL, 0x000b62000004182cULL, 0x00000010ff827819ULL, 0x000fe40000011687ULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff1c7819ULL, 0x020fc40000011685ULL, 0x00000010ff1d7819ULL, 0x000fe40000011686ULL,
0x000010541f1e7816ULL, 0x000fe4000000001eULL, 0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL,
0x00001054821f7816ULL, 0x000fe40000000081ULL, 0x000010547d1c7816ULL, 0x000fe4000000001cULL,
0x000010547e1d7816ULL, 0x000fc4000000001dULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x0000001e2030723cULL, 0x040fe20000041830ULL, 0x00000008ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff447819ULL, 0x000fe20000011644ULL, 0x2000007aff807230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x0000008dff7a723eULL, 0x000fe200020006ffULL,
0x0000001c2034723cULL, 0x000b620000041834ULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x00a000000a1c783bULL, 0x020e620000000200ULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000008ff7d7819ULL, 0x000fe40000011648ULL,
0x000000ff497e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff487819ULL, 0x000fe40000011679ULL,
0x00000010ff497819ULL, 0x000fc4000001167aULL, 0x000010547f447816ULL, 0x000fe40000000044ULL,
0x0000105480457816ULL, 0x000fe40000000045ULL, 0x0000105477487816ULL, 0x000fe40000000048ULL,
0x0000105478497816ULL, 0x000fe40000000049ULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x000000442038723cULL, 0x000be20000041838ULL, 0x00000010ff767819ULL, 0x000fc40000011676ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff447819ULL, 0x020fe20000011673ULL, 0x00000048203c723cULL, 0x000b62000004183cULL,
0x00000010ff457819ULL, 0x000fe40000011674ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000105475447816ULL, 0x000fe20000000044ULL, 0x000000171c1cd231ULL, 0x082fe200003400ffULL,
0x00000010ff487819ULL, 0x020fe20000011671ULL, 0x20000083ff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff497819ULL, 0x000fe20000011672ULL, 0x000000171e1ed231ULL, 0x000fe200003400ffULL,
0x0000105476457816ULL, 0x000fe20000000045ULL, 0x000000161d1dd231ULL, 0x080fe200003400ffULL,
0x000010546f487816ULL, 0x000fe20000000048ULL, 0x000000161f1fd231ULL, 0x000fe200003400ffULL,
0x0000105470497816ULL, 0x000fc40000000049ULL, 0x0000ffff4a7b7812ULL, 0x000fe200078ec0ffULL,
0x000000442040723cULL, 0x040b620000041840ULL, 0x00000018ff597819ULL, 0x000fe4000001164aULL,
0x00000008ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff447819ULL, 0x020fe20000011668ULL, 0x000000482024723cULL, 0x000b620000041824ULL,
0x00000010ff457819ULL, 0x000fc4000001166aULL, 0x00000010ff6a7819ULL, 0x000fe4000001166bULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff207819ULL, 0x020fe40000011666ULL, 0x00000010ff217819ULL, 0x000fe4000001166cULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000000ff4a577812ULL, 0x000fe200078ec0ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL, 0x2000007dff747230ULL, 0x000fe20000004100ULL,
0x0000105445447816ULL, 0x000fe40000000044ULL, 0x000010546a457816ULL, 0x000fc40000000069ULL,
0x000010544b207816ULL, 0x000fe40000000020ULL, 0x000010544c217816ULL, 0x000fe40000000021ULL,
0x00000010ff6d7819ULL, 0x100fe2000001164dULL, 0x000000441c28723cULL, 0x000b620000041828ULL,
0x00000018ff617819ULL, 0x000fe4000001164dULL, 0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x000000201c2c723cULL, 0x000b62000004182cULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff1b7819ULL, 0x000fe2000001164eULL,
0x20000084ff677230ULL, 0x000fe20000004100ULL, 0x000000ff4e627812ULL, 0x000fe200078ec0ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164fULL,
0x00000008ff6e7819ULL, 0x000fc4000001166eULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x0000ffff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff447819ULL, 0x020fe4000001165dULL,
0x00000010ff207819ULL, 0x000fc4000001167bULL, 0x00000010ff217819ULL, 0x000fe40000011674ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x000000ff1b1b7812ULL, 0x000fe200078ec0ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x2000006eff687230ULL, 0x000fe20000004100ULL,
0x000000ff6d6d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4a4a7812ULL, 0x000fe200078ec0ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000008ff4e7819ULL, 0x000fe4000001164eULL,
0x00000008ff4f7819ULL, 0x000fe4000001164fULL, 0x0000105459207816ULL, 0x000fe40000000020ULL,
0x0000105444217816ULL, 0x000fe40000000021ULL, 0x00000010ff227819ULL, 0x000fc40000011657ULL,
0x00000010ff237819ULL, 0x000fe40000011658ULL, 0x00000010ff677819ULL, 0x000fe20000011667ULL,
0x000000201c34723cULL, 0x000b620000041834ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x0000001bff1b723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000001bff457230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x2000007eff737230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000105467227816ULL, 0x000fe20000000022ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000010547c237816ULL, 0x000fe20000000023ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff1b7819ULL, 0x000fc40000011660ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff207819ULL, 0x020fe20000011661ULL, 0x000000221c30723cULL, 0x000b620000041830ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x000010541b687816ULL, 0x000fe40000000068ULL,
0x0000105420697816ULL, 0x000fe4000000004dULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x000000681c3c723cULL, 0x000b64000004183cULL, 0x00000010ff227819ULL, 0x020fe4000001166dULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff1b7819ULL, 0x000fe40000011664ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff207819ULL, 0x000fe40000011665ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00001054735e7816ULL, 0x000fc4000000005eULL, 0x00001054225f7816ULL, 0x000fe4000000005fULL,
0x0000105445627816ULL, 0x000fe40000000062ULL, 0x000010544a637816ULL, 0x000fe40000000063ULL,
0x000010541b4e7816ULL, 0x000fe2000000004eULL, 0x0000005e1c38723cULL, 0x000b620000041838ULL,
0x00001054204f7816ULL, 0x000fce000000004fULL, 0x000000621c40723cULL, 0x040b700000041840ULL,
0x0000004e1c24723cULL, 0x000b620000041824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000d1c7f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c00b1b7811ULL, 0x000fe200078e40ffULL,
0x00f6980056ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff207224ULL, 0x004fc400078e001dULL,
0x0000001a1b00720cULL, 0x000fe20003f06070ULL, 0x000000ffff1d7224ULL, 0x000fe400078e000fULL,
0x000000ffff597224ULL, 0x000fd400078e005bULL, 0x00002ce000000947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x008fc40000015200ULL, 0x00000004190f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fca00078ec0ffULL, 0x00f6cc000f1b7984ULL, 0x000ea40000000800ULL,
0x800000001bff7812ULL, 0x004fe40007804820ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c1e7210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09001e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1b7819ULL, 0x000fc8000001141fULL, 0x0000001e1b1b7211ULL, 0x000fca00078110ffULL,
0x000000ffff1e7224ULL, 0x000fca00000e061fULL, 0x000000021b1b7819ULL, 0x000fc8000000121eULL,
0x0000001b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000121217810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6cc000f1b7984ULL, 0x000ea40000000800ULL, 0x800000001bff7812ULL, 0x004fe40007804820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020b0f7810ULL, 0x000fc80007ffe0ffULL,
0x000000020f00720cULL, 0x000fe40003f06070ULL, 0x000001000e0f7810ULL, 0x000fca0007ffe0ffULL,
0x0000620006227a24ULL, 0x000fcc00078e020fULL, 0x000003c000008947ULL, 0x000fea0003800000ULL,
0x0000000f1a0e7217ULL, 0x000fe20007800000ULL, 0x0000001007447824ULL, 0x000fe200078e00ffULL,
0x00000003ff207819ULL, 0x000fe20000011600ULL, 0x00000010001b7824ULL, 0x000fe400078e00ffULL,
0x000000010e0f7824ULL, 0x000fe200078e0a0fULL, 0x00000004201e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001441d7824ULL, 0x040fe200078e0220ULL, 0x000000701b0e7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff457424ULL, 0x000fe200078e00ffULL, 0x0000000f440f7217ULL, 0x000fe20007800000ULL,
0x000000011d1c7824ULL, 0x000fc400078e0222ULL, 0x000000011d1b7824ULL, 0x040fe400078e0200ULL,
0x000000081d487824ULL, 0x000fe400078e00ffULL, 0x000000010f0f7824ULL, 0x000fe400078e0a44ULL,
0x00000001441f7824ULL, 0x000fe200078e021eULL, 0xfffffff8481b7812ULL, 0x000fe200078ee21bULL,
0x00005e001c1c7625ULL, 0x000fe200078e0045ULL, 0x0000000f1e00720cULL, 0x080fe40003f06070ULL,
0x0000000f2000720cULL, 0x000fe20003fa6070ULL, 0x000000011f217824ULL, 0x040fe200078e0200ULL,
0x0000000e1c1e7210ULL, 0x000fe20007fde0ffULL, 0x000000081f487824ULL, 0x000fc400078e00ffULL,
0x000000011f1c7824ULL, 0x000fe400078e0222ULL, 0x000000ffff1f7224ULL, 0x000fe200030e061dULL,
0xfffffff848237812ULL, 0x000fe200078ee221ULL, 0x00005e001c1c7625ULL, 0x000fe200078e0045ULL,
0x0000000820217810ULL, 0x040fe40007ffe0ffULL, 0x0000000c20487810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0254ULL, 0x0000000e1c207210ULL, 0x000fe20007fde0ffULL,
0x0000000144497824ULL, 0x000fc400078e0221ULL, 0x00000001444b7824ULL, 0x000fe200078e0248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e1b7faeULL, 0x0005e2000e901c46ULL,
0x00000001491c7824ULL, 0x000fe200078e0222ULL, 0x0000000f2100720cULL, 0x080fe20003fa6070ULL,
0x000000ffff217224ULL, 0x000fe200030e061dULL, 0x0000000f4800720cULL, 0x000fe20003fc6070ULL,
0x0000001023237824ULL, 0x000fe400078e0254ULL, 0x00005e001c1c7625ULL, 0x000fc600078e0045ULL,
0x0000000020237faeULL, 0x0007e2000c101c46ULL, 0x000000014b0f7824ULL, 0x000fe200078e0222ULL,
0x0000000e1c1c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001491b7824ULL, 0x144fe400078e0200ULL,
0x0000000849447824ULL, 0x000fe400078e00ffULL, 0x000000014b227824ULL, 0x000fe400078e0200ULL,
0x00005e000f1e7625ULL, 0x000fe200078e0045ULL, 0xfffffff8440f7812ULL, 0x000fc600078ee21bULL,
0x000000084b4b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x0000000e1e1e7210ULL, 0x000fe20007f1e0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0254ULL,
0xfffffff84b1b7812ULL, 0x000fc600078ee222ULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x000000001c0f7faeULL, 0x0007e2000e901c46ULL, 0x000000101b1b7824ULL, 0x000fca00078e0254ULL,
0x000000001e1b7faeULL, 0x0007e2000f101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x00000010070f7824ULL, 0x000fe400078e00ffULL, 0x00000010000e7824ULL, 0x040fe400078e00ffULL,
0x00000080ff217424ULL, 0x000fe200078e00ffULL, 0x0000000f000f7211ULL, 0x000fe400078fe8ffULL,
0x000000700e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000040f1d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010f1b7824ULL, 0x040fe200078e0200ULL, 0x000000080f237810ULL, 0x040fe20007ffe0ffULL,
0x000000080f1c7824ULL, 0x040fe200078e00ffULL, 0x0000000c0f457810ULL, 0x000fe20007ffe0ffULL,
0x000000081d487824ULL, 0x000fc400078e00ffULL, 0x00000001231e7824ULL, 0x100fe200078e0222ULL,
0xfffffff81c1f7812ULL, 0x000fe200078ee21bULL, 0x000000010f1c7824ULL, 0x100fe400078e0222ULL,
0x000000011d1b7824ULL, 0x040fe400078e0222ULL, 0x000000011d0f7824ULL, 0x000fe400078e0200ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0021ULL, 0x0000000123447824ULL, 0x040fe400078e0200ULL,
0x0000000823497824ULL, 0x000fe400078e00ffULL, 0x0000000145207824ULL, 0x040fe200078e0222ULL,
0x0000000e1c227210ULL, 0x000fe20007f1e0ffULL, 0x0000000145237824ULL, 0x000fe200078e0200ULL,
0xfffffff849497812ULL, 0x000fe200078ee244ULL, 0x00000008454a7824ULL, 0x000fe200078e00ffULL,
0xfffffff848457812ULL, 0x000fe200078ee20fULL, 0x000000101f0f7824ULL, 0x000fc400078e0254ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0021ULL, 0xfffffff84a4b7812ULL, 0x000fc600078ee223ULL,
0x000000ffff237224ULL, 0x000fe200000e061dULL, 0x0000000e1e1e7210ULL, 0x000fe20007fbe0ffULL,
0x00005e001b1c7625ULL, 0x000fc600078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000220f7faeULL, 0x0005e2000b901c46ULL, 0x00005e0020207625ULL, 0x000fe200078e0021ULL,
0x0000000e1c1c7210ULL, 0x000fc60007f1e0ffULL, 0x00000010451b7824ULL, 0x100fe200078e0254ULL,
0x0000000e20207210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1d7224ULL, 0x000fe400000e061dULL,
0x0000001049457824ULL, 0x100fe400078e0254ULL, 0x000000ffff1f7224ULL, 0x000fe200028e061fULL,
0x000000001c1b7faeULL, 0x0005e2000b901c46ULL, 0x000000104b497824ULL, 0x000fe400078e0254ULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x000000001e457faeULL, 0x0005e8000b901c46ULL,
0x0000000020497faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x00cfe20000000000ULL,
0xffffffe0030f7812ULL, 0x040fe200078ec0ffULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x00000010031c7812ULL, 0x000fc400078ec0ffULL, 0x00000008031b7812ULL, 0x000fe400078ec0ffULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000000f1b1b7210ULL, 0x000fd60007ffe01cULL,
0x00000000520403c2ULL, 0x000ea40000080000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000270f070ULL, 0xffffff8000004947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a80053587f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f668001b207f8cULL, 0x0002a4000c80043fULL,
0x00000000001c7805ULL, 0x000fc40000015200ULL, 0x00f66c001b0f7984ULL, 0x000f240000000800ULL,
0x800000000fff7812ULL, 0x014fc40007804821ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c1e7210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09001e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc8000001141fULL, 0x0000001e0f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff1e7224ULL, 0x000fca00000e061fULL, 0x000000020f0f7819ULL, 0x000fc8000000121eULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c001b0f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001800e107810ULL, 0x000fca0007ffe010ULL,
0x0000000111107824ULL, 0x000fca00078e0210ULL, 0x00f00000100f7984ULL, 0x000ea80000000800ULL,
0x00f20000101c7984ULL, 0x0002e20000000800ULL, 0x0000005c0f00720bULL, 0x004fe20003f1d000ULL,
0x000085f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x002fc800000e0100ULL,
0x0000ffff10ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1b7424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000003191e7811ULL, 0x000fe400078ff0ffULL, 0x0000005c0f00720bULL, 0x000fe40003f14000ULL,
0x000000191e00720cULL, 0x000fe20003fa5270ULL, 0x000085b27f007947ULL, 0x000fd4000b800000ULL,
0x00000000001b7806ULL, 0x000fc400000e0100ULL, 0x000000801912d824ULL, 0x000fe200078e020eULL,
0x0000005c0f0ed209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001111dd824ULL, 0x000fe200078e0212ULL, 0x000099101b117816ULL, 0x000fc800000000ffULL,
0x00f4000e1d00d388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000005c0f117209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff1bff7812ULL, 0x000fc6000780c0ffULL,
0x0000005c110e7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL,
0x0000000e00127308ULL, 0x000e640000000800ULL, 0x0000001209097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x000084d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e120e7589ULL, 0x0002a400000e0000ULL,
0x0000000e28287220ULL, 0x084fe20000410000ULL, 0x0000000e29297220ULL, 0x080fe20000410000ULL,
0x0000000e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000e30307220ULL, 0x080fe20000410000ULL, 0x0000000e31317220ULL, 0x080fe20000410000ULL,
0x0000000e34347220ULL, 0x080fe20000410000ULL, 0x0000000e35357220ULL, 0x080fe20000410000ULL,
0x0000000e38387220ULL, 0x080fe20000410000ULL, 0x0000000e39397220ULL, 0x080fe20000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000e40407220ULL, 0x080fe20000410000ULL, 0x0000000e41417220ULL, 0x080fe20000410000ULL,
0x0000000e24247220ULL, 0x080fe20000410000ULL, 0x0000000e25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x002fe200078ff0ffULL,
0x000083c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e120e7589ULL, 0x0002a400000e0000ULL,
0x0000000e2a2a7220ULL, 0x084fe20000410000ULL, 0x0000000e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000e32327220ULL, 0x080fe20000410000ULL, 0x0000000e33337220ULL, 0x080fe20000410000ULL,
0x0000000e36367220ULL, 0x080fe20000410000ULL, 0x0000000e37377220ULL, 0x080fe20000410000ULL,
0x0000000e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000e42427220ULL, 0x080fe20000410000ULL, 0x0000000e43437220ULL, 0x080fe20000410000ULL,
0x0000000e26267220ULL, 0x080fe20000410000ULL, 0x0000000e27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff1bff7812ULL, 0x000fe20007800810ULL,
0x00000001ff1b7424ULL, 0x000fe200078e00ffULL, 0x0000005c0f5c7209ULL, 0x000fd60007810000ULL,
0x8000005c0f0f0221ULL, 0x000fe20000010000ULL, 0x00007610ff1b0816ULL, 0x000fc6000000001bULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00150308ULL, 0x000e640000000800ULL,
0x000000151c1c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000091c097221ULL, 0x008fc20000010000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000108557824ULL, 0x000fca00078e0255ULL, 0x00f6ac0055117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e1d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000001d10107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0055117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101b0e7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000015ff0e723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x000054100e0e7816ULL, 0x000fe2000000000eULL,
0x00007f927f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e177589ULL, 0x0002a400000e0000ULL,
0x000000080f1e7810ULL, 0x000fe20007ffe0ffULL, 0x00007fc27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e0e167589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200078e000eULL,
0x0000b34000497802ULL, 0x000fc40000000f00ULL, 0x0000845000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x004fe200078e000eULL, 0x0000b39000497802ULL, 0x000fc40000000f00ULL,
0x0000840000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005148783bULL, 0x000f280000004200ULL,
0x000000005020783bULL, 0x004ea80000004200ULL, 0x000000004610783bULL, 0x000ee80000004200ULL,
0x00000000471c783bULL, 0x008ee20000004200ULL, 0x00000018ff147819ULL, 0x010fc40000011648ULL,
0x000000ff481b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff507819ULL, 0x004fe40000011620ULL,
0x00000014ff70723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x00000010ff637819ULL, 0x100fe20000011622ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000000ff225a7812ULL, 0x000fe200078ec0ffULL, 0x20000050ff607230ULL, 0x000fe20000004100ULL,
0x00000018ff587819ULL, 0x000fc40000011622ULL, 0x0000ffff22697812ULL, 0x000fe400078ec0ffULL,
0x0000001bff73723eULL, 0x000fe400020006ffULL, 0x00000010ff557819ULL, 0x100fe40000011611ULL,
0x000000ff114e7812ULL, 0x040fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000018ff4c7819ULL, 0x000fe40000011611ULL, 0x0000ffff11147812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1b7819ULL, 0x100fe40000011612ULL, 0x000000ff124d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff117819ULL, 0x000fe40000011612ULL, 0x0000ffff12227812ULL, 0x000fe400078ec0ffULL,
0x000000ff13127812ULL, 0x000fe400078ec0ffULL, 0x0000004eff4e723eULL, 0x000fc400020006ffULL,
0x00000010ff787819ULL, 0x000fe40000011648ULL, 0x0000ffff48527812ULL, 0x000fe400078ec0ffULL,
0x00000010ff797819ULL, 0x100fe40000011649ULL, 0x000000ff49447812ULL, 0x040fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011649ULL, 0x0000ffff49777812ULL, 0x000fc400078ec0ffULL,
0x000000ff4b4f7812ULL, 0x000fe400078ec0ffULL, 0x0000004cff50723eULL, 0x000fe200020006ffULL,
0x2000004eff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x100fe4000001164aULL,
0x000000ff4a487812ULL, 0x040fe200078ec0ffULL, 0x20000050ff4e7230ULL, 0x000fe20000004100ULL,
0x00000018ff467819ULL, 0x000fe4000001164aULL, 0x0000ffff4a747812ULL, 0x000fc400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe4000001164bULL, 0x00000018ff497819ULL, 0x000fe4000001164bULL,
0x0000ffff4b6a7812ULL, 0x000fe400078ec0ffULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x00000010ff657819ULL, 0x108fe4000001161cULL, 0x000000ff1c7c7812ULL, 0x000fe200078ec0ffULL,
0x20000012ff507230ULL, 0x000fe20000004100ULL, 0x00000018ff7b7819ULL, 0x000fc4000001161cULL,
0x0000ffff1c627812ULL, 0x000fe400078ec0ffULL, 0x00000018ff477819ULL, 0x000fe4000001161fULL,
0x00000010ff5f7819ULL, 0x100fe40000011610ULL, 0x000000ff104a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011610ULL, 0x0000ffff10577812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1c7819ULL, 0x100fe4000001161dULL, 0x000000ff1d7e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001161dULL, 0x0000ffff1d0f7812ULL, 0x002fe400078ec0ffULL,
0x00000018ff107819ULL, 0x000fe40000011613ULL, 0x00000010ff647819ULL, 0x000fc40000011623ULL,
0x000000ff235b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011623ULL,
0x0000ffff23687812ULL, 0x000fe400078ec0ffULL, 0x00000044ff1d723eULL, 0x000fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000010ff237819ULL, 0x000fe20000011613ULL,
0x2000001dff1d7230ULL, 0x000fe20000004100ULL, 0x0000ffff13447812ULL, 0x000fe200078ec0ffULL,
0x2000004fff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff20517812ULL, 0x000fc400078ec0ffULL,
0x00000047ff13723eULL, 0x000fe400020006ffULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x00000010ff12723eULL, 0x000fe400020006ffULL, 0x000000ff75757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6f7819ULL, 0x000fe40000011621ULL, 0x000000ff21547812ULL, 0x000fc400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe40000011621ULL, 0x0000ffff21727812ULL, 0x000fe400078ec0ffULL,
0x00000008ff107819ULL, 0x000fe20000011652ULL, 0x20000012ff527230ULL, 0x000fe20000004100ULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000010ff0e7819ULL, 0x000fe4000001161eULL,
0x000000ff1e807812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001161eULL,
0x0000ffff1e217812ULL, 0x000fe400078ec0ffULL, 0x00000051ff1e723eULL, 0x000fe200020006ffULL,
0x20000011ff517230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000004aff4f723eULL, 0x000fe200020006ffULL, 0x20000013ff4a7230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000005aff5d7230ULL, 0x000fe20000004100ULL,
0x0000004bff13723eULL, 0x000fe200020006ffULL, 0x2000004fff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff10723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x00000076ff11723eULL, 0x000fe200020006ffULL, 0x20000075ff767230ULL, 0x000fe20000004100ULL,
0x0000007aff5a723eULL, 0x000fe200020006ffULL, 0x20000010ff7a7230ULL, 0x000fe20000004100ULL,
0x0000004dff4f723eULL, 0x000fe200020006ffULL, 0x20000013ff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x20000011ff757230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fe20000011669ULL, 0x00a800001810783bULL, 0x0002a20000000200ULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff79797812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000000ff65657812ULL, 0x000fc400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000069ff18723eULL, 0x002fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000063ff697230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000018ff637230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x000000ff1c1c7812ULL, 0x000fe200078ec0ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000008ff777819ULL, 0x000fc40000011677ULL,
0x00000008ff187819ULL, 0x000fe20000011662ULL, 0x20000065ff627230ULL, 0x000fe20000004100ULL,
0x0000001cff65723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe20000011673ULL, 0x20000045ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe2000001161dULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fc40000011678ULL, 0x00000010ff787819ULL, 0x000fe40000011679ULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x00000010ff6d7819ULL, 0x000fe20000011620ULL,
0x0000001710108231ULL, 0x084fe200003400ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x0000001712128231ULL, 0x000fe200003400ffULL, 0x00001054781d7816ULL, 0x000fe20000000073ULL,
0x0000001611118231ULL, 0x080fe200003400ffULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x0000001613138231ULL, 0x000fe200003400ffULL, 0x00000008ff747819ULL, 0x000fe20000011674ULL,
0x20000048ff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe2000001160fULL,
0x20000053ff617230ULL, 0x000fe20000004100ULL, 0x000000ff0e787812ULL, 0x000fc400078ec0ffULL,
0x00000008ff6a7819ULL, 0x000fe2000001166aULL, 0x0000001c1028723cULL, 0x000be20000041828ULL,
0x00000010ff0f7819ULL, 0x000fe40000011670ULL, 0x00000010ff0e7819ULL, 0x000fe4000001167aULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000010ff707819ULL, 0x000fe40000011671ULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x20000046ff667230ULL, 0x000fe20000004100ULL,
0x0000ffff206e7812ULL, 0x000fc400078ec0ffULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff207819ULL, 0x000fe4000001161fULL, 0x000000ff1f817812ULL, 0x040fe200078ec0ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x0000ffff1f5e7812ULL, 0x000fc400078ec0ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x000010540f0e7816ULL, 0x000fe2000000000eULL, 0x20000049ff677230ULL, 0x000fe20000004100ULL,
0x00000054ff1f723eULL, 0x000fe400020006ffULL, 0x0000007cff53723eULL, 0x000fe400020006ffULL,
0x00001054700f7816ULL, 0x000fe20000000077ULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x00000008ff6e7819ULL, 0x000fe2000001166eULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x0000006fff7c723eULL, 0x000fe200020006ffULL,
0x0000000e102c723cULL, 0x000b62000004182cULL, 0x0000007dff46723eULL, 0x000fe200020006ffULL,
0x2000006dff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff7d7819ULL, 0x000fe20000011672ULL,
0x2000006aff727230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x020fe2000001166cULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x000fe40000011676ULL,
0x0000007bff45723eULL, 0x000fc400020006ffULL, 0x00000010ff707819ULL, 0x000fe4000001166bULL,
0x00000010ff757819ULL, 0x000fe20000011675ULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x0000006eff7b723eULL, 0x000fe200020006ffULL, 0x2000007cff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff20207812ULL, 0x000fe400078ec0ffULL, 0x00000008ff217819ULL, 0x000fe20000011621ULL,
0x2000007bff6a7230ULL, 0x000fe20000004100ULL, 0x000010541d1c7816ULL, 0x000fc4000000001cULL,
0x00001054751d7816ULL, 0x000fe40000000070ULL, 0x00000010ff0f7819ULL, 0x000fe40000011666ULL,
0x00000010ff0e7819ULL, 0x000fe40000011674ULL, 0x00000010ff677819ULL, 0x000fe20000011667ULL,
0x0000001c1030723cULL, 0x000b620000041830ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000020ff20723eULL, 0x000fc400020006ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000010ff1e7819ULL, 0x000fe4000001161eULL, 0x00000010ff1f7819ULL, 0x000fe2000001161fULL,
0x20000021ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x000010540f0e7816ULL, 0x000fc4000000000eULL,
0x00001054670f7816ULL, 0x000fe20000000072ULL, 0x20000020ff677230ULL, 0x000fe20000004100ULL,
0x000010546f207816ULL, 0x000fe4000000001eULL, 0x000010546e217816ULL, 0x000fe4000000001fULL,
0x00a800000a1c783bULL, 0x020e620000000200ULL, 0x0000007dff6d723eULL, 0x000fe200020006ffULL,
0x0000000e1034723cULL, 0x000be20000041834ULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7b7819ULL, 0x000fe20000011668ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x00000008ff6e7819ULL, 0x000fe2000001165eULL,
0x000000201038723cULL, 0x000b640000041838ULL, 0x00000010ff0f7819ULL, 0x020fe20000011660ULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x00000010ff0e7819ULL, 0x000fe4000001166aULL,
0x00000010ff5e7819ULL, 0x000fe40000011661ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000007bff64723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x000010540f0e7816ULL, 0x000fe2000000000eULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x000010545e0f7816ULL, 0x000fe2000000006dULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff207819ULL, 0x000fe4000001165dULL, 0x000000ff555d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff217819ULL, 0x000fe2000001165bULL, 0x0000000e103c723cULL, 0x000b62000004183cULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff557819ULL, 0x000fe2000001165aULL, 0x000000171c1c8231ULL, 0x082fe200003400ffULL,
0x00000010ff0f7819ULL, 0x020fe20000011658ULL, 0x000000171e1e8231ULL, 0x000fe200003400ffULL,
0x00000010ff0e7819ULL, 0x000fe20000011663ULL, 0x000000161d1d8231ULL, 0x080fe200003400ffULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x000000161f1f8231ULL, 0x000fe200003400ffULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x00000081ff48723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x20000080ff477230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x20000018ff187230ULL, 0x000fe20000004100ULL,
0x000010540f0e7816ULL, 0x000fe2000000000eULL, 0x20000073ff6c7230ULL, 0x000fe20000004100ULL,
0x0000105469207816ULL, 0x000fe20000000020ULL, 0x20000078ff6b7230ULL, 0x000fe20000004100ULL,
0x0000105468217816ULL, 0x000fc40000000021ULL, 0x00001054550f7816ULL, 0x000fe40000000064ULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x000000201040723cULL, 0x000f620000041840ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff187819ULL, 0x000fe40000011618ULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x0000000e1024723cULL, 0x000b620000041824ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff577819ULL, 0x000fe20000011657ULL,
0x2000005fff0a7230ULL, 0x000fe20000004100ULL, 0x000000ff23237812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff0f7819ULL, 0x020fe4000001166cULL,
0x00000010ff117819ULL, 0x000fc40000011648ULL, 0x00000010ff107819ULL, 0x000fe4000001166bULL,
0x00000010ff127819ULL, 0x000fe40000011667ULL, 0x00001054450e7816ULL, 0x000fe40000000018ULL,
0x00001054460f7816ULL, 0x000fe4000000000fULL, 0x0000105410107816ULL, 0x000fe40000000047ULL,
0x0000105412117816ULL, 0x000fc40000000011ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x0000000e1c2c723cULL, 0x040b62000004182cULL, 0x00000008ff147819ULL, 0x000fe40000011614ULL,
0x000000ff1b1b7812ULL, 0x000fe200078ec0ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000008ff227819ULL, 0x000fe40000011622ULL, 0x00000008ff447819ULL, 0x000fe20000011644ULL,
0x000000101c30723cULL, 0x000b620000041830ULL, 0x00000010ff4b7819ULL, 0x000fc4000001164bULL,
0x00000010ff0f7819ULL, 0x020fe4000001164cULL, 0x00000010ff0a7819ULL, 0x000fe4000001160aULL,
0x00000010ff107819ULL, 0x000fe4000001165dULL, 0x00000023ff23723eULL, 0x000fe400020006ffULL,
0x0000007eff54723eULL, 0x000fe400020006ffULL, 0x0000007fff49723eULL, 0x000fe200020006ffULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x0000001bff1b723eULL, 0x000fe200020006ffULL,
0x2000006eff5b7230ULL, 0x000fe20000004100ULL, 0x00000022ff22723eULL, 0x000fe200020006ffULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x000010540a0e7816ULL, 0x000fe2000000004bULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00001054100f7816ULL, 0x000fe2000000000fULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000010ff0a7819ULL, 0x000fc4000001164dULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff207819ULL, 0x000fe20000011653ULL,
0x0000000e1c38723cULL, 0x000b620000041838ULL, 0x00000010ff217819ULL, 0x000fe40000011662ULL,
0x000010540a107816ULL, 0x000fe40000000057ULL, 0x00000010ff127819ULL, 0x000fe40000011623ULL,
0x00000010ff547819ULL, 0x000fc40000011654ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff4e7819ULL, 0x000fc4000001164eULL, 0x00000010ff117819ULL, 0x000fe40000011614ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff0a7819ULL, 0x000fe4000001161bULL,
0x00000010ff0f7819ULL, 0x020fe40000011650ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff227819ULL, 0x000fc40000011622ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff237819ULL, 0x000fe40000011644ULL, 0x0000105421207816ULL, 0x000fe40000000020ULL,
0x0000105465217816ULL, 0x000fe40000000054ULL, 0x0000105449667816ULL, 0x000fe40000000066ULL,
0x000010544a677816ULL, 0x000fc4000000005bULL, 0x000010544e117816ULL, 0x000fe20000000011ULL,
0x000000201c28723cULL, 0x040b620000041828ULL, 0x000010540a0e7816ULL, 0x000fe4000000004fULL,
0x00001054120f7816ULL, 0x000fe4000000000fULL, 0x0000105451227816ULL, 0x000fe40000000022ULL,
0x0000105452237816ULL, 0x000fe20000000023ULL, 0x000000661c34723cULL, 0x040b700000041834ULL,
0x000000101c3c723cULL, 0x040b70000004183cULL, 0x0000000e1c40723cULL, 0x040b700000041840ULL,
0x000000221c24723cULL, 0x000b620000041824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000d0e7f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a00056ff7f8cULL, 0x0007e2000c80043fULL,
0x000000010c1d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff207224ULL, 0x004fc400078e000fULL,
0x000000010b0b7810ULL, 0x008fc80007ffe0ffULL, 0x000000020b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff451000007947ULL, 0x000fea000383ffffULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000009007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000cb5000067802ULL, 0x000fc40000000f00ULL,
0x00006a8000007944ULL, 0x00efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x000f240000001000ULL, 0xbf80000000027423ULL, 0x010fc80000000009ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000067919ULL, 0x000e680000000000ULL, 0x00000000000a7919ULL, 0x008ee20000000000ULL,
0x00000002ff097819ULL, 0x006fe40000011606ULL, 0x000000080a0b7811ULL, 0x008fe200078ff0ffULL,
0x0000000003087220ULL, 0x010fca0000410000ULL, 0x00001f0908007589ULL, 0x000e6800000e0000ULL,
0x00001f0b08067589ULL, 0x000ea200000e0000ULL, 0x0000002800287220ULL, 0x042fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x000fe20000410000ULL, 0x0000002a062a7220ULL, 0x044fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x0000003206327220ULL, 0x040fe20000410000ULL,
0x0000003306337220ULL, 0x040fe20000410000ULL, 0x0000003606367220ULL, 0x040fe20000410000ULL,
0x0000003706377220ULL, 0x040fe20000410000ULL, 0x0000003a063a7220ULL, 0x040fe20000410000ULL,
0x0000003b063b7220ULL, 0x040fe20000410000ULL, 0x0000003e063e7220ULL, 0x040fe20000410000ULL,
0x0000003f063f7220ULL, 0x040fe20000410000ULL, 0x0000004206427220ULL, 0x040fe20000410000ULL,
0x0000004306437220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000800097811ULL, 0x010fc400078ff0ffULL,
0x00000002ff0b7819ULL, 0x008fe40000011600ULL, 0x0000000200027812ULL, 0x000fe200078ec0ffULL,
0x00000008090d7824ULL, 0x002fe400078e00ffULL, 0x000000080b0c7824ULL, 0x040fe200078e00ffULL,
0x0000000b02037211ULL, 0x040fe400078ff8ffULL, 0x0000000902067211ULL, 0x000fe200078ff8ffULL,
0x000000080b097824ULL, 0x000fe200078e00ffULL, 0x0000000203027810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80d0e7812ULL, 0x000fe200078ee206ULL, 0x000000080b067824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x000fe200078ee202ULL, 0x000000080b0d7824ULL, 0x000fe200078e00ffULL,
0x00000004030a7810ULL, 0x000fe20007ffe0ffULL, 0x0000100007097824ULL, 0x000fe200078e00ffULL,
0x00000006030b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff806027812ULL, 0x000fe200078ee203ULL,
0x0000000800067824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL,
0x0000080004037824ULL, 0x000fe200078e0209ULL, 0xfffffff80c0c7812ULL, 0x000fc400078ee20bULL,
0x00000008060b7812ULL, 0x000fe200078ec0ffULL, 0x000000100e127824ULL, 0x100fe400078e0203ULL,
0x0000001002067824ULL, 0x100fe200078e0203ULL, 0x000000282902723eULL, 0x000fe200000010ffULL,
0x0000001008087824ULL, 0x100fe400078e0203ULL, 0x000000100a0e7824ULL, 0x100fe400078e0203ULL,
0x000000100c107824ULL, 0x000fe200078e0203ULL, 0x0000002c2d03723eULL, 0x000fe200000010ffULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x000000383906723eULL, 0x000fe200000010ffULL,
0x000000010b127824ULL, 0x040fe200078e0212ULL, 0x0000541002147816ULL, 0x140fe20000000003ULL,
0x000000010b0c7824ULL, 0x040fe200078e0208ULL, 0x0000763202157816ULL, 0x000fe20000000003ULL,
0x000000010b0e7824ULL, 0x000fe200078e020eULL, 0x000000303102723eULL, 0x000fe200000010ffULL,
0x000000010b107824ULL, 0x000fe200078e0210ULL, 0x000000343503723eULL, 0x000fe200000010ffULL,
0x000000140a007388ULL, 0x0003e20000000a00ULL, 0x0000003c3d08723eULL, 0x000fc400000010ffULL,
0x00007632020b7816ULL, 0x140fe40000000003ULL, 0x00005410020a7816ULL, 0x002fe40000000003ULL,
0x000000404102723eULL, 0x000fe400000010ffULL, 0x000000242503723eULL, 0x000fe200000010ffULL,
0x0000000a0c007388ULL, 0x0003e40000000a00ULL, 0x00005410060a7816ULL, 0x142fe40000000008ULL,
0x00007632060b7816ULL, 0x000fc40000000008ULL, 0x0000002a2b06723eULL, 0x000fe400000010ffULL,
0x0000002e2f08723eULL, 0x000fe200000010ffULL, 0x0000000a0e007388ULL, 0x0003e40000000a00ULL,
0x00005410020a7816ULL, 0x142fe40000000003ULL, 0x00007632020b7816ULL, 0x000fe40000000003ULL,
0x000000323302723eULL, 0x000fe400000010ffULL, 0x000000363703723eULL, 0x000fe200000010ffULL,
0x0000000a10007388ULL, 0x0003e40000000a00ULL, 0x00005410060a7816ULL, 0x002fc40000000008ULL,
0x00007632060b7816ULL, 0x000fe40000000008ULL, 0x0000003a3b06723eULL, 0x000fe400000010ffULL,
0x0000003e3f08723eULL, 0x000fe200000010ffULL, 0x0000000a12007388ULL, 0x0003e40000000a00ULL,
0x00005410020a7816ULL, 0x142fe40000000003ULL, 0x00007632020b7816ULL, 0x000fe40000000003ULL,
0x000000424302723eULL, 0x000fc400000010ffULL, 0x000000262703723eULL, 0x000fe200000010ffULL,
0x0004000a0c007388ULL, 0x0003e40000000a00ULL, 0x00005410060a7816ULL, 0x142fe40000000008ULL,
0x00007632060b7816ULL, 0x000fe20000000008ULL, 0x0000000105067824ULL, 0x000fe400078e0200ULL,
0x000000ff00057306ULL, 0x000fe40000205400ULL, 0x0004000a0e007388ULL, 0x0003e20000000a00ULL,
0x0000001006067824ULL, 0x000fe200078e0209ULL, 0x00005410020a7816ULL, 0x002fc40000000003ULL,
0x00007632020b7816ULL, 0x000fe40000000003ULL, 0x000000ff00027306ULL, 0x000e660000209400ULL,
0x0004000a10007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000006147984ULL, 0x000ee20000000c00ULL, 0x000000050200720bULL, 0x002fc60003f1d000ULL,
0x00040000060c7984ULL, 0x000e620000000c00ULL, 0x000000ff00027245ULL, 0x000fc6000020d400ULL,
0x0008000006187984ULL, 0x000f280000000c00ULL, 0x000c0000061c7984ULL, 0x000ea40000000c00ULL,
0x0000000102020812ULL, 0x000fe400078efcffULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000020202723eULL, 0x000fca00000010ffULL, 0x3f803f8002177831ULL, 0x048fe40000200017ULL,
0x3f803f8002167831ULL, 0x040fe40000200016ULL, 0x3f803f8002157831ULL, 0x040fe40000200015ULL,
0x3f803f8002147831ULL, 0x040fe40000200014ULL, 0x3f803f80020f7831ULL, 0x042fe4000020000fULL,
0x3f803f80020e7831ULL, 0x000fc4000020000eULL, 0x3f803f80020d7831ULL, 0x040fe4000020000dULL,
0x3f803f80020c7831ULL, 0x000fe4000020000cULL, 0x3f803f8017177831ULL, 0x010fe4000020001bULL,
0x3f803f8016167831ULL, 0x000fe4000020001aULL, 0x3f803f8015157831ULL, 0x000fe40000200019ULL,
0x3f803f8014147831ULL, 0x000fc40000200018ULL, 0x3f803f800f0f7831ULL, 0x004fe4000020001fULL,
0x3f803f800e0e7831ULL, 0x000fe2000020001eULL, 0x0000001406007388ULL, 0x000fe20000000c00ULL,
0x3f803f800d0d7831ULL, 0x000fe4000020001dULL, 0x3f803f800c0c7831ULL, 0x000fca000020001cULL,
0x0004000c06007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000067810ULL, 0x000fe20007ffe0ffULL,
0x0000000000107919ULL, 0x000e620000002600ULL, 0x00000003ff117819ULL, 0x000fe20000011600ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff057819ULL, 0x000fe20000011606ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000807137824ULL, 0x000fe200078e00ffULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000111027824ULL, 0x000fc400078e0200ULL,
0x0000000106047824ULL, 0x000fc600078e0205ULL, 0x0000000702037812ULL, 0x000fe400078ec0ffULL,
0x00000007040b7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803027812ULL, 0x000fe400078ef800ULL,
0x0ffffff80b047812ULL, 0x000fc600078ef806ULL, 0x0000001002027824ULL, 0x100fe400078e0209ULL,
0x0000001004047824ULL, 0x000fe400078e0209ULL, 0x0000000810127824ULL, 0x042fe200078e00ffULL,
0x0000000002087984ULL, 0x0002e20000000c00ULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x00000000040c7984ULL, 0x0005220000000c00ULL,
0xfffffff812037812ULL, 0x000fe200078ee211ULL, 0x0000000807117824ULL, 0x000fe200078e00ffULL,
0xfffffff810057812ULL, 0x000fc400078ee205ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff811077812ULL, 0x000fe200078ee200ULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x002fe200078040ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x004fe400078240ffULL,
0x00005b0003037a11ULL, 0x000fc400000f4412ULL, 0x00005b0005057a11ULL, 0x000fe400008f4410ULL,
0xfffffff813117812ULL, 0x000fe200078ee206ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x008fe8000c101d06ULL,
0x0000000c04007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x00000006041b7981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000210077824ULL, 0x000fe200078e00ffULL,
0x00f60000ff047f8cULL, 0x002e62000c80043fULL, 0x0000004019037824ULL, 0x000fe400078e00ffULL,
0x0000580007187a24ULL, 0x000fc800078e0218ULL, 0x0000620018177a24ULL, 0x000fc800078e0203ULL,
0x000005a000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x00000080ff257424ULL, 0x000fe200078e00ffULL, 0x000000300e237812ULL, 0x000fe400078ec0ffULL,
0x000000081e147810ULL, 0x040fe20007ffe0ffULL, 0x0000000117067824ULL, 0x040fe200078e021eULL,
0x000000101e207810ULL, 0x040fe40007ffe0ffULL, 0x000000181e227810ULL, 0x000fe20007ffe0ffULL,
0x0000000117087824ULL, 0x000fe200078e0214ULL, 0x000000031a127217ULL, 0x000fe20007800000ULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x000000201e167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000137211ULL, 0x000fe200078fe8ffULL, 0x00005e0008087625ULL, 0x000fe200078e0025ULL,
0x00000023060a7210ULL, 0x080fe40007f1e0ffULL, 0x00001000191d7811ULL, 0x000fe200078e68ffULL,
0x00000001170e7824ULL, 0x040fe200078e0220ULL, 0x00000023080c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000117087824ULL, 0x000fe200078e0222ULL, 0x000000281e1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe400000e0607ULL, 0x000000ffff0d7224ULL, 0x000fc400008e0609ULL,
0x00005e000e067625ULL, 0x000fc800078e0025ULL, 0x00005e0008087625ULL, 0x000fe200078e0025ULL,
0x00000023060e7210ULL, 0x000fc60007f1e0ffULL, 0x0000000117067824ULL, 0x000fe200078e0216ULL,
0x0000002308107210ULL, 0x000fe20007f3e0ffULL, 0x0000000112087824ULL, 0x000fe400078e0a03ULL,
0x000000ffff0f7224ULL, 0x000fe400000e0607ULL, 0x000000ffff117224ULL, 0x000fe200008e0609ULL,
0x000000081400720cULL, 0x080fe20003f26070ULL, 0x00005e0006067625ULL, 0x000fe200078e0025ULL,
0x0000000313097812ULL, 0x000fe400078ec0ffULL, 0x000000081e00720cULL, 0x000fe20003f06070ULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0x0000002306127210ULL, 0x000fc40007f5e0ffULL,
0x0ffffffc09007812ULL, 0x000fe400078ef800ULL, 0xfffffffc14067812ULL, 0x000fe200078ee209ULL,
0x000000ffff137224ULL, 0x000fe200010e0607ULL, 0x000000082000720cULL, 0x080fe20003fa6070ULL,
0x00000010001f7824ULL, 0x100fe200078e021dULL, 0x000000301e007810ULL, 0x000fe20007ffe0ffULL,
0x0000001006217824ULL, 0x000fe200078e021dULL, 0x000000381e1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000117067824ULL, 0x000fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1f7faeULL, 0x0005e2000c101c46ULL, 0x000000082200720cULL, 0x080fe20003f86070ULL,
0x0000000420207824ULL, 0x000fe200078e00ffULL, 0x000000081600720cULL, 0x080fe20003f66070ULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x000000000c217faeULL, 0x0007e2000c901c46ULL,
0x000000081c00720cULL, 0x000fc40003f46070ULL, 0x000000080000720cULL, 0x080fe40003f26070ULL,
0x0000002306147210ULL, 0x000fe20007fde0ffULL, 0x0000000117067824ULL, 0x040fe200078e0200ULL,
0x000000081e00720cULL, 0x000fe20003f06070ULL, 0x0000000117087824ULL, 0x000fe400078e021eULL,
0x000000ffff157224ULL, 0x000fe400030e0607ULL, 0x00000004160c7824ULL, 0x008fe400078e00ffULL,
0x000000041c167824ULL, 0x000fc400078e00ffULL, 0x00000004220a7824ULL, 0x004fe200078e00ffULL,
0xfffffffc0c0c7812ULL, 0x100fe200078ee209ULL, 0x00000004001c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc20007812ULL, 0x100fe200078ee209ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee209ULL, 0x00005e0006067625ULL, 0x000fe200078e0025ULL,
0xfffffffc16167812ULL, 0x100fe400078ee209ULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee209ULL,
0x00000010000b7824ULL, 0x100fe200078e021dULL, 0x0000002306067210ULL, 0x000fe20007fde0ffULL,
0x000000100a0d7824ULL, 0x000fe200078e021dULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee209ULL,
0x00005e0008087625ULL, 0x000fe200078e0025ULL, 0x000000000e0b7faeULL, 0x0005e6000e901c46ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000002308087210ULL, 0x000fe20007fde0ffULL,
0x000000100c177824ULL, 0x100fe200078e021dULL, 0x00000000100d7faeULL, 0x0005e2000e101c46ULL,
0x00000010161f7824ULL, 0x000fc400078e021dULL, 0x000000101c217824ULL, 0x100fe200078e021dULL,
0x0000000012177faeULL, 0x0005e2000d901c46ULL, 0x000000101e1d7824ULL, 0x000fe400078e021dULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x00000000141f7faeULL, 0x0005e8000d101c46ULL,
0x0000000006217faeULL, 0x0005e8000c901c46ULL, 0x00000000081d7faeULL, 0x0005e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x0000001700067211ULL, 0x040fe200078ff0ffULL,
0x00000080ff297424ULL, 0x000fe200078e00ffULL, 0x0000000000077211ULL, 0x000fc400078fe8ffULL,
0x0000000800167811ULL, 0x040fe400078ff0ffULL, 0x0000002800107811ULL, 0x000fe400078ff0ffULL,
0x0000000307157812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0029ULL,
0x000000300e2b7812ULL, 0x000fe400078ec0ffULL, 0x00000010000a7811ULL, 0x040fe200078ff0ffULL,
0x0000000117087824ULL, 0x040fe200078e0216ULL, 0x0000003000127811ULL, 0x000fe200078ff0ffULL,
0x0000000416207824ULL, 0x000fe200078e00ffULL, 0x00000020000e7811ULL, 0x040fe200078ff0ffULL,
0x0000000117167824ULL, 0x040fe200078e0210ULL, 0x00000018000c7811ULL, 0x000fe200078ff0ffULL,
0x0000000410267824ULL, 0x000fe200078e00ffULL, 0x0000002b06107210ULL, 0x000fe20007f1e0ffULL,
0x0000000117097824ULL, 0x040fe200078e020aULL, 0x0000003800147811ULL, 0x000fe200078ff0ffULL,
0x00000001171c7824ULL, 0x000fe200078e0212ULL, 0x0000100019277811ULL, 0x000fe200078e68ffULL,
0x0000000412287824ULL, 0x000fe200078e00ffULL, 0xfffffffc26127812ULL, 0x000fe200078ee215ULL,
0x00000001170f7824ULL, 0x000fc400078e020eULL, 0x000000ffff117224ULL, 0x000fe200000e0607ULL,
0xfffffffc28137812ULL, 0x100fe200078ee215ULL, 0x000000040a227824ULL, 0x000fe400078e00ffULL,
0x000000040c247824ULL, 0x000fe400078e00ffULL, 0x000000040e0e7824ULL, 0x000fe400078e00ffULL,
0x00000001171e7824ULL, 0x000fe200078e0214ULL, 0xfffffffc240d7812ULL, 0x100fe200078ee215ULL,
0x00000004142a7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc15147812ULL, 0x000fe200078ef800ULL,
0x00005e0008067625ULL, 0x000fe200078e0029ULL, 0xfffffffc20007812ULL, 0x000fc400078ee215ULL,
0xfffffffc0e0e7812ULL, 0x100fe200078ee215ULL, 0x00000001170a7824ULL, 0x000fe200078e020cULL,
0xfffffffc220c7812ULL, 0x100fe200078ee215ULL, 0x00005e0009087625ULL, 0x000fe200078e0029ULL,
0xfffffffc2a157812ULL, 0x000fc600078ee215ULL, 0x0000001012237824ULL, 0x000fe200078e0227ULL,
0x0000002b06127210ULL, 0x000fe20007f1e0ffULL, 0x00005e000a0a7625ULL, 0x000fc800078e0029ULL,
0x00000010142d7824ULL, 0x100fe200078e0227ULL, 0x0000002b08147210ULL, 0x000fe20007f3e0ffULL,
0x0000001013257824ULL, 0x100fe400078e0227ULL, 0x0000001000177824ULL, 0x100fe200078e0227ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102d7faeULL, 0x0005e2000b901c46ULL,
0x000000100c1d7824ULL, 0x100fe400078e0227ULL, 0x000000100d1f7824ULL, 0x100fe400078e0227ULL,
0x000000100e217824ULL, 0x000fc400078e0227ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x0000002b0a0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001015277824ULL, 0x000fe400078e0227ULL,
0x000000ffff157224ULL, 0x000fe200008e0609ULL, 0x0000000012177faeULL, 0x0005e2000b901c46ULL,
0x00005e000f067625ULL, 0x000fc600078e0029ULL, 0x00000000141d7faeULL, 0x0005e2000b901c46ULL,
0x00005e0016087625ULL, 0x000fc800078e0029ULL, 0x00005e001c0c7625ULL, 0x000fe200078e0029ULL,
0x0000002b08087210ULL, 0x000fc60007f3e0ffULL, 0x00005e001e0e7625ULL, 0x000fe200078e0029ULL,
0x0000002b0c0c7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000002b06067210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000002b0e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x000000000a1f7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fe400000e0607ULL,
0x000000ffff0f7224ULL, 0x000fc600018e060fULL, 0x0000000006217faeULL, 0x0005e8000b901c46ULL,
0x0000000008237faeULL, 0x0005e8000b901c46ULL, 0x000000000c257faeULL, 0x0005e8000b901c46ULL,
0x000000000e277faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x004fc40000015200ULL, 0x00f60400ff097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x006fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011409ULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000200007819ULL, 0x000fc80000001209ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000002019007824ULL, 0x002fca00078e0200ULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000f00047812ULL, 0x000fc600078ec0ffULL,
0x0000000100057824ULL, 0x000fe400078e0205ULL, 0x0000001004077824ULL, 0x040fe400078e00ffULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x0000000f05007812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f007007812ULL, 0x000fe400078ee200ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x00000000000c7984ULL, 0x000e62000000cc00ULL,
0x000000f004057812ULL, 0x000fca00078ee205ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001000007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x3db504f31b1b7820ULL, 0x010fe20000410000ULL, 0x0000f68819347811ULL, 0x040fe200078e18ffULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0xffffffff02357810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x0000f60819367811ULL, 0x000fc400078e28ffULL,
0x0000010038377824ULL, 0x000fe200078e0203ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000371a00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e003aULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fc4000001ff00ULL,
0x0000000139097810ULL, 0x020fe20007ffe0ffULL, 0x00000a8000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0039ULL, 0x000000013c3a7812ULL, 0x000fc400078e0cffULL,
0x0000003809087211ULL, 0x040fe200078ff8ffULL, 0x000000ffff397224ULL, 0x000fe200078e0009ULL,
0x000000020900780cULL, 0x040fe40003f06070ULL, 0x00000001080b7810ULL, 0x040fe40007ffe0ffULL,
0x00000001090a7812ULL, 0x000fe400078ec0ffULL, 0x000000020b00720cULL, 0x000fe20003f26070ULL,
0x00000100080b7824ULL, 0x000fc800078e0203ULL, 0x0000620018317a24ULL, 0x000fd000078e020bULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000000000097211ULL, 0x002fe200078fe8ffULL,
0x000000040a3d7824ULL, 0x000fe200078e00ffULL, 0x0000000b1a087217ULL, 0x000fe20007800000ULL,
0x00000002193e7824ULL, 0x000fe200078e023aULL, 0x00000002ff127819ULL, 0x100fe20000011600ULL,
0x00000080ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000000309337812ULL, 0x000fe200078ec0ffULL,
0x0000000108107824ULL, 0x000fe200078e0a0bULL, 0x0000000812097810ULL, 0x040fe20007ffe0ffULL,
0x0000000112087824ULL, 0x000fe200078e0231ULL, 0xfffffffc3d3d7812ULL, 0x000fc400078ee200ULL,
0x000000101200720cULL, 0x080fe20003f26070ULL, 0x00000001090a7824ULL, 0x040fe200078e0231ULL,
0x000000100900720cULL, 0x040fe20003f46070ULL, 0x0000000409307824ULL, 0x000fe200078e00ffULL,
0x000010003e3e7811ULL, 0x000fe200078e60ffULL, 0x00005e0008087625ULL, 0x080fe200078e003fULL,
0x0ffffffc33117812ULL, 0x000fe400078ef800ULL, 0xfffffffc30137812ULL, 0x000fe200078ee233ULL,
0x00005e000a0a7625ULL, 0x000fe200078e003fULL, 0x0000001012307810ULL, 0x000fc40007ffe0ffULL,
0x0000001812327810ULL, 0x040fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e023eULL,
0x0000002012407810ULL, 0x040fe20007ffe0ffULL, 0x000000103d087825ULL, 0x000fe200078e0008ULL,
0x0000002812417810ULL, 0x040fe40007ffe0ffULL, 0x0000003012427810ULL, 0x040fe20007ffe0ffULL,
0x0000001013137824ULL, 0x000fe200078e023eULL, 0x0000003812437810ULL, 0x000fe20007ffe0ffULL,
0x000000103d0a7825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e2000c901c46ULL, 0x000000103000720cULL, 0x000fc40003f26070ULL,
0x000000104000720cULL, 0x080fe20003f66070ULL, 0x000000000a137faeULL, 0x0005e2000d101c46ULL,
0x000000103200720cULL, 0x080fe20003f46070ULL, 0x0000000430447824ULL, 0x000fe200078e00ffULL,
0x000000104100720cULL, 0x0c0fe20003f86070ULL, 0x0000000432467824ULL, 0x000fe200078e00ffULL,
0x000000104200720cULL, 0x080fe20003fa6070ULL, 0x0000000441487824ULL, 0x000fe200078e00ffULL,
0x000000104300720cULL, 0x000fe20003fc6070ULL, 0x0000000130087824ULL, 0x102fe400078e0231ULL,
0x0000000140107824ULL, 0x000fe200078e0231ULL, 0xfffffffc48477812ULL, 0x000fe200078ee233ULL,
0x0000000142307824ULL, 0x000fc400078e0231ULL, 0x0000000440407824ULL, 0x000fe400078e00ffULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x00000004434a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc40457812ULL, 0x000fe200078ee233ULL, 0x00000001320a7824ULL, 0x004fe200078e0231ULL,
0xfffffffc42497812ULL, 0x000fe200078ee233ULL, 0x0000000141127824ULL, 0x000fe200078e0231ULL,
0xfffffffc44417812ULL, 0x000fe200078ee233ULL, 0x0000000143327824ULL, 0x000fe200078e0231ULL,
0xfffffffc46437812ULL, 0x100fe200078ee233ULL, 0x00005e0008087625ULL, 0x000fe200078e003fULL,
0xfffffffc4a4b7812ULL, 0x000fc600078ee233ULL, 0x00005e000a0a7625ULL, 0x000fc800078e003fULL,
0x00005e0010107625ULL, 0x000fc800078e003fULL, 0x00005e0012127625ULL, 0x000fc800078e003fULL,
0x00005e0030307625ULL, 0x000fc800078e003fULL, 0x00005e0032327625ULL, 0x000fc800078e003fULL,
0x000000103d087825ULL, 0x000fc800078e0008ULL, 0x000000103d0a7825ULL, 0x000fc800078e000aULL,
0x000000103d107825ULL, 0x000fc800078e0010ULL, 0x000000103d127825ULL, 0x000fc800078e0012ULL,
0x000000103d307825ULL, 0x000fc800078e0030ULL, 0x000000103d327825ULL, 0x000fc800078e0032ULL,
0x00000010413d7824ULL, 0x100fe400078e023eULL, 0x00000010433f7824ULL, 0x100fe400078e023eULL,
0x0000001045417824ULL, 0x100fe200078e023eULL, 0x00000000083d7faeULL, 0x0003e2000c901c46ULL,
0x0000001047437824ULL, 0x100fe400078e023eULL, 0x0000001049457824ULL, 0x100fe200078e023eULL,
0x000000000a3f7faeULL, 0x0003e2000d101c46ULL, 0x000000104b477824ULL, 0x000fc600078e023eULL,
0x0000000010417faeULL, 0x0003e8000d901c46ULL, 0x0000000012437faeULL, 0x0003e8000e101c46ULL,
0x0000000030457faeULL, 0x0003e8000e901c46ULL, 0x0000000032477faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x000000040a3d7824ULL, 0x000fe200078e00ffULL,
0x0000000800107811ULL, 0x042fe200078ff0ffULL, 0x00000002190a7824ULL, 0x000fe200078e023aULL,
0x0000001000127811ULL, 0x040fe200078ff0ffULL, 0x00000080ff417424ULL, 0x000fe200078e00ffULL,
0x0000001800307811ULL, 0x000fe200078ff0ffULL, 0x0000000410447824ULL, 0x000fe200078e00ffULL,
0x0000002000327811ULL, 0x000fe200078ff0ffULL, 0x0000000412467824ULL, 0x000fe200078e00ffULL,
0x00000028003e7811ULL, 0x000fe200078ff0ffULL, 0x0000000430487824ULL, 0x000fe200078e00ffULL,
0x0000003000407811ULL, 0x000fe200078ff0ffULL, 0x00000004324a7824ULL, 0x000fe200078e00ffULL,
0x0000003800427811ULL, 0x000fe200078ff0ffULL, 0x000000043e4c7824ULL, 0x000fe200078e00ffULL,
0x000010000a4d7811ULL, 0x000fe200078e60ffULL, 0x00000001100a7824ULL, 0x100fe200078e0231ULL,
0x0000000000097211ULL, 0x000fe200078fe8ffULL, 0x0000000112107824ULL, 0x100fe200078e0231ULL,
0x0000003100087211ULL, 0x000fe200078ff0ffULL, 0x0000000130127824ULL, 0x100fe200078e0231ULL,
0x00000003090b7812ULL, 0x000fe200078ec0ffULL, 0x0000000132307824ULL, 0x000fe200078e0231ULL,
0xfffffffc3d3d7812ULL, 0x000fe200078ee200ULL, 0x00000004404e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc44447812ULL, 0x100fe200078ee20bULL, 0x0000000442507824ULL, 0x000fe200078e00ffULL,
0xfffffffc46467812ULL, 0x000fe200078ee20bULL, 0x000000013e327824ULL, 0x000fe200078e0231ULL,
0xfffffffc48487812ULL, 0x000fe200078ee20bULL, 0x00000001403e7824ULL, 0x000fe200078e0231ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee20bULL, 0x0000000142407824ULL, 0x000fe200078e0231ULL,
0xfffffffc4c4c7812ULL, 0x100fe200078ee20bULL, 0x00005e0008087625ULL, 0x000fe200078e0041ULL,
0xfffffffc4e4e7812ULL, 0x000fc400078ee20bULL, 0xfffffffc50507812ULL, 0x000fe200078ee20bULL,
0x00005e0010107625ULL, 0x000fe200078e0041ULL, 0x0ffffffc0b427812ULL, 0x000fc600078ef800ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0041ULL, 0x00005e0012127625ULL, 0x000fc800078e0041ULL,
0x00005e0030307625ULL, 0x000fc800078e0041ULL, 0x00005e0032327625ULL, 0x000fc800078e0041ULL,
0x00005e003e3e7625ULL, 0x000fc800078e0041ULL, 0x00005e0040407625ULL, 0x000fc800078e0041ULL,
0x000000103d087825ULL, 0x000fc800078e0008ULL, 0x000000103d0a7825ULL, 0x000fc800078e000aULL,
0x000000103d107825ULL, 0x000fc800078e0010ULL, 0x000000103d127825ULL, 0x000fc800078e0012ULL,
0x000000103d307825ULL, 0x000fc800078e0030ULL, 0x000000103d327825ULL, 0x000fc800078e0032ULL,
0x000000103d3e7825ULL, 0x000fc800078e003eULL, 0x000000103d407825ULL, 0x000fc800078e0040ULL,
0x00000010424f7824ULL, 0x100fe400078e024dULL, 0x00000010443d7824ULL, 0x100fe400078e024dULL,
0x0000001046437824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000084f7faeULL, 0x0003e2000b901c46ULL, 0x0000001048457824ULL, 0x100fe400078e024dULL,
0x000000104a477824ULL, 0x100fe200078e024dULL, 0x000000000a3d7faeULL, 0x0003e2000b901c46ULL,
0x000000104c497824ULL, 0x000fc400078e024dULL, 0x000000104e4b7824ULL, 0x100fe200078e024dULL,
0x0000000010437faeULL, 0x0003e2000b901c46ULL, 0x00000010504d7824ULL, 0x000fc600078e024dULL,
0x0000000012457faeULL, 0x0003e8000b901c46ULL, 0x0000000030477faeULL, 0x0003e8000b901c46ULL,
0x0000000032497faeULL, 0x0003e8000b901c46ULL, 0x000000003e4b7faeULL, 0x0003e8000b901c46ULL,
0x00000000404d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff3e7224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff800097812ULL, 0x020fe200078ec0ffULL,
0x0000000219317824ULL, 0x000fe200078e023cULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000013e467810ULL, 0x000fc40007ffe0ffULL, 0x0000000709097812ULL, 0x000fe400078ef800ULL,
0x0000100031317811ULL, 0x000fe400078e60ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011609ULL,
0x0000000409117824ULL, 0x040fe200078e00ffULL, 0x0000002000107810ULL, 0x000fe20007ffe0ffULL,
0x00000004090a7824ULL, 0x000fe400078e00ffULL, 0x000000010b087824ULL, 0x040fe400078e023eULL,
0x000000010b0b7824ULL, 0x000fc600078e0246ULL, 0xfffffffc11087812ULL, 0x000fe400078ee208ULL,
0xfffffffc0a0a7812ULL, 0x000fe400078ee20bULL, 0x0000000700117812ULL, 0x000fe200078ec0ffULL,
0x0000001008487824ULL, 0x100fe200078e0231ULL, 0xfffffff8100b7812ULL, 0x000fe200078ec0ffULL,
0x000000043b087824ULL, 0x000fe200078e023eULL, 0x0000000811457812ULL, 0x100fe200078ef800ULL,
0x000000100a407824ULL, 0x000fe200078e0231ULL, 0x000000070b307812ULL, 0x000fe200078ef800ULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x0000000208097824ULL, 0x000fc400078e00ffULL,
0x0000001045117824ULL, 0x040fe200078e00ffULL, 0x000000004040783bULL, 0x000ea20000000200ULL,
0x00000001ff0b7819ULL, 0x000fe20000011630ULL, 0x00000004303d7824ULL, 0x000fe200078e00ffULL,
0x0000000900087211ULL, 0x000fe200078fe0ffULL, 0x0000001045447824ULL, 0x000fe200078e00ffULL,
0x0000000209337810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e023eULL,
0x000000023e3e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000145087824ULL, 0x000fe200078e0208ULL,
0x0000003300327211ULL, 0x000fe200078fe0ffULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0xfffffffc3d0a7812ULL, 0x000fc400078ee20aULL, 0xfffffff011087812ULL, 0x000fe200078ee208ULL,
0x00000001453d7824ULL, 0x000fe200078e0232ULL, 0x000000043e00780cULL, 0x000fc60003f25270ULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0xfffffff0443d7812ULL, 0x000fe200078ee23dULL,
0x000000100a447824ULL, 0x000fc600078e0231ULL, 0x000000000810783bULL, 0x0007220000000200ULL,
0x000000103d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff097819ULL, 0x102fe4000001164bULL,
0x0000ffff4b3f7812ULL, 0x040fe400078ec0ffULL, 0x00000009ff33723eULL, 0x000fe400020006ffULL,
0x00000010ff097819ULL, 0x000fe4000001164bULL, 0x000000ff4b4b7812ULL, 0x000fe200078ec0ffULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x000000ff09327812ULL, 0x000fc400078ec0ffULL,
0x00000008ff097819ULL, 0x000fe2000001163fULL, 0x000000010b3f7824ULL, 0x000fe200078e0246ULL,
0x00000032ff32723eULL, 0x000fe200020006ffULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000010ff337819ULL, 0x000fe20000011633ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000ffff434e7812ULL, 0x004fe200078ec0ffULL,
0x20000009ff097230ULL, 0x000fe20000004100ULL, 0x00000010ff327819ULL, 0x000fc40000011632ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff087819ULL, 0x008fe40000011609ULL,
0x0000105433337816ULL, 0x000fe40000000032ULL, 0x0000105408327816ULL, 0x000fe4000000004bULL,
0x00000010ff4b7819ULL, 0x100fe20000011643ULL, 0x000000003d08783bULL, 0x0004e20000000200ULL,
0x00000018ff4c7819ULL, 0x000fc40000011643ULL, 0x000000ff4b4d7812ULL, 0x000fe200078ec0ffULL,
0x000000321004723cULL, 0x010b620000041804ULL, 0x00000008ff4b7819ULL, 0x000fe4000001164eULL,
0x000000ff43437812ULL, 0x000fe400078ec0ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0xfffffffc30307812ULL, 0x000fe200078ee23fULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff4c7819ULL, 0x000fe2000001164cULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fe2000001164dULL,
0x0000001030307824ULL, 0x000fe200078e0231ULL, 0x00000010ff327819ULL, 0x020fc4000001164bULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x000010544c4d7816ULL, 0x000fe4000000004dULL,
0x00001054324c7816ULL, 0x000fe40000000043ULL, 0x000000003030783bULL, 0x000f220000000200ULL,
0x00000018ff3d7819ULL, 0x004fe40000011648ULL, 0x00000010ff577819ULL, 0x102fe40000011644ULL,
0x00000018ff697819ULL, 0x000fc40000011644ULL, 0x000000ff44677812ULL, 0x040fe400078ec0ffULL,
0x0000ffff445b7812ULL, 0x000fe200078ec0ffULL, 0x0000004c0804723cULL, 0x008be20000041804ULL,
0x00000010ff5a7819ULL, 0x100fe40000011645ULL, 0x00000018ff687819ULL, 0x000fe40000011645ULL,
0x000000ff45527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff45557812ULL, 0x000fc400078ec0ffULL,
0x000000ff48437812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe40000011640ULL,
0x00000018ff447819ULL, 0x000fe40000011640ULL, 0x000000ff40457812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40547812ULL, 0x000fe400078ec0ffULL, 0x0000003dff40723eULL, 0x000fc400020006ffULL,
0x00000010ff3f7819ULL, 0x000fe40000011648ULL, 0x0000ffff48727812ULL, 0x000fe400078ec0ffULL,
0x000000ff495c7812ULL, 0x040fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x100fe40000011649ULL,
0x00000018ff487819ULL, 0x000fe40000011649ULL, 0x0000ffff49737812ULL, 0x000fc400078ec0ffULL,
0x00000010ff6d7819ULL, 0x100fe4000001164aULL, 0x00000018ff5d7819ULL, 0x000fe4000001164aULL,
0x000000ff4a667812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4a747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff507819ULL, 0x100fe40000011647ULL, 0x00000018ff4a7819ULL, 0x000fc40000011647ULL,
0x000000ff47497812ULL, 0x040fe400078ec0ffULL, 0x0000ffff474c7812ULL, 0x020fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011641ULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000010ff4b7819ULL, 0x110fe40000011630ULL, 0x00000018ff597819ULL, 0x000fc40000011630ULL,
0x000000ff305e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff30477812ULL, 0x000fe200078ec0ffULL,
0x20000040ff307230ULL, 0x000fe20000004100ULL, 0x000000ff416c7812ULL, 0x040fe400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff4d7819ULL, 0x000fe40000011641ULL,
0x0000ffff414f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011642ULL,
0x00000048ff63723eULL, 0x000fe400020006ffULL, 0x0000005dff40723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x100fe40000011631ULL, 0x00000018ff607819ULL, 0x000fc40000011631ULL,
0x000000ff315f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff31417812ULL, 0x000fe200078ec0ffULL,
0x20000043ff317230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x000000ff42717812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x100fe40000011646ULL,
0x00000018ff657819ULL, 0x000fc40000011646ULL, 0x000000ff46537812ULL, 0x040fe400078ec0ffULL,
0x0000ffff46517812ULL, 0x000fe400078ec0ffULL, 0x00000066ff5d723eULL, 0x000fe200020006ffULL,
0x2000005cff667230ULL, 0x000fe20000004100ULL, 0x0000006cff43723eULL, 0x000fe200020006ffULL,
0x20000040ff5c7230ULL, 0x000fe20000004100ULL, 0x00000045ff46723eULL, 0x000fe200020006ffULL,
0x20000044ff457230ULL, 0x000fe20000004100ULL, 0x000000ff3f3f7812ULL, 0x000fe200078ec0ffULL,
0x2000006aff447230ULL, 0x000fe20000004100ULL, 0x0000006fff6c723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000071ff40723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000008ff6a7819ULL, 0x000fe20000011672ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x000000ff6d717812ULL, 0x000fe200078ec0ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000003fff6f723eULL, 0x000fe200020006ffULL,
0x2000006cff3f7230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fc40000011674ULL,
0x000000ff6b6c7812ULL, 0x000fe200078ec0ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x00000008ff6b7819ULL, 0x000fe40000011673ULL,
0x0000006dff72723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fc400020006ffULL, 0x00000071ff73723eULL, 0x000fe200020006ffULL,
0x2000006aff717230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000072ff6a7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x2000006cff6d7230ULL, 0x000fe20000004100ULL, 0x00000068ff72723eULL, 0x000fe200020006ffULL,
0x2000006bff6c7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x20000073ff6b7230ULL, 0x000fe20000004100ULL, 0x00000065ff73723eULL, 0x000fe200020006ffULL,
0x20000069ff687230ULL, 0x000fe20000004100ULL, 0x00000010ff4e7819ULL, 0x000fe20000011642ULL,
0x20000067ff697230ULL, 0x000fe20000004100ULL, 0x0000ffff42587812ULL, 0x000fe200078ec0ffULL,
0x20000072ff677230ULL, 0x000fe20000004100ULL, 0x000000ff64727812ULL, 0x000fe200078ec0ffULL,
0x20000052ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff647819ULL, 0x000fe20000011654ULL,
0x20000073ff527230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x00000072ff73723eULL, 0x000fe400020006ffULL, 0x00000064ff72723eULL, 0x000fe200020006ffULL,
0x20000053ff647230ULL, 0x000fe20000004100ULL, 0x0000004aff54723eULL, 0x000fe400020006ffULL,
0x00000008ff4f7819ULL, 0x000fe2000001164fULL, 0x20000072ff537230ULL, 0x000fe20000004100ULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e4e7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x00000049ff4a723eULL, 0x000fe200020006ffULL,
0x20000054ff497230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x20000073ff547230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000004eff72723eULL, 0x000fe400020006ffULL,
0x00000058ff4e723eULL, 0x000fe200020006ffULL, 0x2000004fff587230ULL, 0x000fe20000004100ULL,
0x000000ff32617812ULL, 0x000fe200078ec0ffULL, 0x20000072ff4f7230ULL, 0x000fe20000004100ULL,
0x00000059ff73723eULL, 0x000fe200020006ffULL, 0x2000004dff597230ULL, 0x000fe20000004100ULL,
0x00000018ff707819ULL, 0x000fe20000011633ULL, 0x2000004eff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff336e7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff4e7230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x00000061ff72723eULL, 0x000fe400020006ffULL,
0x000000ff57577812ULL, 0x000fe200078ec0ffULL, 0x2000005eff617230ULL, 0x000fe20000004100ULL,
0x00000008ff5b7819ULL, 0x000fe2000001165bULL, 0x20000072ff5e7230ULL, 0x000fe20000004100ULL,
0x00000070ff73723eULL, 0x000fe400020006ffULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x0000006eff70723eULL, 0x000fc400020006ffULL, 0x00000057ff6e723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000070ff577230ULL, 0x000fe20000004100ULL,
0x0000005aff72723eULL, 0x000fe200020006ffULL, 0x2000006eff707230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x2000005bff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff557819ULL, 0x000fe20000011655ULL, 0x20000072ff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff56727812ULL, 0x000fe200078ec0ffULL, 0x20000073ff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fc40000011630ULL, 0x00000010ff307819ULL, 0x000fe40000011631ULL,
0x00000010ff317819ULL, 0x000fe4000001166fULL, 0x0000105471307816ULL, 0x000fe40000000030ULL,
0x0000105456317816ULL, 0x000fe40000000031ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x000000ff50507812ULL, 0x000fc400078ec0ffULL, 0x00000008ff517819ULL, 0x000fe20000011651ULL,
0x20000055ff567230ULL, 0x000fe20000004100ULL, 0x00000050ff6f723eULL, 0x000fe200020006ffULL,
0x00000030100c723cULL, 0x000b62000004180cULL, 0x00000051ff55723eULL, 0x000fe400020006ffULL,
0x00000010ff507819ULL, 0x000fe40000011663ULL, 0x00000010ff517819ULL, 0x000fe2000001166cULL,
0x20000055ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x020fe2000001166dULL,
0x2000006fff557230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fc40000011666ULL,
0x0000105450317816ULL, 0x000fe40000000031ULL, 0x0000105451307816ULL, 0x000fe40000000030ULL,
0x00000010ff507819ULL, 0x000fe4000001165dULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff517819ULL, 0x000fe2000001166bULL, 0x00000030102c723cULL, 0x000be2000004182cULL,
0x00000010ff5d7819ULL, 0x000fc4000001166aULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x000010545c517816ULL, 0x000fe40000000051ULL, 0x000010545d507816ULL, 0x000fe40000000050ULL,
0x0000004cff66723eULL, 0x000fe400020006ffULL, 0x000000ff4b4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff687819ULL, 0x000fe20000011668ULL, 0x000000501028723cULL, 0x000be20000041828ULL,
0x0000004cff5c723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x020fc40000011669ULL, 0x00000010ff317819ULL, 0x000fe40000011670ULL,
0x00000010ff517819ULL, 0x000fe4000001165bULL, 0x00000010ff4b7819ULL, 0x000fe4000001166eULL,
0x00000010ff4c7819ULL, 0x000fe40000011667ULL, 0x00000010ff507819ULL, 0x000fe40000011665ULL,
0x00000010ff5b7819ULL, 0x000fc40000011656ULL, 0x0000105468317816ULL, 0x000fe40000000031ULL,
0x000010544b307816ULL, 0x000fe20000000030ULL, 0x2000005cff4b7230ULL, 0x000fe20000004100ULL,
0x000010544c517816ULL, 0x000fe40000000051ULL, 0x000010545b507816ULL, 0x000fe40000000050ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x000000301024723cULL, 0x000b620000041824ULL,
0x00000008ff477819ULL, 0x000fc40000011647ULL, 0x00000010ff467819ULL, 0x000fe20000011646ULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000010ff307819ULL, 0x020fe20000011645ULL, 0x000000501020723cULL, 0x000b620000041820ULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x20000047ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff517819ULL, 0x020fe40000011654ULL, 0x00000010ff657819ULL, 0x000fe40000011672ULL,
0x0000105430517816ULL, 0x000fe40000000051ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff307819ULL, 0x000fe40000011649ULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff477819ULL, 0x000fe40000011655ULL, 0x00000010ff317819ULL, 0x000fe40000011666ULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x0000105453507816ULL, 0x000fe40000000046ULL,
0x0000105452657816ULL, 0x000fe40000000065ULL, 0x0000105463647816ULL, 0x000fc40000000064ULL,
0x0000105430477816ULL, 0x000fe20000000047ULL, 0x00000050080c723cULL, 0x000fe2000004180cULL,
0x0000105431467816ULL, 0x000fe4000000004aULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000010ff427819ULL, 0x100fe40000011632ULL, 0x00000018ff627819ULL, 0x000fe20000011632ULL,
0x00000064101c723cULL, 0x000f62000004181cULL, 0x0000ffff32327812ULL, 0x000fe200078ec0ffULL,
0x20000041ff307230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fc4000001164fULL,
0x00000010ff3d7819ULL, 0x000fe40000011633ULL, 0x00000008ff327819ULL, 0x000fe20000011632ULL,
0x000000461014723cULL, 0x000b620000041814ULL, 0x0000ffff33337812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff107819ULL, 0x020fc4000001163fULL, 0x00000010ff117819ULL, 0x000fe4000001164bULL,
0x0000105410417816ULL, 0x000fe40000000041ULL, 0x00000010ff107819ULL, 0x000fe40000011645ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fe400020006ffULL,
0x000000ff48487812ULL, 0x000fe200078ec0ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff42427812ULL, 0x000fe200078ec0ffULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x000000ff3d3d7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff337819ULL, 0x000fe40000011633ULL,
0x000010544e117816ULL, 0x000fe40000000011ULL, 0x0000105410107816ULL, 0x000fe40000000061ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x000000100824723cULL, 0x000b620000041824ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000033ff33723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fe20000011630ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fe2000001165eULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x00000010ff117819ULL, 0x020fc40000011632ULL, 0x0000105430307816ULL, 0x000fe4000000005fULL,
0x00001054115e7816ULL, 0x000fe4000000005eULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff587819ULL, 0x000fc40000011658ULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff317819ULL, 0x000fe40000011648ULL, 0x00000010ff5f7819ULL, 0x000fe40000011662ULL,
0x00000010ff427819ULL, 0x000fc40000011642ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff117819ULL, 0x000fe4000001163dULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff107819ULL, 0x000fe40000011633ULL, 0x0000105444597816ULL, 0x000fe40000000059ULL,
0x0000105458587816ULL, 0x000fc40000000043ULL, 0x000010544d407816ULL, 0x000fe40000000040ULL,
0x0000105460317816ULL, 0x000fe40000000031ULL, 0x000010545f5f7816ULL, 0x000fe20000000042ULL,
0x00000058082c723cULL, 0x000b62000004182cULL, 0x000010545a117816ULL, 0x000fe40000000011ULL,
0x0000105410107816ULL, 0x000fca0000000057ULL, 0x000000400828723cULL, 0x040b700000041828ULL,
0x000000300820723cULL, 0x040b700000041820ULL, 0x0000005e081c723cULL, 0x040b70000004181cULL,
0x000000100814723cULL, 0x000b620000041814ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe7c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e003aULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdcb000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000001b24247220ULL, 0x080fe20000410000ULL, 0x0000001b25257220ULL, 0x080fe20000410000ULL,
0x0000001b2c2c7220ULL, 0x0a0fe20000410000ULL, 0x0000001b28287220ULL, 0x080fe20000410000ULL,
0x0000001b29297220ULL, 0x080fe20000410000ULL, 0x0000001b20207220ULL, 0x080fe20000410000ULL,
0x0000001b21217220ULL, 0x080fe20000410000ULL, 0x0000001b0c0c7220ULL, 0x080fe20000410000ULL,
0x0000001b0d0d7220ULL, 0x080fe20000410000ULL, 0x0000001b2d087220ULL, 0x080fe20000410000ULL,
0x0000001b04047220ULL, 0x080fe20000410000ULL, 0x0000001b05057220ULL, 0x080fe20000410000ULL,
0x0000001b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000001b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000001b26117220ULL, 0x080fe20000410000ULL, 0x0000001b27137220ULL, 0x080fe20000410000ULL,
0x0000001b2a0b7220ULL, 0x080fe20000410000ULL, 0x0000001b2b107220ULL, 0x080fe20000410000ULL,
0x000000ffff277224ULL, 0x000fe200078e0024ULL, 0x0000001b2e097220ULL, 0x080fe20000410000ULL,
0x000000ffff267224ULL, 0x000fe200078e0025ULL, 0x0000001b2f0a7220ULL, 0x080fe20000410000ULL,
0x0000001b1f317220ULL, 0x080fe20000410000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e002cULL,
0x0000001b0e0e7220ULL, 0x080fe20000410000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0028ULL,
0x0000001b0f0f7220ULL, 0x080fe20000410000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0029ULL,
0x0000001b06067220ULL, 0x080fe20000410000ULL, 0x000000ffff257224ULL, 0x000fe200078e0020ULL,
0x0000001b07077220ULL, 0x080fe20000410000ULL, 0x000000ffff247224ULL, 0x000fe200078e0021ULL,
0x0000001b22227220ULL, 0x080fe20000410000ULL, 0x0000001b23237220ULL, 0x080fe20000410000ULL,
0x0000001b1e307220ULL, 0x080fe20000410000ULL, 0x0000001b141f7220ULL, 0x080fe20000410000ULL,
0x0000001b15127220ULL, 0x080fe20000410000ULL, 0x0000001b16327220ULL, 0x080fe20000410000ULL,
0x0000001b17337220ULL, 0x000fe20000410000ULL, 0x000000ffff2f7224ULL, 0x000fc400078e000cULL,
0x000000ffff2e7224ULL, 0x000fe400078e000dULL, 0x000000ffff2c7224ULL, 0x000fe400078e0008ULL,
0x000000ffff297224ULL, 0x000fe400078e0004ULL, 0x000000ffff287224ULL, 0x000fe400078e0005ULL,
0x000000ffff217224ULL, 0x000fe400078e001cULL, 0x000000ffff207224ULL, 0x000fe200078e001dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000340c7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff177224ULL, 0x000fc400078e000aULL, 0x000000ffff1e7224ULL, 0x000fe400078e000eULL,
0x000000ffff1d7224ULL, 0x000fe400078e000fULL, 0x000000ffff1c7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0010ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fc400078e0013ULL, 0x000000ffff097224ULL, 0x000fe400078e0006ULL,
0x000000ffff087224ULL, 0x000fe400078e0007ULL, 0x000000ffff137224ULL, 0x000fe400078e0022ULL,
0x000000ffff147224ULL, 0x000fe400078e0023ULL, 0x000000ffff117224ULL, 0x000fe400078e0030ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0031ULL, 0x000000ffff107224ULL, 0x000fe400078e0032ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0033ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040034077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604237210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000002306067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040034077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004000d7824ULL, 0x000fe200078e00ffULL, 0x000000353800720cULL, 0x000fc80003f05270ULL,
0xfffffff00d0c7812ULL, 0x000fca00078ec0ffULL, 0x00000080190c7824ULL, 0x000fca00078e020cULL,
0x00f400000c047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000200227824ULL, 0x000fe400078e00ffULL, 0x000000011a377824ULL, 0x000fc600078e0a37ULL,
0x0000000622227812ULL, 0x000fc800078ec0ffULL, 0x0000000122307812ULL, 0x040fe400078efcffULL,
0x0000000822327812ULL, 0x000fe400078efcffULL, 0x000000373000720cULL, 0x080fe40003f26070ULL,
0x0000001022307812ULL, 0x000fe400078efcffULL, 0x000000373200720cULL, 0x080fe40003f06070ULL,
0x000000373000720cULL, 0x000fc40003fc6070ULL, 0x0000001122327812ULL, 0x040fe400078efcffULL,
0x0000001822307812ULL, 0x040fe400078efcffULL, 0x000000372200720cULL, 0x080fe40003f46070ULL,
0x000000373200720cULL, 0x080fe40003fa6070ULL, 0x000000373000720cULL, 0x000fe40003f66070ULL,
0x00000009223c7812ULL, 0x000fc400078efcffULL, 0x0000001922327812ULL, 0x040fe400078efcffULL,
0x0000002022307812ULL, 0x000fe400078efcffULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000002e2e7808ULL, 0x000fc40004800000ULL, 0x000000373c00720cULL, 0x080fe40003f86070ULL,
0x000000373200720cULL, 0x080fe40003f46070ULL, 0x000000373000720cULL, 0x000fe40003f26070ULL,
0x0000002122327812ULL, 0x040fe400078efcffULL, 0x0000002822307812ULL, 0x000fe400078efcffULL,
0xff8000001c1c7808ULL, 0x000fc40004000000ULL, 0xff8000002d2d7808ULL, 0x000fe40004000000ULL,
0xff80000017177808ULL, 0x000fe40006000000ULL, 0xff8000002c2c7808ULL, 0x000fe40006000000ULL,
0x000000373200720cULL, 0x080fe40003f06070ULL, 0x000000373000720cULL, 0x000fe40003f86070ULL,
0x0000002922327812ULL, 0x000fc400078efcffULL, 0x0000003022307812ULL, 0x000fe400078efcffULL,
0xff8000000b0b7808ULL, 0x000fe40007000000ULL, 0xff8000002b2b7808ULL, 0x000fe40007000000ULL,
0xff8000000a0a7808ULL, 0x000fe40006800000ULL, 0xff8000002a2a7808ULL, 0x000fe40006800000ULL,
0x000000373200720cULL, 0x000fc40003fc6070ULL, 0x000000373000720cULL, 0x000fe40003fa6070ULL,
0x0000003122327812ULL, 0x040fe400078efcffULL, 0x0000003822307812ULL, 0x040fe400078efcffULL,
0x0000003922227812ULL, 0x000fe400078efcffULL, 0xff80000009097808ULL, 0x000fe40005800000ULL,
0xff80000029297808ULL, 0x000fc40005800000ULL, 0xff80000008087808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40005000000ULL, 0xff80000016167808ULL, 0x000fe40004800000ULL,
0xff80000027277808ULL, 0x000fe40004800000ULL, 0x000000373200720cULL, 0x080fe40003f66070ULL,
0x000000373000720cULL, 0x000fc40003f46070ULL, 0x000000372200720cULL, 0x000fe40003f26070ULL,
0xff80000015157808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40004000000ULL,
0xff80000013137808ULL, 0x000fe40006000000ULL, 0xff80000025257808ULL, 0x000fe40006000000ULL,
0xff80000014147808ULL, 0x000fc40007000000ULL, 0xff80000024247808ULL, 0x000fe40007000000ULL,
0xff80000011117808ULL, 0x000fe40006800000ULL, 0xff80000021217808ULL, 0x000fe40006800000ULL,
0xff8000000f0f7808ULL, 0x000fe40005800000ULL, 0xff80000020207808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005000000ULL, 0xff8000001f1f7808ULL, 0x000fe40005000000ULL,
0xff8000000e0e7808ULL, 0x000fe40004800000ULL, 0xff80000012127808ULL, 0x000fc40004800000ULL,
0x0000002f0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff3b7424ULL, 0x000fe200078e00ffULL,
0x0000001e0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x000000042f237208ULL, 0x000fe40004000000ULL, 0x000000051e047208ULL, 0x000fc40004800000ULL,
0x0000002e2300720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x000000232e227208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000002d2200720bULL, 0x000fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fc40003f3e000ULL,
0x000000222d237208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fe40004800000ULL,
0x0000002c2300720bULL, 0x000fe40003f1e000ULL, 0x000000170400720bULL, 0x000fe40003f3e000ULL,
0x000000232c227208ULL, 0x000fe40004000000ULL, 0x0000000417047208ULL, 0x000fc40004800000ULL,
0x0000002b2200720bULL, 0x000fe40003f1e000ULL, 0x0000000b0400720bULL, 0x000fe40003f3e000ULL,
0x000000222b057208ULL, 0x000fe40004000000ULL, 0x000000040b237208ULL, 0x000fe40004800000ULL,
0x0000002a0500720bULL, 0x000fe40003f1e000ULL, 0x0000000a2300720bULL, 0x000fc40003f3e000ULL,
0x000000052a047208ULL, 0x000fe40004000000ULL, 0x000000230a227208ULL, 0x000fe40004800000ULL,
0x000000290400720bULL, 0x000fe40003f1e000ULL, 0x000000092200720bULL, 0x000fe40003f3e000ULL,
0x0000000429057208ULL, 0x000fe40004000000ULL, 0x0000002209237208ULL, 0x000fc40004800000ULL,
0x000000280500720bULL, 0x000fe40003f1e000ULL, 0x000000082300720bULL, 0x000fe40003f3e000ULL,
0x0000000528047208ULL, 0x000fe40004000000ULL, 0x0000002308237208ULL, 0x000fe40004800000ULL,
0x000000270400720bULL, 0x000fe40003f1e000ULL, 0x000000162300720bULL, 0x000fc40003f3e000ULL,
0x0000000427057208ULL, 0x000fe40004000000ULL, 0x0000002316047208ULL, 0x000fe40004800000ULL,
0x000000260500720bULL, 0x000fe40003f1e000ULL, 0x000000150400720bULL, 0x000fe40003f3e000ULL,
0x0000000526227208ULL, 0x000fe40004000000ULL, 0x0000000415047208ULL, 0x000fc40004800000ULL,
0x000000252200720bULL, 0x000fe40003f1e000ULL, 0x000000130400720bULL, 0x000fe40003f3e000ULL,
0x0000002225057208ULL, 0x000fe40004000000ULL, 0x0000000413237208ULL, 0x000fe40004800000ULL,
0x000000240500720bULL, 0x000fe40003f1e000ULL, 0x000000142300720bULL, 0x000fc40003f3e000ULL,
0x0000000524047208ULL, 0x000fe40004000000ULL, 0x0000002314227208ULL, 0x000fe40004800000ULL,
0x000000210400720bULL, 0x000fe40003f1e000ULL, 0x000000112200720bULL, 0x000fe40003f3e000ULL,
0x0000000421057208ULL, 0x000fe40004000000ULL, 0x0000002211227208ULL, 0x000fc40004800000ULL,
0x000000200500720bULL, 0x000fe40003f1e000ULL, 0x0000000f2200720bULL, 0x000fe40003f3e000ULL,
0x0000000520047208ULL, 0x000fe40004000000ULL, 0x000000220f057208ULL, 0x000fe40004800000ULL,
0x0000001f0400720bULL, 0x000fe40003f1e000ULL, 0x000000100500720bULL, 0x000fc40003f3e000ULL,
0x000000041f237208ULL, 0x000fe40004000000ULL, 0x0000000510057208ULL, 0x000fe40004800000ULL,
0x000000122300720bULL, 0x000fe40003f1e000ULL, 0x0000000e0500720bULL, 0x000fe40003f3e000ULL,
0x0000002312327208ULL, 0x000fe40004000000ULL, 0x000000050e377208ULL, 0x000fe20004800000ULL,
0x000015427f007947ULL, 0x000fec000b800000ULL, 0x0c401f0032047f89ULL, 0x0004e400000e0000ULL,
0x000000043200720bULL, 0x008fc80003f1e000ULL, 0x0000003204397208ULL, 0x000fe20004000000ULL,
0x000015527f007947ULL, 0x000fea000b800000ULL, 0x0c401f0037047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007227f89ULL, 0x000e6200000e0000ULL,
0x000000043700720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000003704307208ULL, 0x000fe40004000000ULL, 0x0000000605317208ULL, 0x000fe20004800000ULL,
0x0c201f0039047f89ULL, 0x000ee200000e0000ULL, 0x000000220700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0030057f89ULL, 0x000e6200000e0000ULL, 0x0000000722227208ULL, 0x000fc60004000000ULL,
0x0c201f0031327f89ULL, 0x004ea800000e0000ULL, 0x0c201f0022237f89ULL, 0x0002a200000e0000ULL,
0x000000043900720bULL, 0x008fe40003f1e000ULL, 0x000000053000720bULL, 0x002fe40003f3e000ULL,
0x0000003904047208ULL, 0x000fe40004000000ULL, 0x000000323100720bULL, 0x004fc40003f5e000ULL,
0x0000003005057208ULL, 0x000fe40004800000ULL, 0x0000003132067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05337820ULL, 0x002fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000300ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b17177823ULL, 0x000fe20000010833ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b083b7823ULL, 0x000fe20000010833ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x000fe20000010833ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe20000010833ULL, 0x000000232200720bULL, 0x004fca0003f3e000ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x0000002f2e08723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b152e7823ULL, 0x000fcc0000010833ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001d001d7308ULL, 0x000e700000000800ULL, 0x0000001c001c7308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000eb00000000800ULL, 0x0000002000317308ULL, 0x0007f00000000800ULL,
0x0000002100307308ULL, 0x0009e20000000800ULL, 0x00000004ff207e24ULL, 0x008fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0x3f8000002020783eULL, 0x000fc400000010ffULL,
0x0000001f00327308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b09217823ULL, 0x010fe20000010833ULL,
0x0000001e1d09723eULL, 0x002fe200000010ffULL, 0x000000ffff3d7224ULL, 0x000fca00078e0020ULL,
0x0000000b00377308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b0a1f7823ULL, 0x008fe20000010833ULL,
0x0000002d2c0a723eULL, 0x000fcc00000010ffULL, 0x0000002100397308ULL, 0x0003e20000000800ULL,
0x0000001c170b723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b16177823ULL, 0x000fcc0000010833ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x000000ffff217224ULL, 0x002fce00078e0020ULL,
0x0000002800287308ULL, 0x000e700000000800ULL, 0x0000001f003c7308ULL, 0x0004f00000000800ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x00000020081c723cULL, 0x004b6200000418ffULL,
0x000000292816723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b11297823ULL, 0x000fca0000010833ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b14217823ULL, 0x020fe20000010833ULL,
0x000000373c15723eULL, 0x008fe200000010ffULL, 0x000000ffff3c7224ULL, 0x000fca00078e0020ULL,
0x0000003b002c7308ULL, 0x000eb00000000800ULL, 0x00000017002d7308ULL, 0x0005e20000000800ULL,
0x0000002b2a14723eULL, 0x002fe400000010ffULL, 0x00000002ff2a7819ULL, 0x000fc80000011600ULL,
0x000000012a117810ULL, 0x000fe20007ffe0ffULL, 0x0000002100287308ULL, 0x0003e20000000800ULL,
0x000000392c17723eULL, 0x004fe200000010ffULL, 0x000000082a127824ULL, 0x040fe400078e00ffULL,
0x000000082a377824ULL, 0x040fe400078e00ffULL, 0x000000082a397824ULL, 0x000fe200078e00ffULL,
0xfffffff8122b7812ULL, 0x000fe200078ee211ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000ffff217224ULL, 0x002fc400078e0020ULL, 0x000000082a2c7824ULL, 0x000fca00078e00ffULL,
0x00000020141c723cULL, 0x000b62000004181cULL, 0x0000002600267308ULL, 0x000e6c0000000800ULL,
0x3fb8aa3b10217823ULL, 0x120fe20000010833ULL, 0x3fb8aa3b0e337823ULL, 0x000fe20000010833ULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000ea20000000800ULL,
0x000000272610723eULL, 0x002fc400000010ffULL, 0x000000042a267810ULL, 0x040fe40007ffe0ffULL,
0x000000082a277810ULL, 0x040fe40007ffe0ffULL, 0xfffffff837377812ULL, 0x000fe200078ee226ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0xffffffff2a267810ULL, 0x000fce0007ffe0ffULL,
0x0000001300137308ULL, 0x000ee20000000800ULL, 0x000000252412723eULL, 0x004fe400000010ffULL,
0x000000032a257810ULL, 0x040fe40007ffe0ffULL, 0x000000022a247810ULL, 0x000fe40007ffe0ffULL,
0x0000002d2e11723eULL, 0x002fe200000010ffULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000082a2d7824ULL, 0x000fca00078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee224ULL,
0x000000132813723eULL, 0x008fe200000010ffULL, 0x000000082a287824ULL, 0x040fe200078e00ffULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x000000052a247810ULL, 0x000fc60007ffe0ffULL,
0xfffffff8282f7812ULL, 0x000fe200078ee225ULL, 0x0000003c101c723cULL, 0x000b62000004181cULL,
0x000000062a257810ULL, 0x000fe40007ffe0ffULL, 0x0000003300287308ULL, 0x000fe20000000800ULL,
0xfffffff839397812ULL, 0x000fe400078ee224ULL, 0xfffffff82c3b7812ULL, 0x000fe200078ee225ULL,
0x000000082a3d7824ULL, 0x020fe200078e00ffULL, 0x000000303124723eULL, 0x000fc600000010ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0xfffffff83d3d7812ULL, 0x000fe400078ee226ULL,
0x000000320726723eULL, 0x002fe400000010ffULL, 0x0000002223077208ULL, 0x000fc60004800000ULL,
0x0000000f000e7308ULL, 0x0002a40000000800ULL, 0x000000082a0f7824ULL, 0x002fca00078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee22aULL, 0x00000008272a7824ULL, 0x000fe200078e00ffULL,
0x000000290e25723eULL, 0x004fe400000010ffULL, 0x0000000c0d0e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff82a337812ULL, 0x000fe400078ee227ULL, 0x000000212827723eULL, 0x000fe200000010ffULL,
0x000000ffff217224ULL, 0x000fe200078e0020ULL, 0x00009000192a7811ULL, 0x000fca00078e58ffULL,
0x000000100f0f7824ULL, 0x100fe200078e022aULL, 0x00000020241c723cULL, 0x000f62000004181cULL,
0x000000102b2b7824ULL, 0x100fe400078e022aULL, 0x000000102d2d7824ULL, 0x100fe400078e022aULL,
0x000000102f2f7824ULL, 0x100fe400078e022aULL, 0x0000001037377824ULL, 0x000fe400078e022aULL,
0x000000010f0f7824ULL, 0x000fc400078e020eULL, 0x0000001039397824ULL, 0x100fe400078e022aULL,
0x000000010e2b7824ULL, 0x040fe200078e022bULL, 0x000000080f007388ULL, 0x0003e20000000800ULL,
0x000000103b3b7824ULL, 0x100fe400078e022aULL, 0x000000010e2d7824ULL, 0x040fe200078e022dULL,
0x0000000a2b007388ULL, 0x0003e20000000800ULL, 0x000000103d3d7824ULL, 0x100fe400078e022aULL,
0x000000010e2f7824ULL, 0x000fe200078e022fULL, 0x000000142d007388ULL, 0x0003e20000000800ULL,
0x0000001033337824ULL, 0x000fc400078e022aULL, 0x000000010e377824ULL, 0x040fe200078e0237ULL,
0x000000162f007388ULL, 0x0003e20000000800ULL, 0x000000010e397824ULL, 0x040fe400078e0239ULL,
0x000000010e3b7824ULL, 0x040fe200078e023bULL, 0x0000001037007388ULL, 0x0003e20000000800ULL,
0x000000010e3d7824ULL, 0x040fe400078e023dULL, 0x000000010e0e7824ULL, 0x000fe200078e0233ULL,
0x0000001239007388ULL, 0x0003e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fc600078e001eULL,
0x000000243b007388ULL, 0x0003e80000000800ULL, 0x000000263d007388ULL, 0x0003e80000000800ULL,
0x000000090e007388ULL, 0x0003e80000000800ULL, 0x0004000b2b007388ULL, 0x0003e80000000800ULL,
0x000400152d007388ULL, 0x0003e80000000800ULL, 0x000400172f007388ULL, 0x0003e80000000800ULL,
0x0004001137007388ULL, 0x0003e80000000800ULL, 0x0004001339007388ULL, 0x0003e80000000800ULL,
0x000400253b007388ULL, 0x0003e80000000800ULL, 0x000400273d007388ULL, 0x0003e80000000800ULL,
0x00f000040c008388ULL, 0x0003e80000000c00ULL, 0x00f2001c0c008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000036ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080036ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100036ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000138387810ULL, 0x000fe20007ffe0ffULL,
0x0000180036ff7f8cULL, 0x0003e6000c80043fULL, 0x000000023800720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffbec000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff1f7807ULL, 0x008fe40004000000ULL,
0x00012b60001e7802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0048ULL, 0xfffef34000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004000000ULL, 0x00012bb0001e7802ULL, 0x000fc40000000f00ULL,
0x00000c3000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0048ULL,
0xfffef3b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x008fe200078e0045ULL,
0x00012c0000497802ULL, 0x000fc40000000f00ULL, 0x00000b9000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1e7224ULL, 0x004fe200078e0023ULL, 0xfffef47000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e0045ULL, 0x00012c5000497802ULL, 0x000fc40000000f00ULL,
0x00000b4000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1e7224ULL, 0x004fe200078e0023ULL,
0xfffef59000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e001bULL,
0x00012cb000497802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0018ULL,
0x00000ae000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0023ULL,
0xfffef99000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x000fe200078e0016ULL,
0x00012d1000497802ULL, 0x000fe20000000f00ULL, 0x000000ffff237224ULL, 0x000fc400078e001bULL,
0x00000a8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0023ULL,
0xfffef96000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x008fe40004000000ULL,
0x00012d60001e7802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0048ULL, 0xffff21d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004000000ULL, 0x00012db0001e7802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x004fea0003c00000ULL, 0xffff223000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e004aULL, 0x00012df000497802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0023ULL,
0xffff231000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e004aULL,
0x00012e4000497802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0023ULL, 0xffff242000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x00012ea000497802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e001dULL, 0x000008f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0023ULL, 0xffff288000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x00012ef000497802ULL, 0x000fc40000000f00ULL,
0x000008a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0023ULL,
0xffff286000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x004fe40004000000ULL,
0x00012f40001e7802ULL, 0x000fc40000000f00ULL, 0x000008a000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0048ULL, 0xffff4de000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004000000ULL, 0x00012f90001e7802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0048ULL,
0xffff4e2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e0048ULL,
0x00012fe000497802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0023ULL, 0xffff4f0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e0048ULL, 0x0001303000497802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0023ULL,
0xffff501000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x0001309000497802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fc400078e001dULL,
0x0000070000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0023ULL,
0xffff542000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x000130e000497802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0023ULL, 0xffff540000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x002fe40004000000ULL, 0x00013130001e7802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0048ULL,
0xffff79d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004000000ULL,
0x00013180001e7802ULL, 0x000fc40000000f00ULL, 0x0000066000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0048ULL, 0xffff7a1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e0012ULL, 0x000131d000497802ULL, 0x000fc40000000f00ULL,
0x000005c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0023ULL,
0xffff7af000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e0012ULL,
0x0001322000497802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0023ULL, 0xffff7c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e000eULL, 0x0001328000497802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e000fULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0023ULL, 0xffff802000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e000eULL, 0x000132d000497802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0023ULL,
0xffff800000007947ULL, 0x000fea000383ffffULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0001332000307802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0023ULL, 0xffffea8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0037ULL, 0x0001338000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000233700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x000133e000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x00000037233c7208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000230600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0007ULL,
0x0001344000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000000623067208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000230700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0039ULL,
0x000134a000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000000723227208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000233900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e003cULL,
0x0001350000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000003923047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000233c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0001356000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000003c23057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000230600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0022ULL,
0x000135c000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000000623067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe95000007947ULL, 0x000fea000383ffffULL, 0x0180000009007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000900008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff09ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000009027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffec8b002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000003e00007348ULL, 0x000fe80003800000ULL, 0x0c00003332237389ULL, 0x0002a200000e003bULL,
0xfffec87030007950ULL, 0x000fea0003c3ffffULL, 0x0000001400007348ULL, 0x000fe80003800000ULL,
0x0000001e23237389ULL, 0x0002a200000e0013ULL, 0x00000000ff1f7424ULL, 0x000fc400078e00ffULL,
0x000000ffff1e7224ULL, 0x002fc800078e0049ULL, 0xfffec8201e007950ULL, 0x000fea0003c3ffffULL,
0x000000011f00780cULL, 0x000fe20003f05070ULL, 0x0000001200007348ULL, 0x000fd80003800000ULL,
0x00000000001f7806ULL, 0x000fc800040e0100ULL, 0x000000121f487212ULL, 0x000fe200078ec0ffULL,
0x00000000ff1f7424ULL, 0x000fc800078e00ffULL, 0xfffec7c01e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000460ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e30ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000780ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001670ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001710ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001714ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000013900ULL, 0x9500001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015200ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015250ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000155d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001710ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013af0ULL, 0x0000000000013af0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000155d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin_len = 87728;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
