/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017250ULL, 0x0000000000016ed0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000015300ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000015480ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x00000000000154c0ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000015510ULL, 0x00000000000000f0ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015600ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001530000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x0053500400288080ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808f08288080ULL, 0x8092082880809008ULL, 0x082880809a082880ULL, 0x8080a8082880809bULL,
0xb708288080b60828ULL, 0x288080b808288080ULL, 0x808408288080b908ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080849200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0001530000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x8090082880808f08ULL, 0x0828808096082880ULL,
0x80809b082880809aULL, 0xb608288080a80828ULL, 0x288080b708288080ULL, 0x80b908288080b808ULL,
0x1628808094082880ULL, 0x0000031028808280ULL, 0x9492000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000013800000000ULL, 0x0001548000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808408288080ULL, 0x8090082880808f08ULL, 0x0828808092082880ULL, 0x80809b082880809aULL,
0xb608288080a80828ULL, 0x288080b808288080ULL, 0x80b708288080b908ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080b79200ULL, 0x0000002cffffffffULL, 0x000001f000000000ULL,
0x000154c000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80b6288080b70900ULL,
0x0000000000002880ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808408288080ULL, 0x8090082880808f08ULL, 0x082880809a082880ULL, 0x8080a8082880809bULL,
0xb808288080b70828ULL, 0x288080b908288080ULL, 0x828016288080b608ULL, 0x0000000003102880ULL,
0x8080b69200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000002b000000000ULL,
0x0001551000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL,
0x000823040000007fULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL,
0x0000001800080a04ULL, 0x0060190300600160ULL, 0x00000000000c1704ULL, 0x0021f00000580009ULL,
0x00000000000c1704ULL, 0x0021f00000500008ULL, 0x00000000000c1704ULL, 0x0011f00000480007ULL,
0x00000000000c1704ULL, 0x0081f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL, 0x0134290400000900ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x000002e000000110ULL,
0x0000258000000530ULL, 0x0000275000002620ULL, 0x00002d30000028b0ULL, 0x00002db000002d60ULL,
0x0000550000002e00ULL, 0x000056d0000055a0ULL, 0x00005cc000005830ULL, 0x00005d4000005cf0ULL,
0x000082a000005d90ULL, 0x0000847000008340ULL, 0x00008a60000085d0ULL, 0x00008ae000008a90ULL,
0x0000b0b000008b30ULL, 0x0000b2800000b150ULL, 0x0000b8f00000b3e0ULL, 0x0000b9700000b920ULL,
0x0000d4400000b9c0ULL, 0x00013bb00000d450ULL, 0x00013c0000013bf0ULL, 0x00013c6000013c10ULL,
0x00013ca000013c80ULL, 0x0001494000013cb0ULL, 0x000149d000014980ULL, 0x00014a6000014a10ULL,
0x00014b0000014ab0ULL, 0x00014b9000014b40ULL, 0x00014c2000014bd0ULL, 0x00014cc000014c70ULL,
0x00014d5000014d00ULL, 0x00014de000014d90ULL, 0x00014e8000014e30ULL, 0x00014f1000014ec0ULL,
0x00014fa000014f50ULL, 0x0001504000014ff0ULL, 0x00015100000150a0ULL, 0x000151c000015160ULL,
0x0001528000015220ULL, 0x04403904000152e0ULL, 0x000000ff000003b0ULL, 0x003f01000000f600ULL,
0x0000000b00000430ULL, 0x003f01200000f608ULL, 0x0000000b00000480ULL, 0x003f01200000f688ULL,
0x0000000b000004f0ULL, 0x003f01200000f6a8ULL, 0x0000000b00000520ULL, 0x003f01200000f6c8ULL,
0x000000ff00000910ULL, 0x003f01070000f600ULL, 0x0000000000000b10ULL, 0x003f010200000004ULL,
0x0000000000000bd0ULL, 0x003f010100000000ULL, 0x0000007300001390ULL, 0x003f01070000f6a8ULL,
0x00000073000014a0ULL, 0x003f01010000f6a8ULL, 0x0000000200001500ULL, 0x003f01010000f6c8ULL,
0x0000000200001660ULL, 0x003f01050000f6ccULL, 0x0000000200001850ULL, 0x003f01050000f6ccULL,
0x000000ff000021a0ULL, 0x000501070000f6b0ULL, 0x000000ff00002220ULL, 0x000501010000f6b0ULL,
0x0000000f00002280ULL, 0x003f01010000f608ULL, 0x0000000f000022a0ULL, 0x003f01050000f60cULL,
0x0000000f00002470ULL, 0x003f01050000f60cULL, 0x0000003600002a90ULL, 0x003f01050000f6acULL,
0x0000003600002c60ULL, 0x003f01050000f6acULL, 0x0000001600004700ULL, 0x003f010100000000ULL,
0x0000001000004760ULL, 0x003f01010000f688ULL, 0x0000000600004790ULL, 0x003f010500000004ULL,
0x0000000600004950ULL, 0x003f010500000004ULL, 0x0000000200005150ULL, 0x003f01070000f6a8ULL,
0x00000002000051e0ULL, 0x003f01010000f6a8ULL, 0x0000000f00005240ULL, 0x003f01010000f628ULL,
0x0000000f00005260ULL, 0x003f01050000f62cULL, 0x0000000f00005430ULL, 0x003f01050000f62cULL,
0x0000001200005a20ULL, 0x003f01050000f6b4ULL, 0x0000001200005bf0ULL, 0x003f01050000f6b4ULL,
0x0000003600007470ULL, 0x003f010100000000ULL, 0x00000009000074d0ULL, 0x003f01010000f690ULL,
0x0000000600007500ULL, 0x003f010500000004ULL, 0x00000006000076c0ULL, 0x003f010500000004ULL,
0x0000007300007e80ULL, 0x003f01070000f6b0ULL, 0x0000001200007f80ULL, 0x003f01010000f6b0ULL,
0x0000000f00007fe0ULL, 0x003f01010000f648ULL, 0x0000000f00008000ULL, 0x003f01050000f64cULL,
0x0000000f000081d0ULL, 0x003f01050000f64cULL, 0x0000003c000087c0ULL, 0x003f01050000f6acULL,
0x0000003c00008990ULL, 0x003f01050000f6acULL, 0x000000120000a270ULL, 0x003f010100000000ULL,
0x0000001c0000a2d0ULL, 0x003f010100000000ULL, 0x000000060000a300ULL, 0x003f010500000004ULL,
0x000000060000a4c0ULL, 0x003f010500000004ULL, 0x000000ff0000acd0ULL, 0x0004010700000000ULL,
0x000000730000adb0ULL, 0x003f01010000f6a8ULL, 0x000000000000ae10ULL, 0x003f01010000f668ULL,
0x000000000000ae30ULL, 0x003f01050000f66cULL, 0x000000000000b000ULL, 0x003f01050000f66cULL,
0x000000730000b5b0ULL, 0x003f01050000f6b4ULL, 0x000000730000b7f0ULL, 0x003f01050000f6b4ULL,
0x000000020000d210ULL, 0x003f010100000000ULL, 0x000000060000d290ULL, 0x003f010100000000ULL,
0x000000ff0000e3f0ULL, 0x003f01010000f600ULL, 0x000000ff0000f000ULL, 0x003f01050000f604ULL,
0x000000ff0000f1d0ULL, 0x003f01050000f604ULL, 0x000000ff0000f400ULL, 0x003f01010000f600ULL,
0x000000ff0000f430ULL, 0x003f01050000f604ULL, 0x000000ff0000f5f0ULL, 0x003f01050000f604ULL,
0x00000072000120e0ULL, 0x003f010100000000ULL, 0x00000072000121a0ULL, 0x003f010500000004ULL,
0x0000007200012370ULL, 0x003f010500000004ULL, 0x00000074000147a0ULL, 0x003f010100000000ULL,
0x0000007400014800ULL, 0x003f010100000008ULL, 0x0000007400014860ULL, 0x003f010100000010ULL,
0x00000074000148d0ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL, 0x0000dd300000dd00ULL,
0x0000e0700000df10ULL, 0x0000e3000000e200ULL, 0x000149100000f650ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000034cULL, 0x0000001b00000002ULL, 0x000000000000028cULL,
0x0000001b00000002ULL, 0x00000000000001dcULL, 0x0000001b00000002ULL, 0x000000000000010cULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000324ULL,
0x0000001b00000002ULL, 0x0000000000000269ULL, 0x0000001b00000002ULL, 0x00000000000001b6ULL,
0x0000001b00000002ULL, 0x00000000000000e9ULL, 0x0000001b00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff6e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a006e797a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f280000002100ULL,
0x00000000006f7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff0e7819ULL, 0x010fc80000011607ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff0e0e7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003777a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a77ULL,
0x0000040003007624ULL, 0x000fca00078e026eULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000177770810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000177771810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff77aa12ULL, 0x000fc800078e33ffULL, 0x0000007700007306ULL, 0x000e620000209000ULL,
0x000000ff7700720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000377047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603747227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a74ULL, 0x0000000077007224ULL, 0x000fca00078e0206ULL,
0x000000770000720cULL, 0x000fe20003f66070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000e6400000e0000ULL, 0x00000000020b7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003f45270ULL, 0x0000000100003824ULL, 0x000fe200078e0a77ULL,
0x0000000174743810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x000000770000720cULL, 0x000fe40003f86070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL, 0xff317217ff088424ULL, 0x000fe400078e00ffULL,
0x0000000174744810ULL, 0x000fe20007ffe0ffULL, 0x00f60002ff00a388ULL, 0x0005e20000000a00ULL,
0x00000077ff74d212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x00f400080b008388ULL, 0x0007e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fc400078e0a74ULL,
0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL, 0x00f608040b009388ULL, 0x0009e20000008a00ULL,
0x0000000077777224ULL, 0x000fe400078e0206ULL, 0x3fffff60ff06b424ULL, 0x000fe400078e00ffULL,
0x0000001077007824ULL, 0x000fe400078e00ffULL, 0x3fffff80ff02b424ULL, 0x004fe200078e00ffULL,
0x00f688060b00b388ULL, 0x000fe20000008a00ULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x0000000400087c10ULL, 0x008fc4000fffe1ffULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x3fffffc0ff04c424ULL, 0x010fe200078e00ffULL, 0x0000001008087817ULL, 0x000fe20003800000ULL,
0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL, 0x00f6a8020b00b388ULL, 0x000fe40000008a00ULL,
0x000000ff08767207ULL, 0x000fe40000000000ULL, 0x00005a0074087a19ULL, 0x000fe200000006ffULL,
0x00f6c8040b00c388ULL, 0x000fe80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000107600780cULL, 0x000fe20003f05270ULL, 0x000058006f067a24ULL, 0x000fc400078e02ffULL,
0x0000000409027824ULL, 0x002fe400078e020eULL, 0x0000007906067224ULL, 0x000fe400078e0208ULL,
0x0000000202027824ULL, 0x000fcc00078e00ffULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff077819ULL, 0x002fca000001160dULL, 0x0000000102087824ULL, 0x000fc800078e0207ULL,
0x0000000100037824ULL, 0x000fca00078e0208ULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe40000011603ULL, 0x0000000276037217ULL, 0x000fe20007800000ULL,
0x0000000106057824ULL, 0x000fc800078e0205ULL, 0x0000007904067224ULL, 0x000fe400078e0205ULL,
0x000000100d057824ULL, 0x000fe400078e00ffULL, 0x0000000103047824ULL, 0x000fe400078e0a02ULL,
0x0000010006027825ULL, 0x000fe200078e00ffULL, 0x000000f0050b7812ULL, 0x000fe400078ec0ffULL,
0x000000040700720cULL, 0x000fe20003f06070ULL, 0x0000000108047824ULL, 0x000fe200078e020dULL,
0x0000000b020b7212ULL, 0x000fe200078efcffULL, 0x0000001008077824ULL, 0x000fc600078e00ffULL,
0x00005e000b027a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff007047812ULL, 0x000fe400078ee204ULL,
0x00005f0003037a10ULL, 0x000fc60000ffe4ffULL, 0x0000001004077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x000000020d047211ULL, 0x042fe200078fe0ffULL,
0x000000100d057824ULL, 0x000fc800078e00ffULL, 0x0000000100027824ULL, 0x000fe200078e0204ULL,
0x000000f005077812ULL, 0x000fc800078ec0ffULL, 0x0000000402037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fc60000011602ULL, 0x0000000106037824ULL, 0x000fe400078e0203ULL,
0x0000000104067824ULL, 0x000fe400078e020dULL, 0x0000007902027224ULL, 0x000fc800078e0203ULL,
0x0000010002027825ULL, 0x000fca00078e00ffULL, 0x0000000702027212ULL, 0x000fe200078efcffULL,
0x0000001004077824ULL, 0x000fc600078e00ffULL, 0x00005e0002027a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff007067812ULL, 0x000fe400078ee206ULL, 0x00005f0003037a10ULL, 0x000fc600007fe4ffULL,
0x0000001006077824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000047806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400027300ULL, 0x000e7000000e0000ULL, 0x0000000400067309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x000000ffff077224ULL, 0x004fc400078e0a06ULL,
0x00000004ff067424ULL, 0x000fc800078e00ffULL, 0x000066006f027625ULL, 0x000fcc00078e0006ULL,
0x00f60407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008020c7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x0000007f0c0b7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff0c047810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff0b7819ULL, 0x000fe4000001160bULL,
0x00000008ff0a7819ULL, 0x000fca0000011604ULL, 0x0000d8b000008947ULL, 0x000fea0003800000ULL,
0x00000003ff507819ULL, 0x000fe2000001160eULL, 0x00000003ff077424ULL, 0x002fe400078e00ffULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x01ffffff50507812ULL, 0x000fc800078ec0ffULL,
0x0000000b5000720cULL, 0x000fda0003f06070ULL, 0x000000026f008824ULL, 0x000fe400078e00ffULL,
0x00006800ff038624ULL, 0x000fc800078e00ffULL, 0x0000680000038624ULL, 0x000fe200078e0203ULL,
0x0000f6880e007811ULL, 0x000fc600078e18ffULL, 0x0000000150038824ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040700ff738cULL, 0x0003e20000000000ULL,
0x0000640003028625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000802098981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0400780cULL, 0x000fe20003f04070ULL,
0x0000008074537824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe2000001160eULL,
0x00000080ff077424ULL, 0x002fe200078e00ffULL, 0x0000000000ff7f8cULL, 0x0003e2000c80043fULL,
0x000000010e757812ULL, 0x000fe400078ec0ffULL, 0x0000002008787824ULL, 0x000fca00078e00ffULL,
0x0000006053047812ULL, 0x000fe200078ef878ULL, 0x0000590009067a24ULL, 0x004fc800078e02ffULL,
0x0000008006067824ULL, 0x000fc800078e00ffULL, 0x0000620006027625ULL, 0x000fe200078e0007ULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x000000780c077217ULL, 0x002fe20007800000ULL,
0x0000001075007824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fc6000001160dULL,
0x0000000107077824ULL, 0x000fe200078e0a78ULL, 0x0000000406117810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe200078e0206ULL, 0x0000000c06127810ULL, 0x000fe40007ffe0ffULL,
0x0000000007077217ULL, 0x000fe20007800000ULL, 0x000000010f107824ULL, 0x040fe400078e020dULL,
0x000000080f137824ULL, 0x000fe400078e00ffULL, 0x0000000107077824ULL, 0x000fc600078e0a00ULL,
0xfffffff813167812ULL, 0x000fe200078ee210ULL, 0x0000000100137824ULL, 0x000fe200078e0212ULL,
0x0000000806107810ULL, 0x040fe40007ffe0ffULL, 0x000000070600720cULL, 0x080fe20003f66070ULL,
0x0000000104067824ULL, 0x000fe200078e020fULL, 0x000000071100720cULL, 0x080fe20003f46070ULL,
0x0000000100117824ULL, 0x000fe200078e0211ULL, 0x000000071000720cULL, 0x080fe20003f26070ULL,
0x0000000100107824ULL, 0x000fe200078e0210ULL, 0x000000071200720cULL, 0x000fe20003f06070ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000000104177824ULL, 0x000fe200078e0213ULL,
0x0000007006157812ULL, 0x000fe200078ef805ULL, 0x0000000113067824ULL, 0x140fe400078e020dULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x0000001502147210ULL, 0x000fe20007f9e0ffULL,
0x00000001110f7824ULL, 0x040fe400078e020dULL, 0x0000000811187824ULL, 0x000fe200078e00ffULL,
0xfffffff8131a7812ULL, 0x000fe200078ee206ULL, 0x0000000104007824ULL, 0x000fc400078e0211ULL,
0x0000000110127824ULL, 0x040fe400078e020dULL, 0x0000000810197824ULL, 0x000fe400078e00ffULL,
0x0000000104117824ULL, 0x000fe200078e0210ULL, 0xfffffff818047812ULL, 0x000fe200078ee20fULL,
0x0000000103157824ULL, 0x000fe200020e0607ULL, 0xfffffff819187812ULL, 0x000fe200078ee212ULL,
0x0000008000067825ULL, 0x000fe200078e00ffULL, 0x0000b000080f7811ULL, 0x000fc600078e68ffULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x00000070061f7812ULL, 0x000fc600078ef805ULL,
0x0000008017127825ULL, 0x000fe200078e00ffULL, 0x00000070101d7812ULL, 0x000fc600078ef805ULL,
0x0000001004197824ULL, 0x000fe200078e020fULL, 0x0000007012057812ULL, 0x000fe200078ef805ULL,
0x0000001016177824ULL, 0x100fe200078e020fULL, 0x0000001f02047210ULL, 0x000fe20007f9e0ffULL,
0x00000010181b7824ULL, 0x100fe200078e020fULL, 0x0000001d02067210ULL, 0x000fe20007fbe0ffULL,
0x000000101a0f7824ULL, 0x000fe200078e020fULL, 0x0000000502027210ULL, 0x000fe20007fde0ffULL,
0x0000000103057824ULL, 0x040fe200020e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000d901c48ULL, 0x0000000103077824ULL, 0x000fc400028e0611ULL,
0x0000000103037824ULL, 0x000fe200030e0613ULL, 0x0000000004197faeULL, 0x0003e8000d101c48ULL,
0x00000000061b7faeULL, 0x0003e8000c901c48ULL, 0x00000000020f7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001075007824ULL, 0x002fe200078e00ffULL,
0x0000b000081f7811ULL, 0x000fc800078e68ffULL, 0x000000000d007211ULL, 0x000fc800078fe8ffULL,
0x0000000c00147810ULL, 0x040fe20007ffe0ffULL, 0x0000000100077824ULL, 0x040fe200078e020dULL,
0x0000000400107810ULL, 0x040fe20007ffe0ffULL, 0x0000000800127824ULL, 0x000fe400078e00ffULL,
0x0000000104067824ULL, 0x040fe400078e0200ULL, 0x0000000104177824ULL, 0x000fe200078e0214ULL,
0xfffffff8120f7812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000000800127810ULL, 0x000fc60007ffe0ffULL, 0x0000000814197824ULL, 0x000fe200078e00ffULL,
0x0000007006157812ULL, 0x000fe200078ef805ULL, 0x0000000114067824ULL, 0x100fe400078e020dULL,
0x0000000104007824ULL, 0x000fe200078e0210ULL, 0x0000001502147210ULL, 0x000fe20007f1e0ffULL,
0x0000000110117824ULL, 0x040fe200078e020dULL, 0xfffffff819187812ULL, 0x000fe200078ee206ULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x0000000104107824ULL, 0x000fc400078e0212ULL,
0x0000000112137824ULL, 0x000fe200078e020dULL, 0xfffffff816047812ULL, 0x000fe200078ee211ULL,
0x0000000812127824ULL, 0x000fe400078e00ffULL, 0x0000000103157824ULL, 0x000fe400000e0607ULL,
0x0000008000067825ULL, 0x000fe200078e00ffULL, 0xfffffff812167812ULL, 0x000fc600078ee213ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000070061d7812ULL, 0x000fc600078ef805ULL,
0x0000008017127825ULL, 0x000fe200078e00ffULL, 0x00000070101b7812ULL, 0x000fc600078ef805ULL,
0x0000001004177824ULL, 0x000fe200078e021fULL, 0x0000007012057812ULL, 0x000fe200078ef805ULL,
0x000000100f0f7824ULL, 0x100fe200078e021fULL, 0x0000001d02047210ULL, 0x000fe20007f1e0ffULL,
0x0000001016197824ULL, 0x100fe200078e021fULL, 0x0000001b02067210ULL, 0x000fe20007f3e0ffULL,
0x00000010181b7824ULL, 0x000fe200078e021fULL, 0x0000000502027210ULL, 0x000fe20007f5e0ffULL,
0x0000000103057824ULL, 0x040fe200000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140f7faeULL, 0x0003e2000b901c48ULL, 0x0000000103077824ULL, 0x000fc400008e0611ULL,
0x0000000103037824ULL, 0x000fe200010e0613ULL, 0x0000000004177faeULL, 0x0003e8000b901c48ULL,
0x0000000006197faeULL, 0x0003e8000b901c48ULL, 0x00000000021b7faeULL, 0x0003e4000b901c48ULL,
0x0000001008737824ULL, 0x000fe200078e00ffULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x0000000808027824ULL, 0x002fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000730473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80073127f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6c80002027f8cULL, 0x000ee2000c80043fULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000bd2000008947ULL, 0x000fea0003800000ULL, 0x000000026f557824ULL, 0x000fe200078e00ffULL,
0x00000002ff567819ULL, 0x000fe2000001160eULL, 0x00006800ff007624ULL, 0x000fc400078e00ffULL,
0x000000ffff0f7224ULL, 0x008fe400078e0003ULL, 0x0000680055557624ULL, 0x000fe400078e0200ULL,
0xff317217ff007424ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e00ffULL, 0x0000000000147805ULL, 0x01afca0000015200ULL,
0x000000040e027824ULL, 0x000fca00078e00ffULL, 0xfffffff802027812ULL, 0x000fca00078ec0ffULL,
0x00f6cc0002067984ULL, 0x000ee40000000800ULL, 0x8000000006ff7812ULL, 0x008fe4000780480fULL,
0x0000f6c802067810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x004fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011417ULL,
0x0000003510107211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000210107819ULL, 0x000fc80000001217ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc0002107984ULL, 0x000ea40000000800ULL,
0x8000000010ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100e027824ULL, 0x000fe200078e00ffULL,
0x00000001070f7810ULL, 0x000fe20007ffe0ffULL, 0x0000590009097a24ULL, 0x000fe400078e02ffULL,
0x00000080ff147424ULL, 0x000fe200078e00ffULL, 0xffffffe002107812ULL, 0x000fe200078ec0ffULL,
0x0000008009097824ULL, 0x000fe200078e00ffULL, 0x0000000a0f00720cULL, 0x000fc60003f26070ULL,
0x0000010007107824ULL, 0x000fe400078e0210ULL, 0x0000620009147625ULL, 0x000fc600078e0014ULL,
0x00000040100f7810ULL, 0x000fc80007ffe0ffULL, 0x000000600f107812ULL, 0x000fca00078ec0ffULL,
0x00000001533d7824ULL, 0x000fe200078e0210ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000001002097812ULL, 0x000fe200078ec0ffULL, 0x000000100d177824ULL, 0x000fe200078e00ffULL,
0x0000000f0c027217ULL, 0x000fe40007800000ULL, 0x00000003ff167819ULL, 0x000fe4000001160dULL,
0x0000007017477812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a0fULL,
0x0000000416127810ULL, 0x040fe20007ffe0ffULL, 0x0000000116107824ULL, 0x040fe200078e0209ULL,
0x0000000816367810ULL, 0x000fc40007ffe0ffULL, 0x0000000902027217ULL, 0x000fe20007800000ULL,
0x00000001100f7824ULL, 0x040fe400078e020dULL, 0x0000000810347824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc600078e0a09ULL, 0xfffffff8340f7812ULL, 0x000fe400078ee20fULL,
0x000000021200720cULL, 0x0c0fe20003f66070ULL, 0x0000000112127824ULL, 0x000fe200078e0209ULL,
0x000000021600720cULL, 0x0c0fe40003f86070ULL, 0x0000000c16347810ULL, 0x000fe20007ffe0ffULL,
0x0000000112167824ULL, 0x000fe200078e020dULL, 0x000000023600720cULL, 0x080fe20003f46070ULL,
0x0000000812357824ULL, 0x000fe200078e00ffULL, 0x000000023400720cULL, 0x000fe20003f06070ULL,
0x0000000136367824ULL, 0x000fc400078e0209ULL, 0x00000001343c7824ULL, 0x000fe200078e0209ULL,
0xfffffff835097812ULL, 0x000fe200078ee216ULL, 0x000000013d167824ULL, 0x040fe400078e0210ULL,
0x000000013d347824ULL, 0x000fe400078e0212ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004716457212ULL, 0x000fc600078efcffULL,
0x000000013d377824ULL, 0x040fe200078e0236ULL, 0x0000004734437212ULL, 0x000fe200078efcffULL,
0x000000013d3d7824ULL, 0x000fe200078e023cULL, 0x0000004514167210ULL, 0x000fe20007fbe0ffULL,
0x0000000136027824ULL, 0x100fe200078e020dULL, 0x0000004314347210ULL, 0x000fe20007fde0ffULL,
0x00000008363f7824ULL, 0x000fe400078e00ffULL, 0x000000013c107824ULL, 0x040fe400078e020dULL,
0x000000083c417824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee202ULL,
0x0000008037367825ULL, 0x000fe200078e00ffULL, 0x0000c00008027811ULL, 0x000fc400078e68ffULL,
0xfffffff841417812ULL, 0x000fe200078ee210ULL, 0x000000803d3c7825ULL, 0x000fe200078e00ffULL,
0x0000004736457212ULL, 0x000fc600078efcffULL, 0x0000000115177824ULL, 0x040fe200028e0617ULL,
0x000000473c437212ULL, 0x000fe200078efcffULL, 0x0000000115357824ULL, 0x000fe200030e0635ULL,
0x0000004514367210ULL, 0x040fe20007fbe0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0202ULL,
0x0000004314147210ULL, 0x000fe20007fde0ffULL, 0x0000001009097824ULL, 0x100fe400078e0202ULL,
0x000000103f3f7824ULL, 0x000fe200078e0202ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000160f7faeULL, 0x0005e2000e101c48ULL, 0x0000000115377824ULL, 0x000fc400028e0637ULL,
0x0000001041417824ULL, 0x000fe200078e0202ULL, 0x0000000034097faeULL, 0x0005e2000d901c48ULL,
0x0000000115157824ULL, 0x000fc600030e063dULL, 0x00000000363f7faeULL, 0x0005e8000d101c48ULL,
0x0000000014417faeULL, 0x0005e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001002027812ULL, 0x000fe200078ec0ffULL, 0x000000100d0f7824ULL, 0x040fe200078e00ffULL,
0x0000c00008477811ULL, 0x000fe400078e68ffULL, 0x000000020d027211ULL, 0x000fe400078fe8ffULL,
0x000000700f417812ULL, 0x000fc400078ec0ffULL, 0x0000000802127810ULL, 0x040fe20007ffe0ffULL,
0x0000000102097824ULL, 0x040fe200078e020dULL, 0x0000000c023c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000802107824ULL, 0x000fe400078e00ffULL, 0x000000013d167824ULL, 0x040fe400078e0202ULL,
0x000000013d367824ULL, 0x000fe200078e0212ULL, 0xfffffff810097812ULL, 0x000fe200078ee209ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000402107810ULL, 0x000fc60007ffe0ffULL,
0x00000001120f7824ULL, 0x100fe200078e020dULL, 0x0000004116357212ULL, 0x000fe200078efcffULL,
0x0000000110027824ULL, 0x040fe400078e020dULL, 0x0000000810377824ULL, 0x000fe200078e00ffULL,
0x0000003514167210ULL, 0x000fe20007f1e0ffULL, 0x000000013d347824ULL, 0x040fe400078e0210ULL,
0x000000013d3d7824ULL, 0x000fe200078e023cULL, 0xfffffff837027812ULL, 0x000fe200078ee202ULL,
0x0000000812107824ULL, 0x000fc400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee20fULL, 0x000000013c127824ULL, 0x000fe200078e020dULL,
0x0000004134457212ULL, 0x000fe200078efcffULL, 0x000000083c3f7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff83f127812ULL, 0x000fe200078ee212ULL,
0x000000803d3c7825ULL, 0x000fe200078e00ffULL, 0x0000004136437212ULL, 0x000fc600078efcffULL,
0x0000000115177824ULL, 0x000fe200000e0617ULL, 0x000000413c417212ULL, 0x000fe200078efcffULL,
0x0000001009097824ULL, 0x100fe200078e0247ULL, 0x0000004514347210ULL, 0x000fe20007f1e0ffULL,
0x00000010020f7824ULL, 0x100fe200078e0247ULL, 0x0000004314367210ULL, 0x000fe20007f5e0ffULL,
0x00000010103f7824ULL, 0x000fe200078e0247ULL, 0x0000004114147210ULL, 0x000fe20007f7e0ffULL,
0x0000000115357824ULL, 0x040fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016097faeULL, 0x0005e2000b901c48ULL, 0x0000000115377824ULL, 0x000fc400010e0637ULL,
0x0000001012417824ULL, 0x000fe200078e0247ULL, 0x00000000340f7faeULL, 0x0005e2000b901c48ULL,
0x0000000115157824ULL, 0x000fc600018e063dULL, 0x00000000363f7faeULL, 0x0005e8000b901c48ULL,
0x0000000014417faeULL, 0x0005e4000b901c48ULL, 0x000000080e097824ULL, 0x004fe200078e00ffULL,
0x0000000150147810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x00000000090573c2ULL, 0x000ea200000e0000ULL, 0x0000000b1400720cULL, 0x000fe40003f06070ULL,
0x0000001009107812ULL, 0x000fc400078ec0ffULL, 0xffffffe0090f7812ULL, 0x040fe400078ec0ffULL,
0x0000000809127812ULL, 0x000fce00078ec0ffULL, 0x0000000155148824ULL, 0x000fe400078e0214ULL,
0x00000004ff158424ULL, 0x000fe200078e00ffULL, 0xfffffff005057892ULL, 0x004fc6000f8ec03fULL,
0x0000640014148625ULL, 0x000fe200078e0015ULL, 0x0000f6b005067890ULL, 0x000fe2000fffe03fULL,
0x0000000f120f7210ULL, 0x000fc60007ffe010ULL, 0x0000000814028981ULL, 0x000528000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b000ff147f8cULL, 0x004ea2000c800405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f608000f367f8cULL, 0x000664000c80043fULL, 0x0000000000167805ULL, 0x000fc40000015200ULL,
0x00f60c000f357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x00afc40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x00000034163d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e17ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011435ULL,
0x0000003d10107211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000210107819ULL, 0x000fc80000001235ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c000f357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d517824ULL, 0x000fe200078e00ffULL, 0x00000001ff577819ULL, 0x000fe2000001160dULL,
0x000000200e107824ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe200078e00ffULL,
0x0000007051517812ULL, 0x000fc400078ec0ffULL, 0xffffff8010107812ULL, 0x000fe400078ec0ffULL,
0x0000000c57577812ULL, 0x000fc800078ec0ffULL, 0x0000001057107210ULL, 0x000fca0007ffe051ULL,
0x00f0000010177984ULL, 0x000e680000000800ULL, 0x00f2000010167984ULL, 0x0006a20000000800ULL,
0x000000001700720bULL, 0x002fe20003f1d000ULL, 0x000123a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000127806ULL, 0x008fc800000e0100ULL, 0x0000ffff123d7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fe400078e00ffULL,
0x0000001fff727424ULL, 0x000fc400078e00ffULL, 0xffffffffff717424ULL, 0x000fce00078e00ffULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x0000000e5600720cULL, 0x000fe40003f05270ULL,
0x000000001700720bULL, 0x000fe20003f54000ULL, 0x000123427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x000fc400010e0100ULL, 0x000000800e348824ULL, 0x000fe200078e0251ULL,
0x0000000017128209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000157358824ULL, 0x000fe200078e0234ULL, 0x0000991010347816ULL, 0x000fc800000000ffULL,
0x00f4001235008388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000017357209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff10ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000035127221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x0000001200357308ULL, 0x000e640000000800ULL, 0x0000003511117220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff127819ULL, 0x000fe2000001160dULL,
0x000122627f007947ULL, 0x000fea000b800000ULL, 0x00001f1235127589ULL, 0x0002e400000e0000ULL,
0x0000001230307220ULL, 0x08cfe20000410000ULL, 0x0000001231317220ULL, 0x080fe20000410000ULL,
0x000000122c2c7220ULL, 0x080fe20000410000ULL, 0x000000122d2d7220ULL, 0x080fe20000410000ULL,
0x0000001228287220ULL, 0x080fe20000410000ULL, 0x0000001229297220ULL, 0x080fe20000410000ULL,
0x0000001224247220ULL, 0x080fe20000410000ULL, 0x0000001225257220ULL, 0x080fe20000410000ULL,
0x0000001238387220ULL, 0x080fe20000410000ULL, 0x0000001239397220ULL, 0x080fe20000410000ULL,
0x000000121c1c7220ULL, 0x080fe20000410000ULL, 0x000000121d1d7220ULL, 0x080fe20000410000ULL,
0x0000001218187220ULL, 0x080fe20000410000ULL, 0x0000001219197220ULL, 0x080fe20000410000ULL,
0x0000001220207220ULL, 0x080fe20000410000ULL, 0x0000001221217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d127811ULL, 0x000fe200078ff0ffULL,
0x000121427f007947ULL, 0x000fea000b800000ULL, 0x00001f1235127589ULL, 0x00066400000e0000ULL,
0x0000001232327220ULL, 0x086fe20000410000ULL, 0x0000001233337220ULL, 0x080fe20000410000ULL,
0x000000122e2e7220ULL, 0x080fe20000410000ULL, 0x000000122f2f7220ULL, 0x080fe20000410000ULL,
0x000000122a2a7220ULL, 0x080fe20000410000ULL, 0x000000122b2b7220ULL, 0x080fe20000410000ULL,
0x0000001226267220ULL, 0x080fe20000410000ULL, 0x0000001227277220ULL, 0x080fe20000410000ULL,
0x000000123a3a7220ULL, 0x080fe20000410000ULL, 0x000000123b3b7220ULL, 0x080fe20000410000ULL,
0x000000121e1e7220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x000000121a1a7220ULL, 0x080fe20000410000ULL, 0x000000121b1b7220ULL, 0x080fe20000410000ULL,
0x0000001222227220ULL, 0x080fe20000410000ULL, 0x0000001223237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3dff7812ULL, 0x000fe20007806010ULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000000017007209ULL, 0x000fd60007810000ULL,
0x8000000017170221ULL, 0x000fe20000010000ULL, 0x00007610ff100816ULL, 0x000fc60000000010ULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x0000001700050308ULL, 0x000e640000000800ULL,
0x0000000516160220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001116117221ULL, 0x004fc40000010000ULL, 0x0000000000167805ULL, 0x000fca0000015200ULL,
0xfffffff009367812ULL, 0x000fca00078ec0ffULL, 0x00f6ac0036127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff377224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x008fcc0000015200ULL,
0x0000003416127210ULL, 0x000fca0007f1e1ffULL, 0x0000000135347824ULL, 0x000fe200000e0e17ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011434ULL, 0x0000001209097211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0634ULL, 0x0000000209097819ULL, 0x000fc80000001212ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000137377810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0036127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991010097816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff03723eULL, 0x000fe400000010ffULL,
0x00000002ff107819ULL, 0x000fe4000001160dULL, 0x0000541003097816ULL, 0x000fe20000000003ULL,
0x00011d027f007947ULL, 0x000fea000b800000ULL, 0x00001f1009047589ULL, 0x0002a400000e0000ULL,
0x0000000810127810ULL, 0x000fe20007ffe0ffULL, 0x00011d327f007947ULL, 0x000fea000b800000ULL,
0x00001f1209037589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001010127810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff367224ULL, 0x000fe200078e0009ULL,
0x00002dc000377802ULL, 0x000fc40000000f00ULL, 0x0001270000007944ULL, 0x01cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001810127810ULL, 0x006fe20007ffe0ffULL,
0x000000ffff367224ULL, 0x000fe200078e0009ULL, 0x00002e1000377802ULL, 0x000fc40000000f00ULL,
0x000126b000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000020e107824ULL, 0x002fe200078e00ffULL, 0x000000070d177812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x0000000410127812ULL, 0x004fc400078ec0ffULL,
0x0000000817167812ULL, 0x000fe400078ef80dULL, 0x000000120d097211ULL, 0x040fe200078fe0ffULL,
0x000002000e127824ULL, 0x000fe400078e00ffULL, 0x0000000816137824ULL, 0x040fe400078e00ffULL,
0x0000000116527824ULL, 0x000fe200078e0209ULL, 0xfffff80012097812ULL, 0x000fe400078ec0ffULL,
0x000000080d127812ULL, 0x000fc400078ec0ffULL, 0xfffffff813347812ULL, 0x000fca00078ee252ULL,
0x00000010344d7824ULL, 0x000fc400078e0209ULL, 0x000000040e347824ULL, 0x000fe200078e00ffULL,
0x00000004ff477819ULL, 0x000fe2000001160dULL, 0x00000008164b7824ULL, 0x000fe200078e00ffULL,
0x0000001712137212ULL, 0x000fe400078efcffULL, 0x0000000434347812ULL, 0x000fe400078ec0ffULL,
0x0000b00008547811ULL, 0x000fe200078e68ffULL, 0x0000000813357824ULL, 0x008fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ec0ffULL, 0x0000000147447824ULL, 0x000fc400078e0234ULL,
0x00000008133e7824ULL, 0x040fe400078e00ffULL, 0x00000001133c7824ULL, 0x000fe400078e0244ULL,
0x0000000408477824ULL, 0x000fc600078e0247ULL, 0xfffffff8354c7812ULL, 0x000fe400078ee23cULL,
0x009000004d34783bULL, 0x000e620000000200ULL, 0x000000023c137810ULL, 0x000fe40007ffe0ffULL,
0x000000104c407824ULL, 0x000fe200078e0254ULL, 0x00000002474a7810ULL, 0x000fe40007ffe016ULL,
0xfffffff83e137812ULL, 0x000fe400078ee213ULL, 0xfffffff84b4a7812ULL, 0x000fe200078ee24aULL,
0x000000004040783bULL, 0x000ea80000004200ULL, 0x000000104a097824ULL, 0x000fe200078e0209ULL,
0x0000000434348231ULL, 0x002fc400003400ffULL, 0x0000000436368231ULL, 0x000fe400003400ffULL,
0x0000000335358231ULL, 0x080fe400003400ffULL, 0x0000000337378231ULL, 0x000fe200003400ffULL,
0x00000018ff3d7819ULL, 0x004fe40000011642ULL, 0x0000ffff423c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff433f7812ULL, 0x000fe400078ec0ffULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x00000008ff3c7819ULL, 0x000fe4000001163cULL, 0x00000018ff3e7819ULL, 0x000fe20000011643ULL,
0x2000003dff467230ULL, 0x000fe20000004100ULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x0000003cff3d723eULL, 0x000fe200020006ffULL, 0x00000010133c7824ULL, 0x000fe200078e0254ULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x2000003dff457230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe20000011646ULL,
0x2000003eff497230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fe20000011640ULL,
0x2000003fff487230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fe20000011645ULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0x00000010ff497819ULL, 0x000fc40000011649ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x0000001012457812ULL, 0x000fe400078efe17ULL,
0x0000105447167816ULL, 0x000fe40000000016ULL, 0x0000105449177816ULL, 0x000fe20000000048ULL,
0x0000000144447824ULL, 0x000fe200078e0245ULL, 0x000000ff4b4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000845127824ULL, 0x040fe200078e00ffULL, 0x0000ffff40587812ULL, 0x000fe200078ec0ffULL,
0x0000000845477824ULL, 0x000fe200078e00ffULL, 0x00000002444f7810ULL, 0x000fe20007ffe0ffULL,
0x000000163424723cULL, 0x000be20000041824ULL, 0x0000ffff41497812ULL, 0x000fc400078ec0ffULL,
0xfffffff8124f7812ULL, 0x000fe400078ee24fULL, 0x00000010ff4a7819ULL, 0x000fe40000011641ULL,
0x000000ff40167812ULL, 0x020fe400078ec0ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000016ff59723eULL, 0x000fe400020006ffULL, 0xfffffff8474e7812ULL, 0x000fe200078ee244ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000018ff127819ULL, 0x000fc40000011640ULL,
0x00000008ff587819ULL, 0x000fe20000011658ULL, 0x000000104e447824ULL, 0x000fe200078e0254ULL,
0x00000018ff5b7819ULL, 0x000fe40000011641ULL, 0x00000008ff497819ULL, 0x000fe40000011649ULL,
0x000000ff41177812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x002fe4000001163dULL,
0x000000ff3d6a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe4000001163dULL,
0x0000ffff3d477812ULL, 0x000fe200078ec0ffULL, 0x20000059ff3d7230ULL, 0x000fe20000004100ULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x00000012ff5a723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000017ff5c723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x100fe2000001163cULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff3c657812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000018ff667819ULL, 0x000fc4000001163cULL, 0x0000ffff3c467812ULL, 0x000fe200078ec0ffULL,
0x2000005aff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x100fe4000001163eULL,
0x000000ff3e637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff127819ULL, 0x000fe4000001163eULL,
0x0000ffff3e177812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x000fc40000011642ULL,
0x000000ff426b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff487819ULL, 0x000fe40000011643ULL,
0x000000ff436c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fe2000001163dULL,
0x000000004440783bULL, 0x0002a20000004200ULL, 0x00000010ff3e7819ULL, 0x000fe4000001164bULL,
0x000000ff45687812ULL, 0x000fc400078ec0ffULL, 0x000010543e3e7816ULL, 0x000fe4000000003dULL,
0x00000010ff3d7819ULL, 0x000fe4000001163cULL, 0x000000ff48697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3c7819ULL, 0x000fe40000011658ULL, 0x00000010ff5e7819ULL, 0x000fe4000001163fULL,
0x000000ff3f627812ULL, 0x000fc400078ec0ffULL, 0x00000018ff167819ULL, 0x000fe4000001163fULL,
0x0000ffff3f447812ULL, 0x002fe400078ec0ffULL, 0x00000010ff487819ULL, 0x000fe4000001165bULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff3f7819ULL, 0x000fe4000001165cULL,
0x00000010ff4a7819ULL, 0x000fc4000001164aULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x000010543d3c7816ULL, 0x000fe2000000003cULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00001054483d7816ULL, 0x000fe20000000049ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x000010544a3f7816ULL, 0x000fc4000000003fULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000010ff6c7819ULL, 0x000fe2000001166cULL,
0x0000003c342c723cULL, 0x040b62000004182cULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x004fe40000011640ULL,
0x00000010ff3c7819ULL, 0x020fe2000001166bULL, 0x0000003e3430723cULL, 0x000be20000041830ULL,
0x00000010ff3d7819ULL, 0x000fc40000011668ULL, 0x000000ff40647812ULL, 0x040fe400078ec0ffULL,
0x000010543d3c7816ULL, 0x000fe4000000003cULL, 0x00000063ff3e723eULL, 0x020fe200020006ffULL,
0x20000061ff637230ULL, 0x000fe20000004100ULL, 0x00001054693d7816ULL, 0x000fe4000000006cULL,
0x00000018ff677819ULL, 0x000fe20000011640ULL, 0x2000003eff617230ULL, 0x000fe20000004100ULL,
0x0000ffff40487812ULL, 0x000fe200078ec0ffULL, 0x000000104f3e7824ULL, 0x000fe200078e0254ULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x0000003c3428723cULL, 0x000b620000041828ULL,
0x00000010ff407819ULL, 0x000fc40000011641ULL, 0x000000ff416e7812ULL, 0x040fe200078ec0ffULL,
0x000000003e3c783bULL, 0x020e620000004200ULL, 0x00000018ff6d7819ULL, 0x000fe40000011641ULL,
0x0000ffff41497812ULL, 0x000fe400078ec0ffULL, 0x00000062ff68723eULL, 0x000fe400020006ffULL,
0x00000010ff417819ULL, 0x000fe40000011642ULL, 0x000000ff424b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011642ULL, 0x0000ffff42597812ULL, 0x000fe400078ec0ffULL,
0x0000005fff62723eULL, 0x000fe200020006ffULL, 0x20000068ff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff587819ULL, 0x100fe40000011643ULL, 0x000000ff435b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fc40000011643ULL, 0x0000ffff435c7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000066ff42723eULL, 0x000fe400020006ffULL,
0x00000008ff467819ULL, 0x000fe20000011646ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000006aff43723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000008ff667819ULL, 0x000fe20000011647ULL,
0x20000062ff477230ULL, 0x000fe20000004100ULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000066ff62723eULL, 0x000fe200020006ffULL,
0x20000060ff667230ULL, 0x000fe20000004100ULL, 0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL,
0x20000046ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x000fe20000011665ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000105447467816ULL, 0x000fe40000000046ULL,
0x0000105466477816ULL, 0x000fe20000000043ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff437819ULL, 0x000fc40000011642ULL, 0x00000010ff427819ULL, 0x000fe40000011660ULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x000000463438723cULL, 0x000b620000041838ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x0000105443427816ULL, 0x000fe40000000042ULL,
0x0000105463437816ULL, 0x000fe40000000062ULL, 0x00000010ff477819ULL, 0x020fc4000001165fULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x00000042341c723cULL, 0x000b62000004181cULL, 0x000010545e477816ULL, 0x000fe40000000047ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x102fe4000001163dULL,
0x000000ff3d6c7812ULL, 0x000fe200078ec0ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000018ff697819ULL, 0x000fc4000001163dULL, 0x0000ffff3d5e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff467819ULL, 0x000fe40000011661ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x000000ff453d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x000fe4000001163cULL,
0x000000ff3c687812ULL, 0x000fc400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe4000001163cULL,
0x0000ffff3c637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5f7819ULL, 0x100fe4000001163eULL,
0x000000ff3e6b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe4000001163eULL,
0x0000ffff3e437812ULL, 0x020fc400078ec0ffULL, 0x00000008ff177819ULL, 0x000fe40000011617ULL,
0x0000005aff3e723eULL, 0x000fe200020006ffULL, 0x2000006dff5a7230ULL, 0x000fe20000004100ULL,
0x00000012ff3c723eULL, 0x000fe400020006ffULL, 0x00000008ff447819ULL, 0x000fe40000011644ULL,
0x00000016ff12723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000003dff3d723eULL, 0x000fc400020006ffULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x00000008ff6d7819ULL, 0x000fe20000011648ULL, 0x2000003eff487230ULL, 0x000fe20000004100ULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x20000012ff3e7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000003dff127230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x20000017ff3d7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x0000005bff6f723eULL, 0x000fe200020006ffULL, 0x20000067ff5b7230ULL, 0x000fe20000004100ULL,
0x000010545d467816ULL, 0x000fe20000000046ULL, 0x2000006eff677230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fc4000001163fULL, 0x000000ff3f6a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff667819ULL, 0x000fe2000001163fULL, 0x000000463418723cULL, 0x000b620000041818ULL,
0x0000ffff3f427812ULL, 0x000fe400078ec0ffULL, 0x0000004aff3f723eULL, 0x000fe400020006ffULL,
0x000000ff416e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x000fe2000001163cULL,
0x2000003fff457230ULL, 0x000fe20000004100ULL, 0x00000010ff3e7819ULL, 0x000fc4000001163eULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff417819ULL, 0x000fe40000011644ULL,
0x000000ff40167812ULL, 0x000fe400078ec0ffULL, 0x000010543c407816ULL, 0x000fe4000000003dULL,
0x000010543e417816ULL, 0x000fe40000000041ULL, 0x00900000093c783bULL, 0x000e620000000200ULL,
0x0000004bff4b723eULL, 0x000fc400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x000000ff58587812ULL, 0x000fe200078ec0ffULL, 0x2000004bff4a7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006fff4b7230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fe20000011649ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000058ff17723eULL, 0x000fe200020006ffULL, 0x000000403434723cULL, 0x000b620000041820ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff597819ULL, 0x000fc40000011659ULL, 0x00000008ff5c7819ULL, 0x000fe2000001165cULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000016ff16723eULL, 0x000fe400020006ffULL,
0x0000006cff47723eULL, 0x020fe200020006ffULL, 0x20000017ff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x20000016ff467230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff207819ULL, 0x000fc4000001166dULL,
0x00000010ff217819ULL, 0x000fe4000001166fULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000059ff44723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff61617812ULL, 0x000fe400078ec0ffULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x000000043c3c8231ULL, 0x082fe200003400ffULL,
0x000010545b207816ULL, 0x000fe20000000020ULL, 0x000000043e3e8231ULL, 0x000fe200003400ffULL,
0x000010545a217816ULL, 0x000fe20000000021ULL, 0x000000033d3d8231ULL, 0x080fe200003400ffULL,
0x00000010ff227819ULL, 0x000fe2000001164aULL, 0x000000033f3f8231ULL, 0x000fe200003400ffULL,
0x00000010ff237819ULL, 0x000fc4000001166eULL, 0x00000068ff16723eULL, 0x000fe200020006ffULL,
0x20000044ff687230ULL, 0x000fe20000004100ULL, 0x00000069ff58723eULL, 0x000fe200020006ffULL,
0x2000005cff697230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x000000203c2c723cULL, 0x000b62000004182cULL, 0x00000010ff6c7819ULL, 0x000fe2000001166cULL,
0x20000016ff5c7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x0000105423227816ULL, 0x000fe20000000022ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000060ff49723eULL, 0x000fe200020006ffULL, 0x20000047ff607230ULL, 0x000fe20000004100ULL,
0x00000008ff597819ULL, 0x000fe20000011663ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x000010546c237816ULL, 0x000fe2000000004bULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x0000006aff44723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff477819ULL, 0x000fe20000011612ULL, 0x000000223c28723cULL, 0x000b620000041828ULL,
0x00000010ff457819ULL, 0x000fe20000011645ULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff207819ULL, 0x020fe40000011668ULL,
0x00000010ff217819ULL, 0x000fe40000011669ULL, 0x00000010ff677819ULL, 0x000fc40000011667ULL,
0x00000010ff6a7819ULL, 0x000fe40000011646ULL, 0x00000008ff5e7819ULL, 0x000fe4000001165eULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000105447467816ULL, 0x000fe40000000064ULL,
0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000105445207816ULL, 0x000fc40000000020ULL, 0x0000105448217816ULL, 0x000fe40000000021ULL,
0x000010546a477816ULL, 0x000fe40000000067ULL, 0x0000005eff40723eULL, 0x000fe400020006ffULL,
0x00000010ff227819ULL, 0x000fe2000001165cULL, 0x000000203c24723cULL, 0x000f620000041824ULL,
0x00000010ff237819ULL, 0x000fe20000011660ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x0000006bff17723eULL, 0x000fe200020006ffULL, 0x000000463c30723cULL, 0x000b620000041830ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x0000105461227816ULL, 0x000fe20000000022ULL, 0x2000005fff467230ULL, 0x020fe20000004100ULL,
0x0000105462237816ULL, 0x000fc40000000023ULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff207819ULL, 0x000fe40000011649ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000065ff16723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000016ff167230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe20000011640ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000066ff127230ULL, 0x000fe20000004100ULL,
0x0000105420407816ULL, 0x000fc40000000059ULL, 0x000000223c20723cULL, 0x000b620000041838ULL,
0x00000010ff177819ULL, 0x000fe20000011617ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff587819ULL, 0x000fc80000011658ULL, 0x00000010ff387819ULL, 0x020fe40000011646ULL,
0x00000010ff397819ULL, 0x000fe40000011644ULL, 0x0000105438387816ULL, 0x000fe40000000017ULL,
0x00000010ff177819ULL, 0x000fe40000011616ULL, 0x00000010ff3a7819ULL, 0x000fe4000001165dULL,
0x00000010ff167819ULL, 0x000fc40000011643ULL, 0x00000010ff3b7819ULL, 0x000fe40000011612ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x0000105458417816ULL, 0x000fe40000000041ULL,
0x000010543a397816ULL, 0x000fe40000000039ULL, 0x0000105417167816ULL, 0x000fe40000000016ULL,
0x000010543b177816ULL, 0x000fe20000000042ULL, 0x000000403c1c723cULL, 0x040f70000004181cULL,
0x000000383c18723cULL, 0x040f700000041818ULL, 0x000000163c3c723cULL, 0x000b6e0000041834ULL,
0x0000f6c808167811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000016167f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6880010ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff127224ULL, 0x000fc600078e00ffULL,
0x0000000000347805ULL, 0x000fc80000015200ULL, 0x0000040006377984ULL, 0x000ee40000000800ULL,
0x8000000037ff7812ULL, 0x00afc40007804817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x004fc80000011437ULL,
0x0000003910107211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000210107819ULL, 0x000fc80000001237ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040006377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100e127824ULL, 0x000fe400078e00ffULL, 0x0000590002027a24ULL, 0x010fe400078e02ffULL,
0x00000080ff357424ULL, 0x000fe200078e00ffULL, 0xffffffe012107812ULL, 0x004fe200078ec0ffULL,
0x0000008002347824ULL, 0x000fc800078e00ffULL, 0x0000010007107824ULL, 0x000fe400078e0210ULL,
0x0000620034347625ULL, 0x000fc600078e0035ULL, 0x0000008010177810ULL, 0x000fc80007ffe0ffULL,
0x0000006017027812ULL, 0x000fca00078ec0ffULL, 0x0000000153107824ULL, 0x000fe200078e0202ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000170c027217ULL, 0x000fe40007800000ULL,
0x0000001012377812ULL, 0x000fe400078ec0ffULL, 0x00000003ff127819ULL, 0x000fe2000001160dULL,
0x0000000102027824ULL, 0x000fc600078e0a17ULL, 0x0000000412367810ULL, 0x040fe20007ffe0ffULL,
0x0000000112167824ULL, 0x000fe200078e0237ULL, 0x0000000237027217ULL, 0x000fc60007800000ULL,
0x0000000116177824ULL, 0x040fe400078e020dULL, 0x0000000816387824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe400078e0a37ULL, 0x0000000116167824ULL, 0x000fe200078e0210ULL,
0xfffffff838457812ULL, 0x000fe400078ee217ULL, 0x0000000812177810ULL, 0x040fe40007ffe0ffULL,
0x0000000c12387810ULL, 0x000fc40007ffe0ffULL, 0x000000023600720cULL, 0x0c0fe20003f66070ULL,
0x0000000136367824ULL, 0x100fe200078e0237ULL, 0x000000021700720cULL, 0x0c0fe20003f46070ULL,
0x0000000117397824ULL, 0x000fe200078e0237ULL, 0x000000023800720cULL, 0x080fe20003f06070ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000021200720cULL, 0x000fc60003f86070ULL,
0x0000000138407824ULL, 0x000fe200078e0237ULL, 0x0000005116377212ULL, 0x000fe200078efcffULL,
0x0000000136387824ULL, 0x100fe400078e0210ULL, 0x00000001393a7824ULL, 0x040fe200078e0210ULL,
0x0000003734167210ULL, 0x000fe20007fbe0ffULL, 0x0000000139027824ULL, 0x040fe400078e020dULL,
0x0000000839497824ULL, 0x000fe400078e00ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee202ULL, 0x0000000136127824ULL, 0x000fe200078e020dULL,
0x0000005138417212ULL, 0x000fe200078efcffULL, 0x0000000836477824ULL, 0x000fe400078e00ffULL,
0x0000000140367824ULL, 0x000fe400078e0210ULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fc600078ee212ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000513a437212ULL, 0x000fc600078efcffULL, 0x0000000135177824ULL, 0x040fe200028e0617ULL,
0x0000004134387210ULL, 0x000fe20007fbe0ffULL, 0x0000000140027824ULL, 0x000fe200078e020dULL,
0x0000005136417212ULL, 0x000fe200078efcffULL, 0x00000008404b7824ULL, 0x000fe400078e00ffULL,
0x0000000135397824ULL, 0x000fe200028e0639ULL, 0x00000043343a7210ULL, 0x040fe20007fbe0ffULL,
0x0000001047437824ULL, 0x100fe200078e0254ULL, 0x0000004134367210ULL, 0x000fe20007fde0ffULL,
0x0000001045417824ULL, 0x000fe200078e0254ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee202ULL,
0x00000001353b7824ULL, 0x000fc400028e063bULL, 0x0000001049457824ULL, 0x100fe200078e0254ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016417faeULL, 0x0003e2000e101c48ULL,
0x0000000135377824ULL, 0x000fe400030e0637ULL, 0x000000104b477824ULL, 0x000fe200078e0254ULL,
0x0000000038437faeULL, 0x0003e8000d901c48ULL, 0x000000003a457faeULL, 0x0003e8000d101c48ULL,
0x0000000036477faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001012127812ULL, 0x000fc800078ec0ffULL, 0x000000120d127211ULL, 0x000fc800078fe8ffULL,
0x0000000412387810ULL, 0x040fe20007ffe0ffULL, 0x0000000112367824ULL, 0x040fe200078e0210ULL,
0x00000008123a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000112027824ULL, 0x140fe400078e020dULL,
0x0000000812477824ULL, 0x040fe200078e00ffULL, 0x0000000c12127810ULL, 0x000fe20007ffe0ffULL,
0x0000000138167824ULL, 0x040fe400078e020dULL, 0x0000000838497824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee202ULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee216ULL, 0x000000013a177824ULL, 0x000fe200078e020dULL,
0x0000005136417212ULL, 0x000fe200078efcffULL, 0x000000083a407824ULL, 0x000fe400078e00ffULL,
0x0000000138387824ULL, 0x100fe200078e0210ULL, 0x0000004134367210ULL, 0x000fe20007f1e0ffULL,
0x000000013a3a7824ULL, 0x100fe200078e0210ULL, 0xfffffff8404b7812ULL, 0x000fe200078ee217ULL,
0x0000000112167824ULL, 0x000fe400078e0210ULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005138457212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000513a437212ULL, 0x000fe400078efcffULL,
0x0000004534387210ULL, 0x000fe20007f5e0ffULL, 0x0000000112027824ULL, 0x000fe200078e020dULL,
0x0000005116417212ULL, 0x000fe200078efcffULL, 0x0000000812597824ULL, 0x000fe400078e00ffULL,
0x0000000135377824ULL, 0x040fe200000e0637ULL, 0x00000043343a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000135397824ULL, 0x000fe200010e0639ULL, 0xfffffff859597812ULL, 0x000fe200078ee202ULL,
0x0000001049437824ULL, 0x100fe200078e0254ULL, 0x0000004134167210ULL, 0x000fe20007f7e0ffULL,
0x0000001047417824ULL, 0x000fc400078e0254ULL, 0x00000001353b7824ULL, 0x000fe400000e063bULL,
0x000000104b457824ULL, 0x100fe200078e0254ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036417faeULL, 0x0003e2000b901c48ULL, 0x0000000135177824ULL, 0x000fe400018e0617ULL,
0x0000001059477824ULL, 0x000fe200078e0254ULL, 0x0000000038437faeULL, 0x0003e8000b901c48ULL,
0x000000003a457faeULL, 0x0003e8000b901c48ULL, 0x0000000016477faeULL, 0x0003e4000b901c48ULL,
0x000000080e027824ULL, 0x000fca00078e00ffULL, 0xfffffff002027812ULL, 0x000fc800078ec0ffULL,
0x00000000020573c2ULL, 0x000ea200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a805057890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80002387f8cULL, 0x0022a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628000f167f8cULL, 0x000664000c80043fULL, 0x0000000000367805ULL, 0x000fc40000015200ULL,
0x00f62c000f3b7984ULL, 0x000f240000000800ULL, 0x800000003bff7812ULL, 0x012fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a36417210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e37ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001143bULL,
0x0000004102027211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x0000000202027819ULL, 0x000fc8000000123bULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c000f3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200e027824ULL, 0x000fca00078e00ffULL, 0xffffff8002027812ULL, 0x000fc800078ec0ffULL,
0x0000008051027810ULL, 0x000fca0007ffe002ULL, 0x0000000157027824ULL, 0x000fca00078e0202ULL,
0x00f0000002177984ULL, 0x000e680000000800ULL, 0x00f2000002167984ULL, 0x0006a20000000800ULL,
0x000000001700720bULL, 0x002fe20003f1d000ULL, 0x0000f5e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000127806ULL, 0x008fc800000e0100ULL, 0x0000ffff123b7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff107224ULL, 0x000fd200078e0000ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000156377810ULL, 0x000fe40007ffe0ffULL, 0x000000001700720bULL, 0x000fe40003f54000ULL,
0x0000000e3700720cULL, 0x000fe20003f05270ULL, 0x0000f5827f007947ULL, 0x000fd4000b800000ULL,
0x0000000000027806ULL, 0x000fc400010e0100ULL, 0x000000800e128824ULL, 0x000fe200078e0251ULL,
0x0000000017108209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000157378824ULL, 0x000fe200078e0212ULL, 0x0000991002127816ULL, 0x000fc800000000ffULL,
0x00f4001037008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000017377209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff02ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000037107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fcc0000410000ULL,
0x0000001000107308ULL, 0x000e640000000800ULL, 0x0000001011117220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff127819ULL, 0x000fe2000001160dULL,
0x0000f4a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1210127589ULL, 0x0002e400000e0000ULL,
0x0000001230307220ULL, 0x08cfe20000410000ULL, 0x0000001231317220ULL, 0x080fe20000410000ULL,
0x000000122c2c7220ULL, 0x080fe20000410000ULL, 0x000000122d2d7220ULL, 0x080fe20000410000ULL,
0x0000001228287220ULL, 0x080fe20000410000ULL, 0x0000001229297220ULL, 0x080fe20000410000ULL,
0x0000001224247220ULL, 0x080fe20000410000ULL, 0x0000001225257220ULL, 0x080fe20000410000ULL,
0x0000001220207220ULL, 0x080fe20000410000ULL, 0x0000001221217220ULL, 0x080fe20000410000ULL,
0x000000121c1c7220ULL, 0x080fe20000410000ULL, 0x000000121d1d7220ULL, 0x080fe20000410000ULL,
0x0000001218187220ULL, 0x080fe20000410000ULL, 0x0000001219197220ULL, 0x080fe20000410000ULL,
0x000000123c3c7220ULL, 0x080fe20000410000ULL, 0x000000123d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0002ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d127811ULL, 0x000fe200078ff0ffULL,
0x0000f3827f007947ULL, 0x000fea000b800000ULL, 0x00001f1210127589ULL, 0x00066400000e0000ULL,
0x0000001232327220ULL, 0x086fe20000410000ULL, 0x0000001233337220ULL, 0x080fe20000410000ULL,
0x000000122e2e7220ULL, 0x080fe20000410000ULL, 0x000000122f2f7220ULL, 0x080fe20000410000ULL,
0x000000122a2a7220ULL, 0x080fe20000410000ULL, 0x000000122b2b7220ULL, 0x080fe20000410000ULL,
0x0000001226267220ULL, 0x080fe20000410000ULL, 0x0000001227277220ULL, 0x080fe20000410000ULL,
0x0000001222227220ULL, 0x080fe20000410000ULL, 0x0000001223237220ULL, 0x080fe20000410000ULL,
0x000000121e1e7220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x000000121a1a7220ULL, 0x080fe20000410000ULL, 0x000000121b1b7220ULL, 0x080fe20000410000ULL,
0x000000123e3e7220ULL, 0x080fe20000410000ULL, 0x000000123f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe20007806002ULL,
0x00000001ff027424ULL, 0x000fe200078e00ffULL, 0x0000000017107209ULL, 0x008fd60007810000ULL,
0x8000001017170221ULL, 0x000fe20000010000ULL, 0x00007610ff020816ULL, 0x000fc60000000002ULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x0000001700050308ULL, 0x000e640000000800ULL,
0x0000000516160220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001116117221ULL, 0x004fc40000010000ULL, 0x0000000000167805ULL, 0x000fca0000015200ULL,
0x000000080e007824ULL, 0x000fca00078e00ffULL, 0xfffffff000127812ULL, 0x000fca00078ec0ffULL,
0x00f6b40012377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036163b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e17ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011437ULL,
0x0000003b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000200007819ULL, 0x000fc80000001237ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40012377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991002007816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff157819ULL, 0x000fe4000001160dULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0000ef327f007947ULL, 0x000fea000b800000ULL,
0x00001f1500047589ULL, 0x0002a400000e0000ULL, 0x0000000815127810ULL, 0x000fe20007ffe0ffULL,
0x0000ef627f007947ULL, 0x000fea000b800000ULL, 0x00001f1200037589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001015127810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff367224ULL, 0x000fe200078e0000ULL, 0x00005d5000377802ULL, 0x000fc40000000f00ULL,
0x0000f77000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001815127810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff367224ULL, 0x000fe200078e0000ULL,
0x00005da000377802ULL, 0x000fc40000000f00ULL, 0x0000f72000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100054027810ULL, 0x000fe20007ffe0ffULL, 0x009800004d40783bULL, 0x000f280000000200ULL,
0x000000104c487824ULL, 0x000fc400078e0202ULL, 0x0000001013447824ULL, 0x000fc800078e0202ULL,
0x000000004848783bULL, 0x000ee80000004200ULL, 0x000000004444783bULL, 0x000ea40000004200ULL,
0x0000000440408231ULL, 0x094fe400003400ffULL, 0x0000000442428231ULL, 0x000fe400003400ffULL,
0x0000000341418231ULL, 0x002fc400003400ffULL, 0x0000000343438231ULL, 0x000fe200003400ffULL,
0x000000ff48127812ULL, 0x008fe400078ec0ffULL, 0x00000018ff007819ULL, 0x100fe40000011648ULL,
0x000000ff49147812ULL, 0x000fe400078ec0ffULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x00000000ff00723eULL, 0x000fe400020006ffULL, 0x00000014ff15723eULL, 0x000fe200020006ffULL,
0x20000012ff147230ULL, 0x000fe20000004100ULL, 0x00000018ff127819ULL, 0x000fe20000011649ULL,
0x20000000ff3a7230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe20000011648ULL,
0x20000015ff177230ULL, 0x000fe20000004100ULL, 0x00000012ff3b723eULL, 0x000fc400020006ffULL,
0x000000ff4b167812ULL, 0x000fe400078ec0ffULL, 0x000000ff4a157812ULL, 0x000fe200078ec0ffULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff127819ULL, 0x000fe40000011649ULL,
0x000000ff00007812ULL, 0x000fe400078ec0ffULL, 0x00000016ff37723eULL, 0x000fe400020006ffULL,
0x00000015ff36723eULL, 0x000fc400020006ffULL, 0x000000ff12167812ULL, 0x000fe400078ec0ffULL,
0x00000000ff15723eULL, 0x000fe200020006ffULL, 0x20000036ff127230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fe200020006ffULL, 0x20000037ff007230ULL, 0x000fe20000004100ULL,
0x0000ffff48487812ULL, 0x000fe200078ec0ffULL, 0x20000015ff157230ULL, 0x000fe20000004100ULL,
0x0000ffff49377812ULL, 0x000fe200078ec0ffULL, 0x20000016ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fc40000011614ULL, 0x00000010ff157819ULL, 0x000fe40000011615ULL,
0x00000008ff167819ULL, 0x000fe40000011648ULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x00000010ff487819ULL, 0x000fe40000011636ULL, 0x00000010ff177819ULL, 0x000fe40000011617ULL,
0x0000105415367816ULL, 0x000fc40000000014ULL, 0x00000010ff147819ULL, 0x000fe4000001164aULL,
0x00000010ff157819ULL, 0x000fe4000001164bULL, 0x00000037ff49723eULL, 0x000fe400020006ffULL,
0x0000105448377816ULL, 0x000fe20000000017ULL, 0x000000104e177824ULL, 0x000fe200078e0202ULL,
0x00000016ff16723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x000000ff14147812ULL, 0x000fc400078ec0ffULL, 0x000000ff15157812ULL, 0x000fe200078ec0ffULL,
0x20000016ff487230ULL, 0x000fe20000004100ULL, 0x00000014ff58723eULL, 0x000fe200020006ffULL,
0x000000364030723cULL, 0x000b620000041830ULL, 0x00000015ff59723eULL, 0x000fe400020006ffULL,
0x000000001714783bULL, 0x000e620000004200ULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x0000ffff4a5c7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x020fc4000001163aULL, 0x00000010ff3a7819ULL, 0x000fe40000011648ULL,
0x00000010ff367819ULL, 0x000fe4000001163bULL, 0x00000010ff3b7819ULL, 0x000fe40000011649ULL,
0x00001054373a7816ULL, 0x000fe4000000003aULL, 0x0000ffff4b5d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff127819ULL, 0x000fc40000011612ULL, 0x00000010ff377819ULL, 0x000fe40000011658ULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00001054363b7816ULL, 0x000fe4000000003bULL, 0x00000018ff6f7819ULL, 0x000fe4000001164aULL,
0x00000018ff6e7819ULL, 0x000fc4000001164bULL, 0x00000008ff5c7819ULL, 0x000fe2000001165cULL,
0x0000003a402c723cULL, 0x000f62000004182cULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x0000105437367816ULL, 0x000fe40000000012ULL, 0x0000105459377816ULL, 0x000fe40000000000ULL,
0x00000010ff637819ULL, 0x000fe40000011644ULL, 0x000000ff44697812ULL, 0x000fc400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe20000011644ULL, 0x000000364028723cULL, 0x000b620000041828ULL,
0x0000ffff44647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff007819ULL, 0x102fe40000011614ULL,
0x000000ff14687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff447819ULL, 0x000fe40000011614ULL,
0x0000ffff145a7812ULL, 0x000fc400078ec0ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000005cff14723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011645ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fc40000011615ULL,
0x000000ff15627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe40000011615ULL,
0x0000ffff15127812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x100fe40000011616ULL,
0x000000ff164a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fc40000011616ULL,
0x0000ffff16587812ULL, 0x000fe400078ec0ffULL, 0x00000063ff16723eULL, 0x000fe400020006ffULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff147819ULL, 0x000fe40000011614ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff157819ULL, 0x000fc4000001165dULL,
0x00000069ff36723eULL, 0x020fe400020006ffULL, 0x000000ff65697812ULL, 0x000fe400078ec0ffULL,
0x000010546f147816ULL, 0x000fe20000000014ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x000010546e157816ULL, 0x000fe40000000015ULL, 0x00000008ff657819ULL, 0x000fe20000011664ULL,
0x20000016ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x100fe20000011617ULL,
0x000000104f167824ULL, 0x000fe200078e0202ULL, 0x000000ff175f7812ULL, 0x000fe200078ec0ffULL,
0x000000144024723cULL, 0x000b620000041824ULL, 0x00000018ff5e7819ULL, 0x000fc40000011617ULL,
0x0000ffff175b7812ULL, 0x000fe400078ec0ffULL, 0x000000001614783bULL, 0x020e620000004200ULL,
0x000000ff453a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff45667812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x100fe40000011646ULL, 0x00000010ff3b7819ULL, 0x000fe40000011646ULL,
0x000000ff476b7812ULL, 0x000fc400078ec0ffULL, 0x0000003aff37723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x2000006aff637230ULL, 0x000fe20000004100ULL, 0x00000018ff6c7819ULL, 0x000fe20000011645ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x000fc40000011647ULL,
0x000000ff466d7812ULL, 0x040fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff46467812ULL, 0x000fe400078ec0ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x00000067ff3a723eULL, 0x000fe200020006ffULL, 0x2000006bff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff456a7812ULL, 0x000fe400078ec0ffULL, 0x0000006cff67723eULL, 0x000fe200020006ffULL,
0x2000003aff3a7230ULL, 0x000fe20000004100ULL, 0x0000003bff45723eULL, 0x000fe200020006ffULL,
0x20000065ff3b7230ULL, 0x000fe20000004100ULL, 0x00000008ff467819ULL, 0x000fe20000011646ULL,
0x20000066ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011636ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe20000011664ULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fc40000011637ULL,
0x00000010ff667819ULL, 0x000fe40000011669ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000046ff64723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000006dff5c7230ULL, 0x000fe20000004100ULL, 0x000010546b367816ULL, 0x000fe20000000036ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000105466377816ULL, 0x000fe20000000037ULL,
0x2000006aff467230ULL, 0x000fe20000004100ULL, 0x00000018ff617819ULL, 0x000fc40000011647ULL,
0x00000010ff697819ULL, 0x000fe4000001163aULL, 0x0000ffff47477812ULL, 0x000fe200078ec0ffULL,
0x000000364020723cULL, 0x000b620000041820ULL, 0x00000010ff3a7819ULL, 0x000fe4000001163bULL,
0x00000010ff667819ULL, 0x000fe40000011667ULL, 0x00000010ff3b7819ULL, 0x000fe40000011665ULL,
0x00000008ff477819ULL, 0x000fc40000011647ULL, 0x00001054693a7816ULL, 0x000fe4000000003aULL,
0x00001054663b7816ULL, 0x000fe4000000003bULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x0000003a401c723cULL, 0x000b64000004181cULL, 0x00000010ff367819ULL, 0x020fc40000011664ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000044ff65723eULL, 0x000fe400020006ffULL, 0x00000018ff377819ULL, 0x002fc40000011614ULL,
0x0000105445447816ULL, 0x000fe2000000005cULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000105463367816ULL, 0x000fe40000000036ULL, 0x0000105446457816ULL, 0x000fe4000000005dULL,
0x00000010ff677819ULL, 0x100fe40000011615ULL, 0x000000ff156e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011615ULL, 0x000000444018723cULL, 0x000b620000041818ULL,
0x0000ffff15637812ULL, 0x000fc400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe40000011616ULL,
0x000000ff16157812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011616ULL,
0x0000ffff165d7812ULL, 0x000fe200078ec0ffULL, 0x20000047ff167230ULL, 0x000fe20000004100ULL,
0x00000010ff3a7819ULL, 0x000fe40000011614ULL, 0x000000ff146f7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff143b7812ULL, 0x000fe200078ec0ffULL, 0x20000061ff147230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000015ff15723eULL, 0x000fe200020006ffULL, 0x20000037ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe20000011616ULL, 0x20000048ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fc40000011614ULL, 0x0000006bff48723eULL, 0x000fe400020006ffULL,
0x000000ff006b7812ULL, 0x000fe200078ec0ffULL, 0x20000015ff007230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x100fe20000011617ULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x000000ff176d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011617ULL,
0x0000ffff17467812ULL, 0x000fc400078ec0ffULL, 0x0000105437377816ULL, 0x000fe40000000016ULL,
0x009800000914783bULL, 0x0002a20000000200ULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000004aff617230ULL, 0x000fe20000004100ULL, 0x0000006eff4a723eULL, 0x000fe200020006ffULL,
0x00000036403c723cULL, 0x000b62000004183cULL, 0x000000ff606e7812ULL, 0x000fe200078ec0ffULL,
0x2000006dff447230ULL, 0x020fe20000004100ULL, 0x00000008ff457819ULL, 0x000fe20000011612ULL,
0x2000006cff127230ULL, 0x000fe20000004100ULL, 0x00000008ff607819ULL, 0x000fe2000001165aULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff596c7812ULL, 0x000fc400078ec0ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000062ff697230ULL, 0x000fe20000004100ULL,
0x0000006eff5a723eULL, 0x000fe200020006ffULL, 0x2000006aff097230ULL, 0x002fe20000004100ULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000045ff59723eULL, 0x000fe200020006ffULL,
0x2000006bff457230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000060ff6a7230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe20000011658ULL,
0x20000059ff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff3a587812ULL, 0x000fe400078ec0ffULL,
0x000000ff4b6e7812ULL, 0x000fe200078ec0ffULL, 0x2000005aff4b7230ULL, 0x000fe20000004100ULL,
0x000000ff673a7812ULL, 0x000fe200078ec0ffULL, 0x0000000414148231ULL, 0x084fe200003400ffULL,
0x00000008ff5a7819ULL, 0x000fe2000001165bULL, 0x2000006cff5b7230ULL, 0x000fe20000004100ULL,
0x0000003aff6c723eULL, 0x000fe200020006ffULL, 0x0000000416168231ULL, 0x000fe200003400ffULL,
0x00000008ff677819ULL, 0x000fe2000001163bULL, 0x0000000315158231ULL, 0x080fe200003400ffULL,
0x00000010ff3a7819ULL, 0x000fe20000011668ULL, 0x0000000317178231ULL, 0x000fe200003400ffULL,
0x00000010ff457819ULL, 0x000fc40000011645ULL, 0x00000010ff3b7819ULL, 0x000fe40000011669ULL,
0x00000010ff687819ULL, 0x000fe4000001164bULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff367819ULL, 0x000fe4000001166aULL,
0x00000010ff377819ULL, 0x000fc4000001166bULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x2000006eff607230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000049ff5f7230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00001054453a7816ULL, 0x000fe2000000003aULL,
0x2000006dff597230ULL, 0x000fe20000004100ULL, 0x00001054683b7816ULL, 0x000fe2000000003bULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000105465367816ULL, 0x000fc40000000036ULL,
0x0000105466377816ULL, 0x000fe40000000037ULL, 0x00000008ff637819ULL, 0x000fe20000011663ULL,
0x0000003a1430723cULL, 0x040b620000041830ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x020fe20000011661ULL, 0x00000036142c723cULL, 0x000b62000004182cULL,
0x00000010ff3b7819ULL, 0x000fe20000011662ULL, 0x20000058ff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x2000006cff587230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff367819ULL, 0x020fe40000011659ULL,
0x00000010ff377819ULL, 0x000fe4000001165aULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000063ff41723eULL, 0x000fe200020006ffULL,
0x2000006fff497230ULL, 0x000fe20000004100ULL, 0x000010545b3a7816ULL, 0x000fe2000000003aULL,
0x20000067ff457230ULL, 0x000fe20000004100ULL, 0x00001054603b7816ULL, 0x000fe2000000003bULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x000010545f367816ULL, 0x000fc40000000036ULL,
0x000010545e377816ULL, 0x000fe40000000037ULL, 0x000000ff64647812ULL, 0x000fe200078ec0ffULL,
0x0000003a1428723cULL, 0x040b620000041828ULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff3a7819ULL, 0x020fe20000011649ULL, 0x000000361424723cULL, 0x000b620000041824ULL,
0x00000010ff3b7819ULL, 0x000fc4000001164aULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff367819ULL, 0x020fe40000011645ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff377819ULL, 0x000fc40000011641ULL, 0x00000064ff40723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005dff42723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x000010544b3a7816ULL, 0x000fe2000000003aULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00001054583b7816ULL, 0x000fe2000000003bULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x0000105447367816ULL, 0x000fe40000000036ULL, 0x0000105448377816ULL, 0x000fe20000000037ULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x0000003a1420723cULL, 0x040b620000041820ULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff417819ULL, 0x000fe4000001165cULL, 0x00000010ff3b7819ULL, 0x020fe20000011640ULL,
0x00000036141c723cULL, 0x000b62000004181cULL, 0x00000010ff097819ULL, 0x000fc40000011609ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x000010543b3a7816ULL, 0x000fe20000000000ULL,
0x000000020e007824ULL, 0x000fe200078e00ffULL, 0x00000010ff377819ULL, 0x020fe40000011612ULL,
0x00000010ff367819ULL, 0x000fe40000011642ULL, 0x00001054413b7816ULL, 0x000fe40000000044ULL,
0x0000105437367816ULL, 0x000fc40000000036ULL, 0x0000105409377816ULL, 0x000fe40000000046ULL,
0xfffffff800097812ULL, 0x000fe200078ec0ffULL, 0x0000003a1418723cULL, 0x040f700000041818ULL,
0x000000361414723cULL, 0x000b6e000004183cULL, 0x0000f6c808367811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000036367f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6900009ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff007224ULL, 0x000fc600078e00ffULL, 0x00000000003a7805ULL, 0x000fc80000015200ULL,
0x0000040006097984ULL, 0x004ea40000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804837ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0000003c3a127210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3c7824ULL, 0x000fe200000e0e3bULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff3c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff3c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001143cULL, 0x0000001209097211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e063cULL, 0x0000000209097819ULL, 0x000fc80000001212ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000100007810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040006097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010007007824ULL, 0x000fca00078e0278ULL,
0x000000c000377810ULL, 0x000fc80007ffe0ffULL, 0x0000006037127812ULL, 0x000fca00078ec0ffULL,
0x0000000153097824ULL, 0x000fe200078e0212ULL, 0x000003e000009947ULL, 0x000fea0003800000ULL,
0x000000370c127217ULL, 0x000fe20007800000ULL, 0x000000100e367824ULL, 0x000fc800078e00ffULL,
0x0000000112127824ULL, 0x000fe200078e0a37ULL, 0x0000001036377812ULL, 0x000fe400078ec0ffULL,
0x00000003ff367819ULL, 0x000fe4000001160dULL, 0x0000001237127217ULL, 0x000fe40007800000ULL,
0x00000004363b7810ULL, 0x040fe20007ffe0ffULL, 0x00000001363a7824ULL, 0x140fe200078e0237ULL,
0x00000008363c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112127824ULL, 0x100fe200078e0a37ULL,
0x0000000c363d7810ULL, 0x000fe20007ffe0ffULL, 0x000000013b3e7824ULL, 0x000fc400078e0237ULL,
0x000000013c407824ULL, 0x000fe200078e0237ULL, 0x000000123600720cULL, 0x080fe20003f86070ULL,
0x000000013a367824ULL, 0x040fe200078e0209ULL, 0x000000123b00720cULL, 0x080fe20003f66070ULL,
0x000000013a3b7824ULL, 0x000fe200078e020dULL, 0x000000123c00720cULL, 0x080fe20003f46070ULL,
0x000000083a3c7824ULL, 0x000fe200078e00ffULL, 0x000000123d00720cULL, 0x040fe20003f06070ULL,
0x000000013d427824ULL, 0x000fe400078e0237ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff83c437812ULL, 0x000fc600078ee23bULL, 0x000000013e3a7824ULL, 0x000fe200078e020dULL,
0x00000051363b7212ULL, 0x000fe200078efcffULL, 0x000000083e457824ULL, 0x040fe400078e00ffULL,
0x000000013e3e7824ULL, 0x100fe200078e0209ULL, 0x0000003b34367210ULL, 0x000fe20007fbe0ffULL,
0x00000001403c7824ULL, 0x000fe200078e0209ULL, 0xfffffff845457812ULL, 0x000fe200078ee23aULL,
0x000000803e3e7825ULL, 0x000fc800078e00ffULL, 0x00000001423a7824ULL, 0x000fe200078e0209ULL,
0x000000513e097212ULL, 0x000fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x000000513c417212ULL, 0x000fc600078efcffULL,
0x0000000140127824ULL, 0x040fe400078e020dULL, 0x0000000840477824ULL, 0x000fe400078e00ffULL,
0x0000000135377824ULL, 0x000fe200028e0637ULL, 0x00000009343e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000842497824ULL, 0x000fe200078e00ffULL, 0x000000513a097212ULL, 0x000fe400078efcffULL,
0xfffffff847477812ULL, 0x000fe200078ee212ULL, 0x0000000142127824ULL, 0x000fc400078e020dULL,
0x00000001353f7824ULL, 0x000fe200028e063fULL, 0x00000041343c7210ULL, 0x040fe20007fbe0ffULL,
0x0000001047417824ULL, 0x100fe200078e0202ULL, 0x0000000934347210ULL, 0x000fe20007fde0ffULL,
0x0000001043097824ULL, 0x000fe200078e0202ULL, 0xfffffff849497812ULL, 0x000fe200078ee212ULL,
0x00000001353d7824ULL, 0x040fe400028e063dULL, 0x0000000135357824ULL, 0x000fe200030e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036097faeULL, 0x0003e2000e101c48ULL,
0x00000010453b7824ULL, 0x000fc400078e0202ULL, 0x0000001049437824ULL, 0x000fc600078e0202ULL,
0x000000003e3b7faeULL, 0x0003e8000d901c48ULL, 0x000000003c417faeULL, 0x0003e8000d101c48ULL,
0x0000000034437faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x000000100e127824ULL, 0x000fca00078e00ffULL, 0x0000001012127812ULL, 0x000fc800078ec0ffULL,
0x000000120d127211ULL, 0x000fc800078fe8ffULL, 0x00000004123e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000112367824ULL, 0x140fe200078e020dULL, 0x00000008123a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000812457824ULL, 0x000fe400078e00ffULL, 0x000000013e377824ULL, 0x140fe400078e020dULL,
0x000000083e3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee236ULL,
0x000000013a3b7824ULL, 0x040fe400078e020dULL, 0x000000083a407824ULL, 0x000fe200078e00ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee237ULL, 0x00000001123c7824ULL, 0x140fe200078e0209ULL,
0x0000000c12127810ULL, 0x000fe20007ffe0ffULL, 0x000000013e3e7824ULL, 0x000fe200078e0209ULL,
0xfffffff840497812ULL, 0x000fe200078ee23bULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x000000013a3a7824ULL, 0x100fe400078e0209ULL, 0x0000000112367824ULL, 0x000fe200078e0209ULL,
0x000000513c097212ULL, 0x000fe200078efcffULL, 0x000000803e3e7825ULL, 0x000fc600078e00ffULL,
0x00000009343c7210ULL, 0x000fe20007f1e0ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x000000513e437212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000513a417212ULL, 0x000fe400078efcffULL, 0x00000043343e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000112407824ULL, 0x000fe200078e020dULL, 0x0000005136097212ULL, 0x000fe200078efcffULL,
0x00000008124b7824ULL, 0x000fe400078e00ffULL, 0x00000001353d7824ULL, 0x040fe200000e063dULL,
0x00000041343a7210ULL, 0x040fe20007f1e0ffULL, 0x00000001353f7824ULL, 0x000fe200010e063fULL,
0x0000000934347210ULL, 0x000fe20007f7e0ffULL, 0x0000001045097824ULL, 0x000fe200078e0202ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee240ULL, 0x00000001353b7824ULL, 0x000fc400000e063bULL,
0x0000000135357824ULL, 0x000fe200018e0637ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c097faeULL, 0x0003e2000b901c48ULL, 0x0000001047377824ULL, 0x100fe400078e0202ULL,
0x0000001049417824ULL, 0x100fe400078e0202ULL, 0x000000104b437824ULL, 0x000fe200078e0202ULL,
0x000000003e377faeULL, 0x0003e8000b901c48ULL, 0x000000003a417faeULL, 0x0003e8000b901c48ULL,
0x0000000034437faeULL, 0x0003e4000b901c48ULL, 0x00000000730573c2ULL, 0x000ea200000e0000ULL,
0x0000000250507810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff097424ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000b5000720cULL, 0x000fda0003f06070ULL,
0x0000000150348824ULL, 0x000fe400078e0255ULL, 0x00000004ff358424ULL, 0x000fe200078e00ffULL,
0x0000f6b005057890ULL, 0x004fc6000fffe03fULL, 0x0000640034348625ULL, 0x000fca00078e0035ULL,
0x0000000834098981ULL, 0x000322000c1e1900ULL, 0x000000080e127824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a05ULL, 0xfffffff012127812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b00012347f8cULL, 0x0022a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648000f367f8cULL, 0x000664000c80043fULL, 0x00000000003a7805ULL, 0x000fc40000015200ULL,
0x00f64c000f3d7984ULL, 0x000ee40000000800ULL, 0x800000003dff7812ULL, 0x00afe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c3a3f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e3bULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc8000001143dULL,
0x0000003f12127211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x0000000212127819ULL, 0x000fc8000000123dULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c000f3d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200e0f7824ULL, 0x000fca00078e00ffULL, 0xffffff800f127812ULL, 0x000fc800078ec0ffULL,
0x0000010051127810ULL, 0x000fca0007ffe012ULL, 0x0000000157127824ULL, 0x000fca00078e0212ULL,
0x00f00000123b7984ULL, 0x000e680000000800ULL, 0x00f20000123a7984ULL, 0x0006a20000000800ULL,
0x000000103b00720bULL, 0x002fe20003f1d000ULL, 0x0000ca027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000127806ULL, 0x008fc800000e0100ULL, 0x0000ffff123c7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff127424ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fd200078e0010ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000002560f7810ULL, 0x000fe40007ffe0ffULL, 0x000000103b00720bULL, 0x000fe40003f54000ULL,
0x0000000e0f00720cULL, 0x000fe20003f05270ULL, 0x0000c9a27f007947ULL, 0x000fd4000b800000ULL,
0x00000000000f7806ULL, 0x000fc400010e0100ULL, 0x000000800e368824ULL, 0x000fe200078e0251ULL,
0x000000103b128209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000157378824ULL, 0x000fe200078e0236ULL, 0x000099100f367816ULL, 0x000fc800000000ffULL,
0x00f4001237008388ULL, 0x0003e20000000800ULL, 0x000000ff3600720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000103b377209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0fff7812ULL, 0x000fc6000780c0ffULL,
0x0000001037127221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x00000012003e7308ULL, 0x000e640000000800ULL, 0x0000003e11117220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff127819ULL, 0x000fe2000001160dULL,
0x0000c8c27f007947ULL, 0x000fea000b800000ULL, 0x00001f123e127589ULL, 0x0002e400000e0000ULL,
0x0000001230307220ULL, 0x08cfe20000410000ULL, 0x0000001231317220ULL, 0x080fe20000410000ULL,
0x000000122c2c7220ULL, 0x080fe20000410000ULL, 0x000000122d2d7220ULL, 0x080fe20000410000ULL,
0x0000001228287220ULL, 0x080fe20000410000ULL, 0x0000001229297220ULL, 0x080fe20000410000ULL,
0x0000001224247220ULL, 0x080fe20000410000ULL, 0x0000001225257220ULL, 0x080fe20000410000ULL,
0x0000001220207220ULL, 0x080fe20000410000ULL, 0x0000001221217220ULL, 0x080fe20000410000ULL,
0x000000121c1c7220ULL, 0x080fe20000410000ULL, 0x000000121d1d7220ULL, 0x080fe20000410000ULL,
0x0000001218187220ULL, 0x080fe20000410000ULL, 0x0000001219197220ULL, 0x080fe20000410000ULL,
0x0000001214147220ULL, 0x080fe20000410000ULL, 0x0000001215157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d127811ULL, 0x000fe200078ff0ffULL,
0x0000c7a27f007947ULL, 0x000fea000b800000ULL, 0x00001f123e127589ULL, 0x00066400000e0000ULL,
0x0000001232327220ULL, 0x086fe20000410000ULL, 0x0000001233337220ULL, 0x080fe20000410000ULL,
0x000000122e2e7220ULL, 0x080fe20000410000ULL, 0x000000122f2f7220ULL, 0x080fe20000410000ULL,
0x000000122a2a7220ULL, 0x080fe20000410000ULL, 0x000000122b2b7220ULL, 0x080fe20000410000ULL,
0x0000001226267220ULL, 0x080fe20000410000ULL, 0x0000001227277220ULL, 0x080fe20000410000ULL,
0x0000001222227220ULL, 0x080fe20000410000ULL, 0x0000001223237220ULL, 0x080fe20000410000ULL,
0x000000121e1e7220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x000000121a1a7220ULL, 0x080fe20000410000ULL, 0x000000121b1b7220ULL, 0x080fe20000410000ULL,
0x0000001216167220ULL, 0x080fe20000410000ULL, 0x0000001217177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fe2000780600fULL,
0x00000001ff127424ULL, 0x000fe200078e00ffULL, 0x000000103b0f7209ULL, 0x000fd60007810000ULL,
0x8000000f3b3b0221ULL, 0x000fe20000010000ULL, 0x00007610ff120816ULL, 0x000fc60000000012ULL,
0x3fb8aa3b3b3b0820ULL, 0x000fc80000410000ULL, 0x0000003b00050308ULL, 0x000e640000000800ULL,
0x000000053a3a0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000113a117221ULL, 0x004fc20000010000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x000000080e107824ULL, 0x000fca00078e00ffULL, 0xfffffff0103c7812ULL, 0x000fca00078ec0ffULL,
0x00f6ac003c3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe40007804839ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x008fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a363d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e37ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc8000001143bULL,
0x0000003d10107211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x0000000210107819ULL, 0x000fc8000000123bULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac003c3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991012107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff03723eULL, 0x000fe400000010ffULL, 0x00000002ff397819ULL, 0x000fe4000001160dULL,
0x0000541003107816ULL, 0x000fe20000000003ULL, 0x0000c3527f007947ULL, 0x000fea000b800000ULL,
0x00001f3910047589ULL, 0x0002a400000e0000ULL, 0x0000000839127810ULL, 0x000fe20007ffe0ffULL,
0x0000c3827f007947ULL, 0x000fea000b800000ULL, 0x00001f1210037589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001039127810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff367224ULL, 0x000fe200078e0010ULL, 0x00008af000377802ULL, 0x000fc40000000f00ULL,
0x0000c9d000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001839127810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x00008b4000377802ULL, 0x000fc40000000f00ULL, 0x0000c98000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000104c387824ULL, 0x100fe200078e0254ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000010133c7824ULL, 0x100fe200078e0254ULL,
0x000000070d127812ULL, 0x00cfe200078ec0ffULL, 0x000000104f4f7824ULL, 0x000fc400078e0254ULL,
0x000000003838783bULL, 0x002e620000004200ULL, 0x0000000812137812ULL, 0x000fc600078ef80dULL,
0x000000003c3c783bULL, 0x000ea20000004200ULL, 0x000000ff38107812ULL, 0x002fe400078ec0ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011638ULL, 0x00000010ff647819ULL, 0x104fe4000001163dULL,
0x000000ff3d6b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d657812ULL, 0x000fe200078ec0ffULL, 0x00000008133d7824ULL, 0x000fe200078e00ffULL,
0x00000010ff4c723eULL, 0x000fc400020006ffULL, 0x0000000252107810ULL, 0x000fe40007ffe0ffULL,
0x00000010ff497819ULL, 0x100fe4000001163cULL, 0x000000ff3c697812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c5e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff83d107812ULL, 0x000fe200078ee210ULL, 0x000000104e3d7824ULL, 0x000fe200078e0254ULL,
0x0000004bff3c723eULL, 0x000fe200020006ffULL, 0x2000004cff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff587819ULL, 0x000fc40000011638ULL, 0x0000ffff38407812ULL, 0x000fe200078ec0ffULL,
0x2000003cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x100fe40000011639ULL,
0x000000ff395a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe40000011639ULL,
0x0000ffff39447812ULL, 0x000fe400078ec0ffULL, 0x00000010ff367819ULL, 0x000fc4000001163aULL,
0x000000ff3a4a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001163aULL,
0x0000ffff3a377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x100fe4000001163bULL,
0x000000ff3b6d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff667819ULL, 0x000fc4000001163bULL,
0x0000ffff3b677812ULL, 0x000fe400078ec0ffULL, 0x00a000004d38783bULL, 0x0002a20000000200ULL,
0x00000010ff477819ULL, 0x100fe4000001163eULL, 0x000000ff3e457812ULL, 0x040fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe4000001163eULL, 0x0000ffff3e127812ULL, 0x000fe400078ec0ffULL,
0x00000010ff137819ULL, 0x000fc4000001163fULL, 0x000000ff3f487812ULL, 0x040fe400078ec0ffULL,
0x00000018ff437819ULL, 0x000fe4000001163fULL, 0x0000ffff3f467812ULL, 0x000fe400078ec0ffULL,
0x000000003d3c783bULL, 0x000ee20000004200ULL, 0x00000059ff4d723eULL, 0x002fe400020006ffULL,
0x0000004aff59723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff58587812ULL, 0x000fc400078ec0ffULL,
0x000000ff414a7812ULL, 0x000fe200078ec0ffULL, 0x2000005aff4e7230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000008ff417819ULL, 0x000fe20000011640ULL,
0x20000059ff407230ULL, 0x000fe20000004100ULL, 0x00000008ff447819ULL, 0x000fe20000011644ULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x000000ff365a7812ULL, 0x000fc400078ec0ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000044ff59723eULL, 0x000fe200020006ffULL, 0x2000004aff447230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000041ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe2000001164bULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff4b7819ULL, 0x000fe2000001164eULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe20000011658ULL, 0x0000000438388231ULL, 0x084fe200003400ffULL,
0x00000010ff447819ULL, 0x000fe20000011644ULL, 0x000000043a3a8231ULL, 0x000fe200003400ffULL,
0x00001054414a7816ULL, 0x000fe2000000004aULL, 0x0000000339398231ULL, 0x080fe200003400ffULL,
0x00001054444b7816ULL, 0x000fe2000000004bULL, 0x000000033b3b8231ULL, 0x000fe200003400ffULL,
0x00000010ff417819ULL, 0x000fc4000001164cULL, 0x00000010ff447819ULL, 0x000fe4000001164dULL,
0x00000010ff367819ULL, 0x000fe40000011636ULL, 0x00000010ff4c7819ULL, 0x000fe20000011640ULL,
0x0000004a3830723cULL, 0x000be20000041830ULL, 0x00000010ff4d7819ULL, 0x000fe4000001165aULL,
0x0000105441407816ULL, 0x000fe40000000036ULL, 0x000000ff68687812ULL, 0x000fc400078ec0ffULL,
0x000010544d367816ULL, 0x000fe4000000004cULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff5c7819ULL, 0x108fe4000001163dULL, 0x000000ff3d4c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d5d7812ULL, 0x000fc400078ec0ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000069ff3d723eULL, 0x000fe200020006ffULL, 0x20000066ff697230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x0000105444417816ULL, 0x000fe20000000059ULL,
0x2000003dff667230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fe2000001163cULL,
0x20000068ff3d7230ULL, 0x000fe20000004100ULL, 0x000000ff3c447812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4b7819ULL, 0x020fe4000001163cULL, 0x0000ffff3c5b7812ULL, 0x000fe200078ec0ffULL,
0x2000006dff3c7230ULL, 0x000fe20000004100ULL, 0x0000006aff4a723eULL, 0x000fe400020006ffULL,
0x00000008ff6a7819ULL, 0x000fe40000011637ULL, 0x00000010ff377819ULL, 0x000fe2000001163cULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fc4000001163dULL,
0x00000010ff5a7819ULL, 0x100fe4000001163eULL, 0x000000ff3e607812ULL, 0x040fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001163eULL, 0x0000ffff3e4d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff587819ULL, 0x000fe4000001163fULL, 0x000000ff3f637812ULL, 0x000fc400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe4000001163fULL, 0x0000ffff3f4e7812ULL, 0x000fe400078ec0ffULL,
0x000010543c377816ULL, 0x000fe40000000037ULL, 0x00000040383c723cULL, 0x000b62000004182cULL,
0x00000008ff677819ULL, 0x000fe20000011667ULL, 0x000000004f2c783bULL, 0x0202a20000004200ULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fc400020006ffULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006bff687230ULL, 0x000fe20000004100ULL,
0x000000ff49407812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6d7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff64647812ULL, 0x000fe200078ec0ffULL, 0x000000363828723cULL, 0x000b620000041828ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x00000064ff6b723eULL, 0x000fe200020006ffULL,
0x2000006cff497230ULL, 0x000fe20000004100ULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x20000040ff4f7230ULL, 0x002fe20000004100ULL, 0x00000008ff647819ULL, 0x000fe20000011665ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6c7819ULL, 0x000fe40000011669ULL, 0x00000010ff407819ULL, 0x000fc4000001166aULL,
0x00000010ff417819ULL, 0x000fe40000011667ULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x000010546d407816ULL, 0x000fe20000000040ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000010546c417816ULL, 0x000fe20000000041ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x020fc40000011666ULL,
0x00000010ff377819ULL, 0x000fe40000011668ULL, 0x00000010ff4f7819ULL, 0x000fe2000001164fULL,
0x000000403824723cULL, 0x000b620000041824ULL, 0x00000010ff667819ULL, 0x000fe4000001166bULL,
0x000010544f367816ULL, 0x000fe40000000036ULL, 0x0000105466377816ULL, 0x000fe40000000037ULL,
0x000000ff47477812ULL, 0x000fc400078ec0ffULL, 0x00000010ff417819ULL, 0x020fe4000001164aULL,
0x00000010ff407819ULL, 0x000fe20000011649ULL, 0x000000363820723cULL, 0x000b620000041820ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff497819ULL, 0x000fe40000011664ULL,
0x00000045ff64723eULL, 0x000fe400020006ffULL, 0x000000ff2e6c7812ULL, 0x004fc400078ec0ffULL,
0x00000048ff68723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000105441487816ULL, 0x000fe4000000005eULL,
0x0000105440497816ULL, 0x000fe20000000049ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc4000001162eULL, 0x00000018ff367819ULL, 0x020fe4000001162eULL,
0x0000ffff2e457812ULL, 0x000fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff677819ULL, 0x100fe4000001162dULL, 0x000000ff2d6f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fc4000001162dULL, 0x0000ffff2d4f7812ULL, 0x000fe200078ec0ffULL,
0x20000064ff2d7230ULL, 0x000fe20000004100ULL, 0x00000010ff4a7819ULL, 0x100fe2000001162fULL,
0x2000004bff647230ULL, 0x000fe20000004100ULL, 0x000000ff2f6d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001162fULL, 0x0000ffff2f407812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000063ff2f723eULL, 0x000fe200020006ffULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000060ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff467819ULL, 0x000fe20000011646ULL, 0x2000002fff607230ULL, 0x000fe20000004100ULL,
0x00000061ff4b723eULL, 0x000fe200020006ffULL, 0x2000004cff697230ULL, 0x000fe20000004100ULL,
0x00000036ff61723eULL, 0x000fe200020006ffULL, 0x2000006cff367230ULL, 0x000fe20000004100ULL,
0x00000046ff6c723eULL, 0x000fe200020006ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x000000ff132f7812ULL, 0x000fe200078ec0ffULL, 0x20000061ff137230ULL, 0x000fe20000004100ULL,
0x00000010ff2d7819ULL, 0x000fe2000001162dULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fc40000011647ULL, 0x00000062ff4c723eULL, 0x000fe400020006ffULL,
0x0000002eff62723eULL, 0x000fe400020006ffULL, 0x00000008ff2e7819ULL, 0x000fe20000011612ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000002fff2f723eULL, 0x000fe200020006ffULL,
0x20000062ff127230ULL, 0x000fe20000004100ULL, 0x0000105446467816ULL, 0x000fe2000000002dULL,
0x000002000e2d7824ULL, 0x000fe200078e00ffULL, 0x00000010ff657819ULL, 0x000fc4000001162cULL,
0x000000ff2c6e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff377819ULL, 0x000fe4000001162cULL,
0x0000ffff2c667812ULL, 0x000fe200078ec0ffULL, 0x20000068ff2c7230ULL, 0x000fe20000004100ULL,
0x0000002eff62723eULL, 0x000fe200020006ffULL, 0x2000002fff2e7230ULL, 0x000fe20000004100ULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0xfffff8002d2d7812ULL, 0x000fe200078ec0ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000059ff2f723eULL, 0x000fc400020006ffULL,
0x00000008ff617819ULL, 0x000fe2000001165dULL, 0x00000010105d7824ULL, 0x000fe200078e022dULL,
0x00000010ff2c7819ULL, 0x000fe4000001162cULL, 0x00000010ff477819ULL, 0x000fe4000001162eULL,
0x00000008ff597819ULL, 0x000fe4000001165bULL, 0x000000ff5c5b7812ULL, 0x000fe200078ec0ffULL,
0x2000002fff5c7230ULL, 0x000fe20000004100ULL, 0x0000105447477816ULL, 0x000fc4000000002cULL,
0x00000048382c723cULL, 0x040b62000004181cULL, 0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL,
0x00a000005d1c783bULL, 0x0202a20000000200ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x000000ff58587812ULL, 0x000fe400078ec0ffULL, 0x0000005aff48723eULL, 0x000fe200020006ffULL,
0x2000005bff5a7230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x000000463818723cULL, 0x000b620000041818ULL, 0x00000008ff4e7819ULL, 0x000fe2000001164eULL,
0x20000048ff5b7230ULL, 0x000fe20000004100ULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x20000042ff6a7230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x000000ff65657812ULL, 0x000fe200078ec0ffULL, 0x20000043ff6b7230ULL, 0x000fe20000004100ULL,
0x0000004eff48723eULL, 0x000fe200020006ffULL, 0x20000058ff5d7230ULL, 0x002fe20000004100ULL,
0x000000ff67497812ULL, 0x000fe400078ec0ffULL, 0x00000065ff67723eULL, 0x000fe200020006ffULL,
0x20000048ff587230ULL, 0x000fe20000004100ULL, 0x00000049ff65723eULL, 0x000fe400020006ffULL,
0x00000010ff497819ULL, 0x000fc4000001166aULL, 0x00000010ff487819ULL, 0x000fe40000011662ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x0000105449487816ULL, 0x000fe20000000048ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000010546b497816ULL, 0x000fe2000000006cULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x000000041c1c8231ULL, 0x084fe200003400ffULL,
0x00000008ff4d7819ULL, 0x000fe2000001164dULL, 0x000000041e1e8231ULL, 0x000fe200003400ffULL,
0x00000010ff617819ULL, 0x000fe20000011661ULL, 0x000000483814723cULL, 0x000b620000041814ULL,
0x20000044ff687230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x000000031d1d8231ULL, 0x080fe200003400ffULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x000000031f1f8231ULL, 0x000fe200003400ffULL, 0x00000010ff467819ULL, 0x020fe20000011668ULL,
0x2000004dff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe20000011664ULL,
0x20000067ff4d7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fc40000011659ULL,
0x00000010ff3a7819ULL, 0x000fe40000011663ULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x000010543a397816ULL, 0x000fe40000000061ULL, 0x00000066ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff477819ULL, 0x000fe2000001165cULL, 0x20000065ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x000000381c3c723cULL, 0x000b62000004183cULL,
0x00000010ff667819ULL, 0x000fe2000001165aULL, 0x20000062ff5a7230ULL, 0x000fe20000004100ULL,
0x0000105447467816ULL, 0x000fc40000000046ULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x0000105466477816ULL, 0x000fe40000000069ULL, 0x00000010ff3a7819ULL, 0x000fe4000001165fULL,
0x00000010ff3b7819ULL, 0x000fe40000011660ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x000000461c30723cULL, 0x000b620000041830ULL, 0x00000010ff487819ULL, 0x000fc4000001165dULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff387819ULL, 0x020fe4000001164eULL, 0x00000010ff397819ULL, 0x000fe40000011658ULL,
0x0000006eff43723eULL, 0x000fe400020006ffULL, 0x0000006fff44723eULL, 0x000fc400020006ffULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000041ff42723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000037ff417230ULL, 0x000fe20000004100ULL,
0x000010545b3a7816ULL, 0x000fe2000000003aULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00001054483b7816ULL, 0x000fe2000000003bULL, 0x2000004fff477230ULL, 0x000fe20000004100ULL,
0x000010544b387816ULL, 0x000fc40000000038ULL, 0x000010544c397816ULL, 0x000fe40000000039ULL,
0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL, 0x0000003a1c28723cULL, 0x040b620000041828ULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff457819ULL, 0x000fe40000011645ULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff3a7819ULL, 0x020fe20000011643ULL,
0x000000381c24723cULL, 0x000b620000041824ULL, 0x00000010ff3b7819ULL, 0x000fc40000011644ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff417819ULL, 0x000fe40000011641ULL, 0x00000010ff387819ULL, 0x020fe4000001165aULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff397819ULL, 0x000fc40000011647ULL,
0x0000006dff37723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000005eff467230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x000010544d3a7816ULL, 0x000fe2000000003aULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x000010545c3b7816ULL, 0x000fe2000000003bULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x0000105441387816ULL, 0x000fc40000000038ULL, 0x0000105442397816ULL, 0x000fe40000000039ULL,
0x00000010ff367819ULL, 0x000fe20000011636ULL, 0x0000003a1c20723cULL, 0x040b620000041820ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff3b7819ULL, 0x020fe20000011646ULL,
0x000000381c2c723cULL, 0x000b62000004182cULL, 0x00000010ff127819ULL, 0x000fc40000011612ULL,
0x000010543b367816ULL, 0x000fe40000000036ULL, 0x000010544a377816ULL, 0x000fe40000000037ULL,
0x00000010ff387819ULL, 0x020fe40000011613ULL, 0x00000010ff397819ULL, 0x000fe40000011640ULL,
0x0000105438387816ULL, 0x000fe20000000045ULL, 0x000000361c18723cULL, 0x000f620000041818ULL,
0x0000105412397816ULL, 0x000fc40000000039ULL, 0x0000f6c808127811ULL, 0x000fca00078e18ffULL,
0x000000381c14723cULL, 0x000b6e0000041814ULL, 0x0000f698561c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000001cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff367224ULL, 0x000fc600078e00ffULL, 0x00000000001c7805ULL, 0x004fc80000015200ULL,
0x00000400061f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fc40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c377210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000371e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400061f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000107137810ULL, 0x000fc80007ffe0ffULL,
0x0000000a1300720cULL, 0x000fda0003f06070ULL, 0x0000079000000947ULL, 0x000fea0003800000ULL,
0x0000000207137810ULL, 0x000fe20007ffe0ffULL, 0x0000590009067a24ULL, 0x010fe200078e02ffULL,
0x00000100001d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a1300720cULL, 0x000fe20003f06070ULL,
0x00000080ff137424ULL, 0x000fe200078e00ffULL, 0x000000601d007812ULL, 0x000fe200078ec0ffULL,
0x0000008006067824ULL, 0x000fc800078e00ffULL, 0x0000000153387824ULL, 0x000fe400078e0200ULL,
0x0000620006127625ULL, 0x000fc800078e0013ULL, 0x000003e000008947ULL, 0x000fea0003800000ULL,
0x0000001d0c007217ULL, 0x000fe20007800000ULL, 0x000000100e067824ULL, 0x000fc800078e00ffULL,
0x0000000100007824ULL, 0x000fe200078e0a1dULL, 0x00000010061d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff067819ULL, 0x000fe4000001160dULL, 0x000000001d007217ULL, 0x000fe40007800000ULL,
0x00000004061c7810ULL, 0x040fe40007ffe0ffULL, 0x00000008061e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a1dULL, 0x0000000c061f7810ULL, 0x000fc60007ffe0ffULL,
0x000000011e397824ULL, 0x100fe200078e021dULL, 0x000000001c00720cULL, 0x0c0fe20003f66070ULL,
0x000000011c1c7824ULL, 0x100fe200078e021dULL, 0x000000000600720cULL, 0x0c0fe20003f86070ULL,
0x0000000106067824ULL, 0x000fe200078e021dULL, 0x000000001e00720cULL, 0x080fe20003f46070ULL,
0x000000011c367824ULL, 0x100fe200078e0238ULL, 0x000000001f00720cULL, 0x000fe20003f06070ULL,
0x00000001061e7824ULL, 0x000fe400078e0238ULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000011f3a7824ULL, 0x000fe400078e021dULL, 0x0000000106007824ULL, 0x140fe400078e020dULL,
0x0000000806437824ULL, 0x000fe400078e00ffULL, 0x000000011c067824ULL, 0x140fe400078e020dULL,
0x000000081c457824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee200ULL,
0x00000001391d7824ULL, 0x000fc400078e020dULL, 0x0000000839407824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee206ULL, 0x000000801e1e7825ULL, 0x000fc600078e00ffULL,
0xfffffff840477812ULL, 0x000fe200078ee21dULL, 0x00000001391c7824ULL, 0x100fe200078e0238ULL,
0x0000005136397212ULL, 0x080fe200078efcffULL, 0x000000013a387824ULL, 0x000fe200078e0238ULL,
0x000000511e3b7212ULL, 0x000fe200078efcffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000003912367210ULL, 0x040fe40007fde0ffULL, 0x0000003b121e7210ULL, 0x000fe20007fbe0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x000000511c417212ULL, 0x000fc600078efcffULL,
0x000000013a007824ULL, 0x000fe200078e020dULL, 0x00000051383b7212ULL, 0x000fe200078efcffULL,
0x000000083a497824ULL, 0x000fe400078e00ffULL, 0x00000001131f7824ULL, 0x040fe200028e061fULL,
0x00000041121c7210ULL, 0x040fe20007fbe0ffULL, 0x0000000113377824ULL, 0x000fe200030e0637ULL,
0xfffffff849497812ULL, 0x000fe200078ee200ULL, 0x0000001043437824ULL, 0x100fe200078e0254ULL,
0x0000003b12127210ULL, 0x000fe20007fde0ffULL, 0x0000001045457824ULL, 0x000fc400078e0254ULL,
0x0000001047477824ULL, 0x100fe200078e0254ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e437faeULL, 0x0003e2000e101c48ULL, 0x00000001131d7824ULL, 0x000fe400028e061dULL,
0x0000001049497824ULL, 0x000fe200078e0254ULL, 0x0000000036457faeULL, 0x0003e2000d901c48ULL,
0x0000000113137824ULL, 0x000fc600030e0639ULL, 0x000000001c477faeULL, 0x0003e8000d101c48ULL,
0x0000000012497faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x000000100e007824ULL, 0x000fca00078e00ffULL, 0x0000001000007812ULL, 0x000fc800078ec0ffULL,
0x000000000d007211ULL, 0x000fc800078fe8ffULL, 0x00000004001f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100067824ULL, 0x040fe200078e020dULL, 0x0000000c00397810ULL, 0x040fe20007ffe0ffULL,
0x00000008003b7824ULL, 0x040fe400078e00ffULL, 0x00000001001c7824ULL, 0x100fe400078e0238ULL,
0x000000011f1e7824ULL, 0x000fe200078e0238ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee206ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000800067810ULL, 0x000fc60007ffe0ffULL,
0x000000011f007824ULL, 0x140fe400078e020dULL, 0x000000081f417824ULL, 0x000fe200078e00ffULL,
0x000000511c1f7212ULL, 0x000fe200078efcffULL, 0x0000000106377824ULL, 0x040fe400078e020dULL,
0x00000008063a7824ULL, 0x000fe200078e00ffULL, 0x0000001f121c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000106367824ULL, 0x000fe200078e0238ULL, 0xfffffff841417812ULL, 0x000fe200078ee200ULL,
0x0000000139387824ULL, 0x000fe200078e0238ULL, 0xfffffff83a497812ULL, 0x000fe200078ee237ULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x0000000139067824ULL, 0x040fe200078e020dULL,
0x000000511e437212ULL, 0x000fe200078efcffULL, 0x00000008394b7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee206ULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x0000001041477824ULL, 0x100fe200078e0254ULL,
0x0000005136417212ULL, 0x080fe200078efcffULL, 0x000000103b457824ULL, 0x100fe200078e0254ULL,
0x00000051383b7212ULL, 0x000fe200078efcffULL, 0x00000001131d7824ULL, 0x000fe200000e061dULL,
0x00000043121e7210ULL, 0x040fe20007f1e0ffULL, 0x0000001049497824ULL, 0x100fe200078e0254ULL,
0x0000004112367210ULL, 0x040fe20007f5e0ffULL, 0x000000104b4b7824ULL, 0x000fe200078e0254ULL,
0x0000003b12127210ULL, 0x000fe20007f7e0ffULL, 0x00000001131f7824ULL, 0x040fe200000e061fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c457faeULL, 0x0003e2000b901c48ULL,
0x0000000113377824ULL, 0x000fc400010e0637ULL, 0x0000000113137824ULL, 0x000fe200018e0639ULL,
0x000000001e477faeULL, 0x0003e8000b901c48ULL, 0x0000000036497faeULL, 0x0003e8000b901c48ULL,
0x00000000124b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001008137824ULL, 0x002fc400078e00ffULL, 0x000000080e007824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x0000001013137812ULL, 0x000fe400078ee2ffULL,
0x0000000800007812ULL, 0x000fc600078ec0ffULL, 0x0000002056137824ULL, 0x000fc800078e0213ULL,
0x0000000100007824ULL, 0x000fe200078e0213ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a80073127f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f66800001c7f8cULL, 0x000664000c80043fULL,
0x00000000001e7805ULL, 0x000fc40000015200ULL, 0x00f66c0000377984ULL, 0x000ee40000000800ULL,
0x8000000037ff7812ULL, 0x00afe4000780481dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x004fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x000000361e397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e1fULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011437ULL, 0x0000003906067211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000206067819ULL, 0x000fc80000001237ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c0000377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018056007811ULL, 0x000fc800078e38ffULL,
0x0000000057007210ULL, 0x000fca0007ffe051ULL, 0x00f0000000067984ULL, 0x000e680000000800ULL,
0x00f20000001c7984ULL, 0x0004e20000000800ULL, 0x0000000f0600720bULL, 0x002fe20003f1d000ULL,
0x00009db27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000127806ULL, 0x004fc800000e0100ULL,
0x0000ffff121f7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff127424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fd200078e000fULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000003561d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0600720bULL, 0x000fe40003f54000ULL, 0x0000000e1d00720cULL, 0x000fe20003f05270ULL,
0x00009d527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000007806ULL, 0x000fc400010e0100ULL,
0x000000800e1e8824ULL, 0x000fe200078e0251ULL, 0x0000000f06128209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x00009910001d7816ULL, 0x000fe200000000ffULL,
0x0000000157578824ULL, 0x000fca00078e021eULL, 0x00f4001257008388ULL, 0x0003e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000f06127209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff00ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000f12127221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL, 0x00000012001e7308ULL, 0x000e640000000800ULL,
0x0000001e11117220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff127819ULL, 0x000fe2000001160dULL, 0x00009c727f007947ULL, 0x000fea000b800000ULL,
0x00001f121e127589ULL, 0x0002a400000e0000ULL, 0x0000001230307220ULL, 0x084fe20000410000ULL,
0x0000001231317220ULL, 0x080fe20000410000ULL, 0x000000123c3c7220ULL, 0x080fe20000410000ULL,
0x000000123d3d7220ULL, 0x080fe20000410000ULL, 0x0000001228287220ULL, 0x080fe20000410000ULL,
0x0000001229297220ULL, 0x080fe20000410000ULL, 0x0000001224247220ULL, 0x080fe20000410000ULL,
0x0000001225257220ULL, 0x080fe20000410000ULL, 0x0000001220207220ULL, 0x080fe20000410000ULL,
0x0000001221217220ULL, 0x080fe20000410000ULL, 0x000000122c2c7220ULL, 0x080fe20000410000ULL,
0x000000122d2d7220ULL, 0x080fe20000410000ULL, 0x0000001218187220ULL, 0x080fe20000410000ULL,
0x0000001219197220ULL, 0x080fe20000410000ULL, 0x0000001214147220ULL, 0x080fe20000410000ULL,
0x0000001215157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0000ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d127811ULL, 0x000fe200078ff0ffULL, 0x00009b527f007947ULL, 0x000fea000b800000ULL,
0x00001f121e127589ULL, 0x00046400000e0000ULL, 0x0000001232327220ULL, 0x086fe20000410000ULL,
0x0000001233337220ULL, 0x080fe20000410000ULL, 0x000000123e3e7220ULL, 0x080fe20000410000ULL,
0x000000123f3f7220ULL, 0x080fe20000410000ULL, 0x000000122a2a7220ULL, 0x080fe20000410000ULL,
0x000000122b2b7220ULL, 0x080fe20000410000ULL, 0x0000001226267220ULL, 0x080fe20000410000ULL,
0x0000001227277220ULL, 0x080fe20000410000ULL, 0x0000001222227220ULL, 0x080fe20000410000ULL,
0x0000001223237220ULL, 0x080fe20000410000ULL, 0x000000122e2e7220ULL, 0x080fe20000410000ULL,
0x000000122f2f7220ULL, 0x080fe20000410000ULL, 0x000000121a1a7220ULL, 0x080fe20000410000ULL,
0x000000121b1b7220ULL, 0x080fe20000410000ULL, 0x0000001216167220ULL, 0x080fe20000410000ULL,
0x0000001217177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff1fff7812ULL, 0x000fe20007806000ULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x0000000f06007209ULL, 0x000fd60007810000ULL, 0x8000000006060221ULL, 0x000fe20000010000ULL,
0x00007610ff120816ULL, 0x000fc60000000012ULL, 0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL,
0x0000000600050308ULL, 0x000e640000000800ULL, 0x000000051c1c0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000111c117221ULL, 0x008fc40000010000ULL,
0x00000000001c7805ULL, 0x000fca0000015200ULL, 0x00f6b400730f7984ULL, 0x000e620000000800ULL,
0x000000040e067824ULL, 0x000fca00078e00ffULL, 0x0000000406367812ULL, 0x000fe200078ec0ffULL,
0x000000ffff067224ULL, 0x000fc600078e00ffULL, 0x0000000236367810ULL, 0x000fe40007ffe0ffULL,
0x800000000fff7812ULL, 0x002fe20007804835ULL, 0x00000004750f7824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000023000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000fULL, 0x000000ffff387224ULL, 0x000fe200078e0036ULL,
0x000001f000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c377210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000371e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6b400731f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000fULL, 0x000000ffff387224ULL, 0x000fc400078e0036ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991012067816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff03723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe4000001160dULL, 0x0000541003067816ULL, 0x000fe20000000003ULL,
0x000096827f007947ULL, 0x000fea000b800000ULL, 0x00001f0f06047589ULL, 0x0002a400000e0000ULL,
0x000000080f127810ULL, 0x000fe20007ffe0ffULL, 0x000096b27f007947ULL, 0x000fea000b800000ULL,
0x00001f1206037589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f127810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff367224ULL, 0x000fe200078e0006ULL,
0x0000b98000377802ULL, 0x000fc40000000f00ULL, 0x00009b4000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f127810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff367224ULL, 0x000fe200078e0006ULL, 0x0000b9d000377802ULL, 0x000fc40000000f00ULL,
0x00009af000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070d377812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000356577810ULL, 0x000fc40007ffe0ffULL, 0x0000000837067812ULL, 0x00afe400078ef80dULL,
0x000000080d367812ULL, 0x000fe200078ec0ffULL, 0x0000080057577824ULL, 0x000fe400078e00ffULL,
0x00000008060f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f527812ULL, 0x000fca00078ee252ULL,
0x00000010520f7824ULL, 0x000fc400078e0257ULL, 0x0000001e0d127211ULL, 0x044fe200078fe0ffULL,
0x0000001010577824ULL, 0x000fe200078e0257ULL, 0x0000003736357212ULL, 0x040fe400078efcffULL,
0x000000380d347211ULL, 0x000fe400078fe0ffULL, 0x0000001036377812ULL, 0x000fe200078efe37ULL,
0x0000000135067824ULL, 0x040fe400078e0212ULL, 0x00000008351d7824ULL, 0x000fe400078e00ffULL,
0x0000000837417824ULL, 0x000fc600078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x0000000135067824ULL, 0x040fe400078e0234ULL, 0x0000000835357824ULL, 0x000fe400078e00ffULL,
0x000000101d1d7824ULL, 0x000fc600078e0202ULL, 0xfffffff835357812ULL, 0x000fe200078ee206ULL,
0x0000000137067824ULL, 0x000fe400078e0212ULL, 0x000000001d1c783bULL, 0x000e640000004200ULL,
0x0000001035387824ULL, 0x000fe400078e0202ULL, 0x0000000837357824ULL, 0x000fc800078e00ffULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0xfffffff835357812ULL, 0x000fe200078ee206ULL,
0x0000000137067824ULL, 0x000fc800078e0234ULL, 0x0000001035357824ULL, 0x000fe200078e0202ULL,
0xfffffff841417812ULL, 0x000fca00078ee206ULL, 0x000000003534783bULL, 0x000ee20000004200ULL,
0x0000001041447824ULL, 0x000fe200078e0202ULL, 0x00000010ff607819ULL, 0x102fe4000001161cULL,
0x000000ff1c127812ULL, 0x040fe400078ec0ffULL, 0x00000018ff107819ULL, 0x000fe4000001161cULL,
0x0000ffff1c4c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff1d1c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001161dULL, 0x000000ff1e6c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x104fe4000001163aULL, 0x000000ff3a5b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe4000001163aULL, 0x0000ffff3a657812ULL, 0x000fc400078ec0ffULL,
0x00000010ff6b7819ULL, 0x100fe4000001163bULL, 0x000000ff3b5a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff457819ULL, 0x000fe4000001161dULL, 0x0000ffff1d4d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff597819ULL, 0x100fe4000001161eULL, 0x00000018ff697819ULL, 0x000fe4000001161eULL,
0x0000ffff1e407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff417819ULL, 0x100fe4000001161fULL,
0x000000ff1f6d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fc4000001161fULL,
0x0000ffff1f067812ULL, 0x000fe400078ec0ffULL, 0x00000012ff3b723eULL, 0x000fe400020006ffULL,
0x0000001cff3a723eULL, 0x000fe400020006ffULL, 0x009000000f1c783bULL, 0x000e620000000200ULL,
0x00000010ff5f7819ULL, 0x108fe20000011634ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x000000ff34497812ULL, 0x000fe200078ec0ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x00000018ff127819ULL, 0x000fc40000011634ULL, 0x0000ffff344b7812ULL, 0x000fe400078ec0ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x0000006cff34723eULL, 0x000fe400020006ffULL,
0x00000010ff027819ULL, 0x100fe40000011638ULL, 0x000000ff38637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fc40000011638ULL, 0x0000ffff38547812ULL, 0x000fe400078ec0ffULL,
0x00000069ff38723eULL, 0x000fe200020006ffULL, 0x20000061ff697230ULL, 0x000fe20000004100ULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x20000034ff617230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x000000ff59347812ULL, 0x000fe400078ec0ffULL, 0x00000060ff6c723eULL, 0x000fe200020006ffULL,
0x2000006dff607230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fc40000011639ULL,
0x000000ff395d7812ULL, 0x040fe200078ec0ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000018ff5c7819ULL, 0x000fe40000011639ULL, 0x0000ffff396a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff68723eULL, 0x000fe200020006ffULL, 0x000000041c1c8231ULL, 0x082fe200003400ffULL,
0x00000010ff5e7819ULL, 0x100fe20000011635ULL, 0x000000041e1e8231ULL, 0x000fe200003400ffULL,
0x000000ff35477812ULL, 0x040fe200078ec0ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000018ff427819ULL, 0x000fe20000011635ULL, 0x000000031d1d8231ULL, 0x080fe200003400ffULL,
0x0000ffff35517812ULL, 0x000fe200078ec0ffULL, 0x000000031f1f8231ULL, 0x000fe200003400ffULL,
0x00000010ff4a7819ULL, 0x000fc40000011636ULL, 0x000000ff36437812ULL, 0x040fe400078ec0ffULL,
0x00000018ff0f7819ULL, 0x000fe40000011636ULL, 0x0000ffff36397812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x100fe40000011637ULL, 0x000000ff37467812ULL, 0x000fe400078ec0ffULL,
0x00000018ff107819ULL, 0x000fc40000011637ULL, 0x0000ffff37587812ULL, 0x000fe400078ec0ffULL,
0x00000034ff6d723eULL, 0x000fe400020006ffULL, 0x000000004434783bULL, 0x000e620000004200ULL,
0x000000ff45457812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x0000004dff59723eULL, 0x000fc400020006ffULL,
0x00000008ff4c7819ULL, 0x000fe2000001164cULL, 0x20000045ff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff416e7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff417230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x2000006dff457230ULL, 0x000fe20000004100ULL,
0x00000008ff597819ULL, 0x000fe40000011640ULL, 0x00000010ff407819ULL, 0x000fe2000001163aULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fc4000001163bULL,
0x00000010ff3a7819ULL, 0x000fe4000001166cULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x000010543a3a7816ULL, 0x000fe4000000003bULL, 0x000010544d3b7816ULL, 0x000fe40000000040ULL,
0x00000010ff4d7819ULL, 0x000fe40000011668ULL, 0x00000010ff687819ULL, 0x000fc40000011669ULL,
0x00000010ff407819ULL, 0x000fe2000001164cULL, 0x0000003a1c30723cULL, 0x000b620000041830ULL,
0x00000010ff417819ULL, 0x000fe40000011641ULL, 0x000010544d407816ULL, 0x000fe40000000040ULL,
0x0000105468417816ULL, 0x000fe40000000041ULL, 0x00000010ff3a7819ULL, 0x020fe40000011661ULL,
0x00000010ff457819ULL, 0x000fc40000011645ULL, 0x000000ff37707812ULL, 0x002fe200078ec0ffULL,
0x000000401c3c723cULL, 0x000b62000004183cULL, 0x00001054453a7816ULL, 0x000fe4000000003aULL,
0x00000010ff457819ULL, 0x100fe40000011637ULL, 0x00000018ff6d7819ULL, 0x000fe40000011637ULL,
0x0000ffff37417812ULL, 0x020fe400078ec0ffULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x0000005aff37723eULL, 0x000fe400020006ffULL, 0x00000018ff6c7819ULL, 0x000fe20000011636ULL,
0x2000005bff5a7230ULL, 0x000fe20000004100ULL, 0x00000008ff067819ULL, 0x000fe20000011606ULL,
0x20000037ff5b7230ULL, 0x000fe20000004100ULL, 0x0000006cff37723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x000000ff02027812ULL, 0x000fc400078ec0ffULL,
0x00000006ff6c723eULL, 0x000fe200020006ffULL, 0x20000037ff067230ULL, 0x000fe20000004100ULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x00000002ff37723eULL, 0x000fe200020006ffULL,
0x2000006dff027230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe2000001166aULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff547819ULL, 0x000fe20000011654ULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x2000006eff447230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x00000054ff6a723eULL, 0x000fe200020006ffULL,
0x20000066ff547230ULL, 0x000fe20000004100ULL, 0x00000067ff66723eULL, 0x000fc400020006ffULL,
0x0000006bff67723eULL, 0x000fe200020006ffULL, 0x2000006dff6b7230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe20000011664ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fe20000011638ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff3b7819ULL, 0x000fc40000011660ULL,
0x00000010ff447819ULL, 0x000fe20000011644ULL, 0x2000005cff697230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe40000011659ULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff607819ULL, 0x000fe20000011635ULL,
0x20000047ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff35727812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011635ULL, 0x0000ffff354c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x00000065ff64723eULL, 0x000fe400020006ffULL,
0x00000008ff4b7819ULL, 0x000fe2000001164bULL, 0x20000010ff477230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000005dff35723eULL, 0x000fc400020006ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x0000006dff65723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x000000ff366f7812ULL, 0x000fe400078ec0ffULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000000ff5e6d7812ULL, 0x000fe400078ec0ffULL,
0x00001054443b7816ULL, 0x000fc4000000003bULL, 0x000010544d387816ULL, 0x000fe40000000038ULL,
0x00000012ff12723eULL, 0x000fe400020006ffULL, 0x00000010ff4d7819ULL, 0x000fe20000011636ULL,
0x0000003a1c28723cULL, 0x000b620000041828ULL, 0x0000ffff36447812ULL, 0x000fe200078ec0ffULL,
0x20000062ff367230ULL, 0x000fe20000004100ULL, 0x00000008ff517819ULL, 0x000fe40000011651ULL,
0x0000004bff4b723eULL, 0x000fc400020006ffULL, 0x00000010ff597819ULL, 0x100fe40000011634ULL,
0x000000ff34717812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011634ULL,
0x0000ffff34617812ULL, 0x000fe200078ec0ffULL, 0x20000063ff347230ULL, 0x000fe20000004100ULL,
0x0000005fff5e723eULL, 0x000fe200020006ffULL, 0x2000004eff637230ULL, 0x000fe20000004100ULL,
0x0000006fff10723eULL, 0x000fe200020006ffULL, 0x20000012ff4e7230ULL, 0x000fe20000004100ULL,
0x0000006dff5f723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff52527812ULL, 0x000fe200078ec0ffULL, 0x20000010ff107230ULL, 0x000fe20000004100ULL,
0x000000ff4a6d7812ULL, 0x000fe200078ec0ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fc40000011639ULL, 0x00000051ff4a723eULL, 0x000fe200020006ffULL,
0x2000004bff517230ULL, 0x000fe20000004100ULL, 0x0000006eff12723eULL, 0x000fe400020006ffULL,
0x00000052ff4b723eULL, 0x000fe200020006ffULL, 0x2000004aff527230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fe20000011636ULL, 0x20000012ff127230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe4000001166cULL, 0x0000006fff36723eULL, 0x000fc400020006ffULL,
0x00000010ff347819ULL, 0x000fe40000011634ULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff6c7819ULL, 0x000fe20000011654ULL,
0x2000004bff547230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x20000036ff4b7230ULL, 0x000fe20000004100ULL, 0x000010546e397816ULL, 0x000fc40000000039ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000004fff687230ULL, 0x000fe20000004100ULL,
0x00001054373a7816ULL, 0x020fe40000000034ULL, 0x000010546c3b7816ULL, 0x000fe20000000035ULL,
0x2000006dff4a7230ULL, 0x000fe20000004100ULL, 0x009000005734783bULL, 0x000e620000000200ULL,
0x000000381c24723cULL, 0x000b620000041824ULL, 0x00000008ff6c7819ULL, 0x000fe40000011658ULL,
0x000000ff596d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff587819ULL, 0x000fe4000001166aULL,
0x00000010ff397819ULL, 0x020fe40000011668ULL, 0x00000010ff387819ULL, 0x000fe40000011669ULL,
0x00000010ff597819ULL, 0x000fe4000001166bULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x0000105439587816ULL, 0x000fc40000000058ULL, 0x0000105438597816ULL, 0x000fe20000000059ULL,
0x20000048ff627230ULL, 0x000fe20000004100ULL, 0x0000003a1c38723cULL, 0x000b620000041820ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff217819ULL, 0x020fe40000011666ULL,
0x00000010ff207819ULL, 0x000fc40000011667ULL, 0x00001054215a7816ULL, 0x000fe4000000005aULL,
0x00001054205b7816ULL, 0x000fe4000000005bULL, 0x000000581c20723cULL, 0x040b62000004182cULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000042ff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff2d7819ULL, 0x020fe20000011662ULL, 0x20000049ff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff2c7819ULL, 0x000fe20000011664ULL, 0x0000005a1c18723cULL, 0x040f620000041818ULL,
0x00000010ff2e7819ULL, 0x000fe20000011663ULL, 0x20000043ff487230ULL, 0x000fe20000004100ULL,
0x000010542d2c7816ULL, 0x000fe2000000002cULL, 0x0000000434348231ULL, 0x082fe200003400ffULL,
0x000010542e2d7816ULL, 0x000fe20000000065ULL, 0x0000000436368231ULL, 0x000fe200003400ffULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x0000000335358231ULL, 0x080fe200003400ffULL,
0x0000000fff0f723eULL, 0x000fe200020006ffULL, 0x0000000337378231ULL, 0x000fe200003400ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x0000002c1c14723cULL, 0x000b620000041814ULL,
0x20000046ff497230ULL, 0x000fe20000004100ULL, 0x000000ff60607812ULL, 0x000fe200078ec0ffULL,
0x2000000fff467230ULL, 0x000fe20000004100ULL, 0x00000010ff2e7819ULL, 0x000fe2000001165dULL,
0x2000006cff667230ULL, 0x000fe20000004100ULL, 0x00000010ff2f7819ULL, 0x000fc4000001165eULL,
0x00000010ff1d7819ULL, 0x020fe4000001164eULL, 0x00000010ff1c7819ULL, 0x000fe4000001164fULL,
0x00000010ff2c7819ULL, 0x000fe40000011651ULL, 0x00000010ff2d7819ULL, 0x000fe40000011652ULL,
0x000010541d2c7816ULL, 0x000fe4000000002cULL, 0x000010541c2d7816ULL, 0x000fc4000000002dULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff1c7819ULL, 0x000fe40000011648ULL, 0x00000010ff1d7819ULL, 0x000fe4000001164aULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff547819ULL, 0x000fc40000011654ULL,
0x00000071ff43723eULL, 0x000fe400020006ffULL, 0x00000072ff42723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000060ff59723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000010542f2e7816ULL, 0x000fe2000000002eULL, 0x2000006dff577230ULL, 0x000fe20000004100ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000010545f2f7816ULL, 0x000fc4000000005cULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x00000008ff4c7819ULL, 0x000fe4000001164cULL, 0x00001054541d7816ULL, 0x000fe20000000049ULL,
0x0000002e3430723cULL, 0x000f620000041830ULL, 0x00000010ff1f7819ULL, 0x000fe40000011646ULL,
0x00000010ff1e7819ULL, 0x000fe4000001164bULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000010ff667819ULL, 0x000fe20000011666ULL, 0x0000002c342c723cULL, 0x040f62000004183cULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000061ff58723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x000010541f1e7816ULL, 0x000fe2000000001eULL, 0x0000001c3428723cULL, 0x000b620000041828ULL,
0x00001054471f7816ULL, 0x000fe20000000066ULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff45457812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1c7819ULL, 0x020fe20000011643ULL,
0x0000001e3424723cULL, 0x000b620000041824ULL, 0x00000010ff1d7819ULL, 0x000fe40000011642ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff3c7819ULL, 0x000fe40000011659ULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000070ff0f723eULL, 0x000fc400020006ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000004dff487230ULL, 0x000fe20000004100ULL,
0x00000008ff447819ULL, 0x000fe20000011644ULL, 0x2000000fff0f7230ULL, 0x000fe20000004100ULL,
0x00001054571c7816ULL, 0x000fe2000000001cULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x000010543c1d7816ULL, 0x000fe4000000001dULL, 0x00000008ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff1f7819ULL, 0x020fc40000011640ULL, 0x00000010ff1e7819ULL, 0x000fe20000011658ULL,
0x0000001c3438723cULL, 0x000b620000041838ULL, 0x00000010ff3d7819ULL, 0x000fe40000011612ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x000010541f1e7816ULL, 0x000fe2000000001eULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x000010543d1f7816ULL, 0x000fe2000000004cULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff107819ULL, 0x000fc40000011610ULL,
0x00000010ff1d7819ULL, 0x020fe40000011648ULL, 0x00000010ff0f7819ULL, 0x000fe4000001160fULL,
0x00000010ff127819ULL, 0x000fe40000011645ULL, 0x000010541d3c7816ULL, 0x000fe40000000010ULL,
0x0000001e341c723cULL, 0x000b620000041820ULL, 0x00001054123d7816ULL, 0x000fe4000000000fULL,
0x00000010ff0f7819ULL, 0x000fc40000011606ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff027819ULL, 0x000fe20000011602ULL, 0x0000003c3418723cULL, 0x000b640000041818ULL,
0x00000010ff217819ULL, 0x020fe40000011641ULL, 0x000010540f207816ULL, 0x000fe40000000044ULL,
0x0000105402217816ULL, 0x000fe40000000021ULL, 0x0000000408027810ULL, 0x000fc80007ffe0ffULL,
0x0000f6a802027811ULL, 0x000fe200078e18ffULL, 0x000000203420723cULL, 0x000b620000041814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000002147f8cULL, 0x0202a2000c80043fULL,
0x0000000107077810ULL, 0x000fe40007ffe0ffULL, 0x0000f6a056067811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000006ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff0f7224ULL, 0x004fe200078e0015ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff436000007947ULL, 0x000fea000383ffffULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000011007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000d36000047802ULL, 0x000fc40000000f00ULL, 0x00007fa000007944ULL, 0x01efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001100007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x00afc80000000011ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000047919ULL, 0x000e680000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000002ff067819ULL, 0x002fe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x008fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000003000307220ULL, 0x042fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x000fe20000410000ULL,
0x0000003204327220ULL, 0x044fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x000fc20000410000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x0000001c1d1c723eULL, 0x000fc400000010ffULL,
0x000000181918723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002a2b2a723eULL, 0x000fe400000010ffULL, 0x000000262715723eULL, 0x000fe400000010ffULL,
0x0000003a3b3a723eULL, 0x000fc400000010ffULL, 0x0000001e1f1d723eULL, 0x000fe400000010ffULL,
0x0000001a1b1a723eULL, 0x000fe400000010ffULL, 0x00000022230d723eULL, 0x000fe400000010ffULL,
0x000054102a147816ULL, 0x000fe40000000015ULL, 0x00000002ff077819ULL, 0x102fe20000011605ULL,
0x0000000178787824ULL, 0x000fe200078e0205ULL, 0x0000000205007812ULL, 0x000fc400078ec0ffULL,
0x0000000805097811ULL, 0x010fe200078ff0ffULL, 0x00000008070b7824ULL, 0x040fe200078e00ffULL,
0x0000000700027211ULL, 0x048fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000900037211ULL, 0x000fe200078ff8ffULL, 0x00000008090a7824ULL, 0x000fe200078e00ffULL,
0x0000000202007810ULL, 0x040fe20007ffe0ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000000402047810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee203ULL,
0x0000100075037824ULL, 0x000fe200078e00ffULL, 0xfffffff80b067812ULL, 0x000fc400078ee200ULL,
0xfffffff809007812ULL, 0x000fe200078ee202ULL, 0x0000080008077824ULL, 0x000fe200078e0203ULL,
0x0000000602097810ULL, 0x000fe20007ffe0ffULL, 0x0000000805027824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0c7812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e0207ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x000000100a107824ULL, 0x100fe200078e0207ULL,
0x0000000802097812ULL, 0x000fe200078ec0ffULL, 0x00000010060a7824ULL, 0x100fe200078e0207ULL,
0x000000303100723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0207ULL,
0x0000002c2d02723eULL, 0x000fe200000010ffULL, 0x0000000104067824ULL, 0x000fe200078e0209ULL,
0x000000383904723eULL, 0x000fe200000010ffULL, 0x00000001090a7824ULL, 0x040fe200078e020aULL,
0x0000541000127816ULL, 0x104fe20000000002ULL, 0x000000100e0e7824ULL, 0x000fe200078e0207ULL,
0x0000763200137816ULL, 0x000fe20000000002ULL, 0x0000000109077824ULL, 0x000fe200078e020cULL,
0x000000282900723eULL, 0x000fe200000010ffULL, 0x00000001090e7824ULL, 0x000fe200078e020eULL,
0x000000242502723eULL, 0x000fe200000010ffULL, 0x0000001206007388ULL, 0x0003e20000000a00ULL,
0x00000020210c723eULL, 0x000fe200000010ffULL, 0x0000000109107824ULL, 0x000fe200078e0210ULL,
0x000076322a157816ULL, 0x000fe20000000015ULL, 0x0000001078787824ULL, 0x000fe200078e0203ULL,
0x000000ff00097306ULL, 0x000fe20000209400ULL, 0x0000541000127816ULL, 0x002fc40000000002ULL,
0x0000763200137816ULL, 0x000fe40000000002ULL, 0x000000323300723eULL, 0x000fe400000010ffULL,
0x0000002e2f02723eULL, 0x000fe200000010ffULL, 0x000000120a007388ULL, 0x0003e40000000a00ULL,
0x0000541004127816ULL, 0x142fe4000000001cULL, 0x0000763204137816ULL, 0x000fe4000000001cULL,
0x000054103a1c7816ULL, 0x000fc4000000001dULL, 0x000076323a1d7816ULL, 0x000fe2000000001dULL,
0x0000001207007388ULL, 0x0003e40000000a00ULL, 0x0000541018127816ULL, 0x142fe4000000000cULL,
0x0000763218137816ULL, 0x000fe4000000000cULL, 0x000054101a0c7816ULL, 0x140fe4000000000dULL,
0x000076321a0d7816ULL, 0x000fe2000000000dULL, 0x000000120e007388ULL, 0x0003e40000000a00ULL,
0x0000541000127816ULL, 0x002fc40000000002ULL, 0x0000763200137816ULL, 0x000fe40000000002ULL,
0x000000ff00007306ULL, 0x000e660000205400ULL, 0x0000001210007388ULL, 0x000fe80000000a00ULL,
0x000400140a007388ULL, 0x000fe80000000a00ULL, 0x0004001c07007388ULL, 0x000fe80000000a00ULL,
0x0004000c0e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000078107984ULL, 0x000ea20000000c00ULL, 0x000000000900720bULL, 0x002fc40003f1d000ULL,
0x000000ff00007245ULL, 0x000fe2000020d400ULL, 0x0004000078187984ULL, 0x000e680000000c00ULL,
0x0008000078147984ULL, 0x000ee80000000c00ULL, 0x000c0000781c7984ULL, 0x000ee40000000c00ULL,
0x0000000100000812ULL, 0x000fc400078efcffULL, 0x000000ff0800720cULL, 0x000fe40003f05270ULL,
0x000000000009723eULL, 0x000fca00000010ffULL, 0x3f803f8009137831ULL, 0x044fe40000200013ULL,
0x3f803f8009127831ULL, 0x040fe40000200012ULL, 0x3f803f8009117831ULL, 0x040fe40000200011ULL,
0x3f803f8009107831ULL, 0x040fe40000200010ULL, 0x3f803f80091b7831ULL, 0x042fe4000020001bULL,
0x3f803f80091a7831ULL, 0x000fc4000020001aULL, 0x3f803f8009197831ULL, 0x040fe40000200019ULL,
0x3f803f8009187831ULL, 0x000fe40000200018ULL, 0x3f803f8013137831ULL, 0x008fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fe40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fc40000200014ULL, 0x3f803f801b1b7831ULL, 0x000fe4000020001fULL,
0x3f803f801a1a7831ULL, 0x000fe2000020001eULL, 0x0000001078007388ULL, 0x000fe20000000c00ULL,
0x3f803f8019197831ULL, 0x000fe4000020001dULL, 0x3f803f8018187831ULL, 0x000fca000020001cULL,
0x0004001878007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x000fc80000011605ULL,
0x000000760400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000104007824ULL, 0x100fe200078e0205ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00005a0074747a19ULL, 0x000fe200000006ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x00000007050c7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800007812ULL, 0x000fe200078ef805ULL, 0x0000580000067ab9ULL, 0x000fc40000000800ULL,
0x00000008750d7824ULL, 0x000fe400078e020cULL, 0x0000001000027824ULL, 0x000fe400078e0203ULL,
0x0000001077007824ULL, 0x000fc600078e0204ULL, 0x0000000002087984ULL, 0x0004e40000000c00ULL,
0x0000000500067c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff047a19ULL, 0x000fe20000011600ULL,
0x00000006040472a4ULL, 0x002fe4000f8e023fULL, 0x0000000174067824ULL, 0x000fe200078e0206ULL,
0x0000002005027810ULL, 0x004fc60007ffe0ffULL, 0x0000007904077224ULL, 0x000fe200078e0206ULL,
0x00000003ff0f7819ULL, 0x000fe20000011602ULL, 0x0000000479007c24ULL, 0x000fca000f8e02ffULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x000fc800078040ffULL, 0x00005d0007077a11ULL, 0x000fe400000f4404ULL,
0x000000760f00720cULL, 0x000fc60003f06070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0083ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x100fe200078e020fULL, 0x00000040050c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010770f7824ULL, 0x000fc600078e020fULL, 0x0000000704077812ULL, 0x002fe400078ec0ffULL,
0x00005a00ff067a19ULL, 0x000fe4000001160fULL, 0x0ffffff807047812ULL, 0x000fe400078ef802ULL,
0x000000050f077c12ULL, 0x000fe4000f8e30ffULL, 0x00000003ff0f7819ULL, 0x000fe2000001160cULL,
0x0000001004047824ULL, 0x000fe200078e0203ULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x0000000174077824ULL, 0x000fc600078e0207ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000007906077224ULL, 0x000fe400078e0207ULL, 0x00000008750d7824ULL, 0x000fc600078e0202ULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x000fc800078040ffULL, 0x00005d0007077a11ULL, 0x000fe400000f440eULL,
0x000000760f00720cULL, 0x000fc60003f06070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe400078e020fULL, 0x00000010770f7824ULL, 0x000fc600078e020fULL,
0x0000000702077812ULL, 0x002fe400078ec0ffULL, 0x000000050f067c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff807027812ULL, 0x000fe400078ef80cULL, 0x00005a00ff047a19ULL, 0x000fe2000001160fULL,
0x0000000174067824ULL, 0x000fe200078e0206ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001002027824ULL, 0x000fe400078e0203ULL, 0x0000007904077224ULL, 0x000fe200078e0206ULL,
0x0000006005067810ULL, 0x000fc40007ffe0ffULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x0000000700077210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff0d7819ULL, 0x000fc60000011606ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0007047a11ULL, 0x000fe200078040ffULL,
0x0000000106027824ULL, 0x002fc600078e020dULL, 0x00005d0007057a11ULL, 0x000fe200000f440eULL,
0x0000000875077824ULL, 0x000fe200078e020cULL, 0x000000760d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000702077812ULL, 0x000fc800078ec0ffULL,
0xfffffff807027812ULL, 0x000fe200078ef806ULL, 0x0000000804007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x002fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x00000010770d7824ULL, 0x000fc600078e020dULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000875757824ULL, 0x000fe200078e0206ULL,
0x000000050d037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fc6000001160dULL,
0x0000000174037824ULL, 0x000fc800078e0203ULL, 0x0000007902037224ULL, 0x000fca00078e0203ULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x0000001075027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff027819ULL, 0x000fc8000001160eULL,
0x0000000b0200720cULL, 0x000fda0003f06070ULL, 0x000000026f038824ULL, 0x000fc800078e00ffULL,
0x0000680003088a24ULL, 0x000fe400078e0202ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000640008088625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808038981ULL, 0x000ea2000c1e1900ULL, 0x00006c00ff107624ULL, 0x000fe400078e00ffULL,
0x00006d00ff117624ULL, 0x000fe200078e00ffULL, 0x00f60000ff067f8cULL, 0x002e68000c80043fULL,
0x00000008100f7981ULL, 0x000722000c1e9900ULL, 0x000001ff0400780cULL, 0x000fe20003f04070ULL,
0x000000806e6e7824ULL, 0x000fc400078e00ffULL, 0x0000008074047824ULL, 0x000fe400078e00ffULL,
0x000000400e737824ULL, 0x000fe400078e00ffULL, 0x00000080ff137424ULL, 0x000fc600078e00ffULL,
0x00000040041e7812ULL, 0x000fe200078ef873ULL, 0x0000006e03127224ULL, 0x004fc800078e02ffULL,
0x0000620012087625ULL, 0x000fe200078e0013ULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff257819ULL, 0x00afe4000001160dULL, 0x000010000e227811ULL, 0x000fe400078e68ffULL,
0x00000008251f7810ULL, 0x040fe20007ffe0ffULL, 0x000000011e107824ULL, 0x040fe200078e0225ULL,
0x0000001025267810ULL, 0x040fe40007ffe0ffULL, 0x0000001825287810ULL, 0x040fe20007ffe0ffULL,
0x000000011e127824ULL, 0x000fe200078e021fULL, 0x0000002025217810ULL, 0x040fe20007ffe0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000002825237810ULL, 0x000fc40007ffe0ffULL,
0x0000003025247810ULL, 0x000fe20007ffe0ffULL, 0x000000011e147824ULL, 0x000fe200078e0226ULL,
0x0000003010197812ULL, 0x000fe200078ef805ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x0000001908187210ULL, 0x000fe20007f1e0ffULL, 0x000000011e167824ULL, 0x000fe200078e0228ULL,
0x00000030121b7812ULL, 0x000fe200078ef805ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000001b081a7210ULL, 0x000fe20007f3e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000030141d7812ULL, 0x000fe400078ef805ULL, 0x000000730c147217ULL, 0x000fe20007800000ULL,
0x0000000109197824ULL, 0x040fe200000e0611ULL, 0x0000003016117812ULL, 0x000fe200078ef805ULL,
0x000000011e1c7824ULL, 0x000fe200078e0221ULL, 0x0000001d08107210ULL, 0x040fe20007f1e0ffULL,
0x00000001091b7824ULL, 0x000fe200008e0613ULL, 0x0000001108127210ULL, 0x000fe20007f3e0ffULL,
0x00000001141d7824ULL, 0x000fe200078e0a73ULL, 0x0000000d0d167211ULL, 0x000fe200078fe8ffULL,
0x0000000109117824ULL, 0x000fc400000e0615ULL, 0x000000801c147825ULL, 0x000fe200078e00ffULL,
0x0000000316207812ULL, 0x000fe400078ec0ffULL, 0x0000001d2500720cULL, 0x080fe20003f06070ULL,
0x0000000109137824ULL, 0x000fe200008e0617ULL, 0x0000001d1f00720cULL, 0x040fe20003f26070ULL,
0x000000041f1f7824ULL, 0x000fe200078e00ffULL, 0x0000003014177812ULL, 0x000fe200078ef805ULL,
0x000000011e167824ULL, 0x000fe200078e0223ULL, 0x0ffffffc200d7812ULL, 0x000fe400078ef80dULL,
0x0000001708147210ULL, 0x000fc40007f5e0ffULL, 0xfffffffc1f177812ULL, 0x000fe200078ee220ULL,
0x000000100d0d7824ULL, 0x100fe200078e0222ULL, 0x0000003825257810ULL, 0x000fe20007ffe0ffULL,
0x0000000109157824ULL, 0x000fe200010e0615ULL, 0x0000001d2600720cULL, 0x080fe20003fa6070ULL,
0x00000010171f7824ULL, 0x000fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000180d7faeULL, 0x0003e2000c101c48ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001d2800720cULL, 0x080fe40003f86070ULL, 0x000000001a1f7faeULL, 0x0005e2000c901c48ULL,
0x0000001d2100720cULL, 0x000fc40003f66070ULL, 0x0000003016277812ULL, 0x000fe200078ef805ULL,
0x000000011e167824ULL, 0x000fe200078e0224ULL, 0x0000001d2300720cULL, 0x040fe20003f46070ULL,
0x0000000423237824ULL, 0x000fe200078e00ffULL, 0x00000027081c7210ULL, 0x000fe20007fde0ffULL,
0x000000011e187824ULL, 0x002fe200078e0225ULL, 0x0000001d2400720cULL, 0x080fe20003f26070ULL,
0x00000004260d7824ULL, 0x000fe200078e00ffULL, 0x0000001d2500720cULL, 0x000fe20003f06070ULL,
0x00000001091d7824ULL, 0x000fe400030e0617ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffffc0d0d7812ULL, 0x000fc600078ee220ULL, 0x00000004211f7824ULL, 0x004fe200078e00ffULL,
0x0000003016217812ULL, 0x100fe200078ef805ULL, 0x00000004281b7824ULL, 0x000fe400078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000002108167210ULL, 0x000fe40007fde0ffULL,
0xfffffffc1b1b7812ULL, 0x100fe200078ee220ULL, 0x0000000424277824ULL, 0x000fe200078e00ffULL,
0x0000003018057812ULL, 0x000fe200078ef805ULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0xfffffffc1f1f7812ULL, 0x100fe200078ee220ULL, 0x0000000109177824ULL, 0x000fe200030e0617ULL,
0xfffffffc23217812ULL, 0x000fe200078ee220ULL, 0x000000100d0d7824ULL, 0x000fe200078e0222ULL,
0xfffffffc27237812ULL, 0x000fe200078ee220ULL, 0x000000101b1b7824ULL, 0x000fe200078e0222ULL,
0xfffffffc25257812ULL, 0x000fe200078ee220ULL, 0x000000101f1f7824ULL, 0x100fe200078e0222ULL,
0x0000000508087210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x100fe200078e0222ULL,
0x00000000100d7faeULL, 0x0003e2000e901c48ULL, 0x0000001023237824ULL, 0x000fc400078e0222ULL,
0x0000001025257824ULL, 0x000fe200078e0222ULL, 0x00000000121b7faeULL, 0x0003e2000e101c48ULL,
0x0000000109097824ULL, 0x000fc600030e0619ULL, 0x00000000141f7faeULL, 0x0003e8000d901c48ULL,
0x000000001c217faeULL, 0x0003e8000d101c48ULL, 0x0000000016237faeULL, 0x0003e8000c901c48ULL,
0x0000000008257faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x000000180d137811ULL, 0x04afe400078ff0ffULL, 0x000000200d157811ULL, 0x000fc400078ff0ffULL,
0x000000100d117811ULL, 0x040fe200078ff0ffULL, 0x000000011e167824ULL, 0x040fe200078e0213ULL,
0x0000001e0d107211ULL, 0x000fe200078ff0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0000000d0d127211ULL, 0x040fe200078fe8ffULL, 0x000000011e207824ULL, 0x040fe200078e0215ULL,
0x000000080d1d7811ULL, 0x040fe200078ff0ffULL, 0x000000011e147824ULL, 0x000fe200078e0211ULL,
0x000000280d177811ULL, 0x000fe200078ff0ffULL, 0x00000004111f7824ULL, 0x000fe200078e00ffULL,
0x000000300d197811ULL, 0x000fe200078ff0ffULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x000000380d1b7811ULL, 0x000fe200078ff0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000003121a7812ULL, 0x000fc400078ec0ffULL, 0x000010000e287811ULL, 0x000fe200078e68ffULL,
0x000000011e127824ULL, 0x000fe200078e021dULL, 0xfffffffc1f187812ULL, 0x100fe200078ee21aULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc1a217812ULL, 0x000fe200078ef80dULL,
0x000000011e227824ULL, 0x000fe200078e0217ULL, 0x00000030101f7812ULL, 0x000fe200078ef805ULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0xfffffffc1d0d7812ULL, 0x100fe200078ee21aULL,
0x000000011e247824ULL, 0x040fe400078e0219ULL, 0x0000000419237824ULL, 0x000fe200078e00ffULL,
0xfffffffc13197812ULL, 0x100fe200078ee21aULL, 0x000000011e267824ULL, 0x000fe200078e021bULL,
0xfffffffc171c7812ULL, 0x100fe200078ee21aULL, 0x000000041b257824ULL, 0x000fe200078e00ffULL,
0xfffffffc151b7812ULL, 0x100fe200078ee21aULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffffc231d7812ULL, 0x000fc400078ee21aULL, 0xfffffffc251e7812ULL, 0x000fe200078ee21aULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000001f081a7210ULL, 0x000fc60007f1e0ffULL,
0x0000001019237824ULL, 0x000fe200078e0228ULL, 0x0000003012197812ULL, 0x100fe200078ef805ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000030141f7812ULL, 0x000fc600078ef805ULL,
0x000000101c277824ULL, 0x100fe200078e0228ULL, 0x00000019081c7210ULL, 0x000fe20007f3e0ffULL,
0x000000101e2b7824ULL, 0x100fe200078e0228ULL, 0x0000001f081e7210ULL, 0x000fe20007f5e0ffULL,
0x000000101b257824ULL, 0x100fe200078e0228ULL, 0x0000003016197812ULL, 0x000fe200078ef805ULL,
0x000000101d297824ULL, 0x000fe400078e0228ULL, 0x00000001091b7824ULL, 0x040fe200000e0611ULL,
0x0000001908167210ULL, 0x000fe20007f1e0ffULL, 0x00000001091d7824ULL, 0x000fc400008e0613ULL,
0x0000008020107825ULL, 0x000fc800078e00ffULL, 0x0000001021337824ULL, 0x100fe200078e0228ULL,
0x0000003010317812ULL, 0x000fe200078ef805ULL, 0x00000001091f7824ULL, 0x000fe400010e0615ULL,
0x0000008022127825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a337faeULL, 0x0003e6000b901c48ULL, 0x0000001018217824ULL, 0x000fe200078e0228ULL,
0x00000030122f7812ULL, 0x000fe200078ef805ULL, 0x0000008024147825ULL, 0x000fc600078e00ffULL,
0x0000002f08127210ULL, 0x000fe20007f3e0ffULL, 0x0000008026187825ULL, 0x000fe200078e00ffULL,
0x00000030142d7812ULL, 0x000fc600078ef805ULL, 0x0000000109177824ULL, 0x000fe200000e0617ULL,
0x0000003018057812ULL, 0x000fe200078ef805ULL, 0x000000100d0d7824ULL, 0x000fe200078e0228ULL,
0x0000003108107210ULL, 0x040fe20007f1e0ffULL, 0x0000000109137824ULL, 0x040fe200008e0613ULL,
0x0000002d08147210ULL, 0x040fe40007f5e0ffULL, 0x0000000508087210ULL, 0x000fe20007f7e0ffULL,
0x0000000109117824ULL, 0x040fe200000e0611ULL, 0x000000001c0d7faeULL, 0x0003e2000b901c48ULL,
0x0000000109157824ULL, 0x000fc400010e0615ULL, 0x0000000109097824ULL, 0x000fe200018e0619ULL,
0x000000001e217faeULL, 0x0003e8000b901c48ULL, 0x0000000016237faeULL, 0x0003e8000b901c48ULL,
0x0000000010257faeULL, 0x0003e8000b901c48ULL, 0x0000000012277faeULL, 0x0003e8000b901c48ULL,
0x0000000014297faeULL, 0x0003e8000b901c48ULL, 0x00000000082b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000001008107210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e09ULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011411ULL,
0x0000001005057211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0611ULL,
0x0000000205057819ULL, 0x000fc80000001210ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x000000200e057824ULL, 0x002fca00078e0205ULL,
0x00000003ff067819ULL, 0x000fc80000011605ULL, 0x1ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000000f05067812ULL, 0x000fc600078ec0ffULL, 0x0000000105087824ULL, 0x000fe400078e0208ULL,
0x0000001006107824ULL, 0x040fe400078e00ffULL, 0x0000001006077824ULL, 0x000fe200078e00ffULL,
0x0000000f08057812ULL, 0x040fe400078ec0ffULL, 0x0000000108087810ULL, 0x000fe40007ffe0ffULL,
0x000000f010057812ULL, 0x000fe400078ee205ULL, 0x0000000f08087812ULL, 0x000fc600078ec0ffULL,
0x0000000005147984ULL, 0x000e62000000cc00ULL, 0x000000f007087812ULL, 0x000fca00078ee208ULL,
0x0000000008107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001805007388ULL, 0x0003e8000000cc00ULL,
0x0000001408007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff107f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0d7224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x00f60400ff057984ULL, 0x002e640000000800ULL,
0x8000000005ff7812ULL, 0x006fc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011409ULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00005800ff107624ULL, 0x000fe200078e00ffULL,
0x800058000c707a10ULL, 0x000fe20007ffe0ffULL, 0x000068006f6f7a24ULL, 0x000fe200078e02ffULL,
0x3db504f30f067820ULL, 0x010fe20000410000ULL, 0x0000f6880e727811ULL, 0x000fe200078e18ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000001f10097810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x0000f6080e747811ULL, 0x000fe400078e28ffULL,
0x00000004ff0d7819ULL, 0x000fc40000011609ULL, 0xffffffff10717810ULL, 0x040fe40007ffe0ffULL,
0x0000000910097810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff707819ULL, 0x000fe40000011670ULL,
0x0ffffffe0d0d7812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0008ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x018fc4000001ff00ULL,
0x000000013800780cULL, 0x040fe20003f25270ULL, 0x00000080ff187424ULL, 0x020fe200078e00ffULL,
0x0000000107087810ULL, 0x000fe20007ffe0ffULL, 0x00000be000007945ULL, 0x000fe20003800000ULL,
0x0000000138147810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff397224ULL, 0x000fc600078e0038ULL,
0x000000021400780cULL, 0x040fe20003f06070ULL, 0x000000ffff387224ULL, 0x000fe200078e0014ULL,
0x000000ff14167207ULL, 0x000fc60000800000ULL, 0x000000ffff081224ULL, 0x000fc800078e0207ULL,
0x00000100083c7824ULL, 0x040fe200078e0273ULL, 0x0000000108157810ULL, 0x000fe40007ffe0ffULL,
0x000000010f087812ULL, 0x000fe400078e0cffULL, 0x0000000a1500720cULL, 0x000fe20003f46070ULL,
0x0000006e03157224ULL, 0x010fe200078e02ffULL, 0x000000403c177812ULL, 0x000fc600078ec0ffULL,
0x0000620015147625ULL, 0x000fc800078e0018ULL, 0x0000000104427824ULL, 0x000fc800078e0217ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x0000001005177824ULL, 0x002fe200078e00ffULL,
0x00000002ff467819ULL, 0x000fe20000011605ULL, 0x000000020e437824ULL, 0x000fc600078e0208ULL,
0x0000003017197812ULL, 0x000fe200078ec0ffULL, 0x00000001461b7824ULL, 0x140fe200078e0242ULL,
0x0000000846477810ULL, 0x040fe40007ffe0ffULL, 0x0000001046497810ULL, 0x000fe20007ffe0ffULL,
0x0000004016187824ULL, 0x000fe200078e0219ULL, 0x0000003c0c177217ULL, 0x000fe20007800000ULL,
0x00000001473b7824ULL, 0x100fe200078e0242ULL, 0x00000018464c7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000100043437811ULL, 0x000fe200078e60ffULL,
0x0000000149417824ULL, 0x000fe200078e0242ULL, 0x00000020464d7810ULL, 0x040fe20007ffe0ffULL,
0x000000803b3a7825ULL, 0x000fe200078e0018ULL, 0x00000030464e7810ULL, 0x000fc60007ffe0ffULL,
0x000000801b1a7825ULL, 0x000fc800078e0018ULL, 0x0000008041407825ULL, 0x000fe200078e0018ULL,
0x0000001a143e7210ULL, 0x000fc60007f3e0ffULL, 0x0000000117177824ULL, 0x000fe200078e0a3cULL,
0x0000003a143c7210ULL, 0x000fe20007f5e0ffULL, 0x000000014c457824ULL, 0x000fe200078e0242ULL,
0x00000005053a7211ULL, 0x000fe200078fe8ffULL, 0x00000001153f7824ULL, 0x000fe200008e061bULL,
0x0000004014407210ULL, 0x000fe20007f7e0ffULL, 0x0000008045447825ULL, 0x000fe200078e0018ULL,
0x000000033a487812ULL, 0x000fe400078ec0ffULL, 0x000000174c00720cULL, 0x080fe20003fa6070ULL,
0x00000001153d7824ULL, 0x000fe200010e063bULL, 0x000000174700720cULL, 0x0c0fe20003f46070ULL,
0x0000000447477824ULL, 0x000fe200078e00ffULL, 0x00000044141a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000115417824ULL, 0x000fe200018e0641ULL, 0x000000174900720cULL, 0x0c0fe20003f66070ULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x0ffffffc48447812ULL, 0x000fe200078ef805ULL,
0x00000001151b7824ULL, 0x000fe200008e0645ULL, 0xfffffffc474a7812ULL, 0x000fe200078ee248ULL,
0x000000014d3b7824ULL, 0x000fe200078e0242ULL, 0x000000174600720cULL, 0x000fe20003f26070ULL,
0x0000001044477824ULL, 0x100fe200078e0243ULL, 0xfffffffc49447812ULL, 0x000fe200078ee248ULL,
0x000000104a497824ULL, 0x000fe200078e0243ULL, 0x00000028464a7810ULL, 0x040fe20007ffe0ffULL,
0x000000803b3a7825ULL, 0x000fe200078e0018ULL, 0x0000003846467810ULL, 0x000fc60007ffe0ffULL,
0x000000014a457824ULL, 0x000fe200078e0242ULL, 0x0000003a143a7210ULL, 0x000fe20007f9e0ffULL,
0x00000010444b7824ULL, 0x000fe400078e0243ULL, 0x0000008045447825ULL, 0x000fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e2000c901c48ULL,
0x000000174600720cULL, 0x080fe40003f26070ULL, 0x00000001153b7824ULL, 0x000fe200020e063bULL,
0x000000003c497faeULL, 0x0005e2000d101c48ULL, 0x000000174d00720cULL, 0x0c0fe20003f86070ULL,
0x000000044d4d7824ULL, 0x000fe200078e00ffULL, 0x000000174e00720cULL, 0x080fe20003f46070ULL,
0x00000000404b7faeULL, 0x0007e2000d901c48ULL, 0x000000174a00720cULL, 0x000fe20003f66070ULL,
0x000000044c177824ULL, 0x000fc400078e00ffULL, 0x000000014e3f7824ULL, 0x102fe400078e0242ULL,
0x0000000146477824ULL, 0x000fe200078e0242ULL, 0xfffffffc4d427812ULL, 0x000fe200078ee248ULL,
0x000000803f3e7825ULL, 0x000fe200078e0018ULL, 0x00000044143c7210ULL, 0x004fc60007fde0ffULL,
0x000000044a417824ULL, 0x008fe200078e00ffULL, 0xfffffffc17407812ULL, 0x000fe200078ee248ULL,
0x00000001153d7824ULL, 0x000fe200030e0645ULL, 0x0000003e143e7210ULL, 0x000fe20007fde0ffULL,
0x0000008047187825ULL, 0x000fe200078e0018ULL, 0xfffffffc41447812ULL, 0x000fc600078ee248ULL,
0x000000044e457824ULL, 0x000fe400078e00ffULL, 0x0000000446477824ULL, 0x000fe400078e00ffULL,
0x00000001153f7824ULL, 0x000fe200030e063fULL, 0xfffffffc45467812ULL, 0x100fe200078ee248ULL,
0x0000001040177824ULL, 0x100fe200078e0243ULL, 0xfffffffc47487812ULL, 0x000fe200078ee248ULL,
0x0000001042417824ULL, 0x100fe200078e0243ULL, 0x0000001814147210ULL, 0x000fe20007fde0ffULL,
0x0000001044457824ULL, 0x100fe200078e0243ULL, 0x000000001a177faeULL, 0x0003e2000e901c48ULL,
0x0000001046477824ULL, 0x000fc400078e0243ULL, 0x0000001048437824ULL, 0x000fe200078e0243ULL,
0x000000003a417faeULL, 0x0003e2000e101c48ULL, 0x0000000115157824ULL, 0x000fc600030e0619ULL,
0x000000003c457faeULL, 0x0003e8000d901c48ULL, 0x000000003e477faeULL, 0x0003e8000d101c48ULL,
0x0000000014437faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x00000008051b7811ULL, 0x042fe200078ff0ffULL, 0x0000001005177824ULL, 0x040fe200078e00ffULL,
0x00000010053f7811ULL, 0x040fe200078ff0ffULL, 0x000000020e197824ULL, 0x000fe200078e0208ULL,
0x0000001805417811ULL, 0x000fe200078ff0ffULL, 0x000000011b3b7824ULL, 0x100fe200078e0242ULL,
0x0000000505187211ULL, 0x000fe200078fe8ffULL, 0x000000041b1b7824ULL, 0x000fe200078e00ffULL,
0x0000002005437811ULL, 0x000fe200078ff0ffULL, 0x000000013f3d7824ULL, 0x100fe200078e0242ULL,
0x0000002805457811ULL, 0x000fe200078ff0ffULL, 0x000000043f497824ULL, 0x000fe200078e00ffULL,
0x0000003005477811ULL, 0x000fe200078ff0ffULL, 0x00000001413f7824ULL, 0x100fe200078e0242ULL,
0x0000003805517811ULL, 0x000fe200078ff0ffULL, 0x00000004414b7824ULL, 0x000fe200078e00ffULL,
0x0000000318187812ULL, 0x000fe200078ec0ffULL, 0x0000000143417824ULL, 0x100fe200078e0242ULL,
0x0000003017177812ULL, 0x000fe200078ec0ffULL, 0x00000004434d7824ULL, 0x000fe200078e00ffULL,
0x00001000191a7811ULL, 0x000fe200078e60ffULL, 0x0000000145437824ULL, 0x000fe200078e0242ULL,
0xfffffffc49497812ULL, 0x100fe200078ee218ULL, 0x00000004454f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc4b4b7812ULL, 0x100fe200078ee218ULL, 0x0000000447537824ULL, 0x000fe200078e00ffULL,
0x0ffffffc18197812ULL, 0x000fe200078ef805ULL, 0x0000000451577824ULL, 0x000fe200078e00ffULL,
0xfffffffc4d4d7812ULL, 0x000fe200078ee218ULL, 0x0000000147457824ULL, 0x000fe200078e0242ULL,
0xfffffffc1b477812ULL, 0x000fe200078ee218ULL, 0x0000001019557824ULL, 0x000fe200078e021aULL,
0xfffffffc4f4f7812ULL, 0x100fe200078ee218ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0xfffffffc53537812ULL, 0x000fe200078ee218ULL, 0x0000000151517824ULL, 0x000fe200078e0242ULL,
0xfffffffc57577812ULL, 0x000fe200078ee218ULL, 0x0000004016187824ULL, 0x000fe200078e0217ULL,
0x00000042051b7211ULL, 0x000fe200078ff0ffULL, 0x0000001047177824ULL, 0x000fc400078e021aULL,
0x0000001049477824ULL, 0x100fe400078e021aULL, 0x000000104b497824ULL, 0x100fe400078e021aULL,
0x000000104d4b7824ULL, 0x100fe400078e021aULL, 0x000000104f4d7824ULL, 0x100fe400078e021aULL,
0x00000010534f7824ULL, 0x100fe400078e021aULL, 0x0000001057537824ULL, 0x000fc400078e021aULL,
0x000000801b1a7825ULL, 0x000fc800078e0018ULL, 0x000000803b3a7825ULL, 0x000fe200078e0018ULL,
0x0000001a141a7210ULL, 0x000fc60007f3e0ffULL, 0x000000803d3c7825ULL, 0x000fe200078e0018ULL,
0x0000003a143a7210ULL, 0x000fc60007f5e0ffULL, 0x000000803f3e7825ULL, 0x000fe200078e0018ULL,
0x0000003c143c7210ULL, 0x000fc60007f7e0ffULL, 0x0000008041407825ULL, 0x000fe200078e0018ULL,
0x0000003e143e7210ULL, 0x000fc60007f9e0ffULL, 0x0000008043427825ULL, 0x000fc800078e0018ULL,
0x0000008045447825ULL, 0x000fc800078e0018ULL, 0x0000008051187825ULL, 0x000fc800078e0018ULL,
0x00000001151b7824ULL, 0x040fe200008e061bULL, 0x0000004014407210ULL, 0x040fe20007f3e0ffULL,
0x00000001153b7824ULL, 0x040fe200010e063bULL, 0x0000004214427210ULL, 0x040fe20007f5e0ffULL,
0x00000001153d7824ULL, 0x040fe200018e063dULL, 0x0000004414447210ULL, 0x040fe20007f7e0ffULL,
0x00000001153f7824ULL, 0x040fe200020e063fULL, 0x0000001814147210ULL, 0x000fe20007f9e0ffULL,
0x0000000115417824ULL, 0x040fe200008e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a557faeULL, 0x0003e2000b901c48ULL, 0x0000000115437824ULL, 0x000fc400010e0643ULL,
0x0000000115457824ULL, 0x040fe200018e0645ULL, 0x000000003a177faeULL, 0x0003e2000b901c48ULL,
0x0000000115157824ULL, 0x000fc600020e0619ULL, 0x000000003c477faeULL, 0x0003e8000b901c48ULL,
0x000000003e497faeULL, 0x0003e8000b901c48ULL, 0x00000000404b7faeULL, 0x0003e8000b901c48ULL,
0x00000000424d7faeULL, 0x0003e8000b901c48ULL, 0x00000000444f7faeULL, 0x0003e8000b901c48ULL,
0x0000000014537faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000011600780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000202027810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x0000000b0200720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000026f147824ULL, 0x002fe400078e0202ULL,
0x00000004ff157424ULL, 0x000fc800078e00ffULL, 0x0000640014147625ULL, 0x000fca00078e0015ULL,
0x0000000814037981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff3a7224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff805147812ULL, 0x020fe200078ec0ffULL,
0x000000020e3b7824ULL, 0x000fe200078e020fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000013a187810ULL, 0x000fe40007ffe0ffULL, 0x0000000714147812ULL, 0x100fe400078ef805ULL,
0x000010003b3b7811ULL, 0x000fe400078e60ffULL, 0x00000001ff157819ULL, 0x000fe20000011614ULL,
0x0000000414177824ULL, 0x040fe200078e00ffULL, 0x00000020054a7810ULL, 0x040fe20007ffe0ffULL,
0x00000004141a7824ULL, 0x000fe200078e00ffULL, 0x0000000705407812ULL, 0x000fe200078ec0ffULL,
0x0000000115167824ULL, 0x040fe200078e023aULL, 0xfffffff84a4a7812ULL, 0x000fe200078ec0ffULL,
0x0000000115157824ULL, 0x000fe200078e0218ULL, 0x0000000840487812ULL, 0x000fc400078ef805ULL,
0xfffffffc17167812ULL, 0x000fe200078ee216ULL, 0x0000000439177824ULL, 0x000fe200078e023aULL,
0xfffffffc1a1a7812ULL, 0x000fe400078ee215ULL, 0x000000074a4a7812ULL, 0x000fe200078ef805ULL,
0x0000001016167824ULL, 0x100fe400078e023bULL, 0x0000000217147824ULL, 0x000fe200078e00ffULL,
0x00000001ff177819ULL, 0x000fe2000001164aULL, 0x000000101a447824ULL, 0x000fe200078e023bULL,
0x00000000163c783bULL, 0x0002a20000000200ULL, 0x000000044a427824ULL, 0x000fe200078e00ffULL,
0x0000001405157211ULL, 0x000fe200078fe0ffULL, 0x00000001174b7824ULL, 0x000fc400078e0218ULL,
0x0000000117177824ULL, 0x000fe200078e023aULL, 0x000000004444783bULL, 0x000ee20000000200ULL,
0x0000000148157824ULL, 0x000fe200078e0215ULL, 0x000000023a3a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001048167824ULL, 0x002fc600078e00ffULL, 0x000000043a00780cULL, 0x000fe40003f25270ULL,
0xfffffff016157812ULL, 0x000fe400078ee215ULL, 0x0000000214167810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc42147812ULL, 0x000fe200078ee217ULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x0000001605177211ULL, 0x000fc800078fe0ffULL, 0x000000001518783bULL, 0x0002e20000000200ULL,
0x0000000148417824ULL, 0x040fe400078e0217ULL, 0x0000001048487824ULL, 0x000fca00078e00ffULL,
0xfffffff048417812ULL, 0x000fca00078ee241ULL, 0x0000001041157824ULL, 0x002fe200078e00ffULL,
0x00000010ff167819ULL, 0x104fe4000001163fULL, 0x00000018ff407819ULL, 0x000fe4000001163fULL,
0x000000ff16177812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3f427812ULL, 0x000fe400078ec0ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000017ff17723eULL, 0x000fc400020006ffULL,
0x00000008ff167819ULL, 0x000fe20000011642ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x000000ff3f3f7812ULL, 0x000fe200078ec0ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00000010ff427819ULL, 0x000fe20000011640ULL,
0x0000001014407824ULL, 0x000fe200078e023bULL, 0x00000010ff177819ULL, 0x000fe20000011617ULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fc400020006ffULL,
0x0000105442497816ULL, 0x000fe40000000017ULL, 0x00000010ff487819ULL, 0x000fe20000011616ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000001514783bULL, 0x000fe20000000200ULL,
0x0000ffff474e7812ULL, 0x008fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe20000011647ULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x0000004cff4c723eULL, 0x000fc400020006ffULL, 0x0000105448487816ULL, 0x000fe4000000003fULL,
0x00000010ff3f7819ULL, 0x000fe20000011647ULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x000000ff3f4d7812ULL, 0x000fe200078ec0ffULL,
0x000000481810723cULL, 0x000b620000041810ULL, 0x00000008ff3f7819ULL, 0x000fe4000001164eULL,
0x00000047ff47723eULL, 0x000fc400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x000000044a487824ULL, 0x020fe200078e00ffULL,
0x00000010ff4c7819ULL, 0x000fe2000001164cULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x000000ff3c517812ULL, 0x000fe200078ec0ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0xfffffffc48487812ULL, 0x000fe200078ee24bULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fc40000011647ULL, 0x00000010ff497819ULL, 0x000fe2000001164dULL,
0x0000001048637824ULL, 0x000fe200078e023bULL, 0x00000010ff4a7819ULL, 0x000fe4000001163fULL,
0x000010544c497816ULL, 0x000fe40000000049ULL, 0x000010544a487816ULL, 0x000fe40000000047ULL,
0x00000018ff3f7819ULL, 0x100fe4000001163cULL, 0x00000010ff3b7819ULL, 0x000fc4000001163cULL,
0x00000018ff647819ULL, 0x002fe20000011641ULL, 0x000000481410723cULL, 0x000be20000041810ULL,
0x000000ff415d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41527812ULL, 0x000fe400078ec0ffULL,
0x00000010ff627819ULL, 0x000fe40000011643ULL, 0x00000010ff497819ULL, 0x020fe40000011641ULL,
0x00000018ff557819ULL, 0x000fc40000011643ULL, 0x000000ff43417812ULL, 0x040fe400078ec0ffULL,
0x0000ffff43567812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3c507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x100fe4000001163dULL, 0x00000018ff5c7819ULL, 0x000fe4000001163dULL,
0x000000ff3d5b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3d4f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4a7819ULL, 0x100fe4000001163eULL, 0x00000018ff687819ULL, 0x000fe4000001163eULL,
0x000000ff3e757812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e5f7812ULL, 0x000fe400078ec0ffULL,
0x0000003fff43723eULL, 0x000fc400020006ffULL, 0x00000000633c783bULL, 0x000e620000000200ULL,
0x00000010ff597819ULL, 0x100fe40000011644ULL, 0x00000018ff667819ULL, 0x000fe40000011644ULL,
0x000000ff44577812ULL, 0x040fe400078ec0ffULL, 0x0000ffff445a7812ULL, 0x000fe200078ec0ffULL,
0x20000043ff447230ULL, 0x000fe20000004100ULL, 0x000000ff3b437812ULL, 0x000fe400078ec0ffULL,
0x00000008ff507819ULL, 0x000fc40000011650ULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000008ff4f7819ULL, 0x000fe2000001164fULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000010ff537819ULL, 0x100fe20000011642ULL,
0x2000005cff3b7230ULL, 0x000fe20000004100ULL, 0x00000018ff5e7819ULL, 0x000fe40000011642ULL,
0x000000ff42547812ULL, 0x040fe400078ec0ffULL, 0x0000ffff42617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff477819ULL, 0x000fc40000011640ULL, 0x00000018ff657819ULL, 0x000fe40000011640ULL,
0x000000ff40607812ULL, 0x040fe400078ec0ffULL, 0x0000ffff40487812ULL, 0x000fe400078ec0ffULL,
0x00000010ff427819ULL, 0x100fe40000011645ULL, 0x00000018ff587819ULL, 0x000fe40000011645ULL,
0x000000ff454b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff454c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x100fe40000011646ULL, 0x00000018ff697819ULL, 0x000fe40000011646ULL,
0x000000ff46677812ULL, 0x040fe400078ec0ffULL, 0x0000ffff464d7812ULL, 0x000fe400078ec0ffULL,
0x0000004fff4f723eULL, 0x000fc400020006ffULL, 0x00000010ff457819ULL, 0x000fe40000011643ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fe40000011644ULL, 0x00000010ff437819ULL, 0x000fe20000011650ULL,
0x2000004eff507230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fe20000011651ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fc400020006ffULL,
0x0000105443447816ULL, 0x000fe40000000044ULL, 0x00000010ff437819ULL, 0x000fe4000001163bULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff3b7819ULL, 0x000fe4000001164fULL,
0x00000010ff637819ULL, 0x102fe4000001163cULL, 0x00000018ff6d7819ULL, 0x000fc4000001163cULL,
0x000000ff3c6b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165bULL, 0x00001054434f7816ULL, 0x000fe40000000050ULL,
0x00000057ff3c723eULL, 0x000fe400020006ffULL, 0x00000010ff5b7819ULL, 0x000fc4000001163dULL,
0x00000018ff6c7819ULL, 0x000fe4000001163dULL, 0x000000ff3d437812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3d507812ULL, 0x000fe400078ec0ffULL, 0x00000066ff3d723eULL, 0x000fe200020006ffULL,
0x20000075ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x00000058ff75723eULL, 0x000fe200020006ffULL, 0x2000003cff587230ULL, 0x000fe20000004100ULL,
0x000000ff4a3c7812ULL, 0x000fe200078ec0ffULL, 0x2000003dff577230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000069ff76723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000003cff69723eULL, 0x000fe200020006ffULL, 0x20000067ff3c7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000005fff677230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x00000064ff5f723eULL, 0x000fe200020006ffULL,
0x20000065ff647230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x20000060ff657230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x2000005dff607230ULL, 0x000fe20000004100ULL, 0x000000ff42427812ULL, 0x000fe200078ec0ffULL,
0x2000005eff5d7230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000054ff5e7230ULL, 0x000fe20000004100ULL, 0x0000105446457816ULL, 0x000fe20000000045ULL,
0x20000055ff547230ULL, 0x000fe20000004100ULL, 0x00000008ff4c7819ULL, 0x000fe2000001164cULL,
0x20000041ff557230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff40417812ULL, 0x000fe200078ec0ffULL,
0x000000441834723cULL, 0x000be20000041834ULL, 0x0000004cff40723eULL, 0x000fe200020006ffULL,
0x20000042ff4c7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x0000006dff42723eULL, 0x000fe400020006ffULL, 0x00000018ff447819ULL, 0x020fe4000001163eULL,
0x0000006cff6d723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff3e457812ULL, 0x000fe400078ec0ffULL, 0x0000004bff3d723eULL, 0x000fe200020006ffULL,
0x20000075ff4b7230ULL, 0x000fe20000004100ULL, 0x00000043ff6c723eULL, 0x000fe200020006ffULL,
0x2000006bff437230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000003dff4a7230ULL, 0x000fe20000004100ULL, 0x00000008ff4d7819ULL, 0x000fe2000001164dULL,
0x20000076ff3d7230ULL, 0x000fe20000004100ULL, 0x00000018ff467819ULL, 0x000fe2000001163fULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000041ff75723eULL, 0x000fc400020006ffULL,
0x00000044ff6b723eULL, 0x000fe200020006ffULL, 0x2000006dff447230ULL, 0x000fe20000004100ULL,
0x000000ff3f6a7812ULL, 0x000fe400078ec0ffULL, 0x00000045ff6d723eULL, 0x000fe200020006ffULL,
0x2000006cff457230ULL, 0x000fe20000004100ULL, 0x0000004dff41723eULL, 0x000fe200020006ffULL,
0x20000040ff4d7230ULL, 0x000fe20000004100ULL, 0x00000046ff6c723eULL, 0x000fe200020006ffULL,
0x20000075ff407230ULL, 0x000fe20000004100ULL, 0x00000008ff527819ULL, 0x000fe20000011652ULL,
0x2000006bff467230ULL, 0x000fe20000004100ULL, 0x000000ff53537812ULL, 0x000fe200078ec0ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x000000ff476b7812ULL, 0x000fe200078ec0ffULL,
0x2000006dff477230ULL, 0x000fe20000004100ULL, 0x0000006aff75723eULL, 0x000fc400020006ffULL,
0x00000008ff6a7819ULL, 0x000fe20000011648ULL, 0x2000006cff487230ULL, 0x000fe20000004100ULL,
0x00000052ff6d723eULL, 0x000fe400020006ffULL, 0x00000053ff76723eULL, 0x000fe400020006ffULL,
0x00000010ff527819ULL, 0x000fe20000011668ULL, 0x2000006dff687230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe40000011669ULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x000000ff496c7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff497230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x000010543b4e7816ULL, 0x000fe4000000004eULL, 0x0000105452537816ULL, 0x000fe40000000053ULL,
0x00000010ff527819ULL, 0x000fe40000011666ULL, 0x00000010ff677819ULL, 0x000fe20000011667ULL,
0x0000004e1830723cULL, 0x000be20000041830ULL, 0x0000006cff75723eULL, 0x000fe200020006ffULL,
0x2000006aff6c7230ULL, 0x000fe20000004100ULL, 0x0000105467527816ULL, 0x000fc40000000052ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x20000075ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff63677812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x00000052182c723cULL, 0x000b64000004182cULL, 0x00000010ff4e7819ULL, 0x020fe40000011665ULL,
0x00000010ff4f7819ULL, 0x000fe4000001166bULL, 0x00000010ff637819ULL, 0x000fc4000001166cULL,
0x00000061ff75723eULL, 0x000fe200020006ffULL, 0x20000076ff617230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00001054644f7816ULL, 0x000fe4000000004fULL,
0x00001054634e7816ULL, 0x000fc4000000004eULL, 0x00000010ff647819ULL, 0x000fe4000001165fULL,
0x00000010ff527819ULL, 0x000fe40000011660ULL, 0x00000010ff537819ULL, 0x000fe2000001166aULL,
0x0000004e1828723cULL, 0x000be20000041828ULL, 0x00000010ff637819ULL, 0x000fe40000011668ULL,
0x00000062ff6d723eULL, 0x000fe200020006ffULL, 0x20000075ff627230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000105464537816ULL, 0x000fe20000000053ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000105463527816ULL, 0x000fe20000000052ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fe20000011656ULL, 0x2000006dff567230ULL, 0x000fe20000004100ULL,
0x00000008ff607819ULL, 0x000fe4000001165cULL, 0x000000ff5b637812ULL, 0x000fe200078ec0ffULL,
0x000000521824723cULL, 0x000b620000041824ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165dULL,
0x00000010ff4e7819ULL, 0x020fe4000001165eULL, 0x00000010ff4f7819ULL, 0x000fe40000011661ULL,
0x00000010ff5b7819ULL, 0x000fe40000011662ULL, 0x00000069ff66723eULL, 0x000fe400020006ffULL,
0x000010545c4f7816ULL, 0x000fe4000000004fULL, 0x000010545b4e7816ULL, 0x000fe2000000004eULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fc40000011659ULL,
0x00000010ff527819ULL, 0x000fe40000011658ULL, 0x00000010ff597819ULL, 0x000fe2000001165aULL,
0x0000004e1820723cULL, 0x000b620000041820ULL, 0x00000010ff517819ULL, 0x000fe4000001163eULL,
0x0000105459527816ULL, 0x000fe40000000052ULL, 0x000000ff51597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff547819ULL, 0x000fc40000011654ULL, 0x00000010ff4e7819ULL, 0x020fe40000011655ULL,
0x00000010ff4f7819ULL, 0x000fe40000011656ULL, 0x00000010ff517819ULL, 0x000fe40000011666ULL,
0x00001054544f7816ULL, 0x000fe4000000004fULL, 0x00001054514e7816ULL, 0x000fe4000000004eULL,
0x00000008ff507819ULL, 0x000fc40000011650ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff3b7819ULL, 0x000fe2000001163fULL, 0x0000004e181c723cULL, 0x000b62000004181cULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x20000060ff587230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000050ff55723eULL, 0x000fe400020006ffULL,
0x00000010ff1a7819ULL, 0x020fc4000001163dULL, 0x00000010ff187819ULL, 0x000fe4000001163cULL,
0x00000010ff197819ULL, 0x000fe40000011640ULL, 0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x000010541a197816ULL, 0x000fe40000000019ULL, 0x0000105441187816ULL, 0x000fe40000000018ULL,
0x0000ffff3e3e7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fe20000011657ULL, 0x20000063ff577230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe2000001164dULL, 0x20000055ff4d7230ULL, 0x000fe20000004100ULL,
0x0000003bff3c723eULL, 0x000fe200020006ffULL, 0x00000018142c723cULL, 0x000b62000004182cULL,
0x00000010ff1a7819ULL, 0x000fe40000011643ULL, 0x00000010ff3b7819ULL, 0x000fe20000011658ULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000008ff3e7819ULL, 0x000fc4000001163eULL,
0x00000008ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff197819ULL, 0x020fe40000011657ULL, 0x00000010ff187819ULL, 0x000fe40000011645ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x000010543b1a7816ULL, 0x000fc4000000001aULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fe200020006ffULL, 0x20000067ff5f7230ULL, 0x000fe20000004100ULL,
0x0000003fff3b723eULL, 0x000fe400020006ffULL, 0x0000105444197816ULL, 0x000fe20000000019ULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x000010544d187816ULL, 0x000fe20000000018ULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fc4000001164bULL,
0x00000010ff4b7819ULL, 0x000fe2000001164cULL, 0x20000059ff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe2000001164aULL, 0x000000181424723cULL, 0x000b620000041824ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff1b7819ULL, 0x000fe4000001165fULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff3f7819ULL, 0x000fc4000001164cULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff197819ULL, 0x020fe4000001163cULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff187819ULL, 0x000fc4000001163bULL,
0x000010545c537816ULL, 0x000fe40000000053ULL, 0x00001054504b7816ULL, 0x000fe4000000004bULL,
0x00001054514a7816ULL, 0x000fe4000000004aULL, 0x00001054421b7816ULL, 0x000fe2000000001bULL,
0x000000521434723cULL, 0x000b620000041834ULL, 0x00001054463f7816ULL, 0x000fe4000000003fULL,
0x000010543e3e7816ULL, 0x000fc40000000047ULL, 0x0000105448197816ULL, 0x000fe40000000019ULL,
0x0000105418187816ULL, 0x000fe20000000049ULL, 0x0000004a1430723cULL, 0x040b700000041830ULL,
0x0000001a1428723cULL, 0x040b700000041828ULL, 0x0000003e1420723cULL, 0x040b700000041820ULL,
0x00000018141c723cULL, 0x000b62000004181cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe7c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0008ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffda7000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000000630307220ULL, 0x0a0fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x080fe20000410000ULL, 0x000000062d2d7220ULL, 0x080fe20000410000ULL,
0x000000062c2c7220ULL, 0x080fe20000410000ULL, 0x0000000621217220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x00000006360f7220ULL, 0x080fe20000410000ULL,
0x000000062f177220ULL, 0x080fe20000410000ULL, 0x0000000637147220ULL, 0x080fe20000410000ULL,
0x0000000631387220ULL, 0x080fe20000410000ULL, 0x000000062e167220ULL, 0x080fe20000410000ULL,
0x0000000620367220ULL, 0x080fe20000410000ULL, 0x000000061f197220ULL, 0x080fe20000410000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0030ULL, 0x0000000632157220ULL, 0x080fe20000410000ULL,
0x0000000633397220ULL, 0x080fe20000410000ULL, 0x0000000610317220ULL, 0x080fe20000410000ULL,
0x00000006113c7220ULL, 0x080fe20000410000ULL, 0x0000000625377220ULL, 0x080fe20000410000ULL,
0x0000000622207220ULL, 0x080fe20000410000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0034ULL,
0x0000000612107220ULL, 0x080fe20000410000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0035ULL,
0x00000006133b7220ULL, 0x080fe20000410000ULL, 0x000000ffff307224ULL, 0x000fe200078e002dULL,
0x00000006283a7220ULL, 0x080fe20000410000ULL, 0x0000000629327220ULL, 0x080fe20000410000ULL,
0x000000062a117220ULL, 0x080fe20000410000ULL, 0x000000062b187220ULL, 0x080fe20000410000ULL,
0x0000000624337220ULL, 0x080fe20000410000ULL, 0x0000000626267220ULL, 0x080fe20000410000ULL,
0x0000000627277220ULL, 0x080fe20000410000ULL, 0x0000000623237220ULL, 0x080fe20000410000ULL,
0x000000061d257220ULL, 0x080fe20000410000ULL, 0x000000061e227220ULL, 0x000fe20000410000ULL,
0x000000ffff357224ULL, 0x000fc400078e002cULL, 0x000000ffff347224ULL, 0x000fe400078e0021ULL,
0x000000ffff2d7224ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000072127f8cULL, 0x0002a2000c80043fULL, 0x000000ffff217224ULL, 0x000fe400078e0023ULL,
0x000000ffff287224ULL, 0x000fe400078e000fULL, 0x000000ffff1e7224ULL, 0x000fe400078e0014ULL,
0x000000ffff297224ULL, 0x000fc400078e0015ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0016ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0017ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0018ULL,
0x000000ffff237224ULL, 0x000fc400078e0019ULL, 0x0000000000107805ULL, 0x002fca0000015200ULL,
0x00000400720f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x006fc40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011415ULL,
0x000000140f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x000000020f0f7819ULL, 0x000fc80000001214ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400720f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000405247824ULL, 0x000fe200078e00ffULL, 0x000000700700720cULL, 0x000fc80003f06070ULL,
0xfffffff0240f7812ULL, 0x000fca00078ec0ffULL, 0x000000800e0f7824ULL, 0x000fca00078e020fULL,
0x00f400000f107984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0x00000100073d7824ULL, 0x000fe400078e0273ULL, 0x00000002053e7824ULL, 0x000fe400078e00ffULL,
0x00000002ff537424ULL, 0x000fe200078e00ffULL, 0x0000003d0c147217ULL, 0x000fe40007800000ULL,
0x000000063e3e7812ULL, 0x000fc600078ec0ffULL, 0x00000001143d7824ULL, 0x000fe200078e0a3dULL,
0x0000000005147211ULL, 0x000fe200078ff0ffULL, 0x0000000109187824ULL, 0x000fe200078e023eULL,
0x000058003e407a10ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff167a19ULL, 0x000fe20000011614ULL,
0x00000001181a7824ULL, 0x140fe200078e0a3dULL, 0x0000003d1800720cULL, 0x000fe20003f26070ULL,
0x0000000140187824ULL, 0x000fe200078e0a3dULL, 0x0000001671167217ULL, 0x040fe40003800000ULL,
0x0000001a711a7217ULL, 0x000fc40003800000ULL, 0x0000003d4000720cULL, 0x000fe20003f06070ULL,
0x000000160d5a7224ULL, 0x000fe200078e02ffULL, 0x0000001871187217ULL, 0x000fe40003800000ULL,
0x00000004ff1a7819ULL, 0x000fe4000001161aULL, 0x000000ff184b7207ULL, 0x000fe40000000000ULL,
0x000000ff1a197207ULL, 0x000fe40000800000ULL, 0x0000005a4b167211ULL, 0x000fc400078fe0ffULL,
0x00000008141a7810ULL, 0x000fe20007ffe0ffULL, 0x000000015a187824ULL, 0x000fe200078e0219ULL,
0x000000103e467812ULL, 0x000fe200078efcffULL, 0x0000600016147625ULL, 0x080fe200078e0053ULL,
0x00005a00ff1a7a19ULL, 0x000fe4000001161aULL, 0x0000580046427a10ULL, 0x000fe20007ffe0ffULL,
0x0000600018167625ULL, 0x000fe200078e0053ULL, 0x0000001a711a7217ULL, 0x000fe20003800000ULL,
0x0000000814517981ULL, 0x0046a4000c1e9500ULL, 0x0000000109447824ULL, 0x000fc400078e0246ULL,
0x0000000816587981ULL, 0x0002a2000c1e9500ULL, 0x0000001a0d5c7224ULL, 0x000fe400078e02ffULL,
0x0000003d4400720cULL, 0x080fe40003f26070ULL, 0x0000003d4200720cULL, 0x040fe20003f06070ULL,
0x0000000142147824ULL, 0x108fe200078e0a3dULL, 0x0000005c4b187211ULL, 0x000fe200078fe0ffULL,
0x00000001191a7824ULL, 0x000fe400078e025cULL, 0x0000000144167824ULL, 0x002fe200078e0a3dULL,
0x000000203e447812ULL, 0x000fe200078efcffULL, 0x0000600018187625ULL, 0x000fe200078e0053ULL,
0x0000001471147217ULL, 0x000fc40003800000ULL, 0x00005800444a7a10ULL, 0x000fe20007ffe0ffULL,
0x000060001a1a7625ULL, 0x000fe200078e0053ULL, 0x000000ff143f7207ULL, 0x000fe20000000000ULL,
0x00000008184d7981ULL, 0x0002e2000c1e9500ULL, 0x0000001671167217ULL, 0x000fe20003800000ULL,
0x000000014a4e7824ULL, 0x040fe200078e0a3dULL, 0x0000005a3f147211ULL, 0x000fe200078fe0ffULL,
0x0000000109507824ULL, 0x000fe200078e0244ULL, 0x00000004ff167819ULL, 0x000fe20000011616ULL,
0x000000081a567981ULL, 0x0002e2000c1e9500ULL, 0x0000003d4a00720cULL, 0x000fe20003f06070ULL,
0x0000600014147625ULL, 0x000fe200078e0053ULL, 0x0000004e71457217ULL, 0x000fc40003800000ULL,
0x000000ff16197207ULL, 0x002fe20000800000ULL, 0x0000000150527824ULL, 0x000fe200078e0a3dULL,
0x000000ff45457207ULL, 0x000fe20000000000ULL, 0x0000000814417981ULL, 0x0002e2000c1e9500ULL,
0x000000303e4e7812ULL, 0x000fe200078efcffULL, 0x000000015a167824ULL, 0x000fe200078e0219ULL,
0x0000005c3f187211ULL, 0x000fe200078fe0ffULL, 0x00000001191a7824ULL, 0x000fe200078e025cULL,
0x0000005271527217ULL, 0x000fe20003800000ULL, 0x00000001095e7824ULL, 0x000fe200078e024eULL,
0x0000003d5000720cULL, 0x000fe20003f26070ULL, 0x0000600016167625ULL, 0x000fe200078e0053ULL,
0x0000005a45147211ULL, 0x002fc600078fe0ffULL, 0x0000600018187625ULL, 0x080fe200078e0053ULL,
0x00000004ff527819ULL, 0x000fe20000011652ULL, 0x0000000816487981ULL, 0x0002e4000c1e9500ULL,
0x000060001a1a7625ULL, 0x080fe200078e0053ULL, 0x000058004e507a10ULL, 0x000fe20007ffe0ffULL,
0x0000000818437981ULL, 0x0002e4000c1e9500ULL, 0x0000600014147625ULL, 0x000fe200078e0053ULL,
0x000000ff52497207ULL, 0x000fe20000800000ULL, 0x000000081a4c7981ULL, 0x0002e4000c1e9500ULL,
0x000000015e607824ULL, 0x000fc400078e0a3dULL, 0x0000000814477981ULL, 0x0002e4000c1e9500ULL,
0x000000015a167824ULL, 0x002fe200078e0249ULL, 0x0000005c45187211ULL, 0x000fe400078fe0ffULL,
0x0000006071607217ULL, 0x000fe20003800000ULL, 0x00000001491a7824ULL, 0x000fe400078e025cULL,
0x0000000150147824ULL, 0x040fe200078e0a3dULL, 0x0000003d5000720cULL, 0x000fe20003f06070ULL,
0x0000600016167625ULL, 0x000fe200078e0053ULL, 0x0000003d5e00720cULL, 0x000fc40003f26070ULL,
0x0000001471147217ULL, 0x000fe20003800000ULL, 0x0000600018187625ULL, 0x080fe200078e0053ULL,
0x00000004ff607819ULL, 0x000fe20000011660ULL, 0x0000000816527981ULL, 0x0002e4000c1e9500ULL,
0x000060001a1a7625ULL, 0x000fe200078e0053ULL, 0x000000ff144f7207ULL, 0x000fe20000000000ULL,
0x0000000818497981ULL, 0x0002e2000c1e9500ULL, 0x000000ff60557207ULL, 0x000fc60000800000ULL,
0x000000081a547981ULL, 0x0002e2000c1e9500ULL, 0x0000005a4f147211ULL, 0x000fe200078fe0ffULL,
0x000000015a167824ULL, 0x002fc800078e0255ULL, 0x0000600014147625ULL, 0x000fc800078e0053ULL,
0x0000600016167625ULL, 0x000fe400078e0053ULL, 0x0000000814147981ULL, 0x0002e2000c1e9500ULL,
0x0000005c4f187211ULL, 0x000fc600078fe0ffULL, 0x0000000816177981ULL, 0x0002e2000c1e9500ULL,
0x00000001551a7824ULL, 0x000fe400078e025cULL, 0x0000600018187625ULL, 0x000fc800078e0053ULL,
0x000060001a1a7625ULL, 0x000fe400078e0053ULL, 0x0000000818187981ULL, 0x0002e8000c1e9500ULL,
0x000000081a1b7981ULL, 0x0004e2000c1e9500ULL, 0xfffffff04b5a7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff4b7424ULL, 0x000fc800078e00ffULL, 0x000000013d157824ULL, 0x002fe200078e025aULL,
0x000000083e5a7812ULL, 0x000fc600078efcffULL, 0x0000000140627824ULL, 0x100fe200078e0a15ULL,
0x000000093e5e7812ULL, 0x000fe400078efcffULL, 0x000058005a5c7a10ULL, 0x000fe40007ffe0ffULL,
0x000000624b627219ULL, 0x000fe400000006ffULL, 0x000058005e167a10ULL, 0x000fe20007ffe0ffULL,
0x000000015c647824ULL, 0x000fc800078e0a15ULL, 0x0000000116667824ULL, 0x000fe200078e0a15ULL,
0x000000644b647219ULL, 0x000fe400000006ffULL, 0xfffffff03f537812ULL, 0x000fe400078ec0ffULL,
0x000000664b667219ULL, 0x000fe400000006ffULL, 0x000000183e7c7812ULL, 0x040fe200078efcffULL,
0x000000013d537824ULL, 0x000fe200078e0253ULL, 0x000000193e7a7812ULL, 0x000fc600078efcffULL,
0x00000001425b7824ULL, 0x000fe200078e0a53ULL, 0x000058007a197a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff045557812ULL, 0x000fc600078ec0ffULL, 0x0000000119617824ULL, 0x000fe400078e0a53ULL,
0x000000013d557824ULL, 0x000fe200078e0255ULL, 0x000000213e6a7812ULL, 0x000fc600078efcffULL,
0x000000014a637824ULL, 0x000fe200078e0a55ULL, 0x000000283e687812ULL, 0x000fe400078efcffULL,
0xfffffff04f4f7812ULL, 0x000fe400078ec0ffULL, 0x000000614b617219ULL, 0x000fe400000006ffULL,
0x000058006a787a10ULL, 0x000fe20007ffe0ffULL, 0x000000013d577824ULL, 0x000fe200078e024fULL,
0x0000580068767a10ULL, 0x000fc60007ffe0ffULL, 0x0000000178657824ULL, 0x100fe400078e0a55ULL,
0x0000000176677824ULL, 0x000fe400078e0a55ULL, 0x0000000150597824ULL, 0x000fca00078e0a57ULL,
0x000000594b597219ULL, 0x000fe400000006ffULL, 0x0000541051517816ULL, 0x004fe40000000058ULL,
0x000000013e587812ULL, 0x000fe400078efcffULL, 0x0000005162ff7212ULL, 0x000fe4000780c0ffULL,
0x0000580058607a10ULL, 0x000fe40007ffe0ffULL, 0x0000003d4000720cULL, 0x000fc60000701470ULL,
0x00000001601a7824ULL, 0x000fe200078e0a15ULL, 0x0000003d3e00720cULL, 0x040fe40000701070ULL,
0x000000113e157812ULL, 0x000fe400078efcffULL, 0x0000001a4b1a7219ULL, 0x000fe400000006ffULL,
0x0000005164ff7212ULL, 0x080fe4000784c0ffULL, 0x000000511aff7212ULL, 0x000fe4000786c0ffULL,
0x000054104d4d7816ULL, 0x008fc40000000056ULL, 0x0000005166ff7212ULL, 0x000fe4000782c0ffULL,
0xff8000001f1f7808ULL, 0x000fe40000000000ULL, 0x0000004d62ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004d1aff7212ULL, 0x080fe400078ac0ffULL, 0x0000004d64ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004d66ff7212ULL, 0x000fc4000780c0ffULL, 0x0000580015517a10ULL, 0x000fe40007ffe0ffULL,
0x000058007c4d7a10ULL, 0x000fe40007ffe0ffULL, 0x0000003d4000720cULL, 0x080fe20002781470ULL,
0x00000001515d7824ULL, 0x100fe200078e0a53ULL, 0x0000003d5c00720cULL, 0x080fe200037c1470ULL,
0x000000014d5f7824ULL, 0x000fe200078e0a53ULL, 0x0000003d1600720cULL, 0x000fe40000701470ULL,
0x0000005b4b537219ULL, 0x000fc400000006ffULL, 0x0000005d4b5b7219ULL, 0x040fe400000006ffULL,
0x0000003d3e00720cULL, 0x080fe40002781070ULL, 0x0000003d5a00720cULL, 0x080fe400037c1070ULL,
0x0000003d5e00720cULL, 0x000fe40000701070ULL, 0x0000005f4b5d7219ULL, 0x000fe400000006ffULL,
0x0000541041487816ULL, 0x000fc40000000048ULL, 0x00005410434c7816ULL, 0x000fe4000000004cULL,
0x0000003d1600720cULL, 0x000fe40000f21470ULL, 0xff80000028287808ULL, 0x000fe40002000000ULL,
0xff80000029297808ULL, 0x000fe40003000000ULL, 0xff80000039397808ULL, 0x000fe40000000000ULL,
0x0000004853ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004c53ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004c5dff7212ULL, 0x000fe4000780c0ffULL, 0x0000003d5e00720cULL, 0x080fe40000f21070ULL,
0x0000003d6000720cULL, 0x0c0fe40001f61470ULL, 0x0000003d6000720cULL, 0x080fe40002fa1470ULL,
0x0000003d5c00720cULL, 0x000fc40001741470ULL, 0x0000003d4200720cULL, 0x0c0fe40002781470ULL,
0x0000003d4200720cULL, 0x080fe400037c1470ULL, 0x0000003d4d00720cULL, 0x080fe40000701470ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0x000000293e667812ULL, 0x000fe400078efcffULL,
0x0000003d5800720cULL, 0x000fc40001f61070ULL, 0x0000003d5800720cULL, 0x080fe40002fa1070ULL,
0x0000003d5a00720cULL, 0x080fe40001741070ULL, 0x0000003d4600720cULL, 0x0c0fe40002721070ULL,
0x0000003d4600720cULL, 0x080fe400037c1070ULL, 0x0000003d7c00720cULL, 0x000fe40000701070ULL,
0x000000634b5f7219ULL, 0x000fc400000006ffULL, 0x0000541047527816ULL, 0x000fe40000000052ULL,
0x0000541049547816ULL, 0x000fe40000000054ULL, 0x00005800666c7a10ULL, 0x000fe40007ffe0ffULL,
0xff8000002e2e7808ULL, 0x000fe40001800000ULL, 0xff8000001e1e7808ULL, 0x000fe40002800000ULL,
0xff8000002f2f7808ULL, 0x000fc40001000000ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff8000002b2b7808ULL, 0x000fe40003000000ULL, 0xff8000002c2c7808ULL, 0x000fe40000000000ULL,
0x000000485bff7212ULL, 0x080fe4000786c0ffULL, 0x000000485dff7212ULL, 0x080fe400078ac0ffULL,
0x0000004861ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004c5bff7212ULL, 0x080fe4000788c0ffULL,
0x0000004c61ff7212ULL, 0x000fe4000782c0ffULL, 0x000000525fff7212ULL, 0x040fe400078cc0ffULL,
0x000000545fff7212ULL, 0x000fe2000780c0ffULL, 0x000000016c697824ULL, 0x000fe200078e0a55ULL,
0x0000003d5100720cULL, 0x0c0fe40001f61470ULL, 0x0000003d5100720cULL, 0x000fc40002781470ULL,
0x0000003d4d00720cULL, 0x080fe40002fa1470ULL, 0x0000003d1900720cULL, 0x0c0fe40001741470ULL,
0x0000003d1900720cULL, 0x080fe40000f21470ULL, 0x0000003d4a00720cULL, 0x0c0fe400037c1470ULL,
0x0000003d4a00720cULL, 0x000fe40000701470ULL, 0x000000313e627812ULL, 0x000fc400078efcffULL,
0x000000383e567812ULL, 0x040fe400078efcffULL, 0x000000393e1a7812ULL, 0x000fe400078efcffULL,
0x000000654b637219ULL, 0x000fe400000006ffULL, 0x0000003d1500720cULL, 0x0c0fe40001f61070ULL,
0x0000003d1500720cULL, 0x080fe40002781070ULL, 0x0000003d7c00720cULL, 0x000fc40002fa1070ULL,
0x0000003d7a00720cULL, 0x0c0fe40001741070ULL, 0x0000003d7a00720cULL, 0x080fe40000f21070ULL,
0x0000003d4400720cULL, 0x0c0fe400037c1070ULL, 0x0000003d4400720cULL, 0x000fe40000701070ULL,
0x000000674b657219ULL, 0x040fe400000006ffULL, 0x000000694b697219ULL, 0x000fc400000006ffULL,
0x0000541014147816ULL, 0x000fe40000000017ULL, 0x0000580062647a10ULL, 0x000fe40007ffe0ffULL,
0x00005800563f7a10ULL, 0x000fe40007ffe0ffULL, 0x000058001a457a10ULL, 0x000fe40007ffe0ffULL,
0xff80000030307808ULL, 0x000fe40001800000ULL, 0xff8000002a2a7808ULL, 0x000fc40002000000ULL,
0xff80000031317808ULL, 0x000fe40002800000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0xff8000003a3a7808ULL, 0x000fe40003000000ULL,
0xff8000001d1d7808ULL, 0x000fe40000000000ULL, 0x0000005263ff7212ULL, 0x000fc4000786c0ffULL,
0x0000005265ff7212ULL, 0x080fe4000788c0ffULL, 0x0000005269ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005463ff7212ULL, 0x080fe4000784c0ffULL, 0x0000005465ff7212ULL, 0x080fe4000782c0ffULL,
0x0000005469ff7212ULL, 0x000fe400078cc0ffULL, 0x0000001459ff7212ULL, 0x000fe2000780c0ffULL,
0x0000000164557824ULL, 0x100fe200078e0a57ULL, 0x0000003d7800720cULL, 0x0c0fe20001f61470ULL,
0x000000013f4f7824ULL, 0x100fe200078e0a57ULL, 0x0000003d7800720cULL, 0x080fe20001741470ULL,
0x0000000145577824ULL, 0x000fe200078e0a57ULL, 0x0000003d7600720cULL, 0x000fc40002781470ULL,
0x0000003d7600720cULL, 0x080fe40000f21470ULL, 0x0000003d6c00720cULL, 0x0c0fe40002fa1470ULL,
0x0000003d6c00720cULL, 0x080fe400037c1470ULL, 0x0000003d5000720cULL, 0x080fe40000701470ULL,
0x0000003d6a00720cULL, 0x0c0fe40001f61070ULL, 0x0000003d6a00720cULL, 0x000fc40001741070ULL,
0x0000003d6800720cULL, 0x0c0fe40002781070ULL, 0x0000003d6800720cULL, 0x080fe40000f21070ULL,
0x0000003d6600720cULL, 0x0c0fe40002fa1070ULL, 0x0000003d6600720cULL, 0x080fe400037c1070ULL,
0x0000003d4e00720cULL, 0x000fe40000701070ULL, 0x000000554b557219ULL, 0x000fc400000006ffULL,
0x0000004f4b4f7219ULL, 0x040fe400000006ffULL, 0x000000574b577219ULL, 0x000fe400000006ffULL,
0x0000541018187816ULL, 0x000fe4000000001bULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff80000033337808ULL, 0x000fc40002000000ULL,
0xff80000026267808ULL, 0x000fe40000800000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0xff80000027277808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0x0000001455ff7212ULL, 0x080fe4000786c0ffULL, 0x000000144fff7212ULL, 0x000fc4000784c0ffULL,
0x0000001457ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001859ff7212ULL, 0x080fe4000782c0ffULL,
0x0000001855ff7212ULL, 0x080fe400078ac0ffULL, 0x000000184fff7212ULL, 0x080fe400078cc0ffULL,
0x0000001857ff7212ULL, 0x000fe4000780c0ffULL, 0x0000003d5000720cULL, 0x000fc40000f21470ULL,
0x0000003d6400720cULL, 0x0c0fe40001f61470ULL, 0x0000003d6400720cULL, 0x080fe40002fa1470ULL,
0x0000003d3f00720cULL, 0x0c0fe40001741470ULL, 0x0000003d3f00720cULL, 0x080fe400037c1470ULL,
0x0000003d4500720cULL, 0x0c0fe40002781470ULL, 0x0000003d4500720cULL, 0x000fc40000701470ULL,
0x0000003d4e00720cULL, 0x080fe40000f21070ULL, 0x0000003d6200720cULL, 0x0c0fe40001f61070ULL,
0x0000003d6200720cULL, 0x080fe40002fa1070ULL, 0x0000003d5600720cULL, 0x0c0fe40001741070ULL,
0x0000003d5600720cULL, 0x080fe400037c1070ULL, 0x0000003d1a00720cULL, 0x000fc40002781070ULL,
0x0000003d1a00720cULL, 0x000fe40000701070ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff80000020207808ULL, 0x000fe40000800000ULL, 0xff80000021217808ULL, 0x000fc40002800000ULL,
0xff80000022227808ULL, 0x000fe40003000000ULL, 0xff80000023237808ULL, 0x000fc40000000000ULL,
0x0000001f1000720bULL, 0x004fe20003f1e000ULL, 0x0000001fff187424ULL, 0x000fe200078e00ffULL,
0x000000281100720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x000000101f157208ULL, 0x000fe40004000000ULL, 0x0000001128117208ULL, 0x000fe40004800000ULL,
0x0000002e1500720bULL, 0x000fc40003f1e000ULL, 0x0000001e1100720bULL, 0x000fe40003f3e000ULL,
0x000000152e107208ULL, 0x000fe40004000000ULL, 0x000000111e147208ULL, 0x000fe40004800000ULL,
0x0000002f1000720bULL, 0x000fe40003f1e000ULL, 0x000000291400720bULL, 0x000fe40003f3e000ULL,
0x000000102f117208ULL, 0x000fc40004000000ULL, 0x0000001429147208ULL, 0x000fe40004800000ULL,
0x000000381100720bULL, 0x000fe40003f1e000ULL, 0x000000391400720bULL, 0x000fe40003f3e000ULL,
0x0000001138107208ULL, 0x000fe40004000000ULL, 0x0000001439147208ULL, 0x000fe40004800000ULL,
0x000000351000720bULL, 0x000fc40003f1e000ULL, 0x0000002b1400720bULL, 0x000fe40003f3e000ULL,
0x0000001035117208ULL, 0x000fe40004000000ULL, 0x000000142b157208ULL, 0x000fe40004800000ULL,
0x000000301100720bULL, 0x000fe40003f1e000ULL, 0x0000002a1500720bULL, 0x000fe40003f3e000ULL,
0x0000001130107208ULL, 0x000fc40004000000ULL, 0x000000152a157208ULL, 0x000fe40004800000ULL,
0x000000311000720bULL, 0x000fe40003f1e000ULL, 0x0000002c1500720bULL, 0x000fe40003f3e000ULL,
0x0000001031117208ULL, 0x000fe40004000000ULL, 0x000000152c107208ULL, 0x000fe40004800000ULL,
0x0000003c1100720bULL, 0x000fc40003f1e000ULL, 0x0000003b1000720bULL, 0x000fe40003f3e000ULL,
0x000000113c117208ULL, 0x000fe40004000000ULL, 0x000000103b107208ULL, 0x000fe40004800000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x0000001d1000720bULL, 0x000fe40003f3e000ULL,
0x000000113a117208ULL, 0x000fc40004000000ULL, 0x000000101d157208ULL, 0x000fe40004800000ULL,
0x000000321100720bULL, 0x000fe40003f1e000ULL, 0x0000001c1500720bULL, 0x000fe40003f3e000ULL,
0x0000001132107208ULL, 0x000fe40004000000ULL, 0x000000151c157208ULL, 0x000fe40004800000ULL,
0x000000331000720bULL, 0x000fc40003f1e000ULL, 0x000000261500720bULL, 0x000fe40003f3e000ULL,
0x0000001033107208ULL, 0x000fe40004000000ULL, 0x0000001526147208ULL, 0x000fe40004800000ULL,
0x000000371000720bULL, 0x000fe40003f1e000ULL, 0x000000271400720bULL, 0x000fe40003f3e000ULL,
0x0000001037117208ULL, 0x000fc40004000000ULL, 0x0000001427157208ULL, 0x000fe40004800000ULL,
0x000000361100720bULL, 0x000fe40003f1e000ULL, 0x000000201500720bULL, 0x000fe40003f3e000ULL,
0x0000001136117208ULL, 0x000fe40004000000ULL, 0x0000001520107208ULL, 0x000fe40004800000ULL,
0x000000341100720bULL, 0x000fc40003f1e000ULL, 0x000000211000720bULL, 0x000fe40003f3e000ULL,
0x0000001134147208ULL, 0x000fe40004000000ULL, 0x0000001021117208ULL, 0x000fe40004800000ULL,
0x0000002d1400720bULL, 0x000fe40003f1e000ULL, 0x000000221100720bULL, 0x000fe40003f3e000ULL,
0x000000142d147208ULL, 0x000fc40004000000ULL, 0x0000001122107208ULL, 0x000fe40004800000ULL,
0x000000251400720bULL, 0x000fe40003f1e000ULL, 0x000000231000720bULL, 0x000fe40003f3e000ULL,
0x0000001425167208ULL, 0x000fe40004000000ULL, 0x0000001023197208ULL, 0x000fe20004800000ULL,
0x000014727f007947ULL, 0x000fec000b800000ULL, 0x0c401f0016107f89ULL, 0x0004e400000e0000ULL,
0x000000101600720bULL, 0x008fc80003f1e000ULL, 0x00000016101b7208ULL, 0x000fe20004000000ULL,
0x000014827f007947ULL, 0x000fea000b800000ULL, 0x0c401f0019107f89ULL, 0x000ee800000e0000ULL,
0x0c401f0012117f89ULL, 0x000e6800000e0000ULL, 0x0c401f0013167f89ULL, 0x006e6200000e0000ULL,
0x000000101900720bULL, 0x008fc40003f1e000ULL, 0x000000111200720bULL, 0x000fe40003f3e000ULL,
0x0000001910147208ULL, 0x000fe40004000000ULL, 0x0000001211157208ULL, 0x000fe20004800000ULL,
0x0c201f001b107f89ULL, 0x000ea200000e0000ULL, 0x000000161300720bULL, 0x002fc60003f1e000ULL,
0x0c201f0014117f89ULL, 0x000e6200000e0000ULL, 0x00000013163d7208ULL, 0x000fc60004000000ULL,
0x0c201f0015187f89ULL, 0x000ee800000e0000ULL, 0x0c201f003d3e7f89ULL, 0x0002e200000e0000ULL,
0x000000101b00720bULL, 0x004fe40003f1e000ULL, 0x000000111400720bULL, 0x002fe40003f3e000ULL,
0x0000001b10107208ULL, 0x000fe40004000000ULL, 0x000000181500720bULL, 0x008fc40003f5e000ULL,
0x0000001411117208ULL, 0x000fe40004800000ULL, 0x0000001518127208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b10137820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c24247812ULL, 0x000fe400078ec0ffULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010813ULL, 0x0000002f00167308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b311a7823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b3a317823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010813ULL, 0x0000002e00157308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b342f7823ULL, 0x102fe20000010813ULL, 0x3fb8aa3b11347820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b37377823ULL, 0x000fe20000010813ULL, 0x0000000305ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010834ULL,
0x0000001f00147308ULL, 0x000e620000000800ULL, 0x3fb8aa3b362e7823ULL, 0x008fe20000010813ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b27277823ULL, 0x000fe20000010834ULL, 0x0000003e3d00720bULL, 0x004fe20003f3e000ULL,
0x0000003800177308ULL, 0x000eb00000000800ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000141514723eULL, 0x002fce00000010ffULL, 0x0000001e001f7308ULL, 0x000e620000000800ULL,
0x000000161716723eULL, 0x004fce00000010ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000003900367308ULL, 0x000ea20000000800ULL, 0x000000281f15723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b1d287823ULL, 0x000fcc0000010834ULL, 0x0000003000197308ULL, 0x0003f00000000800ULL,
0x0000003500187308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b2d307823ULL, 0x002fe20000010813ULL,
0x3fb8aa3b2c2d7823ULL, 0x100fe20000010834ULL, 0x00000004ff2c7e24ULL, 0x000fe2000f8e00ffULL,
0x000000293617723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b1c297823ULL, 0x100fe20000010834ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000002ff367819ULL, 0x000fe20000011605ULL,
0x0000002d00357308ULL, 0x0003e20000000800ULL, 0x3f8000002c2c783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b25137823ULL, 0x000fe20000010813ULL, 0x3fb8aa3b20257823ULL, 0x000fe20000010834ULL,
0x0000000136207810ULL, 0x000fc40007ffe0ffULL, 0x000000ffff407224ULL, 0x100fe200078e002cULL,
0x00000008363f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000ffff2d7224ULL, 0x102fe200078e002cULL, 0x000000181918723eULL, 0x008fe200000010ffULL,
0x000000ffff417224ULL, 0x000fca00078e002cULL, 0x0000003c001b7308ULL, 0x000e620000000800ULL,
0x0000002c141c723cULL, 0x000f6e00000418ffULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000ea20000000800ULL, 0x0000001a1b1a723eULL, 0x002fce00000010ffULL,
0x0000003b003a7308ULL, 0x0002e20000000800ULL, 0x0000002b2a19723eULL, 0x004fce00000010ffULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b212a7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b222b7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b23347823ULL, 0x000fe20000010834ULL,
0x000000ffff3b7224ULL, 0x002fe200078e002cULL, 0x000000353a1b723eULL, 0x008fc600000010ffULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000ffff3a7224ULL, 0x000fc600078e002cULL,
0x0000002c181c723cULL, 0x020b68000004181cULL, 0x0000003300337308ULL, 0x000fe60000000800ULL,
0x00000008362d7824ULL, 0x020fca00078e00ffULL, 0x0000003700387308ULL, 0x0004e20000000800ULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee220ULL, 0x000000313220723eULL, 0x002fe200000010ffULL,
0x0000000836327824ULL, 0x000fc800078e00ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000000836377824ULL, 0x004fce00078e00ffULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000333822723eULL, 0x008fe200000010ffULL, 0x0000000836337824ULL, 0x040fe400078e00ffULL,
0x0000000836387824ULL, 0x000fc800078e00ffULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x000000282921723eULL, 0x002fe400000010ffULL,
0x0000000336287810ULL, 0x000fc40007ffe0ffULL, 0x0000000436297810ULL, 0x000fe40007ffe0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee228ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0xfffffff838357812ULL, 0x000fe400078ee229ULL, 0x0000000536287810ULL, 0x040fe40007ffe0ffULL,
0x0000000636297810ULL, 0x000fe40007ffe0ffULL, 0xfffffff837377812ULL, 0x000fe200078ee228ULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x000000262723723eULL, 0x004fc400000010ffULL,
0x0000000236277810ULL, 0x000fe40007ffe0ffULL, 0xfffffff832397812ULL, 0x040fe400078ee229ULL,
0xfffffff832317812ULL, 0x000fe200078ee227ULL, 0x0000003a201c723cULL, 0x000b62000004181cULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x0000000836277824ULL, 0x000fca00078e00ffULL,
0x00000008363b7824ULL, 0x020fe200078e00ffULL, 0x0000002e2f28723eULL, 0x002fe200000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0xfffffff827277812ULL, 0x000fe400078ee236ULL,
0x000090000e2e7811ULL, 0x000fca00078e58ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000001027277824ULL, 0x100fe400078e022eULL, 0x000000102d2d7824ULL, 0x100fe400078e022eULL,
0x0000001031317824ULL, 0x100fe400078e022eULL, 0x0000001033337824ULL, 0x100fe200078e022eULL,
0x0000002a00267308ULL, 0x0004e20000000800ULL, 0x0000001035357824ULL, 0x000fe400078e022eULL,
0x0000000127277824ULL, 0x000fc400078e0224ULL, 0x0000001037377824ULL, 0x100fe400078e022eULL,
0x00000001242d7824ULL, 0x000fe200078e022dULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0xffffffff362a7810ULL, 0x004fe20007ffe0ffULL, 0x000000083f367824ULL, 0x000fe200078e00ffULL,
0x0000001427007388ULL, 0x0005e20000000800ULL, 0x0000001039397824ULL, 0x000fe200078e022eULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee22aULL, 0x0000000124317824ULL, 0x000fe200078e0231ULL,
0x00000030132a723eULL, 0x002fe200000010ffULL, 0x0000003400347308ULL, 0x000e620000000800ULL,
0x000000252629723eULL, 0x008fe200000010ffULL, 0x000000103b3b7824ULL, 0x100fe200078e022eULL,
0xfffffff8363f7812ULL, 0x000fe200078ee23fULL, 0x0000000124337824ULL, 0x040fe200078e0233ULL,
0x000000162d007388ULL, 0x0005e20000000800ULL, 0x0000000124357824ULL, 0x000fe200078e0235ULL,
0x0000003d3e137208ULL, 0x000fe20004800000ULL, 0x000000103f3f7824ULL, 0x000fe200078e022eULL,
0x0000001831007388ULL, 0x0005e20000000800ULL, 0x0000000124377824ULL, 0x000fc400078e0237ULL,
0x0000000124397824ULL, 0x040fe200078e0239ULL, 0x0000001a33007388ULL, 0x0005e20000000800ULL,
0x00000001243b7824ULL, 0x000fe200078e023bULL, 0x0000002b342b723eULL, 0x002fe200000010ffULL,
0x0000000124247824ULL, 0x000fe200078e023fULL, 0x0000002035007388ULL, 0x0005e80000000800ULL,
0x0000002237007388ULL, 0x0005e20000000800ULL, 0x00000040281c723cULL, 0x000f66000004181cULL,
0x0000002839007388ULL, 0x0005e80000000800ULL, 0x0000002a3b007388ULL, 0x0005e80000000800ULL,
0x0000001524007388ULL, 0x0005e80000000800ULL, 0x000400172d007388ULL, 0x0005e80000000800ULL,
0x0004001931007388ULL, 0x0005e80000000800ULL, 0x0004001b33007388ULL, 0x0005e20000000800ULL,
0x000000ffff1d7224ULL, 0x020fc600078e001eULL, 0x0004002135007388ULL, 0x0005e80000000800ULL,
0x0004002337007388ULL, 0x0005e80000000800ULL, 0x0004002939007388ULL, 0x0005e80000000800ULL,
0x0004002b3b007388ULL, 0x0005e80000000800ULL, 0x00f000100f008388ULL, 0x0005e80000000c00ULL,
0x00f2001c0f008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000074ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080074ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100074ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000107077810ULL, 0x000fe20007ffe0ffULL, 0x0000180074ff7f8cULL, 0x0003e6000c80043fULL,
0x0000000a0700720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffae4000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff127807ULL, 0x008fe40004000000ULL, 0x0001495000367802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x014fea0003c00000ULL, 0xfffedc3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x000fe40005000000ULL, 0x0001499000367802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0012ULL,
0xfffedc8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0035ULL,
0x000149e000377802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x014fea0003c00000ULL,
0xfffedd7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0035ULL,
0x00014a2000377802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x016fea0003c00000ULL,
0xfffede9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0009ULL,
0x00014a7000377802ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fc400078e0010ULL,
0x00000a5000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0012ULL,
0xfffee2b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0009ULL,
0x00014ac000377802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0012ULL, 0xfffee29000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x008fe40004000000ULL, 0x00014b1000367802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x004fea0003c00000ULL, 0xffff09f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x000fe40005000000ULL, 0x00014b5000367802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0012ULL,
0xffff0a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x00014ba000377802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x004fea0003c00000ULL,
0xffff0b3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x00014be000377802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x006fea0003c00000ULL,
0xffff0c5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0000ULL,
0x00014c3000377802ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fc400078e0015ULL,
0x0000089000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0012ULL,
0xffff108000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0000ULL,
0x00014c8000377802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0012ULL, 0xffff106000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x008fe40004000000ULL, 0x00014cd000367802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x014fea0003c00000ULL, 0xffff35d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x000fe40005000000ULL, 0x00014d1000367802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0012ULL,
0xffff362000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e003eULL,
0x00014d6000377802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x014fea0003c00000ULL,
0xffff371000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e003eULL,
0x00014da000377802ULL, 0x000fc40000000f00ULL, 0x0000072000007944ULL, 0x016fea0003c00000ULL,
0xffff383000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x00014df000377802ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fc400078e0039ULL,
0x000006d000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0012ULL,
0xffff3c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x00014e4000377802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0012ULL, 0xffff3c4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x004fe40004000000ULL, 0x00014e9000367802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x018fea0003c00000ULL, 0xffff622000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x000fe40005000000ULL, 0x00014ed000367802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0012ULL,
0xffff627000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e001eULL,
0x00014f2000377802ULL, 0x000fc40000000f00ULL, 0x000005a000007944ULL, 0x018fea0003c00000ULL,
0xffff636000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e001eULL,
0x00014f6000377802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x01afea0003c00000ULL,
0xffff648000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0006ULL,
0x00014fb000377802ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fc400078e000fULL,
0x0000051000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0012ULL,
0xffff693000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0006ULL,
0x0001500000377802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0012ULL, 0xffff691000007947ULL, 0x000fea000383ffffULL,
0x00000002ff177424ULL, 0x000fe200078e00ffULL, 0x0001505000147802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e003eULL,
0xffffeb5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x006fe200078e0019ULL,
0x000150b000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x0000003e1900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e0012ULL, 0x0001511000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff177424ULL, 0x000fe200078e00ffULL, 0x000000193e117208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000003e1200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e0013ULL, 0x0001517000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff177424ULL, 0x000fe200078e00ffULL, 0x000000123e197208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000003e1300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e001bULL, 0x000151d000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x000000133e3d7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000003e1b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e0011ULL, 0x0001523000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x0000001b3e107208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000003e1100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e0019ULL, 0x0001529000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x000000113e117208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000003e1900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e003dULL, 0x000152f000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x000000193e127208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffea2000007947ULL, 0x000fea000383ffffULL,
0x0180000011007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000001100008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff11ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000011027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000001100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffeab8002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff157424ULL, 0x000fe200078e00ffULL, 0x0000003f00007348ULL, 0x000fe80003800000ULL,
0x0c000017163e7389ULL, 0x0002a200000e0018ULL, 0xfffeab4014007950ULL, 0x000fea0003c3ffffULL,
0x0000007100007348ULL, 0x000fe80003800000ULL, 0x0000001236127389ULL, 0x0002a400000e0072ULL,
0x000000ffff367224ULL, 0x002fc400078e0037ULL, 0x00000000ff377424ULL, 0x000fc800078e00ffULL,
0xfffeaaf036007950ULL, 0x000fea0003c3ffffULL, 0x000000011200780cULL, 0x000fe20003f45070ULL,
0x00000000ff377424ULL, 0x000fe200078e00ffULL, 0x0000007000007348ULL, 0x000ff60003800000ULL,
0x0000000000127806ULL, 0x000fc800050e0100ULL, 0x0000007012127212ULL, 0x000fe200078ec0ffULL,
0xfffeaa9036007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000360ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d58ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e18ULL, 0x00000000000007bcULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015d8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015e8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001678ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000167cULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000015600ULL, 0x7f00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016e80ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016ed0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017250ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001678ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015808ULL, 0x0000000000015808ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017250ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_89_cubin_len = 95024;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
