/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016940ULL, 0x00000000000165c0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x0000000000014f40ULL, 0x0000000000000240ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000015180ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00014f4000000000ULL, 0x0001080400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x00014f4000000000ULL, 0x0000024000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x000823040000007fULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000e000942804ULL, 0x00000960000002c0ULL,
0x000028a000002820ULL, 0x00002ab000002970ULL, 0x0000300000002ff0ULL, 0x00005420000053c0ULL,
0x0000566000005520ULL, 0x00005a7000005a60ULL, 0x00007dc000007d60ULL, 0x0000800000007ec0ULL,
0x0000841000008400ULL, 0x0000a7b00000a750ULL, 0x0000a9f00000a8b0ULL, 0x0000af000000aef0ULL,
0x0000c8600000c850ULL, 0x000143f000014340ULL, 0x000146d000014620ULL, 0x00014a30000149a0ULL,
0x00014c4000014b50ULL, 0x0000047004303904ULL, 0x00017600000000ffULL, 0x0000055000040100ULL,
0x0001760800000000ULL, 0x00000660003f0100ULL, 0x0001768800000000ULL, 0x00000790003f0100ULL,
0x000176a800000003ULL, 0x000008a0003f0100ULL, 0x000176c800000002ULL, 0x00000e00003f0100ULL,
0x00017600000000ffULL, 0x00000f80000a0107ULL, 0x0001768800000000ULL, 0x00001870003f0101ULL,
0x00000000000000ffULL, 0x000018a000040107ULL, 0x00000000000000ffULL, 0x0000192000040101ULL,
0x0000002000000002ULL, 0x00001a70003f0101ULL, 0x000176c800000017ULL, 0x00001c00000a0109ULL,
0x000176c800000035ULL, 0x000024d0003f0109ULL, 0x000176b000000034ULL, 0x000025a0000a0107ULL,
0x000176b000000056ULL, 0x000025b0003f0101ULL, 0x000176080000004cULL, 0x000025d0003f0101ULL,
0x000176080000004cULL, 0x00002740003f0109ULL, 0x000176080000004cULL, 0x00002c70003f0109ULL,
0x000176a80000003cULL, 0x00002df0000a0109ULL, 0x000176a800000036ULL, 0x00004770003f0109ULL,
0x000176c800000034ULL, 0x00004790003f0101ULL, 0x0001768800000052ULL, 0x000047c0000a0101ULL,
0x0000000000000044ULL, 0x00004930003f0109ULL, 0x0000000000000044ULL, 0x00005120003f0109ULL,
0x000176a800000014ULL, 0x00005170000a0107ULL, 0x000176a800000052ULL, 0x00005180003f0101ULL,
0x000176280000004cULL, 0x000051a0003f0101ULL, 0x000176280000004cULL, 0x00005310003f0109ULL,
0x000176280000004cULL, 0x00005830003f0109ULL, 0x000176b000000017ULL, 0x000059b0000a0109ULL,
0x000176b000000037ULL, 0x00007100003f0109ULL, 0x000176c800000034ULL, 0x00007110003f0101ULL,
0x0001769000000036ULL, 0x00007140000a0101ULL, 0x0000000000000044ULL, 0x000072b0003f0109ULL,
0x0000000000000044ULL, 0x00007a40003f0109ULL, 0x00000008000000ffULL, 0x00007b1000040107ULL,
0x0000000800000054ULL, 0x00007b20003f0101ULL, 0x000176480000004cULL, 0x00007b40003f0101ULL,
0x000176480000004cULL, 0x00007cb0003f0109ULL, 0x000176480000004cULL, 0x000081d0003f0109ULL,
0x000176a800000017ULL, 0x00008350000a0109ULL, 0x000176a800000037ULL, 0x00009b10003f0109ULL,
0x000176c800000034ULL, 0x00009b30003f0101ULL, 0x0001769800000036ULL, 0x00009b60003f0101ULL,
0x0000000000000044ULL, 0x00009cd0003f0109ULL, 0x0000000000000044ULL, 0x0000a4c0003f0109ULL,
0x00000000000000ffULL, 0x0000a51000040107ULL, 0x000176a800000014ULL, 0x0000a520003f0101ULL,
0x0001766800000006ULL, 0x0000a550003f0101ULL, 0x0001766800000006ULL, 0x0000a6c0003f0109ULL,
0x0001766800000006ULL, 0x0000abb0003f0109ULL, 0x000176b00000003fULL, 0x0000ad70003f0109ULL,
0x000176b00000003fULL, 0x0000c5a0003f0109ULL, 0x000176a800000014ULL, 0x0000c670003f0101ULL,
0x000176a000000014ULL, 0x0000d7b0003f0101ULL, 0x00017600000000ffULL, 0x0000f0c0000a0101ULL,
0x00017600000000ffULL, 0x0000f230000a0109ULL, 0x00017600000000ffULL, 0x0000f410000a0109ULL,
0x00017600000000ffULL, 0x0000f430000a0101ULL, 0x00017600000000ffULL, 0x0000f5a0000a0109ULL,
0x00017600000000ffULL, 0x00012990000a0109ULL, 0x0001768800000009ULL, 0x00012b60003f0101ULL,
0x0001768800000009ULL, 0x00012cd0003f0109ULL, 0x0001768800000009ULL, 0x00014ee0003f0109ULL,
0x000176080000000aULL, 0x00014ef0003f0101ULL, 0x000176100000000aULL, 0x00014f00003f0101ULL,
0x000176180000000aULL, 0x00014f10003f0101ULL, 0x000176200000000aULL, 0x00053803003f0101ULL,
0x0000d0d000201c04ULL, 0x0000d2f00000d130ULL, 0x0000d5e00000d450ULL, 0x0000f5d00000d6e0ULL,
0x000c050400014f30ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL,
0x0000001800080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001700000002ULL,
0x0000000000014f40ULL, 0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff047b82ULL, 0x000ea20000000a00ULL,
0x00000000000b7919ULL, 0x000ee20000002200ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x0000000000097919ULL, 0x000f2a0000002100ULL, 0x00000400ff067b82ULL, 0x000f620000000800ULL,
0x0000000000407919ULL, 0x000ea20000002600ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000157919ULL, 0x000eaa0000002700ULL, 0x00008600ff0a7b82ULL, 0x000ee20000000800ULL,
0x0000000500007306ULL, 0x004ea20000209000ULL, 0x000000ff0500720cULL, 0x000fc40003f45070ULL,
0x00000005ff3a7819ULL, 0x010fca0000011609ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x00001fff3a3a7589ULL, 0x000f2200000e0000ULL, 0x0ffffffe00027836ULL, 0x004fcc0000000000ULL,
0x0000000200037305ULL, 0x0004e4000021f000ULL, 0x000000ffff027224ULL, 0x004fe400078e00ffULL,
0x000000ffff087224ULL, 0x008fc800078e0a03ULL, 0x0000000508077224ULL, 0x000fe400078e02ffULL,
0x0000000000087919ULL, 0x000ea40000002300ULL, 0x0000000703037227ULL, 0x000fcc00078e0002ULL,
0x0000000603077227ULL, 0x022fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000000305007224ULL, 0x000fca00078e0206ULL, 0x000000050000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a05ULL, 0x0000000107070836ULL, 0x000fc60000000000ULL,
0x000000050000720cULL, 0x000fda0003f26070ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x00000005ff07a212ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027836ULL, 0x002fe40000000000ULL, 0x0000000408007c24ULL, 0x004fe2000f8e020bULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307067224ULL, 0x004fc800078e02ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a06ULL, 0x0000000d03037227ULL, 0x000fc800078e0002ULL,
0x0000000400027c24ULL, 0x000fe4000f8e0209ULL, 0x0000004003417227ULL, 0x000fe200078e00ffULL,
0x00001fff08097589ULL, 0x00092400000e0000ULL, 0x0000007f0200780cULL, 0x040fe20003f64070ULL,
0x000000ffff037224ULL, 0x000fe200078e0a41ULL, 0x000000030200780cULL, 0x000fc60003f84070ULL,
0x0000000307007224ULL, 0x000fca00078e0240ULL, 0x000000070000720cULL, 0x000fc60003f06070ULL,
0x000000000006b919ULL, 0x000e620000008800ULL, 0x000004000003b802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a07ULL, 0x0000000141410836ULL, 0x000fe20000000000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000070000720cULL, 0x000fda0003f26070ULL,
0x0000000141411836ULL, 0x000fe20000000000ULL, 0x00000007ff41a212ULL, 0x000fe400078e33ffULL,
0x0000000f0200780cULL, 0x000fe40003f24070ULL, 0x000006540603b816ULL, 0x002fe20000000003ULL,
0x000000ffff007224ULL, 0x000fe200078e0a41ULL, 0x000000010200780cULL, 0x000fe20003f44070ULL,
0xff317217ff06b424ULL, 0x000fe400078e00ffULL, 0x0000000007407224ULL, 0x000fc400078e0240ULL,
0x000000040203b824ULL, 0x000fe200078e0203ULL, 0x0000000000240947ULL, 0x010fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01760006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01760804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000402007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01768804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x017400060300b388ULL, 0x0003e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000001040007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000030612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a00ULL, 0x0000000a04037219ULL, 0x002fe200000006ffULL,
0x0000000415047224ULL, 0x000fe200078e02ffULL, 0x0000000a050f7219ULL, 0x000fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000820000087ab9ULL, 0x000fe20000000a00ULL, 0x00000010033b7446ULL, 0x000fe20003800002ULL,
0x0000000409037824ULL, 0x000fe200078e023aULL, 0x0000000a41027219ULL, 0x000fc400000006ffULL,
0x000000ff3b3b7207ULL, 0x000fc60000000000ULL, 0x0000000f04027224ULL, 0x000fe200078e0202ULL,
0x000000103b00780cULL, 0x000fe20003f05270ULL, 0x0000000203047824ULL, 0x000fd800078e00ffULL,
0x0000000000848947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0xffffffffff037424ULL, 0x000fe200078e00ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000087919ULL, 0x000ea60000008800ULL, 0x0000000a03067219ULL, 0x000fe400000006ffULL,
0x00000004ff0b7819ULL, 0x002fca000001160eULL, 0x00000001040d7824ULL, 0x000fc800078e020bULL,
0x0000000100037824ULL, 0x000fca00078e020dULL, 0x0000000603077212ULL, 0x000fe400078e30ffULL,
0x0000000aff067219ULL, 0x000fe40000011603ULL, 0x0000040000037802ULL, 0x000fe20000000f00ULL,
0x0000000102027824ULL, 0x000fe200078e0207ULL, 0x000000043b077248ULL, 0x000fe40007fe0000ULL,
0x0000065408087816ULL, 0x004fe20000000003ULL, 0x0000000f06067224ULL, 0x000fe400078e0202ULL,
0x000000100e037824ULL, 0x000fe200078e00ffULL, 0x00000000080a72caULL, 0x000fe200000e0000ULL,
0x0000000107047824ULL, 0x000fc400078e0a04ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x000000f003117812ULL, 0x000fe400078ec0ffULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x000000010d027824ULL, 0x040fe200078e020eULL, 0x0000001106117212ULL, 0x000fe200078efcffULL,
0x000000100d0d7824ULL, 0x000fc600078e00ffULL, 0x0000000411067c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff00d027812ULL, 0x000fe400078ee202ULL, 0x0000000507077c10ULL, 0x000fe40008ffe4ffULL,
0x0000000a020b7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e2000c101c48ULL, 0x0000000000707947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0xffffffffff037424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000008800ULL,
0x000000040e0b7211ULL, 0x002fe400078fe0ffULL, 0x0000000a03047219ULL, 0x000fc600000006ffULL,
0x0000000100037824ULL, 0x000fca00078e020bULL, 0x0000000403077212ULL, 0x000fe400078e30ffULL,
0x0000000aff047219ULL, 0x000fe20000011603ULL, 0x000000100e037824ULL, 0x000fe400078e00ffULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x0000040000027802ULL, 0x000fc60000000f00ULL,
0x0000000f04077224ULL, 0x000fe200078e0207ULL, 0x000006540d027816ULL, 0x004fe40000000002ULL,
0x000000f0030d7812ULL, 0x000fe200078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x00000000020a72caULL, 0x000fc600000e0000ULL, 0x000000010b027824ULL, 0x040fe200078e020eULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fc600078e00ffULL,
0x0000000406067c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff00b027812ULL, 0x000fe400078ee202ULL,
0x0000000507077c10ULL, 0x000fe400087fe4ffULL, 0x0000000a020b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e4000b901c48ULL,
0x000176000a047890ULL, 0x000fe2000fffe03fULL, 0x00009200ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000415067825ULL, 0x002fe200078e0006ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000806387981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x0000007f38397836ULL, 0x004fe40000000000ULL,
0x000000ff38047836ULL, 0x000fc60000000000ULL, 0x00000007ff397819ULL, 0x000fe40000011639ULL,
0x00000008ff0d7819ULL, 0x000fca0000011604ULL, 0x000000c8000c8947ULL, 0x000fea0003800000ULL,
0x00000003ff0c7819ULL, 0x000fe2000001163aULL, 0xffffffffff4e7424ULL, 0x000fe200078e00ffULL,
0x00008e00ff107b82ULL, 0x000e620000000a00ULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0x01ffffff0c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000390c00720cULL, 0x000fda0003f06070ULL,
0x00009400ff098b82ULL, 0x000ea20000000800ULL, 0x0000000215008824ULL, 0x000fce00078e00ffULL,
0x00009000ff068b82ULL, 0x000ee20000000a00ULL, 0x0000000900098224ULL, 0x004fe200078e0209ULL,
0x0000000a3a007c11ULL, 0x000fc6000f8e18ffULL, 0x000000010c098824ULL, 0x000fe200078e0209ULL,
0x0176880b00ff79a7ULL, 0x0005e6000850003fULL, 0x0000000409068825ULL, 0x008fca00078e0006ULL,
0x00000008064e8981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0400780cULL, 0x000fe20003f04070ULL,
0x00000080410a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x004fe4000001163aULL,
0x000000013a087812ULL, 0x000fc600078ec0ffULL, 0x000000200b097824ULL, 0x000fca00078e00ffULL,
0x000000600a007812ULL, 0x000fe200078ef809ULL, 0x000000054e057224ULL, 0x008fc800078e02ffULL,
0x0000008005057824ULL, 0x000fc800078e00ffULL, 0x0000008005047825ULL, 0x002fe200078e0010ULL,
0x0000000000fc0947ULL, 0x000fec0003800000ULL, 0x0000000938027248ULL, 0x000fe20007fe0000ULL,
0x0000001008077824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fc6000001160eULL,
0x0000000102027824ULL, 0x000fe400078e0a09ULL, 0x0000000107117824ULL, 0x000fe400078e0206ULL,
0x0000000406127836ULL, 0x000fe20000000000ULL, 0x0000000702027248ULL, 0x000fe20007fe0000ULL,
0x0000000111107824ULL, 0x040fe400078e020eULL, 0x0000000811137824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc400078e0a07ULL, 0x0000000806167836ULL, 0x000fe20000000000ULL,
0xfffffff813147812ULL, 0x000fe200078ee210ULL, 0x0000000107137824ULL, 0x000fe200078e0212ULL,
0x000000021200720cULL, 0x080fe20003f46070ULL, 0x0000000c06127836ULL, 0x000fe20000000000ULL,
0x000000020600720cULL, 0x080fe20003f66070ULL, 0x0000000100067824ULL, 0x000fe200078e0211ULL,
0x000000021600720cULL, 0x080fe20003f26070ULL, 0x0000000113107824ULL, 0x040fe200078e020eULL,
0x000000021200720cULL, 0x000fe20003f06070ULL, 0x0000000813197824ULL, 0x000fc400078e00ffULL,
0x0000000107117824ULL, 0x040fe400078e0216ULL, 0x0000000107177824ULL, 0x000fe200078e0212ULL,
0xfffffff819027812ULL, 0x000fe200078ee210ULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x00000001001a7824ULL, 0x040fe200078e0217ULL, 0x0000007006197812ULL, 0x000fe200078ef803ULL,
0x0000000117067824ULL, 0x140fe400078e020eULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0x0000001904167210ULL, 0x000fe20007f9e0ffULL, 0x0000000100107824ULL, 0x000fe400078e0211ULL,
0x0000000111127824ULL, 0x040fe200078e020eULL, 0xfffffff8171c7812ULL, 0x000fe200078ee206ULL,
0x0000000811117824ULL, 0x000fc400078e00ffULL, 0x0000000100137824ULL, 0x000fe200078e0213ULL,
0x0000000a0b007c11ULL, 0x000fe2000f8e68ffULL, 0x0000000105177824ULL, 0x000fe200020e0607ULL,
0xfffffff811187812ULL, 0x000fe200078ee212ULL, 0x0000008013067825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000007006237812ULL, 0x000fc600078ef803ULL,
0x000000801a127825ULL, 0x000fe200078e00ffULL, 0x0000007010217812ULL, 0x000fc600078ef803ULL,
0x0001300000197836ULL, 0x000fe20000000000ULL, 0x0000007012037812ULL, 0x000fe400078ef803ULL,
0x0000002104067210ULL, 0x000fe20007fbe0ffULL, 0x00000010021d7824ULL, 0x100fe200078e0219ULL,
0x0000002304027210ULL, 0x000fe20007f9e0ffULL, 0x00000010141b7824ULL, 0x100fe200078e0219ULL,
0x0000000304047210ULL, 0x000fe20007fde0ffULL, 0x00000010181f7824ULL, 0x000fe400078e0219ULL,
0x0000000105037824ULL, 0x040fe200020e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161b7faeULL, 0x0003e2000d901c48ULL, 0x0000000105077824ULL, 0x000fc400028e0611ULL,
0x000000101c197824ULL, 0x000fe200078e0219ULL, 0x00000000021d7faeULL, 0x0003e2000d101c48ULL,
0x0000000105057824ULL, 0x000fc600030e0613ULL, 0x00000000061f7faeULL, 0x0003e8000c901c48ULL,
0x0000000004197faeULL, 0x0003e2000c101c48ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x0000001008077824ULL, 0x000fca00078e00ffULL, 0x000000070e077211ULL, 0x000fca00078fe8ffULL,
0x0000000407117836ULL, 0x000fe40000000000ULL, 0x0000000107027824ULL, 0x140fe400078e020eULL,
0x0000000807137824ULL, 0x000fe400078e00ffULL, 0x0000000111107824ULL, 0x040fe400078e020eULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0xfffffff813027812ULL, 0x000fe200078ee202ULL,
0x0000000100067824ULL, 0x000fc400078e0207ULL, 0x0000000807137836ULL, 0x000fe20000000000ULL,
0xfffffff817147812ULL, 0x000fe200078ee210ULL, 0x0000000c07177836ULL, 0x000fe40000000000ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000000100127824ULL, 0x040fe200078e0217ULL,
0x0000007006197812ULL, 0x000fe200078ef803ULL, 0x0000000117067824ULL, 0x140fe400078e020eULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x0000001904167210ULL, 0x000fe20007f1e0ffULL,
0x0000000100117824ULL, 0x040fe400078e0211ULL, 0x0000000100107824ULL, 0x000fe200078e0213ULL,
0xfffffff817187812ULL, 0x000fe200078ee206ULL, 0x0000000113007824ULL, 0x000fc400078e020eULL,
0x00000008131b7824ULL, 0x000fe200078e00ffULL, 0x0000000a0b137c11ULL, 0x000fe2000f8e68ffULL,
0x0000000105177824ULL, 0x000fe400000e0607ULL, 0x0000008011067825ULL, 0x000fe200078e00ffULL,
0xfffffff81b007812ULL, 0x000fc600078ee200ULL, 0x0001300013237836ULL, 0x000fe20000000000ULL,
0x0000007006217812ULL, 0x000fe200078ef803ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000070101f7812ULL, 0x000fc600078ef803ULL,
0x0000001002197824ULL, 0x100fe200078e0223ULL, 0x0000007012037812ULL, 0x000fe200078ef803ULL,
0x00000010141b7824ULL, 0x100fe200078e0223ULL, 0x0000002104027210ULL, 0x000fe20007f1e0ffULL,
0x00000010001d7824ULL, 0x100fe200078e0223ULL, 0x0000001f04067210ULL, 0x000fe20007f3e0ffULL,
0x00000010181f7824ULL, 0x000fe200078e0223ULL, 0x0000000304047210ULL, 0x000fe20007f5e0ffULL,
0x0000000105037824ULL, 0x040fe200000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e2000b901c48ULL, 0x0000000105077824ULL, 0x000fc400008e0611ULL,
0x0000000105057824ULL, 0x000fe200010e0613ULL, 0x00000000021b7faeULL, 0x0003e8000b901c48ULL,
0x00000000061d7faeULL, 0x0003e8000b901c48ULL, 0x00000000041f7faeULL, 0x0003e4000b901c48ULL,
0x0000000aff007e24ULL, 0x000fe2000f8e00ffULL, 0x000000000b0472caULL, 0x000fe200000e0000ULL,
0x00000001ff037424ULL, 0x002fe200078e00ffULL, 0x000000ff0d00720cULL, 0x000fe20003f05270ULL,
0x000176a800007836ULL, 0x000fe20000000000ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff507224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000572caULL, 0x000fc400000e0000ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe400078e00ffULL, 0x000000080b027824ULL, 0x000fe400078e0200ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000003ff4679a7ULL, 0x0002a20008500004ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00002003020279a7ULL, 0x002e62000850003fULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ac00548947ULL, 0x000fec0003800000ULL,
0x00009400ff047b82ULL, 0x000ee20000000800ULL, 0x00000002ff077819ULL, 0x000fe2000001163aULL,
0x000000083a027824ULL, 0x002fe200078e00ffULL, 0x000000010b007812ULL, 0x000fe200078ec0ffULL,
0x0000000215157824ULL, 0x000fe200078e00ffULL, 0x0000000a07057c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff347224ULL, 0x000fe200078e0003ULL, 0x0000000802027812ULL, 0x000fe200078ec0ffULL,
0xff317217ff517424ULL, 0x000fe400078e00ffULL, 0x0000001000057824ULL, 0x000fc400078e0205ULL,
0x000000ffff137224ULL, 0x000fe400078e00ffULL, 0x0000000102067824ULL, 0x000fe400078e0205ULL,
0x0000000415057224ULL, 0x008fe400078e0204ULL, 0x000000ffff047224ULL, 0x000fce00078e00ffULL,
0x0000000000147805ULL, 0x012fce0000015200ULL, 0x000000043a167824ULL, 0x000fca00078e00ffULL,
0xfffffff816177812ULL, 0x000fc800078ec0ffULL, 0x0176c834170075a7ULL, 0x000e62000800014aULL,
0x0000000a17357c36ULL, 0x000fc80008000000ULL, 0x000176c835447836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176c834350075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x000000103a167824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x0000000104347836ULL, 0x000fe40000000000ULL,
0x000000054e4e7c24ULL, 0x000fe2000f8e02ffULL, 0xffffffe016177812ULL, 0x000fe400078ec0ffULL,
0x0000000d3400720cULL, 0x000fe20003f26070ULL, 0x000000804e357824ULL, 0x000fe400078e00ffULL,
0x0000010004177824ULL, 0x000fc800078e0217ULL, 0x0000004017377836ULL, 0x000fca0000000000ULL,
0x0000006037177812ULL, 0x000fe200078ec0ffULL, 0x0000008035147825ULL, 0x002fc800078e0014ULL,
0x000000010a3c7824ULL, 0x000fe200078e0217ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x0000001016177812ULL, 0x000fe200078ec0ffULL, 0x000000100e427824ULL, 0x000fe200078e00ffULL,
0x0000003738167248ULL, 0x000fe40007fe0000ULL, 0x00000003ff367819ULL, 0x100fe4000001160eULL,
0x0000007042497812ULL, 0x000fe200078ec0ffULL, 0x0000000116167824ULL, 0x000fe400078e0a37ULL,
0x0000000136357824ULL, 0x000fe400078e0217ULL, 0x00000008363d7836ULL, 0x000fe20000000000ULL,
0x0000001716167248ULL, 0x000fe20007fe0000ULL, 0x0000000135347824ULL, 0x000fc400078e020eULL,
0x0000000835377824ULL, 0x000fe400078e00ffULL, 0x0000000116167824ULL, 0x000fc600078e0a17ULL,
0xfffffff8373e7812ULL, 0x000fe200078ee234ULL, 0x0000000436377836ULL, 0x000fe20000000000ULL,
0x000000163600720cULL, 0x080fe20003f86070ULL, 0x0000000c36367836ULL, 0x000fe20000000000ULL,
0x000000163d00720cULL, 0x0c0fe20003f46070ULL, 0x000000013d3d7824ULL, 0x100fe200078e0217ULL,
0x000000163700720cULL, 0x0c0fe20003f66070ULL, 0x0000000137377824ULL, 0x100fe200078e0217ULL,
0x000000163600720cULL, 0x040fe20003f06070ULL, 0x00000001363f7824ULL, 0x000fe400078e0217ULL,
0x000000013c167824ULL, 0x000fc400078e0235ULL, 0x000000013c367824ULL, 0x040fe400078e0237ULL,
0x000000013c357824ULL, 0x040fe400078e023dULL, 0x000000013c437824ULL, 0x000fe400078e023fULL,
0x000000013d3c7824ULL, 0x140fe400078e020eULL, 0x000000083d4b7824ULL, 0x000fe400078e00ffULL,
0x0000000137347824ULL, 0x000fc400078e020eULL, 0x0000000837457824ULL, 0x000fe200078e00ffULL,
0xfffffff84b467812ULL, 0x004fe200078ee23cULL, 0x000000013f3d7824ULL, 0x040fe400078e020eULL,
0x000000083f487824ULL, 0x000fe200078e00ffULL, 0xfffffff845427812ULL, 0x000fe200078ee234ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000a0b457c11ULL, 0x000fe4000f8e68ffULL,
0xfffffff848487812ULL, 0x000fe200078ee23dULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000049363d7212ULL, 0x000fc600078efcffULL, 0x0000008035347825ULL, 0x000fe200078e00ffULL,
0x00000049163f7212ULL, 0x080fe400078efcffULL, 0x0000003d14367210ULL, 0x000fe20007fde0ffULL,
0x00000080433c7825ULL, 0x000fe200078e00ffULL, 0x0000003f14167210ULL, 0x000fe40007fbe0ffULL,
0x00000049344b7212ULL, 0x080fe200078efcffULL, 0x00014000453f7836ULL, 0x000fe20000000000ULL,
0x000000493c497212ULL, 0x000fe200078efcffULL, 0x0000000115177824ULL, 0x040fe200028e0617ULL,
0x0000004b14347210ULL, 0x000fe20007fbe0ffULL, 0x0000000115377824ULL, 0x000fe200030e0637ULL,
0x0000004914147210ULL, 0x000fe20007fde0ffULL, 0x000000103e437824ULL, 0x000fc400078e023fULL,
0x0000001042457824ULL, 0x100fe400078e023fULL, 0x0000001046497824ULL, 0x000fe200078e023fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016437faeULL, 0x0003e2000e101c48ULL,
0x0000000115357824ULL, 0x040fe400028e0635ULL, 0x00000010483f7824ULL, 0x000fe200078e023fULL,
0x0000000036457faeULL, 0x0003e2000d901c48ULL, 0x0000000115157824ULL, 0x000fc600030e063dULL,
0x0000000034497faeULL, 0x0003e8000d101c48ULL, 0x00000000143f7faeULL, 0x0003e2000c101c48ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x0000001016177812ULL, 0x000fe200078ec0ffULL,
0x000000100e367824ULL, 0x000fc600078e00ffULL, 0x000000170e177211ULL, 0x000fe400078fe8ffULL,
0x0000007036497812ULL, 0x000fc600078ec0ffULL, 0x0000000417357836ULL, 0x000fe40000000000ULL,
0x0000000117167824ULL, 0x140fe400078e020eULL, 0x0000000817377824ULL, 0x000fe400078e00ffULL,
0x0000000135347824ULL, 0x040fe400078e020eULL, 0x00000008353d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8373e7812ULL, 0x000fe200078ee216ULL, 0x000000013c167824ULL, 0x000fc400078e0217ULL,
0x0000000817377836ULL, 0x000fe20000000000ULL, 0xfffffff83d427812ULL, 0x000fe200078ee234ULL,
0x0000000c173d7836ULL, 0x000fe40000000000ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x000000013c357824ULL, 0x000fe200078e0235ULL, 0x00000049163f7212ULL, 0x000fe200078efcffULL,
0x000000013c367824ULL, 0x040fe400078e0237ULL, 0x0000000137347824ULL, 0x140fe200078e020eULL,
0x0000003f14167210ULL, 0x000fe20007f1e0ffULL, 0x0000000837457824ULL, 0x000fe400078e00ffULL,
0x000000013c3c7824ULL, 0x000fe400078e023dULL, 0x000000013d377824ULL, 0x040fe200078e020eULL,
0xfffffff845457812ULL, 0x000fe200078ee234ULL, 0x000000083d467824ULL, 0x004fe200078e00ffULL,
0x0000000a0b3d7c11ULL, 0x000fe2000f8e68ffULL, 0x0000008035347825ULL, 0x000fc600078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee237ULL, 0x000140003d4f7836ULL, 0x000fe20000000000ULL,
0x00000049344d7212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x00000049364b7212ULL, 0x000fc600078efcffULL,
0x0000000115177824ULL, 0x000fe200000e0617ULL, 0x000000493c497212ULL, 0x000fe200078efcffULL,
0x000000103e3f7824ULL, 0x100fe200078e024fULL, 0x0000004d14347210ULL, 0x000fe20007f1e0ffULL,
0x0000001042437824ULL, 0x100fe200078e024fULL, 0x0000004b14367210ULL, 0x000fe20007f5e0ffULL,
0x0000001045457824ULL, 0x000fe200078e024fULL, 0x0000004914147210ULL, 0x000fe20007f7e0ffULL,
0x0000000115357824ULL, 0x040fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000163f7faeULL, 0x0003e2000b901c48ULL, 0x0000000115377824ULL, 0x000fc400010e0637ULL,
0x0000001046497824ULL, 0x000fe200078e024fULL, 0x0000000034437faeULL, 0x0003e2000b901c48ULL,
0x0000000115157824ULL, 0x000fc600018e063dULL, 0x0000000036457faeULL, 0x0003e8000b901c48ULL,
0x0000000014497faeULL, 0x0003e4000b901c48ULL, 0x000000010c167836ULL, 0x002fe40000000000ULL,
0xffffffffff4f7424ULL, 0x000fc600078e00ffULL, 0x000000391600720cULL, 0x000fe20003f06070ULL,
0x000000083a3c7824ULL, 0x000fca00078e00ffULL, 0xfffffff03c347812ULL, 0x000fca00078ec0ffULL,
0x0000000a34567c36ULL, 0x000fe40008000000ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x0000000105178824ULL, 0x000fe200078e0216ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000560572caULL, 0x000fda00000e0000ULL, 0x000176b005057890ULL, 0x000fe2000fffe03fULL,
0x0000000417148825ULL, 0x002fd000078e0014ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a45ULL,
0x00000008144f8981ULL, 0x000322000c1e1900ULL, 0xffffffe03c167812ULL, 0x040fe200078ec0ffULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x000000103c177812ULL, 0x000fc800078ec0ffULL,
0x0000000a17167c10ULL, 0x000fe4000fffe016ULL, 0x000000083c177812ULL, 0x000fca00078ec0ffULL,
0x00000001164c7824ULL, 0x000fe200078e0217ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x0176b035565679a7ULL, 0x0002a4000850003fULL, 0x017608354c3479a7ULL, 0x0022e4000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x017608354c0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017608354c0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000100e427824ULL, 0x000fe200078e00ffULL, 0x00000001ff457819ULL, 0x000fe2000001160eULL,
0x000000203a147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000007042427812ULL, 0x000fe400078ec0ffULL, 0xffffff8014157812ULL, 0x000fe400078ec0ffULL,
0x0000000c45457812ULL, 0x000fe400078ec0ffULL, 0x0000000a42147c10ULL, 0x000fca000fffe015ULL,
0x0000000114147824ULL, 0x000fca00078e0245ULL, 0x0170000014167984ULL, 0x000ee80000000800ULL,
0x0172000014177984ULL, 0x000b620000000800ULL, 0x000000511600720bULL, 0x008fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000000fc8947ULL, 0x026fea0003800000ULL, 0x0000003a0700720cULL, 0x000fe40003f45270ULL,
0x000000511600720bULL, 0x000fd60003f14000ULL, 0x0000000a3a15ac11ULL, 0x000fe4000f8e38ffULL,
0x000000511614a209ULL, 0x000fe40007810000ULL, 0x000000154515a210ULL, 0x000fe40007ffe042ULL,
0x0000000000367806ULL, 0x000fc600000e0100ULL, 0x017400141500a388ULL, 0x0003e20000000800ULL,
0x0000991036347816ULL, 0x000fc800000000ffULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005116147209ULL, 0x000fe40007810000ULL,
0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0036ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005114147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160eULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001418187220ULL, 0x082fe20000410000ULL, 0x0000001419197220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x0000001410107220ULL, 0x080fe20000410000ULL, 0x0000001411117220ULL, 0x000fce0000410000ULL,
0x0000001550507220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x000000141a1a7220ULL, 0x082fe20000410000ULL, 0x000000141b1b7220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x000000141e1e7220ULL, 0x080fe20000410000ULL, 0x000000141f1f7220ULL, 0x080fe20000410000ULL,
0x0000001412127220ULL, 0x080fe20000410000ULL, 0x0000001413137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806036ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005116517209ULL, 0x000fd60007810000ULL, 0x8000005116160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005017507221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0xfffffff03c3c7812ULL, 0x000fc800078ec0ffULL, 0x0176a8473c0075a7ULL, 0x000e62000800014aULL,
0x0000000a3c367c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176a847360075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034157816ULL, 0x000fe200000000ffULL,
0x000000023a527824ULL, 0x000fe200078e00ffULL, 0x000000070e587812ULL, 0x000fe200078ec0ffULL,
0x000002003a147824ULL, 0x040fe200078e00ffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000043a547824ULL, 0x000fe200078e00ffULL, 0x0000000452157812ULL, 0x000fe400078ec0ffULL,
0xfffff800144e7812ULL, 0x000fe400078ec0ffULL, 0x0000000858497812ULL, 0x000fc400078ef80eULL,
0x000000150e147211ULL, 0x040fe200078fe0ffULL, 0x0000000a4e4e7c36ULL, 0x000fe20008000000ULL,
0x000000080e477812ULL, 0x000fe200078ec0ffULL, 0x0000000849167824ULL, 0x040fe200078e00ffULL,
0x00000004ff5a7819ULL, 0x000fe2000001160eULL, 0x0000000149437824ULL, 0x000fe200078e0214ULL,
0x0000000454547812ULL, 0x000fe400078ec0ffULL, 0x00000058473d7212ULL, 0x000fe400078efcffULL,
0x0000000a0b487c11ULL, 0x000fe2000f8e68ffULL, 0x000000015a547824ULL, 0x000fe200078e0254ULL,
0xfffffff816157812ULL, 0x000fe200078ee243ULL, 0x000000083d4d7824ULL, 0x000fc400078e00ffULL,
0x000000013d3c7824ULL, 0x000fe400078e0254ULL, 0x0001300048467836ULL, 0x000fe40000000000ULL,
0x00000010154a7824ULL, 0x000fe200078e024eULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee23cULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011000004a14783bULL, 0x0022e20000000200ULL,
0x000000104d347824ULL, 0x000fe200078e0246ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000083d3e7824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000023c4b7836ULL, 0x000fe20000000000ULL, 0x0000001047477812ULL, 0x000fe200078efe58ULL,
0x000000040b5a7824ULL, 0x000fc600078e025aULL, 0xfffffff83e4b7812ULL, 0x000fe200078ee24bULL,
0x0000000154547824ULL, 0x000fe200078e0247ULL, 0x000000025a5a7810ULL, 0x000fe20007ffe049ULL,
0x0000000849497824ULL, 0x000fe400078e00ffULL, 0x000000104b3c7824ULL, 0x000fc600078e0246ULL,
0xfffffff849497812ULL, 0x000fc600078ee25aULL, 0x000000003c3c783bULL, 0x000f640000004200ULL,
0x00000010494e7824ULL, 0x000fe200078e024eULL, 0x000000ff35607812ULL, 0x022fe400078ec0ffULL,
0x000000ff34587812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011634ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000010ff6c7819ULL, 0x000fc40000011635ULL,
0x00000018ff5e7819ULL, 0x000fe40000011635ULL, 0x0000ffff35677812ULL, 0x000fe400078ec0ffULL,
0x000000ff376e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fe40000011637ULL,
0x00000018ff6f7819ULL, 0x008fe4000001163cULL, 0x00000018ff5c7819ULL, 0x000fc4000001163dULL,
0x00000018ff6d7819ULL, 0x000fe40000011637ULL, 0x0000ffff375b7812ULL, 0x000fe400078ec0ffULL,
0x00000058ff35723eULL, 0x000fe400020006ffULL, 0x000000ff3e5d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x000fe20000011634ULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x0000ffff34687812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6a7819ULL, 0x000fe4000001163cULL,
0x000000ff3c707812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3c657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff627819ULL, 0x100fe4000001163eULL, 0x00000018ff587819ULL, 0x000fe4000001163eULL,
0x0000ffff3e5f7812ULL, 0x000fc400078ec0ffULL, 0x0000005aff37723eULL, 0x000fe200020006ffULL,
0x20000060ff5a7230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000010ff347819ULL, 0x100fe2000001163fULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x000000ff3f597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f3c7812ULL, 0x000fc400078ec0ffULL, 0x0000006eff60723eULL, 0x000fe400020006ffULL,
0x0000005cff3f723eULL, 0x000fe200020006ffULL, 0x2000006fff5c7230ULL, 0x000fe20000004100ULL,
0x00000018ff557819ULL, 0x100fe20000011636ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000005dff6e723eULL, 0x000fe200020006ffULL, 0x2000003fff5d7230ULL, 0x000fe20000004100ULL,
0x00000059ff6f723eULL, 0x000fe400020006ffULL, 0x00000055ff59723eULL, 0x000fe200020006ffULL,
0x2000006eff557230ULL, 0x000fe20000004100ULL, 0x00000058ff3f723eULL, 0x000fe200020006ffULL,
0x2000006fff587230ULL, 0x000fe20000004100ULL, 0x0000003eff6e723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe20000011636ULL,
0x2000003fff3e7230ULL, 0x000fe20000004100ULL, 0x00000008ff687819ULL, 0x000fe20000011668ULL,
0x2000006eff3f7230ULL, 0x000fe20000004100ULL, 0x0000006dff6f723eULL, 0x000fc400020006ffULL,
0x000000ff536d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6c6e7812ULL, 0x000fe200078ec0ffULL,
0x2000006fff537230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x0000006dff6c723eULL, 0x000fc400020006ffULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x0000006eff6d723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000006bff6e723eULL, 0x000fe200020006ffULL,
0x20000068ff6b7230ULL, 0x000fe20000004100ULL, 0x0000ffff3d697812ULL, 0x000fe200078ec0ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff6a687812ULL, 0x000fe200078ec0ffULL,
0x20000067ff6a7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000006eff677230ULL, 0x000fe20000004100ULL, 0x00000008ff657819ULL, 0x000fc40000011665ULL,
0x00000008ff697819ULL, 0x000fe40000011669ULL, 0x00000068ff6e723eULL, 0x000fe200020006ffULL,
0x20000063ff687230ULL, 0x000fe20000004100ULL, 0x00000065ff63723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x2000006eff657230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff626e7812ULL, 0x000fe200078ec0ffULL,
0x20000063ff627230ULL, 0x000fe20000004100ULL, 0x000000ff346f7812ULL, 0x000fe200078ec0ffULL,
0x20000069ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe20000011635ULL,
0x2000005eff647230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc4000001166cULL,
0x000000ff36617812ULL, 0x040fe400078ec0ffULL, 0x00000010ff697819ULL, 0x000fe4000001165aULL,
0x00000010ff6c7819ULL, 0x000fe4000001166dULL, 0x0000ffff36367812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x000fe4000001163dULL, 0x0000105435347816ULL, 0x000fc40000000034ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x000010546c357816ULL, 0x000fe40000000069ULL,
0x00000008ff6c7819ULL, 0x000fe20000011636ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff367819ULL, 0x000fe2000001166bULL,
0x000000341418723cULL, 0x000fe20000041818ULL, 0x000000ff3d717812ULL, 0x000fc400078ec0ffULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff697819ULL, 0x000fe40000011664ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000070ff3d723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x00000071ff5e723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x0000105469377816ULL, 0x000fe2000000006aULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe20000011661ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe40000011660ULL, 0x00000010ff677819ULL, 0x000fe20000011667ULL,
0x000000361428723cULL, 0x000fe20000041828ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x0000105467347816ULL, 0x000fc40000000034ULL, 0x0000105468357816ULL, 0x000fe40000000035ULL,
0x00000008ff367819ULL, 0x000fe4000001163cULL, 0x00000010ff3c7819ULL, 0x000fe4000001163dULL,
0x00000010ff3d7819ULL, 0x000fe2000001165eULL, 0x00000034142c723cULL, 0x000fe2000004182cULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000008ff5b7819ULL, 0x000fe2000001165bULL, 0x2000006eff5a7230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fe2000001165fULL, 0x2000006fff647230ULL, 0x000fe20000004100ULL,
0x00000036ff60723eULL, 0x000fe400020006ffULL, 0x00001054653c7816ULL, 0x000fc4000000003cULL,
0x00001054663d7816ULL, 0x000fe2000000003dULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe4000001165cULL, 0x00000010ff347819ULL, 0x000fe4000001165dULL,
0x00000010ff367819ULL, 0x000fe20000011662ULL, 0x0000003c1424723cULL, 0x000fe20000041824ULL,
0x00000010ff377819ULL, 0x000fe40000011663ULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000105435367816ULL, 0x000fe20000000036ULL,
0x20000069ff5e7230ULL, 0x000fe20000004100ULL, 0x0000105434377816ULL, 0x000fe20000000037ULL,
0x2000006cff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe40000011655ULL,
0x00000010ff3d7819ULL, 0x000fc40000011658ULL, 0x00000010ff357819ULL, 0x000fe2000001165aULL,
0x000000361420723cULL, 0x000fe20000041820ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00001054353c7816ULL, 0x000fe4000000003cULL, 0x00001054643d7816ULL, 0x000fe4000000003dULL,
0x00000010ff367819ULL, 0x000fe40000011653ULL, 0x00000010ff357819ULL, 0x000fc4000001165bULL,
0x00000010ff377819ULL, 0x000fe2000001163eULL, 0x0000003c141c723cULL, 0x000fe2000004181cULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff347819ULL, 0x000fe4000001165fULL, 0x00000010ff3f7819ULL, 0x000fe2000001163fULL,
0x00000008473d7824ULL, 0x000fe200078e00ffULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x0000105436357816ULL, 0x000fe40000000035ULL, 0x0000105437367816ULL, 0x000fe4000000005eULL,
0x0000105459347816ULL, 0x000fe40000000034ULL, 0x000010543f377816ULL, 0x000fe40000000060ULL,
0xfffffff83d497812ULL, 0x000fc600078ee254ULL, 0x000000341430723cULL, 0x000fec0000041830ULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x0000001049347824ULL, 0x000fe200078e0246ULL,
0x011000004e14783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x00000008473c7824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x0000000254477836ULL, 0x000fe20000000000ULL,
0xfffffff852527812ULL, 0x000fc800078ec0ffULL, 0xfffffff83c477812ULL, 0x000fca00078ee247ULL,
0x00000010473c7824ULL, 0x000fcc00078e0246ULL, 0x000000003c3c783bULL, 0x000f640000004200ULL,
0x00000010ff6c7819ULL, 0x122fe40000011634ULL, 0x000000ff34547812ULL, 0x040fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe40000011634ULL, 0x0000ffff346a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff365d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff35557812ULL, 0x000fe400078ec0ffULL,
0x00000018ff347819ULL, 0x000fe40000011635ULL, 0x00000018ff597819ULL, 0x000fe40000011636ULL,
0x000000ff375f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c6d7812ULL, 0x008fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x00000010ff6b7819ULL, 0x000fe40000011635ULL,
0x00000010ff627819ULL, 0x000fe40000011636ULL, 0x0000ffff36617812ULL, 0x000fe400078ec0ffULL,
0x00000055ff68723eULL, 0x000fe400020006ffULL, 0x00000034ff64723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x0000ffff35657812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000053ff63723eULL, 0x000fc400020006ffULL, 0x00000010ff367819ULL, 0x100fe4000001163cULL,
0x00000018ff557819ULL, 0x000fe2000001163cULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000ffff3c347812ULL, 0x000fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000010ff5b7819ULL, 0x000fe4000001163eULL, 0x000000ff3e5a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x100fe40000011637ULL, 0x00000018ff5e7819ULL, 0x000fe40000011637ULL,
0x0000ffff37667812ULL, 0x000fe400078ec0ffULL, 0x000000ff3f3e7812ULL, 0x000fc400078ec0ffULL,
0x0000005fff60723eULL, 0x000fe200020006ffULL, 0x2000005dff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff5d7230ULL, 0x000fe20000004100ULL,
0x00000054ff69723eULL, 0x000fe200020006ffULL, 0x2000006dff597230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x100fe2000001163dULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x000000ff3d6e7812ULL, 0x000fe200078ec0ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff587819ULL, 0x000fc4000001163dULL, 0x0000ffff3d357812ULL, 0x000fe400078ec0ffULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe4000001163fULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f547812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6a7819ULL, 0x000fc4000001166aULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x0000005aff3f723eULL, 0x000fe400020006ffULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x0000003eff6d723eULL, 0x000fe200020006ffULL,
0x2000003fff3e7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006dff3f7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006eff5a7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000006bff6d7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000006aff6b7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000065ff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff36367812ULL, 0x000fe200078ec0ffULL, 0x20000062ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff37377812ULL, 0x000fe200078ec0ffULL, 0x20000061ff657230ULL, 0x000fe20000004100ULL,
0x00000036ff62723eULL, 0x000fc400020006ffULL, 0x00000037ff61723eULL, 0x000fe400020006ffULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011669ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe4000001166cULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166dULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x000010546d377816ULL, 0x000fe40000000068ULL,
0x00000008ff687819ULL, 0x000fe40000011634ULL, 0x00000008ff697819ULL, 0x000fc40000011635ULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff347819ULL, 0x000fe4000001166bULL,
0x00000010ff357819ULL, 0x000fe4000001166eULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x0000105463347816ULL, 0x000fe20000000034ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000105464357816ULL, 0x000fe20000000035ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe4000001165fULL,
0x00000010ff377819ULL, 0x000fe4000001166aULL, 0x00000010ff637819ULL, 0x000fe20000011660ULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff647819ULL, 0x000fc40000011667ULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x0000105464377816ULL, 0x000fe40000000063ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff347819ULL, 0x000fe20000011665ULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff357819ULL, 0x000fc40000011666ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x000010545d347816ULL, 0x000fe20000000034ULL,
0x20000068ff5f7230ULL, 0x000fe20000004100ULL, 0x000010545e357816ULL, 0x000fe20000000035ULL,
0x20000069ff607230ULL, 0x000fe20000004100ULL, 0x000000ff5b5b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff367819ULL, 0x000fe20000011659ULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000008ff547819ULL, 0x000fe20000011654ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000105461377816ULL, 0x000fe4000000005aULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff587819ULL, 0x000fc40000011658ULL, 0x00000010ff347819ULL, 0x000fe2000001165fULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x00000010ff357819ULL, 0x000fe40000011660ULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000008ff537819ULL, 0x000fe40000011653ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x0000105455347816ULL, 0x000fc40000000034ULL, 0x0000105458357816ULL, 0x000fe20000000035ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x000fe2000001163eULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe2000001163fULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x000000341420723cULL, 0x000fe20000041820ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x000010545b367816ULL, 0x000fe40000000036ULL, 0x000010545c377816ULL, 0x000fe40000000037ULL,
0x00000010ff347819ULL, 0x000fe4000001163dULL, 0x00000010ff3d7819ULL, 0x000fe40000011654ULL,
0x00000010ff357819ULL, 0x000fe2000001163cULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x00000010ff3c7819ULL, 0x000fc40000011653ULL, 0x00001054343d7816ULL, 0x000fe4000000003dULL,
0x0000000a0b347c11ULL, 0x000fe4000f8e18ffULL, 0x00001054353c7816ULL, 0x000fe2000000003cULL,
0x00000001ff377424ULL, 0x000fc800078e00ffULL, 0x0176c837343479a7ULL, 0x0002e4000850003fULL,
0x0000003c1410723cULL, 0x000fe20000041810ULL, 0x0176883752ff79a7ULL, 0x0003de000850000aULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035440075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x002fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035440075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00008e00ff547b82ULL, 0x000ee20000000a00ULL,
0x000000103a147824ULL, 0x000fe200078e00ffULL, 0x0000850000057ab9ULL, 0x000fe40000000800ULL,
0x000000054f4f7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe014157812ULL, 0x000fe400078ec0ffULL,
0x000000804f4f7824ULL, 0x000fc600078e00ffULL, 0x0000010004157824ULL, 0x000fc800078e0215ULL,
0x0000008015177836ULL, 0x000fca0000000000ULL, 0x0000006017157812ULL, 0x000fe200078ec0ffULL,
0x000000804f547825ULL, 0x008fc800078e0054ULL, 0x000000010a167824ULL, 0x000fe200078e0215ULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x0000001014357812ULL, 0x000fe400078ec0ffULL,
0x0000001738147248ULL, 0x000fe40007fe0000ULL, 0x00000003ff157819ULL, 0x000fc6000001160eULL,
0x0000000114147824ULL, 0x000fe400078e0a17ULL, 0x0000000115177824ULL, 0x100fe400078e0235ULL,
0x0000000415367836ULL, 0x000fe20000000000ULL, 0x0000001435147248ULL, 0x000fe20007fe0000ULL,
0x0000000117347824ULL, 0x040fe400078e020eULL, 0x00000008173f7824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fc400078e0a35ULL, 0x0000000c15377836ULL, 0x002fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee234ULL, 0x0000000815347836ULL, 0x000fe20000000000ULL,
0x000000141500720cULL, 0x080fe20003f86070ULL, 0x0000000117157824ULL, 0x100fe200078e0216ULL,
0x000000143600720cULL, 0x0c0fe20003f66070ULL, 0x0000000136177824ULL, 0x100fe200078e0235ULL,
0x000000143400720cULL, 0x0c0fe20003f46070ULL, 0x00000001343d7824ULL, 0x000fe200078e0235ULL,
0x000000143700720cULL, 0x000fe20003f06070ULL, 0x0000000117367824ULL, 0x000fc400078e0216ULL,
0x00000001374f7824ULL, 0x000fe400078e0235ULL, 0x0000000117347824ULL, 0x040fe400078e020eULL,
0x0000000817597824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff859597812ULL, 0x000fe200078ee234ULL, 0x000000013d357824ULL, 0x040fe200078e020eULL,
0x0000004236177212ULL, 0x080fe200078efcffULL, 0x000000083d3c7824ULL, 0x000fe400078e00ffULL,
0x0000008015147825ULL, 0x000fe200078e00ffULL, 0x0000001754367210ULL, 0x000fe40007fde0ffULL,
0xfffffff83c5b7812ULL, 0x000fe200078ee235ULL, 0x000000013d347824ULL, 0x100fe200078e0216ULL,
0x00000042143d7212ULL, 0x000fe200078efcffULL, 0x000000014f167824ULL, 0x000fc400078e0216ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003d54147210ULL, 0x000fc60007fbe0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004234537212ULL, 0x000fc600078efcffULL,
0x000000014f3c7824ULL, 0x040fe400078e020eULL, 0x000000084f5d7824ULL, 0x000fe200078e00ffULL,
0x00000042164f7212ULL, 0x000fe200078efcffULL, 0x0000000155157824ULL, 0x040fe200028e0615ULL,
0x0000005354347210ULL, 0x000fe20007fbe0ffULL, 0x0000000155377824ULL, 0x000fe200030e0637ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee23cULL, 0x000000103f3d7824ULL, 0x100fe200078e0246ULL,
0x0000004f54167210ULL, 0x000fe20007fde0ffULL, 0x00000010593f7824ULL, 0x000fc400078e0246ULL,
0x000000105b4f7824ULL, 0x100fe200078e0246ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000e101c48ULL, 0x0000000155357824ULL, 0x000fe400028e0635ULL,
0x000000105d537824ULL, 0x000fe200078e0246ULL, 0x00000000363f7faeULL, 0x0003e2000d901c48ULL,
0x0000000155177824ULL, 0x000fc600030e0617ULL, 0x00000000344f7faeULL, 0x0003e8000d101c48ULL,
0x0000000016537faeULL, 0x0003e2000c101c48ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x0000001014157812ULL, 0x000fc800078ec0ffULL, 0x000000150e157211ULL, 0x000fca00078fe8ffULL,
0x0000000115177824ULL, 0x040fe400078e020eULL, 0x0000000815347824ULL, 0x040fe400078e00ffULL,
0x0000000115147824ULL, 0x000fe400078e0216ULL, 0x0000000415357836ULL, 0x000fe20000000000ULL,
0xfffffff8343d7812ULL, 0x000fe200078ee217ULL, 0x00000008153f7836ULL, 0x000fe40000000000ULL,
0x0000000c154f7836ULL, 0x000fc40000000000ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000000135347824ULL, 0x040fe200078e0216ULL, 0x0000004214177212ULL, 0x000fe200078efcffULL,
0x0000000135377824ULL, 0x142fe400078e020eULL, 0x00000008353e7824ULL, 0x000fe200078e00ffULL,
0x0000001754147210ULL, 0x000fe20007f1e0ffULL, 0x000000013f357824ULL, 0x040fe400078e020eULL,
0x000000083f527824ULL, 0x040fe400078e00ffULL, 0x000000013f367824ULL, 0x100fe200078e0216ULL,
0xfffffff83e3f7812ULL, 0x000fe200078ee237ULL, 0x000000014f167824ULL, 0x000fc400078e0216ULL,
0x000000014f3c7824ULL, 0x040fe400078e020eULL, 0x000000084f5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8524f7812ULL, 0x000fe200078ee235ULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee23cULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000042345b7212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004236597212ULL, 0x000fc600078efcffULL, 0x0000000155157824ULL, 0x000fe200000e0615ULL,
0x0000004216537212ULL, 0x000fe200078efcffULL, 0x000000103d3d7824ULL, 0x100fe200078e0246ULL,
0x0000005b54347210ULL, 0x000fe20007f1e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0246ULL,
0x0000005954367210ULL, 0x000fe20007f5e0ffULL, 0x000000104f4f7824ULL, 0x000fe200078e0246ULL,
0x0000005354167210ULL, 0x000fe20007f7e0ffULL, 0x0000000155357824ULL, 0x040fe200000e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000b901c48ULL,
0x0000000155377824ULL, 0x000fc400010e0637ULL, 0x000000105d537824ULL, 0x000fe200078e0246ULL,
0x00000000343f7faeULL, 0x0003e2000b901c48ULL, 0x0000000155177824ULL, 0x000fc600018e0617ULL,
0x00000000364f7faeULL, 0x0003e8000b901c48ULL, 0x0000000016537faeULL, 0x0003e4000b901c48ULL,
0x000000083a147824ULL, 0x002fe400078e00ffULL, 0x00000001ff177424ULL, 0x000fc600078e00ffULL,
0xfffffff014147812ULL, 0x000fca00078ec0ffULL, 0x0000000a14527c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000000520572caULL, 0x000fda00000e0000ULL,
0x000176a805057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0176a817525279a7ULL, 0x0002e4000850003fULL,
0x017628174c1679a7ULL, 0x0022a4000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x017628174c0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003414377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017628174c0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000203a147824ULL, 0x000fe400078e00ffULL,
0x0000000aff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000008015147810ULL, 0x000fc80007ffe014ULL,
0x0000001445147210ULL, 0x000fca0007ffe042ULL, 0x0170000014167984ULL, 0x000ea80000000800ULL,
0x0172000014177984ULL, 0x0009220000000800ULL, 0x000000511600720bULL, 0x004fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x01afea0003800000ULL, 0x0000000107157836ULL, 0x000fe20000000000ULL,
0x000000511600720bULL, 0x000fc80003f14000ULL, 0x0000003a1500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x0000000a3a15ac11ULL, 0x000fe4000f8e38ffULL,
0x000000511614a209ULL, 0x000fe40007810000ULL, 0x000000154537a210ULL, 0x000fe40007ffe042ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160eULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x002fe20000015200ULL, 0x000000083a167824ULL, 0x000fca00078e00ffULL,
0xfffffff016177812ULL, 0x000fc800078ec0ffULL, 0x0176b057170075a7ULL, 0x000ea2000800014aULL,
0x0000000a17377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x0001400048467836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000104d347824ULL, 0x000fd800078e0246ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011800004a14783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x000000104b3c7824ULL, 0x000fcc00078e0246ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000ff355a7812ULL, 0x010fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011637ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe40000011635ULL, 0x000000ff3f6c7812ULL, 0x022fe200078ec0ffULL,
0x2000005aff637230ULL, 0x000fe20000004100ULL, 0x0000ffff34627812ULL, 0x000fc400078ec0ffULL,
0x0000006dff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff677819ULL, 0x000fe40000011636ULL,
0x0000006cff6d723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe40000011637ULL, 0x000000ff4f6c7812ULL, 0x000fe200078ec0ffULL,
0x2000006dff4f7230ULL, 0x000fe20000004100ULL, 0x00000008ff627819ULL, 0x000fc40000011662ULL,
0x0000ffff36667812ULL, 0x000fe400078ec0ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x000000ff65657812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000006cff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fc4000001163cULL, 0x000000ff376e7812ULL, 0x000fe200078ec0ffULL,
0x20000062ff6c7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x000000ff34587812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fc40000011634ULL,
0x0000ffff375f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x000fe40000011634ULL,
0x000000ff69697812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011636ULL,
0x00000010ff617819ULL, 0x000fe4000001163dULL, 0x0000006eff6e723eULL, 0x000fc400020006ffULL,
0x00000066ff62723eULL, 0x000fe200020006ffULL, 0x20000067ff667230ULL, 0x000fe20000004100ULL,
0x00000018ff597819ULL, 0x000fe20000011635ULL, 0x20000065ff677230ULL, 0x000fe20000004100ULL,
0x0000ffff356a7812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000ffff3c647812ULL, 0x000fe400078ec0ffULL, 0x00000058ff35723eULL, 0x000fe400020006ffULL,
0x00000057ff37723eULL, 0x000fc400020006ffULL, 0x0000ffff3d687812ULL, 0x000fe200078ec0ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fe2000001163fULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x000000ff3c6f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe4000001163cULL,
0x00000018ff577819ULL, 0x000fc4000001163eULL, 0x000000ff56567812ULL, 0x000fe400078ec0ffULL,
0x00000069ff65723eULL, 0x000fe400020006ffULL, 0x0000005dff3c723eULL, 0x000fe200020006ffULL,
0x2000006eff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff61697812ULL, 0x000fe200078ec0ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff617819ULL, 0x000fe20000011664ULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000006bff6e723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x2000005fff647230ULL, 0x000fe20000004100ULL,
0x00000056ff6b723eULL, 0x000fe400020006ffULL, 0x00000010ff607819ULL, 0x000fe2000001163eULL,
0x20000057ff567230ULL, 0x000fe20000004100ULL, 0x00000008ff6a7819ULL, 0x000fe2000001166aULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x2000006eff577230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc4000001163fULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000069ff5f723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff60697812ULL, 0x000fe200078ec0ffULL,
0x20000061ff607230ULL, 0x000fe20000004100ULL, 0x000000ff346e7812ULL, 0x000fe200078ec0ffULL,
0x20000068ff617230ULL, 0x000fe20000004100ULL, 0x000000ff365e7812ULL, 0x000fe200078ec0ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe20000011635ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc40000011663ULL,
0x00000010ff687819ULL, 0x000fe4000001166dULL, 0x0000ffff3e367812ULL, 0x000fe400078ec0ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000069ff637230ULL, 0x000fe20000004100ULL,
0x0000105468357816ULL, 0x000fc40000000035ULL, 0x000010546b347816ULL, 0x000fe20000000034ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff687819ULL, 0x000fe40000011636ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff367819ULL, 0x000fe2000001166cULL,
0x000000341418723cULL, 0x008fe20000041818ULL, 0x00000010ff697819ULL, 0x000fe40000011659ULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105469377816ULL, 0x000fe4000000006aULL, 0x00000018ff5b7819ULL, 0x000fe4000001163dULL,
0x00000010ff347819ULL, 0x000fe4000001165eULL, 0x00000010ff357819ULL, 0x000fe20000011666ULL,
0x000000361428723cULL, 0x000fe20000041828ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff5e7819ULL, 0x000fe40000011667ULL, 0x000000ff3d707812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3f5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3e3d7812ULL, 0x000fe400078ec0ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000005bff3e723eULL, 0x000fc400020006ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x000010545e357816ULL, 0x000fe2000000005dULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fe4000001165cULL, 0x00000010ff377819ULL, 0x000fe4000001163cULL,
0x00000010ff367819ULL, 0x000fe20000011662ULL, 0x00000034142c723cULL, 0x000fe2000004182cULL,
0x00000010ff5d7819ULL, 0x000fc4000001165aULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000003dff3f723eULL, 0x000fe200020006ffULL, 0x2000006fff5b7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x20000070ff3d7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000068ff5c7230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000006eff597230ULL, 0x000fe20000004100ULL,
0x000010545d377816ULL, 0x000fe20000000064ULL, 0x20000069ff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc40000011658ULL, 0x00000010ff587819ULL, 0x000fe4000001163eULL,
0x00000010ff3e7819ULL, 0x000fe20000011660ULL, 0x000000361430723cULL, 0x000fe20000041830ULL,
0x00000010ff3c7819ULL, 0x000fe4000001165bULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff5b7819ULL, 0x000fe4000001163fULL, 0x00000010ff347819ULL, 0x000fc4000001165fULL,
0x00001054353e7816ULL, 0x000fe4000000003eULL, 0x00000010ff377819ULL, 0x000fe40000011656ULL,
0x00000010ff367819ULL, 0x000fe4000001165cULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff3f7819ULL, 0x000fe40000011661ULL, 0x00000010ff5e7819ULL, 0x000fc40000011663ULL,
0x00000010ff357819ULL, 0x000fe4000001164fULL, 0x00000010ff567819ULL, 0x000fe40000011659ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00001054343d7816ULL, 0x000fe4000000003dULL, 0x0000105437367816ULL, 0x000fc40000000036ULL,
0x00001054653c7816ULL, 0x000fe4000000003cULL, 0x00001054583f7816ULL, 0x000fe4000000003fULL,
0x000010545e347816ULL, 0x000fe4000000005bULL, 0x0000105456357816ULL, 0x000fe20000000035ULL,
0x0000003c1424723cULL, 0x000fe20000041824ULL, 0x0000105457377816ULL, 0x000fca000000005aULL,
0x0000003e1420723cULL, 0x000fec0000041820ULL, 0x00000034141c723cULL, 0x000fec000004181cULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x0000001049347824ULL, 0x000fe200078e0246ULL,
0x011800004e14783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x00000010473c7824ULL, 0x000fe200078e0246ULL,
0x000000003434783bULL, 0x000f2a0000004200ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x000000ff35577812ULL, 0x010fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011636ULL,
0x00000018ff4e7819ULL, 0x002fc40000011634ULL, 0x00000018ff567819ULL, 0x100fe40000011635ULL,
0x000000ff3c6c7812ULL, 0x020fe400078ec0ffULL, 0x000000ff344f7812ULL, 0x040fe400078ec0ffULL,
0x00000010ff6b7819ULL, 0x000fe40000011634ULL, 0x0000ffff34697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6a7819ULL, 0x000fc40000011635ULL, 0x00000010ff637819ULL, 0x000fe40000011636ULL,
0x000000ff365c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff36627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011637ULL, 0x00000057ff67723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x0000ffff35647812ULL, 0x000fe200078ec0ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe40000011637ULL,
0x000000ff375e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff37657812ULL, 0x000fe400078ec0ffULL,
0x0000004eff60723eULL, 0x000fe400020006ffULL, 0x00000056ff61723eULL, 0x000fc400020006ffULL,
0x00000010ff367819ULL, 0x100fe2000001163cULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000018ff577819ULL, 0x000fe2000001163cULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000ffff3c347812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000004fff68723eULL, 0x000fe400020006ffULL, 0x00000010ff377819ULL, 0x000fc4000001163dULL,
0x000000ff3d6d7812ULL, 0x040fe200078ec0ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000018ff567819ULL, 0x000fe4000001163dULL, 0x0000ffff3d357812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x100fe4000001163eULL, 0x000000ff3e597812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001163eULL, 0x0000ffff3e4e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x100fe4000001163fULL, 0x000000ff3f3e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f4f7812ULL, 0x000fe400078ec0ffULL,
0x0000005dff3f723eULL, 0x000fe200020006ffULL, 0x20000058ff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL, 0x2000006cff587230ULL, 0x000fe20000004100ULL,
0x000000ff6a6a7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff697819ULL, 0x000fe40000011669ULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000059ff6c723eULL, 0x000fe400020006ffULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x00000008ff627819ULL, 0x000fe40000011662ULL,
0x0000006bff6b723eULL, 0x000fc400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000006dff597230ULL, 0x000fe20000004100ULL, 0x0000003eff6e723eULL, 0x000fe200020006ffULL,
0x2000006cff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff66667812ULL, 0x000fe200078ec0ffULL,
0x2000006aff6c7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000069ff6a7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000064ff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff36367812ULL, 0x000fc400078ec0ffULL,
0x000000ff37377812ULL, 0x000fe200078ec0ffULL, 0x20000062ff647230ULL, 0x000fe20000004100ULL,
0x00000066ff69723eULL, 0x000fe200020006ffULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x00000036ff62723eULL, 0x000fe400020006ffULL, 0x00000037ff63723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011668ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011667ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fc4000001166bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x00000008ff677819ULL, 0x000fe40000011634ULL,
0x00000008ff687819ULL, 0x000fe40000011635ULL, 0x0000005eff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe20000011660ULL,
0x2000003fff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe2000001166aULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000010546b367816ULL, 0x000fc40000000036ULL,
0x000010546c377816ULL, 0x000fe40000000037ULL, 0x00000010ff607819ULL, 0x000fe40000011661ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x000000361418723cULL, 0x008fe20000041818ULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x0000105460357816ULL, 0x000fe2000000006dULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fc4000001165fULL, 0x00000010ff367819ULL, 0x000fe4000001165eULL,
0x00000010ff377819ULL, 0x000fe20000011666ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x00000010ff347819ULL, 0x000fe40000011664ULL, 0x00000010ff357819ULL, 0x000fe40000011665ULL,
0x0000105469377816ULL, 0x000fe40000000060ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000056ff3f723eULL, 0x000fe200020006ffULL,
0x20000057ff567230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000067ff5f7230ULL, 0x000fe20000004100ULL, 0x000010545d347816ULL, 0x000fe20000000034ULL,
0x2000003fff577230ULL, 0x000fe20000004100ULL, 0x000010545c357816ULL, 0x000fe20000000035ULL,
0x20000068ff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL,
0x2000006eff3f7230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00000010ff367819ULL, 0x000fe40000011658ULL, 0x00000010ff377819ULL, 0x000fe20000011662ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x000fe40000011663ULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff357819ULL, 0x000fc40000011656ULL,
0x00000010ff347819ULL, 0x000fe4000001165fULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x00000010ff577819ULL, 0x000fe20000011657ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x0000105458377816ULL, 0x000fc40000000059ULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x0000105435347816ULL, 0x000fe20000000034ULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000105457357816ULL, 0x000fc4000000005eULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe4000001163eULL, 0x00000010ff377819ULL, 0x000fe2000001165aULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff3f7819ULL, 0x000fe2000001163fULL,
0x000000341420723cULL, 0x000fe20000041820ULL, 0x00000010ff3e7819ULL, 0x000fe4000001165bULL,
0x0000105437367816ULL, 0x000fc40000000036ULL, 0x000010543e377816ULL, 0x000fe4000000003fULL,
0x00000010ff357819ULL, 0x000fe4000001163cULL, 0x00000010ff3c7819ULL, 0x000fe4000001164eULL,
0x00000010ff347819ULL, 0x000fe2000001163dULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x00000010ff3d7819ULL, 0x000fe4000001164fULL, 0x00001054353c7816ULL, 0x000fe2000000003cULL,
0x000000023a357824ULL, 0x000fe200078e00ffULL, 0x00001054343d7816ULL, 0x000fc4000000003dULL,
0x0000000a0b347c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0xfffffff835367812ULL, 0x000fc600078ec0ffULL, 0x0000003c1410723cULL, 0x000fe20000041810ULL,
0x0176c837343479a7ULL, 0x0002e2000850003fULL, 0x0176903736ff79a7ULL, 0x0003de000850000aULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035440075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035440075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000100044f7824ULL, 0x000fc800078e0209ULL,
0x000000c04f177836ULL, 0x000fca0000000000ULL, 0x0000006017157812ULL, 0x000fca00078ec0ffULL,
0x000000010a357824ULL, 0x000fe200078e0215ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x0000001738147248ULL, 0x000fe20007fe0000ULL, 0x000000103a157824ULL, 0x000fc800078e00ffULL,
0x0000000114147824ULL, 0x000fe200078e0a17ULL, 0x0000001015177812ULL, 0x000fe400078ec0ffULL,
0x00000003ff157819ULL, 0x000fe4000001160eULL, 0x0000001417147248ULL, 0x000fc60007fe0000ULL,
0x0000000415347836ULL, 0x000fe40000000000ULL, 0x0000000114147824ULL, 0x100fe400078e0a17ULL,
0x0000000115167824ULL, 0x140fe400078e0217ULL, 0x0000000815377836ULL, 0x002fe20000000000ULL,
0x000000141500720cULL, 0x080fe20003f86070ULL, 0x0000000c153c7836ULL, 0x000fe20000000000ULL,
0x000000143400720cULL, 0x0c0fe20003f66070ULL, 0x0000000134367824ULL, 0x000fe200078e0217ULL,
0x000000143700720cULL, 0x080fe20003f46070ULL, 0x0000000116157824ULL, 0x000fe200078e0235ULL,
0x000000143c00720cULL, 0x000fe20003f06070ULL, 0x0000000116347824ULL, 0x000fc400078e020eULL,
0x0000000816577824ULL, 0x000fe400078e00ffULL, 0x0000000136167824ULL, 0x040fe400078e020eULL,
0x0000000836597824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee234ULL,
0x0000008015147825ULL, 0x000fc600078e00ffULL, 0xfffffff859597812ULL, 0x000fe200078ee216ULL,
0x0000000137377824ULL, 0x000fe400078e0217ULL, 0x0000000136367824ULL, 0x000fe400078e0235ULL,
0x000000013c3e7824ULL, 0x000fe200078e0217ULL, 0x0000004214177212ULL, 0x000fe200078efcffULL,
0x0000000137167824ULL, 0x040fe400078e0235ULL, 0x00000001373c7824ULL, 0x040fe200078e020eULL,
0x0000001754147210ULL, 0x000fe20007fbe0ffULL, 0x00000008375b7824ULL, 0x000fc400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee23cULL,
0x000000013e347824ULL, 0x000fe200078e0235ULL, 0x00000042363d7212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x00000042163f7212ULL, 0x000fc600078efcffULL, 0x0000000155157824ULL, 0x040fe200028e0615ULL,
0x0000003d54367210ULL, 0x000fe20007fbe0ffULL, 0x000000013e3c7824ULL, 0x000fe200078e020eULL,
0x00000042343d7212ULL, 0x000fe200078efcffULL, 0x000000083e5d7824ULL, 0x000fe400078e00ffULL,
0x0000000155377824ULL, 0x000fe200028e0637ULL, 0x0000003f54167210ULL, 0x000fe20007fbe0ffULL,
0x0000001057577824ULL, 0x100fe200078e0246ULL, 0x0000003d54347210ULL, 0x000fe20007fde0ffULL,
0x0000001059597824ULL, 0x100fe200078e0246ULL, 0xfffffff85d3d7812ULL, 0x000fe200078ee23cULL,
0x0000000155177824ULL, 0x000fe200028e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014577faeULL, 0x0003e2000e101c48ULL, 0x000000105b5b7824ULL, 0x000fc400078e0246ULL,
0x0000000155357824ULL, 0x000fe200030e0635ULL, 0x0000000036597faeULL, 0x0003e2000d901c48ULL,
0x000000103d3d7824ULL, 0x000fc600078e0246ULL, 0x00000000165b7faeULL, 0x0003e8000d101c48ULL,
0x00000000343d7faeULL, 0x0003e2000c101c48ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x000000103a147824ULL, 0x000fca00078e00ffULL, 0x0000001014157812ULL, 0x000fc800078ec0ffULL,
0x000000150e157211ULL, 0x000fca00078fe8ffULL, 0x0000000415167836ULL, 0x000fe40000000000ULL,
0x0000000115147824ULL, 0x140fe400078e020eULL, 0x0000000815597824ULL, 0x000fe400078e00ffULL,
0x0000000815347836ULL, 0x000fe40000000000ULL, 0x0000000116177824ULL, 0x040fe200078e020eULL,
0xfffffff859597812ULL, 0x000fe200078ee214ULL, 0x00000008163c7824ULL, 0x000fc400078e00ffULL,
0x0000000115147824ULL, 0x000fe400078e0235ULL, 0x0000000134367824ULL, 0x042fe200078e020eULL,
0xfffffff83c5b7812ULL, 0x000fe200078ee217ULL, 0x00000008345d7824ULL, 0x000fe400078e00ffULL,
0x0000000c15177836ULL, 0x000fe40000000000ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fc600078ee236ULL, 0x0000000116167824ULL, 0x100fe200078e0235ULL,
0x00000042143d7212ULL, 0x000fe200078efcffULL, 0x0000000134347824ULL, 0x100fe400078e0235ULL,
0x0000000117367824ULL, 0x040fe200078e0235ULL, 0x0000003d54147210ULL, 0x000fe20007f1e0ffULL,
0x00000001173c7824ULL, 0x040fe400078e020eULL, 0x00000008175f7824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee23cULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004216577212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000042343f7212ULL, 0x080fe400078efcffULL,
0x0000005754167210ULL, 0x000fe20007f5e0ffULL, 0x0000000155157824ULL, 0x000fe200000e0615ULL,
0x00000042363d7212ULL, 0x000fe200078efcffULL, 0x0000001059597824ULL, 0x100fe200078e0246ULL,
0x0000003f54347210ULL, 0x000fe20007f1e0ffULL, 0x0000000155177824ULL, 0x000fe200010e0617ULL,
0x0000003d54367210ULL, 0x000fe20007f7e0ffULL, 0x000000105b5b7824ULL, 0x000fe200078e0246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014597faeULL, 0x0003e2000b901c48ULL,
0x0000000155357824ULL, 0x000fc400000e0635ULL, 0x000000105d5d7824ULL, 0x100fe200078e0246ULL,
0x00000000165b7faeULL, 0x0003e2000b901c48ULL, 0x0000000155377824ULL, 0x000fe400018e0637ULL,
0x000000105f5f7824ULL, 0x000fe200078e0246ULL, 0x00000000345d7faeULL, 0x0003e8000b901c48ULL,
0x00000000365f7faeULL, 0x0003e4000b901c48ULL, 0x000000020c0c7836ULL, 0x000fe20000000000ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0xffffffffff4e7424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x000000390c00720cULL, 0x000fca0003f06070ULL,
0x00000000ff0079b0ULL, 0x000ff00008000a45ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x000000010c178824ULL, 0x000fe400078e0205ULL, 0x000000083a167824ULL, 0x000fc400078e00ffULL,
0x0000000417148825ULL, 0x002fca00078e0014ULL, 0x00000008144e8981ULL, 0x000322000c1e1900ULL,
0x0000000aff177e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff016167812ULL, 0x000fc800078ec0ffULL,
0x000176a816547810ULL, 0x000fe20007ffe017ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000817545479a7ULL, 0x000664000850003fULL,
0x017648174c1679a7ULL, 0x0086a4000850003fULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x017648174c0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003414377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017648174c0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000203a147824ULL, 0x000fe400078e00ffULL,
0x0000000aff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000010015147810ULL, 0x000fc80007ffe014ULL,
0x0000001445147210ULL, 0x000fca0007ffe042ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0004a20000000800ULL, 0x000000511600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x0000000207157836ULL, 0x000fe20000000000ULL,
0x000000511600720bULL, 0x000fc80003f14000ULL, 0x0000003a1500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x0000000a3a15ac11ULL, 0x000fe4000f8e38ffULL,
0x000000511614a209ULL, 0x000fe40007810000ULL, 0x000000154537a210ULL, 0x000fe40007ffe042ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160eULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x000000083a167824ULL, 0x000fca00078e00ffULL,
0xfffffff016177812ULL, 0x000fc800078ec0ffULL, 0x0176a853170075a7ULL, 0x000e62000800014aULL,
0x0000000a17377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176a853370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x00013000484c7836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000104d347824ULL, 0x000fd800078e024cULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x012000004a14783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000104b3c7824ULL, 0x000fe200078e024cULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000070e4b7812ULL, 0x000fe200078ec0ffULL, 0x0000000243487836ULL, 0x000fc60000000000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000084b4b7812ULL, 0x000fca00078ef80eULL,
0x000000084b4b7824ULL, 0x000fca00078e00ffULL, 0xfffffff84b487812ULL, 0x000fe400078ee248ULL,
0x000000ff35567812ULL, 0x022fe400078ec0ffULL, 0x00000010ff627819ULL, 0x100fe40000011636ULL,
0x000000ff365b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011636ULL,
0x0000ffff365a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff687819ULL, 0x000fe40000011634ULL,
0x00000010ff597819ULL, 0x100fe40000011637ULL, 0x000000ff375c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011637ULL, 0x0000ffff375d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x008fc4000001163cULL, 0x000000ff3c6c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c367812ULL, 0x000fe400078ec0ffULL,
0x000000ff344a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff35657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x000fc4000001163dULL, 0x000000ff3d6d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d377812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e3d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe4000001163fULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x00000010ff677819ULL, 0x000fe40000011635ULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x20000056ff647230ULL, 0x000fe20000004100ULL,
0x0000ffff34667812ULL, 0x000fe400078ec0ffULL, 0x0000004aff63723eULL, 0x000fe400020006ffULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x00000018ff4a7819ULL, 0x000fe2000001163eULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000006aff56723eULL, 0x000fe400020006ffULL, 0x00000008ff667819ULL, 0x000fc40000011666ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000004aff6a723eULL, 0x000fe200020006ffULL,
0x2000003dff4a7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000069ff3d7230ULL, 0x000fe20000004100ULL, 0x000000ff59597812ULL, 0x000fe200078ec0ffULL,
0x20000068ff697230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000065ff687230ULL, 0x000fe20000004100ULL, 0x00000018ff527819ULL, 0x000fe20000011635ULL,
0x20000062ff657230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x00000010ff357819ULL, 0x000fe4000001163fULL, 0x000000ff3f4b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3f587812ULL, 0x000fe200078ec0ffULL, 0x2000003cff3f7230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x2000006aff3c7230ULL, 0x000fe20000004100ULL,
0x00000008ff5d7819ULL, 0x000fe2000001165dULL, 0x20000067ff6a7230ULL, 0x000fe20000004100ULL,
0x00000008ff5a7819ULL, 0x000fe2000001165aULL, 0x20000066ff677230ULL, 0x000fe20000004100ULL,
0x000000ff61627812ULL, 0x000fe200078ec0ffULL, 0x20000059ff667230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000062ff59723eULL, 0x000fe200020006ffULL, 0x2000005dff627230ULL, 0x000fe20000004100ULL,
0x00000008ff367819ULL, 0x000fe20000011636ULL, 0x2000005aff617230ULL, 0x000fe20000004100ULL,
0x00000008ff377819ULL, 0x000fe20000011637ULL, 0x20000059ff5d7230ULL, 0x000fe20000004100ULL,
0x00000036ff59723eULL, 0x000fe400020006ffULL, 0x00000037ff5a723eULL, 0x000fc400020006ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011634ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011663ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe40000011664ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000105469367816ULL, 0x000fe20000000036ULL,
0x2000004dff5f7230ULL, 0x000fe20000004100ULL, 0x000010546a377816ULL, 0x000fe20000000037ULL,
0x20000052ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc4000001163eULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x000000361418723cULL, 0x000fe20000041818ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x000000ff34637812ULL, 0x000fe400078ec0ffULL, 0x000000ff35647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff367819ULL, 0x000fc4000001165bULL, 0x00000010ff377819ULL, 0x000fe4000001165cULL,
0x0000006cff4d723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fc40000011667ULL, 0x00000010ff357819ULL, 0x000fe40000011668ULL,
0x0000006dff52723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x0000105465367816ULL, 0x000fe20000000036ULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x0000105466377816ULL, 0x000fe20000000037ULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x000010545f347816ULL, 0x000fc40000000034ULL, 0x0000105460357816ULL, 0x000fe40000000035ULL,
0x00000010ff527819ULL, 0x000fe20000011652ULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x0000ffff3e537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff577819ULL, 0x000fe20000011657ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff367819ULL, 0x000fc4000001164dULL, 0x00000010ff377819ULL, 0x000fe4000001165eULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff347819ULL, 0x000fe40000011661ULL,
0x00000010ff357819ULL, 0x000fe40000011662ULL, 0x0000006bff3e723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fc40000000036ULL, 0x000010545d377816ULL, 0x000fe20000000052ULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000008ff537819ULL, 0x000fe40000011653ULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x0000105457347816ULL, 0x000fe20000000034ULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x0000105456357816ULL, 0x000fe40000000035ULL,
0x0000004bff4b723eULL, 0x000fc400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x000002003a377824ULL, 0x000fe200078e00ffULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fe2000001163fULL, 0x20000063ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe2000001163eULL, 0x20000064ff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe20000011659ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe2000001165aULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff3e7819ULL, 0x000fc4000001164aULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0xfffff80037377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x000fe4000001164bULL,
0x000010543f357816ULL, 0x000fe2000000005aULL, 0x0000000a37377c36ULL, 0x000fe20008000000ULL,
0x00000010ff367819ULL, 0x000fe4000001163dULL, 0x00000010ff4b7819ULL, 0x000fc4000001165cULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff3d7819ULL, 0x000fe40000011658ULL, 0x000010544b3e7816ULL, 0x000fe2000000003eULL,
0x0000001048347824ULL, 0x000fe200078e0237ULL, 0x000010545b3f7816ULL, 0x000fe2000000004aULL,
0x0000001049357824ULL, 0x000fe200078e024cULL, 0x000010543c3c7816ULL, 0x000fc40000000053ULL,
0x00001054363d7816ULL, 0x000fc6000000003dULL, 0x0000003e141c723cULL, 0x000fec000004181cULL,
0x0000003c1410723cULL, 0x000fe20000041810ULL, 0x012000003414783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003534783bULL, 0x002e620000004200ULL, 0x00000010473c7824ULL, 0x000fcc00078e024cULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x00000010ff667819ULL, 0x002fe40000011634ULL,
0x00000010ff657819ULL, 0x000fe40000011635ULL, 0x0000ffff34647812ULL, 0x040fe400078ec0ffULL,
0x000000ff34497812ULL, 0x000fe400078ec0ffULL, 0x000000ff354a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x000fc40000011636ULL, 0x000000ff36527812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011636ULL, 0x00000010ff5f7819ULL, 0x100fe40000011637ULL,
0x000000ff37587812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011637ULL,
0x0000ffff355e7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff36367812ULL, 0x000fe400078ec0ffULL,
0x0000ffff37377812ULL, 0x000fe400078ec0ffULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x00000049ff49723eULL, 0x000fc400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x20000049ff637230ULL, 0x000fe20000004100ULL,
0x00000018ff477819ULL, 0x000fe20000011634ULL, 0x2000004aff627230ULL, 0x000fe20000004100ULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff347819ULL, 0x000fe40000011635ULL,
0x00000018ff677819ULL, 0x028fc4000001163cULL, 0x00000018ff687819ULL, 0x000fe4000001163dULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x00000008ff367819ULL, 0x000fe40000011636ULL,
0x00000008ff377819ULL, 0x000fc40000011637ULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x000000ff3c597812ULL, 0x000fe400078ec0ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000047ff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff617819ULL, 0x000fc4000001163dULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000034ff5b723eULL, 0x000fe400020006ffULL,
0x00000010ff607819ULL, 0x000fe4000001163cULL, 0x000000ff3d697812ULL, 0x040fe200078ec0ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000ffff3d357812ULL, 0x000fe400078ec0ffULL,
0x00000067ff4a723eULL, 0x000fe200020006ffULL, 0x20000066ff677230ULL, 0x000fe20000004100ULL,
0x00000068ff49723eULL, 0x000fe200020006ffULL, 0x20000065ff687230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000064ff667230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x2000005dff647230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x2000005fff657230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x100fe2000001163fULL, 0x20000036ff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff3f6b7812ULL, 0x040fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fe2000001163fULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x0000ffff3f4b7812ULL, 0x000fc400078ec0ffULL, 0x00000059ff3f723eULL, 0x000fe200020006ffULL,
0x20000052ff597230ULL, 0x000fe20000004100ULL, 0x000000ff61617812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c347812ULL, 0x000fe400078ec0ffULL, 0x00000069ff52723eULL, 0x000fe200020006ffULL,
0x2000005eff697230ULL, 0x000fe20000004100ULL, 0x000000ff605d7812ULL, 0x000fe200078ec0ffULL,
0x20000037ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011663ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fc40000011662ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000061ff5e723eULL, 0x000fe400020006ffULL, 0x00000008ff617819ULL, 0x000fe40000011634ULL,
0x00000008ff627819ULL, 0x000fe20000011635ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x00000010ff357819ULL, 0x000fe4000001165cULL,
0x00000010ff347819ULL, 0x000fe20000011666ULL, 0x20000058ff5a7230ULL, 0x000fe20000004100ULL,
0x0000105467367816ULL, 0x000fe40000000036ULL, 0x0000105468377816ULL, 0x000fe40000000037ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165bULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff537819ULL, 0x100fe2000001163eULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x000000ff3e6a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e477812ULL, 0x000fe400078ec0ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000057ff3e723eULL, 0x000fc400020006ffULL, 0x0000105435347816ULL, 0x000fe20000000034ULL,
0x2000004dff577230ULL, 0x000fe20000004100ULL, 0x000010545c357816ULL, 0x000fe20000000069ULL,
0x2000003eff587230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011659ULL,
0x2000003fff4d7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe40000011664ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165aULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff5c7819ULL, 0x000fc40000011665ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x00000010ff577819ULL, 0x000fe20000011657ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff347819ULL, 0x000fe4000001165fULL, 0x00000010ff357819ULL, 0x000fc40000011660ULL,
0x000010545c377816ULL, 0x000fe4000000005bULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000105457347816ULL, 0x000fe20000000034ULL,
0x20000061ff597230ULL, 0x000fe20000004100ULL, 0x0000105458357816ULL, 0x000fe20000000035ULL,
0x20000062ff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff53537812ULL, 0x000fe200078ec0ffULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x000000ff56567812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000010ff367819ULL, 0x000fe4000001164dULL,
0x00000010ff377819ULL, 0x000fe40000011652ULL, 0x0000006aff3e723eULL, 0x000fe400020006ffULL,
0x0000006bff3f723eULL, 0x000fc400020006ffULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000008ff4b7819ULL, 0x000fe2000001164bULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe2000001164aULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe40000011659ULL,
0x000010545d367816ULL, 0x000fc40000000036ULL, 0x000010545e377816ULL, 0x000fe40000000037ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x000000361424723cULL, 0x000fe20000041824ULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000105435347816ULL, 0x000fc40000000034ULL,
0x0000105449357816ULL, 0x000fe2000000005aULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000010ff367819ULL, 0x000fe2000001163eULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe2000001163fULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x00000010ff567819ULL, 0x000fc40000011656ULL, 0x0000105453367816ULL, 0x000fe40000000036ULL,
0x0000105456377816ULL, 0x000fe40000000037ULL, 0x00000010ff347819ULL, 0x000fe4000001163dULL,
0x00000010ff3d7819ULL, 0x000fe4000001164bULL, 0x00000010ff3c7819ULL, 0x000fe2000001163cULL,
0x00000036141c723cULL, 0x000fe2000004181cULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00001054343d7816ULL, 0x000fe4000000003dULL, 0x0000000a0b347c11ULL, 0x000fe4000f8e18ffULL,
0x000010543c3c7816ULL, 0x000fe20000000047ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000a07367c11ULL, 0x000fc6000f8e18ffULL, 0x0176c837343479a7ULL, 0x0002e4000850003fULL,
0x0000003c1410723cULL, 0x000fe20000041810ULL, 0x0176983736ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035440075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035440075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000104147836ULL, 0x000fca0000000000ULL,
0x0000000d1400720cULL, 0x000fda0003f06070ULL, 0x0000000400e80947ULL, 0x000fea0003800000ULL,
0x00008e00ff147b82ULL, 0x000ee20000000a00ULL, 0x0000000204167836ULL, 0x000fe20000000000ULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x000001004f4f7836ULL, 0x000fe40000000000ULL,
0x000000054e347c24ULL, 0x010fe2000f8e02ffULL, 0x0000000d1600720cULL, 0x000fe40003f06070ULL,
0x000000604f177812ULL, 0x000fe200078ec0ffULL, 0x0000008034357824ULL, 0x000fc800078e00ffULL,
0x000000010a3d7824ULL, 0x000fe400078e0217ULL, 0x0000008035147825ULL, 0x008fc800078e0014ULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x0000004f38167248ULL, 0x000fe20007fe0000ULL,
0x000000103a177824ULL, 0x000fe200078e00ffULL, 0x00000003ff347819ULL, 0x000fc6000001160eULL,
0x0000000116167824ULL, 0x000fe200078e0a4fULL, 0x0000001017177812ULL, 0x000fe200078ec0ffULL,
0x0000000434367836ULL, 0x002fe40000000000ULL, 0x0000000834377836ULL, 0x000fe20000000000ULL,
0x0000001617167248ULL, 0x000fe20007fe0000ULL, 0x0000000c343e7836ULL, 0x000fe40000000000ULL,
0x0000000134357824ULL, 0x100fe400078e0217ULL, 0x0000000116167824ULL, 0x000fc400078e0a17ULL,
0x00000001373c7824ULL, 0x100fe400078e0217ULL, 0x000000013e447824ULL, 0x100fe200078e0217ULL,
0x000000163600720cULL, 0x0c0fe20003f66070ULL, 0x0000000136367824ULL, 0x000fe200078e0217ULL,
0x000000163e00720cULL, 0x080fe20003f06070ULL, 0x0000000835497824ULL, 0x000fe200078e00ffULL,
0x000000163400720cULL, 0x080fe20003f86070ULL, 0x0000000136177824ULL, 0x040fe200078e020eULL,
0x000000163700720cULL, 0x000fe20003f46070ULL, 0x00000008363e7824ULL, 0x000fc400078e00ffULL,
0x0000000135347824ULL, 0x140fe400078e023dULL, 0x0000000135167824ULL, 0x100fe200078e020eULL,
0xfffffff83e4b7812ULL, 0x000fe200078ee217ULL, 0x0000000136367824ULL, 0x000fe400078e023dULL,
0x000000013c357824ULL, 0x040fe200078e020eULL, 0xfffffff849497812ULL, 0x000fe200078ee216ULL,
0x000000083c4a7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff84a4d7812ULL, 0x000fe200078ee235ULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000013c167824ULL, 0x100fe200078e023dULL, 0x00000042343f7212ULL, 0x080fe200078efcffULL,
0x00000001443c7824ULL, 0x000fe200078e023dULL, 0x00000042363d7212ULL, 0x080fe200078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003f14347210ULL, 0x000fe40007fbe0ffULL,
0x0000003d14367210ULL, 0x000fe20007fde0ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000004216477212ULL, 0x000fc600078efcffULL, 0x00000001443e7824ULL, 0x000fe200078e020eULL,
0x000000423c3f7212ULL, 0x000fe200078efcffULL, 0x00000008444f7824ULL, 0x000fe400078e00ffULL,
0x0000000115357824ULL, 0x040fe200028e0635ULL, 0x0000004714167210ULL, 0x000fe20007fbe0ffULL,
0x0000000115377824ULL, 0x000fe200030e0637ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee23eULL,
0x0000001049497824ULL, 0x100fe200078e024cULL, 0x0000003f14147210ULL, 0x000fe20007fde0ffULL,
0x000000104b4b7824ULL, 0x000fc400078e024cULL, 0x000000104d4d7824ULL, 0x100fe200078e024cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034497faeULL, 0x0003e2000e101c48ULL,
0x0000000115177824ULL, 0x000fe400028e0617ULL, 0x000000104f4f7824ULL, 0x000fe200078e024cULL,
0x00000000364b7faeULL, 0x0003e2000d901c48ULL, 0x0000000115157824ULL, 0x000fc600030e063dULL,
0x00000000164d7faeULL, 0x0003e8000d101c48ULL, 0x00000000144f7faeULL, 0x0003e2000c101c48ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x000000103a167824ULL, 0x000fca00078e00ffULL,
0x0000001016177812ULL, 0x000fc800078ec0ffULL, 0x000000170e177211ULL, 0x000fca00078fe8ffULL,
0x0000000117167824ULL, 0x040fe400078e023dULL, 0x0000000117347824ULL, 0x040fe400078e020eULL,
0x00000008173f7824ULL, 0x000fe400078e00ffULL, 0x0000000417357836ULL, 0x000fe40000000000ULL,
0x00000008173e7836ULL, 0x000fe20000000000ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee234ULL,
0x0000000c17447836ULL, 0x000fc40000000000ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000000135347824ULL, 0x140fe400078e023dULL, 0x0000000135377824ULL, 0x142fe400078e020eULL,
0x00000008354a7824ULL, 0x000fe200078e00ffULL, 0x0000004216357212ULL, 0x000fe200078efcffULL,
0x000000013e3c7824ULL, 0x100fe400078e023dULL, 0x0000000144367824ULL, 0x000fe200078e023dULL,
0x0000003514167210ULL, 0x000fe20007f1e0ffULL, 0x000000013e3d7824ULL, 0x040fe200078e020eULL,
0xfffffff84a477812ULL, 0x000fe200078ee237ULL, 0x000000083e527824ULL, 0x000fc400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff8524f7812ULL, 0x000fe200078ee23dULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004234497212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x00000010474d7824ULL, 0x000fe200078e024cULL,
0x000000423c477212ULL, 0x080fe200078efcffULL, 0x00000001443e7824ULL, 0x040fe400078e020eULL,
0x0000000844537824ULL, 0x000fe200078e00ffULL, 0x00000047143c7210ULL, 0x000fe20007f5e0ffULL,
0x000000103f4b7824ULL, 0x100fe200078e024cULL, 0x00000042363f7212ULL, 0x000fe200078efcffULL,
0x0000000115177824ULL, 0x000fe200000e0617ULL, 0x0000004914347210ULL, 0x000fe20007f1e0ffULL,
0x000000104f4f7824ULL, 0x100fe200078e024cULL, 0xfffffff853537812ULL, 0x000fe200078ee23eULL,
0x00000001153d7824ULL, 0x040fe200010e063dULL, 0x0000003f14147210ULL, 0x000fe20007f7e0ffULL,
0x0000000115357824ULL, 0x000fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000164b7faeULL, 0x0003e2000b901c48ULL, 0x0000001053537824ULL, 0x000fc400078e024cULL,
0x0000000115157824ULL, 0x000fe200018e0637ULL, 0x00000000344d7faeULL, 0x0003e8000b901c48ULL,
0x000000003c4f7faeULL, 0x0003e8000b901c48ULL, 0x0000000014537faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000a0b147c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0176a835141479a7ULL, 0x0002e4000850003fULL,
0x01766835063479a7ULL, 0x0022a4000850003fULL, 0x000000ffff477224ULL, 0x00afce00078e0015ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x01766835060075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01766835060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000a07157c11ULL, 0x000fe2000f8e38ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0x0000018042147810ULL, 0x000fca0007ffe015ULL, 0x0000000145147824ULL, 0x000fca00078e0214ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000511600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x004fea0003800000ULL,
0x0000000307157836ULL, 0x000fe20000000000ULL, 0x000000511600720bULL, 0x000fc80003f14000ULL,
0x0000003a1500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x0000000a3a15ac11ULL, 0x000fe4000f8e38ffULL, 0x000000511614a209ULL, 0x000fe40007810000ULL,
0x000000154545a210ULL, 0x000fe40007ffe042ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400144500a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005116147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005114147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160eULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001550507220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005116517209ULL, 0x000fd60007810000ULL, 0x8000005116160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005017507221ULL, 0x000fe20000010000ULL, 0x0000000a0b3f7c11ULL, 0x000fce000f8e20ffULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x0176b0553f0075a7ULL, 0x000e62000800017fULL,
0x000000043a167824ULL, 0x000fe400078e00ffULL, 0x0000000408357824ULL, 0x000fc600078e00ffULL,
0x0000000416167812ULL, 0x000fca00078ec0ffULL, 0x0000000216367836ULL, 0x000fc80000000000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e0036ULL, 0x0000000000600947ULL, 0x002fec0003800000ULL,
0x000000ffff3c7224ULL, 0x000fce00078e00ffULL, 0x000000103c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013c3c7836ULL, 0x000fce0000000000ULL, 0x0176b0553f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ffff3d7224ULL, 0x000fce00078e0036ULL,
0x000000070e457812ULL, 0x040fe200078ec0ffULL, 0x0000000307167836ULL, 0x000fe20000000000ULL,
0x000000080e447812ULL, 0x000fe400078ec0ffULL, 0x0000991034157816ULL, 0x000fe400000000ffULL,
0x0000000845147812ULL, 0x000fe400078ef80eULL, 0x000000350e497211ULL, 0x000fe400078fe0ffULL,
0x00000045443e7212ULL, 0x000fe200078efcffULL, 0x0000000814347824ULL, 0x000fe200078e00ffULL,
0x000000ff1500720cULL, 0x000fc60003f05270ULL, 0x000000013e147824ULL, 0x040fe200078e0249ULL,
0xfffffff834347812ULL, 0x000fe200078ee243ULL, 0x000000083e177824ULL, 0x000fe200078e00ffULL,
0x0000000a16437c11ULL, 0x000fc8000f8e58ffULL, 0xfffffff817157812ULL, 0x000fe200078ee214ULL,
0x0000001034147824ULL, 0x000fc800078e0243ULL, 0x0000001015347824ULL, 0x000fe200078e0246ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff167819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000816367836ULL, 0x000fe20000000000ULL,
0x0000541000157816ULL, 0x000fca0000000000ULL, 0x00001f1615037589ULL, 0x0002a800000e0000ULL,
0x00001f3615007589ULL, 0x0002e400000e0000ULL, 0x011000001414783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x088fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x0000003d0e427211ULL, 0x000fe200078fe0ffULL,
0x000000083e3d7824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x0000001048487824ULL, 0x000fe400078e0243ULL, 0x000000013e3c7824ULL, 0x000fca00078e0242ULL,
0xfffffff83d3d7812ULL, 0x000fca00078ee23cULL, 0x000000103d3d7824ULL, 0x000fcc00078e0246ULL,
0x000000003d3c783bULL, 0x000f640000004200ULL, 0x00000018ff4a7819ULL, 0x128fe40000011634ULL,
0x000000ff36537812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fe40000011634ULL,
0x000000ff344b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff34617812ULL, 0x000fc400078ec0ffULL,
0x000000ff37587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff437819ULL, 0x100fe40000011635ULL,
0x000000ff35347812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011635ULL,
0x0000ffff35607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fc40000011637ULL,
0x0000004aff35723eULL, 0x000fe400020006ffULL, 0x00000010ff597819ULL, 0x104fe4000001163cULL,
0x000000ff3c637812ULL, 0x040fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000018ff4a7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x00000010ff5f7819ULL, 0x100fe40000011636ULL,
0x00000018ff4f7819ULL, 0x000fe40000011636ULL, 0x0000ffff36567812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x100fe4000001163dULL, 0x000000ff3d657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fc4000001163dULL, 0x0000ffff3d5e7812ULL, 0x000fe400078ec0ffULL,
0x00000058ff3c723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x100fe4000001163fULL,
0x000000ff3f677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f527812ULL, 0x000fc400078ec0ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000054ff3f723eULL, 0x000fe200020006ffULL, 0x20000053ff547230ULL, 0x000fe20000004100ULL,
0x00000008ff567819ULL, 0x000fe20000011656ULL, 0x2000003cff537230ULL, 0x000fe20000004100ULL,
0x00000018ff627819ULL, 0x000fe2000001163eULL, 0x2000004dff587230ULL, 0x000fe20000004100ULL,
0x00000065ff3c723eULL, 0x000fe200020006ffULL, 0x2000003fff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fc40000011637ULL, 0x00000034ff5b723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x0000003dff65723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000ffff37377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff557819ULL, 0x000fe4000001163eULL,
0x000000ff3e667812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3e347812ULL, 0x000fe400078ec0ffULL,
0x0000004aff3f723eULL, 0x000fe400020006ffULL, 0x0000004fff3e723eULL, 0x000fe400020006ffULL,
0x00000064ff4a723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000063ff4f723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000062ff64723eULL, 0x000fc400020006ffULL, 0x0000004cff62723eULL, 0x000fe200020006ffULL,
0x20000065ff4c7230ULL, 0x000fe20000004100ULL, 0x000000ff43637812ULL, 0x000fe200078ec0ffULL,
0x20000064ff437230ULL, 0x000fe20000004100ULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000008ff377819ULL, 0x000fe20000011637ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x000000ff59657812ULL, 0x000fe200078ec0ffULL, 0x20000056ff597230ULL, 0x000fe20000004100ULL,
0x000000ff57577812ULL, 0x000fc400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000008ff567819ULL, 0x000fe4000001165cULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000063ff647230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0x20000061ff637230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x20000037ff5c7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x2000004bff5a7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000060ff617230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000057ff607230ULL, 0x000fe20000004100ULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff55377812ULL, 0x000fe200078ec0ffULL,
0x20000056ff557230ULL, 0x000fe20000004100ULL, 0x0000005dff57723eULL, 0x000fe200020006ffULL,
0x20000065ff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL,
0x2000005eff567230ULL, 0x000fe20000004100ULL, 0x00000037ff5e723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x000000ff36657812ULL, 0x000fc400078ec0ffULL,
0x00000010ff367819ULL, 0x000fe2000001165aULL, 0x2000005eff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe40000011662ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fc40000000036ULL, 0x0000105464377816ULL, 0x000fe2000000005bULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe40000011634ULL,
0x00000010ff357819ULL, 0x000fe40000011635ULL, 0x00000010ff347819ULL, 0x000fe20000011663ULL,
0x000000361418723cULL, 0x002fe20000041818ULL, 0x00000010ff5e7819ULL, 0x000fe40000011658ULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010545e357816ULL, 0x000fe40000000061ULL, 0x00000008ff5e7819ULL, 0x000fe40000011652ULL,
0x00000010ff367819ULL, 0x000fe40000011654ULL, 0x00000010ff377819ULL, 0x000fe20000011653ULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff5f7819ULL, 0x000fc4000001165fULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000066ff4b723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x20000067ff3d7230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000065ff587230ULL, 0x000fe20000004100ULL, 0x000010545f367816ULL, 0x000fe20000000036ULL,
0x2000005bff527230ULL, 0x000fe20000004100ULL, 0x0000105460377816ULL, 0x000fe20000000037ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc4000001163eULL,
0x00000010ff347819ULL, 0x000fe40000011659ULL, 0x00000010ff4d7819ULL, 0x000fe2000001164dULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x000010544d357816ULL, 0x000fe4000000005cULL,
0x00000010ff377819ULL, 0x000fc4000001163fULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff367819ULL, 0x000fe2000001164aULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164bULL, 0x00000010ff3f7819ULL, 0x000fe40000011657ULL,
0x00000010ff3e7819ULL, 0x000fe4000001164fULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff4a7819ULL, 0x000fe40000011655ULL, 0x00000010ff4b7819ULL, 0x000fe40000011656ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff587819ULL, 0x000fc40000011658ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff537819ULL, 0x000fe4000001165eULL, 0x000010543f3f7816ULL, 0x000fe4000000003cULL,
0x000010545d3e7816ULL, 0x000fe4000000003eULL, 0x00001054374a7816ULL, 0x000fc4000000004aULL,
0x00001054364b7816ULL, 0x000fe4000000004bULL, 0x000010545a3c7816ULL, 0x000fe2000000004dULL,
0x011000004834783bULL, 0x0002a20000000200ULL, 0x00001054583d7816ULL, 0x000fe2000000003dULL,
0x0000003e1424723cULL, 0x000fe20000041824ULL, 0x0000105443527816ULL, 0x000fe40000000052ULL,
0x000010544c537816ULL, 0x000fc60000000053ULL, 0x0000004a1420723cULL, 0x000fec0000041820ULL,
0x0000003c141c723cULL, 0x000fec000004181cULL, 0x000000521410723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x002fde0003800000ULL,
0x0000000334347232ULL, 0x084fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x0000001044447812ULL, 0x000fe200078efe45ULL, 0x0000000104047836ULL, 0x000fc80000000000ULL,
0x0000000144497824ULL, 0x040fe400078e0249ULL, 0x0000000844147824ULL, 0x040fe400078e00ffULL,
0x0000000144427824ULL, 0x040fe400078e0242ULL, 0x00000008443d7824ULL, 0x000fe200078e00ffULL,
0xfffffff814497812ULL, 0x000fc800078ee249ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee242ULL,
0x0000001049147824ULL, 0x000fc800078e0246ULL, 0x000000103d3d7824ULL, 0x000fe400078e0246ULL,
0x000000001414783bULL, 0x000e680000004200ULL, 0x000000003d3c783bULL, 0x000ee20000004200ULL,
0x00000010ff5c7819ULL, 0x002fe40000011614ULL, 0x00000010ff5d7819ULL, 0x000fe40000011615ULL,
0x000000ff16487812ULL, 0x000fc400078ec0ffULL, 0x0000ffff155a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff587819ULL, 0x100fe40000011616ULL, 0x00000018ff467819ULL, 0x000fe40000011616ULL,
0x00000010ff597819ULL, 0x000fe40000011617ULL, 0x00000010ff557819ULL, 0x008fe4000001163cULL,
0x000000ff14427812ULL, 0x000fc400078ec0ffULL, 0x00000018ff437819ULL, 0x000fe40000011614ULL,
0x0000ffff145b7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff16167812ULL, 0x000fe400078ec0ffULL,
0x000000ff174c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe40000011617ULL,
0x000000ff15147812ULL, 0x000fc400078ec0ffULL, 0x00000018ff447819ULL, 0x000fe40000011615ULL,
0x0000ffff17177812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000008ff5a7819ULL, 0x000fc4000001165aULL, 0x000000ff59597812ULL, 0x000fe200078ec0ffULL,
0x20000048ff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x00000042ff56723eULL, 0x000fe400020006ffULL, 0x000000ff3d607812ULL, 0x000fe400078ec0ffULL,
0x000000ff58587812ULL, 0x000fe200078ec0ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000008ff167819ULL, 0x000fc40000011616ULL, 0x00000014ff57723eULL, 0x000fe400020006ffULL,
0x00000010ff547819ULL, 0x000fe4000001163dULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000043ff527230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000044ff537230ULL, 0x000fe20000004100ULL,
0x00000008ff177819ULL, 0x000fe20000011617ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000018ff5e7819ULL, 0x000fe2000001163cULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fc4000001163dULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000060ff48723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x000000ff54607812ULL, 0x000fe200078ec0ffULL, 0x20000055ff547230ULL, 0x000fe20000004100ULL,
0x0000ffff3c157812ULL, 0x000fe400078ec0ffULL, 0x0000005eff43723eULL, 0x000fe200020006ffULL,
0x2000005aff5e7230ULL, 0x000fe20000004100ULL, 0x0000005fff44723eULL, 0x000fe200020006ffULL,
0x20000059ff5f7230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x20000058ff5a7230ULL, 0x000fe20000004100ULL, 0x00000060ff55723eULL, 0x000fe200020006ffULL,
0x20000016ff597230ULL, 0x000fe20000004100ULL, 0x00000008ff607819ULL, 0x000fe20000011615ULL,
0x20000017ff587230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fe20000011656ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fe20000011657ULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000010ff157819ULL, 0x000fe2000001165cULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff567819ULL, 0x000fe2000001165dULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x0000ffff3d147812ULL, 0x000fc400078ec0ffULL,
0x000000ff3c4f7812ULL, 0x000fe400078ec0ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000105415167816ULL, 0x000fe40000000016ULL, 0x0000105456177816ULL, 0x000fe40000000017ULL,
0x00000008ff567819ULL, 0x000fe40000011614ULL, 0x00000010ff157819ULL, 0x000fc40000011652ULL,
0x00000010ff147819ULL, 0x000fe2000001165bULL, 0x000000163418723cULL, 0x004fe20000041818ULL,
0x0000004fff3d723eULL, 0x000fe200020006ffULL, 0x2000004cff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff4a7819ULL, 0x000fe4000001163eULL, 0x0000105415147816ULL, 0x000fc40000000014ULL,
0x0000105453157816ULL, 0x000fe4000000005eULL, 0x000000ff4a537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff167819ULL, 0x000fe4000001164dULL, 0x00000010ff177819ULL, 0x000fe2000001165aULL,
0x000000143428723cULL, 0x000fe20000041828ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff4a7819ULL, 0x000fc4000001165fULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x0000004bff3c723eULL, 0x000fe400020006ffULL, 0x0000105417167816ULL, 0x000fe20000000016ULL,
0x20000046ff4b7230ULL, 0x000fe20000004100ULL, 0x000010544a177816ULL, 0x000fe2000000004fULL,
0x2000003cff4c7230ULL, 0x000fe20000004100ULL, 0x000000ff3e627812ULL, 0x000fe200078ec0ffULL,
0x2000003dff467230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fc4000001164bULL,
0x00000010ff4c7819ULL, 0x000fe2000001164cULL, 0x00000016342c723cULL, 0x000fe2000004182cULL,
0x00000010ff147819ULL, 0x000fe40000011659ULL, 0x00000010ff157819ULL, 0x000fe40000011658ULL,
0x00000018ff617819ULL, 0x000fe4000001163eULL, 0x00000010ff167819ULL, 0x000fe40000011646ULL,
0x00000010ff177819ULL, 0x000fc40000011654ULL, 0x0000ffff3e457812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000010ff487819ULL, 0x000fe20000011648ULL, 0x20000060ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff557819ULL, 0x000fe20000011655ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000010ff497819ULL, 0x000fc4000001163fULL, 0x000000ff3f3e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe4000001163fULL, 0x0000ffff3f427812ULL, 0x000fe400078ec0ffULL,
0x00000062ff3f723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x000010544b147816ULL, 0x000fe20000000014ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x000010544c157816ULL, 0x000fe20000000015ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000105417167816ULL, 0x000fc40000000016ULL, 0x0000105455177816ULL, 0x000fe40000000048ULL,
0x0000003eff3e723eULL, 0x000fe200020006ffULL, 0x000000143430723cULL, 0x000fe20000041830ULL,
0x000000ff49497812ULL, 0x000fe400078ec0ffULL, 0x00000010ff437819ULL, 0x000fe20000011643ULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x000000163424723cULL, 0x000fe20000041824ULL, 0x00000010ff447819ULL, 0x000fc40000011644ULL,
0x00000010ff147819ULL, 0x000fe20000011652ULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe40000011656ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff167819ULL, 0x000fe40000011653ULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x0000105443147816ULL, 0x000fc40000000014ULL, 0x0000105444157816ULL, 0x000fe40000000015ULL,
0x00000010ff177819ULL, 0x000fe4000001163eULL, 0x00001054163e7816ULL, 0x000fe2000000003fULL,
0x000000040b167836ULL, 0x000fe20000000000ULL, 0x00000042ff46723eULL, 0x000fe200020006ffULL,
0x000000143420723cULL, 0x000fe20000041820ULL, 0x00000010ff427819ULL, 0x000fe40000011649ULL,
0x00000008ff457819ULL, 0x000fe20000011645ULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00001054423f7816ULL, 0x000fe20000000017ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000000a16147c11ULL, 0x000fc4000f8e18ffULL, 0x00000063ff3d723eULL, 0x000fe400020006ffULL,
0x00000061ff3c723eULL, 0x000fe200020006ffULL, 0x0000003e341c723cULL, 0x000fe2000004181cULL,
0x0176a817141479a7ULL, 0x000e62000850003fULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe40000004100ULL, 0x2000003cff3c7230ULL, 0x000fe40000004100ULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fc4000001163dULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff3d7819ULL, 0x000fe40000011646ULL, 0x000010543c3c7816ULL, 0x000fe40000000045ULL,
0x00001054163d7816ULL, 0x000fe4000000003dULL, 0x0000000a07147c11ULL, 0x002fca000f8e18ffULL,
0x0000003c3410723cULL, 0x000fe20000041810ULL, 0x0176a01714ff79a7ULL, 0x0003ec000850003fULL,
0x000000ffff347224ULL, 0x000fe200078e0015ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0xffffff5000e49947ULL, 0x000fde000383ffffULL, 0x000000ff0d00720cULL, 0x000fe20003f05270ULL,
0x000000ffff167224ULL, 0x000fe400078e0025ULL, 0x000000ffff357224ULL, 0x000fe400078e0024ULL,
0x000000ffff257224ULL, 0x000fe400078e001bULL, 0x000000ffff247224ULL, 0x000fe400078e001aULL,
0x000000ffff1b7224ULL, 0x000fc800078e0019ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000050007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000c79000047802ULL, 0x000fce0000000f00ULL,
0x0000008400ec7944ULL, 0x016fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005000037308ULL, 0x002e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000050ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x000f640000000a00ULL,
0x0000000802037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000002405247220ULL, 0x044fe20000410000ULL,
0x0000002505257220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fce0000410000ULL, 0x0000000000027919ULL, 0x002e620000000000ULL,
0x000000202120723eULL, 0x000fe400000010ffULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002e2f2e723eULL, 0x000fc400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x000000121312723eULL, 0x000fe400000010ffULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x00000002ff057819ULL, 0x102fe20000011602ULL,
0x0000000109097824ULL, 0x000fe200078e0202ULL, 0x0000000202007812ULL, 0x000fc400078ec0ffULL,
0x0000000802077811ULL, 0x000fe200078ff0ffULL, 0x00000008050e7824ULL, 0x000fe200078e00ffULL,
0x0000000500037211ULL, 0x040fe400078ff8ffULL, 0x0000000700047211ULL, 0x000fe200078ff8ffULL,
0x00000008070d7824ULL, 0x000fe400078e00ffULL, 0x0000000805077824ULL, 0x040fe400078e00ffULL,
0x0000000203007836ULL, 0x000fe20000000000ULL, 0xfffffff80d147812ULL, 0x000fe200078ee204ULL,
0x0000000805047824ULL, 0x000fc400078e00ffULL, 0x00000008050d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8070a7812ULL, 0x000fe200078ee200ULL, 0x0000000403067836ULL, 0x000fe20000000000ULL,
0x0000000a08007c11ULL, 0x000fe2000f8e60ffULL, 0x0000000603077836ULL, 0x000fe20000000000ULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x0000000802057824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0c7812ULL, 0x000fe200078ee206ULL, 0x000008000b037824ULL, 0x100fe200078e0200ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x0000001009097824ULL, 0x000fe200078e0200ULL,
0x0000000805067812ULL, 0x000fe200078ec0ffULL, 0x0000001004057824ULL, 0x100fe200078e0203ULL,
0x000000282904723eULL, 0x000fe200000010ffULL, 0x0000001014197824ULL, 0x000fc400078e0203ULL,
0x000000100a0d7824ULL, 0x100fe400078e0203ULL, 0x000000100c157824ULL, 0x100fe200078e0203ULL,
0x000054101e0c7816ULL, 0x000fe20000000012ULL, 0x000000100e177824ULL, 0x000fe200078e0203ULL,
0x000000181b03723eULL, 0x000fe200000010ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x000000351605723eULL, 0x000fe200000010ffULL, 0x0000000106197824ULL, 0x040fe200078e0219ULL,
0x00005410031a7816ULL, 0x140fe20000000004ULL, 0x00000001060d7824ULL, 0x040fe200078e020dULL,
0x00007632031b7816ULL, 0x000fe20000000004ULL, 0x0000000106157824ULL, 0x040fe200078e0215ULL,
0x0000002c2d03723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fe200078e0217ULL,
0x000000303104723eULL, 0x000fe200000010ffULL, 0x0000001a07007388ULL, 0x000fe20000000a00ULL,
0x00000010110e723eULL, 0x000fc400000010ffULL, 0x0000541003167816ULL, 0x140fe40000000004ULL,
0x0000763203177816ULL, 0x000fe40000000004ULL, 0x0000541005107816ULL, 0x140fe40000000020ULL,
0x0000763205117816ULL, 0x000fe20000000020ULL, 0x000000160d007388ULL, 0x0003e20000000a00ULL,
0x000000242503723eULL, 0x000fe400000010ffULL, 0x0000002a2b04723eULL, 0x000fe200000010ffULL,
0x0000001015007388ULL, 0x0007e20000000a00ULL, 0x0000763226057816ULL, 0x000fc40000000022ULL,
0x000000323317723eULL, 0x002fe400000010ffULL, 0x000054101c107816ULL, 0x148fe4000000000eULL,
0x000076321c117816ULL, 0x000fe4000000000eULL, 0x000054102e167816ULL, 0x140fe40000000017ULL,
0x000076322e177816ULL, 0x000fe20000000017ULL, 0x0000001006007388ULL, 0x0003e40000000a00ULL,
0x0000541003107816ULL, 0x002fc40000000004ULL, 0x0000763203117816ULL, 0x000fe40000000004ULL,
0x0000541026047816ULL, 0x000fe20000000022ULL, 0x000000ff00037306ULL, 0x000e640000202400ULL,
0x0000001019007388ULL, 0x000fe80000000a00ULL, 0x000400160d007388ULL, 0x0007e80000000a00ULL,
0x0004000415007388ULL, 0x000fe20000000a00ULL, 0x000076321e0d7816ULL, 0x008fca0000000012ULL,
0x0004000c06007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000009107984ULL, 0x000e680000000c00ULL, 0x00040000091c7984ULL, 0x000ee80000000c00ULL,
0x0008000009187984ULL, 0x000f680000000c00ULL, 0x000c000009207984ULL, 0x000f620000000c00ULL,
0x0000001303137230ULL, 0x002fc40000200800ULL, 0x0000001203127230ULL, 0x040fe40000200800ULL,
0x0000001103117230ULL, 0x040fe40000200800ULL, 0x0000001003107230ULL, 0x040fe40000200800ULL,
0x0000001f031f7230ULL, 0x048fe40000200800ULL, 0x0000001e031e7230ULL, 0x040fe40000200800ULL,
0x0000001d031d7230ULL, 0x000fc40000200800ULL, 0x0000001c03037230ULL, 0x000fe40000200800ULL,
0x0000001b13137230ULL, 0x024fe40000200000ULL, 0x0000001a12127230ULL, 0x000fe40000200000ULL,
0x0000001911117230ULL, 0x000fe40000200000ULL, 0x0000001810107230ULL, 0x000fe40000200000ULL,
0x000000231f1f7230ULL, 0x000fc40000200000ULL, 0x000000221e1e7230ULL, 0x000fe20000200000ULL,
0x0000001009007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000200000ULL,
0x00000020031c7230ULL, 0x000fca0000200000ULL, 0x0004001c09007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000003ff057819ULL, 0x000fe20000011602ULL,
0x0000840000057ab9ULL, 0x000fc60000000800ULL, 0x0000003b0500720cULL, 0x000fe20003f06070ULL,
0x00000005040472a4ULL, 0x004fd8000f8e023fULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00008600ff0b7b82ULL, 0x000ea20000000800ULL, 0x0000000105037824ULL, 0x000fe200078e0202ULL,
0x0000880000067ab9ULL, 0x000fe20000000a00ULL, 0xffffffffff067424ULL, 0x000fe400078e00ffULL,
0x0000002002077836ULL, 0x000fe20000000000ULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803037812ULL, 0x000fca00078ef802ULL, 0x0000001003047824ULL, 0x000fe400078e0200ULL,
0x0000001040037824ULL, 0x000fc600078e0205ULL, 0x0000000004107984ULL, 0x0022e20000000c00ULL,
0x0000000b060d7219ULL, 0x084fe200000006ffULL, 0x000000040f067c24ULL, 0x000fe2000f8e02ffULL,
0x0000000b41417219ULL, 0x000fe400000006ffULL, 0x0000000d03057212ULL, 0x000fe400078e30ffULL,
0x0000000bff0a7219ULL, 0x000fe40000011603ULL, 0x0000000702037812ULL, 0x000fe200078ec0ffULL,
0x0000000141057824ULL, 0x000fc800078e0205ULL, 0x0000000f0a057224ULL, 0x000fe400078e0205ULL,
0x0000000808037824ULL, 0x000fc600078e0203ULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000605047c11ULL, 0x002fc8000f8040ffULL,
0x0000000705057c11ULL, 0x000fe400080f440aULL, 0x00000003ff0a7819ULL, 0x000fe20000011607ULL,
0x0000001003047825ULL, 0x000fc600078e0004ULL, 0x0000003b0a00720cULL, 0x000fe40003f06070ULL,
0x0000001004007986ULL, 0x0083f6000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107037824ULL, 0x100fe400078e020aULL, 0x00000010400a7824ULL, 0x000fe400078e020aULL,
0x0000004002097836ULL, 0x000fe20000000000ULL, 0x0000000703047812ULL, 0x002fc800078ec0ffULL,
0x0ffffff804037812ULL, 0x000fe400078ef807ULL, 0x0000000d0a047212ULL, 0x000fe400078e30ffULL,
0x0000000bff0a7219ULL, 0x000fe2000001160aULL, 0x0000001003037824ULL, 0x000fe200078e0200ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000000141047824ULL, 0x000fc600078e0204ULL,
0x0000000003107984ULL, 0x000e620000000c00ULL, 0x0000000f0a057224ULL, 0x000fe400078e0204ULL,
0x0000000808077824ULL, 0x000fc600078e0207ULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000605047c11ULL, 0x000fc8000f8040ffULL,
0x0000000705057c11ULL, 0x000fe400080f440aULL, 0x00000003ff0a7819ULL, 0x000fe20000011609ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x0000003b0a00720cULL, 0x000fe40003f06070ULL,
0x0000001004007986ULL, 0x0023f6000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000109037824ULL, 0x100fe400078e020aULL, 0x00000010400a7824ULL, 0x000fe400078e020aULL,
0x0000006002057836ULL, 0x002fe20000000000ULL, 0x0000000703047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804037812ULL, 0x000fe400078ef809ULL, 0x0000000709097812ULL, 0x000fc600078ec0ffULL,
0x0000001003047824ULL, 0x000fe200078e0200ULL, 0x0000000d0a037212ULL, 0x000fe200078e30ffULL,
0x0000000808097824ULL, 0x000fe200078e0209ULL, 0x0000000bff0a7219ULL, 0x000fe4000001160aULL,
0x0000000004107984ULL, 0x0002a20000000c00ULL, 0x0000000141037824ULL, 0x000fc800078e0203ULL,
0x0000000f0a037224ULL, 0x000fe200078e0203ULL, 0x00000003ff047819ULL, 0x002fc80000011605ULL,
0x0000000306037210ULL, 0x000fe20007f1e0ffULL, 0x0000000105077824ULL, 0x000fc800078e0204ULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000603027c11ULL, 0x000fc8000f8040ffULL,
0x0000000703037c11ULL, 0x000fe400080f440aULL, 0x0000003b0400720cULL, 0x000fe40003f06070ULL,
0x00000007070a7812ULL, 0x000fe200078ec0ffULL, 0x0000001009027825ULL, 0x000fc600078e0002ULL,
0xfffffff80a077812ULL, 0x000fe400078ef805ULL, 0x0000001002007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x0000001040047824ULL, 0x000fc600078e0204ULL,
0x0000000007107984ULL, 0x002e620000000c00ULL, 0x0000000808057824ULL, 0x000fe200078e0205ULL,
0x0000000d04007212ULL, 0x000fe400078e30ffULL, 0x0000000bff047219ULL, 0x000fc60000011604ULL,
0x0000000141007824ULL, 0x000fc800078e0200ULL, 0x0000000f040f7224ULL, 0x000fca00078e0200ULL,
0x0000000f060f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x000000060f027c11ULL, 0x000fc8000f8040ffULL, 0x000000070f037c11ULL, 0x000fc600080f4400ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000001002007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe2000001163aULL,
0x00009800ff127b82ULL, 0x000e620000000a00ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000390a00720cULL, 0x000fe20003f06070ULL, 0xffffffffff097424ULL, 0x000fc800078e00ffULL,
0x00008e00ff167b82ULL, 0x000eb00000000a00ULL, 0x00009400ff028b82ULL, 0x000ee20000000800ULL,
0x0000000215078824ULL, 0x000fce00078e00ffULL, 0x00009000ff108b82ULL, 0x000f620000000a00ULL,
0x0000000812087981ULL, 0x002322000c1e9900ULL, 0x0000000207078224ULL, 0x008fc800078e020aULL,
0x0000000407108825ULL, 0x020fe400078e0010ULL, 0x01760006ff0679a7ULL, 0x000e66000850000aULL,
0x0000000810098981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0400780cULL, 0x000fe20003f04070ULL,
0x0000008005027824ULL, 0x000fe400078e00ffULL, 0x0000008041417824ULL, 0x000fe400078e00ffULL,
0x0000000902057224ULL, 0x008fc400078e02ffULL, 0x000000403a097824ULL, 0x000fe400078e00ffULL,
0x0000008005047825ULL, 0x004fc600078e0016ULL, 0x00000040410b7812ULL, 0x000fe200078ef809ULL,
0x0000000c00200947ULL, 0x002fec0003800000ULL, 0x00000003ff257819ULL, 0x000fe4000001160eULL,
0x00000009380c7248ULL, 0x000fc60007fe0000ULL, 0x00000008251b7836ULL, 0x000fe40000000000ULL,
0x0000000425137836ULL, 0x000fe40000000000ULL, 0x000000011b117824ULL, 0x040fe400078e020eULL,
0x000000081b247824ULL, 0x000fe400078e00ffULL, 0x000000010b107824ULL, 0x040fe400078e0225ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a09ULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x000000010b127824ULL, 0x000fc400078e0213ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000c1300720cULL, 0x000fc60003fa6070ULL, 0x00000001130f7824ULL, 0x040fe200078e020eULL,
0x0000007010217812ULL, 0x000fe200078ef803ULL, 0x0000000813147824ULL, 0x000fe400078e00ffULL,
0x0000001025177836ULL, 0x000fe20000000000ULL, 0x0000002104207210ULL, 0x000fe20007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fc600078ee20fULL,
0x0000000117107824ULL, 0x040fe200078e020eULL, 0x0000007012197812ULL, 0x000fe200078ef803ULL,
0x00000008171f7824ULL, 0x000fe400078e00ffULL, 0x0000000c251d7836ULL, 0x000fe20000000000ULL,
0x0000001904187210ULL, 0x000fe20007f3e0ffULL, 0x0000000105217824ULL, 0x000fe200000e0611ULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee210ULL, 0x000000010b107824ULL, 0x000fe200078e021bULL,
0x0000000c1700720cULL, 0x080fe20003f06070ULL, 0x000000010b127824ULL, 0x000fe200078e021dULL,
0x0000000c1d00720cULL, 0x000fe20003f46070ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000105197824ULL, 0x000fe200008e0613ULL, 0x00000070101f7812ULL, 0x000fe200078ef803ULL,
0x000000010b177824ULL, 0x000fe200078e0217ULL, 0x0000000c1b00720cULL, 0x000fe20003f26070ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001f041e7210ULL, 0x000fc60007f7e0ffULL,
0x0000001425277836ULL, 0x000fe40000000000ULL, 0x000000011d0f7824ULL, 0x040fe400078e020eULL,
0x000000081d287824ULL, 0x000fe200078e00ffULL, 0x00000070121d7812ULL, 0x000fe200078ef803ULL,
0x0000008017167825ULL, 0x000fc600078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20fULL,
0x000000010b1a7824ULL, 0x000fe200078e0227ULL, 0x00000070160f7812ULL, 0x000fe200078ef803ULL,
0x00000018252b7836ULL, 0x000fe20000000000ULL, 0x0000001d041c7210ULL, 0x000fe20007f9e0ffULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x000000010b227824ULL, 0x000fe400078e022bULL,
0x00000001051f7824ULL, 0x040fe200018e0611ULL, 0x0000000f04167210ULL, 0x000fe20007f7e0ffULL,
0x00000001051d7824ULL, 0x000fe200020e0613ULL, 0x000000701a137812ULL, 0x000fe200078ef803ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000a3a0f7c11ULL, 0x000fc6000f8e70ffULL,
0x0000001c252f7836ULL, 0x000fe20000000000ULL, 0x0000007022117812ULL, 0x000fe200078ef803ULL,
0x0000000105177824ULL, 0x000fe200018e0617ULL, 0x0000001304127210ULL, 0x000fe20007f7e0ffULL,
0x000000010b1a7824ULL, 0x000fe200078e022fULL, 0x0000001104107210ULL, 0x000fe20007f9e0ffULL,
0x0000000125227824ULL, 0x000fe400078e020eULL, 0x0000000105137824ULL, 0x000fe200018e061bULL,
0x0000000c2700720cULL, 0x000fe20003f66070ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000722297812ULL, 0x000fc600078ec0ffULL, 0x0000000105117824ULL, 0x000fe200020e0623ULL,
0x000000701a237812ULL, 0x000fe200078ef803ULL, 0x0000002025317836ULL, 0x000fe20000000000ULL,
0x0000000c2500720cULL, 0x000fe20003f86070ULL, 0x0000000127227824ULL, 0x040fe200078e020eULL,
0x00000023041a7210ULL, 0x000fe20007fde0ffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0ffffff829267812ULL, 0x000fe200078ef80eULL, 0x000000010b237824ULL, 0x000fe400078e0231ULL,
0x000010000f0f7836ULL, 0x000fe20000000000ULL, 0xfffffff8272c7812ULL, 0x000fe200078ee222ULL,
0x0000008023227825ULL, 0x000fc800078e00ffULL, 0x0000002425337836ULL, 0x000fe20000000000ULL,
0x0000007022277812ULL, 0x000fe200078ef803ULL, 0x0000001026297824ULL, 0x000fe400078e020fULL,
0x0000002825357836ULL, 0x000fe40000000000ULL, 0x000000010b267824ULL, 0x000fe200078e0233ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020297faeULL, 0x0003e2000e101c48ULL,
0x00000001051b7824ULL, 0x000fe200030e061bULL, 0x0000000c2b00720cULL, 0x040fe20003f86070ULL,
0x000000012b2d7824ULL, 0x040fe200078e020eULL, 0x0000002704227210ULL, 0x000fe20007fde0ffULL,
0x000000082b2e7824ULL, 0x000fc400078e00ffULL, 0x000000010b2b7824ULL, 0x000fe400078e0235ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fc600078ee22dULL,
0x000000802b207825ULL, 0x002fe200078e00ffULL, 0x00000070262b7812ULL, 0x000fc600078ef803ULL,
0x0000000105237824ULL, 0x000fe200030e0623ULL, 0x0000002b04267210ULL, 0x000fe20007fde0ffULL,
0x0000001014297824ULL, 0x000fe200078e020fULL, 0x00000070202b7812ULL, 0x000fe200078ef803ULL,
0x000000012f147824ULL, 0x000fe400078e020eULL, 0x0000000105277824ULL, 0x000fe200030e0627ULL,
0x0000002b04207210ULL, 0x000fe20007fde0ffULL, 0x00000010242b7824ULL, 0x000fe200078e020fULL,
0x0000000018297faeULL, 0x0003e2000e901c48ULL, 0x0000000c2f00720cULL, 0x040fe20003fa6070ULL,
0x000000082f2f7824ULL, 0x000fc400078e00ffULL, 0x000000001e2b7faeULL, 0x0005e2000c901c48ULL,
0x0000000c3100720cULL, 0x0c0fe20003f26070ULL, 0x0000000131247824ULL, 0x040fe200078e020eULL,
0xfffffff82f147812ULL, 0x000fe200078ee214ULL, 0x0000002c25377836ULL, 0x000fe40000000000ULL,
0x0000000831317824ULL, 0x000fe400078e00ffULL, 0x0000001028297824ULL, 0x002fe400078e020fULL,
0x000000010b187824ULL, 0x000fe200078e0237ULL, 0xfffffff831247812ULL, 0x000fe200078ee224ULL,
0x000000102a1f7824ULL, 0x104fe200078e020fULL, 0x000000001c297faeULL, 0x0003e2000d101c48ULL,
0x0000003025317836ULL, 0x000fe20000000000ULL, 0x0000000c3300720cULL, 0x000fe20003f46070ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000000161f7faeULL, 0x0005e6000c101c48ULL,
0x00000010142b7824ULL, 0x000fe200078e020fULL, 0x00000070182d7812ULL, 0x000fe200078ef803ULL,
0x000000010b147824ULL, 0x000fc400078e0231ULL, 0x0000000105217824ULL, 0x000fe200030e0621ULL,
0x0000002d04187210ULL, 0x000fe20007fde0ffULL, 0x000000102c1d7824ULL, 0x102fe400078e020fULL,
0x000000102e297824ULL, 0x000fe400078e020fULL, 0x00000034251f7836ULL, 0x004fe20000000000ULL,
0x00000000121d7faeULL, 0x0003e2000d901c48ULL, 0x0000000133287824ULL, 0x000fe200078e020eULL,
0x0000000c3100720cULL, 0x080fe20003f66070ULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000000010297faeULL, 0x0005e2000e101c48ULL, 0x0000000105197824ULL, 0x000fe200030e0619ULL,
0x0000000c3700720cULL, 0x080fe20003f86070ULL, 0x00000010242d7824ULL, 0x000fe200078e020fULL,
0xfffffff833287812ULL, 0x000fe200078ee228ULL, 0x0000003825337836ULL, 0x000fe20000000000ULL,
0x000000001a2b7faeULL, 0x0007e2000e901c48ULL, 0x0000003c25257836ULL, 0x000fe20000000000ULL,
0x0000000c3500720cULL, 0x080fe20003fa6070ULL, 0x000000010b127824ULL, 0x002fe200078e021fULL,
0x00000000222d7faeULL, 0x0003e2000c901c48ULL, 0x00000010282f7824ULL, 0x000fe200078e020fULL,
0x0000000c3300720cULL, 0x080fe20003f26070ULL, 0x0000008014107825ULL, 0x004fe200078e00ffULL,
0x0000000c2500720cULL, 0x000fc40003f06070ULL, 0x00000000262f7faeULL, 0x0005e2000d101c48ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007010177812ULL, 0x000fe400078ef803ULL,
0x0000000c1f00720cULL, 0x000fe20003f46070ULL, 0x0000000131107824ULL, 0x140fe200078e020eULL,
0x0000001704167210ULL, 0x000fe20007fde0ffULL, 0x0000000831317824ULL, 0x000fe200078e00ffULL,
0x00000070121b7812ULL, 0x008fe200078ef803ULL, 0x000000010b127824ULL, 0x000fe400078e0225ULL,
0x0000000105177824ULL, 0x000fe200030e0611ULL, 0xfffffff8311c7812ULL, 0x000fe200078ee210ULL,
0x000000010b117824ULL, 0x000fe200078e0233ULL, 0x0000001b041a7210ULL, 0x000fe20007fde0ffULL,
0x000000011f1d7824ULL, 0x000fc400078e020eULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x000000081f1e7824ULL, 0x000fe200078e00ffULL, 0x0000007010237812ULL, 0x002fe200078ef803ULL,
0x0000000135147824ULL, 0x100fe400078e020eULL, 0x00000001330b7824ULL, 0x140fe400078e020eULL,
0x0000000833227824ULL, 0x000fe400078e00ffULL, 0x0000000835357824ULL, 0x000fe400078e00ffULL,
0x00000001370c7824ULL, 0x000fc400078e020eULL, 0x00000001051b7824ULL, 0x000fe200030e0613ULL,
0x0000002304107210ULL, 0x000fe20007fde0ffULL, 0x00000001251f7824ULL, 0x040fe200078e020eULL,
0xfffffff81e0e7812ULL, 0x000fe200078ee21dULL, 0x0000000825247824ULL, 0x000fe200078e00ffULL,
0xfffffff8221e7812ULL, 0x000fe200078ee20bULL, 0x0000000837377824ULL, 0x000fe200078e00ffULL,
0xfffffff835147812ULL, 0x000fe200078ee214ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff824227812ULL, 0x000fe400078ee21fULL, 0xfffffff8370c7812ULL, 0x000fe200078ee20cULL,
0x0000000105117824ULL, 0x000fe200030e0611ULL, 0x00000070121f7812ULL, 0x000fe200078ef803ULL,
0x0000001014037824ULL, 0x000fc400078e020fULL, 0x000000100c0b7824ULL, 0x100fe200078e020fULL,
0x0000001f04047210ULL, 0x000fe20007fde0ffULL, 0x000000101c1d7824ULL, 0x100fe200078e020fULL,
0x0000000020037faeULL, 0x0005e2000e901c48ULL, 0x000000100e1f7824ULL, 0x100fe400078e020fULL,
0x000000101e237824ULL, 0x100fe200078e020fULL, 0x00000000180b7faeULL, 0x0005e2000e101c48ULL,
0x00000010220f7824ULL, 0x000fe400078e020fULL, 0x0000000105057824ULL, 0x000fe200030e0613ULL,
0x00000000161d7faeULL, 0x0005e8000d901c48ULL, 0x000000001a1f7faeULL, 0x0005e8000d101c48ULL,
0x0000000010237faeULL, 0x0005e8000c901c48ULL, 0x00000000040f7faeULL, 0x0005e2000c101c48ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x000000040e107811ULL, 0x040fe400078fe8ffULL,
0x0000000c0e137811ULL, 0x040fe400078fe8ffULL, 0x000000080e127811ULL, 0x000fe200078fe8ffULL,
0x00000001100c7824ULL, 0x100fe200078e020eULL, 0x000000100e147811ULL, 0x000fe200078fe8ffULL,
0x00000008101f7824ULL, 0x000fe200078e00ffULL, 0x000000140e177811ULL, 0x040fe200078fe8ffULL,
0x0000000113117824ULL, 0x140fe200078e020eULL, 0x0000001c0e1b7811ULL, 0x000fe200078fe8ffULL,
0x00000008131a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL,
0x00000001120f7824ULL, 0x100fe200078e020eULL, 0x000000180e197811ULL, 0x000fe200078fe8ffULL,
0x0000000812187824ULL, 0x000fe200078e00ffULL, 0x000000200e1d7811ULL, 0x000fe200078fe8ffULL,
0x0000000114167824ULL, 0x100fe200078e020eULL, 0x000000240e1e7811ULL, 0x000fe200078fe8ffULL,
0x0000000814277824ULL, 0x000fe200078e00ffULL, 0xfffffff81a257812ULL, 0x000fe200078ee211ULL,
0x00000001170c7824ULL, 0x140fe200078e020eULL, 0xfffffff818217812ULL, 0x000fe200078ee20fULL,
0x00000008172b7824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee216ULL,
0x000000011b117824ULL, 0x140fe200078e020eULL, 0x0000002c0e237811ULL, 0x040fe200078fe8ffULL,
0x000000081b1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL,
0x00000001190f7824ULL, 0x140fe200078e020eULL, 0x000000280e207811ULL, 0x040fe200078fe8ffULL,
0x0000000819187824ULL, 0x000fe200078e00ffULL, 0x000000300e297811ULL, 0x000fe200078fe8ffULL,
0x000000011d167824ULL, 0x140fe200078e020eULL, 0xfffffff81a2f7812ULL, 0x000fe200078ee211ULL,
0x000000081d317824ULL, 0x000fe200078e00ffULL, 0xfffffff8182d7812ULL, 0x000fe200078ee20fULL,
0x000000011e0c7824ULL, 0x100fe200078e020eULL, 0x000000340e2e7811ULL, 0x000fe200078fe8ffULL,
0x000000081e337824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee216ULL,
0x0000000123117824ULL, 0x140fe200078e020eULL, 0x000000380e307811ULL, 0x000fe200078fe8ffULL,
0x00000008232a7824ULL, 0x000fe200078e00ffULL, 0xfffffff833247812ULL, 0x000fe200078ee20cULL,
0x00000001200f7824ULL, 0x100fe200078e020eULL, 0x0000000e0e0c7211ULL, 0x000fe200078fe8ffULL,
0x0000000820267824ULL, 0x000fe200078e00ffULL, 0x0000003c0e337811ULL, 0x000fe200078fe8ffULL,
0x0000000129167824ULL, 0x040fe200078e020eULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL,
0x0000000829357824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20fULL,
0x000000010b187824ULL, 0x040fe200078e0214ULL, 0x000000070c117812ULL, 0x000fe200078ec0ffULL,
0x000000010b327824ULL, 0x040fe200078e021eULL, 0xfffffff8352c7812ULL, 0x000fe200078ee216ULL,
0x000000010b167824ULL, 0x040fe200078e0213ULL, 0x0000000b0e0f7211ULL, 0x000fe200078fe8ffULL,
0x000000010b347824ULL, 0x000fc400078e0220ULL, 0x000000010b107824ULL, 0x040fe400078e0210ULL,
0x000000010b127824ULL, 0x040fe400078e0212ULL, 0x000000010b1a7824ULL, 0x040fe400078e0217ULL,
0x000000010b1c7824ULL, 0x040fe400078e0219ULL, 0x000000010b227824ULL, 0x040fe400078e021bULL,
0x000000010b287824ULL, 0x000fc400078e021dULL, 0x000000010b367824ULL, 0x040fe400078e0223ULL,
0x000000010b207824ULL, 0x040fe400078e0229ULL, 0x000000010b1e7824ULL, 0x040fe400078e022eULL,
0x000000012e137824ULL, 0x040fe400078e020eULL, 0x000000010b147824ULL, 0x040fe400078e0230ULL,
0x000000010b0c7824ULL, 0x000fe200078e0233ULL, 0x0ffffff8110b7812ULL, 0x000fe200078ef80eULL,
0x000000082e2e7824ULL, 0x000fc400078e00ffULL, 0x0000000130177824ULL, 0x100fe400078e020eULL,
0x0000000133117824ULL, 0x040fe200078e020eULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee213ULL,
0x00000008333c7824ULL, 0x000fe200078e00ffULL, 0x0000000a3a137c11ULL, 0x000fe2000f8e70ffULL,
0x000000800f0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff83c197812ULL, 0x000fe200078ee211ULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x000000700e1b7812ULL, 0x000fe200078ef803ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000001b040e7210ULL, 0x000fe20007f1e0ffULL,
0x00001000133c7836ULL, 0x000fe20000000000ULL, 0xfffffff830177812ULL, 0x000fe200078ee217ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000070101b7812ULL, 0x000fc600078ef803ULL,
0x0000001017307824ULL, 0x000fe200078e023cULL, 0x0000001b04107210ULL, 0x000fe20007f3e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000070121b7812ULL, 0x000fc600078ef803ULL,
0x00000001050f7824ULL, 0x000fe200000e060fULL, 0x0000001b04127210ULL, 0x000fe20007f1e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000007016237812ULL, 0x000fc600078ef803ULL,
0x0000000105137824ULL, 0x000fe200000e0613ULL, 0x0000002304167210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x000000701c237812ULL, 0x000fc600078ef803ULL,
0x00000010193b7824ULL, 0x000fe200078e023cULL, 0x000000701a297812ULL, 0x000fe200078ef803ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000023041c7210ULL, 0x000fc60007f5e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000007018337812ULL, 0x000fc600078ef803ULL,
0x0000000105177824ULL, 0x040fe200000e0617ULL, 0x00000029041a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000105117824ULL, 0x000fe200008e0611ULL, 0x0000003304187210ULL, 0x000fe20007f3e0ffULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x00000070223f7812ULL, 0x000fc600078ef803ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000007032437812ULL, 0x000fc600078ef803ULL,
0x00000001051b7824ULL, 0x000fe200000e061bULL, 0x0000003f04227210ULL, 0x000fe20007f1e0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000007034457812ULL, 0x000fc600078ef803ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000070283d7812ULL, 0x000fc600078ef803ULL,
0x0000000105237824ULL, 0x040fe200000e0623ULL, 0x0000004304427210ULL, 0x000fe20007f1e0ffULL,
0x00000001051d7824ULL, 0x040fe200010e061dULL, 0x0000004504447210ULL, 0x000fe20007f5e0ffULL,
0x0000000105197824ULL, 0x040fe200008e0619ULL, 0x0000003d04287210ULL, 0x000fe20007f3e0ffULL,
0x0000000105437824ULL, 0x040fe200000e0633ULL, 0x00000070363d7812ULL, 0x000fe200078ef803ULL,
0x0000000105457824ULL, 0x000fe400010e0635ULL, 0x0000008020327825ULL, 0x000fe200078e00ffULL,
0x0000003d04367210ULL, 0x000fc60007f1e0ffULL, 0x000000100b0b7824ULL, 0x100fe200078e023cULL,
0x00000070324b7812ULL, 0x000fe200078ef803ULL, 0x000000101f1f7824ULL, 0x100fe400078e023cULL,
0x0000001021217824ULL, 0x100fe200078e023cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e2000b901c48ULL, 0x0000001025257824ULL, 0x100fe400078e023cULL,
0x0000001027277824ULL, 0x100fe200078e023cULL, 0x00000000101f7faeULL, 0x0003e2000b901c48ULL,
0x000000102b2b7824ULL, 0x000fc400078e023cULL, 0x000000102d2d7824ULL, 0x100fe200078e023cULL,
0x0000000012217faeULL, 0x0003e2000b901c48ULL, 0x000000102f2f7824ULL, 0x100fe400078e023cULL,
0x0000001031317824ULL, 0x100fe200078e023cULL, 0x0000000016257faeULL, 0x0003e2000b901c48ULL,
0x0000001024247824ULL, 0x100fe400078e023cULL, 0x0000001026267824ULL, 0x100fe200078e023cULL,
0x0000000018277faeULL, 0x0003e2000b901c48ULL, 0x000000102a2a7824ULL, 0x000fc400078e023cULL,
0x000000102c2c7824ULL, 0x100fe200078e023cULL, 0x000000001a2b7faeULL, 0x0003e2000b901c48ULL,
0x000000102e2e7824ULL, 0x000fe400078e023cULL, 0x000000801e347825ULL, 0x000fe200078e00ffULL,
0x000000001c2d7faeULL, 0x0003e6000b901c48ULL, 0x00000080143c7825ULL, 0x000fe200078e00ffULL,
0x0000007034497812ULL, 0x000fe200078ef803ULL, 0x00000000222f7faeULL, 0x0003e4000b901c48ULL,
0x000000800c3e7825ULL, 0x000fe200078e00ffULL, 0x000000703c477812ULL, 0x000fc600078ef803ULL,
0x0000000105377824ULL, 0x040fe200000e0637ULL, 0x000000703e037812ULL, 0x000fe200078ef803ULL,
0x0000000105297824ULL, 0x040fe200008e0629ULL, 0x0000004b04327210ULL, 0x000fe40007f1e0ffULL,
0x0000004904347210ULL, 0x000fe40007f3e0ffULL, 0x00000047043c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000105337824ULL, 0x040fe200000e0633ULL, 0x0000000304047210ULL, 0x000fe20007f7e0ffULL,
0x0000000105357824ULL, 0x040fe200008e0635ULL, 0x0000000028317faeULL, 0x0003e2000b901c48ULL,
0x00000001053d7824ULL, 0x000fc400010e063dULL, 0x0000000105057824ULL, 0x000fe200018e063fULL,
0x0000000042247faeULL, 0x0003e8000b901c48ULL, 0x0000000044267faeULL, 0x0003e8000b901c48ULL,
0x00000000362a7faeULL, 0x0003e8000b901c48ULL, 0x00000000322c7faeULL, 0x0003e8000b901c48ULL,
0x00000000342e7faeULL, 0x0003e8000b901c48ULL, 0x000000003c307faeULL, 0x0003e8000b901c48ULL,
0x00000000043b7faeULL, 0x0003e4000b901c48ULL, 0x000000020a047836ULL, 0x006fe20000000000ULL,
0x00000000000079afULL, 0x000e280000000000ULL, 0x000000390400720cULL, 0x000fda0003f06070ULL,
0x00009400ff038b82ULL, 0x000e620000000800ULL, 0x0000000215058824ULL, 0x000fce00078e00ffULL,
0x00009000ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000305058224ULL, 0x002fe400078e0204ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x00000004050a8825ULL, 0x004fca00078e000aULL,
0x000000080a038981ULL, 0x000324000c1e1900ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01760007ff0075a7ULL, 0x000e64000800014aULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff107224ULL, 0x000fce00078e00ffULL, 0x000000101000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fce0000015200ULL,
0x0000000e0a0c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e0bULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140eULL, 0x0000000c05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e060eULL, 0x0000000205057819ULL, 0x000fc8000000120cULL,
0x000000050000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000110107836ULL, 0x000fce0000000000ULL, 0x01760007ff0075a7ULL, 0x000e64000800014aULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000203a057824ULL, 0x002fca00078e0205ULL,
0x00000003ff067819ULL, 0x000fc80000011605ULL, 0x1ffffffe060a7812ULL, 0x000fe400078ec0ffULL,
0x0000000f05067812ULL, 0x000fc600078ec0ffULL, 0x00000001050a7824ULL, 0x000fe400078e020aULL,
0x0000001006077824ULL, 0x000fe400078e00ffULL, 0x000000010a057836ULL, 0x000fe20000000000ULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x000fc600078e00ffULL,
0x0000000f05057812ULL, 0x000fe400078ec0ffULL, 0x000000f0070a7812ULL, 0x000fe400078ee20aULL,
0x000000f006057812ULL, 0x000fe400078ee205ULL, 0x0000000a0a0a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a05057c11ULL, 0x000fc6000f8e20ffULL, 0x000000000a187984ULL, 0x000e680000000c00ULL,
0x0000000005107984ULL, 0x000ea20000000c00ULL, 0x000000ffff1c7224ULL, 0x002fe400078e0018ULL,
0x000000ffff187224ULL, 0x000fe400078e0019ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000ffff197224ULL, 0x000fc400078e001bULL, 0x000000ffff1e7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0013ULL, 0x0000001c0a007388ULL, 0x0003e80000000c00ULL,
0x0000001805007388ULL, 0x0003e20000000c00ULL, 0x0176000eff0e79a7ULL, 0x000ea4000850000aULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x0176000fff0075a7ULL, 0x004ea4000800014aULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e07ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140bULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x0176000fff0075a7ULL, 0x000ea4000800014aULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009400ff067b82ULL, 0x000ea20000000800ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000840000077ab9ULL, 0x000fe20000000800ULL, 0x3db504f308087820ULL, 0x010fe20000410000ULL,
0x0000001f07047890ULL, 0x000fe4000fffe03fULL, 0x80000007380c7c36ULL, 0x000fe20008000000ULL,
0x0000000a3a0a7c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x000000043f047899ULL, 0x000fe20008011604ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x00000008ff0c7819ULL, 0x000fe2000001160cULL, 0xffffffff07057890ULL, 0x000fc4000fffe03fULL,
0x0000000907067890ULL, 0x000fe4000fffe03fULL, 0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL,
0x0000000615077224ULL, 0x004fe400078e02ffULL, 0x0000010009067836ULL, 0x000fe20000000000ULL,
0x0000000a3a097c11ULL, 0x000fd0000f8e18ffULL, 0x00008e00ff107b82ULL, 0x002ea20000000a00ULL,
0x000000020b0e7836ULL, 0x000fe40000000000ULL, 0x000001000b0f7824ULL, 0x000fe400078e0206ULL,
0x0000000302037224ULL, 0x010fe200078e02ffULL, 0x0000000d0e00720cULL, 0x000fe40003f06070ULL,
0x000000400f127812ULL, 0x000fe400078ec0ffULL, 0x00000001180e7812ULL, 0x000fc600078e0cffULL,
0x0000000141127824ULL, 0x000fe400078e0212ULL, 0x0000008003107825ULL, 0x004fc800078e0010ULL,
0x0000000c002c8947ULL, 0x000fea0003800000ULL, 0x00000003ff267819ULL, 0x002fe40000011605ULL,
0x0000000f38147248ULL, 0x000fc60007fe0000ULL, 0x0000000426167836ULL, 0x000fe40000000000ULL,
0x0000000114137824ULL, 0x000fe400078e0a0fULL, 0x0000000116037824ULL, 0x040fe400078e0205ULL,
0x0000000816307824ULL, 0x040fe200078e00ffULL, 0x000000131600720cULL, 0x040fe20003fa6070ULL,
0x00000008261a7836ULL, 0x000fe40000000000ULL, 0x0000000116167824ULL, 0x000fe200078e0212ULL,
0xfffffff830307812ULL, 0x000fe200078ee203ULL, 0x0000001005037824ULL, 0x000fc400078e00ffULL,
0x000000011a2e7824ULL, 0x040fe400078e0205ULL, 0x000000081a157824ULL, 0x000fe200078e00ffULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff8152e7812ULL, 0x000fe200078ee22eULL, 0x0000000126147824ULL, 0x000fe200078e0212ULL,
0x0000000316197212ULL, 0x000fe200078efcffULL, 0x0000000c261c7836ULL, 0x000fe40000000000ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000001910167210ULL, 0x000fe40007f3e0ffULL,
0x000000131c00720cULL, 0x000fe20003f46070ULL, 0x00000010261e7836ULL, 0x000fe20000000000ULL,
0x00000003141b7212ULL, 0x000fe200078efcffULL, 0x0000000111177824ULL, 0x000fe200008e0617ULL,
0x000000131a00720cULL, 0x000fe20003f26070ULL, 0x000000011c1d7824ULL, 0x040fe200078e0205ULL,
0x0000001b10147210ULL, 0x000fe20007f1e0ffULL, 0x000000081c327824ULL, 0x000fc400078e00ffULL,
0x000000011a1a7824ULL, 0x100fe400078e0212ULL, 0x000000011c1c7824ULL, 0x000fe200078e0212ULL,
0xfffffff832327812ULL, 0x000fe200078ee21dULL, 0x000000011e2c7824ULL, 0x040fe400078e0205ULL,
0x000000081e1f7824ULL, 0x040fe400078e00ffULL, 0x0000000111157824ULL, 0x000fe200000e0615ULL,
0x000000131e00720cULL, 0x000fe20003f06070ULL, 0x00000014262a7836ULL, 0x000fe20000000000ULL,
0xfffffff81f2c7812ULL, 0x000fe200078ee22cULL, 0x000000801a1a7825ULL, 0x000fc800078e00ffULL,
0x000000011e1e7824ULL, 0x000fe200078e0212ULL, 0x000000031a217212ULL, 0x000fe200078efcffULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0x0000002110207210ULL, 0x000fe20007f7e0ffULL,
0x0000001826367836ULL, 0x000fe20000000000ULL, 0x000000031c197212ULL, 0x000fe200078efcffULL,
0x000000012a247824ULL, 0x000fe400078e0212ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000001910227210ULL, 0x000fc60007f9e0ffULL, 0x0000000136287824ULL, 0x000fe200078e0212ULL,
0x000000031e237212ULL, 0x000fe200078efcffULL, 0x0000008024247825ULL, 0x000fc800078e00ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000000324197212ULL, 0x000fc600078efcffULL,
0x0000000111217824ULL, 0x040fe200018e061bULL, 0x00000023101e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001c263c7836ULL, 0x000fe20000000000ULL, 0x00000003281b7212ULL, 0x000fe200078efcffULL,
0x0000000111237824ULL, 0x040fe200020e061dULL, 0x00000019101c7210ULL, 0x000fe20007f9e0ffULL,
0x000000013c247824ULL, 0x000fe200078e0212ULL, 0x0000000a3a197c11ULL, 0x000fe2000f8e70ffULL,
0x0000000126287824ULL, 0x000fe400078e0205ULL, 0x00000001111f7824ULL, 0x040fe200018e061fULL,
0x0000001b101a7210ULL, 0x000fe20007f7e0ffULL, 0x00000001111d7824ULL, 0x000fe200020e0625ULL,
0x0000000728287812ULL, 0x000fe200078ec0ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x000000132600720cULL, 0x000fc60003f86070ULL, 0x00000020263e7836ULL, 0x000fe40000000000ULL,
0x00000001111b7824ULL, 0x000fe200018e0629ULL, 0x000000132a00720cULL, 0x040fe20003f66070ULL,
0x000000012a2b7824ULL, 0x000fe200078e0205ULL, 0x0000000324297212ULL, 0x000fe200078efcffULL,
0x000000082a347824ULL, 0x000fe200078e00ffULL, 0x0ffffff8282a7812ULL, 0x000fe200078ef805ULL,
0x000000013e287824ULL, 0x000fe200078e0212ULL, 0x0000002910247210ULL, 0x000fe20007fde0ffULL,
0x000020000e277824ULL, 0x000fe200078e0219ULL, 0xfffffff834347812ULL, 0x000fe200078ee22bULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x0000100027277836ULL, 0x000fe20000000000ULL,
0x00000003282b7212ULL, 0x000fe200078efcffULL, 0x0000002426407836ULL, 0x000fe40000000000ULL,
0x000000102a2d7824ULL, 0x000fe400078e0227ULL, 0x0000002826427836ULL, 0x000fe40000000000ULL,
0x00000001402a7824ULL, 0x100fe200078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142d7faeULL, 0x0003e2000e101c48ULL, 0x0000000111257824ULL, 0x000fe200030e0625ULL,
0x0000002b10287210ULL, 0x000fe20007fde0ffULL, 0x00000001422f7824ULL, 0x000fe200078e0212ULL,
0x000000133600720cULL, 0x000fe20003f86070ULL, 0x000000802a2a7825ULL, 0x000fc800078e00ffULL,
0x0000000111297824ULL, 0x000fe400030e0629ULL, 0x0000000136317824ULL, 0x000fe400078e0205ULL,
0x000000802f147825ULL, 0x002fe200078e00ffULL, 0x000000032a2f7212ULL, 0x000fc600078efcffULL,
0x0000000836367824ULL, 0x000fe200078e00ffULL, 0x0000002f102a7210ULL, 0x000fe20007fde0ffULL,
0x00000010302d7824ULL, 0x000fe200078e0227ULL, 0x00000003142f7212ULL, 0x000fe200078efcffULL,
0x000000013c307824ULL, 0x000fe200078e0205ULL, 0xfffffff836367812ULL, 0x000fe200078ee231ULL,
0x00000001112b7824ULL, 0x000fe200030e062bULL, 0x0000002f10147210ULL, 0x000fe20007fde0ffULL,
0x00000000162d7faeULL, 0x0003e2000e901c48ULL, 0x000000102e2f7824ULL, 0x000fe200078e0227ULL,
0x000000133c00720cULL, 0x040fe20003fa6070ULL, 0x000000083c317824ULL, 0x000fc400078e00ffULL,
0x0000002c263c7836ULL, 0x000fe20000000000ULL, 0x00000000202f7faeULL, 0x0005e2000c901c48ULL,
0x0000000111157824ULL, 0x000fe200030e0615ULL, 0xfffffff831307812ULL, 0x000fe200078ee230ULL,
0x000000013e2e7824ULL, 0x040fe200078e0205ULL, 0x000000133e00720cULL, 0x0c0fe20003f26070ULL,
0x000000083e337824ULL, 0x000fe400078e00ffULL, 0x00000010322d7824ULL, 0x002fe400078e0227ULL,
0x000000013c167824ULL, 0x000fe200078e0212ULL, 0xfffffff8332e7812ULL, 0x000fe200078ee22eULL,
0x0000000140327824ULL, 0x000fe200078e0205ULL, 0x00000000222d7faeULL, 0x0003e2000d101c48ULL,
0x000000102c217824ULL, 0x004fe200078e0227ULL, 0x000000134000720cULL, 0x000fe20003f46070ULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x000000001e217faeULL, 0x0005e2000c101c48ULL,
0x00000034262c7836ULL, 0x000fe20000000000ULL, 0x0000000316317212ULL, 0x000fe200078efcffULL,
0x0000000840357824ULL, 0x000fe400078e00ffULL, 0x00000010302f7824ULL, 0x100fe200078e0227ULL,
0x0000003110167210ULL, 0x000fe20007fde0ffULL, 0x0000003026227836ULL, 0x002fe20000000000ULL,
0xfffffff835327812ULL, 0x000fe200078ee232ULL, 0x0000001034237824ULL, 0x100fe400078e0227ULL,
0x00000010362d7824ULL, 0x000fc400078e0227ULL, 0x00000001221e7824ULL, 0x144fe200078e0212ULL,
0x000000001c237faeULL, 0x0003e2000d901c48ULL, 0x0000000111177824ULL, 0x000fe200030e0617ULL,
0x000000132200720cULL, 0x080fe20003f66070ULL, 0x00000008421f7824ULL, 0x000fe200078e00ffULL,
0x000000001a2d7faeULL, 0x0005e2000e101c48ULL, 0x000000102e317824ULL, 0x100fe200078e0227ULL,
0x000000133c00720cULL, 0x080fe20003f86070ULL, 0x0000001032337824ULL, 0x000fe200078e0227ULL,
0x00000000242f7faeULL, 0x0007e2000e901c48ULL, 0x00000038262e7836ULL, 0x000fe20000000000ULL,
0x000000134200720cULL, 0x080fe20003fa6070ULL, 0x0000003c26267836ULL, 0x000fe20000000000ULL,
0x0000000028317faeULL, 0x0009e2000c901c48ULL, 0x000000012c1c7824ULL, 0x002fe200078e0212ULL,
0x000000132e00720cULL, 0x080fe20003f26070ULL, 0x0000000122217824ULL, 0x000fe200078e0205ULL,
0x000000002a337faeULL, 0x0003e2000d101c48ULL, 0x000000801e1a7825ULL, 0x004fe200078e00ffULL,
0x000000132c00720cULL, 0x000fc40003f46070ULL, 0x000000132600720cULL, 0x000fe20003f06070ULL,
0x00000001421e7824ULL, 0x100fe200078e0205ULL, 0x000000031a1d7212ULL, 0x080fe200078efcffULL,
0x000000013c137824ULL, 0x000fe400078e0205ULL, 0x0000000822247824ULL, 0x008fe200078e00ffULL,
0x0000001d101a7210ULL, 0x000fe20007fde0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0xfffffff81f207812ULL, 0x000fe400078ee21eULL, 0xfffffff824247812ULL, 0x000fe200078ee221ULL,
0x00000001111b7824ULL, 0x000fe200030e061bULL, 0x000000031c1f7212ULL, 0x000fe200078efcffULL,
0x000000012e1c7824ULL, 0x000fc400078e0212ULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x0000001f101e7210ULL, 0x000fe20007fde0ffULL, 0x0000000126127824ULL, 0x000fe400078e0212ULL,
0x000000012e257824ULL, 0x000fe200078e0205ULL, 0xfffffff83c227812ULL, 0x000fe200078ee213ULL,
0x00000001111f7824ULL, 0x000fe400030e061dULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x000000082e287824ULL, 0x010fe200078e00ffULL, 0x000000031c217212ULL, 0x000fe200078efcffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x00000021101c7210ULL, 0x000fe20007fde0ffULL,
0x000000012c237824ULL, 0x140fe200078e0205ULL, 0xfffffff828287812ULL, 0x000fe200078ee225ULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0x0000000312257212ULL, 0x000fe200078efcffULL,
0x0000000126297824ULL, 0x040fe400078e0205ULL, 0x00000008262a7824ULL, 0x002fe200078e00ffULL,
0xfffffff82c267812ULL, 0x000fe200078ee223ULL, 0x00000001111d7824ULL, 0x000fe200030e061dULL,
0x0000002510107210ULL, 0x000fe20007fde0ffULL, 0x0000001020037824ULL, 0x100fe200078e0227ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee229ULL, 0x0000001022217824ULL, 0x000fc400078e0227ULL,
0x0000001024237824ULL, 0x100fe200078e0227ULL, 0x0000000014037faeULL, 0x0003e2000e901c48ULL,
0x0000001026257824ULL, 0x100fe400078e0227ULL, 0x0000001028297824ULL, 0x100fe200078e0227ULL,
0x0000000016217faeULL, 0x0003e2000e101c48ULL, 0x000000102a277824ULL, 0x000fe400078e0227ULL,
0x0000000111117824ULL, 0x000fe200030e0613ULL, 0x000000001a237faeULL, 0x0003e8000d901c48ULL,
0x000000001e257faeULL, 0x0003e8000d101c48ULL, 0x000000001c297faeULL, 0x0003e8000c901c48ULL,
0x0000000010277faeULL, 0x0003e2000c101c48ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x0000000405147811ULL, 0x042fe200078fe8ffULL, 0x00000010054d7824ULL, 0x040fe200078e00ffULL,
0x0000000805167811ULL, 0x040fe400078fe8ffULL, 0x0000000c051a7811ULL, 0x040fe200078fe8ffULL,
0x0000000114037824ULL, 0x140fe200078e0205ULL, 0x00000014051e7811ULL, 0x040fe200078fe8ffULL,
0x0000000814307824ULL, 0x000fe200078e00ffULL, 0x00000010051c7811ULL, 0x040fe200078fe8ffULL,
0x0000000116137824ULL, 0x140fe200078e0205ULL, 0x0000001c05227811ULL, 0x040fe200078fe8ffULL,
0x00000008163c7824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee203ULL,
0x000000011a037824ULL, 0x140fe200078e0205ULL, 0x0000002405267811ULL, 0x040fe200078fe8ffULL,
0x000000081a3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x000000011e157824ULL, 0x140fe200078e0205ULL, 0x0000002005247811ULL, 0x040fe200078fe8ffULL,
0x000000081e427824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee203ULL,
0x000000011c137824ULL, 0x140fe200078e0205ULL, 0x0000002c052a7811ULL, 0x040fe200078fe8ffULL,
0x000000081c407824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee215ULL,
0x0000000122037824ULL, 0x140fe200078e0205ULL, 0x0000003405367811ULL, 0x040fe200078fe8ffULL,
0x0000000822467824ULL, 0x000fe200078e00ffULL, 0x0000001805207811ULL, 0x040fe200078fe8ffULL,
0x0000000126157824ULL, 0x140fe200078e0205ULL, 0xfffffff840407812ULL, 0x000fe200078ee213ULL,
0x00000008264a7824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee203ULL,
0x0000000124137824ULL, 0x140fe200078e0205ULL, 0x00000030052c7811ULL, 0x040fe200078fe8ffULL,
0x0000000824487824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee215ULL,
0x000000012a037824ULL, 0x140fe200078e0205ULL, 0x0000002805287811ULL, 0x040fe200078fe8ffULL,
0x000000082a4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fe200078ee213ULL,
0x0000000136157824ULL, 0x100fe200078e0205ULL, 0x0000000a3a197c11ULL, 0x000fe2000f8e70ffULL,
0x0000000836527824ULL, 0x000fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee203ULL,
0x0000000120177824ULL, 0x140fe200078e0205ULL, 0x0000000505037211ULL, 0x040fe200078fe8ffULL,
0x0000000820447824ULL, 0x000fe200078e00ffULL, 0xfffffff852527812ULL, 0x000fe200078ee215ULL,
0x000000012c137824ULL, 0x140fe200078e0205ULL, 0x0000003c05157811ULL, 0x040fe200078fe8ffULL,
0x000000082c507824ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe200078ee217ULL,
0x0000000128177824ULL, 0x140fe200078e0205ULL, 0x0000003805347811ULL, 0x000fe200078fe8ffULL,
0x00000008284c7824ULL, 0x000fe200078e00ffULL, 0xfffffff850507812ULL, 0x000fe200078ee213ULL,
0x0000000115327824ULL, 0x100fe200078e0212ULL, 0x0000001205137211ULL, 0x000fe200078fe8ffULL,
0x0000000815567824ULL, 0x000fe200078e00ffULL, 0x00000007032e7812ULL, 0x000fe200078ec0ffULL,
0x0000000115037824ULL, 0x000fe200078e0205ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee217ULL,
0x000020000e157824ULL, 0x000fe200078e0219ULL, 0x000000704d4d7812ULL, 0x000fe200078ec0ffULL,
0x0000000134177824ULL, 0x040fe200078e0205ULL, 0xfffffff856567812ULL, 0x000fe200078ee203ULL,
0x0000000834547824ULL, 0x000fe200078e00ffULL, 0x0ffffff82e2e7812ULL, 0x000fe200078ef805ULL,
0x0000000114147824ULL, 0x000fc400078e0212ULL, 0x0000000116167824ULL, 0x100fe200078e0212ULL,
0xfffffff854547812ULL, 0x000fe200078ee217ULL, 0x000000011a1a7824ULL, 0x100fe400078e0212ULL,
0x000000011c1c7824ULL, 0x100fe400078e0212ULL, 0x000000011e1e7824ULL, 0x100fe400078e0212ULL,
0x0000000120207824ULL, 0x100fe400078e0212ULL, 0x0000000122227824ULL, 0x000fc400078e0212ULL,
0x0000000124247824ULL, 0x100fe400078e0212ULL, 0x0000000126267824ULL, 0x100fe400078e0212ULL,
0x0000000128287824ULL, 0x100fe400078e0212ULL, 0x000000012a2a7824ULL, 0x100fe400078e0212ULL,
0x000000012c2c7824ULL, 0x100fe400078e0212ULL, 0x0000000136367824ULL, 0x000fc400078e0212ULL,
0x0000000134347824ULL, 0x000fe400078e0212ULL, 0x0000008013127825ULL, 0x000fc800078e00ffULL,
0x00001000151d7836ULL, 0x000fe20000000000ULL, 0x0000004d12037212ULL, 0x000fe200078efcffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x0000000310127210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004d141b7212ULL, 0x000fc600078efcffULL,
0x0000000111137824ULL, 0x000fe200000e0613ULL, 0x0000001b10147210ULL, 0x000fe20007f3e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000004d161f7212ULL, 0x000fc600078efcffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000001f10167210ULL, 0x000fe40007f1e0ffULL,
0x0000004d1a237212ULL, 0x080fe200078efcffULL, 0x000000102e4b7824ULL, 0x000fe400078e021dULL,
0x0000000111177824ULL, 0x000fe200000e0617ULL, 0x00000023101a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001030497824ULL, 0x100fe200078e021dULL, 0x0000004d20237212ULL, 0x080fe200078efcffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000124b7faeULL, 0x0003e4000b901c48ULL, 0x0000002310207210ULL, 0x000fe20007f5e0ffULL,
0x000000103c477824ULL, 0x100fe200078e021dULL, 0x0000004d1e257212ULL, 0x000fe200078efcffULL,
0x000000103e457824ULL, 0x000fc400078e021dULL, 0x0000001040437824ULL, 0x100fe400078e021dULL,
0x00000010423f7824ULL, 0x100fe400078e021dULL, 0x00000010443d7824ULL, 0x100fe400078e021dULL,
0x00000010463b7824ULL, 0x100fe400078e021dULL, 0x0000001048377824ULL, 0x100fe400078e021dULL,
0x000000104a357824ULL, 0x000fc400078e021dULL, 0x000000104c337824ULL, 0x100fe400078e021dULL,
0x000000104e317824ULL, 0x100fe400078e021dULL, 0x0000001050307824ULL, 0x100fe400078e021dULL,
0x00000010522f7824ULL, 0x100fe400078e021dULL, 0x00000010542e7824ULL, 0x100fe400078e021dULL,
0x0000001056037824ULL, 0x000fc400078e021dULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000004d1c277212ULL, 0x000fc600078efcffULL,
0x00000001111b7824ULL, 0x040fe200000e061bULL, 0x00000025101e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000111157824ULL, 0x040fe200008e0615ULL, 0x00000027101c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000004d222d7212ULL, 0x080fe400078efcffULL,
0x0000000014497faeULL, 0x0003e2000b901c48ULL, 0x00000001111f7824ULL, 0x000fe200000e061fULL,
0x0000002d10227210ULL, 0x000fe20007f1e0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000004d264f7212ULL, 0x080fe200078efcffULL, 0x0000000016477faeULL, 0x0003e4000b901c48ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000004d282d7212ULL, 0x000fe200078efcffULL,
0x000000001a457faeULL, 0x0003e4000b901c48ULL, 0x0000008024247825ULL, 0x000fc800078e00ffULL,
0x0000000111237824ULL, 0x040fe200000e0623ULL, 0x0000004f10267210ULL, 0x000fe20007f1e0ffULL,
0x0000000111217824ULL, 0x040fe200010e0621ULL, 0x0000004d2a4f7212ULL, 0x080fe200078efcffULL,
0x00000001111d7824ULL, 0x040fe200008e061dULL, 0x0000004d24517212ULL, 0x080fe200078efcffULL,
0x0000000111277824ULL, 0x040fe200000e0627ULL, 0x0000002d10287210ULL, 0x000fe20007f5e0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000004f102a7210ULL, 0x000fe20007f1e0ffULL,
0x000000001c437faeULL, 0x0003e2000b901c48ULL, 0x0000005110247210ULL, 0x000fe20007f3e0ffULL,
0x00000080364e7825ULL, 0x000fe200078e00ffULL, 0x0000004d2c597212ULL, 0x080fe200078efcffULL,
0x000000001e3f7faeULL, 0x0003e4000b901c48ULL, 0x0000008034507825ULL, 0x000fe200078e00ffULL,
0x0000004d4e577212ULL, 0x080fe200078efcffULL, 0x00000000203d7faeULL, 0x0003e4000b901c48ULL,
0x0000008032527825ULL, 0x000fe200078e00ffULL, 0x0000004d50557212ULL, 0x080fe200078efcffULL,
0x00000000223b7faeULL, 0x0003e4000b901c48ULL, 0x00000001112b7824ULL, 0x040fe200000e062bULL,
0x0000004d524d7212ULL, 0x000fe200078efcffULL, 0x0000000111257824ULL, 0x040fe200008e0625ULL,
0x00000059102c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000111297824ULL, 0x000fe200010e0629ULL,
0x00000057104c7210ULL, 0x000fc40007f3e0ffULL, 0x00000055104e7210ULL, 0x000fe20007f5e0ffULL,
0x00000001112d7824ULL, 0x040fe200000e062dULL, 0x0000004d10107210ULL, 0x000fe20007f7e0ffULL,
0x00000001114d7824ULL, 0x040fe200008e064fULL, 0x0000000024377faeULL, 0x0003e2000b901c48ULL,
0x00000001114f7824ULL, 0x040fe400010e0651ULL, 0x0000000111117824ULL, 0x000fe200018e0653ULL,
0x0000000026357faeULL, 0x0003e8000b901c48ULL, 0x0000000028337faeULL, 0x0003e8000b901c48ULL,
0x000000002a317faeULL, 0x0003e8000b901c48ULL, 0x000000002c307faeULL, 0x0003e8000b901c48ULL,
0x000000004c2f7faeULL, 0x0003e8000b901c48ULL, 0x000000004e2e7faeULL, 0x0003e8000b901c48ULL,
0x0000000010037faeULL, 0x0003e4000b901c48ULL, 0x0000000204047836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff037424ULL, 0x002fc600078e00ffULL,
0x000000390400720cULL, 0x000fda0003f06070ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x0000000207118824ULL, 0x000fe400078e0204ULL, 0x0000002005167836ULL, 0x000fe20000000000ULL,
0xfffffff805487812ULL, 0x040fe200078ec0ffULL, 0x0000200018437824ULL, 0x000fe200078e0219ULL,
0x0000000705427812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x00000004ff407819ULL, 0x000fe40000011605ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000411148825ULL, 0x002fe200078e0014ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000814038981ULL, 0x000322000c1e1900ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000100043437836ULL, 0x000fe20000000000ULL, 0x0000000748487812ULL, 0x000fe400078ef805ULL,
0x0000000842497812ULL, 0x000fe400078ef805ULL, 0xfffffff816147812ULL, 0x002fc800078ec0ffULL,
0x00000007143b7812ULL, 0x000fce00078ef805ULL, 0x0000000148147824ULL, 0x140fe400078e024bULL,
0x0000000848157824ULL, 0x040fe400078e00ffULL, 0x00000010493e7824ULL, 0x000fe400078e00ffULL,
0x000000013b167824ULL, 0x040fe200078e024bULL, 0xfffffff815147812ULL, 0x000fe200078ee214ULL,
0x000000083b177824ULL, 0x000fe400078e00ffULL, 0x0000000848567824ULL, 0x000fc400078e00ffULL,
0x0000001014187824ULL, 0x100fe200078e0243ULL, 0xfffffff8173c7812ULL, 0x000fe200078ee216ULL,
0x000000024b147824ULL, 0x000fe400078e0240ULL, 0x00000010493d7824ULL, 0x040fe400078e00ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x0000000149157824ULL, 0x140fe200078e0214ULL,
0x0000000249507810ULL, 0x000fe20007ffe014ULL, 0x000000014b147836ULL, 0x000fe40000000000ULL,
0x000000103c3c7824ULL, 0x000fe200078e0243ULL, 0xfffffff03e157812ULL, 0x000fe200078ee215ULL,
0x0000000148177824ULL, 0x100fe200078e0214ULL, 0xfffffff03d507812ULL, 0x000fe200078ee250ULL,
0x000000013b3e7824ULL, 0x000fe200078e0214ULL, 0x0000000a15157c11ULL, 0x000fe2000f8e20ffULL,
0x000000083b3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff856567812ULL, 0x000fe200078ee217ULL,
0x000000024b4b7836ULL, 0x000fc60000000000ULL, 0xfffffff83d3e7812ULL, 0x000fe200078ee23eULL,
0x0000001056567824ULL, 0x000fe200078e0243ULL, 0x000000084b00780cULL, 0x000fc60003f05270ULL,
0x000000103e3e7824ULL, 0x000fe200078e0243ULL, 0x00000018ff147819ULL, 0x102fe40000011618ULL,
0x000000ff18167812ULL, 0x000fe400078ec0ffULL, 0x00000014ff44723eULL, 0x000fe400020006ffULL,
0x00000016ff3f723eULL, 0x000fe400020006ffULL, 0x000000001514783bULL, 0x000e620000000200ULL,
0x00000010ff3d7819ULL, 0x000fc40000011618ULL, 0x0000ffff184d7812ULL, 0x000fe200078ec0ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000018ff187819ULL, 0x000fe40000011619ULL,
0x00000010ff517819ULL, 0x100fe4000001161bULL, 0x00000018ff747819ULL, 0x000fe4000001161bULL,
0x000000ff1b727812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b547812ULL, 0x000fc400078ec0ffULL,
0x00000018ff1b723eULL, 0x000fe400020006ffULL, 0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff187819ULL, 0x000fe2000001164dULL, 0x2000001bff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff19457812ULL, 0x000fe400078ec0ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fc400020006ffULL, 0x00000010ff4f7819ULL, 0x100fe2000001161aULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000018ff4a7819ULL, 0x000fe2000001161aULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x000000ff1a527812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1a557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fe40000011619ULL,
0x0000ffff19537812ULL, 0x000fe200078ec0ffULL, 0x20000044ff197230ULL, 0x000fe20000004100ULL,
0x00000045ff1a723eULL, 0x000fc400020006ffULL, 0x000000ff4c4c7812ULL, 0x000fe200078ec0ffULL,
0x000000003c44783bULL, 0x0004e20000000200ULL, 0x00000008ff1b7819ULL, 0x000fe20000011653ULL,
0x2000001aff4d7230ULL, 0x000fe20000004100ULL, 0x00000010ff1a7819ULL, 0x000fe40000011619ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff197819ULL, 0x000fe40000011618ULL,
0x00000010ff3c7819ULL, 0x004fc4000001163fULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000001bff3f723eULL, 0x000fe400020006ffULL, 0x000010541a3d7816ULL, 0x000fe2000000003dULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00001054193c7816ULL, 0x000fe2000000003cULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000005618783bULL, 0x000fe20000000200ULL,
0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x00000052ff52723eULL, 0x000fc400020006ffULL,
0x0000003c1434723cULL, 0x002fe20000041834ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x0000004fff53723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000008ff4f7819ULL, 0x000fe40000011655ULL, 0x00000010ff3d7819ULL, 0x000fe2000001164eULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe4000001164cULL,
0x00000010ff4c7819ULL, 0x000fc4000001164dULL, 0x000010543d4d7816ULL, 0x000fe4000000003cULL,
0x000010543f4c7816ULL, 0x000fe4000000004cULL, 0x000000003e3c783bULL, 0x000e620000000200ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000010ff5a7819ULL, 0x008fe40000011647ULL,
0x0000ffff446d7812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000008ff547819ULL, 0x000fe20000011654ULL, 0x0000004c1430723cULL, 0x000fe20000041830ULL,
0x00000010ff647819ULL, 0x000fc40000011646ULL, 0x0000ffff45677812ULL, 0x000fe400078ec0ffULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fe40000011644ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff527819ULL, 0x000fe20000011652ULL, 0x20000054ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff4f7819ULL, 0x000fc4000001164fULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000018ff557819ULL, 0x000fe40000011645ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011644ULL, 0x000000ff44707812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e5f7812ULL, 0x002fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x000010544f527816ULL, 0x000fe40000000052ULL, 0x00000010ff447819ULL, 0x000fe40000011618ULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x0000ffff194f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x100fe4000001161aULL, 0x00000018ff577819ULL, 0x000fe4000001161aULL,
0x000000ff1a4c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1a4d7812ULL, 0x000fe400078ec0ffULL,
0x00000067ff54723eULL, 0x000fe200020006ffULL, 0x2000005aff677230ULL, 0x000fe20000004100ULL,
0x00000018ff637819ULL, 0x000fc4000001163fULL, 0x00000055ff1a723eULL, 0x000fe200020006ffULL,
0x20000071ff557230ULL, 0x000fe20000004100ULL, 0x000000ff3f5e7812ULL, 0x000fe200078ec0ffULL,
0x2000006dff717230ULL, 0x000fe20000004100ULL, 0x0000005fff5a723eULL, 0x000fe200020006ffULL,
0x20000064ff6d7230ULL, 0x000fe20000004100ULL, 0x0000ffff475c7812ULL, 0x000fe200078ec0ffULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x000000ff445f7812ULL, 0x000fe200078ec0ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000018ff6e7819ULL, 0x000fe20000011646ULL,
0x2000005aff447230ULL, 0x000fe20000004100ULL, 0x000000ff466c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff465d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff467819ULL, 0x100fe40000011619ULL, 0x00000018ff617819ULL, 0x000fe40000011619ULL,
0x000000ff19587812ULL, 0x000fe400078ec0ffULL, 0x000000ff51517812ULL, 0x000fc400078ec0ffULL,
0x00000063ff64723eULL, 0x000fe400020006ffULL, 0x00000010ff197819ULL, 0x000fe4000001161bULL,
0x0000005eff63723eULL, 0x000fe400020006ffULL, 0x00000010ff687819ULL, 0x000fe40000011645ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff537819ULL, 0x000fc40000011653ULL,
0x00000008ff5c7819ULL, 0x000fe4000001165cULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x000000ff456f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe40000011618ULL, 0x00000051ff51723eULL, 0x000fc400020006ffULL,
0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff18627812ULL, 0x040fe200078ec0ffULL,
0x20000051ff757230ULL, 0x000fe20000004100ULL, 0x0000ffff18457812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff465e7812ULL, 0x000fe200078ec0ffULL, 0x20000063ff467230ULL, 0x000fe20000004100ULL,
0x000000ff19197812ULL, 0x000fe200078ec0ffULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x000010544a537816ULL, 0x000fe20000000053ULL, 0x2000004fff5f7230ULL, 0x000fe20000004100ULL,
0x0000ffff1b187812ULL, 0x000fe200078ec0ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fe2000001163cULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x00000052142c723cULL, 0x000fe2000004182cULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000019ff4f723eULL, 0x000fe400020006ffULL,
0x00000068ff51723eULL, 0x000fe200020006ffULL, 0x2000005cff687230ULL, 0x000fe20000004100ULL,
0x00000008ff187819ULL, 0x000fe40000011618ULL, 0x000000ff59197812ULL, 0x000fe200078ec0ffULL,
0x2000004eff597230ULL, 0x000fe20000004100ULL, 0x00000061ff5c723eULL, 0x000fe200020006ffULL,
0x20000076ff617230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fe20000011647ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000018ff797819ULL, 0x000fe2000001163cULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff3c787812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3c527812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4e723eULL, 0x000fe400020006ffULL,
0x00000019ff76723eULL, 0x000fe400020006ffULL, 0x000000ff47667812ULL, 0x000fe200078ec0ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x100fe4000001163dULL,
0x00000018ff777819ULL, 0x000fc4000001163dULL, 0x000000ff3d3c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3d6a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff197819ULL, 0x000fe40000011675ULL, 0x00000010ff187819ULL, 0x000fe40000011672ULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000018ff4a7819ULL, 0x000fe4000001161bULL,
0x000000ff1b477812ULL, 0x000fe400078ec0ffULL, 0x00000010ff697819ULL, 0x100fe4000001163eULL,
0x00000018ff3d7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e607812ULL, 0x000fe400078ec0ffULL,
0x0000006fff1b723eULL, 0x000fc400020006ffULL, 0x0000006bff3e723eULL, 0x000fe400020006ffULL,
0x0000105474197816ULL, 0x000fe20000000019ULL, 0x2000001bff1b7230ULL, 0x000fe20000004100ULL,
0x0000105473187816ULL, 0x000fe40000000018ULL, 0x00000010ff5b7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f567812ULL, 0x000fe400078ec0ffULL, 0x00000066ff3f723eULL, 0x000fe200020006ffULL,
0x2000003eff667230ULL, 0x000fe20000004100ULL, 0x000000ff653e7812ULL, 0x000fe200078ec0ffULL,
0x000000181428723cULL, 0x000fe20000041828ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x2000003fff657230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fc400020006ffULL,
0x00000010ff1a7819ULL, 0x000fe2000001161aULL, 0x20000070ff6f7230ULL, 0x000fe20000004100ULL,
0x0000000a50187c11ULL, 0x000fe2000f8e20ffULL, 0x2000003eff707230ULL, 0x000fe20000004100ULL,
0x00000010ff1b7819ULL, 0x000fe4000001161bULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff507819ULL, 0x000fe40000011654ULL, 0x000010541a517816ULL, 0x000fc40000000051ULL,
0x0000105450507816ULL, 0x000fe4000000001bULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x00000008ff737819ULL, 0x000fe40000011652ULL,
0x000000ff53747812ULL, 0x000fe200078ec0ffULL, 0x000000501420723cULL, 0x000fe20000041820ULL,
0x00000010ff727819ULL, 0x000fe40000011655ULL, 0x00000010ff527819ULL, 0x000fc4000001166fULL,
0x00000010ff537819ULL, 0x000fe40000011670ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x2000006eff6b7230ULL, 0x000fe20000004100ULL,
0x0000105472537816ULL, 0x000fe20000000053ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000105471527816ULL, 0x000fe20000000052ULL, 0x2000005dff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff5a7819ULL, 0x000fe20000011645ULL, 0x20000064ff457230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fc4000001166aULL, 0x000000ff69707812ULL, 0x000fe200078ec0ffULL,
0x000000521424723cULL, 0x000fe20000041824ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166bULL,
0x00000010ff697819ULL, 0x000fe4000001166eULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fe4000001166dULL, 0x00000010ff527819ULL, 0x000fe2000001166cULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fc400020006ffULL,
0x000010546a537816ULL, 0x000fe40000000053ULL, 0x00000010ff517819ULL, 0x000fe20000011667ULL,
0x2000005aff647230ULL, 0x000fe20000004100ULL, 0x0000105469527816ULL, 0x000fe40000000052ULL,
0x00000010ff6a7819ULL, 0x000fe40000011666ULL, 0x00000010ff507819ULL, 0x000fe40000011665ULL,
0x00000010ff677819ULL, 0x000fe20000011668ULL, 0x00000052141c723cULL, 0x000fe2000004181cULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x000010546a517816ULL, 0x000fe20000000051ULL, 0x20000058ff5d7230ULL, 0x000fe20000004100ULL,
0x0000105467507816ULL, 0x000fe20000000050ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff527819ULL, 0x000fe40000011661ULL,
0x00000010ff627819ULL, 0x000fe20000011662ULL, 0x000000501410723cULL, 0x000fe20000041810ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff537819ULL, 0x000fe40000011664ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x0000105452177816ULL, 0x000fe20000000063ULL, 0x2000004cff587230ULL, 0x000fe20000004100ULL,
0x0000105453167816ULL, 0x000fe20000000062ULL, 0x2000004dff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x000fe2000001165cULL, 0x2000004fff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe2000001165dULL, 0x20000076ff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe2000001165eULL, 0x000000161834723cULL, 0x002fe20000041834ULL,
0x00000010ff5f7819ULL, 0x000fc4000001165fULL, 0x0000004aff3e723eULL, 0x000fe400020006ffULL,
0x000010545c157816ULL, 0x000fe40000000015ULL, 0x000010545f147816ULL, 0x000fe40000000014ULL,
0x00000047ff4a723eULL, 0x000fe200020006ffULL, 0x2000003eff477230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000010ff527819ULL, 0x000fe20000011657ULL,
0x000000141830723cULL, 0x000fe20000041830ULL, 0x00000010ff167819ULL, 0x000fe20000011658ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fc40000011659ULL,
0x00000010ff537819ULL, 0x000fe4000001165aULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x0000003cff3e723eULL, 0x000fe200020006ffULL, 0x20000078ff3c7230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000003dff3f723eULL, 0x000fe200020006ffULL,
0x20000077ff3d7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x2000006fff667230ULL, 0x000fe20000004100ULL, 0x00000074ff55723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x0000105452177816ULL, 0x000fe20000000017ULL,
0x20000073ff547230ULL, 0x000fe20000004100ULL, 0x0000105453167816ULL, 0x000fe20000000016ULL,
0x20000070ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff607819ULL, 0x000fe20000011660ULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x000000ff5b5b7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe20000011656ULL, 0x00000016182c723cULL, 0x000fe2000004182cULL,
0x00000010ff147819ULL, 0x000fe40000011647ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000079ff4c723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005bff51723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x20000060ff507230ULL, 0x000fe20000004100ULL,
0x00001054144d7816ULL, 0x000fe2000000004dULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe2000001163cULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fc4000001163dULL, 0x00000010ff167819ULL, 0x000fe4000001163eULL,
0x00000010ff3d7819ULL, 0x000fe40000011666ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163fULL,
0x00000010ff177819ULL, 0x000fe40000011654ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff557819ULL, 0x000fc40000011655ULL, 0x000010543d167816ULL, 0x000fe40000000016ULL,
0x0000105417147816ULL, 0x000fe40000000014ULL, 0x000010543e3d7816ULL, 0x000fe40000000065ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff157819ULL, 0x000fe4000001164eULL,
0x000010543c177816ULL, 0x000fc40000000055ULL, 0x00000010ff3e7819ULL, 0x000fe40000011645ULL,
0x00000010ff527819ULL, 0x000fe4000001164cULL, 0x00000010ff4f7819ULL, 0x000fe2000001164fULL,
0x000000161820723cULL, 0x000fe20000041820ULL, 0x00000010ff3c7819ULL, 0x000fe40000011644ULL,
0x00000010ff3f7819ULL, 0x000fe40000011650ULL, 0x00000010ff477819ULL, 0x000fc40000011651ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff457819ULL, 0x000fe40000011656ULL,
0x00001054154c7816ULL, 0x000fe4000000004aULL, 0x0000105452157816ULL, 0x000fe4000000004fULL,
0x000010543f3c7816ULL, 0x000fe4000000003cULL, 0x000010543e477816ULL, 0x000fe20000000047ULL,
0x0000004c1828723cULL, 0x000fe20000041828ULL, 0x0000105445467816ULL, 0x000fca0000000046ULL,
0x000000141824723cULL, 0x000fec0000041824ULL, 0x0000003c181c723cULL, 0x000fec000004181cULL,
0x000000461810723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe800300947ULL, 0x000fde000383ffffULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x0000000834177220ULL, 0x080fe20000410000ULL, 0x0000000824167220ULL, 0x080fe20000410000ULL,
0x0000000825347220ULL, 0x080fe20000410000ULL, 0x00000008213d7220ULL, 0x080fe20000410000ULL,
0x00000008223b7220ULL, 0x080fe20000410000ULL, 0x01768814091479a7ULL, 0x000262000850003fULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000836367220ULL, 0x080fe20000410000ULL,
0x0000000837377220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000832327220ULL, 0x080fe20000410000ULL,
0x0000000833337220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x000000082e2e7220ULL, 0x080fe20000410000ULL,
0x000000082f2f7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x000000082a2a7220ULL, 0x080fe20000410000ULL,
0x000000082b2b7220ULL, 0x080fe20000410000ULL, 0x0000000826267220ULL, 0x080fe20000410000ULL,
0x0000000827277220ULL, 0x080fe20000410000ULL, 0x00000008203c7220ULL, 0x080fe20000410000ULL,
0x0000000823237220ULL, 0x080fe20000410000ULL, 0x000000081c3e7220ULL, 0x080fe20000410000ULL,
0x000000081d3f7220ULL, 0x080fe20000410000ULL, 0x000000081e217220ULL, 0x080fe20000410000ULL,
0x000000081f227220ULL, 0x080fe20000410000ULL, 0x0000000810407220ULL, 0x080fe20000410000ULL,
0x0000000811437220ULL, 0x080fe20000410000ULL, 0x0000000812247220ULL, 0x080fe20000410000ULL,
0x0000000813257220ULL, 0x002fce0000410000ULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x01768815090075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x0000001210197210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001912127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x01768815090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000405107824ULL, 0x000fe200078e00ffULL,
0x0000000a3a117c11ULL, 0x000fe4000f8e38ffULL, 0x0000000c0b00720cULL, 0x000fe40003f06070ULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x0000000111207824ULL, 0x000fca00078e0210ULL,
0x0174000020107984ULL, 0x0002a20000000c00ULL, 0x0000001000c48947ULL, 0x000fea0003800000ULL,
0xffffff000f0f7836ULL, 0x000fe20000000000ULL, 0x0000000005187211ULL, 0x040fe200078ff0ffULL,
0x0000000205447824ULL, 0x000fe200078e00ffULL, 0x0000860000077ab9ULL, 0x000fe20000000800ULL,
0x00008400000b7ab9ULL, 0x000fe20000000800ULL, 0x0000000f38147248ULL, 0x000fe40007fe0000ULL,
0x0000000644447812ULL, 0x000fe400078ec0ffULL, 0x00000007ff197c19ULL, 0x000fe20008011618ULL,
0x00000001140f7824ULL, 0x000fc400078e0a0fULL, 0x00008c00ff147b82ULL, 0x000ee20000000a00ULL,
0x00000006441a7c36ULL, 0x000fe20008000000ULL, 0x0000000519197c48ULL, 0x000fe2000bfe0000ULL,
0x000000ffff557224ULL, 0x000fe400078e0a0fULL, 0x0000000b44467c36ULL, 0x000fe20008000000ULL,
0x0000000f1a00720cULL, 0x080fe20003f26070ULL, 0x0000000818187836ULL, 0x000fe20000000000ULL,
0x000000051a1a7e46ULL, 0x000fe2000b800055ULL, 0x00000004195e7c24ULL, 0x000fe2000f8e02ffULL,
0x0000000f4600720cULL, 0x000fc40003f06070ULL, 0x0000000546517e46ULL, 0x000fe4000b800055ULL,
0x00000004ff1a7819ULL, 0x000fe4000001161aULL, 0x000000ff51517207ULL, 0x000fe40000000000ULL,
0x000000ff1a197207ULL, 0x000fe40000800000ULL, 0x00000007ff187c19ULL, 0x000fe40008011618ULL,
0x0000005e511f7211ULL, 0x000fe200078fe0ffULL, 0x000000015e1d7824ULL, 0x000fe200078e0219ULL,
0x0000000518187c48ULL, 0x000fc4000bfe0000ULL, 0x00000010444a7812ULL, 0x000fe200078efcffULL,
0x000000021f1e7825ULL, 0x008fc800078e0014ULL, 0x000000021d1c7825ULL, 0x000fe200078e0014ULL,
0x000000081e577981ULL, 0x0044e6000c1e9500ULL, 0x0000000418607c24ULL, 0x000fe2000f8e02ffULL,
0x000000081c5c7981ULL, 0x000ae2000c1e9500ULL, 0x0000000b4a487c36ULL, 0x000fe40008000000ULL,
0x0000000119197824ULL, 0x000fe200078e0260ULL, 0x00000060511b7211ULL, 0x000fe200078fe0ffULL,
0x000000064a1e7c36ULL, 0x004fe20008000000ULL, 0x0000000f4800720cULL, 0x000fe20003f06070ULL,
0x0000000219187825ULL, 0x000fe200078e0014ULL, 0x0000000548457e46ULL, 0x000fc4000b800055ULL,
0x00000020444e7812ULL, 0x000fe200078efcffULL, 0x000000021b1a7825ULL, 0x000fe200078e0014ULL,
0x000000ff45457207ULL, 0x000fe20000000000ULL, 0x00000008185a7981ULL, 0x0004e2000c1e9500ULL,
0x000000051e1c7e46ULL, 0x022fe2000b800055ULL, 0x0000000b4e507c36ULL, 0x000fe20008000000ULL,
0x0000000f1e00720cULL, 0x080fe20003f26070ULL, 0x000000081a537981ULL, 0x000362000c1e9500ULL,
0x00000004ff1c7819ULL, 0x000fe2000001161cULL, 0x000000064e547c36ULL, 0x000fe20008000000ULL,
0x0000000f5000720cULL, 0x000fc40003f06070ULL, 0x0000005e45197211ULL, 0x004fe400078fe0ffULL,
0x00000005504b7e46ULL, 0x000fe4000b800055ULL, 0x000000ff1c1d7207ULL, 0x000fe20000800000ULL,
0x0000000219187825ULL, 0x000fe200078e0014ULL, 0x000000ff4b4b7207ULL, 0x000fe40000000000ULL,
0x00000060451f7211ULL, 0x000fe200078fe0ffULL, 0x000000015e1b7824ULL, 0x002fe200078e021dULL,
0x00000005544d7e46ULL, 0x000fe2000b800055ULL, 0x0000000818477981ULL, 0x0002a2000c1e9500ULL,
0x000000011d497824ULL, 0x000fe200078e0260ULL, 0x0000000f5400720cULL, 0x000fe20003f26070ULL,
0x000000021f1c7825ULL, 0x000fe200078e0014ULL, 0x0000003044547812ULL, 0x000fc400078efcffULL,
0x00000004ff4d7819ULL, 0x000fe2000001164dULL, 0x000000021b1a7825ULL, 0x000fe200078e0014ULL,
0x0000005e4b197211ULL, 0x002fc600078fe0ffULL, 0x00000002491e7825ULL, 0x100fe200078e0014ULL,
0x000000ff4d4f7207ULL, 0x000fe20000800000ULL, 0x000000081a4c7981ULL, 0x0002a4000c1e9500ULL,
0x0000000219187825ULL, 0x000fe400078e0014ULL, 0x000000081c497981ULL, 0x0002a4000c1e9500ULL,
0x0000000654627c36ULL, 0x000fe40008000000ULL, 0x000000081e527981ULL, 0x0002a2000c1e9500ULL,
0x0000000b54567c36ULL, 0x000fc60008000000ULL, 0x00000008184d7981ULL, 0x0002a4000c1e9500ULL,
0x000000015e1b7824ULL, 0x002fe200078e024fULL, 0x000000604b1d7211ULL, 0x000fe200078fe0ffULL,
0x000000014f1f7824ULL, 0x000fe200078e0260ULL, 0x0000000562187e46ULL, 0x000fc6000b800055ULL,
0x000000021f1e7825ULL, 0x100fe200078e0014ULL, 0x0000000f5600720cULL, 0x080fe40003f06070ULL,
0x0000000556557e46ULL, 0x000fe2000b800055ULL, 0x000000021b1a7825ULL, 0x000fe200078e0014ULL,
0x0000000f6200720cULL, 0x000fe20003f26070ULL, 0x000000081e1e7981ULL, 0x000ea2000c1e9500ULL,
0x00000004ff187819ULL, 0x000fe20000011618ULL, 0x000000021d1c7825ULL, 0x000fe200078e0014ULL,
0x000000ff55557207ULL, 0x000fe20000000000ULL, 0x000000081a587981ULL, 0x0002a2000c1e9500ULL,
0x000000ff18597207ULL, 0x000fc60000800000ULL, 0x000000081c4f7981ULL, 0x0002a2000c1e9500ULL,
0x0000005e55197211ULL, 0x000fe200078fe0ffULL, 0x000000015e1b7824ULL, 0x002fc800078e0259ULL,
0x0000000219187825ULL, 0x000fc800078e0014ULL, 0x000000021b1a7825ULL, 0x000fe200078e0014ULL,
0x00000060551d7211ULL, 0x000fe200078fe0ffULL, 0x0000000818187981ULL, 0x0002a8000c1e9500ULL,
0x000000081a1b7981ULL, 0x0002a2000c1e9500ULL, 0x0000000159597824ULL, 0x000fe400078e0260ULL,
0x000000021d1c7825ULL, 0x000fc800078e0014ULL, 0x0000000259147825ULL, 0x000fe400078e0014ULL,
0x000000081c1c7981ULL, 0x000ea8000c1e9500ULL, 0x0000000814157981ULL, 0x0002a2000c1e9500ULL,
0xfffffff0515e7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff1f7424ULL, 0x000fc800078e00ffULL,
0x000000010f197824ULL, 0x002fc800078e025eULL, 0x0000000146647824ULL, 0x100fe200078e0a19ULL,
0x0000000844627812ULL, 0x040fe400078efcffULL, 0x0000000944607812ULL, 0x000fe400078efcffULL,
0x000000641f647219ULL, 0x000fe200000006ffULL, 0x0000000b621a7c36ULL, 0x000fe40008000000ULL,
0x0000000b60147c36ULL, 0x000fe40008000000ULL, 0x000000011a687824ULL, 0x000fc400078e0a19ULL,
0x00000001146a7824ULL, 0x000fe200078e0a19ULL, 0x00000018447a7812ULL, 0x040fe400078efcffULL,
0x000000681f687219ULL, 0x040fe400000006ffULL, 0x0000006a1f6a7219ULL, 0x000fe400000006ffULL,
0xfffffff045457812ULL, 0x000fe200078ec0ffULL, 0x0000000b7a1d7c36ULL, 0x000fe20008000000ULL,
0x00000011447c7812ULL, 0x040fe400078efcffULL, 0x0000001944787812ULL, 0x000fc400078efcffULL,
0xfffffff055557812ULL, 0x000fe200078ec0ffULL, 0x0000000b7c517c36ULL, 0x000fc80008000000ULL,
0x000000010f637824ULL, 0x000fe200078e0255ULL, 0x00000021446e7812ULL, 0x040fe400078efcffULL,
0x00000028446c7812ULL, 0x000fc600078efcffULL, 0x0000000b6e747c36ULL, 0x000fe40008000000ULL,
0x0000000b6c727c36ULL, 0x000fe40008000000ULL, 0x0000000156657824ULL, 0x000fca00078e0a63ULL,
0x000000651f657219ULL, 0x000fe400000006ffULL, 0x0000541057577816ULL, 0x008fe4000000005cULL,
0x00000001445c7812ULL, 0x000fe400078efcffULL, 0x0000005764ff7212ULL, 0x000fc6000780c0ffULL,
0x0000000b5c5e7c36ULL, 0x000fe20008000000ULL, 0x0000000f4600720cULL, 0x000fc60000701470ULL,
0x000000015e667824ULL, 0x000fe200078e0a19ULL, 0x0000000f4400720cULL, 0x000fc800007a1070ULL,
0x000000661f667219ULL, 0x000fe400000006ffULL, 0x0000541053537816ULL, 0x020fe4000000005aULL,
0xff80000017177808ULL, 0x000fe40002800000ULL, 0x0000005364ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005366ff7212ULL, 0x080fe4000780c0ffULL, 0x0000005368ff7212ULL, 0x000fc400078cc0ffULL,
0x000000536aff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff04b537812ULL, 0x000fe200078ec0ffULL,
0x000000010f4b7824ULL, 0x040fe200078e0245ULL, 0x0000005766ff7212ULL, 0x080fe2000782c0ffULL,
0x0000000b78197c36ULL, 0x000fe20008000000ULL, 0x0000005768ff7212ULL, 0x080fe2000786c0ffULL,
0x000000010f5b7824ULL, 0x000fe200078e0253ULL, 0x000000576aff7212ULL, 0x000fe2000788c0ffULL,
0x0000000148537824ULL, 0x100fe200078e0a4bULL, 0x0000000f4600720cULL, 0x080fe20001741470ULL,
0x000000011d577824ULL, 0x000fe200078e0a4bULL, 0x0000000f1a00720cULL, 0x000fc400037c1470ULL,
0x0000000f1400720cULL, 0x080fe20002fa1470ULL, 0x0000000151557824ULL, 0x100fe200078e0a4bULL,
0x0000000f4400720cULL, 0x080fe20001741070ULL, 0x0000000119597824ULL, 0x000fe200078e0a4bULL,
0x0000000f6200720cULL, 0x080fe400037c1070ULL, 0x0000000f6000720cULL, 0x000fe40002fa1070ULL,
0x000000531f4b7219ULL, 0x040fe400000006ffULL, 0x000000571f577219ULL, 0x000fc400000006ffULL,
0x00005410474c7816ULL, 0x004fe4000000004cULL, 0x0000541049527816ULL, 0x000fe40000000052ULL,
0xff80000036367808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000004c4bff7212ULL, 0x000fc4000784c0ffULL,
0x000000524bff7212ULL, 0x080fe400078cc0ffULL, 0x0000005257ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001505d7824ULL, 0x000fe200078e0a5bULL, 0x0000000f5e00720cULL, 0x0c0fe40000f21470ULL,
0x0000000f5e00720cULL, 0x080fe40000701470ULL, 0x0000000f1a00720cULL, 0x080fe40001f61470ULL,
0x0000000f1400720cULL, 0x000fc40002781470ULL, 0x0000000f4800720cULL, 0x0c0fe40001741470ULL,
0x0000000f4800720cULL, 0x080fe400037c1470ULL, 0x0000000f1d00720cULL, 0x080fe40002fa1470ULL,
0x00000029446a7812ULL, 0x000fe400078efcffULL, 0x0000000f5c00720cULL, 0x0c0fe40000f21070ULL,
0x0000000f5c00720cULL, 0x000fc40000701070ULL, 0x0000000f6200720cULL, 0x080fe40001f61070ULL,
0x0000000f6000720cULL, 0x080fe40002781070ULL, 0x0000000f4a00720cULL, 0x0c0fe40001741070ULL,
0x0000000f4a00720cULL, 0x080fe400037c1070ULL, 0x0000000f7a00720cULL, 0x000fe40002fa1070ULL,
0x000000551f537219ULL, 0x000fc400000006ffULL, 0x000000591f597219ULL, 0x040fe400000006ffULL,
0x0000005d1f5d7219ULL, 0x000fe400000006ffULL, 0x000054104d4d7816ULL, 0x000fe40000000058ULL,
0x000054104f1e7816ULL, 0x000fe2000000001eULL, 0x0000000b6a707c36ULL, 0x000fe20008000000ULL,
0xff80000035357808ULL, 0x000fe40000800000ULL, 0xff80000037377808ULL, 0x000fc40000000000ULL,
0xff80000030307808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x0000004c53ff7212ULL, 0x000fc4000782c0ffULL,
0x0000004c57ff7212ULL, 0x080fe4000780c0ffULL, 0x0000004c59ff7212ULL, 0x000fe4000786c0ffULL,
0x0000005253ff7212ULL, 0x080fe4000788c0ffULL, 0x0000005259ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004d5dff7212ULL, 0x040fe400078cc0ffULL, 0x0000001e5dff7212ULL, 0x000fe200078ac0ffULL,
0x00000001745f7824ULL, 0x100fe200078e0a5bULL, 0x0000000f5100720cULL, 0x0c0fe20000f21470ULL,
0x0000000172617824ULL, 0x100fe200078e0a5bULL, 0x0000000f5100720cULL, 0x080fe20002781470ULL,
0x00000001705b7824ULL, 0x000fe200078e0a5bULL, 0x0000000f1d00720cULL, 0x000fc40000701470ULL,
0x0000000f1900720cULL, 0x0c0fe40001f61470ULL, 0x0000000f1900720cULL, 0x080fe40001741470ULL,
0x0000000f5000720cULL, 0x0c0fe400037c1470ULL, 0x0000000f5000720cULL, 0x000fe40002fa1470ULL,
0x0000003144667812ULL, 0x040fe400078efcffULL, 0x0000003844647812ULL, 0x000fc400078efcffULL,
0x00000039445a7812ULL, 0x000fe400078efcffULL, 0x0000000f7c00720cULL, 0x0c0fe40000f21070ULL,
0x0000000f7c00720cULL, 0x080fe40002781070ULL, 0x0000000f7a00720cULL, 0x080fe40000701070ULL,
0x0000000f7800720cULL, 0x0c0fe40001f61070ULL, 0x0000000f7800720cULL, 0x000fc40001741070ULL,
0x0000000f4e00720cULL, 0x0c0fe400037c1070ULL, 0x0000000f4e00720cULL, 0x000fe40002fa1070ULL,
0x0000005f1f5f7219ULL, 0x040fe400000006ffULL, 0x000000611f617219ULL, 0x040fe400000006ffULL,
0x0000005b1f5b7219ULL, 0x000fe400000006ffULL, 0x0000541018187816ULL, 0x000fe2000000001bULL,
0x0000000b66687c36ULL, 0x000fe20008000000ULL, 0xff8000002d2d7808ULL, 0x000fe20000800000ULL,
0x0000000b64767c36ULL, 0x000fe20008000000ULL, 0xff8000002f2f7808ULL, 0x000fe20002000000ULL,
0x0000000b5a457c36ULL, 0x000fe20008000000ULL, 0xff80000028287808ULL, 0x000fc40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000016167808ULL, 0x000fe40003000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0x0000004d5fff7212ULL, 0x080fe4000782c0ffULL, 0x0000004d61ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004d5bff7212ULL, 0x000fe4000780c0ffULL, 0x0000001e5fff7212ULL, 0x080fe4000786c0ffULL,
0x0000001e61ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001e5bff7212ULL, 0x000fe400078cc0ffULL,
0x0000001865ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000168677824ULL, 0x100fe200078e0a63ULL,
0x0000000f7400720cULL, 0x080fe20000f21470ULL, 0x0000000176697824ULL, 0x100fe200078e0a63ULL,
0x0000000f7400720cULL, 0x080fe20001f61470ULL, 0x0000000145637824ULL, 0x000fe200078e0a63ULL,
0x0000000f7200720cULL, 0x000fc40002781470ULL, 0x0000000f7200720cULL, 0x080fe40001741470ULL,
0x0000000f7000720cULL, 0x0c0fe40000701470ULL, 0x0000000f7000720cULL, 0x080fe400037c1470ULL,
0x0000000f5600720cULL, 0x080fe40002fa1470ULL, 0x0000000f6e00720cULL, 0x0c0fe40000f21070ULL,
0x0000000f6e00720cULL, 0x000fc40001f61070ULL, 0x0000000f6c00720cULL, 0x0c0fe40002781070ULL,
0x0000000f6c00720cULL, 0x080fe40001741070ULL, 0x0000000f6a00720cULL, 0x0c0fe40000701070ULL,
0x0000000f6a00720cULL, 0x080fe400037c1070ULL, 0x0000000f5400720cULL, 0x000fe40002fa1070ULL,
0x000000671f677219ULL, 0x000fc400000006ffULL, 0x000000691f697219ULL, 0x040fe400000006ffULL,
0x000000631f637219ULL, 0x000fe400000006ffULL, 0x000054101c1c7816ULL, 0x000fe40000000015ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff8000003c3c7808ULL, 0x000fc40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001000000ULL,
0xff8000003d3d7808ULL, 0x000fe40000000000ULL, 0xff80000023237808ULL, 0x000fe40003000000ULL,
0xff8000003e3e7808ULL, 0x000fe40002800000ULL, 0x0000001867ff7212ULL, 0x080fe4000782c0ffULL,
0x0000001869ff7212ULL, 0x000fc4000786c0ffULL, 0x0000001863ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001c65ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001c67ff7212ULL, 0x080fe4000780c0ffULL,
0x0000001c69ff7212ULL, 0x080fe400078cc0ffULL, 0x0000001c63ff7212ULL, 0x000fe400078ac0ffULL,
0x0000000f5600720cULL, 0x000fc40001741470ULL, 0x0000000f6800720cULL, 0x0c0fe40000f21470ULL,
0x0000000f6800720cULL, 0x080fe40000701470ULL, 0x0000000f7600720cULL, 0x0c0fe40001f61470ULL,
0x0000000f7600720cULL, 0x080fe400037c1470ULL, 0x0000000f4500720cULL, 0x0c0fe40002781470ULL,
0x0000000f4500720cULL, 0x000fc40002fa1470ULL, 0x0000000f5400720cULL, 0x080fe40001741070ULL,
0x0000000f6600720cULL, 0x0c0fe40000f21070ULL, 0x0000000f6600720cULL, 0x080fe40000701070ULL,
0x0000000f6400720cULL, 0x0c0fe40001f61070ULL, 0x0000000f6400720cULL, 0x080fe400037c1070ULL,
0x0000000f5a00720cULL, 0x000fc40002781070ULL, 0x0000000f5a00720cULL, 0x000fe40002fa1070ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0xff80000040407808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fe40002000000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000022227808ULL, 0x000fc40000000000ULL, 0xff80000024247808ULL, 0x000fe40003000000ULL,
0xff80000025257808ULL, 0x000fce0002800000ULL, 0x000000171000720bULL, 0x004fe20003f1e000ULL,
0x3f80000000077882ULL, 0x000fe20000000000ULL, 0xfffffff8ff427812ULL, 0x000fe200078ee242ULL,
0x000000010b0b7836ULL, 0x000fe20000000000ULL, 0x0000001017107208ULL, 0x000fc80004000000ULL,
0x000000351000720bULL, 0x000fc80003f1e000ULL, 0x00000010350f7208ULL, 0x000fc80004000000ULL,
0x000000300f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f30107208ULL, 0x000fc80004000000ULL,
0x000000311000720bULL, 0x000fc80003f1e000ULL, 0x00000010310f7208ULL, 0x000fc80004000000ULL,
0x0000002c0f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f2c107208ULL, 0x000fc80004000000ULL,
0x0000002d1000720bULL, 0x000fc80003f1e000ULL, 0x000000102d0f7208ULL, 0x000fc80004000000ULL,
0x000000280f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f28107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x00000010290f7208ULL, 0x000fc80004000000ULL,
0x000000160f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f160f7208ULL, 0x000fc80004000000ULL,
0x000000340f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f340f7208ULL, 0x000fc80004000000ULL,
0x0000003c0f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f3c107208ULL, 0x000fe40004000000ULL,
0x000000361100720bULL, 0x000fe40003f1e000ULL, 0x0000003d1000720bULL, 0x000fc80003f3e000ULL,
0x000000103d0f7208ULL, 0x000fe40004800000ULL, 0x0000001136107208ULL, 0x000fe40004000000ULL,
0x0000003e0f00720bULL, 0x000fe40003f3e000ULL, 0x000000371000720bULL, 0x000fe40003f1e000ULL,
0x0000000f3e147208ULL, 0x000fe40004800000ULL, 0x00000010370f7208ULL, 0x000fc40004000000ULL,
0x0000003f1400720bULL, 0x000fe40003f3e000ULL, 0x000000320f00720bULL, 0x000fe40003f1e000ULL,
0x000000143f117208ULL, 0x000fe40004800000ULL, 0x0000000f32107208ULL, 0x000fe40004000000ULL,
0x000000401100720bULL, 0x000fe40003f3e000ULL, 0x000000331000720bULL, 0x000fc40003f1e000ULL,
0x0000001140147208ULL, 0x000fe40004800000ULL, 0x00000010330f7208ULL, 0x000fe40004000000ULL,
0x000000431400720bULL, 0x000fe40003f3e000ULL, 0x0000002e0f00720bULL, 0x000fe40003f1e000ULL,
0x0000001443147208ULL, 0x000fe40004800000ULL, 0x0000000f2e107208ULL, 0x000fc60004000000ULL,
0x0c401f0014117f89ULL, 0x000ea200000e0000ULL, 0x0000002f1000720bULL, 0x000fc80003f1e000ULL,
0x000000102f0f7208ULL, 0x000fc80004000000ULL, 0x0000002a0f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f2a107208ULL, 0x000fc80004000000ULL, 0x0000002b1000720bULL, 0x000fc80003f1e000ULL,
0x000000102b0f7208ULL, 0x000fe40004000000ULL, 0x000000111400720bULL, 0x004fe40003f3e000ULL,
0x000000260f00720bULL, 0x000fe40003f1e000ULL, 0x0000001411117208ULL, 0x000fe40004800000ULL,
0x0000000f26107208ULL, 0x000fc60004000000ULL, 0x0c201f0011187f89ULL, 0x000ea200000e0000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x0000001027107208ULL, 0x000fc80004000000ULL,
0x0000003b1000720bULL, 0x000fc80003f1e000ULL, 0x000000103b107208ULL, 0x000fc80004000000ULL,
0x000000231000720bULL, 0x000fc80003f1e000ULL, 0x0000001023147208ULL, 0x000fe40004000000ULL,
0x000000181100720bULL, 0x004fe40003f3e000ULL, 0x000000211400720bULL, 0x000fe40003f1e000ULL,
0x0000001118107208ULL, 0x000fe40004800000ULL, 0x00000014210f7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10157820ULL, 0x000fe20000410000ULL, 0x000000220f00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010815ULL, 0x0000000f220f7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010815ULL,
0x0000003000197308ULL, 0x0005e20000000800ULL, 0x000000240f00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010815ULL, 0x0000000f24147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010815ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x000000251400720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b3e307823ULL, 0x104fe20000010815ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010815ULL, 0x0000001425147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010815ULL,
0x0000003500187308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010815ULL,
0x0c401f00140f7f89ULL, 0x000eac00000e0000ULL, 0x00000031001a7308ULL, 0x0007700000000800ULL,
0x0000002c001b7308ULL, 0x000be20000000800ULL, 0x3fb8aa3b3f317823ULL, 0x108fe20000010815ULL,
0x3fb8aa3b43157823ULL, 0x000fcc0000010815ULL, 0x0000002d00447308ULL, 0x0006e20000000800ULL,
0x00000007ff2c7e24ULL, 0x022fe2000f8e00ffULL, 0x0000000f1400720bULL, 0x004fc80003f1e000ULL,
0x000000140f117208ULL, 0x000fe40004000000ULL, 0x3f8000002c2c783eULL, 0x000fe200000010ffULL,
0x00000016000f7308ULL, 0x0003e40000000800ULL, 0x0c201f0011147f89ULL, 0x000ea400000e0000ULL,
0x000000ffff2d7224ULL, 0x008fc800078e002cULL, 0x0000001500357308ULL, 0x000fe20000000800ULL,
0x000000191a16723eULL, 0x002fce00000010ffULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x000000141100720bULL, 0x004fc80003f1e000ULL,
0x0000001114117208ULL, 0x000fe40004000000ULL, 0x000000171814723eULL, 0x000fe200000010ffULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x0000001b4418723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b113e7820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b36367823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b37377823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001083eULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001083eULL,
0x00000028291a723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001083eULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b24247823ULL, 0x000fcc000001083eULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x000000363715723eULL, 0x002fce00000010ffULL,
0x0000003300337308ULL, 0x000e700000000800ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000323317723eULL, 0x002fce00000010ffULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x0000002c141c723cULL, 0x000fee00000418ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x0000002e2f19723eULL, 0x002fce00000010ffULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x00000008422f7824ULL, 0x000fce00078e00ffULL, 0x0000002700367308ULL, 0x0005e20000000800ULL,
0x0000002a2b1b723eULL, 0x002fce00000010ffULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21277823ULL, 0x104fe2000001083eULL, 0x3fb8aa3b253e7823ULL, 0x000fe2000001083eULL,
0x0c401f0012217f89ULL, 0x000e6200000e0000ULL, 0x0000002c1828723cULL, 0x000fe8000004181cULL,
0x0000003d003d7308ULL, 0x000ea60000000800ULL, 0x0000000f341c723eULL, 0x000fc400000010ffULL,
0x00000003ff0f7819ULL, 0x000fc60000011605ULL, 0x00000026003f7308ULL, 0x0007620000000800ULL,
0x000000030f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000003c3d1e723eULL, 0x004fca00000010ffULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x0c401f0013267f89ULL, 0x008ea200000e0000ULL,
0x000000211200720bULL, 0x002fe40003f1e000ULL, 0x0000003f361d723eULL, 0x020fc800000010ffULL,
0x0000002300327308ULL, 0x000e620000000800ULL, 0x0000001221127208ULL, 0x000fe20004000000ULL,
0x0000000842217824ULL, 0x000fcc00078e00ffULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x0000003b321f723eULL, 0x002fce00000010ffULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x000000261300720bULL, 0x004fc80003f3e000ULL, 0x0000001326137208ULL, 0x000fe20004800000ULL,
0x0000002c1c28723cULL, 0x000fe40000041828ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000272225723eULL, 0x002fce00000010ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x0000000842227836ULL, 0x000fe40000000000ULL, 0x000000010f427824ULL, 0x040fe400078e0242ULL,
0x000000010f2d7824ULL, 0x000fe400078e0222ULL, 0x0c201f00120f7f89ULL, 0x000e6200000e0000ULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x00000008222e7824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fc800078ee242ULL, 0xfffffff82e2d7812ULL, 0x000fe200078ee22dULL,
0x000000ffff2e7224ULL, 0x000fe200078e0018ULL, 0x0000002400237308ULL, 0x0007e20000000800ULL,
0x000000ffff187224ULL, 0x000fe200078e000eULL, 0x000000403526723eULL, 0x004fcc00000010ffULL,
0x0000003e003e7308ULL, 0x000ea20000000800ULL, 0x000000303124723eULL, 0x008fe200000010ffULL,
0x000000ffff307224ULL, 0x100fe400078e002cULL, 0x000000ffff317224ULL, 0x000fe400078e002cULL,
0x0000000822357824ULL, 0x000fe200078e00ffULL, 0x0000000f1200720bULL, 0x002fe20003f1e000ULL,
0x0c201f0013227f89ULL, 0x000e6200000e0000ULL, 0x00000004422c7836ULL, 0x000fe40000000000ULL,
0x0000000c42427836ULL, 0x000fe20000000000ULL, 0x000000120f127208ULL, 0x000fe20004000000ULL,
0x000000ffff327224ULL, 0x000fe200078e0024ULL, 0x0000000305ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff337224ULL, 0x000fe200078e0026ULL, 0x000000233e27723eULL, 0x004fe200000010ffULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a3a237c11ULL, 0x000fc4000f8e58ffULL,
0xfffffff835357812ULL, 0x000fc600078ee242ULL, 0x000000302428723cULL, 0x000fe20000041828ULL,
0x0001100023347836ULL, 0x000fe20000000000ULL, 0xfffffff82f237812ULL, 0x000fe200078ee22cULL,
0x000000ffff2c7224ULL, 0x000fe400078e0014ULL, 0x0000001021217824ULL, 0x000fe400078e0234ULL,
0x000000ffff2f7224ULL, 0x000fe400078e001aULL, 0x000000ffff307224ULL, 0x000fe200078e001cULL,
0x000000221300720bULL, 0x002fe20003f3e000ULL, 0x000000ffff147224ULL, 0x000fc400078e0015ULL,
0x0000001023237824ULL, 0x000fe200078e0234ULL, 0x0000001322137208ULL, 0x000fe20004800000ULL,
0x000000ffff317224ULL, 0x000fe400078e001eULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff1c7224ULL, 0x000fe400078e001dULL, 0x000000102d297824ULL, 0x000fe400078e0234ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0016ULL, 0x000000ffff167224ULL, 0x000fe400078e0019ULL,
0x000000ffff177224ULL, 0x000fe200078e001bULL, 0x0000002c21007844ULL, 0x0003e20000000200ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001fULL, 0x0000001035357824ULL, 0x000fe200078e0234ULL,
0x0000003023007844ULL, 0x0003e20000000200ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0027ULL, 0x0000001429007844ULL, 0x0003e20000000200ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0028ULL, 0x000000ffff1b7224ULL, 0x000fe200078e002aULL,
0x0000001c35007844ULL, 0x0003e80000000200ULL, 0x0170001020008388ULL, 0x0003e80000000c00ULL,
0x0172001a20008388ULL, 0x0003e20000000a00ULL, 0x0000000d0b00720cULL, 0x000fe20003f06070ULL,
0x0176080f0aff79a7ULL, 0x0003e2000850003fULL, 0x0176100f0aff79a7ULL, 0x0003e2000850003fULL,
0x0176180f0aff79a7ULL, 0x0003e2000850003fULL, 0x0176200f0aff79a7ULL, 0x0003f2000850003fULL,
0xffffffa400f08947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000050007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000005000008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff50ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000050027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005000007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffeac02d07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x000000000000057fULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000700ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000958ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a38ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a8cULL,
0x0000000000000660ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001138ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000015180ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016300ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016350ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000016350ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x0000000000016940ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000016940ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001138ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015180ULL, 0x0000000000015180ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000016350ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_90_cubin_len = 92816;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
