/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001a7b0ULL, 0x000000000001a430ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL,
0x2400000000000000ULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b00010000020cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000299ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b000100000383ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000003d1ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000042cULL, 0x0000000000018d90ULL,
0x0000000000000270ULL, 0x00040003000004a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000019000ULL, 0x000d0003000004d2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00018d9000000000ULL,
0x0001080400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x00018d9000000000ULL, 0x0000027000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000bdULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000d000dc2804ULL, 0x0000096000000250ULL,
0x00002b8000002b10ULL, 0x00002d9000002c60ULL, 0x0000300000002ec0ULL, 0x000035a000003590ULL,
0x000035c0000035b0ULL, 0x00005b9000005b30ULL, 0x00005dd000005ca0ULL, 0x0000604000005f00ULL,
0x000064e0000064d0ULL, 0x00006500000064f0ULL, 0x00008a00000089a0ULL, 0x00008c4000008b10ULL,
0x00008eb000008d70ULL, 0x000092f0000092e0ULL, 0x0000931000009300ULL, 0x0000b8100000b7a0ULL,
0x0000ba300000b900ULL, 0x0000bca00000bb60ULL, 0x0000c1b00000c1a0ULL, 0x0000c1d00000c1c0ULL,
0x0000dc400000dc30ULL, 0x0000dc600000dc50ULL, 0x000175c000017510ULL, 0x000179b0000178a0ULL,
0x00017e9000017da0ULL, 0x0001824000018150ULL, 0x0000047004303904ULL, 0x0001a600000000ffULL,
0x0000055000040100ULL, 0x0001a60800000000ULL, 0x00000660003f0100ULL, 0x0001a68800000000ULL,
0x00000790003f0100ULL, 0x0001a6a800000005ULL, 0x000008a0003f0100ULL, 0x0001a6c800000004ULL,
0x00000fe0003f0100ULL, 0x0001a60000000009ULL, 0x00001160003f0107ULL, 0x0001a68800000000ULL,
0x00001b00003f0101ULL, 0x00000000000000ffULL, 0x00001b8000040107ULL, 0x00000000000000ffULL,
0x00001c0000040101ULL, 0x0000002000000003ULL, 0x00001d60003f0101ULL, 0x0001a6c800000041ULL,
0x00001ee0003f0109ULL, 0x0001a6c800000041ULL, 0x000027c0003f0109ULL, 0x0001a6b000000042ULL,
0x00002880003f0107ULL, 0x0001a6b000000042ULL, 0x00002890003f0101ULL, 0x0001a60800000080ULL,
0x000028b0003f0101ULL, 0x0001a60800000080ULL, 0x00002a20003f0109ULL, 0x0001a60800000080ULL,
0x00003190003f0109ULL, 0x0001a6a800000042ULL, 0x00003320003f0109ULL, 0x0001a6a800000042ULL,
0x00004ef0003f0109ULL, 0x0001a6c80000003cULL, 0x00004f10003f0101ULL, 0x0001a6880000007cULL,
0x00004f90003f0101ULL, 0x0000000000000006ULL, 0x00005100003f0109ULL, 0x0000000000000006ULL,
0x000058b0003f0109ULL, 0x00000000000000ffULL, 0x000058f000050107ULL, 0x00000000000000ffULL,
0x0000590000050101ULL, 0x0001a62800000080ULL, 0x00005920003f0101ULL, 0x0001a62800000080ULL,
0x00005a90003f0109ULL, 0x0001a62800000080ULL, 0x00006220003f0109ULL, 0x0001a6b00000003fULL,
0x00006390003f0109ULL, 0x0001a6b00000003fULL, 0x00007d20003f0109ULL, 0x0001a6c80000003cULL,
0x00007d50003f0101ULL, 0x0001a6900000003eULL, 0x00007da0003f0101ULL, 0x0000000000000006ULL,
0x00007f10003f0109ULL, 0x0000000000000006ULL, 0x000086a0003f0109ULL, 0x00000008000000ffULL,
0x0000876000040107ULL, 0x0000000800000086ULL, 0x00008770003f0101ULL, 0x0001a64800000080ULL,
0x00008790003f0101ULL, 0x0001a64800000080ULL, 0x00008900003f0109ULL, 0x0001a64800000080ULL,
0x00009060003f0109ULL, 0x00000000000000ffULL, 0x000091d000050109ULL, 0x00000000000000ffULL,
0x0000ab2000050109ULL, 0x0000000000000006ULL, 0x0000ab50003f0101ULL, 0x0001a6980000003eULL,
0x0000abb0003f0101ULL, 0x0000000000000006ULL, 0x0000ad20003f0109ULL, 0x0000000000000006ULL,
0x0000b510003f0109ULL, 0x00000000000000ffULL, 0x0000b55000040107ULL, 0x00000000000000ffULL,
0x0000b56000050101ULL, 0x0001a66800000008ULL, 0x0000b590003f0101ULL, 0x0001a66800000008ULL,
0x0000b700003f0109ULL, 0x0001a66800000008ULL, 0x0000be70003f0109ULL, 0x0001a6b00000003fULL,
0x0000bfe0003f0109ULL, 0x0001a6b00000003fULL, 0x0000da40003f0109ULL, 0x0000000000000006ULL,
0x0000da80003f0101ULL, 0x0001a6a000000006ULL, 0x0000f750003f0101ULL, 0x0001a60000000009ULL,
0x000110e0003f0101ULL, 0x0001a60000000009ULL, 0x00011250003f0109ULL, 0x0001a60000000009ULL,
0x000115a0003f0109ULL, 0x0001a60000000009ULL, 0x000115c0003f0101ULL, 0x0001a60000000009ULL,
0x00011730003f0109ULL, 0x0001a60000000009ULL, 0x00014dc0003f0109ULL, 0x0001a68800000006ULL,
0x000151c0003f0101ULL, 0x0001a68800000006ULL, 0x00015330003f0109ULL, 0x0001a68800000006ULL,
0x00018d30003f0109ULL, 0x0001a6080000005fULL, 0x00018d40003f0101ULL, 0x0001a6100000005fULL,
0x00018d50003f0101ULL, 0x0001a6180000005fULL, 0x00018d60003f0101ULL, 0x0001a6200000005fULL,
0x00053803003f0101ULL, 0x0000eb8000301c04ULL, 0x0000ed900000ebe0ULL, 0x0000f0500000eef0ULL,
0x0000f3100000f1b0ULL, 0x0000f6000000f470ULL, 0x000117600000f700ULL, 0x000c050400018d80ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001600080a04ULL,
0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001500000002ULL, 0x0000000000018d90ULL,
0x0000000000000044ULL, 0x0000001500000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001500000002ULL, 0x0000000000000000ULL, 0x000000000001a700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000117919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000000a7919ULL, 0x000eea0000002200ULL, 0x00000400ff067b82ULL, 0x000f220000000800ULL,
0x0000000000097919ULL, 0x000f620000002100ULL, 0x0000010000047ab9ULL, 0x000fcc0000000800ULL,
0x00008600ff0e7b82ULL, 0x000ee20000000800ULL, 0x0000000300007306ULL, 0x004ea20000209000ULL,
0x000000ff0300720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x00000005ff787819ULL, 0x022fcc0000011609ULL, 0x00001fff78787589ULL, 0x000e6200000e0000ULL,
0x0ffffffe00047836ULL, 0x004fc80000000000ULL, 0x0000000400057305ULL, 0x000564000021f000ULL,
0x000000ffff047224ULL, 0x004fe400078e00ffULL, 0x000000ffff087224ULL, 0x020fc800078e0a05ULL,
0x0000000308077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000ea40000002600ULL,
0x0000000705057227ULL, 0x000fcc00078e0004ULL, 0x0000000605777227ULL, 0x010fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a77ULL, 0x0000000503007224ULL, 0x000fca00078e0206ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a03ULL,
0x0000000177770836ULL, 0x000fc60000000000ULL, 0x000000030000720cULL, 0x000fda0003f26070ULL,
0x0000000177771836ULL, 0x000fe20000000000ULL, 0x00000003ff77a212ULL, 0x000fc800078e33ffULL,
0x0000007700007306ULL, 0x000f220000209000ULL, 0x000000ff7700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00047836ULL, 0x010fe40000000000ULL,
0x0000000411007c24ULL, 0x008fe2000f8e020aULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x000722000021f000ULL, 0x00001fff11117589ULL, 0x000e6200000e0000ULL,
0x000000ffff047224ULL, 0x008fe400078e00ffULL, 0x0000000577067224ULL, 0x010fc800078e02ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x0000000705057227ULL, 0x000fe400078e0004ULL,
0x0000000000077919ULL, 0x000e640000002700ULL, 0x0000000400047c24ULL, 0x000fe4000f8e0209ULL,
0x0000000805597227ULL, 0x004fc600078e00ffULL, 0x0000007f0400780cULL, 0x040fe20003f64070ULL,
0x000000ffff057224ULL, 0x000fe200078e0a59ULL, 0x000000030400780cULL, 0x000fc60003f84070ULL,
0x0000000577007224ULL, 0x000fca00078e0208ULL, 0x000000770000720cULL, 0x000fc60003f06070ULL,
0x000000000006b919ULL, 0x000ea20000008800ULL, 0x000004000005b802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a77ULL, 0x0000000159590836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000770000720cULL, 0x000fda0003f26070ULL,
0x0000000159591836ULL, 0x000fe20000000000ULL, 0x00000077ff59a212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x000fe40003f24070ULL, 0x000006540605b816ULL, 0x004fe20000000005ULL,
0x000000ffff007224ULL, 0x000fe200078e0a59ULL, 0x000000010400780cULL, 0x000fe20003f44070ULL,
0xff317217ff06b424ULL, 0x000fe400078e00ffULL, 0x0000000077777224ULL, 0x000fc400078e0208ULL,
0x000000040405b824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x002fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400060500b388ULL, 0x0003e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000002077007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a6a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x0000000e02057219ULL, 0x002fe200000006ffULL,
0x0000000207027224ULL, 0x000fe200078e02ffULL, 0x0000000e030b7219ULL, 0x000fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000500720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002005757446ULL, 0x000fe20003800004ULL,
0x0000000411047824ULL, 0x000fe200078e0278ULL, 0x0000000e59767219ULL, 0x000fc400000006ffULL,
0x000000ff75757207ULL, 0x000fe20000000000ULL, 0x0000000404047824ULL, 0x000fe400078e00ffULL,
0x0000000b02027224ULL, 0x000fe200078e0276ULL, 0x000000207500780cULL, 0x000fda0003f05270ULL,
0x0000000000c48947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x0000000475057248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ea40000008800ULL,
0x0000000e09087219ULL, 0x000fe200000006ffULL, 0x0000000105057824ULL, 0x000fe200078e0a04ULL,
0x0000040000097802ULL, 0x000fe40000000f00ULL, 0x00000004ff067819ULL, 0x002fc8000001160aULL,
0x000000050600720cULL, 0x080fe20003f06070ULL, 0x00000002060c7836ULL, 0x000fe20000000000ULL,
0x0000065410097816ULL, 0x004fe20000000009ULL, 0x0000000104137824ULL, 0x040fe400078e0206ULL,
0x0000000104157824ULL, 0x000fe200078e020cULL, 0x000000050c00720cULL, 0x000fe20003f26070ULL,
0x00000001000d7824ULL, 0x040fe400078e0213ULL, 0x0000000100177824ULL, 0x000fe400078e0215ULL,
0x0000000115067824ULL, 0x000fe200078e020aULL, 0x000000080d0f7212ULL, 0x080fe200078e30ffULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0x0000000817197212ULL, 0x000fc400078e30ffULL,
0x0000000eff047219ULL, 0x080fe2000001160dULL, 0x00000001020f7824ULL, 0x040fe200078e020fULL,
0x0000000eff087219ULL, 0x000fe20000011617ULL, 0x0000000102197824ULL, 0x000fe200078e0219ULL,
0xfffffff015067812ULL, 0x000fe200078ee206ULL, 0x0000000b040c7224ULL, 0x080fe400078e020fULL,
0x000000100a047824ULL, 0x000fe400078e00ffULL, 0x0000000b08087224ULL, 0x000fe400078e0219ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000f004057812ULL, 0x000fc600078ec0ffULL,
0x00000100080e7825ULL, 0x000fe200078e00ffULL, 0x000000050c0c7212ULL, 0x000fc600078efcffULL,
0x0000000113027824ULL, 0x040fe200078e020aULL, 0x000000050e057212ULL, 0x000fe200078efcffULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0x000000040c0c7c10ULL, 0x000fe4000ff5e0ffULL,
0x00000004050e7c10ULL, 0x000fe4000ff7e0ffULL, 0xfffffff013027812ULL, 0x000fe200078ee202ULL,
0x0000001006137824ULL, 0x100fe200078e0209ULL, 0x000000050d0d7c10ULL, 0x000fe400097fe4ffULL,
0x000000050f0f7c10ULL, 0x000fe20009ffe4ffULL, 0x0000001002057824ULL, 0x000fca00078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c057faeULL, 0x0003e8000c101c46ULL,
0x000000000e137faeULL, 0x0003e2000c901c46ULL, 0x0000000000a87947ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000e620000000000ULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x00000400000c7802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000000000f7919ULL, 0x000ea40000008800ULL, 0x0000000e090d7219ULL, 0x000fe400000006ffULL,
0x000000040a057211ULL, 0x002fca00078fe0ffULL, 0x0000000205137836ULL, 0x000fe40000000000ULL,
0x0000000100047824ULL, 0x040fe400078e0205ULL, 0x0000000100087824ULL, 0x000fe400078e0213ULL,
0x0000001005177824ULL, 0x000fe200078e00ffULL, 0x0000000d04097212ULL, 0x080fe400078e30ffULL,
0x0000000d080d7212ULL, 0x000fe400078e30ffULL, 0x0000000eff047219ULL, 0x080fe20000011604ULL,
0x0000000102067824ULL, 0x040fe200078e0209ULL, 0x0000000eff087219ULL, 0x000fe20000011608ULL,
0x00000001020d7824ULL, 0x000fe200078e020dULL, 0x000006540f097816ULL, 0x004fe2000000000cULL,
0x0000000b04067224ULL, 0x000fc400078e0206ULL, 0x000000100a047824ULL, 0x000fe400078e00ffULL,
0x0000000b08087224ULL, 0x000fe400078e020dULL, 0x00000100060c7825ULL, 0x000fe200078e00ffULL,
0x000000f004157812ULL, 0x000fc600078ec0ffULL, 0x00000100080e7825ULL, 0x000fe200078e00ffULL,
0x000000150c0c7212ULL, 0x000fc600078efcffULL, 0x0000000105027824ULL, 0x100fe200078e020aULL,
0x000000150e0e7212ULL, 0x000fe200078efcffULL, 0x0000000113057824ULL, 0x040fe200078e020aULL,
0x000000040c0c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001013067824ULL, 0x000fe200078e00ffULL,
0xfffffff017027812ULL, 0x000fe400078ee202ULL, 0x000000040e0e7c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff006067812ULL, 0x000fe200078ee205ULL, 0x0000001002057824ULL, 0x000fe200078e0209ULL,
0x000000050d0d7c10ULL, 0x000fc400087fe4ffULL, 0x000000050f0f7c10ULL, 0x000fe20008ffe4ffULL,
0x0000001006137824ULL, 0x000fe400078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c057faeULL, 0x0003e8000b901c46ULL, 0x000000000e137faeULL, 0x0003e4000b901c46ULL,
0x00000000090472caULL, 0x000fe200000e0000ULL, 0x00009200ff0c7b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001a60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x00000004070c7825ULL, 0x002fe200078e000cULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x000000060c747981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1100720cULL, 0x000fe20003f05270ULL,
0x0000007f746f7836ULL, 0x004fe40000000000ULL, 0x000000ff74057836ULL, 0x000fc60000000000ULL,
0x00000007ff6f7819ULL, 0x000fe4000001166fULL, 0x00000008ff6b7819ULL, 0x000fca0000011605ULL,
0x000000e400988947ULL, 0x000fea0003800000ULL, 0x00000003ff6a7819ULL, 0x000fe20000011678ULL,
0xffffffffff827424ULL, 0x000fe400078e00ffULL, 0x00000004ff117424ULL, 0x000fe200078e00ffULL,
0x01ffffff6a6a7812ULL, 0x000fc800078ec0ffULL, 0x0000006f6a00720cULL, 0x000fda0003f06070ULL,
0x00009400ff0f8b82ULL, 0x000e620000000800ULL, 0x0000000207008824ULL, 0x000fce00078e00ffULL,
0x00009000ff0c8b82ULL, 0x000ea20000000a00ULL, 0x0000000f000f8224ULL, 0x002fe400078e020fULL,
0x0000000878007824ULL, 0x000fe400078e0209ULL, 0x000000016a0f8824ULL, 0x000fe400078e020fULL,
0x01a6881100ff79a7ULL, 0x0003e4000850003fULL, 0x000000040f0c8825ULL, 0x004fca00078e000cULL,
0x000000060c828981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x0000008059597824ULL, 0x000fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe40000011678ULL,
0x0000000178057812ULL, 0x000fc600078ec0ffULL, 0x000000206e5b7824ULL, 0x000fe200078e00ffULL,
0x00008e00ff0e7b82ULL, 0x000ee80000000a00ULL, 0x0000006059007812ULL, 0x002fe200078ef85bULL,
0x0000000382037224ULL, 0x004fc800078e02ffULL, 0x0000008003037824ULL, 0x000fc800078e00ffULL,
0x0000008003027825ULL, 0x008fe200078e000eULL, 0x0000000000fc0947ULL, 0x000fec0003800000ULL,
0x0000005b74067248ULL, 0x000fe20007fe0000ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fc6000001160aULL, 0x0000000106067824ULL, 0x000fe400078e0a5bULL,
0x00000001050d7824ULL, 0x000fe400078e0208ULL, 0x00000004080e7836ULL, 0x000fe20000000000ULL,
0x0000000506067248ULL, 0x000fe20007fe0000ULL, 0x000000010d0c7824ULL, 0x040fe400078e020aULL,
0x000000080d0f7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fc400078e0a05ULL,
0x00000001000d7824ULL, 0x000fe200078e020dULL, 0xfffffff80f147812ULL, 0x000fe200078ee20cULL,
0x00000008080c7836ULL, 0x000fe20000000000ULL, 0x000000060e00720cULL, 0x080fe20003f46070ULL,
0x00000001050f7824ULL, 0x000fe200078e020eULL, 0x000000060800720cULL, 0x080fe20003f66070ULL,
0x0000000c080e7836ULL, 0x000fe20000000000ULL, 0x000000060c00720cULL, 0x080fe20003f26070ULL,
0x000000010f087824ULL, 0x040fe400078e020aULL, 0x000000080f157824ULL, 0x000fe200078e00ffULL,
0x000000060e00720cULL, 0x000fe20003f06070ULL, 0x0000000105117824ULL, 0x000fc400078e020cULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff815087812ULL, 0x000fc600078ee208ULL,
0x0000000105137824ULL, 0x000fe200078e020eULL, 0x000000700c157812ULL, 0x000fe200078ef804ULL,
0x00000001000f7824ULL, 0x040fe400078e020fULL, 0x0000000100107824ULL, 0x040fe200078e0213ULL,
0x0000001502127210ULL, 0x000fe20007f9e0ffULL, 0x00000001130c7824ULL, 0x040fe400078e020aULL,
0x0000000813137824ULL, 0x000fe400078e00ffULL, 0x00000001000e7824ULL, 0x000fc400078e0211ULL,
0x0000000111057824ULL, 0x000fe200078e020aULL, 0xfffffff813167812ULL, 0x000fe200078ee20cULL,
0x0000000103137824ULL, 0x000fe400020e060dULL, 0x000000800f0c7825ULL, 0x000fc800078e00ffULL,
0x0000000811067824ULL, 0x000fe200078e00ffULL, 0x000000700c1f7812ULL, 0x000fe200078ef804ULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff806067812ULL, 0x000fe200078ee205ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000700e1d7812ULL, 0x000fc600078ef804ULL,
0x000020006e007824ULL, 0x000fe200078e0209ULL, 0x00000070101b7812ULL, 0x000fe400078ef804ULL,
0x0000001f02047210ULL, 0x000fe20007f9e0ffULL, 0x0001600000057836ULL, 0x000fe20000000000ULL,
0x0000001d020c7210ULL, 0x000fe40007fbe0ffULL, 0x0000001b02027210ULL, 0x000fe20007fde0ffULL,
0x0000001014157824ULL, 0x100fe400078e0205ULL, 0x0000001008177824ULL, 0x000fc400078e0205ULL,
0x0000001006197824ULL, 0x100fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000d901c46ULL, 0x00000010161b7824ULL, 0x000fe400078e0205ULL,
0x0000000103057824ULL, 0x040fe400020e060dULL, 0x00000001030d7824ULL, 0x040fe400028e060fULL,
0x0000000103037824ULL, 0x000fe200030e0611ULL, 0x0000000004177faeULL, 0x0003e8000d101c46ULL,
0x000000000c197faeULL, 0x0003e8000c901c46ULL, 0x00000000021b7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x0000001005057824ULL, 0x000fca00078e00ffULL,
0x000000050a057211ULL, 0x000fca00078fe8ffULL, 0x00000004050f7836ULL, 0x000fe40000000000ULL,
0x0000000105067824ULL, 0x140fe400078e020aULL, 0x00000008050d7824ULL, 0x000fe400078e00ffULL,
0x00000001000c7824ULL, 0x000fe400078e0205ULL, 0x000000010f087824ULL, 0x040fe200078e020aULL,
0xfffffff80d067812ULL, 0x000fe200078ee206ULL, 0x000000080f117824ULL, 0x000fc400078e00ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff811087812ULL, 0x000fe200078ee208ULL,
0x0000000805117836ULL, 0x000fe20000000000ULL, 0x000000700c137812ULL, 0x000fe200078ef804ULL,
0x0000000c05057836ULL, 0x000fe40000000000ULL, 0x00000001000f7824ULL, 0x040fe200078e020fULL,
0x0000001302127210ULL, 0x000fe20007f1e0ffULL, 0x0000000100107824ULL, 0x000fe400078e0205ULL,
0x00000001050c7824ULL, 0x040fe400078e020aULL, 0x0000000805057824ULL, 0x000fc400078e00ffULL,
0x00000001000e7824ULL, 0x000fe400078e0211ULL, 0x0000000111007824ULL, 0x040fe200078e020aULL,
0xfffffff805057812ULL, 0x000fe200078ee20cULL, 0x0000000811157824ULL, 0x000fe400078e00ffULL,
0x000020006e117824ULL, 0x000fe400078e0209ULL, 0x0000000103137824ULL, 0x000fe200000e060dULL,
0xfffffff815007812ULL, 0x000fe200078ee200ULL, 0x000000800f0c7825ULL, 0x000fc800078e00ffULL,
0x0001600011217836ULL, 0x000fe20000000000ULL, 0x000000700c1f7812ULL, 0x000fe200078ef804ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e1d7812ULL, 0x000fc600078ef804ULL, 0x0000001006157824ULL, 0x100fe200078e0221ULL,
0x00000070101b7812ULL, 0x000fe200078ef804ULL, 0x0000001008177824ULL, 0x100fe200078e0221ULL,
0x0000001f02047210ULL, 0x000fe20007f1e0ffULL, 0x0000001000197824ULL, 0x100fe200078e0221ULL,
0x0000001d020c7210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000b901c46ULL, 0x0000001b02027210ULL, 0x000fe20007f5e0ffULL,
0x00000010051b7824ULL, 0x000fe400078e0221ULL, 0x0000000103057824ULL, 0x000fc400000e060dULL,
0x00000001030d7824ULL, 0x040fe400008e060fULL, 0x0000000103037824ULL, 0x000fe200010e0611ULL,
0x0000000004177faeULL, 0x0003e8000b901c46ULL, 0x000000000c197faeULL, 0x0003e8000b901c46ULL,
0x00000000021b7faeULL, 0x0003e4000b901c46ULL, 0x0001a6a809037836ULL, 0x002fe20000000000ULL,
0x000000006e0472caULL, 0x000fe200000e0000ULL, 0x00000001ff027424ULL, 0x000fe200078e00ffULL,
0x000000ff6b00720cULL, 0x000fe20003f05270ULL, 0x000000ffff837224ULL, 0x000fe200078e00ffULL,
0x00000000030572caULL, 0x000fe400000e0000ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000ffff317224ULL, 0x000fe400078e00ffULL,
0x000000086e037824ULL, 0x000fe200078e0203ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000002ff7a79a7ULL, 0x0002a20008500004ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00002002030279a7ULL, 0x002e62000850003fULL, 0x0000000000567805ULL, 0x000fc4000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x000000bc00a08947ULL, 0x000fec0003800000ULL,
0x00009400ff047b82ULL, 0x000ee20000000800ULL, 0x00000002ff5a7819ULL, 0x000fe20000011678ULL,
0x0000000878027824ULL, 0x002fe200078e00ffULL, 0x000000016e007812ULL, 0x000fe200078ec0ffULL,
0x0000000207077824ULL, 0x000fe400078e00ffULL, 0x000000205a057824ULL, 0x000fe200078e0209ULL,
0x0000000802027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff407224ULL, 0x000fe400078e0003ULL,
0x0000001000057824ULL, 0x000fc400078e0205ULL, 0xff317217ff7e7424ULL, 0x000fe400078e00ffULL,
0x0000000102087824ULL, 0x000fe400078e0205ULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x0000000407077224ULL, 0x008fce00078e0204ULL,
0x00000000003c7805ULL, 0x010fce0000015200ULL, 0x0000000478067824ULL, 0x000fca00078e00ffULL,
0xfffffff806067812ULL, 0x000fca00078ec0ffULL, 0x0000000109417824ULL, 0x000fc800078e0206ULL,
0x01a6c840410075a7ULL, 0x000e62000800017fULL, 0x0001a6c841067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff427224ULL, 0x000fce00078e00ffULL,
0x000000104200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000142427836ULL, 0x000fce0000000000ULL,
0x01a6c840410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff3c7b82ULL, 0x000e620000000a00ULL, 0x00000010783e7824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x0000000158407836ULL, 0x000fe40000000000ULL,
0x0000000582827c24ULL, 0x000fe2000f8e02ffULL, 0xffffffe03e3f7812ULL, 0x000fe400078ec0ffULL,
0x0000006b4000720cULL, 0x000fc60003f26070ULL, 0x00000100583f7824ULL, 0x000fc800078e023fULL,
0x000000403f417836ULL, 0x000fe40000000000ULL, 0x00000080823f7824ULL, 0x000fc600078e00ffULL,
0x0000006041407812ULL, 0x000fe200078ec0ffULL, 0x000000803f3c7825ULL, 0x002fc800078e003cULL,
0x0000000159447824ULL, 0x000fe200078e0240ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x000000103e3f7812ULL, 0x000fe200078ec0ffULL, 0x000000100a5c7824ULL, 0x000fe200078e00ffULL,
0x00000041743e7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff427819ULL, 0x100fe4000001160aULL,
0x000000705c617812ULL, 0x000fe200078ec0ffULL, 0x000000013e3e7824ULL, 0x000fe400078e0a41ULL,
0x0000000142417824ULL, 0x000fe400078e023fULL, 0x0000000842457836ULL, 0x000fe20000000000ULL,
0x0000003f3e3e7248ULL, 0x000fe20007fe0000ULL, 0x0000000141407824ULL, 0x000fc400078e020aULL,
0x0000000841437824ULL, 0x000fe400078e00ffULL, 0x000000013e3e7824ULL, 0x000fc600078e0a3fULL,
0xfffffff843467812ULL, 0x000fe200078ee240ULL, 0x0000000442437836ULL, 0x000fe20000000000ULL,
0x0000003e4200720cULL, 0x080fe20003f86070ULL, 0x0000000c42427836ULL, 0x000fe20000000000ULL,
0x0000003e4500720cULL, 0x0c0fe20003f46070ULL, 0x0000000145457824ULL, 0x100fe200078e023fULL,
0x0000003e4300720cULL, 0x0c0fe20003f66070ULL, 0x0000000143437824ULL, 0x100fe200078e023fULL,
0x0000003e4200720cULL, 0x040fe20003f06070ULL, 0x0000000142477824ULL, 0x000fe400078e023fULL,
0x0000000144407824ULL, 0x000fc400078e0243ULL, 0x0000000143427824ULL, 0x140fe400078e020aULL,
0x00000008435f7824ULL, 0x000fe400078e00ffULL, 0x00000001443e7824ULL, 0x040fe400078e0241ULL,
0x0000000144437824ULL, 0x040fe200078e0245ULL, 0xfffffff85f5c7812ULL, 0x000fe200078ee242ULL,
0x00000001445d7824ULL, 0x000fe400078e0247ULL, 0x0000000145447824ULL, 0x000fc400078e020aULL,
0x0000000845637824ULL, 0x000fe400078e00ffULL, 0x0000000147457824ULL, 0x040fe400078e020aULL,
0x0000000847607824ULL, 0x000fe200078e00ffULL, 0xfffffff8635e7812ULL, 0x000fe200078ee244ULL,
0x0000008040407825ULL, 0x000fc600078e00ffULL, 0xfffffff860607812ULL, 0x000fe200078ee245ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000006140457212ULL, 0x000fc600078efcffULL,
0x0000008043427825ULL, 0x000fe200078e00ffULL, 0x000000613e477212ULL, 0x080fe400078efcffULL,
0x000000453c407210ULL, 0x000fe20007fde0ffULL, 0x000000805d447825ULL, 0x000fe200078e00ffULL,
0x000000473c3e7210ULL, 0x000fe40007fbe0ffULL, 0x0000006142637212ULL, 0x080fe200078efcffULL,
0x000020006e5f7824ULL, 0x000fe200078e0209ULL, 0x0000006144617212ULL, 0x000fe200078efcffULL,
0x000000013d3f7824ULL, 0x000fe200028e063fULL, 0x000000633c427210ULL, 0x000fe20007fbe0ffULL,
0x000170005f477836ULL, 0x000fc40000000000ULL, 0x000000013d417824ULL, 0x040fe200030e0641ULL,
0x000000613c3c7210ULL, 0x000fe20007fde0ffULL, 0x00000010465d7824ULL, 0x100fe400078e0247ULL,
0x000000105c5f7824ULL, 0x100fe400078e0247ULL, 0x000000105e617824ULL, 0x000fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e5d7faeULL, 0x0003e2000e101c46ULL,
0x000000013d437824ULL, 0x040fe400028e0643ULL, 0x0000001060477824ULL, 0x000fe200078e0247ULL,
0x00000000405f7faeULL, 0x0003e2000d901c46ULL, 0x000000013d3d7824ULL, 0x000fc600030e0645ULL,
0x0000000042617faeULL, 0x0003e8000d101c46ULL, 0x000000003c477faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x000000103e3f7812ULL, 0x000fe200078ec0ffULL,
0x000000100a427824ULL, 0x000fc600078e00ffULL, 0x0000003f0a3f7211ULL, 0x000fe400078fe8ffULL,
0x0000007042617812ULL, 0x000fc600078ec0ffULL, 0x000000043f417836ULL, 0x000fe40000000000ULL,
0x000000013f3e7824ULL, 0x140fe400078e020aULL, 0x000000083f437824ULL, 0x000fe400078e00ffULL,
0x0000000141407824ULL, 0x040fe400078e020aULL, 0x0000000841457824ULL, 0x000fe200078e00ffULL,
0xfffffff843467812ULL, 0x000fe200078ee23eULL, 0x00000001443e7824ULL, 0x000fc400078e023fULL,
0x000000083f437836ULL, 0x000fe20000000000ULL, 0xfffffff8455c7812ULL, 0x000fe200078ee240ULL,
0x0000000c3f457836ULL, 0x000fe40000000000ULL, 0x000000803e3e7825ULL, 0x000fc800078e00ffULL,
0x0000000144427824ULL, 0x000fe200078e0243ULL, 0x000000613e477212ULL, 0x000fe200078efcffULL,
0x0000000143407824ULL, 0x140fe400078e020aULL, 0x00000008435d7824ULL, 0x000fe200078e00ffULL,
0x000000473c3e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000144417824ULL, 0x000fe400078e0241ULL,
0x0000000145437824ULL, 0x040fe200078e020aULL, 0xfffffff85d5e7812ULL, 0x000fe200078ee240ULL,
0x0000000845607824ULL, 0x000fc400078e00ffULL, 0x0000000144447824ULL, 0x000fe400078e0245ULL,
0x000020006e457824ULL, 0x000fe200078e0209ULL, 0xfffffff860607812ULL, 0x000fe200078ee243ULL,
0x0000008041407825ULL, 0x000fc800078e00ffULL, 0x0001700045677836ULL, 0x000fe20000000000ULL,
0x0000006140657212ULL, 0x000fe200078efcffULL, 0x0000008042427825ULL, 0x000fc800078e00ffULL,
0x0000008044447825ULL, 0x000fe200078e00ffULL, 0x0000006142637212ULL, 0x000fc600078efcffULL,
0x000000013d3f7824ULL, 0x040fe200000e063fULL, 0x0000006144617212ULL, 0x000fe200078efcffULL,
0x0000001046477824ULL, 0x100fe200078e0267ULL, 0x000000653c407210ULL, 0x000fe20007f1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e0267ULL, 0x000000633c427210ULL, 0x000fe20007f5e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e0267ULL, 0x000000613c3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000013d417824ULL, 0x040fe200000e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e2000b901c46ULL, 0x000000013d437824ULL, 0x000fc400010e0643ULL,
0x0000001060617824ULL, 0x000fe200078e0267ULL, 0x00000000405d7faeULL, 0x0003e2000b901c46ULL,
0x000000013d3d7824ULL, 0x000fc600018e0645ULL, 0x00000000425f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c617faeULL, 0x0003e4000b901c46ULL, 0x000000016a3e7836ULL, 0x002fe40000000000ULL,
0xffffffffff7a7424ULL, 0x004fc600078e00ffULL, 0x0000006f3e00720cULL, 0x000fe20003f06070ULL,
0x0000000878407824ULL, 0x000fd800078e00ffULL, 0x00000001073f8824ULL, 0x000fe200078e023eULL,
0xfffffff0403e7812ULL, 0x000fe200078ec0ffULL, 0x00009000ff3c8b82ULL, 0x000e680000000a00ULL,
0x0000000109427824ULL, 0x000fca00078e023eULL, 0x00000000420572caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0001a6b005057890ULL, 0x000fe2000fffe03fULL,
0x000000043f3c8825ULL, 0x002fca00078e003cULL, 0x000000063c7a8981ULL, 0x000322000c1e1900ULL,
0xffffffe0403e7812ULL, 0x040fe200078ec0ffULL, 0x00000001ff417424ULL, 0x000fe200078e00ffULL,
0x00000010403f7812ULL, 0x040fe200078ec0ffULL, 0x00000000ff0079b0ULL, 0x000fe60008000a45ULL,
0x000000093f3e7210ULL, 0x000fe40007ffe03eULL, 0x00000008403f7812ULL, 0x000fca00078ec0ffULL,
0x000000013e807824ULL, 0x000fe200078e023fULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x01a6b041428679a7ULL, 0x0002a4000850003fULL, 0x01a60841804079a7ULL, 0x0022e4000850003fULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x01a60841800075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x000000104400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000144447836ULL, 0x000fce0000000000ULL,
0x01a60841800075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000100a6c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff6d7819ULL, 0x000fe2000001160aULL,
0x00000020783c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x000000706c6c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff857224ULL, 0x000fe200078e007eULL,
0xffffff803c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c6d6d7812ULL, 0x000fe400078ec0ffULL,
0x000000096c3c7210ULL, 0x000fca0007ffe03cULL, 0x000000013c3c7824ULL, 0x000fca00078e026dULL,
0x01a000003c3d7984ULL, 0x000ee80000000800ULL, 0x01a200003c3e7984ULL, 0x000b620000000800ULL,
0x0000007e3d00720bULL, 0x008fda0003f1d000ULL, 0x00000000003f7806ULL, 0x000fc800000e0100ULL,
0x000000ff3f00720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x026fea0003800000ULL,
0x000000785a00720cULL, 0x000fe40003f45270ULL, 0x0000007e3d00720bULL, 0x0c0fe40003f14000ULL,
0x0000007e3d857209ULL, 0x000fd20007810000ULL, 0x00000080783ca824ULL, 0x000fe400078e0209ULL,
0x0000000000447806ULL, 0x000fc600000e0100ULL, 0x0000003c6d3ca210ULL, 0x000fe40007ffe06cULL,
0x000000ff4400720cULL, 0x000fc60003f05270ULL, 0x01a400853c00a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007e853c7221ULL, 0x000fe20000010100ULL,
0x000000ff44ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0044ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b3c3c7820ULL, 0x000fe20000410000ULL, 0x00ff000044ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000044ff7812ULL, 0x000fe2000788c0ffULL, 0x0000003c00417308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff3c7819ULL, 0x002fcc000001160aULL,
0x00001f3c413c7589ULL, 0x004e6400000e0000ULL, 0x0000003c54547220ULL, 0x082fe20000410000ULL,
0x0000003c55557220ULL, 0x080fe20000410000ULL, 0x0000003c48487220ULL, 0x080fe20000410000ULL,
0x0000003c49497220ULL, 0x080fe20000410000ULL, 0x0000003c4c4c7220ULL, 0x080fe20000410000ULL,
0x0000003c4d4d7220ULL, 0x080fe20000410000ULL, 0x0000003c50507220ULL, 0x080fe20000410000ULL,
0x0000003c51517220ULL, 0x080fe20000410000ULL, 0x0000003c30307220ULL, 0x080fe20000410000ULL,
0x0000003c31317220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a3c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f3c413c7589ULL, 0x004e6400000e0000ULL,
0x0000003c56567220ULL, 0x082fe20000410000ULL, 0x0000003c57577220ULL, 0x080fe20000410000ULL,
0x0000003c4a4a7220ULL, 0x080fe20000410000ULL, 0x0000003c4b4b7220ULL, 0x080fe20000410000ULL,
0x0000003c4e4e7220ULL, 0x080fe20000410000ULL, 0x0000003c4f4f7220ULL, 0x080fe20000410000ULL,
0x0000003c52527220ULL, 0x080fe20000410000ULL, 0x0000003c53537220ULL, 0x080fe20000410000ULL,
0x0000003c32327220ULL, 0x080fe20000410000ULL, 0x0000003c33337220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a3c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c413c7589ULL, 0x004e6400000e0000ULL, 0x0000003c0c0c7220ULL, 0x082fe20000410000ULL,
0x0000003c0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003c10107220ULL, 0x080fe20000410000ULL,
0x0000003c11117220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003c20207220ULL, 0x080fe20000410000ULL,
0x0000003c21217220ULL, 0x080fe20000410000ULL, 0x0000003c38387220ULL, 0x080fe20000410000ULL,
0x0000003c39397220ULL, 0x080fe20000410000ULL, 0x0000003c34347220ULL, 0x080fe20000410000ULL,
0x0000003c35357220ULL, 0x000fce0000410000ULL, 0x0000004183837220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a3c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c413c7589ULL, 0x000e6400000e0000ULL, 0x0000003c0e0e7220ULL, 0x082fe20000410000ULL,
0x0000003c0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003c12127220ULL, 0x080fe20000410000ULL,
0x0000003c13137220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003c22227220ULL, 0x080fe20000410000ULL,
0x0000003c23237220ULL, 0x080fe20000410000ULL, 0x0000003c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003c36367220ULL, 0x080fe20000410000ULL,
0x0000003c37377220ULL, 0x000fce0000410000ULL, 0x000000443fff7212ULL, 0x000fda00078030ffULL,
0x800000853d3d0221ULL, 0x000fe20000010000ULL, 0x00007610ff400816ULL, 0x000fc60000000040ULL,
0x3fb8aa3b3d3d0820ULL, 0x000fc80000410000ULL, 0x0000003d00040308ULL, 0x000ea40000000800ULL,
0x000000043e3e0220ULL, 0x004fce0000410000ULL, 0x000000833e837221ULL, 0x000fce0000010000ULL,
0x00000000003c7805ULL, 0x002fce0000015200ULL, 0x01a6a87b420075a7ULL, 0x000e62000800017fULL,
0x0001a6a842417836ULL, 0x000fca0000000000ULL, 0x00000000410572caULL, 0x000fe200000e0000ULL,
0x0000000000600947ULL, 0x002fdc0003800000ULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x000000104400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000144447836ULL, 0x000fce0000000000ULL,
0x01a6a87b420075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000410572caULL, 0x000fde00000e0000ULL, 0x00000002787c7824ULL, 0x000fe200078e00ffULL,
0x000000080a3d7812ULL, 0x000fe200078ec0ffULL, 0x0000000478717824ULL, 0x000fe200078e00ffULL,
0x0000991040407816ULL, 0x000fe200000000ffULL, 0x00001000783f7824ULL, 0x000fe200078e00ffULL,
0x000000047c7d7812ULL, 0x000fe400078ec0ffULL, 0x000000073d687812ULL, 0x000fe200078ef80aULL,
0x000000ffff3d7224ULL, 0x000fe200078e0040ULL, 0x0000007d0a3c7211ULL, 0x000fe400078fe0ffULL,
0x0000001068797812ULL, 0x040fe200078efcffULL, 0x00000008683e7824ULL, 0x040fe200078e00ffULL,
0x000000ff3d00720cULL, 0x000fe20003f05270ULL, 0x00000001687f7824ULL, 0x000fe200078e023cULL,
0x0000000471717812ULL, 0x000fe200078ec0ffULL, 0x00000400783d7824ULL, 0x000fe200078e00ffULL,
0xffffe0003f407812ULL, 0x000fe200078ec0ffULL, 0x000000013c7e7824ULL, 0x000fe200078e0279ULL,
0xfffffff83e7f7812ULL, 0x000fe200078ee27fULL, 0x0000000868697824ULL, 0x000fe200078e00ffULL,
0xfffff0003d3e7812ULL, 0x000fe200078ec0ffULL, 0x00000008793d7824ULL, 0x000fe200078e00ffULL,
0x000000710a717211ULL, 0x000fc400078fe0ffULL, 0x0001200009737810ULL, 0x040fe40007ffe03eULL,
0xfffffff83d7e7812ULL, 0x000fe200078ee27eULL, 0x00000001685c7824ULL, 0x000fe200078e0271ULL,
0x00016000095e7810ULL, 0x000fe20007ffe040ULL, 0x000000107f3e7824ULL, 0x100fe400078e0273ULL,
0x000000107e447824ULL, 0x000fe200078e0273ULL, 0xfffffff869697812ULL, 0x000fe200078ee25cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x00005410003c7816ULL, 0x000fe20000000000ULL, 0x00000008033d7836ULL, 0x000fe40000000000ULL,
0x00000018033f7836ULL, 0x000fe40000000000ULL, 0x00001f053c057589ULL, 0x0002a800000e0000ULL,
0x00001f3d3c027589ULL, 0x0002e800000e0000ULL, 0x00001f033c037589ULL, 0x00026800000e0000ULL,
0x00001f3f3c007589ULL, 0x00026400000e0000ULL, 0x000000003e3c783bULL, 0x002e620000000200ULL,
0x0000001069407824ULL, 0x000fc600078e025eULL, 0x000000004444783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x088fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000544447232ULL, 0x084fe40000200000ULL,
0x0000000546467232ULL, 0x000fc40000200000ULL, 0x0000000045457232ULL, 0x080fe40000200000ULL,
0x0000000047477232ULL, 0x000fce0000200000ULL, 0x0000000868607824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x000000025c7b7836ULL, 0x000fe20000000000ULL,
0x000000027d7d7812ULL, 0x000fc800078efcffULL, 0xfffffff8607b7812ULL, 0x000fe400078ee27bULL,
0x0000007d0a7d7211ULL, 0x000fc600078fe0ffULL, 0x000000107b5e7824ULL, 0x000fcc00078e025eULL,
0x000000005e5c783bULL, 0x000f640000004200ULL, 0x000000ff40607812ULL, 0x068fe400078ec0ffULL,
0x00000010ff927819ULL, 0x000fe40000011641ULL, 0x00000060ff64723eULL, 0x000fe400020006ffULL,
0x0000ffff41907812ULL, 0x000fe400078ec0ffULL, 0x0000ffff40917812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fe40000011642ULL, 0x00000008ff917819ULL, 0x000fe40000011691ULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000010ff8b7819ULL, 0x104fe4000001165cULL,
0x000000ff5c957812ULL, 0x000fe400078ec0ffULL, 0x00000018ff947819ULL, 0x000fc4000001165cULL,
0x0000ffff5c847812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x00000010ff707819ULL, 0x100fe4000001165eULL, 0x000000ff5e617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe4000001165eULL, 0x0000ffff5e827812ULL, 0x000fc400078ec0ffULL,
0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff937819ULL, 0x100fe4000001165fULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff817819ULL, 0x000fe4000001165fULL,
0x0000ffff5f727812ULL, 0x000fe400078ec0ffULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x0000005eff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000061ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL, 0x2000005fff617230ULL, 0x000fe20000004100ULL,
0x0000ffff42897812ULL, 0x000fe200078ec0ffULL, 0x20000093ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe40000011690ULL, 0x0000ffff438c7812ULL, 0x000fc400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000091ff90723eULL, 0x000fe200020006ffULL,
0x20000092ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe40000011643ULL,
0x0000008eff92723eULL, 0x000fe200020006ffULL, 0x20000093ff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe2000001168cULL, 0x20000092ff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fc40000011640ULL, 0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000010ff8d7819ULL, 0x000fe2000001165dULL, 0x20000089ff927230ULL, 0x000fe20000004100ULL,
0x0000ffff5d887812ULL, 0x000fe200078ec0ffULL, 0x20000093ff897230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x000000ff5d967812ULL, 0x000fe400078ec0ffULL,
0x00000094ff5d723eULL, 0x000fe400020006ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff41637812ULL, 0x000fc400078ec0ffULL, 0x000000ff8d947812ULL, 0x000fe200078ec0ffULL,
0x2000008aff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x000000ff81937812ULL, 0x000fe200078ec0ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000008ff817819ULL, 0x000fe40000011682ULL,
0x00000018ff407819ULL, 0x000fe20000011641ULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x000000ff42657812ULL, 0x000fe400078ec0ffULL, 0x000000ff43667812ULL, 0x000fe400078ec0ffULL,
0x0000008bff8a723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x00000018ff417819ULL, 0x000fe20000011642ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000084ff827230ULL, 0x000fe20000004100ULL,
0x00000094ff8b723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000093ff94723eULL, 0x000fe200020006ffULL, 0x20000088ff847230ULL, 0x000fe20000004100ULL,
0x00000018ff427819ULL, 0x000fe20000011643ULL, 0x20000070ff887230ULL, 0x000fe20000004100ULL,
0x00000081ff93723eULL, 0x000fe200020006ffULL, 0x20000094ff817230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000066ff43723eULL, 0x000fe200020006ffULL,
0x20000063ff667230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000093ff707230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000065ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x20000041ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fe20000011667ULL,
0x20000095ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x00000008ff727819ULL, 0x000fe40000011672ULL, 0x00000096ff43723eULL, 0x000fe400020006ffULL,
0x00000010ff947819ULL, 0x000fe40000011666ULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x000010548f667816ULL, 0x000fe20000000064ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000105493647816ULL, 0x000fc40000000090ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe40000011663ULL,
0x00000010ff627819ULL, 0x000fe20000011662ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe4000001168cULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff8c7819ULL, 0x000fc40000011641ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff417819ULL, 0x000fe40000011689ULL,
0x00000010ff897819ULL, 0x000fe4000001165eULL, 0x0000105463627816ULL, 0x000fe40000000062ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165cULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x000010548d637816ULL, 0x000fe40000000090ULL, 0x000010545d5c7816ULL, 0x000fe40000000082ULL,
0x00000010ff8d7819ULL, 0x000fe40000011643ULL, 0x00000010ff827819ULL, 0x000fe20000011661ULL,
0x000000623c4c723cULL, 0x002fe2000004184cULL, 0x00000010ff8f7819ULL, 0x000fc40000011665ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff437819ULL, 0x000fe2000001168aULL,
0x000000624414723cULL, 0x000fe20000041814ULL, 0x00000010ff617819ULL, 0x000fe40000011660ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff657819ULL, 0x000fe4000001168eULL,
0x00000010ff8a7819ULL, 0x000fc4000001168bULL, 0x00001054895d7816ULL, 0x000fe40000000084ULL,
0x00000010ff607819ULL, 0x000fe20000011670ULL, 0x0000000168707824ULL, 0x000fe200078e027dULL,
0x00000010ff677819ULL, 0x000fe20000011691ULL, 0x00000001797d7824ULL, 0x000fe200078e027dULL,
0x00000010ff927819ULL, 0x000fe20000011692ULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff8b7819ULL, 0x000fe40000011688ULL, 0x00000010ff817819ULL, 0x000fc40000011681ULL,
0x00000010ff897819ULL, 0x000fe2000001165fULL, 0x0000005c4420723cULL, 0x000fe20000041820ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x0000105440657816ULL, 0x000fe40000000065ULL, 0x0000105443427816ULL, 0x000fe2000000008cULL,
0x00000001795c7824ULL, 0x000fe200078e0271ULL, 0x0000105461607816ULL, 0x000fc40000000060ULL,
0x0000105467677816ULL, 0x000fe20000000094ULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x000010548f407816ULL, 0x000fe40000000092ULL, 0x000010548a437816ULL, 0x000fe4000000008dULL,
0x000010548b5e7816ULL, 0x000fe2000000005eULL, 0x000000663c54723cULL, 0x000fe20000041854ULL,
0x00001054815f7816ULL, 0x000fe40000000082ULL, 0x0000105489617816ULL, 0x000fe20000000072ULL,
0x000020006e727824ULL, 0x000fc400078e0209ULL, 0x000000403c50723cULL, 0x000fe40000041850ULL,
0x0001600072847836ULL, 0x000fc80000000000ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x00000066440c723cULL, 0x000fe2000004180cULL, 0x00000008683d7824ULL, 0x000fc400078e00ffULL,
0x00000008793c7824ULL, 0x000fc600078e00ffULL, 0xfffffff83d707812ULL, 0x000fe200078ee270ULL,
0x00000008793d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c717812ULL, 0x000fe200078ee27dULL,
0x000000644410723cULL, 0x000fe40000041810ULL, 0x00000010703c7824ULL, 0x100fe200078e0273ULL,
0xfffffff83d7d7812ULL, 0x000fe200078ee25cULL, 0x0000001071737824ULL, 0x000fe400078e0273ULL,
0x000000404418723cULL, 0x000fe40000041818ULL, 0x000000003c3c783bULL, 0x000e680000000200ULL,
0x00000042441c723cULL, 0x000fe2000004181cULL, 0x000000107d407824ULL, 0x000fca00078e0284ULL,
0x0000005e4438723cULL, 0x000fec0000041838ULL, 0x000000604444723cULL, 0x000fe20000041834ULL,
0x000000007334783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x080fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x00000008795e7824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x000000025c737836ULL, 0x004fe20000000000ULL,
0xfffffff87c7c7812ULL, 0x000fc800078ec0ffULL, 0xfffffff85e737812ULL, 0x000fe200078ee273ULL,
0x00000001097c7824ULL, 0x000fc800078e027cULL, 0x00000010735c7824ULL, 0x000fcc00078e0284ULL,
0x000000005c5c783bULL, 0x000ea20000004200ULL, 0x00000010ff907819ULL, 0x120fe40000011640ULL,
0x000000ff40607812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011640ULL,
0x0000ffff40927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff937819ULL, 0x000fe40000011641ULL,
0x000000ff41637812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x0000ffff41947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff957819ULL, 0x100fe40000011642ULL,
0x000000ff42667812ULL, 0x040fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x0000ffff428e7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8d7819ULL, 0x100fe40000011643ULL,
0x000000ff43677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe40000011643ULL,
0x0000ffff438f7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff64723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x004fc4000001165cULL, 0x000000ff5c657812ULL, 0x040fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff437819ULL, 0x000fe4000001165cULL,
0x0000ffff5c8a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x100fe4000001165dULL,
0x000000ff5d977812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fc4000001165dULL,
0x0000ffff5d8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x100fe4000001165eULL,
0x000000ff5e817812ULL, 0x040fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe4000001165eULL,
0x0000ffff5e897812ULL, 0x000fe400078ec0ffULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x00000010ff887819ULL, 0x100fe4000001165fULL, 0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff967819ULL, 0x000fe4000001165fULL, 0x0000ffff5f827812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000066ff5d723eULL, 0x000fc400020006ffULL,
0x00000067ff5f723eULL, 0x000fe200020006ffULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fe200020006ffULL, 0x2000005dff627230ULL, 0x000fe20000004100ULL,
0x00000065ff5d723eULL, 0x000fe200020006ffULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x00000043ff5f723eULL, 0x000fe200020006ffULL, 0x20000041ff657230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000005dff417230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x2000005fff5d7230ULL, 0x000fe20000004100ULL,
0x00000061ff5f723eULL, 0x000fe200020006ffULL, 0x20000097ff437230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fc400020006ffULL, 0x0000005eff97723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff927819ULL, 0x000fe20000011692ULL,
0x20000081ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff90907812ULL, 0x000fe200078ec0ffULL,
0x2000005fff817230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000096ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff967819ULL, 0x000fe20000011694ULL,
0x20000097ff617230ULL, 0x000fe20000004100ULL, 0x000000ff95977812ULL, 0x000fe200078ec0ffULL,
0x20000092ff957230ULL, 0x000fe20000004100ULL, 0x000000ff93937812ULL, 0x000fc400078ec0ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x00000008ff927819ULL, 0x000fe4000001168fULL, 0x00000093ff94723eULL, 0x000fe200020006ffULL,
0x20000090ff937230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x20000096ff907230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168eULL,
0x20000097ff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000092ff96723eULL, 0x000fe200020006ffULL,
0x2000008dff927230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x0000008cff8d723eULL, 0x000fe200020006ffULL,
0x20000096ff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff8a7819ULL, 0x000fe2000001168aULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff91977812ULL, 0x000fe200078ec0ffULL,
0x2000008eff917230ULL, 0x000fe20000004100ULL, 0x000000ff88967812ULL, 0x000fe200078ec0ffULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000008ff8b7819ULL, 0x000fe4000001168bULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x00000097ff8e723eULL, 0x000fe400020006ffULL, 0x00000008ff887819ULL, 0x000fe20000011689ULL,
0x2000008aff897230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000096ff97723eULL, 0x000fc400020006ffULL,
0x000010548f627816ULL, 0x000fe40000000062ULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000010ff8f7819ULL, 0x000fe40000011641ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x2000008bff8a7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe2000001168cULL, 0x20000060ff8b7230ULL, 0x000fe20000004100ULL,
0x00000088ff96723eULL, 0x000fe200020006ffULL, 0x20000097ff887230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fc400020006ffULL, 0x00000010ff8c7819ULL, 0x000fe2000001168dULL,
0x20000096ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff977819ULL, 0x000fe20000011666ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x0000105442417816ULL, 0x000fe40000000041ULL, 0x000010548c427816ULL, 0x000fe4000000008fULL,
0x00000010ff8c7819ULL, 0x000fc4000001165dULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff967819ULL, 0x000fe40000011667ULL, 0x0000105494677816ULL, 0x000fe40000000097ULL,
0x00000010ff947819ULL, 0x000fe40000011665ULL, 0x00000010ff8d7819ULL, 0x000fe4000001165cULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff657819ULL, 0x000fe40000011690ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff5d7819ULL, 0x000fe4000001168aULL,
0x000010548c5c7816ULL, 0x000fc40000000089ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff917819ULL, 0x000fc40000011691ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff8a7819ULL, 0x000fe4000001168bULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff897819ULL, 0x000fc4000001165fULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x0000105493667816ULL, 0x000fe40000000064ULL, 0x0000105440657816ULL, 0x000fe40000000065ULL,
0x000010545e5d7816ULL, 0x000fe4000000005dULL, 0x00001054885f7816ULL, 0x000fe20000000061ULL,
0x000000663c54723cULL, 0x002fe20000041854ULL, 0x0000105496647816ULL, 0x000fc40000000095ULL,
0x0000105492637816ULL, 0x000fe40000000063ULL, 0x0000105494407816ULL, 0x000fe20000000091ULL,
0x0000005c3c2c723cULL, 0x000fe2000004182cULL, 0x000010548e437816ULL, 0x000fe40000000043ULL,
0x000010548a5e7816ULL, 0x000fe4000000008dULL, 0x0000105481607816ULL, 0x000fe20000000060ULL,
0x000000643c48723cULL, 0x000fe20000041848ULL, 0x0000105489617816ULL, 0x000fca0000000082ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x00000066340c723cULL, 0x008fe2000004180cULL,
0x000000086e3c7824ULL, 0x000fc400078e0209ULL, 0x00000001ff3f7424ULL, 0x000fc600078e00ffULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x01a6c83f3c3c79a7ULL, 0x00026a000850003fULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x01a6883f7cff79a7ULL, 0x0003ea000850003fULL,
0x000000403418723cULL, 0x000fec0000041818ULL, 0x00000042341c723cULL, 0x000fec000004181cULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x002fde0000041844ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff8a7b82ULL, 0x000e620000000a00ULL, 0x00000010783c7824ULL, 0x000fe200078e00ffULL,
0x0000850000087ab9ULL, 0x000fe40000000800ULL, 0x000000087a7a7c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe03c357812ULL, 0x000fca00078ec0ffULL, 0x0000010058357824ULL, 0x000fc800078e0235ULL,
0x0000008035377836ULL, 0x000fe40000000000ULL, 0x000000807a357824ULL, 0x000fc600078e00ffULL,
0x0000006037347812ULL, 0x000fe200078ec0ffULL, 0x00000080358a7825ULL, 0x002fc800078e008aULL,
0x0000000159367824ULL, 0x000fe200078e0234ULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x0000003774347248ULL, 0x000fe40007fe0000ULL, 0x000000103c3d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff357819ULL, 0x000fe2000001160aULL, 0x0000000134347824ULL, 0x000fc800078e0a37ULL,
0x0000000135377824ULL, 0x100fe200078e023dULL, 0x000000343d347248ULL, 0x000fe20007fe0000ULL,
0x00000004353e7836ULL, 0x000fe40000000000ULL, 0x00000001373c7824ULL, 0x040fe400078e020aULL,
0x00000008375d7824ULL, 0x000fe400078e00ffULL, 0x0000000134347824ULL, 0x100fe400078e0a3dULL,
0x000000013e3f7824ULL, 0x040fe200078e023dULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee23cULL,
0x00000008353c7836ULL, 0x000fe20000000000ULL, 0x000000343e00720cULL, 0x080fe20003f66070ULL,
0x0000000c353e7836ULL, 0x000fe20000000000ULL, 0x000000343500720cULL, 0x080fe20003f86070ULL,
0x0000000137357824ULL, 0x000fe200078e0236ULL, 0x000000343c00720cULL, 0x080fe20003f46070ULL,
0x000000013f377824ULL, 0x040fe200078e020aULL, 0x000000343e00720cULL, 0x000fe20003f06070ULL,
0x000000083f407824ULL, 0x000fc400078e00ffULL, 0x0000008035347825ULL, 0x000fc600078e00ffULL,
0xfffffff8405f7812ULL, 0x000fe200078ee237ULL, 0x000000013c417824ULL, 0x100fe200078e023dULL,
0x0000006c34377212ULL, 0x000fe200078efcffULL, 0x000000013f3c7824ULL, 0x000fe400078e0236ULL,
0x000000013e637824ULL, 0x000fe200078e023dULL, 0x000000378a347210ULL, 0x000fe20007fbe0ffULL,
0x00000001413f7824ULL, 0x040fe400078e020aULL, 0x0000000841407824ULL, 0x000fe400078e00ffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff840617812ULL, 0x000fe200078ee23fULL,
0x00000001413e7824ULL, 0x100fe200078e0236ULL, 0x0000006c3c417212ULL, 0x000fe200078efcffULL,
0x0000000163367824ULL, 0x000fe400078e0236ULL, 0x000000803e3e7825ULL, 0x000fc800078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006c3e437212ULL, 0x000fc600078efcffULL,
0x000000018b357824ULL, 0x000fe200028e0635ULL, 0x000000418a3c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000163407824ULL, 0x040fe200078e020aULL, 0x0000006c36417212ULL, 0x000fe200078efcffULL,
0x0000000863637824ULL, 0x000fe400078e00ffULL, 0x000000018b3d7824ULL, 0x000fe200028e063dULL,
0x000000438a3e7210ULL, 0x000fe20007fbe0ffULL, 0x000000105f437824ULL, 0x100fe200078e0284ULL,
0x000000418a367210ULL, 0x000fe20007fde0ffULL, 0x000000105d417824ULL, 0x000fe200078e0284ULL,
0xfffffff863637812ULL, 0x000fe200078ee240ULL, 0x000000018b3f7824ULL, 0x000fc400028e063fULL,
0x00000010615d7824ULL, 0x100fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e2000e101c46ULL, 0x000000018b377824ULL, 0x000fe400030e0637ULL,
0x00000010635f7824ULL, 0x000fe200078e0284ULL, 0x000000003c437faeULL, 0x0003e8000d901c46ULL,
0x000000003e5d7faeULL, 0x0003e8000d101c46ULL, 0x00000000365f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x000000103c357812ULL, 0x000fc800078ec0ffULL,
0x000000350a357211ULL, 0x000fca00078fe8ffULL, 0x0000000135347824ULL, 0x140fe400078e020aULL,
0x00000008355f7824ULL, 0x000fe400078e00ffULL, 0x0000000435377836ULL, 0x000fe40000000000ULL,
0x00000008353d7836ULL, 0x000fe20000000000ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee234ULL,
0x00000001373c7824ULL, 0x040fe400078e020aULL, 0x0000000837617824ULL, 0x000fc400078e00ffULL,
0x000000013d3e7824ULL, 0x040fe400078e020aULL, 0x000000083d637824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee23cULL, 0x0000000135347824ULL, 0x000fe400078e0236ULL,
0x0000000c353f7836ULL, 0x000fe20000000000ULL, 0xfffffff863637812ULL, 0x000fe200078ee23eULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x00000001373c7824ULL, 0x100fe200078e0236ULL,
0x0000006c34417212ULL, 0x000fe200078efcffULL, 0x000000013d3e7824ULL, 0x100fe400078e0236ULL,
0x000000013f367824ULL, 0x040fe200078e0236ULL, 0x000000418a347210ULL, 0x000fe20007f1e0ffULL,
0x000000013f407824ULL, 0x040fe400078e020aULL, 0x000000083f657824ULL, 0x000fe400078e00ffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff865657812ULL, 0x000fe200078ee240ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000006c3c5d7212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006c3e437212ULL, 0x080fe400078efcffULL,
0x0000005d8a3c7210ULL, 0x000fe20007f5e0ffULL, 0x000000018b357824ULL, 0x000fe200000e0635ULL,
0x0000006c36417212ULL, 0x000fe200078efcffULL, 0x00000010635d7824ULL, 0x100fe200078e0284ULL,
0x000000438a3e7210ULL, 0x000fe20007f1e0ffULL, 0x000000018b3d7824ULL, 0x000fe200010e063dULL,
0x000000418a367210ULL, 0x000fe20007f7e0ffULL, 0x000000105f417824ULL, 0x000fc400078e0284ULL,
0x0000001061437824ULL, 0x100fe400078e0284ULL, 0x000000018b3f7824ULL, 0x040fe200000e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x000000018b377824ULL, 0x000fe400018e0637ULL, 0x00000010655f7824ULL, 0x000fe200078e0284ULL,
0x000000003c437faeULL, 0x0003e8000b901c46ULL, 0x000000003e5d7faeULL, 0x0003e8000b901c46ULL,
0x00000000365f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000035ff8879a7ULL, 0x0002a40008500005ULL,
0x01a62835803479a7ULL, 0x0022e4000850003fULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x01a62835800075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c363f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e37ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a62835800075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000002078347824ULL, 0x000fe400078e00ffULL,
0x00000001ff3c7424ULL, 0x000fc600078e00ffULL, 0xffffff8034347812ULL, 0x000fc800078ec0ffULL,
0x0000008009347810ULL, 0x000fc80007ffe034ULL, 0x000000346d347210ULL, 0x000fca0007ffe06cULL,
0x01a0000034367984ULL, 0x000ee80000000800ULL, 0x01a2000034357984ULL, 0x0009220000000800ULL,
0x000000853600720bULL, 0x008fda0003f1d000ULL, 0x00000000003d7806ULL, 0x000fc800000e0100ULL,
0x000000ff3d00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x016fea0003800000ULL,
0x000000015a377836ULL, 0x000fe20000000000ULL, 0x000000853600720bULL, 0x000fc80003f14000ULL,
0x000000783700720cULL, 0x000fd20003f45270ULL, 0x00000000003c7806ULL, 0x000fc800000e0100ULL,
0x000000807837a824ULL, 0x000fe200078e0209ULL, 0x000000853634a209ULL, 0x000fe40007810000ULL,
0x000000ff3c00720cULL, 0x000fe40003f05270ULL, 0x000000376d37a210ULL, 0x000fca0007ffe06cULL,
0x01a400343700a388ULL, 0x0003ec0000000800ULL, 0x0000000400548947ULL, 0x000fea0003800000ULL,
0x0000008536347209ULL, 0x002fe40007810000ULL, 0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL, 0x0000008534347221ULL, 0x000fe20000010100ULL,
0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL, 0xff0000003cff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003e7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff377819ULL, 0x000fca000001160aULL,
0x00001f373e347589ULL, 0x006e6400000e0000ULL, 0x0000005434547220ULL, 0x042fe20000410000ULL,
0x0000005534557220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004c344c7220ULL, 0x040fe20000410000ULL,
0x0000004d344d7220ULL, 0x040fe20000410000ULL, 0x0000005034507220ULL, 0x040fe20000410000ULL,
0x0000005134517220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002434247220ULL, 0x040fe20000410000ULL,
0x0000002534257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a377811ULL, 0x000fca00078ff0ffULL, 0x00001f373e347589ULL, 0x006e6400000e0000ULL,
0x0000005634567220ULL, 0x042fe20000410000ULL, 0x0000005734577220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004e344e7220ULL, 0x040fe20000410000ULL, 0x0000004f344f7220ULL, 0x040fe20000410000ULL,
0x0000005234527220ULL, 0x040fe20000410000ULL, 0x0000005334537220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002634267220ULL, 0x040fe20000410000ULL, 0x0000002734277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a377811ULL, 0x000fca00078ff0ffULL,
0x00001f373e347589ULL, 0x006e6400000e0000ULL, 0x0000000c340c7220ULL, 0x042fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x040fe20000410000ULL, 0x0000003834387220ULL, 0x040fe20000410000ULL,
0x0000003934397220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x000fce0000410000ULL, 0x0000003e83837220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a377811ULL, 0x000fca00078ff0ffULL,
0x00001f373e347589ULL, 0x002e6400000e0000ULL, 0x0000000e340e7220ULL, 0x042fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x040fe20000410000ULL, 0x0000003a343a7220ULL, 0x040fe20000410000ULL,
0x0000003b343b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x000fce0000410000ULL, 0x0000003c3dff7212ULL, 0x000fe200078030ffULL,
0x00000001ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000008536857209ULL, 0x000fd60007810000ULL,
0x8000008536360221ULL, 0x000fe20000010000ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600040308ULL, 0x000ea40000000800ULL,
0x0000000435350220ULL, 0x004fce0000410000ULL, 0x0000008335837221ULL, 0x000fe20000010000ULL,
0x0000000000347805ULL, 0x002fe20000015200ULL, 0x0000000878367824ULL, 0x000fca00078e00ffULL,
0xfffffff036367812ULL, 0x000fca00078ec0ffULL, 0x00000001093f7824ULL, 0x000fc800078e0236ULL,
0x01a6b0873f0075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a6b0873f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000099103c347816ULL, 0x000fe200000000ffULL,
0x0000040078357824ULL, 0x040fe400078e00ffULL, 0x0000100078367824ULL, 0x000fe200078e00ffULL,
0x000000ff3400720cULL, 0x000fe40003f05270ULL, 0xfffff000357c7812ULL, 0x000fe400078ec0ffULL,
0xffffe00036367812ULL, 0x000fe400078ec0ffULL, 0x00013000097c7810ULL, 0x000fc40007ffe07cULL,
0x00017000095c7810ULL, 0x000fc60007ffe036ULL, 0x000000107f3c7824ULL, 0x100fe400078e027cULL,
0x000000107e347824ULL, 0x000fe400078e027cULL, 0x0000001069407824ULL, 0x000fe200078e025cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff367819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000000836027836ULL, 0x000fe20000000000ULL,
0x0000541000357816ULL, 0x000fe20000000000ULL, 0x00000010363e7836ULL, 0x000fe40000000000ULL,
0x0000001836427836ULL, 0x000fe40000000000ULL, 0x00001f0235027589ULL, 0x0002a800000e0000ULL,
0x00001f3e35057589ULL, 0x0002e800000e0000ULL, 0x00001f3635037589ULL, 0x00026800000e0000ULL,
0x00001f4235007589ULL, 0x00026400000e0000ULL, 0x000000003c3c783bULL, 0x002e680000000200ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x084fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x000000107b5c7824ULL, 0x000fe200078e025cULL, 0x000000004040783bULL, 0x000f2a0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000018ff627819ULL, 0x110fe40000011640ULL,
0x00000018ff637819ULL, 0x000fe40000011641ULL, 0x00000010ff917819ULL, 0x000fc40000011640ULL,
0x000000ff40607812ULL, 0x040fe400078ec0ffULL, 0x0000ffff40937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff947819ULL, 0x000fe40000011641ULL, 0x000000ff41647812ULL, 0x040fe400078ec0ffULL,
0x0000ffff41957812ULL, 0x000fe400078ec0ffULL, 0x000000ff43667812ULL, 0x000fc400078ec0ffULL,
0x00000010ff967819ULL, 0x100fe40000011642ULL, 0x000000ff42657812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff428e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x100fe40000011643ULL, 0x00000018ff417819ULL, 0x000fc40000011643ULL,
0x0000ffff43907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8f7819ULL, 0x128fe4000001165cULL,
0x000000ff5c437812ULL, 0x040fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe4000001165cULL,
0x0000ffff5c877812ULL, 0x000fe400078ec0ffULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x00000010ff927819ULL, 0x100fe4000001165dULL, 0x000000ff5d987812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d8c7812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000066ff5d723eULL, 0x000fe200020006ffULL,
0x20000062ff667230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000063ff627230ULL, 0x000fe20000004100ULL, 0x000000ff5e817812ULL, 0x000fe200078ec0ffULL,
0x2000005dff637230ULL, 0x000fe20000004100ULL, 0x00000043ff43723eULL, 0x000fc400020006ffULL,
0x00000060ff61723eULL, 0x000fe400020006ffULL, 0x00000018ff7a7819ULL, 0x100fe4000001165eULL,
0x00000098ff98723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fe4000001165eULL, 0x0000ffff5e867812ULL, 0x000fe400078ec0ffULL,
0x00000018ff977819ULL, 0x000fc4000001165fULL, 0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL,
0x00000042ff5d723eULL, 0x000fe200020006ffULL, 0x20000041ff427230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000043ff417230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fe2000001165fULL, 0x20000098ff437230ULL, 0x000fe20000004100ULL,
0x0000ffff5f677812ULL, 0x000fe200078ec0ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fc400020006ffULL, 0x0000007aff5f723eULL, 0x000fe400020006ffULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x0000005eff98723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff91917812ULL, 0x000fe200078ec0ffULL,
0x20000081ff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff937819ULL, 0x000fe20000011693ULL,
0x2000005fff817230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000097ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff977819ULL, 0x000fe20000011695ULL,
0x20000098ff7a7230ULL, 0x000fe20000004100ULL, 0x00000093ff95723eULL, 0x000fe200020006ffULL,
0x20000091ff937230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fc400020006ffULL,
0x000000ff96967812ULL, 0x000fe200078ec0ffULL, 0x20000095ff957230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x20000097ff917230ULL, 0x000fe20000004100ULL,
0x00000008ff977819ULL, 0x000fe40000011690ULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x20000096ff907230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fc400020006ffULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000008dff967230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x20000097ff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff877819ULL, 0x000fe40000011687ULL, 0x000000ff94947812ULL, 0x000fe400078ec0ffULL,
0x000000ff92987812ULL, 0x000fe200078ec0ffULL, 0x2000008eff927230ULL, 0x000fe20000004100ULL,
0x00000008ff8c7819ULL, 0x000fc4000001168cULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x000000ff82977812ULL, 0x000fe400078ec0ffULL, 0x00000008ff827819ULL, 0x000fe40000011686ULL,
0x0000008fff8e723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x20000087ff867230ULL, 0x000fe20000004100ULL,
0x00000098ff8f723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000097ff98723eULL, 0x000fe200020006ffULL, 0x2000008cff877230ULL, 0x000fe20000004100ULL,
0x00000082ff97723eULL, 0x000fe200020006ffULL, 0x20000060ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff677819ULL, 0x000fe20000011667ULL, 0x20000098ff827230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000097ff607230ULL, 0x000fe20000004100ULL,
0x00000067ff99723eULL, 0x000fc400020006ffULL, 0x00000010ff977819ULL, 0x000fe20000011666ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe20000011661ULL,
0x20000099ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe40000011693ULL,
0x00000010ff987819ULL, 0x000fe40000011664ULL, 0x00000010ff937819ULL, 0x000fe40000011694ULL,
0x0000105466667816ULL, 0x000fc40000000067ULL, 0x0000105493677816ULL, 0x000fe40000000098ULL,
0x00000010ff937819ULL, 0x000fe40000011665ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff657819ULL, 0x000fe20000011691ULL, 0x000000663c54723cULL, 0x002fe20000041854ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x0000105462657816ULL, 0x000fe20000000065ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x0000105490627816ULL, 0x000fe20000000093ULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff907819ULL, 0x000fe40000011641ULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff417819ULL, 0x000fe4000001168dULL,
0x00000010ff8d7819ULL, 0x000fe4000001165cULL, 0x000010545d5c7816ULL, 0x000fe40000000086ULL,
0x00000010ff647819ULL, 0x000fe40000011695ULL, 0x00000010ff427819ULL, 0x000fc40000011642ULL,
0x00000010ff917819ULL, 0x000fe40000011643ULL, 0x000010545e5d7816ULL, 0x000fe40000000087ULL,
0x00000010ff957819ULL, 0x000fe40000011640ULL, 0x00000010ff437819ULL, 0x000fe4000001168eULL,
0x00000010ff877819ULL, 0x000fe20000011682ULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x00000010ff407819ULL, 0x000fe20000011692ULL, 0x0000005c3420723cULL, 0x000fe20000041820ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168fULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff817819ULL, 0x000fc40000011681ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff827819ULL, 0x000fe4000001165fULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x0000105443427816ULL, 0x000fe40000000090ULL, 0x0000105497647816ULL, 0x000fc40000000064ULL,
0x0000105496637816ULL, 0x000fe40000000063ULL, 0x0000105495407816ULL, 0x000fe40000000040ULL,
0x000010548e437816ULL, 0x000fe20000000091ULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x000010548c5e7816ULL, 0x000fe4000000008dULL, 0x00001054875f7816ULL, 0x000fe2000000007aULL,
0x00017000727a7836ULL, 0x000fe20000000000ULL, 0x0000105481607816ULL, 0x000fe20000000060ULL,
0x000000623c4c723cULL, 0x000fe2000004184cULL, 0x0000105482617816ULL, 0x000fca0000000061ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x00000010703c7824ULL, 0x000fca00078e027cULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x0000001071407824ULL, 0x000fe200078e027cULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000107d7c7824ULL, 0x000fc600078e027aULL,
0x000000623414723cULL, 0x000fec0000041814ULL, 0x00000042341c723cULL, 0x000fec000004181cULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000603444723cULL, 0x000fe20000041844ULL,
0x000000004034783bULL, 0x0006a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x080fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x00000010735c7824ULL, 0x000fe200078e027aULL,
0x000000007c40783bULL, 0x008eea0000004200ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x00000010ff917819ULL, 0x108fe40000011640ULL, 0x000000ff40607812ULL, 0x000fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fc40000011640ULL, 0x0000ffff40947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff957819ULL, 0x100fe40000011641ULL, 0x000000ff41637812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011641ULL, 0x0000ffff41967812ULL, 0x000fe400078ec0ffULL,
0x00000010ff977819ULL, 0x000fc40000011642ULL, 0x000000ff42657812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff428f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff417819ULL, 0x100fe40000011643ULL, 0x00000010ff907819ULL, 0x000fe40000011643ULL,
0x000000ff439a7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff43927812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c427812ULL, 0x050fe400078ec0ffULL, 0x00000018ff437819ULL, 0x100fe4000001165cULL,
0x00000060ff66723eULL, 0x000fe400020006ffULL, 0x00000010ff8e7819ULL, 0x000fe4000001165cULL,
0x0000ffff5c867812ULL, 0x000fe200078ec0ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fc4000001165dULL, 0x000000ff5d997812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff607819ULL, 0x100fe4000001165eULL, 0x000000ff5e817812ULL, 0x000fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fc4000001165eULL, 0x0000ffff5e877812ULL, 0x000fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000010ff8c7819ULL, 0x100fe4000001165fULL,
0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff987819ULL, 0x000fe4000001165fULL,
0x0000ffff5f677812ULL, 0x000fc400078ec0ffULL, 0x00000042ff5d723eULL, 0x000fe200020006ffULL,
0x20000041ff427230ULL, 0x000fe20000004100ULL, 0x00000043ff5f723eULL, 0x000fe400020006ffULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x2000005dff417230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000005fff5d7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000099ff437230ULL, 0x000fe20000004100ULL,
0x00000008ff947819ULL, 0x000fc40000011694ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000005eff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x0000009aff9a723eULL, 0x000fe200020006ffULL, 0x20000081ff5c7230ULL, 0x000fe20000004100ULL,
0x00000098ff98723eULL, 0x000fe200020006ffULL, 0x2000005fff817230ULL, 0x000fe20000004100ULL,
0x00000008ff997819ULL, 0x000fe40000011696ULL, 0x000000ff95957812ULL, 0x000fe200078ec0ffULL,
0x20000098ff5f7230ULL, 0x000fe20000004100ULL, 0x00000094ff96723eULL, 0x000fc400020006ffULL,
0x00000061ff64723eULL, 0x000fe200020006ffULL, 0x20000063ff617230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x2000009aff637230ULL, 0x000fe20000004100ULL,
0x00000095ff98723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x000000ff979a7812ULL, 0x000fe200078ec0ffULL, 0x20000096ff977230ULL, 0x000fe20000004100ULL,
0x00000008ff8f7819ULL, 0x000fe2000001168fULL, 0x20000098ff947230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000099ff99723eULL, 0x000fe400020006ffULL,
0x00000008ff967819ULL, 0x000fe20000011692ULL, 0x20000091ff957230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x20000099ff917230ULL, 0x000fe20000004100ULL,
0x00000096ff98723eULL, 0x000fe400020006ffULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff867819ULL, 0x000fc40000011686ULL, 0x000000ff93997812ULL, 0x000fe200078ec0ffULL,
0x2000008fff937230ULL, 0x000fe20000004100ULL, 0x0000008eff8f723eULL, 0x000fe200020006ffULL,
0x20000098ff8e7230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff8d7819ULL, 0x000fe2000001168dULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c987812ULL, 0x000fc400078ec0ffULL,
0x00000008ff8c7819ULL, 0x000fe20000011687ULL, 0x20000086ff877230ULL, 0x000fe20000004100ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000098ff86723eULL, 0x000fe400020006ffULL, 0x0000008cff98723eULL, 0x000fe200020006ffULL,
0x2000008dff8c7230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000060ff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe20000011667ULL,
0x20000098ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff947819ULL, 0x000fe20000011694ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000067ff98723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fc40000011661ULL,
0x000000ff90907812ULL, 0x000fe200078ec0ffULL, 0x20000098ff617230ULL, 0x000fe20000004100ULL,
0x0000105494677816ULL, 0x000fe40000000067ULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff947819ULL, 0x000fe40000011665ULL, 0x00000010ff657819ULL, 0x000fe20000011691ULL,
0x20000090ff967230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fc40000011641ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff417819ULL, 0x000fe4000001168eULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff8e7819ULL, 0x000fe4000001168fULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fc400020006ffULL, 0x0000009aff9a723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000099ff90723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x2000009aff927230ULL, 0x000fe20000004100ULL, 0x000010548e427816ULL, 0x000fe20000000091ULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe4000001165dULL,
0x00000010ff877819ULL, 0x000fc40000011687ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff957819ULL, 0x000fe40000011695ULL, 0x00000010ff997819ULL, 0x000fe40000011664ULL,
0x00000010ff8f7819ULL, 0x000fe4000001165cULL, 0x00000010ff647819ULL, 0x000fe40000011697ULL,
0x000010548e5c7816ULL, 0x000fc40000000087ULL, 0x0000105495667816ULL, 0x000fe40000000066ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff977819ULL, 0x000fe40000011663ULL,
0x00000010ff877819ULL, 0x000fe20000011681ULL, 0x000000663c54723cULL, 0x002fe20000041854ULL,
0x00000010ff957819ULL, 0x000fe40000011640ULL, 0x00000010ff637819ULL, 0x000fc40000011692ULL,
0x00000010ff5e7819ULL, 0x000fe2000001165eULL, 0x00000066340c723cULL, 0x004fe2000004180cULL,
0x00000010ff5d7819ULL, 0x000fe4000001168cULL, 0x00000010ff817819ULL, 0x000fe40000011682ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff407819ULL, 0x000fe40000011693ULL,
0x00000010ff437819ULL, 0x000fc40000011643ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168dULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff827819ULL, 0x000fe4000001165fULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x0000105462657816ULL, 0x000fe40000000065ULL,
0x0000105463627816ULL, 0x000fe40000000094ULL, 0x000010545e5d7816ULL, 0x000fe4000000005dULL,
0x0000105499647816ULL, 0x000fe40000000064ULL, 0x0000105496637816ULL, 0x000fe40000000097ULL,
0x0000105495407816ULL, 0x000fe20000000040ULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x0000105490437816ULL, 0x000fc40000000043ULL, 0x000010548c5e7816ULL, 0x000fe4000000008fULL,
0x00001054865f7816ULL, 0x000fe20000000087ULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x0000105481607816ULL, 0x000fe40000000060ULL, 0x0000105482617816ULL, 0x000fc60000000061ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x000000643410723cULL, 0x000fe20000041810ULL,
0x00000002783c7824ULL, 0x000fc400078e00ffULL, 0x00000001ff3f7424ULL, 0x000fc600078e00ffULL,
0xfffffff83c3e7812ULL, 0x000fe200078ec0ffULL, 0x000000086e3c7824ULL, 0x000fe200078e0209ULL,
0x000000623414723cULL, 0x000fe60000041814ULL, 0x00000001093e7824ULL, 0x000fe400078e023eULL,
0x01a6c83f3c3c79a7ULL, 0x000e62000850003fULL, 0x000000403418723cULL, 0x000fec0000041818ULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x01a6903f3eff79a7ULL, 0x0005ea000850003fULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x000fee0000041844ULL, 0x0000000000347805ULL, 0x000fe20000015200ULL,
0x0000003d060075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x006fdc0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000010058817824ULL, 0x000fc800078e025bULL,
0x000000c081357836ULL, 0x000fca0000000000ULL, 0x0000006035347812ULL, 0x000fca00078ec0ffULL,
0x0000000159407824ULL, 0x000fe200078e0234ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x0000003574347248ULL, 0x000fe20007fe0000ULL, 0x0000001078367824ULL, 0x000fc800078e00ffULL,
0x0000000134347824ULL, 0x000fe200078e0a35ULL, 0x0000001036377812ULL, 0x000fe400078ec0ffULL,
0x00000003ff357819ULL, 0x000fe4000001160aULL, 0x0000003437347248ULL, 0x000fc60007fe0000ULL,
0x00000001353d7824ULL, 0x140fe400078e0237ULL, 0x0000000134347824ULL, 0x100fe400078e0a37ULL,
0x0000000435367836ULL, 0x000fe40000000000ULL, 0x00000008353c7836ULL, 0x000fe20000000000ULL,
0x000000343500720cULL, 0x080fe20003f86070ULL, 0x0000000c353e7836ULL, 0x000fe20000000000ULL,
0x000000343600720cULL, 0x080fe20003f66070ULL, 0x000000013d357824ULL, 0x000fe200078e0240ULL,
0x000000343c00720cULL, 0x080fe20003f46070ULL, 0x00000001363f7824ULL, 0x000fe200078e0237ULL,
0x000000343e00720cULL, 0x000fe20003f06070ULL, 0x0000008035347825ULL, 0x000fc800078e00ffULL,
0x000000013c417824ULL, 0x100fe400078e0237ULL, 0x000000013e637824ULL, 0x000fe200078e0237ULL,
0x0000006c34377212ULL, 0x000fe200078efcffULL, 0x000000013d367824ULL, 0x140fe400078e020aULL,
0x000000083d5d7824ULL, 0x000fe200078e00ffULL, 0x000000378a347210ULL, 0x000fe20007fbe0ffULL,
0x000000013f3c7824ULL, 0x040fe400078e020aULL, 0x000000083f5f7824ULL, 0x040fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL, 0x000000013f3e7824ULL, 0x000fc400078e0240ULL,
0x00000001413d7824ULL, 0x040fe200078e020aULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee23cULL,
0x0000000841427824ULL, 0x000fe400078e00ffULL, 0x000000803e3e7825ULL, 0x000fc600078e00ffULL,
0xfffffff842617812ULL, 0x000fe200078ee23dULL, 0x0000000141367824ULL, 0x100fe200078e0240ULL,
0x0000006c3e417212ULL, 0x000fe200078efcffULL, 0x00000001633c7824ULL, 0x000fe400078e0240ULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000006c36437212ULL, 0x000fc600078efcffULL, 0x000000018b357824ULL, 0x000fe200028e0635ULL,
0x000000418a3e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000163407824ULL, 0x040fe200078e020aULL,
0x0000006c3c417212ULL, 0x000fe200078efcffULL, 0x0000000863637824ULL, 0x000fe400078e00ffULL,
0x000000018b3f7824ULL, 0x000fe200028e063fULL, 0x000000438a367210ULL, 0x000fe20007fbe0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e027aULL, 0x000000418a3c7210ULL, 0x000fe20007fde0ffULL,
0x000000105f5f7824ULL, 0x100fe200078e027aULL, 0xfffffff863417812ULL, 0x000fe200078ee240ULL,
0x000000018b377824ULL, 0x000fe200028e0637ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000345d7faeULL, 0x0003e2000e101c46ULL, 0x0000001061617824ULL, 0x000fc400078e027aULL,
0x000000018b3d7824ULL, 0x000fe200030e063dULL, 0x000000003e5f7faeULL, 0x0003e2000d901c46ULL,
0x0000001041417824ULL, 0x000fc600078e027aULL, 0x0000000036617faeULL, 0x0003e8000d101c46ULL,
0x000000003c417faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001078347824ULL, 0x000fca00078e00ffULL, 0x0000001034357812ULL, 0x000fc800078ec0ffULL,
0x000000350a357211ULL, 0x000fca00078fe8ffULL, 0x00000008353d7836ULL, 0x000fe40000000000ULL,
0x0000000435377836ULL, 0x000fe40000000000ULL, 0x0000000135347824ULL, 0x140fe400078e020aULL,
0x00000008355f7824ULL, 0x000fe400078e00ffULL, 0x000000013d3e7824ULL, 0x040fe400078e020aULL,
0x000000083d637824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee234ULL,
0x00000001353c7824ULL, 0x000fc400078e0240ULL, 0x0000000137367824ULL, 0x040fe200078e020aULL,
0xfffffff863637812ULL, 0x000fe200078ee23eULL, 0x0000000837617824ULL, 0x000fe400078e00ffULL,
0x0000000c35357836ULL, 0x000fe40000000000ULL, 0x000000013d347824ULL, 0x000fe200078e0240ULL,
0xfffffff861617812ULL, 0x000fe200078ee236ULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x00000001373e7824ULL, 0x100fe200078e0240ULL, 0x0000006c3c417212ULL, 0x000fe200078efcffULL,
0x0000000135367824ULL, 0x040fe400078e0240ULL, 0x0000000135407824ULL, 0x040fe200078e020aULL,
0x000000418a3c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000835657824ULL, 0x000fe400078e00ffULL,
0x000000803e3e7825ULL, 0x000fc600078e00ffULL, 0xfffffff865657812ULL, 0x000fe200078ee240ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006c3e5d7212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006c34437212ULL, 0x080fe400078efcffULL,
0x0000005d8a3e7210ULL, 0x000fe20007f5e0ffULL, 0x000000018b3d7824ULL, 0x000fe200000e063dULL,
0x0000006c36417212ULL, 0x000fe200078efcffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0x000000438a347210ULL, 0x000fe20007f1e0ffULL, 0x000000018b3f7824ULL, 0x000fe200010e063fULL,
0x000000418a367210ULL, 0x000fe20007f7e0ffULL, 0x0000001061617824ULL, 0x000fe200078e027aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c5f7faeULL, 0x0003e2000b901c46ULL,
0x000000018b357824ULL, 0x000fc400000e0635ULL, 0x0000001063637824ULL, 0x100fe200078e027aULL,
0x000000003e617faeULL, 0x0003e2000b901c46ULL, 0x000000018b377824ULL, 0x000fe400018e0637ULL,
0x0000001065657824ULL, 0x000fe200078e027aULL, 0x0000000034637faeULL, 0x0003e8000b901c46ULL,
0x0000000036657faeULL, 0x0003e4000b901c46ULL, 0x000000026a6a7836ULL, 0x000fe20000000000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0xffffffffff827424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0000006f6a00720cULL, 0x000fca0003f06070ULL,
0x00000000ff0079b0ULL, 0x000ff00008000a48ULL, 0x00009000ff348b82ULL, 0x000e620000000a00ULL,
0x000000016a378824ULL, 0x000fe400078e0207ULL, 0x0000000878367824ULL, 0x000fc400078e00ffULL,
0x0000000437348825ULL, 0x002fca00078e0034ULL, 0x0000000634828981ULL, 0x000322000c1e1900ULL,
0xfffffff036367812ULL, 0x000fe200078ec0ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0x0001a6a836867810ULL, 0x000fe20007ffe009ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000837868679a7ULL, 0x0004e2000850003fULL, 0x01a64837803479a7ULL, 0x002464000850003fULL,
0x0000000000367805ULL, 0x004fce0000015200ULL, 0x01a64835800075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000003c363f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e37ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a64835800075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002078347824ULL, 0x000fe400078e00ffULL, 0x00000001ff3c7424ULL, 0x000fc600078e00ffULL,
0xffffff8034347812ULL, 0x000fc800078ec0ffULL, 0x0000010009347810ULL, 0x000fc80007ffe034ULL,
0x000000346d347210ULL, 0x000fca0007ffe06cULL, 0x01a0000034367984ULL, 0x000e680000000800ULL,
0x01a2000034357984ULL, 0x0004a20000000800ULL, 0x000000853600720bULL, 0x002fda0003f1d000ULL,
0x00000000003d7806ULL, 0x000fc800000e0100ULL, 0x000000ff3d00720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x00cfea0003800000ULL, 0x000000025a377836ULL, 0x000fe20000000000ULL,
0x000000853600720bULL, 0x000fc80003f14000ULL, 0x000000783700720cULL, 0x000fd20003f45270ULL,
0x00000000003c7806ULL, 0x000fc800000e0100ULL, 0x000000807837a824ULL, 0x000fe200078e0209ULL,
0x000000853634a209ULL, 0x000fe40007810000ULL, 0x000000ff3c00720cULL, 0x000fe40003f05270ULL,
0x000000376d37a210ULL, 0x000fca0007ffe06cULL, 0x01a400343700a388ULL, 0x0003ec0000000800ULL,
0x0000000400548947ULL, 0x000fea0003800000ULL, 0x0000008536347209ULL, 0x002fe40007810000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x0000008534347221ULL, 0x000fe20000010100ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003e7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff377819ULL, 0x000fca000001160aULL, 0x00001f373e347589ULL, 0x006e6400000e0000ULL,
0x0000005434547220ULL, 0x042fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a377811ULL, 0x000fca00078ff0ffULL,
0x00001f373e347589ULL, 0x006e6400000e0000ULL, 0x0000005634567220ULL, 0x042fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a377811ULL, 0x000fca00078ff0ffULL, 0x00001f373e347589ULL, 0x006e6400000e0000ULL,
0x0000000c340c7220ULL, 0x042fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003e83837220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a377811ULL, 0x000fca00078ff0ffULL, 0x00001f373e347589ULL, 0x002e6400000e0000ULL,
0x0000000e340e7220ULL, 0x042fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003c3dff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000008536857209ULL, 0x000fd60007810000ULL, 0x8000008536360221ULL, 0x000fe20000010000ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x004fce0000410000ULL,
0x0000008335837221ULL, 0x000fce0000010000ULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x00000089ff0075a7ULL, 0x000e640008000145ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x00000089ff0075a7ULL, 0x000e640008000145ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000099103c347816ULL, 0x000fe200000000ffULL,
0x0000040078357824ULL, 0x000fe400078e00ffULL, 0x0000001069407824ULL, 0x000fe200078e0284ULL,
0x000000ff3400720cULL, 0x000fe40003f05270ULL, 0xfffff00035807812ULL, 0x000fc800078ec0ffULL,
0x0001400009807810ULL, 0x000fca0007ffe080ULL, 0x000000107f3c7824ULL, 0x100fe400078e0280ULL,
0x000000107e347824ULL, 0x000fe200078e0280ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff367819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000000836027836ULL, 0x000fe20000000000ULL, 0x0000541000357816ULL, 0x000fe20000000000ULL,
0x00000010363e7836ULL, 0x000fe40000000000ULL, 0x0000001836427836ULL, 0x000fe40000000000ULL,
0x00001f0235027589ULL, 0x0002a800000e0000ULL, 0x00001f3e35057589ULL, 0x0002e800000e0000ULL,
0x00001f3635037589ULL, 0x00026800000e0000ULL, 0x00001f4235007589ULL, 0x00026400000e0000ULL,
0x000000003c3c783bULL, 0x002e680000000200ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000107b5c7824ULL, 0x000fe200078e0284ULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x0001600072727836ULL, 0x000fc80000000000ULL,
0x000000005c5c783bULL, 0x000f640000004200ULL, 0x000000ff40607812ULL, 0x068fe400078ec0ffULL,
0x00000010ff927819ULL, 0x100fe40000011640ULL, 0x00000018ff627819ULL, 0x000fe40000011640ULL,
0x0000ffff40907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x004fc4000001165cULL,
0x000000ff5c967812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe4000001165cULL,
0x0000ffff5c7f7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff64723eULL, 0x000fe400020006ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x00000010ff7b7819ULL, 0x000fe2000001165eULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff5e607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001165eULL, 0x0000ffff5e847812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff41657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff947819ULL, 0x000fe4000001165fULL, 0x000000ff42667812ULL, 0x000fc400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff887819ULL, 0x000fe4000001165fULL,
0x0000ffff5f7e7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff917819ULL, 0x100fe40000011641ULL, 0x00000018ff637819ULL, 0x000fc40000011641ULL,
0x0000ffff41937812ULL, 0x000fe400078ec0ffULL, 0x0000005eff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x100fe20000011642ULL,
0x20000060ff5c7230ULL, 0x000fe20000004100ULL, 0x00000018ff417819ULL, 0x000fe20000011642ULL,
0x2000005fff607230ULL, 0x000fe20000004100ULL, 0x0000ffff428a7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000066ff42723eULL, 0x000fe200020006ffULL, 0x20000065ff667230ULL, 0x000fe20000004100ULL,
0x00000018ff957819ULL, 0x100fe20000011643ULL, 0x20000094ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff907819ULL, 0x000fe20000011690ULL, 0x20000042ff657230ULL, 0x000fe20000004100ULL,
0x000000ff91947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x000fc40000011643ULL,
0x0000ffff438d7812ULL, 0x000fe400078ec0ffULL, 0x00000095ff42723eULL, 0x000fe400020006ffULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe20000011693ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000094ff93723eULL, 0x000fc400020006ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe2000001168aULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff947819ULL, 0x000fe4000001168dULL,
0x00000092ff91723eULL, 0x000fe200020006ffULL, 0x20000090ff927230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fc400020006ffULL, 0x00000010ff8e7819ULL, 0x000fe2000001165dULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x0000008fff90723eULL, 0x000fe200020006ffULL,
0x20000095ff8f7230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff43677812ULL, 0x000fe200078ec0ffULL, 0x20000090ff8d7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fc400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x2000008bff907230ULL, 0x000fe20000004100ULL, 0x0000ffff5d897812ULL, 0x040fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff8e957812ULL, 0x000fe200078ec0ffULL, 0x2000008aff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff5d977812ULL, 0x000fe200078ec0ffULL, 0x20000094ff8a7230ULL, 0x000fe20000004100ULL,
0x00000067ff43723eULL, 0x000fe200020006ffULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fc400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000040ff5d723eULL, 0x000fe200020006ffULL,
0x20000041ff407230ULL, 0x000fe20000004100ULL, 0x00000008ff897819ULL, 0x000fe20000011689ULL,
0x20000096ff417230ULL, 0x000fe20000004100ULL, 0x0000008cff8b723eULL, 0x000fe200020006ffULL,
0x20000063ff627230ULL, 0x000fe20000004100ULL, 0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff88947812ULL, 0x000fe200078ec0ffULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe20000011684ULL,
0x2000007fff847230ULL, 0x000fe20000004100ULL, 0x00000008ff7e7819ULL, 0x000fe2000001167eULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000095ff8c723eULL, 0x000fc400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000094ff7f723eULL, 0x000fe400020006ffULL,
0x00000010ff957819ULL, 0x000fe40000011667ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000088ff94723eULL, 0x000fe200020006ffULL,
0x20000089ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe20000011693ULL,
0x2000007bff897230ULL, 0x000fe20000004100ULL, 0x00000097ff43723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000094ff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fe20000011640ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff407819ULL, 0x000fe2000001168dULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff8d7819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fe4000001168aULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff8a7819ULL, 0x000fc4000001168bULL,
0x00000010ff947819ULL, 0x000fe40000011666ULL, 0x00000010ff8b7819ULL, 0x000fe4000001165eULL,
0x0000105491667816ULL, 0x000fe40000000064ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165cULL,
0x00000010ff917819ULL, 0x000fe40000011665ULL, 0x000010545d5c7816ULL, 0x000fc40000000084ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff657819ULL, 0x000fe4000001168fULL,
0x00000010ff847819ULL, 0x000fe40000011660ULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff607819ULL, 0x000fc4000001167bULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff8c7819ULL, 0x000fc4000001168cULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff7b7819ULL, 0x000fe4000001165fULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x0000105462657816ULL, 0x000fc40000000065ULL,
0x0000105440627816ULL, 0x000fe40000000091ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x0000105461607816ULL, 0x000fe40000000060ULL, 0x0000105467677816ULL, 0x000fe40000000094ULL,
0x0000105495647816ULL, 0x000fe40000000092ULL, 0x0000105490637816ULL, 0x000fc40000000063ULL,
0x0000105493407816ULL, 0x000fe2000000008eULL, 0x000000663c54723cULL, 0x002fe20000041854ULL,
0x000010548a427816ULL, 0x000fe4000000008dULL, 0x000010548c437816ULL, 0x000fe40000000043ULL,
0x000010548b5d7816ULL, 0x000fe20000000088ULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x00001054895e7816ULL, 0x000fe4000000005eULL, 0x000010547f5f7816ULL, 0x000fc40000000084ULL,
0x000010547b617816ULL, 0x000fe2000000007eULL, 0x000000623c4c723cULL, 0x000fec000004184cULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005c3c2c723cULL, 0x000fec000004182cULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x00000010703c7824ULL, 0x000fc400078e0280ULL, 0x0000001071807824ULL, 0x000fc600078e0280ULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x000000003c3c783bULL, 0x000e6a0000000200ULL,
0x000000623414723cULL, 0x000fec0000041814ULL, 0x000000403418723cULL, 0x000fec0000041818ULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x000000107d417824ULL, 0x000fca00078e0272ULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x000fe20000041844ULL, 0x000000008034783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000010735c7824ULL, 0x000fe200078e0272ULL, 0x000000004140783bULL, 0x000f6a0000004200ULL,
0x000000005c5c783bULL, 0x000f640000004200ULL, 0x0000ffff418d7812ULL, 0x024fe400078ec0ffULL,
0x00000010ff907819ULL, 0x000fc40000011640ULL, 0x00000010ff8c7819ULL, 0x000fe40000011642ULL,
0x00000010ff8a7819ULL, 0x108fe4000001165cULL, 0x000000ff5c937812ULL, 0x040fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe4000001165cULL, 0x0000ffff5c7f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x000fc4000001165dULL, 0x000000ff5d947812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d807812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e5d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff917819ULL, 0x100fe4000001165fULL,
0x00000010ff7e7819ULL, 0x000fc4000001165fULL, 0x000000ff5f617812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5f7b7812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5f723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff40607812ULL, 0x040fe200078ec0ffULL,
0x2000005fff5c7230ULL, 0x000fe20000004100ULL, 0x0000ffff408e7812ULL, 0x000fe200078ec0ffULL,
0x20000091ff5f7230ULL, 0x000fe20000004100ULL, 0x0000ffff42847812ULL, 0x000fc400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x0000ffff43897812ULL, 0x000fe400078ec0ffULL,
0x00000008ff917819ULL, 0x000fe4000001168dULL, 0x000000ff42647812ULL, 0x000fe400078ec0ffULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x000000ff41637812ULL, 0x000fc400078ec0ffULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8f7819ULL, 0x100fe40000011641ULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x00000060ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x00000008ff847819ULL, 0x000fe20000011684ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000018ff417819ULL, 0x000fc40000011642ULL,
0x000000ff43667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe4000001165eULL,
0x00000018ff607819ULL, 0x000fe4000001165eULL, 0x0000ffff5e7d7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000008ff897819ULL, 0x000fe40000011689ULL, 0x00000064ff42723eULL, 0x000fe400020006ffULL,
0x00000092ff5e723eULL, 0x000fe400020006ffULL, 0x00000090ff8d723eULL, 0x000fe400020006ffULL,
0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe20000011643ULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x0000008cff90723eULL, 0x000fe200020006ffULL,
0x20000091ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff8b927812ULL, 0x000fe200078ec0ffULL,
0x20000063ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff657819ULL, 0x000fe40000011643ULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000066ff43723eULL, 0x000fe200020006ffULL, 0x20000062ff667230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000042ff627230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000043ff637230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fc400020006ffULL, 0x000000ff88917812ULL, 0x000fe200078ec0ffULL,
0x20000090ff887230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000084ff907230ULL, 0x000fe20000004100ULL, 0x00000065ff42723eULL, 0x000fe200020006ffULL,
0x20000089ff847230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x20000041ff657230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x2000008aff897230ULL, 0x000fe20000004100ULL, 0x00000008ff807819ULL, 0x000fe20000011680ULL,
0x20000093ff417230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x20000092ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fe20000011664ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe2000001168eULL,
0x20000091ff8b7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x00000010ff8e7819ULL, 0x000fe40000011663ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000010ff637819ULL, 0x000fe40000011688ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000010ff887819ULL, 0x000fe40000011641ULL, 0x000000ff7e917812ULL, 0x000fe200078ec0ffULL,
0x2000007fff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x20000080ff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe20000011684ULL,
0x20000073ff807230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff7d7819ULL, 0x000fe4000001167dULL, 0x00000008ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000094ff43723eULL, 0x000fe200020006ffULL,
0x20000091ff737230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fc400020006ffULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x0000105489427816ULL, 0x000fe20000000088ULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe2000001165eULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165dULL, 0x00000010ff5d7819ULL, 0x000fc4000001167fULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff847819ULL, 0x000fe4000001165cULL,
0x00000010ff7f7819ULL, 0x000fe40000011680ULL, 0x00000010ff917819ULL, 0x000fe40000011666ULL,
0x00000010ff667819ULL, 0x000fe4000001168dULL, 0x000010545e5d7816ULL, 0x000fc4000000005dULL,
0x00000010ff8d7819ULL, 0x000fe40000011665ULL, 0x00001054895c7816ULL, 0x000fe4000000007eULL,
0x000010547f5e7816ULL, 0x000fe40000000084ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff407819ULL, 0x000fe20000011640ULL, 0x0000005c3c2c723cULL, 0x002fe2000004182cULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff657819ULL, 0x000fe4000001168cULL,
0x00000010ff7f7819ULL, 0x000fe20000011660ULL, 0x0000005c3420723cULL, 0x000fe20000041820ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff7e7819ULL, 0x000fe40000011673ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff607819ULL, 0x000fe4000001167dULL,
0x00000010ff807819ULL, 0x000fe4000001165fULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x0000105466667816ULL, 0x000fe40000000067ULL, 0x0000105440657816ULL, 0x000fe40000000065ULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x000010547e5f7816ULL, 0x000fe40000000061ULL,
0x000010548f677816ULL, 0x000fe40000000092ULL, 0x0000105491647816ULL, 0x000fc40000000064ULL,
0x000010548b637816ULL, 0x000fe2000000008eULL, 0x0000005e3c28723cULL, 0x000fe20000041828ULL,
0x000010548d407816ULL, 0x000fe40000000090ULL, 0x000010548a437816ULL, 0x000fe40000000043ULL,
0x000010547f607816ULL, 0x000fe20000000060ULL, 0x000000663c54723cULL, 0x000fe20000041854ULL,
0x0000105480617816ULL, 0x000fca000000007bULL, 0x000000643c48723cULL, 0x000fec0000041848ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x00000066340c723cULL, 0x000fe2000004180cULL, 0x00000002783c7824ULL, 0x000fc400078e00ffULL,
0x00000001ff3f7424ULL, 0x000fc600078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ec0ffULL,
0x000000643410723cULL, 0x000fe80000041810ULL, 0x00000001093e7824ULL, 0x000fe400078e023cULL,
0x0000003f063c79a7ULL, 0x000262000850003fULL, 0x000000623414723cULL, 0x000fec0000041814ULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x01a6983f3eff79a7ULL, 0x0003ea000850003fULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x002fde0000041844ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000158347836ULL, 0x000fca0000000000ULL, 0x0000006b3400720cULL, 0x000fda0003f06070ULL,
0x0000000400e80947ULL, 0x000fea0003800000ULL, 0x00008e00ff347b82ULL, 0x000e620000000a00ULL,
0x0000000258367836ULL, 0x000fe20000000000ULL, 0x0000850000087ab9ULL, 0x000fe20000000800ULL,
0x0000010081817836ULL, 0x000fe40000000000ULL, 0x0000000882377c24ULL, 0x010fe2000f8e02ffULL,
0x0000006b3600720cULL, 0x000fe40003f06070ULL, 0x0000006081367812ULL, 0x000fe200078ec0ffULL,
0x0000008037377824ULL, 0x000fc800078e00ffULL, 0x0000000159407824ULL, 0x000fe400078e0236ULL,
0x0000008037347825ULL, 0x002fc800078e0034ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x0000008174367248ULL, 0x000fe20007fe0000ULL, 0x0000001078377824ULL, 0x000fe200078e00ffULL,
0x00000003ff3c7819ULL, 0x000fc6000001160aULL, 0x0000000136367824ULL, 0x000fe200078e0a81ULL,
0x0000001037377812ULL, 0x000fe200078ec0ffULL, 0x000000083c417836ULL, 0x000fe40000000000ULL,
0x000000043c3e7836ULL, 0x000fe20000000000ULL, 0x0000003637367248ULL, 0x000fe20007fe0000ULL,
0x0000000c3c427836ULL, 0x000fe40000000000ULL, 0x000000013c3d7824ULL, 0x100fe400078e0237ULL,
0x0000000136367824ULL, 0x000fc400078e0a37ULL, 0x000000013e3f7824ULL, 0x100fe400078e0237ULL,
0x000000083d5f7824ULL, 0x000fe200078e00ffULL, 0x000000364100720cULL, 0x0c0fe20003f46070ULL,
0x0000000141417824ULL, 0x000fe200078e0237ULL, 0x000000363c00720cULL, 0x080fe20003f86070ULL,
0x000000013d3c7824ULL, 0x100fe200078e0240ULL, 0x000000363e00720cULL, 0x080fe20003f66070ULL,
0x000000013f3e7824ULL, 0x000fe200078e0240ULL, 0x000000364200720cULL, 0x000fe20003f06070ULL,
0x000000013d367824ULL, 0x000fc400078e020aULL, 0x00000001413d7824ULL, 0x140fe400078e020aULL,
0x00000008415c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee236ULL,
0x00000001425d7824ULL, 0x000fe400078e0237ULL, 0x000000013f377824ULL, 0x040fe200078e020aULL,
0xfffffff85c637812ULL, 0x000fe200078ee23dULL, 0x000000083f427824ULL, 0x000fe400078e00ffULL,
0x000000803e3e7825ULL, 0x000fc600078e00ffULL, 0xfffffff842617812ULL, 0x000fe200078ee237ULL,
0x000000803c3c7825ULL, 0x000fc800078e00ffULL, 0x0000000141367824ULL, 0x100fe200078e0240ULL,
0x0000006c3e417212ULL, 0x080fe200078efcffULL, 0x000000015d407824ULL, 0x000fe200078e0240ULL,
0x0000006c3c437212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000041343e7210ULL, 0x000fe40007fde0ffULL, 0x00000043343c7210ULL, 0x000fe20007fbe0ffULL,
0x0000008040407825ULL, 0x000fc800078e00ffULL, 0x000000015d427824ULL, 0x040fe200078e020aULL,
0x0000006c40437212ULL, 0x080fe200078efcffULL, 0x000000085d657824ULL, 0x000fe200078e00ffULL,
0x0000006c365d7212ULL, 0x000fe200078efcffULL, 0x00000001353d7824ULL, 0x040fe400028e063dULL,
0x00000001353f7824ULL, 0x000fe200030e063fULL, 0x0000005d34367210ULL, 0x000fe20007fbe0ffULL,
0x000000105f5f7824ULL, 0x100fe200078e0272ULL, 0xfffffff865657812ULL, 0x000fe200078ee242ULL,
0x0000001061617824ULL, 0x100fe200078e0272ULL, 0x0000004334347210ULL, 0x000fe20007fde0ffULL,
0x0000001063637824ULL, 0x000fe200078e0272ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c5f7faeULL, 0x0003e2000e101c46ULL, 0x0000000135377824ULL, 0x000fc400028e0637ULL,
0x0000001065657824ULL, 0x000fe200078e0272ULL, 0x000000003e617faeULL, 0x0003e2000d901c46ULL,
0x0000000135357824ULL, 0x000fc600030e0641ULL, 0x0000000036637faeULL, 0x0003e8000d101c46ULL,
0x0000000034657faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001078367824ULL, 0x000fca00078e00ffULL, 0x0000001036377812ULL, 0x000fc800078ec0ffULL,
0x000000370a377211ULL, 0x000fca00078fe8ffULL, 0x0000000137367824ULL, 0x040fe400078e0240ULL,
0x00000001373c7824ULL, 0x040fe400078e020aULL, 0x0000000837437824ULL, 0x000fe400078e00ffULL,
0x00000004373d7836ULL, 0x000fe40000000000ULL, 0x0000000837417836ULL, 0x000fe20000000000ULL,
0xfffffff843437812ULL, 0x000fe200078ee23cULL, 0x0000000c375d7836ULL, 0x000fc40000000000ULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x000000013d3c7824ULL, 0x040fe400078e0240ULL,
0x000000013d3f7824ULL, 0x040fe400078e020aULL, 0x000000083d5c7824ULL, 0x000fe200078e00ffULL,
0x0000006c363d7212ULL, 0x000fe200078efcffULL, 0x00000001413e7824ULL, 0x040fe400078e0240ULL,
0x0000000141427824ULL, 0x040fe200078e020aULL, 0x0000003d34367210ULL, 0x000fe20007f1e0ffULL,
0x0000000841657824ULL, 0x000fc400078e00ffULL, 0x000000015d417824ULL, 0x040fe400078e020aULL,
0x000000085d5e7824ULL, 0x040fe200078e00ffULL, 0xfffffff865657812ULL, 0x000fe200078ee242ULL,
0x000000015d407824ULL, 0x000fe200078e0240ULL, 0xfffffff85c5d7812ULL, 0x000fe200078ee23fULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff85e677812ULL, 0x000fc600078ee241ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000006c3c5f7212ULL, 0x000fc600078efcffULL,
0x0000008040407825ULL, 0x000fc800078e00ffULL, 0x000000105d637824ULL, 0x100fe200078e0272ULL,
0x0000006c3e5d7212ULL, 0x080fe200078efcffULL, 0x0000001043617824ULL, 0x100fe200078e0272ULL,
0x0000006c40437212ULL, 0x000fe200078efcffULL, 0x0000000135377824ULL, 0x000fe200000e0637ULL,
0x0000005f343c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001065657824ULL, 0x100fe200078e0272ULL,
0x0000005d343e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001067677824ULL, 0x000fe200078e0272ULL,
0x0000004334347210ULL, 0x000fe20007f7e0ffULL, 0x00000001353d7824ULL, 0x040fe200000e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036617faeULL, 0x0003e2000b901c46ULL,
0x00000001353f7824ULL, 0x000fc400010e063fULL, 0x0000000135357824ULL, 0x000fe200018e0641ULL,
0x000000003c637faeULL, 0x0003e8000b901c46ULL, 0x000000003e657faeULL, 0x0003e8000b901c46ULL,
0x0000000034677faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff3d7424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0000003dff3479a7ULL, 0x0002a40008500005ULL,
0x01a6683d083c79a7ULL, 0x0022e4000850003fULL, 0x000000ffff7b7224ULL, 0x006fce00078e0035ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a6683d080075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6683d080075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000805a357824ULL, 0x000fe400078e0209ULL, 0x00000001ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff7e7224ULL, 0x000fe200078e0085ULL, 0x000001806c347810ULL, 0x000fca0007ffe035ULL,
0x000000016d347824ULL, 0x000fca00078e0234ULL, 0x01a0000034367984ULL, 0x000e680000000800ULL,
0x01a2000034357984ULL, 0x0004a20000000800ULL, 0x000000853600720bULL, 0x002fda0003f1d000ULL,
0x00000000003d7806ULL, 0x000fc800000e0100ULL, 0x000000ff3d00720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x004fea0003800000ULL, 0x000000035a377836ULL, 0x000fe20000000000ULL,
0x000000853600720bULL, 0x0c0fe40003f14000ULL, 0x00000085367e7209ULL, 0x000fe40007810000ULL,
0x000000783700720cULL, 0x000fd20003f45270ULL, 0x00000000003c7806ULL, 0x000fc800000e0100ULL,
0x000000807834a824ULL, 0x000fe200078e0209ULL, 0x000000ff3c00720cULL, 0x000fc80003f05270ULL,
0x000000346d6da210ULL, 0x000fca0007ffe06cULL, 0x01a4007e6d00a388ULL, 0x0003e80000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x000000857e347221ULL, 0x000fe20000010100ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x00000034003e7308ULL, 0x0004ec0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff377819ULL, 0x000fca000001160aULL,
0x00001f373e347589ULL, 0x00cea400000e0000ULL, 0x0000005434547220ULL, 0x044fe20000410000ULL,
0x0000005534557220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004c344c7220ULL, 0x040fe20000410000ULL,
0x0000004d344d7220ULL, 0x040fe20000410000ULL, 0x0000005034507220ULL, 0x040fe20000410000ULL,
0x0000005134517220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002434247220ULL, 0x040fe20000410000ULL,
0x0000002534257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a377811ULL, 0x000fca00078ff0ffULL, 0x00001f373e347589ULL, 0x00cea400000e0000ULL,
0x0000005634567220ULL, 0x044fe20000410000ULL, 0x0000005734577220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004e344e7220ULL, 0x040fe20000410000ULL, 0x0000004f344f7220ULL, 0x040fe20000410000ULL,
0x0000005234527220ULL, 0x040fe20000410000ULL, 0x0000005334537220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002634267220ULL, 0x040fe20000410000ULL, 0x0000002734277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a377811ULL, 0x000fca00078ff0ffULL,
0x00001f373e347589ULL, 0x00cea400000e0000ULL, 0x0000000c340c7220ULL, 0x044fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x040fe20000410000ULL, 0x0000003834387220ULL, 0x040fe20000410000ULL,
0x0000003934397220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x000fce0000410000ULL, 0x0000003e83837220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a377811ULL, 0x000fca00078ff0ffULL,
0x00001f373e347589ULL, 0x004ea400000e0000ULL, 0x0000000e340e7220ULL, 0x044fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x040fe20000410000ULL, 0x0000003a343a7220ULL, 0x040fe20000410000ULL,
0x0000003b343b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x000fce0000410000ULL, 0x0000003c3dff7212ULL, 0x000fe200078030ffULL,
0x00000001ff3c7424ULL, 0x000fd800078e00ffULL, 0x000000367e360221ULL, 0x000fe20000010100ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600040308ULL, 0x000ee40000000800ULL, 0x0000000435350220ULL, 0x008fce0000410000ULL,
0x0000008335837221ULL, 0x000fce0000010000ULL, 0x0000000000347805ULL, 0x004fce0000015200ULL,
0x0000000878367824ULL, 0x000fca00078e00ffULL, 0xfffffff036367812ULL, 0x000fca00078ec0ffULL,
0x00000001093f7824ULL, 0x000fc800078e0236ULL, 0x01a6b0873f0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6b0873f0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000016e347812ULL, 0x000fe200078ec0ffULL, 0x00000008793d7824ULL, 0x000fe200078e00ffULL,
0x00000004ff377819ULL, 0x000fe2000001160aULL, 0x000010005a367824ULL, 0x000fe200078e0209ULL,
0x000099103c357816ULL, 0x000fe200000000ffULL, 0x00000008683c7824ULL, 0x000fe400078e00ffULL,
0x0000000434347824ULL, 0x000fe200078e0237ULL, 0x000000ff3500720cULL, 0x000fe20003f05270ULL,
0x0000000478377824ULL, 0x000fe400078e00ffULL, 0x0000000168357824ULL, 0x000fc400078e0234ULL,
0x0000000179347824ULL, 0x000fe200078e0234ULL, 0x00000004377d7812ULL, 0x000fe200078ec0ffULL,
0x0001500036607836ULL, 0x000fe20000000000ULL, 0xfffffff83c357812ULL, 0x000fe400078ee235ULL,
0xfffffff83d377812ULL, 0x000fe200078ee234ULL, 0x0000001069347824ULL, 0x000fe200078e027aULL,
0x000000027d7d7812ULL, 0x000fe200078efcffULL, 0x0000001035357824ULL, 0x100fe400078e0260ULL,
0x0000001037377824ULL, 0x000fe200078e0260ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x0000541000367816ULL, 0x000fe20000000000ULL,
0x00000008033d7836ULL, 0x000fe40000000000ULL, 0x00000018033f7836ULL, 0x000fe40000000000ULL,
0x00001f0536057589ULL, 0x0004e800000e0000ULL, 0x00001f3d36027589ULL, 0x00046800000e0000ULL,
0x00001f0336037589ULL, 0x00046800000e0000ULL, 0x00001f3f36007589ULL, 0x00046400000e0000ULL,
0x00000000355c783bULL, 0x0004e80000000200ULL, 0x000000003740783bULL, 0x0004620000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000035c5c7232ULL, 0x08afe40000200000ULL,
0x000000035e5e7232ULL, 0x000fe40000200000ULL, 0x000000025d5d7232ULL, 0x080fe40000200000ULL,
0x000000025f5f7232ULL, 0x000fe40000200000ULL, 0x0000000540407232ULL, 0x080fe40000200000ULL,
0x0000000542427232ULL, 0x000fc40000200000ULL, 0x0000000041417232ULL, 0x080fe40000200000ULL,
0x0000000043437232ULL, 0x000fce0000200000ULL, 0x0000007d0a7d7211ULL, 0x000fe200078fe0ffULL,
0x00000008683d7824ULL, 0x004fe200078e00ffULL, 0x000000003434783bULL, 0x000ea20000004200ULL,
0x0000001070807824ULL, 0x100fe400078e0260ULL, 0x0000000168687824ULL, 0x000fe400078e027dULL,
0x00000010717f7824ULL, 0x000fc600078e0260ULL, 0xfffffff83d3d7812ULL, 0x000fca00078ee268ULL,
0x000000103d3d7824ULL, 0x000fcc00078e027aULL, 0x000000003d3c783bULL, 0x000f620000004200ULL,
0x00000010ff897819ULL, 0x004fe40000011634ULL, 0x00000018ff627819ULL, 0x100fe40000011635ULL,
0x00000010ff677819ULL, 0x000fe40000011636ULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fe40000011635ULL, 0x000000ff35637812ULL, 0x000fc400078ec0ffULL,
0x0000ffff35877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe40000011637ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000018ff607819ULL, 0x000fe40000011634ULL,
0x000000ff36647812ULL, 0x000fe200078ec0ffULL, 0x20000062ff657230ULL, 0x000fe20000004100ULL,
0x00000018ff357819ULL, 0x000fc40000011636ULL, 0x0000ffff36707812ULL, 0x000fe400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x000000ff378a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff367819ULL, 0x000fe40000011637ULL, 0x0000ffff37867812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c8b7812ULL, 0x028fc400078ec0ffULL, 0x000000ff3d8c7812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000010ff6d7819ULL, 0x102fe4000001163cULL,
0x00000018ff377819ULL, 0x000fe4000001163cULL, 0x0000ffff3c817812ULL, 0x000fe400078ec0ffULL,
0x000000ff34617812ULL, 0x000fc400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe4000001163dULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x100fe4000001163eULL, 0x000000ff3e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fc4000001163eULL, 0x0000ffff3e667812ULL, 0x000fe400078ec0ffULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff3d7819ULL, 0x100fe4000001163fULL, 0x000000ff3f3e7812ULL, 0x000fe200078ec0ffULL,
0x20000060ff697230ULL, 0x000fe20000004100ULL, 0x00000018ff8f7819ULL, 0x000fc4000001163fULL,
0x0000ffff3f717812ULL, 0x000fe400078ec0ffULL, 0x00000008ff707819ULL, 0x000fe40000011670ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000008bff62723eULL, 0x000fe400020006ffULL,
0x0000008cff3f723eULL, 0x000fe200020006ffULL, 0x20000089ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8b7819ULL, 0x000fe20000011687ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x000000ff88887812ULL, 0x000fc400078ec0ffULL, 0x00000072ff89723eULL, 0x000fe200020006ffULL,
0x20000061ff6c7230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe400020006ffULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000070ff72723eULL, 0x000fe200020006ffULL, 0x20000067ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff817819ULL, 0x000fe20000011681ULL, 0x20000035ff617230ULL, 0x000fe20000004100ULL,
0x0000008aff60723eULL, 0x000fc400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x000000ff84677812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000088ff8a723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x000000ff3d3d7812ULL, 0x000fe200078ec0ffULL, 0x2000008aff877230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000086ff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff717819ULL, 0x000fc40000011671ULL, 0x0000008dff35723eULL, 0x000fe200020006ffULL,
0x2000008bff8d7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000072ff8b7230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000081ff867230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000067ff817230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x20000063ff687230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x000000ff6d6d7812ULL, 0x000fc400078ec0ffULL,
0x00000071ff72723eULL, 0x000fe400020006ffULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff717819ULL, 0x000fe4000001168cULL, 0x0000ffff34347812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000066ff67723eULL, 0x000fe200020006ffULL,
0x2000003dff667230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000072ff3d7230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000073ff847230ULL, 0x000fe20000004100ULL, 0x00000008ff857819ULL, 0x000fe20000011685ULL,
0x20000036ff637230ULL, 0x000fe20000004100ULL, 0x0000105471727816ULL, 0x000fe2000000006cULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000008ff347819ULL, 0x000fe20000011634ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fc40000011665ULL,
0x00000010ff717819ULL, 0x000fe4000001168dULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff657819ULL, 0x000fe40000011670ULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011687ULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fc400020006ffULL,
0x00000034ff88723eULL, 0x000fe400020006ffULL, 0x000010546c717816ULL, 0x000fe40000000071ULL,
0x00001054656c7816ULL, 0x000fe20000000064ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000105473737816ULL, 0x000fe40000000068ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff657819ULL, 0x000fc40000011662ULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x00000072400c723cULL, 0x000fe2000004180cULL, 0x0000003eff36723eULL, 0x000fe200020006ffULL,
0x20000037ff3e7230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff647819ULL, 0x000fe20000011663ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe2000001168bULL, 0x000000725c54723cULL, 0x000fe20000041854ULL,
0x00000010ff687819ULL, 0x000fc4000001166dULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000010ff637819ULL, 0x000fe4000001168aULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x2000008eff377230ULL, 0x000fe20000004100ULL, 0x00001054896d7816ULL, 0x000fe40000000060ULL,
0x0000105461627816ULL, 0x000fe20000000062ULL, 0x2000008fff347230ULL, 0x000fe20000004100ULL,
0x0000105468607816ULL, 0x000fc40000000065ULL, 0x0000105464637816ULL, 0x000fe20000000063ULL,
0x0000006c4014723cULL, 0x000fe20000041814ULL, 0x00000010ff617819ULL, 0x000fe4000001163fULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff657819ULL, 0x000fe20000011685ULL,
0x000000624018723cULL, 0x000fe20000041818ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163eULL,
0x00000010ff647819ULL, 0x000fc40000011686ULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x0000006c5c4c723cULL, 0x000fe2000004184cULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x000010543c657816ULL, 0x000fe20000000065ULL,
0x000000625c50723cULL, 0x000fe20000041850ULL, 0x000010543f647816ULL, 0x000fe40000000064ULL,
0x00000010ff3c7819ULL, 0x000fc40000011636ULL, 0x0000105469707816ULL, 0x000fe40000000088ULL,
0x0000105484617816ULL, 0x000fe20000000061ULL, 0x000000644020723cULL, 0x000fe20000041820ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff367819ULL, 0x000fe40000011681ULL,
0x00000010ff3f7819ULL, 0x000fe20000011666ULL, 0x000000704010723cULL, 0x000fe20000041810ULL,
0x00000010ff357819ULL, 0x000fc40000011635ULL, 0x00000010ff687819ULL, 0x000fe40000011667ULL,
0x00000010ff847819ULL, 0x000fe20000011634ULL, 0x00000060401c723cULL, 0x000fe2000004181cULL,
0x00000010ff697819ULL, 0x000fe4000001163dULL, 0x0000105436667816ULL, 0x000fe40000000037ULL,
0x000010543f677816ULL, 0x000fe2000000003cULL, 0x000000705c48723cULL, 0x000fe20000041848ULL,
0x0000105435687816ULL, 0x000fe20000000068ULL, 0x00000000803c783bULL, 0x0002a20000000200ULL,
0x0000105484697816ULL, 0x000fc60000000069ULL, 0x000000664038723cULL, 0x000fe20000041838ULL,
0x000000007f34783bULL, 0x0002ea0000000200ULL, 0x000000605c30723cULL, 0x000fec0000041830ULL,
0x000000645c2c723cULL, 0x000fec000004182cULL, 0x000000665c28723cULL, 0x000fec0000041828ULL,
0x000000685c24723cULL, 0x000fec0000041824ULL, 0x000000684040723cULL, 0x000fe20000041844ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x002fde0003800000ULL,
0x000000033c3c7232ULL, 0x084fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000001797d7824ULL, 0x040fe200078e027dULL, 0x000000007c44783bULL, 0x000e620000004200ULL,
0x00000008795c7824ULL, 0x000fe400078e00ffULL, 0x0000000158587836ULL, 0x000fc60000000000ULL,
0xfffffff85c7d7812ULL, 0x000fca00078ee27dULL, 0x000000107d5c7824ULL, 0x000fcc00078e027aULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000ff44617812ULL, 0x042fe400078ec0ffULL,
0x00000018ff607819ULL, 0x100fe40000011644ULL, 0x00000010ff7f7819ULL, 0x000fe40000011644ULL,
0x0000ffff44857812ULL, 0x000fe400078ec0ffULL, 0x000000ff467c7812ULL, 0x000fe400078ec0ffULL,
0x00000061ff68723eULL, 0x000fc400020006ffULL, 0x00000010ff807819ULL, 0x100fe40000011645ULL,
0x000000ff45447812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011645ULL,
0x0000ffff45877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fe40000011646ULL,
0x00000060ff73723eULL, 0x000fc400020006ffULL, 0x00000010ff697819ULL, 0x128fe4000001165cULL,
0x000000ff5c707812ULL, 0x040fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000018ff457819ULL, 0x000fe4000001165cULL, 0x0000ffff5c667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fe40000011646ULL, 0x0000ffff467a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7d7819ULL, 0x100fe40000011647ULL, 0x000000ff47847812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe40000011647ULL, 0x0000ffff47797812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x000fe4000001165dULL, 0x000000ff5d5c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe4000001165dULL, 0x0000ffff5d657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x000000ff5f477812ULL, 0x040fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe4000001165fULL, 0x0000ffff5f617812ULL, 0x000fe200078ec0ffULL,
0x20000068ff5f7230ULL, 0x000fe20000004100ULL, 0x0000007cff5d723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000044ff6d723eULL, 0x000fe400020006ffULL,
0x00000071ff68723eULL, 0x000fe200020006ffULL, 0x2000005dff717230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x2000006cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fe200078ec0ffULL, 0x20000068ff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe2000001165eULL, 0x20000081ff687230ULL, 0x000fe20000004100ULL,
0x000000ff5e447812ULL, 0x000fc400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe4000001165eULL,
0x0000ffff5e637812ULL, 0x000fe200078ec0ffULL, 0x2000006dff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff5d7819ULL, 0x000fe40000011685ULL, 0x00000084ff6d723eULL, 0x000fe400020006ffULL,
0x00000008ff847819ULL, 0x000fe40000011687ULL, 0x00000080ff81723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x00000084ff85723eULL, 0x000fe200020006ffULL, 0x20000081ff847230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x2000005dff817230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x000000ff7d5d7812ULL, 0x000fe200078ec0ffULL,
0x2000007fff807230ULL, 0x000fe20000004100ULL, 0x00000008ff797819ULL, 0x000fe20000011679ULL,
0x20000085ff7f7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000086ff7d7230ULL, 0x000fe20000004100ULL, 0x00000079ff85723eULL, 0x000fc400020006ffULL,
0x00000070ff86723eULL, 0x000fe200020006ffULL, 0x2000005dff797230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x20000085ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fe20000011680ULL, 0x20000086ff5d7230ULL, 0x000fe20000004100ULL,
0x00000045ff85723eULL, 0x000fe400020006ffULL, 0x00000044ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff7a7819ULL, 0x000fc4000001167aULL, 0x00000010ff457819ULL, 0x000fe2000001165eULL,
0x20000085ff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x0000105480447816ULL, 0x000fe4000000005fULL, 0x00000072ff80723eULL, 0x000fe400020006ffULL,
0x00000010ff727819ULL, 0x000fe40000011673ULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x0000105484457816ULL, 0x000fe40000000045ULL,
0x00000047ff73723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000046ff84723eULL, 0x000fc400020006ffULL, 0x0000105472467816ULL, 0x000fe20000000081ULL,
0x000000443c54723cULL, 0x004fe20000041854ULL, 0x000010547c477816ULL, 0x000fe2000000007fULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000000ff69697812ULL, 0x000fe200078ec0ffULL,
0x20000084ff727230ULL, 0x000fe20000004100ULL, 0x000000ff67677812ULL, 0x000fe200078ec0ffULL,
0x00000044340c723cULL, 0x000fe2000004180cULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff7c7819ULL, 0x000fc40000011679ULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x000000463c48723cULL, 0x000fe20000041848ULL, 0x00000010ff457819ULL, 0x000fe4000001166dULL,
0x00000010ff447819ULL, 0x000fe20000011671ULL, 0x20000080ff717230ULL, 0x000fe20000004100ULL,
0x00000069ff6d723eULL, 0x000fe200020006ffULL, 0x000000463410723cULL, 0x000fe20000041810ULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x000000ff62627812ULL, 0x000fe200078ec0ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fc4000001166cULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff477819ULL, 0x000fe40000011670ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x000010547d447816ULL, 0x000fe20000000044ULL,
0x20000060ff5f7230ULL, 0x000fe20000004100ULL, 0x000010547c457816ULL, 0x000fe20000000045ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000086ff607230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000105469467816ULL, 0x000fe2000000007aULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000105468477816ULL, 0x000fe20000000047ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff637819ULL, 0x000fe20000011663ULL, 0x000000443c4c723cULL, 0x000fe2000004184cULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff617819ULL, 0x000fc40000011661ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x000000443414723cULL, 0x000fe20000041814ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x000000463c50723cULL, 0x000fe20000041850ULL, 0x00000010ff457819ULL, 0x000fe2000001165cULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fe2000001165dULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fe2000001165fULL,
0x000000463418723cULL, 0x000fe20000041818ULL, 0x00000010ff5f7819ULL, 0x000fc40000011665ULL,
0x00000010ff5d7819ULL, 0x000fe40000011662ULL, 0x000010545c5f7816ULL, 0x000fe4000000005fULL,
0x00000010ff477819ULL, 0x000fe4000001165eULL, 0x00000010ff467819ULL, 0x000fe40000011667ULL,
0x00000010ff5e7819ULL, 0x000fe40000011666ULL, 0x0000105446457816ULL, 0x000fc40000000045ULL,
0x00001054475e7816ULL, 0x000fe4000000005eULL, 0x000010545d467816ULL, 0x000fe40000000060ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x0000005e3c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff477819ULL, 0x000fe40000011673ULL,
0x00000010ff5c7819ULL, 0x000fc40000011663ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x0000005e3420723cULL, 0x000fe20000041820ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff5d7819ULL, 0x000fe40000011661ULL, 0x000010546d447816ULL, 0x000fe40000000044ULL,
0x00001054715c7816ULL, 0x000fe4000000005cULL, 0x0000105464477816ULL, 0x000fc40000000047ULL,
0x00001054725d7816ULL, 0x000fe2000000005dULL, 0x000000443c30723cULL, 0x000fec0000041830ULL,
0x000000463c28723cULL, 0x000fec0000041828ULL, 0x0000005c3c24723cULL, 0x000fec0000041824ULL,
0x00000044341c723cULL, 0x000fe2000004181cULL, 0x00000001ff3f7424ULL, 0x000fc800078e00ffULL,
0x0000003f063c79a7ULL, 0x0002a2000850003fULL, 0x000000463438723cULL, 0x000fec0000041838ULL,
0x0000005c3434723cULL, 0x000fe20000041840ULL, 0x000000085a067824ULL, 0x002fc800078e0209ULL,
0x01a6a03f06ff79a7ULL, 0x0003e4000850003fULL, 0x000000ffff407224ULL, 0x004fe200078e003dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff4000989947ULL, 0x002fde000383ffffULL,
0x000000ff6b00720cULL, 0x000fda0003f05270ULL, 0x0000000400648947ULL, 0x000fea0003800000ULL,
0x0180000083007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000db5000047802ULL, 0x000fce0000000f00ULL,
0x000000b000907944ULL, 0x016fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000008300007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000083ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x0000000806057811ULL, 0x042fe400078ff0ffULL, 0x0000001806077811ULL, 0x040fe400078ff0ffULL,
0x00000002ff3d7819ULL, 0x000fe40000011606ULL, 0x00000010063f7811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f3d00047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea800000e0000ULL, 0x00001f3f00067589ULL, 0x000ee800000e0000ULL,
0x00001f0700077589ULL, 0x000f6200000e0000ULL, 0x0000005404547220ULL, 0x042fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x000fe20000410000ULL, 0x0000005605567220ULL, 0x044fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000004a054a7220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004e054e7220ULL, 0x040fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x0000000c060c7220ULL, 0x048fe20000410000ULL,
0x0000000d060d7220ULL, 0x040fe20000410000ULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000001406147220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001806187220ULL, 0x040fe20000410000ULL,
0x0000001906197220ULL, 0x040fe20000410000ULL, 0x0000001c061c7220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000002006207220ULL, 0x040fe20000410000ULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000003806387220ULL, 0x040fe20000410000ULL,
0x0000003906397220ULL, 0x040fe20000410000ULL, 0x0000003406347220ULL, 0x040fe20000410000ULL,
0x0000003506357220ULL, 0x000fe20000410000ULL, 0x0000000e070e7220ULL, 0x060fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000003a073a7220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000000178787812ULL, 0x000fe400078ec0ffULL, 0x000000303130723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000200078097824ULL, 0x000fe200078e0209ULL,
0x0000002c2d2c723eULL, 0x000fc400000010ffULL, 0x000000282928723eULL, 0x000fe400000010ffULL,
0x000000242524723eULL, 0x000fe400000010ffULL, 0x000000565756723eULL, 0x000fe400000010ffULL,
0x0000004a4b4a723eULL, 0x000fe400000010ffULL, 0x0000004e4f4e723eULL, 0x000fe400000010ffULL,
0x000000525352723eULL, 0x000fc400000010ffULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x0000000800057811ULL, 0x048fe400078ff0ffULL,
0x0000000200027812ULL, 0x002fc400078ec0ffULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fe400078ff8ffULL,
0x0000001000057811ULL, 0x040fe200078ff0ffULL, 0x0000000807087824ULL, 0x040fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee203ULL, 0x00000008073c7824ULL, 0x000fe200078e00ffULL,
0x00000018003d7811ULL, 0x000fe200078ff0ffULL, 0x00000008053f7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fc400078ff8ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x000000083d447824ULL, 0x000fe200078e00ffULL, 0x0000003d02057211ULL, 0x000fe200078ff8ffULL,
0x00000008073d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3e7812ULL, 0x000fe200078ee204ULL,
0x0000000203027836ULL, 0x000fe20000000000ULL, 0xfffffff844447812ULL, 0x000fe200078ee205ULL,
0x0000000403057836ULL, 0x000fe20000000000ULL, 0x0000000c0d0c723eULL, 0x000fe200000010ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff83d067812ULL, 0x000fe200078ee202ULL,
0x0000000807027824ULL, 0x000fe200078e00ffULL, 0xfffffff808087812ULL, 0x000fe200078ee205ULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0x0000000804057812ULL, 0x000fc400078ec0ffULL,
0xfffffff802027812ULL, 0x000fe200078ee203ULL, 0x000010006e037824ULL, 0x000fe200078e0209ULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee207ULL, 0x000000141514723eULL, 0x000fe200000010ffULL,
0x000000100a407824ULL, 0x100fe200078e0203ULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x000000103e427824ULL, 0x100fe200078e0203ULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x0000001002047824ULL, 0x100fe200078e0203ULL, 0x000000545502723eULL, 0x000fe200000010ffULL,
0x0000001044447824ULL, 0x100fe200078e0203ULL, 0x000000383938723eULL, 0x000fe200000010ffULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x000000343534723eULL, 0x000fe200000010ffULL,
0x00000010080a7824ULL, 0x100fe200078e0203ULL, 0x0000000e0f0e723eULL, 0x000fe200000010ffULL,
0x000000103c3e7824ULL, 0x000fe200078e0203ULL, 0x000000484903723eULL, 0x000fe200000010ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x000000121307723eULL, 0x000fe200000010ffULL,
0x0000000105407824ULL, 0x040fe200078e0240ULL, 0x0000541002467816ULL, 0x140fe20000000003ULL,
0x0000000105427824ULL, 0x040fe200078e0242ULL, 0x0000763202477816ULL, 0x000fe20000000003ULL,
0x0000000105447824ULL, 0x000fe200078e0244ULL, 0x0000004c4d02723eULL, 0x000fe200000010ffULL,
0x0000000105087824ULL, 0x000fe200078e0206ULL, 0x000000505103723eULL, 0x000fe200000010ffULL,
0x0000004604007388ULL, 0x0003e20000000a00ULL, 0x00000001053c7824ULL, 0x000fe200078e020aULL,
0x000000101106723eULL, 0x000fe200000010ffULL, 0x00000001053e7824ULL, 0x000fe200078e023eULL,
0x0000763202057816ULL, 0x000fc40000000003ULL, 0x00000018190a723eULL, 0x000fe400000010ffULL,
0x000000161716723eULL, 0x000fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fe400000010ffULL,
0x0000541002047816ULL, 0x002fe40000000003ULL, 0x0000541030027816ULL, 0x140fe4000000002cULL,
0x0000763230037816ULL, 0x000fe2000000002cULL, 0x0000000408007388ULL, 0x000fe20000000a00ULL,
0x0000001e1f1e723eULL, 0x000fc400000010ffULL, 0x00000022230f723eULL, 0x000fe200000010ffULL,
0x000000023c007388ULL, 0x0003e20000000a00ULL, 0x0000003a3b3a723eULL, 0x000fe400000010ffULL,
0x00000036371d723eULL, 0x000fe400000010ffULL, 0x00007632160d7816ULL, 0x000fe4000000001aULL,
0x000076321e217816ULL, 0x000fe4000000000fULL, 0x000076323a297816ULL, 0x000fc4000000001dULL,
0x000000ff6e00720cULL, 0x000fe40003f05270ULL, 0x0000541028027816ULL, 0x142fe40000000024ULL,
0x0000763228037816ULL, 0x000fe40000000024ULL, 0x000054103a287816ULL, 0x000fc6000000001dULL,
0x000000023e007388ULL, 0x0003e40000000a00ULL, 0x0000541056027816ULL, 0x142fe4000000004aULL,
0x0000763256037816ULL, 0x000fca000000004aULL, 0x0000000240007388ULL, 0x0003e40000000a00ULL,
0x000054104e027816ULL, 0x142fe40000000052ULL, 0x000076324e037816ULL, 0x000fca0000000052ULL,
0x0004000208007388ULL, 0x0003e40000000a00ULL, 0x0000541032027816ULL, 0x142fe4000000002eULL,
0x0000763232037816ULL, 0x000fca000000002eULL, 0x000400023c007388ULL, 0x0003e40000000a00ULL,
0x000054102a027816ULL, 0x142fe40000000026ULL, 0x000076322a037816ULL, 0x000fca0000000026ULL,
0x000400023e007388ULL, 0x0003e40000000a00ULL, 0x000054100c027816ULL, 0x142fe40000000006ULL,
0x000076320c037816ULL, 0x000fe40000000006ULL, 0x000054100e067816ULL, 0x140fe40000000007ULL,
0x000076320e077816ULL, 0x000fe20000000007ULL, 0x0000000242007388ULL, 0x0003e20000000a00ULL,
0x00005410160c7816ULL, 0x000fc4000000001aULL, 0x0000541014027816ULL, 0x142fe4000000000aULL,
0x0000763214037816ULL, 0x000fca000000000aULL, 0x0008000208007388ULL, 0x0003e40000000a00ULL,
0x000054101c027816ULL, 0x142fe40000000020ULL, 0x000076321c037816ULL, 0x000fe40000000020ULL,
0x000054101e207816ULL, 0x000fc6000000000fULL, 0x000800023c007388ULL, 0x0003e40000000a00ULL,
0x0000541038027816ULL, 0x142fe40000000034ULL, 0x0000763238037816ULL, 0x000fca0000000034ULL,
0x000800023e007388ULL, 0x0003e80000000a00ULL, 0x0000000644007388ULL, 0x000fe80000000a00ULL,
0x000c000c08007388ULL, 0x000fe20000000a00ULL, 0x000000015b027824ULL, 0x002fc600078e0200ULL,
0x000c00203c007388ULL, 0x000fe20000000a00ULL, 0x0000001002037824ULL, 0x000fc600078e0209ULL,
0x000c00283e007388ULL, 0x000fe20000000a00ULL, 0x000000ff00027306ULL, 0x000e620000202400ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000003047984ULL, 0x000e680000000c00ULL,
0x0004000003107984ULL, 0x000ee80000000c00ULL, 0x0008000003187984ULL, 0x000f680000000c00ULL,
0x000c000003207984ULL, 0x000f680000000c00ULL, 0x00100000030c7984ULL, 0x000f680000000c00ULL,
0x0014000003147984ULL, 0x000f680000000c00ULL, 0x00180000031c7984ULL, 0x000f680000000c00ULL,
0x001c000003247984ULL, 0x000f620000000c00ULL, 0x0000000702077230ULL, 0x002fc40000200800ULL,
0x0000000602067230ULL, 0x040fe40000200800ULL, 0x0000000502057230ULL, 0x040fe40000200800ULL,
0x0000000402047230ULL, 0x040fe40000200800ULL, 0x0000001302137230ULL, 0x048fe40000200800ULL,
0x0000001202127230ULL, 0x040fe40000200800ULL, 0x0000001102117230ULL, 0x000fc40000200800ULL,
0x0000001002107230ULL, 0x040fe40000200800ULL, 0x0000001b021b7230ULL, 0x064fe40000200800ULL,
0x0000001a021a7230ULL, 0x040fe40000200800ULL, 0x0000001902197230ULL, 0x040fe40000200800ULL,
0x0000001802187230ULL, 0x040fe40000200800ULL, 0x0000002302237230ULL, 0x000fc40000200800ULL,
0x0000002202227230ULL, 0x040fe40000200800ULL, 0x0000002102217230ULL, 0x040fe40000200800ULL,
0x0000002002027230ULL, 0x000fe40000200800ULL, 0x0000000f07077230ULL, 0x000fe40000200000ULL,
0x0000000e06067230ULL, 0x000fe40000200000ULL, 0x0000000d05057230ULL, 0x000fc40000200000ULL,
0x0000000c04047230ULL, 0x000fe40000200000ULL, 0x0000001713137230ULL, 0x000fe40000200000ULL,
0x0000001612127230ULL, 0x000fe20000200000ULL, 0x0000000403007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000200000ULL, 0x0000001410107230ULL, 0x000fe40000200000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000200000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000200000ULL,
0x0004001003007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000200000ULL,
0x0000001c18187230ULL, 0x000fe40000200000ULL, 0x0000002723237230ULL, 0x000fe40000200000ULL,
0x0000002622227230ULL, 0x000fe20000200000ULL, 0x0008001803007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000200000ULL, 0x0000002402207230ULL, 0x000fca0000200000ULL,
0x000c002003007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff047819ULL, 0x002fe20000011600ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x000000750400720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104027824ULL, 0x000fe200078e0200ULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000a05057299ULL, 0x000fe2000800063fULL,
0x0000000702037812ULL, 0x000fe200078ec0ffULL, 0x0000002000067836ULL, 0x000fc60000000000ULL,
0x0ffffff803027812ULL, 0x000fca00078ef800ULL, 0x0000001002037824ULL, 0x000fe400078e0209ULL,
0x0000002077027824ULL, 0x000fc600078e0204ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff047c19ULL, 0x000fe20008011602ULL,
0x000000040b027c24ULL, 0x000fe4000f8e02ffULL, 0x0000000176057824ULL, 0x000fe200078e0205ULL,
0x0000000700037812ULL, 0x002fc600078ec0ffULL, 0x0000000b04057224ULL, 0x000fe400078e0205ULL,
0x0000000878037824ULL, 0x000fc600078e0203ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff087819ULL, 0x000fe20000011606ULL,
0x0000001003047825ULL, 0x000fc600078e0004ULL, 0x000000750800720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000004000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef803ULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000000176057824ULL, 0x000fe200078e0205ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe400078e0209ULL, 0x0000000b06057224ULL, 0x000fc400078e0205ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x000e640000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x0000006000067836ULL, 0x000fe40000000000ULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0023d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000008000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef803ULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000000176057824ULL, 0x000fe200078e0205ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe400078e0209ULL, 0x0000000b06057224ULL, 0x000fc400078e0205ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x000e640000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x000000a000067836ULL, 0x000fe40000000000ULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0023d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x000000c000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fe400078e0206ULL,
0x000000e000007836ULL, 0x000fe20000000000ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef803ULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000000176057824ULL, 0x000fe200078e0205ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x0000001004077824ULL, 0x000fc400078e0209ULL,
0x0000000b06057224ULL, 0x000fe200078e0205ULL, 0x00000003ff067819ULL, 0x000fe20000011600ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000000100077824ULL, 0x002fc600078e0206ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0xfffffff807087812ULL, 0x000fe400078ef800ULL, 0x0000000c04007986ULL, 0x0043ea000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001008087824ULL, 0x000fe200078e0209ULL,
0x0000000700057812ULL, 0x002fe200078ec0ffULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x00000000080c7984ULL, 0x000e620000000c00ULL, 0x0000000878057824ULL, 0x000fe200078e0205ULL,
0x0000000506037c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fc60008011606ULL,
0x0000000176037824ULL, 0x000fc800078e0203ULL, 0x0000000b06037224ULL, 0x000fca00078e0203ULL,
0x0000000302037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fc600080f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff6a7819ULL, 0x000fe20000011678ULL,
0x00009800ff127b82ULL, 0x000e620000000a00ULL, 0x00000001ff0c7424ULL, 0x000fe400078e00ffULL,
0x0000006f6a00720cULL, 0x000fc80003f06070ULL, 0x01a6000c090c79a7ULL, 0x0004b2000850003fULL,
0x00009400ff028b82ULL, 0x000ee20000000800ULL, 0x00000002070b8824ULL, 0x000fce00078e00ffULL,
0x00009000ff108b82ULL, 0x000f620000000a00ULL, 0x0000000612067981ULL, 0x00252e000c1e9900ULL,
0x00008e00ff0e7b82ULL, 0x000e620000000a00ULL, 0x000000020b0b8224ULL, 0x008fc800078e026aULL,
0x000000040b108825ULL, 0x020fc800078e0010ULL, 0xffffffffff0b7424ULL, 0x000fcc00078e00ffULL,
0x00000006100b8981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x0000008003027824ULL, 0x000fe400078e00ffULL, 0x0000008059037824ULL, 0x000fe400078e00ffULL,
0x0000004078697824ULL, 0x000fca00078e00ffULL, 0x0000004003057812ULL, 0x000fe200078ef869ULL,
0x0000000b020b7224ULL, 0x008fc800078e02ffULL, 0x000000800b0e7825ULL, 0x002fe200078e000eULL,
0x0000000c00200947ULL, 0x004fec0003800000ULL, 0x00000003ff397819ULL, 0x000fe4000001160aULL,
0x0000006974087248ULL, 0x000fc60007fe0000ULL, 0x0000000839197836ULL, 0x000fe40000000000ULL,
0x0000000105107824ULL, 0x000fe400078e0239ULL, 0x0000000119117824ULL, 0x040fe400078e020aULL,
0x0000000819167824ULL, 0x000fe400078e00ffULL, 0x0000000439137836ULL, 0x000fe40000000000ULL,
0x0000001039157836ULL, 0x000fe20000000000ULL, 0xfffffff816277812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x00000001130b7824ULL, 0x140fe200078e020aULL,
0x00000070101d7812ULL, 0x000fe200078ef804ULL, 0x0000000813147824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fe200078e0a69ULL, 0x0000001d0e1c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000115107824ULL, 0x040fe200078e020aULL, 0xfffffff814257812ULL, 0x000fe200078ee20bULL,
0x00000008152b7824ULL, 0x000fe200078e00ffULL, 0x000000081300720cULL, 0x000fe20003fa6070ULL,
0x0000000c391b7836ULL, 0x000fc40000000000ULL, 0x0000000105127824ULL, 0x000fe200078e0213ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL, 0x000000011b0b7824ULL, 0x040fe200078e020aULL,
0x000000081b00720cULL, 0x040fe20003f46070ULL, 0x000000081b147824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff814297812ULL, 0x000fe200078ee20bULL,
0x0000000105107824ULL, 0x000fe200078e0219ULL, 0x0000007012177812ULL, 0x000fe200078ef804ULL,
0x000000010f1d7824ULL, 0x000fe200000e0611ULL, 0x000000081500720cULL, 0x000fe20003f06070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000170e127210ULL, 0x000fc60007f3e0ffULL,
0x0000000105147824ULL, 0x040fe200078e021bULL, 0x00000070101f7812ULL, 0x000fe200078ef804ULL,
0x0000000105167824ULL, 0x000fe400078e0215ULL, 0x0000001439237836ULL, 0x000fe20000000000ULL,
0x0000001f0e1e7210ULL, 0x000fe20007f7e0ffULL, 0x00000018392f7836ULL, 0x000fe40000000000ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007014217812ULL, 0x000fc600078ef804ULL, 0x0000000105187824ULL, 0x040fe200078e0223ULL,
0x00000070160b7812ULL, 0x000fe200078ef804ULL, 0x00000001051a7824ULL, 0x000fe200078e022fULL,
0x000000210e207210ULL, 0x000fe20007f9e0ffULL, 0x000000010f137824ULL, 0x000fe200008e0613ULL,
0x000000081900720cULL, 0x000fe20003f26070ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x000000010f1f7824ULL, 0x040fe200018e0611ULL,
0x0000000b0e147210ULL, 0x000fe20007f7e0ffULL, 0x0000001c39317836ULL, 0x000fe20000000000ULL,
0x0000007018117812ULL, 0x000fe200078ef804ULL, 0x000000010f217824ULL, 0x000fe200020e0615ULL,
0x000000701a0b7812ULL, 0x000fe200078ef804ULL, 0x0000000105107824ULL, 0x000fe400078e0231ULL,
0x000000010f157824ULL, 0x000fe200018e0617ULL, 0x000000110e167210ULL, 0x000fe20007f7e0ffULL,
0x00000001391a7824ULL, 0x000fe200078e020aULL, 0x0000000b0e187210ULL, 0x000fe20007f9e0ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x000000071a2d7812ULL, 0x000fe200078ec0ffULL,
0x00004000780b7824ULL, 0x000fe400078e0209ULL, 0x000000010f177824ULL, 0x000fe200018e0619ULL,
0x000000082300720cULL, 0x080fe20003f66070ULL, 0x000000010f197824ULL, 0x000fe200020e061bULL,
0x00000070101b7812ULL, 0x000fe200078ef804ULL, 0x000020000b267836ULL, 0x000fe20000000000ULL,
0x000000083900720cULL, 0x000fe20003f86070ULL, 0x0000002039337836ULL, 0x000fe20000000000ULL,
0x0000001b0e227210ULL, 0x000fe20007fde0ffULL, 0x00000001230b7824ULL, 0x000fc400078e020aULL,
0x00000008231a7824ULL, 0x000fe200078e00ffULL, 0x0ffffff82d237812ULL, 0x000fe200078ef80aULL,
0x0000000105107824ULL, 0x000fe400078e0233ULL, 0x0000002439357836ULL, 0x000fe20000000000ULL,
0xfffffff81a2d7812ULL, 0x000fe200078ee20bULL, 0x00000010230b7824ULL, 0x000fe400078e0226ULL,
0x000000010f237824ULL, 0x000fe400030e0611ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c0b7faeULL, 0x0003e2000e101c46ULL,
0x000000082f00720cULL, 0x000fc40003f86070ULL, 0x00000001051a7824ULL, 0x000fe200078e0235ULL,
0x00000070101b7812ULL, 0x000fe200078ef804ULL, 0x0000002839377836ULL, 0x000fe40000000000ULL,
0x000000012f107824ULL, 0x040fe200078e020aULL, 0x0000001b0e247210ULL, 0x000fe20007fde0ffULL,
0x000000082f2f7824ULL, 0x000fe400078e00ffULL, 0x000000801a1a7825ULL, 0x000fc600078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee210ULL, 0x0000000105287824ULL, 0x000fe200078e0237ULL,
0x000000701a1d7812ULL, 0x002fe200078ef804ULL, 0x00000010250b7824ULL, 0x000fe400078e0226ULL,
0x000000010f257824ULL, 0x000fe200030e0611ULL, 0x0000001d0e1a7210ULL, 0x000fe20007fde0ffULL,
0x0000008028107825ULL, 0x000fe200078e00ffULL, 0x00000000120b7faeULL, 0x0003e2000e901c46ULL,
0x000000083100720cULL, 0x040fe40003fa6070ULL, 0x00000001311c7824ULL, 0x040fe200078e020aULL,
0x00000070101d7812ULL, 0x000fe200078ef804ULL, 0x00000008313b7824ULL, 0x000fc400078e00ffULL,
0x0000001027277824ULL, 0x100fe400078e0226ULL, 0x0000002c39317836ULL, 0x000fe40000000000ULL,
0x0000001029297824ULL, 0x000fe200078e0226ULL, 0x000000001e277faeULL, 0x000fe2000c901c46ULL,
0x00000001330b7824ULL, 0x042fe200078e020aULL, 0x000000083300720cULL, 0x0c0fe20003f26070ULL,
0x0000000833287824ULL, 0x000fe200078e00ffULL, 0x0000000020297faeULL, 0x0003e2000d101c46ULL,
0x0000000105127824ULL, 0x000fe200078e0231ULL, 0x000000083500720cULL, 0x000fe20003f46070ULL,
0x000000102b2b7824ULL, 0x000fe200078e0226ULL, 0xfffffff8280b7812ULL, 0x000fe200078ee20bULL,
0x000000010f1b7824ULL, 0x000fe200030e061bULL, 0x0000001d0e107210ULL, 0x000fe20007fde0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff83b1d7812ULL, 0x000fe200078ee21cULL,
0x00000000142b7faeULL, 0x0005e4000c101c46ULL, 0x00000001351c7824ULL, 0x000fe200078e020aULL,
0x0000007012337812ULL, 0x000fe200078ef804ULL, 0x0000003039217836ULL, 0x002fc40000000000ULL,
0x000000102d2d7824ULL, 0x100fe400078e0226ULL, 0x0000000835357824ULL, 0x000fe400078e00ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0226ULL, 0x00000000162d7faeULL, 0x0003e2000d901c46ULL,
0x0000000105147824ULL, 0x004fe200078e0221ULL, 0xfffffff8351f7812ULL, 0x000fe200078ee21cULL,
0x000000101d1d7824ULL, 0x100fe200078e0226ULL, 0x00000000182f7faeULL, 0x0005e2000e101c46ULL,
0x000000100b0b7824ULL, 0x000fe200078e0226ULL, 0x000000083100720cULL, 0x080fe20003f86070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000000221d7faeULL, 0x000fe2000e901c46ULL,
0x000000083700720cULL, 0x000fc40003fa6070ULL, 0x000000010f117824ULL, 0x000fe200030e0611ULL,
0x000000330e127210ULL, 0x000fe20007fde0ffULL, 0x0000003439277836ULL, 0x000fe20000000000ULL,
0x00000000240b7faeULL, 0x0007e2000c901c46ULL, 0x000000101f1f7824ULL, 0x000fe200078e0226ULL,
0x000000082100720cULL, 0x080fe20003f66070ULL, 0x0000000105167824ULL, 0x002fe400078e0227ULL,
0x000000010f137824ULL, 0x000fe200030e0613ULL, 0x000000001a1f7faeULL, 0x0003e2000d101c46ULL,
0x0000000137197824ULL, 0x004fe200078e020aULL, 0x000000082700720cULL, 0x000fe20003f46070ULL,
0x00000008371c7824ULL, 0x000fc400078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000070140b7812ULL, 0x008fc600078ef804ULL, 0x0000003839297836ULL, 0x000fe20000000000ULL,
0x0000000b0e187210ULL, 0x000fe20007fde0ffULL, 0x0000003c392b7836ULL, 0x000fe20000000000ULL,
0xfffffff81c1b7812ULL, 0x002fe200078ee219ULL, 0x00000001210b7824ULL, 0x100fe200078e020aULL,
0x000000082900720cULL, 0x080fe20003f26070ULL, 0x000000010f197824ULL, 0x000fe200030e0615ULL,
0x0000007016157812ULL, 0x000fe200078ef804ULL, 0x00000008211a7824ULL, 0x000fe200078e00ffULL,
0x000000082b00720cULL, 0x000fe20003f06070ULL, 0x0000000105147824ULL, 0x000fe200078e0229ULL,
0x000000150e167210ULL, 0x000fe20007fde0ffULL, 0x0000000131087824ULL, 0x040fe200078e020aULL,
0xfffffff81a1f7812ULL, 0x000fe200078ee20bULL, 0x00000008311d7824ULL, 0x000fc400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL,
0x00000001050b7824ULL, 0x000fe200078e022bULL, 0x0000007014057812ULL, 0x000fe200078ef804ULL,
0x0000000127087824ULL, 0x100fe400078e020aULL, 0x00000001291a7824ULL, 0x100fe400078e020aULL,
0x000000012b1c7824ULL, 0x000fe400078e020aULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x000000010f177824ULL, 0x000fe200030e0617ULL, 0x000000050e147210ULL, 0x000fe20007fde0ffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x000000700a217812ULL, 0x000fe200078ef804ULL,
0x0000000829237824ULL, 0x000fe400078e00ffULL, 0x000000082b257824ULL, 0x000fe200078e00ffULL,
0xfffffff827057812ULL, 0x000fe200078ee208ULL, 0x000000010f157824ULL, 0x000fe200030e0615ULL,
0xfffffff823237812ULL, 0x000fe200078ee21aULL, 0x000000101b1b7824ULL, 0x100fe200078e0226ULL,
0xfffffff825257812ULL, 0x000fe200078ee21cULL, 0x000000101d1d7824ULL, 0x100fe200078e0226ULL,
0x000000210e047210ULL, 0x000fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0226ULL,
0x00000000101b7faeULL, 0x0003e2000e901c46ULL, 0x0000001005217824ULL, 0x000fc400078e0226ULL,
0x0000001023237824ULL, 0x100fe200078e0226ULL, 0x00000000121d7faeULL, 0x0003e2000e101c46ULL,
0x0000001025257824ULL, 0x000fe400078e0226ULL, 0x000000010f057824ULL, 0x000fe200030e060bULL,
0x00000000181f7faeULL, 0x0003e8000d901c46ULL, 0x0000000016217faeULL, 0x0003e8000d101c46ULL,
0x0000000014237faeULL, 0x0003e8000c901c46ULL, 0x0000000004257faeULL, 0x0003e2000c101c46ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x000000100a177811ULL, 0x040fe400078fe8ffULL,
0x000000040a107811ULL, 0x040fe400078fe8ffULL, 0x000000080a127811ULL, 0x040fe200078fe8ffULL,
0x0000000117187824ULL, 0x140fe200078e020aULL, 0x0000000c0a137811ULL, 0x040fe200078fe8ffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0x000000200a1f7811ULL, 0x000fe200078fe8ffULL,
0x0000000110087824ULL, 0x100fe200078e020aULL, 0x0000001c0a1d7811ULL, 0x000fe200078fe8ffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0xfffffff819187812ULL, 0x000fe200078ee218ULL,
0x00000001120b7824ULL, 0x100fe200078e020aULL, 0x000000140a197811ULL, 0x000fe200078fe8ffULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0xfffffff815147812ULL, 0x000fe200078ee208ULL,
0x0000000113117824ULL, 0x140fe200078e020aULL, 0x000000180a1b7811ULL, 0x040fe200078fe8ffULL,
0x00000008131a7824ULL, 0x000fe200078e00ffULL, 0xfffffff816157812ULL, 0x000fe200078ee20bULL,
0x0000000119087824ULL, 0x140fe200078e020aULL, 0x0000002c0a257811ULL, 0x040fe200078fe8ffULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0xfffffff81a167812ULL, 0x000fe200078ee211ULL,
0x000000011f207824ULL, 0x140fe200078e020aULL, 0x000000300a2b7811ULL, 0x040fe200078fe8ffULL,
0x000000081f237824ULL, 0x000fe200078e00ffULL, 0xfffffff8211a7812ULL, 0x000fe200078ee208ULL,
0x000000011d117824ULL, 0x140fe200078e020aULL, 0x000000240a217811ULL, 0x040fe200078fe8ffULL,
0x000000081d1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff823207812ULL, 0x000fe200078ee220ULL,
0x000000011b0b7824ULL, 0x100fe200078e020aULL, 0x000000280a237811ULL, 0x040fe200078fe8ffULL,
0x0000000121087824ULL, 0x140fe200078e020aULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee211ULL,
0x0000000821277824ULL, 0x000fe200078e00ffULL, 0x000000340a2d7811ULL, 0x040fe200078fe8ffULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0x000000380a2f7811ULL, 0x040fe200078fe8ffULL,
0x0000000125117824ULL, 0x140fe200078e020aULL, 0xfffffff827227812ULL, 0x000fe200078ee208ULL,
0x00000008252a7824ULL, 0x000fe200078e00ffULL, 0x0000000a0a087211ULL, 0x040fe200078fe8ffULL,
0x0000000823247824ULL, 0x040fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL,
0x00000001230b7824ULL, 0x100fe200078e020aULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL,
0x000000012b267824ULL, 0x140fe200078e020aULL, 0x0000003c0a317811ULL, 0x000fe200078fe8ffULL,
0x000000082b297824ULL, 0x000fe200078e00ffULL, 0x0000000708117812ULL, 0x000fe200078ec0ffULL,
0x0000000105087824ULL, 0x000fe200078e0213ULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x000000012d137824ULL, 0x040fe200078e020aULL, 0xfffffff8292c7812ULL, 0x000fe200078ee226ULL,
0x000000082d367824ULL, 0x000fe200078e00ffULL, 0x000000050a0b7211ULL, 0x000fe200078fe8ffULL,
0x0000000105107824ULL, 0x000fc400078e0210ULL, 0x0000000105127824ULL, 0x040fe400078e0212ULL,
0x0000000105177824ULL, 0x040fe400078e0217ULL, 0x0000000105197824ULL, 0x040fe400078e0219ULL,
0x00000001051b7824ULL, 0x040fe400078e021bULL, 0x00000001051d7824ULL, 0x040fe400078e021dULL,
0x0000000105267824ULL, 0x040fe200078e021fULL, 0xfffffff8361f7812ULL, 0x000fe200078ee213ULL,
0x0000000105277824ULL, 0x000fc400078e0221ULL, 0x0000000105287824ULL, 0x040fe400078e0223ULL,
0x0000000105297824ULL, 0x040fe400078e0225ULL, 0x00000001052e7824ULL, 0x040fe400078e022bULL,
0x0000000105307824ULL, 0x040fe400078e022dULL, 0x0000000105327824ULL, 0x040fe400078e022fULL,
0x0000000105347824ULL, 0x000fe200078e0231ULL, 0x0ffffff811057812ULL, 0x000fe200078ef80aULL,
0x0000000131117824ULL, 0x000fc400078e020aULL, 0x00000008313a7824ULL, 0x000fe400078e00ffULL,
0x0000400078137824ULL, 0x000fe400078e0209ULL, 0x000000012f217824ULL, 0x000fe200078e020aULL,
0xfffffff83a237812ULL, 0x000fe200078ee211ULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x00002000134d7836ULL, 0x000fe20000000000ULL, 0x000000700a257812ULL, 0x000fe200078ef804ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x000000250e0a7210ULL, 0x000fe20007f1e0ffULL,
0x000000082f387824ULL, 0x000fe400078e00ffULL, 0x00000010052f7824ULL, 0x100fe200078e024dULL,
0x0000007010057812ULL, 0x000fe200078ef804ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff838217812ULL, 0x000fe400078ee221ULL, 0x000000050e107210ULL, 0x000fe20007f3e0ffULL,
0x0000001014317824ULL, 0x100fe200078e024dULL, 0x0000007012057812ULL, 0x000fe200078ef804ULL,
0x0000001015337824ULL, 0x000fc400078e024dULL, 0x0000008008147825ULL, 0x000fc800078e00ffULL,
0x000000010f0b7824ULL, 0x000fe200000e060bULL, 0x000000050e127210ULL, 0x000fe20007f1e0ffULL,
0x000000101f497824ULL, 0x100fe200078e024dULL, 0x00000070141f7812ULL, 0x000fe200078ef804ULL,
0x0000001018377824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2f7faeULL, 0x0003e2000b901c46ULL, 0x0000001016357824ULL, 0x000fe400078e024dULL,
0x0000008019187825ULL, 0x000fc800078e00ffULL, 0x0000008017167825ULL, 0x000fc800078e00ffULL,
0x000000101a397824ULL, 0x100fe400078e024dULL, 0x000000101e3d7824ULL, 0x000fe400078e024dULL,
0x000000010f137824ULL, 0x000fe200000e0613ULL, 0x0000001f0e1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000101c3b7824ULL, 0x100fe400078e024dULL, 0x00000010203f7824ULL, 0x100fe400078e024dULL,
0x0000001022417824ULL, 0x000fc400078e024dULL, 0x0000001024437824ULL, 0x100fe400078e024dULL,
0x000000102a457824ULL, 0x100fe400078e024dULL, 0x000000102c477824ULL, 0x100fe400078e024dULL,
0x00000010214b7824ULL, 0x000fe200078e024dULL, 0x0000007016217812ULL, 0x000fe200078ef804ULL,
0x000000801b1a7825ULL, 0x000fc800078e00ffULL, 0x00000010234d7824ULL, 0x000fe200078e024dULL,
0x0000007018237812ULL, 0x000fe200078ef804ULL, 0x000000010f1f7824ULL, 0x040fe200000e0615ULL,
0x000000701a257812ULL, 0x000fe200078ef804ULL, 0x000000010f117824ULL, 0x000fe200008e0611ULL,
0x000000230e227210ULL, 0x000fe20007f1e0ffULL, 0x000000801d147825ULL, 0x000fe200078e00ffULL,
0x000000210e207210ULL, 0x000fe40007f3e0ffULL, 0x000000250e247210ULL, 0x000fe20007f5e0ffULL,
0x000000010f237824ULL, 0x040fe200000e0619ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x000000010f217824ULL, 0x000fc400008e0617ULL, 0x0000008027187825ULL, 0x000fe200078e00ffULL,
0x0000007014277812ULL, 0x000fe200078ef804ULL, 0x0000000012337faeULL, 0x0003e4000b901c46ULL,
0x0000008026167825ULL, 0x000fe200078e00ffULL, 0x000000270e267210ULL, 0x000fe20007f1e0ffULL,
0x000000001e357faeULL, 0x0003e2000b901c46ULL, 0x00000070182b7812ULL, 0x000fe200078ef804ULL,
0x000000010f257824ULL, 0x000fe400010e061bULL, 0x00000080281a7825ULL, 0x000fe200078e00ffULL,
0x0000000020377faeULL, 0x0003e6000b901c46ULL, 0x00000080291c7825ULL, 0x000fe200078e00ffULL,
0x0000007016297812ULL, 0x000fe200078ef804ULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x000000701a2d7812ULL, 0x000fe200078ef804ULL, 0x000000010f277824ULL, 0x040fe200000e0615ULL,
0x000000290e287210ULL, 0x000fe20007f3e0ffULL, 0x000000802e147825ULL, 0x000fe200078e00ffULL,
0x0000002b0e2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x0000002d0e2c7210ULL, 0x000fe20007f5e0ffULL, 0x000000010f297824ULL, 0x040fe200008e0617ULL,
0x000000701c057812ULL, 0x000fe200078ef804ULL, 0x000000010f2b7824ULL, 0x040fe200000e0619ULL,
0x0000007014537812ULL, 0x000fe200078ef804ULL, 0x0000008030167825ULL, 0x000fe200078e00ffULL,
0x000000050e1c7210ULL, 0x000fe20007f1e0ffULL, 0x00000000263d7faeULL, 0x0003e4000b901c46ULL,
0x000000010f2d7824ULL, 0x040fe200010e061bULL, 0x0000007016517812ULL, 0x000fe200078ef804ULL,
0x0000008032187825ULL, 0x000fe200078e00ffULL, 0x00000000283f7faeULL, 0x0003e4000b901c46ULL,
0x000000510e147210ULL, 0x000fe20007f3e0ffULL, 0x00000080341a7825ULL, 0x000fe200078e00ffULL,
0x00000070184f7812ULL, 0x000fe200078ef804ULL, 0x000000002a417faeULL, 0x0003e4000b901c46ULL,
0x000000010f1d7824ULL, 0x000fe200000e061dULL, 0x000000701a057812ULL, 0x000fe200078ef804ULL,
0x000000002c437faeULL, 0x0003e2000b901c46ULL, 0x000000530e047210ULL, 0x000fc40007f1e0ffULL,
0x0000004f0e167210ULL, 0x000fe20007f5e0ffULL, 0x000000001c457faeULL, 0x0003e2000b901c46ULL,
0x000000050e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000010f057824ULL, 0x040fe400000e0615ULL,
0x000000010f157824ULL, 0x040fe400008e0617ULL, 0x000000010f177824ULL, 0x040fe200010e0619ULL,
0x0000000004477faeULL, 0x0003e2000b901c46ULL, 0x000000010f0f7824ULL, 0x000fc600018e061bULL,
0x0000000014497faeULL, 0x0003e8000b901c46ULL, 0x00000000164b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e4d7faeULL, 0x0003e4000b901c46ULL, 0x000000026a6a7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff6d7424ULL, 0x000fc600078e00ffULL,
0x0000006f6a00720cULL, 0x000fda0003f06070ULL, 0x00009400ff088b82ULL, 0x000ea20000000800ULL,
0x00000002070b8824ULL, 0x002fce00078e00ffULL, 0x00009000ff048b82ULL, 0x000e620000000a00ULL,
0x000000080b0b8224ULL, 0x004fc800078e026aULL, 0x000000040b048825ULL, 0x002fca00078e0004ULL,
0x00000006046d8981ULL, 0x000324000c1e1900ULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a6000d090075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a040f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e05ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc8000001140bULL, 0x0000000f08087211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000208087819ULL, 0x000fc8000000120bULL,
0x000000080000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x01a6000d090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002078047824ULL, 0x002fc800078e0205ULL, 0x0000000104087836ULL, 0x000fe20000000000ULL,
0x00000004ff057819ULL, 0x000fc80000011604ULL, 0x0ffffffe050b7812ULL, 0x000fe400078ec0ffULL,
0x0000001f04057812ULL, 0x000fc600078ec0ffULL, 0x000000010b0c7824ULL, 0x000fe400078e0208ULL,
0x00000001040a7824ULL, 0x000fe400078e020bULL, 0x00000010050f7824ULL, 0x040fe200078e00ffULL,
0x0000000f0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00000010050d7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x000000080b0b7836ULL, 0x000fe20000000000ULL,
0x000001f00f0c7812ULL, 0x000fe400078ee20cULL, 0x000001f00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000000108087824ULL, 0x000fc400078e020bULL, 0x000000100c0c7824ULL, 0x100fe400078e0209ULL,
0x000000100a0a7824ULL, 0x000fe200078e0209ULL, 0x0000000f08087812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e020bULL, 0x000000000c107984ULL, 0x000e620000000c00ULL,
0x00000010050b7824ULL, 0x040fe400078e00ffULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x000000000a147984ULL, 0x000ea20000000c00ULL, 0x0000000f04047812ULL, 0x000fc600078ec0ffULL,
0x000001f005087812ULL, 0x000fe400078ee208ULL, 0x000001f00b047812ULL, 0x000fc600078ee204ULL,
0x0000001008087824ULL, 0x100fe400078e0209ULL, 0x0000001004047824ULL, 0x000fe400078e0209ULL,
0x000000ffff1a7224ULL, 0x002fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff187224ULL, 0x004fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fc400078e0016ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0013ULL,
0x000000180a007388ULL, 0x000fe20000000c00ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fca00078e0017ULL, 0x0000001c0c007388ULL, 0x0003e80000000c00ULL,
0x0000000008107984ULL, 0x000ea80000000c00ULL, 0x0000000004147984ULL, 0x000ee20000000c00ULL,
0x00000001ff0c7424ULL, 0x002fe400078e00ffULL, 0x000000ffff237224ULL, 0x004fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff207224ULL, 0x008fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x0000002004007388ULL, 0x0003e80000000c00ULL, 0x0000001008007388ULL, 0x0003e20000000c00ULL,
0x01a6000c090c79a7ULL, 0x0002a4000850003fULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a6000d090075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a040f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e05ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc8000001140bULL, 0x0000000f08087211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000208087819ULL, 0x000fc8000000120bULL,
0x000000080000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x01a6000d090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6b00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009400ff687b82ULL, 0x000e620000000800ULL,
0x0000000000057919ULL, 0x000ea20000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x3db504f306047820ULL, 0x010fe20000410000ULL, 0x0000001f09047890ULL, 0x000fe2000fffe03fULL,
0x0000010069697836ULL, 0x000fe20000000000ULL, 0xffffffff09057890ULL, 0x000fe2000fffe03fULL,
0x0000000878067824ULL, 0x140fe200078e0209ULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x00000020785f7824ULL, 0x000fe200078e0209ULL, 0x0000000909087890ULL, 0x000fe2000fffe03fULL,
0x000000ffff5e7224ULL, 0x000fe200078e00ffULL, 0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL,
0x000000ffff5c7224ULL, 0x000fc400078e00ffULL, 0x0000006807687224ULL, 0x002fe400078e02ffULL,
0x8000000974077c36ULL, 0x000fca0008000000ULL, 0x00000008ff077819ULL, 0x000fce0000011607ULL,
0x00008e00ff0c7b82ULL, 0x002e620000000a00ULL, 0x000000025e087836ULL, 0x000fe40000000000ULL,
0x000001005e0b7824ULL, 0x000fe400078e0269ULL, 0x0000006d026d7224ULL, 0x010fe200078e02ffULL,
0x0000006b0800720cULL, 0x000fe40003f06070ULL, 0x000000400b0a7812ULL, 0x000fe400078ec0ffULL,
0x000000015c087812ULL, 0x000fc600078e0cffULL, 0x00000001030a7824ULL, 0x000fe400078e020aULL,
0x000000806d0c7825ULL, 0x002fc800078e000cULL, 0x0000000c002c8947ULL, 0x000fea0003800000ULL,
0x00000003ff287819ULL, 0x004fe20000011605ULL, 0x00000010051c7824ULL, 0x000fe200078e00ffULL,
0x0000000b740e7248ULL, 0x000fe20007fe0000ULL, 0x00004000785d7824ULL, 0x000fe400078e0209ULL,
0x0000000428107836ULL, 0x000fe20000000000ULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000828127836ULL, 0x000fe40000000000ULL, 0x00000001100f7824ULL, 0x040fe400078e0205ULL,
0x0000000810147824ULL, 0x000fc400078e00ffULL, 0x000000010e1d7824ULL, 0x000fe400078e0a0bULL,
0x00000001280e7824ULL, 0x100fe200078e020aULL, 0xfffffff814297812ULL, 0x000fe200078ee20fULL,
0x00000001120f7824ULL, 0x000fe200078e0205ULL, 0x0000001d1000720cULL, 0x000fe20003fa6070ULL,
0x0000000812147824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fe400078e020aULL,
0x0000001028167836ULL, 0x000fe20000000000ULL, 0xfffffff8142b7812ULL, 0x000fe200078ee20fULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001c0e237212ULL, 0x000fc600078efcffULL, 0x00000008162f7824ULL, 0x000fe200078e00ffULL,
0x0000001c10137212ULL, 0x000fe200078efcffULL, 0x0000000116107824ULL, 0x000fe200078e0205ULL,
0x000000230c227210ULL, 0x000fe20007f1e0ffULL, 0x0000000c28147836ULL, 0x000fe20000000000ULL,
0x000000130c0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001428247836ULL, 0x000fe20000000000ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee210ULL, 0x000000010d237824ULL, 0x040fe200000e060fULL,
0x0000001d1400720cULL, 0x080fe20003f46070ULL, 0x000000010d0f7824ULL, 0x000fe200008e0611ULL,
0x0000001d1200720cULL, 0x0c0fe20003f26070ULL, 0x0000000112107824ULL, 0x100fe200078e020aULL,
0x0000001d1600720cULL, 0x000fe20003f06070ULL, 0x0000000114127824ULL, 0x000fc400078e020aULL,
0x0000000114157824ULL, 0x040fe400078e0205ULL, 0x0000000814187824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff8182d7812ULL, 0x000fe200078ee215ULL,
0x0000000116147824ULL, 0x000fe200078e020aULL, 0x0000001c101b7212ULL, 0x000fe200078efcffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000001b0c167210ULL, 0x000fe20007f7e0ffULL,
0x00000018282a7836ULL, 0x000fe20000000000ULL, 0x0000001c12177212ULL, 0x000fe200078efcffULL,
0x0000000124187824ULL, 0x000fe400078e020aULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000170c1a7210ULL, 0x000fc60007f9e0ffULL, 0x000000012a1e7824ULL, 0x000fe200078e020aULL,
0x0000001c141b7212ULL, 0x000fe200078efcffULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x000000010d177824ULL, 0x040fe200018e0611ULL,
0x0000001c18117212ULL, 0x080fe200078efcffULL, 0x0000001c282e7836ULL, 0x000fe20000000000ULL,
0x0000001b0c107210ULL, 0x000fe20007f7e0ffULL, 0x000000010d1b7824ULL, 0x040fe200020e0613ULL,
0x0000001c1e137212ULL, 0x000fe200078efcffULL, 0x000000012e187824ULL, 0x000fe200078e020aULL,
0x000000110c127210ULL, 0x000fe20007f9e0ffULL, 0x000000010d117824ULL, 0x000fe200018e0615ULL,
0x000000130c147210ULL, 0x000fe20007f7e0ffULL, 0x00002000081e7824ULL, 0x000fc400078e025dULL,
0x000000010d137824ULL, 0x040fe200020e0619ULL, 0x0000001d2800720cULL, 0x080fe20003f86070ULL,
0x000000010d157824ULL, 0x000fe200018e061fULL, 0x0000001d2400720cULL, 0x000fe20003f66070ULL,
0x00000001281f7824ULL, 0x000fe400078e0205ULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0x000000071f207812ULL, 0x000fe200078ec0ffULL, 0x0000002028307836ULL, 0x000fe20000000000ULL,
0x0000001c181f7212ULL, 0x000fe200078efcffULL, 0x000020001e267836ULL, 0x000fe20000000000ULL,
0x0ffffff820277812ULL, 0x000fe200078ef805ULL, 0x0000000130187824ULL, 0x000fe200078e020aULL,
0x0000001f0c1e7210ULL, 0x000fe20007fde0ffULL, 0x0000002428327836ULL, 0x000fe40000000000ULL,
0x0000000124217824ULL, 0x000fe400078e0205ULL, 0x000000010d1f7824ULL, 0x000fc400030e0619ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x0000000824247824ULL, 0x000fe200078e00ffULL,
0x0000001c18257212ULL, 0x000fe200078efcffULL, 0x0000000132207824ULL, 0x000fe400078e020aULL,
0x0000002828347836ULL, 0x000fe20000000000ULL, 0xfffffff824317812ULL, 0x000fe200078ee221ULL,
0x0000001027277824ULL, 0x000fe200078e0226ULL, 0x000000250c247210ULL, 0x000fe20007fde0ffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022277faeULL, 0x0003e2000e101c46ULL, 0x0000000134187824ULL, 0x000fe200078e020aULL,
0x0000001d2a00720cULL, 0x000fe20003f86070ULL, 0x000000010d257824ULL, 0x000fe400030e0619ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000012a2c7824ULL, 0x140fe400078e0205ULL,
0x000000082a337824ULL, 0x000fe200078e00ffULL, 0x0000001c20277212ULL, 0x082fe200078efcffULL,
0x0000001029237824ULL, 0x100fe400078e0226ULL, 0x000000012e227824ULL, 0x040fe200078e0205ULL,
0x000000270c207210ULL, 0x000fe20007fde0ffULL, 0x000000082e357824ULL, 0x000fe200078e00ffULL,
0x0000001c18277212ULL, 0x000fe200078efcffULL, 0x000000000e237faeULL, 0x0003e2000e901c46ULL,
0xfffffff833337812ULL, 0x000fe200078ee22cULL, 0x000000010d217824ULL, 0x000fe200030e0621ULL,
0x000000270c187210ULL, 0x000fe20007fde0ffULL, 0x000000102b277824ULL, 0x100fe200078e0226ULL,
0xfffffff835357812ULL, 0x000fe200078ee222ULL, 0x0000002c282c7836ULL, 0x000fe20000000000ULL,
0x0000001d2e00720cULL, 0x080fe20003fa6070ULL, 0x0000000130227824ULL, 0x040fe200078e0205ULL,
0x0000000016277faeULL, 0x0005e2000c901c46ULL, 0x00000008302b7824ULL, 0x040fe200078e00ffULL,
0x0000001d3000720cULL, 0x000fe20003f26070ULL, 0x000000102d237824ULL, 0x002fc400078e0226ULL,
0x000000012c0e7824ULL, 0x000fe400078e020aULL, 0x00000001322a7824ULL, 0x000fe200078e0205ULL,
0x000000001a237faeULL, 0x0003e2000d101c46ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001d3200720cULL, 0x000fc60003f46070ULL, 0x000000102f177824ULL, 0x104fe200078e0226ULL,
0x0000001c0e297212ULL, 0x000fe200078efcffULL, 0x00000008322d7824ULL, 0x000fe400078e00ffULL,
0x000000010d197824ULL, 0x000fe200030e0619ULL, 0x0000000010177faeULL, 0x0005e2000c101c46ULL,
0x000000290c0e7210ULL, 0x000fe20007fde0ffULL, 0x00000030281a7836ULL, 0x002fe20000000000ULL,
0xfffffff82b297812ULL, 0x000fe200078ee222ULL, 0x00000010311b7824ULL, 0x100fe200078e0226ULL,
0xfffffff82d2b7812ULL, 0x000fe200078ee22aULL, 0x0000001033237824ULL, 0x000fc400078e0226ULL,
0x0000003428227836ULL, 0x000fe20000000000ULL, 0x00000000121b7faeULL, 0x0003e2000d901c46ULL,
0x0000001035277824ULL, 0x000fe200078e0226ULL, 0x0000001d1a00720cULL, 0x0c0fe20003f66070ULL,
0x000000011a107824ULL, 0x004fe200078e020aULL, 0x0000000014237faeULL, 0x0005e2000e101c46ULL,
0x000000010d0f7824ULL, 0x000fe200030e060fULL, 0x0000001d2c00720cULL, 0x080fe20003f86070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000001e277faeULL, 0x0007e2000e901c46ULL,
0x0000001d3400720cULL, 0x000fc40003fa6070ULL, 0x0000001029297824ULL, 0x000fe400078e0226ULL,
0x0000000122127824ULL, 0x002fe400078e020aULL, 0x000000102b2b7824ULL, 0x000fe200078e0226ULL,
0x0000001c10157212ULL, 0x004fe200078efcffULL, 0x00000038282a7836ULL, 0x000fe20000000000ULL,
0x0000000024297faeULL, 0x0003e2000c901c46ULL, 0x0000003c28287836ULL, 0x000fe20000000000ULL,
0x000000150c147210ULL, 0x000fe20007fde0ffULL, 0x0000000134167824ULL, 0x040fe200078e0205ULL,
0x00000000202b7faeULL, 0x0005e2000d101c46ULL, 0x0000000834177824ULL, 0x000fe200078e00ffULL,
0x0000001d2200720cULL, 0x080fe20003f46070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000001d2a00720cULL, 0x000fc40003f26070ULL, 0x0000001d2800720cULL, 0x000fe20003f06070ULL,
0x000000010d157824ULL, 0x000fe200030e0611ULL, 0xfffffff8171d7812ULL, 0x000fe200078ee216ULL,
0x000000012c117824ULL, 0x100fe200078e0205ULL, 0x0000001c12177212ULL, 0x000fe200078efcffULL,
0x000000082c2c7824ULL, 0x000fe400078e00ffULL, 0x000000011a127824ULL, 0x040fe200078e0205ULL,
0x000000170c167210ULL, 0x000fe20007fde0ffULL, 0x000000081a237824ULL, 0x000fe200078e00ffULL,
0xfffffff82c1f7812ULL, 0x008fe200078ee211ULL, 0x000000012a107824ULL, 0x000fc400078e020aULL,
0x000000010d177824ULL, 0x000fe200030e0613ULL, 0xfffffff823237812ULL, 0x000fe200078ee212ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000128127824ULL, 0x000fe200078e020aULL,
0x0000001c101b7212ULL, 0x000fe200078efcffULL, 0x00000001221a7824ULL, 0x000fe400078e0205ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001b0c107210ULL, 0x000fc60007fde0ffULL,
0x0000000822257824ULL, 0x002fe200078e00ffULL, 0x0000001c12217212ULL, 0x004fe200078efcffULL,
0x000000012a0a7824ULL, 0x140fe400078e0205ULL, 0x000000082a277824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee21aULL, 0x00000001281e7824ULL, 0x040fe400078e0205ULL,
0x0000000828297824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x000000010d117824ULL, 0x000fe200030e0611ULL, 0x000000210c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000101d1b7824ULL, 0x100fe200078e0226ULL, 0xfffffff829297812ULL, 0x000fe200078ee21eULL,
0x000000101f1d7824ULL, 0x000fc400078e0226ULL, 0x00000010231f7824ULL, 0x100fe200078e0226ULL,
0x00000000181b7faeULL, 0x0003e2000e901c46ULL, 0x0000001025217824ULL, 0x100fe400078e0226ULL,
0x0000001027237824ULL, 0x100fe200078e0226ULL, 0x000000000e1d7faeULL, 0x0003e2000e101c46ULL,
0x0000001029257824ULL, 0x000fe400078e0226ULL, 0x000000010d0d7824ULL, 0x000fe200030e0613ULL,
0x00000000141f7faeULL, 0x0003e8000d901c46ULL, 0x0000000016217faeULL, 0x0003e8000d101c46ULL,
0x0000000010237faeULL, 0x0003e8000c901c46ULL, 0x000000000c257faeULL, 0x0003e2000c101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x0000000405107811ULL, 0x044fe200078fe8ffULL,
0x00004000785d7824ULL, 0x000fe200078e0209ULL, 0x0000000805127811ULL, 0x040fe400078fe8ffULL,
0x0000001405187811ULL, 0x040fe200078fe8ffULL, 0x00000001100e7824ULL, 0x140fe200078e0205ULL,
0x00000018051a7811ULL, 0x040fe200078fe8ffULL, 0x0000000810117824ULL, 0x000fe200078e00ffULL,
0x0000000c05147811ULL, 0x040fe200078fe8ffULL, 0x00000001120f7824ULL, 0x140fe200078e0205ULL,
0x0000001005167811ULL, 0x040fe200078fe8ffULL, 0x0000000812287824ULL, 0x000fe200078e00ffULL,
0xfffffff811267812ULL, 0x000fe200078ee20eULL, 0x0000000118117824ULL, 0x140fe200078e0205ULL,
0x00000024051f7811ULL, 0x040fe200078fe8ffULL, 0x0000000818347824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee20fULL, 0x000000011a137824ULL, 0x140fe200078e0205ULL,
0x0000002805207811ULL, 0x040fe200078fe8ffULL, 0x000000081a367824ULL, 0x000fe200078e00ffULL,
0x0000001c051c7811ULL, 0x040fe200078fe8ffULL, 0x00000001140e7824ULL, 0x140fe200078e0205ULL,
0x00000020051e7811ULL, 0x000fe200078fe8ffULL, 0x0000000814157824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee211ULL, 0x00000001160f7824ULL, 0x140fe200078e0205ULL,
0xfffffff836367812ULL, 0x000fe200078ee213ULL, 0x00000008162c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8152a7812ULL, 0x000fe200078ee20eULL, 0x000000011f117824ULL, 0x100fe200078e0205ULL,
0x0000003405307811ULL, 0x000fe200078fe8ffULL, 0x000000081f3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20fULL, 0x0000000120137824ULL, 0x140fe200078e0205ULL,
0x0000003805327811ULL, 0x040fe200078fe8ffULL, 0x00000008203e7824ULL, 0x000fe200078e00ffULL,
0x0000002c05227811ULL, 0x040fe200078fe8ffULL, 0x000000011c0e7824ULL, 0x140fe200078e0205ULL,
0x00000030052e7811ULL, 0x000fe200078fe8ffULL, 0x000000081c157824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x000000011e0f7824ULL, 0x140fe200078e0205ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x000000081e3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff815387812ULL, 0x000fe200078ee20eULL, 0x0000000130117824ULL, 0x000fc400078e0205ULL,
0x0000000830447824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL,
0x0000000132137824ULL, 0x140fe400078e0205ULL, 0x0000000832467824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee211ULL, 0x00000001220e7824ULL, 0x140fe400078e0205ULL,
0x0000000822157824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee213ULL,
0x000000012e0f7824ULL, 0x140fe200078e0205ULL, 0x0000003c05137811ULL, 0x040fe200078fe8ffULL,
0x000000082e427824ULL, 0x000fe200078e00ffULL, 0xfffffff815407812ULL, 0x000fe200078ee20eULL,
0x0000001005117824ULL, 0x040fe200078e00ffULL, 0x0000000a050e7211ULL, 0x000fe200078fe8ffULL,
0x0000000113157824ULL, 0x040fe200078e0205ULL, 0xfffffff842427812ULL, 0x000fe200078ee20fULL,
0x0000000813487824ULL, 0x000fe200078e00ffULL, 0x00000005050f7211ULL, 0x000fe200078fe8ffULL,
0x0000000110107824ULL, 0x000fe200078e020aULL, 0x00000070114f7812ULL, 0x000fe200078ec0ffULL,
0x0000200008117824ULL, 0x000fe200078e025dULL, 0x000000070f247812ULL, 0x000fe200078ec0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fc400078ee215ULL,
0x0ffffff824247812ULL, 0x000fe200078ef805ULL, 0x00002000114d7836ULL, 0x000fe20000000000ULL,
0x0000004f0e157212ULL, 0x000fe200078efcffULL, 0x0000000112127824ULL, 0x000fe400078e020aULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000150c0e7210ULL, 0x000fc60007f1e0ffULL,
0x0000000114147824ULL, 0x100fe200078e020aULL, 0x0000004f10157212ULL, 0x000fe200078efcffULL,
0x0000000116167824ULL, 0x100fe400078e020aULL, 0x0000000118187824ULL, 0x100fe200078e020aULL,
0x000000150c107210ULL, 0x000fe20007f3e0ffULL, 0x000000011a1a7824ULL, 0x100fe400078e020aULL,
0x000000011c1c7824ULL, 0x100fe400078e020aULL, 0x000000011e1e7824ULL, 0x000fc400078e020aULL,
0x000000011f1f7824ULL, 0x100fe400078e020aULL, 0x0000000120207824ULL, 0x100fe400078e020aULL,
0x0000000122227824ULL, 0x100fe400078e020aULL, 0x000000012e2e7824ULL, 0x100fe400078e020aULL,
0x0000000130307824ULL, 0x100fe400078e020aULL, 0x0000000132327824ULL, 0x000fc400078e020aULL,
0x00000001130a7824ULL, 0x000fe400078e020aULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004f12197212ULL, 0x000fc600078efcffULL,
0x000000010d0f7824ULL, 0x000fe200000e060fULL, 0x000000190c127210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004f141d7212ULL, 0x000fc600078efcffULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x000000010d137824ULL, 0x040fe200000e0613ULL,
0x0000001d0c147210ULL, 0x000fe20007f1e0ffULL, 0x00000010242f7824ULL, 0x000fe200078e024dULL,
0x0000004f181d7212ULL, 0x080fe200078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004f1a257212ULL, 0x000fe400078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e2f7faeULL, 0x0003e2000b901c46ULL, 0x000000010d157824ULL, 0x000fe200000e0615ULL,
0x0000001d0c187210ULL, 0x000fe20007f1e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000250c247210ULL, 0x000fc40007f5e0ffULL, 0x0000004f16217212ULL, 0x080fe200078efcffULL,
0x000000010d117824ULL, 0x040fe200008e0611ULL, 0x0000004f1c277212ULL, 0x000fe200078efcffULL,
0x000000010d257824ULL, 0x000fe200010e061bULL, 0x000000210c167210ULL, 0x000fe20007f3e0ffULL,
0x000000801e1a7825ULL, 0x000fc800078e00ffULL, 0x000000801f1e7825ULL, 0x000fe200078e00ffULL,
0x0000004f1a297212ULL, 0x000fc600078efcffULL, 0x0000001026317824ULL, 0x000fe200078e024dULL,
0x0000004f1e2b7212ULL, 0x080fe200078efcffULL, 0x000000010d197824ULL, 0x000fe200000e0619ULL,
0x000000270c267210ULL, 0x000fe20007f1e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000010317faeULL, 0x0003e6000b901c46ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000004f202d7212ULL, 0x000fc600078efcffULL, 0x0000001028337824ULL, 0x100fe400078e024dULL,
0x000000102a357824ULL, 0x000fe400078e024dULL, 0x000000010d177824ULL, 0x040fe200008e0617ULL,
0x000000290c287210ULL, 0x000fe20007f3e0ffULL, 0x000000010d277824ULL, 0x040fe200000e061dULL,
0x0000002b0c2a7210ULL, 0x000fe20007f1e0ffULL, 0x000000102c377824ULL, 0x000fe200078e024dULL,
0x0000004f221d7212ULL, 0x080fe200078efcffULL, 0x000000010d297824ULL, 0x040fe200008e061bULL,
0x0000002d0c2c7210ULL, 0x000fe20007f5e0ffULL, 0x000000010d2b7824ULL, 0x040fe200000e061fULL,
0x0000001d0c227210ULL, 0x000fe20007f1e0ffULL, 0x000000802e1a7825ULL, 0x000fe200078e00ffULL,
0x0000000012337faeULL, 0x0003e6000b901c46ULL, 0x00000080301c7825ULL, 0x000fe200078e00ffULL,
0x0000004f1a557212ULL, 0x080fe200078efcffULL, 0x0000000014357faeULL, 0x0003e4000b901c46ULL,
0x000000010d2d7824ULL, 0x000fe200010e0621ULL, 0x0000004f1c537212ULL, 0x080fe200078efcffULL,
0x00000080321e7825ULL, 0x000fe200078e00ffULL, 0x0000000016377faeULL, 0x0003e4000b901c46ULL,
0x000000530c1c7210ULL, 0x000fe20007f3e0ffULL, 0x000000800a207825ULL, 0x000fe200078e00ffULL,
0x0000004f1e517212ULL, 0x000fc600078efcffULL, 0x0000001034397824ULL, 0x100fe200078e024dULL,
0x0000004f204f7212ULL, 0x000fe200078efcffULL, 0x00000010363b7824ULL, 0x000fe200078e024dULL,
0x000000510c1e7210ULL, 0x000fe20007f5e0ffULL, 0x000000010d237824ULL, 0x000fe200000e0623ULL,
0x000000550c1a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010383d7824ULL, 0x100fe200078e024dULL,
0x0000004f0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000103a3f7824ULL, 0x100fe200078e024dULL,
0x0000000018397faeULL, 0x0003e2000b901c46ULL, 0x000000103c417824ULL, 0x000fc400078e024dULL,
0x000000103e437824ULL, 0x100fe200078e024dULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x0000001040457824ULL, 0x100fe400078e024dULL, 0x0000001042477824ULL, 0x000fe200078e024dULL,
0x00000000263d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d1b7824ULL, 0x040fe400000e061bULL,
0x0000001044497824ULL, 0x000fe200078e024dULL, 0x00000000283f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d1d7824ULL, 0x000fc400008e061dULL, 0x00000010464b7824ULL, 0x000fe200078e024dULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x000000010d1f7824ULL, 0x040fe400010e061fULL,
0x00000010484d7824ULL, 0x000fe200078e024dULL, 0x000000002c437faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e0621ULL, 0x0000000022457faeULL, 0x0003e8000b901c46ULL,
0x000000001a477faeULL, 0x0003e8000b901c46ULL, 0x000000001c497faeULL, 0x0003e8000b901c46ULL,
0x000000001e4b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c4d7faeULL, 0x0003e4000b901c46ULL,
0x000000026a6a7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff6d7424ULL, 0x000fc600078e00ffULL, 0x0000006f6a00720cULL, 0x000fda0003f06070ULL,
0x00009000ff0c8b82ULL, 0x002e620000000a00ULL, 0x00000002680f8824ULL, 0x000fe200078e026aULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000040f0c8825ULL, 0x002fe200078e000cULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fc4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000000060c6d8981ULL, 0x000322000c1e1900ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000000000c7805ULL, 0x002fce000001ff00ULL,
0xfffffff805147812ULL, 0x040fe200078ec0ffULL, 0x000020005c6c7824ULL, 0x000fe200078e025dULL,
0x00000004ff197819ULL, 0x000fe20000011605ULL, 0x000000010a6e7836ULL, 0x000fe20000000000ULL,
0x0000000714157812ULL, 0x000fe200078ef805ULL, 0x000020006c6c7836ULL, 0x000fe20000000000ULL,
0x0000000805167812ULL, 0x000fe200078ec0ffULL, 0x0000002005187836ULL, 0x000fe40000000000ULL,
0x0000000115147824ULL, 0x040fe200078e020aULL, 0x00000007161a7812ULL, 0x000fe200078ef805ULL,
0x0000000815177824ULL, 0x040fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ec0ffULL,
0x0000000115167824ULL, 0x040fe200078e026eULL, 0x000000101a707812ULL, 0x040fe200078efcffULL,
0x000000101a1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee214ULL,
0x000000020a147824ULL, 0x000fe200078e0219ULL, 0x0000000718757812ULL, 0x000fe200078ef805ULL,
0x0000000815197824ULL, 0x000fc400078e00ffULL, 0x0000001017177824ULL, 0x000fe400078e026cULL,
0x000000011a157824ULL, 0x000fe400078e0214ULL, 0x0000001070187824ULL, 0x000fe200078e00ffULL,
0x000000001760783bULL, 0x0002a20000000200ULL, 0x000000101a1b7824ULL, 0x000fe400078e00ffULL,
0x00000001756e7824ULL, 0x000fe200078e026eULL, 0xfffffff819177812ULL, 0x002fe200078ee216ULL,
0x0000000214197836ULL, 0x000fe20000000000ULL, 0xfffffff01c167812ULL, 0x000fe200078ee215ULL,
0x0000000170157824ULL, 0x000fc400078e0214ULL, 0x0000001017647824ULL, 0x000fe400078e026cULL,
0x0000000175177824ULL, 0x040fe200078e020aULL, 0xfffffff018187812ULL, 0x000fe200078ee215ULL,
0x00000008751c7824ULL, 0x000fe400078e00ffULL, 0x000000006464783bULL, 0x000e620000000200ULL,
0x0000001016167824ULL, 0x100fe400078e0209ULL, 0x0000001018187824ULL, 0x000fe200078e0209ULL,
0xfffffff81c177812ULL, 0x000fe200078ee217ULL, 0x000000011a1a7824ULL, 0x100fe200078e0219ULL,
0x000000001658783bULL, 0x000ee20000000200ULL, 0x0000000170197824ULL, 0x000fc400078e0219ULL,
0x0000001070707824ULL, 0x000fe200078e00ffULL, 0x00000000181c783bULL, 0x000ae20000000200ULL,
0xfffffff01b1a7812ULL, 0x000fe200078ee21aULL, 0x000000020a0a7836ULL, 0x000fc80000000000ULL,
0x000000101a1a7824ULL, 0x000fe200078e0209ULL, 0x000000080a00780cULL, 0x000fe40003f05270ULL,
0xfffffff070187812ULL, 0x020fe200078ee219ULL, 0x0000001017707824ULL, 0x000fe200078e026cULL,
0x00000010ff147819ULL, 0x104fe40000011663ULL, 0x00000018ff157819ULL, 0x000fe40000011663ULL,
0x000000ff14147812ULL, 0x000fe200078ec0ffULL, 0x000000007070783bULL, 0x000ea20000000200ULL,
0x00000015ff15723eULL, 0x000fc400020006ffULL, 0x00000014ff14723eULL, 0x000fe400020006ffULL,
0x0000ffff631b7812ULL, 0x040fe200078ec0ffULL, 0x20000015ff167230ULL, 0x000fe20000004100ULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x20000014ff157230ULL, 0x000fe20000004100ULL,
0x00000008ff147819ULL, 0x000fe4000001161bULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fc400020006ffULL, 0x00000010ff167819ULL, 0x000fe20000011616ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff157819ULL, 0x000fe20000011615ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x0000ffff677b7812ULL, 0x002fe400078ec0ffULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff767819ULL, 0x000fe40000011614ULL,
0x0000105416777816ULL, 0x000fe20000000015ULL, 0x0000001018157824ULL, 0x000fe200078e0209ULL,
0x0000105476767816ULL, 0x000fe20000000063ULL, 0x000000001a18783bULL, 0x000fe20000000200ULL,
0x00000018ff637819ULL, 0x000fc40000011667ULL, 0x000000ff64947812ULL, 0x000fe200078ec0ffULL,
0x000000001514783bULL, 0x000fe20000000200ULL, 0x00000063ff79723eULL, 0x000fe200020006ffULL,
0x000000765810723cULL, 0x008fe20000041810ULL, 0x00000010ff637819ULL, 0x000fe40000011667ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000079ff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff63797812ULL, 0x000fe200078ec0ffULL, 0x000000761c0c723cULL, 0x000fe2000004180cULL,
0x00000008ff637819ULL, 0x000fc4000001167bULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000000875777824ULL, 0x000fe200078e00ffULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x004fe20000011671ULL, 0x20000063ff757230ULL, 0x000fe20000004100ULL,
0xfffffff877637812ULL, 0x000fe200078ee26eULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fc40000011667ULL, 0x00000010ff6e7819ULL, 0x000fe20000011675ULL,
0x00000010637c7824ULL, 0x000fe200078e026cULL, 0x00000018ff757819ULL, 0x000fe40000011664ULL,
0x000010546e767816ULL, 0x000fe40000000067ULL, 0x000000ff606e7812ULL, 0x000fe200078ec0ffULL,
0x000000007c7c783bULL, 0x000e620000000200ULL, 0x00000075ff9a723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fc400020006ffULL, 0x00000010ff777819ULL, 0x000fe40000011679ULL,
0x00000018ff7b7819ULL, 0x000fe20000011671ULL, 0x2000006eff997230ULL, 0x000fe20000004100ULL,
0x000000ff718d7812ULL, 0x040fe200078ec0ffULL, 0x2000009aff6e7230ULL, 0x000fe20000004100ULL,
0x0000ffff71987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff937819ULL, 0x100fe40000011672ULL,
0x00000018ff8f7819ULL, 0x000fc40000011672ULL, 0x000000ff728e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff72957812ULL, 0x000fe400078ec0ffULL, 0x0000ffff609a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff967819ULL, 0x100fe40000011673ULL, 0x00000018ff717819ULL, 0x000fe40000011673ULL,
0x000000ff73727812ULL, 0x000fc400078ec0ffULL, 0x0000ffff73977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff737819ULL, 0x000fe40000011664ULL, 0x0000ffff648c7812ULL, 0x000fe400078ec0ffULL,
0x00000094ff75723eULL, 0x000fe400020006ffULL, 0x00000018ff647819ULL, 0x000fe40000011666ULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x002fc4000001167dULL, 0x00000018ff8b7819ULL, 0x000fe4000001167dULL,
0x000000ff7d8a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7d817812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x000fe40000011660ULL, 0x000000ff66927812ULL, 0x000fe400078ec0ffULL,
0x000000ff7d947812ULL, 0x000fc400078ec0ffULL, 0x00000008ff7d7819ULL, 0x000fe4000001169aULL,
0x00000018ff637819ULL, 0x000fe40000011670ULL, 0x00000064ff9a723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x000010547a777816ULL, 0x000fe40000000077ULL,
0x00000092ff64723eULL, 0x000fc400020006ffULL, 0x00000063ff92723eULL, 0x000fe200020006ffULL,
0x2000009aff637230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x2000007dff9a7230ULL, 0x000fe20000004100ULL, 0x00000018ff9b7819ULL, 0x100fe20000011665ULL,
0x000000761810723cULL, 0x000fe20000041810ULL, 0x0000008fff7d723eULL, 0x000fe200020006ffULL,
0x2000008dff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x000fe20000011665ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x00000076140c723cULL, 0x000fe2000004180cULL, 0x0000009bff9b723eULL, 0x000fe200020006ffULL,
0x2000007dff8d7230ULL, 0x000fe20000004100ULL, 0x00000018ff6c7819ULL, 0x000fc40000011660ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x2000009bff607230ULL, 0x000fe20000004100ULL,
0x000000ff70777812ULL, 0x000fe400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x20000094ff9b7230ULL, 0x000fe20000004100ULL, 0x00000008ff8c7819ULL, 0x000fe2000001168cULL,
0x20000092ff947230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe40000011670ULL,
0x000000ff807d7812ULL, 0x000fc400078ec0ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000ffff70707812ULL, 0x000fe400078ec0ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000010ff7a7819ULL, 0x000fe40000011666ULL, 0x0000ffff66767812ULL, 0x000fe200078ec0ffULL,
0x20000077ff927230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x000000ff65677812ULL, 0x040fe400078ec0ffULL, 0x0000006cff66723eULL, 0x000fe200020006ffULL,
0x20000071ff777230ULL, 0x000fe20000004100ULL, 0x0000008cff80723eULL, 0x000fe200020006ffULL,
0x20000072ff8c7230ULL, 0x000fe20000004100ULL, 0x0000ffff65657812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000007dff9c723eULL, 0x000fe200020006ffULL,
0x20000073ff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff91917812ULL, 0x000fe200078ec0ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff727819ULL, 0x000fc40000011670ULL,
0x00000010ff707819ULL, 0x000fe40000011699ULL, 0x00000010ff737819ULL, 0x000fe4000001169aULL,
0x00000008ff717819ULL, 0x000fe20000011665ULL, 0x2000009cff657230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x0000105473707816ULL, 0x000fc40000000070ULL, 0x000000ff90737812ULL, 0x000fe200078ec0ffULL,
0x20000091ff907230ULL, 0x000fe20000004100ULL, 0x00000071ff9c723eULL, 0x000fe200020006ffULL,
0x20000072ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff717819ULL, 0x000fe4000001169bULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000018ff727819ULL, 0x000fc40000011661ULL, 0x0000105466717816ULL, 0x000fe20000000071ULL,
0x2000009cff667230ULL, 0x000fe20000004100ULL, 0x00000008ff997819ULL, 0x000fe40000011698ULL,
0x000000ff93987812ULL, 0x000fe200078ec0ffULL, 0x20000073ff937230ULL, 0x000fe20000004100ULL,
0x00000072ff9b723eULL, 0x000fe200020006ffULL, 0x000000705854723cULL, 0x000fe20000041854ULL,
0x00000010ff737819ULL, 0x000fe40000011661ULL, 0x000000ff619a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff619d7812ULL, 0x000fe200078ec0ffULL, 0x000000701c50723cULL, 0x000fe20000041850ULL,
0x00000018ff617819ULL, 0x100fe40000011662ULL, 0x00000010ff727819ULL, 0x000fe40000011662ULL,
0x000000ff629c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff62717812ULL, 0x000fe200078ec0ffULL,
0x2000009bff707230ULL, 0x000fe20000004100ULL, 0x0000009aff9a723eULL, 0x000fc400020006ffULL,
0x00000061ff62723eULL, 0x000fe400020006ffULL, 0x000000ff739b7812ULL, 0x000fe200078ec0ffULL,
0x2000009aff737230ULL, 0x000fe20000004100ULL, 0x00000008ff617819ULL, 0x000fe2000001169dULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe400078ec0ffULL,
0x00000008ff717819ULL, 0x000fe40000011671ULL, 0x0000009bff9b723eULL, 0x000fc400020006ffULL,
0x0000009cff9c723eULL, 0x000fe400020006ffULL, 0x00000061ff9a723eULL, 0x000fe200020006ffULL,
0x2000009bff9b7230ULL, 0x000fe20000004100ULL, 0x00000072ff9e723eULL, 0x000fe200020006ffULL,
0x2000009cff617230ULL, 0x000fe20000004100ULL, 0x00000071ff9d723eULL, 0x000fe200020006ffULL,
0x2000009aff9a7230ULL, 0x000fe20000004100ULL, 0x00000010ff9c7819ULL, 0x000fe20000011670ULL,
0x2000009eff717230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011673ULL,
0x2000009dff707230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fc4000001169bULL,
0x00000010ff9b7819ULL, 0x000fe4000001169aULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000098ff98723eULL, 0x000fe400020006ffULL, 0x000010549c737816ULL, 0x000fe40000000073ULL,
0x000010549b727816ULL, 0x000fe40000000072ULL, 0x00000008ff9a7819ULL, 0x000fe20000011695ULL,
0x20000098ff957230ULL, 0x000fe20000004100ULL, 0x000000ff969b7812ULL, 0x000fe200078ec0ffULL,
0x20000099ff967230ULL, 0x000fe20000004100ULL, 0x00000008ff977819ULL, 0x000fe20000011697ULL,
0x00000072584c723cULL, 0x000fe2000004184cULL, 0x0000105462717816ULL, 0x000fc40000000071ULL,
0x0000105470707816ULL, 0x000fe40000000061ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x000000721c48723cULL, 0x000fe20000041848ULL, 0x0000009aff99723eULL, 0x000fe400020006ffULL,
0x0000009bff98723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000097ff9a723eULL, 0x000fe200020006ffULL, 0x000000705844723cULL, 0x000fe20000041844ULL,
0x00000010ff727819ULL, 0x000fe2000001167bULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fe20000011693ULL, 0x20000098ff977230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe20000011696ULL, 0x000000701c40723cULL, 0x000fe20000041840ULL,
0x2000009aff627230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fc40000011690ULL,
0x000000ff7a617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff907819ULL, 0x000fe4000001168dULL,
0x00000010ff707819ULL, 0x000fe4000001168fULL, 0x0000105472717816ULL, 0x000fe40000000093ULL,
0x00000010ff727819ULL, 0x000fe4000001168eULL, 0x0000105473707816ULL, 0x000fc40000000070ULL,
0x00000010ff8e7819ULL, 0x000fe40000011677ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000010ff7a7819ULL, 0x000fe20000011692ULL, 0x000000705838723cULL, 0x000fe20000041838ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff997819ULL, 0x000fe20000011699ULL, 0x000000701c28723cULL, 0x000fe20000041828ULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x00000010ff777819ULL, 0x000fe40000011697ULL,
0x00000010ff8d7819ULL, 0x000fe40000011662ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff627819ULL, 0x000fe40000011676ULL, 0x00001054947b7816ULL, 0x000fe2000000007bULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00001054917a7816ULL, 0x000fc4000000007aULL,
0x0000105490737816ULL, 0x000fe40000000095ULL, 0x0000105499727816ULL, 0x000fe40000000072ULL,
0x000010548e777816ULL, 0x000fe20000000077ULL, 0x0000007a1c2c723cULL, 0x000fe2000004182cULL,
0x000010548d767816ULL, 0x000fe4000000008cULL, 0x00000010ff837819ULL, 0x100fe4000001167cULL,
0x00000018ff897819ULL, 0x000fe2000001167cULL, 0x000000721c24723cULL, 0x000fe20000041824ULL,
0x000000ff7c887812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7c7c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff827819ULL, 0x100fe2000001167eULL, 0x000000761c20723cULL, 0x000fe20000041820ULL,
0x00000018ff857819ULL, 0x000fe4000001167eULL, 0x000000ff7e847812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x100fe2000001167fULL, 0x0000007a583c723cULL, 0x000fe2000004183cULL,
0x00000018ff877819ULL, 0x000fc4000001167fULL, 0x000000ff7f867812ULL, 0x040fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x000fe2000001166eULL, 0x000000725834723cULL, 0x000fe20000041834ULL,
0x00000010ff717819ULL, 0x000fe4000001167dULL, 0x0000ffff7e7e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x000000765830723cULL, 0x000fe20000041830ULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000008ff7c7819ULL, 0x000fe2000001167cULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x000000ff79797812ULL, 0x000fe400078ec0ffULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x000010546e717816ULL, 0x000fe40000000071ULL, 0x000000ff83837812ULL, 0x000fc400078ec0ffULL,
0x00000008ff817819ULL, 0x000fe40000011681ULL, 0x00000008ff7e7819ULL, 0x000fe4000001167eULL,
0x000000ff6c6e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff1e7819ULL, 0x000fc40000011667ULL,
0x00000010ff1f7819ULL, 0x000fe40000011665ULL, 0x00000010ff1d7819ULL, 0x000fe40000011666ULL,
0x00000088ff8c723eULL, 0x000fe200020006ffULL, 0x20000062ff887230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000008cff587230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000084ff5b723eULL, 0x000fe200020006ffULL,
0x2000008aff597230ULL, 0x000fe20000004100ULL, 0x00000079ff70723eULL, 0x000fe200020006ffULL,
0x20000085ff7b7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000070ff737230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000082ff727230ULL, 0x000fe20000004100ULL, 0x00000087ff62723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x2000008bff5a7230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000081ff79723eULL, 0x000fe200020006ffULL,
0x20000086ff7a7230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000083ff817230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000007eff6c7230ULL, 0x000fe20000004100ULL, 0x00001054601f7816ULL, 0x000fe2000000001fULL,
0x2000006eff657230ULL, 0x000fe20000004100ULL, 0x000010541d1e7816ULL, 0x000fe2000000001eULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fc40000011663ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff707819ULL, 0x000fe20000011675ULL,
0x0000001e184c723cULL, 0x000fe2000004184cULL, 0x000010541c617816ULL, 0x000fe40000000061ULL,
0x00000010ff1c7819ULL, 0x000fe40000011658ULL, 0x00000010ff607819ULL, 0x000fe20000011664ULL,
0x0000001e1448723cULL, 0x000fe20000041848ULL, 0x00000010ff1d7819ULL, 0x000fc40000011688ULL,
0x00000010ff587819ULL, 0x000fe40000011659ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff1f7819ULL, 0x000fe4000001167cULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff1e7819ULL, 0x000fe4000001165bULL, 0x00000010ff757819ULL, 0x000fc40000011680ULL,
0x00000010ff647819ULL, 0x000fe40000011689ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff597819ULL, 0x000fe40000011673ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff5b7819ULL, 0x000fe4000001166cULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x000010541f1c7816ULL, 0x000fe4000000001cULL, 0x000010541d607816ULL, 0x000fc40000000060ULL,
0x000010547b1f7816ULL, 0x000fe40000000072ULL, 0x0000105475707816ULL, 0x000fe40000000070ULL,
0x00001054641d7816ULL, 0x000fe20000000081ULL, 0x000000601844723cULL, 0x000fe20000041844ULL,
0x000010545a597816ULL, 0x000fe40000000059ULL, 0x0000105479587816ULL, 0x000fe40000000058ULL,
0x000010545b1e7816ULL, 0x000fe2000000001eULL, 0x000000701854723cULL, 0x000fe20000041854ULL,
0x00001054627b7816ULL, 0x000fc40000000065ULL, 0x000010547f7a7816ULL, 0x000fc6000000007aULL,
0x000000701450723cULL, 0x000fec0000041850ULL, 0x000000601440723cULL, 0x000fec0000041840ULL,
0x0000001c183c723cULL, 0x000fec000004183cULL, 0x000000581838723cULL, 0x000fec0000041838ULL,
0x0000001e1834723cULL, 0x000fec0000041834ULL, 0x0000007a1830723cULL, 0x000fec0000041830ULL,
0x0000001c142c723cULL, 0x000fec000004182cULL, 0x000000581428723cULL, 0x000fec0000041828ULL,
0x0000001e1424723cULL, 0x000fec0000041824ULL, 0x0000007a1420723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffffe400980947ULL, 0x000fde000383ffffULL,
0x00000001ff197424ULL, 0x000fe400078e00ffULL, 0x000000040c0a7220ULL, 0x080fe20000410000ULL,
0x000000040d147220ULL, 0x080fe20000410000ULL, 0x0000000454157220ULL, 0x080fe20000410000ULL,
0x01a68819060c79a7ULL, 0x0002a2000850003fULL, 0x0000000455557220ULL, 0x080fe20000410000ULL,
0x0000000456567220ULL, 0x080fe20000410000ULL, 0x0000000457577220ULL, 0x080fe20000410000ULL,
0x000000044c4c7220ULL, 0x080fe20000410000ULL, 0x000000044d4d7220ULL, 0x080fe20000410000ULL,
0x000000044e4e7220ULL, 0x080fe20000410000ULL, 0x000000044f4f7220ULL, 0x080fe20000410000ULL,
0x0000000444447220ULL, 0x080fe20000410000ULL, 0x0000000445457220ULL, 0x080fe20000410000ULL,
0x0000000446467220ULL, 0x080fe20000410000ULL, 0x0000000447477220ULL, 0x080fe20000410000ULL,
0x0000000410107220ULL, 0x080fe20000410000ULL, 0x0000000411117220ULL, 0x080fe20000410000ULL,
0x0000000412127220ULL, 0x080fe20000410000ULL, 0x0000000413137220ULL, 0x080fe20000410000ULL,
0x000000043c3c7220ULL, 0x080fe20000410000ULL, 0x000000043d3d7220ULL, 0x080fe20000410000ULL,
0x000000043e3e7220ULL, 0x080fe20000410000ULL, 0x000000043f3f7220ULL, 0x080fe20000410000ULL,
0x0000000438387220ULL, 0x080fe20000410000ULL, 0x0000000439397220ULL, 0x080fe20000410000ULL,
0x000000043a3a7220ULL, 0x080fe20000410000ULL, 0x000000043b3b7220ULL, 0x080fe20000410000ULL,
0x0000000434347220ULL, 0x080fe20000410000ULL, 0x0000000435357220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x0000000430307220ULL, 0x080fe20000410000ULL, 0x0000000431317220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x0000000450177220ULL, 0x080fe20000410000ULL, 0x0000000451517220ULL, 0x080fe20000410000ULL,
0x0000000452527220ULL, 0x080fe20000410000ULL, 0x0000000453537220ULL, 0x080fe20000410000ULL,
0x0000000448487220ULL, 0x080fe20000410000ULL, 0x0000000449497220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x080fe20000410000ULL,
0x0000000440407220ULL, 0x080fe20000410000ULL, 0x0000000441417220ULL, 0x080fe20000410000ULL,
0x0000000442427220ULL, 0x080fe20000410000ULL, 0x0000000443437220ULL, 0x080fe20000410000ULL,
0x000000040e167220ULL, 0x080fe20000410000ULL, 0x000000040f187220ULL, 0x080fe20000410000ULL,
0x000000042c2c7220ULL, 0x080fe20000410000ULL, 0x000000042d2d7220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000429297220ULL, 0x080fe20000410000ULL,
0x000000042a2a7220ULL, 0x080fe20000410000ULL, 0x000000042b2b7220ULL, 0x080fe20000410000ULL,
0x0000000424247220ULL, 0x080fe20000410000ULL, 0x0000000425257220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x000fe20000410000ULL,
0x0000000705197812ULL, 0x006fce00078ec0ffULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x01a6880d060075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fce0000015200ULL,
0x0000000e1a1d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e1bULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x0000001d0e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x01a6880d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000004050c7824ULL, 0x000fe200078e00ffULL,
0x000000075e00720cULL, 0x000fe20003f06070ULL, 0x00000080780d7824ULL, 0x000fc600078e0209ULL,
0xfffffff00c0c7812ULL, 0x000fca00078ec0ffULL, 0x000000010d1a7824ULL, 0x000fca00078e020cULL,
0x01a400001a0c7984ULL, 0x0002a20000000c00ULL, 0x0000001c00c48947ULL, 0x000fea0003800000ULL,
0xffffff000b0b7836ULL, 0x000fe20000000000ULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x0000000205aa7824ULL, 0x000fe200078e00ffULL, 0x00008c00ff587b82ULL, 0x000ee20000000a00ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000000b741c7248ULL, 0x000fe40007fe0000ULL,
0x00000006aaaa7812ULL, 0x000fc600078ec0ffULL, 0x000000011cab7824ULL, 0x000fe200078e0a0bULL,
0x00000000050b7211ULL, 0x000fe200078ff0ffULL, 0x0000000aaaa97c36ULL, 0x000fe40008000000ULL,
0x000000ffff727224ULL, 0x000fe200078e0aabULL, 0x00000009ff1b7c19ULL, 0x000fe2000801160bULL,
0x000000080b1c7836ULL, 0x000fe20000000000ULL, 0x000000aba900720cULL, 0x000fe20003f06070ULL,
0x000000100b1d7836ULL, 0x000fe20000000000ULL, 0x000000051b1b7c48ULL, 0x000fe2000bfe0000ULL,
0x000000180b1e7836ULL, 0x000fe20000000000ULL, 0x00000005a99a7e46ULL, 0x000fe2000b800072ULL,
0x00000008aa0b7c36ULL, 0x000fe20008000000ULL, 0x00000009ff1c7c19ULL, 0x000fe2000801161cULL,
0x000000041b6c7c24ULL, 0x000fe2000f8e02ffULL, 0x000000ff9a9a7207ULL, 0x000fc40000000000ULL,
0x000000ab0b00720cULL, 0x000fe40003f26070ULL, 0x000000050b0b7e46ULL, 0x000fe4000b800072ULL,
0x00000009ff1b7c19ULL, 0x000fe4000801161dULL, 0x00000004ff0b7819ULL, 0x000fe4000001160bULL,
0x00000009ff1e7c19ULL, 0x000fe4000801161eULL, 0x000000ff0b0b7207ULL, 0x000fc40000800000ULL,
0x0000006c9a5b7211ULL, 0x000fe400078fe0ffULL, 0x000000051c1c7c48ULL, 0x000fe2000bfe0000ULL,
0x000000016c1f7824ULL, 0x000fe200078e020bULL, 0x000000051b1b7c48ULL, 0x000fe2000bfe0000ULL,
0x000000025b5a7825ULL, 0x008fe200078e0058ULL, 0x000000051e607c48ULL, 0x000fc6000bfe0000ULL,
0x000000021f1e7825ULL, 0x000fe200078e0058ULL, 0x000000065aa77981ULL, 0x0044e6000c1e9500ULL,
0x000000041c707c24ULL, 0x000fe2000f8e02ffULL, 0x000000061ea87981ULL, 0x000ae2000c1e9500ULL,
0x000000041b6e7c24ULL, 0x000fe4000f8e02ffULL, 0x0000000460607c24ULL, 0x000fe2000f8e02ffULL,
0x000000709a1d7211ULL, 0x040fe200078fe0ffULL, 0x000000010b997824ULL, 0x040fe200078e0270ULL,
0x0000006e9a977211ULL, 0x000fe200078fe0ffULL, 0x000000010b1b7824ULL, 0x000fe200078e026eULL,
0x00000010aa857812ULL, 0x000fe200078efcffULL, 0x000000021d1c7825ULL, 0x000fc800078e0058ULL,
0x000000010b0b7824ULL, 0x000fe200078e0260ULL, 0x000000061c937981ULL, 0x000ae2000c1e9500ULL,
0x0000000297967825ULL, 0x000fc800078e0058ULL, 0x0000000299987825ULL, 0x100fe400078e0058ULL,
0x0000000696967981ULL, 0x000ee4000c1e9500ULL, 0x000000021b5a7825ULL, 0x104fe400078e0058ULL,
0x0000000698987981ULL, 0x0004e4000c1e9500ULL, 0x00000008851e7c36ULL, 0x022fe40008000000ULL,
0x000000020b1c7825ULL, 0x000fc400078e0058ULL, 0x000000065a0b7981ULL, 0x000362000c1e9500ULL,
0x000000609a957211ULL, 0x000fe200078fe0ffULL, 0x0000000a85867c36ULL, 0x000fe20008000000ULL,
0x000000051e507e46ULL, 0x000fe2000b800072ULL, 0x000000061c1f7981ULL, 0x000362000c1e9500ULL,
0x000000ab1e00720cULL, 0x080fe20003f26070ULL, 0x0000000295947825ULL, 0x000fe200078e0058ULL,
0x000000ab8600720cULL, 0x000fe40003f06070ULL, 0x00000005861b7e46ULL, 0x000fe4000b800072ULL,
0x00000004ff507819ULL, 0x000fe20000011650ULL, 0x0000000694947981ULL, 0x000f62000c1e9500ULL,
0x000000ff1b997207ULL, 0x004fc40000000000ULL, 0x000000ff501b7207ULL, 0x000fe40000800000ULL,
0x0000006c995b7211ULL, 0x042fe400078fe0ffULL, 0x00000070991d7211ULL, 0x000fe200078fe0ffULL,
0x000000016c8d7824ULL, 0x000fe400078e021bULL, 0x000000011b5d7824ULL, 0x000fe200078e0270ULL,
0x00000020aa767812ULL, 0x000fe200078efcffULL, 0x000000028d8c7825ULL, 0x000fc800078e0058ULL,
0x000000025b5a7825ULL, 0x100fe400078e0058ULL, 0x000000068c8c7981ULL, 0x000ea4000c1e9500ULL,
0x000000021d1c7825ULL, 0x100fe400078e0058ULL, 0x000000065a8b7981ULL, 0x0002a4000c1e9500ULL,
0x000000025d5c7825ULL, 0x000fe400078e0058ULL, 0x000000061c897981ULL, 0x0002a4000c1e9500ULL,
0x000000011b617824ULL, 0x000fc400078e026eULL, 0x0000000876547c36ULL, 0x000fe20008000000ULL,
0x000000065c8a7981ULL, 0x000ea2000c1e9500ULL, 0x0000000a76777c36ULL, 0x000fe20008000000ULL,
0x0000006e99657211ULL, 0x000fe200078fe0ffULL, 0x00000002615a7825ULL, 0x002fe200078e0058ULL,
0x0000006099637211ULL, 0x000fe400078fe0ffULL, 0x0000000554617e46ULL, 0x000fe2000b800072ULL,
0x000000011b1b7824ULL, 0x000fe200078e0260ULL, 0x000000ab7700720cULL, 0x080fe40003f06070ULL,
0x00000005771e7e46ULL, 0x000fe2000b800072ULL, 0x0000000265647825ULL, 0x000fe200078e0058ULL,
0x000000ab5400720cULL, 0x000fc40003f26070ULL, 0x00000004ff617819ULL, 0x000fe20000011661ULL,
0x0000000263627825ULL, 0x100fe200078e0058ULL, 0x000000ff1e1e7207ULL, 0x000fe20000000000ULL,
0x0000000664887981ULL, 0x000ea4000c1e9500ULL, 0x000000021b1c7825ULL, 0x000fe200078e0058ULL,
0x000000ff61617207ULL, 0x000fe20000800000ULL, 0x0000000662877981ULL, 0x0002a2000c1e9500ULL,
0x0000006c1e7d7211ULL, 0x000fc600078fe0ffULL, 0x000000065a1b7981ULL, 0x0002a2000c1e9500ULL,
0x000000701e7b7211ULL, 0x000fc600078fe0ffULL, 0x000000061c507981ULL, 0x000ea2000c1e9500ULL,
0x0000000161637824ULL, 0x002fe400078e0270ULL, 0x000000027d7c7825ULL, 0x000fc800078e0058ULL,
0x000000027b7a7825ULL, 0x100fe400078e0058ULL, 0x000000067c7c7981ULL, 0x0002a4000c1e9500ULL,
0x0000000263627825ULL, 0x000fe400078e0058ULL, 0x000000067a7a7981ULL, 0x000ea4000c1e9500ULL,
0x000000016c5b7824ULL, 0x000fe200078e0261ULL, 0x0000006e1e677211ULL, 0x040fe200078fe0ffULL,
0x00000006627d7981ULL, 0x002ea4000c1e9500ULL, 0x000000025b5a7825ULL, 0x000fe200078e0058ULL,
0x000000601e657211ULL, 0x000fc600078fe0ffULL, 0x00000001611d7824ULL, 0x040fe200078e026eULL,
0x000000065a7f7981ULL, 0x0002a2000c1e9500ULL, 0x00000001615d7824ULL, 0x000fe400078e0260ULL,
0x000000021d1c7825ULL, 0x000fc800078e0058ULL, 0x0000000267667825ULL, 0x100fe400078e0058ULL,
0x000000061c1c7981ULL, 0x000ea2000c1e9500ULL, 0x00000030aa5b7812ULL, 0x002fe200078efcffULL,
0x0000000265647825ULL, 0x100fe400078e0058ULL, 0x00000006667b7981ULL, 0x000ea4000c1e9500ULL,
0x000000025d5c7825ULL, 0x000fe400078e0058ULL, 0x0000000664797981ULL, 0x000ea4000c1e9500ULL,
0x000000085b5a7c36ULL, 0x000fc40008000000ULL, 0x000000065c547981ULL, 0x0002a2000c1e9500ULL,
0x0000000a5b617c36ULL, 0x000fe40008000000ULL, 0x000000055a717e46ULL, 0x000fe4000b800072ULL,
0x000000ab5a00720cULL, 0x080fe40003f26070ULL, 0x000000ab6100720cULL, 0x000fe40003f06070ULL,
0x0000000561977e46ULL, 0x000fe4000b800072ULL, 0x00000004ff717819ULL, 0x000fc40000011671ULL,
0x000000ff97977207ULL, 0x000fe40000000000ULL, 0x000000ff71757207ULL, 0x000fe40000800000ULL,
0x0000006c97637211ULL, 0x040fe400078fe0ffULL, 0x0000006e97817211ULL, 0x000fe200078fe0ffULL,
0x000000016c5d7824ULL, 0x002fe400078e0275ULL, 0x0000000175717824ULL, 0x000fe200078e026eULL,
0x0000007097837211ULL, 0x000fe200078fe0ffULL, 0x0000000175737824ULL, 0x000fc400078e0270ULL,
0x0000000263627825ULL, 0x000fc800078e0058ULL, 0x000000025d5c7825ULL, 0x100fe200078e0058ULL,
0x0000000662677981ULL, 0x000ea6000c1e9500ULL, 0x0000000281807825ULL, 0x100fe200078e0058ULL,
0x000000065c6c7981ULL, 0x0002a6000c1e9500ULL, 0x0000000271707825ULL, 0x100fe200078e0058ULL,
0x0000000680647981ULL, 0x000ea8000c1e9500ULL, 0x00000006701d7981ULL, 0x000ea2000c1e9500ULL,
0x0000000283827825ULL, 0x000fc800078e0058ULL, 0x0000000273727825ULL, 0x000fe200078e0058ULL,
0x0000000682657981ULL, 0x0002a4000c1e9500ULL, 0x00000060975d7211ULL, 0x002fe400078fe0ffULL,
0x0000000672667981ULL, 0x0002a2000c1e9500ULL, 0x0000000175757824ULL, 0x000fe400078e0260ULL,
0x000000025d5c7825ULL, 0x000fc800078e0058ULL, 0x0000000275587825ULL, 0x000fe200078e0058ULL,
0x000000065c627981ULL, 0x000ea8000c1e9500ULL, 0x0000000658637981ULL, 0x0002a2000c1e9500ULL,
0xfffffff09a9a7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff957424ULL, 0x000fc800078e00ffULL,
0x00000001ab9a7824ULL, 0x000fc800078e029aULL, 0x00000001a9a67824ULL, 0x000fe200078e0a9aULL,
0x00000001aa917812ULL, 0x000fc800078efcffULL, 0x000000a695a67219ULL, 0x000fe200000006ffULL,
0x0000000a91927c36ULL, 0x000fe20008000000ULL, 0x00000011aa837812ULL, 0x040fe400078efcffULL,
0x00000018aa807812ULL, 0x040fe400078efcffULL, 0x00000019aa7e7812ULL, 0x000fe400078efcffULL,
0xfffffff0999c7812ULL, 0x000fe400078ec0ffULL, 0xfffffff01ea27812ULL, 0x000fe200078ec0ffULL,
0x0000000a83847c36ULL, 0x000fe20008000000ULL, 0xfffffff0971e7812ULL, 0x000fe200078ec0ffULL,
0x0000000a80827c36ULL, 0x000fc40008000000ULL, 0x0000000a7e817c36ULL, 0x000fe40008000000ULL,
0x00000001ab977824ULL, 0x000fe400078e029cULL, 0x0000000192ba7824ULL, 0x000fe200078e0a9aULL,
0x00000008aa8e7812ULL, 0x000fe200078efcffULL, 0x0000000186b67824ULL, 0x100fe200078e0a97ULL,
0x00000009aa8d7812ULL, 0x000fe200078efcffULL, 0x00000001849c7824ULL, 0x100fe400078e0a97ULL,
0x0000000182b47824ULL, 0x000fc400078e0a97ULL, 0x00000001819e7824ULL, 0x000fe200078e0a97ULL,
0x000000ba95977219ULL, 0x000fe200000006ffULL, 0x0000000a8e907c36ULL, 0x000fe40008000000ULL,
0x0000000a8d8f7c36ULL, 0x000fe40008000000ULL, 0x0000000190b87824ULL, 0x100fe400078e0a9aULL,
0x000000018f9a7824ULL, 0x000fc600078e0a9aULL, 0x000000b895997219ULL, 0x040fe400000006ffULL,
0x0000009a959a7219ULL, 0x000fe400000006ffULL, 0x00005410a7a77816ULL, 0x008fc800000000a8ULL,
0x000000a7a6ff7212ULL, 0x000fc800078ac0ffULL, 0x000000aba900720cULL, 0x000fc80002fa1470ULL,
0x000000abaa00720cULL, 0x000fe40002fa1070ULL, 0x000000a797ff7212ULL, 0x000fe4000788c0ffULL,
0xff80000015157808ULL, 0x000fe40002800000ULL, 0x0000541093937816ULL, 0x000fe40000000098ULL,
0x00005410960b7816ULL, 0x020fe4000000000bULL, 0x00000093a6ff7212ULL, 0x000fc4000784c0ffULL,
0x0000000ba6ff7212ULL, 0x000fe4000782c0ffULL, 0x0000009397ff7212ULL, 0x000fe400078ac0ffULL,
0x000000aba900720cULL, 0x0c0fe40001741470ULL, 0x000000aba900720cULL, 0x080fe40000f21470ULL,
0x000000ab9200720cULL, 0x0c0fe40002781470ULL, 0x000000ab9200720cULL, 0x000fc40002fa1470ULL,
0x000000abaa00720cULL, 0x0c0fe40001741070ULL, 0x000000abaa00720cULL, 0x080fe40000f21070ULL,
0x000000ab9100720cULL, 0x0c0fe40002781070ULL, 0x000000ab9100720cULL, 0x000fe40002fa1070ULL,
0x00005410941f7816ULL, 0x000fe4000000001fULL, 0xff80000056567808ULL, 0x000fc40001000000ULL,
0xff80000017177808ULL, 0x000fe40000800000ULL, 0xff80000055557808ULL, 0x000fe40002000000ULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x000000a799ff7212ULL, 0x000fe4000786c0ffULL,
0x0000001fa6ff7212ULL, 0x000fe4000780c0ffULL, 0x0000000b97ff7212ULL, 0x000fc4000784c0ffULL,
0x0000001f97ff7212ULL, 0x000fe4000782c0ffULL, 0x000000939aff7212ULL, 0x000fe4000788c0ffULL,
0x0000000b99ff7212ULL, 0x000fe400078ac0ffULL, 0x000000aba900720cULL, 0x080fe40000701470ULL,
0x000000ab9200720cULL, 0x0c0fe40001741470ULL, 0x000000ab9200720cULL, 0x000fc40000f21470ULL,
0x000000ab9000720cULL, 0x0c0fe40001f61470ULL, 0x000000ab9000720cULL, 0x080fe40002fa1470ULL,
0x000000ab8f00720cULL, 0x080fe40002781470ULL, 0x000000abaa00720cULL, 0x080fe40000701070ULL,
0x000000ab9100720cULL, 0x0c0fe40001741070ULL, 0x000000ab9100720cULL, 0x000fc40000f21070ULL,
0x000000ab8e00720cULL, 0x0c0fe40001f61070ULL, 0x000000ab8e00720cULL, 0x080fe40002fa1070ULL,
0x000000ab8d00720cULL, 0x000fe40002781070ULL, 0x000000b6959b7219ULL, 0x040fe400000006ffULL,
0x0000009c959c7219ULL, 0x000fe400000006ffULL, 0x000054108b8b7816ULL, 0x004fc4000000008cULL,
0x0000541089897816ULL, 0x000fe4000000008aULL, 0xff80000052527808ULL, 0x000fe40000000000ULL,
0xff80000051517808ULL, 0x000fe40001000000ULL, 0xff80000053537808ULL, 0x000fe40000800000ULL,
0xff8000004c4c7808ULL, 0x000fe40001800000ULL, 0xff80000048487808ULL, 0x000fc40002800000ULL,
0xff8000004f4f7808ULL, 0x000fe40002000000ULL, 0x0000009399ff7212ULL, 0x040fe4000780c0ffULL,
0x0000000b9aff7212ULL, 0x040fe4000784c0ffULL, 0x0000001f99ff7212ULL, 0x080fe4000782c0ffULL,
0x0000001f9aff7212ULL, 0x000fe4000786c0ffULL, 0x0000008b9cff7212ULL, 0x000fc400078ac0ffULL,
0x000000899bff7212ULL, 0x000fe4000788c0ffULL, 0x000000ab9000720cULL, 0x0c0fe40000701470ULL,
0x000000ab9000720cULL, 0x080fe40000f21470ULL, 0x000000ab8f00720cULL, 0x0c0fe40001741470ULL,
0x000000ab8f00720cULL, 0x080fe40001f61470ULL, 0x000000ab8600720cULL, 0x000fc40002781470ULL,
0x000000ab8400720cULL, 0x080fe40002fa1470ULL, 0x000000ab8e00720cULL, 0x0c0fe40000701070ULL,
0x000000ab8e00720cULL, 0x080fe40000f21070ULL, 0x000000ab8d00720cULL, 0x0c0fe40001741070ULL,
0x000000ab8d00720cULL, 0x080fe40001f61070ULL, 0x000000ab8500720cULL, 0x000fc40002781070ULL,
0x000000ab8300720cULL, 0x000fe40002fa1070ULL, 0x000000b4959d7219ULL, 0x040fe400000006ffULL,
0x0000009e959e7219ULL, 0x000fe400000006ffULL, 0x00005410881b7816ULL, 0x000fe4000000001bULL,
0x0000541087507816ULL, 0x000fe20000000050ULL, 0x00000001aba27824ULL, 0x000fe200078e02a2ULL,
0xff8000004e4e7808ULL, 0x000fc40000000000ULL, 0xff8000004a4a7808ULL, 0x000fe40000800000ULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff8000004b4b7808ULL, 0x000fe40001800000ULL,
0xff80000046467808ULL, 0x000fe40002000000ULL, 0xff80000045457808ULL, 0x000fe40002800000ULL,
0x0000008b9bff7212ULL, 0x000fc4000780c0ffULL, 0x0000008b9dff7212ULL, 0x000fe4000782c0ffULL,
0x0000001b9bff7212ULL, 0x0c0fe4000784c0ffULL, 0x000000509bff7212ULL, 0x000fe4000786c0ffULL,
0x0000001b9cff7212ULL, 0x000fe4000788c0ffULL, 0x000000899eff7212ULL, 0x000fe200078ac0ffULL,
0x0000000177b27824ULL, 0x000fe200078e0aa2ULL, 0x000000ab8600720cULL, 0x000fc40000701470ULL,
0x000000ab8600720cULL, 0x0c0fe40001741470ULL, 0x000000ab8600720cULL, 0x080fe40001f61470ULL,
0x000000ab8400720cULL, 0x080fe40002781470ULL, 0x000000ab8200720cULL, 0x080fe40000f21470ULL,
0x000000ab8100720cULL, 0x000fe40002fa1470ULL, 0x00000021aa737812ULL, 0x002fc400078efcffULL,
0x000000ab8500720cULL, 0x0c0fe40000701070ULL, 0x000000ab8500720cULL, 0x0c0fe40001741070ULL,
0x000000ab8500720cULL, 0x080fe40001f61070ULL, 0x000000ab8300720cULL, 0x080fe40002781070ULL,
0x000000ab8000720cULL, 0x080fe40000f21070ULL, 0x000000ab7e00720cULL, 0x000fc40002fa1070ULL,
0x000000b2959f7219ULL, 0x000fe400000006ffULL, 0x000054107a7a7816ULL, 0x000fe2000000007dULL,
0x0000000a73757c36ULL, 0x000fe20008000000ULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff80000040407808ULL, 0x000fe40001000000ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000041417808ULL, 0x000fc40002000000ULL, 0xff80000010107808ULL, 0x000fe40000800000ULL,
0xff80000013137808ULL, 0x000fe40002800000ULL, 0x000000899cff7212ULL, 0x0c0fe4000780c0ffULL,
0x000000509cff7212ULL, 0x000fe4000784c0ffULL, 0x000000899dff7212ULL, 0x000fe4000786c0ffULL,
0x0000001b9eff7212ULL, 0x000fc4000788c0ffULL, 0x000000509eff7212ULL, 0x000fe4000782c0ffULL,
0x0000007a9fff7212ULL, 0x000fe200078ac0ffULL, 0x0000000175a07824ULL, 0x000fe200078e0aa2ULL,
0x000000ab8400720cULL, 0x0c0fe40000701470ULL, 0x000000ab8400720cULL, 0x080fe40001741470ULL,
0x000000ab8200720cULL, 0x080fe40001f61470ULL, 0x000000ab8100720cULL, 0x000fc40002781470ULL,
0x000000ab8100720cULL, 0x080fe40000f21470ULL, 0x000000ab7700720cULL, 0x080fe40002fa1470ULL,
0x00000028aa707812ULL, 0x040fe400078efcffULL, 0x00000029aa6e7812ULL, 0x000fe400078efcffULL,
0x000000ab8300720cULL, 0x0c0fe40000701070ULL, 0x000000ab8300720cULL, 0x000fc40001741070ULL,
0x000000ab8000720cULL, 0x080fe40001f61070ULL, 0x000000ab7e00720cULL, 0x0c0fe40002781070ULL,
0x000000ab7e00720cULL, 0x080fe40000f21070ULL, 0x000000ab7600720cULL, 0x000fe40002fa1070ULL,
0x000000a095a07219ULL, 0x000fe400000006ffULL, 0x000054107c7c7816ULL, 0x000fc4000000007fULL,
0x000054107b1c7816ULL, 0x000fe4000000001cULL, 0x0000541079547816ULL, 0x000fe20000000054ULL,
0x0000000a70727c36ULL, 0x000fe20008000000ULL, 0xff80000047477808ULL, 0x000fe20000000000ULL,
0x0000000a6e717c36ULL, 0x000fe20008000000ULL, 0xff80000043437808ULL, 0x000fe40001000000ULL,
0xff80000012127808ULL, 0x000fe40001800000ULL, 0xff80000014147808ULL, 0x000fc40002000000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x000000a79aff7212ULL, 0x000fe400078cc0ffULL, 0x0000001b9dff7212ULL, 0x040fe4000780c0ffULL,
0x000000509dff7212ULL, 0x000fe4000784c0ffULL, 0x0000007c9fff7212ULL, 0x000fc4000786c0ffULL,
0x0000001c9fff7212ULL, 0x040fe4000788c0ffULL, 0x000000549fff7212ULL, 0x000fe4000782c0ffULL,
0x0000001ca0ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000172b07824ULL, 0x100fe200078e0aa2ULL,
0x000000ab8f00720cULL, 0x080fe200037c1470ULL, 0x0000000171a27824ULL, 0x000fe200078e0aa2ULL,
0x000000ab8200720cULL, 0x0c0fe40000701470ULL, 0x000000ab8200720cULL, 0x000fc40001741470ULL,
0x000000ab7700720cULL, 0x0c0fe40001f61470ULL, 0x000000ab7700720cULL, 0x0c0fe40002781470ULL,
0x000000ab7700720cULL, 0x080fe40000f21470ULL, 0x000000ab7500720cULL, 0x080fe40002fa1470ULL,
0x000000ab8d00720cULL, 0x080fe400037c1070ULL, 0x000000ab8000720cULL, 0x000fc40000701070ULL,
0x000000ab8000720cULL, 0x080fe40001741070ULL, 0x000000ab7600720cULL, 0x0c0fe40001f61070ULL,
0x000000ab7600720cULL, 0x0c0fe40002781070ULL, 0x000000ab7600720cULL, 0x080fe40000f21070ULL,
0x000000ab7300720cULL, 0x000fe40002fa1070ULL, 0x000000b095a17219ULL, 0x000fc400000006ffULL,
0x000000a295a27219ULL, 0x000fe200000006ffULL, 0x00000001ab1e7824ULL, 0x000fe200078e021eULL,
0xff8000004d4d7808ULL, 0x000fe40003000000ULL, 0xff8000000a0a7808ULL, 0x000fe40000000000ULL,
0xff80000016167808ULL, 0x000fe40001000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001800000ULL,
0xff8000002c2c7808ULL, 0x000fc40002000000ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff8000002d2d7808ULL, 0x000fe40002800000ULL, 0x0000008b9eff7212ULL, 0x000fe400078cc0ffULL,
0x0000007ca0ff7212ULL, 0x0c0fe4000780c0ffULL, 0x0000007ca1ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007aa0ff7212ULL, 0x000fc4000786c0ffULL, 0x00000054a0ff7212ULL, 0x000fe4000788c0ffULL,
0x0000007aa1ff7212ULL, 0x000fe4000782c0ffULL, 0x0000001ca2ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000161ae7824ULL, 0x000fe200078e0a1eULL, 0x000000ab8100720cULL, 0x080fe400037c1470ULL,
0x000000ab7500720cULL, 0x0c0fe40000701470ULL, 0x000000ab7500720cULL, 0x000fc40001f61470ULL,
0x000000ab7500720cULL, 0x080fe40002781470ULL, 0x000000ab7200720cULL, 0x0c0fe40001741470ULL,
0x000000ab7200720cULL, 0x080fe40000f21470ULL, 0x000000ab7100720cULL, 0x000fe40002fa1470ULL,
0x00000031aa5a7812ULL, 0x040fe400078efcffULL, 0x00000038aa597812ULL, 0x000fc400078efcffULL,
0x00000039aa587812ULL, 0x000fe400078efcffULL, 0x000000ab7e00720cULL, 0x080fe400037c1070ULL,
0x000000ab7300720cULL, 0x0c0fe40000701070ULL, 0x000000ab7300720cULL, 0x0c0fe40001f61070ULL,
0x000000ab7300720cULL, 0x080fe40002781070ULL, 0x000000ab7000720cULL, 0x000fc40001741070ULL,
0x000000ab7000720cULL, 0x080fe40000f21070ULL, 0x000000ab6e00720cULL, 0x000fe40002fa1070ULL,
0x000000ae95a37219ULL, 0x000fe400000006ffULL, 0x0000541067677816ULL, 0x000fe4000000006cULL,
0x00005410641d7816ULL, 0x000fe2000000001dULL, 0x0000000a5a607c36ULL, 0x000fe20008000000ULL,
0xff80000011117808ULL, 0x000fe20003000000ULL, 0x0000000a595d7c36ULL, 0x000fe20008000000ULL,
0xff8000003d3d7808ULL, 0x000fe20000000000ULL, 0x0000000a585c7c36ULL, 0x000fe20008000000ULL,
0xff8000003f3f7808ULL, 0x000fc40001800000ULL, 0xff8000002f2f7808ULL, 0x000fe40002000000ULL,
0xff80000038387808ULL, 0x000fe40001000000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff80000029297808ULL, 0x000fe40002800000ULL, 0x0000007ca2ff7212ULL, 0x040fe400078cc0ffULL,
0x0000007aa2ff7212ULL, 0x000fc4000780c0ffULL, 0x0000001ca1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000054a1ff7212ULL, 0x080fe4000788c0ffULL, 0x00000054a2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000067a3ff7212ULL, 0x040fe4000782c0ffULL, 0x0000001da3ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000160a47824ULL, 0x100fe200078e0a1eULL, 0x000000ab7200720cULL, 0x0c0fe20001f61470ULL,
0x000000015dac7824ULL, 0x100fe200078e0a1eULL, 0x000000ab7200720cULL, 0x080fe20002781470ULL,
0x000000015c1e7824ULL, 0x000fe200078e0a1eULL, 0x000000ab7100720cULL, 0x000fc400037c1470ULL,
0x000000ab7100720cULL, 0x0c0fe40000701470ULL, 0x000000ab7100720cULL, 0x080fe40001741470ULL,
0x000000ab6100720cULL, 0x0c0fe40000f21470ULL, 0x000000ab6100720cULL, 0x080fe40002fa1470ULL,
0x000000ab7000720cULL, 0x0c0fe40001f61070ULL, 0x000000ab7000720cULL, 0x000fc40002781070ULL,
0x000000ab6e00720cULL, 0x0c0fe400037c1070ULL, 0x000000ab6e00720cULL, 0x0c0fe40000701070ULL,
0x000000ab6e00720cULL, 0x080fe40001741070ULL, 0x000000ab5b00720cULL, 0x0c0fe40000f21070ULL,
0x000000ab5b00720cULL, 0x000fe40002fa1070ULL, 0x000000a495a47219ULL, 0x000fc400000006ffULL,
0x000000ac95a57219ULL, 0x040fe400000006ffULL, 0x0000001e951e7219ULL, 0x000fe400000006ffULL,
0x0000541065657816ULL, 0x000fe40000000066ULL, 0xff80000028287808ULL, 0x000fe40001800000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff80000039397808ULL, 0x000fc40003000000ULL,
0xff8000003b3b7808ULL, 0x000fe40000000000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0x00000067a4ff7212ULL, 0x080fe4000786c0ffULL, 0x00000067a5ff7212ULL, 0x000fc4000788c0ffULL,
0x000000671eff7212ULL, 0x000fe400078cc0ffULL, 0x00000065a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000065a4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x00000065a5ff7212ULL, 0x000fe4000782c0ffULL,
0x0000001da4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000ab6100720cULL, 0x000fc40000701470ULL,
0x000000ab6000720cULL, 0x0c0fe40001f61470ULL, 0x000000ab6000720cULL, 0x0c0fe40001741470ULL,
0x000000ab6000720cULL, 0x080fe40002fa1470ULL, 0x000000ab5d00720cULL, 0x0c0fe40002781470ULL,
0x000000ab5c00720cULL, 0x080fe400037c1470ULL, 0x000000ab5d00720cULL, 0x000fc40000f21470ULL,
0x000000ab5b00720cULL, 0x080fe40000701070ULL, 0x000000ab5a00720cULL, 0x0c0fe40001f61070ULL,
0x000000ab5a00720cULL, 0x0c0fe40001741070ULL, 0x000000ab5a00720cULL, 0x080fe40002fa1070ULL,
0x000000ab5900720cULL, 0x0c0fe40002781070ULL, 0x000000ab5900720cULL, 0x000fc40000f21070ULL,
0x000000ab5800720cULL, 0x000fe400037c1070ULL, 0x0000541062627816ULL, 0x000fe40000000063ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff80000035357808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fc40002800000ULL,
0xff80000030307808ULL, 0x000fe40002000000ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0x000000651eff7212ULL, 0x040fe4000780c0ffULL,
0x0000001da5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000001d1eff7212ULL, 0x000fc4000784c0ffULL,
0x00000062a3ff7212ULL, 0x080fe400078ac0ffULL, 0x00000062a4ff7212ULL, 0x080fe4000788c0ffULL,
0x00000062a5ff7212ULL, 0x080fe4000782c0ffULL, 0x000000621eff7212ULL, 0x000fe400078cc0ffULL,
0x000000ab6100720cULL, 0x080fe40002fa1470ULL, 0x000000ab6000720cULL, 0x000fc40002781470ULL,
0x000000ab5d00720cULL, 0x0c0fe40001f61470ULL, 0x000000ab5d00720cULL, 0x080fe40000f21470ULL,
0x000000ab5c00720cULL, 0x0c0fe40000701470ULL, 0x000000ab5c00720cULL, 0x0c0fe40001741470ULL,
0x000000ab5c00720cULL, 0x080fe400037c1470ULL, 0x000000ab5b00720cULL, 0x000fc40002fa1070ULL,
0x000000ab5a00720cULL, 0x080fe40002781070ULL, 0x000000ab5800720cULL, 0x0c0fe40000701070ULL,
0x000000ab5900720cULL, 0x0c0fe40001f61070ULL, 0x000000ab5900720cULL, 0x080fe40000f21070ULL,
0x000000ab5800720cULL, 0x0c0fe40001741070ULL, 0x000000ab5800720cULL, 0x000fc400037c1070ULL,
0xff80000033337808ULL, 0x000fe40000000000ULL, 0xff80000020207808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff80000022227808ULL, 0x000fc40000800000ULL,
0xff80000023237808ULL, 0x000fce0003000000ULL, 0x000000150c00720bULL, 0x004fe20003f1e000ULL,
0x3f80000000097882ULL, 0x000fe20000000000ULL, 0x000000015e5e7836ULL, 0x000fe40000000000ULL,
0x0000000c150c7208ULL, 0x000fc80004000000ULL, 0x000000550c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c550b7208ULL, 0x000fc80004000000ULL, 0x0000004c0b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b4c0c7208ULL, 0x000fc80004000000ULL, 0x0000004d0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c4d0b7208ULL, 0x000fc80004000000ULL, 0x000000440b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b440c7208ULL, 0x000fc80004000000ULL, 0x000000450c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c450b7208ULL, 0x000fc80004000000ULL, 0x000000100b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b100c7208ULL, 0x000fc80004000000ULL, 0x000000110c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c110b7208ULL, 0x000fc80004000000ULL, 0x0000003c0b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b3c0c7208ULL, 0x000fc80004000000ULL, 0x0000003d0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c3d0b7208ULL, 0x000fc80004000000ULL, 0x000000380b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b380c7208ULL, 0x000fc80004000000ULL, 0x000000390c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c390b7208ULL, 0x000fc80004000000ULL, 0x000000340b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b340c7208ULL, 0x000fc80004000000ULL, 0x000000350c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c350b7208ULL, 0x000fc80004000000ULL, 0x000000300b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b300c7208ULL, 0x000fe40004000000ULL, 0x000000560d00720bULL, 0x000fe40003f1e000ULL,
0x000000310c00720bULL, 0x000fc80003f3e000ULL, 0x0000000c311b7208ULL, 0x000fe40004800000ULL,
0x0000000d560c7208ULL, 0x000fc60004000000ULL, 0x0c401f001b1c7f89ULL, 0x000ea200000e0000ULL,
0x000000570c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c570b7208ULL, 0x000fc80004000000ULL,
0x0000004e0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b4e0c7208ULL, 0x000fc80004000000ULL,
0x0000004f0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c4f0b7208ULL, 0x000fe40004000000ULL,
0x0000001c1b00720bULL, 0x004fe40003f3e000ULL, 0x000000460b00720bULL, 0x000fe40003f1e000ULL,
0x0000001b1c0d7208ULL, 0x000fe40004800000ULL, 0x0000000b460c7208ULL, 0x000fc60004000000ULL,
0x0c201f000d1c7f89ULL, 0x000ea200000e0000ULL, 0x000000470c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c470b7208ULL, 0x000fc80004000000ULL, 0x000000120b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b120c7208ULL, 0x000fc80004000000ULL, 0x000000130c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c130b7208ULL, 0x000fe40004000000ULL, 0x0000001c0d00720bULL, 0x004fe40003f3e000ULL,
0x0000003e0b00720bULL, 0x000fe40003f1e000ULL, 0x0000000d1c0c7208ULL, 0x000fe40004800000ULL,
0x0000000b3e1c7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b0c547820ULL, 0x000fe20000410000ULL,
0x0000003f1c00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b150b7823ULL, 0x100fe20000010854ULL,
0x0000001c3f0d7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4c157823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b441d7823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b101f7823ULL, 0x100fe20000010854ULL,
0x0000003a0d00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b11507823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b551c7823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010854ULL,
0x0000000d3a1e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b34347823ULL, 0x000fe20000010854ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x0000003b1e00720bULL, 0x000fc80003f1e000ULL, 0x0000001e3b0d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4d1e7823ULL, 0x000fe40000010854ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x000000360d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d364c7208ULL, 0x000fc60004000000ULL,
0x0000001500157308ULL, 0x000fe20000000800ULL, 0x000000374c00720bULL, 0x000fc80003f1e000ULL,
0x0000004c370d7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b454c7823ULL, 0x000fe40000010854ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x000000320d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d32447208ULL, 0x000fc60004000000ULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x000000334400720bULL, 0x000fc80003f1e000ULL, 0x0000004433107208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3c447823ULL, 0x100fe20000010854ULL, 0x000000170e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b383c7823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b31387823ULL, 0x000fe20000010854ULL,
0x0c401f00101b7f89ULL, 0x000ea200000e0000ULL, 0x0000000e170e7208ULL, 0x000fe20004000000ULL,
0x0000005000507308ULL, 0x000fe60000000800ULL, 0x000000510e00720bULL, 0x000fc80003f1e000ULL,
0x0000000e510d7208ULL, 0x000fe20004000000ULL, 0x0000001d001d7308ULL, 0x000fe60000000800ULL,
0x000000480d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d480e7208ULL, 0x000fe20004000000ULL,
0x0000004c004c7308ULL, 0x000fe60000000800ULL, 0x000000490e00720bULL, 0x000fe40003f1e000ULL,
0x0000001b1000720bULL, 0x004fe40003f3e000ULL, 0x0000000e490d7208ULL, 0x000fe20004000000ULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x000000101b107208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b351b7823ULL, 0x100fe20000010854ULL, 0x000000400d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b30357823ULL, 0x000fc40000010854ULL, 0x0c201f0010457f89ULL, 0x000ea200000e0000ULL,
0x0000000d400e7208ULL, 0x000fe20004000000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x000000410e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e410d7208ULL, 0x000fe20004000000ULL,
0x0000003c003c7308ULL, 0x000fe60000000800ULL, 0x0000000a0d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d0a0d7208ULL, 0x000fe20004000000ULL, 0x0000003900397308ULL, 0x000fe60000000800ULL,
0x000000140d00720bULL, 0x000fe40003f1e000ULL, 0x000000451000720bULL, 0x004fe40003f3e000ULL,
0x0000000d14117208ULL, 0x000fe20004000000ULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x00000010450d7208ULL, 0x000fc40004800000ULL, 0x0000002c1100720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b0d557820ULL, 0x000fe20000410000ULL, 0x000000112c0e7208ULL, 0x000fe20004000000ULL,
0x0000003800387308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b13587823ULL, 0x100fe20000010855ULL,
0x0000002d0e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b56117823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b47567823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b12477823ULL, 0x100fe20000010855ULL,
0x0000000e2d317208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3a127823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b464d7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b57307823ULL, 0x100fe20000010855ULL,
0x000000283100720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b4f547823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010855ULL,
0x00000031280e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4e317823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b3b4e7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b363a7823ULL, 0x100fe20000010855ULL,
0x000000290e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b323b7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b33467823ULL, 0x000fe20000010855ULL,
0x0000000e29457208ULL, 0x000fe20004000000ULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x000000520f00720bULL, 0x000fc40003f1e000ULL, 0x000000244500720bULL, 0x000fe40003f3e000ULL,
0x0000000f520e7208ULL, 0x000fe40004000000ULL, 0x0000004524107208ULL, 0x000fe20004800000ULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x000000530e00720bULL, 0x000fe40003f1e000ULL,
0x000000251000720bULL, 0x000fe40003f3e000ULL, 0x0000000e530f7208ULL, 0x000fc40004000000ULL,
0x0000001025457208ULL, 0x000fe20004800000ULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x0000004a0f00720bULL, 0x000fe40003f1e000ULL, 0x000000204500720bULL, 0x000fe40003f3e000ULL,
0x0000000f4a0e7208ULL, 0x000fe40004000000ULL, 0x0000004520107208ULL, 0x000fe20004800000ULL,
0x0000005400547308ULL, 0x000ee20000000800ULL, 0x0000004b0e00720bULL, 0x000fc40003f1e000ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000000e4b0f7208ULL, 0x000fe40004000000ULL,
0x0000001021107208ULL, 0x000fe20004800000ULL, 0x0000004700477308ULL, 0x000fe20000000800ULL,
0x000000420f00720bULL, 0x000fe40003f1e000ULL, 0x000000113011723eULL, 0x004fe200000010ffULL,
0x0c401f0010457f89ULL, 0x000ea200000e0000ULL, 0x0000000f420e7208ULL, 0x000fc60004000000ULL,
0x0000005800587308ULL, 0x000f620000000800ULL, 0x000000430e00720bULL, 0x000fc80003f1e000ULL,
0x0000000e430f7208ULL, 0x000fc60004000000ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x000000160f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f160f7208ULL, 0x000fc60004000000ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x000000180f00720bULL, 0x000fe40003f1e000ULL,
0x000000451000720bULL, 0x004fe40003f3e000ULL, 0x0000000f180f7208ULL, 0x000fe40004000000ULL,
0x0000001045107208ULL, 0x000fe20004800000ULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x0000002e0f00720bULL, 0x000fc60003f1e000ULL, 0x0c201f0010137f89ULL, 0x000ea200000e0000ULL,
0x0000000f2e0e7208ULL, 0x000fc60004000000ULL, 0x0000001200457308ULL, 0x0005e20000000800ULL,
0x0000002f0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e2f0f7208ULL, 0x000fc60004000000ULL,
0x0000003f003f7308ULL, 0x000fe20000000800ULL, 0x0000002a0f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f2a0e7208ULL, 0x000fc60004000000ULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x0000002b0e00720bULL, 0x000fe40003f1e000ULL, 0x000000131000720bULL, 0x004fe40003f3e000ULL,
0x0000000e2b0f7208ULL, 0x000fe40004000000ULL, 0x00000010130e7208ULL, 0x000fe20004800000ULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x000000260f00720bULL, 0x000fe40003f1e000ULL,
0x000000315413723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b0e127820ULL, 0x002fe20000410000ULL,
0x0000000f26107208ULL, 0x000fc40004000000ULL, 0xfffffff8ff547812ULL, 0x000fe200078ee219ULL,
0x3fb8aa3b0a557823ULL, 0x100fe20000010812ULL, 0x000000271000720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010812ULL, 0x00000010270f7208ULL, 0x000fe20004000000ULL,
0x0000004900627308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b40367823ULL, 0x100fe20000010812ULL, 0x000000220f00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b414f7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b145c7823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b2c577823ULL, 0x100fe20000010812ULL, 0x0000000f22107208ULL, 0x000fe20004000000ULL,
0x0000004800337308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b21497823ULL, 0x102fe20000010812ULL,
0x3fb8aa3b2d607823ULL, 0x100fe20000010812ULL, 0x000000231000720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b295a7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b24407823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b25417823ULL, 0x100fe20000010812ULL, 0x0000001023107208ULL, 0x000fe20004000000ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20487823ULL, 0x004fe20000010812ULL,
0x0000001854597836ULL, 0x000fc40000000000ULL, 0x0c401f00100f7f89ULL, 0x000e6800000e0000ULL,
0x0000005100327308ULL, 0x0004f00000000800ULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28517823ULL, 0x004fe20000010812ULL, 0x000000151e12723eULL, 0x000fc400000010ffULL,
0x0000001f501e723eULL, 0x000fe400000010ffULL, 0x00000047581f723eULL, 0x020fe200000010ffULL,
0x0000001054587836ULL, 0x000fe20000000000ULL, 0x000000173214723eULL, 0x008fe200000010ffULL,
0x0000005c005c7308ULL, 0x000fe20000000800ULL, 0x0000000f1000720bULL, 0x002fc80003f1e000ULL,
0x000000100f0f7208ULL, 0x000fc60004000000ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x0000000b1c10723eULL, 0x000fe400000010ffULL, 0x0000001d4c1c723eULL, 0x000fe200000010ffULL,
0x0c201f000f0a7f89ULL, 0x000e6200000e0000ULL, 0x0000004d561d723eULL, 0x000fe200000010ffULL,
0x0000000854567836ULL, 0x000fe40000000000ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x00000008584d7824ULL, 0x000fce00078e00ffULL, 0x0000005700577308ULL, 0x000ff00000000800ULL,
0x0000006000607308ULL, 0x000fe20000000800ULL, 0x0000000a0f00720bULL, 0x002fc80003f1e000ULL,
0x0000000f0a0f7208ULL, 0x000fe20004000000ULL, 0x00000009ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x0000000305ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b0f217820ULL, 0x000fe20000410000ULL, 0x3f8000000a0a783eULL, 0x000fc600000010ffULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b16207823ULL, 0x000fe20000010821ULL, 0x000000336216723eULL, 0x000fe200000010ffULL,
0x0000004a004a7308ULL, 0x000fe20000000800ULL, 0x000000ffff0b7224ULL, 0x000fe200078e000aULL,
0x00000003ff627819ULL, 0x000fe20000011605ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010821ULL,
0x0000000405197810ULL, 0x000fe20007ffe062ULL, 0x3fb8aa3b43437823ULL, 0x000fe20000010821ULL,
0x0000004b004b7308ULL, 0x000e620000000800ULL, 0x0000000a1030723cULL, 0x000fe200000418ffULL,
0x0000000719247812ULL, 0x000fca00078ec0ffULL, 0x000000ffff197224ULL, 0x100fe400078e000aULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010821ULL, 0x000000ffff5d7224ULL, 0x000fe400078e000aULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe20000010821ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x0000004a4b17723eULL, 0x002fce00000010ffULL, 0x0000005300537308ULL, 0x000e620000000800ULL,
0x00000008564b7824ULL, 0x000fce00078e00ffULL, 0x00000018004a7308ULL, 0x0005e20000000800ULL,
0x0000000a1c30723cULL, 0x000fe20000041830ULL, 0x000000525315723eULL, 0x002fcc00000010ffULL,
0x0000002000297308ULL, 0x0002e20000000800ULL, 0x000000ffff187224ULL, 0x104fe400078e000aULL,
0x3fb8aa3b260b7823ULL, 0x100fe20000010821ULL, 0x0000000859537824ULL, 0x000fe200078e00ffULL,
0x000000555c26723eULL, 0x000fe200000010ffULL, 0x000000ffff5c7224ULL, 0x000fe400078e000aULL,
0x3fb8aa3b22527823ULL, 0x100fe20000010821ULL, 0x0000003c3922723eULL, 0x000fe200000010ffULL,
0x0000002e00477308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b2f207823ULL, 0x002fce0000010821ULL,
0x0000004200257308ULL, 0x0003e20000000800ULL, 0x00000018142c723cULL, 0x004fee00000418ffULL,
0x0000004300287308ULL, 0x0005620000000800ULL, 0xfffffff84d427812ULL, 0x002fe200078ee224ULL,
0x3fb8aa3b274d7823ULL, 0x000fe20000010821ULL, 0xfffffff84b197812ULL, 0x000fc400078ee224ULL,
0xfffffff853187812ULL, 0x000fe200078ee224ULL, 0x3fb8aa3b23537823ULL, 0x000fe20000010821ULL,
0x000000294a27723eULL, 0x008fe200000010ffULL, 0x0000005a005a7308ULL, 0x000fe20000000800ULL,
0x0000000854437824ULL, 0x004fe200078e00ffULL, 0x0000003e3f21723eULL, 0x000fe200000010ffULL,
0x000000ffff3e7224ULL, 0x100fe200078e000aULL, 0x000000454e23723eULL, 0x000fe200000010ffULL,
0x000000ffff3f7224ULL, 0x000fe200078e000aULL, 0xfffffff843437812ULL, 0x000fe200078ee224ULL,
0x0000000856457824ULL, 0x000fe200078e00ffULL, 0x000000364f24723eULL, 0x000fe200000010ffULL,
0x00000020004c7308ULL, 0x0002a20000000800ULL, 0x000000252825723eULL, 0x020fc400000010ffULL,
0x000000576028723eULL, 0x000fe400000010ffULL, 0x0000000362367812ULL, 0x000fc600078ec0ffULL,
0x0000005c242c723cULL, 0x000fe2000004182cULL, 0x0000002a004b7308ULL, 0x0007e20000000800ULL,
0x000000443d20723eULL, 0x002fe200000010ffULL, 0x0000000136367824ULL, 0x000fe400078e0205ULL,
0x00000008543d7824ULL, 0x000fe200078e00ffULL, 0x000000474c29723eULL, 0x004fe200000010ffULL,
0x0000000858477824ULL, 0x000fe400078e00ffULL, 0x0000002b00507308ULL, 0x000e620000000800ULL,
0x000000515a2a723eULL, 0x008fe200000010ffULL, 0x0000003e2030723cULL, 0x000fe20000041830ULL,
0x0000000736367812ULL, 0x000fe200078ec0ffULL, 0x000000ffff5c7224ULL, 0x000fc600078e0008ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee236ULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0xfffffff845457812ULL, 0x000fe400078ee236ULL, 0xfffffff847477812ULL, 0x000fe400078ee236ULL,
0x0000004b502b723eULL, 0x002fc600000010ffULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x00000008594b7824ULL, 0x000fc600078e00ffULL, 0x0000003e282c723cULL, 0x000fe4000004182cULL,
0xfffffff84b4b7812ULL, 0x000fe400078ee236ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x000000353836723eULL, 0x000fe400000010ffULL, 0x0000003a3735723eULL, 0x004fca00000010ffULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x000000341b34723eULL, 0x002fce00000010ffULL,
0x0000004600467308ULL, 0x000e620000000800ULL, 0x00001000781b7824ULL, 0x000fce00078e0209ULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x0000003b4637723eULL, 0x002fce00000010ffULL,
0x0000004900497308ULL, 0x000e620000000800ULL, 0x0000003e3430723cULL, 0x000fee0000041830ULL,
0x0000004000407308ULL, 0x000fe20000000800ULL, 0x000000ffff3e7224ULL, 0x000fe200078e001cULL,
0x00000048493a723eULL, 0x002fcc00000010ffULL, 0x0000004100417308ULL, 0x000e620000000800ULL,
0x000000ffff487224ULL, 0x100fe400078e000aULL, 0x000000ffff497224ULL, 0x000fe400078e000aULL,
0x000000ffff3f7224ULL, 0x000fe400078e001eULL, 0x000000ffff1c7224ULL, 0x000fe200078e0021ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0035ULL,
0x000000ffff217224ULL, 0x000fc400078e0016ULL, 0x000000ffff357224ULL, 0x000fe200078e002aULL,
0x000000404138723eULL, 0x002fe400000010ffULL, 0x0000004d003c7308ULL, 0x000e620000000800ULL,
0x000120001b407836ULL, 0x000fe40000000000ULL, 0x000000ffff417224ULL, 0x000fe400078e0022ULL,
0x000000103d0a7824ULL, 0x100fe400078e0240ULL, 0x0000001019197824ULL, 0x100fe200078e0240ULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x00000010421b7824ULL, 0x000fc400078e0240ULL,
0x000000ffff3d7224ULL, 0x000fe400078e0012ULL, 0x0000001018187824ULL, 0x000fe200078e0240ULL,
0x0000000b3c39723eULL, 0x002fe400000010ffULL, 0x0000005300537308ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0010ULL, 0x00000010430b7824ULL, 0x100fe400078e0240ULL,
0x0000001045457824ULL, 0x100fe200078e0240ULL, 0x0000003c0a007844ULL, 0x0005e20000000200ULL,
0x0000001047477824ULL, 0x000fc400078e0240ULL, 0x000000104b4b7824ULL, 0x000fe400078e0240ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff407224ULL, 0x000fe200078e0020ULL,
0x00000052533b723eULL, 0x002fe200000010ffULL, 0x000000ffff427224ULL, 0x000fe400078e0034ULL,
0x000000ffff437224ULL, 0x000fe400078e0036ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x00000048382c723cULL, 0x000fe2000004182cULL, 0x000000ffff127224ULL, 0x000fe200078e001dULL,
0x000000400b007844ULL, 0x0003e20000000200ULL, 0x000000ffff137224ULL, 0x000fe400078e001fULL,
0x000000ffff1d7224ULL, 0x000fe400078e0023ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0037ULL,
0x0000001045007844ULL, 0x0003e20000000200ULL, 0x000000ffff207224ULL, 0x000fe400078e0014ULL,
0x000000ffff227224ULL, 0x000fe200078e0024ULL, 0x0000001c19007844ULL, 0x0003e20000000200ULL,
0x000000ffff237224ULL, 0x000fc400078e0026ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff347224ULL, 0x000fe200078e0028ULL, 0x0000002047007844ULL, 0x0003e20000000200ULL,
0x000000ffff367224ULL, 0x000fe400078e0038ULL, 0x000000ffff377224ULL, 0x000fe400078e003aULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff167224ULL, 0x000fe200078e0025ULL,
0x000000341b007844ULL, 0x0003e20000000200ULL, 0x000000ffff177224ULL, 0x000fc400078e0027ULL,
0x000000ffff247224ULL, 0x000fe400078e0029ULL, 0x000000ffff257224ULL, 0x000fe200078e002bULL,
0x000000144b007844ULL, 0x0003e20000000200ULL, 0x000000ffff267224ULL, 0x000fe400078e0039ULL,
0x000000ffff277224ULL, 0x000fe400078e003bULL, 0x000000ffff317224ULL, 0x000fe400078e0032ULL,
0x000000ffff327224ULL, 0x000fe200078e002cULL, 0x0000002418007844ULL, 0x0003e20000000200ULL,
0x000000ffff337224ULL, 0x000fc400078e002eULL, 0x00000001ff0a7424ULL, 0x004fe200078e00ffULL,
0x01a0000c1a008388ULL, 0x0003e80000000c00ULL, 0x01a200301a008388ULL, 0x0003e20000000c00ULL,
0x0000006b5e00720cULL, 0x000fe20003f06070ULL, 0x01a6080a5fff79a7ULL, 0x0003e2000850003fULL,
0x01a6100a5fff79a7ULL, 0x0003e2000850003fULL, 0x01a6180a5fff79a7ULL, 0x0003e2000850003fULL,
0x01a6200a5fff79a7ULL, 0x0003f2000850003fULL, 0xffffff8800c08947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000083007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008300008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff83ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000083027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008300007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe70023c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004ebULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000668ULL, 0x0000000000000228ULL, 0x0000001500000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000970ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c4ULL, 0x0000000000000700ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001110ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000019000ULL, 0x0000001500000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a180ULL, 0x0000000000000040ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a1c0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000001a1c0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x000000000001a7b0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001a7b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000001110ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019000ULL,
0x0000000000019000ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001a180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001a1c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_90_cubin_len = 108800;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
