/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000164d0ULL, 0x0000000000016150ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x00000000000145b0ULL,
0x0000000000000180ULL, 0x000b0022000004c4ULL, 0x0000000000014730ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000014770ULL, 0x0000000000000050ULL, 0x000b002200000519ULL,
0x00000000000147c0ULL, 0x0000000000000140ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000014900ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000145b000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x00502c0400288080ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808b0828808081ULL, 0x92082880808c0828ULL, 0x2880809408288080ULL,
0x8096082880809508ULL, 0x0828808097082880ULL, 0x80809e082880809cULL, 0xa908288080a30828ULL,
0x288080ab08288080ULL, 0x808408288080c908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080849200ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x000145b000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8086288080840900ULL, 0x0000000000002880ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808b0828808081ULL, 0x92082880808c0828ULL, 0x2880809408288080ULL,
0x8096082880809508ULL, 0x0828808097082880ULL, 0x80809e082880809cULL, 0xab08288080a90828ULL,
0x288080c908288080ULL, 0x828016288080b008ULL, 0x0000000003102880ULL, 0x8080b09200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000013000000000ULL, 0x0001473000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808b0828808081ULL,
0x92082880808c0828ULL, 0x2880809408288080ULL, 0x8096082880809508ULL, 0x0828808097082880ULL,
0x80809e082880809cULL, 0xa908288080a30828ULL, 0x288080ab08288080ULL, 0x828016288080c908ULL,
0x0000000003102880ULL, 0x8080c99200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL,
0x000001e000000000ULL, 0x0001477000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x809e288080c90900ULL, 0x0000000000002880ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808b0828808081ULL,
0x92082880808c0828ULL, 0x2880809408288080ULL, 0x8096082880809508ULL, 0x0828808097082880ULL,
0x8080a9082880809cULL, 0xc908288080ab0828ULL, 0x2880809e08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x000022002880809eULL, 0x0000001cffffffffULL, 0x000002a000000000ULL,
0x000147c000000000ULL, 0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001a00082f04ULL,
0x0008230400000096ULL, 0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL,
0x0000000000000016ULL, 0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL,
0x0000001500081104ULL, 0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL,
0x0000001a00081204ULL, 0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL,
0x0000001700080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x0134290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01342804ffffffffULL, 0x000000d0000000c0ULL, 0x0000233000000400ULL, 0x00002500000023f0ULL,
0x00002ae000002670ULL, 0x00002b6000002b10ULL, 0x0000556000002bb0ULL, 0x0000573000005600ULL,
0x00005d0000005890ULL, 0x00005d8000005d30ULL, 0x000084c000005dd0ULL, 0x0000869000008560ULL,
0x00008c60000087f0ULL, 0x00008ce000008c90ULL, 0x0000b42000008d30ULL, 0x0000b5e00000b4c0ULL,
0x0000bba00000b740ULL, 0x0000bc200000bbd0ULL, 0x0000d5300000bc70ULL, 0x00012da00000d540ULL,
0x00012df000012de0ULL, 0x00012e5000012e00ULL, 0x00012e9000012e70ULL, 0x00013b4000012ea0ULL,
0x00013be000013b90ULL, 0x00013c9000013c30ULL, 0x00013d4000013cf0ULL, 0x00013dd000013d90ULL,
0x00013e8000013e20ULL, 0x00013f2000013ed0ULL, 0x00013fb000013f70ULL, 0x0001406000014000ULL,
0x00014100000140b0ULL, 0x000141a000014150ULL, 0x00014250000141f0ULL, 0x000142f0000142a0ULL,
0x000143b000014350ULL, 0x0001447000014410ULL, 0x00014530000144d0ULL, 0x0440390400014590ULL,
0x000000ff00000210ULL, 0x003f01000000f600ULL, 0x0000000d000002a0ULL, 0x003f01200000f608ULL,
0x0000000d00000370ULL, 0x003f01200000f688ULL, 0x0000000d000003a0ULL, 0x003f01200000f6a8ULL,
0x0000000d000003d0ULL, 0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL,
0x0000000b00000600ULL, 0x003f010200000004ULL, 0x0000000b000006b0ULL, 0x003f010100000000ULL,
0x000000ff00001000ULL, 0x0004010700000000ULL, 0x000000ff00001080ULL, 0x0004010100000000ULL,
0x00000008000010e0ULL, 0x003f010100000020ULL, 0x00000007000012a0ULL, 0x003f01050000f6ccULL,
0x0000000700001490ULL, 0x003f01050000f6ccULL, 0x0000000d00001e80ULL, 0x003f01070000f6a8ULL,
0x0000000d00001fd0ULL, 0x003f01010000f6a8ULL, 0x0000000f00002030ULL, 0x003f01010000f608ULL,
0x0000000f00002050ULL, 0x003f01050000f60cULL, 0x0000000f00002220ULL, 0x003f01050000f60cULL,
0x0000002200002840ULL, 0x003f01050000f6acULL, 0x0000002200002a10ULL, 0x003f01050000f6acULL,
0x0000001c000044c0ULL, 0x003f01010000f6c8ULL, 0x0000005700004540ULL, 0x003f01010000f688ULL,
0x0000000c000045d0ULL, 0x003f010500000004ULL, 0x0000000c000047a0ULL, 0x003f010500000004ULL,
0x0000005500005190ULL, 0x003f01070000f6a8ULL, 0x0000005500005260ULL, 0x003f01010000f6a8ULL,
0x0000000f000052c0ULL, 0x003f01010000f628ULL, 0x0000000f000052e0ULL, 0x003f01050000f62cULL,
0x0000000f000054b0ULL, 0x003f01050000f62cULL, 0x0000000d00005a60ULL, 0x003f01050000f6acULL,
0x0000000d00005c30ULL, 0x003f01050000f6acULL, 0x0000001c000074d0ULL, 0x003f010100000000ULL,
0x0000005700007540ULL, 0x003f01010000f690ULL, 0x0000000c000075b0ULL, 0x003f010500000004ULL,
0x0000000c00007780ULL, 0x003f010500000004ULL, 0x0000005600008060ULL, 0x003f010700000000ULL,
0x0000000d000081c0ULL, 0x003f01010000f6a8ULL, 0x0000000f00008220ULL, 0x003f01010000f648ULL,
0x0000000f00008240ULL, 0x003f01050000f64cULL, 0x0000000f00008410ULL, 0x003f01050000f64cULL,
0x00000055000089c0ULL, 0x003f01050000f6acULL, 0x0000005500008b90ULL, 0x003f01050000f6acULL,
0x0000001c0000a470ULL, 0x003f010100000000ULL, 0x000000570000a4e0ULL, 0x003f01010000f698ULL,
0x0000000c0000a570ULL, 0x003f010500000004ULL, 0x0000000c0000a740ULL, 0x003f010500000004ULL,
0x000000540000b040ULL, 0x003f010700000000ULL, 0x000000550000b120ULL, 0x003f01010000f6a8ULL,
0x0000000f0000b180ULL, 0x003f01010000f668ULL, 0x0000000f0000b1a0ULL, 0x003f01050000f66cULL,
0x0000000f0000b370ULL, 0x003f01050000f66cULL, 0x0000000d0000b900ULL, 0x003f01050000f6acULL,
0x0000000d0000bad0ULL, 0x003f01050000f6acULL, 0x0000000c0000d2e0ULL, 0x003f010100000000ULL,
0x000000570000d340ULL, 0x003f01010000f6a0ULL, 0x000000ff0000e170ULL, 0x003f01010000f600ULL,
0x000000ff0000ef80ULL, 0x003f01050000f604ULL, 0x000000ff0000f150ULL, 0x003f01050000f604ULL,
0x000000ff0000f380ULL, 0x003f01010000f600ULL, 0x000000ff0000f3b0ULL, 0x003f01050000f604ULL,
0x000000ff0000f570ULL, 0x003f01050000f604ULL, 0x00000040000121d0ULL, 0x003f010100000000ULL,
0x00000040000122d0ULL, 0x003f010500000004ULL, 0x00000040000124a0ULL, 0x003f010500000004ULL,
0x00000042000139a0ULL, 0x003f010100000000ULL, 0x0000004200013a00ULL, 0x003f010100000008ULL,
0x0000004200013a60ULL, 0x003f010100000010ULL, 0x0000004200013ad0ULL, 0x003f010100000018ULL,
0x00141c0400053803ULL, 0x0000e0800000de00ULL, 0x0000f6900000f5d0ULL, 0x0000040100013b10ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000334ULL, 0x0000001a00000002ULL, 0x000000000000027cULL,
0x0000001a00000002ULL, 0x00000000000001ccULL, 0x0000001a00000002ULL, 0x000000000000010cULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x000000000000030fULL,
0x0000001a00000002ULL, 0x0000000000000254ULL, 0x0000001a00000002ULL, 0x00000000000001a4ULL,
0x0000001a00000002ULL, 0x00000000000000e9ULL, 0x0000001a00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff3d7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea40000002300ULL,
0x000000083d087824ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x0000000000187919ULL, 0x000f280000002600ULL, 0x0000000000077919ULL, 0x000f280000002700ULL,
0x0000000000047919ULL, 0x000f220000000000ULL, 0x00000005ff1b7819ULL, 0x002fc6000001160dULL,
0x00001fff020c7589ULL, 0x004fe800000e0000ULL, 0x00001fff1b1b7589ULL, 0x000e6200000e0000ULL,
0x0000010002007a24ULL, 0x008fe400078e0203ULL, 0x0000001200037300ULL, 0x000ea200000e0000ULL,
0x0000000818067824ULL, 0x010fe400078e00ffULL, 0x00000000000d7a24ULL, 0x000fc400078e020dULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x00000007080a7224ULL, 0x000fe400078e0206ULL,
0x000000ff0d00720cULL, 0x040fe20003f45270ULL, 0x0000001200127309ULL, 0x000f220000000000ULL,
0x0000007f0d00780cULL, 0x040fe40003f84070ULL, 0x0000000f0d00780cULL, 0x040fe40003f64070ULL,
0x000000030d00780cULL, 0x000fe40003f24070ULL, 0x000000040300720cULL, 0x004fe20003f02070ULL,
0x000000040c097824ULL, 0x002fc800078e021bULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x0000000209067824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe200078e00ffULL,
0x00000004ff0f7819ULL, 0x008fe20000011600ULL, 0xff317217ff10c424ULL, 0x000fe200078e00ffULL,
0x00000008060b7817ULL, 0x000fe40007800000ULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x000000010d00780cULL, 0x000fe20003f44070ULL, 0x3fffffc0ff04b424ULL, 0x000fc400078e00ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0a06ULL, 0x00f400100d00c388ULL, 0x0005e20000004800ULL,
0x00000001060b7824ULL, 0x000fe400078e020fULL, 0x7fffffc0ff05b424ULL, 0x000fe400078e00ffULL,
0x0000001000067824ULL, 0x000fe400078e00ffULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x00f608040d00b388ULL, 0x0003e20000008a00ULL, 0x000000010a027824ULL, 0x000fe200078e020bULL,
0x000000f006117812ULL, 0x000fe200078ec0ffULL, 0x000000010b107824ULL, 0x004fe200078e0200ULL,
0x0000000e0f00720cULL, 0x000fe20003f66070ULL, 0x000000100b137824ULL, 0x000fc400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0xfffffff013107812ULL, 0x000fe200078ee210ULL,
0x3fffff60ff089424ULL, 0x000fe200078e00ffULL, 0x0000001102027210ULL, 0x000fe20007f9e0ffULL,
0x7fffff60ff099424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff049424ULL, 0x002fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe200078e00ffULL, 0x00f688080d009388ULL, 0x0003e20000008a00ULL,
0x3fffffc0ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f6a8040d009388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fc400020e0603ULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0x00f6c80a0d00a388ULL, 0x000fe60000008a00ULL,
0x0000620007447625ULL, 0x000fc800078e000fULL, 0x0000001010097824ULL, 0x002fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff087224ULL, 0x010fe200078e0a12ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000644447981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fc40003f05270ULL,
0x0000007f441a7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff440c7810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff1a7819ULL, 0x000fe4000001161aULL, 0x00000008ff197819ULL, 0x000fca000001160cULL,
0x0000db4000008947ULL, 0x000fea0003800000ULL, 0x00000003ff5f7819ULL, 0x000fe2000001161bULL,
0x00000003ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000f6881b0b7811ULL, 0x000fe400078e18ffULL,
0x01ffffff5f5f7812ULL, 0x000fc800078ec0ffULL, 0x0000001a5f00720cULL, 0x000fda0003f06070ULL,
0x0000000207028824ULL, 0x002fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640002048624ULL, 0x000fe400078e0203ULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x000000015f048824ULL, 0x000fe200078e0204ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040a0bff738cULL, 0x0003e20000000000ULL, 0x0000600004088625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000608028981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000008018047824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe2000001161bULL, 0x000000000bff7f8cULL, 0x0007e2000c80043fULL,
0x000000011b0a7812ULL, 0x002fc600078ec0ffULL, 0x0000002003057824ULL, 0x000fca00078e00ffULL,
0x00000060040c7812ULL, 0x000fe200078ef805ULL, 0x00005800020d7a24ULL, 0x004fc800078e02ffULL,
0x000000800d177824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x000000100a097824ULL, 0x008fe200078e00ffULL, 0x0000000544087217ULL, 0x000fe40007800000ULL,
0x00000003ff0a7819ULL, 0x000fe40000011600ULL, 0x00000070061f7812ULL, 0x000fe200078ec0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a05ULL, 0x000000040a0e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090b7824ULL, 0x000fe200078e020aULL, 0x0000000c0a117810ULL, 0x000fc40007ffe0ffULL,
0x0000000908087217ULL, 0x000fe20007800000ULL, 0x000000010b0d7824ULL, 0x040fe400078e0200ULL,
0x000000080b107824ULL, 0x000fe400078e00ffULL, 0x000000010c0b7824ULL, 0x000fe400078e020bULL,
0x0000000108087824ULL, 0x000fe200078e0a09ULL, 0xfffffff8100d7812ULL, 0x000fe200078ee20dULL,
0x00000001090f7824ULL, 0x000fe200078e020eULL, 0x0000000b17167210ULL, 0x000fe20007f1e0ffULL,
0x0000000109137824ULL, 0x000fe200078e0211ULL, 0x000000080a107810ULL, 0x040fe20007ffe0ffULL,
0x000000080f1d7824ULL, 0x040fe200078e00ffULL, 0x000000080a00720cULL, 0x080fe20003f66070ULL,
0x000000010f0a7824ULL, 0x000fe200078e0200ULL, 0x000000080e00720cULL, 0x080fe20003f46070ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e00160e7a11ULL, 0x000fe200078838ffULL,
0x00000001090b7824ULL, 0x000fe200078e0210ULL, 0x000000081000720cULL, 0x080fe20003f26070ULL,
0x000000010c0f7824ULL, 0x040fe200078e020fULL, 0x000000081100720cULL, 0x000fe20003f06070ULL,
0x000000010c087824ULL, 0x000fe200078e020bULL, 0x00005f0016167a11ULL, 0x000fe200020f3c15ULL,
0x000000010c0c7824ULL, 0x000fe200078e0213ULL, 0x0000000f17147210ULL, 0x000fe20007f9e0ffULL,
0x00000008130f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d097812ULL, 0x000fe200078ee20aULL,
0x000000010b0a7824ULL, 0x100fe200078e0200ULL, 0x0000000817107210ULL, 0x000fe20007fbe0ffULL,
0x000000080b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000c170c7210ULL, 0x000fe20007fde0ffULL,
0x0000000113087824ULL, 0x000fc400078e0200ULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x00005e0014127a11ULL, 0x040fe200078838ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e06ffULL,
0xfffffff80b0b7812ULL, 0x000fe400078ee20aULL, 0x0000b000030a7811ULL, 0x000fe400078e68ffULL,
0xfffffff80f0f7812ULL, 0x000fe400078ee208ULL, 0x00005f0014147a11ULL, 0x000fe200020f3c11ULL,
0x0000001009137824ULL, 0x100fe200078e020aULL, 0x0000000e1f087210ULL, 0x000fe20007f9e0ffULL,
0x000000100b157824ULL, 0x000fc400078e020aULL, 0x000000100d117824ULL, 0x000fe200078e020aULL,
0x00005e00100d7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e06ffULL,
0x00005e000c0e7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff097224ULL, 0x000fe400020e0616ULL,
0x000000100f177824ULL, 0x000fe200078e020aULL, 0x0000001f120a7210ULL, 0x080fe40007f9e0ffULL,
0x00005f00100f7a11ULL, 0x000fe200028f3c1dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e2000d901c46ULL, 0x00005f000c067a11ULL, 0x000fe200030f3c0bULL,
0x000000ffff0b7224ULL, 0x000fe200020e0614ULL, 0x0000001f0d0c7210ULL, 0x000fc40007fbe0ffULL,
0x0000001f0e0e7210ULL, 0x000fe40007f9e0ffULL, 0x000000000a137faeULL, 0x0003e2000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fe400028e060fULL, 0x000000ffff0f7224ULL, 0x000fc600020e0606ULL,
0x000000000c157faeULL, 0x0003e8000c901c46ULL, 0x000000000e177faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x000000100a097824ULL, 0x008fe200078e00ffULL,
0x00000070061d7812ULL, 0x000fc800078ec0ffULL, 0x0000000900097211ULL, 0x000fc800078fe8ffULL,
0x00000004090b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000109087824ULL, 0x140fe400078e0200ULL,
0x00000008090d7824ULL, 0x000fe400078e00ffULL, 0x000000010b0a7824ULL, 0x040fe400078e0200ULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d087812ULL, 0x000fe200078ee208ULL,
0x000000010c0b7824ULL, 0x000fe200078e020bULL, 0x00000008090d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80f0a7812ULL, 0x000fe400078ee20aULL, 0x0000000c090f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c097824ULL, 0x040fe200078e0209ULL, 0x0000000b17127210ULL, 0x040fe20007f5e0ffULL,
0x000000010c0e7824ULL, 0x040fe400078e020dULL, 0x000000010c0c7824ULL, 0x000fe200078e020fULL,
0x0000000917147210ULL, 0x000fe20007f3e0ffULL, 0x000000010d097824ULL, 0x100fe200078e0200ULL,
0x0000000e17107210ULL, 0x000fe20007f7e0ffULL, 0x000000080d167824ULL, 0x000fe200078e00ffULL,
0x0000000c170c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0x00005e00140e7a11ULL, 0x000fe200078238ffULL, 0x000000010f0b7824ULL, 0x000fe200078e0200ULL,
0x0000b00003177811ULL, 0x000fe200078e68ffULL, 0x000000080f187824ULL, 0x000fe200078e00ffULL,
0xfffffff816097812ULL, 0x000fe200078ee209ULL, 0x000000ffff0f7224ULL, 0x000fe200018e06ffULL,
0x00005f0014147a11ULL, 0x000fe200008f3c0dULL, 0x000000100a137824ULL, 0x000fe200078e0217ULL,
0xfffffff8180b7812ULL, 0x000fe200078ee20bULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x00005e00120a7a11ULL, 0x000fe200078238ffULL, 0x0000001008117824ULL, 0x000fc400078e0217ULL,
0x0000001009157824ULL, 0x000fe200078e0217ULL, 0x00005f0012127a11ULL, 0x000fe200008f3c0dULL,
0x000000100b177824ULL, 0x000fe200078e0217ULL, 0x0000000e1d087210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e000c0e7a11ULL, 0x000fe400078638ffULL,
0x00005e00100d7a11ULL, 0x000fe200078438ffULL, 0x000000ffff097224ULL, 0x000fe200008e0614ULL,
0x0000000a1d0a7210ULL, 0x000fe40007f1e0ffULL, 0x00005f000c067a11ULL, 0x000fc400018f3c0bULL,
0x00005f00100f7a11ULL, 0x000fe200010f3c0fULL, 0x000000ffff0b7224ULL, 0x000fe200000e0612ULL,
0x0000000d1d0c7210ULL, 0x040fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e2000b901c46ULL, 0x0000000e1d0e7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060fULL, 0x000000000a137faeULL, 0x0003e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x000fc600010e0606ULL, 0x000000000c157faeULL, 0x0003e8000b901c46ULL,
0x000000000e177faeULL, 0x0003e4000b901c46ULL, 0x00000000030473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1900720cULL, 0x000fe20003f05270ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000f6a803087811ULL, 0x002fe200078e18ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff5c7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200008087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000c23000008947ULL, 0x000fea0003800000ULL, 0x0000000207087824ULL, 0x004fe400078e00ffULL,
0x00006400ff077624ULL, 0x000fc400078e00ffULL, 0x000000ffff207224ULL, 0x000fe400078e0009ULL,
0x0000640008087624ULL, 0x000fe400078e0207ULL, 0xff317217ff5c7424ULL, 0x002fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc400078e00ffULL, 0x000001000a077824ULL, 0x000fca00078e00ffULL,
0x000000440700720cULL, 0x000fda0003f06070ULL, 0x0000c14000000947ULL, 0x010fea0003800000ULL,
0x000000ffff097224ULL, 0x000fe400078e005fULL, 0x000000ffff0b7224ULL, 0x000fc400078e001cULL,
0x00000000000e7805ULL, 0x000fca0000015200ULL, 0x000000041b077824ULL, 0x000fca00078e00ffULL,
0xfffffff807077812ULL, 0x000fc800078ec0ffULL, 0x0000f6c807107810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc00070d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000022000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0010ULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0e117210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0fULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001140dULL,
0x000000110c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x000000020c0c7819ULL, 0x000fc8000000120dULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc00070d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0010ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101b077824ULL, 0x000fe200078e00ffULL, 0x000000010a0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000580002027a24ULL, 0x000fc600078e02ffULL, 0x000000190e00720cULL, 0x000fe20003f06070ULL,
0x0000008002237824ULL, 0x000fe200078e00ffULL, 0xffffffe0070d7812ULL, 0x000fe400078ec0ffULL,
0x000000011c0e7812ULL, 0x000fc600078e0cffULL, 0x000001000a0d7824ULL, 0x000fca00078e020dULL,
0x000000400d137810ULL, 0x000fc80007ffe0ffULL, 0x0000006004207812ULL, 0x000fe200078ef813ULL,
0x0000049000008947ULL, 0x000fea0003800000ULL, 0x0000001007077812ULL, 0x000fe200078ec0ffULL,
0x0000000203147824ULL, 0x000fe200078e020eULL, 0x00000003ff187819ULL, 0x000fc80000011600ULL,
0x00000004181d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001180d7824ULL, 0x000fe200078e0207ULL,
0x0000b00014147811ULL, 0x000fe400078e60ffULL, 0x0000000818217810ULL, 0x000fe20007ffe0ffULL,
0x0000000120027824ULL, 0x000fe400078e020dULL, 0x000000080d227824ULL, 0x000fc600078e00ffULL,
0x0000000223127210ULL, 0x000fe40007f1e0ffULL, 0x0000001344027217ULL, 0x000fc60007800000ULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e0012117a11ULL, 0x000fe200078038ffULL,
0x0000000102027824ULL, 0x000fe400078e0a13ULL, 0x000000011d137824ULL, 0x000fe200078e0207ULL,
0x00005f0012127a11ULL, 0x000fe200000f3c0fULL, 0x00000010000f7824ULL, 0x000fe200078e00ffULL,
0x0000000702027217ULL, 0x000fe20007800000ULL, 0x0000000120107824ULL, 0x000fe400078e0213ULL,
0x0000000813467824ULL, 0x000fe200078e00ffULL, 0x000000700f1f7812ULL, 0x000fe200078ec0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a07ULL, 0x00000010231e7210ULL, 0x000fe20007fde0ffULL,
0x000000010d0f7824ULL, 0x000fe200078e0200ULL, 0x0000001f11107210ULL, 0x000fc40007fbe0ffULL,
0x000000021800720cULL, 0x080fe20003f06070ULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0xfffffff8220f7812ULL, 0x000fe200078ee20fULL, 0x000000ffff117224ULL, 0x000fe200028e0612ULL,
0x00005e001e127a11ULL, 0x040fe400078c38ffULL, 0x000000021d00720cULL, 0x000fe20003fa6070ULL,
0x000000100f0f7824ULL, 0x000fe200078e0214ULL, 0x00005f001e1e7a11ULL, 0x000fe200030f3c0dULL,
0x00000001211d7824ULL, 0x000fe200078e0207ULL, 0x0000000c18227810ULL, 0x000fe20007ffe0ffULL,
0x00000001130d7824ULL, 0x000fc400078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e2000c101c46ULL, 0x0000000120137824ULL, 0x000fe200078e021dULL,
0x0000001f12127210ULL, 0x000fe20007f1e0ffULL, 0x0000000122077824ULL, 0x000fe200078e0207ULL,
0xfffffff8460d7812ULL, 0x000fe400078ee20dULL, 0x0000001323187210ULL, 0x000fe20007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200000e061eULL, 0x000000022100720cULL, 0x000fe20003f06070ULL,
0x000000100d0d7824ULL, 0x000fe400078e0214ULL, 0x00000008071e7824ULL, 0x000fc400078e00ffULL,
0x00000001200f7824ULL, 0x002fe200078e0207ULL, 0x00000000120d7faeULL, 0x0003e2000e901c46ULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x00005e0018107a11ULL, 0x040fe400078a38ffULL,
0x0000000f230f7210ULL, 0x000fe40007fde0ffULL, 0x00005f0018117a11ULL, 0x000fe400028f3c11ULL,
0x000000022200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff187224ULL, 0x000fe200030e06ffULL,
0x0000001f10107210ULL, 0x000fe20007fde0ffULL, 0x000000011d027824ULL, 0x000fc400078e0200ULL,
0x000000081d1d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x00005e000f127a11ULL, 0x002fe200078c38ffULL, 0x00000001070d7824ULL, 0x000fe200078e0200ULL,
0xfffffff81d077812ULL, 0x000fe400078ee202ULL, 0x00005f000f027a11ULL, 0x000fe400030f3c18ULL,
0x0000001f12127210ULL, 0x000fe20007fde0ffULL, 0x0000001007077824ULL, 0x000fe200078e0214ULL,
0xfffffff81e0d7812ULL, 0x000fc600078ee20dULL, 0x000000ffff137224ULL, 0x000fe200030e0602ULL,
0x0000000010077faeULL, 0x0003e2000c101c46ULL, 0x000000100d0d7824ULL, 0x000fca00078e0214ULL,
0x00000000120d7faeULL, 0x0003e2000e901c46ULL, 0x000003c000007947ULL, 0x000fea0003800000ULL,
0x0000001007077812ULL, 0x000fc800078ec0ffULL, 0x0000000700077211ULL, 0x000fc800078fe8ffULL,
0x00000004070f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000120027824ULL, 0x040fe200078e0207ULL,
0x0000000c07137810ULL, 0x040fe20007ffe0ffULL, 0x00000001070d7824ULL, 0x100fe400078e0200ULL,
0x000000010f107824ULL, 0x000fe200078e0200ULL, 0x0000000223227210ULL, 0x000fe20007f1e0ffULL,
0x000000080f117824ULL, 0x000fe400078e00ffULL, 0x0000000807127824ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e06ffULL, 0xfffffff811027812ULL, 0x000fe200078ee210ULL,
0x00000001200f7824ULL, 0x040fe200078e020fULL, 0x0000000807117810ULL, 0x000fe20007ffe0ffULL,
0x0000000120107824ULL, 0x000fe200078e0213ULL, 0x00005e0022217a11ULL, 0x000fc400078038ffULL,
0xfffffff8120d7812ULL, 0x000fe200078ee20dULL, 0x0000000120077824ULL, 0x000fe200078e0211ULL,
0x00005f0022227a11ULL, 0x000fe200000f3c1dULL, 0x0000000811147824ULL, 0x000fe200078e00ffULL,
0x0000000f231d7210ULL, 0x040fe40007fde0ffULL, 0x00000007231f7210ULL, 0x000fe20007fbe0ffULL,
0x0000000111077824ULL, 0x100fe200078e0200ULL, 0x0000001023187210ULL, 0x000fe20007f1e0ffULL,
0x0000000113107824ULL, 0x040fe400078e0200ULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0xfffffff8140f7812ULL, 0x000fe200078ee207ULL, 0x000000ffff1e7224ULL, 0x000fe200030e06ffULL,
0x00005e001d127a11ULL, 0x000fe200078c38ffULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0xfffffff813147812ULL, 0x000fe200078ee210ULL, 0x000000ffff107224ULL, 0x000fe200028e06ffULL,
0x00005f001d137a11ULL, 0x000fe200030f3c1eULL, 0x0000000203117824ULL, 0x000fe200078e020eULL,
0x00005e001f1e7a11ULL, 0x000fc400078a38ffULL, 0x00000070071d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00005f001f1f7a11ULL, 0x000fe400028f3c10ULL,
0x0000001d21107210ULL, 0x080fe40007f1e0ffULL, 0x0000001d12127210ULL, 0x080fe40007fbe0ffULL,
0x00005e0018207a11ULL, 0x000fe400078c38ffULL, 0x0000b00011217811ULL, 0x000fe200078e60ffULL,
0x000000ffff117224ULL, 0x000fe200000e0622ULL, 0x0000001d1e1e7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x00005f0018187a11ULL, 0x000fe200030f3c07ULL,
0x000000100d0d7824ULL, 0x100fe200078e0221ULL, 0x0000001d20207210ULL, 0x000fe20007fbe0ffULL,
0x0000001002077824ULL, 0x000fc400078e0221ULL, 0x000000100f0f7824ULL, 0x100fe200078e0221ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100d7faeULL, 0x0003e2000b901c46ULL,
0x00000010141d7824ULL, 0x000fe400078e0221ULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000000012077faeULL, 0x0003e2000b901c46ULL, 0x000000ffff217224ULL, 0x000fc600028e0618ULL,
0x000000001e0f7faeULL, 0x0003e8000b901c46ULL, 0x00000000201d7faeULL, 0x0003e4000b901c46ULL,
0x000000015f077810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff027424ULL, 0x000fc600078e00ffULL,
0x0000001a0700720cULL, 0x000fe20003f06070ULL, 0x000000081b077824ULL, 0x000fca00078e00ffULL,
0xfffffff0070d7812ULL, 0x000fca00078ec0ffULL, 0x000000080e0d7824ULL, 0x000fe400078e020dULL,
0x0000000108108810ULL, 0x000fe20007ffe05fULL, 0x00000004ff118424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffffe0070f7812ULL, 0x040fe200078ec0ffULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x0000001007127812ULL, 0x040fe400078ec0ffULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x0000000610028981ULL, 0x000322000c1e1900ULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x0000000f070f7210ULL, 0x000fe40007ffe012ULL, 0x0000f6a80d567810ULL, 0x000fd20007ffe0ffULL,
0x00000000560403c2ULL, 0x000ea40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000d507f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f608000f1e7f8cULL, 0x0002a4000c80043fULL,
0x0000000000107805ULL, 0x002fc40000015200ULL, 0x00f60c000f077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fe4000780481fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011413ULL, 0x0000001207077211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000207077819ULL, 0x000fc80000001212ULL,
0x000000070000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c000f077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x000000201b107824ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fe200078e00ffULL, 0x0000007007467812ULL, 0x000fc400078ec0ffULL,
0xffffff8010107812ULL, 0x000fe400078ec0ffULL, 0x0000000c11117812ULL, 0x000fc800078ec0ffULL,
0x0000001011077210ULL, 0x000fca0007ffe046ULL, 0x00f00000071d7984ULL, 0x000e680000000800ULL,
0x00f2000007187984ULL, 0x0004e20000000800ULL, 0x0000005c1d00720bULL, 0x002fe20003f1d000ULL,
0x000117f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000077806ULL, 0x004fc800000e0100ULL,
0x0000ffff07217812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff077424ULL, 0x000fe400078e00ffULL, 0x000000ffff537224ULL, 0x000fc400078e005cULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff147424ULL, 0x000fca00078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe4000001161bULL,
0x0000005c1d00720bULL, 0x000fe40003f14000ULL, 0x0000001b1e00720cULL, 0x000fe20003fa5270ULL,
0x000117827f007947ULL, 0x000fd4000b800000ULL, 0x0000000000207806ULL, 0x000fc400000e0100ULL,
0x000000801b1ed824ULL, 0x000fe200078e0246ULL, 0x0000001d5c537209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910201f7816ULL, 0x000fe200000000ffULL,
0x00000001111ed824ULL, 0x000fc600078e021eULL, 0x000000ff1f00720cULL, 0x000fe40003f05270ULL,
0x00f400531e00d388ULL, 0x0003f60000000800ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000535c1e7221ULL, 0x002fe20000010000ULL, 0x000000ff20ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00457308ULL, 0x0002ac0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x002fe20000011600ULL, 0x000116c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e451e7589ULL, 0x0042a400000e0000ULL, 0x0000001e28287220ULL, 0x084fe20000410000ULL,
0x0000001e29297220ULL, 0x080fe20000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001e30307220ULL, 0x080fe20000410000ULL,
0x0000001e31317220ULL, 0x080fe20000410000ULL, 0x0000001e34347220ULL, 0x080fe20000410000ULL,
0x0000001e35357220ULL, 0x080fe20000410000ULL, 0x0000001e38387220ULL, 0x080fe20000410000ULL,
0x0000001e39397220ULL, 0x080fe20000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001e3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001e40407220ULL, 0x080fe20000410000ULL,
0x0000001e41417220ULL, 0x080fe20000410000ULL, 0x0000001e24247220ULL, 0x080fe20000410000ULL,
0x0000001e25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0020ff7812ULL, 0x000fe2000780c0ffULL, 0x0000004506067220ULL, 0x004fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x002fe200078ff0ffULL,
0x000115a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e451e7589ULL, 0x0002a400000e0000ULL,
0x0000001e2a2a7220ULL, 0x084fe20000410000ULL, 0x0000001e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001e32327220ULL, 0x080fe20000410000ULL, 0x0000001e33337220ULL, 0x080fe20000410000ULL,
0x0000001e36367220ULL, 0x080fe20000410000ULL, 0x0000001e37377220ULL, 0x080fe20000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001e42427220ULL, 0x080fe20000410000ULL, 0x0000001e43437220ULL, 0x080fe20000410000ULL,
0x0000001e26267220ULL, 0x080fe20000410000ULL, 0x0000001e27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff21ff7812ULL, 0x000fda0007806020ULL,
0x800000531d1d0221ULL, 0x000fe20000010000ULL, 0x00007610ff070816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL, 0x0000001d00150308ULL, 0x000e640000000800ULL,
0x0000001518180220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000618067221ULL, 0x008fc20000010000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000000203187824ULL, 0x000fc800078e021cULL, 0x0000000818227824ULL, 0x000fca00078e00ffULL,
0x00f6ac0022187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e1d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000121207824ULL, 0x000fe200000e0e1fULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011420ULL,
0x0000001d18187211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e0620ULL,
0x0000000218187819ULL, 0x000fc8000000121dULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000123237810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0022187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991007187816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000015ff16723eULL, 0x000fe400000010ffULL, 0x00000002ff187819ULL, 0x000fe40000011600ULL,
0x00005410161d7816ULL, 0x000fe20000000016ULL, 0x000111827f007947ULL, 0x000fea000b800000ULL,
0x00001f181d177589ULL, 0x0002a400000e0000ULL, 0x0000000818167810ULL, 0x000fe20007ffe0ffULL,
0x000111b27f007947ULL, 0x000fea000b800000ULL, 0x00001f161d167589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010181e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x000fe200078e001dULL, 0x00002b7000497802ULL, 0x000fc40000000f00ULL,
0x00011c0000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018181e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x004fe200078e001dULL,
0x00002bc000497802ULL, 0x000fc40000000f00ULL, 0x00011bb000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007001d7812ULL, 0x00afe200078ec0ffULL,
0x000000021b577824ULL, 0x000fe200078e00ffULL, 0x00000004ff487819ULL, 0x100fe20000011600ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000081d457812ULL, 0x000fe200078ef800ULL,
0x000002001b1d7824ULL, 0x000fe200078e00ffULL, 0x0000000457187812ULL, 0x000fc400078ec0ffULL,
0x0000000800597812ULL, 0x000fe200078ec0ffULL, 0x00000008451f7824ULL, 0x040fe200078e00ffULL,
0x0000001845187210ULL, 0x000fe40007ffe048ULL, 0xfffff8001d4d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff81f187812ULL, 0x000fca00078ee218ULL, 0x0000001018187824ULL, 0x000fc400078e024dULL,
0x000000041b587824ULL, 0x000fe200078e00ffULL, 0x0000000759597812ULL, 0x000fe200078ef800ULL,
0x00000002034e7824ULL, 0x000fe200078e021cULL, 0x00009910074f7816ULL, 0x000fe200000000ffULL,
0x00000008454c7824ULL, 0x000fe200078e00ffULL, 0x0000000458587812ULL, 0x000fe200078ec0ffULL,
0x00000008591d7824ULL, 0x040fe200078e00ffULL, 0x0000001059497812ULL, 0x040fe200078efcffULL,
0x0000000859227824ULL, 0x000fe200078e00ffULL, 0x0000b0004e4e7811ULL, 0x000fe200078e60ffULL,
0x0000000148587824ULL, 0x000fe200078e0258ULL, 0x000000ff4f00720cULL, 0x000fe20003fa5270ULL,
0x00000008494b7824ULL, 0x000fc400078e00ffULL, 0x0000000159207824ULL, 0x000fe400078e0258ULL,
0x00000001584a7824ULL, 0x000fe400078e0249ULL, 0x0000000403487824ULL, 0x000fe200078e0248ULL,
0xfffffff81d1c7812ULL, 0x000fe200078ee220ULL, 0x0000000849527824ULL, 0x000fe200078e00ffULL,
0x0000000220477810ULL, 0x000fe40007ffe0ffULL, 0xfffffff84b467812ULL, 0x000fe200078ee24aULL,
0x000000101c1c7824ULL, 0x000fe200078e024eULL, 0xfffffff822477812ULL, 0x000fc400078ee247ULL,
0x0000000248077810ULL, 0x000fe20007ffe045ULL, 0x0000001046487824ULL, 0x100fe200078e024eULL,
0x000000024a457810ULL, 0x000fe20007ffe0ffULL, 0x0000001047207824ULL, 0x000fe200078e024eULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0xfffffff84c4c7812ULL, 0x000fe400078ee207ULL,
0xfffffff852457812ULL, 0x000fe200078ee245ULL, 0x000000004848783bULL, 0x000ee40000004200ULL,
0x000000104c077824ULL, 0x000fc400078e024dULL, 0x000000002020783bULL, 0x004ea20000004200ULL,
0x00000010454c7824ULL, 0x000fcc00078e024eULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x000000ff1e6d7812ULL, 0x002fe400078ec0ffULL, 0x00000010ff887819ULL, 0x000fe4000001161cULL,
0x00000010ff6f7819ULL, 0x108fe40000011649ULL, 0x000000ff498b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011649ULL, 0x0000ffff49607812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5d7819ULL, 0x000fe4000001161dULL, 0x0000ffff1d847812ULL, 0x000fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164bULL, 0x000000ff1c557812ULL, 0x040fe400078ec0ffULL,
0x00000018ff547819ULL, 0x000fe4000001161cULL, 0x0000ffff1c877812ULL, 0x000fc400078ec0ffULL,
0x000000ff1d5b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001161dULL,
0x00000010ff777819ULL, 0x100fe4000001161eULL, 0x00000018ff5c7819ULL, 0x000fe4000001161eULL,
0x0000ffff1e787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x000fc4000001161fULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000ffff1f837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1e7819ULL, 0x104fe20000011620ULL, 0x2000006dff817230ULL, 0x000fe20000004100ULL,
0x000000ff20807812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011620ULL,
0x0000ffff201c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1d7819ULL, 0x100fe40000011621ULL,
0x000000ff21707812ULL, 0x040fe400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe40000011621ULL,
0x0000ffff217c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001161fULL,
0x00000010ff7b7819ULL, 0x000fc40000011622ULL, 0x000000ff22747812ULL, 0x040fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fe40000011622ULL, 0x0000ffff22797812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7a7819ULL, 0x100fe40000011623ULL, 0x000000ff23767812ULL, 0x000fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fc40000011623ULL, 0x0000ffff23757812ULL, 0x000fe400078ec0ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff227819ULL, 0x000fe40000011648ULL,
0x000000ff48827812ULL, 0x040fe400078ec0ffULL, 0x0000ffff48237812ULL, 0x000fe400078ec0ffULL,
0x00000049ff49723eULL, 0x000fc400020006ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff847819ULL, 0x000fe40000011684ULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x000000ff77777812ULL, 0x000fe400078ec0ffULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x20000054ff857230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fc40000011678ULL,
0x00000008ff837819ULL, 0x000fe40000011683ULL, 0x00000018ff7e7819ULL, 0x000fe40000011648ULL,
0x00000010ff617819ULL, 0x100fe4000001164aULL, 0x000000ff4a8d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8c7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a627812ULL, 0x000fc400078ec0ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000008bff6d723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000082ff4a723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000005dff8b723eULL, 0x000fe200020006ffULL,
0x20000049ff5d7230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x000000ff22227812ULL, 0x000fe200078ec0ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000008ff237819ULL, 0x000fe40000011623ULL, 0x000000ff1f7d7812ULL, 0x000fe400078ec0ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000055ff1f723eULL, 0x000fc400020006ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000083ff49723eULL, 0x000fe200020006ffULL, 0x20000077ff837230ULL, 0x000fe20000004100ULL,
0x0000007eff54723eULL, 0x000fe200020006ffULL, 0x2000006eff7e7230ULL, 0x000fe20000004100ULL,
0x0000008aff55723eULL, 0x000fe200020006ffULL, 0x20000088ff8a7230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x2000004aff6e7230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000084ff887230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe200020006ffULL, 0x2000007fff847230ULL, 0x000fe20000004100ULL,
0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL, 0x20000078ff7f7230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x20000073ff787230ULL, 0x000fe20000004100ULL,
0x00000022ff22723eULL, 0x000fe200020006ffULL, 0x20000020ff737230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fe200020006ffULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe2000001164bULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x000000ff4b8e7812ULL, 0x040fe200078ec0ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x0000ffff4b6c7812ULL, 0x000fc400078ec0ffULL, 0x00000080ff4a723eULL, 0x000fe200020006ffULL,
0x20000049ff807230ULL, 0x000fe20000004100ULL, 0x00000070ff4b723eULL, 0x000fe400020006ffULL,
0x00000076ff77723eULL, 0x000fe200020006ffULL, 0x20000074ff767230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000021ff747230ULL, 0x000fe20000004100ULL,
0x0000005eff49723eULL, 0x000fe200020006ffULL, 0x20000023ff5e7230ULL, 0x000fe20000004100ULL,
0x0000006fff70723eULL, 0x000fe200020006ffULL, 0x20000022ff6f7230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x009000001820783bULL, 0x000e620000000200ULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x2000007dff827230ULL, 0x000fe20000004100ULL,
0x00000008ff6c7819ULL, 0x000fe2000001166cULL, 0x2000005cff7d7230ULL, 0x000fe20000004100ULL,
0x0000008cff5c723eULL, 0x000fe200020006ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000008ff627819ULL, 0x000fe20000011662ULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000063ff8c723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff4c647812ULL, 0x000fe200078ec0ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000018ff667819ULL, 0x000fe2000001164dULL, 0x2000005aff867230ULL, 0x000fe20000004100ULL,
0x00000062ff63723eULL, 0x000fe200020006ffULL, 0x2000008cff627230ULL, 0x000fe20000004100ULL,
0x000000ff4d677812ULL, 0x000fc400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe2000001164cULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000064ff8c723eULL, 0x000fe200020006ffULL,
0x2000006cff647230ULL, 0x000fe20000004100ULL, 0x000000ff4e687812ULL, 0x000fe400078ec0ffULL,
0x0000008dff5a723eULL, 0x000fe400020006ffULL, 0x00000066ff6c723eULL, 0x000fe400020006ffULL,
0x00000067ff8d723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000018ff697819ULL, 0x000fc4000001164eULL, 0x00000065ff67723eULL, 0x000fe200020006ffULL,
0x2000008cff657230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fe2000001164fULL,
0x2000008dff667230ULL, 0x000fe20000004100ULL, 0x00000068ff8c723eULL, 0x000fe200020006ffULL,
0x2000006cff687230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x0000001720208231ULL, 0x082fe200003400ffULL, 0x00000069ff6c723eULL, 0x000fe200020006ffULL,
0x2000008cff697230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe20000011687ULL,
0x2000005bff897230ULL, 0x000fe20000004100ULL, 0x0000006bff8d723eULL, 0x000fe200020006ffULL,
0x2000006cff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff1e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000001722228231ULL, 0x000fe200003400ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000008dff6c7230ULL, 0x000fe20000004100ULL, 0x0000001eff8c723eULL, 0x000fe200020006ffULL,
0x0000001621218231ULL, 0x080fe200003400ffULL, 0x000000ff1d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe2000001161fULL,
0x0000001623238231ULL, 0x000fe200003400ffULL, 0x00000010ff1d7819ULL, 0x000fe2000001168aULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff1f7819ULL, 0x000fe20000011689ULL,
0x2000008cff897230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fc4000001168bULL,
0x000010541d1e7816ULL, 0x000fe4000000001eULL, 0x000010548a1f7816ULL, 0x000fe4000000001fULL,
0x00000008ff8a7819ULL, 0x000fe4000001161cULL, 0x00000010ff1d7819ULL, 0x000fe40000011685ULL,
0x00000010ff1c7819ULL, 0x000fe20000011687ULL, 0x0000001e2028723cULL, 0x000be20000041828ULL,
0x00000010ff8b7819ULL, 0x000fc40000011686ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x000010548b1d7816ULL, 0x000fe40000000088ULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x0000001c202c723cULL, 0x000b64000004182cULL,
0x00000010ff1e7819ULL, 0x020fc40000011681ULL, 0x00000010ff1f7819ULL, 0x000fe20000011682ULL,
0x2000008dff857230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff1c7819ULL, 0x000fe4000001167fULL, 0x00000010ff1d7819ULL, 0x000fe40000011680ULL,
0x000010547d1c7816ULL, 0x000fe4000000001cULL, 0x000010547e1d7816ULL, 0x000fc4000000001dULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00001054831e7816ULL, 0x000fe4000000001eULL,
0x00001054841f7816ULL, 0x000fe2000000001fULL, 0x0000001c2034723cULL, 0x000b620000041834ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000008ff867819ULL, 0x000fe4000001167cULL,
0x0000008aff8a723eULL, 0x000fc400020006ffULL, 0x00000010ff1c7819ULL, 0x020fe20000011685ULL,
0x0000001e2030723cULL, 0x000b620000041830ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x2000008aff7c7230ULL, 0x000fe20000004100ULL, 0x000010541c4b7816ULL, 0x000fe4000000004bULL,
0x00900000071c783bULL, 0x020e620000000200ULL, 0x00000010ff487819ULL, 0x000fe2000001164cULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x000000ff7b7b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff7a7a7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff797819ULL, 0x000fe40000011679ULL,
0x00000008ff7d7819ULL, 0x000fe40000011675ULL, 0x000000ff487e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff487819ULL, 0x000fe4000001167cULL,
0x00000010ff4a7819ULL, 0x000fc4000001164aULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff757819ULL, 0x000fe40000011678ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x0000105449487816ULL, 0x000fe20000000048ULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00001054894a7816ULL, 0x000fe2000000004aULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x0000105475497816ULL, 0x000fc40000000086ULL, 0x00000008ff607819ULL, 0x000fe20000011660ULL,
0x000000171c1cd231ULL, 0x082fe200003400ffULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x0000004a2038723cULL, 0x040be20000041838ULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x000000171e1ed231ULL, 0x000fe200003400ffULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x000000161d1dd231ULL, 0x080fe200003400ffULL, 0x00000010ff747819ULL, 0x000fe20000011674ULL,
0x000000161f1fd231ULL, 0x000fe200003400ffULL, 0x00000010ff4a7819ULL, 0x020fe20000011676ULL,
0x00000048203c723cULL, 0x000b62000004183cULL, 0x00000010ff4b7819ULL, 0x000fc40000011677ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x000010547b4a7816ULL, 0x000fe4000000004aULL,
0x00000010ff487819ULL, 0x020fe20000011679ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff497819ULL, 0x000fe4000001167dULL, 0x000010547a4b7816ULL, 0x000fe4000000004bULL,
0x0000105473487816ULL, 0x000fc40000000048ULL, 0x0000105474497816ULL, 0x000fe40000000049ULL,
0x00000010ff557819ULL, 0x000fe20000011655ULL, 0x0000004a2040723cULL, 0x040f620000041840ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff717819ULL, 0x000fe4000001164dULL,
0x0000ffff4c727812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4d4d7812ULL, 0x000fe200078ec0ffULL,
0x000000482024723cULL, 0x000b620000041824ULL, 0x000000ff61617812ULL, 0x000fc400078ec0ffULL,
0x00000008ff727819ULL, 0x000fe40000011672ULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff217819ULL, 0x020fe40000011654ULL, 0x00000010ff207819ULL, 0x000fe4000001165eULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x0000105421207816ULL, 0x000fc40000000020ULL,
0x0000105455217816ULL, 0x000fe40000000060ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x0000008eff5b723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x000000201c2c723cULL, 0x000b62000004182cULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff4c7819ULL, 0x000fc4000001164eULL,
0x00000010ff217819ULL, 0x020fe2000001165cULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff207819ULL, 0x000fe40000011663ULL, 0x0000ffff4e527812ULL, 0x000fe400078ec0ffULL,
0x0000105421207816ULL, 0x000fe40000000020ULL, 0x000010545d217816ULL, 0x000fe40000000064ULL,
0x00000010ff4e7819ULL, 0x000fc4000001164fULL, 0x000000ff4f6a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x000000201c34723cULL, 0x000b620000041834ULL,
0x00000010ff4b7819ULL, 0x000fe2000001166dULL, 0x20000072ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e4e7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff527819ULL, 0x000fe40000011652ULL,
0x00000008ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff227819ULL, 0x000fe4000001165aULL,
0x00000010ff237819ULL, 0x000fe4000001165bULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff207819ULL, 0x020fe40000011667ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff217819ULL, 0x000fe4000001164dULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x2000007eff757230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000105461227816ULL, 0x000fe20000000022ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x0000105462237816ULL, 0x000fe20000000023ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000105420207816ULL, 0x000fc4000000006dULL,
0x0000105468217816ULL, 0x000fe40000000021ULL, 0x00000010ff4a7819ULL, 0x000fe2000001166eULL,
0x000000221c30723cULL, 0x040b620000041830ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff237819ULL, 0x020fe20000011666ULL, 0x000000201c3c723cULL, 0x000b62000004183cULL,
0x00000010ff227819ULL, 0x000fc40000011675ULL, 0x00000010ff487819ULL, 0x000fe40000011671ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff4d7819ULL, 0x000fe4000001166aULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff217819ULL, 0x020fe4000001164fULL,
0x000010546f4a7816ULL, 0x000fe4000000004aULL, 0x00001054704b7816ULL, 0x000fe4000000004bULL,
0x0000105422227816ULL, 0x000fc40000000065ULL, 0x0000105448237816ULL, 0x000fe40000000023ULL,
0x000010544c4c7816ULL, 0x000fe20000000069ULL, 0x0000004a1c28723cULL, 0x000f620000041828ULL,
0x000010544e4d7816ULL, 0x000fe4000000004dULL, 0x000010546b207816ULL, 0x000fe40000000052ULL,
0x000010546c217816ULL, 0x000fc60000000021ULL, 0x000000221c38723cULL, 0x040f700000041838ULL,
0x0000004c1c40723cULL, 0x040f700000041840ULL, 0x000000201c24723cULL, 0x000b6e0000041824ULL,
0x00000008031c7824ULL, 0x020fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd00000008000ULL,
0x00f6c8001c1c7f8cULL, 0x000e62000c80043fULL, 0xfffffff857577812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000400a1f7811ULL, 0x000fe200078e40ffULL,
0x00f6880057ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff207224ULL, 0x002fe200078e001dULL,
0x000000015f5f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5c7224ULL, 0x000fe200078e0053ULL,
0x000000441f00720cULL, 0x000fe20003f06070ULL, 0x000000ffff5d7224ULL, 0x000fc400078e0051ULL,
0x000000ffff1c7224ULL, 0x000fd400078e000eULL, 0x00008dc000000947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x004fc40000015200ULL, 0x000004000c1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000c1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101b1e7824ULL, 0x000fe200078e00ffULL,
0x000000010a1c7810ULL, 0x000fe20007ffe0ffULL, 0x00005800025a7a24ULL, 0x010fc600078e02ffULL,
0x000000191c00720cULL, 0x000fe20003f06070ULL, 0x000000805a5a7824ULL, 0x000fe200078e00ffULL,
0xffffffe01e1d7812ULL, 0x000fca00078ec0ffULL, 0x000001000a1d7824ULL, 0x000fca00078e021dULL,
0x000000801d1d7810ULL, 0x000fc80007ffe0ffULL, 0x00000060044a7812ULL, 0x000fe200078ef81dULL,
0x000004b000008947ULL, 0x000fea0003800000ULL, 0x000000101e4b7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff4e7819ULL, 0x000fe40000011600ULL, 0x0000001d441c7217ULL, 0x000fe40007800000ULL,
0x000000044e207810ULL, 0x040fe20007ffe0ffULL, 0x000000014e1f7824ULL, 0x040fe200078e024bULL,
0x000000084e4f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011c1c7824ULL, 0x000fc400078e0a1dULL,
0x000000011f1d7824ULL, 0x000fe400078e024aULL, 0x00000001204d7824ULL, 0x100fe200078e024bULL,
0x0000001c4b1c7217ULL, 0x000fe20007800000ULL, 0x000000011f1e7824ULL, 0x000fe200078e0200ULL,
0x0000001d5a497210ULL, 0x000fe20007f1e0ffULL, 0x000000014d1d7824ULL, 0x000fe400078e024aULL,
0x000000081f1f7824ULL, 0x000fe400078e00ffULL, 0x000000011c487824ULL, 0x100fe200078e0a4bULL,
0x0000001d5a237210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0xfffffff81f527812ULL, 0x000fe200078ee21eULL, 0x00000010001e7824ULL, 0x000fe200078e00ffULL,
0x00005e00491f7a11ULL, 0x000fe200078038ffULL, 0x000010000b1d7824ULL, 0x000fe200078e00ffULL,
0x000000482000720cULL, 0x000fe20003fa6070ULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x00005f0049497a11ULL, 0x000fe200000f3c1cULL, 0x000000014f557824ULL, 0x000fe200078e024bULL,
0x00005e0023217a11ULL, 0x000fc400078c38ffULL, 0x000000701e1c7812ULL, 0x000fe400078ec0ffULL,
0x000010001d227812ULL, 0x000fe200078ec0ffULL, 0x00000001551d7824ULL, 0x000fe200078e024aULL,
0x00005f0023237a11ULL, 0x000fe400030f3c20ULL, 0x0000001c1f1e7210ULL, 0x080fe20007f1e0ffULL,
0x0000200003227824ULL, 0x000fe200078e0222ULL, 0x0000001c21207210ULL, 0x000fc60007fde0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0649ULL, 0x000000484e00720cULL, 0x000fe20003f06070ULL,
0x000000ffff217224ULL, 0x000fe200030e0623ULL, 0x0000001d5a4c7210ULL, 0x000fe20007fde0ffULL,
0x000000084d497824ULL, 0x040fe200078e00ffULL, 0x0000b000221d7810ULL, 0x000fe20007ffe0ffULL,
0x000000014d227824ULL, 0x000fe200078e0200ULL, 0x0000000c4e4e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x000fe200030e06ffULL, 0x00005e004c4d7a11ULL, 0x000fe400078c38ffULL,
0xfffffff849227812ULL, 0x000fe200078ee222ULL, 0x0000001052497824ULL, 0x000fe200078e021dULL,
0x00005f004c4c7a11ULL, 0x000fe200030f3c23ULL, 0x000000014e5b7824ULL, 0x000fc400078e024bULL,
0x00000010224b7824ULL, 0x000fe200078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e497faeULL, 0x0003e2000c101c46ULL, 0x000000015b237824ULL, 0x000fe200078e024aULL,
0x0000001c4d227210ULL, 0x000fe40007f1e0ffULL, 0x00000000204b7faeULL, 0x0005e2000e901c46ULL,
0x000000484f00720cULL, 0x080fe40003fa6070ULL, 0x000000235a4a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff237224ULL, 0x000fe200000e064cULL, 0x000000484e00720cULL, 0x000fe20003f06070ULL,
0x0000000155487824ULL, 0x000fc400078e0200ULL, 0x0000000855557824ULL, 0x000fe400078e00ffULL,
0x000000ffff4d7224ULL, 0x000fe200030e06ffULL, 0x00005e004a1f7a11ULL, 0x042fe200078c38ffULL,
0x000000015b497824ULL, 0x000fe200078e0200ULL, 0xfffffff855487812ULL, 0x000fe200078ee248ULL,
0x000000085b4c7824ULL, 0x000fe200078e00ffULL, 0x00005f004a207a11ULL, 0x004fe400030f3c4dULL,
0x0000001c1f1e7210ULL, 0x000fe20007fde0ffULL, 0x0000001048217824ULL, 0x000fe200078e021dULL,
0xfffffff84c4a7812ULL, 0x000fc600078ee249ULL, 0x000000ffff1f7224ULL, 0x000fe200030e0620ULL,
0x0000000022217faeULL, 0x0003e2000e901c46ULL, 0x000000104a1d7824ULL, 0x000fca00078e021dULL,
0x000000001e1d7faeULL, 0x0003e2000c101c46ULL, 0x000003e000007947ULL, 0x000fea0003800000ULL,
0x000000101e1d7812ULL, 0x000fc800078ec0ffULL, 0x0000001d001f7211ULL, 0x000fc800078fe8ffULL,
0x000000041f217810ULL, 0x040fe20007ffe0ffULL, 0x000000011f1c7824ULL, 0x140fe200078e0200ULL,
0x000000081f237810ULL, 0x040fe20007ffe0ffULL, 0x000000081f1d7824ULL, 0x000fe400078e00ffULL,
0x0000000121207824ULL, 0x040fe400078e0200ULL, 0x0000000821497824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1e7812ULL, 0x000fe200078ee21cULL, 0x0000000123227824ULL, 0x040fe400078e0200ULL,
0x00000008234b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8494e7812ULL, 0x000fe200078ee220ULL,
0x000000011f1d7824ULL, 0x040fe200078e024aULL, 0x0000000c1f497810ULL, 0x000fe20007ffe0ffULL,
0x000010000b1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff84b527812ULL, 0x000fe200078ee222ULL,
0x00000001231f7824ULL, 0x100fe200078e024aULL, 0x0000001d5a227210ULL, 0x000fe20007f1e0ffULL,
0x00000001211d7824ULL, 0x000fc400078e024aULL, 0x0000000149217824ULL, 0x040fe400078e024aULL,
0x0000000149207824ULL, 0x040fe200078e0200ULL, 0x0000001d5a1d7210ULL, 0x000fe20007fbe0ffULL,
0x0000000849497824ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x00005e00224b7a11ULL, 0x000fe200078038ffULL, 0x000000ffff487224ULL, 0x000fe200028e06ffULL,
0xfffffff849547812ULL, 0x000fe400078ee220ULL, 0x000010001c207812ULL, 0x000fe200078ec0ffULL,
0x00000010001c7824ULL, 0x000fe200078e00ffULL, 0x00005e001d4d7a11ULL, 0x000fc400078a38ffULL,
0x00005f0022227a11ULL, 0x000fe200000f3c23ULL, 0x0000200003207824ULL, 0x000fe200078e0220ULL,
0x00005f001d487a11ULL, 0x000fe400028f3c48ULL, 0x0000001f5a1f7210ULL, 0x040fe40007f1e0ffULL,
0x000000215a217210ULL, 0x000fe40007fbe0ffULL, 0x0000b000204f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200000e06ffULL, 0x00005e001f237a11ULL, 0x000fe200078038ffULL,
0x000000ffff4a7224ULL, 0x000fe200028e06ffULL, 0x00005e0021497a11ULL, 0x000fe200078a38ffULL,
0x000000101e1d7824ULL, 0x000fe200078e024fULL, 0x000000701c1c7812ULL, 0x000fc400078ec0ffULL,
0x00005f001f4c7a11ULL, 0x000fe400000f3c4cULL, 0x00005f00214a7a11ULL, 0x000fe400028f3c4aULL,
0x0000001c4b1e7210ULL, 0x080fe20007f1e0ffULL, 0x000000104e4b7824ULL, 0x100fe200078e024fULL,
0x0000001c4d207210ULL, 0x080fe20007fbe0ffULL, 0x00000010524d7824ULL, 0x100fe400078e024fULL,
0x000000ffff1f7224ULL, 0x000fe200000e0622ULL, 0x0000001c23227210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200028e0648ULL, 0x0000001c49487210ULL, 0x000fe20007fbe0ffULL,
0x00000010544f7824ULL, 0x000fe200078e024fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc400000e064cULL,
0x000000ffff497224ULL, 0x000fe200028e064aULL, 0x00000000204b7faeULL, 0x0003e8000b901c46ULL,
0x00000000224d7faeULL, 0x0003e8000b901c46ULL, 0x00000000484f7faeULL, 0x0003e4000b901c46ULL,
0x000000081b1e7824ULL, 0x002fe200078e00ffULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000080b1d7824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0xfffffff01e1e7812ULL, 0x000fe400078ec0ffULL, 0x000000081d1d7812ULL, 0x000fca00078ec0ffULL,
0x000000011e557824ULL, 0x000fca00078e021dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a855547810ULL, 0x000fc80007ffe0ffULL, 0x00000000540403c2ULL, 0x000e640000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x002fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800555c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628000f227f8cULL, 0x000664000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0x00f62c000f1d7984ULL, 0x000f240000000800ULL, 0x800000001dff7812ULL, 0x012fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e207210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1fULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc80000011421ULL,
0x000000201d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x000000021d1d7819ULL, 0x000fc80000001220ULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c000f1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000801c1e7810ULL, 0x000fca0007ffe010ULL, 0x00000001111e7824ULL, 0x000fca00078e021eULL,
0x00f000001e207984ULL, 0x000e680000000800ULL, 0x00f200001e1d7984ULL, 0x0006a20000000800ULL,
0x000000532000720bULL, 0x002fe20003f1d000ULL, 0x0000e7c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000217806ULL, 0x008fc800000e0100ULL, 0x0000ffff21ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x004fd200078e0053ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000011b1e7811ULL, 0x000fe400078ff0ffULL, 0x000000532000720bULL, 0x000fe40003f14000ULL,
0x0000001b1e00720cULL, 0x000fe20003fa5270ULL, 0x0000e7727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400000e0100ULL, 0x000000801b1ed824ULL, 0x000fe200078e021cULL,
0x00000053201cd209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001111fd824ULL, 0x000fe200078e021eULL, 0x00009910221e7816ULL, 0x000fc800000000ffULL,
0x00f4001c1f00d388ULL, 0x0003e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000053201c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL,
0x000000531c1c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c004b7308ULL, 0x000e640000000800ULL, 0x0000004b06067220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x0000e6827f007947ULL, 0x000fea000b800000ULL, 0x00001f1e4b1c7589ULL, 0x0002a400000e0000ULL,
0x0000001c28287220ULL, 0x084fe20000410000ULL, 0x0000001c29297220ULL, 0x080fe20000410000ULL,
0x0000001c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001c30307220ULL, 0x080fe20000410000ULL, 0x0000001c31317220ULL, 0x080fe20000410000ULL,
0x0000001c34347220ULL, 0x080fe20000410000ULL, 0x0000001c35357220ULL, 0x080fe20000410000ULL,
0x0000001c38387220ULL, 0x080fe20000410000ULL, 0x0000001c39397220ULL, 0x080fe20000410000ULL,
0x0000001c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001c40407220ULL, 0x080fe20000410000ULL, 0x0000001c41417220ULL, 0x080fe20000410000ULL,
0x0000001c24247220ULL, 0x080fe20000410000ULL, 0x0000001c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0022ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x002fe200078ff0ffULL,
0x0000e5727f007947ULL, 0x000fea000b800000ULL, 0x00001f1e4b1c7589ULL, 0x0002a400000e0000ULL,
0x0000001c2a2a7220ULL, 0x084fe20000410000ULL, 0x0000001c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001c32327220ULL, 0x080fe20000410000ULL, 0x0000001c33337220ULL, 0x080fe20000410000ULL,
0x0000001c36367220ULL, 0x080fe20000410000ULL, 0x0000001c37377220ULL, 0x080fe20000410000ULL,
0x0000001c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001c42427220ULL, 0x080fe20000410000ULL, 0x0000001c43437220ULL, 0x080fe20000410000ULL,
0x0000001c26267220ULL, 0x080fe20000410000ULL, 0x0000001c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff22ff7812ULL, 0x000fe20007800821ULL,
0x00000001ff227424ULL, 0x000fe200078e00ffULL, 0x00000053205c7209ULL, 0x000fd60007810000ULL,
0x8000005c20200221ULL, 0x000fe20000010000ULL, 0x00007610ff220816ULL, 0x000fc60000000022ULL,
0x3fb8aa3b20200820ULL, 0x000fc80000410000ULL, 0x0000002000150308ULL, 0x000e640000000800ULL,
0x000000151d1d0220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000061d067221ULL, 0x000fc40000010000ULL, 0x00000000001c7805ULL, 0x000fca0000015200ULL,
0x00f6ac000d1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac000d1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910221c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000015ff16723eULL, 0x000fe400000010ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011600ULL,
0x00005410161c7816ULL, 0x000fe20000000016ULL, 0x0000e1527f007947ULL, 0x000fea000b800000ULL,
0x00001f1d1c177589ULL, 0x0002a400000e0000ULL, 0x000000081d1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000e1827f007947ULL, 0x000fea000b800000ULL, 0x00001f1e1c167589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101d1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x00005d9000497802ULL, 0x000fc40000000f00ULL,
0x0000e9e000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181d1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x004fe200078e001cULL,
0x00005de000497802ULL, 0x000fc40000000f00ULL, 0x0000e99000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002035e7824ULL, 0x000fe200078e020eULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001591c7824ULL, 0x00afc400078e0258ULL,
0x0000000859537824ULL, 0x000fe200078e00ffULL, 0x0000b0005e5e7811ULL, 0x000fc800078e60ffULL,
0xfffffff853537812ULL, 0x000fe200078ee21cULL, 0x0000001047527824ULL, 0x100fe400078e025eULL,
0x0000001046517824ULL, 0x100fe400078e025eULL, 0x0000001053537824ULL, 0x100fe200078e025eULL,
0x000000005220783bULL, 0x004e620000004200ULL, 0x0000001045507824ULL, 0x000fc600078e025eULL,
0x000000005148783bULL, 0x000ea80000004200ULL, 0x00000000531c783bULL, 0x000ee80000004200ULL,
0x00000000504c783bULL, 0x000f220000004200ULL, 0x00000018ff787819ULL, 0x002fe40000011620ULL,
0x00000018ff6c7819ULL, 0x000fc40000011623ULL, 0x00000018ff607819ULL, 0x004fe40000011649ULL,
0x000000ff217d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff717819ULL, 0x000fe40000011623ULL,
0x000000ff23817812ULL, 0x040fe400078ec0ffULL, 0x0000ffff23797812ULL, 0x000fe400078ec0ffULL,
0x000000ff4b627812ULL, 0x000fc400078ec0ffULL, 0x000000ff1d647812ULL, 0x008fe400078ec0ffULL,
0x000000ff22807812ULL, 0x000fe400078ec0ffULL, 0x00000018ff237819ULL, 0x000fe4000001164bULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000010ff887819ULL, 0x000fe4000001161eULL,
0x000000ff1e877812ULL, 0x000fc400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe4000001161eULL,
0x0000ffff1e8b7812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff727819ULL, 0x100fe40000011648ULL, 0x000000ff486f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fc40000011648ULL, 0x0000ffff481e7812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000007dff48723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x000000ff1c637812ULL, 0x000fe200078ec0ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000064ff8d723eULL, 0x000fc400020006ffULL,
0x00000080ff7d723eULL, 0x000fe200020006ffULL, 0x20000078ff807230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fe200020006ffULL, 0x2000006cff787230ULL, 0x000fe20000004100ULL,
0x000000ff4c647812ULL, 0x010fe200078ec0ffULL, 0x20000060ff6c7230ULL, 0x000fe20000004100ULL,
0x000000ff4d657812ULL, 0x000fe200078ec0ffULL, 0x20000062ff607230ULL, 0x000fe20000004100ULL,
0x00000063ff8c723eULL, 0x000fe200020006ffULL, 0x20000023ff627230ULL, 0x000fe20000004100ULL,
0x00000018ff637819ULL, 0x000fe2000001164cULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000065ff23723eULL, 0x000fc400020006ffULL, 0x00000010ff6d7819ULL, 0x100fe40000011622ULL,
0x00000018ff6b7819ULL, 0x000fe40000011622ULL, 0x0000ffff227a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f227812ULL, 0x000fe400078ec0ffULL, 0x00000063ff65723eULL, 0x000fe200020006ffULL,
0x20000064ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff7f7819ULL, 0x100fe20000011621ULL,
0x20000023ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff7c7819ULL, 0x000fe20000011621ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000ffff21827812ULL, 0x000fc400078ec0ffULL,
0x000000ff1f907812ULL, 0x000fe400078ec0ffULL, 0x00000018ff217819ULL, 0x000fe4000001164eULL,
0x00000010ff687819ULL, 0x000fe4000001161cULL, 0x00000022ff23723eULL, 0x000fe400020006ffULL,
0x00000010ff747819ULL, 0x000fe40000011620ULL, 0x000000ff20737812ULL, 0x000fc400078ec0ffULL,
0x0000ffff207e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff207819ULL, 0x000fe4000001164fULL,
0x00000010ff6a7819ULL, 0x000fe4000001161dULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000021ff22723eULL, 0x000fe400020006ffULL, 0x000000ff68217812ULL, 0x000fe200078ec0ffULL,
0x20000023ff687230ULL, 0x000fe20000004100ULL, 0x00000018ff5b7819ULL, 0x000fc4000001161cULL,
0x0000ffff1c697812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x100fe4000001161fULL,
0x00000018ff8f7819ULL, 0x000fe4000001161fULL, 0x0000ffff1f7b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff49707812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1f7819ULL, 0x000fc40000011649ULL,
0x0000ffff491c7812ULL, 0x000fe400078ec0ffULL, 0x00000020ff23723eULL, 0x000fe400020006ffULL,
0x00000073ff49723eULL, 0x000fe200020006ffULL, 0x20000090ff737230ULL, 0x000fe20000004100ULL,
0x000000ff6a207812ULL, 0x000fe200078ec0ffULL, 0x20000023ff6a7230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000070ff90723eULL, 0x000fc400020006ffULL, 0x00000008ff697819ULL, 0x000fe20000011669ULL,
0x2000006fff707230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe200020006ffULL,
0x20000090ff6f7230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000069ff90723eULL, 0x000fe200020006ffULL, 0x20000022ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff6e7819ULL, 0x000fe2000001161dULL, 0x20000021ff917230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000020ff937230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x009800001820783bULL, 0x000e620000000200ULL,
0x0000ffff1d837812ULL, 0x000fe200078ec0ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x2000006eff8a7230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000087ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x2000008fff877230ULL, 0x000fe20000004100ULL,
0x00000081ff8f723eULL, 0x000fe200020006ffULL, 0x2000007cff817230ULL, 0x000fe20000004100ULL,
0x00000008ff7e7819ULL, 0x000fe2000001167eULL, 0x2000007dff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x2000008fff7d7230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fc400020006ffULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8b7819ULL, 0x000fe2000001168bULL, 0x20000083ff927230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000008ff827819ULL, 0x000fe40000011682ULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000008ff7b7819ULL, 0x000fc4000001167bULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000077ff8f723eULL, 0x000fe200020006ffULL,
0x2000006bff777230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7a7819ULL, 0x000fe2000001167aULL, 0x2000008fff6b7230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x000000ff71717812ULL, 0x000fe200078ec0ffULL,
0x0000001720208231ULL, 0x082fe200003400ffULL, 0x00000008ff797819ULL, 0x000fe20000011679ULL,
0x20000088ff8f7230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x0000001722228231ULL, 0x000fe200003400ffULL, 0x00000082ff83723eULL, 0x000fe200020006ffULL,
0x2000007eff827230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x2000006dff7e7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000008bff887230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000007bff8b7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000007fff7b7230ULL, 0x000fe20000004100ULL, 0x00000079ff6d723eULL, 0x000fe200020006ffULL,
0x2000007aff797230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x20000071ff7f7230ULL, 0x000fe20000004100ULL, 0x00000008ff1e7819ULL, 0x000fe2000001161eULL,
0x2000006dff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff1f1f7812ULL, 0x000fe200078ec0ffULL,
0x0000001621218231ULL, 0x080fe200003400ffULL, 0x0000005bff89723eULL, 0x000fe200020006ffULL,
0x0000001623238231ULL, 0x000fe200003400ffULL, 0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000072ff71723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x0000001eff6d723eULL, 0x000fc400020006ffULL,
0x0000001fff72723eULL, 0x000fe200020006ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fe2000001168cULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff1f7819ULL, 0x000fe2000001168dULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff8c7819ULL, 0x000fe40000011693ULL,
0x00000010ff1d7819ULL, 0x000fc4000001164aULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00001054911e7816ULL, 0x000fe4000000001eULL, 0x000010548c1f7816ULL, 0x000fe2000000001fULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff8c7819ULL, 0x000fe4000001161cULL,
0x000000ff1d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x0000001e2028723cULL, 0x000be20000041828ULL, 0x00000010ff8a7819ULL, 0x000fc4000001168aULL,
0x00000010ff1c7819ULL, 0x000fe40000011690ULL, 0x00000010ff1d7819ULL, 0x000fe40000011692ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00001054891c7816ULL, 0x000fe4000000001cULL,
0x000010548a1d7816ULL, 0x000fe2000000001dULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000000ff74747812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1e7819ULL, 0x020fe4000001166eULL,
0x00000010ff1f7819ULL, 0x000fe20000011673ULL, 0x0000001c202c723cULL, 0x000be2000004182cULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff857819ULL, 0x000fe4000001164bULL, 0x0000ffff4a847812ULL, 0x000fc400078ec0ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x000010548f1e7816ULL, 0x000fe4000000001eULL,
0x000010548e1f7816ULL, 0x000fe2000000001fULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x000000ff85897812ULL, 0x000fe400078ec0ffULL, 0x00000008ff857819ULL, 0x000fe40000011684ULL,
0x00000010ff1d7819ULL, 0x020fe20000011686ULL, 0x0000001e2030723cULL, 0x000b620000041830ULL,
0x00000010ff1c7819ULL, 0x000fc40000011688ULL, 0x00000010ff847819ULL, 0x000fe40000011687ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x00001054841d7816ULL, 0x000fe4000000008bULL, 0x00000010ff1e7819ULL, 0x020fe40000011648ULL,
0x00000010ff497819ULL, 0x000fc40000011649ULL, 0x00000010ff487819ULL, 0x000fe20000011674ULL,
0x0000001c2034723cULL, 0x000b620000041834ULL, 0x00000010ff1f7819ULL, 0x000fe4000001167bULL,
0x0000105448487816ULL, 0x000fe40000000049ULL, 0x000010541f497816ULL, 0x000fe4000000001eULL,
0x00980000071c783bULL, 0x020e620000000200ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x000000ff4a5f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe2000001164aULL,
0x20000085ff747230ULL, 0x000fe20000004100ULL, 0x0000ffff4b4b7812ULL, 0x000fe200078ec0ffULL,
0x000000482038723cULL, 0x000b620000041838ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164cULL,
0x00000008ff847819ULL, 0x000fe4000001164bULL, 0x000000ff4a857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4b7819ULL, 0x000fc40000011680ULL, 0x00000010ff4a7819ULL, 0x000fe40000011682ULL,
0x00000010ff807819ULL, 0x000fe40000011681ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x000010544b4a7816ULL, 0x000fe4000000004aULL, 0x00001054804b7816ULL, 0x000fe40000000083ULL,
0x00000010ff487819ULL, 0x020fc4000001167cULL, 0x00000010ff497819ULL, 0x000fe4000001167eULL,
0x00000010ff807819ULL, 0x000fe2000001167dULL, 0x0000004a203c723cULL, 0x000b62000004183cULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff4a7819ULL, 0x020fe20000011679ULL,
0x000000171c1c8231ULL, 0x082fe200003400ffULL, 0x00000010ff4b7819ULL, 0x000fe2000001167aULL,
0x000000171e1e8231ULL, 0x000fe200003400ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x000000161d1d8231ULL, 0x080fe200003400ffULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x000000161f1f8231ULL, 0x000fe200003400ffULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000105449487816ULL, 0x000fe20000000048ULL,
0x2000008dff6e7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000089ff7b7230ULL, 0x000fe20000004100ULL, 0x000010547f497816ULL, 0x000fc40000000080ULL,
0x00001054774a7816ULL, 0x000fe2000000004aULL, 0x2000008cff737230ULL, 0x000fe20000004100ULL,
0x00001054784b7816ULL, 0x000fe4000000004bULL, 0x00000010ff767819ULL, 0x000fe2000001164dULL,
0x000000482040723cULL, 0x000b620000041840ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x00000010ff487819ULL, 0x020fe20000011670ULL, 0x0000004a2024723cULL, 0x000b620000041824ULL,
0x00000010ff497819ULL, 0x000fe4000001166fULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff227819ULL, 0x020fe4000001165fULL,
0x00000010ff237819ULL, 0x000fc4000001166eULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff207819ULL, 0x000fe4000001166dULL,
0x00000010ff217819ULL, 0x000fe40000011673ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000085ff7c7230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000105423227816ULL, 0x000fe20000000022ULL,
0x20000084ff7d7230ULL, 0x000fe20000004100ULL, 0x000010547b237816ULL, 0x000fe20000000060ULL,
0x20000076ff707230ULL, 0x000fe20000004100ULL, 0x0000ffff4c757812ULL, 0x000fe400078ec0ffULL,
0x0000105471487816ULL, 0x000fc40000000048ULL, 0x0000105472497816ULL, 0x000fe20000000049ULL,
0x000000221c30723cULL, 0x040b620000041830ULL, 0x000010546b207816ULL, 0x000fe40000000020ULL,
0x000010546c217816ULL, 0x000fe40000000021ULL, 0x00000018ff667819ULL, 0x000fe4000001164dULL,
0x00000010ff5b7819ULL, 0x000fe2000001164eULL, 0x000000481c28723cULL, 0x000f620000041828ULL,
0x000000ff4e677812ULL, 0x000fc400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fe4000001164fULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x000000201c2c723cULL, 0x000b62000004182cULL, 0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff757819ULL, 0x000fe40000011675ULL, 0x00000008ff4d7819ULL, 0x000fc4000001164dULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff227819ULL, 0x020fe40000011663ULL, 0x00000010ff237819ULL, 0x000fc4000001167cULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff207819ULL, 0x000fe40000011674ULL, 0x00000010ff217819ULL, 0x000fe4000001167dULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff497819ULL, 0x000fc40000011670ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000075ff6f7230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fe20000000022ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x0000105461207816ULL, 0x000fe20000000020ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000105462217816ULL, 0x000fc40000000021ULL, 0x0000105449237816ULL, 0x000fe40000000064ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x000000201c34723cULL, 0x000b620000041834ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff207819ULL, 0x020fe2000001166fULL, 0x000000221c38723cULL, 0x000b620000041838ULL,
0x00000010ff217819ULL, 0x000fe4000001164dULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff227819ULL, 0x020fe4000001165bULL,
0x00000010ff237819ULL, 0x000fc40000011668ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x0000105465207816ULL, 0x000fe40000000020ULL, 0x0000105466217816ULL, 0x000fe40000000021ULL,
0x0000105422227816ULL, 0x000fe40000000067ULL, 0x000010544c237816ULL, 0x000fe40000000023ULL,
0x00001054694e7816ULL, 0x000fe2000000004eULL, 0x000000201c3c723cULL, 0x000f62000004183cULL,
0x000010546a4f7816ULL, 0x000fce000000004fULL, 0x000000221c40723cULL, 0x040f700000041840ULL,
0x0000004e1c24723cULL, 0x000b6e0000041824ULL, 0x0000f6c8031c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000001c1c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000800a1f7811ULL, 0x000fe200078e40ffULL,
0x00f6900057ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff207224ULL, 0x002fe200078e001dULL,
0x00000001095f7810ULL, 0x000fc40007ffe0ffULL, 0x000000441f00720cULL, 0x000fe40003f06070ULL,
0x000000010b1c7812ULL, 0x000fd600078ec0ffULL, 0x00005de000000947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x004fc40000015200ULL, 0x000004000c1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc8000001141fULL, 0x0000002102027211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x0000000202027819ULL, 0x000fc8000000121fULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000c1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101b1c7824ULL, 0x000fe200078e00ffULL,
0x000000010a027810ULL, 0x000fc80007ffe0ffULL, 0x000000190200720cULL, 0x000fe40003f06070ULL,
0xffffffe01c1d7812ULL, 0x000fca00078ec0ffULL, 0x000001000a1d7824ULL, 0x000fca00078e021dULL,
0x000000c01d1f7810ULL, 0x000fc80007ffe0ffULL, 0x0000006004497812ULL, 0x000fe200078ef81fULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000101c4b7812ULL, 0x000fe200078ec0ffULL,
0x00000010001c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff227819ULL, 0x000fe40000011600ULL,
0x0000001f44027217ULL, 0x000fe40007800000ULL, 0x00000004224a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001221e7824ULL, 0x000fe200078e024bULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a1fULL, 0x00000008224d7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e1d7824ULL, 0x000fc400078e0249ULL, 0x000000014a4c7824ULL, 0x100fe200078e024bULL,
0x000000024b027217ULL, 0x000fe20007800000ULL, 0x000000011e217824ULL, 0x000fe200078e0200ULL,
0x0000001d5a1d7210ULL, 0x000fe20007f1e0ffULL, 0x000000081e4e7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe400078e0a4bULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x00005e001d1f7a11ULL, 0x000fe200078038ffULL, 0x000000084c4f7824ULL, 0x000fc600078e00ffULL,
0x00005f001d207a11ULL, 0x000fe200000f3c20ULL, 0x000000014c1d7824ULL, 0x000fe200078e0249ULL,
0x000000022200720cULL, 0x000fe40003f06070ULL, 0x0000001c1f1e7210ULL, 0x000fe40007fbe0ffULL,
0x0000001d5a487210ULL, 0x000fe40007fde0ffULL, 0xfffffff84e1d7812ULL, 0x000fe200078ee221ULL,
0x000000ffff1f7224ULL, 0x000fe200028e0620ULL, 0x000000024a00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff217224ULL, 0x000fe200030e06ffULL, 0x00005e0048237a11ULL, 0x000fe200078c38ffULL,
0x000000101d1d7824ULL, 0x000fc400078e025eULL, 0x000000014d4e7824ULL, 0x000fe200078e024bULL,
0x00005f0048487a11ULL, 0x000fe200030f3c21ULL, 0x000000014c4a7824ULL, 0x000fe200078e0200ULL,
0x0000000c224c7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0003e2000c101c46ULL, 0x000000014e217824ULL, 0x000fe200078e0249ULL,
0x0000001c23207210ULL, 0x000fe40007f1e0ffULL, 0xfffffff84f237812ULL, 0x000fe200078ee24aULL,
0x000000014c4b7824ULL, 0x000fe200078e024bULL, 0x000000215a227210ULL, 0x000fe20007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200000e0648ULL, 0x000000024d00720cULL, 0x000fe20003f06070ULL,
0x00000010231d7824ULL, 0x002fc400078e025eULL, 0x000000014b1f7824ULL, 0x040fe400078e0249ULL,
0x000000ffff237224ULL, 0x000fe200030e06ffULL, 0x00000000201d7faeULL, 0x0003e2000e901c46ULL,
0x00005e0022497a11ULL, 0x000fe400078a38ffULL, 0x0000001f5a5a7210ULL, 0x000fe40007fde0ffULL,
0x00005f00221f7a11ULL, 0x000fe200028f3c23ULL, 0x000000014b227824ULL, 0x100fe200078e0200ULL,
0x000000024c00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff237224ULL, 0x000fe200030e06ffULL,
0x0000001c491e7210ULL, 0x000fe20007fde0ffULL, 0x000000014e027824ULL, 0x000fc400078e0200ULL,
0x000000084e497824ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe200030e061fULL,
0x00005e005a217a11ULL, 0x042fe200078c38ffULL, 0x000000084b4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8491d7812ULL, 0x000fe400078ee202ULL, 0x00005f005a027a11ULL, 0x000fe400030f3c23ULL,
0x0000001c21207210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e025eULL,
0xfffffff84b237812ULL, 0x000fc600078ee222ULL, 0x000000ffff217224ULL, 0x000fe200030e0602ULL,
0x000000001e1d7faeULL, 0x0003e2000c101c46ULL, 0x0000001023237824ULL, 0x000fca00078e025eULL,
0x0000000020237faeULL, 0x0003e2000e901c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x000000101c1d7812ULL, 0x000fc800078ec0ffULL, 0x0000001d00027211ULL, 0x000fc800078fe8ffULL,
0x00000004021e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001021d7824ULL, 0x140fe400078e0249ULL,
0x00000001021c7824ULL, 0x100fe400078e0200ULL, 0x000000011e1f7824ULL, 0x000fe200078e0200ULL,
0x0000001d5a227210ULL, 0x000fe20007f1e0ffULL, 0x000000081e207824ULL, 0x000fe400078e00ffULL,
0x00000008024d7824ULL, 0x000fe400078e00ffULL, 0x000000011e1d7824ULL, 0x000fe200078e0249ULL,
0xfffffff8204f7812ULL, 0x000fe200078ee21fULL, 0x000000ffff1f7224ULL, 0x000fe200000e06ffULL,
0xfffffff84d4d7812ULL, 0x000fc400078ee21cULL, 0x00005e00224b7a11ULL, 0x000fe400078038ffULL,
0x00000008021c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c021e7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0022227a11ULL, 0x000fe200000f3c1fULL, 0x000000011c1f7824ULL, 0x100fe200078e0249ULL,
0x0000001d5a487210ULL, 0x000fe20007f1e0ffULL, 0x000000011e1d7824ULL, 0x000fe400078e0249ULL,
0x000000011c027824ULL, 0x000fe200078e0200ULL, 0x0000001f5a1f7210ULL, 0x000fe20007fbe0ffULL,
0x000000081c5b7824ULL, 0x000fe200078e00ffULL, 0x0000001d5a1d7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff237224ULL, 0x000fe200000e06ffULL, 0x00005e0048217a11ULL, 0x000fe200078038ffULL,
0x00000010001c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee202ULL,
0x000000ffff4a7224ULL, 0x000fe200028e06ffULL, 0x00005f0048487a11ULL, 0x000fe200000f3c23ULL,
0x000000011e207824ULL, 0x040fe200078e0200ULL, 0x00005e001f237a11ULL, 0x000fe200078038ffULL,
0x000000081e5f7824ULL, 0x000fe200078e00ffULL, 0x00005e001d497a11ULL, 0x000fe200078a38ffULL,
0x000000ffff027224ULL, 0x000fe200030e06ffULL, 0x000000701c1c7812ULL, 0x000fc400078ec0ffULL,
0x00005f001f4a7a11ULL, 0x000fe400000f3c4aULL, 0xfffffff85f5f7812ULL, 0x000fe400078ee220ULL,
0x00005f001d027a11ULL, 0x000fe200028f3c02ULL, 0x000000104d1d7824ULL, 0x100fe200078e025eULL,
0x0000001c4b1e7210ULL, 0x080fe20007f1e0ffULL, 0x000000104f4b7824ULL, 0x100fe200078e025eULL,
0x0000001c21207210ULL, 0x080fe20007fbe0ffULL, 0x000000105b4d7824ULL, 0x000fe400078e025eULL,
0x000000ffff1f7224ULL, 0x000fe200000e0622ULL, 0x0000001c23227210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200028e0648ULL, 0x0000001c49487210ULL, 0x000fe20007fbe0ffULL,
0x000000105f4f7824ULL, 0x000fe200078e025eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc400000e064aULL,
0x000000ffff497224ULL, 0x000fe200028e0602ULL, 0x00000000204b7faeULL, 0x0003e8000b901c46ULL,
0x00000000224d7faeULL, 0x0003e8000b901c46ULL, 0x00000000484f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000002091d7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x0000001a1d00720cULL, 0x000fda0003fa6070ULL, 0x0000004000005947ULL, 0x000fea0003800000ULL,
0x00000002081e7810ULL, 0x000fe20007ffe009ULL, 0x00000004ff1f7424ULL, 0x000fc800078e00ffULL,
0x000060001e1e7625ULL, 0x000fca00078e001fULL, 0x000000061e027981ULL, 0x000324000c1e1900ULL,
0x0000009000007945ULL, 0x000fe40003800000ULL, 0x00000000560403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8000d5a7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648000f227f8cULL, 0x0002a4000c80043fULL, 0x00000000001e7805ULL, 0x002fc40000015200ULL,
0x00f64c000f1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x006fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e207210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1fULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc80000011421ULL,
0x000000201d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x000000021d1d7819ULL, 0x000fc80000001220ULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c000f1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001001c1e7810ULL, 0x000fca0007ffe010ULL, 0x00000001111e7824ULL, 0x000fca00078e021eULL,
0x00f000001e1d7984ULL, 0x000e680000000800ULL, 0x00f200001e207984ULL, 0x0004e20000000800ULL,
0x0000005c1d00720bULL, 0x002fe20003f1d000ULL, 0x0000ba427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000217806ULL, 0x004fc800000e0100ULL, 0x0000ffff21ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff487424ULL, 0x000fe400078e00ffULL,
0x000000ffff617224ULL, 0x000fd200078e005cULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000021b1e7811ULL, 0x000fe400078ff0ffULL, 0x0000005c1d00720bULL, 0x000fe40003f14000ULL,
0x0000001b1e00720cULL, 0x000fe20003fa5270ULL, 0x0000b9f27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400000e0100ULL, 0x000000801b1ed824ULL, 0x000fe200078e021cULL,
0x0000001d5c1cd209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001111fd824ULL, 0x000fe200078e021eULL, 0x00009910221e7816ULL, 0x000fc800000000ffULL,
0x00f4001c1f00d388ULL, 0x0003e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000001d5c1f7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL,
0x8000001f5c1c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c004b7308ULL, 0x000e640000000800ULL, 0x0000004b06067220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x0000b9027f007947ULL, 0x000fea000b800000ULL, 0x00001f1e4b1c7589ULL, 0x0002a400000e0000ULL,
0x0000001c28287220ULL, 0x084fe20000410000ULL, 0x0000001c29297220ULL, 0x080fe20000410000ULL,
0x0000001c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001c30307220ULL, 0x080fe20000410000ULL, 0x0000001c31317220ULL, 0x080fe20000410000ULL,
0x0000001c34347220ULL, 0x080fe20000410000ULL, 0x0000001c35357220ULL, 0x080fe20000410000ULL,
0x0000001c38387220ULL, 0x080fe20000410000ULL, 0x0000001c39397220ULL, 0x080fe20000410000ULL,
0x0000001c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001c40407220ULL, 0x080fe20000410000ULL, 0x0000001c41417220ULL, 0x080fe20000410000ULL,
0x0000001c24247220ULL, 0x080fe20000410000ULL, 0x0000001c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0022ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x002fe200078ff0ffULL,
0x0000b7f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e4b1c7589ULL, 0x0002a400000e0000ULL,
0x0000001c2a2a7220ULL, 0x084fe20000410000ULL, 0x0000001c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001c32327220ULL, 0x080fe20000410000ULL, 0x0000001c33337220ULL, 0x080fe20000410000ULL,
0x0000001c36367220ULL, 0x080fe20000410000ULL, 0x0000001c37377220ULL, 0x080fe20000410000ULL,
0x0000001c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001c42427220ULL, 0x080fe20000410000ULL, 0x0000001c43437220ULL, 0x080fe20000410000ULL,
0x0000001c26267220ULL, 0x080fe20000410000ULL, 0x0000001c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff22ff7812ULL, 0x000fe20007800821ULL,
0x00000001ff487424ULL, 0x000fe200078e00ffULL, 0x0000001d5c617209ULL, 0x000fd60007810000ULL,
0x800000611d1d0221ULL, 0x000fe20000010000ULL, 0x00007610ff480816ULL, 0x000fc60000000048ULL,
0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL, 0x0000001d00150308ULL, 0x000e640000000800ULL,
0x0000001520200220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000620067221ULL, 0x008fc20000010000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x00f6ac00551e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00551e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910481c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000015ff16723eULL, 0x000fe400000010ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011600ULL,
0x00005410161c7816ULL, 0x000fe20000000016ULL, 0x0000b3d27f007947ULL, 0x000fea000b800000ULL,
0x00001f1d1c177589ULL, 0x0002a400000e0000ULL, 0x000000081d1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000b4027f007947ULL, 0x000fea000b800000ULL, 0x00001f1e1c167589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101d1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x00008cf000497802ULL, 0x000fc40000000f00ULL,
0x0000ba8000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181d1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x004fe200078e001cULL,
0x00008d4000497802ULL, 0x000fc40000000f00ULL, 0x0000ba3000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000010000b1c7824ULL, 0x00afe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000159587824ULL, 0x000fc400078e0258ULL,
0x00000008591d7824ULL, 0x000fe200078e00ffULL, 0x000010001c1c7812ULL, 0x000fc800078ec0ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee258ULL, 0x00002000031c7824ULL, 0x000fca00078e021cULL,
0x0000b0001c567810ULL, 0x000fca0007ffe0ffULL, 0x0000001047207824ULL, 0x100fe400078e0256ULL,
0x0000001046497824ULL, 0x100fe200078e0256ULL, 0x0000991048467816ULL, 0x000fe200000000ffULL,
0x000000101d1c7824ULL, 0x100fe400078e0256ULL, 0x000000002020783bULL, 0x004e620000004200ULL,
0x00000010454c7824ULL, 0x000fe200078e0256ULL, 0x000000ff4600720cULL, 0x000fe40003fa5270ULL,
0x000000004948783bULL, 0x000ea80000004200ULL, 0x000000001c1c783bULL, 0x000ee80000004200ULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0x00000010ff6b7819ULL, 0x002fc40000011623ULL,
0x000000ff23757812ULL, 0x040fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe40000011623ULL,
0x0000ffff23727812ULL, 0x000fe400078ec0ffULL, 0x00000018ff237819ULL, 0x004fe4000001164bULL,
0x000000ff1d5e7812ULL, 0x008fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fc40000011649ULL,
0x00000010ff667819ULL, 0x100fe4000001161dULL, 0x00000018ff687819ULL, 0x000fe4000001161dULL,
0x0000ffff1d867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff887819ULL, 0x100fe4000001161fULL,
0x000000ff1f7e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7f7819ULL, 0x000fc4000001161fULL,
0x0000ffff1f777812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b5d7812ULL, 0x000fe400078ec0ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x00000010ff1f7819ULL, 0x000fe40000011649ULL,
0x000000ff49717812ULL, 0x040fe400078ec0ffULL, 0x0000ffff491d7812ULL, 0x000fc400078ec0ffULL,
0x0000005eff85723eULL, 0x000fe400020006ffULL, 0x000000ff4c5f7812ULL, 0x040fe400078ec0ffULL,
0x00000010ff497819ULL, 0x100fe2000001164cULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000018ff5e7819ULL, 0x000fe4000001164cULL, 0x0000ffff4c6e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d607812ULL, 0x000fc400078ec0ffULL, 0x00000059ff4c723eULL, 0x000fe400020006ffULL,
0x0000005dff59723eULL, 0x000fe200020006ffULL, 0x20000023ff5d7230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000060ff23723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe40000011622ULL, 0x000000ff22787812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011622ULL, 0x0000ffff22737812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f227812ULL, 0x000fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe40000011620ULL,
0x0000005eff60723eULL, 0x000fe200020006ffULL, 0x2000005fff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x100fe20000011621ULL, 0x20000023ff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff218b7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000018ff477819ULL, 0x000fc40000011621ULL, 0x0000ffff21807812ULL, 0x000fe400078ec0ffULL,
0x00000010ff817819ULL, 0x100fe4000001161eULL, 0x000000ff1e797812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001161eULL, 0x0000ffff1e877812ULL, 0x000fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fc4000001164eULL, 0x00000010ff647819ULL, 0x000fe4000001161cULL,
0x00000010ff6c7819ULL, 0x100fe40000011648ULL, 0x000000ff48707812ULL, 0x040fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe40000011648ULL, 0x0000ffff481e7812ULL, 0x000fe400078ec0ffULL,
0x00000022ff23723eULL, 0x000fc400020006ffULL, 0x00000010ff767819ULL, 0x000fe40000011620ULL,
0x000000ff208a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff207a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b487812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x00000018ff207819ULL, 0x000fe4000001164fULL,
0x00000078ff4b723eULL, 0x000fe200020006ffULL, 0x20000074ff787230ULL, 0x000fe20000004100ULL,
0x00000021ff22723eULL, 0x000fe400020006ffULL, 0x000000ff64217812ULL, 0x000fe200078ec0ffULL,
0x20000023ff647230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000004bff747230ULL, 0x000fe20000004100ULL, 0x00000020ff23723eULL, 0x000fc400020006ffULL,
0x0000ffff1c657812ULL, 0x000fe400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x000000ff66207812ULL, 0x000fe200078ec0ffULL,
0x20000068ff837230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000023ff667230ULL, 0x000fe20000004100ULL, 0x00000070ff4b723eULL, 0x000fe200020006ffULL,
0x2000006aff707230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000079ff687230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fc400020006ffULL,
0x00000071ff6a723eULL, 0x000fe200020006ffULL, 0x20000069ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x2000004bff697230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x20000089ff4b7230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000047ff79723eULL, 0x000fe200020006ffULL, 0x2000008bff477230ULL, 0x000fe20000004100ULL,
0x00000065ff89723eULL, 0x000fe200020006ffULL, 0x20000022ff657230ULL, 0x000fe20000004100ULL,
0x000000ff76767812ULL, 0x000fe200078ec0ffULL, 0x20000021ff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000020ff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff1c467812ULL, 0x000fe200078ec0ffULL, 0x00a000001820783bULL, 0x000e620000000200ULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000008ff877819ULL, 0x000fc40000011687ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff777819ULL, 0x000fe40000011677ULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fe20000011680ULL, 0x20000076ff807230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000067ff767230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000046ff847230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000086ff8c7230ULL, 0x000fe20000004100ULL,
0x00000018ff457819ULL, 0x000fe2000001161cULL, 0x20000087ff867230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000077ff877230ULL, 0x000fe20000004100ULL,
0x00000072ff67723eULL, 0x000fe200020006ffULL, 0x20000073ff727230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x2000006bff777230ULL, 0x000fe20000004100ULL,
0x00000008ff1e7819ULL, 0x000fe2000001161eULL, 0x20000067ff737230ULL, 0x000fe20000004100ULL,
0x000000ff1f1f7812ULL, 0x000fe200078ec0ffULL, 0x0000001720208231ULL, 0x082fe200003400ffULL,
0x00000045ff82723eULL, 0x000fe200020006ffULL, 0x0000001722228231ULL, 0x000fe200003400ffULL,
0x000000ff81817812ULL, 0x000fe200078ec0ffULL, 0x0000001621218231ULL, 0x080fe200003400ffULL,
0x0000006cff6b723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x0000001eff67723eULL, 0x000fe200020006ffULL, 0x0000001623238231ULL, 0x000fe200003400ffULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x0000001fff6c723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fc40000011684ULL, 0x0000007eff46723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff1f7819ULL, 0x000fe40000011685ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff847819ULL, 0x000fe4000001168dULL,
0x00000010ff1c7819ULL, 0x000fe4000001164aULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x0000006dff7e723eULL, 0x000fe200020006ffULL, 0x20000046ff6d7230ULL, 0x000fe20000004100ULL,
0x000010548b1e7816ULL, 0x000fe2000000001eULL, 0x2000008aff467230ULL, 0x000fe20000004100ULL,
0x00001054841f7816ULL, 0x000fe2000000001fULL, 0x20000081ff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff847819ULL, 0x000fe2000001161dULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000000ff1c857812ULL, 0x000fe200078ec0ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fe20000011682ULL, 0x0000001e2028723cULL, 0x000b620000041828ULL,
0x00000010ff1c7819ULL, 0x000fc40000011689ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x00001054831d7816ULL, 0x000fe2000000008cULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x000000ff7b7b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1e7819ULL, 0x020fe40000011668ULL, 0x00000010ff1f7819ULL, 0x000fe2000001168aULL,
0x0000001c202c723cULL, 0x000b62000004182cULL, 0x00000010ff827819ULL, 0x000fe4000001166dULL,
0x00000010ff837819ULL, 0x000fe40000011688ULL, 0x0000ffff4a7c7812ULL, 0x000fe400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x000010541f1e7816ULL, 0x000fe4000000001eULL,
0x00001054831f7816ULL, 0x000fe20000000082ULL, 0x2000007bff817230ULL, 0x000fe20000004100ULL,
0x000000ff7d827812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7d7819ULL, 0x000fe4000001167cULL,
0x00000010ff1d7819ULL, 0x020fe2000001167eULL, 0x0000001e2030723cULL, 0x000b620000041830ULL,
0x00000010ff1c7819ULL, 0x000fc40000011686ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167fULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x000010547c1d7816ULL, 0x000fe40000000087ULL, 0x00000010ff1f7819ULL, 0x020fe40000011680ULL,
0x00000010ff1e7819ULL, 0x000fc40000011681ULL, 0x00000010ff467819ULL, 0x000fe20000011646ULL,
0x0000001c2034723cULL, 0x000b620000041834ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x000010541f467816ULL, 0x000fe40000000046ULL, 0x000010541e477816ULL, 0x000fe40000000047ULL,
0x00000008ff7a7819ULL, 0x000fe2000001167aULL, 0x00a00000071c783bULL, 0x020e620000000200ULL,
0x0000008eff7b723eULL, 0x000fc400020006ffULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x000000462038723cULL, 0x000b620000041838ULL, 0x0000007dff7e723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff497f7812ULL, 0x000fe200078ec0ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000007eff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff7e7819ULL, 0x000fe40000011648ULL,
0x00000010ff497819ULL, 0x000fe20000011678ULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x000fc4000001167aULL, 0x00000010ff787819ULL, 0x000fe40000011679ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x0000105449487816ULL, 0x000fe40000000048ULL,
0x0000105478497816ULL, 0x000fe4000000007bULL, 0x00000010ff6f7819ULL, 0x000fe4000001164dULL,
0x00000010ff467819ULL, 0x020fc40000011674ULL, 0x00000010ff477819ULL, 0x000fe20000011676ULL,
0x00000048203c723cULL, 0x000b62000004183cULL, 0x00000010ff787819ULL, 0x000fe40000011675ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x000000ff6f767812ULL, 0x000fe400078ec0ffULL,
0x0000105447467816ULL, 0x000fe40000000046ULL, 0x00000008ff6f7819ULL, 0x000fe2000001166eULL,
0x000000171c1cd231ULL, 0x082fe200003400ffULL, 0x00000010ff497819ULL, 0x020fe20000011670ULL,
0x000000171e1ed231ULL, 0x000fe200003400ffULL, 0x00000010ff487819ULL, 0x000fe20000011672ULL,
0x000000161d1dd231ULL, 0x080fe200003400ffULL, 0x0000105477477816ULL, 0x000fe20000000078ULL,
0x000000161f1fd231ULL, 0x000fe200003400ffULL, 0x00000010ff6e7819ULL, 0x000fc40000011671ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x000000462040723cULL, 0x000b620000041840ULL, 0x0000105449487816ULL, 0x000fe40000000048ULL,
0x000010546e497816ULL, 0x000fe20000000073ULL, 0x20000084ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff4a587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff467819ULL, 0x020fc40000011669ULL,
0x00000010ff477819ULL, 0x000fe2000001166aULL, 0x000000482024723cULL, 0x000b620000041824ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001164aULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000085ff687230ULL, 0x000fe20000004100ULL,
0x000010546b467816ULL, 0x000fc40000000046ULL, 0x000010546c477816ULL, 0x000fe20000000047ULL,
0x20000082ff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff207819ULL, 0x020fe20000011667ULL,
0x000000461c28723cULL, 0x000b620000041828ULL, 0x00000010ff217819ULL, 0x000fe4000001166dULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x000010544b207816ULL, 0x000fe20000000020ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x000010544c217816ULL, 0x000fe20000000021ULL, 0x2000007eff757230ULL, 0x000fe20000004100ULL,
0x00000018ff627819ULL, 0x000fe4000001164dULL, 0x00000010ff457819ULL, 0x000fe4000001164eULL,
0x000000ff4e637812ULL, 0x000fe200078ec0ffULL, 0x000000201c2c723cULL, 0x000b62000004182cULL,
0x00000010ff4a7819ULL, 0x000fc4000001164fULL, 0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff227819ULL, 0x000fe40000011658ULL, 0x00000010ff237819ULL, 0x000fe40000011668ULL,
0x00000010ff597819ULL, 0x000fc40000011659ULL, 0x00000010ff467819ULL, 0x020fe4000001167dULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x000000ff45457812ULL, 0x000fe200078ec0ffULL, 0x2000007fff747230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fe40000000022ULL, 0x000000ff4a4a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x0000105446237816ULL, 0x000fe40000000059ULL, 0x00000010ff217819ULL, 0x000fe4000001165cULL,
0x00000010ff207819ULL, 0x000fe4000001167cULL, 0x00000010ff467819ULL, 0x000fe2000001165dULL,
0x000000221c30723cULL, 0x000b620000041830ULL, 0x00000010ff757819ULL, 0x000fc40000011675ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000006fff697230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000105421207816ULL, 0x000fe20000000020ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x0000105446217816ULL, 0x000fe20000000075ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff237819ULL, 0x020fe40000011674ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x000000201c34723cULL, 0x000b620000041834ULL,
0x00001054235e7816ULL, 0x000fe4000000005eULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff217819ULL, 0x020fe4000001164dULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff227819ULL, 0x000fe40000011645ULL,
0x00000010ff237819ULL, 0x000fe40000011664ULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00001054765f7816ULL, 0x000fe4000000005fULL, 0x0000105460207816ULL, 0x000fc40000000069ULL,
0x0000105462217816ULL, 0x000fe40000000021ULL, 0x0000105422227816ULL, 0x000fe20000000063ULL,
0x0000005e1c38723cULL, 0x000f620000041838ULL, 0x000010544a237816ULL, 0x000fe40000000023ULL,
0x00001054654e7816ULL, 0x000fe4000000004eULL, 0x00001054664f7816ULL, 0x000fc6000000004fULL,
0x000000201c3c723cULL, 0x040f70000004183cULL, 0x000000221c40723cULL, 0x040f700000041840ULL,
0x0000004e1c24723cULL, 0x000b6e0000041824ULL, 0x0000f6c8031c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000001c1c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c00a1f7811ULL, 0x000fe200078e40ffULL,
0x00f6980057ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff207224ULL, 0x002fe200078e001dULL,
0x00000002095f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200078e000eULL,
0x000000441f00720cULL, 0x000fe20003f06070ULL, 0x000000ffff5c7224ULL, 0x000fc400078e0061ULL,
0x000000ffff5d7224ULL, 0x000fd400078e005bULL, 0x00002e2000000947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x004fc40000015200ULL, 0x000004000c1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001141fULL, 0x000000210e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000020e0e7819ULL, 0x000fc8000000121fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000c1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020a0e7810ULL, 0x040fe20007ffe0ffULL,
0x000001000a0c7824ULL, 0x000fe400078e0205ULL, 0x00005800021c7a24ULL, 0x010fe200078e02ffULL,
0x000000190e00720cULL, 0x000fe40003f06070ULL, 0x000001000c1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000801c4b7824ULL, 0x000fc600078e00ffULL, 0x0000006004457812ULL, 0x000fce00078ef81dULL,
0x0000048000008947ULL, 0x000fea0003800000ULL, 0x000000101b0c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff227819ULL, 0x000fe20000011600ULL, 0x00000010001c7824ULL, 0x000fc600078e00ffULL,
0x000000100c477812ULL, 0x000fe400078ec0ffULL, 0x0000001d440c7217ULL, 0x000fe40007800000ULL,
0x0000000422467810ULL, 0x040fe20007ffe0ffULL, 0x0000000122207824ULL, 0x040fe200078e0247ULL,
0x0000000822497810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fe400078e0a1dULL,
0x00000001200e7824ULL, 0x000fe400078e0245ULL, 0x0000000146487824ULL, 0x000fc400078e0247ULL,
0x00000008204a7824ULL, 0x000fe200078e00ffULL, 0x0000000e4b1e7210ULL, 0x000fe20007f1e0ffULL,
0x00000008484d7824ULL, 0x000fe200078e00ffULL, 0x0000000c470e7217ULL, 0x000fe40007800000ULL,
0x000000701c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e06ffULL,
0x00005e001e1d7a11ULL, 0x000fe200078038ffULL, 0x000000010e0e7824ULL, 0x000fe400078e0a47ULL,
0x00000001481c7824ULL, 0x000fe200078e0245ULL, 0x00005f001e1e7a11ULL, 0x000fe200000f3c1fULL,
0x00000001201f7824ULL, 0x000fe200078e0200ULL, 0x0000000e2200720cULL, 0x000fc40003f06070ULL,
0x0000001c4b207210ULL, 0x000fe40007fde0ffULL, 0x0000000c1d1c7210ULL, 0x000fe40007fbe0ffULL,
0xfffffff84a217812ULL, 0x000fe200078ee21fULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x00005e0020237a11ULL, 0x000fe200078c38ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e061eULL,
0x0000000e4600720cULL, 0x000fe20003fa6070ULL, 0x0000001021217824ULL, 0x000fe200078e0256ULL,
0x00005f0020207a11ULL, 0x000fe200030f3c1fULL, 0x00000001494a7824ULL, 0x000fc400078e0247ULL,
0x0000000148467824ULL, 0x000fe200078e0200ULL, 0x0000000c22487810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e2000c101c46ULL,
0x000000014a1f7824ULL, 0x000fe200078e0245ULL, 0x0000000c231e7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff84d237812ULL, 0x000fe200078ee246ULL, 0x0000000148477824ULL, 0x000fe200078e0247ULL,
0x0000001f4b227210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e0620ULL,
0x0000000e4900720cULL, 0x000fe20003f06070ULL, 0x0000001023217824ULL, 0x002fc400078e0256ULL,
0x00000001471c7824ULL, 0x000fe400078e0245ULL, 0x000000ffff237224ULL, 0x000fe200030e06ffULL,
0x000000001e217faeULL, 0x0003e2000e901c46ULL, 0x00005e00221d7a11ULL, 0x000fe200078a38ffULL,
0x000000084a457824ULL, 0x000fe200078e00ffULL, 0x0000001c4b207210ULL, 0x000fe40007fde0ffULL,
0x00005f0022227a11ULL, 0x000fe400028f3c23ULL, 0x0000000e4800720cULL, 0x000fe20003fa6070ULL,
0x000000ffff237224ULL, 0x000fe200030e06ffULL, 0x0000000c1d1c7210ULL, 0x000fe20007fde0ffULL,
0x000000014a0e7824ULL, 0x000fc800078e0200ULL, 0x000000ffff1d7224ULL, 0x000fe200030e0622ULL,
0x00005e00201f7a11ULL, 0x042fe200078c38ffULL, 0x0000000147227824ULL, 0x000fe200078e0200ULL,
0xfffffff845217812ULL, 0x000fe200078ee20eULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x00005f00200e7a11ULL, 0x000fe400030f3c23ULL, 0x0000000c1f1e7210ULL, 0x000fe20007fde0ffULL,
0x0000001021217824ULL, 0x000fe200078e0256ULL, 0xfffffff847237812ULL, 0x000fc600078ee222ULL,
0x000000ffff1f7224ULL, 0x000fe200030e060eULL, 0x000000001c217faeULL, 0x0003e2000c101c46ULL,
0x0000001023237824ULL, 0x000fca00078e0256ULL, 0x000000001e237faeULL, 0x0003e2000e901c46ULL,
0x000003b000007947ULL, 0x000fea0003800000ULL, 0x000000101b0c7824ULL, 0x000fca00078e00ffULL,
0x000000100c1d7812ULL, 0x000fc800078ec0ffULL, 0x0000001d000e7211ULL, 0x000fc800078fe8ffULL,
0x000000040e1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000010e0c7824ULL, 0x140fe200078e0245ULL,
0x0000000c0e1f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010e1c7824ULL, 0x100fe400078e0200ULL,
0x000000011e1d7824ULL, 0x040fe200078e0200ULL, 0x0000000c4b207210ULL, 0x000fe20007f1e0ffULL,
0x000000081e227824ULL, 0x000fe400078e00ffULL, 0x000000080e4d7824ULL, 0x000fe400078e00ffULL,
0x000000011e0c7824ULL, 0x000fe200078e0245ULL, 0xfffffff8224f7812ULL, 0x000fe200078ee21dULL,
0x000000ffff1d7224ULL, 0x000fe200000e06ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee21cULL,
0x000000081f597824ULL, 0x000fe200078e00ffULL, 0x00005e0020477a11ULL, 0x000fc400078038ffULL,
0x000000080e1c7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0020207a11ULL, 0x000fe400000f3c1dULL,
0x0000000c4b227210ULL, 0x000fe20007f1e0ffULL, 0x000000011c0e7824ULL, 0x140fe400078e0245ULL,
0x000000011f0c7824ULL, 0x000fe400078e0245ULL, 0x000000011c1e7824ULL, 0x040fe200078e0200ULL,
0x0000000e4b467210ULL, 0x040fe20007fbe0ffULL, 0x000000081c217824ULL, 0x000fe200078e00ffULL,
0x0000000c4b0e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x00005e0022497a11ULL, 0x000fe200078038ffULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8214b7812ULL, 0x000fe200078ee21eULL, 0x000000011f1c7824ULL, 0x000fe200078e0200ULL,
0x00005f0022227a11ULL, 0x000fe200000f3c1dULL, 0x000000ffff1f7224ULL, 0x000fe200028e06ffULL,
0x00005e0046217a11ULL, 0x000fe200078038ffULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x00005e000e237a11ULL, 0x000fe200078a38ffULL, 0x000000104d457824ULL, 0x000fe200078e0256ULL,
0x000000700c0c7812ULL, 0x000fc400078ec0ffULL, 0xfffffff859597812ULL, 0x000fe400078ee21cULL,
0x00005f0046467a11ULL, 0x000fe400000f3c1fULL, 0x00005f000e0e7a11ULL, 0x000fe400028f3c1dULL,
0x0000000c471c7210ULL, 0x080fe20007f1e0ffULL, 0x000000104f477824ULL, 0x100fe200078e0256ULL,
0x0000000c491e7210ULL, 0x080fe20007fbe0ffULL, 0x000000104b497824ULL, 0x000fe400078e0256ULL,
0x000000ffff1d7224ULL, 0x000fe200000e0620ULL, 0x0000000c21207210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e0622ULL, 0x0000000c23227210ULL, 0x000fe20007fbe0ffULL,
0x00000010594b7824ULL, 0x000fe200078e0256ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c457faeULL, 0x0003e2000b901c46ULL, 0x000000ffff217224ULL, 0x000fc400000e0646ULL,
0x000000ffff237224ULL, 0x000fe200028e060eULL, 0x000000001e477faeULL, 0x0003e8000b901c46ULL,
0x0000000020497faeULL, 0x0003e8000b901c46ULL, 0x00000000224b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000540403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800555c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668000f207f8cULL, 0x0022a4000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x00f66c000f1f7984ULL, 0x000f240000000800ULL, 0x800000001fff7812ULL, 0x014fc40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c237210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001141fULL,
0x000000230e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000020e0e7819ULL, 0x000fc8000000121fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c000f1f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x004fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001800c107810ULL, 0x000fca0007ffe010ULL, 0x0000000111107824ULL, 0x000fca00078e0210ULL,
0x00f00000100e7984ULL, 0x000ea80000000800ULL, 0x00f20000100f7984ULL, 0x0022e20000000800ULL,
0x000000610e00720bULL, 0x004fe20003f1d000ULL, 0x00008cc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x002fc800000e0100ULL, 0x0000ffff10ff7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x008fd200078e0061ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000031b1c7811ULL, 0x000fe400078ff0ffULL, 0x000000610e00720bULL, 0x000fe40003f14000ULL,
0x0000001b1c00720cULL, 0x000fe20003fa5270ULL, 0x00008c727f007947ULL, 0x000fd4000b800000ULL,
0x00000000001d7806ULL, 0x000fc400000e0100ULL, 0x000000801b0cd824ULL, 0x000fe200078e020cULL,
0x000000610e5c7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000011111d824ULL, 0x000fe200078e020cULL, 0x000099101d0c7816ULL, 0x000fc800000000ffULL,
0x00f4005c1100d388ULL, 0x0003e20000000800ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000615c0c7221ULL, 0x002fe20000010100ULL,
0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00117308ULL, 0x000e640000000800ULL,
0x0000001106067220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x00008ba27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e110c7589ULL, 0x0002a400000e0000ULL, 0x0000000c28287220ULL, 0x084fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001e7811ULL, 0x002fe200078ff0ffULL, 0x00008a927f007947ULL, 0x000fea000b800000ULL,
0x00001f1e110c7589ULL, 0x0002a400000e0000ULL, 0x0000000c2a2a7220ULL, 0x084fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff1dff7812ULL, 0x000fe20007800810ULL, 0x00000001ff1c7424ULL, 0x000fd800078e00ffULL,
0x0000000e5c0e0221ULL, 0x000fe20000010100ULL, 0x00007610ff1c0816ULL, 0x000fc6000000001cULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00150308ULL, 0x000e640000000800ULL,
0x000000150f0f0220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000060f067221ULL, 0x000fc40000010000ULL, 0x00000000000e7805ULL, 0x000fca0000015200ULL,
0x00f6ac000d117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e1d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011411ULL,
0x0000001d0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x000000020c0c7819ULL, 0x000fc80000001211ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac000d117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099101c0c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000015ff0c723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011600ULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x000086827f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c177589ULL, 0x0002a400000e0000ULL, 0x000000080d1e7810ULL, 0x000fe20007ffe0ffULL,
0x000086b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e0c167589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x000fe200078e000cULL, 0x0000bc3000497802ULL, 0x000fc40000000f00ULL,
0x00008b4000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x004fe200078e000cULL,
0x0000bc8000497802ULL, 0x000fc40000000f00ULL, 0x00008af000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005320783bULL, 0x004ea80000004200ULL, 0x00000000521c783bULL, 0x008ee80000004200ULL,
0x000000005110783bULL, 0x000f280000004200ULL, 0x00000000500c783bULL, 0x002e620000004200ULL,
0x00000018ff147819ULL, 0x004fc40000011620ULL, 0x00000010ff4e7819ULL, 0x000fe40000011620ULL,
0x000000ff20467812ULL, 0x040fe400078ec0ffULL, 0x0000ffff20787812ULL, 0x000fe400078ec0ffULL,
0x000000ff21207812ULL, 0x000fe400078ec0ffULL, 0x00000018ff557819ULL, 0x008fe4000001161dULL,
0x000000ff1f5e7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff687819ULL, 0x110fe40000011610ULL,
0x000000ff107b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011610ULL,
0x0000ffff10627812ULL, 0x000fe400078ec0ffULL, 0x00000014ff71723eULL, 0x000fe400020006ffULL,
0x00000010ff617819ULL, 0x000fc4000001161eULL, 0x000000ff1e597812ULL, 0x040fe200078ec0ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000018ff587819ULL, 0x000fe4000001161eULL,
0x0000ffff1e6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x100fe4000001161fULL,
0x00000018ff797819ULL, 0x000fe4000001161fULL, 0x0000ffff1f697812ULL, 0x000fc400078ec0ffULL,
0x00000010ff107819ULL, 0x100fe40000011612ULL, 0x000000ff127f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011612ULL, 0x0000ffff12657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x002fe4000001160dULL, 0x000000ff0d4c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001160dULL, 0x0000ffff0d147812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe40000011621ULL, 0x00000018ff477819ULL, 0x000fe40000011621ULL,
0x0000ffff21777812ULL, 0x000fe400078ec0ffULL, 0x00000020ff12723eULL, 0x000fc400020006ffULL,
0x00000010ff5b7819ULL, 0x100fe4000001160cULL, 0x000000ff0c487812ULL, 0x040fe200078ec0ffULL,
0x20000012ff127230ULL, 0x000fe20000004100ULL, 0x00000018ff497819ULL, 0x000fe4000001160cULL,
0x0000ffff0c547812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1e7819ULL, 0x000fe4000001160eULL,
0x000000ff0e4b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff0d7819ULL, 0x000fe4000001160eULL,
0x0000ffff0e1f7812ULL, 0x000fe400078ec0ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000010ff207819ULL, 0x100fe4000001160fULL, 0x000000ff0f0e7812ULL, 0x000fe200078ec0ffULL,
0x20000055ff5f7230ULL, 0x000fe20000004100ULL, 0x00000018ff0c7819ULL, 0x000fc4000001160fULL,
0x0000ffff0f217812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011622ULL,
0x0000005eff0f723eULL, 0x000fe400020006ffULL, 0x00000018ff457819ULL, 0x000fe40000011613ULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000058ff55723eULL, 0x000fe200020006ffULL,
0x2000000fff587230ULL, 0x000fe20000004100ULL, 0x00000045ff0f723eULL, 0x000fe200020006ffULL,
0x2000004dff667230ULL, 0x000fe20000004100ULL, 0x000000ff23507812ULL, 0x000fe200078ec0ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000048ff4d723eULL, 0x000fe200020006ffULL,
0x2000000fff487230ULL, 0x000fe20000004100ULL, 0x00000049ff0f723eULL, 0x000fc400020006ffULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x2000004dff497230ULL, 0x000fe20000004100ULL,
0x0000004bff4d723eULL, 0x000fe200020006ffULL, 0x2000000fff4b7230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000050ff6b7230ULL, 0x000fe20000004100ULL,
0x0000000eff0f723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000004aff50723eULL, 0x000fe200020006ffULL, 0x2000004cff4a7230ULL, 0x000fe20000004100ULL,
0x0000000dff0e723eULL, 0x000fc400020006ffULL, 0x000000ff4e0d7812ULL, 0x000fe200078ec0ffULL,
0x20000050ff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe20000011622ULL,
0x2000000fff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff767819ULL, 0x100fe40000011623ULL,
0x000000ff22517812ULL, 0x040fe400078ec0ffULL, 0x0000ffff22747812ULL, 0x000fe400078ec0ffULL,
0x00000018ff227819ULL, 0x000fc40000011623ULL, 0x0000000dff0d723eULL, 0x000fe400020006ffULL,
0x0000000cff50723eULL, 0x000fe400020006ffULL, 0x000000ff75757812ULL, 0x000fe400078ec0ffULL,
0x00000008ff0c7819ULL, 0x000fe20000011678ULL, 0x2000000dff787230ULL, 0x000fe20000004100ULL,
0x000000ff76767812ULL, 0x000fe200078ec0ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x000000ff1d567812ULL, 0x000fc400078ec0ffULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x20000022ff677230ULL, 0x000fe20000004100ULL, 0x0000000cff0c723eULL, 0x000fe400020006ffULL,
0x00000076ff0d723eULL, 0x000fe200020006ffULL, 0x20000075ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fc4000001161dULL, 0x0000ffff1d737812ULL, 0x000fe200078ec0ffULL,
0x2000000dff757230ULL, 0x000fe20000004100ULL, 0x00000056ff1d723eULL, 0x000fe400020006ffULL,
0x00000079ff56723eULL, 0x000fe400020006ffULL, 0x0000007aff22723eULL, 0x000fe200020006ffULL,
0x2000000cff7a7230ULL, 0x000fe20000004100ULL, 0x0000004fff79723eULL, 0x000fe200020006ffULL,
0x2000000eff4f7230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe20000011673ULL,
0x00a80000180c783bULL, 0x0002a20000000200ULL, 0x000000ff61617812ULL, 0x000fe200078ec0ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x2000001dff1d7230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011613ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x000000ff13807812ULL, 0x040fe200078ec0ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000008ff187819ULL, 0x002fe2000001166dULL,
0x20000073ff6d7230ULL, 0x000fe20000004100ULL, 0x0000ffff135a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe40000011669ULL, 0x00000046ff13723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x20000013ff137230ULL, 0x000fe20000004100ULL, 0x00000008ff777819ULL, 0x000fe20000011677ULL,
0x20000061ff697230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000018ff617230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000008ff187819ULL, 0x000fe20000011662ULL,
0x20000073ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011612ULL,
0x20000047ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff137819ULL, 0x000fe20000011613ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff127819ULL, 0x000fe40000011678ULL,
0x00000010ff607819ULL, 0x000fc40000011611ULL, 0x000000ff117d7812ULL, 0x000fe200078ec0ffULL,
0x000000170c0c8231ULL, 0x084fe200003400ffULL, 0x00000018ff7c7819ULL, 0x000fe20000011611ULL,
0x000000170e0e8231ULL, 0x000fe200003400ffULL, 0x00000010ff787819ULL, 0x000fe20000011679ULL,
0x000000160d0d8231ULL, 0x080fe200003400ffULL, 0x0000ffff236a7812ULL, 0x000fe200078ec0ffULL,
0x000000160f0f8231ULL, 0x000fe200003400ffULL, 0x0000ffff11117812ULL, 0x000fe400078ec0ffULL,
0x00000018ff237819ULL, 0x000fc4000001161cULL, 0x0000105412127816ULL, 0x000fe40000000013ULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x0000105478137816ULL, 0x000fe40000000073ULL,
0x00000008ff6a7819ULL, 0x000fe4000001166aULL, 0x00000008ff737819ULL, 0x000fe40000011611ULL,
0x000000ff10787812ULL, 0x000fe200078ec0ffULL, 0x000000120c28723cULL, 0x000be20000041828ULL,
0x00000023ff23723eULL, 0x000fc400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x20000023ff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff107819ULL, 0x000fe4000001167aULL, 0x00000010ff117819ULL, 0x000fe40000011677ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x000000ff70707812ULL, 0x000fe200078ec0ffULL, 0x20000051ff6c7230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x0000105471107816ULL, 0x000fe40000000010ULL, 0x0000105472117816ULL, 0x000fe40000000011ULL,
0x0000007cff23723eULL, 0x000fe400020006ffULL, 0x00000070ff7c723eULL, 0x000fe200020006ffULL,
0x2000006aff707230ULL, 0x000fe20000004100ULL, 0x00000010ff127819ULL, 0x020fe2000001166cULL,
0x000000100c2c723cULL, 0x000be2000004182cULL, 0x00000010ff137819ULL, 0x000fe20000011676ULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fc4000001161cULL,
0x00000010ff717819ULL, 0x000fe4000001166bULL, 0x00000010ff117819ULL, 0x020fe40000011666ULL,
0x00000010ff107819ULL, 0x000fe40000011674ULL, 0x00000010ff727819ULL, 0x000fe40000011675ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff707819ULL, 0x000fc40000011670ULL,
0x0000ffff1c6f7812ULL, 0x000fe400078ec0ffULL, 0x0000105413127816ULL, 0x000fe40000000012ULL,
0x0000105411107816ULL, 0x000fe40000000010ULL, 0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL,
0x0000105472137816ULL, 0x000fe40000000071ULL, 0x0000105467117816ULL, 0x000fc40000000070ULL,
0x000000ff1c527812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6f7819ULL, 0x000fe2000001166fULL,
0x000000120c30723cULL, 0x040f620000041830ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000052ff1c723eULL, 0x000fe400020006ffULL, 0x0000007bff51723eULL, 0x000fe400020006ffULL,
0x000000ff64647812ULL, 0x000fe200078ec0ffULL, 0x000000100c34723cULL, 0x000b620000041834ULL,
0x0000006fff7b723eULL, 0x000fe200020006ffULL, 0x00a800000710783bULL, 0x020e620000000200ULL,
0x2000006eff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff657819ULL, 0x000fe20000011665ULL,
0x2000001cff1c7230ULL, 0x000fe20000004100ULL, 0x00000064ff66723eULL, 0x000fe200020006ffULL,
0x2000007cff6e7230ULL, 0x000fe20000004100ULL, 0x00000065ff64723eULL, 0x000fe200020006ffULL,
0x2000007bff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe2000001161cULL,
0x20000066ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x000fe2000001161dULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x00000008ff667819ULL, 0x000fe4000001165aULL, 0x000000ff5b677812ULL, 0x000fe400078ec0ffULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x000fe4000001165eULL,
0x00000010ff5a7819ULL, 0x000fe4000001166aULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x00000010ff5e7819ULL, 0x000fe4000001165fULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x000010546f1c7816ULL, 0x000fe4000000001cULL,
0x000010546e1d7816ULL, 0x000fe4000000001dULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x000010545b5a7816ULL, 0x000fc4000000005aULL, 0x000010545e5b7816ULL, 0x000fe2000000006dULL,
0x0000001c0c38723cULL, 0x040be20000041838ULL, 0x000000ff687b7812ULL, 0x000fe200078ec0ffULL,
0x20000063ff687230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fe20000011655ULL,
0x0000001710108231ULL, 0x082fe200003400ffULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x0000001712128231ULL, 0x000fe200003400ffULL, 0x00000010ff1c7819ULL, 0x020fe20000011659ULL,
0x0000005a0c3c723cULL, 0x000b62000004183cULL, 0x00000008ff597819ULL, 0x000fe20000011654ULL,
0x0000001611118231ULL, 0x080fe200003400ffULL, 0x00000010ff547819ULL, 0x000fe20000011661ULL,
0x0000001613138231ULL, 0x000fe200003400ffULL, 0x00000010ff1d7819ULL, 0x000fc40000011658ULL,
0x000000ff535a7812ULL, 0x020fe400078ec0ffULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff537819ULL, 0x000fe40000011656ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x0000105455547816ULL, 0x000fe40000000054ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x00000080ff46723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x2000007fff457230ULL, 0x000fe20000004100ULL, 0x00001054691c7816ULL, 0x000fe2000000001cULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00001054681d7816ULL, 0x000fe2000000001dULL,
0x20000078ff6b7230ULL, 0x000fe20000004100ULL, 0x0000105453557816ULL, 0x000fe40000000062ULL,
0x00000018ff18723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x0000001c0c40723cULL, 0x040f620000041840ULL, 0x00000008ff147819ULL, 0x000fe20000011614ULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x000000ff60637812ULL, 0x000fe200078ec0ffULL,
0x20000073ff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff20207812ULL, 0x000fe400078ec0ffULL,
0x00000010ff457819ULL, 0x000fe20000011645ULL, 0x000000540c24723cULL, 0x000b620000041824ULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x0000007dff52723eULL, 0x000fe400020006ffULL,
0x0000007eff47723eULL, 0x000fe200020006ffULL, 0x2000007bff607230ULL, 0x000fe20000004100ULL,
0x000000ff1e0c7812ULL, 0x020fe200078ec0ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000014ff1e723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff0f7819ULL, 0x000fe40000011646ULL, 0x00000010ff0e7819ULL, 0x000fe2000001166bULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fc40000011665ULL,
0x00000010ff0d7819ULL, 0x000fe40000011622ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000000cff22723eULL, 0x000fe200020006ffULL,
0x20000066ff587230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fe20000011618ULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x000010540e0e7816ULL, 0x000fe20000000045ULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x00001054140f7816ULL, 0x000fc4000000000fULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x0000000e1030723cULL, 0x000b620000041830ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x000010540d0c7816ULL, 0x000fe20000000018ULL,
0x20000067ff077230ULL, 0x000fe20000004100ULL, 0x00001054230d7816ULL, 0x000fe2000000006cULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fc40000011651ULL,
0x00000010ff1d7819ULL, 0x000fe40000011660ULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x0000000c102c723cULL, 0x000b62000004182cULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff657819ULL, 0x000fe40000011648ULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff0e7819ULL, 0x020fe4000001164bULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff0f7819ULL, 0x000fe4000001161eULL,
0x00000010ff4d7819ULL, 0x000fc4000001164dULL, 0x00000010ff227819ULL, 0x000fe40000011622ULL,
0x00000010ff237819ULL, 0x000fe4000001164eULL, 0x00000010ff207819ULL, 0x000fe40000011620ULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x00000008ff217819ULL, 0x000fc40000011621ULL, 0x00001054631d7816ULL, 0x000fe40000000052ULL,
0x0000105447647816ULL, 0x000fe40000000064ULL, 0x0000105465657816ULL, 0x000fe40000000058ULL,
0x000010540e0e7816ULL, 0x000fe20000000059ULL, 0x0000001c1028723cULL, 0x000f620000041828ULL,
0x000010544c0f7816ULL, 0x000fe4000000000fULL, 0x0000105422227816ULL, 0x000fc4000000004dULL,
0x0000105420237816ULL, 0x000fe40000000023ULL, 0x00000010ff497819ULL, 0x000fe20000011649ULL,
0x000000641034723cULL, 0x040f620000041834ULL, 0x00000010ff0d7819ULL, 0x000fe4000001164aULL,
0x00000010ff0c7819ULL, 0x000fe40000011607ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x0000000e103c723cULL, 0x000f62000004183cULL,
0x00000021ff21723eULL, 0x000fc400020006ffULL, 0x000010540c0c7816ULL, 0x000fe20000000049ULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x000010545a0d7816ULL, 0x000fe2000000000dULL,
0x20000021ff217230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x000000221040723cULL, 0x000f620000041840ULL, 0x00000010ff1f7819ULL, 0x000fce000001161fULL,
0x0000000c1038723cULL, 0x000b6e0000041838ULL, 0x00000010ff0c7819ULL, 0x020fe4000001164fULL,
0x00000010ff0d7819ULL, 0x000fe40000011621ULL, 0x000010540c0c7816ULL, 0x000fc4000000001fULL,
0x00001054500d7816ULL, 0x000fce000000000dULL, 0x0000000c1024723cULL, 0x000b6e0000041824ULL,
0x0000f6c8030c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000c0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00057ff7f8cULL, 0x0005e2000c80043fULL, 0x00000002095f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x002fe200078e000dULL, 0x000000010b1c7812ULL, 0x000fc400078ec0ffULL,
0x000000010a0a7810ULL, 0x004fc80007ffe0ffULL, 0x000000190a00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff3e5000007947ULL, 0x000fea000383ffffULL,
0x000000ff1900720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000d45000047802ULL, 0x000fc40000000f00ULL,
0x0000716000007944ULL, 0x016fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000600077308ULL, 0x000ee40000001000ULL, 0xbf80000007007423ULL, 0x008fc80000000006ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000007007223ULL, 0x000fc40000000007ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff077624ULL, 0x000fe400078e00ffULL,
0x00006800ff067624ULL, 0x000fca00078e00ffULL, 0x0000000606077981ULL, 0x008ee8000c1e9900ULL,
0x0000000000027919ULL, 0x010ea80000000000ULL, 0x0000000000087919ULL, 0x004ea20000000000ULL,
0x00000002ff097819ULL, 0x000fe40000011602ULL, 0x00000008080b7811ULL, 0x004fe200078ff0ffULL,
0x0000000007047220ULL, 0x008fca0000410000ULL, 0x00001f0904007589ULL, 0x000ea800000e0000ULL,
0x00001f0b04027589ULL, 0x000ee200000e0000ULL, 0x0000002800287220ULL, 0x044fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x000fe20000410000ULL, 0x0000002a022a7220ULL, 0x048fe20000410000ULL,
0x0000002b022b7220ULL, 0x040fe20000410000ULL, 0x0000002e022e7220ULL, 0x040fe20000410000ULL,
0x0000002f022f7220ULL, 0x040fe20000410000ULL, 0x0000003202327220ULL, 0x040fe20000410000ULL,
0x0000003302337220ULL, 0x040fe20000410000ULL, 0x0000003602367220ULL, 0x040fe20000410000ULL,
0x0000003702377220ULL, 0x040fe20000410000ULL, 0x0000003a023a7220ULL, 0x040fe20000410000ULL,
0x0000003b023b7220ULL, 0x040fe20000410000ULL, 0x0000003e023e7220ULL, 0x040fe20000410000ULL,
0x0000003f023f7220ULL, 0x040fe20000410000ULL, 0x0000004202427220ULL, 0x040fe20000410000ULL,
0x0000004302437220ULL, 0x040fe20000410000ULL, 0x0000002602267220ULL, 0x040fe20000410000ULL,
0x0000002702277220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000010001b087824ULL, 0x004fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000100008087812ULL, 0x000fe400078ee2ffULL, 0x00000002ff077819ULL, 0x108fe20000011600ULL,
0x0000000105057824ULL, 0x000fe200078e0200ULL, 0x0000000200027812ULL, 0x010fc400078ec0ffULL,
0x0000000800097811ULL, 0x000fe200078ff0ffULL, 0x0000000807107824ULL, 0x000fe200078e00ffULL,
0x0000000702047211ULL, 0x040fe400078ff8ffULL, 0x0000000902067211ULL, 0x000fe200078ff8ffULL,
0x00000008090b7824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x000fe20007ffe0ffULL,
0x0000000807097824ULL, 0x000fc600078e00ffULL, 0xfffffff80b0c7812ULL, 0x000fe200078ee206ULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee202ULL,
0x0000080003077824ULL, 0x000fe200078e0208ULL, 0xfffffff809027812ULL, 0x000fe400078ee204ULL,
0x0000000404067810ULL, 0x000fe20007ffe0ffULL, 0x000000100c127824ULL, 0x100fe200078e0207ULL,
0x0000000604097810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0207ULL,
0xfffffff810107812ULL, 0x000fe200078ee209ULL, 0x000000100a0c7824ULL, 0x100fe200078e0207ULL,
0x0000000804097812ULL, 0x000fe200078ec0ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0207ULL,
0x000000282902723eULL, 0x000fe200000010ffULL, 0x0000001010107824ULL, 0x000fe200078e0207ULL,
0x0000002c2d04723eULL, 0x000fe200000010ffULL, 0x00000001060a7824ULL, 0x000fe200078e0209ULL,
0x000000383906723eULL, 0x000fe200000010ffULL, 0x00000001090c7824ULL, 0x040fe200078e020cULL,
0x0000541002147816ULL, 0x040fe20000000004ULL, 0x00000001090e7824ULL, 0x040fe200078e020eULL,
0x0000763202157816ULL, 0x000fe20000000004ULL, 0x0000000109107824ULL, 0x000fe200078e0210ULL,
0x000000303102723eULL, 0x000fe200000010ffULL, 0x0000000109127824ULL, 0x000fe200078e0212ULL,
0x000000343504723eULL, 0x000fe200000010ffULL, 0x000000140a007388ULL, 0x0005e20000000a00ULL,
0x0000003c3d07723eULL, 0x000fc400000010ffULL, 0x00007632020b7816ULL, 0x140fe40000000004ULL,
0x00005410020a7816ULL, 0x004fe40000000004ULL, 0x000000404102723eULL, 0x000fe400000010ffULL,
0x000000242504723eULL, 0x000fe200000010ffULL, 0x0000000a0c007388ULL, 0x0005e40000000a00ULL,
0x00005410060a7816ULL, 0x144fe40000000007ULL, 0x00007632060b7816ULL, 0x000fc40000000007ULL,
0x0000002a2b06723eULL, 0x000fe400000010ffULL, 0x0000002e2f07723eULL, 0x000fe200000010ffULL,
0x0000000a0e007388ULL, 0x0005e40000000a00ULL, 0x00005410020a7816ULL, 0x144fe40000000004ULL,
0x00007632020b7816ULL, 0x000fe40000000004ULL, 0x000000323302723eULL, 0x000fe400000010ffULL,
0x000000363704723eULL, 0x000fe200000010ffULL, 0x0000000a10007388ULL, 0x0005e40000000a00ULL,
0x00005410060a7816ULL, 0x004fc40000000007ULL, 0x00007632060b7816ULL, 0x000fe40000000007ULL,
0x0000003a3b06723eULL, 0x000fe400000010ffULL, 0x0000003e3f07723eULL, 0x000fe200000010ffULL,
0x0000000a12007388ULL, 0x0005e40000000a00ULL, 0x00005410020a7816ULL, 0x144fe40000000004ULL,
0x00007632020b7816ULL, 0x000fe40000000004ULL, 0x000000424302723eULL, 0x000fc400000010ffULL,
0x000000262704723eULL, 0x000fe200000010ffULL, 0x0004000a0c007388ULL, 0x0005e40000000a00ULL,
0x00005410060a7816ULL, 0x144fe40000000007ULL, 0x00007632060b7816ULL, 0x000fe40000000007ULL,
0x000000ff00067306ULL, 0x000fe60000205400ULL, 0x0004000a0e007388ULL, 0x0005e40000000a00ULL,
0x00005410020a7816ULL, 0x004fc40000000004ULL, 0x00007632020b7816ULL, 0x000fe20000000004ULL,
0x0000001005047824ULL, 0x000fe200078e0208ULL, 0x000000ff00027245ULL, 0x000fe2000020d400ULL,
0x000000ff00057306ULL, 0x000ea40000209400ULL, 0x0004000a10007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000004147984ULL, 0x000ee80000000c00ULL,
0x00040000040c7984ULL, 0x000e620000000c00ULL, 0x000000060500720bULL, 0x004fc60003f1d000ULL,
0x00080000041c7984ULL, 0x000ea80000000c00ULL, 0x000c000004207984ULL, 0x000eac0000000c00ULL,
0x0000000102020812ULL, 0x000fc400078efcffULL, 0x000000ff0300720cULL, 0x000fe40003f05270ULL,
0x000000020206723eULL, 0x000fca00000010ffULL, 0x3f803f8006177831ULL, 0x048fe40000200017ULL,
0x3f803f8006167831ULL, 0x040fe40000200016ULL, 0x3f803f8006157831ULL, 0x040fe40000200015ULL,
0x3f803f8006147831ULL, 0x040fe40000200014ULL, 0x3f803f80060f7831ULL, 0x042fe4000020000fULL,
0x3f803f80060e7831ULL, 0x000fc4000020000eULL, 0x3f803f80060d7831ULL, 0x040fe4000020000dULL,
0x3f803f80060c7831ULL, 0x000fe4000020000cULL, 0x3f803f8017177831ULL, 0x004fe4000020001fULL,
0x3f803f8016167831ULL, 0x000fe4000020001eULL, 0x3f803f8015157831ULL, 0x000fe4000020001dULL,
0x3f803f8014147831ULL, 0x000fc4000020001cULL, 0x3f803f800f0f7831ULL, 0x000fe40000200023ULL,
0x3f803f800e0e7831ULL, 0x000fe20000200022ULL, 0x0000001404007388ULL, 0x000fe20000000c00ULL,
0x3f803f800d0d7831ULL, 0x000fe40000200021ULL, 0x3f803f800c0c7831ULL, 0x000fca0000200020ULL,
0x0004000c04007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000067810ULL, 0x000fe20007ffe0ffULL,
0x0000000000107919ULL, 0x000e620000002600ULL, 0x00000003ff117819ULL, 0x000fe20000011600ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff057819ULL, 0x000fe20000011606ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000011b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000111027824ULL, 0x000fe200078e0200ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000106047824ULL, 0x000fc600078e0205ULL, 0x0000000702037812ULL, 0x000fe400078ec0ffULL,
0x0000000704077812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803037812ULL, 0x000fe400078ef800ULL,
0x0ffffff807077812ULL, 0x000fc600078ef806ULL, 0x0000001003037824ULL, 0x100fe400078e0208ULL,
0x0000001007077824ULL, 0x000fe400078e0208ULL, 0x0000000810027824ULL, 0x042fe200078e00ffULL,
0x0000000003087984ULL, 0x000e620000000c00ULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x00000000070c7984ULL, 0x0004e20000000c00ULL,
0xfffffff802027812ULL, 0x000fc400078ee211ULL, 0xfffffff810057812ULL, 0x000fe400078ee205ULL,
0x0000000402117c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000405057c10ULL, 0x000fe2000ff3e0ffULL,
0x000000081b077824ULL, 0x004fe400078e00ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005a0011027a11ULL, 0x000fe200078040ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078240ffULL, 0x000000081b1b7824ULL, 0x000fe200078e00ffULL,
0x00005b0011037a11ULL, 0x000fc400000f4412ULL, 0xfffffff807077812ULL, 0x000fe400078ee200ULL,
0x00005b0005057a11ULL, 0x000fe400008f4410ULL, 0xfffffff81b117812ULL, 0x000fe200078ee206ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x002fe8000c101d06ULL, 0x0000000c04007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff037819ULL, 0x002fe2000001161bULL,
0xffffffffff027424ULL, 0x000fc600078e00ffULL, 0x0000001a0300720cULL, 0x000fda0003f06070ULL,
0x0000000207088824ULL, 0x000fc800078e00ffULL, 0x0000640008088a24ULL, 0x000fc800078e0203ULL,
0x0000600008088625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff0a7624ULL, 0x000fe200078e00ffULL, 0x0000000608028981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff0b7624ULL, 0x000fc600078e00ffULL, 0x00f60000ff047f8cULL, 0x000e68000c80043fULL,
0x000000060a3e7981ULL, 0x000722000c1e9900ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x0000008018187824ULL, 0x000fe400078e00ffULL, 0x000000401b3f7824ULL, 0x000fe400078e00ffULL,
0x000000803d3d7824ULL, 0x000fc600078e00ffULL, 0x00000040180f7812ULL, 0x000fe200078ef83fULL,
0x0000003d02267224ULL, 0x004fc800078e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff207819ULL, 0x00afe40000011600ULL, 0x00000030061f7812ULL, 0x000fe400078ec0ffULL,
0x0000000820157810ULL, 0x040fe20007ffe0ffULL, 0x000000010f087824ULL, 0x040fe200078e0220ULL,
0x0000001820217810ULL, 0x040fe40007ffe0ffULL, 0x0000001020177810ULL, 0x000fe20007ffe0ffULL,
0x000000010f097824ULL, 0x000fe200078e0215ULL, 0x0000000826167210ULL, 0x040fe20007f1e0ffULL,
0x0000000415067824ULL, 0x000fe200078e00ffULL, 0x000010001b137811ULL, 0x000fe200078e68ffULL,
0x000000010f087824ULL, 0x040fe200078e0217ULL, 0x0000000926127210ULL, 0x000fe20007f3e0ffULL,
0x000000010f097824ULL, 0x000fc400078e0221ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e0016147a11ULL, 0x000fe200078038ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x00000009261e7210ULL, 0x000fe40007f7e0ffULL, 0x0000000000097211ULL, 0x000fe400078fe8ffULL,
0x00005e0012107a11ULL, 0x000fe400078238ffULL, 0x00000008260d7210ULL, 0x000fe40007f5e0ffULL,
0x0000003f44087217ULL, 0x000fc40007800000ULL, 0x00005f0016167a11ULL, 0x000fe200000f3c11ULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x0000000309117812ULL, 0x000fe200078ec0ffULL,
0x00000001080e7824ULL, 0x000fe200078e0a3fULL, 0x00005f0012127a11ULL, 0x000fe200008f3c0bULL,
0x000000ffff0b7224ULL, 0x000fe200018e06ffULL, 0x00005e001e1c7a11ULL, 0x040fe400078238ffULL,
0x0ffffffc11007812ULL, 0x000fe400078ef800ULL, 0x000000141f087210ULL, 0x000fe20007f7e0ffULL,
0x0000000417147824ULL, 0x000fe200078e00ffULL, 0x00005f001e1e7a11ULL, 0x000fc400008f3c0bULL,
0x00005e000d0c7a11ULL, 0x000fe200078038ffULL, 0x000000ffff097224ULL, 0x000fe200018e0616ULL,
0x0000000e1500720cULL, 0x080fe20003f26070ULL, 0x0000001000157824ULL, 0x000fe200078e0213ULL,
0xfffffffc06007812ULL, 0x100fe400078ee211ULL, 0xfffffffc14067812ULL, 0x000fe400078ee211ULL,
0x00005f000d0d7a11ULL, 0x000fe400000f3c0aULL, 0x0000000e2000720cULL, 0x000fe20003f06070ULL,
0x00000010061d7824ULL, 0x000fe200078e0213ULL, 0x0000002020067810ULL, 0x000fc40007ffe0ffULL,
0x0000000e1700720cULL, 0x080fe20003f46070ULL, 0x0000001000177824ULL, 0x000fe200078e0213ULL,
0x0000001f100a7210ULL, 0x080fe20007f7e0ffULL, 0x000000010f007824ULL, 0x000fe200078e0206ULL,
0x0000001f0c0c7210ULL, 0x000fe40007f9e0ffULL, 0x0000002820107810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0612ULL, 0x0000003020127810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008157faeULL, 0x0003e2000c101c46ULL,
0x0000003820147810ULL, 0x000fe20007ffe0ffULL, 0x0000000421207824ULL, 0x040fe200078e00ffULL,
0x0000000e0600720cULL, 0x080fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x0000000e2100720cULL, 0x080fe20003f86070ULL, 0x000000000a177faeULL, 0x0005e2000c901c46ULL,
0x0000000e1200720cULL, 0x000fc60003f26070ULL, 0x000000000c1d7faeULL, 0x0007e2000d101c46ULL,
0x0000000e1000720cULL, 0x000fe40003f46070ULL, 0x0000000026097210ULL, 0x002fe40007f1e0ffULL,
0xfffffffc20007812ULL, 0x000fe400078ee211ULL, 0x00005e0009167a11ULL, 0x000fe200078c38ffULL,
0x000000ffff0a7224ULL, 0x004fe200000e06ffULL, 0x0000001f1c087210ULL, 0x000fe20007fbe0ffULL,
0x00000010000b7824ULL, 0x000fe200078e0213ULL, 0x0000000e1400720cULL, 0x000fe20003f06070ULL,
0x000000010f007824ULL, 0x000fe200078e0210ULL, 0x00005f00090e7a11ULL, 0x000fe200030f3c0aULL,
0x000000ffff097224ULL, 0x000fc400028e061eULL, 0x000000010f0a7824ULL, 0x040fe200078e0212ULL,
0x00000000260c7210ULL, 0x008fe20007fbe0ffULL, 0x0000000406007824ULL, 0x000fe200078e00ffULL,
0x00000000080b7faeULL, 0x0003e2000e101c46ULL, 0x000000010f0f7824ULL, 0x000fe200078e0214ULL,
0x0000000a260d7210ULL, 0x000fe20007f9e0ffULL, 0x0000000410067824ULL, 0x000fe200078e00ffULL,
0xfffffffc00007812ULL, 0x100fe200078ee211ULL, 0x00000004120a7824ULL, 0x000fe200078e00ffULL,
0x0000000f260f7210ULL, 0x000fe20007fde0ffULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x000fc400078ee211ULL, 0xfffffffc0a0a7812ULL, 0x100fe400078ee211ULL,
0xfffffffc14087812ULL, 0x002fe200078ee211ULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0x00005e000c0b7a11ULL, 0x000fe200078a38ffULL, 0x0000001000117824ULL, 0x100fe400078e0213ULL,
0x0000001006157824ULL, 0x000fe200078e0213ULL, 0x00005f000c107a11ULL, 0x000fe200028f3c09ULL,
0x000000100a177824ULL, 0x100fe400078e0213ULL, 0x0000001008137824ULL, 0x000fe200078e0213ULL,
0x0000001f16087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff067224ULL, 0x000fe200020e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078838ffULL, 0x000000ffff007224ULL, 0x000fc400030e06ffULL,
0x000000ffff097224ULL, 0x000fe200028e060eULL, 0x0000001f0b0a7210ULL, 0x080fe40007fbe0ffULL,
0x00005e000f0e7a11ULL, 0x000fe400078c38ffULL, 0x00005f000d067a11ULL, 0x000fe200020f3c06ULL,
0x000000ffff0b7224ULL, 0x000fe200028e0610ULL, 0x0000001f0c0c7210ULL, 0x080fe20007f9e0ffULL,
0x0000000008117faeULL, 0x0003e2000d901c46ULL, 0x00005f000f007a11ULL, 0x000fe400030f3c00ULL,
0x0000001f0e0e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e0606ULL,
0x000000000a157faeULL, 0x0003e6000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fe200028e0600ULL,
0x000000000c177faeULL, 0x0003e8000c901c46ULL, 0x000000000e137faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000000f00087211ULL, 0x04afe400078ff0ffULL,
0x00000008001e7811ULL, 0x000fc400078ff0ffULL, 0x0000000826087210ULL, 0x000fe40007f1e0ffULL,
0x00000020000e7811ULL, 0x040fe400078ff0ffULL, 0x00000010000a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0008227a11ULL, 0x000fe200078038ffULL,
0x000000010f0d7824ULL, 0x040fe200078e020eULL, 0x00000018000c7811ULL, 0x000fe400078ff0ffULL,
0x00005f0008247a11ULL, 0x000fe200000f3c09ULL, 0x000000010f087824ULL, 0x040fe200078e021eULL,
0x0000003000127811ULL, 0x040fe200078ff0ffULL, 0x000000010f097824ULL, 0x040fe200078e020aULL,
0x0000000000167211ULL, 0x040fe200078fe8ffULL, 0x000000010f0b7824ULL, 0x040fe200078e020cULL,
0x0000002800107811ULL, 0x040fe200078ff0ffULL, 0x000000010f137824ULL, 0x040fe200078e0212ULL,
0x0000003800147811ULL, 0x000fe200078ff0ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x0000000826207210ULL, 0x000fe20007fde0ffULL, 0x000000040a087824ULL, 0x000fe200078e00ffULL,
0x0000000d26177210ULL, 0x000fe20007f3e0ffULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0x00000003160d7812ULL, 0x000fe200078ec0ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000000926157210ULL, 0x000fe20007fbe0ffULL, 0x000000010f117824ULL, 0x000fe200078e0210ULL,
0x000010001b297811ULL, 0x000fe200078e68ffULL, 0x000000040e0a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc0d0e7812ULL, 0x000fe200078ef800ULL, 0x000000010f0f7824ULL, 0x000fe200078e0214ULL,
0xfffffffc1e007812ULL, 0x100fe200078ee20dULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0xfffffffc08087812ULL, 0x100fe200078ee20dULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0xfffffffc0c097812ULL, 0x000fe200078ee20dULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x0000000b261c7210ULL, 0x000fe20007f1e0ffULL, 0x00000010081f7824ULL, 0x100fe200078e0229ULL,
0x00005e00201e7a11ULL, 0x000fe200078c38ffULL, 0x0000001009217824ULL, 0x000fe200078e0229ULL,
0xfffffffc120c7812ULL, 0x000fe200078ee20dULL, 0x000000100e2d7824ULL, 0x000fe200078e0229ULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee20dULL, 0x000000ffff087224ULL, 0x000fe200028e06ffULL,
0xfffffffc100b7812ULL, 0x000fe200078ee20dULL, 0x000000100c277824ULL, 0x000fe200078e0229ULL,
0xfffffffc140d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005f0020207a11ULL, 0x000fe200030f3c1dULL, 0x00000010001d7824ULL, 0x100fe200078e0229ULL,
0x0000001126117210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e00150c7a11ULL, 0x000fe200078a38ffULL, 0x000000100a237824ULL, 0x100fe200078e0229ULL,
0x00005e001c0e7a11ULL, 0x000fe200078038ffULL, 0x000000100b257824ULL, 0x100fe200078e0229ULL,
0x00005e0017107a11ULL, 0x000fe200078238ffULL, 0x000000100d297824ULL, 0x000fe200078e0229ULL,
0x00000030062b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x0000001326137210ULL, 0x000fc40007f7e0ffULL, 0x0000000f260f7210ULL, 0x000fe40007f9e0ffULL,
0x00005f00150d7a11ULL, 0x000fe200028f3c08ULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x00005f001c1c7a11ULL, 0x000fe400000f3c09ULL, 0x00005f0017177a11ULL, 0x000fe200008f3c00ULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x000000222b087210ULL, 0x000fe40007f1e0ffULL,
0x00005e0011127a11ULL, 0x000fc400078238ffULL, 0x00005e0013147a11ULL, 0x000fe200078438ffULL,
0x000000ffff097224ULL, 0x000fe200000e0624ULL, 0x00005e000f167a11ULL, 0x000fe400078638ffULL,
0x00005f0011157a11ULL, 0x000fe400008f3c0aULL, 0x0000001e2b0a7210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082d7faeULL, 0x0003e2000b901c46ULL,
0x00005f0013067a11ULL, 0x000fe400010f3c06ULL, 0x0000000c2b0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0620ULL, 0x00005f000f007a11ULL, 0x000fc400018f3c00ULL,
0x0000000e2b0e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000102b107210ULL, 0x040fe20007f7e0ffULL, 0x000000000a1d7faeULL, 0x0003e2000b901c46ULL,
0x000000122b127210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e061cULL,
0x000000142b147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0617ULL,
0x000000162b167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0615ULL,
0x000000000c1f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc400028e0606ULL,
0x000000ffff177224ULL, 0x000fe200000e0600ULL, 0x000000000e217faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e8000b901c46ULL, 0x0000000012257faeULL, 0x0003e8000b901c46ULL,
0x0000000014277faeULL, 0x0003e8000b901c46ULL, 0x0000000016297faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x00f60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140bULL,
0x0000000d00007211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000200007819ULL, 0x000fc8000000120bULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x000000201b007824ULL, 0x002fca00078e0200ULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f00047812ULL, 0x000fc600078ec0ffULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x0000001004097824ULL, 0x040fe400078e00ffULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0x0000000f05007812ULL, 0x040fe400078ec0ffULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000000f009007812ULL, 0x000fe400078ee200ULL, 0x0000000f05057812ULL, 0x000fc600078ec0ffULL,
0x00000000000c7984ULL, 0x000e62000000cc00ULL, 0x000000f004057812ULL, 0x000fca00078ee205ULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001000007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff067224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008040d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011409ULL,
0x0000000d00007211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000200007819ULL, 0x000fc80000001209ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1900720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x00006400073c7a24ULL, 0x000fe200078e02ffULL,
0x3db504f33e3e7820ULL, 0x010fe20000410000ULL, 0x0000f6881b407811ULL, 0x000fe200078e18ffULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0xffffffff19417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000f6081b427811ULL, 0x000fc400078e28ffULL,
0x0000010046437824ULL, 0x000fe200078e023fULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000434400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0048ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff457224ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fc4000001ff00ULL,
0x0000000145097810ULL, 0x020fe20007ffe0ffULL, 0x00000d8000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e0045ULL, 0x000000014a487812ULL, 0x000fe200078e0cffULL,
0x0000003d02397224ULL, 0x010fe200078e02ffULL, 0x0000004609087211ULL, 0x040fe200078ff8ffULL,
0x000000ffff457224ULL, 0x000fe200078e0009ULL, 0x000000020900780cULL, 0x000fc40003f06070ULL,
0x00000001080a7810ULL, 0x040fe20007ffe0ffULL, 0x0000010008387824ULL, 0x000fe200078e023fULL,
0x0000000109527812ULL, 0x000fe400078ec0ffULL, 0x000000190a00720cULL, 0x000fe40003f26070ULL,
0x00000040380b7812ULL, 0x000fca00078ec0ffULL, 0x0000000118337824ULL, 0x000fcc00078e020bULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x002fe20000011600ULL,
0x000000021b3a7824ULL, 0x000fe200078e0248ULL, 0x0000003844097217ULL, 0x000fe40007800000ULL,
0x00000010314d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000131087824ULL, 0x140fe200078e0233ULL,
0x00000008313b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109387824ULL, 0x000fe200078e0a38ULL,
0x00000018314f7810ULL, 0x000fe20007ffe0ffULL, 0x000000014d0b7824ULL, 0x100fe200078e0233ULL,
0x00000008392d7210ULL, 0x000fe20007f3e0ffULL, 0x000000013b0a7824ULL, 0x000fe200078e0233ULL,
0x0000002031517810ULL, 0x000fc40007ffe0ffULL, 0x0000000b392e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x0000000a39307210ULL, 0x000fe40007f5e0ffULL,
0x0000002831537810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2f7224ULL, 0x000fe200018e06ffULL,
0x00005e002e087a11ULL, 0x000fe200078638ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x00005e00300a7a11ULL, 0x000fe400078438ffULL, 0x00005f002e097a11ULL, 0x000fe200018f3c2fULL,
0x000000014f2e7824ULL, 0x100fe200078e0233ULL, 0x00005e002d2c7a11ULL, 0x000fe200078238ffULL,
0x00000001512f7824ULL, 0x000fe200078e0233ULL, 0x0000003031547810ULL, 0x000fc40007ffe0ffULL,
0x0000003831557810ULL, 0x000fe40007ffe0ffULL, 0x00005f00300b7a11ULL, 0x000fe200010f3c0bULL,
0x0000000153307824ULL, 0x100fe200078e0233ULL, 0x00005f002d2d7a11ULL, 0x000fe200008f3c32ULL,
0x0000000155327824ULL, 0x100fe200078e0233ULL, 0x0000002e39367210ULL, 0x000fe40007f3e0ffULL,
0x000000383100720cULL, 0x000fe20003f46070ULL, 0x0000000154317824ULL, 0x000fe200078e0233ULL,
0x0000002f39347210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e06ffULL,
0x0000003039377210ULL, 0x000fc40007fde0ffULL, 0x0000000000307211ULL, 0x000fe400078fe8ffULL,
0x00005e00362e7a11ULL, 0x000fe200078238ffULL, 0x000000ffff507224ULL, 0x000fe200030e06ffULL,
0x0000003139357210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x0000003239337210ULL, 0x000fe20007f7e0ffULL, 0x0000000452397824ULL, 0x000fe200078e00ffULL,
0x00000003304b7812ULL, 0x000fe200078ec0ffULL, 0x000000043b327824ULL, 0x040fe200078e00ffULL,
0x00005f00362f7a11ULL, 0x000fe200008f3c2fULL, 0x000000ffff4e7224ULL, 0x000fe200020e06ffULL,
0x000000383b00720cULL, 0x000fe20003f26070ULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x000010003a3a7811ULL, 0x000fc400078e60ffULL, 0x0ffffffc4b3b7812ULL, 0x100fe400078ef800ULL,
0xfffffffc39397812ULL, 0x000fe400078ee200ULL, 0xfffffffc32497812ULL, 0x000fe200078ee24bULL,
0x000000103b3b7824ULL, 0x000fe200078e023aULL, 0x00005e0034307a11ULL, 0x040fe200078a38ffULL,
0x00000010392c7825ULL, 0x000fe200078e002cULL, 0x00005e0033327a11ULL, 0x000fe400078838ffULL,
0x00005f0034317a11ULL, 0x000fe200028f3c31ULL, 0x0000001049497824ULL, 0x000fe200078e023aULL,
0x00005e0037367a11ULL, 0x000fe200078a38ffULL, 0x00000010390a7825ULL, 0x000fe200078e000aULL,
0x00005e0035347a11ULL, 0x000fe200078638ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c3b7faeULL, 0x0003e2000d101c46ULL, 0x00005f0037377a11ULL, 0x000fe200028f3c50ULL,
0x0000001039087825ULL, 0x000fe200078e0008ULL, 0x00005f0035357a11ULL, 0x000fe200018f3c4eULL,
0x000000000a497faeULL, 0x0005e2000c901c46ULL, 0x00005f0033337a11ULL, 0x000fe200020f3c4cULL,
0x000000044f4c7824ULL, 0x000fe200078e00ffULL, 0x000000384d00720cULL, 0x080fe20003f26070ULL,
0x00000004514e7824ULL, 0x000fe200078e00ffULL, 0x000000384f00720cULL, 0x080fe20003f46070ULL,
0x00000010392e7825ULL, 0x000fe200078e002eULL, 0x000000385100720cULL, 0x000fc40003f66070ULL,
0x000000385300720cULL, 0x0c0fe20003f86070ULL, 0x00000004532c7824ULL, 0x002fe200078e00ffULL,
0x000000385400720cULL, 0x0c0fe20003fa6070ULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0x000000385500720cULL, 0x000fe20003fc6070ULL, 0x000000044d387824ULL, 0x000fe200078e00ffULL,
0xfffffffc4c2d7812ULL, 0x100fe200078ee24bULL, 0x00000004550a7824ULL, 0x004fe200078e00ffULL,
0xfffffffc4e3b7812ULL, 0x000fe200078ee24bULL, 0x0000001039307825ULL, 0x000fe200078e0030ULL,
0xfffffffc380b7812ULL, 0x000fc400078ee24bULL, 0xfffffffc2c497812ULL, 0x100fe200078ee24bULL,
0x000000102d2d7824ULL, 0x100fe200078e023aULL, 0xfffffffc544d7812ULL, 0x100fe200078ee24bULL,
0x000000100b0b7824ULL, 0x100fe200078e023aULL, 0xfffffffc0a4f7812ULL, 0x000fe200078ee24bULL,
0x000000103b3b7824ULL, 0x100fe400078e023aULL, 0x0000001049497824ULL, 0x000fe200078e023aULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000001039367825ULL, 0x000fc600078e0036ULL,
0x000000002e2d7faeULL, 0x0003e2000d101c46ULL, 0x000000104d4b7824ULL, 0x000fe400078e023aULL,
0x0000001039347825ULL, 0x000fe200078e0034ULL, 0x00000000303b7faeULL, 0x0003e6000d901c46ULL,
0x000000104f4d7824ULL, 0x000fe200078e023aULL, 0x0000000036497faeULL, 0x0003e2000e101c46ULL,
0x0000001039327825ULL, 0x000fc600078e0032ULL, 0x00000000344b7faeULL, 0x0003e8000e901c46ULL,
0x00000000324d7faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000000800307811ULL, 0x002fe200078ff0ffULL, 0x0000000452537824ULL, 0x000fe200078e00ffULL,
0x0000003300087211ULL, 0x040fe400078ff0ffULL, 0x00000000002d7211ULL, 0x000fe200078fe8ffULL,
0x0000000130097824ULL, 0x040fe200078e0233ULL, 0x00000008390b7210ULL, 0x000fe20007f3e0ffULL,
0x00000004304c7824ULL, 0x000fe200078e00ffULL, 0x0000001800327811ULL, 0x000fc400078ff0ffULL,
0x0000000939097210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e000b0a7a11ULL, 0x000fe400078238ffULL, 0x0000002000347811ULL, 0x000fe200078ff0ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e0009087a11ULL, 0x000fe400078438ffULL,
0x00005f000b0b7a11ULL, 0x000fe200008f3c2eULL, 0x0000000434507824ULL, 0x000fe200078e00ffULL,
0x00005f0009097a11ULL, 0x000fe200010f3c2cULL, 0x000000021b2c7824ULL, 0x000fe200078e0248ULL,
0x00000010002e7811ULL, 0x000fc400078ff0ffULL, 0x0000003000387811ULL, 0x000fe400078ff0ffULL,
0x000000032d357812ULL, 0x000fe200078ec0ffULL, 0x00000001322d7824ULL, 0x100fe200078e0233ULL,
0x000010002c517811ULL, 0x000fe200078e60ffULL, 0x000000012e2c7824ULL, 0x000fe200078e0233ULL,
0x0000002800367811ULL, 0x000fe200078ff0ffULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0x00000038003a7811ULL, 0x000fe200078ff0ffULL, 0x000000042e4e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc50507812ULL, 0x000fe200078ee235ULL, 0x00000001342e7824ULL, 0x100fe200078e0233ULL,
0x0000002c39347210ULL, 0x000fe20007f7e0ffULL, 0x0000000138307824ULL, 0x040fe200078e0233ULL,
0xfffffffc53537812ULL, 0x100fe200078ee200ULL, 0x0000000438567824ULL, 0x000fe200078e00ffULL,
0xfffffffc4c387812ULL, 0x000fe200078ee235ULL, 0x00000001362f7824ULL, 0x000fe200078e0233ULL,
0xfffffffc324c7812ULL, 0x100fe200078ee235ULL, 0x0000000436547824ULL, 0x000fe200078e00ffULL,
0x0000002d39327210ULL, 0x040fe20007f5e0ffULL, 0x000000043a587824ULL, 0x000fe200078e00ffULL,
0xfffffffc56567812ULL, 0x000fe200078ee235ULL, 0x000000013a317824ULL, 0x000fe200078e0233ULL,
0xfffffffc4e3a7812ULL, 0x000fe200078ee235ULL, 0x000000ffff2d7224ULL, 0x000fe200018e06ffULL,
0x0000002e394e7210ULL, 0x040fe20007f3e0ffULL, 0x000000104c497824ULL, 0x000fe200078e0251ULL,
0x0000002f39337210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e06ffULL,
0xfffffffc54547812ULL, 0x000fe200078ee235ULL, 0x000000103a3b7824ULL, 0x000fe200078e0251ULL,
0xfffffffc58587812ULL, 0x000fe200078ee235ULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x0ffffffc35367812ULL, 0x000fe200078ef800ULL, 0x00000010530a7825ULL, 0x000fe200078e000aULL,
0x0000003039357210ULL, 0x000fc40007f9e0ffULL, 0x00005e00322e7a11ULL, 0x000fe200078438ffULL,
0x0000001036557824ULL, 0x000fe200078e0251ULL, 0x00005e00342c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000003139377210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x00005f00322f7a11ULL, 0x000fe200010f3c2fULL,
0x0000001038397824ULL, 0x000fe200078e0251ULL, 0x00005e004e307a11ULL, 0x000fe200078238ffULL,
0x000000ffff387224ULL, 0x000fe200028e06ffULL, 0x00005f00342d7a11ULL, 0x000fe200030f3c2dULL,
0x0000001053087825ULL, 0x000fe200078e0008ULL, 0x00005e0033327a11ULL, 0x000fe200078438ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a557faeULL, 0x0003e2000b901c46ULL,
0x00005e0035347a11ULL, 0x000fe200078638ffULL, 0x00000010532c7825ULL, 0x000fe200078e002cULL,
0x00005e0037367a11ULL, 0x000fe200078838ffULL, 0x0000000008397faeULL, 0x0003e2000b901c46ULL,
0x00005f004e317a11ULL, 0x000fe200008f3c31ULL, 0x00000010532e7825ULL, 0x000fe200078e002eULL,
0x00005f0033337a11ULL, 0x000fe200010f3c4cULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x00005f0035357a11ULL, 0x000fe200018f3c3aULL, 0x00000010504b7824ULL, 0x000fe200078e0251ULL,
0x00005f0037377a11ULL, 0x000fe200020f3c38ULL, 0x0000001053307825ULL, 0x040fe200078e0030ULL,
0x000000002e497faeULL, 0x0003e6000b901c46ULL, 0x00000010544d7824ULL, 0x000fe200078e0251ULL,
0x00000000304b7faeULL, 0x0003e2000b901c46ULL, 0x0000001053327825ULL, 0x000fc800078e0032ULL,
0x00000010564f7824ULL, 0x000fe200078e0251ULL, 0x00000000324d7faeULL, 0x0003e2000b901c46ULL,
0x0000001053347825ULL, 0x000fc800078e0034ULL, 0x0000001058517824ULL, 0x000fe200078e0251ULL,
0x00000000344f7faeULL, 0x0003e2000b901c46ULL, 0x0000001053367825ULL, 0x000fca00078e0036ULL,
0x0000000036517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5200720cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000009947ULL, 0x000fea0003800000ULL, 0x0000000203037810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff027424ULL, 0x000fc600078e00ffULL, 0x0000001a0300720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000023c087824ULL, 0x002fe400078e0203ULL,
0x00000004ff097424ULL, 0x000fc800078e00ffULL, 0x0000600008087625ULL, 0x000fca00078e0009ULL,
0x0000000608027981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff800097812ULL, 0x022fe200078ec0ffULL,
0x000000021b317824ULL, 0x000fe200078e024aULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000014c3a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000709097812ULL, 0x000fe400078ef800ULL,
0x0000100031317811ULL, 0x000fe400078e60ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011609ULL,
0x00000004092d7824ULL, 0x040fe200078e00ffULL, 0x00000020002c7810ULL, 0x000fe20007ffe0ffULL,
0x00000004090a7824ULL, 0x000fc400078e00ffULL, 0x000000010b087824ULL, 0x040fe400078e024cULL,
0x000000010b0b7824ULL, 0x000fc600078e023aULL, 0xfffffffc2d087812ULL, 0x000fe400078ee208ULL,
0xfffffffc0a0a7812ULL, 0x000fe400078ee20bULL, 0x00000007002d7812ULL, 0x000fe200078ec0ffULL,
0x0000001008507824ULL, 0x100fe200078e0231ULL, 0xfffffff82c0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000447087824ULL, 0x000fe200078e024cULL, 0x000000082d3b7812ULL, 0x100fe200078ef800ULL,
0x000000100a347824ULL, 0x000fe200078e0231ULL, 0x000000070b307812ULL, 0x000fe200078ef800ULL,
0x000000005050783bULL, 0x000e620000000200ULL, 0x0000000208097824ULL, 0x000fc400078e00ffULL,
0x000000103b2d7824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x00000001ff0b7819ULL, 0x000fe20000011630ULL, 0x0000000430397824ULL, 0x000fe200078e00ffULL,
0x0000000900087211ULL, 0x000fe200078fe0ffULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0x0000000209337810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e024cULL,
0x000000024c4c7810ULL, 0x000fe20007ffe0ffULL, 0x000000013b087824ULL, 0x000fe200078e0208ULL,
0x0000003300327211ULL, 0x000fe200078fe0ffULL, 0x000000010b4b7824ULL, 0x000fe200078e023aULL,
0xfffffffc390a7812ULL, 0x000fc400078ee20aULL, 0xfffffff02d087812ULL, 0x000fe200078ee208ULL,
0x000000013b387824ULL, 0x040fe200078e0232ULL, 0xfffffffc30307812ULL, 0x000fe200078ee24bULL,
0x000000103b3b7824ULL, 0x000fe200078e00ffULL, 0x000000044c00780cULL, 0x000fe20003f25270ULL,
0x0000001008087824ULL, 0x000fe400078e00ffULL, 0x0000001030307824ULL, 0x000fe200078e0231ULL,
0xfffffff03b387812ULL, 0x000fe400078ee238ULL, 0x00000000082c783bULL, 0x0006e60000000200ULL,
0x0000001038497824ULL, 0x000fc400078e00ffULL, 0x000000100a387824ULL, 0x000fe200078e0231ULL,
0x00000018ff097819ULL, 0x102fe40000011653ULL, 0x0000ffff53397812ULL, 0x040fe400078ec0ffULL,
0x00000009ff33723eULL, 0x000fe400020006ffULL, 0x00000010ff097819ULL, 0x000fe40000011653ULL,
0x000000ff53537812ULL, 0x000fe200078ec0ffULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x000000ff09327812ULL, 0x000fc400078ec0ffULL, 0x00000008ff097819ULL, 0x000fe40000011639ULL,
0x00000032ff32723eULL, 0x000fe200020006ffULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000010ff337819ULL, 0x000fe20000011633ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x004fe20000011637ULL,
0x20000009ff097230ULL, 0x000fe20000004100ULL, 0x00000010ff327819ULL, 0x000fc40000011632ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff087819ULL, 0x008fe40000011609ULL,
0x0000105433337816ULL, 0x000fe40000000032ULL, 0x0000105408327816ULL, 0x000fe40000000053ULL,
0x0000ffff37537812ULL, 0x000fe200078ec0ffULL, 0x000000004908783bULL, 0x0002a20000000200ULL,
0x000000ff4d4f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fe20000011637ULL,
0x000000322c04723cULL, 0x000b620000041804ULL, 0x00000008ff4d7819ULL, 0x000fe40000011653ULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff497819ULL, 0x002fe20000011650ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000010ff4e7819ULL, 0x000fe2000001164eULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000010ff4f7819ULL, 0x000fc4000001164fULL,
0x00000010ff327819ULL, 0x020fe4000001164dULL, 0x00000010ff377819ULL, 0x000fe40000011637ULL,
0x000010544e4f7816ULL, 0x000fe4000000004fULL, 0x00001054324e7816ULL, 0x000fe40000000037ULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0x00000018ff377819ULL, 0x000fe40000011650ULL,
0x000000ff50537812ULL, 0x000fc400078ec0ffULL, 0x0000ffff50797812ULL, 0x000fe400078ec0ffULL,
0x00000018ff757819ULL, 0x100fe20000011635ULL, 0x0000004e0804723cULL, 0x004be20000041804ULL,
0x000000ff35767812ULL, 0x040fe400078ec0ffULL, 0x0000ffff35507812ULL, 0x000fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fe40000011636ULL, 0x00000010ff4e7819ULL, 0x020fc40000011635ULL,
0x00000037ff35723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011651ULL,
0x00000010ff727819ULL, 0x000fe40000011652ULL, 0x00000053ff6e723eULL, 0x000fe400020006ffULL,
0x0000ffff52737812ULL, 0x000fe400078ec0ffULL, 0x000000ff36787812ULL, 0x000fe200078ec0ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x0000ffff51747812ULL, 0x000fc400078ec0ffULL,
0x000000ff71717812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4f7819ULL, 0x000fe40000011636ULL,
0x0000ffff36577812ULL, 0x000fe400078ec0ffULL, 0x00000078ff36723eULL, 0x000fe400020006ffULL,
0x00000010ff5e7819ULL, 0x102fe40000011630ULL, 0x00000018ff587819ULL, 0x000fe20000011630ULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x000000ff30597812ULL, 0x000fc400078ec0ffULL,
0x0000ffff30537812ULL, 0x000fe200078ec0ffULL, 0x20000035ff307230ULL, 0x000fe20000004100ULL,
0x00000077ff35723eULL, 0x000fe400020006ffULL, 0x000000ff72777812ULL, 0x000fe400078ec0ffULL,
0x00000008ff727819ULL, 0x000fe20000011673ULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x00000077ff78723eULL, 0x000fe400020006ffULL, 0x00000072ff77723eULL, 0x000fe400020006ffULL,
0x00000018ff707819ULL, 0x000fe20000011638ULL, 0x20000078ff727230ULL, 0x000fe20000004100ULL,
0x00000074ff73723eULL, 0x000fe200020006ffULL, 0x20000071ff747230ULL, 0x000fe20000004100ULL,
0x0000ffff34687812ULL, 0x000fe200078ec0ffULL, 0x20000077ff717230ULL, 0x000fe20000004100ULL,
0x000000ff386f7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff3a4b7812ULL, 0x000fc400078ec0ffULL, 0x00000070ff77723eULL, 0x000fe400020006ffULL,
0x00000018ff557819ULL, 0x000fe4000001163bULL, 0x00000018ff547819ULL, 0x000fe40000011651ULL,
0x000000ff51657812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fe40000011638ULL,
0x0000ffff38677812ULL, 0x000fc400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe40000011639ULL,
0x00000018ff6b7819ULL, 0x000fe40000011639ULL, 0x000000ff395f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff39617812ULL, 0x000fe400078ec0ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x00000018ff517819ULL, 0x000fc40000011652ULL, 0x00000010ff397819ULL, 0x000fe4000001163bULL,
0x000000ff3b4d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3b387812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3b7819ULL, 0x000fe40000011634ULL, 0x0000006fff70723eULL, 0x000fe200020006ffULL,
0x20000077ff6f7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fc400020006ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001163aULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000068ff77723eULL, 0x000fe200020006ffULL, 0x2000004bff687230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x20000055ff4b7230ULL, 0x000fe20000004100ULL,
0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL, 0x20000065ff6c7230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fe200020006ffULL, 0x20000077ff557230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000051ff657230ULL, 0x000fe20000004100ULL,
0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x2000003bff517230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fc400020006ffULL, 0x0000006aff78723eULL, 0x000fe200020006ffULL,
0x2000005fff6a7230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000075ff3b7230ULL, 0x000fe20000004100ULL, 0x000000ff49497812ULL, 0x000fe200078ec0ffULL,
0x20000078ff5f7230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000004fff77723eULL, 0x000fe400020006ffULL, 0x00000008ff507819ULL, 0x000fc40000011650ULL,
0x000000ff325c7812ULL, 0x000fe400078ec0ffULL, 0x00000049ff75723eULL, 0x000fe200020006ffULL,
0x20000076ff497230ULL, 0x000fe20000004100ULL, 0x00000058ff78723eULL, 0x000fe200020006ffULL,
0x2000004eff587230ULL, 0x000fe20000004100ULL, 0x00000008ff767819ULL, 0x000fe20000011679ULL,
0x20000077ff4e7230ULL, 0x000fe20000004100ULL, 0x00000008ff577819ULL, 0x000fe20000011657ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000054ff69723eULL, 0x000fe400020006ffULL,
0x000000ff336d7812ULL, 0x000fe400078ec0ffULL, 0x0000005cff77723eULL, 0x000fe200020006ffULL,
0x20000059ff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x100fe20000011631ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000018ff5b7819ULL, 0x000fe20000011631ULL,
0x20000077ff597230ULL, 0x000fe20000004100ULL, 0x000000ff315a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff31377812ULL, 0x000fe400078ec0ffULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x00000018ff317819ULL, 0x000fe40000011633ULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000057ff4f723eULL, 0x000fe200020006ffULL,
0x20000050ff577230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x20000078ff507230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000031ff77723eULL, 0x000fc400020006ffULL,
0x00000064ff78723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe2000001163aULL,
0x20000077ff647230ULL, 0x000fe20000004100ULL, 0x00000063ff31723eULL, 0x000fe200020006ffULL,
0x2000006dff637230ULL, 0x000fe20000004100ULL, 0x000000ff62797812ULL, 0x000fe200078ec0ffULL,
0x20000067ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe20000011630ULL,
0x20000078ff677230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fe20000011661ULL,
0x20000031ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fc4000001166eULL,
0x00000010ff317819ULL, 0x000fe40000011675ULL, 0x00000010ff617819ULL, 0x000fe40000011676ULL,
0x0000ffff3a607812ULL, 0x000fe400078ec0ffULL, 0x000000ff52667812ULL, 0x000fe400078ec0ffULL,
0x0000105462317816ULL, 0x000fe40000000031ULL, 0x0000105461307816ULL, 0x000fc40000000030ULL,
0x00000008ff607819ULL, 0x000fe40000011660ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x000000ff39397812ULL, 0x000fe200078ec0ffULL, 0x000000302c0c723cULL, 0x000b62000004180cULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe20000011669ULL,
0x20000060ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x020fe2000001166cULL,
0x20000039ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x000fc40000011674ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x0000105462317816ULL, 0x000fe40000000031ULL,
0x0000105473307816ULL, 0x000fe40000000030ULL, 0x00000008ff6c7819ULL, 0x000fe40000011638ULL,
0x00000010ff627819ULL, 0x000fe40000011665ULL, 0x00000010ff397819ULL, 0x000fe20000011672ULL,
0x000000302c10723cULL, 0x000be20000041810ULL, 0x00000010ff387819ULL, 0x000fc40000011666ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x0000105462397816ULL, 0x000fe20000000039ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x0000105471387816ULL, 0x000fe20000000038ULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff567819ULL, 0x000fc40000011634ULL,
0x000000ff5e627812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x000fe2000001166fULL,
0x000000382c14723cULL, 0x000be40000041814ULL, 0x00000010ff307819ULL, 0x020fe40000011670ULL,
0x00000010ff317819ULL, 0x000fe40000011677ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x000000ff34527812ULL, 0x000fe400078ec0ffULL,
0x000000ff56567812ULL, 0x000fe200078ec0ffULL, 0x20000079ff617230ULL, 0x000fe20000004100ULL,
0x00000062ff66723eULL, 0x000fe400020006ffULL, 0x000010545e317816ULL, 0x000fe40000000031ULL,
0x000010546d307816ULL, 0x000fe20000000030ULL, 0x20000066ff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fc4000001166bULL, 0x00000010ff387819ULL, 0x000fe4000001166aULL,
0x00000010ff397819ULL, 0x000fe20000011667ULL, 0x000000302c1c723cULL, 0x000b62000004181cULL,
0x00000010ff657819ULL, 0x000fe40000011678ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000105462397816ULL, 0x000fe20000000039ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x0000105465387816ULL, 0x000fe20000000038ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff54627812ULL, 0x000fc400078ec0ffULL,
0x00000010ff547819ULL, 0x000fe4000001165fULL, 0x00000010ff317819ULL, 0x020fe20000011661ULL,
0x000000382c20723cULL, 0x000b620000041820ULL, 0x00000008ff537819ULL, 0x000fe40000011653ULL,
0x0000105454317816ULL, 0x000fe40000000031ULL, 0x00000010ff547819ULL, 0x000fe40000011651ULL,
0x00000010ff387819ULL, 0x020fc40000011652ULL, 0x00000010ff397819ULL, 0x000fe40000011656ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff307819ULL, 0x000fe40000011668ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff4d7819ULL, 0x000fc4000001164dULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x0000105454397816ULL, 0x000fe40000000039ULL,
0x0000105455387816ULL, 0x000fe20000000038ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000105469307816ULL, 0x000fc40000000030ULL, 0x000010544b6d7816ULL, 0x000fe40000000060ULL,
0x000010546c6c7816ULL, 0x000fe2000000004dULL, 0x00000038080c723cULL, 0x000be2000004180cULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x00000010ff3a7819ULL, 0x100fe40000011632ULL,
0x00000018ff5d7819ULL, 0x000fe40000011632ULL, 0x00000010ff347819ULL, 0x000fe20000011633ULL,
0x000000302c24723cULL, 0x000f620000041824ULL, 0x000000ff3a3a7812ULL, 0x000fe200078ec0ffULL,
0x20000037ff397230ULL, 0x020fe20000004100ULL, 0x0000ffff32327812ULL, 0x000fc400078ec0ffULL,
0x0000ffff33337812ULL, 0x000fe400078ec0ffULL, 0x00000010ff377819ULL, 0x000fe2000001164eULL,
0x0000006c2c28723cULL, 0x000b620000041828ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff2c7819ULL, 0x020fc40000011635ULL, 0x00000010ff2d7819ULL, 0x000fe4000001165eULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000008ff327819ULL, 0x000fe20000011632ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff34347812ULL, 0x000fe200078ec0ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x000010542c377816ULL, 0x000fc40000000037ULL, 0x00000008ff337819ULL, 0x000fe40000011633ULL,
0x00001054502d7816ULL, 0x000fe4000000002dULL, 0x00001054532c7816ULL, 0x000fe4000000005cULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000032ff32723eULL, 0x000fe200020006ffULL, 0x0000002c081c723cULL, 0x000b62000004181cULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000033ff2f723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff337819ULL, 0x000fe2000001163aULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x00000010ff2c7819ULL, 0x020fe2000001165dULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fe2000001165bULL, 0x2000002fff2f7230ULL, 0x000fe20000004100ULL,
0x000010542c337816ULL, 0x000fc40000000033ULL, 0x00000010ff387819ULL, 0x000fe4000001163bULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff317819ULL, 0x000fe40000011658ULL,
0x00000010ff307819ULL, 0x000fe40000011657ULL, 0x00000010ff367819ULL, 0x000fe40000011636ULL,
0x00000010ff4f7819ULL, 0x000fc4000001164fULL, 0x00000010ff5b7819ULL, 0x000fe40000011662ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff327819ULL, 0x000fe40000011632ULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x00000010ff2d7819ULL, 0x000fe40000011634ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff2c7819ULL, 0x000fe4000001162fULL,
0x0000105438317816ULL, 0x000fe40000000031ULL, 0x0000105430307816ULL, 0x000fe40000000049ULL,
0x000010544f367816ULL, 0x000fc40000000036ULL, 0x000010542e5b7816ULL, 0x000fe4000000005bULL,
0x00001054395a7816ULL, 0x000fe2000000005aULL, 0x000000300810723cULL, 0x000b620000041810ULL,
0x0000105432327816ULL, 0x000fe40000000059ULL, 0x00001054642d7816ULL, 0x000fe4000000002dULL,
0x000010542c2c7816ULL, 0x000fc60000000063ULL, 0x000000360814723cULL, 0x040b700000041814ULL,
0x0000005a0820723cULL, 0x040b700000041820ULL, 0x000000320824723cULL, 0x040b700000041824ULL,
0x0000002c0828723cULL, 0x000b620000041828ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe7c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0048ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd8f000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000003e102d7220ULL, 0x0a0fe20000410000ULL, 0x0000003e060b7220ULL, 0x080fe20000410000ULL,
0x0000003e07107220ULL, 0x080fe20000410000ULL, 0x0000003e20207220ULL, 0x080fe20000410000ULL,
0x0000003e21217220ULL, 0x080fe20000410000ULL, 0x0000003e14147220ULL, 0x080fe20000410000ULL,
0x0000003e15157220ULL, 0x080fe20000410000ULL, 0x0000003e04047220ULL, 0x080fe20000410000ULL,
0x0000003e05057220ULL, 0x080fe20000410000ULL, 0x0000003e1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003e24067220ULL, 0x080fe20000410000ULL,
0x0000003e25077220ULL, 0x080fe20000410000ULL, 0x0000003e112c7220ULL, 0x080fe20000410000ULL,
0x0000003e12087220ULL, 0x080fe20000410000ULL, 0x0000003e1f117220ULL, 0x080fe20000410000ULL,
0x0000003e16097220ULL, 0x080fe20000410000ULL, 0x0000003e26307220ULL, 0x080fe20000410000ULL,
0x0000003e27317220ULL, 0x080fe20000410000ULL, 0x0000003e281f7220ULL, 0x080fe20000410000ULL,
0x0000003e29127220ULL, 0x080fe20000410000ULL, 0x0000003e2a327220ULL, 0x080fe20000410000ULL,
0x0000003e2b337220ULL, 0x080fe20000410000ULL, 0x000000ffff257224ULL, 0x000fe200078e0020ULL,
0x0000003e0c2f7220ULL, 0x080fe20000410000ULL, 0x000000ffff247224ULL, 0x000fe200078e0021ULL,
0x0000003e0d2e7220ULL, 0x080fe20000410000ULL, 0x0000003e0e0e7220ULL, 0x080fe20000410000ULL,
0x0000003e0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003e13137220ULL, 0x080fe20000410000ULL,
0x0000003e170a7220ULL, 0x080fe20000410000ULL, 0x0000003e1e167220ULL, 0x080fe20000410000ULL,
0x0000003e22227220ULL, 0x080fe20000410000ULL, 0x0000003e23237220ULL, 0x000fe20000410000ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0014ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0015ULL,
0x000000ffff297224ULL, 0x000fe400078e0004ULL, 0x000000ffff287224ULL, 0x000fe400078e0005ULL,
0x000000ffff277224ULL, 0x000fe400078e001cULL, 0x000000ffff267224ULL, 0x000fe400078e001dULL,
0x000000ffff217224ULL, 0x000fc400078e0006ULL, 0x000000ffff207224ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000400c7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff087224ULL, 0x000fe400078e000aULL,
0x000000ffff0a7224ULL, 0x000fe400078e000bULL, 0x000000ffff1e7224ULL, 0x000fe400078e000eULL,
0x000000ffff1d7224ULL, 0x000fc400078e000fULL, 0x000000ffff177224ULL, 0x000fe400078e0013ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0011ULL,
0x000000ffff137224ULL, 0x000fe400078e0022ULL, 0x000000ffff147224ULL, 0x000fe400078e0023ULL,
0x000000ffff117224ULL, 0x000fc400078e0030ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0031ULL,
0x000000ffff107224ULL, 0x000fe400078e0032ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0033ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040040077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604237210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000002306067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040040077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004000d7824ULL, 0x000fe200078e00ffULL,
0x000000414600720cULL, 0x000fc80003f05270ULL, 0xfffffff00d0c7812ULL, 0x000fca00078ec0ffULL,
0x000000801b0c7824ULL, 0x000fca00078e020cULL, 0x00f400000c047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000200227824ULL, 0x000fe400078e00ffULL,
0x0000000144437824ULL, 0x000fc600078e0a43ULL, 0x0000000622227812ULL, 0x000fc800078ec0ffULL,
0x0000000122307812ULL, 0x040fe400078efcffULL, 0x0000000822327812ULL, 0x000fe400078efcffULL,
0x000000433000720cULL, 0x080fe40003f26070ULL, 0x0000001022307812ULL, 0x000fe400078efcffULL,
0x000000433200720cULL, 0x080fe40003f06070ULL, 0x000000433000720cULL, 0x000fc40003fc6070ULL,
0x0000001122327812ULL, 0x040fe400078efcffULL, 0x0000001822307812ULL, 0x040fe400078efcffULL,
0x000000432200720cULL, 0x080fe40003f46070ULL, 0x000000433200720cULL, 0x080fe40003fa6070ULL,
0x000000433000720cULL, 0x000fe40003f66070ULL, 0x0000000922347812ULL, 0x000fc400078efcffULL,
0x0000001922327812ULL, 0x040fe400078efcffULL, 0x0000002022307812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff8000002f2f7808ULL, 0x000fe40005000000ULL,
0xff8000001d1d7808ULL, 0x000fe40004800000ULL, 0xff8000002e2e7808ULL, 0x000fc40004800000ULL,
0x000000433400720cULL, 0x080fe40003f86070ULL, 0x000000433200720cULL, 0x080fe40003f46070ULL,
0x000000433000720cULL, 0x000fe40003f26070ULL, 0x0000002122327812ULL, 0x040fe400078efcffULL,
0x0000002822307812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fc40004000000ULL,
0xff8000002d2d7808ULL, 0x000fe40004000000ULL, 0xff80000017177808ULL, 0x000fe40006000000ULL,
0xff8000002c2c7808ULL, 0x000fe40006000000ULL, 0x000000433200720cULL, 0x080fe40003f06070ULL,
0x000000433000720cULL, 0x000fe40003f86070ULL, 0x0000002922327812ULL, 0x000fc400078efcffULL,
0x0000003022307812ULL, 0x000fe400078efcffULL, 0xff80000009097808ULL, 0x000fe40007000000ULL,
0xff8000002b2b7808ULL, 0x000fe40007000000ULL, 0xff80000008087808ULL, 0x000fe40006800000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0x000000433200720cULL, 0x000fc40003fc6070ULL,
0x000000433000720cULL, 0x000fe40003fa6070ULL, 0x0000003122327812ULL, 0x040fe400078efcffULL,
0x0000003822307812ULL, 0x040fe400078efcffULL, 0x0000003922227812ULL, 0x000fe400078efcffULL,
0xff8000000a0a7808ULL, 0x000fe40005800000ULL, 0xff80000029297808ULL, 0x000fc40005800000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff80000028287808ULL, 0x000fe40005000000ULL,
0xff80000016167808ULL, 0x000fe40004800000ULL, 0xff80000027277808ULL, 0x000fe40004800000ULL,
0x000000433200720cULL, 0x080fe40003f66070ULL, 0x000000433000720cULL, 0x000fc40003f46070ULL,
0x000000432200720cULL, 0x000fe40003f26070ULL, 0xff80000015157808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40006000000ULL,
0xff80000025257808ULL, 0x000fe40006000000ULL, 0xff80000014147808ULL, 0x000fc40007000000ULL,
0xff80000024247808ULL, 0x000fe40007000000ULL, 0xff80000011117808ULL, 0x000fe40006800000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40005800000ULL,
0xff80000020207808ULL, 0x000fe40005800000ULL, 0xff80000010107808ULL, 0x000fc40005000000ULL,
0xff8000001f1f7808ULL, 0x000fe40005000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fc40004800000ULL, 0x0000002f0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff367424ULL, 0x000fe200078e00ffULL, 0x0000001e0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x000000042f237208ULL, 0x000fe40004000000ULL,
0x000000051e047208ULL, 0x000fc40004800000ULL, 0x0000002e2300720bULL, 0x000fe40003f1e000ULL,
0x0000001d0400720bULL, 0x000fe40003f3e000ULL, 0x000000232e227208ULL, 0x000fe40004000000ULL,
0x000000041d057208ULL, 0x000fe40004800000ULL, 0x0000002d2200720bULL, 0x000fe40003f1e000ULL,
0x0000001c0500720bULL, 0x000fc40003f3e000ULL, 0x000000222d237208ULL, 0x000fe40004000000ULL,
0x000000051c047208ULL, 0x000fe40004800000ULL, 0x0000002c2300720bULL, 0x000fe40003f1e000ULL,
0x000000170400720bULL, 0x000fe40003f3e000ULL, 0x000000232c227208ULL, 0x000fe40004000000ULL,
0x0000000417047208ULL, 0x000fc40004800000ULL, 0x0000002b2200720bULL, 0x000fe40003f1e000ULL,
0x000000090400720bULL, 0x000fe40003f3e000ULL, 0x000000222b057208ULL, 0x000fe40004000000ULL,
0x0000000409237208ULL, 0x000fe40004800000ULL, 0x0000002a0500720bULL, 0x000fe40003f1e000ULL,
0x000000082300720bULL, 0x000fc40003f3e000ULL, 0x000000052a047208ULL, 0x000fe40004000000ULL,
0x0000002308237208ULL, 0x000fe40004800000ULL, 0x000000290400720bULL, 0x000fe40003f1e000ULL,
0x0000000a2300720bULL, 0x000fe40003f3e000ULL, 0x0000000429057208ULL, 0x000fe40004000000ULL,
0x000000230a047208ULL, 0x000fc40004800000ULL, 0x000000280500720bULL, 0x000fe40003f1e000ULL,
0x0000000b0400720bULL, 0x000fe40003f3e000ULL, 0x0000000528227208ULL, 0x000fe40004000000ULL,
0x000000040b057208ULL, 0x000fe40004800000ULL, 0x000000272200720bULL, 0x000fe40003f1e000ULL,
0x000000160500720bULL, 0x000fc40003f3e000ULL, 0x0000002227237208ULL, 0x000fe40004000000ULL,
0x0000000516047208ULL, 0x000fe40004800000ULL, 0x000000262300720bULL, 0x000fe40003f1e000ULL,
0x000000150400720bULL, 0x000fe40003f3e000ULL, 0x0000002326227208ULL, 0x000fe40004000000ULL,
0x0000000415047208ULL, 0x000fc40004800000ULL, 0x000000252200720bULL, 0x000fe40003f1e000ULL,
0x000000130400720bULL, 0x000fe40003f3e000ULL, 0x0000002225057208ULL, 0x000fe40004000000ULL,
0x0000000413237208ULL, 0x000fe40004800000ULL, 0x000000240500720bULL, 0x000fe40003f1e000ULL,
0x000000142300720bULL, 0x000fc40003f3e000ULL, 0x0000000524047208ULL, 0x000fe40004000000ULL,
0x0000002314227208ULL, 0x000fe40004800000ULL, 0x000000210400720bULL, 0x000fe40003f1e000ULL,
0x000000112200720bULL, 0x000fe40003f3e000ULL, 0x0000000421057208ULL, 0x000fe40004000000ULL,
0x0000002211227208ULL, 0x000fc40004800000ULL, 0x000000200500720bULL, 0x000fe40003f1e000ULL,
0x0000000f2200720bULL, 0x000fe40003f3e000ULL, 0x0000000520047208ULL, 0x000fe40004000000ULL,
0x000000220f057208ULL, 0x000fe40004800000ULL, 0x0000001f0400720bULL, 0x000fe40003f1e000ULL,
0x000000100500720bULL, 0x000fc40003f3e000ULL, 0x000000041f237208ULL, 0x000fe40004000000ULL,
0x0000000510057208ULL, 0x000fe40004800000ULL, 0x000000122300720bULL, 0x000fe40003f1e000ULL,
0x0000000e0500720bULL, 0x000fe40003f3e000ULL, 0x0000002312327208ULL, 0x000fe40004000000ULL,
0x000000050e347208ULL, 0x000fe20004800000ULL, 0x000015327f007947ULL, 0x000fec000b800000ULL,
0x0c401f0032047f89ULL, 0x0004e400000e0000ULL, 0x000000043200720bULL, 0x008fc80003f1e000ULL,
0x0000003204357208ULL, 0x000fe20004000000ULL, 0x000015427f007947ULL, 0x000fea000b800000ULL,
0x0c401f0034047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000e6800000e0000ULL,
0x0c401f0007227f89ULL, 0x000ea200000e0000ULL, 0x000000043400720bULL, 0x008fc40003f1e000ULL,
0x000000050600720bULL, 0x002fe40003f3e000ULL, 0x0000003404307208ULL, 0x000fe40004000000ULL,
0x0000000605317208ULL, 0x000fe20004800000ULL, 0x0c201f0035047f89ULL, 0x000e6200000e0000ULL,
0x000000220700720bULL, 0x004fc60003f1e000ULL, 0x0c201f0030057f89ULL, 0x000ea200000e0000ULL,
0x0000000722227208ULL, 0x000fc60004000000ULL, 0x0c201f0031327f89ULL, 0x000ee800000e0000ULL,
0x0c201f0022237f89ULL, 0x0002e400000e0000ULL, 0x000000043500720bULL, 0x002fe40003f1e000ULL,
0x000000053000720bULL, 0x004fe40003f3e000ULL, 0x0000003504047208ULL, 0x000fc40004000000ULL,
0x000000323100720bULL, 0x008fe40003f5e000ULL, 0x0000003005057208ULL, 0x000fe40004800000ULL,
0x0000003132067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b05337820ULL, 0x002fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b17177823ULL, 0x000fe20000010833ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b09097823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b0b377823ULL, 0x000fe20000010833ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x000fe20000010833ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fe20000010833ULL,
0x000000232200720bULL, 0x004fca0003f3e000ULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001d001d7308ULL, 0x000ff00000000800ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000001700177308ULL, 0x000e700000000800ULL,
0x0000002000317308ULL, 0x0005f00000000800ULL, 0x0000002100307308ULL, 0x0007e20000000800ULL,
0x00000004ff207e24ULL, 0x004fe2000f8e00ffULL, 0x0000001c170b723eULL, 0x002fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b16177823ULL, 0x000fc40000010833ULL,
0x3f8000002020783eULL, 0x000fe400000010ffULL, 0x0000001f00327308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0a217823ULL, 0x108fe20000010833ULL, 0x0000002d2c0a723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b152d7823ULL, 0x000fca0000010833ULL, 0x0000000900347308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b081f7823ULL, 0x002fe20000010833ULL, 0x0000002f2e08723eULL, 0x000fcc00000010ffULL,
0x0000002100367308ULL, 0x0003e20000000800ULL, 0x0000001e1d09723eULL, 0x004fce00000010ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x000000ffff217224ULL, 0x002fce00078e0020ULL,
0x0000002800287308ULL, 0x000e700000000800ULL, 0x0000001f00357308ULL, 0x0004f00000000800ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x00000020081c723cULL, 0x004b6200000418ffULL,
0x000000292816723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b11297823ULL, 0x000fca0000010833ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b14217823ULL, 0x020fe20000010833ULL,
0x000000343515723eULL, 0x008fcc00000010ffULL, 0x0000003700377308ULL, 0x000eb00000000800ULL,
0x00000017002c7308ULL, 0x0005e20000000800ULL, 0x0000002b2a14723eULL, 0x002fe400000010ffULL,
0x00000002ff2a7819ULL, 0x000fc80000011600ULL, 0x000000012a117810ULL, 0x040fe20007ffe0ffULL,
0x0000002100287308ULL, 0x0003e20000000800ULL, 0x000000363717723eULL, 0x004fe200000010ffULL,
0x000000082a127824ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x100fe400078e0020ULL,
0x000000ffff377224ULL, 0x100fe200078e0020ULL, 0xfffffff8122b7812ULL, 0x000fe200078ee211ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000ffff217224ULL, 0x002fc400078e0020ULL,
0x000000082a357824ULL, 0x040fe400078e00ffULL, 0x000000082a3b7824ULL, 0x000fc600078e00ffULL,
0x00000020141c723cULL, 0x000b62000004181cULL, 0x0000002600267308ULL, 0x000e6c0000000800ULL,
0x3fb8aa3b10217823ULL, 0x120fe20000010833ULL, 0x3fb8aa3b0e337823ULL, 0x000fe20000010833ULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000ea20000000800ULL,
0x000000272610723eULL, 0x002fc400000010ffULL, 0x000000042a267810ULL, 0x040fe40007ffe0ffULL,
0x000000082a277810ULL, 0x040fe40007ffe0ffULL, 0xfffffff835357812ULL, 0x000fe200078ee226ULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0xffffffff2a267810ULL, 0x000fc80007ffe0ffULL,
0xfffffff83b3b7812ULL, 0x000fc600078ee226ULL, 0x0000001300137308ULL, 0x000ee20000000800ULL,
0x000000252412723eULL, 0x004fe400000010ffULL, 0x000000032a257810ULL, 0x040fe40007ffe0ffULL,
0x000000022a247810ULL, 0x040fe40007ffe0ffULL, 0x0000002c2d11723eULL, 0x002fe200000010ffULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x000000082a2d7824ULL, 0x040fe400078e00ffULL,
0x000000082a2c7824ULL, 0x000fc600078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee224ULL,
0x000000132813723eULL, 0x008fe200000010ffULL, 0x000000082a287824ULL, 0x040fe200078e00ffULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x000000052a247810ULL, 0x000fc60007ffe0ffULL,
0xfffffff8282f7812ULL, 0x000fe200078ee225ULL, 0x00000036101c723cULL, 0x000b62000004181cULL,
0x000000062a257810ULL, 0x000fe40007ffe0ffULL, 0x0000003300287308ULL, 0x000fe40000000800ULL,
0xfffffff82c397812ULL, 0x000fe400078ee225ULL, 0x000000082a377824ULL, 0x020fc800078e00ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0xfffffff837377812ULL, 0x000fe400078ee224ULL,
0x000000303124723eULL, 0x000fe400000010ffULL, 0x000000320726723eULL, 0x002fe400000010ffULL,
0x0000002223077208ULL, 0x000fe20004800000ULL, 0x0000000f000e7308ULL, 0x0002a40000000800ULL,
0x000000082a0f7824ULL, 0x002fca00078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee22aULL,
0x00000008272a7824ULL, 0x000fe200078e00ffULL, 0x000000290e25723eULL, 0x004fe400000010ffULL,
0x0000000c0d0e7812ULL, 0x000fe400078ec0ffULL, 0xfffffff82a337812ULL, 0x000fe400078ee227ULL,
0x000000212827723eULL, 0x000fe200000010ffULL, 0x000000ffff217224ULL, 0x000fe200078e0020ULL,
0x000090001b2a7811ULL, 0x000fca00078e58ffULL, 0x000000100f0f7824ULL, 0x100fe200078e022aULL,
0x00000020241c723cULL, 0x000f62000004181cULL, 0x000000102b2b7824ULL, 0x100fe400078e022aULL,
0x000000102d2d7824ULL, 0x100fe400078e022aULL, 0x000000102f2f7824ULL, 0x100fe400078e022aULL,
0x0000001035357824ULL, 0x000fe400078e022aULL, 0x000000010f0f7824ULL, 0x000fc400078e020eULL,
0x0000001037377824ULL, 0x100fe400078e022aULL, 0x000000010e2b7824ULL, 0x040fe200078e022bULL,
0x000000080f007388ULL, 0x0003e20000000800ULL, 0x0000001039397824ULL, 0x100fe400078e022aULL,
0x000000010e2d7824ULL, 0x040fe200078e022dULL, 0x0000000a2b007388ULL, 0x0003e20000000800ULL,
0x000000103b3b7824ULL, 0x100fe400078e022aULL, 0x000000010e2f7824ULL, 0x000fe200078e022fULL,
0x000000142d007388ULL, 0x0003e20000000800ULL, 0x0000001033337824ULL, 0x000fc400078e022aULL,
0x000000010e357824ULL, 0x040fe200078e0235ULL, 0x000000162f007388ULL, 0x0003e20000000800ULL,
0x000000010e377824ULL, 0x040fe400078e0237ULL, 0x000000010e397824ULL, 0x040fe200078e0239ULL,
0x0000001035007388ULL, 0x0003e20000000800ULL, 0x000000010e3b7824ULL, 0x040fe400078e023bULL,
0x000000010e0e7824ULL, 0x000fe200078e0233ULL, 0x0000001237007388ULL, 0x0003e20000000800ULL,
0x000000ffff1d7224ULL, 0x020fc600078e001eULL, 0x0000002439007388ULL, 0x0003e80000000800ULL,
0x000000263b007388ULL, 0x0003e80000000800ULL, 0x000000090e007388ULL, 0x0003e80000000800ULL,
0x0004000b2b007388ULL, 0x0003e80000000800ULL, 0x000400152d007388ULL, 0x0003e80000000800ULL,
0x000400172f007388ULL, 0x0003e80000000800ULL, 0x0004001135007388ULL, 0x0003e80000000800ULL,
0x0004001337007388ULL, 0x0003e80000000800ULL, 0x0004002539007388ULL, 0x0003e80000000800ULL,
0x000400273b007388ULL, 0x0003e80000000800ULL, 0x00f000040c008388ULL, 0x0003e80000000c00ULL,
0x00f2001c0c008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000042ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080042ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100042ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000146467810ULL, 0x000fe20007ffe0ffULL, 0x0000180042ff7f8cULL, 0x0003e6000c80043fULL,
0x000000194600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffbb5000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff1f7807ULL, 0x004fe40004000000ULL, 0x00013b50001e7802ULL, 0x000fc40000000f00ULL,
0x00000c7000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff077224ULL, 0x000fe200078e0022ULL,
0xfffee7d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004000000ULL,
0x00013ba0001e7802ULL, 0x000fc40000000f00ULL, 0x00000c2000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff207224ULL, 0x000fe200078e0022ULL, 0xfffee84000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x004fe200078e0045ULL, 0x00013bf000497802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1e7224ULL, 0x004fe200078e0023ULL,
0xfffee90000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e0045ULL,
0x00013c4000497802ULL, 0x000fc40000000f00ULL, 0x00000b3000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1e7224ULL, 0x004fe200078e0023ULL, 0xfffeea2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e001dULL, 0x00013ca000497802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0018ULL, 0x00000ad000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0023ULL, 0xfffeee3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1e7224ULL, 0x000fe200078e0016ULL, 0x00013d0000497802ULL, 0x000fe20000000f00ULL,
0x000000ffff237224ULL, 0x000fc400078e001dULL, 0x00000a7000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0023ULL, 0xfffeee0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x008fe40004000000ULL, 0x00013d50001e7802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff217224ULL, 0x000fe200078e0022ULL,
0xffff180000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004000000ULL,
0x00013da0001e7802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x000fea0003c00000ULL,
0xffff186000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e004bULL,
0x00013de000497802ULL, 0x000fc40000000f00ULL, 0x0000099000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0023ULL, 0xffff194000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e004bULL, 0x00013e3000497802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0023ULL,
0xffff1a5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x00013e9000497802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fc400078e001dULL,
0x000008e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0023ULL,
0xffff1e6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x00013ee000497802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0023ULL, 0xffff1e4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x004fe40004000000ULL, 0x00013f30001e7802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff217224ULL, 0x000fe200078e0022ULL,
0xffff458000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004000000ULL,
0x00013f80001e7802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x018fea0003c00000ULL,
0xffff45e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e004bULL,
0x00013fc000497802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0023ULL, 0xffff46c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e004bULL, 0x0001401000497802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0023ULL,
0xffff47d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x0001407000497802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fc400078e001dULL,
0x0000070000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0023ULL,
0xffff4be000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x000140c000497802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0023ULL, 0xffff4bc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x002fe40004000000ULL, 0x00014110001e7802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0022ULL,
0xffff730000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004000000ULL,
0x00014160001e7802ULL, 0x000fc40000000f00ULL, 0x0000066000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0022ULL, 0xffff735000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e0011ULL, 0x000141b000497802ULL, 0x000fc40000000f00ULL,
0x000005c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0023ULL,
0xffff742000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e0011ULL,
0x0001420000497802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0023ULL, 0xffff753000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e000cULL, 0x0001426000497802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e000dULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0023ULL, 0xffff793000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e000cULL, 0x000142b000497802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0023ULL,
0xffff791000007947ULL, 0x000fea000383ffffULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0001430000307802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0023ULL, 0xffffea9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0034ULL, 0x0001436000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x000000233400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x000143c000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000003423347208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000230600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0007ULL,
0x0001442000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000000623067208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000230700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0035ULL,
0x0001448000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000000723227208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000233500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0034ULL,
0x000144e000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000003523047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000233400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0001454000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000003423057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000230600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0022ULL,
0x000145a000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000000623067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe96000007947ULL, 0x000fea000383ffffULL, 0x0180000006007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000600008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000007ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x006fe400078e0004ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffeb8d006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x0c00003332237389ULL, 0x0002a200000e0036ULL,
0xfffeb89030007950ULL, 0x000fea0003c3ffffULL, 0x0000001400007348ULL, 0x000fe80003800000ULL,
0x0000001e23237389ULL, 0x0002a200000e0013ULL, 0x00000000ff1f7424ULL, 0x000fc400078e00ffULL,
0x000000ffff1e7224ULL, 0x002fc800078e0049ULL, 0xfffeb8401e007950ULL, 0x000fea0003c3ffffULL,
0x000000011f00780cULL, 0x000fe20003f05070ULL, 0x0000001200007348ULL, 0x000fd80003800000ULL,
0x00000000001f7806ULL, 0x000fc800040e0100ULL, 0x000000121f227212ULL, 0x000fe200078ec0ffULL,
0x00000000ff1f7424ULL, 0x000fc800078e00ffULL, 0xfffeb7e01e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000348ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d18ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd8ULL, 0x0000000000000780ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001558ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001568ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015fcULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000014900ULL, 0x9600001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016100ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016150ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000164d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015f8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014b08ULL, 0x0000000000014b08ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000164d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 91568;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
