/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017350ULL, 0x0000000000016fd0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x00000000000153f0ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000015570ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x00000000000155b0ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000015600ULL, 0x0000000000000100ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015700ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000153f000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x00538c0400288080ULL,
0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8c08288080820828ULL,
0x2880809808288080ULL, 0x809c082880809908ULL, 0x082880809f082880ULL, 0x8080a308288080a1ULL,
0xad08288080ab0828ULL, 0x288080af08288080ULL, 0x80b408288080b008ULL, 0x1628808084082880ULL,
0x0000031028808280ULL, 0x8492000000000000ULL, 0x0000002200288080ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x000153f000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809608288080ULL, 0x8099082880809808ULL,
0x082880809c082880ULL, 0x8080a1082880809fULL, 0xab08288080a30828ULL, 0x288080ad08288080ULL,
0x80b008288080af08ULL, 0x08288080b4082880ULL, 0x8082801628808094ULL, 0x0000000000031028ULL,
0x2880809492000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000014000000000ULL,
0x0001557000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808c08288080ULL, 0x809c082880809808ULL,
0x082880809f082880ULL, 0x8080a308288080a1ULL, 0xad08288080ab0828ULL, 0x288080af08288080ULL,
0x80b408288080b008ULL, 0x1628808099082880ULL, 0x0000031028808280ULL, 0x9992000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000020000000000ULL, 0x000155b000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8098288080990900ULL, 0x0000000000002880ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809908288080ULL,
0x809f082880809c08ULL, 0x08288080a1082880ULL, 0x8080ab08288080a3ULL, 0xaf08288080ad0828ULL,
0x288080b008288080ULL, 0x809808288080b408ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080989200ULL, 0x0000001cffffffffULL, 0x000002c800000000ULL, 0x0001560000000000ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x000823040000007fULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL, 0x0000001800080a04ULL,
0x0060190300600160ULL, 0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL,
0x0021f00000500008ULL, 0x00000000000c1704ULL, 0x0011f00000480007ULL, 0x00000000000c1704ULL,
0x0081f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL,
0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL,
0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0004310400801b03ULL, 0x0134290400000900ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x00000340000002e0ULL, 0x0000265000000580ULL,
0x0000282000002700ULL, 0x00002e1000002980ULL, 0x00002e9000002e40ULL, 0x0000566000002ee0ULL,
0x0000583000005700ULL, 0x00005e2000005990ULL, 0x00005ea000005e50ULL, 0x0000844000005ef0ULL,
0x00008610000084e0ULL, 0x00008c0000008770ULL, 0x00008c8000008c30ULL, 0x0000b29000008cd0ULL,
0x0000b4600000b330ULL, 0x0000ba500000b5c0ULL, 0x0000bad00000ba80ULL, 0x0000d5500000bb20ULL,
0x00013ca00000d560ULL, 0x00013cf000013ce0ULL, 0x00013d5000013d00ULL, 0x00013d9000013d70ULL,
0x00014a3000013da0ULL, 0x00014ac000014a70ULL, 0x00014b5000014b00ULL, 0x00014bf000014ba0ULL,
0x00014c8000014c30ULL, 0x00014d1000014cc0ULL, 0x00014db000014d60ULL, 0x00014e4000014df0ULL,
0x00014ed000014e80ULL, 0x00014f7000014f20ULL, 0x0001500000014fb0ULL, 0x0001509000015040ULL,
0x00015130000150e0ULL, 0x000151f000015190ULL, 0x000152b000015250ULL, 0x0001537000015310ULL,
0x04403904000153d0ULL, 0x000000ff000003f0ULL, 0x003f01000000f600ULL, 0x0000000900000470ULL,
0x003f01200000f608ULL, 0x00000009000004b0ULL, 0x003f01200000f688ULL, 0x00000009000004d0ULL,
0x003f01200000f6a8ULL, 0x0000000900000540ULL, 0x003f01200000f6c8ULL, 0x000000ff00000920ULL,
0x003f01070000f600ULL, 0x0000000600000b10ULL, 0x003f010200000004ULL, 0x0000000600000bd0ULL,
0x003f010100000000ULL, 0x00000000000013e0ULL, 0x003f01070000f6a8ULL, 0x0000000000001530ULL,
0x003f01010000f6a8ULL, 0x0000000400001590ULL, 0x003f01010000f6c8ULL, 0x0000001900001740ULL,
0x003f01050000f6ccULL, 0x0000001900001920ULL, 0x003f01050000f6ccULL, 0x0000001a00002240ULL,
0x003f01070000f6b0ULL, 0x0000001a000022f0ULL, 0x003f01010000f6b0ULL, 0x0000000d00002350ULL,
0x003f01010000f608ULL, 0x0000000d00002370ULL, 0x003f01050000f60cULL, 0x0000000d00002540ULL,
0x003f01050000f60cULL, 0x0000003600002b70ULL, 0x003f01050000f6acULL, 0x0000003600002d40ULL,
0x003f01050000f6acULL, 0x00000010000047f0ULL, 0x003f010100000000ULL, 0x0000000c00004850ULL,
0x003f01010000f688ULL, 0x0000000400004880ULL, 0x003f010500000004ULL, 0x0000000400004a40ULL,
0x003f010500000004ULL, 0x0000000c00005270ULL, 0x003f01070000f6a8ULL, 0x0000000c00005340ULL,
0x003f01010000f6a8ULL, 0x0000000d000053a0ULL, 0x003f01010000f628ULL, 0x0000000d000053c0ULL,
0x003f01050000f62cULL, 0x0000000d00005590ULL, 0x003f01050000f62cULL, 0x0000003a00005b80ULL,
0x003f01050000f6b4ULL, 0x0000003a00005d50ULL, 0x003f01050000f6b4ULL, 0x00000018000075d0ULL,
0x003f010100000000ULL, 0x0000000c00007630ULL, 0x003f01010000f690ULL, 0x0000000400007660ULL,
0x003f010500000004ULL, 0x0000000400007820ULL, 0x003f010500000004ULL, 0x0000000c00008050ULL,
0x003f01070000f6b0ULL, 0x0000000c00008120ULL, 0x003f01010000f6b0ULL, 0x0000000d00008180ULL,
0x003f01010000f648ULL, 0x0000000d000081a0ULL, 0x003f01050000f64cULL, 0x0000000d00008370ULL,
0x003f01050000f64cULL, 0x0000003800008960ULL, 0x003f01050000f6acULL, 0x0000003800008b30ULL,
0x003f01050000f6acULL, 0x000000120000a3b0ULL, 0x003f010100000000ULL, 0x0000000f0000a410ULL,
0x003f01010000f698ULL, 0x000000040000a440ULL, 0x003f010500000004ULL, 0x000000040000a600ULL,
0x003f010500000004ULL, 0x0000000c0000aef0ULL, 0x003f01070000f6a8ULL, 0x0000000c0000af80ULL,
0x003f01010000f6a8ULL, 0x000000050000afe0ULL, 0x003f01010000f668ULL, 0x000000050000b010ULL,
0x003f01050000f66cULL, 0x000000050000b1e0ULL, 0x003f01050000f66cULL, 0x000000120000b7b0ULL,
0x003f01050000f6b4ULL, 0x000000120000b980ULL, 0x003f01050000f6b4ULL, 0x000000040000d300ULL,
0x003f010100000000ULL, 0x0000000e0000d380ULL, 0x003f010100000000ULL, 0x000000ff0000e510ULL,
0x003f01010000f600ULL, 0x000000ff0000f110ULL, 0x003f01050000f604ULL, 0x000000ff0000f2e0ULL,
0x003f01050000f604ULL, 0x000000ff0000f510ULL, 0x003f01010000f600ULL, 0x000000ff0000f540ULL,
0x003f01050000f604ULL, 0x000000ff0000f700ULL, 0x003f01050000f604ULL, 0x00000072000121d0ULL,
0x003f010100000000ULL, 0x0000007200012290ULL, 0x003f010500000004ULL, 0x0000007200012460ULL,
0x003f010500000004ULL, 0x0000007400014890ULL, 0x003f010100000000ULL, 0x00000074000148f0ULL,
0x003f010100000008ULL, 0x0000007400014950ULL, 0x003f010100000010ULL, 0x00000074000149c0ULL,
0x003f010100000018ULL, 0x00201c0400053803ULL, 0x0000de500000de20ULL, 0x0000e1a00000e040ULL,
0x0000e4300000e330ULL, 0x00014a000000f760ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000364ULL, 0x0000001b00000002ULL, 0x00000000000002a4ULL, 0x0000001b00000002ULL,
0x00000000000001ecULL, 0x0000001b00000002ULL, 0x0000000000000114ULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000341ULL, 0x0000001b00000002ULL,
0x000000000000027eULL, 0x0000001b00000002ULL, 0x00000000000001c3ULL, 0x0000001b00000002ULL,
0x00000000000000eeULL, 0x0000001b00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff6e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000767919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000e7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a006e7b7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x00000000000b7919ULL, 0x000f280000002100ULL,
0x00000000006f7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e026eULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007603747227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a74ULL, 0x0000000007007224ULL, 0x000fca00078e0276ULL,
0x000000070000720cULL, 0x000fda0003f66070ULL, 0x0000000100003824ULL, 0x000fe200078e0a07ULL,
0x0000000174743810ULL, 0x000fe20007ffe0ffULL, 0x000001000e027a24ULL, 0x008fe400078e0203ULL,
0x00001fff0e0e7589ULL, 0x000fe200000e0000ULL, 0x000000070000720cULL, 0x000fe20003f86070ULL,
0x0000000002097a24ULL, 0x110fe200078e020bULL, 0x00000005ff0b7819ULL, 0x000fc8000001160bULL,
0x000000ff0900720cULL, 0x040fe40003f45270ULL, 0x0000007f0900780cULL, 0x040fe20003f04070ULL,
0x00001fff0b0b7589ULL, 0x000e6200000e0000ULL, 0x0000000f0900780cULL, 0x040fe40003f24070ULL,
0x000000030900780cULL, 0x000fe40003f64070ULL, 0x0000000174744810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff74d212ULL, 0x000fc400078e33ffULL, 0x000000010900780cULL, 0x000fe20003f84070ULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fe400078e0a74ULL,
0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL, 0x0000000007767224ULL, 0x000fe400078e0276ULL,
0xff317217ff088424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00a388ULL, 0x0005e20000000a00ULL,
0x0000001076007824ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x00f4000809008388ULL, 0x0007e20000004800ULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x0000000400007c0cULL, 0x040fe2000bf03070ULL, 0x3fffff60ff06b424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL, 0x00f6080409009388ULL, 0x0009e20000008a00ULL,
0x3fffff80ff02b424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x0000000400087c10ULL, 0x008fe2000fffe1ffULL, 0x00f688060900b388ULL, 0x0005e60000008a00ULL,
0x0000001008087817ULL, 0x000fe20003800000ULL, 0x00f6a8020900b388ULL, 0x0003e60000008a00ULL,
0x000000ff08757207ULL, 0x000fe20000000000ULL, 0x3fffffc0ff04c424ULL, 0x010fe200078e00ffULL,
0x00005a0074087a19ULL, 0x000fe200000006ffULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x000000107500780cULL, 0x000fe20003f05270ULL, 0x000058006f067a24ULL, 0x004fc600078e02ffULL,
0x00f6c8040900c388ULL, 0x000fe20000008a00ULL, 0x000000040e027824ULL, 0x002fe400078e020bULL,
0x0000007b06067224ULL, 0x000fe400078e0208ULL, 0x0000000202027824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000497919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fc40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff077819ULL, 0x002fca0000011649ULL, 0x0000000102087824ULL, 0x000fc800078e0207ULL,
0x0000000100037824ULL, 0x000fca00078e0208ULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe40000011603ULL, 0x0000000275037217ULL, 0x000fe20007800000ULL,
0x0000000106057824ULL, 0x000fc800078e0205ULL, 0x0000007b04067224ULL, 0x000fe400078e0205ULL,
0x0000001049047824ULL, 0x000fe400078e00ffULL, 0x0000000103057824ULL, 0x000fe400078e0a02ULL,
0x0000010006027825ULL, 0x000fe200078e00ffULL, 0x000000f004097812ULL, 0x000fe400078ec0ffULL,
0x000000050700720cULL, 0x000fe20003f06070ULL, 0x0000000108057824ULL, 0x000fe200078e0249ULL,
0x0000000902097212ULL, 0x000fe200078efcffULL, 0x0000001008087824ULL, 0x000fc600078e00ffULL,
0x00005e0009027a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff008057812ULL, 0x000fe400078ee205ULL,
0x00005f0003037a10ULL, 0x000fc60000ffe4ffULL, 0x0000001005057824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000497919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000249057211ULL, 0x042fe200078fe0ffULL,
0x0000001049047824ULL, 0x000fc800078e00ffULL, 0x0000000100027824ULL, 0x000fe200078e0205ULL,
0x000000f004077812ULL, 0x000fc800078ec0ffULL, 0x0000000402037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fc60000011602ULL, 0x0000000106037824ULL, 0x000fe400078e0203ULL,
0x0000000105067824ULL, 0x040fe400078e0249ULL, 0x0000007b02027224ULL, 0x000fe400078e0203ULL,
0x0000001005057824ULL, 0x000fe400078e00ffULL, 0x0000010002027825ULL, 0x000fc600078e00ffULL,
0xfffffff005067812ULL, 0x000fe400078ee206ULL, 0x0000000702027212ULL, 0x000fc600078efcffULL,
0x0000001006057824ULL, 0x000fe200078e00ffULL, 0x00005e0002027a10ULL, 0x000fc80007f1e0ffULL,
0x00005f0003037a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e8000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000057806ULL, 0x000fe200038e0000ULL, 0x00000004ff0c7424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000500027300ULL, 0x000e7000000e0000ULL,
0x0000000500067309ULL, 0x000ea20000000000ULL, 0x000000030200720cULL, 0x002fe20003f02070ULL,
0x000066006f027625ULL, 0x000fc800078e000cULL, 0x000000ffff067224ULL, 0x004fd000078e0a06ULL,
0x00f60406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008020a7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0e00720cULL, 0x000fe40003f05270ULL, 0x0000003f0a097810ULL, 0x044fe40007ffe0ffULL,
0x000000ff0a0d7810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff097819ULL, 0x000fe40000011609ULL,
0x00000008ff087819ULL, 0x000fca000001160dULL, 0x0000d9e000008947ULL, 0x000fea0003800000ULL,
0x00000002ff727819ULL, 0x000fe2000001160bULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x0000f6880b067811ULL, 0x002fe200078e18ffULL, 0xffffffffff057424ULL, 0x000fe200078e00ffULL,
0x03ffffff72007812ULL, 0x000fc800078ec0ffULL, 0x000000090000720cULL, 0x000fda0003f06070ULL,
0x000000026f028824ULL, 0x000fe400078e00ffULL, 0x00006800ff038624ULL, 0x000fc800078e00ffULL,
0x0000680002038624ULL, 0x000fc800078e0203ULL, 0x0000000100038824ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040706ff738cULL, 0x0003e20000000000ULL,
0x0000640003028625ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000802058981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0d00780cULL, 0x000fe20003f04070ULL,
0x0000004074557824ULL, 0x000fe200078e00ffULL, 0x00000001ff547819ULL, 0x000fe2000001160bULL,
0x00000080ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000006ff7f8cULL, 0x0007e6000c80043fULL,
0x0000002054777824ULL, 0x000fca00078e00ffULL, 0x00000020550d7812ULL, 0x000fe200078ef877ULL,
0x0000590005057a24ULL, 0x004fc800078e02ffULL, 0x0000004005077824ULL, 0x002fe200078e00ffULL,
0x000000010b057812ULL, 0x000fc600078ec0ffULL, 0x0000620007027625ULL, 0x000fe200078e000eULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x000000770a067217ULL, 0x008fe20007800000ULL,
0x0000001005077824ULL, 0x000fe200078e00ffULL, 0x00000003ff0e7819ULL, 0x000fc60000011649ULL,
0x0000000106067824ULL, 0x000fe200078e0a77ULL, 0x000000040e117810ULL, 0x040fe20007ffe0ffULL,
0x0000000107107824ULL, 0x000fe200078e020eULL, 0x0000000c0e137810ULL, 0x000fe40007ffe0ffULL,
0x0000000706067217ULL, 0x000fe20007800000ULL, 0x00000001100f7824ULL, 0x040fe400078e0249ULL,
0x0000000810147824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fc400078e0a07ULL,
0x000000010d107824ULL, 0x000fe200078e0210ULL, 0xfffffff814147812ULL, 0x000fe200078ee20fULL,
0x0000000107167824ULL, 0x040fe200078e0213ULL, 0x000000080e0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000060e00720cULL, 0x080fe20003f66070ULL, 0x00000001070e7824ULL, 0x000fe200078e0211ULL,
0x000000061100720cULL, 0x080fe20003f46070ULL, 0x0000000107127824ULL, 0x000fe200078e020fULL,
0x000000060f00720cULL, 0x080fe20003f26070ULL, 0x000000010d0f7824ULL, 0x000fe200078e020eULL,
0x000000061300720cULL, 0x000fe20003f06070ULL, 0x0000008010067825ULL, 0x000fc800078e00ffULL,
0x000000010e107824ULL, 0x100fe200078e0249ULL, 0x0000007006137812ULL, 0x000fe200078ef804ULL,
0x000000080e157824ULL, 0x000fe400078e00ffULL, 0x000000010d0e7824ULL, 0x040fe400078e0212ULL,
0x000000010d117824ULL, 0x000fe400078e0216ULL, 0x00000001120d7824ULL, 0x140fe400078e0249ULL,
0x0000000812187824ULL, 0x000fe200078e00ffULL, 0x0000001302127210ULL, 0x000fe20007f9e0ffULL,
0x0000000116067824ULL, 0x000fc400078e0249ULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0xfffffff815167812ULL, 0x000fe200078ee210ULL, 0x0000000103137824ULL, 0x000fe200020e0607ULL,
0xfffffff818187812ULL, 0x000fe200078ee20dULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0xfffffff8171a7812ULL, 0x000fe400078ee206ULL, 0x0000b000540d7811ULL, 0x000fe200078e68ffULL,
0x000000800f067825ULL, 0x000fe200078e00ffULL, 0x00000070101b7812ULL, 0x000fc600078ef804ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000070061f7812ULL, 0x000fc600078ef804ULL,
0x0000001014157824ULL, 0x100fe200078e020dULL, 0x000000700e1d7812ULL, 0x000fe200078ef804ULL,
0x0000001016177824ULL, 0x100fe200078e020dULL, 0x0000001f02067210ULL, 0x000fe20007f9e0ffULL,
0x0000001018197824ULL, 0x100fe200078e020dULL, 0x0000001d020e7210ULL, 0x000fe20007fbe0ffULL,
0x000000101a0d7824ULL, 0x000fe200078e020dULL, 0x0000001b02027210ULL, 0x000fe20007fde0ffULL,
0x0000000103077824ULL, 0x040fe200020e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000d901c48ULL, 0x00000001030f7824ULL, 0x000fc400028e060fULL,
0x0000000103037824ULL, 0x000fe200030e0611ULL, 0x0000000006177faeULL, 0x0003e8000d101c48ULL,
0x000000000e197faeULL, 0x0003e8000c901c48ULL, 0x00000000020d7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001005067824ULL, 0x008fe200078e00ffULL,
0x0000b000541f7811ULL, 0x000fc800078e68ffULL, 0x0000000649067211ULL, 0x000fc800078fe8ffULL,
0x0000000406107810ULL, 0x040fe20007ffe0ffULL, 0x000000010d077824ULL, 0x000fe200078e0206ULL,
0x0000000806127810ULL, 0x040fe20007ffe0ffULL, 0x00000001060e7824ULL, 0x040fe200078e0249ULL,
0x0000000c06167810ULL, 0x040fe20007ffe0ffULL, 0x00000008060f7824ULL, 0x000fe400078e00ffULL,
0x0000008007067825ULL, 0x000fc600078e00ffULL, 0xfffffff80f147812ULL, 0x000fe200078ee20eULL,
0x000000010d0e7824ULL, 0x040fe200078e0210ULL, 0x0000007006137812ULL, 0x000fe200078ef804ULL,
0x00000001100f7824ULL, 0x040fe400078e0249ULL, 0x0000000810187824ULL, 0x000fe400078e00ffULL,
0x000000010d107824ULL, 0x040fe400078e0212ULL, 0x000000010d117824ULL, 0x000fe200078e0216ULL,
0xfffffff818157812ULL, 0x000fe200078ee20fULL, 0x00000001120d7824ULL, 0x000fc400078e0249ULL,
0x00000008121a7824ULL, 0x000fe200078e00ffULL, 0x0000001302127210ULL, 0x000fe20007f1e0ffULL,
0x0000000116067824ULL, 0x040fe400078e0249ULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0xfffffff81a167812ULL, 0x000fe200078ee20dULL, 0x0000000103137824ULL, 0x000fe400000e0607ULL,
0x00000010140d7824ULL, 0x000fe200078e021fULL, 0xfffffff817187812ULL, 0x000fe200078ee206ULL,
0x000000800e067825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120d7faeULL, 0x0003e2000b901c48ULL, 0x00000080100e7825ULL, 0x000fe200078e00ffULL,
0x00000070061d7812ULL, 0x000fc600078ef804ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x000000700e1b7812ULL, 0x100fe400078ef804ULL, 0x0000001d02067210ULL, 0x000fe20007f1e0ffULL,
0x0000001015157824ULL, 0x100fe200078e021fULL, 0x0000007010197812ULL, 0x000fe200078ef804ULL,
0x0000001016177824ULL, 0x000fe200078e021fULL, 0x0000001b020e7210ULL, 0x040fe20007f3e0ffULL,
0x0000000103077824ULL, 0x000fe200000e0607ULL, 0x0000001902027210ULL, 0x000fe20007f5e0ffULL,
0x0000001018197824ULL, 0x000fc400078e021fULL, 0x00000001030f7824ULL, 0x040fe200008e060fULL,
0x0000000006157faeULL, 0x0003e2000b901c48ULL, 0x0000000103037824ULL, 0x000fc600010e0611ULL,
0x000000000e177faeULL, 0x0003e8000b901c48ULL, 0x0000000002197faeULL, 0x0003e4000b901c48ULL,
0x0000000100077810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff067424ULL, 0x000fc600078e00ffULL,
0x000000090700720cULL, 0x000fda0003f06070ULL, 0x000000026f008824ULL, 0x000fe400078e00ffULL,
0x00006800ff038624ULL, 0x000fc800078e00ffULL, 0x0000680000008624ULL, 0x000fc800078e0203ULL,
0x00000001000d8824ULL, 0x000fe400078e0207ULL, 0x0000001054007824ULL, 0x000fe400078e00ffULL,
0x000064000d0c8625ULL, 0x000fe400078e000cULL, 0x00000000000473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000080c068981ULL, 0x000522000c1e1900ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x0000000854047824ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6a80000027f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6c800040c7f8cULL, 0x000662000c80043fULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000bd8000008947ULL, 0x000fea0003800000ULL,
0x00000010000f7812ULL, 0x008fe200078ec0ffULL, 0x000000026f567824ULL, 0x000fc400078e00ffULL,
0x00006800ff197624ULL, 0x000fe400078e00ffULL, 0x0000002072007824ULL, 0x002fe400078e020fULL,
0x000000ffff3c7224ULL, 0x004fe400078e0003ULL, 0x000000ffff187224ULL, 0x000fe400078e000dULL,
0x0000680056567624ULL, 0x000fe400078e0219ULL, 0x0000000805057824ULL, 0x000fc400078e0200ULL,
0xff317217ff3e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff487224ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fc400078e00ffULL, 0x000000ffff717224ULL, 0x00afca00078e0007ULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x000000040b047824ULL, 0x000fca00078e00ffULL,
0xfffffff804197812ULL, 0x000fc800078ec0ffULL, 0x0000f6c819047810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc00190f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804818ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c1b7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x0000001b0e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc00190f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100b0e7824ULL, 0x000fe200078e00ffULL, 0x00000001480f7810ULL, 0x000fe20007ffe0ffULL,
0x0000590006067a24ULL, 0x010fc600078e02ffULL, 0xffffffe00e0d7812ULL, 0x000fe200078ec0ffULL,
0x00000040060c7824ULL, 0x000fe200078e00ffULL, 0x000000080f00720cULL, 0x000fc60003f26070ULL,
0x00000100480d7824ULL, 0x000fca00078e020dULL, 0x000000400d197810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fc600078e00ffULL, 0x0000002019067812ULL, 0x000fe200078ec0ffULL,
0x000062000c0c7625ULL, 0x000fc800078e000dULL, 0x0000000155357824ULL, 0x000fe200078e0206ULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x000000190a067217ULL, 0x000fe40007800000ULL,
0x000000100e0f7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff1a7819ULL, 0x000fe20000011649ULL,
0x0000000106067824ULL, 0x000fc600078e0a19ULL, 0x000000041a197810ULL, 0x040fe20007ffe0ffULL,
0x000000011a0e7824ULL, 0x000fe200078e020fULL, 0x0000000f06067217ULL, 0x000fe40007800000ULL,
0x000000081a347810ULL, 0x000fe20007ffe0ffULL, 0x000000010e187824ULL, 0x000fe200078e0249ULL,
0x0000000c1a377810ULL, 0x000fe20007ffe0ffULL, 0x000000080e1b7824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x100fe400078e0a0fULL, 0x0000000137387824ULL, 0x100fe200078e020fULL,
0xfffffff81b367812ULL, 0x000fe200078ee218ULL, 0x0000000119187824ULL, 0x040fe200078e020fULL,
0x000000061900720cULL, 0x080fe20003f66070ULL, 0x00000010491b7824ULL, 0x000fe200078e00ffULL,
0x000000061a00720cULL, 0x080fe20003f86070ULL, 0x0000000118197824ULL, 0x000fe200078e0249ULL,
0x000000063400720cULL, 0x080fe20003f46070ULL, 0x00000008183a7824ULL, 0x000fe200078e00ffULL,
0x000000063700720cULL, 0x000fe20003f06070ULL, 0x00000001341a7824ULL, 0x000fe200078e020fULL,
0x000000701b3f7812ULL, 0x000fe200078ec0ffULL, 0x00000001350e7824ULL, 0x040fe200078e020eULL,
0xfffffff83a067812ULL, 0x000fe200078ee219ULL, 0x0000000135187824ULL, 0x000fc400078e0218ULL,
0x00000001351b7824ULL, 0x000fe400078e021aULL, 0x000000011a347824ULL, 0x040fe400078e0249ULL,
0x000000081a377824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x00000001381a7824ULL, 0x000fe200078e0249ULL, 0x0000003f0e397212ULL, 0x000fe200078efcffULL,
0x00000008383b7824ULL, 0x000fe400078e00ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000390c0e7210ULL, 0x000fe40007fbe0ffULL, 0xfffffff83b3a7812ULL, 0x000fe200078ee21aULL,
0x0000000135357824ULL, 0x000fe200078e0238ULL, 0xfffffff837387812ULL, 0x000fe200078ee234ULL,
0x000000801b1a7825ULL, 0x000fe200078e00ffULL, 0x0000003f18377212ULL, 0x000fc600078efcffULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x000000370c187210ULL, 0x000fe40007fde0ffULL,
0x0000003f1a417212ULL, 0x080fe200078efcffULL, 0x000000010d0f7824ULL, 0x040fe200028e060fULL,
0x0000003f343f7212ULL, 0x000fe200078efcffULL, 0x000000010d197824ULL, 0x000fe200030e0619ULL,
0x0000c00054377811ULL, 0x000fe400078e68ffULL, 0x000000410c1a7210ULL, 0x040fe40007fbe0ffULL,
0x0000003f0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001036397824ULL, 0x000fc400078e0237ULL,
0x00000010063b7824ULL, 0x100fe400078e0237ULL, 0x00000010383f7824ULL, 0x000fe200078e0237ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e397faeULL, 0x0003e2000e101c48ULL,
0x000000010d1b7824ULL, 0x040fe400028e061bULL, 0x000000103a377824ULL, 0x000fe200078e0237ULL,
0x00000000183b7faeULL, 0x0003e2000d901c48ULL, 0x000000010d0d7824ULL, 0x000fc600030e0635ULL,
0x000000001a3f7faeULL, 0x0003e8000d101c48ULL, 0x000000000c377faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000100e067812ULL, 0x000fe200078ec0ffULL,
0x00000010490e7824ULL, 0x040fe200078e00ffULL, 0x0000c00054457811ULL, 0x000fe400078e68ffULL,
0x0000000649067211ULL, 0x000fe400078fe8ffULL, 0x000000700e3f7812ULL, 0x000fc400078ec0ffULL,
0x0000000406187810ULL, 0x040fe20007ffe0ffULL, 0x00000001060f7824ULL, 0x040fe200078e0249ULL,
0x00000008061a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000806367824ULL, 0x040fe200078e00ffULL,
0x0000000c06347810ULL, 0x000fe20007ffe0ffULL, 0x00000001350e7824ULL, 0x040fe400078e0206ULL,
0x0000000135197824ULL, 0x000fe200078e0218ULL, 0xfffffff836367812ULL, 0x000fe200078ee20fULL,
0x0000000118067824ULL, 0x040fe400078e0249ULL, 0x0000000818397824ULL, 0x000fc400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff839067812ULL, 0x000fe200078ee206ULL,
0x00000001351b7824ULL, 0x000fe200078e021aULL, 0x0000003f0e377212ULL, 0x000fe200078efcffULL,
0x000000011a187824ULL, 0x140fe400078e0249ULL, 0x000000081a3b7824ULL, 0x000fe200078e00ffULL,
0x000000370c0e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001341a7824ULL, 0x040fe400078e0249ULL,
0x0000000834417824ULL, 0x000fe200078e00ffULL, 0xfffffff83b387812ULL, 0x000fe200078ee218ULL,
0x0000000135357824ULL, 0x000fc400078e0234ULL, 0x0000008019187825ULL, 0x000fe200078e00ffULL,
0xfffffff8413a7812ULL, 0x000fc600078ee21aULL, 0x000000801b1a7825ULL, 0x000fe200078e00ffULL,
0x0000003f18437212ULL, 0x000fc600078efcffULL, 0x0000008035347825ULL, 0x000fe200078e00ffULL,
0x0000003f1a417212ULL, 0x000fc600078efcffULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x0000003f343f7212ULL, 0x000fe200078efcffULL, 0x0000001036377824ULL, 0x100fe200078e0245ULL,
0x000000430c187210ULL, 0x000fe20007f1e0ffULL, 0x0000001006397824ULL, 0x100fe200078e0245ULL,
0x000000410c1a7210ULL, 0x000fe20007f5e0ffULL, 0x00000010383b7824ULL, 0x000fe200078e0245ULL,
0x0000003f0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d197824ULL, 0x040fe200000e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e377faeULL, 0x0003e2000b901c48ULL,
0x000000010d1b7824ULL, 0x000fc400010e061bULL, 0x000000103a3f7824ULL, 0x000fe200078e0245ULL,
0x0000000018397faeULL, 0x0003e2000b901c48ULL, 0x000000010d0d7824ULL, 0x000fc600018e0635ULL,
0x000000001a3b7faeULL, 0x0003e8000b901c48ULL, 0x000000000c3f7faeULL, 0x0003e4000b901c48ULL,
0x000000080b067824ULL, 0x000fe200078e00ffULL, 0x0000000107187810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff0f7424ULL, 0x000fc600078e00ffULL, 0xfffffff0061a7812ULL, 0x000fe400078ec0ffULL,
0x000000091800720cULL, 0x000fe40003f06070ULL, 0x000000001a0473c2ULL, 0x000e6200000e0000ULL,
0xffffffe0060d7812ULL, 0x040fe400078ec0ffULL, 0x00000010060c7812ULL, 0x040fe400078ec0ffULL,
0x0000000806067812ULL, 0x000fcc00078ec0ffULL, 0x0000000156188824ULL, 0x000fe400078e0218ULL,
0x00000004ff198424ULL, 0x000fe200078e00ffULL, 0x0000000d060d7210ULL, 0x000fe40007ffe00cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000640018188625ULL, 0x000fca00078e0019ULL,
0x00000008180f8981ULL, 0x000522000c1e1900ULL, 0x0000f6b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6b0001a1a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f608000d367f8cULL, 0x0004e4000c80043fULL,
0x0000000000187805ULL, 0x000fc40000015200ULL, 0x00f60c000d357984ULL, 0x000ea40000000800ULL,
0x8000000035ff7812ULL, 0x00cfe40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003418397210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e19ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011435ULL, 0x0000003906067211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000206067819ULL, 0x000fc80000001235ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c000d357984ULL, 0x000ea40000000800ULL, 0x8000000035ff7812ULL, 0x004fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001049517824ULL, 0x000fe200078e00ffULL,
0x00000001ff737819ULL, 0x000fe20000011649ULL, 0x000000200b067824ULL, 0x000fe400078e00ffULL,
0xffffffffff787424ULL, 0x000fe200078e00ffULL, 0x0000007051517812ULL, 0x000fc400078ec0ffULL,
0xffffff8006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c73737812ULL, 0x000fc800078ec0ffULL,
0x0000000673067210ULL, 0x000fca0007ffe051ULL, 0x00f0000006357984ULL, 0x000ea80000000800ULL,
0x00f20000060e7984ULL, 0x0006620000000800ULL, 0x0000003e3500720bULL, 0x004fe20003f1d000ULL,
0x000123c27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c377812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fc400078e003eULL,
0x0000001fff7a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff797424ULL, 0x000fca00078e00ffULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x0000000b7200720cULL, 0x000fe40003f05270ULL,
0x0000003e3500720bULL, 0x000fe20003f54000ULL, 0x000123527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000067806ULL, 0x000fc400010e0100ULL, 0x000000800b0c8824ULL, 0x000fe200078e0251ULL,
0x0000003e35197209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991006187816ULL, 0x000fe200000000ffULL, 0x00000001730c8824ULL, 0x000fca00078e020cULL,
0x00f400190c008388ULL, 0x0005e20000000800ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000193e0c7221ULL, 0x004fe20000010000ULL,
0x000000ff06ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00397308ULL, 0x000ea40000000800ULL,
0x000000393d3d7220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011649ULL, 0x000122827f007947ULL, 0x000fea000b800000ULL,
0x00001f0c390c7589ULL, 0x0004e400000e0000ULL, 0x0000000c2c2c7220ULL, 0x08cfe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c14147220ULL, 0x080fe20000410000ULL,
0x0000000c15157220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0006ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008490c7811ULL, 0x000fe200078ff0ffULL, 0x000121627f007947ULL, 0x000fea000b800000ULL,
0x00001f0c390c7589ULL, 0x0004e400000e0000ULL, 0x0000000c2e2e7220ULL, 0x08cfe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c16167220ULL, 0x080fe20000410000ULL,
0x0000000c17177220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff37ff7812ULL, 0x000fe20007806006ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000003e35067209ULL, 0x000fd60007810000ULL, 0x8000000635350221ULL, 0x000fe20000010000ULL,
0x00007610ff0c0816ULL, 0x000fc6000000000cULL, 0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL,
0x0000003500030308ULL, 0x000ea40000000800ULL, 0x000000030e0e0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003d0e0e7221ULL, 0x002fc20000010000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x000000080b347824ULL, 0x000fca00078e00ffULL,
0xfffffff034367812ULL, 0x000fca00078ec0ffULL, 0x00f6ac0036357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003418377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e19ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0036357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100c0c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff347819ULL, 0x000fe40000011649ULL, 0x0000541000357816ULL, 0x000fe20000000000ULL,
0x00011d127f007947ULL, 0x000fea000b800000ULL, 0x00001f3435027589ULL, 0x0002a400000e0000ULL,
0x00000008340c7810ULL, 0x000fe20007ffe0ffULL, 0x00011d427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c35007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010340c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0035ULL,
0x00002ea000197802ULL, 0x000fc40000000f00ULL, 0x0001271000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018340c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e0035ULL, 0x00002ef000197802ULL, 0x000fc40000000f00ULL,
0x000126c000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000020b0c7824ULL, 0x00cfe200078e00ffULL, 0x0000000749197812ULL, 0x000fe200078ec0ffULL,
0x000002000b447824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000040c187812ULL, 0x000fc400078ec0ffULL, 0x0000000819387812ULL, 0x000fe400078ef849ULL,
0x0000001849357211ULL, 0x042fe400078fe0ffULL, 0xfffff80044447812ULL, 0x000fe200078ec0ffULL,
0x0000000838597824ULL, 0x040fe200078e00ffULL, 0x0000000849187812ULL, 0x000fe200078ec0ffULL,
0x0000000138587824ULL, 0x000fca00078e0235ULL, 0xfffffff859597812ULL, 0x000fca00078ee258ULL,
0x0000001059597824ULL, 0x000fc800078e00ffULL, 0x00000001594b7824ULL, 0x000fc400078e0244ULL,
0x000000040b357824ULL, 0x000fe200078e00ffULL, 0x00000004ff367819ULL, 0x000fe20000011649ULL,
0x00000008383b7824ULL, 0x000fe200078e00ffULL, 0x0000001918347212ULL, 0x000fe400078efcffULL,
0x0000000435357812ULL, 0x000fe400078ec0ffULL, 0x0000b00054577811ULL, 0x000fe200078e68ffULL,
0x00000008344a7824ULL, 0x000fe200078e00ffULL, 0x0000001018407812ULL, 0x000fe200078efe19ULL,
0x0000000136397824ULL, 0x000fe200078e0235ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000834377824ULL, 0x000fc400078e00ffULL, 0x0000000134357824ULL, 0x000fe400078e0239ULL,
0x0000000139417824ULL, 0x000fe400078e0240ULL, 0x0000000840427824ULL, 0x000fe200078e00ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee235ULL, 0x0000000840467824ULL, 0x000fe200078e00ffULL,
0x00000002354e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000454357824ULL, 0x000fe200078e0236ULL,
0xfffffff8424d7812ULL, 0x000fe200078ee241ULL, 0x000000104a3c7824ULL, 0x000fe200078e0257ULL,
0xfffffff8374e7812ULL, 0x000fc400078ee24eULL, 0x00000002354c7810ULL, 0x000fe40007ffe038ULL,
0x00000002414f7810ULL, 0x000fe20007ffe0ffULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x000000104e347824ULL, 0x000fe200078e0257ULL, 0xfffffff83b4c7812ULL, 0x000fe400078ee24cULL,
0x009000004b38783bULL, 0x000ea20000000200ULL, 0xfffffff8464f7812ULL, 0x000fe400078ee24fULL,
0x000000104c4c7824ULL, 0x000fe200078e0244ULL, 0x000000003434783bULL, 0x000ee20000004200ULL,
0x00000018ff187819ULL, 0x002fc4000001163eULL, 0x0000ffff3e407812ULL, 0x000fe400078ec0ffULL,
0x00000018ff19723eULL, 0x000fe200020006ffULL, 0x0000000238388231ULL, 0x084fe200003400ffULL,
0x00000018ff187819ULL, 0x000fe2000001163fULL, 0x000000023a3a8231ULL, 0x000fe200003400ffULL,
0x0000ffff3f427812ULL, 0x000fe200078ec0ffULL, 0x20000019ff457230ULL, 0x000fe20000004100ULL,
0x00000018ff41723eULL, 0x000fe200020006ffULL, 0x0000000039398231ULL, 0x080fe200003400ffULL,
0x00000008ff187819ULL, 0x000fe20000011640ULL, 0x000000003b3b8231ULL, 0x000fe200003400ffULL,
0x00000008ff407819ULL, 0x000fe20000011642ULL, 0x20000041ff477230ULL, 0x000fe20000004100ULL,
0x00000018ff18723eULL, 0x000fc400020006ffULL, 0x00000040ff42723eULL, 0x000fe400020006ffULL,
0x00000010ff457819ULL, 0x000fe20000011645ULL, 0x20000018ff197230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x000fe2000001163eULL, 0x20000042ff467230ULL, 0x000fe20000004100ULL,
0x000000ff3e427812ULL, 0x000fe400078ec0ffULL, 0x000000ff18537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff187819ULL, 0x000fc40000011619ULL, 0x00000010ff3e7819ULL, 0x000fe40000011647ULL,
0x00000010ff197819ULL, 0x000fe40000011646ULL, 0x00000010ff437819ULL, 0x000fe4000001163fULL,
0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x0000105445187816ULL, 0x000fe40000000018ULL,
0x000010543e197816ULL, 0x000fc40000000019ULL, 0x000000ff435c7812ULL, 0x000fe400078ec0ffULL,
0x0000003fff43723eULL, 0x000fe400020006ffULL, 0x000000ff3c417812ULL, 0x000fe200078ec0ffULL,
0x000000183810723cULL, 0x000be20000041810ULL, 0x000000ff343f7812ULL, 0x008fe200078ec0ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x000000ff35507812ULL, 0x000fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x0000003fff47723eULL, 0x000fe400020006ffULL,
0x00000010ff197819ULL, 0x020fe4000001163cULL, 0x00000050ff3f723eULL, 0x000fe400020006ffULL,
0x00000010ff5b7819ULL, 0x000fe4000001163dULL, 0x000000ff195a7812ULL, 0x000fe200078ec0ffULL,
0x20000041ff197230ULL, 0x000fe20000004100ULL, 0x000000ff3d407812ULL, 0x000fe200078ec0ffULL,
0x2000003fff417230ULL, 0x000fe20000004100ULL, 0x000000ff5b5b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff527819ULL, 0x100fe40000011634ULL, 0x00000010ff3f7819ULL, 0x000fe40000011634ULL,
0x0000ffff34347812ULL, 0x000fe400078ec0ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x2000005aff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff347819ULL, 0x000fe20000011634ULL,
0x20000040ff5d7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x2000005bff5f7230ULL, 0x000fe20000004100ULL, 0x0000ffff3c3e7812ULL, 0x000fe200078ec0ffULL,
0x20000047ff407230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x20000052ff477230ULL, 0x000fe20000004100ULL, 0x00000018ff187819ULL, 0x000fc4000001163cULL,
0x00000018ff3c7819ULL, 0x000fe2000001163dULL, 0x20000034ff527230ULL, 0x000fe20000004100ULL,
0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff197819ULL, 0x000fe40000011619ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000008ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000010ff607819ULL, 0x000fe4000001165fULL,
0x00000018ff34723eULL, 0x000fe400020006ffULL, 0x000010545e187816ULL, 0x000fe40000000019ULL,
0x00000008ff3d7819ULL, 0x000fe2000001163dULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000105460197816ULL, 0x000fc4000000005dULL,
0x00000018ff507819ULL, 0x100fe20000011635ULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe40000011635ULL, 0x0000003cff3c723eULL, 0x000fe200020006ffULL,
0x00000018382c723cULL, 0x000b62000004182cULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x000000ff3f3f7812ULL, 0x000fe200078ec0ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000ffff35357812ULL, 0x000fe200078ec0ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000008ff357819ULL, 0x000fe20000011635ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff197819ULL, 0x020fe20000011634ULL, 0x2000003fff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe2000001163eULL, 0x000000104d3f7824ULL, 0x000fe200078e0257ULL,
0x00000010ff187819ULL, 0x000fe40000011636ULL, 0x00000035ff5d723eULL, 0x000fc400020006ffULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff357819ULL, 0x000fe2000001163dULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000105419347816ULL, 0x000fe40000000034ULL,
0x000000ff185e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff187819ULL, 0x000fe40000011642ULL,
0x00000010ff197819ULL, 0x000fc40000011653ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff427819ULL, 0x000fe40000011637ULL,
0x000010543c357816ULL, 0x000fe40000000035ULL, 0x0000105419187816ULL, 0x000fe20000000018ULL,
0x000000003f3c783bULL, 0x000e620000004200ULL, 0x000010545c197816ULL, 0x000fe20000000043ULL,
0x000000104f437824ULL, 0x000fe200078e0257ULL, 0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL,
0x000000343828723cULL, 0x000b620000041828ULL, 0x000000ff42427812ULL, 0x000fc400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000042ff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff347819ULL, 0x020fe20000011640ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe20000011641ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x000000004340783bULL, 0x000ea20000004200ULL, 0x000000ff36457812ULL, 0x000fe200078ec0ffULL,
0x000000183814723cULL, 0x000b620000041814ULL, 0x000000ff37467812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x0000005eff53723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x000010545b347816ULL, 0x000fe20000000034ULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000010545a357816ULL, 0x000fe20000000035ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fc400020006ffULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x000000343830723cULL, 0x000be20000041830ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff187819ULL, 0x020fe40000011652ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff347819ULL, 0x000fc40000011645ULL, 0x00000010ff357819ULL, 0x000fe40000011646ULL,
0x0000105453347816ULL, 0x000fe40000000034ULL, 0x000010545c357816ULL, 0x000fe40000000035ULL,
0x00000010ff197819ULL, 0x000fe4000001165dULL, 0x0000105447187816ULL, 0x000fe40000000018ULL,
0x0000105450197816ULL, 0x000fe20000000019ULL, 0x000000343820723cULL, 0x000be20000041820ULL,
0x000000ff3c627812ULL, 0x002fc400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe4000001163cULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000018ff347819ULL, 0x020fe20000011636ULL,
0x000000183824723cULL, 0x000b620000041824ULL, 0x0000ffff36367812ULL, 0x000fe400078ec0ffULL,
0x00000018ff357819ULL, 0x000fe40000011637ULL, 0x00000008ff367819ULL, 0x000fc40000011636ULL,
0x00000010ff187819ULL, 0x020fe4000001163cULL, 0x0000ffff3c467812ULL, 0x000fe400078ec0ffULL,
0x00000010ff197819ULL, 0x100fe4000001163dULL, 0x000000ff3d5e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe4000001163dULL, 0x0000ffff3d637812ULL, 0x000fc400078ec0ffULL,
0x0000ffff37377812ULL, 0x000fe400078ec0ffULL, 0x000000ff3f607812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3c7819ULL, 0x104fe40000011640ULL, 0x000000ff40687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011640ULL, 0x0000ffff403d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff657819ULL, 0x100fe4000001163eULL, 0x000000ff3e507812ULL, 0x040fe400078ec0ffULL,
0x00000018ff477819ULL, 0x000fe4000001163eULL, 0x0000ffff3e5c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x000fe40000011641ULL, 0x000000ff41697812ULL, 0x000fc400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x0000ffff415a7812ULL, 0x000fe400078ec0ffULL,
0x00000034ff34723eULL, 0x000fe400020006ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe20000011642ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x000000ff42417812ULL, 0x000fc400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fe40000011642ULL,
0x0000ffff42457812ULL, 0x000fe200078ec0ffULL, 0x20000062ff427230ULL, 0x000fe20000004100ULL,
0x0000005eff6a723eULL, 0x000fe200020006ffULL, 0x20000061ff5e7230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000008ff377819ULL, 0x000fe20000011637ULL,
0x2000006aff617230ULL, 0x000fe20000004100ULL, 0x00000060ff62723eULL, 0x000fe200020006ffULL,
0x20000052ff607230ULL, 0x000fe20000004100ULL, 0x00000018ff5f7819ULL, 0x000fc4000001163fULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x20000062ff527230ULL, 0x000fe20000004100ULL,
0x000000ff18187812ULL, 0x000fe400078ec0ffULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x0000005fff6a723eULL, 0x000fe200020006ffULL, 0x20000035ff5f7230ULL, 0x000fe20000004100ULL,
0x00000018ff62723eULL, 0x000fe200020006ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc40000011634ULL, 0x00000010ff187819ULL, 0x000fe20000011636ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe4000001165fULL,
0x0000105435187816ULL, 0x000fe40000000018ULL, 0x000000ff19357812ULL, 0x000fe400078ec0ffULL,
0x00000010ff197819ULL, 0x000fe40000011637ULL, 0x00000008ff467819ULL, 0x000fc40000011646ULL,
0x0000105434197816ULL, 0x000fe40000000019ULL, 0x00000046ff36723eULL, 0x000fe200020006ffULL,
0x2000006aff467230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fe20000011663ULL, 0x20000036ff5f7230ULL, 0x000fe20000004100ULL,
0x000000183838723cULL, 0x000b62000004181cULL, 0x20000035ff637230ULL, 0x000fe20000004100ULL,
0x00000034ff6a723eULL, 0x000fc400020006ffULL, 0x009000004c34783bULL, 0x000e620000000200ULL,
0x00000010ff667819ULL, 0x000fe4000001163fULL, 0x0000005dff18723eULL, 0x020fe200020006ffULL,
0x2000006aff1c7230ULL, 0x000fe20000004100ULL, 0x00000040ff19723eULL, 0x000fe400020006ffULL,
0x0000ffff3f3f7812ULL, 0x000fe200078ec0ffULL, 0x20000018ff407230ULL, 0x000fe20000004100ULL,
0x00000041ff18723eULL, 0x000fe200020006ffULL, 0x20000019ff417230ULL, 0x000fe20000004100ULL,
0x00000018ff647819ULL, 0x000fc40000011643ULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x0000003eff19723eULL, 0x000fe200020006ffULL, 0x20000018ff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000003cff18723eULL, 0x000fe200020006ffULL,
0x20000019ff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff43677812ULL, 0x000fe200078ec0ffULL,
0x2000003fff5d7230ULL, 0x000fe20000004100ULL, 0x00000008ff197819ULL, 0x000fe2000001163dULL,
0x20000064ff3d7230ULL, 0x000fe20000004100ULL, 0x000000ff531d7812ULL, 0x000fe200078ec0ffULL,
0x20000018ff537230ULL, 0x000fe20000004100ULL, 0x000000ff65657812ULL, 0x000fc400078ec0ffULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x00000067ff3f723eULL, 0x000fe400020006ffULL,
0x00000019ff64723eULL, 0x000fe400020006ffULL, 0x0000001dff67723eULL, 0x000fe200020006ffULL,
0x0000000234348231ULL, 0x082fe200003400ffULL, 0x00000010ff187819ULL, 0x000fe20000011642ULL,
0x0000000236368231ULL, 0x000fe200003400ffULL, 0x00000010ff197819ULL, 0x000fe20000011662ULL,
0x0000000035358231ULL, 0x080fe200003400ffULL, 0x00000010ff1d7819ULL, 0x000fe20000011661ULL,
0x0000000037378231ULL, 0x000fe200003400ffULL, 0x00000010ff627819ULL, 0x000fe20000011663ULL,
0x20000067ff617230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x20000064ff427230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x0000105419187816ULL, 0x000fe20000000018ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000105462197816ULL, 0x000fe2000000001dULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff5c7819ULL, 0x000fc4000001165cULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x00000018342c723cULL, 0x000b62000004182cULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff1d7819ULL, 0x000fe4000001161cULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x000010545e1c7816ULL, 0x000fe2000000005fULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00001054601d7816ULL, 0x000fe2000000001dULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x020fe40000011650ULL,
0x00000010ff197819ULL, 0x000fe40000011652ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x0000001c3428723cULL, 0x000b620000041828ULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000068ff1e723eULL, 0x000fe400020006ffULL, 0x00000069ff1f723eULL, 0x000fe400020006ffULL,
0x0000105465187816ULL, 0x000fe20000000018ULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x0000105466197816ULL, 0x000fe20000000019ULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x000000183414723cULL, 0x000b640000041814ULL,
0x00000010ff1c7819ULL, 0x020fe4000001165cULL, 0x00000010ff1d7819ULL, 0x000fe4000001165dULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00001054471c7816ULL, 0x000fe4000000001cULL,
0x00001054461d7816ULL, 0x000fe2000000001dULL, 0x2000005aff527230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x000fc4000001161eULL, 0x00000010ff447819ULL, 0x000fe40000011643ULL,
0x00000010ff197819ULL, 0x000fe4000001161fULL, 0x00000010ff1e7819ULL, 0x000fe40000011661ULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff44447812ULL, 0x000fc400078ec0ffULL, 0x000010541e197816ULL, 0x000fe40000000019ULL,
0x00000008ff457819ULL, 0x000fe20000011645ULL, 0x0000001c341c723cULL, 0x000b620000041810ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff117819ULL, 0x020fc40000011640ULL,
0x00000010ff107819ULL, 0x000fe40000011642ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000044ff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff537819ULL, 0x000fe20000011653ULL,
0x2000005bff507230ULL, 0x000fe20000004100ULL, 0x00000045ff44723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000043ff43723eULL, 0x000fc400020006ffULL,
0x0000105411107816ULL, 0x000fe20000000010ULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x0000105441117816ULL, 0x000fe20000000052ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000105453187816ULL, 0x000fe40000000018ULL, 0x00000010ff127819ULL, 0x000fe4000001163eULL,
0x00000010ff137819ULL, 0x000fe20000011650ULL, 0x000000103424723cULL, 0x000b620000041824ULL,
0x00000010ff3f7819ULL, 0x000fc4000001163fULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff117819ULL, 0x020fe2000001163cULL,
0x000000183430723cULL, 0x000b620000041830ULL, 0x00000010ff107819ULL, 0x000fe40000011644ULL,
0x0000105413127816ULL, 0x000fe40000000012ULL, 0x000010545a137816ULL, 0x000fc4000000003fULL,
0x00000010ff187819ULL, 0x020fe4000001163dULL, 0x0000105411107816ULL, 0x000fe40000000010ULL,
0x0000105418117816ULL, 0x000fe20000000043ULL, 0x000000123420723cULL, 0x040f700000041820ULL,
0x000000103434723cULL, 0x000b6e0000041838ULL, 0x0000f6c854107811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f688000cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff387224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x0000040004197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x00afc40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001812397210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e13ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x004fc80000011419ULL, 0x000000390c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff197224ULL, 0x000fca00000e0619ULL, 0x000000020c0c7819ULL, 0x000fc80000001219ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040004197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100b137824ULL, 0x000fe400078e00ffULL,
0x000059000f0f7a24ULL, 0x010fe400078e02ffULL, 0x00000080ff107424ULL, 0x000fe200078e00ffULL,
0xffffffe013117812ULL, 0x000fe200078ec0ffULL, 0x000000400f0f7824ULL, 0x000fc800078e00ffULL,
0x0000010048117824ULL, 0x000fca00078e0211ULL, 0x0000008011127810ULL, 0x000fe20007ffe0ffULL,
0x000062000f107625ULL, 0x000fc600078e0010ULL, 0x00000020120c7812ULL, 0x004fca00078ec0ffULL,
0x00000001550c7824ULL, 0x000fe200078e020cULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x000000120a0f7217ULL, 0x000fe40007800000ULL, 0x0000001013187812ULL, 0x000fe400078ec0ffULL,
0x00000003ff137819ULL, 0x000fe20000011649ULL, 0x000000010f0f7824ULL, 0x000fc600078e0a12ULL,
0x0000000413387810ULL, 0x040fe20007ffe0ffULL, 0x0000000113127824ULL, 0x140fe200078e0218ULL,
0x0000000f180f7217ULL, 0x000fe40007800000ULL, 0x0000000c13397810ULL, 0x000fe20007ffe0ffULL,
0x0000000112197824ULL, 0x040fe400078e0249ULL, 0x000000010f0f7824ULL, 0x000fe400078e0a18ULL,
0x00000008123c7824ULL, 0x040fe400078e00ffULL, 0x0000000112127824ULL, 0x000fe200078e020cULL,
0x0000000f3800720cULL, 0x0c0fe20003f66070ULL, 0x0000000138387824ULL, 0x100fe200078e0218ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee219ULL, 0x00000001393f7824ULL, 0x100fe200078e0218ULL,
0x0000000813197810ULL, 0x040fe20007ffe0ffULL, 0x00000008383e7824ULL, 0x040fe200078e00ffULL,
0x0000000f1300720cULL, 0x080fe20003f86070ULL, 0x0000000138137824ULL, 0x040fe200078e0249ULL,
0x0000000f1900720cULL, 0x0c0fe20003f46070ULL, 0x0000000119197824ULL, 0x000fe200078e0218ULL,
0x0000000f3900720cULL, 0x000fe20003f06070ULL, 0x00000001383a7824ULL, 0x000fe200078e020cULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000119397824ULL, 0x040fe200078e0249ULL, 0x00000051120f7212ULL, 0x000fe200078efcffULL,
0x0000000819407824ULL, 0x000fe400078e00ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000000f10127210ULL, 0x000fc60007fbe0ffULL, 0x0000000119387824ULL, 0x100fe200078e020cULL,
0x000000513a0f7212ULL, 0x000fe200078efcffULL, 0x000000013f187824ULL, 0x000fe200078e020cULL,
0xfffffff8400c7812ULL, 0x000fe200078ee239ULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000051383d7212ULL, 0x000fc600078efcffULL,
0x0000000111137824ULL, 0x000fe200028e0613ULL, 0x0000000f103a7210ULL, 0x000fe20007fbe0ffULL,
0x000000013f407824ULL, 0x040fe200078e0249ULL, 0x00000051180f7212ULL, 0x000fe200078efcffULL,
0x000000083f3f7824ULL, 0x000fe400078e00ffULL, 0x00000001113b7824ULL, 0x000fe200028e063bULL,
0x0000003d10387210ULL, 0x000fe20007fbe0ffULL, 0x000000100c3d7824ULL, 0x100fe200078e0257ULL,
0x0000000f10107210ULL, 0x000fe20007fde0ffULL, 0x000000103c0f7824ULL, 0x000fe200078e0257ULL,
0xfffffff83f407812ULL, 0x000fe200078ee240ULL, 0x0000000111397824ULL, 0x000fc400028e0639ULL,
0x0000000111117824ULL, 0x000fe200030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120f7faeULL, 0x0003e2000e101c48ULL, 0x000000103e197824ULL, 0x100fe400078e0257ULL,
0x00000010403f7824ULL, 0x000fc600078e0257ULL, 0x000000003a197faeULL, 0x0003e8000d901c48ULL,
0x00000000383d7faeULL, 0x0003e8000d101c48ULL, 0x00000000103f7faeULL, 0x0003e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001013127812ULL, 0x000fc800078ec0ffULL,
0x0000001249127211ULL, 0x000fc800078fe8ffULL, 0x0000000812187810ULL, 0x040fe20007ffe0ffULL,
0x00000001120f7824ULL, 0x140fe200078e0249ULL, 0x00000004123a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008123c7824ULL, 0x040fe400078e00ffULL, 0x0000000112387824ULL, 0x000fe400078e020cULL,
0x0000000118197824ULL, 0x000fe200078e0249ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL,
0x0000000818407824ULL, 0x000fe200078e00ffULL, 0x0000000c120f7810ULL, 0x000fe20007ffe0ffULL,
0x0000008038387825ULL, 0x000fc600078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee219ULL,
0x000000013a137824ULL, 0x040fe400078e0249ULL, 0x000000083a3e7824ULL, 0x040fe400078e00ffULL,
0x000000013a3a7824ULL, 0x100fe400078e020cULL, 0x0000000118187824ULL, 0x100fe200078e020cULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x000000010f127824ULL, 0x040fe400078e020cULL,
0x000000010f0c7824ULL, 0x000fc400078e0249ULL, 0x000000080f3d7824ULL, 0x000fe200078e00ffULL,
0x00000051380f7212ULL, 0x000fe200078efcffULL, 0x000000803a3a7825ULL, 0x000fc600078e00ffULL,
0x0000000f10387210ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0xfffffff83d0c7812ULL, 0x000fe400078ee20cULL, 0x000000513a3f7212ULL, 0x080fe200078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000051183d7212ULL, 0x000fe400078efcffULL,
0x0000003f103a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000111397824ULL, 0x040fe200000e0639ULL,
0x00000051120f7212ULL, 0x000fe200078efcffULL, 0x000000100c3f7824ULL, 0x000fe200078e0257ULL,
0x0000003d10187210ULL, 0x040fe20007f1e0ffULL, 0x00000001113b7824ULL, 0x000fe200010e063bULL,
0x0000000f10107210ULL, 0x000fe20007f7e0ffULL, 0x000000103c0f7824ULL, 0x000fc400078e0257ULL,
0x0000000111197824ULL, 0x040fe400000e0619ULL, 0x0000000111117824ULL, 0x000fe200018e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000380f7faeULL, 0x0003e2000b901c48ULL,
0x000000103e137824ULL, 0x100fe400078e0257ULL, 0x00000010403d7824ULL, 0x000fc600078e0257ULL,
0x000000003a137faeULL, 0x0003e8000b901c48ULL, 0x00000000183d7faeULL, 0x0003e8000b901c48ULL,
0x00000000103f7faeULL, 0x0003e4000b901c48ULL, 0x000000080b0c7824ULL, 0x000fe200078e00ffULL,
0x0000000207127810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff107424ULL, 0x000fc600078e00ffULL,
0xfffffff00c0c7812ULL, 0x000fe400078ec0ffULL, 0x000000091200720cULL, 0x000fe40003f06070ULL,
0x000000000c0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000156128824ULL, 0x000fc400078e0212ULL, 0x00000004ff138424ULL, 0x000fc800078e00ffULL,
0x0000640012128625ULL, 0x000fca00078e0013ULL, 0x0000000812108981ULL, 0x000522000c1e1900ULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6a8000c127f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628000d187f8cULL, 0x000664000c80043fULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x00f62c000d0f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00afe40007804819ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a380f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3a7824ULL, 0x000fe200000e0e39ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001143aULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e063aULL,
0x000000020c0c7819ULL, 0x000fc8000000120fULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c000d0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200b0c7824ULL, 0x000fca00078e00ffULL, 0xffffff800c0c7812ULL, 0x000fc800078ec0ffULL,
0x00000080510c7810ULL, 0x000fca0007ffe00cULL, 0x00000001730c7824ULL, 0x000fca00078e020cULL,
0x00f000000c117984ULL, 0x000e680000000800ULL, 0x00f200000c387984ULL, 0x0006a20000000800ULL,
0x000000061100720bULL, 0x002fe20003f1d000ULL, 0x0000f5727f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c3a7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fd200078e0006ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000001720c7810ULL, 0x000fe40007ffe0ffULL, 0x000000061100720bULL, 0x000fe40003f54000ULL,
0x0000000b0c00720cULL, 0x000fe20003f05270ULL, 0x0000f5127f007947ULL, 0x000fd4000b800000ULL,
0x00000000000f7806ULL, 0x000fc400010e0100ULL, 0x000000800b188824ULL, 0x000fe200078e0251ULL,
0x00000006110c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000173198824ULL, 0x000fe200078e0218ULL, 0x000099100f187816ULL, 0x000fc800000000ffULL,
0x00f4000c19008388ULL, 0x0003e20000000800ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000611197209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0fff7812ULL, 0x000fc6000780c0ffULL,
0x00000006190c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00397308ULL, 0x000e640000000800ULL, 0x000000390e0e7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011649ULL,
0x0000f4327f007947ULL, 0x000fea000b800000ULL, 0x00001f0c390c7589ULL, 0x0002e400000e0000ULL,
0x0000000c2c2c7220ULL, 0x08cfe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c14147220ULL, 0x080fe20000410000ULL, 0x0000000c15157220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490c7811ULL, 0x000fe200078ff0ffULL,
0x0000f3127f007947ULL, 0x000fea000b800000ULL, 0x00001f0c390c7589ULL, 0x00066400000e0000ULL,
0x0000000c2e2e7220ULL, 0x086fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c16167220ULL, 0x080fe20000410000ULL, 0x0000000c17177220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3aff7812ULL, 0x000fe2000780600fULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x00000006110f7209ULL, 0x000fd60007810000ULL,
0x8000000f11110221ULL, 0x000fe20000010000ULL, 0x00007610ff0c0816ULL, 0x000fc6000000000cULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100030308ULL, 0x000e640000000800ULL,
0x0000000338380220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000e380e7221ULL, 0x004fc20000010000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x000000080b067824ULL, 0x000fca00078e00ffULL, 0xfffffff0063a7812ULL, 0x000fca00078ec0ffULL,
0x00f6b4003a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780481bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x008fcc0000015200ULL, 0x0000003818117210ULL, 0x000fca0007f1e1ffULL,
0x0000000139387824ULL, 0x000fe200000e0e19ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff3800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff3800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011438ULL,
0x0000001106067211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0638ULL,
0x0000000206067819ULL, 0x000fc80000001211ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b4003a117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100c067816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff117819ULL, 0x000fe40000011649ULL,
0x0000541000067816ULL, 0x000fe20000000000ULL, 0x0000eec27f007947ULL, 0x000fea000b800000ULL,
0x00001f1106027589ULL, 0x0002a400000e0000ULL, 0x00000008110c7810ULL, 0x000fe20007ffe0ffULL,
0x0000eef27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c06007589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010110c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e0006ULL, 0x00005eb000197802ULL, 0x000fc40000000f00ULL,
0x0000f70000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018110c7810ULL, 0x006fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0006ULL,
0x00005f0000197802ULL, 0x000fc40000000f00ULL, 0x0000f6b000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100057507810ULL, 0x000fca0007ffe0ffULL, 0x000000104a537824ULL, 0x100fe400078e0250ULL,
0x000000104e387824ULL, 0x000fc600078e0250ULL, 0x000000005318783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x008ee20000004200ULL, 0x00000010ff117819ULL, 0x102fe40000011618ULL,
0x000000ff18437812ULL, 0x040fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe40000011618ULL,
0x0000ffff18527812ULL, 0x000fc400078ec0ffULL, 0x00000018ff187819ULL, 0x000fe40000011619ULL,
0x00000010ff657819ULL, 0x108fe4000001163aULL, 0x000000ff3a6d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001163aULL, 0x0000ffff3a667812ULL, 0x000fe400078ec0ffULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x00000018ff3a723eULL, 0x000fe400020006ffULL,
0x000000ff1b3e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff477819ULL, 0x100fe40000011639ULL,
0x000000ff39067812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011639ULL,
0x0000ffff39467812ULL, 0x000fc400078ec0ffULL, 0x00000043ff39723eULL, 0x000fe200020006ffULL,
0x20000042ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe20000011619ULL,
0x2000003aff427230ULL, 0x000fe20000004100ULL, 0x000000ff195d7812ULL, 0x040fe200078ec0ffULL,
0x20000039ff397230ULL, 0x000fe20000004100ULL, 0x0000ffff19407812ULL, 0x000fe400078ec0ffULL,
0x00000010ff417819ULL, 0x000fe4000001161aULL, 0x000000ff1a5e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001161aULL, 0x0000ffff1a3c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3d7819ULL, 0x100fe4000001161bULL, 0x00000018ff5c7819ULL, 0x000fe4000001161bULL,
0x0000ffff1b3f7812ULL, 0x000fe400078ec0ffULL, 0x009800004b18783bULL, 0x000e620000000200ULL,
0x0000003eff3a723eULL, 0x000fc400020006ffULL, 0x00000010ff457819ULL, 0x100fe40000011638ULL,
0x000000ff380c7812ULL, 0x044fe400078ec0ffULL, 0x00000018ff447819ULL, 0x000fe40000011638ULL,
0x0000ffff386b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff11117812ULL, 0x000fe400078ec0ffULL,
0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL, 0x0000005dff38723eULL, 0x000fe400020006ffULL,
0x0000005bff5d723eULL, 0x000fe200020006ffULL, 0x2000003aff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x100fe2000001163bULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x000000ff3b6f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff707819ULL, 0x000fe4000001163bULL,
0x0000ffff3b687812ULL, 0x000fc400078ec0ffULL, 0x00000011ff3a723eULL, 0x000fe200020006ffULL,
0x2000005dff117230ULL, 0x000fe20000004100ULL, 0x0000005aff3b723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x00000008ff407819ULL, 0x000fe20000011640ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe20000011639ULL, 0x2000005eff3e7230ULL, 0x000fe20000004100ULL,
0x0000005cff5e723eULL, 0x000fc400020006ffULL, 0x00000008ff5c7819ULL, 0x000fe20000011652ULL,
0x000000104d527824ULL, 0x000fe200078e0250ULL, 0x00000010ff3a7819ULL, 0x000fe2000001163aULL,
0x2000005eff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe20000011638ULL,
0x0000000218188231ULL, 0x082fe200003400ffULL, 0x00000010ff3b7819ULL, 0x000fe2000001163bULL,
0x000000021a1a8231ULL, 0x000fe200003400ffULL, 0x00000040ff5d723eULL, 0x000fe200020006ffULL,
0x0000000019198231ULL, 0x080fe200003400ffULL, 0x000000ff415e7812ULL, 0x000fe200078ec0ffULL,
0x000000001b1b8231ULL, 0x000fe200003400ffULL, 0x000010543a407816ULL, 0x000fc40000000039ULL,
0x000010543b417816ULL, 0x000fe40000000038ULL, 0x000000005238783bULL, 0x000e620000004200ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5f7819ULL, 0x000fe2000001163cULL, 0x2000005cff3c7230ULL, 0x000fe20000004100ULL,
0x0000003dff60723eULL, 0x000fe200020006ffULL, 0x2000005dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff437819ULL, 0x000fc40000011643ULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00001054433c7816ULL, 0x000fc4000000003cULL,
0x00001054423d7816ULL, 0x000fe2000000003dULL, 0x2000005eff5c7230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x000000401840723cULL, 0x040b62000004182cULL,
0x000000ff45457812ULL, 0x000fe400078ec0ffULL, 0x000000ff47477812ULL, 0x000fe400078ec0ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000010ff2c7819ULL, 0x020fe2000001163eULL,
0x2000003fff2e7230ULL, 0x000fe20000004100ULL, 0x00000010ff2d7819ULL, 0x000fe2000001165cULL,
0x0000003c183c723cULL, 0x000b620000041828ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x0000005fff5d723eULL, 0x000fe400020006ffULL, 0x0000000cff2a723eULL, 0x020fe400020006ffULL,
0x000010542d2c7816ULL, 0x000fe2000000002cULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x00001054602d7816ULL, 0x000fe4000000005bULL, 0x00000006ff2b723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff2a7819ULL, 0x000fc4000001162aULL,
0x00000010ff457819ULL, 0x000fe20000011645ULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe4000001162eULL, 0x0000002c182c723cULL, 0x000b620000041814ULL,
0x00000010ff067819ULL, 0x102fe40000011638ULL, 0x000000ff38697812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011638ULL, 0x0000ffff380c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff117819ULL, 0x000fe40000011611ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff287819ULL, 0x000fe4000001165dULL, 0x00000044ff14723eULL, 0x020fe400020006ffULL,
0x0000105445387816ULL, 0x000fe2000000002aULL, 0x000000104f457824ULL, 0x000fe200078e0250ULL,
0x00000010ff447819ULL, 0x000fe20000011647ULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x00000010ff2b7819ULL, 0x000fc4000001162bULL, 0x0000105411287816ULL, 0x000fe40000000028ULL,
0x000010545a297816ULL, 0x000fe40000000029ULL, 0x00000010ff117819ULL, 0x100fe40000011639ULL,
0x000000ff395f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe40000011639ULL,
0x0000ffff395a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5d7819ULL, 0x100fe4000001163bULL,
0x000000ff3b637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe4000001163bULL,
0x0000ffff3b5e7812ULL, 0x000fe400078ec0ffULL, 0x0000105444397816ULL, 0x000fe4000000002bULL,
0x00000008ff3b7819ULL, 0x000fe20000011646ULL, 0x000000281828723cULL, 0x000b62000004181cULL,
0x000000004544783bULL, 0x000e620000004200ULL, 0x00000010ff5b7819ULL, 0x000fc4000001163aULL,
0x000000ff3a617812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe4000001163aULL,
0x0000ffff3a5c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fe4000001166bULL,
0x0000006cff15723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fc400020006ffULL,
0x0000003bff3b723eULL, 0x000fe200020006ffULL, 0x20000015ff157230ULL, 0x000fe20000004100ULL,
0x000000ff65657812ULL, 0x000fe200078ec0ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x2000003bff1f7230ULL, 0x020fe20000004100ULL,
0x0000006fff17723eULL, 0x000fe400020006ffULL, 0x0000006dff16723eULL, 0x000fe400020006ffULL,
0x00000065ff1c723eULL, 0x000fe200020006ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x20000016ff167230ULL, 0x000fe20000004100ULL,
0x00000008ff687819ULL, 0x000fe20000011668ULL, 0x2000001cff1c7230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe20000011614ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000008ff1d7819ULL, 0x000fc40000011666ULL, 0x00000010ff147819ULL, 0x000fe4000001163aULL,
0x00000010ff667819ULL, 0x000fe40000011615ULL, 0x00000010ff157819ULL, 0x000fe4000001161fULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000068ff1f723eULL, 0x000fe400020006ffULL,
0x000010543b147816ULL, 0x000fe20000000014ULL, 0x20000070ff1e7230ULL, 0x000fe20000004100ULL,
0x0000001dff1d723eULL, 0x000fe200020006ffULL, 0x000000381838723cULL, 0x000b620000041830ULL,
0x00000010ff167819ULL, 0x000fe20000011616ULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fc400020006ffULL, 0x0000105466157816ULL, 0x000fe40000000015ULL,
0x00000010ff317819ULL, 0x020fe20000011617ULL, 0x2000001dff307230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe2000001161cULL, 0x2000006eff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff327819ULL, 0x000fe40000011667ULL, 0x00001054171c7816ULL, 0x000fe40000000016ULL,
0x00001054321d7816ULL, 0x000fe20000000031ULL, 0x000000141814723cULL, 0x000b620000041824ULL,
0x00000010ff1e7819ULL, 0x000fc4000001161eULL, 0x00000010ff1f7819ULL, 0x000fe4000001161fULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x000010541e257816ULL, 0x020fe4000000001fULL,
0x00000010ff247819ULL, 0x000fe20000011630ULL, 0x0000001c181c723cULL, 0x000b620000041820ULL,
0x000000ff44657812ULL, 0x002fe400078ec0ffULL, 0x00000018ff277819ULL, 0x000fc40000011644ULL,
0x0000ffff44337812ULL, 0x000fe400078ec0ffULL, 0x00000010ff227819ULL, 0x020fe40000011644ULL,
0x00000010ff317819ULL, 0x100fe40000011645ULL, 0x000000ff45667812ULL, 0x040fe400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe40000011645ULL, 0x0000ffff45237812ULL, 0x000fc400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000069ff32723eULL, 0x000fe400020006ffULL,
0x00000010ff307819ULL, 0x100fe40000011646ULL, 0x000000ff46457812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011646ULL, 0x0000ffff46267812ULL, 0x000fc400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x000010546b247816ULL, 0x000fe40000000024ULL,
0x00000010ff217819ULL, 0x100fe20000011647ULL, 0x20000063ff677230ULL, 0x000fe20000004100ULL,
0x000000ff47467812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe40000011647ULL,
0x0000ffff47207812ULL, 0x000fc400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000065ff47723eULL, 0x000fe200020006ffULL,
0x20000062ff657230ULL, 0x000fe20000004100ULL, 0x0000006aff69723eULL, 0x000fe200020006ffULL,
0x20000032ff6a7230ULL, 0x000fe20000004100ULL, 0x00000066ff62723eULL, 0x000fe200020006ffULL,
0x20000060ff6b7230ULL, 0x000fe20000004100ULL, 0x00000061ff32723eULL, 0x000fe200020006ffULL,
0x20000064ff667230ULL, 0x000fe20000004100ULL, 0x00000027ff63723eULL, 0x000fe200020006ffULL,
0x20000047ff277230ULL, 0x000fe20000004100ULL, 0x00000044ff64723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000045ff60723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000046ff61723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x000000241844723cULL, 0x000b620000041834ULL,
0x000000ff06067812ULL, 0x000fe200078ec0ffULL, 0x009800004c18783bULL, 0x020e620000000200ULL,
0x000000ff11117812ULL, 0x000fe200078ec0ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe2000001160cULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000006ff0c723eULL, 0x000fe200020006ffULL, 0x2000005fff6c7230ULL, 0x000fe20000004100ULL,
0x00000011ff11723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000008ff5a7819ULL, 0x000fe2000001165aULL, 0x2000000cff0c7230ULL, 0x000fe20000004100ULL,
0x00000024ff24723eULL, 0x000fe200020006ffULL, 0x20000011ff347230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x0000005aff37723eULL, 0x000fe200020006ffULL,
0x20000024ff367230ULL, 0x000fe20000004100ULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x000000ff31317812ULL, 0x000fe200078ec0ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005cff24723eULL, 0x000fc400020006ffULL, 0x00000031ff5a723eULL, 0x000fe400020006ffULL,
0x00000008ff337819ULL, 0x000fe20000011633ULL, 0x20000024ff247230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe4000001166cULL, 0x00000010ff317819ULL, 0x000fe4000001160cULL,
0x00000010ff5c7819ULL, 0x000fe20000011634ULL, 0x0000000218188231ULL, 0x082fe200003400ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x000000021a1a8231ULL, 0x000fe200003400ffULL,
0x000000ff22117812ULL, 0x000fe200078ec0ffULL, 0x2000005dff227230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000033ff33723eULL, 0x000fe200020006ffULL, 0x0000000019198231ULL, 0x080fe200003400ffULL,
0x0000105431347816ULL, 0x000fe2000000006aULL, 0x000000001b1b8231ULL, 0x000fe200003400ffULL,
0x000010545c357816ULL, 0x000fe20000000035ULL, 0x20000033ff0c7230ULL, 0x000fe20000004100ULL,
0x000000ff305d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff5c7819ULL, 0x000fe4000001166bULL, 0x00000010ff307819ULL, 0x000fe40000011636ULL,
0x00000010ff317819ULL, 0x000fe40000011637ULL, 0x00000008ff237819ULL, 0x000fe20000011623ULL,
0x000000341834723cULL, 0x000b620000041840ULL, 0x0000005eff25723eULL, 0x000fc400020006ffULL,
0x00000011ff11723eULL, 0x000fe400020006ffULL, 0x0000105469307816ULL, 0x000fe20000000030ULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x000010545c317816ULL, 0x000fe20000000031ULL,
0x20000011ff117230ULL, 0x000fe20000004100ULL, 0x00000023ff33723eULL, 0x000fe400020006ffULL,
0x00000010ff327819ULL, 0x000fe40000011632ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x20000033ff417230ULL, 0x020fe20000004100ULL, 0x00000008ff267819ULL, 0x000fc40000011626ULL,
0x00000010ff427819ULL, 0x000fe40000011622ULL, 0x000000ff21217812ULL, 0x000fe400078ec0ffULL,
0x00000010ff237819ULL, 0x000fe40000011667ULL, 0x000010545b227816ULL, 0x000fe40000000032ULL,
0x000000301830723cULL, 0x000b62000004183cULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x00000026ff3c723eULL, 0x020fe400020006ffULL, 0x00000010ff257819ULL, 0x000fe40000011625ULL,
0x00000021ff3d723eULL, 0x000fe400020006ffULL, 0x00000010ff267819ULL, 0x000fe40000011627ULL,
0x0000105442237816ULL, 0x000fe20000000023ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff277819ULL, 0x000fc40000011662ULL, 0x00000010ff217819ULL, 0x000fe20000011611ULL,
0x2000003cff117230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe2000001165aULL,
0x00000022182c723cULL, 0x000b62000004182cULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000105465247816ULL, 0x000fe40000000024ULL, 0x0000105466257816ULL, 0x000fe20000000025ULL,
0x2000005dff407230ULL, 0x000fe20000004100ULL, 0x0000105421267816ULL, 0x000fc40000000026ULL,
0x000010545a277816ULL, 0x000fe40000000027ULL, 0x00000008ff207819ULL, 0x000fe20000011620ULL,
0x000000241828723cULL, 0x040f620000041828ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff0c7819ULL, 0x000fe4000001160cULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff217819ULL, 0x000fe20000011641ULL, 0x000000261824723cULL, 0x000b620000041838ULL,
0x0000006dff5f723eULL, 0x000fc400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000020ff22723eULL, 0x020fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000105463207816ULL, 0x000fe2000000000cULL, 0x20000068ff067230ULL, 0x000fe20000004100ULL,
0x0000105464217816ULL, 0x000fe20000000021ULL, 0x20000022ff3a7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe40000011660ULL, 0x00000010ff237819ULL, 0x000fc40000011640ULL,
0x00000010ff397819ULL, 0x000fe40000011661ULL, 0x0000105423387816ULL, 0x000fe40000000038ULL,
0x000000201820723cULL, 0x000b620000041814ULL, 0x00000010ff0c7819ULL, 0x000fe4000001163dULL,
0x00000010ff117819ULL, 0x000fe40000011611ULL, 0x00000010ff067819ULL, 0x000fe40000011606ULL,
0x00000010ff147819ULL, 0x020fc4000001165fULL, 0x00000010ff157819ULL, 0x000fe4000001163aULL,
0x000010540c397816ULL, 0x000fe40000000039ULL, 0x0000105414147816ULL, 0x000fe40000000011ULL,
0x0000105406157816ULL, 0x000fe20000000015ULL, 0x000000020b067824ULL, 0x000fe400078e00ffULL,
0x00000038181c723cULL, 0x000f66000004181cULL, 0xfffffff8060c7812ULL, 0x000fca00078ec0ffULL,
0x000000141814723cULL, 0x000b6e0000041844ULL, 0x0000f6c854187811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000018187f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f690000cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff067224ULL, 0x000fc600078e00ffULL, 0x00000000001a7805ULL, 0x000fc80000015200ULL,
0x0000040004117984ULL, 0x000ee40000000800ULL, 0x8000000011ff7812ULL, 0x00afc40007804819ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x000000381a117210ULL, 0x000fca0007f1e1ffULL, 0x0000000139387824ULL, 0x000fe200000e0e1bULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff3800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff3800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x004fc80000011438ULL, 0x000000110c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0638ULL, 0x000000020c0c7819ULL, 0x000fc80000001211ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040004117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100b0c7824ULL, 0x004fe400078e00ffULL,
0x0000590010107a24ULL, 0x010fe400078e02ffULL, 0x00000080ff1b7424ULL, 0x000fe200078e00ffULL,
0xffffffe00c117812ULL, 0x000fe200078ec0ffULL, 0x0000004010107824ULL, 0x000fc800078e00ffULL,
0x0000010048117824ULL, 0x000fe400078e0211ULL, 0x00006200101a7625ULL, 0x000fc600078e001bULL,
0x000000c011117810ULL, 0x000fc80007ffe0ffULL, 0x0000002011067812ULL, 0x000fca00078ec0ffULL,
0x0000000155067824ULL, 0x000fe200078e0206ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x000000100c197812ULL, 0x000fe400078ec0ffULL, 0x000000110a0c7217ULL, 0x000fe40007800000ULL,
0x00000003ff107819ULL, 0x000fc60000011649ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a11ULL,
0x0000000410387810ULL, 0x040fe20007ffe0ffULL, 0x0000000110117824ULL, 0x040fe200078e0219ULL,
0x0000000c103a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c190c7217ULL, 0x000fe20007800000ULL,
0x0000000111187824ULL, 0x040fe400078e0249ULL, 0x0000000811417824ULL, 0x000fe400078e00ffULL,
0x000000010c0c7824ULL, 0x000fc400078e0a19ULL, 0x000000013a3c7824ULL, 0x100fe200078e0219ULL,
0xfffffff841417812ULL, 0x000fe400078ee218ULL, 0x0000000c3800720cULL, 0x0c0fe20003f66070ULL,
0x0000000138387824ULL, 0x000fe200078e0219ULL, 0x0000000810187810ULL, 0x000fe20007ffe0ffULL,
0x000000083c477824ULL, 0x000fe200078e00ffULL, 0x0000000c1000720cULL, 0x080fe20003f86070ULL,
0x0000000111107824ULL, 0x000fe200078e0206ULL, 0x0000000c3a00720cULL, 0x080fe20003f06070ULL,
0x0000000138117824ULL, 0x000fe200078e0249ULL, 0x0000000c1800720cULL, 0x000fe20003f46070ULL,
0x00000008383e7824ULL, 0x000fc400078e00ffULL, 0x00000001383a7824ULL, 0x000fe400078e0206ULL,
0x0000000118397824ULL, 0x000fe200078e0219ULL, 0xfffffff83e437812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000005110197212ULL, 0x000fc600078efcffULL, 0x0000000139187824ULL, 0x140fe200078e0206ULL,
0x000000191a107210ULL, 0x000fe20007fbe0ffULL, 0x000000013c387824ULL, 0x000fe200078e0206ULL,
0x000000513a3d7212ULL, 0x000fe200078efcffULL, 0x00000001390c7824ULL, 0x040fe400078e0249ULL,
0x0000000839457824ULL, 0x000fe400078e00ffULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee20cULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x00000051183f7212ULL, 0x000fc600078efcffULL, 0x000000011b117824ULL, 0x000fe200028e0611ULL,
0x0000003d1a3a7210ULL, 0x000fe20007fbe0ffULL, 0x000000013c067824ULL, 0x000fe200078e0249ULL,
0x00000051383d7212ULL, 0x000fc600078efcffULL, 0x000000011b3b7824ULL, 0x000fe200028e063bULL,
0x0000003f1a187210ULL, 0x040fe20007fbe0ffULL, 0x00000010453f7824ULL, 0x100fe200078e0250ULL,
0x0000003d1a1a7210ULL, 0x000fe20007fde0ffULL, 0x00000010413d7824ULL, 0x000fe200078e0250ULL,
0xfffffff847477812ULL, 0x000fe200078ee206ULL, 0x000000011b197824ULL, 0x040fe400028e0619ULL,
0x000000011b1b7824ULL, 0x000fe200030e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103d7faeULL, 0x0003e2000e101c48ULL, 0x0000001043397824ULL, 0x000fc400078e0250ULL,
0x0000001047417824ULL, 0x000fc600078e0250ULL, 0x000000003a397faeULL, 0x0003e8000d901c48ULL,
0x00000000183f7faeULL, 0x0003e8000d101c48ULL, 0x000000001a417faeULL, 0x0003e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000100c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c490c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c3a7810ULL, 0x040fe20007ffe0ffULL,
0x000000010c107824ULL, 0x140fe200078e0249ULL, 0x000000080c187810ULL, 0x040fe20007ffe0ffULL,
0x000000080c437824ULL, 0x000fe400078e00ffULL, 0x000000013a117824ULL, 0x140fe400078e0249ULL,
0x000000083a387824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee210ULL,
0x000000010c107824ULL, 0x040fe200078e0206ULL, 0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000118197824ULL, 0x000fe200078e0249ULL, 0xfffffff838457812ULL, 0x000fe200078ee211ULL,
0x00000008183c7824ULL, 0x000fc400078e00ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee219ULL, 0x000000013a3a7824ULL, 0x100fe200078e0206ULL,
0x00000051103d7212ULL, 0x000fe200078efcffULL, 0x0000000118187824ULL, 0x100fe400078e0206ULL,
0x000000010c387824ULL, 0x000fe200078e0206ULL, 0x0000003d1a107210ULL, 0x000fe20007f1e0ffULL,
0x000000803a3a7825ULL, 0x000fc800078e00ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000513a417212ULL, 0x000fc600078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x00000051183f7212ULL, 0x000fe400078efcffULL, 0x000000411a3a7210ULL, 0x000fe20007f5e0ffULL,
0x000000010c067824ULL, 0x000fe200078e0249ULL, 0x00000051383d7212ULL, 0x000fe200078efcffULL,
0x000000080c5b7824ULL, 0x000fe400078e00ffULL, 0x000000011b117824ULL, 0x040fe200000e0611ULL,
0x0000003f1a187210ULL, 0x040fe20007f1e0ffULL, 0x000000011b3b7824ULL, 0x000fe200010e063bULL,
0x0000003d1a1a7210ULL, 0x000fe20007f7e0ffULL, 0x00000010433d7824ULL, 0x000fe200078e0250ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee206ULL, 0x000000011b197824ULL, 0x000fc400000e0619ULL,
0x000000011b1b7824ULL, 0x000fe200018e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103d7faeULL, 0x0003e2000b901c48ULL, 0x0000001045397824ULL, 0x100fe400078e0250ULL,
0x00000010473f7824ULL, 0x100fe400078e0250ULL, 0x000000105b417824ULL, 0x000fe200078e0250ULL,
0x000000003a397faeULL, 0x0003e8000b901c48ULL, 0x00000000183f7faeULL, 0x0003e8000b901c48ULL,
0x000000001a417faeULL, 0x0003e4000b901c48ULL, 0x000000080b0c7824ULL, 0x000fe200078e00ffULL,
0x0000000307107810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff067424ULL, 0x000fc600078e00ffULL,
0xfffffff00c0c7812ULL, 0x000fe400078ec0ffULL, 0x000000091000720cULL, 0x000fe40003f06070ULL,
0x000000000c0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000156108824ULL, 0x000fc400078e0210ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000640010108625ULL, 0x000fca00078e0011ULL, 0x0000000810068981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b0000c107f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648000d187f8cULL, 0x000664000c80043fULL, 0x00000000001a7805ULL, 0x000fc40000015200ULL,
0x00f64c000d397984ULL, 0x000ee40000000800ULL, 0x8000000039ff7812ULL, 0x00afe40007804819ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x000000381a3b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e1bULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011439ULL,
0x0000003b0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x000000020c0c7819ULL, 0x000fc80000001239ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c000d397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200b0c7824ULL, 0x000fca00078e00ffULL, 0xffffff800c0c7812ULL, 0x000fc800078ec0ffULL,
0x00000100510c7810ULL, 0x000fca0007ffe00cULL, 0x00000001730c7824ULL, 0x000fca00078e020cULL,
0x00f000000c1a7984ULL, 0x000e680000000800ULL, 0x00f200000c1b7984ULL, 0x0006a20000000800ULL,
0x0000000f1a00720bULL, 0x002fe20003f1d000ULL, 0x0000c9527f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c387812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fd200078e000fULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000002720c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1a00720bULL, 0x000fe40003f54000ULL,
0x0000000b0c00720cULL, 0x000fe20003f05270ULL, 0x0000c8f27f007947ULL, 0x000fd4000b800000ULL,
0x00000000000d7806ULL, 0x000fc400010e0100ULL, 0x000000800b188824ULL, 0x000fe200078e0251ULL,
0x0000000f1a0c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000173198824ULL, 0x000fe200078e0218ULL, 0x000099100d187816ULL, 0x000fc800000000ffULL,
0x00f4000c19008388ULL, 0x0003e20000000800ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000f1a0c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL,
0x0000000f0c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00397308ULL, 0x000e640000000800ULL, 0x000000390e0e7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011649ULL,
0x0000c8127f007947ULL, 0x000fea000b800000ULL, 0x00001f0c390c7589ULL, 0x0002e400000e0000ULL,
0x0000000c34347220ULL, 0x08cfe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c14147220ULL, 0x080fe20000410000ULL, 0x0000000c15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490c7811ULL, 0x000fe200078ff0ffULL,
0x0000c6f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c390c7589ULL, 0x00066400000e0000ULL,
0x0000000c36367220ULL, 0x086fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c16167220ULL, 0x080fe20000410000ULL, 0x0000000c17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff38ff7812ULL, 0x000fe2000780600dULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000f1a0d7209ULL, 0x000fd60007810000ULL,
0x8000000d1a1a0221ULL, 0x000fe20000010000ULL, 0x00007610ff0c0816ULL, 0x000fc6000000000cULL,
0x3fb8aa3b1a1a0820ULL, 0x000fc80000410000ULL, 0x0000001a00030308ULL, 0x000e640000000800ULL,
0x000000031b1b0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000e1b0e7221ULL, 0x004fc20000010000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x000000080b0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff00f387812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00380f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff397224ULL, 0x008fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc8000001141bULL,
0x0000001a0f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff1a7224ULL, 0x000fca00000e061bULL,
0x000000020f0f7819ULL, 0x000fc8000000121aULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000139397810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00380f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100c0c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff127819ULL, 0x000fe40000011649ULL,
0x00005410000f7816ULL, 0x000fe20000000000ULL, 0x0000c2a27f007947ULL, 0x000fea000b800000ULL,
0x00001f120f027589ULL, 0x0002a400000e0000ULL, 0x00000008120c7810ULL, 0x000fe20007ffe0ffULL,
0x0000c2d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0f007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010120c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x00008c9000197802ULL, 0x000fc40000000f00ULL,
0x0000c92000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018120c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e000fULL,
0x00008ce000197802ULL, 0x000fc40000000f00ULL, 0x0000c8d000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000104a397824ULL, 0x000fe200078e0257ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00a000004b18783bULL, 0x000ee80000000200ULL,
0x000000003938783bULL, 0x000ea40000004200ULL, 0x0000000218188231ULL, 0x00cfc400003400ffULL,
0x000000021a1a8231ULL, 0x000fe200003400ffULL, 0x000000ff393d7812ULL, 0x000fe200078ec0ffULL,
0x0000000019198231ULL, 0x082fe200003400ffULL, 0x000000ff383c7812ULL, 0x040fe200078ec0ffULL,
0x000000001b1b8231ULL, 0x000fe200003400ffULL, 0x00000018ff137819ULL, 0x100fe40000011638ULL,
0x00000010ff127819ULL, 0x000fe40000011638ULL, 0x0000ffff38417812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3e7819ULL, 0x000fc40000011639ULL, 0x00000018ff387819ULL, 0x000fe40000011639ULL,
0x0000ffff394a7812ULL, 0x000fe200078ec0ffULL, 0x000000104e397824ULL, 0x100fe200078e0257ULL,
0x0000003dff3f723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000013ff3d723eULL, 0x000fe200020006ffULL, 0x2000003fff467230ULL, 0x000fe20000004100ULL,
0x00000010ff0f7819ULL, 0x100fe2000001163aULL, 0x2000003cff137230ULL, 0x000fe20000004100ULL,
0x000000ff3a0c7812ULL, 0x040fe200078ec0ffULL, 0x2000003dff457230ULL, 0x000fe20000004100ULL,
0x00000018ff6b7819ULL, 0x000fe2000001163aULL, 0x000000104d3f7824ULL, 0x000fe200078e0257ULL,
0x0000ffff3a427812ULL, 0x000fc400078ec0ffULL, 0x00000010ff477819ULL, 0x100fe4000001163bULL,
0x000000ff3b447812ULL, 0x040fe400078ec0ffULL, 0x00000018ff437819ULL, 0x000fe4000001163bULL,
0x0000ffff3b617812ULL, 0x000fe400078ec0ffULL, 0x00000038ff40723eULL, 0x000fe400020006ffULL,
0x000000003938783bULL, 0x000e620000004200ULL, 0x000000ff3e3e7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff3c7819ULL, 0x000fe20000011641ULL, 0x20000040ff4e7230ULL, 0x000fe20000004100ULL,
0x00000008ff3d7819ULL, 0x000fe4000001164aULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x2000003eff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff12127812ULL, 0x000fe200078ec0ffULL,
0x2000003cff417230ULL, 0x000fe20000004100ULL, 0x000000ff0f4d7812ULL, 0x000fe200078ec0ffULL,
0x2000003dff4b7230ULL, 0x000fe20000004100ULL, 0x00000012ff12723eULL, 0x000fe200020006ffULL,
0x000000003f3c783bULL, 0x000ea20000004200ULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x0000000cff0c723eULL, 0x000fe200020006ffULL, 0x20000012ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff127819ULL, 0x000fe40000011613ULL, 0x00000010ff137819ULL, 0x000fe20000011646ULL,
0x2000000cff0c7230ULL, 0x000fe20000004100ULL, 0x00000010ff0f7819ULL, 0x000fe40000011640ULL,
0x000010544a137816ULL, 0x000fe40000000013ULL, 0x000010540f127816ULL, 0x000fc40000000012ULL,
0x00000010ff407819ULL, 0x000fe40000011641ULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff4e7819ULL, 0x000fe2000001164eULL, 0x000000121834723cULL, 0x000be20000041834ULL,
0x00000010ff417819ULL, 0x000fe4000001164bULL, 0x0000105445407816ULL, 0x000fe40000000040ULL,
0x000010544e417816ULL, 0x000fc40000000041ULL, 0x000000ff38137812ULL, 0x022fe400078ec0ffULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x100fe2000001163aULL,
0x000000401830723cULL, 0x000b620000041830ULL, 0x000000ff3a687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001163aULL, 0x0000ffff3a0f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff127819ULL, 0x000fe4000001160cULL, 0x00000018ff667819ULL, 0x000fe40000011638ULL,
0x00000010ff637819ULL, 0x100fe4000001163bULL, 0x000000ff3b3a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b0c7812ULL, 0x000fc400078ec0ffULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000044ff3b723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000066ff40723eULL, 0x020fe200020006ffULL,
0x20000013ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff137819ULL, 0x000fe20000011642ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x004fe2000001163cULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x000000ff3c447812ULL, 0x000fc400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe4000001163cULL, 0x0000ffff3c5e7812ULL, 0x000fe200078ec0ffULL,
0x2000006bff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x100fe4000001163dULL,
0x000000ff3d5d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe4000001163dULL,
0x0000ffff3d4e7812ULL, 0x000fc400078ec0ffULL, 0x00000043ff3d723eULL, 0x000fe400020006ffULL,
0x0000003aff6b723eULL, 0x000fe400020006ffULL, 0x00000068ff43723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000013ff3a723eULL, 0x000fe400020006ffULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fc4000001164dULL, 0x00000010ff137819ULL, 0x000fe4000001163bULL,
0x00000010ff687819ULL, 0x000fe20000011647ULL, 0x2000006bff477230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe40000011638ULL, 0x00000010ff657819ULL, 0x100fe40000011639ULL,
0x00000018ff677819ULL, 0x000fe40000011639ULL, 0x0000ffff38387812ULL, 0x000fc400078ec0ffULL,
0x00000061ff3b723eULL, 0x000fe200020006ffULL, 0x2000003aff617230ULL, 0x000fe20000004100ULL,
0x000010544d127816ULL, 0x000fe40000000012ULL, 0x0000105468137816ULL, 0x000fe40000000013ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x000000ff653a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff39697812ULL, 0x000fe200078ec0ffULL, 0x20000067ff427230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011638ULL, 0x000000104f387824ULL, 0x000fe200078e0257ULL,
0x0000ffff39397812ULL, 0x000fe200078ec0ffULL, 0x00000012182c723cULL, 0x000b62000004182cULL,
0x000000ff64677812ULL, 0x000fe200078ec0ffULL, 0x2000003bff647230ULL, 0x000fe20000004100ULL,
0x0000003aff4f723eULL, 0x000fc400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff137819ULL, 0x020fe40000011639ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000067ff127230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x000000ff63687812ULL, 0x000fe400078ec0ffULL,
0x00000069ff69723eULL, 0x000fc400020006ffULL, 0x00000062ff63723eULL, 0x000fe200020006ffULL,
0x20000065ff627230ULL, 0x000fe20000004100ULL, 0x00000013ff67723eULL, 0x000fe200020006ffULL,
0x2000004fff137230ULL, 0x000fe20000004100ULL, 0x00000068ff65723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fe2000001163dULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff4f7819ULL, 0x000fe4000001163cULL,
0x00000010ff3d7819ULL, 0x000fe20000011664ULL, 0x20000065ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe20000011661ULL, 0x20000067ff617230ULL, 0x000fe20000004100ULL,
0x00001054683d7816ULL, 0x000fc4000000003dULL, 0x000010544f3c7816ULL, 0x000fe4000000003cULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff657819ULL, 0x000fe20000011612ULL, 0x0000003c1828723cULL, 0x000b620000041828ULL,
0x00000010ff687819ULL, 0x000fe40000011613ULL, 0x0000105465127816ULL, 0x000fc40000000066ULL,
0x0000105468137816ULL, 0x000fe40000000069ULL, 0x00000008ff0f7819ULL, 0x000fe4000001160fULL,
0x00000010ff5a7819ULL, 0x100fe4000001163eULL, 0x000000ff3e4b7812ULL, 0x040fe200078ec0ffULL,
0x000000121824723cULL, 0x000b620000041824ULL, 0x00000018ff417819ULL, 0x000fe4000001163eULL,
0x0000ffff3e5b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff3f4d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3d7819ULL, 0x020fe40000011640ULL, 0x00000018ff3e7819ULL, 0x000fe4000001163fULL,
0x0000004aff4f723eULL, 0x000fe400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe40000011642ULL,
0x00000010ff407819ULL, 0x000fc40000011643ULL, 0x0000000fff0f723eULL, 0x000fe400020006ffULL,
0x00000010ff427819ULL, 0x000fe40000011662ULL, 0x00000010ff437819ULL, 0x000fe20000011661ULL,
0x2000000fff0f7230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x102fe4000001163aULL,
0x000000ff3a6c7812ULL, 0x040fe200078ec0ffULL, 0x2000005dff667230ULL, 0x000fe20000004100ULL,
0x00000018ff127819ULL, 0x000fe4000001163aULL, 0x0000ffff3a4a7812ULL, 0x000fe400078ec0ffULL,
0x0000004dff4d723eULL, 0x000fc400020006ffULL, 0x00000010ff677819ULL, 0x100fe40000011638ULL,
0x000000ff386d7812ULL, 0x040fe200078ec0ffULL, 0x2000004dff5d7230ULL, 0x000fe20000004100ULL,
0x00000018ff137819ULL, 0x000fe40000011638ULL, 0x0000ffff38687812ULL, 0x000fe400078ec0ffULL,
0x00000010ff697819ULL, 0x000fe40000011639ULL, 0x000000ff396e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe40000011639ULL, 0x0000ffff39617812ULL, 0x000fe200078ec0ffULL,
0x2000004fff397230ULL, 0x000fe20000004100ULL, 0x000000ff3b3a7812ULL, 0x000fe400078ec0ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x000010543d427816ULL, 0x000fe40000000042ULL,
0x000010543c437816ULL, 0x000fe20000000043ULL, 0x2000003eff4d7230ULL, 0x000fe20000004100ULL,
0x00000018ff387819ULL, 0x000fc4000001163bULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00001054633c7816ULL, 0x000fe40000000040ULL, 0x00001054643d7816ULL, 0x000fe20000000047ULL,
0x20000044ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe4000001163bULL,
0x0000ffff3b407812ULL, 0x000fe400078ec0ffULL, 0x0000003aff3b723eULL, 0x000fe200020006ffULL,
0x0000003c181c723cULL, 0x000fe2000004181cULL, 0x00000012ff3a723eULL, 0x000fc400020006ffULL,
0x00000008ff0c7819ULL, 0x000fe2000001160cULL, 0x2000003bff127230ULL, 0x000fe20000004100ULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff3e7819ULL, 0x000fe2000001160fULL, 0x20000038ff0f7230ULL, 0x000fe20000004100ULL,
0x0000006bff44723eULL, 0x000fe400020006ffULL, 0x000000ff606b7812ULL, 0x000fc400078ec0ffULL,
0x0000000cff60723eULL, 0x000fe200020006ffULL, 0x2000003aff0c7230ULL, 0x000fe20000004100ULL,
0x00001054393e7816ULL, 0x000fe2000000003eULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x000000421838723cULL, 0x000b620000041820ULL, 0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL,
0x00a000004c20783bULL, 0x020e620000000200ULL, 0x00000008ff4e7819ULL, 0x000fe2000001164eULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fe4000001163fULL,
0x0000006aff6a723eULL, 0x000fc400020006ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x2000006bff437230ULL, 0x000fe20000004100ULL, 0x00000008ff3f7819ULL, 0x000fe2000001163fULL,
0x2000005fff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x2000004eff5f7230ULL, 0x000fe20000004100ULL, 0x0000003fff4e723eULL, 0x000fc400020006ffULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff3f7819ULL, 0x000fe20000011660ULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000045ff637230ULL, 0x000fe20000004100ULL, 0x000010546a3f7816ULL, 0x000fe2000000003fULL,
0x20000046ff647230ULL, 0x000fe20000004100ULL, 0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff5b7819ULL, 0x000fe2000001165bULL, 0x0000003e1814723cULL, 0x000b620000041814ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x0000000220208231ULL, 0x082fe200003400ffULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x0000000222228231ULL, 0x000fe200003400ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000004bff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x0000000021218231ULL, 0x080fe200003400ffULL,
0x00000010ff187819ULL, 0x020fe2000001165eULL, 0x0000000023238231ULL, 0x000fe200003400ffULL,
0x00000010ff197819ULL, 0x000fe2000001165fULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x0000005bff4c723eULL, 0x000fe400020006ffULL,
0x0000105463187816ULL, 0x000fe20000000018ULL, 0x20000041ff4b7230ULL, 0x000fe20000004100ULL,
0x0000105464197816ULL, 0x000fe20000000019ULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe40000011665ULL, 0x00000010ff3d7819ULL, 0x000fe40000011643ULL,
0x00000010ff667819ULL, 0x000fe20000011666ULL, 0x000000182030723cULL, 0x000b620000041830ULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x000000ff695b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1a7819ULL, 0x000fe4000001164fULL,
0x00000010ff1b7819ULL, 0x000fe4000001165aULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x000010543d3c7816ULL, 0x000fc4000000003cULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x000010546b3d7816ULL, 0x000fe40000000066ULL, 0x0000006dff45723eULL, 0x000fe400020006ffULL,
0x00000067ff42723eULL, 0x000fc400020006ffULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff3e7819ULL, 0x000fe2000001164dULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x020fe2000001164cULL,
0x0000003c2034723cULL, 0x000b620000041834ULL, 0x00000010ff197819ULL, 0x000fe4000001164eULL,
0x0000006eff46723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x000010541b1a7816ULL, 0x000fe2000000001aULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00000013ff13723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000068ff60723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000013ff417230ULL, 0x000fe20000004100ULL, 0x000010545c1b7816ULL, 0x000fe2000000005dULL,
0x20000060ff437230ULL, 0x000fe20000004100ULL, 0x000010544b187816ULL, 0x000fe20000000018ULL,
0x20000061ff3d7230ULL, 0x020fe20000004100ULL, 0x000010543e197816ULL, 0x000fc40000000019ULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x0000001a202c723cULL, 0x040b62000004182cULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4a7819ULL, 0x000fe4000001164aULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff1a7819ULL, 0x020fe20000011645ULL,
0x000000182028723cULL, 0x000b620000041828ULL, 0x00000010ff1b7819ULL, 0x000fc40000011642ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x2000006cff137230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x020fe20000011643ULL, 0x20000062ff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fc40000011644ULL, 0x00000010ff197819ULL, 0x000fe4000001163dULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x000010541b1a7816ULL, 0x000fe2000000001aULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x000010545b1b7816ULL, 0x000fc40000000046ULL, 0x0000105441187816ULL, 0x000fe20000000018ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000105444197816ULL, 0x000fe40000000019ULL,
0x00000010ff137819ULL, 0x000fe20000011613ULL, 0x0000001a2024723cULL, 0x000b620000041824ULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff4a7819ULL, 0x000fc4000001164aULL, 0x00000010ff1a7819ULL, 0x020fe20000011612ULL,
0x000000182038723cULL, 0x000b620000041838ULL, 0x00000010ff0f7819ULL, 0x000fe4000001160fULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x000010543c127816ULL, 0x000fe40000000013ULL,
0x00000010ff197819ULL, 0x020fe2000001160cULL, 0x000000020b0c7824ULL, 0x000fe200078e00ffULL,
0x0000105447137816ULL, 0x000fc4000000001aULL, 0x00001054194a7816ULL, 0x000fe4000000004aULL,
0x000010540f4b7816ULL, 0x000fe40000000040ULL, 0xfffffff80c0f7812ULL, 0x000fe200078ec0ffULL,
0x00000012201c723cULL, 0x040b6e000004181cULL, 0x0000f6c854127811ULL, 0x020fe200078e18ffULL,
0x0000004a2020723cULL, 0x000b620000041814ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f698000fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0c7224ULL, 0x000fc600078e00ffULL, 0x0000000000147805ULL, 0x020fc80000015200ULL,
0x00000400040f7984ULL, 0x004ea40000000800ULL, 0x800000000fff7812ULL, 0x006fc40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614167210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011417ULL, 0x000000160f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff167224ULL, 0x000fca00000e0617ULL, 0x000000020f0f7819ULL, 0x000fc80000001216ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400040f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001480f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000307077810ULL, 0x000fe40007ffe0ffULL, 0x000000080f00720cULL, 0x000fda0003f06070ULL,
0x0000083000000947ULL, 0x000fea0003800000ULL, 0x0000000248077810ULL, 0x000fe20007ffe0ffULL,
0x0000590006067a24ULL, 0x010fe400078e02ffULL, 0x000001000f0f7824ULL, 0x000fe200078e0277ULL,
0x000000080700720cULL, 0x000fe20003f06070ULL, 0x0000004006077824ULL, 0x000fe400078e00ffULL,
0x00000080ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000200f067812ULL, 0x000fca00078ec0ffULL,
0x0000000155187824ULL, 0x000fe400078e0206ULL, 0x0000620007067625ULL, 0x000fe400078e000cULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x0000000f0a0c7217ULL, 0x000fe20007800000ULL,
0x000000100b127824ULL, 0x000fc800078e00ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0fULL,
0x00000010120f7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff127819ULL, 0x000fe40000011649ULL,
0x0000000c0f0c7217ULL, 0x000fe40007800000ULL, 0x0000000812157810ULL, 0x040fe20007ffe0ffULL,
0x0000000112137824ULL, 0x140fe200078e020fULL, 0x0000000412147810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0fULL, 0x0000000c12167810ULL, 0x000fe20007ffe0ffULL,
0x0000000813177824ULL, 0x000fc600078e00ffULL, 0x0000000c1500720cULL, 0x0c0fe20003f46070ULL,
0x0000000115157824ULL, 0x000fe200078e020fULL, 0x0000000c1200720cULL, 0x080fe20003f86070ULL,
0x0000000113127824ULL, 0x000fe200078e0218ULL, 0x0000000c1400720cULL, 0x080fe20003f66070ULL,
0x00000008153c7824ULL, 0x000fe200078e00ffULL, 0x0000000c1600720cULL, 0x000fe20003f06070ULL,
0x00000001130c7824ULL, 0x100fe400078e0249ULL, 0x0000000115137824ULL, 0x000fe400078e0249ULL,
0x0000000114147824ULL, 0x100fe200078e020fULL, 0xfffffff8170c7812ULL, 0x000fe200078ee20cULL,
0x00000001161b7824ULL, 0x000fe200078e020fULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x0000000114167824ULL, 0x000fc400078e0218ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x00000001140f7824ULL, 0x000fe200078e0249ULL, 0x0000005112197212ULL, 0x000fe200078efcffULL,
0x00000008141a7824ULL, 0x000fe400078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001906127210ULL, 0x000fe40007fbe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL,
0x0000000115147824ULL, 0x100fe200078e0218ULL, 0x00000051160f7212ULL, 0x000fe200078efcffULL,
0x000000011b187824ULL, 0x000fc400078e0218ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000f06167210ULL, 0x000fc60007fde0ffULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x000000011b3d7824ULL, 0x040fe200078e0249ULL, 0x00000051180f7212ULL, 0x080fe200078efcffULL,
0x000000081b3e7824ULL, 0x000fe200078e00ffULL, 0x00000051141b7212ULL, 0x000fe200078efcffULL,
0x0000000107137824ULL, 0x040fe400028e0613ULL, 0x0000000107177824ULL, 0x000fe200030e0617ULL,
0x0000001b06147210ULL, 0x000fe20007fbe0ffULL, 0x000000101a3f7824ULL, 0x000fe200078e0257ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee23dULL, 0x000000100c3d7824ULL, 0x100fe200078e0257ULL,
0x0000000f06067210ULL, 0x000fe20007fde0ffULL, 0x000000103c0f7824ULL, 0x000fc400078e0257ULL,
0x0000000107157824ULL, 0x040fe200028e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123d7faeULL, 0x0003e2000e101c48ULL, 0x000000103e577824ULL, 0x000fe400078e0257ULL,
0x0000000107077824ULL, 0x000fe200030e0619ULL, 0x00000000163f7faeULL, 0x0003e8000d901c48ULL,
0x00000000140f7faeULL, 0x0003e8000d101c48ULL, 0x0000000006577faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000100b0c7824ULL, 0x000fca00078e00ffULL,
0x000000100c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c490c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c157810ULL, 0x040fe20007ffe0ffULL, 0x000000010c127824ULL, 0x140fe200078e0218ULL,
0x000000080c177810ULL, 0x040fe20007ffe0ffULL, 0x000000010c0f7824ULL, 0x140fe200078e0249ULL,
0x0000000c0c197810ULL, 0x040fe20007ffe0ffULL, 0x000000080c1a7824ULL, 0x000fe400078e00ffULL,
0x0000000115147824ULL, 0x040fe400078e0218ULL, 0x00000001150c7824ULL, 0x040fe200078e0249ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL, 0x00000008151b7824ULL, 0x000fc400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff81b0c7812ULL, 0x000fe200078ee20cULL,
0x0000000117167824ULL, 0x140fe200078e0218ULL, 0x00000051120f7212ULL, 0x000fe200078efcffULL,
0x0000000117157824ULL, 0x140fe400078e0249ULL, 0x00000008173c7824ULL, 0x000fe200078e00ffULL,
0x0000000f06127210ULL, 0x000fe20007f1e0ffULL, 0x0000000119177824ULL, 0x040fe400078e0249ULL,
0x00000008193e7824ULL, 0x040fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee215ULL,
0x0000000119187824ULL, 0x000fc400078e0218ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fc600078ee217ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000051143d7212ULL, 0x000fc600078efcffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x00000051161b7212ULL, 0x000fc600078efcffULL, 0x0000000107137824ULL, 0x040fe200000e0613ULL,
0x00000051180f7212ULL, 0x000fe200078efcffULL, 0x000000101a3f7824ULL, 0x100fe200078e0257ULL,
0x0000003d06147210ULL, 0x000fe20007f1e0ffULL, 0x000000100c417824ULL, 0x100fe200078e0257ULL,
0x0000001b06167210ULL, 0x000fe20007f5e0ffULL, 0x000000103c437824ULL, 0x000fe200078e0257ULL,
0x0000000f06067210ULL, 0x000fe20007f7e0ffULL, 0x0000000107157824ULL, 0x040fe200000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123f7faeULL, 0x0003e2000b901c48ULL,
0x0000000107177824ULL, 0x000fc400010e0617ULL, 0x000000103e577824ULL, 0x000fe200078e0257ULL,
0x0000000014417faeULL, 0x0003e2000b901c48ULL, 0x0000000107077824ULL, 0x000fc600018e0619ULL,
0x0000000016437faeULL, 0x0003e8000b901c48ULL, 0x0000000006577faeULL, 0x0003e4000b901c48ULL,
0x0000000471077810ULL, 0x002fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0xffffffffff067424ULL, 0x000fe400078e00ffULL, 0x000000090700720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000156127824ULL, 0x000fe400078e0207ULL,
0x00000004ff137424ULL, 0x000fc800078e00ffULL, 0x0000640012127625ULL, 0x000fca00078e0013ULL,
0x0000000812067981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000080b0c7824ULL, 0x000fca00078e00ffULL, 0xfffffff00c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000000c0473c2ULL, 0x000ea200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a804047890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8000c3c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680005127f8cULL, 0x0022a2000c80043fULL, 0x000000ffff3c7224ULL, 0x008fc600078e003dULL,
0x0000000000147805ULL, 0x000fc80000015200ULL, 0x00f66c00050f7984ULL, 0x000ee40000000800ULL,
0x800000000fff7812ULL, 0x00cfe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x00000016140f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000117167824ULL, 0x000fe200000e0e15ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011416ULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e0616ULL, 0x000000020c0c7819ULL, 0x000fc8000000120fULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c00050f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000180720c7811ULL, 0x000fc800078e38ffULL,
0x0000000c730c7210ULL, 0x000fca0007ffe051ULL, 0x00f000000c127984ULL, 0x000ea80000000800ULL,
0x00f200000c3d7984ULL, 0x0006620000000800ULL, 0x0000000d1200720bULL, 0x004fe20003f1d000ULL,
0x00009cc27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c147812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff137424ULL, 0x000fe400078e00ffULL, 0x000000ffff3e7224ULL, 0x000fd200078e000dULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000003720c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000d1200720bULL, 0x000fe40003f54000ULL, 0x0000000b0c00720cULL, 0x000fe20003f05270ULL,
0x00009c627f007947ULL, 0x000fd4000b800000ULL, 0x00000000000f7806ULL, 0x000fc400010e0100ULL,
0x000000800b168824ULL, 0x000fe200078e0251ULL, 0x0000000d120c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100f137816ULL, 0x000fe200000000ffULL,
0x0000000173738824ULL, 0x000fca00078e0216ULL, 0x00f4000c73008388ULL, 0x0005e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000d120c7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0fff7812ULL, 0x000fc6000780c0ffULL, 0x0000000d0c0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00137308ULL, 0x000ea40000000800ULL,
0x000000130e0e7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011649ULL, 0x00009b827f007947ULL, 0x000fea000b800000ULL,
0x00001f0c130c7589ULL, 0x0004e400000e0000ULL, 0x0000000c34347220ULL, 0x08cfe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008490c7811ULL, 0x000fe200078ff0ffULL, 0x00009a627f007947ULL, 0x000fea000b800000ULL,
0x00001f0c130c7589ULL, 0x0004e400000e0000ULL, 0x0000000c36367220ULL, 0x08cfe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x080fe20000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff14ff7812ULL, 0x000fe2000780600fULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x0000000d123e7209ULL, 0x000fd60007810000ULL, 0x8000003e12120221ULL, 0x000fe20000010000ULL,
0x00007610ff130816ULL, 0x000fc60000000013ULL, 0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL,
0x0000001200030308ULL, 0x000ea40000000800ULL, 0x000000033d3d0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e3d3d7221ULL, 0x002fc20000010000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x000000080b0e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e127812ULL, 0x000fca00078ec0ffULL, 0x00f6b400120f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b400120f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910130c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011649ULL, 0x00005410000d7816ULL, 0x000fe20000000000ULL,
0x000096127f007947ULL, 0x000fea000b800000ULL, 0x00001f0e0d027589ULL, 0x0002a400000e0000ULL,
0x000000080e0c7810ULL, 0x000fe20007ffe0ffULL, 0x000096427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100e0c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e000dULL,
0x0000bae000197802ULL, 0x000fc40000000f00ULL, 0x00009ad000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180e0c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x0000bb3000197802ULL, 0x000fc40000000f00ULL,
0x00009a8000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000080072187824ULL, 0x040fe200078e0259ULL,
0x00000003725b7810ULL, 0x000fc40007ffe0ffULL, 0x00000000530c783bULL, 0x00ee620000004200ULL,
0x0000000749167812ULL, 0x000fc400078ec0ffULL, 0x0000000258147810ULL, 0x000fe20007ffe0ffULL,
0x000000005210783bULL, 0x0004e20000004200ULL, 0x0000000816167812ULL, 0x000fca00078ef849ULL,
0x0000000816197824ULL, 0x000fe200078e00ffULL, 0x0000000849167812ULL, 0x000fc800078ec0ffULL,
0x0000000716477812ULL, 0x000fe400078ef849ULL, 0xfffffff819527812ULL, 0x004fe400078ee214ULL,
0x00000010475d7812ULL, 0x040fe200078efcffULL, 0x00000008475f7824ULL, 0x000fc800078e00ffULL,
0x000000085d5c7824ULL, 0x000fe200078e00ffULL, 0x00000010ff3f7819ULL, 0x102fe4000001160cULL,
0x000000ff0c4a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe4000001160cULL,
0x0000ffff0c447812ULL, 0x000fe200078ec0ffULL, 0x000000040b0c7824ULL, 0x000fe200078e00ffULL,
0x00000010ff147819ULL, 0x008fe40000011612ULL, 0x000000ff12467812ULL, 0x000fc400078ec0ffULL,
0x000000040c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff197819ULL, 0x000fe40000011612ULL,
0x000000020c0c7812ULL, 0x000fe400078efcffULL, 0x0000ffff12427812ULL, 0x000fe400078ec0ffULL,
0x0000000c490c7211ULL, 0x000fe400078fe0ffULL, 0x00000010ff167819ULL, 0x000fc40000011613ULL,
0x000000ff131a7812ULL, 0x000fe200078ec0ffULL, 0x0000000147127824ULL, 0x100fe200078e020cULL,
0x00000018ff597819ULL, 0x000fe20000011613ULL, 0x000000015d577824ULL, 0x000fe200078e020cULL,
0x0000ffff13477812ULL, 0x000fe200078ec0ffULL, 0x000000805b0c7824ULL, 0x000fe200078e0252ULL,
0x000000ff0d4c7812ULL, 0x000fe400078ec0ffULL, 0xfffffff85f137812ULL, 0x000fe400078ee212ULL,
0x00000018ff4b7819ULL, 0x000fc4000001160dULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x000000ff0e4d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff157819ULL, 0x000fe4000001160eULL,
0x0000004cff12723eULL, 0x000fe200020006ffULL, 0x00000010134c7824ULL, 0x000fe200078e0250ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x2000004aff137230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x20000012ff127230ULL, 0x000fe20000004100ULL,
0x00000018ff177819ULL, 0x000fe2000001160fULL, 0x2000004bff527230ULL, 0x000fe20000004100ULL,
0x00000015ff4a723eULL, 0x000fe200020006ffULL, 0x2000004dff157230ULL, 0x000fe20000004100ULL,
0x000000ff10407812ULL, 0x000fc400078ec0ffULL, 0x00000018ff457819ULL, 0x000fe40000011611ULL,
0x000000ff11437812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1b7819ULL, 0x000fe40000011610ULL,
0x00000017ff4b723eULL, 0x000fe200020006ffULL, 0x2000004aff177230ULL, 0x000fe20000004100ULL,
0x00000040ff4d723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x2000004bff407230ULL, 0x000fe20000004100ULL, 0x00000043ff4a723eULL, 0x000fe200020006ffULL,
0x2000004dff437230ULL, 0x000fe20000004100ULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x20000045ff4b7230ULL, 0x000fe20000004100ULL, 0x0000001bff1b723eULL, 0x000fe200020006ffULL,
0x2000004aff4d7230ULL, 0x000fe20000004100ULL, 0x0000001aff1a723eULL, 0x000fe200020006ffULL,
0x20000046ff457230ULL, 0x000fe20000004100ULL, 0xfffffff85c577812ULL, 0x000fe200078ee257ULL,
0x2000001bff4a7230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x2000001aff467230ULL, 0x000fe20000004100ULL, 0x00000019ff5b723eULL, 0x000fe200020006ffULL,
0x0000001057507824ULL, 0x000fe200078e0250ULL, 0x00000010ff587819ULL, 0x000fe2000001160dULL,
0x00a800001818783bULL, 0x000e620000000200ULL, 0x000000ff0f5a7812ULL, 0x000fe200078ec0ffULL,
0x20000041ff577230ULL, 0x000fe20000004100ULL, 0x0000ffff0d537812ULL, 0x000fc400078ec0ffULL,
0x0000005aff41723eULL, 0x000fe400020006ffULL, 0x000000ff58587812ULL, 0x000fe400078ec0ffULL,
0x00000010ff0d7819ULL, 0x000fe2000001160eULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000010ff4e7819ULL, 0x000fe4000001160fULL, 0x000000ff3f5a7812ULL, 0x000fe200078ec0ffULL,
0x2000005bff3f7230ULL, 0x000fe20000004100ULL, 0x0000ffff0e0e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4f7819ULL, 0x000fe40000011610ULL, 0x00000059ff5b723eULL, 0x000fe400020006ffULL,
0x00000058ff59723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe20000011644ULL,
0x2000005bff447230ULL, 0x000fe20000004100ULL, 0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x20000059ff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff0e7819ULL, 0x000fc4000001160eULL,
0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff0f517812ULL, 0x000fe400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff0f7819ULL, 0x000fe40000011611ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x2000005aff5b7230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x0000000218188231ULL, 0x082fe200003400ffULL,
0x00000008ff537819ULL, 0x000fe20000011653ULL, 0x000000021a1a8231ULL, 0x000fe200003400ffULL,
0x0000000eff0e723eULL, 0x000fe200020006ffULL, 0x2000004eff5a7230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x0000000019198231ULL, 0x080fe200003400ffULL,
0x00000008ff517819ULL, 0x000fe20000011651ULL, 0x000000001b1b8231ULL, 0x000fe200003400ffULL,
0x000000ff0f0f7812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4e7230ULL, 0x000fe20000004100ULL,
0x0000ffff10107812ULL, 0x000fc400078ec0ffULL, 0x000000ff0d597812ULL, 0x000fe200078ec0ffULL,
0x20000058ff0d7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x2000000eff587230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x0000000fff4f723eULL, 0x000fe200020006ffULL, 0x20000053ff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff0e7819ULL, 0x000fe20000011612ULL, 0x20000051ff537230ULL, 0x000fe20000004100ULL,
0x00000008ff107819ULL, 0x000fe20000011610ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff137819ULL, 0x000fc40000011613ULL, 0x00000010ff127819ULL, 0x000fe4000001165bULL,
0x00000010ff0f7819ULL, 0x000fe4000001165cULL, 0x000090000c0c7811ULL, 0x000fe400078e20ffULL,
0x00000010ff51723eULL, 0x000fe400020006ffULL, 0x0000105412127816ULL, 0x000fe40000000013ULL,
0x000010540f137816ULL, 0x000fe2000000000eULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff107819ULL, 0x000fc4000001160dULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x0000ffff11117812ULL, 0x000fe400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x000000121834723cULL, 0x000b620000041834ULL, 0x00000008ff5b7819ULL, 0x000fe40000011611ULL,
0x00000010ff577819ULL, 0x000fe20000011657ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff117819ULL, 0x000fc4000001165dULL,
0x0000105457107816ULL, 0x000fe40000000010ULL, 0x0000105452117816ULL, 0x000fe40000000011ULL,
0x000000ff14127812ULL, 0x020fe400078ec0ffULL, 0x00000010ff147819ULL, 0x000fe40000011615ULL,
0x00000010ff157819ULL, 0x000fe40000011641ULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000012ff57723eULL, 0x000fe400020006ffULL,
0x000000101810723cULL, 0x000b620000041830ULL, 0x0000105459147816ULL, 0x000fe40000000014ULL,
0x000010545a157816ULL, 0x000fe40000000015ULL, 0x00000010ff177819ULL, 0x000fe40000011617ULL,
0x000000ff16307812ULL, 0x020fc400078ec0ffULL, 0x00000010ff167819ULL, 0x000fe40000011640ULL,
0x00000010ff407819ULL, 0x000fe20000011658ULL, 0x000000020c0c8231ULL, 0x082fe200003400ffULL,
0x00000010ff417819ULL, 0x000fe20000011653ULL, 0x000000020e0e8231ULL, 0x000fe200003400ffULL,
0x0000105417407816ULL, 0x000fe20000000040ULL, 0x000000000d0d8231ULL, 0x080fe200003400ffULL,
0x0000105416417816ULL, 0x000fe20000000041ULL, 0x000000000f0f8231ULL, 0x000fe200003400ffULL,
0x000000141814723cULL, 0x000be2000004182cULL, 0x00000030ff30723eULL, 0x000fe200020006ffULL,
0x20000057ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fc4000001164dULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff2c7819ULL, 0x020fe40000011643ULL,
0x00000010ff2d7819ULL, 0x000fe2000001164eULL, 0x20000030ff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fe2000001164fULL, 0x000000004c30783bULL, 0x000e620000004200ULL,
0x000010542d2c7816ULL, 0x000fe4000000002cULL, 0x000010542e2d7816ULL, 0x000fc4000000004dULL,
0x00000042ff2f723eULL, 0x000fe400020006ffULL, 0x000000401840723cULL, 0x000b620000041828ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000008ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff4b7819ULL, 0x000fe2000001164bULL, 0x2000005bff527230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x020fe2000001164aULL, 0x2000002fff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff287819ULL, 0x000fe20000011651ULL, 0x0000002c0c2c723cULL, 0x000be20000041834ULL,
0x00000010ff527819ULL, 0x000fe20000011652ULL, 0x000000005034783bULL, 0x020ea20000004200ULL,
0x00000047ff2b723eULL, 0x000fc400020006ffULL, 0x0000105429287816ULL, 0x000fe40000000028ULL,
0x000010544b297816ULL, 0x000fe20000000052ULL, 0x2000002bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff2a7819ULL, 0x000fe40000011653ULL,
0x00000010ff477819ULL, 0x000fe40000011646ULL, 0x000010542a467816ULL, 0x000fc40000000045ULL,
0x000000280c28723cULL, 0x000be20000041810ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff117819ULL, 0x020fe4000001164bULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x000010543f107816ULL, 0x000fc4000000004aULL, 0x0000105444117816ULL, 0x000fe40000000011ULL,
0x000010544e477816ULL, 0x000fe40000000047ULL, 0x000000ff31447812ULL, 0x002fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x000fe20000011630ULL, 0x000000100c10723cULL, 0x000be20000041840ULL,
0x00000010ff597819ULL, 0x000fe40000011631ULL, 0x00000018ff457819ULL, 0x000fc40000011632ULL,
0x00000010ff527819ULL, 0x000fe40000011633ULL, 0x00000018ff427819ULL, 0x020fe20000011631ULL,
0x000000460c14723cULL, 0x000be20000041814ULL, 0x0000ffff313f7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff32517812ULL, 0x000fe400078ec0ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x000000ff30417812ULL, 0x000fc400078ec0ffULL, 0x00000010ff317819ULL, 0x000fe20000011632ULL,
0x20000044ff577230ULL, 0x000fe20000004100ULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x004fe40000011634ULL,
0x0000ffff30587812ULL, 0x000fe400078ec0ffULL, 0x000000ff334c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011637ULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x000000ff52527812ULL, 0x000fe400078ec0ffULL, 0x000000ff32467812ULL, 0x020fe400078ec0ffULL,
0x00000008ff517819ULL, 0x000fe40000011651ULL, 0x00000018ff407819ULL, 0x000fc40000011630ULL,
0x000000ff355e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011635ULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000041ff537230ULL, 0x000fe20000004100ULL,
0x000000ff31317812ULL, 0x000fc400078ec0ffULL, 0x0000ffff334e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x000fe40000011634ULL, 0x000000ff344d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff307819ULL, 0x000fe40000011635ULL, 0x00000010ff327819ULL, 0x000fe40000011636ULL,
0x000000ff36607812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011636ULL,
0x0000ffff364a7812ULL, 0x000fe400078ec0ffULL, 0x0000005cff44723eULL, 0x000fe400020006ffULL,
0x0000ffff34347812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4b7819ULL, 0x000fe20000011637ULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x000000ff37617812ULL, 0x000fc400078ec0ffULL,
0x0000ffff37437812ULL, 0x000fe400078ec0ffULL, 0x0000004cff36723eULL, 0x000fe200020006ffULL,
0x20000045ff4c7230ULL, 0x000fe20000004100ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x0000005bff5c723eULL, 0x000fe200020006ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000046ff37723eULL, 0x000fc400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x0000005eff46723eULL, 0x000fe200020006ffULL,
0x20000059ff5e7230ULL, 0x000fe20000004100ULL, 0x0000005dff45723eULL, 0x000fe200020006ffULL,
0x2000005aff5d7230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe2000001163fULL,
0x2000005cff3f7230ULL, 0x000fe20000004100ULL, 0x00000031ff31723eULL, 0x000fe200020006ffULL,
0x20000052ff597230ULL, 0x000fe20000004100ULL, 0x00000018ff477819ULL, 0x000fe20000011633ULL,
0x20000051ff527230ULL, 0x000fe20000004100ULL, 0x00000008ff4e7819ULL, 0x000fe2000001164eULL,
0x20000031ff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff30307812ULL, 0x000fe200078ec0ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000040ff33723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000008ff347819ULL, 0x000fe20000011634ULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x0000005bff5c723eULL, 0x000fe200020006ffULL, 0x20000058ff5b7230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x20000042ff507230ULL, 0x000fe20000004100ULL,
0x00000030ff51723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x2000004eff587230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fe20000011653ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff317819ULL, 0x000fe20000011657ULL, 0x20000034ff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x0000ffff35357812ULL, 0x000fe400078ec0ffULL, 0x000010545d307816ULL, 0x000fe40000000030ULL,
0x000010545e317816ULL, 0x000fe40000000031ULL, 0x000000ff32327812ULL, 0x000fe400078ec0ffULL,
0x00000010ff337819ULL, 0x000fc40000011633ULL, 0x00000010ff347819ULL, 0x000fe4000001165bULL,
0x00000008ff537819ULL, 0x000fe40000011635ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff357819ULL, 0x000fe4000001165cULL, 0x00000032ff57723eULL, 0x000fe400020006ffULL,
0x0000105433347816ULL, 0x000fc40000000034ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x000000301830723cULL, 0x000be20000041824ULL, 0x0000105450357816ULL, 0x000fe20000000035ULL,
0x20000057ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe40000011637ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff247819ULL, 0x020fe40000011636ULL,
0x00000010ff367819ULL, 0x000fc4000001165aULL, 0x0000004dff40723eULL, 0x000fe200020006ffULL,
0x20000047ff4d7230ULL, 0x000fe20000004100ULL, 0x0000105436367816ULL, 0x000fe40000000037ULL,
0x0000105459377816ULL, 0x000fe20000000024ULL, 0x20000040ff477230ULL, 0x000fe20000004100ULL,
0x000000341824723cULL, 0x000b620000041838ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x00000010ff357819ULL, 0x020fe2000001164cULL, 0x00000036181c723cULL, 0x000f62000004181cULL,
0x00000010ff347819ULL, 0x000fe20000011652ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010544d357816ULL, 0x000fe40000000058ULL, 0x00000060ff42723eULL, 0x000fc400020006ffULL,
0x00000061ff41723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x000000341818723cULL, 0x000b620000041820ULL, 0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff4a7819ULL, 0x000fe2000001164aULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff437819ULL, 0x000fe20000011643ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x020fc40000011644ULL,
0x00000010ff207819ULL, 0x000fe4000001164eULL, 0x00000010ff227819ULL, 0x000fe40000011645ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x0000005fff40723eULL, 0x000fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000105421207816ULL, 0x000fe20000000020ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000105422217816ULL, 0x000fe20000000053ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff427819ULL, 0x000fc40000011642ULL,
0x00000010ff237819ULL, 0x000fe40000011650ULL, 0x00000010ff417819ULL, 0x000fe20000011641ULL,
0x000000200c24723cULL, 0x000b620000041824ULL, 0x00000010ff347819ULL, 0x000fe4000001164bULL,
0x0000105423227816ULL, 0x000fe40000000042ULL, 0x0000105434237816ULL, 0x000fe40000000041ULL,
0x00000010ff367819ULL, 0x000fc40000011647ULL, 0x00000010ff377819ULL, 0x000fe40000011646ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff387819ULL, 0x000fe40000011651ULL,
0x00000010ff217819ULL, 0x020fe40000011640ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff347819ULL, 0x000fc4000001163fULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x000010544f367816ULL, 0x000fe40000000036ULL, 0x0000105438377816ULL, 0x000fe40000000037ULL,
0x00001054214a7816ULL, 0x000fe4000000004aULL, 0x00001054344b7816ULL, 0x000fe20000000043ULL,
0x000000220c20723cULL, 0x040b70000004181cULL, 0x000000360c30723cULL, 0x040b700000041830ULL,
0x0000004a0c1c723cULL, 0x000b620000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x00000000040c7f8cULL, 0x0202a2000c80043fULL, 0x0000000148487810ULL, 0x000fc40007ffe0ffULL,
0x0000f6a0720e7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000eff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff187224ULL, 0x004fe200078e000dULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff433000007947ULL, 0x000fea000383ffffULL,
0x000000ff0800720cULL, 0x008fe20003f05270ULL, 0x000000ffff0d7224ULL, 0x002fe400078e0011ULL,
0x000000ffff097224ULL, 0x000fd400078e0010ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000003d007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000d47000047802ULL, 0x000fc40000000f00ULL,
0x00007f8000007944ULL, 0x014fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003d00007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x006fc8000000003dULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x00000002ff067819ULL, 0x012fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000002c002c7220ULL, 0x042fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x040fe20000410000ULL, 0x0000000900097220ULL, 0x040fe20000410000ULL,
0x0000000d000d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x000fe20000410000ULL, 0x0000002e042e7220ULL, 0x044fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000010000b067824ULL, 0x010fe200078e00ffULL, 0x000000242524723eULL, 0x000fc400000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000202120723eULL, 0x000fe400000010ffULL,
0x000000161716723eULL, 0x000fe400000010ffULL, 0x000000121312723eULL, 0x000fc400000010ffULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x000000262719723eULL, 0x000fe400000010ffULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000541032187816ULL, 0x000fe40000000019ULL,
0x00000002ff057819ULL, 0x002fe40000011600ULL, 0x0000000200027812ULL, 0x004fc400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x00000008050f7824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000763232197816ULL, 0x000fe40000000019ULL, 0xfffffff80e0e7812ULL, 0x000fc400078ee203ULL,
0x0000100006037812ULL, 0x000fe400078ee2ffULL, 0xfffffff807087812ULL, 0x040fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x0000080054057824ULL, 0x000fe200078e0203ULL,
0x0000000404067810ULL, 0x040fe40007ffe0ffULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0a7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x0000002c2d02723eULL, 0x000fe200000010ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x000000282904723eULL, 0x000fe200000010ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x00007632160f7816ULL, 0x000fe20000000012ULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000541002107816ULL, 0x040fe20000000004ULL,
0x00000001070e7824ULL, 0x040fe200078e020eULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x000000141502723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000090d04723eULL, 0x000fe200000010ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000303105723eULL, 0x000fc400000010ffULL, 0x0000763202077816ULL, 0x140fe40000000004ULL,
0x0000541002067816ULL, 0x002fe40000000004ULL, 0x0000001c1d10723eULL, 0x000fe400000010ffULL,
0x0000002e2f02723eULL, 0x000fe200000010ffULL, 0x0000000608007388ULL, 0x0003e20000000a00ULL,
0x0000002a2b04723eULL, 0x000fe400000010ffULL, 0x0000001e1f11723eULL, 0x000fc800000010ffULL,
0x0000763222097816ULL, 0x000fe40000000011ULL, 0x0000541005067816ULL, 0x142fe40000000024ULL,
0x0000763205077816ULL, 0x000fe40000000024ULL, 0x000000ff00057306ULL, 0x000fe60000209400ULL,
0x000000060a007388ULL, 0x0003e40000000a00ULL, 0x0000541020067816ULL, 0x002fc40000000010ULL,
0x0000763220077816ULL, 0x000fca0000000010ULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x0000541002067816ULL, 0x142fe40000000004ULL, 0x0000763202077816ULL, 0x000fe20000000004ULL,
0x0000000177027824ULL, 0x000fe200078e0200ULL, 0x000000ff00047306ULL, 0x000e660000205400ULL,
0x000000060e007388ULL, 0x0005e40000000a00ULL, 0x00005410160e7816ULL, 0x004fe20000000012ULL,
0x0000001002067824ULL, 0x000fe200078e0203ULL, 0x000000040500720bULL, 0x002fc40003f1d000ULL,
0x000000ff00027245ULL, 0x000fe2000020d400ULL, 0x0004000e08007388ULL, 0x0003e80000000a00ULL,
0x000400180a007388ULL, 0x000fec0000000a00ULL, 0x0000000102020812ULL, 0x000fc400078efcffULL,
0x0000541022087816ULL, 0x002fe40000000011ULL, 0x00000002020d723eULL, 0x000fe400000010ffULL,
0x000000ff5400720cULL, 0x000fe20003f05270ULL, 0x000400080c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000006107984ULL, 0x000e680000000c00ULL,
0x0004000006187984ULL, 0x000ea80000000c00ULL, 0x0008000006147984ULL, 0x000ee80000000c00ULL,
0x000c0000061c7984ULL, 0x000ee20000000c00ULL, 0x3f803f800d137831ULL, 0x002fc40000200013ULL,
0x3f803f800d127831ULL, 0x040fe40000200012ULL, 0x3f803f800d117831ULL, 0x040fe40000200011ULL,
0x3f803f800d107831ULL, 0x040fe40000200010ULL, 0x3f803f800d1b7831ULL, 0x044fe4000020001bULL,
0x3f803f800d1a7831ULL, 0x040fe4000020001aULL, 0x3f803f800d197831ULL, 0x000fc40000200019ULL,
0x3f803f800d187831ULL, 0x000fe40000200018ULL, 0x3f803f8013137831ULL, 0x008fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fe40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fe40000200014ULL, 0x3f803f801b1b7831ULL, 0x000fc4000020001fULL,
0x3f803f801a1a7831ULL, 0x000fe2000020001eULL, 0x0000001006007388ULL, 0x000fe20000000c00ULL,
0x3f803f8019197831ULL, 0x000fe4000020001dULL, 0x3f803f8018187831ULL, 0x000fca000020001cULL,
0x0004001806007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fc80000011600ULL,
0x000000750700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107027824ULL, 0x100fe200078e0200ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00005a0074747a19ULL, 0x000fe200000006ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000702057812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x000000010b0b7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff805027812ULL, 0x000fe200078ef800ULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00000007000a7812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000001076027824ULL, 0x000fe400078e0207ULL, 0x000000080b077824ULL, 0x000fe200078e020aULL,
0x00000000040c7984ULL, 0x0004e40000000c00ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011602ULL, 0x00000006040472a4ULL, 0x002fc4000f8e023fULL,
0x0000000174057824ULL, 0x000fc800078e0205ULL, 0x0000007b06057224ULL, 0x000fe200078e0205ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x000000047b027c24ULL, 0x000fc6000f8e02ffULL,
0x00000003ff097819ULL, 0x000fe40000011606ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x004fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f4408ULL, 0x000000750900720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe200078e0209ULL,
0x0000004000087810ULL, 0x000fe20007ffe0ffULL, 0x0000001076097824ULL, 0x000fc600078e0209ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000509057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x00005a00ff047a19ULL, 0x000fe20000011609ULL,
0x0000000174057824ULL, 0x000fe200078e0205ULL, 0x00000003ff097819ULL, 0x000fe40000011608ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000007b04057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x000000080b077824ULL, 0x002fc800078e0206ULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440aULL, 0x000000750900720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000108047824ULL, 0x102fe200078e0209ULL,
0x0000006000007810ULL, 0x000fe20007ffe0ffULL, 0x0000001076097824ULL, 0x000fc600078e0209ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef808ULL,
0x0000000509057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x00005a00ff047a19ULL, 0x000fe20000011609ULL,
0x0000000174057824ULL, 0x000fe200078e0205ULL, 0x00000003ff097819ULL, 0x000fe20000011600ULL,
0x000000080b077824ULL, 0x000fe200078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000007b04057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000100067824ULL, 0x002fc800078e0209ULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440aULL,
0x000000750900720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000706077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807067812ULL, 0x000fe200078ef800ULL,
0x0000000c04007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000001076097824ULL, 0x000fc600078e0209ULL, 0x00000000060c7984ULL, 0x002e620000000c00ULL,
0x000000080b057824ULL, 0x000fe200078e0200ULL, 0x0000000509037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fc60000011609ULL, 0x0000000174037824ULL, 0x000fc800078e0203ULL,
0x0000007b04037224ULL, 0x000fca00078e0203ULL, 0x0000000302037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000090b00720cULL, 0x000fda0003f06070ULL, 0x000000026f028824ULL, 0x000fc800078e00ffULL,
0x00006800020f8a24ULL, 0x000fe400078e020bULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x000064000f0e8625ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000080e028981ULL, 0x000ea2000c1e1900ULL, 0x00006c00ff107624ULL, 0x000fe400078e00ffULL,
0x00006d00ff117624ULL, 0x000fe200078e00ffULL, 0x00f60000ff067f8cULL, 0x002e68000c80043fULL,
0x0000000810057981ULL, 0x000722000c1e9900ULL, 0x000001ff0d00780cULL, 0x000fe20003f04070ULL,
0x000000406e6e7824ULL, 0x000fc400078e00ffULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000400b737824ULL, 0x000fe400078e00ffULL, 0x0000004074037824ULL, 0x000fe400078e00ffULL,
0x0000006e020c7224ULL, 0x004fc800078e02ffULL, 0x000062000c0c7625ULL, 0x000fe200078e000dULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff237819ULL, 0x00afe40000011649ULL,
0x0000004949147211ULL, 0x000fe400078fe8ffULL, 0x00000008231d7810ULL, 0x000fe20007ffe0ffULL,
0x0000004074747824ULL, 0x000fe200078e0223ULL, 0x00000003141c7812ULL, 0x000fe400078ec0ffULL,
0x000010000b1e7811ULL, 0x000fe200078e68ffULL, 0x00000080740e7825ULL, 0x040fe200078e00ffULL,
0x0000000874107810ULL, 0x000fc40007ffe0ffULL, 0x0000001074127810ULL, 0x000fe40007ffe0ffULL,
0x000000300e177812ULL, 0x100fe200078ef804ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000002874147810ULL, 0x000fe40007ffe0ffULL, 0x000000170c167210ULL, 0x000fe20007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000003010197812ULL, 0x100fe400078ef804ULL,
0x000000730a107217ULL, 0x000fe20007800000ULL, 0x000000010d177824ULL, 0x000fe200000e060fULL,
0x0000003012157812ULL, 0x000fc400078ef804ULL, 0x000000190c187210ULL, 0x000fe20007f3e0ffULL,
0x00000001101a7824ULL, 0x000fe200078e0a73ULL, 0x000000150c0e7210ULL, 0x000fe40007f5e0ffULL,
0x0000002074127810ULL, 0x040fe20007ffe0ffULL, 0x000000010d197824ULL, 0x040fe200008e0611ULL,
0x0000001874117810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0f7824ULL, 0x000fe200010e0613ULL,
0x0000001a1d00720cULL, 0x080fe20003f26070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000001a2300720cULL, 0x000fc40003f06070ULL, 0x0ffffffc1c497812ULL, 0x000fe200078ef849ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x0000003012157812ULL, 0x000fe400078ef804ULL,
0x0000001023277810ULL, 0x000fe20007ffe0ffULL, 0x000000041d1d7824ULL, 0x000fe200078e00ffULL,
0x000000150c127210ULL, 0x000fe20007f7e0ffULL, 0x0000001049497824ULL, 0x000fe200078e021eULL,
0x00000030101b7812ULL, 0x000fe400078ef804ULL, 0xfffffffc1d157812ULL, 0x000fe200078ee21cULL,
0x000000010d137824ULL, 0x000fe200018e0613ULL, 0x0000001b0c107210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016497faeULL, 0x0003e2000c101c48ULL,
0x00000020231d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010151b7824ULL, 0x000fe200078e021eULL,
0x00000028231f7810ULL, 0x040fe20007ffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003023217810ULL, 0x000fc40007ffe0ffULL, 0x00000000181b7faeULL, 0x0005e2000c901c48ULL,
0x0000001823297810ULL, 0x000fe20007ffe0ffULL, 0x000000010d117824ULL, 0x000fe200010e0611ULL,
0x0000003014257812ULL, 0x000fe400078ef804ULL, 0x0000003074147810ULL, 0x040fe20007ffe0ffULL,
0x000000041d177824ULL, 0x002fe200078e00ffULL, 0x0000003874167810ULL, 0x000fe40007ffe0ffULL,
0x0000001a2700720cULL, 0x080fe40003fa6070ULL, 0x0000003823237810ULL, 0x000fe20007ffe0ffULL,
0x00000004271b7824ULL, 0x004fe200078e00ffULL, 0x000000250c187210ULL, 0x000fe20007fde0ffULL,
0x000000041f257824ULL, 0x040fe200078e00ffULL, 0x0000001a1f00720cULL, 0x080fe20003f46070ULL,
0x0000000421277824ULL, 0x040fe200078e00ffULL, 0x0000001a2100720cULL, 0x080fe20003f26070ULL,
0x000000010d197824ULL, 0x000fe200030e0615ULL, 0x0000001a2900720cULL, 0x000fe20003f86070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffffc171f7812ULL, 0x000fc400078ee21cULL,
0x0000001a1d00720cULL, 0x080fe20003f66070ULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0x0000003014217812ULL, 0x000fe200078ef804ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001a2300720cULL, 0x040fe40003f06070ULL, 0x000000210c147210ULL, 0x000fe20007fde0ffULL,
0x00000004232b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee21cULL,
0x000000101f1f7824ULL, 0x000fe200078e021eULL, 0xfffffffc27237812ULL, 0x100fe200078ee21cULL,
0x000000010d157824ULL, 0x000fe200030e0615ULL, 0xfffffffc291d7812ULL, 0x000fe200078ee21cULL,
0x000000101b1b7824ULL, 0x000fe200078e021eULL, 0x0000003016277812ULL, 0x000fe200078ef804ULL,
0x0000001023237824ULL, 0x000fe200078e021eULL, 0xfffffffc25217812ULL, 0x000fe200078ee21cULL,
0x000000101d1d7824ULL, 0x000fe200078e021eULL, 0xfffffffc2b257812ULL, 0x000fe200078ee21cULL,
0x000000000e1b7faeULL, 0x0003e2000e901c48ULL, 0x000000270c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001021217824ULL, 0x000fc400078e021eULL, 0x0000001025257824ULL, 0x000fe200078e021eULL,
0x00000000101d7faeULL, 0x0003e2000e101c48ULL, 0x000000010d0d7824ULL, 0x000fc600030e0617ULL,
0x00000000121f7faeULL, 0x0003e8000d901c48ULL, 0x0000000018217faeULL, 0x0003e8000d101c48ULL,
0x0000000014237faeULL, 0x0003e8000c901c48ULL, 0x000000000c257faeULL, 0x0003e2000c101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000849107811ULL, 0x04afe400078ff0ffULL,
0x0000001049127811ULL, 0x000fc400078ff0ffULL, 0x0000001849167811ULL, 0x040fe200078ff0ffULL,
0x0000000410117824ULL, 0x000fe200078e00ffULL, 0x00000020491e7811ULL, 0x040fe200078ff0ffULL,
0x0000000412157824ULL, 0x000fe200078e00ffULL, 0x0000002849207811ULL, 0x040fe200078ff0ffULL,
0x0000000416177824ULL, 0x000fe200078e00ffULL, 0x0000003049227811ULL, 0x040fe200078ff0ffULL,
0x000000041e197824ULL, 0x000fe200078e00ffULL, 0x0000003849247811ULL, 0x040fe200078ff0ffULL,
0x0000000420137824ULL, 0x000fe200078e00ffULL, 0x00000003490e7211ULL, 0x040fe200078ff0ffULL,
0x00000004221b7824ULL, 0x000fe200078e00ffULL, 0x00000049490f7211ULL, 0x000fe200078fe8ffULL,
0x00000004241d7824ULL, 0x000fe200078e00ffULL, 0x000010000b267811ULL, 0x000fe200078e68ffULL,
0x0000000103127824ULL, 0x000fe200078e0212ULL, 0x000000030f1c7812ULL, 0x000fe200078ec0ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x0ffffffc1c497812ULL, 0x000fe200078ef849ULL,
0x0000000103107824ULL, 0x000fe200078e0210ULL, 0xfffffffc11147812ULL, 0x100fe400078ee21cULL,
0xfffffffc15157812ULL, 0x100fe200078ee21cULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffffc17177812ULL, 0x100fe400078ee21cULL, 0xfffffffc19197812ULL, 0x000fe200078ee21cULL,
0x0000001015217824ULL, 0x000fe200078e0226ULL, 0xfffffffc131a7812ULL, 0x100fe200078ee21cULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffffc1b1b7812ULL, 0x000fc400078ee21cULL,
0xfffffffc1d1c7812ULL, 0x000fe200078ee21cULL, 0x0000001019257824ULL, 0x000fe200078e0226ULL,
0x000000300e1d7812ULL, 0x000fe200078ef804ULL, 0x00000001030e7824ULL, 0x040fe200078e0216ULL,
0x0000003010157812ULL, 0x000fe200078ef804ULL, 0x000000101c2b7824ULL, 0x100fe200078e0226ULL,
0x0000001d0c187210ULL, 0x000fe20007f1e0ffULL, 0x000000101a277824ULL, 0x000fe200078e0226ULL,
0x00000030121d7812ULL, 0x000fe200078ef804ULL, 0x0000000103107824ULL, 0x000fe200078e021eULL,
0x000000150c1a7210ULL, 0x040fe20007f3e0ffULL, 0x000000010d197824ULL, 0x000fe200000e060fULL,
0x0000001d0c1c7210ULL, 0x000fe20007f5e0ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000010d1d7824ULL, 0x000fe200010e0613ULL, 0x000000300e137812ULL, 0x000fe200078ef804ULL,
0x00000010141f7824ULL, 0x000fe400078e0226ULL, 0x0000000103127824ULL, 0x000fe200078e0220ULL,
0x000000130c0e7210ULL, 0x000fe20007f1e0ffULL, 0x000000101b297824ULL, 0x000fe400078e0226ULL,
0x0000000103147824ULL, 0x000fe400078e0222ULL, 0x000000010d1b7824ULL, 0x000fc400008e0611ULL,
0x0000000103167824ULL, 0x000fe400078e0224ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000003010337812ULL, 0x000fc600078ef804ULL,
0x0000001017237824ULL, 0x000fe200078e0226ULL, 0x0000003012317812ULL, 0x000fe200078ef804ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x000000310c127210ULL, 0x000fe20007f3e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000030142f7812ULL, 0x000fc600078ef804ULL,
0x000000010d0f7824ULL, 0x000fe200000e060fULL, 0x00000030162d7812ULL, 0x000fe200078ef804ULL,
0x0000001049497824ULL, 0x000fe200078e0226ULL, 0x000000330c107210ULL, 0x040fe20007f1e0ffULL,
0x000000010d137824ULL, 0x040fe200008e0613ULL, 0x0000002f0c147210ULL, 0x040fe40007f5e0ffULL,
0x0000002d0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d117824ULL, 0x040fe200000e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018497faeULL, 0x0003e2000b901c48ULL,
0x000000010d157824ULL, 0x000fc400010e0615ULL, 0x000000010d0d7824ULL, 0x000fe200018e0617ULL,
0x000000001a1f7faeULL, 0x0003e8000b901c48ULL, 0x000000001c217faeULL, 0x0003e8000b901c48ULL,
0x000000000e237faeULL, 0x0003e8000b901c48ULL, 0x0000000010257faeULL, 0x0003e8000b901c48ULL,
0x0000000012277faeULL, 0x0003e8000b901c48ULL, 0x0000000014297faeULL, 0x0003e8000b901c48ULL,
0x000000000c2b7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000c7805ULL, 0x002fc40000015200ULL, 0x00f60400ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140fULL, 0x0000001104047211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x0000000204047819ULL, 0x000fc8000000120fULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x000000200b047824ULL, 0x002fca00078e0204ULL, 0x00000003ff067819ULL, 0x000fc80000011604ULL,
0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL, 0x0000000f04067812ULL, 0x000fc600078ec0ffULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x00000010060d7824ULL, 0x040fe400078e00ffULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000f07047812ULL, 0x040fe400078ec0ffULL,
0x0000000107077810ULL, 0x000fe40007ffe0ffULL, 0x000000f00d047812ULL, 0x000fe400078ee204ULL,
0x0000000f07077812ULL, 0x000fc600078ec0ffULL, 0x0000000004107984ULL, 0x000e62000000cc00ULL,
0x000000f006077812ULL, 0x000fca00078ee207ULL, 0x00000000070c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001404007388ULL, 0x0003e8000000cc00ULL, 0x0000001007007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff0e7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff107224ULL, 0x002fc600078e00ffULL, 0x0000000000067805ULL, 0x000fc80000015200ULL,
0x00f60400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x006fc4000780480fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c06117210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e07ULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140dULL, 0x0000001104047211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x0000000204047819ULL, 0x000fc8000000120dULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x00005800ff0f7624ULL, 0x000fe200078e00ffULL, 0x800058000a707a10ULL, 0x000fe20007ffe0ffULL,
0x000068006f6f7a24ULL, 0x000fe200078e02ffULL, 0x3db504f305057820ULL, 0x010fe20000410000ULL,
0x0000f6880b727811ULL, 0x000fe200078e18ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000001f0f0d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e000bULL,
0x0000f6080b747811ULL, 0x000fe400078e28ffULL, 0x00000004ff0e7819ULL, 0x000fc4000001160dULL,
0xffffffff0f717810ULL, 0x040fe40007ffe0ffULL, 0x000000090f0d7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff707819ULL, 0x000fe40000011670ULL, 0x0ffffffe0e0e7812ULL, 0x000fc400078ec0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0007ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x018fc4000001ff00ULL, 0x000000013800780cULL, 0x000fe20003f25270ULL,
0x00000080ff187424ULL, 0x020fe200078e00ffULL, 0x00000001061a7810ULL, 0x000fe20007ffe0ffULL,
0x0000006e02157224ULL, 0x010fe200078e02ffULL, 0x0000000138147810ULL, 0x000fe20007ffe0ffULL,
0x00000ba000007945ULL, 0x000fe20003800000ULL, 0x000000ffff397224ULL, 0x000fc400078e0038ULL,
0x000000021400780cULL, 0x040fe20003f06070ULL, 0x000000ffff387224ULL, 0x000fe200078e0014ULL,
0x000000ff14167207ULL, 0x000fe20000800000ULL, 0x0000620015147625ULL, 0x000fc800078e0018ULL,
0x000000ffff1a1224ULL, 0x000fca00078e0206ULL, 0x000000011a077810ULL, 0x000fc80007ffe0ffULL,
0x000000080700720cULL, 0x000fe40003f46070ULL, 0x000000010f077812ULL, 0x000fd600078e0cffULL,
0x000005e00000a947ULL, 0x000fea0003800000ULL, 0x0000001004177824ULL, 0x002fe200078e00ffULL,
0x00000002ff447819ULL, 0x000fe20000011604ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000020b427824ULL, 0x000fe200078e0207ULL, 0x0000003017177812ULL, 0x000fe200078ec0ffULL,
0x00000001031b7824ULL, 0x000fe200078e0244ULL, 0x0000000844467810ULL, 0x040fe40007ffe0ffULL,
0x0000001044487810ULL, 0x000fe20007ffe0ffULL, 0x0000004016187824ULL, 0x000fe200078e0217ULL,
0x00000018444a7810ULL, 0x000fe20007ffe0ffULL, 0x000001001a177824ULL, 0x000fe200078e0273ULL,
0x00000020444c7810ULL, 0x000fe20007ffe0ffULL, 0x000000801b1a7825ULL, 0x000fe200078e0018ULL,
0x0000100042427811ULL, 0x000fc400078e60ffULL, 0x000000170a407217ULL, 0x000fe20007800000ULL,
0x00000001033b7824ULL, 0x040fe200078e0246ULL, 0x0000001a143c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000103417824ULL, 0x000fe200078e0248ULL, 0x00000004041a7211ULL, 0x000fe200078fe8ffULL,
0x000000803b3a7825ULL, 0x000fc600078e0018ULL, 0x000000031a4f7812ULL, 0x000fe200078ec0ffULL,
0x0000000140177824ULL, 0x000fe200078e0a17ULL, 0x0000003a143e7210ULL, 0x000fe20007f5e0ffULL,
0x00000001153d7824ULL, 0x000fe200008e061bULL, 0x0ffffffc4f437812ULL, 0x000fe200078ef804ULL,
0x0000008041407825ULL, 0x000fe200078e0018ULL, 0x000000174a00720cULL, 0x000fc60003fa6070ULL,
0x00000001031b7824ULL, 0x000fe200078e024aULL, 0x0000004014407210ULL, 0x000fe20007f3e0ffULL,
0x00000001153f7824ULL, 0x000fe200010e063bULL, 0x000000174600720cULL, 0x000fe20003f46070ULL,
0x000000801b1a7825ULL, 0x000fc800078e0018ULL, 0x0000000115417824ULL, 0x000fe200008e0641ULL,
0x0000001a141a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0x000000174400720cULL, 0x080fe20003f26070ULL, 0x00000001033b7824ULL, 0x000fe400078e024cULL,
0x00000001151b7824ULL, 0x000fe200018e061bULL, 0xfffffffc46457812ULL, 0x000fe200078ee24fULL,
0x0000001043437824ULL, 0x000fe200078e0242ULL, 0x000000174800720cULL, 0x040fe20003f66070ULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x0000002844467810ULL, 0x000fe20007ffe0ffULL,
0x000000803b3a7825ULL, 0x000fc600078e0018ULL, 0xfffffffc48477812ULL, 0x000fe200078ee24fULL,
0x0000000103497824ULL, 0x000fe200078e0246ULL, 0x0000003044487810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c437faeULL, 0x0003e2000c901c48ULL,
0x0000001045457824ULL, 0x100fe200078e0242ULL, 0x0000003a143a7210ULL, 0x000fe20007f9e0ffULL,
0x0000001047477824ULL, 0x000fe200078e0242ULL, 0x0000003844447810ULL, 0x000fe20007ffe0ffULL,
0x00000001034b7824ULL, 0x000fe200078e0248ULL, 0x000000003e457faeULL, 0x0005e2000d101c48ULL,
0x00000001153b7824ULL, 0x000fe200020e063bULL, 0x000000174c00720cULL, 0x080fe20003f86070ULL,
0x00000001034d7824ULL, 0x000fe200078e0244ULL, 0x0000000040477faeULL, 0x0007e2000d901c48ULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x000000174600720cULL, 0x080fe20003f66070ULL,
0x00000080493c7825ULL, 0x002fe200078e0018ULL, 0x000000174800720cULL, 0x000fc40003f46070ULL,
0x000000174400720cULL, 0x000fe20003f26070ULL, 0x000000044c4c7824ULL, 0x000fe200078e00ffULL,
0x0000003c143c7210ULL, 0x000fe20007fde0ffULL, 0x000000804b3e7825ULL, 0x004fe200078e0018ULL,
0xfffffffc4a177812ULL, 0x100fe400078ee24fULL, 0xfffffffc4c417812ULL, 0x008fe200078ee24fULL,
0x00000001153d7824ULL, 0x000fe200030e063dULL, 0x0000003e143e7210ULL, 0x000fe20007fde0ffULL,
0x0000000446467824ULL, 0x000fe400078e00ffULL, 0x0000000448487824ULL, 0x000fc400078e00ffULL,
0x000000804d187825ULL, 0x000fe200078e0018ULL, 0xfffffffc46437812ULL, 0x100fe400078ee24fULL,
0xfffffffc48457812ULL, 0x000fe200078ee24fULL, 0x0000000444447824ULL, 0x000fe400078e00ffULL,
0x00000001153f7824ULL, 0x000fe200030e063fULL, 0x0000001814147210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x100fe200078e0242ULL, 0xfffffffc44477812ULL, 0x000fe200078ee24fULL,
0x0000001041417824ULL, 0x000fc400078e0242ULL, 0x0000001043437824ULL, 0x100fe200078e0242ULL,
0x000000001a177faeULL, 0x0003e2000e901c48ULL, 0x0000001045457824ULL, 0x100fe400078e0242ULL,
0x0000001047477824ULL, 0x000fe200078e0242ULL, 0x000000003a417faeULL, 0x0003e2000e101c48ULL,
0x0000000115157824ULL, 0x000fc600030e0619ULL, 0x000000003c437faeULL, 0x0003e8000d901c48ULL,
0x000000003e457faeULL, 0x0003e8000d101c48ULL, 0x0000000014477faeULL, 0x0003e2000c901c48ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x000000020b187824ULL, 0x000fe200078e0207ULL,
0x00000008043a7811ULL, 0x002fc400078ff0ffULL, 0x0000000404177211ULL, 0x000fe400078fe8ffULL,
0x00001000181a7811ULL, 0x000fe200078e60ffULL, 0x000000043a187824ULL, 0x000fe200078e00ffULL,
0x00000010043c7811ULL, 0x040fe200078ff0ffULL, 0x00000001033f7824ULL, 0x000fe200078e023aULL,
0x00000018043e7811ULL, 0x040fe400078ff0ffULL, 0x0000002004407811ULL, 0x000fe200078ff0ffULL,
0x000000043c487824ULL, 0x000fe200078e00ffULL, 0x0000002804427811ULL, 0x000fe200078ff0ffULL,
0x000000043e4a7824ULL, 0x000fe200078e00ffULL, 0x0000003004447811ULL, 0x000fe200078ff0ffULL,
0x00000004404c7824ULL, 0x000fe200078e00ffULL, 0x0000003804467811ULL, 0x000fe200078ff0ffULL,
0x00000004424e7824ULL, 0x000fe200078e00ffULL, 0x0000000317177812ULL, 0x000fe200078ec0ffULL,
0x0000000444507824ULL, 0x000fe200078e00ffULL, 0x00000003043b7211ULL, 0x000fe200078ff0ffULL,
0x0000000446527824ULL, 0x000fe200078e00ffULL, 0xfffffffc18477812ULL, 0x100fe200078ee217ULL,
0x0000001004187824ULL, 0x000fe200078e00ffULL, 0xfffffffc48497812ULL, 0x100fe200078ee217ULL,
0x0000000103437824ULL, 0x000fe200078e023cULL, 0xfffffffc4a4b7812ULL, 0x100fe200078ee217ULL,
0x0000001047477824ULL, 0x100fe200078e021aULL, 0xfffffffc4c4d7812ULL, 0x100fe200078ee217ULL,
0x0000001049497824ULL, 0x100fe200078e021aULL, 0xfffffffc4e4f7812ULL, 0x100fe200078ee217ULL,
0x000000104b4b7824ULL, 0x000fe200078e021aULL, 0x0ffffffc17197812ULL, 0x000fe200078ef804ULL,
0x000000104d4d7824ULL, 0x100fe200078e021aULL, 0xfffffffc50517812ULL, 0x100fe200078ee217ULL,
0x000000104f4f7824ULL, 0x100fe200078e021aULL, 0xfffffffc52537812ULL, 0x000fe200078ee217ULL,
0x0000001019177824ULL, 0x100fe200078e021aULL, 0x00000030181b7812ULL, 0x000fe200078ec0ffULL,
0x0000001051517824ULL, 0x000fc400078e021aULL, 0x0000001053537824ULL, 0x000fe400078e021aULL,
0x00000040161a7824ULL, 0x000fe400078e021bULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x0000000103457824ULL, 0x000fe400078e023eULL, 0x000000803b3a7825ULL, 0x000fc800078e001aULL,
0x00000001033d7824ULL, 0x000fe200078e0242ULL, 0x0000003a143a7210ULL, 0x000fe20007f3e0ffULL,
0x000000803f3e7825ULL, 0x000fc800078e001aULL, 0x0000000103417824ULL, 0x040fe200078e0240ULL,
0x0000003e143e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000103197824ULL, 0x000fe400078e0244ULL,
0x0000008043427825ULL, 0x000fc800078e001aULL, 0x0000008045447825ULL, 0x000fe200078e001aULL,
0x0000004214427210ULL, 0x000fc60007f7e0ffULL, 0x0000000103557824ULL, 0x000fe200078e0246ULL,
0x0000004414447210ULL, 0x000fe20007f9e0ffULL, 0x0000008041407825ULL, 0x000fc800078e001aULL,
0x000000803d3c7825ULL, 0x000fc800078e001aULL, 0x0000008019187825ULL, 0x000fc800078e001aULL,
0x00000080551a7825ULL, 0x000fc800078e001aULL, 0x00000001153b7824ULL, 0x040fe200008e063bULL,
0x0000004014407210ULL, 0x040fe20007f3e0ffULL, 0x00000001153f7824ULL, 0x040fe200010e063fULL,
0x0000003c143c7210ULL, 0x040fe20007f5e0ffULL, 0x0000000115437824ULL, 0x040fe200018e0643ULL,
0x0000001814187210ULL, 0x040fe20007f7e0ffULL, 0x0000000115457824ULL, 0x040fe200020e0645ULL,
0x0000001a14147210ULL, 0x000fe20007f9e0ffULL, 0x0000000115417824ULL, 0x040fe200008e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a177faeULL, 0x0003e2000b901c48ULL,
0x00000001153d7824ULL, 0x000fc400010e063dULL, 0x0000000115197824ULL, 0x040fe200018e0619ULL,
0x000000003e477faeULL, 0x0003e2000b901c48ULL, 0x0000000115157824ULL, 0x000fc600020e061bULL,
0x0000000042497faeULL, 0x0003e8000b901c48ULL, 0x00000000444b7faeULL, 0x0003e8000b901c48ULL,
0x00000000404d7faeULL, 0x0003e8000b901c48ULL, 0x000000003c4f7faeULL, 0x0003e8000b901c48ULL,
0x0000000018517faeULL, 0x0003e8000b901c48ULL, 0x0000000014537faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011600780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x000000040c0c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff027424ULL, 0x000fc600078e00ffULL,
0x000000090c00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000026f147824ULL, 0x002fe400078e020cULL, 0x00000004ff157424ULL, 0x000fc800078e00ffULL,
0x0000640014147625ULL, 0x000fca00078e0015ULL, 0x0000000814027981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff3a7224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff804157812ULL, 0x020fe200078ec0ffULL, 0x000000020b3b7824ULL, 0x000fe200078e020fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000013a167810ULL, 0x000fe40007ffe0ffULL,
0x0000000715157812ULL, 0x000fe400078ef804ULL, 0x000010003b3b7811ULL, 0x000fe400078e60ffULL,
0x00000001ff177819ULL, 0x000fe20000011615ULL, 0x0000000415197824ULL, 0x040fe200078e00ffULL,
0x00000020041a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000415187824ULL, 0x000fc400078e00ffULL,
0x0000000117147824ULL, 0x040fe400078e023aULL, 0x0000000117177824ULL, 0x000fc600078e0216ULL,
0xfffffffc19147812ULL, 0x000fe400078ee214ULL, 0x0000000704197812ULL, 0x000fe400078ec0ffULL,
0xfffffffc18187812ULL, 0x000fe200078ee217ULL, 0x00000010143c7824ULL, 0x100fe200078e023bULL,
0xfffffff81a177812ULL, 0x000fe200078ec0ffULL, 0x0000000439147824ULL, 0x000fe200078e023aULL,
0x0000000819437812ULL, 0x100fe200078ef804ULL, 0x0000001018447824ULL, 0x000fe200078e023bULL,
0x00000007174a7812ULL, 0x000fe200078ef804ULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x0000000214157824ULL, 0x000fc400078e00ffULL, 0x0000001043197824ULL, 0x000fe200078e00ffULL,
0x00000001ff177819ULL, 0x000fe2000001164aULL, 0x000000044a427824ULL, 0x000fe200078e00ffULL,
0x0000001504147211ULL, 0x000fe200078fe0ffULL, 0x000000004444783bULL, 0x000ea20000000200ULL,
0x0000000215157810ULL, 0x000fe20007ffe0ffULL, 0x00000001174b7824ULL, 0x000fe400078e0216ULL,
0x0000000143147824ULL, 0x000fe400078e0214ULL, 0x0000000117177824ULL, 0x000fe200078e023aULL,
0x000000023a3a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff019147812ULL, 0x000fe400078ee214ULL,
0xfffffffc42167812ULL, 0x000fe400078ee217ULL, 0x0000001504177211ULL, 0x000fe200078fe0ffULL,
0x0000001014147824ULL, 0x000fe200078e00ffULL, 0x000000043a00780cULL, 0x000fc60003f25270ULL,
0x0000000143417824ULL, 0x040fe200078e0217ULL, 0x000000001418783bULL, 0x0006a40000000200ULL,
0x0000001043147824ULL, 0x008fca00078e00ffULL, 0xfffffff014417812ULL, 0x000fe400078ee241ULL,
0x00000010ff157819ULL, 0x102fe4000001163fULL, 0x00000018ff407819ULL, 0x000fe2000001163fULL,
0x00000010414c7824ULL, 0x000fe200078e00ffULL, 0x000000ff15177812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3f427812ULL, 0x000fe400078ec0ffULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x00000008ff157819ULL, 0x000fe20000011642ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x000000ff3f3f7812ULL, 0x000fe200078ec0ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x000fe20000011640ULL, 0x0000001016407824ULL, 0x000fe200078e023bULL,
0x00000010ff177819ULL, 0x000fe20000011617ULL, 0x20000015ff157230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fc400020006ffULL, 0x0000105414497816ULL, 0x000fe20000000017ULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x00000010ff487819ULL, 0x000fe20000011615ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x0000ffff474f7812ULL, 0x004fe200078ec0ffULL,
0x000000004c14783bULL, 0x0004e20000000200ULL, 0x00000018ff4d7819ULL, 0x000fe40000011647ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x0000004dff4d723eULL, 0x000fc400020006ffULL,
0x0000105448487816ULL, 0x000fe4000000003fULL, 0x00000010ff3f7819ULL, 0x000fe20000011647ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff47477812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f4e7812ULL, 0x000fe200078ec0ffULL, 0x000000481810723cULL, 0x000b620000041810ULL,
0x00000008ff3f7819ULL, 0x000fe4000001164fULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x000000044a487824ULL, 0x020fe200078e00ffULL, 0x00000010ff4c7819ULL, 0x004fe2000001164dULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x000000ff3c517812ULL, 0x000fe200078ec0ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0xfffffffc48487812ULL, 0x000fe200078ee24bULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000010ff497819ULL, 0x000fe2000001164eULL, 0x0000001048637824ULL, 0x000fe200078e023bULL,
0x00000010ff4a7819ULL, 0x000fe4000001163fULL, 0x000010544c497816ULL, 0x000fe40000000049ULL,
0x000010544a487816ULL, 0x000fe40000000047ULL, 0x00000018ff3f7819ULL, 0x000fe4000001163cULL,
0x00000018ff647819ULL, 0x002fc40000011641ULL, 0x000000ff415d7812ULL, 0x040fe200078ec0ffULL,
0x000000481410723cULL, 0x008be20000041810ULL, 0x0000ffff41527812ULL, 0x000fe400078ec0ffULL,
0x00000010ff627819ULL, 0x100fe40000011643ULL, 0x00000018ff557819ULL, 0x000fe40000011643ULL,
0x00000010ff497819ULL, 0x020fe40000011641ULL, 0x000000ff43417812ULL, 0x000fc400078ec0ffULL,
0x0000ffff43567812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3b7819ULL, 0x000fe4000001163cULL,
0x0000ffff3c507812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x100fe4000001163dULL,
0x00000018ff5c7819ULL, 0x000fe4000001163dULL, 0x000000ff3d5b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3d4f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x100fe4000001163eULL,
0x00000018ff687819ULL, 0x000fe4000001163eULL, 0x000000ff3e757812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3e5f7812ULL, 0x000fe400078ec0ffULL, 0x0000003fff43723eULL, 0x000fc400020006ffULL,
0x00000000633c783bULL, 0x000e620000000200ULL, 0x00000010ff597819ULL, 0x100fe40000011644ULL,
0x00000018ff667819ULL, 0x000fe40000011644ULL, 0x000000ff44577812ULL, 0x040fe400078ec0ffULL,
0x0000ffff445a7812ULL, 0x000fe200078ec0ffULL, 0x20000043ff447230ULL, 0x000fe20000004100ULL,
0x000000ff3b437812ULL, 0x000fe400078ec0ffULL, 0x00000008ff507819ULL, 0x000fc40000011650ULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000008ff4f7819ULL, 0x000fe2000001164fULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x100fe20000011642ULL, 0x2000005cff3b7230ULL, 0x000fe20000004100ULL,
0x00000018ff5e7819ULL, 0x000fe40000011642ULL, 0x000000ff42547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff42617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff477819ULL, 0x000fc40000011640ULL,
0x00000018ff657819ULL, 0x000fe40000011640ULL, 0x000000ff40607812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40487812ULL, 0x000fe400078ec0ffULL, 0x00000010ff427819ULL, 0x100fe40000011645ULL,
0x00000018ff587819ULL, 0x000fe40000011645ULL, 0x000000ff454b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff454c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff407819ULL, 0x100fe40000011646ULL,
0x00000018ff697819ULL, 0x000fe40000011646ULL, 0x000000ff46677812ULL, 0x040fe400078ec0ffULL,
0x0000ffff464d7812ULL, 0x000fe400078ec0ffULL, 0x0000004fff4f723eULL, 0x000fc400020006ffULL,
0x00000010ff457819ULL, 0x000fe40000011643ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x000fe40000011644ULL,
0x00000010ff437819ULL, 0x000fe20000011650ULL, 0x2000004eff507230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe20000011651ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fc400020006ffULL, 0x0000105443447816ULL, 0x000fe40000000044ULL,
0x00000010ff437819ULL, 0x000fe4000001163bULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff3b7819ULL, 0x000fe4000001164fULL, 0x00000010ff637819ULL, 0x102fe4000001163cULL,
0x00000018ff6d7819ULL, 0x000fc4000001163cULL, 0x000000ff3c6b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165bULL,
0x00001054434f7816ULL, 0x000fe40000000050ULL, 0x00000057ff3c723eULL, 0x000fe400020006ffULL,
0x00000010ff5b7819ULL, 0x000fc4000001163dULL, 0x00000018ff6c7819ULL, 0x000fe4000001163dULL,
0x000000ff3d437812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3d507812ULL, 0x000fe400078ec0ffULL,
0x00000066ff3d723eULL, 0x000fe200020006ffULL, 0x20000075ff667230ULL, 0x000fe20000004100ULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x00000058ff75723eULL, 0x000fe200020006ffULL,
0x2000003cff587230ULL, 0x000fe20000004100ULL, 0x000000ff4a3c7812ULL, 0x000fe200078ec0ffULL,
0x2000003dff577230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000069ff76723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000003cff69723eULL, 0x000fe200020006ffULL,
0x20000067ff3c7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000005fff677230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fc400020006ffULL,
0x00000064ff5f723eULL, 0x000fe200020006ffULL, 0x20000065ff647230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000060ff657230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x2000005dff607230ULL, 0x000fe20000004100ULL,
0x000000ff42427812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5d7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000054ff5e7230ULL, 0x000fe20000004100ULL,
0x0000105446457816ULL, 0x000fe20000000045ULL, 0x20000055ff547230ULL, 0x000fe20000004100ULL,
0x00000008ff4c7819ULL, 0x000fe2000001164cULL, 0x20000041ff557230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff40417812ULL, 0x000fe200078ec0ffULL, 0x000000441834723cULL, 0x000be20000041834ULL,
0x0000004cff40723eULL, 0x000fe200020006ffULL, 0x20000042ff4c7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fc400020006ffULL, 0x0000006dff42723eULL, 0x000fe400020006ffULL,
0x00000018ff447819ULL, 0x020fe4000001163eULL, 0x0000006cff6d723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff3e457812ULL, 0x000fe400078ec0ffULL,
0x0000004bff3d723eULL, 0x000fe200020006ffULL, 0x20000075ff4b7230ULL, 0x000fe20000004100ULL,
0x00000043ff6c723eULL, 0x000fe200020006ffULL, 0x2000006bff437230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x2000003dff4a7230ULL, 0x000fe20000004100ULL,
0x00000008ff4d7819ULL, 0x000fe2000001164dULL, 0x20000076ff3d7230ULL, 0x000fe20000004100ULL,
0x00000018ff467819ULL, 0x000fe2000001163fULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000041ff75723eULL, 0x000fc400020006ffULL, 0x00000044ff6b723eULL, 0x000fe200020006ffULL,
0x2000006dff447230ULL, 0x000fe20000004100ULL, 0x000000ff3f6a7812ULL, 0x000fe400078ec0ffULL,
0x00000045ff6d723eULL, 0x000fe200020006ffULL, 0x2000006cff457230ULL, 0x000fe20000004100ULL,
0x0000004dff41723eULL, 0x000fe200020006ffULL, 0x20000040ff4d7230ULL, 0x000fe20000004100ULL,
0x00000046ff6c723eULL, 0x000fe200020006ffULL, 0x20000075ff407230ULL, 0x000fe20000004100ULL,
0x00000008ff527819ULL, 0x000fe20000011652ULL, 0x2000006bff467230ULL, 0x000fe20000004100ULL,
0x000000ff53537812ULL, 0x000fe200078ec0ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x000000ff476b7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff477230ULL, 0x000fe20000004100ULL,
0x0000006aff75723eULL, 0x000fc400020006ffULL, 0x00000008ff6a7819ULL, 0x000fe20000011648ULL,
0x2000006cff487230ULL, 0x000fe20000004100ULL, 0x00000052ff6d723eULL, 0x000fe400020006ffULL,
0x00000053ff76723eULL, 0x000fe400020006ffULL, 0x00000010ff527819ULL, 0x000fe20000011668ULL,
0x2000006dff687230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fe40000011669ULL,
0x0000006bff6b723eULL, 0x000fc400020006ffULL, 0x000000ff496c7812ULL, 0x000fe200078ec0ffULL,
0x20000075ff497230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000010543b4e7816ULL, 0x000fe4000000004eULL,
0x0000105452537816ULL, 0x000fe40000000053ULL, 0x00000010ff527819ULL, 0x000fe40000011666ULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x0000004e1830723cULL, 0x000be20000041830ULL,
0x0000006cff75723eULL, 0x000fe200020006ffULL, 0x2000006aff6c7230ULL, 0x000fe20000004100ULL,
0x0000105467527816ULL, 0x000fc40000000052ULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x20000075ff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff63677812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x00000052182c723cULL, 0x000b64000004182cULL,
0x00000010ff4e7819ULL, 0x020fe40000011665ULL, 0x00000010ff4f7819ULL, 0x000fe4000001166bULL,
0x00000010ff637819ULL, 0x000fc4000001166cULL, 0x00000061ff75723eULL, 0x000fe200020006ffULL,
0x20000076ff617230ULL, 0x000fe20000004100ULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00001054644f7816ULL, 0x000fe4000000004fULL, 0x00001054634e7816ULL, 0x000fc4000000004eULL,
0x00000010ff647819ULL, 0x000fe4000001165fULL, 0x00000010ff527819ULL, 0x000fe40000011660ULL,
0x00000010ff537819ULL, 0x000fe2000001166aULL, 0x0000004e1828723cULL, 0x000be20000041828ULL,
0x00000010ff637819ULL, 0x000fe40000011668ULL, 0x00000062ff6d723eULL, 0x000fe200020006ffULL,
0x20000075ff627230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000105464537816ULL, 0x000fe20000000053ULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x0000105463527816ULL, 0x000fe20000000052ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000008ff697819ULL, 0x000fe20000011656ULL,
0x2000006dff567230ULL, 0x000fe20000004100ULL, 0x00000008ff607819ULL, 0x000fe4000001165cULL,
0x000000ff5b637812ULL, 0x000fe200078ec0ffULL, 0x000000521824723cULL, 0x000b620000041824ULL,
0x00000010ff5c7819ULL, 0x000fc4000001165dULL, 0x00000010ff4e7819ULL, 0x020fe4000001165eULL,
0x00000010ff4f7819ULL, 0x000fe40000011661ULL, 0x00000010ff5b7819ULL, 0x000fe40000011662ULL,
0x00000069ff66723eULL, 0x000fe400020006ffULL, 0x000010545c4f7816ULL, 0x000fe4000000004fULL,
0x000010545b4e7816ULL, 0x000fe2000000004eULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fc40000011659ULL, 0x00000010ff527819ULL, 0x000fe40000011658ULL,
0x00000010ff597819ULL, 0x000fe2000001165aULL, 0x0000004e1820723cULL, 0x000b620000041820ULL,
0x00000010ff517819ULL, 0x000fe4000001163eULL, 0x0000105459527816ULL, 0x000fe40000000052ULL,
0x000000ff51597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x000fc40000011654ULL,
0x00000010ff4e7819ULL, 0x020fe40000011655ULL, 0x00000010ff4f7819ULL, 0x000fe40000011656ULL,
0x00000010ff517819ULL, 0x000fe40000011666ULL, 0x00001054544f7816ULL, 0x000fe4000000004fULL,
0x00001054514e7816ULL, 0x000fe4000000004eULL, 0x00000008ff507819ULL, 0x000fc40000011650ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000010ff3b7819ULL, 0x000fe2000001163fULL,
0x0000004e181c723cULL, 0x000b62000004181cULL, 0x00000010ff417819ULL, 0x000fe20000011641ULL,
0x20000060ff587230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000050ff55723eULL, 0x000fe400020006ffULL, 0x00000010ff1a7819ULL, 0x020fc4000001163dULL,
0x00000010ff187819ULL, 0x000fe4000001163cULL, 0x00000010ff197819ULL, 0x000fe40000011640ULL,
0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x000010541a197816ULL, 0x000fe40000000019ULL,
0x0000105441187816ULL, 0x000fe40000000018ULL, 0x0000ffff3e3e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x000fe20000011657ULL,
0x20000063ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe2000001164dULL,
0x20000055ff4d7230ULL, 0x000fe20000004100ULL, 0x0000003bff3c723eULL, 0x000fe200020006ffULL,
0x00000018142c723cULL, 0x000b62000004182cULL, 0x00000010ff1a7819ULL, 0x000fe40000011643ULL,
0x00000010ff3b7819ULL, 0x000fe20000011658ULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000008ff3e7819ULL, 0x000fc4000001163eULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff447819ULL, 0x000fe40000011644ULL, 0x00000010ff197819ULL, 0x020fe40000011657ULL,
0x00000010ff187819ULL, 0x000fe40000011645ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x000010543b1a7816ULL, 0x000fc4000000001aULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x20000067ff5f7230ULL, 0x000fe20000004100ULL, 0x0000003fff3b723eULL, 0x000fe400020006ffULL,
0x0000105444197816ULL, 0x000fe20000000019ULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x000010544d187816ULL, 0x000fe20000000018ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fc4000001164bULL, 0x00000010ff4b7819ULL, 0x000fe2000001164cULL,
0x20000059ff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff4a7819ULL, 0x000fe2000001164aULL,
0x000000181424723cULL, 0x000b620000041824ULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff1b7819ULL, 0x000fe4000001165fULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff3f7819ULL, 0x000fc4000001164cULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff3e7819ULL, 0x000fe4000001163eULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff197819ULL, 0x020fe4000001163cULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x00000010ff187819ULL, 0x000fc4000001163bULL, 0x000010545c537816ULL, 0x000fe40000000053ULL,
0x00001054504b7816ULL, 0x000fe4000000004bULL, 0x00001054514a7816ULL, 0x000fe4000000004aULL,
0x00001054421b7816ULL, 0x000fe2000000001bULL, 0x000000521434723cULL, 0x000b620000041834ULL,
0x00001054463f7816ULL, 0x000fe4000000003fULL, 0x000010543e3e7816ULL, 0x000fc40000000047ULL,
0x0000105448197816ULL, 0x000fe40000000019ULL, 0x0000105418187816ULL, 0x000fe20000000049ULL,
0x0000004a1430723cULL, 0x040b700000041830ULL, 0x0000001a1428723cULL, 0x040b700000041828ULL,
0x0000003e1420723cULL, 0x040b700000041820ULL, 0x00000018141c723cULL, 0x000b62000004181cULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe7c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0007ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffda9000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000000530307220ULL, 0x0a0fe20000410000ULL,
0x0000000534347220ULL, 0x080fe20000410000ULL, 0x0000000535357220ULL, 0x080fe20000410000ULL,
0x000000052d2d7220ULL, 0x080fe20000410000ULL, 0x000000052c2c7220ULL, 0x080fe20000410000ULL,
0x0000000521217220ULL, 0x080fe20000410000ULL, 0x000000051c1c7220ULL, 0x080fe20000410000ULL,
0x00000005360f7220ULL, 0x080fe20000410000ULL, 0x000000052f177220ULL, 0x080fe20000410000ULL,
0x0000000537147220ULL, 0x080fe20000410000ULL, 0x0000000531387220ULL, 0x080fe20000410000ULL,
0x000000052e167220ULL, 0x080fe20000410000ULL, 0x0000000520367220ULL, 0x080fe20000410000ULL,
0x000000051f197220ULL, 0x080fe20000410000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0030ULL,
0x0000000532157220ULL, 0x080fe20000410000ULL, 0x0000000533397220ULL, 0x080fe20000410000ULL,
0x0000000510317220ULL, 0x080fe20000410000ULL, 0x00000005113c7220ULL, 0x080fe20000410000ULL,
0x0000000525377220ULL, 0x080fe20000410000ULL, 0x0000000522207220ULL, 0x080fe20000410000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0034ULL, 0x0000000512107220ULL, 0x080fe20000410000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0035ULL, 0x00000005133b7220ULL, 0x080fe20000410000ULL,
0x000000ffff307224ULL, 0x000fe200078e002dULL, 0x00000005283a7220ULL, 0x080fe20000410000ULL,
0x0000000529327220ULL, 0x080fe20000410000ULL, 0x000000052a117220ULL, 0x080fe20000410000ULL,
0x000000052b187220ULL, 0x080fe20000410000ULL, 0x0000000524337220ULL, 0x080fe20000410000ULL,
0x0000000526267220ULL, 0x080fe20000410000ULL, 0x0000000527277220ULL, 0x080fe20000410000ULL,
0x0000000523237220ULL, 0x080fe20000410000ULL, 0x000000051d257220ULL, 0x080fe20000410000ULL,
0x000000051e227220ULL, 0x000fe20000410000ULL, 0x000000ffff357224ULL, 0x000fc400078e002cULL,
0x000000ffff347224ULL, 0x000fe400078e0021ULL, 0x000000ffff2d7224ULL, 0x000fe200078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000072127f8cULL, 0x0002a2000c80043fULL,
0x000000ffff217224ULL, 0x000fe400078e0023ULL, 0x000000ffff287224ULL, 0x000fe400078e000fULL,
0x000000ffff1e7224ULL, 0x000fe400078e0014ULL, 0x000000ffff297224ULL, 0x000fc400078e0015ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0016ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0017ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0018ULL, 0x000000ffff237224ULL, 0x000fc400078e0019ULL,
0x0000000000107805ULL, 0x002fca0000015200ULL, 0x00000400720f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x006fc40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011415ULL, 0x000000140f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x000000020f0f7819ULL, 0x000fc80000001214ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400720f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000404247824ULL, 0x000fe200078e00ffULL,
0x000000700600720cULL, 0x000fc80003f06070ULL, 0xfffffff024107812ULL, 0x000fca00078ec0ffULL,
0x000000800b0f7824ULL, 0x000fca00078e0210ULL, 0x00f400000f107984ULL, 0x0002a20000000c00ULL,
0x0000136000008947ULL, 0x000fea0003800000ULL, 0x00000100063d7824ULL, 0x000fe400078e0273ULL,
0x00000002043e7824ULL, 0x000fe400078e00ffULL, 0x00000002ff537424ULL, 0x000fe200078e00ffULL,
0x0000003d0a147217ULL, 0x000fe40007800000ULL, 0x000000063e3e7812ULL, 0x000fc600078ec0ffULL,
0x00000001143d7824ULL, 0x000fe200078e0a3dULL, 0x0000000004147211ULL, 0x000fe200078ff0ffULL,
0x000000010d187824ULL, 0x000fe200078e023eULL, 0x000058003e407a10ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff167a19ULL, 0x000fe20000011614ULL, 0x00000001181a7824ULL, 0x140fe200078e0a3dULL,
0x0000003d1800720cULL, 0x000fe20003f26070ULL, 0x0000000140187824ULL, 0x000fe200078e0a3dULL,
0x0000001671157217ULL, 0x040fe40003800000ULL, 0x0000001a711a7217ULL, 0x000fc40003800000ULL,
0x0000003d4000720cULL, 0x000fe20003f06070ULL, 0x000000150e5a7224ULL, 0x000fe200078e02ffULL,
0x0000001871187217ULL, 0x000fe40003800000ULL, 0x00000004ff1a7819ULL, 0x000fe4000001161aULL,
0x000000ff184b7207ULL, 0x000fe40000000000ULL, 0x000000ff1a197207ULL, 0x000fe40000800000ULL,
0x0000005a4b167211ULL, 0x000fc400078fe0ffULL, 0x00000008141a7810ULL, 0x000fe20007ffe0ffULL,
0x000000015a187824ULL, 0x000fe200078e0219ULL, 0x000000103e467812ULL, 0x000fe200078efcffULL,
0x0000600016147625ULL, 0x080fe200078e0053ULL, 0x00005a00ff1a7a19ULL, 0x000fe4000001161aULL,
0x0000580046427a10ULL, 0x000fe20007ffe0ffULL, 0x0000600018167625ULL, 0x000fe200078e0053ULL,
0x0000001a711b7217ULL, 0x000fe20003800000ULL, 0x0000000814517981ULL, 0x0046a4000c1e9500ULL,
0x000000010d447824ULL, 0x000fc400078e0246ULL, 0x0000000816587981ULL, 0x0002a2000c1e9500ULL,
0x0000001b0e5c7224ULL, 0x000fe400078e02ffULL, 0x0000003d4400720cULL, 0x080fe40003f26070ULL,
0x0000003d4200720cULL, 0x040fe20003f06070ULL, 0x0000000142147824ULL, 0x108fe200078e0a3dULL,
0x0000005c4b187211ULL, 0x000fe200078fe0ffULL, 0x00000001191a7824ULL, 0x000fe400078e025cULL,
0x0000000144167824ULL, 0x002fe200078e0a3dULL, 0x000000203e447812ULL, 0x000fe200078efcffULL,
0x0000600018187625ULL, 0x000fe200078e0053ULL, 0x0000001471147217ULL, 0x000fc40003800000ULL,
0x00005800444a7a10ULL, 0x000fe20007ffe0ffULL, 0x000060001a1a7625ULL, 0x000fe200078e0053ULL,
0x000000ff143f7207ULL, 0x000fe20000000000ULL, 0x00000008184d7981ULL, 0x0002e2000c1e9500ULL,
0x0000001671167217ULL, 0x000fe20003800000ULL, 0x000000014a4e7824ULL, 0x040fe200078e0a3dULL,
0x0000005a3f147211ULL, 0x000fe200078fe0ffULL, 0x000000010d507824ULL, 0x000fe200078e0244ULL,
0x00000004ff167819ULL, 0x000fe20000011616ULL, 0x000000081a567981ULL, 0x0002e2000c1e9500ULL,
0x0000003d4a00720cULL, 0x000fe20003f06070ULL, 0x0000600014147625ULL, 0x000fe200078e0053ULL,
0x0000004e71457217ULL, 0x000fc40003800000ULL, 0x000000ff16197207ULL, 0x002fe20000800000ULL,
0x0000000150527824ULL, 0x000fe200078e0a3dULL, 0x000000ff45457207ULL, 0x000fe20000000000ULL,
0x0000000814417981ULL, 0x0002e2000c1e9500ULL, 0x000000303e4e7812ULL, 0x000fe200078efcffULL,
0x000000015a167824ULL, 0x000fe200078e0219ULL, 0x0000005c3f187211ULL, 0x000fe200078fe0ffULL,
0x00000001191a7824ULL, 0x000fe200078e025cULL, 0x0000005271527217ULL, 0x000fe20003800000ULL,
0x000000010d5e7824ULL, 0x000fe200078e024eULL, 0x0000003d5000720cULL, 0x000fe20003f26070ULL,
0x0000600016167625ULL, 0x000fe200078e0053ULL, 0x0000005a45147211ULL, 0x002fc600078fe0ffULL,
0x0000600018187625ULL, 0x080fe200078e0053ULL, 0x00000004ff527819ULL, 0x000fe20000011652ULL,
0x0000000816487981ULL, 0x0002e4000c1e9500ULL, 0x000060001a1a7625ULL, 0x080fe200078e0053ULL,
0x000058004e507a10ULL, 0x000fe20007ffe0ffULL, 0x0000000818437981ULL, 0x0002e4000c1e9500ULL,
0x0000600014147625ULL, 0x000fe200078e0053ULL, 0x000000ff52497207ULL, 0x000fe20000800000ULL,
0x000000081a4c7981ULL, 0x0002e4000c1e9500ULL, 0x000000015e607824ULL, 0x000fc400078e0a3dULL,
0x0000000814477981ULL, 0x0002e4000c1e9500ULL, 0x000000015a167824ULL, 0x002fe200078e0249ULL,
0x0000005c45187211ULL, 0x000fe400078fe0ffULL, 0x0000006071607217ULL, 0x000fe20003800000ULL,
0x00000001491a7824ULL, 0x000fe400078e025cULL, 0x0000000150147824ULL, 0x040fe200078e0a3dULL,
0x0000003d5000720cULL, 0x000fe20003f06070ULL, 0x0000600016167625ULL, 0x000fe200078e0053ULL,
0x0000003d5e00720cULL, 0x000fc40003f26070ULL, 0x0000001471147217ULL, 0x000fe20003800000ULL,
0x0000600018187625ULL, 0x080fe200078e0053ULL, 0x00000004ff607819ULL, 0x000fe20000011660ULL,
0x0000000816527981ULL, 0x0002e4000c1e9500ULL, 0x000060001a1a7625ULL, 0x000fe200078e0053ULL,
0x000000ff144f7207ULL, 0x000fe20000000000ULL, 0x0000000818497981ULL, 0x0002e2000c1e9500ULL,
0x000000ff60557207ULL, 0x000fc60000800000ULL, 0x000000081a547981ULL, 0x0002e2000c1e9500ULL,
0x0000005a4f147211ULL, 0x000fe200078fe0ffULL, 0x000000015a167824ULL, 0x002fc800078e0255ULL,
0x0000600014147625ULL, 0x000fc800078e0053ULL, 0x0000600016167625ULL, 0x000fe400078e0053ULL,
0x0000000814147981ULL, 0x0002e2000c1e9500ULL, 0x0000005c4f187211ULL, 0x000fc600078fe0ffULL,
0x0000000816177981ULL, 0x0002e2000c1e9500ULL, 0x00000001551a7824ULL, 0x000fe400078e025cULL,
0x0000600018187625ULL, 0x000fc800078e0053ULL, 0x000060001a1a7625ULL, 0x000fe400078e0053ULL,
0x0000000818187981ULL, 0x0002e8000c1e9500ULL, 0x000000081a1b7981ULL, 0x0004e2000c1e9500ULL,
0xfffffff04b5a7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff4b7424ULL, 0x000fc800078e00ffULL,
0x000000013d157824ULL, 0x002fe200078e025aULL, 0x000000083e5a7812ULL, 0x000fc600078efcffULL,
0x0000000140627824ULL, 0x100fe200078e0a15ULL, 0x000000093e5e7812ULL, 0x000fe400078efcffULL,
0x000058005a5c7a10ULL, 0x000fe40007ffe0ffULL, 0x000000624b627219ULL, 0x000fe400000006ffULL,
0x000058005e167a10ULL, 0x000fe20007ffe0ffULL, 0x000000015c647824ULL, 0x000fc800078e0a15ULL,
0x0000000116667824ULL, 0x000fe200078e0a15ULL, 0x000000644b647219ULL, 0x000fe400000006ffULL,
0xfffffff03f537812ULL, 0x000fe400078ec0ffULL, 0x000000664b667219ULL, 0x000fe400000006ffULL,
0x000000183e7c7812ULL, 0x040fe200078efcffULL, 0x000000013d537824ULL, 0x000fe200078e0253ULL,
0x000000193e7a7812ULL, 0x000fc600078efcffULL, 0x00000001425b7824ULL, 0x000fe200078e0a53ULL,
0x000058007a197a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff045557812ULL, 0x000fc600078ec0ffULL,
0x0000000119617824ULL, 0x000fe400078e0a53ULL, 0x000000013d557824ULL, 0x000fe200078e0255ULL,
0x000000213e6a7812ULL, 0x000fc600078efcffULL, 0x000000014a637824ULL, 0x000fe200078e0a55ULL,
0x000000283e687812ULL, 0x000fe400078efcffULL, 0xfffffff04f4f7812ULL, 0x000fe400078ec0ffULL,
0x000000614b617219ULL, 0x000fe400000006ffULL, 0x000058006a787a10ULL, 0x000fe20007ffe0ffULL,
0x000000013d577824ULL, 0x000fe200078e024fULL, 0x0000580068767a10ULL, 0x000fc60007ffe0ffULL,
0x0000000178657824ULL, 0x100fe400078e0a55ULL, 0x0000000176677824ULL, 0x000fe400078e0a55ULL,
0x0000000150597824ULL, 0x000fca00078e0a57ULL, 0x000000594b597219ULL, 0x000fe400000006ffULL,
0x0000541051517816ULL, 0x004fe40000000058ULL, 0x000000013e587812ULL, 0x000fe400078efcffULL,
0x0000005162ff7212ULL, 0x000fe4000780c0ffULL, 0x0000580058607a10ULL, 0x000fe40007ffe0ffULL,
0x0000003d4000720cULL, 0x000fc60000701470ULL, 0x00000001601a7824ULL, 0x000fe200078e0a15ULL,
0x0000003d3e00720cULL, 0x040fe40000701070ULL, 0x000000113e157812ULL, 0x000fe400078efcffULL,
0x0000001a4b1a7219ULL, 0x000fe400000006ffULL, 0x0000005164ff7212ULL, 0x080fe4000784c0ffULL,
0x000000511aff7212ULL, 0x000fe4000786c0ffULL, 0x000054104d4d7816ULL, 0x008fc40000000056ULL,
0x0000005166ff7212ULL, 0x000fe4000782c0ffULL, 0xff8000001f1f7808ULL, 0x000fe40000000000ULL,
0x0000004d62ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004d1aff7212ULL, 0x080fe400078ac0ffULL,
0x0000004d64ff7212ULL, 0x080fe400078cc0ffULL, 0x0000004d66ff7212ULL, 0x000fc4000780c0ffULL,
0x0000580015517a10ULL, 0x000fe40007ffe0ffULL, 0x000058007c4d7a10ULL, 0x000fe40007ffe0ffULL,
0x0000003d4000720cULL, 0x080fe20002781470ULL, 0x00000001515d7824ULL, 0x100fe200078e0a53ULL,
0x0000003d5c00720cULL, 0x080fe200037c1470ULL, 0x000000014d5f7824ULL, 0x000fe200078e0a53ULL,
0x0000003d1600720cULL, 0x000fe40000701470ULL, 0x0000005b4b537219ULL, 0x000fc400000006ffULL,
0x0000005d4b5b7219ULL, 0x040fe400000006ffULL, 0x0000003d3e00720cULL, 0x080fe40002781070ULL,
0x0000003d5a00720cULL, 0x080fe400037c1070ULL, 0x0000003d5e00720cULL, 0x000fe40000701070ULL,
0x0000005f4b5d7219ULL, 0x000fe400000006ffULL, 0x0000541041487816ULL, 0x000fc40000000048ULL,
0x00005410434c7816ULL, 0x000fe4000000004cULL, 0x0000003d1600720cULL, 0x000fe40000f21470ULL,
0xff80000028287808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fe40003000000ULL,
0xff80000039397808ULL, 0x000fe40000000000ULL, 0x0000004853ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004c53ff7212ULL, 0x080fe400078cc0ffULL, 0x0000004c5dff7212ULL, 0x000fe4000780c0ffULL,
0x0000003d5e00720cULL, 0x080fe40000f21070ULL, 0x0000003d6000720cULL, 0x0c0fe40001f61470ULL,
0x0000003d6000720cULL, 0x080fe40002fa1470ULL, 0x0000003d5c00720cULL, 0x000fc40001741470ULL,
0x0000003d4200720cULL, 0x0c0fe40002781470ULL, 0x0000003d4200720cULL, 0x080fe400037c1470ULL,
0x0000003d4d00720cULL, 0x080fe40000701470ULL, 0xff80000038387808ULL, 0x000fe40000800000ULL,
0x000000293e667812ULL, 0x000fe400078efcffULL, 0x0000003d5800720cULL, 0x000fc40001f61070ULL,
0x0000003d5800720cULL, 0x080fe40002fa1070ULL, 0x0000003d5a00720cULL, 0x080fe40001741070ULL,
0x0000003d4600720cULL, 0x0c0fe40002721070ULL, 0x0000003d4600720cULL, 0x080fe400037c1070ULL,
0x0000003d7c00720cULL, 0x000fe40000701070ULL, 0x000000634b5f7219ULL, 0x000fc400000006ffULL,
0x0000541047527816ULL, 0x000fe40000000052ULL, 0x0000541049547816ULL, 0x000fe40000000054ULL,
0x00005800666c7a10ULL, 0x000fe40007ffe0ffULL, 0xff8000002e2e7808ULL, 0x000fe40001800000ULL,
0xff8000001e1e7808ULL, 0x000fe40002800000ULL, 0xff8000002f2f7808ULL, 0x000fc40001000000ULL,
0xff80000035357808ULL, 0x000fe40000800000ULL, 0xff8000002b2b7808ULL, 0x000fe40003000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0x000000485bff7212ULL, 0x080fe4000786c0ffULL,
0x000000485dff7212ULL, 0x080fe400078ac0ffULL, 0x0000004861ff7212ULL, 0x000fc4000784c0ffULL,
0x0000004c5bff7212ULL, 0x080fe4000788c0ffULL, 0x0000004c61ff7212ULL, 0x000fe4000782c0ffULL,
0x000000525fff7212ULL, 0x040fe400078cc0ffULL, 0x000000545fff7212ULL, 0x000fe2000780c0ffULL,
0x000000016c697824ULL, 0x000fe200078e0a55ULL, 0x0000003d5100720cULL, 0x0c0fe40001f61470ULL,
0x0000003d5100720cULL, 0x000fc40002781470ULL, 0x0000003d4d00720cULL, 0x080fe40002fa1470ULL,
0x0000003d1900720cULL, 0x0c0fe40001741470ULL, 0x0000003d1900720cULL, 0x080fe40000f21470ULL,
0x0000003d4a00720cULL, 0x0c0fe400037c1470ULL, 0x0000003d4a00720cULL, 0x000fe40000701470ULL,
0x000000313e627812ULL, 0x000fc400078efcffULL, 0x000000383e567812ULL, 0x040fe400078efcffULL,
0x000000393e1a7812ULL, 0x000fe400078efcffULL, 0x000000654b637219ULL, 0x000fe400000006ffULL,
0x0000003d1500720cULL, 0x0c0fe40001f61070ULL, 0x0000003d1500720cULL, 0x080fe40002781070ULL,
0x0000003d7c00720cULL, 0x000fc40002fa1070ULL, 0x0000003d7a00720cULL, 0x0c0fe40001741070ULL,
0x0000003d7a00720cULL, 0x080fe40000f21070ULL, 0x0000003d4400720cULL, 0x0c0fe400037c1070ULL,
0x0000003d4400720cULL, 0x000fe40000701070ULL, 0x000000674b657219ULL, 0x040fe400000006ffULL,
0x000000694b697219ULL, 0x000fc400000006ffULL, 0x0000541014147816ULL, 0x000fe40000000017ULL,
0x0000580062647a10ULL, 0x000fe40007ffe0ffULL, 0x00005800563f7a10ULL, 0x000fe40007ffe0ffULL,
0x000058001a457a10ULL, 0x000fe40007ffe0ffULL, 0xff80000030307808ULL, 0x000fe40001800000ULL,
0xff8000002a2a7808ULL, 0x000fc40002000000ULL, 0xff80000031317808ULL, 0x000fe40002800000ULL,
0xff8000003c3c7808ULL, 0x000fe40001000000ULL, 0xff8000003b3b7808ULL, 0x000fe40000800000ULL,
0xff8000003a3a7808ULL, 0x000fe40003000000ULL, 0xff8000001d1d7808ULL, 0x000fe40000000000ULL,
0x0000005263ff7212ULL, 0x000fc4000786c0ffULL, 0x0000005265ff7212ULL, 0x080fe4000788c0ffULL,
0x0000005269ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005463ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005465ff7212ULL, 0x080fe4000782c0ffULL, 0x0000005469ff7212ULL, 0x000fe400078cc0ffULL,
0x0000001459ff7212ULL, 0x000fe2000780c0ffULL, 0x0000000164557824ULL, 0x100fe200078e0a57ULL,
0x0000003d7800720cULL, 0x0c0fe20001f61470ULL, 0x000000013f4f7824ULL, 0x100fe200078e0a57ULL,
0x0000003d7800720cULL, 0x080fe20001741470ULL, 0x0000000145577824ULL, 0x000fe200078e0a57ULL,
0x0000003d7600720cULL, 0x000fc40002781470ULL, 0x0000003d7600720cULL, 0x080fe40000f21470ULL,
0x0000003d6c00720cULL, 0x0c0fe40002fa1470ULL, 0x0000003d6c00720cULL, 0x080fe400037c1470ULL,
0x0000003d5000720cULL, 0x080fe40000701470ULL, 0x0000003d6a00720cULL, 0x0c0fe40001f61070ULL,
0x0000003d6a00720cULL, 0x000fc40001741070ULL, 0x0000003d6800720cULL, 0x0c0fe40002781070ULL,
0x0000003d6800720cULL, 0x080fe40000f21070ULL, 0x0000003d6600720cULL, 0x0c0fe40002fa1070ULL,
0x0000003d6600720cULL, 0x080fe400037c1070ULL, 0x0000003d4e00720cULL, 0x000fe40000701070ULL,
0x000000554b557219ULL, 0x000fc400000006ffULL, 0x0000004f4b4f7219ULL, 0x040fe400000006ffULL,
0x000000574b577219ULL, 0x000fe400000006ffULL, 0x0000541018187816ULL, 0x000fe4000000001bULL,
0xff80000032327808ULL, 0x000fe40001800000ULL, 0xff8000001c1c7808ULL, 0x000fe40001000000ULL,
0xff80000033337808ULL, 0x000fc40002000000ULL, 0xff80000026267808ULL, 0x000fe40000800000ULL,
0xff80000037377808ULL, 0x000fe40002800000ULL, 0xff80000027277808ULL, 0x000fe40003000000ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0x0000001455ff7212ULL, 0x080fe4000786c0ffULL,
0x000000144fff7212ULL, 0x000fc4000784c0ffULL, 0x0000001457ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001859ff7212ULL, 0x080fe4000782c0ffULL, 0x0000001855ff7212ULL, 0x080fe400078ac0ffULL,
0x000000184fff7212ULL, 0x080fe400078cc0ffULL, 0x0000001857ff7212ULL, 0x000fe4000780c0ffULL,
0x0000003d5000720cULL, 0x000fc40000f21470ULL, 0x0000003d6400720cULL, 0x0c0fe40001f61470ULL,
0x0000003d6400720cULL, 0x080fe40002fa1470ULL, 0x0000003d3f00720cULL, 0x0c0fe40001741470ULL,
0x0000003d3f00720cULL, 0x080fe400037c1470ULL, 0x0000003d4500720cULL, 0x0c0fe40002781470ULL,
0x0000003d4500720cULL, 0x000fc40000701470ULL, 0x0000003d4e00720cULL, 0x080fe40000f21070ULL,
0x0000003d6200720cULL, 0x0c0fe40001f61070ULL, 0x0000003d6200720cULL, 0x080fe40002fa1070ULL,
0x0000003d5600720cULL, 0x0c0fe40001741070ULL, 0x0000003d5600720cULL, 0x080fe400037c1070ULL,
0x0000003d1a00720cULL, 0x000fc40002781070ULL, 0x0000003d1a00720cULL, 0x000fe40000701070ULL,
0xff80000034347808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40002000000ULL, 0xff80000020207808ULL, 0x000fe40000800000ULL,
0xff80000021217808ULL, 0x000fc40002800000ULL, 0xff80000022227808ULL, 0x000fe40003000000ULL,
0xff80000023237808ULL, 0x000fc40000000000ULL, 0x0000001f1000720bULL, 0x004fe20003f1e000ULL,
0x0000001fff187424ULL, 0x000fe200078e00ffULL, 0x000000281100720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x000000101f157208ULL, 0x000fe40004000000ULL,
0x0000001128117208ULL, 0x000fe40004800000ULL, 0x0000002e1500720bULL, 0x000fc40003f1e000ULL,
0x0000001e1100720bULL, 0x000fe40003f3e000ULL, 0x000000152e107208ULL, 0x000fe40004000000ULL,
0x000000111e147208ULL, 0x000fe40004800000ULL, 0x0000002f1000720bULL, 0x000fe40003f1e000ULL,
0x000000291400720bULL, 0x000fe40003f3e000ULL, 0x000000102f117208ULL, 0x000fc40004000000ULL,
0x0000001429147208ULL, 0x000fe40004800000ULL, 0x000000381100720bULL, 0x000fe40003f1e000ULL,
0x000000391400720bULL, 0x000fe40003f3e000ULL, 0x0000001138107208ULL, 0x000fe40004000000ULL,
0x0000001439147208ULL, 0x000fe40004800000ULL, 0x000000351000720bULL, 0x000fc40003f1e000ULL,
0x0000002b1400720bULL, 0x000fe40003f3e000ULL, 0x0000001035117208ULL, 0x000fe40004000000ULL,
0x000000142b157208ULL, 0x000fe40004800000ULL, 0x000000301100720bULL, 0x000fe40003f1e000ULL,
0x0000002a1500720bULL, 0x000fe40003f3e000ULL, 0x0000001130107208ULL, 0x000fc40004000000ULL,
0x000000152a157208ULL, 0x000fe40004800000ULL, 0x000000311000720bULL, 0x000fe40003f1e000ULL,
0x0000002c1500720bULL, 0x000fe40003f3e000ULL, 0x0000001031117208ULL, 0x000fe40004000000ULL,
0x000000152c107208ULL, 0x000fe40004800000ULL, 0x0000003c1100720bULL, 0x000fc40003f1e000ULL,
0x0000003b1000720bULL, 0x000fe40003f3e000ULL, 0x000000113c117208ULL, 0x000fe40004000000ULL,
0x000000103b107208ULL, 0x000fe40004800000ULL, 0x0000003a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001d1000720bULL, 0x000fe40003f3e000ULL, 0x000000113a117208ULL, 0x000fc40004000000ULL,
0x000000101d157208ULL, 0x000fe40004800000ULL, 0x000000321100720bULL, 0x000fe40003f1e000ULL,
0x0000001c1500720bULL, 0x000fe40003f3e000ULL, 0x0000001132107208ULL, 0x000fe40004000000ULL,
0x000000151c157208ULL, 0x000fe40004800000ULL, 0x000000331000720bULL, 0x000fc40003f1e000ULL,
0x000000261500720bULL, 0x000fe40003f3e000ULL, 0x0000001033107208ULL, 0x000fe40004000000ULL,
0x0000001526147208ULL, 0x000fe40004800000ULL, 0x000000371000720bULL, 0x000fe40003f1e000ULL,
0x000000271400720bULL, 0x000fe40003f3e000ULL, 0x0000001037117208ULL, 0x000fc40004000000ULL,
0x0000001427157208ULL, 0x000fe40004800000ULL, 0x000000361100720bULL, 0x000fe40003f1e000ULL,
0x000000201500720bULL, 0x000fe40003f3e000ULL, 0x0000001136117208ULL, 0x000fe40004000000ULL,
0x0000001520107208ULL, 0x000fe40004800000ULL, 0x000000341100720bULL, 0x000fc40003f1e000ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000001134147208ULL, 0x000fe40004000000ULL,
0x0000001021117208ULL, 0x000fe40004800000ULL, 0x0000002d1400720bULL, 0x000fe40003f1e000ULL,
0x000000221100720bULL, 0x000fe40003f3e000ULL, 0x000000142d147208ULL, 0x000fc40004000000ULL,
0x0000001122107208ULL, 0x000fe40004800000ULL, 0x000000251400720bULL, 0x000fe40003f1e000ULL,
0x000000231000720bULL, 0x000fe40003f3e000ULL, 0x0000001425167208ULL, 0x000fe40004000000ULL,
0x0000001023197208ULL, 0x000fe20004800000ULL, 0x000014727f007947ULL, 0x000fec000b800000ULL,
0x0c401f0016107f89ULL, 0x0004e400000e0000ULL, 0x000000101600720bULL, 0x008fc80003f1e000ULL,
0x00000016101b7208ULL, 0x000fe20004000000ULL, 0x000014827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0019107f89ULL, 0x000ee800000e0000ULL, 0x0c401f0012117f89ULL, 0x000e6800000e0000ULL,
0x0c401f0013167f89ULL, 0x006e6200000e0000ULL, 0x000000101900720bULL, 0x008fc40003f1e000ULL,
0x000000111200720bULL, 0x000fe40003f3e000ULL, 0x0000001910147208ULL, 0x000fe40004000000ULL,
0x0000001211157208ULL, 0x000fe20004800000ULL, 0x0c201f001b107f89ULL, 0x000ea200000e0000ULL,
0x000000161300720bULL, 0x002fc60003f1e000ULL, 0x0c201f0014117f89ULL, 0x000e6200000e0000ULL,
0x00000013163d7208ULL, 0x000fc60004000000ULL, 0x0c201f0015187f89ULL, 0x000ee800000e0000ULL,
0x0c201f003d3e7f89ULL, 0x0002e200000e0000ULL, 0x000000101b00720bULL, 0x004fe40003f1e000ULL,
0x000000111400720bULL, 0x002fe40003f3e000ULL, 0x0000001b10107208ULL, 0x000fe40004000000ULL,
0x000000181500720bULL, 0x008fc40003f5e000ULL, 0x0000001411117208ULL, 0x000fe40004800000ULL,
0x0000001518127208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b10137820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000c24247812ULL, 0x000fe400078ec0ffULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010813ULL,
0x0000002f00167308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b311a7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b3a317823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010813ULL,
0x0000002e00157308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b342f7823ULL, 0x102fe20000010813ULL,
0x3fb8aa3b11347820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b37377823ULL, 0x000fe20000010813ULL,
0x0000000304ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010834ULL, 0x0000001f00147308ULL, 0x000e620000000800ULL,
0x3fb8aa3b362e7823ULL, 0x008fe20000010813ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b27277823ULL, 0x000fe20000010834ULL,
0x0000003e3d00720bULL, 0x004fe20003f3e000ULL, 0x0000003800177308ULL, 0x000eb00000000800ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x000000141514723eULL, 0x002fce00000010ffULL,
0x0000001e001f7308ULL, 0x000e620000000800ULL, 0x000000161716723eULL, 0x004fce00000010ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000003900367308ULL, 0x000ea20000000800ULL,
0x000000281f15723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1d287823ULL, 0x000fcc0000010834ULL,
0x0000003000197308ULL, 0x0003f00000000800ULL, 0x0000003500187308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b2d307823ULL, 0x102fe20000010813ULL, 0x3fb8aa3b2c2d7823ULL, 0x100fe20000010834ULL,
0x00000004ff2c7e24ULL, 0x000fe2000f8e00ffULL, 0x000000293617723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b1c297823ULL, 0x000fe20000010834ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000002ff367819ULL, 0x000fe20000011604ULL, 0x0000002d00357308ULL, 0x0003e20000000800ULL,
0x3f8000002c2c783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b25137823ULL, 0x000fe20000010813ULL,
0x3fb8aa3b20257823ULL, 0x000fe20000010834ULL, 0x0000000136207810ULL, 0x000fc40007ffe0ffULL,
0x000000ffff407224ULL, 0x100fe200078e002cULL, 0x00000008363f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x000000ffff2d7224ULL, 0x102fe200078e002cULL,
0x000000181918723eULL, 0x008fe200000010ffULL, 0x000000ffff417224ULL, 0x000fca00078e002cULL,
0x0000003c001b7308ULL, 0x000e620000000800ULL, 0x0000002c141c723cULL, 0x000f6e00000418ffULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x0000001a1b1a723eULL, 0x002fce00000010ffULL, 0x0000003b003a7308ULL, 0x0002e20000000800ULL,
0x0000002b2a19723eULL, 0x004fce00000010ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b212a7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b222b7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b23347823ULL, 0x000fe20000010834ULL, 0x000000ffff3b7224ULL, 0x002fe200078e002cULL,
0x000000353a1b723eULL, 0x008fc600000010ffULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x000000ffff3a7224ULL, 0x000fc600078e002cULL, 0x0000002c181c723cULL, 0x020b68000004181cULL,
0x0000003300337308ULL, 0x000fe60000000800ULL, 0x00000008362d7824ULL, 0x020fca00078e00ffULL,
0x0000003700387308ULL, 0x0004e20000000800ULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee220ULL,
0x000000313220723eULL, 0x002fe200000010ffULL, 0x0000000836327824ULL, 0x000fc800078e00ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000000836377824ULL, 0x004fce00078e00ffULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x000000333822723eULL, 0x008fe200000010ffULL,
0x0000000836337824ULL, 0x040fe400078e00ffULL, 0x0000000836387824ULL, 0x000fc800078e00ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000282921723eULL, 0x002fe400000010ffULL, 0x0000000336287810ULL, 0x000fc40007ffe0ffULL,
0x0000000436297810ULL, 0x000fe40007ffe0ffULL, 0xfffffff833337812ULL, 0x000fe200078ee228ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0xfffffff838357812ULL, 0x000fe400078ee229ULL,
0x0000000536287810ULL, 0x040fe40007ffe0ffULL, 0x0000000636297810ULL, 0x000fe40007ffe0ffULL,
0xfffffff837377812ULL, 0x000fe200078ee228ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x000000262723723eULL, 0x004fc400000010ffULL, 0x0000000236277810ULL, 0x000fe40007ffe0ffULL,
0xfffffff832397812ULL, 0x040fe400078ee229ULL, 0xfffffff832317812ULL, 0x000fe200078ee227ULL,
0x0000003a201c723cULL, 0x000b62000004181cULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000000836277824ULL, 0x000fca00078e00ffULL, 0x00000008363b7824ULL, 0x020fe200078e00ffULL,
0x0000002e2f28723eULL, 0x002fe200000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0xfffffff827277812ULL, 0x000fe400078ee236ULL, 0x000090000b2e7811ULL, 0x000fca00078e58ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000001027277824ULL, 0x100fe400078e022eULL,
0x000000102d2d7824ULL, 0x100fe400078e022eULL, 0x0000001031317824ULL, 0x100fe400078e022eULL,
0x0000001033337824ULL, 0x100fe200078e022eULL, 0x0000002a00267308ULL, 0x0004e20000000800ULL,
0x0000001035357824ULL, 0x000fe400078e022eULL, 0x0000000127277824ULL, 0x000fc400078e0224ULL,
0x0000001037377824ULL, 0x100fe400078e022eULL, 0x00000001242d7824ULL, 0x000fe200078e022dULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0xffffffff362a7810ULL, 0x004fe20007ffe0ffULL,
0x000000083f367824ULL, 0x000fe200078e00ffULL, 0x0000001427007388ULL, 0x0005e20000000800ULL,
0x0000001039397824ULL, 0x000fe200078e022eULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee22aULL,
0x0000000124317824ULL, 0x000fe200078e0231ULL, 0x00000030132a723eULL, 0x002fe200000010ffULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x000000252629723eULL, 0x008fe200000010ffULL,
0x000000103b3b7824ULL, 0x100fe200078e022eULL, 0xfffffff8363f7812ULL, 0x000fe200078ee23fULL,
0x0000000124337824ULL, 0x040fe200078e0233ULL, 0x000000162d007388ULL, 0x0005e20000000800ULL,
0x0000000124357824ULL, 0x000fe200078e0235ULL, 0x0000003d3e137208ULL, 0x000fe20004800000ULL,
0x000000103f3f7824ULL, 0x000fe200078e022eULL, 0x0000001831007388ULL, 0x0005e20000000800ULL,
0x0000000124377824ULL, 0x000fc400078e0237ULL, 0x0000000124397824ULL, 0x040fe200078e0239ULL,
0x0000001a33007388ULL, 0x0005e20000000800ULL, 0x00000001243b7824ULL, 0x000fe200078e023bULL,
0x0000002b342b723eULL, 0x002fe200000010ffULL, 0x0000000124247824ULL, 0x000fe200078e023fULL,
0x0000002035007388ULL, 0x0005e80000000800ULL, 0x0000002237007388ULL, 0x0005e20000000800ULL,
0x00000040281c723cULL, 0x000f66000004181cULL, 0x0000002839007388ULL, 0x0005e80000000800ULL,
0x0000002a3b007388ULL, 0x0005e80000000800ULL, 0x0000001524007388ULL, 0x0005e80000000800ULL,
0x000400172d007388ULL, 0x0005e80000000800ULL, 0x0004001931007388ULL, 0x0005e80000000800ULL,
0x0004001b33007388ULL, 0x0005e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fc600078e001eULL,
0x0004002135007388ULL, 0x0005e80000000800ULL, 0x0004002337007388ULL, 0x0005e80000000800ULL,
0x0004002939007388ULL, 0x0005e80000000800ULL, 0x0004002b3b007388ULL, 0x0005e80000000800ULL,
0x00f000100f008388ULL, 0x0005e80000000c00ULL, 0x00f2001c0f008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080074ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000106067810ULL, 0x000fe20007ffe0ffULL,
0x0000180074ff7f8cULL, 0x0003e6000c80043fULL, 0x000000080600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffae6000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x00014a4000187802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x012fea0003c00000ULL,
0xfffedc1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x00014a8000187802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff067224ULL, 0x000fe200078e000cULL, 0xfffedc7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x00014ad000197802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x012fea0003c00000ULL, 0xfffedd5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x00014b1000197802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x012fea0003c00000ULL, 0xfffede7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0035ULL, 0x00014b6000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0034ULL, 0x00000a5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xfffee2a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0035ULL, 0x00014bb000197802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000cULL,
0xfffee28000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x00014c0000187802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x014fea0003c00000ULL,
0xffff0a6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x00014c4000187802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000cULL, 0xffff0ab000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x00014c9000197802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x014fea0003c00000ULL, 0xffff0ba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x00014cd000197802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x016fea0003c00000ULL, 0xffff0cc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0006ULL, 0x00014d2000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0011ULL, 0x0000089000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xffff10f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0006ULL, 0x00014d7000197802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000cULL,
0xffff10d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x00014dc000187802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x014fea0003c00000ULL,
0xffff368000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x00014e0000187802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000cULL, 0xffff36d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x00014e5000197802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x014fea0003c00000ULL, 0xffff37c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x00014e9000197802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x016fea0003c00000ULL, 0xffff38e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x00014ee000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0012ULL, 0x000006d000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xffff3d1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x00014f3000197802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000cULL,
0xffff3cf000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x00014f8000187802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x012fea0003c00000ULL,
0xffff631000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x00014fc000187802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000cULL, 0xffff636000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x0001501000197802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x012fea0003c00000ULL, 0xffff645000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x0001505000197802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x012fea0003c00000ULL, 0xffff657000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x000150a000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000eULL, 0x0000051000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xffff69a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x000150f000197802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000cULL,
0xffff698000007947ULL, 0x000fea000383ffffULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x0001514000147802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e003eULL, 0xffffeb5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x006fe200078e0019ULL, 0x000151a000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff177424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x0000003e1900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0012ULL,
0x0001520000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x000000193e117208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0013ULL,
0x0001526000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x000000123e197208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e001bULL,
0x000152c000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x000000133e3d7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0011ULL,
0x0001532000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000001b3e107208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0019ULL,
0x0001538000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x000000113e117208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e003dULL,
0x000153e000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x000000193e127208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffea2000007947ULL, 0x000fea000383ffffULL, 0x018000003d007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000003d00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff3dff7812ULL, 0x040fe4000780c0ffULL,
0x800000003d027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003d00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffeaa9002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000003f00007348ULL, 0x000fe80003800000ULL, 0x0c000017163e7389ULL, 0x0002a200000e0018ULL,
0xfffeaa5014007950ULL, 0x000fea0003c3ffffULL, 0x0000007900007348ULL, 0x000fe80003800000ULL,
0x0000000c180c7389ULL, 0x0002a400000e007aULL, 0x000000ffff187224ULL, 0x002fc400078e0019ULL,
0x00000000ff197424ULL, 0x000fc800078e00ffULL, 0xfffeaa0018007950ULL, 0x000fea0003c3ffffULL,
0x000000010c00780cULL, 0x000fe20003f45070ULL, 0x00000000ff197424ULL, 0x000fe200078e00ffULL,
0x0000007800007348ULL, 0x000ff60003800000ULL, 0x00000000000c7806ULL, 0x000fc800050e0100ULL,
0x000000780c0c7212ULL, 0x000fe200078ec0ffULL, 0xfffea9a018007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000378ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d70ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e30ULL, 0x00000000000007bcULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001600ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001690ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001694ULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000015700ULL, 0x7f00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016f80ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016fd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017350ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001690ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000158f0ULL, 0x00000000000158f0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016f80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017350ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_89_cubin_len = 95280;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
