/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016a40ULL, 0x00000000000166c0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x0000000000015000ULL, 0x0000000000000280ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000015280ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001500000000000ULL, 0x0001080400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x0001500000000000ULL, 0x0000028000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x000823040000007fULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000001c000942804ULL, 0x0000096000000260ULL,
0x00002910000028a0ULL, 0x00002b20000029e0ULL, 0x0000309000003080ULL, 0x00005520000054c0ULL,
0x0000576000005620ULL, 0x00005b7000005b60ULL, 0x00007f1000007eb0ULL, 0x0000815000008010ULL,
0x0000856000008550ULL, 0x0000a9600000a900ULL, 0x0000aba00000aa60ULL, 0x0000aff00000afe0ULL,
0x0000c9200000c910ULL, 0x00014470000143c0ULL, 0x000146f000014660ULL, 0x00014a20000149a0ULL,
0x00014d1000014c50ULL, 0x0000047004303904ULL, 0x00017600000000ffULL, 0x0000055000040100ULL,
0x0001760800000000ULL, 0x00000660003f0100ULL, 0x0001768800000000ULL, 0x00000790003f0100ULL,
0x000176a800000005ULL, 0x000008a0003f0100ULL, 0x000176c800000004ULL, 0x00000de0003f0100ULL,
0x000176000000000dULL, 0x00000f70003f0107ULL, 0x0001768800000000ULL, 0x00001800003f0101ULL,
0x0000000000000049ULL, 0x0000193000040107ULL, 0x0000000000000049ULL, 0x000019b000040101ULL,
0x0000002000000002ULL, 0x00001b00003f0101ULL, 0x000176c800000035ULL, 0x00001c80003f0109ULL,
0x000176c800000035ULL, 0x00002560003f0109ULL, 0x000176b000000056ULL, 0x00002620003f0107ULL,
0x000176b000000056ULL, 0x00002630003f0101ULL, 0x0001760800000051ULL, 0x00002650003f0101ULL,
0x0001760800000051ULL, 0x000027c0003f0109ULL, 0x0001760800000051ULL, 0x00002d10003f0109ULL,
0x000176a800000036ULL, 0x00002e80003f0109ULL, 0x000176a800000036ULL, 0x00004820003f0109ULL,
0x000176c800000034ULL, 0x00004830003f0101ULL, 0x0001768800000052ULL, 0x00004860003f0101ULL,
0x0000000000000004ULL, 0x000049d0003f0109ULL, 0x0000000000000004ULL, 0x00005210003f0109ULL,
0x000176a800000016ULL, 0x00005280003f0107ULL, 0x000176a800000016ULL, 0x00005290003f0101ULL,
0x0001762800000051ULL, 0x000052b0003f0101ULL, 0x0001762800000051ULL, 0x00005420003f0109ULL,
0x0001762800000051ULL, 0x00005940003f0109ULL, 0x000176b000000037ULL, 0x00005ab0003f0109ULL,
0x000176b000000037ULL, 0x00007210003f0109ULL, 0x000176c800000034ULL, 0x00007220003f0101ULL,
0x0001769000000040ULL, 0x00007250003f0101ULL, 0x0000000000000004ULL, 0x000073c0003f0109ULL,
0x0000000000000004ULL, 0x00007c00003f0109ULL, 0x000176b000000016ULL, 0x00007c70003f0107ULL,
0x000176b000000016ULL, 0x00007c80003f0101ULL, 0x0001764800000051ULL, 0x00007ca0003f0101ULL,
0x0001764800000051ULL, 0x00007e10003f0109ULL, 0x0001764800000051ULL, 0x00008330003f0109ULL,
0x000176a800000037ULL, 0x000084a0003f0109ULL, 0x000176a800000037ULL, 0x00009bf0003f0109ULL,
0x000176c800000034ULL, 0x00009c10003f0101ULL, 0x0001769800000042ULL, 0x00009c40003f0101ULL,
0x0000000000000004ULL, 0x00009db0003f0109ULL, 0x0000000000000004ULL, 0x0000a680003f0109ULL,
0x000176a800000014ULL, 0x0000a6c0003f0107ULL, 0x000176a800000014ULL, 0x0000a6d0003f0101ULL,
0x0001766800000007ULL, 0x0000a700003f0101ULL, 0x0001766800000007ULL, 0x0000a870003f0109ULL,
0x0001766800000007ULL, 0x0000ad80003f0109ULL, 0x000176b000000037ULL, 0x0000aef0003f0109ULL,
0x000176b000000037ULL, 0x0000c6b0003f0109ULL, 0x0000000000000004ULL, 0x0000c750003f0101ULL,
0x000176a000000004ULL, 0x0000d7f0003f0101ULL, 0x000176000000000dULL, 0x0000f160003f0101ULL,
0x000176000000000dULL, 0x0000f2d0003f0109ULL, 0x000176000000000dULL, 0x0000f4b0003f0109ULL,
0x000176000000000dULL, 0x0000f4d0003f0101ULL, 0x000176000000000dULL, 0x0000f640003f0109ULL,
0x000176000000000dULL, 0x00012a10003f0109ULL, 0x000176880000000bULL, 0x00012be0003f0101ULL,
0x000176880000000bULL, 0x00012d50003f0109ULL, 0x000176880000000bULL, 0x00014fa0003f0109ULL,
0x000176080000000cULL, 0x00014fb0003f0101ULL, 0x000176100000000cULL, 0x00014fc0003f0101ULL,
0x000176180000000cULL, 0x00014fd0003f0101ULL, 0x000176200000000cULL, 0x00053803003f0101ULL,
0x0000d19000201c04ULL, 0x0000d3b00000d1f0ULL, 0x0000d6a00000d510ULL, 0x0000f6700000d7a0ULL,
0x000c050400014ff0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL,
0x0000001800080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001700000002ULL,
0x0000000000015000ULL, 0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000097919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000000a7919ULL, 0x000eea0000002200ULL, 0x00000400ff067b82ULL, 0x000f220000000800ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000157919ULL, 0x000f6c0000002700ULL,
0x00008600ff117b82ULL, 0x000f620000000800ULL, 0x0000000300007306ULL, 0x004ea20000209000ULL,
0x000000ff0300720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00047836ULL, 0x004fcc0000000000ULL, 0x0000000400057305ULL, 0x0004e4000021f000ULL,
0x000000ffff047224ULL, 0x004fe400078e00ffULL, 0x000000ffff087224ULL, 0x00afc800078e0a05ULL,
0x0000000308077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002600ULL,
0x0000000705057227ULL, 0x000fe400078e0004ULL, 0x0000000000077919ULL, 0x000ea80000002100ULL,
0x00000006053d7227ULL, 0x010fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a3dULL,
0x0000000503007224ULL, 0x000fca00078e0206ULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a03ULL, 0x000000013d3d0836ULL, 0x000fe20000000000ULL,
0x00000005ff3c7819ULL, 0x004fe40000011607ULL, 0x000000030000720cULL, 0x000fc80003f26070ULL,
0x00001fff3c3c7589ULL, 0x000f7200000e0000ULL, 0x000000013d3d1836ULL, 0x000fe20000000000ULL,
0x00000003ff3da212ULL, 0x000fc800078e33ffULL, 0x0000003d00007306ULL, 0x000ea20000209000ULL,
0x000000ff3d00720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00047836ULL, 0x004fe40000000000ULL, 0x0000000409007c24ULL, 0x000fe2000f8e020aULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000400057305ULL, 0x0004e2000021f000ULL,
0x00001fff09097589ULL, 0x000f6200000e0000ULL, 0x000000ffff047224ULL, 0x004fe400078e00ffULL,
0x000000053d067224ULL, 0x008fc800078e02ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a06ULL,
0x0000000b05057227ULL, 0x000fc800078e0004ULL, 0x0000000400047c24ULL, 0x000fe4000f8e0207ULL,
0x00000008053e7227ULL, 0x002fc600078e00ffULL, 0x0000007f0400780cULL, 0x040fe20003f64070ULL,
0x000000ffff057224ULL, 0x000fe200078e0a3eULL, 0x000000030400780cULL, 0x000fc60003f84070ULL,
0x000000053d007224ULL, 0x000fca00078e0208ULL, 0x0000003d0000720cULL, 0x000fc60003f06070ULL,
0x000000000006b919ULL, 0x000e620000008800ULL, 0x000004000005b802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a3dULL, 0x000000013e3e0836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x0000003d0000720cULL, 0x000fda0003f26070ULL,
0x000000013e3e1836ULL, 0x000fe20000000000ULL, 0x0000003dff3ea212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x000fe40003f24070ULL, 0x000006540605b816ULL, 0x002fe20000000005ULL,
0x000000ffff007224ULL, 0x000fe200078e0a3eULL, 0x000000010400780cULL, 0x000fe20003f44070ULL,
0xff317217ff06b424ULL, 0x000fe400078e00ffULL, 0x000000003d3d7224ULL, 0x000fc400078e0208ULL,
0x000000040405b824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x020fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01760006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01760804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01768804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x017400060500b388ULL, 0x0003e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x000000103d007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x0000001102057219ULL, 0x082fe200000006ffULL,
0x0000000215027224ULL, 0x000fe200078e02ffULL, 0x00000011030f7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000500720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x00000010053b7446ULL, 0x000fe20003800004ULL,
0x0000000409057824ULL, 0x000fe200078e023cULL, 0x000000113e047219ULL, 0x000fc400000006ffULL,
0x000000ff3b3b7207ULL, 0x000fc60000000000ULL, 0x0000000f02027224ULL, 0x000fe200078e0204ULL,
0x000000103b00780cULL, 0x000fe20003f05270ULL, 0x0000000205047824ULL, 0x000fd800078e00ffULL,
0x0000000000808947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000137919ULL, 0x000ea60000008800ULL, 0x0000001106067219ULL, 0x000fe400000006ffULL,
0x00000004ff0b7819ULL, 0x002fca000001160eULL, 0x00000001040d7824ULL, 0x000fc800078e020bULL,
0x0000000100057824ULL, 0x000fca00078e020dULL, 0x0000000605077212ULL, 0x000fe400078e30ffULL,
0x00000011ff067219ULL, 0x000fe20000011605ULL, 0x000000100e057824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e0207ULL, 0x000000043b077248ULL, 0x000fe40007fe0000ULL,
0x000000f005117812ULL, 0x000fe200078ec0ffULL, 0x0000000f06067224ULL, 0x000fe400078e0202ULL,
0x0000000107047824ULL, 0x000fc400078e0a04ULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000040b00720cULL, 0x000fe20003f06070ULL, 0x000000010d027824ULL, 0x040fe200078e020eULL,
0x0000040000047802ULL, 0x000fe20000000f00ULL, 0x000000100d0b7824ULL, 0x000fe200078e00ffULL,
0x0000001106117212ULL, 0x000fe400078efcffULL, 0x00000654130d7816ULL, 0x004fe40000000004ULL,
0xfffffff00b027812ULL, 0x000fe400078ee202ULL, 0x0000000411067c10ULL, 0x000fc6000ff3e0ffULL,
0x00000010020b7824ULL, 0x000fe200078e020dULL, 0x0000000507077c10ULL, 0x000fca0008ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000c101c46ULL,
0x00000000006c7947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000137919ULL, 0x000ea60000008800ULL, 0x0000001106057219ULL, 0x000fe400000006ffULL,
0x000000040e0b7211ULL, 0x002fca00078fe0ffULL, 0x0000000100047824ULL, 0x000fca00078e020bULL,
0x0000000504057212ULL, 0x000fe400078e30ffULL, 0x00000011ff047219ULL, 0x000fc60000011604ULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x000000010b027824ULL, 0x000fe400078e020eULL,
0x0000000f04047224ULL, 0x000fe400078e0205ULL, 0x000000100e057824ULL, 0x000fe400078e00ffULL,
0x0000010004067825ULL, 0x000fe200078e00ffULL, 0x0000040000047802ULL, 0x000fe40000000f00ULL,
0x000000f0050d7812ULL, 0x000fe200078ec0ffULL, 0x000000100b0b7824ULL, 0x000fc600078e00ffULL,
0x0000000d06067212ULL, 0x000fe400078efcffULL, 0x00000654130d7816ULL, 0x004fe40000000004ULL,
0xfffffff00b027812ULL, 0x000fe400078ee202ULL, 0x0000000406067c10ULL, 0x000fc6000ff1e0ffULL,
0x00000010020b7824ULL, 0x000fe200078e020dULL, 0x0000000507077c10ULL, 0x000fca00087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e8000b901c46ULL,
0x000000000d0472caULL, 0x000fe200000e0000ULL, 0x00009200ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001760004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000415067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606397981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe20003f05270ULL,
0x0000003f393a7836ULL, 0x004fe40000000000ULL, 0x000000ff39047836ULL, 0x000fc60000000000ULL,
0x00000006ff3a7819ULL, 0x000fe4000001163aULL, 0x00000008ff387819ULL, 0x000fca0000011604ULL,
0x000000c800408947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe2000001163cULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0x03ffffff0c097812ULL, 0x000fc800078ec0ffULL, 0x0000003a0900720cULL, 0x000fda0003f06070ULL,
0x00009400ff078b82ULL, 0x000e620000000800ULL, 0x0000000215008824ULL, 0x000fce00078e00ffULL,
0x00009000ff108b82ULL, 0x000ea20000000a00ULL, 0x0000000700008224ULL, 0x002fc800078e0207ULL,
0x0000000109078824ULL, 0x000fe400078e0200ULL, 0x000000083c007824ULL, 0x000fe400078e020dULL,
0x0000000407108825ULL, 0x004fe400078e0010ULL, 0x0176880b00ff79a7ULL, 0x0003e6000850003fULL,
0x0000000610028981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0400780cULL, 0x000fc40003f04070ULL,
0x00000001ff0a7819ULL, 0x000fe2000001163cULL, 0x000000403e0b7824ULL, 0x002fc800078e00ffULL,
0x000000200a087824ULL, 0x000fe200078e00ffULL, 0x00008e00ff067b82ULL, 0x000e680000000a00ULL,
0x000000200b007812ULL, 0x000fe200078ef808ULL, 0x0000000302027224ULL, 0x004fc800078e02ffULL,
0x0000004002037824ULL, 0x000fc800078e00ffULL, 0x0000008003027825ULL, 0x002fe200078e0006ULL,
0x000000013c077812ULL, 0x000fe200078ec0ffULL, 0x0000000000fc0947ULL, 0x000fec0003800000ULL,
0x0000000839117248ULL, 0x000fe20007fe0000ULL, 0x0000001007047824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fc6000001160eULL, 0x0000000111117824ULL, 0x000fe400078e0a08ULL,
0x0000000104137824ULL, 0x000fe400078e0206ULL, 0x0000000406127836ULL, 0x000fe20000000000ULL,
0x0000000411117248ULL, 0x000fe20007fe0000ULL, 0x0000000113107824ULL, 0x040fe400078e020eULL,
0x0000000813177824ULL, 0x000fe400078e00ffULL, 0x0000000111117824ULL, 0x000fc400078e0a04ULL,
0x0000000806167836ULL, 0x000fe20000000000ULL, 0xfffffff817147812ULL, 0x000fe200078ee210ULL,
0x0000000104177824ULL, 0x000fe200078e0212ULL, 0x000000111200720cULL, 0x080fe20003f46070ULL,
0x0000000c06127836ULL, 0x000fe20000000000ULL, 0x000000110600720cULL, 0x080fe20003f66070ULL,
0x0000000100107824ULL, 0x000fe200078e0213ULL, 0x000000111600720cULL, 0x080fe20003f26070ULL,
0x0000000117067824ULL, 0x040fe200078e020eULL, 0x000000111200720cULL, 0x000fe20003f06070ULL,
0x00000008171b7824ULL, 0x000fc400078e00ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff81b067812ULL, 0x000fe200078ee206ULL, 0x0000000104197824ULL, 0x040fe200078e0212ULL,
0x00000070101b7812ULL, 0x000fe200078ef805ULL, 0x0000000104137824ULL, 0x000fe400078e0216ULL,
0x0000000100167824ULL, 0x040fe200078e0219ULL, 0x0000001b02187210ULL, 0x000fe20007f9e0ffULL,
0x0000000119107824ULL, 0x040fe400078e020eULL, 0x0000000819197824ULL, 0x000fe400078e00ffULL,
0x0000000100127824ULL, 0x000fc400078e0213ULL, 0x0000000113047824ULL, 0x040fe200078e020eULL,
0xfffffff8191a7812ULL, 0x000fe200078ee210ULL, 0x0000000813137824ULL, 0x000fe400078e00ffULL,
0x0000000100177824ULL, 0x000fe400078e0217ULL, 0x0000000103197824ULL, 0x000fe200020e0611ULL,
0xfffffff813047812ULL, 0x000fe200078ee204ULL, 0x000020000a007824ULL, 0x000fe400078e020dULL,
0x0000008017107825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007010257812ULL, 0x000fc600078ef805ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007012237812ULL, 0x000fc600078ef805ULL, 0x00013000001b7836ULL, 0x000fe20000000000ULL,
0x0000007016057812ULL, 0x000fe400078ef805ULL, 0x0000002302107210ULL, 0x000fe20007fbe0ffULL,
0x0000001004217824ULL, 0x100fe200078e021bULL, 0x0000002502047210ULL, 0x000fe20007f9e0ffULL,
0x00000010141d7824ULL, 0x100fe200078e021bULL, 0x0000000502027210ULL, 0x000fe20007fde0ffULL,
0x00000010061f7824ULL, 0x000fe400078e021bULL, 0x0000000103057824ULL, 0x040fe200020e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000d901c46ULL,
0x0000000103117824ULL, 0x000fc400028e0613ULL, 0x000000101a1b7824ULL, 0x000fe200078e021bULL,
0x00000000041f7faeULL, 0x0003e2000d101c46ULL, 0x0000000103037824ULL, 0x000fc600030e0617ULL,
0x0000000010217faeULL, 0x0003e8000c901c46ULL, 0x00000000021b7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x0000001007117824ULL, 0x000fca00078e00ffULL,
0x000000110e117211ULL, 0x000fca00078fe8ffULL, 0x0000000411137836ULL, 0x000fe40000000000ULL,
0x0000000111047824ULL, 0x140fe400078e020eULL, 0x0000000811177824ULL, 0x000fe400078e00ffULL,
0x0000000113067824ULL, 0x040fe400078e020eULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0xfffffff817047812ULL, 0x000fe200078ee204ULL, 0x0000000100107824ULL, 0x000fc400078e0211ULL,
0x0000000811177836ULL, 0x000fe20000000000ULL, 0xfffffff819067812ULL, 0x000fe200078ee206ULL,
0x0000000c11197836ULL, 0x000fe40000000000ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000100167824ULL, 0x040fe200078e0219ULL, 0x00000070101b7812ULL, 0x000fe200078ef805ULL,
0x0000000119107824ULL, 0x140fe400078e020eULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x0000001b02187210ULL, 0x000fe20007f1e0ffULL, 0x0000000100137824ULL, 0x040fe400078e0213ULL,
0x0000000100127824ULL, 0x000fe200078e0217ULL, 0xfffffff819147812ULL, 0x000fe200078ee210ULL,
0x0000000117007824ULL, 0x000fc400078e020eULL, 0x00000008171d7824ULL, 0x000fe400078e00ffULL,
0x000020000a177824ULL, 0x000fe400078e020dULL, 0x0000000103197824ULL, 0x000fe200000e0611ULL,
0xfffffff81d007812ULL, 0x000fe200078ee200ULL, 0x0000008013107825ULL, 0x000fc800078e00ffULL,
0x0001300017257836ULL, 0x000fe20000000000ULL, 0x0000007010237812ULL, 0x000fe200078ef805ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007012217812ULL, 0x000fc600078ef805ULL, 0x00000010041b7824ULL, 0x100fe200078e0225ULL,
0x0000007016057812ULL, 0x000fe200078ef805ULL, 0x00000010061d7824ULL, 0x100fe200078e0225ULL,
0x0000002302047210ULL, 0x000fe20007f1e0ffULL, 0x00000010001f7824ULL, 0x100fe200078e0225ULL,
0x0000002102107210ULL, 0x000fe20007f3e0ffULL, 0x0000001014217824ULL, 0x000fe200078e0225ULL,
0x0000000502027210ULL, 0x000fe20007f5e0ffULL, 0x0000000103057824ULL, 0x040fe200000e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181b7faeULL, 0x0003e2000b901c46ULL,
0x0000000103117824ULL, 0x000fc400008e0613ULL, 0x0000000103037824ULL, 0x000fe200010e0617ULL,
0x00000000041d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000002217faeULL, 0x0003e4000b901c46ULL, 0x0000000109097836ULL, 0x000fe40000000000ULL,
0xffffffffff537424ULL, 0x000fc600078e00ffULL, 0x0000003a0900720cULL, 0x000fe20003f06070ULL,
0x000176a80d497836ULL, 0x000fe20000000000ULL, 0x000000000a0472caULL, 0x000fd600000e0000ULL,
0x00009400ff058b82ULL, 0x002e620000000800ULL, 0x00000000490572caULL, 0x000fe200000e0000ULL,
0x0000000215008824ULL, 0x000fcc00078e00ffULL, 0x00009000ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000404047899ULL, 0x000fca000800063fULL, 0x0000000504057290ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000500008224ULL, 0x002fc800078e0205ULL, 0x0000000100058824ULL, 0x000fc800078e0209ULL,
0x0000000405028825ULL, 0x004fca00078e0002ULL, 0x0000000602538981ULL, 0x000322000c1e1900ULL,
0x000000ff3800720cULL, 0x000fe20003f05270ULL, 0x00000001ff007424ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe400078e00ffULL, 0x000000080a027824ULL, 0x002fe200078e0249ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000494879a7ULL, 0x0002a20008500004ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00002000020279a7ULL, 0x0002e2000850003fULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ac00748947ULL, 0x000fec0003800000ULL, 0x00009400ff137b82ULL, 0x000f620000000800ULL,
0x00000004ff057e24ULL, 0x000fe4000f8e00ffULL, 0x000000200c007824ULL, 0x002fe400078e020dULL,
0x0000000215067824ULL, 0x000fe200078e00ffULL, 0x0000001005057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff347224ULL, 0x008fe400078e0003ULL, 0xff317217ff557424ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fc400078e0205ULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x0000000807077824ULL, 0x000fe400078e0200ULL, 0x0000001306067224ULL, 0x020fe400078e0213ULL,
0x000000ffff137224ULL, 0x000fce00078e00ffULL, 0x000000ffff457224ULL, 0x000fce00078e0009ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x000000043c047824ULL, 0x000fca00078e00ffULL,
0xfffffff804047812ULL, 0x000fca00078ec0ffULL, 0x000000010d357824ULL, 0x000fc800078e0204ULL,
0x0176c834350075a7ULL, 0x000e62000800017fULL, 0x000176c835047836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176c834350075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x000000103c167824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000000105177836ULL, 0x000fe40000000000ULL,
0x0000000453537c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe016347812ULL, 0x000fe400078ec0ffULL,
0x000000381700720cULL, 0x000fe20003f26070ULL, 0x0000004053537824ULL, 0x000fe400078e00ffULL,
0x0000010005347824ULL, 0x000fc800078e0234ULL, 0x0000004034357836ULL, 0x000fca0000000000ULL,
0x0000002035347812ULL, 0x000fe200078ec0ffULL, 0x0000008053147825ULL, 0x002fc800078e0014ULL,
0x000000010b407824ULL, 0x000fe200078e0234ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x0000001016177812ULL, 0x000fe200078ec0ffULL, 0x000000100e427824ULL, 0x000fe200078e00ffULL,
0x0000003539167248ULL, 0x000fe40007fe0000ULL, 0x00000003ff367819ULL, 0x000fe4000001160eULL,
0x0000007042517812ULL, 0x000fe200078ec0ffULL, 0x0000000116167824ULL, 0x000fe400078e0a35ULL,
0x0000000436377836ULL, 0x000fe40000000000ULL, 0x0000000136357824ULL, 0x000fe200078e0217ULL,
0x0000001716167248ULL, 0x000fe20007fe0000ULL, 0x0000000836417836ULL, 0x000fc40000000000ULL,
0x0000000135347824ULL, 0x040fe400078e020eULL, 0x0000000116167824ULL, 0x000fe400078e0a17ULL,
0x00000008353f7824ULL, 0x000fc600078e00ffULL, 0x000000163600720cULL, 0x080fe20003f86070ULL,
0x0000000c36367836ULL, 0x000fe20000000000ULL, 0x000000163700720cULL, 0x0c0fe20003f66070ULL,
0x0000000137377824ULL, 0x100fe200078e0217ULL, 0x000000164100720cULL, 0x0c0fe20003f46070ULL,
0x0000000141417824ULL, 0x100fe200078e0217ULL, 0x000000163600720cULL, 0x040fe20003f06070ULL,
0x0000000136437824ULL, 0x000fe200078e0217ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee234ULL,
0x0000000140167824ULL, 0x040fe400078e0235ULL, 0x0000000140367824ULL, 0x000fc400078e0237ULL,
0x0000000137347824ULL, 0x140fe400078e020eULL, 0x0000000837477824ULL, 0x000fe400078e00ffULL,
0x0000000140357824ULL, 0x040fe400078e0241ULL, 0x0000000140427824ULL, 0x000fe400078e0243ULL,
0x0000000141407824ULL, 0x040fe400078e020eULL, 0x00000008414b7824ULL, 0x000fc400078e00ffULL,
0x0000000143417824ULL, 0x040fe400078e020eULL, 0x0000000843447824ULL, 0x000fe200078e00ffULL,
0xfffffff847437812ULL, 0x000fe200078ee234ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff84b477812ULL, 0x000fe400078ee240ULL, 0xfffffff8444b7812ULL, 0x000fe200078ee241ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000005136417212ULL, 0x000fc600078efcffULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x00000051164d7212ULL, 0x080fe400078efcffULL,
0x0000004114367210ULL, 0x000fe20007fde0ffULL, 0x0000008042407825ULL, 0x000fe200078e00ffULL,
0x0000004d14167210ULL, 0x000fe40007fbe0ffULL, 0x00000051344f7212ULL, 0x080fe200078efcffULL,
0x000020000a447824ULL, 0x000fe200078e020dULL, 0x00000051404d7212ULL, 0x000fe200078efcffULL,
0x0000000115177824ULL, 0x000fe200028e0617ULL, 0x0000004f14347210ULL, 0x000fe20007fbe0ffULL,
0x0001400044427836ULL, 0x000fc40000000000ULL, 0x0000000115377824ULL, 0x000fe200030e0637ULL,
0x0000004d14147210ULL, 0x000fe20007fde0ffULL, 0x000000103f3f7824ULL, 0x100fe400078e0242ULL,
0x0000001043437824ULL, 0x100fe400078e0242ULL, 0x0000001047477824ULL, 0x100fe200078e0242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000163f7faeULL, 0x0003e2000e101c46ULL,
0x0000000115357824ULL, 0x000fe400028e0635ULL, 0x000000104b4b7824ULL, 0x000fe200078e0242ULL,
0x0000000036437faeULL, 0x0003e2000d901c46ULL, 0x0000000115157824ULL, 0x000fc600030e0641ULL,
0x0000000034477faeULL, 0x0003e8000d101c46ULL, 0x00000000144b7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x0000001016177812ULL, 0x000fe200078ec0ffULL,
0x000000100e367824ULL, 0x000fc600078e00ffULL, 0x000000170e177211ULL, 0x000fe400078fe8ffULL,
0x00000070364b7812ULL, 0x000fc600078ec0ffULL, 0x0000000417357836ULL, 0x000fe40000000000ULL,
0x0000000117167824ULL, 0x140fe400078e020eULL, 0x00000008173f7824ULL, 0x000fe400078e00ffULL,
0x0000000135347824ULL, 0x040fe400078e020eULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL, 0x0000000140167824ULL, 0x000fc400078e0217ULL,
0x0000000c17417836ULL, 0x000fe20000000000ULL, 0xfffffff837427812ULL, 0x000fe200078ee234ULL,
0x0000000817377836ULL, 0x000fe40000000000ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000000140367824ULL, 0x000fe200078e0237ULL, 0x0000004b16437212ULL, 0x000fe200078efcffULL,
0x0000000137347824ULL, 0x140fe400078e020eULL, 0x0000000837477824ULL, 0x000fe200078e00ffULL,
0x0000004314167210ULL, 0x000fe20007f1e0ffULL, 0x0000000140357824ULL, 0x000fe400078e0235ULL,
0x0000000141377824ULL, 0x040fe200078e020eULL, 0xfffffff847447812ULL, 0x000fe200078ee234ULL,
0x0000000841467824ULL, 0x000fc400078e00ffULL, 0x0000000140407824ULL, 0x000fe400078e0241ULL,
0x000020000a417824ULL, 0x000fe200078e020dULL, 0xfffffff846467812ULL, 0x000fe200078ee237ULL,
0x0000008035347825ULL, 0x000fc800078e00ffULL, 0x0001400041517836ULL, 0x000fe20000000000ULL,
0x0000004b344f7212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x0000008040407825ULL, 0x000fe200078e00ffULL, 0x0000004b364d7212ULL, 0x000fc600078efcffULL,
0x0000000115177824ULL, 0x000fe200000e0617ULL, 0x0000004b404b7212ULL, 0x000fe200078efcffULL,
0x000000103f3f7824ULL, 0x100fe200078e0251ULL, 0x0000004f14347210ULL, 0x000fe20007f1e0ffULL,
0x0000001042437824ULL, 0x100fe200078e0251ULL, 0x0000004d14367210ULL, 0x000fe20007f5e0ffULL,
0x0000001044477824ULL, 0x000fe200078e0251ULL, 0x0000004b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000000115357824ULL, 0x040fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000163f7faeULL, 0x0003e2000b901c46ULL, 0x0000000115377824ULL, 0x000fc400010e0637ULL,
0x00000010464b7824ULL, 0x000fe200078e0251ULL, 0x0000000034437faeULL, 0x0003e2000b901c46ULL,
0x0000000115157824ULL, 0x000fc600018e0641ULL, 0x0000000036477faeULL, 0x0003e8000b901c46ULL,
0x00000000144b7faeULL, 0x0003e4000b901c46ULL, 0x0000000109177836ULL, 0x002fe40000000000ULL,
0xffffffffff4c7424ULL, 0x000fc600078e00ffULL, 0x0000003a1700720cULL, 0x000fe20003f06070ULL,
0x000000083c167824ULL, 0x000fca00078e00ffULL, 0xfffffff016347812ULL, 0x000fca00078ec0ffULL,
0x000000010d567824ULL, 0x000fe400078e0234ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x0000000106178824ULL, 0x000fe400078e0217ULL, 0x00000000560472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000417148825ULL, 0x002fd000078e0014ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x00000006144c8981ULL, 0x000322000c1e1900ULL, 0xffffffe016347812ULL, 0x040fe400078ec0ffULL,
0x0000001016177812ULL, 0x040fe400078ec0ffULL, 0x0000000816167812ULL, 0x000fe400078ec0ffULL,
0x0000000d17177210ULL, 0x000fe20007ffe034ULL, 0x00000001ff347424ULL, 0x000fc800078e00ffULL,
0x0000000117517824ULL, 0x000fe200078e0216ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x0176b034565679a7ULL, 0x0002e4000850003fULL, 0x01760834513479a7ULL, 0x0022a4000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x01760835510075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01760835510075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000100e447824ULL, 0x000fe200078e00ffULL, 0x00000001ff477819ULL, 0x000fe2000001160eULL,
0x000000203c147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000007044447812ULL, 0x000fe400078ec0ffULL, 0xffffff8014147812ULL, 0x000fe400078ec0ffULL,
0x0000000c47477812ULL, 0x000fe400078ec0ffULL, 0x0000000d44147210ULL, 0x000fca0007ffe014ULL,
0x0000000114147824ULL, 0x000fca00078e0247ULL, 0x0170000014167984ULL, 0x000ea80000000800ULL,
0x0172000014177984ULL, 0x000b620000000800ULL, 0x000000551600720bULL, 0x004fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000000fc8947ULL, 0x02afea0003800000ULL, 0x0000003c0c00720cULL, 0x000fe40003f45270ULL,
0x000000551600720bULL, 0x0c0fe40003f14000ULL, 0x0000005516377209ULL, 0x000fd20007810000ULL,
0x000000803c14a824ULL, 0x000fe400078e020dULL, 0x0000000000347806ULL, 0x000fc600000e0100ULL,
0x000000144714a210ULL, 0x000fe40007ffe044ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400371400a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000003755557221ULL, 0x000fe20000010000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b55557820ULL, 0x000fcc0000410000ULL, 0x0000005500557308ULL, 0x000e680000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fcc000001160eULL,
0x00001f1455147589ULL, 0x002e6400000e0000ULL, 0x0000001418187220ULL, 0x082fe20000410000ULL,
0x0000001419197220ULL, 0x080fe20000410000ULL, 0x0000001428287220ULL, 0x080fe20000410000ULL,
0x0000001429297220ULL, 0x080fe20000410000ULL, 0x000000142c2c7220ULL, 0x080fe20000410000ULL,
0x000000142d2d7220ULL, 0x080fe20000410000ULL, 0x0000001430307220ULL, 0x080fe20000410000ULL,
0x0000001431317220ULL, 0x080fe20000410000ULL, 0x0000001424247220ULL, 0x080fe20000410000ULL,
0x0000001425257220ULL, 0x080fe20000410000ULL, 0x0000001420207220ULL, 0x080fe20000410000ULL,
0x0000001421217220ULL, 0x080fe20000410000ULL, 0x000000141c1c7220ULL, 0x080fe20000410000ULL,
0x000000141d1d7220ULL, 0x080fe20000410000ULL, 0x0000001410107220ULL, 0x080fe20000410000ULL,
0x0000001411117220ULL, 0x000fce0000410000ULL, 0x0000005554547220ULL, 0x002fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x000fcc00078ff0ffULL,
0x00001f1455147589ULL, 0x000e6400000e0000ULL, 0x000000141a1a7220ULL, 0x082fe20000410000ULL,
0x000000141b1b7220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x0000001426267220ULL, 0x080fe20000410000ULL,
0x0000001427277220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x000000141e1e7220ULL, 0x080fe20000410000ULL,
0x000000141f1f7220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff557224ULL, 0x000fd400078e0037ULL,
0x8000003716160221ULL, 0x100fe20000010000ULL, 0x000000ffff550224ULL, 0x000fe200078e0037ULL,
0x00007610ff340816ULL, 0x000fe40000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000e640000000800ULL, 0x0000000217170220ULL, 0x002fce0000410000ULL,
0x0000005417547221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x000000083c167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d367824ULL, 0x000fc800078e0216ULL, 0x0176a849360075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff377224ULL, 0x000fce00078e00ffULL,
0x000000103700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000137377836ULL, 0x000fce0000000000ULL,
0x0176a849360075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034157816ULL, 0x000fe200000000ffULL, 0x000000023c527824ULL, 0x000fe200078e00ffULL,
0x000000070e4a7812ULL, 0x000fe200078ec0ffULL, 0x000002003c147824ULL, 0x040fe200078e00ffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000043c587824ULL, 0x000fe200078e00ffULL,
0x0000000452157812ULL, 0x000fe200078ec0ffULL, 0x000020000a4e7824ULL, 0x000fe200078e020dULL,
0xfffff80014167812ULL, 0x000fe400078ec0ffULL, 0x000000084a537812ULL, 0x000fe200078ef80eULL,
0x000130004e487836ULL, 0x000fe20000000000ULL, 0x000000150e147211ULL, 0x040fe200078fe0ffULL,
0x000000010d4b7824ULL, 0x000fe200078e0216ULL, 0x000000080e497812ULL, 0x000fe200078ec0ffULL,
0x0000000853467824ULL, 0x040fe200078e00ffULL, 0x00000004ff597819ULL, 0x000fe2000001160eULL,
0x00000001533f7824ULL, 0x000fe200078e0214ULL, 0x0000000458587812ULL, 0x000fc400078ec0ffULL,
0x0000004a49417212ULL, 0x000fe400078efcffULL, 0xfffffff846467812ULL, 0x000fe200078ee23fULL,
0x0000000159587824ULL, 0x000fe400078e0258ULL, 0x00000008414f7824ULL, 0x040fe400078e00ffULL,
0x0000000141407824ULL, 0x000fe400078e0258ULL, 0x0000001046507824ULL, 0x000fc600078e024bULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee240ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011000005014783bULL, 0x0022e20000000200ULL, 0x000000104f347824ULL, 0x000fe200078e0248ULL,
0x0000000000100947ULL, 0x000fec0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x0000000841427824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x00000002404d7836ULL, 0x000fe20000000000ULL,
0x0000001049497812ULL, 0x000fe200078efe4aULL, 0x000000040a5a7824ULL, 0x000fc600078e0259ULL,
0xfffffff8424d7812ULL, 0x000fe200078ee24dULL, 0x0000000158587824ULL, 0x000fe200078e0249ULL,
0x000000025a5a7810ULL, 0x000fe20007ffe053ULL, 0x0000000853537824ULL, 0x000fe400078e00ffULL,
0x000000104d407824ULL, 0x000fc600078e0248ULL, 0xfffffff8534a7812ULL, 0x000fc600078ee25aULL,
0x000000004040783bULL, 0x000f640000004200ULL, 0x000000104a4a7824ULL, 0x000fe200078e024bULL,
0x000000ff35657812ULL, 0x022fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x100fe40000011634ULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000010ff537819ULL, 0x000fe40000011634ULL,
0x000000ff345c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff346b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff37707812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6c7819ULL, 0x100fe40000011635ULL,
0x00000018ff637819ULL, 0x000fe40000011635ULL, 0x00000018ff627819ULL, 0x108fe40000011640ULL,
0x00000010ff697819ULL, 0x000fc40000011640ULL, 0x000000ff40717812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40607812ULL, 0x000fe400078ec0ffULL, 0x0000ffff356d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x100fe40000011636ULL, 0x000000ff36667812ULL, 0x000fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fc40000011636ULL, 0x0000ffff36347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x100fe40000011641ULL, 0x000000ff41727812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011641ULL, 0x0000ffff416a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5f7819ULL, 0x000fc40000011642ULL, 0x000000ff425e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff42647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff367819ULL, 0x100fe40000011643ULL, 0x000000ff43427812ULL, 0x000fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fc40000011643ULL, 0x0000ffff43617812ULL, 0x000fe400078ec0ffULL,
0x0000005aff35723eULL, 0x000fe200020006ffULL, 0x20000065ff5a7230ULL, 0x000fe20000004100ULL,
0x00000062ff43723eULL, 0x000fe400020006ffULL, 0x00000070ff65723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x0000005dff70723eULL, 0x000fe200020006ffULL,
0x20000043ff5d7230ULL, 0x000fe20000004100ULL, 0x0000005eff43723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000018ff6f7819ULL, 0x000fe20000011637ULL,
0x20000070ff5e7230ULL, 0x000fe20000004100ULL, 0x00000042ff70723eULL, 0x000fc400020006ffULL,
0x00000040ff42723eULL, 0x000fe200020006ffULL, 0x20000043ff407230ULL, 0x000fe20000004100ULL,
0x00000041ff43723eULL, 0x000fe200020006ffULL, 0x20000070ff417230ULL, 0x000fe20000004100ULL,
0x0000006fff70723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff536f7812ULL, 0x000fe200078ec0ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fc40000011637ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000071ff627230ULL, 0x000fe20000004100ULL, 0x00000008ff707819ULL, 0x000fe2000001166dULL,
0x2000006fff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x000000ff6e717812ULL, 0x000fe200078ec0ffULL, 0x2000006cff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff696f7812ULL, 0x000fc400078ec0ffULL, 0x00000070ff6c723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000008ff607819ULL, 0x000fe20000011660ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000ffff375b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff707819ULL, 0x000fe2000001166aULL, 0x20000068ff6a7230ULL, 0x000fe20000004100ULL,
0x0000005cff37723eULL, 0x000fc400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000008ff6b7819ULL, 0x000fe4000001166bULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000067ff68723eULL, 0x000fe200020006ffULL,
0x2000006fff677230ULL, 0x000fe20000004100ULL, 0x000000ff5f6f7812ULL, 0x000fe200078ec0ffULL,
0x20000060ff5f7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000070ff607230ULL, 0x000fe20000004100ULL, 0x00000063ff5c723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x000000ff36707812ULL, 0x000fe200078ec0ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011637ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fc4000001165aULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x000010546e377816ULL, 0x000fe20000000037ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x000010546d367816ULL, 0x000fe20000000036ULL, 0x20000071ff697230ULL, 0x000fe20000004100ULL,
0x00000008ff6e7819ULL, 0x000fc40000011634ULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00000010ff347819ULL, 0x000fe2000001166bULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000010ff6d7819ULL, 0x000fe4000001165cULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000072ff63723eULL, 0x000fe400020006ffULL, 0x0000105435347816ULL, 0x000fc40000000034ULL,
0x000010546d357816ULL, 0x000fe2000000006cULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe40000011666ULL, 0x00000010ff377819ULL, 0x000fe40000011665ULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x0000105469367816ULL, 0x000fc40000000036ULL,
0x000010546a377816ULL, 0x000fe40000000037ULL, 0x00000010ff347819ULL, 0x000fe40000011662ULL,
0x00000010ff357819ULL, 0x000fe40000011663ULL, 0x00000010ff677819ULL, 0x000fe20000011667ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000105467347816ULL, 0x000fe20000000034ULL, 0x2000006fff5a7230ULL, 0x000fe20000004100ULL,
0x0000105468357816ULL, 0x000fe20000000035ULL, 0x20000070ff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x00000008ff6b7819ULL, 0x000fe40000011664ULL,
0x00000008ff657819ULL, 0x000fe20000011661ULL, 0x000000341424723cULL, 0x000fe20000041824ULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff367819ULL, 0x000fe4000001165fULL, 0x00000010ff377819ULL, 0x000fe40000011660ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000006eff647230ULL, 0x000fe20000004100ULL,
0x000010545d367816ULL, 0x000fe20000000036ULL, 0x2000006bff617230ULL, 0x000fe20000004100ULL,
0x000010545e377816ULL, 0x000fe20000000037ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fc40000011640ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff357819ULL, 0x000fe2000001165aULL, 0x000000361420723cULL, 0x000fe20000041820ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x0000105435407816ULL, 0x000fe40000000040ULL,
0x000010545c417816ULL, 0x000fe40000000041ULL, 0x00000010ff367819ULL, 0x000fc40000011653ULL,
0x00000010ff357819ULL, 0x000fe4000001165bULL, 0x00000010ff597819ULL, 0x000fe20000011659ULL,
0x00000040141c723cULL, 0x000fe2000004181cULL, 0x00000010ff347819ULL, 0x000fe40000011664ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff5a7819ULL, 0x000fe40000011643ULL,
0x00000010ff617819ULL, 0x000fe20000011661ULL, 0x0000000849417824ULL, 0x000fe200078e00ffULL,
0x00000010ff377819ULL, 0x000fc40000011665ULL, 0x0000105436357816ULL, 0x000fe40000000035ULL,
0x0000105459347816ULL, 0x000fe40000000034ULL, 0x0000105442367816ULL, 0x000fe40000000061ULL,
0x000010545a377816ULL, 0x000fe40000000037ULL, 0xfffffff8414b7812ULL, 0x000fe200078ee258ULL,
0x000000341430723cULL, 0x000fec0000041830ULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x000000104b347824ULL, 0x000fe200078e0248ULL, 0x011000004a14783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x0000000849407824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x0000000258497836ULL, 0x000fe20000000000ULL, 0xfffffff852527812ULL, 0x000fc800078ec0ffULL,
0xfffffff840497812ULL, 0x000fe200078ee249ULL, 0x000000010d527824ULL, 0x000fc800078e0252ULL,
0x0000001049407824ULL, 0x000fcc00078e0248ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x000000ff34587812ULL, 0x062fe400078ec0ffULL, 0x00000010ff6c7819ULL, 0x100fe40000011634ULL,
0x00000018ff537819ULL, 0x000fe40000011634ULL, 0x0000ffff346d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff347819ULL, 0x000fc40000011635ULL, 0x000000ff365f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fe40000011636ULL, 0x00000058ff69723eULL, 0x000fe400020006ffULL,
0x000000ff355a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x008fe20000011640ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000018ff6f7819ULL, 0x000fc40000011641ULL,
0x00000010ff657819ULL, 0x000fe40000011636ULL, 0x0000ffff36637812ULL, 0x000fe400078ec0ffULL,
0x00000034ff68723eULL, 0x000fe400020006ffULL, 0x000000ff40617812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fc40000011635ULL, 0x0000ffff35647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6b7819ULL, 0x100fe40000011637ULL, 0x000000ff37607812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011637ULL, 0x0000ffff37667812ULL, 0x000fe400078ec0ffULL,
0x00000053ff67723eULL, 0x000fc400020006ffULL, 0x00000010ff347819ULL, 0x000fe40000011640ULL,
0x0000ffff40367812ULL, 0x000fe200078ec0ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005aff6a723eULL, 0x000fe400020006ffULL,
0x00000010ff357819ULL, 0x000fe40000011641ULL, 0x000000ff415c7812ULL, 0x040fe200078ec0ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000ffff41377812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5d7819ULL, 0x100fe40000011642ULL, 0x000000ff42707812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff42537812ULL, 0x000fe400078ec0ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000010ff5e7819ULL, 0x000fc40000011643ULL,
0x000000ff43427812ULL, 0x040fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011643ULL,
0x0000ffff435a7812ULL, 0x000fe400078ec0ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000061ff43723eULL, 0x000fe200020006ffULL, 0x2000005fff617230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL, 0x20000058ff597230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000006fff587230ULL, 0x000fe20000004100ULL,
0x000000ff65657812ULL, 0x000fc400078ec0ffULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x20000060ff627230ULL, 0x000fe20000004100ULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x00000008ff637819ULL, 0x000fe20000011663ULL, 0x2000005bff607230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000043ff5b7230ULL, 0x000fe20000004100ULL,
0x0000006eff6f723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x2000006cff6e7230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000065ff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x000000ff34347812ULL, 0x000fe200078ec0ffULL,
0x20000063ff657230ULL, 0x000fe20000004100ULL, 0x000000ff35357812ULL, 0x000fe400078ec0ffULL,
0x00000042ff43723eULL, 0x000fe200020006ffULL, 0x20000070ff427230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000064ff707230ULL, 0x000fe20000004100ULL,
0x00000034ff63723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000035ff64723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe20000011669ULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc4000001166eULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x000010546f357816ULL, 0x000fe2000000006aULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff667819ULL, 0x000fc40000011666ULL,
0x00000008ff697819ULL, 0x000fe40000011636ULL, 0x00000008ff6a7819ULL, 0x000fe20000011637ULL,
0x000000341418723cULL, 0x000fe20000041818ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff367819ULL, 0x000fe4000001166dULL,
0x00000010ff377819ULL, 0x000fc40000011670ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x0000105467367816ULL, 0x000fe40000000036ULL, 0x0000105468377816ULL, 0x000fe20000000037ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe40000011661ULL,
0x00000010ff357819ULL, 0x000fe4000001166cULL, 0x00000010ff677819ULL, 0x000fe20000011662ULL,
0x000000361428723cULL, 0x000fe20000041828ULL, 0x00000010ff687819ULL, 0x000fc4000001166bULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x0000105468357816ULL, 0x000fe20000000067ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff367819ULL, 0x000fe20000011665ULL, 0x00000034142c723cULL, 0x000fe2000004182cULL,
0x00000010ff377819ULL, 0x000fc40000011666ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x20000069ff617230ULL, 0x000fe20000004100ULL, 0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL,
0x2000006aff627230ULL, 0x000fe20000004100ULL, 0x000010545f367816ULL, 0x000fe40000000036ULL,
0x0000105460377816ULL, 0x000fc40000000037ULL, 0x00000010ff347819ULL, 0x000fe4000001165bULL,
0x00000010ff357819ULL, 0x000fe4000001165cULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x000000361430723cULL, 0x000fe20000041830ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fc400020006ffULL,
0x0000105463347816ULL, 0x000fe20000000034ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x0000105464357816ULL, 0x000fe20000000035ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff537819ULL, 0x000fe40000011653ULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x000000341424723cULL, 0x000fe20000041824ULL,
0x00000010ff587819ULL, 0x000fc40000011658ULL, 0x00000010ff367819ULL, 0x000fe40000011661ULL,
0x00000010ff377819ULL, 0x000fe40000011662ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000105459367816ULL, 0x000fe20000000036ULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000105458377816ULL, 0x000fe20000000037ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc40000011642ULL,
0x00000010ff357819ULL, 0x000fe40000011643ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x000000361420723cULL, 0x000fe20000041820ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x000010545d347816ULL, 0x000fe40000000034ULL, 0x000010545e357816ULL, 0x000fe40000000035ULL,
0x00000010ff377819ULL, 0x000fc40000011640ULL, 0x00000010ff367819ULL, 0x000fe40000011653ULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x00000034141c723cULL, 0x000fe2000004181cULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105441377816ULL, 0x000fe2000000005aULL, 0x00000001ff417424ULL, 0x000fe400078e00ffULL,
0x000000080a347824ULL, 0x000fc800078e020dULL, 0x000000361410723cULL, 0x000fe40000041810ULL,
0x0176c841343479a7ULL, 0x0002e2000850003fULL, 0x0176884152ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035040075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00008e00ff147b82ULL, 0x000ee20000000a00ULL,
0x000000103c357824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x000000044c4c7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe035167812ULL, 0x000fe400078ec0ffULL,
0x000000404c177824ULL, 0x000fc600078e00ffULL, 0x0000010005167824ULL, 0x000fc800078e0216ULL,
0x0000008016347836ULL, 0x000fca0000000000ULL, 0x0000002034167812ULL, 0x000fe200078ec0ffULL,
0x0000008017147825ULL, 0x008fc800078e0014ULL, 0x000000010b377824ULL, 0x000fe200078e0216ULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x0000003439167248ULL, 0x000fe40007fe0000ULL,
0x0000001035357812ULL, 0x000fe400078ec0ffULL, 0x00000003ff177819ULL, 0x000fe2000001160eULL,
0x0000000116167824ULL, 0x000fc800078e0a34ULL, 0x0000000117347824ULL, 0x140fe200078e0235ULL,
0x0000001635167248ULL, 0x000fe20007fe0000ULL, 0x0000000417407836ULL, 0x000fe40000000000ULL,
0x0000000134367824ULL, 0x140fe400078e020eULL, 0x0000000834537824ULL, 0x000fe400078e00ffULL,
0x0000000116167824ULL, 0x100fe400078e0a35ULL, 0x0000000c17417836ULL, 0x002fe20000000000ULL,
0xfffffff853537812ULL, 0x000fe200078ee236ULL, 0x0000000817367836ULL, 0x000fe20000000000ULL,
0x000000164000720cULL, 0x0c0fe20003f66070ULL, 0x0000000140407824ULL, 0x100fe200078e0235ULL,
0x000000161700720cULL, 0x080fe20003f86070ULL, 0x0000000141427824ULL, 0x140fe200078e0235ULL,
0x000000163600720cULL, 0x0c0fe20003f46070ULL, 0x0000000136367824ULL, 0x000fe200078e0235ULL,
0x000000164100720cULL, 0x000fe20003f06070ULL, 0x0000000140177824ULL, 0x000fc400078e020eULL,
0x00000008404c7824ULL, 0x040fe400078e00ffULL, 0x0000000140407824ULL, 0x100fe400078e0237ULL,
0x0000000136357824ULL, 0x040fe200078e020eULL, 0xfffffff84c5d7812ULL, 0x000fe200078ee217ULL,
0x0000000836527824ULL, 0x000fe400078e00ffULL, 0x0000000134347824ULL, 0x000fe400078e0237ULL,
0x0000008040407825ULL, 0x000fe200078e00ffULL, 0xfffffff8525f7812ULL, 0x000fc600078ee235ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004440177212ULL, 0x000fc600078efcffULL,
0x0000000136367824ULL, 0x100fe200078e0237ULL, 0x0000004434437212ULL, 0x000fe200078efcffULL,
0x0000000142167824ULL, 0x000fe200078e0237ULL, 0x0000001714407210ULL, 0x000fe20007fde0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004314347210ULL, 0x000fc60007fbe0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000044365b7212ULL, 0x000fc600078efcffULL,
0x00000001424c7824ULL, 0x000fe200078e020eULL, 0x0000004416597212ULL, 0x000fe200078efcffULL,
0x0000000842617824ULL, 0x000fe400078e00ffULL, 0x0000000115357824ULL, 0x040fe200028e0635ULL,
0x0000005b14367210ULL, 0x000fe20007fbe0ffULL, 0x0000000115417824ULL, 0x000fe200030e0641ULL,
0xfffffff861617812ULL, 0x000fe200078ee24cULL, 0x0000001053437824ULL, 0x100fe200078e0248ULL,
0x0000005914147210ULL, 0x000fe20007fde0ffULL, 0x000000105d537824ULL, 0x000fc400078e0248ULL,
0x000000105f597824ULL, 0x100fe200078e0248ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034437faeULL, 0x0003e2000e101c46ULL, 0x0000000115377824ULL, 0x000fe400028e0637ULL,
0x00000010615b7824ULL, 0x000fe200078e0248ULL, 0x0000000040537faeULL, 0x0003e2000d901c46ULL,
0x0000000115157824ULL, 0x000fc600030e0617ULL, 0x0000000036597faeULL, 0x0003e8000d101c46ULL,
0x00000000145b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x0000001035357812ULL, 0x000fc800078ec0ffULL, 0x000000350e357211ULL, 0x000fca00078fe8ffULL,
0x0000000135177824ULL, 0x040fe400078e020eULL, 0x0000000835367824ULL, 0x040fe400078e00ffULL,
0x0000000135167824ULL, 0x000fe400078e0237ULL, 0x0000000435347836ULL, 0x000fe20000000000ULL,
0xfffffff836437812ULL, 0x000fe200078ee217ULL, 0x0000000835427836ULL, 0x000fe40000000000ULL,
0x0000000c354c7836ULL, 0x000fc40000000000ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000000134367824ULL, 0x100fe200078e0237ULL, 0x0000004416357212ULL, 0x000fe200078efcffULL,
0x0000000134417824ULL, 0x142fe400078e020eULL, 0x0000000834527824ULL, 0x000fe200078e00ffULL,
0x0000003514167210ULL, 0x000fe20007f1e0ffULL, 0x0000000142407824ULL, 0x100fe400078e0237ULL,
0x000000014c347824ULL, 0x000fe200078e0237ULL, 0xfffffff852537812ULL, 0x000fe200078ee241ULL,
0x0000000142377824ULL, 0x000fc400078e020eULL, 0x0000000842587824ULL, 0x000fe400078e00ffULL,
0x0000008040407825ULL, 0x000fc600078e00ffULL, 0xfffffff858597812ULL, 0x000fe200078ee237ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000044405d7212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x00000044365f7212ULL, 0x080fe400078efcffULL,
0x0000005d14407210ULL, 0x000fe20007f5e0ffULL, 0x000000014c427824ULL, 0x000fe200078e020eULL,
0x00000044345b7212ULL, 0x000fe200078efcffULL, 0x000000084c617824ULL, 0x000fe400078e00ffULL,
0x0000000115177824ULL, 0x000fe200000e0617ULL, 0x0000005f14367210ULL, 0x000fe20007f1e0ffULL,
0x0000001043437824ULL, 0x100fe200078e0248ULL, 0xfffffff861617812ULL, 0x000fe200078ee242ULL,
0x0000001053537824ULL, 0x100fe200078e0248ULL, 0x0000005b14147210ULL, 0x000fe20007f7e0ffULL,
0x0000000115377824ULL, 0x000fe200000e0637ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016437faeULL, 0x0003e2000b901c46ULL, 0x0000001059597824ULL, 0x000fc400078e0248ULL,
0x0000000115417824ULL, 0x000fe200010e0641ULL, 0x0000000036537faeULL, 0x0003e2000b901c46ULL,
0x00000010615b7824ULL, 0x000fe400078e0248ULL, 0x0000000115157824ULL, 0x000fe200018e0635ULL,
0x0000000040597faeULL, 0x0003e8000b901c46ULL, 0x00000000145b7faeULL, 0x0003e4000b901c46ULL,
0x0000000209177836ULL, 0x002fe40000000000ULL, 0xffffffffff537424ULL, 0x000fc600078e00ffULL,
0x0000003a1700720cULL, 0x000fe20003f06070ULL, 0x000000083c167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d167824ULL, 0x000fe400078e0216ULL,
0x00009000ff148b82ULL, 0x000e620000000a00ULL, 0x0000000106178824ULL, 0x000fe400078e0217ULL,
0x00000000160472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176a804047890ULL, 0x000fe2000fffe03fULL, 0x0000000417148825ULL, 0x002fd000078e0014ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a44ULL, 0x0000000614538981ULL, 0x000322000c1e1900ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0176a817165879a7ULL, 0x000764000850003fULL, 0x01762817511479a7ULL, 0x022664000850003fULL,
0x0000000000167805ULL, 0x008fce0000015200ULL, 0x01762815510075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003416377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e17ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01762815510075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000203c147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x000000800d147810ULL, 0x000fc80007ffe014ULL,
0x0000001447147210ULL, 0x000fca0007ffe044ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0006e20000000800ULL, 0x000000551600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x000000010c157836ULL, 0x000fe20000000000ULL,
0x000000551600720bULL, 0x000fc80003f14000ULL, 0x0000003c1500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000803c15a824ULL, 0x000fe200078e020dULL,
0x000000551614a209ULL, 0x000fc80007810000ULL, 0x000000154737a210ULL, 0x000fe40007ffe044ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005516147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005514147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160eULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001554547220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005516557209ULL, 0x000fd60007810000ULL,
0x8000005516160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005417547221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x000000083c167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d377824ULL, 0x000fc800078e0216ULL,
0x0176b057370075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x000140004e487836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000104f4c7824ULL, 0x000fd800078e0248ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011800005014783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000104d407824ULL, 0x000fe200078e0248ULL, 0x000000004c34783bULL, 0x000f6a0000004200ULL,
0x000000004040783bULL, 0x000f640000004200ULL, 0x00000010ff527819ULL, 0x022fe40000011634ULL,
0x000000ff345a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011634ULL,
0x0000ffff34687812ULL, 0x000fe400078ec0ffULL, 0x000000ff35347812ULL, 0x000fe400078ec0ffULL,
0x000000ff405b7812ULL, 0x008fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x000fe40000011641ULL,
0x000000ff41707812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011641ULL,
0x0000ffff41677812ULL, 0x000fe400078ec0ffULL, 0x000000ff42417812ULL, 0x000fe400078ec0ffULL,
0x00000034ff65723eULL, 0x000fe400020006ffULL, 0x00000010ff347819ULL, 0x100fe40000011643ULL,
0x000000ff436e7812ULL, 0x000fe200078ec0ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000018ff6d7819ULL, 0x000fc40000011643ULL, 0x0000ffff43617812ULL, 0x000fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe40000011640ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000006fff43723eULL, 0x000fe400020006ffULL, 0x00000010ff6c7819ULL, 0x100fe40000011637ULL,
0x000000ff37727812ULL, 0x000fe200078ec0ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000018ff717819ULL, 0x000fc40000011637ULL, 0x0000ffff37667812ULL, 0x000fe400078ec0ffULL,
0x00000041ff6f723eULL, 0x000fe400020006ffULL, 0x00000010ff6a7819ULL, 0x100fe40000011636ULL,
0x000000ff36637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011636ULL,
0x0000ffff366b7812ULL, 0x000fc400078ec0ffULL, 0x00000057ff37723eULL, 0x000fe400020006ffULL,
0x00000010ff5c7819ULL, 0x100fe40000011642ULL, 0x00000018ff577819ULL, 0x000fe20000011642ULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x0000ffff42367812ULL, 0x000fe400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000060ff42723eULL, 0x000fe200020006ffULL,
0x2000005bff607230ULL, 0x000fe20000004100ULL, 0x00000010ff567819ULL, 0x000fe20000011635ULL,
0x2000006fff5b7230ULL, 0x000fe20000004100ULL, 0x000000ff52527812ULL, 0x000fe200078ec0ffULL,
0x20000070ff417230ULL, 0x000fe20000004100ULL, 0x0000006eff6f723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff566e7812ULL, 0x000fc400078ec0ffULL,
0x0000006dff70723eULL, 0x000fe400020006ffULL, 0x00000052ff6d723eULL, 0x000fe200020006ffULL,
0x2000006fff527230ULL, 0x000fe20000004100ULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff6a6f7812ULL, 0x000fe400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000006eff6a7230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x00000010ff647819ULL, 0x000fe40000011640ULL, 0x00000008ff6e7819ULL, 0x000fe2000001166bULL,
0x20000068ff6b7230ULL, 0x000fe20000004100ULL, 0x0000ffff405e7812ULL, 0x000fe200078ec0ffULL,
0x2000006fff687230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x000000ff646f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011635ULL,
0x2000006eff647230ULL, 0x000fe20000004100ULL, 0x0000ffff35697812ULL, 0x000fc400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x0000005aff35723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x0000005dff6e723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000008ff697819ULL, 0x000fe40000011669ULL, 0x0000005eff5d723eULL, 0x000fe200020006ffULL,
0x20000057ff567230ULL, 0x000fe20000004100ULL, 0x00000067ff5e723eULL, 0x000fe200020006ffULL,
0x2000006fff677230ULL, 0x000fe20000004100ULL, 0x000000ff5c6f7812ULL, 0x000fe200078ec0ffULL,
0x2000006eff5c7230ULL, 0x000fe20000004100ULL, 0x0000005fff5a723eULL, 0x000fe200020006ffULL,
0x20000070ff577230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff346e7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe20000011635ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff6c707812ULL, 0x000fe200078ec0ffULL,
0x20000069ff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc40000011665ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000070ff69723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x000010546a357816ULL, 0x000fc40000000035ULL, 0x000010546d347816ULL, 0x000fe20000000034ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000008ff6a7819ULL, 0x000fe40000011636ULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff377819ULL, 0x000fe20000011637ULL,
0x000000341418723cULL, 0x000fe20000041818ULL, 0x00000010ff367819ULL, 0x000fe4000001166bULL,
0x00000010ff6d7819ULL, 0x000fc4000001165aULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000062ff40723eULL, 0x000fe200020006ffULL, 0x20000072ff627230ULL, 0x000fe20000004100ULL,
0x00000071ff5f723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000010546d377816ULL, 0x000fe2000000006cULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc40000011663ULL,
0x00000010ff357819ULL, 0x000fe40000011668ULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x000000361428723cULL, 0x000fe20000041828ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x0000105469357816ULL, 0x000fe40000000062ULL,
0x00000008ff6b7819ULL, 0x000fc40000011661ULL, 0x00000010ff377819ULL, 0x000fe40000011640ULL,
0x00000010ff367819ULL, 0x000fe20000011664ULL, 0x00000034142c723cULL, 0x000fe2000004182cULL,
0x00000010ff637819ULL, 0x000fe4000001165fULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006aff617230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000006fff657230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000006eff5a7230ULL, 0x000fe20000004100ULL,
0x0000105463377816ULL, 0x000fe20000000066ULL, 0x2000006bff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe40000011642ULL, 0x00000010ff427819ULL, 0x000fc4000001165dULL,
0x00000010ff347819ULL, 0x000fe20000011643ULL, 0x000000361430723cULL, 0x000fe20000041830ULL,
0x0000105435427816ULL, 0x000fe40000000042ULL, 0x00000010ff437819ULL, 0x000fe4000001165eULL,
0x00000010ff357819ULL, 0x000fe40000011652ULL, 0x00000010ff377819ULL, 0x000fe40000011656ULL,
0x00000010ff367819ULL, 0x000fc40000011661ULL, 0x00000010ff407819ULL, 0x000fe40000011660ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff5e7819ULL, 0x000fc40000011665ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff527819ULL, 0x000fe40000011657ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x0000105434437816ULL, 0x000fe40000000043ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105467407816ULL, 0x000fc40000000040ULL, 0x000010545c417816ULL, 0x000fe20000000041ULL,
0x000000421420723cULL, 0x000fe20000041820ULL, 0x000010545e347816ULL, 0x000fe4000000005bULL,
0x000010545a357816ULL, 0x000fe40000000035ULL, 0x0000105452377816ULL, 0x000fe2000000005fULL,
0x000000401424723cULL, 0x000fe20000041824ULL, 0x000000104b527824ULL, 0x000fca00078e0248ULL,
0x00000034141c723cULL, 0x000fec000004181cULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x011800004a14783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x0000001049407824ULL, 0x000fe200078e0248ULL,
0x000000005234783bULL, 0x000f6a0000004200ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x00000010ff6d7819ULL, 0x022fe40000011634ULL, 0x000000ff34577812ULL, 0x000fc400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe40000011634ULL, 0x0000ffff346e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff355a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff347819ULL, 0x000fe40000011635ULL,
0x000000ff36607812ULL, 0x000fe400078ec0ffULL, 0x000000ff37617812ULL, 0x000fc400078ec0ffULL,
0x0000ffff35657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x100fe40000011636ULL,
0x00000018ff5b7819ULL, 0x000fe40000011637ULL, 0x00000010ff687819ULL, 0x000fe40000011636ULL,
0x0000ffff36647812ULL, 0x000fe400078ec0ffULL, 0x0000005aff6b723eULL, 0x000fc400020006ffULL,
0x00000034ff67723eULL, 0x000fe400020006ffULL, 0x000000ff40627812ULL, 0x008fe200078ec0ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe20000011635ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe40000011637ULL,
0x0000ffff376c7812ULL, 0x000fe400078ec0ffULL, 0x00000056ff66723eULL, 0x000fc400020006ffULL,
0x00000010ff347819ULL, 0x100fe40000011640ULL, 0x00000018ff5a7819ULL, 0x000fe20000011640ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000ffff40367812ULL, 0x000fe400078ec0ffULL,
0x00000057ff6a723eULL, 0x000fe400020006ffULL, 0x00000010ff357819ULL, 0x100fe40000011641ULL,
0x000000ff415d7812ULL, 0x000fe200078ec0ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000018ff707819ULL, 0x000fc40000011641ULL, 0x0000ffff41377812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011642ULL, 0x000000ff42717812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff42567812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000010ff5f7819ULL, 0x100fe40000011643ULL, 0x000000ff43427812ULL, 0x040fe200078ec0ffULL,
0x20000061ff637230ULL, 0x000fe20000004100ULL, 0x00000018ff417819ULL, 0x000fe40000011643ULL,
0x0000ffff43577812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x00000062ff43723eULL, 0x000fe200020006ffULL, 0x20000060ff627230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000005cff607230ULL, 0x000fe20000004100ULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x2000005bff617230ULL, 0x000fe20000004100ULL,
0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL, 0x20000043ff5c7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x000000ff69697812ULL, 0x000fe400078ec0ffULL, 0x00000070ff5b723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000008ff6c7819ULL, 0x000fe2000001166cULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000042ff43723eULL, 0x000fe200020006ffULL,
0x20000071ff427230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000065ff717230ULL, 0x000fe20000004100ULL, 0x0000006fff70723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fe2000001166eULL,
0x2000006dff6f7230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fc400020006ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000068ff6d7230ULL, 0x000fe20000004100ULL,
0x0000006cff65723eULL, 0x000fe200020006ffULL, 0x20000069ff6c7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000064ff687230ULL, 0x000fe20000004100ULL,
0x000000ff34347812ULL, 0x000fe200078ec0ffULL, 0x20000065ff697230ULL, 0x000fe20000004100ULL,
0x000000ff35357812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000034ff64723eULL, 0x000fc400020006ffULL, 0x00000035ff65723eULL, 0x000fe400020006ffULL,
0x00000010ff347819ULL, 0x000fe2000001166aULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe2000001166bULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000008ff6a7819ULL, 0x000fc40000011636ULL, 0x00000008ff6b7819ULL, 0x000fe40000011637ULL,
0x000010546f347816ULL, 0x000fe40000000034ULL, 0x0000105470357816ULL, 0x000fe40000000035ULL,
0x00000010ff377819ULL, 0x000fe40000011666ULL, 0x00000010ff367819ULL, 0x000fe4000001166eULL,
0x00000010ff667819ULL, 0x000fe20000011667ULL, 0x000000341418723cULL, 0x000fe20000041818ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105466377816ULL, 0x000fe40000000071ULL, 0x00000010ff347819ULL, 0x000fe40000011662ULL,
0x00000010ff357819ULL, 0x000fe40000011663ULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x000000361428723cULL, 0x000fe20000041828ULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x000010546d347816ULL, 0x000fe40000000034ULL,
0x000010546c357816ULL, 0x000fe20000000035ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff377819ULL, 0x000fe40000011660ULL,
0x00000010ff367819ULL, 0x000fe20000011668ULL, 0x00000034142c723cULL, 0x000fe2000004182cULL,
0x00000010ff5e7819ULL, 0x000fc40000011661ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000006aff627230ULL, 0x000fe20000004100ULL,
0x000010545e377816ULL, 0x000fe20000000069ULL, 0x2000006bff637230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fc4000001165cULL, 0x00000010ff357819ULL, 0x000fe40000011664ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x000000361430723cULL, 0x000fe20000041830ULL,
0x00000010ff5c7819ULL, 0x000fe40000011665ULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x000010545c357816ULL, 0x000fe4000000005dULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff5c7819ULL, 0x000fe40000011656ULL,
0x00000010ff377819ULL, 0x000fe2000001165aULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011662ULL, 0x000000341424723cULL, 0x000fe20000041824ULL,
0x00000008ff577819ULL, 0x000fc40000011657ULL, 0x00000010ff567819ULL, 0x000fe4000001165bULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000105456377816ULL, 0x000fc40000000063ULL,
0x00000010ff347819ULL, 0x000fe20000011642ULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe40000011666ULL, 0x00000010ff437819ULL, 0x000fe20000011643ULL,
0x000000361420723cULL, 0x000fe20000041820ULL, 0x00000010ff427819ULL, 0x000fe4000001165fULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x0000105442357816ULL, 0x000fc40000000043ULL,
0x00000010ff377819ULL, 0x000fe40000011640ULL, 0x00000010ff407819ULL, 0x000fe20000011641ULL,
0x000000023c417824ULL, 0x000fe200078e00ffULL, 0x00000010ff367819ULL, 0x000fe2000001165cULL,
0x00000034141c723cULL, 0x000fe2000004181cULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x0000105440377816ULL, 0x000fc40000000057ULL,
0xfffffff841407812ULL, 0x000fe200078ec0ffULL, 0x000000080a347824ULL, 0x000fe400078e020dULL,
0x00000001ff417424ULL, 0x000fe400078e00ffULL, 0x000000010d407824ULL, 0x000fe200078e0240ULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x0176c841343479a7ULL, 0x0002e4000850003fULL,
0x0176904140ff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035040075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00008e00ff147b82ULL, 0x000ee20000000a00ULL, 0x000000103c167824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000453537c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe016347812ULL, 0x000fe400078ec0ffULL, 0x0000004053537824ULL, 0x000fc600078e00ffULL,
0x0000010005177824ULL, 0x000fc800078e0234ULL, 0x000000c017177836ULL, 0x000fca0000000000ULL,
0x0000002017347812ULL, 0x000fe200078ec0ffULL, 0x0000008053147825ULL, 0x008fc800078e0014ULL,
0x000000010b347824ULL, 0x000fe200078e0234ULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x0000001016357812ULL, 0x000fe400078ec0ffULL, 0x0000001739167248ULL, 0x000fe40007fe0000ULL,
0x00000003ff367819ULL, 0x000fc6000001160eULL, 0x0000000116167824ULL, 0x000fe400078e0a17ULL,
0x0000000136177824ULL, 0x100fe400078e0235ULL, 0x0000000436407836ULL, 0x002fe20000000000ULL,
0x0000001635167248ULL, 0x000fe20007fe0000ULL, 0x0000000117377824ULL, 0x040fe400078e020eULL,
0x0000000817427824ULL, 0x000fe400078e00ffULL, 0x0000000116167824ULL, 0x000fc400078e0a35ULL,
0x0000000836417836ULL, 0x000fe20000000000ULL, 0xfffffff842577812ULL, 0x000fe200078ee237ULL,
0x0000000140377824ULL, 0x140fe200078e0235ULL, 0x000000164000720cULL, 0x080fe20003f66070ULL,
0x0000000c36407836ULL, 0x000fe20000000000ULL, 0x000000163600720cULL, 0x080fe20003f86070ULL,
0x0000000117177824ULL, 0x000fe200078e0234ULL, 0x000000164100720cULL, 0x0c0fe20003f46070ULL,
0x0000000141417824ULL, 0x000fe200078e0235ULL, 0x000000164000720cULL, 0x000fe20003f06070ULL,
0x0000008017167825ULL, 0x000fc800078e00ffULL, 0x00000001405f7824ULL, 0x000fe400078e0235ULL,
0x0000000137407824ULL, 0x040fe400078e0234ULL, 0x0000000137367824ULL, 0x040fe400078e020eULL,
0x00000008375b7824ULL, 0x000fe200078e00ffULL, 0x0000004416377212ULL, 0x000fe200078efcffULL,
0x0000000141357824ULL, 0x040fe400078e0234ULL, 0x0000000141427824ULL, 0x040fe200078e020eULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee236ULL, 0x00000008415d7824ULL, 0x000fe200078e00ffULL,
0x0000003714167210ULL, 0x000fe20007fbe0ffULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee242ULL, 0x000000015f367824ULL, 0x000fe200078e0234ULL,
0x0000004440437212ULL, 0x000fe200078efcffULL, 0x0000008035347825ULL, 0x000fc800078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004434537212ULL, 0x000fc600078efcffULL,
0x0000000115177824ULL, 0x000fe200028e0617ULL, 0x0000004314407210ULL, 0x000fe20007fbe0ffULL,
0x000000015f427824ULL, 0x040fe200078e020eULL, 0x0000004436437212ULL, 0x000fe200078efcffULL,
0x000000085f5f7824ULL, 0x000fe400078e00ffULL, 0x0000000115417824ULL, 0x000fe200028e0641ULL,
0x0000005314347210ULL, 0x000fe20007fbe0ffULL, 0x0000001057577824ULL, 0x100fe200078e0248ULL,
0x0000004314147210ULL, 0x000fe20007fde0ffULL, 0x000000105b5b7824ULL, 0x100fe200078e0248ULL,
0xfffffff85f437812ULL, 0x000fe200078ee242ULL, 0x0000000115357824ULL, 0x000fe200028e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016577faeULL, 0x0003e2000e101c46ULL,
0x000000105d5d7824ULL, 0x000fc400078e0248ULL, 0x0000000115157824ULL, 0x000fe200030e0637ULL,
0x00000000405b7faeULL, 0x0003e2000d901c46ULL, 0x0000001043437824ULL, 0x000fc600078e0248ULL,
0x00000000345d7faeULL, 0x0003e8000d101c46ULL, 0x0000000014437faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x0000001016177812ULL, 0x000fc800078ec0ffULL,
0x000000170e177211ULL, 0x000fca00078fe8ffULL, 0x0000000417357836ULL, 0x000fe40000000000ULL,
0x0000000817377836ULL, 0x000fe40000000000ULL, 0x0000000135367824ULL, 0x140fe400078e020eULL,
0x00000008355d7824ULL, 0x000fe400078e00ffULL, 0x0000000117167824ULL, 0x140fe400078e020eULL,
0x00000008175b7824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL,
0x0000000137407824ULL, 0x002fc400078e020eULL, 0x00000008375f7824ULL, 0x000fe200078e00ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee216ULL, 0x0000000117367824ULL, 0x100fe400078e0234ULL,
0x0000000c17177836ULL, 0x000fe20000000000ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee240ULL,
0x0000000137167824ULL, 0x000fe400078e0234ULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x0000000135407824ULL, 0x100fe200078e0234ULL, 0x0000004436437212ULL, 0x000fe200078efcffULL,
0x0000000117347824ULL, 0x040fe400078e0234ULL, 0x0000000117427824ULL, 0x040fe200078e020eULL,
0x0000004314367210ULL, 0x000fe20007f1e0ffULL, 0x0000000817617824ULL, 0x000fe400078e00ffULL,
0x0000008040407825ULL, 0x000fc600078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee242ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004440577212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004416537212ULL, 0x080fe400078efcffULL,
0x0000005714407210ULL, 0x000fe20007f5e0ffULL, 0x0000000115377824ULL, 0x000fe200000e0637ULL,
0x0000004434437212ULL, 0x000fe200078efcffULL, 0x000000105b5b7824ULL, 0x100fe200078e0248ULL,
0x0000005314167210ULL, 0x000fe20007f1e0ffULL, 0x0000000115417824ULL, 0x000fe200010e0641ULL,
0x0000004314147210ULL, 0x000fe20007f7e0ffULL, 0x000000105d5d7824ULL, 0x000fe200078e0248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000365b7faeULL, 0x0003e2000b901c46ULL,
0x0000000115177824ULL, 0x000fc400000e0617ULL, 0x000000105f5f7824ULL, 0x100fe200078e0248ULL,
0x00000000405d7faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fe400018e0635ULL,
0x0000001061617824ULL, 0x000fe200078e0248ULL, 0x00000000165f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014617faeULL, 0x0003e4000b901c46ULL, 0x0000000309177836ULL, 0x002fe40000000000ULL,
0xffffffffff537424ULL, 0x000fc600078e00ffULL, 0x0000003a1700720cULL, 0x000fe20003f06070ULL,
0x000000083c167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d167824ULL, 0x000fe400078e0216ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x0000000106178824ULL, 0x000fe400078e0217ULL, 0x00000000160472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000417148825ULL, 0x002fd000078e0014ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x0000000614538981ULL, 0x000322000c1e1900ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0176b017165679a7ULL, 0x000764000850003fULL,
0x01764817511479a7ULL, 0x022664000850003fULL, 0x0000000000167805ULL, 0x008fce0000015200ULL,
0x01764815510075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003416377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01764815510075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000203c147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x000001000d147810ULL, 0x000fc80007ffe014ULL, 0x0000001447147210ULL, 0x000fca0007ffe044ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0006e20000000800ULL,
0x000000551600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x000000020c157836ULL, 0x000fe20000000000ULL, 0x000000551600720bULL, 0x000fc80003f14000ULL,
0x0000003c1500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000803c15a824ULL, 0x000fe200078e020dULL, 0x000000551614a209ULL, 0x000fc80007810000ULL,
0x000000154737a210ULL, 0x000fe40007ffe044ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400143700a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005516147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005514147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160eULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001554547220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005516557209ULL, 0x000fd60007810000ULL, 0x8000005516160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005417547221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x000000083c167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d377824ULL, 0x000fc800078e0216ULL, 0x0176a859370075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176a859370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x000130004e4e7836ULL, 0x000fc60000000000ULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x000000104f357824ULL, 0x000fd800078e024eULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x012000005014783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000104d407824ULL, 0x000fe200078e024eULL,
0x000000003534783bULL, 0x000f6a0000004200ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x000000ff34517812ULL, 0x022fe400078ec0ffULL, 0x00000018ff507819ULL, 0x000fc40000011634ULL,
0x00000018ff587819ULL, 0x000fe40000011635ULL, 0x00000018ff5d7819ULL, 0x100fe40000011637ULL,
0x00000010ff647819ULL, 0x000fe40000011637ULL, 0x000000ff376c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff375f7812ULL, 0x000fe400078ec0ffULL, 0x00000051ff62723eULL, 0x000fc400020006ffULL,
0x00000010ff667819ULL, 0x100fe40000011636ULL, 0x000000ff365c7812ULL, 0x040fe200078ec0ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000018ff5a7819ULL, 0x000fe40000011636ULL,
0x0000ffff36657812ULL, 0x000fe400078ec0ffULL, 0x00000050ff37723eULL, 0x000fe400020006ffULL,
0x000000ff406d7812ULL, 0x008fc400078ec0ffULL, 0x00000010ff607819ULL, 0x100fe20000011641ULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x000000ff416e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe40000011641ULL, 0x0000ffff41677812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x000fe40000011642ULL, 0x000000ff42417812ULL, 0x000fc400078ec0ffULL,
0x00000018ff507819ULL, 0x000fe40000011642ULL, 0x0000ffff42367812ULL, 0x000fe400078ec0ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000005dff42723eULL, 0x000fe400020006ffULL,
0x00000010ff687819ULL, 0x100fe40000011640ULL, 0x00000018ff597819ULL, 0x000fc40000011640ULL,
0x0000ffff40637812ULL, 0x000fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x0000005aff40723eULL, 0x000fe200020006ffULL, 0x20000058ff5a7230ULL, 0x000fe20000004100ULL,
0x00000018ff6b7819ULL, 0x000fe20000011643ULL, 0x20000042ff587230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fc40000011635ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x0000ffff34617812ULL, 0x000fe400078ec0ffULL,
0x00000059ff42723eULL, 0x000fe200020006ffULL, 0x2000006dff597230ULL, 0x000fe20000004100ULL,
0x000000ff436a7812ULL, 0x000fe200078ec0ffULL, 0x2000006cff5c7230ULL, 0x000fe20000004100ULL,
0x0000006bff6d723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff4d6b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x0000006aff6c723eULL, 0x000fe400020006ffULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x0000ffff35697812ULL, 0x000fe200078ec0ffULL, 0x2000006cff4d7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x000000ff64647812ULL, 0x000fc400078ec0ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x00000008ff6c7819ULL, 0x000fe20000011669ULL,
0x2000006bff697230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000061ff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff4f7819ULL, 0x000fc40000011634ULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x00000065ff61723eULL, 0x000fe200020006ffULL, 0x20000066ff657230ULL, 0x000fe20000004100ULL,
0x000000ff35347812ULL, 0x000fe200078ec0ffULL, 0x20000064ff667230ULL, 0x000fe20000004100ULL,
0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x00000068ff64723eULL, 0x000fe400020006ffULL,
0x000000ff60687812ULL, 0x000fe400078ec0ffULL, 0x00000008ff607819ULL, 0x000fe20000011663ULL,
0x2000005fff637230ULL, 0x000fe20000004100ULL, 0x00000034ff35723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x0000004fff6a723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fc400020006ffULL, 0x00000060ff5f723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000050ff4f7230ULL, 0x000fe20000004100ULL, 0x00000067ff60723eULL, 0x000fe200020006ffULL,
0x2000006dff507230ULL, 0x000fe20000004100ULL, 0x000000ff5e677812ULL, 0x000fe200078ec0ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe20000011643ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000ffff435b7812ULL, 0x000fc400078ec0ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000051ff43723eULL, 0x000fe400020006ffULL,
0x00000041ff51723eULL, 0x000fe200020006ffULL, 0x2000006eff417230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000068ff5e7230ULL, 0x000fe20000004100ULL,
0x00000067ff6d723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000000ff346e7812ULL, 0x000fe200078ec0ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe20000011635ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe20000011662ULL, 0x2000006dff627230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc4000001166aULL, 0x00000010ff687819ULL, 0x000fe40000011669ULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x0000105468357816ULL, 0x000fe40000000067ULL,
0x00000008ff687819ULL, 0x000fe40000011636ULL, 0x00000010ff377819ULL, 0x000fe40000011637ULL,
0x00000010ff367819ULL, 0x000fe2000001166bULL, 0x000000341418723cULL, 0x000fe20000041818ULL,
0x00000010ff677819ULL, 0x000fc4000001165aULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x0000105467377816ULL, 0x000fe4000000006cULL,
0x00000010ff347819ULL, 0x000fe4000001165dULL, 0x00000010ff357819ULL, 0x000fe4000001165cULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x000000361428723cULL, 0x000fe20000041828ULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x00000008ff677819ULL, 0x000fe4000001165bULL,
0x0000105465347816ULL, 0x000fe40000000034ULL, 0x0000105466357816ULL, 0x000fe40000000035ULL,
0x00000010ff377819ULL, 0x000fe40000011640ULL, 0x00000010ff367819ULL, 0x000fe40000011661ULL,
0x00000010ff587819ULL, 0x000fe20000011658ULL, 0x00000034142c723cULL, 0x000fe2000004182cULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x2000006eff5a7230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x20000068ff5b7230ULL, 0x000fe20000004100ULL, 0x0000105458377816ULL, 0x000fe20000000063ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc40000011642ULL,
0x00000010ff427819ULL, 0x000fe4000001165fULL, 0x00000010ff347819ULL, 0x000fe20000011643ULL,
0x000000361430723cULL, 0x000fe20000041830ULL, 0x00000010ff407819ULL, 0x000fe40000011659ULL,
0x00000010ff437819ULL, 0x000fe40000011660ULL, 0x0000105435427816ULL, 0x000fe40000000042ULL,
0x00000010ff597819ULL, 0x000fc40000011664ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff357819ULL, 0x000fe4000001164dULL,
0x00000010ff4f7819ULL, 0x000fc4000001164fULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff367819ULL, 0x000fe4000001165bULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff377819ULL, 0x000fe40000011667ULL, 0x0000105434437816ULL, 0x000fe40000000043ULL,
0x0000105459407816ULL, 0x000fc40000000040ULL, 0x000010545e417816ULL, 0x000fe40000000041ULL,
0x0000105462347816ULL, 0x000fe20000000051ULL, 0x000000421420723cULL, 0x000fe20000041820ULL,
0x000010545a357816ULL, 0x000fe40000000035ULL, 0x000010544f367816ULL, 0x000fe40000000036ULL,
0x0000105450377816ULL, 0x000fe20000000037ULL, 0x000000401424723cULL, 0x000fec0000041824ULL,
0x00000034141c723cULL, 0x000fec000004181cULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x000000104b357824ULL, 0x000fe200078e024eULL, 0x012000004a14783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003534783bULL, 0x000f620000004200ULL, 0x0000001049407824ULL, 0x000fcc00078e024eULL,
0x000000004040783bULL, 0x000f640000004200ULL, 0x00000010ff677819ULL, 0x022fe40000011635ULL,
0x00000010ff5d7819ULL, 0x000fe40000011636ULL, 0x000000ff344a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff687819ULL, 0x000fe40000011634ULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x0000ffff34667812ULL, 0x000fe400078ec0ffULL, 0x000000ff354b7812ULL, 0x000fe200078ec0ffULL,
0x2000004aff647230ULL, 0x000fe20000004100ULL, 0x00000018ff6a7819ULL, 0x008fe40000011641ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x000000ff36507812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011636ULL, 0x00000010ff617819ULL, 0x100fe40000011637ULL,
0x000000ff375a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe40000011637ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x0000ffff355e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff36367812ULL, 0x000fe400078ec0ffULL, 0x0000ffff37377812ULL, 0x000fe400078ec0ffULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe40000011640ULL,
0x00000018ff497819ULL, 0x000fc40000011634ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000010ff637819ULL, 0x000fe40000011641ULL, 0x0000006aff4a723eULL, 0x000fe200020006ffULL,
0x20000067ff6a7230ULL, 0x000fe20000004100ULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x2000005dff677230ULL, 0x000fe20000004100ULL, 0x00000018ff347819ULL, 0x000fe20000011635ULL,
0x2000004bff657230ULL, 0x000fe20000004100ULL, 0x000000ff61617812ULL, 0x000fe200078ec0ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000018ff697819ULL, 0x000fc40000011640ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000008ff5e7819ULL, 0x000fe4000001165eULL,
0x00000008ff367819ULL, 0x000fe40000011636ULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x000000ff625d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff405b7812ULL, 0x000fc400078ec0ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x00000049ff60723eULL, 0x000fe400020006ffULL,
0x00000034ff5f723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000ffff40347812ULL, 0x000fe200078ec0ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff416b7812ULL, 0x000fc400078ec0ffULL,
0x00000069ff4b723eULL, 0x000fe200020006ffULL, 0x20000068ff697230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000066ff687230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x20000061ff667230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x100fe20000011642ULL, 0x20000036ff617230ULL, 0x000fe20000004100ULL,
0x000000ff426c7812ULL, 0x000fe200078ec0ffULL, 0x20000037ff627230ULL, 0x000fe20000004100ULL,
0x00000018ff407819ULL, 0x000fc40000011642ULL, 0x0000ffff42497812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005bff42723eULL, 0x000fe200020006ffULL,
0x20000050ff5b7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000ffff41357812ULL, 0x000fe400078ec0ffULL, 0x0000006bff50723eULL, 0x000fe200020006ffULL,
0x2000005eff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011664ULL,
0x2000005dff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011665ULL,
0x20000063ff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fe40000011634ULL,
0x00000008ff647819ULL, 0x000fe20000011635ULL, 0x2000005aff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe40000011660ULL, 0x00000010ff347819ULL, 0x000fe40000011668ULL,
0x0000105469367816ULL, 0x000fc40000000036ULL, 0x000010546a377816ULL, 0x000fe40000000037ULL,
0x00000010ff607819ULL, 0x000fe4000001165fULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000105435347816ULL, 0x000fe20000000034ULL,
0x2000004fff5a7230ULL, 0x000fe20000004100ULL, 0x0000105460357816ULL, 0x000fe2000000006bULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe2000001165bULL,
0x20000042ff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fc4000001165cULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x0000105467367816ULL, 0x000fe40000000036ULL,
0x0000105466377816ULL, 0x000fe40000000037ULL, 0x00000010ff357819ULL, 0x000fe4000001165aULL,
0x00000010ff347819ULL, 0x000fc40000011661ULL, 0x00000010ff597819ULL, 0x000fe20000011659ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff587819ULL, 0x000fe40000011643ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000105435347816ULL, 0x000fe20000000034ULL,
0x20000063ff5c7230ULL, 0x000fe20000004100ULL, 0x0000105459357816ULL, 0x000fe20000000062ULL,
0x20000064ff5b7230ULL, 0x000fe20000004100ULL, 0x000000ff436d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff51517812ULL, 0x000fe400078ec0ffULL, 0x000000ff58587812ULL, 0x000fe200078ec0ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x0000ffff434d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff367819ULL, 0x000fe4000001164fULL, 0x00000010ff377819ULL, 0x000fe4000001165eULL,
0x00000010ff507819ULL, 0x000fc40000011650ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x0000006cff42723eULL, 0x000fe400020006ffULL,
0x0000006dff43723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000008ff4d7819ULL, 0x000fe2000001164dULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x000010545d377816ULL, 0x000fc40000000050ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff347819ULL, 0x000fe2000001165cULL, 0x000000361424723cULL, 0x000fe20000041824ULL,
0x00000010ff357819ULL, 0x000fe4000001165bULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000008ff497819ULL, 0x000fc40000011649ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x000010544b347816ULL, 0x000fe40000000034ULL,
0x000010544a357816ULL, 0x000fe20000000035ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000010ff367819ULL, 0x000fe20000011642ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe20000011643ULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x00000010ff587819ULL, 0x000fe20000011658ULL, 0x000000023c427824ULL, 0x000fe200078e00ffULL,
0x0000105451367816ULL, 0x000fc40000000036ULL, 0x0000105458377816ULL, 0x000fe40000000037ULL,
0x00000010ff347819ULL, 0x000fe40000011641ULL, 0x00000010ff417819ULL, 0x000fe4000001164dULL,
0x00000010ff357819ULL, 0x000fe20000011640ULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x00000010ff407819ULL, 0x000fe40000011649ULL, 0xfffffff842427812ULL, 0x000fc400078ec0ffULL,
0x0000105434417816ULL, 0x000fe20000000041ULL, 0x000000080a347824ULL, 0x000fe200078e020dULL,
0x0000105435407816ULL, 0x000fe20000000040ULL, 0x00000001ff377424ULL, 0x000fe400078e00ffULL,
0x000000010d427824ULL, 0x000fe400078e0242ULL, 0x0176c837343479a7ULL, 0x0002e4000850003fULL,
0x000000401410723cULL, 0x000fe20000041810ULL, 0x0176983742ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035040075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x002fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000000105177836ULL, 0x000fe40000000000ULL,
0x0000000309097836ULL, 0x000fc60000000000ULL, 0x000000381700720cULL, 0x000fda0003f06070ULL,
0x0000000800080947ULL, 0x000fea0003800000ULL, 0x00008e00ff147b82ULL, 0x000ee20000000a00ULL,
0x0000000205097836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000010017347824ULL, 0x000fe400078e0208ULL, 0x0000000453537c24ULL, 0x010fe2000f8e02ffULL,
0x000000380900720cULL, 0x000fe40003f06070ULL, 0x0000002034167812ULL, 0x000fe200078ec0ffULL,
0x0000004053537824ULL, 0x000fc800078e00ffULL, 0x000000010b407824ULL, 0x000fe400078e0216ULL,
0x0000008053147825ULL, 0x008fc800078e0014ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x0000003439097248ULL, 0x000fe20007fe0000ULL, 0x000000103c167824ULL, 0x000fe200078e00ffULL,
0x00000003ff177819ULL, 0x000fc6000001160eULL, 0x0000000109097824ULL, 0x000fe200078e0a34ULL,
0x0000001016167812ULL, 0x000fe200078ec0ffULL, 0x0000000417347836ULL, 0x000fe40000000000ULL,
0x0000000817367836ULL, 0x000fe20000000000ULL, 0x0000000916097248ULL, 0x000fe20007fe0000ULL,
0x0000000c17377836ULL, 0x002fe40000000000ULL, 0x0000000134357824ULL, 0x100fe400078e0216ULL,
0x0000000109097824ULL, 0x000fc400078e0a16ULL, 0x0000000136417824ULL, 0x100fe400078e0216ULL,
0x0000000137437824ULL, 0x100fe200078e0216ULL, 0x000000091700720cULL, 0x0c0fe20003f86070ULL,
0x0000000117177824ULL, 0x000fe200078e0216ULL, 0x000000093400720cULL, 0x080fe20003f66070ULL,
0x0000000135167824ULL, 0x000fe200078e020eULL, 0x000000093600720cULL, 0x080fe20003f46070ULL,
0x0000000117347824ULL, 0x000fe200078e0240ULL, 0x000000093700720cULL, 0x000fe20003f06070ULL,
0x00000008354b7824ULL, 0x000fc400078e00ffULL, 0x0000000135367824ULL, 0x000fe400078e0240ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fc600078ee216ULL,
0x0000000117097824ULL, 0x140fe400078e020eULL, 0x0000000817427824ULL, 0x000fe400078e00ffULL,
0x0000000141177824ULL, 0x040fe400078e020eULL, 0x00000008414a7824ULL, 0x000fe200078e00ffULL,
0xfffffff842497812ULL, 0x000fe200078ee209ULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff84a4d7812ULL, 0x000fe200078ee217ULL, 0x0000000141167824ULL, 0x100fe200078e0240ULL,
0x0000004434417212ULL, 0x080fe200078efcffULL, 0x0000000143407824ULL, 0x000fe200078e0240ULL,
0x0000004436097212ULL, 0x000fe200078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004114347210ULL, 0x000fe40007fbe0ffULL, 0x0000000914367210ULL, 0x000fe20007fde0ffULL,
0x0000008040407825ULL, 0x000fc800078e00ffULL, 0x0000000143427824ULL, 0x040fe200078e020eULL,
0x0000004440097212ULL, 0x080fe200078efcffULL, 0x00000008434f7824ULL, 0x000fe200078e00ffULL,
0x0000004416437212ULL, 0x000fe200078efcffULL, 0x0000000115357824ULL, 0x040fe400028e0635ULL,
0x0000000115377824ULL, 0x000fe200030e0637ULL, 0x0000004314167210ULL, 0x000fe20007fbe0ffULL,
0x0000001049497824ULL, 0x100fe200078e024eULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee242ULL,
0x000000104b4b7824ULL, 0x100fe200078e024eULL, 0x0000000914147210ULL, 0x000fe20007fde0ffULL,
0x000000104d4d7824ULL, 0x000fe200078e024eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034497faeULL, 0x0003e2000e101c46ULL, 0x0000000115177824ULL, 0x000fc400028e0617ULL,
0x000000104f4f7824ULL, 0x000fe200078e024eULL, 0x00000000364b7faeULL, 0x0003e2000d901c46ULL,
0x0000000115157824ULL, 0x000fc600030e0641ULL, 0x00000000164d7faeULL, 0x0003e8000d101c46ULL,
0x00000000144f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x000000103c097824ULL, 0x000fca00078e00ffULL, 0x0000001009097812ULL, 0x000fc800078ec0ffULL,
0x000000090e097211ULL, 0x000fca00078fe8ffULL, 0x0000000109177824ULL, 0x040fe400078e020eULL,
0x0000000809347824ULL, 0x040fe400078e00ffULL, 0x0000000109167824ULL, 0x000fe400078e0240ULL,
0x0000000409357836ULL, 0x000fe20000000000ULL, 0xfffffff834437812ULL, 0x000fe200078ee217ULL,
0x0000000809417836ULL, 0x000fe40000000000ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000000c09497836ULL, 0x000fe20000000000ULL, 0x0000004416097212ULL, 0x000fe200078efcffULL,
0x0000000135347824ULL, 0x040fe400078e0240ULL, 0x0000000135377824ULL, 0x142fe200078e020eULL,
0x0000000914167210ULL, 0x000fe20007f1e0ffULL, 0x0000000835427824ULL, 0x000fe400078e00ffULL,
0x0000000141357824ULL, 0x040fe400078e020eULL, 0x00000008414a7824ULL, 0x040fe200078e00ffULL,
0xfffffff842097812ULL, 0x000fe200078ee237ULL, 0x0000000141367824ULL, 0x000fc400078e0240ULL,
0x0000000149417824ULL, 0x040fe200078e020eULL, 0xfffffff84a4f7812ULL, 0x000fe200078ee235ULL,
0x0000000849507824ULL, 0x040fe400078e00ffULL, 0x0000000149407824ULL, 0x000fe400078e0240ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff850517812ULL, 0x000fc600078ee241ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004434497212ULL, 0x000fc600078efcffULL,
0x0000008040407825ULL, 0x000fc800078e00ffULL, 0x00000010434b7824ULL, 0x100fe200078e024eULL,
0x0000004436437212ULL, 0x080fe200078efcffULL, 0x00000010094d7824ULL, 0x100fe200078e024eULL,
0x0000004440097212ULL, 0x000fe200078efcffULL, 0x0000000115177824ULL, 0x000fe200000e0617ULL,
0x0000004914347210ULL, 0x000fe20007f1e0ffULL, 0x000000104f4f7824ULL, 0x100fe200078e024eULL,
0x0000004314367210ULL, 0x000fe20007f5e0ffULL, 0x0000001051517824ULL, 0x000fe200078e024eULL,
0x0000000914147210ULL, 0x000fe20007f7e0ffULL, 0x0000000115357824ULL, 0x040fe200000e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000164b7faeULL, 0x0003e2000b901c46ULL,
0x0000000115377824ULL, 0x000fc400010e0637ULL, 0x0000000115157824ULL, 0x000fe200018e0641ULL,
0x00000000344d7faeULL, 0x0003e8000b901c46ULL, 0x00000000364f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014517faeULL, 0x0003e4000b901c46ULL, 0x0000000445097836ULL, 0x000fe40000000000ULL,
0xffffffffff537424ULL, 0x000fc600078e00ffULL, 0x0000003a0900720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009000ff147b82ULL, 0x002e620000000a00ULL,
0x0000000106177824ULL, 0x000fc800078e0209ULL, 0x0000000417147825ULL, 0x002fca00078e0014ULL,
0x0000000614537981ULL, 0x000324000c1e1900ULL, 0x000000083c147824ULL, 0x002fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xfffffff014147812ULL, 0x000fca00078ec0ffULL,
0x000000010d147824ULL, 0x000fca00078e0214ULL, 0x00000000140472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a834141479a7ULL, 0x0002e4000850003fULL, 0x01766834073479a7ULL, 0x0022a4000850003fULL,
0x000000ffff497224ULL, 0x00afce00078e0015ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x01766835070075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01766835070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000800c157824ULL, 0x000fe400078e020dULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0x0000018044147810ULL, 0x000fca0007ffe015ULL,
0x0000000147147824ULL, 0x000fca00078e0214ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0004a20000000800ULL, 0x000000551600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x004fea0003800000ULL, 0x000000030c157836ULL, 0x000fe20000000000ULL,
0x000000551600720bULL, 0x000fc80003f14000ULL, 0x0000003c1500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000803c15a824ULL, 0x000fe200078e020dULL,
0x000000551614a209ULL, 0x000fc80007810000ULL, 0x000000154747a210ULL, 0x000fe40007ffe044ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400144700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005516147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005514147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160eULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001554547220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005516557209ULL, 0x000fd60007810000ULL,
0x8000005516160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005417547221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x000000083c167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d377824ULL, 0x000fc800078e0216ULL,
0x0176b057370075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x000000043c167824ULL, 0x000fe200078e00ffULL, 0x000000080e457812ULL, 0x000fe200078ec0ffULL,
0x000008000c157824ULL, 0x000fe200078e020dULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000000416167812ULL, 0x000fe200078ec0ffULL, 0x0000001046157824ULL, 0x000fc600078e0215ULL,
0x0000000216417812ULL, 0x000fce00078efcffULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803177836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1714007589ULL, 0x0002e400000e0000ULL,
0x012800001514783bULL, 0x002e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x086fe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x088fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x0000000745457812ULL, 0x000fe200078ef80eULL, 0x000000004c34783bULL, 0x000f620000004200ULL,
0x000000410e447211ULL, 0x040fe200078fe0ffULL, 0x000000023f3f7836ULL, 0x000fe20000000000ULL,
0x000000070e477812ULL, 0x000fe200078ec0ffULL, 0x0000000845417824ULL, 0x040fe400078e00ffULL,
0x0000000145407824ULL, 0x000fe200078e0244ULL, 0x0000000847477812ULL, 0x000fe200078ef80eULL,
0x000000030c467836ULL, 0x000fc60000000000ULL, 0xfffffff841417812ULL, 0x000fe200078ee240ULL,
0x00000008474a7824ULL, 0x000fe400078e00ffULL, 0x0000080046467824ULL, 0x000fe400078e020dULL,
0x0000001041417824ULL, 0x000fe200078e0248ULL, 0xfffffff84a3f7812ULL, 0x000fca00078ee23fULL,
0x000000004140783bULL, 0x000f620000004200ULL, 0x000000103f3f7824ULL, 0x000fe200078e0246ULL,
0x00000018ff467819ULL, 0x128fe40000011634ULL, 0x000000ff364f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4b7819ULL, 0x000fe40000011634ULL, 0x000000ff34477812ULL, 0x040fe400078ec0ffULL,
0x0000ffff34617812ULL, 0x000fc400078ec0ffULL, 0x000000ff37587812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4a7819ULL, 0x100fe40000011635ULL, 0x000000ff35347812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011635ULL, 0x0000ffff35607812ULL, 0x000fe400078ec0ffULL,
0x00000018ff507819ULL, 0x000fc40000011637ULL, 0x00000046ff35723eULL, 0x000fe400020006ffULL,
0x00000010ff597819ULL, 0x104fe40000011640ULL, 0x000000ff40637812ULL, 0x040fe200078ec0ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000018ff467819ULL, 0x000fe40000011640ULL,
0x0000ffff405c7812ULL, 0x000fe400078ec0ffULL, 0x0000004fff4f723eULL, 0x000fc400020006ffULL,
0x00000010ff5f7819ULL, 0x100fe40000011636ULL, 0x00000018ff4d7819ULL, 0x000fe40000011636ULL,
0x0000ffff36567812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x100fe40000011641ULL,
0x000000ff41657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff647819ULL, 0x000fc40000011641ULL,
0x0000ffff415e7812ULL, 0x000fe400078ec0ffULL, 0x00000058ff40723eULL, 0x000fe400020006ffULL,
0x00000010ff367819ULL, 0x100fe40000011643ULL, 0x000000ff43677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x0000ffff434e7812ULL, 0x000fc400078ec0ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000050ff43723eULL, 0x000fe200020006ffULL,
0x2000004fff507230ULL, 0x000fe20000004100ULL, 0x00000008ff567819ULL, 0x000fe20000011656ULL,
0x20000040ff4f7230ULL, 0x000fe20000004100ULL, 0x00000018ff627819ULL, 0x000fe20000011642ULL,
0x2000004cff587230ULL, 0x000fe20000004100ULL, 0x00000065ff40723eULL, 0x000fe200020006ffULL,
0x20000043ff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fc40000011637ULL,
0x00000034ff5b723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL, 0x00000041ff65723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000ffff37377812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fe40000011642ULL, 0x000000ff42667812ULL, 0x000fc400078ec0ffULL,
0x0000ffff42347812ULL, 0x000fe400078ec0ffULL, 0x00000046ff43723eULL, 0x000fe400020006ffULL,
0x0000004dff42723eULL, 0x000fe400020006ffULL, 0x00000064ff46723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000063ff4d723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000062ff64723eULL, 0x000fc400020006ffULL,
0x0000004bff62723eULL, 0x000fe200020006ffULL, 0x20000065ff4b7230ULL, 0x000fe20000004100ULL,
0x000000ff4a637812ULL, 0x000fe200078ec0ffULL, 0x20000064ff4a7230ULL, 0x000fe20000004100ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff377819ULL, 0x000fe20000011637ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000008ff607819ULL, 0x000fe40000011660ULL, 0x000000ff59657812ULL, 0x000fe200078ec0ffULL,
0x20000056ff597230ULL, 0x000fe20000004100ULL, 0x000000ff57577812ULL, 0x000fc400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000008ff567819ULL, 0x000fe4000001165cULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000063ff647230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x20000061ff637230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000037ff5c7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x20000047ff5a7230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x20000060ff617230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000057ff607230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x000000ff51377812ULL, 0x000fe200078ec0ffULL, 0x20000056ff517230ULL, 0x000fe20000004100ULL,
0x0000005dff57723eULL, 0x000fe200020006ffULL, 0x20000065ff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff567230ULL, 0x000fe20000004100ULL,
0x00000037ff5e723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x000000ff36657812ULL, 0x000fc400078ec0ffULL, 0x00000010ff367819ULL, 0x000fe2000001165aULL,
0x2000005eff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000105437367816ULL, 0x000fc40000000036ULL,
0x0000105464377816ULL, 0x000fe2000000005bULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff5b7819ULL, 0x000fe40000011634ULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00000010ff347819ULL, 0x000fe20000011663ULL, 0x000000361418723cULL, 0x002fe20000041818ULL,
0x00000010ff5e7819ULL, 0x000fe40000011658ULL, 0x00000010ff617819ULL, 0x000fc40000011661ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff367819ULL, 0x000fe40000011650ULL,
0x00000010ff377819ULL, 0x000fe4000001164fULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x00000066ff47723eULL, 0x000fc400020006ffULL,
0x000010545e357816ULL, 0x000fe40000000061ULL, 0x000010545f367816ULL, 0x000fe20000000036ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x0000105460377816ULL, 0x000fe40000000037ULL,
0x00000008ff5e7819ULL, 0x000fe2000001164eULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000067ff417230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe20000011642ULL, 0x20000065ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff4f7819ULL, 0x000fe2000001164cULL, 0x2000005bff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe20000011643ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fc4000001164dULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff437819ULL, 0x000fe40000011657ULL, 0x00000010ff347819ULL, 0x000fe40000011659ULL,
0x00000010ff4c7819ULL, 0x000fe40000011647ULL, 0x00000010ff4d7819ULL, 0x000fe4000001165aULL,
0x00000010ff5c7819ULL, 0x000fc4000001165cULL, 0x0000105443437816ULL, 0x000fe40000000040ULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x000010544d407816ULL, 0x000fe4000000004cULL,
0x000010544f357816ULL, 0x000fe4000000005cULL, 0x00000010ff367819ULL, 0x000fe40000011646ULL,
0x00000010ff4d7819ULL, 0x000fc4000001164aULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000010ff467819ULL, 0x000fe40000011651ULL,
0x00000010ff477819ULL, 0x000fe40000011656ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff4e7819ULL, 0x000fc4000001164eULL,
0x00000010ff4a7819ULL, 0x000fe4000001164bULL, 0x00000010ff4f7819ULL, 0x000fe4000001165eULL,
0x000010545d427816ULL, 0x000fe40000000042ULL, 0x0000105437467816ULL, 0x000fe40000000046ULL,
0x0000105436477816ULL, 0x000fe40000000047ULL, 0x0000105458417816ULL, 0x000fe20000000041ULL,
0x011000003f34783bULL, 0x0002a20000000200ULL, 0x000010544d4e7816ULL, 0x000fe2000000004eULL,
0x000000421424723cULL, 0x000fe20000041824ULL, 0x000010544a4f7816ULL, 0x000fca000000004fULL,
0x000000461420723cULL, 0x000fec0000041820ULL, 0x00000040141c723cULL, 0x000fec000004181cULL,
0x0000004e1410723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000100947ULL, 0x002fde0003800000ULL, 0x0000000334347232ULL, 0x084fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x0000001045457812ULL, 0x000fe200078efcffULL,
0x000000005214783bULL, 0x000e620000004200ULL, 0x0000000105057836ULL, 0x000fc60000000000ULL,
0x0000000145447824ULL, 0x040fe400078e0244ULL, 0x00000008453f7824ULL, 0x000fca00078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fca00078ee244ULL, 0x000000103f3f7824ULL, 0x000fca00078e0248ULL,
0x000000003f40783bULL, 0x000ee20000004200ULL, 0x000000ff15527812ULL, 0x002fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x100fe40000011614ULL, 0x000000ff14507812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011614ULL, 0x0000ffff145f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fc40000011615ULL, 0x00000018ff567819ULL, 0x000fe40000011615ULL,
0x0000ffff15607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x100fe40000011616ULL,
0x000000ff16577812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011616ULL,
0x0000ffff16587812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5a7819ULL, 0x100fe40000011617ULL,
0x000000ff175e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011617ULL,
0x0000ffff17157812ULL, 0x000fe400078ec0ffULL, 0x00000010ff477819ULL, 0x008fe40000011640ULL,
0x000000ff40147812ULL, 0x000fc400078ec0ffULL, 0x00000018ff167819ULL, 0x000fe40000011640ULL,
0x0000ffff403f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff487819ULL, 0x100fe40000011641ULL,
0x000000ff41177812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x0000ffff41447812ULL, 0x000fc400078ec0ffULL, 0x00000052ff41723eULL, 0x000fe400020006ffULL,
0x00000057ff5c723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x0000004fff52723eULL, 0x000fe200020006ffULL, 0x20000041ff4f7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000005cff417230ULL, 0x000fe20000004100ULL,
0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL, 0x20000050ff577230ULL, 0x000fe20000004100ULL,
0x000000ff515c7812ULL, 0x000fe200078ec0ffULL, 0x2000005bff517230ULL, 0x000fe20000004100ULL,
0x0000005eff50723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x0000005dff5e723eULL, 0x000fc400020006ffULL, 0x000000ff59597812ULL, 0x000fe200078ec0ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x0000004eff5b723eULL, 0x000fe200020006ffULL, 0x2000005eff4e7230ULL, 0x000fe20000004100ULL,
0x0000005cff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe20000011658ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000008ff5c7819ULL, 0x000fe2000001165fULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x0000005aff5f723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000059ff5a7230ULL, 0x000fe20000004100ULL, 0x00000008ff157819ULL, 0x000fe40000011615ULL,
0x00000008ff5e7819ULL, 0x000fe20000011660ULL, 0x2000005fff607230ULL, 0x000fe20000004100ULL,
0x00000015ff59723eULL, 0x000fe200020006ffULL, 0x20000058ff5f7230ULL, 0x000fe20000004100ULL,
0x00000014ff61723eULL, 0x000fc400020006ffULL, 0x00000010ff147819ULL, 0x000fe20000011657ULL,
0x20000059ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff157819ULL, 0x000fe2000001164fULL,
0x20000061ff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff587819ULL, 0x000fe4000001165dULL, 0x000010545b147816ULL, 0x000fe40000000014ULL,
0x0000105458157816ULL, 0x000fc40000000015ULL, 0x00000016ff58723eULL, 0x000fe400020006ffULL,
0x00000017ff5b723eULL, 0x000fe400020006ffULL, 0x00000010ff177819ULL, 0x000fe20000011652ULL,
0x20000058ff527230ULL, 0x000fe20000004100ULL, 0x00000040ff58723eULL, 0x000fe200020006ffULL,
0x000000143418723cULL, 0x004fe20000041818ULL, 0x00000010ff407819ULL, 0x000fe40000011641ULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff157819ULL, 0x000fe2000001165aULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x000000ff48487812ULL, 0x000fe200078ec0ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000105415407816ULL, 0x000fc40000000040ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff147819ULL, 0x000fe4000001165fULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff157819ULL, 0x000fe40000011657ULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fc400020006ffULL,
0x0000105451147816ULL, 0x000fe20000000014ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x000010544e157816ULL, 0x000fe20000000015ULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000008ff3f7819ULL, 0x000fe4000001163fULL, 0x00000008ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff597819ULL, 0x000fe20000011656ULL, 0x2000005bff567230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe2000001165cULL, 0x000000143430723cULL, 0x000fe20000041830ULL,
0x00000010ff417819ULL, 0x000fe20000011650ULL, 0x20000058ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fc40000011660ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000010ff457819ULL, 0x100fe20000011642ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x000000ff424b7812ULL, 0x000fe200078ec0ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000018ff4c7819ULL, 0x000fc40000011642ULL, 0x0000ffff42427812ULL, 0x000fe400078ec0ffULL,
0x0000105417167816ULL, 0x000fe40000000016ULL, 0x0000105460417816ULL, 0x000fe40000000041ULL,
0x0000105459177816ULL, 0x000fe4000000005eULL, 0x00000010ff147819ULL, 0x000fe4000001164fULL,
0x00000010ff157819ULL, 0x000fe20000011656ULL, 0x00000040342c723cULL, 0x000fe2000004182cULL,
0x00000010ff477819ULL, 0x000fc40000011647ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x000000ff45457812ULL, 0x000fe200078ec0ffULL, 0x000000163428723cULL, 0x000fe20000041828ULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x0000105447147816ULL, 0x000fe40000000014ULL,
0x0000105448157816ULL, 0x000fe40000000015ULL, 0x00000045ff45723eULL, 0x000fc400020006ffULL,
0x00000010ff407819ULL, 0x000fe40000011652ULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x000000143424723cULL, 0x000fe20000041824ULL, 0x00000010ff3f7819ULL, 0x000fe2000001163fULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe40000011644ULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fc400020006ffULL,
0x0000004cff16723eULL, 0x000fe200020006ffULL, 0x20000042ff157230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fe20000011643ULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x0000105440407816ULL, 0x000fe2000000003fULL, 0x20000016ff167230ULL, 0x000fe20000004100ULL,
0x0000105450417816ULL, 0x000fe40000000041ULL, 0x000000ff434d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fc40000011643ULL, 0x000000ff46467812ULL, 0x000fe200078ec0ffULL,
0x000000403420723cULL, 0x000fe20000041820ULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x00000010ff147819ULL, 0x000fe40000011645ULL, 0x00000010ff157819ULL, 0x000fe40000011615ULL,
0x0000004dff17723eULL, 0x000fe200020006ffULL, 0x00000001ff417424ULL, 0x000fe200078e00ffULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fe20000011616ULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x0000105414427816ULL, 0x000fe4000000004bULL, 0x0000105416167816ULL, 0x000fe40000000015ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x00000041041479a7ULL, 0x0002a2000850003fULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000010ff177819ULL, 0x000fe20000011617ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x000fe20000011646ULL,
0x20000043ff3f7230ULL, 0x000fc60000004100ULL, 0x0000105446437816ULL, 0x000fe20000000017ULL,
0x000000080c047824ULL, 0x002fe200078e020dULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff177819ULL, 0x000fe2000001163fULL, 0x0176a04104ff79a7ULL, 0x0003e4000850003fULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x000010544a177816ULL, 0x000fce0000000017ULL,
0x000000163410723cULL, 0x000fee0000041810ULL, 0x000000ffff347224ULL, 0x004fe200078e0015ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff5000bc9947ULL, 0x002fde000383ffffULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000054007836ULL, 0x002fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000c85000047802ULL, 0x000fce0000000f00ULL,
0x0000008400ec7944ULL, 0x01cfea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005400037308ULL, 0x008e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000054ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000001a051a7220ULL, 0x044fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fce0000410000ULL, 0x0000000000037919ULL, 0x008ee20000000000ULL,
0x000000013c3c7812ULL, 0x000fe400078ec0ffULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000010003c0d7824ULL, 0x000fe200078e020dULL,
0x0000001c1d1c723eULL, 0x000fc400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x000000121312723eULL, 0x000fe400000010ffULL,
0x000000ff0a00720cULL, 0x000fc40003f05270ULL, 0x000076321e217816ULL, 0x000fe40000000012ULL,
0x00000002ff057819ULL, 0x108fe20000011603ULL, 0x0000000108087824ULL, 0x000fe200078e0203ULL,
0x0000000203007812ULL, 0x042fe400078ec0ffULL, 0x0000000803077811ULL, 0x000fe200078ff0ffULL,
0x00000008050e7824ULL, 0x000fe200078e00ffULL, 0x0000000500027211ULL, 0x000fe200078ff8ffULL,
0x0000001008087824ULL, 0x000fe200078e020dULL, 0x0000000700047211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x000fc400078e00ffULL, 0x0000000805077824ULL, 0x040fe400078e00ffULL,
0x0000000202007836ULL, 0x000fe20000000000ULL, 0xfffffff809147812ULL, 0x000fe200078ee204ULL,
0x0000000805097824ULL, 0x000fe400078e00ffULL, 0x0000000402047836ULL, 0x000fe20000000000ULL,
0xfffffff807067812ULL, 0x000fe200078ee200ULL, 0x000008000a057824ULL, 0x000fe200078e020dULL,
0xfffffff807007812ULL, 0x000fe200078ee202ULL, 0x0000000602077836ULL, 0x000fe20000000000ULL,
0xfffffff8090c7812ULL, 0x000fe200078ee204ULL, 0x0000000803027824ULL, 0x000fc400078e00ffULL,
0x0000001000047824ULL, 0x100fe200078e0205ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x0000000802077812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x000000181900723eULL, 0x000fe200000010ffULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x000000282902723eULL, 0x000fe200000010ffULL,
0x000000100e0e7824ULL, 0x000fe400078e0205ULL, 0x0000000104057824ULL, 0x000fe200078e0207ULL,
0x0000541000167816ULL, 0x040fe20000000002ULL, 0x0000000107147824ULL, 0x040fe200078e0214ULL,
0x0000763200177816ULL, 0x000fe20000000002ULL, 0x0000000107067824ULL, 0x000fe200078e0206ULL,
0x0000002c2d00723eULL, 0x000fe200000010ffULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000303102723eULL, 0x000fe200000010ffULL, 0x0000000107077824ULL, 0x000fe200078e020eULL,
0x000000242504723eULL, 0x000fe200000010ffULL, 0x0000001605007388ULL, 0x0003e20000000a00ULL,
0x00000010110e723eULL, 0x000fc400000010ffULL, 0x0000541004107816ULL, 0x140fe40000000020ULL,
0x0000763204117816ULL, 0x000fe40000000020ULL, 0x000054101c047816ULL, 0x000fe4000000000eULL,
0x000054101e207816ULL, 0x000fe40000000012ULL, 0x0000541000167816ULL, 0x142fe40000000002ULL,
0x0000763200177816ULL, 0x000fc40000000002ULL, 0x000076321c057816ULL, 0x000fe4000000000eULL,
0x0000001a1b00723eULL, 0x000fe200000010ffULL, 0x0000001606007388ULL, 0x0003e20000000a00ULL,
0x0000002a2b02723eULL, 0x000fc600000010ffULL, 0x000000100c007388ULL, 0x000fe80000000a00ULL,
0x0000000407007388ULL, 0x0007e20000000a00ULL, 0x000000323317723eULL, 0x002fc800000010ffULL,
0x000054102e167816ULL, 0x140fe40000000017ULL, 0x000076322e177816ULL, 0x000fe40000000017ULL,
0x0000541000047816ULL, 0x148fe40000000002ULL, 0x0000763200057816ULL, 0x000fe40000000002ULL,
0x000000ff00007306ULL, 0x000e660000202400ULL, 0x0000000414007388ULL, 0x0007e80000000a00ULL,
0x0004001606007388ULL, 0x000fe20000000a00ULL, 0x0000541026047816ULL, 0x008fc40000000022ULL,
0x0000763226057816ULL, 0x000fca0000000022ULL, 0x000400040c007388ULL, 0x000fe80000000a00ULL,
0x0004002007007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000008107984ULL, 0x000e680000000c00ULL, 0x0004000008187984ULL, 0x000ee80000000c00ULL,
0x0008000008147984ULL, 0x000f680000000c00ULL, 0x000c0000081c7984ULL, 0x000f620000000c00ULL,
0x0000001300137230ULL, 0x002fc40000200800ULL, 0x0000001200127230ULL, 0x040fe40000200800ULL,
0x0000001100117230ULL, 0x040fe40000200800ULL, 0x0000001000107230ULL, 0x040fe40000200800ULL,
0x0000001b001b7230ULL, 0x048fe40000200800ULL, 0x0000001a001a7230ULL, 0x040fe40000200800ULL,
0x0000001900197230ULL, 0x000fc40000200800ULL, 0x0000001800007230ULL, 0x000fe40000200800ULL,
0x0000001713137230ULL, 0x024fe40000200000ULL, 0x0000001612127230ULL, 0x000fe40000200000ULL,
0x0000001511117230ULL, 0x000fe40000200000ULL, 0x0000001410107230ULL, 0x000fe40000200000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000200000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000200000ULL,
0x0000001008007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000200000ULL,
0x0000001c00187230ULL, 0x000fca0000200000ULL, 0x0004001808007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000840000057ab9ULL, 0x000fc60000000800ULL, 0x0000003b0600720cULL, 0x000fe20003f06070ULL,
0x00000005040472a4ULL, 0x004fd8000f8e023fULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00008600ff137b82ULL, 0x002e620000000800ULL, 0x0000000106007824ULL, 0x000fe200078e0203ULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x0000000703077812ULL, 0x000fe400078ec0ffULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x000000083c077824ULL, 0x000fe200078e0207ULL, 0x0ffffff800007812ULL, 0x000fca00078ef803ULL,
0x0000001000027824ULL, 0x000fe400078e020dULL, 0x000000103d007824ULL, 0x000fc600078e0206ULL,
0x0000000002087984ULL, 0x0004e20000000c00ULL, 0x0000001304157219ULL, 0x082fe400000006ffULL,
0x000000133e3e7219ULL, 0x000fe400000006ffULL, 0x0000001500057212ULL, 0x000fe200078e30ffULL,
0x0000002003027836ULL, 0x004fe20000000000ULL, 0x00000013ff047219ULL, 0x000fe20000011600ULL,
0x000000040f007c24ULL, 0x000fe4000f8e02ffULL, 0x000000013e057824ULL, 0x000fc800078e0205ULL,
0x0000000f04057224ULL, 0x000fca00078e0205ULL, 0x0000000500057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011602ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x0000003b0600720cULL, 0x000fe40003f06070ULL,
0x0000000804007986ULL, 0x0083f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x142fe200078e0206ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x000000103d067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x000000083c117824ULL, 0x000fc600078e0211ULL, 0x0ffffff805047812ULL, 0x000fca00078ef802ULL,
0x0000001004077824ULL, 0x000fe200078e020dULL, 0x0000001506047212ULL, 0x000fe400078e30ffULL,
0x00000013ff067219ULL, 0x000fe40000011606ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x000000013e047824ULL, 0x000fc800078e0204ULL, 0x0000000f06057224ULL, 0x000fe400078e0204ULL,
0x0000004003067836ULL, 0x000fc60000000000ULL, 0x0000000500057210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff027819ULL, 0x000fc60000011606ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f440cULL,
0x0000003b0200720cULL, 0x000fe20003f06070ULL, 0x0000001011047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ee000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe400078e0202ULL, 0x000000103d027824ULL, 0x000fe400078e0202ULL,
0x0000006003077836ULL, 0x000fe20000000000ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000001502057212ULL, 0x000fe400078e30ffULL,
0x00000013ff027219ULL, 0x000fe20000011602ULL, 0x0000001004047824ULL, 0x000fe400078e020dULL,
0x000000013e057824ULL, 0x000fc600078e0205ULL, 0x0000000004087984ULL, 0x0002a20000000c00ULL,
0x0000000f02057224ULL, 0x000fca00078e0205ULL, 0x00000005000c7210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff047819ULL, 0x002fe40000011607ULL, 0x0000000706057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x000000080c027c11ULL, 0x000fe2000f8040ffULL,
0x0000000107067824ULL, 0x000fe400078e0204ULL, 0x000000083c057824ULL, 0x000fe200078e0205ULL,
0x000000090c037c11ULL, 0x000fc400080f4403ULL, 0x0000003b0400720cULL, 0x000fe40003f06070ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000001005027825ULL, 0x000fc600078e0002ULL,
0xfffffff806067812ULL, 0x000fe400078ef807ULL, 0x0000000802007986ULL, 0x0043ea000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001006067824ULL, 0x000fe200078e020dULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x000000103d047824ULL, 0x000fc600078e0204ULL,
0x0000000006087984ULL, 0x002e620000000c00ULL, 0x000000083c077824ULL, 0x000fe200078e0207ULL,
0x0000001504027212ULL, 0x000fe400078e30ffULL, 0x00000013ff047219ULL, 0x000fc60000011604ULL,
0x000000013e027824ULL, 0x000fc800078e0202ULL, 0x0000000f040f7224ULL, 0x000fca00078e0202ULL,
0x0000000f000f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x000000080f027c11ULL, 0x000fc8000f8040ffULL, 0x000000090f037c11ULL, 0x000fc600080f4400ULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000003a3c00720cULL, 0x000fe20003f06070ULL,
0x00009800ff107b82ULL, 0x000e620000000a00ULL, 0x00000001ff087424ULL, 0x000fe400078e00ffULL,
0xffffffffff0f7424ULL, 0x000fc800078e00ffULL, 0x017600080d0879a7ULL, 0x0004aa000850003fULL,
0x0000000215078824ULL, 0x000fe200078e00ffULL, 0x00009400ff028b82ULL, 0x000ef00000000800ULL,
0x00009000ff0a8b82ULL, 0x000f620000000a00ULL, 0x00000006100c7981ULL, 0x002522000c1e9900ULL,
0x0000000207078224ULL, 0x008fc800078e023cULL, 0x00000004070a8825ULL, 0x020fe400078e000aULL,
0x00008e00ff067b82ULL, 0x000e660000000a00ULL, 0x000000060a0f8981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0400780cULL, 0x000fe20003f04070ULL, 0x0000004003027824ULL, 0x000fe400078e00ffULL,
0x000000403c047824ULL, 0x000fe400078e00ffULL, 0x000000403e037824ULL, 0x000fc400078e00ffULL,
0x0000000f020f7224ULL, 0x008fc800078e02ffULL, 0x000000800f067825ULL, 0x002fe400078e0006ULL,
0x0000000c00200947ULL, 0x004fea0003800000ULL, 0x00000003ff217819ULL, 0x000fe4000001160eULL,
0x00000004390f7248ULL, 0x000fc60007fe0000ULL, 0x00000004210b7836ULL, 0x000fe40000000000ULL,
0x000000010f0f7824ULL, 0x000fe400078e0a04ULL, 0x000000010b0a7824ULL, 0x140fe400078e020eULL,
0x000000080b257824ULL, 0x040fe200078e00ffULL, 0x0000000f0b00720cULL, 0x080fe20003f86070ULL,
0x00000008210b7836ULL, 0x000fe40000000000ULL, 0x000000403e3e7824ULL, 0x000fe200078e0221ULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000010b147824ULL, 0x040fe200078e020eULL,
0x0000000f0b00720cULL, 0x040fe20003f06070ULL, 0x000000080b2d7824ULL, 0x000fc400078e00ffULL,
0x0000000c21117836ULL, 0x000fe40000000000ULL, 0x000000803e0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee214ULL, 0x0000000f1100720cULL, 0x040fe20003f26070ULL,
0x000000083e127836ULL, 0x000fe20000000000ULL, 0x000000700a237812ULL, 0x000fe200078ef805ULL,
0x000000043e107836ULL, 0x000fe40000000000ULL, 0x0000000111167824ULL, 0x040fe200078e020eULL,
0x0000002306227210ULL, 0x000fe20007f5e0ffULL, 0x00000008112f7824ULL, 0x000fc400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee216ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000007012177812ULL, 0x000fc600078ef805ULL,
0x0000000c3e167836ULL, 0x000fe20000000000ULL, 0x00000070101f7812ULL, 0x000fe200078ef805ULL,
0x0000000107237824ULL, 0x000fe200010e060bULL, 0x00000017060a7210ULL, 0x000fe20007f7e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001f061e7210ULL, 0x000fc60007f5e0ffULL,
0x000000103e107836ULL, 0x000fe20000000000ULL, 0x00000070161d7812ULL, 0x000fe200078ef805ULL,
0x00000001071f7824ULL, 0x000fe400010e0611ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001d061c7210ULL, 0x000fc60007f5e0ffULL, 0x000000183e187836ULL, 0x000fe20000000000ULL,
0x0000007010277812ULL, 0x000fe200078ef805ULL, 0x0000001c3e1a7836ULL, 0x000fe40000000000ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007018297812ULL, 0x000fc600078ef805ULL, 0x00000001071d7824ULL, 0x040fe200010e0617ULL,
0x0000002706167210ULL, 0x000fe20007f5e0ffULL, 0x000000143e127836ULL, 0x000fe20000000000ULL,
0x000000701a277812ULL, 0x000fe200078ef805ULL, 0x00000001070b7824ULL, 0x000fe200018e0613ULL,
0x0000002906107210ULL, 0x000fe20007f7e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000002706187210ULL, 0x000fc60007fbe0ffULL, 0x0000000107177824ULL, 0x040fe200010e0611ULL,
0x00000070122b7812ULL, 0x000fe200078ef805ULL, 0x0000000107117824ULL, 0x040fe400018e0619ULL,
0x0000001021207836ULL, 0x000fe20000000000ULL, 0x0000002b06127210ULL, 0x000fe20007f5e0ffULL,
0x0000000107197824ULL, 0x000fe200028e061bULL, 0x0000000f2100720cULL, 0x040fe20003fa6070ULL,
0x00000001211b7824ULL, 0x000fe400078e020eULL, 0x000000203e1a7836ULL, 0x000fc40000000000ULL,
0x0000000120247824ULL, 0x040fe200078e020eULL, 0x000000071b297812ULL, 0x000fe200078ec0ffULL,
0x0000000820317824ULL, 0x000fe400078e00ffULL, 0x000040003c147824ULL, 0x000fe200078e020dULL,
0x0ffffff829297812ULL, 0x000fe200078ef80eULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fc600078ee224ULL, 0x0000100014147836ULL, 0x000fe20000000000ULL,
0x000000701a277812ULL, 0x000fe200078ef805ULL, 0x0000001421267836ULL, 0x000fe40000000000ULL,
0x000000243e247836ULL, 0x000fe20000000000ULL, 0x00000027061a7210ULL, 0x000fe20007fde0ffULL,
0x0000000107137824ULL, 0x000fe200010e0613ULL, 0x0000000f2000720cULL, 0x080fe20003f46070ULL,
0x0000000126207824ULL, 0x040fe200078e020eULL, 0x0000000f2600720cULL, 0x040fe20003f66070ULL,
0x0000000826337824ULL, 0x000fc400078e00ffULL, 0x00000010252b7824ULL, 0x000fe400078e0214ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fc600078ee220ULL,
0x000000283e267836ULL, 0x000fe20000000000ULL, 0x0000007024357812ULL, 0x000fe200078ef805ULL,
0x0000001029297824ULL, 0x000fe400078e0214ULL, 0x0000001821207836ULL, 0x000fe40000000000ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022297faeULL, 0x0003e4000e901c46ULL, 0x0000000f2000720cULL, 0x040fe20003fa6070ULL,
0x00000001071b7824ULL, 0x000fe200030e061bULL, 0x0000003506247210ULL, 0x000fe20007fde0ffULL,
0x0000000120287824ULL, 0x000fe200078e020eULL, 0x000000001e2b7faeULL, 0x0005e2000e101c46ULL,
0x0000001c212a7836ULL, 0x000fc40000000000ULL, 0x000000102d2d7824ULL, 0x100fe400078e0214ULL,
0x000000102f2f7824ULL, 0x000fe200078e0214ULL, 0x0000007026237812ULL, 0x002fe200078ef805ULL,
0x0000000820297824ULL, 0x000fe200078e00ffULL, 0x000000000a2d7faeULL, 0x0003e2000c101c46ULL,
0x000000012a207824ULL, 0x040fe200078e020eULL, 0x0000000f2a00720cULL, 0x040fe20003f86070ULL,
0x0000000107257824ULL, 0x000fe200030e0625ULL, 0xfffffff829297812ULL, 0x000fe200078ee228ULL,
0x000000082a2b7824ULL, 0x004fe200078e00ffULL, 0x00000023061e7210ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x100fe200078e0214ULL, 0x000000001c2f7faeULL, 0x000fe2000c901c46ULL,
0x0000002c3e227836ULL, 0x000fe20000000000ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee220ULL,
0x0000001033337824ULL, 0x000fe200078e0214ULL, 0x0000000016317faeULL, 0x000fe2000d101c46ULL,
0x0000008022227825ULL, 0x000fc600078e00ffULL, 0x0000000012337faeULL, 0x0005e2000d901c46ULL,
0x0000001029297824ULL, 0x000fe200078e0214ULL, 0x0000007022357812ULL, 0x000fe200078ef805ULL,
0x00000001071f7824ULL, 0x000fe400030e0627ULL, 0x0000002021207836ULL, 0x000fe20000000000ULL,
0x0000000010297faeULL, 0x0007e2000e901c46ULL, 0x0000002421277836ULL, 0x000fe20000000000ULL,
0x00000035060a7210ULL, 0x002fe20007fde0ffULL, 0x0000000120267824ULL, 0x040fe200078e020eULL,
0x0000000f2000720cULL, 0x0c0fe20003f06070ULL, 0x0000000820377824ULL, 0x000fe200078e00ffULL,
0x0000000f2700720cULL, 0x000fe20003f26070ULL, 0x000000303e127836ULL, 0x004fc40000000000ULL,
0x0000000127207824ULL, 0x040fe200078e020eULL, 0xfffffff8371d7812ULL, 0x000fe200078ee226ULL,
0x0000000827277824ULL, 0x000fe400078e00ffULL, 0x0000008012107825ULL, 0x008fc600078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee220ULL, 0x00000028211c7836ULL, 0x000fe20000000000ULL,
0x0000007010137812ULL, 0x000fe200078ef805ULL, 0x000000343e127836ULL, 0x000fe40000000000ULL,
0x000000102b2b7824ULL, 0x000fe200078e0214ULL, 0x0000000f1c00720cULL, 0x040fe20003fa6070ULL,
0x000000011c177824ULL, 0x040fe400078e020eULL, 0x00000001070b7824ULL, 0x000fe200030e0623ULL,
0x0000001306167210ULL, 0x000fe20007fde0ffULL, 0x000000081c1c7824ULL, 0x000fe200078e00ffULL,
0x00000000182b7faeULL, 0x0003e2000e101c46ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000101d1d7824ULL, 0x100fe400078e0214ULL, 0x0000001027277824ULL, 0x000fe400078e0214ULL,
0x0000002c21207836ULL, 0x000fe20000000000ULL, 0x000000001a1d7faeULL, 0x0005e2000c101c46ULL,
0x0000003021227836ULL, 0x000fe20000000000ULL, 0xfffffff81c197812ULL, 0x002fe200078ee217ULL,
0x0000003421237836ULL, 0x000fe20000000000ULL, 0x0000000024277faeULL, 0x0003e2000c901c46ULL,
0x0000003821267836ULL, 0x000fe20000000000ULL, 0x0000000f2000720cULL, 0x080fe20003f86070ULL,
0x0000003c21217836ULL, 0x000fe20000000000ULL, 0x0000000f2200720cULL, 0x0c0fe20003f66070ULL,
0x0000000107177824ULL, 0x000fe200030e0611ULL, 0x0000007012117812ULL, 0x000fe200078ef805ULL,
0x0000000122107824ULL, 0x140fe200078e020eULL, 0x0000000f2300720cULL, 0x0c0fe20003f46070ULL,
0x00000008221d7824ULL, 0x004fe200078e00ffULL, 0x0000000f2600720cULL, 0x080fe20003f26070ULL,
0x0000000123187824ULL, 0x100fe200078e020eULL, 0x0000000f2100720cULL, 0x000fe20003f06070ULL,
0x00000001200f7824ULL, 0x040fe200078e020eULL, 0x0000001106127210ULL, 0x000fe20007fde0ffULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL,
0x000000383e117836ULL, 0x000fc40000000000ULL, 0x0000000823257824ULL, 0x002fe200078e00ffULL,
0xfffffff8201b7812ULL, 0x000fe200078ee20fULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x0000003c3e0f7836ULL, 0x000fe20000000000ULL, 0x0000007010237812ULL, 0x000fe200078ef805ULL,
0x00000001261a7824ULL, 0x100fe400078e020eULL, 0x00000001211c7824ULL, 0x000fe400078e020eULL,
0x000000800f0e7825ULL, 0x000fc800078e00ffULL, 0x0000000107137824ULL, 0x000fe200030e0613ULL,
0x0000002306107210ULL, 0x000fe20007fde0ffULL, 0x0000000826277824ULL, 0x000fe200078e00ffULL,
0x000000700e057812ULL, 0x000fe200078ef805ULL, 0x0000000821297824ULL, 0x000fe200078e00ffULL,
0xfffffff825217812ULL, 0x000fe200078ee218ULL, 0x0000000107117824ULL, 0x000fe200030e0611ULL,
0xfffffff827237812ULL, 0x000fe200078ee21aULL, 0x0000001019197824ULL, 0x100fe200078e0214ULL,
0xfffffff829257812ULL, 0x000fe200078ee21cULL, 0x000000101b1b7824ULL, 0x100fe200078e0214ULL,
0x0000000506067210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0214ULL,
0x000000001e197faeULL, 0x0003e2000e901c46ULL, 0x0000001021217824ULL, 0x000fc400078e0214ULL,
0x0000001023237824ULL, 0x100fe200078e0214ULL, 0x000000000a1b7faeULL, 0x0003e2000e101c46ULL,
0x0000001025257824ULL, 0x000fe400078e0214ULL, 0x0000000107077824ULL, 0x000fe200030e060fULL,
0x00000000161d7faeULL, 0x0003e8000d901c46ULL, 0x0000000012217faeULL, 0x0003e8000d101c46ULL,
0x0000000010237faeULL, 0x0003e8000c901c46ULL, 0x0000000006257faeULL, 0x0003e2000c101c46ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x000000140e177811ULL, 0x000fe200078fe8ffULL,
0x000040003c307824ULL, 0x000fe200078e020dULL, 0x000000040e107811ULL, 0x040fe400078fe8ffULL,
0x000000100e137811ULL, 0x040fe200078fe8ffULL, 0x0000000117147824ULL, 0x140fe200078e020eULL,
0x0000000c0e127811ULL, 0x040fe200078fe8ffULL, 0x0000000817197824ULL, 0x000fe200078e00ffULL,
0x000000080e117811ULL, 0x000fe200078fe8ffULL, 0x00000001100a7824ULL, 0x100fe200078e020eULL,
0x000000200e1a7811ULL, 0x000fe200078fe8ffULL, 0x00000008101f7824ULL, 0x000fe200078e00ffULL,
0xfffffff819147812ULL, 0x000fe200078ee214ULL, 0x00000001130f7824ULL, 0x140fe200078e020eULL,
0x0000001c0e197811ULL, 0x000fe200078fe8ffULL, 0x0000000813187824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL, 0x00000001120b7824ULL, 0x100fe200078e020eULL,
0x0000002c0e2c7811ULL, 0x000fe200078fe8ffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0xfffffff818257812ULL, 0x000fe200078ee20fULL, 0x00000001110a7824ULL, 0x140fe200078e020eULL,
0x000000180e187811ULL, 0x040fe200078fe8ffULL, 0x0000000811217824ULL, 0x000fe200078e00ffULL,
0xfffffff816237812ULL, 0x000fe200078ee20bULL, 0x00000001190b7824ULL, 0x140fe200078e020eULL,
0x000000240e1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000819167824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee20aULL, 0x00000001180a7824ULL, 0x100fe200078e020eULL,
0x000000280e2d7811ULL, 0x000fe200078fe8ffULL, 0x0000000818297824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee20bULL, 0x000000011a0f7824ULL, 0x100fe200078e020eULL,
0x000000300e207811ULL, 0x000fe200078fe8ffULL, 0x000000081a1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x000000012c0b7824ULL, 0x100fe200078e020eULL,
0x000000340e1e7811ULL, 0x000fe200078fe8ffULL, 0x000000082c2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL, 0x000000011b1d7824ULL, 0x140fe200078e020eULL,
0x000000380e287811ULL, 0x040fe200078fe8ffULL, 0x000000081b227824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee20bULL, 0x000000012d0a7824ULL, 0x140fe200078e020eULL,
0x0000000e0e0b7211ULL, 0x000fe200078fe8ffULL, 0x000000082d277824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee21dULL, 0x00000001200f7824ULL, 0x000fc400078e020eULL,
0x0000000820267824ULL, 0x000fe200078e00ffULL, 0xfffffff827247812ULL, 0x000fe200078ee20aULL,
0x000000011e1d7824ULL, 0x100fe200078e020eULL, 0x000000030e0a7211ULL, 0x000fe200078fe8ffULL,
0x000000081e2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8262b7812ULL, 0x000fe200078ee20fULL,
0x0000000128277824ULL, 0x000fe200078e020eULL, 0x0000003c0e267811ULL, 0x000fe200078fe8ffULL,
0x0000000828327824ULL, 0x000fe200078e00ffULL, 0x000000070b0f7812ULL, 0x000fe200078ec0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fc400078ee21dULL,
0x0ffffff80f1d7812ULL, 0x000fe200078ef80eULL, 0x00000001260e7824ULL, 0x040fe200078e020eULL,
0xfffffff8322f7812ULL, 0x000fe200078ee227ULL, 0x00000008260f7824ULL, 0x000fe200078e00ffULL,
0x000000700a277812ULL, 0x000fe200078ef805ULL, 0x0000000103107824ULL, 0x000fe400078e0210ULL,
0x0000100030307836ULL, 0x000fe20000000000ULL, 0xfffffff80f327812ULL, 0x000fe200078ee20eULL,
0x00000080100e7825ULL, 0x000fe200078e00ffULL, 0x00000027060a7210ULL, 0x000fc60007f1e0ffULL,
0x0000000103117824ULL, 0x040fe200078e0211ULL, 0x000000700e317812ULL, 0x000fe200078ef805ULL,
0x0000000103127824ULL, 0x040fe400078e0212ULL, 0x0000001014277824ULL, 0x100fe200078e0230ULL,
0x00000031060e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001016147824ULL, 0x000fe400078e0230ULL,
0x0000000103167824ULL, 0x000fe400078e0213ULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0230ULL, 0x00000070103b7812ULL, 0x000fe200078ef805ULL,
0x000000101f1f7824ULL, 0x100fe400078e0230ULL, 0x0000001021217824ULL, 0x100fe400078e0230ULL,
0x0000001023237824ULL, 0x100fe400078e0230ULL, 0x0000001025257824ULL, 0x100fe400078e0230ULL,
0x0000001029297824ULL, 0x000fc400078e0230ULL, 0x000000101c1c7824ULL, 0x100fe400078e0230ULL,
0x0000001022227824ULL, 0x100fe400078e0230ULL, 0x0000001024247824ULL, 0x100fe400078e0230ULL,
0x000000102a2a7824ULL, 0x100fe400078e0230ULL, 0x000000102b2b7824ULL, 0x100fe400078e0230ULL,
0x000000102e2e7824ULL, 0x000fc400078e0230ULL, 0x000000102f2f7824ULL, 0x100fe400078e0230ULL,
0x0000001032327824ULL, 0x000fe400078e0230ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000103307824ULL, 0x000fe200078e0217ULL, 0x0000007012337812ULL, 0x000fe200078ef805ULL,
0x00000001070b7824ULL, 0x000fe200000e060bULL, 0x0000003b06107210ULL, 0x000fe20007f1e0ffULL,
0x0000008030307825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1d7faeULL, 0x0003e2000b901c46ULL, 0x0000000103347824ULL, 0x000fe400078e0218ULL,
0x00000001070f7824ULL, 0x040fe200008e060fULL, 0x0000003306127210ULL, 0x000fe20007f3e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000007030337812ULL, 0x000fe400078ef805ULL,
0x000000000e1f7faeULL, 0x0003e2000b901c46ULL, 0x0000000107117824ULL, 0x000fe200000e0611ULL,
0x0000003306187210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007034337812ULL, 0x000fc400078ef805ULL, 0x0000000010217faeULL, 0x0003e2000b901c46ULL,
0x0000000103307824ULL, 0x000fe200078e0219ULL, 0x0000007016377812ULL, 0x000fe200078ef805ULL,
0x0000000107197824ULL, 0x000fe400000e0631ULL, 0x0000000103347824ULL, 0x000fe200078e021aULL,
0x00000033061a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000003706167210ULL, 0x000fc60007f5e0ffULL, 0x0000000103367824ULL, 0x040fe200078e021bULL,
0x0000007030337812ULL, 0x000fe200078ef805ULL, 0x00000001033e7824ULL, 0x000fe400078e022dULL,
0x00000001071b7824ULL, 0x000fe400000e0635ULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000070342d7812ULL, 0x000fc600078ef805ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x00000070363b7812ULL, 0x000fc600078ef805ULL,
0x0000000103407824ULL, 0x000fe200078e022cULL, 0x00000033062c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000107137824ULL, 0x040fe200008e0613ULL, 0x000000703e337812ULL, 0x000fe200078ef805ULL,
0x0000000107177824ULL, 0x040fe200010e0617ULL, 0x0000002d06307210ULL, 0x000fe20007f3e0ffULL,
0x00000001072d7824ULL, 0x000fe200000e0631ULL, 0x0000003b06347210ULL, 0x000fe20007f1e0ffULL,
0x0000008040407825ULL, 0x000fe200078e00ffULL, 0x0000003306367210ULL, 0x000fe20007f5e0ffULL,
0x0000000012237faeULL, 0x0003e4000b901c46ULL, 0x00000001033e7824ULL, 0x000fe200078e0220ULL,
0x0000007040337812ULL, 0x000fe200078ef805ULL, 0x0000000107317824ULL, 0x000fe200008e0635ULL,
0x0000000016257faeULL, 0x0003e2000b901c46ULL, 0x0000000103427824ULL, 0x000fc400078e021eULL,
0x0000000107357824ULL, 0x000fe200000e0637ULL, 0x0000003306407210ULL, 0x000fe20007f1e0ffULL,
0x0000000103447824ULL, 0x000fe200078e0228ULL, 0x0000000018277faeULL, 0x0003e2000b901c46ULL,
0x0000000107377824ULL, 0x000fe400010e063fULL, 0x0000000103467824ULL, 0x000fe200078e0226ULL,
0x000000001a297faeULL, 0x0003e2000b901c46ULL, 0x000000803e3e7825ULL, 0x000fc600078e00ffULL,
0x000000002c147faeULL, 0x0003e2000b901c46ULL, 0x0000008042427825ULL, 0x000fe200078e00ffULL,
0x000000703e3d7812ULL, 0x000fe400078ef805ULL, 0x00000000301c7faeULL, 0x0003e2000b901c46ULL,
0x0000008044447825ULL, 0x000fe200078e00ffULL, 0x00000070423b7812ULL, 0x000fe400078ef805ULL,
0x0000000034227faeULL, 0x0003e2000b901c46ULL, 0x0000008046467825ULL, 0x000fe200078e00ffULL,
0x0000007044337812ULL, 0x000fc400078ef805ULL, 0x0000003b06427210ULL, 0x000fe20007f3e0ffULL,
0x0000000107417824ULL, 0x040fe200000e0641ULL, 0x0000007046057812ULL, 0x000fe200078ef805ULL,
0x0000000036247faeULL, 0x0003e2000b901c46ULL, 0x0000003d063e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000107437824ULL, 0x040fe200008e0643ULL, 0x0000003306447210ULL, 0x000fe20007f5e0ffULL,
0x00000000402a7faeULL, 0x0003e2000b901c46ULL, 0x0000000506067210ULL, 0x000fe20007f7e0ffULL,
0x00000001073f7824ULL, 0x040fe400000e063fULL, 0x0000000107457824ULL, 0x000fc400010e0645ULL,
0x0000000107077824ULL, 0x000fe200018e0647ULL, 0x000000003e2b7faeULL, 0x0003e8000b901c46ULL,
0x00000000422e7faeULL, 0x0003e8000b901c46ULL, 0x00000000442f7faeULL, 0x0003e8000b901c46ULL,
0x0000000006327faeULL, 0x0003e4000b901c46ULL, 0x000000043c057836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff077424ULL, 0x002fc600078e00ffULL,
0x0000003a0500720cULL, 0x000fda0003f06070ULL, 0x00009400ff0f8b82ULL, 0x000e620000000800ULL,
0x0000000215068824ULL, 0x000fce00078e00ffULL, 0x00009000ff0a8b82ULL, 0x000ea20000000a00ULL,
0x0000000f060f8224ULL, 0x002fc800078e0205ULL, 0x000000040f0a8825ULL, 0x004fca00078e000aULL,
0x000000060a078981ULL, 0x000324000c1e1900ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x017600090d0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff107224ULL, 0x000fce00078e00ffULL, 0x000000101000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fce0000015200ULL,
0x0000000e0a117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0bULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc8000001140fULL, 0x0000001106067211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x0000000206067819ULL, 0x000fc8000000120fULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000110107836ULL, 0x000fce0000000000ULL, 0x017600090d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000097919ULL, 0x000e620000000000ULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000203c067824ULL, 0x002fca00078e0209ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL,
0x0000000f06087812ULL, 0x000fc600078ec0ffULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x00000010080a7824ULL, 0x040fe400078e00ffULL, 0x0000000109067836ULL, 0x000fe20000000000ULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x00000010080b7824ULL, 0x000fc600078e00ffULL,
0x0000000f06087812ULL, 0x000fe400078ec0ffULL, 0x000000f00a067812ULL, 0x000fe400078ee209ULL,
0x000000f00b087812ULL, 0x000fc600078ee208ULL, 0x0000001006067824ULL, 0x100fe400078e020dULL,
0x0000001008087824ULL, 0x000fc600078e020dULL, 0x0000000006187984ULL, 0x000e680000000c00ULL,
0x0000000008107984ULL, 0x000ea20000000c00ULL, 0x000000ffff1c7224ULL, 0x002fe400078e0018ULL,
0x000000ffff187224ULL, 0x000fe400078e0019ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000ffff197224ULL, 0x000fc400078e001bULL, 0x000000ffff1e7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0013ULL, 0x0000001c06007388ULL, 0x0003e80000000c00ULL,
0x0000001808007388ULL, 0x0003e20000000c00ULL, 0x0176000e0d0e79a7ULL, 0x0002a4000850003fULL,
0x0000000000087805ULL, 0x002fce0000015200ULL, 0x0176000f0d0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff107224ULL, 0x000fce00078e00ffULL,
0x000000101000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a08117210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc8000001140bULL,
0x0000001106067211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000206067819ULL, 0x000fc8000000120bULL, 0x000000060000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000110107836ULL, 0x000fce0000000000ULL,
0x0176000f0d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009400ff087b82ULL, 0x000e620000000800ULL, 0x0000000000067919ULL, 0x000ea20000000000ULL,
0x0000840000097ab9ULL, 0x000fe20000000800ULL, 0x3db504f30c097820ULL, 0x010fe20000410000ULL,
0x0000001f09047890ULL, 0x000fe4000fffe03fULL, 0x80000009390e7c36ULL, 0x000fe20008000000ULL,
0xffffffff09057890ULL, 0x000fe2000fffe03fULL, 0x00000100040a7836ULL, 0x000fe20000000000ULL,
0x000000043f047899ULL, 0x000fe20008011604ULL, 0x000000083c0b7824ULL, 0x140fe200078e020dULL,
0x00000008ff0e7819ULL, 0x000fe2000001160eULL, 0x000000203c0c7824ULL, 0x000fe200078e020dULL,
0x0000000909087890ULL, 0x000fe2000fffe03fULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x000000ffff207224ULL, 0x000fc400078e00ffULL,
0x0000000815087224ULL, 0x002fd200078e02ffULL, 0x00008e00ff107b82ULL, 0x004e620000000a00ULL,
0x000000020f137836ULL, 0x000fe20000000000ULL, 0x00000001203b7812ULL, 0x000fe200078e0cffULL,
0x0000000702077224ULL, 0x010fc600078e02ffULL, 0x000000381300720cULL, 0x000fe20003f06070ULL,
0x0000008007107825ULL, 0x002fd800078e0010ULL, 0x0000000c00308947ULL, 0x000fea0003800000ULL,
0x000001000f127824ULL, 0x000fe200078e020aULL, 0x00000003ff147819ULL, 0x004fe20000011606ULL,
0x000040003c227824ULL, 0x000fc600078e020dULL, 0x0000001239137248ULL, 0x000fe20007fe0000ULL,
0x0000000414187836ULL, 0x000fe40000000000ULL, 0x0000000c141e7836ULL, 0x000fe40000000000ULL,
0x0000000113137824ULL, 0x000fe400078e0a12ULL, 0x0000000118077824ULL, 0x040fe400078e0206ULL,
0x0000000818167824ULL, 0x040fe200078e00ffULL, 0x000000131800720cULL, 0x080fe20003f46070ULL,
0x0000000103187824ULL, 0x000fe200078e0218ULL, 0x000000131e00720cULL, 0x040fe20003fa6070ULL,
0x000000011e157824ULL, 0x000fe200078e0206ULL, 0xfffffff816297812ULL, 0x000fe200078ee207ULL,
0x0000001006077824ULL, 0x000fc400078e00ffULL, 0x000000081e1a7824ULL, 0x000fe400078e00ffULL,
0x0000000103167824ULL, 0x000fe200078e0214ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0xfffffff81a2d7812ULL, 0x000fc600078ee215ULL,
0x0000001814287836ULL, 0x000fe20000000000ULL, 0x0000000718157212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x0000000128187824ULL, 0x100fe200078e0206ULL,
0x00000007161b7212ULL, 0x000fe200078efcffULL, 0x00000008281d7824ULL, 0x000fe200078e00ffULL,
0x0000001510167210ULL, 0x000fe20007f3e0ffULL, 0x00000008141c7836ULL, 0x000fe20000000000ULL,
0x0000001b101a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001014247836ULL, 0x000fe20000000000ULL,
0xfffffff81d157812ULL, 0x000fe200078ee218ULL, 0x000000011c127824ULL, 0x040fe200078e0206ULL,
0x000000131c00720cULL, 0x0c0fe20003f66070ULL, 0x000000081c2b7824ULL, 0x000fe200078e00ffULL,
0x000000132400720cULL, 0x000fe20003f86070ULL, 0x0000000103187824ULL, 0x000fc400078e021cULL,
0x00000001031c7824ULL, 0x000fe200078e021eULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee212ULL,
0x00000001141f7824ULL, 0x000fe400078e0206ULL, 0x000000801c1c7825ULL, 0x000fc600078e00ffULL,
0x000000071f237812ULL, 0x000fe200078ec0ffULL, 0x00000001031e7824ULL, 0x000fe200078e0224ULL,
0x000000071c217212ULL, 0x000fe200078efcffULL, 0x00000001111b7824ULL, 0x040fe200000e0617ULL,
0x0ffffff823237812ULL, 0x000fe200078ef806ULL, 0x0000000124127824ULL, 0x040fe200078e0206ULL,
0x00000021101c7210ULL, 0x000fe20007fde0ffULL, 0x00000008242f7824ULL, 0x000fe400078e00ffULL,
0x0000000111177824ULL, 0x000fe200008e0619ULL, 0x000000131400720cULL, 0x000fe20003f26070ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fc600078ee212ULL,
0x0000001414267836ULL, 0x000fe20000000000ULL, 0x0000000718257212ULL, 0x000fe200078efcffULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0x0000002510247210ULL, 0x000fe20007f1e0ffULL,
0x0000000126127824ULL, 0x000fe200078e0206ULL, 0x000000071e217212ULL, 0x000fe200078efcffULL,
0x0000000826317824ULL, 0x040fe400078e00ffULL, 0x00000001111d7824ULL, 0x000fe200030e061dULL,
0x0000002110187210ULL, 0x000fe20007fde0ffULL, 0x00000001031e7824ULL, 0x000fe200078e0226ULL,
0xfffffff831317812ULL, 0x000fe200078ee212ULL, 0x000020003b127824ULL, 0x000fe400078e0222ULL,
0x0000000111257824ULL, 0x000fe200000e0619ULL, 0x000000132600720cULL, 0x000fe20003f06070ULL,
0x0000100012127836ULL, 0x000fc40000000000ULL, 0x0000000111197824ULL, 0x000fe400030e061fULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x0000001023217824ULL, 0x000fe200078e0212ULL,
0x000000071e277212ULL, 0x000fe200078efcffULL, 0x00000020142a7836ULL, 0x000fe40000000000ULL,
0x0000000103237824ULL, 0x000fe200078e0228ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a217faeULL, 0x0003e2000c901c46ULL, 0x000000012a1e7824ULL, 0x000fe200078e0206ULL,
0x000000132800720cULL, 0x000fe20003f26070ULL, 0x000000082a357824ULL, 0x000fe400078e00ffULL,
0x0000001c14267836ULL, 0x000fc40000000000ULL, 0x00000030142c7836ULL, 0x000fe20000000000ULL,
0xfffffff835357812ULL, 0x000fe200078ee21eULL, 0x0000000126287824ULL, 0x040fe400078e0206ULL,
0x0000000826337824ULL, 0x040fe200078e00ffULL, 0x00000027101a7210ULL, 0x002fe20007fde0ffULL,
0x0000001029217824ULL, 0x100fe400078e0212ULL, 0x0000001015157824ULL, 0x000fe200078e0212ULL,
0xfffffff833337812ULL, 0x000fe200078ee228ULL, 0x00000001111b7824ULL, 0x000fe200030e061fULL,
0x0000000016217faeULL, 0x0003e2000d101c46ULL, 0x00000080231e7825ULL, 0x000fe200078e00ffULL,
0x000000132600720cULL, 0x000fc60003f46070ULL, 0x0000000103267824ULL, 0x000fe200078e0226ULL,
0x000000071e277212ULL, 0x000fe200078efcffULL, 0x000000102b237824ULL, 0x000fe400078e0212ULL,
0x0000000103287824ULL, 0x000fe200078e022aULL, 0x00000027101e7210ULL, 0x000fe20007fde0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000024237faeULL, 0x0005e2000d901c46ULL,
0x000000132a00720cULL, 0x000fe40003f66070ULL, 0x0000008028167825ULL, 0x002fe200078e00ffULL,
0x0000000726297212ULL, 0x000fc600078efcffULL, 0x00000001111f7824ULL, 0x000fe400030e061fULL,
0x00000024142a7836ULL, 0x000fe40000000000ULL, 0x000000102d217824ULL, 0x000fe200078e0212ULL,
0x0000002910247210ULL, 0x004fe20007fde0ffULL, 0x000000012a287824ULL, 0x000fe200078e0206ULL,
0x0000000716237212ULL, 0x000fe200078efcffULL, 0x0000000103167824ULL, 0x000fe200078e022aULL,
0x000000001c217faeULL, 0x0003e2000e901c46ULL, 0x0000000111257824ULL, 0x000fe200030e0627ULL,
0x0000002310267210ULL, 0x000fe20007fde0ffULL, 0x000000082a2b7824ULL, 0x040fe200078e00ffULL,
0x000000132a00720cULL, 0x000fe20003fa6070ULL, 0x000000102f237824ULL, 0x000fc400078e0212ULL,
0x0000000111277824ULL, 0x000fe200030e0617ULL, 0xfffffff82b297812ULL, 0x000fe400078ee228ULL,
0x0000000018237faeULL, 0x0005e2000e101c46ULL, 0x00000080161c7825ULL, 0x002fc800078e00ffULL,
0x0000002814167836ULL, 0x000fe20000000000ULL, 0x000000071c177212ULL, 0x000fc600078efcffULL,
0x0000000116217824ULL, 0x040fe200078e0206ULL, 0x000000131600720cULL, 0x040fe20003f86070ULL,
0x0000000816287824ULL, 0x000fe200078e00ffULL, 0x00000017101c7210ULL, 0x000fe20007fde0ffULL,
0x0000000103167824ULL, 0x040fe400078e0216ULL, 0x0000000103237824ULL, 0x004fe200078e022cULL,
0xfffffff8282b7812ULL, 0x000fe200078ee221ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000002c14287836ULL, 0x000fe20000000000ULL, 0x0000000716197212ULL, 0x000fe200078efcffULL,
0x00000001111d7824ULL, 0x000fe400030e061dULL, 0x0000000103187824ULL, 0x000fe200078e0228ULL,
0x0000001910167210ULL, 0x000fe20007fde0ffULL, 0x0000001031217824ULL, 0x000fe400078e0212ULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x000000001a217faeULL, 0x0003e2000c101c46ULL,
0x00000001282a7824ULL, 0x040fe200078e0206ULL, 0x000000132800720cULL, 0x0c0fe20003f06070ULL,
0x00000008282d7824ULL, 0x000fe200078e00ffULL, 0x000000001e157faeULL, 0x0005e2000c901c46ULL,
0x0000000111177824ULL, 0x000fe200030e0617ULL, 0x000000132c00720cULL, 0x000fe20003f26070ULL,
0x0000003414287836ULL, 0x000fe20000000000ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee22aULL,
0x00000038142a7836ULL, 0x000fe20000000000ULL, 0x0000000718217212ULL, 0x002fe200078efcffULL,
0x00000080231a7825ULL, 0x000fc600078e00ffULL, 0x0000002110187210ULL, 0x000fe20007fde0ffULL,
0x000000012c237824ULL, 0x000fe200078e0206ULL, 0x000000071a217212ULL, 0x000fe200078efcffULL,
0x000000082c2c7824ULL, 0x000fe400078e00ffULL, 0x00000001031e7824ULL, 0x004fe400078e0228ULL,
0x0000000111197824ULL, 0x000fe200030e0619ULL, 0x00000021101a7210ULL, 0x000fe20007fde0ffULL,
0x0000001033217824ULL, 0x100fe200078e0212ULL, 0xfffffff82c2f7812ULL, 0x000fe200078ee223ULL,
0x0000001035157824ULL, 0x000fc400078e0212ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000000024217faeULL, 0x0003e6000d101c46ULL, 0x0000003c142c7836ULL, 0x000fe20000000000ULL,
0x0000000026157faeULL, 0x0005e2000d901c46ULL, 0x0000001029237824ULL, 0x000fe200078e0212ULL,
0x000000071e297212ULL, 0x000fe200078efcffULL, 0x0000000103147824ULL, 0x000fe200078e022aULL,
0x000000132a00720cULL, 0x080fe20003f66070ULL, 0x00000001111b7824ULL, 0x000fe200030e061bULL,
0x000000001c237faeULL, 0x0007e2000e901c46ULL, 0x00000029101e7210ULL, 0x000fe20007fde0ffULL,
0x0000000128217824ULL, 0x042fe200078e0206ULL, 0x000000132800720cULL, 0x0c0fe20003fa6070ULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x000000132c00720cULL, 0x000fe20003f46070ULL,
0x0000008014147825ULL, 0x004fc600078e00ffULL, 0xfffffff828257812ULL, 0x000fe200078ee221ULL,
0x00000001111f7824ULL, 0x000fe200030e061fULL, 0x0000000714137212ULL, 0x000fe200078efcffULL,
0x00000001031c7824ULL, 0x008fe400078e022cULL, 0x000000012a237824ULL, 0x040fe200078e0206ULL,
0x0000001310147210ULL, 0x000fe20007fde0ffULL, 0x000000082a2a7824ULL, 0x000fe400078e00ffULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0xfffffff82a277812ULL, 0x000fe200078ee223ULL,
0x000000012c247824ULL, 0x000fe200078e0206ULL, 0x000000071c237212ULL, 0x000fe200078efcffULL,
0x000000082c297824ULL, 0x000fe400078e00ffULL, 0x0000000111157824ULL, 0x000fe200030e0615ULL,
0x0000002310107210ULL, 0x000fe20007fde0ffULL, 0x000000102b077824ULL, 0x100fe200078e0212ULL,
0xfffffff829297812ULL, 0x000fe200078ee224ULL, 0x000000102d137824ULL, 0x100fe400078e0212ULL,
0x000000102f217824ULL, 0x100fe200078e0212ULL, 0x0000000016077faeULL, 0x0003e2000e101c46ULL,
0x0000001025237824ULL, 0x000fc400078e0212ULL, 0x0000001027257824ULL, 0x100fe200078e0212ULL,
0x0000000018137faeULL, 0x0003e2000c101c46ULL, 0x0000001029277824ULL, 0x000fe400078e0212ULL,
0x0000000111117824ULL, 0x000fe200030e061dULL, 0x000000001a217faeULL, 0x0003e8000c901c46ULL,
0x000000001e237faeULL, 0x0003e8000e901c46ULL, 0x0000000014257faeULL, 0x0003e8000d901c46ULL,
0x0000000010277faeULL, 0x0003e2000d101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x0000000806187811ULL, 0x004fe200078fe8ffULL, 0x000040003c227824ULL, 0x000fe200078e020dULL,
0x0000000406147811ULL, 0x040fe400078fe8ffULL, 0x00000010061a7811ULL, 0x000fe200078fe8ffULL,
0x0000000118127824ULL, 0x100fe200078e0206ULL, 0x00000014061b7811ULL, 0x000fe200078fe8ffULL,
0x00000008182d7824ULL, 0x000fe200078e00ffULL, 0x0000000c06197811ULL, 0x000fe200078fe8ffULL,
0x0000000114077824ULL, 0x100fe200078e0206ULL, 0x00000018061d7811ULL, 0x000fe200078fe8ffULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL,
0x000000011a127824ULL, 0x100fe200078e0206ULL, 0x0000002006257811ULL, 0x000fe200078fe8ffULL,
0x000000081a437824ULL, 0x000fe200078e00ffULL, 0xfffffff816237812ULL, 0x000fe200078ee207ULL,
0x000000011b137824ULL, 0x140fe200078e0206ULL, 0x0000002406247811ULL, 0x040fe200078fe8ffULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0x0000001c06287811ULL, 0x040fe200078fe8ffULL,
0x0000000119077824ULL, 0x140fe200078e0206ULL, 0xfffffff843437812ULL, 0x000fe200078ee212ULL,
0x0000000819167824ULL, 0x000fe200078e00ffULL, 0xfffffff81c417812ULL, 0x000fe200078ee213ULL,
0x000000011d157824ULL, 0x140fe200078e0206ULL, 0x0000002806277811ULL, 0x040fe200078fe8ffULL,
0x000000081d1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8162f7812ULL, 0x000fe200078ee207ULL,
0x0000000125127824ULL, 0x140fe200078e0206ULL, 0x0000003006407811ULL, 0x040fe200078fe8ffULL,
0x0000000825377824ULL, 0x000fe200078e00ffULL, 0x0000003406367811ULL, 0x000fe200078fe8ffULL,
0x0000000124137824ULL, 0x100fe200078e0206ULL, 0x0000002c06267811ULL, 0x000fe200078fe8ffULL,
0x00000008241c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e3f7812ULL, 0x000fe200078ee215ULL,
0x0000000128077824ULL, 0x140fe200078e0206ULL, 0xfffffff837377812ULL, 0x000fe200078ee212ULL,
0x0000000828167824ULL, 0x000fe200078e00ffULL, 0xfffffff81c357812ULL, 0x000fe200078ee213ULL,
0x0000000127157824ULL, 0x140fe200078e0206ULL, 0x0000003806347811ULL, 0x000fe200078fe8ffULL,
0x00000008271e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8163d7812ULL, 0x000fe200078ee207ULL,
0x0000000140127824ULL, 0x100fe200078e0206ULL, 0x0000003c063e7811ULL, 0x000fe200078fe8ffULL,
0x00000008401f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e337812ULL, 0x000fe200078ee215ULL,
0x0000000136137824ULL, 0x000fc400078e0206ULL, 0x00000008361c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL, 0x0000000126077824ULL, 0x100fe200078e0206ULL,
0x0000000306127211ULL, 0x000fe200078fe8ffULL, 0x0000000826167824ULL, 0x000fe200078e00ffULL,
0xfffffff81c297812ULL, 0x000fe200078ee213ULL, 0x0000000134157824ULL, 0x000fe200078e0206ULL,
0x0000000606137211ULL, 0x000fe200078fe8ffULL, 0x00000008341e7824ULL, 0x000fe200078e00ffULL,
0xfffffff816317812ULL, 0x000fe200078ee207ULL, 0x0000001006077824ULL, 0x000fc400078e00ffULL,
0x0000000103167824ULL, 0x000fe200078e0214ULL, 0xfffffff81e2b7812ULL, 0x000fe200078ee215ULL,
0x000020003b147824ULL, 0x000fe200078e0222ULL, 0x0000000713157812ULL, 0x000fe200078ec0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0ffffff815217812ULL, 0x000fe200078ef806ULL, 0x0000100014327836ULL, 0x000fe20000000000ULL,
0x0000000712177212ULL, 0x000fe200078efcffULL, 0x0000008016147825ULL, 0x000fc600078e00ffULL,
0x0000001710127210ULL, 0x000fe20007f1e0ffULL, 0x000000013e1c7824ULL, 0x000fe200078e0206ULL,
0x0000000714177212ULL, 0x000fe200078efcffULL, 0x000000083e457824ULL, 0x000fe400078e00ffULL,
0x0000000103167824ULL, 0x000fe200078e0218ULL, 0x0000001710147210ULL, 0x000fe20007f3e0ffULL,
0x00000010292e7824ULL, 0x000fe200078e0232ULL, 0xfffffff845457812ULL, 0x000fe200078ee21cULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x00000001031c7824ULL, 0x040fe200078e021bULL,
0x0000000716297212ULL, 0x000fe200078efcffULL, 0x00000001031e7824ULL, 0x000fe400078e021dULL,
0x000000801c1c7825ULL, 0x000fc800078e00ffULL, 0x0000000113137824ULL, 0x000fe200000e0611ULL,
0x0000002910167210ULL, 0x000fe20007f1e0ffULL, 0x000000101f307824ULL, 0x000fe200078e0232ULL,
0x000000071c297212ULL, 0x000fe200078efcffULL, 0x00000001031a7824ULL, 0x000fe400078e021aULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x0000000117177824ULL, 0x000fe200000e0611ULL,
0x00000029101c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000103197824ULL, 0x000fe200078e0219ULL,
0x000000071e297212ULL, 0x000fe200078efcffULL, 0x000000801a1a7825ULL, 0x000fc800078e00ffULL,
0x0000001021217824ULL, 0x100fe400078e0232ULL, 0x0000001023237824ULL, 0x100fe400078e0232ULL,
0x000000102d2d7824ULL, 0x100fe200078e0232ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012217faeULL, 0x0003e2000b901c46ULL, 0x000000102f2f7824ULL, 0x100fe400078e0232ULL,
0x0000001043437824ULL, 0x100fe400078e0232ULL, 0x0000001041417824ULL, 0x000fc400078e0232ULL,
0x000000103f3f7824ULL, 0x100fe400078e0232ULL, 0x000000103d3d7824ULL, 0x100fe400078e0232ULL,
0x0000001037377824ULL, 0x100fe400078e0232ULL, 0x0000001035357824ULL, 0x100fe400078e0232ULL,
0x0000001033337824ULL, 0x100fe400078e0232ULL, 0x0000001031317824ULL, 0x000fc400078e0232ULL,
0x000000102b2c7824ULL, 0x100fe400078e0232ULL, 0x0000001045327824ULL, 0x000fe200078e0232ULL,
0x000000071a457212ULL, 0x000fe200078efcffULL, 0x0000008019187825ULL, 0x000fc600078e00ffULL,
0x00000045101a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000103287824ULL, 0x000fe200078e0228ULL,
0x00000007182b7212ULL, 0x000fe200078efcffULL, 0x000000011d1d7824ULL, 0x000fe200000e0611ULL,
0x00000029101e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000103447824ULL, 0x040fe400078e0225ULL,
0x0000000103297824ULL, 0x000fe400078e0224ULL, 0x0000008028247825ULL, 0x000fc800078e00ffULL,
0x0000008044447825ULL, 0x000fc800078e00ffULL, 0x0000000115157824ULL, 0x000fe200008e0611ULL,
0x0000002b10187210ULL, 0x000fe20007f3e0ffULL, 0x00000001032a7824ULL, 0x000fe200078e0227ULL,
0x0000000724277212ULL, 0x080fe200078efcffULL, 0x0000008029287825ULL, 0x000fe200078e00ffULL,
0x0000000744477212ULL, 0x080fe200078efcffULL, 0x0000000014237faeULL, 0x0003e4000b901c46ULL,
0x000000011f1f7824ULL, 0x100fe200000e0611ULL, 0x0000002710247210ULL, 0x000fe20007f1e0ffULL,
0x0000000119197824ULL, 0x100fe200008e0611ULL, 0x0000000728277212ULL, 0x080fe200078efcffULL,
0x0000000103427824ULL, 0x000fe200078e0226ULL, 0x0000004710267210ULL, 0x000fe20007f3e0ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x00000000162d7faeULL, 0x0003e6000b901c46ULL,
0x0000000125257824ULL, 0x100fe200000e0611ULL, 0x0000002710287210ULL, 0x000fe20007f1e0ffULL,
0x0000000145277824ULL, 0x100fe200008e0611ULL, 0x000000072a497212ULL, 0x080fe200078efcffULL,
0x0000008042447825ULL, 0x000fe200078e00ffULL, 0x00000000182f7faeULL, 0x0003e6000b901c46ULL,
0x000000011b1b7824ULL, 0x000fe200010e0611ULL, 0x00000049102a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000103467824ULL, 0x040fe200078e0240ULL, 0x0000000744497212ULL, 0x000fe200078efcffULL,
0x00000001034c7824ULL, 0x040fe200078e0236ULL, 0x000000001a437faeULL, 0x0003e2000b901c46ULL,
0x00000001034a7824ULL, 0x000fc400078e0234ULL, 0x0000000103487824ULL, 0x000fe200078e023eULL,
0x000000001c417faeULL, 0x0003e2000b901c46ULL, 0x0000008046467825ULL, 0x000fc600078e00ffULL,
0x000000001e3f7faeULL, 0x0003e2000b901c46ULL, 0x0000000129297824ULL, 0x100fe200000e0611ULL,
0x0000004910447210ULL, 0x000fe20007f1e0ffULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x00000007464f7212ULL, 0x080fe200078efcffULL, 0x00000000243d7faeULL, 0x0003e4000b901c46ULL,
0x000000804a4a7825ULL, 0x000fe200078e00ffULL, 0x000000074c517212ULL, 0x080fe200078efcffULL,
0x0000000026377faeULL, 0x0003e4000b901c46ULL, 0x0000008048487825ULL, 0x000fe200078e00ffULL,
0x000000074a537212ULL, 0x080fe200078efcffULL, 0x0000000028357faeULL, 0x0003e2000b901c46ULL,
0x00000051104c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000145457824ULL, 0x100fe200000e0611ULL,
0x0000000748077212ULL, 0x000fe200078efcffULL, 0x000000012b2b7824ULL, 0x100fe200010e0611ULL,
0x0000004f10467210ULL, 0x000fe20007f1e0ffULL, 0x000000014d4d7824ULL, 0x000fe200008e0611ULL,
0x00000053104a7210ULL, 0x000fc40007f5e0ffULL, 0x0000000710107210ULL, 0x000fe20007f7e0ffULL,
0x0000000147477824ULL, 0x100fe200000e0611ULL, 0x000000002a337faeULL, 0x0003e2000b901c46ULL,
0x000000014b4b7824ULL, 0x100fe400010e0611ULL, 0x0000000149117824ULL, 0x000fe200018e0611ULL,
0x0000000044317faeULL, 0x0003e8000b901c46ULL, 0x0000000046307faeULL, 0x0003e8000b901c46ULL,
0x000000004c2e7faeULL, 0x0003e8000b901c46ULL, 0x000000004a2c7faeULL, 0x0003e8000b901c46ULL,
0x0000000010327faeULL, 0x0003e4000b901c46ULL, 0x0000000405057836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff077424ULL, 0x002fc600078e00ffULL,
0x0000003a0500720cULL, 0x000fda0003f06070ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x0000000208118824ULL, 0x000fe400078e0205ULL, 0x00000020063d7836ULL, 0x000fe20000000000ULL,
0xfffffff806497812ULL, 0x000fe200078ec0ffULL, 0x0000200020487824ULL, 0x000fe200078e0222ULL,
0x00000007063f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x00000004ff3e7819ULL, 0x000fe40000011606ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fc4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000411148825ULL, 0x002fca00078e0014ULL,
0x0000000614078981ULL, 0x000322000c1e1900ULL, 0xfffffff83d3d7812ULL, 0x000fe400078ec0ffULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000100048487836ULL, 0x000fe20000000000ULL,
0x0000000749497812ULL, 0x000fe400078ef806ULL, 0x000000083f4a7812ULL, 0x000fc400078ef806ULL,
0x000000073d3d7812ULL, 0x002fce00078ef806ULL, 0x0000000149147824ULL, 0x140fe400078e024cULL,
0x0000000849157824ULL, 0x040fe400078e00ffULL, 0x000000014c407836ULL, 0x000fe40000000000ULL,
0x000000104a177824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x0000000849427824ULL, 0x000fe400078e00ffULL, 0x000000013d167824ULL, 0x000fc400078e024cULL,
0x0000001015187824ULL, 0x000fe400078e0248ULL, 0x000000024c157824ULL, 0x000fe400078e023eULL,
0x000000083d417824ULL, 0x000fe400078e00ffULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x000000014a147824ULL, 0x140fe200078e0215ULL, 0x000000024a507810ULL, 0x040fe20007ffe015ULL,
0x0000000149157824ULL, 0x100fe200078e0240ULL, 0xfffffff841417812ULL, 0x000fe200078ee216ULL,
0x000000104a437824ULL, 0x000fe200078e00ffULL, 0xfffffff017147812ULL, 0x000fe200078ee214ULL,
0x000000013d517824ULL, 0x040fe200078e0240ULL, 0xfffffff842577812ULL, 0x000fe200078ee215ULL,
0x000000083d427824ULL, 0x000fe200078e00ffULL, 0xfffffff043507812ULL, 0x000fe200078ee250ULL,
0x0000001014147824ULL, 0x000fc400078e020dULL, 0x0000001041417824ULL, 0x100fe200078e0248ULL,
0xfffffff842517812ULL, 0x000fe200078ee251ULL, 0x0000001057577824ULL, 0x000fe400078e0248ULL,
0x000000024c4c7836ULL, 0x000fca0000000000ULL, 0x000000084c00780cULL, 0x000fe40003f05270ULL,
0x00000018ff157819ULL, 0x002fe40000011618ULL, 0x000000ff18167812ULL, 0x000fe400078ec0ffULL,
0x00000018ff177819ULL, 0x000fe40000011619ULL, 0x00000015ff43723eULL, 0x000fe400020006ffULL,
0x00000016ff42723eULL, 0x000fc400020006ffULL, 0x00000017ff44723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x00000010ff407819ULL, 0x000fe20000011618ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000ffff18537812ULL, 0x000fe200078ec0ffULL, 0x20000044ff547230ULL, 0x000fe20000004100ULL,
0x000000ff19187812ULL, 0x040fe200078ec0ffULL, 0x000000004144783bULL, 0x0004e20000000200ULL,
0x00000010ff4e7819ULL, 0x000fe40000011619ULL, 0x0000ffff19567812ULL, 0x000fc400078ec0ffULL,
0x00000018ff19723eULL, 0x000fe400020006ffULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x00000008ff187819ULL, 0x000fe40000011653ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000018ff4f7819ULL, 0x100fe2000001161aULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fc4000001161aULL,
0x000000ff1a527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1a587812ULL, 0x000fe200078ec0ffULL,
0x20000019ff1a7230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x20000018ff197230ULL, 0x000fe20000004100ULL, 0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff417819ULL, 0x004fe40000011656ULL, 0x00000010ff4d7819ULL, 0x000fc4000001161bULL,
0x00000018ff737819ULL, 0x000fe4000001161bULL, 0x000000ff1b717812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1b4b7812ULL, 0x000fe400078ec0ffULL, 0x00000052ff53723eULL, 0x000fe200020006ffULL,
0x2000004fff527230ULL, 0x000fe20000004100ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff187819ULL, 0x000fe20000011642ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fc40000011640ULL, 0x00000010ff1b7819ULL, 0x000fe40000011619ULL,
0x0000004eff4f723eULL, 0x000fe400020006ffULL, 0x00000041ff4e723eULL, 0x000fe400020006ffULL,
0x0000105443197816ULL, 0x000fe20000000040ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000010541b187816ULL, 0x000fe20000000018ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000008ff1b7819ULL, 0x000fe20000011658ULL, 0x000000005740783bULL, 0x0005620000000200ULL,
0x00000010ff1a7819ULL, 0x000fc4000001161aULL, 0x0000001bff1b723eULL, 0x000fe200020006ffULL,
0x000000181434723cULL, 0x002fe20000041834ULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x008fe20000011644ULL, 0x2000001bff577230ULL, 0x004fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000010ff197819ULL, 0x000fe2000001164eULL,
0x0000001051187824ULL, 0x000fe200078e0248ULL, 0x00000018ff6f7819ULL, 0x000fe20000011644ULL,
0x20000055ff587230ULL, 0x000fe20000004100ULL, 0x00001054194e7816ULL, 0x000fc4000000001aULL,
0x000000ff44707812ULL, 0x040fe200078ec0ffULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x0000ffff44637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff447819ULL, 0x000fe40000011652ULL,
0x00000010ff527819ULL, 0x000fe40000011653ULL, 0x00000010ff537819ULL, 0x000fe40000011658ULL,
0x00000010ff577819ULL, 0x000fc40000011657ULL, 0x000000ff456e7812ULL, 0x000fe400078ec0ffULL,
0x0000105444537816ULL, 0x000fe40000000053ULL, 0x0000105457527816ULL, 0x000fe40000000052ULL,
0x00000018ff567819ULL, 0x000fe40000011646ULL, 0x0000ffff475d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff45627812ULL, 0x000fe200078ec0ffULL, 0x00000052142c723cULL, 0x000fe2000004182cULL,
0x00000018ff6c7819ULL, 0x000fc40000011647ULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x00000018ff657819ULL, 0x020fe40000011641ULL, 0x00000010ff557819ULL, 0x000fe40000011646ULL,
0x000000ff466d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff46597812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff467819ULL, 0x100fe40000011640ULL,
0x00000018ff697819ULL, 0x000fe40000011640ULL, 0x00000010ff5c7819ULL, 0x102fe4000001161bULL,
0x00000018ff647819ULL, 0x000fe4000001161bULL, 0x000000ff1b607812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1b577812ULL, 0x000fc400078ec0ffULL, 0x0000006eff1b723eULL, 0x000fe400020006ffULL,
0x00000056ff6e723eULL, 0x000fe400020006ffULL, 0x00000010ff537819ULL, 0x100fe20000011619ULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x00000018ff777819ULL, 0x000fe40000011619ULL,
0x000000ff19767812ULL, 0x040fe400078ec0ffULL, 0x0000ffff196b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe4000001161aULL, 0x0000006cff19723eULL, 0x000fe200020006ffULL,
0x2000006eff6c7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x000000ff556e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff405b7812ULL, 0x000fc400078ec0ffULL, 0x00000062ff55723eULL, 0x000fe400020006ffULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff4f7819ULL, 0x000fe2000001164fULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000069ff62723eULL, 0x000fe200020006ffULL,
0x2000005dff697230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000065ff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff46467812ULL, 0x000fe200078ec0ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x000000ff40687812ULL, 0x000fc400078ec0ffULL,
0x00000010ff407819ULL, 0x000fe40000011641ULL, 0x000000ff4d747812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4b7819ULL, 0x000fe4000001164bULL, 0x00000008ff657819ULL, 0x000fe4000001165bULL,
0x00001054544f7816ULL, 0x000fe4000000004fULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x00000046ff5b723eULL, 0x000fe200020006ffULL, 0x20000075ff467230ULL, 0x000fe20000004100ULL,
0x0000ffff42547812ULL, 0x000fe200078ec0ffULL, 0x0000004e1430723cULL, 0x000fe20000041830ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x000000ff40757812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000064ff407230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x2000005bff647230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x100fe20000011618ULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000018ff797819ULL, 0x000fc40000011618ULL, 0x000000ff18787812ULL, 0x040fe400078ec0ffULL,
0x0000ffff18527812ULL, 0x000fe200078ec0ffULL, 0x20000071ff187230ULL, 0x000fe20000004100ULL,
0x00000008ff547819ULL, 0x000fe40000011654ULL, 0x000000ff66717812ULL, 0x000fe200078ec0ffULL,
0x20000019ff667230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000004bff197230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fc40000011645ULL,
0x00000054ff5b723eULL, 0x000fe400020006ffULL, 0x000000ff5f547812ULL, 0x000fe200078ec0ffULL,
0x20000075ff5f7230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe20000011645ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe40000011647ULL,
0x000000ff47677812ULL, 0x000fe400078ec0ffULL, 0x000000ff41477812ULL, 0x000fc400078ec0ffULL,
0x0000ffff415a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff447819ULL, 0x100fe40000011642ULL,
0x00000018ff587819ULL, 0x000fe40000011642ULL, 0x000000ff42457812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e4d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fc40000011673ULL,
0x00000010ff4f7819ULL, 0x100fe40000011643ULL, 0x00000018ff427819ULL, 0x000fe40000011643ULL,
0x000000ff43417812ULL, 0x040fe400078ec0ffULL, 0x0000ffff434e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff187819ULL, 0x000fc40000011618ULL,
0x00000010ff737819ULL, 0x000fe40000011619ULL, 0x00000010ff6a7819ULL, 0x000fe4000001161aULL,
0x000000ff1a437812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1a617812ULL, 0x000fe400078ec0ffULL,
0x00000072ff1a723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fc400020006ffULL,
0x000000ff51517812ULL, 0x000fe200078ec0ffULL, 0x2000001aff1a7230ULL, 0x000fe20000004100ULL,
0x0000105475197816ULL, 0x000fe40000000074ULL, 0x0000105473187816ULL, 0x000fe40000000018ULL,
0x00000051ff4b723eULL, 0x000fe200020006ffULL, 0x2000004dff517230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fe40000011663ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x000000181428723cULL, 0x000fe20000041828ULL, 0x00000010ff1a7819ULL, 0x000fc4000001161aULL,
0x00000010ff1b7819ULL, 0x000fe2000001161bULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000001050187824ULL, 0x000fe200078e020dULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000006fff567230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe20000011655ULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x000010541a517816ULL, 0x000fc40000000051ULL,
0x0000105450507816ULL, 0x000fe4000000001bULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x00000008ff597819ULL, 0x000fe40000011659ULL, 0x000000ff53757812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe20000011652ULL, 0x000000501420723cULL, 0x000fe20000041820ULL,
0x00000010ff537819ULL, 0x000fe40000011671ULL, 0x00000010ff747819ULL, 0x000fc40000011656ULL,
0x00000010ff527819ULL, 0x000fe40000011670ULL, 0x00000010ff717819ULL, 0x000fe40000011672ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x0000105474537816ULL, 0x000fe20000000053ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x0000105471527816ULL, 0x000fe20000000052ULL, 0x20000059ff6f7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000068ff63723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x2000004bff687230ULL, 0x000fe20000004100ULL,
0x000000521424723cULL, 0x000fe20000041824ULL, 0x000000ff6a6a7812ULL, 0x000fe200078ec0ffULL,
0x20000047ff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fe2000001166cULL,
0x20000042ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fc4000001166dULL,
0x00000010ff537819ULL, 0x000fe4000001166eULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000006aff6d723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000076ff42723eULL, 0x000fe400020006ffULL,
0x000010546c537816ULL, 0x000fc40000000053ULL, 0x000010546f527816ULL, 0x000fe20000000052ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe20000011666ULL,
0x2000006dff667230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe40000011667ULL,
0x00000010ff517819ULL, 0x000fe20000011668ULL, 0x00000052141c723cULL, 0x000fe2000004181cULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000008ff767819ULL, 0x000fc4000001165aULL,
0x000000ff445a7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff447230ULL, 0x000fe20000004100ULL,
0x000010546a517816ULL, 0x000fe40000000051ULL, 0x0000105469507816ULL, 0x000fe40000000050ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x000000ff4f607812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4f7819ULL, 0x000fe2000001164eULL, 0x000000501410723cULL, 0x000fe20000041810ULL,
0x00000010ff537819ULL, 0x000fc40000011662ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff527819ULL, 0x000fe40000011665ULL,
0x00000060ff4e723eULL, 0x000fe200020006ffULL, 0x20000076ff607230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x0000105453177816ULL, 0x000fe20000000064ULL,
0x20000045ff597230ULL, 0x000fe20000004100ULL, 0x0000105452167816ULL, 0x000fe20000000063ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fc4000001165dULL,
0x00000010ff147819ULL, 0x000fe4000001165eULL, 0x00000010ff157819ULL, 0x000fe2000001165fULL,
0x000000161834723cULL, 0x002fe20000041834ULL, 0x00000010ff517819ULL, 0x000fe40000011660ULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000079ff4d723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000041ff4b7230ULL, 0x000fe20000004100ULL,
0x00000008ff6b7819ULL, 0x000fe2000001166bULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x0000105452157816ULL, 0x000fe40000000015ULL,
0x0000105451147816ULL, 0x000fe40000000014ULL, 0x00000008ff577819ULL, 0x000fe40000011657ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000010ff587819ULL, 0x000fe20000011658ULL,
0x000000141830723cULL, 0x000fe20000041830ULL, 0x00000010ff167819ULL, 0x000fe20000011659ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fc4000001165aULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000077ff45723eULL, 0x000fe400020006ffULL, 0x00000043ff41723eULL, 0x000fe200020006ffULL,
0x20000078ff437230ULL, 0x000fe20000004100ULL, 0x00000073ff70723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000075ff56723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000070ff557230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000006bff677230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000061ff507230ULL, 0x000fe20000004100ULL, 0x0000105458177816ULL, 0x000fe20000000017ULL,
0x2000005cff517230ULL, 0x000fe20000004100ULL, 0x000010545b167816ULL, 0x000fe20000000016ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000010ff527819ULL, 0x000fe4000001164dULL, 0x00000010ff147819ULL, 0x000fe2000001164eULL,
0x00000016182c723cULL, 0x000fe2000004182cULL, 0x00000010ff157819ULL, 0x000fe40000011654ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164fULL, 0x00001054474f7816ULL, 0x000fe40000000014ULL,
0x0000105452157816ULL, 0x000fc40000000015ULL, 0x00000010ff147819ULL, 0x000fe40000011643ULL,
0x00000010ff527819ULL, 0x000fe40000011645ULL, 0x00000010ff167819ULL, 0x000fe40000011642ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff557819ULL, 0x000fc40000011655ULL, 0x00000010ff177819ULL, 0x000fe40000011656ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff437819ULL, 0x000fe40000011666ULL,
0x00000010ff417819ULL, 0x000fe40000011641ULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff427819ULL, 0x000fc40000011650ULL, 0x00000010ff457819ULL, 0x000fe40000011651ULL,
0x00000010ff447819ULL, 0x000fe40000011644ULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x000010544e4e7816ULL, 0x000fe4000000004bULL, 0x0000105455147816ULL, 0x000fe40000000014ULL,
0x0000105452177816ULL, 0x000fc40000000017ULL, 0x0000105467167816ULL, 0x000fe20000000016ULL,
0x0000004e1828723cULL, 0x000fe20000041828ULL, 0x0000105446437816ULL, 0x000fe40000000043ULL,
0x0000105442427816ULL, 0x000fe40000000041ULL, 0x0000105440457816ULL, 0x000fe20000000045ULL,
0x000000141824723cULL, 0x000fe20000041824ULL, 0x0000105457447816ULL, 0x000fca0000000044ULL,
0x000000161820723cULL, 0x000fec0000041820ULL, 0x00000042181c723cULL, 0x000fec000004181cULL,
0x000000441810723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe800300947ULL, 0x000fde000383ffffULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x0000000934177220ULL, 0x080fe20000410000ULL, 0x0000000925347220ULL, 0x080fe20000410000ULL,
0x00000009203e7220ULL, 0x080fe20000410000ULL, 0x0000000921407220ULL, 0x080fe20000410000ULL,
0x00000009223d7220ULL, 0x080fe20000410000ULL, 0x017688140b1479a7ULL, 0x000262000850003fULL,
0x0000000923257220ULL, 0x080fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000936367220ULL, 0x080fe20000410000ULL, 0x0000000937377220ULL, 0x080fe20000410000ULL,
0x0000000930307220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x000000092e2e7220ULL, 0x080fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x0000000928287220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x080fe20000410000ULL,
0x000000092a2a7220ULL, 0x080fe20000410000ULL, 0x000000092b2b7220ULL, 0x080fe20000410000ULL,
0x0000000924167220ULL, 0x080fe20000410000ULL, 0x0000000926267220ULL, 0x080fe20000410000ULL,
0x0000000927277220ULL, 0x080fe20000410000ULL, 0x000000091c417220ULL, 0x080fe20000410000ULL,
0x000000091d427220ULL, 0x080fe20000410000ULL, 0x000000091e227220ULL, 0x080fe20000410000ULL,
0x000000091f217220ULL, 0x080fe20000410000ULL, 0x0000000910437220ULL, 0x080fe20000410000ULL,
0x0000000911447220ULL, 0x080fe20000410000ULL, 0x0000000912207220ULL, 0x080fe20000410000ULL,
0x0000000913237220ULL, 0x002fce0000410000ULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x017688150b0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x0000001210197210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001912127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x017688150b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000406107824ULL, 0x000fe200078e00ffULL,
0x0000000e0f00720cULL, 0x000fe20003f06070ULL, 0x000000803c117824ULL, 0x000fc600078e020dULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x0000000111247824ULL, 0x000fca00078e0210ULL,
0x0174000024107984ULL, 0x0002a20000000c00ULL, 0x0000001000c48947ULL, 0x000fea0003800000ULL,
0x000001000f147824ULL, 0x000fe200078e0204ULL, 0x0000000006187211ULL, 0x040fe200078ff0ffULL,
0x0000000206467824ULL, 0x000fe200078e00ffULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000001439457248ULL, 0x000fe40007fe0000ULL,
0x0000000646467812ULL, 0x000fe400078ec0ffULL, 0x00000009ff197c19ULL, 0x000fe20008011618ULL,
0x0000000145457824ULL, 0x000fc400078e0a14ULL, 0x00008c00ff147b82ULL, 0x000ee20000000a00ULL,
0x00000008461a7c36ULL, 0x000fe20008000000ULL, 0x0000000519197c48ULL, 0x000fe2000bfe0000ULL,
0x000000ffff577224ULL, 0x000fe400078e0a45ULL, 0x0000000a46487c36ULL, 0x000fe20008000000ULL,
0x000000451a00720cULL, 0x080fe20003f26070ULL, 0x0000000818187836ULL, 0x000fe20000000000ULL,
0x000000051a1a7e46ULL, 0x000fe2000b800057ULL, 0x0000000419607c24ULL, 0x000fe2000f8e02ffULL,
0x000000454800720cULL, 0x000fc40003f06070ULL, 0x0000000548557e46ULL, 0x000fe4000b800057ULL,
0x00000004ff1a7819ULL, 0x000fe4000001161aULL, 0x000000ff55557207ULL, 0x000fe40000000000ULL,
0x000000ff1a197207ULL, 0x000fe40000800000ULL, 0x00000009ff187c19ULL, 0x000fe40008011618ULL,
0x00000060551b7211ULL, 0x000fe200078fe0ffULL, 0x00000001601d7824ULL, 0x000fe200078e0219ULL,
0x0000000518187c48ULL, 0x000fc4000bfe0000ULL, 0x00000010464c7812ULL, 0x000fe200078efcffULL,
0x000000021b1a7825ULL, 0x008fc800078e0014ULL, 0x000000021d1c7825ULL, 0x000fe200078e0014ULL,
0x000000061a597981ULL, 0x0044e6000c1e9500ULL, 0x0000000418627c24ULL, 0x000fe2000f8e02ffULL,
0x000000061c5e7981ULL, 0x000ee2000c1e9500ULL, 0x0000000a4c4a7c36ULL, 0x000fe40008000000ULL,
0x0000000119197824ULL, 0x000fe200078e0262ULL, 0x0000002046507812ULL, 0x000fe200078efcffULL,
0x000000084c1a7c36ULL, 0x004fe20008000000ULL, 0x000000454a00720cULL, 0x000fe20003f06070ULL,
0x0000000219187825ULL, 0x000fe200078e0014ULL, 0x000000054a477e46ULL, 0x000fc4000b800057ULL,
0x00000062551f7211ULL, 0x000fe400078fe0ffULL, 0x000000ff47477207ULL, 0x000fe20000000000ULL,
0x0000000a50527c36ULL, 0x000fe20008000000ULL, 0x000000051a1b7e46ULL, 0x000fe2000b800057ULL,
0x00000006185c7981ULL, 0x000562000c1e9500ULL, 0x000000021f1e7825ULL, 0x000fe200078e0014ULL,
0x000000451a00720cULL, 0x080fe40003f26070ULL, 0x00000004ff1b7819ULL, 0x000fe2000001161bULL,
0x0000000850567c36ULL, 0x000fe20008000000ULL, 0x000000455200720cULL, 0x000fe20003f06070ULL,
0x000000061e537981ULL, 0x000564000c1e9500ULL, 0x0000006047197211ULL, 0x004fc400078fe0ffULL,
0x00000005524d7e46ULL, 0x000fe4000b800057ULL, 0x000000ff1b1d7207ULL, 0x002fe20000800000ULL,
0x0000000219187825ULL, 0x000fe200078e0014ULL, 0x000000ff4d4d7207ULL, 0x000fe40000000000ULL,
0x00000062471f7211ULL, 0x000fe200078fe0ffULL, 0x00000001601b7824ULL, 0x000fe200078e021dULL,
0x00000005564f7e46ULL, 0x000fe2000b800057ULL, 0x0000000618497981ULL, 0x0002a2000c1e9500ULL,
0x000000011d4b7824ULL, 0x000fe200078e0262ULL, 0x000000455600720cULL, 0x000fe20003f26070ULL,
0x000000021f1c7825ULL, 0x000fe200078e0014ULL, 0x0000003046567812ULL, 0x000fc400078efcffULL,
0x00000004ff4f7819ULL, 0x000fe2000001164fULL, 0x000000021b1a7825ULL, 0x000fe200078e0014ULL,
0x000000604d197211ULL, 0x002fc600078fe0ffULL, 0x000000024b1e7825ULL, 0x100fe200078e0014ULL,
0x000000ff4f517207ULL, 0x000fe20000800000ULL, 0x000000061a4e7981ULL, 0x0002a4000c1e9500ULL,
0x0000000219187825ULL, 0x000fe400078e0014ULL, 0x000000061c4b7981ULL, 0x0002a4000c1e9500ULL,
0x0000000856647c36ULL, 0x000fe40008000000ULL, 0x000000061e547981ULL, 0x0002a2000c1e9500ULL,
0x0000000a56587c36ULL, 0x000fc60008000000ULL, 0x00000006184f7981ULL, 0x0002a4000c1e9500ULL,
0x00000001601b7824ULL, 0x002fe200078e0251ULL, 0x000000624d1d7211ULL, 0x000fe200078fe0ffULL,
0x00000001511f7824ULL, 0x000fe200078e0262ULL, 0x0000000564187e46ULL, 0x000fc6000b800057ULL,
0x000000021f1e7825ULL, 0x100fe200078e0014ULL, 0x000000455800720cULL, 0x080fe40003f06070ULL,
0x0000000558577e46ULL, 0x000fe2000b800057ULL, 0x000000021b1a7825ULL, 0x000fe200078e0014ULL,
0x000000456400720cULL, 0x000fe20003f26070ULL, 0x000000061e1e7981ULL, 0x000ea2000c1e9500ULL,
0x00000004ff187819ULL, 0x000fe20000011618ULL, 0x000000021d1c7825ULL, 0x000fe200078e0014ULL,
0x000000ff57577207ULL, 0x000fe20000000000ULL, 0x000000061a5a7981ULL, 0x0002a2000c1e9500ULL,
0x000000ff185b7207ULL, 0x000fc60000800000ULL, 0x000000061c517981ULL, 0x0002a2000c1e9500ULL,
0x0000006057197211ULL, 0x000fe200078fe0ffULL, 0x00000001601b7824ULL, 0x002fc800078e025bULL,
0x0000000219187825ULL, 0x000fc800078e0014ULL, 0x000000021b1a7825ULL, 0x000fe200078e0014ULL,
0x00000062571d7211ULL, 0x000fe200078fe0ffULL, 0x0000000618187981ULL, 0x0002a8000c1e9500ULL,
0x000000061a1b7981ULL, 0x0002a2000c1e9500ULL, 0x000000015b5b7824ULL, 0x000fe400078e0262ULL,
0x000000021d1c7825ULL, 0x000fc800078e0014ULL, 0x000000025b147825ULL, 0x000fe400078e0014ULL,
0x000000061c1c7981ULL, 0x000ea8000c1e9500ULL, 0x0000000614157981ULL, 0x0002a2000c1e9500ULL,
0xfffffff055607812ULL, 0x000fe200078ec0ffULL, 0x00000001ff1f7424ULL, 0x000fc800078e00ffULL,
0x0000000145197824ULL, 0x002fe200078e0260ULL, 0x0000000846607812ULL, 0x000fc600078efcffULL,
0x0000000148667824ULL, 0x000fe200078e0a19ULL, 0x0000000946627812ULL, 0x000fe200078efcffULL,
0x0000000a601a7c36ULL, 0x000fc60008000000ULL, 0x000000661f667219ULL, 0x040fe200000006ffULL,
0x0000000a62147c36ULL, 0x000fe40008000000ULL, 0x000000011a6a7824ULL, 0x100fe400078e0a19ULL,
0x00000001146c7824ULL, 0x000fe200078e0a19ULL, 0x00000018467c7812ULL, 0x000fe400078efcffULL,
0x0000006a1f6a7219ULL, 0x040fe400000006ffULL, 0x0000006c1f6c7219ULL, 0x000fc400000006ffULL,
0xfffffff047477812ULL, 0x000fe400078ec0ffULL, 0xfffffff0575b7812ULL, 0x000fe400078ec0ffULL,
0x00000019467a7812ULL, 0x000fca00078efcffULL, 0x0000000a7a1d7c36ULL, 0x000fe20008000000ULL,
0x0000002146707812ULL, 0x040fe400078efcffULL, 0x00000028466e7812ULL, 0x000fe200078efcffULL,
0x00000001455b7824ULL, 0x000fe400078e025bULL, 0x0000000a70767c36ULL, 0x000fe40008000000ULL,
0x0000000a6e747c36ULL, 0x000fe40008000000ULL, 0x00000001586b7824ULL, 0x000fca00078e0a5bULL,
0x0000006b1f6b7219ULL, 0x000fe400000006ffULL, 0x0000541059597816ULL, 0x008fe4000000005eULL,
0x00000001465e7812ULL, 0x000fe400078efcffULL, 0x0000005966ff7212ULL, 0x000fc6000780c0ffULL,
0x0000000a5e647c36ULL, 0x000fe20008000000ULL, 0x000000454800720cULL, 0x000fc60000701470ULL,
0x0000000164687824ULL, 0x000fe200078e0a19ULL, 0x000000454600720cULL, 0x000fc800007a1070ULL,
0x000000681f687219ULL, 0x000fe400000006ffULL, 0x000000596aff7212ULL, 0x080fe4000786c0ffULL,
0x0000005968ff7212ULL, 0x080fe4000782c0ffULL, 0x0000541053537816ULL, 0x020fe4000000005cULL,
0x000000596cff7212ULL, 0x000fe4000788c0ffULL, 0xff80000017177808ULL, 0x000fc40002800000ULL,
0xfffffff04d597812ULL, 0x000fe200078ec0ffULL, 0x00000001454d7824ULL, 0x040fe200078e0247ULL,
0x0000005366ff7212ULL, 0x080fe4000784c0ffULL, 0x0000005368ff7212ULL, 0x080fe4000780c0ffULL,
0x000000536aff7212ULL, 0x080fe400078cc0ffULL, 0x000000536cff7212ULL, 0x000fe200078ac0ffULL,
0x0000000a7c537c36ULL, 0x000fe20008000000ULL, 0x000000454800720cULL, 0x080fe20001741470ULL,
0x0000000145577824ULL, 0x000fe200078e0259ULL, 0x000000451a00720cULL, 0x080fe200037c1470ULL,
0x000000014a597824ULL, 0x100fe200078e0a4dULL, 0x000000451400720cULL, 0x000fe20002fa1470ULL,
0x00000001535f7824ULL, 0x000fe200078e0a4dULL, 0x0000001146197812ULL, 0x000fc400078efcffULL,
0x000000454600720cULL, 0x080fe40001741070ULL, 0x000000456000720cULL, 0x080fe400037c1070ULL,
0x000000456200720cULL, 0x000fe40002fa1070ULL, 0x000000591f597219ULL, 0x040fe400000006ffULL,
0x0000005f1f5f7219ULL, 0x000fe400000006ffULL, 0x00005410494e7816ULL, 0x004fc4000000004eULL,
0x000054104b547816ULL, 0x000fe20000000054ULL, 0x0000000a19557c36ULL, 0x000fe20008000000ULL,
0xff80000036367808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000004e59ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005459ff7212ULL, 0x000fc400078cc0ffULL, 0x000000545fff7212ULL, 0x000fe200078ac0ffULL,
0x00000001555d7824ULL, 0x100fe200078e0a4dULL, 0x000000456400720cULL, 0x0c0fe20000f21470ULL,
0x000000011d637824ULL, 0x000fe200078e0a4dULL, 0x000000456400720cULL, 0x080fe20000701470ULL,
0x0000000152617824ULL, 0x000fe200078e0a57ULL, 0x000000451a00720cULL, 0x080fe40001f61470ULL,
0x000000451400720cULL, 0x080fe40002781470ULL, 0x000000454a00720cULL, 0x000fc40001741470ULL,
0x000000454a00720cULL, 0x080fe400037c1470ULL, 0x000000455300720cULL, 0x080fe40002fa1470ULL,
0x00000029466c7812ULL, 0x000fe400078efcffULL, 0x000000455e00720cULL, 0x0c0fe40000f21070ULL,
0x000000455e00720cULL, 0x080fe40000701070ULL, 0x000000456000720cULL, 0x000fc40001f61070ULL,
0x000000456200720cULL, 0x080fe40002781070ULL, 0x000000454c00720cULL, 0x0c0fe40001741070ULL,
0x000000454c00720cULL, 0x080fe400037c1070ULL, 0x000000457c00720cULL, 0x000fe40002fa1070ULL,
0x0000005d1f5d7219ULL, 0x040fe400000006ffULL, 0x000000631f637219ULL, 0x000fc400000006ffULL,
0x000000611f617219ULL, 0x000fe400000006ffULL, 0x000054104f5a7816ULL, 0x000fe4000000005aULL,
0x00005410511e7816ULL, 0x000fe2000000001eULL, 0x0000000a6c727c36ULL, 0x000fe20008000000ULL,
0xff80000035357808ULL, 0x000fe40000800000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000030307808ULL, 0x000fc40001800000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x0000004e5dff7212ULL, 0x080fe4000782c0ffULL,
0x0000004e5fff7212ULL, 0x000fc4000780c0ffULL, 0x0000004e63ff7212ULL, 0x000fe4000786c0ffULL,
0x000000545dff7212ULL, 0x080fe4000788c0ffULL, 0x0000005463ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005a61ff7212ULL, 0x040fe400078cc0ffULL, 0x0000001e61ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000176657824ULL, 0x100fe200078e0a57ULL, 0x000000455500720cULL, 0x0c0fe20000f21470ULL,
0x0000000174677824ULL, 0x100fe200078e0a57ULL, 0x000000455500720cULL, 0x080fe20002781470ULL,
0x0000000172697824ULL, 0x000fe200078e0a57ULL, 0x000000455300720cULL, 0x000fc40000701470ULL,
0x000000451d00720cULL, 0x0c0fe40001f61470ULL, 0x000000451d00720cULL, 0x080fe40001741470ULL,
0x000000455200720cULL, 0x0c0fe400037c1470ULL, 0x000000455200720cULL, 0x000fe40002fa1470ULL,
0x0000003146687812ULL, 0x040fe400078efcffULL, 0x0000003846667812ULL, 0x000fc400078efcffULL,
0x00000039465c7812ULL, 0x000fe400078efcffULL, 0x000000451900720cULL, 0x0c0fe40000f21070ULL,
0x000000451900720cULL, 0x080fe40002781070ULL, 0x000000457c00720cULL, 0x080fe40000701070ULL,
0x000000457a00720cULL, 0x0c0fe40001f61070ULL, 0x000000457a00720cULL, 0x000fc40001741070ULL,
0x000000455000720cULL, 0x0c0fe400037c1070ULL, 0x000000455000720cULL, 0x000fe40002fa1070ULL,
0x000000651f657219ULL, 0x040fe400000006ffULL, 0x000000671f677219ULL, 0x040fe400000006ffULL,
0x000000691f697219ULL, 0x000fe400000006ffULL, 0x0000541018187816ULL, 0x000fe2000000001bULL,
0x0000000a686a7c36ULL, 0x000fe20008000000ULL, 0xff8000002d2d7808ULL, 0x000fe20000800000ULL,
0x0000000a66787c36ULL, 0x000fe20008000000ULL, 0xff8000002f2f7808ULL, 0x000fe20002000000ULL,
0x0000000a5c477c36ULL, 0x000fe20008000000ULL, 0xff80000028287808ULL, 0x000fc40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000016167808ULL, 0x000fe40003000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0x0000005a65ff7212ULL, 0x080fe4000782c0ffULL, 0x0000005a67ff7212ULL, 0x000fc4000788c0ffULL,
0x0000005a69ff7212ULL, 0x000fe4000780c0ffULL, 0x0000001e65ff7212ULL, 0x080fe4000786c0ffULL,
0x0000001e67ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001e69ff7212ULL, 0x000fe400078cc0ffULL,
0x000000186bff7212ULL, 0x000fe200078ac0ffULL, 0x000000016a577824ULL, 0x100fe200078e0a5bULL,
0x000000457600720cULL, 0x080fe20000f21470ULL, 0x00000001784d7824ULL, 0x100fe200078e0a5bULL,
0x000000457600720cULL, 0x080fe20001f61470ULL, 0x00000001475b7824ULL, 0x000fe200078e0a5bULL,
0x000000457400720cULL, 0x000fc40002781470ULL, 0x000000457400720cULL, 0x080fe40001741470ULL,
0x000000457200720cULL, 0x0c0fe40000701470ULL, 0x000000457200720cULL, 0x080fe400037c1470ULL,
0x000000455800720cULL, 0x080fe40002fa1470ULL, 0x000000457000720cULL, 0x0c0fe40000f21070ULL,
0x000000457000720cULL, 0x000fc40001f61070ULL, 0x000000456e00720cULL, 0x0c0fe40002781070ULL,
0x000000456e00720cULL, 0x080fe40001741070ULL, 0x000000456c00720cULL, 0x0c0fe40000701070ULL,
0x000000456c00720cULL, 0x080fe400037c1070ULL, 0x000000455600720cULL, 0x000fe40002fa1070ULL,
0x000000571f577219ULL, 0x000fc400000006ffULL, 0x0000004d1f4d7219ULL, 0x040fe400000006ffULL,
0x0000005b1f5b7219ULL, 0x000fe400000006ffULL, 0x000054101c1c7816ULL, 0x000fe40000000015ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff8000003e3e7808ULL, 0x000fc40002000000ULL, 0xff8000003d3d7808ULL, 0x000fe40001000000ULL,
0xff80000040407808ULL, 0x000fe40000000000ULL, 0xff80000025257808ULL, 0x000fe40003000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x0000001857ff7212ULL, 0x080fe4000782c0ffULL,
0x000000184dff7212ULL, 0x000fc4000786c0ffULL, 0x000000185bff7212ULL, 0x000fe4000788c0ffULL,
0x0000001c6bff7212ULL, 0x080fe4000784c0ffULL, 0x0000001c57ff7212ULL, 0x080fe4000780c0ffULL,
0x0000001c4dff7212ULL, 0x080fe400078cc0ffULL, 0x0000001c5bff7212ULL, 0x000fe400078ac0ffULL,
0x000000455800720cULL, 0x000fc40001741470ULL, 0x000000456a00720cULL, 0x0c0fe40000f21470ULL,
0x000000456a00720cULL, 0x080fe40000701470ULL, 0x000000457800720cULL, 0x0c0fe40001f61470ULL,
0x000000457800720cULL, 0x080fe400037c1470ULL, 0x000000454700720cULL, 0x0c0fe40002781470ULL,
0x000000454700720cULL, 0x000fc40002fa1470ULL, 0x000000455600720cULL, 0x080fe40001741070ULL,
0x000000456800720cULL, 0x0c0fe40000f21070ULL, 0x000000456800720cULL, 0x080fe40000701070ULL,
0x000000456600720cULL, 0x0c0fe40001f61070ULL, 0x000000456600720cULL, 0x080fe400037c1070ULL,
0x000000455c00720cULL, 0x000fc40002781070ULL, 0x000000455c00720cULL, 0x000fe40002fa1070ULL,
0xff80000042427808ULL, 0x000fe40000800000ULL, 0xff80000043437808ULL, 0x000fe40001800000ULL,
0xff80000044447808ULL, 0x000fe40002000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fc40000000000ULL, 0xff80000020207808ULL, 0x000fe40003000000ULL,
0xff80000023237808ULL, 0x000fce0002800000ULL, 0x000000171000720bULL, 0x004fe20003f1e000ULL,
0x3f80000000097882ULL, 0x000fe20000000000ULL, 0x000000010f0f7836ULL, 0x000fe40000000000ULL,
0x0000001017107208ULL, 0x000fc80004000000ULL, 0x000000351000720bULL, 0x000fc80003f1e000ULL,
0x0000001035157208ULL, 0x000fc80004000000ULL, 0x000000301500720bULL, 0x000fc80003f1e000ULL,
0x0000001530107208ULL, 0x000fc80004000000ULL, 0x000000311000720bULL, 0x000fc80003f1e000ULL,
0x0000001031157208ULL, 0x000fc80004000000ULL, 0x0000002c1500720bULL, 0x000fc80003f1e000ULL,
0x000000152c107208ULL, 0x000fc80004000000ULL, 0x0000002d1000720bULL, 0x000fc80003f1e000ULL,
0x000000102d157208ULL, 0x000fc80004000000ULL, 0x000000281500720bULL, 0x000fc80003f1e000ULL,
0x0000001528107208ULL, 0x000fc80004000000ULL, 0x000000291000720bULL, 0x000fc80003f1e000ULL,
0x0000001029157208ULL, 0x000fc80004000000ULL, 0x000000161500720bULL, 0x000fc80003f1e000ULL,
0x0000001516157208ULL, 0x000fc80004000000ULL, 0x000000341500720bULL, 0x000fc80003f1e000ULL,
0x0000001534157208ULL, 0x000fc80004000000ULL, 0x0000003e1500720bULL, 0x000fc80003f1e000ULL,
0x000000153e157208ULL, 0x000fe40004000000ULL, 0x000000361100720bULL, 0x000fe40003f1e000ULL,
0x000000401500720bULL, 0x000fe40003f3e000ULL, 0x0000001136107208ULL, 0x000fe40004000000ULL,
0x0000001540147208ULL, 0x000fe40004800000ULL, 0x000000371000720bULL, 0x000fc40003f1e000ULL,
0x000000411400720bULL, 0x000fe40003f3e000ULL, 0x0000001037117208ULL, 0x000fe40004000000ULL,
0x0000001441157208ULL, 0x000fe40004800000ULL, 0x000000321100720bULL, 0x000fe40003f1e000ULL,
0x000000421500720bULL, 0x000fe40003f3e000ULL, 0x0000001132107208ULL, 0x000fc40004000000ULL,
0x0000001542147208ULL, 0x000fe40004800000ULL, 0x000000331000720bULL, 0x000fe40003f1e000ULL,
0x000000431400720bULL, 0x000fe40003f3e000ULL, 0x0000001033117208ULL, 0x000fe40004000000ULL,
0x0000001443157208ULL, 0x000fe40004800000ULL, 0x0000002e1100720bULL, 0x000fc40003f1e000ULL,
0x000000441500720bULL, 0x000fe40003f3e000ULL, 0x000000112e107208ULL, 0x000fe40004000000ULL,
0x0000001544157208ULL, 0x000fe40004800000ULL, 0x0000002f1000720bULL, 0x000fc60003f1e000ULL,
0x0c401f0015147f89ULL, 0x000ea200000e0000ULL, 0x000000102f117208ULL, 0x000fc80004000000ULL,
0x0000002a1100720bULL, 0x000fc80003f1e000ULL, 0x000000112a107208ULL, 0x000fc80004000000ULL,
0x0000002b1000720bULL, 0x000fc80003f1e000ULL, 0x000000102b117208ULL, 0x000fc80004000000ULL,
0x000000261100720bULL, 0x000fe40003f1e000ULL, 0x000000141500720bULL, 0x004fe40003f3e000ULL,
0x0000001126107208ULL, 0x000fe40004000000ULL, 0x0000001514187208ULL, 0x000fe40004800000ULL,
0x000000271000720bULL, 0x000fc60003f1e000ULL, 0x0c201f0018157f89ULL, 0x000ea200000e0000ULL,
0x0000001027107208ULL, 0x000fc80004000000ULL, 0x0000003d1000720bULL, 0x000fc80003f1e000ULL,
0x000000103d107208ULL, 0x000fc80004000000ULL, 0x000000251000720bULL, 0x000fc80003f1e000ULL,
0x0000001025117208ULL, 0x000fc80004000000ULL, 0x000000221100720bULL, 0x000fe40003f1e000ULL,
0x000000151800720bULL, 0x004fe40003f3e000ULL, 0x0000001122147208ULL, 0x000fe40004000000ULL,
0x0000001815107208ULL, 0x000fe40004800000ULL, 0x000000211400720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b10157820ULL, 0x000fe20000410000ULL, 0x0000001421117208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010815ULL, 0x000000201100720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010815ULL,
0x0000003000197308ULL, 0x0005e20000000800ULL, 0x0000001120147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b281b7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010815ULL, 0x000000231400720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010815ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x0000001423147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3e307823ULL, 0x104fe20000010815ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b16287823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010815ULL,
0x0c401f0014117f89ULL, 0x000ea400000e0000ULL, 0x0000003500187308ULL, 0x000ff00000000800ULL,
0x00000031001a7308ULL, 0x0007700000000800ULL, 0x0000001b001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b43317823ULL, 0x008fe20000010815ULL, 0x000000111400720bULL, 0x004fcc0003f1e000ULL,
0x0000002c001c7308ULL, 0x0005e20000000800ULL, 0x000000191a16723eULL, 0x022fe400000010ffULL,
0x0000001411117208ULL, 0x000fca0004000000ULL, 0x0c201f0011147f89ULL, 0x000e6200000e0000ULL,
0x00000029001f7308ULL, 0x0007620000000800ULL, 0x3fb8aa3b422c7823ULL, 0x004fce0000010815ULL,
0x0000002d001d7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b41297823ULL, 0x108fe20000010815ULL,
0x3fb8aa3b44157823ULL, 0x000fe20000010815ULL, 0x0000001e1f1e723eULL, 0x020fca00000010ffULL,
0x00000034002d7308ULL, 0x000fe20000000800ULL, 0x000000141100720bULL, 0x002fce0003f1e000ULL,
0x0000001500347308ULL, 0x000fe20000000800ULL, 0x0000001c1d1c723eULL, 0x004fe400000010ffULL,
0x0000001114117208ULL, 0x000fe40004000000ULL, 0x000000171814723eULL, 0x000fc600000010ffULL,
0x3fb8aa3b113e7820ULL, 0x000fe20000410000ULL, 0x0000004000357308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b261b7823ULL, 0x100fe2000001083eULL, 0x00000009ff267e24ULL, 0x000fe2000f8e00ffULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b27417823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001083eULL,
0x3f8000002626783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b3d3d7823ULL, 0x000fe2000001083eULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000ffff277224ULL, 0x000fce00078e0026ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x000000363715723eULL, 0x002fce00000010ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x000000ffff367224ULL, 0x100fe400078e0026ULL,
0x000000ffff377224ULL, 0x000fca00078e0026ULL, 0x0000001b00407308ULL, 0x0005e20000000800ULL,
0x000000323317723eULL, 0x002fce00000010ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000ffff337224ULL, 0x000fe200078e0026ULL, 0x000000261418723cULL, 0x004fec00000418ffULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b25277823ULL, 0x000fe4000001083eULL,
0x0c401f0012257f89ULL, 0x000eaa00000e0000ULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x0000002e2f1d723eULL, 0x002fce00000010ffULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b222e7823ULL, 0x000fce000001083eULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x0000002a2b1f723eULL, 0x002fce00000010ffULL, 0x0000002700327308ULL, 0x0002e20000000800ULL,
0x0c401f00132a7f89ULL, 0x000f6200000e0000ULL, 0x3fb8aa3b202b7823ULL, 0x100fe2000001083eULL,
0x000000251200720bULL, 0x004fe20003f1e000ULL, 0x000000361c18723cULL, 0x000fe60000041818ULL,
0x0000001225127208ULL, 0x000fe20004000000ULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b21277823ULL, 0x102fe2000001083eULL, 0x3fb8aa3b233e7823ULL, 0x000fe2000001083eULL,
0x00000003ff257819ULL, 0x000fc40000011606ULL, 0x0000003d3223723eULL, 0x008fc600000010ffULL,
0x0000003000307308ULL, 0x000e620000000800ULL, 0x000000ffff327224ULL, 0x000fe200078e0026ULL,
0x0000000325257812ULL, 0x000fe400078ec0ffULL, 0x000000282d20723eULL, 0x004fc800000010ffULL,
0x0000004100417308ULL, 0x000ea20000000800ULL, 0x0000002a1300720bULL, 0x020fc80003f3e000ULL,
0x000000132a137208ULL, 0x000fe40004800000ULL, 0x000000303522723eULL, 0x002fe200000010ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x000000404121723eULL, 0x004fce00000010ffULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x000000322018723cULL, 0x000fee0000041818ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000292c28723eULL, 0x002fce00000010ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0xfffffff8ff2c7812ULL, 0x000fe200078ee23fULL,
0x000000ffff3f7224ULL, 0x000fc800078e0026ULL, 0x000000082c2d7824ULL, 0x040fe400078e00ffULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x000000082c327824ULL, 0x000fe200078e00ffULL,
0x0000002e2729723eULL, 0x002fcc00000010ffULL, 0x0000003e003e7308ULL, 0x000e620000000800ULL,
0x000000082c2e7836ULL, 0x000fe40000000000ULL, 0x00000001252c7824ULL, 0x040fe400078e022cULL,
0x00000001252f7824ULL, 0x000fe400078e022eULL, 0x0c201f0012257f89ULL, 0x000ea200000e0000ULL,
0x0000003100317308ULL, 0x000ee20000000800ULL, 0x000000082e367824ULL, 0x000fe400078e00ffULL,
0x000008003c277824ULL, 0x000fc400078e020dULL, 0x0000000c2c307836ULL, 0x000fe20000000000ULL,
0x0000002b3e2b723eULL, 0x002fe200000010ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0026ULL,
0xfffffff82d267812ULL, 0x000fe200078ee22cULL, 0x000000042c2d7836ULL, 0x000fe40000000000ULL,
0x0001100027277836ULL, 0x000fe20000000000ULL, 0x00000031342a723eULL, 0x008fe200000010ffULL,
0x000000082e317824ULL, 0x000fe200078e00ffULL, 0x0c201f0013347f89ULL, 0x000e6200000e0000ULL,
0xfffffff8322c7812ULL, 0x000fe200078ee22dULL, 0x0000001026267824ULL, 0x000fe200078e0227ULL,
0xfffffff8362e7812ULL, 0x000fe200078ee22fULL, 0x000000ffff2d7224ULL, 0x000fe200078e0016ULL,
0x0000003e2818723cULL, 0x000fe20000041818ULL, 0x000000251200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e001eULL, 0xfffffff831367812ULL, 0x000fe200078ee230ULL,
0x000000ffff307224ULL, 0x000fe200078e0020ULL, 0x0000001225127208ULL, 0x000fe20004000000ULL,
0x000000ffff317224ULL, 0x000fe200078e0022ULL, 0x0000000306ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff327224ULL, 0x000fc400078e0028ULL, 0x000000ffff337224ULL, 0x000fe400078e002aULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x0000001036367824ULL, 0x000fe400078e0227ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0023ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0029ULL,
0x000000341300720bULL, 0x002fe20003f3e000ULL, 0x000000102c197824ULL, 0x000fc400078e0227ULL,
0x000000102e1b7824ULL, 0x000fe200078e0227ULL, 0x0000001334137208ULL, 0x000fe20004800000ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0014ULL, 0x000000ffff2e7224ULL, 0x000fe400078e001cULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff157224ULL, 0x000fe200078e0017ULL,
0x0000002c26007844ULL, 0x000fe20000000200ULL, 0x000000ffff177224ULL, 0x000fc400078e001fULL,
0x000000ffff1c7224ULL, 0x000fe200078e0021ULL, 0x0000003019007844ULL, 0x0003e20000000200ULL,
0x000000ffff1f7224ULL, 0x000fe400078e002bULL, 0x000000ffff227224ULL, 0x000fe200078e0018ULL,
0x000000141b007844ULL, 0x0005e20000000200ULL, 0x000000ffff237224ULL, 0x000fe400078e001aULL,
0x000000ffff207224ULL, 0x000fe200078e003bULL, 0x0000001c36007844ULL, 0x0005e80000000200ULL,
0x0170001024008388ULL, 0x0005e80000000c00ULL, 0x0172002224008388ULL, 0x0005e20000000a00ULL,
0x000000380f00720cULL, 0x000fe20003f06070ULL, 0x00000001ff197424ULL, 0x002fc800078e00ffULL,
0x017608190cff79a7ULL, 0x0005e2000850003fULL, 0x017610190cff79a7ULL, 0x0005e2000850003fULL,
0x017618190cff79a7ULL, 0x0005e2000850003fULL, 0x017620190cff79a7ULL, 0x0005ea000850003fULL,
0xffffffa400e88947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000054007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000005400008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff54ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000054027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffeac02a07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x000000000000057fULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000700ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000958ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a38ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a8cULL,
0x0000000000000660ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001138ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000015280ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016400ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016450ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000016450ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x0000000000016a40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000016a40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001138ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015280ULL, 0x0000000000015280ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016400ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000016450ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_90_cubin_len = 93072;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
