/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001aab0ULL, 0x000000000001a730ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL,
0x2400000000000000ULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b00010000020cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000299ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b000100000383ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000003d1ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000042cULL, 0x00000000000190c0ULL,
0x0000000000000240ULL, 0x00040003000004a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000019300ULL, 0x000d0003000004d2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000190c000000000ULL,
0x0001080400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x000190c000000000ULL, 0x0000024000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000b9ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002d000dc2804ULL, 0x00000960000003c0ULL,
0x00002c4000002bd0ULL, 0x00002e5000002d20ULL, 0x000030c000002f80ULL, 0x0000364000003630ULL,
0x0000366000003650ULL, 0x00005d1000005c80ULL, 0x00005f2000005df0ULL, 0x0000619000006050ULL,
0x0000665000006640ULL, 0x0000667000006660ULL, 0x00008c1000008b80ULL, 0x00008e2000008cf0ULL,
0x0000909000008f50ULL, 0x0000955000009540ULL, 0x0000957000009560ULL, 0x0000bb600000baf0ULL,
0x0000bd800000bc50ULL, 0x0000bff00000beb0ULL, 0x0000c5100000c500ULL, 0x0000c5300000c520ULL,
0x0000dfa00000df90ULL, 0x0000dfc00000dfb0ULL, 0x000178c000017810ULL, 0x00017ca000017ba0ULL,
0x000181b0000180a0ULL, 0x000185f000018490ULL, 0x0000047004303904ULL, 0x0001a600000000ffULL,
0x0000055000040100ULL, 0x0001a60800000000ULL, 0x00000660003f0100ULL, 0x0001a68800000000ULL,
0x00000790003f0100ULL, 0x0001a6a800000005ULL, 0x000008a0003f0100ULL, 0x0001a6c800000004ULL,
0x00001000003f0100ULL, 0x0001a600000000ffULL, 0x00001180000a0107ULL, 0x0001a68800000000ULL,
0x00001be0003f0101ULL, 0x00000000000000ffULL, 0x00001c4000040107ULL, 0x00000000000000ffULL,
0x00001cc000040101ULL, 0x0000002000000002ULL, 0x00001e10003f0101ULL, 0x0001a6c80000003fULL,
0x00001fa0000a0109ULL, 0x0001a6c800000041ULL, 0x00002870003f0109ULL, 0x0001a6b000000040ULL,
0x00002940000a0107ULL, 0x0001a6b000000042ULL, 0x00002950003f0101ULL, 0x0001a60800000080ULL,
0x00002970003f0101ULL, 0x0001a60800000080ULL, 0x00002ae0003f0109ULL, 0x0001a60800000080ULL,
0x00003250003f0109ULL, 0x0001a6a800000042ULL, 0x000033c0003f0109ULL, 0x0001a6a800000042ULL,
0x00004f90003f0109ULL, 0x0001a6c80000003cULL, 0x00004fb0003f0101ULL, 0x0001a68800000081ULL,
0x00005020000a0101ULL, 0x0000000000000006ULL, 0x00005190003f0109ULL, 0x0000000000000006ULL,
0x00005990003f0109ULL, 0x0001a6a80000007aULL, 0x00005a30000a0107ULL, 0x0001a6a800000084ULL,
0x00005a40003f0101ULL, 0x0001a62800000080ULL, 0x00005a60003f0101ULL, 0x0001a62800000080ULL,
0x00005bd0003f0109ULL, 0x0001a62800000080ULL, 0x00006360003f0109ULL, 0x0001a6b000000037ULL,
0x000064e0000a0109ULL, 0x0001a6b00000003fULL, 0x00007e70003f0109ULL, 0x0001a6c80000003cULL,
0x00007e90003f0101ULL, 0x0001a6900000003eULL, 0x00007f10000a0101ULL, 0x0000000000000006ULL,
0x00008080003f0109ULL, 0x0000000000000006ULL, 0x000088b0003f0109ULL, 0x0001a6b000000036ULL,
0x00008930000a0107ULL, 0x0001a6b000000086ULL, 0x00008940003f0101ULL, 0x0001a64800000080ULL,
0x00008960003f0101ULL, 0x0001a64800000080ULL, 0x00008ad0003f0109ULL, 0x0001a64800000080ULL,
0x00009260003f0109ULL, 0x0001a6a800000037ULL, 0x000093e0000a0109ULL, 0x0001a6a80000003fULL,
0x0000ad80003f0109ULL, 0x0001a6c800000041ULL, 0x0000adb0003f0101ULL, 0x0001a6980000003eULL,
0x0000ae10000a0101ULL, 0x0001a6c800000041ULL, 0x0000afa0003f0109ULL, 0x0001a6c800000041ULL,
0x0000b860003f0109ULL, 0x0001a6a800000080ULL, 0x0000b8b0000a0107ULL, 0x0001a6a800000034ULL,
0x0000b8c0003f0101ULL, 0x0001a66800000009ULL, 0x0000b8f0003f0101ULL, 0x0001a66800000009ULL,
0x0000ba60003f0109ULL, 0x0001a66800000009ULL, 0x0000c1c0003f0109ULL, 0x0001a6b000000037ULL,
0x0000c340000a0109ULL, 0x0001a6b00000003fULL, 0x0000dd90003f0109ULL, 0x0000000000000006ULL,
0x0000dde0003f0101ULL, 0x0001a6a000000006ULL, 0x0000fb10003f0101ULL, 0x0001a600000000ffULL,
0x00011410000a0101ULL, 0x0001a600000000ffULL, 0x00011580000a0109ULL, 0x0001a600000000ffULL,
0x000118c0000a0109ULL, 0x0001a600000000ffULL, 0x000118e0000a0101ULL, 0x0001a600000000ffULL,
0x00011a50000a0109ULL, 0x0001a600000000ffULL, 0x000150e0000a0109ULL, 0x0001a68800000007ULL,
0x000154b0003f0101ULL, 0x0001a68800000007ULL, 0x00015620003f0109ULL, 0x0001a68800000007ULL,
0x00019060003f0109ULL, 0x0001a6080000006aULL, 0x00019070003f0101ULL, 0x0001a6100000006aULL,
0x00019080003f0101ULL, 0x0001a6180000006aULL, 0x00019090003f0101ULL, 0x0001a6200000006aULL,
0x00053803003f0101ULL, 0x0000eed000301c04ULL, 0x0000f0e00000ef30ULL, 0x0000f3a00000f240ULL,
0x0000f6600000f500ULL, 0x0000f9500000f7c0ULL, 0x00011a800000fa50ULL, 0x000c0504000190b0ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001600080a04ULL,
0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001500000002ULL, 0x00000000000190c0ULL,
0x0000000000000044ULL, 0x0000001500000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001500000002ULL, 0x0000000000000000ULL, 0x000000000001a700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000097919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000000a7919ULL, 0x000eea0000002200ULL, 0x00000400ff067b82ULL, 0x000f220000000800ULL,
0x0000000000717919ULL, 0x000f620000002100ULL, 0x0000010000047ab9ULL, 0x000fcc0000000800ULL,
0x00008600ff137b82ULL, 0x000ee20000000800ULL, 0x0000000300007306ULL, 0x004ea20000209000ULL,
0x000000ff0300720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00047836ULL, 0x004fcc0000000000ULL, 0x0000000400057305ULL, 0x0004e4000021f000ULL,
0x000000ffff047224ULL, 0x004fe400078e00ffULL, 0x000000ffff087224ULL, 0x00afc800078e0a05ULL,
0x0000000308077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002600ULL,
0x0000000705057227ULL, 0x000fcc00078e0004ULL, 0x0000000605777227ULL, 0x010fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a77ULL, 0x0000000503007224ULL, 0x000fca00078e0206ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a03ULL,
0x0000000177770836ULL, 0x000fc60000000000ULL, 0x000000030000720cULL, 0x000fda0003f26070ULL,
0x0000000177771836ULL, 0x000fe20000000000ULL, 0x00000003ff77a212ULL, 0x000fc800078e33ffULL,
0x0000007700007306ULL, 0x000ea20000209000ULL, 0x000000ff7700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00047836ULL, 0x004fe40000000000ULL,
0x0000000409007c24ULL, 0x000fe2000f8e020aULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x0004e4000021f000ULL, 0x000000ffff047224ULL, 0x004fe400078e00ffULL,
0x0000000577067224ULL, 0x008fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x0000000705057227ULL, 0x000fe400078e0004ULL, 0x0000000000077919ULL, 0x000ea40000002700ULL,
0x0000000400047c24ULL, 0x120fe2000f8e0271ULL, 0x00000005ff717819ULL, 0x000fe20000011671ULL,
0x0000000805587227ULL, 0x002fc600078e00ffULL, 0x0000007f0400780cULL, 0x040fe20003f64070ULL,
0x000000ffff057224ULL, 0x000fe200078e0a58ULL, 0x00001fff71717589ULL, 0x000e6200000e0000ULL,
0x000000030400780cULL, 0x000fe40003f84070ULL, 0x0000000577007224ULL, 0x000fca00078e0208ULL,
0x000000770000720cULL, 0x000fc60003f06070ULL, 0x000000000006b919ULL, 0x000ee20000008800ULL,
0x000004000005b802ULL, 0x000fd20000000f00ULL, 0x0000000100000824ULL, 0x000fe400078e0a77ULL,
0x0000000158580836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000770000720cULL, 0x000fda0003f26070ULL, 0x0000000158581836ULL, 0x000fe20000000000ULL,
0x00000077ff58a212ULL, 0x000fe400078e33ffULL, 0x0000000f0400780cULL, 0x000fe40003f24070ULL,
0x000006540605b816ULL, 0x008fe20000000005ULL, 0x000000ffff007224ULL, 0x000fe200078e0a58ULL,
0x00001fff09067589ULL, 0x00026200000e0000ULL, 0x000000010400780cULL, 0x000fe40003f44070ULL,
0x0000000077777224ULL, 0x000fc400078e0208ULL, 0xff317217ff08b424ULL, 0x000fe400078e00ffULL,
0x000000040405b824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x006fec0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x01a60006043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01a60804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01a68804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400080500b388ULL, 0x0005e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000002077007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x008fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x004fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01a6a804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01a6c804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x0000001302057219ULL, 0x084fe200000006ffULL,
0x0000000207027224ULL, 0x000fe200078e02ffULL, 0x00000013030b7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000500720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002005757446ULL, 0x000fe20003800004ULL,
0x0000000406047824ULL, 0x002fe200078e0271ULL, 0x0000001358767219ULL, 0x000fc400000006ffULL,
0x000000ff75757207ULL, 0x000fe20000000000ULL, 0x0000000404047824ULL, 0x000fe400078e00ffULL,
0x0000000b02027224ULL, 0x000fe200078e0276ULL, 0x000000207500780cULL, 0x000fda0003f05270ULL,
0x0000000000c88947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0xffffffffff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000475057248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ea20000008800ULL,
0x00000400000d7802ULL, 0x000fe40000000f00ULL, 0x000000130c097219ULL, 0x000fe200000006ffULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x00000004ff087819ULL, 0x002fe4000001160aULL,
0x0000065410127816ULL, 0x004fc6000000000dULL, 0x00000002080e7836ULL, 0x000fe20000000000ULL,
0x000000050800720cULL, 0x080fe20003f06070ULL, 0x00000001040f7824ULL, 0x000fe200078e0208ULL,
0x00000000120a72caULL, 0x000fe200000e0000ULL, 0x0000000104117824ULL, 0x000fe200078e020eULL,
0x000000050e00720cULL, 0x000fe20003f26070ULL, 0x00000001000c7824ULL, 0x040fe400078e020fULL,
0x0000000100047824ULL, 0x000fe400078e0211ULL, 0x00000001110e7824ULL, 0x040fe200078e020aULL,
0x000000090c0d7212ULL, 0x080fe200078e30ffULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0x0000000904097212ULL, 0x000fc400078e30ffULL, 0x00000013ff0c7219ULL, 0x080fe2000001160cULL,
0x00000001020d7824ULL, 0x040fe200078e020dULL, 0x00000013ff107219ULL, 0x000fe20000011604ULL,
0x0000000102097824ULL, 0x000fe200078e0209ULL, 0xfffffff0110e7812ULL, 0x000fe200078ee20eULL,
0x0000000b0c087224ULL, 0x080fe400078e020dULL, 0x000000100a047824ULL, 0x000fe400078e00ffULL,
0x0000000b100c7224ULL, 0x000fe400078e0209ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x000000f004057812ULL, 0x000fc600078ec0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000508087212ULL, 0x000fc600078efcffULL, 0x000000010f027824ULL, 0x040fe200078e020aULL,
0x000000050c057212ULL, 0x000fe200078efcffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000408087c10ULL, 0x000fe4000ff5e0ffULL, 0x00000004050c7c10ULL, 0x000fe4000ff7e0ffULL,
0xfffffff00f027812ULL, 0x000fe400078ee202ULL, 0x0000000509097c10ULL, 0x000fe400097fe4ffULL,
0x0000000a02057c11ULL, 0x000fc4000f8e20ffULL, 0x000000050d0d7c10ULL, 0x000fe40009ffe4ffULL,
0x0000000a0e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000c101c46ULL, 0x000000000c0f7faeULL, 0x0003e2000c901c46ULL,
0x0000000000ac7947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0x00000400000c7802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000117919ULL, 0x000ea20000008800ULL, 0x000000040a057211ULL, 0x002fe200078fe0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00000654110c7816ULL, 0x004fc6000000000cULL,
0x00000002050f7836ULL, 0x000fe20000000000ULL, 0x00000013040d7219ULL, 0x000fe200000006ffULL,
0x0000000100047824ULL, 0x000fe200078e0205ULL, 0x000000000c0a72caULL, 0x000fe200000e0000ULL,
0x0000000100087824ULL, 0x000fe400078e020fULL, 0x000000100f0e7824ULL, 0x000fe200078e00ffULL,
0x0000000d04097212ULL, 0x080fe400078e30ffULL, 0x0000000d080d7212ULL, 0x000fe400078e30ffULL,
0x00000013ff047219ULL, 0x080fe20000011604ULL, 0x0000000102097824ULL, 0x040fe200078e0209ULL,
0x00000013ff087219ULL, 0x000fe20000011608ULL, 0x00000001020d7824ULL, 0x000fc400078e020dULL,
0x0000000b04097224ULL, 0x080fe400078e0209ULL, 0x000000100a047824ULL, 0x000fe400078e00ffULL,
0x0000000b080d7224ULL, 0x000fe400078e020dULL, 0x0000010009087825ULL, 0x000fe200078e00ffULL,
0x000000f004117812ULL, 0x000fc600078ec0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e00ffULL,
0x0000001108087212ULL, 0x000fc600078efcffULL, 0x0000000105027824ULL, 0x140fe200078e020aULL,
0x000000110c0c7212ULL, 0x000fe200078efcffULL, 0x0000001005137824ULL, 0x000fe200078e00ffULL,
0x0000000408087c10ULL, 0x000fe2000ff1e0ffULL, 0x000000010f057824ULL, 0x000fe200078e020aULL,
0x000000040c0c7c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff013027812ULL, 0x000fe400078ee202ULL,
0xfffffff00e0e7812ULL, 0x000fe400078ee205ULL, 0x0000000509097c10ULL, 0x000fc400087fe4ffULL,
0x0000000a02057c11ULL, 0x000fe4000f8e20ffULL, 0x000000050d0d7c10ULL, 0x000fe40008ffe4ffULL,
0x0000000a0e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000c0f7faeULL, 0x0003e4000b901c46ULL,
0x0001a6000a047890ULL, 0x000fe2000fffe03fULL, 0x00009200ff087b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000407087825ULL, 0x002fe200078e0008ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000608747981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000003f74707836ULL, 0x004fe40000000000ULL,
0x000000ff74057836ULL, 0x000fc60000000000ULL, 0x00000006ff707819ULL, 0x000fe40000011670ULL,
0x00000008ff6b7819ULL, 0x000fca0000011605ULL, 0x000000e800688947ULL, 0x000fea0003800000ULL,
0x00000002ff5a7819ULL, 0x000fe20000011671ULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0x03ffffff5a597812ULL, 0x000fc800078ec0ffULL,
0x000000705900720cULL, 0x000fda0003f06070ULL, 0x00009400ff0d8b82ULL, 0x000e620000000800ULL,
0x0000000207008824ULL, 0x000fce00078e00ffULL, 0x00009000ff088b82ULL, 0x000ea20000000a00ULL,
0x0000000d00008224ULL, 0x002fc800078e020dULL, 0x00000001590d8824ULL, 0x000fe200078e0200ULL,
0x0000000a71007c11ULL, 0x000fc6000f8e18ffULL, 0x000000040d088825ULL, 0x004fe200078e0008ULL,
0x01a6880f00ff79a7ULL, 0x0003e8000850003fULL, 0x0000000608028981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x0000004058587824ULL, 0x000fe200078e00ffULL,
0x00000001ff6a7819ULL, 0x000fe40000011671ULL, 0x0000000171057812ULL, 0x000fc600078ec0ffULL,
0x000000206a5b7824ULL, 0x000fe200078e00ffULL, 0x00008e00ff0c7b82ULL, 0x000ee80000000a00ULL,
0x0000002058007812ULL, 0x002fe200078ef85bULL, 0x0000000302027224ULL, 0x004fc800078e02ffULL,
0x0000004002037824ULL, 0x000fc800078e00ffULL, 0x0000008003027825ULL, 0x008fe200078e000cULL,
0x0000000000fc0947ULL, 0x000fec0003800000ULL, 0x0000005b74067248ULL, 0x000fe20007fe0000ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fc6000001160aULL,
0x0000000106067824ULL, 0x000fe400078e0a5bULL, 0x0000000105097824ULL, 0x000fe400078e0208ULL,
0x00000004080d7836ULL, 0x000fe20000000000ULL, 0x0000000506067248ULL, 0x000fe20007fe0000ULL,
0x00000001090c7824ULL, 0x040fe400078e020aULL, 0x00000008090f7824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fc400078e0a05ULL, 0x0000000c080e7836ULL, 0x000fe20000000000ULL,
0xfffffff80f127812ULL, 0x000fe200078ee20cULL, 0x00000008080c7836ULL, 0x000fe20000000000ULL,
0x000000060d00720cULL, 0x080fe20003f46070ULL, 0x00000001050d7824ULL, 0x000fe200078e020dULL,
0x000000060800720cULL, 0x080fe20003f66070ULL, 0x0000000100097824ULL, 0x000fe200078e0209ULL,
0x000000060c00720cULL, 0x080fe20003f26070ULL, 0x000000010d087824ULL, 0x040fe200078e020aULL,
0x000000060e00720cULL, 0x000fe20003f06070ULL, 0x000000080d137824ULL, 0x000fc400078e00ffULL,
0x0000000105117824ULL, 0x040fe400078e020eULL, 0x00000001050f7824ULL, 0x000fe200078e020cULL,
0xfffffff813067812ULL, 0x000fe200078ee208ULL, 0x0000008009087825ULL, 0x000fc800078e00ffULL,
0x00000001000e7824ULL, 0x040fe200078e0211ULL, 0x0000007008137812ULL, 0x000fe200078ef804ULL,
0x0000000111087824ULL, 0x040fe400078e020aULL, 0x0000000811117824ULL, 0x000fe200078e00ffULL,
0x0000001302107210ULL, 0x000fe20007f9e0ffULL, 0x00000001000d7824ULL, 0x040fe400078e020dULL,
0x00000001000c7824ULL, 0x000fe200078e020fULL, 0xfffffff811167812ULL, 0x000fe200078ee208ULL,
0x0000000103117824ULL, 0x000fe200020e0609ULL, 0x0000000a6a007c11ULL, 0x000fe2000f8e68ffULL,
0x000000800d087825ULL, 0x000fc800078e00ffULL, 0x000000010f057824ULL, 0x040fe200078e020aULL,
0x00000070081d7812ULL, 0x000fe200078ef804ULL, 0x000000080f147824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1b7812ULL, 0x000fc600078ef804ULL,
0x0001600000057836ULL, 0x000fe20000000000ULL, 0x000000700e197812ULL, 0x000fe400078ef804ULL,
0x0000001d02047210ULL, 0x000fe20007f9e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0205ULL,
0x0000001b02087210ULL, 0x000fe20007fbe0ffULL, 0x0000001006157824ULL, 0x100fe200078e0205ULL,
0x0000001902027210ULL, 0x000fe20007fde0ffULL, 0x0000001014177824ULL, 0x100fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000d901c46ULL,
0x0000001016197824ULL, 0x000fc400078e0205ULL, 0x0000000103057824ULL, 0x040fe400020e0609ULL,
0x0000000103097824ULL, 0x040fe400028e060dULL, 0x0000000103037824ULL, 0x000fe200030e060fULL,
0x0000000004157faeULL, 0x0003e8000d101c46ULL, 0x0000000008177faeULL, 0x0003e8000c901c46ULL,
0x0000000002197faeULL, 0x0003e2000c101c46ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x0000001005057824ULL, 0x000fca00078e00ffULL, 0x000000050a057211ULL, 0x000fca00078fe8ffULL,
0x00000004050d7836ULL, 0x000fe40000000000ULL, 0x0000000100087824ULL, 0x000fe400078e0205ULL,
0x000000010d097824ULL, 0x140fe400078e020aULL, 0x000000080d127824ULL, 0x000fe400078e00ffULL,
0x0000000105067824ULL, 0x040fe400078e020aULL, 0x00000008050f7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee209ULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff80f067812ULL, 0x000fe200078ee206ULL, 0x00000008050f7836ULL, 0x000fe20000000000ULL,
0x0000007008117812ULL, 0x000fe200078ef804ULL, 0x0000000c05057836ULL, 0x000fe40000000000ULL,
0x00000001000d7824ULL, 0x040fe200078e020dULL, 0x0000001102107210ULL, 0x000fe20007f1e0ffULL,
0x00000001000e7824ULL, 0x040fe400078e0205ULL, 0x0000000105087824ULL, 0x000fe400078e020aULL,
0x00000001000c7824ULL, 0x000fc400078e020fULL, 0x0000000805057824ULL, 0x000fe400078e00ffULL,
0x000000010f007824ULL, 0x040fe400078e020aULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0x0000000a6a0f7c11ULL, 0x000fe2000f8e68ffULL, 0x0000000103117824ULL, 0x000fe200000e0609ULL,
0xfffffff805057812ULL, 0x000fe200078ee208ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fc600078ee200ULL, 0x000160000f1f7836ULL, 0x000fe20000000000ULL,
0x00000070081d7812ULL, 0x000fe200078ef804ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1b7812ULL, 0x000fc600078ef804ULL,
0x0000001006137824ULL, 0x100fe200078e021fULL, 0x000000700e197812ULL, 0x000fe200078ef804ULL,
0x0000001012157824ULL, 0x100fe200078e021fULL, 0x0000001d02047210ULL, 0x000fe20007f1e0ffULL,
0x0000001000177824ULL, 0x100fe200078e021fULL, 0x0000001b02087210ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000b901c46ULL,
0x0000001902027210ULL, 0x000fe20007f5e0ffULL, 0x0000001005197824ULL, 0x000fe400078e021fULL,
0x0000000103057824ULL, 0x000fc400000e0609ULL, 0x0000000103097824ULL, 0x040fe400008e060dULL,
0x0000000103037824ULL, 0x000fe200010e060fULL, 0x0000000004157faeULL, 0x0003e8000b901c46ULL,
0x0000000008177faeULL, 0x0003e8000b901c46ULL, 0x0000000002197faeULL, 0x0003e4000b901c46ULL,
0x0000000159597836ULL, 0x000fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000705900720cULL, 0x000fda0003f06070ULL, 0x00009400ff058b82ULL, 0x002e620000000800ULL,
0x0000000207008824ULL, 0x000fce00078e00ffULL, 0x00009000ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000500008224ULL, 0x002fc800078e0205ULL, 0x0000000100058824ULL, 0x000fc800078e0259ULL,
0x0000000405028825ULL, 0x004fc800078e0002ULL, 0x0000000aff057e24ULL, 0x000fe2000f8e00ffULL,
0x000000006a0472caULL, 0x000fe200000e0000ULL, 0x0000000602818981ULL, 0x000322000c1e1900ULL,
0x000000ff6b00720cULL, 0x000fe20003f05270ULL, 0x0001a6a805057836ULL, 0x000fe20000000000ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000000ffff827224ULL, 0x000fe200078e00ffULL,
0x00000000050572caULL, 0x000fe400000e0000ULL, 0x00000000003a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000086a027824ULL, 0x002fe200078e0205ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000009ff7879a7ULL, 0x0002a20008500004ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000527805ULL, 0x000fe4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00002009020279a7ULL, 0x0002e2000850003fULL, 0x0000000000567805ULL, 0x000fe4000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x000000c000488947ULL, 0x000fec0003800000ULL,
0x00009400ff377b82ULL, 0x000f620000000800ULL, 0x0000000871027824ULL, 0x008fe200078e00ffULL,
0x000000016a007812ULL, 0x000fe200078ec0ffULL, 0x0000000207087824ULL, 0x000fe200078e00ffULL,
0x0000000a5a057c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff407224ULL, 0x000fe200078e0003ULL,
0x0000000802027812ULL, 0x000fe200078ec0ffULL, 0xff317217ff7e7424ULL, 0x000fe400078e00ffULL,
0x0000001000057824ULL, 0x000fe400078e0205ULL, 0x000000ffff077224ULL, 0x000fc400078e00ffULL,
0x0000000102097824ULL, 0x002fe400078e0205ULL, 0x0000003708087224ULL, 0x020fe400078e0237ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000ffff6c7224ULL, 0x000fce00078e0059ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000000471067824ULL, 0x000fca00078e00ffULL,
0xfffffff8063f7812ULL, 0x000fc800078ec0ffULL, 0x01a6c8403f0075a7ULL, 0x000e62000800014aULL,
0x0000000a3f417c36ULL, 0x000fc80008000000ULL, 0x0001a6c841067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff427224ULL, 0x000fce00078e00ffULL,
0x000000104200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000142427836ULL, 0x000fce0000000000ULL,
0x01a6c840410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff3c7b82ULL, 0x000e620000000a00ULL, 0x00000010713e7824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000000107427836ULL, 0x000fe40000000000ULL,
0x0000000481817c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe03e407812ULL, 0x000fe400078ec0ffULL,
0x0000006b4200720cULL, 0x000fe20003f26070ULL, 0x0000004081817824ULL, 0x000fe400078e00ffULL,
0x0000010007407824ULL, 0x000fc800078e0240ULL, 0x0000004040417836ULL, 0x000fca0000000000ULL,
0x00000020413f7812ULL, 0x000fe200078ec0ffULL, 0x00000080813c7825ULL, 0x002fc800078e003cULL,
0x0000000158447824ULL, 0x000fe200078e023fULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x000000103e3f7812ULL, 0x000fe200078ec0ffULL, 0x000000100a5c7824ULL, 0x000fe200078e00ffULL,
0x00000041743e7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff427819ULL, 0x100fe4000001160aULL,
0x000000705c617812ULL, 0x000fe200078ec0ffULL, 0x000000013e3e7824ULL, 0x000fe400078e0a41ULL,
0x0000000142417824ULL, 0x000fe400078e023fULL, 0x0000000842457836ULL, 0x000fe20000000000ULL,
0x0000003f3e3e7248ULL, 0x000fe20007fe0000ULL, 0x0000000141407824ULL, 0x000fc400078e020aULL,
0x0000000841437824ULL, 0x000fe400078e00ffULL, 0x000000013e3e7824ULL, 0x000fc600078e0a3fULL,
0xfffffff843467812ULL, 0x000fe200078ee240ULL, 0x0000000442437836ULL, 0x000fe20000000000ULL,
0x0000003e4200720cULL, 0x080fe20003f86070ULL, 0x0000000c42427836ULL, 0x000fe20000000000ULL,
0x0000003e4500720cULL, 0x0c0fe20003f46070ULL, 0x0000000145457824ULL, 0x100fe200078e023fULL,
0x0000003e4300720cULL, 0x0c0fe20003f66070ULL, 0x0000000143437824ULL, 0x100fe200078e023fULL,
0x0000003e4200720cULL, 0x040fe20003f06070ULL, 0x0000000142477824ULL, 0x000fe400078e023fULL,
0x0000000144407824ULL, 0x000fc400078e0243ULL, 0x0000000143427824ULL, 0x140fe400078e020aULL,
0x00000008435f7824ULL, 0x000fe400078e00ffULL, 0x00000001443e7824ULL, 0x040fe400078e0241ULL,
0x0000000144437824ULL, 0x040fe200078e0245ULL, 0xfffffff85f5c7812ULL, 0x000fe200078ee242ULL,
0x00000001445d7824ULL, 0x000fe200078e0247ULL, 0x0000000a6a5f7c11ULL, 0x000fe2000f8e68ffULL,
0x0000000145447824ULL, 0x000fc400078e020aULL, 0x0000000845637824ULL, 0x000fe400078e00ffULL,
0x0000000147457824ULL, 0x040fe400078e020aULL, 0x0000000847607824ULL, 0x000fe200078e00ffULL,
0xfffffff8635e7812ULL, 0x000fe200078ee244ULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff860607812ULL, 0x000fe200078ee245ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000006140457212ULL, 0x000fc600078efcffULL, 0x0000008043427825ULL, 0x000fe200078e00ffULL,
0x000000613e477212ULL, 0x080fe400078efcffULL, 0x000000453c407210ULL, 0x000fe20007fde0ffULL,
0x000000805d447825ULL, 0x000fe200078e00ffULL, 0x000000473c3e7210ULL, 0x000fe40007fbe0ffULL,
0x0000006142637212ULL, 0x080fe200078efcffULL, 0x000170005f477836ULL, 0x000fe20000000000ULL,
0x0000006144617212ULL, 0x000fe200078efcffULL, 0x000000013d3f7824ULL, 0x040fe200028e063fULL,
0x000000633c427210ULL, 0x000fe20007fbe0ffULL, 0x000000013d417824ULL, 0x000fe200030e0641ULL,
0x000000613c3c7210ULL, 0x000fe20007fde0ffULL, 0x00000010465d7824ULL, 0x000fc400078e0247ULL,
0x000000105c5f7824ULL, 0x100fe400078e0247ULL, 0x000000105e617824ULL, 0x000fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e5d7faeULL, 0x0003e2000e101c46ULL,
0x000000013d437824ULL, 0x040fe400028e0643ULL, 0x0000001060477824ULL, 0x000fe200078e0247ULL,
0x00000000405f7faeULL, 0x0003e2000d901c46ULL, 0x000000013d3d7824ULL, 0x000fc600030e0645ULL,
0x0000000042617faeULL, 0x0003e8000d101c46ULL, 0x000000003c477faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x000000103e3f7812ULL, 0x000fe200078ec0ffULL,
0x000000100a427824ULL, 0x000fc600078e00ffULL, 0x0000003f0a3f7211ULL, 0x000fe400078fe8ffULL,
0x0000007042617812ULL, 0x000fc600078ec0ffULL, 0x000000043f417836ULL, 0x000fe40000000000ULL,
0x000000013f3e7824ULL, 0x140fe400078e020aULL, 0x000000083f437824ULL, 0x000fe400078e00ffULL,
0x0000000141407824ULL, 0x040fe400078e020aULL, 0x0000000841457824ULL, 0x000fe200078e00ffULL,
0xfffffff843467812ULL, 0x000fe200078ee23eULL, 0x00000001443e7824ULL, 0x000fc400078e023fULL,
0x000000083f437836ULL, 0x000fe20000000000ULL, 0xfffffff8455c7812ULL, 0x000fe200078ee240ULL,
0x0000000c3f457836ULL, 0x000fe40000000000ULL, 0x000000803e3e7825ULL, 0x000fc800078e00ffULL,
0x0000000144417824ULL, 0x000fe200078e0241ULL, 0x000000613e477212ULL, 0x000fe200078efcffULL,
0x0000000144427824ULL, 0x040fe400078e0243ULL, 0x0000000143407824ULL, 0x140fe200078e020aULL,
0x000000473c3e7210ULL, 0x000fe20007f1e0ffULL, 0x00000008435d7824ULL, 0x000fe400078e00ffULL,
0x0000000144447824ULL, 0x000fe400078e0245ULL, 0x0000000145437824ULL, 0x040fe200078e020aULL,
0xfffffff85d5e7812ULL, 0x000fe200078ee240ULL, 0x0000000845607824ULL, 0x000fe200078e00ffULL,
0x0000000a6a457c11ULL, 0x000fe2000f8e68ffULL, 0x0000008041407825ULL, 0x000fc600078e00ffULL,
0xfffffff860607812ULL, 0x000fe200078ee243ULL, 0x0001700045677836ULL, 0x000fe20000000000ULL,
0x0000006140657212ULL, 0x000fe200078efcffULL, 0x0000008042427825ULL, 0x000fc800078e00ffULL,
0x0000008044447825ULL, 0x000fe200078e00ffULL, 0x0000006142637212ULL, 0x000fc600078efcffULL,
0x000000013d3f7824ULL, 0x040fe200000e063fULL, 0x0000006144617212ULL, 0x000fe200078efcffULL,
0x0000001046477824ULL, 0x100fe200078e0267ULL, 0x000000653c407210ULL, 0x000fe20007f1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e0267ULL, 0x000000633c427210ULL, 0x000fe20007f5e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e0267ULL, 0x000000613c3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000013d417824ULL, 0x040fe200000e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e2000b901c46ULL, 0x000000013d437824ULL, 0x000fc400010e0643ULL,
0x0000001060617824ULL, 0x000fe200078e0267ULL, 0x00000000405d7faeULL, 0x0003e2000b901c46ULL,
0x000000013d3d7824ULL, 0x000fc600018e0645ULL, 0x00000000425f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c617faeULL, 0x0003e4000b901c46ULL, 0x00000001593f7836ULL, 0x002fe40000000000ULL,
0xffffffffff7c7424ULL, 0x000fc600078e00ffULL, 0x000000703f00720cULL, 0x000fe20003f06070ULL,
0x00000008717a7824ULL, 0x000fca00078e00ffULL, 0xfffffff07a407812ULL, 0x000fca00078ec0ffULL,
0x0000000a40427c36ULL, 0x000fe40008000000ULL, 0x00009000ff3c8b82ULL, 0x000e620000000a00ULL,
0x00000001083f8824ULL, 0x000fe200078e023fULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000420472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x000000043f3c8825ULL, 0x002fd000078e003cULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x000000063c7c8981ULL, 0x000322000c1e1900ULL, 0xffffffe07a3e7812ULL, 0x040fe200078ec0ffULL,
0x00000001ff417424ULL, 0x000fe200078e00ffULL, 0x000000107a3f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a3f3e7c10ULL, 0x000fe4000fffe03eULL, 0x000000087a3f7812ULL, 0x000fca00078ec0ffULL,
0x000000013e807824ULL, 0x000fe200078e023fULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x01a6b041428679a7ULL, 0x0002e4000850003fULL, 0x01a60841804079a7ULL, 0x0022a4000850003fULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x01a60841800075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x000000104400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000144447836ULL, 0x000fce0000000000ULL,
0x01a60841800075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000100a697824ULL, 0x000fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe2000001160aULL,
0x00000020713c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x0000007069697812ULL, 0x000fe200078ec0ffULL, 0x000000ffff837224ULL, 0x000fe200078e007eULL,
0xffffff803c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c6e6e7812ULL, 0x000fe400078ec0ffULL,
0x0000000a693d7c10ULL, 0x000fca000fffe03cULL, 0x000000013d3d7824ULL, 0x000fca00078e026eULL,
0x01a000003d3f7984ULL, 0x000ea80000000800ULL, 0x01a200003d417984ULL, 0x000b620000000800ULL,
0x0000007e3f00720bULL, 0x004fda0003f1d000ULL, 0x00000000003e7806ULL, 0x000fc800000e0100ULL,
0x000000ff3e00720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x02afea0003800000ULL,
0x000000715a00720cULL, 0x000fe40003f45270ULL, 0x0000007e3f00720bULL, 0x0c0fe40003f14000ULL,
0x0000007e3f837209ULL, 0x000fd20007810000ULL, 0x0000000a713cac11ULL, 0x000fe4000f8e38ffULL,
0x00000000003d7806ULL, 0x000fe400000e0100ULL, 0x0000003c6e3ca210ULL, 0x000fe40007ffe069ULL,
0x000000ff3d00720cULL, 0x000fc60003f05270ULL, 0x01a400833c00a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007e833c7221ULL, 0x000fe20000010100ULL,
0x000000ff3dff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003dff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b3c3c7820ULL, 0x000fe20000410000ULL, 0x00ff00003dff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003dff7812ULL, 0x000fe2000788c0ffULL, 0x0000003c00437308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff3c7819ULL, 0x002fcc000001160aULL,
0x00001f3c433c7589ULL, 0x004e6400000e0000ULL, 0x0000003c54547220ULL, 0x082fe20000410000ULL,
0x0000003c55557220ULL, 0x080fe20000410000ULL, 0x0000003c48487220ULL, 0x080fe20000410000ULL,
0x0000003c49497220ULL, 0x080fe20000410000ULL, 0x0000003c4c4c7220ULL, 0x080fe20000410000ULL,
0x0000003c4d4d7220ULL, 0x080fe20000410000ULL, 0x0000003c50507220ULL, 0x080fe20000410000ULL,
0x0000003c51517220ULL, 0x080fe20000410000ULL, 0x0000003c30307220ULL, 0x080fe20000410000ULL,
0x0000003c31317220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a3c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f3c433c7589ULL, 0x004e6400000e0000ULL,
0x0000003c56567220ULL, 0x082fe20000410000ULL, 0x0000003c57577220ULL, 0x080fe20000410000ULL,
0x0000003c4a4a7220ULL, 0x080fe20000410000ULL, 0x0000003c4b4b7220ULL, 0x080fe20000410000ULL,
0x0000003c4e4e7220ULL, 0x080fe20000410000ULL, 0x0000003c4f4f7220ULL, 0x080fe20000410000ULL,
0x0000003c52527220ULL, 0x080fe20000410000ULL, 0x0000003c53537220ULL, 0x080fe20000410000ULL,
0x0000003c32327220ULL, 0x080fe20000410000ULL, 0x0000003c33337220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a3c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c433c7589ULL, 0x004e6400000e0000ULL, 0x0000003c0c0c7220ULL, 0x082fe20000410000ULL,
0x0000003c0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003c10107220ULL, 0x080fe20000410000ULL,
0x0000003c11117220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003c20207220ULL, 0x080fe20000410000ULL,
0x0000003c21217220ULL, 0x080fe20000410000ULL, 0x0000003c38387220ULL, 0x080fe20000410000ULL,
0x0000003c39397220ULL, 0x080fe20000410000ULL, 0x0000003c34347220ULL, 0x080fe20000410000ULL,
0x0000003c35357220ULL, 0x000fce0000410000ULL, 0x0000004382827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a3c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c433c7589ULL, 0x000e6400000e0000ULL, 0x0000003c0e0e7220ULL, 0x082fe20000410000ULL,
0x0000003c0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003c12127220ULL, 0x080fe20000410000ULL,
0x0000003c13137220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003c22227220ULL, 0x080fe20000410000ULL,
0x0000003c23237220ULL, 0x080fe20000410000ULL, 0x0000003c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003c36367220ULL, 0x080fe20000410000ULL,
0x0000003c37377220ULL, 0x000fce0000410000ULL, 0x0000003d3eff7212ULL, 0x000fda00078030ffULL,
0x800000833f3f0221ULL, 0x000fe20000010000ULL, 0x00007610ff400816ULL, 0x000fc60000000040ULL,
0x3fb8aa3b3f3f0820ULL, 0x000fc80000410000ULL, 0x0000003f00040308ULL, 0x000ea40000000800ULL,
0x0000000441410220ULL, 0x004fce0000410000ULL, 0x0000008241827221ULL, 0x000fce0000010000ULL,
0x00000000003c7805ULL, 0x002fce0000015200ULL, 0x01a6a879420075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff437224ULL, 0x000fce00078e00ffULL,
0x000000104300780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000413e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000143437836ULL, 0x000fce0000000000ULL,
0x01a6a879420075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910403d7816ULL, 0x000fe200000000ffULL, 0x0000000271817824ULL, 0x040fe400078e00ffULL,
0x00000400713c7824ULL, 0x000fe200078e00ffULL, 0x000000ff3d00720cULL, 0x000fe20003f05270ULL,
0x00000004717d7824ULL, 0x000fe200078e00ffULL, 0x000000080a3d7812ULL, 0x000fe200078ec0ffULL,
0x0000000aff797e24ULL, 0x000fe2000f8e00ffULL, 0x00000004816f7812ULL, 0x000fe200078ec0ffULL,
0x0000000aff3f7e24ULL, 0x000fe2000f8e00ffULL, 0x000000073d687812ULL, 0x000fc400078ef80aULL,
0x0000006f0a3d7211ULL, 0x000fe400078fe0ffULL, 0x0000001068787812ULL, 0x040fe200078efcffULL,
0x00000008683e7824ULL, 0x000fe200078e00ffULL, 0xfffff0003c3c7812ULL, 0x000fe200078ec0ffULL,
0x00000001687f7824ULL, 0x000fe200078e023dULL, 0x000000047d7d7812ULL, 0x000fe200078ec0ffULL,
0x000000013d7e7824ULL, 0x000fe200078e0278ULL, 0x0001200079797810ULL, 0x000fe20007ffe03cULL,
0x00000008783d7824ULL, 0x000fe200078e00ffULL, 0x0000007d0a7d7211ULL, 0x000fe200078fe0ffULL,
0x00001000713c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e7f7812ULL, 0x000fe200078ee27fULL,
0x00000008686d7824ULL, 0x040fe200078e00ffULL, 0xfffffff83d7e7812ULL, 0x000fe200078ee27eULL,
0x00000001685c7824ULL, 0x000fe200078e027dULL, 0xffffe0003c3c7812ULL, 0x000fe200078ec0ffULL,
0x000000107f3e7824ULL, 0x000fc400078e0279ULL, 0x000000107e447824ULL, 0x000fe200078e0279ULL,
0x000160003f5e7810ULL, 0x000fe40007ffe03cULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee25cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x00005410003c7816ULL, 0x000fe20000000000ULL, 0x00000008033d7836ULL, 0x000fe40000000000ULL,
0x00000018033f7836ULL, 0x000fe40000000000ULL, 0x00001f053c057589ULL, 0x0002a800000e0000ULL,
0x00001f3d3c027589ULL, 0x0002e800000e0000ULL, 0x00001f033c037589ULL, 0x00026800000e0000ULL,
0x00001f3f3c007589ULL, 0x00026400000e0000ULL, 0x000000003e3c783bULL, 0x002e620000000200ULL,
0x000000106d407824ULL, 0x000fc600078e025eULL, 0x000000004444783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x088fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000544447232ULL, 0x084fe40000200000ULL,
0x0000000546467232ULL, 0x000fc40000200000ULL, 0x0000000045457232ULL, 0x080fe40000200000ULL,
0x0000000047477232ULL, 0x000fce0000200000ULL, 0x0000000868607824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x000000025c7b7836ULL, 0x000fe20000000000ULL,
0x000000026f6f7812ULL, 0x000fc800078efcffULL, 0xfffffff8607b7812ULL, 0x000fca00078ee27bULL,
0x000000107b5e7824ULL, 0x000fcc00078e025eULL, 0x000000005e5c783bULL, 0x000f640000004200ULL,
0x000000ff40607812ULL, 0x068fe400078ec0ffULL, 0x00000010ff927819ULL, 0x100fe40000011640ULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x0000ffff40907812ULL, 0x000fe400078ec0ffULL,
0x000000ff41657812ULL, 0x000fc400078ec0ffULL, 0x00000060ff64723eULL, 0x000fe400020006ffULL,
0x000000ff42667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x100fe20000011641ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff637819ULL, 0x000fe40000011641ULL,
0x00000010ff8c7819ULL, 0x004fe4000001165cULL, 0x000000ff5c967812ULL, 0x000fc400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe4000001165cULL, 0x0000ffff5c847812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x00000010ff727819ULL, 0x100fe4000001165eULL,
0x000000ff5e607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fc4000001165eULL,
0x0000ffff5e857812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff41937812ULL, 0x000fe400078ec0ffULL, 0x00000018ff947819ULL, 0x000fe4000001165fULL,
0x00000010ff8f7819ULL, 0x100fe40000011642ULL, 0x00000018ff417819ULL, 0x000fc40000011642ULL,
0x0000ffff428a7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff887819ULL, 0x000fe4000001165fULL,
0x0000ffff5f737812ULL, 0x000fe400078ec0ffULL, 0x00000066ff42723eULL, 0x000fe200020006ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x0000005eff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff907819ULL, 0x000fe20000011690ULL, 0x20000042ff657230ULL, 0x000fe20000004100ULL,
0x00000018ff957819ULL, 0x100fe20000011643ULL, 0x20000060ff5c7230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x2000005fff607230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe40000011643ULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x20000094ff5f7230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x00000095ff42723eULL, 0x000fe400020006ffULL, 0x00000008ff957819ULL, 0x000fe40000011693ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff91947812ULL, 0x000fe400078ec0ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff438d7812ULL, 0x000fc400078ec0ffULL, 0x00000092ff91723eULL, 0x000fe200020006ffULL,
0x20000090ff927230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x0000008fff90723eULL, 0x000fe200020006ffULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x000000ff43677812ULL, 0x000fe200078ec0ffULL, 0x20000095ff8f7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000094ff93723eULL, 0x000fc400020006ffULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe4000001165dULL,
0x00000008ff947819ULL, 0x000fe2000001168dULL, 0x20000090ff8d7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x2000008bff907230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL, 0x00000067ff43723eULL, 0x000fe200020006ffULL,
0x20000062ff677230ULL, 0x000fe20000004100ULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000000ff5d977812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5d897812ULL, 0x000fe400078ec0ffULL, 0x00000094ff94723eULL, 0x000fc400020006ffULL,
0x000000ff8e957812ULL, 0x000fe200078ec0ffULL, 0x2000008aff8e7230ULL, 0x000fe20000004100ULL,
0x00000040ff5d723eULL, 0x000fe200020006ffULL, 0x20000041ff407230ULL, 0x000fe20000004100ULL,
0x0000008cff8b723eULL, 0x000fe200020006ffULL, 0x20000096ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x20000094ff8a7230ULL, 0x000fe20000004100ULL,
0x00000095ff8c723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff957819ULL, 0x000fe20000011667ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff677819ULL, 0x000fe20000011693ULL, 0x20000063ff627230ULL, 0x000fe20000004100ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000043ff637230ULL, 0x000fe20000004100ULL,
0x000000ff88947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff937819ULL, 0x000fe40000011640ULL,
0x00000008ff887819ULL, 0x000fe20000011685ULL, 0x20000084ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fc4000001168dULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff8d7819ULL, 0x000fe40000011641ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff417819ULL, 0x000fe4000001168aULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x00000094ff84723eULL, 0x000fe400020006ffULL,
0x00000010ff8a7819ULL, 0x000fe4000001168bULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000088ff94723eULL, 0x000fe200020006ffULL,
0x20000089ff887230ULL, 0x000fe20000004100ULL, 0x00000097ff43723eULL, 0x000fe200020006ffULL,
0x20000072ff897230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x20000094ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe20000011691ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000010548a427816ULL, 0x000fc4000000008dULL,
0x00000010ff8a7819ULL, 0x000fe4000001165dULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff947819ULL, 0x000fe40000011666ULL, 0x0000105491667816ULL, 0x000fe40000000064ULL,
0x00000010ff8b7819ULL, 0x000fe4000001165cULL, 0x00000010ff917819ULL, 0x000fc40000011665ULL,
0x000010548a5c7816ULL, 0x000fe40000000085ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff657819ULL, 0x000fe4000001168fULL, 0x00000010ff857819ULL, 0x000fe40000011660ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff5d7819ULL, 0x000fc40000011688ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff607819ULL, 0x000fe40000011672ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff8e7819ULL, 0x000fc4000001168eULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff887819ULL, 0x000fe40000011689ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff727819ULL, 0x000fe4000001165fULL, 0x00000010ff737819ULL, 0x000fc40000011673ULL,
0x0000105462657816ULL, 0x000fe40000000065ULL, 0x0000105440627816ULL, 0x000fe40000000091ULL,
0x000010545e5d7816ULL, 0x000fe4000000005dULL, 0x0000105461607816ULL, 0x000fe40000000060ULL,
0x0000105467677816ULL, 0x000fe40000000094ULL, 0x0000105495647816ULL, 0x000fe20000000092ULL,
0x0000005c3c2c723cULL, 0x002fe2000004182cULL, 0x0000105490637816ULL, 0x000fc40000000063ULL,
0x0000105493407816ULL, 0x000fe4000000008eULL, 0x000010548c437816ULL, 0x000fe20000000043ULL,
0x000000663c54723cULL, 0x000fe20000041854ULL, 0x00001054885e7816ULL, 0x000fe4000000008bULL,
0x00001054845f7816ULL, 0x000fe40000000085ULL, 0x0000105472617816ULL, 0x000fe20000000073ULL,
0x000000643c48723cULL, 0x000fe20000041848ULL, 0x0000000a6a737c11ULL, 0x000fca000f8e68ffULL,
0x000000623c4c723cULL, 0x000fe2000004184cULL, 0x0001600073847836ULL, 0x000fca0000000000ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x0000005c4420723cULL, 0x000fe20000041820ULL, 0x0000006f0a3d7211ULL, 0x000fe200078fe0ffULL,
0x00000008683c7824ULL, 0x000fc400078e00ffULL, 0x00000008783f7824ULL, 0x000fe400078e00ffULL,
0x00000001686f7824ULL, 0x100fe200078e023dULL, 0x00000066440c723cULL, 0x000fe2000004180cULL,
0x0000000178727824ULL, 0x040fe400078e023dULL, 0x00000001785c7824ULL, 0x040fe200078e027dULL,
0xfffffff83c6f7812ULL, 0x000fe200078ee26fULL, 0x00000008787d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f727812ULL, 0x000fe200078ee272ULL, 0x000000644410723cULL, 0x000fe40000041810ULL,
0x000000106f3c7824ULL, 0x100fe200078e0279ULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee25cULL,
0x0000001072797824ULL, 0x000fc400078e0279ULL, 0x000000624414723cULL, 0x000fe40000041814ULL,
0x000000003c3c783bULL, 0x000e680000000200ULL, 0x000000404418723cULL, 0x000fec0000041818ULL,
0x00000042441c723cULL, 0x000fe2000004181cULL, 0x000000107d407824ULL, 0x000fca00078e0284ULL,
0x0000005e4438723cULL, 0x000fec0000041838ULL, 0x000000604444723cULL, 0x000fe20000041834ULL,
0x000000007934783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x080fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x00000008785e7824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x000000025c797836ULL, 0x004fe20000000000ULL,
0xfffffff881817812ULL, 0x000fc800078ec0ffULL, 0xfffffff85e797812ULL, 0x000fca00078ee279ULL,
0x00000010795c7824ULL, 0x000fcc00078e0284ULL, 0x000000005c5c783bULL, 0x000ea20000004200ULL,
0x00000018ff627819ULL, 0x120fe40000011640ULL, 0x00000018ff637819ULL, 0x100fe40000011641ULL,
0x00000010ff917819ULL, 0x000fe40000011640ULL, 0x000000ff40607812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40937812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x000fc40000011641ULL,
0x000000ff41647812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41957812ULL, 0x000fe400078ec0ffULL,
0x000000ff43667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff967819ULL, 0x100fe40000011642ULL,
0x000000ff42657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fc40000011642ULL,
0x0000ffff428e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8d7819ULL, 0x100fe40000011643ULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x0000ffff43907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x004fe4000001165cULL, 0x000000ff5c437812ULL, 0x000fc400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe4000001165cULL, 0x0000ffff5c8b7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff927819ULL, 0x100fe4000001165dULL,
0x000000ff5d987812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fc4000001165dULL,
0x0000ffff5d8c7812ULL, 0x000fe400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000066ff5d723eULL, 0x000fe200020006ffULL, 0x20000062ff667230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000063ff627230ULL, 0x000fe20000004100ULL,
0x000000ff5e887812ULL, 0x000fe200078ec0ffULL, 0x2000005dff637230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000060ff61723eULL, 0x000fe400020006ffULL,
0x00000018ff857819ULL, 0x100fe4000001165eULL, 0x00000098ff98723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe4000001165eULL,
0x0000ffff5e8a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fc4000001165fULL,
0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL, 0x00000042ff5d723eULL, 0x000fe200020006ffULL,
0x20000041ff427230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000043ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fe2000001165fULL,
0x20000098ff437230ULL, 0x000fe20000004100ULL, 0x0000ffff5f677812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x00000085ff5f723eULL, 0x000fe400020006ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x0000005eff98723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x20000088ff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe20000011693ULL, 0x2000005fff887230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000097ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff977819ULL, 0x000fe20000011695ULL, 0x20000098ff857230ULL, 0x000fe20000004100ULL,
0x00000093ff95723eULL, 0x000fe200020006ffULL, 0x20000091ff937230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fc400020006ffULL, 0x000000ff96967812ULL, 0x000fe200078ec0ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff917230ULL, 0x000fe20000004100ULL, 0x00000008ff977819ULL, 0x000fe40000011690ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000008ff8e7819ULL, 0x000fe4000001168eULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000096ff907230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fc400020006ffULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000008dff967230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff8b7819ULL, 0x000fe4000001168bULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x000000ff92987812ULL, 0x000fe200078ec0ffULL,
0x2000008eff927230ULL, 0x000fe20000004100ULL, 0x00000008ff8c7819ULL, 0x000fc4000001168cULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x000000ff89977812ULL, 0x000fe400078ec0ffULL,
0x00000008ff897819ULL, 0x000fe4000001168aULL, 0x0000008fff8e723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x2000008bff8a7230ULL, 0x000fe20000004100ULL, 0x00000098ff8f723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000097ff98723eULL, 0x000fe200020006ffULL,
0x2000008cff8b7230ULL, 0x000fe20000004100ULL, 0x00000089ff97723eULL, 0x000fe200020006ffULL,
0x20000060ff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe20000011667ULL,
0x20000098ff897230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000097ff607230ULL, 0x000fe20000004100ULL, 0x00000067ff99723eULL, 0x000fc400020006ffULL,
0x00000010ff977819ULL, 0x000fe20000011666ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe20000011661ULL, 0x20000099ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe40000011693ULL, 0x00000010ff987819ULL, 0x000fe40000011664ULL,
0x00000010ff937819ULL, 0x000fe40000011694ULL, 0x0000105466667816ULL, 0x000fc40000000067ULL,
0x0000105493677816ULL, 0x000fe40000000098ULL, 0x00000010ff937819ULL, 0x000fe40000011665ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff657819ULL, 0x000fe20000011691ULL,
0x000000663c54723cULL, 0x002fe20000041854ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x0000105462657816ULL, 0x000fe20000000065ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000105490627816ULL, 0x000fe20000000093ULL,
0x00000066340c723cULL, 0x008fe2000004180cULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff907819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fc4000001168dULL, 0x00000010ff8d7819ULL, 0x000fe4000001165cULL,
0x000010545d5c7816ULL, 0x000fe4000000008aULL, 0x00000010ff647819ULL, 0x000fe40000011695ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff917819ULL, 0x000fe40000011643ULL,
0x00000010ff8a7819ULL, 0x000fc40000011685ULL, 0x00000010ff957819ULL, 0x000fe40000011640ULL,
0x00000010ff437819ULL, 0x000fe4000001168eULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff857819ULL, 0x000fe40000011688ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x00000010ff407819ULL, 0x000fe40000011692ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168fULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff607819ULL, 0x000fc40000011660ULL, 0x00000010ff887819ULL, 0x000fe4000001165fULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x0000105443427816ULL, 0x000fe40000000090ULL, 0x000010545e5d7816ULL, 0x000fe4000000008bULL,
0x0000105497647816ULL, 0x000fc40000000064ULL, 0x0000105496637816ULL, 0x000fe40000000063ULL,
0x0000105495407816ULL, 0x000fe20000000040ULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x000010548e437816ULL, 0x000fe40000000091ULL, 0x000010548c5e7816ULL, 0x000fe4000000008dULL,
0x00001054895f7816ULL, 0x000fe2000000008aULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x0000105485607816ULL, 0x000fc40000000060ULL, 0x0000105488617816ULL, 0x000fc60000000061ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x000000643410723cULL, 0x000fe20000041810ULL,
0x0000000a6a3c7c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff3e7424ULL, 0x000fc800078e00ffULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x01a6c83e3c3c79a7ULL, 0x00026a000850003fULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x01a6883e81ff79a7ULL, 0x0003ea000850000aULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005c3420723cULL, 0x000fec0000041820ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000603444723cULL, 0x002fde0000041844ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008e00ff347b82ULL, 0x000e620000000a00ULL,
0x0000001071367824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x000000047c7c7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe0363c7812ULL, 0x000fe400078ec0ffULL,
0x000000407c3d7824ULL, 0x000fc600078e00ffULL, 0x00000100073c7824ULL, 0x000fc800078e023cULL,
0x000000803c3f7836ULL, 0x000fca0000000000ULL, 0x000000203f377812ULL, 0x000fe200078ec0ffULL,
0x000000803d347825ULL, 0x002fc800078e0034ULL, 0x0000000158427824ULL, 0x000fe200078e0237ULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x0000001036377812ULL, 0x000fe400078ec0ffULL,
0x0000003f74367248ULL, 0x000fe40007fe0000ULL, 0x00000003ff3c7819ULL, 0x000fc6000001160aULL,
0x0000000136367824ULL, 0x000fe400078e0a3fULL, 0x000000013c3d7824ULL, 0x100fe400078e0237ULL,
0x000000043c3f7836ULL, 0x000fe20000000000ULL, 0x0000003637367248ULL, 0x000fe20007fe0000ULL,
0x000000013d3e7824ULL, 0x040fe400078e020aULL, 0x000000083d5d7824ULL, 0x000fe400078e00ffULL,
0x0000000136367824ULL, 0x000fc400078e0a37ULL, 0x0000000c3c417836ULL, 0x000fe20000000000ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee23eULL, 0x000000083c3e7836ULL, 0x000fe20000000000ULL,
0x000000363f00720cULL, 0x0c0fe20003f66070ULL, 0x000000013f3f7824ULL, 0x100fe200078e0237ULL,
0x000000363c00720cULL, 0x080fe20003f86070ULL, 0x000000013e437824ULL, 0x040fe200078e0237ULL,
0x000000363e00720cULL, 0x080fe20003f46070ULL, 0x000000013d3c7824ULL, 0x100fe200078e0242ULL,
0x000000364100720cULL, 0x000fe20003f06070ULL, 0x000000013f407824ULL, 0x000fc400078e0242ULL,
0x00000001433d7824ULL, 0x140fe400078e020aULL, 0x00000008435c7824ULL, 0x000fe400078e00ffULL,
0x00000001415f7824ULL, 0x000fe400078e0237ULL, 0x000000013f377824ULL, 0x040fe200078e020aULL,
0xfffffff85c657812ULL, 0x000fe200078ee23dULL, 0x000000083f3e7824ULL, 0x000fe400078e00ffULL,
0x0000008040407825ULL, 0x000fc600078e00ffULL, 0xfffffff83e637812ULL, 0x000fe200078ee237ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000006940377212ULL, 0x000fc600078efcffULL,
0x00000001433e7824ULL, 0x100fe200078e0242ULL, 0x000000693c437212ULL, 0x000fe200078efcffULL,
0x000000015f367824ULL, 0x000fe200078e0242ULL, 0x0000003734407210ULL, 0x000fe20007fde0ffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x00000043343c7210ULL, 0x000fc60007fbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000693e617212ULL, 0x000fc600078efcffULL,
0x000000015f427824ULL, 0x040fe400078e020aULL, 0x000000085f677824ULL, 0x000fe200078e00ffULL,
0x00000069365f7212ULL, 0x000fe200078efcffULL, 0x00000001353d7824ULL, 0x040fe200028e063dULL,
0x00000061343e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000135417824ULL, 0x000fe200030e0641ULL,
0xfffffff867677812ULL, 0x000fe200078ee242ULL, 0x000000105d437824ULL, 0x100fe200078e0284ULL,
0x0000005f34347210ULL, 0x000fe20007fde0ffULL, 0x00000010635d7824ULL, 0x000fc400078e0284ULL,
0x00000010655f7824ULL, 0x100fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c437faeULL, 0x0003e2000e101c46ULL, 0x00000001353f7824ULL, 0x000fe400028e063fULL,
0x0000001067617824ULL, 0x000fe200078e0284ULL, 0x00000000405d7faeULL, 0x0003e2000d901c46ULL,
0x0000000135357824ULL, 0x000fc600030e0637ULL, 0x000000003e5f7faeULL, 0x0003e8000d101c46ULL,
0x0000000034617faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x0000001036377812ULL, 0x000fc800078ec0ffULL, 0x000000370a377211ULL, 0x000fca00078fe8ffULL,
0x00000001373c7824ULL, 0x040fe400078e020aULL, 0x0000000837437824ULL, 0x040fe400078e00ffULL,
0x0000000137367824ULL, 0x000fe400078e0242ULL, 0x00000004373d7836ULL, 0x000fe20000000000ULL,
0xfffffff843437812ULL, 0x000fe200078ee23cULL, 0x0000000837417836ULL, 0x000fe40000000000ULL,
0x0000000c375d7836ULL, 0x000fc40000000000ULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000013d3e7824ULL, 0x100fe400078e0242ULL, 0x0000000141407824ULL, 0x100fe400078e0242ULL,
0x000000015d3c7824ULL, 0x000fe400078e0242ULL, 0x000000013d3f7824ULL, 0x140fe400078e020aULL,
0x000000083d5c7824ULL, 0x000fe200078e00ffULL, 0x00000069363d7212ULL, 0x000fe200078efcffULL,
0x0000000141427824ULL, 0x000fc400078e020aULL, 0x00000008415f7824ULL, 0x000fe200078e00ffULL,
0x0000003d34367210ULL, 0x000fe20007f1e0ffULL, 0x000000015d417824ULL, 0x040fe400078e020aULL,
0x000000085d5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5d7812ULL, 0x000fe200078ee23fULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe400078ee242ULL,
0xfffffff85e677812ULL, 0x000fe200078ee241ULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x000000693e657212ULL, 0x000fc600078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000006940637212ULL, 0x000fc600078efcffULL, 0x0000000135377824ULL, 0x000fe200000e0637ULL,
0x000000693c617212ULL, 0x000fe200078efcffULL, 0x0000001043437824ULL, 0x100fe200078e0284ULL,
0x00000065343e7210ULL, 0x000fe20007f1e0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0284ULL,
0x0000006334407210ULL, 0x000fe20007f5e0ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0284ULL,
0x0000006134347210ULL, 0x000fe20007f7e0ffULL, 0x00000001353f7824ULL, 0x040fe200000e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036437faeULL, 0x0003e2000b901c46ULL,
0x0000000135417824ULL, 0x000fc400010e0641ULL, 0x0000001067617824ULL, 0x000fe200078e0284ULL,
0x000000003e5d7faeULL, 0x0003e2000b901c46ULL, 0x0000000135357824ULL, 0x000fc600018e063dULL,
0x00000000405f7faeULL, 0x0003e8000b901c46ULL, 0x0000000034617faeULL, 0x0003e4000b901c46ULL,
0x0000000259377836ULL, 0x002fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000703700720cULL, 0x000fe40003f06070ULL, 0xfffffff07a7a7812ULL, 0x000fca00078ec0ffULL,
0x0000000a7a847c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00009000ff348b82ULL, 0x000e620000000a00ULL, 0x00000000840472caULL, 0x000fe200000e0000ULL,
0x0000000108378824ULL, 0x000fd800078e0237ULL, 0x0001a6a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000437348825ULL, 0x002fca00078e0034ULL,
0x0000000634818981ULL, 0x000322000c1e1900ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x01a6a837848479a7ULL, 0x0004e4000850003fULL,
0x01a62837803679a7ULL, 0x004464000850003fULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x01a62837800075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c343f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a62837800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002071347824ULL, 0x000fe400078e00ffULL,
0x0000000aff357e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0xffffff8034347812ULL, 0x000fc800078ec0ffULL, 0x0000008035347810ULL, 0x000fc80007ffe034ULL,
0x000000346e347210ULL, 0x000fca0007ffe069ULL, 0x01a0000034367984ULL, 0x000e680000000800ULL,
0x01a2000034357984ULL, 0x000b620000000800ULL, 0x000000833600720bULL, 0x002fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fc800000e0100ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x02cfea0003800000ULL, 0x000000015a347836ULL, 0x000fe20000000000ULL,
0x000000833600720bULL, 0x000fc80003f14000ULL, 0x000000713400720cULL, 0x000fda0003f45270ULL,
0x0000000a713cac11ULL, 0x000fe4000f8e38ffULL, 0x000000833634a209ULL, 0x000fe40007810000ULL,
0x0000003c6e3da210ULL, 0x000fe40007ffe069ULL, 0x00000000003c7806ULL, 0x000fc600000e0100ULL,
0x01a400343d00a388ULL, 0x0003e20000000800ULL, 0x000000ff3c00720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000008336347209ULL, 0x000fe40007810000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x0000008334347221ULL, 0x000fe20000010100ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc000001160aULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000005434547220ULL, 0x042fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x004e6400000e0000ULL, 0x0000005634567220ULL, 0x042fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000000c340c7220ULL, 0x042fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003d82827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x000e6400000e0000ULL,
0x0000000e340e7220ULL, 0x042fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003c37ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000008336837209ULL, 0x000fd60007810000ULL, 0x8000008336360221ULL, 0x000fe20000010000ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x004fce0000410000ULL,
0x0000008235827221ULL, 0x000fce0000010000ULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x0000000871367824ULL, 0x000fca00078e00ffULL, 0xfffffff036377812ULL, 0x000fc800078ec0ffULL,
0x01a6b087370075a7ULL, 0x000e62000800014aULL, 0x0000000a373f7c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6b0873f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099103c347816ULL, 0x000fe200000000ffULL, 0x0000040071357824ULL, 0x040fe400078e00ffULL,
0x0000100071367824ULL, 0x000fe200078e00ffULL, 0x000000ff3400720cULL, 0x000fe20003f05270ULL,
0x0000000aff7c7e24ULL, 0x000fe2000f8e00ffULL, 0xfffff00035357812ULL, 0x000fe200078ec0ffULL,
0x0000000aff377e24ULL, 0x000fe2000f8e00ffULL, 0xffffe00036367812ULL, 0x000fe400078ec0ffULL,
0x000130007c7c7810ULL, 0x000fc40007ffe035ULL, 0x00017000375c7810ULL, 0x000fc60007ffe036ULL,
0x000000107f3c7824ULL, 0x100fe400078e027cULL, 0x000000107e347824ULL, 0x000fe400078e027cULL,
0x000000106d407824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff367819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000000836027836ULL, 0x000fe20000000000ULL, 0x0000541000357816ULL, 0x000fe20000000000ULL,
0x00000010363e7836ULL, 0x000fe40000000000ULL, 0x0000001836427836ULL, 0x000fe40000000000ULL,
0x00001f0235027589ULL, 0x0002a800000e0000ULL, 0x00001f3e35057589ULL, 0x0002e800000e0000ULL,
0x00001f3635037589ULL, 0x00026800000e0000ULL, 0x00001f4235007589ULL, 0x00026400000e0000ULL,
0x000000003c3c783bULL, 0x002e680000000200ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000107b5c7824ULL, 0x000fe200078e025cULL,
0x000000004040783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000010ff8e7819ULL, 0x028fe40000011640ULL, 0x000000ff40607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x0000ffff40907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff967819ULL, 0x000fe40000011642ULL, 0x00000010ff8d7819ULL, 0x104fe4000001165cULL,
0x000000ff5c977812ULL, 0x000fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fc4000001165cULL,
0x0000ffff5c877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x000fe40000011641ULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x00000010ff8c7819ULL, 0x000fe40000011643ULL,
0x000000ff5e7a7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff64723eULL, 0x000fc400020006ffULL,
0x00000018ff617819ULL, 0x100fe4000001165eULL, 0x00000096ff96723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe4000001165eULL,
0x0000ffff5e887812ULL, 0x000fe400078ec0ffULL, 0x00000018ff957819ULL, 0x000fe4000001165fULL,
0x000000ff41657812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x000000ff91917812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe40000011641ULL, 0x0000ffff41947812ULL, 0x000fe400078ec0ffULL,
0x000000ff42667812ULL, 0x000fc400078ec0ffULL, 0x00000010ff927819ULL, 0x000fe4000001165dULL,
0x000000ff5d987812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5d8a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x000fe4000001165fULL, 0x0000ffff5f867812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fc400020006ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x00000040ff5d723eULL, 0x000fe200020006ffULL,
0x20000096ff407230ULL, 0x000fe20000004100ULL, 0x00000061ff5f723eULL, 0x000fe400020006ffULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fc40000011642ULL, 0x0000ffff428b7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000005eff96723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x2000007aff5c7230ULL, 0x000fe20000004100ULL, 0x00000066ff42723eULL, 0x000fe200020006ffULL,
0x2000005fff7a7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000095ff5f7230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x20000091ff957230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000042ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe20000011687ULL,
0x2000008cff917230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x20000041ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe20000011690ULL,
0x20000097ff417230ULL, 0x000fe20000004100ULL, 0x0000008dff8c723eULL, 0x000fe200020006ffULL,
0x20000096ff617230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fc400020006ffULL,
0x00000092ff8d723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x000000ff43677812ULL, 0x000fe200078ec0ffULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x000000ff93977812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fc400078ec0ffULL,
0x000000ff89927812ULL, 0x000fe400078ec0ffULL, 0x00000008ff897819ULL, 0x000fe20000011688ULL,
0x20000087ff887230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff947819ULL, 0x000fe40000011694ULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x0000ffff438f7812ULL, 0x000fc400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000067ff43723eULL, 0x000fe200020006ffULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000092ff87723eULL, 0x000fe400020006ffULL, 0x00000089ff92723eULL, 0x000fe200020006ffULL,
0x2000008aff897230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x20000060ff8a7230ULL, 0x000fe20000004100ULL, 0x00000094ff96723eULL, 0x000fe200020006ffULL,
0x20000090ff947230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000092ff607230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe2000001168fULL,
0x20000097ff8f7230ULL, 0x000fe20000004100ULL, 0x00000008ff8b7819ULL, 0x000fe2000001168bULL,
0x2000008eff937230ULL, 0x000fe20000004100ULL, 0x00000010ff977819ULL, 0x000fe20000011667ULL,
0x20000063ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fe20000011666ULL,
0x20000096ff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe20000011695ULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000090ff96723eULL, 0x000fc400020006ffULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x2000008bff907230ULL, 0x000fe20000004100ULL,
0x0000105467677816ULL, 0x000fe20000000092ULL, 0x20000096ff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x000fe40000011665ULL, 0x00000098ff43723eULL, 0x000fe400020006ffULL,
0x00000010ff657819ULL, 0x000fe4000001168eULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fc40000011691ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff8f7819ULL, 0x000fe2000001168fULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000010548e637816ULL, 0x000fe40000000063ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff887819ULL, 0x000fc40000011688ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000010ff8e7819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fe4000001168bULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff897819ULL, 0x000fc40000011689ULL, 0x0000105462657816ULL, 0x000fe40000000065ULL,
0x00000010ff8b7819ULL, 0x000fe4000001165cULL, 0x000010548f627816ULL, 0x000fe40000000092ULL,
0x000010545d5c7816ULL, 0x000fe40000000088ULL, 0x0000105493667816ULL, 0x000fe40000000064ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x000000623c4c723cULL, 0x002fe2000004184cULL,
0x00000010ff8f7819ULL, 0x000fc40000011643ULL, 0x00000010ff887819ULL, 0x000fe40000011661ULL,
0x00000010ff937819ULL, 0x000fe20000011640ULL, 0x000000663c54723cULL, 0x000fe20000041854ULL,
0x00000010ff437819ULL, 0x000fe4000001168cULL, 0x000010545e5d7816ULL, 0x000fe40000000089ULL,
0x00000010ff617819ULL, 0x000fe2000001167aULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x00017000737a7836ULL, 0x000fe20000000000ULL,
0x00000010ff947819ULL, 0x000fc40000011694ULL, 0x00000010ff407819ULL, 0x000fe20000011690ULL,
0x0000005c3c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff8c7819ULL, 0x000fe4000001168dULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x00000010ff897819ULL, 0x000fe4000001165fULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x0000005c3420723cULL, 0x000fe20000041820ULL, 0x0000105443427816ULL, 0x000fe4000000008eULL,
0x0000105461607816ULL, 0x000fe40000000060ULL, 0x0000105497647816ULL, 0x000fe40000000094ULL,
0x0000105493407816ULL, 0x000fe40000000040ULL, 0x000010548c437816ULL, 0x000fc4000000008fULL,
0x000010548a5e7816ULL, 0x000fe2000000008bULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x00001054875f7816ULL, 0x000fe40000000088ULL, 0x0000105489617816ULL, 0x000fc60000000086ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x000000106f3c7824ULL, 0x000fca00078e027cULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x0000001072407824ULL, 0x000fe200078e027cULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000107d7c7824ULL, 0x000fc600078e027aULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x000fe20000041844ULL, 0x000000004034783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000010795c7824ULL, 0x000fe200078e027aULL, 0x000000007c40783bULL, 0x004eaa0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000010ff907819ULL, 0x104fe40000011640ULL,
0x000000ff40607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fc40000011640ULL,
0x0000ffff40927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff937819ULL, 0x100fe40000011641ULL,
0x000000ff41637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x0000ffff41947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff957819ULL, 0x000fc40000011642ULL,
0x000000ff42667812ULL, 0x040fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x0000ffff428e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8d7819ULL, 0x100fe40000011643ULL,
0x000000ff43677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fc40000011643ULL,
0x0000ffff438f7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff64723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x128fe4000001165cULL, 0x000000ff5c657812ULL, 0x040fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff437819ULL, 0x000fe4000001165cULL,
0x0000ffff5c8a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff917819ULL, 0x100fe4000001165dULL,
0x000000ff5d977812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x000fe4000001165eULL,
0x000000ff5e867812ULL, 0x000fc400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe4000001165eULL,
0x0000ffff5e897812ULL, 0x000fe400078ec0ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff887819ULL, 0x100fe4000001165fULL, 0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff967819ULL, 0x000fc4000001165fULL, 0x0000ffff5f877812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000066ff5d723eULL, 0x000fe400020006ffULL,
0x00000067ff5f723eULL, 0x000fe200020006ffULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fe200020006ffULL, 0x2000005dff627230ULL, 0x000fe20000004100ULL,
0x00000065ff5d723eULL, 0x000fe200020006ffULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x00000043ff5f723eULL, 0x000fe200020006ffULL, 0x20000041ff657230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000005dff417230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x2000005fff5d7230ULL, 0x000fe20000004100ULL,
0x00000061ff5f723eULL, 0x000fe200020006ffULL, 0x20000097ff437230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fc400020006ffULL, 0x0000005eff97723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff927819ULL, 0x000fe20000011692ULL,
0x20000086ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff90907812ULL, 0x000fe200078ec0ffULL,
0x2000005fff867230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000096ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff967819ULL, 0x000fe20000011694ULL,
0x20000097ff617230ULL, 0x000fe20000004100ULL, 0x000000ff95977812ULL, 0x000fe200078ec0ffULL,
0x20000092ff957230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x00000008ff927819ULL, 0x000fe4000001168fULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x20000097ff8f7230ULL, 0x000fe20000004100ULL, 0x00000093ff94723eULL, 0x000fe200020006ffULL,
0x20000090ff937230ULL, 0x000fe20000004100ULL, 0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL,
0x20000096ff907230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168eULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000092ff96723eULL, 0x000fe200020006ffULL,
0x2000008dff927230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x0000008cff8d723eULL, 0x000fe200020006ffULL, 0x20000096ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fe2000001168aULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x000000ff91977812ULL, 0x000fe200078ec0ffULL, 0x2000008eff917230ULL, 0x000fe20000004100ULL,
0x00000008ff8b7819ULL, 0x000fc4000001168bULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff88967812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x00000008ff887819ULL, 0x000fe20000011689ULL, 0x2000008aff897230ULL, 0x000fe20000004100ULL,
0x000010548f627816ULL, 0x000fe40000000062ULL, 0x00000097ff8e723eULL, 0x000fc400020006ffULL,
0x00000008ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff8f7819ULL, 0x000fe20000011641ULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000096ff97723eULL, 0x000fe400020006ffULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x2000008bff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fc4000001168cULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000010ff8c7819ULL, 0x000fe4000001168dULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000060ff8b7230ULL, 0x000fe20000004100ULL,
0x00000088ff96723eULL, 0x000fe200020006ffULL, 0x20000097ff887230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x0000105442417816ULL, 0x000fe20000000041ULL, 0x20000096ff607230ULL, 0x000fe20000004100ULL,
0x000010548c427816ULL, 0x000fe2000000008fULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff977819ULL, 0x000fc40000011666ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000010ff8c7819ULL, 0x000fe4000001165dULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff967819ULL, 0x000fe40000011667ULL, 0x00000010ff8d7819ULL, 0x000fe4000001165cULL,
0x0000105494677816ULL, 0x000fc40000000097ULL, 0x000010548c5c7816ULL, 0x000fe40000000089ULL,
0x00000010ff947819ULL, 0x000fe40000011665ULL, 0x00000010ff897819ULL, 0x000fe40000011661ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff407819ULL, 0x000fc40000011640ULL, 0x00000010ff657819ULL, 0x000fe40000011690ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff5d7819ULL, 0x000fe4000001168aULL,
0x00000010ff617819ULL, 0x000fe40000011686ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff957819ULL, 0x000fc40000011695ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8a7819ULL, 0x000fc4000001168bULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff867819ULL, 0x000fe4000001165fULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x0000105493667816ULL, 0x000fe40000000064ULL, 0x0000105440657816ULL, 0x000fe40000000065ULL,
0x000010545e5d7816ULL, 0x000fc4000000005dULL, 0x0000105461607816ULL, 0x000fe20000000060ULL,
0x000000663c54723cULL, 0x002fe20000041854ULL, 0x0000105496647816ULL, 0x000fe40000000095ULL,
0x0000105492637816ULL, 0x000fe40000000063ULL, 0x0000105494407816ULL, 0x000fe20000000091ULL,
0x0000005c3c2c723cULL, 0x000fe2000004182cULL, 0x000010548e437816ULL, 0x000fe40000000043ULL,
0x000010548a5e7816ULL, 0x000fc4000000008dULL, 0x00001054885f7816ULL, 0x000fe20000000089ULL,
0x000000643c48723cULL, 0x000fe20000041848ULL, 0x0000105486617816ULL, 0x000fca0000000087ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x00000002713d7824ULL, 0x000fe200078e00ffULL, 0x0000000a6a3c7c11ULL, 0x000fe2000f8e18ffULL,
0x00000001ff3f7424ULL, 0x000fc600078e00ffULL, 0xfffffff83d3e7812ULL, 0x000fe200078ec0ffULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x01a6c83f3c3c79a7ULL, 0x00026a000850003fULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x01a6903f3eff79a7ULL, 0x0003ea000850000aULL,
0x000000403418723cULL, 0x000fec0000041818ULL, 0x00000042341c723cULL, 0x000fec000004181cULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x002fde0000041844ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff347b82ULL, 0x000e620000000a00ULL, 0x0000001071367824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000481817c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe0363c7812ULL, 0x000fe400078ec0ffULL, 0x0000004081817824ULL, 0x000fc600078e00ffULL,
0x00000100073c7824ULL, 0x000fc800078e023cULL, 0x000000c03c3d7836ULL, 0x000fca0000000000ULL,
0x000000203d377812ULL, 0x000fe200078ec0ffULL, 0x0000008081347825ULL, 0x002fc800078e0034ULL,
0x0000000158417824ULL, 0x000fe200078e0237ULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x0000001036377812ULL, 0x000fe400078ec0ffULL, 0x0000003d74367248ULL, 0x000fe40007fe0000ULL,
0x00000003ff3c7819ULL, 0x000fc6000001160aULL, 0x0000000136367824ULL, 0x000fe400078e0a3dULL,
0x000000013c3d7824ULL, 0x100fe400078e0237ULL, 0x000000043c3f7836ULL, 0x000fe20000000000ULL,
0x0000003637367248ULL, 0x000fe20007fe0000ULL, 0x000000013d3e7824ULL, 0x040fe400078e020aULL,
0x000000083d5f7824ULL, 0x000fe400078e00ffULL, 0x0000000136367824ULL, 0x000fc400078e0a37ULL,
0x000000083c407836ULL, 0x000fe20000000000ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee23eULL,
0x000000013f3e7824ULL, 0x040fe200078e0237ULL, 0x000000363c00720cULL, 0x080fe20003f86070ULL,
0x0000000c3c427836ULL, 0x000fe20000000000ULL, 0x000000363f00720cULL, 0x080fe20003f66070ULL,
0x000000013d3c7824ULL, 0x000fe200078e0241ULL, 0x000000364000720cULL, 0x080fe20003f46070ULL,
0x000000013e3d7824ULL, 0x000fe200078e020aULL, 0x000000364200720cULL, 0x000fe20003f06070ULL,
0x000000083e5e7824ULL, 0x000fc400078e00ffULL, 0x00000001403f7824ULL, 0x000fe400078e0237ULL,
0x000000013e3e7824ULL, 0x000fe200078e0241ULL, 0xfffffff85e617812ULL, 0x000fe200078ee23dULL,
0x000000803c3c7825ULL, 0x000fc800078e00ffULL, 0x00000001425c7824ULL, 0x000fe200078e0237ULL,
0x000000693c377212ULL, 0x000fe200078efcffULL, 0x000000013f407824ULL, 0x040fe400078e0241ULL,
0x000000013f427824ULL, 0x040fe200078e020aULL, 0x00000037343c7210ULL, 0x000fe20007fbe0ffULL,
0x000000083f637824ULL, 0x000fe400078e00ffULL, 0x000000803e3e7825ULL, 0x000fc600078e00ffULL,
0xfffffff863637812ULL, 0x000fe200078ee242ULL, 0x000000015c367824ULL, 0x000fe200078e0241ULL,
0x000000693e437212ULL, 0x000fe200078efcffULL, 0x0000008040407825ULL, 0x000fc800078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000069405d7212ULL, 0x000fc600078efcffULL,
0x00000001353d7824ULL, 0x040fe200028e063dULL, 0x00000043343e7210ULL, 0x000fe20007fbe0ffULL,
0x000000015c427824ULL, 0x000fe200078e020aULL, 0x0000006936437212ULL, 0x000fe200078efcffULL,
0x000000085c657824ULL, 0x000fe400078e00ffULL, 0x00000001353f7824ULL, 0x000fe200028e063fULL,
0x0000005d34407210ULL, 0x000fe20007fbe0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0x0000004334347210ULL, 0x000fe20007fde0ffULL, 0x0000001061617824ULL, 0x100fe200078e027aULL,
0xfffffff865437812ULL, 0x000fe200078ee242ULL, 0x0000000135417824ULL, 0x000fe200028e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c5f7faeULL, 0x0003e2000e101c46ULL,
0x0000001063637824ULL, 0x000fc400078e027aULL, 0x0000000135357824ULL, 0x000fe200030e0637ULL,
0x000000003e617faeULL, 0x0003e2000d901c46ULL, 0x0000001043437824ULL, 0x000fc600078e027aULL,
0x0000000040637faeULL, 0x0003e8000d101c46ULL, 0x0000000034437faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x0000001036377812ULL, 0x000fc800078ec0ffULL,
0x000000370a377211ULL, 0x000fca00078fe8ffULL, 0x00000004373e7836ULL, 0x000fe40000000000ULL,
0x0000000837407836ULL, 0x000fe40000000000ULL, 0x000000013e3c7824ULL, 0x140fe400078e020aULL,
0x000000083e637824ULL, 0x000fe400078e00ffULL, 0x00000001403d7824ULL, 0x040fe400078e020aULL,
0x0000000840427824ULL, 0x000fe200078e00ffULL, 0xfffffff863637812ULL, 0x000fe200078ee23cULL,
0x00000001373c7824ULL, 0x000fc400078e0241ULL, 0x0000000137367824ULL, 0x040fe200078e020aULL,
0xfffffff842657812ULL, 0x000fe200078ee23dULL, 0x0000000837617824ULL, 0x000fe400078e00ffULL,
0x0000000c37377836ULL, 0x000fe40000000000ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fc600078ee236ULL, 0x000000013e3e7824ULL, 0x100fe200078e0241ULL,
0x000000693c437212ULL, 0x000fe200078efcffULL, 0x0000000140407824ULL, 0x100fe400078e0241ULL,
0x0000000137367824ULL, 0x000fe200078e0241ULL, 0x00000043343c7210ULL, 0x000fe20007f1e0ffULL,
0x000000803e3e7825ULL, 0x000fc800078e00ffULL, 0x0000000137427824ULL, 0x040fe200078e020aULL,
0x000000693e5f7212ULL, 0x080fe200078efcffULL, 0x0000000837677824ULL, 0x000fe400078e00ffULL,
0x0000008040407825ULL, 0x000fe200078e00ffULL, 0x0000005f343e7210ULL, 0x000fe40007f5e0ffULL,
0xfffffff867677812ULL, 0x000fe200078ee242ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000069405d7212ULL, 0x000fc600078efcffULL, 0x00000001353d7824ULL, 0x000fe200000e063dULL,
0x0000006936437212ULL, 0x000fe200078efcffULL, 0x0000001061617824ULL, 0x100fe200078e027aULL,
0x0000005d34407210ULL, 0x000fe20007f1e0ffULL, 0x00000001353f7824ULL, 0x000fe200010e063fULL,
0x0000004334347210ULL, 0x000fe20007f7e0ffULL, 0x0000001063637824ULL, 0x100fe200078e027aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c617faeULL, 0x0003e2000b901c46ULL,
0x0000000135417824ULL, 0x000fe400000e0641ULL, 0x0000001065657824ULL, 0x000fe200078e027aULL,
0x000000003e637faeULL, 0x0003e2000b901c46ULL, 0x0000000135357824ULL, 0x000fc400018e0637ULL,
0x0000001067677824ULL, 0x000fe200078e027aULL, 0x0000000040657faeULL, 0x0003e8000b901c46ULL,
0x0000000034677faeULL, 0x0003e4000b901c46ULL, 0x0000000359377836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000703700720cULL, 0x000fe20003f06070ULL,
0x0000000871367824ULL, 0x000fca00078e00ffULL, 0xfffffff036367812ULL, 0x000fca00078ec0ffULL,
0x0000000a36867c36ULL, 0x000fe40008000000ULL, 0x00009000ff348b82ULL, 0x002e620000000a00ULL,
0x0000000108378824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000860472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000437348825ULL, 0x002fd000078e0034ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x0000000634818981ULL, 0x000322000c1e1900ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x01a6b037868679a7ULL, 0x0004e2000850003fULL,
0x01a64837803479a7ULL, 0x002464000850003fULL, 0x0000000000367805ULL, 0x004fce0000015200ULL,
0x01a64835800075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c363f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e37ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a64835800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002071347824ULL, 0x000fe400078e00ffULL,
0x0000000aff357e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0xffffff8034347812ULL, 0x000fc800078ec0ffULL, 0x0000010035347810ULL, 0x000fc80007ffe034ULL,
0x000000346e347210ULL, 0x000fca0007ffe069ULL, 0x01a0000034367984ULL, 0x000e680000000800ULL,
0x01a2000034357984ULL, 0x0004a20000000800ULL, 0x000000833600720bULL, 0x002fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fc800000e0100ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x00cfea0003800000ULL, 0x000000025a347836ULL, 0x000fe20000000000ULL,
0x000000833600720bULL, 0x000fc80003f14000ULL, 0x000000713400720cULL, 0x000fda0003f45270ULL,
0x0000000a713cac11ULL, 0x000fe4000f8e38ffULL, 0x000000833634a209ULL, 0x000fe40007810000ULL,
0x0000003c6e3da210ULL, 0x000fe40007ffe069ULL, 0x00000000003c7806ULL, 0x000fc600000e0100ULL,
0x01a400343d00a388ULL, 0x0003e20000000800ULL, 0x000000ff3c00720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000008336347209ULL, 0x000fe40007810000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x0000008334347221ULL, 0x000fe20000010100ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc000001160aULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000005434547220ULL, 0x042fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x004e6400000e0000ULL, 0x0000005634567220ULL, 0x042fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000000c340c7220ULL, 0x042fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003d82827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x000e6400000e0000ULL,
0x0000000e340e7220ULL, 0x042fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003c37ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000008336837209ULL, 0x000fd60007810000ULL, 0x8000008336360221ULL, 0x000fe20000010000ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x004fce0000410000ULL,
0x0000008235827221ULL, 0x000fce0000010000ULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x0000000871807824ULL, 0x000fca00078e00ffULL, 0xfffffff080377812ULL, 0x000fc800078ec0ffULL,
0x01a6a885370075a7ULL, 0x000e62000800014aULL, 0x0000000a373f7c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6a8853f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099103c347816ULL, 0x000fe200000000ffULL, 0x0000040071357824ULL, 0x040fe400078e00ffULL,
0x0000100071367824ULL, 0x000fe200078e00ffULL, 0x000000ff3400720cULL, 0x000fe20003f05270ULL,
0x0000000aff847e24ULL, 0x000fe2000f8e00ffULL, 0xfffff00035357812ULL, 0x000fe200078ec0ffULL,
0x0000000aff377e24ULL, 0x000fe2000f8e00ffULL, 0xffffe00036367812ULL, 0x000fe400078ec0ffULL,
0x0001400084847810ULL, 0x000fc40007ffe035ULL, 0x00016000375c7810ULL, 0x000fc60007ffe036ULL,
0x000000107f3c7824ULL, 0x100fe400078e0284ULL, 0x000000107e347824ULL, 0x000fe400078e0284ULL,
0x000000106d417824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff367819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000000836027836ULL, 0x000fe20000000000ULL, 0x0000541000357816ULL, 0x000fe20000000000ULL,
0x00000010363e7836ULL, 0x000fe40000000000ULL, 0x0000001836407836ULL, 0x000fe40000000000ULL,
0x00001f0235027589ULL, 0x0002a800000e0000ULL, 0x00001f3e35057589ULL, 0x0002e800000e0000ULL,
0x00001f3635037589ULL, 0x00026800000e0000ULL, 0x00001f4035007589ULL, 0x00026400000e0000ULL,
0x000000003c3c783bULL, 0x002e680000000200ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000107b5c7824ULL, 0x000fe200078e025cULL,
0x000000004140783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x000000ff40607812ULL, 0x028fe400078ec0ffULL, 0x00000010ff927819ULL, 0x000fc40000011640ULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x0000ffff40917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x104fe4000001165cULL, 0x000000ff5c967812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe4000001165cULL, 0x0000ffff5c7f7812ULL, 0x000fc400078ec0ffULL,
0x00000060ff64723eULL, 0x000fe400020006ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x000000ff5e607812ULL, 0x040fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x100fe4000001165eULL, 0x00000018ff617819ULL, 0x000fe4000001165eULL,
0x0000ffff5e857812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff947819ULL, 0x100fe4000001165fULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000010ff887819ULL, 0x000fe4000001165fULL,
0x0000ffff5f7e7812ULL, 0x000fc400078ec0ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x0000005eff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x20000060ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff41657812ULL, 0x000fe200078ec0ffULL, 0x20000061ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x100fe20000011641ULL, 0x2000005fff617230ULL, 0x000fe20000004100ULL,
0x000000ff42667812ULL, 0x000fe200078ec0ffULL, 0x20000094ff5f7230ULL, 0x000fe20000004100ULL,
0x00000018ff637819ULL, 0x000fc40000011641ULL, 0x0000ffff41937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x100fe40000011642ULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x0000ffff428a7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000066ff42723eULL, 0x000fc400020006ffULL, 0x000000ff90947812ULL, 0x000fe200078ec0ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe20000011691ULL,
0x20000042ff657230ULL, 0x000fe20000004100ULL, 0x00000018ff957819ULL, 0x100fe40000011643ULL,
0x00000010ff8b7819ULL, 0x000fe40000011643ULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x00000090ff90723eULL, 0x000fc400020006ffULL, 0x00000095ff42723eULL, 0x000fe400020006ffULL,
0x00000008ff957819ULL, 0x000fe40000011693ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff438d7812ULL, 0x000fe400078ec0ffULL, 0x00000092ff91723eULL, 0x000fe200020006ffULL,
0x20000090ff927230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fc400020006ffULL,
0x0000008fff90723eULL, 0x000fe200020006ffULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x000000ff43677812ULL, 0x000fe200078ec0ffULL, 0x20000095ff8f7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000094ff93723eULL, 0x000fe400020006ffULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fc4000001165dULL,
0x00000008ff947819ULL, 0x000fe2000001168dULL, 0x20000090ff8d7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x2000008bff907230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5d897812ULL, 0x000fe400078ec0ffULL,
0x00000067ff43723eULL, 0x000fe200020006ffULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fc400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff5d977812ULL, 0x000fe400078ec0ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x000000ff8e957812ULL, 0x000fe200078ec0ffULL, 0x2000008aff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff7f7819ULL, 0x000fe2000001167fULL, 0x20000094ff8a7230ULL, 0x000fe20000004100ULL,
0x00000040ff5d723eULL, 0x000fe200020006ffULL, 0x20000041ff407230ULL, 0x000fe20000004100ULL,
0x0000008cff8b723eULL, 0x000fe200020006ffULL, 0x20000096ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000095ff8c723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fc400020006ffULL, 0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff957819ULL, 0x000fe40000011667ULL,
0x00000008ff947819ULL, 0x000fe20000011685ULL, 0x2000007fff857230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe40000011693ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x000000ff88887812ULL, 0x000fe200078ec0ffULL,
0x20000063ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fe20000011640ULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000010ff407819ULL, 0x000fe4000001168dULL, 0x00000010ff8d7819ULL, 0x000fe40000011641ULL,
0x00000094ff7f723eULL, 0x000fc400020006ffULL, 0x00000008ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe4000001168aULL, 0x00000088ff94723eULL, 0x000fe200020006ffULL,
0x20000089ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168bULL,
0x2000007bff897230ULL, 0x000fe20000004100ULL, 0x00000097ff43723eULL, 0x000fe200020006ffULL,
0x20000094ff7b7230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fc400020006ffULL,
0x0000105442417816ULL, 0x000fe20000000041ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000010548a427816ULL, 0x000fe2000000008dULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff8a7819ULL, 0x000fe4000001165dULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff5d7819ULL, 0x000fe40000011688ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff8b7819ULL, 0x000fe4000001165cULL, 0x00000010ff887819ULL, 0x000fe40000011689ULL,
0x00000010ff947819ULL, 0x000fe40000011666ULL, 0x0000105491667816ULL, 0x000fc40000000064ULL,
0x00000010ff917819ULL, 0x000fe40000011665ULL, 0x000010545e5d7816ULL, 0x000fe4000000005dULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff657819ULL, 0x000fe4000001168fULL,
0x000010548a5c7816ULL, 0x000fe40000000085ULL, 0x00001054885e7816ULL, 0x000fc4000000008bULL,
0x00000010ff857819ULL, 0x000fe40000011660ULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x0000005c3c2c723cULL, 0x002fe2000004182cULL, 0x00000010ff887819ULL, 0x000fe4000001167bULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x0000005c3420723cULL, 0x000fe20000041820ULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff607819ULL, 0x000fe4000001167fULL,
0x00000010ff7b7819ULL, 0x000fe4000001165fULL, 0x00000010ff7e7819ULL, 0x000fc4000001167eULL,
0x0000105462657816ULL, 0x000fe40000000065ULL, 0x0000105440627816ULL, 0x000fe40000000091ULL,
0x00001054885f7816ULL, 0x000fe40000000061ULL, 0x0000105467677816ULL, 0x000fe40000000094ULL,
0x0000105495647816ULL, 0x000fe40000000092ULL, 0x0000105490637816ULL, 0x000fe20000000063ULL,
0x0000005e3c28723cULL, 0x000fe20000041828ULL, 0x0000105493407816ULL, 0x000fc4000000008eULL,
0x000010548c437816ULL, 0x000fe40000000043ULL, 0x0000105485607816ULL, 0x000fe20000000060ULL,
0x000000663c54723cULL, 0x000fe20000041854ULL, 0x000010547b617816ULL, 0x000fe2000000007eULL,
0x00016000737e7836ULL, 0x000fc80000000000ULL, 0x000000643c48723cULL, 0x000fec0000041848ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x00000066340c723cULL, 0x000fe2000004180cULL, 0x000000106f3c7824ULL, 0x000fc400078e0284ULL,
0x0000001072847824ULL, 0x000fc600078e0284ULL, 0x000000643410723cULL, 0x000fe20000041810ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x000000623414723cULL, 0x000fec0000041814ULL,
0x000000403418723cULL, 0x000fec0000041818ULL, 0x00000042341c723cULL, 0x000fe2000004181cULL,
0x000000107d417824ULL, 0x000fca00078e027eULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x000fe20000041844ULL, 0x000000008434783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000010795c7824ULL, 0x000fe200078e027eULL, 0x000000004140783bULL, 0x000f6a0000004200ULL,
0x000000005c5c783bULL, 0x000f640000004200ULL, 0x0000ffff418d7812ULL, 0x024fe400078ec0ffULL,
0x00000010ff907819ULL, 0x000fc40000011640ULL, 0x00000010ff8c7819ULL, 0x000fe40000011642ULL,
0x00000010ff8a7819ULL, 0x108fe4000001165cULL, 0x000000ff5c937812ULL, 0x040fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe4000001165cULL, 0x0000ffff5c7f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x000fc4000001165dULL, 0x000000ff5d947812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d847812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e5d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff917819ULL, 0x100fe4000001165fULL,
0x00000010ff7d7819ULL, 0x000fc4000001165fULL, 0x000000ff5f617812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5f797812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5f723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff40607812ULL, 0x040fe200078ec0ffULL,
0x2000005fff5c7230ULL, 0x000fe20000004100ULL, 0x0000ffff408e7812ULL, 0x000fe200078ec0ffULL,
0x20000091ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff917819ULL, 0x000fc4000001168dULL,
0x0000ffff42857812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011640ULL,
0x0000ffff43897812ULL, 0x000fe400078ec0ffULL, 0x000000ff42647812ULL, 0x000fe400078ec0ffULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x000000ff41637812ULL, 0x000fc400078ec0ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x100fe40000011641ULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x00000060ff67723eULL, 0x000fe400020006ffULL, 0x00000008ff8e7819ULL, 0x000fc4000001168eULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x00000010ff887819ULL, 0x000fe40000011643ULL,
0x000000ff43667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe4000001165eULL,
0x00000018ff607819ULL, 0x000fc4000001165eULL, 0x0000ffff5e7b7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x00000064ff42723eULL, 0x000fe400020006ffULL, 0x00000092ff5e723eULL, 0x000fe400020006ffULL,
0x00000090ff8d723eULL, 0x000fc400020006ffULL, 0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x0000008cff90723eULL, 0x000fe200020006ffULL,
0x20000091ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff8b927812ULL, 0x000fe200078ec0ffULL,
0x20000063ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff657819ULL, 0x000fe40000011643ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000066ff43723eULL, 0x000fe200020006ffULL, 0x20000062ff667230ULL, 0x000fe20000004100ULL,
0x000000ff88917812ULL, 0x000fe200078ec0ffULL, 0x20000042ff627230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000090ff887230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000085ff907230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000043ff637230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000089ff857230ULL, 0x000fe20000004100ULL,
0x00000065ff42723eULL, 0x000fe200020006ffULL, 0x20000041ff657230ULL, 0x000fe20000004100ULL,
0x00000008ff7f7819ULL, 0x000fe2000001167fULL, 0x2000008aff897230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000093ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x20000092ff8a7230ULL, 0x000fe20000004100ULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x20000091ff8b7230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x00000010ff927819ULL, 0x000fe40000011664ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe4000001168eULL,
0x000000ff7d917812ULL, 0x000fe200078ec0ffULL, 0x2000007fff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe20000011663ULL, 0x20000084ff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff847230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fc4000001167bULL, 0x00000008ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff637819ULL, 0x000fe40000011688ULL, 0x00000010ff887819ULL, 0x000fe40000011641ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff417819ULL, 0x000fe40000011685ULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000094ff43723eULL, 0x000fe200020006ffULL, 0x20000091ff737230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000105489427816ULL, 0x000fe20000000088ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff887819ULL, 0x000fe4000001165dULL,
0x00000010ff857819ULL, 0x000fe4000001165cULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff5d7819ULL, 0x000fe4000001167fULL, 0x00000010ff917819ULL, 0x000fe40000011666ULL,
0x00000010ff667819ULL, 0x000fc4000001168dULL, 0x000010545e5c7816ULL, 0x000fe4000000007dULL,
0x00000010ff8d7819ULL, 0x000fe40000011665ULL, 0x00001054845e7816ULL, 0x000fe40000000085ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff657819ULL, 0x000fe4000001168cULL,
0x00001054885d7816ULL, 0x000fe4000000005dULL, 0x00000010ff7d7819ULL, 0x000fe40000011660ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff847819ULL, 0x000fe20000011673ULL,
0x0000005c3c2c723cULL, 0x002fe2000004182cULL, 0x00000010ff8f7819ULL, 0x000fc4000001168fULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff907819ULL, 0x000fe20000011690ULL,
0x0000005c3420723cULL, 0x000fe20000041820ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff607819ULL, 0x000fe4000001167bULL,
0x00000010ff887819ULL, 0x000fc4000001165fULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x0000105466667816ULL, 0x000fe40000000067ULL, 0x0000105440657816ULL, 0x000fe40000000065ULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x00001054845f7816ULL, 0x000fe40000000061ULL,
0x000010548f677816ULL, 0x000fc40000000092ULL, 0x0000105491647816ULL, 0x000fe40000000064ULL,
0x000010548b637816ULL, 0x000fe2000000008eULL, 0x0000005e3c28723cULL, 0x000fe20000041828ULL,
0x000010548d407816ULL, 0x000fe40000000090ULL, 0x000010548a437816ULL, 0x000fe40000000043ULL,
0x000010547d607816ULL, 0x000fe20000000060ULL, 0x000000663c54723cULL, 0x000fe20000041854ULL,
0x0000105488617816ULL, 0x000fca0000000079ULL, 0x000000643c48723cULL, 0x000fec0000041848ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x00000002713c7824ULL, 0x000fc400078e00ffULL,
0x00000001ff3f7424ULL, 0x000fc600078e00ffULL, 0xfffffff83c3e7812ULL, 0x000fe200078ec0ffULL,
0x00000066340c723cULL, 0x000fe2000004180cULL, 0x0000000a6a417c11ULL, 0x000fc8000f8e18ffULL,
0x01a6c83f413c79a7ULL, 0x000262000850003fULL, 0x000000643410723cULL, 0x000fec0000041810ULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x01a6983f3eff79a7ULL, 0x0003ea000850000aULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x002fde0000041844ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a6c83d410075a7ULL, 0x000e62000800017fULL,
0x000000035a3e7836ULL, 0x000fc80000000000ULL, 0x000000ffff367224ULL, 0x000fe200078e003eULL,
0x0000000000600947ULL, 0x002fec0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x01a6c83d410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ffff367224ULL, 0x000fce00078e003eULL, 0x00000001073c7836ULL, 0x000fe40000000000ULL,
0x0000000359597836ULL, 0x000fc60000000000ULL, 0x0000006b3c00720cULL, 0x000fda0003f06070ULL,
0x0000000800080947ULL, 0x000fea0003800000ULL, 0x00008e00ff347b82ULL, 0x000e620000000a00ULL,
0x000001003c3d7824ULL, 0x000fe200078e025bULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x00000002073c7836ULL, 0x000fe40000000000ULL, 0x0000000481817c24ULL, 0x010fe2000f8e02ffULL,
0x000000203d377812ULL, 0x000fe400078ec0ffULL, 0x0000006b3c00720cULL, 0x000fe20003f06070ULL,
0x0000004081817824ULL, 0x000fe400078e00ffULL, 0x0000000158427824ULL, 0x000fc400078e0237ULL,
0x0000008081347825ULL, 0x002fd000078e0034ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x0000003d74377248ULL, 0x000fe20007fe0000ULL, 0x00000010713c7824ULL, 0x000fc800078e00ffULL,
0x0000000137377824ULL, 0x000fe200078e0a3dULL, 0x000000103c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff3d7819ULL, 0x000fe4000001160aULL, 0x000000373c377248ULL, 0x000fc60007fe0000ULL,
0x000000043d3e7836ULL, 0x000fe40000000000ULL, 0x0000000137377824ULL, 0x100fe400078e0a3cULL,
0x000000083d407836ULL, 0x000fe40000000000ULL, 0x0000000c3d417836ULL, 0x000fe20000000000ULL,
0x000000373d00720cULL, 0x0c0fe20003f86070ULL, 0x000000013d3d7824ULL, 0x100fe200078e023cULL,
0x000000373e00720cULL, 0x0c0fe20003f66070ULL, 0x000000013e3f7824ULL, 0x000fe200078e023cULL,
0x000000374000720cULL, 0x0c0fe20003f46070ULL, 0x000000013d3e7824ULL, 0x000fe200078e0242ULL,
0x000000374100720cULL, 0x000fe20003f06070ULL, 0x0000000140437824ULL, 0x000fc400078e023cULL,
0x0000000141597824ULL, 0x000fe400078e023cULL, 0x000000013f3c7824ULL, 0x040fe400078e020aULL,
0x000000083f5f7824ULL, 0x040fe400078e00ffULL, 0x000000013f407824ULL, 0x000fe400078e0242ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fc600078ee23cULL,
0x000000013d377824ULL, 0x140fe400078e020aULL, 0x000000083d5c7824ULL, 0x000fe400078e00ffULL,
0x00000001433d7824ULL, 0x040fe400078e020aULL, 0x00000008435e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee237ULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff85e617812ULL, 0x000fe200078ee23dULL, 0x00000001433c7824ULL, 0x100fe200078e0242ULL,
0x000000693e437212ULL, 0x080fe200078efcffULL, 0x0000000159427824ULL, 0x000fe200078e0242ULL,
0x0000006940377212ULL, 0x000fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x00000043343e7210ULL, 0x000fe40007fbe0ffULL, 0x0000003734407210ULL, 0x000fe20007fde0ffULL,
0x0000008042427825ULL, 0x000fc800078e00ffULL, 0x00000001595c7824ULL, 0x040fe200078e020aULL,
0x0000006942377212ULL, 0x080fe200078efcffULL, 0x0000000859637824ULL, 0x000fe200078e00ffULL,
0x000000693c597212ULL, 0x000fe200078efcffULL, 0x00000001353f7824ULL, 0x040fe400028e063fULL,
0x0000000135417824ULL, 0x000fe200030e0641ULL, 0x00000059343c7210ULL, 0x000fe20007fbe0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e027eULL, 0xfffffff863637812ULL, 0x000fe200078ee25cULL,
0x000000105f5f7824ULL, 0x100fe200078e027eULL, 0x0000003734347210ULL, 0x000fe20007fde0ffULL,
0x0000001061617824ULL, 0x000fe200078e027eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e5d7faeULL, 0x0003e2000e101c46ULL, 0x00000001353d7824ULL, 0x000fc400028e063dULL,
0x0000001063637824ULL, 0x000fe200078e027eULL, 0x00000000405f7faeULL, 0x0003e2000d901c46ULL,
0x0000000135357824ULL, 0x000fc600030e0643ULL, 0x000000003c617faeULL, 0x0003e8000d101c46ULL,
0x0000000034637faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001071377824ULL, 0x000fca00078e00ffULL, 0x0000001037377812ULL, 0x000fc800078ec0ffULL,
0x000000370a377211ULL, 0x000fca00078fe8ffULL, 0x00000001373d7824ULL, 0x040fe400078e020aULL,
0x00000008373e7824ULL, 0x040fe400078e00ffULL, 0x00000001373c7824ULL, 0x000fe400078e0242ULL,
0x00000004373f7836ULL, 0x000fe20000000000ULL, 0xfffffff83e597812ULL, 0x000fe200078ee23dULL,
0x0000000837437836ULL, 0x000fe40000000000ULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x0000000c375d7836ULL, 0x000fe20000000000ULL, 0x000000693c377212ULL, 0x000fe200078efcffULL,
0x000000013f3e7824ULL, 0x040fe400078e0242ULL, 0x000000013f417824ULL, 0x140fe200078e020aULL,
0x00000037343c7210ULL, 0x000fe20007f1e0ffULL, 0x000000083f5c7824ULL, 0x000fe400078e00ffULL,
0x00000001433f7824ULL, 0x040fe400078e020aULL, 0x00000008435e7824ULL, 0x040fe200078e00ffULL,
0xfffffff85c377812ULL, 0x000fe200078ee241ULL, 0x0000000143407824ULL, 0x000fc400078e0242ULL,
0x000000015d437824ULL, 0x040fe200078e020aULL, 0xfffffff85e637812ULL, 0x000fe200078ee23fULL,
0x000000085d607824ULL, 0x040fe400078e00ffULL, 0x000000015d427824ULL, 0x000fe400078e0242ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0xfffffff860657812ULL, 0x000fc600078ee243ULL,
0x0000008040407825ULL, 0x000fe200078e00ffULL, 0x000000693e5d7212ULL, 0x000fc600078efcffULL,
0x0000008042427825ULL, 0x000fc800078e00ffULL, 0x00000010595f7824ULL, 0x100fe200078e027eULL,
0x0000006940597212ULL, 0x080fe200078efcffULL, 0x0000001037617824ULL, 0x100fe200078e027eULL,
0x0000006942377212ULL, 0x000fe200078efcffULL, 0x00000001353d7824ULL, 0x000fe200000e063dULL,
0x0000005d343e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001063637824ULL, 0x100fe200078e027eULL,
0x0000005934407210ULL, 0x000fe20007f5e0ffULL, 0x0000001065657824ULL, 0x000fe200078e027eULL,
0x0000003734347210ULL, 0x000fe20007f7e0ffULL, 0x00000001353f7824ULL, 0x040fe200000e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c5f7faeULL, 0x0003e2000b901c46ULL,
0x0000000135417824ULL, 0x000fc400010e0641ULL, 0x0000000135357824ULL, 0x000fe200018e0643ULL,
0x000000003e617faeULL, 0x0003e8000b901c46ULL, 0x0000000040637faeULL, 0x0003e8000b901c46ULL,
0x0000000034657faeULL, 0x0003e4000b901c46ULL, 0x000000046c597836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000705900720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009000ff347b82ULL, 0x002e620000000a00ULL,
0x0000000108377824ULL, 0x000fc800078e0259ULL, 0x0000000437347825ULL, 0x002fca00078e0034ULL,
0x0000000634817981ULL, 0x000324000c1e1900ULL, 0xfffffff080807812ULL, 0x000fe200078ec0ffULL,
0x00000001ff3e7424ULL, 0x002fc800078e00ffULL, 0x0000000a80347c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000000340472caULL, 0x000fda00000e0000ULL,
0x0001a6a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01a6a83e343479a7ULL, 0x0002a4000850003fULL,
0x01a6683e093e79a7ULL, 0x0022e4000850003fULL, 0x000000ffff797224ULL, 0x006fce00078e0035ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a6683f090075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000003c343c7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e35ULL, 0x003d09003c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143dULL,
0x0000003c37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3c7224ULL, 0x000fca00000e063dULL,
0x0000000237377819ULL, 0x000fc8000000123cULL, 0x000000370000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x01a6683f090075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000a36367c11ULL, 0x000fe2000f8e38ffULL, 0x00000001ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff7e7224ULL, 0x000fe200078e0083ULL, 0x000000366e367210ULL, 0x000fca0007ffe069ULL,
0x01a00000363e7984ULL, 0x000e680000000800ULL, 0x01a2000036357984ULL, 0x0004a20000000800ULL,
0x000000833e00720bULL, 0x002fda0003f1d000ULL, 0x0000000000377806ULL, 0x000fc800000e0100ULL,
0x000000ff3700720cULL, 0x000fda0003f05270ULL, 0x0000000400948947ULL, 0x004fea0003800000ULL,
0x000000035a347836ULL, 0x000fe20000000000ULL, 0x000000833e00720bULL, 0x0c0fe40003f14000ULL,
0x000000833e7e7209ULL, 0x000fe40007810000ULL, 0x000000713400720cULL, 0x000fd20003f45270ULL,
0x0000000000367806ULL, 0x000fc800000e0100ULL, 0x0000000a7134ac11ULL, 0x000fe4000f8e38ffULL,
0x000000ff3600720cULL, 0x000fe40003f05270ULL, 0x000000346e69a210ULL, 0x000fca0007ffe069ULL,
0x01a4007e6900a388ULL, 0x0003ec0000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x000000837e347221ULL, 0x000fe20000010100ULL, 0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0036ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL,
0x00ff000036ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000036ff7812ULL, 0x000fe2000788c0ffULL,
0x00000034003d7308ULL, 0x0004ec0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x004fcc000001160aULL, 0x00001f343d347589ULL, 0x008ea400000e0000ULL,
0x0000005434547220ULL, 0x044fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a347811ULL, 0x004fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x008ea400000e0000ULL, 0x0000005634567220ULL, 0x044fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a347811ULL, 0x004fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x008ea400000e0000ULL,
0x0000000c340c7220ULL, 0x044fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003d82827220ULL, 0x008fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a347811ULL, 0x004fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x000ea400000e0000ULL,
0x0000000e340e7220ULL, 0x044fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003637ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fd800078e00ffULL,
0x0000003e7e340221ULL, 0x004fe20000010100ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400040308ULL, 0x000ea40000000800ULL,
0x0000000435350220ULL, 0x004fce0000410000ULL, 0x0000008235827221ULL, 0x000fe20000010000ULL,
0x000000016a3e7812ULL, 0x000fce00078ec0ffULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000000871367824ULL, 0x000fca00078e00ffULL, 0xfffffff036377812ULL, 0x000fc800078ec0ffULL,
0x01a6b087370075a7ULL, 0x000ea2000800014aULL, 0x0000000a373f7c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x004fec0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x01a6b0873f0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000004ff357819ULL, 0x000fe2000001160aULL, 0x000000035a367836ULL, 0x000fe20000000000ULL,
0x000099103c347816ULL, 0x000fe200000000ffULL, 0x00000008683d7824ULL, 0x000fe400078e00ffULL,
0x000000043e357824ULL, 0x000fe200078e0235ULL, 0x000000ff3400720cULL, 0x000fe20003f05270ULL,
0x00000008783c7824ULL, 0x000fe200078e00ffULL, 0x0000000a36367c11ULL, 0x000fe2000f8e60ffULL,
0x0000000168347824ULL, 0x100fe400078e0235ULL, 0x0000000178357824ULL, 0x000fc400078e0235ULL,
0x0000000471377824ULL, 0x000fe200078e00ffULL, 0xfffffff83d347812ULL, 0x000fe200078ee234ULL,
0x00012000367d7836ULL, 0x000fe20000000000ULL, 0xfffffff83c367812ULL, 0x000fe200078ee235ULL,
0x000000106d357824ULL, 0x000fe200078e027aULL, 0x0000000437377812ULL, 0x000fe200078ec0ffULL,
0x0000001034347824ULL, 0x100fe400078e027dULL, 0x0000001036367824ULL, 0x000fe200078e027dULL,
0x00000002377b7812ULL, 0x000fe200078efcffULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff3c7819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x000000083c027836ULL, 0x000fe20000000000ULL, 0x0000541000377816ULL, 0x000fe20000000000ULL,
0x000000103c3e7836ULL, 0x000fe40000000000ULL, 0x000000183c407836ULL, 0x000fe40000000000ULL,
0x00001f0237027589ULL, 0x0004e800000e0000ULL, 0x00001f3e37057589ULL, 0x00046800000e0000ULL,
0x00001f3c37037589ULL, 0x00046800000e0000ULL, 0x00001f4037007589ULL, 0x00046400000e0000ULL,
0x00000000345c783bULL, 0x000ae80000000200ULL, 0x000000003640783bULL, 0x0044620000000200ULL,
0x0000000000200947ULL, 0x020fea0003800000ULL, 0x000000035c5c7232ULL, 0x08afe40000200000ULL,
0x000000035e5e7232ULL, 0x000fe40000200000ULL, 0x000000025d5d7232ULL, 0x080fe40000200000ULL,
0x000000025f5f7232ULL, 0x000fe40000200000ULL, 0x0000000540407232ULL, 0x080fe40000200000ULL,
0x0000000542427232ULL, 0x000fc40000200000ULL, 0x0000000041417232ULL, 0x080fe40000200000ULL,
0x0000000043437232ULL, 0x000fce0000200000ULL, 0x0000007b0a7b7211ULL, 0x000fe200078fe0ffULL,
0x00000008683d7824ULL, 0x040fe200078e00ffULL, 0x000000003534783bULL, 0x004ea20000004200ULL,
0x000000106f7f7824ULL, 0x000fe400078e027dULL, 0x0000000168687824ULL, 0x000fe400078e027bULL,
0x00000010727d7824ULL, 0x000fc600078e027dULL, 0xfffffff83d3d7812ULL, 0x000fca00078ee268ULL,
0x000000103d3d7824ULL, 0x000fcc00078e027aULL, 0x000000003d3c783bULL, 0x000f620000004200ULL,
0x00000018ff627819ULL, 0x104fe40000011635ULL, 0x00000018ff607819ULL, 0x000fe40000011634ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff877819ULL, 0x000fe40000011635ULL,
0x000000ff35637812ULL, 0x040fe200078ec0ffULL, 0x20000062ff657230ULL, 0x000fe20000004100ULL,
0x0000ffff35867812ULL, 0x000fc400078ec0ffULL, 0x00000010ff857819ULL, 0x100fe40000011636ULL,
0x000000ff36647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff357819ULL, 0x000fe40000011636ULL,
0x0000ffff36847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6c7819ULL, 0x028fe4000001163cULL,
0x000000ff3c8a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff887819ULL, 0x000fe40000011634ULL,
0x000000ff34617812ULL, 0x040fe400078ec0ffULL, 0x00000018ff367819ULL, 0x100fe40000011637ULL,
0x0000ffff34347812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x000fe40000011637ULL,
0x000000ff37897812ULL, 0x000fc400078ec0ffULL, 0x0000ffff37837812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001163fULL,
0x00000018ff377819ULL, 0x000fe2000001163cULL, 0x20000060ff697230ULL, 0x002fe20000004100ULL,
0x0000ffff3c6f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000010ff6e7819ULL, 0x100fe4000001163dULL,
0x000000ff3d8b7812ULL, 0x040fe200078ec0ffULL, 0x20000063ff687230ULL, 0x000fe20000004100ULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d737812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e8d7812ULL, 0x000fc400078ec0ffULL, 0x0000008aff62723eULL, 0x000fe400020006ffULL,
0x00000010ff3d7819ULL, 0x000fe4000001163fULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe20000011686ULL, 0x20000036ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fc4000001163eULL, 0x00000018ff8c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e667812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fe40000011634ULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x20000061ff677230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000089ff60723eULL, 0x000fe400020006ffULL,
0x00000035ff35723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000087ff89723eULL, 0x000fe200020006ffULL,
0x20000035ff617230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x20000089ff867230ULL, 0x000fe20000004100ULL,
0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000034ff87723eULL, 0x000fe200020006ffULL, 0x2000008eff347230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x2000006cff8e7230ULL, 0x000fe20000004100ULL,
0x0000003eff36723eULL, 0x000fe200020006ffULL, 0x20000037ff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x2000008dff377230ULL, 0x000fe20000004100ULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x2000008aff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x0000003dff6c723eULL, 0x000fc400020006ffULL, 0x0000008cff35723eULL, 0x000fe200020006ffULL,
0x20000085ff8c7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000006fff857230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000066ff3d723eULL, 0x000fe200020006ffULL, 0x2000006cff667230ULL, 0x000fe20000004100ULL,
0x0000ffff3f6d7812ULL, 0x000fe200078ec0ffULL, 0x20000084ff897230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fc400078ec0ffULL, 0x000000ff72727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x000fe40000011665ULL, 0x00000010ff6f7819ULL, 0x000fe4000001168dULL,
0x0000008bff3f723eULL, 0x000fe200020006ffULL, 0x20000088ff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x20000083ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe2000001168cULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000080ff8a7230ULL, 0x000fe20000004100ULL,
0x000010546c6f7816ULL, 0x000fe4000000006fULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x20000072ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00001054656c7816ULL, 0x000fc40000000064ULL, 0x00000010ff657819ULL, 0x000fe40000011662ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff647819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fe40000011689ULL,
0x00000010ff637819ULL, 0x000fc40000011688ULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011667ULL,
0x2000003dff677230ULL, 0x000fe20000004100ULL, 0x0000105461627816ULL, 0x000fe20000000062ULL,
0x2000006dff3d7230ULL, 0x000fe20000004100ULL, 0x0000105464637816ULL, 0x000fe20000000063ULL,
0x2000006eff837230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe2000001163fULL,
0x20000073ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x00000010ff6d7819ULL, 0x000fe2000001168aULL, 0x000000624018723cULL, 0x000fe20000041818ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163eULL, 0x00000010ff647819ULL, 0x000fe40000011685ULL,
0x00000010ff8e7819ULL, 0x000fe2000001168eULL, 0x000000625c50723cULL, 0x000fe20000041850ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff737819ULL, 0x000fe40000011686ULL, 0x00000010ff6e7819ULL, 0x000fe40000011687ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x000010546d6d7816ULL, 0x000fe40000000060ULL, 0x000010543f647816ULL, 0x000fc40000000064ULL,
0x000010548e607816ULL, 0x000fe40000000065ULL, 0x00000010ff3f7819ULL, 0x000fe20000011666ULL,
0x0000006c4014723cULL, 0x000fe20000041814ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x0000105473737816ULL, 0x000fe40000000068ULL, 0x00001054696e7816ULL, 0x000fe2000000006eULL,
0x0000006c5c4c723cULL, 0x000fe2000004184cULL, 0x00000010ff3e7819ULL, 0x000fc40000011683ULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff657819ULL, 0x000fe20000011684ULL,
0x0000006e4010723cULL, 0x000fe20000041810ULL, 0x00000010ff367819ULL, 0x000fe40000011636ULL,
0x0000105480667816ULL, 0x000fe40000000037ULL, 0x00000010ff357819ULL, 0x000fe20000011635ULL,
0x0000006e5c48723cULL, 0x000fe20000041848ULL, 0x00000010ff687819ULL, 0x000fc40000011667ULL,
0x00000010ff807819ULL, 0x000fe40000011634ULL, 0x00000010ff697819ULL, 0x000fe4000001163dULL,
0x000010548b727816ULL, 0x000fe40000000072ULL, 0x000010543e617816ULL, 0x000fe40000000061ULL,
0x000010543c657816ULL, 0x000fe40000000065ULL, 0x000010543f677816ULL, 0x000fe20000000036ULL,
0x00000072400c723cULL, 0x000fe2000004180cULL, 0x0000105435687816ULL, 0x000fe20000000068ULL,
0x000000007f3c783bULL, 0x0002620000000200ULL, 0x0000105480697816ULL, 0x000fc60000000069ULL,
0x00000060401c723cULL, 0x000fe2000004181cULL, 0x000000007d34783bULL, 0x00026a0000000200ULL,
0x000000644020723cULL, 0x000fec0000041820ULL, 0x000000664038723cULL, 0x000fec0000041838ULL,
0x000000725c54723cULL, 0x000fec0000041854ULL, 0x000000605c30723cULL, 0x000fec0000041830ULL,
0x000000645c2c723cULL, 0x000fec000004182cULL, 0x000000665c28723cULL, 0x000fec0000041828ULL,
0x000000685c24723cULL, 0x000fec0000041824ULL, 0x000000684040723cULL, 0x000fe20000041844ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x002fde0003800000ULL,
0x000000033c3c7232ULL, 0x080fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x080fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000001787b7824ULL, 0x040fe200078e027bULL, 0x000000007c44783bULL, 0x000e620000004200ULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000000107077836ULL, 0x000fc60000000000ULL,
0xfffffff8787b7812ULL, 0x000fca00078ee27bULL, 0x000000107b5c7824ULL, 0x000fcc00078e027aULL,
0x000000005c5c783bULL, 0x000ea20000004200ULL, 0x00000018ff687819ULL, 0x002fe40000011645ULL,
0x00000010ff7d7819ULL, 0x100fe40000011644ULL, 0x000000ff44617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe40000011644ULL, 0x0000ffff44837812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fc40000011647ULL, 0x00000010ff7f7819ULL, 0x000fe40000011645ULL,
0x000000ff45447812ULL, 0x040fe400078ec0ffULL, 0x0000ffff45857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff697819ULL, 0x104fe4000001165cULL, 0x000000ff5c6f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fc4000001165cULL, 0x0000ffff5c667812ULL, 0x000fe400078ec0ffULL,
0x000000ff47807812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x100fe4000001165dULL,
0x000000ff5d5c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe4000001165dULL,
0x0000ffff5d657812ULL, 0x000fc400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000007bff5d723eULL, 0x000fe400020006ffULL, 0x00000044ff6c723eULL, 0x000fe200020006ffULL,
0x20000068ff7b7230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x100fe20000011646ULL,
0x2000005dff687230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000010ff847819ULL, 0x000fc40000011646ULL, 0x00000061ff64723eULL, 0x000fe400020006ffULL,
0x00000060ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff607819ULL, 0x100fe2000001165eULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff5e447812ULL, 0x040fe200078ec0ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe4000001165eULL,
0x0000ffff5e617812ULL, 0x000fe200078ec0ffULL, 0x2000006cff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff5d7819ULL, 0x000fe40000011683ULL,
0x0000006dff6c723eULL, 0x000fe200020006ffULL, 0x20000080ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000008ff807819ULL, 0x000fe20000011685ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000ffff477a7812ULL, 0x000fc400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7c7819ULL, 0x000fe40000011647ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000080ff83723eULL, 0x000fe200020006ffULL,
0x2000007fff807230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe2000001167aULL,
0x2000005dff7f7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff7c5d7812ULL, 0x000fe200078ec0ffULL,
0x20000084ff7c7230ULL, 0x000fe20000004100ULL, 0x0000007aff84723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x0000006fff85723eULL, 0x000fe200020006ffULL, 0x20000084ff6f7230ULL, 0x000fe20000004100ULL,
0x0000005cff86723eULL, 0x000fe200020006ffULL, 0x2000005dff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff466e7812ULL, 0x000fe200078ec0ffULL, 0x20000085ff5c7230ULL, 0x000fe20000004100ULL,
0x00000045ff84723eULL, 0x000fe200020006ffULL, 0x20000086ff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff457819ULL, 0x000fc4000001165eULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x0000ffff46787812ULL, 0x000fe400078ec0ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000044ff86723eULL, 0x000fe400020006ffULL, 0x000010547d447816ULL, 0x000fe20000000064ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x0000105480457816ULL, 0x000fe20000000045ULL,
0x20000086ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fc40000011678ULL,
0x000000ff5f477812ULL, 0x000fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe2000001165fULL,
0x000000443c54723cULL, 0x000fe20000041854ULL, 0x00000072ff7d723eULL, 0x000fe400020006ffULL,
0x00000010ff727819ULL, 0x000fe40000011673ULL, 0x00000010ff807819ULL, 0x000fe2000001167bULL,
0x00000044340c723cULL, 0x000fe2000004180cULL, 0x00000010ff7f7819ULL, 0x000fc4000001167fULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000047ff73723eULL, 0x000fe400020006ffULL, 0x00000046ff7b723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x0000105472467816ULL, 0x000fe2000000007fULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x0000105480477816ULL, 0x000fe20000000083ULL,
0x2000007bff727230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fe2000001166eULL,
0x2000007dff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x000fc4000001167cULL,
0x000000ff69697812ULL, 0x000fe200078ec0ffULL, 0x000000463c48723cULL, 0x000fe20000041848ULL,
0x0000105445447816ULL, 0x000fe40000000044ULL, 0x00000010ff627819ULL, 0x000fe4000001165fULL,
0x00000010ff457819ULL, 0x000fe2000001166dULL, 0x000000463410723cULL, 0x000fe20000041810ULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5f5f7812ULL, 0x000fc400078ec0ffULL,
0x00000069ff6d723eULL, 0x000fe400020006ffULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff697819ULL, 0x000fe4000001166cULL,
0x00000010ff787819ULL, 0x000fc40000011678ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff477819ULL, 0x000fe4000001166fULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000063ff85723eULL, 0x000fe200020006ffULL, 0x20000084ff637230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000085ff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff5f7819ULL, 0x000fe2000001165fULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010547a457816ULL, 0x000fe20000000045ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000105469467816ULL, 0x000fc40000000078ULL, 0x0000105468477816ULL, 0x000fe40000000047ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x000000443c4c723cULL, 0x000fe2000004184cULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000443414723cULL, 0x000fe20000041814ULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x000000463c50723cULL, 0x000fe20000041850ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe20000011667ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x000000463418723cULL, 0x000fe20000041818ULL,
0x00000010ff457819ULL, 0x000fe20000011660ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00001054445d7816ULL, 0x000fc4000000005dULL, 0x0000105445447816ULL, 0x000fe40000000064ULL,
0x2000005fff477230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x000fe4000001165eULL,
0x00000010ff5f7819ULL, 0x000fe40000011665ULL, 0x00000010ff457819ULL, 0x000fe4000001166eULL,
0x00001054465f7816ULL, 0x000fe4000000005fULL, 0x00000010ff467819ULL, 0x000fc40000011661ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff5e7819ULL, 0x000fe40000011666ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x0000105445467816ULL, 0x000fe40000000046ULL, 0x000010546d5c7816ULL, 0x000fe4000000005cULL,
0x00001054635e7816ULL, 0x000fe4000000005eULL, 0x0000105462457816ULL, 0x000fc40000000073ULL,
0x0000105472477816ULL, 0x000fe20000000047ULL, 0x0000005c3c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c2c723cULL, 0x000fec000004182cULL, 0x000000443c28723cULL, 0x000fec0000041828ULL,
0x000000463c24723cULL, 0x000fec0000041824ULL, 0x0000005c341c723cULL, 0x000fe2000004181cULL,
0x00000001ff3f7424ULL, 0x000fc800078e00ffULL, 0x0000003f063c79a7ULL, 0x0002a2000850003fULL,
0x0000005e3420723cULL, 0x000fec0000041820ULL, 0x000000443438723cULL, 0x000fe20000041838ULL,
0x0000000a5a067c11ULL, 0x002fca000f8e18ffULL, 0x000000463434723cULL, 0x000fe20000041840ULL,
0x01a6a03f06ff79a7ULL, 0x0003ec000850003fULL, 0x000000ffff407224ULL, 0x004fe200078e003dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff3c00ec9947ULL, 0x002fde000383ffffULL,
0x000000ff6b00720cULL, 0x000fda0003f05270ULL, 0x0000000400648947ULL, 0x000fea0003800000ULL,
0x0180000082007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000deb000047802ULL, 0x000fce0000000f00ULL,
0x000000b000847944ULL, 0x01efea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000008200037308ULL, 0x008ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc80000000082ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000001805077811ULL, 0x042fe400078ff0ffULL, 0x00000002ff097819ULL, 0x000fe40000011605ULL,
0x00000008053d7811ULL, 0x040fe400078ff0ffULL, 0x00000010053f7811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f0900047589ULL, 0x000e6800000e0000ULL,
0x00001f3d00067589ULL, 0x000ea800000e0000ULL, 0x00001f3f00057589ULL, 0x000ee800000e0000ULL,
0x00001f0700077589ULL, 0x000f6200000e0000ULL, 0x0000005404547220ULL, 0x042fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x000fe20000410000ULL, 0x0000005606567220ULL, 0x044fe20000410000ULL,
0x0000005706577220ULL, 0x040fe20000410000ULL, 0x0000004a064a7220ULL, 0x040fe20000410000ULL,
0x0000004b064b7220ULL, 0x040fe20000410000ULL, 0x0000004e064e7220ULL, 0x040fe20000410000ULL,
0x0000004f064f7220ULL, 0x040fe20000410000ULL, 0x0000005206527220ULL, 0x040fe20000410000ULL,
0x0000005306537220ULL, 0x040fe20000410000ULL, 0x0000003206327220ULL, 0x040fe20000410000ULL,
0x0000003306337220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x000fe20000410000ULL, 0x0000000c050c7220ULL, 0x048fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000001105117220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000003805387220ULL, 0x040fe20000410000ULL,
0x0000003905397220ULL, 0x040fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000003505357220ULL, 0x000fe20000410000ULL, 0x0000000e070e7220ULL, 0x060fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000003a073a7220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000f620000000000ULL,
0x0000000171717812ULL, 0x000fe400078ec0ffULL, 0x000000303130723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002c2d2c723eULL, 0x000fc400000010ffULL,
0x000000282928723eULL, 0x000fe400000010ffULL, 0x000000242524723eULL, 0x000fe400000010ffULL,
0x000000565757723eULL, 0x000fe400000010ffULL, 0x0000004a4b4a723eULL, 0x000fe400000010ffULL,
0x0000004e4f4e723eULL, 0x000fe400000010ffULL, 0x000000525352723eULL, 0x000fc400000010ffULL,
0x0000541057567816ULL, 0x140fe4000000004aULL, 0x0000763257577816ULL, 0x000fe4000000004aULL,
0x000076324e257816ULL, 0x000fe40000000052ULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x0000000800057811ULL, 0x062fe400078ff0ffULL, 0x0000000200027812ULL, 0x008fc400078ec0ffULL,
0x0000001800097811ULL, 0x000fe200078ff0ffULL, 0x00000008053e7824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x000fe200078ff0ffULL,
0x0000000809427824ULL, 0x000fe200078e00ffULL, 0x00000002ff077819ULL, 0x000fe40000011600ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee203ULL, 0x0000000805407824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x040fe200078ff8ffULL, 0x00000008073c7824ULL, 0x000fe200078e00ffULL,
0x0000000702047211ULL, 0x000fc400078ff8ffULL, 0x0000000902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee203ULL,
0x0000000204027836ULL, 0x000fe20000000000ULL, 0xfffffff842427812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000000a71037c11ULL, 0x000fe2000f8e68ffULL,
0x0000000404067836ULL, 0x000fe20000000000ULL, 0xfffffff809087812ULL, 0x000fe200078ee202ULL,
0x0000000604077836ULL, 0x000fe20000000000ULL, 0xfffffff805027812ULL, 0x000fe200078ee204ULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x000010006a057824ULL, 0x000fe200078e0203ULL, 0xfffffff83c3c7812ULL, 0x000fc400078ee207ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x0000001002067824ULL, 0x100fe200078e0205ULL,
0x000000545502723eULL, 0x000fe200000010ffULL, 0x000000103e3e7824ULL, 0x000fe200078e0205ULL,
0x000000484904723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x0000002e2f2e723eULL, 0x000fe200000010ffULL, 0x0000001040407824ULL, 0x100fe200078e0205ULL,
0x0000541002447816ULL, 0x100fe20000000004ULL, 0x0000001042427824ULL, 0x100fe200078e0205ULL,
0x0000763202457816ULL, 0x000fe20000000004ULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000004c4d02723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0205ULL,
0x000000505104723eULL, 0x000fe200000010ffULL, 0x000000103c3c7824ULL, 0x000fe200078e0205ULL,
0x0000004406007388ULL, 0x0003e20000000a00ULL, 0x00000001073e7824ULL, 0x000fe200078e023eULL,
0x0000002a2b2a723eULL, 0x000fe200000010ffULL, 0x0000000107407824ULL, 0x000fe200078e0240ULL,
0x000000262726723eULL, 0x000fe200000010ffULL, 0x0000000107427824ULL, 0x000fe200078e0242ULL,
0x0000000c0d0c723eULL, 0x000fe200000010ffULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x000000141514723eULL, 0x000fe200000010ffULL, 0x0000000107057824ULL, 0x000fe200078e020aULL,
0x00000018190a723eULL, 0x000fe200000010ffULL, 0x00000001073c7824ULL, 0x000fe200078e023cULL,
0x0000541002067816ULL, 0x002fc40000000004ULL, 0x0000763202077816ULL, 0x000fe20000000004ULL,
0x000000015b027824ULL, 0x000fe200078e0200ULL, 0x00007632140d7816ULL, 0x000fe4000000000aULL,
0x0000001c1d1c723eULL, 0x000fe200000010ffULL, 0x0000000608007388ULL, 0x0003e20000000a00ULL,
0x000000202120723eULL, 0x000fe200000010ffULL, 0x0000001002047824ULL, 0x000fe200078e0203ULL,
0x000000383938723eULL, 0x000fe200000010ffULL, 0x000000ff00027306ULL, 0x000ee20000202400ULL,
0x000000343534723eULL, 0x000fc400000010ffULL, 0x0000000e0f0e723eULL, 0x000fe400000010ffULL,
0x000000161716723eULL, 0x000fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fe400000010ffULL,
0x0000541030067816ULL, 0x142fe4000000002cULL, 0x0000763230077816ULL, 0x000fe4000000002cULL,
0x0000001e1f1e723eULL, 0x000fc400000010ffULL, 0x00000022230f723eULL, 0x000fe200000010ffULL,
0x0000000605007388ULL, 0x0003e20000000a00ULL, 0x0000003a3b3a723eULL, 0x000fe400000010ffULL,
0x00000036371d723eULL, 0x000fe400000010ffULL, 0x000000ff6a00720cULL, 0x000fe40003f05270ULL,
0x000076323a097816ULL, 0x000fe4000000001dULL, 0x0000541028067816ULL, 0x002fc40000000024ULL,
0x0000763228077816ULL, 0x000fe40000000024ULL, 0x000054104e247816ULL, 0x000fc60000000052ULL,
0x000000063c007388ULL, 0x0003e80000000a00ULL, 0x000000563e007388ULL, 0x000fe80000000a00ULL,
0x0004002408007388ULL, 0x000be20000000a00ULL, 0x000000101106723eULL, 0x002fe400000010ffULL,
0x000054102a107816ULL, 0x000fc40000000026ULL, 0x000076322a117816ULL, 0x000fe40000000026ULL,
0x000000121307723eULL, 0x000fe400000010ffULL, 0x0000541032247816ULL, 0x164fe4000000002eULL,
0x0000763232257816ULL, 0x000fca000000002eULL, 0x0004002405007388ULL, 0x000fe80000000a00ULL,
0x000400103c007388ULL, 0x0003e40000000a00ULL, 0x000054100c107816ULL, 0x142fe40000000006ULL,
0x000076320c117816ULL, 0x000fe40000000006ULL, 0x00005410140c7816ULL, 0x000fc4000000000aULL,
0x000054100e067816ULL, 0x140fe20000000007ULL, 0x0000001040007388ULL, 0x000fe20000000a00ULL,
0x000076320e077816ULL, 0x000fc60000000007ULL, 0x0008000c08007388ULL, 0x0003e40000000a00ULL,
0x000054101c0c7816ULL, 0x142fe40000000020ULL, 0x000076321c0d7816ULL, 0x000fca0000000020ULL,
0x0008000c05007388ULL, 0x0003e40000000a00ULL, 0x00005410380c7816ULL, 0x142fe40000000034ULL,
0x00007632380d7816ULL, 0x000fca0000000034ULL, 0x0008000c3c007388ULL, 0x000fe80000000a00ULL,
0x0000000642007388ULL, 0x0003e40000000a00ULL, 0x0000541016067816ULL, 0x142fe4000000001aULL,
0x0000763216077816ULL, 0x000fca000000001aULL, 0x000c000608007388ULL, 0x0003e40000000a00ULL,
0x000054101e067816ULL, 0x142fe4000000000fULL, 0x000076321e077816ULL, 0x000fe4000000000fULL,
0x000054103a087816ULL, 0x000fc6000000001dULL, 0x000c000605007388ULL, 0x000fe80000000a00ULL,
0x000c00083c007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000040c7984ULL, 0x000ee80000000c00ULL, 0x0004000004147984ULL, 0x000e680000000c00ULL,
0x00080000041c7984ULL, 0x000ea80000000c00ULL, 0x000c000004247984ULL, 0x000f680000000c00ULL,
0x0010000004107984ULL, 0x000ea80000000c00ULL, 0x0014000004187984ULL, 0x000f680000000c00ULL,
0x0018000004207984ULL, 0x000f680000000c00ULL, 0x001c000004287984ULL, 0x000f620000000c00ULL,
0x0000000f020f7230ULL, 0x008fc40000200800ULL, 0x0000000e020e7230ULL, 0x040fe40000200800ULL,
0x0000000d020d7230ULL, 0x040fe40000200800ULL, 0x0000000c020c7230ULL, 0x040fe40000200800ULL,
0x0000001702177230ULL, 0x042fe40000200800ULL, 0x0000001602167230ULL, 0x040fe40000200800ULL,
0x0000001502157230ULL, 0x000fc40000200800ULL, 0x0000001402147230ULL, 0x040fe40000200800ULL,
0x0000001f021f7230ULL, 0x044fe40000200800ULL, 0x0000001e021e7230ULL, 0x040fe40000200800ULL,
0x0000001d021d7230ULL, 0x040fe40000200800ULL, 0x0000001c021c7230ULL, 0x040fe40000200800ULL,
0x0000002702277230ULL, 0x020fc40000200800ULL, 0x0000002602267230ULL, 0x040fe40000200800ULL,
0x0000002502257230ULL, 0x040fe40000200800ULL, 0x0000002402027230ULL, 0x000fe40000200800ULL,
0x000000130f0f7230ULL, 0x000fe40000200000ULL, 0x000000120e0e7230ULL, 0x000fe40000200000ULL,
0x000000110d0d7230ULL, 0x000fc40000200000ULL, 0x000000100c0c7230ULL, 0x000fe40000200000ULL,
0x0000001b17177230ULL, 0x000fe40000200000ULL, 0x0000001a16167230ULL, 0x000fe20000200000ULL,
0x0000000c04007388ULL, 0x0003e20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000200000ULL,
0x0000001814147230ULL, 0x000fe40000200000ULL, 0x000000231f1f7230ULL, 0x000fc40000200000ULL,
0x000000221e1e7230ULL, 0x000fe20000200000ULL, 0x0004001404007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000200000ULL, 0x000000201c1c7230ULL, 0x000fe40000200000ULL,
0x0000002b27277230ULL, 0x000fe40000200000ULL, 0x0000002a26267230ULL, 0x000fe20000200000ULL,
0x0008001c04007388ULL, 0x0003e20000000c00ULL, 0x0000002925257230ULL, 0x000fc40000200000ULL,
0x0000002802247230ULL, 0x000fca0000200000ULL, 0x000c002404007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000003ff047819ULL, 0x002fe20000011600ULL,
0x0000840000057ab9ULL, 0x000fc60000000800ULL, 0x000000750400720cULL, 0x000fe20003f06070ULL,
0x00000005040472a4ULL, 0x004fd8000f8e023fULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000104027824ULL, 0x000fe200078e0200ULL, 0x00008600000a7ab9ULL, 0x000fe20000000800ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000a05057299ULL, 0x000fe2000800063fULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x00000007000a7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fc600078ef800ULL,
0x0000000871077824ULL, 0x000fe400078e020aULL, 0x0000001002067824ULL, 0x000fe400078e0203ULL,
0x0000002077027824ULL, 0x000fc600078e0204ULL, 0x00000000060c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff047c19ULL, 0x000fe20008011602ULL,
0x000000040b027c24ULL, 0x000fe4000f8e02ffULL, 0x0000000176057824ULL, 0x000fe400078e0205ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000b04057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f4408ULL,
0x00000003ff087819ULL, 0x000fe20000011606ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x000000750800720cULL, 0x000fe40003f06070ULL, 0x0000000c04007986ULL, 0x0043f6000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e0208ULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000508057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b08057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000871077824ULL, 0x002fc800078e0206ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4408ULL, 0x0000004000087836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff067819ULL, 0x000fc80000011608ULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000108047824ULL, 0x102fe400078e0206ULL,
0x0000002077067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef808ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b06057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000871077824ULL, 0x002fc800078e0208ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4406ULL, 0x0000006000067836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff087819ULL, 0x000fc80000011606ULL,
0x000000750800720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e0208ULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000508057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b08057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000871077824ULL, 0x002fc800078e0206ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4408ULL, 0x0000008000087836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff067819ULL, 0x000fc80000011608ULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000108047824ULL, 0x102fe400078e0206ULL,
0x0000002077067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef808ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b06057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000871077824ULL, 0x002fc800078e0208ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4406ULL, 0x000000a000067836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff087819ULL, 0x000fc80000011606ULL,
0x000000750800720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e0208ULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000508057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b08057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000871077824ULL, 0x002fc800078e0206ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4408ULL, 0x000000c000087836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff067819ULL, 0x000fc80000011608ULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000108047824ULL, 0x102fe400078e0206ULL,
0x0000002077067824ULL, 0x000fe400078e0206ULL, 0x000000e000007836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef808ULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x0002a20000000c00ULL,
0x0000000b06057224ULL, 0x000fe200078e0205ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000100097824ULL, 0x000fe400078e0206ULL,
0x0000000871077824ULL, 0x002fe400078e0208ULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe4000f8040ffULL, 0x0000000709097812ULL, 0x000fe400078ec0ffULL,
0x0000000905057c11ULL, 0x000fc400080f440aULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0xfffffff809087812ULL, 0x000fe200078ef800ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ea000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000002077067824ULL, 0x000fc600078e0206ULL, 0x00000000080c7984ULL, 0x002e620000000c00ULL,
0x0000000871717824ULL, 0x000fe200078e0200ULL, 0x0000000506037c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fc60008011606ULL, 0x0000000176037824ULL, 0x000fc800078e0203ULL,
0x0000000b06037224ULL, 0x000fca00078e0203ULL, 0x0000000302037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fc600080f4404ULL, 0x0000001071027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000707100720cULL, 0x000fe20003f06070ULL, 0x00009800ff107b82ULL, 0x000e620000000a00ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0xffffffffff0b7424ULL, 0x000fca00078e00ffULL,
0x00008e00ff0c7b82ULL, 0x000ea80000000a00ULL, 0x0000000207028824ULL, 0x000fc800078e00ffULL,
0x00009400ff098b82ULL, 0x000ef00000000800ULL, 0x00009000ff0e8b82ULL, 0x000f620000000a00ULL,
0x0000000610067981ULL, 0x002322000c1e9900ULL, 0x0000000902098224ULL, 0x008fc800078e0271ULL,
0x00000004090e8825ULL, 0x020fe400078e000eULL, 0x01a60008ff0879a7ULL, 0x000e66000850000aULL,
0x000000060e0b8981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x0000004003027824ULL, 0x000fe400078e00ffULL, 0x0000004071037824ULL, 0x000fe400078e00ffULL,
0x0000004058057824ULL, 0x000fc400078e00ffULL, 0x0000000b020b7224ULL, 0x008fc800078e02ffULL,
0x000000800b0c7825ULL, 0x004fe400078e000cULL, 0x0000000c00200947ULL, 0x002fea0003800000ULL,
0x00000003ff337819ULL, 0x000fe4000001160aULL, 0x00000003740e7248ULL, 0x000fc60007fe0000ULL,
0x00000004330f7836ULL, 0x000fe40000000000ULL, 0x000000010e0b7824ULL, 0x000fe400078e0a03ULL,
0x000000010f0e7824ULL, 0x140fe400078e020aULL, 0x000000080f277824ULL, 0x040fe200078e00ffULL,
0x0000000b0f00720cULL, 0x080fe20003f86070ULL, 0x00000008330f7836ULL, 0x000fe40000000000ULL,
0x0000004058587824ULL, 0x000fe200078e0233ULL, 0xfffffff827277812ULL, 0x000fe200078ee20eULL,
0x000000010f147824ULL, 0x040fe200078e020aULL, 0x0000000b0f00720cULL, 0x040fe20003f06070ULL,
0x000000080f297824ULL, 0x000fc400078e00ffULL, 0x00000080580e7825ULL, 0x000fc600078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee214ULL, 0x0000000c33117836ULL, 0x000fe20000000000ULL,
0x000000700e1b7812ULL, 0x000fe200078ef804ULL, 0x0000000458107836ULL, 0x000fe40000000000ULL,
0x0000000111157824ULL, 0x040fe200078e020aULL, 0x0000000b1100720cULL, 0x040fe20003f26070ULL,
0x0000000811167824ULL, 0x000fe200078e00ffULL, 0x0000001b0c1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff8162b7812ULL, 0x000fe200078ee215ULL,
0x0000000c580e7836ULL, 0x000fe20000000000ULL, 0x00000070101d7812ULL, 0x000fe200078ef804ULL,
0x000000010d1b7824ULL, 0x000fe400010e060fULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001d0c1c7210ULL, 0x000fc60007f5e0ffULL, 0x0000000858127836ULL, 0x000fe20000000000ULL,
0x000000700e217812ULL, 0x000fe200078ef804ULL, 0x0000001058107836ULL, 0x000fe20000000000ULL,
0x0000000a710e7c11ULL, 0x000fe2000f8e70ffULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000001c58187836ULL, 0x000fe20000000000ULL, 0x00000070121f7812ULL, 0x000fe200078ef804ULL,
0x000000010d1d7824ULL, 0x000fe200010e0611ULL, 0x000000210c207210ULL, 0x000fe20007f5e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001f0c1e7210ULL, 0x000fc60007f7e0ffULL,
0x0000001858147836ULL, 0x000fe20000000000ULL, 0x0000007010177812ULL, 0x000fe200078ef804ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x000000010d217824ULL, 0x040fe200010e060fULL, 0x00000070180f7812ULL, 0x000fe200078ef804ULL,
0x0000001458127836ULL, 0x000fe20000000000ULL, 0x000000170c107210ULL, 0x000fe20007f5e0ffULL,
0x000000010d1f7824ULL, 0x000fe200018e0613ULL, 0x0000007014177812ULL, 0x000fe200078ef804ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000f0c147210ULL, 0x000fe40007fbe0ffULL,
0x000000170c167210ULL, 0x000fe20007f7e0ffULL, 0x00000001330f7824ULL, 0x000fe200078e020aULL,
0x0000007012237812ULL, 0x000fe200078ef804ULL, 0x000020000e247836ULL, 0x000fc40000000000ULL,
0x00000020580e7836ULL, 0x000fe20000000000ULL, 0x000000070f257812ULL, 0x000fe200078ec0ffULL,
0x0000001433227836ULL, 0x000fe40000000000ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0ffffff825257812ULL, 0x000fc600078ef80aULL, 0x000000010d117824ULL, 0x040fe200010e0611ULL,
0x000000230c127210ULL, 0x000fe20007f5e0ffULL, 0x0000001033187836ULL, 0x000fe20000000000ULL,
0x000000700e237812ULL, 0x000fe200078ef804ULL, 0x00000001220e7824ULL, 0x140fe400078e020aULL,
0x00000008222f7824ULL, 0x040fe400078e00ffULL, 0x000000010d177824ULL, 0x040fe200018e0615ULL,
0x0000000b2200720cULL, 0x080fe20003f66070ULL, 0x000000010d137824ULL, 0x040fe200010e0613ULL,
0x0000000b1800720cULL, 0x0c0fe20003f46070ULL, 0x000000010d157824ULL, 0x000fe200028e0619ULL,
0x000000230c227210ULL, 0x000fe20007fde0ffULL, 0x0000000118197824ULL, 0x040fe200078e020aULL,
0x0000000b3300720cULL, 0x000fe20003fa6070ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL, 0x00000024580e7836ULL, 0x000fc40000000000ULL,
0x000000010d237824ULL, 0x000fe200030e060fULL, 0xfffffff8182d7812ULL, 0x000fe200078ee219ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000002858187836ULL, 0x000fe20000000000ULL,
0x000000700e317812ULL, 0x000fe200078ef804ULL, 0x0000001025257824ULL, 0x100fe400078e0224ULL,
0x0000001027277824ULL, 0x000fe400078e0224ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a257faeULL, 0x0003e6000e901c46ULL,
0x0000001c332a7836ULL, 0x000fe20000000000ULL, 0x000000001c277faeULL, 0x0005e2000e101c46ULL,
0x0000001833267836ULL, 0x000fc40000000000ULL, 0x0000001029297824ULL, 0x000fe200078e0224ULL,
0x0000000b2a00720cULL, 0x080fe20003f86070ULL, 0x0000000126287824ULL, 0x040fe200078e020aULL,
0x0000000b2600720cULL, 0x0c0fe20003fa6070ULL, 0x0000000826357824ULL, 0x000fe200078e00ffULL,
0x000000310c1a7210ULL, 0x002fe20007fde0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0224ULL,
0x0000007018257812ULL, 0x000fe200078ef804ULL, 0x000000012a187824ULL, 0x040fe200078e020aULL,
0xfffffff8351d7812ULL, 0x004fe200078ee228ULL, 0x000000082a277824ULL, 0x000fe200078e00ffULL,
0x000000001e297faeULL, 0x0003e2000c101c46ULL, 0x000000010d1b7824ULL, 0x000fe200030e060fULL,
0x000000250c0e7210ULL, 0x000fe20007fde0ffULL, 0x00000020331c7836ULL, 0x000fe20000000000ULL,
0xfffffff827257812ULL, 0x000fe200078ee218ULL, 0x0000002c58187836ULL, 0x000fe20000000000ULL,
0x00000000202b7faeULL, 0x000fe2000c901c46ULL, 0x0000002433277836ULL, 0x000fe20000000000ULL,
0x0000000b1c00720cULL, 0x000fe20003f06070ULL, 0x000000102d2d7824ULL, 0x000fc400078e0224ULL,
0x000000010d0f7824ULL, 0x000fe200030e0619ULL, 0x0000000b2700720cULL, 0x040fe20003f26070ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000000102d7faeULL, 0x0005e6000d101c46ULL,
0x000000011c267824ULL, 0x140fe200078e020aULL, 0x0000007018317812ULL, 0x000fe200078ef804ULL,
0x000000081c357824ULL, 0x000fe400078e00ffULL, 0x00000001271c7824ULL, 0x040fe200078e020aULL,
0x000000310c187210ULL, 0x000fe20007fde0ffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0xfffffff8351f7812ULL, 0x002fe200078ee226ULL, 0x000000102f2f7824ULL, 0x000fc400078e0224ULL,
0x0000003058107836ULL, 0x004fe20000000000ULL, 0xfffffff827217812ULL, 0x000fe200078ee21cULL,
0x000000101d1d7824ULL, 0x000fe200078e0224ULL, 0x00000000122f7faeULL, 0x0003e2000d901c46ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x00000000161d7faeULL, 0x000fe2000e901c46ULL,
0x0000001025257824ULL, 0x100fe400078e0224ULL, 0x00000028331c7836ULL, 0x000fe40000000000ULL,
0x000000010d197824ULL, 0x000fe200030e0619ULL, 0x0000000014257faeULL, 0x0005e2000e101c46ULL,
0x000000101f1f7824ULL, 0x100fe200078e0224ULL, 0x0000007010137812ULL, 0x002fe200078ef804ULL,
0x0000003458127836ULL, 0x000fe20000000000ULL, 0x0000000b1c00720cULL, 0x000fe20003fa6070ULL,
0x0000001021217824ULL, 0x000fe200078e0224ULL, 0x00000000221f7faeULL, 0x000fe2000c101c46ULL,
0x0000002c331e7836ULL, 0x000fc40000000000ULL, 0x0000003033207836ULL, 0x000fe20000000000ULL,
0x000000001a217faeULL, 0x0003e2000c901c46ULL, 0x0000003433267836ULL, 0x000fe20000000000ULL,
0x000000130c147210ULL, 0x004fe20007fde0ffULL, 0x000000011c157824ULL, 0x000fe200078e020aULL,
0x0000000b1e00720cULL, 0x080fe20003f86070ULL, 0x000000081c1c7824ULL, 0x000fe200078e00ffULL,
0x0000000b2000720cULL, 0x080fe20003f66070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b2600720cULL, 0x000fe40003f46070ULL, 0xfffffff81c177812ULL, 0x000fe200078ee215ULL,
0x0000003833277836ULL, 0x000fc40000000000ULL, 0x0000003c33287836ULL, 0x000fe40000000000ULL,
0x000000010d157824ULL, 0x000fe200030e0611ULL, 0x0000007012117812ULL, 0x000fe200078ef804ULL,
0x0000000120107824ULL, 0x140fe200078e020aULL, 0x0000000b2700720cULL, 0x080fe20003f26070ULL,
0x00000008201d7824ULL, 0x000fe200078e00ffULL, 0x0000000b2800720cULL, 0x000fe20003f06070ULL,
0x000000011e0b7824ULL, 0x040fe200078e020aULL, 0x000000110c127210ULL, 0x000fe20007fde0ffULL,
0x000000081e1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL,
0x0000003858117836ULL, 0x000fc40000000000ULL, 0x0000000126167824ULL, 0x000fe200078e020aULL,
0xfffffff81e1b7812ULL, 0x002fe200078ee20bULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x0000003c580b7836ULL, 0x000fe20000000000ULL, 0x00000070101f7812ULL, 0x000fe200078ef804ULL,
0x00000001271a7824ULL, 0x100fe400078e020aULL, 0x00000001281c7824ULL, 0x000fe400078e020aULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x000000010d137824ULL, 0x000fe200030e0613ULL,
0x0000001f0c107210ULL, 0x000fe20007fde0ffULL, 0x0000000826217824ULL, 0x000fe200078e00ffULL,
0x000000700a257812ULL, 0x000fe200078ef804ULL, 0x0000000827277824ULL, 0x000fe400078e00ffULL,
0x0000000828237824ULL, 0x000fe200078e00ffULL, 0xfffffff8211f7812ULL, 0x000fe200078ee216ULL,
0x000000010d117824ULL, 0x000fe200030e0611ULL, 0xfffffff827217812ULL, 0x000fe200078ee21aULL,
0x0000001017177824ULL, 0x100fe200078e0224ULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x000000101b1b7824ULL, 0x100fe200078e0224ULL, 0x000000250c0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0224ULL, 0x000000000e177faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x000fc400078e0224ULL, 0x0000001021217824ULL, 0x100fe200078e0224ULL,
0x00000000181b7faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fe400078e0224ULL,
0x000000010d0b7824ULL, 0x000fe200030e060bULL, 0x00000000141d7faeULL, 0x0003e8000d901c46ULL,
0x00000000121f7faeULL, 0x0003e8000d101c46ULL, 0x0000000010217faeULL, 0x0003e8000c901c46ULL,
0x000000000a237faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x000000100a177811ULL, 0x040fe400078fe8ffULL, 0x000000040a0f7811ULL, 0x040fe400078fe8ffULL,
0x0000000c0a157811ULL, 0x040fe200078fe8ffULL, 0x0000000117107824ULL, 0x140fe200078e020aULL,
0x000000080a137811ULL, 0x040fe200078fe8ffULL, 0x00000008171d7824ULL, 0x000fe200078e00ffULL,
0x000000200a1f7811ULL, 0x040fe200078fe8ffULL, 0x000000010f0b7824ULL, 0x140fe200078e020aULL,
0x000000140a197811ULL, 0x040fe200078fe8ffULL, 0x000000080f127824ULL, 0x000fe200078e00ffULL,
0xfffffff81d187812ULL, 0x000fe200078ee210ULL, 0x00000001150e7824ULL, 0x140fe200078e020aULL,
0x0000001c0a1d7811ULL, 0x040fe200078fe8ffULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x00000001130b7824ULL, 0x140fe200078e020aULL,
0x000000240a217811ULL, 0x040fe200078fe8ffULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0xfffffff81b167812ULL, 0x000fe200078ee20eULL, 0x000000011d0e7824ULL, 0x140fe200078e020aULL,
0x000000180a1b7811ULL, 0x040fe200078fe8ffULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20bULL, 0x000000011f107824ULL, 0x140fe200078e020aULL,
0x000000340a2e7811ULL, 0x040fe200078fe8ffULL, 0x000000081f257824ULL, 0x000fe200078e00ffULL,
0xfffffff8231e7812ULL, 0x000fe200078ee20eULL, 0x0000000119117824ULL, 0x140fe200078e020aULL,
0x000000280a237811ULL, 0x040fe200078fe8ffULL, 0x00000008191a7824ULL, 0x000fe200078e00ffULL,
0xfffffff825207812ULL, 0x000fe200078ee210ULL, 0x000000011b0b7824ULL, 0x140fe200078e020aULL,
0x0000002c0a257811ULL, 0x040fe200078fe8ffULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL, 0x0000000121117824ULL, 0x140fe200078e020aULL,
0x000000300a2c7811ULL, 0x040fe200078fe8ffULL, 0x0000000821227824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x00000001230b7824ULL, 0x140fe200078e020aULL,
0x000000380a307811ULL, 0x040fe200078fe8ffULL, 0x0000000823247824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x00000001250e7824ULL, 0x140fe200078e020aULL,
0x0000003c0a327811ULL, 0x000fe200078fe8ffULL, 0x0000000825277824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20bULL, 0x000000012e117824ULL, 0x100fe200078e020aULL,
0x0000000a0a0b7211ULL, 0x000fe200078fe8ffULL, 0x000000082e287824ULL, 0x000fe200078e00ffULL,
0xfffffff827267812ULL, 0x000fe200078ee20eULL, 0x000000012c107824ULL, 0x100fe200078e020aULL,
0x000000050a0e7211ULL, 0x000fe200078fe8ffULL, 0x000000082c297824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee211ULL, 0x0000000130117824ULL, 0x040fe200078e020aULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000830347824ULL, 0x000fe200078e00ffULL,
0xfffffff829277812ULL, 0x000fe200078ee210ULL, 0x0000000105107824ULL, 0x000fe200078e020fULL,
0x0000000a712a7c11ULL, 0x000fe2000f8e70ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0ffffff80b0b7812ULL, 0x000fc400078ef80aULL, 0xfffffff834297812ULL, 0x000fe200078ee211ULL,
0x00000001320a7824ULL, 0x040fe200078e020aULL, 0x000000700e2b7812ULL, 0x000fe200078ef804ULL,
0x00000008322d7824ULL, 0x000fe400078e00ffULL, 0x000020002a4b7836ULL, 0x000fe40000000000ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff82d0e7812ULL, 0x000fe400078ee20aULL,
0x0000002b0c0a7210ULL, 0x000fe20007f1e0ffULL, 0x000000100b2d7824ULL, 0x100fe200078e024bULL,
0x00000070100b7812ULL, 0x000fe200078ef804ULL, 0x00000010122f7824ULL, 0x000fc400078e024bULL,
0x0000001014317824ULL, 0x100fe400078e024bULL, 0x0000001016337824ULL, 0x100fe400078e024bULL,
0x0000001018357824ULL, 0x100fe400078e024bULL, 0x000000101a377824ULL, 0x100fe400078e024bULL,
0x000000101c397824ULL, 0x100fe400078e024bULL, 0x000000101e3b7824ULL, 0x000fc400078e024bULL,
0x00000010203d7824ULL, 0x100fe400078e024bULL, 0x00000010223f7824ULL, 0x100fe400078e024bULL,
0x0000001024417824ULL, 0x100fe400078e024bULL, 0x0000001026437824ULL, 0x100fe400078e024bULL,
0x0000001027457824ULL, 0x100fe400078e024bULL, 0x0000001028477824ULL, 0x000fc400078e024bULL,
0x0000001029497824ULL, 0x100fe400078e024bULL, 0x000000100e4b7824ULL, 0x000fe200078e024bULL,
0x0000000b0c0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000105107824ULL, 0x040fe400078e0213ULL,
0x0000000105127824ULL, 0x000fe400078e0215ULL, 0x000000010d0b7824ULL, 0x040fe400000e060fULL,
0x000000010d0f7824ULL, 0x000fc400008e0611ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2d7faeULL, 0x0003e6000b901c46ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007010297812ULL, 0x000fe200078ef804ULL,
0x000000000e2f7faeULL, 0x0003e4000b901c46ULL, 0x0000000105167824ULL, 0x040fe200078e0219ULL,
0x000000290c107210ULL, 0x000fe20007f1e0ffULL, 0x0000000105147824ULL, 0x000fc400078e0217ULL,
0x0000000105187824ULL, 0x000fe200078e021bULL, 0x00000070121b7812ULL, 0x000fe200078ef804ULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000001b0c127210ULL, 0x000fe20007f3e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000070161b7812ULL, 0x000fc600078ef804ULL,
0x000000010d117824ULL, 0x040fe200000e0611ULL, 0x0000001b0c167210ULL, 0x000fe20007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000070181b7812ULL, 0x000fe400078ef804ULL,
0x0000000010317faeULL, 0x0003e2000b901c46ULL, 0x000000010d177824ULL, 0x000fe200000e0617ULL,
0x0000001b0c227210ULL, 0x000fe20007f1e0ffULL, 0x00000001051a7824ULL, 0x040fe200078e021dULL,
0x0000007014277812ULL, 0x000fe200078ef804ULL, 0x0000000105187824ULL, 0x000fc400078e021fULL,
0x00000001051e7824ULL, 0x000fe200078e0223ULL, 0x000000270c147210ULL, 0x000fe20007f5e0ffULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x000000010d237824ULL, 0x000fe400000e0619ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x00000001051c7824ULL, 0x000fe200078e0221ULL,
0x000000701a217812ULL, 0x000fe200078ef804ULL, 0x000000010d137824ULL, 0x000fe200008e0613ULL,
0x0000007018277812ULL, 0x000fe200078ef804ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000210c247210ULL, 0x000fe40007f1e0ffULL, 0x000000270c267210ULL, 0x000fe20007f3e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c297812ULL, 0x000fe200078ef804ULL,
0x0000000012337faeULL, 0x0003e4000b901c46ULL, 0x00000001051a7824ULL, 0x000fe200078e0225ULL,
0x000000701e2b7812ULL, 0x000fe200078ef804ULL, 0x000000010d257824ULL, 0x040fe200000e061bULL,
0x000000290c287210ULL, 0x000fe20007f1e0ffULL, 0x000000010d277824ULL, 0x000fc400008e0619ULL,
0x000000801a187825ULL, 0x000fc800078e00ffULL, 0x000000010d157824ULL, 0x040fe200010e0615ULL,
0x0000002b0c2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010d297824ULL, 0x000fe200000e061dULL,
0x00000070181d7812ULL, 0x000fe200078ef804ULL, 0x00000001051a7824ULL, 0x040fe200078e022cULL,
0x0000000014357faeULL, 0x0003e2000b901c46ULL, 0x00000001051c7824ULL, 0x040fe200078e022eULL,
0x0000001d0c187210ULL, 0x000fe20007f1e0ffULL, 0x00000001051e7824ULL, 0x040fe200078e0230ULL,
0x0000000016377faeULL, 0x0003e2000b901c46ULL, 0x0000000105207824ULL, 0x000fc400078e0232ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000022397faeULL, 0x0003e6000b901c46ULL,
0x000000010d2b7824ULL, 0x040fe200010e061fULL, 0x000000701a537812ULL, 0x000fe200078ef804ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x00000000243b7faeULL, 0x0003e6000b901c46ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c517812ULL, 0x000fe200078ef804ULL,
0x00000000263d7faeULL, 0x0003e4000b901c46ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000701e4f7812ULL, 0x000fe200078ef804ULL, 0x00000000283f7faeULL, 0x0003e2000b901c46ULL,
0x000000510c1c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010d197824ULL, 0x040fe200000e0619ULL,
0x00000070204d7812ULL, 0x000fe200078ef804ULL, 0x000000002a417faeULL, 0x0003e2000b901c46ULL,
0x000000530c1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010d1d7824ULL, 0x040fe200008e061dULL,
0x0000004f0c1e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000018437faeULL, 0x0003e2000b901c46ULL,
0x0000004d0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d1b7824ULL, 0x000fc400000e061bULL,
0x000000010d1f7824ULL, 0x040fe400010e061fULL, 0x000000010d0d7824ULL, 0x000fe200018e0621ULL,
0x000000001a457faeULL, 0x0003e8000b901c46ULL, 0x000000001c477faeULL, 0x0003e8000b901c46ULL,
0x000000001e497faeULL, 0x0003e8000b901c46ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000471777836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff757424ULL, 0x000fc600078e00ffULL, 0x000000707700720cULL, 0x000fda0003f06070ULL,
0x00009400ff0d8b82ULL, 0x002e620000000800ULL, 0x0000000207048824ULL, 0x000fce00078e00ffULL,
0x00009000ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000d040d8224ULL, 0x002fc800078e0277ULL,
0x000000040d0a8825ULL, 0x004fca00078e000aULL, 0x000000060a758981ULL, 0x000324000c1e1900ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x01a60009ff0075a7ULL, 0x000e64000800014aULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001140dULL,
0x0000000f04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x0000000204047819ULL, 0x000fc8000000120dULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01a60009ff0075a7ULL, 0x000e64000800014aULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x0000002071047824ULL, 0x002fc800078e0204ULL,
0x00000001040a7836ULL, 0x000fe20000000000ULL, 0x00000004ff087819ULL, 0x000fc80000011604ULL,
0x0ffffffe08097812ULL, 0x000fe400078ec0ffULL, 0x0000001f04087812ULL, 0x000fc600078ec0ffULL,
0x00000001090c7824ULL, 0x000fe400078e020aULL, 0x00000001040b7824ULL, 0x000fe400078e0209ULL,
0x00000010080d7824ULL, 0x000fe200078e00ffULL, 0x0000000f0c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000010080e7824ULL, 0x040fe200078e00ffULL, 0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000809097836ULL, 0x000fe20000000000ULL, 0x000001f00d0c7812ULL, 0x000fe200078ee20cULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0x000001f00e0b7812ULL, 0x000fe200078ee20bULL,
0x0000000104047824ULL, 0x100fe200078e0209ULL, 0x0000000a0c0c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0x0000000a0b0b7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000f04047812ULL, 0x000fe200078ec0ffULL, 0x000000000c107984ULL, 0x000e620000000c00ULL,
0x0000000f09097812ULL, 0x000fe400078ec0ffULL, 0x000001f00d047812ULL, 0x000fe200078ee204ULL,
0x000000000b147984ULL, 0x000ea20000000c00ULL, 0x000001f008097812ULL, 0x000fe400078ee209ULL,
0x0000000a04047c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a09097c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1a7224ULL, 0x002fc400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff187224ULL, 0x004fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0013ULL,
0x000000180b007388ULL, 0x000fe20000000c00ULL, 0x000000ffff1c7224ULL, 0x000fc400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fca00078e0017ULL, 0x0000001c0c007388ULL, 0x0003e80000000c00ULL,
0x0000000009107984ULL, 0x000ea80000000c00ULL, 0x0000000004147984ULL, 0x000ee20000000c00ULL,
0x00000001ff0c7424ULL, 0x002fe400078e00ffULL, 0x000000ffff237224ULL, 0x004fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff207224ULL, 0x008fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x0000002004007388ULL, 0x0003e80000000c00ULL, 0x0000001009007388ULL, 0x0003e20000000c00ULL,
0x01a6000cff0c79a7ULL, 0x000ea4000850000aULL, 0x0000000000087805ULL, 0x002fce0000015200ULL,
0x01a6000dff0075a7ULL, 0x004e64000800014aULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a080f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140bULL, 0x0000000f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000204047819ULL, 0x000fc8000000120bULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x01a6000dff0075a7ULL, 0x000e64000800014aULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6b00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009400ff727b82ULL, 0x000e620000000800ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x3db504f306067820ULL, 0x010fe20000410000ULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x8000000974587c36ULL, 0x000fe20008000000ULL, 0x0000000a716a7c11ULL, 0x000fe2000f8e28ffULL,
0x0000010003737836ULL, 0x000fe20000000000ULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x0000000000687805ULL, 0x000fc4000001ff00ULL, 0x00000008ff587819ULL, 0x000fe20000011658ULL,
0xffffffff09057890ULL, 0x000fe4000fffe03fULL, 0x0000000909087890ULL, 0x000fe4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x0000007207727224ULL, 0x002fe200078e02ffULL,
0x0000000a71077c11ULL, 0x000fd4000f8e18ffULL, 0x00008e00ff087b82ULL, 0x002e620000000a00ULL,
0x00000002680a7836ULL, 0x000fe20000000000ULL, 0x0000000169597812ULL, 0x000fe200078e0cffULL,
0x0000007502757224ULL, 0x010fc600078e02ffULL, 0x0000006b0a00720cULL, 0x000fe20003f06070ULL,
0x0000008075087825ULL, 0x002fd800078e0008ULL, 0x0000000c00308947ULL, 0x000fea0003800000ULL,
0x00000100680b7824ULL, 0x000fe200078e0273ULL, 0x00000003ff0c7819ULL, 0x004fe40000011604ULL,
0x0000000a715a7c11ULL, 0x000fe4000f8e70ffULL, 0x0000000b740a7248ULL, 0x000fe20007fe0000ULL,
0x000000040c107836ULL, 0x000fe40000000000ULL, 0x0000000c0c187836ULL, 0x000fe40000000000ULL,
0x000000010a0b7824ULL, 0x000fc400078e0a0bULL, 0x00000001100a7824ULL, 0x140fe400078e0204ULL,
0x00000008100f7824ULL, 0x040fe200078e00ffULL, 0x0000000b1000720cULL, 0x080fe20003f46070ULL,
0x00000001180e7824ULL, 0x040fe200078e0204ULL, 0x0000000b1800720cULL, 0x040fe20003fa6070ULL,
0x0000000818117824ULL, 0x000fe200078e00ffULL, 0xfffffff80f1c7812ULL, 0x000fe200078ee20aULL,
0x00000010040a7824ULL, 0x000fe400078e00ffULL, 0x0000000105107824ULL, 0x040fe200078e0210ULL,
0xfffffff811207812ULL, 0x000fe200078ee20eULL, 0x00000001050e7824ULL, 0x000fe200078e020cULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x000000080c127836ULL, 0x000fc40000000000ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000b1200720cULL, 0x000fe20003f66070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000a10177212ULL, 0x000fc600078efcffULL,
0x00000001120d7824ULL, 0x100fe200078e0204ULL, 0x0000000a0e157212ULL, 0x000fe200078efcffULL,
0x00000008121e7824ULL, 0x000fe200078e00ffULL, 0x0000001708167210ULL, 0x000fe20007f3e0ffULL,
0x000000180c287836ULL, 0x000fe20000000000ULL, 0x0000001508147210ULL, 0x000fe20007f1e0ffULL,
0x000000100c1a7836ULL, 0x000fe20000000000ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL,
0x00000001280e7824ULL, 0x140fe400078e0204ULL, 0x0000000828137824ULL, 0x000fe200078e00ffULL,
0x0000000b1a00720cULL, 0x040fe20003f86070ULL, 0x000000011a0d7824ULL, 0x000fc400078e0204ULL,
0x000000081a227824ULL, 0x000fe200078e00ffULL, 0xfffffff8132a7812ULL, 0x000fe200078ee20eULL,
0x0000000105107824ULL, 0x000fe400078e0218ULL, 0x000000140c247836ULL, 0x000fe20000000000ULL,
0xfffffff822227812ULL, 0x000fe200078ee20dULL, 0x0000000109177824ULL, 0x000fe200008e0611ULL,
0x0000000b0c00720cULL, 0x000fe20003f26070ULL, 0x00000001050e7824ULL, 0x000fe400078e0212ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x00000001240d7824ULL, 0x100fe200078e0204ULL,
0x0000000a101b7212ULL, 0x000fe200078efcffULL, 0x0000000824267824ULL, 0x000fe400078e00ffULL,
0x000000010c137824ULL, 0x000fe400078e0204ULL, 0x0000000109157824ULL, 0x000fe200000e060fULL,
0xfffffff826267812ULL, 0x000fe200078ee20dULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000007131f7812ULL, 0x000fc600078ec0ffULL, 0x00002000590d7824ULL, 0x000fe200078e025aULL,
0x0000000a0e197212ULL, 0x000fe200078efcffULL, 0x0000000105127824ULL, 0x000fe200078e021aULL,
0x0000001b081a7210ULL, 0x000fe20007fde0ffULL, 0x000020000d0d7836ULL, 0x000fe20000000000ULL,
0x0ffffff81f0e7812ULL, 0x000fe200078ef804ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000001908187210ULL, 0x000fc60007f1e0ffULL, 0x00000001091b7824ULL, 0x000fe200030e0611ULL,
0x0000000a121d7212ULL, 0x080fe200078efcffULL, 0x000000100e117824ULL, 0x000fe400078e020dULL,
0x00000001050e7824ULL, 0x000fe200078e0224ULL, 0x0000001d08127210ULL, 0x000fe20007fde0ffULL,
0x0000000109197824ULL, 0x040fe200000e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014117faeULL, 0x0003e2000c901c46ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000b2400720cULL, 0x080fe40003f06070ULL, 0x0000000b2800720cULL, 0x000fe20003f26070ULL,
0x000000200c2c7836ULL, 0x000fe20000000000ULL, 0x0000000a0e1d7212ULL, 0x000fe200078efcffULL,
0x0000000109137824ULL, 0x000fc400030e0613ULL, 0x000000012c0e7824ULL, 0x040fe400078e0204ULL,
0x000000082c217824ULL, 0x000fe200078e00ffULL, 0x0000001d08147210ULL, 0x002fe20007fde0ffULL,
0x0000000105107824ULL, 0x000fe400078e0228ULL, 0x0000001c0c247836ULL, 0x000fe20000000000ULL,
0xfffffff8212e7812ULL, 0x000fe200078ee20eULL, 0x0000000109157824ULL, 0x000fe400030e060fULL,
0x00000080100e7825ULL, 0x000fc800078e00ffULL, 0x00000001241f7824ULL, 0x000fe200078e0204ULL,
0x0000000a0e1d7212ULL, 0x000fe200078efcffULL, 0x0000000824287824ULL, 0x000fe400078e00ffULL,
0x0000000105107824ULL, 0x040fe400078e0224ULL, 0x00000001050e7824ULL, 0x000fe200078e022cULL,
0xfffffff828287812ULL, 0x000fe200078ee21fULL, 0x000000101c1f7824ULL, 0x000fe200078e020dULL,
0x0000001d081c7210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000000161f7faeULL, 0x0003e2000d101c46ULL, 0x000000101e217824ULL, 0x000fe200078e020dULL,
0x0000000b2400720cULL, 0x080fe20003f46070ULL, 0x00000001091d7824ULL, 0x000fe400030e060fULL,
0x000000240c1e7836ULL, 0x000fe20000000000ULL, 0x0000000018217faeULL, 0x0005e2000d901c46ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000b2c00720cULL, 0x000fe40003f66070ULL,
0x0000000a10177212ULL, 0x002fe200078efcffULL, 0x00000010201f7824ULL, 0x000fc400078e020dULL,
0x000000011e207824ULL, 0x000fe200078e0204ULL, 0x0000001708167210ULL, 0x000fe20007fde0ffULL,
0x0000000105107824ULL, 0x000fe200078e021eULL, 0x0000000a0e197212ULL, 0x004fe200078efcffULL,
0x000000081e217824ULL, 0x000fe200078e00ffULL, 0x000000001a1f7faeULL, 0x0003e2000e901c46ULL,
0x0000000109177824ULL, 0x000fe200030e0611ULL, 0x0000001908187210ULL, 0x000fe20007fde0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff821207812ULL, 0x000fe400078ee220ULL,
0x0000000b1e00720cULL, 0x000fe20003fa6070ULL, 0x0000001022217824ULL, 0x000fc400078e020dULL,
0x000000280c0e7836ULL, 0x000fe40000000000ULL, 0x0000000109197824ULL, 0x000fe200030e060fULL,
0x0000000012217faeULL, 0x0005e2000e101c46ULL, 0x000000010e0f7824ULL, 0x000fe200078e0204ULL,
0x0000000a101b7212ULL, 0x002fe200078efcffULL, 0x000000080e227824ULL, 0x040fe200078e00ffULL,
0x0000000b0e00720cULL, 0x000fe20003f86070ULL, 0x00000001050e7824ULL, 0x000fe200078e020eULL,
0x0000001b081a7210ULL, 0x000fe20007fde0ffULL, 0x0000002c0c1e7836ULL, 0x000fe20000000000ULL,
0xfffffff822227812ULL, 0x000fe200078ee20fULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x00000010261f7824ULL, 0x000fe400078e020dULL, 0x00000001091b7824ULL, 0x000fe200030e0611ULL,
0x0000000a0e117212ULL, 0x000fe200078efcffULL, 0x000000300c267836ULL, 0x000fe20000000000ULL,
0x00000000141f7faeULL, 0x0003e2000c101c46ULL, 0x0000000105107824ULL, 0x000fe200078e021eULL,
0x00000011080e7210ULL, 0x000fe20007fde0ffULL, 0x000000011e137824ULL, 0x044fe200078e0204ULL,
0x0000000b1e00720cULL, 0x040fe20003f06070ULL, 0x000000081e247824ULL, 0x000fc400078e00ffULL,
0x0000000105127824ULL, 0x000fe400078e0226ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fc600078ee213ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000a10157212ULL, 0x002fc600078efcffULL, 0x000000102a217824ULL, 0x000fe200078e020dULL,
0x0000000a121f7212ULL, 0x000fe200078efcffULL, 0x0000000126107824ULL, 0x040fe400078e0204ULL,
0x0000000826237824ULL, 0x040fe200078e00ffULL, 0x000000001c217faeULL, 0x0003e2000c901c46ULL,
0x000000340c127836ULL, 0x000fe20000000000ULL, 0x0000000b2600720cULL, 0x000fe20003f26070ULL,
0x00000001090f7824ULL, 0x000fe200030e060fULL, 0x0000001508147210ULL, 0x000fe40007fde0ffULL,
0xfffffff823267812ULL, 0x000fe200078ee210ULL, 0x0000000105107824ULL, 0x000fc400078e0212ULL,
0x0000000109157824ULL, 0x000fe200030e0611ULL, 0x0000001f081e7210ULL, 0x000fe20007fde0ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000001020217824ULL, 0x102fe200078e020dULL,
0x0000000a101d7212ULL, 0x000fe200078efcffULL, 0x000000380c207836ULL, 0x000fe40000000000ULL,
0x0000001028237824ULL, 0x000fe400078e020dULL, 0x00000001091f7824ULL, 0x000fe200030e0613ULL,
0x0000001d081c7210ULL, 0x000fe20007fde0ffULL, 0x000000102e137824ULL, 0x000fe200078e020dULL,
0x0000000016237faeULL, 0x0003e2000d101c46ULL, 0x0000000105107824ULL, 0x000fc400078e0220ULL,
0x0000003c0c287836ULL, 0x000fe20000000000ULL, 0x0000000018137faeULL, 0x0005e2000d901c46ULL,
0x00000001091d7824ULL, 0x000fe200030e0611ULL, 0x0000000b2000720cULL, 0x080fe20003f66070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000001a217faeULL, 0x0007e2000e901c46ULL,
0x0000000b1200720cULL, 0x0c0fe40003fa6070ULL, 0x00000001120c7824ULL, 0x100fe200078e0204ULL,
0x0000000b2800720cULL, 0x000fe20003f46070ULL, 0x0000000120167824ULL, 0x102fe200078e0204ULL,
0x0000000a100b7212ULL, 0x000fe200078efcffULL, 0x0000000128177824ULL, 0x000fc400078e0204ULL,
0x0000000812197824ULL, 0x004fe200078e00ffULL, 0x0000000b08107210ULL, 0x000fe20007fde0ffULL,
0x0000000105127824ULL, 0x000fe400078e0228ULL, 0x00000008201b7824ULL, 0x008fe200078e00ffULL,
0xfffffff8190c7812ULL, 0x000fe200078ee20cULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff81b167812ULL, 0x000fe200078ee216ULL, 0x0000000828187824ULL, 0x000fe200078e00ffULL,
0x0000000a121b7212ULL, 0x000fe200078efcffULL, 0x0000000109117824ULL, 0x000fe400030e0611ULL,
0x00000010220b7824ULL, 0x100fe200078e020dULL, 0xfffffff818187812ULL, 0x000fe200078ee217ULL,
0x0000001024177824ULL, 0x100fe200078e020dULL, 0x0000001b08087210ULL, 0x000fe20007fde0ffULL,
0x0000001026197824ULL, 0x100fe200078e020dULL, 0x000000000e0b7faeULL, 0x0003e2000e101c46ULL,
0x000000100c1b7824ULL, 0x000fc400078e020dULL, 0x0000001016217824ULL, 0x100fe200078e020dULL,
0x0000000014177faeULL, 0x0003e2000c101c46ULL, 0x00000010180d7824ULL, 0x000fe400078e020dULL,
0x0000000109097824ULL, 0x000fe200030e0613ULL, 0x000000001e197faeULL, 0x0003e8000c901c46ULL,
0x000000001c1b7faeULL, 0x0003e8000e901c46ULL, 0x0000000010217faeULL, 0x0003e8000d901c46ULL,
0x00000000080d7faeULL, 0x0003e2000d101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x00000004040e7811ULL, 0x044fe400078fe8ffULL, 0x0000000804117811ULL, 0x040fe400078fe8ffULL,
0x0000000c04127811ULL, 0x000fe200078fe8ffULL, 0x000000010e0a7824ULL, 0x100fe200078e0204ULL,
0x0000001004137811ULL, 0x000fe200078fe8ffULL, 0x000000080e2d7824ULL, 0x000fe200078e00ffULL,
0x0000001404147811ULL, 0x040fe200078fe8ffULL, 0x00000001110b7824ULL, 0x140fe200078e0204ULL,
0x0000001804157811ULL, 0x000fe200078fe8ffULL, 0x00000008110c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL, 0x00000001120a7824ULL, 0x100fe200078e0204ULL,
0x0000001c04187811ULL, 0x000fe200078fe8ffULL, 0x0000000812317824ULL, 0x000fe200078e00ffULL,
0xfffffff80c2f7812ULL, 0x000fe200078ee20bULL, 0x00000001130b7824ULL, 0x140fe200078e0204ULL,
0x00000020041a7811ULL, 0x040fe200078fe8ffULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0x00000024041c7811ULL, 0x000fe200078fe8ffULL, 0x00000001140c7824ULL, 0x140fe200078e0204ULL,
0xfffffff831317812ULL, 0x000fe200078ee20aULL, 0x0000000814357824ULL, 0x000fe200078e00ffULL,
0xfffffff810337812ULL, 0x000fe200078ee20bULL, 0x00000001150d7824ULL, 0x140fe200078e0204ULL,
0x00000028041e7811ULL, 0x000fe200078fe8ffULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee20cULL, 0x00000001180a7824ULL, 0x100fe200078e0204ULL,
0x0000002c04207811ULL, 0x000fe200078fe8ffULL, 0x0000000818397824ULL, 0x000fe200078e00ffULL,
0x0000003004227811ULL, 0x000fe200078fe8ffULL, 0x000000011a0b7824ULL, 0x100fe200078e0204ULL,
0x0000003404247811ULL, 0x000fe200078fe8ffULL, 0x000000081a107824ULL, 0x000fe200078e00ffULL,
0xfffffff816377812ULL, 0x000fe200078ee20dULL, 0x000000011c0c7824ULL, 0x140fe200078e0204ULL,
0xfffffff839397812ULL, 0x000fe200078ee20aULL, 0x000000081c3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8103b7812ULL, 0x000fe200078ee20bULL, 0x000000011e0d7824ULL, 0x100fe200078e0204ULL,
0x0000003804267811ULL, 0x000fe200078fe8ffULL, 0x000000081e167824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL, 0x00000001200a7824ULL, 0x140fe200078e0204ULL,
0x0000000a715a7c11ULL, 0x000fe2000f8e70ffULL, 0x0000000820417824ULL, 0x000fe200078e00ffULL,
0xfffffff8163f7812ULL, 0x000fe200078ee20dULL, 0x00000001220b7824ULL, 0x100fe200078e0204ULL,
0x0000003c04277811ULL, 0x000fe200078fe8ffULL, 0x0000000822107824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee20aULL, 0x00000001240c7824ULL, 0x000fc400078e0204ULL,
0x0000000824457824ULL, 0x000fe200078e00ffULL, 0xfffffff810437812ULL, 0x000fe200078ee20bULL,
0x00000001260d7824ULL, 0x100fe200078e0204ULL, 0x00000005040b7211ULL, 0x000fe200078fe8ffULL,
0x0000000826167824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee20cULL,
0x00000010040a7824ULL, 0x040fe200078e00ffULL, 0x00000004040c7211ULL, 0x000fe200078fe8ffULL,
0x0000000827497824ULL, 0x040fe200078e00ffULL, 0xfffffff816477812ULL, 0x000fe200078ee20dULL,
0x0000000127167824ULL, 0x000fe200078e0204ULL, 0x000000700a4b7812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x000000070c0d7812ULL, 0x000fc400078ec0ffULL,
0xfffffff849497812ULL, 0x000fe200078ee216ULL, 0x00002000590c7824ULL, 0x000fe200078e025aULL,
0x0ffffff80d2b7812ULL, 0x000fe200078ef804ULL, 0x0000000105107824ULL, 0x000fe200078e020eULL,
0x0000004b0a0f7212ULL, 0x000fe200078efcffULL, 0x000020000c0e7836ULL, 0x000fe40000000000ULL,
0x00000080100c7825ULL, 0x000fe200078e00ffULL, 0x0000000f080a7210ULL, 0x000fc60007f1e0ffULL,
0x000000102b2b7824ULL, 0x100fe200078e020eULL, 0x0000004b0c0f7212ULL, 0x000fe200078efcffULL,
0x000000102d2d7824ULL, 0x100fe400078e020eULL, 0x000000102f2f7824ULL, 0x100fe200078e020eULL,
0x0000000f080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001031317824ULL, 0x100fe400078e020eULL,
0x0000001033337824ULL, 0x100fe400078e020eULL, 0x0000001035357824ULL, 0x000fc400078e020eULL,
0x0000001037377824ULL, 0x100fe400078e020eULL, 0x0000001039397824ULL, 0x100fe400078e020eULL,
0x000000103b3b7824ULL, 0x100fe400078e020eULL, 0x000000103d3d7824ULL, 0x100fe400078e020eULL,
0x000000103f3f7824ULL, 0x100fe400078e020eULL, 0x0000001041417824ULL, 0x000fc400078e020eULL,
0x0000001043437824ULL, 0x100fe400078e020eULL, 0x0000001045457824ULL, 0x100fe400078e020eULL,
0x0000001047477824ULL, 0x100fe400078e020eULL, 0x0000001049497824ULL, 0x000fe400078e020eULL,
0x00000001050e7824ULL, 0x040fe400078e0211ULL, 0x0000000105147824ULL, 0x000fc400078e0214ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000105167824ULL, 0x000fe200078e0215ULL,
0x0000004b0e197212ULL, 0x000fe200078efcffULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0609ULL, 0x00000019080e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004b14197212ULL, 0x080fe400078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2b7faeULL, 0x0003e2000b901c46ULL,
0x0000000105137824ULL, 0x000fe400078e0213ULL, 0x000000010f0f7824ULL, 0x000fe200000e0609ULL,
0x0000001908147210ULL, 0x000fe20007f1e0ffULL, 0x0000000105107824ULL, 0x000fe200078e0212ULL,
0x0000004b16197212ULL, 0x000fe200078efcffULL, 0x0000008013127825ULL, 0x000fc800078e00ffULL,
0x0000000105187824ULL, 0x000fe200078e0218ULL, 0x0000004b121d7212ULL, 0x000fe200078efcffULL,
0x0000000115157824ULL, 0x000fe200000e0609ULL, 0x0000001908167210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000001d08127210ULL, 0x000fc60007f5e0ffULL,
0x00000001051c7824ULL, 0x000fe200078e021cULL, 0x0000004b18217212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000004b101b7212ULL, 0x000fc600078efcffULL, 0x00000001051e7824ULL, 0x000fe400078e021eULL,
0x0000000117177824ULL, 0x000fe200000e0609ULL, 0x0000002108187210ULL, 0x000fe20007f1e0ffULL,
0x00000001051a7824ULL, 0x000fe200078e021aULL, 0x0000004b1c217212ULL, 0x000fe200078efcffULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x0000000105207824ULL, 0x000fe200078e0220ULL,
0x0000004b1e257212ULL, 0x080fe200078efcffULL, 0x000000010d0d7824ULL, 0x100fe200008e0609ULL,
0x0000001b08107210ULL, 0x000fe20007f3e0ffULL, 0x0000000119197824ULL, 0x100fe200000e0609ULL,
0x00000021081c7210ULL, 0x000fe20007f1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000000c2d7faeULL, 0x0003e6000b901c46ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000004b1a237212ULL, 0x080fe200078efcffULL, 0x000000000e2f7faeULL, 0x0003e4000b901c46ULL,
0x0000000113137824ULL, 0x000fe200010e0609ULL, 0x00000025081e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000105227824ULL, 0x040fe200078e0222ULL, 0x0000004b20257212ULL, 0x000fe200078efcffULL,
0x0000000105247824ULL, 0x000fc400078e0224ULL, 0x0000000111117824ULL, 0x100fe200008e0609ULL,
0x00000023081a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000105267824ULL, 0x000fe400078e0226ULL,
0x000000011d1d7824ULL, 0x000fe200000e0609ULL, 0x0000002508207210ULL, 0x000fe20007f1e0ffULL,
0x0000000105287824ULL, 0x000fe200078e0227ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x0000008022227825ULL, 0x000fc600078e00ffULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000004b224d7212ULL, 0x080fe400078efcffULL,
0x0000000014357faeULL, 0x0003e2000b901c46ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000004b244f7212ULL, 0x080fe400078efcffULL, 0x0000000016377faeULL, 0x0003e2000b901c46ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000004b26517212ULL, 0x000fc400078efcffULL,
0x0000000018397faeULL, 0x0003e2000b901c46ULL, 0x0000000121217824ULL, 0x100fe200000e0609ULL,
0x0000004b284b7212ULL, 0x000fe200078efcffULL, 0x000000011b1b7824ULL, 0x100fe200008e0609ULL,
0x0000004d08227210ULL, 0x000fe20007f1e0ffULL, 0x000000011f1f7824ULL, 0x100fe200010e0609ULL,
0x0000004f08247210ULL, 0x000fe40007f3e0ffULL, 0x0000005108267210ULL, 0x000fe20007f5e0ffULL,
0x0000000123237824ULL, 0x100fe200000e0609ULL, 0x0000004b08087210ULL, 0x000fe20007f7e0ffULL,
0x0000000125257824ULL, 0x100fe200008e0609ULL, 0x000000001a3b7faeULL, 0x0003e2000b901c46ULL,
0x0000000127277824ULL, 0x000fc400010e0609ULL, 0x0000000129097824ULL, 0x000fe200018e0609ULL,
0x000000001c3d7faeULL, 0x0003e8000b901c46ULL, 0x000000001e3f7faeULL, 0x0003e8000b901c46ULL,
0x0000000020417faeULL, 0x0003e8000b901c46ULL, 0x0000000022437faeULL, 0x0003e8000b901c46ULL,
0x0000000024457faeULL, 0x0003e8000b901c46ULL, 0x0000000026477faeULL, 0x0003e8000b901c46ULL,
0x0000000008497faeULL, 0x0003e4000b901c46ULL, 0x0000000477777836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff757424ULL, 0x000fc600078e00ffULL,
0x000000707700720cULL, 0x000fda0003f06070ULL, 0x00009000ff088b82ULL, 0x002e620000000a00ULL,
0x00000002720b8824ULL, 0x000fe200078e0277ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff5b7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000040b088825ULL, 0x002fe200078e0008ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000608758981ULL, 0x000322000c1e1900ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fc4000001ff00ULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000087805ULL, 0x002fce000001ff00ULL, 0xfffffff804117812ULL, 0x000fe200078ec0ffULL,
0x00002000696e7824ULL, 0x000fe400078e025aULL, 0x000000015b6f7836ULL, 0x000fe20000000000ULL,
0x0000000711127812ULL, 0x000fe200078ef804ULL, 0x000020006e6e7836ULL, 0x000fe40000000000ULL,
0x0000002004137836ULL, 0x000fe40000000000ULL, 0x0000000112107824ULL, 0x040fe400078e025bULL,
0x0000000812117824ULL, 0x040fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ec0ffULL,
0x0000000812157824ULL, 0x000fc400078e00ffULL, 0x0000000112127824ULL, 0x000fe200078e026fULL,
0xfffffff811117812ULL, 0x000fe400078ee210ULL, 0x00000004ff107819ULL, 0x000fe40000011604ULL,
0xfffffff815157812ULL, 0x000fe200078ee212ULL, 0x00000010115c7824ULL, 0x000fe200078e026eULL,
0x0000000804117812ULL, 0x000fe200078ec0ffULL, 0x000000025b107824ULL, 0x000fe200078e0210ULL,
0x0000000713767812ULL, 0x000fe200078ef804ULL, 0x0000001015607824ULL, 0x000fe200078e026eULL,
0x0000000711167812ULL, 0x000fe200078ef804ULL, 0x000000005c5c783bULL, 0x000e640000000200ULL,
0x0000000176137824ULL, 0x000fe200078e025bULL, 0x0000001016647812ULL, 0x040fe200078efcffULL,
0x000000006060783bULL, 0x000ea20000000200ULL, 0x0000000116117824ULL, 0x000fc400078e0210ULL,
0x0000001016147824ULL, 0x000fe400078e00ffULL, 0x0000000164127824ULL, 0x040fe400078e0210ULL,
0x0000001064157824ULL, 0x000fe200078e00ffULL, 0xfffffff014117812ULL, 0x000fe200078ee211ULL,
0x0000001016177824ULL, 0x000fe400078e00ffULL, 0x0000000876147824ULL, 0x040fe200078e00ffULL,
0xfffffff015127812ULL, 0x000fe200078ee212ULL, 0x0000000210157836ULL, 0x000fe20000000000ULL,
0x0000000a11117c11ULL, 0x000fe2000f8e20ffULL, 0x00000001766f7824ULL, 0x000fe200078e026fULL,
0xfffffff814137812ULL, 0x000fe200078ee213ULL, 0x0000000116167824ULL, 0x100fe200078e0215ULL,
0x0000000a12127c11ULL, 0x000fe2000f8e20ffULL, 0x000000001154783bULL, 0x0007620000000200ULL,
0x0000000164157824ULL, 0x000fc400078e0215ULL, 0xfffffff017167812ULL, 0x000fe200078ee216ULL,
0x000000001218783bULL, 0x000f620000000200ULL, 0x0000001064647824ULL, 0x000fe400078e00ffULL,
0x0000000876767824ULL, 0x000fe200078e00ffULL, 0x0000000a16167c11ULL, 0x000fe2000f8e20ffULL,
0x000000025b5b7836ULL, 0x000fe20000000000ULL, 0xfffffff064157812ULL, 0x000fe200078ee215ULL,
0x0000001013647824ULL, 0x000fe200078e026eULL, 0xfffffff8766f7812ULL, 0x000fe400078ee26fULL,
0x000000085b00780cULL, 0x000fc40003f05270ULL, 0x00000010ff107819ULL, 0x102fe2000001165fULL,
0x000000106f6f7824ULL, 0x000fe200078e026eULL, 0x0000ffff5f177812ULL, 0x040fe200078ec0ffULL,
0x000000006464783bULL, 0x000e620000000200ULL, 0x000000ff10107812ULL, 0x000fe400078ec0ffULL,
0x00000018ff147819ULL, 0x000fe4000001165fULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x000000ff5f5f7812ULL, 0x000fc400078ec0ffULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x20000010ff117230ULL, 0x008fe20000004100ULL, 0x00000008ff107819ULL, 0x000fe40000011617ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x0000ffff637a7812ULL, 0x004fe200078ec0ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fe20000011614ULL,
0x20000010ff107230ULL, 0x000fe20000004100ULL, 0x00000010ff117819ULL, 0x000fc40000011611ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff6c7819ULL, 0x000fe40000011610ULL,
0x00001054146d7816ULL, 0x000fe40000000011ULL, 0x000010546c6c7816ULL, 0x000fe4000000005fULL,
0x00000018ff5f7819ULL, 0x000fe40000011663ULL, 0x0000000a15117c11ULL, 0x000fc4000f8e20ffULL,
0x0000005fff78723eULL, 0x000fe200020006ffULL, 0x0000006c540c723cULL, 0x020fe2000004180cULL,
0x00000010ff5f7819ULL, 0x000fe20000011663ULL, 0x000000001614783bULL, 0x000ea20000000200ULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x20000078ff797230ULL, 0x000fe20000004100ULL,
0x000000ff5f787812ULL, 0x000fe200078ec0ffULL, 0x0000006c1808723cULL, 0x000fe20000041808ULL,
0x00000008ff5f7819ULL, 0x000fe2000001167aULL, 0x000000001110783bULL, 0x000ee20000000200ULL,
0x00000078ff78723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000018ff8c7819ULL, 0x002fe20000011665ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff6c7819ULL, 0x000fc4000001165fULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x0000105479797816ULL, 0x000fe40000000078ULL,
0x000010546c787816ULL, 0x000fe40000000063ULL, 0x000000006f6c783bULL, 0x000e620000000200ULL,
0x000000ff658d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff65977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff927819ULL, 0x000fc40000011666ULL, 0x00000018ff8f7819ULL, 0x000fe40000011666ULL,
0x000000ff668e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff66947812ULL, 0x000fe200078ec0ffULL,
0x00000078140c723cULL, 0x004fe2000004180cULL, 0x00000018ff637819ULL, 0x000fe4000001165cULL,
0x00000010ff957819ULL, 0x100fe40000011667ULL, 0x00000018ff667819ULL, 0x000fe20000011667ULL,
0x000000781008723cULL, 0x008fe20000041808ULL, 0x0000ffff67967812ULL, 0x000fc400078ec0ffULL,
0x000000ff619a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x100fe40000011660ULL,
0x00000010ff797819ULL, 0x000fe40000011665ULL, 0x000000ff67657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x000fe40000011660ULL, 0x000000ff607b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff60987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff787819ULL, 0x100fe40000011662ULL,
0x00000018ff607819ULL, 0x000fe40000011662ULL, 0x00000010ff827819ULL, 0x102fe4000001166cULL,
0x00000018ff887819ULL, 0x000fe4000001166cULL, 0x000000ff6c877812ULL, 0x000fc400078ec0ffULL,
0x0000ffff6c7c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff62917812ULL, 0x040fe400078ec0ffULL,
0x0000ffff628b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6c7819ULL, 0x000fe4000001165cULL,
0x00000063ff62723eULL, 0x000fe400020006ffULL, 0x0000009aff63723eULL, 0x000fc400020006ffULL,
0x00000010ff7d7819ULL, 0x100fe2000001166dULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000018ff8a7819ULL, 0x000fe2000001166dULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x000000ff6d897812ULL, 0x040fe400078ec0ffULL, 0x0000ffff6d807812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5c9a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff937819ULL, 0x000fc40000011661ULL,
0x000000ff6c6d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6c7819ULL, 0x000fe4000001169aULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011664ULL, 0x00000060ff9a723eULL, 0x000fe200020006ffULL,
0x2000006dff9b7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x000000ff5c767812ULL, 0x000fe200078ec0ffULL, 0x20000093ff5c7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000005fff93723eULL, 0x000fe200020006ffULL,
0x2000009aff5f7230ULL, 0x000fe20000004100ULL, 0x0000008fff6d723eULL, 0x000fe200020006ffULL,
0x2000006cff9a7230ULL, 0x000fe20000004100ULL, 0x00000010ff7f7819ULL, 0x000fe20000011661ULL,
0x2000008cff8f7230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x2000006dff8c7230ULL, 0x000fe20000004100ULL, 0x0000008eff6c723eULL, 0x000fe200020006ffULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x2000008dff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff647e7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff7f6d7812ULL, 0x000fe200078ec0ffULL,
0x20000066ff6c7230ULL, 0x000fe20000004100ULL, 0x00000076ff99723eULL, 0x000fc400020006ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x0000ffff61617812ULL, 0x000fe400078ec0ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x0000006dff66723eULL, 0x000fe200020006ffULL,
0x20000065ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fc40000011664ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000ffff64647812ULL, 0x000fe400078ec0ffULL,
0x00000091ff60723eULL, 0x000fe200020006ffULL, 0x2000007eff917230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011661ULL, 0x20000066ff617230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011664ULL, 0x20000067ff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff987819ULL, 0x000fe20000011698ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fc40000011699ULL, 0x00000010ff677819ULL, 0x000fe4000001169aULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x00000098ff7f723eULL, 0x000fe400020006ffULL,
0x0000105467647816ULL, 0x000fe40000000064ULL, 0x00000065ff98723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x000000ff79677812ULL, 0x000fc400078ec0ffULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff657819ULL, 0x000fe4000001169bULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x20000090ff797230ULL, 0x000fe20000004100ULL,
0x0000105462657816ULL, 0x000fe20000000065ULL, 0x20000098ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff987819ULL, 0x000fe20000011697ULL, 0x20000066ff907230ULL, 0x000fe20000004100ULL,
0x000000ff92977812ULL, 0x000fe200078ec0ffULL, 0x20000067ff927230ULL, 0x000fe20000004100ULL,
0x00000018ff667819ULL, 0x100fe2000001165dULL, 0x000000645450723cULL, 0x000fe20000041850ULL,
0x00000010ff677819ULL, 0x000fc4000001165dULL, 0x000000ff5d997812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5d9c7812ULL, 0x000fe200078ec0ffULL, 0x00000064184c723cULL, 0x000fe2000004184cULL,
0x00000018ff5d7819ULL, 0x100fe4000001165eULL, 0x00000066ff9a723eULL, 0x000fe400020006ffULL,
0x000000ff5e9b7812ULL, 0x040fe400078ec0ffULL, 0x00000010ff657819ULL, 0x000fe2000001165eULL,
0x2000009aff647230ULL, 0x000fe20000004100ULL, 0x0000ffff5e667812ULL, 0x000fc400078ec0ffULL,
0x0000005dff5e723eULL, 0x000fe400020006ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5d7819ULL, 0x000fe2000001169cULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x00000067ff9a723eULL, 0x000fe400020006ffULL,
0x0000005dff67723eULL, 0x000fe200020006ffULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x2000009aff9a7230ULL, 0x000fe20000004100ULL,
0x0000009bff9b723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000066ff9c723eULL, 0x000fc400020006ffULL, 0x000000ff65657812ULL, 0x000fe200078ec0ffULL,
0x2000009bff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe40000011699ULL,
0x00000010ff9b7819ULL, 0x000fe20000011664ULL, 0x2000009cff647230ULL, 0x000fe20000004100ULL,
0x00000010ff9a7819ULL, 0x000fe4000001169aULL, 0x00000010ff997819ULL, 0x000fe40000011667ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x000010549b677816ULL, 0x000fe2000000009aULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000105499667816ULL, 0x000fe40000000066ULL, 0x00000008ff997819ULL, 0x000fe40000011694ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x000000665448723cULL, 0x000fe20000041848ULL, 0x00000097ff97723eULL, 0x000fc400020006ffULL,
0x000000ff959a7812ULL, 0x000fe200078ec0ffULL, 0x20000098ff957230ULL, 0x000fe20000004100ULL,
0x00000099ff98723eULL, 0x000fe200020006ffULL, 0x000000661844723cULL, 0x000fe20000041844ULL,
0x00000008ff967819ULL, 0x000fe20000011696ULL, 0x20000097ff947230ULL, 0x000fe20000004100ULL,
0x0000105464647816ULL, 0x000fe2000000005dULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x000000ff785d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff787819ULL, 0x000fe40000011691ULL,
0x00000010ff677819ULL, 0x000fe40000011690ULL, 0x00000010ff667819ULL, 0x000fe40000011693ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x0000009aff97723eULL, 0x000fc400020006ffULL,
0x00000096ff99723eULL, 0x000fe400020006ffULL, 0x000010545e657816ULL, 0x000fe20000000065ULL,
0x20000097ff967230ULL, 0x000fe20000004100ULL, 0x0000105467787816ULL, 0x000fe20000000078ULL,
0x20000099ff5e7230ULL, 0x000fe20000004100ULL, 0x0000105466797816ULL, 0x000fe40000000079ULL,
0x00000010ff8c7819ULL, 0x000fe2000001168cULL, 0x000000645440723cULL, 0x000fe20000041840ULL,
0x00000010ff677819ULL, 0x000fc40000011694ULL, 0x00000010ff667819ULL, 0x000fe4000001168dULL,
0x00000010ff8d7819ULL, 0x000fe20000011698ULL, 0x00000064183c723cULL, 0x000fe2000004183cULL,
0x000010548c677816ULL, 0x000fe40000000067ULL, 0x00000010ff8c7819ULL, 0x000fe4000001166cULL,
0x000010548d667816ULL, 0x000fe20000000066ULL, 0x000000781828723cULL, 0x000fe20000041828ULL,
0x00000010ff6c7819ULL, 0x000fc4000001166dULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff927819ULL, 0x000fe20000011692ULL, 0x000000661820723cULL, 0x000fe20000041820ULL,
0x00000010ff647819ULL, 0x000fe4000001168eULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff6d7819ULL, 0x000fe20000011696ULL, 0x000000785438723cULL, 0x000fe20000041838ULL,
0x00000010ff8d7819ULL, 0x000fc4000001165eULL, 0x000010548f657816ULL, 0x000fe40000000092ULL,
0x0000105495647816ULL, 0x000fe20000000064ULL, 0x000000665430723cULL, 0x000fe20000041830ULL,
0x000010548c6d7816ULL, 0x000fe4000000006dULL, 0x000010548d6c7816ULL, 0x000fe4000000006cULL,
0x00000010ff817819ULL, 0x100fe2000001166eULL, 0x000000641824723cULL, 0x000fe20000041824ULL,
0x00000018ff847819ULL, 0x000fc4000001166eULL, 0x000000ff6e837812ULL, 0x040fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe2000001166fULL, 0x0000006c181c723cULL, 0x000fe2000004181cULL,
0x00000018ff867819ULL, 0x000fe4000001166fULL, 0x000000ff6f857812ULL, 0x040fe400078ec0ffULL,
0x0000ffff6e6e7812ULL, 0x000fe200078ec0ffULL, 0x000000645434723cULL, 0x000fe20000041834ULL,
0x0000ffff6f6f7812ULL, 0x000fc400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000008ff7c7819ULL, 0x000fe2000001167cULL, 0x0000006c542c723cULL, 0x000fe2000004182cULL,
0x00000087ff5e723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fe40000011680ULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8b7819ULL, 0x000fe2000001168bULL, 0x2000005eff547230ULL, 0x000fe20000004100ULL,
0x000000ff82827812ULL, 0x000fc400078ec0ffULL, 0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6e7819ULL, 0x000fe4000001166eULL, 0x000000ff76767812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff1a7819ULL, 0x000fc40000011663ULL, 0x00000010ff1b7819ULL, 0x000fe40000011661ULL,
0x00000010ff197819ULL, 0x000fe40000011662ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000080ff64723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000089ff557230ULL, 0x000fe20000004100ULL,
0x00000083ff57723eULL, 0x000fc400020006ffULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000084ff797230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000081ff667230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000008bff877230ULL, 0x000fe20000004100ULL, 0x00000086ff5e723eULL, 0x000fe200020006ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x2000008aff567230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000007dff65723eULL, 0x000fe200020006ffULL,
0x2000007cff7d7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000064ff7c7230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000085ff787230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000082ff807230ULL, 0x000fe20000004100ULL, 0x000010545c1b7816ULL, 0x000fe2000000001bULL,
0x20000065ff677230ULL, 0x000fe20000004100ULL, 0x00001054191a7816ULL, 0x000fe2000000001aULL,
0x2000006eff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fe2000001165fULL,
0x20000076ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x0000001a1448723cULL, 0x000fe20000041848ULL, 0x00001054185d7816ULL, 0x000fc4000000005dULL,
0x00000010ff187819ULL, 0x000fe40000011654ULL, 0x00000010ff547819ULL, 0x000fe20000011655ULL,
0x0000001a1044723cULL, 0x000fe20000041844ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff657819ULL, 0x000fe4000001167eULL,
0x00000010ff1b7819ULL, 0x000fc4000001167cULL, 0x00000010ff1a7819ULL, 0x000fe40000011657ULL,
0x00000010ff647819ULL, 0x000fe4000001167bULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff5c7819ULL, 0x000fe40000011660ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff887819ULL, 0x000fc40000011688ULL, 0x00000010ff197819ULL, 0x000fe40000011680ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff557819ULL, 0x000fe40000011667ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff577819ULL, 0x000fc4000001166cULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x000010541b547816ULL, 0x000fe40000000054ULL, 0x00001054791b7816ULL, 0x000fe40000000066ULL,
0x000010547a657816ULL, 0x000fc40000000065ULL, 0x000010547f647816ULL, 0x000fe40000000064ULL,
0x00001054875c7816ULL, 0x000fe4000000005cULL, 0x0000105488197816ULL, 0x000fe40000000019ULL,
0x000010547d187816ULL, 0x000fe20000000018ULL, 0x000000641450723cULL, 0x000fe20000041850ULL,
0x0000105456557816ULL, 0x000fe40000000055ULL, 0x00001054571a7816ULL, 0x000fc4000000001aULL,
0x000010545e797816ULL, 0x000fe20000000061ULL, 0x00000064104c723cULL, 0x000fe2000004184cULL,
0x000010546f787816ULL, 0x000fca0000000078ULL, 0x0000005c1440723cULL, 0x000fec0000041840ULL,
0x0000005c103c723cULL, 0x000fec000004183cULL, 0x000000181438723cULL, 0x000fec0000041838ULL,
0x000000541434723cULL, 0x000fec0000041834ULL, 0x0000001a1430723cULL, 0x000fec0000041830ULL,
0x00000078142c723cULL, 0x000fec000004182cULL, 0x000000181028723cULL, 0x000fec0000041828ULL,
0x000000541024723cULL, 0x000fec0000041824ULL, 0x0000001a1020723cULL, 0x000fec0000041820ULL,
0x00000078101c723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe400980947ULL, 0x000fde000383ffffULL, 0x0000000608107220ULL, 0x080fe20000410000ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0x0000000609127220ULL, 0x080fe20000410000ULL,
0x0000000650117220ULL, 0x080fe20000410000ULL, 0x0000000651517220ULL, 0x080fe20000410000ULL,
0x0000000652527220ULL, 0x080fe20000410000ULL, 0x0000000653537220ULL, 0x080fe20000410000ULL,
0x01a68808070879a7ULL, 0x000262000850003fULL, 0x0000000648487220ULL, 0x080fe20000410000ULL,
0x0000000649497220ULL, 0x080fe20000410000ULL, 0x000000064a4a7220ULL, 0x080fe20000410000ULL,
0x000000064b4b7220ULL, 0x080fe20000410000ULL, 0x0000000640407220ULL, 0x080fe20000410000ULL,
0x0000000641417220ULL, 0x080fe20000410000ULL, 0x0000000642427220ULL, 0x080fe20000410000ULL,
0x0000000643437220ULL, 0x080fe20000410000ULL, 0x000000060c0c7220ULL, 0x080fe20000410000ULL,
0x000000060d0d7220ULL, 0x080fe20000410000ULL, 0x000000060e0e7220ULL, 0x080fe20000410000ULL,
0x000000060f0f7220ULL, 0x080fe20000410000ULL, 0x0000000638387220ULL, 0x080fe20000410000ULL,
0x0000000639397220ULL, 0x080fe20000410000ULL, 0x000000063a3a7220ULL, 0x080fe20000410000ULL,
0x000000063b3b7220ULL, 0x080fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x080fe20000410000ULL, 0x0000000636367220ULL, 0x080fe20000410000ULL,
0x0000000637377220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000632327220ULL, 0x080fe20000410000ULL,
0x0000000633337220ULL, 0x080fe20000410000ULL, 0x000000062c2c7220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x000000062e2e7220ULL, 0x080fe20000410000ULL,
0x000000062f2f7220ULL, 0x080fe20000410000ULL, 0x000000064c137220ULL, 0x080fe20000410000ULL,
0x000000064d4d7220ULL, 0x080fe20000410000ULL, 0x000000064e4e7220ULL, 0x080fe20000410000ULL,
0x000000064f4f7220ULL, 0x080fe20000410000ULL, 0x0000000644447220ULL, 0x080fe20000410000ULL,
0x0000000645457220ULL, 0x080fe20000410000ULL, 0x0000000646467220ULL, 0x080fe20000410000ULL,
0x0000000647477220ULL, 0x080fe20000410000ULL, 0x000000063c3c7220ULL, 0x080fe20000410000ULL,
0x000000063d3d7220ULL, 0x080fe20000410000ULL, 0x000000063e3e7220ULL, 0x080fe20000410000ULL,
0x000000063f3f7220ULL, 0x080fe20000410000ULL, 0x000000060a147220ULL, 0x080fe20000410000ULL,
0x000000060b157220ULL, 0x080fe20000410000ULL, 0x0000000628287220ULL, 0x080fe20000410000ULL,
0x0000000629297220ULL, 0x080fe20000410000ULL, 0x000000062a2a7220ULL, 0x080fe20000410000ULL,
0x000000062b2b7220ULL, 0x080fe20000410000ULL, 0x0000000624247220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x0000000626267220ULL, 0x080fe20000410000ULL,
0x0000000627277220ULL, 0x080fe20000410000ULL, 0x0000000620207220ULL, 0x080fe20000410000ULL,
0x0000000621217220ULL, 0x080fe20000410000ULL, 0x0000000622227220ULL, 0x080fe20000410000ULL,
0x0000000623237220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x000000061d1d7220ULL, 0x080fe20000410000ULL, 0x000000061e1e7220ULL, 0x080fe20000410000ULL,
0x000000061f1f7220ULL, 0x000fe20000410000ULL, 0x0000000704167812ULL, 0x002fce00078ec0ffULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x01a68809070075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a18177210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x000000170a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01a68809070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000404087824ULL, 0x000fe200078e00ffULL, 0x0000000a71177c11ULL, 0x000fe4000f8e38ffULL,
0x000000586800720cULL, 0x000fe40003f06070ULL, 0xfffffff008087812ULL, 0x000fca00078ec0ffULL,
0x0000000117177824ULL, 0x000fca00078e0208ULL, 0x01a4000017087984ULL, 0x0002a20000000c00ULL,
0x0000001c00c48947ULL, 0x000fea0003800000ULL, 0x0000010068ab7824ULL, 0x000fe200078e0203ULL,
0x0000860000097ab9ULL, 0x000fe20000000800ULL, 0x0000000204aa7824ULL, 0x000fe200078e00ffULL,
0x00008c00ff567b82ULL, 0x000ee20000000a00ULL, 0x00008400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000ab74187248ULL, 0x000fe40007fe0000ULL, 0x00000006aaaa7812ULL, 0x000fc600078ec0ffULL,
0x0000000118ab7824ULL, 0x000fe200078e0aabULL, 0x0000000004187211ULL, 0x000fe200078ff0ffULL,
0x0000000baaa97c36ULL, 0x000fe40008000000ULL, 0x000000ffff667224ULL, 0x000fe200078e0aabULL,
0x00000009ff197c19ULL, 0x000fe20008011618ULL, 0x00000008181a7836ULL, 0x000fe20000000000ULL,
0x000000aba900720cULL, 0x000fe20003f06070ULL, 0x00000010181b7836ULL, 0x000fe20000000000ULL,
0x0000000519197c48ULL, 0x000fe2000bfe0000ULL, 0x00000018184c7836ULL, 0x000fe20000000000ULL,
0x00000009ff1a7c19ULL, 0x000fe2000801161aULL, 0x00000008aa187c36ULL, 0x000fe20008000000ULL,
0x00000005a99a7e46ULL, 0x000fe2000b800066ULL, 0x0000000419677c24ULL, 0x000fe2000f8e02ffULL,
0x000000051a1a7c48ULL, 0x000fc4000bfe0000ULL, 0x000000ab1800720cULL, 0x000fe40003f26070ULL,
0x0000000518187e46ULL, 0x000fe2000b800066ULL, 0x000000041a6f7c24ULL, 0x000fe2000f8e02ffULL,
0x000000ff9a9a7207ULL, 0x000fe40000000000ULL, 0x00000004ff187819ULL, 0x000fe40000011618ULL,
0x00000009ff1b7c19ULL, 0x000fe4000801161bULL, 0x000000ff181a7207ULL, 0x000fc40000800000ULL,
0x000000679a197211ULL, 0x040fe400078fe0ffULL, 0x000000051b1b7c48ULL, 0x000fe2000bfe0000ULL,
0x00000001675f7824ULL, 0x000fe200078e021aULL, 0x00000009ff4c7c19ULL, 0x000fe2000801164cULL,
0x0000000219187825ULL, 0x108fe200078e0056ULL, 0x0000006f9a957211ULL, 0x000fe400078fe0ffULL,
0x000000054c4c7c48ULL, 0x000fe2000bfe0000ULL, 0x000000025f5e7825ULL, 0x000fe200078e0056ULL,
0x0000000618a77981ULL, 0x0044e6000c1e9500ULL, 0x000000041b6d7c24ULL, 0x000fe2000f8e02ffULL,
0x000000065ea87981ULL, 0x000ee2000c1e9500ULL, 0x000000011a557824ULL, 0x000fc400078e026fULL,
0x000000011a1b7824ULL, 0x000fe200078e026dULL, 0x0000006d9a5d7211ULL, 0x000fe200078fe0ffULL,
0x0000000295947825ULL, 0x000fe200078e0056ULL, 0x00000010aa857812ULL, 0x000fc600078efcffULL,
0x000000021b187825ULL, 0x104fe400078e0056ULL, 0x0000000694947981ULL, 0x000564000c1e9500ULL,
0x000000025d5c7825ULL, 0x100fe400078e0056ULL, 0x0000000618187981ULL, 0x000f64000c1e9500ULL,
0x0000000255547825ULL, 0x000fc800078e0056ULL, 0x000000044c697c24ULL, 0x000fe2000f8e02ffULL,
0x000000065c957981ULL, 0x004f62000c1e9500ULL, 0x00000008854c7c36ULL, 0x000fc60008000000ULL,
0x0000000654977981ULL, 0x000562000c1e9500ULL, 0x000000699a5b7211ULL, 0x000fe200078fe0ffULL,
0x0000000b85867c36ULL, 0x000fe20008000000ULL, 0x000000054c5e7e46ULL, 0x002fe2000b800066ULL,
0x000000011a617824ULL, 0x000fe200078e0269ULL, 0x000000ab4c00720cULL, 0x080fe20003f26070ULL,
0x000000025b5a7825ULL, 0x000fe200078e0056ULL, 0x00000004ff5e7819ULL, 0x000fe4000001165eULL,
0x000000ab8600720cULL, 0x000fe20003f06070ULL, 0x00000002611a7825ULL, 0x000fe200078e0056ULL,
0x0000000586987e46ULL, 0x000fe2000b800066ULL, 0x000000065a937981ULL, 0x000362000c1e9500ULL,
0x000000ff5e5e7207ULL, 0x000fc40000800000ULL, 0x000000ff98987207ULL, 0x000fe20000000000ULL,
0x000000061a507981ULL, 0x000364000c1e9500ULL, 0x00000001678d7824ULL, 0x000fe200078e025eULL,
0x0000006f98557211ULL, 0x004fe200078fe0ffULL, 0x000000015e5b7824ULL, 0x002fe200078e026fULL,
0x00000067981b7211ULL, 0x000fe200078fe0ffULL, 0x000000028d8c7825ULL, 0x000fe200078e0056ULL,
0x00000020aa767812ULL, 0x000fc600078efcffULL, 0x000000021b1a7825ULL, 0x100fe200078e0056ULL,
0x00000069985d7211ULL, 0x000fe200078fe0ffULL, 0x000000068c8c7981ULL, 0x000ea4000c1e9500ULL,
0x0000000255547825ULL, 0x100fe400078e0056ULL, 0x000000061a8b7981ULL, 0x000ea4000c1e9500ULL,
0x000000025b5a7825ULL, 0x000fe400078e0056ULL, 0x0000000654897981ULL, 0x0002a4000c1e9500ULL,
0x000000015e617824ULL, 0x000fc400078e0269ULL, 0x0000000876607c36ULL, 0x000fe20008000000ULL,
0x000000065a8a7981ULL, 0x000ea2000c1e9500ULL, 0x0000006d985f7211ULL, 0x000fe200078fe0ffULL,
0x0000000b76787c36ULL, 0x000fe40008000000ULL, 0x000000015e197824ULL, 0x000fe400078e026dULL,
0x0000000261547825ULL, 0x002fe200078e0056ULL, 0x0000000560617e46ULL, 0x000fc6000b800066ULL,
0x000000025d5c7825ULL, 0x100fe200078e0056ULL, 0x000000ab7800720cULL, 0x080fe20003f06070ULL,
0x0000000654547981ULL, 0x000ea2000c1e9500ULL, 0x00000005784c7e46ULL, 0x000fe2000b800066ULL,
0x000000025f5e7825ULL, 0x000fe200078e0056ULL, 0x000000ab6000720cULL, 0x000fe20003f26070ULL,
0x000000065c877981ULL, 0x0002a2000c1e9500ULL, 0x00000004ff617819ULL, 0x000fe20000011661ULL,
0x00000002191a7825ULL, 0x000fe200078e0056ULL, 0x000000ff4c4c7207ULL, 0x000fe20000000000ULL,
0x000000065e887981ULL, 0x000ea8000c1e9500ULL, 0x000000061a197981ULL, 0x0002a4000c1e9500ULL,
0x000000ff615c7207ULL, 0x002fc40000800000ULL, 0x0000006f4c5b7211ULL, 0x000fc600078fe0ffULL,
0x000000015c617824ULL, 0x000fe400078e026fULL, 0x000000025b5a7825ULL, 0x000fe200078e0056ULL,
0x000000674c1b7211ULL, 0x000fc600078fe0ffULL, 0x0000000261607825ULL, 0x100fe200078e0056ULL,
0x000000065a7b7981ULL, 0x0002a2000c1e9500ULL, 0x0000006d4c657211ULL, 0x040fe400078fe0ffULL,
0x000000021b1a7825ULL, 0x000fe200078e0056ULL, 0x00000006607c7981ULL, 0x000ea2000c1e9500ULL,
0x000000694c637211ULL, 0x000fe400078fe0ffULL, 0x00000001677f7824ULL, 0x000fe200078e025cULL,
0x000000061a7d7981ULL, 0x0002a2000c1e9500ULL, 0x000000015c557824ULL, 0x000fc400078e026dULL,
0x000000015c5d7824ULL, 0x000fe200078e0269ULL, 0x00000030aa5b7812ULL, 0x002fe200078efcffULL,
0x000000027f7e7825ULL, 0x000fc800078e0056ULL, 0x0000000265647825ULL, 0x100fe400078e0056ULL,
0x000000067e7e7981ULL, 0x000ea4000c1e9500ULL, 0x00000002551a7825ULL, 0x100fe400078e0056ULL,
0x0000000664797981ULL, 0x000ea4000c1e9500ULL, 0x0000000263627825ULL, 0x100fe400078e0056ULL,
0x000000061a1a7981ULL, 0x000ea4000c1e9500ULL, 0x000000025d5c7825ULL, 0x000fc400078e0056ULL,
0x00000006627a7981ULL, 0x000ea4000c1e9500ULL, 0x000000085b5a7c36ULL, 0x000fe40008000000ULL,
0x000000065c557981ULL, 0x0002a2000c1e9500ULL, 0x0000000b5b5f7c36ULL, 0x000fe40008000000ULL,
0x000000055a5e7e46ULL, 0x000fe4000b800066ULL, 0x000000ab5a00720cULL, 0x080fe40003f26070ULL,
0x000000ab5f00720cULL, 0x000fc40003f06070ULL, 0x000000055f967e46ULL, 0x000fe4000b800066ULL,
0x00000004ff5e7819ULL, 0x000fe4000001165eULL, 0x000000ff96967207ULL, 0x000fe40000000000ULL,
0x000000ff5e5e7207ULL, 0x000fe40000800000ULL, 0x00000067965d7211ULL, 0x042fe400078fe0ffULL,
0x0000006d96817211ULL, 0x000fe200078fe0ffULL, 0x0000000167677824ULL, 0x000fc400078e025eULL,
0x000000015e6d7824ULL, 0x000fe400078e026dULL, 0x0000000267667825ULL, 0x000fc800078e0056ULL,
0x000000025d5c7825ULL, 0x100fe400078e0056ULL, 0x0000000666667981ULL, 0x000ea4000c1e9500ULL,
0x0000000281807825ULL, 0x100fe400078e0056ULL, 0x000000065c657981ULL, 0x0002a4000c1e9500ULL,
0x000000026d6c7825ULL, 0x000fe400078e0056ULL, 0x0000000680627981ULL, 0x000ea2000c1e9500ULL,
0x0000006f96837211ULL, 0x000fc600078fe0ffULL, 0x000000066c1b7981ULL, 0x000ea2000c1e9500ULL,
0x000000015e6f7824ULL, 0x000fe400078e026fULL, 0x0000000283827825ULL, 0x000fc800078e0056ULL,
0x000000026f6e7825ULL, 0x000fe200078e0056ULL, 0x0000000682637981ULL, 0x0002a4000c1e9500ULL,
0x00000069965d7211ULL, 0x002fe400078fe0ffULL, 0x000000066e647981ULL, 0x0002a2000c1e9500ULL,
0x000000015e697824ULL, 0x000fe400078e0269ULL, 0x000000025d5c7825ULL, 0x000fc800078e0056ULL,
0x0000000269567825ULL, 0x000fe200078e0056ULL, 0x000000065c607981ULL, 0x000ea8000c1e9500ULL,
0x0000000656617981ULL, 0x0002a2000c1e9500ULL, 0xfffffff09a9a7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff997424ULL, 0x000fc800078e00ffULL, 0x00000001ab9a7824ULL, 0x000fc800078e029aULL,
0x00000001a9a67824ULL, 0x000fe200078e0a9aULL, 0x00000001aa917812ULL, 0x000fc800078efcffULL,
0x000000a699a67219ULL, 0x040fe200000006ffULL, 0x0000000b91927c36ULL, 0x000fe20008000000ULL,
0xfffffff04ca27812ULL, 0x000fe400078ec0ffULL, 0xfffffff0964c7812ULL, 0x000fe200078ec0ffULL,
0x0000000192967824ULL, 0x000fe200078e0a9aULL, 0x00000008aa8e7812ULL, 0x040fe400078efcffULL,
0x00000009aa8d7812ULL, 0x000fe400078efcffULL, 0x0000009699967219ULL, 0x000fc400000006ffULL,
0xfffffff098987812ULL, 0x000fe200078ec0ffULL, 0x0000000b8e907c36ULL, 0x000fe40008000000ULL,
0x0000000b8d8f7c36ULL, 0x000fe40008000000ULL, 0x00000001ab9b7824ULL, 0x000fe400078e0298ULL,
0x0000000190987824ULL, 0x100fe400078e0a9aULL, 0x000000018f9a7824ULL, 0x000fe200078e0a9aULL,
0x00000011aa837812ULL, 0x000fc400078efcffULL, 0x0000009899987219ULL, 0x040fe400000006ffULL,
0x0000009a999a7219ULL, 0x000fe200000006ffULL, 0x0000000b83847c36ULL, 0x000fe20008000000ULL,
0x00000018aa807812ULL, 0x040fe400078efcffULL, 0x00000019aa7f7812ULL, 0x000fe200078efcffULL,
0x0000000186b67824ULL, 0x000fe400078e0a9bULL, 0x0000000b80827c36ULL, 0x000fe40008000000ULL,
0x0000000b7f817c36ULL, 0x000fc40008000000ULL, 0x00000001849c7824ULL, 0x000fe200078e0a9bULL,
0x00005410a7a77816ULL, 0x008fc800000000a8ULL, 0x000000a7a6ff7212ULL, 0x000fc800078ac0ffULL,
0x000000aba900720cULL, 0x000fc80002fa1470ULL, 0x000000abaa00720cULL, 0x000fe40002fa1070ULL,
0x000000a796ff7212ULL, 0x000fe4000782c0ffULL, 0xff80000011117808ULL, 0x000fe40002800000ULL,
0x0000541095957816ULL, 0x020fe40000000018ULL, 0x0000541094977816ULL, 0x000fe40000000097ULL,
0x00000095a6ff7212ULL, 0x000fc4000788c0ffULL, 0x00000097a6ff7212ULL, 0x080fe4000784c0ffULL,
0x0000009796ff7212ULL, 0x000fe400078ac0ffULL, 0x000000aba900720cULL, 0x0c0fe40001741470ULL,
0x000000aba900720cULL, 0x080fe40002781470ULL, 0x000000ab9200720cULL, 0x0c0fe40000f21470ULL,
0x000000ab9200720cULL, 0x000fc40002fa1470ULL, 0x000000abaa00720cULL, 0x0c0fe40001741070ULL,
0x000000abaa00720cULL, 0x080fe40002781070ULL, 0x000000ab9100720cULL, 0x0c0fe40000f21070ULL,
0x000000ab9100720cULL, 0x000fe40002fa1070ULL, 0x0000541093937816ULL, 0x000fe40000000050ULL,
0xff80000052527808ULL, 0x000fc40001000000ULL, 0xff80000013137808ULL, 0x000fe40002000000ULL,
0xff80000051517808ULL, 0x000fe40000800000ULL, 0xff80000053537808ULL, 0x000fe40002800000ULL,
0x000000a798ff7212ULL, 0x000fe4000786c0ffULL, 0x00000093a6ff7212ULL, 0x000fe4000780c0ffULL,
0x0000009596ff7212ULL, 0x000fc4000784c0ffULL, 0x0000009396ff7212ULL, 0x000fe4000788c0ffULL,
0x000000979aff7212ULL, 0x000fe4000782c0ffULL, 0x0000009598ff7212ULL, 0x000fe400078ac0ffULL,
0x000000aba900720cULL, 0x080fe40000701470ULL, 0x000000ab9200720cULL, 0x0c0fe40001741470ULL,
0x000000ab9200720cULL, 0x000fc40002781470ULL, 0x000000ab9000720cULL, 0x0c0fe40001f61470ULL,
0x000000ab9000720cULL, 0x080fe40002fa1470ULL, 0x000000ab8f00720cULL, 0x080fe20000f21470ULL,
0x0000000182b47824ULL, 0x100fe200078e0a9bULL, 0x000000abaa00720cULL, 0x080fe20000701070ULL,
0x00000001819e7824ULL, 0x000fe200078e0a9bULL, 0x000000ab9100720cULL, 0x0c0fe40001741070ULL,
0x000000ab9100720cULL, 0x000fc40002781070ULL, 0x000000ab8e00720cULL, 0x0c0fe40001f61070ULL,
0x000000ab8e00720cULL, 0x080fe40002fa1070ULL, 0x000000ab8d00720cULL, 0x000fe40000f21070ULL,
0x000000b6999b7219ULL, 0x040fe400000006ffULL, 0x0000009c999c7219ULL, 0x000fe400000006ffULL,
0x000054108b8b7816ULL, 0x004fc4000000008cULL, 0x0000541089897816ULL, 0x000fe4000000008aULL,
0xff8000004e4e7808ULL, 0x000fe40000000000ULL, 0xff8000004d4d7808ULL, 0x000fe40001000000ULL,
0xff8000004f4f7808ULL, 0x000fe40002000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000044447808ULL, 0x000fc40002800000ULL, 0xff8000004b4b7808ULL, 0x000fe40000800000ULL,
0x0000009798ff7212ULL, 0x000fe4000780c0ffULL, 0x000000959aff7212ULL, 0x000fe4000784c0ffULL,
0x0000009398ff7212ULL, 0x080fe4000788c0ffULL, 0x000000939aff7212ULL, 0x000fe4000786c0ffULL,
0x0000008b9cff7212ULL, 0x000fc400078ac0ffULL, 0x000000899bff7212ULL, 0x000fe4000782c0ffULL,
0x000000ab9000720cULL, 0x0c0fe40000701470ULL, 0x000000ab9000720cULL, 0x080fe40002781470ULL,
0x000000ab8f00720cULL, 0x0c0fe40001741470ULL, 0x000000ab8f00720cULL, 0x080fe40001f61470ULL,
0x000000ab8600720cULL, 0x000fc40000f21470ULL, 0x000000ab8400720cULL, 0x080fe40002fa1470ULL,
0x000000ab8e00720cULL, 0x0c0fe40000701070ULL, 0x000000ab8e00720cULL, 0x080fe40002781070ULL,
0x000000ab8d00720cULL, 0x0c0fe40001741070ULL, 0x000000ab8d00720cULL, 0x080fe40001f61070ULL,
0x000000ab8500720cULL, 0x000fc40000f21070ULL, 0x000000ab8300720cULL, 0x000fe40002fa1070ULL,
0x000000b4999d7219ULL, 0x040fe400000006ffULL, 0x0000009e999e7219ULL, 0x000fe400000006ffULL,
0x0000541088197816ULL, 0x000fe40000000019ULL, 0x0000541087547816ULL, 0x000fe20000000054ULL,
0x00000001aba27824ULL, 0x000fe200078e02a2ULL, 0xff8000004a4a7808ULL, 0x000fc40000000000ULL,
0xff80000046467808ULL, 0x000fe40002000000ULL, 0xff80000045457808ULL, 0x000fe40001000000ULL,
0xff80000047477808ULL, 0x000fe40001800000ULL, 0xff80000042427808ULL, 0x000fe40000800000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x0000008b9bff7212ULL, 0x000fc4000780c0ffULL,
0x0000008b9dff7212ULL, 0x000fe4000788c0ffULL, 0x000000199bff7212ULL, 0x0c0fe4000784c0ffULL,
0x000000549bff7212ULL, 0x000fe4000786c0ffULL, 0x000000199cff7212ULL, 0x000fe4000782c0ffULL,
0x000000899eff7212ULL, 0x000fe200078ac0ffULL, 0x0000000178b27824ULL, 0x000fe200078e0aa2ULL,
0x000000ab8600720cULL, 0x000fc40000701470ULL, 0x000000ab8600720cULL, 0x0c0fe40001741470ULL,
0x000000ab8600720cULL, 0x080fe40001f61470ULL, 0x000000ab8400720cULL, 0x080fe40000f21470ULL,
0x000000ab8200720cULL, 0x080fe40002781470ULL, 0x000000ab8100720cULL, 0x000fe40002fa1470ULL,
0x00000021aa6e7812ULL, 0x002fc400078efcffULL, 0x000000ab8500720cULL, 0x0c0fe40000701070ULL,
0x000000ab8500720cULL, 0x0c0fe40001741070ULL, 0x000000ab8500720cULL, 0x080fe40001f61070ULL,
0x000000ab8300720cULL, 0x080fe40000f21070ULL, 0x000000ab8000720cULL, 0x080fe40002781070ULL,
0x000000ab7f00720cULL, 0x000fc40002fa1070ULL, 0x000000b2999f7219ULL, 0x000fe400000006ffULL,
0x000054107b7b7816ULL, 0x000fe2000000007cULL, 0x0000000b6e6f7c36ULL, 0x000fe20008000000ULL,
0xff80000040407808ULL, 0x000fe40000000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000003e3e7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fc40000800000ULL,
0xff8000000c0c7808ULL, 0x000fe40002000000ULL, 0xff8000000f0f7808ULL, 0x000fe40002800000ULL,
0x000000899cff7212ULL, 0x0c0fe4000780c0ffULL, 0x000000549cff7212ULL, 0x000fe4000784c0ffULL,
0x000000899dff7212ULL, 0x000fe4000786c0ffULL, 0x000000199eff7212ULL, 0x000fc4000782c0ffULL,
0x000000549eff7212ULL, 0x000fe4000788c0ffULL, 0x0000007b9fff7212ULL, 0x000fe200078ac0ffULL,
0x000000016fa07824ULL, 0x000fe200078e0aa2ULL, 0x000000ab8400720cULL, 0x0c0fe40000701470ULL,
0x000000ab8400720cULL, 0x080fe40001741470ULL, 0x000000ab8200720cULL, 0x080fe40001f61470ULL,
0x000000ab8100720cULL, 0x000fc40000f21470ULL, 0x000000ab8100720cULL, 0x080fe40002781470ULL,
0x000000ab7800720cULL, 0x080fe40002fa1470ULL, 0x00000028aa697812ULL, 0x040fe400078efcffULL,
0x00000029aa677812ULL, 0x000fe400078efcffULL, 0x000000ab8300720cULL, 0x0c0fe40000701070ULL,
0x000000ab8300720cULL, 0x000fc40001741070ULL, 0x000000ab8000720cULL, 0x080fe40001f61070ULL,
0x000000ab7f00720cULL, 0x0c0fe40000f21070ULL, 0x000000ab7f00720cULL, 0x080fe40002781070ULL,
0x000000ab7600720cULL, 0x000fe40002fa1070ULL, 0x000000a099a07219ULL, 0x000fe400000006ffULL,
0x000054107d7d7816ULL, 0x000fc4000000007eULL, 0x00005410791a7816ULL, 0x000fe4000000001aULL,
0x000054107a557816ULL, 0x000fe20000000055ULL, 0x0000000b696d7c36ULL, 0x000fe20008000000ULL,
0xff80000043437808ULL, 0x000fe20000000000ULL, 0x0000000b676c7c36ULL, 0x000fe20008000000ULL,
0xff8000003f3f7808ULL, 0x000fe40001000000ULL, 0xff8000000e0e7808ULL, 0x000fe40001800000ULL,
0xff80000012127808ULL, 0x000fc40000800000ULL, 0xff80000015157808ULL, 0x000fe40002000000ULL,
0xff8000003a3a7808ULL, 0x000fe40002800000ULL, 0x000000a79aff7212ULL, 0x000fe400078cc0ffULL,
0x000000199dff7212ULL, 0x040fe4000780c0ffULL, 0x000000549dff7212ULL, 0x000fe4000784c0ffULL,
0x0000007d9fff7212ULL, 0x000fc4000786c0ffULL, 0x0000001a9fff7212ULL, 0x0c0fe4000782c0ffULL,
0x000000559fff7212ULL, 0x000fe4000788c0ffULL, 0x0000001aa0ff7212ULL, 0x000fe200078ac0ffULL,
0x000000016db07824ULL, 0x100fe200078e0aa2ULL, 0x000000ab8f00720cULL, 0x080fe200037c1470ULL,
0x000000016ca27824ULL, 0x000fe200078e0aa2ULL, 0x000000ab8200720cULL, 0x0c0fe40000701470ULL,
0x000000ab8200720cULL, 0x000fc40001741470ULL, 0x000000ab7800720cULL, 0x0c0fe40001f61470ULL,
0x000000ab7800720cULL, 0x0c0fe40000f21470ULL, 0x000000ab7800720cULL, 0x080fe40002781470ULL,
0x000000ab6f00720cULL, 0x080fe40002fa1470ULL, 0x000000ab8d00720cULL, 0x080fe400037c1070ULL,
0x000000ab8000720cULL, 0x000fc40000701070ULL, 0x000000ab8000720cULL, 0x080fe40001741070ULL,
0x000000ab7600720cULL, 0x0c0fe40001f61070ULL, 0x000000ab7600720cULL, 0x0c0fe40000f21070ULL,
0x000000ab7600720cULL, 0x080fe40002781070ULL, 0x000000ab6e00720cULL, 0x000fe40002fa1070ULL,
0x000000b099a17219ULL, 0x000fc400000006ffULL, 0x000000a299a27219ULL, 0x000fe200000006ffULL,
0x00000001ab4c7824ULL, 0x000fe200078e024cULL, 0xff80000049497808ULL, 0x000fe40003000000ULL,
0xff80000010107808ULL, 0x000fe40000000000ULL, 0xff80000014147808ULL, 0x000fe40001000000ULL,
0xff80000038387808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fc40000800000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x0000008b9eff7212ULL, 0x000fe400078cc0ffULL, 0x0000007da0ff7212ULL, 0x0c0fe4000780c0ffULL,
0x0000007da1ff7212ULL, 0x000fe4000784c0ffULL, 0x0000007ba0ff7212ULL, 0x000fc4000786c0ffULL,
0x00000055a0ff7212ULL, 0x000fe4000782c0ffULL, 0x0000007ba1ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001aa2ff7212ULL, 0x000fe200078ac0ffULL, 0x000000015fae7824ULL, 0x000fe200078e0a4cULL,
0x000000ab8100720cULL, 0x080fe400037c1470ULL, 0x000000ab6f00720cULL, 0x0c0fe40000701470ULL,
0x000000ab6f00720cULL, 0x000fc40001f61470ULL, 0x000000ab6f00720cULL, 0x080fe40000f21470ULL,
0x000000ab6d00720cULL, 0x0c0fe40001741470ULL, 0x000000ab6d00720cULL, 0x080fe40002781470ULL,
0x000000ab6c00720cULL, 0x000fe40002fa1470ULL, 0x00000031aa5a7812ULL, 0x040fe400078efcffULL,
0x00000038aa577812ULL, 0x000fc400078efcffULL, 0x00000039aa567812ULL, 0x000fe400078efcffULL,
0x000000ab7f00720cULL, 0x080fe400037c1070ULL, 0x000000ab6e00720cULL, 0x0c0fe40000701070ULL,
0x000000ab6e00720cULL, 0x0c0fe40001f61070ULL, 0x000000ab6e00720cULL, 0x080fe40000f21070ULL,
0x000000ab6900720cULL, 0x000fc40001741070ULL, 0x000000ab6900720cULL, 0x080fe40002781070ULL,
0x000000ab6700720cULL, 0x000fe40002fa1070ULL, 0x000000ae99a37219ULL, 0x000fe400000006ffULL,
0x0000541065657816ULL, 0x000fe40000000066ULL, 0x00005410621b7816ULL, 0x000fe2000000001bULL,
0x0000000b5a5e7c36ULL, 0x000fe20008000000ULL, 0xff8000000d0d7808ULL, 0x000fe20003000000ULL,
0x0000000b575d7c36ULL, 0x000fe20008000000ULL, 0xff80000039397808ULL, 0x000fe20000000000ULL,
0x0000000b565c7c36ULL, 0x000fe20008000000ULL, 0xff8000003b3b7808ULL, 0x000fc40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40000800000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40002000000ULL, 0xff80000025257808ULL, 0x000fe40002800000ULL,
0x0000007da2ff7212ULL, 0x040fe400078cc0ffULL, 0x0000007ba2ff7212ULL, 0x000fc4000780c0ffULL,
0x0000001aa1ff7212ULL, 0x040fe4000786c0ffULL, 0x00000055a1ff7212ULL, 0x080fe4000782c0ffULL,
0x00000055a2ff7212ULL, 0x000fe4000784c0ffULL, 0x00000065a3ff7212ULL, 0x040fe4000788c0ffULL,
0x0000001ba3ff7212ULL, 0x000fe200078ac0ffULL, 0x000000015ea47824ULL, 0x100fe200078e0a4cULL,
0x000000ab6d00720cULL, 0x080fe20001f61470ULL, 0x000000015dac7824ULL, 0x100fe200078e0a4cULL,
0x000000ab6d00720cULL, 0x080fe20000f21470ULL, 0x000000015c4c7824ULL, 0x000fe200078e0a4cULL,
0x000000ab6c00720cULL, 0x000fc400037c1470ULL, 0x000000ab6c00720cULL, 0x0c0fe40000701470ULL,
0x000000ab6c00720cULL, 0x080fe40001741470ULL, 0x000000ab5f00720cULL, 0x0c0fe40002781470ULL,
0x000000ab5f00720cULL, 0x080fe40002fa1470ULL, 0x000000ab6900720cULL, 0x0c0fe40001f61070ULL,
0x000000ab6900720cULL, 0x000fc40000f21070ULL, 0x000000ab6700720cULL, 0x0c0fe400037c1070ULL,
0x000000ab6700720cULL, 0x0c0fe40000701070ULL, 0x000000ab6700720cULL, 0x080fe40001741070ULL,
0x000000ab5b00720cULL, 0x0c0fe40002781070ULL, 0x000000ab5b00720cULL, 0x000fe40002fa1070ULL,
0x000000a499a47219ULL, 0x000fc400000006ffULL, 0x000000ac99a57219ULL, 0x040fe400000006ffULL,
0x0000004c994c7219ULL, 0x000fe400000006ffULL, 0x0000541063637816ULL, 0x000fe40000000064ULL,
0xff80000024247808ULL, 0x000fe40001800000ULL, 0xff80000026267808ULL, 0x000fe40000800000ULL,
0xff80000035357808ULL, 0x000fc40003000000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40002000000ULL,
0xff80000020207808ULL, 0x000fe40002800000ULL, 0x00000065a4ff7212ULL, 0x080fe4000786c0ffULL,
0x00000065a5ff7212ULL, 0x000fc4000782c0ffULL, 0x000000654cff7212ULL, 0x000fe400078cc0ffULL,
0x00000063a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000063a4ff7212ULL, 0x0c0fe4000784c0ffULL,
0x00000063a5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001ba4ff7212ULL, 0x000fe400078ac0ffULL,
0x000000ab5f00720cULL, 0x000fc40000701470ULL, 0x000000ab5e00720cULL, 0x0c0fe40001f61470ULL,
0x000000ab5e00720cULL, 0x0c0fe40001741470ULL, 0x000000ab5e00720cULL, 0x080fe40002fa1470ULL,
0x000000ab5d00720cULL, 0x0c0fe40000f21470ULL, 0x000000ab5c00720cULL, 0x080fe400037c1470ULL,
0x000000ab5d00720cULL, 0x000fc40002781470ULL, 0x000000ab5b00720cULL, 0x080fe40000701070ULL,
0x000000ab5a00720cULL, 0x0c0fe40001f61070ULL, 0x000000ab5a00720cULL, 0x0c0fe40001741070ULL,
0x000000ab5a00720cULL, 0x080fe40002fa1070ULL, 0x000000ab5700720cULL, 0x080fe40000f21070ULL,
0x000000ab5600720cULL, 0x000fc400037c1070ULL, 0x000000ab5700720cULL, 0x000fe40002781070ULL,
0x0000541060607816ULL, 0x000fe40000000061ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff80000031317808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fc40002800000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff8000002d2d7808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002000000ULL,
0x000000634cff7212ULL, 0x040fe4000780c0ffULL, 0x0000001ba5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000001b4cff7212ULL, 0x000fc4000784c0ffULL, 0x00000060a3ff7212ULL, 0x080fe400078ac0ffULL,
0x00000060a4ff7212ULL, 0x080fe4000782c0ffULL, 0x00000060a5ff7212ULL, 0x080fe400078cc0ffULL,
0x000000604cff7212ULL, 0x000fe4000788c0ffULL, 0x000000ab5f00720cULL, 0x080fe40002fa1470ULL,
0x000000ab5e00720cULL, 0x000fc40000f21470ULL, 0x000000ab5d00720cULL, 0x0c0fe40001f61470ULL,
0x000000ab5d00720cULL, 0x080fe400037c1470ULL, 0x000000ab5c00720cULL, 0x0c0fe40000701470ULL,
0x000000ab5c00720cULL, 0x0c0fe40001741470ULL, 0x000000ab5c00720cULL, 0x080fe40002781470ULL,
0x000000ab5b00720cULL, 0x000fc40002fa1070ULL, 0x000000ab5a00720cULL, 0x080fe40000f21070ULL,
0x000000ab5600720cULL, 0x0c0fe40000701070ULL, 0x000000ab5700720cULL, 0x0c0fe40001f61070ULL,
0x000000ab5700720cULL, 0x080fe400037c1070ULL, 0x000000ab5600720cULL, 0x0c0fe40001741070ULL,
0x000000ab5600720cULL, 0x000fc40002781070ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001800000ULL, 0xff8000001d1d7808ULL, 0x000fe40001000000ULL,
0xff80000022227808ULL, 0x000fe40002800000ULL, 0xff80000023237808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fc40003000000ULL, 0xff8000001f1f7808ULL, 0x000fce0002000000ULL,
0x000000110800720bULL, 0x004fe20003f1e000ULL, 0x3f80000000097882ULL, 0x000fe20000000000ULL,
0x0000000168687836ULL, 0x000fe40000000000ULL, 0x0000000811087208ULL, 0x000fe20004000000ULL,
0x000000ffff697224ULL, 0x000fc600078e0059ULL, 0x000000510800720bULL, 0x000fc80003f1e000ULL,
0x0000000851197208ULL, 0x000fc80004000000ULL, 0x000000481900720bULL, 0x000fc80003f1e000ULL,
0x0000001948087208ULL, 0x000fc80004000000ULL, 0x000000490800720bULL, 0x000fc80003f1e000ULL,
0x0000000849197208ULL, 0x000fc80004000000ULL, 0x000000401900720bULL, 0x000fc80003f1e000ULL,
0x0000001940087208ULL, 0x000fc80004000000ULL, 0x000000410800720bULL, 0x000fc80003f1e000ULL,
0x0000000841197208ULL, 0x000fc80004000000ULL, 0x0000000c1900720bULL, 0x000fc80003f1e000ULL,
0x000000190c087208ULL, 0x000fc80004000000ULL, 0x0000000d0800720bULL, 0x000fc80003f1e000ULL,
0x000000080d197208ULL, 0x000fc80004000000ULL, 0x000000381900720bULL, 0x000fc80003f1e000ULL,
0x0000001938087208ULL, 0x000fc80004000000ULL, 0x000000390800720bULL, 0x000fc80003f1e000ULL,
0x0000000839197208ULL, 0x000fc80004000000ULL, 0x000000341900720bULL, 0x000fc80003f1e000ULL,
0x0000001934087208ULL, 0x000fc80004000000ULL, 0x000000350800720bULL, 0x000fc80003f1e000ULL,
0x0000000835197208ULL, 0x000fc80004000000ULL, 0x000000301900720bULL, 0x000fc80003f1e000ULL,
0x0000001930087208ULL, 0x000fc80004000000ULL, 0x000000310800720bULL, 0x000fc80003f1e000ULL,
0x0000000831197208ULL, 0x000fc80004000000ULL, 0x0000002c1900720bULL, 0x000fc80003f1e000ULL,
0x000000192c087208ULL, 0x000fe40004000000ULL, 0x000000520900720bULL, 0x000fe40003f1e000ULL,
0x0000002d0800720bULL, 0x000fc80003f3e000ULL, 0x000000082d187208ULL, 0x000fe40004800000ULL,
0x0000000952087208ULL, 0x000fc60004000000ULL, 0x0c401f0018197f89ULL, 0x000ea200000e0000ULL,
0x000000530800720bULL, 0x000fc80003f1e000ULL, 0x0000000853097208ULL, 0x000fc80004000000ULL,
0x0000004a0900720bULL, 0x000fc80003f1e000ULL, 0x000000094a087208ULL, 0x000fc80004000000ULL,
0x0000004b0800720bULL, 0x000fc80003f1e000ULL, 0x000000084b097208ULL, 0x000fe40004000000ULL,
0x000000191800720bULL, 0x004fe40003f3e000ULL, 0x000000420900720bULL, 0x000fe40003f1e000ULL,
0x0000001819197208ULL, 0x000fe40004800000ULL, 0x0000000942087208ULL, 0x000fc60004000000ULL,
0x0c201f0019187f89ULL, 0x000ea200000e0000ULL, 0x000000430800720bULL, 0x000fc80003f1e000ULL,
0x0000000843097208ULL, 0x000fc80004000000ULL, 0x0000000e0900720bULL, 0x000fc80003f1e000ULL,
0x000000090e087208ULL, 0x000fc80004000000ULL, 0x0000000f0800720bULL, 0x000fc80003f1e000ULL,
0x000000080f097208ULL, 0x000fe40004000000ULL, 0x000000181900720bULL, 0x004fe40003f3e000ULL,
0x0000003a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001918087208ULL, 0x000fe40004800000ULL,
0x000000093a187208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b08547820ULL, 0x000fe20000410000ULL,
0x0000003b1800720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b48197823ULL, 0x100fe20000010854ULL,
0x000000183b097208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b401b7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b0c507823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b51187823ULL, 0x100fe20000010854ULL,
0x000000360900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b414c7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b38417823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b2c387823ULL, 0x100fe20000010854ULL,
0x00000009361a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010854ULL,
0x000000371a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010854ULL, 0x0000005000507308ULL, 0x000fe20000000800ULL,
0x0000001a37097208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b491a7823ULL, 0x000fc60000010854ULL,
0x000000320900720bULL, 0x000fc60003f1e000ULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x0000000932487208ULL, 0x000fc80004000000ULL, 0x000000334800720bULL, 0x000fc60003f1e000ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x0000004833097208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b39487823ULL, 0x000fc60000010854ULL, 0x0000002e0900720bULL, 0x000fc60003f1e000ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x000000092e407208ULL, 0x000fc80004000000ULL,
0x0000002f4000720bULL, 0x000fc60003f1e000ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x000000402f407208ULL, 0x000fe40004000000ULL, 0x000000130a00720bULL, 0x000fc60003f1e000ULL,
0x0c401f0040497f89ULL, 0x000ea200000e0000ULL, 0x0000000a130a7208ULL, 0x000fe20004000000ULL,
0x0000001a001a7308ULL, 0x000fe60000000800ULL, 0x0000004d0a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a4d097208ULL, 0x000fe20004000000ULL, 0x0000001b001b7308ULL, 0x000fe60000000800ULL,
0x000000440900720bULL, 0x000fc80003f1e000ULL, 0x00000009440a7208ULL, 0x000fe20004000000ULL,
0x0000004c004c7308ULL, 0x000fe60000000800ULL, 0x000000450a00720bULL, 0x000fe40003f1e000ULL,
0x000000494000720bULL, 0x004fe40003f3e000ULL, 0x0000000a45097208ULL, 0x000fe20004000000ULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x00000040490c7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b35497823ULL, 0x000fe20000010854ULL, 0x0000003c0900720bULL, 0x000fc60003f1e000ULL,
0x0c201f000c397f89ULL, 0x000ea200000e0000ULL, 0x000000093c0a7208ULL, 0x000fe20004000000ULL,
0x0000003400407308ULL, 0x0007e60000000800ULL, 0x0000003d0a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a3d097208ULL, 0x000fe20004000000ULL, 0x0000004800487308ULL, 0x000fe60000000800ULL,
0x000000100900720bULL, 0x000fc80003f1e000ULL, 0x0000000910097208ULL, 0x000fe20004000000ULL,
0x0000004900497308ULL, 0x000fe60000000800ULL, 0x000000120900720bULL, 0x000fe40003f1e000ULL,
0x000000390c00720bULL, 0x004fe40003f3e000ULL, 0x0000000912357208ULL, 0x000fe20004000000ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x0000000c39097208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b2d397823ULL, 0x000fe20000010854ULL, 0x000000283500720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b09557820ULL, 0x000fe20000410000ULL, 0x00000035280a7208ULL, 0x000fe20004000000ULL,
0x0000003100317308ULL, 0x000ea40000000800ULL, 0x3fb8aa3b522c7823ULL, 0x100fe20000010855ULL,
0x000000290a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b43527823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b0f547823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b4a347823ULL, 0x108fe20000010855ULL,
0x0000000a292d7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4b4a7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010855ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x000000242d00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b424b7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b36427823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b32367823ULL, 0x100fe20000010855ULL,
0x0000002d240a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010855ULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x000000250a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b33337823ULL, 0x000fe20000010855ULL,
0x000000303130723eULL, 0x004fc400000010ffULL, 0x0000000a25357208ULL, 0x000fe40004000000ULL,
0x0000004e0b00720bULL, 0x000fe20003f1e000ULL, 0x00000053002d7308ULL, 0x000fe20000000800ULL,
0x000000203500720bULL, 0x000fe40003f3e000ULL, 0x0000000b4e0a7208ULL, 0x000fe40004000000ULL,
0x00000035200c7208ULL, 0x000fe40004800000ULL, 0x0000004f0a00720bULL, 0x000fe20003f1e000ULL,
0x0000004a00357308ULL, 0x0004e20000000800ULL, 0x000000210c00720bULL, 0x000fc40003f3e000ULL,
0x0000000a4f0b7208ULL, 0x000fe40004000000ULL, 0x0000000c21517208ULL, 0x000fe40004800000ULL,
0x000000460b00720bULL, 0x000fe20003f1e000ULL, 0x0000005400547308ULL, 0x000fe20000000800ULL,
0x0000001c5100720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2f4a7823ULL, 0x104fe20000010855ULL,
0x0000000b460a7208ULL, 0x000fe40004000000ULL, 0x000000511c0c7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b0e517823ULL, 0x000fe20000010855ULL, 0x000000470a00720bULL, 0x000fe20003f1e000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000001d0c00720bULL, 0x000fc40003f3e000ULL,
0x0000000a470b7208ULL, 0x000fe40004000000ULL, 0x0000000c1d0c7208ULL, 0x000fe40004800000ULL,
0x0000003e0b00720bULL, 0x000fe20003f1e000ULL, 0x0000005100517308ULL, 0x000ea40000000800ULL,
0x0c401f000c437f89ULL, 0x000f6200000e0000ULL, 0x0000000b3e0a7208ULL, 0x000fc80004000000ULL,
0x0000003f0a00720bULL, 0x000fe20003f1e000ULL, 0x0000005200527308ULL, 0x000fe60000000800ULL,
0x0000000a3f0b7208ULL, 0x000fc80004000000ULL, 0x000000140b00720bULL, 0x000fe20003f1e000ULL,
0x0000004200427308ULL, 0x000fe60000000800ULL, 0x0000000b140a7208ULL, 0x000fc80004000000ULL,
0x000000150a00720bULL, 0x000fe20003f1e000ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x000000430c00720bULL, 0x022fe40003f3e000ULL, 0x0000000a150b7208ULL, 0x000fe40004000000ULL,
0x0000000c430c7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b37437823ULL, 0x100fe20000010855ULL,
0x0000002a0b00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2e377823ULL, 0x000fe20000010855ULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x0c201f000c0f7f89ULL, 0x000e6200000e0000ULL,
0x0000000b2a0a7208ULL, 0x000fc80004000000ULL, 0x0000002b0a00720bULL, 0x000fe40003f1e000ULL,
0x0000004300437308ULL, 0x000fe40000000800ULL, 0x0000000a2b0b7208ULL, 0x000fc80004000000ULL,
0x000000260b00720bULL, 0x000fe40003f1e000ULL, 0x0000003600367308ULL, 0x000fe40000000800ULL,
0x0000000b260a7208ULL, 0x000fc80004000000ULL, 0x000000270a00720bULL, 0x000fe40003f1e000ULL,
0x0000003300337308ULL, 0x000f620000000800ULL, 0x0000000f0c00720bULL, 0x002fe40003f3e000ULL,
0x0000000a270b7208ULL, 0x000fe40004000000ULL, 0x0000000c0f0a7208ULL, 0x000fe40004800000ULL,
0x000000220b00720bULL, 0x000fe20003f1e000ULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x00000034350f723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b0a0e7820ULL, 0x000fe20000410000ULL,
0x0000000b220c7208ULL, 0x000fe20004000000ULL, 0x00000009ff347e24ULL, 0x000fc4000f8e00ffULL,
0x3fb8aa3b44447823ULL, 0x100fe2000001080eULL, 0x000000230c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe2000001080eULL,
0x00000044005b7308ULL, 0x0003e20000000800ULL, 0x0000000c230b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b45457823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080eULL,
0x3f8000003434783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b3c327823ULL, 0x100fe2000001080eULL,
0x0000001e0b00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b125c7823ULL, 0x100fe2000001080eULL,
0x00000013002e7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b1c447823ULL, 0x102fe2000001080eULL,
0x0000000b1e0c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b10557823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b28567823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b29577823ULL, 0x100fe2000001080eULL,
0x0000001f0c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b24537823ULL, 0x100fe2000001080eULL,
0x0000004d002f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b255a7823ULL, 0x100fe2000001080eULL,
0x0000000c1f0c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b203c7823ULL, 0x000fe2000001080eULL,
0x000000500d12723eULL, 0x000fe200000010ffULL, 0x000000ffff357224ULL, 0x100fe200078e0034ULL,
0x0000002c2d0d723eULL, 0x000fe200000010ffULL, 0x0c401f000c0b7f89ULL, 0x000e6200000e0000ULL,
0x00000045005e7308ULL, 0x0006620000000800ULL, 0x0000001b4c10723eULL, 0x000fe200000010ffULL,
0x000000ffff5d7224ULL, 0x000fe200078e0034ULL, 0xfffffff8ff507812ULL, 0x000fc400078ee216ULL,
0x000000515413723eULL, 0x004fe400000010ffULL, 0x000000363331723eULL, 0x020fe200000010ffULL,
0x0000003d004d7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b1d457823ULL, 0x008fe2000001080eULL,
0x0000000850517836ULL, 0x000fe20000000000ULL, 0x0000000a71367c11ULL, 0x000fe2000f8e60ffULL,
0x0000001850547836ULL, 0x000fc80000000000ULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b213d7823ULL, 0x004fe2000001080eULL, 0x000000191a0e723eULL, 0x000fe400000010ffULL,
0x0000005b5e1a723eULL, 0x002fe200000010ffULL, 0x00000008545e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff5b7819ULL, 0x000fe40000011604ULL, 0x0000000b0c00720bULL, 0x000fe20003f1e000ULL,
0x0000005c005c7308ULL, 0x000fe20000000800ULL, 0x0000000404167810ULL, 0x000fc40007ffe05bULL,
0x0000000c0b0b7208ULL, 0x000fca0004000000ULL, 0x0c201f000b0c7f89ULL, 0x000e6200000e0000ULL,
0x0000003200327308ULL, 0x000ff00000000800ULL, 0x0000005300537308ULL, 0x000ff00000000800ULL,
0x0000005a005a7308ULL, 0x000fe20000000800ULL, 0x0000000c0b00720bULL, 0x002fce0003f1e000ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x0000000b0c0b7208ULL, 0x000fe40004000000ULL,
0x00000011180c723eULL, 0x000fe400000010ffULL, 0x0000002e2f18723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b0b1c7820ULL, 0x000fe20000410000ULL, 0x0000004b5211723eULL, 0x000fe200000010ffULL,
0x0000001050527836ULL, 0x000fe20000000000ULL, 0x0000005700577308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b46467823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b47477823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL,
0x000000340c2c723cULL, 0x000fe200000418ffULL, 0x0000004600467308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2b207823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b1e4b7823ULL, 0x000fe2000001081cULL, 0x0000004700477308ULL, 0x000e620000000800ULL,
0x00000040491e723eULL, 0x000fc400000010ffULL, 0x0000000304ff7812ULL, 0x000fca000780c0ffULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x00000046471b723eULL, 0x002fce00000010ffULL,
0x0000004f004f7308ULL, 0x000e620000000800ULL, 0x0000000716477812ULL, 0x000fe200078ec0ffULL,
0x0000000851167824ULL, 0x040fe200078e00ffULL, 0x00000034102c723cULL, 0x000fe2000004182cULL,
0x0000000851517824ULL, 0x000fc800078e00ffULL, 0x00000014001d7308ULL, 0x0005e40000000800ULL,
0x3fb8aa3b22357823ULL, 0x000fe2000001081cULL, 0x000000555c22723eULL, 0x000fe200000010ffULL,
0x000000ffff5c7224ULL, 0x000fe200078e0034ULL, 0x0000004e4f19723eULL, 0x002fc600000010ffULL,
0x0000001500467308ULL, 0x0002e20000000800ULL, 0x000000ffff147224ULL, 0x004fe400078e0034ULL,
0x3fb8aa3b1f4f7823ULL, 0x000fe2000001081cULL, 0x00000008524e7824ULL, 0x000fe200078e00ffULL,
0x00000042431f723eULL, 0x000fe200000010ffULL, 0x000000ffff427224ULL, 0x100fe400078e0034ULL,
0x000000ffff437224ULL, 0x100fe200078e0034ULL, 0x0000002a00257308ULL, 0x0005e20000000800ULL,
0x000000ffff157224ULL, 0x002fce00078e0034ULL, 0x0000003e00217308ULL, 0x0003e20000000800ULL,
0x000000141828723cULL, 0x004fee00000418ffULL, 0x0000003f00247308ULL, 0x000ea20000000800ULL,
0x00000008503e7824ULL, 0x002fe200078e00ffULL, 0xfffffff816157812ULL, 0x000fc400078ee247ULL,
0xfffffff84e167812ULL, 0x000fe400078ee247ULL, 0xfffffff83e3e7812ULL, 0x000fe400078ee247ULL,
0xfffffff85e147812ULL, 0x000fe200078ee247ULL, 0x00000020004c7308ULL, 0x0003620000000800ULL,
0x3fb8aa3b23477823ULL, 0x000fe2000001081cULL, 0x0000001d4623723eULL, 0x008fe400000010ffULL,
0x00000041481c723eULL, 0x000fe200000010ffULL, 0x0000000852417824ULL, 0x000fe200078e00ffULL,
0x000000212421723eULL, 0x004fe200000010ffULL, 0x000000ffff527224ULL, 0x000fe200078e0034ULL,
0x00000026003f7308ULL, 0x0005e20000000800ULL, 0x000000324d20723eULL, 0x002fc400000010ffULL,
0x0000003a3b1d723eULL, 0x000fe400000010ffULL, 0x000000565724723eULL, 0x000fe400000010ffULL,
0x000000254c25723eULL, 0x020fe200000010ffULL, 0x0000005c2028723cULL, 0x000fe20000041828ULL,
0x00000027004e7308ULL, 0x000e620000000800ULL, 0x000000535a26723eULL, 0x004fe200000010ffULL,
0x000000ffff537224ULL, 0x000fe200078e0034ULL, 0x000000035b3b7812ULL, 0x000fe400078ec0ffULL,
0x000000421c2c723cULL, 0x000fe6000004182cULL, 0x0000004a004a7308ULL, 0x000ea20000000800ULL,
0x000000013b327824ULL, 0x000fc600078e0204ULL, 0x0000000854437824ULL, 0x000fe400078e00ffULL,
0x0000000732327812ULL, 0x000fe400078ec0ffULL, 0x0000003f4e27723eULL, 0x002fe200000010ffULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x00000008503f7824ULL, 0x000fe200078e00ffULL,
0xfffffff851467812ULL, 0x000fe400078ee232ULL, 0xfffffff841487812ULL, 0x000fe200078ee232ULL,
0x000000ffff417224ULL, 0x000fe200078e0034ULL, 0x000000522428723cULL, 0x000fe20000041828ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee232ULL, 0x0000003900397308ULL, 0x000e620000000800ULL,
0xfffffff8434c7812ULL, 0x000fc400078ee232ULL, 0x000000374a33723eULL, 0x004fe200000010ffULL,
0x000000ffff4a7224ULL, 0x000fe400078e0034ULL, 0x000000ffff377224ULL, 0x000fe400078e0012ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x000000ffff127224ULL, 0x000fe200078e0031ULL,
0x000000383932723eULL, 0x002fcc00000010ffULL, 0x0000004700407308ULL, 0x000e700000000800ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000354039723eULL, 0x002fce00000010ffULL,
0x0000003d003d7308ULL, 0x000e620000000800ULL, 0x000000ffff407224ULL, 0x000fe400078e0034ULL,
0x000000ffff357224ULL, 0x000fe400078e000eULL, 0x000000ffff0e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff117224ULL, 0x000fe200078e001fULL, 0x0000004400447308ULL, 0x000fe20000000800ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0022ULL, 0x000000ffff227224ULL, 0x000fe200078e0039ULL,
0x0000003c3d38723eULL, 0x002fc800000010ffULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0x00012000363d7836ULL, 0x000fe40000000000ULL, 0x000000ffff367224ULL, 0x000fe400078e0010ULL,
0x0000001016167824ULL, 0x100fe400078e023dULL, 0x0000001014147824ULL, 0x100fe200078e023dULL,
0x0000004b003b7308ULL, 0x0005e20000000800ULL, 0x0000001046467824ULL, 0x100fe400078e023dULL,
0x0000001048487824ULL, 0x000fc400078e023dULL, 0x000000104c4c7824ULL, 0x000fe200078e023dULL,
0x00000044453a723eULL, 0x002fe400000010ffULL, 0x0000004f00427308ULL, 0x000e620000000800ULL,
0x000000ffff4b7224ULL, 0x004fe400078e0034ULL, 0x000000ffff347224ULL, 0x000fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff3c7224ULL, 0x000fe200078e001cULL,
0x0000004a302c723cULL, 0x000fe2000004182cULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff0f7224ULL, 0x000fe400078e0013ULL, 0x000000ffff107224ULL, 0x000fe200078e001dULL,
0x0000003b423b723eULL, 0x002fe200000010ffULL, 0x000000ffff137224ULL, 0x000fe400078e0033ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0018ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000403828723cULL, 0x000fe20000041828ULL, 0x000000ffff187224ULL, 0x000fc400078e0019ULL,
0x000000ffff317224ULL, 0x000fc600078e0026ULL, 0x000000ffff337224ULL, 0x000fe400078e003aULL,
0x00000010152f7824ULL, 0x100fe400078e023dULL, 0x000000103e2d7824ULL, 0x100fe400078e023dULL,
0x000000103f157824ULL, 0x000fe400078e023dULL, 0x000000ffff3d7224ULL, 0x000fe400078e001eULL,
0x000000ffff3e7224ULL, 0x000fe200078e0030ULL, 0x0000003415007844ULL, 0x000fe20000000200ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0032ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff307224ULL, 0x000fe200078e0024ULL, 0x0000003c2d007844ULL, 0x0003e20000000200ULL,
0x000000ffff327224ULL, 0x000fe400078e0038ULL, 0x000000ffff197224ULL, 0x000fe200078e001bULL,
0x0000000c46007844ULL, 0x0005e20000000200ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0023ULL, 0x000000102f007844ULL, 0x0007e20000000200ULL,
0x000000ffff207224ULL, 0x000fc400078e0025ULL, 0x000000ffff217224ULL, 0x000fe200078e0027ULL,
0x0000001c48007844ULL, 0x000be20000000200ULL, 0x000000ffff237224ULL, 0x000fe400078e003bULL,
0x000000ffff2d7224ULL, 0x002fe200078e002eULL, 0x0000003016007844ULL, 0x0003e20000000200ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0028ULL, 0x00000001ff0d7424ULL, 0x004fe200078e00ffULL,
0x000000184c007844ULL, 0x0003e20000000200ULL, 0x000000ffff2f7224ULL, 0x008fc600078e002aULL,
0x0000002014007844ULL, 0x0003e80000000200ULL, 0x01a0000817008388ULL, 0x0003e80000000c00ULL,
0x01a2002c17008388ULL, 0x0003e20000000c00ULL, 0x0000006b6800720cULL, 0x000fe20003f06070ULL,
0x01a6080d6aff79a7ULL, 0x0003e2000850003fULL, 0x01a6100d6aff79a7ULL, 0x0003e2000850003fULL,
0x01a6180d6aff79a7ULL, 0x0003e2000850003fULL, 0x01a6200d6aff79a7ULL, 0x0003f2000850003fULL,
0xffffff8800b88947ULL, 0x020fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000082007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000008200008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff82ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000082027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000008200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffe6c02707950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004ebULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000668ULL, 0x0000000000000228ULL, 0x0000001500000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000970ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c4ULL, 0x0000000000000700ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001110ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000019300ULL, 0x0000001500000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a480ULL, 0x0000000000000040ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a4c0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000001a4c0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x000000000001aab0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001aab0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000001110ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019300ULL,
0x0000000000019300ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001a480ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001a4c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_90_cubin_len = 109568;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
