/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016650ULL, 0x00000000000162d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x0000000000014740ULL,
0x0000000000000180ULL, 0x000b0022000004c4ULL, 0x00000000000148c0ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000014900ULL, 0x0000000000000050ULL, 0x000b002200000519ULL,
0x0000000000014950ULL, 0x0000000000000130ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000014a80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001474000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x0050900400288080ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8c082880808b0828ULL, 0x2880809208288080ULL,
0x8095082880809408ULL, 0x0828808096082880ULL, 0x80809c0828808097ULL, 0xa3082880809e0828ULL,
0x288080a708288080ULL, 0x80c908288080a808ULL, 0x1628808085082880ULL, 0x0000031028808280ULL,
0x8592000000000000ULL, 0x0000002200288080ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0001474000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808085ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8c082880808b0828ULL, 0x2880809208288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL,
0x80809c0828808097ULL, 0xa7082880809e0828ULL, 0x288080a808288080ULL, 0x80b008288080c908ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b09200ULL, 0x0000001cffffffffULL,
0x0000014000000000ULL, 0x000148c000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8c082880808b0828ULL, 0x2880809208288080ULL,
0x8095082880809408ULL, 0x0828808096082880ULL, 0x80809c0828808097ULL, 0xa3082880809e0828ULL,
0x288080a708288080ULL, 0x80c908288080a808ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080c99200ULL, 0x0000002cffffffffULL, 0x000001f000000000ULL, 0x0001490000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x809e288080c90900ULL, 0x0000000000002880ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8c082880808b0828ULL, 0x2880809208288080ULL,
0x8095082880809408ULL, 0x0828808096082880ULL, 0x80809c0828808097ULL, 0xa808288080a70828ULL,
0x288080c908288080ULL, 0x8280162880809e08ULL, 0x0000000003102880ULL, 0x80809e9200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000002b000000000ULL, 0x0001495000000000ULL,
0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001a00082f04ULL, 0x0008230400000096ULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x0134290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x000000e0000000d0ULL, 0x000023d000000400ULL, 0x0000259000002480ULL, 0x00002b7000002700ULL,
0x00002bf000002ba0ULL, 0x0000567000002c40ULL, 0x0000584000005710ULL, 0x00005e10000059a0ULL,
0x00005e9000005e40ULL, 0x000085f000005ee0ULL, 0x000087c000008690ULL, 0x00008d9000008920ULL,
0x00008e1000008dc0ULL, 0x0000b5d000008e60ULL, 0x0000b7900000b670ULL, 0x0000bd500000b8f0ULL,
0x0000bdd00000bd80ULL, 0x0000d6f00000be20ULL, 0x00012f300000d700ULL, 0x00012f8000012f70ULL,
0x00012fe000012f90ULL, 0x0001302000013000ULL, 0x00013cd000013030ULL, 0x00013d7000013d20ULL,
0x00013e2000013dc0ULL, 0x00013ed000013e80ULL, 0x00013f6000013f20ULL, 0x0001401000013fb0ULL,
0x000140b000014060ULL, 0x0001414000014100ULL, 0x000141f000014190ULL, 0x0001429000014240ULL,
0x00014330000142e0ULL, 0x000143e000014380ULL, 0x0001448000014430ULL, 0x00014540000144e0ULL,
0x00014600000145a0ULL, 0x000146c000014660ULL, 0x0440390400014720ULL, 0x000000ff00000230ULL,
0x003f01000000f600ULL, 0x0000000f00000270ULL, 0x003f01200000f608ULL, 0x0000000f00000380ULL,
0x003f01200000f688ULL, 0x0000000f000003b0ULL, 0x003f01200000f6a8ULL, 0x0000000f000003e0ULL,
0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000000a00000600ULL,
0x003f010200000004ULL, 0x0000000a000006b0ULL, 0x003f010100000000ULL, 0x000000ff000010a0ULL,
0x0004010700000000ULL, 0x000000ff00001120ULL, 0x0004010100000000ULL, 0x0000000800001180ULL,
0x003f010100000020ULL, 0x0000000700001340ULL, 0x003f01050000f6ccULL, 0x0000000700001530ULL,
0x003f01050000f6ccULL, 0x0000000e00001f00ULL, 0x003f01070000f6a8ULL, 0x0000000e00002070ULL,
0x003f01010000f6a8ULL, 0x0000000f000020d0ULL, 0x003f01010000f608ULL, 0x0000000f000020f0ULL,
0x003f01050000f60cULL, 0x0000000f000022c0ULL, 0x003f01050000f60cULL, 0x0000001c000028d0ULL,
0x003f01050000f6acULL, 0x0000001c00002aa0ULL, 0x003f01050000f6acULL, 0x0000001c00004550ULL,
0x003f01010000f6c8ULL, 0x00000058000045d0ULL, 0x003f01010000f688ULL, 0x0000000c00004660ULL,
0x003f010500000004ULL, 0x0000000c00004830ULL, 0x003f010500000004ULL, 0x0000005600005230ULL,
0x003f01070000f6a8ULL, 0x0000005600005360ULL, 0x003f01010000f6a8ULL, 0x0000000f000053c0ULL,
0x003f01010000f628ULL, 0x0000000f000053f0ULL, 0x003f01050000f62cULL, 0x0000000f000055c0ULL,
0x003f01050000f62cULL, 0x0000000e00005b70ULL, 0x003f01050000f6acULL, 0x0000000e00005d40ULL,
0x003f01050000f6acULL, 0x0000001c000075e0ULL, 0x003f010100000000ULL, 0x0000005800007650ULL,
0x003f01010000f690ULL, 0x0000000c000076c0ULL, 0x003f010500000004ULL, 0x0000000c00007890ULL,
0x003f010500000004ULL, 0x0000005700008190ULL, 0x003f010700000000ULL, 0x0000000e000082f0ULL,
0x003f01010000f6a8ULL, 0x0000000f00008350ULL, 0x003f01010000f648ULL, 0x0000000f00008370ULL,
0x003f01050000f64cULL, 0x0000000f00008540ULL, 0x003f01050000f64cULL, 0x0000005600008af0ULL,
0x003f01050000f6acULL, 0x0000005600008cc0ULL, 0x003f01050000f6acULL, 0x0000001c0000a5a0ULL,
0x003f010100000000ULL, 0x000000580000a610ULL, 0x003f01010000f698ULL, 0x0000000c0000a6a0ULL,
0x003f010500000004ULL, 0x0000000c0000a870ULL, 0x003f010500000004ULL, 0x000000550000b170ULL,
0x003f010700000000ULL, 0x000000560000b2d0ULL, 0x003f01010000f6a8ULL, 0x0000000f0000b330ULL,
0x003f01010000f668ULL, 0x0000000f0000b350ULL, 0x003f01050000f66cULL, 0x0000000f0000b520ULL,
0x003f01050000f66cULL, 0x0000000e0000bab0ULL, 0x003f01050000f6acULL, 0x0000000e0000bc80ULL,
0x003f01050000f6acULL, 0x0000000c0000d4a0ULL, 0x003f010100000000ULL, 0x000000580000d500ULL,
0x003f01010000f6a0ULL, 0x000000ff0000e320ULL, 0x003f01010000f600ULL, 0x000000ff0000f120ULL,
0x003f01050000f604ULL, 0x000000ff0000f2f0ULL, 0x003f01050000f604ULL, 0x000000ff0000f520ULL,
0x003f01010000f600ULL, 0x000000ff0000f550ULL, 0x003f01050000f604ULL, 0x000000ff0000f710ULL,
0x003f01050000f604ULL, 0x0000003e00012360ULL, 0x003f010100000000ULL, 0x0000003e00012460ULL,
0x003f010500000004ULL, 0x0000003e00012630ULL, 0x003f010500000004ULL, 0x0000004000013b30ULL,
0x003f010100000000ULL, 0x0000004000013b90ULL, 0x003f010100000008ULL, 0x0000004000013bf0ULL,
0x003f010100000010ULL, 0x0000004000013c60ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL,
0x0000e2400000dfc0ULL, 0x0000f8400000f770ULL, 0x0000040100013ca0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000034cULL, 0x0000001a00000002ULL, 0x000000000000028cULL, 0x0000001a00000002ULL,
0x00000000000001dcULL, 0x0000001a00000002ULL, 0x0000000000000114ULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000324ULL, 0x0000001a00000002ULL,
0x0000000000000269ULL, 0x0000001a00000002ULL, 0x00000000000001b9ULL, 0x0000001a00000002ULL,
0x00000000000000eeULL, 0x0000001a00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff137624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x00000004ff187424ULL, 0x000fe400078e00ffULL, 0x0000000813087824ULL, 0x000fe200078e00ffULL,
0x0000000000037919ULL, 0x000ee80000002200ULL, 0x0000000000127919ULL, 0x000f280000002600ULL,
0x0000000000077919ULL, 0x000f280000002700ULL, 0x0000000000047919ULL, 0x000f220000000000ULL,
0x00000005ff457819ULL, 0x002fc6000001160fULL, 0x00001fff020e7589ULL, 0x004fe800000e0000ULL,
0x00001fff45457589ULL, 0x000e6200000e0000ULL, 0x0000010002007a24ULL, 0x008fe400078e0203ULL,
0x0000001400037300ULL, 0x000ea200000e0000ULL, 0x0000000812067824ULL, 0x010fe400078e00ffULL,
0x00000000000f7a24ULL, 0x000fc400078e020fULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x00000007080a7224ULL, 0x000fe400078e0206ULL, 0x000000ff0f00720cULL, 0x040fe20003f45270ULL,
0x0000001400147309ULL, 0x000f220000000000ULL, 0x0000000f0f00780cULL, 0x040fe40003f64070ULL,
0x0000007f0f00780cULL, 0x040fe40003f84070ULL, 0x000000030f00780cULL, 0x000fe40003f24070ULL,
0x000000040300720cULL, 0x004fe20003f02070ULL, 0x000000040e097824ULL, 0x002fc800078e0245ULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x0000000209067824ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fe200078e00ffULL, 0x00000004ff117819ULL, 0x008fe20000011600ULL,
0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL, 0x00000008060b7817ULL, 0x000fe20007800000ULL,
0x7fffffc0ff05b424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x000000010f00780cULL, 0x000fe20003f44070ULL, 0xff317217ff0cc424ULL, 0x000fc400078e00ffULL,
0x000000010b107824ULL, 0x000fe200078e0a06ULL, 0x00f608040f00b388ULL, 0x0005e20000008a00ULL,
0x00000001060b7824ULL, 0x000fe400078e0211ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x000000101100720cULL, 0x000fe20003f66070ULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x00f4000c0f00c388ULL, 0x0003e20000004800ULL, 0x000000010a027824ULL, 0x000fe400078e020bULL,
0x000000100b157824ULL, 0x000fc400078e00ffULL, 0x00005c0002027625ULL, 0x000fe200078e0003ULL,
0x000000f006057812ULL, 0x004fc600078ec0ffULL, 0x000000010b047824ULL, 0x000fe400078e0200ULL,
0x3fffff60ff089424ULL, 0x000fe400078e00ffULL, 0x7fffff60ff099424ULL, 0x000fe200078e00ffULL,
0xfffffff015107812ULL, 0x000fe200078ee204ULL, 0x3fffff80ff0a9424ULL, 0x000fe200078e00ffULL,
0x0000000502047210ULL, 0x000fe20007f9e0ffULL, 0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL,
0x00f688080f009388ULL, 0x0005e20000008a00ULL, 0x3fffffc0ff0ca424ULL, 0x002fc400078e00ffULL,
0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL, 0x00f6a80a0f009388ULL, 0x000fe20000008a00ULL,
0x000000ffff057224ULL, 0x000fe400020e0603ULL, 0x0000620007027625ULL, 0x000fe200078e0018ULL,
0x00f6c80c0f00a388ULL, 0x000fe60000008a00ULL, 0x0000001010097824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff087224ULL, 0x010fe200078e0a14ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006021b7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fc40003f05270ULL,
0x0000003f1b197810ULL, 0x044fe40007ffe0ffULL, 0x000000ff1b0c7810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff197819ULL, 0x000fe40000011619ULL, 0x00000008ff447819ULL, 0x000fca000001160cULL,
0x0000dd0000008947ULL, 0x000fea0003800000ULL, 0x00000002ff027819ULL, 0x000fe20000011645ULL,
0x00000003ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000f688450a7811ULL, 0x000fe200078e18ffULL,
0xffffffffff057424ULL, 0x002fe200078e00ffULL, 0x03ffffff02607812ULL, 0x000fc800078ec0ffULL,
0x000000196000720cULL, 0x000fda0003f06070ULL, 0x0000000207038824ULL, 0x000fe400078e00ffULL,
0x00006400ff048624ULL, 0x000fc800078e00ffULL, 0x0000640003038624ULL, 0x000fc800078e0204ULL,
0x0000000160038824ULL, 0x000fe200078e0203ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040b0aff738cULL, 0x0003e20000000000ULL, 0x0000600003088625ULL, 0x000fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000608058981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000004012037824ULL, 0x000fe200078e00ffULL,
0x00000001ff1a7819ULL, 0x000fe20000011645ULL, 0x000000000aff7f8cULL, 0x0007e8000c80043fULL,
0x000000201a047824ULL, 0x000fca00078e00ffULL, 0x00000020030b7812ULL, 0x002fe200078ef804ULL,
0x00005800050c7a24ULL, 0x004fe200078e02ffULL, 0x0000000145057812ULL, 0x000fc600078ec0ffULL,
0x000000400c1c7824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x008fe200078e00ffULL, 0x000000041b057217ULL, 0x000fe40007800000ULL,
0x00000003ff097819ULL, 0x000fe40000011600ULL, 0x0000007006177812ULL, 0x000fe200078ec0ffULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x00000004090d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0209ULL, 0x00000008090e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000805057217ULL, 0x000fe20007800000ULL, 0x000000010a0c7824ULL, 0x040fe400078e0200ULL,
0x000000080a0f7824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x000fe400078e0a08ULL,
0x000000010b0a7824ULL, 0x000fe200078e020aULL, 0xfffffff80f0c7812ULL, 0x000fe400078ee20cULL,
0x000000050d00720cULL, 0x000fe20003f46070ULL, 0x00000001080d7824ULL, 0x000fe200078e020dULL,
0x0000000a1c117210ULL, 0x000fc40007f1e0ffULL, 0x000000050900720cULL, 0x080fe20003f66070ULL,
0x000000080d0a7824ULL, 0x000fe200078e00ffULL, 0x0000000c090f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d097824ULL, 0x000fe200078e0200ULL, 0x000000050e00720cULL, 0x080fe20003f26070ULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005e0011167a11ULL, 0x000fe200078838ffULL,
0x00000001080e7824ULL, 0x000fe200078e020eULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL,
0x000000010b0d7824ULL, 0x000fe200078e020dULL, 0x00005f0011097a11ULL, 0x000fe200020f3c12ULL,
0x0000000108107824ULL, 0x000fe200078e020fULL, 0x000000050f00720cULL, 0x000fe20003f06070ULL,
0x000000010e087824ULL, 0x000fe200078e0200ULL, 0x0000000d1c0d7210ULL, 0x000fe20007f9e0ffULL,
0x000000080e117824ULL, 0x000fc400078e00ffULL, 0x000000010b057824ULL, 0x000fe400078e020eULL,
0x000000ffff147224ULL, 0x000fe200020e06ffULL, 0xfffffff8110e7812ULL, 0x000fe200078ee208ULL,
0x0000000110087824ULL, 0x040fe200078e0200ULL, 0x00005e000d127a11ULL, 0x000fe200078838ffULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0x000000051c0f7210ULL, 0x000fe20007fbe0ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0210ULL, 0x0000b0001a057811ULL, 0x000fe400078e68ffULL,
0xfffffff811067812ULL, 0x000fe200078ee208ULL, 0x000000ffff107224ULL, 0x000fe200028e06ffULL,
0x00005f000d147a11ULL, 0x000fe200020f3c14ULL, 0x000000100c117824ULL, 0x100fe200078e0205ULL,
0x0000000b1c0b7210ULL, 0x000fe20007fde0ffULL, 0x000000100a137824ULL, 0x100fe200078e0205ULL,
0x0000001617087210ULL, 0x000fe20007f9e0ffULL, 0x000000100e157824ULL, 0x000fe200078e0205ULL,
0x00005e000f0d7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff0c7224ULL, 0x000fe200030e06ffULL,
0x00005e000b0e7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff097224ULL, 0x000fe200020e0609ULL,
0x00000017120a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001006057824ULL, 0x000fe200078e0205ULL,
0x00005f000f0f7a11ULL, 0x000fc400028f3c10ULL, 0x00005f000b067a11ULL, 0x000fe200030f3c0cULL,
0x000000ffff0b7224ULL, 0x000fe200020e0614ULL, 0x000000170d0c7210ULL, 0x080fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e2000d901c46ULL,
0x000000170e0e7210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e060fULL,
0x000000000a137faeULL, 0x0003e2000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fc600020e0606ULL,
0x000000000c157faeULL, 0x0003e8000c901c46ULL, 0x000000000e057faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001005057824ULL, 0x008fe200078e00ffULL,
0x0000b0001a157811ULL, 0x000fe400078e68ffULL, 0x00000070061d7812ULL, 0x000fe400078ec0ffULL,
0x0000000500057211ULL, 0x000fc800078fe8ffULL, 0x0000000405097810ULL, 0x040fe20007ffe0ffULL,
0x0000000105087824ULL, 0x140fe200078e0200ULL, 0x00000008050c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008050d7824ULL, 0x040fe200078e00ffULL, 0x0000000c050e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b057824ULL, 0x000fe400078e0205ULL, 0x00000001090a7824ULL, 0x000fe200078e0200ULL,
0xfffffff80d087812ULL, 0x000fe200078ee208ULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0x000000051c147210ULL, 0x000fe20007f3e0ffULL, 0x000000010b097824ULL, 0x000fc400078e0209ULL,
0x000000010b0d7824ULL, 0x000fe200078e020cULL, 0xfffffff80f0a7812ULL, 0x000fe200078ee20aULL,
0x000000010b0b7824ULL, 0x000fe200078e020eULL, 0x000000091c127210ULL, 0x000fe20007f5e0ffULL,
0x000000010c057824ULL, 0x100fe200078e0200ULL, 0x0000000d1c0f7210ULL, 0x000fe20007f7e0ffULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000b1c0d7210ULL, 0x000fe20007f1e0ffULL,
0x000000010e0b7824ULL, 0x040fe400078e0200ULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0xfffffff80c097812ULL, 0x000fe200078ee205ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005e00140e7a11ULL, 0x000fe200078238ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0xfffffff8100b7812ULL, 0x000fe200078ee20bULL, 0x0000001008057824ULL, 0x000fe200078e0215ULL,
0x00005f0014147a11ULL, 0x000fe200008f3c11ULL, 0x000000100a117824ULL, 0x100fe200078e0215ULL,
0x00005e0012107a11ULL, 0x040fe200078238ffULL, 0x0000001009137824ULL, 0x100fe200078e0215ULL,
0x00005e000f0c7a11ULL, 0x000fe200078438ffULL, 0x000000100b157824ULL, 0x000fe200078e0215ULL,
0x00005f00120b7a11ULL, 0x000fe200008f3c17ULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x0000000e1d087210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e000d0e7a11ULL, 0x000fc400078638ffULL, 0x00005f000f0f7a11ULL, 0x000fe200010f3c0aULL,
0x000000ffff097224ULL, 0x000fe200008e0614ULL, 0x000000101d0a7210ULL, 0x040fe40007f1e0ffULL,
0x0000000c1d0c7210ULL, 0x000fe40007f3e0ffULL, 0x00005f000d067a11ULL, 0x000fe200018f3c06ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000000e1d0e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e6000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0606ULL,
0x000000000a117faeULL, 0x0003e8000b901c46ULL, 0x000000000c137faeULL, 0x0003e8000b901c46ULL,
0x000000000e157faeULL, 0x0003e4000b901c46ULL, 0x0000000160607810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff057424ULL, 0x002fc600078e00ffULL, 0x000000196000720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x0000000207057824ULL, 0x000fe400078e00ffULL,
0x00006400ff067624ULL, 0x000fc800078e00ffULL, 0x0000640005057624ULL, 0x000fc800078e0206ULL,
0x0000000105087824ULL, 0x000fc800078e0260ULL, 0x0000600008087625ULL, 0x000fca00078e0018ULL,
0x0000000608057981ULL, 0x000324000c1e1900ULL, 0x000000001a0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff4400720cULL, 0x000fe20003f05270ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000f6a81a087811ULL, 0x002fe200078e18ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff5a7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200008087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000c35000008947ULL, 0x000fea0003800000ULL, 0x0000000207087824ULL, 0x004fe400078e00ffULL,
0x00006400ff077624ULL, 0x000fc400078e00ffULL, 0x000000ffff207224ULL, 0x000fe400078e0009ULL,
0x0000640008087624ULL, 0x000fe400078e0207ULL, 0xff317217ff5e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc400078e00ffULL, 0x00000100090a7824ULL, 0x000fca00078e00ffULL,
0x0000001b0a00720cULL, 0x000fda0003f06070ULL, 0x0000c26000000947ULL, 0x004fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0060ULL, 0x000000ffff0a7224ULL, 0x000fc400078e001dULL,
0x00000000000e7805ULL, 0x000fca0000015200ULL, 0x0000000445077824ULL, 0x000fca00078e00ffULL,
0xfffffff807077812ULL, 0x000fc800078ec0ffULL, 0x0000f6c807107810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc00070d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804820ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000022000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0010ULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0e117210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0fULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001140dULL,
0x000000110c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x000000020c0c7819ULL, 0x000fc8000000120dULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc00070d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0010ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001045077824ULL, 0x000fe200078e00ffULL, 0x00000001090d7810ULL, 0x000fe20007ffe0ffULL,
0x0000580005057a24ULL, 0x010fc600078e02ffULL, 0x000000440d00720cULL, 0x000fe20003f06070ULL,
0x0000004005227824ULL, 0x000fe200078e00ffULL, 0xffffffe0070e7812ULL, 0x000fe400078ec0ffULL,
0x000000011d0d7812ULL, 0x000fc600078e0cffULL, 0x00000100090e7824ULL, 0x000fca00078e020eULL,
0x000000400e0e7810ULL, 0x000fc80007ffe0ffULL, 0x00000020031e7812ULL, 0x000fe200078ef80eULL,
0x0000049000008947ULL, 0x000fea0003800000ULL, 0x0000001007127812ULL, 0x000fe200078ec0ffULL,
0x000000021a147824ULL, 0x000fe200078e020dULL, 0x00000003ff207819ULL, 0x000fc80000011600ULL,
0x00000004201f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000120077824ULL, 0x100fe200078e0212ULL,
0x0000b00014147811ULL, 0x000fe400078e60ffULL, 0x0000000820237810ULL, 0x000fe20007ffe0ffULL,
0x000000011e057824ULL, 0x000fe400078e0207ULL, 0x000000011f117824ULL, 0x000fe400078e0212ULL,
0x0000000807467824ULL, 0x000fe200078e00ffULL, 0x0000000522187210ULL, 0x000fc40007f1e0ffULL,
0x0000000e1b057217ULL, 0x000fc60007800000ULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e0018107a11ULL, 0x000fe200078038ffULL, 0x0000000105057824ULL, 0x000fe400078e0a0eULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x00005f0018187a11ULL, 0x000fe200000f3c0fULL,
0x00000001070f7824ULL, 0x000fe200078e0200ULL, 0x0000001205057217ULL, 0x000fe40007800000ULL,
0x000000700e477812ULL, 0x000fe200078ec0ffULL, 0x000000011e0e7824ULL, 0x000fe200078e0211ULL,
0xfffffff846077812ULL, 0x000fe200078ee20fULL, 0x0000000105057824ULL, 0x000fc600078e0a12ULL,
0x0000000e221c7210ULL, 0x000fe20007fde0ffULL, 0x0000001007077824ULL, 0x000fe200078e0214ULL,
0x000000052000720cULL, 0x000fe40003f06070ULL, 0x00000047100e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x00005e001c107a11ULL, 0x000fe400078c38ffULL,
0x0000000c20207810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e0618ULL,
0x000000051f00720cULL, 0x000fe20003fa6070ULL, 0x00000001231f7824ULL, 0x000fe200078e0212ULL,
0x00005f001c1c7a11ULL, 0x000fe200030f3c13ULL, 0x0000000111137824ULL, 0x000fc400078e0200ULL,
0x0000000811187824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0005e2000c101c46ULL, 0x000000011e117824ULL, 0x000fe200078e021fULL,
0x0000004710107210ULL, 0x000fe20007f1e0ffULL, 0x0000000120217824ULL, 0x000fe200078e0212ULL,
0xfffffff818137812ULL, 0x000fe400078ee213ULL, 0x0000001122187210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200000e061cULL, 0x000000052300720cULL, 0x000fe20003f06070ULL,
0x0000001013137824ULL, 0x000fc400078e0214ULL, 0x00000008211c7824ULL, 0x000fe400078e00ffULL,
0x000000011e077824ULL, 0x004fe200078e0221ULL, 0x0000000010137faeULL, 0x0005e2000e901c46ULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x00005e00180e7a11ULL, 0x000fe400078a38ffULL,
0x0000000722127210ULL, 0x000fe40007fde0ffULL, 0x00005f0018077a11ULL, 0x000fe200028f3c0fULL,
0x000000081f187824ULL, 0x040fe200078e00ffULL, 0x000000052000720cULL, 0x000fe20003fa6070ULL,
0x000000ffff237224ULL, 0x000fe200030e06ffULL, 0x000000470e0e7210ULL, 0x000fe20007fde0ffULL,
0x000000011f057824ULL, 0x000fc800078e0200ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0607ULL,
0x00005e0012107a11ULL, 0x004fe200078c38ffULL, 0x0000000121077824ULL, 0x000fe200078e0200ULL,
0xfffffff818057812ULL, 0x000fe400078ee205ULL, 0x00005f0012117a11ULL, 0x000fe400030f3c23ULL,
0x0000004710107210ULL, 0x000fe20007fde0ffULL, 0x0000001005057824ULL, 0x000fe200078e0214ULL,
0xfffffff81c077812ULL, 0x000fc600078ee207ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x000000000e057faeULL, 0x0005e2000c101c46ULL, 0x0000001007077824ULL, 0x000fca00078e0214ULL,
0x0000000010077faeULL, 0x0005e2000e901c46ULL, 0x000003c000007947ULL, 0x000fea0003800000ULL,
0x0000001007057812ULL, 0x000fc800078ec0ffULL, 0x0000000500057211ULL, 0x000fc800078fe8ffULL,
0x00000004050f7810ULL, 0x040fe20007ffe0ffULL, 0x000000011e077824ULL, 0x000fe200078e0205ULL,
0x0000000c051f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001050e7824ULL, 0x100fe400078e0200ULL,
0x000000010f107824ULL, 0x040fe200078e0200ULL, 0x0000000722217210ULL, 0x000fe20007f1e0ffULL,
0x000000080f117824ULL, 0x000fe400078e00ffULL, 0x0000000805137824ULL, 0x000fe400078e00ffULL,
0x000000011e0f7824ULL, 0x000fe200078e020fULL, 0xfffffff811077812ULL, 0x000fe200078ee210ULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x0000000805117810ULL, 0x000fc40007ffe0ffULL,
0xfffffff813137812ULL, 0x000fe200078ee20eULL, 0x000000011e0e7824ULL, 0x040fe200078e021fULL,
0x00005e0021207a11ULL, 0x000fe200078038ffULL, 0x000000011e057824ULL, 0x000fe200078e0211ULL,
0x0000000f22127210ULL, 0x040fe20007fde0ffULL, 0x0000000811147824ULL, 0x000fe200078e00ffULL,
0x00005f0021217a11ULL, 0x000fe400000f3c10ULL, 0x00000005220f7210ULL, 0x040fe20007fbe0ffULL,
0x0000000111057824ULL, 0x100fe200078e0200ULL, 0x0000000e221c7210ULL, 0x000fe20007f1e0ffULL,
0x000000011f0e7824ULL, 0x000fc400078e0200ULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x00005e0012107a11ULL, 0x000fe200078c38ffULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0xfffffff81f187812ULL, 0x000fe200078ee20eULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x00005f0012117a11ULL, 0x000fe400030f3c11ULL, 0x00005e000f127a11ULL, 0x000fe400078a38ffULL,
0x0000007005237812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x00005f000f1f7a11ULL, 0x000fe200028f3c0eULL, 0x000000021a0f7824ULL, 0x000fe200078e020dULL,
0x00000023200e7210ULL, 0x000fc40007f1e0ffULL, 0x0000002310107210ULL, 0x080fe40007fbe0ffULL,
0x00005e001c1e7a11ULL, 0x000fe400078c38ffULL, 0x0000b0000f207811ULL, 0x000fe200078e60ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0621ULL, 0x0000002312127210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x00005f001c1c7a11ULL, 0x000fe200030f3c05ULL,
0x0000001013057824ULL, 0x100fe200078e0220ULL, 0x000000231e1e7210ULL, 0x000fe20007fbe0ffULL,
0x0000001007077824ULL, 0x000fc400078e0220ULL, 0x0000001014217824ULL, 0x100fe200078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e057faeULL, 0x0005e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fe400000e061fULL, 0x0000001018237824ULL, 0x000fe200078e0220ULL,
0x0000000010077faeULL, 0x0005e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fc600028e061cULL,
0x0000000012217faeULL, 0x0005e8000b901c46ULL, 0x000000001e237faeULL, 0x0005e4000b901c46ULL,
0x0000000845077824ULL, 0x004fe200078e00ffULL, 0x0000000160107810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0xfffffff0070e7812ULL, 0x000fe400078ec0ffULL,
0x000000191000720cULL, 0x000fc60003f06070ULL, 0x000000080d0e7824ULL, 0x000fca00078e020eULL,
0x0000000000007918ULL, 0x000fea0000000000ULL, 0x0000000108108824ULL, 0x000fe400078e0210ULL,
0x00000004ff118424ULL, 0x000fe200078e00ffULL, 0xffffffe0070f7812ULL, 0x040fe400078ec0ffULL,
0x0000001007127812ULL, 0x040fe200078ec0ffULL, 0x0000600010108625ULL, 0x000fe200078e0011ULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x0000f6a80e577810ULL, 0x000fc40007ffe0ffULL, 0x0000000610058981ULL, 0x000522000c1e1900ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000000f070f7210ULL, 0x000fd60007ffe012ULL,
0x00000000570403c2ULL, 0x000ee40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000e527f8cULL, 0x0006a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f608000f1e7f8cULL, 0x0006a4000c80043fULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x00f60c000f077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fc4000780481fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011413ULL, 0x0000001207077211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000207077819ULL, 0x000fc80000001212ULL,
0x000000070000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c000f077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe4000780481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x0000002045107824ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fe200078e00ffULL, 0x0000007007207812ULL, 0x000fc400078ec0ffULL,
0xffffff8010107812ULL, 0x000fe400078ec0ffULL, 0x0000000c11117812ULL, 0x000fc800078ec0ffULL,
0x0000001011077210ULL, 0x000fca0007ffe020ULL, 0x00f0000007217984ULL, 0x000ea80000000800ULL,
0x00f2000007187984ULL, 0x0006620000000800ULL, 0x0000005e2100720bULL, 0x004fe20003f1d000ULL,
0x000118e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000077806ULL, 0x008fc800000e0100ULL,
0x0000ffff07477812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff077424ULL, 0x000fe400078e00ffULL, 0x000000ffff517224ULL, 0x000fc400078e005eULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff147424ULL, 0x000fca00078e00ffULL,
0x0000043000008947ULL, 0x000fea0003800000ULL, 0x000000450200720cULL, 0x000fe40003fa5270ULL,
0x0000005e2100720bULL, 0x000fe20003f14000ULL, 0x000118827f007947ULL, 0x000fd8000b800000ULL,
0x00000000001c7806ULL, 0x000fc400000e0100ULL, 0x00000080451ed824ULL, 0x000fe200078e0220ULL,
0x000000215e517209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099101c1f7816ULL, 0x000fe200000000ffULL, 0x00000001111ed824ULL, 0x000fc600078e021eULL,
0x000000ff1f00720cULL, 0x000fe40003f05270ULL, 0x00f400511e00d388ULL, 0x0005f60000000800ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000515e1e7221ULL, 0x004fe20000010000ULL,
0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e004b7308ULL, 0x0004ec0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x004fe20000011600ULL,
0x000117c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e4b1e7589ULL, 0x0084e400000e0000ULL,
0x0000001e28287220ULL, 0x088fe20000410000ULL, 0x0000001e29297220ULL, 0x080fe20000410000ULL,
0x0000001e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001e30307220ULL, 0x080fe20000410000ULL, 0x0000001e31317220ULL, 0x080fe20000410000ULL,
0x0000001e34347220ULL, 0x080fe20000410000ULL, 0x0000001e35357220ULL, 0x080fe20000410000ULL,
0x0000001e38387220ULL, 0x080fe20000410000ULL, 0x0000001e39397220ULL, 0x080fe20000410000ULL,
0x0000001e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001e40407220ULL, 0x080fe20000410000ULL, 0x0000001e41417220ULL, 0x080fe20000410000ULL,
0x0000001e24247220ULL, 0x080fe20000410000ULL, 0x0000001e25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000004b06067220ULL, 0x008fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001e7811ULL, 0x004fe200078ff0ffULL, 0x000116a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e4b1e7589ULL, 0x0004e400000e0000ULL, 0x0000001e2a2a7220ULL, 0x088fe20000410000ULL,
0x0000001e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001e32327220ULL, 0x080fe20000410000ULL,
0x0000001e33337220ULL, 0x080fe20000410000ULL, 0x0000001e36367220ULL, 0x080fe20000410000ULL,
0x0000001e37377220ULL, 0x080fe20000410000ULL, 0x0000001e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001e3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001e3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001e42427220ULL, 0x080fe20000410000ULL,
0x0000001e43437220ULL, 0x080fe20000410000ULL, 0x0000001e26267220ULL, 0x080fe20000410000ULL,
0x0000001e27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff47ff7812ULL, 0x000fda000780601cULL, 0x8000005121210221ULL, 0x000fe20000010000ULL,
0x00007610ff070816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b21210820ULL, 0x000fc80000410000ULL,
0x0000002100150308ULL, 0x000ea40000000800ULL, 0x0000001518180220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000618067221ULL, 0x002fc20000010000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x000000021a187824ULL, 0x000fc800078e021dULL,
0x00000008181c7824ULL, 0x000fca00078e00ffULL, 0x00f6ac001c187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e237210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1fULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011421ULL, 0x0000002318187211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000218187819ULL, 0x000fc80000001221ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac001c187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991007187816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000015ff16723eULL, 0x000fe400000010ffULL,
0x00000002ff187819ULL, 0x000fe40000011600ULL, 0x0000541016217816ULL, 0x000fe20000000016ULL,
0x000112827f007947ULL, 0x000fea000b800000ULL, 0x00001f1821177589ULL, 0x0002a400000e0000ULL,
0x0000000818167810ULL, 0x000fe20007ffe0ffULL, 0x000112b27f007947ULL, 0x000fea000b800000ULL,
0x00001f1621167589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010181e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200078e0021ULL,
0x00002c0000497802ULL, 0x000fc40000000f00ULL, 0x00011d0000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018181e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x004fe200078e0021ULL, 0x00002c5000497802ULL, 0x000fc40000000f00ULL,
0x00011cb000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007001f7812ULL, 0x000fe200078ec0ffULL, 0x0000000245587824ULL, 0x040fe200078e00ffULL,
0x00000004ff497819ULL, 0x100fe20000011600ULL, 0x0000020045187824ULL, 0x002fe200078e00ffULL,
0x000000081f467812ULL, 0x000fe200078ef800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004581f7812ULL, 0x000fc400078ec0ffULL, 0xfffff800184d7812ULL, 0x000fe200078ec0ffULL,
0x00000008461c7824ULL, 0x040fe200078e00ffULL, 0x0000001f461f7210ULL, 0x000fc80007ffe049ULL,
0xfffffff81c187812ULL, 0x000fe400078ee21fULL, 0x00000008001f7812ULL, 0x000fc600078ec0ffULL,
0x0000001018187824ULL, 0x000fc400078e024dULL, 0x0000000445597824ULL, 0x000fe200078e00ffULL,
0x000000071f5a7812ULL, 0x000fe200078ef800ULL, 0x000000021a4f7824ULL, 0x000fe200078e021dULL,
0x00009910074e7816ULL, 0x000fe200000000ffULL, 0x00000008464c7824ULL, 0x000fe200078e00ffULL,
0x0000000459597812ULL, 0x000fe200078ec0ffULL, 0x000000085a1d7824ULL, 0x040fe200078e00ffULL,
0x000000105a487812ULL, 0x040fe200078efcffULL, 0x000000085a217824ULL, 0x008fe200078e00ffULL,
0x0000b0004f4f7811ULL, 0x000fe200078e60ffULL, 0x0000000149597824ULL, 0x000fe200078e0259ULL,
0x000000ff4e00720cULL, 0x000fe20003fa5270ULL, 0x0000000848477824ULL, 0x000fc400078e00ffULL,
0x000000015a207824ULL, 0x000fe400078e0259ULL, 0x00000001594a7824ULL, 0x000fe400078e0248ULL,
0x000000041a497824ULL, 0x000fe200078e0249ULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee220ULL,
0x0000000848557824ULL, 0x000fe200078e00ffULL, 0x0000000220507810ULL, 0x000fe40007ffe0ffULL,
0xfffffff847477812ULL, 0x000fe200078ee24aULL, 0x000000101c1c7824ULL, 0x000fe200078e024fULL,
0xfffffff821507812ULL, 0x000fc400078ee250ULL, 0x0000000249077810ULL, 0x000fe20007ffe046ULL,
0x0000001047497824ULL, 0x100fe200078e024fULL, 0x000000024a467810ULL, 0x000fe20007ffe0ffULL,
0x0000001050207824ULL, 0x000fe200078e024fULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0xfffffff84c4c7812ULL, 0x000fe400078ee207ULL, 0xfffffff855467812ULL, 0x000fe200078ee246ULL,
0x000000004948783bULL, 0x000ee40000004200ULL, 0x000000104c077824ULL, 0x000fc400078e024dULL,
0x000000002020783bULL, 0x004ea20000004200ULL, 0x00000010464c7824ULL, 0x000fcc00078e024fULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x000000ff1d6e7812ULL, 0x042fe400078ec0ffULL,
0x00000010ff897819ULL, 0x000fe4000001161cULL, 0x0000ffff1d857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5f7819ULL, 0x108fe40000011649ULL, 0x000000ff498e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fc40000011649ULL, 0x0000ffff49627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fe4000001161dULL, 0x00000010ff807819ULL, 0x000fe4000001161fULL,
0x00000018ff497819ULL, 0x000fe4000001164bULL, 0x000000ff1c5d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fc4000001161cULL, 0x0000ffff1c887812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001161dULL, 0x00000010ff777819ULL, 0x100fe4000001161eULL,
0x000000ff1e7e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001161eULL,
0x0000ffff1e797812ULL, 0x000fc400078ec0ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000ffff1f847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1e7819ULL, 0x104fe20000011620ULL,
0x2000006eff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff20817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe40000011620ULL, 0x0000ffff201c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1d7819ULL, 0x100fe40000011621ULL, 0x000000ff21747812ULL, 0x040fe400078ec0ffULL,
0x00000018ff717819ULL, 0x000fe40000011621ULL, 0x0000ffff217d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7c7819ULL, 0x000fc40000011622ULL,
0x000000ff22757812ULL, 0x040fe400078ec0ffULL, 0x00000018ff207819ULL, 0x000fe40000011622ULL,
0x0000ffff227a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7b7819ULL, 0x100fe40000011623ULL,
0x000000ff23787812ULL, 0x000fe400078ec0ffULL, 0x00000018ff217819ULL, 0x000fc40000011623ULL,
0x0000ffff23767812ULL, 0x000fe400078ec0ffULL, 0x000000ff488c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x100fe4000001164aULL, 0x000000ff4a8f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff557819ULL, 0x000fe4000001164aULL, 0x0000ffff4a637812ULL, 0x000fc400078ec0ffULL,
0x00000008ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff227819ULL, 0x000fe40000011648ULL,
0x0000ffff48237812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b4a7812ULL, 0x000fe400078ec0ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x00000008ff797819ULL, 0x000fe40000011679ULL,
0x00000018ff8b7819ULL, 0x000fe40000011648ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000000ff77777812ULL, 0x000fe200078ec0ffULL,
0x2000005bff867230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fc40000011684ULL,
0x0000008cff6e723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x000000ff1f837812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000018ff7f7819ULL, 0x000fe4000001161fULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x0000005cff8c723eULL, 0x000fe200020006ffULL, 0x20000049ff5c7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x000000ff22227812ULL, 0x000fe200078ec0ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff237819ULL, 0x000fe40000011623ULL,
0x0000005dff1f723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x0000008bff5d723eULL, 0x000fe200020006ffULL, 0x20000089ff8b7230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000085ff897230ULL, 0x000fe20000004100ULL,
0x00000084ff49723eULL, 0x000fe200020006ffULL, 0x20000080ff857230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000079ff807230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000077ff847230ULL, 0x000fe20000004100ULL,
0x00000055ff5b723eULL, 0x000fe200020006ffULL, 0x2000004aff557230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe200020006ffULL, 0x20000071ff797230ULL, 0x000fe20000004100ULL,
0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff777230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x00000022ff22723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fe200020006ffULL, 0x20000021ff757230ULL, 0x000fe20000004100ULL,
0x00000081ff4a723eULL, 0x000fe200020006ffULL, 0x20000049ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe2000001164bULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000ffff4b6d7812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000074ff4b723eULL, 0x000fe200020006ffULL, 0x20000020ff747230ULL, 0x000fe20000004100ULL,
0x00000070ff49723eULL, 0x000fe200020006ffULL, 0x20000022ff707230ULL, 0x000fe20000004100ULL,
0x0000005fff71723eULL, 0x000fe200020006ffULL, 0x20000023ff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x100fe2000001164cULL, 0x009000001820783bULL, 0x000e620000000200ULL,
0x000000ff4c657812ULL, 0x040fe200078ec0ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000018ff667819ULL, 0x000fe2000001164cULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x0000ffff4c727812ULL, 0x000fe200078ec0ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000010ff4c7819ULL, 0x000fc4000001164eULL, 0x000000ff4e697812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001164eULL, 0x0000ffff4e547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x100fe4000001164fULL, 0x000000ff4f6b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fc4000001164fULL, 0x0000ffff4f567812ULL, 0x000fe400078ec0ffULL,
0x0000008dff4f723eULL, 0x000fe400020006ffULL, 0x00000008ff627819ULL, 0x000fe40000011662ULL,
0x000000ff618d7812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000062ff61723eULL, 0x000fc400020006ffULL,
0x0000008dff62723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fe20000011663ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000064ff8d723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe2000001166dULL,
0x0000001720208231ULL, 0x082fe200003400ffULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x0000001722228231ULL, 0x000fe200003400ffULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x0000001621218231ULL, 0x080fe200003400ffULL, 0x00000063ff64723eULL, 0x000fe200020006ffULL,
0x2000008dff637230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000007eff827230ULL, 0x000fe20000004100ULL, 0x000000ff4d687812ULL, 0x000fe200078ec0ffULL,
0x2000006fff7e7230ULL, 0x000fe20000004100ULL, 0x00000018ff677819ULL, 0x000fe2000001164dULL,
0x0000001623238231ULL, 0x000fe200003400ffULL, 0x00000065ff8d723eULL, 0x000fe200020006ffULL,
0x2000006dff657230ULL, 0x000fe20000004100ULL, 0x0000008eff6f723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000068ff8e723eULL, 0x000fc400020006ffULL,
0x00000066ff68723eULL, 0x000fe200020006ffULL, 0x2000008dff667230ULL, 0x000fe20000004100ULL,
0x00000067ff6d723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011688ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000069ff8d723eULL, 0x000fe200020006ffULL, 0x2000006dff697230ULL, 0x000fe20000004100ULL,
0x000000ff1e1e7812ULL, 0x000fe200078ec0ffULL, 0x2000008eff677230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000006aff6d723eULL, 0x000fe200020006ffULL, 0x2000008dff6a7230ULL, 0x000fe20000004100ULL,
0x0000001eff8d723eULL, 0x000fe200020006ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fe2000001161fULL, 0x2000005eff877230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x000000ff1d1d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1f7819ULL, 0x000fe2000001168aULL, 0x2000008dff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x000010548b1e7816ULL, 0x000fe4000000001eULL, 0x0000001dff8d723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000010548c1f7816ULL, 0x000fc4000000001fULL,
0x00000008ff8b7819ULL, 0x000fe4000001161cULL, 0x00000010ff1d7819ULL, 0x000fe20000011686ULL,
0x2000008dff867230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe20000011688ULL,
0x0000001e2028723cULL, 0x000be20000041828ULL, 0x00000010ff8c7819ULL, 0x000fe40000011687ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x000010548c1d7816ULL, 0x000fe20000000089ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x020fe40000011682ULL,
0x00000010ff1f7819ULL, 0x000fe40000011684ULL, 0x00000010ff837819ULL, 0x000fe20000011683ULL,
0x0000001c202c723cULL, 0x000b62000004182cULL, 0x00000010ff827819ULL, 0x000fc40000011685ULL,
0x000010541f1e7816ULL, 0x000fe4000000001eULL, 0x00001054821f7816ULL, 0x000fe40000000083ULL,
0x000000ff7c827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x020fe4000001167eULL,
0x00000010ff1c7819ULL, 0x000fe20000011680ULL, 0x0000001e2030723cULL, 0x000fe20000041830ULL,
0x00000010ff7c7819ULL, 0x000fc4000001167fULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x000010547c1d7816ULL, 0x000fe40000000081ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000008ff877819ULL, 0x000fe4000001167dULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x0000001c2034723cULL, 0x000b620000041834ULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x00000008ff7a7819ULL, 0x000fe2000001167aULL,
0x2000008bff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff487e7812ULL, 0x000fe200078ec0ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x020fe4000001168aULL,
0x000000ff7b7b7812ULL, 0x000fe400078ec0ffULL, 0x000010541d4a7816ULL, 0x000fe4000000004aULL,
0x00900000071c783bULL, 0x000e620000000200ULL, 0x00000008ff7c7819ULL, 0x000fc40000011676ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff487819ULL, 0x000fe4000001167dULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff767819ULL, 0x000fe40000011679ULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000105449487816ULL, 0x000fe20000000048ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00001054864b7816ULL, 0x000fe2000000004bULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x0000105476497816ULL, 0x000fc40000000087ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff7b7819ULL, 0x000fe2000001167bULL, 0x0000004a2038723cULL, 0x040be20000041838ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x000000171c1cd231ULL, 0x082fe200003400ffULL,
0x00000010ff4a7819ULL, 0x020fe20000011677ULL, 0x00000048203c723cULL, 0x000b62000004183cULL,
0x00000010ff4b7819ULL, 0x000fe20000011682ULL, 0x000000171e1ed231ULL, 0x000fe200003400ffULL,
0x00000010ff737819ULL, 0x000fe2000001164dULL, 0x000000161d1dd231ULL, 0x080fe200003400ffULL,
0x000010544b4a7816ULL, 0x000fe2000000004aULL, 0x000000161f1fd231ULL, 0x000fe200003400ffULL,
0x00000010ff497819ULL, 0x020fc40000011674ULL, 0x00000010ff487819ULL, 0x000fe4000001167aULL,
0x000010547b4b7816ULL, 0x000fe40000000078ULL, 0x0000105449487816ULL, 0x000fe40000000048ULL,
0x0000105475497816ULL, 0x000fe4000000007cULL, 0x00000008ff727819ULL, 0x000fe20000011672ULL,
0x0000004a2040723cULL, 0x000f620000041840ULL, 0x0000ffff4d4d7812ULL, 0x000fc400078ec0ffULL,
0x0000008fff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5c7819ULL, 0x000fe2000001165cULL, 0x000000482024723cULL, 0x000b620000041824ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x000000ff4c4c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff227819ULL, 0x020fe4000001164fULL, 0x00000010ff207819ULL, 0x000fe4000001165fULL,
0x00000010ff217819ULL, 0x000fe40000011661ULL, 0x000010545d207816ULL, 0x000fe40000000020ULL,
0x0000105422217816ULL, 0x000fe40000000021ULL, 0x00000010ff4a7819ULL, 0x000fe2000001166eULL,
0x20000072ff6e7230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fc400020006ffULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x000000201c2c723cULL, 0x000b62000004182cULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000008ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff207819ULL, 0x020fe40000011664ULL,
0x00000010ff217819ULL, 0x000fc40000011665ULL, 0x000010545b207816ULL, 0x000fe40000000020ULL,
0x000010545c217816ULL, 0x000fe40000000021ULL, 0x00000008ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff227819ULL, 0x000fe4000001165eULL, 0x00000010ff237819ULL, 0x000fe20000011662ULL,
0x000000201c34723cULL, 0x000b620000041834ULL, 0x00000010ff557819ULL, 0x000fc40000011655ULL,
0x00000010ff487819ULL, 0x000fe40000011663ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000006cff8e723eULL, 0x000fe200020006ffULL, 0x2000006dff6c7230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x2000008eff6d7230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x2000007eff767230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x020fe20000011668ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fe2000001166eULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x0000105423227816ULL, 0x000fe40000000022ULL,
0x0000105448237816ULL, 0x000fe20000000055ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000010ff4b7819ULL, 0x000fe40000011670ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff707819ULL, 0x000fe20000011671ULL, 0x000000221c30723cULL, 0x000b620000041830ULL,
0x00001054216e7816ULL, 0x000fc4000000006eULL, 0x00000010ff207819ULL, 0x000fe40000011669ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff217819ULL, 0x000fe4000001164cULL, 0x000010544b4a7816ULL, 0x000fe4000000004aULL,
0x00001054704b7816ULL, 0x000fc4000000006fULL, 0x00001054206f7816ULL, 0x000fe4000000004dULL,
0x00001054216a7816ULL, 0x000fe4000000006aULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x0000004a1c28723cULL, 0x000f620000041828ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff237819ULL, 0x020fe40000011676ULL, 0x00000010ff227819ULL, 0x000fc40000011673ULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x0000006e1c3c723cULL, 0x000f62000004183cULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff217819ULL, 0x000fe4000001166cULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff207819ULL, 0x000fe4000001166dULL,
0x00000010ff557819ULL, 0x000fc40000011656ULL, 0x0000105423667816ULL, 0x000fe40000000066ULL,
0x0000105422677816ULL, 0x000fe40000000067ULL, 0x000010544e6b7816ULL, 0x000fe4000000006bULL,
0x0000105421547816ULL, 0x000fe40000000054ULL, 0x0000105420557816ULL, 0x000fe20000000055ULL,
0x000000661c38723cULL, 0x040f700000041838ULL, 0x0000006a1c40723cULL, 0x040f700000041840ULL,
0x000000541c24723cULL, 0x000b6e0000041824ULL, 0x000000081a1c7824ULL, 0x020fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd00000008000ULL, 0x00f6c8001c1c7f8cULL, 0x000e62000c80043fULL,
0xfffffff858587812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000040091c7811ULL, 0x002fe200078e40ffULL, 0x00f6880058ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff207224ULL, 0x000fe200078e001dULL, 0x0000000160607810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5e7224ULL, 0x000fe200078e0051ULL, 0x0000001b1c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff5b7224ULL, 0x000fc400078e0053ULL, 0x000000ffff1d7224ULL, 0x000fd400078e000dULL,
0x00008ef000000947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x002fc40000015200ULL,
0x000004000c1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000c1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010451e7824ULL, 0x000fe200078e00ffULL, 0x00000001091d7810ULL, 0x000fe20007ffe0ffULL,
0x0000580005057a24ULL, 0x010fc600078e02ffULL, 0x000000441d00720cULL, 0x000fe20003f06070ULL,
0x00000040054e7824ULL, 0x000fe200078e00ffULL, 0xffffffe01e1c7812ULL, 0x000fca00078ec0ffULL,
0x00000100091c7824ULL, 0x000fca00078e021cULL, 0x000000801c1c7810ULL, 0x000fc80007ffe0ffULL,
0x00000020034a7812ULL, 0x000fe200078ef81cULL, 0x000004b000008947ULL, 0x000fea0003800000ULL,
0x000000101e487812ULL, 0x000fe400078ec0ffULL, 0x00000003ff4b7819ULL, 0x000fc80000011600ULL,
0x000000044b4d7810ULL, 0x040fe20007ffe0ffULL, 0x000000014b237824ULL, 0x000fc800078e0248ULL,
0x0000000123057824ULL, 0x000fe400078e024aULL, 0x000000014d4f7824ULL, 0x000fe400078e0248ULL,
0x00000008234c7824ULL, 0x000fe200078e00ffULL, 0x000000054e207210ULL, 0x000fe20007f1e0ffULL,
0x000000014f1e7824ULL, 0x000fe200078e024aULL, 0x0000001c1b057217ULL, 0x000fc60007800000ULL,
0x000000ffff217224ULL, 0x000fe200000e06ffULL, 0x00005e00201f7a11ULL, 0x000fe200078038ffULL,
0x00000001051d7824ULL, 0x000fe200078e0a1cULL, 0x0000001e4e227210ULL, 0x000fe20007fde0ffULL,
0x000010000a057824ULL, 0x000fe200078e00ffULL, 0x00005f0020207a11ULL, 0x000fe200000f3c21ULL,
0x00000010001c7824ULL, 0x000fe200078e00ffULL, 0x0000001d481d7217ULL, 0x000fe20007800000ULL,
0x0000000123217824ULL, 0x000fe200078e0200ULL, 0x0000100005057812ULL, 0x000fe400078ec0ffULL,
0x000000701c1c7812ULL, 0x000fe200078ec0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0a48ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL, 0x000020001a057824ULL, 0x000fe200078e0205ULL,
0x0000001c1f1e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff217224ULL, 0x000fe200030e06ffULL,
0x0000001d4b00720cULL, 0x000fc40003f06070ULL, 0x0000b00005057810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e0620ULL, 0x0000001d4d00720cULL, 0x000fe40003fa6070ULL,
0x000000084b4d7810ULL, 0x000fe20007ffe0ffULL, 0x000000104c237824ULL, 0x000fe200078e0205ULL,
0x00005e0022497a11ULL, 0x040fe200078c38ffULL, 0x000000014f4c7824ULL, 0x000fe200078e0200ULL,
0x0000000c4b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000014d557824ULL, 0x000fe200078e0248ULL,
0x00005f0022227a11ULL, 0x000fe200030f3c21ULL, 0x000000084f4f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e237faeULL, 0x0003e2000c101c46ULL,
0x0000000155217824ULL, 0x000fe200078e024aULL, 0x0000001c49207210ULL, 0x000fc40007f1e0ffULL,
0xfffffff84f4c7812ULL, 0x000fe200078ee24cULL, 0x000000014b4f7824ULL, 0x000fe200078e0248ULL,
0x000000214e487210ULL, 0x000fe20007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0622ULL,
0x0000001d4d00720cULL, 0x000fc60003f06070ULL, 0x000000ffff497224ULL, 0x000fe400030e06ffULL,
0x000000104c237824ULL, 0x002fe400078e0205ULL, 0x000000014f1e7824ULL, 0x000fe400078e024aULL,
0x00000008554a7824ULL, 0x000fe200078e00ffULL, 0x0000000020237faeULL, 0x0003e2000e901c46ULL,
0x00005e00481f7a11ULL, 0x000fe200078a38ffULL, 0x000000084f4c7824ULL, 0x000fe200078e00ffULL,
0x0000001e4e227210ULL, 0x000fc40007fde0ffULL, 0x00005f0048487a11ULL, 0x000fe400028f3c49ULL,
0x0000001d4b00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff497224ULL, 0x000fe200030e06ffULL,
0x0000001c1f1e7210ULL, 0x000fe20007fde0ffULL, 0x00000001551d7824ULL, 0x100fe400078e0200ULL,
0x000000014f237824ULL, 0x002fe400078e0200ULL, 0x000000ffff1f7224ULL, 0x000fe200030e0648ULL,
0x00005e0022217a11ULL, 0x000fc400078c38ffULL, 0xfffffff84a487812ULL, 0x000fe400078ee21dULL,
0x00005f0022227a11ULL, 0x000fe400030f3c49ULL, 0x0000001c21207210ULL, 0x000fe20007fde0ffULL,
0x00000010481d7824ULL, 0x000fe200078e0205ULL, 0xfffffff84c4a7812ULL, 0x000fc600078ee223ULL,
0x000000ffff217224ULL, 0x000fe200030e0622ULL, 0x000000001e1d7faeULL, 0x0003e2000c101c46ULL,
0x000000104a057824ULL, 0x000fca00078e0205ULL, 0x0000000020057faeULL, 0x0003e2000e901c46ULL,
0x000003e000007947ULL, 0x000fea0003800000ULL, 0x000000101e057812ULL, 0x000fc800078ec0ffULL,
0x00000005001d7211ULL, 0x000fc800078fe8ffULL, 0x000000041d237810ULL, 0x040fe20007ffe0ffULL,
0x000000011d057824ULL, 0x040fe200078e024aULL, 0x000000081d497810ULL, 0x040fe20007ffe0ffULL,
0x000000011d1c7824ULL, 0x140fe200078e0200ULL, 0x0000000c1d4b7810ULL, 0x040fe20007ffe0ffULL,
0x000000081d217824ULL, 0x000fe200078e00ffULL, 0x000000054e227210ULL, 0x000fe20007f1e0ffULL,
0x00000001231f7824ULL, 0x040fe400078e0200ULL, 0x0000000823547824ULL, 0x000fe200078e00ffULL,
0xfffffff8211e7812ULL, 0x000fe200078ee21cULL, 0x00000001491c7824ULL, 0x000fc400078e024aULL,
0x000000ffff217224ULL, 0x000fe200000e06ffULL, 0xfffffff854547812ULL, 0x000fe200078ee21fULL,
0x0000000123057824ULL, 0x100fe200078e024aULL, 0x00005e00221f7a11ULL, 0x000fe200078038ffULL,
0x000000014b1d7824ULL, 0x000fe200078e024aULL, 0x0000001c4e4c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000149207824ULL, 0x140fe200078e0200ULL, 0x00005f0022227a11ULL, 0x000fe200000f3c21ULL,
0x0000000849237824ULL, 0x000fe200078e00ffULL, 0x000000054e057210ULL, 0x000fe20007fde0ffULL,
0x000010000a1c7824ULL, 0x000fe200078e00ffULL, 0x0000001d4e1d7210ULL, 0x000fe20007f1e0ffULL,
0x000000014b497824ULL, 0x000fe200078e0200ULL, 0xfffffff8234e7812ULL, 0x000fe200078ee220ULL,
0x000000ffff487224ULL, 0x000fe200030e06ffULL, 0x000010001c237812ULL, 0x000fe200078ec0ffULL,
0x000000084b567824ULL, 0x000fe200078e00ffULL, 0x00005e0005217a11ULL, 0x000fe200078c38ffULL,
0x00000010001c7824ULL, 0x000fc400078e00ffULL, 0x000020001a207824ULL, 0x000fe200078e0223ULL,
0x00005f0005487a11ULL, 0x000fe200030f3c48ULL, 0x000000ffff057224ULL, 0x000fe200028e06ffULL,
0xfffffff856567812ULL, 0x000fe200078ee249ULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0x00005e004c237a11ULL, 0x000fe400078038ffULL, 0x0000b000204d7810ULL, 0x000fe40007ffe0ffULL,
0x00005e001d497a11ULL, 0x040fe400078a38ffULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x000000104e4b7824ULL, 0x000fe200078e024dULL, 0x00005f004c4c7a11ULL, 0x000fe200000f3c05ULL,
0x000000101e057824ULL, 0x100fe200078e024dULL, 0x00005f001d4a7a11ULL, 0x000fe200028f3c4aULL,
0x00000010541d7824ULL, 0x100fe200078e024dULL, 0x0000001c1f1e7210ULL, 0x080fe20007f1e0ffULL,
0x00000010564d7824ULL, 0x000fe200078e024dULL, 0x0000001c21207210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0622ULL, 0x0000001c23227210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200028e0648ULL, 0x0000001c49487210ULL, 0x000fe40007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e057faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fe400000e064cULL, 0x000000ffff497224ULL, 0x000fe200028e064aULL,
0x00000000201d7faeULL, 0x0003e8000b901c46ULL, 0x00000000224b7faeULL, 0x0003e8000b901c46ULL,
0x00000000484d7faeULL, 0x0003e4000b901c46ULL, 0x0000000845207824ULL, 0x002fe200078e00ffULL,
0x000000020b1e7810ULL, 0x000fe20007ffe0ffULL, 0x000000080a1d7824ULL, 0x000fc400078e00ffULL,
0xffffffffff057424ULL, 0x000fe200078e00ffULL, 0xfffffff020207812ULL, 0x000fe400078ec0ffULL,
0x000000081d1d7812ULL, 0x000fe400078ec0ffULL, 0x000000191e00720cULL, 0x000fc60003f06070ULL,
0x0000000120567824ULL, 0x000fca00078e021dULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x00000002081e8810ULL, 0x000fe20007ffe00bULL, 0x00000004ff1f8424ULL, 0x000fc800078e00ffULL,
0x000060001e1e8625ULL, 0x000fe200078e001fULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x0000f6a856557810ULL, 0x000fc60007ffe0ffULL, 0x000000061e058981ULL, 0x000322000c1e1900ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000550403c2ULL, 0x000ea40000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800561e7f8cULL, 0x0022a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628000f227f8cULL, 0x000662000c80043fULL, 0x000000ffff5b7224ULL, 0x004fc600078e001fULL,
0x00000000001e7805ULL, 0x000fc80000015200ULL, 0x00f62c000f1d7984ULL, 0x000ea40000000800ULL,
0x800000001dff7812ULL, 0x006fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e207210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1fULL,
0x003d09002000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011421ULL, 0x000000201d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff207224ULL, 0x000fca00000e0621ULL, 0x000000021d1d7819ULL, 0x000fc80000001220ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c000f1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000801c1e7810ULL, 0x000fca0007ffe010ULL,
0x00000001111e7824ULL, 0x000fca00078e021eULL, 0x00f000001e207984ULL, 0x000e680000000800ULL,
0x00f200001e1d7984ULL, 0x0004e20000000800ULL, 0x000000512000720bULL, 0x002fe20003f1d000ULL,
0x0000e8427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x004fc800000e0100ULL,
0x0000ffff21ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff5e7224ULL, 0x000fd200078e0051ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000001021e7810ULL, 0x000fe40007ffe0ffULL,
0x000000512000720bULL, 0x000fe40003f14000ULL, 0x000000451e00720cULL, 0x000fe20003fa5270ULL,
0x0000e7f27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000227806ULL, 0x000fc400000e0100ULL,
0x00000080451ed824ULL, 0x000fe200078e021cULL, 0x00000051201cd209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x00000001111fd824ULL, 0x000fe200078e021eULL,
0x00009910221e7816ULL, 0x000fc800000000ffULL, 0x00f4001c1f00d388ULL, 0x0003e20000000800ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000051201c7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x000000511c1c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL, 0x0000001c004b7308ULL, 0x000e640000000800ULL,
0x0000004b06067220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x0000e7027f007947ULL, 0x000fea000b800000ULL,
0x00001f1e4b1c7589ULL, 0x0002a400000e0000ULL, 0x0000001c28287220ULL, 0x084fe20000410000ULL,
0x0000001c29297220ULL, 0x080fe20000410000ULL, 0x0000001c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001c30307220ULL, 0x080fe20000410000ULL,
0x0000001c31317220ULL, 0x080fe20000410000ULL, 0x0000001c34347220ULL, 0x080fe20000410000ULL,
0x0000001c35357220ULL, 0x080fe20000410000ULL, 0x0000001c38387220ULL, 0x080fe20000410000ULL,
0x0000001c39397220ULL, 0x080fe20000410000ULL, 0x0000001c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001c40407220ULL, 0x080fe20000410000ULL,
0x0000001c41417220ULL, 0x080fe20000410000ULL, 0x0000001c24247220ULL, 0x080fe20000410000ULL,
0x0000001c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001e7811ULL, 0x002fe200078ff0ffULL, 0x0000e5f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e4b1c7589ULL, 0x0002a400000e0000ULL, 0x0000001c2a2a7220ULL, 0x084fe20000410000ULL,
0x0000001c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001c32327220ULL, 0x080fe20000410000ULL,
0x0000001c33337220ULL, 0x080fe20000410000ULL, 0x0000001c36367220ULL, 0x080fe20000410000ULL,
0x0000001c37377220ULL, 0x080fe20000410000ULL, 0x0000001c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001c42427220ULL, 0x080fe20000410000ULL,
0x0000001c43437220ULL, 0x080fe20000410000ULL, 0x0000001c26267220ULL, 0x080fe20000410000ULL,
0x0000001c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff22ff7812ULL, 0x000fe20007800821ULL, 0x00000001ff227424ULL, 0x000fe200078e00ffULL,
0x00000051205e7209ULL, 0x000fd60007810000ULL, 0x8000005e20200221ULL, 0x000fe20000010000ULL,
0x00007610ff220816ULL, 0x000fc60000000022ULL, 0x3fb8aa3b20200820ULL, 0x000fc80000410000ULL,
0x0000002000150308ULL, 0x000e640000000800ULL, 0x000000151d1d0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000061d067221ULL, 0x008fc40000010000ULL,
0x00000000001c7805ULL, 0x000fca0000015200ULL, 0x00f6ac000e1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac000e1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804853ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910221c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000015ff16723eULL, 0x000fe400000010ffULL,
0x00000002ff1d7819ULL, 0x000fe40000011600ULL, 0x00005410161c7816ULL, 0x000fe20000000016ULL,
0x0000e1d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1d1c177589ULL, 0x0002a400000e0000ULL,
0x000000081d1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000e2027f007947ULL, 0x000fea000b800000ULL,
0x00001f1e1c167589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101d1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x00005ea000497802ULL, 0x000fc40000000f00ULL, 0x0000ea6000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181d1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x004fe200078e001cULL, 0x00005ef000497802ULL, 0x000fc40000000f00ULL,
0x0000ea1000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021a5d7824ULL, 0x000fe200078e020dULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000015a1c7824ULL, 0x00afc400078e0259ULL, 0x000000085a1d7824ULL, 0x000fe200078e00ffULL,
0x0000b0005d5d7811ULL, 0x000fc800078e60ffULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee21cULL,
0x0000001050537824ULL, 0x100fe400078e025dULL, 0x0000001047527824ULL, 0x100fe400078e025dULL,
0x000000101c547824ULL, 0x100fe200078e025dULL, 0x000000005320783bULL, 0x004e620000004200ULL,
0x0000001046517824ULL, 0x000fc600078e025dULL, 0x000000005248783bULL, 0x000ea80000004200ULL,
0x00000000541c783bULL, 0x000ee80000004200ULL, 0x00000000514c783bULL, 0x000ee20000004200ULL,
0x00000018ff787819ULL, 0x002fe40000011620ULL, 0x00000018ff6c7819ULL, 0x000fc40000011623ULL,
0x00000018ff607819ULL, 0x004fe40000011649ULL, 0x000000ff217d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff717819ULL, 0x000fe40000011623ULL, 0x000000ff23817812ULL, 0x040fe400078ec0ffULL,
0x0000ffff23797812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b627812ULL, 0x000fc400078ec0ffULL,
0x000000ff1d647812ULL, 0x008fe400078ec0ffULL, 0x000000ff22807812ULL, 0x000fe400078ec0ffULL,
0x00000018ff237819ULL, 0x000fe4000001164bULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000010ff887819ULL, 0x000fe4000001161eULL, 0x000000ff1e877812ULL, 0x000fc400078ec0ffULL,
0x00000018ff867819ULL, 0x000fe4000001161eULL, 0x0000ffff1e8b7812ULL, 0x000fe400078ec0ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff727819ULL, 0x100fe40000011648ULL,
0x000000ff486f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fc40000011648ULL,
0x0000ffff481e7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000007dff48723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x000000ff1c637812ULL, 0x000fe200078ec0ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000064ff8d723eULL, 0x000fc400020006ffULL, 0x00000080ff7d723eULL, 0x000fe200020006ffULL,
0x20000078ff807230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x2000006cff787230ULL, 0x000fe20000004100ULL, 0x000000ff4c647812ULL, 0x000fe200078ec0ffULL,
0x20000060ff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff4d657812ULL, 0x000fe200078ec0ffULL,
0x20000062ff607230ULL, 0x000fe20000004100ULL, 0x00000063ff8c723eULL, 0x000fe200020006ffULL,
0x20000023ff627230ULL, 0x000fe20000004100ULL, 0x00000018ff637819ULL, 0x000fe2000001164cULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000065ff23723eULL, 0x000fc400020006ffULL,
0x00000010ff6d7819ULL, 0x100fe40000011622ULL, 0x00000018ff6b7819ULL, 0x000fe40000011622ULL,
0x0000ffff227a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f227812ULL, 0x000fe400078ec0ffULL,
0x00000063ff65723eULL, 0x000fe200020006ffULL, 0x20000064ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x100fe20000011621ULL, 0x20000023ff647230ULL, 0x000fe20000004100ULL,
0x00000018ff7c7819ULL, 0x000fe20000011621ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000ffff21827812ULL, 0x000fc400078ec0ffULL, 0x000000ff1f907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fe4000001164eULL, 0x00000010ff687819ULL, 0x000fe4000001161cULL,
0x00000022ff23723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x000fe40000011620ULL,
0x000000ff20737812ULL, 0x000fc400078ec0ffULL, 0x0000ffff207e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fe4000001164fULL, 0x00000010ff6a7819ULL, 0x000fe4000001161dULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000021ff22723eULL, 0x000fe400020006ffULL,
0x000000ff68217812ULL, 0x000fe200078ec0ffULL, 0x20000023ff687230ULL, 0x000fe20000004100ULL,
0x00000018ff5c7819ULL, 0x000fc4000001161cULL, 0x0000ffff1c697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8e7819ULL, 0x100fe4000001161fULL, 0x00000018ff8f7819ULL, 0x000fe4000001161fULL,
0x0000ffff1f7b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff49707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1f7819ULL, 0x000fc40000011649ULL, 0x0000ffff491c7812ULL, 0x000fe400078ec0ffULL,
0x00000020ff23723eULL, 0x000fe400020006ffULL, 0x00000073ff49723eULL, 0x000fe200020006ffULL,
0x20000090ff737230ULL, 0x000fe20000004100ULL, 0x000000ff6a207812ULL, 0x000fe200078ec0ffULL,
0x20000023ff6a7230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000070ff90723eULL, 0x000fc400020006ffULL,
0x00000008ff697819ULL, 0x000fe20000011669ULL, 0x2000006fff707230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x20000090ff6f7230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000069ff90723eULL, 0x000fe200020006ffULL,
0x20000022ff697230ULL, 0x000fe20000004100ULL, 0x00000018ff6e7819ULL, 0x000fe2000001161dULL,
0x20000021ff917230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000020ff937230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x009800001820783bULL, 0x000e620000000200ULL, 0x0000ffff1d837812ULL, 0x000fe200078ec0ffULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x2000006eff8a7230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000087ff6e7230ULL, 0x000fe20000004100ULL, 0x00000008ff837819ULL, 0x000fe20000011683ULL,
0x2000008fff877230ULL, 0x000fe20000004100ULL, 0x00000081ff8f723eULL, 0x000fe200020006ffULL,
0x2000007cff817230ULL, 0x000fe20000004100ULL, 0x00000008ff7e7819ULL, 0x000fe2000001167eULL,
0x2000007dff7c7230ULL, 0x000fe20000004100ULL, 0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL,
0x2000008fff7d7230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fc400020006ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8b7819ULL, 0x000fe2000001168bULL,
0x20000083ff927230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000008ff827819ULL, 0x000fe40000011682ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff7b7819ULL, 0x000fc4000001167bULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000077ff8f723eULL, 0x000fe200020006ffULL, 0x2000006bff777230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7a7819ULL, 0x000fe2000001167aULL,
0x2000008fff6b7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000000ff71717812ULL, 0x000fe200078ec0ffULL, 0x0000001720208231ULL, 0x082fe200003400ffULL,
0x00000008ff797819ULL, 0x000fe20000011679ULL, 0x20000088ff8f7230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x0000001722228231ULL, 0x000fe200003400ffULL,
0x00000082ff83723eULL, 0x000fe200020006ffULL, 0x2000007eff827230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x2000006dff7e7230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x2000008bff887230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x2000007bff8b7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000007fff7b7230ULL, 0x000fe20000004100ULL,
0x00000079ff6d723eULL, 0x000fe200020006ffULL, 0x2000007aff797230ULL, 0x000fe20000004100ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000071ff7f7230ULL, 0x000fe20000004100ULL,
0x00000008ff1e7819ULL, 0x000fe2000001161eULL, 0x2000006dff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff1f1f7812ULL, 0x000fe200078ec0ffULL, 0x0000001621218231ULL, 0x080fe200003400ffULL,
0x0000005cff89723eULL, 0x000fe200020006ffULL, 0x0000001623238231ULL, 0x000fe200003400ffULL,
0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000072ff71723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x0000001eff6d723eULL, 0x000fc400020006ffULL, 0x0000001fff72723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe2000001168cULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff1f7819ULL, 0x000fe2000001168dULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff8c7819ULL, 0x000fe40000011693ULL, 0x00000010ff1d7819ULL, 0x000fc4000001164aULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00001054911e7816ULL, 0x000fe4000000001eULL,
0x000010548c1f7816ULL, 0x000fe2000000001fULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff8c7819ULL, 0x000fe4000001161cULL, 0x000000ff1d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x0000001e2028723cULL, 0x000be20000041828ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x00000010ff1c7819ULL, 0x000fe40000011690ULL,
0x00000010ff1d7819ULL, 0x000fe40000011692ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00001054891c7816ULL, 0x000fe4000000001cULL, 0x000010548a1d7816ULL, 0x000fe2000000001dULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x000000ff74747812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1e7819ULL, 0x020fe4000001166eULL, 0x00000010ff1f7819ULL, 0x000fe20000011673ULL,
0x0000001c202c723cULL, 0x000be2000004182cULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff857819ULL, 0x000fe4000001164bULL,
0x0000ffff4a847812ULL, 0x000fc400078ec0ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x000010548f1e7816ULL, 0x000fe4000000001eULL, 0x000010548e1f7816ULL, 0x000fe2000000001fULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000000ff85897812ULL, 0x000fe400078ec0ffULL,
0x00000008ff857819ULL, 0x000fe40000011684ULL, 0x00000010ff1d7819ULL, 0x020fe20000011686ULL,
0x0000001e2030723cULL, 0x000b620000041830ULL, 0x00000010ff1c7819ULL, 0x000fc40000011688ULL,
0x00000010ff847819ULL, 0x000fe40000011687ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x00001054841d7816ULL, 0x000fe4000000008bULL,
0x00000010ff1e7819ULL, 0x020fe40000011648ULL, 0x00000010ff497819ULL, 0x000fc40000011649ULL,
0x00000010ff487819ULL, 0x000fe20000011674ULL, 0x0000001c2034723cULL, 0x000b620000041834ULL,
0x00000010ff1f7819ULL, 0x000fe4000001167bULL, 0x0000105448487816ULL, 0x000fe40000000049ULL,
0x000010541f497816ULL, 0x000fe4000000001eULL, 0x00980000071c783bULL, 0x020e620000000200ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x000000ff4a5f7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe2000001164aULL, 0x20000085ff747230ULL, 0x000fe20000004100ULL,
0x0000ffff4b4b7812ULL, 0x000fe200078ec0ffULL, 0x000000482038723cULL, 0x000b620000041838ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164cULL, 0x00000008ff847819ULL, 0x000fe4000001164bULL,
0x000000ff4a857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4b7819ULL, 0x000fc40000011680ULL,
0x00000010ff4a7819ULL, 0x000fe40000011682ULL, 0x00000010ff807819ULL, 0x000fe40000011681ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x000010544b4a7816ULL, 0x000fe4000000004aULL,
0x00001054804b7816ULL, 0x000fe40000000083ULL, 0x00000010ff487819ULL, 0x020fc4000001167cULL,
0x00000010ff497819ULL, 0x000fe4000001167eULL, 0x00000010ff807819ULL, 0x000fe2000001167dULL,
0x0000004a203c723cULL, 0x000b62000004183cULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff4a7819ULL, 0x020fe20000011679ULL, 0x000000171c1c8231ULL, 0x082fe200003400ffULL,
0x00000010ff4b7819ULL, 0x000fe2000001167aULL, 0x000000171e1e8231ULL, 0x000fe200003400ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000161d1d8231ULL, 0x080fe200003400ffULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x000000161f1f8231ULL, 0x000fe200003400ffULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000105449487816ULL, 0x000fe20000000048ULL, 0x2000008dff6e7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x20000089ff7b7230ULL, 0x000fe20000004100ULL,
0x000010547f497816ULL, 0x000fc40000000080ULL, 0x00001054774a7816ULL, 0x000fe2000000004aULL,
0x2000008cff737230ULL, 0x000fe20000004100ULL, 0x00001054784b7816ULL, 0x000fe4000000004bULL,
0x00000010ff767819ULL, 0x000fe2000001164dULL, 0x000000482040723cULL, 0x000b620000041840ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x000000ff76767812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7b7819ULL, 0x000fc4000001167bULL, 0x00000010ff487819ULL, 0x020fe20000011670ULL,
0x0000004a2024723cULL, 0x000b620000041824ULL, 0x00000010ff497819ULL, 0x000fe4000001166fULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff227819ULL, 0x020fe4000001165fULL, 0x00000010ff237819ULL, 0x000fc4000001166eULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff207819ULL, 0x000fe4000001166dULL, 0x00000010ff217819ULL, 0x000fe40000011673ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000085ff7c7230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fe20000000022ULL, 0x20000084ff7d7230ULL, 0x000fe20000004100ULL,
0x000010547b237816ULL, 0x000fe20000000060ULL, 0x20000076ff707230ULL, 0x000fe20000004100ULL,
0x0000ffff4c757812ULL, 0x000fe400078ec0ffULL, 0x0000105471487816ULL, 0x000fc40000000048ULL,
0x0000105472497816ULL, 0x000fe20000000049ULL, 0x000000221c30723cULL, 0x040b620000041830ULL,
0x000010546b207816ULL, 0x000fe40000000020ULL, 0x000010546c217816ULL, 0x000fe40000000021ULL,
0x00000018ff667819ULL, 0x000fe4000001164dULL, 0x00000010ff5c7819ULL, 0x000fe2000001164eULL,
0x000000481c28723cULL, 0x000f620000041828ULL, 0x000000ff4e677812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4c7819ULL, 0x000fe4000001164fULL, 0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4e4e7812ULL, 0x000fe200078ec0ffULL, 0x000000201c2c723cULL, 0x000b62000004182cULL,
0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff757819ULL, 0x000fe40000011675ULL,
0x00000008ff4d7819ULL, 0x000fc4000001164dULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4e7819ULL, 0x000fe4000001164eULL,
0x00000008ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff227819ULL, 0x020fe40000011663ULL,
0x00000010ff237819ULL, 0x000fc4000001167cULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff207819ULL, 0x000fe40000011674ULL,
0x00000010ff217819ULL, 0x000fe4000001167dULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff497819ULL, 0x000fc40000011670ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000075ff6f7230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000105423227816ULL, 0x000fe20000000022ULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000105461207816ULL, 0x000fe20000000020ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000105462217816ULL, 0x000fc40000000021ULL,
0x0000105449237816ULL, 0x000fe40000000064ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff667819ULL, 0x000fe20000011666ULL, 0x000000201c34723cULL, 0x000b620000041834ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff4c7819ULL, 0x000fc4000001164cULL, 0x00000010ff207819ULL, 0x020fe2000001166fULL,
0x000000221c38723cULL, 0x000b620000041838ULL, 0x00000010ff217819ULL, 0x000fe4000001164dULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff237819ULL, 0x020fe40000011668ULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x0000105465207816ULL, 0x000fe40000000020ULL,
0x0000105466217816ULL, 0x000fe40000000021ULL, 0x000010545c227816ULL, 0x000fe40000000067ULL,
0x000010544c237816ULL, 0x000fe40000000023ULL, 0x00001054694e7816ULL, 0x000fe2000000004eULL,
0x000000201c3c723cULL, 0x000f62000004183cULL, 0x000010546a4f7816ULL, 0x000fce000000004fULL,
0x000000221c40723cULL, 0x040f700000041840ULL, 0x0000004e1c24723cULL, 0x000b6e0000041824ULL,
0x0000f6c81a1c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000001c1c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000080091c7811ULL, 0x002fe200078e40ffULL, 0x00f6900058ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff207224ULL, 0x000fe200078e001dULL, 0x000000020b607810ULL, 0x000fc40007ffe0ffULL,
0x0000001b1c00720cULL, 0x000fe40003f06070ULL, 0x000000010a1d7812ULL, 0x000fd600078ec0ffULL,
0x00005e9000000947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x002fc40000015200ULL,
0x000004000c1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000c1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010451c7824ULL, 0x000fe200078e00ffULL, 0x00000001091d7810ULL, 0x000fe20007ffe0ffULL,
0x0000580005057a24ULL, 0x010fc600078e02ffULL, 0x000000441d00720cULL, 0x000fe20003f06070ULL,
0x00000040054a7824ULL, 0x000fe200078e00ffULL, 0xffffffe01c1e7812ULL, 0x000fca00078ec0ffULL,
0x00000100091e7824ULL, 0x000fca00078e021eULL, 0x000000c01e1e7810ULL, 0x000fc80007ffe0ffULL,
0x0000002003497812ULL, 0x000fe200078ef81eULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000101c487812ULL, 0x000fe400078ec0ffULL, 0x00000003ff4b7819ULL, 0x000fe40000011600ULL,
0x0000001e1b057217ULL, 0x000fe40007800000ULL, 0x000000044b4d7810ULL, 0x040fe20007ffe0ffULL,
0x000000014b217824ULL, 0x000fe400078e0248ULL, 0x0000000105057824ULL, 0x000fc400078e0a1eULL,
0x00000001211c7824ULL, 0x000fe400078e0249ULL, 0x00000010001e7824ULL, 0x000fe200078e00ffULL,
0x0000000548057217ULL, 0x000fe20007800000ULL, 0x000000014d4e7824ULL, 0x000fe200078e0248ULL,
0x0000001c4a1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000121237824ULL, 0x000fe400078e0200ULL,
0x0000000105057824ULL, 0x000fe400078e0a48ULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x00005e001c1f7a11ULL, 0x000fe200078038ffULL, 0x00000008214c7824ULL, 0x000fc400078e00ffULL,
0x000000084e5f7824ULL, 0x000fe200078e00ffULL, 0x00005f001c207a11ULL, 0x000fe200000f3c1dULL,
0x000000014e1d7824ULL, 0x000fe200078e0249ULL, 0x000000701e1c7812ULL, 0x000fe400078ec0ffULL,
0x000000054b00720cULL, 0x000fe40003f06070ULL, 0x0000001c1f1e7210ULL, 0x080fe40007fbe0ffULL,
0x0000001d4a227210ULL, 0x000fe40007fde0ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee223ULL,
0x000000ffff1f7224ULL, 0x000fe200028e0620ULL, 0x000000054d00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff217224ULL, 0x000fe200030e06ffULL, 0x000000084b4d7810ULL, 0x040fe20007ffe0ffULL,
0x000000104c1d7824ULL, 0x000fe200078e025dULL, 0x00005e0022237a11ULL, 0x000fe200078c38ffULL,
0x000000014e4c7824ULL, 0x000fe200078e0200ULL, 0x0000000c4b4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000014d4f7824ULL, 0x000fe200078e0248ULL, 0x00005f0022227a11ULL, 0x000fe200030f3c21ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e1d7faeULL, 0x0003e2000c101c46ULL,
0x0000001c23207210ULL, 0x000fe20007f1e0ffULL, 0x000000014f217824ULL, 0x000fe200078e0249ULL,
0xfffffff85f4c7812ULL, 0x000fe200078ee24cULL, 0x000000014b4e7824ULL, 0x000fc600078e0248ULL,
0x000000214a487210ULL, 0x000fe20007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0622ULL,
0x000000054d00720cULL, 0x080fe20003f06070ULL, 0x000000104c1d7824ULL, 0x002fe400078e025dULL,
0x000000014e1e7824ULL, 0x000fe400078e0249ULL, 0x000000ffff237224ULL, 0x000fe200030e06ffULL,
0x00000000201d7faeULL, 0x0003e2000e901c46ULL, 0x00005e00481f7a11ULL, 0x000fe200078a38ffULL,
0x000000014e497824ULL, 0x100fe200078e0200ULL, 0x0000001e4a227210ULL, 0x000fe20007fde0ffULL,
0x000000084f4a7824ULL, 0x000fe200078e00ffULL, 0x00005f0048487a11ULL, 0x000fe200028f3c23ULL,
0x000000084e4e7824ULL, 0x000fe200078e00ffULL, 0x000000054b00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff237224ULL, 0x000fe200030e06ffULL, 0x0000001c1f1e7210ULL, 0x000fe20007fde0ffULL,
0x000000014f057824ULL, 0x000fc800078e0200ULL, 0x000000ffff1f7224ULL, 0x000fe200030e0648ULL,
0x00005e0022217a11ULL, 0x002fe400078c38ffULL, 0xfffffff84a487812ULL, 0x000fe400078ee205ULL,
0x00005f00221d7a11ULL, 0x000fe400030f3c23ULL, 0x0000001c21207210ULL, 0x000fe20007fde0ffULL,
0x0000001048057824ULL, 0x000fe200078e025dULL, 0xfffffff84e227812ULL, 0x000fc600078ee249ULL,
0x000000ffff217224ULL, 0x000fe200030e061dULL, 0x000000001e057faeULL, 0x0003e2000c101c46ULL,
0x00000010225d7824ULL, 0x000fca00078e025dULL, 0x00000000205d7faeULL, 0x0003e2000e901c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x000000101c057812ULL, 0x000fc800078ec0ffULL,
0x00000005001c7211ULL, 0x000fc800078fe8ffULL, 0x000000041c207810ULL, 0x040fe20007ffe0ffULL,
0x000000011c057824ULL, 0x040fe200078e0249ULL, 0x000000081c217810ULL, 0x040fe20007ffe0ffULL,
0x000000011c1d7824ULL, 0x140fe200078e0200ULL, 0x0000000c1c237810ULL, 0x040fe20007ffe0ffULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0x000000054a227210ULL, 0x000fe20007f1e0ffULL,
0x00000001201f7824ULL, 0x040fe400078e0200ULL, 0x00000008204e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee21dULL, 0x000000ffff1d7224ULL, 0x000fc400000e06ffULL,
0x0000000120057824ULL, 0x000fe200078e0249ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee21fULL,
0x00000001211c7824ULL, 0x040fe200078e0249ULL, 0x00005e00221f7a11ULL, 0x040fe200078038ffULL,
0x0000000121207824ULL, 0x000fe400078e0200ULL, 0x00000008234b7824ULL, 0x040fe200078e00ffULL,
0x00005f0022227a11ULL, 0x000fe400000f3c1dULL, 0x000000054a487210ULL, 0x040fe20007f1e0ffULL,
0x0000000123057824ULL, 0x000fe200078e0249ULL, 0x0000001c4a4c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000821497824ULL, 0x000fc400078e00ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x00005e0048217a11ULL, 0x000fe200078038ffULL, 0x00000010001c7824ULL, 0x000fe200078e00ffULL,
0x000000054a057210ULL, 0x000fe40007fde0ffULL, 0x00005f0048487a11ULL, 0x000fe200000f3c1dULL,
0x000000ffff1d7224ULL, 0x000fe200028e06ffULL, 0xfffffff8495c7812ULL, 0x000fe200078ee220ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x00005e0005497a11ULL, 0x000fe200078a38ffULL,
0x0000000123207824ULL, 0x000fe200078e0200ULL, 0x00005e004c237a11ULL, 0x000fc400078038ffULL,
0x000000701c1c7812ULL, 0x000fe400078ec0ffULL, 0x00005f00054a7a11ULL, 0x000fe200028f3c4aULL,
0x000000101e057824ULL, 0x000fe200078e025dULL, 0x00005f004c4c7a11ULL, 0x000fe200000f3c1dULL,
0x000000104e1d7824ULL, 0x100fe200078e025dULL, 0xfffffff84b607812ULL, 0x000fe200078ee220ULL,
0x000000105c4b7824ULL, 0x100fe200078e025dULL, 0x0000001c1f1e7210ULL, 0x080fe40007f1e0ffULL,
0x0000001c21207210ULL, 0x000fe20007fbe0ffULL, 0x00000010605d7824ULL, 0x000fc400078e025dULL,
0x000000ffff1f7224ULL, 0x000fe200000e0622ULL, 0x0000001c23227210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200028e0648ULL, 0x0000001c49487210ULL, 0x000fe40007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e057faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fe400000e064cULL, 0x000000ffff497224ULL, 0x000fe200028e064aULL,
0x00000000201d7faeULL, 0x0003e8000b901c46ULL, 0x00000000224b7faeULL, 0x0003e8000b901c46ULL,
0x00000000485d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000030b1e7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff057424ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x000000191e00720cULL, 0x000fda0003fa6070ULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x00000001081e7824ULL, 0x000fe400078e021eULL,
0x00000004ff1f7424ULL, 0x000fc800078e00ffULL, 0x000060001e1e7625ULL, 0x000fca00078e001fULL,
0x000000061e057981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000570403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000e5c7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f648000f227f8cULL, 0x0002a4000c80043fULL,
0x00000000001e7805ULL, 0x002fc40000015200ULL, 0x00f64c000f1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x006fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e207210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1fULL,
0x003d09002000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011421ULL, 0x000000201d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff207224ULL, 0x000fca00000e0621ULL, 0x000000021d1d7819ULL, 0x000fc80000001220ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c000f1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001001c1e7810ULL, 0x000fca0007ffe010ULL,
0x00000001111e7824ULL, 0x000fca00078e021eULL, 0x00f000001e1d7984ULL, 0x000e680000000800ULL,
0x00f200001e207984ULL, 0x0004e20000000800ULL, 0x0000005e1d00720bULL, 0x002fe20003f1d000ULL,
0x0000baa27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x004fc800000e0100ULL,
0x0000ffff21ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff487424ULL, 0x000fe400078e00ffULL, 0x000000ffff577224ULL, 0x000fd200078e005eULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000002021e7810ULL, 0x000fe40007ffe0ffULL,
0x0000005e1d00720bULL, 0x000fe40003f14000ULL, 0x000000451e00720cULL, 0x000fe20003fa5270ULL,
0x0000ba527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000227806ULL, 0x000fc400000e0100ULL,
0x00000080451ed824ULL, 0x000fe200078e021cULL, 0x0000001d5e1cd209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x00000001111fd824ULL, 0x000fe200078e021eULL,
0x00009910221e7816ULL, 0x000fc800000000ffULL, 0x00f4001c1f00d388ULL, 0x0003e20000000800ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001d5e1f7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x8000001f5e1c7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL, 0x0000001c004b7308ULL, 0x000e640000000800ULL,
0x0000004b06067220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x0000b9627f007947ULL, 0x000fea000b800000ULL,
0x00001f1e4b1c7589ULL, 0x0002a400000e0000ULL, 0x0000001c28287220ULL, 0x084fe20000410000ULL,
0x0000001c29297220ULL, 0x080fe20000410000ULL, 0x0000001c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001c30307220ULL, 0x080fe20000410000ULL,
0x0000001c31317220ULL, 0x080fe20000410000ULL, 0x0000001c34347220ULL, 0x080fe20000410000ULL,
0x0000001c35357220ULL, 0x080fe20000410000ULL, 0x0000001c38387220ULL, 0x080fe20000410000ULL,
0x0000001c39397220ULL, 0x080fe20000410000ULL, 0x0000001c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001c40407220ULL, 0x080fe20000410000ULL,
0x0000001c41417220ULL, 0x080fe20000410000ULL, 0x0000001c24247220ULL, 0x080fe20000410000ULL,
0x0000001c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001e7811ULL, 0x002fe200078ff0ffULL, 0x0000b8527f007947ULL, 0x000fea000b800000ULL,
0x00001f1e4b1c7589ULL, 0x0002a400000e0000ULL, 0x0000001c2a2a7220ULL, 0x084fe20000410000ULL,
0x0000001c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001c32327220ULL, 0x080fe20000410000ULL,
0x0000001c33337220ULL, 0x080fe20000410000ULL, 0x0000001c36367220ULL, 0x080fe20000410000ULL,
0x0000001c37377220ULL, 0x080fe20000410000ULL, 0x0000001c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001c42427220ULL, 0x080fe20000410000ULL,
0x0000001c43437220ULL, 0x080fe20000410000ULL, 0x0000001c26267220ULL, 0x080fe20000410000ULL,
0x0000001c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff22ff7812ULL, 0x000fe20007800821ULL, 0x00000001ff487424ULL, 0x000fe200078e00ffULL,
0x0000001d5e577209ULL, 0x000fd60007810000ULL, 0x800000571d1d0221ULL, 0x000fe20000010000ULL,
0x00007610ff480816ULL, 0x000fc60000000048ULL, 0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL,
0x0000001d00150308ULL, 0x000e640000000800ULL, 0x0000001520200220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000620067221ULL, 0x008fc20000010000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x00f6ac00561e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00561e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910481c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000015ff16723eULL, 0x000fe400000010ffULL,
0x00000002ff1d7819ULL, 0x000fe40000011600ULL, 0x00005410161c7816ULL, 0x000fe20000000016ULL,
0x0000b4327f007947ULL, 0x000fea000b800000ULL, 0x00001f1d1c177589ULL, 0x0002a400000e0000ULL,
0x000000081d1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000b4627f007947ULL, 0x000fea000b800000ULL,
0x00001f1e1c167589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101d1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200078e001cULL,
0x00008e2000497802ULL, 0x000fc40000000f00ULL, 0x0000bae000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181d1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x004fe200078e001cULL, 0x00008e7000497802ULL, 0x000fc40000000f00ULL,
0x0000ba9000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000010000a1c7824ULL, 0x00afe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000015a597824ULL, 0x000fc600078e0259ULL, 0x000010001c1d7812ULL, 0x000fe200078ec0ffULL,
0x000000085a1c7824ULL, 0x000fc800078e00ffULL, 0x000020001a1d7824ULL, 0x000fe200078e021dULL,
0xfffffff81c1c7812ULL, 0x000fc800078ee259ULL, 0x0000b0001d597810ULL, 0x000fca0007ffe0ffULL,
0x000000101c1c7824ULL, 0x100fe400078e0259ULL, 0x0000001047497824ULL, 0x100fe200078e0259ULL,
0x0000991048477816ULL, 0x000fe200000000ffULL, 0x0000001050207824ULL, 0x100fe400078e0259ULL,
0x00000010464c7824ULL, 0x000fe200078e0259ULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x000000ff4700720cULL, 0x000fc60003f05270ULL, 0x000000004948783bULL, 0x000ee80000004200ULL,
0x000000002020783bULL, 0x004ea80000004200ULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x000000ff1d607812ULL, 0x002fe400078ec0ffULL, 0x00000010ff827819ULL, 0x000fc4000001161eULL,
0x000000ff486a7812ULL, 0x008fe400078ec0ffULL, 0x000000ff1e797812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001161eULL, 0x0000ffff1e887812ULL, 0x000fe400078ec0ffULL,
0x000000ff496b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fc4000001161cULL,
0x00000010ff6c7819ULL, 0x104fe40000011623ULL, 0x000000ff23767812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011623ULL, 0x0000ffff23737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6d7819ULL, 0x100fe40000011648ULL, 0x00000018ff717819ULL, 0x000fc40000011648ULL,
0x0000ffff481e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x100fe40000011620ULL,
0x000000ff20807812ULL, 0x040fe400078ec0ffULL, 0x00000018ff477819ULL, 0x000fe40000011620ULL,
0x0000ffff207b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x000fc40000011622ULL,
0x000000ff22757812ULL, 0x040fe400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe40000011622ULL,
0x0000ffff22747812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x100fe4000001164bULL,
0x000000ff4b637812ULL, 0x000fe400078ec0ffULL, 0x00000018ff237819ULL, 0x000fc4000001164bULL,
0x0000ffff4b487812ULL, 0x000fe400078ec0ffULL, 0x00000060ff87723eULL, 0x000fe400020006ffULL,
0x00000010ff4b7819ULL, 0x100fe4000001164fULL, 0x000000ff4f227812ULL, 0x040fe200078ec0ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000018ff207819ULL, 0x000fe4000001164fULL,
0x0000ffff4f607812ULL, 0x000fc400078ec0ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000006bff4f723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x2000006aff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff1c5a7812ULL, 0x000fe200078ec0ffULL,
0x2000004fff6a7230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x20000046ff837230ULL, 0x000fe20000004100ULL, 0x000000ff1f7f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff507819ULL, 0x100fe4000001161dULL, 0x00000018ff697819ULL, 0x000fe4000001161dULL,
0x0000ffff1d857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff897819ULL, 0x100fe4000001161fULL,
0x00000018ff7a7819ULL, 0x000fe4000001161fULL, 0x0000ffff1f787812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7c7819ULL, 0x100fe40000011621ULL, 0x000000ff218c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe40000011621ULL, 0x0000ffff21817812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1f7819ULL, 0x100fe40000011649ULL, 0x00000018ff5f7819ULL, 0x000fc40000011649ULL,
0x0000ffff491d7812ULL, 0x000fe400078ec0ffULL, 0x0000005aff86723eULL, 0x000fe400020006ffULL,
0x00000063ff4f723eULL, 0x000fe200020006ffULL, 0x20000023ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff497819ULL, 0x100fe2000001164cULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000000ff4c677812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000018ff5a7819ULL, 0x000fc4000001164cULL, 0x0000ffff4c6f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fe4000001164eULL, 0x0000007fff46723eULL, 0x000fe400020006ffULL,
0x00000010ff5e7819ULL, 0x000fe4000001161cULL, 0x00000080ff4c723eULL, 0x000fe400020006ffULL,
0x00000022ff23723eULL, 0x000fc400020006ffULL, 0x0000006eff7f723eULL, 0x000fe200020006ffULL,
0x20000046ff6e7230ULL, 0x000fe20000004100ULL, 0x00000021ff22723eULL, 0x000fe200020006ffULL,
0x2000004cff467230ULL, 0x000fe20000004100ULL, 0x000000ff5e217812ULL, 0x000fe200078ec0ffULL,
0x20000023ff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff4d8b7812ULL, 0x000fe200078ec0ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000071ff4c723eULL, 0x000fc400020006ffULL, 0x00000020ff23723eULL, 0x000fe200020006ffULL,
0x20000064ff717230ULL, 0x000fe20000004100ULL, 0x0000ffff1c667812ULL, 0x000fe200078ec0ffULL,
0x2000004cff647230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x000000ff50207812ULL, 0x000fe200078ec0ffULL, 0x20000023ff507230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000069ff847230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fc400020006ffULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000079ff697230ULL, 0x000fe20000004100ULL, 0x00000008ff667819ULL, 0x000fe40000011666ULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x0000005fff4c723eULL, 0x000fe400020006ffULL, 0x0000005aff5f723eULL, 0x000fe200020006ffULL,
0x2000008bff5a7230ULL, 0x000fe20000004100ULL, 0x00000047ff79723eULL, 0x000fe200020006ffULL,
0x2000008cff477230ULL, 0x000fe20000004100ULL, 0x00000066ff8b723eULL, 0x000fe200020006ffULL,
0x20000022ff667230ULL, 0x000fe20000004100ULL, 0x000000ff77777812ULL, 0x000fe200078ec0ffULL,
0x20000021ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff68687812ULL, 0x000fe200078ec0ffULL,
0x20000020ff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff857819ULL, 0x000fe20000011685ULL,
0x00a000001820783bULL, 0x000e620000000200ULL, 0x00000008ff887819ULL, 0x000fe20000011688ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fe20000011678ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000008ff737819ULL, 0x000fe40000011673ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000085ff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff8f7819ULL, 0x000fe20000011681ULL,
0x20000077ff817230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000068ff777230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000088ff857230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000078ff887230ULL, 0x000fe20000004100ULL, 0x00000073ff68723eULL, 0x000fe200020006ffULL,
0x2000006cff787230ULL, 0x000fe20000004100ULL, 0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL,
0x20000074ff737230ULL, 0x000fe20000004100ULL, 0x00000008ff1e7819ULL, 0x000fe2000001161eULL,
0x20000068ff747230ULL, 0x000fe20000004100ULL, 0x000000ff1f1f7812ULL, 0x000fc400078ec0ffULL,
0x0000006dff6c723eULL, 0x000fe400020006ffULL, 0x0000001eff68723eULL, 0x000fe400020006ffULL,
0x0000001fff6d723eULL, 0x000fe200020006ffULL, 0x0000001720208231ULL, 0x082fe200003400ffULL,
0x000000ff4a5b7812ULL, 0x000fe200078ec0ffULL, 0x0000001722228231ULL, 0x000fe200003400ffULL,
0x00000010ff1e7819ULL, 0x000fe20000011686ULL, 0x0000001621218231ULL, 0x080fe200003400ffULL,
0x00000010ff1f7819ULL, 0x000fe2000001168cULL, 0x0000001623238231ULL, 0x000fe200003400ffULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe2000001168eULL, 0x2000007aff807230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe2000001164aULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000072ff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff82827812ULL, 0x000fe200078ec0ffULL, 0x20000065ff727230ULL, 0x000fe20000004100ULL,
0x000010541f1e7816ULL, 0x000fe2000000001eULL, 0x2000005bff657230ULL, 0x000fe20000004100ULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x000010548e1f7816ULL, 0x000fc40000000087ULL,
0x00000018ff627819ULL, 0x000fe4000001164dULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff867819ULL, 0x000fe2000001161dULL, 0x0000001e2028723cULL, 0x000b620000041828ULL,
0x000000ff1c877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x00000010ff1c7819ULL, 0x000fe4000001168bULL,
0x00000010ff1d7819ULL, 0x000fe4000001168dULL, 0x000000ff4e8a7812ULL, 0x000fe400078ec0ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000062ff5b723eULL, 0x000fe200020006ffULL, 0x20000067ff627230ULL, 0x000fe20000004100ULL,
0x00001054831c7816ULL, 0x000fe2000000001cULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00001054841d7816ULL, 0x000fe2000000001dULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000008aff67723eULL, 0x000fe200020006ffULL, 0x20000082ff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x020fc40000011669ULL, 0x00000010ff837819ULL, 0x000fe2000001166eULL,
0x0000001c202c723cULL, 0x000b62000004182cULL, 0x00000010ff1f7819ULL, 0x000fe2000001168aULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe40000011689ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff1c7819ULL, 0x020fc40000011685ULL, 0x00000010ff1d7819ULL, 0x000fe40000011688ULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x000010541f1e7816ULL, 0x000fe4000000001eULL,
0x00001054841f7816ULL, 0x000fe40000000083ULL, 0x000010547f1c7816ULL, 0x000fe4000000001cULL,
0x00001054801d7816ULL, 0x000fc4000000001dULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x0000001e2030723cULL, 0x040f620000041830ULL, 0x00000008ff7b7819ULL, 0x000fe4000001167bULL,
0x00000008ff7f7819ULL, 0x000fe20000011648ULL, 0x2000007cff827230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000008fff7c723eULL, 0x000fe200020006ffULL,
0x0000001c2034723cULL, 0x000b620000041834ULL, 0x000000ff49807812ULL, 0x000fe200078ec0ffULL,
0x00a00000071c783bULL, 0x020e620000000200ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fc40000011647ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff487819ULL, 0x000fe4000001167bULL,
0x00000010ff497819ULL, 0x000fc4000001167cULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x0000105481467816ULL, 0x000fe20000000046ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000105482477816ULL, 0x000fe20000000047ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000105479487816ULL, 0x000fe40000000048ULL,
0x000010547a497816ULL, 0x000fc40000000049ULL, 0x00000010ff777819ULL, 0x000fe20000011677ULL,
0x000000462038723cULL, 0x040b620000041838ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff467819ULL, 0x020fe20000011675ULL, 0x00000048203c723cULL, 0x000b62000004183cULL,
0x00000010ff477819ULL, 0x000fe20000011676ULL, 0x000000171c1c8231ULL, 0x082fe200003400ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x000000171e1e8231ULL, 0x000fe200003400ffULL,
0x0000105477467816ULL, 0x000fe20000000046ULL, 0x000000161d1d8231ULL, 0x080fe200003400ffULL,
0x00000010ff487819ULL, 0x020fe20000011673ULL, 0x20000086ff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff497819ULL, 0x000fe20000011674ULL, 0x000000161f1f8231ULL, 0x000fe200003400ffULL,
0x0000105478477816ULL, 0x000fc40000000047ULL, 0x0000105471487816ULL, 0x000fe40000000048ULL,
0x0000105472497816ULL, 0x000fe40000000049ULL, 0x0000ffff4a7e7812ULL, 0x000fe200078ec0ffULL,
0x000000462040723cULL, 0x000b620000041840ULL, 0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000008ff7e7819ULL, 0x000fc4000001167eULL,
0x0000007dff83723eULL, 0x000fe200020006ffULL, 0x000000482024723cULL, 0x000b620000041824ULL,
0x00000018ff617819ULL, 0x000fe2000001164aULL, 0x20000087ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x020fe4000001166bULL, 0x00000010ff477819ULL, 0x000fe4000001166cULL,
0x00000010ff217819ULL, 0x000fe40000011664ULL, 0x00000010ff207819ULL, 0x000fc40000011668ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166aULL, 0x00000010ff6c7819ULL, 0x000fe4000001166dULL,
0x00000010ff237819ULL, 0x000fe4000001164cULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x0000007eff7d723eULL, 0x000fe200020006ffULL, 0x20000083ff7e7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x0000105447467816ULL, 0x000fe20000000046ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000105421207816ULL, 0x000fe20000000020ULL,
0x2000007fff767230ULL, 0x000fe20000004100ULL, 0x000010546c477816ULL, 0x000fe4000000006bULL,
0x0000105423217816ULL, 0x000fe4000000006eULL, 0x00000010ff707819ULL, 0x000fc4000001164dULL,
0x00000010ff4a7819ULL, 0x000fe2000001164eULL, 0x000000461c28723cULL, 0x040b620000041828ULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4e4e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff227819ULL, 0x000fe40000011665ULL, 0x00000010ff237819ULL, 0x000fe2000001164fULL,
0x000000201c2c723cULL, 0x000b62000004182cULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b4b7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x0000105469227816ULL, 0x000fe40000000022ULL, 0x000010547e237816ULL, 0x000fe40000000023ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff467819ULL, 0x020fc40000011663ULL,
0x00000010ff207819ULL, 0x000fe2000001167dULL, 0x000000221c30723cULL, 0x000b620000041830ULL,
0x00000010ff217819ULL, 0x000fe40000011676ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000080ff757230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x2000006fff6a7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000004bff227230ULL, 0x020fe20000004100ULL, 0x0000105461207816ULL, 0x000fe20000000020ULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000105446217816ULL, 0x000fe20000000021ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x000000201c34723cULL, 0x000b620000041834ULL, 0x00000010ff637819ULL, 0x000fe40000011670ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff207819ULL, 0x020fc4000001165bULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff4b7819ULL, 0x000fe4000001165eULL, 0x00000010ff227819ULL, 0x000fe40000011622ULL,
0x00000010ff217819ULL, 0x000fc40000011666ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff4f7819ULL, 0x000fe40000011660ULL,
0x0000105475627816ULL, 0x000fe40000000062ULL, 0x0000105463637816ULL, 0x000fe4000000005aULL,
0x000010545f6a7816ULL, 0x000fc4000000006aULL, 0x00001054206b7816ULL, 0x000fe4000000004dULL,
0x000010544a4a7816ULL, 0x000fe20000000067ULL, 0x000000621c38723cULL, 0x000f620000041838ULL,
0x00001054224b7816ULL, 0x000fe4000000004bULL, 0x00001054214e7816ULL, 0x000fe4000000004eULL,
0x00001054504f7816ULL, 0x000fc6000000004fULL, 0x0000006a1c3c723cULL, 0x040f70000004183cULL,
0x0000004a1c40723cULL, 0x040f700000041840ULL, 0x0000004e1c24723cULL, 0x000b6e0000041824ULL,
0x0000f6c81a1c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000001c1c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c0091c7811ULL, 0x002fe200078e40ffULL, 0x00f6980058ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff207224ULL, 0x000fe200078e001dULL, 0x000000030b607810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e000dULL, 0x0000001b1c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff5e7224ULL, 0x000fc400078e0057ULL, 0x000000ffff5b7224ULL, 0x000fd400078e005dULL,
0x00002eb000000947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x002fc40000015200ULL,
0x000004000c0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c1e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09001e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001141fULL,
0x0000001e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff1e7224ULL, 0x000fca00000e061fULL,
0x000000020d0d7819ULL, 0x000fc8000000121eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000121217810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000c0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002090d7810ULL, 0x040fe20007ffe0ffULL, 0x00000100090c7824ULL, 0x000fe400078e0204ULL,
0x0000580005057a24ULL, 0x010fe200078e02ffULL, 0x000000440d00720cULL, 0x000fe40003f06070ULL,
0x000001000c1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000004005467824ULL, 0x000fc600078e00ffULL,
0x0000002003237812ULL, 0x000fce00078ef81cULL, 0x0000048000008947ULL, 0x000fea0003800000ULL,
0x0000001045057824ULL, 0x000fe200078e00ffULL, 0x00000003ff477819ULL, 0x000fc80000011600ULL,
0x0000001005227812ULL, 0x000fe400078ec0ffULL, 0x0000001c1b057217ULL, 0x000fe40007800000ULL,
0x0000000447497810ULL, 0x040fe20007ffe0ffULL, 0x00000001471f7824ULL, 0x000fe400078e0222ULL,
0x0000000105057824ULL, 0x000fe400078e0a1cULL, 0x000000011f0c7824ULL, 0x000fe400078e0223ULL,
0x00000010001c7824ULL, 0x000fe200078e00ffULL, 0x0000000522057217ULL, 0x000fe20007800000ULL,
0x00000001494a7824ULL, 0x000fe200078e0222ULL, 0x0000000c460c7210ULL, 0x000fe20007f1e0ffULL,
0x000000011f217824ULL, 0x000fc400078e0200ULL, 0x0000000105057824ULL, 0x000fe400078e0a22ULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e000c1d7a11ULL, 0x000fe200078038ffULL,
0x000000081f487824ULL, 0x000fe400078e00ffULL, 0x000000084a4d7824ULL, 0x000fe200078e00ffULL,
0x00005f000c1e7a11ULL, 0x000fe200000f3c0dULL, 0x000000014a0d7824ULL, 0x000fe200078e0223ULL,
0x000000701c0c7812ULL, 0x000fe400078ec0ffULL, 0x000000054700720cULL, 0x000fc40003f06070ULL,
0x0000000c1d1c7210ULL, 0x080fe40007fbe0ffULL, 0x0000000d46207210ULL, 0x000fe40007fde0ffULL,
0xfffffff848487812ULL, 0x000fe200078ee221ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061eULL,
0x000000054900720cULL, 0x000fe20003fa6070ULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x0000000847497810ULL, 0x040fe20007ffe0ffULL, 0x00000010480d7824ULL, 0x000fe200078e0259ULL,
0x00005e0020217a11ULL, 0x000fe200078c38ffULL, 0x000000014a487824ULL, 0x000fe200078e0200ULL,
0x0000000c47477810ULL, 0x000fe20007ffe0ffULL, 0x00000001494b7824ULL, 0x000fe200078e0222ULL,
0x00005f0020207a11ULL, 0x000fe200030f3c1fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c0d7faeULL, 0x0003e2000c101c46ULL, 0x0000000c211e7210ULL, 0x000fe20007f1e0ffULL,
0x000000014b1f7824ULL, 0x000fe200078e0223ULL, 0xfffffff84d487812ULL, 0x000fe200078ee248ULL,
0x00000001474a7824ULL, 0x000fc600078e0222ULL, 0x0000001f46227210ULL, 0x000fe20007fde0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0620ULL, 0x000000054900720cULL, 0x080fe20003f06070ULL,
0x00000010480d7824ULL, 0x002fe400078e0259ULL, 0x000000014a1c7824ULL, 0x000fe400078e0223ULL,
0x000000ffff217224ULL, 0x000fe200030e06ffULL, 0x000000001e0d7faeULL, 0x0003e2000e901c46ULL,
0x00005e00221d7a11ULL, 0x000fe200078a38ffULL, 0x000000014a237824ULL, 0x100fe200078e0200ULL,
0x0000001c46207210ULL, 0x000fe20007fde0ffULL, 0x000000084b467824ULL, 0x000fe200078e00ffULL,
0x00005f0022227a11ULL, 0x000fe200028f3c21ULL, 0x000000084a4a7824ULL, 0x000fe200078e00ffULL,
0x000000054700720cULL, 0x000fe20003fa6070ULL, 0x000000ffff217224ULL, 0x000fe200030e06ffULL,
0x0000000c1d1c7210ULL, 0x000fe20007fde0ffULL, 0x000000014b057824ULL, 0x000fc800078e0200ULL,
0x000000ffff1d7224ULL, 0x000fe200030e0622ULL, 0x00005e00201f7a11ULL, 0x002fe400078c38ffULL,
0xfffffff846227812ULL, 0x000fe400078ee205ULL, 0x00005f00200d7a11ULL, 0x000fe400030f3c21ULL,
0x0000000c1f1e7210ULL, 0x000fe20007fde0ffULL, 0x0000001022057824ULL, 0x000fe200078e0259ULL,
0xfffffff84a207812ULL, 0x000fc600078ee223ULL, 0x000000ffff1f7224ULL, 0x000fe200030e060dULL,
0x000000001c057faeULL, 0x0003e2000c101c46ULL, 0x0000001020597824ULL, 0x000fca00078e0259ULL,
0x000000001e597faeULL, 0x0003e2000e901c46ULL, 0x000003b000007947ULL, 0x000fea0003800000ULL,
0x0000001045057824ULL, 0x000fca00078e00ffULL, 0x0000001005057812ULL, 0x000fc800078ec0ffULL,
0x00000005000c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c1e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010c057824ULL, 0x040fe200078e0223ULL, 0x000000080c1f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x140fe200078e0200ULL, 0x0000000c0c217810ULL, 0x040fe20007ffe0ffULL,
0x000000080c1c7824ULL, 0x000fe200078e00ffULL, 0x0000000546207210ULL, 0x000fe20007f1e0ffULL,
0x000000011e1d7824ULL, 0x040fe400078e0200ULL, 0x000000081e4a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0d7224ULL, 0x000fc400000e06ffULL,
0x000000011e057824ULL, 0x000fe200078e0223ULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee21dULL,
0x000000011f0c7824ULL, 0x040fe200078e0223ULL, 0x00005e00201d7a11ULL, 0x040fe200078038ffULL,
0x000000011f1e7824ULL, 0x000fe400078e0200ULL, 0x0000000821477824ULL, 0x040fe200078e00ffULL,
0x00005f0020207a11ULL, 0x000fe400000f3c0dULL, 0x0000000546227210ULL, 0x040fe20007f1e0ffULL,
0x0000000121057824ULL, 0x000fe200078e0223ULL, 0x0000000c46487210ULL, 0x000fe20007fbe0ffULL,
0x000000081f237824ULL, 0x000fc400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e00221f7a11ULL, 0x000fe200078038ffULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x0000000546057210ULL, 0x000fe40007fde0ffULL, 0x00005f0022227a11ULL, 0x000fe200000f3c0dULL,
0x000000ffff0d7224ULL, 0x000fe200028e06ffULL, 0xfffffff8234c7812ULL, 0x000fe200078ee21eULL,
0x000000ffff467224ULL, 0x000fe200030e06ffULL, 0x00005e0005237a11ULL, 0x000fe200078a38ffULL,
0x00000001211e7824ULL, 0x000fe200078e0200ULL, 0x00005e0048217a11ULL, 0x000fc400078038ffULL,
0x000000700c0c7812ULL, 0x000fe400078ec0ffULL, 0x00005f0005467a11ULL, 0x000fe200028f3c46ULL,
0x000000101c057824ULL, 0x000fe200078e0259ULL, 0x00005f0048487a11ULL, 0x000fe200000f3c0dULL,
0x000000104a0d7824ULL, 0x100fe200078e0259ULL, 0xfffffff8474e7812ULL, 0x000fe200078ee21eULL,
0x000000104c477824ULL, 0x100fe200078e0259ULL, 0x0000000c1d1c7210ULL, 0x080fe40007f1e0ffULL,
0x0000000c1f1e7210ULL, 0x000fe20007fbe0ffULL, 0x000000104e597824ULL, 0x000fc400078e0259ULL,
0x000000ffff1d7224ULL, 0x000fe200000e0620ULL, 0x0000000c21207210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e0622ULL, 0x0000000c23227210ULL, 0x000fe40007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c057faeULL, 0x0003e2000b901c46ULL,
0x000000ffff217224ULL, 0x000fe400000e0648ULL, 0x000000ffff237224ULL, 0x000fe200028e0646ULL,
0x000000001e0d7faeULL, 0x0003e8000b901c46ULL, 0x0000000020477faeULL, 0x0003e8000b901c46ULL,
0x0000000022597faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000040b1c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff057424ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x000000191c00720cULL, 0x000fda0003fa6070ULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x00000001081c7824ULL, 0x000fe400078e021cULL,
0x00000004ff1d7424ULL, 0x000fc800078e00ffULL, 0x000060001c1c7625ULL, 0x000fca00078e001dULL,
0x000000061c057981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000550403c2ULL, 0x000ea40000080000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000270f070ULL, 0xffffff8000004947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800565a7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f668000f207f8cULL, 0x0002a4000c80043fULL,
0x00000000001c7805ULL, 0x002fc40000015200ULL, 0x00f66c000f0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x006fe40007804821ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c1e7210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09001e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc8000001141fULL, 0x0000001e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff1e7224ULL, 0x000fca00000e061fULL, 0x000000020d0d7819ULL, 0x000fc8000000121eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c000f0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001800c107810ULL, 0x000fca0007ffe010ULL,
0x0000000111107824ULL, 0x000fca00078e0210ULL, 0x00f00000101c7984ULL, 0x000e680000000800ULL,
0x00f20000100d7984ULL, 0x0004e20000000800ULL, 0x000000571c00720bULL, 0x002fe20003f1d000ULL,
0x00008ca27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0fff7812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff5e7224ULL, 0x000fd200078e0057ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x0000000302107810ULL, 0x000fe40007ffe0ffULL,
0x000000571c00720bULL, 0x000fe40003f14000ULL, 0x000000451000720cULL, 0x000fe20003fa5270ULL,
0x00008c527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000107806ULL, 0x000fc400000e0100ULL,
0x00000080450cd824ULL, 0x000fe200078e020cULL, 0x000000571c5e7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x000000011111d824ULL, 0x000fe200078e020cULL,
0x00009910100c7816ULL, 0x000fc800000000ffULL, 0x00f4005e1100d388ULL, 0x0003e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x000000575e0c7221ULL, 0x002fe20000010100ULL, 0x000000ff10ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00117308ULL, 0x000e640000000800ULL, 0x0000001106067220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x00008b827f007947ULL, 0x000fea000b800000ULL, 0x00001f1e110c7589ULL, 0x0002a400000e0000ULL,
0x0000000c28287220ULL, 0x084fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c38387220ULL, 0x080fe20000410000ULL, 0x0000000c39397220ULL, 0x080fe20000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000c40407220ULL, 0x080fe20000410000ULL, 0x0000000c41417220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x002fe200078ff0ffULL,
0x00008a727f007947ULL, 0x000fea000b800000ULL, 0x00001f1e110c7589ULL, 0x0002a400000e0000ULL,
0x0000000c2a2a7220ULL, 0x084fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c42427220ULL, 0x080fe20000410000ULL, 0x0000000c43437220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff10ff7812ULL, 0x000fe2000780080fULL,
0x00000001ff1d7424ULL, 0x000fd800078e00ffULL, 0x0000001c5e1c0221ULL, 0x000fe20000010100ULL,
0x00007610ff1d0816ULL, 0x000fc6000000001dULL, 0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL,
0x0000001c00150308ULL, 0x000e640000000800ULL, 0x000000150d0d0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000060d067221ULL, 0x008fc40000010000ULL,
0x00000000000c7805ULL, 0x000fca0000015200ULL, 0x00f6ac000e0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100c107210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0dULL,
0x003d09001000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011411ULL, 0x000000100f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff107224ULL, 0x000fca00000e0611ULL, 0x000000020f0f7819ULL, 0x000fc80000001210ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac000e0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101d0c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000015ff0c723eULL, 0x000fe400000010ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011600ULL, 0x000054100c0c7816ULL, 0x000fe2000000000cULL,
0x000086627f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0c177589ULL, 0x0002a400000e0000ULL,
0x000000080d1e7810ULL, 0x000fe20007ffe0ffULL, 0x000086927f007947ULL, 0x000fea000b800000ULL,
0x00001f1e0c167589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100d1e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200078e000cULL,
0x0000bde000497802ULL, 0x000fc40000000f00ULL, 0x00008b2000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180d1e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x004fe200078e000cULL, 0x0000be3000497802ULL, 0x000fc40000000f00ULL,
0x00008ad000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005454783bULL, 0x000ee80000004200ULL,
0x00000000531c783bULL, 0x008ee80000004200ULL, 0x000000005210783bULL, 0x000ea80000004200ULL,
0x00000000510c783bULL, 0x002e620000004200ULL, 0x00000018ff147819ULL, 0x000fc40000011654ULL,
0x000000ff54207812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x100fe40000011656ULL,
0x000000ff56487812ULL, 0x040fe400078ec0ffULL, 0x00000018ff477819ULL, 0x000fe40000011656ULL,
0x0000ffff56767812ULL, 0x000fe400078ec0ffULL, 0x000000ff55217812ULL, 0x000fc400078ec0ffULL,
0x00000018ff567819ULL, 0x008fe4000001161dULL, 0x00000010ff4f7819ULL, 0x100fe40000011655ULL,
0x00000018ff227819ULL, 0x000fe40000011655ULL, 0x0000ffff55787812ULL, 0x000fe400078ec0ffULL,
0x000000ff1f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6a7819ULL, 0x004fc40000011610ULL,
0x000000ff107c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fe40000011610ULL,
0x0000ffff10637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff657819ULL, 0x100fe40000011613ULL,
0x000000ff13807812ULL, 0x000fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fc40000011613ULL,
0x0000ffff135c7812ULL, 0x000fe400078ec0ffULL, 0x00000014ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff507819ULL, 0x000fe40000011654ULL, 0x0000ffff54797812ULL, 0x000fe200078ec0ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe4000001161eULL,
0x000000ff1e597812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001161eULL,
0x0000ffff1e6e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff107819ULL, 0x100fe40000011612ULL,
0x000000ff127f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff237819ULL, 0x000fe40000011612ULL,
0x0000ffff12667812ULL, 0x000fc400078ec0ffULL, 0x00000020ff13723eULL, 0x000fe400020006ffULL,
0x00000010ff557819ULL, 0x102fe4000001160dULL, 0x000000ff0d4d7812ULL, 0x040fe200078ec0ffULL,
0x20000013ff137230ULL, 0x000fe20000004100ULL, 0x00000018ff4b7819ULL, 0x000fe4000001160dULL,
0x0000ffff0d147812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fc4000001161fULL,
0x00000018ff7a7819ULL, 0x000fe4000001161fULL, 0x0000ffff1f6b7812ULL, 0x000fe400078ec0ffULL,
0x00000021ff12723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x100fe4000001160cULL,
0x000000ff0c497812ULL, 0x000fe200078ec0ffULL, 0x20000012ff127230ULL, 0x000fe20000004100ULL,
0x00000018ff4a7819ULL, 0x000fc4000001160cULL, 0x0000ffff0c547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1e7819ULL, 0x100fe4000001160eULL, 0x000000ff0e4c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff0d7819ULL, 0x000fe4000001160eULL, 0x0000ffff0e207812ULL, 0x000fe400078ec0ffULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x00000010ff1f7819ULL, 0x100fe4000001160fULL,
0x000000ff0f0e7812ULL, 0x040fe200078ec0ffULL, 0x20000056ff607230ULL, 0x000fe20000004100ULL,
0x00000018ff0c7819ULL, 0x000fe4000001160fULL, 0x0000ffff0f217812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011657ULL, 0x0000005fff0f723eULL, 0x000fc400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000005aff56723eULL, 0x000fe200020006ffULL,
0x2000000fff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff57517812ULL, 0x000fe200078ec0ffULL,
0x2000004eff687230ULL, 0x000fe20000004100ULL, 0x00000046ff0f723eULL, 0x000fe200020006ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000049ff4e723eULL, 0x000fe200020006ffULL, 0x2000000fff497230ULL, 0x000fe20000004100ULL,
0x0000004aff0f723eULL, 0x000fe200020006ffULL, 0x20000051ff697230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x2000004eff4a7230ULL, 0x000fe20000004100ULL,
0x0000004bff51723eULL, 0x000fc400020006ffULL, 0x0000004cff4e723eULL, 0x000fe200020006ffULL,
0x2000000fff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe20000011657ULL,
0x2000004dff4b7230ULL, 0x000fe20000004100ULL, 0x0000ffff576d7812ULL, 0x000fe200078ec0ffULL,
0x20000051ff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff1d577812ULL, 0x000fe200078ec0ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000000eff0f723eULL, 0x000fe400020006ffULL,
0x0000000dff0e723eULL, 0x000fc400020006ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f0d7812ULL, 0x000fe200078ec0ffULL, 0x2000000fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe4000001161dULL, 0x0000ffff1d747812ULL, 0x000fe400078ec0ffULL,
0x00000057ff1d723eULL, 0x000fe400020006ffULL, 0x0000000cff51723eULL, 0x000fc400020006ffULL,
0x0000007aff57723eULL, 0x000fe200020006ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x00000050ff0c723eULL, 0x000fe200020006ffULL, 0x2000000eff507230ULL, 0x000fe20000004100ULL,
0x0000000dff7a723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000008ff0d7819ULL, 0x000fe20000011679ULL, 0x2000000cff797230ULL, 0x000fe20000004100ULL,
0x000000ff75757812ULL, 0x000fe200078ec0ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000022ff22723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x0000000dff0d723eULL, 0x000fc400020006ffULL, 0x00000008ff767819ULL, 0x000fe20000011676ULL,
0x20000022ff6f7230ULL, 0x000fe20000004100ULL, 0x00000075ff0c723eULL, 0x000fe400020006ffULL,
0x0000007bff22723eULL, 0x000fe200020006ffULL, 0x2000000dff7b7230ULL, 0x000fe20000004100ULL,
0x00000076ff75723eULL, 0x000fe200020006ffULL, 0x2000000cff767230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fe20000011674ULL, 0x00a80000180c783bULL, 0x0002a20000000200ULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000022ff227230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000008ff787819ULL, 0x000fe40000011678ULL,
0x00000008ff187819ULL, 0x002fe2000001166eULL, 0x20000074ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fe2000001166bULL, 0x20000062ff6b7230ULL, 0x000fe20000004100ULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x20000018ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff187819ULL, 0x000fe20000011663ULL, 0x20000074ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011612ULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff137819ULL, 0x000fc40000011613ULL, 0x00000010ff127819ULL, 0x000fe40000011679ULL,
0x00000010ff617819ULL, 0x100fe40000011611ULL, 0x000000ff117e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011611ULL, 0x00000010ff797819ULL, 0x000fe4000001167aULL,
0x0000ffff11117812ULL, 0x000fc400078ec0ffULL, 0x0000105412127816ULL, 0x000fe40000000013ULL,
0x0000105479137816ULL, 0x000fe20000000074ULL, 0x000000170c0c8231ULL, 0x084fe200003400ffULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x000000170e0e8231ULL, 0x000fe200003400ffULL,
0x000000ff77777812ULL, 0x000fe200078ec0ffULL, 0x000000160d0d8231ULL, 0x080fe200003400ffULL,
0x00000008ff6d7819ULL, 0x000fe2000001166dULL, 0x20000048ff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fe20000011611ULL, 0x000000160f0f8231ULL, 0x000fe200003400ffULL,
0x000000ff10797812ULL, 0x000fc400078ec0ffULL, 0x00000010ff117819ULL, 0x000fe40000011672ULL,
0x00000010ff107819ULL, 0x000fe4000001167bULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x000000120c28723cULL, 0x000be20000041828ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x20000047ff677230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x0000105411107816ULL, 0x000fe40000000010ULL,
0x00000023ff48723eULL, 0x000fe200020006ffULL, 0x2000007dff237230ULL, 0x000fe20000004100ULL,
0x000010546f117816ULL, 0x000fc40000000078ULL, 0x00000073ff7d723eULL, 0x000fe200020006ffULL,
0x2000006dff737230ULL, 0x000fe20000004100ULL, 0x00000018ff527819ULL, 0x000fe2000001161cULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000010ff127819ULL, 0x020fe2000001166cULL,
0x000000100c2c723cULL, 0x000b62000004182cULL, 0x00000010ff137819ULL, 0x000fe40000011669ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff767819ULL, 0x000fc40000011676ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff107819ULL, 0x020fe40000011675ULL, 0x00000010ff117819ULL, 0x000fe40000011673ULL,
0x00000010ff707819ULL, 0x000fe4000001161cULL, 0x0000ffff1c717812ULL, 0x000fc400078ec0ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x0000105477127816ULL, 0x000fe40000000012ULL,
0x0000105476137816ULL, 0x000fe20000000013ULL, 0x20000052ff5f7230ULL, 0x000fe20000004100ULL,
0x0000105467107816ULL, 0x000fe40000000010ULL, 0x0000105468117816ULL, 0x000fe40000000011ULL,
0x000000ff70707812ULL, 0x000fe200078ec0ffULL, 0x000000120c30723cULL, 0x000fe20000041830ULL,
0x000000ff1c537812ULL, 0x000fc400078ec0ffULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000053ff1c723eULL, 0x000fe200020006ffULL,
0x000000100c34723cULL, 0x000be20000041834ULL, 0x0000007cff52723eULL, 0x000fe200020006ffULL,
0x00a800000710783bULL, 0x020e620000000200ULL, 0x00000071ff7c723eULL, 0x000fe200020006ffULL,
0x20000070ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x000fe2000001161dULL,
0x2000001cff1c7230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe2000001165cULL,
0x2000007dff707230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x2000007cff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe2000001161cULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fc40000011670ULL,
0x000000ff5d687812ULL, 0x000fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff5c7819ULL, 0x000fe4000001166dULL, 0x00000010ff5d7819ULL, 0x000fc4000001166eULL,
0x00001054711c7816ULL, 0x000fe4000000001cULL, 0x00001054701d7816ULL, 0x000fe4000000001dULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x000010545f5c7816ULL, 0x000fe2000000005cULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00001054605d7816ULL, 0x000fe2000000005dULL, 0x0000001c0c38723cULL, 0x040be20000041838ULL,
0x000000ff6a7c7812ULL, 0x000fe200078ec0ffULL, 0x20000064ff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x0000001710108231ULL, 0x082fe200003400ffULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x0000001712128231ULL, 0x000fe200003400ffULL,
0x00000010ff1d7819ULL, 0x020fe2000001165aULL, 0x0000005c0c3c723cULL, 0x000b62000004183cULL,
0x00000008ff5a7819ULL, 0x000fe20000011654ULL, 0x0000001611118231ULL, 0x080fe200003400ffULL,
0x00000010ff547819ULL, 0x000fe20000011662ULL, 0x0000001613138231ULL, 0x000fe200003400ffULL,
0x00000010ff1c7819ULL, 0x000fc40000011659ULL, 0x000000ff555c7812ULL, 0x020fe400078ec0ffULL,
0x00000010ff557819ULL, 0x000fe40000011656ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff567819ULL, 0x000fe40000011657ULL, 0x00000018ff18723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x0000105455547816ULL, 0x000fe20000000054ULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x000010546b1c7816ULL, 0x000fe2000000001cULL,
0x20000074ff6c7230ULL, 0x000fe20000004100ULL, 0x000010546a1d7816ULL, 0x000fe4000000001dULL,
0x0000105456557816ULL, 0x000fe40000000063ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000010ff187819ULL, 0x000fe20000011618ULL, 0x0000001c0c40723cULL, 0x000f620000041840ULL,
0x00000008ff147819ULL, 0x000fe20000011614ULL, 0x20000068ff077230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fc40000011623ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x000000540c24723cULL, 0x000b620000041824ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x20000067ff597230ULL, 0x000fe20000004100ULL, 0x000000ff1e1e7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff0d7819ULL, 0x020fe20000011622ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x000010540d0c7816ULL, 0x000fe40000000018ULL, 0x00001054230d7816ULL, 0x000fe4000000006cULL,
0x00000010ff077819ULL, 0x000fe40000011607ULL, 0x000000ff65657812ULL, 0x000fe400078ec0ffULL,
0x0000001eff1e723eULL, 0x000fe200020006ffULL, 0x0000000c102c723cULL, 0x000b62000004182cULL,
0x000000ff61647812ULL, 0x000fc400078ec0ffULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x000000ff1f1f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff207819ULL, 0x000fe40000011620ULL, 0x00000010ff0c7819ULL, 0x020fe40000011649ULL,
0x00000008ff217819ULL, 0x000fe40000011621ULL, 0x00000010ff497819ULL, 0x000fc40000011659ULL,
0x00001054074a7816ULL, 0x000fe4000000004aULL, 0x00000010ff077819ULL, 0x000fe4000001164cULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff0e7819ULL, 0x000fe4000001164dULL,
0x00000010ff0d7819ULL, 0x000fe40000011614ULL, 0x00000065ff6f723eULL, 0x000fc400020006ffULL,
0x0000007eff53723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000080ff47723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x2000007fff467230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x2000007cff617230ULL, 0x000fe20000004100ULL,
0x00000066ff65723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000079ff697230ULL, 0x000fe20000004100ULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x2000006fff667230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x000010540c497816ULL, 0x000fe20000000049ULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x00001054070c7816ULL, 0x000fe2000000005aULL, 0x20000020ff207230ULL, 0x000fe20000004100ULL,
0x000010540e0d7816ULL, 0x000fe2000000000dULL, 0x20000021ff217230ULL, 0x000fe20000004100ULL,
0x00000010ff4e7819ULL, 0x000fc4000001164eULL, 0x00000010ff077819ULL, 0x000fe4000001161eULL,
0x00000010ff1c7819ULL, 0x000fe20000011652ULL, 0x0000000c103c723cULL, 0x000b62000004183cULL,
0x00001054074e7816ULL, 0x000fe4000000004eULL, 0x00000010ff1d7819ULL, 0x000fe40000011653ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff0e7819ULL, 0x000fe4000001161fULL,
0x00000010ff077819ULL, 0x000fe40000011650ULL, 0x00000010ff207819ULL, 0x000fc40000011620ULL,
0x00000010ff0c7819ULL, 0x020fe40000011651ULL, 0x00000010ff217819ULL, 0x000fe40000011621ULL,
0x00001054611c7816ULL, 0x000fe4000000001cULL, 0x00001054641d7816ULL, 0x000fe4000000001dULL,
0x0000105469467816ULL, 0x000fe40000000046ULL, 0x0000105466477816ULL, 0x000fc40000000047ULL,
0x0000105448487816ULL, 0x000fe20000000065ULL, 0x0000001c1028723cULL, 0x040b620000041828ULL,
0x000010545c4b7816ULL, 0x000fe4000000004bULL, 0x000010540e4f7816ULL, 0x000fe4000000004fULL,
0x0000105407207816ULL, 0x000fe40000000020ULL, 0x000010540c217816ULL, 0x000fe20000000021ULL,
0x000000461030723cULL, 0x000b620000041830ULL, 0x0000f6c81a0c7811ULL, 0x000fce00078e18ffULL,
0x000000481034723cULL, 0x040b700000041834ULL, 0x0000004a1038723cULL, 0x040b700000041838ULL,
0x0000004e1040723cULL, 0x040b700000041840ULL, 0x000000201024723cULL, 0x000b620000041824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000000c0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00058ff7f8cULL, 0x0005e2000c80043fULL, 0x000000040b607810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x022fe200078e000dULL, 0x000000010a1d7812ULL, 0x000fc400078ec0ffULL,
0x0000000109097810ULL, 0x002fc80007ffe0ffULL, 0x000000440900720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff3d3000007947ULL, 0x000fea000383ffffULL,
0x000000ff4400720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000d61000057802ULL, 0x010fc40000000f00ULL,
0x0000713000007944ULL, 0x006fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000600037308ULL, 0x000ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc80000000006ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000057919ULL, 0x010ea80000000000ULL, 0x0000000000087919ULL, 0x004ea20000000000ULL,
0x00000002ff077819ULL, 0x000fe40000011605ULL, 0x0000000808057811ULL, 0x004fe200078ff0ffULL,
0x0000000003067220ULL, 0x00afca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea200000e0000ULL, 0x0000002800287220ULL, 0x042fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x000fe20000410000ULL, 0x0000002a052a7220ULL, 0x044fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x000fc20000410000ULL, 0x0000000000037919ULL, 0x000ee80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000803077811ULL, 0x048fe200078ff0ffULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x0000000203007812ULL, 0x000fc400078ec0ffULL,
0x00000002ff097819ULL, 0x004fe20000011603ULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0x0000000700057211ULL, 0x050fe200078ff8ffULL, 0x0000100045077824ULL, 0x000fe200078e00ffULL,
0x0000000900027211ULL, 0x000fe200078ff8ffULL, 0x00000008090b7824ULL, 0x040fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee205ULL, 0x0000000809057824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008090e7824ULL, 0x000fe200078e00ffULL,
0x0000100007077812ULL, 0x000fc400078ee2ffULL, 0xfffffff80b087812ULL, 0x000fe400078ee200ULL,
0xfffffff805007812ULL, 0x000fe200078ee202ULL, 0x000008001a057824ULL, 0x100fe200078e0207ULL,
0x0000000402067810ULL, 0x000fe20007ffe0ffULL, 0x0000001004047824ULL, 0x000fe200078e0207ULL,
0x0000000602097810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0c7812ULL, 0x000fe200078ee206ULL, 0x0000001000067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x000000100a107824ULL, 0x100fe200078e0205ULL,
0x0000000802097812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x000000282900723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000010ffULL, 0x0000000106087824ULL, 0x000fe200078e0209ULL,
0x0000003c3d06723eULL, 0x000fe200000010ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x0000541000127816ULL, 0x040fe20000000002ULL, 0x0000000109107824ULL, 0x040fe200078e0210ULL,
0x0000763200137816ULL, 0x000fe20000000002ULL, 0x00000001090a7824ULL, 0x000fe200078e020aULL,
0x000000303100723eULL, 0x000fe200000010ffULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0x000000343502723eULL, 0x000fe200000010ffULL, 0x0000001208007388ULL, 0x0005e20000000a00ULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x000000383905723eULL, 0x000fc400000010ffULL,
0x0000763200097816ULL, 0x140fe40000000002ULL, 0x0000541000087816ULL, 0x004fe40000000002ULL,
0x000000404100723eULL, 0x000fe400000010ffULL, 0x000000242502723eULL, 0x000fe200000010ffULL,
0x000000080a007388ULL, 0x0005e40000000a00ULL, 0x0000541005087816ULL, 0x144fe40000000006ULL,
0x0000763205097816ULL, 0x000fc40000000006ULL, 0x0000002a2b05723eULL, 0x000fe400000010ffULL,
0x0000002e2f06723eULL, 0x000fe200000010ffULL, 0x000000080c007388ULL, 0x0005e40000000a00ULL,
0x0000541000087816ULL, 0x144fe40000000002ULL, 0x0000763200097816ULL, 0x000fe40000000002ULL,
0x000000323300723eULL, 0x000fe400000010ffULL, 0x000000363702723eULL, 0x000fe200000010ffULL,
0x000000080e007388ULL, 0x0005e40000000a00ULL, 0x0000541005087816ULL, 0x004fc40000000006ULL,
0x0000763205097816ULL, 0x000fe40000000006ULL, 0x0000003a3b05723eULL, 0x000fe400000010ffULL,
0x0000003e3f06723eULL, 0x000fe200000010ffULL, 0x0000000810007388ULL, 0x0005e60000000a00ULL,
0x0000541005147816ULL, 0x140fe40000000006ULL, 0x0000763205157816ULL, 0x000fc40000000006ULL,
0x000000ff00057306ULL, 0x000fe20000205400ULL, 0x0000541000087816ULL, 0x144fe40000000002ULL,
0x0000763200097816ULL, 0x000fe40000000002ULL, 0x000000424300723eULL, 0x000fe400000010ffULL,
0x000000262702723eULL, 0x000fe200000010ffULL, 0x000400080a007388ULL, 0x000fe60000000a00ULL,
0x00007632000d7816ULL, 0x140fe20000000002ULL, 0x000400140c007388ULL, 0x0005e40000000a00ULL,
0x00005410000c7816ULL, 0x004fc40000000002ULL, 0x000000ff00007306ULL, 0x000ea60000209400ULL,
0x0004000c0e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000004087984ULL, 0x000ee20000000c00ULL, 0x000000050000720bULL, 0x004fc60003f1d000ULL,
0x0004000004147984ULL, 0x000ea20000000c00ULL, 0x000000ff00007245ULL, 0x000fc6000020d400ULL,
0x0008000004107984ULL, 0x000e680000000c00ULL, 0x000c0000041c7984ULL, 0x000e640000000c00ULL,
0x0000000100000812ULL, 0x000fe400078efcffULL, 0x000000ff1a00720cULL, 0x000fe40003f05270ULL,
0x000000000005723eULL, 0x000fca00000010ffULL, 0x3f803f80050b7831ULL, 0x048fe4000020000bULL,
0x3f803f80050a7831ULL, 0x040fe4000020000aULL, 0x3f803f8005097831ULL, 0x040fe40000200009ULL,
0x3f803f8005087831ULL, 0x040fe40000200008ULL, 0x3f803f8005177831ULL, 0x044fe40000200017ULL,
0x3f803f8005167831ULL, 0x000fc40000200016ULL, 0x3f803f8005157831ULL, 0x040fe40000200015ULL,
0x3f803f8005147831ULL, 0x000fe40000200014ULL, 0x3f803f800b0b7831ULL, 0x002fe40000200013ULL,
0x3f803f800a0a7831ULL, 0x000fe40000200012ULL, 0x3f803f8009097831ULL, 0x000fe40000200011ULL,
0x3f803f8008087831ULL, 0x000fc40000200010ULL, 0x3f803f8017177831ULL, 0x000fe4000020001fULL,
0x3f803f8016167831ULL, 0x000fe2000020001eULL, 0x0000000804007388ULL, 0x000fe20000000c00ULL,
0x3f803f8015157831ULL, 0x000fe4000020001dULL, 0x3f803f8014147831ULL, 0x000fca000020001cULL,
0x0004001404007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000020030c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000047919ULL, 0x000e620000002600ULL, 0x00000003ff067819ULL, 0x100fe20000011603ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff057819ULL, 0x000fe2000001160cULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000145457812ULL, 0x000fe200078ec0ffULL,
0x0000000106007824ULL, 0x000fe200078e0203ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x000000010c027824ULL, 0x000fc400078e0205ULL, 0x00000008450e7824ULL, 0x000fe200078e00ffULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0000000702097812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800007812ULL, 0x100fe400078ef803ULL, 0x0ffffff809027812ULL, 0x000fe400078ef80cULL,
0xfffffff80e037812ULL, 0x000fe200078ee203ULL, 0x0000001000007824ULL, 0x000fc400078e0207ULL,
0x0000001002077824ULL, 0x000fe400078e0207ULL, 0x00000008040d7824ULL, 0x042fe200078e00ffULL,
0x0000000000087984ULL, 0x0002e20000000c00ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x0000000007107984ULL, 0x0005220000000c00ULL,
0xfffffff80d027812ULL, 0x000fe200078ee206ULL, 0x00000008450d7824ULL, 0x000fe200078e00ffULL,
0xfffffff804057812ULL, 0x000fc400078ee205ULL, 0x0000000402027c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405007c10ULL, 0x002fe4000ff3e0ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fe200000e06ffULL, 0x00005a0002047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x004fe200008e06ffULL, 0x00005a0000067a11ULL, 0x000fe400078240ffULL,
0x00005b0002057a11ULL, 0x000fc400000f4405ULL, 0x00005b0000077a11ULL, 0x000fc600008f4407ULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x000000100d047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000001004007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000194500720cULL, 0x000fe20003f06070ULL,
0xffffffffff027424ULL, 0x000fd800078e00ffULL, 0x0000000207088824ULL, 0x002fc800078e00ffULL,
0x0000640008088a24ULL, 0x000fc800078e0245ULL, 0x0000600008088625ULL, 0x000fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff0a7624ULL, 0x000fe200078e00ffULL,
0x0000000608028981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff0b7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff047f8cULL, 0x000e68000c80043fULL, 0x000000060a3c7981ULL, 0x000722000c1e9900ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000004013037824ULL, 0x000fe400078e00ffULL,
0x0000004045187824ULL, 0x000fe400078e00ffULL, 0x00000040123d7824ULL, 0x000fc400078e00ffULL,
0x0000000302277224ULL, 0x004fcc00078e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff237819ULL, 0x00afe40000011600ULL, 0x0000003006257812ULL, 0x000fe400078ec0ffULL,
0x0000001023137810ULL, 0x000fe20007ffe0ffULL, 0x00000040120e7824ULL, 0x000fe200078e0223ULL,
0x0000100045117811ULL, 0x000fe400078e68ffULL, 0x0000001823297810ULL, 0x000fe40007ffe0ffULL,
0x000000180e0a7810ULL, 0x000fc40007ffe0ffULL, 0x000000100e097810ULL, 0x040fe40007ffe0ffULL,
0x0000000e27157210ULL, 0x040fe40007f1e0ffULL, 0x0000000a270a7210ULL, 0x040fe40007f7e0ffULL,
0x000000080e087810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x00000009270d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200018e06ffULL,
0x00005e0015107a11ULL, 0x000fc400078038ffULL, 0x0000000827147210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff087224ULL, 0x000fe200010e06ffULL, 0x00005e000a127a11ULL, 0x040fe400078638ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078438ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x00005f0015157a11ULL, 0x000fe400000f3c16ULL, 0x00005f000a167a11ULL, 0x000fe400018f3c09ULL,
0x000000181b097217ULL, 0x000fc40007800000ULL, 0x00005e00140b7a11ULL, 0x000fe400078238ffULL,
0x00005f000d0d7a11ULL, 0x000fe200010f3c08ULL, 0x0000000109067824ULL, 0x000fe200078e0a18ULL,
0x0000000000087211ULL, 0x000fe400078fe8ffULL, 0x00005f0014147a11ULL, 0x000fe400008f3c0fULL,
0x00000003080f7812ULL, 0x000fe400078ec0ffULL, 0x0000000823097810ULL, 0x000fc40007ffe0ffULL,
0x0ffffffc0f007812ULL, 0x000fe400078ef800ULL, 0x000000062300720cULL, 0x000fe20003f06070ULL,
0x00000004090a7824ULL, 0x000fe200078e00ffULL, 0x0000001025087210ULL, 0x000fe20007f7e0ffULL,
0x0000000413107824ULL, 0x040fe200078e00ffULL, 0x000000061300720cULL, 0x080fe20003f46070ULL,
0x0000001000137824ULL, 0x000fe200078e0211ULL, 0xfffffffc0a007812ULL, 0x000fe400078ee20fULL,
0x000000060900720cULL, 0x000fe20003f26070ULL, 0x000000ffff097224ULL, 0x000fe200018e0615ULL,
0x000000250b0a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001000157824ULL, 0x000fe200078e0211ULL,
0xfffffffc10107812ULL, 0x000fc400078ee20fULL, 0x000000250c0c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0614ULL, 0x000000200e007810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0x0000001010177824ULL, 0x000fe200078e0211ULL, 0x00000020231d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e060dULL, 0x0000000027147210ULL, 0x000fe20007f1e0ffULL,
0x0000000429107824ULL, 0x040fe200078e00ffULL, 0x000000062900720cULL, 0x000fe20003f86070ULL,
0x000000000a157faeULL, 0x0005e2000c901c46ULL, 0x00000028231f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc10007812ULL, 0x000fe200078ee20fULL, 0x000000000c177faeULL, 0x0007e2000d101c46ULL,
0x000000ffff097224ULL, 0x002fe200000e06ffULL, 0x0000002512087210ULL, 0x000fe40007fbe0ffULL,
0x0000003023217810ULL, 0x040fe40007ffe0ffULL, 0x0000003823237810ULL, 0x000fe20007ffe0ffULL,
0x00000010000b7824ULL, 0x004fe200078e0211ULL, 0x000000061d00720cULL, 0x080fe20003f66070ULL,
0x00000004210a7824ULL, 0x000fe200078e00ffULL, 0x000000061f00720cULL, 0x000fc40003f46070ULL,
0x00005e00140c7a11ULL, 0x048fe400078c38ffULL, 0x000000062100720cULL, 0x080fe40003f26070ULL,
0x00005f0014147a11ULL, 0x000fe200030f3c09ULL, 0x000000ffff097224ULL, 0x000fe200028e0616ULL,
0x000000062300720cULL, 0x000fe40003f06070ULL, 0x000000280e007810ULL, 0x040fe40007ffe0ffULL,
0x000000300e067810ULL, 0x040fe20007ffe0ffULL, 0x00000000080b7faeULL, 0x0003e2000e101c46ULL,
0x000000380e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000027127210ULL, 0x000fe20007fbe0ffULL,
0x000000041d007824ULL, 0x000fe200078e00ffULL, 0x0000000627107210ULL, 0x000fe20007f9e0ffULL,
0x000000041f067824ULL, 0x000fe200078e00ffULL, 0x0000000e270d7210ULL, 0x000fe20007fde0ffULL,
0x00000004230e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc00007812ULL, 0x100fe400078ee20fULL,
0xfffffffc06067812ULL, 0x100fe200078ee20fULL, 0x000000ffff097224ULL, 0x002fe200028e06ffULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee20fULL, 0x0000001000137824ULL, 0x000fe200078e0211ULL,
0xfffffffc0e087812ULL, 0x000fe200078ee20fULL, 0x0000001006157824ULL, 0x100fe200078e0211ULL,
0x00005e00120f7a11ULL, 0x000fe200078a38ffULL, 0x000000100a177824ULL, 0x000fc400078e0211ULL,
0x0000001008117824ULL, 0x000fe200078e0211ULL, 0x00005f0012127a11ULL, 0x000fe200028f3c09ULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0x000000250c087210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff007224ULL, 0x000fe200030e06ffULL, 0x00005e00100c7a11ULL, 0x040fe400078838ffULL,
0x00005e000d0e7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff097224ULL, 0x000fe200028e0614ULL,
0x000000250f0a7210ULL, 0x000fe40007fbe0ffULL, 0x00005f0010067a11ULL, 0x000fc400020f3c0bULL,
0x000000250c0c7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0612ULL,
0x00005f000d007a11ULL, 0x000fe200030f3c00ULL, 0x0000000008137faeULL, 0x0003e2000d901c46ULL,
0x000000250e0e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe400020e0606ULL,
0x000000000a157faeULL, 0x0003e4000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fe400028e0600ULL,
0x000000000c177faeULL, 0x0003e8000c901c46ULL, 0x000000000e117faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000003d00087211ULL, 0x04afe400078ff0ffULL,
0x00000008001c7811ULL, 0x000fc400078ff0ffULL, 0x0000000827087210ULL, 0x000fe40007f1e0ffULL,
0x00000020000e7811ULL, 0x040fe400078ff0ffULL, 0x00000010000a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0008207a11ULL, 0x000fe200078038ffULL,
0x000000013d0d7824ULL, 0x040fe200078e020eULL, 0x00000018000c7811ULL, 0x000fe400078ff0ffULL,
0x00005f0008227a11ULL, 0x000fe200000f3c09ULL, 0x000000013d087824ULL, 0x040fe200078e021cULL,
0x0000003000127811ULL, 0x040fe200078ff0ffULL, 0x000000013d097824ULL, 0x040fe200078e020aULL,
0x0000000000167211ULL, 0x040fe200078fe8ffULL, 0x000000013d0b7824ULL, 0x040fe200078e020cULL,
0x0000002800107811ULL, 0x040fe200078ff0ffULL, 0x000000013d117824ULL, 0x000fe200078e0212ULL,
0x0000003800147811ULL, 0x000fe200078ff0ffULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0x00000008271e7210ULL, 0x040fe20007fde0ffULL, 0x000000040a087824ULL, 0x000fe200078e00ffULL,
0x0000000d27177210ULL, 0x040fe20007f3e0ffULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0x00000003160d7812ULL, 0x000fe200078ec0ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000000927157210ULL, 0x000fe20007fbe0ffULL, 0x000000013d0f7824ULL, 0x000fe200078e0210ULL,
0x0000100045297811ULL, 0x000fe200078e68ffULL, 0x000000040e0a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc0d0e7812ULL, 0x000fe200078ef800ULL, 0x000000013d137824ULL, 0x000fe200078e0214ULL,
0xfffffffc1c007812ULL, 0x100fe200078ee20dULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0xfffffffc08087812ULL, 0x100fe200078ee20dULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0xfffffffc0c097812ULL, 0x000fe200078ee20dULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x0000000b271a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010081f7824ULL, 0x100fe200078e0229ULL,
0x00005e001e1c7a11ULL, 0x000fe200078c38ffULL, 0x0000001009217824ULL, 0x000fe200078e0229ULL,
0xfffffffc120c7812ULL, 0x000fe200078ee20dULL, 0x000000100e2d7824ULL, 0x000fe200078e0229ULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee20dULL, 0x000000ffff087224ULL, 0x000fe200028e06ffULL,
0xfffffffc100b7812ULL, 0x000fe200078ee20dULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x0000000f270f7210ULL, 0x040fe20007f5e0ffULL, 0x000000100a237824ULL, 0x100fe200078e0229ULL,
0x0000001127117210ULL, 0x000fe20007f7e0ffULL, 0x000000100b257824ULL, 0x100fe200078e0229ULL,
0x0000001327137210ULL, 0x000fe20007f9e0ffULL, 0x000000100c277824ULL, 0x000fe200078e0229ULL,
0xfffffffc140d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x00005f001e1e7a11ULL, 0x000fe200030f3c1dULL, 0x00000010001d7824ULL, 0x100fe200078e0229ULL,
0x00005e00150c7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e001a0e7a11ULL, 0x000fe200078038ffULL, 0x000000100d297824ULL, 0x000fe200078e0229ULL,
0x00005e0017107a11ULL, 0x000fc400078238ffULL, 0x00000030062b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff067224ULL, 0x000fe200018e06ffULL, 0x00005f00150d7a11ULL, 0x000fe400028f3c08ULL,
0x00005f001a1a7a11ULL, 0x000fe400000f3c09ULL, 0x00005f0017177a11ULL, 0x000fe200008f3c00ULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x000000202b087210ULL, 0x000fe40007f1e0ffULL,
0x00005e000f127a11ULL, 0x000fc400078238ffULL, 0x00005e0011147a11ULL, 0x000fe200078438ffULL,
0x000000ffff097224ULL, 0x000fe200000e0622ULL, 0x00005e0013167a11ULL, 0x000fe400078638ffULL,
0x00005f000f157a11ULL, 0x000fe400008f3c0aULL, 0x0000001c2b0a7210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082d7faeULL, 0x0003e2000b901c46ULL,
0x00005f0011067a11ULL, 0x000fe400010f3c06ULL, 0x0000000c2b0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e061eULL, 0x00005f0013007a11ULL, 0x000fc400018f3c00ULL,
0x0000000e2b0e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000102b107210ULL, 0x040fe20007f7e0ffULL, 0x000000000a1d7faeULL, 0x0003e2000b901c46ULL,
0x000000122b127210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e061aULL,
0x000000142b147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0617ULL,
0x000000162b167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0615ULL,
0x000000000c1f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc400028e0606ULL,
0x000000ffff177224ULL, 0x000fe200000e0600ULL, 0x000000000e217faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e8000b901c46ULL, 0x0000000012257faeULL, 0x0003e8000b901c46ULL,
0x0000000014277faeULL, 0x0003e8000b901c46ULL, 0x0000000016297faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x00f60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140bULL,
0x0000000d00007211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000200007819ULL, 0x000fc8000000120bULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000002045007824ULL, 0x002fca00078e0200ULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f00047812ULL, 0x000fc600078ec0ffULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x0000001004097824ULL, 0x040fe400078e00ffULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0x0000000f05007812ULL, 0x040fe400078ec0ffULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000000f009007812ULL, 0x000fe400078ee200ULL, 0x0000000f05057812ULL, 0x000fc600078ec0ffULL,
0x00000000000c7984ULL, 0x000e62000000cc00ULL, 0x000000f004057812ULL, 0x000fca00078ee205ULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001000007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff067224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008040d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011409ULL,
0x0000000d00007211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000200007819ULL, 0x000fc80000001209ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff4400720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x00006400071a7a24ULL, 0x000fe200078e02ffULL,
0x3db504f33c3c7820ULL, 0x010fe20000410000ULL, 0x0000f688453e7811ULL, 0x040fe200078e18ffULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0xffffffff443f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x0000f60845407811ULL, 0x000fe200078e28ffULL,
0x000000ffff437224ULL, 0x000fc400078e0045ULL, 0x0000010041467824ULL, 0x000fe200078e0218ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000461b00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e0042ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fc4000001ff00ULL, 0x0000000147087810ULL, 0x020fe20007ffe0ffULL,
0x00000d6000007945ULL, 0x000fe20003800000ULL, 0x000000ffff497224ULL, 0x000fe200078e0047ULL,
0x0000000148427812ULL, 0x000fe200078e0cffULL, 0x0000000302397224ULL, 0x010fe200078e02ffULL,
0x00000041080b7211ULL, 0x040fe200078ff8ffULL, 0x000000ffff477224ULL, 0x000fe200078e0008ULL,
0x000000020800780cULL, 0x000fc40003f06070ULL, 0x000000010b097810ULL, 0x000fe40007ffe0ffULL,
0x0000000108507812ULL, 0x000fe400078ec0ffULL, 0x000000440900720cULL, 0x000fda0003f26070ULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff337819ULL, 0x002fe20000011600ULL,
0x000001000b2e7824ULL, 0x000fe400078e0218ULL, 0x00000002453a7824ULL, 0x000fe200078e0242ULL,
0x00000010334f7810ULL, 0x000fe20007ffe0ffULL, 0x000000013d087824ULL, 0x000fe200078e0233ULL,
0x00000008333b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002e1b097217ULL, 0x000fe20007800000ULL,
0x000000013d0b7824ULL, 0x000fe200078e024fULL, 0x00000008392d7210ULL, 0x000fe20007f3e0ffULL,
0x000000013d0a7824ULL, 0x000fe200078e023bULL, 0x0000001833517810ULL, 0x000fe20007ffe0ffULL,
0x0000000109387824ULL, 0x000fe200078e0a2eULL, 0x0000000b392f7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff347224ULL, 0x000fe200008e06ffULL, 0x0000000a39317210ULL, 0x000fe20007f5e0ffULL,
0x000000013d2e7824ULL, 0x000fe200078e0251ULL, 0x0000002033527810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x00005e002f087a11ULL, 0x000fe200078638ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x0000002833537810ULL, 0x000fc40007ffe0ffULL,
0x00005e002d2c7a11ULL, 0x000fe400078238ffULL, 0x00005e00310a7a11ULL, 0x000fe400078438ffULL,
0x0000003033547810ULL, 0x040fe40007ffe0ffULL, 0x0000003833557810ULL, 0x000fe40007ffe0ffULL,
0x00005f002f097a11ULL, 0x000fe200018f3c30ULL, 0x000000013d2f7824ULL, 0x000fe200078e0252ULL,
0x00005f002d2d7a11ULL, 0x000fe200008f3c34ULL, 0x000000013d307824ULL, 0x000fe200078e0253ULL,
0x0000002e39367210ULL, 0x000fc40007f3e0ffULL, 0x00005f00310b7a11ULL, 0x000fe200010f3c32ULL,
0x000000013d317824ULL, 0x000fe200078e0254ULL, 0x0000002f39347210ULL, 0x000fe20007fbe0ffULL,
0x000000013d327824ULL, 0x000fe200078e0255ULL, 0x0000003039377210ULL, 0x000fe20007fde0ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e06ffULL, 0x0000000000307211ULL, 0x000fe400078fe8ffULL,
0x000000383300720cULL, 0x000fe20003f46070ULL, 0x000000ffff4e7224ULL, 0x000fe200030e06ffULL,
0x00005e00362e7a11ULL, 0x000fc400078238ffULL, 0x0000003139357210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e06ffULL, 0x0000003239337210ULL, 0x000fe20007f7e0ffULL,
0x0000000450397824ULL, 0x000fe200078e00ffULL, 0x00000003304d7812ULL, 0x000fe200078ec0ffULL,
0x000000043b327824ULL, 0x040fe200078e00ffULL, 0x00005f00362f7a11ULL, 0x000fe200008f3c2fULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x000000383b00720cULL, 0x000fe20003f26070ULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x000010003a3a7811ULL, 0x000fc400078e60ffULL,
0x0ffffffc4d3b7812ULL, 0x100fe400078ef800ULL, 0xfffffffc39397812ULL, 0x000fe400078ee200ULL,
0xfffffffc324b7812ULL, 0x000fe200078ee24dULL, 0x000000103b3b7824ULL, 0x000fe200078e023aULL,
0x00005e0034307a11ULL, 0x040fe200078a38ffULL, 0x00000010392c7825ULL, 0x000fe200078e002cULL,
0x00005e0033327a11ULL, 0x000fe400078638ffULL, 0x00005f0034317a11ULL, 0x000fe200028f3c31ULL,
0x000000104b4b7824ULL, 0x000fe200078e023aULL, 0x00005e0037367a11ULL, 0x000fe200078a38ffULL,
0x00000010390a7825ULL, 0x000fe200078e000aULL, 0x00005e0035347a11ULL, 0x000fe200078838ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c3b7faeULL, 0x0003e2000d101c46ULL,
0x00005f0037377a11ULL, 0x000fe200028f3c4eULL, 0x0000001039087825ULL, 0x000fe200078e0008ULL,
0x00005f0035357a11ULL, 0x000fe200020f3c4cULL, 0x000000000a4b7faeULL, 0x0005e2000c901c46ULL,
0x00005f0033337a11ULL, 0x000fe200018f3c4aULL, 0x00000004514a7824ULL, 0x000fe200078e00ffULL,
0x000000384f00720cULL, 0x080fe20003f26070ULL, 0x00000010392e7825ULL, 0x000fe200078e002eULL,
0x000000385100720cULL, 0x000fc40003f46070ULL, 0x000000385200720cULL, 0x0c0fe20003f66070ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x000000385300720cULL, 0x0c0fe20003f86070ULL,
0x00000004532c7824ULL, 0x002fe200078e00ffULL, 0x000000385400720cULL, 0x0c0fe20003fa6070ULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0x000000385500720cULL, 0x000fe20003fc6070ULL,
0x000000044f387824ULL, 0x000fe200078e00ffULL, 0xfffffffc4a2d7812ULL, 0x100fe200078ee24dULL,
0x00000004550a7824ULL, 0x004fe200078e00ffULL, 0xfffffffc523b7812ULL, 0x000fe200078ee24dULL,
0x0000001039307825ULL, 0x000fe200078e0030ULL, 0xfffffffc380b7812ULL, 0x000fc400078ee24dULL,
0xfffffffc2c4b7812ULL, 0x100fe200078ee24dULL, 0x000000102d2d7824ULL, 0x100fe200078e023aULL,
0xfffffffc544f7812ULL, 0x100fe200078ee24dULL, 0x000000100b0b7824ULL, 0x100fe200078e023aULL,
0xfffffffc0a517812ULL, 0x000fe200078ee24dULL, 0x000000103b3b7824ULL, 0x100fe400078e023aULL,
0x000000104b4b7824ULL, 0x000fe200078e023aULL, 0x00000000080b7faeULL, 0x0003e2000c901c46ULL,
0x0000001039367825ULL, 0x000fc600078e0036ULL, 0x000000002e2d7faeULL, 0x0003e2000d101c46ULL,
0x000000104f4d7824ULL, 0x000fe400078e023aULL, 0x0000001039347825ULL, 0x000fe200078e0034ULL,
0x00000000303b7faeULL, 0x0003e6000d901c46ULL, 0x00000010514f7824ULL, 0x000fe200078e023aULL,
0x00000000364b7faeULL, 0x0003e2000e101c46ULL, 0x0000001039327825ULL, 0x000fc600078e0032ULL,
0x00000000344d7faeULL, 0x0003e8000e901c46ULL, 0x00000000324f7faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000800307811ULL, 0x002fe200078ff0ffULL,
0x0000000450557824ULL, 0x000fe200078e00ffULL, 0x0000003d00087211ULL, 0x040fe400078ff0ffULL,
0x0000001000327811ULL, 0x000fe200078ff0ffULL, 0x000000013d0a7824ULL, 0x040fe200078e0230ULL,
0x00000039080b7210ULL, 0x080fe20007f3e0ffULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0x0000001800367811ULL, 0x000fe200078ff0ffULL, 0x000000013d347824ULL, 0x040fe200078e0232ULL,
0x000000390a097210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00000020003a7811ULL, 0x040fe200078ff0ffULL, 0x000000013d387824ULL, 0x040fe200078e0236ULL,
0x00000028004c7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x0000003000527811ULL, 0x040fe200078ff0ffULL, 0x000000013d4a7824ULL, 0x040fe200078e023aULL,
0x0000003800567811ULL, 0x000fe200078ff0ffULL, 0x000000013d4e7824ULL, 0x000fe200078e024cULL,
0x00005e000b0a7a11ULL, 0x000fe200078238ffULL, 0x000000013d547824ULL, 0x000fe200078e0252ULL,
0x00005e0009087a11ULL, 0x000fe200078438ffULL, 0x000000013d587824ULL, 0x000fe200078e0256ULL,
0x00005f000b0b7a11ULL, 0x000fe200008f3c2eULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0x00000000002e7211ULL, 0x000fc400078fe8ffULL, 0x00005f0009097a11ULL, 0x000fe200010f3c2cULL,
0x00000002452c7824ULL, 0x000fe200078e0242ULL, 0x00000039342d7210ULL, 0x080fe20007fde0ffULL,
0x0000000432347824ULL, 0x000fe200078e00ffULL, 0x00000039382f7210ULL, 0x080fe20007fbe0ffULL,
0x000000043a387824ULL, 0x000fe200078e00ffULL, 0x000000394a317210ULL, 0x080fe20007f9e0ffULL,
0x000000044c3a7824ULL, 0x000fe200078e00ffULL, 0x000000394e337210ULL, 0x080fe20007f3e0ffULL,
0x00000004524a7824ULL, 0x000fe200078e00ffULL, 0x0000003954357210ULL, 0x080fe20007f5e0ffULL,
0x00000004564c7824ULL, 0x000fe200078e00ffULL, 0x0000003958377210ULL, 0x000fc40007f7e0ffULL,
0x000000032e397812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0x000010002c537811ULL, 0x000fe400078e60ffULL, 0xfffffffc30327812ULL, 0x100fe400078ee239ULL,
0x0ffffffc39307812ULL, 0x000fe400078ef800ULL, 0x00005e002d2c7a11ULL, 0x040fe400078c38ffULL,
0xfffffffc34347812ULL, 0x000fe200078ee239ULL, 0x0000001030577824ULL, 0x000fe200078e0253ULL,
0xfffffffc36367812ULL, 0x100fe200078ee239ULL, 0x000000ffff307224ULL, 0x000fe200028e06ffULL,
0xfffffffc38387812ULL, 0x000fe200078ee239ULL, 0x00000010343b7824ULL, 0x000fe200078e0253ULL,
0xfffffffc3a3a7812ULL, 0x000fe200078ee239ULL, 0x00000010364b7824ULL, 0x000fe200078e0253ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee239ULL, 0x00000010384d7824ULL, 0x000fe200078e0253ULL,
0xfffffffc4c4c7812ULL, 0x000fe200078ee239ULL, 0x0000001032397824ULL, 0x100fe200078e0253ULL,
0x00005f002d2d7a11ULL, 0x000fe200030f3c2eULL, 0x000000103a4f7824ULL, 0x100fe200078e0253ULL,
0x00005e002f2e7a11ULL, 0x000fe200078a38ffULL, 0x000000104a517824ULL, 0x100fe200078e0253ULL,
0xfffffffc55557812ULL, 0x000fe200078ee200ULL, 0x000000104c537824ULL, 0x000fe200078e0253ULL,
0x00005f002f2f7a11ULL, 0x000fe200028f3c30ULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078838ffULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0x00005e0033327a11ULL, 0x000fe200078238ffULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078438ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078638ffULL, 0x00000010550a7825ULL, 0x000fe200078e000aULL,
0x00005f0031317a11ULL, 0x000fc400020f3c4cULL, 0x00005f0033337a11ULL, 0x000fe200008f3c4aULL,
0x0000001055087825ULL, 0x000fe200078e0008ULL, 0x00005f0035357a11ULL, 0x000fe200010f3c3aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a577faeULL, 0x0003e2000b901c46ULL,
0x00005f0037377a11ULL, 0x000fe200018f3c38ULL, 0x00000010552c7825ULL, 0x040fe400078e002cULL,
0x0000000008397faeULL, 0x0003e4000b901c46ULL, 0x00000010552e7825ULL, 0x040fe400078e002eULL,
0x000000002c3b7faeULL, 0x0003e4000b901c46ULL, 0x0000001055307825ULL, 0x000fc400078e0030ULL,
0x000000002e4b7faeULL, 0x0003e4000b901c46ULL, 0x0000001055327825ULL, 0x040fe400078e0032ULL,
0x00000000304d7faeULL, 0x0003e4000b901c46ULL, 0x0000001055347825ULL, 0x040fe400078e0034ULL,
0x00000000324f7faeULL, 0x0003e4000b901c46ULL, 0x0000001055367825ULL, 0x000fc400078e0036ULL,
0x0000000034517faeULL, 0x0003e8000b901c46ULL, 0x0000000036537faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5000720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x0000000443437810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff027424ULL, 0x000fc600078e00ffULL,
0x000000194300720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000021a087824ULL, 0x002fe400078e0243ULL, 0x00000004ff097424ULL, 0x000fc800078e00ffULL,
0x0000600008087625ULL, 0x000fca00078e0009ULL, 0x0000000608027981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff800097812ULL, 0x022fe200078ec0ffULL, 0x0000000245317824ULL, 0x000fe200078e0248ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014a3a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000709097812ULL, 0x000fe400078ef800ULL, 0x0000100031317811ULL, 0x000fe400078e60ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011609ULL, 0x00000004092d7824ULL, 0x040fe200078e00ffULL,
0x00000020002c7810ULL, 0x000fe20007ffe0ffULL, 0x00000004090a7824ULL, 0x000fc400078e00ffULL,
0x000000010b087824ULL, 0x040fe400078e024aULL, 0x000000010b0b7824ULL, 0x000fc600078e023aULL,
0xfffffffc2d087812ULL, 0x000fe400078ee208ULL, 0x00000007002d7812ULL, 0x000fe400078ec0ffULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee20bULL, 0x00000010084c7824ULL, 0x100fe200078e0231ULL,
0x000000082d3b7812ULL, 0x000fe200078ef800ULL, 0x0000000449087824ULL, 0x000fe200078e024aULL,
0xfffffff82c0b7812ULL, 0x000fe200078ec0ffULL, 0x000000100a347824ULL, 0x000fe400078e0231ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x0000000208097824ULL, 0x000fe200078e00ffULL,
0x000000070b307812ULL, 0x000fe200078ef800ULL, 0x000000103b2d7824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000ea40000000200ULL, 0x0000000900087211ULL, 0x000fe200078fe0ffULL,
0x0000000430397824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc40000011630ULL,
0x0000000209337810ULL, 0x000fe20007ffe0ffULL, 0x000000013b087824ULL, 0x000fe400078e0208ULL,
0x000000010b0a7824ULL, 0x040fe200078e024aULL, 0x0000003300327211ULL, 0x000fe200078fe0ffULL,
0x000000010b507824ULL, 0x000fe200078e023aULL, 0xfffffff02d087812ULL, 0x000fe400078ee208ULL,
0xfffffffc390a7812ULL, 0x000fe200078ee20aULL, 0x000000013b387824ULL, 0x000fe200078e0232ULL,
0x000000024a4a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001008087824ULL, 0x000fc400078e00ffULL,
0x000000103b3b7824ULL, 0x000fe200078e00ffULL, 0x000000044a00780cULL, 0x000fe40003f25270ULL,
0x00000000082c783bULL, 0x0006e40000000200ULL, 0xfffffff03b387812ULL, 0x000fca00078ee238ULL,
0x00000010384b7824ULL, 0x000fe400078e00ffULL, 0x000000100a387824ULL, 0x000fe200078e0231ULL,
0x00000018ff097819ULL, 0x102fe4000001164fULL, 0x0000ffff4f397812ULL, 0x040fe400078ec0ffULL,
0x00000009ff33723eULL, 0x000fe400020006ffULL, 0x00000010ff097819ULL, 0x000fe4000001164fULL,
0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x000000ff09327812ULL, 0x000fc400078ec0ffULL, 0x00000008ff097819ULL, 0x000fe40000011639ULL,
0x00000032ff32723eULL, 0x000fe200020006ffULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000010ff337819ULL, 0x000fe20000011633ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000ffff37537812ULL, 0x004fe200078ec0ffULL,
0x20000009ff097230ULL, 0x000fe20000004100ULL, 0x00000010ff327819ULL, 0x000fc40000011632ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff087819ULL, 0x008fe40000011609ULL,
0x0000105433337816ULL, 0x000fe40000000032ULL, 0x0000105408327816ULL, 0x000fe4000000004fULL,
0x00000010ff4f7819ULL, 0x100fe20000011637ULL, 0x000000004b08783bULL, 0x000e620000000200ULL,
0x00000018ff517819ULL, 0x000fc40000011637ULL, 0x000000ff4f527812ULL, 0x000fe200078ec0ffULL,
0x000000322c04723cULL, 0x000b620000041804ULL, 0x00000008ff4f7819ULL, 0x000fe40000011653ULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x0000000430337824ULL, 0x020fe200078e00ffULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fc400020006ffULL,
0xfffffffc33507812ULL, 0x000fe200078ee250ULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fe2000001164fULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x0000001050317824ULL, 0x000fe200078e0231ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x0000105430547816ULL, 0x000fc40000000037ULL,
0x000000003130783bULL, 0x000ea20000000200ULL, 0x00000018ff377819ULL, 0x000fe4000001164cULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff727819ULL, 0x000fe4000001164eULL,
0x0000105451557816ULL, 0x000fe40000000052ULL, 0x00000018ff527819ULL, 0x000fe4000001164dULL,
0x00000018ff667819ULL, 0x000fc4000001164eULL, 0x000000ff4e6c7812ULL, 0x040fe200078ec0ffULL,
0x000000540804723cULL, 0x002be20000041804ULL, 0x0000ffff4e737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4b7819ULL, 0x000fe4000001164cULL, 0x00000010ff4e7819ULL, 0x100fe40000011635ULL,
0x00000018ff767819ULL, 0x000fe40000011635ULL, 0x000000ff35777812ULL, 0x000fc400078ec0ffULL,
0x0000ffff35507812ULL, 0x000fe400078ec0ffULL, 0x00000037ff35723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x000000ff4d657812ULL, 0x000fe400078ec0ffULL,
0x000000ff34757812ULL, 0x000fe200078ec0ffULL, 0x20000052ff697230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fc400020006ffULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff717819ULL, 0x000fe4000001164dULL, 0x00000010ff5e7819ULL, 0x104fe40000011630ULL,
0x00000018ff587819ULL, 0x000fe40000011630ULL, 0x000000ff30597812ULL, 0x040fe400078ec0ffULL,
0x0000ffff30537812ULL, 0x000fe200078ec0ffULL, 0x20000035ff307230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000066ff35723eULL, 0x000fe400020006ffULL,
0x00000075ff52723eULL, 0x000fe400020006ffULL, 0x0000004bff75723eULL, 0x000fe200020006ffULL,
0x20000077ff4b7230ULL, 0x000fe20000004100ULL, 0x00000018ff787819ULL, 0x000fe20000011636ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x0000ffff4d747812ULL, 0x000fe200078ec0ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000006cff66723eULL, 0x000fe200020006ffULL,
0x20000065ff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff71717812ULL, 0x000fe200078ec0ffULL,
0x20000035ff657230ULL, 0x000fe20000004100ULL, 0x000000ff72777812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff727819ULL, 0x000fc40000011673ULL,
0x00000078ff35723eULL, 0x000fe400020006ffULL, 0x00000008ff747819ULL, 0x000fe40000011674ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000077ff78723eULL, 0x000fe400020006ffULL, 0x00000072ff77723eULL, 0x000fe400020006ffULL,
0x00000018ff707819ULL, 0x000fe20000011638ULL, 0x20000078ff727230ULL, 0x000fe20000004100ULL,
0x00000074ff73723eULL, 0x000fe200020006ffULL, 0x20000071ff747230ULL, 0x000fe20000004100ULL,
0x0000ffff34687812ULL, 0x000fe200078ec0ffULL, 0x20000077ff717230ULL, 0x000fe20000004100ULL,
0x000000ff4c517812ULL, 0x040fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x0000ffff4c7a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff386f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3a4c7812ULL, 0x000fe400078ec0ffULL, 0x00000070ff77723eULL, 0x000fe400020006ffULL,
0x00000018ff557819ULL, 0x020fe4000001163bULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff637819ULL, 0x000fc40000011638ULL, 0x0000ffff38677812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe40000011639ULL, 0x00000018ff6b7819ULL, 0x000fe40000011639ULL,
0x000000ff395f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff39617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x000fc40000011636ULL, 0x0000006fff70723eULL, 0x000fe200020006ffULL,
0x20000077ff6f7230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001163aULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe4000001163bULL, 0x000000ff3b4d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3b387812ULL, 0x000fc400078ec0ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000018ff3b7819ULL, 0x000fe40000011634ULL, 0x00000068ff77723eULL, 0x000fe200020006ffULL,
0x2000004cff687230ULL, 0x000fe20000004100ULL, 0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x20000055ff4c7230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000077ff557230ULL, 0x000fe20000004100ULL, 0x000000ff4f4f7812ULL, 0x000fc400078ec0ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x0000006aff78723eULL, 0x000fe200020006ffULL,
0x2000005fff6a7230ULL, 0x000fe20000004100ULL, 0x0000003bff3b723eULL, 0x000fe200020006ffULL,
0x20000051ff6e7230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000078ff5f7230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x2000003bff517230ULL, 0x000fe20000004100ULL, 0x0000004fff77723eULL, 0x000fe200020006ffULL,
0x20000076ff3b7230ULL, 0x000fe20000004100ULL, 0x0000ffff36577812ULL, 0x000fc400078ec0ffULL,
0x00000008ff507819ULL, 0x000fe40000011650ULL, 0x000000ff325c7812ULL, 0x000fe400078ec0ffULL,
0x00000058ff78723eULL, 0x000fe200020006ffULL, 0x2000004eff587230ULL, 0x000fe20000004100ULL,
0x00000008ff767819ULL, 0x000fe2000001167aULL, 0x20000077ff4e7230ULL, 0x000fe20000004100ULL,
0x00000008ff577819ULL, 0x000fe40000011657ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x000000ff336d7812ULL, 0x000fe400078ec0ffULL,
0x0000005cff77723eULL, 0x000fe200020006ffULL, 0x20000059ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff547819ULL, 0x100fe40000011631ULL, 0x00000018ff5b7819ULL, 0x000fe20000011631ULL,
0x20000077ff597230ULL, 0x000fe20000004100ULL, 0x000000ff315a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff31377812ULL, 0x000fe400078ec0ffULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x00000018ff317819ULL, 0x000fe40000011633ULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000057ff4f723eULL, 0x000fe200020006ffULL,
0x20000050ff577230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x20000078ff507230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x000000ff36797812ULL, 0x000fc400078ec0ffULL,
0x00000031ff77723eULL, 0x000fe400020006ffULL, 0x00000064ff78723eULL, 0x000fe400020006ffULL,
0x00000010ff627819ULL, 0x000fe2000001163aULL, 0x20000077ff647230ULL, 0x000fe20000004100ULL,
0x00000063ff31723eULL, 0x000fe200020006ffULL, 0x2000006dff637230ULL, 0x000fe20000004100ULL,
0x00000079ff36723eULL, 0x000fe200020006ffULL, 0x20000067ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff62797812ULL, 0x000fe200078ec0ffULL, 0x20000078ff677230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fe20000011661ULL, 0x20000031ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe20000011630ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fc4000001166eULL, 0x00000010ff317819ULL, 0x000fe40000011675ULL,
0x00000010ff617819ULL, 0x000fe40000011676ULL, 0x0000ffff3a607812ULL, 0x000fe400078ec0ffULL,
0x0000105462317816ULL, 0x000fe40000000031ULL, 0x0000105461307816ULL, 0x000fe40000000030ULL,
0x00000008ff607819ULL, 0x000fc40000011660ULL, 0x000000ff39397812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x000000302c0c723cULL, 0x000b62000004180cULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe20000011669ULL,
0x20000060ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x20000039ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x020fc4000001166cULL,
0x00000010ff317819ULL, 0x000fe40000011674ULL, 0x0000105473307816ULL, 0x000fe40000000030ULL,
0x0000105462317816ULL, 0x000fe40000000031ULL, 0x00000008ff6c7819ULL, 0x000fe40000011638ULL,
0x00000010ff627819ULL, 0x000fe40000011665ULL, 0x00000010ff397819ULL, 0x000fe20000011672ULL,
0x000000302c10723cULL, 0x000be20000041810ULL, 0x00000010ff387819ULL, 0x000fc40000011666ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x0000105462397816ULL, 0x000fe20000000039ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x0000105471387816ULL, 0x000fe20000000038ULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff567819ULL, 0x000fc40000011634ULL,
0x000000ff5e627812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x000fe2000001166fULL,
0x000000382c14723cULL, 0x000be40000041814ULL, 0x00000010ff307819ULL, 0x020fe40000011670ULL,
0x00000010ff317819ULL, 0x000fe40000011677ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x000000ff56567812ULL, 0x000fe400078ec0ffULL,
0x00000062ff66723eULL, 0x000fe200020006ffULL, 0x20000079ff617230ULL, 0x000fe20000004100ULL,
0x000010545e317816ULL, 0x000fe40000000031ULL, 0x000010546d307816ULL, 0x000fe20000000030ULL,
0x20000066ff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe4000001166bULL,
0x00000010ff387819ULL, 0x000fc4000001166aULL, 0x00000010ff397819ULL, 0x000fe20000011667ULL,
0x000000302c1c723cULL, 0x000b62000004181cULL, 0x00000010ff657819ULL, 0x000fe40000011678ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x0000105462397816ULL, 0x000fe20000000039ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000105465387816ULL, 0x000fe20000000038ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x000000ff54627812ULL, 0x000fc400078ec0ffULL, 0x00000010ff547819ULL, 0x000fe4000001165fULL,
0x00000010ff317819ULL, 0x020fe20000011661ULL, 0x000000382c20723cULL, 0x000b620000041820ULL,
0x00000008ff537819ULL, 0x000fe40000011653ULL, 0x0000105454317816ULL, 0x000fe40000000031ULL,
0x00000010ff547819ULL, 0x000fe40000011651ULL, 0x00000010ff387819ULL, 0x020fc40000011652ULL,
0x00000010ff397819ULL, 0x000fe40000011656ULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff307819ULL, 0x000fe40000011668ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff6d7819ULL, 0x000fe4000001164cULL, 0x00000010ff4d7819ULL, 0x000fc4000001164dULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000008ff377819ULL, 0x000fe40000011637ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000105454397816ULL, 0x000fe40000000039ULL, 0x0000105455387816ULL, 0x000fe20000000038ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000105469307816ULL, 0x000fc40000000030ULL,
0x000010546d6d7816ULL, 0x000fe40000000060ULL, 0x000010546c6c7816ULL, 0x000fe2000000004dULL,
0x00000038080c723cULL, 0x000be2000004180cULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x100fe40000011632ULL, 0x00000018ff5d7819ULL, 0x000fe40000011632ULL,
0x00000010ff347819ULL, 0x000fe20000011633ULL, 0x000000302c24723cULL, 0x000f620000041824ULL,
0x000000ff3a3a7812ULL, 0x000fe200078ec0ffULL, 0x20000037ff397230ULL, 0x020fe20000004100ULL,
0x0000ffff32327812ULL, 0x000fc400078ec0ffULL, 0x0000ffff33337812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x000fe2000001164eULL, 0x0000006c2c28723cULL, 0x000b620000041828ULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff2c7819ULL, 0x020fc40000011635ULL,
0x00000010ff2d7819ULL, 0x000fe4000001165eULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000008ff327819ULL, 0x000fe20000011632ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff34347812ULL, 0x000fe200078ec0ffULL,
0x2000003aff3a7230ULL, 0x000fe20000004100ULL, 0x000010542c377816ULL, 0x000fc40000000037ULL,
0x00000008ff337819ULL, 0x000fe40000011633ULL, 0x00001054502d7816ULL, 0x000fe4000000002dULL,
0x00001054532c7816ULL, 0x000fe4000000005cULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x0000002c081c723cULL, 0x000b62000004181cULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000033ff2f723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff337819ULL, 0x000fe2000001163aULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x020fe2000001165dULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000010ff2e7819ULL, 0x000fe2000001165bULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x000010542c337816ULL, 0x000fc40000000033ULL,
0x00000010ff387819ULL, 0x000fe4000001163bULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff317819ULL, 0x000fe40000011658ULL, 0x00000010ff307819ULL, 0x000fe40000011657ULL,
0x00000010ff367819ULL, 0x000fe40000011636ULL, 0x00000010ff4f7819ULL, 0x000fc4000001164fULL,
0x00000010ff5b7819ULL, 0x000fe40000011662ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff327819ULL, 0x000fe40000011632ULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff2d7819ULL, 0x000fe40000011634ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff2c7819ULL, 0x000fe4000001162fULL, 0x0000105438317816ULL, 0x000fe40000000031ULL,
0x0000105430307816ULL, 0x000fe4000000004bULL, 0x000010544f367816ULL, 0x000fc40000000036ULL,
0x000010542e5b7816ULL, 0x000fe4000000005bULL, 0x00001054395a7816ULL, 0x000fe2000000005aULL,
0x000000300810723cULL, 0x000b620000041810ULL, 0x0000105432327816ULL, 0x000fe40000000059ULL,
0x00001054642d7816ULL, 0x000fe4000000002dULL, 0x000010542c2c7816ULL, 0x000fc60000000063ULL,
0x000000360814723cULL, 0x040b700000041814ULL, 0x0000005a0820723cULL, 0x040b700000041820ULL,
0x000000320824723cULL, 0x040b700000041824ULL, 0x0000002c0828723cULL, 0x000b620000041828ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe7c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff487224ULL, 0x000fe200078e0042ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd91000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000003c102d7220ULL, 0x0a0fe20000410000ULL,
0x0000003c060b7220ULL, 0x080fe20000410000ULL, 0x0000003c07107220ULL, 0x080fe20000410000ULL,
0x0000003c20207220ULL, 0x080fe20000410000ULL, 0x0000003c21217220ULL, 0x080fe20000410000ULL,
0x0000003c14147220ULL, 0x080fe20000410000ULL, 0x0000003c15157220ULL, 0x080fe20000410000ULL,
0x0000003c04047220ULL, 0x080fe20000410000ULL, 0x0000003c05057220ULL, 0x080fe20000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003c24067220ULL, 0x080fe20000410000ULL, 0x0000003c25077220ULL, 0x080fe20000410000ULL,
0x0000003c112c7220ULL, 0x080fe20000410000ULL, 0x0000003c12087220ULL, 0x080fe20000410000ULL,
0x0000003c1f117220ULL, 0x080fe20000410000ULL, 0x0000003c16097220ULL, 0x080fe20000410000ULL,
0x0000003c26307220ULL, 0x080fe20000410000ULL, 0x0000003c27317220ULL, 0x080fe20000410000ULL,
0x0000003c281f7220ULL, 0x080fe20000410000ULL, 0x0000003c29127220ULL, 0x080fe20000410000ULL,
0x0000003c2a327220ULL, 0x080fe20000410000ULL, 0x0000003c2b337220ULL, 0x080fe20000410000ULL,
0x000000ffff257224ULL, 0x000fe200078e0020ULL, 0x0000003c0c2f7220ULL, 0x080fe20000410000ULL,
0x000000ffff247224ULL, 0x000fe200078e0021ULL, 0x0000003c0d2e7220ULL, 0x080fe20000410000ULL,
0x0000003c0e0e7220ULL, 0x080fe20000410000ULL, 0x0000003c0f0f7220ULL, 0x080fe20000410000ULL,
0x0000003c13137220ULL, 0x080fe20000410000ULL, 0x0000003c170a7220ULL, 0x080fe20000410000ULL,
0x0000003c1e167220ULL, 0x080fe20000410000ULL, 0x0000003c22227220ULL, 0x080fe20000410000ULL,
0x0000003c23237220ULL, 0x000fe20000410000ULL, 0x000000ffff2b7224ULL, 0x000fc400078e0014ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0015ULL, 0x000000ffff297224ULL, 0x000fe400078e0004ULL,
0x000000ffff287224ULL, 0x000fe400078e0005ULL, 0x000000ffff277224ULL, 0x000fe400078e001cULL,
0x000000ffff267224ULL, 0x000fe400078e001dULL, 0x000000ffff217224ULL, 0x000fc400078e0006ULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003e0c7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe400078e0008ULL,
0x000000ffff087224ULL, 0x000fe400078e000aULL, 0x000000ffff0a7224ULL, 0x000fe400078e000bULL,
0x000000ffff1e7224ULL, 0x000fe400078e000eULL, 0x000000ffff1d7224ULL, 0x000fc400078e000fULL,
0x000000ffff177224ULL, 0x000fe400078e0013ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0011ULL, 0x000000ffff137224ULL, 0x000fe400078e0022ULL,
0x000000ffff147224ULL, 0x000fe400078e0023ULL, 0x000000ffff117224ULL, 0x000fc400078e0030ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0031ULL, 0x000000ffff107224ULL, 0x000fe400078e0032ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0033ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004003e077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604237210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000002306067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003e077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004000d7824ULL, 0x000fe200078e00ffULL, 0x0000003f4100720cULL, 0x000fc80003f05270ULL,
0xfffffff00d0c7812ULL, 0x000fca00078ec0ffULL, 0x00000080450c7824ULL, 0x000fca00078e020cULL,
0x00f400000c047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000200227824ULL, 0x000fe400078e00ffULL, 0x000000011b467824ULL, 0x000fc600078e0a46ULL,
0x0000000622237812ULL, 0x000fc800078ec0ffULL, 0x0000000123317812ULL, 0x040fe400078efcffULL,
0x0000000823337812ULL, 0x000fe400078efcffULL, 0x000000463100720cULL, 0x080fe40003f26070ULL,
0x0000001023317812ULL, 0x000fe400078efcffULL, 0x000000463300720cULL, 0x080fe40003f06070ULL,
0x000000463100720cULL, 0x000fc40003fc6070ULL, 0x0000001123337812ULL, 0x040fe400078efcffULL,
0x0000001823317812ULL, 0x040fe400078efcffULL, 0x000000462300720cULL, 0x080fe40003f46070ULL,
0x000000463300720cULL, 0x080fe40003fa6070ULL, 0x000000463100720cULL, 0x000fe40003f66070ULL,
0x0000000923357812ULL, 0x000fc400078efcffULL, 0x0000001923337812ULL, 0x040fe400078efcffULL,
0x0000002023317812ULL, 0x000fe400078efcffULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000002e2e7808ULL, 0x000fc40004800000ULL, 0x000000463500720cULL, 0x080fe40003f86070ULL,
0x000000463300720cULL, 0x080fe40003f46070ULL, 0x000000463100720cULL, 0x000fe40003f26070ULL,
0x0000002123337812ULL, 0x040fe400078efcffULL, 0x0000002823317812ULL, 0x000fe400078efcffULL,
0xff8000001c1c7808ULL, 0x000fc40004000000ULL, 0xff8000002d2d7808ULL, 0x000fe40004000000ULL,
0xff80000017177808ULL, 0x000fe40006000000ULL, 0xff8000002c2c7808ULL, 0x000fe40006000000ULL,
0x000000463300720cULL, 0x080fe40003f06070ULL, 0x000000463100720cULL, 0x000fe40003f86070ULL,
0x0000002923337812ULL, 0x000fc400078efcffULL, 0x0000003023317812ULL, 0x000fe400078efcffULL,
0xff80000009097808ULL, 0x000fe40007000000ULL, 0xff8000002b2b7808ULL, 0x000fe40007000000ULL,
0xff80000008087808ULL, 0x000fe40006800000ULL, 0xff8000002a2a7808ULL, 0x000fe40006800000ULL,
0x000000463300720cULL, 0x000fc40003fc6070ULL, 0x000000463100720cULL, 0x000fe40003fa6070ULL,
0x0000003123337812ULL, 0x040fe400078efcffULL, 0x0000003823317812ULL, 0x040fe400078efcffULL,
0x0000003923237812ULL, 0x000fe400078efcffULL, 0xff8000000a0a7808ULL, 0x000fe40005800000ULL,
0xff80000029297808ULL, 0x000fc40005800000ULL, 0xff8000000b0b7808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40005000000ULL, 0xff80000016167808ULL, 0x000fe40004800000ULL,
0xff80000027277808ULL, 0x000fe40004800000ULL, 0x000000463300720cULL, 0x080fe40003f66070ULL,
0x000000463100720cULL, 0x000fc40003f46070ULL, 0x000000462300720cULL, 0x000fe40003f26070ULL,
0xff80000015157808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40004000000ULL,
0xff80000013137808ULL, 0x000fe40006000000ULL, 0xff80000025257808ULL, 0x000fe40006000000ULL,
0xff80000014147808ULL, 0x000fc40007000000ULL, 0xff80000024247808ULL, 0x000fe40007000000ULL,
0xff80000011117808ULL, 0x000fe40006800000ULL, 0xff80000021217808ULL, 0x000fe40006800000ULL,
0xff8000000f0f7808ULL, 0x000fe40005800000ULL, 0xff80000020207808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005000000ULL, 0xff8000001f1f7808ULL, 0x000fe40005000000ULL,
0xff8000000e0e7808ULL, 0x000fe40004800000ULL, 0xff80000012127808ULL, 0x000fc40004800000ULL,
0x0000002f0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff367424ULL, 0x000fe200078e00ffULL,
0x0000001e0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x000000042f237208ULL, 0x000fe40004000000ULL, 0x000000051e047208ULL, 0x000fc40004800000ULL,
0x0000002e2300720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x000000232e227208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000002d2200720bULL, 0x000fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fc40003f3e000ULL,
0x000000222d237208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fe40004800000ULL,
0x0000002c2300720bULL, 0x000fe40003f1e000ULL, 0x000000170400720bULL, 0x000fe40003f3e000ULL,
0x000000232c227208ULL, 0x000fe40004000000ULL, 0x0000000417047208ULL, 0x000fc40004800000ULL,
0x0000002b2200720bULL, 0x000fe40003f1e000ULL, 0x000000090400720bULL, 0x000fe40003f3e000ULL,
0x000000222b057208ULL, 0x000fe40004000000ULL, 0x0000000409237208ULL, 0x000fe40004800000ULL,
0x0000002a0500720bULL, 0x000fe40003f1e000ULL, 0x000000082300720bULL, 0x000fc40003f3e000ULL,
0x000000052a047208ULL, 0x000fe40004000000ULL, 0x0000002308237208ULL, 0x000fe40004800000ULL,
0x000000290400720bULL, 0x000fe40003f1e000ULL, 0x0000000a2300720bULL, 0x000fe40003f3e000ULL,
0x0000000429057208ULL, 0x000fe40004000000ULL, 0x000000230a047208ULL, 0x000fc40004800000ULL,
0x000000280500720bULL, 0x000fe40003f1e000ULL, 0x0000000b0400720bULL, 0x000fe40003f3e000ULL,
0x0000000528227208ULL, 0x000fe40004000000ULL, 0x000000040b057208ULL, 0x000fe40004800000ULL,
0x000000272200720bULL, 0x000fe40003f1e000ULL, 0x000000160500720bULL, 0x000fc40003f3e000ULL,
0x0000002227237208ULL, 0x000fe40004000000ULL, 0x0000000516047208ULL, 0x000fe40004800000ULL,
0x000000262300720bULL, 0x000fe40003f1e000ULL, 0x000000150400720bULL, 0x000fe40003f3e000ULL,
0x0000002326227208ULL, 0x000fe40004000000ULL, 0x0000000415047208ULL, 0x000fc40004800000ULL,
0x000000252200720bULL, 0x000fe40003f1e000ULL, 0x000000130400720bULL, 0x000fe40003f3e000ULL,
0x0000002225057208ULL, 0x000fe40004000000ULL, 0x0000000413237208ULL, 0x000fe40004800000ULL,
0x000000240500720bULL, 0x000fe40003f1e000ULL, 0x000000142300720bULL, 0x000fc40003f3e000ULL,
0x0000000524047208ULL, 0x000fe40004000000ULL, 0x0000002314227208ULL, 0x000fe40004800000ULL,
0x000000210400720bULL, 0x000fe40003f1e000ULL, 0x000000112200720bULL, 0x000fe40003f3e000ULL,
0x0000000421057208ULL, 0x000fe40004000000ULL, 0x0000002211227208ULL, 0x000fc40004800000ULL,
0x000000200500720bULL, 0x000fe40003f1e000ULL, 0x0000000f2200720bULL, 0x000fe40003f3e000ULL,
0x0000000520047208ULL, 0x000fe40004000000ULL, 0x000000220f057208ULL, 0x000fe40004800000ULL,
0x0000001f0400720bULL, 0x000fe40003f1e000ULL, 0x000000100500720bULL, 0x000fc40003f3e000ULL,
0x000000041f237208ULL, 0x000fe40004000000ULL, 0x0000000510057208ULL, 0x000fe40004800000ULL,
0x000000122300720bULL, 0x000fe40003f1e000ULL, 0x0000000e0500720bULL, 0x000fe40003f3e000ULL,
0x0000002312327208ULL, 0x000fe40004000000ULL, 0x000000050e347208ULL, 0x000fe20004800000ULL,
0x000015327f007947ULL, 0x000fec000b800000ULL, 0x0c401f0032047f89ULL, 0x0004e400000e0000ULL,
0x000000043200720bULL, 0x008fc80003f1e000ULL, 0x0000003204357208ULL, 0x000fe20004000000ULL,
0x000015427f007947ULL, 0x000fea000b800000ULL, 0x0c401f0034047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000e6800000e0000ULL, 0x0c401f0007227f89ULL, 0x000ea200000e0000ULL,
0x000000043400720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x002fe40003f3e000ULL,
0x0000003404307208ULL, 0x000fe40004000000ULL, 0x0000000605317208ULL, 0x000fe20004800000ULL,
0x0c201f0035047f89ULL, 0x000e6200000e0000ULL, 0x000000220700720bULL, 0x004fc60003f1e000ULL,
0x0c201f0030057f89ULL, 0x000ea200000e0000ULL, 0x0000000722227208ULL, 0x000fc60004000000ULL,
0x0c201f0031327f89ULL, 0x000ee800000e0000ULL, 0x0c201f0022237f89ULL, 0x0002e400000e0000ULL,
0x000000043500720bULL, 0x002fe40003f1e000ULL, 0x000000053000720bULL, 0x004fe40003f3e000ULL,
0x0000003504047208ULL, 0x000fc40004000000ULL, 0x000000323100720bULL, 0x008fe40003f5e000ULL,
0x0000003005057208ULL, 0x000fe40004800000ULL, 0x0000003132067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05337820ULL, 0x002fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000300ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b17177823ULL, 0x000fe20000010833ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b0b377823ULL, 0x000fe20000010833ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x000fe20000010833ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe20000010833ULL, 0x000000232200720bULL, 0x004fca0003f3e000ULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001d001d7308ULL, 0x000ff00000000800ULL, 0x0000001c001c7308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000e700000000800ULL, 0x0000002000317308ULL, 0x0005f00000000800ULL,
0x0000002100307308ULL, 0x0007e20000000800ULL, 0x00000004ff207e24ULL, 0x004fe2000f8e00ffULL,
0x0000001c170b723eULL, 0x002fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b16177823ULL, 0x000fc40000010833ULL, 0x3f8000002020783eULL, 0x000fe400000010ffULL,
0x0000001f00327308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0a217823ULL, 0x108fe20000010833ULL,
0x0000002d2c0a723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b152d7823ULL, 0x000fca0000010833ULL,
0x0000000900347308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b081f7823ULL, 0x002fe20000010833ULL,
0x0000002f2e08723eULL, 0x000fcc00000010ffULL, 0x0000002100367308ULL, 0x0003e20000000800ULL,
0x0000001e1d09723eULL, 0x004fce00000010ffULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000ffff217224ULL, 0x002fce00078e0020ULL, 0x0000002800287308ULL, 0x000e700000000800ULL,
0x0000001f00357308ULL, 0x0004f00000000800ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x00000020081c723cULL, 0x004b6200000418ffULL, 0x000000292816723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b11297823ULL, 0x000fca0000010833ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b14217823ULL, 0x020fe20000010833ULL, 0x000000343515723eULL, 0x008fcc00000010ffULL,
0x0000003700377308ULL, 0x000eb00000000800ULL, 0x00000017002c7308ULL, 0x0005e20000000800ULL,
0x0000002b2a14723eULL, 0x002fe400000010ffULL, 0x00000002ff2a7819ULL, 0x000fc80000011600ULL,
0x000000012a117810ULL, 0x040fe20007ffe0ffULL, 0x0000002100287308ULL, 0x0003e20000000800ULL,
0x000000363717723eULL, 0x004fe200000010ffULL, 0x000000082a127824ULL, 0x000fe400078e00ffULL,
0x000000ffff367224ULL, 0x100fe400078e0020ULL, 0x000000ffff377224ULL, 0x100fe200078e0020ULL,
0xfffffff8122b7812ULL, 0x000fe200078ee211ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000ffff217224ULL, 0x002fc400078e0020ULL, 0x000000082a357824ULL, 0x040fe400078e00ffULL,
0x000000082a3b7824ULL, 0x000fc600078e00ffULL, 0x00000020141c723cULL, 0x000b62000004181cULL,
0x0000002600267308ULL, 0x000e6c0000000800ULL, 0x3fb8aa3b10217823ULL, 0x120fe20000010833ULL,
0x3fb8aa3b0e337823ULL, 0x000fe20000010833ULL, 0x0000002500257308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000ea20000000800ULL, 0x000000272610723eULL, 0x002fc400000010ffULL,
0x000000042a267810ULL, 0x040fe40007ffe0ffULL, 0x000000082a277810ULL, 0x040fe40007ffe0ffULL,
0xfffffff835357812ULL, 0x000fe200078ee226ULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0xffffffff2a267810ULL, 0x000fc80007ffe0ffULL, 0xfffffff83b3b7812ULL, 0x000fc600078ee226ULL,
0x0000001300137308ULL, 0x000ee20000000800ULL, 0x000000252412723eULL, 0x004fe400000010ffULL,
0x000000032a257810ULL, 0x040fe40007ffe0ffULL, 0x000000022a247810ULL, 0x040fe40007ffe0ffULL,
0x0000002c2d11723eULL, 0x002fe200000010ffULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000082a2d7824ULL, 0x040fe400078e00ffULL, 0x000000082a2c7824ULL, 0x000fc600078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee224ULL, 0x000000132813723eULL, 0x008fe200000010ffULL,
0x000000082a287824ULL, 0x040fe200078e00ffULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x000000052a247810ULL, 0x000fc60007ffe0ffULL, 0xfffffff8282f7812ULL, 0x000fe200078ee225ULL,
0x00000036101c723cULL, 0x000b62000004181cULL, 0x000000062a257810ULL, 0x000fe40007ffe0ffULL,
0x0000003300287308ULL, 0x000fe40000000800ULL, 0xfffffff82c397812ULL, 0x000fe400078ee225ULL,
0x000000082a377824ULL, 0x020fc800078e00ffULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0xfffffff837377812ULL, 0x000fe400078ee224ULL, 0x000000303124723eULL, 0x000fe400000010ffULL,
0x000000320726723eULL, 0x002fe400000010ffULL, 0x0000002223077208ULL, 0x000fe20004800000ULL,
0x0000000f000e7308ULL, 0x0002a40000000800ULL, 0x000000082a0f7824ULL, 0x002fca00078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee22aULL, 0x00000008272a7824ULL, 0x000fe200078e00ffULL,
0x000000290e25723eULL, 0x004fe400000010ffULL, 0x0000000c0d0e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff82a337812ULL, 0x000fe400078ee227ULL, 0x000000212827723eULL, 0x000fe200000010ffULL,
0x000000ffff217224ULL, 0x000fe200078e0020ULL, 0x00009000452a7811ULL, 0x000fca00078e58ffULL,
0x000000100f0f7824ULL, 0x100fe200078e022aULL, 0x00000020241c723cULL, 0x000f62000004181cULL,
0x000000102b2b7824ULL, 0x100fe400078e022aULL, 0x000000102d2d7824ULL, 0x100fe400078e022aULL,
0x000000102f2f7824ULL, 0x100fe400078e022aULL, 0x0000001035357824ULL, 0x000fe400078e022aULL,
0x000000010f0f7824ULL, 0x000fc400078e020eULL, 0x0000001037377824ULL, 0x100fe400078e022aULL,
0x000000010e2b7824ULL, 0x040fe200078e022bULL, 0x000000080f007388ULL, 0x0003e20000000800ULL,
0x0000001039397824ULL, 0x100fe400078e022aULL, 0x000000010e2d7824ULL, 0x040fe200078e022dULL,
0x0000000a2b007388ULL, 0x0003e20000000800ULL, 0x000000103b3b7824ULL, 0x100fe400078e022aULL,
0x000000010e2f7824ULL, 0x000fe200078e022fULL, 0x000000142d007388ULL, 0x0003e20000000800ULL,
0x0000001033337824ULL, 0x000fc400078e022aULL, 0x000000010e357824ULL, 0x040fe200078e0235ULL,
0x000000162f007388ULL, 0x0003e20000000800ULL, 0x000000010e377824ULL, 0x040fe400078e0237ULL,
0x000000010e397824ULL, 0x040fe200078e0239ULL, 0x0000001035007388ULL, 0x0003e20000000800ULL,
0x000000010e3b7824ULL, 0x040fe400078e023bULL, 0x000000010e0e7824ULL, 0x000fe200078e0233ULL,
0x0000001237007388ULL, 0x0003e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fc600078e001eULL,
0x0000002439007388ULL, 0x0003e80000000800ULL, 0x000000263b007388ULL, 0x0003e80000000800ULL,
0x000000090e007388ULL, 0x0003e80000000800ULL, 0x0004000b2b007388ULL, 0x0003e80000000800ULL,
0x000400152d007388ULL, 0x0003e80000000800ULL, 0x000400172f007388ULL, 0x0003e80000000800ULL,
0x0004001135007388ULL, 0x0003e80000000800ULL, 0x0004001337007388ULL, 0x0003e80000000800ULL,
0x0004002539007388ULL, 0x0003e80000000800ULL, 0x000400273b007388ULL, 0x0003e80000000800ULL,
0x00f000040c008388ULL, 0x0003e80000000c00ULL, 0x00f2001c0c008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000040ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080040ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100040ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000141417810ULL, 0x000fe20007ffe0ffULL,
0x0000180040ff7f8cULL, 0x0003e6000c80043fULL, 0x000000444100720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffbb7000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff1f7807ULL, 0x008fe40004000000ULL,
0x00013ce0001e7802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff077224ULL, 0x000fe200078e0022ULL, 0xfffee6e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004000000ULL, 0x00013d30001e7802ULL, 0x000fc40000000f00ULL,
0x00000c2000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0022ULL,
0xfffee74000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x008fe200078e004bULL,
0x00013d8000497802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff1e7224ULL, 0x004fe200078e0023ULL, 0xfffee80000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e004bULL, 0x00013dd000497802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff1e7224ULL, 0x004fe200078e0023ULL,
0xfffee92000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e0021ULL,
0x00013e3000497802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0018ULL,
0x00000ad000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0023ULL,
0xfffeed3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x000fe200078e0016ULL,
0x00013e9000497802ULL, 0x000fe20000000f00ULL, 0x000000ffff237224ULL, 0x000fc400078e0021ULL,
0x00000a7000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0023ULL,
0xfffeed0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x004fe40004000000ULL,
0x00013ee0001e7802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0022ULL, 0xffff178000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004000000ULL, 0x00013f30001e7802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x018fea0003c00000ULL, 0xffff17e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e004bULL, 0x00013f7000497802ULL, 0x000fc40000000f00ULL,
0x0000099000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0023ULL,
0xffff18c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e004bULL,
0x00013fc000497802ULL, 0x000fc40000000f00ULL, 0x0000094000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0023ULL, 0xffff19d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x0001402000497802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e001dULL, 0x000008e000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0023ULL, 0xffff1de000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x0001407000497802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0023ULL,
0xffff1dc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x004fe40004000000ULL,
0x000140c0001e7802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0022ULL, 0xffff452000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004000000ULL, 0x00014110001e7802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x018fea0003c00000ULL, 0xffff458000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e004bULL, 0x0001415000497802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0023ULL,
0xffff466000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e004bULL,
0x000141a000497802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0023ULL, 0xffff477000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x0001420000497802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e001dULL, 0x0000070000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0023ULL, 0xffff4b8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e001cULL, 0x0001425000497802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0023ULL,
0xffff4b6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x004fe40004000000ULL,
0x000142a0001e7802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0022ULL, 0xffff732000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004000000ULL, 0x000142f0001e7802ULL, 0x000fc40000000f00ULL,
0x0000066000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0022ULL,
0xffff737000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e0011ULL,
0x0001434000497802ULL, 0x000fc40000000f00ULL, 0x000005c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0023ULL, 0xffff744000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e0011ULL, 0x0001439000497802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0023ULL,
0xffff755000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e000cULL,
0x000143f000497802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fc400078e000dULL,
0x0000051000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0023ULL,
0xffff795000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x000fe200078e000cULL,
0x0001444000497802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0023ULL, 0xffff793000007947ULL, 0x000fea000383ffffULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x0001449000307802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0023ULL,
0xffffea9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x006fe200078e0034ULL,
0x000144f000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x000000233400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0006ULL, 0x0001455000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x0000003423347208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000230600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0007ULL, 0x000145b000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x0000000623067208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000230700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0035ULL, 0x0001461000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x0000000723227208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000233500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0034ULL, 0x0001467000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x0000003523047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000233400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0006ULL, 0x000146d000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x0000003423057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000230600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0022ULL, 0x0001473000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x0000000623067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe96000007947ULL, 0x000fea000383ffffULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000600008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000006027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffeb74002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003700007348ULL, 0x000fe80003800000ULL,
0x0c00003332237389ULL, 0x0002a200000e0036ULL, 0xfffeb70030007950ULL, 0x000fea0003c3ffffULL,
0x0000001400007348ULL, 0x000fe80003800000ULL, 0x0000001e23237389ULL, 0x0002a200000e0013ULL,
0x00000000ff1f7424ULL, 0x000fc400078e00ffULL, 0x000000ffff1e7224ULL, 0x002fc800078e0049ULL,
0xfffeb6b01e007950ULL, 0x000fea0003c3ffffULL, 0x000000011f00780cULL, 0x000fe20003f05070ULL,
0x0000001200007348ULL, 0x000fd80003800000ULL, 0x00000000001f7806ULL, 0x000fc800040e0100ULL,
0x000000121f227212ULL, 0x000fe200078ec0ffULL, 0x00000000ff1f7424ULL, 0x000fc800078e00ffULL,
0xfffeb6501e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000360ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d30ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000df0ULL, 0x0000000000000780ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001570ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001610ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001614ULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000014a80ULL, 0x9600001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016280ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000162d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016650ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001610ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014c70ULL, 0x0000000000014c70ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016280ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016650ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 91952;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
