/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001aed0ULL, 0x000000000001ab50ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000018ed0ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000019050ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000019090ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x00000000000190e0ULL, 0x0000000000000120ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019200ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00018ed000000000ULL, 0x0000040400000000ULL, 0x810c000000180400ULL, 0x0063900408288080ULL,
0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8a08288080830828ULL,
0x2880808b08288080ULL, 0x808d082880808c08ULL, 0x082880808f082880ULL, 0x8080920828808090ULL,
0x9608288080930828ULL, 0x288080a808288080ULL, 0x80aa08288080a908ULL, 0x08288080ad082880ULL,
0x8080b808288080b1ULL, 0x8408288080b90828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808084920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x00018ed000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8408288080830828ULL, 0x2880808a08288080ULL, 0x808d082880808b08ULL, 0x082880808e082880ULL,
0x808090082880808fULL, 0x9608288080920828ULL, 0x288080a808288080ULL, 0x80aa08288080a908ULL,
0x08288080ad082880ULL, 0x8080b808288080b1ULL, 0x8c08288080b90828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808c920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000015800000000ULL, 0x0001905000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808a08288080ULL,
0x808c082880808b08ULL, 0x082880808d082880ULL, 0x808090082880808fULL, 0x9308288080920828ULL,
0x2880809608288080ULL, 0x80a908288080a808ULL, 0x08288080aa082880ULL, 0x8080b108288080adULL,
0xb908288080b80828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b9920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000022800000000ULL, 0x0001909000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80b8288080b90900ULL, 0x0000000000002880ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808a08288080ULL,
0x808c082880808b08ULL, 0x082880808d082880ULL, 0x808090082880808fULL, 0x9308288080920828ULL,
0x2880809608288080ULL, 0x80a908288080a808ULL, 0x08288080aa082880ULL, 0x8080b108288080adULL,
0xb808288080b90828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b8920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000030800000000ULL, 0x000190e000000000ULL,
0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000008ULL, 0x000000080000001bULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0058016000000018ULL, 0x000c170400581903ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL,
0x0048000800000000ULL, 0x000c17040021f000ULL, 0x0040000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040061f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0x0000093000043104ULL, 0xffffffff01342904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002d001342804ULL, 0x000005b000000410ULL,
0x000024a000002410ULL, 0x00002720000025c0ULL, 0x00002bb000002b80ULL, 0x00002c9000002c20ULL,
0x00005a90000059f0ULL, 0x00005d1000005bb0ULL, 0x000061b000006180ULL, 0x0000629000006220ULL,
0x0000904000008fb0ULL, 0x000092d000009170ULL, 0x0000978000009750ULL, 0x00009860000097f0ULL,
0x0000c5500000c4b0ULL, 0x0000c7d00000c670ULL, 0x0000ccb00000cc80ULL, 0x0000cd900000cd20ULL,
0x0000ee800000ee70ULL, 0x00017400000173c0ULL, 0x0001742000017410ULL, 0x0001749000017430ULL,
0x000174d0000174b0ULL, 0x000181f0000181a0ULL, 0x000182c000018260ULL, 0x000183a000018330ULL,
0x0001845000018400ULL, 0x00018520000184c0ULL, 0x0001860000018590ULL, 0x000186b000018660ULL,
0x0001878000018720ULL, 0x00018860000187f0ULL, 0x00018910000188c0ULL, 0x000189e000018980ULL,
0x00018ac000018a50ULL, 0x00018bb000018b30ULL, 0x00018cb000018c30ULL, 0x00018db000018d30ULL,
0x00018eb000018e30ULL, 0x000003a004403904ULL, 0x00017600000000ffULL, 0x00000450003f0100ULL,
0x000176080000000dULL, 0x000004e0003f0120ULL, 0x000176880000000dULL, 0x00000530003f0120ULL,
0x000176a80000000dULL, 0x00000590003f0120ULL, 0x000176c80000000dULL, 0x00000940003f0120ULL,
0x00017600000000ffULL, 0x00000aa0003f0107ULL, 0x0001768c00000010ULL, 0x00000b30003f0102ULL,
0x0001768800000010ULL, 0x00001360003f0101ULL, 0x00000000000000ffULL, 0x000013e000040107ULL,
0x00000000000000ffULL, 0x0000144000040101ULL, 0x0000002000000008ULL, 0x000015a0003f0101ULL,
0x000176cc00000007ULL, 0x00001780003f0105ULL, 0x000176cc00000007ULL, 0x00001fe0003f0105ULL,
0x000176b000000004ULL, 0x00002080003f0107ULL, 0x000176b000000004ULL, 0x000020e0003f0101ULL,
0x000176080000001aULL, 0x00002120003f0101ULL, 0x0001760c0000000dULL, 0x00002300003f0105ULL,
0x0001760c0000000dULL, 0x000028e0003f0105ULL, 0x000176ac0000001aULL, 0x00002ab0003f0105ULL,
0x000176ac0000001aULL, 0x00004c60003f0105ULL, 0x0000000000000038ULL, 0x00004cc0003f0101ULL,
0x0001768800000003ULL, 0x00004cf0003f0101ULL, 0x000000040000000fULL, 0x00004eb0003f0105ULL,
0x000000040000000fULL, 0x00005600003f0105ULL, 0x00000000000000ffULL, 0x000056d000040107ULL,
0x00000000000000ffULL, 0x0000573000040101ULL, 0x0001762800000003ULL, 0x00005750003f0101ULL,
0x0001762c0000000dULL, 0x00005920003f0105ULL, 0x0001762c0000000dULL, 0x00005ee0003f0105ULL,
0x000176b40000003bULL, 0x000060b0003f0105ULL, 0x000176b40000003bULL, 0x00008210003f0105ULL,
0x0000000000000012ULL, 0x00008270003f0101ULL, 0x000176900000006fULL, 0x000082a0003f0101ULL,
0x000000040000000fULL, 0x00008460003f0105ULL, 0x000000040000000fULL, 0x00008bc0003f0105ULL,
0x00000008000000ffULL, 0x00008c5000040107ULL, 0x000176b000000040ULL, 0x00008cb0003f0101ULL,
0x000176480000000dULL, 0x00008d10003f0101ULL, 0x0001764c0000000dULL, 0x00008ee0003f0105ULL,
0x0001764c0000000dULL, 0x000094b0003f0105ULL, 0x000176ac0000001bULL, 0x00009680003f0105ULL,
0x000176ac0000001bULL, 0x0000b6e0003f0105ULL, 0x000000000000000fULL, 0x0000b740003f0101ULL,
0x0000000000000000ULL, 0x0000b770003f0101ULL, 0x000000040000000fULL, 0x0000b930003f0105ULL,
0x000000040000000fULL, 0x0000c0d0003f0105ULL, 0x00000000000000ffULL, 0x0000c1a000040107ULL,
0x00000000000000ffULL, 0x0000c20000040101ULL, 0x0001766800000000ULL, 0x0000c230003f0101ULL,
0x0001766c00000000ULL, 0x0000c400003f0105ULL, 0x0001766c00000000ULL, 0x0000c9a0003f0105ULL,
0x000176b400000036ULL, 0x0000cba0003f0105ULL, 0x000176b400000036ULL, 0x0000ec40003f0105ULL,
0x000000000000000fULL, 0x0000ecc0003f0101ULL, 0x0000000000000007ULL, 0x0000fe30003f0101ULL,
0x00017600000000ffULL, 0x00011640003f0101ULL, 0x00017604000000ffULL, 0x00011810003f0105ULL,
0x00017604000000ffULL, 0x00011a40003f0105ULL, 0x00017600000000ffULL, 0x00011a70003f0101ULL,
0x00017604000000ffULL, 0x00011c30003f0105ULL, 0x00017604000000ffULL, 0x00015940003f0105ULL,
0x000000000000007cULL, 0x000159d0003f0101ULL, 0x000000040000007cULL, 0x00015ba0003f0105ULL,
0x000000040000007cULL, 0x00017fe0003f0105ULL, 0x000000000000007dULL, 0x00018040003f0101ULL,
0x000000080000007dULL, 0x000180a0003f0101ULL, 0x000000100000007dULL, 0x00018110003f0101ULL,
0x000000180000007dULL, 0x00053803003f0101ULL, 0x0000f74000201c04ULL, 0x0000f9900000f780ULL,
0x0000fc800000faf0ULL, 0x00011c900000fd80ULL, 0x0000040100018160ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000003c4ULL, 0x0000001b00000002ULL, 0x00000000000002e4ULL, 0x0000001b00000002ULL,
0x0000000000000214ULL, 0x0000001b00000002ULL, 0x000000000000012cULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x000000000000039aULL, 0x0000001b00000002ULL,
0x00000000000002baULL, 0x0000001b00000002ULL, 0x00000000000001eaULL, 0x0000001b00000002ULL,
0x0000000000000102ULL, 0x0000001b00000002ULL, 0x0000000000017700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0xfffffff801017810ULL, 0x000fe20007ffe0ffULL, 0x00005a0000057ab9ULL, 0x000fe20000000800ULL,
0x00000000000b7919ULL, 0x000ee20000002300ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x00000000000c7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff0a7819ULL, 0x010fc80000011609ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x010fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000006037d7227ULL, 0x004fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a7dULL,
0x0000000007007224ULL, 0x000fca00078e0206ULL, 0x000000070000720cULL, 0x000fe20003f66070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000fe400000e0000ULL,
0x00000000020d7a24ULL, 0x000fca00078e0209ULL, 0x000000ff0d00720cULL, 0x000fc60003f45270ULL,
0x0000000100003824ULL, 0x000fe200078e0a07ULL, 0x000000017d7d3810ULL, 0x000fe40007ffe0ffULL,
0x0000007f0d00780cULL, 0x040fe40003f04070ULL, 0x000000070000720cULL, 0x000fe40003f86070ULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000030d00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL,
0xff317217ff108424ULL, 0x000fe400078e00ffULL, 0x000000017d7d4810ULL, 0x000fe20007ffe0ffULL,
0x01760002ff00a388ULL, 0x0003e20000000a00ULL, 0x00000007ff7dd212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f84070ULL,
0x017400100d008388ULL, 0x000fe20000004800ULL, 0x7fffffc0ff059424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe200078e0a7dULL, 0x00001fff0a027589ULL, 0x0004e200000e0000ULL,
0x3fffff80ff08b424ULL, 0x000fe200078e00ffULL, 0x00005a007d037a19ULL, 0x002fe200000006ffULL,
0x00000000070f7224ULL, 0x000fe200078e0206ULL, 0x017608040d009388ULL, 0x0003e20000008a00ULL,
0x3fffff60ff06b424ULL, 0x000fc400078e00ffULL, 0x000000100f747824ULL, 0x000fe200078e00ffULL,
0x0000040f01007387ULL, 0x0009e20000100800ULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x00005a000e0a7a19ULL, 0x004fe200000006ffULL, 0x7fffff80ff09b424ULL, 0x000fe200078e00ffULL,
0x0000000474007c10ULL, 0x040fe4000fffe1ffULL, 0x0000000474007c0cULL, 0x000fe2000bf03070ULL,
0x017688060d00b388ULL, 0x0007e20000008a00ULL, 0x0000001000007817ULL, 0x000fe20003800000ULL,
0x3fffffc0ff04c424ULL, 0x002fc400078e00ffULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x000000ff000f7207ULL, 0x010fe20000000000ULL, 0x0176a8080d00b388ULL, 0x000fe20000008a00ULL,
0x000058000c007a24ULL, 0x000fe400078e02ffULL, 0x000000100f00780cULL, 0x000fe20003f05270ULL,
0x0000000f01007387ULL, 0x000fe20000100800ULL, 0x0000000a00007224ULL, 0x000fe400078e0203ULL,
0x000000040b067824ULL, 0x008fe200078e0202ULL, 0x0176c8040d00c388ULL, 0x000fe60000008a00ULL,
0x0000000206067824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000001d000008947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fc40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff077819ULL, 0x002fca0000011611ULL,
0x0000000106087824ULL, 0x000fc800078e0207ULL, 0x0000000174037824ULL, 0x000fca00078e0208ULL,
0x0000000403057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff047a19ULL, 0x000fe40000011603ULL,
0x000000060f037217ULL, 0x000fe20007800000ULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x0000001011007824ULL, 0x000fe400078e00ffULL, 0x0000000a04047224ULL, 0x000fe400078e0205ULL,
0x0000000103037824ULL, 0x000fe200078e0a06ULL, 0x000000f000097812ULL, 0x000fe200078ec0ffULL,
0x0000010004047825ULL, 0x000fc600078e00ffULL, 0x000000030700720cULL, 0x000fe20003f06070ULL,
0x0000000108037824ULL, 0x000fe200078e0211ULL, 0x0000000904097212ULL, 0x000fe200078efcffULL,
0x0000001008087824ULL, 0x000fc600078e00ffULL, 0x00005e0009047a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff008037812ULL, 0x000fe400078ee203ULL, 0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL,
0x0000001003037824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000c101c48ULL, 0x0000018000007947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000611067211ULL, 0x002fca00078fe0ffULL, 0x0000000174037824ULL, 0x000fca00078e0206ULL,
0x0000000403057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff037a19ULL, 0x000fc60000011603ULL,
0x0000000100007824ULL, 0x000fc800078e0205ULL, 0x0000000a03037224ULL, 0x000fe400078e0200ULL,
0x0000001011007824ULL, 0x000fe400078e00ffULL, 0x0000010003047825ULL, 0x000fc600078e00ffULL,
0x000000f000077812ULL, 0x000fe200078ec0ffULL, 0x0000000106037824ULL, 0x040fe400078e0211ULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000704047212ULL, 0x000fc800078efcffULL,
0xfffffff006037812ULL, 0x000fe400078ee203ULL, 0x00005e0004047a10ULL, 0x000fc60007f1e0ffULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x00005f0005057a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e8000b901c48ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000037806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000300047300ULL, 0x000e7000000e0000ULL,
0x0000000300067309ULL, 0x000ea20000000000ULL, 0x000000050400720cULL, 0x002fe20003f02070ULL,
0x00000004ff057424ULL, 0x000fc400078e00ffULL, 0x000000ffff067224ULL, 0x004fe400078e0a06ULL,
0x000064000c047625ULL, 0x000fd000078e0005ULL, 0x01760406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000804777981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0b00720cULL, 0x000fe40003f05270ULL,
0x000000ff77037810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff7a7819ULL, 0x000fce0000011603ULL,
0x0000f32000008947ULL, 0x000fea0003800000ULL, 0x0000000802107824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01768c0510ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0300780cULL, 0x000fe20003f04070ULL, 0x000000020c047824ULL, 0x000fe200078e00ffULL,
0x00000001ff787819ULL, 0x000fe20000011602ULL, 0x0176880010ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000102797812ULL, 0x000fe200078ec0ffULL, 0x0000590004047624ULL, 0x000fe400078e020eULL,
0x0000002078077824ULL, 0x000fc400078e00ffULL, 0x000000017d7b7824ULL, 0x000fc800078e0204ULL,
0x000066007b037a24ULL, 0x000fe200078e0207ULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000000777047217ULL, 0x008fe20007800000ULL, 0x0000001079057824ULL, 0x004fe200078e00ffULL,
0x00000003ff067819ULL, 0x002fc60000011611ULL, 0x0000000104047824ULL, 0x000fe200078e0a07ULL,
0x0000000406097810ULL, 0x040fe20007ffe0ffULL, 0x0000000105087824ULL, 0x000fe200078e0206ULL,
0x0000000c060b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000504047217ULL, 0x000fe20007800000ULL,
0x0000000108077824ULL, 0x040fe400078e0211ULL, 0x00000008080c7824ULL, 0x000fe400078e00ffULL,
0x0000000104047824ULL, 0x000fc400078e0a05ULL, 0x0000000103087824ULL, 0x000fe200078e0208ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x00000001050e7824ULL, 0x040fe200078e020bULL,
0x0000000806077810ULL, 0x040fe40007ffe0ffULL, 0x000000040600720cULL, 0x080fe20003f66070ULL,
0x0000000105067824ULL, 0x000fe200078e0209ULL, 0x000000040900720cULL, 0x080fe20003f46070ULL,
0x00000001050a7824ULL, 0x000fe200078e0207ULL, 0x000000040700720cULL, 0x080fe20003f26070ULL,
0x0000000103077824ULL, 0x000fe200078e0206ULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x0000008008047825ULL, 0x000fc800078e00ffULL, 0x0000000106087824ULL, 0x100fe200078e0211ULL,
0x00000070040b7812ULL, 0x000fe200078ef800ULL, 0x00000008060d7824ULL, 0x000fe400078e00ffULL,
0x0000000103067824ULL, 0x040fe400078e020aULL, 0x0000000103097824ULL, 0x000fe400078e020eULL,
0x000000010a037824ULL, 0x140fe400078e0211ULL, 0x000000080a127824ULL, 0x000fe200078e00ffULL,
0x000062000b0a7a10ULL, 0x000fe20007f9e0ffULL, 0x000000010e047824ULL, 0x000fc400078e0211ULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0x00006300050b7a10ULL, 0x000fe400027fe4ffULL,
0xfffffff80d0e7812ULL, 0x000fe200078ee208ULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0xfffffff80f147812ULL, 0x000fe400078ee204ULL, 0xfffffff812127812ULL, 0x000fe200078ee203ULL,
0x0000008007047825ULL, 0x000fe200078e00ffULL, 0x0001300078037811ULL, 0x000fc600078e68ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fc600078ef800ULL,
0x000000100c0d7824ULL, 0x100fe200078e0203ULL, 0x0000007006067812ULL, 0x100fe200078ef800ULL,
0x000000100e0f7824ULL, 0x100fe200078e0203ULL, 0x0000007008007812ULL, 0x000fe200078ef800ULL,
0x0000001012137824ULL, 0x100fe200078e0203ULL, 0x0000620004047a10ULL, 0x000fe20007f9e0ffULL,
0x0000001014037824ULL, 0x000fe200078e0203ULL, 0x0000620006067a10ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000d901c48ULL,
0x0000620000087a10ULL, 0x000fe40007fde0ffULL, 0x0000630005057a10ULL, 0x000fc400027fe4ffULL,
0x0000630007077a10ULL, 0x000fe40002ffe4ffULL, 0x0000630009097a10ULL, 0x000fe200037fe4ffULL,
0x00000000040f7faeULL, 0x0003e8000d101c48ULL, 0x0000000006137faeULL, 0x0003e8000c901c48ULL,
0x0000000008037faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001079047824ULL, 0x008fe200078e00ffULL, 0x0001300078137811ULL, 0x000fc800078e68ffULL,
0x0000000411047211ULL, 0x000fc800078fe8ffULL, 0x0000000404087810ULL, 0x040fe20007ffe0ffULL,
0x0000000103057824ULL, 0x004fe200078e0204ULL, 0x00000008040a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000104067824ULL, 0x042fe200078e0211ULL, 0x0000000c040e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000804077824ULL, 0x000fe400078e00ffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff8070c7812ULL, 0x000fe200078ee206ULL, 0x0000000103067824ULL, 0x040fe200078e0208ULL,
0x00000070040b7812ULL, 0x000fe200078ef800ULL, 0x0000000108077824ULL, 0x040fe400078e0211ULL,
0x0000000808127824ULL, 0x000fe400078e00ffULL, 0x0000000103087824ULL, 0x040fe400078e020aULL,
0x0000000103097824ULL, 0x000fe200078e020eULL, 0xfffffff8120d7812ULL, 0x000fe200078ee207ULL,
0x000000010a037824ULL, 0x000fc400078e0211ULL, 0x000000080a147824ULL, 0x000fe200078e00ffULL,
0x000062000b0a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000010e047824ULL, 0x040fe400078e0211ULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0x00006300050b7a10ULL, 0x000fe200007fe4ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0213ULL, 0xfffffff8140e7812ULL, 0x000fe200078ee203ULL,
0x000000100c037824ULL, 0x000fe200078e0213ULL, 0xfffffff80f127812ULL, 0x000fe200078ee204ULL,
0x0000008006047825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a037faeULL, 0x0003e2000b901c48ULL, 0x0000008008067825ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fc600078ef800ULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x100fe400078ef800ULL, 0x0000620004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000100e0f7824ULL, 0x100fe200078e0213ULL, 0x0000007008007812ULL, 0x000fe200078ef800ULL,
0x0000001012137824ULL, 0x000fe200078e0213ULL, 0x0000620006067a10ULL, 0x000fe40007f3e0ffULL,
0x0000620000087a10ULL, 0x000fe40007f5e0ffULL, 0x0000630005057a10ULL, 0x000fc400007fe4ffULL,
0x0000630007077a10ULL, 0x000fe40000ffe4ffULL, 0x0000630009097a10ULL, 0x000fe200017fe4ffULL,
0x00000000040d7faeULL, 0x0003e8000b901c48ULL, 0x00000000060f7faeULL, 0x0003e8000b901c48ULL,
0x0000000008137faeULL, 0x0003e4000b901c48ULL, 0x00000000780473c2ULL, 0x000ea200000e0000ULL,
0x000000ff7a00720cULL, 0x000fe20003f05270ULL, 0x000000ffff067224ULL, 0x002fe200078e00ffULL,
0x000176a878087811ULL, 0x000fe200078e18ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000176a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff047f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200008087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000d81000008947ULL, 0x000fea0003800000ULL, 0x000000ffff007224ULL, 0x004fe200078e0009ULL,
0x00000002ff7c7819ULL, 0x000fe20000011602ULL, 0x000000ffff037224ULL, 0x002fc400078e0005ULL,
0xff317217ff097424ULL, 0x000fe400078e00ffULL, 0x000000ffff667224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400078e00ffULL, 0x000000ffff127224ULL, 0x02afca00078e00ffULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x0000000402077824ULL, 0x000fca00078e00ffULL,
0xfffffff807077812ULL, 0x000fc800078ec0ffULL, 0x000176c807087810ULL, 0x000fe20007ffe0ffULL,
0x0176cc00070d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0008ULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e040e7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e05ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc8000001140fULL, 0x0000000e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e060fULL, 0x000000020d0d7819ULL, 0x000fc8000000120eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176cc00070d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0008ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000166057810ULL, 0x000fe20007ffe0ffULL,
0x0000002078007824ULL, 0x000fc600078e00ffULL, 0x0000007a0500720cULL, 0x000fe20003f26070ULL,
0x00000100660e7824ULL, 0x000fca00078e0200ULL, 0x000000400e047810ULL, 0x000fca0007ffe0ffULL,
0x000066007b1a7a24ULL, 0x000fe400078e0204ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000000477007217ULL, 0x000fe20007800000ULL, 0x0000001079057824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc60000011611ULL, 0x0000000100007824ULL, 0x000fe200078e0a04ULL,
0x0000000407127810ULL, 0x000fe20007ffe0ffULL, 0x0000000105047824ULL, 0x000fe200078e0207ULL,
0x0000000807137810ULL, 0x000fe40007ffe0ffULL, 0x0000000005007217ULL, 0x000fe20007800000ULL,
0x0000000104087824ULL, 0x040fe200078e0211ULL, 0x0000000c07187810ULL, 0x000fe20007ffe0ffULL,
0x00000008040d7824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fc400078e0a05ULL,
0x0000000104047824ULL, 0x000fe200078e021aULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL,
0x0000001011087824ULL, 0x000fe200078e00ffULL, 0x000000001200720cULL, 0x080fe20003f66070ULL,
0x0000000105127824ULL, 0x000fe200078e0212ULL, 0x000000000700720cULL, 0x080fe20003f86070ULL,
0x0000000105197824ULL, 0x000fe200078e0218ULL, 0x000000001300720cULL, 0x080fe20003f46070ULL,
0x0000000112077824ULL, 0x000fe200078e0211ULL, 0x000000001800720cULL, 0x000fe20003f06070ULL,
0x0000000812387824ULL, 0x000fc400078e00ffULL, 0x0000000105137824ULL, 0x000fe400078e0213ULL,
0x0000000112127824ULL, 0x100fe200078e021aULL, 0xfffffff838397812ULL, 0x000fe200078ee207ULL,
0x0000000113187824ULL, 0x000fe200078e021aULL, 0x0000007008077812ULL, 0x000fe200078ec0ffULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000113007824ULL, 0x140fe200078e0211ULL,
0x0000000704047212ULL, 0x080fe200078efcffULL, 0x00000008133b7824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000620004047a10ULL, 0x000fe40007fbe0ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee200ULL, 0x00000001191a7824ULL, 0x040fe200078e021aULL,
0x0000000712127212ULL, 0x000fe200078efcffULL, 0x0000000119087824ULL, 0x040fe200078e0211ULL,
0x0001400078007811ULL, 0x000fe200078e68ffULL, 0x00000008193d7824ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe20007fde0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000630005057a10ULL, 0x000fc40002ffe4ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee208ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000718187212ULL, 0x080fe400078efcffULL,
0x0000630013137a10ULL, 0x000fe400037fe4ffULL, 0x000000071a1a7212ULL, 0x000fe200078efcffULL,
0x000000100d077824ULL, 0x100fe200078e0200ULL, 0x0000620018187a10ULL, 0x000fe20007fbe0ffULL,
0x00000010390d7824ULL, 0x100fe200078e0200ULL, 0x000062001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x000000103b397824ULL, 0x100fe200078e0200ULL, 0x0000630019197a10ULL, 0x000fe20002ffe4ffULL,
0x000000103d3b7824ULL, 0x000fe200078e0200ULL, 0x000063001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000e101c48ULL,
0x00000000120d7faeULL, 0x0003e8000d901c48ULL, 0x0000000018397faeULL, 0x0003e8000d101c48ULL,
0x000000001a3b7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001079007824ULL, 0x000fe400078e00ffULL, 0x0000001011047824ULL, 0x000fc600078e00ffULL,
0x0000000011007211ULL, 0x000fe400078fe8ffULL, 0x0000007004397812ULL, 0x000fe400078ec0ffULL,
0x0000000c00137810ULL, 0x040fe20007ffe0ffULL, 0x0000000100057824ULL, 0x140fe200078e0211ULL,
0x00000008000d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000800087824ULL, 0x040fe400078e00ffULL,
0x0000000100047824ULL, 0x000fe400078e021aULL, 0x0000000113197824ULL, 0x000fe200078e0211ULL,
0xfffffff808077812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000000400087810ULL, 0x000fc60007ffe0ffULL, 0x0000000813387824ULL, 0x000fe200078e00ffULL,
0x0000003904047212ULL, 0x000fe200078efcffULL, 0x0000000108127824ULL, 0x140fe400078e021aULL,
0x0000000108007824ULL, 0x000fe200078e0211ULL, 0xfffffff8383d7812ULL, 0x000fe200078ee219ULL,
0x00000008081b7824ULL, 0x000fe200078e00ffULL, 0x0000620004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000010d187824ULL, 0x100fe400078e021aULL, 0x00000001131a7824ULL, 0x000fe200078e021aULL,
0x0000630005057a10ULL, 0x000fe200007fe4ffULL, 0x000000010d087824ULL, 0x000fc400078e0211ULL,
0x000000080d3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b0d7812ULL, 0x000fe200078ee200ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0001400078007811ULL, 0x000fe400078e68ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee208ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003912127212ULL, 0x000fc600078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000003918187212ULL, 0x080fe400078efcffULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x0000001007077824ULL, 0x100fe200078e0200ULL, 0x000000391a1a7212ULL, 0x000fe200078efcffULL,
0x000000100d0d7824ULL, 0x100fe200078e0200ULL, 0x0000620018187a10ULL, 0x000fe20007f5e0ffULL,
0x000000103b397824ULL, 0x100fe200078e0200ULL, 0x000062001a1a7a10ULL, 0x000fe20007f7e0ffULL,
0x000000103d3b7824ULL, 0x000fe200078e0200ULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000b901c48ULL,
0x0000630019197a10ULL, 0x000fc400017fe4ffULL, 0x000063001b1b7a10ULL, 0x000fe20001ffe4ffULL,
0x00000000120d7faeULL, 0x0003e8000b901c48ULL, 0x0000000018397faeULL, 0x0003e8000b901c48ULL,
0x000000001a3b7faeULL, 0x0003e4000b901c48ULL, 0xfffffff010047812ULL, 0x042fe400078ec0ffULL,
0xffffffe010007812ULL, 0x000fc400078ec0ffULL, 0x00000000040573c2ULL, 0x000e6200000e0000ULL,
0x0000001010057812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fe400078e0205ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008791a7824ULL, 0x000fe200078e0200ULL,
0x000176b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176b00004047f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017608001a1a7f8cULL, 0x000ea4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x0000000810077812ULL, 0x000fca00078ec0ffULL, 0x00000001000d7824ULL, 0x000fca00078e0207ULL,
0x01760c000d077984ULL, 0x000ee40000000800ULL, 0x8000000007ff7812ULL, 0x00cfe4000780481bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001812077210ULL, 0x000fca0007f1e1ffULL, 0x0000000119187824ULL, 0x000fe200000e0e13ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff1800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff1800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011418ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0618ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01760c000d077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001011607824ULL, 0x000fe200078e00ffULL, 0x00000001ff757819ULL, 0x000fe20000011611ULL,
0x0000002002007824ULL, 0x000fc600078e00ffULL, 0x0000007060607812ULL, 0x000fe400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c75757812ULL, 0x000fc800078ec0ffULL,
0x0000000075007210ULL, 0x000fca0007ffe060ULL, 0x0170000000087984ULL, 0x000ea80000000800ULL,
0x0172000000077984ULL, 0x0006620000000800ULL, 0x000000090800720bULL, 0x004fe20003f1d000ULL,
0x00015d627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff131b7812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fd200078e0009ULL,
0x0000043000008947ULL, 0x000fea0003800000ULL, 0x000000027c00720cULL, 0x000fe40003f05270ULL,
0x000000090800720bULL, 0x000fe20003f54000ULL, 0x00015d227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000127806ULL, 0x000fc400010e0100ULL, 0x00000080021a8824ULL, 0x000fe200078e0260ULL,
0x0000000908007209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991012197816ULL, 0x000fe200000000ffULL, 0x0000000175138824ULL, 0x000fca00078e021aULL,
0x0174000013008388ULL, 0x0005e20000000800ULL, 0x000000ff1900720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000900097221ULL, 0x004fe20000010100ULL,
0x000000ff12ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009001a7308ULL, 0x000ea40000000800ULL,
0x0000001a06067220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011611ULL, 0x00015c627f007947ULL, 0x000fea000b800000ULL,
0x00001f131a137589ULL, 0x0004e400000e0000ULL, 0x0000001334347220ULL, 0x08cfe40000410000ULL,
0x0000001335357220ULL, 0x080fe40000410000ULL, 0x0000001330307220ULL, 0x080fe40000410000ULL,
0x0000001331317220ULL, 0x080fe40000410000ULL, 0x000000132c2c7220ULL, 0x080fe40000410000ULL,
0x000000132d2d7220ULL, 0x000fc40000410000ULL, 0x0000001328287220ULL, 0x080fe40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x0000001324247220ULL, 0x080fe40000410000ULL,
0x0000001325257220ULL, 0x080fe40000410000ULL, 0x0000001320207220ULL, 0x080fe40000410000ULL,
0x0000001321217220ULL, 0x000fc40000410000ULL, 0x000000131c1c7220ULL, 0x080fe40000410000ULL,
0x000000131d1d7220ULL, 0x080fe40000410000ULL, 0x0000001314147220ULL, 0x080fe40000410000ULL,
0x0000001315157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0012ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000811137811ULL, 0x000fe200078ff0ffULL, 0x00015b627f007947ULL, 0x000fea000b800000ULL,
0x00001f131a137589ULL, 0x0004e400000e0000ULL, 0x0000001336367220ULL, 0x08cfe40000410000ULL,
0x0000001337377220ULL, 0x080fe40000410000ULL, 0x0000001332327220ULL, 0x080fe40000410000ULL,
0x0000001333337220ULL, 0x080fe40000410000ULL, 0x000000132e2e7220ULL, 0x080fe40000410000ULL,
0x000000132f2f7220ULL, 0x000fc40000410000ULL, 0x000000132a2a7220ULL, 0x080fe40000410000ULL,
0x000000132b2b7220ULL, 0x080fe40000410000ULL, 0x0000001326267220ULL, 0x080fe40000410000ULL,
0x0000001327277220ULL, 0x080fe40000410000ULL, 0x0000001322227220ULL, 0x080fe40000410000ULL,
0x0000001323237220ULL, 0x000fc40000410000ULL, 0x000000131e1e7220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x080fe40000410000ULL, 0x0000001316167220ULL, 0x080fe40000410000ULL,
0x0000001317177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1bff7812ULL, 0x000fda0007806012ULL, 0x8000000008080221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b08080820ULL, 0x000fc80000410000ULL,
0x00000008000c0308ULL, 0x000ea40000000800ULL, 0x0000000c07070220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000607067221ULL, 0x002fc40000010000ULL,
0x0000000000087805ULL, 0x000fca0000015200ULL, 0xfffffff0101a7812ULL, 0x000fca00078ec0ffULL,
0x0176ac001a127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001208127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e09ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011413ULL,
0x0000001207077211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000207077819ULL, 0x000fc80000001212ULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000119197810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac001a127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991018037816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f65270ULL, 0x0000016000003947ULL, 0x000fea0003800000ULL,
0x0000000cff03723eULL, 0x000fe400000010ffULL, 0x00000002ff087819ULL, 0x000fe40000011611ULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x000157627f007947ULL, 0x000fea000b800000ULL,
0x00001f08030b7589ULL, 0x0002a400000e0000ULL, 0x0000000808137810ULL, 0x000fe20007ffe0ffULL,
0x000157b27f007947ULL, 0x000fea000b800000ULL, 0x00001f13030a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001008137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x00002c3000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0001646000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001808137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e0003ULL,
0x00002ca000397802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x000163f000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000711037812ULL, 0x00afe200078ec0ffULL,
0x0000020002097824ULL, 0x000fe200078e00ffULL, 0x00000004ff527819ULL, 0x100fe20000011611ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000803637812ULL, 0x000fe400078ef811ULL,
0xfffff80009097812ULL, 0x000fe200078ec0ffULL, 0x0000000478087824ULL, 0x000fe400078e0252ULL,
0x0000000863387824ULL, 0x040fe400078e00ffULL, 0x00000001634b7824ULL, 0x000fe200078e0208ULL,
0x0000000811087812ULL, 0x000fc800078ec0ffULL, 0xfffffff838387812ULL, 0x000fca00078ee24bULL,
0x0000001038387824ULL, 0x000fc400078e0209ULL, 0x00000003083d7212ULL, 0x040fe200078efcffULL,
0x0000000479527824ULL, 0x000fe200078e0252ULL, 0x0000001008087812ULL, 0x000fe400078efe03ULL,
0x00013000786e7811ULL, 0x000fe200078e68ffULL, 0x000000013d3c7824ULL, 0x000fe200078e0252ULL,
0x000000024b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000083d077824ULL, 0x000fe400078e00ffULL,
0x0000000152527824ULL, 0x000fe400078e0208ULL, 0x0000000808037824ULL, 0x000fe200078e00ffULL,
0xfffffff807077812ULL, 0x000fc400078ee23cULL, 0x000000023c3c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff803037812ULL, 0x000fe200078ee252ULL, 0x0000001007077824ULL, 0x000fc800078e026eULL,
0x0000001003187824ULL, 0x000fe200078e026eULL, 0x000000000740783bULL, 0x000e6a0000004200ULL,
0x000000001818783bULL, 0x000ee20000004200ULL, 0x00000018ff137819ULL, 0x006fe20000011442ULL,
0x0000004000577306ULL, 0x000fe20000009400ULL, 0x00000018ff3a7819ULL, 0x000fe40000011443ULL,
0x00000018ff037819ULL, 0x000fc40000011440ULL, 0x00000018ff3f7819ULL, 0x008fe40000011419ULL,
0x00000018ff077819ULL, 0x000fe20000011441ULL, 0x0000001300507306ULL, 0x000fe20000209400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001141aULL, 0x00000018ff4e7819ULL, 0x000fca000001141bULL,
0x00000013003b7306ULL, 0x000ff00000205400ULL, 0x00000013005d7306ULL, 0x000ff0000020d400ULL,
0x0000003f005c7306ULL, 0x000ff00000209400ULL, 0x0000003f00447306ULL, 0x000ff00000205400ULL,
0x0000003f00137306ULL, 0x0003f0000020d400ULL, 0x0000003a00567306ULL, 0x000fe20000209400ULL,
0x000000083d3f7824ULL, 0x002fc400078e00ffULL, 0x00000100413d7824ULL, 0x000fca00078e00ffULL,
0x0000003a004f7306ULL, 0x000fe20000205400ULL, 0x00000018ff687819ULL, 0x000fe4000001143dULL,
0xfffffff83f3d7812ULL, 0x000fca00078ee23cULL, 0x0000003a00597306ULL, 0x0003e2000020d400ULL,
0x000000103d3d7824ULL, 0x000fce00078e026eULL, 0x00000040005e7306ULL, 0x000ea20000005400ULL,
0x00000100403a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143aULL,
0x0000004000547306ULL, 0x0002f0000000d400ULL, 0x0000003e003a7306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x002fe200078e00ffULL, 0x0000005e5700720bULL, 0x004fc80003fbd000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000003e006b7306ULL, 0x000e6e0000205400ULL,
0x0000000154545812ULL, 0x008fe200078efcffULL, 0x0000003e00657306ULL, 0x0004f0000020d400ULL,
0x0000000300747306ULL, 0x000fe20000209400ULL, 0x000000003d3c783bULL, 0x004ea20000004200ULL,
0x0000006b3a00720bULL, 0x002fcc0003f5d000ULL, 0x0000000300697306ULL, 0x000e6e0000205400ULL,
0x0000000165652812ULL, 0x008fe200078efcffULL, 0x00000007005b7306ULL, 0x000fe60000209400ULL,
0x000000546554723eULL, 0x000fca00000010ffULL, 0x00000007004c7306ULL, 0x000ee20000205400ULL,
0x000000697400720bULL, 0x002fce0003fdd000ULL, 0x0000000700517306ULL, 0x000e70000020d400ULL,
0x0000004d00467306ULL, 0x000fe20000209400ULL, 0x0000004c5b00720bULL, 0x008fe40003f9d000ULL,
0x00000018ff6b7819ULL, 0x004fc4000001143dULL, 0x00000018ff717819ULL, 0x000fc6000001143fULL,
0x0000004d00487306ULL, 0x000fec0000205400ULL, 0x0000000151514812ULL, 0x002fe400078efcffULL,
0x0000004d00077306ULL, 0x000ff0000020d400ULL, 0x00000040004d7306ULL, 0x000ff00000209400ULL,
0x0000004000727306ULL, 0x000e700000205400ULL, 0x0000004100397306ULL, 0x000ff00000009400ULL,
0x00000041005a7306ULL, 0x000ea20000005400ULL, 0x000000724d00720bULL, 0x002fce0003f5d000ULL,
0x00000068005f7306ULL, 0x000ff00000209400ULL, 0x0000006800627306ULL, 0x000e620000205400ULL,
0x0000005a3900720bULL, 0x004fce0003f1d000ULL, 0x0000004100557306ULL, 0x0004f0000000d400ULL,
0x0000000300537306ULL, 0x0008e2000020d400ULL, 0x0001000041417824ULL, 0x004fe200078e00ffULL,
0x000000625f00720bULL, 0x002fe20003fbd000ULL, 0x000001003c5f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000040006a7306ULL, 0x0002a2000020d400ULL,
0x00000018ff037819ULL, 0x010fe40000011418ULL, 0x0000000155550812ULL, 0x008fe400078efcffULL,
0x0000003b5000720bULL, 0x000fc60003f1d000ULL, 0x0000000300127306ULL, 0x000fe20000209400ULL,
0x0000010042407824ULL, 0x002fe200078e00ffULL, 0x0000000153536812ULL, 0x000fc800078efcffULL,
0x00000018ff6d7819ULL, 0x000fe20000011440ULL, 0x0000010043407824ULL, 0x000fe200078e00ffULL,
0x00000003004a7306ULL, 0x000fe20000205400ULL, 0x000000016a6a2812ULL, 0x004fe400078efcffULL,
0x000000015d5d0812ULL, 0x000fe400078efcffULL, 0x00000018ff6f7819ULL, 0x000fc60000011440ULL,
0x0000000300457306ULL, 0x000ff0000020d400ULL, 0x0000004e00477306ULL, 0x000ff00000209400ULL,
0x0000004e00497306ULL, 0x000ff00000205400ULL, 0x0000004e00037306ULL, 0x000ff0000020d400ULL,
0x00000068004e7306ULL, 0x000e70000020d400ULL, 0x0000004100647306ULL, 0x000ff00000209400ULL,
0x0000004100677306ULL, 0x000ea20000205400ULL, 0x000000014e4e5812ULL, 0x002fc800078efcffULL,
0x000000554e55723eULL, 0x000fc600000010ffULL, 0x00000042005e7306ULL, 0x000ff00000009400ULL,
0x0000004200697306ULL, 0x000e620000005400ULL, 0x000000676400720bULL, 0x004fe40003f5d000ULL,
0x00000018ff647819ULL, 0x000fca000001145fULL, 0x0000006d00587306ULL, 0x000ff00000209400ULL,
0x0000006d00617306ULL, 0x000ea20000205400ULL, 0x000000695e00720bULL, 0x002fce0003fbd000ULL,
0x0000006f00407306ULL, 0x000ff00000209400ULL, 0x0000006f00577306ULL, 0x000e620000205400ULL,
0x000000615800720bULL, 0x004fce0003fdd000ULL, 0x0000006d006c7306ULL, 0x000eb0000020d400ULL,
0x00000042006d7306ULL, 0x000ee2000000d400ULL, 0x000000574000720bULL, 0x002fce0003f9d000ULL,
0x00000043005e7306ULL, 0x000fe20000009400ULL, 0x000000016c6c6812ULL, 0x004fce00078efcffULL,
0x00000043003b7306ULL, 0x000e620000005400ULL, 0x000000016d6d5812ULL, 0x008fce00078efcffULL,
0x0000004100707306ULL, 0x0004f0000020d400ULL, 0x0000006b004c7306ULL, 0x000fe20000209400ULL,
0x00000018ff417819ULL, 0x004fe4000001143cULL, 0x0000003b5e00720bULL, 0x002fca0003fbd000ULL,
0x0000006b004d7306ULL, 0x000fe20000205400ULL, 0x0000000170702812ULL, 0x008fe400078efcffULL,
0x0000004f5600720bULL, 0x000fca0003f5d000ULL, 0x0000006b005b7306ULL, 0x000ff0000020d400ULL,
0x0000006400627306ULL, 0x000fe20000209400ULL, 0x0000000159592812ULL, 0x000fce00078efcffULL,
0x00000064006b7306ULL, 0x000e700000205400ULL, 0x0000006f00687306ULL, 0x000eb0000020d400ULL,
0x0000004100397306ULL, 0x000fe20000209400ULL, 0x0000006b6200720bULL, 0x002fc40003fdd000ULL,
0x00000018ff627819ULL, 0x000fca000001143eULL, 0x00000041003a7306ULL, 0x000e620000205400ULL,
0x0000000168684812ULL, 0x004fce00078efcffULL, 0x00000064005f7306ULL, 0x0004f0000020d400ULL,
0x00000041005a7306ULL, 0x0008e2000020d400ULL, 0x000001003d647824ULL, 0x004fe200078e00ffULL,
0x0000003a3900720bULL, 0x002fc40003f9d000ULL, 0x011000003838783bULL, 0x000e640000000200ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000003c00407306ULL, 0x000fe20000009400ULL,
0x0001000042417824ULL, 0x010fe200078e00ffULL, 0x000000015f5f6812ULL, 0x008fc800078efcffULL,
0x00000018ff6f7819ULL, 0x000fe40000011441ULL, 0x0000006400617306ULL, 0x000fe20000209400ULL,
0x000000015a5a4812ULL, 0x000fce00078efcffULL, 0x00000064005e7306ULL, 0x000eb00000205400ULL,
0x0000006f00417306ULL, 0x000ff00000209400ULL, 0x0000006f00427306ULL, 0x000fe20000205400ULL,
0x0000005e6100720bULL, 0x004fe20003fdd000ULL, 0x0000000b3838b231ULL, 0x002fc400003400ffULL,
0x0000000b3a3ab231ULL, 0x000fc800003400ffULL, 0x0000006f00677306ULL, 0x000fe2000020d400ULL,
0x0000000a3939b231ULL, 0x080fe400003400ffULL, 0x0000000a3b3bb231ULL, 0x000fca00003400ffULL,
0x00000043006f7306ULL, 0x0002a4000000d400ULL, 0x000000543834723cULL, 0x000bec0000041834ULL,
0x0000003c004f7306ULL, 0x000ee20000005400ULL, 0x0001000043437824ULL, 0x002fe200078e00ffULL,
0x0000006a5354723eULL, 0x020fc400000010ffULL, 0x000000705155723eULL, 0x000fe200000010ffULL,
0x0000010019517824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011443ULL,
0x0000003c00617306ULL, 0x000322000000d400ULL, 0x000000016f6f5812ULL, 0x004fe400078efcffULL,
0x000000543830723cULL, 0x000b620000041830ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000004f4000720bULL, 0x008fc40003fbd000ULL, 0x0000006200587306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fe400078e00ffULL, 0x000100003d547824ULL, 0x020fca00078e00ffULL,
0x00000062006b7306ULL, 0x000fe20000205400ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000000161615812ULL, 0x010fe400078efcffULL, 0x0000004d4c00720bULL, 0x000fe20003fbd000ULL,
0x00000100184c7824ULL, 0x000fe400078e00ffULL, 0x0000006200507306ULL, 0x000ff0000020d400ULL,
0x0000006400627306ULL, 0x000e64000020d400ULL, 0x000000015b5b5812ULL, 0x000fcc00078efcffULL,
0x0000007100567306ULL, 0x000ff00000209400ULL, 0x0000007100577306ULL, 0x000fe20000205400ULL,
0x0000000162626812ULL, 0x002fe400078efcffULL, 0x000000424100720bULL, 0x000fca0003fdd000ULL,
0x00000071004f7306ULL, 0x0003f0000020d400ULL, 0x0000006900407306ULL, 0x000fe20000209400ULL,
0x00000018ff717819ULL, 0x002fe4000001144cULL, 0x0000000167676812ULL, 0x000fca00078efcffULL,
0x0000006900437306ULL, 0x000e700000205400ULL, 0x00000069005e7306ULL, 0x000eb0000020d400ULL,
0x00000071004c7306ULL, 0x000fe20000209400ULL, 0x000000434000720bULL, 0x002fe20003fdd000ULL,
0x0001000018437824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011443ULL,
0x00000071004d7306ULL, 0x000fec0000205400ULL, 0x000000015e5e6812ULL, 0x004fe400078efcffULL,
0x0000007100417306ULL, 0x000fe2000020d400ULL, 0x0000006b5800720bULL, 0x000fe20003fdd000ULL,
0x000001003e6b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000003d00697306ULL, 0x000fec0000009400ULL, 0x0000000150506812ULL, 0x000fe400078efcffULL,
0x0000003d00717306ULL, 0x000e700000005400ULL, 0x0000003d006a7306ULL, 0x0004e2000000d400ULL,
0x000000716900720bULL, 0x002fce0003f1d000ULL, 0x0000001900587306ULL, 0x000fe2000000d400ULL,
0x00000018ff717819ULL, 0x000fe4000001143cULL, 0x0000006d6c3c723eULL, 0x000fe400000010ffULL,
0x0000006f683d723eULL, 0x004fc600000010ffULL, 0x0000007100557306ULL, 0x000fe80000209400ULL,
0x0000003c382c723cULL, 0x000be2000004182cULL, 0x000000016a6a0812ULL, 0x008fc600078efcffULL,
0x0000007100707306ULL, 0x000e660000205400ULL, 0x000000675d3c723eULL, 0x020fe400000010ffULL,
0x0000005e593d723eULL, 0x000fc600000010ffULL, 0x00000054006c7306ULL, 0x000fe80000209400ULL,
0x0000003c3828723cULL, 0x000b680000041828ULL, 0x00000054006f7306ULL, 0x000ea20000205400ULL,
0x000000705500720bULL, 0x002fce0003f5d000ULL, 0x0000007100697306ULL, 0x000e70000020d400ULL,
0x0000006b005d7306ULL, 0x000fe20000209400ULL, 0x0000006f6c00720bULL, 0x004fe20003f1d000ULL,
0x000001003f6f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x0000006b005e7306ULL, 0x000ea20000205400ULL, 0x0000000169692812ULL, 0x002fce00078efcffULL,
0x0000003f003d7306ULL, 0x020ff00000009400ULL, 0x0000003f006c7306ULL, 0x000e620000005400ULL,
0x0000005e5d00720bULL, 0x004fce0003f5d000ULL, 0x0000005400687306ULL, 0x000eb0000020d400ULL,
0x0000003e006d7306ULL, 0x000fe20000009400ULL, 0x0000006c3d00720bULL, 0x002fe40003fbd000ULL,
0x0000006a623d723eULL, 0x000fca00000010ffULL, 0x0000003e003c7306ULL, 0x000e620000005400ULL,
0x0000000168680812ULL, 0x004fce00078efcffULL, 0x0000006f00597306ULL, 0x000ff00000209400ULL,
0x0000006f005e7306ULL, 0x000ea20000205400ULL, 0x0000003c6d00720bULL, 0x002fe40003f1d000ULL,
0x000000615f3c723eULL, 0x000fe200000010ffULL, 0x000100003f5f7824ULL, 0x000fc800078e00ffULL,
0x0000001900547306ULL, 0x000fe40000009400ULL, 0x0000003c3824723cULL, 0x000b6c0000041824ULL,
0x0000001900557306ULL, 0x0002e20000005400ULL, 0x0000005e5900720bULL, 0x004fe40003f9d000ULL,
0x000000695a3c723eULL, 0x020fe200000010ffULL, 0x0000000808697824ULL, 0x000fe200078e00ffULL,
0x000000685b3d723eULL, 0x000fe200000010ffULL, 0x000001001a687824ULL, 0x000fc400078e00ffULL,
0x0000006b006b7306ULL, 0x000ea2000020d400ULL, 0x0001000019197824ULL, 0x002fe400078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000003c3820723cULL, 0x000b640000041820ULL,
0x00000018ff717819ULL, 0x000fe20000011419ULL, 0x000100003e197824ULL, 0x000fe200078e00ffULL,
0x0000003e006c7306ULL, 0x000e62000000d400ULL, 0x000000555400720bULL, 0x008fc60003fdd000ULL,
0x00000018ff707819ULL, 0x000fc80000011419ULL, 0x0000006f00677306ULL, 0x000ee2000020d400ULL,
0x000000016b6b2812ULL, 0x004fe400078efcffULL, 0x000000575600720bULL, 0x000fe40003f5d000ULL,
0x0000000252567810ULL, 0x000fe40007ffe0ffULL, 0x0000000158586812ULL, 0x000fe200078efcffULL,
0x0000003f003e7306ULL, 0x000522000000d400ULL, 0x000000016c6c0812ULL, 0x002fc800078efcffULL,
0x0000006c6b3c723eULL, 0x020fe400000010ffULL, 0x0000000167674812ULL, 0x008fe200078efcffULL,
0x00000070006d7306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x004fe4000001145fULL,
0x000000014f4f2812ULL, 0x000fe400078efcffULL, 0x0000004d4c00720bULL, 0x000fe40003f5d000ULL,
0x000000013e3e5812ULL, 0x010fe200078efcffULL, 0x0000003f00627306ULL, 0x000fe60000209400ULL,
0x0000003e673d723eULL, 0x000fc400000010ffULL, 0xfffffff869677812ULL, 0x000fc600078ee256ULL,
0x0000003f006a7306ULL, 0x000e640000205400ULL, 0x00000010673e7824ULL, 0x000fe200078e026eULL,
0x0000003c381c723cULL, 0x000b62000004181cULL, 0x0000000141412812ULL, 0x000fc800078efcffULL,
0x0000003f00577306ULL, 0x0004f0000020d400ULL, 0x0000007000617306ULL, 0x000f220000205400ULL,
0x000000003e3c783bULL, 0x024ea20000004200ULL, 0x0000006a6200720bULL, 0x002fcc0003f9d000ULL,
0x0000007000197306ULL, 0x000e6e000020d400ULL, 0x0000000157574812ULL, 0x008fe200078efcffULL,
0x0000001a005f7306ULL, 0x000fe20000009400ULL, 0x000000616d00720bULL, 0x010fe40003f1d000ULL,
0x000000574f57723eULL, 0x000fc400000010ffULL, 0x0000004a1200720bULL, 0x000fc60003f9d000ULL,
0x0000001a005b7306ULL, 0x000eec0000005400ULL, 0x0000000119190812ULL, 0x002fe400078efcffULL,
0x00000018004e7306ULL, 0x000fe40000009400ULL, 0x000000195056723eULL, 0x000fe200000010ffULL,
0x000001001b197824ULL, 0x000fe200078e00ffULL, 0x0000000145454812ULL, 0x000fc400078efcffULL,
0x000000445c00720bULL, 0x000fe40003f9d000ULL, 0x0000001800427306ULL, 0x000e620000005400ULL,
0x000001003c127824ULL, 0x004fe200078e00ffULL, 0x000000563814723cULL, 0x000b620000041814ULL,
0x0000005b5f00720bULL, 0x008fe40003fbd000ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff5b7819ULL, 0x000fe20000011412ULL, 0x0000001800407306ULL, 0x000ea2000000d400ULL,
0x000100001b387824ULL, 0x020fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143cULL,
0x0000000863127824ULL, 0x000fe200078e00ffULL, 0x0000000113134812ULL, 0x000fc800078efcffULL,
0x0000005100187306ULL, 0x000fe20000209400ULL, 0x000000424e00720bULL, 0x002fe40003f1d000ULL,
0xfffffff812127812ULL, 0x000fe200078ee24bULL, 0x000001003d4b7824ULL, 0x000fc800078e00ffULL,
0x0000005100537306ULL, 0x000e620000205400ULL, 0x0000001012127824ULL, 0x000fca00078e0209ULL,
0x0000000140400812ULL, 0x004fe400078efcffULL, 0x0000001a005a7306ULL, 0x0004e4000000d400ULL,
0x000000404140723eULL, 0x000fcc00000010ffULL, 0x0000001b00617306ULL, 0x000fe20000009400ULL,
0x000100001a1a7824ULL, 0x004fe200078e00ffULL, 0x000000531800720bULL, 0x002fc80003f1d000ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001b00507306ULL, 0x000fe20000005400ULL,
0x000000015a5a5812ULL, 0x008fce00078efcffULL, 0x0000001b004f7306ULL, 0x0003f0000000d400ULL,
0x0000007200657306ULL, 0x000fe20000209400ULL, 0x00000018ff1b7819ULL, 0x002fce0000011438ULL,
0x0000007200647306ULL, 0x000e700000205400ULL, 0x0000007200437306ULL, 0x000eb0000020d400ULL,
0x00000071005d7306ULL, 0x000fe20000209400ULL, 0x000000646500720bULL, 0x002fc40003f5d000ULL,
0x00000018ff647819ULL, 0x000fca000001144bULL, 0x00000071005e7306ULL, 0x000e6c0000205400ULL,
0x0000000143432812ULL, 0x004fe400078efcffULL, 0x0000007100597306ULL, 0x000ea2000020d400ULL,
0x000000506100720bULL, 0x000fce0003f5d000ULL, 0x0000006800627306ULL, 0x000fe20000209400ULL,
0x0000005e5d00720bULL, 0x002fca0003fdd000ULL, 0x000000014f4f2812ULL, 0x000fe400078efcffULL,
0x0000006800527306ULL, 0x000e6c0000205400ULL, 0x0000000159596812ULL, 0x004fe400078efcffULL,
0x0000006800677306ULL, 0x000ea4000020d400ULL, 0x000000591359723eULL, 0x000fcc00000010ffULL,
0x0000001900687306ULL, 0x000fe20000209400ULL, 0x000000526200720bULL, 0x002fce0003fdd000ULL,
0x00000019006b7306ULL, 0x000e6c0000205400ULL, 0x0000000167676812ULL, 0x004fe400078efcffULL,
0x0000001900577306ULL, 0x0004f0000020d400ULL, 0x0000001a00707306ULL, 0x000fe20000209400ULL,
0x00000018ff197819ULL, 0x004fc4000001143dULL, 0x0000006b6800720bULL, 0x002fca0003f9d000ULL,
0x0000001a006f7306ULL, 0x000e700000205400ULL, 0x0000001a00697306ULL, 0x000522000020d400ULL,
0x0000000157574812ULL, 0x008fc800078efcffULL, 0x0000004f574f723eULL, 0x000fc600000010ffULL,
0x0000001b00717306ULL, 0x000fe20000209400ULL, 0x00000018ff1a7819ULL, 0x004fe4000001143eULL,
0x0000006f7000720bULL, 0x002fca0003fbd000ULL, 0x0000001b00727306ULL, 0x000e700000205400ULL,
0x0000001b00567306ULL, 0x0004e2000020d400ULL, 0x0000000169695812ULL, 0x010fce00078efcffULL,
0x0000003a006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff1b7819ULL, 0x004fe4000001143fULL,
0x000000727100720bULL, 0x002fca0003f9d000ULL, 0x0000003a006d7306ULL, 0x000ff00000205400ULL,
0x0000003a00387306ULL, 0x000fe2000020d400ULL, 0x0000000156564812ULL, 0x008fce00078efcffULL,
0x00000019006a7306ULL, 0x000ff00000209400ULL, 0x00000019004e7306ULL, 0x000ff00000205400ULL,
0x0000001900397306ULL, 0x000ff0000020d400ULL, 0x0000001a00427306ULL, 0x000ff00000209400ULL,
0x0000001a004d7306ULL, 0x000ff00000205400ULL, 0x0000001a003a7306ULL, 0x000ff0000020d400ULL,
0x0000001b004c7306ULL, 0x000ff00000209400ULL, 0x0000001b004a7306ULL, 0x000ff00000205400ULL,
0x0000001b003b7306ULL, 0x0003f0000020d400ULL, 0x0000005100517306ULL, 0x000ea2000020d400ULL,
0x011000001218783bULL, 0x002e6e0000000200ULL, 0x0000003c00547306ULL, 0x000ff00000009400ULL,
0x0000003c00657306ULL, 0x000ee20000005400ULL, 0x0000000151510812ULL, 0x004fc400078efcffULL,
0x000000484600720bULL, 0x000fe20003f1d000ULL, 0x000100003c467824ULL, 0x000fe200078e00ffULL,
0x000000585141723eULL, 0x000fe200000010ffULL, 0x000100003f517824ULL, 0x000fe200078e00ffULL,
0x000000434558723eULL, 0x000fe200000010ffULL, 0x00000064005f7306ULL, 0x000fe20000209400ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff437819ULL, 0x000fca0000011451ULL,
0x0000006400507306ULL, 0x000ea20000205400ULL, 0x000000655400720bULL, 0x008fe40003fdd000ULL,
0x0000000107070812ULL, 0x000fca00078efcffULL, 0x00000064004b7306ULL, 0x000fe2000020d400ULL,
0x0000000b1818b231ULL, 0x082fe400003400ffULL, 0x0000000b1a1ab231ULL, 0x000fe400003400ffULL,
0x0000000a1919b231ULL, 0x080fe400003400ffULL, 0x0000000a1b1bb231ULL, 0x000fe200003400ffULL,
0x0000003c00447306ULL, 0x000e62000000d400ULL, 0x000000494700720bULL, 0x000fe20003f7d000ULL,
0x000001003e497824ULL, 0x000fe200078e00ffULL, 0x000000505f00720bULL, 0x004fe20003f1d000ULL,
0x000100003d477824ULL, 0x000fc400078e00ffULL, 0x000000581830723cULL, 0x040f620000041830ULL,
0x00000018ff527819ULL, 0x000fe20000011449ULL, 0x0000003d00737306ULL, 0x000fec0000009400ULL,
0x0000000103033812ULL, 0x000fe200078efcffULL, 0x000000401834723cULL, 0x000b620000041834ULL,
0x0000003d00747306ULL, 0x000ea20000005400ULL, 0x0000000144446812ULL, 0x002fc400078efcffULL,
0x000000014b4b0812ULL, 0x000fc600078efcffULL, 0x000000690740723eULL, 0x020fe400000010ffULL,
0x0000005b00557306ULL, 0x000fe20000209400ULL, 0x000000560341723eULL, 0x000fe200000010ffULL,
0x0000000202037824ULL, 0x000fca00078e00ffULL, 0xfffffff803037812ULL, 0x000fe200078ec0ffULL,
0x0000005b00637306ULL, 0x000e620000205400ULL, 0x000000747300720bULL, 0x004fe20003f5d000ULL,
0x000000401828723cULL, 0x000f6c0000041828ULL, 0x0000004600617306ULL, 0x000ff00000209400ULL,
0x0000004600647306ULL, 0x000ea20000205400ULL, 0x000000635500720bULL, 0x002fe20003fbd000ULL,
0x000100003e557824ULL, 0x000fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000003d003c7306ULL, 0x0002f0000000d400ULL, 0x0000003e00497306ULL, 0x000fe20000009400ULL,
0x00000018ff3d7819ULL, 0x002fc40000011447ULL, 0x000000646100720bULL, 0x004fca0003fdd000ULL,
0x0000003e00627306ULL, 0x000e620000005400ULL, 0x000000013c3c2812ULL, 0x008fe400078efcffULL,
0x0000004e6a00720bULL, 0x000fe40003f5d000ULL, 0x0000003c4b45723eULL, 0x000fe400000010ffULL,
0x0000005a674e723eULL, 0x000fe200000010ffULL, 0x0000005b00537306ULL, 0x000eac000020d400ULL,
0x0000004e182c723cULL, 0x000f64000004182cULL, 0x0000004600487306ULL, 0x000ee2000020d400ULL,
0x000000624900720bULL, 0x002fc40003f9d000ULL, 0x0000000139392812ULL, 0x000fca00078efcffULL,
0x0000003d005d7306ULL, 0x000fe20000209400ULL, 0x0000000153535812ULL, 0x004fe400078efcffULL,
0x0000006d6c00720bULL, 0x000fe40003fbd000ULL, 0x000000445344723eULL, 0x000fc600000010ffULL,
0x0000003d005e7306ULL, 0x000e620000205400ULL, 0x0000000148486812ULL, 0x008fc600078efcffULL,
0x000000441824723cULL, 0x000f680000041824ULL, 0x00000052005b7306ULL, 0x000fe20000209400ULL,
0x0000000138385812ULL, 0x000fe400078efcffULL, 0x0000004d4200720bULL, 0x000fe40003fbd000ULL,
0x000000483838723eULL, 0x000fc600000010ffULL, 0x00000052005c7306ULL, 0x000ea20000205400ULL,
0x0000005e5d00720bULL, 0x002fce0003f1d000ULL, 0x0000003d00477306ULL, 0x0002e2000020d400ULL,
0x000000013a3a5812ULL, 0x000fce00078efcffULL, 0x0000005200467306ULL, 0x000f22000020d400ULL,
0x000001003f3d7824ULL, 0x002fe200078e00ffULL, 0x0000005c5b00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff6b7819ULL, 0x000fe4000001143dULL, 0x0000003e00497306ULL, 0x000e62000000d400ULL,
0x0000000147470812ULL, 0x008fe400078efcffULL, 0x0000004a4c00720bULL, 0x000fe40003f1d000ULL,
0x000000473939723eULL, 0x000fc600000010ffULL, 0x0000003f00687306ULL, 0x000fe20000009400ULL,
0x0000000146466812ULL, 0x010fc600078efcffULL, 0x000000381820723cULL, 0x000b680000041820ULL,
0x0000003f00657306ULL, 0x000ea20000005400ULL, 0x0000000149494812ULL, 0x002fe400078efcffULL,
0x000000013b3b0812ULL, 0x000fe400078efcffULL, 0x00000049463c723eULL, 0x000fe400000010ffULL,
0x000176c878387811ULL, 0x020fe200078e18ffULL, 0x0000006b00527306ULL, 0x000ff00000209400ULL,
0x0000006b00547306ULL, 0x000e620000205400ULL, 0x000000656800720bULL, 0x004fce0003f7d000ULL,
0x0000003f003e7306ULL, 0x000eb0000000d400ULL, 0x0000005500507306ULL, 0x000fe20000209400ULL,
0x000000545200720bULL, 0x002fce0003f5d000ULL, 0x00000055003f7306ULL, 0x000e620000205400ULL,
0x000000013e3e3812ULL, 0x004fce00078efcffULL, 0x0000004300137306ULL, 0x000ff00000209400ULL,
0x0000004300587306ULL, 0x000ea20000205400ULL, 0x0000003f5000720bULL, 0x002fce0003fdd000ULL,
0x0000006b003d7306ULL, 0x000e70000020d400ULL, 0x0000005500557306ULL, 0x000ee2000020d400ULL,
0x000000581300720bULL, 0x004fce0003f9d000ULL, 0x0000004300407306ULL, 0x000ea2000020d400ULL,
0x000000013d3d2812ULL, 0x002fc800078efcffULL, 0x0000003e3d3d723eULL, 0x000fe400000010ffULL,
0x0000000155556812ULL, 0x008fc800078efcffULL, 0x000000553a3a723eULL, 0x000fe200000010ffULL,
0x0000003c181c723cULL, 0x000b62000004181cULL, 0x0000000140404812ULL, 0x004fc800078efcffULL,
0x000000403b3b723eULL, 0x000fce00000010ffULL, 0x0000003a1818723cULL, 0x000b620000041814ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000038387f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176880003ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff077224ULL, 0x000fc600078e00ffULL,
0x0000000000147805ULL, 0x020fc80000015200ULL, 0x000004000f037984ULL, 0x004ea40000000800ULL,
0x8000000003ff7812ULL, 0x006fe40007804839ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011417ULL,
0x0000001603037211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000203037819ULL, 0x000fc80000001216ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000107077810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000f037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000800e147810ULL, 0x000fca0007ffe0ffULL, 0x000066007b077a24ULL, 0x000fe200078e0214ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x0000001477037217ULL, 0x000fe20007800000ULL,
0x0000001079167824ULL, 0x000fe200078e00ffULL, 0x00000003ff137819ULL, 0x000fc60000011611ULL,
0x0000000103037824ULL, 0x000fe200078e0a14ULL, 0x0000000413177810ULL, 0x000fe20007ffe0ffULL,
0x0000000116147824ULL, 0x000fc600078e0213ULL, 0x0000000316037217ULL, 0x000fe20007800000ULL,
0x0000000114157824ULL, 0x040fe400078e0211ULL, 0x0000000814387824ULL, 0x040fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a16ULL, 0x0000000114147824ULL, 0x000fe200078e0207ULL,
0xfffffff8383d7812ULL, 0x000fe200078ee215ULL, 0x0000000116387824ULL, 0x000fe200078e0217ULL,
0x0000000813157810ULL, 0x000fc40007ffe0ffULL, 0x000000031700720cULL, 0x080fe20003f66070ULL,
0x00000008383e7824ULL, 0x000fe200078e00ffULL, 0x0000000c13177810ULL, 0x040fe20007ffe0ffULL,
0x00000001163a7824ULL, 0x000fe200078e0215ULL, 0x000000031300720cULL, 0x080fe20003f86070ULL,
0x0000000138137824ULL, 0x000fe200078e0211ULL, 0x000000031500720cULL, 0x080fe20003f46070ULL,
0x00000001163c7824ULL, 0x000fe200078e0217ULL, 0x000000031700720cULL, 0x000fe20003f06070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff83e137812ULL, 0x000fc600078ee213ULL,
0x0000000138167824ULL, 0x100fe200078e0207ULL, 0x0000006014147212ULL, 0x000fe200078efcffULL,
0x000000013a387824ULL, 0x000fe400078e0207ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000620014147a10ULL, 0x000fc60007fbe0ffULL, 0x000000013a037824ULL, 0x000fe200078e0211ULL,
0x0000006016167212ULL, 0x080fe200078efcffULL, 0x000000083a3e7824ULL, 0x000fe200078e00ffULL,
0x0000630015157a10ULL, 0x000fe20002ffe4ffULL, 0x000000013c3a7824ULL, 0x000fe200078e0207ULL,
0x0000620016167a10ULL, 0x000fe20007fbe0ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0xfffffff83e037812ULL, 0x000fe400078ee203ULL, 0x0000630017177a10ULL, 0x000fe20002ffe4ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000006038387212ULL, 0x000fc600078efcffULL,
0x000000013c077824ULL, 0x000fe200078e0211ULL, 0x000000603a3a7212ULL, 0x000fe200078efcffULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x0000620038387a10ULL, 0x000fe20007fbe0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e026eULL, 0x000062003a3a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001013137824ULL, 0x100fe200078e026eULL, 0xfffffff83c077812ULL, 0x000fe200078ee207ULL,
0x0000001003037824ULL, 0x100fe200078e026eULL, 0x0000630039397a10ULL, 0x000fe20002ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000e101c48ULL,
0x000063003b3b7a10ULL, 0x000fe200037fe4ffULL, 0x0000001007077824ULL, 0x000fc400078e026eULL,
0x0000000016137faeULL, 0x0003e8000d901c48ULL, 0x0000000038037faeULL, 0x0003e8000d101c48ULL,
0x000000003a077faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001079147824ULL, 0x000fca00078e00ffULL, 0x0000001411167211ULL, 0x000fc800078fe8ffULL,
0x00000004163a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000116037824ULL, 0x140fe200078e0211ULL,
0x0000000816387810ULL, 0x040fe20007ffe0ffULL, 0x0000000816147824ULL, 0x000fe400078e00ffULL,
0x000000013a137824ULL, 0x040fe400078e0211ULL, 0x000000083a3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff814037812ULL, 0x000fe200078ee203ULL, 0x0000000138157824ULL, 0x040fe400078e0211ULL,
0x00000008383e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c137812ULL, 0x000fe200078ee213ULL,
0x0000000116147824ULL, 0x140fe200078e0207ULL, 0x0000000c163c7810ULL, 0x000fe20007ffe0ffULL,
0x000000013a3a7824ULL, 0x000fe200078e0207ULL, 0xfffffff83e3d7812ULL, 0x000fe200078ee215ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000000138167824ULL, 0x100fe200078e0207ULL,
0x0000006014147212ULL, 0x000fe200078efcffULL, 0x000000013c387824ULL, 0x000fe400078e0207ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000620014147a10ULL, 0x000fc60007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000603a3a7212ULL, 0x080fe400078efcffULL,
0x0000630015157a10ULL, 0x000fe200007fe4ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000006016167212ULL, 0x080fe400078efcffULL, 0x000062003a3a7a10ULL, 0x000fe20007f5e0ffULL,
0x000000013c077824ULL, 0x000fe200078e0211ULL, 0x0000006038387212ULL, 0x000fe200078efcffULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x0000620016167a10ULL, 0x000fe20007f1e0ffULL,
0x0000001003037824ULL, 0x100fe200078e026eULL, 0x0000620038387a10ULL, 0x000fe20007f7e0ffULL,
0x0000001013137824ULL, 0x100fe200078e026eULL, 0xfffffff83c077812ULL, 0x000fe200078ee207ULL,
0x000000103d3d7824ULL, 0x100fe200078e026eULL, 0x000063003b3b7a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014037faeULL, 0x0003e2000b901c48ULL,
0x0000630017177a10ULL, 0x000fe200007fe4ffULL, 0x0000001007077824ULL, 0x000fe200078e026eULL,
0x0000630039397a10ULL, 0x000fe20001ffe4ffULL, 0x000000003a137faeULL, 0x0003e8000b901c48ULL,
0x00000000163d7faeULL, 0x0003e8000b901c48ULL, 0x0000000038077faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000001078037824ULL, 0x000fe200078e00ffULL,
0xffffffe010147812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000810077812ULL, 0x000fe400078ec0ffULL, 0x0000001003037812ULL, 0x000fc800078ec0ffULL,
0x0000001407037210ULL, 0x000fe20007ffe003ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff147f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01762800033a7f8cULL, 0x0004e4000c80043fULL,
0x0000000000167805ULL, 0x000fc40000015200ULL, 0x01762c000d037984ULL, 0x004ea40000000800ULL,
0x8000000003ff7812ULL, 0x00cfe4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x0000003816387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e17ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011439ULL, 0x0000003803037211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000203037819ULL, 0x000fc80000001238ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01762c000d037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002037824ULL, 0x000fca00078e00ffULL,
0xffffff8003037812ULL, 0x000fc800078ec0ffULL, 0x0000008060167810ULL, 0x000fca0007ffe003ULL,
0x0000000175167824ULL, 0x000fca00078e0216ULL, 0x0170000016037984ULL, 0x000ea80000000800ULL,
0x0172000016177984ULL, 0x0006620000000800ULL, 0x000000000300720bULL, 0x004fe20003f1d000ULL,
0x000129e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff133d7812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff137424ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fd200078e0000ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000017c077810ULL, 0x000fe40007ffe0ffULL,
0x000000000300720bULL, 0x000fe40003f54000ULL, 0x000000020700720cULL, 0x000fe20003f05270ULL,
0x000129927f007947ULL, 0x000fd4000b800000ULL, 0x0000000000167806ULL, 0x000fc400010e0100ULL,
0x0000008002388824ULL, 0x000fe200078e0260ULL, 0x0000000003077209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991016137816ULL, 0x000fe200000000ffULL,
0x0000000175388824ULL, 0x000fca00078e0238ULL, 0x0174000738008388ULL, 0x0005e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000007007221ULL, 0x004fe20000010100ULL, 0x000000ff16ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x00000000003f7308ULL, 0x000ea40000000800ULL, 0x0000003f06067220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011611ULL,
0x000128d27f007947ULL, 0x000fea000b800000ULL, 0x00001f133f137589ULL, 0x0004e400000e0000ULL,
0x0000001334347220ULL, 0x08cfe40000410000ULL, 0x0000001335357220ULL, 0x080fe40000410000ULL,
0x0000001330307220ULL, 0x080fe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x000fc40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x080fe40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x000fc40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000811137811ULL, 0x000fe200078ff0ffULL,
0x000127d27f007947ULL, 0x000fea000b800000ULL, 0x00001f133f137589ULL, 0x0004e400000e0000ULL,
0x0000001336367220ULL, 0x08cfe40000410000ULL, 0x0000001337377220ULL, 0x080fe40000410000ULL,
0x0000001332327220ULL, 0x080fe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x000fc40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x080fe40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x000fc40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3dff7812ULL, 0x000fe20007806016ULL,
0x00000001ff137424ULL, 0x000fd800078e00ffULL, 0x8000000703030221ULL, 0x000fe20000010000ULL,
0x00007610ff130816ULL, 0x000fc60000000013ULL, 0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL,
0x00000003000c0308ULL, 0x000ea40000000800ULL, 0x0000000c17170220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000617067221ULL, 0x002fc40000010000ULL,
0x0000000000167805ULL, 0x000fca0000015200ULL, 0xfffffff0103b7812ULL, 0x000fca00078ec0ffULL,
0x0176b4003b037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003816037210ULL, 0x000fca0007f1e1ffULL,
0x0000000139387824ULL, 0x000fe200000e0e17ULL, 0x003d09000300780cULL, 0x000fc80003f06070ULL,
0x000000ff3800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400300780cULL, 0x000fc80003f06070ULL, 0x000000ff3800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011438ULL,
0x0000000300007211ULL, 0x000fca00078110ffULL, 0x000000ffff037224ULL, 0x000fca00000e0638ULL,
0x0000000200007819ULL, 0x000fc80000001203ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176b4003b037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991013007816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x0000000cff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe40000011611ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000123c27f007947ULL, 0x000fea000b800000ULL,
0x00001f03000b7589ULL, 0x0002a400000e0000ULL, 0x0000000803137810ULL, 0x000fe20007ffe0ffULL,
0x000124127f007947ULL, 0x000fea000b800000ULL, 0x00001f13000a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001003137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200078e0000ULL, 0x0000623000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00012e6000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001803137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e0000ULL,
0x000062a000397802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x00012df000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002026f7824ULL, 0x000fe200078e00ffULL,
0x0000000711037812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000046f007812ULL, 0x008fe400078ec0ffULL, 0x0000000803057812ULL, 0x000fe400078ef811ULL,
0x0000000011007211ULL, 0x000fc600078fe0ffULL, 0x0000000805047824ULL, 0x040fe400078e00ffULL,
0x0000000105057824ULL, 0x000fe200078e0200ULL, 0x0000000811007812ULL, 0x000fc800078ec0ffULL,
0xfffffff804047812ULL, 0x000fca00078ee205ULL, 0x0000001004047824ULL, 0x000fc400078e0209ULL,
0x0000000402167824ULL, 0x000fe200078e00ffULL, 0x0000000300007212ULL, 0x000fe200078efcffULL,
0x0000000808137824ULL, 0x004fe200078e00ffULL, 0x000010006e747810ULL, 0x000fe40007ffe0ffULL,
0x0000000416167812ULL, 0x000fe200078ec0ffULL, 0x00000008006b7824ULL, 0x000fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe400078ec0ffULL, 0x0000001611037211ULL, 0x000fca00078fe0ffULL,
0x0000000100407824ULL, 0x100fe400078e0203ULL, 0x0000000108167824ULL, 0x000fc600078e0203ULL,
0xfffffff86b6b7812ULL, 0x000fe400078ee240ULL, 0xfffffff813507812ULL, 0x000fe400078ee216ULL,
0x0000000216167810ULL, 0x000fe20007ffe0ffULL, 0x000000106b6b7824ULL, 0x100fe400078e0274ULL,
0x0000001050387824ULL, 0x000fc600078e0274ULL, 0x000000006b3c783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x00000018ff417819ULL, 0x002fe2000001143eULL,
0x0000003c005b7306ULL, 0x000fe20000009400ULL, 0x00000018ff137819ULL, 0x000fe4000001143cULL,
0x00000018ff427819ULL, 0x000fe4000001143fULL, 0x00000018ff437819ULL, 0x004fc40000011439ULL,
0x00000018ff177819ULL, 0x000fe2000001143dULL, 0x00000041005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff4f7819ULL, 0x000fce000001143aULL, 0x00000041005c7306ULL, 0x000ff00000205400ULL,
0x0000004100637306ULL, 0x0003f0000020d400ULL, 0x0000001300597306ULL, 0x000fe20000209400ULL,
0x000001003c417824ULL, 0x002fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000001300647306ULL, 0x000e700000205400ULL, 0x0000001300547306ULL, 0x0004f0000020d400ULL,
0x0000004200537306ULL, 0x000fe20000209400ULL, 0x00000018ff137819ULL, 0x004fc40000011438ULL,
0x000000645900720bULL, 0x002fca0003f9d000ULL, 0x00000042006a7306ULL, 0x000ff00000205400ULL,
0x0000004200627306ULL, 0x0003e2000020d400ULL, 0x0000000154544812ULL, 0x008fce00078efcffULL,
0x00000041006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x002fce000001143bULL,
0x0000004100617306ULL, 0x000e700000205400ULL, 0x00000013004d7306ULL, 0x000ff00000209400ULL,
0x00000013004c7306ULL, 0x000fe20000205400ULL, 0x000000616c00720bULL, 0x002fce0003fbd000ULL,
0x0000001300447306ULL, 0x000ff0000020d400ULL, 0x00000042004b7306ULL, 0x000ff00000209400ULL,
0x0000004200467306ULL, 0x000ff00000205400ULL, 0x0000004200137306ULL, 0x0003f0000020d400ULL,
0x0000004300497306ULL, 0x000fe20000209400ULL, 0x000001003d427824ULL, 0x002fca00078e00ffULL,
0x00000018ff697819ULL, 0x000fe40000011442ULL, 0x0000004300477306ULL, 0x000ff00000205400ULL,
0x0000004300457306ULL, 0x000ff0000020d400ULL, 0x0000004100577306ULL, 0x0002b0000020d400ULL,
0x0000006900437306ULL, 0x000fe20000209400ULL, 0x000100003d417824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011441ULL, 0x0000006900587306ULL, 0x000e620000205400ULL,
0x0000000157575812ULL, 0x004fce00078efcffULL, 0x0000003c00687306ULL, 0x000eb00000005400ULL,
0x0000003c004e7306ULL, 0x000722000000d400ULL, 0x000000584300720bULL, 0x002fe20003fbd000ULL,
0x000001003f437824ULL, 0x000fcc00078e00ffULL, 0x0000003d005a7306ULL, 0x000fe20000009400ULL,
0x000100003c3c7824ULL, 0x008fe200078e00ffULL, 0x000000685b00720bULL, 0x004fe40003f5d000ULL,
0x00000018ff687819ULL, 0x000fe20000011443ULL, 0x0000000800437824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003d00677306ULL, 0x000e620000005400ULL,
0x0000000240007810ULL, 0x000fc80007ffe0ffULL, 0xfffffff843007812ULL, 0x000fe400078ee200ULL,
0x000000014e4e2812ULL, 0x010fe200078efcffULL, 0x0000006d00417306ULL, 0x000fe40000209400ULL,
0x0000001000407824ULL, 0x000fe200078e0274ULL, 0x0000004e574e723eULL, 0x000fca00000010ffULL,
0x0000006d00427306ULL, 0x000ea20000205400ULL, 0x000000675a00720bULL, 0x002fce0003f7d000ULL,
0x0000003c00657306ULL, 0x000ff00000209400ULL, 0x0000003c00707306ULL, 0x000e620000205400ULL,
0x000000424100720bULL, 0x004fe40003f5d000ULL, 0x000000004040783bULL, 0x000eaa0000004200ULL,
0x0000003c00567306ULL, 0x000730000020d400ULL, 0x00000017005e7306ULL, 0x000fe20000209400ULL,
0x000001003e3c7824ULL, 0x048fe200078e00ffULL, 0x000000706500720bULL, 0x002fe20003fdd000ULL,
0x000100003e657824ULL, 0x000fc600078e00ffULL, 0x00000018ff647819ULL, 0x000fe4000001143cULL,
0x00000017005f7306ULL, 0x000fee0000205400ULL, 0x0000000156566812ULL, 0x010fe200078efcffULL,
0x0000001700557306ULL, 0x000fe6000020d400ULL, 0x000000565454723eULL, 0x000fca00000010ffULL,
0x0000004f00487306ULL, 0x000fe20000209400ULL, 0x00000018ff577819ULL, 0x004fce0000011443ULL,
0x0000004f004a7306ULL, 0x000ff00000205400ULL, 0x0000004f00177306ULL, 0x000ff0000020d400ULL,
0x0000003d004f7306ULL, 0x000e70000000d400ULL, 0x00000064003c7306ULL, 0x000ff00000209400ULL,
0x00000064003d7306ULL, 0x000ea20000205400ULL, 0x000000014f4f3812ULL, 0x002fce00078efcffULL,
0x0000006400597306ULL, 0x000e70000020d400ULL, 0x0000003f00647306ULL, 0x000fe20000009400ULL,
0x0000003d3c00720bULL, 0x004fce0003f7d000ULL, 0x0000003f00677306ULL, 0x000eac0000005400ULL,
0x0000000159593812ULL, 0x002fe400078efcffULL, 0x0000003e005a7306ULL, 0x000fe20000009400ULL,
0x0000006a5300720bULL, 0x000fce0003f7d000ULL, 0x0000003e005b7306ULL, 0x000e620000005400ULL,
0x000000676400720bULL, 0x004fe20003f9d000ULL, 0x000100003f647824ULL, 0x000fc800078e00ffULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x0000006d00517306ULL, 0x0004f0000020d400ULL,
0x0000006800617306ULL, 0x000fe20000209400ULL, 0x00000018ff6d7819ULL, 0x004fc40000011464ULL,
0x0000005b5a00720bULL, 0x002fca0003fdd000ULL, 0x00000068006c7306ULL, 0x000e620000205400ULL,
0x0000000151512812ULL, 0x008fce00078efcffULL, 0x0000006900527306ULL, 0x0004f0000020d400ULL,
0x0000006800587306ULL, 0x000f22000020d400ULL, 0x0000006c6100720bULL, 0x002fe40003f5d000ULL,
0x00000018ff697819ULL, 0x004fc40000011465ULL, 0x00000018ff617819ULL, 0x000fc60000011441ULL,
0x0000003e005a7306ULL, 0x000e62000000d400ULL, 0x0000000152525812ULL, 0x008fe400078efcffULL,
0x0000005f5e00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff5f7819ULL, 0x000fe40000011440ULL,
0x0000004f524f723eULL, 0x000fe200000010ffULL, 0x0000006d003e7306ULL, 0x000fe20000209400ULL,
0x0000000158582812ULL, 0x010fce00078efcffULL, 0x0000006d00677306ULL, 0x000ea20000205400ULL,
0x0000000155555812ULL, 0x000fe400078efcffULL, 0x0000005c5d00720bULL, 0x000fe40003fbd000ULL,
0x000000015a5a6812ULL, 0x002fe400078efcffULL, 0x000000515555723eULL, 0x000fe200000010ffULL,
0x0000006900707306ULL, 0x000ff00000209400ULL, 0x0000006900657306ULL, 0x000e620000205400ULL,
0x000000673e00720bULL, 0x004fe20003f5d000ULL, 0x00000100403e7824ULL, 0x000fe200078e00ffULL,
0x0000000163635812ULL, 0x000fc800078efcffULL, 0x00000018ff677819ULL, 0x000fe2000001143eULL,
0x0000006900687306ULL, 0x0005f0000020d400ULL, 0x0000003f005b7306ULL, 0x000ee2000000d400ULL,
0x00000018ff697819ULL, 0x004fc40000011442ULL, 0x000000657000720bULL, 0x002fca0003fdd000ULL,
0x0000005f003f7306ULL, 0x000ff00000209400ULL, 0x0000005f00727306ULL, 0x000e620000205400ULL,
0x000000015b5b4812ULL, 0x008fe400078efcffULL, 0x0000000168686812ULL, 0x000fca00078efcffULL,
0x00000061003c7306ULL, 0x000ff00000209400ULL, 0x00000061003d7306ULL, 0x000ea20000205400ULL,
0x000000723f00720bULL, 0x002fce0003f9d000ULL, 0x0000006d00647306ULL, 0x0002f0000020d400ULL,
0x0000005f005e7306ULL, 0x000f22000020d400ULL, 0x0000003d3c00720bULL, 0x004fe20003fdd000ULL,
0x00000100386d7824ULL, 0x002fe200078e00ffULL, 0x01180000043c783bULL, 0x000e680000000200ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x00000061005d7306ULL, 0x000ea2000020d400ULL,
0x0000000164642812ULL, 0x008fce00078efcffULL, 0x00000069005f7306ULL, 0x000fe20000209400ULL,
0x000000015e5e4812ULL, 0x010fce00078efcffULL, 0x00000069006a7306ULL, 0x000ee20000205400ULL,
0x000000015d5d6812ULL, 0x004fce00078efcffULL, 0x0000006700617306ULL, 0x000ff00000209400ULL,
0x00000067006c7306ULL, 0x000ea20000205400ULL, 0x0000006a5f00720bULL, 0x008fe20003fbd000ULL,
0x0000000b3c3c8231ULL, 0x002fc400003400ffULL, 0x0000000b3e3e8231ULL, 0x000fe400003400ffULL,
0x0000000a3d3d8231ULL, 0x080fe400003400ffULL, 0x00000040005c7306ULL, 0x000fe20000009400ULL,
0x0000000a3f3f8231ULL, 0x000fce00003400ffULL, 0x0000004000657306ULL, 0x000e620000005400ULL,
0x0000006c6100720bULL, 0x004fe20003f5d000ULL, 0x000000543c30723cULL, 0x040b6c0000041830ULL,
0x00000067005f7306ULL, 0x000ea2000020d400ULL, 0x0000005a5954723eULL, 0x020fe200000010ffULL,
0x0000004e3c34723cULL, 0x000fe20000041834ULL, 0x0000005b5855723eULL, 0x000fc400000010ffULL,
0x000000655c00720bULL, 0x002fc60003f7d000ULL, 0x0000004000617306ULL, 0x000e62000000d400ULL,
0x0000010041657824ULL, 0x000fe200078e00ffULL, 0x000000543c2c723cULL, 0x000b68000004182cULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000041005c7306ULL, 0x000fe20000009400ULL,
0x000000015f5f2812ULL, 0x004fe200078efcffULL, 0x0000010039557824ULL, 0x020fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011455ULL, 0x0000004100677306ULL, 0x000ea20000005400ULL,
0x0000000161613812ULL, 0x002fe400078efcffULL, 0x000000646255723eULL, 0x000fca00000010ffULL,
0x0000006900537306ULL, 0x000e70000020d400ULL, 0x00000065006a7306ULL, 0x000fe20000209400ULL,
0x000000675c00720bULL, 0x004fe20003f7d000ULL, 0x00010000405c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000006500697306ULL, 0x000ea20000205400ULL,
0x0000000153535812ULL, 0x002fce00078efcffULL, 0x0000004100677306ULL, 0x000e62000000d400ULL,
0x000000696a00720bULL, 0x004fce0003f5d000ULL, 0x0000006500657306ULL, 0x000ea2000020d400ULL,
0x0000000167673812ULL, 0x002fce00078efcffULL, 0x0000005c00697306ULL, 0x000ff00000209400ULL,
0x0000005c006a7306ULL, 0x000e620000205400ULL, 0x0000000165652812ULL, 0x004fce00078efcffULL,
0x0000005700527306ULL, 0x000ff00000209400ULL, 0x00000057006c7306ULL, 0x000ea20000205400ULL,
0x0000006a6900720bULL, 0x002fe20003f7d000ULL, 0x0001000041697824ULL, 0x000fc400078e00ffULL,
0x00000100426a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000003800517306ULL, 0x000fe20000009400ULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x0000006c5200720bULL, 0x004fca0003f5d000ULL, 0x0000003800567306ULL, 0x000fe20000005400ULL,
0x00010000386c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000003800527306ULL, 0x000ff0000000d400ULL, 0x0000005c00387306ULL, 0x000e70000020d400ULL,
0x0000006d004e7306ULL, 0x000ff00000209400ULL, 0x0000006d004f7306ULL, 0x000fe20000205400ULL,
0x0000000138383812ULL, 0x002fce00078efcffULL, 0x0000006d00407306ULL, 0x000ff0000020d400ULL,
0x0000006900417306ULL, 0x000ff00000209400ULL, 0x0000006900587306ULL, 0x000e700000205400ULL,
0x0000006a006d7306ULL, 0x000ff00000209400ULL, 0x0000006a00547306ULL, 0x000ea20000205400ULL,
0x000000584100720bULL, 0x002fce0003f7d000ULL, 0x0000006c005c7306ULL, 0x000ff00000209400ULL,
0x0000006c00597306ULL, 0x000fe20000205400ULL, 0x000000546d00720bULL, 0x004fe40003f9d000ULL,
0x000000686354723eULL, 0x000fe200000010ffULL, 0x0000010043637824ULL, 0x000fc800078e00ffULL,
0x0000006c00417306ULL, 0x000fe2000020d400ULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x000000543c28723cULL, 0x000bec0000041828ULL, 0x0000006900697306ULL, 0x000e62000020d400ULL,
0x000000676555723eULL, 0x020fe200000010ffULL, 0x000001003a677824ULL, 0x000fe200078e00ffULL,
0x000000615f54723eULL, 0x000fc800000010ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x00000042006d7306ULL, 0x000fe40000009400ULL, 0x000000543c24723cULL, 0x000b6c0000041824ULL,
0x00000042006c7306ULL, 0x000ea20000005400ULL, 0x0000000169693812ULL, 0x002fc400078efcffULL,
0x000000385e54723eULL, 0x020fe200000010ffULL, 0x0001000043387824ULL, 0x000fe200078e00ffULL,
0x000000695d55723eULL, 0x000fc600000010ffULL, 0x0000006a00627306ULL, 0x000e68000020d400ULL,
0x000000543c20723cULL, 0x000b680000041820ULL, 0x0000004200647306ULL, 0x000ee2000000d400ULL,
0x0000006c6d00720bULL, 0x004fe20003f7d000ULL, 0x00010000426d7824ULL, 0x000fc400078e00ffULL,
0x0001000039557824ULL, 0x020fc600078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x00000043006a7306ULL, 0x000fe20000009400ULL, 0x0000000162624812ULL, 0x002fce00078efcffULL,
0x0000004300657306ULL, 0x000e620000005400ULL, 0x0000000164643812ULL, 0x008fce00078efcffULL,
0x00000070005a7306ULL, 0x000ff00000209400ULL, 0x00000070005b7306ULL, 0x000fe20000205400ULL,
0x000000656a00720bULL, 0x002fe40003f7d000ULL, 0x00000018ff657819ULL, 0x000fc40000011438ULL,
0x000000646238723eULL, 0x000fe400000010ffULL, 0x00000018ff647819ULL, 0x000fe20000011455ULL,
0x0000007000587306ULL, 0x000ff0000020d400ULL, 0x0000006300687306ULL, 0x000ff00000209400ULL,
0x0000006300707306ULL, 0x000e700000205400ULL, 0x0000006300637306ULL, 0x000eb0000020d400ULL,
0x00000043005e7306ULL, 0x000ee2000000d400ULL, 0x000000706800720bULL, 0x002fe20003fdd000ULL,
0x000100003a687824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011468ULL,
0x0000006d006c7306ULL, 0x000fec0000209400ULL, 0x0000000163636812ULL, 0x004fe400078efcffULL,
0x0000006d005f7306ULL, 0x000e620000205400ULL, 0x000000015e5e3812ULL, 0x008fce00078efcffULL,
0x00000065005d7306ULL, 0x000ff00000209400ULL, 0x0000006500547306ULL, 0x000ea20000205400ULL,
0x0000005f6c00720bULL, 0x002fce0003f9d000ULL, 0x0000005700577306ULL, 0x000e70000020d400ULL,
0x0000006d00617306ULL, 0x000ee2000020d400ULL, 0x000000545d00720bULL, 0x004fce0003f7d000ULL,
0x0000006500627306ULL, 0x000ea2000020d400ULL, 0x0000000157572812ULL, 0x002fe400078efcffULL,
0x0000004f4e00720bULL, 0x000fca0003f5d000ULL, 0x0000003900427306ULL, 0x000fe20000009400ULL,
0x0000000161614812ULL, 0x008fe400078efcffULL, 0x000000595c00720bULL, 0x000fca0003f9d000ULL,
0x00000039005f7306ULL, 0x000e620000005400ULL, 0x0000000162623812ULL, 0x004fe400078efcffULL,
0x000000565100720bULL, 0x000fe20003f7d000ULL, 0x000100003b567824ULL, 0x000fe200078e00ffULL,
0x0000000140402812ULL, 0x000fc600078efcffULL, 0x0000003900437306ULL, 0x0005e2000000d400ULL,
0x0000000141414812ULL, 0x000fe400078efcffULL, 0x0000005b5a00720bULL, 0x000fe40003f9d000ULL,
0x00000018ff567819ULL, 0x000fc60000011456ULL, 0x0000003a00707306ULL, 0x000fe20000009400ULL,
0x0000005e6339723eULL, 0x004fe400000010ffULL, 0x0000000152523812ULL, 0x000fe400078efcffULL,
0x0000004c4d00720bULL, 0x000fe40003f7d000ULL, 0x0000005f4200720bULL, 0x002fe20003fdd000ULL,
0x000000383c1c723cULL, 0x000b62000004181cULL, 0x0000003a00717306ULL, 0x000e620000005400ULL,
0x0000000158584812ULL, 0x000fc400078efcffULL, 0x0000004a4800720bULL, 0x000fe40003f9d000ULL,
0x000000524052723eULL, 0x000fe200000010ffULL, 0x0000000808397824ULL, 0x020fe200078e00ffULL,
0x000000615338723eULL, 0x000fe200000010ffULL, 0x0000006400557306ULL, 0x000fe20000209400ULL,
0x0000000144443812ULL, 0x000fe400078efcffULL, 0xfffffff839167812ULL, 0x000fe400078ee216ULL,
0x000000625739723eULL, 0x000fc400000010ffULL, 0x000000474900720bULL, 0x000fe20003f7d000ULL,
0x0000001016617824ULL, 0x000fe200078e0274ULL, 0x0000003a00627306ULL, 0x000ea2000000d400ULL,
0x000000717000720bULL, 0x002fe40003fbd000ULL, 0x000000383c3c723cULL, 0x000b620000041818ULL,
0x0000000143436812ULL, 0x000fe200078efcffULL, 0x000000006118783bULL, 0x0202e20000004200ULL,
0x0000000117174812ULL, 0x000fe400078efcffULL, 0x0000003b00397306ULL, 0x000fe20000005400ULL,
0x000000414444723eULL, 0x000fe200000010ffULL, 0x000001003b387824ULL, 0x000fe200078e00ffULL,
0x0000000145453812ULL, 0x000fc800078efcffULL, 0x00000018ff697819ULL, 0x000fe20000011438ULL,
0x0000003b00617306ULL, 0x002fe2000000d400ULL, 0x0000000162625812ULL, 0x004fce00078efcffULL,
0x0000003b00387306ULL, 0x000e700000009400ULL, 0x0000006400547306ULL, 0x000ea20000205400ULL,
0x000000393800720bULL, 0x002fce0003f5d000ULL, 0x00000064005d7306ULL, 0x000e62000020d400ULL,
0x00000018ff3a7819ULL, 0x008fe20000011418ULL, 0x0000010018487824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011419ULL, 0x00000100194a7824ULL, 0x000fc800078e00ffULL,
0x0000003a006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff717819ULL, 0x000fe2000001141aULL,
0x000001001b407824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011448ULL,
0x000000545500720bULL, 0x004fe40003fdd000ULL, 0x00000018ff5a7819ULL, 0x000fe2000001144aULL,
0x0000003a006d7306ULL, 0x000fe20000205400ULL, 0x0000000161612812ULL, 0x000fe400078efcffULL,
0x00000018ff5b7819ULL, 0x000fca000001141bULL, 0x0000003a004e7306ULL, 0x0005e4000020d400ULL,
0x000000015d5d6812ULL, 0x002fc800078efcffULL, 0x0000005d4545723eULL, 0x000fe400000010ffULL,
0x00000067005e7306ULL, 0x000fe20000209400ULL, 0x011800001238783bULL, 0x004e6e0000000200ULL,
0x0000006700537306ULL, 0x000eb00000205400ULL, 0x0000006900647306ULL, 0x000ff00000209400ULL,
0x0000006900657306ULL, 0x000ee20000205400ULL, 0x000000535e00720bULL, 0x004fe20003fdd000ULL,
0x0001000018537824ULL, 0x000fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000006900577306ULL, 0x000eb0000020d400ULL, 0x0000005600697306ULL, 0x000fe20000209400ULL,
0x0000000b38388231ULL, 0x082fe200003400ffULL, 0x000000656400720bULL, 0x008fe20003f7d000ULL,
0x0000000b3a3a8231ULL, 0x000fc400003400ffULL, 0x0000000a39398231ULL, 0x080fe400003400ffULL,
0x0000000a3b3b8231ULL, 0x000fe200003400ffULL, 0x00000056006a7306ULL, 0x000e620000205400ULL,
0x000000464b00720bULL, 0x000fca0003f1d000ULL, 0x000000443830723cULL, 0x000b620000041830ULL,
0x0000000157573812ULL, 0x004fe200078efcffULL, 0x00000056004f7306ULL, 0x000eac000020d400ULL,
0x0000000113130812ULL, 0x000fe400078efcffULL, 0x00000070005f7306ULL, 0x000fe20000209400ULL,
0x0000006a6900720bULL, 0x002fce0003f5d000ULL, 0x00000070005c7306ULL, 0x000fec0000205400ULL,
0x000000014f4f2812ULL, 0x004fe400078efcffULL, 0x0000007000427306ULL, 0x000ff0000020d400ULL,
0x0000007100567306ULL, 0x000ff00000209400ULL, 0x0000007100597306ULL, 0x000ff00000205400ULL,
0x00000071004c7306ULL, 0x000ff0000020d400ULL, 0x0000004900717306ULL, 0x000ff00000209400ULL,
0x0000004900707306ULL, 0x000e700000205400ULL, 0x0000004900487306ULL, 0x000eb0000020d400ULL,
0x0000001900497306ULL, 0x000fe20000009400ULL, 0x000000707100720bULL, 0x002fce0003f9d000ULL,
0x00000019004a7306ULL, 0x000e6c0000005400ULL, 0x0000000148484812ULL, 0x004fe400078efcffULL,
0x0000006700637306ULL, 0x000eb0000020d400ULL, 0x0000007200677306ULL, 0x000fe20000209400ULL,
0x0000004a4900720bULL, 0x002fe20003fbd000ULL, 0x0001000019497824ULL, 0x000fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011449ULL, 0x0000007200687306ULL, 0x000e620000205400ULL,
0x000001001a497824ULL, 0x000fe200078e00ffULL, 0x0000000163636812ULL, 0x004fc800078efcffULL,
0x00000018ff767819ULL, 0x000fe40000011449ULL, 0x00000018004b7306ULL, 0x000fe20000009400ULL,
0x000000626362723eULL, 0x000fe400000010ffULL, 0x000000615763723eULL, 0x000fca00000010ffULL,
0x0000001800547306ULL, 0x000ea20000005400ULL, 0x000000686700720bULL, 0x002fe20003f7d000ULL,
0x00000062382c723cULL, 0x000f6c000004182cULL, 0x0000007200517306ULL, 0x000e70000020d400ULL,
0x0000005a00557306ULL, 0x000fe20000209400ULL, 0x000000544b00720bULL, 0x004fce0003fdd000ULL,
0x0000005a00727306ULL, 0x000ea20000205400ULL, 0x0000000151513812ULL, 0x002fe400078efcffULL,
0x0000006d6c00720bULL, 0x000fe40003f7d000ULL, 0x00000018ff6c7819ULL, 0x000fc60000011440ULL,
0x0000005300647306ULL, 0x000ff00000209400ULL, 0x0000005300657306ULL, 0x000e620000205400ULL,
0x000000725500720bULL, 0x004fe40003f5d000ULL, 0x000000014e4e3812ULL, 0x000fc400078efcffULL,
0x000000595600720bULL, 0x000fc60003f7d000ULL, 0x0000005b004d7306ULL, 0x000ff00000209400ULL,
0x0000005b00477306ULL, 0x000fe20000205400ULL, 0x000000656400720bULL, 0x002fe20003f1d000ULL,
0x000100001a647824ULL, 0x000fe200078e00ffULL, 0x000000014c4c3812ULL, 0x000fe200078efcffULL,
0x000100001b657824ULL, 0x000fc600078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000005b00127306ULL, 0x000fe2000020d400ULL, 0x00000018ff5d7819ULL, 0x000fce0000011465ULL,
0x0000005a00467306ULL, 0x000e70000020d400ULL, 0x00000053004a7306ULL, 0x0004f0000020d400ULL,
0x00000073005b7306ULL, 0x000fe20000209400ULL, 0x000000435853723eULL, 0x004fc400000010ffULL,
0x0000000146462812ULL, 0x002fca00078efcffULL, 0x00000073005e7306ULL, 0x000e620000205400ULL,
0x000000523834723cULL, 0x000b620000041834ULL, 0x000000014a4a0812ULL, 0x008fcc00078efcffULL,
0x0000007600547306ULL, 0x000ff00000209400ULL, 0x00000076005a7306ULL, 0x000ea20000205400ULL,
0x0000005e5b00720bULL, 0x002fce0003f5d000ULL, 0x00000018004b7306ULL, 0x000e70000000d400ULL,
0x0000001900187306ULL, 0x000ee2000000d400ULL, 0x0000005a5400720bULL, 0x004fce0003f1d000ULL,
0x0000001a00677306ULL, 0x000fe20000009400ULL, 0x000000014b4b6812ULL, 0x002fc800078efcffULL,
0x0000004b4844723eULL, 0x020fc600000010ffULL, 0x0000001a00687306ULL, 0x000e620000005400ULL,
0x0000000118185812ULL, 0x008fe400078efcffULL, 0x0000005c5f00720bULL, 0x000fe40003fbd000ULL,
0x000000184645723eULL, 0x000fe400000010ffULL, 0x0000004a4e18723eULL, 0x000fe200000010ffULL,
0x0000007300197306ULL, 0x000ea8000020d400ULL, 0x000000443824723cULL, 0x000b680000041824ULL,
0x0000007600497306ULL, 0x000ee2000020d400ULL, 0x000000686700720bULL, 0x002fc40003f9d000ULL,
0x0000000142425812ULL, 0x000fca00078efcffULL, 0x0000001a00527306ULL, 0x000322000000d400ULL,
0x0000000119192812ULL, 0x004fe400078efcffULL, 0x000000474d00720bULL, 0x000fe40003f5d000ULL,
0x000000194219723eULL, 0x000fc600000010ffULL, 0x0000001b00697306ULL, 0x000fe20000009400ULL,
0x0000000149490812ULL, 0x008fe400078efcffULL, 0x00000051171a723eULL, 0x002fe200000010ffULL,
0x000000183820723cULL, 0x000b680000041820ULL, 0x0000001b006a7306ULL, 0x000e620000005400ULL,
0x0000000152524812ULL, 0x010fe400078efcffULL, 0x0000000112122812ULL, 0x000fc400078efcffULL,
0x000000524942723eULL, 0x000fc600000010ffULL, 0x0000006c00587306ULL, 0x000ff00000209400ULL,
0x0000006c00557306ULL, 0x000ea20000205400ULL, 0x0000006a6900720bULL, 0x002fce0003fdd000ULL,
0x0000006400537306ULL, 0x000ff00000209400ULL, 0x0000006400417306ULL, 0x000e620000205400ULL,
0x000000555800720bULL, 0x004fce0003fbd000ULL, 0x0000005d005b7306ULL, 0x000ff00000209400ULL,
0x0000005d00547306ULL, 0x000ea20000205400ULL, 0x000000415300720bULL, 0x002fce0003f1d000ULL,
0x0000001b00437306ULL, 0x0002f0000000d400ULL, 0x0000006c00407306ULL, 0x000f22000020d400ULL,
0x0000004f131b723eULL, 0x002fe400000010ffULL, 0x000000545b00720bULL, 0x004fca0003f9d000ULL,
0x0000006400137306ULL, 0x000e62000020d400ULL, 0x0000000143436812ULL, 0x008fe200078efcffULL,
0x0000001a3828723cULL, 0x000b6c0000041828ULL, 0x0000005d004d7306ULL, 0x000ea2000020d400ULL,
0x0000000140405812ULL, 0x010fc800078efcffULL, 0x000000434043723eULL, 0x000fe400000010ffULL,
0x0000000113130812ULL, 0x002fc800078efcffULL, 0x000000134c4c723eULL, 0x000fe200000010ffULL,
0x00000042381c723cULL, 0x000b62000004181cULL, 0x000000014d4d4812ULL, 0x004fc800078efcffULL,
0x0000004d124d723eULL, 0x000fe400000010ffULL, 0x000176c878127811ULL, 0x000fca00078e18ffULL,
0x0000004c383c723cULL, 0x000b62000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017690006fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff177224ULL, 0x000fc600078e00ffULL, 0x0000000000187805ULL, 0x020fc80000015200ULL,
0x000004000f1b7984ULL, 0x000ee40000000800ULL, 0x800000001bff7812ULL, 0x00afe40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a18397210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x000000391a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000117177810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000f1b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c00e187810ULL, 0x000fca0007ffe0ffULL,
0x000066007b387a24ULL, 0x000fe200078e0218ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000001877127217ULL, 0x000fe20007800000ULL, 0x0000001079177824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fc60000011611ULL, 0x0000000112127824ULL, 0x000fe200078e0a18ULL,
0x00000004131a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000117187824ULL, 0x000fe200078e0213ULL,
0x0000000c131b7810ULL, 0x000fe40007ffe0ffULL, 0x0000001217127217ULL, 0x000fe20007800000ULL,
0x0000000118197824ULL, 0x040fe400078e0211ULL, 0x00000008183a7824ULL, 0x000fe400078e00ffULL,
0x0000000112127824ULL, 0x000fc600078e0a17ULL, 0xfffffff83a3b7812ULL, 0x000fe200078ee219ULL,
0x00000001173a7824ULL, 0x040fe200078e021bULL, 0x000000121a00720cULL, 0x080fe20003f66070ULL,
0x00000001171a7824ULL, 0x000fe200078e021aULL, 0x0000000813197810ULL, 0x040fe40007ffe0ffULL,
0x000000121300720cULL, 0x080fe20003f86070ULL, 0x0000000118137824ULL, 0x000fe200078e0238ULL,
0x000000121900720cULL, 0x080fe20003f46070ULL, 0x000000011a187824ULL, 0x040fe200078e0211ULL,
0x000000121b00720cULL, 0x000fe20003f06070ULL, 0x000000081a417824ULL, 0x000fc400078e00ffULL,
0x0000000117197824ULL, 0x000fe400078e0219ULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fc600078ee218ULL, 0x000000011a187824ULL, 0x100fe200078e0238ULL,
0x0000006012127212ULL, 0x080fe200078efcffULL, 0x00000001191a7824ULL, 0x140fe400078e0238ULL,
0x0000000119177824ULL, 0x040fe200078e0211ULL, 0x0000620012127a10ULL, 0x000fe20007fbe0ffULL,
0x0000000819407824ULL, 0x000fe400078e00ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000630013137a10ULL, 0x000fe40002ffe4ffULL, 0xfffffff840437812ULL, 0x000fe200078ee217ULL,
0x000000013a387824ULL, 0x000fe200078e0238ULL, 0x0000006018187212ULL, 0x000fe200078efcffULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0x0000620018187a10ULL, 0x000fe20007fbe0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x000000601a1a7212ULL, 0x080fe400078efcffULL,
0x0000630019197a10ULL, 0x000fe20002ffe4ffULL, 0x000000013a177824ULL, 0x000fe200078e0211ULL,
0x0000006038387212ULL, 0x000fe200078efcffULL, 0x000000083a3a7824ULL, 0x000fe200078e00ffULL,
0x000062001a1a7a10ULL, 0x000fe40007fbe0ffULL, 0x0000620038387a10ULL, 0x000fc40007fde0ffULL,
0xfffffff83a457812ULL, 0x000fe200078ee217ULL, 0x000000103b177824ULL, 0x100fe200078e0274ULL,
0x000063001b1b7a10ULL, 0x000fe20002ffe4ffULL, 0x00000010413b7824ULL, 0x100fe200078e0274ULL,
0x0000630039397a10ULL, 0x000fe200037fe4ffULL, 0x0000001043417824ULL, 0x100fe200078e0274ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012177faeULL, 0x0003e2000e101c48ULL,
0x0000001045437824ULL, 0x000fc600078e0274ULL, 0x00000000183b7faeULL, 0x0003e8000d901c48ULL,
0x000000001a417faeULL, 0x0003e8000d101c48ULL, 0x0000000038437faeULL, 0x0003e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001079127824ULL, 0x000fca00078e00ffULL,
0x0000001211137211ULL, 0x000fc800078fe8ffULL, 0x00000004133a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000113127824ULL, 0x140fe200078e0211ULL, 0x00000008131a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000813177824ULL, 0x000fe400078e00ffULL, 0x000000013a187824ULL, 0x140fe400078e0211ULL,
0x000000083a417824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee212ULL,
0x0000000113127824ULL, 0x000fe400078e0238ULL, 0x000000011a197824ULL, 0x040fe200078e0211ULL,
0xfffffff841417812ULL, 0x000fe200078ee218ULL, 0x000000081a407824ULL, 0x000fe200078e00ffULL,
0x0000000c13187810ULL, 0x000fe20007ffe0ffULL, 0x000000013a3a7824ULL, 0x000fc400078e0238ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff840437812ULL, 0x000fc600078ee219ULL,
0x000000011a1a7824ULL, 0x100fe400078e0238ULL, 0x0000000118387824ULL, 0x000fe400078e0238ULL,
0x000000803a3a7825ULL, 0x000fc800078e00ffULL, 0x0000000118197824ULL, 0x040fe400078e0211ULL,
0x0000000818407824ULL, 0x000fe200078e00ffULL, 0x0000006012187212ULL, 0x080fe200078efcffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x000000603a127212ULL, 0x080fe400078efcffULL,
0x0000620018187a10ULL, 0x000fe20007f1e0ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000000601a1a7212ULL, 0x080fe400078efcffULL, 0xfffffff840457812ULL, 0x000fe200078ee219ULL,
0x0000001017177824ULL, 0x000fe200078e0274ULL, 0x0000006038387212ULL, 0x000fc400078efcffULL,
0x0000620012127a10ULL, 0x000fe40007f5e0ffULL, 0x0000630013197a10ULL, 0x000fe400007fe4ffULL,
0x000062001a1a7a10ULL, 0x000fe40007f1e0ffULL, 0x0000620038387a10ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018177faeULL, 0x0003e2000b901c48ULL,
0x000063003b137a10ULL, 0x000fe200017fe4ffULL, 0x00000010413b7824ULL, 0x100fe200078e0274ULL,
0x000063001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x0000001043417824ULL, 0x100fe200078e0274ULL,
0x0000630039397a10ULL, 0x000fe20001ffe4ffULL, 0x0000001045437824ULL, 0x000fe200078e0274ULL,
0x00000000123b7faeULL, 0x0003e8000b901c48ULL, 0x000000001a417faeULL, 0x0003e8000b901c48ULL,
0x0000000038437faeULL, 0x0003e4000b901c48ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff010407812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b00040407f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017648000d127f8cULL, 0x0006a4000c80043fULL,
0x0000000000187805ULL, 0x000fc40000015200ULL, 0xffffffe0100d7812ULL, 0x048fe400078ec0ffULL,
0x00000010101a7812ULL, 0x040fe400078ec0ffULL, 0x0000000810177812ULL, 0x000fc800078ec0ffULL,
0x0000000d170d7210ULL, 0x000fca0007ffe01aULL, 0x01764c000d177984ULL, 0x000ee40000000800ULL,
0x8000000017ff7812ULL, 0x00cfe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09001a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc8000001141bULL, 0x0000001a17177211ULL, 0x000fca00078110ffULL,
0x000000ffff1a7224ULL, 0x000fca00000e061bULL, 0x0000000217177819ULL, 0x000fc8000000121aULL,
0x000000170000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c000d177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020020d7824ULL, 0x000fca00078e00ffULL,
0xffffff800d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000010060127810ULL, 0x000fca0007ffe00dULL,
0x0000000175127824ULL, 0x000fca00078e0212ULL, 0x0170000012187984ULL, 0x000ea80000000800ULL,
0x01720000120d7984ULL, 0x0006620000000800ULL, 0x000000071800720bULL, 0x004fe20003f1d000ULL,
0x0000f6827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff13197812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff177424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000027c137810ULL, 0x000fe40007ffe0ffULL, 0x000000071800720bULL, 0x000fe40003f54000ULL,
0x000000021300720cULL, 0x000fe20003f05270ULL, 0x0000f6427f007947ULL, 0x000fd4000b800000ULL,
0x0000000000127806ULL, 0x000fc400010e0100ULL, 0x00000080021a8824ULL, 0x000fe200078e0260ULL,
0x0000000718138209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991012177816ULL, 0x000fe200000000ffULL, 0x00000001751a8824ULL, 0x000fca00078e021aULL,
0x017400131a008388ULL, 0x0005e20000000800ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000007181a7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff12ff7812ULL, 0x000fc6000780c0ffULL,
0x000000071a137221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300177308ULL, 0x000ea40000000800ULL, 0x0000001706067220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011611ULL,
0x0000f5727f007947ULL, 0x000fea000b800000ULL, 0x00001f1317137589ULL, 0x0004e400000e0000ULL,
0x0000001334347220ULL, 0x08cfe40000410000ULL, 0x0000001335357220ULL, 0x080fe40000410000ULL,
0x0000001330307220ULL, 0x080fe40000410000ULL, 0x0000001331317220ULL, 0x000fc40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x080fe40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x000fc40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x080fe40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x000000133c3c7220ULL, 0x080fe40000410000ULL, 0x000000133d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0012ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000811137811ULL, 0x000fe200078ff0ffULL,
0x0000f4727f007947ULL, 0x000fea000b800000ULL, 0x00001f1317137589ULL, 0x0004e400000e0000ULL,
0x0000001336367220ULL, 0x08cfe40000410000ULL, 0x0000001337377220ULL, 0x080fe40000410000ULL,
0x0000001332327220ULL, 0x080fe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x000fc40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x080fe40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x000fc40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x000000133e3e7220ULL, 0x080fe40000410000ULL, 0x000000133f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff19ff7812ULL, 0x000fe20007806012ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x0000000718077209ULL, 0x000fd60007810000ULL,
0x8000000718180221ULL, 0x000fe20000010000ULL, 0x00007610ff170816ULL, 0x000fc60000000017ULL,
0x3fb8aa3b18180820ULL, 0x000fc80000410000ULL, 0x00000018000c0308ULL, 0x000ea40000000800ULL,
0x0000000c0d0d0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000060d067221ULL, 0x002fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0xfffffff0101b7812ULL, 0x000fca00078ec0ffULL, 0x0176ac001b0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001812187210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e13ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011419ULL, 0x000000180d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0619ULL, 0x000000020d0d7819ULL, 0x000fc80000001218ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac001b0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910170d7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x0000000cff0a723eULL, 0x000fe400000010ffULL,
0x00000002ff127819ULL, 0x000fe40000011611ULL, 0x000054100a0d7816ULL, 0x000fe2000000000aULL,
0x0000f0527f007947ULL, 0x000fea000b800000ULL, 0x00001f120d0b7589ULL, 0x0002a400000e0000ULL,
0x0000000812137810ULL, 0x000fe20007ffe0ffULL, 0x0000f0a27f007947ULL, 0x000fea000b800000ULL,
0x00001f130d0a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001012137810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e000dULL,
0x0000980000397802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000f89000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001812137810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200078e000dULL, 0x0000987000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000f82000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000187824ULL, 0x100fe200078e026eULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001050387824ULL, 0x000fc800078e026eULL, 0x000000001818783bULL, 0x000f280000004200ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x00000018ff007819ULL, 0x010fe20000011418ULL,
0x00000018005b7306ULL, 0x000fe20000009400ULL, 0x00000018ff137819ULL, 0x00cfe4000001141aULL,
0x00000018ff437819ULL, 0x000fe40000011439ULL, 0x00000018ff127819ULL, 0x002fc40000011419ULL,
0x00000018ff177819ULL, 0x000fe20000011438ULL, 0x00000000004d7306ULL, 0x000fe20000209400ULL,
0x00000018ff157819ULL, 0x000fce000001141bULL, 0x00000000004e7306ULL, 0x000ff00000205400ULL,
0x0000000000677306ULL, 0x0003f0000020d400ULL, 0x0000001300477306ULL, 0x000fe20000209400ULL,
0x0000000811007812ULL, 0x002fc800078ec0ffULL, 0x0000000700007812ULL, 0x000fc600078ef811ULL,
0x0000001300467306ULL, 0x000fe40000205400ULL, 0x0000000100037824ULL, 0x040fe400078e0203ULL,
0x0000000800007824ULL, 0x000fc800078e00ffULL, 0x0000001300627306ULL, 0x0003f0000020d400ULL,
0x00000043005f7306ULL, 0x000fe20000209400ULL, 0xfffffff800137812ULL, 0x002fca00078ee203ULL,
0x0000001013487824ULL, 0x000fe400078e026eULL, 0x0000010018137824ULL, 0x000fe200078e00ffULL,
0x00000043005d7306ULL, 0x000fe60000205400ULL, 0x000000004848783bULL, 0x000e620000004200ULL,
0x00000018ff137819ULL, 0x000fc80000011413ULL, 0x0000001300537306ULL, 0x000ff00000209400ULL,
0x0000001300547306ULL, 0x000eb00000205400ULL, 0x0000004300007306ULL, 0x0003f0000020d400ULL,
0x00000012004c7306ULL, 0x000fe20000209400ULL, 0x000000545300720bULL, 0x004fce0003fdd000ULL,
0x00000012004f7306ULL, 0x000fe20000205400ULL, 0x0000010048437824ULL, 0x042fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011448ULL, 0x0001000048537824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fc80000011449ULL, 0x0000001200657306ULL, 0x000fe2000020d400ULL,
0x00000018ff6c7819ULL, 0x000fe40000011443ULL, 0x00000018ff707819ULL, 0x000fca0000011453ULL,
0x00000017000d7306ULL, 0x000ff00000209400ULL, 0x0000001700127306ULL, 0x000ff00000205400ULL,
0x0000001700037306ULL, 0x0003f0000020d400ULL, 0x0000006c005a7306ULL, 0x000fe20000209400ULL,
0x0000010019177824ULL, 0x002fca00078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011417ULL,
0x0000006c00437306ULL, 0x000e700000205400ULL, 0x0000004800597306ULL, 0x000ff00000009400ULL,
0x00000048006a7306ULL, 0x000ea20000005400ULL, 0x000000435a00720bULL, 0x002fe20003f7d000ULL,
0x0000010049437824ULL, 0x000fcc00078e00ffULL, 0x0000001500457306ULL, 0x000ff00000209400ULL,
0x0000001500447306ULL, 0x000fe20000205400ULL, 0x0000006a5900720bULL, 0x004fe40003f9d000ULL,
0x00000018ff6a7819ULL, 0x000fca0000011443ULL, 0x0000001500617306ULL, 0x000ff0000020d400ULL,
0x0000001300157306ULL, 0x000e70000020d400ULL, 0x0000004200647306ULL, 0x000ff00000209400ULL,
0x0000004200637306ULL, 0x000ea20000205400ULL, 0x0000000115156812ULL, 0x002fce00078efcffULL,
0x0000004200177306ULL, 0x000e70000020d400ULL, 0x0000005600557306ULL, 0x000fe20000209400ULL,
0x000000636400720bULL, 0x004fce0003fdd000ULL, 0x0000005600687306ULL, 0x000fec0000205400ULL,
0x0000000117176812ULL, 0x002fe400078efcffULL, 0x0000005600527306ULL, 0x000fe2000020d400ULL,
0x000000464700720bULL, 0x000fce0003fdd000ULL, 0x0000006d00137306ULL, 0x000fec0000209400ULL,
0x0000000162626812ULL, 0x000fe400078efcffULL, 0x0000006d00427306ULL, 0x000ff00000205400ULL,
0x0000006d00517306ULL, 0x000ff0000020d400ULL, 0x0000004900567306ULL, 0x000ff00000009400ULL,
0x00000049006d7306ULL, 0x000e700000005400ULL, 0x00000018005c7306ULL, 0x000ff00000005400ULL,
0x0000001800147306ULL, 0x0005e2000000d400ULL, 0x0000006d5600720bULL, 0x002fe20003fbd000ULL,
0x0001000049567824ULL, 0x000fcc00078e00ffULL, 0x0000007000547306ULL, 0x000fe20000209400ULL,
0x0001000018187824ULL, 0x004fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011418ULL,
0x00000070006f7306ULL, 0x000e700000205400ULL, 0x0000006c00587306ULL, 0x0004f0000020d400ULL,
0x0000005700697306ULL, 0x000fe20000209400ULL, 0x0000006f5400720bULL, 0x002fc40003f5d000ULL,
0x00000018ff6c7819ULL, 0x004fca0000011456ULL, 0x00000057005e7306ULL, 0x000fe20000205400ULL,
0x0000000158583812ULL, 0x008fe400078efcffULL, 0x000000685500720bULL, 0x000fca0003f7d000ULL,
0x0000005700187306ULL, 0x000ff0000020d400ULL, 0x0000004800577306ULL, 0x000e62000000d400ULL,
0x0000000152523812ULL, 0x000fce00078efcffULL, 0x0000007000537306ULL, 0x000eb0000020d400ULL,
0x0000006a00437306ULL, 0x000fe20000209400ULL, 0x0000000157574812ULL, 0x002fe400078efcffULL,
0x000000421300720bULL, 0x000fe20003f9d000ULL, 0x000001004b137824ULL, 0x000fe200078e00ffULL,
0x000000575858723eULL, 0x000fc600000010ffULL, 0x0000006a00487306ULL, 0x000e620000205400ULL,
0x0000000153532812ULL, 0x004fce00078efcffULL, 0x0000004900597306ULL, 0x0004e2000000d400ULL,
0x0000000151514812ULL, 0x000fce00078efcffULL, 0x0000006c00567306ULL, 0x000fe20000209400ULL,
0x000001004a497824ULL, 0x004fe200078e00ffULL, 0x000000484300720bULL, 0x002fe40003f5d000ULL,
0x00000018ff487819ULL, 0x000fe4000001144aULL, 0x00000018ff707819ULL, 0x000fe40000011449ULL,
0x0000006c006d7306ULL, 0x000e620000205400ULL, 0x0000000159595812ULL, 0x008fce00078efcffULL,
0x0000006a005a7306ULL, 0x000eb0000020d400ULL, 0x0000007000497306ULL, 0x000fe20000209400ULL,
0x0000006d5600720bULL, 0x002fce0003f7d000ULL, 0x0000007000687306ULL, 0x000e620000205400ULL,
0x000000015a5a2812ULL, 0x004fc800078efcffULL, 0x000000595a59723eULL, 0x000fc600000010ffULL,
0x0000006c00547306ULL, 0x0004f0000020d400ULL, 0x0000004a006a7306ULL, 0x000fe20000009400ULL,
0x00000018ff6c7819ULL, 0x004fe40000011413ULL, 0x000000684900720bULL, 0x002fe20003f5d000ULL,
0x000100004a687824ULL, 0x000fc800078e00ffULL, 0x0000006c00427306ULL, 0x000fe20000209400ULL,
0x0000000154543812ULL, 0x008fce00078efcffULL, 0x0000006c00437306ULL, 0x000e700000205400ULL,
0x0000004a006f7306ULL, 0x000eb00000005400ULL, 0x0000007000557306ULL, 0x000722000020d400ULL,
0x000000434200720bULL, 0x002fce0003f7d000ULL, 0x0000004a00567306ULL, 0x000e62000000d400ULL,
0x00000018ff707819ULL, 0x008fe40000011468ULL, 0x0000006f6a00720bULL, 0x004fca0003fbd000ULL,
0x0000007000687306ULL, 0x000fe20000209400ULL, 0x0000000155552812ULL, 0x010fce00078efcffULL,
0x0000007000437306ULL, 0x000ea20000205400ULL, 0x0000000156565812ULL, 0x002fc800078efcffULL,
0x000000565556723eULL, 0x000fc600000010ffULL, 0x0000004b00497306ULL, 0x000ff00000009400ULL,
0x0000004b006a7306ULL, 0x000e620000005400ULL, 0x000000436800720bULL, 0x004fce0003f9d000ULL,
0x00000048006f7306ULL, 0x000ff00000209400ULL, 0x00000048004a7306ULL, 0x000ea20000205400ULL,
0x0000006a4900720bULL, 0x002fe20003f5d000ULL, 0x0001000019497824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011449ULL, 0x0000006c00137306ULL, 0x000e70000020d400ULL,
0x0000004b00437306ULL, 0x000ee2000000d400ULL, 0x0000004a6f00720bULL, 0x004fce0003fbd000ULL,
0x0000004800487306ULL, 0x000ea2000020d400ULL, 0x0000000113133812ULL, 0x002fe400078efcffULL,
0x0000005c5b00720bULL, 0x000fca0003f7d000ULL, 0x0000001900687306ULL, 0x000fe20000009400ULL,
0x0000000143432812ULL, 0x008fc800078efcffULL, 0x000000431357723eULL, 0x000fc600000010ffULL,
0x00000019006d7306ULL, 0x000e620000005400ULL, 0x0000000148485812ULL, 0x004fe400078efcffULL,
0x0000004f4c00720bULL, 0x000fe20003fbd000ULL, 0x000001001a4c7824ULL, 0x000fe200078e00ffULL,
0x0000000114143812ULL, 0x000fe400078efcffULL, 0x0000005e6900720bULL, 0x000fe20003f7d000ULL,
0x0000007000427306ULL, 0x000ea2000020d400ULL, 0x000000141514723eULL, 0x000fce00000010ffULL,
0x00000019006c7306ULL, 0x000ee2000000d400ULL, 0x0000006d6800720bULL, 0x002fe40003f5d000ULL,
0x00000018ff687819ULL, 0x000fe2000001144cULL, 0x00000010164c7824ULL, 0x000fe200078e026eULL,
0x0000000165655812ULL, 0x000fe400078efcffULL, 0x0000000118183812ULL, 0x000fe200078efcffULL,
0x0000006800637306ULL, 0x000fe20000209400ULL, 0x0000000142424812ULL, 0x004fe400078efcffULL,
0x0000004e4d00720bULL, 0x000fc40003f9d000ULL, 0x000000004c4c783bULL, 0x000e620000004200ULL,
0x00000018ff707819ULL, 0x000fe4000001143aULL, 0x00000068005e7306ULL, 0x000ea20000205400ULL,
0x000000016c6c2812ULL, 0x008fe400078efcffULL, 0x000000444500720bULL, 0x000fe20003f5d000ULL,
0x000001001b447824ULL, 0x000fe200078e00ffULL, 0x0000006c1715723eULL, 0x000fe400000010ffULL,
0x000000424842723eULL, 0x000fe200000010ffULL, 0x0000006a00497306ULL, 0x000fe20000209400ULL,
0x00000018ff697819ULL, 0x000fc40000011444ULL, 0x0000000167674812ULL, 0x000fc800078efcffULL,
0x000000186718723eULL, 0x000fe200000010ffULL, 0x0000006a004a7306ULL, 0x000ee20000205400ULL,
0x0000005e6300720bULL, 0x004fe20003f9d000ULL, 0x000100001a637824ULL, 0x000fe200078e00ffULL,
0x0000000161612812ULL, 0x000fc800078efcffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x0000006a00197306ULL, 0x000eb0000020d400ULL, 0x00000068006a7306ULL, 0x000f22000020d400ULL,
0x0000004a4900720bULL, 0x008fc40003f7d000ULL, 0x00000018ff5e7819ULL, 0x002fe4000001144cULL,
0x00000018ff717819ULL, 0x000fc6000001144fULL, 0x0000001b00167306ULL, 0x000fec0000009400ULL,
0x0000000119193812ULL, 0x004fe400078efcffULL, 0x0000001b00457306ULL, 0x000e620000005400ULL,
0x000000016a6a4812ULL, 0x010fe400078efcffULL, 0x000000196519723eULL, 0x000fca00000010ffULL,
0x0000006900447306ULL, 0x000ff00000209400ULL, 0x0000006900477306ULL, 0x000ea20000205400ULL,
0x000000451600720bULL, 0x002fce0003fbd000ULL, 0x0000001a005b7306ULL, 0x000fe20000009400ULL,
0x000000474400720bULL, 0x004fce0003f9d000ULL, 0x0000001a005c7306ULL, 0x000e620000005400ULL,
0x012000000444783bULL, 0x0004ee0000000200ULL, 0x0000001a00647306ULL, 0x000f22000000d400ULL,
0x00000018ff047819ULL, 0x004fe4000001143bULL, 0x0000005c5b00720bULL, 0x002fca0003f7d000ULL,
0x0000001b00687306ULL, 0x0002b0000000d400ULL, 0x00000063001a7306ULL, 0x000fe20000209400ULL,
0x000100001b1b7824ULL, 0x002fe200078e00ffULL, 0x0000000164643812ULL, 0x010fc800078efcffULL,
0x00000018ff6c7819ULL, 0x000fe4000001141bULL, 0x00000063006f7306ULL, 0x000e620000205400ULL,
0x000000120d00720bULL, 0x000fe40003f7d000ULL, 0x0000000168685812ULL, 0x004fca00078efcffULL,
0x0000006900697306ULL, 0x000ea2000020d400ULL, 0x0000000b44448231ULL, 0x088fe400003400ffULL,
0x0000000b46468231ULL, 0x000fe400003400ffULL, 0x0000000a45458231ULL, 0x080fe200003400ffULL,
0x0000000103033812ULL, 0x000fe200078efcffULL, 0x0000000a47478231ULL, 0x000fe200003400ffULL,
0x0000005e00167306ULL, 0x000fe20000209400ULL, 0x0000006f1a00720bULL, 0x002fe20003fbd000ULL,
0x000001004e6f7824ULL, 0x000fe200078e00ffULL, 0x0000005d5f00720bULL, 0x000fc60003f7d000ULL,
0x000000584434723cULL, 0x000fe20000041834ULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x0000005e006d7306ULL, 0x000e620000205400ULL, 0x0000000169694812ULL, 0x004fce00078efcffULL,
0x00000004005c7306ULL, 0x000fe20000209400ULL, 0x0000000100003812ULL, 0x000fce00078efcffULL,
0x00000004005b7306ULL, 0x000fe20000205400ULL, 0x0000006d1600720bULL, 0x002fe40003f9d000ULL,
0x000000144414723cULL, 0x000b6a0000041824ULL, 0x00000004000d7306ULL, 0x000fe4000020d400ULL,
0x000001004c247824ULL, 0x020fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000006300637306ULL, 0x000e70000020d400ULL, 0x0000006c00047306ULL, 0x000ff00000209400ULL,
0x0000006c001b7306ULL, 0x000ea20000205400ULL, 0x0000000163635812ULL, 0x002fce00078efcffULL,
0x0000002400257306ULL, 0x000fe20000209400ULL, 0x0000001b0400720bULL, 0x004fce0003fbd000ULL,
0x0000002400267306ULL, 0x000e620000205400ULL, 0x0000000711047812ULL, 0x000fe200078ec0ffULL,
0x000000184418723cULL, 0x000b660000041820ULL, 0x0000000804047812ULL, 0x000fc600078ef811ULL,
0x0000006c00677306ULL, 0x0004e2000020d400ULL, 0x000000646a20723eULL, 0x020fe200000010ffULL,
0x0000000804217824ULL, 0x000fe200078e00ffULL, 0x0000000205047810ULL, 0x000fe20007ffe0ffULL,
0x000001004d6a7824ULL, 0x000fc600078e00ffULL, 0xfffffff821047812ULL, 0x000fe200078ee204ULL,
0x0000004c00227306ULL, 0x000fe20000009400ULL, 0x000000262500720bULL, 0x002fe20003fdd000ULL,
0x000100004d6c7824ULL, 0x004fe200078e00ffULL, 0x000000686921723eULL, 0x000fe200000010ffULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000004c00237306ULL, 0x000e620000005400ULL,
0x0001200009257810ULL, 0x000fe20007ffe004ULL, 0x00000020441c723cULL, 0x000b62000004181cULL,
0x0000000167675812ULL, 0x008fca00078efcffULL, 0x0000002400097306ULL, 0x0004f0000020d400ULL,
0x0000007000497306ULL, 0x000fe20000209400ULL, 0x000000002524783bULL, 0x004ea20000000200ULL,
0x000000232200720bULL, 0x002fc40003fbd000ULL, 0x00000018ff227819ULL, 0x000fc8000001144dULL,
0x00000070004a7306ULL, 0x000fe20000205400ULL, 0x0000000109096812ULL, 0x008fce00078efcffULL,
0x0000007000127306ULL, 0x0003f0000020d400ULL, 0x0000004c00697306ULL, 0x000ee2000000d400ULL,
0x000100004c707824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000002200237306ULL, 0x000ff00000209400ULL, 0x0000002200647306ULL, 0x000e620000205400ULL,
0x0000000169695812ULL, 0x008fe200078efcffULL, 0x0000000b24248231ULL, 0x004fc400003400ffULL,
0x0000000b26268231ULL, 0x000fe400003400ffULL, 0x0000000a25258231ULL, 0x080fe400003400ffULL,
0x00000070004c7306ULL, 0x000fe20000209400ULL, 0x0000000a27278231ULL, 0x000fce00003400ffULL,
0x00000070006d7306ULL, 0x000ea20000205400ULL, 0x000000642300720bULL, 0x002fce0003f5d000ULL,
0x0000004d00207306ULL, 0x020ff00000009400ULL, 0x0000004d00217306ULL, 0x000e620000005400ULL,
0x0000006d4c00720bULL, 0x004fce0003fbd000ULL, 0x0000006a00657306ULL, 0x000ff00000209400ULL,
0x0000006a00687306ULL, 0x000ea20000205400ULL, 0x000000212000720bULL, 0x002fe20003fdd000ULL,
0x000001004f207824ULL, 0x000fe200078e00ffULL, 0x000000676121723eULL, 0x000fca00000010ffULL,
0x0000002200647306ULL, 0x000e70000020d400ULL, 0x0000004d006d7306ULL, 0x000722000000d400ULL,
0x000000686500720bULL, 0x004fce0003f1d000ULL, 0x0000006f00227306ULL, 0x000fe20000209400ULL,
0x00000018ff4d7819ULL, 0x008fe40000011420ULL, 0x000000636220723eULL, 0x000fe400000010ffULL,
0x00000018ff637819ULL, 0x000fe4000001144eULL, 0x0000000164642812ULL, 0x002fe200078efcffULL,
0x0000006f00237306ULL, 0x000e620000205400ULL, 0x000000016d6d6812ULL, 0x010fce00078efcffULL,
0x0000007000657306ULL, 0x000eb0000020d400ULL, 0x0000004d00627306ULL, 0x000fe20000209400ULL,
0x000000232200720bULL, 0x002fe40003fdd000ULL, 0x000000204420723cULL, 0x000b6a000004183cULL,
0x0000004d00617306ULL, 0x000e620000205400ULL, 0x0000000165655812ULL, 0x004fe200078efcffULL,
0x00000100383e7824ULL, 0x020fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000006a006a7306ULL, 0x000eb0000020d400ULL, 0x0000006c004c7306ULL, 0x000fe20000209400ULL,
0x000000616200720bULL, 0x002fce0003fbd000ULL, 0x0000006c00687306ULL, 0x000e620000205400ULL,
0x000000016a6a0812ULL, 0x004fce00078efcffULL, 0x0000003e00617306ULL, 0x000ff00000209400ULL,
0x0000003e00707306ULL, 0x000ea20000205400ULL, 0x000000684c00720bULL, 0x002fce0003f1d000ULL,
0x0000006c006c7306ULL, 0x000e70000020d400ULL, 0x00000063003f7306ULL, 0x000fe20000209400ULL,
0x000000706100720bULL, 0x004fce0003f5d000ULL, 0x0000006300627306ULL, 0x000ea20000205400ULL,
0x000000016c6c0812ULL, 0x002fce00078efcffULL, 0x0000006f004c7306ULL, 0x000e70000020d400ULL,
0x0000007100617306ULL, 0x000fe20000209400ULL, 0x000000623f00720bULL, 0x004fce0003f1d000ULL,
0x0000007100707306ULL, 0x000ea20000205400ULL, 0x000000014c4c6812ULL, 0x002fce00078efcffULL,
0x0000005e005e7306ULL, 0x000e70000020d400ULL, 0x0000004d004d7306ULL, 0x000ee2000020d400ULL,
0x000000706100720bULL, 0x004fe20003fdd000ULL, 0x000100004e707824ULL, 0x000fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x0000004e003c7306ULL, 0x000fe20000009400ULL,
0x000000015e5e4812ULL, 0x002fce00078efcffULL, 0x0000004e003d7306ULL, 0x000e620000005400ULL,
0x000000014d4d5812ULL, 0x008fce00078efcffULL, 0x0000004f003f7306ULL, 0x000ff00000009400ULL,
0x0000004f00627306ULL, 0x000ea20000005400ULL, 0x0000003d3c00720bULL, 0x002fce0003f9d000ULL,
0x0000007100617306ULL, 0x0002e2000020d400ULL, 0x000000623f00720bULL, 0x004fce0003fbd000ULL,
0x00000038003c7306ULL, 0x000fe20000009400ULL, 0x0001000038717824ULL, 0x002fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x00000038003d7306ULL, 0x000fe20000005400ULL,
0x0000000161616812ULL, 0x008fce00078efcffULL, 0x0000004e00687306ULL, 0x000e70000000d400ULL,
0x00000038003f7306ULL, 0x000ff0000000d400ULL, 0x0000004f00677306ULL, 0x000ea2000000d400ULL,
0x0000000168684812ULL, 0x002fc400078efcffULL, 0x0000003d3c00720bULL, 0x000fe40003f9d000ULL,
0x00000069093c723eULL, 0x000fe400000010ffULL, 0x0000006d6a3d723eULL, 0x000fe200000010ffULL,
0x00000070006f7306ULL, 0x000fe20000209400ULL, 0x00000018ff6d7819ULL, 0x000fe2000001144bULL,
0x000100004b4b7824ULL, 0x000fc800078e00ffULL, 0x0000003c2414723cULL, 0x000be20000041814ULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000007000387306ULL, 0x000e620000205400ULL,
0x0000000167675812ULL, 0x004fe400078efcffULL, 0x000000013f3f4812ULL, 0x000fe400078efcffULL,
0x000000655e3c723eULL, 0x020fe200000010ffULL, 0x0000010039657824ULL, 0x000fe200078e00ffULL,
0x0000006c643d723eULL, 0x000fe200000010ffULL, 0x0000006300637306ULL, 0x000ea6000020d400ULL,
0x00000018ff657819ULL, 0x000fc60000011465ULL, 0x0000003c2418723cULL, 0x000be20000041818ULL,
0x000000386f00720bULL, 0x002fe20003fbd000ULL, 0x000100004f6f7824ULL, 0x000fe200078e00ffULL,
0x00000070006a7306ULL, 0x000e68000020d400ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000000163630812ULL, 0x004fe400078efcffULL, 0x0000006f00697306ULL, 0x000ff00000209400ULL,
0x0000006f005e7306ULL, 0x000ea20000205400ULL, 0x000000016a6a5812ULL, 0x002fce00078efcffULL,
0x0000003900387306ULL, 0x000ff00000009400ULL, 0x00000039004f7306ULL, 0x000e620000005400ULL,
0x0000005e6900720bULL, 0x004fe20003f1d000ULL, 0x00010000395e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x00000039003c7306ULL, 0x0204e2000000d400ULL,
0x0000004f3800720bULL, 0x002fce0003fbd000ULL, 0x0000006f006f7306ULL, 0x000e62000020d400ULL,
0x000000684c38723eULL, 0x000fe400000010ffULL, 0x000000674d39723eULL, 0x004fca00000010ffULL,
0x0000006d004f7306ULL, 0x000fe40000209400ULL, 0x00000038241c723cULL, 0x000be2000004181cULL,
0x000000013c3c5812ULL, 0x008fe400078efcffULL, 0x0000004a4900720bULL, 0x000fc60003fbd000ULL,
0x0000006d004c7306ULL, 0x000ea20000205400ULL, 0x000001003a387824ULL, 0x020fe200078e00ffULL,
0x000000016f6f0812ULL, 0x002fcc00078efcffULL, 0x0000004b00707306ULL, 0x000fe40000209400ULL,
0x0000000112125812ULL, 0x000fcc00078efcffULL, 0x0000004b00397306ULL, 0x000e620000205400ULL,
0x0000004c4f00720bULL, 0x004fce0003f1d000ULL, 0x00000071004e7306ULL, 0x000ff00000209400ULL,
0x0000007100627306ULL, 0x000fe20000205400ULL, 0x000000397000720bULL, 0x002fe40003fdd000ULL,
0x0000006f6139723eULL, 0x000fca00000010ffULL, 0x0000007100097306ULL, 0x0003f0000020d400ULL,
0x0000004b004f7306ULL, 0x000ea2000020d400ULL, 0x00000018ff717819ULL, 0x002fe20000011438ULL,
0x000001003b387824ULL, 0x000fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011438ULL,
0x0000006d00617306ULL, 0x000e62000020d400ULL, 0x0000006a6338723eULL, 0x000fce00000010ffULL,
0x0000006500647306ULL, 0x000fe20000209400ULL, 0x000000382420723cULL, 0x000be20000041820ULL,
0x000000014f4f6812ULL, 0x004fe400078efcffULL, 0x000000624e00720bULL, 0x000fe20003fdd000ULL,
0x000100003a627824ULL, 0x000fc600078e00ffULL, 0x00000065006c7306ULL, 0x000ea20000205400ULL,
0x0000000161610812ULL, 0x002fe400078efcffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000004f6143723eULL, 0x000fc600000010ffULL, 0x0000003b00397306ULL, 0x020fe20000009400ULL,
0x0000000109096812ULL, 0x000fce00078efcffULL, 0x0000003b005a7306ULL, 0x000e620000005400ULL,
0x0000006c6400720bULL, 0x004fce0003f1d000ULL, 0x0000003e003e7306ULL, 0x000eb0000020d400ULL,
0x0000003a004e7306ULL, 0x000fe20000009400ULL, 0x0000005a3900720bULL, 0x002fe20003f9d000ULL,
0x000100003b397824ULL, 0x000fcc00078e00ffULL, 0x0000003a00387306ULL, 0x000e620000005400ULL,
0x000000013e3e2812ULL, 0x004fc800078efcffULL, 0x0000003f3e3e723eULL, 0x000fc600000010ffULL,
0x00000065003d7306ULL, 0x000eb0000020d400ULL, 0x0000007100687306ULL, 0x000fe20000209400ULL,
0x000000384e00720bULL, 0x002fe40003f5d000ULL, 0x000000535238723eULL, 0x000fc400000010ffULL,
0x00000018ff527819ULL, 0x000fe40000011439ULL, 0x000000545139723eULL, 0x000fe200000010ffULL,
0x0000007100697306ULL, 0x000e620000205400ULL, 0x000000013d3d0812ULL, 0x004fc800078efcffULL,
0x0000003c3d3f723eULL, 0x000fc600000010ffULL, 0x0000005e00657306ULL, 0x000ff00000209400ULL,
0x0000005e00677306ULL, 0x000ea20000205400ULL, 0x000000696800720bULL, 0x002fce0003f1d000ULL,
0x0000005e004c7306ULL, 0x000e70000020d400ULL, 0x00000071004d7306ULL, 0x000ee2000020d400ULL,
0x000000676500720bULL, 0x004fce0003fdd000ULL, 0x00000070005e7306ULL, 0x000fec0000209400ULL,
0x000000014c4c6812ULL, 0x002fe400078efcffULL, 0x0000007000637306ULL, 0x000e620000205400ULL,
0x000000014d4d0812ULL, 0x008fe400078efcffULL, 0x0000005b5c00720bULL, 0x000fca0003fdd000ULL,
0x0000003a00587306ULL, 0x000eb0000000d400ULL, 0x0000006200597306ULL, 0x000fe20000209400ULL,
0x000000635e00720bULL, 0x002fe40003f7d000ULL, 0x000000010d0d6812ULL, 0x000fca00078efcffULL,
0x00000062005a7306ULL, 0x000e620000205400ULL, 0x0000000158582812ULL, 0x004fc800078efcffULL,
0x000000584d4a723eULL, 0x000fc600000010ffULL, 0x0000005200517306ULL, 0x000ff00000209400ULL,
0x0000005200547306ULL, 0x000ea20000205400ULL, 0x0000005a5900720bULL, 0x002fce0003f1d000ULL,
0x00000070004b7306ULL, 0x000e70000020d400ULL, 0x0000003b004e7306ULL, 0x000722000000d400ULL,
0x000000545100720bULL, 0x004fce0003f5d000ULL, 0x0000006200137306ULL, 0x000ea2000020d400ULL,
0x000000384438723cULL, 0x008f620000041830ULL, 0x000000014b4b3812ULL, 0x002fcc00078efcffULL,
0x0000005200527306ULL, 0x000e62000020d400ULL, 0x000000564430723cULL, 0x000b62000004182cULL,
0x000000014e4e4812ULL, 0x010fc800078efcffULL, 0x0000004e4b4b723eULL, 0x000fe400000010ffULL,
0x0000000113130812ULL, 0x004fe200078efcffULL, 0x000000424444723cULL, 0x000f640000041828ULL,
0x00000009032c723eULL, 0x020fe400000010ffULL, 0x0000004c002d723eULL, 0x000fe400000010ffULL,
0x000000131212723eULL, 0x000fe400000010ffULL, 0x0000000152522812ULL, 0x002fe200078efcffULL,
0x0000003e2428723cULL, 0x000b620000041834ULL, 0x000176987c007811ULL, 0x000fc400078e18ffULL,
0x000000520d13723eULL, 0x000fca00000010ffULL, 0x0000002c242c723cULL, 0x040b700000041838ULL,
0x0000004a2430723cULL, 0x040b700000041830ULL, 0x000000122424723cULL, 0x000b620000041844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000000f367f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff037224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x000004000f097984ULL, 0x000f240000000800ULL,
0x8000000009ff7812ULL, 0x014fc40007804837ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412097210ULL, 0x000fca0007f1e1ffULL,
0x0000000135347824ULL, 0x000fe200000e0e13ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x008fc80000011434ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0634ULL,
0x0000000200007819ULL, 0x000fc80000001209ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000103037810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000f097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000166037810ULL, 0x000fc80007ffe0ffULL, 0x0000007a0300720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x0000000266037810ULL, 0x000fe40007ffe0ffULL,
0x000001000e0e7810ULL, 0x000fe40007ffe0ffULL, 0x0000007a0300720cULL, 0x000fc60003f06070ULL,
0x000066007b037a24ULL, 0x000fd400078e020eULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x0000000e77007217ULL, 0x008fe20007800000ULL, 0x0000001079097824ULL, 0x000fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fc60000011611ULL, 0x0000000100007824ULL, 0x000fe200078e0a0eULL,
0x000000040d137810ULL, 0x000fe20007ffe0ffULL, 0x0000000109127824ULL, 0x000fc600078e020dULL,
0x0000000009007217ULL, 0x040fe20007800000ULL, 0x00000001120e7824ULL, 0x040fe400078e0211ULL,
0x00000008123b7824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a09ULL,
0x0000000109347824ULL, 0x000fe200078e0213ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL,
0x0000000112127824ULL, 0x000fe200078e0203ULL, 0x000000001300720cULL, 0x000fe20003f66070ULL,
0x0000000834367824ULL, 0x000fe200078e00ffULL, 0x0000000c0d137810ULL, 0x000fe20007ffe0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e026eULL, 0x000000080d0e7810ULL, 0x000fc40007ffe0ffULL,
0x000000000d00720cULL, 0x080fe20003f86070ULL, 0x00000001093a7824ULL, 0x000fe200078e0213ULL,
0x000000001300720cULL, 0x080fe20003f06070ULL, 0x00000001340d7824ULL, 0x000fe200078e0211ULL,
0x000000000e00720cULL, 0x000fe20003f46070ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff8360d7812ULL, 0x000fe200078ee20dULL, 0x0000000134347824ULL, 0x000fe200078e0203ULL,
0x0000006012127212ULL, 0x000fe200078efcffULL, 0x00000001090e7824ULL, 0x000fe400078e020eULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc60007fbe0ffULL,
0x000000010e367824ULL, 0x100fe200078e0203ULL, 0x0000006034347212ULL, 0x080fe200078efcffULL,
0x000000013a387824ULL, 0x000fe200078e0203ULL, 0x0000630013137a10ULL, 0x000fe20002ffe4ffULL,
0x000000010e007824ULL, 0x000fe200078e0211ULL, 0x0000620034347a10ULL, 0x000fe20007fbe0ffULL,
0x000000080e097824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000630035357a10ULL, 0x000fe20002ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123b7faeULL, 0x0005e2000e101c48ULL, 0xfffffff809037812ULL, 0x000fe200078ee200ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000006036367212ULL, 0x000fc600078efcffULL,
0x000000013a007824ULL, 0x000fe200078e0211ULL, 0x0000006038387212ULL, 0x000fe200078efcffULL,
0x000000083a097824ULL, 0x000fe200078e00ffULL, 0x0000620036367a10ULL, 0x000fe20007fbe0ffULL,
0x000000100d0d7824ULL, 0x100fe200078e026eULL, 0x0000620038387a10ULL, 0x000fe20007fde0ffULL,
0x0000001003037824ULL, 0x000fe200078e026eULL, 0xfffffff809097812ULL, 0x000fe400078ee200ULL,
0x0000630037377a10ULL, 0x000fe20002ffe4ffULL, 0x00000000340d7faeULL, 0x0005e2000d901c48ULL,
0x0000630039397a10ULL, 0x000fe200037fe4ffULL, 0x0000001009097824ULL, 0x000fc400078e026eULL,
0x0000000036037faeULL, 0x0005e8000d101c48ULL, 0x0000000038097faeULL, 0x0005e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001079007824ULL, 0x008fca00078e00ffULL,
0x0000000011007211ULL, 0x000fc800078fe8ffULL, 0x0000000400387810ULL, 0x040fe20007ffe0ffULL,
0x0000000100097824ULL, 0x140fe200078e0211ULL, 0x0000000800347810ULL, 0x040fe20007ffe0ffULL,
0x0000000800127824ULL, 0x000fe400078e00ffULL, 0x00000001380d7824ULL, 0x040fe400078e0211ULL,
0x0000000838367824ULL, 0x000fe200078e00ffULL, 0xfffffff812097812ULL, 0x000fe200078ee209ULL,
0x0000000100127824ULL, 0x040fe200078e0203ULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x00000001340e7824ULL, 0x000fe200078e0211ULL, 0xfffffff8360d7812ULL, 0x000fe200078ee20dULL,
0x00000008343b7824ULL, 0x000fc400078e00ffULL, 0x0000000138387824ULL, 0x000fe400078e0203ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fc600078ee20eULL,
0x0000000134347824ULL, 0x100fe200078e0203ULL, 0x0000006012127212ULL, 0x000fe200078efcffULL,
0x0000000100367824ULL, 0x000fe400078e0203ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fc60007f1e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006038387212ULL, 0x080fe400078efcffULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006034347212ULL, 0x080fe400078efcffULL,
0x0000620038387a10ULL, 0x000fe20007f5e0ffULL, 0x0000000100037824ULL, 0x000fe200078e0211ULL,
0x0000006036367212ULL, 0x000fe200078efcffULL, 0x0000000800007824ULL, 0x000fe200078e00ffULL,
0x0000620034347a10ULL, 0x000fe20007f1e0ffULL, 0x0000001009097824ULL, 0x100fe200078e026eULL,
0x0000620036367a10ULL, 0x000fe20007f7e0ffULL, 0x000000100d0d7824ULL, 0x100fe200078e026eULL,
0xfffffff800037812ULL, 0x000fe200078ee203ULL, 0x000000103b3b7824ULL, 0x100fe200078e026eULL,
0x0000630039397a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012097faeULL, 0x0005e2000b901c48ULL, 0x0000630035357a10ULL, 0x000fe200007fe4ffULL,
0x0000001003037824ULL, 0x000fe200078e026eULL, 0x0000630037377a10ULL, 0x000fe20001ffe4ffULL,
0x00000000380d7faeULL, 0x0005e8000b901c48ULL, 0x00000000343b7faeULL, 0x0005e8000b901c48ULL,
0x0000000036037faeULL, 0x0005e4000b901c48ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000001078037824ULL, 0x000fe200078e00ffULL, 0x0000000810007812ULL, 0x008fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x0000001003037812ULL, 0x000fca00078ee2ffULL,
0x000000207c037824ULL, 0x000fc800078e0203ULL, 0x0000000100007824ULL, 0x000fe200078e0203ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff127f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176680000367f8cULL, 0x000662000c80043fULL, 0x000000ffff037224ULL, 0x004fc600078e0013ULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x01766c0000097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x006fe40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x00000034120e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000135347824ULL, 0x000fe200000e0e13ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011434ULL, 0x0000000e09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e0634ULL, 0x0000000209097819ULL, 0x000fc8000000120eULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01766c0000097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001807c007811ULL, 0x008fc800078e38ffULL,
0x0000000075007210ULL, 0x000fca0007ffe060ULL, 0x01700000000e7984ULL, 0x000e680000000800ULL,
0x01720000000d7984ULL, 0x0004e20000000800ULL, 0x000000070e00720bULL, 0x002fe20003f1d000ULL,
0x0000c3e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x004fc800000e0100ULL,
0x0000ffff13357812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff007424ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fd200078e0007ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000037c097810ULL, 0x000fe40007ffe0ffULL,
0x000000070e00720bULL, 0x000fe40003f54000ULL, 0x000000020900720cULL, 0x000fe20003f05270ULL,
0x0000c3927f007947ULL, 0x000fd4000b800000ULL, 0x0000000000127806ULL, 0x000fc400010e0100ULL,
0x0000008002608824ULL, 0x000fe200078e0260ULL, 0x000000070e097209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991012137816ULL, 0x000fe200000000ffULL,
0x0000000175608824ULL, 0x000fca00078e0260ULL, 0x0174000960008388ULL, 0x0003e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000709077221ULL, 0x002fe20000010100ULL, 0x000000ff12ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b07077820ULL, 0x000fcc0000410000ULL,
0x0000000700077308ULL, 0x000e640000000800ULL, 0x0000000706067220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011611ULL,
0x0000c2d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1307137589ULL, 0x0002a400000e0000ULL,
0x0000001328287220ULL, 0x084fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x000fc40000410000ULL,
0x0000001330307220ULL, 0x080fe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x080fe40000410000ULL,
0x0000001314147220ULL, 0x080fe40000410000ULL, 0x0000001315157220ULL, 0x000fc40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x080fe40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0012ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000811137811ULL, 0x000fe200078ff0ffULL,
0x0000c1d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1307137589ULL, 0x00046400000e0000ULL,
0x000000132a2a7220ULL, 0x086fe40000410000ULL, 0x000000132b2b7220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x080fe40000410000ULL,
0x0000001332327220ULL, 0x080fe40000410000ULL, 0x0000001333337220ULL, 0x000fc40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x0000001316167220ULL, 0x080fe40000410000ULL, 0x0000001317177220ULL, 0x080fe40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x000fc40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff35ff7812ULL, 0x000fda0007806012ULL,
0x0000000e090e0221ULL, 0x000fe20000010100ULL, 0x00007610ff000816ULL, 0x000fc60000000000ULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e000c0308ULL, 0x000e640000000800ULL,
0x0000000c0d0d0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000060d067221ULL, 0x008fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0xfffffff010367812ULL, 0x000fe200078ec0ffULL, 0x00000004020d7824ULL, 0x000fc800078e00ffULL,
0x0176b40036077984ULL, 0x000e620000000800ULL, 0x000000040d0d7812ULL, 0x000fe400078ec0ffULL,
0x8000000007ff7812ULL, 0x002fe40007804841ULL, 0x000000020d077812ULL, 0x000fe200078efcffULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000103700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x00000034120e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000135347824ULL, 0x000fe200000e0e13ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011434ULL, 0x0000000e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e0634ULL, 0x000000020d0d7819ULL, 0x000fc8000000120eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000137377810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176b400360d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991000007816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f65270ULL, 0x0000016000003947ULL, 0x000fea0003800000ULL,
0x0000000cff00723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011611ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0000bd827f007947ULL, 0x000fea000b800000ULL,
0x00001f0d000b7589ULL, 0x0002a400000e0000ULL, 0x000000080d137810ULL, 0x000fe20007ffe0ffULL,
0x0000bdd27f007947ULL, 0x000fea000b800000ULL, 0x00001f13000a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100d137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200078e0000ULL, 0x0000cd3000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000c36000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180d137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e0000ULL,
0x0000cda000397802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000c2f000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000711137812ULL, 0x04cfe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000811407812ULL, 0x000fe400078ec0ffULL,
0x0000000813007812ULL, 0x002fe400078ef811ULL, 0x000000037c3d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000800007824ULL, 0x000fca00078e00ffULL, 0xfffffff800057812ULL, 0x000fca00078ee205ULL,
0x000000807c3c7824ULL, 0x000fca00078e0205ULL, 0x000128003c3c7811ULL, 0x000fc400078e20ffULL,
0x000000006b38783bULL, 0x000e620000004200ULL, 0x000010006e6e7810ULL, 0x000fe40007ffe0ffULL,
0x0000001340137212ULL, 0x000fe400078efcffULL, 0x0000000711407211ULL, 0x000fe200078fe0ffULL,
0x0000010038347824ULL, 0x002fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011439ULL,
0x0000003800557306ULL, 0x000fe20000009400ULL, 0x00000018ff007819ULL, 0x000fe40000011438ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff367819ULL, 0x000fe4000001143aULL,
0x00000018ff377819ULL, 0x000fe2000001143bULL, 0x0000003500127306ULL, 0x000ff00000209400ULL,
0x00000035003f7306ULL, 0x000ff00000205400ULL, 0x00000035006c7306ULL, 0x0003f0000020d400ULL,
0x0000003400617306ULL, 0x000fe20000209400ULL, 0x0000010039357824ULL, 0x002fca00078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011435ULL, 0x0000003400627306ULL, 0x000e700000205400ULL,
0x0000003400737306ULL, 0x0004f0000020d400ULL, 0x0000000000467306ULL, 0x000fe20000209400ULL,
0x0000001050347824ULL, 0x004fe200078e026eULL, 0x000000626100720bULL, 0x002fcc0003f5d000ULL,
0x0000000000477306ULL, 0x000e6e0000205400ULL, 0x0000000173732812ULL, 0x008fe200078efcffULL,
0x00000000006d7306ULL, 0x000eb0000020d400ULL, 0x0000003800657306ULL, 0x000ee20000005400ULL,
0x000000474600720bULL, 0x002fce0003f5d000ULL, 0x00000036000d7306ULL, 0x000fec0000209400ULL,
0x000000016d6d2812ULL, 0x004fe400078efcffULL, 0x00000036000e7306ULL, 0x000fe20000205400ULL,
0x000000655500720bULL, 0x008fe40003fbd000ULL, 0x0000003f1200720bULL, 0x000fca0003f5d000ULL,
0x00000036005f7306ULL, 0x000ff0000020d400ULL, 0x0000003700057306ULL, 0x000fe20000209400ULL,
0x000000016c6c2812ULL, 0x000fce00078efcffULL, 0x0000003700007306ULL, 0x000e700000205400ULL,
0x0000003700637306ULL, 0x0005f0000020d400ULL, 0x00000038006f7306ULL, 0x000722000000d400ULL,
0x000000003434783bULL, 0x004ea20000004200ULL, 0x000000000500720bULL, 0x002fcc0003f5d000ULL,
0x0000003900607306ULL, 0x000fe20000009400ULL, 0x0001000038387824ULL, 0x008fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000039005c7306ULL, 0x000e620000005400ULL,
0x000000016f6f5812ULL, 0x010fe400078efcffULL, 0x0000000163632812ULL, 0x000fca00078efcffULL,
0x0000003800447306ULL, 0x000ff00000209400ULL, 0x0000003800457306ULL, 0x000ee20000205400ULL,
0x0000005c6000720bULL, 0x002fce0003fdd000ULL, 0x0000003800717306ULL, 0x000322000020d400ULL,
0x00000018ff677819ULL, 0x004fe40000011435ULL, 0x00000018ff657819ULL, 0x000fe40000011436ULL,
0x00000018ff5c7819ULL, 0x000fe40000011437ULL, 0x000000454400720bULL, 0x008fe20003fbd000ULL,
0x0000000113447824ULL, 0x040fe200078e0240ULL, 0x00000041003e7306ULL, 0x000fe20000209400ULL,
0x0000000813457824ULL, 0x000fc400078e00ffULL, 0x000001003a387824ULL, 0x002fe400078e00ffULL,
0x0000000108407824ULL, 0x000fe200078e0240ULL, 0xfffffff845457812ULL, 0x000fe200078ee244ULL,
0x0000010034447824ULL, 0x000fe200078e00ffULL, 0x00000041005b7306ULL, 0x000e620000205400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000001045457824ULL, 0x000fe200078e0274ULL,
0x00000018ff607819ULL, 0x000fe40000011444ULL, 0x0000000171715812ULL, 0x010fc400078efcffULL,
0x0000003900547306ULL, 0x0004e2000000d400ULL, 0x000000004544783bULL, 0x000f2e0000004200ULL,
0x0000004100707306ULL, 0x0006e2000020d400ULL, 0x0001000039397824ULL, 0x004fe200078e00ffULL,
0x0000005b3e00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003a00597306ULL, 0x000fe20000009400ULL, 0x000001003b417824ULL, 0x008fe200078e00ffULL,
0x0000000154546812ULL, 0x000fc800078efcffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000039004d7306ULL, 0x000fe20000209400ULL, 0x0000000170705812ULL, 0x000fce00078efcffULL,
0x00000039005e7306ULL, 0x000e700000205400ULL, 0x0000003a005a7306ULL, 0x000ea20000005400ULL,
0x00000018ff687819ULL, 0x010fe40000011445ULL, 0x00000018ff747819ULL, 0x000fca0000011446ULL,
0x0000003800487306ULL, 0x000fe20000209400ULL, 0x0000005e4d00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff4d7819ULL, 0x000fca0000011444ULL, 0x00000038004a7306ULL, 0x000e620000205400ULL,
0x0000005a5900720bULL, 0x004fce0003f9d000ULL, 0x0000003a00527306ULL, 0x0004f0000000d400ULL,
0x0000003900727306ULL, 0x000f22000020d400ULL, 0x000100003a3a7824ULL, 0x004fe200078e00ffULL,
0x0000004a4800720bULL, 0x002fc80003fdd000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038006b7306ULL, 0x0002a2000020d400ULL, 0x0000000152524812ULL, 0x008fce00078efcffULL,
0x0000004100497306ULL, 0x000fe20000209400ULL, 0x0000000172725812ULL, 0x010fe400078efcffULL,
0x0000000e0d00720bULL, 0x000fe20003fbd000ULL, 0x00000100440d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x002fe20000011434ULL, 0x00000100450e7824ULL, 0x000fe400078e00ffULL,
0x00000041004b7306ULL, 0x000e620000205400ULL, 0x000000016b6b6812ULL, 0x004fce00078efcffULL,
0x0000003a004c7306ULL, 0x000fe20000209400ULL, 0x000000015f5f5812ULL, 0x000fce00078efcffULL,
0x0000003a004e7306ULL, 0x000ea20000205400ULL, 0x0000004b4900720bULL, 0x002fce0003fdd000ULL,
0x0000003b004f7306ULL, 0x000ff00000009400ULL, 0x0000003b00587306ULL, 0x000e620000005400ULL,
0x0000004e4c00720bULL, 0x004fce0003f9d000ULL, 0x0000003b00537306ULL, 0x0004f0000000d400ULL,
0x0000006700577306ULL, 0x000fe20000209400ULL, 0x000100003b3b7824ULL, 0x004fe200078e00ffULL,
0x000000584f00720bULL, 0x002fe20003f1d000ULL, 0x0001000034587824ULL, 0x000fc600078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000006700437306ULL, 0x000fee0000205400ULL,
0x0000000153530812ULL, 0x008fe200078efcffULL, 0x0000006700557306ULL, 0x0003f0000020d400ULL,
0x00000041006a7306ULL, 0x000ea2000020d400ULL, 0x00000018ff677819ULL, 0x002fce000001140dULL,
0x0000003b00517306ULL, 0x000ff00000209400ULL, 0x0000003b005d7306ULL, 0x000e620000205400ULL,
0x000000016a6a6812ULL, 0x004fce00078efcffULL, 0x00000067004b7306ULL, 0x000ff00000209400ULL,
0x00000067004c7306ULL, 0x000ea20000205400ULL, 0x0000005d5100720bULL, 0x002fe40003fdd000ULL,
0x00000018ff5d7819ULL, 0x000fca000001140eULL, 0x0000003400077306ULL, 0x000ff00000009400ULL,
0x0000003400137306ULL, 0x000e620000005400ULL, 0x0000004c4b00720bULL, 0x004fe20003fbd000ULL,
0x00010000444b7824ULL, 0x000fcc00078e00ffULL, 0x0000003a00697306ULL, 0x000eb0000020d400ULL,
0x0000003b00647306ULL, 0x000ee2000020d400ULL, 0x000000130700720bULL, 0x002fce0003f1d000ULL,
0x00000065003a7306ULL, 0x000fe20000209400ULL, 0x0000000169694812ULL, 0x004fce00078efcffULL,
0x00000065003b7306ULL, 0x000fe20000205400ULL, 0x0000000164646812ULL, 0x008fce00078efcffULL,
0x0000006500507306ULL, 0x0003f0000020d400ULL, 0x0000004500517306ULL, 0x000fe20000009400ULL,
0x00000018ff657819ULL, 0x002fce0000011458ULL, 0x00000045004c7306ULL, 0x000e700000005400ULL,
0x0000006500597306ULL, 0x000ff00000209400ULL, 0x0000006500587306ULL, 0x000fe20000205400ULL,
0x0000004c5100720bULL, 0x002fe20003f5d000ULL, 0x0001000045517824ULL, 0x000fcc00078e00ffULL,
0x00000065005b7306ULL, 0x000ff0000020d400ULL, 0x0000004d005e7306ULL, 0x000ff00000209400ULL,
0x0000004d00657306ULL, 0x000e700000205400ULL, 0x0000006800487306ULL, 0x000ff00000209400ULL,
0x00000068004a7306ULL, 0x000fe20000205400ULL, 0x000000655e00720bULL, 0x002fc40003f9d000ULL,
0x00000018ff657819ULL, 0x000fca0000011451ULL, 0x0000006800057306ULL, 0x000ff0000020d400ULL,
0x0000004400077306ULL, 0x000ff00000009400ULL, 0x0000004400687306ULL, 0x000e700000005400ULL,
0x00000067000d7306ULL, 0x000eb0000020d400ULL, 0x0000005d004e7306ULL, 0x000fe20000209400ULL,
0x000000680700720bULL, 0x002fce0003fdd000ULL, 0x0000005d00497306ULL, 0x000e620000205400ULL,
0x000000010d0d5812ULL, 0x004fce00078efcffULL, 0x0000005d000e7306ULL, 0x0005f0000020d400ULL,
0x0000004500137306ULL, 0x000722000000d400ULL, 0x00000018ff5d7819ULL, 0x004fe4000001144bULL,
0x000000494e00720bULL, 0x002fca0003fbd000ULL, 0x0000006500517306ULL, 0x000fe20000209400ULL,
0x0000010047457824ULL, 0x008fce00078e00ffULL, 0x0000006500687306ULL, 0x000e620000205400ULL,
0x0000000113132812ULL, 0x010fe400078efcffULL, 0x000000010e0e5812ULL, 0x000fca00078efcffULL,
0x0000005d004b7306ULL, 0x000ff00000209400ULL, 0x0000005d005e7306ULL, 0x000ea20000205400ULL,
0x000000685100720bULL, 0x002fe40003f5d000ULL, 0x00000018ff687819ULL, 0x000fca0000011445ULL,
0x0000004400077306ULL, 0x0002f0000000d400ULL, 0x0000005d004c7306ULL, 0x000f22000020d400ULL,
0x0000010046447824ULL, 0x002fe200078e00ffULL, 0x0000005e4b00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff677819ULL, 0x000fe40000011444ULL, 0x0000004d00127306ULL, 0x000e62000020d400ULL,
0x0000000107076812ULL, 0x008fe400078efcffULL, 0x0000004a4800720bULL, 0x000fca0003fdd000ULL,
0x0000006700447306ULL, 0x000fe20000209400ULL, 0x000000014c4c5812ULL, 0x010fce00078efcffULL,
0x00000067005d7306ULL, 0x000ea20000205400ULL, 0x0000000112124812ULL, 0x002fe400078efcffULL,
0x0000000105056812ULL, 0x000fe400078efcffULL, 0x0000004c1212723eULL, 0x000fc600000010ffULL,
0x00000046004e7306ULL, 0x000ff00000009400ULL, 0x0000004600517306ULL, 0x000e620000005400ULL,
0x0000005d4400720bULL, 0x004fce0003fbd000ULL, 0x0000006500497306ULL, 0x0004f0000020d400ULL,
0x0000003800417306ULL, 0x000fe20000209400ULL, 0x000000514e00720bULL, 0x002fe20003f9d000ULL,
0x00010000464e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x004fe2000001144eULL,
0x0000003800427306ULL, 0x000e620000205400ULL, 0x0000000149492812ULL, 0x008fce00078efcffULL,
0x00000067004a7306ULL, 0x000eb0000020d400ULL, 0x0000006800457306ULL, 0x000fe20000209400ULL,
0x000000424100720bULL, 0x002fe20003f5d000ULL, 0x0001000047417824ULL, 0x000fcc00078e00ffULL,
0x00000068005e7306ULL, 0x000e620000205400ULL, 0x000000014a4a5812ULL, 0x004fce00078efcffULL,
0x0000003400617306ULL, 0x0004f0000000d400ULL, 0x00000046004b7306ULL, 0x000f22000000d400ULL,
0x0000010035347824ULL, 0x004fe200078e00ffULL, 0x0000005e4500720bULL, 0x002fc40003fbd000ULL,
0x00000018ff457819ULL, 0x000fe40000011441ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000004700447306ULL, 0x000fe20000009400ULL, 0x0000000161610812ULL, 0x008fe400078efcffULL,
0x0000003b3a00720bULL, 0x000fca0003f1d000ULL, 0x00000047005d7306ULL, 0x000e620000005400ULL,
0x000000014b4b4812ULL, 0x010fc800078efcffULL, 0x0000004b4a4a723eULL, 0x000fc600000010ffULL,
0x0000003800567306ULL, 0x000ea2000020d400ULL, 0x0000000150500812ULL, 0x000fce00078efcffULL,
0x0000006800487306ULL, 0x000ee2000020d400ULL, 0x0000005d4400720bULL, 0x002fce0003f9d000ULL,
0x0000005c00387306ULL, 0x000fe20000209400ULL, 0x0000000156562812ULL, 0x004fce00078efcffULL,
0x0000005c00397306ULL, 0x000fe20000205400ULL, 0x0000000148485812ULL, 0x008fce00078efcffULL,
0x0000005c004f7306ULL, 0x000ff0000020d400ULL, 0x0000006500517306ULL, 0x000ff00000209400ULL,
0x0000006500427306ULL, 0x000e700000205400ULL, 0x00000060005a7306ULL, 0x000ff00000209400ULL,
0x00000060005c7306ULL, 0x000fe20000205400ULL, 0x000000425100720bULL, 0x002fce0003fbd000ULL,
0x0000006000627306ULL, 0x000ff0000020d400ULL, 0x00000034003e7306ULL, 0x000ff00000209400ULL,
0x00000034003f7306ULL, 0x000e700000205400ULL, 0x0000003400607306ULL, 0x000eb0000020d400ULL,
0x0000007400347306ULL, 0x000fe20000209400ULL, 0x0000003f3e00720bULL, 0x002fce0003f5d000ULL,
0x00000074004d7306ULL, 0x000e6c0000205400ULL, 0x0000000160602812ULL, 0x004fe400078efcffULL,
0x00000065004e7306ULL, 0x000eb0000020d400ULL, 0x0000004500447306ULL, 0x000fe20000209400ULL,
0x0000004d3400720bULL, 0x002fce0003fdd000ULL, 0x00000045005d7306ULL, 0x000e620000205400ULL,
0x000000014e4e5812ULL, 0x004fce00078efcffULL, 0x0000007400007306ULL, 0x000eb0000020d400ULL,
0x00000047004d7306ULL, 0x000722000000d400ULL, 0x0000005d4400720bULL, 0x002fe20003fbd000ULL,
0x00000008085d7824ULL, 0x000fc400078e00ffULL, 0x0001000036087824ULL, 0x000fc800078e00ffULL,
0x0000003500347306ULL, 0x000fe20000009400ULL, 0x0000000100006812ULL, 0x004fe400078efcffULL,
0x0000005c5a00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000018ff477819ULL, 0x008fe20000011447ULL, 0x0000003500677306ULL, 0x000e620000005400ULL,
0x000000014d4d4812ULL, 0x010fe400078efcffULL, 0x0000004e004e723eULL, 0x000fc400000010ffULL,
0x0000004d484b723eULL, 0x000fc600000010ffULL, 0x0000004500517306ULL, 0x000ea2000020d400ULL,
0x0000000162626812ULL, 0x000fe400078efcffULL, 0x000000585900720bULL, 0x000fe40003fdd000ULL,
0x000000673400720bULL, 0x002fe20003f9d000ULL, 0x0001000035347824ULL, 0x000fe400078e00ffULL,
0x0000003500657306ULL, 0x000e66000000d400ULL, 0x00000018ff467819ULL, 0x000fe20000011434ULL,
0x0000010036347824ULL, 0x000fe200078e00ffULL, 0x0000000151515812ULL, 0x004fc400078efcffULL,
0x000000435700720bULL, 0x000fe20003fbd000ULL, 0x0000010037437824ULL, 0x000fe200078e00ffULL,
0x0000004600417306ULL, 0x000fe20000209400ULL, 0x000000015b5b6812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x000fe20003fdd000ULL, 0x000008003d387824ULL, 0x000fe200078e0204ULL,
0x00000018ff577819ULL, 0x000fe20000011443ULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x0000000165654812ULL, 0x002fe200078efcffULL, 0x0000004600427306ULL, 0x000e620000205400ULL,
0x00000018ff5c7819ULL, 0x000fe20000011434ULL, 0x011000003838783bULL, 0x000ee20000000200ULL,
0x0000000155555812ULL, 0x000fca00078efcffULL, 0x00000046005e7306ULL, 0x000f22000020d400ULL,
0x000000014f4f6812ULL, 0x000fce00078efcffULL, 0x0000003600437306ULL, 0x000fe20000009400ULL,
0x000000424100720bULL, 0x002fce0003f5d000ULL, 0x0000003600467306ULL, 0x000e6c0000005400ULL,
0x000000015e5e2812ULL, 0x010fe400078efcffULL, 0x0000005700447306ULL, 0x000fe20000209400ULL,
0x0000000b3c3cb231ULL, 0x004fce00003400ffULL, 0x0000005700457306ULL, 0x000ea20000205400ULL,
0x000000464300720bULL, 0x002fe20003f9d000ULL, 0x0000000b3e3eb231ULL, 0x080fe400003400ffULL,
0x0000000a3d3db231ULL, 0x080fe400003400ffULL, 0x0000000a3f3fb231ULL, 0x000fe400003400ffULL,
0x0000005700597306ULL, 0x000322000020d400ULL, 0x0000000b3838b231ULL, 0x088fe400003400ffULL,
0x0000000b3a3ab231ULL, 0x000fc400003400ffULL, 0x0000000a3939b231ULL, 0x080fe200003400ffULL,
0x0000004a3c1c723cULL, 0x000fe2000004181cULL, 0x0000000a3b3bb231ULL, 0x000fe200003400ffULL,
0x0000005c00347306ULL, 0x000fe20000209400ULL, 0xfffffff85d577812ULL, 0x002fe400078ee240ULL,
0x000000454400720bULL, 0x004fe40003fbd000ULL, 0x000000526b44723eULL, 0x000fe200000010ffULL,
0x0000001057407824ULL, 0x000fe400078e026eULL, 0x0000005c00357306ULL, 0x000e680000205400ULL,
0x000000004040783bULL, 0x000ea80000004200ULL, 0x0000003700047306ULL, 0x000fe20000009400ULL,
0x0000000159595812ULL, 0x010fce00078efcffULL, 0x0000003700577306ULL, 0x000ee20000005400ULL,
0x000000353400720bULL, 0x002fe40003f5d000ULL, 0x0000006f7334723eULL, 0x000fe400000010ffULL,
0x000000547035723eULL, 0x000fc600000010ffULL, 0x00000037005d7306ULL, 0x000328000000d400ULL,
0x000000343c28723cULL, 0x000b680000041828ULL, 0x0000005c005a7306ULL, 0x000f22000020d400ULL,
0x0001000037377824ULL, 0x002fe200078e00ffULL, 0x000000570400720bULL, 0x008fc40003f7d000ULL,
0x000000716d34723eULL, 0x020fe400000010ffULL, 0x00000018ff467819ULL, 0x000fe40000011437ULL,
0x00000036005c7306ULL, 0x000e62000000d400ULL, 0x000000726c35723eULL, 0x000fe400000010ffULL,
0x00000018ff457819ULL, 0x004fe40000011442ULL, 0x00000018ff547819ULL, 0x000fc60000011440ULL,
0x0000004500747306ULL, 0x000fe20000209400ULL, 0x000000343c2c723cULL, 0x000be2000004182cULL,
0x000000015d5d3812ULL, 0x010fe400078efcffULL, 0x000000015a5a2812ULL, 0x000fe400078efcffULL,
0x0000005d595d723eULL, 0x000fe400000010ffULL, 0x00000045006d7306ULL, 0x000fe20000205400ULL,
0x000000015c5c4812ULL, 0x002fc800078efcffULL, 0x0000005c5a5c723eULL, 0x000fe200000010ffULL,
0x00000100435a7824ULL, 0x000fe400078e00ffULL, 0x0000004500527306ULL, 0x0003e6000020d400ULL,
0x00000018ff5a7819ULL, 0x000fca000001145aULL, 0x0000004600377306ULL, 0x000fe20000209400ULL,
0x000000536a45723eULL, 0x002fe400000010ffULL, 0x00000018ff537819ULL, 0x000fca0000011443ULL,
0x0000004600367306ULL, 0x000e700000205400ULL, 0x0000004600577306ULL, 0x0004f0000020d400ULL,
0x0000000800767306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x004fc40000011441ULL,
0x000000363700720bULL, 0x002fca0003f9d000ULL, 0x0000000800757306ULL, 0x000e700000205400ULL,
0x0000000800587306ULL, 0x000ea2000020d400ULL, 0x0000000157574812ULL, 0x008fce00078efcffULL,
0x0000004700687306ULL, 0x000fe20000209400ULL, 0x000000757600720bULL, 0x002fce0003f5d000ULL,
0x0000004700677306ULL, 0x000e6c0000205400ULL, 0x0000000158582812ULL, 0x004fe400078efcffULL,
0x0000004700047306ULL, 0x000eb0000020d400ULL, 0x00000046006f7306ULL, 0x000fe20000209400ULL,
0x000000676800720bULL, 0x002fce0003f5d000ULL, 0x00000046006e7306ULL, 0x000fec0000205400ULL,
0x0000000104042812ULL, 0x004fe400078efcffULL, 0x0000004600087306ULL, 0x0003f0000020d400ULL,
0x0000004100347306ULL, 0x020fe20000009400ULL, 0x000000443c44723cULL, 0x002bee0000041830ULL,
0x0000010040307824ULL, 0x020fe200078e00ffULL, 0x000000646331723eULL, 0x000fe200000010ffULL,
0x0000004000327306ULL, 0x000fe60000009400ULL, 0x00000018ff357819ULL, 0x000fc40000011430ULL,
0x000000695f30723eULL, 0x000fc600000010ffULL, 0x00000035006a7306ULL, 0x000fe80000209400ULL,
0x000000303c24723cULL, 0x000b680000041824ULL, 0x0000004100317306ULL, 0x020e660000005400ULL,
0x0000010041307824ULL, 0x000fca00078e00ffULL, 0x0000003500697306ULL, 0x000eb00000205400ULL,
0x00000035005f7306ULL, 0x0007e2000020d400ULL, 0x000000313400720bULL, 0x002fe40003f7d000ULL,
0x000000616234723eULL, 0x000fca00000010ffULL, 0x0000004000337306ULL, 0x000e620000005400ULL,
0x00000018ff357819ULL, 0x008fe20000011430ULL, 0x0001000040307824ULL, 0x000fe200078e00ffULL,
0x000000696a00720bULL, 0x004fc80003f1d000ULL, 0x00000018ff317819ULL, 0x000fe20000011430ULL,
0x00000035006b7306ULL, 0x000fe20000209400ULL, 0x0001000041307824ULL, 0x000fce00078e00ffULL,
0x00000035006c7306ULL, 0x000ea20000205400ULL, 0x000000333200720bULL, 0x002fe40003fbd000ULL,
0x000000015f5f0812ULL, 0x000fca00078efcffULL, 0x0000003500637306ULL, 0x0003f0000020d400ULL,
0x0000004000647306ULL, 0x000ee2000000d400ULL, 0x000000656035723eULL, 0x002fe400000010ffULL,
0x00000018ff607819ULL, 0x000fc40000011430ULL, 0x0000005b5630723eULL, 0x000fe400000010ffULL,
0x0000006c6b00720bULL, 0x004fe20003f5d000ULL, 0x000000343834723cULL, 0x000be20000041828ULL,
0x0000003100767306ULL, 0x000fec0000209400ULL, 0x0000010042287824ULL, 0x020fe200078e00ffULL,
0x0000000164645812ULL, 0x008fe200078efcffULL, 0x0000004200297306ULL, 0x000fe60000005400ULL,
0x00000018ff2b7819ULL, 0x000fc40000011428ULL, 0x0000000163632812ULL, 0x000fc600078efcffULL,
0x0000004200287306ULL, 0x000e700000009400ULL, 0x0000003100757306ULL, 0x000eb00000205400ULL,
0x0000002b00617306ULL, 0x000fe20000209400ULL, 0x000000292800720bULL, 0x002fc40003f9d000ULL,
0x000000585028723eULL, 0x000fe400000010ffULL, 0x000000574f29723eULL, 0x000fe200000010ffULL,
0x00010000434f7824ULL, 0x000fe400078e00ffULL, 0x0000002b005b7306ULL, 0x000fe20000205400ULL,
0x000000757600720bULL, 0x004fce0003fbd000ULL, 0x0000002b00567306ULL, 0x000ff0000020d400ULL,
0x00000043002a7306ULL, 0x000ff00000009400ULL, 0x00000043002b7306ULL, 0x000e700000005400ULL,
0x0000004100407306ULL, 0x000eb0000000d400ULL, 0x0000003100417306ULL, 0x000722000020d400ULL,
0x0000002b2a00720bULL, 0x002fc40003fdd000ULL, 0x000000283828723cULL, 0x000bea0000041824ULL,
0x0000005400737306ULL, 0x000fe20000209400ULL, 0x0000005e5531723eULL, 0x008fe400000010ffULL,
0x000000070d24723eULL, 0x020fe400000010ffULL, 0x00000018ff0d7819ULL, 0x000fc4000001144fULL,
0x000000130e25723eULL, 0x000fe200000010ffULL, 0x0000005400707306ULL, 0x000e620000205400ULL,
0x000000303830723cULL, 0x040fe2000004182cULL, 0x000000490513723eULL, 0x000fe400000010ffULL,
0x0000000140403812ULL, 0x004fe400078efcffULL, 0x0000000141415812ULL, 0x010fe400078efcffULL,
0x0000006000657306ULL, 0x000fe20000209400ULL, 0x0000005c382c723cULL, 0x000be20000041844ULL,
0x0000006e6f00720bULL, 0x000fc40003f7d000ULL, 0x0000005b6100720bULL, 0x000fe40003fbd000ULL,
0x00000051044f723eULL, 0x000fe400000010ffULL, 0x0000006000627306ULL, 0x000ea20000205400ULL,
0x0001000042477824ULL, 0x020fe200078e00ffULL, 0x000000707300720bULL, 0x002fe20003f1d000ULL,
0x000000243c14723cULL, 0x000b660000041814ULL, 0x00000018ff477819ULL, 0x000fc40000011447ULL,
0x0000005400547306ULL, 0x000e62000020d400ULL, 0x0000000108083812ULL, 0x000fe400078efcffULL,
0x000000123c18723cULL, 0x040f620000041818ULL, 0x0000000156565812ULL, 0x000fe400078efcffULL,
0x000000645f24723eULL, 0x020fe400000010ffULL, 0x0000006000607306ULL, 0x000ee2000020d400ULL,
0x000000626500720bULL, 0x004fe40003f5d000ULL, 0x0000004e3c3c723cULL, 0x000b620000041820ULL,
0x000000406325723eULL, 0x000fc800000010ffULL, 0x0000004200457306ULL, 0x000ea2000000d400ULL,
0x0000000154540812ULL, 0x002fe400078efcffULL, 0x0000006d7400720bULL, 0x000fe20003f1d000ULL,
0x000000243824723cULL, 0x000b640000041814ULL, 0x000000415420723eULL, 0x020fe400000010ffULL,
0x0000005300727306ULL, 0x000fe20000209400ULL, 0x0000000160602812ULL, 0x008fc800078efcffULL,
0x000000600821723eULL, 0x000fc600000010ffULL, 0x0000005300717306ULL, 0x000e620000205400ULL,
0x0000000145454812ULL, 0x004fe400078efcffULL, 0x0000000152520812ULL, 0x000fe200078efcffULL,
0x000000203820723cULL, 0x000b620000041818ULL, 0x000000455656723eULL, 0x000fc600000010ffULL,
0x0000005a00557306ULL, 0x000ff00000209400ULL, 0x0000005a00597306ULL, 0x000ea20000205400ULL,
0x000000717200720bULL, 0x002fce0003f5d000ULL, 0x0000004700467306ULL, 0x000ff00000209400ULL,
0x0000004700077306ULL, 0x000e620000205400ULL, 0x000000595500720bULL, 0x004fce0003f7d000ULL,
0x0000000d00057306ULL, 0x000ff00000209400ULL, 0x0000000d000e7306ULL, 0x000ea20000205400ULL,
0x000000074600720bULL, 0x002fce0003fbd000ULL, 0x0000005300537306ULL, 0x000e70000020d400ULL,
0x0000005a00447306ULL, 0x000ee2000020d400ULL, 0x0000000e0500720bULL, 0x004fce0003f9d000ULL,
0x0000004300427306ULL, 0x000ea2000000d400ULL, 0x0000000153532812ULL, 0x002fce00078efcffULL,
0x0000004700477306ULL, 0x000e62000020d400ULL, 0x0000000144443812ULL, 0x008fce00078efcffULL,
0x0000000d00007306ULL, 0x000ee2000020d400ULL, 0x0000000142426812ULL, 0x004fc800078efcffULL,
0x000000424457723eULL, 0x000fe400000010ffULL, 0x0000000147475812ULL, 0x002fc800078efcffULL,
0x000000475252723eULL, 0x000fe200000010ffULL, 0x00000056381c723cULL, 0x000b62000004181cULL,
0x0000000100004812ULL, 0x008fc800078efcffULL, 0x000000005353723eULL, 0x000fce00000010ffULL,
0x000000523814723cULL, 0x000b62000004183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x000000000f047f8cULL, 0x0002a2000c80043fULL, 0x0000000166667810ULL, 0x000fe40007ffe0ffULL,
0x000176a07c077811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000007ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x004fe200078e0005ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff285000007947ULL, 0x000fea000383ffffULL,
0x000000ff7a00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000ed9000047802ULL, 0x002fc40000000f00ULL,
0x0000a14000007944ULL, 0x02cfea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000600037308ULL, 0x000f240000001000ULL, 0xbf80000003007423ULL, 0x010fc80000000006ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006b00ff037624ULL, 0x000fe400078e00ffULL,
0x00006a00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x002e680000000000ULL, 0x0000000000077919ULL, 0x008ee20000000000ULL,
0x00000002ff067819ULL, 0x006fe40000011604ULL, 0x0000000807047811ULL, 0x008fe200078ff0ffULL,
0x0000000003057220ULL, 0x010fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003400347220ULL, 0x042fe40000410000ULL,
0x0000003500357220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x000fc40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000002800287220ULL, 0x040fe40000410000ULL,
0x0000002900297220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x040fe40000410000ULL,
0x0000002500257220ULL, 0x000fc40000410000ULL, 0x0000002000207220ULL, 0x060fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x040fe40000410000ULL,
0x0000001d001d7220ULL, 0x040fe40000410000ULL, 0x0000001400147220ULL, 0x040fe40000410000ULL,
0x0000001500157220ULL, 0x000fc40000410000ULL, 0x0000003604367220ULL, 0x044fe40000410000ULL,
0x0000003704377220ULL, 0x040fe40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x000fc40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x040fe40000410000ULL, 0x0000002604267220ULL, 0x040fe40000410000ULL,
0x0000002704277220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fc40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000001604167220ULL, 0x040fe40000410000ULL,
0x0000001704177220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000f220000000000ULL,
0x000000202120723eULL, 0x020fe200000010ffULL, 0x00000020780b7824ULL, 0x000fe200078e00ffULL,
0x0000001c1d1c723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002e2f2e723eULL, 0x000fc400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222313723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x00000016170f723eULL, 0x002fe400000010ffULL,
0x00000002ff057819ULL, 0x010fc40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x008fe200078ff0ffULL, 0x0000000805097824ULL, 0x044fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000404067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000100079037824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x0000080078057824ULL, 0x000fe200078e0203ULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x000000303104723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fc400078e0207ULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000541002107816ULL, 0x040fe20000000004ULL,
0x0000000107097824ULL, 0x040fe200078e020eULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x0000002c2d02723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000282904723eULL, 0x000fe200000010ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000242505723eULL, 0x000fc400000010ffULL, 0x0000763202077816ULL, 0x140fe40000000004ULL,
0x00000014150e723eULL, 0x000fe400000010ffULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x000000363702723eULL, 0x000fe400000010ffULL, 0x000000323304723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x000054102e107816ULL, 0x000fc4000000002aULL,
0x000076322e117816ULL, 0x000fe4000000002aULL, 0x0000541005067816ULL, 0x142fe40000000020ULL,
0x0000763205077816ULL, 0x000fe40000000020ULL, 0x000000ff00057306ULL, 0x000fe60000209400ULL,
0x000000060a007388ULL, 0x0003e40000000a00ULL, 0x000054101c067816ULL, 0x002fc4000000000eULL,
0x000076321c077816ULL, 0x000fe4000000000eULL, 0x000054101e0e7816ULL, 0x140fe4000000000fULL,
0x000076321e0f7816ULL, 0x000fe2000000000fULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x0000541002067816ULL, 0x142fe40000000004ULL, 0x0000763202077816ULL, 0x000fe20000000004ULL,
0x000000010b027824ULL, 0x000fe200078e0200ULL, 0x000000ff00047306ULL, 0x000e660000205400ULL,
0x0000000609007388ULL, 0x0005e80000000a00ULL, 0x0004001008007388ULL, 0x0007e20000000a00ULL,
0x0000763226097816ULL, 0x004fe20000000013ULL, 0x0000001002067824ULL, 0x000fe200078e0203ULL,
0x000000040500720bULL, 0x002fe20003f1d000ULL, 0x000000ff00027306ULL, 0x000e62000020d400ULL,
0x0000541026087816ULL, 0x008fca0000000013ULL, 0x000400080a007388ULL, 0x000fe80000000a00ULL,
0x0004000e0c007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000006107984ULL, 0x000ea20000000c00ULL, 0x0000000102020812ULL, 0x002fc400078efcffULL,
0x000000ff7800720cULL, 0x000fe20003f05270ULL, 0x0004000006087984ULL, 0x000e620000000c00ULL,
0x000000020204723eULL, 0x000fc600000010ffULL, 0x0008000006147984ULL, 0x000ee80000000c00ULL,
0x000c000006187984ULL, 0x000f220000000c00ULL, 0x3f803f8004137831ULL, 0x044fe40000200013ULL,
0x3f803f8004127831ULL, 0x040fe40000200012ULL, 0x3f803f8004117831ULL, 0x040fe40000200011ULL,
0x3f803f8004107831ULL, 0x000fc40000200010ULL, 0x3f803f80040b7831ULL, 0x042fe4000020000bULL,
0x3f803f80040a7831ULL, 0x040fe4000020000aULL, 0x3f803f8004097831ULL, 0x040fe40000200009ULL,
0x3f803f8004087831ULL, 0x000fe40000200008ULL, 0x3f803f8013137831ULL, 0x008fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fc40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fe40000200014ULL, 0x3f803f800b0b7831ULL, 0x010fe4000020001bULL,
0x3f803f800a0a7831ULL, 0x000fe2000020001aULL, 0x0000001006007388ULL, 0x000fe20000000c00ULL,
0x3f803f8009097831ULL, 0x000fe40000200019ULL, 0x3f803f8008087831ULL, 0x000fca0000200018ULL,
0x0004000806007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000011f7983ULL, 0x000ea20000100800ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x0000001f0700720cULL, 0x004fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000400011d7983ULL, 0x000ea20000100800ULL,
0x0000000107027824ULL, 0x100fe200078e0200ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00005900ff1c7624ULL, 0x000fe200078e00ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000702057812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x00005a007d7d7a19ULL, 0x000fe400000006ffULL,
0x0ffffff805027812ULL, 0x000fe200078ef800ULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00005a001c1c7a19ULL, 0x000fc400000006ffULL, 0x00000007000e7812ULL, 0x000fe200078ec0ffULL,
0x0000001002047824ULL, 0x000fca00078e0203ULL, 0x0000000004087984ULL, 0x0007220000000c00ULL,
0x00000006040472a4ULL, 0x002fe2000f8e023fULL, 0x000000101d027824ULL, 0x004fe400078e0207ULL,
0x0000000879077824ULL, 0x000fc600078e020eULL, 0x0000000502067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe20000011602ULL, 0x000000041c027c24ULL, 0x000fe4000f8e02ffULL,
0x000000017d067824ULL, 0x000fc800078e0206ULL, 0x0000001c05057224ULL, 0x000fe200078e0206ULL,
0x0000002000067810ULL, 0x000fc80007ffe0ffULL, 0x0000000502057210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff0d7819ULL, 0x000fc60000011606ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x008fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440cULL,
0x0000001f0d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0103ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe200078e020dULL, 0x00000040000c7810ULL, 0x000fe20007ffe0ffULL,
0x000000101d0d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x000000017d047824ULL, 0x000fc800078e0204ULL, 0x0000001c0d0d7224ULL, 0x000fe400078e0204ULL,
0x0000000879077824ULL, 0x002fc600078e0206ULL, 0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000d047a11ULL, 0x000fc800078040ffULL,
0x00005d000d057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0d7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000001f0d00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe200078e020dULL, 0x0000006000007810ULL, 0x000fe20007ffe0ffULL,
0x000000101d0d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000879077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x000000017d047824ULL, 0x000fc800078e0204ULL,
0x0000001c0d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff0d7819ULL, 0x000fc60000011600ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fe200078040ffULL, 0x0000000100067824ULL, 0x002fc600078e020dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x0000001f0d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000706077812ULL, 0x000fc800078ec0ffULL,
0xfffffff807067812ULL, 0x000fe200078ef800ULL, 0x0000000804007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000101d0d7824ULL, 0x000fc800078e020dULL,
0x0000000006047984ULL, 0x002e620000000c00ULL, 0x000000050d037c12ULL, 0x000fe2000f8e30ffULL,
0x0000000879797824ULL, 0x000fe200078e0200ULL, 0x00005a00ff0d7a19ULL, 0x000fc6000001160dULL,
0x000000017d087824ULL, 0x000fc800078e0203ULL, 0x0000001c0d0d7224ULL, 0x000fca00078e0208ULL,
0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005c000d027a11ULL, 0x000fc800078040ffULL, 0x00005d000d037a11ULL, 0x000fca00000f4408ULL,
0x0000001079027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006a00ff067624ULL, 0x002fe400078e00ffULL,
0x00006b00ff077624ULL, 0x000fca00078e00ffULL, 0x0000000806067981ULL, 0x000322000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0300780cULL, 0x000fe20003f04070ULL,
0x000000020c767824ULL, 0x000fe200078e00ffULL, 0x01760000ff047f8cULL, 0x000ea2000c80043fULL,
0x0000004002797824ULL, 0x000fe400078e00ffULL, 0x0000590076767a24ULL, 0x000fc800078e027dULL,
0x0000660076087a24ULL, 0x000fc800078e0279ULL, 0x00000c7000000947ULL, 0x000fea0003800000ULL,
0x00000079770a7217ULL, 0x000fe40007800000ULL, 0x00000003ff107819ULL, 0x000fc60000011611ULL,
0x000000010a077824ULL, 0x002fe200078e0a79ULL, 0x00000004100c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0210ULL, 0x0000000810127810ULL, 0x000fe40007ffe0ffULL,
0x000000070c00720cULL, 0x040fe20003fa6070ULL, 0x000000010c037824ULL, 0x000fe200078e0211ULL,
0x0000000c10187810ULL, 0x000fe20007ffe0ffULL, 0x000000080c207824ULL, 0x000fe200078e00ffULL,
0x00000014101e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001080c7824ULL, 0x000fe200078e020cULL,
0x00000010100e7810ULL, 0x000fe20007ffe0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x00000018102a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee203ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a147812ULL, 0x100fe400078ef800ULL,
0x000000071800720cULL, 0x080fe20003f46070ULL, 0x0000000112097824ULL, 0x000fe200078e0211ULL,
0x000000700c167812ULL, 0x000fe200078ef800ULL, 0x0000000812227824ULL, 0x000fe200078e00ffULL,
0x0000620014147a10ULL, 0x000fe20007f1e0ffULL, 0x00000001080c7824ULL, 0x000fe200078e0218ULL,
0x0000620016167a10ULL, 0x000fe20007f3e0ffULL, 0x00000001080a7824ULL, 0x000fe200078e0212ULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x000000010e097824ULL, 0x000fe200078e0211ULL,
0x000063000d177a10ULL, 0x000fe20000ffe4ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000071200720cULL, 0x000fc40003f26070ULL, 0x000063000b157a10ULL, 0x000fe200007fe4ffULL,
0x0000000108127824ULL, 0x000fe200078e021eULL, 0x000000070e00720cULL, 0x040fe20003f06070ULL,
0x000000080e267824ULL, 0x000fe200078e00ffULL, 0x000000700c1a7812ULL, 0x000fe200078ef800ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001c102c7810ULL, 0x000fe40007ffe0ffULL,
0x000062001a1a7a10ULL, 0x000fe20007f9e0ffULL, 0x00000001080e7824ULL, 0x000fe200078e020eULL,
0xfffffff826267812ULL, 0x000fe200078ee209ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000063000d1b7a10ULL, 0x000fc400027fe4ffULL, 0x0000002810327810ULL, 0x000fe20007ffe0ffULL,
0x0000000118037824ULL, 0x100fe200078e0211ULL, 0x00000070120c7812ULL, 0x100fe200078ef800ULL,
0x0000000818247824ULL, 0x000fe200078e00ffULL, 0x000000700a187812ULL, 0x000fe200078ef800ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000062000c0c7a10ULL, 0x000fe40007f9e0ffULL,
0x0000620018187a10ULL, 0x000fe20007f7e0ffULL, 0x00000001081c7824ULL, 0x000fe200078e022aULL,
0x000000700e0e7812ULL, 0x000fe200078ef800ULL, 0x0000000110097824ULL, 0x000fe200078e0211ULL,
0x000063000b197a10ULL, 0x000fe20001ffe4ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fc40007f7e0ffULL, 0x00006300130d7a10ULL, 0x000fe200027fe4ffULL,
0x000000081e287824ULL, 0x000fe200078e00ffULL, 0x000000701c0a7812ULL, 0x000fe200078ef800ULL,
0x000000012a217824ULL, 0x100fe200078e0211ULL, 0x00000007091c7812ULL, 0x000fe200078ec0ffULL,
0x000000011e097824ULL, 0x000fe200078e0211ULL, 0x000000071000720cULL, 0x080fe20003f86070ULL,
0x0000000108127824ULL, 0x040fe200078e022cULL, 0x000063000f0f7a10ULL, 0x000fe20001ffe4ffULL,
0x0000000108237824ULL, 0x000fe200078e0232ULL, 0xfffffff824247812ULL, 0x000fe200078ee203ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000071e00720cULL, 0x000fc40003f66070ULL,
0x0000100002037811ULL, 0x000fe400078e70ffULL, 0x0ffffff81c1e7812ULL, 0x000fe400078ef811ULL,
0xfffffff828287812ULL, 0x000fe400078ee209ULL, 0x00000020102e7810ULL, 0x000fe20007ffe0ffULL,
0x000000101e097824ULL, 0x000fe200078e0203ULL, 0x0000002410307810ULL, 0x000fe40007ffe0ffULL,
0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x00000001081c7824ULL, 0x000fe200078e022eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014097faeULL, 0x0003e2000e101c48ULL,
0x000000072a00720cULL, 0x040fe20003f86070ULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x000063001d0b7a10ULL, 0x000fe200037fe4ffULL, 0x00000001081e7824ULL, 0x000fe200078e0230ULL,
0x0000007012127812ULL, 0x000fe200078ef800ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fc400078ee221ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x000000082c217824ULL, 0x000fe200078e00ffULL, 0x000000701c1c7812ULL, 0x000fe200078ef800ULL,
0x0000001020097824ULL, 0x002fe200078e0203ULL, 0x0000630013137a10ULL, 0x000fe200037fe4ffULL,
0x000000012c207824ULL, 0x000fe200078e0211ULL, 0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x0000008023147825ULL, 0x000fe200078e00ffULL, 0x0000000016097faeULL, 0x0003e2000e901c48ULL,
0x000000072c00720cULL, 0x080fe40003fa6070ULL, 0xfffffff821207812ULL, 0x000fe200078ee220ULL,
0x0000001022217824ULL, 0x000fe200078e0203ULL, 0x0000002c102c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000130237824ULL, 0x100fe200078e0211ULL, 0x000063001d1d7a10ULL, 0x000fe200037fe4ffULL,
0x000000012e227824ULL, 0x040fe200078e0211ULL, 0x0000000018217faeULL, 0x0007e2000c901c48ULL,
0x000000082e257824ULL, 0x000fe200078e00ffULL, 0x0000007014147812ULL, 0x000fe200078ef800ULL,
0x0000001024097824ULL, 0x002fe200078e0203ULL, 0x000000072e00720cULL, 0x000fe20003f26070ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fc400078ee222ULL,
0x000000001a097faeULL, 0x0003e2000d101c48ULL, 0x000000073000720cULL, 0x040fe20003f46070ULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x000000701e1e7812ULL, 0x000fe200078ef800ULL,
0x0000001026197824ULL, 0x008fe400078e0203ULL, 0x0000000108167824ULL, 0x000fe200078e022cULL,
0xfffffff830187812ULL, 0x000fe200078ee223ULL, 0x0000001020217824ULL, 0x000fe200078e0203ULL,
0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000000e197faeULL, 0x0007e2000c101c48ULL, 0x00000034101a7810ULL, 0x002fc40007ffe0ffULL,
0x0000001018257824ULL, 0x100fe200078e0203ULL, 0x0000003010187810ULL, 0x000fe20007ffe0ffULL,
0x0000001028097824ULL, 0x100fe200078e0203ULL, 0x000063001f1f7a10ULL, 0x000fe200037fe4ffULL,
0x000000102a1b7824ULL, 0x100fe200078e0203ULL, 0x0000620014147a10ULL, 0x000fe20007fde0ffULL,
0x0000001022237824ULL, 0x000fe200078e0203ULL, 0x000000000c097faeULL, 0x0003e2000d901c48ULL,
0x0000007016167812ULL, 0x000fe200078ef800ULL, 0x00000001080e7824ULL, 0x008fe200078e0218ULL,
0x0000630015157a10ULL, 0x000fe200037fe4ffULL, 0x000000000a1b7faeULL, 0x0007e2000e101c48ULL,
0x0000620016167a10ULL, 0x000fc40007fde0ffULL, 0x0000003810207810ULL, 0x040fe20007ffe0ffULL,
0x0000000012217faeULL, 0x0005e2000e901c48ULL, 0x0000003c10227810ULL, 0x000fe20007ffe0ffULL,
0x0000000832107824ULL, 0x000fe200078e00ffULL, 0x0000630017177a10ULL, 0x000fe200037fe4ffULL,
0x00000001080c7824ULL, 0x002fe200078e021aULL, 0x000000001c237faeULL, 0x0003e2000c901c48ULL,
0x0000000132097824ULL, 0x040fe200078e0211ULL, 0x000000073200720cULL, 0x080fe20003fa6070ULL,
0x000000800e0a7825ULL, 0x008fe200078e00ffULL, 0x000000001e257faeULL, 0x0007e2000d101c48ULL,
0x000000072c00720cULL, 0x000fc40003f86070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a0e7812ULL, 0x000fe400078ef800ULL, 0xfffffff810107812ULL, 0x000fe200078ee209ULL,
0x00000001080a7824ULL, 0x000fe200078e0220ULL, 0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x0000000118097824ULL, 0x140fe200078e0211ULL, 0x000000071800720cULL, 0x080fe20003f66070ULL,
0x000000082c127824ULL, 0x004fe200078e00ffULL, 0x000000071a00720cULL, 0x080fe20003f46070ULL,
0x0000000818187824ULL, 0x000fe200078e00ffULL, 0x000000072000720cULL, 0x080fe20003f26070ULL,
0x0000000108087824ULL, 0x000fe200078e0222ULL, 0x000000072200720cULL, 0x000fe20003f06070ULL,
0x000000012c077824ULL, 0x000fe200078e0211ULL, 0x000063000b0f7a10ULL, 0x000fe200037fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fc400078ef800ULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000011a077824ULL, 0x000fe200078e0211ULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee209ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x100fe400078ef800ULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000000120137824ULL, 0x100fe200078e0211ULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x00000008201c7824ULL, 0x002fe200078e00ffULL, 0x0000007008007812ULL, 0x000fe200078ef800ULL,
0x0000000122117824ULL, 0x000fe200078e0211ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL,
0x00000008221e7824ULL, 0x008fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee213ULL,
0x0000001010077824ULL, 0x100fe200078e0203ULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x0000001018137824ULL, 0x000fe200078e0203ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee211ULL,
0x0000001012117824ULL, 0x100fe200078e0203ULL, 0x0000620000087a10ULL, 0x000fe20007fde0ffULL,
0x000000101a197824ULL, 0x100fe200078e0203ULL, 0x0000000014077faeULL, 0x0003e2000e901c48ULL,
0x000000101c1b7824ULL, 0x100fe200078e0203ULL, 0x0000630009097a10ULL, 0x000fe200037fe4ffULL,
0x000000101e037824ULL, 0x000fe200078e0203ULL, 0x0000000016117faeULL, 0x0003e8000e101c48ULL,
0x000000000e137faeULL, 0x0003e8000d901c48ULL, 0x000000000c197faeULL, 0x0003e8000d101c48ULL,
0x000000000a1b7faeULL, 0x0003e8000c901c48ULL, 0x0000000008037faeULL, 0x0003e2000c101c48ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x00000008110c7811ULL, 0x040fe400078fe8ffULL,
0x0000000411077811ULL, 0x002fc400078fe8ffULL, 0x0000001411127811ULL, 0x040fe200078fe8ffULL,
0x000000010c097824ULL, 0x140fe200078e0211ULL, 0x0000000c110d7811ULL, 0x040fe200078fe8ffULL,
0x000000080c107824ULL, 0x000fe200078e00ffULL, 0x0000001811137811ULL, 0x000fe200078fe8ffULL,
0x0000000107037824ULL, 0x000fe200078e0211ULL, 0x0000001c11157811ULL, 0x000fe200078fe8ffULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0xfffffff810177812ULL, 0x000fe200078ee209ULL,
0x0000000112097824ULL, 0x040fe200078e0211ULL, 0x0000001011107811ULL, 0x000fe200078fe8ffULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x000000010d0a7824ULL, 0x000fe200078e0211ULL, 0x0000002411187811ULL, 0x000fe200078fe8ffULL,
0x000000080d197824ULL, 0x000fe200078e00ffULL, 0xfffffff8161d7812ULL, 0x000fe200078ee209ULL,
0x0000000110037824ULL, 0x140fe200078e0211ULL, 0x0000002011167811ULL, 0x000fe200078fe8ffULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee20aULL,
0x00000001130a7824ULL, 0x000fe200078e0211ULL, 0x00000028111a7811ULL, 0x000fe200078fe8ffULL,
0x00000008131f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8141b7812ULL, 0x000fe200078ee203ULL,
0x00000001150b7824ULL, 0x100fe200078e0211ULL, 0x0000002c111c7811ULL, 0x000fe200078fe8ffULL,
0x00000008151e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL,
0x0000000116037824ULL, 0x040fe200078e0211ULL, 0x0000003011277811ULL, 0x040fe200078fe8ffULL,
0x0000000816207824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL,
0x0000000118097824ULL, 0x040fe200078e0211ULL, 0x0000003411297811ULL, 0x040fe200078fe8ffULL,
0x0000000818147824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee203ULL,
0x000000011a0a7824ULL, 0x040fe200078e0211ULL, 0x0000001111037211ULL, 0x040fe200078fe8ffULL,
0x000000081a237824ULL, 0x000fe200078e00ffULL, 0xfffffff814217812ULL, 0x000fe200078ee209ULL,
0x000000011c0b7824ULL, 0x040fe200078e0211ULL, 0x00000038112b7811ULL, 0x040fe200078fe8ffULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0x0000003c112c7811ULL, 0x040fe200078fe8ffULL,
0x00000001080f7824ULL, 0x040fe200078e020dULL, 0x0000000811097211ULL, 0x000fe200078fe8ffULL,
0x0000000108247824ULL, 0x040fe200078e0216ULL, 0xfffffff823237812ULL, 0x000fe200078ee20aULL,
0x0000000108267824ULL, 0x000fe200078e0218ULL, 0xfffffff822257812ULL, 0x000fe200078ee20bULL,
0x0000000108287824ULL, 0x040fe200078e021aULL, 0x00000007030a7812ULL, 0x000fe200078ec0ffULL,
0x00000001082a7824ULL, 0x000fc400078e021cULL, 0x00000001080b7824ULL, 0x000fe200078e0207ULL,
0x0ffffff80a037812ULL, 0x000fe200078ef811ULL, 0x00000001080c7824ULL, 0x040fe400078e020cULL,
0x0000000108107824ULL, 0x040fe400078e0210ULL, 0x0000000108127824ULL, 0x040fe400078e0212ULL,
0x0000000108147824ULL, 0x040fe400078e0213ULL, 0x0000000108227824ULL, 0x000fc400078e0215ULL,
0x00000001081c7824ULL, 0x040fe400078e0227ULL, 0x00000001081a7824ULL, 0x040fe400078e0229ULL,
0x00000001290d7824ULL, 0x040fe400078e0211ULL, 0x0000000829307824ULL, 0x000fe400078e00ffULL,
0x0000000108187824ULL, 0x040fe400078e022bULL, 0x0000000108167824ULL, 0x000fe200078e022cULL,
0xfffffff830137812ULL, 0x000fe200078ee20dULL, 0x0000008009087825ULL, 0x000fc800078e00ffULL,
0x0000000127077824ULL, 0x140fe200078e0211ULL, 0x0000007008087812ULL, 0x000fe200078ef800ULL,
0x00000008272e7824ULL, 0x000fe400078e00ffULL, 0x000000012c0a7824ULL, 0x100fe200078e0211ULL,
0x0000620008087a10ULL, 0x000fe20007f1e0ffULL, 0x000000082c277824ULL, 0x000fe200078e00ffULL,
0x00001000022c7811ULL, 0x000fe200078e70ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000630009097a10ULL, 0x000fe400007fe4ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x000000012b157824ULL, 0x040fe200078e0211ULL, 0xfffffff82e117812ULL, 0x000fe200078ee207ULL,
0x000000100e077824ULL, 0x000fe200078e022cULL, 0x000000700c0c7812ULL, 0x000fe200078ef800ULL,
0x000000082b327824ULL, 0x000fc400078e00ffULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000062000c0c7a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff832157812ULL, 0x000fe200078ee215ULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x000000700e0e7812ULL, 0x000fe400078ef800ULL,
0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL, 0x00000010133b7824ULL, 0x000fe200078e022cULL,
0x000000700a0a7812ULL, 0x000fe200078ef800ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fc40007f1e0ffULL, 0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000001011397824ULL, 0x000fe200078e022cULL, 0x0000007012127812ULL, 0x000fe200078ef800ULL,
0x0000001023357824ULL, 0x100fe200078e022cULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fe40007f1e0ffULL,
0x000063000b0b7a10ULL, 0x000fe20000ffe4ffULL, 0x00000010153d7824ULL, 0x000fe200078e022cULL,
0x0000007010107812ULL, 0x000fe200078ef800ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000630013137a10ULL, 0x000fc400007fe4ffULL, 0x0000620010107a10ULL, 0x000fe20007f3e0ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x0000630011117a10ULL, 0x000fe20000ffe4ffULL,
0x0000001025377824ULL, 0x000fe200078e022cULL, 0x0000007014147812ULL, 0x000fe200078ef800ULL,
0x0000001003037824ULL, 0x100fe400078e022cULL, 0x0000001017177824ULL, 0x100fe200078e022cULL,
0x0000620014147a10ULL, 0x000fe20007f5e0ffULL, 0x0000001019197824ULL, 0x100fe200078e022cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008037faeULL, 0x0003e2000b901c48ULL,
0x000000101b1b7824ULL, 0x100fe200078e022cULL, 0x0000630015157a10ULL, 0x000fe200017fe4ffULL,
0x000000101d1d7824ULL, 0x100fe200078e022cULL, 0x000000000a077faeULL, 0x0003e2000b901c48ULL,
0x000000101f1f7824ULL, 0x000fc400078e022cULL, 0x000000101e1e7824ULL, 0x100fe200078e022cULL,
0x000000000c177faeULL, 0x0003e2000b901c48ULL, 0x0000001020207824ULL, 0x100fe400078e022cULL,
0x0000001021217824ULL, 0x100fe200078e022cULL, 0x000000000e197faeULL, 0x0003e2000b901c48ULL,
0x00000010273f7824ULL, 0x000fe200078e022cULL, 0x00000070222c7812ULL, 0x100fe200078ef800ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x00000000101b7faeULL, 0x0003e4000b901c48ULL,
0x000062002c2c7a10ULL, 0x000fe20007f1e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x00000070242e7812ULL, 0x100fe200078ef800ULL, 0x00000000121d7faeULL, 0x0003e2000b901c48ULL,
0x00006300232d7a10ULL, 0x000fe200007fe4ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000007026307812ULL, 0x100fe200078ef800ULL, 0x00000000141f7faeULL, 0x0003e2000b901c48ULL,
0x000062002e2e7a10ULL, 0x000fe20007f3e0ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000007028327812ULL, 0x000fe200078ef800ULL, 0x000000002c1e7faeULL, 0x0003e2000b901c48ULL,
0x0000620030307a10ULL, 0x000fe20007f1e0ffULL, 0x000000801c227825ULL, 0x000fe200078e00ffULL,
0x0000620032327a10ULL, 0x000fc40007f5e0ffULL, 0x00006300252f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000801a247825ULL, 0x000fe200078e00ffULL, 0x000000702a2a7812ULL, 0x100fe400078ef800ULL,
0x0000630027317a10ULL, 0x000fe200007fe4ffULL, 0x0000008018267825ULL, 0x000fe200078e00ffULL,
0x0000630029337a10ULL, 0x000fe200017fe4ffULL, 0x000000002e207faeULL, 0x0003e2000b901c48ULL,
0x000062002a2a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000008016287825ULL, 0x000fe200078e00ffULL,
0x0000007022227812ULL, 0x100fe200078ef800ULL, 0x0000000030217faeULL, 0x0003e2000b901c48ULL,
0x0000007024247812ULL, 0x000fc400078ef800ULL, 0x0000007026267812ULL, 0x100fe200078ef800ULL,
0x0000000032357faeULL, 0x0003e2000b901c48ULL, 0x000063002b2b7a10ULL, 0x000fe400007fe4ffULL,
0x0000007028007812ULL, 0x000fe400078ef800ULL, 0x0000620022227a10ULL, 0x000fe20007f1e0ffULL,
0x000000002a377faeULL, 0x0003e2000b901c48ULL, 0x0000620024247a10ULL, 0x000fe40007f3e0ffULL,
0x0000620026267a10ULL, 0x000fc40007f5e0ffULL, 0x0000620000287a10ULL, 0x000fe40007f7e0ffULL,
0x0000630023237a10ULL, 0x000fe400007fe4ffULL, 0x0000630025257a10ULL, 0x000fe40000ffe4ffULL,
0x0000630027277a10ULL, 0x000fe200017fe4ffULL, 0x0000000022397faeULL, 0x0003e2000b901c48ULL,
0x0000630029297a10ULL, 0x000fc60001ffe4ffULL, 0x00000000243b7faeULL, 0x0003e8000b901c48ULL,
0x00000000263d7faeULL, 0x0003e8000b901c48ULL, 0x00000000283f7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x01760400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08037210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e09ULL, 0x003d09000300780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400300780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140aULL,
0x0000000300007211ULL, 0x000fca00078110ffULL, 0x000000ffff037224ULL, 0x000fca00000e060aULL,
0x0000000200007819ULL, 0x000fc80000001203ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000107077810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002002007824ULL, 0x002fca00078e0203ULL,
0x00000003ff037819ULL, 0x000fc80000011600ULL, 0x1ffffffe03057812ULL, 0x000fe400078ec0ffULL,
0x0000000f00037812ULL, 0x000fc600078ec0ffULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x0000001003077824ULL, 0x040fe400078e00ffULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x0000000f05007812ULL, 0x040fe400078ec0ffULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000000f007007812ULL, 0x000fe400078ee200ULL, 0x0000000f05057812ULL, 0x000fc600078ec0ffULL,
0x00000000000c7984ULL, 0x000e62000000cc00ULL, 0x000000f004057812ULL, 0x000fca00078ee205ULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001000007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff077224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x01760400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000804037210ULL, 0x000fca0007f1e1ffULL,
0x0000000109087824ULL, 0x000fe200000e0e05ULL, 0x003d09000300780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400300780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011408ULL,
0x0000000300007211ULL, 0x000fca00078110ffULL, 0x000000ffff037224ULL, 0x000fca00000e0608ULL,
0x0000000200007819ULL, 0x000fc80000001203ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000107077810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff7a00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000001fff007424ULL, 0x000fe200078e00ffULL,
0x8000580077787a10ULL, 0x000fe20007ffe0ffULL, 0x00000001ff7b7424ULL, 0x000fe200078e00ffULL,
0x0000010079797810ULL, 0x000fe20007ffe0ffULL, 0x00005800ff727624ULL, 0x000fe200078e00ffULL,
0x0000580000007a10ULL, 0x000fe20007ffe0ffULL, 0x3db504f306047820ULL, 0x010fe20000410000ULL,
0x00017688027c7811ULL, 0x040fe200078e18ffULL, 0x000000ffff6e7224ULL, 0x000fe200078e00ffULL,
0x00000004ff007819ULL, 0x000fe20000011600ULL, 0x000000ffff6d7224ULL, 0x000fe200078e00ffULL,
0x00017608027d7811ULL, 0x000fc400078e28ffULL, 0x000058007b7b7a10ULL, 0x000fe40007ffe1ffULL,
0x0000000972727810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff787819ULL, 0x000fe40000011678ULL,
0x0ffffffe00737812ULL, 0x000fc400078ec0ffULL, 0x000000026e057810ULL, 0x040fe20007ffe0ffULL,
0x000001006e6f7824ULL, 0x000fe200078e0279ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000016d717812ULL, 0x000fe400078e0cffULL, 0x0000007a0500720cULL, 0x000fe20003f06070ULL,
0x0000660076007a24ULL, 0x000fd800078e026fULL, 0x00000ca000008947ULL, 0x00cfea0003800000ULL,
0x00000003ff157819ULL, 0x002fe20000011603ULL, 0x00000002021a7824ULL, 0x000fe200078e0271ULL,
0x0000006f77147217ULL, 0x000fe40007800000ULL, 0x0000000415077810ULL, 0x040fe20007ffe0ffULL,
0x0000000115187824ULL, 0x040fe200078e0203ULL, 0x00000008150b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000114147824ULL, 0x000fe200078e0a6fULL, 0x0000000c150d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107057824ULL, 0x100fe200078e0203ULL, 0x00000010150f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000807067824ULL, 0x040fe200078e00ffULL, 0x000000140700720cULL, 0x080fe20003fa6070ULL,
0x000000010b097824ULL, 0x000fe200078e0203ULL, 0x0000001415197810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff806217812ULL, 0x000fe200078ee205ULL,
0x0000001003057824ULL, 0x000fe200078e00ffULL, 0x00000018151d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107087824ULL, 0x000fe200078e0200ULL, 0xfffffff80a237812ULL, 0x000fe200078ee209ULL,
0x000000010d0a7824ULL, 0x000fe200078e0203ULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000140d00720cULL, 0x000fc40003f46070ULL,
0x0000001c152b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d257824ULL, 0x000fe200078e00ffULL,
0x0000000508087212ULL, 0x000fe200078efcffULL, 0x000000010f1b7824ULL, 0x040fe200078e0203ULL,
0x0000000718187812ULL, 0x000fe200078ec0ffULL, 0x000000080f0c7824ULL, 0x000fe200078e00ffULL,
0x0000620008087a10ULL, 0x000fe20007f3e0ffULL, 0x0000000115067824ULL, 0x000fe200078e0200ULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000010b0a7824ULL, 0x100fe200078e0200ULL,
0x0000630009097a10ULL, 0x000fe20000ffe4ffULL, 0x000000010f107824ULL, 0x100fe200078e0200ULL,
0xfffffff80c1b7812ULL, 0x000fe200078ee21bULL, 0x000000010d0c7824ULL, 0x000fe200078e0200ULL,
0x000000140b00720cULL, 0x000fe20003f26070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x00000020152d7810ULL, 0x000fc40007ffe0ffULL, 0x000010001a1a7811ULL, 0x000fe200078e68ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000050a0a7212ULL, 0x080fe400078efcffULL,
0x0ffffff8181f7812ULL, 0x000fe200078ef803ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000506067212ULL, 0x080fe400078efcffULL, 0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000050c0e7212ULL, 0x000fc400078efcffULL,
0x0000620006067a10ULL, 0x000fe20007f1e0ffULL, 0x0000000119127824ULL, 0x100fe200078e0200ULL,
0x00000005100c7212ULL, 0x000fe200078efcffULL, 0x000000011d167824ULL, 0x000fe200078e0200ULL,
0x000062000e0e7a10ULL, 0x000fe20007f9e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000063000b0b7a10ULL, 0x000fe40001ffe4ffULL, 0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000630007077a10ULL, 0x000fc400007fe4ffULL,
0x0000000512107212ULL, 0x080fe200078efcffULL, 0x00000001191c7824ULL, 0x100fe200078e0203ULL,
0x000000140f00720cULL, 0x080fe20003f06070ULL, 0x0000000819277824ULL, 0x000fe200078e00ffULL,
0x0000000516127212ULL, 0x000fe200078efcffULL, 0x000000012b167824ULL, 0x100fe200078e0200ULL,
0x000063000d0f7a10ULL, 0x000fe200027fe4ffULL, 0x000000012d187824ULL, 0x000fe200078e0200ULL,
0x00006300110d7a10ULL, 0x000fe20001ffe4ffULL, 0x000000101f1f7824ULL, 0x100fe200078e021aULL,
0x0000620010107a10ULL, 0x000fe20007f7e0ffULL, 0x000000011d207824ULL, 0x040fe200078e0203ULL,
0x0000620012127a10ULL, 0x000fe20007f9e0ffULL, 0x000000081d297824ULL, 0x000fe200078e00ffULL,
0x0000630013117a10ULL, 0x000fe20001ffe4ffULL, 0x000000101b1b7824ULL, 0x000fe200078e021aULL,
0x0000630017137a10ULL, 0x000fe200027fe4ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000141500720cULL, 0x000fc40003f86070ULL, 0x00000024152f7810ULL, 0x000fe40007ffe0ffULL,
0x000000141900720cULL, 0x080fe20003f66070ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000516167212ULL, 0x080fe400078efcffULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x000000012f1c7824ULL, 0x000fe200078e0200ULL, 0x0000002815317810ULL, 0x000fe40007ffe0ffULL,
0x0000620016167a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000061f7faeULL, 0x0003e2000e101c48ULL, 0x000000141d00720cULL, 0x000fe20003f86070ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000518187212ULL, 0x000fc400078efcffULL,
0x0000002c15337810ULL, 0x000fe20007ffe0ffULL, 0x00000001311e7824ULL, 0x000fe200078e0200ULL,
0x0000630017177a10ULL, 0x000fe400037fe4ffULL, 0x0000620018187a10ULL, 0x000fe40007fde0ffULL,
0x000000051c1c7212ULL, 0x000fe200078efcffULL, 0x00000010211f7824ULL, 0x102fe200078e021aULL,
0x0000630019197a10ULL, 0x000fe200037fe4ffULL, 0x0000001023217824ULL, 0x000fe200078e021aULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x000000801e067825ULL, 0x000fe200078e00ffULL,
0x00000000081f7faeULL, 0x0003e2000e901c48ULL, 0xfffffff829297812ULL, 0x000fc400078ee220ULL,
0x000063001d1d7a10ULL, 0x000fe200037fe4ffULL, 0x000000000a217faeULL, 0x0005e2000c901c48ULL,
0x0000000506067212ULL, 0x000fe200078efcffULL, 0x000000012b1e7824ULL, 0x140fe200078e0203ULL,
0x000000142b00720cULL, 0x0c0fe20003fa6070ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x0000620006067a10ULL, 0x000fe20007fde0ffULL, 0x000000012f207824ULL, 0x000fe200078e0203ULL,
0x000000142d00720cULL, 0x000fe20003f26070ULL, 0x00000010251f7824ULL, 0x002fe200078e021aULL,
0x0000003015257810ULL, 0x000fe20007ffe0ffULL, 0x0000000133087824ULL, 0x000fe200078e0200ULL,
0x0000630007077a10ULL, 0x000fe200037fe4ffULL, 0x00000010270b7824ULL, 0x004fe200078e021aULL,
0x000000000e1f7faeULL, 0x0003e2000d101c48ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fc400078ee21eULL, 0x000000000c1b7faeULL, 0x0005e2000c101c48ULL,
0x00000001250a7824ULL, 0x000fe200078e0200ULL, 0x0000000508087212ULL, 0x080fe200078efcffULL,
0x000000012d1e7824ULL, 0x140fe200078e0203ULL, 0x00000000100b7faeULL, 0x0007e2000d901c48ULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x0000620008087a10ULL, 0x000fe20007fde0ffULL,
0x000000082f237824ULL, 0x000fe200078e00ffULL, 0x0000003815277810ULL, 0x000fe20007ffe0ffULL,
0x00000010290f7824ULL, 0x102fe200078e021aULL, 0x0000630009097a10ULL, 0x000fe200037fe4ffULL,
0x00000001310e7824ULL, 0x000fe200078e0203ULL, 0x00000034151b7810ULL, 0x004fe20007ffe0ffULL,
0x000000102b1f7824ULL, 0x000fe200078e021aULL, 0x00000000120f7faeULL, 0x0003e2000e101c48ULL,
0x000000142f00720cULL, 0x000fe20003f46070ULL, 0x000000800a0a7825ULL, 0x008fe200078e00ffULL,
0xfffffff82d217812ULL, 0x000fe200078ee21eULL, 0x00000000161f7faeULL, 0x0005e2000e901c48ULL,
0x0000003c15297810ULL, 0x000fe20007ffe0ffULL, 0x000000011b0c7824ULL, 0x000fe200078e0200ULL,
0x000000050a0a7212ULL, 0x000fe200078efcffULL, 0x0000000833157824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee220ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000062000a0a7a10ULL, 0x000fc40007fde0ffULL, 0x000000143100720cULL, 0x040fe20003fa6070ULL,
0x0000000831137824ULL, 0x002fe200078e00ffULL, 0x000000050c107212ULL, 0x000fe200078efcffULL,
0x00000001270c7824ULL, 0x000fe200078e0200ULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x0000001021217824ULL, 0x000fe200078e021aULL, 0xfffffff813137812ULL, 0x000fe200078ee20eULL,
0x00000001330e7824ULL, 0x100fe200078e0203ULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x00000001250f7824ULL, 0x040fe200078e0203ULL, 0x0000000018217faeULL, 0x0003e2000c901c48ULL,
0x0000000825127824ULL, 0x000fe200078e00ffULL, 0x000063000d117a10ULL, 0x000fe200037fe4ffULL,
0x0000001023237824ULL, 0x000fe200078e021aULL, 0xfffffff815157812ULL, 0x000fe200078ee20eULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff812177812ULL, 0x004fc400078ee20fULL,
0x000000001c237faeULL, 0x0005e2000d101c48ULL, 0x00000001290e7824ULL, 0x000fe200078e0200ULL,
0x000000050c0c7212ULL, 0x080fe200078efcffULL, 0x000000011b127824ULL, 0x100fe200078e0203ULL,
0x000000143300720cULL, 0x080fe20003f86070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000141b00720cULL, 0x080fe40003f46070ULL, 0x000000142500720cULL, 0x080fe20003f66070ULL,
0x000000081b197824ULL, 0x002fe200078e00ffULL, 0x000000142700720cULL, 0x0c0fe20003f26070ULL,
0x0000000127007824ULL, 0x100fe200078e0203ULL, 0x000000142900720cULL, 0x000fe20003f06070ULL,
0x00000008271b7824ULL, 0x000fe200078e00ffULL, 0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL,
0x0000000129147824ULL, 0x040fe200078e0203ULL, 0x000000050e0e7212ULL, 0x000fe200078efcffULL,
0x00000008291d7824ULL, 0x004fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee212ULL,
0x0000001013057824ULL, 0x000fe200078e021aULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x0000001015137824ULL, 0x000fe200078e021aULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee214ULL,
0x0000001017157824ULL, 0x100fe200078e021aULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001019177824ULL, 0x100fe200078e021aULL, 0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x000000101b197824ULL, 0x100fe200078e021aULL, 0x0000000006057faeULL, 0x0003e2000e901c48ULL,
0x000000101d1b7824ULL, 0x000fe200078e021aULL, 0x000063000f0f7a10ULL, 0x000fc400037fe4ffULL,
0x0000000008137faeULL, 0x0003e8000e101c48ULL, 0x000000000a157faeULL, 0x0003e8000d901c48ULL,
0x0000000010177faeULL, 0x0003e8000d101c48ULL, 0x000000000c197faeULL, 0x0003e8000c901c48ULL,
0x000000000e1b7faeULL, 0x0003e2000c101c48ULL, 0x00000b6000007947ULL, 0x000fea0003800000ULL,
0x00000008030a7811ULL, 0x042fe200078fe8ffULL, 0x0000001003377824ULL, 0x040fe200078e00ffULL,
0x0000000403087811ULL, 0x000fc400078fe8ffULL, 0x0000001403107811ULL, 0x040fe200078fe8ffULL,
0x000000010a067824ULL, 0x140fe200078e0203ULL, 0x0000000c030c7811ULL, 0x040fe200078fe8ffULL,
0x000000080a077824ULL, 0x000fe200078e00ffULL, 0x00000010030e7811ULL, 0x040fe200078fe8ffULL,
0x0000000108057824ULL, 0x140fe200078e0203ULL, 0x0000001803127811ULL, 0x000fe200078fe8ffULL,
0x00000008081e7824ULL, 0x000fe200078e00ffULL, 0xfffffff807207812ULL, 0x000fe200078ee206ULL,
0x0000000110077824ULL, 0x040fe200078e0203ULL, 0x0000002403187811ULL, 0x040fe200078fe8ffULL,
0x00000008102e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee205ULL,
0x000000010c057824ULL, 0x140fe200078e0203ULL, 0x0000001c03147811ULL, 0x040fe200078fe8ffULL,
0x000000080c2a7824ULL, 0x000fe200078e00ffULL, 0x0000002003167811ULL, 0x040fe200078fe8ffULL,
0x000000010e067824ULL, 0x000fe200078e0203ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee207ULL,
0x000000080e0b7824ULL, 0x000fe200078e00ffULL, 0x00000028031a7811ULL, 0x000fe200078fe8ffULL,
0x0000000112097824ULL, 0x000fe200078e0203ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL,
0x0000000812307824ULL, 0x000fe200078e00ffULL, 0xfffffff80b2c7812ULL, 0x000fe200078ee206ULL,
0x0000000118077824ULL, 0x140fe200078e0203ULL, 0x0000003403267811ULL, 0x040fe200078fe8ffULL,
0x0000000818367824ULL, 0x000fe200078e00ffULL, 0x0000002c031c7811ULL, 0x040fe200078fe8ffULL,
0x0000000114057824ULL, 0x040fe200078e0203ULL, 0x0000003003287811ULL, 0x040fe200078fe8ffULL,
0x0000000814327824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee209ULL,
0x0000000116067824ULL, 0x000fe200078e0203ULL, 0xfffffff836367812ULL, 0x000fe200078ee207ULL,
0x00000008160b7824ULL, 0x000fe200078e00ffULL, 0x0000003803247811ULL, 0x000fe200078fe8ffULL,
0x000000011a097824ULL, 0x000fe200078e0203ULL, 0xfffffff832327812ULL, 0x000fe200078ee205ULL,
0x000000081a387824ULL, 0x000fe200078e00ffULL, 0xfffffff80b347812ULL, 0x000fe200078ee206ULL,
0x0000000126077824ULL, 0x040fe200078e0203ULL, 0x0000007037377812ULL, 0x000fe200078ec0ffULL,
0x00000008263e7824ULL, 0x000fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee209ULL,
0x000000011c057824ULL, 0x000fc400078e0203ULL, 0x000000081c3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL, 0x0000000128067824ULL, 0x040fe200078e0203ULL,
0x0000003c03077811ULL, 0x040fe200078fe8ffULL, 0x00000008280b7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL, 0x0000000124097824ULL, 0x040fe200078e0203ULL,
0x0000000303057211ULL, 0x000fe200078fe8ffULL, 0x0000000824407824ULL, 0x000fe200078e00ffULL,
0xfffffff80b3c7812ULL, 0x000fe200078ee206ULL, 0x0000000108087824ULL, 0x100fe200078e0200ULL,
0x0000000003067211ULL, 0x000fe200078fe8ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0200ULL,
0xfffffff840407812ULL, 0x000fe200078ee209ULL, 0x0000000202097824ULL, 0x000fc400078e0271ULL,
0x000000010c0c7824ULL, 0x100fe400078e0200ULL, 0x000000010e0e7824ULL, 0x100fe200078e0200ULL,
0x00001000090d7811ULL, 0x000fe200078e68ffULL, 0x0000000110107824ULL, 0x100fe400078e0200ULL,
0x0000000112127824ULL, 0x100fe400078e0200ULL, 0x0000000114147824ULL, 0x100fe400078e0200ULL,
0x0000000116167824ULL, 0x000fc400078e0200ULL, 0x0000000118187824ULL, 0x100fe400078e0200ULL,
0x000000011a1a7824ULL, 0x100fe400078e0200ULL, 0x000000011c1c7824ULL, 0x100fe400078e0200ULL,
0x0000000128287824ULL, 0x100fe400078e0200ULL, 0x0000000126267824ULL, 0x100fe400078e0200ULL,
0x0000000124247824ULL, 0x000fc400078e0200ULL, 0x0000000107227824ULL, 0x000fe200078e0200ULL,
0x0000000705007812ULL, 0x000fe200078ec0ffULL, 0x00000001070b7824ULL, 0x140fe400078e0203ULL,
0x0000000807427824ULL, 0x000fe200078e00ffULL, 0x0ffffff800007812ULL, 0x000fe200078ef803ULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee20bULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003706067212ULL, 0x000fc600078efcffULL,
0x0000001000357824ULL, 0x100fe200078e020dULL, 0x0000620006067a10ULL, 0x000fe20007f1e0ffULL,
0x000000101e337824ULL, 0x100fe200078e020dULL, 0x000000370a0a7212ULL, 0x000fe200078efcffULL,
0x0000001020317824ULL, 0x100fe200078e020dULL, 0x0000630007077a10ULL, 0x000fe200007fe4ffULL,
0x000000102a2f7824ULL, 0x100fe200078e020dULL, 0x000062000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000102c2d7824ULL, 0x100fe400078e020dULL, 0x000000102e2b7824ULL, 0x100fe200078e020dULL,
0x000063000b0b7a10ULL, 0x000fe200007fe4ffULL, 0x0000001030297824ULL, 0x100fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006357faeULL, 0x0003e2000b901c48ULL,
0x0000001032277824ULL, 0x000fc400078e020dULL, 0x0000001034257824ULL, 0x100fe400078e020dULL,
0x0000001036237824ULL, 0x100fe400078e020dULL, 0x0000001038217824ULL, 0x100fe400078e020dULL,
0x000000103a207824ULL, 0x100fe400078e020dULL, 0x000000103c1f7824ULL, 0x100fe400078e020dULL,
0x000000103e1e7824ULL, 0x000fc400078e020dULL, 0x0000001040057824ULL, 0x100fe400078e020dULL,
0x0000001042007824ULL, 0x000fe400078e020dULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000370c0c7212ULL, 0x000fc600078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000062000c0c7a10ULL, 0x000fe40007f1e0ffULL,
0x0000003710107212ULL, 0x080fe200078efcffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000063000d0d7a10ULL, 0x000fe400007fe4ffULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000003714147212ULL, 0x080fe400078efcffULL,
0x0000003708087212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000630011117a10ULL, 0x000fc400007fe4ffULL, 0x0000620014147a10ULL, 0x000fe20007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000620008087a10ULL, 0x000fe40007f3e0ffULL,
0x0000003718187212ULL, 0x080fe200078efcffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000370e0e7212ULL, 0x080fe400078efcffULL, 0x0000003712127212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000630015157a10ULL, 0x000fc400007fe4ffULL,
0x0000630009097a10ULL, 0x000fe20000ffe4ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000620018187a10ULL, 0x000fe40007f1e0ffULL, 0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008028387825ULL, 0x000fe200078e00ffULL, 0x000000371c1c7212ULL, 0x080fe200078efcffULL,
0x0000000008337faeULL, 0x0003e2000b901c48ULL, 0x0000620012127a10ULL, 0x000fe20007f5e0ffULL,
0x00000080263a7825ULL, 0x000fe200078e00ffULL, 0x0000003716167212ULL, 0x080fe200078efcffULL,
0x000000000a317faeULL, 0x0003e2000b901c48ULL, 0x000000371a1a7212ULL, 0x000fe200078efcffULL,
0x00000080243c7825ULL, 0x000fe200078e00ffULL, 0x0000630019197a10ULL, 0x000fe200007fe4ffULL,
0x000000000c2f7faeULL, 0x0003e2000b901c48ULL, 0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x00000080223e7825ULL, 0x000fe200078e00ffULL, 0x000062001c1c7a10ULL, 0x000fc40007f1e0ffULL,
0x0000630013137a10ULL, 0x000fe200017fe4ffULL, 0x000000000e2d7faeULL, 0x0003e2000b901c48ULL,
0x0000620016167a10ULL, 0x000fe40007f3e0ffULL, 0x0000003738367212ULL, 0x080fe200078efcffULL,
0x00000000102b7faeULL, 0x0003e2000b901c48ULL, 0x000062001a1a7a10ULL, 0x000fe40007f5e0ffULL,
0x000000373a387212ULL, 0x080fe200078efcffULL, 0x0000000012297faeULL, 0x0003e2000b901c48ULL,
0x000000373c3a7212ULL, 0x000fc400078efcffULL, 0x000063001d1d7a10ULL, 0x000fe200007fe4ffULL,
0x0000000014277faeULL, 0x0003e2000b901c48ULL, 0x000000373e377212ULL, 0x000fe400078efcffULL,
0x0000630017177a10ULL, 0x000fe40000ffe4ffULL, 0x0000620036367a10ULL, 0x000fe40007f1e0ffULL,
0x000063001b1b7a10ULL, 0x000fe200017fe4ffULL, 0x0000000016257faeULL, 0x0003e2000b901c48ULL,
0x0000620038387a10ULL, 0x000fc40007f3e0ffULL, 0x000062003a3a7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000018237faeULL, 0x0003e2000b901c48ULL, 0x00006200373c7a10ULL, 0x000fe40007f7e0ffULL,
0x0000630039377a10ULL, 0x000fe200007fe4ffULL, 0x000000001a217faeULL, 0x0003e2000b901c48ULL,
0x000063003b397a10ULL, 0x000fe40000ffe4ffULL, 0x000063003d3b7a10ULL, 0x000fe200017fe4ffULL,
0x000000001c207faeULL, 0x0003e2000b901c48ULL, 0x000063003f3d7a10ULL, 0x000fc60001ffe4ffULL,
0x00000000361f7faeULL, 0x0003e8000b901c48ULL, 0x00000000381e7faeULL, 0x0003e8000b901c48ULL,
0x000000003a057faeULL, 0x0003e8000b901c48ULL, 0x000000003c007faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff057224ULL, 0x002fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff803007812ULL, 0x000fe200078ec0ffULL,
0x0000000202187824ULL, 0x000fe200078e026dULL, 0x0000000105197810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000700007812ULL, 0x000fc400078ef803ULL,
0x0000100018187811ULL, 0x000fc600078e68ffULL, 0x0000000100067824ULL, 0x040fe400078e0205ULL,
0x0000000800077824ULL, 0x040fe400078e00ffULL, 0x0000000800097824ULL, 0x040fe400078e00ffULL,
0x0000000100007824ULL, 0x000fe200078e0219ULL, 0xfffffff807077812ULL, 0x000fc800078ee206ULL,
0xfffffff809097812ULL, 0x000fe200078ee200ULL, 0x0000001007077824ULL, 0x000fc800078e0218ULL,
0x0000001009097824ULL, 0x000fe200078e0218ULL, 0x00000000070c783bULL, 0x000e680000000200ULL,
0x000000000914783bULL, 0x020ea20000000200ULL, 0x00000018ff077819ULL, 0x002fe2000001140eULL,
0x0000000d00527306ULL, 0x000fe20000009400ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140fULL,
0x000100000f4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x004fc40000011414ULL,
0x00000018ff127819ULL, 0x000fe40000011416ULL, 0x00000018ff007819ULL, 0x000fe2000001140cULL,
0x0000001000567306ULL, 0x000fe20000209400ULL, 0x00000018ff067819ULL, 0x000fe4000001140dULL,
0x00000018ff117819ULL, 0x000fe40000011415ULL, 0x00000018ff137819ULL, 0x000fe40000011417ULL,
0x00000018ff6c7819ULL, 0x000fe2000001144dULL, 0x0000001000547306ULL, 0x000ff00000205400ULL,
0x0000001000087306ULL, 0x0003f0000020d400ULL, 0x00000007003e7306ULL, 0x000fe20000209400ULL,
0x000100000d107824ULL, 0x002fce00078e00ffULL, 0x0000000700617306ULL, 0x000ff00000205400ULL,
0x00000007004a7306ULL, 0x000ff0000020d400ULL, 0x00000012003d7306ULL, 0x000ff00000209400ULL,
0x00000012003c7306ULL, 0x000ff00000205400ULL, 0x0000001200077306ULL, 0x0003f0000020d400ULL,
0x0000000d00637306ULL, 0x000ea20000005400ULL, 0x00000018ff127819ULL, 0x002fc40000011410ULL,
0x0000002003107810ULL, 0x000fc80007ffe0ffULL, 0xfffffff810107812ULL, 0x000fe200078ec0ffULL,
0x0000000d00447306ULL, 0x0002f0000000d400ULL, 0x0000000a00537306ULL, 0x000fe20000209400ULL,
0x000001000d0d7824ULL, 0x002fe200078e00ffULL, 0x000000635200720bULL, 0x004fc80003fbd000ULL,
0x00000018ff4b7819ULL, 0x000fe4000001140dULL, 0x0000000a00597306ULL, 0x000e620000205400ULL,
0x00000007100d7812ULL, 0x000fca00078ef803ULL, 0x000000010d107824ULL, 0x040fe200078e0205ULL,
0x0000000144445812ULL, 0x008fe200078efcffULL, 0x0000000a004f7306ULL, 0x0004e2000020d400ULL,
0x000000010d197824ULL, 0x000fce00078e0219ULL, 0x0000000c00507306ULL, 0x000fe20000009400ULL,
0x000100000c0a7824ULL, 0x004fe200078e00ffULL, 0x000000595300720bULL, 0x002fc80003fbd000ULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x0000000c005b7306ULL, 0x000e6e0000005400ULL,
0x000000014f4f5812ULL, 0x008fe200078efcffULL, 0x0000000c003f7306ULL, 0x0004f0000000d400ULL,
0x00000000004c7306ULL, 0x000fe20000209400ULL, 0x000001000c0c7824ULL, 0x004fe200078e00ffULL,
0x0000005b5000720bULL, 0x002fcc0003fdd000ULL, 0x0000000000497306ULL, 0x000e6e0000205400ULL,
0x000000013f3f6812ULL, 0x008fe200078efcffULL, 0x0000000000407306ULL, 0x000eb0000020d400ULL,
0x00000011000b7306ULL, 0x000fe20000209400ULL, 0x000000494c00720bULL, 0x002fce0003f5d000ULL,
0x0000001100097306ULL, 0x000fec0000205400ULL, 0x0000000140402812ULL, 0x004fe400078efcffULL,
0x0000001100007306ULL, 0x0003f0000020d400ULL, 0x00000006001b7306ULL, 0x000fe20000209400ULL,
0x00000018ff117819ULL, 0x002fce000001140cULL, 0x00000011000c7306ULL, 0x000ff00000209400ULL,
0x0000001100477306ULL, 0x000ff00000205400ULL, 0x0000001100417306ULL, 0x0003f0000020d400ULL,
0x00000006001a7306ULL, 0x000ea20000205400ULL, 0x000000080d117824ULL, 0x002fca00078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee210ULL, 0x000100000e107824ULL, 0x000fe200078e00ffULL,
0x0000000600437306ULL, 0x000e66000020d400ULL, 0x0000001011117824ULL, 0x000fe200078e0218ULL,
0x00000018ff5a7819ULL, 0x000fc80000011410ULL, 0x0000001300647306ULL, 0x000fe20000209400ULL,
0x0000001a1b00720bULL, 0x004fe20003f3d000ULL, 0x00010000141a7824ULL, 0x000fcc00078e00ffULL,
0x00000013005f7306ULL, 0x000fec0000205400ULL, 0x0000000143431812ULL, 0x002fe400078efcffULL,
0x0000001300067306ULL, 0x000ff0000020d400ULL, 0x0000001200487306ULL, 0x000ff00000209400ULL,
0x0000001200757306ULL, 0x000e700000205400ULL, 0x0000001200467306ULL, 0x0004f0000020d400ULL,
0x0000000a00517306ULL, 0x000fe20000209400ULL, 0x000000001110783bULL, 0x004ea20000000200ULL,
0x000000754800720bULL, 0x002fcc0003fdd000ULL, 0x0000000a00587306ULL, 0x000e6e0000205400ULL,
0x0000000146466812ULL, 0x008fe200078efcffULL, 0x0000000e004e7306ULL, 0x000fe20000009400ULL,
0x000000613e00720bULL, 0x000fce0003fdd000ULL, 0x0000000e00577306ULL, 0x000ee20000005400ULL,
0x000000585100720bULL, 0x002fca0003f7d000ULL, 0x000000014a4a6812ULL, 0x000fe400078efcffULL,
0x0000000e00687306ULL, 0x000330000000d400ULL, 0x0000000a00427306ULL, 0x000f22000020d400ULL,
0x000001000e0e7824ULL, 0x002fe200078e00ffULL, 0x000000574e00720bULL, 0x008fe20003f9d000ULL,
0x0001000010537824ULL, 0x004fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fc40000011410ULL,
0x00000018ff5d7819ULL, 0x000fe4000001140eULL, 0x0000005a00677306ULL, 0x000fe20000209400ULL,
0x00000018ff517819ULL, 0x000fe40000011412ULL, 0x00000018ff4c7819ULL, 0x000fc80000011413ULL,
0x0000000168684812ULL, 0x010fe200078efcffULL, 0x0000005d00607306ULL, 0x000fe20000209400ULL,
0x0000000142423812ULL, 0x000fe400078efcffULL, 0x000000470c00720bULL, 0x000fca0003f7d000ULL,
0x0000005d00627306ULL, 0x000e700000205400ULL, 0x0000005a00697306ULL, 0x000fe20000205400ULL,
0x0000000141413812ULL, 0x000fce00078efcffULL, 0x0000005a006a7306ULL, 0x0005e2000020d400ULL,
0x000000626000720bULL, 0x002fce0003f3d000ULL, 0x0000004b000a7306ULL, 0x000fe20000209400ULL,
0x000001000f5a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000004b006b7306ULL, 0x000e700000205400ULL, 0x0000004b00457306ULL, 0x000eb0000020d400ULL,
0x0000005d004b7306ULL, 0x000ee2000020d400ULL, 0x0000006b0a00720bULL, 0x002fc40003f5d000ULL,
0x00000018ff6b7819ULL, 0x000fe20000011453ULL, 0x0000010010537824ULL, 0x000fc800078e00ffULL,
0x0000000f000e7306ULL, 0x000fec0000009400ULL, 0x0000000145452812ULL, 0x004fe400078efcffULL,
0x0000000f00557306ULL, 0x000e620000005400ULL, 0x000000014b4b1812ULL, 0x008fe400078efcffULL,
0x000000696700720bULL, 0x000fca0003f5d000ULL, 0x0000006c004d7306ULL, 0x000ff00000209400ULL,
0x0000006c005c7306ULL, 0x000ea20000205400ULL, 0x000000550e00720bULL, 0x002fe40003f1d000ULL,
0x000000016a6a2812ULL, 0x000fca00078efcffULL, 0x0000005a005d7306ULL, 0x000ff00000209400ULL,
0x0000005a005e7306ULL, 0x000e620000205400ULL, 0x0000005c4d00720bULL, 0x004fce0003f9d000ULL,
0x00000014000c7306ULL, 0x000ff00000009400ULL, 0x00000014001b7306ULL, 0x000ea20000005400ULL,
0x0000005e5d00720bULL, 0x002fce0003f3d000ULL, 0x00000070005b7306ULL, 0x000ff00000209400ULL,
0x0000007000637306ULL, 0x000fe20000205400ULL, 0x0000001b0c00720bULL, 0x004fe20003f7d000ULL,
0x00000100140c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe2000001140cULL,
0x0000007000527306ULL, 0x0003e2000020d400ULL, 0x00010000150c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000006c00657306ULL, 0x0004e2000020d400ULL,
0x00000018ff707819ULL, 0x002fce000001141aULL, 0x0000005a00507306ULL, 0x000e62000020d400ULL,
0x00000018ff6c7819ULL, 0x004fce0000011411ULL, 0x0000005100587306ULL, 0x000fe20000209400ULL,
0x0000000165654812ULL, 0x008fe400078efcffULL, 0x000000545600720bULL, 0x000fca0003f9d000ULL,
0x00000051000e7306ULL, 0x000fe20000205400ULL, 0x0000000150501812ULL, 0x002fce00078efcffULL,
0x0000005100557306ULL, 0x000fe2000020d400ULL, 0x0000000108084812ULL, 0x000fce00078efcffULL,
0x00000011004d7306ULL, 0x000ff00000009400ULL, 0x00000011005e7306ULL, 0x000e700000005400ULL,
0x0000004c00517306ULL, 0x000ff00000209400ULL, 0x0000004c005a7306ULL, 0x000fe20000205400ULL,
0x0000005e4d00720bULL, 0x002fce0003fdd000ULL, 0x0000004c00497306ULL, 0x000ff0000020d400ULL,
0x00000070001a7306ULL, 0x000ff00000209400ULL, 0x00000070001b7306ULL, 0x000ff00000205400ULL,
0x00000070004c7306ULL, 0x000ff0000020d400ULL, 0x0000001000597306ULL, 0x000ff00000009400ULL,
0x0000001000707306ULL, 0x000e700000005400ULL, 0x0000000f00667306ULL, 0x000eb0000000d400ULL,
0x0000001000617306ULL, 0x000722000000d400ULL, 0x000000705900720bULL, 0x002fce0003f5d000ULL,
0x0000006b00677306ULL, 0x000fe20000209400ULL, 0x0001000011107824ULL, 0x008fe200078e00ffULL,
0x0000000166660812ULL, 0x004fe400078efcffULL, 0x000000635b00720bULL, 0x000fe20003f1d000ULL,
0x00010000125b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011410ULL,
0x0000006b00697306ULL, 0x000e620000205400ULL, 0x0000000161612812ULL, 0x010fce00078efcffULL,
0x0000006c000f7306ULL, 0x000fe20000209400ULL, 0x0000000152520812ULL, 0x000fce00078efcffULL,
0x0000006c004e7306ULL, 0x000fe20000205400ULL, 0x000000696700720bULL, 0x002fce0003f3d000ULL,
0x0000006c00577306ULL, 0x000ff0000020d400ULL, 0x0000006b00627306ULL, 0x0002b0000020d400ULL,
0x0000007500477306ULL, 0x000fe20000209400ULL, 0x00000100116b7824ULL, 0x002fce00078e00ffULL,
0x00000075006c7306ULL, 0x000fe20000205400ULL, 0x0000000162621812ULL, 0x004fce00078efcffULL,
0x00000075000a7306ULL, 0x0003f0000020d400ULL, 0x00000011005c7306ULL, 0x000ea2000000d400ULL,
0x00000018ff757819ULL, 0x002fce0000011453ULL, 0x0000005d00107306ULL, 0x000ff00000209400ULL,
0x0000005d004d7306ULL, 0x000e620000205400ULL, 0x000000015c5c6812ULL, 0x004fce00078efcffULL,
0x0000001200117306ULL, 0x000ff00000009400ULL, 0x0000001200567306ULL, 0x000ea20000005400ULL,
0x0000004d1000720bULL, 0x002fe20003f5d000ULL, 0x0001000013107824ULL, 0x000fcc00078e00ffULL,
0x0000007500537306ULL, 0x000ff00000209400ULL, 0x0000007500597306ULL, 0x000e620000205400ULL,
0x000000561100720bULL, 0x004fe20003fbd000ULL, 0x0000010012117824ULL, 0x000fca00078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000007500607306ULL, 0x0005f0000020d400ULL,
0x0000005d005e7306ULL, 0x000ee2000020d400ULL, 0x00000018ff757819ULL, 0x004fc4000001146bULL,
0x000000595300720bULL, 0x002fca0003f3d000ULL, 0x00000075006b7306ULL, 0x000ff00000209400ULL,
0x0000007500707306ULL, 0x000e620000205400ULL, 0x000000015e5e2812ULL, 0x008fe400078efcffULL,
0x0000004e0f00720bULL, 0x000fc40003f5d000ULL, 0x0000000160601812ULL, 0x000fe400078efcffULL,
0x000000090b00720bULL, 0x000fe20003f3d000ULL, 0x00000075005d7306ULL, 0x0004f0000020d400ULL,
0x0000001100677306ULL, 0x000fe20000209400ULL, 0x00000018ff757819ULL, 0x004fc4000001145bULL,
0x000000706b00720bULL, 0x002fe40003f1d000ULL, 0x0000000157572812ULL, 0x000fe400078efcffULL,
0x0000000100001812ULL, 0x000fe200078efcffULL, 0x00000075005b7306ULL, 0x000ff00000209400ULL,
0x0000007500637306ULL, 0x000e620000205400ULL, 0x000000015d5d0812ULL, 0x008fc400078efcffULL,
0x0000000e5800720bULL, 0x000fca0003f1d000ULL, 0x0000007500567306ULL, 0x0004f0000020d400ULL,
0x0000001100697306ULL, 0x000f220000205400ULL, 0x00000018ff757819ULL, 0x004fe40000011410ULL,
0x000000635b00720bULL, 0x002fc40003fdd000ULL, 0x0000000155550812ULL, 0x000fe400078efcffULL,
0x0000005a5100720bULL, 0x000fe20003f1d000ULL, 0x0000001100537306ULL, 0x000e62000020d400ULL,
0x00000007035a7812ULL, 0x000fc800078ec0ffULL, 0x000000085a5a7812ULL, 0x000fc600078ef803ULL,
0x0000007500107306ULL, 0x000fe20000209400ULL, 0x0000000156566812ULL, 0x008fe400078efcffULL,
0x000000696700720bULL, 0x010fe40003f5d000ULL, 0x0000000149490812ULL, 0x000fe400078efcffULL,
0x0000003c3d00720bULL, 0x000fe20003f1d000ULL, 0x0000007500117306ULL, 0x000eb00000205400ULL,
0x0000001200547306ULL, 0x000ee2000000d400ULL, 0x0000000153532812ULL, 0x002fc600078efcffULL,
0x0000000107070812ULL, 0x000fe400078efcffULL, 0x000000535555723eULL, 0x000fe400000010ffULL,
0x0000001500127306ULL, 0x000fe20000009400ULL, 0x000000111000720bULL, 0x004fe20003fdd000ULL,
0x0000010013107824ULL, 0x000fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011410ULL,
0x0000001500597306ULL, 0x000e620000005400ULL, 0x0000000154545812ULL, 0x008fc800078efcffULL,
0x000000545654723eULL, 0x000fc600000010ffULL, 0x00000075004d7306ULL, 0x000eb0000020d400ULL,
0x0000005b00107306ULL, 0x000fe20000209400ULL, 0x000000591200720bULL, 0x002fe20003f5d000ULL,
0x000000080d127824ULL, 0x000fca00078e00ffULL, 0xfffffff812197812ULL, 0x000fe200078ee219ULL,
0x0000005b00117306ULL, 0x000e620000205400ULL, 0x000000014d4d6812ULL, 0x004fc600078efcffULL,
0x0000001019127824ULL, 0x000fe400078e0218ULL, 0x0001000016187824ULL, 0x000fe400078e00ffULL,
0x0000005b00517306ULL, 0x0004e6000020d400ULL, 0x00000018ff637819ULL, 0x000fe40000011418ULL,
0x00000004ff187819ULL, 0x000fc60000011603ULL, 0x00000016000e7306ULL, 0x000fe20000009400ULL,
0x000000111000720bULL, 0x002fe20003fdd000ULL, 0x00000002055b7824ULL, 0x044fe200078e0218ULL,
0x0000000205057810ULL, 0x000fca0007ffe0ffULL, 0x00000016000f7306ULL, 0x000e6c0000005400ULL,
0x0000000151516812ULL, 0x008fe400078efcffULL, 0x0000001300097306ULL, 0x000ff00000009400ULL,
0x0000001300707306ULL, 0x000ea20000005400ULL, 0x0000000f0e00720bULL, 0x002fe20003fdd000ULL,
0x000000015a0e7824ULL, 0x140fe200078e025bULL, 0x000000025a5b7810ULL, 0x040fe20007ffe05bULL,
0x000000105a0f7824ULL, 0x000fc800078e00ffULL, 0x00000013004e7306ULL, 0x0002e2000000d400ULL,
0xfffffff00f0f7812ULL, 0x000fca00078ee20eULL, 0x000000100f187824ULL, 0x000fe200078e00ffULL,
0x000000700900720bULL, 0x004fe20003fbd000ULL, 0x000000001210783bULL, 0x002e620000000200ULL,
0x0000001400487306ULL, 0x000eb0000000d400ULL, 0x0000000c00147306ULL, 0x000fe60000209400ULL,
0x000000014e4e5812ULL, 0x008fc400078efcffULL, 0x0000001b1a00720bULL, 0x000fe40003fbd000ULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x0000000c003e7306ULL, 0x000f220000205400ULL,
0x0000000148483812ULL, 0x004fce00078efcffULL, 0x00000015000b7306ULL, 0x000464000000d400ULL,
0x000000014c4c5812ULL, 0x000fe400078efcffULL, 0x0000006c4700720bULL, 0x000fe40003fbd000ULL,
0x000000484c48723eULL, 0x000fe400000010ffULL, 0x0000001600097306ULL, 0x0002e2000000d400ULL,
0x0000010015157824ULL, 0x004fe200078e00ffULL, 0x0000003e1400720bULL, 0x010fc40003f7d000ULL,
0x0000003f4214723eULL, 0x000fe400000010ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000018ff6c7819ULL, 0x002fe20000011411ULL, 0x0000010016167824ULL, 0x000fe200078e00ffULL,
0x0000001500587306ULL, 0x000fe20000209400ULL, 0x00000018ff757819ULL, 0x000fe40000011410ULL,
0x000000010b0b2812ULL, 0x000fe400078efcffULL, 0x000000010a0a5812ULL, 0x000fc400078efcffULL,
0x0000000109096812ULL, 0x008fe200078efcffULL, 0x0000001500597306ULL, 0x000e620000205400ULL,
0x000000541828723cULL, 0x000bee0000041828ULL, 0x00000015000d7306ULL, 0x0004e2000020d400ULL,
0x0000010013557824ULL, 0x020fce00078e00ffULL, 0x0000006c003d7306ULL, 0x000fe20000209400ULL,
0x00000018ff157819ULL, 0x004fe40000011416ULL, 0x000000595800720bULL, 0x002fe40003fbd000ULL,
0x00000018ff557819ULL, 0x000fc60000011455ULL, 0x0000001500697306ULL, 0x000ff00000209400ULL,
0x0000001500677306ULL, 0x000e620000205400ULL, 0x000000010d0d5812ULL, 0x008fc800078efcffULL,
0x0000000d000d723eULL, 0x000fc600000010ffULL, 0x00000015000f7306ULL, 0x0004f0000020d400ULL,
0x0000006c003e7306ULL, 0x000fe20000205400ULL, 0x000000414015723eULL, 0x004fe400000010ffULL,
0x000000676900720bULL, 0x002fca0003f3d000ULL, 0x0000006c003f7306ULL, 0x000fe2000020d400ULL,
0x000000141820723cULL, 0x000bee0000041820ULL, 0x0000001700477306ULL, 0x000fe20000009400ULL,
0x000000444614723eULL, 0x020fe400000010ffULL, 0x000000454315723eULL, 0x000fc400000010ffULL,
0x000000010f0f1812ULL, 0x008fe400078efcffULL, 0x00000018ff457819ULL, 0x000fe20000011413ULL,
0x00000017006c7306ULL, 0x000e620000005400ULL, 0x0000000f070f723eULL, 0x000fe200000010ffULL,
0x000000141834723cULL, 0x000b6c0000041834ULL, 0x00000063006b7306ULL, 0x000fe20000209400ULL,
0x0000004b4a15723eULL, 0x020fe200000010ffULL, 0x0001000017147824ULL, 0x000fc400078e00ffULL,
0x00000100174a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011414ULL,
0x0000006300707306ULL, 0x000fe20000205400ULL, 0x0000006c4700720bULL, 0x002fe40003f9d000ULL,
0x000000686a14723eULL, 0x000fe200000010ffULL, 0x0001000010687824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fc6000001144aULL, 0x00000063000e7306ULL, 0x000fe2000020d400ULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x000000141830723cULL, 0x000b6c0000041830ULL,
0x0000007500167306ULL, 0x000fe20000209400ULL, 0x000000504f15723eULL, 0x020fe200000010ffULL,
0x00000100104f7824ULL, 0x000fe200078e00ffULL, 0x000000666514723eULL, 0x000fc800000010ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000007500637306ULL, 0x000fe40000205400ULL,
0x000000141838723cULL, 0x000b6c0000041838ULL, 0x00000075003c7306ULL, 0x0003e2000020d400ULL,
0x0001000011147824ULL, 0x020fc400078e00ffULL, 0x0000010011157824ULL, 0x000fca00078e00ffULL,
0x0000000c000c7306ULL, 0x000ea2000020d400ULL, 0x00000018ff757819ULL, 0x002fce0000011412ULL,
0x0000007500407306ULL, 0x000ff00000209400ULL, 0x0000007500417306ULL, 0x000fe20000205400ULL,
0x000000010c0c3812ULL, 0x004fe400078efcffULL, 0x000000706b00720bULL, 0x000fc40003f7d000ULL,
0x0000000b0c0c723eULL, 0x000fc600000010ffULL, 0x0000007500427306ULL, 0x000ff0000020d400ULL,
0x0000001700477306ULL, 0x000e62000000d400ULL, 0x000000010e0e3812ULL, 0x000fe400078efcffULL,
0x000000631600720bULL, 0x000fc40003f7d000ULL, 0x000000090e0e723eULL, 0x000fc600000010ffULL,
0x0000001000757306ULL, 0x000ff00000009400ULL, 0x0000001000177306ULL, 0x000ea20000005400ULL,
0x000000013c3c3812ULL, 0x000fe400078efcffULL, 0x0000005f6400720bULL, 0x000fc40003f7d000ULL,
0x0000000147474812ULL, 0x002fc600078efcffULL, 0x0000001100707306ULL, 0x000fe20000009400ULL,
0x000000177500720bULL, 0x004fce0003f5d000ULL, 0x0000006a006c7306ULL, 0x000fe20000209400ULL,
0x0000000106063812ULL, 0x000fce00078efcffULL, 0x0000001100757306ULL, 0x000e700000005400ULL,
0x0000006a006b7306ULL, 0x000ff00000205400ULL, 0x0000006a004a7306ULL, 0x000fe2000020d400ULL,
0x000000757000720bULL, 0x002fc40003fbd000ULL, 0x00000018ff707819ULL, 0x000fe40000011414ULL,
0x00000018ff757819ULL, 0x000fe40000011415ULL, 0x000000616214723eULL, 0x000fe200000010ffULL,
0x00000010004b7306ULL, 0x000e62000000d400ULL, 0x000000605215723eULL, 0x000fce00000010ffULL,
0x0000006800177306ULL, 0x000fe20000209400ULL, 0x00000014182c723cULL, 0x000b6e000004182cULL,
0x00000068006a7306ULL, 0x000ea20000205400ULL, 0x0000005c5e14723eULL, 0x020fe400000010ffULL,
0x0000005d5715723eULL, 0x000fe200000010ffULL, 0x0001000012577824ULL, 0x000fe200078e00ffULL,
0x000000014b4b2812ULL, 0x002fc600078efcffULL, 0x0000006800107306ULL, 0x000e62000020d400ULL,
0x00000018ff677819ULL, 0x000fe20000011457ULL, 0x000000141824723cULL, 0x000b6c0000041824ULL,
0x0000004f00657306ULL, 0x000fe20000209400ULL, 0x0000006a1700720bULL, 0x004fe20003fdd000ULL,
0x000000105a147824ULL, 0x020fca00078e00ffULL, 0xfffffff0145b7812ULL, 0x000fe200078ee25bULL,
0x0000004f00687306ULL, 0x000ea80000205400ULL, 0x000000105b147824ULL, 0x000fe400078e00ffULL,
0x0000000110106812ULL, 0x002fe200078efcffULL, 0x00000100125b7824ULL, 0x000fe200078e00ffULL,
0x0000004f004f7306ULL, 0x000e70000020d400ULL, 0x0000004600587306ULL, 0x000fe20000209400ULL,
0x000000686500720bULL, 0x004fce0003f1d000ULL, 0x0000004600597306ULL, 0x000eac0000205400ULL,
0x000000014f4f0812ULL, 0x002fe400078efcffULL, 0x0000007000667306ULL, 0x000fe40000209400ULL,
0x0000004f3c07723eULL, 0x000fcc00000010ffULL, 0x0000007000617306ULL, 0x000e620000205400ULL,
0x000000595800720bULL, 0x004fce0003f1d000ULL, 0x0000001200637306ULL, 0x000ff00000009400ULL,
0x0000001200167306ULL, 0x000ea20000005400ULL, 0x000000616600720bULL, 0x002fe20003fdd000ULL,
0x0001000013617824ULL, 0x000fcc00078e00ffULL, 0x0000004600467306ULL, 0x000e70000020d400ULL,
0x0000001100507306ULL, 0x000ee2000000d400ULL, 0x000000166300720bULL, 0x004fe40003f3d000ULL,
0x000000001414783bULL, 0x000eaa0000000200ULL, 0x0000007000117306ULL, 0x000f22000020d400ULL,
0x0000000146460812ULL, 0x002fc400078efcffULL, 0x0000003e3d00720bULL, 0x000fe40003f1d000ULL,
0x000000474646723eULL, 0x000fc600000010ffULL, 0x0000007500627306ULL, 0x000fe20000209400ULL,
0x0000000150505812ULL, 0x008fce00078efcffULL, 0x0000007500607306ULL, 0x000e620000205400ULL,
0x0000000111116812ULL, 0x010fe400078efcffULL, 0x0000006b6c00720bULL, 0x000fe40003fdd000ULL,
0x000000013f3f0812ULL, 0x000fe400078efcffULL, 0x00000050113e723eULL, 0x000fe200000010ffULL,
0x00000067005c7306ULL, 0x000ff00000209400ULL, 0x00000067005d7306ULL, 0x000ee20000205400ULL,
0x000000606200720bULL, 0x002fc40003f9d000ULL, 0x000000014a4a6812ULL, 0x000fe200078efcffULL,
0x0000000c1434723cULL, 0x004fe20000041834ULL, 0x000000414000720bULL, 0x000fe40003fdd000ULL,
0x0000004a0647723eULL, 0x000fe200000010ffULL, 0x00000012005a7306ULL, 0x0002a2000000d400ULL,
0x0000004b1006723eULL, 0x000fc600000010ffULL, 0x0000000e1430723cULL, 0x040fe80000041830ULL,
0x00000013005e7306ULL, 0x000fe20000009400ULL, 0x0000004e4d12723eULL, 0x002fe400000010ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011461ULL, 0x000000461438723cULL, 0x000fe20000041838ULL,
0x0000005d5c00720bULL, 0x008fe40003f7d000ULL, 0x0000000142426812ULL, 0x000fe200078efcffULL,
0x0000001300637306ULL, 0x000e620000005400ULL, 0x000000015a5a1812ULL, 0x004fc600078efcffULL,
0x00000006142c723cULL, 0x000fe8000004182cULL, 0x0000001300547306ULL, 0x0005f0000000d400ULL,
0x0000006700577306ULL, 0x000722000020d400ULL, 0x000000514913723eULL, 0x004fc400000010ffULL,
0x0000000a0849723eULL, 0x000fe400000010ffULL, 0x000000635e00720bULL, 0x002fc60003f5d000ULL,
0x0000004e004d7306ULL, 0x000fe20000209400ULL, 0x00000018ff677819ULL, 0x008fe2000001145bULL,
0x00000012181c723cULL, 0x000f6c000004181cULL, 0x0000004e00087306ULL, 0x000e620000205400ULL,
0x0000000157573812ULL, 0x010fe200078efcffULL, 0x000000481420723cULL, 0x000b620000041820ULL,
0x0000000154542812ULL, 0x000fca00078efcffULL, 0x0000007500527306ULL, 0x000eb0000020d400ULL,
0x0000004500437306ULL, 0x000fe20000209400ULL, 0x000000084d00720bULL, 0x002fce0003f1d000ULL,
0x0000004500447306ULL, 0x000e620000205400ULL, 0x0000000152524812ULL, 0x004fc800078efcffULL,
0x000000523f3f723eULL, 0x000fe400000010ffULL, 0x0000005a5752723eULL, 0x000fe200000010ffULL,
0x00000067005b7306ULL, 0x000fe80000209400ULL, 0x0000003e1424723cULL, 0x000b680000041824ULL,
0x0000006700567306ULL, 0x000ea20000205400ULL, 0x000000444300720bULL, 0x002fce0003fbd000ULL,
0x0000005500007306ULL, 0x000ff00000209400ULL, 0x00000055000b7306ULL, 0x000e620000205400ULL,
0x000000565b00720bULL, 0x004fce0003f9d000ULL, 0x0000004e00097306ULL, 0x000eb0000020d400ULL,
0x0000004500457306ULL, 0x000ee2000020d400ULL, 0x0000000b0000720bULL, 0x002fce0003f7d000ULL,
0x0000006700537306ULL, 0x000e62000020d400ULL, 0x0000000109090812ULL, 0x004fe400078efcffULL,
0x000000080500780cULL, 0x000fe40003f05270ULL, 0x000000540944723eULL, 0x000fc600000010ffULL,
0x0000005500087306ULL, 0x000ea2000020d400ULL, 0x0000000145455812ULL, 0x008fe400078efcffULL,
0x0000000153534812ULL, 0x002fc800078efcffULL, 0x000000534253723eULL, 0x000fe400000010ffULL,
0x0000000108083812ULL, 0x004fca00078efcffULL, 0x000000521428723cULL, 0x000b620000041828ULL,
0x000000084545723eULL, 0x000fce00000010ffULL, 0x00000044141c723cULL, 0x020b62000004181cULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffe11000007947ULL, 0x000fcc000383ffffULL,
0x0000000431317220ULL, 0x080fe40000410000ULL, 0x000000042c2c7220ULL, 0x080fe40000410000ULL,
0x000000042d2d7220ULL, 0x080fe40000410000ULL, 0x0000000420207220ULL, 0x080fe40000410000ULL,
0x0000000434347220ULL, 0x080fe40000410000ULL, 0x0000000435357220ULL, 0x000fc40000410000ULL,
0x0000000438387220ULL, 0x080fe40000410000ULL, 0x0000000439397220ULL, 0x080fe40000410000ULL,
0x0000000424247220ULL, 0x080fe40000410000ULL, 0x0000000428007220ULL, 0x080fe40000410000ULL,
0x0000000429057220ULL, 0x080fe40000410000ULL, 0x000000042f097220ULL, 0x000fc40000410000ULL,
0x000000042a157220ULL, 0x0a0fe40000410000ULL, 0x0000000423087220ULL, 0x080fe40000410000ULL,
0x00000004301b7220ULL, 0x080fe40000410000ULL, 0x000000042e127220ULL, 0x080fe40000410000ULL,
0x00000004271a7220ULL, 0x080fe40000410000ULL, 0x000000042b167220ULL, 0x000fc40000410000ULL,
0x000000041d147220ULL, 0x080fe40000410000ULL, 0x000000041f187220ULL, 0x080fe40000410000ULL,
0x000000ffff287224ULL, 0x000fe400078e0031ULL, 0x000000ffff2f7224ULL, 0x000fe400078e002cULL,
0x000000ffff2a7224ULL, 0x000fe400078e002dULL, 0x0000000421217220ULL, 0x000fc40000410000ULL,
0x0000000422227220ULL, 0x080fe40000410000ULL, 0x0000000436367220ULL, 0x080fe40000410000ULL,
0x0000000437377220ULL, 0x080fe40000410000ULL, 0x0000000432327220ULL, 0x080fe40000410000ULL,
0x0000000433337220ULL, 0x080fe40000410000ULL, 0x000000043a3a7220ULL, 0x000fc40000410000ULL,
0x000000043b307220ULL, 0x080fe40000410000ULL, 0x00000004252e7220ULL, 0x080fe40000410000ULL,
0x0000000426137220ULL, 0x080fe40000410000ULL, 0x000000041c277220ULL, 0x080fe40000410000ULL,
0x000000041e177220ULL, 0x000fe40000410000ULL, 0x000000ffff237224ULL, 0x000fc400078e0020ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0034ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0035ULL,
0x000000ffff297224ULL, 0x000fe400078e0038ULL, 0x000000ffff317224ULL, 0x000fe400078e0039ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0024ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000007c067f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fe400078e0008ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0036ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0037ULL,
0x000000ffff257224ULL, 0x000fe400078e0032ULL, 0x000000ffff247224ULL, 0x000fc400078e0033ULL,
0x000000ffff267224ULL, 0x000fe400078e003aULL, 0x000000ffff057224ULL, 0x000fc400078e0009ULL,
0x0000000000087805ULL, 0x002fca0000015200ULL, 0x000004007c0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x006fe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140bULL, 0x0000000d00007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004007c0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403197824ULL, 0x000fe200078e00ffULL,
0x000000786e00720cULL, 0x000fc80003f06070ULL, 0xfffffff019077812ULL, 0x000fca00078ec0ffULL,
0x0000008002007824ULL, 0x000fca00078e0207ULL, 0x0174000000087984ULL, 0x0002a20000000c00ULL,
0x0000136000008947ULL, 0x000fea0003800000ULL, 0x0000000203337824ULL, 0x000fe200078e00ffULL,
0xffffff006f067810ULL, 0x000fe20007ffe0ffULL, 0x00000002ff457424ULL, 0x000fe200078e00ffULL,
0x0000007403077211ULL, 0x000fe400078ff0ffULL, 0x0000000677357217ULL, 0x000fe40007800000ULL,
0x0000000633337812ULL, 0x000fc600078ec0ffULL, 0x0000000135357824ULL, 0x000fe200078e0a06ULL,
0x0000580033327a10ULL, 0x000fe20007ffe0ffULL, 0x00000001720c7824ULL, 0x000fe200078e0233ULL,
0x00005a00ff067a19ULL, 0x000fe40000011607ULL, 0x0000000807077810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0e7824ULL, 0x140fe200078e0a35ULL, 0x000000350c00720cULL, 0x000fe20003f26070ULL,
0x00000001320c7824ULL, 0x000fe200078e0a35ULL, 0x000000067b067217ULL, 0x040fe40003800000ULL,
0x0000000e7b0e7217ULL, 0x000fc40003800000ULL, 0x0000001033367812ULL, 0x000fe200078efcffULL,
0x0000000673507224ULL, 0x000fe200078e02ffULL, 0x00005a00ff107a19ULL, 0x000fe40000011607ULL,
0x000000353200720cULL, 0x000fe40003f06070ULL, 0x0000000c7b0c7217ULL, 0x000fe40003800000ULL,
0x00000004ff0e7819ULL, 0x000fe4000001160eULL, 0x00005800363a7a10ULL, 0x000fc40007ffe0ffULL,
0x000000107b4e7217ULL, 0x000fe40003800000ULL, 0x000000ff0c387207ULL, 0x000fe40000000000ULL,
0x000000ff0e077207ULL, 0x000fe20000800000ULL, 0x0000000172407824ULL, 0x000fe200078e0236ULL,
0x0000005038107211ULL, 0x000fe200078fe0ffULL, 0x000000013a3e7824ULL, 0x000fe400078e0a35ULL,
0x0000004e734e7224ULL, 0x000fe400078e02ffULL, 0x00000001500e7824ULL, 0x000fe200078e0207ULL,
0x0000003e7b3b7217ULL, 0x000fe20003800000ULL, 0x0000000140427824ULL, 0x000fe200078e0a35ULL,
0x0000004e380c7211ULL, 0x000fe200078fe0ffULL, 0x0000600010107625ULL, 0x000fe200078e0045ULL,
0x00000020333e7812ULL, 0x000fc600078efcffULL, 0x000060000e0e7625ULL, 0x000fe200078e0045ULL,
0x000000427b427217ULL, 0x000fe20003800000ULL, 0x0000000810377981ULL, 0x000722000c1e9500ULL,
0x000000353a00720cULL, 0x080fe40003f06070ULL, 0x000000354000720cULL, 0x000fe20003f26070ULL,
0x000000080e347981ULL, 0x000322000c1e9500ULL, 0x000058003e407a10ULL, 0x000fe20007ffe0ffULL,
0x000060000c0c7625ULL, 0x000fe200078e0045ULL, 0x00000004ff427819ULL, 0x000fe40000011642ULL,
0x000000ff3b3b7207ULL, 0x000fe20000000000ULL, 0x0000000107067824ULL, 0x000fe200078e024eULL,
0x000000080c397981ULL, 0x000522000c1e9500ULL, 0x0000000140467824ULL, 0x000fc400078e0a35ULL,
0x0000600006067625ULL, 0x000fe200078e0045ULL, 0x000000ff420f7207ULL, 0x002fe40000800000ULL,
0x000000354000720cULL, 0x000fe20003f06070ULL, 0x0000000172487824ULL, 0x000fe200078e023eULL,
0x000000503b0c7211ULL, 0x004fe200078fe0ffULL, 0x00000008063c7981ULL, 0x0002a2000c1e9500ULL,
0x000000467b467217ULL, 0x000fe20003800000ULL, 0x00000001500e7824ULL, 0x000fe400078e020fULL,
0x00000001484a7824ULL, 0x000fe200078e0a35ULL, 0x000000ff46477207ULL, 0x000fe20000000000ULL,
0x000060000c067625ULL, 0x002fe200078e0045ULL, 0x0000003033467812ULL, 0x000fc600078efcffULL,
0x000060000e0c7625ULL, 0x000fe200078e0045ULL, 0x0000004e3b0e7211ULL, 0x000fe200078fe0ffULL,
0x00000008063d7981ULL, 0x0002a2000c1e9500ULL, 0x0000004a7b4a7217ULL, 0x000fe20003800000ULL,
0x000000010f107824ULL, 0x008fe200078e024eULL, 0x000000354800720cULL, 0x000fe20003f26070ULL,
0x0000000172527824ULL, 0x000fe200078e0246ULL, 0x00000004ff4a7819ULL, 0x000fe2000001164aULL,
0x000060000e0e7625ULL, 0x000fe200078e0045ULL, 0x000000080c427981ULL, 0x0006a2000c1e9500ULL,
0x0000005047067211ULL, 0x002fc400078fe0ffULL, 0x0000600010107625ULL, 0x080fe200078e0045ULL,
0x0000580046487a10ULL, 0x000fe20007ffe0ffULL, 0x000000080e3f7981ULL, 0x0002a4000c1e9500ULL,
0x0000600006067625ULL, 0x000fe200078e0045ULL, 0x000000ff4a437207ULL, 0x000fe20000800000ULL,
0x0000000810447981ULL, 0x0002a4000c1e9500ULL, 0x0000000152547824ULL, 0x000fe400078e0a35ULL,
0x0000000806417981ULL, 0x0002a2000c1e9500ULL, 0x00000001500c7824ULL, 0x008fe200078e0243ULL,
0x0000004e470e7211ULL, 0x002fc400078fe0ffULL, 0x000000547b547217ULL, 0x000fe20003800000ULL,
0x0000000143107824ULL, 0x000fe400078e024eULL, 0x0000000148067824ULL, 0x040fe200078e0a35ULL,
0x000000354800720cULL, 0x000fe20003f06070ULL, 0x000060000c0c7625ULL, 0x000fe200078e0045ULL,
0x000000355200720cULL, 0x000fe40003f26070ULL, 0x000000067b067217ULL, 0x000fe20003800000ULL,
0x000060000e0e7625ULL, 0x080fe200078e0045ULL, 0x00000004ff547819ULL, 0x000fe20000011654ULL,
0x000000080c4a7981ULL, 0x0002e4000c1e9500ULL, 0x0000600010107625ULL, 0x000fe200078e0045ULL,
0x000000ff06497207ULL, 0x000fe20000000000ULL, 0x000000080e437981ULL, 0x0002e2000c1e9500ULL,
0x000000ff544b7207ULL, 0x000fc60000800000ULL, 0x00000008104c7981ULL, 0x0002e2000c1e9500ULL,
0x0000005049067211ULL, 0x000fe200078fe0ffULL, 0x00000001500c7824ULL, 0x002fc800078e024bULL,
0x0000600006067625ULL, 0x000fc800078e0045ULL, 0x000060000c0c7625ULL, 0x000fe400078e0045ULL,
0x0000000806067981ULL, 0x0002e2000c1e9500ULL, 0x0000004e490e7211ULL, 0x000fc600078fe0ffULL,
0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL, 0x000000014b107824ULL, 0x000fe400078e024eULL,
0x000060000e0e7625ULL, 0x000fc800078e0045ULL, 0x0000600010107625ULL, 0x000fe400078e0045ULL,
0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL, 0x0000000810117981ULL, 0x0002e2000c1e9500ULL,
0x0000000133667812ULL, 0x040fe400078efcffULL, 0xfffffff0380f7812ULL, 0x002fe400078ec0ffULL,
0x0000000833647812ULL, 0x000fc400078efcffULL, 0x0000000933627812ULL, 0x000fe200078efcffULL,
0x00000001350f7824ULL, 0x000fe200078e020fULL, 0x00005800666c7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001ff457424ULL, 0x000fe200078e00ffULL, 0x00005800646a7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580062687a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff03b4d7812ULL, 0x000fe200078ec0ffULL,
0x00000001323b7824ULL, 0x100fe200078e0a0fULL, 0xfffffff0474f7812ULL, 0x000fe200078ec0ffULL,
0x000000016c477824ULL, 0x100fe200078e0a0fULL, 0xfffffff0495b7812ULL, 0x000fe200078ec0ffULL,
0x000000016a497824ULL, 0x000fc400078e0a0fULL, 0x00000001684b7824ULL, 0x000fe200078e0a0fULL,
0x0000003b450f7219ULL, 0x000fe400000006ffULL, 0x0000001833587812ULL, 0x000fe400078efcffULL,
0x00000049453b7219ULL, 0x040fe400000006ffULL, 0x0000004b45497219ULL, 0x000fe200000006ffULL,
0x00000001354d7824ULL, 0x000fe200078e024dULL, 0x00005800585e7a10ULL, 0x000fc60007ffe0ffULL,
0x000000013a577824ULL, 0x100fe400078e0a4dULL, 0x000000015e597824ULL, 0x000fe200078e0a4dULL,
0x00000011335a7812ULL, 0x040fe400078efcffULL, 0x0000001933567812ULL, 0x000fe400078efcffULL,
0x0000004745477219ULL, 0x040fe400000006ffULL, 0x0000005745577219ULL, 0x040fe400000006ffULL,
0x0000005945597219ULL, 0x000fe200000006ffULL, 0x00000001354f7824ULL, 0x000fe200078e024fULL,
0x000058005a607a10ULL, 0x000fc40007ffe0ffULL, 0x00005800565c7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001405f7824ULL, 0x000fe400078e0a4fULL, 0x0000000160557824ULL, 0x100fe400078e0a4dULL,
0x000000015c5d7824ULL, 0x000fe200078e0a4dULL, 0x0000002133547812ULL, 0x040fe400078efcffULL,
0x0000002833527812ULL, 0x040fe400078efcffULL, 0x0000002933507812ULL, 0x000fc400078efcffULL,
0x0000005545557219ULL, 0x040fe400000006ffULL, 0x0000005d455d7219ULL, 0x040fe400000006ffULL,
0x0000005f455f7219ULL, 0x000fe200000006ffULL, 0x00000001355b7824ULL, 0x000fe200078e025bULL,
0x0000580054077a10ULL, 0x000fe40007ffe0ffULL, 0x0000580052707a10ULL, 0x000fe40007ffe0ffULL,
0x0000580050387a10ULL, 0x000fe20007ffe0ffULL, 0x0000000107617824ULL, 0x000fc400078e0a4fULL,
0x0000000170637824ULL, 0x100fe400078e0a4fULL, 0x0000000138657824ULL, 0x000fe400078e0a4fULL,
0x0000000148677824ULL, 0x000fe200078e0a5bULL, 0x00000031334e7812ULL, 0x040fe400078efcffULL,
0x0000003833107812ULL, 0x040fe400078efcffULL, 0x00000039330c7812ULL, 0x000fe400078efcffULL,
0x0000006145617219ULL, 0x000fc400000006ffULL, 0x0000006345637219ULL, 0x040fe400000006ffULL,
0x0000006545657219ULL, 0x040fe400000006ffULL, 0x0000006745677219ULL, 0x000fe400000006ffULL,
0x000058004e4b7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800104d7a10ULL, 0x000fe40007ffe0ffULL,
0x000058000c4f7a10ULL, 0x000fe20007ffe0ffULL, 0x000000014b517824ULL, 0x000fc400078e0a5bULL,
0x000000014d537824ULL, 0x100fe400078e0a5bULL, 0x000000014f5b7824ULL, 0x000fe200078e0a5bULL,
0x0000005145517219ULL, 0x040fe400000006ffULL, 0x0000005345537219ULL, 0x040fe400000006ffULL,
0x0000005b455b7219ULL, 0x000fe400000006ffULL, 0x0000541037347816ULL, 0x010fc80000000034ULL,
0x000000340fff7212ULL, 0x000fc8000780c0ffULL, 0x000000353200720cULL, 0x000fc80000701470ULL,
0x000000353300720cULL, 0x000fe40000701070ULL, 0x00005410393c7816ULL, 0x004fe4000000003cULL,
0xff80000023237808ULL, 0x000fe40000000000ULL, 0x0000003c0fff7212ULL, 0x080fe4000788c0ffULL,
0x0000003c3bff7212ULL, 0x080fe400078cc0ffULL, 0x0000003c49ff7212ULL, 0x000fc4000780c0ffULL,
0x000000353200720cULL, 0x080fe40002781470ULL, 0x000000356a00720cULL, 0x080fe400037c1470ULL,
0x000000356800720cULL, 0x080fe40000701470ULL, 0x0000003449ff7212ULL, 0x000fe4000782c0ffULL,
0x000000353300720cULL, 0x080fe40002781070ULL, 0x000000356400720cULL, 0x000fc400037c1070ULL,
0x000000356200720cULL, 0x080fe40000701070ULL, 0x000054103d427816ULL, 0x000fe40000000042ULL,
0x000000356800720cULL, 0x000fe40000f21470ULL, 0xff80000022227808ULL, 0x000fe40002000000ULL,
0xff8000001e1e7808ULL, 0x000fe40003000000ULL, 0x000054103f447816ULL, 0x000fc40000000044ULL,
0xff8000001c1c7808ULL, 0x000fe40000000000ULL, 0x0000003447ff7212ULL, 0x080fe4000786c0ffULL,
0x000000343bff7212ULL, 0x000fe4000784c0ffULL, 0x0000003c47ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004257ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004457ff7212ULL, 0x000fc400078cc0ffULL,
0x0000004459ff7212ULL, 0x000fe4000780c0ffULL, 0x000000356200720cULL, 0x080fe40000f21070ULL,
0x000000356c00720cULL, 0x0c0fe40001f61470ULL, 0x000000356c00720cULL, 0x080fe40002fa1470ULL,
0x000000356a00720cULL, 0x080fe40001741470ULL, 0x000000353a00720cULL, 0x000fc40002781470ULL,
0x000000353a00720cULL, 0x080fe400037c1470ULL, 0x000000355e00720cULL, 0x080fe40000701470ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0x000000356600720cULL, 0x0c0fe40001f61070ULL,
0x000000356600720cULL, 0x080fe40002fa1070ULL, 0x000000356400720cULL, 0x000fc40001741070ULL,
0x000000353600720cULL, 0x0c0fe40002721070ULL, 0x000000353600720cULL, 0x080fe400037c1070ULL,
0x000000355800720cULL, 0x000fe40000701070ULL, 0x00005410414a7816ULL, 0x008fe4000000004aULL,
0x00005410434c7816ULL, 0x000fe4000000004cULL, 0xff80000021217808ULL, 0x000fc40001800000ULL,
0xff80000020207808ULL, 0x000fe40002800000ULL, 0xff8000001f1f7808ULL, 0x000fe40001000000ULL,
0xff8000001b1b7808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40000000000ULL, 0x0000004255ff7212ULL, 0x000fc4000786c0ffULL,
0x0000004259ff7212ULL, 0x080fe400078ac0ffULL, 0x000000425dff7212ULL, 0x000fe4000784c0ffULL,
0x0000004455ff7212ULL, 0x080fe4000788c0ffULL, 0x000000445dff7212ULL, 0x000fe4000782c0ffULL,
0x0000004a5fff7212ULL, 0x040fe400078cc0ffULL, 0x0000004c5fff7212ULL, 0x000fc4000780c0ffULL,
0x000000356000720cULL, 0x0c0fe40001f61470ULL, 0x000000356000720cULL, 0x080fe40002781470ULL,
0x000000355e00720cULL, 0x080fe40002fa1470ULL, 0x000000355c00720cULL, 0x0c0fe40001741470ULL,
0x000000355c00720cULL, 0x080fe40000f21470ULL, 0x000000354000720cULL, 0x000fc400037c1470ULL,
0x000000354000720cULL, 0x080fe40000701470ULL, 0x000000355a00720cULL, 0x0c0fe40001f61070ULL,
0x000000355a00720cULL, 0x080fe40002781070ULL, 0x000000355800720cULL, 0x080fe40002fa1070ULL,
0x000000355600720cULL, 0x0c0fe40001741070ULL, 0x000000355600720cULL, 0x000fc40000f21070ULL,
0x000000353e00720cULL, 0x0c0fe400037c1070ULL, 0x000000353e00720cULL, 0x000fe40000701070ULL,
0x0000541006067816ULL, 0x000fe4000000000dULL, 0xff80000028287808ULL, 0x000fe40001800000ULL,
0xff80000024247808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fc40002800000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff8000002f2f7808ULL, 0x000fe40003000000ULL, 0xff80000012127808ULL, 0x000fe40000000000ULL,
0x0000004a61ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004a63ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004a65ff7212ULL, 0x000fe400078ac0ffULL, 0x0000004c61ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004c63ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004c65ff7212ULL, 0x000fe400078cc0ffULL,
0x0000000667ff7212ULL, 0x000fe4000780c0ffULL, 0x000000350700720cULL, 0x000fc40001f61470ULL,
0x000000350700720cULL, 0x080fe40001741470ULL, 0x000000357000720cULL, 0x0c0fe40002781470ULL,
0x000000357000720cULL, 0x080fe40000f21470ULL, 0x000000353800720cULL, 0x0c0fe40002fa1470ULL,
0x000000353800720cULL, 0x080fe400037c1470ULL, 0x000000354800720cULL, 0x000fc40000701470ULL,
0x000000355400720cULL, 0x0c0fe40001f61070ULL, 0x000000355400720cULL, 0x080fe40001741070ULL,
0x000000355200720cULL, 0x0c0fe40002781070ULL, 0x000000355200720cULL, 0x080fe40000f21070ULL,
0x000000355000720cULL, 0x0c0fe40002fa1070ULL, 0x000000355000720cULL, 0x000fc400037c1070ULL,
0x000000354600720cULL, 0x000fe40000701070ULL, 0x000054100e0e7816ULL, 0x000fe40000000011ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff80000005057808ULL, 0x000fe40001000000ULL,
0xff8000002b2b7808ULL, 0x000fe40002000000ULL, 0xff80000013137808ULL, 0x000fc40000800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002800000ULL, 0xff8000001a1a7808ULL, 0x000fe40003000000ULL,
0xff8000002d2d7808ULL, 0x000fe40000000000ULL, 0x0000000651ff7212ULL, 0x080fe4000786c0ffULL,
0x0000000653ff7212ULL, 0x080fe4000784c0ffULL, 0x000000065bff7212ULL, 0x000fc4000788c0ffULL,
0x0000000e67ff7212ULL, 0x080fe4000782c0ffULL, 0x0000000e51ff7212ULL, 0x080fe400078ac0ffULL,
0x0000000e53ff7212ULL, 0x080fe400078cc0ffULL, 0x0000000e5bff7212ULL, 0x000fe4000780c0ffULL,
0x000000354800720cULL, 0x080fe40000f21470ULL, 0x000000354b00720cULL, 0x000fc40001f61470ULL,
0x000000354b00720cULL, 0x080fe40002fa1470ULL, 0x000000354d00720cULL, 0x0c0fe40001741470ULL,
0x000000354d00720cULL, 0x080fe400037c1470ULL, 0x000000354f00720cULL, 0x0c0fe40002781470ULL,
0x000000354f00720cULL, 0x080fe40000701470ULL, 0x000000354600720cULL, 0x000fc40000f21070ULL,
0x000000354e00720cULL, 0x0c0fe40001f61070ULL, 0x000000354e00720cULL, 0x080fe40002fa1070ULL,
0x000000351000720cULL, 0x0c0fe40001741070ULL, 0x000000351000720cULL, 0x080fe400037c1070ULL,
0x000000350c00720cULL, 0x0c0fe40002781070ULL, 0x000000350c00720cULL, 0x000fc40000701070ULL,
0xff8000002c2c7808ULL, 0x000fe40001800000ULL, 0xff80000027277808ULL, 0x000fe40001000000ULL,
0xff80000014147808ULL, 0x000fe40002000000ULL, 0xff80000015157808ULL, 0x000fe40000800000ULL,
0xff80000016167808ULL, 0x000fe40002800000ULL, 0xff80000017177808ULL, 0x000fc40003000000ULL,
0xff80000018187808ULL, 0x000fc40000000000ULL, 0x000000230800720bULL, 0x004fe40003f1e000ULL,
0x000000220900720bULL, 0x000fe40003f3e000ULL, 0x0000000823087208ULL, 0x000fe40004000000ULL,
0x0000000922097208ULL, 0x000fe40004800000ULL, 0x000000210800720bULL, 0x000fe40003f1e000ULL,
0x000000200900720bULL, 0x000fc40003f3e000ULL, 0x0000000821087208ULL, 0x000fe40004000000ULL,
0x0000000920097208ULL, 0x000fe40004800000ULL, 0x0000001f0800720bULL, 0x000fe40003f1e000ULL,
0x0000001e0900720bULL, 0x000fe40003f3e000ULL, 0x000000081f087208ULL, 0x000fe40004000000ULL,
0x000000091e097208ULL, 0x000fc40004800000ULL, 0x0000001d0800720bULL, 0x000fe40003f1e000ULL,
0x0000001c0900720bULL, 0x000fe40003f3e000ULL, 0x000000081d087208ULL, 0x000fe40004000000ULL,
0x000000091c067208ULL, 0x000fe40004800000ULL, 0x0000001b0800720bULL, 0x000fe40003f1e000ULL,
0x000000250600720bULL, 0x000fc40003f3e000ULL, 0x000000081b077208ULL, 0x000fe40004000000ULL,
0x0000000625097208ULL, 0x000fe40004800000ULL, 0x000000280700720bULL, 0x000fe40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x0000000728067208ULL, 0x000fe40004000000ULL,
0x0000000924097208ULL, 0x000fc40004800000ULL, 0x000000290600720bULL, 0x000fe40003f1e000ULL,
0x000000260900720bULL, 0x000fe40003f3e000ULL, 0x0000000629067208ULL, 0x000fe40004000000ULL,
0x0000000926097208ULL, 0x000fe40004800000ULL, 0x000000310600720bULL, 0x000fe40003f1e000ULL,
0x000000300900720bULL, 0x000fc40003f3e000ULL, 0x0000000631067208ULL, 0x000fe40004000000ULL,
0x0000000930097208ULL, 0x000fe40004800000ULL, 0x0000002f0600720bULL, 0x000fe40003f1e000ULL,
0x000000120900720bULL, 0x000fe40003f3e000ULL, 0x000000062f077208ULL, 0x000fe40004000000ULL,
0x0000000912067208ULL, 0x000fc40004800000ULL, 0x0000002a0700720bULL, 0x000fe40003f1e000ULL,
0x000000050600720bULL, 0x000fe40003f3e000ULL, 0x000000072a087208ULL, 0x000fe40004000000ULL,
0x0000000605067208ULL, 0x000fe40004800000ULL, 0x0000002b0800720bULL, 0x000fe40003f1e000ULL,
0x000000130600720bULL, 0x000fc40003f3e000ULL, 0x000000082b077208ULL, 0x000fe40004000000ULL,
0x0000000613097208ULL, 0x000fe40004800000ULL, 0x0000002e0700720bULL, 0x000fe40003f1e000ULL,
0x0000001a0900720bULL, 0x000fe40003f3e000ULL, 0x000000072e067208ULL, 0x000fe40004000000ULL,
0x000000091a087208ULL, 0x000fc40004800000ULL, 0x0000002d0600720bULL, 0x000fe40003f1e000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x000000062d077208ULL, 0x000fe40004000000ULL,
0x0000000815097208ULL, 0x000fe40004800000ULL, 0x0000002c0700720bULL, 0x000fe40003f1e000ULL,
0x000000160900720bULL, 0x000fc40003f3e000ULL, 0x000000072c067208ULL, 0x000fe40004000000ULL,
0x0000000916087208ULL, 0x000fe40004800000ULL, 0x000000270600720bULL, 0x000fe40003f1e000ULL,
0x000000170800720bULL, 0x000fe40003f3e000ULL, 0x0000000627077208ULL, 0x000fe40004000000ULL,
0x0000000817097208ULL, 0x000fc40004800000ULL, 0x000000140700720bULL, 0x000fe40003f1e000ULL,
0x000000180900720bULL, 0x000fe40003f3e000ULL, 0x00000007140e7208ULL, 0x000fe40004000000ULL,
0x0000000918107208ULL, 0x000fe20004800000ULL, 0x000017327f007947ULL, 0x000fec000b800000ULL,
0x0c401f000e067f89ULL, 0x0004e400000e0000ULL, 0x000000060e00720bULL, 0x008fc80003f1e000ULL,
0x0000000e06327208ULL, 0x000fe20004000000ULL, 0x000017627f007947ULL, 0x000fea000b800000ULL,
0x0c401f0010067f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a077f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b087f89ULL, 0x000e6800000e0000ULL, 0x0c201f0032097f89ULL, 0x000ea200000e0000ULL,
0x000000061000720bULL, 0x008fc40003f1e000ULL, 0x000000070a00720bULL, 0x010fe40003f3e000ULL,
0x00000010060c7208ULL, 0x000fe40004000000ULL, 0x0000000a070d7208ULL, 0x000fe40004800000ULL,
0x000000080b00720bULL, 0x002fe20003f1e000ULL, 0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL,
0x0000000b08067208ULL, 0x000fe20004000000ULL, 0x0c201f000d0e7f89ULL, 0x004ea200000e0000ULL,
0x000000093200720bULL, 0x000fc60003f1e000ULL, 0x0c201f0006077f89ULL, 0x0006e200000e0000ULL,
0x0000003209087208ULL, 0x000fe40004000000ULL, 0x0000000f0c00720bULL, 0x002fe40003f3e000ULL,
0x0000000e0d00720bULL, 0x004fe40003f5e000ULL, 0x0000000c0f097208ULL, 0x000fe40004800000ULL,
0x0000000d0e0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b08327820ULL, 0x008fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000303ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010832ULL, 0x000000070600720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b21217823ULL, 0x100fe40000010832ULL, 0x00000023000c7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b28287823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe20000010832ULL,
0x0000002800117308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b09237820ULL, 0x004fc40000410000ULL,
0x3fb8aa3b29297823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010823ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010823ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe40000010823ULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe40000010823ULL,
0x3fb8aa3b2c287823ULL, 0x008fc40000010832ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010823ULL,
0x0000001f000e7308ULL, 0x002fe20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe40000010823ULL,
0x3fb8aa3b26267823ULL, 0x100fe40000010823ULL, 0x3fb8aa3b31317823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b30307823ULL, 0x000fe20000010823ULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000c210c723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b2f2f7823ULL, 0x000fc40000010832ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe40000010832ULL,
0x00000022000d7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b05057823ULL, 0x100fe40000010823ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe40000010823ULL,
0x3fb8aa3b14147823ULL, 0x000fe20000010832ULL, 0x00000020002c7308ULL, 0x0007220000000800ULL,
0x0000000e1d0e723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b12227823ULL, 0x004fc40000010823ULL,
0x3fb8aa3b2d0b7823ULL, 0x000fc80000010832ULL, 0x0000001e000f7308ULL, 0x000fe20000000800ULL,
0x00000004ff207e24ULL, 0x008fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x3f8000002020783eULL, 0x000fe400000010ffULL, 0x0000001c001c7308ULL, 0x000e620000000800ULL,
0x0000000d2c0d723eULL, 0x010fe400000010ffULL, 0x000000ffff217224ULL, 0x000fe200078e0020ULL,
0x00000002ff2c7819ULL, 0x000fc80000011603ULL, 0x0000001b00107308ULL, 0x0004e20000000800ULL,
0x000000082c337824ULL, 0x000fe200078e00ffULL, 0x0000000f1c0f723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b271b7823ULL, 0x004fca0000010832ULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x000000200c1c723cULL, 0x000b6200000418ffULL, 0x000000101110723eULL, 0x008fcc00000010ffULL,
0x0000002400247308ULL, 0x000e620000000800ULL, 0x3fb8aa3b13217823ULL, 0x020fce0000010823ULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000003100347308ULL, 0x0004e20000000800ULL,
0x000000252411723eULL, 0x002fe200000010ffULL, 0x000000ffff247224ULL, 0x000fc400078e0020ULL,
0x000000ffff257224ULL, 0x000fc800078e0020ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000ffff317224ULL, 0x004fce00078e0020ULL, 0x0000003000277308ULL, 0x0002a20000000800ULL,
0x000000293412723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b17297823ULL, 0x000fcc0000010823ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x000000ffff307224ULL, 0x002fe200078e0020ULL,
0x000000262713723eULL, 0x004fcc00000010ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16277823ULL, 0x100fe40000010823ULL, 0x000000082c167824ULL, 0x040fe200078e00ffULL,
0x00000024101c723cULL, 0x000b68000004181cULL, 0x0000002b002b7308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b15247823ULL, 0x120fe20000010823ULL, 0x000000012c157810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b18237823ULL, 0x000fc60000010823ULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0xfffffff8162d7812ULL, 0x000fce00078ee215ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000000500057308ULL, 0x000ea20000000800ULL, 0x0000002b2e16723eULL, 0x002fe200000010ffULL,
0x000000082c2b7824ULL, 0x000fcc00078e00ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000001a001a7308ULL, 0x000e620000000800ULL, 0x000000220515723eULL, 0x004fe400000010ffULL,
0x000000022c057810ULL, 0x000fc40007ffe0ffULL, 0x000000042c227810ULL, 0x000fc60007ffe0ffULL,
0x0000001400267308ULL, 0x0005e20000000800ULL, 0x000000211a17723eULL, 0x002fce00000010ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000002f2a14723eULL, 0x004fe200000010ffULL,
0x000000082c2a7824ULL, 0x040fe200078e00ffULL, 0x000000032c1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000082c2f7824ULL, 0x000fc600078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee21aULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x00000030141c723cULL, 0x000b62000004181cULL,
0xfffffff82a217812ULL, 0x000fe200078ee205ULL, 0x000000082c057824ULL, 0x040fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee222ULL, 0x000000052c227810ULL, 0x040fe40007ffe0ffULL,
0x00000023001a7308ULL, 0x0005e20000000800ULL, 0x000000082c317824ULL, 0x060fe200078e00ffULL,
0x000000082c2a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff805057812ULL, 0x000fe400078ee22cULL,
0x0000001b2626723eULL, 0x002fe200000010ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0020ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0xfffffff831317812ULL, 0x000fe200078ee222ULL,
0x000000082a377824ULL, 0x000fe200078e00ffULL, 0x0001100002227811ULL, 0x000fc800078e58ffULL,
0xfffffff837237812ULL, 0x004fe200078ee22aULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x0000001005057824ULL, 0x100fe400078e0222ULL, 0x000000102d2d7824ULL, 0x100fe400078e0222ULL,
0x0000001021217824ULL, 0x100fe400078e0222ULL, 0x000000102b2b7824ULL, 0x100fe200078e0222ULL,
0x0000002400257308ULL, 0x0005e20000000800ULL, 0x000000102f2f7824ULL, 0x000fc400078e0222ULL,
0x0000001031317824ULL, 0x100fe400078e0222ULL, 0x0000001023237824ULL, 0x000fc600078e0222ULL,
0x0000002700187308ULL, 0x0007220000000800ULL, 0x000000062c247810ULL, 0x004fc80007ffe0ffULL,
0xfffffff833337812ULL, 0x000fe400078ee224ULL, 0x0000000b2824723eULL, 0x002fe400000010ffULL,
0xffffffff2c277810ULL, 0x048fe20007ffe0ffULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0x00000006070b7208ULL, 0x000fe20004800000ULL, 0x0000001033337824ULL, 0x000fc600078e0222ULL,
0xfffffff82c357812ULL, 0x000fe400078ee227ULL, 0x000000291a27723eULL, 0x000fe200000010ffULL,
0x000000ffff1a7224ULL, 0x000fe200078e0020ULL, 0x000000251825723eULL, 0x010fe200000010ffULL,
0x0000001035357824ULL, 0x000fe200078e0222ULL, 0x0000000c19187812ULL, 0x000fca00078ec0ffULL,
0x0000001a241c723cULL, 0x000f62000004181cULL, 0x0000000105057824ULL, 0x000fe400078e0218ULL,
0x00000001182d7824ULL, 0x040fe400078e022dULL, 0x0000000118217824ULL, 0x040fe200078e0221ULL,
0x0000000c05007388ULL, 0x0003e20000000800ULL, 0x00000001182b7824ULL, 0x040fe400078e022bULL,
0x00000001182f7824ULL, 0x040fe200078e022fULL, 0x0000000e2d007388ULL, 0x0003e20000000800ULL,
0x0000000118317824ULL, 0x000fc400078e0231ULL, 0x0000000118337824ULL, 0x040fe200078e0233ULL,
0x0000001021007388ULL, 0x0003e20000000800ULL, 0x0000000118357824ULL, 0x040fe400078e0235ULL,
0x0000000118187824ULL, 0x000fe200078e0223ULL, 0x000000122b007388ULL, 0x0003e80000000800ULL,
0x000000142f007388ULL, 0x0003e40000000800ULL, 0x000000ffff1d7224ULL, 0x020fc400078e001eULL,
0x0000001631007388ULL, 0x0003e80000000800ULL, 0x0000002433007388ULL, 0x0003e80000000800ULL,
0x0000002635007388ULL, 0x0003e80000000800ULL, 0x0000000d18007388ULL, 0x0003e80000000800ULL,
0x0004000f2d007388ULL, 0x0003e80000000800ULL, 0x0004001121007388ULL, 0x0003e80000000800ULL,
0x000400132b007388ULL, 0x0003e80000000800ULL, 0x000400152f007388ULL, 0x0003e80000000800ULL,
0x0004001731007388ULL, 0x0003e80000000800ULL, 0x0004002533007388ULL, 0x0003e80000000800ULL,
0x0004002735007388ULL, 0x0003e80000000800ULL, 0x0170000800008388ULL, 0x0003e80000000c00ULL,
0x0172001c00008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000007dff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008007dff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010007dff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000016e6e7810ULL, 0x000fe20007ffe0ffULL, 0x000018007dff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff6d7224ULL, 0x000fc400078e0071ULL, 0x0000007a6e00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff9c5000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x000181b000387802ULL, 0x000fc40000000f00ULL,
0x00000f3000007944ULL, 0x002fea0003c00000ULL, 0xfffea26000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x0001820000387802ULL, 0x000fc40000000f00ULL, 0x00000ee000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff127224ULL, 0x000fe200078e0013ULL, 0xfffea29000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e001aULL, 0x0001827000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000e2000007944ULL, 0x002fea0003c00000ULL, 0xfffea35000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e001aULL, 0x000182d000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000dc000007944ULL, 0x002fea0003c00000ULL, 0xfffea45000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x0001834000397802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0008ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0013ULL, 0xfffea83000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x000183b000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0013ULL,
0xfffea7f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0001841000387802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x002fea0003c00000ULL, 0xfffed5e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x0001846000387802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff167224ULL, 0x000fe200078e0013ULL, 0xfffed62000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e003fULL, 0x000184d000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000bc000007944ULL, 0x002fea0003c00000ULL, 0xfffed6e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e003fULL, 0x0001853000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x002fea0003c00000ULL, 0xfffed7e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0000ULL, 0x000185a000397802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0003ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0013ULL, 0xfffedbd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0000ULL, 0x0001861000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000a8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0013ULL,
0xfffedb9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0001867000387802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x002fea0003c00000ULL, 0xffff094000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x000186c000387802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff127224ULL, 0x000fe200078e0013ULL, 0xffff097000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0017ULL, 0x0001873000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000096000007944ULL, 0x002fea0003c00000ULL, 0xffff0a4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0017ULL, 0x0001879000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000090000007944ULL, 0x002fea0003c00000ULL, 0xffff0b4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e000dULL, 0x0001880000397802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0012ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0013ULL, 0xffff0f4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e000dULL, 0x0001887000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000082000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0013ULL,
0xffff0f0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x004fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x000188d000387802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x008fea0003c00000ULL, 0xffff3be000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x0001892000387802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x000fe200078e0013ULL, 0xffff3c2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0007ULL, 0x0001899000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000070000007944ULL, 0x008fea0003c00000ULL, 0xffff3ce000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0007ULL, 0x000189f000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x00afea0003c00000ULL, 0xffff3de000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0000ULL, 0x00018a6000397802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e000dULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0013ULL, 0xffff421000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0000ULL, 0x00018ad000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0013ULL,
0xffff41d000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x00018b40000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0007ULL, 0xffffe87000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x006fe200078e0010ULL, 0x00018bc0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00018c40000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007107208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0x00018cc0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000070b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0032ULL,
0x00018d40000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b07067208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000073200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00018dc0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000003207087208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00018e40000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007097208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0006ULL,
0x00018ec0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe66000007947ULL, 0x000fea000383ffffULL, 0x0180000006007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000600008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe6fb002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x0c00000f0e077389ULL, 0x0002a200000e0007ULL,
0xfffe6f700c007950ULL, 0x000fea0003c3ffffULL, 0x0000003a00007348ULL, 0x000fe80003800000ULL,
0x0000001338137389ULL, 0x0002a400000e003bULL, 0x000000ffff387224ULL, 0x002fc400078e0039ULL,
0x00000000ff397424ULL, 0x000fc800078e00ffULL, 0xfffe6f2038007950ULL, 0x000fea0003c3ffffULL,
0x000000011300780cULL, 0x000fe20003f45070ULL, 0x0000003900007348ULL, 0x000fd80003800000ULL,
0x0000000000137806ULL, 0x000fc800050e0100ULL, 0x0000003913137212ULL, 0x000fe200078ec0ffULL,
0x00000000ff397424ULL, 0x000fc800078e00ffULL, 0xfffe6ec038007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x00000000000003d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e90ULL, 0x00000000000007c0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001650ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001660ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016f0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016f4ULL, 0x00000000000001b8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000019200ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001ab00ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001ab50ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001aed0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000016f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019410ULL, 0x0000000000019410ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001ab00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001aed0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_80_cubin_len = 110512;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
