/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000190d0ULL, 0x0000000000018d50ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x00000000000171b0ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000017330ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000017370ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x00000000000173c0ULL, 0x0000000000000140ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000017500ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000171b000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x005afc0400288080ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL, 0xa708288080910828ULL,
0x288080a908288080ULL, 0x80bd08288080b008ULL, 0x1628808084082880ULL, 0x0000031028808280ULL,
0x8492000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x000171b000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x9108288080900828ULL,
0x288080a708288080ULL, 0x80b008288080a908ULL, 0x08288080bd082880ULL, 0x808280162880808aULL,
0x0000000000031028ULL, 0x2880808a92000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000011000000000ULL, 0x0001733000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x9108288080900828ULL, 0x288080a708288080ULL,
0x80b008288080a908ULL, 0x16288080bd082880ULL, 0x0000031028808280ULL, 0xbd92000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x000001a800000000ULL, 0x0001737000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8090288080bd0900ULL, 0x0000000000002880ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0xa708288080900828ULL, 0x288080a908288080ULL,
0x80bd08288080b008ULL, 0x1628808091082880ULL, 0x0000031028808280ULL, 0x9192000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000024800000000ULL, 0x000173c000000000ULL,
0x0000014000000000ULL, 0x0000080400000000ULL, 0x8090288080910900ULL, 0x0000000000002880ULL,
0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL,
0x0000007b00043704ULL, 0x0000001800080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL,
0x0021f00000500009ULL, 0x00000000000c1704ULL, 0x0021f00000480008ULL, 0x00000000000c1704ULL,
0x0011f00000400007ULL, 0x00000000000c1704ULL, 0x0061f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL,
0x0134290400000900ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x00000420000002d0ULL, 0x000023c000000540ULL, 0x0000259000002470ULL, 0x00002b50000026f0ULL,
0x00002bd000002b80ULL, 0x0000597000002c20ULL, 0x00005b3000005a10ULL, 0x0000610000005c90ULL,
0x0000618000006130ULL, 0x00008ee0000061d0ULL, 0x000090b000008f80ULL, 0x0000969000009210ULL,
0x00009710000096c0ULL, 0x0000c3b000009760ULL, 0x0000c5700000c450ULL, 0x0000cb800000c6d0ULL,
0x0000cc000000cbb0ULL, 0x0000ed300000cc50ULL, 0x00015a300000ed40ULL, 0x00015a8000015a70ULL,
0x00015aa000015a90ULL, 0x00015b2000015b00ULL, 0x000167f000015b40ULL, 0x0001688000016830ULL,
0x00016910000168c0ULL, 0x000169b000016960ULL, 0x00016a40000169f0ULL, 0x00016ad000016a80ULL,
0x00016b7000016b20ULL, 0x00016c0000016bb0ULL, 0x00016c9000016c40ULL, 0x00016d3000016ce0ULL,
0x00016dc000016d70ULL, 0x00016e5000016e00ULL, 0x00016ef000016ea0ULL, 0x00016fb000016f50ULL,
0x0001707000017010ULL, 0x00017130000170d0ULL, 0x0440390400017190ULL, 0x000000ff000003c0ULL,
0x003f01000000f600ULL, 0x0000000d00000400ULL, 0x003f01200000f608ULL, 0x0000000d00000480ULL,
0x003f01200000f688ULL, 0x0000000d000004f0ULL, 0x003f01200000f6a8ULL, 0x0000000d00000520ULL,
0x003f01200000f6c8ULL, 0x000000ff00000910ULL, 0x003f01070000f600ULL, 0x0000000200000a70ULL,
0x003f01020000f68cULL, 0x0000000200000b00ULL, 0x003f01010000f688ULL, 0x000000ff00001330ULL,
0x0004010700000000ULL, 0x000000ff000013b0ULL, 0x0004010100000000ULL, 0x0000000600001410ULL,
0x003f010100000020ULL, 0x0000000600001570ULL, 0x003f01050000f6ccULL, 0x0000000600001740ULL,
0x003f01050000f6ccULL, 0x0000001200001f80ULL, 0x003f01070000f6b0ULL, 0x0000001200002020ULL,
0x003f01010000f6b0ULL, 0x0000001000002080ULL, 0x003f01010000f608ULL, 0x00000006000020c0ULL,
0x003f01050000f60cULL, 0x00000006000022a0ULL, 0x003f01050000f60cULL, 0x00000022000028b0ULL,
0x003f01050000f6acULL, 0x0000002200002a80ULL, 0x003f01050000f6acULL, 0x0000003400004be0ULL,
0x003f010100000000ULL, 0x0000000e00004c40ULL, 0x003f01010000f688ULL, 0x0000000500004c70ULL,
0x003f010500000004ULL, 0x0000000500004e30ULL, 0x003f010500000004ULL, 0x000000ff00005580ULL,
0x0004010700000000ULL, 0x000000ff00005650ULL, 0x0004010100000000ULL, 0x0000000e000056b0ULL,
0x003f01010000f628ULL, 0x00000006000056d0ULL, 0x003f01050000f62cULL, 0x00000006000058a0ULL,
0x003f01050000f62cULL, 0x0000003a00005e60ULL, 0x003f01050000f6b4ULL, 0x0000003a00006030ULL,
0x003f01050000f6b4ULL, 0x0000001000008140ULL, 0x003f010100000000ULL, 0x0000005a000081a0ULL,
0x003f01010000f690ULL, 0x00000005000081d0ULL, 0x003f010500000004ULL, 0x0000000500008390ULL,
0x003f010500000004ULL, 0x000000ff00008af0ULL, 0x0004010700000008ULL, 0x0000003800008b80ULL,
0x003f01010000f6b0ULL, 0x0000000600008be0ULL, 0x003f01010000f648ULL, 0x0000000600008c40ULL,
0x003f01050000f64cULL, 0x0000000600008e10ULL, 0x003f01050000f64cULL, 0x0000003d000093f0ULL,
0x003f01050000f6acULL, 0x0000003d000095c0ULL, 0x003f01050000f6acULL, 0x000000050000b5e0ULL,
0x003f010100000000ULL, 0x0000000a0000b640ULL, 0x003f010100000000ULL, 0x000000050000b670ULL,
0x003f010500000004ULL, 0x000000050000b830ULL, 0x003f010500000004ULL, 0x000000ff0000bfd0ULL,
0x0004010700000000ULL, 0x000000ff0000c0a0ULL, 0x0004010100000000ULL, 0x000000130000c100ULL,
0x003f01010000f668ULL, 0x000000130000c130ULL, 0x003f01050000f66cULL, 0x000000130000c300ULL,
0x003f01050000f66cULL, 0x000000340000c8a0ULL, 0x003f01050000f6b4ULL, 0x000000340000caa0ULL,
0x003f01050000f6b4ULL, 0x000000050000eb00ULL, 0x003f010100000000ULL, 0x000000060000eb80ULL,
0x003f010100000000ULL, 0x000000ff0000fca0ULL, 0x003f01010000f600ULL, 0x000000ff00010850ULL,
0x003f01050000f604ULL, 0x000000ff00010a20ULL, 0x003f01050000f604ULL, 0x000000ff00010c50ULL,
0x003f01010000f600ULL, 0x000000ff00010c80ULL, 0x003f01050000f604ULL, 0x000000ff00010e40ULL,
0x003f01050000f604ULL, 0x0000007900013f70ULL, 0x003f010100000000ULL, 0x0000007900014020ULL,
0x003f010500000004ULL, 0x00000079000141f0ULL, 0x003f010500000004ULL, 0x0000007b00016650ULL,
0x003f010100000000ULL, 0x0000007b000166b0ULL, 0x003f010100000008ULL, 0x0000007b00016710ULL,
0x003f010100000010ULL, 0x0000007b00016780ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL,
0x0000f6200000f5f0ULL, 0x0000f9600000f800ULL, 0x0000fbf00000faf0ULL, 0x000167c000010ea0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002c4ULL, 0x0000001b00000002ULL,
0x0000000000000224ULL, 0x0000001b00000002ULL, 0x0000000000000194ULL, 0x0000001b00000002ULL,
0x00000000000000ecULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x000000000000029eULL, 0x0000001b00000002ULL, 0x00000000000001feULL, 0x0000001b00000002ULL,
0x000000000000016bULL, 0x0000001b00000002ULL, 0x00000000000000c6ULL, 0x0000001b00000002ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x00000000007a7919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e7d7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x00000000000c7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff0a7819ULL, 0x010fc80000011609ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x010fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007a03777227ULL, 0x004fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a77ULL,
0x0000000007007224ULL, 0x000fca00078e027aULL, 0x000000070000720cULL, 0x000fe20003f66070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000fe400000e0000ULL,
0x00000000020d7a24ULL, 0x000fca00078e0209ULL, 0x000000ff0d00720cULL, 0x000fc60003f45270ULL,
0x0000000100003824ULL, 0x000fe200078e0a07ULL, 0x0000000177773810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000070000720cULL, 0x000fe40003f86070ULL,
0x0000007f0d00780cULL, 0x040fe40003f04070ULL, 0x000000030d00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fe400078e00ffULL, 0x0000000177774810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000007ff77d212ULL, 0x000fe200078e33ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0xff317217ff108424ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f84070ULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x00f608040d009388ULL, 0x0005e20000008a00ULL, 0x000000ffff007224ULL, 0x000fc600078e0a77ULL,
0x00001fff0a047589ULL, 0x000ee200000e0000ULL, 0x00000000077a7224ULL, 0x000fe400078e027aULL,
0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL, 0x00f400100d008388ULL, 0x000fe20000004800ULL,
0x000000107a737824ULL, 0x000fe400078e00ffULL, 0x3fffff80ff02b424ULL, 0x002fe200078e00ffULL,
0x00f688060d00b388ULL, 0x000fe20000008a00ULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x0000000473007c10ULL, 0x040fe2000fffe1ffULL, 0x3fffffc0ff08c424ULL, 0x000fe200078e00ffULL,
0x0000000473007c0cULL, 0x000fe2000bf03070ULL, 0x7fffffc0ff09c424ULL, 0x000fe200078e00ffULL,
0x0000001000007817ULL, 0x000fe20003800000ULL, 0x00f6a8020d00b388ULL, 0x000fe20000008a00ULL,
0x00005a0077057a19ULL, 0x004fc400000006ffULL, 0x000000ff00797207ULL, 0x000fe20000000000ULL,
0x00f6c8080d00c388ULL, 0x000fe20000008a00ULL, 0x000058000c007a24ULL, 0x000fc600078e02ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107900780cULL, 0x000fe20003f05270ULL,
0x000000040b027824ULL, 0x008fe400078e0204ULL, 0x0000007d00057224ULL, 0x000fe400078e0205ULL,
0x0000000202027824ULL, 0x000fd000078e00ffULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff087819ULL, 0x002fca0000011600ULL, 0x0000000102097824ULL, 0x000fc800078e0208ULL,
0x0000000173037824ULL, 0x000fca00078e0209ULL, 0x00000004030a7c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011603ULL, 0x0000001000037824ULL, 0x000fe400078e00ffULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x0000000279057217ULL, 0x000fe40007800000ULL,
0x000000f0030d7812ULL, 0x000fe200078ec0ffULL, 0x0000007d06067224ULL, 0x000fe400078e020aULL,
0x0000000105057824ULL, 0x000fc400078e0a02ULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000050800720cULL, 0x000fe20003f06070ULL, 0x0000000109027824ULL, 0x040fe200078e0200ULL,
0x0000000d060d7212ULL, 0x000fe200078efcffULL, 0x0000001009097824ULL, 0x000fc600078e00ffULL,
0x00005e000d067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff009027812ULL, 0x000fe400078ee202ULL,
0x00005f0007077a10ULL, 0x000fc60000ffe4ffULL, 0x0000001002057824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000200027211ULL, 0x002fca00078fe0ffULL,
0x0000000173037824ULL, 0x000fca00078e0202ULL, 0x0000000403087c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011603ULL, 0x0000001000037824ULL, 0x000fe400078e00ffULL,
0x0000000105087824ULL, 0x000fe400078e0208ULL, 0x0000000102057824ULL, 0x000fe200078e0200ULL,
0x000000f003097812ULL, 0x000fe200078ec0ffULL, 0x0000007d06067224ULL, 0x000fe400078e0208ULL,
0x0000001002027824ULL, 0x000fc400078e00ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0xfffffff002057812ULL, 0x000fe400078ee205ULL, 0x0000000906067212ULL, 0x000fc600078efcffULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00005e0006067a10ULL, 0x000fc80007f1e0ffULL,
0x00005f0007077a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c48ULL, 0x0000000000067919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200057300ULL, 0x000e7000000e0000ULL, 0x0000000200077309ULL, 0x000ea20000000000ULL,
0x000000060500720cULL, 0x002fe20003f02070ULL, 0x000000ffff057224ULL, 0x004fc400078e0a07ULL,
0x00000004ff077424ULL, 0x000fc800078e00ffULL, 0x000064000c067625ULL, 0x000fcc00078e0007ULL,
0x00f60405ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806697981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x000000ff69057810ULL, 0x006fc80007ffe0ffULL,
0x00000008ff6a7819ULL, 0x000fce0000011605ULL, 0x0000f1c000008947ULL, 0x000fea0003800000ULL,
0x0000000804027824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0702ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x000000020c067824ULL, 0x000fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe20000011604ULL,
0x00f6880002ff7f8cULL, 0x0005e2000c80043fULL, 0x0000000104727812ULL, 0x000fe200078ec0ffULL,
0x0000590006067624ULL, 0x000fe400078e020eULL, 0x000000206e7c7824ULL, 0x000fc400078e00ffULL,
0x0000000177737824ULL, 0x000fc800078e0206ULL, 0x0000660073057a24ULL, 0x000fe200078e027cULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000007c69077217ULL, 0x006fe20007800000ULL,
0x0000001072067824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fc60000011600ULL,
0x0000000107077824ULL, 0x000fe200078e0a7cULL, 0x00000004080b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fc600078e0208ULL, 0x0000000607077217ULL, 0x000fe20007800000ULL,
0x00000001090a7824ULL, 0x040fe400078e0200ULL, 0x00000008090d7824ULL, 0x000fe400078e00ffULL,
0x0000000107077824ULL, 0x000fe400078e0a06ULL, 0x0000000105097824ULL, 0x000fe200078e0209ULL,
0xfffffff80d0e7812ULL, 0x000fe400078ee20aULL, 0x00000008080a7810ULL, 0x000fc40007ffe0ffULL,
0x000000070800720cULL, 0x0c0fe40003f66070ULL, 0x0000000c08087810ULL, 0x000fe40007ffe0ffULL,
0x000000070b00720cULL, 0x080fe20003f46070ULL, 0x00000001060b7824ULL, 0x000fe200078e020bULL,
0x000000070a00720cULL, 0x080fe20003f26070ULL, 0x00000001060a7824ULL, 0x000fe200078e020aULL,
0x000000070800720cULL, 0x000fe20003f06070ULL, 0x00000001060c7824ULL, 0x000fe400078e0208ULL,
0x0000008009067825ULL, 0x000fc800078e00ffULL, 0x00000001050f7824ULL, 0x000fe200078e020cULL,
0x00000070060d7812ULL, 0x000fe200078ef803ULL, 0x000000010c067824ULL, 0x140fe400078e0200ULL,
0x000000080c117824ULL, 0x000fe200078e00ffULL, 0x000062000d0c7a10ULL, 0x000fe20007f9e0ffULL,
0x000000010b097824ULL, 0x040fe400078e0200ULL, 0x000000080b107824ULL, 0x000fe200078e00ffULL,
0xfffffff811147812ULL, 0x000fe200078ee206ULL, 0x0000000105087824ULL, 0x000fe200078e020bULL,
0x00006300070d7a10ULL, 0x000fe200027fe4ffULL, 0x00000001050b7824ULL, 0x000fe200078e020aULL,
0xfffffff810107812ULL, 0x000fe200078ee209ULL, 0x0000008008067825ULL, 0x000fc800078e00ffULL,
0x000000010a057824ULL, 0x000fe200078e0200ULL, 0x0000007006067812ULL, 0x000fe200078ef803ULL,
0x000000080a127824ULL, 0x000fe400078e00ffULL, 0x000000800b087825ULL, 0x000fe200078e00ffULL,
0x0000620006067a10ULL, 0x000fe40007f9e0ffULL, 0xfffffff812127812ULL, 0x000fe200078ee205ULL,
0x000000800f0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fe400078ef803ULL,
0x0000b0006e057811ULL, 0x000fc400078e68ffULL, 0x000000700a0a7812ULL, 0x000fe400078ef803ULL,
0x0000620008087a10ULL, 0x000fe20007fbe0ffULL, 0x000000100e0f7824ULL, 0x100fe200078e0205ULL,
0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001010117824ULL, 0x100fe200078e0205ULL,
0x0000630007077a10ULL, 0x000fe200027fe4ffULL, 0x0000001012037824ULL, 0x100fe200078e0205ULL,
0x0000630009097a10ULL, 0x000fe20002ffe4ffULL, 0x0000001014057824ULL, 0x000fe200078e0205ULL,
0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e8000d901c48ULL, 0x0000000006117faeULL, 0x0003e8000d101c48ULL,
0x0000000008037faeULL, 0x0003e8000c901c48ULL, 0x000000000a057faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001072077824ULL, 0x006fe200078e00ffULL,
0x0000b0006e137811ULL, 0x000fc800078e68ffULL, 0x0000000700067211ULL, 0x000fc800078fe8ffULL,
0x0000000406097810ULL, 0x040fe20007ffe0ffULL, 0x0000000106087824ULL, 0x040fe200078e0200ULL,
0x0000000c060c7810ULL, 0x040fe20007ffe0ffULL, 0x00000008060b7824ULL, 0x040fe400078e00ffULL,
0x0000000105077824ULL, 0x000fe400078e0206ULL, 0x00000001090a7824ULL, 0x000fe200078e0200ULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL, 0x0000000105087824ULL, 0x000fe200078e0209ULL,
0x00000008060b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008007067825ULL, 0x000fc800078e00ffULL,
0x00000008090f7824ULL, 0x000fe200078e00ffULL, 0x00000070060d7812ULL, 0x000fe200078ef803ULL,
0x0000000105097824ULL, 0x040fe400078e020bULL, 0x0000000105117824ULL, 0x000fe200078e020cULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL, 0x000000010b057824ULL, 0x140fe400078e0200ULL,
0x000000080b107824ULL, 0x000fe400078e00ffULL, 0x000000010c067824ULL, 0x000fc400078e0200ULL,
0x000000080c0b7824ULL, 0x000fe200078e00ffULL, 0x000062000d0c7a10ULL, 0x000fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0213ULL, 0xfffffff810107812ULL, 0x000fe200078ee205ULL,
0x000000100e057824ULL, 0x000fe200078e0213ULL, 0xfffffff80b127812ULL, 0x000fe200078ee206ULL,
0x00000080110a7825ULL, 0x000fe200078e00ffULL, 0x00006300070d7a10ULL, 0x000fc600007fe4ffULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x100fe200078ef803ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c057faeULL, 0x0003e4000b901c48ULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fe400078ef803ULL,
0x000062000a0a7a10ULL, 0x000fe20007f5e0ffULL, 0x0000001012117824ULL, 0x000fe200078e0213ULL,
0x0000007008087812ULL, 0x000fe200078ef803ULL, 0x0000001010037824ULL, 0x000fe200078e0213ULL,
0x0000620006067a10ULL, 0x000fc40007f1e0ffULL, 0x0000620008087a10ULL, 0x000fe40007f3e0ffULL,
0x0000630007077a10ULL, 0x000fe400007fe4ffULL, 0x0000630009097a10ULL, 0x000fe40000ffe4ffULL,
0x000063000b0b7a10ULL, 0x000fe200017fe4ffULL, 0x00000000060f7faeULL, 0x0003e8000b901c48ULL,
0x0000000008037faeULL, 0x0003e8000b901c48ULL, 0x000000000a117faeULL, 0x0003e4000b901c48ULL,
0x000000006e0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000f6a86e067811ULL, 0x002fe200078e18ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047891ULL, 0x004fd2000f8e203fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff0a7f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000d70000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e000bULL, 0x00000002ff757819ULL, 0x000fe20000011604ULL,
0x000000ffff0b7224ULL, 0x004fc400078e0007ULL, 0xff317217ff307424ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e00ffULL, 0x000000ffff377224ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x02afca00078e00ffULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x0000000404057824ULL, 0x000fca00078e00ffULL, 0xfffffff805067812ULL, 0x000fc800078ec0ffULL,
0x0000f6c806057810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc00060e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000110e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc00060e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001030b7810ULL, 0x040fe20007ffe0ffULL, 0x0000010003567824ULL, 0x000fc600078e027cULL,
0x0000006a0b00720cULL, 0x000fe40003f26070ULL, 0x00000040560c7810ULL, 0x000fca0007ffe0ffULL,
0x0000660073127a24ULL, 0x000fcc00078e020cULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000000c69067217ULL, 0x000fe20007800000ULL, 0x00000010720b7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fe20000011600ULL, 0x00000010000e7824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fe200078e0a0cULL, 0x000000040d107810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0f7824ULL, 0x000fc600078e020dULL, 0x000000060b067217ULL, 0x000fe20007800000ULL,
0x000000010f0c7824ULL, 0x040fe400078e0200ULL, 0x000000080f217824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fe400078e0a0bULL, 0x000000010b117824ULL, 0x000fe200078e0210ULL,
0xfffffff821217812ULL, 0x000fe400078ee20cULL, 0x000000061000720cULL, 0x080fe20003f66070ULL,
0x00000001110c7824ULL, 0x000fe200078e0200ULL, 0x000000080d107810ULL, 0x000fe20007ffe0ffULL,
0x0000000811237824ULL, 0x000fe200078e00ffULL, 0x000000060d00720cULL, 0x000fc40003f86070ULL,
0x0000000c0d0d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b137824ULL, 0x000fe200078e0210ULL,
0xfffffff823237812ULL, 0x000fe200078ee20cULL, 0x000000010f0c7824ULL, 0x100fe200078e0212ULL,
0x000000061000720cULL, 0x080fe20003f46070ULL, 0x000000010b337824ULL, 0x000fe200078e020dULL,
0x000000700e0b7812ULL, 0x000fe200078ec0ffULL, 0x00000001110e7824ULL, 0x100fe200078e0212ULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x0000000113107824ULL, 0x040fe400078e0212ULL,
0x0000000113067824ULL, 0x000fc400078e0200ULL, 0x0000000133117824ULL, 0x040fe400078e0200ULL,
0x0000000833207824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff8203d7812ULL, 0x000fe200078ee211ULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0x0000000b0c0c7212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x000062000c0c7a10ULL, 0x000fe20007fbe0ffULL, 0x0000000133127824ULL, 0x000fe200078e0212ULL,
0xfffffff813337812ULL, 0x000fe200078ee206ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000b0e0e7212ULL, 0x080fe400078efcffULL, 0x0000c0006e067811ULL, 0x000fe200078e68ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000062000e0e7a10ULL, 0x000fe40007fde0ffULL,
0x0000000b10107212ULL, 0x000fc400078efcffULL, 0x0000000b12127212ULL, 0x000fe200078efcffULL,
0x00000010210b7824ULL, 0x100fe200078e0206ULL, 0x000063000d0d7a10ULL, 0x000fe20002ffe4ffULL,
0x0000001023217824ULL, 0x100fe200078e0206ULL, 0x000063000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x0000001033237824ULL, 0x100fe200078e0206ULL, 0x0000620010107a10ULL, 0x000fe20007fbe0ffULL,
0x000000103d337824ULL, 0x000fe200078e0206ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000e101c48ULL,
0x0000630011117a10ULL, 0x000fc40002ffe4ffULL, 0x0000630013137a10ULL, 0x000fe200037fe4ffULL,
0x000000000e217faeULL, 0x0003e8000d901c48ULL, 0x0000000010237faeULL, 0x0003e8000d101c48ULL,
0x0000000012337faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010720b7824ULL, 0x000fe200078e00ffULL, 0x0000c0006e337811ULL, 0x000fe200078e68ffULL,
0x0000001000067824ULL, 0x000fc600078e00ffULL, 0x0000000b000b7211ULL, 0x000fe400078fe8ffULL,
0x0000007006237812ULL, 0x000fe400078ec0ffULL, 0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe200078e0200ULL, 0x000000080b117810ULL, 0x040fe20007ffe0ffULL,
0x000000080b0e7824ULL, 0x040fe200078e00ffULL, 0x0000000c0b137810ULL, 0x040fe20007ffe0ffULL,
0x000000010b0c7824ULL, 0x000fe400078e0212ULL, 0x000000010f0b7824ULL, 0x040fe200078e0200ULL,
0xfffffff80e067812ULL, 0x000fe200078ee20dULL, 0x000000010f0e7824ULL, 0x000fc400078e0212ULL,
0x000000080f207824ULL, 0x000fe400078e00ffULL, 0x0000000111107824ULL, 0x040fe400078e0212ULL,
0x00000001110f7824ULL, 0x040fe200078e0200ULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x0000000811227824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee20fULL, 0x0000000113117824ULL, 0x040fe200078e0200ULL,
0x000000230c0c7212ULL, 0x080fe200078efcffULL, 0x0000000813327824ULL, 0x040fe400078e00ffULL,
0x0000000113127824ULL, 0x000fe200078e0212ULL, 0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee211ULL,
0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000230e0e7212ULL, 0x000fc600078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000002310107212ULL, 0x080fe400078efcffULL, 0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000010060b7824ULL, 0x100fe200078e0233ULL, 0x0000002312127212ULL, 0x000fe200078efcffULL,
0x0000001020217824ULL, 0x100fe200078e0233ULL, 0x0000620010107a10ULL, 0x000fe20007f5e0ffULL,
0x0000001022237824ULL, 0x100fe200078e0233ULL, 0x0000620012127a10ULL, 0x000fe20007f7e0ffULL,
0x0000001032337824ULL, 0x000fe200078e0233ULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c48ULL,
0x0000630011117a10ULL, 0x000fc400017fe4ffULL, 0x0000630013137a10ULL, 0x000fe20001ffe4ffULL,
0x000000000e217faeULL, 0x0003e8000b901c48ULL, 0x0000000010237faeULL, 0x0003e8000b901c48ULL,
0x0000000012337faeULL, 0x0003e4000b901c48ULL, 0xfffffff002127812ULL, 0x042fe400078ec0ffULL,
0xffffffe002067812ULL, 0x000fc400078ec0ffULL, 0x00000000120573c2ULL, 0x000e6200000e0000ULL,
0x00000010020b7812ULL, 0x000fca00078ec0ffULL, 0x00000001060b7824ULL, 0x000fe400078e020bULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000872107824ULL, 0x000fe200078e020bULL,
0x0000f6b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b00012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080010107f8cULL, 0x000ea4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x0000000802067812ULL, 0x000fca00078ec0ffULL, 0x000000010b067824ULL, 0x000fca00078e0206ULL,
0x00f60c00060b7984ULL, 0x000ee40000000800ULL, 0x800000000bff7812ULL, 0x00cfe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c0e7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001140fULL, 0x0000000e0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e060fULL, 0x000000020b0b7819ULL, 0x000fc8000000120eULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f60c00060b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000607824ULL, 0x000fe200078e00ffULL, 0x00000001ff627819ULL, 0x000fe20000011600ULL,
0x00000020040b7824ULL, 0x000fe400078e00ffULL, 0xffffffffff747424ULL, 0x000fe200078e00ffULL,
0x0000007060607812ULL, 0x000fc400078ec0ffULL, 0xffffff800b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c62627812ULL, 0x000fc800078ec0ffULL, 0x0000000b620b7210ULL, 0x000fca0007ffe060ULL,
0x00f000000b0d7984ULL, 0x000ea80000000800ULL, 0x00f200000b0e7984ULL, 0x0006620000000800ULL,
0x000000300d00720bULL, 0x004fe20003f1d000ULL, 0x000144127f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c207812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc400078e0030ULL, 0x0000001fff787424ULL, 0x000fe400078e00ffULL,
0xffffffffff767424ULL, 0x000fca00078e00ffULL, 0x0000043000008947ULL, 0x000fea0003800000ULL,
0x000000047500720cULL, 0x000fe40003f05270ULL, 0x000000300d00720bULL, 0x000fe20003f54000ULL,
0x000143a27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x000fc400010e0100ULL,
0x0000008004118824ULL, 0x000fe200078e0260ULL, 0x000000300d0c7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100f107816ULL, 0x000fe200000000ffULL,
0x0000000162118824ULL, 0x000fca00078e0211ULL, 0x00f4000c11008388ULL, 0x0005e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x000000300c107221ULL, 0x004fe20000010100ULL, 0x000000ff0fff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000217308ULL, 0x000ea40000000800ULL, 0x0000002131317220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x000142d27f007947ULL, 0x000fea000b800000ULL, 0x00001f10213c7589ULL, 0x0004e400000e0000ULL,
0x0000003c38387220ULL, 0x08cfe20000410000ULL, 0x0000003c39397220ULL, 0x080fe20000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003c18187220ULL, 0x080fe20000410000ULL, 0x0000003c19197220ULL, 0x080fe20000410000ULL,
0x0000003c14147220ULL, 0x080fe20000410000ULL, 0x0000003c15157220ULL, 0x080fe20000410000ULL,
0x0000003c24247220ULL, 0x080fe20000410000ULL, 0x0000003c25257220ULL, 0x080fe20000410000ULL,
0x0000003c28287220ULL, 0x080fe20000410000ULL, 0x0000003c29297220ULL, 0x080fe20000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000003c34347220ULL, 0x080fe20000410000ULL, 0x0000003c35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x000141b27f007947ULL, 0x000fea000b800000ULL, 0x00001f10213c7589ULL, 0x0004e400000e0000ULL,
0x0000003c3a3a7220ULL, 0x08cfe20000410000ULL, 0x0000003c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003c16167220ULL, 0x080fe20000410000ULL, 0x0000003c17177220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x080fe20000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c36367220ULL, 0x080fe20000410000ULL, 0x0000003c37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff20ff7812ULL, 0x000fda000780600fULL,
0x8000000c0d0d0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00070308ULL, 0x000ea40000000800ULL,
0x000000070e0e0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000310e0d7221ULL, 0x002fc40000010000ULL, 0x00000000000e7805ULL, 0x000fca0000015200ULL,
0xfffffff002227812ULL, 0x000fca00078ec0ffULL, 0x00f6ac0022117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e217210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000002110107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0022117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100b0a7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0a7819ULL, 0x000fe40000011600ULL, 0x00005410080b7816ULL, 0x000fe20000000008ULL,
0x00013d927f007947ULL, 0x000fea000b800000ULL, 0x00001f0a0b087589ULL, 0x0002a400000e0000ULL,
0x000000080a107810ULL, 0x000fe20007ffe0ffULL, 0x00013dc27f007947ULL, 0x000fea000b800000ULL,
0x00001f100b097589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100a107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000bULL,
0x00002be0003d7802ULL, 0x000fc40000000f00ULL, 0x0001479000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180a107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x00002c30003d7802ULL, 0x000fc40000000f00ULL,
0x0001474000007944ULL, 0x006fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007000e7812ULL, 0x000fe200078ec0ffULL, 0x00000200040b7824ULL, 0x00afe200078e00ffULL,
0x00000004ff117819ULL, 0x100fe20000011600ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000080e5d7812ULL, 0x000fc600078ef800ULL, 0x000000046e0a7824ULL, 0x000fe400078e0211ULL,
0x000000085d107824ULL, 0x040fe400078e00ffULL, 0x000000015d497824ULL, 0x000fe200078e020aULL,
0xfffff8000b0a7812ULL, 0x000fe400078ec0ffULL, 0x00000008000b7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8100f7812ULL, 0x000fca00078ee249ULL, 0x000000100f307824ULL, 0x000fc400078e020aULL,
0x0000000e0b0f7212ULL, 0x040fe200078efcffULL, 0x00000004725e7824ULL, 0x000fe200078e0211ULL,
0x0000b0006e647811ULL, 0x000fe400078e68ffULL, 0x000000100b0b7812ULL, 0x000fe200078efe0eULL,
0x000000010f317824ULL, 0x000fe200078e025eULL, 0x0000000249497810ULL, 0x000fe20007ffe0ffULL,
0x000000080f107824ULL, 0x040fe400078e00ffULL, 0x000000080f327824ULL, 0x000fe400078e00ffULL,
0x000000015e5e7824ULL, 0x000fe200078e020bULL, 0xfffffff810117812ULL, 0x000fe200078ee231ULL,
0x000000080b217824ULL, 0x000fe200078e00ffULL, 0x0000000231317810ULL, 0x000fc60007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e0264ULL, 0xfffffff832317812ULL, 0x000fe400078ee231ULL,
0xfffffff821217812ULL, 0x000fe400078ee25eULL, 0x00000000113c783bULL, 0x004e620000004200ULL,
0x0000001031407824ULL, 0x100fe400078e0264ULL, 0x0000001021217824ULL, 0x000fe200078e0264ULL,
0x009000003030783bULL, 0x000ea80000000200ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x000000002120783bULL, 0x000ee20000004200ULL, 0x000001003c617824ULL, 0x002fe200078e00ffULL,
0x0000003c00547306ULL, 0x000fe20000009400ULL, 0x000001003d587824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe2000001143cULL, 0x0000000830308231ULL, 0x084fe200003400ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000000832328231ULL, 0x000fe200003400ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000000931318231ULL, 0x080fe200003400ffULL,
0x0000003c00517306ULL, 0x000e620000005400ULL, 0x00000018ff597819ULL, 0x000fe2000001143dULL,
0x0000000933338231ULL, 0x000fcc00003400ffULL, 0x0000003d00527306ULL, 0x000ff00000009400ULL,
0x0000003d00537306ULL, 0x000ea20000005400ULL, 0x000000515400720bULL, 0x002fce0003f5d000ULL,
0x00000061005f7306ULL, 0x000ff00000209400ULL, 0x00000061006c7306ULL, 0x0003220000205400ULL,
0x000000535200720bULL, 0x004fce0003f9d000ULL, 0x0000005800677306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x002fce000020d400ULL, 0x0000005800707306ULL, 0x0002a20000205400ULL,
0x0000006c5f00720bULL, 0x010fce0003f7d000ULL, 0x0000003c004e7306ULL, 0x0008e2000000d400ULL,
0x0000005800587245ULL, 0x002fca000020d400ULL, 0x0000000161613812ULL, 0x000fe400078efcffULL,
0x0000003d004f7306ULL, 0x000262000000d400ULL, 0x000100003c3c7824ULL, 0x010fe200078e00ffULL,
0x000000706700720bULL, 0x004fc80003fbd000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000000014e4e2812ULL, 0x008fe200078efcffULL, 0x000100003d3d7824ULL, 0x002fe200078e00ffULL,
0x0000003c00677306ULL, 0x000fe40000209400ULL, 0x0000004e614e723eULL, 0x000fe400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000000014f4f4812ULL, 0x000fc400078efcffULL,
0x0000003c006c7306ULL, 0x0002a20000205400ULL, 0x0000000158585812ULL, 0x000fc800078efcffULL,
0x0000004f584f723eULL, 0x000fc600000010ffULL, 0x0000003f005b7306ULL, 0x000fe20000009400ULL,
0x0000003c003c7245ULL, 0x002fc6000020d400ULL, 0x0000004e3038723cULL, 0x000be80000041838ULL,
0x0000003f005c7306ULL, 0x000e620000005400ULL, 0x0000006c6700720bULL, 0x004fe40003f9d000ULL,
0x000001003e4e7824ULL, 0x020fe400078e00ffULL, 0x000001003f4f7824ULL, 0x000fc600078e00ffULL,
0x0000005900657306ULL, 0x000fe20000209400ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff4f7819ULL, 0x000fc6000001144fULL, 0x000000013c3c4812ULL, 0x000fe400078efcffULL,
0x0000005900687306ULL, 0x000ea20000205400ULL, 0x0000005c5b00720bULL, 0x002fce0003f7d000ULL,
0x0000005500637306ULL, 0x000ff00000209400ULL, 0x0000005500667306ULL, 0x0002e20000205400ULL,
0x000000686500720bULL, 0x004fce0003fbd000ULL, 0x0000003d006b7306ULL, 0x000fe20000209400ULL,
0x0000005500557245ULL, 0x002fce000020d400ULL, 0x0000003d006c7306ULL, 0x0002a20000205400ULL,
0x000000666300720bULL, 0x008fe40003fdd000ULL, 0x0000005900667245ULL, 0x000fc8000020d400ULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x0000003e00577306ULL, 0x000fe20000009400ULL,
0x0000003d003d7245ULL, 0x002fca000020d400ULL, 0x0000000155556812ULL, 0x000fe400078efcffULL,
0x0000003e005a7306ULL, 0x000e620000005400ULL, 0x0000006c6b00720bULL, 0x004fe40003f9d000ULL,
0x0000003c553c723eULL, 0x000fe400000010ffULL, 0x00000018ff557819ULL, 0x000fc6000001143eULL,
0x0000004e00677306ULL, 0x000fec0000209400ULL, 0x000000013d3d4812ULL, 0x000fe400078efcffULL,
0x0000004e005c7306ULL, 0x000ea20000205400ULL, 0x0000005a5700720bULL, 0x002fe40003f5d000ULL,
0x0000003d663d723eULL, 0x000fc400000010ffULL, 0x00000018ff667819ULL, 0x000fc6000001143fULL,
0x0000004f00657306ULL, 0x000fe40000209400ULL, 0x0000003c301c723cULL, 0x000b6c000004181cULL,
0x0000004f00687306ULL, 0x0002e20000205400ULL, 0x0000005c6700720bULL, 0x004fe40003fdd000ULL,
0x0000004e003c7245ULL, 0x020fc4000020d400ULL, 0x0000004f003d7245ULL, 0x000fc6000020d400ULL,
0x0000003e004d7306ULL, 0x000ea2000000d400ULL, 0x00000018ff4f7819ULL, 0x002fca0000011421ULL,
0x000000013c3c6812ULL, 0x000fe400078efcffULL, 0x0000003f00507306ULL, 0x000e62000000d400ULL,
0x000000686500720bULL, 0x008fe40003f9d000ULL, 0x000000014d4d2812ULL, 0x004fca00078efcffULL,
0x0000004100527306ULL, 0x000fe20000009400ULL, 0x0000004d3c3c723eULL, 0x000fca00000010ffULL,
0x000000013d3d4812ULL, 0x000fe400078efcffULL, 0x0000000150503812ULL, 0x002fe200078efcffULL,
0x0000004100537306ULL, 0x000e620000005400ULL, 0x00000018ff4d7819ULL, 0x000fe40000011420ULL,
0x000000503d3d723eULL, 0x000fca00000010ffULL, 0x0000005500637306ULL, 0x000fe40000209400ULL,
0x0000003c3018723cULL, 0x000b6c0000041818ULL, 0x0000005500657306ULL, 0x000ea20000205400ULL,
0x000100003e3d7824ULL, 0x020fe200078e00ffULL, 0x000000535200720bULL, 0x002fe20003f7d000ULL,
0x000100003f3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004000517306ULL, 0x000fe20000009400ULL, 0x00000018ff3c7819ULL, 0x000fce000001143cULL,
0x0000003d003e7306ULL, 0x000fe20000209400ULL, 0x000000656300720bULL, 0x004fe20003fdd000ULL,
0x0000010040657824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000003d003f7306ULL, 0x0002b00000205400ULL, 0x0000004000547306ULL, 0x000ee20000005400ULL,
0x0000003d003d7245ULL, 0x002fce000020d400ULL, 0x0000006600677306ULL, 0x000fe20000209400ULL,
0x0000003f3e00720bULL, 0x004fe20003fbd000ULL, 0x00000100413f7824ULL, 0x000fe200078e00ffULL,
0x00000055003e7245ULL, 0x000fc8000020d400ULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000006600687306ULL, 0x0002a20000205400ULL, 0x000000545100720bULL, 0x008fe40003f9d000ULL,
0x000000013e3e6812ULL, 0x000fc600078efcffULL, 0x000000013d3d5812ULL, 0x000fe400078efcffULL,
0x0000003c00527306ULL, 0x000fe20000209400ULL, 0x0000006600667245ULL, 0x002fce000020d400ULL,
0x0000003c00537306ULL, 0x0002e20000205400ULL, 0x000000686700720bULL, 0x004fe40003f5d000ULL,
0x0000003c00677245ULL, 0x000fca000020d400ULL, 0x0000006500547306ULL, 0x000fe20000209400ULL,
0x0000003d3e3c723eULL, 0x002fca00000010ffULL, 0x0000000166662812ULL, 0x000fe400078efcffULL,
0x0000006500637306ULL, 0x000e620000205400ULL, 0x000000535200720bULL, 0x008fe40003fbd000ULL,
0x00000018ff537819ULL, 0x000fca0000011422ULL, 0x0000003f00687306ULL, 0x000fec0000209400ULL,
0x0000000167675812ULL, 0x000fe400078efcffULL, 0x0000003f006b7306ULL, 0x000ea20000205400ULL,
0x000000635400720bULL, 0x002fe40003fdd000ULL, 0x00000067663d723eULL, 0x000fc400000010ffULL,
0x0000006500667245ULL, 0x000fe4000020d400ULL, 0x00000018ff637819ULL, 0x000fe20000011440ULL,
0x00000040005f7306ULL, 0x0002e2000000d400ULL, 0x00000018ff657819ULL, 0x000fe20000011441ULL,
0x0000003c3014723cULL, 0x000b680000041814ULL, 0x0000000166666812ULL, 0x000fe400078efcffULL,
0x0000004100617306ULL, 0x000922000000d400ULL, 0x0000006b6800720bULL, 0x004fe20003fbd000ULL,
0x0001000040407824ULL, 0x002fc400078e00ffULL, 0x0000010042687824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x00000063003e7306ULL, 0x000fe20000209400ULL,
0x000000015f5f4812ULL, 0x008fe200078efcffULL, 0x0001000041417824ULL, 0x010fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000005f663c723eULL, 0x020fe400000010ffULL,
0x0000003f00667245ULL, 0x000fe2000020d400ULL, 0x0000006300677306ULL, 0x0002a20000205400ULL,
0x0000000161613812ULL, 0x000fc400078efcffULL, 0x0000000166665812ULL, 0x000fe400078efcffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000061663d723eULL, 0x000fe200000010ffULL,
0x00000065003f7306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x002fe4000020d400ULL,
0x00000018ff5f7819ULL, 0x000fc60000011423ULL, 0x0000003c3024723cULL, 0x000b640000041824ULL,
0x0000006500667306ULL, 0x0002e20000205400ULL, 0x000000673e00720bULL, 0x004fe20003f7d000ULL,
0x0000010043677824ULL, 0x000fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000004000617306ULL, 0x000fe20000209400ULL, 0x0000006500657245ULL, 0x002fca000020d400ULL,
0x0000000163633812ULL, 0x000fe400078efcffULL, 0x00000040003c7306ULL, 0x0202a20000205400ULL,
0x000000663f00720bULL, 0x008fe20003fbd000ULL, 0x000000080b667824ULL, 0x000fe200078e00ffULL,
0x000000025e3f7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8663f7812ULL, 0x000fe200078ee23fULL,
0x00000041003d7306ULL, 0x000fe20000209400ULL, 0x00000018ff667819ULL, 0x000fe40000011442ULL,
0x0000004000407245ULL, 0x002fe2000020d400ULL, 0x000000103f3f7824ULL, 0x000fe400078e0264ULL,
0x0000000165655812ULL, 0x000fe400078efcffULL, 0x00000041003e7306ULL, 0x0002e20000205400ULL,
0x0000003c6100720bULL, 0x004fce0003f5d000ULL, 0x00000043005b7306ULL, 0x000fe20000009400ULL,
0x0000004100417245ULL, 0x002fca000020d400ULL, 0x0000000140402812ULL, 0x000fe400078efcffULL,
0x0000003e3d00720bULL, 0x008fe20003f9d000ULL, 0x00000043005c7306ULL, 0x000e620000005400ULL,
0x000000406340723eULL, 0x000fe200000010ffULL, 0x000000003f3c783bULL, 0x000eac0000004200ULL,
0x00000066006b7306ULL, 0x000fe80000209400ULL, 0x0000000141414812ULL, 0x000fc800078efcffULL,
0x00000066006c7306ULL, 0x000ee20000205400ULL, 0x000000416541723eULL, 0x000fe400000010ffULL,
0x0000005c5b00720bULL, 0x002fe40003f5d000ULL, 0x00000018ff5c7819ULL, 0x000fc60000011443ULL,
0x0000004200587306ULL, 0x000fe20000009400ULL, 0x000000403028723cULL, 0x000b6e0000041828ULL,
0x0000004200577306ULL, 0x000e620000005400ULL, 0x0000006c6b00720bULL, 0x008fe20003f7d000ULL,
0x00010000426b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x00000068006d7306ULL, 0x000ff00000209400ULL, 0x00000068006f7306ULL, 0x000ee20000205400ULL,
0x000000575800720bULL, 0x002fce0003fdd000ULL, 0x0000006700707306ULL, 0x000ff00000209400ULL,
0x0000006700717306ULL, 0x000e620000205400ULL, 0x0000006f6d00720bULL, 0x008fce0003f9d000ULL,
0x00000042005a7306ULL, 0x000ef0000000d400ULL, 0x0000004300597306ULL, 0x0008a2000000d400ULL,
0x000000717000720bULL, 0x002fce0003fbd000ULL, 0x0000005c00407306ULL, 0x020fe20000209400ULL,
0x0001000043437824ULL, 0x010fe200078e00ffULL, 0x000000015a5a6812ULL, 0x008fc800078efcffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000005c00417306ULL, 0x000e620000205400ULL,
0x0000000159592812ULL, 0x004fce00078efcffULL, 0x0000006b00427306ULL, 0x000ff00000209400ULL,
0x0000006b006d7306ULL, 0x000ea20000205400ULL, 0x000000414000720bULL, 0x002fe40003fdd000ULL,
0x0000006800417245ULL, 0x000fc4000020d400ULL, 0x0000006700687245ULL, 0x000fe4000020d400ULL,
0x0000000141414812ULL, 0x000fe200078efcffULL, 0x00000043006c7306ULL, 0x000fe20000209400ULL,
0x0000000168685812ULL, 0x000fe400078efcffULL, 0x0000005a4140723eULL, 0x000fe400000010ffULL,
0x000000596841723eULL, 0x000fe200000010ffULL, 0x0001000022687824ULL, 0x000fe200078e00ffULL,
0x0000005c00677245ULL, 0x000fe2000020d400ULL, 0x00000043006f7306ULL, 0x000e620000205400ULL,
0x0000006d4200720bULL, 0x004fc40003f5d000ULL, 0x00000043005c7245ULL, 0x000fe2000020d400ULL,
0x00000040302c723cULL, 0x000b62000004182cULL, 0x0000000167676812ULL, 0x000fe400078efcffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000002000467306ULL, 0x000fe60000009400ULL,
0x0000006600417245ULL, 0x020fe4000020d400ULL, 0x0000006b00407245ULL, 0x000fc4000020d400ULL,
0x0000000141413812ULL, 0x000fe200078efcffULL, 0x0000002000447306ULL, 0x000ea20000005400ULL,
0x0000006f6c00720bULL, 0x002fe20003f9d000ULL, 0x00000100216f7824ULL, 0x000fe200078e00ffULL,
0x0000000140402812ULL, 0x000fc800078efcffULL, 0x000000404140723eULL, 0x000fe200000010ffULL,
0x00000021004c7306ULL, 0x000fe20000009400ULL, 0x00000018ff6f7819ULL, 0x000fca000001146fULL,
0x000000015c5c4812ULL, 0x000fe400078efcffULL, 0x0000002100487306ULL, 0x000e620000005400ULL,
0x000000444600720bULL, 0x004fe40003f7d000ULL, 0x0000005c6741723eULL, 0x000fe200000010ffULL,
0x0001000020677824ULL, 0x000fc800078e00ffULL, 0x0000002200477306ULL, 0x000fe20000009400ULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x000000403034723cULL, 0x000b6c0000041834ULL,
0x0000002200457306ULL, 0x000ea20000005400ULL, 0x0000010020317824ULL, 0x020fe200078e00ffULL,
0x000000484c00720bULL, 0x002fe20003fdd000ULL, 0x0001000021417824ULL, 0x000fc400078e00ffULL,
0x00000100234c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000002100117306ULL, 0x000e62000000d400ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x000000454700720bULL, 0x004fca0003f9d000ULL,
0x0000003100327306ULL, 0x000ff00000209400ULL, 0x00000031006b7306ULL, 0x000ea20000205400ULL,
0x0000000111116812ULL, 0x002fce00078efcffULL, 0x00000041006d7306ULL, 0x000ff00000209400ULL,
0x0000004100467306ULL, 0x000e620000205400ULL, 0x0000006b3200720bULL, 0x004fe20003fbd000ULL,
0x000000085d327824ULL, 0x000fca00078e00ffULL, 0xfffffff832497812ULL, 0x000fe200078ee249ULL,
0x0000002000107306ULL, 0x0004e8000000d400ULL, 0x0000001049447824ULL, 0x000fc800078e020aULL,
0x0000004d004e7306ULL, 0x000fe20000209400ULL, 0x0000010022207824ULL, 0x004fe200078e00ffULL,
0x000000466d00720bULL, 0x002fe20003fdd000ULL, 0x000001003c6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe4000001143dULL, 0x00000018ff5d7819ULL, 0x000fe40000011420ULL,
0x0000004d00507306ULL, 0x0002a20000205400ULL, 0x0000003100207245ULL, 0x000fe4000020d400ULL,
0x0000000110103812ULL, 0x008fc400078efcffULL, 0x0000000120205812ULL, 0x000fe400078efcffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000006700307306ULL, 0x000fe20000209400ULL,
0x0000004d004d7245ULL, 0x002fe4000020d400ULL, 0x000000102020723eULL, 0x000fca00000010ffULL,
0x0000006700337306ULL, 0x000e620000205400ULL, 0x000000504e00720bULL, 0x004fe40003f7d000ULL,
0x0000004100507245ULL, 0x000fe4000020d400ULL, 0x00000018ff417819ULL, 0x000fe4000001143eULL,
0x0000000150506812ULL, 0x000fe200078efcffULL, 0x0000005d00487306ULL, 0x000fec0000209400ULL,
0x000000014d4d3812ULL, 0x000fc400078efcffULL, 0x0000005d00457306ULL, 0x0004e20000205400ULL,
0x000000333000720bULL, 0x002fe40003fbd000ULL, 0x009000004430783bULL, 0x000e6a0000000200ULL,
0x0000006f006c7306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x004fce000020d400ULL,
0x0000006f00217306ULL, 0x000fe20000205400ULL, 0x000000454800720bULL, 0x008fe40003fdd000ULL,
0x00000018ff457819ULL, 0x000fca000001143fULL, 0x0000004c00477306ULL, 0x000fec0000209400ULL,
0x000000015d5d6812ULL, 0x000fe400078efcffULL, 0x0000004c00497306ULL, 0x000eb00000205400ULL,
0x00000022000e7306ULL, 0x000722000000d400ULL, 0x0000000830308231ULL, 0x002fc400003400ffULL,
0x0000000832328231ULL, 0x000fe400003400ffULL, 0x0000000931318231ULL, 0x000fc600003400ffULL,
0x0000003d00587306ULL, 0x000fe20000009400ULL, 0x0000006700227245ULL, 0x008fe2000020d400ULL,
0x0001000023677824ULL, 0x000fe200078e00ffULL, 0x000000494700720bULL, 0x004fe20003fdd000ULL,
0x0000000933338231ULL, 0x000fe200003400ffULL, 0x0000000122225812ULL, 0x000fe400078efcffULL,
0x000000216c00720bULL, 0x000fe20003fbd000ULL, 0x0000003d005b7306ULL, 0x000e620000005400ULL,
0x000000010e0e4812ULL, 0x010fe400078efcffULL, 0x00000018ff677819ULL, 0x000fc40000011467ULL,
0x0000006f00217245ULL, 0x000fe4000020d400ULL, 0x000000224d10723eULL, 0x000fe200000010ffULL,
0x0000004f00517306ULL, 0x000fe20000209400ULL, 0x0000000e5d0e723eULL, 0x000fc600000010ffULL,
0x0000000121215812ULL, 0x000fc800078efcffULL, 0x0000004f00527306ULL, 0x000ea20000205400ULL,
0x0000005b5800720bULL, 0x002fe40003f9d000ULL, 0x0000004c005b7245ULL, 0x000fe4000020d400ULL,
0x0000005300587245ULL, 0x000fe4000020d400ULL, 0x000000015b5b6812ULL, 0x000fe200078efcffULL,
0x00000068006b7306ULL, 0x000fe20000209400ULL, 0x000000112121723eULL, 0x000fce00000010ffULL,
0x00000068006c7306ULL, 0x000e620000205400ULL, 0x000000525100720bULL, 0x004fce0003f7d000ULL,
0x00000023004a7306ULL, 0x000ff00000009400ULL, 0x00000023004b7306ULL, 0x000ea20000005400ULL,
0x0000006c6b00720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000ff00000209400ULL,
0x0000005300557306ULL, 0x000e620000205400ULL, 0x0000004b4a00720bULL, 0x004fe40003f5d000ULL,
0x00000018ff4a7819ULL, 0x000fca000001143cULL, 0x0000003c00637306ULL, 0x000ff00000009400ULL,
0x0000003c00657306ULL, 0x000ea20000005400ULL, 0x000000555400720bULL, 0x002fe40003fbd000ULL,
0x0000004f00547245ULL, 0x000fc4000020d400ULL, 0x0000006800557245ULL, 0x000fe4000020d400ULL,
0x0000000154543812ULL, 0x000fe200078efcffULL, 0x0000006700517306ULL, 0x000fe20000209400ULL,
0x0000000155556812ULL, 0x000fe400078efcffULL, 0x00000067004f7245ULL, 0x000fe4000020d400ULL,
0x000000505411723eULL, 0x000fe400000010ffULL, 0x0000000158585812ULL, 0x000fe200078efcffULL,
0x0000006700527306ULL, 0x000e620000205400ULL, 0x000000656300720bULL, 0x004fe20003f7d000ULL,
0x000001003d657824ULL, 0x000fc400078e00ffULL, 0x00000010301c723cULL, 0x000b66000004181cULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x00000023000f7306ULL, 0x000ea6000000d400ULL,
0x000000555810723eULL, 0x020fca00000010ffULL, 0x0000003e00597306ULL, 0x000fe20000009400ULL,
0x000000525100720bULL, 0x002fe40003fdd000ULL, 0x0000006d00517245ULL, 0x000fca000020d400ULL,
0x0000003e005a7306ULL, 0x000e620000005400ULL, 0x000000010f0f2812ULL, 0x004fc800078efcffULL,
0x0000000f5b0f723eULL, 0x000fe400000010ffULL, 0x000000014f4f6812ULL, 0x000fe200078efcffULL,
0x0000005f005e7306ULL, 0x000fe80000209400ULL, 0x0000000e3018723cULL, 0x000b680000041818ULL,
0x0000005f00617306ULL, 0x0004e20000205400ULL, 0x0000005a5900720bULL, 0x002fe20003f5d000ULL,
0x000100003c5a7824ULL, 0x000fc400078e00ffULL, 0x000100003d597824ULL, 0x000fc600078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000006d004c7306ULL, 0x000fe20000209400ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000005f005f7245ULL, 0x004fca000020d400ULL,
0x0000006d006c7306ULL, 0x000e620000205400ULL, 0x000000615e00720bULL, 0x008fce0003f1d000ULL,
0x0000003f00667306ULL, 0x000fec0000009400ULL, 0x000000015f5f0812ULL, 0x000fe400078efcffULL,
0x0000003f005c7306ULL, 0x000ea20000005400ULL, 0x0000006c4c00720bULL, 0x002fe20003fdd000ULL,
0x000001003e4c7824ULL, 0x000fe200078e00ffULL, 0x0000004f5f11723eULL, 0x000fc800000010ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000003c00577306ULL, 0x000e64000000d400ULL,
0x000000103014723cULL, 0x000f680000041814ULL, 0x0000000151516812ULL, 0x000fe400078efcffULL,
0x0000006500637306ULL, 0x000fe20000209400ULL, 0x0000005c6600720bULL, 0x004fce0003fbd000ULL,
0x00000065003c7306ULL, 0x000ea20000205400ULL, 0x0000000157573812ULL, 0x002fc800078efcffULL,
0x00000057510e723eULL, 0x020fc600000010ffULL, 0x0000004a00237306ULL, 0x000ff00000209400ULL,
0x0000004a004e7306ULL, 0x000e620000205400ULL, 0x0000003c6300720bULL, 0x004fe20003f1d000ULL,
0x000100003e3c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x00000046005e7306ULL, 0x000ff00000209400ULL, 0x0000004600617306ULL, 0x0004e20000205400ULL,
0x0000004e2300720bULL, 0x002fc40003fdd000ULL, 0x000000203020723cULL, 0x000b6a0000041838ULL,
0x0000003d00427306ULL, 0x000322000000d400ULL, 0x0000004600467245ULL, 0x004fe4000020d400ULL,
0x0000004a003b7245ULL, 0x020fc8000020d400ULL, 0x000000013b3b6812ULL, 0x000fe200078efcffULL,
0x0000005a00687306ULL, 0x000fe20000209400ULL, 0x000001003f3d7824ULL, 0x042fe200078e00ffULL,
0x000000615e00720bULL, 0x008fe20003f7d000ULL, 0x000100003f5e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005a006b7306ULL, 0x0003e20000205400ULL,
0x00000018ff387819ULL, 0x000fe4000001145eULL, 0x0000000142424812ULL, 0x010fc800078efcffULL,
0x0000000146463812ULL, 0x000fe200078efcffULL, 0x0000005900667306ULL, 0x000fe20000209400ULL,
0x0000005a005a7245ULL, 0x002fce000020d400ULL, 0x0000005900677306ULL, 0x0002b00000205400ULL,
0x0000004c005c7306ULL, 0x000fe20000209400ULL, 0x0000005900597245ULL, 0x002fce000020d400ULL,
0x0000004c00637306ULL, 0x0002e20000205400ULL, 0x000000676600720bULL, 0x004fce0003f9d000ULL,
0x0000003d00527306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x002fca000020d400ULL,
0x0000000159594812ULL, 0x000fe400078efcffULL, 0x0000003d00537306ULL, 0x0002a20000205400ULL,
0x000000635c00720bULL, 0x008fe40003fdd000ULL, 0x000000594611723eULL, 0x000fca00000010ffULL,
0x0000003e00437306ULL, 0x000722000000d400ULL, 0x0000003d003d7245ULL, 0x002fca000020d400ULL,
0x000000014c4c6812ULL, 0x000fe400078efcffULL, 0x0000003f00407306ULL, 0x000e62000000d400ULL,
0x00000065003e7245ULL, 0x008fe4000020d400ULL, 0x000000535200720bULL, 0x004fe40003f7d000ULL,
0x000000013e3e0812ULL, 0x000fe400078efcffULL, 0x0000006b6800720bULL, 0x000fe20003f1d000ULL,
0x0000004100487306ULL, 0x000fe20000209400ULL, 0x0000000143432812ULL, 0x010fc400078efcffULL,
0x000000423e0f723eULL, 0x000fca00000010ffULL, 0x00000041004b7306ULL, 0x0004e20000205400ULL,
0x0000000140405812ULL, 0x002fe200078efcffULL, 0x0000000e3024723cULL, 0x000b620000041824ULL,
0x000000013d3d3812ULL, 0x000fe400078efcffULL, 0x000000015a5a0812ULL, 0x000fc600078efcffULL,
0x0000004500477306ULL, 0x000fe20000209400ULL, 0x0000005a3b10723eULL, 0x000fe400000010ffULL,
0x000000403d0f723eULL, 0x020fe400000010ffULL, 0x0000004100417245ULL, 0x004fe4000020d400ULL,
0x00000038003d7245ULL, 0x000fe2000020d400ULL, 0x0000004500497306ULL, 0x000e620000205400ULL,
0x0000004b4800720bULL, 0x008fe20003f1d000ULL, 0x000000103028723cULL, 0x000b620000041828ULL,
0x000000434c0e723eULL, 0x000fca00000010ffULL, 0x0000003c004e7306ULL, 0x000fe20000209400ULL,
0x0000004500107245ULL, 0x020fe2000020d400ULL, 0x0000000e302c723cULL, 0x000b68000004182cULL,
0x0000000141410812ULL, 0x000fe400078efcffULL, 0x0000003c003f7306ULL, 0x0004e20000205400ULL,
0x000000494700720bULL, 0x002fe20003f9d000ULL, 0x00000002040e7824ULL, 0x020fca00078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ec0ffULL, 0x0000003800397306ULL, 0x000fe20000209400ULL,
0x0000003c003c7245ULL, 0x004fca000020d400ULL, 0x0000000110104812ULL, 0x000fe400078efcffULL,
0x00000038003a7306ULL, 0x000e620000205400ULL, 0x0000003f4e00720bULL, 0x008fda0003fdd000ULL,
0x000000013c3c6812ULL, 0x000fe400078efcffULL, 0x0000003a3900720bULL, 0x002fe40003f5d000ULL,
0x0000003c413c723eULL, 0x000fd600000010ffULL, 0x000000013d3d2812ULL, 0x000fc800078efcffULL,
0x0000003d103d723eULL, 0x000fce00000010ffULL, 0x0000003c3030723cULL, 0x000b6e0000041834ULL,
0x0000f6c86e347811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000034347f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688000eff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff367224ULL, 0x000fc600078e00ffULL,
0x00000000000e7805ULL, 0x004fc80000015200ULL, 0x0000040005117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x006fc40007804835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000003710107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040005117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008056107810ULL, 0x000fca0007ffe0ffULL, 0x0000660073357a24ULL, 0x000fe200078e0210ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x00000010690e7217ULL, 0x000fe20007800000ULL,
0x0000001072117824ULL, 0x000fe200078e00ffULL, 0x00000003ff0f7819ULL, 0x000fc60000011600ULL,
0x000000010e0e7824ULL, 0x000fe200078e0a10ULL, 0x000000040f367810ULL, 0x000fe20007ffe0ffULL,
0x0000000111107824ULL, 0x000fe200078e020fULL, 0x0000000c0f387810ULL, 0x000fe40007ffe0ffULL,
0x0000000e110e7217ULL, 0x000fe20007800000ULL, 0x0000000110347824ULL, 0x040fe400078e0200ULL,
0x0000000810397824ULL, 0x000fe400078e00ffULL, 0x000000010e0e7824ULL, 0x000fc400078e0a11ULL,
0x00000001113a7824ULL, 0x000fe200078e0238ULL, 0xfffffff839397812ULL, 0x000fe400078ee234ULL,
0x0000000e3600720cULL, 0x080fe20003f66070ULL, 0x0000000111367824ULL, 0x000fe200078e0236ULL,
0x000000080f347810ULL, 0x040fe20007ffe0ffULL, 0x000000083a3f7824ULL, 0x000fe200078e00ffULL,
0x0000000e0f00720cULL, 0x080fe20003f86070ULL, 0x00000001100f7824ULL, 0x000fe200078e0235ULL,
0x0000000e3400720cULL, 0x080fe20003f46070ULL, 0x0000000136107824ULL, 0x000fe200078e0200ULL,
0x0000000e3800720cULL, 0x000fe20003f06070ULL, 0x00000008363b7824ULL, 0x000fc400078e00ffULL,
0x000000800f0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL,
0x0000000136107824ULL, 0x000fe200078e0235ULL, 0x000000600e0e7212ULL, 0x000fe200078efcffULL,
0x0000000111377824ULL, 0x000fe400078e0234ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fc60007fbe0ffULL, 0x0000000137347824ULL, 0x100fe200078e0235ULL,
0x0000006010107212ULL, 0x080fe200078efcffULL, 0x000000013a367824ULL, 0x000fe200078e0235ULL,
0x000063000f0f7a10ULL, 0x000fe20002ffe4ffULL, 0x0000000137387824ULL, 0x040fe200078e0200ULL,
0x0000620010107a10ULL, 0x000fe20007fbe0ffULL, 0x00000008373d7824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000630011117a10ULL, 0x000fe40002ffe4ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee238ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006034347212ULL, 0x000fc600078efcffULL, 0x000000013a387824ULL, 0x000fe200078e0200ULL,
0x0000006036367212ULL, 0x000fe200078efcffULL, 0x0000001039397824ULL, 0x100fe200078e0264ULL,
0x0000620034347a10ULL, 0x000fe20007fbe0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0264ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee238ULL, 0x000000103d3d7824ULL, 0x100fe200078e0264ULL,
0x0000620036367a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e397faeULL, 0x0003e2000e101c48ULL, 0x0000630035357a10ULL, 0x000fe20002ffe4ffULL,
0x000000103f3f7824ULL, 0x000fe200078e0264ULL, 0x0000630037377a10ULL, 0x000fe200037fe4ffULL,
0x00000000103b7faeULL, 0x0003e8000d901c48ULL, 0x00000000343d7faeULL, 0x0003e8000d101c48ULL,
0x00000000363f7faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010720f7824ULL, 0x000fca00078e00ffULL, 0x0000000f000f7211ULL, 0x000fc800078fe8ffULL,
0x000000040f367810ULL, 0x040fe20007ffe0ffULL, 0x000000010f0e7824ULL, 0x140fe200078e0200ULL,
0x000000080f117810ULL, 0x040fe20007ffe0ffULL, 0x000000080f397824ULL, 0x040fe200078e00ffULL,
0x0000000c0f377810ULL, 0x000fe20007ffe0ffULL, 0x0000000136107824ULL, 0x040fe400078e0200ULL,
0x00000008363b7824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee20eULL,
0x0000000111347824ULL, 0x040fe400078e0200ULL, 0x00000008113d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x000000010f0e7824ULL, 0x000fc400078e0235ULL,
0x0000000136367824ULL, 0x000fe200078e0235ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee234ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000111107824ULL, 0x100fe200078e0235ULL,
0x000000600e0e7212ULL, 0x080fe200078efcffULL, 0x0000000137347824ULL, 0x040fe400078e0235ULL,
0x0000000137387824ULL, 0x040fe200078e0200ULL, 0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000008373f7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000063000f0f7a10ULL, 0x000fe400007fe4ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee238ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000006036367212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006010107212ULL, 0x080fe400078efcffULL,
0x0000620036367a10ULL, 0x000fe20007f5e0ffULL, 0x0000001039397824ULL, 0x100fe200078e0264ULL,
0x0000006034347212ULL, 0x000fe200078efcffULL, 0x000000103b3b7824ULL, 0x100fe200078e0264ULL,
0x0000620010107a10ULL, 0x000fe20007f1e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0264ULL,
0x0000620034347a10ULL, 0x000fe20007f7e0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e0264ULL,
0x0000630037377a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e397faeULL, 0x0003e2000b901c48ULL, 0x0000630011117a10ULL, 0x000fc400007fe4ffULL,
0x0000630035357a10ULL, 0x000fe20001ffe4ffULL, 0x00000000363b7faeULL, 0x0003e8000b901c48ULL,
0x00000000103d7faeULL, 0x0003e8000b901c48ULL, 0x00000000343f7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000106e0e7824ULL, 0x000fe200078e00ffULL,
0xffffffe0020f7812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000802107812ULL, 0x000fe400078ec0ffULL, 0x000000100e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000f100e7210ULL, 0x000fe20007ffe00eULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff347f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628000e367f8cULL, 0x0004e4000c80043fULL,
0x00000000000e7805ULL, 0x004fc40000015200ULL, 0x00f62c0006117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x00cfe40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e397210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000003910107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c0006117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020040e7824ULL, 0x000fca00078e00ffULL,
0xffffff800e0f7812ULL, 0x000fc800078ec0ffULL, 0x00000080600f7810ULL, 0x000fca0007ffe00fULL,
0x00000001620f7824ULL, 0x000fca00078e020fULL, 0x00f000000f377984ULL, 0x000ea80000000800ULL,
0x00f200000f367984ULL, 0x0006620000000800ULL, 0x0000000c3700720bULL, 0x004fe20003f1d000ULL,
0x000110227f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c387812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fd200078e000cULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x00000001750f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c3700720bULL, 0x000fe40003f54000ULL, 0x000000040f00720cULL, 0x000fe20003f05270ULL,
0x00010fc27f007947ULL, 0x000fd4000b800000ULL, 0x00000000000f7806ULL, 0x000fc400010e0100ULL,
0x0000008004118824ULL, 0x000fe200078e0260ULL, 0x0000000c370e7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100f107816ULL, 0x000fe200000000ffULL,
0x0000000162118824ULL, 0x000fca00078e0211ULL, 0x00f4000e11008388ULL, 0x0005e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000c0e0c7221ULL, 0x004fe20000010100ULL, 0x000000ff0fff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fcc0000410000ULL,
0x0000000c000c7308ULL, 0x000ea40000000800ULL, 0x0000000c0d0d7220ULL, 0x004fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x00010ef27f007947ULL, 0x000fea000b800000ULL, 0x00001f100c3c7589ULL, 0x0004e400000e0000ULL,
0x0000003c20207220ULL, 0x08cfe20000410000ULL, 0x0000003c21217220ULL, 0x080fe20000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003c18187220ULL, 0x080fe20000410000ULL, 0x0000003c19197220ULL, 0x080fe20000410000ULL,
0x0000003c14147220ULL, 0x080fe20000410000ULL, 0x0000003c15157220ULL, 0x080fe20000410000ULL,
0x0000003c24247220ULL, 0x080fe20000410000ULL, 0x0000003c25257220ULL, 0x080fe20000410000ULL,
0x0000003c28287220ULL, 0x080fe20000410000ULL, 0x0000003c29297220ULL, 0x080fe20000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000003c30307220ULL, 0x080fe20000410000ULL, 0x0000003c31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x00010dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f100c3c7589ULL, 0x0004e400000e0000ULL,
0x0000003c22227220ULL, 0x08cfe20000410000ULL, 0x0000003c23237220ULL, 0x080fe20000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003c16167220ULL, 0x080fe20000410000ULL, 0x0000003c17177220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x080fe20000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c32327220ULL, 0x080fe20000410000ULL, 0x0000003c33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff38ff7812ULL, 0x000fe2000780600fULL,
0x00000001ff0f7424ULL, 0x000fd800078e00ffULL, 0x8000000e37370221ULL, 0x000fe20000010000ULL,
0x00007610ff0f0816ULL, 0x000fc6000000000fULL, 0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL,
0x0000003700070308ULL, 0x000ea40000000800ULL, 0x0000000736360220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000d360d7221ULL, 0x002fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0xfffffff0023a7812ULL, 0x000fca00078ec0ffULL,
0x00f6b4003a377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003610397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e11ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011437ULL,
0x000000390c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x000000020c0c7819ULL, 0x000fc80000001237ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b4003a377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100f0c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080c7816ULL, 0x000fe20000000008ULL, 0x000109a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0c087589ULL, 0x0002a400000e0000ULL, 0x000000080f107810ULL, 0x000fe20007ffe0ffULL,
0x000109d27f007947ULL, 0x000fea000b800000ULL, 0x00001f100c097589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00006190003d7802ULL, 0x000fc40000000f00ULL,
0x000111e000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000cULL,
0x000061e0003d7802ULL, 0x000fc40000000f00ULL, 0x0001119000007944ULL, 0x006fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002045a7824ULL, 0x000fe200078e00ffULL,
0x00000007000c7812ULL, 0x04afe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008003d7812ULL, 0x000fc400078ec0ffULL, 0x000000045a0f7812ULL, 0x000fe400078ec0ffULL,
0x000000080c4c7812ULL, 0x000fe400078ef800ULL, 0x0000000f000f7211ULL, 0x000fc600078fe0ffULL,
0x000000084c377824ULL, 0x040fe400078e00ffULL, 0x000000014c4c7824ULL, 0x000fca00078e020fULL,
0xfffffff837377812ULL, 0x000fca00078ee24cULL, 0x0000001037377824ULL, 0x000fc600078e020aULL,
0x00000004040f7824ULL, 0x000fe200078e00ffULL, 0x0000000c3d3d7212ULL, 0x000fe200078efcffULL,
0x009800003740783bULL, 0x000e620000000200ULL, 0x0000100064717810ULL, 0x000fe20007ffe0ffULL,
0x000000080b557824ULL, 0x000fe200078e00ffULL, 0x000000040f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000083d107824ULL, 0x000fe200078e00ffULL, 0xfffffff85a5a7812ULL, 0x000fe400078ec0ffULL,
0x0000000f000c7211ULL, 0x000fca00078fe0ffULL, 0x000000013d0f7824ULL, 0x100fe400078e020cULL,
0x000000010b367824ULL, 0x000fc600078e020cULL, 0xfffffff810107812ULL, 0x000fe400078ee20fULL,
0x000000020f0f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff855557812ULL, 0x000fe200078ee236ULL,
0x0000001010617824ULL, 0x000fe200078e0271ULL, 0x0000000236367810ULL, 0x000fc60007ffe0ffULL,
0x0000001055387824ULL, 0x000fe200078e0271ULL, 0x000000006110783bULL, 0x000eea0000004200ULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x0000000840408231ULL, 0x086fe400003400ffULL,
0x0000000842428231ULL, 0x000fe400003400ffULL, 0x0000000941418231ULL, 0x000fc400003400ffULL,
0x0000000943438231ULL, 0x000fe200003400ffULL, 0x00000100103c7824ULL, 0x008fe200078e00ffULL,
0x00000010003e7306ULL, 0x000fe20000009400ULL, 0x00000018ff657819ULL, 0x000fc60000011410ULL,
0x00000018ff5d7819ULL, 0x000fe2000001143cULL, 0x00000100113c7824ULL, 0x000fc600078e00ffULL,
0x00000010003f7306ULL, 0x000e640000005400ULL, 0x00000018ff3c7819ULL, 0x000fcc000001143cULL,
0x0000001100637306ULL, 0x000ff00000009400ULL, 0x0000001100687306ULL, 0x000ea20000005400ULL,
0x0000003f3e00720bULL, 0x002fe20003f5d000ULL, 0x000000083d3e7824ULL, 0x000fca00078e00ffULL,
0xfffffff83e0f7812ULL, 0x000fe200078ee20fULL, 0x0000005d00577306ULL, 0x000fe20000209400ULL,
0x0000003c003e7245ULL, 0x000fce000020d400ULL, 0x0000005d005e7306ULL, 0x0002e20000205400ULL,
0x000000686300720bULL, 0x004fce0003f9d000ULL, 0x0000003c00677306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x002fce000020d400ULL, 0x0000003c006c7306ULL, 0x0002a20000205400ULL,
0x0000005e5700720bULL, 0x008fe40003f7d000ULL, 0x00000018ff577819ULL, 0x000fca0000011411ULL,
0x0000001000527306ULL, 0x000722000000d400ULL, 0x000000100f3c7824ULL, 0x002fca00078e0271ULL,
0x000000015d5d3812ULL, 0x000fe400078efcffULL, 0x0000001100537306ULL, 0x000262000000d400ULL,
0x0000006c6700720bULL, 0x004fe20003fbd000ULL, 0x0001000010107824ULL, 0x008fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005700637306ULL, 0x000fe20000209400ULL,
0x0000000152522812ULL, 0x010fe200078efcffULL, 0x0001000011117824ULL, 0x002fc600078e00ffULL,
0x000000525d52723eULL, 0x000fe400000010ffULL, 0x000000013e3e5812ULL, 0x000fe200078efcffULL,
0x0000005700677306ULL, 0x0002a20000205400ULL, 0x0000000153534812ULL, 0x000fe400078efcffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x000000533e53723eULL, 0x000fe400000010ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011412ULL, 0x0000001100687306ULL, 0x000fe20000209400ULL,
0x0000005700577245ULL, 0x002fe2000020d400ULL, 0x000000003c3c783bULL, 0x000e640000004200ULL,
0x000000524020723cULL, 0x000b680000041820ULL, 0x0000001100537306ULL, 0x0207220000205400ULL,
0x000000676300720bULL, 0x004fe20003fbd000ULL, 0x0000010013677824ULL, 0x000fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x00000010006b7306ULL, 0x000fe20000209400ULL,
0x0000001100117245ULL, 0x008fca000020d400ULL, 0x0000000157575812ULL, 0x000fe400078efcffULL,
0x00000010006c7306ULL, 0x0004e20000205400ULL, 0x000000536800720bULL, 0x010fe40003f9d000ULL,
0x0000006500537245ULL, 0x000fca000020d400ULL, 0x0000006500667306ULL, 0x000fe20000209400ULL,
0x0000001000107245ULL, 0x004fca000020d400ULL, 0x0000000111114812ULL, 0x000fe400078efcffULL,
0x00000065005e7306ULL, 0x0005220000205400ULL, 0x0000006c6b00720bULL, 0x008fe40003f5d000ULL,
0x000000115711723eULL, 0x000fca00000010ffULL, 0x0000001200587306ULL, 0x000fe20000009400ULL,
0x0000010012657824ULL, 0x004fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000012005f7306ULL, 0x000ea20000005400ULL, 0x0000005e6600720bULL, 0x010fe40003f7d000ULL,
0x00000018ff5e7819ULL, 0x000fe40000011413ULL, 0x0000000110102812ULL, 0x000fc600078efcffULL,
0x0000006500687306ULL, 0x000fec0000209400ULL, 0x0000000153533812ULL, 0x000fe400078efcffULL,
0x00000065006b7306ULL, 0x0007220000205400ULL, 0x0000005f5800720bULL, 0x004fe20003fdd000ULL,
0x00010000125f7824ULL, 0x000fe200078e00ffULL, 0x000000105310723eULL, 0x000fc800000010ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000005d006f7306ULL, 0x000fe20000209400ULL,
0x0000006500657245ULL, 0x008fe2000020d400ULL, 0x00000010401c723cULL, 0x000bec000004181cULL,
0x0000005d00707306ULL, 0x0004e20000205400ULL, 0x0000006b6800720bULL, 0x010fe20003f9d000ULL,
0x0001000013687824ULL, 0x000fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x00000067006c7306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x004fca000020d400ULL,
0x0000000165654812ULL, 0x000fe400078efcffULL, 0x00000067006d7306ULL, 0x000ea20000205400ULL,
0x000000706f00720bULL, 0x008fce0003f7d000ULL, 0x0000001300547306ULL, 0x000fec0000009400ULL,
0x000000015d5d3812ULL, 0x000fe400078efcffULL, 0x0000001300597306ULL, 0x000ee20000005400ULL,
0x0000006d6c00720bULL, 0x004fce0003fbd000ULL, 0x00000012005c7306ULL, 0x000eb0000000d400ULL,
0x0000005e00667306ULL, 0x000fe20000209400ULL, 0x000000595400720bULL, 0x008fce0003f5d000ULL,
0x0000005e00637306ULL, 0x000ee20000205400ULL, 0x000000015c5c6812ULL, 0x004fc800078efcffULL,
0x0000005c6510723eULL, 0x020fc600000010ffULL, 0x00000013005b7306ULL, 0x000eb0000000d400ULL,
0x0000005f006b7306ULL, 0x000fe20000209400ULL, 0x000000636600720bULL, 0x008fe40003fdd000ULL,
0x0000006700667245ULL, 0x000fc8000020d400ULL, 0x0000000166665812ULL, 0x000fe200078efcffULL,
0x0000005f006c7306ULL, 0x000ee20000205400ULL, 0x000000015b5b2812ULL, 0x004fc800078efcffULL,
0x0000005b6611723eULL, 0x000fe400000010ffULL, 0x0000005e00667245ULL, 0x000fe2000020d400ULL,
0x00000068006d7306ULL, 0x000fe60000209400ULL, 0x0000000166666812ULL, 0x000fe200078efcffULL,
0x000000104018723cULL, 0x000b680000041818ULL, 0x0000006800707306ULL, 0x000ea20000205400ULL,
0x0000006c6b00720bULL, 0x008fc40003f5d000ULL, 0x0000005f00107245ULL, 0x020fe4000020d400ULL,
0x0000006800117245ULL, 0x000fe4000020d400ULL, 0x00000018ff5f7819ULL, 0x002fe2000001143cULL,
0x0000003c00527306ULL, 0x000fec0000009400ULL, 0x0000000110102812ULL, 0x000fc400078efcffULL,
0x000000706d00720bULL, 0x004fe20003f9d000ULL, 0x0000003c00577306ULL, 0x000e620000005400ULL,
0x000000105d10723eULL, 0x000fce00000010ffULL, 0x0000005f00637306ULL, 0x000fe80000209400ULL,
0x0000000111114812ULL, 0x000fc800078efcffULL, 0x000000116611723eULL, 0x000fe200000010ffULL,
0x0000005f006c7306ULL, 0x000ea20000205400ULL, 0x000000575200720bULL, 0x002fca0003fdd000ULL,
0x000000104014723cULL, 0x000be40000041814ULL, 0x0000003d00587306ULL, 0x000fea0000009400ULL,
0x000001003c117824ULL, 0x020fe400078e00ffULL, 0x000001003d107824ULL, 0x000fe200078e00ffULL,
0x0000003d00597306ULL, 0x000e620000005400ULL, 0x0000006c6300720bULL, 0x004fc40003f5d000ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff637819ULL, 0x000fe2000001143dULL, 0x0000001100657306ULL, 0x000ff00000209400ULL,
0x0000001100687306ULL, 0x0004e20000205400ULL, 0x000000595800720bULL, 0x002fc40003fbd000ULL,
0x0000001100587245ULL, 0x000fca000020d400ULL, 0x0000001000667306ULL, 0x000fe20000209400ULL,
0x0000001000117245ULL, 0x004fce000020d400ULL, 0x0000001000577306ULL, 0x000e620000205400ULL,
0x000000686500720bULL, 0x008fe20003f7d000ULL, 0x000100003c657824ULL, 0x000fca00078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000003d00547306ULL, 0x0004ec000000d400ULL,
0x0000000158583812ULL, 0x000fe400078efcffULL, 0x0000003c00537306ULL, 0x000f22000000d400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000576600720bULL, 0x002fc80003f9d000ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006500527306ULL, 0x000fe20000209400ULL,
0x0000000154545812ULL, 0x008fcc00078efcffULL, 0x0000000111114812ULL, 0x000fe200078efcffULL,
0x0000006500577306ULL, 0x000e620000205400ULL, 0x0000000153536812ULL, 0x010fe400078efcffULL,
0x000000541111723eULL, 0x000fe400000010ffULL, 0x000000535810723eULL, 0x000fe400000010ffULL,
0x00000018ff547819ULL, 0x000fe20000011439ULL, 0x0000006300597306ULL, 0x000fe80000209400ULL,
0x000000104024723cULL, 0x000be80000041824ULL, 0x0000006300687306ULL, 0x000ea20000205400ULL,
0x000000575200720bULL, 0x002fc40003fdd000ULL, 0x0000005f00117245ULL, 0x020fe4000020d400ULL,
0x0000006500107245ULL, 0x000fe4000020d400ULL, 0x0000000111112812ULL, 0x000fe200078efcffULL,
0x0000003d003c7306ULL, 0x000fec0000209400ULL, 0x0000000110106812ULL, 0x000fc400078efcffULL,
0x0000003d00677306ULL, 0x0002e20000205400ULL, 0x000000685900720bULL, 0x004fe40003f7d000ULL,
0x0000006300687245ULL, 0x000fe4000020d400ULL, 0x000000101110723eULL, 0x000fe400000010ffULL,
0x00000018ff597819ULL, 0x000fe20000011438ULL, 0x0000003e00127306ULL, 0x000fe20000009400ULL,
0x0000003d003d7245ULL, 0x002fca000020d400ULL, 0x0000000168683812ULL, 0x000fe400078efcffULL,
0x000000673c00720bULL, 0x008fe20003f9d000ULL, 0x0000003e00137306ULL, 0x000e620000005400ULL,
0x00000018ff3c7819ULL, 0x000fce000001143eULL, 0x0000003f005c7306ULL, 0x000fe80000009400ULL,
0x000000013d3d4812ULL, 0x000fc800078efcffULL, 0x0000003f005e7306ULL, 0x000ea20000005400ULL,
0x0000003d6811723eULL, 0x000fe400000010ffULL, 0x000000131200720bULL, 0x002fe20003fbd000ULL,
0x000001003f127824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc6000001143fULL,
0x000000104028723cULL, 0x000b620000041828ULL, 0x0000003c005f7306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x000fca0000011412ULL, 0x000001003e117824ULL, 0x020fe200078e00ffULL,
0x0000005e5c00720bULL, 0x004fe20003f7d000ULL, 0x0000003c00667306ULL, 0x000e620000205400ULL,
0x000100003e5e7824ULL, 0x000fe400078e00ffULL, 0x00000018ff117819ULL, 0x000fc60000011411ULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000001100657306ULL, 0x000ff00000209400ULL,
0x00000011005c7306ULL, 0x0004e20000205400ULL, 0x000000665f00720bULL, 0x002fe20003f5d000ULL,
0x000100003f5f7824ULL, 0x000fe200078e00ffULL, 0x0000001100667245ULL, 0x000fc8000020d400ULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000003e005b7306ULL, 0x000e62000000d400ULL,
0x000000080b117824ULL, 0x004fca00078e00ffULL, 0xfffffff811367812ULL, 0x000fe400078ee236ULL,
0x0000001200677306ULL, 0x000fe20000209400ULL, 0x0000005c6500720bULL, 0x008fce0003fdd000ULL,
0x00000012003e7306ULL, 0x0004e20000205400ULL, 0x000000015b5b5812ULL, 0x002fca00078efcffULL,
0x0000000166666812ULL, 0x000fe400078efcffULL, 0x0000003f005d7306ULL, 0x000e62000000d400ULL,
0x0000001200127245ULL, 0x004fce000020d400ULL, 0x0000003d00637306ULL, 0x000fe20000209400ULL,
0x0000003e6700720bULL, 0x008fe40003f9d000ULL, 0x00000018ff3e7819ULL, 0x000fca000001143aULL,
0x0000003d00107306ULL, 0x000ea20000205400ULL, 0x000000015d5d3812ULL, 0x002fca00078efcffULL,
0x0000000112124812ULL, 0x000fe400078efcffULL, 0x0000005e00137306ULL, 0x000fe40000209400ULL,
0x0000005d1211723eULL, 0x000fe200000010ffULL, 0x0000001036127824ULL, 0x000fca00078e0271ULL,
0x0000005e005c7306ULL, 0x000e620000205400ULL, 0x000000106300720bULL, 0x004fe40003fbd000ULL,
0x0000005b6610723eULL, 0x000fe400000010ffULL, 0x0000003c00637245ULL, 0x000fe4000020d400ULL,
0x0000003d00667245ULL, 0x000fe2000020d400ULL, 0x0000005f00657306ULL, 0x000fe20000209400ULL,
0x0000005e003c7245ULL, 0x000fe2000020d400ULL, 0x00000010402c723cULL, 0x000b62000004182cULL,
0x0000005f003d7245ULL, 0x000fc4000020d400ULL, 0x0000000163632812ULL, 0x000fe400078efcffULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x0000005f00687306ULL, 0x0004e20000205400ULL,
0x0000005c1300720bULL, 0x002fe40003f7d000ULL, 0x000000001210783bULL, 0x020fe20000004200ULL,
0x00000018ff5c7819ULL, 0x000fc8000001143bULL, 0x00000038004b7306ULL, 0x000fe20000009400ULL,
0x00000100385f7824ULL, 0x004fca00078e00ffULL, 0x000000013c3c3812ULL, 0x000fe400078efcffULL,
0x000000686500720bULL, 0x008fe20003f9d000ULL, 0x00000038004d7306ULL, 0x000e620000005400ULL,
0x0000003c633c723eULL, 0x000fe400000010ffULL, 0x00000018ff5f7819ULL, 0x000fca000001145fULL,
0x00000039004f7306ULL, 0x000fe80000009400ULL, 0x000000013d3d4812ULL, 0x000fc800078efcffULL,
0x0000003d663d723eULL, 0x000fe200000010ffULL, 0x0000003900507306ULL, 0x000ea20000005400ULL,
0x0000004d4b00720bULL, 0x002fca0003f5d000ULL, 0x0000003c4040723cULL, 0x000b640000041830ULL,
0x0000005f00667306ULL, 0x000fea0000209400ULL, 0x0000010039307824ULL, 0x020fc600078e00ffULL,
0x0000005f003d7306ULL, 0x0002e20000205400ULL, 0x000000504f00720bULL, 0x004fe40003f9d000ULL,
0x00000018ff3c7819ULL, 0x000fe40000011430ULL, 0x009800004430783bULL, 0x000ea60000000200ULL,
0x0000003c00677306ULL, 0x000fe20000209400ULL, 0x0000005f005f7245ULL, 0x002fce000020d400ULL,
0x0000003c00687306ULL, 0x0003220000205400ULL, 0x0000003d6600720bULL, 0x008fce0003f7d000ULL,
0x00000038004e7306ULL, 0x000ee2000000d400ULL, 0x0000003c003c7245ULL, 0x002fca000020d400ULL,
0x000000015f5f3812ULL, 0x000fe400078efcffULL, 0x0000003900517306ULL, 0x000e62000000d400ULL,
0x000000686700720bULL, 0x010fce0003fbd000ULL, 0x0000003a00457306ULL, 0x000fe20000009400ULL,
0x000000014e4e2812ULL, 0x008fc800078efcffULL, 0x0000004e5f4e723eULL, 0x000fe200000010ffULL,
0x00010000385f7824ULL, 0x000fe200078e00ffULL, 0x000000013c3c5812ULL, 0x000fe200078efcffULL,
0x0000003a00467306ULL, 0x000ee20000005400ULL, 0x0000000151514812ULL, 0x002fe200078efcffULL,
0x0000000830308231ULL, 0x084fe200003400ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000000832328231ULL, 0x000fe200003400ffULL, 0x000000513c4f723eULL, 0x000fe200000010ffULL,
0x0000000931318231ULL, 0x080fe400003400ffULL, 0x0000005900527306ULL, 0x000fe20000209400ULL,
0x0000000933338231ULL, 0x000fce00003400ffULL, 0x0000005900537306ULL, 0x000e620000205400ULL,
0x000000464500720bULL, 0x008fe20003f9d000ULL, 0x0000004e3020723cULL, 0x000b6c0000041820ULL,
0x0000005f00457306ULL, 0x000fe20000209400ULL, 0x00010000394f7824ULL, 0x020fca00078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000005f00467306ULL, 0x000ea20000205400ULL,
0x000000535200720bULL, 0x002fce0003f7d000ULL, 0x0000003b00487306ULL, 0x000ff00000009400ULL,
0x0000003b00497306ULL, 0x000e620000005400ULL, 0x000000464500720bULL, 0x004fe20003fdd000ULL,
0x000100003a467824ULL, 0x000fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000003e003f7306ULL, 0x000ff00000209400ULL, 0x0000003e005b7306ULL, 0x000ea20000205400ULL,
0x000000494800720bULL, 0x002fe20003f5d000ULL, 0x000001003a497824ULL, 0x000fc400078e00ffULL,
0x000001003b487824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000004f00677306ULL, 0x000fe20000209400ULL, 0x00000018ff487819ULL, 0x000fce0000011448ULL,
0x0000004f00527306ULL, 0x000e620000205400ULL, 0x0000005b3f00720bULL, 0x004fe40003fbd000ULL,
0x0000005f005b7245ULL, 0x000fe4000020d400ULL, 0x00000059005f7245ULL, 0x000fe4000020d400ULL,
0x000000015b5b6812ULL, 0x000fe200078efcffULL, 0x0000005400587306ULL, 0x000fe20000209400ULL,
0x000000015f5f3812ULL, 0x000fe400078efcffULL, 0x00000018ff3f7819ULL, 0x000fca0000011411ULL,
0x0000005400577306ULL, 0x000ea20000205400ULL, 0x000000526700720bULL, 0x002fe40003fdd000ULL,
0x0000005400677245ULL, 0x000fe4000020d400ULL, 0x00000018ff527819ULL, 0x000fc60000011410ULL,
0x0000005c005d7306ULL, 0x000ff00000209400ULL, 0x0000005c005e7306ULL, 0x0002e20000205400ULL,
0x000000575800720bULL, 0x004fe20003f1d000ULL, 0x000100003b577824ULL, 0x000fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000004900537306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x002fca000020d400ULL, 0x0000000167670812ULL, 0x000fe400078efcffULL,
0x00000049006c7306ULL, 0x000e620000205400ULL, 0x0000005e5d00720bULL, 0x008fe40003f7d000ULL,
0x0000004f005d7245ULL, 0x000fc8000020d400ULL, 0x000000015d5d6812ULL, 0x000fe200078efcffULL,
0x0000001000657306ULL, 0x000fec0000009400ULL, 0x000000015c5c3812ULL, 0x000fe400078efcffULL,
0x0000001000637306ULL, 0x000ea20000005400ULL, 0x0000006c5300720bULL, 0x002fce0003fdd000ULL,
0x0000003a00477306ULL, 0x000e70000000d400ULL, 0x0000004800397306ULL, 0x000fe20000209400ULL,
0x000000636500720bULL, 0x004fe40003f1d000ULL, 0x0000004900637245ULL, 0x000fc4000020d400ULL,
0x0000004800657245ULL, 0x000fe4000020d400ULL, 0x0000000163636812ULL, 0x000fe200078efcffULL,
0x00000048003a7306ULL, 0x000ea20000205400ULL, 0x0000000147474812ULL, 0x002fce00078efcffULL,
0x0000004600457306ULL, 0x000ff00000209400ULL, 0x00000046006b7306ULL, 0x000e620000205400ULL,
0x0000003a3900720bULL, 0x004fe40003fdd000ULL, 0x00000018ff397819ULL, 0x000fc40000011412ULL,
0x00000018ff3a7819ULL, 0x000fc60000011413ULL, 0x00000011004b7306ULL, 0x000fec0000009400ULL,
0x0000000165656812ULL, 0x000fe400078efcffULL, 0x0000001100667306ULL, 0x000ea20000005400ULL,
0x0000006b4500720bULL, 0x002fe20003fdd000ULL, 0x00010000106b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000003b004a7306ULL, 0x000e70000000d400ULL,
0x00000012004d7306ULL, 0x000fe20000009400ULL, 0x000000664b00720bULL, 0x004fe20003f9d000ULL,
0x00000100104b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000001200507306ULL, 0x000ea20000005400ULL, 0x000000014a4a2812ULL, 0x002fce00078efcffULL,
0x0000005700587306ULL, 0x000ff00000209400ULL, 0x0000005700687306ULL, 0x000e620000205400ULL,
0x000000504d00720bULL, 0x004fe40003f5d000ULL, 0x0000004600507245ULL, 0x000fe2000020d400ULL,
0x0000010011467824ULL, 0x000fc600078e00ffULL, 0x0000000150506812ULL, 0x000fe200078efcffULL,
0x0000001300517306ULL, 0x000fe20000009400ULL, 0x00000018ff467819ULL, 0x000fce0000011446ULL,
0x00000013004e7306ULL, 0x000ea20000005400ULL, 0x000000685800720bULL, 0x002fe40003fdd000ULL,
0x0000003e00587245ULL, 0x000fc8000020d400ULL, 0x0000000158585812ULL, 0x000fe200078efcffULL,
0x0000004b004d7306ULL, 0x000ff00000209400ULL, 0x0000004b00547306ULL, 0x000e620000205400ULL,
0x0000004e5100720bULL, 0x004fc40003fbd000ULL, 0x00000057004e7245ULL, 0x000fe4000020d400ULL,
0x0000004b00517245ULL, 0x000fe4000020d400ULL, 0x000000014e4e6812ULL, 0x000fe200078efcffULL,
0x0000005200597306ULL, 0x000ff00000209400ULL, 0x00000052005e7306ULL, 0x0004e20000205400ULL,
0x000000544d00720bULL, 0x002fe20003fdd000ULL, 0x00010000114d7824ULL, 0x000fc400078e00ffULL,
0x0000010012547824ULL, 0x000fc800078e00ffULL, 0x00000046003e7306ULL, 0x000fe20000209400ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005200527245ULL, 0x004fc6000020d400ULL,
0x0000000151516812ULL, 0x000fe400078efcffULL, 0x00000046006d7306ULL, 0x000e620000205400ULL,
0x0000005e5900720bULL, 0x008fe40003f7d000ULL, 0x00000018ff5e7819ULL, 0x000fca000001144dULL,
0x0000001000447306ULL, 0x000eac000000d400ULL, 0x0000000152523812ULL, 0x000fe400078efcffULL,
0x0000003f003b7306ULL, 0x000fe20000209400ULL, 0x0000006d3e00720bULL, 0x002fce0003fdd000ULL,
0x0000003f00497306ULL, 0x000e620000205400ULL, 0x0000000144440812ULL, 0x004fc800078efcffULL,
0x000000445144723eULL, 0x000fc600000010ffULL, 0x00000011003d7306ULL, 0x000eb0000000d400ULL,
0x0000006b00107306ULL, 0x000fe20000209400ULL, 0x000000493b00720bULL, 0x002fe20003f1d000ULL,
0x00000100133b7824ULL, 0x000fe200078e00ffULL, 0x0000004600497245ULL, 0x000fc8000020d400ULL,
0x0000000149496812ULL, 0x000fe200078efcffULL, 0x0000006b00117306ULL, 0x000e620000205400ULL,
0x000000013d3d4812ULL, 0x004fe400078efcffULL, 0x00000018ff467819ULL, 0x000fe2000001143bULL,
0x00010000123b7824ULL, 0x000fc800078e00ffULL, 0x0000005e004b7306ULL, 0x000fe20000209400ULL,
0x00000018ff3b7819ULL, 0x000fce000001143bULL, 0x0000005e003e7306ULL, 0x0004e20000205400ULL,
0x000000111000720bULL, 0x002fe40003fdd000ULL, 0x000000476310723eULL, 0x000fe400000010ffULL,
0x0000006b00477245ULL, 0x000fe4000020d400ULL, 0x0000004a6511723eULL, 0x000fe200000010ffULL,
0x00000039004f7306ULL, 0x000fe20000209400ULL, 0x0000005e005e7245ULL, 0x004fca000020d400ULL,
0x0000000147476812ULL, 0x000fe200078efcffULL, 0x000000103018723cULL, 0x000b620000041818ULL,
0x0000003900537306ULL, 0x000e620000205400ULL, 0x0000003e4b00720bULL, 0x008fe20003f9d000ULL,
0x00010000133e7824ULL, 0x000fc800078e00ffULL, 0x0000003f00117245ULL, 0x020fe4000020d400ULL,
0x0000005400667306ULL, 0x000fe20000209400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000054003f7245ULL, 0x000fe4000020d400ULL, 0x0000000111110812ULL, 0x000fe400078efcffULL,
0x000000015e5e4812ULL, 0x000fe200078efcffULL, 0x0000005400687306ULL, 0x000ea20000205400ULL,
0x000000534f00720bULL, 0x002fc40003fdd000ULL, 0x000000475210723eULL, 0x000fe400000010ffULL,
0x0000005e1111723eULL, 0x000fe400000010ffULL, 0x0000003900397245ULL, 0x000fe2000020d400ULL,
0x00000012003c7306ULL, 0x0002e8000000d400ULL, 0x000000103028723cULL, 0x000b640000041828ULL,
0x0000000139396812ULL, 0x000fc400078efcffULL, 0x0000004600577306ULL, 0x000fe20000209400ULL,
0x000000686600720bULL, 0x004fe40003f7d000ULL, 0x0000005b5f12723eULL, 0x002fe400000010ffULL,
0x0000003b00107245ULL, 0x020fe4000020d400ULL, 0x0000003e00117245ULL, 0x000fe2000020d400ULL,
0x0000004600597306ULL, 0x000e620000205400ULL, 0x000000013c3c2812ULL, 0x008fca00078efcffULL,
0x000000013f3f3812ULL, 0x000fe400078efcffULL, 0x0000003a00457306ULL, 0x000fe40000209400ULL,
0x0000003c3f3c723eULL, 0x000fcc00000010ffULL, 0x0000003a00487306ULL, 0x0004e20000205400ULL,
0x000000595700720bULL, 0x002fce0003f1d000ULL, 0x0000003b004b7306ULL, 0x000fe20000209400ULL,
0x0000003a003a7245ULL, 0x004fce000020d400ULL, 0x0000003b004d7306ULL, 0x000e620000205400ULL,
0x000000484500720bULL, 0x008fe40003f9d000ULL, 0x0000003d4945723eULL, 0x000fe400000010ffULL,
0x00000046003d7245ULL, 0x000fc6000020d400ULL, 0x0000003e004a7306ULL, 0x000fe20000209400ULL,
0x000000013d3d0812ULL, 0x000fe200078efcffULL, 0x000000443024723cULL, 0x000f680000041824ULL,
0x000000013a3a4812ULL, 0x000fe400078efcffULL, 0x0000003e004f7306ULL, 0x000ea20000205400ULL,
0x0000004d4b00720bULL, 0x002fce0003f7d000ULL, 0x0000001300387306ULL, 0x0002ec000000d400ULL,
0x0000000110103812ULL, 0x000fe400078efcffULL, 0x0000004f4a00720bULL, 0x004fe40003f5d000ULL,
0x0000005d6713723eULL, 0x002fc400000010ffULL, 0x000000103910723eULL, 0x000fe400000010ffULL,
0x0000000138385812ULL, 0x008fc600078efcffULL, 0x00000012301c723cULL, 0x000b62000004181cULL,
0x000000383d3d723eULL, 0x000fc600000010ffULL, 0x0000000111112812ULL, 0x000fc600078efcffULL,
0x000000505812723eULL, 0x020fe400000010ffULL, 0x0000004e5c13723eULL, 0x000fe200000010ffULL,
0x0000003c302c723cULL, 0x000f62000004182cULL, 0x000000113a11723eULL, 0x000fce00000010ffULL,
0x000000123014723cULL, 0x040f700000041814ULL, 0x000000103030723cULL, 0x000b6e0000041840ULL,
0x0000f6c86e107811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f690005aff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff3a7224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x0000040005397984ULL, 0x000ee40000000800ULL,
0x8000000039ff7812ULL, 0x00afc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038123b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e13ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040005397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c056127810ULL, 0x000fca0007ffe0ffULL, 0x00006600733b7a24ULL, 0x000fe200078e0212ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x0000001269107217ULL, 0x000fe20007800000ULL,
0x0000001072137824ULL, 0x000fe200078e00ffULL, 0x00000003ff117819ULL, 0x000fc60000011600ULL,
0x0000000110107824ULL, 0x000fe200078e0a12ULL, 0x0000000411397810ULL, 0x000fe20007ffe0ffULL,
0x0000000113127824ULL, 0x000fe200078e0211ULL, 0x00000008113a7810ULL, 0x000fe40007ffe0ffULL,
0x0000001013107217ULL, 0x000fe20007800000ULL, 0x0000000112387824ULL, 0x040fe400078e0200ULL,
0x00000008123d7824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fc600078e0a13ULL,
0xfffffff83d3c7812ULL, 0x000fe200078ee238ULL, 0x0000000113387824ULL, 0x000fe200078e0239ULL,
0x000000101100720cULL, 0x0c0fe40003f86070ULL, 0x0000000c113d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112117824ULL, 0x000fe200078e023bULL, 0x000000103900720cULL, 0x080fe20003f66070ULL,
0x0000000138127824ULL, 0x000fe200078e0200ULL, 0x000000103a00720cULL, 0x080fe20003f46070ULL,
0x0000000838417824ULL, 0x000fe200078e00ffULL, 0x000000103d00720cULL, 0x000fe20003f06070ULL,
0x0000000113397824ULL, 0x000fc400078e023aULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0xfffffff8413e7812ULL, 0x000fc600078ee212ULL, 0x0000000138387824ULL, 0x000fe200078e023bULL,
0x0000006010107212ULL, 0x000fe200078efcffULL, 0x00000001133f7824ULL, 0x000fe400078e023dULL,
0x00000001393a7824ULL, 0x040fe200078e023bULL, 0x0000620010107a10ULL, 0x000fe20007fbe0ffULL,
0x0000000139137824ULL, 0x040fe400078e0200ULL, 0x0000000839407824ULL, 0x000fe200078e00ffULL,
0x0000630011117a10ULL, 0x000fe20002ffe4ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee213ULL, 0x000000013f127824ULL, 0x000fe200078e023bULL,
0x0000006038387212ULL, 0x000fe200078efcffULL, 0x000000803a3a7825ULL, 0x000fc600078e00ffULL,
0x0000620038387a10ULL, 0x000fe20007fbe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000603a3a7212ULL, 0x080fe400078efcffULL, 0x0000630039397a10ULL, 0x000fe20002ffe4ffULL,
0x000000013f3d7824ULL, 0x040fe200078e0200ULL, 0x0000006012127212ULL, 0x000fe200078efcffULL,
0x000000083f427824ULL, 0x000fe200078e00ffULL, 0x000062003a3a7a10ULL, 0x000fe20007fbe0ffULL,
0x000000103e3f7824ULL, 0x100fe200078e0271ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x0000001040417824ULL, 0x000fe200078e0271ULL, 0xfffffff842427812ULL, 0x000fe200078ee23dULL,
0x000000103c3d7824ULL, 0x000fe200078e0271ULL, 0x000063003b3b7a10ULL, 0x000fc40002ffe4ffULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x0000001042437824ULL, 0x000fe200078e0271ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103d7faeULL, 0x0003e8000e101c48ULL,
0x00000000383f7faeULL, 0x0003e8000d901c48ULL, 0x000000003a417faeULL, 0x0003e8000d101c48ULL,
0x0000000012437faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001072117824ULL, 0x000fca00078e00ffULL, 0x0000001100117211ULL, 0x000fc800078fe8ffULL,
0x0000000411387810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x140fe200078e0200ULL,
0x00000008113a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000811397824ULL, 0x000fe400078e00ffULL,
0x0000000138127824ULL, 0x040fe400078e0200ULL, 0x00000008383d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8393c7812ULL, 0x000fe200078ee210ULL, 0x000000013a137824ULL, 0x040fe400078e0200ULL,
0x000000083a407824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3e7812ULL, 0x000fe200078ee212ULL,
0x0000000111127824ULL, 0x140fe200078e023bULL, 0x0000000c11117810ULL, 0x000fe20007ffe0ffULL,
0x0000000138387824ULL, 0x000fe200078e023bULL, 0xfffffff840407812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000013a3a7824ULL, 0x100fe200078e023bULL,
0x0000006012127212ULL, 0x000fe200078efcffULL, 0x0000000111107824ULL, 0x000fe400078e023bULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc60007f1e0ffULL,
0x00000001113d7824ULL, 0x040fe200078e0200ULL, 0x0000006038387212ULL, 0x080fe200078efcffULL,
0x0000000811427824ULL, 0x000fe200078e00ffULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000620038387a10ULL, 0x000fe40007f5e0ffULL,
0xfffffff842427812ULL, 0x000fe200078ee23dULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000603a3a7212ULL, 0x080fe400078efcffULL, 0x0000630039397a10ULL, 0x000fe200017fe4ffULL,
0x000000103c3d7824ULL, 0x100fe200078e0271ULL, 0x0000006010107212ULL, 0x000fe200078efcffULL,
0x000000103e3f7824ULL, 0x100fe200078e0271ULL, 0x000062003a3a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000001040417824ULL, 0x100fe200078e0271ULL, 0x0000620010107a10ULL, 0x000fe20007f7e0ffULL,
0x0000001042437824ULL, 0x000fe200078e0271ULL, 0x000063003b3b7a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123d7faeULL, 0x0003e2000b901c48ULL,
0x0000630011117a10ULL, 0x000fc60001ffe4ffULL, 0x00000000383f7faeULL, 0x0003e8000b901c48ULL,
0x000000003a417faeULL, 0x0003e8000b901c48ULL, 0x0000000010437faeULL, 0x0003e4000b901c48ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff002387812ULL, 0x000fce00078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b00038387f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480006107f8cULL, 0x0006a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0xffffffe002067812ULL, 0x048fe400078ec0ffULL, 0x00000010023b7812ULL, 0x040fe400078ec0ffULL,
0x00000008023a7812ULL, 0x000fc800078ec0ffULL, 0x000000063a067210ULL, 0x000fca0007ffe03bULL,
0x00f64c00063b7984ULL, 0x000ee40000000800ULL, 0x800000003bff7812ULL, 0x00cfe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a123d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e13ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c00063b7984ULL, 0x000ea40000000800ULL,
0x800000003bff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002004067824ULL, 0x000fca00078e00ffULL, 0xffffff8006117812ULL, 0x000fc800078ec0ffULL,
0x0000010060117810ULL, 0x000fca0007ffe011ULL, 0x0000000162117824ULL, 0x000fca00078e0211ULL,
0x00f0000011137984ULL, 0x000ea80000000800ULL, 0x00f2000011127984ULL, 0x0006620000000800ULL,
0x0000000e1300720bULL, 0x004fe20003f1d000ULL, 0x0000dc727f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c3b7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fd200078e000eULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000275117810ULL, 0x000fe40007ffe0ffULL, 0x0000000e1300720bULL, 0x000fe40003f54000ULL,
0x000000041100720cULL, 0x000fe20003f05270ULL, 0x0000dc127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000067806ULL, 0x000fc400010e0100ULL, 0x0000008004118824ULL, 0x000fe200078e0260ULL,
0x0000000e13108209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001623d8824ULL, 0x000fe200078e0211ULL, 0x0000991006117816ULL, 0x000fc800000000ffULL,
0x00f400103d008388ULL, 0x0005e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000e13117209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff06ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000e11107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x00000010003a7308ULL, 0x000ea40000000800ULL, 0x0000003a0d0d7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x0000db327f007947ULL, 0x000fea000b800000ULL, 0x00001f103a3c7589ULL, 0x0004e400000e0000ULL,
0x0000003c20207220ULL, 0x08cfe20000410000ULL, 0x0000003c21217220ULL, 0x080fe20000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003c18187220ULL, 0x080fe20000410000ULL, 0x0000003c19197220ULL, 0x080fe20000410000ULL,
0x0000003c14147220ULL, 0x080fe20000410000ULL, 0x0000003c15157220ULL, 0x080fe20000410000ULL,
0x0000003c24247220ULL, 0x080fe20000410000ULL, 0x0000003c25257220ULL, 0x080fe20000410000ULL,
0x0000003c28287220ULL, 0x080fe20000410000ULL, 0x0000003c29297220ULL, 0x080fe20000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000003c30307220ULL, 0x080fe20000410000ULL, 0x0000003c31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0006ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x0000da127f007947ULL, 0x000fea000b800000ULL, 0x00001f103a3c7589ULL, 0x0004e400000e0000ULL,
0x0000003c22227220ULL, 0x08cfe20000410000ULL, 0x0000003c23237220ULL, 0x080fe20000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003c16167220ULL, 0x080fe20000410000ULL, 0x0000003c17177220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x080fe20000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c32327220ULL, 0x080fe20000410000ULL, 0x0000003c33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe20007806006ULL,
0x00000001ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000e13067209ULL, 0x000fd60007810000ULL,
0x8000000613130221ULL, 0x000fe20000010000ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x0000001300070308ULL, 0x000ea40000000800ULL,
0x0000000712120220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d12127221ULL, 0x002fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0xfffffff0023d7812ULL, 0x000fca00078ec0ffULL, 0x00f6ac003d0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a100e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3a7824ULL, 0x000fe200000e0e11ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc8000001143aULL, 0x0000000e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e063aULL, 0x000000020d0d7819ULL, 0x000fc8000000120eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac003d0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099103c0d7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011600ULL, 0x00005410080d7816ULL, 0x000fe20000000008ULL,
0x0000d5d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0e0d087589ULL, 0x0002a400000e0000ULL,
0x000000080e107810ULL, 0x000fe20007ffe0ffULL, 0x0000d6027f007947ULL, 0x000fea000b800000ULL,
0x00001f100d097589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100e107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000dULL,
0x00009720003d7802ULL, 0x000fc40000000f00ULL, 0x0000dc5000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180e107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000dULL, 0x00009770003d7802ULL, 0x000fc40000000f00ULL,
0x0000dc0000007944ULL, 0x006fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100f447824ULL, 0x100fe200078e0264ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001036407824ULL, 0x000fc400078e0264ULL, 0x00a000003734783bULL, 0x000f220000000200ULL,
0x00000010553c7824ULL, 0x004fc600078e0264ULL, 0x000000004444783bULL, 0x000ea80000004200ULL,
0x000000004040783bULL, 0x000ee80000004200ULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x0000000834348231ULL, 0x090fe400003400ffULL, 0x0000000836368231ULL, 0x000fe200003400ffULL,
0x00000100440e7824ULL, 0x006fe200078e00ffULL, 0x00000044000d7306ULL, 0x008fe20000009400ULL,
0x0000000935358231ULL, 0x000fc400003400ffULL, 0x0000000937378231ULL, 0x000fe200003400ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001140eULL, 0x00000100450e7824ULL, 0x000fc600078e00ffULL,
0x00000044004a7306ULL, 0x000e640000005400ULL, 0x00000018ff5d7819ULL, 0x000fcc000001140eULL,
0x0000004500577306ULL, 0x000ff00000009400ULL, 0x00000045005a7306ULL, 0x000ea20000005400ULL,
0x0000004a0d00720bULL, 0x002fe40003f5d000ULL, 0x0000005d004a7245ULL, 0x000fca000020d400ULL,
0x0000004b000f7306ULL, 0x000ff00000209400ULL, 0x0000004b00587306ULL, 0x0002e20000205400ULL,
0x0000005a5700720bULL, 0x004fce0003f9d000ULL, 0x0000005d00677306ULL, 0x000fe20000209400ULL,
0x0000004b004b7245ULL, 0x002fce000020d400ULL, 0x0000005d006c7306ULL, 0x000e620000205400ULL,
0x000000580f00720bULL, 0x008fce0003f7d000ULL, 0x0000004400487306ULL, 0x000eac000000d400ULL,
0x000000014b4b3812ULL, 0x000fe400078efcffULL, 0x0000004500497306ULL, 0x000ee2000000d400ULL,
0x0000006c6700720bULL, 0x002fe40003fbd000ULL, 0x0000000148482812ULL, 0x004fca00078efcffULL,
0x0000004600657306ULL, 0x000fe20000009400ULL, 0x000000484b48723eULL, 0x000fca00000010ffULL,
0x000000014a4a5812ULL, 0x000fe400078efcffULL, 0x0000000149494812ULL, 0x008fe200078efcffULL,
0x0000004600667306ULL, 0x000e660000005400ULL, 0x000000494a49723eULL, 0x000fca00000010ffULL,
0x0000004700687306ULL, 0x000fe40000009400ULL, 0x000000483448723cULL, 0x000b6c0000041824ULL,
0x00000047005f7306ULL, 0x000ea20000005400ULL, 0x0001000044277824ULL, 0x020fe200078e00ffULL,
0x000000666500720bULL, 0x002fe20003f9d000ULL, 0x0001000045267824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011444ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000004000597306ULL, 0x000fe20000009400ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff257819ULL, 0x000fe20000011445ULL, 0x0000010046457824ULL, 0x000fc800078e00ffULL,
0x00000040005e7306ULL, 0x000e620000005400ULL, 0x0000005f6800720bULL, 0x004fe40003fbd000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000002500687245ULL, 0x000fc6000020d400ULL,
0x00000027006b7306ULL, 0x000ff00000209400ULL, 0x0000002700667306ULL, 0x0004e20000205400ULL,
0x0000005e5900720bULL, 0x002fce0003f5d000ULL, 0x0000002400677306ULL, 0x000fe20000209400ULL,
0x0000002700277245ULL, 0x004fce000020d400ULL, 0x00000024006c7306ULL, 0x0002a20000205400ULL,
0x000000666b00720bULL, 0x008fce0003fdd000ULL, 0x00000026005f7306ULL, 0x000fe20000209400ULL,
0x0000002400247245ULL, 0x002fca000020d400ULL, 0x0000000127276812ULL, 0x000fe400078efcffULL,
0x00000026005e7306ULL, 0x000e620000205400ULL, 0x0000006c6700720bULL, 0x004fe40003f7d000ULL,
0x0000002600677245ULL, 0x000fca000020d400ULL, 0x0000002500447306ULL, 0x000fec0000209400ULL,
0x0000000124243812ULL, 0x000fe400078efcffULL, 0x0000002500597306ULL, 0x000ea20000205400ULL,
0x0000005e5f00720bULL, 0x002fe40003fdd000ULL, 0x000000272424723eULL, 0x000fca00000010ffULL,
0x0000004500657306ULL, 0x000fec0000209400ULL, 0x0000000167676812ULL, 0x000fe400078efcffULL,
0x0000004500667306ULL, 0x000e620000205400ULL, 0x000000594400720bULL, 0x004fe20003f7d000ULL,
0x0000010047447824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fc80000011446ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000004600637306ULL, 0x000eac000000d400ULL,
0x0000000168683812ULL, 0x000fe400078efcffULL, 0x000000666500720bULL, 0x002fe20003fdd000ULL,
0x0000004400267306ULL, 0x000fe20000209400ULL, 0x000000676825723eULL, 0x000fe200000010ffULL,
0x0001000046677824ULL, 0x000fe200078e00ffULL, 0x0000004500687245ULL, 0x000fc8000020d400ULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000004400657306ULL, 0x000e620000205400ULL,
0x0000000163634812ULL, 0x004fc600078efcffULL, 0x0000000168686812ULL, 0x000fc800078efcffULL,
0x00000047003a7306ULL, 0x000ea2000000d400ULL, 0x000000652600720bULL, 0x002fce0003fdd000ULL,
0x00000041005b7306ULL, 0x000fe20000009400ULL, 0x000000243424723cULL, 0x000b620000041828ULL,
0x00000018ff657819ULL, 0x000fe40000011440ULL, 0x000000013a3a5812ULL, 0x004fc800078efcffULL,
0x00000041005c7306ULL, 0x000e620000005400ULL, 0x0000000700297812ULL, 0x020fe400078ec0ffULL,
0x000000636828723eULL, 0x000fe200000010ffULL, 0x0001000047637824ULL, 0x000fe200078e00ffULL,
0x0000000829297812ULL, 0x000fc600078ef800ULL, 0x00000067002a7306ULL, 0x000fe20000209400ULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000000829467824ULL, 0x000fe200078e00ffULL,
0x000000024c297810ULL, 0x000fc80007ffe0ffULL, 0xfffffff846457812ULL, 0x000fe200078ee229ULL,
0x00000067002b7306ULL, 0x000ea20000205400ULL, 0x0000004400297245ULL, 0x000fe4000020d400ULL,
0x0000005c5b00720bULL, 0x002fe40003f7d000ULL, 0x0000000129296812ULL, 0x000fe400078efcffULL,
0x00000018ff5b7819ULL, 0x000fe20000011447ULL, 0x00000059005f7306ULL, 0x000fe20000209400ULL,
0x0000003a2929723eULL, 0x000fe200000010ffULL, 0x00000010453a7824ULL, 0x000fca00078e00ffULL,
0x0000a0000a447810ULL, 0x000fe20007ffe03aULL, 0x0000005900667306ULL, 0x000e620000205400ULL,
0x0000002b2a00720bULL, 0x004fe20003fbd000ULL, 0x00000100400a7824ULL, 0x040fe200078e00ffULL,
0x000000283428723cULL, 0x000b64000004182cULL, 0x000000004444783bULL, 0x000ea40000000200ULL,
0x00000018ff0a7819ULL, 0x000fe2000001140aULL, 0x0000006300687306ULL, 0x000fe40000209400ULL,
0x00000067002c7245ULL, 0x020fe2000020d400ULL, 0x0001000040677824ULL, 0x000fe200078e00ffULL,
0x00000059002d7245ULL, 0x000fc4000020d400ULL, 0x000000012c2c5812ULL, 0x000fe400078efcffULL,
0x00000063006d7306ULL, 0x0007220000205400ULL, 0x000000665f00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff677819ULL, 0x000fca0000011467ULL, 0x0000005b005c7306ULL, 0x000fe20000209400ULL,
0x0000006300637245ULL, 0x008fca000020d400ULL, 0x000000012d2d6812ULL, 0x000fe400078efcffULL,
0x0000005b006b7306ULL, 0x000e620000205400ULL, 0x0000006d6800720bULL, 0x010fe20003fbd000ULL,
0x0000010041687824ULL, 0x000fe200078e00ffULL, 0x0000002c2d2c723eULL, 0x000fc800000010ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x00000043000d7306ULL, 0x000fe20000009400ULL,
0x0000000844448231ULL, 0x004fca00003400ffULL, 0x0000000163635812ULL, 0x000fe200078efcffULL,
0x0000000846468231ULL, 0x000fe200003400ffULL, 0x00000043005a7306ULL, 0x000ea20000005400ULL,
0x0000006b5c00720bULL, 0x002fe20003fdd000ULL, 0x0000000945458231ULL, 0x080fe400003400ffULL,
0x0000000947478231ULL, 0x000fc800003400ffULL, 0x0000000a002f7306ULL, 0x000ff00000209400ULL,
0x0000000a00667306ULL, 0x000e620000205400ULL, 0x0000005a0d00720bULL, 0x004fe40003fbd000ULL,
0x0000005b005a7245ULL, 0x000fc4000020d400ULL, 0x0000000a000d7245ULL, 0x000fe4000020d400ULL,
0x000000015a5a6812ULL, 0x000fe200078efcffULL, 0x00000040000e7306ULL, 0x0004e6000000d400ULL,
0x000000635a2d723eULL, 0x000fe200000010ffULL, 0x0000010042637824ULL, 0x000fe200078e00ffULL,
0x000000662f00720bULL, 0x002fc60003fdd000ULL, 0x00000065002e7306ULL, 0x000fe20000209400ULL,
0x00000018ff667819ULL, 0x000fe20000011441ULL, 0x0001000041407824ULL, 0x004fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fc80000011463ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006500597306ULL, 0x0002a20000205400ULL, 0x000000010e0e2812ULL, 0x008fe400078efcffULL,
0x000000010d0d6812ULL, 0x000fca00078efcffULL, 0x00000066005f7306ULL, 0x000fe20000209400ULL,
0x0000000e0d0e723eULL, 0x000fe400000010ffULL, 0x00000008000d7812ULL, 0x000fe400078ec0ffULL,
0x0000006500657245ULL, 0x002fe4000020d400ULL, 0x000000070d0d7812ULL, 0x000fe200078ef800ULL,
0x00000066006c7306ULL, 0x0002e20000205400ULL, 0x000000592e00720bULL, 0x004fce0003f1d000ULL,
0x00000068005c7306ULL, 0x000fe20000209400ULL, 0x0000006600667245ULL, 0x002fca000020d400ULL,
0x0000000165650812ULL, 0x000fe400078efcffULL, 0x00000068005b7306ULL, 0x0002a20000205400ULL,
0x0000006c5f00720bULL, 0x008fce0003f5d000ULL, 0x00000041000f7306ULL, 0x000722000000d400ULL,
0x0000006800687245ULL, 0x002fca000020d400ULL, 0x0000000166662812ULL, 0x000fe400078efcffULL,
0x00000067000a7306ULL, 0x000fe20000209400ULL, 0x0000005b5c00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff417819ULL, 0x008fca000001143dULL, 0x00000067002f7306ULL, 0x000e620000205400ULL,
0x000000010f0f3812ULL, 0x010fca00078efcffULL, 0x0000000168686812ULL, 0x000fe400078efcffULL,
0x00000040002e7306ULL, 0x000fe40000209400ULL, 0x0000000f680f723eULL, 0x000fe200000010ffULL,
0x0001000043687824ULL, 0x000fca00078e00ffULL, 0x00000040005f7306ULL, 0x000ea20000205400ULL,
0x0000002f0a00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x00000018ff0a7819ULL, 0x000fc6000001143eULL, 0x0000004200587306ULL, 0x000fe20000009400ULL,
0x0000005f2e00720bULL, 0x004fce0003f7d000ULL, 0x00000042005d7306ULL, 0x000e620000005400ULL,
0x0000002c342c723cULL, 0x000b6e0000041830ULL, 0x000000010d337824ULL, 0x060fe200078e020cULL,
0x0000006300327306ULL, 0x000fe20000209400ULL, 0x000000080d0c7824ULL, 0x000fe200078e00ffULL,
0x0000006700307245ULL, 0x000fc4000020d400ULL, 0x0000004000317245ULL, 0x000fe4000020d400ULL,
0xfffffff80c337812ULL, 0x000fe400078ee233ULL, 0x0000000e440c723cULL, 0x000be20000041848ULL,
0x0000000130306812ULL, 0x000fe200078efcffULL, 0x00000063004b7306ULL, 0x020ea20000205400ULL,
0x0000000131313812ULL, 0x000fe200078efcffULL, 0x0000001033337824ULL, 0x000fe200078e0264ULL,
0x000000306530723eULL, 0x000fe400000010ffULL, 0x0000010043497824ULL, 0x000fe200078e00ffULL,
0x000000316631723eULL, 0x000fc400000010ffULL, 0x0000004200577306ULL, 0x000ee2000000d400ULL,
0x0000005d5800720bULL, 0x002fe40003f9d000ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x000000304424723cULL, 0x000be20000041824ULL, 0x00000018ff657819ULL, 0x000fe40000011442ULL,
0x0000004900677306ULL, 0x000fe20000209400ULL, 0x0000004b3200720bULL, 0x004fe40003f1d000ULL,
0x000000003330783bULL, 0x020e620000004200ULL, 0x00000018ff587819ULL, 0x000fc4000001143cULL,
0x00000018ff407819ULL, 0x000fe4000001143fULL, 0x0000004900487306ULL, 0x0005220000205400ULL,
0x0000000157574812ULL, 0x008fce00078efcffULL, 0x00000043005e7306ULL, 0x000ee2000000d400ULL,
0x0000004900497245ULL, 0x004fe4000020d400ULL, 0x000000486700720bULL, 0x010fca0003f5d000ULL,
0x00000065004b7306ULL, 0x000fe20000209400ULL, 0x0000006300487245ULL, 0x000fe4000020d400ULL,
0x00000018ff637819ULL, 0x000fe40000011443ULL, 0x0000000148480812ULL, 0x000fe400078efcffULL,
0x000000015e5e5812ULL, 0x008fe200078efcffULL, 0x0000006300667306ULL, 0x000fe20000209400ULL,
0x000000574848723eULL, 0x000fe200000010ffULL, 0x0001000042577824ULL, 0x000fe200078e00ffULL,
0x0000000149492812ULL, 0x000fc800078efcffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x00000063006b7306ULL, 0x000ea20000205400ULL, 0x0000005e4949723eULL, 0x000fce00000010ffULL,
0x0000006500677306ULL, 0x000ee20000205400ULL, 0x000000484428723cULL, 0x000bee0000041828ULL,
0x00000057006c7306ULL, 0x000fe20000209400ULL, 0x0000006b6600720bULL, 0x004fe20003f9d000ULL,
0x0000010030667824ULL, 0x002fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000005700427306ULL, 0x000e620000205400ULL, 0x000000674b00720bULL, 0x008fe20003f1d000ULL,
0x0000010031677824ULL, 0x000fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000006800437306ULL, 0x000ff00000209400ULL, 0x00000068005e7306ULL, 0x000ea20000205400ULL,
0x000000426c00720bULL, 0x002fce0003fbd000ULL, 0x00000030006d7306ULL, 0x000ff00000009400ULL,
0x0000003000487306ULL, 0x020e620000005400ULL, 0x0000005e4300720bULL, 0x004fce0003fdd000ULL,
0x0000003100497306ULL, 0x000ff00000009400ULL, 0x00000031006c7306ULL, 0x000ea20000005400ULL,
0x000000486d00720bULL, 0x002fe40003f7d000ULL, 0x00000065006d7245ULL, 0x000fc8000020d400ULL,
0x000000016d6d0812ULL, 0x000fe200078efcffULL, 0x0000006600427306ULL, 0x000ff00000209400ULL,
0x0000006600437306ULL, 0x000e620000205400ULL, 0x0000006c4900720bULL, 0x004fe20003f5d000ULL,
0x000001003c497824ULL, 0x000fe200078e00ffULL, 0x00000063006c7245ULL, 0x000fc8000020d400ULL,
0x000000016c6c4812ULL, 0x000fe200078efcffULL, 0x00000067005e7306ULL, 0x000fe20000209400ULL,
0x00000018ff497819ULL, 0x000fce0000011449ULL, 0x0000006700657306ULL, 0x000ea20000205400ULL,
0x000000434200720bULL, 0x002fe40003f1d000ULL, 0x0000005700427245ULL, 0x000fe4000020d400ULL,
0x0000006800437245ULL, 0x000fe4000020d400ULL, 0x0000000142425812ULL, 0x000fe200078efcffULL,
0x0000003100687306ULL, 0x000e62000000d400ULL, 0x0000000143436812ULL, 0x000fe400078efcffULL,
0x000000426d42723eULL, 0x000fc400000010ffULL, 0x000000436c43723eULL, 0x000fe400000010ffULL,
0x000000655e00720bULL, 0x004fe20003f9d000ULL, 0x00000030006b7306ULL, 0x000ea8000000d400ULL,
0x00000042442c723cULL, 0x000be2000004182cULL, 0x0000000168682812ULL, 0x002fc600078efcffULL,
0x0000003c004d7306ULL, 0x000fe60000009400ULL, 0x0000006700437245ULL, 0x020fe4000020d400ULL,
0x0000006600427245ULL, 0x000fe4000020d400ULL, 0x0000000143434812ULL, 0x000fe400078efcffULL,
0x000000016b6b3812ULL, 0x004fe200078efcffULL, 0x0000003c004e7306ULL, 0x000e620000005400ULL,
0x000000684343723eULL, 0x000fe200000010ffULL, 0x0001000030687824ULL, 0x000fe200078e00ffULL,
0x0000000142420812ULL, 0x000fc800078efcffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000003d004f7306ULL, 0x000fe20000009400ULL, 0x0000006b4242723eULL, 0x000fe400000010ffULL,
0x00000018ff6b7819ULL, 0x000fca0000011430ULL, 0x0000003d00507306ULL, 0x000ea20000005400ULL,
0x000000423420723cULL, 0x000b620000041820ULL, 0x0000004e4d00720bULL, 0x002fcc0003f5d000ULL,
0x00000068006c7306ULL, 0x000fe20000209400ULL, 0x0001000031437824ULL, 0x020fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fc80000011431ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000068006d7306ULL, 0x0002e20000205400ULL, 0x000000504f00720bULL, 0x004fce0003f9d000ULL,
0x00000043004e7306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x002fce000020d400ULL,
0x00000043004f7306ULL, 0x000e620000205400ULL, 0x0000006d6c00720bULL, 0x008fce0003fbd000ULL,
0x0000006b00307306ULL, 0x000fec0000209400ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x0000006b006f7306ULL, 0x0004e20000205400ULL, 0x0000004f4e00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff4f7819ULL, 0x000fca0000011432ULL, 0x0000003f00537306ULL, 0x000fe20000009400ULL,
0x0000006b006b7245ULL, 0x004fce000020d400ULL, 0x0000003f00547306ULL, 0x000e620000005400ULL,
0x0000006f3000720bULL, 0x008fe40003fdd000ULL, 0x0000004300307245ULL, 0x000fc8000020d400ULL,
0x0000000130305812ULL, 0x000fe200078efcffULL, 0x00000032005e7306ULL, 0x000fec0000009400ULL,
0x000000016b6b6812ULL, 0x000fe400078efcffULL, 0x0000003200637306ULL, 0x000ea20000005400ULL,
0x000000545300720bULL, 0x002fe20003f1d000ULL, 0x0000010032537824ULL, 0x000fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000003e00517306ULL, 0x000ff00000009400ULL,
0x0000003e00527306ULL, 0x000e620000005400ULL, 0x000000635e00720bULL, 0x004fe20003fbd000ULL,
0x0000010033637824ULL, 0x000fe200078e00ffULL, 0x00000042005e7245ULL, 0x000fc8000020d400ULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x00000042004d7306ULL, 0x000ff00000209400ULL,
0x0000004200507306ULL, 0x000ea20000205400ULL, 0x000000525100720bULL, 0x002fce0003f7d000ULL,
0x0000005300517306ULL, 0x000ff00000209400ULL, 0x0000005300527306ULL, 0x0002e20000205400ULL,
0x000000504d00720bULL, 0x004fce0003fdd000ULL, 0x0000003200657306ULL, 0x000522000000d400ULL,
0x0000005300537245ULL, 0x002fca000020d400ULL, 0x000000015e5e6812ULL, 0x000fe400078efcffULL,
0x0000006300427306ULL, 0x000fe20000209400ULL, 0x0001000032327824ULL, 0x004fe200078e00ffULL,
0x000000525100720bULL, 0x008fc80003fdd000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000063004d7306ULL, 0x0002a20000205400ULL, 0x0000000165655812ULL, 0x010fcc00078efcffULL,
0x0000000153536812ULL, 0x000fe200078efcffULL, 0x0000003300667306ULL, 0x000fe20000009400ULL,
0x0000006300637245ULL, 0x002fce000020d400ULL, 0x0000003300677306ULL, 0x000e620000005400ULL,
0x0000004d4200720bULL, 0x004fe20003fbd000ULL, 0x00010000334d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fc80000011433ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000003200517306ULL, 0x000fec0000209400ULL, 0x0000000163635812ULL, 0x000fe400078efcffULL,
0x0000003200527306ULL, 0x000ea20000205400ULL, 0x000000676600720bULL, 0x002fe20003fdd000ULL,
0x000001003d667824ULL, 0x000fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000003300317306ULL, 0x0002f0000000d400ULL, 0x0000004f00437306ULL, 0x000fe20000209400ULL,
0x000000525100720bULL, 0x004fe20003fbd000ULL, 0x000100003c337824ULL, 0x002fc400078e00ffULL,
0x000100003d527824ULL, 0x000fc600078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000004f004e7306ULL, 0x0002a20000205400ULL, 0x0000000131316812ULL, 0x008fe400078efcffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x000000316331723eULL, 0x000fc600000010ffULL,
0x0000004d00547306ULL, 0x000fe20000209400ULL, 0x0000004f004f7245ULL, 0x002fce000020d400ULL,
0x0000004d00517306ULL, 0x000e620000205400ULL, 0x0000004e4300720bULL, 0x004fe40003fdd000ULL,
0x00000032004e7245ULL, 0x000fc8000020d400ULL, 0x000000014e4e5812ULL, 0x000fe200078efcffULL,
0x0000004200507306ULL, 0x000fec0000209400ULL, 0x000000014f4f6812ULL, 0x000fe400078efcffULL,
0x0000004200437306ULL, 0x000ea20000205400ULL, 0x000000515400720bULL, 0x002fce0003fbd000ULL,
0x00000049004b7306ULL, 0x000ff00000209400ULL, 0x0000004900577306ULL, 0x000e620000205400ULL,
0x000000435000720bULL, 0x004fe40003fdd000ULL, 0x0000004d00437245ULL, 0x000fe2000020d400ULL,
0x000001003e4d7824ULL, 0x000fe200078e00ffULL, 0x0000004900507245ULL, 0x000fc4000020d400ULL,
0x0000000143435812ULL, 0x000fe200078efcffULL, 0x0000003c003b7306ULL, 0x000ea2000000d400ULL,
0x00000018ff4d7819ULL, 0x000fce000001144dULL, 0x00000033003c7306ULL, 0x000fe20000209400ULL,
0x000000574b00720bULL, 0x002fe40003fbd000ULL, 0x00000042004b7245ULL, 0x000fe2000020d400ULL,
0x000001003f427824ULL, 0x000fc600078e00ffULL, 0x000000014b4b6812ULL, 0x000fe200078efcffULL,
0x0000003300517306ULL, 0x000e620000205400ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x000000013b3b2812ULL, 0x004fc600078efcffULL, 0x0000000150505812ULL, 0x000fe400078efcffULL,
0x00000058005d7306ULL, 0x000ff00000209400ULL, 0x00000058005b7306ULL, 0x0004e20000205400ULL,
0x000000513c00720bULL, 0x002fe20003fbd000ULL, 0x000100003e3c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000003d00137306ULL, 0x000e62000000d400ULL,
0x0000005800587245ULL, 0x004fce000020d400ULL, 0x0000006600327306ULL, 0x000fe20000209400ULL,
0x0000005b5d00720bULL, 0x008fce0003fdd000ULL, 0x00000066003d7306ULL, 0x0004e20000205400ULL,
0x0000000113134812ULL, 0x002fca00078efcffULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000005200677306ULL, 0x000fe20000209400ULL, 0x0000006600667245ULL, 0x004fce000020d400ULL,
0x00000052006c7306ULL, 0x0002b00000205400ULL, 0x0000003e00117306ULL, 0x0008a2000000d400ULL,
0x0000005200527245ULL, 0x002fce000020d400ULL, 0x0000004100597306ULL, 0x000fe20000209400ULL,
0x00000033003e7245ULL, 0x010fe4000020d400ULL, 0x000000305e33723eULL, 0x000fe400000010ffULL,
0x000000013e3e5812ULL, 0x000fe400078efcffULL, 0x0000003d3200720bULL, 0x008fe20003fbd000ULL,
0x00000041005a7306ULL, 0x0002e20000205400ULL, 0x000000686b32723eULL, 0x000fe200000010ffULL,
0x000100003f3d7824ULL, 0x000fe200078e00ffULL, 0x0000006c6700720bULL, 0x004fc40003fdd000ULL,
0x000000655330723eULL, 0x000fe400000010ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000004d00577306ULL, 0x000fe20000209400ULL, 0x00000032341c723cULL, 0x040b62000004181cULL,
0x0000004100417245ULL, 0x002fe4000020d400ULL, 0x0000000166665812ULL, 0x000fe400078efcffULL,
0x0000000111113812ULL, 0x000fe400078efcffULL, 0x0000004d005b7306ULL, 0x000e620000205400ULL,
0x0000004e4f32723eULL, 0x020fe200000010ffULL, 0x000000303418723cULL, 0x000b620000041818ULL,
0x0000005a5900720bULL, 0x008fc40003f5d000ULL, 0x000000434b33723eULL, 0x000fe400000010ffULL,
0x0000000152526812ULL, 0x000fe200078efcffULL, 0x00000040004a7306ULL, 0x000fe20000209400ULL,
0x0000003b5030723eULL, 0x020fe400000010ffULL, 0x000000136631723eULL, 0x000fe200000010ffULL,
0x000000323414723cULL, 0x000f620000041814ULL, 0x0000004200137245ULL, 0x000fe4000020d400ULL,
0x0000003e583e723eULL, 0x000fe200000010ffULL, 0x0000004000487306ULL, 0x0004e20000205400ULL,
0x0000005b5700720bULL, 0x002fc40003f9d000ULL, 0x0000000141412812ULL, 0x000fe200078efcffULL,
0x000000304420723cULL, 0x000b680000041820ULL, 0x0000003f00107306ULL, 0x000e62000000d400ULL,
0x0000004000407245ULL, 0x004fce000020d400ULL, 0x0000000a005f7306ULL, 0x000fe20000209400ULL,
0x000000484a00720bULL, 0x008fe40003fdd000ULL, 0x0000004d00487245ULL, 0x000fc8000020d400ULL,
0x0000000148484812ULL, 0x000fe200078efcffULL, 0x0000000a005c7306ULL, 0x0004e20000205400ULL,
0x0000000110100812ULL, 0x002fe400078efcffULL, 0x000000114830723eULL, 0x020fe400000010ffULL,
0x0000000a00117245ULL, 0x000fe4000020d400ULL, 0x0000000140406812ULL, 0x000fe200078efcffULL,
0x0000004200517306ULL, 0x000fe20000209400ULL, 0x0000f698750a7811ULL, 0x004fce00078e18ffULL,
0x0000004200547306ULL, 0x000e620000205400ULL, 0x0000005c5f00720bULL, 0x008fce0003fbd000ULL,
0x0000003c00497306ULL, 0x000fec0000209400ULL, 0x0000000111115812ULL, 0x000fe400078efcffULL,
0x0000003c003f7306ULL, 0x0004e20000205400ULL, 0x000000545100720bULL, 0x002fce0003f5d000ULL,
0x0000003d00537306ULL, 0x000fe20000209400ULL, 0x0000003c003c7245ULL, 0x004fca000020d400ULL,
0x0000000113132812ULL, 0x000fe400078efcffULL, 0x0000003d004e7306ULL, 0x0002a20000205400ULL,
0x0000003f4900720bULL, 0x008fe40003f9d000ULL, 0x00000052413f723eULL, 0x000fe400000010ffULL,
0x000000101331723eULL, 0x000fe400000010ffULL, 0x0000003d003d7245ULL, 0x002fc6000020d400ULL,
0x0000003e441c723cULL, 0x040b68000004181cULL, 0x000000013c3c4812ULL, 0x000fe400078efcffULL,
0x0000004e5300720bULL, 0x004fe40003f7d000ULL, 0x0000003c113c723eULL, 0x000fe200000010ffULL,
0x000000304418723cULL, 0x000b740000041818ULL, 0x000000013d3d3812ULL, 0x000fc800078efcffULL,
0x0000003d403d723eULL, 0x000fce00000010ffULL, 0x0000003c4414723cULL, 0x000b620000041814ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000005107f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000aff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff137224ULL, 0x000fc600078e00ffULL,
0x0000000000307805ULL, 0x020fc80000015200ULL, 0x0000040005337984ULL, 0x000f240000000800ULL,
0x8000000033ff7812ULL, 0x014fe40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230357210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x008fc80000011433ULL,
0x000000350a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x000000020a0a7819ULL, 0x000fc80000001233ULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040005337984ULL, 0x000ea40000000800ULL,
0x8000000033ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000103117810ULL, 0x000fc80007ffe0ffULL, 0x0000006a1100720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x0000000203117810ULL, 0x000fe40007ffe0ffULL,
0x0000010056567810ULL, 0x000fe40007ffe0ffULL, 0x0000006a1100720cULL, 0x000fc60003f06070ULL,
0x0000660073137a24ULL, 0x000fd400078e0256ULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x00000056690a7217ULL, 0x008fe20007800000ULL, 0x0000001072117824ULL, 0x000fe200078e00ffULL,
0x00000003ff107819ULL, 0x000fc60000011600ULL, 0x000000010a0a7824ULL, 0x000fe200078e0a56ULL,
0x0000000410327810ULL, 0x000fe20007ffe0ffULL, 0x0000000111307824ULL, 0x000fc600078e0210ULL,
0x0000000a110a7217ULL, 0x040fe20007800000ULL, 0x0000000130317824ULL, 0x040fe400078e0200ULL,
0x0000000830347824ULL, 0x000fe400078e00ffULL, 0x000000010a0a7824ULL, 0x000fe400078e0a11ULL,
0x0000000130307824ULL, 0x000fe200078e0213ULL, 0xfffffff834377812ULL, 0x000fe400078ee231ULL,
0x0000000a3200720cULL, 0x080fe20003f66070ULL, 0x0000000111327824ULL, 0x000fe200078e0232ULL,
0x0000000810317810ULL, 0x040fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e0264ULL,
0x0000000a1000720cULL, 0x080fe20003f86070ULL, 0x00000008323b7824ULL, 0x000fe200078e00ffULL,
0x0000000c10347810ULL, 0x000fe20007ffe0ffULL, 0x0000000132107824ULL, 0x000fe200078e0200ULL,
0x0000000a3100720cULL, 0x080fe20003f46070ULL, 0x0000000111337824ULL, 0x000fe200078e0231ULL,
0x0000000a3400720cULL, 0x000fe20003f06070ULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fc600078ee210ULL, 0x0000000132107824ULL, 0x100fe200078e0213ULL,
0x0000006030307212ULL, 0x000fe200078efcffULL, 0x0000000111367824ULL, 0x000fe400078e0234ULL,
0x0000000133327824ULL, 0x040fe200078e0213ULL, 0x0000620030307a10ULL, 0x000fe20007fbe0ffULL,
0x00000001330a7824ULL, 0x040fe400078e0200ULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000630031317a10ULL, 0x000fe20002ffe4ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000136347824ULL, 0x000fe200078e0213ULL, 0xfffffff833137812ULL, 0x000fe200078ee20aULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000006010107212ULL, 0x080fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030377faeULL, 0x0005e4000e101c48ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe40007fbe0ffULL,
0x0000006032327212ULL, 0x080fe200078efcffULL, 0x00000001360a7824ULL, 0x000fe200078e0200ULL,
0x0000006034347212ULL, 0x000fe200078efcffULL, 0x00000008363d7824ULL, 0x000fe200078e00ffULL,
0x0000630011117a10ULL, 0x000fe20002ffe4ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0264ULL,
0x0000620032327a10ULL, 0x000fe20007fbe0ffULL, 0x0000001013137824ULL, 0x000fe200078e0264ULL,
0xfffffff83d3d7812ULL, 0x000fc400078ee20aULL, 0x0000620034347a10ULL, 0x000fe20007fde0ffULL,
0x00000000103b7faeULL, 0x0005e2000d901c48ULL, 0x0000630033337a10ULL, 0x000fe20002ffe4ffULL,
0x000000103d3d7824ULL, 0x000fe200078e0264ULL, 0x0000630035357a10ULL, 0x000fc600037fe4ffULL,
0x0000000032137faeULL, 0x0005e8000d101c48ULL, 0x00000000343d7faeULL, 0x0005e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001072117824ULL, 0x000fca00078e00ffULL,
0x0000001100117211ULL, 0x000fc800078fe8ffULL, 0x0000000411347810ULL, 0x040fe20007ffe0ffULL,
0x00000001110a7824ULL, 0x148fe200078e0200ULL, 0x0000000811327810ULL, 0x040fe20007ffe0ffULL,
0x0000000811377824ULL, 0x000fe400078e00ffULL, 0x0000000134107824ULL, 0x040fe400078e0200ULL,
0x00000008343b7824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee20aULL,
0x0000000132307824ULL, 0x040fe200078e0200ULL, 0x0000000c110a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008323d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x000fc400078e0213ULL, 0x0000000134347824ULL, 0x000fe200078e0213ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee230ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000132327824ULL, 0x100fe200078e0213ULL, 0x0000006010107212ULL, 0x000fe200078efcffULL,
0x000000010a307824ULL, 0x000fe400078e0213ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fc60007f1e0ffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000006034347212ULL, 0x080fe400078efcffULL, 0x0000630011117a10ULL, 0x000fe200007fe4ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x0000006032327212ULL, 0x080fe400078efcffULL,
0x0000620034347a10ULL, 0x000fe20007f5e0ffULL, 0x000000010a137824ULL, 0x000fe200078e0200ULL,
0x0000006030307212ULL, 0x000fe200078efcffULL, 0x000000080a0a7824ULL, 0x000fe200078e00ffULL,
0x0000620032327a10ULL, 0x000fe20007f1e0ffULL, 0x0000001037377824ULL, 0x100fe200078e0264ULL,
0x0000620030307a10ULL, 0x000fe20007f7e0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0264ULL,
0xfffffff80a137812ULL, 0x000fe200078ee213ULL, 0x000000103d3d7824ULL, 0x100fe200078e0264ULL,
0x0000630035357a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010377faeULL, 0x0005e2000b901c48ULL, 0x0000630033337a10ULL, 0x000fe200007fe4ffULL,
0x0000001013137824ULL, 0x000fe200078e0264ULL, 0x0000630031317a10ULL, 0x000fe20001ffe4ffULL,
0x00000000343b7faeULL, 0x0005e8000b901c48ULL, 0x00000000323d7faeULL, 0x0005e8000b901c48ULL,
0x0000000030137faeULL, 0x0005e4000b901c48ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000106e0a7824ULL, 0x008fe200078e00ffULL, 0x0000000802137812ULL, 0x000fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x000000100a0a7812ULL, 0x000fca00078ee2ffULL,
0x00000020750a7824ULL, 0x000fc800078e020aULL, 0x0000000113137824ULL, 0x000fe200078e020aULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff307f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680013107f8cULL, 0x000662000c80043fULL, 0x000000ffff0a7224ULL, 0x004fc600078e0031ULL,
0x0000000000307805ULL, 0x000fc80000015200ULL, 0x00f66c0013337984ULL, 0x000ea40000000800ULL,
0x8000000033ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c0013337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018075117811ULL, 0x000fc800078e38ffULL,
0x0000001162117210ULL, 0x000fca0007ffe060ULL, 0x00f0000011137984ULL, 0x008e680000000800ULL,
0x00f2000011317984ULL, 0x0004e20000000800ULL, 0x000000061300720bULL, 0x002fe20003f1d000ULL,
0x0000a9627f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff3c347812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff327424ULL, 0x000fe400078e00ffULL, 0x000000ffff307224ULL, 0x000fd200078e0006ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x0000000375117810ULL, 0x000fe40007ffe0ffULL,
0x000000061300720bULL, 0x000fe40003f54000ULL, 0x000000041100720cULL, 0x000fe20003f05270ULL,
0x0000a9027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000337806ULL, 0x000fc400010e0100ULL,
0x0000008004118824ULL, 0x000fe200078e0260ULL, 0x0000000613307209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991033107816ULL, 0x000fe200000000ffULL,
0x0000000162118824ULL, 0x000fca00078e0211ULL, 0x00f4003011008388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000630067221ULL, 0x002fe20000010100ULL, 0x000000ff33ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL,
0x0000000600357308ULL, 0x000e640000000800ULL, 0x0000003512127220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x0000a8327f007947ULL, 0x000fea000b800000ULL, 0x00001f10353c7589ULL, 0x0002a400000e0000ULL,
0x0000003c20207220ULL, 0x084fe20000410000ULL, 0x0000003c21217220ULL, 0x080fe20000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003c18187220ULL, 0x080fe20000410000ULL, 0x0000003c19197220ULL, 0x080fe20000410000ULL,
0x0000003c14147220ULL, 0x080fe20000410000ULL, 0x0000003c15157220ULL, 0x080fe20000410000ULL,
0x0000003c0c0c7220ULL, 0x080fe20000410000ULL, 0x0000003c0d0d7220ULL, 0x080fe20000410000ULL,
0x0000003c24247220ULL, 0x080fe20000410000ULL, 0x0000003c25257220ULL, 0x080fe20000410000ULL,
0x0000003c28287220ULL, 0x080fe20000410000ULL, 0x0000003c29297220ULL, 0x080fe20000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000003c2d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0033ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x002fe200078ff0ffULL,
0x0000a7127f007947ULL, 0x000fea000b800000ULL, 0x00001f10353c7589ULL, 0x0002a400000e0000ULL,
0x0000003c22227220ULL, 0x084fe20000410000ULL, 0x0000003c23237220ULL, 0x080fe20000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003c16167220ULL, 0x080fe20000410000ULL, 0x0000003c17177220ULL, 0x080fe20000410000ULL,
0x0000003c0e0e7220ULL, 0x080fe20000410000ULL, 0x0000003c0f0f7220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x080fe20000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff34ff7812ULL, 0x000fda0007806033ULL,
0x0000001330130221ULL, 0x000fe20000010100ULL, 0x00007610ff320816ULL, 0x000fc60000000032ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x0000001300070308ULL, 0x000e640000000800ULL,
0x0000000731310220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001231317221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0xfffffff002347812ULL, 0x000fe200078ec0ffULL, 0x0000000404067824ULL, 0x000fc800078e00ffULL,
0x00f6b40034137984ULL, 0x000e620000000800ULL, 0x0000000406067812ULL, 0x000fc800078ec0ffULL,
0x0000000206337812ULL, 0x000fe400078efcffULL, 0x8000000013ff7812ULL, 0x002fe20007804839ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210357210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011413ULL, 0x0000003506067211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000206067819ULL, 0x000fc80000001213ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6b40034137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804839ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991032067816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff06723eULL, 0x000fe400000010ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x0000541006067816ULL, 0x000fe20000000006ULL, 0x0000a2a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1306087589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x0000a2d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1006097589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e0006ULL, 0x0000cc10003d7802ULL, 0x000fc40000000f00ULL,
0x0000a76000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e0006ULL,
0x0000cc60003d7802ULL, 0x000fc40000000f00ULL, 0x0000a71000007944ULL, 0x006fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000700497812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008005e7812ULL, 0x000fc400078ec0ffULL,
0x0000000849067812ULL, 0x00afe400078ef800ULL, 0x0000000375707810ULL, 0x000fc60007ffe0ffULL,
0x0000000806117824ULL, 0x000fca00078e00ffULL, 0xfffffff811107812ULL, 0x000fca00078ee24cULL,
0x0000008075107824ULL, 0x000fca00078e0210ULL, 0x0000a80010107811ULL, 0x000fc400078e20ffULL,
0x000000006160783bULL, 0x000e620000004200ULL, 0x000000495e497212ULL, 0x000fe200078efcffULL,
0x0000080070707824ULL, 0x000fe200078e023aULL, 0x00001000646f7810ULL, 0x000fc60007ffe0ffULL,
0x00000008495e7824ULL, 0x000fe400078e00ffULL, 0x00000010553c7824ULL, 0x004fcc00078e026fULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0x00000100614b7824ULL, 0x042fe200078e00ffULL,
0x0000006100137306ULL, 0x000fe20000009400ULL, 0x00000100604a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011460ULL, 0x00010000604c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x00010000614d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x00000100625a7824ULL, 0x000fe200078e00ffULL,
0x0000006100127306ULL, 0x000e620000005400ULL, 0x00000018ff357819ULL, 0x000fe20000011461ULL,
0x00000100635c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc4000001144cULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000006200387306ULL, 0x000fe20000009400ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000003400557245ULL, 0x000fe4000020d400ULL, 0x00000018ff367819ULL, 0x000fe40000011462ULL,
0x00000018ff457819ULL, 0x000fe20000011463ULL, 0x0000006200117306ULL, 0x000ea20000005400ULL,
0x000000121300720bULL, 0x002fce0003f5d000ULL, 0x0000004b00597306ULL, 0x000ff00000209400ULL,
0x0000004b006c7306ULL, 0x000e620000205400ULL, 0x000000113800720bULL, 0x004fe40003f7d000ULL,
0x000000001010783bULL, 0x000eaa0000000200ULL, 0x00000060005f7306ULL, 0x000ff00000009400ULL,
0x0000006000687306ULL, 0x000ee20000005400ULL, 0x0000006c5900720bULL, 0x002fc40003fbd000ULL,
0x00000033006c7211ULL, 0x000fca00078fe0ffULL, 0x0000006000407306ULL, 0x000e62000000d400ULL,
0x0000000149337824ULL, 0x000fca00078e026cULL, 0xfffffff85e5e7812ULL, 0x000fe400078ee233ULL,
0x0000004a00517306ULL, 0x000fe20000209400ULL, 0x000000685f00720bULL, 0x008fe40003fdd000ULL,
0x0000004a00337245ULL, 0x000fe2000020d400ULL, 0x000000105e717824ULL, 0x000fe200078e0271ULL,
0x00000035005e7245ULL, 0x000fc6000020d400ULL, 0x0000004a00607306ULL, 0x0007220000205400ULL,
0x0000000810108231ULL, 0x084fe400003400ffULL, 0x0000000812128231ULL, 0x000fc600003400ffULL,
0x0000000140406812ULL, 0x002fe200078efcffULL, 0x0000000911118231ULL, 0x080fe200003400ffULL,
0x0000006100417306ULL, 0x000e62000000d400ULL, 0x0000004b004a7245ULL, 0x008fe2000020d400ULL,
0x0000000913138231ULL, 0x000fc600003400ffULL, 0x000000014a4a5812ULL, 0x000fc600078efcffULL,
0x00000034003b7306ULL, 0x000fe20000209400ULL, 0x000000605100720bULL, 0x010fce0003f9d000ULL,
0x0000003400567306ULL, 0x0004e20000205400ULL, 0x0000000141412812ULL, 0x002fc800078efcffULL,
0x000000414a41723eULL, 0x000fe400000010ffULL, 0x0000000133334812ULL, 0x000fe200078efcffULL,
0x00000035004e7306ULL, 0x000fe20000209400ULL, 0x0000004c00347245ULL, 0x004fe4000020d400ULL,
0x000000403340723eULL, 0x000fe400000010ffULL, 0x00000018ff4a7819ULL, 0x000fc6000001143cULL,
0x0000003500527306ULL, 0x0002a20000205400ULL, 0x000000563b00720bULL, 0x008fce0003fdd000ULL,
0x0000004c00427306ULL, 0x000fe20000209400ULL, 0x0000004d00357245ULL, 0x002fca000020d400ULL,
0x0000000155556812ULL, 0x000fe400078efcffULL, 0x0000004c00437306ULL, 0x0002e20000205400ULL,
0x000000524e00720bULL, 0x004fe40003fbd000ULL, 0x00000018ff527819ULL, 0x000fca000001143dULL,
0x0000004d00537306ULL, 0x000fe20000209400ULL, 0x00000018ff4c7819ULL, 0x002fca000001143eULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x0000004d00547306ULL, 0x0002a20000205400ULL,
0x000000434200720bULL, 0x008fe40003f5d000ULL, 0x000000401040723cULL, 0x000b640000041820ULL,
0x000000007120783bULL, 0x020ee60000004200ULL, 0x0000005a004f7306ULL, 0x000fe20000209400ULL,
0x00000018ff4d7819ULL, 0x002fca000001143fULL, 0x0000000134342812ULL, 0x000fe400078efcffULL,
0x0000005a00577306ULL, 0x000e620000205400ULL, 0x000000545300720bULL, 0x004fe40003f9d000ULL,
0x000000345534723eULL, 0x000fca00000010ffULL, 0x0000006300327306ULL, 0x000fec0000009400ULL,
0x0000000135354812ULL, 0x000fe400078efcffULL, 0x0000006300587306ULL, 0x000ea20000005400ULL,
0x000000574f00720bULL, 0x002fe40003f5d000ULL, 0x000000355e35723eULL, 0x000fca00000010ffULL,
0x0000005c005b7306ULL, 0x000fe40000209400ULL, 0x00000034101c723cULL, 0x000b62000004181cULL,
0x0000010020767824ULL, 0x008fe400078e00ffULL, 0x0000010021747824ULL, 0x000fc600078e00ffULL,
0x0000005c005d7306ULL, 0x000e620000205400ULL, 0x000000583200720bULL, 0x004fe40003f9d000ULL,
0x0000005a00357245ULL, 0x020fe4000020d400ULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x0000000135352812ULL, 0x000fe200078efcffULL, 0x0000006200067306ULL, 0x0004e2000000d400ULL,
0x00000018ff747819ULL, 0x000fce0000011474ULL, 0x0000006300487306ULL, 0x000922000000d400ULL,
0x0001000062627824ULL, 0x004fe200078e00ffULL, 0x0000005d5b00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000000106063812ULL, 0x008fe200078efcffULL,
0x0001000063637824ULL, 0x010fe200078e00ffULL, 0x0000003600467306ULL, 0x000fe40000209400ULL,
0x000000063534723eULL, 0x000fe400000010ffULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x0000005c00357245ULL, 0x000fc4000020d400ULL, 0x0000003600477306ULL, 0x000e620000205400ULL,
0x0000000148484812ULL, 0x000fe400078efcffULL, 0x0000000135355812ULL, 0x000fc800078efcffULL,
0x000000483535723eULL, 0x000fe200000010ffULL, 0x0000004500447306ULL, 0x000fec0000209400ULL,
0x000000341018723cULL, 0x000b640000041818ULL, 0x0000004500377306ULL, 0x000ea20000205400ULL,
0x000000474600720bULL, 0x002fc80003f9d000ULL, 0x000000010b357824ULL, 0x060fe200078e026cULL,
0x0000006200347245ULL, 0x000fe4000020d400ULL, 0x0000006200507306ULL, 0x000ff00000209400ULL,
0x00000062006d7306ULL, 0x000e620000205400ULL, 0x000000374400720bULL, 0x004fe20003fbd000ULL,
0x000000080b447824ULL, 0x000fe200078e00ffULL, 0x00000036000b7245ULL, 0x000fc4000020d400ULL,
0x0000004500367245ULL, 0x000fe4000020d400ULL, 0xfffffff844447812ULL, 0x000fe200078ee235ULL,
0x0000006300647306ULL, 0x000fe20000209400ULL, 0x0000006300357245ULL, 0x000fe4000020d400ULL,
0x000000010b0b4812ULL, 0x000fe200078efcffULL, 0x0000001044447824ULL, 0x000fe400078e026fULL,
0x0000000136365812ULL, 0x000fe400078efcffULL, 0x0000006300657306ULL, 0x000ea20000205400ULL,
0x0000006d5000720bULL, 0x002fe20003f7d000ULL, 0x000001003c6d7824ULL, 0x000fe200078e00ffULL,
0x000000004444783bULL, 0x000fe80000004200ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000003c00667306ULL, 0x000fe60000009400ULL, 0x0000006d003a7245ULL, 0x000fc6000020d400ULL,
0x0000000134343812ULL, 0x000fe400078efcffULL, 0x000000656400720bULL, 0x004fe20003fdd000ULL,
0x0000003c00677306ULL, 0x000e620000005400ULL, 0x000000340b34723eULL, 0x000fe200000010ffULL,
0x000001003d657824ULL, 0x000fe400078e00ffULL, 0x000001003e0b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000006d00717306ULL, 0x000fe20000205400ULL,
0x00000018ff0b7819ULL, 0x000fc6000001140bULL, 0x0000000135356812ULL, 0x000fe400078efcffULL,
0x000000676600720bULL, 0x002fe40003f5d000ULL, 0x0000003d00687306ULL, 0x000fe20000009400ULL,
0x000000353635723eULL, 0x000fce00000010ffULL, 0x0000006d00677306ULL, 0x0002a20000209400ULL,
0x000000341014723cULL, 0x000b640000041814ULL, 0x009000007034783bULL, 0x020eea0000000200ULL,
0x0000003d006b7306ULL, 0x000f220000005400ULL, 0x000100003f6d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000006500627306ULL, 0x000fe20000209400ULL,
0x000000716700720bULL, 0x004fce0003fdd000ULL, 0x00000065006c7306ULL, 0x000e620000205400ULL,
0x0000006b6800720bULL, 0x010fca0003f7d000ULL, 0x000000013a3a6812ULL, 0x000fe400078efcffULL,
0x0000003f003b7306ULL, 0x000ff00000009400ULL, 0x0000003f00597306ULL, 0x000ea20000005400ULL,
0x0000006c6200720bULL, 0x002fe20003fdd000ULL, 0x0000000834348231ULL, 0x008fc400003400ffULL,
0x0000000836368231ULL, 0x000fe400003400ffULL, 0x0000000935358231ULL, 0x080fe400003400ffULL,
0x0000003c00397306ULL, 0x0002e2000000d400ULL, 0x0000000937378231ULL, 0x000fce00003400ffULL,
0x0000003d00387306ULL, 0x000922000000d400ULL, 0x000000593b00720bULL, 0x004fe20003f9d000ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x00000065003b7245ULL, 0x000fe2000020d400ULL,
0x000100003e597824ULL, 0x000fc600078e00ffULL, 0x000000013b3b6812ULL, 0x000fe200078efcffULL,
0x0000002000577306ULL, 0x000fe20000009400ULL, 0x0000000139392812ULL, 0x008fe200078efcffULL,
0x000100003d3d7824ULL, 0x010fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000000393a3a723eULL, 0x000fe400000010ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000002000587306ULL, 0x000e620000005400ULL, 0x0000000138383812ULL, 0x000fc400078efcffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x000000383b3b723eULL, 0x000fc600000010ffULL,
0x0000007600707306ULL, 0x000fe80000209400ULL, 0x0000003a3438723cULL, 0x000be80000041840ULL,
0x00000076007b7306ULL, 0x000ea20000205400ULL, 0x000000585700720bULL, 0x002fce0003f1d000ULL,
0x0000007400787306ULL, 0x000ff00000209400ULL, 0x0000007400427306ULL, 0x020e620000205400ULL,
0x0000007b7000720bULL, 0x004fe40003f5d000ULL, 0x00000052007b7245ULL, 0x000fca000020d400ULL,
0x0000002000327306ULL, 0x000eb0000000d400ULL, 0x00000021005a7306ULL, 0x000fe20000009400ULL,
0x000000427800720bULL, 0x002fe40003fdd000ULL, 0x0000007600427245ULL, 0x000fc8000020d400ULL,
0x0000000142422812ULL, 0x000fe200078efcffULL, 0x00000021005b7306ULL, 0x000e620000005400ULL,
0x0000000132320812ULL, 0x004fc800078efcffULL, 0x000000324232723eULL, 0x000fc600000010ffULL,
0x0000003c00667306ULL, 0x000ff00000209400ULL, 0x0000003c00647306ULL, 0x0004e20000205400ULL,
0x0000005b5a00720bULL, 0x002fe40003f7d000ULL, 0x00000018ff5a7819ULL, 0x000fca0000011420ULL,
0x0000004a004b7306ULL, 0x000fe20000209400ULL, 0x0000003c003c7245ULL, 0x004fce000020d400ULL,
0x0000004a00517306ULL, 0x000e620000205400ULL, 0x000000646600720bULL, 0x008fe40003f1d000ULL,
0x0000003d00647245ULL, 0x000fca000020d400ULL, 0x0000005200537306ULL, 0x000fec0000209400ULL,
0x000000013c3c0812ULL, 0x000fe400078efcffULL, 0x0000005200547306ULL, 0x000ea20000205400ULL,
0x000000514b00720bULL, 0x002fe40003f5d000ULL, 0x00000074004b7245ULL, 0x000fc4000020d400ULL,
0x0000004d00747245ULL, 0x000fe4000020d400ULL, 0x000000014b4b6812ULL, 0x000fe200078efcffULL,
0x0000002100067306ULL, 0x000e70000000d400ULL, 0x0000004c00557306ULL, 0x000fe20000209400ULL,
0x000000545300720bULL, 0x004fe20003fdd000ULL, 0x0001000020547824ULL, 0x000fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000004c00567306ULL, 0x000ea20000205400ULL,
0x0000000106063812ULL, 0x002fe400078efcffULL, 0x0000005400527245ULL, 0x000fc6000020d400ULL,
0x000000017b7b6812ULL, 0x000fe400078efcffULL, 0x0000003d00687306ULL, 0x000ff00000209400ULL,
0x0000003d006b7306ULL, 0x0002e20000205400ULL, 0x000000565500720bULL, 0x004fc40003f7d000ULL,
0x0000004a00557245ULL, 0x000fe2000020d400ULL, 0x00010000214a7824ULL, 0x000fc600078e00ffULL,
0x0000000155552812ULL, 0x000fe200078efcffULL, 0x00000022005c7306ULL, 0x000fe20000009400ULL,
0x00000018ff3d7819ULL, 0x002fe40000011421ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000006b6800720bULL, 0x008fc60003f1d000ULL, 0x00000022005d7306ULL, 0x000e700000005400ULL,
0x0000005a00567306ULL, 0x000fe40000209400ULL, 0x0000000164640812ULL, 0x000fcc00078efcffULL,
0x0000005a006b7306ULL, 0x0004e20000205400ULL, 0x0000005d5c00720bULL, 0x002fe40003f5d000ULL,
0x000000647b21723eULL, 0x000fe200000010ffULL, 0x0000010022647824ULL, 0x000fc800078e00ffULL,
0x0000005400207306ULL, 0x000fe20000209400ULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x0000005a005a7245ULL, 0x004fca000020d400ULL, 0x00000054005b7306ULL, 0x000e620000205400ULL,
0x0000006b5600720bULL, 0x008fce0003f1d000ULL, 0x0000003d005c7306ULL, 0x000fec0000209400ULL,
0x000000015a5a0812ULL, 0x000fe400078efcffULL, 0x0000003d006b7306ULL, 0x000ea20000205400ULL,
0x0000005b2000720bULL, 0x002fe40003fdd000ULL, 0x0000003c5520723eULL, 0x000fc400000010ffULL,
0x00000018ff557819ULL, 0x000fc60000011422ULL, 0x0000004a00567306ULL, 0x000fe40000209400ULL,
0x00000020341c723cULL, 0x000be8000004181cULL, 0x0000000152526812ULL, 0x000fe400078efcffULL,
0x0000004a005b7306ULL, 0x000e620000205400ULL, 0x0000006b5c00720bULL, 0x004fe40003fdd000ULL,
0x0000003d00217245ULL, 0x020fc4000020d400ULL, 0x0000004a00207245ULL, 0x000fe4000020d400ULL,
0x000000525a52723eULL, 0x000fe200000010ffULL, 0x00000064005c7306ULL, 0x000fec0000209400ULL,
0x0000000121216812ULL, 0x000fe400078efcffULL, 0x00000064006b7306ULL, 0x000ea20000205400ULL,
0x0000005b5600720bULL, 0x002fe20003f1d000ULL, 0x0000010023567824ULL, 0x000fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x00000023005e7306ULL, 0x000fec0000009400ULL,
0x0000000120200812ULL, 0x000fe400078efcffULL, 0x00000023005f7306ULL, 0x000e620000005400ULL,
0x0000006b5c00720bULL, 0x004fc40003fdd000ULL, 0x00000018ff5c7819ULL, 0x000fe40000011423ULL,
0x0000000b006b7245ULL, 0x000fc6000020d400ULL, 0x00000056005b7306ULL, 0x000ff00000209400ULL,
0x00000056004a7306ULL, 0x000ea20000205400ULL, 0x0000005f5e00720bULL, 0x002fe20003f1d000ULL,
0x00010000225e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000002200487306ULL, 0x0002f0000000d400ULL, 0x0000004d004e7306ULL, 0x000fe20000209400ULL,
0x0000006400227245ULL, 0x002fc8000020d400ULL, 0x0000000122226812ULL, 0x000fe400078efcffULL,
0x0000004a5b00720bULL, 0x004fe20003fdd000ULL, 0x0000004d004f7306ULL, 0x000e620000205400ULL,
0x00010000234a7824ULL, 0x000fe200078e00ffULL, 0x0000000148482812ULL, 0x008fc800078efcffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000005e00647306ULL, 0x000ff00000209400ULL,
0x0000005e005b7306ULL, 0x000ea20000205400ULL, 0x0000004f4e00720bULL, 0x002fc40003f5d000ULL,
0x00000018ff4e7819ULL, 0x000fca0000011445ULL, 0x0000002300507306ULL, 0x0002ec000000d400ULL,
0x0000000174742812ULL, 0x000fe400078efcffULL, 0x0000005500547306ULL, 0x000fe20000209400ULL,
0x0000005600237245ULL, 0x002fc8000020d400ULL, 0x0000000123236812ULL, 0x000fe400078efcffULL,
0x0000005b6400720bULL, 0x004fe20003fdd000ULL, 0x00000055005f7306ULL, 0x0002a20000205400ULL,
0x0000000150500812ULL, 0x008fe400078efcffULL, 0x00000018ff5b7819ULL, 0x000fca0000011444ULL,
0x0000003e00617306ULL, 0x000fe20000009400ULL, 0x0000005500557245ULL, 0x002fce000020d400ULL,
0x0000003e00607306ULL, 0x000e620000005400ULL, 0x0000005f5400720bULL, 0x004fe40003f1d000ULL,
0x0000005e00547245ULL, 0x000fc8000020d400ULL, 0x0000000154546812ULL, 0x000fe200078efcffULL,
0x0000004a00667306ULL, 0x000fec0000209400ULL, 0x0000000155550812ULL, 0x000fe400078efcffULL,
0x0000004a004f7306ULL, 0x0004e20000205400ULL, 0x000000606100720bULL, 0x002fe20003fbd000ULL,
0x000001003f617824ULL, 0x000fe200078e00ffULL, 0x000000545554723eULL, 0x000fc800000010ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000000b00637306ULL, 0x000fe20000209400ULL,
0x0000004a004a7245ULL, 0x004fce000020d400ULL, 0x0000000b00607306ULL, 0x0002a20000205400ULL,
0x0000004f6600720bULL, 0x008fe40003fdd000ULL, 0x0000005c004f7245ULL, 0x000fca000020d400ULL,
0x0000005c003d7306ULL, 0x000fe20000209400ULL, 0x00000018ff0b7819ULL, 0x002fca0000011447ULL,
0x000000014a4a6812ULL, 0x000fe400078efcffULL, 0x0000005c00567306ULL, 0x000e620000205400ULL,
0x000000606300720bULL, 0x004fe20003fdd000ULL, 0x0000010044607824ULL, 0x000fca00078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000005900627306ULL, 0x000fec0000209400ULL,
0x000000016b6b6812ULL, 0x000fe400078efcffULL, 0x00000059006c7306ULL, 0x000ea20000205400ULL,
0x000000563d00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff3d7819ULL, 0x000fca0000011446ULL,
0x0000003e00497306ULL, 0x000e6c000000d400ULL, 0x000000014f4f0812ULL, 0x000fe400078efcffULL,
0x0000006100677306ULL, 0x000fe20000209400ULL, 0x0000006c6200720bULL, 0x004fe40003fdd000ULL,
0x00000059006c7245ULL, 0x000fc4000020d400ULL, 0x0000004a4f55723eULL, 0x000fc600000010ffULL,
0x00000061003e7306ULL, 0x0004e20000205400ULL, 0x0000000149495812ULL, 0x002fca00078efcffULL,
0x000000016c6c6812ULL, 0x000fe400078efcffULL, 0x0000003f00337306ULL, 0x000e62000000d400ULL,
0x0000006100617245ULL, 0x004fce000020d400ULL, 0x0000006d006f7306ULL, 0x000fe20000209400ULL,
0x0000003e6700720bULL, 0x008fe20003f1d000ULL, 0x0000010045677824ULL, 0x000fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000006d003f7306ULL, 0x000ea20000205400ULL,
0x0000000133334812ULL, 0x002fca00078efcffULL, 0x0000000161610812ULL, 0x000fe400078efcffULL,
0x0000004500707306ULL, 0x000fe40000009400ULL, 0x00000033614d723eULL, 0x000fe400000010ffULL,
0x000000064b33723eULL, 0x000fc800000010ffULL, 0x0000004500577306ULL, 0x000e620000005400ULL,
0x0000003f6f00720bULL, 0x004fe40003fbd000ULL, 0x00000032100c723cULL, 0x000bea000004180cULL,
0x0000004600587306ULL, 0x000fe40000009400ULL, 0x0000005b00327245ULL, 0x020fcc000020d400ULL,
0x0000004600517306ULL, 0x000ea20000005400ULL, 0x000000577000720bULL, 0x002fe20003f9d000ULL,
0x0001000044577824ULL, 0x000fe200078e00ffULL, 0x0000004c00707245ULL, 0x000fe4000020d400ULL,
0x000000496b4c723eULL, 0x000fe400000010ffULL, 0x0000000170703812ULL, 0x000fe200078efcffULL,
0x0000004700537306ULL, 0x000fe20000009400ULL, 0x00000018ff577819ULL, 0x000fc60000011457ULL,
0x0000004c3418723cULL, 0x000be80000041818ULL, 0x00000047005d7306ULL, 0x000e620000005400ULL,
0x000000515800720bULL, 0x004fe20003fdd000ULL, 0x0001000045587824ULL, 0x000fe200078e00ffULL,
0x00000067004d7245ULL, 0x020fe2000020d400ULL, 0x0000010046517824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000006000687306ULL, 0x000fe20000209400ULL,
0x00000018ff517819ULL, 0x000fce0000011451ULL, 0x0000006000627306ULL, 0x0005e20000205400ULL,
0x0000005d5300720bULL, 0x002fce0003f7d000ULL, 0x0000004400657306ULL, 0x000fe20000009400ULL,
0x0000006000607245ULL, 0x004fce000020d400ULL, 0x0000004400717306ULL, 0x000e700000005400ULL,
0x0000004400407306ULL, 0x000eb0000000d400ULL, 0x00000067006f7306ULL, 0x000fe20000209400ULL,
0x000000716500720bULL, 0x002fce0003f1d000ULL, 0x0000006700447306ULL, 0x000e6c0000205400ULL,
0x0000000140400812ULL, 0x004fe400078efcffULL, 0x0000004500417306ULL, 0x0004f0000000d400ULL,
0x0000005b00647306ULL, 0x000fe20000209400ULL, 0x0000006d00457245ULL, 0x004fc4000020d400ULL,
0x000000446f00720bULL, 0x002fe20003f5d000ULL, 0x0000010047447824ULL, 0x000fe200078e00ffULL,
0x0000000145455812ULL, 0x000fe400078efcffULL, 0x000000626800720bULL, 0x000fe20003fbd000ULL,
0x0000005b00667306ULL, 0x000e620000205400ULL, 0x00000018ff497819ULL, 0x000fe40000011444ULL,
0x0000006c7044723eULL, 0x000fe400000010ffULL, 0x000000457445723eULL, 0x000fc400000010ffULL,
0x0000000141414812ULL, 0x008fe200078efcffULL, 0x0000005800537306ULL, 0x000fe20000209400ULL,
0x000000014d4d2812ULL, 0x000fc600078efcffULL, 0x0000000160605812ULL, 0x000fe200078efcffULL,
0x000000443414723cULL, 0x000be20000041814ULL, 0x000000414d41723eULL, 0x000fe400000010ffULL,
0x0000005800687306ULL, 0x0004e20000205400ULL, 0x000000666400720bULL, 0x002fe40003fbd000ULL,
0x000000406040723eULL, 0x000fe400000010ffULL, 0x000000482244723eULL, 0x020fe400000010ffULL,
0x000000502345723eULL, 0x000fe200000010ffULL, 0x0000004e005f7306ULL, 0x000fe20000209400ULL,
0x0000005800587245ULL, 0x004fca000020d400ULL, 0x0000000132325812ULL, 0x000fe400078efcffULL,
0x0000004e005e7306ULL, 0x000e620000205400ULL, 0x000000685300720bULL, 0x008fe40003f9d000ULL,
0x000000202153723eULL, 0x000fca00000010ffULL, 0x0000005700637306ULL, 0x000fe40000209400ULL,
0x000000521020723cULL, 0x000f680000041824ULL, 0x0000000158584812ULL, 0x000fe400078efcffULL,
0x0000005700657306ULL, 0x0004e20000205400ULL, 0x0000005e5f00720bULL, 0x002fce0003f1d000ULL,
0x00000051005d7306ULL, 0x000fe20000209400ULL, 0x0000005700577245ULL, 0x004fce000020d400ULL,
0x0000005100627306ULL, 0x000e620000205400ULL, 0x000000656300720bULL, 0x008fce0003f5d000ULL,
0x0000004600437306ULL, 0x0004ec000000d400ULL, 0x0000000157572812ULL, 0x000fe400078efcffULL,
0x00000047003c7306ULL, 0x0008e2000000d400ULL, 0x0001000046467824ULL, 0x004fe200078e00ffULL,
0x000000625d00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff4c7819ULL, 0x000fe40000011446ULL,
0x0000004900597306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x010fe200078e00ffULL,
0x0000000143436812ULL, 0x008fc800078efcffULL, 0x00000018ff067819ULL, 0x000fe40000011447ULL,
0x0000004900617306ULL, 0x000e620000205400ULL, 0x000000441044723cULL, 0x000b620000041828ULL,
0x00000006004d7245ULL, 0x000fe4000020d400ULL, 0x000000013c3c3812ULL, 0x000fc800078efcffULL,
0x0000003d00567306ULL, 0x000fe20000209400ULL, 0x0000004e00297245ULL, 0x020fe2000020d400ULL,
0x000000541010723cULL, 0x000b62000004182cULL, 0x00000051002a7245ULL, 0x000fe4000020d400ULL,
0x0000000129290812ULL, 0x000fe400078efcffULL, 0x000000012a2a5812ULL, 0x000fe200078efcffULL,
0x0000003d005c7306ULL, 0x0004e20000205400ULL, 0x000000615900720bULL, 0x002fe40003f1d000ULL,
0x00000049002d7245ULL, 0x020fc4000020d400ULL, 0x000000573228723eULL, 0x000fe400000010ffULL,
0x000000582929723eULL, 0x000fe200000010ffULL, 0x0000000b003e7306ULL, 0x000fe20000209400ULL,
0x0000003d003d7245ULL, 0x004fe4000020d400ULL, 0x000000432a2c723eULL, 0x000fc600000010ffULL,
0x000000012d2d0812ULL, 0x000fe200078efcffULL, 0x000000283428723cULL, 0x000f620000041820ULL,
0x0000000b003f7306ULL, 0x000e620000205400ULL, 0x0000005c5600720bULL, 0x008fe40003f5d000ULL,
0x0000003c2d2d723eULL, 0x000fca00000010ffULL, 0x0000004c005e7306ULL, 0x000fe40000209400ULL,
0x0000002c342c723cULL, 0x000f680000041844ULL, 0x000000013d3d2812ULL, 0x000fe400078efcffULL,
0x0000004c004b7306ULL, 0x0004e20000205400ULL, 0x0000003f3e00720bULL, 0x002fce0003f9d000ULL,
0x0000000600337306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x004fce000020d400ULL,
0x0000000600247306ULL, 0x000e620000205400ULL, 0x0000004b5e00720bULL, 0x008fda0003fbd000ULL,
0x000000014c4c5812ULL, 0x000fe400078efcffULL, 0x000000243300720bULL, 0x002fe40003fdd000ULL,
0x000000403424723cULL, 0x000b62000004180cULL, 0x0000004c3d4c723eULL, 0x000fcc00000010ffULL,
0x0000000b000c7245ULL, 0x020fc8000020d400ULL, 0x000000010c0c4812ULL, 0x000fe400078efcffULL,
0x000000014d4d6812ULL, 0x000fc800078efcffULL, 0x0000004d0c4d723eULL, 0x000fce00000010ffULL,
0x0000004c3434723cULL, 0x000b620000041810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x00000000050c7f8cULL, 0x0002a2000c80043fULL, 0x0000000103037810ULL, 0x000fe40007ffe0ffULL,
0x0000f6a075067811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff0b7224ULL, 0x004fe200078e000dULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff296000007947ULL, 0x000fea000383ffffULL,
0x000000ff6a00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000031007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000ec5000047802ULL, 0x000fc40000000f00ULL,
0x0000856000007944ULL, 0x02efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003100007308ULL, 0x000f240000001000ULL, 0xbf80000000027423ULL, 0x010fc80000000031ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006b00ff037624ULL, 0x000fe400078e00ffULL,
0x00006a00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x000ee80000000000ULL, 0x0000000000077919ULL, 0x004ea20000000000ULL,
0x00000002ff067819ULL, 0x008fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x012fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003800387220ULL, 0x042fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x060fe20000410000ULL,
0x0000003500357220ULL, 0x000fe20000410000ULL, 0x0000003a043a7220ULL, 0x044fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x000fc20000410000ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x000000282928723eULL, 0x000fc400000010ffULL, 0x0000002c2d2c723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000343534723eULL, 0x020fe400000010ffULL,
0x0000001a1b1a723eULL, 0x000fe400000010ffULL, 0x000000262726723eULL, 0x000fc400000010ffULL,
0x0000002a2b13723eULL, 0x000fe400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x00000002ff077819ULL, 0x106fe20000011605ULL, 0x000000017c7c7824ULL, 0x000fe200078e0205ULL,
0x0000000205007812ULL, 0x040fe400078ec0ffULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x00000008070b7824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x040fe200078ff8ffULL,
0x00000008070d7824ULL, 0x000fe200078e00ffULL, 0x0000000900037211ULL, 0x000fe200078ff8ffULL,
0x00000008090e7824ULL, 0x000fe200078e00ffULL, 0x0000000202007810ULL, 0x040fe20007ffe0ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000000402047810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000100072037824ULL, 0x000fe200078e00ffULL,
0xfffffff80b067812ULL, 0x008fe400078ee200ULL, 0xfffffff809007812ULL, 0x000fe200078ee202ULL,
0x000008006e077824ULL, 0x000fe200078e0203ULL, 0x0000000602087810ULL, 0x000fe20007ffe0ffULL,
0x0000000805027824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x100fe200078e0207ULL, 0x000000383900723eULL, 0x000fe200000010ffULL,
0x000000100e0e7824ULL, 0x100fe200078e0207ULL, 0x0000000802097812ULL, 0x000fe200078ec0ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0207ULL, 0x0000001c1d02723eULL, 0x000fe200000010ffULL,
0x000000107c7c7824ULL, 0x000fe200078e0203ULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee208ULL,
0x0000001006087824ULL, 0x000fe200078e0207ULL, 0x0000541000107816ULL, 0x100fe20000000002ULL,
0x0000000104067824ULL, 0x000fe200078e0209ULL, 0x0000763200117816ULL, 0x000fe20000000002ULL,
0x000000100c0c7824ULL, 0x000fe200078e0207ULL, 0x000000181900723eULL, 0x000fe200000010ffULL,
0x0000000109087824ULL, 0x000fe200078e0208ULL, 0x000000141502723eULL, 0x000fe200000010ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x000000242504723eULL, 0x000fe200000010ffULL,
0x00000001090a7824ULL, 0x040fe200078e020aULL, 0x0000763200077816ULL, 0x000fe20000000002ULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x00000016170d723eULL, 0x000fe200000010ffULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x000000363717723eULL, 0x000fc400000010ffULL,
0x0000763226097816ULL, 0x000fe40000000013ULL, 0x000076322e0f7816ULL, 0x000fe40000000017ULL,
0x0000541000067816ULL, 0x002fe40000000002ULL, 0x0000003a3b00723eULL, 0x000fe400000010ffULL,
0x0000001e1f02723eULL, 0x000fe200000010ffULL, 0x0000000608007388ULL, 0x0003e40000000a00ULL,
0x0000541004067816ULL, 0x002fc40000000028ULL, 0x0000763204077816ULL, 0x000fca0000000028ULL,
0x000000060a007388ULL, 0x0003e40000000a00ULL, 0x000054102c067816ULL, 0x142fe40000000034ULL,
0x000076322c077816ULL, 0x000fca0000000034ULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x0000541000067816ULL, 0x142fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x000000ff00007306ULL, 0x000fe60000205400ULL, 0x000000060e007388ULL, 0x0003e40000000a00ULL,
0x000054101a067816ULL, 0x002fc4000000000dULL, 0x000076321a077816ULL, 0x000fe4000000000dULL,
0x000054102e0e7816ULL, 0x000fc60000000017ULL, 0x0004000608007388ULL, 0x0003e40000000a00ULL,
0x0000541026087816ULL, 0x002fe20000000013ULL, 0x000000ff00077306ULL, 0x000e680000209400ULL,
0x000400080a007388ULL, 0x000fe80000000a00ULL, 0x0004000e0c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000007c107984ULL, 0x000ea20000000c00ULL,
0x000000000700720bULL, 0x002fc40003f1d000ULL, 0x000000ff00007245ULL, 0x000fe2000020d400ULL,
0x000400007c087984ULL, 0x000e680000000c00ULL, 0x000800007c147984ULL, 0x000ee80000000c00ULL,
0x000c00007c187984ULL, 0x000f240000000c00ULL, 0x0000000100000812ULL, 0x000fc400078efcffULL,
0x000000ff6e00720cULL, 0x000fe40003f05270ULL, 0x000000000004723eULL, 0x000fca00000010ffULL,
0x3f803f8004137831ULL, 0x044fe40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x040fe40000200010ULL,
0x3f803f80040b7831ULL, 0x042fe4000020000bULL, 0x3f803f80040a7831ULL, 0x000fc4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fc40000200014ULL,
0x3f803f800b0b7831ULL, 0x010fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x000000107c007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x000400087c007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x000fc80000011605ULL, 0x000000790400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104007824ULL, 0x100fe200078e0205ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a0077777a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007050d7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff800007812ULL, 0x000fe200078ef805ULL,
0x0000580000067ab9ULL, 0x000fc40000000800ULL, 0x00000008720d7824ULL, 0x000fe400078e020dULL,
0x0000001000027824ULL, 0x000fe400078e0203ULL, 0x000000107a007824ULL, 0x000fc600078e0204ULL,
0x0000000002087984ULL, 0x0004e40000000c00ULL, 0x0000000500067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011600ULL, 0x00000006040472a4ULL, 0x002fe4000f8e023fULL,
0x0000000177067824ULL, 0x000fe200078e0206ULL, 0x0000002005027810ULL, 0x004fc60007ffe0ffULL,
0x0000007d04077224ULL, 0x000fe200078e0206ULL, 0x00000003ff0f7819ULL, 0x000fe20000011602ULL,
0x000000047d007c24ULL, 0x000fca000f8e02ffULL, 0x0000000700077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f4404ULL, 0x000000790f00720cULL, 0x000fc60003f06070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000102047824ULL, 0x100fe200078e020fULL,
0x00000040050c7810ULL, 0x000fe20007ffe0ffULL, 0x000000107a0f7824ULL, 0x000fe200078e020fULL,
0x00000007020d7812ULL, 0x000fe400078ec0ffULL, 0x0000000704077812ULL, 0x002fc400078ec0ffULL,
0x00005a00ff067a19ULL, 0x000fe2000001160fULL, 0x00000008720d7824ULL, 0x000fe200078e020dULL,
0x0ffffff807047812ULL, 0x000fe400078ef802ULL, 0x000000050f077c12ULL, 0x000fe4000f8e30ffULL,
0x00000003ff0f7819ULL, 0x000fe2000001160cULL, 0x0000001004047824ULL, 0x000fe400078e0203ULL,
0x0000000177077824ULL, 0x000fc600078e0207ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000007d06077224ULL, 0x000fca00078e0207ULL, 0x0000000700077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f440eULL, 0x000000790f00720cULL, 0x000fc60003f06070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe400078e020fULL,
0x000000107a0f7824ULL, 0x000fc600078e020fULL, 0x0000000702077812ULL, 0x002fe400078ec0ffULL,
0x000000050f067c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff807027812ULL, 0x000fe400078ef80cULL,
0x00005a00ff047a19ULL, 0x000fe2000001160fULL, 0x0000000177067824ULL, 0x000fe400078e0206ULL,
0x0000001002027824ULL, 0x000fe400078e0203ULL, 0x0000007d04077224ULL, 0x000fe200078e0206ULL,
0x0000006005067810ULL, 0x000fc40007ffe0ffULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x00000007000e7210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011606ULL,
0x000000070c077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x00005c000e047a11ULL, 0x000fe200078040ffULL, 0x0000000106027824ULL, 0x002fe400078e020dULL,
0x0000000872077824ULL, 0x000fe200078e0207ULL, 0x00005d000e057a11ULL, 0x000fc400000f4405ULL,
0x000000790d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000702077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807027812ULL, 0x000fe200078ef806ULL,
0x0000000804007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e0203ULL, 0x0000000706057812ULL, 0x000fe200078ec0ffULL,
0x000000107a0d7824ULL, 0x000fc600078e020dULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000872057824ULL, 0x000fe200078e0205ULL, 0x000000050d037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fc6000001160dULL, 0x0000000177037824ULL, 0x000fc800078e0203ULL,
0x0000007d02037224ULL, 0x000fca00078e0203ULL, 0x0000000300037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4400ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006a00ff067624ULL, 0x000fe400078e00ffULL, 0x00006b00ff077624ULL, 0x000fca00078e00ffULL,
0x0000000806027981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x000000020c6e7824ULL, 0x000fe200078e00ffULL,
0x00f60000ff067f8cULL, 0x002e62000c80043fULL, 0x00000040047a7824ULL, 0x000fe400078e00ffULL,
0x000059006e6e7a24ULL, 0x000fc800078e0277ULL, 0x000066006e057a24ULL, 0x000fc800078e027aULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x000fe40000011600ULL,
0x0000007a69157217ULL, 0x000fe40007800000ULL, 0x000000081c167810ULL, 0x040fe20007ffe0ffULL,
0x0000000105087824ULL, 0x040fe200078e021cULL, 0x000000181c1f7810ULL, 0x040fe40007ffe0ffULL,
0x000000101c1e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001050a7824ULL, 0x000fe200078e0216ULL,
0x000000201c187810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00001000041b7811ULL, 0x000fc400078e68ffULL, 0x000000281c1a7810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008107812ULL, 0x000fc600078ef803ULL,
0x00000001050e7824ULL, 0x040fe200078e021fULL, 0x000000300a127812ULL, 0x100fe200078ef803ULL,
0x00000001050c7824ULL, 0x000fe200078e021eULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fe40007f3e0ffULL,
0x0000630009117a10ULL, 0x000fe200007fe4ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300e0a7812ULL, 0x100fe400078ef803ULL, 0x000063000b137a10ULL, 0x000fe20000ffe4ffULL,
0x00000001150e7824ULL, 0x000fe200078e0a7aULL, 0x000000300c087812ULL, 0x000fe200078ef803ULL,
0x00000001050c7824ULL, 0x000fe200078e0218ULL, 0x000062000a0a7a10ULL, 0x000fc40007f3e0ffULL,
0x0000620008087a10ULL, 0x000fe40007f1e0ffULL, 0x000063000f0b7a10ULL, 0x000fe40000ffe4ffULL,
0x000063000d097a10ULL, 0x000fe200007fe4ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x00000000000f7211ULL, 0x000fe400078fe8ffULL, 0x0000000e1c00720cULL, 0x000fe40003f06070ULL,
0x000000030f197812ULL, 0x000fc400078ec0ffULL, 0x000000300c147812ULL, 0x000fe200078ef803ULL,
0x00000004160c7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc19007812ULL, 0x000fe400078ef800ULL,
0x0000620014147a10ULL, 0x000fe40007f5e0ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee219ULL,
0x00000010000f7824ULL, 0x100fe200078e021bULL, 0x000063000d157a10ULL, 0x000fe200017fe4ffULL,
0x0000000105007824ULL, 0x000fe200078e021aULL, 0x0000000e1600720cULL, 0x000fe20003f26070ULL,
0x000000100c1d7824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0005e2000c101c48ULL, 0x00000080000c7825ULL, 0x000fe200078e00ffULL,
0x000000301c007810ULL, 0x000fc40007ffe0ffULL, 0x000000381c1c7810ULL, 0x000fe40007ffe0ffULL,
0x000000300c167812ULL, 0x000fe200078ef803ULL, 0x00000001050c7824ULL, 0x000fe200078e0200ULL,
0x0000000e1e00720cULL, 0x0c0fe20003fa6070ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x0000620016167a10ULL, 0x000fe20007fde0ffULL, 0x00000000121d7faeULL, 0x0007e2000c901c48ULL,
0x0000000e1f00720cULL, 0x0c0fe20003f86070ULL, 0x000000041f107824ULL, 0x004fe200078e00ffULL,
0x000063000d177a10ULL, 0x000fe200037fe4ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000e1800720cULL, 0x000fc40003f66070ULL, 0x0000000e1a00720cULL, 0x080fe40003f46070ULL,
0x0000000e0000720cULL, 0x080fe40003f26070ULL, 0x0000000e1c00720cULL, 0x000fe20003f06070ULL,
0x00000001050e7824ULL, 0x000fe200078e021cULL, 0x000000300c0c7812ULL, 0x000fe200078ef803ULL,
0x0000000418127824ULL, 0x008fe200078e00ffULL, 0xfffffffc10107812ULL, 0x000fe200078ee219ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000062000c0c7a10ULL, 0x000fc40007fde0ffULL,
0xfffffffc12127812ULL, 0x000fe200078ee219ULL, 0x000000041a187824ULL, 0x000fe200078e00ffULL,
0x000000300e0e7812ULL, 0x000fe200078ef803ULL, 0x00000004001a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e007812ULL, 0x100fe200078ee219ULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc18187812ULL, 0x000fe200078ee219ULL, 0x0000001010057824ULL, 0x000fe200078e021bULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee219ULL, 0x0000001000037824ULL, 0x000fe200078e021bULL,
0xfffffffc1c1c7812ULL, 0x000fe200078ee219ULL, 0x0000001012117824ULL, 0x100fe200078e021bULL,
0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x0000001018137824ULL, 0x100fe200078e021bULL,
0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x000000101a197824ULL, 0x100fe200078e021bULL,
0x0000000008037faeULL, 0x0005e2000e901c48ULL, 0x000000101c1b7824ULL, 0x000fe200078e021bULL,
0x000063000f0f7a10ULL, 0x000fc400037fe4ffULL, 0x000000000a057faeULL, 0x0005e8000e101c48ULL,
0x0000000014117faeULL, 0x0005e8000d901c48ULL, 0x0000000016137faeULL, 0x0005e8000d101c48ULL,
0x000000000c197faeULL, 0x0005e8000c901c48ULL, 0x000000000e1b7faeULL, 0x0005e2000c101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000010000c7811ULL, 0x040fe400078ff0ffULL,
0x00000018000e7811ULL, 0x000fc400078ff0ffULL, 0x0000002800127811ULL, 0x040fe200078ff0ffULL,
0x00000001050d7824ULL, 0x040fe200078e020cULL, 0x0000003800167811ULL, 0x040fe200078ff0ffULL,
0x00000001050f7824ULL, 0x040fe200078e020eULL, 0x0000000800187811ULL, 0x040fe200078ff0ffULL,
0x00000001051a7824ULL, 0x040fe200078e0212ULL, 0x0000002000107811ULL, 0x040fe200078ff0ffULL,
0x00000001051e7824ULL, 0x000fe200078e0216ULL, 0x0000003000147811ULL, 0x000fe200078ff0ffULL,
0x0000000418207824ULL, 0x000fe200078e00ffULL, 0x0000000000097211ULL, 0x000fe200078fe8ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000500087211ULL, 0x000fe200078ff0ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x00000003090b7812ULL, 0x000fe200078ec0ffULL,
0x0000000410227824ULL, 0x000fe200078e00ffULL, 0x0000100004237811ULL, 0x000fe200078e68ffULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e117812ULL, 0x100fe200078ee20bULL,
0x0000000414247824ULL, 0x000fe200078e00ffULL, 0xfffffffc22137812ULL, 0x000fe200078ee20bULL,
0x0000000416167824ULL, 0x000fc400078e00ffULL, 0x00000001050a7824ULL, 0x040fe200078e0218ULL,
0xfffffffc24157812ULL, 0x100fe200078ee20bULL, 0x0000000105187824ULL, 0x040fe200078e0210ULL,
0xfffffffc0c107812ULL, 0x100fe200078ee20bULL, 0x00000001051c7824ULL, 0x000fe200078e0214ULL,
0x0ffffffc0b057812ULL, 0x000fe200078ef800ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc20007812ULL, 0x100fe400078ee20bULL, 0xfffffffc12147812ULL, 0x100fe200078ee20bULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc16167812ULL, 0x000fc400078ee20bULL,
0x0000003008127812ULL, 0x100fe200078ef803ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000300c177812ULL, 0x000fe400078ef803ULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x00000010141f7824ULL, 0x000fe200078e0223ULL, 0x000000300a147812ULL, 0x000fe200078ef803ULL,
0x0000001005257824ULL, 0x000fe400078e0223ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x0000620014147a10ULL, 0x000fc60007f3e0ffULL, 0x0000001000057824ULL, 0x000fe200078e0223ULL,
0x000000300e0e7812ULL, 0x000fe200078ef803ULL, 0x0000001010197824ULL, 0x100fe400078e0223ULL,
0x00000010111b7824ULL, 0x100fe400078e0223ULL, 0x00000010131d7824ULL, 0x100fe200078e0223ULL,
0x0000630009137a10ULL, 0x000fe200007fe4ffULL, 0x0000001015217824ULL, 0x100fe200078e0223ULL,
0x000063000b157a10ULL, 0x000fe20000ffe4ffULL, 0x0000001016237824ULL, 0x000fe200078e0223ULL,
0x0000620017167a10ULL, 0x000fe20007f5e0ffULL, 0x0000008018087825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012257faeULL, 0x0005e2000b901c48ULL, 0x000063000d177a10ULL, 0x000fe200017fe4ffULL,
0x000000801a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008087812ULL, 0x100fe200078ef803ULL,
0x0000000014057faeULL, 0x0005e2000b901c48ULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x000000801c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x100fe200078ef803ULL,
0x0000000016197faeULL, 0x0005e2000b901c48ULL, 0x0000620008087a10ULL, 0x000fe20007f1e0ffULL,
0x000000801e107825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x000fe200078ef803ULL,
0x000000000e1b7faeULL, 0x0005e2000b901c48ULL, 0x000062000a0a7a10ULL, 0x000fc40007f3e0ffULL,
0x0000003010037812ULL, 0x000fe400078ef803ULL, 0x000062000c0c7a10ULL, 0x000fe40007f5e0ffULL,
0x0000620003107a10ULL, 0x000fe40007f7e0ffULL, 0x0000630009097a10ULL, 0x000fe400007fe4ffULL,
0x000063000b0b7a10ULL, 0x000fe40000ffe4ffULL, 0x000063000d0d7a10ULL, 0x000fe200017fe4ffULL,
0x00000000081d7faeULL, 0x0005e2000b901c48ULL, 0x0000630011117a10ULL, 0x000fc60001ffe4ffULL,
0x000000000a1f7faeULL, 0x0005e8000b901c48ULL, 0x000000000c217faeULL, 0x0005e8000b901c48ULL,
0x0000000010237faeULL, 0x0005e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x004fc40000015200ULL, 0x00f60400ff037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x006fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08037210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e09ULL,
0x003d09000300780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400300780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140aULL, 0x0000000300007211ULL, 0x000fca00078110ffULL,
0x000000ffff037224ULL, 0x000fca00000e060aULL, 0x0000000200007819ULL, 0x000fc80000001203ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002004007824ULL, 0x002fca00078e0203ULL, 0x00000003ff037819ULL, 0x000fc80000011600ULL,
0x1ffffffe03057812ULL, 0x000fe400078ec0ffULL, 0x0000000f00037812ULL, 0x000fc600078ec0ffULL,
0x0000000100057824ULL, 0x000fe400078e0205ULL, 0x0000001003077824ULL, 0x040fe400078e00ffULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x0000000f05007812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f007007812ULL, 0x000fe400078ee200ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x00000000000c7984ULL, 0x000e62000000cc00ULL,
0x000000f006057812ULL, 0x000fca00078ee205ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001000007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff057224ULL, 0x002fc600078e00ffULL, 0x0000000000067805ULL, 0x000fc80000015200ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806037210ULL, 0x000fca0007f1e1ffULL, 0x0000000109087824ULL, 0x000fe200000e0e07ULL,
0x003d09000300780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400300780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011408ULL, 0x0000000300007211ULL, 0x000fca00078110ffULL,
0x000000ffff037224ULL, 0x000fca00000e0608ULL, 0x0000000200007819ULL, 0x000fc80000001203ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6a00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x0000001fff007424ULL, 0x000fe200078e00ffULL, 0x8000580069777a10ULL, 0x000fe20007ffe0ffULL,
0x00000001ff787424ULL, 0x000fe200078e00ffULL, 0x3db504f302067820ULL, 0x010fe20000410000ULL,
0x00005800ff6f7624ULL, 0x000fe200078e00ffULL, 0x0000580000007a10ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000f68804797811ULL, 0x000fe200078e18ffULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00000004ff007819ULL, 0x000fc40000011600ULL,
0x0000f608047b7811ULL, 0x000fe400078e28ffULL, 0x0000580078787a10ULL, 0x000fe40007ffe1ffULL,
0x000000096f6f7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff777819ULL, 0x000fe40000011677ULL,
0x0ffffffe00717812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e0008ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x00cfc4000001ff00ULL,
0x000000010a00780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x0000000107037810ULL, 0x020fc40007ffe0ffULL, 0x000000010a007810ULL, 0x000fe40007ffe0ffULL,
0x0000000109087812ULL, 0x000fe400078e0cffULL, 0x000000020000780cULL, 0x040fe40003f06070ULL,
0x000000ff00027207ULL, 0x000fc60000800000ULL, 0x000000ffff031224ULL, 0x000fc800078e0207ULL,
0x0000010003157824ULL, 0x040fe200078e027aULL, 0x00000001030b7810ULL, 0x000fc80007ffe0ffULL,
0x0000006a0b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff0b7224ULL, 0x000fe400078e000aULL,
0x000000ffff0a7224ULL, 0x000fe400078e0000ULL, 0x000066006e007a24ULL, 0x000fd000078e0215ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x0000001005037824ULL, 0x002fe200078e00ffULL,
0x00000002ff417819ULL, 0x000fe20000011605ULL, 0x00000002042d7824ULL, 0x000fe200078e0208ULL,
0x0000001569147217ULL, 0x000fe40007800000ULL, 0x0000003003037812ULL, 0x000fe200078ec0ffULL,
0x00000001410d7824ULL, 0x140fe200078e0200ULL, 0x00000008412f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001142c7824ULL, 0x000fe200078e0a15ULL, 0x0000001841437810ULL, 0x040fe20007ffe0ffULL,
0x0000004002027824ULL, 0x000fe200078e0203ULL, 0x00000010413d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x0000002041457810ULL, 0x000fe20007ffe0ffULL,
0x000000012f0f7824ULL, 0x000fe200078e0200ULL, 0x000010002d2d7811ULL, 0x000fe200078e60ffULL,
0x000000800d0c7825ULL, 0x000fe200078e0002ULL, 0x0000002841477810ULL, 0x000fc40007ffe0ffULL,
0x0000003041497810ULL, 0x000fe20007ffe0ffULL, 0x00000001431b7824ULL, 0x100fe200078e0200ULL,
0x000062000c167a10ULL, 0x000fe20007f3e0ffULL, 0x000000013d197824ULL, 0x000fe200078e0200ULL,
0x0000002c4300720cULL, 0x000fe20003fa6070ULL, 0x000000800f0e7825ULL, 0x000fe200078e0002ULL,
0x000063000d177a10ULL, 0x000fc60000ffe4ffULL, 0x000000801b1a7825ULL, 0x100fe200078e0002ULL,
0x000062000e147a10ULL, 0x000fe40007f5e0ffULL, 0x00000005050e7211ULL, 0x000fe200078fe8ffULL,
0x0000008019187825ULL, 0x000fe200078e0002ULL, 0x000062001a0c7a10ULL, 0x000fe40007f3e0ffULL,
0x000000030e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000443437824ULL, 0x000fe200078e00ffULL,
0x0000620018187a10ULL, 0x000fe40007f7e0ffULL, 0x000063000f157a10ULL, 0x000fe200017fe4ffULL,
0x00000001450f7824ULL, 0x100fe200078e0200ULL, 0x000063001b0d7a10ULL, 0x000fe20000ffe4ffULL,
0x00000001471b7824ULL, 0x000fe200078e0200ULL, 0x0000002c2f00720cULL, 0x0c0fe20003f46070ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0x0000630019197a10ULL, 0x000fe20001ffe4ffULL,
0x000000800f0e7825ULL, 0x000fe200078e0002ULL, 0x0000002c4100720cULL, 0x000fc40003f26070ULL,
0x0000002c3d00720cULL, 0x040fe20003f66070ULL, 0x000000043d3d7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc2e1a7812ULL, 0x000fe400078ef805ULL, 0xfffffffc2f3c7812ULL, 0x100fe400078ee22eULL,
0x000062000e0e7a10ULL, 0x000fe20007f9e0ffULL, 0x000000101a2f7824ULL, 0x100fe200078e022dULL,
0xfffffffc3d1a7812ULL, 0x000fe200078ee22eULL, 0x000000103c3d7824ULL, 0x000fe200078e022dULL,
0x0000003841417810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000162f7faeULL, 0x0003e2000c901c48ULL, 0x000000101a3f7824ULL, 0x000fe200078e022dULL,
0x000063000f0f7a10ULL, 0x000fe200027fe4ffULL, 0x000000801b1a7825ULL, 0x000fe200078e0002ULL,
0x00000000143d7faeULL, 0x0005e2000d101c48ULL, 0x0000002c4500720cULL, 0x0c0fe40003f86070ULL,
0x0000000445457824ULL, 0x000fe200078e00ffULL, 0x00000000183f7faeULL, 0x0007e2000d901c48ULL,
0x0000002c4700720cULL, 0x0c0fe20003f66070ULL, 0x0000000447477824ULL, 0x000fe200078e00ffULL,
0x0000002c4900720cULL, 0x0c0fe20003f46070ULL, 0x0000000149177824ULL, 0x102fe200078e0200ULL,
0x0000002c4100720cULL, 0x040fe20003f26070ULL, 0x00000001412f7824ULL, 0x000fe200078e0200ULL,
0xfffffffc43007812ULL, 0x000fe200078ee22eULL, 0x0000008017167825ULL, 0x000fe200078e0002ULL,
0x000062001a147a10ULL, 0x004fc40007fde0ffULL, 0xfffffffc471a7812ULL, 0x000fe200078ee22eULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x000063001b157a10ULL, 0x000fe200037fe4ffULL,
0x0000000441417824ULL, 0x000fe200078e00ffULL, 0x0000620016167a10ULL, 0x000fe20007fde0ffULL,
0x000000802f027825ULL, 0x000fe200078e0002ULL, 0xfffffffc45187812ULL, 0x108fe400078ee22eULL,
0xfffffffc492c7812ULL, 0x100fe200078ee22eULL, 0x0000001000197824ULL, 0x100fe200078e022dULL,
0xfffffffc412e7812ULL, 0x000fe200078ee22eULL, 0x00000010181b7824ULL, 0x100fe200078e022dULL,
0x0000630017177a10ULL, 0x000fe200037fe4ffULL, 0x000000101a2f7824ULL, 0x100fe200078e022dULL,
0x0000620002027a10ULL, 0x000fe20007fde0ffULL, 0x000000102c3d7824ULL, 0x100fe200078e022dULL,
0x000000000c197faeULL, 0x0003e2000e901c48ULL, 0x000000102e2d7824ULL, 0x000fe200078e022dULL,
0x0000630003037a10ULL, 0x000fc400037fe4ffULL, 0x000000000e1b7faeULL, 0x0003e8000e101c48ULL,
0x00000000142f7faeULL, 0x0003e8000d901c48ULL, 0x00000000163d7faeULL, 0x0003e8000d101c48ULL,
0x00000000022d7faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000001005037824ULL, 0x042fe200078e00ffULL, 0x0000001005177811ULL, 0x040fe200078ff0ffULL,
0x00000002040d7824ULL, 0x000fe200078e0208ULL, 0x0000001805197811ULL, 0x000fc400078ff0ffULL,
0x0000003003037812ULL, 0x000fe200078ec0ffULL, 0x0000000117157824ULL, 0x100fe200078e0200ULL,
0x00000020051b7811ULL, 0x000fe200078ff0ffULL, 0x00000004193d7824ULL, 0x000fe200078e00ffULL,
0x00000028052d7811ULL, 0x040fe200078ff0ffULL, 0x0000004002027824ULL, 0x000fe200078e0203ULL,
0x0000000805037811ULL, 0x000fe200078ff0ffULL, 0x000000041b3f7824ULL, 0x000fe200078e00ffULL,
0x00000030052f7811ULL, 0x040fe400078ff0ffULL, 0x0000003805477811ULL, 0x000fe200078ff0ffULL,
0x00000001030f7824ULL, 0x100fe200078e0200ULL, 0x000010000d497811ULL, 0x000fe200078e60ffULL,
0x00000004170d7824ULL, 0x000fe200078e00ffULL, 0x00000005050c7211ULL, 0x000fe200078fe8ffULL,
0x0000000119177824ULL, 0x000fc400078e0200ULL, 0x000000011b197824ULL, 0x100fe200078e0200ULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000012d1b7824ULL, 0x000fe400078e0200ULL,
0x0000000403037824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d147812ULL, 0x100fe200078ee20cULL,
0x000000042d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3d167812ULL, 0x100fe200078ee20cULL,
0x000000042f417824ULL, 0x000fe200078e00ffULL, 0xfffffffc030e7812ULL, 0x100fe200078ee20cULL,
0x0000000447437824ULL, 0x000fe200078e00ffULL, 0xfffffffc3f187812ULL, 0x100fe200078ee20cULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0xfffffffc2d1a7812ULL, 0x000fe200078ee20cULL,
0x000000012f2d7824ULL, 0x000fe200078e0200ULL, 0xfffffffc412c7812ULL, 0x100fe200078ee20cULL,
0x000000100e2f7824ULL, 0x100fe200078e0249ULL, 0xfffffffc432e7812ULL, 0x000fe200078ee20cULL,
0x00000010143d7824ULL, 0x000fe200078e0249ULL, 0x0ffffffc0c0c7812ULL, 0x000fe200078ef805ULL,
0x000000800f0e7825ULL, 0x000fe200078e0002ULL, 0x00000000050d7211ULL, 0x000fc600078ff0ffULL,
0x000000100c4b7824ULL, 0x000fe200078e0249ULL, 0x000062000e0e7a10ULL, 0x000fe20007f5e0ffULL,
0x000000800d0c7825ULL, 0x000fc600078e0002ULL, 0x000063000f0f7a10ULL, 0x000fe200017fe4ffULL,
0x00000010163f7824ULL, 0x000fe200078e0249ULL, 0x000062000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008015147825ULL, 0x000fc600078e0002ULL, 0x000063000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000008017167825ULL, 0x000fe200078e0002ULL, 0x0000620014147a10ULL, 0x000fc60007f7e0ffULL,
0x0000000147477824ULL, 0x000fe200078e0200ULL, 0x0000620016167a10ULL, 0x000fe20007f9e0ffULL,
0x0000001018417824ULL, 0x100fe200078e0249ULL, 0x0000630015157a10ULL, 0x000fe20001ffe4ffULL,
0x000000101a437824ULL, 0x000fe200078e0249ULL, 0x0000630017177a10ULL, 0x000fe200027fe4ffULL,
0x0000008019187825ULL, 0x000fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c4b7faeULL, 0x0003e6000b901c48ULL, 0x000000102c457824ULL, 0x000fe200078e0249ULL,
0x0000620018187a10ULL, 0x000fe20007f3e0ffULL, 0x000000801b1a7825ULL, 0x100fe200078e0002ULL,
0x000000000e2f7faeULL, 0x0003e4000b901c48ULL, 0x0000630019197a10ULL, 0x000fe20000ffe4ffULL,
0x000000802d2c7825ULL, 0x100fe200078e0002ULL, 0x000062001a1a7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000143d7faeULL, 0x0003e4000b901c48ULL, 0x0000008047027825ULL, 0x000fe200078e0002ULL,
0x000062002c2c7a10ULL, 0x000fe20007f7e0ffULL, 0x00000000163f7faeULL, 0x0003e2000b901c48ULL,
0x000063001b1b7a10ULL, 0x000fe200017fe4ffULL, 0x000000102e497824ULL, 0x000fe200078e0249ULL,
0x0000620002027a10ULL, 0x000fe20007f9e0ffULL, 0x0000000018417faeULL, 0x0003e2000b901c48ULL,
0x000063002d2d7a10ULL, 0x000fc40001ffe4ffULL, 0x0000630003037a10ULL, 0x000fe200027fe4ffULL,
0x000000001a437faeULL, 0x0003e8000b901c48ULL, 0x000000002c457faeULL, 0x0003e8000b901c48ULL,
0x0000000002497faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff0c7224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff805007812ULL, 0x000fe200078ec0ffULL,
0x00000002042d7824ULL, 0x000fe200078e0209ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000010c187810ULL, 0x000fc40007ffe0ffULL, 0x0000000700007812ULL, 0x000fe400078ef805ULL,
0x000010002d2d7811ULL, 0x000fe400078e60ffULL, 0x00000001ff037819ULL, 0x020fe20000011600ULL,
0x00000004000d7824ULL, 0x040fe400078e00ffULL, 0x0000000400007824ULL, 0x000fe400078e00ffULL,
0x0000000103027824ULL, 0x040fe400078e020cULL, 0x0000000103037824ULL, 0x000fc600078e0218ULL,
0xfffffffc0d027812ULL, 0x000fe400078ee202ULL, 0xfffffffc00007812ULL, 0x000fc600078ee203ULL,
0x0000001002027824ULL, 0x100fe400078e022dULL, 0x0000001000007824ULL, 0x000fc600078e022dULL,
0x000000000244783bULL, 0x000e680000000200ULL, 0x000000000014783bULL, 0x0004e40000000200ULL,
0x0000002005007810ULL, 0x004fc80007ffe0ffULL, 0xfffffff800007812ULL, 0x000fc800078ec0ffULL,
0x0000000700197812ULL, 0x000fc800078ef805ULL, 0x00000001ff1b7819ULL, 0x000fe20000011619ULL,
0x0000000419037824ULL, 0x000fc800078e00ffULL, 0x000000011b007824ULL, 0x040fe400078e020cULL,
0x000000011b1b7824ULL, 0x000fc600078e0218ULL, 0xfffffffc03007812ULL, 0x000fca00078ee200ULL,
0x00000010003c7824ULL, 0x000fe200078e022dULL, 0x00000045000f7306ULL, 0x002fe20000009400ULL,
0x00000018ff4c7819ULL, 0x000fe20000011444ULL, 0x00010000442c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011445ULL, 0x0001000045537824ULL, 0x000fe200078e00ffULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0001000046747824ULL, 0x040fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000004500487306ULL, 0x000e620000005400ULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000010046757824ULL, 0x000fe200078e00ffULL,
0x0000002c00557245ULL, 0x000fc4000020d400ULL, 0x0000004a00767245ULL, 0x000fe4000020d400ULL,
0x00000018ff4e7819ULL, 0x000fe20000011446ULL, 0x00000046002e7306ULL, 0x000fe20000009400ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff6d7819ULL, 0x000fc60000011447ULL, 0x0000004600497306ULL, 0x000ea20000005400ULL,
0x000000480f00720bULL, 0x002fe40003f3d000ULL, 0x0000000705487812ULL, 0x000fc800078ec0ffULL,
0x0000000848487812ULL, 0x000fe200078ef805ULL, 0x0000004c00517306ULL, 0x000ff00000209400ULL,
0x0000004c00607306ULL, 0x0003220000205400ULL, 0x000000492e00720bULL, 0x004fce0003f5d000ULL,
0x00000044002f7306ULL, 0x000fe20000009400ULL, 0x0000004c004c7245ULL, 0x002fce000020d400ULL,
0x0000004400507306ULL, 0x000e620000005400ULL, 0x000000605100720bULL, 0x010fce0003fbd000ULL,
0x00000044000e7306ULL, 0x00052c000000d400ULL, 0x000000014c4c5812ULL, 0x000fe400078efcffULL,
0x0000004a00427306ULL, 0x000fe20000209400ULL, 0x0000010044447824ULL, 0x004fe200078e00ffULL,
0x000000502f00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff0f7819ULL, 0x000fe20000011444ULL,
0x000000040b447824ULL, 0x000fe200078e020cULL, 0x0000004a004f7306ULL, 0x000e620000205400ULL,
0x000000020c0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000244497824ULL, 0x000fe400078e00ffULL,
0x0000010045447824ULL, 0x000fe400078e00ffULL, 0x000000010e0e6812ULL, 0x010fe200078efcffULL,
0x0000002c001a7306ULL, 0x000fe20000209400ULL, 0x0000004905517211ULL, 0x000fc400078fe0ffULL,
0x00000018ff447819ULL, 0x000fc60000011444ULL, 0x0000000148517824ULL, 0x000fe400078e0251ULL,
0x0000002c002f7306ULL, 0x000ea20000205400ULL, 0x0000004f4200720bULL, 0x002fe20003f7d000ULL,
0x0000001048427824ULL, 0x000fca00078e00ffULL, 0xfffffff042517812ULL, 0x000fe200078ee251ULL,
0x0000000419427824ULL, 0x000fe200078e00ffULL, 0x0000000f002e7306ULL, 0x000fe60000209400ULL,
0x0000001051187824ULL, 0x000fe200078e00ffULL, 0xfffffffc42427812ULL, 0x000fe400078ee21bULL,
0x0000000176763812ULL, 0x000fe400078efcffULL, 0x0000002f1a00720bULL, 0x004fe20003f9d000ULL,
0x0000000f004f7306ULL, 0x0002a20000205400ULL, 0x000000001818783bULL, 0x000f220000000200ULL,
0x00000010422d7824ULL, 0x000fe200078e022dULL, 0x00000018ff517819ULL, 0x008fca0000011414ULL,
0x0000005300507306ULL, 0x000fe20000209400ULL, 0x0000000f000f7245ULL, 0x002fc6000020d400ULL,
0x0000000155554812ULL, 0x000fc800078efcffULL, 0x00000053002f7306ULL, 0x000e620000205400ULL,
0x0000004f2e00720bULL, 0x004fe40003f9d000ULL, 0x0000000e550e723eULL, 0x000fca00000010ffULL,
0x00000044004f7306ULL, 0x000fec0000209400ULL, 0x000000010f0f4812ULL, 0x000fe400078efcffULL,
0x0000004400607306ULL, 0x000ea20000205400ULL, 0x0000002f5000720bULL, 0x002fe40003fdd000ULL,
0x0000000f4c0f723eULL, 0x000fe200000010ffULL, 0x000000002d2c783bULL, 0x000e620000000200ULL,
0x00000018ff4c7819ULL, 0x000fc60000011415ULL, 0x0000004500527306ULL, 0x000ee4000000d400ULL,
0x0000000e1820723cULL, 0x010be20000041820ULL, 0x000000604f00720bULL, 0x004fca0003f9d000ULL,
0x0000004e00707306ULL, 0x000fe20000209400ULL, 0x00000053000f7245ULL, 0x020fe4000020d400ULL,
0x00000018ff4f7819ULL, 0x000fe40000011416ULL, 0x000000010f0f6812ULL, 0x000fe400078efcffULL,
0x0000000152521812ULL, 0x008fe200078efcffULL, 0x0000004e00727306ULL, 0x000ea60000205400ULL,
0x000000520f0e723eULL, 0x000fc400000010ffULL, 0x00000044000f7245ULL, 0x000fc6000020d400ULL,
0x00000046006b7306ULL, 0x000ee2000000d400ULL, 0x000000010f0f4812ULL, 0x000fc800078efcffULL,
0x0000000f760f723eULL, 0x000fc600000010ffULL, 0x0000007400447306ULL, 0x000fe20000209400ULL,
0x000000727000720bULL, 0x004fe20003fdd000ULL, 0x0001000047707824ULL, 0x000fe400078e00ffULL,
0x0000000e1834723cULL, 0x000be60000041834ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000007400467306ULL, 0x000ea20000205400ULL, 0x000000016b6b2812ULL, 0x008fce00078efcffULL,
0x0000007500767306ULL, 0x000ff00000209400ULL, 0x00000075000f7306ULL, 0x020ee20000205400ULL,
0x000000464400720bULL, 0x004fe40003f7d000ULL, 0x0000007400467245ULL, 0x000fc4000020d400ULL,
0x0000004e00747245ULL, 0x000fc6000020d400ULL, 0x0000001400547306ULL, 0x000fe20000009400ULL,
0x0000000174746812ULL, 0x000fca00078efcffULL, 0x0000000146463812ULL, 0x000fe400078efcffULL,
0x00000014006c7306ULL, 0x000ea20000005400ULL, 0x0000000f7600720bULL, 0x008fe40003fbd000ULL,
0x0000006b4646723eULL, 0x000fca00000010ffULL, 0x0000001500637306ULL, 0x000ff00000009400ULL,
0x0000001500647306ULL, 0x000ee20000005400ULL, 0x0000006c5400720bULL, 0x004fe20003f3d000ULL,
0x00000100476c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x00000070000f7306ULL, 0x000ff00000209400ULL, 0x0000007000727306ULL, 0x0005220000205400ULL,
0x000000646300720bULL, 0x008fce0003f7d000ULL, 0x00000047000d7306ULL, 0x000fe20000009400ULL,
0x0000007000707245ULL, 0x004fce000020d400ULL, 0x00000047004d7306ULL, 0x000ea20000005400ULL,
0x000000720f00720bULL, 0x010fce0003fdd000ULL, 0x00000047004b7306ULL, 0x00072c000000d400ULL,
0x0000000170706812ULL, 0x000fe400078efcffULL, 0x0000006d00657306ULL, 0x000fe20000209400ULL,
0x0000007500477245ULL, 0x008fe4000020d400ULL, 0x0000004d0d00720bULL, 0x004fc40003f9d000ULL,
0x0000000147475812ULL, 0x000fc600078efcffULL, 0x0000006d00667306ULL, 0x0004e20000205400ULL,
0x000000477447723eULL, 0x000fce00000010ffULL, 0x0000003c00677306ULL, 0x000fe20000009400ULL,
0x000000461830723cULL, 0x000b620000041830ULL, 0x000000014b4b4812ULL, 0x010fe400078efcffULL,
0x0000006d006d7245ULL, 0x004fc8000020d400ULL, 0x0000003c00687306ULL, 0x000ea20000005400ULL,
0x000100003c477824ULL, 0x060fe200078e00ffULL, 0x000000666500720bULL, 0x008fe20003f5d000ULL,
0x000001003c657824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe4000001143dULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000006c006b7306ULL, 0x000fe20000209400ULL,
0x00000018ff657819ULL, 0x000fcc0000011465ULL, 0x000000016d6d2812ULL, 0x000fe200078efcffULL,
0x0000006c00647306ULL, 0x0007220000205400ULL, 0x000000686700720bULL, 0x004fe40003fbd000ULL,
0x00000018ff677819ULL, 0x000fca000001143cULL, 0x0000003d00617306ULL, 0x000fe20000009400ULL,
0x0000006c006c7245ULL, 0x008fce000020d400ULL, 0x0000003d00627306ULL, 0x000ea20000005400ULL,
0x000000646b00720bULL, 0x010fe20003fdd000ULL, 0x000100003d647824ULL, 0x000fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000003c005f7306ULL, 0x000eec000000d400ULL,
0x000000016c6c6812ULL, 0x000fe400078efcffULL, 0x0000004700637306ULL, 0x000fe20000209400ULL,
0x000000626100720bULL, 0x004fc40003f9d000ULL, 0x0000004700627245ULL, 0x000fca000020d400ULL,
0x00000047003c7306ULL, 0x000ea20000205400ULL, 0x000000015f5f5812ULL, 0x008fce00078efcffULL,
0x0000006500687306ULL, 0x000ff00000209400ULL, 0x00000065006b7306ULL, 0x0007220000205400ULL,
0x0000003c6300720bULL, 0x004fe20003fdd000ULL, 0x000001003d637824ULL, 0x000fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000003e005d7306ULL, 0x000fe20000009400ULL,
0x0000006500657245ULL, 0x008fca000020d400ULL, 0x0000000162626812ULL, 0x000fe400078efcffULL,
0x0000003e005e7306ULL, 0x000ea20000005400ULL, 0x0000006b6800720bULL, 0x010fce0003f5d000ULL,
0x0000006700467306ULL, 0x000fec0000209400ULL, 0x0000000165652812ULL, 0x000fe400078efcffULL,
0x0000006700617306ULL, 0x0007220000205400ULL, 0x0000005e5d00720bULL, 0x004fe20003fdd000ULL,
0x000100003e5e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000006400727306ULL, 0x000fe20000209400ULL, 0x0000006700677245ULL, 0x008fce000020d400ULL,
0x0000006400477306ULL, 0x0004e20000205400ULL, 0x000000614600720bULL, 0x010fce0003fbd000ULL,
0x0000003d00437306ULL, 0x000f22000000d400ULL, 0x0000006400647245ULL, 0x004fca000020d400ULL,
0x0000000167675812ULL, 0x000fe400078efcffULL, 0x00000063003d7306ULL, 0x000fe20000209400ULL,
0x000000477200720bULL, 0x008fce0003f5d000ULL, 0x0000006300467306ULL, 0x0004e20000205400ULL,
0x0000000143434812ULL, 0x010fca00078efcffULL, 0x0000000164642812ULL, 0x000fe400078efcffULL,
0x00000066003c7306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x004fce000020d400ULL,
0x00000066005d7306ULL, 0x0005220000205400ULL, 0x000000463d00720bULL, 0x008fe20003f5d000ULL,
0x000001003e3d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000005e00477306ULL, 0x000fe20000209400ULL, 0x0000006600667245ULL, 0x004fca000020d400ULL,
0x0000000163632812ULL, 0x000fe400078efcffULL, 0x0000005e00727306ULL, 0x0004e20000205400ULL,
0x0000005d3c00720bULL, 0x010fe40003fbd000ULL, 0x00000018ff5d7819ULL, 0x000fca000001143eULL,
0x00000016005b7306ULL, 0x000fe20000009400ULL, 0x0000005e005e7245ULL, 0x004fca000020d400ULL,
0x0000000166665812ULL, 0x000fe400078efcffULL, 0x00000016005c7306ULL, 0x000ea20000005400ULL,
0x000000724700720bULL, 0x008fce0003f9d000ULL, 0x0000003e00417306ULL, 0x000eec000000d400ULL,
0x000000015e5e4812ULL, 0x000fe400078efcffULL, 0x0000003f00597306ULL, 0x000fe20000009400ULL,
0x0000005c5b00720bULL, 0x004fe20003f5d000ULL, 0x000100003f5b7824ULL, 0x000fe200078e00ffULL,
0x0000003d005c7245ULL, 0x000fc8000020d400ULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000003f005a7306ULL, 0x000ea20000005400ULL, 0x0000000141416812ULL, 0x008fce00078efcffULL,
0x0000003d003e7306ULL, 0x000ff00000209400ULL, 0x0000003d00477306ULL, 0x0007220000205400ULL,
0x0000005a5900720bULL, 0x004fe20003fbd000ULL, 0x000001003f5a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000005d003c7306ULL, 0x000fe20000209400ULL,
0x00010000143d7824ULL, 0x008fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005d00617306ULL, 0x0004e20000205400ULL, 0x000000473e00720bULL, 0x010fce0003f9d000ULL,
0x0000005b00467306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x004fca000020d400ULL,
0x000000015c5c4812ULL, 0x000fe400078efcffULL, 0x0000005b00477306ULL, 0x0005220000205400ULL,
0x000000613c00720bULL, 0x008fce0003fdd000ULL, 0x0000005a003e7306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x004fca000020d400ULL, 0x000000015d5d6812ULL, 0x000fe400078efcffULL,
0x0000005a00597306ULL, 0x0004e20000205400ULL, 0x000000474600720bULL, 0x010fe20003f9d000ULL,
0x0000010014467824ULL, 0x000fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000003f00427306ULL, 0x000862000000d400ULL, 0x0000005a005a7245ULL, 0x004fca000020d400ULL,
0x000000015b5b4812ULL, 0x000fe400078efcffULL, 0x000000593e00720bULL, 0x008fe20003fdd000ULL,
0x0000001400407306ULL, 0x000ea2000000d400ULL, 0x00000018ff3f7819ULL, 0x010fe4000001143fULL,
0x0000000142425812ULL, 0x002fca00078efcffULL, 0x0000003f003c7306ULL, 0x000fe20000209400ULL,
0x000000425b42723eULL, 0x000fc600000010ffULL, 0x000000015a5a6812ULL, 0x000fc800078efcffULL,
0x0000003f00477306ULL, 0x000e620000205400ULL, 0x0000000140401812ULL, 0x004fce00078efcffULL,
0x0000003d003e7306ULL, 0x000ff00000209400ULL, 0x0000003d00597306ULL, 0x000ea20000205400ULL,
0x000000473c00720bULL, 0x002fe40003fbd000ULL, 0x0000004c00477245ULL, 0x000fca000020d400ULL,
0x0000004600147306ULL, 0x000ff00000209400ULL, 0x0000004600617306ULL, 0x000e620000205400ULL,
0x000000593e00720bULL, 0x004fe20003fdd000ULL, 0x00010000153e7824ULL, 0x000fe200078e00ffULL,
0x0000003f00597245ULL, 0x000fc8000020d400ULL, 0x0000000159595812ULL, 0x000fe200078efcffULL,
0x0000001700587306ULL, 0x000fe20000009400ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000001700567306ULL, 0x000ea20000005400ULL, 0x000000611400720bULL, 0x002fe20003fbd000ULL,
0x0000010015147824ULL, 0x000fca00078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000005100457306ULL, 0x000ff00000209400ULL, 0x0000005100507306ULL, 0x0002e20000205400ULL,
0x000000565800720bULL, 0x004fc40003f9d000ULL, 0x0000003d00567245ULL, 0x000fe2000020d400ULL,
0x00010000163d7824ULL, 0x000fc600078e00ffULL, 0x0000000156566812ULL, 0x000fe200078efcffULL,
0x0000001500037306ULL, 0x000ea2000000d400ULL, 0x0000005100517245ULL, 0x002fe4000020d400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000000405640723eULL, 0x000fc600000010ffULL,
0x0000001400157306ULL, 0x000fe20000209400ULL, 0x000000504500720bULL, 0x008fe40003fdd000ULL,
0x0000004600507245ULL, 0x000fe4000020d400ULL, 0x0000003e00457245ULL, 0x000fe4000020d400ULL,
0x0000000150505812ULL, 0x000fe200078efcffULL, 0x0000001400727306ULL, 0x000e620000205400ULL,
0x0000000103033812ULL, 0x004fca00078efcffULL, 0x0000000151516812ULL, 0x000fe400078efcffULL,
0x0000002c004a7306ULL, 0x000ff00000009400ULL, 0x0000002c00577306ULL, 0x000ea20000005400ULL,
0x000000721500720bULL, 0x002fce0003fdd000ULL, 0x0000003e003f7306ULL, 0x000ff00000209400ULL,
0x0000003e00587306ULL, 0x0002e20000205400ULL, 0x000000574a00720bULL, 0x004fe40003f7d000ULL,
0x00000014004a7245ULL, 0x000fc4000020d400ULL, 0x0000004b7014723eULL, 0x000fe400000010ffULL,
0x000000014a4a6812ULL, 0x000fe200078efcffULL, 0x0000003d00467306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x002fce000001142eULL, 0x0000003d00157306ULL, 0x000e620000205400ULL,
0x000000583f00720bULL, 0x008fce0003fbd000ULL, 0x0000004f00537306ULL, 0x000fec0000209400ULL,
0x0000000145455812ULL, 0x000fe400078efcffULL, 0x0000004f00527306ULL, 0x0004e20000205400ULL,
0x000000154600720bULL, 0x002fe40003fdd000ULL, 0x0000006c6d15723eULL, 0x000fe200000010ffULL,
0x000100002c6d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe2000001142dULL,
0x00010000176c7824ULL, 0x000fc400078e00ffULL, 0x0000001600027306ULL, 0x000322000000d400ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x000000141810723cULL, 0x000b620000041810ULL,
0x0000004f004f7245ULL, 0x004fe4000020d400ULL, 0x00000018ff6c7819ULL, 0x000fc6000001146cULL,
0x0000006d00147306ULL, 0x020fe20000209400ULL, 0x0000010016167824ULL, 0x002fe200078e00ffULL,
0x000000525300720bULL, 0x008fe40003fbd000ULL, 0x00000018ff527819ULL, 0x000fe4000001142cULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000006d00157306ULL, 0x000e620000205400ULL,
0x0000000102022812ULL, 0x010fcc00078efcffULL, 0x000000014f4f5812ULL, 0x000fe200078efcffULL,
0x00000016003f7306ULL, 0x000ff00000209400ULL, 0x0000001600727306ULL, 0x000fe20000205400ULL,
0x000000151400720bULL, 0x002fc40003fbd000ULL, 0x0000005f6214723eULL, 0x000fe200000010ffULL,
0x000100002d627824ULL, 0x000fe200078e00ffULL, 0x000000656715723eULL, 0x000fe200000010ffULL,
0x000001002d5f7824ULL, 0x000fe400078e00ffULL, 0x0000002e00447306ULL, 0x000fe20000009400ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x000000141838723cULL, 0x000b680000041838ULL, 0x0000002e004e7306ULL, 0x000e660000005400ULL,
0x0000000249147810ULL, 0x020fc40007ffe0ffULL, 0x0000005c5d49723eULL, 0x000fe200000010ffULL,
0x000001002f5d7824ULL, 0x000fe200078e00ffULL, 0x0000001405157211ULL, 0x000fe200078fe0ffULL,
0x0000004c00557306ULL, 0x000fe20000209400ULL, 0x000000436414723eULL, 0x000fe200000010ffULL,
0x000100002e437824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000000148157824ULL, 0x040fe400078e0215ULL, 0x0000001048487824ULL, 0x000fe400078e00ffULL,
0x0000004c00607306ULL, 0x0004e20000205400ULL, 0x0000004e4400720bULL, 0x002fe20003f5d000ULL,
0x0000010017447824ULL, 0x000fe200078e00ffULL, 0x00000016004e7245ULL, 0x000fe2000020d400ULL,
0x000001002c167824ULL, 0x000fc600078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011444ULL,
0x0000002f00687306ULL, 0x000fe20000009400ULL, 0x0000003d004c7245ULL, 0x004fe4000020d400ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x000000723f00720bULL, 0x000fe20003fdd000ULL, 0x0000002f006b7306ULL, 0x000e620000005400ULL,
0x000000605500720bULL, 0x008fc40003f3d000ULL, 0x00000018ff557819ULL, 0x000fe40000011417ULL,
0x0000006d00447245ULL, 0x000fe4000020d400ULL, 0x00000018ff3d7819ULL, 0x000fe2000001142fULL,
0x0000001700007306ULL, 0x000ea2000000d400ULL, 0x0000000144445812ULL, 0x000fe400078efcffULL,
0x000000024c02723eULL, 0x000fe400000010ffULL, 0x000000014e4e6812ULL, 0x000fc400078efcffULL,
0x0000000147471812ULL, 0x000fe200078efcffULL, 0x0000002c000d7306ULL, 0x000ee2000000d400ULL,
0x0000006b6800720bULL, 0x002fce0003fdd000ULL, 0x0000006c00727306ULL, 0x000fe20000209400ULL,
0x0000000100004812ULL, 0x004fce00078efcffULL, 0x0000006c00177306ULL, 0x0002a20000205400ULL,
0x000000010d0d3812ULL, 0x008fc800078efcffULL, 0x0000000d4444723eULL, 0x000fe400000010ffULL,
0x0000003e000d7245ULL, 0x000fe2000020d400ULL, 0x00000016006b7306ULL, 0x000fe20000209400ULL,
0x0000006c006c7245ULL, 0x002fce000020d400ULL, 0x0000001600707306ULL, 0x000e620000205400ULL,
0x000000177200720bULL, 0x004fce0003f7d000ULL, 0x0000002d004d7306ULL, 0x000fec0000009400ULL,
0x000000016c6c3812ULL, 0x000fe400078efcffULL, 0x0000002d00547306ULL, 0x000ea20000005400ULL,
0x000000706b00720bULL, 0x002fce0003fbd000ULL, 0x0000002d000e7306ULL, 0x0003f0000000d400ULL,
0x0000005500617306ULL, 0x000fe20000209400ULL, 0xfffffff0482d7812ULL, 0x002fe400078ee215ULL,
0x000000636615723eULL, 0x000fc400000010ffULL, 0x0000001600637245ULL, 0x000fe2000020d400ULL,
0x000000102d177824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe20000011443ULL,
0x0000005500607306ULL, 0x000e620000205400ULL, 0x0000000163635812ULL, 0x000fe200078efcffULL,
0x000000141828723cULL, 0x040b620000041828ULL, 0x000000415e48723eULL, 0x000fe200000010ffULL,
0x000000001714783bULL, 0x020ee20000000200ULL, 0x0000005a5943723eULL, 0x000fe200000010ffULL,
0x000100002f417824ULL, 0x000fe200078e00ffULL, 0x000000544d00720bULL, 0x004fe20003f3d000ULL,
0x0000006500687306ULL, 0x000fe40000209400ULL, 0x000000481824723cULL, 0x040f6c0000041824ULL,
0x0000006500707306ULL, 0x0005220000205400ULL, 0x000000606100720bULL, 0x002fe20003f7d000ULL,
0x00000042181c723cULL, 0x000b64000004181cULL, 0x000000010e0e1812ULL, 0x000fc800078efcffULL,
0x0000005200577306ULL, 0x000fe20000209400ULL, 0x0000006500657245ULL, 0x004fe4000020d400ULL,
0x000000006c18723eULL, 0x020fe400000010ffULL, 0x0000002d00007245ULL, 0x000fe4000020d400ULL,
0x00000003451a723eULL, 0x000fe200000010ffULL, 0x0000005200587306ULL, 0x0002a20000205400ULL,
0x000000706800720bULL, 0x010fe40003fbd000ULL, 0x0000004e4f03723eULL, 0x000fc400000010ffULL,
0x0000004a471b723eULL, 0x000fc600000010ffULL, 0x0000002d00677306ULL, 0x000fe20000209400ULL,
0x0000005200527245ULL, 0x002fe2000020d400ULL, 0x000000021430723cULL, 0x048b680000041830ULL,
0x0000000165655812ULL, 0x000fe400078efcffULL, 0x000000585700720bULL, 0x004fe20003f9d000ULL,
0x0000002d00687306ULL, 0x000e620000205400ULL, 0x0000005500587245ULL, 0x000fe2000020d400ULL,
0x0000001a1434723cULL, 0x000f660000041834ULL, 0x0000000158583812ULL, 0x000fc600078efcffULL,
0x0000004600537306ULL, 0x000fe20000209400ULL, 0x000000655819723eULL, 0x000fc600000010ffULL,
0x0000000152524812ULL, 0x000fc800078efcffULL, 0x0000004600547306ULL, 0x0004e20000205400ULL,
0x000000181410723cULL, 0x000f620000041810ULL, 0x000000686700720bULL, 0x002fe40003f3d000ULL,
0x000000635245723eULL, 0x000fc800000010ffULL, 0x00000062006b7306ULL, 0x000fe20000209400ULL,
0x0000004600467245ULL, 0x004fe4000020d400ULL, 0x000000441438723cULL, 0x000f680000041838ULL,
0x0000000100001812ULL, 0x000fe200078efcffULL, 0x00000062006d7306ULL, 0x000e620000205400ULL,
0x000000545300720bULL, 0x008fce0003f7d000ULL, 0x0000005f00647306ULL, 0x000fec0000209400ULL,
0x0000000146463812ULL, 0x000fe400078efcffULL, 0x0000005f00667306ULL, 0x0004e20000205400ULL,
0x0000006d6b00720bULL, 0x002fce0003fbd000ULL, 0x0000002e000f7306ULL, 0x000322000000d400ULL,
0x0000005f005f7245ULL, 0x004fce000020d400ULL, 0x0000002f003c7306ULL, 0x000522000000d400ULL,
0x000001002e2e7824ULL, 0x002fe200078e00ffULL, 0x000000666400720bULL, 0x008fc80003f9d000ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000003e004b7306ULL, 0x000fe20000209400ULL,
0x00000018ff2f7819ULL, 0x004fe40000011441ULL, 0x000000505141723eULL, 0x000fe400000010ffULL,
0x000000010f0f2812ULL, 0x010fe400078efcffULL, 0x000000015f5f4812ULL, 0x000fe200078efcffULL,
0x0000002f00487306ULL, 0x000fe20000209400ULL, 0x000000013c3c6812ULL, 0x000fe200078efcffULL,
0x000000401420723cULL, 0x000b640000041820ULL, 0x0000005f4603723eULL, 0x020fc800000010ffULL,
0x0000002f00437306ULL, 0x0002a20000205400ULL, 0x0000006200417245ULL, 0x000fc8000020d400ULL,
0x0000000141415812ULL, 0x000fc600078efcffULL, 0x0000003e004d7306ULL, 0x000ee20000205400ULL,
0x0000000e4102723eULL, 0x000fe400000010ffULL, 0x0000000f000e723eULL, 0x000fe400000010ffULL,
0x0000002f002f7245ULL, 0x002fe4000020d400ULL, 0x0000003d00007245ULL, 0x000fe2000020d400ULL,
0x0000003d003f7306ULL, 0x000fe20000209400ULL, 0x000000434800720bULL, 0x004fe20003f3d000ULL,
0x000000021428723cULL, 0x000b6c0000041828ULL, 0x0000003d002c7306ULL, 0x0002a20000205400ULL,
0x0000004d4b00720bULL, 0x008fca0003fbd000ULL, 0x000000012f2f1812ULL, 0x000fe400078efcffULL,
0x0000002e005c7306ULL, 0x000fe20000209400ULL, 0x0000005d003d7245ULL, 0x002fe4000020d400ULL,
0x000000040c00780cULL, 0x000fe40003f25270ULL, 0x0000003c2f3c723eULL, 0x000fe400000010ffULL,
0x000000010d0d5812ULL, 0x000fe200078efcffULL, 0x0000002e00597306ULL, 0x0002e20000205400ULL,
0x0000002c3f00720bULL, 0x004fce0003f9d000ULL, 0x0000005d00407306ULL, 0x000fe20000209400ULL,
0x0000002e002e7245ULL, 0x002fca000020d400ULL, 0x0000000100004812ULL, 0x000fe400078efcffULL,
0x0000005d00197306ULL, 0x000e620000205400ULL, 0x000000595c00720bULL, 0x008fda0003f7d000ULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x000000194000720bULL, 0x002fe40003f5d000ULL,
0x0000002e0d0f723eULL, 0x000fce00000010ffULL, 0x0000000e1424723cULL, 0x000b680000041824ULL,
0x000000013d3d2812ULL, 0x000fc800078efcffULL, 0x0000003d003d723eULL, 0x000fce00000010ffULL,
0x0000003c141c723cULL, 0x000b62000004181cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe0c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff097224ULL, 0x000fe200078e0008ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd47000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000000630307220ULL, 0x080fe20000410000ULL, 0x0000000631317220ULL, 0x080fe20000410000ULL,
0x0000000620207220ULL, 0x080fe20000410000ULL, 0x0000000621217220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000610107220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x0000000628007220ULL, 0x0a0fe20000410000ULL, 0x0000000629027220ULL, 0x080fe20000410000ULL,
0x0000000627187220ULL, 0x080fe20000410000ULL, 0x0000000633097220ULL, 0x080fe20000410000ULL,
0x000000062a157220ULL, 0x080fe20000410000ULL, 0x000000062b0a7220ULL, 0x080fe20000410000ULL,
0x00000006242f7220ULL, 0x080fe20000410000ULL, 0x00000006252d7220ULL, 0x080fe20000410000ULL,
0x0000000626177220ULL, 0x080fe20000410000ULL, 0x000000061d167220ULL, 0x080fe20000410000ULL,
0x000000ffff277224ULL, 0x000fe200078e0030ULL, 0x0000000622227220ULL, 0x080fe20000410000ULL,
0x000000ffff287224ULL, 0x000fe200078e0031ULL, 0x0000000623237220ULL, 0x080fe20000410000ULL,
0x00000006352e7220ULL, 0x080fe20000410000ULL, 0x0000000636367220ULL, 0x080fe20000410000ULL,
0x00000006372c7220ULL, 0x080fe20000410000ULL, 0x0000000632327220ULL, 0x080fe20000410000ULL,
0x0000000611337220ULL, 0x080fe20000410000ULL, 0x0000000612127220ULL, 0x080fe20000410000ULL,
0x0000000613137220ULL, 0x080fe20000410000ULL, 0x000000063a147220ULL, 0x080fe20000410000ULL,
0x000000063b3b7220ULL, 0x080fe20000410000ULL, 0x000000061c247220ULL, 0x080fe20000410000ULL,
0x000000061e197220ULL, 0x080fe20000410000ULL, 0x000000061f1a7220ULL, 0x000fe20000410000ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0020ULL, 0x000000ffff257224ULL, 0x000fe400078e0021ULL,
0x000000ffff267224ULL, 0x000fe400078e0034ULL, 0x000000ffff297224ULL, 0x000fe400078e0010ULL,
0x000000ffff317224ULL, 0x000fe400078e0038ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0039ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0000ULL, 0x000000ffff307224ULL, 0x000fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000079027f8cULL, 0x0002a2000c80043fULL,
0x000000ffff207224ULL, 0x000fe400078e0022ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0023ULL,
0x000000ffff227224ULL, 0x000fe400078e0032ULL, 0x000000ffff217224ULL, 0x000fe400078e0009ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0036ULL, 0x000000ffff237224ULL, 0x000fe400078e0012ULL,
0x000000ffff327224ULL, 0x000fe400078e0013ULL, 0x000000ffff097224ULL, 0x000fe400078e003bULL,
0x000000ffff1c7224ULL, 0x000fc400078e000aULL, 0x00000000000a7805ULL, 0x002fca0000015200ULL,
0x00000400790d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x006fe40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140dULL,
0x0000000f00007211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x0000000200007819ULL, 0x000fc8000000120dULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400790d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004051b7824ULL, 0x000fe200078e00ffULL, 0x000000770700720cULL, 0x000fc80003f06070ULL,
0xfffffff01b037812ULL, 0x000fca00078ec0ffULL, 0x0000008004007824ULL, 0x000fca00078e0203ULL,
0x00f40000000c7984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0x0000010007367824ULL, 0x000fe200078e027aULL, 0x0000007305027211ULL, 0x040fe200078ff0ffULL,
0x0000000205347824ULL, 0x000fe400078e00ffULL, 0x00000002ff487424ULL, 0x000fe200078e00ffULL,
0x0000003669037217ULL, 0x000fe40007800000ULL, 0x0000000634347812ULL, 0x000fe400078ec0ffULL,
0x00000008020a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103367824ULL, 0x000fe200078e0a36ULL,
0x00005a00ff037a19ULL, 0x000fe20000011602ULL, 0x000000016f0b7824ULL, 0x000fe200078e0234ULL,
0x0000580034357a10ULL, 0x000fc40007ffe0ffULL, 0x0000000378027217ULL, 0x000fe40003800000ULL,
0x000000360b00720cULL, 0x040fe20003f26070ULL, 0x000000010b0b7824ULL, 0x100fe200078e0a36ULL,
0x0000001034397812ULL, 0x000fe200078efcffULL, 0x0000000135037824ULL, 0x000fe200078e0a36ULL,
0x00005a00ff117a19ULL, 0x000fe2000001160aULL, 0x0000000271517224ULL, 0x000fe200078e02ffULL,
0x0000000b780b7217ULL, 0x000fe40003800000ULL, 0x000000363500720cULL, 0x000fc40003f06070ULL,
0x0000000378037217ULL, 0x040fe40003800000ULL, 0x00000004ff0b7819ULL, 0x000fe4000001160bULL,
0x00005800393b7a10ULL, 0x000fe40007ffe0ffULL, 0x00000011780a7217ULL, 0x000fe40003800000ULL,
0x000000ff033a7207ULL, 0x000fe40000000000ULL, 0x000000ff0b027207ULL, 0x000fe20000800000ULL,
0x000000016f417824ULL, 0x000fe200078e0239ULL, 0x000000513a137211ULL, 0x000fe200078fe0ffULL,
0x000000013b3f7824ULL, 0x000fc400078e0a36ULL, 0x0000000a714f7224ULL, 0x000fe400078e02ffULL,
0x0000000151117824ULL, 0x000fe200078e0202ULL, 0x0000003f783e7217ULL, 0x000fe20003800000ULL,
0x0000000141437824ULL, 0x000fe200078e0a36ULL, 0x0000004f3a0b7211ULL, 0x000fe200078fe0ffULL,
0x0000600013127625ULL, 0x000fe200078e0048ULL, 0x00000020343f7812ULL, 0x000fc600078efcffULL,
0x0000600011107625ULL, 0x000fe200078e0048ULL, 0x0000004378437217ULL, 0x000fe20003800000ULL,
0x0000000812387981ULL, 0x000722000c1e9500ULL, 0x000000363b00720cULL, 0x080fe40003f06070ULL,
0x000000364100720cULL, 0x000fe20003f26070ULL, 0x0000000810377981ULL, 0x000322000c1e9500ULL,
0x000058003f417a10ULL, 0x000fe20007ffe0ffULL, 0x000060000b0a7625ULL, 0x000fe200078e0048ULL,
0x00000004ff437819ULL, 0x000fe40000011643ULL, 0x000000ff3e3e7207ULL, 0x000fe20000000000ULL,
0x0000000102037824ULL, 0x000fe200078e024fULL, 0x000000080a3c7981ULL, 0x000522000c1e9500ULL,
0x0000000141477824ULL, 0x000fc400078e0a36ULL, 0x0000600003027625ULL, 0x000fe200078e0048ULL,
0x000000ff43107207ULL, 0x002fe40000800000ULL, 0x000000364100720cULL, 0x000fe20003f06070ULL,
0x000000016f497824ULL, 0x000fe200078e023fULL, 0x000000513e0b7211ULL, 0x004fe200078fe0ffULL,
0x00000008023d7981ULL, 0x0002a2000c1e9500ULL, 0x0000004778477217ULL, 0x000fe20003800000ULL,
0x0000000151117824ULL, 0x000fe400078e0210ULL, 0x00000001494b7824ULL, 0x000fe200078e0a36ULL,
0x000000ff474a7207ULL, 0x000fe20000000000ULL, 0x000060000b027625ULL, 0x002fe200078e0048ULL,
0x0000003034477812ULL, 0x000fc600078efcffULL, 0x00006000110a7625ULL, 0x000fe200078e0048ULL,
0x0000004f3e117211ULL, 0x000fe200078fe0ffULL, 0x0000000802407981ULL, 0x0002a2000c1e9500ULL,
0x0000004b784b7217ULL, 0x000fe20003800000ULL, 0x0000000110137824ULL, 0x008fe200078e024fULL,
0x000000364900720cULL, 0x000fe20003f26070ULL, 0x000000016f537824ULL, 0x000fe200078e0247ULL,
0x00000004ff4b7819ULL, 0x000fe2000001164bULL, 0x0000600011107625ULL, 0x000fe200078e0048ULL,
0x000000080a437981ULL, 0x0006a2000c1e9500ULL, 0x000000514a037211ULL, 0x002fc400078fe0ffULL,
0x0000600013127625ULL, 0x080fe200078e0048ULL, 0x0000580047497a10ULL, 0x000fe20007ffe0ffULL,
0x0000000810427981ULL, 0x0002a4000c1e9500ULL, 0x0000600003027625ULL, 0x000fe200078e0048ULL,
0x000000ff4b467207ULL, 0x000fe20000800000ULL, 0x0000000812457981ULL, 0x0002a4000c1e9500ULL,
0x0000000153557824ULL, 0x000fe400078e0a36ULL, 0x0000000802447981ULL, 0x0002a2000c1e9500ULL,
0x00000001510b7824ULL, 0x008fe200078e0246ULL, 0x0000004f4a117211ULL, 0x002fc400078fe0ffULL,
0x0000005578557217ULL, 0x000fe20003800000ULL, 0x0000000146137824ULL, 0x000fe400078e024fULL,
0x0000000149037824ULL, 0x040fe200078e0a36ULL, 0x000000364900720cULL, 0x000fe20003f06070ULL,
0x000060000b0a7625ULL, 0x000fe200078e0048ULL, 0x000000365300720cULL, 0x000fe40003f26070ULL,
0x0000000378037217ULL, 0x000fe20003800000ULL, 0x0000600011107625ULL, 0x080fe200078e0048ULL,
0x00000004ff557819ULL, 0x000fe20000011655ULL, 0x000000080a4b7981ULL, 0x0002e4000c1e9500ULL,
0x0000600013127625ULL, 0x000fe200078e0048ULL, 0x000000ff034c7207ULL, 0x000fe20000000000ULL,
0x0000000810467981ULL, 0x0002e2000c1e9500ULL, 0x000000ff554e7207ULL, 0x000fc60000800000ULL,
0x00000008124d7981ULL, 0x0002e2000c1e9500ULL, 0x000000514c037211ULL, 0x000fe200078fe0ffULL,
0x00000001510b7824ULL, 0x002fc800078e024eULL, 0x0000600003027625ULL, 0x000fc800078e0048ULL,
0x000060000b0a7625ULL, 0x000fe400078e0048ULL, 0x0000000802027981ULL, 0x0002e2000c1e9500ULL,
0x0000004f4c117211ULL, 0x000fc600078fe0ffULL, 0x000000080a0b7981ULL, 0x0002e2000c1e9500ULL,
0x000000014e137824ULL, 0x000fe400078e024fULL, 0x0000600011107625ULL, 0x000fc800078e0048ULL,
0x0000600013127625ULL, 0x000fe400078e0048ULL, 0x0000000810107981ULL, 0x0002e8000c1e9500ULL,
0x00000008124f7981ULL, 0x0002e2000c1e9500ULL, 0xfffffff03a3a7812ULL, 0x000fe400078ec0ffULL,
0x0000000134677812ULL, 0x040fe400078efcffULL, 0x0000000834657812ULL, 0x000fe200078efcffULL,
0x00000001363a7824ULL, 0x000fe200078e023aULL, 0x0000000934637812ULL, 0x000fe200078efcffULL,
0x00000001ff487424ULL, 0x000fe200078e00ffULL, 0x0000580067757a10ULL, 0x000fc40007ffe0ffULL,
0x00005800656d7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800636b7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff03e507812ULL, 0x000fe200078ec0ffULL, 0x00000001353e7824ULL, 0x100fe200078e0a3aULL,
0xfffffff04a527812ULL, 0x000fe200078ec0ffULL, 0x00000001754a7824ULL, 0x100fe200078e0a3aULL,
0xfffffff04c5e7812ULL, 0x000fe200078ec0ffULL, 0x000000016d4c7824ULL, 0x100fe400078e0a3aULL,
0x000000016b4e7824ULL, 0x000fe200078e0a3aULL, 0x0000003e483a7219ULL, 0x000fc400000006ffULL,
0x0000001834597812ULL, 0x000fe400078efcffULL, 0x0000004c483e7219ULL, 0x040fe400000006ffULL,
0x0000004e484c7219ULL, 0x000fe200000006ffULL, 0x0000000136507824ULL, 0x000fe200078e0250ULL,
0x00005800595f7a10ULL, 0x000fc60007ffe0ffULL, 0x000000013b5a7824ULL, 0x100fe400078e0a50ULL,
0x000000015f5c7824ULL, 0x000fe200078e0a50ULL, 0x00000011345b7812ULL, 0x040fe400078efcffULL,
0x0000001934577812ULL, 0x000fe400078efcffULL, 0x0000004a484a7219ULL, 0x040fe400000006ffULL,
0x0000005a485a7219ULL, 0x040fe400000006ffULL, 0x0000005c485c7219ULL, 0x000fe200000006ffULL,
0x0000000136527824ULL, 0x000fe200078e0252ULL, 0x000058005b617a10ULL, 0x000fc40007ffe0ffULL,
0x00005800575d7a10ULL, 0x000fe20007ffe0ffULL, 0x0000000141627824ULL, 0x000fe400078e0a52ULL,
0x0000000161587824ULL, 0x100fe400078e0a50ULL, 0x000000015d607824ULL, 0x000fe200078e0a50ULL,
0x0000002134557812ULL, 0x040fe400078efcffULL, 0x0000002834537812ULL, 0x040fe400078efcffULL,
0x0000002934517812ULL, 0x000fc400078efcffULL, 0x0000005848587219ULL, 0x040fe400000006ffULL,
0x0000006048607219ULL, 0x040fe400000006ffULL, 0x0000006248627219ULL, 0x000fe200000006ffULL,
0x00000001365e7824ULL, 0x000fe200078e025eULL, 0x0000580055127a10ULL, 0x002fe40007ffe0ffULL,
0x00005800530a7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800517d7a10ULL, 0x000fe20007ffe0ffULL,
0x0000000112647824ULL, 0x000fc400078e0a52ULL, 0x000000010a667824ULL, 0x100fe400078e0a52ULL,
0x000000017d687824ULL, 0x000fe400078e0a52ULL, 0x00000001496c7824ULL, 0x000fe200078e0a5eULL,
0x0000003134137812ULL, 0x040fe400078efcffULL, 0x0000003834117812ULL, 0x040fe400078efcffULL,
0x0000003934037812ULL, 0x000fe400078efcffULL, 0x0000006448647219ULL, 0x000fc400000006ffULL,
0x0000006648667219ULL, 0x040fe400000006ffULL, 0x0000006848687219ULL, 0x040fe400000006ffULL,
0x0000006c486c7219ULL, 0x000fe400000006ffULL, 0x00005800134e7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580011507a10ULL, 0x000fe40007ffe0ffULL, 0x0000580003527a10ULL, 0x000fe20007ffe0ffULL,
0x000000014e547824ULL, 0x000fc400078e0a5eULL, 0x0000000150567824ULL, 0x100fe400078e0a5eULL,
0x00000001525e7824ULL, 0x000fe200078e0a5eULL, 0x0000005448547219ULL, 0x040fe400000006ffULL,
0x0000005648567219ULL, 0x040fe400000006ffULL, 0x0000005e485e7219ULL, 0x000fe400000006ffULL,
0x0000541038377816ULL, 0x010fc80000000037ULL, 0x000000373aff7212ULL, 0x000fc8000780c0ffULL,
0x000000363500720cULL, 0x000fc80000701470ULL, 0x000000363400720cULL, 0x000fe40000701070ULL,
0x000054103c3d7816ULL, 0x004fe4000000003dULL, 0xff8000001d1d7808ULL, 0x000fe40000000000ULL,
0x0000003d3aff7212ULL, 0x080fe4000788c0ffULL, 0x0000003d3eff7212ULL, 0x080fe400078cc0ffULL,
0x0000003d4cff7212ULL, 0x000fc4000780c0ffULL, 0x000000363500720cULL, 0x080fe40002781470ULL,
0x000000366d00720cULL, 0x080fe400037c1470ULL, 0x000000366b00720cULL, 0x080fe40000701470ULL,
0x000000374cff7212ULL, 0x000fe4000782c0ffULL, 0x000000363400720cULL, 0x080fe40002781070ULL,
0x000000366500720cULL, 0x000fc400037c1070ULL, 0x000000366300720cULL, 0x080fe40000701070ULL,
0x0000541040437816ULL, 0x000fe40000000043ULL, 0x000000366b00720cULL, 0x000fe40000f21470ULL,
0xff80000020207808ULL, 0x000fe40002000000ULL, 0xff8000001f1f7808ULL, 0x000fe40003000000ULL,
0x0000541042457816ULL, 0x000fc40000000045ULL, 0xff8000002c2c7808ULL, 0x000fe40000000000ULL,
0x000000374aff7212ULL, 0x080fe4000786c0ffULL, 0x000000373eff7212ULL, 0x000fe4000784c0ffULL,
0x0000003d4aff7212ULL, 0x000fe400078ac0ffULL, 0x000000435aff7212ULL, 0x040fe4000788c0ffULL,
0x000000455aff7212ULL, 0x000fc400078cc0ffULL, 0x000000455cff7212ULL, 0x000fe4000780c0ffULL,
0x000000366300720cULL, 0x080fe40000f21070ULL, 0x000000367500720cULL, 0x0c0fe40001f61470ULL,
0x000000367500720cULL, 0x080fe40002fa1470ULL, 0x000000366d00720cULL, 0x080fe40001741470ULL,
0x000000363b00720cULL, 0x000fc40002781470ULL, 0x000000363b00720cULL, 0x080fe400037c1470ULL,
0x000000365f00720cULL, 0x080fe40000701470ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0x000000366700720cULL, 0x0c0fe40001f61070ULL, 0x000000366700720cULL, 0x080fe40002fa1070ULL,
0x000000366500720cULL, 0x000fc40001741070ULL, 0x000000363900720cULL, 0x0c0fe40002721070ULL,
0x000000363900720cULL, 0x080fe400037c1070ULL, 0x000000365900720cULL, 0x000fe40000701070ULL,
0x00005410444b7816ULL, 0x008fe4000000004bULL, 0x00005410464d7816ULL, 0x000fe4000000004dULL,
0xff80000025257808ULL, 0x000fc40001800000ULL, 0xff8000001e1e7808ULL, 0x000fe40002800000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40000800000ULL,
0xff80000022227808ULL, 0x000fe40003000000ULL, 0xff80000023237808ULL, 0x000fe40000000000ULL,
0x0000004358ff7212ULL, 0x000fc4000786c0ffULL, 0x000000435cff7212ULL, 0x080fe400078ac0ffULL,
0x0000004360ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004558ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004560ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004b62ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004d62ff7212ULL, 0x000fc4000780c0ffULL, 0x000000366100720cULL, 0x0c0fe40001f61470ULL,
0x000000366100720cULL, 0x080fe40002781470ULL, 0x000000365f00720cULL, 0x080fe40002fa1470ULL,
0x000000365d00720cULL, 0x0c0fe40001741470ULL, 0x000000365d00720cULL, 0x080fe40000f21470ULL,
0x000000364100720cULL, 0x000fc400037c1470ULL, 0x000000364100720cULL, 0x080fe40000701470ULL,
0x000000365b00720cULL, 0x0c0fe40001f61070ULL, 0x000000365b00720cULL, 0x080fe40002781070ULL,
0x000000365900720cULL, 0x080fe40002fa1070ULL, 0x000000365700720cULL, 0x0c0fe40001741070ULL,
0x000000365700720cULL, 0x000fc40000f21070ULL, 0x000000363f00720cULL, 0x0c0fe400037c1070ULL,
0x000000363f00720cULL, 0x000fe40000701070ULL, 0x00005410020b7816ULL, 0x000fe4000000000bULL,
0xff80000028287808ULL, 0x000fe40001800000ULL, 0xff80000021217808ULL, 0x000fe40002000000ULL,
0xff80000029297808ULL, 0x000fc40002800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000031317808ULL, 0x000fe40003000000ULL,
0xff80000014147808ULL, 0x000fe40000000000ULL, 0x0000004b64ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004b66ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004b68ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004d64ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004d66ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004d68ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000b6cff7212ULL, 0x000fe4000780c0ffULL,
0x000000361200720cULL, 0x000fc40001f61470ULL, 0x000000361200720cULL, 0x080fe40001741470ULL,
0x000000360a00720cULL, 0x0c0fe40002781470ULL, 0x000000360a00720cULL, 0x080fe40000f21470ULL,
0x000000367d00720cULL, 0x0c0fe40002fa1470ULL, 0x000000367d00720cULL, 0x080fe400037c1470ULL,
0x000000364900720cULL, 0x000fc40000701470ULL, 0x000000365500720cULL, 0x0c0fe40001f61070ULL,
0x000000365500720cULL, 0x080fe40001741070ULL, 0x000000365300720cULL, 0x0c0fe40002781070ULL,
0x000000365300720cULL, 0x080fe40000f21070ULL, 0x000000365100720cULL, 0x0c0fe40002fa1070ULL,
0x000000365100720cULL, 0x000fc400037c1070ULL, 0x000000364700720cULL, 0x000fe40000701070ULL,
0x00005410104f7816ULL, 0x000fe4000000004fULL, 0xff8000002a2a7808ULL, 0x000fe40001800000ULL,
0xff80000009097808ULL, 0x000fe40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff80000015157808ULL, 0x000fc40000800000ULL, 0xff80000030307808ULL, 0x000fe40002800000ULL,
0xff8000001c1c7808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0x0000000b54ff7212ULL, 0x080fe4000786c0ffULL, 0x0000000b56ff7212ULL, 0x080fe4000784c0ffULL,
0x0000000b5eff7212ULL, 0x000fc4000788c0ffULL, 0x0000004f6cff7212ULL, 0x080fe4000782c0ffULL,
0x0000004f54ff7212ULL, 0x080fe400078ac0ffULL, 0x0000004f56ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004f5eff7212ULL, 0x000fe4000780c0ffULL, 0x000000364900720cULL, 0x080fe40000f21470ULL,
0x000000364e00720cULL, 0x000fc40001f61470ULL, 0x000000364e00720cULL, 0x080fe40002fa1470ULL,
0x000000365000720cULL, 0x0c0fe40001741470ULL, 0x000000365000720cULL, 0x080fe400037c1470ULL,
0x000000365200720cULL, 0x0c0fe40002781470ULL, 0x000000365200720cULL, 0x080fe40000701470ULL,
0x000000364700720cULL, 0x000fc40000f21070ULL, 0x000000361300720cULL, 0x0c0fe40001f61070ULL,
0x000000361300720cULL, 0x080fe40002fa1070ULL, 0x000000361100720cULL, 0x0c0fe40001741070ULL,
0x000000361100720cULL, 0x080fe400037c1070ULL, 0x000000360300720cULL, 0x0c0fe40002781070ULL,
0x000000360300720cULL, 0x000fc40000701070ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff80000016167808ULL, 0x000fe40002000000ULL,
0xff80000017177808ULL, 0x000fe40000800000ULL, 0xff80000018187808ULL, 0x000fe40002800000ULL,
0xff80000019197808ULL, 0x000fc40003000000ULL, 0xff8000001a1a7808ULL, 0x000fc40000000000ULL,
0x0000001d0c00720bULL, 0x004fe20003f1e000ULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x000000200d00720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000000c1d0c7208ULL, 0x000fe40004000000ULL, 0x0000000d200d7208ULL, 0x000fe40004800000ULL,
0x000000250c00720bULL, 0x000fe40003f1e000ULL, 0x0000001e0d00720bULL, 0x000fc40003f3e000ULL,
0x0000000c25037208ULL, 0x000fe40004000000ULL, 0x0000000d1e027208ULL, 0x000fe40004800000ULL,
0x000000260300720bULL, 0x000fe40003f1e000ULL, 0x0000001f0200720bULL, 0x000fe40003f3e000ULL,
0x0000000326037208ULL, 0x000fe40004000000ULL, 0x000000021f0b7208ULL, 0x000fc40004800000ULL,
0x0000002e0300720bULL, 0x000fe40003f1e000ULL, 0x0000002c0b00720bULL, 0x000fe40003f3e000ULL,
0x000000032e027208ULL, 0x000fe40004000000ULL, 0x0000000b2c0b7208ULL, 0x000fe40004800000ULL,
0x000000270200720bULL, 0x000fe40003f1e000ULL, 0x000000220b00720bULL, 0x000fc40003f3e000ULL,
0x0000000227037208ULL, 0x000fe40004000000ULL, 0x0000000b22027208ULL, 0x000fe40004800000ULL,
0x000000280300720bULL, 0x000fe40003f1e000ULL, 0x000000210200720bULL, 0x000fe40003f3e000ULL,
0x00000003280a7208ULL, 0x000fe40004000000ULL, 0x0000000221027208ULL, 0x000fc40004800000ULL,
0x000000290a00720bULL, 0x000fe40003f1e000ULL, 0x000000230200720bULL, 0x000fe40003f3e000ULL,
0x0000000a290a7208ULL, 0x000fe40004000000ULL, 0x0000000223037208ULL, 0x000fe40004800000ULL,
0x000000330a00720bULL, 0x000fe40003f1e000ULL, 0x000000320300720bULL, 0x000fc40003f3e000ULL,
0x0000000a330a7208ULL, 0x000fe40004000000ULL, 0x0000000332037208ULL, 0x000fe40004800000ULL,
0x000000310a00720bULL, 0x000fe40003f1e000ULL, 0x000000140300720bULL, 0x000fe40003f3e000ULL,
0x0000000a310b7208ULL, 0x000fe40004000000ULL, 0x0000000314027208ULL, 0x000fc40004800000ULL,
0x0000002a0b00720bULL, 0x000fe40003f1e000ULL, 0x000000090200720bULL, 0x000fe40003f3e000ULL,
0x0000000b2a0a7208ULL, 0x000fe40004000000ULL, 0x0000000209027208ULL, 0x000fe40004800000ULL,
0x0000002b0a00720bULL, 0x000fe40003f1e000ULL, 0x000000150200720bULL, 0x000fc40003f3e000ULL,
0x0000000a2b037208ULL, 0x000fe40004000000ULL, 0x00000002150b7208ULL, 0x000fe40004800000ULL,
0x000000300300720bULL, 0x000fe40003f1e000ULL, 0x0000001c0b00720bULL, 0x000fe40003f3e000ULL,
0x0000000330027208ULL, 0x000fe40004000000ULL, 0x0000000b1c0a7208ULL, 0x000fc40004800000ULL,
0x0000002f0200720bULL, 0x000fe40003f1e000ULL, 0x000000170a00720bULL, 0x000fe40003f3e000ULL,
0x000000022f027208ULL, 0x000fe40004000000ULL, 0x0000000a17037208ULL, 0x000fe40004800000ULL,
0x0000002d0200720bULL, 0x000fe40003f1e000ULL, 0x000000180300720bULL, 0x000fc40003f3e000ULL,
0x000000022d0b7208ULL, 0x000fe40004000000ULL, 0x0000000318027208ULL, 0x000fe40004800000ULL,
0x000000240b00720bULL, 0x000fe40003f1e000ULL, 0x000000190200720bULL, 0x000fe40003f3e000ULL,
0x0000000b240b7208ULL, 0x000fe40004000000ULL, 0x0000000219037208ULL, 0x000fc40004800000ULL,
0x000000160b00720bULL, 0x000fe40003f1e000ULL, 0x0000001a0300720bULL, 0x000fe40003f3e000ULL,
0x0000000b16107208ULL, 0x000fe40004000000ULL, 0x000000031a127208ULL, 0x000fe20004800000ULL,
0x000014a27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0010027f89ULL, 0x0004e400000e0000ULL,
0x000000021000720bULL, 0x008fc80003f1e000ULL, 0x0000001002347208ULL, 0x000fe20004000000ULL,
0x000014b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0012027f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e037f89ULL, 0x000f2800000e0000ULL, 0x0c401f000f0c7f89ULL, 0x000e6800000e0000ULL,
0x0c201f00340d7f89ULL, 0x000ea200000e0000ULL, 0x000000021200720bULL, 0x008fc40003f1e000ULL,
0x000000030e00720bULL, 0x010fe40003f3e000ULL, 0x00000012020a7208ULL, 0x000fe40004000000ULL,
0x0000000e030b7208ULL, 0x000fe40004800000ULL, 0x0000000c0f00720bULL, 0x002fe20003f1e000ULL,
0x0c201f000a117f89ULL, 0x000e6600000e0000ULL, 0x0000000f0c027208ULL, 0x000fe20004000000ULL,
0x0c201f000b107f89ULL, 0x004ea200000e0000ULL, 0x0000000d3400720bULL, 0x000fc60003f1e000ULL,
0x0c201f0002037f89ULL, 0x0006e200000e0000ULL, 0x000000340d0c7208ULL, 0x000fe40004000000ULL,
0x000000110a00720bULL, 0x002fe40003f3e000ULL, 0x000000100b00720bULL, 0x004fe40003f5e000ULL,
0x0000000a110d7208ULL, 0x000fe40004800000ULL, 0x0000000b100e7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b0c347820ULL, 0x008fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000305ff7812ULL, 0x000fe2000780c0ffULL, 0x00000004ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010834ULL,
0x0000002600127308ULL, 0x0007e20000000800ULL, 0x3f8000000a0a783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010834ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b2f0f7823ULL, 0x100fe20000010834ULL,
0x0000002e00117308ULL, 0x002e620000000800ULL, 0x3fb8aa3b2d267823ULL, 0x008fe20000010834ULL,
0x3fb8aa3b0d2d7820ULL, 0x000fe20000410000ULL, 0x000000ffff377224ULL, 0x000fe200078e000aULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082dULL,
0x0000001d00107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL,
0x000000121112723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010834ULL,
0x00000025000b7308ULL, 0x0002e20000000800ULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1a1a7823ULL, 0x000fe2000001082dULL, 0x000000030200720bULL, 0x004fe20003f3e000ULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24257823ULL, 0x002fce0000010834ULL,
0x0000001e00137308ULL, 0x000e620000000800ULL, 0x000000100b10723eULL, 0x008fe200000010ffULL,
0x000000ffff0b7224ULL, 0x000fcc00078e000aULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000201311723eULL, 0x002fce00000010ffULL,
0x00000022001d7308ULL, 0x000fe20000000800ULL, 0x0000001f2c13723eULL, 0x004fce00000010ffULL,
0x0000002100247308ULL, 0x000e700000000800ULL, 0x00000023002e7308ULL, 0x0005f00000000800ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000000a1020723cULL, 0x004f6200000418ffULL,
0x0000001d241d723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b17247823ULL, 0x000fca000001082dULL,
0x0000003300367308ULL, 0x000e700000000800ULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000ea20000000800ULL, 0x00000029361e723eULL, 0x002fe200000010ffULL,
0x000000ffff367224ULL, 0x000fcc00078e000aULL, 0x00000032002f7308ULL, 0x0002f00000000800ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c327823ULL, 0x102fe2000001082dULL,
0x00000027281c723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b18277823ULL, 0x000fe2000001082dULL,
0x0000002e2f1f723eULL, 0x008fc800000010ffULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x00000002ff2e7819ULL, 0x000fc80000011605ULL, 0x000000082e357810ULL, 0x040fe20007ffe0ffULL,
0x000000361c20723cULL, 0x020f620000041820ULL, 0x000000082e297824ULL, 0x040fe200078e00ffULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x000000082e2d7824ULL, 0x040fe400078e00ffULL,
0x000000082e2f7824ULL, 0x040fe400078e00ffULL, 0x000000082e337824ULL, 0x000fc600078e00ffULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x00000014002c7308ULL, 0x0005f00000000800ULL,
0x0000000900097308ULL, 0x000ee20000000800ULL, 0x000000012e147810ULL, 0x004fc80007ffe0ffULL,
0xfffffff829297812ULL, 0x000fe400078ee214ULL, 0x000000312a14723eULL, 0x002fe200000010ffULL,
0x00000015000b7308ULL, 0x0007e20000000800ULL, 0x000000ffff317224ULL, 0x000fe200078e000aULL,
0x000000032e2a7810ULL, 0x000fcc0007ffe0ffULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x0000002c0915723eULL, 0x008fe200000010ffULL, 0x000000082e2c7824ULL, 0x040fe200078e00ffULL,
0x000000022e097810ULL, 0x000fca0007ffe0ffULL, 0x0000001600287308ULL, 0x0005e20000000800ULL,
0x0000000b3217723eULL, 0x002fce00000010ffULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000002b3016723eULL, 0x004fe200000010ffULL, 0x000000ffff307224ULL, 0x000fe200078e000aULL,
0xfffffff82c0b7812ULL, 0x000fe200078ee209ULL, 0x000000082e097824ULL, 0x040fe200078e00ffULL,
0xffffffff2e2c7810ULL, 0x040fe20007ffe0ffULL, 0x000000082e2b7824ULL, 0x000fe400078e00ffULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000301420723cULL, 0x020b620000041820ULL,
0xfffffff809097812ULL, 0x000fc400078ee22eULL, 0xfffffff82b2b7812ULL, 0x000fe400078ee22aULL,
0x000000062e2a7810ULL, 0x040fe40007ffe0ffULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000082e317824ULL, 0x020fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fc800078ee22cULL,
0xfffffff831317812ULL, 0x000fe400078ee22aULL, 0x0000002400187308ULL, 0x0007f00000000800ULL,
0x0000002700277308ULL, 0x000f220000000800ULL, 0x000000042e247810ULL, 0x008fc80007ffe0ffULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee224ULL, 0x000000052e247810ULL, 0x000fe20007ffe0ffULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x00000008352e7824ULL, 0x000fe400078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee224ULL, 0x0000000f2624723eULL, 0x002fe400000010ffULL,
0x000000252826723eULL, 0x004fe200000010ffULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x000000182725723eULL, 0x010fc400000010ffULL, 0x0000000c1b187812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e000aULL, 0x0000900004287811ULL, 0x000fe400078e58ffULL,
0xfffffff82e357812ULL, 0x000fe400078ee235ULL, 0x00000002030f7208ULL, 0x000fe20004800000ULL,
0x0000001009097824ULL, 0x100fe400078e0228ULL, 0x0000001029297824ULL, 0x100fe400078e0228ULL,
0x000000100b0b7824ULL, 0x000fe200078e0228ULL, 0x000000191a27723eULL, 0x002fe200000010ffULL,
0x000000ffff1a7224ULL, 0x000fc400078e000aULL, 0x000000102b2b7824ULL, 0x100fe400078e0228ULL,
0x000000102d2d7824ULL, 0x000fe400078e0228ULL, 0x0000000109097824ULL, 0x000fe200078e0218ULL,
0x0000001a2420723cULL, 0x000f620000041820ULL, 0x000000102f2f7824ULL, 0x100fe400078e0228ULL,
0x0000000118297824ULL, 0x000fe200078e0229ULL, 0x0000001009007388ULL, 0x0003e20000000800ULL,
0x0000001031317824ULL, 0x000fc400078e0228ULL, 0x00000001180b7824ULL, 0x040fe200078e020bULL,
0x0000001229007388ULL, 0x0003e20000000800ULL, 0x0000001033337824ULL, 0x100fe400078e0228ULL,
0x00000001182b7824ULL, 0x040fe200078e022bULL, 0x0000001c0b007388ULL, 0x0003e20000000800ULL,
0x0000001035357824ULL, 0x000fe400078e0228ULL, 0x00000001182d7824ULL, 0x040fe200078e022dULL,
0x0000001e2b007388ULL, 0x0003e20000000800ULL, 0x00000001182f7824ULL, 0x000fc400078e022fULL,
0x0000000118317824ULL, 0x040fe200078e0231ULL, 0x000000142d007388ULL, 0x0003e20000000800ULL,
0x0000000118337824ULL, 0x040fe400078e0233ULL, 0x0000000118187824ULL, 0x000fe200078e0235ULL,
0x000000162f007388ULL, 0x0003e20000000800ULL, 0x000000ffff217224ULL, 0x020fc600078e0022ULL,
0x0000002431007388ULL, 0x0003e80000000800ULL, 0x0000002633007388ULL, 0x0003e80000000800ULL,
0x0000001118007388ULL, 0x0003e80000000800ULL, 0x0004001329007388ULL, 0x0003e80000000800ULL,
0x0004001d0b007388ULL, 0x0003e80000000800ULL, 0x0004001f2b007388ULL, 0x0003e80000000800ULL,
0x000400152d007388ULL, 0x0003e80000000800ULL, 0x000400172f007388ULL, 0x0003e80000000800ULL,
0x0004002531007388ULL, 0x0003e80000000800ULL, 0x0004002733007388ULL, 0x0003e80000000800ULL,
0x00f0000c00008388ULL, 0x0003e80000000c00ULL, 0x00f2002000008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007bff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008007bff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010007bff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000107077810ULL, 0x000fe20007ffe0ffULL,
0x000018007bff7f8cULL, 0x0003e6000c80043fULL, 0x0000006a0700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa7f000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff107807ULL, 0x008fe40004000000ULL,
0x0001680000117802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x002fea0003c00000ULL,
0xfffebbc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x0001684000117802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e003cULL, 0xfffebc2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0021ULL, 0x00016890003d7802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x002fea0003c00000ULL, 0xfffebd0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0021ULL, 0x000168d0003d7802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x002fea0003c00000ULL, 0xfffebe2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x00016920003d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e000aULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003cULL, 0xfffec22000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x00016970003d7802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xfffec20000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe40004000000ULL,
0x000169c000117802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x002fea0003c00000ULL,
0xfffeefb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x00016a0000117802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e003cULL, 0xfffef00000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00016a50003d7802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x002fea0003c00000ULL, 0xfffef0e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00016a90003d7802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x002fea0003c00000ULL, 0xfffef20000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00016ae0003d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e000fULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003cULL, 0xfffef61000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00016b30003d7802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xfffef5f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe40004000000ULL,
0x00016b8000117802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x002fea0003c00000ULL,
0xffff236000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x00016bc000117802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x000fe200078e003cULL, 0xffff23b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e003aULL, 0x00016c10003d7802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x002fea0003c00000ULL, 0xffff24a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e003aULL, 0x00016c50003d7802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x002fea0003c00000ULL, 0xffff25c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000dULL, 0x00016ca0003d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e000eULL, 0x000006d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003cULL, 0xffff29e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000dULL, 0x00016cf0003d7802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xffff29c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe40004000000ULL,
0x00016d4000117802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x008fea0003c00000ULL,
0xffff567000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x00016d8000117802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff337224ULL, 0x000fe200078e003cULL, 0xffff56c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0035ULL, 0x00016dd0003d7802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x008fea0003c00000ULL, 0xffff57a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0035ULL, 0x00016e10003d7802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x008fea0003c00000ULL, 0xffff58c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0006ULL, 0x00016e60003d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003cULL, 0xffff5d1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0006ULL, 0x00016eb0003d7802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xffff5cf000007947ULL, 0x000fea000383ffffULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x00016f00000a7802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0003ULL, 0xffffeb2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x006fe200078e0012ULL, 0x00016f60000a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000031200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000eULL,
0x00016fc0000a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x0000001203127208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000030e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000fULL,
0x00017020000a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x0000000e030e7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000030f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e0034ULL,
0x00017080000a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x0000000f03027208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000033400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e0012ULL,
0x000170e0000a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x00000034030c7208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000031200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000eULL,
0x00017140000a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x00000012030d7208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000030e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e0002ULL,
0x000171a0000a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x0000000e030e7208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe9f000007947ULL, 0x000fea000383ffffULL, 0x0180000031007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000003100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff31ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000031027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe8cd002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00001110037389ULL, 0x0002a200000e0013ULL,
0xfffe8c900a007950ULL, 0x000fea0003c3ffffULL, 0x0000007600007348ULL, 0x000fe80003800000ULL,
0x00000010113c7389ULL, 0x0002a400000e0078ULL, 0x000000ffff107224ULL, 0x002fc400078e003dULL,
0x00000000ff117424ULL, 0x000fc800078e00ffULL, 0xfffe8c4010007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f45070ULL, 0x000000ffff107224ULL, 0x000fe200078e0011ULL,
0x0000007400007348ULL, 0x000fe80003800000ULL, 0x00000000ff117424ULL, 0x000fce00078e00ffULL,
0x00000000003c7806ULL, 0x000fc800050e0100ULL, 0x000000743c3c7212ULL, 0x000fe200078ec0ffULL,
0xfffe8bd010007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x00000000000002e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ce0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000da0ULL, 0x00000000000007bcULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001560ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001570ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001600ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001604ULL, 0x00000000000001b8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000017500ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018d00ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018d50ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000190d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001600ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017700ULL, 0x0000000000017700ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018d00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000190d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_89_cubin_len = 102832;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
