/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000013d38ULL, 0x00000000000139b8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x0000000000012320ULL, 0x0000000000000260ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000012580ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001232000000000ULL, 0x00010c0400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x0001232000000000ULL, 0x0000026000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x0008230400000080ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0050000900000000ULL,
0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040021f000ULL, 0x0040000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040061f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000023000942804ULL, 0x00000960000002e0ULL,
0x0000269000002620ULL, 0x000028a000002760ULL, 0x00002dc000002db0ULL, 0x000049a000004930ULL,
0x00004bc000004a80ULL, 0x000050e0000050d0ULL, 0x00006c7000006c10ULL, 0x00006eb000006d70ULL,
0x00007300000072f0ULL, 0x00008e8000008e10ULL, 0x000090a000008f60ULL, 0x0000951000009500ULL,
0x0000a6000000a5f0ULL, 0x0001181000011760ULL, 0x00011ac000011a40ULL, 0x00011da000011ce0ULL,
0x00011fe000011e40ULL, 0x0000048004303904ULL, 0x00017600000000ffULL, 0x0000056000040100ULL,
0x0001760800000005ULL, 0x00000670003f0100ULL, 0x0001768800000005ULL, 0x00000790003f0100ULL,
0x000176a800000003ULL, 0x000008a0003f0100ULL, 0x000176c800000002ULL, 0x00000e00003f0100ULL,
0x00017600000000ffULL, 0x00000f0000080107ULL, 0x000176880000000bULL, 0x000017b000080101ULL,
0x00000000000000ffULL, 0x000017e000040107ULL, 0x00000000000000ffULL, 0x0000186000040101ULL,
0x0000002000000003ULL, 0x00001920003f0101ULL, 0x000176c800000017ULL, 0x00001ab000080109ULL,
0x000176c800000035ULL, 0x00002300003f0109ULL, 0x000176b000000017ULL, 0x0000237000080107ULL,
0x000176b000000048ULL, 0x00002380003f0101ULL, 0x0001760800000034ULL, 0x000023c0003f0101ULL,
0x000176080000004bULL, 0x00002530003f0109ULL, 0x000176080000004bULL, 0x00002a50003f0109ULL,
0x000176a800000016ULL, 0x00002bd000080109ULL, 0x000176a800000036ULL, 0x00003c90003f0109ULL,
0x000176c800000035ULL, 0x00003cb0003f0101ULL, 0x0001768800000037ULL, 0x00003d5000080101ULL,
0x0000000000000004ULL, 0x00003ec0003f0109ULL, 0x0000000000000004ULL, 0x00004660003f0109ULL,
0x000176a800000014ULL, 0x000046e000080107ULL, 0x000176a800000056ULL, 0x000046f0003f0101ULL,
0x0001762800000015ULL, 0x00004710003f0101ULL, 0x000176280000004bULL, 0x00004880003f0109ULL,
0x000176280000004bULL, 0x00004d90003f0109ULL, 0x000176b000000017ULL, 0x00004f1000080109ULL,
0x000176b000000037ULL, 0x00005f70003f0109ULL, 0x000176c800000034ULL, 0x00005f90003f0101ULL,
0x0001769000000053ULL, 0x0000603000080101ULL, 0x0000000000000004ULL, 0x000061a0003f0109ULL,
0x0000000000000004ULL, 0x00006900003f0109ULL, 0x00000008000000ffULL, 0x0000697000040107ULL,
0x0000000800000054ULL, 0x00006980003f0101ULL, 0x000176480000004bULL, 0x000069f0003f0101ULL,
0x000176480000003dULL, 0x00006b60003f0109ULL, 0x000176480000003dULL, 0x00007070003f0109ULL,
0x000176a800000017ULL, 0x000071f000080109ULL, 0x000176a800000037ULL, 0x00008130003f0109ULL,
0x0000000000000004ULL, 0x00008160003f0101ULL, 0x0001769800000037ULL, 0x00008210003f0101ULL,
0x0000000000000004ULL, 0x00008380003f0109ULL, 0x0000000000000004ULL, 0x00008b20003f0109ULL,
0x00000000000000ffULL, 0x00008bb000040107ULL, 0x000176a800000014ULL, 0x00008bd0003f0101ULL,
0x0001766800000037ULL, 0x00008c00003f0101ULL, 0x0001766800000037ULL, 0x00008d70003f0109ULL,
0x0001766800000037ULL, 0x00009260003f0109ULL, 0x000176b000000017ULL, 0x0000940000080109ULL,
0x000176b00000003dULL, 0x0000a250003f0109ULL, 0x0000000000000004ULL, 0x0000a2a0003f0101ULL,
0x000176a000000004ULL, 0x0000b500003f0101ULL, 0x00017600000000ffULL, 0x0000cd3000080101ULL,
0x00017600000000ffULL, 0x0000cea000080109ULL, 0x00017600000000ffULL, 0x0000d08000080109ULL,
0x00017600000000ffULL, 0x0000d0a000080101ULL, 0x00017600000000ffULL, 0x0000d21000080109ULL,
0x00017600000000ffULL, 0x0000fd8000080109ULL, 0x0001768800000005ULL, 0x0000ff50003f0101ULL,
0x0001768800000005ULL, 0x000100c0003f0109ULL, 0x0001768800000005ULL, 0x000122c0003f0109ULL,
0x0001760800000006ULL, 0x000122d0003f0101ULL, 0x0001761000000006ULL, 0x000122e0003f0101ULL,
0x0001761800000006ULL, 0x000122f0003f0101ULL, 0x0001762000000006ULL, 0x00053803003f0101ULL,
0x0000ae6000201c04ULL, 0x0000b0800000aec0ULL, 0x0000b3700000b1e0ULL, 0x0000d2400000b470ULL,
0x000c050400012310ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL,
0x0000001800080a04ULL, 0x0000000000580210ULL, 0x00000000000000bcULL, 0x0000001700000002ULL,
0x0000000000012320ULL, 0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff087b82ULL, 0x000ea20000000a00ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000067919ULL, 0x000ee20000002300ULL,
0x0000010000057ab9ULL, 0x000fe20000000800ULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x0000000000077919ULL, 0x000ee20000002200ULL, 0x0000000000397919ULL, 0x000f220000002100ULL,
0x0000000000117919ULL, 0x000f620000002700ULL, 0x0000000900007306ULL, 0x004ea20000209000ULL,
0x000000ff0900720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00027836ULL, 0x004fcc0000000000ULL, 0x0000000200037305ULL, 0x0004e4000021f000ULL,
0x000000ffff027224ULL, 0x004fe400078e00ffULL, 0x000000ffff047224ULL, 0x00afc800078e0a03ULL,
0x0000000904057224ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000403057c27ULL, 0x000fc8000f8e00ffULL, 0x000000ffff047224ULL, 0x000fc800078e0a05ULL,
0x0000000409007e24ULL, 0x000fe2000f8e0204ULL, 0x00000000000479c3ULL, 0x000e680000002600ULL,
0x000000090000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a09ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000090000720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000009ff05a212ULL, 0x000fc800078e33ffULL,
0x0000000500007306ULL, 0x000ea20000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00027836ULL, 0x004fe40000000000ULL,
0x0000000506007c24ULL, 0x000fe2000f8e0207ULL, 0x0000000000057ab9ULL, 0x000fc60000000800ULL,
0x0000000200037305ULL, 0x0004e2000021f000ULL, 0x00001fff06067589ULL, 0x000f6200000e0000ULL,
0x000000ffff027224ULL, 0x004fe400078e00ffULL, 0x0000000305047224ULL, 0x008fc800078e02ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a04ULL, 0x0000000b03037227ULL, 0x000fe400078e0002ULL,
0x00008600ff0b7b82ULL, 0x000f640000000800ULL, 0x0000000500027c24ULL, 0x110fe2000f8e0239ULL,
0x00000005ff397819ULL, 0x000fe20000011639ULL, 0x0000000403407c27ULL, 0x002fc6000f8e00ffULL,
0x0000007f0200780cULL, 0x040fe20003f64070ULL, 0x000000ffff007224ULL, 0x000fe200078e0a40ULL,
0x00001fff39397589ULL, 0x000f6200000e0000ULL, 0x000000030200780cULL, 0x000fe40003f84070ULL,
0x0000000405007e24ULL, 0x000fca000f8e0200ULL, 0x000000050000720cULL, 0x000fc60003f06070ULL,
0x000000000003b919ULL, 0x000e620000008800ULL, 0xff317217ff04b424ULL, 0x000fd200078e00ffULL,
0x0000000100000824ULL, 0x000fe400078e0a05ULL, 0x0000000140400836ULL, 0x000fe20000000000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000050000720cULL, 0x000fe40003f26070ULL,
0x000004000000b802ULL, 0x000fd60000000f00ULL, 0x0000000140401836ULL, 0x000fe20000000000ULL,
0x00000005ff40a212ULL, 0x000fe400078e33ffULL, 0x0000000f0200780cULL, 0x040fe40003f24070ULL,
0x000006540303b816ULL, 0x002fe20000000000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0a40ULL,
0x000000010200780cULL, 0x000fc60003f44070ULL, 0x00000004053a7e24ULL, 0x000fe4000f8e023aULL,
0x000000040203b824ULL, 0x000fe400078e0203ULL, 0x000000103a007824ULL, 0x000fe200078e00ffULL,
0x0000000000240947ULL, 0x020fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01760006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402057c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000050612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01760804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402057c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01768804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x017400040300b388ULL, 0x0003e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000030612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e0a00ULL, 0x0000000b08037219ULL, 0x082fe200000006ffULL,
0x0000000811087224ULL, 0x000fe200078e02ffULL, 0x0000000b090f7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000001003387446ULL, 0x000fe20003800038ULL,
0x0000000406037824ULL, 0x000fe200078e0239ULL, 0x0000000b40027219ULL, 0x000fc400000006ffULL,
0x000000ff38387207ULL, 0x000fe20000000000ULL, 0x0000000203037824ULL, 0x000fe400078e00ffULL,
0x0000000f08027224ULL, 0x000fe200078e0202ULL, 0x000000103800780cULL, 0x000fda0003f05270ULL,
0x0000000000848947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00000400000a7802ULL, 0x000fe20000000f00ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000137919ULL, 0x000ea40000008800ULL,
0x0000000b04057219ULL, 0x000fe400000006ffULL, 0x00000004ff087819ULL, 0x002fe4000001160dULL,
0x0000065413137816ULL, 0x004fc6000000000aULL, 0x0000000103077824ULL, 0x000fe200078e0208ULL,
0x00000000130872caULL, 0x000fc600000e0000ULL, 0x0000000100047824ULL, 0x000fca00078e0207ULL,
0x0000000504057212ULL, 0x000fe400078e30ffULL, 0x0000000bff047219ULL, 0x000fc60000011604ULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0x0000000338027248ULL, 0x000fc60007fe0000ULL,
0x0000000f040a7224ULL, 0x000fe400078e0205ULL, 0x000000100d047824ULL, 0x000fe400078e00ffULL,
0x0000000102057824ULL, 0x000fe400078e0a03ULL, 0x000001000a027825ULL, 0x000fe200078e00ffULL,
0x000000f0040b7812ULL, 0x000fe400078ec0ffULL, 0x000000050800720cULL, 0x000fe20003f06070ULL,
0x0000000107057824ULL, 0x040fe200078e020dULL, 0x0000000b020b7212ULL, 0x000fe200078efcffULL,
0x0000001007087824ULL, 0x000fc600078e00ffULL, 0x000000040b027c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff008057812ULL, 0x000fe400078ee205ULL, 0x0000000503037c10ULL, 0x000fe40008ffe4ffULL,
0x0000000805057c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c46ULL, 0x0000000000707947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000137919ULL, 0x000ea60000008800ULL,
0x0000000b04047219ULL, 0x000fe400000006ffULL, 0x000000030d057211ULL, 0x002fca00078fe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0205ULL, 0x0000001005087824ULL, 0x000fc600078e00ffULL,
0x0000000403077212ULL, 0x000fe400078e30ffULL, 0x0000000bff047219ULL, 0x000fc60000011603ULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x0000040000027802ULL, 0x000fc80000000f00ULL,
0x0000065413137816ULL, 0x004fe20000000002ULL, 0x0000000f04027224ULL, 0x000fe400078e0207ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000000130872caULL, 0x000fe200000e0000ULL,
0x0000010002027825ULL, 0x000fc600078e00ffULL, 0x000000f0040b7812ULL, 0x000fe200078ec0ffULL,
0x0000000105077824ULL, 0x000fc600078e020dULL, 0x0000000b02027212ULL, 0x000fe400078efcffULL,
0xfffffff008077812ULL, 0x000fe400078ee207ULL, 0x0000000402027c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000807077c11ULL, 0x000fe4000f8e20ffULL, 0x0000000503037c10ULL, 0x000fca00087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000b901c46ULL,
0x0001760008047890ULL, 0x000fe2000fffe03fULL, 0x00009000ff027b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000411027825ULL, 0x002fe200078e0002ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006020e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x000000ff0e067836ULL, 0x004fca0000000000ULL,
0x00000008ff0c7819ULL, 0x000fce0000011606ULL, 0x000000a400788947ULL, 0x000fea0003800000ULL,
0x00000008390b7824ULL, 0x040fe200078e00ffULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x00000004ff007424ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011639ULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000000139077812ULL, 0x000fe200078ec0ffULL,
0x017688000bff79a7ULL, 0x0003e40008500008ULL, 0x0000000211007824ULL, 0x002fc800078e00ffULL,
0x0000000900037224ULL, 0x000fe400078e0209ULL, 0x000000200a097824ULL, 0x000fe400078e00ffULL,
0x0000000140087824ULL, 0x000fc800078e0203ULL, 0x0000000408007c24ULL, 0x000fe2000f8e0209ULL,
0x0000000400000947ULL, 0x000fec0003800000ULL, 0x000000090e027248ULL, 0x000fe20007fe0000ULL,
0x0000001007037824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fe2000001160dULL,
0x00008e0000047ab9ULL, 0x000fe40000000a00ULL, 0x0000000102027824ULL, 0x000fe400078e0a09ULL,
0x0000000103067824ULL, 0x000fe400078e0205ULL, 0x0000000405117836ULL, 0x000fe20000000000ULL,
0x0000000302027248ULL, 0x000fe20007fe0000ULL, 0x0000000106107824ULL, 0x000fc400078e020dULL,
0x0000000806137824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e0a03ULL,
0x0000000c05127836ULL, 0x000fe20000000000ULL, 0xfffffff813167812ULL, 0x000fe200078ee210ULL,
0x0000000805107836ULL, 0x000fe20000000000ULL, 0x000000021100720cULL, 0x080fe20003f46070ULL,
0x0000000100067824ULL, 0x000fe200078e0206ULL, 0x000000020500720cULL, 0x080fe20003f66070ULL,
0x0000000103117824ULL, 0x040fe200078e0211ULL, 0x000000021000720cULL, 0x080fe20003f26070ULL,
0x0000000103107824ULL, 0x040fe200078e0210ULL, 0x000000021200720cULL, 0x000fe20003f06070ULL,
0x0000000103137824ULL, 0x000fc400078e0212ULL, 0x0000008006027825ULL, 0x000fc800078e00ffULL,
0x0000000111057824ULL, 0x040fe200078e020dULL, 0x0000007002147812ULL, 0x000fe200078ef804ULL,
0x0000000811187824ULL, 0x000fe400078e00ffULL, 0x0000000100127824ULL, 0x040fe200078e0213ULL,
0x0000000414147c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000113027824ULL, 0x040fe200078e020dULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0x0000000503157c10ULL, 0x000fe2000a7fe4ffULL, 0x0000000100117824ULL, 0x000fc400078e0211ULL,
0x0000000100067824ULL, 0x000fe200078e0210ULL, 0xfffffff8131c7812ULL, 0x000fe200078ee202ULL,
0x0000000110057824ULL, 0x000fe200078e020dULL, 0x000000080a007c11ULL, 0x000fe2000f8e68ffULL,
0x00000008101a7824ULL, 0x000fe400078e00ffULL, 0x0000008011027825ULL, 0x000fc600078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL, 0x0000008006107825ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc600078ef804ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000402027c10ULL, 0x000fc6000ff9e0ffULL, 0x0001300000057836ULL, 0x000fe20000000000ULL,
0x0000007010007812ULL, 0x000fe400078ef804ULL, 0x0000007012107812ULL, 0x000fe200078ef804ULL,
0x0000001016177824ULL, 0x100fe200078e0205ULL, 0x0000000400047c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001018197824ULL, 0x100fe200078e0205ULL, 0x0000000410107c10ULL, 0x000fe2000ffde0ffULL,
0x000000101a1b7824ULL, 0x100fe200078e0205ULL, 0x0000000503037c10ULL, 0x000fe2000a7fe4ffULL,
0x000000101c1d7824ULL, 0x000fe200078e0205ULL, 0x0000000511057c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d901c46ULL,
0x0000000513117c10ULL, 0x000fc6000b7fe4ffULL, 0x0000000002197faeULL, 0x0003e8000d101c46ULL,
0x00000000041b7faeULL, 0x0003e8000c901c46ULL, 0x00000000101d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00008e0000047ab9ULL, 0x000fc80000000a00ULL, 0x000000020d027211ULL, 0x000fca00078fe8ffULL,
0x0000000402067836ULL, 0x000fe40000000000ULL, 0x0000000102037824ULL, 0x140fe400078e020dULL,
0x0000000802127824ULL, 0x000fe400078e00ffULL, 0x0000000106107824ULL, 0x040fe400078e020dULL,
0x0000000806117824ULL, 0x000fe200078e00ffULL, 0xfffffff812057812ULL, 0x000fe200078ee203ULL,
0x0000000100037824ULL, 0x000fc400078e0202ULL, 0x0000000c02127836ULL, 0x000fe20000000000ULL,
0xfffffff811167812ULL, 0x000fe200078ee210ULL, 0x0000000802107836ULL, 0x000fe40000000000ULL,
0x0000008003027825ULL, 0x000fc800078e00ffULL, 0x0000000100067824ULL, 0x040fe200078e0206ULL,
0x0000007002147812ULL, 0x000fe200078ef804ULL, 0x0000000100117824ULL, 0x040fe400078e0210ULL,
0x0000000100137824ULL, 0x000fe200078e0212ULL, 0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000110007824ULL, 0x140fe400078e020dULL, 0x0000000810157824ULL, 0x000fe200078e00ffULL,
0x000000080a107c11ULL, 0x000fe2000f8e68ffULL, 0x0000000112027824ULL, 0x000fc400078e020dULL,
0x0000000812177824ULL, 0x000fe200078e00ffULL, 0xfffffff815007812ULL, 0x000fe200078ee200ULL,
0x00013000101d7836ULL, 0x000fe20000000000ULL, 0x0000000503157c10ULL, 0x000fe200087fe4ffULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0xfffffff817187812ULL, 0x000fc600078ee202ULL,
0x0000008006027825ULL, 0x000fc800078e00ffULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc600078ef804ULL, 0x0000001005177824ULL, 0x100fe200078e021dULL,
0x0000007010057812ULL, 0x000fe200078ef804ULL, 0x0000001016197824ULL, 0x100fe200078e021dULL,
0x0000007012107812ULL, 0x000fe200078ef804ULL, 0x00000010001b7824ULL, 0x100fe200078e021dULL,
0x0000000402027c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010181d7824ULL, 0x000fe200078e021dULL,
0x0000000405047c10ULL, 0x000fe2000ff3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000b901c46ULL, 0x0000000410107c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000503037c10ULL, 0x000fc400087fe4ffULL, 0x0000000511057c10ULL, 0x000fe40008ffe4ffULL,
0x0000000513117c10ULL, 0x000fe200097fe4ffULL, 0x0000000002197faeULL, 0x0003e8000b901c46ULL,
0x00000000041b7faeULL, 0x0003e8000b901c46ULL, 0x00000000101d7faeULL, 0x0003e4000b901c46ULL,
0x00000008ff037e24ULL, 0x002fe2000f8e00ffULL, 0x000000000a0472caULL, 0x000fe200000e0000ULL,
0x00000001ff027424ULL, 0x000fe200078e00ffULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x000176a803037836ULL, 0x000fe20000000000ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff517224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000030572caULL, 0x000fc400000e0000ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe400078e00ffULL, 0x000000080a037824ULL, 0x000fe400078e0203ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000002ff4c79a7ULL, 0x0002a20008500004ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00002002030279a7ULL, 0x002e62000850003fULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000008c00008947ULL, 0x000fec0003800000ULL,
0x000000ffff347224ULL, 0x002fe200078e0003ULL, 0x00000002ff067819ULL, 0x000fe20000011639ULL,
0xff317217ff457424ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fce00078e00ffULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000000439047824ULL, 0x000fca00078e00ffULL, 0xfffffff804177812ULL, 0x000fc800078ec0ffULL,
0x0176c834170075a7ULL, 0x000e620008000148ULL, 0x0000000817357c36ULL, 0x000fc80008000000ULL,
0x000176c835047836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176c834350075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000105157836ULL, 0x000fe20000000000ULL,
0x0000920000057ab9ULL, 0x000fe20000000800ULL, 0x0000010005447824ULL, 0x000fc600078e0209ULL,
0x0000000c1500720cULL, 0x000fe20003f26070ULL, 0x0000004044157836ULL, 0x000fc80000000000ULL,
0x0000000508367c24ULL, 0x000fd0000f8e0215ULL, 0x0000000400089947ULL, 0x000fea0003800000ULL,
0x000000150e147248ULL, 0x000fe20007fe0000ULL, 0x0000001007177824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe2000001160dULL, 0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000114147824ULL, 0x000fe400078e0a15ULL, 0x0000000117157824ULL, 0x000fe400078e0216ULL,
0x0000000416357836ULL, 0x000fe20000000000ULL, 0x0000001417147248ULL, 0x000fe20007fe0000ULL,
0x0000000115347824ULL, 0x000fc400078e020dULL, 0x00000008153b7824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fe400078e0a17ULL, 0x0000000117377824ULL, 0x000fe200078e0235ULL,
0xfffffff83b3c7812ULL, 0x000fe200078ee234ULL, 0x0000000816347836ULL, 0x000fe20000000000ULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x0000000c163b7836ULL, 0x000fe20000000000ULL,
0x000000143500720cULL, 0x080fe20003f66070ULL, 0x0000000137167824ULL, 0x040fe200078e020dULL,
0x000000143400720cULL, 0x080fe20003f46070ULL, 0x00000008373f7824ULL, 0x000fe200078e00ffULL,
0x000000143b00720cULL, 0x000fe20003f06070ULL, 0x0000000117357824ULL, 0x000fc400078e0234ULL,
0x00000001173d7824ULL, 0x000fe200078e023bULL, 0xfffffff83f3e7812ULL, 0x000fe200078ee216ULL,
0x000000100d177824ULL, 0x000fe200078e00ffULL, 0x000000080a3b7c11ULL, 0x000fe2000f8e68ffULL,
0x0000000115147824ULL, 0x100fe400078e0236ULL, 0x0000000137167824ULL, 0x100fe400078e0236ULL,
0x0000000135347824ULL, 0x040fe400078e0236ULL, 0x0000000135377824ULL, 0x000fc400078e020dULL,
0x0000000835427824ULL, 0x000fe400078e00ffULL, 0x000000013d367824ULL, 0x040fe400078e0236ULL,
0x000000013d357824ULL, 0x040fe200078e020dULL, 0xfffffff842427812ULL, 0x000fe200078ee237ULL,
0x000000083d467824ULL, 0x000fe200078e00ffULL, 0x00000070173d7812ULL, 0x000fe200078ec0ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee235ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003d14147212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003d16167212ULL, 0x080fe400078efcffULL,
0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fe4000ffde0ffULL, 0x0000003d34347212ULL, 0x080fe200078efcffULL,
0x000140003b3b7836ULL, 0x000fe20000000000ULL, 0x0000003d36367212ULL, 0x000fe400078efcffULL,
0x0000000b15157c10ULL, 0x000fe2000affe4ffULL, 0x000000103c3d7824ULL, 0x100fe200078e023bULL,
0x0000000b17177c10ULL, 0x000fe2000b7fe4ffULL, 0x000000103e3f7824ULL, 0x100fe200078e023bULL,
0x0000000a34347c10ULL, 0x000fe2000ffbe0ffULL, 0x0000001042417824ULL, 0x100fe200078e023bULL,
0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL, 0x00000010463b7824ULL, 0x000fe200078e023bULL,
0x0000000b35357c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000e101c46ULL, 0x0000000b37377c10ULL, 0x000fc6000b7fe4ffULL,
0x00000000163f7faeULL, 0x0003e8000d901c46ULL, 0x0000000034417faeULL, 0x0003e8000d101c46ULL,
0x00000000363b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d47947ULL, 0x000fea0003800000ULL,
0x0000001007147824ULL, 0x000fe200078e00ffULL, 0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL,
0x000000100d167824ULL, 0x000fc600078e00ffULL, 0x000000140d157211ULL, 0x000fe400078fe8ffULL,
0x00000070163f7812ULL, 0x000fc600078ec0ffULL, 0x0000000415177836ULL, 0x000fe40000000000ULL,
0x0000000115147824ULL, 0x140fe400078e020dULL, 0x00000008153b7824ULL, 0x000fe400078e00ffULL,
0x0000000117347824ULL, 0x040fe400078e020dULL, 0x00000008173d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee214ULL, 0x0000000815357836ULL, 0x000fc40000000000ULL,
0x0000000c153c7836ULL, 0x000fe20000000000ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee234ULL,
0x0000000115147824ULL, 0x100fe400078e0236ULL, 0x0000000117167824ULL, 0x100fe200078e0236ULL,
0x000000080a177c11ULL, 0x000fe2000f8e68ffULL, 0x0000000135347824ULL, 0x040fe400078e0236ULL,
0x0000000135377824ULL, 0x040fe400078e020dULL, 0x00000008353e7824ULL, 0x000fc400078e00ffULL,
0x000000013c367824ULL, 0x040fe400078e0236ULL, 0x000000013c357824ULL, 0x040fe200078e020dULL,
0xfffffff83e417812ULL, 0x000fe200078ee237ULL, 0x000000083c3c7824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83c437812ULL, 0x000fe200078ee235ULL,
0x00014000173c7836ULL, 0x000fe20000000000ULL, 0x0000003f14147212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003f16167212ULL, 0x080fe400078efcffULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003f34347212ULL, 0x080fe400078efcffULL, 0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e023cULL, 0x0000003f36367212ULL, 0x000fe200078efcffULL,
0x000000103d3d7824ULL, 0x100fe200078e023cULL, 0x0000000a34347c10ULL, 0x000fe2000ff5e0ffULL,
0x00000010413f7824ULL, 0x100fe200078e023cULL, 0x0000000a36367c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001043417824ULL, 0x000fe200078e023cULL, 0x0000000b17177c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143b7faeULL, 0x0003e2000b901c46ULL,
0x0000000b35357c10ULL, 0x000fc400097fe4ffULL, 0x0000000b37377c10ULL, 0x000fe20009ffe4ffULL,
0x00000000163d7faeULL, 0x0003e8000b901c46ULL, 0x00000000343f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036417faeULL, 0x0003e4000b901c46ULL, 0xfffffff00b177812ULL, 0x042fe200078ec0ffULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0xffffffe00b147812ULL, 0x040fe400078ec0ffULL,
0x000000100b157812ULL, 0x000fe200078ec0ffULL, 0x0000000817487c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000815167c10ULL, 0x000fe4000fffe014ULL,
0x00000000480572caULL, 0x000fc600000e0000ULL, 0x0000000807347824ULL, 0x000fd400078e0216ULL,
0x000176b005057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0176b035484879a7ULL, 0x0002e4000850003fULL,
0x01760835343479a7ULL, 0x002e64000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x000000080b177812ULL, 0x000fca00078ec0ffULL, 0x00000001164b7824ULL, 0x000fc800078e0217ULL,
0x017608354b0075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017608354b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000100d437824ULL, 0x000fe200078e00ffULL,
0x00000001ff467819ULL, 0x000fe2000001160dULL, 0x0000002039147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000007043437812ULL, 0x000fe200078ec0ffULL,
0x000000ffff527224ULL, 0x000fe200078e0045ULL, 0xffffff8014147812ULL, 0x000fe400078ec0ffULL,
0x0000000c46467812ULL, 0x000fe400078ec0ffULL, 0x0000000843157c10ULL, 0x000fca000fffe014ULL,
0x0000000115157824ULL, 0x000fca00078e0246ULL, 0x0170000015147984ULL, 0x000e680000000800ULL,
0x0172000015177984ULL, 0x0009220000000800ULL, 0x000000451400720bULL, 0x002fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16357812ULL, 0x000fda000780c0ffULL,
0x0000000000f48947ULL, 0x01cfea0003800000ULL, 0x000000390600720cULL, 0x000fe40003f45270ULL,
0x000000451400720bULL, 0x0c0fe40003f14000ULL, 0x0000004514527209ULL, 0x000fd20007810000ULL,
0x000000083915ac11ULL, 0x000fe4000f8e38ffULL, 0x0000000000347806ULL, 0x000fe400000e0100ULL,
0x000000154615a210ULL, 0x000fe40007ffe043ULL, 0x0000991034167816ULL, 0x000fc600000000ffULL,
0x017400521500a388ULL, 0x0003e20000000800ULL, 0x000000ff1600720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x0000004552157221ULL, 0x000fe20000010100ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b15157820ULL, 0x000fc80000410000ULL, 0x0000001500167308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff157819ULL, 0x002fcc000001160dULL,
0x00001f1516157589ULL, 0x004e6400000e0000ULL, 0x0000001518187220ULL, 0x082fe20000410000ULL,
0x0000001519197220ULL, 0x080fe20000410000ULL, 0x000000152c2c7220ULL, 0x080fe20000410000ULL,
0x000000152d2d7220ULL, 0x080fe20000410000ULL, 0x0000001530307220ULL, 0x080fe20000410000ULL,
0x0000001531317220ULL, 0x080fe20000410000ULL, 0x0000001528287220ULL, 0x080fe20000410000ULL,
0x0000001529297220ULL, 0x080fe20000410000ULL, 0x0000001524247220ULL, 0x080fe20000410000ULL,
0x0000001525257220ULL, 0x080fe20000410000ULL, 0x0000001520207220ULL, 0x080fe20000410000ULL,
0x0000001521217220ULL, 0x080fe20000410000ULL, 0x000000151c1c7220ULL, 0x080fe20000410000ULL,
0x000000151d1d7220ULL, 0x080fe20000410000ULL, 0x0000001510107220ULL, 0x080fe20000410000ULL,
0x0000001511117220ULL, 0x000fce0000410000ULL, 0x0000001651517220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d157811ULL, 0x002fcc00078ff0ffULL,
0x00001f1516157589ULL, 0x000e6400000e0000ULL, 0x000000151a1a7220ULL, 0x082fe20000410000ULL,
0x000000151b1b7220ULL, 0x080fe20000410000ULL, 0x000000152e2e7220ULL, 0x080fe20000410000ULL,
0x000000152f2f7220ULL, 0x080fe20000410000ULL, 0x0000001532327220ULL, 0x080fe20000410000ULL,
0x0000001533337220ULL, 0x080fe20000410000ULL, 0x000000152a2a7220ULL, 0x080fe20000410000ULL,
0x000000152b2b7220ULL, 0x080fe20000410000ULL, 0x0000001526267220ULL, 0x080fe20000410000ULL,
0x0000001527277220ULL, 0x080fe20000410000ULL, 0x0000001522227220ULL, 0x080fe20000410000ULL,
0x0000001523237220ULL, 0x080fe20000410000ULL, 0x000000151e1e7220ULL, 0x080fe20000410000ULL,
0x000000151f1f7220ULL, 0x080fe20000410000ULL, 0x0000001512127220ULL, 0x080fe20000410000ULL,
0x0000001513137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x8000005214140221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL,
0x0000001400020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005117517221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x002fe40000015200ULL,
0xfffffff00b167812ULL, 0x000fc800078ec0ffULL, 0x0176a84d160075a7ULL, 0x000ea20008000148ULL,
0x0000000816367c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176a84d360075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034157816ULL, 0x000fe200000000ffULL,
0x0000020039147824ULL, 0x000fe200078e00ffULL, 0x000000070d547812ULL, 0x040fe400078ec0ffULL,
0x00000004ff4e7819ULL, 0x000fe4000001160dULL, 0x000000080d417812ULL, 0x000fe400078ec0ffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000040a507824ULL, 0x100fe200078e024eULL,
0x00000008544f7812ULL, 0x000fe200078ef80dULL, 0x00000004074e7824ULL, 0x000fe200078e024eULL,
0x0000005441157212ULL, 0x000fc400078efcffULL, 0xfffff80014147812ULL, 0x000fe200078ec0ffULL,
0x000000014f507824ULL, 0x040fe200078e0250ULL, 0x000000080a3b7c11ULL, 0x000fe2000f8e68ffULL,
0x000000084f177824ULL, 0x000fe400078e00ffULL, 0x0000000115167824ULL, 0x040fe400078e024eULL,
0x0000000815357824ULL, 0x000fe400078e00ffULL, 0x0000000814457c36ULL, 0x000fe20008000000ULL,
0xfffffff817147812ULL, 0x000fe200078ee250ULL, 0x000130003b427836ULL, 0x000fe20000000000ULL,
0xfffffff835177812ULL, 0x000fe200078ee216ULL, 0x0000000216347836ULL, 0x000fc40000000000ULL,
0x0000001014167824ULL, 0x000fe400078e0245ULL, 0x00000010173c7824ULL, 0x000fe200078e0242ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011000001614783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x088fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0xfffffff835357812ULL, 0x000fe200078ee234ULL, 0x000000084f4f7824ULL, 0x000fe200078e00ffULL,
0x0000001041417812ULL, 0x000fe200078efe54ULL, 0x0000000250507836ULL, 0x000fe40000000000ULL,
0x0000001035357824ULL, 0x000fe400078e0242ULL, 0x000000014e4e7824ULL, 0x000fe200078e0241ULL,
0xfffffff84f507812ULL, 0x000fc600078ee250ULL, 0x000000003534783bULL, 0x000f620000004200ULL,
0x000001003c537824ULL, 0x050fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001143dULL,
0x000001003d587824ULL, 0x040fe200078e00ffULL, 0x000088803d657816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x000088803c577816ULL, 0x000fe200000000ffULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff5b7819ULL, 0x000fe2000001143cULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x028fe40000011434ULL,
0x00008880345d7816ULL, 0x000fe200000000ffULL, 0x0000005300667306ULL, 0x0007e20000202400ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff557819ULL, 0x000fe40000011435ULL,
0x00008880355a7816ULL, 0x000fc400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000003d00677306ULL, 0x0009e20000202400ULL, 0x000001003e537824ULL, 0x048fe200078e00ffULL,
0x000088803e607816ULL, 0x000fe400000000ffULL, 0x000088803f617816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005700577306ULL, 0x000ee20000202400ULL,
0x00000100343d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001143eULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc4000001143fULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005300637306ULL, 0x0009e20000202400ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff477819ULL, 0x000fe40000011436ULL,
0x00000018ff4a7819ULL, 0x000fc60000011437ULL, 0x0000006500657306ULL, 0x000fe20000202400ULL,
0x0000010035537824ULL, 0x050fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005800687306ULL, 0x000f220000202400ULL,
0x00000018ff357819ULL, 0x000fce0000011435ULL, 0x0000003400597306ULL, 0x000bf00000202400ULL,
0x0000003c00647306ULL, 0x0007e20000202400ULL, 0x0000010037347824ULL, 0x024fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005b005b7306ULL, 0x000ea20000202400ULL,
0x000001003f3c7824ULL, 0x04afe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003500587306ULL, 0x0003e20000202400ULL,
0x00000018ff3f7819ULL, 0x000fce000001143fULL, 0x0000006000607306ULL, 0x000ee20000202400ULL,
0x000100003e357824ULL, 0x002fce00078e00ffULL, 0x00000034003e7306ULL, 0x0003f00000202400ULL,
0x0000006100617306ULL, 0x000fe20000202400ULL, 0x0000541057347816ULL, 0x002fe40000000066ULL,
0x00000018ff577819ULL, 0x000fc40000011435ULL, 0x0000541065357816ULL, 0x010fc60000000068ULL,
0x0000003c00627306ULL, 0x0003280000202400ULL, 0x000000341418723cULL, 0x000fe80000041818ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00008880363c7816ULL, 0x002fe400000000ffULL,
0x0000541064347816ULL, 0x004fc4000000005bULL, 0x0000541067357816ULL, 0x000fc6000000005cULL,
0x0000003d005e7306ULL, 0x0002a80000202400ULL, 0x00000034142c723cULL, 0x000fe8000004182cULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x00000100363d7824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000541060347816ULL, 0x008fc40000000063ULL,
0x0000541061357816ULL, 0x010fe40000000062ULL, 0x00000053005f7306ULL, 0x0002e20000202400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x000000341430723cULL, 0x000fe60000041830ULL, 0x0000005600567306ULL, 0x000f220000202400ULL,
0x0000888037537816ULL, 0x042fe200000000ffULL, 0x0001000037377824ULL, 0x000fc400078e00ffULL,
0x000054105d347816ULL, 0x004fc6000000005eULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000005500557306ULL, 0x000e620000202400ULL, 0x000054105a357816ULL, 0x008fce000000005fULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x000000341424723cULL, 0x000fee0000041824ULL,
0x0000004d004d7306ULL, 0x000fe20000202400ULL, 0x0000541059347816ULL, 0x010fe40000000056ULL,
0x0000541058357816ULL, 0x002fca0000000055ULL, 0x0000005700577306ULL, 0x000e640000202400ULL,
0x000000341420723cULL, 0x000fec0000041820ULL, 0x0000003f005c7306ULL, 0x000ea20000202400ULL,
0x0000000841357824ULL, 0x000fca00078e00ffULL, 0xfffffff835357812ULL, 0x000fe400078ee24eULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x00005410574c7816ULL, 0x002fe4000000004cULL,
0x000054105c4d7816ULL, 0x004fca000000004dULL, 0x0000003d003d7306ULL, 0x000e640000202400ULL,
0x0000004c1428723cULL, 0x000fec0000041828ULL, 0x0000004700477306ULL, 0x000fe20000202400ULL,
0x00000010504c7824ULL, 0x000fe200078e0245ULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000004a004a7306ULL, 0x000ff00000202400ULL, 0x0000005300537306ULL, 0x000e700000202400ULL,
0x0000003600367306ULL, 0x000ea20000202400ULL, 0x00005410533d7816ULL, 0x002fce000000003eULL,
0x0000003700377306ULL, 0x000e620000202400ULL, 0x0000003c141c723cULL, 0x000fe2000004181cULL,
0x0000541036367816ULL, 0x004fcc0000000047ULL, 0x00000010353c7824ULL, 0x000fe200078e0242ULL,
0x0000541037377816ULL, 0x002fce000000004aULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x011000004c14783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000000841357824ULL, 0x000fe400078e00ffULL, 0x000000024e4e7836ULL, 0x000fca0000000000ULL,
0xfffffff835357812ULL, 0x000fca00078ee24eULL, 0x0000001035357824ULL, 0x000fcc00078e0242ULL,
0x000000003534783bULL, 0x000f220000004200ULL, 0x00000018ff587819ULL, 0x008fe2000001143cULL,
0x000001003c4f7824ULL, 0x040fe200078e00ffULL, 0x000088803c557816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe2000001143dULL,
0x000001003d507824ULL, 0x040fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000088803d5e7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x00000018ff577819ULL, 0x000fe2000001143eULL,
0x0000004f00607306ULL, 0x0007e20000202400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff567819ULL, 0x000fe4000001143fULL, 0x000088803e5a7816ULL, 0x040fe400000000ffULL,
0x000088803f5b7816ULL, 0x000fe200000000ffULL, 0x0000003c005f7306ULL, 0x000be20000202400ULL,
0x000001003e4f7824ULL, 0x048fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x010fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc40000011435ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000005500557306ULL, 0x000ee20000202400ULL,
0x000001003f3c7824ULL, 0x062fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000888037657816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x00000018ff3f7819ULL, 0x000fc4000001143fULL, 0x00000018ff4a7819ULL, 0x000fe40000011437ULL,
0x00000018ff477819ULL, 0x000fc60000011436ULL, 0x0000005000637306ULL, 0x0003300000202400ULL,
0x0000003d00627306ULL, 0x000be20000202400ULL, 0x0000888034507816ULL, 0x002fce00000000ffULL,
0x0000004f005d7306ULL, 0x0003e20000202400ULL, 0x00000100343d7824ULL, 0x064fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00647306ULL, 0x0005e20000202400ULL, 0x00008880354f7816ULL, 0x002fe400000000ffULL,
0x00000018ff347819ULL, 0x000fca0000011434ULL, 0x0000005900597306ULL, 0x000e620000202400ULL,
0x00000100353c7824ULL, 0x044fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff547819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003e005c7306ULL, 0x000fe20000202400ULL, 0x00008880363c7816ULL, 0x000fce00000000ffULL,
0x0000003f00617306ULL, 0x000ff00000202400ULL, 0x00000034003e7306ULL, 0x0007f00000202400ULL,
0x00000035003f7306ULL, 0x0009e20000202400ULL, 0x0000541055347816ULL, 0x008fe20000000060ULL,
0x000000ffff557224ULL, 0x000fcc00078e0065ULL, 0x0000005a005a7306ULL, 0x000ea20000202400ULL,
0x000054105e357816ULL, 0x010fe20000000063ULL, 0x00000100375e7824ULL, 0x040fe400078e00ffULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000005b005b7306ULL, 0x000ee20000202400ULL, 0x000000341418723cULL, 0x000fee0000041818ULL,
0x000054105f347816ULL, 0x000fe20000000058ULL, 0x0000005700577306ULL, 0x000f220000202400ULL,
0x0000541062357816ULL, 0x002fce0000000059ULL, 0x0000005600567306ULL, 0x000e620000202400ULL,
0x00000034142c723cULL, 0x000fee000004182cULL, 0x0001000036357824ULL, 0x000fe200078e00ffULL,
0x0000003d00537306ULL, 0x000be20000202400ULL, 0x000054105a347816ULL, 0x004fc6000000005dULL,
0x00000018ff587819ULL, 0x000fe40000011435ULL, 0x000054105b357816ULL, 0x008fe40000000064ULL,
0x0000005000507306ULL, 0x000ea20000202400ULL, 0x00000100363d7824ULL, 0x020fc800078e00ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004f004f7306ULL, 0x000fe80000202400ULL, 0x000054105c347816ULL, 0x010fe40000000057ULL,
0x0000541061357816ULL, 0x002fe40000000056ULL, 0x0000005400547306ULL, 0x000e620000202400ULL,
0x00000018ff567819ULL, 0x000fc80000011437ULL, 0x000000341428723cULL, 0x000fe60000041828ULL,
0x0000004d004d7306ULL, 0x000ee80000202400ULL, 0x0000541050347816ULL, 0x004fe40000000053ULL,
0x000054104f357816ULL, 0x002fe40000000054ULL, 0x0000004e004e7306ULL, 0x000e6a0000202400ULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x000054103e3e7816ULL, 0x008fc4000000004dULL,
0x0000003c003c7306ULL, 0x000fe80000202400ULL, 0x0000000239347824ULL, 0x000fe200078e00ffULL,
0x000000080a357c11ULL, 0x000fc6000f8e18ffULL, 0x0000003d003d7306ULL, 0x000ea20000202400ULL,
0x000054103f3f7816ULL, 0x002fe4000000004eULL, 0xfffffff834377812ULL, 0x000fca00078ec0ffULL,
0x0000004700477306ULL, 0x000fe20000202400ULL, 0x0000003e1420723cULL, 0x000fe20000041820ULL,
0x000054103c3c7816ULL, 0x004fcc000000003dULL, 0x0000004a004a7306ULL, 0x000fe20000202400ULL,
0x00000001ff3e7424ULL, 0x000fc800078e00ffULL, 0x0176c83e353479a7ULL, 0x000e66000850003fULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x0176883e37ff79a7ULL, 0x0005ee0008500008ULL,
0x0000005e00367306ULL, 0x000ef00000202400ULL, 0x0000005800587306ULL, 0x000f220000202400ULL,
0x00005410553d7816ULL, 0x008fce0000000036ULL, 0x0000005600597306ULL, 0x000ee20000202400ULL,
0x0000003c141c723cULL, 0x000fe2000004181cULL, 0x0000541058587816ULL, 0x010fe40000000047ULL,
0x0000541059597816ULL, 0x008fce000000004aULL, 0x000000581410723cULL, 0x000fee0000041810ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x00000035040075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x006fdc0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000008044157836ULL, 0x000fe20000000000ULL, 0x0000920000057ab9ULL, 0x000fc60000000800ULL,
0x0000000508357c24ULL, 0x000fe2000f8e0215ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x000000150e147248ULL, 0x000fe20007fe0000ULL, 0x0000001007177824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe2000001160dULL, 0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000114147824ULL, 0x000fe400078e0a15ULL, 0x0000000416367836ULL, 0x000fe40000000000ULL,
0x0000000117347824ULL, 0x000fe200078e0216ULL, 0x0000001417147248ULL, 0x000fe20007fe0000ULL,
0x0000000816377836ULL, 0x000fc40000000000ULL, 0x0000000134157824ULL, 0x000fe400078e020dULL,
0x0000000114147824ULL, 0x000fe400078e0a17ULL, 0x00000008343c7824ULL, 0x000fe400078e00ffULL,
0x0000000c163e7836ULL, 0x000fe20000000000ULL, 0x000000143600720cULL, 0x080fe20003f66070ULL,
0x0000000117367824ULL, 0x040fe200078e0236ULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x00000001174a7824ULL, 0x000fe200078e023eULL, 0xfffffff83c3d7812ULL, 0x000fe200078ee215ULL,
0x0000000136167824ULL, 0x040fe200078e020dULL, 0x000000143700720cULL, 0x080fe20003f46070ULL,
0x00000008363f7824ULL, 0x000fe200078e00ffULL, 0x000000143e00720cULL, 0x000fe20003f06070ULL,
0x0000000134157824ULL, 0x000fc400078e0235ULL, 0x00000001173c7824ULL, 0x000fe200078e0237ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL, 0x0000008015147825ULL, 0x000fc800078e00ffULL,
0x0000000136167824ULL, 0x100fe200078e0235ULL, 0x0000004314147212ULL, 0x080fe200078efcffULL,
0x000000013c347824ULL, 0x040fe400078e0235ULL, 0x000000013c377824ULL, 0x040fe200078e020dULL,
0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL, 0x000000083c3c7824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000b15157c10ULL, 0x000fe4000affe4ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee237ULL, 0x000000014a367824ULL, 0x000fe200078e0235ULL,
0x0000004316167212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004334347212ULL, 0x080fe400078efcffULL, 0x0000000b17177c10ULL, 0x000fe2000affe4ffULL,
0x000000014a3c7824ULL, 0x000fe200078e020dULL, 0x0000004336367212ULL, 0x000fe200078efcffULL,
0x000000084a4d7824ULL, 0x000fe200078e00ffULL, 0x0000000a34347c10ULL, 0x000fe2000ffbe0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0242ULL, 0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0242ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee23cULL,
0x0000001047477824ULL, 0x100fe200078e0242ULL, 0x0000000b35357c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000e101c46ULL,
0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL, 0x000000104d4d7824ULL, 0x000fc400078e0242ULL,
0x00000000163f7faeULL, 0x0003e8000d901c46ULL, 0x0000000034477faeULL, 0x0003e8000d101c46ULL,
0x00000000364d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001007147824ULL, 0x000fe200078e00ffULL, 0x00008e00000a7ab9ULL, 0x000fc80000000a00ULL,
0x000000140d167211ULL, 0x000fca00078fe8ffULL, 0x0000000116157824ULL, 0x040fe400078e020dULL,
0x0000000816367824ULL, 0x040fe400078e00ffULL, 0x0000000416347836ULL, 0x000fe40000000000ULL,
0x0000000c163e7836ULL, 0x000fe20000000000ULL, 0xfffffff8363d7812ULL, 0x000fe200078ee215ULL,
0x00000008163c7836ULL, 0x000fe40000000000ULL, 0x0000000116147824ULL, 0x000fc400078e0235ULL,
0x0000000134367824ULL, 0x040fe400078e0235ULL, 0x0000000134177824ULL, 0x040fe400078e020dULL,
0x00000008344a7824ULL, 0x000fe400078e00ffULL, 0x000000013e347824ULL, 0x040fe400078e0235ULL,
0x000000013e377824ULL, 0x000fe200078e020dULL, 0xfffffff84a3f7812ULL, 0x000fe200078ee217ULL,
0x000000013c167824ULL, 0x000fc400078e0235ULL, 0x000000083e3e7824ULL, 0x000fe400078e00ffULL,
0x000000013c357824ULL, 0x040fe400078e020dULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e4d7812ULL, 0x000fe200078ee237ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee235ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004314147212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004336367212ULL, 0x080fe400078efcffULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004316167212ULL, 0x080fe400078efcffULL,
0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0242ULL,
0x0000004334347212ULL, 0x000fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e0242ULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000001047477824ULL, 0x100fe200078e0242ULL,
0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e0242ULL,
0x0000000a34347c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x0000000b37377c10ULL, 0x000fc400097fe4ffULL,
0x0000000b17177c10ULL, 0x000fe400087fe4ffULL, 0x0000000b35357c10ULL, 0x000fe20009ffe4ffULL,
0x00000000363f7faeULL, 0x0003e8000b901c46ULL, 0x0000000016477faeULL, 0x0003e8000b901c46ULL,
0x00000000344d7faeULL, 0x0003e4000b901c46ULL, 0x000000100a147824ULL, 0x002fe200078e00ffULL,
0xffffffe00b167812ULL, 0x000fe200078ec0ffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x0000000814567c36ULL, 0x000fe20008000000ULL, 0x0000001014157812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000560572caULL, 0x000fe400000e0000ULL,
0x0000000815157c10ULL, 0x000fe4000fffe016ULL, 0x000000080b167812ULL, 0x000fca00078ec0ffULL,
0x0000000116157824ULL, 0x000fc800078e0215ULL, 0x000176a805057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0176a834565679a7ULL, 0x0002a4000850003fULL, 0x01762834153479a7ULL, 0x0022e4000850003fULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x017628354b0075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017628354b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002039147824ULL, 0x000fe400078e00ffULL, 0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000008015147810ULL, 0x000fc80007ffe014ULL, 0x0000001446147210ULL, 0x000fca0007ffe043ULL,
0x0170000014157984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0006e20000000800ULL,
0x000000521500720bULL, 0x002fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff16167812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x0000000106147836ULL, 0x000fe20000000000ULL, 0x000000521500720bULL, 0x0c0fe40003f14000ULL,
0x0000005215367209ULL, 0x000fe40007810000ULL, 0x000000391400720cULL, 0x000fd20003f45270ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x000000083914ac11ULL, 0x000fc8000f8e38ffULL,
0x000000144637a210ULL, 0x000fe40007ffe043ULL, 0x0000991035147816ULL, 0x000fc600000000ffULL,
0x017400363700a388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000003652527221ULL, 0x000fe20000010000ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b52527820ULL, 0x000fcc0000410000ULL, 0x0000005200527308ULL, 0x000e680000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff377819ULL, 0x000fca000001160dULL,
0x00001f3752147589ULL, 0x002e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000005251517220ULL, 0x002fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d377811ULL, 0x000fca00078ff0ffULL,
0x00001f3752147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007806035ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x000fd400078e0036ULL,
0x8000003615150221ULL, 0x100fe20000010000ULL, 0x000000ffff520224ULL, 0x000fe200078e0036ULL,
0x00007610ff340816ULL, 0x000fe40000000034ULL, 0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL,
0x0000001500020308ULL, 0x000e640000000800ULL, 0x0000000217170220ULL, 0x002fce0000410000ULL,
0x0000005117517221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x000fe40000015200ULL,
0xfffffff00b177812ULL, 0x000fc800078ec0ffULL, 0x0176b049170075a7ULL, 0x000e620008000148ULL,
0x0000000817377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b049370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000239537824ULL, 0x040fe200078e00ffULL,
0x0000991034347816ULL, 0x000fe200000000ffULL, 0x00000004394e7824ULL, 0x000fe200078e00ffULL,
0x000000070d167812ULL, 0x040fe200078ec0ffULL, 0x000140003b487836ULL, 0x000fe20000000000ULL,
0x000000080d157812ULL, 0x000fe400078ec0ffULL, 0x0000000453147812ULL, 0x000fe400078ec0ffULL,
0x0000001615357212ULL, 0x000fe200078efcffULL, 0x000000ffff157224ULL, 0x000fe200078e0034ULL,
0x0000000816177812ULL, 0x000fc400078ef80dULL, 0x000000140d147211ULL, 0x000fe200078fe0ffULL,
0x0000000835497824ULL, 0x000fe200078e00ffULL, 0x000000ff1500720cULL, 0x000fe40003f05270ULL,
0x000000044e4e7812ULL, 0x000fe200078ec0ffULL, 0x00000001174a7824ULL, 0x040fe400078e0214ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x0000004e0d4e7211ULL, 0x000fc800078fe0ffULL,
0xfffffff817507812ULL, 0x000fe200078ee24aULL, 0x0000000135347824ULL, 0x000fc800078e024eULL,
0x0000001050507824ULL, 0x000fe200078e0245ULL, 0xfffffff849497812ULL, 0x000fe200078ee234ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011800005014783bULL, 0x0022e20000000200ULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x00000000493c783bULL, 0x000f220000004200ULL, 0x0000000835367824ULL, 0x000fe400078e00ffULL,
0x00000002344f7836ULL, 0x000fca0000000000ULL, 0xfffffff8364f7812ULL, 0x000fca00078ee24fULL,
0x000000104f347824ULL, 0x000fcc00078e0248ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x00000018ff637819ULL, 0x010fe2000001143cULL, 0x000001003c587824ULL, 0x040fe200078e00ffULL,
0x000088803c667816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe2000001143dULL, 0x000001003d597824ULL, 0x040fe200078e00ffULL,
0x000088803d6b7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x00000018ff587819ULL, 0x000fc40000011458ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803e647816ULL, 0x000fe200000000ffULL,
0x0000003c006a7306ULL, 0x0009e20000202400ULL, 0x000088803f657816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x022fe40000011434ULL, 0x00000018ff477819ULL, 0x000fc40000011435ULL,
0x00008880345b7816ULL, 0x000fe200000000ffULL, 0x0000005800697306ULL, 0x0003620000202400ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001143eULL,
0x00000018ff5d7819ULL, 0x000fe2000001143fULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x000001003e587824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc40000011436ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000059006e7306ULL, 0x0003220000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff547819ULL, 0x000fca0000011437ULL,
0x0000003d006c7306ULL, 0x0009e20000202400ULL, 0x0000888035597816ULL, 0x002fce00000000ffULL,
0x0000003c00687306ULL, 0x0003e20000202400ULL, 0x00000100343d7824ULL, 0x054fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006300637306ULL, 0x000ea20000202400ULL, 0x00000100353c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001143cULL, 0x0000006100617306ULL, 0x000e620000202400ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880363c7816ULL, 0x000fca00000000ffULL,
0x0000005800677306ULL, 0x000ff00000202400ULL, 0x00000034005a7306ULL, 0x000bf00000202400ULL,
0x0000003500587306ULL, 0x0009e20000202400ULL, 0x0000541066347816ULL, 0x028fce0000000069ULL,
0x0000006400647306ULL, 0x000ee20000202400ULL, 0x000054106b357816ULL, 0x010fce000000006eULL,
0x0000006500657306ULL, 0x000f220000202400ULL, 0x000000341418723cULL, 0x000fee0000041818ULL,
0x000054106a347816ULL, 0x004fe20000000063ULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x000054106c357816ULL, 0x002fce0000000061ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x00000034142c723cULL, 0x000fee000004182cULL, 0x0000003e00627306ULL, 0x0002a20000202400ULL,
0x0000541064347816ULL, 0x008fe40000000067ULL, 0x0000541065357816ULL, 0x010fca0000000068ULL,
0x0000003f00607306ULL, 0x0007220000202400ULL, 0x00008880373e7816ULL, 0x042fe200000000ffULL,
0x000000341430723cULL, 0x000fec0000041830ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x00000100373f7824ULL, 0x048fe200078e00ffULL, 0x0000541062347816ULL, 0x004fe2000000005fULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000003d005c7306ULL, 0x0002a20000202400ULL, 0x0000541060357816ULL, 0x010fe4000000005dULL,
0x00000018ff377819ULL, 0x000fca0000011437ULL, 0x0000005900597306ULL, 0x000fe20000202400ULL,
0x00000100363d7824ULL, 0x042fe200078e00ffULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x000054105b347816ULL, 0x004fca000000005cULL, 0x0000005500557306ULL, 0x000ea20000202400ULL,
0x0000541059357816ULL, 0x002fce000000005eULL, 0x0000004700477306ULL, 0x000e620000202400ULL,
0x000000341424723cULL, 0x000fee0000041824ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x000054105a347816ULL, 0x004fe40000000055ULL, 0x0000541058357816ULL, 0x002fca0000000047ULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x0000000841477824ULL, 0x040fe200078e00ffULL,
0x000000341420723cULL, 0x000fec0000041820ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x0000000141347824ULL, 0x000fe200078e024eULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0xfffffff847477812ULL, 0x000fce00078ee234ULL,
0x0000003e003e7306ULL, 0x000ff00000202400ULL, 0x0000003f003f7306ULL, 0x000e700000202400ULL,
0x0000003600367306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000003700377306ULL, 0x000e620000202400ULL, 0x0000003c141c723cULL, 0x000fe2000004181cULL,
0x0000541036367816ULL, 0x004fcc000000004dULL, 0x00000010473c7824ULL, 0x000fe200078e0248ULL,
0x0000541037377816ULL, 0x002fce0000000054ULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x011800004c14783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000000841367824ULL, 0x000fe200078e00ffULL, 0xfffffff853537812ULL, 0x000fe200078ec0ffULL,
0x00000002344d7836ULL, 0x000fca0000000000ULL, 0xfffffff8364d7812ULL, 0x000fca00078ee24dULL,
0x000000104d347824ULL, 0x000fcc00078e0248ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x00000018ff637819ULL, 0x008fe2000001143cULL, 0x000001003c597824ULL, 0x040fe200078e00ffULL,
0x000088803c667816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe2000001143dULL, 0x000001003d5a7824ULL, 0x040fe200078e00ffULL,
0x000088803d6b7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x00000018ff597819ULL, 0x000fc40000011459ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5f7819ULL, 0x000fe2000001143eULL,
0x0000003c006a7306ULL, 0x0007e20000202400ULL, 0x000088803e647816ULL, 0x000fe400000000ffULL,
0x00000018ff587819ULL, 0x010fe40000011434ULL, 0x00000018ff557819ULL, 0x000fc40000011435ULL,
0x00008880345b7816ULL, 0x000fe200000000ffULL, 0x0000005900697306ULL, 0x0009620000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x000088803f657816ULL, 0x040fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001143fULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x000001003e597824ULL, 0x050fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x002fc40000011436ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000005a006c7306ULL, 0x0002e20000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff547819ULL, 0x000fca0000011437ULL,
0x0000003d006d7306ULL, 0x0009e20000202400ULL, 0x00008880355a7816ULL, 0x002fce00000000ffULL,
0x0000003c00687306ULL, 0x0003e20000202400ULL, 0x00000100343d7824ULL, 0x050fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006300637306ULL, 0x000f220000202400ULL, 0x00000100353c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143cULL, 0x0000006200627306ULL, 0x000e620000202400ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880363c7816ULL, 0x000fca00000000ffULL,
0x0000005900677306ULL, 0x000ff00000202400ULL, 0x0000003e00607306ULL, 0x000ff00000202400ULL,
0x0000003400597306ULL, 0x000bf00000202400ULL, 0x00000035003e7306ULL, 0x0007e20000202400ULL,
0x0000541066347816ULL, 0x024fe20000000069ULL, 0x0000010037667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000006400647306ULL, 0x000ea20000202400ULL,
0x000054106b357816ULL, 0x008fce000000006cULL, 0x0000006500657306ULL, 0x000ee20000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x000054106a347816ULL, 0x010fe20000000063ULL,
0x0000005f005f7306ULL, 0x000f220000202400ULL, 0x000054106d357816ULL, 0x002fe20000000062ULL,
0x0001000037637824ULL, 0x000fca00078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x00000034142c723cULL, 0x000fee000004182cULL,
0x0000003f00617306ULL, 0x0003620000202400ULL, 0x0001000036357824ULL, 0x000fe200078e00ffULL,
0x0000541064347816ULL, 0x004fc80000000067ULL, 0x00000018ff627819ULL, 0x000fe40000011435ULL,
0x0000541065357816ULL, 0x008fe20000000068ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x00008880373f7816ULL, 0x002fca00000000ffULL, 0x000000341430723cULL, 0x000fe40000041830ULL,
0x0000003d005c7306ULL, 0x0002aa0000202400ULL, 0x0000541060347816ULL, 0x010fe4000000005fULL,
0x0000541061357816ULL, 0x020fe2000000005eULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x00000100363d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x0000005d005d7306ULL, 0x000e6c0000202400ULL,
0x000054105b347816ULL, 0x004fe4000000005cULL, 0x0000005800587306ULL, 0x000ea20000202400ULL,
0x000054105a357816ULL, 0x002fce000000005dULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x000000341424723cULL, 0x000fee0000041824ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541059347816ULL, 0x004fe40000000058ULL, 0x000054103e357816ULL, 0x002fca0000000055ULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x00000001ff3e7424ULL, 0x000fe200078e00ffULL,
0x000000341420723cULL, 0x000fec0000041820ULL, 0x0000003f003f7306ULL, 0x000fe20000202400ULL,
0x000000080a347c11ULL, 0x000fe4000f8e18ffULL, 0x000054103c3c7816ULL, 0x002fca000000003dULL,
0x0000006600367306ULL, 0x000e620000202400ULL, 0x0176c83e343479a7ULL, 0x000eae000850003fULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x0176903e53ff79a7ULL, 0x0007e20008500008ULL,
0x000054103f3d7816ULL, 0x002fcc0000000036ULL, 0x0000006200377306ULL, 0x000e620000202400ULL,
0x0000003c141c723cULL, 0x000fee000004181cULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541037367816ULL, 0x002fce000000004cULL, 0x0000006300637306ULL, 0x000e640000202400ULL,
0x0000541063377816ULL, 0x002fce0000000054ULL, 0x000000361410723cULL, 0x000fee0000041810ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x00000035040075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x00afdc0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000c044157836ULL, 0x000fe20000000000ULL, 0x0000920000057ab9ULL, 0x000fc60000000800ULL,
0x0000000508177c24ULL, 0x000fe2000f8e0215ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x000000150e147248ULL, 0x000fe20007fe0000ULL, 0x0000001007357824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe2000001160dULL, 0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000114147824ULL, 0x000fe400078e0a15ULL, 0x0000000135347824ULL, 0x000fe400078e0216ULL,
0x0000000416367836ULL, 0x000fe20000000000ULL, 0x0000001435147248ULL, 0x000fe20007fe0000ULL,
0x0000000134157824ULL, 0x000fc400078e020dULL, 0x00000008343c7824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fe400078e0a35ULL, 0x0000000816377836ULL, 0x000fe20000000000ULL,
0xfffffff83c3d7812ULL, 0x000fe200078ee215ULL, 0x0000000c163c7836ULL, 0x000fe20000000000ULL,
0x000000143600720cULL, 0x080fe20003f66070ULL, 0x0000000135367824ULL, 0x000fe200078e0236ULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x0000000134157824ULL, 0x000fe200078e0217ULL,
0x000000143700720cULL, 0x080fe20003f46070ULL, 0x0000000136167824ULL, 0x000fe200078e020dULL,
0x000000143c00720cULL, 0x000fe20003f06070ULL, 0x00000008363f7824ULL, 0x000fc400078e00ffULL,
0x0000008015147825ULL, 0x000fc600078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL,
0x0000000135347824ULL, 0x040fe200078e0237ULL, 0x0000004314147212ULL, 0x000fe200078efcffULL,
0x0000000136367824ULL, 0x000fe400078e0217ULL, 0x00000001353e7824ULL, 0x000fe200078e023cULL,
0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL, 0x0000000134357824ULL, 0x040fe400078e020dULL,
0x00000008343c7824ULL, 0x000fe200078e00ffULL, 0x0000000b15157c10ULL, 0x000fe2000affe4ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff83c537812ULL, 0x000fe200078ee235ULL,
0x0000000134167824ULL, 0x100fe200078e0217ULL, 0x0000004336367212ULL, 0x000fe200078efcffULL,
0x000000013e347824ULL, 0x000fe400078e0217ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000a36367c10ULL, 0x000fc6000ffbe0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x080fe400078efcffULL, 0x0000000b37377c10ULL, 0x000fe2000affe4ffULL,
0x000000013e3c7824ULL, 0x000fe200078e020dULL, 0x0000004334347212ULL, 0x000fe200078efcffULL,
0x000000083e557824ULL, 0x000fe200078e00ffULL, 0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0248ULL, 0x0000000a34347c10ULL, 0x000fe2000ffde0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0248ULL, 0xfffffff855557812ULL, 0x000fe200078ee23cULL,
0x0000001053537824ULL, 0x100fe200078e0248ULL, 0x0000000b17177c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000e101c46ULL,
0x0000000b35357c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001055557824ULL, 0x000fc400078e0248ULL,
0x00000000363f7faeULL, 0x0003e8000d901c46ULL, 0x0000000016537faeULL, 0x0003e8000d101c46ULL,
0x0000000034557faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001007147824ULL, 0x000fe200078e00ffULL, 0x00008e00000a7ab9ULL, 0x000fc80000000a00ULL,
0x000000140d167211ULL, 0x000fca00078fe8ffULL, 0x0000000116157824ULL, 0x040fe400078e020dULL,
0x0000000816367824ULL, 0x040fe400078e00ffULL, 0x0000000416347836ULL, 0x000fe40000000000ULL,
0x00000008163c7836ULL, 0x000fe20000000000ULL, 0xfffffff8363d7812ULL, 0x000fe200078ee215ULL,
0x0000000c163e7836ULL, 0x000fe40000000000ULL, 0x0000000116147824ULL, 0x000fc400078e0217ULL,
0x0000000134167824ULL, 0x040fe400078e0217ULL, 0x0000000134357824ULL, 0x040fe400078e020dULL,
0x00000008344c7824ULL, 0x000fe400078e00ffULL, 0x000000013c347824ULL, 0x100fe400078e0217ULL,
0x000000013e367824ULL, 0x000fe200078e0217ULL, 0xfffffff84c3f7812ULL, 0x000fe200078ee235ULL,
0x000000013c177824ULL, 0x000fc400078e020dULL, 0x000000083c3c7824ULL, 0x000fe400078e00ffULL,
0x000000013e377824ULL, 0x040fe400078e020dULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c537812ULL, 0x000fe200078ee217ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff83e557812ULL, 0x000fe200078ee237ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004314147212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x080fe400078efcffULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004334347212ULL, 0x080fe400078efcffULL,
0x0000000a16167c10ULL, 0x000fe2000ff5e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0248ULL,
0x0000004336367212ULL, 0x000fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e0248ULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000001053537824ULL, 0x100fe200078e0248ULL,
0x0000000a34347c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001055557824ULL, 0x000fe200078e0248ULL,
0x0000000a36367c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x0000000b17177c10ULL, 0x000fc400097fe4ffULL,
0x0000000b35357c10ULL, 0x000fe400087fe4ffULL, 0x0000000b37377c10ULL, 0x000fe20009ffe4ffULL,
0x00000000163f7faeULL, 0x0003e8000b901c46ULL, 0x0000000034537faeULL, 0x0003e8000b901c46ULL,
0x0000000036557faeULL, 0x0003e4000b901c46ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000008ff157e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff00b547812ULL, 0x000fe200078ec0ffULL, 0x00000001ff167424ULL, 0x000fc600078e00ffULL,
0x000176a854547810ULL, 0x000fe40007ffe015ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000816545479a7ULL, 0x0002a4000850003fULL,
0x017648164b1679a7ULL, 0x0022e4000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0xffffffe00b347812ULL, 0x040fe400078ec0ffULL, 0x000000100b357812ULL, 0x040fe400078ec0ffULL,
0x000000080b367812ULL, 0x000fe400078ec0ffULL, 0x0000000835357c10ULL, 0x000fca000fffe034ULL,
0x00000001353d7824ULL, 0x000fc800078e0236ULL, 0x017648173d0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003414377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017648173d0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000002039147824ULL, 0x000fe400078e00ffULL, 0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000010015147810ULL, 0x000fc80007ffe014ULL, 0x0000001446147210ULL, 0x000fca0007ffe043ULL,
0x0170000014157984ULL, 0x000ee80000000800ULL, 0x0172000014177984ULL, 0x0009220000000800ULL,
0x000000521500720bULL, 0x008fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff16357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x016fea0003800000ULL,
0x0000000206147836ULL, 0x000fe20000000000ULL, 0x000000521500720bULL, 0x000fc80003f14000ULL,
0x000000391400720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000083916ac11ULL, 0x000fe4000f8e38ffULL, 0x000000521514a209ULL, 0x000fe40007810000ULL,
0x000000164637a210ULL, 0x000fe40007ffe043ULL, 0x0000991034167816ULL, 0x000fc600000000ffULL,
0x017400143700a388ULL, 0x0003e20000000800ULL, 0x000000ff1600720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005215377209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005237147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400167308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x000fca000001160dULL, 0x00001f3716147589ULL, 0x006e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001651517220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080d377811ULL, 0x000fca00078ff0ffULL, 0x00001f3716147589ULL, 0x002e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005215527209ULL, 0x000fd60007810000ULL, 0x8000005215150221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL,
0x0000001500020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005117517221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x002fe40000015200ULL,
0xfffffff00b177812ULL, 0x000fc800078ec0ffULL, 0x0176a857170075a7ULL, 0x000ea20008000148ULL,
0x0000000817377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176a857370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000080d147812ULL, 0x000fe400078ec0ffULL,
0x0000991034347816ULL, 0x000fe400000000ffULL, 0x0000000714157812ULL, 0x000fc600078ef80dULL,
0x000000ffff147224ULL, 0x000fe400078e0034ULL, 0x00000001154e7824ULL, 0x040fe400078e024eULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0x000000ff1400720cULL, 0x000fc80003f05270ULL,
0xfffffff815157812ULL, 0x000fca00078ee24eULL, 0x00000010153c7824ULL, 0x000fc800078e0242ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x012000005014783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0x000000104f347824ULL, 0x000fcc00078e0242ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x00000018ff5b7819ULL, 0x010fe2000001143cULL, 0x000001003c507824ULL, 0x042fe200078e00ffULL,
0x000088803c587816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001143dULL, 0x000001003d537824ULL, 0x040fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000088803d617816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc40000011453ULL,
0x00000018ff5a7819ULL, 0x000fe2000001143eULL, 0x0000005000637306ULL, 0x0003e20000202400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff597819ULL, 0x000fe4000001143fULL,
0x000088803e5d7816ULL, 0x040fe400000000ffULL, 0x000088803f5e7816ULL, 0x000fe200000000ffULL,
0x0000003c00627306ULL, 0x0009e20000202400ULL, 0x000001003e507824ULL, 0x042fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x020fe20000011434ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fc40000011435ULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005800587306ULL, 0x000e620000202400ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011436ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006100617306ULL, 0x000fe20000202400ULL, 0x00000018ff3f7819ULL, 0x000fc4000001143fULL,
0x00000018ff4e7819ULL, 0x000fe40000011437ULL, 0x0000888037687816ULL, 0x000fc600000000ffULL,
0x0000005300667306ULL, 0x0009700000202400ULL, 0x0000003d00657306ULL, 0x0003e20000202400ULL,
0x0000888034537816ULL, 0x010fce00000000ffULL, 0x0000005000607306ULL, 0x0009e20000202400ULL,
0x00000100343d7824ULL, 0x046fe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00677306ULL, 0x0003e20000202400ULL,
0x0000888035507816ULL, 0x010fe400000000ffULL, 0x00000018ff347819ULL, 0x000fca0000011434ULL,
0x0000005c005c7306ULL, 0x000ea20000202400ULL, 0x00000100353c7824ULL, 0x042fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe4000001143cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003e005f7306ULL, 0x000fe20000202400ULL,
0x00008880363c7816ULL, 0x000fce00000000ffULL, 0x0000003f00647306ULL, 0x000ff00000202400ULL,
0x00000034003f7306ULL, 0x0003f00000202400ULL, 0x00000035003e7306ULL, 0x000be20000202400ULL,
0x0000541058347816ULL, 0x002fe20000000063ULL, 0x000000ffff587224ULL, 0x000fcc00078e0068ULL,
0x0000005d005d7306ULL, 0x000e620000202400ULL, 0x0000541061357816ULL, 0x028fe20000000066ULL,
0x0000010037617824ULL, 0x040fe400078e00ffULL, 0x0001000037377824ULL, 0x000fc800078e00ffULL,
0x0000005e005e7306ULL, 0x000ee20000202400ULL, 0x000000341418723cULL, 0x000fe20000041818ULL,
0x00000018ff377819ULL, 0x000fcc0000011437ULL, 0x0000541062347816ULL, 0x000fe2000000005bULL,
0x0000005a005a7306ULL, 0x000f220000202400ULL, 0x0000541065357816ULL, 0x004fe4000000005cULL,
0x00000018ff5b7819ULL, 0x000fca0000011461ULL, 0x0000005900597306ULL, 0x000ea20000202400ULL,
0x00000034142c723cULL, 0x000fee000004182cULL, 0x0000003d00567306ULL, 0x000be20000202400ULL,
0x000054105d347816ULL, 0x002fe40000000060ULL, 0x000054105e357816ULL, 0x008fca0000000067ULL,
0x0000005300537306ULL, 0x000e620000202400ULL, 0x00000100363d7824ULL, 0x060fe200078e00ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005000507306ULL, 0x000fe20000202400ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x000054105f347816ULL, 0x010fe4000000005aULL,
0x0000541064357816ULL, 0x004fe40000000059ULL, 0x000000070d5a7812ULL, 0x000fe200078ec0ffULL,
0x0000005700577306ULL, 0x000ea60000202400ULL, 0x000000085a5a7812ULL, 0x000fe200078ef80dULL,
0x000000341428723cULL, 0x000fe80000041828ULL, 0x0000004c004c7306ULL, 0x000ee60000202400ULL,
0x0000541053347816ULL, 0x002fe20000000056ULL, 0x000000085a537824ULL, 0x000fe200078e00ffULL,
0x0000541050357816ULL, 0x004fc60000000057ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x000000024a507836ULL, 0x000fc60000000000ULL, 0x000000341424723cULL, 0x000fe80000041824ULL,
0x0000003d003d7306ULL, 0x000e660000202400ULL, 0x000054103f347816ULL, 0x008fe4000000004cULL,
0xfffffff8534c7812ULL, 0x000fc600078ee250ULL, 0x0000004f004f7306ULL, 0x000ea40000202400ULL,
0x000000104c457824ULL, 0x000fe200078e0245ULL, 0x000054103c3c7816ULL, 0x002fca000000003dULL,
0x0000004b004b7306ULL, 0x000fe20000202400ULL, 0x000054103e357816ULL, 0x004fce000000004fULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x000000341420723cULL, 0x000fee0000041820ULL,
0x0000005800587306ULL, 0x000ff00000202400ULL, 0x0000005b005b7306ULL, 0x000e700000202400ULL,
0x0000003600367306ULL, 0x000ea20000202400ULL, 0x00005410583d7816ULL, 0x002fce000000005bULL,
0x0000003700377306ULL, 0x000e620000202400ULL, 0x0000003c141c723cULL, 0x000fe2000004181cULL,
0x0000541036367816ULL, 0x004fcc000000004bULL, 0x00000010473c7824ULL, 0x000fe200078e0242ULL,
0x0000541037377816ULL, 0x002fce000000004eULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x012000004514783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x000000104d347824ULL, 0x000fcc00078e0242ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x00000018ff5c7819ULL, 0x008fe2000001143cULL, 0x000001003c4f7824ULL, 0x040fe200078e00ffULL,
0x000088803c5b7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001143dULL, 0x000001003d507824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000010037677824ULL, 0x010fe200078e00ffULL,
0x000088803d617816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x00000018ff577819ULL, 0x000fe2000001143fULL,
0x0000004f00667306ULL, 0x0007e20000202400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000088803f5e7816ULL, 0x000fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011434ULL,
0x00000018ff4e7819ULL, 0x000fe20000011435ULL, 0x0000003c005f7306ULL, 0x0009e20000202400ULL,
0x000001003e4f7824ULL, 0x008fe200078e00ffULL, 0x0000888034537816ULL, 0x000fc400000000ffULL,
0x000088803e5d7816ULL, 0x040fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000005b005b7306ULL, 0x000ee20000202400ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x002fe20000011436ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x0000006100617306ULL, 0x000fe20000202400ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff4b7819ULL, 0x000fc60000011437ULL, 0x0000005000687306ULL, 0x000e700000202400ULL,
0x0000003d00637306ULL, 0x0009f00000202400ULL, 0x0000004f00607306ULL, 0x000be20000202400ULL,
0x00000100343d7824ULL, 0x010fc400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00657306ULL, 0x0009e20000202400ULL,
0x00008880354f7816ULL, 0x024fe400000000ffULL, 0x00000018ff347819ULL, 0x000fca0000011434ULL,
0x0000005a005a7306ULL, 0x000ea20000202400ULL, 0x00000100353c7824ULL, 0x050fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001143cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003f00647306ULL, 0x000fe20000202400ULL,
0x00008880363c7816ULL, 0x000fce00000000ffULL, 0x0000003400507306ULL, 0x0007f00000202400ULL,
0x00000035003f7306ULL, 0x0003e20000202400ULL, 0x000054105b347816ULL, 0x008fe40000000066ULL,
0x00000018ff5b7819ULL, 0x000fca0000011467ULL, 0x0000005d005d7306ULL, 0x000ee20000202400ULL,
0x0000541061357816ULL, 0x002fce0000000068ULL, 0x0000005e005e7306ULL, 0x000e620000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x000054105f347816ULL, 0x000fe2000000005cULL,
0x0000005900597306ULL, 0x000fe20000202400ULL, 0x0000541063357816ULL, 0x004fce000000005aULL,
0x0000005700577306ULL, 0x000fe20000202400ULL, 0x00000034142c723cULL, 0x000fee000004182cULL,
0x0000003e00627306ULL, 0x0005220000202400ULL, 0x000054105d347816ULL, 0x008fe40000000060ULL,
0x000054105e357816ULL, 0x002fca0000000065ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x00008880373e7816ULL, 0x044fe200000000ffULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x0001000037377824ULL, 0x000fca00078e00ffULL, 0x0000003d00567306ULL, 0x0002a20000202400ULL,
0x0000541062347816ULL, 0x010fe40000000059ULL, 0x0000541064357816ULL, 0x000fe40000000057ULL,
0x00000018ff5a7819ULL, 0x000fe40000011437ULL, 0x0000000806377c11ULL, 0x000fe2000f8e18ffULL,
0x0000004f004f7306ULL, 0x000fe20000202400ULL, 0x00000100363d7824ULL, 0x042fe200078e00ffULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005800587306ULL, 0x000e620000202400ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000541053347816ULL, 0x004fca0000000056ULL,
0x0000004d004d7306ULL, 0x000ea20000202400ULL, 0x000054104f357816ULL, 0x002fce0000000058ULL,
0x0000004e004e7306ULL, 0x000e620000202400ULL, 0x000000341424723cULL, 0x000fee0000041824ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x0000541050347816ULL, 0x004fe4000000004dULL,
0x000054103f357816ULL, 0x002fca000000004eULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x00000001ff3f7424ULL, 0x000fe200078e00ffULL, 0x000000341420723cULL, 0x000fec0000041820ULL,
0x0000004500457306ULL, 0x000fe20000202400ULL, 0x0000003f043479a7ULL, 0x000ea2000850003fULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000004b004b7306ULL, 0x000fe20000202400ULL,
0x0176983f37ff79a7ULL, 0x0003ee000850003fULL, 0x0000003e003e7306ULL, 0x000ff00000202400ULL,
0x0000005b005b7306ULL, 0x000ef00000202400ULL, 0x0000003600367306ULL, 0x000f220000202400ULL,
0x000054103e3d7816ULL, 0x008fce000000005bULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x0000003c141c723cULL, 0x000fe2000004181cULL, 0x0000541036367816ULL, 0x010fe40000000045ULL,
0x000054105a377816ULL, 0x002fce000000004bULL, 0x000000361410723cULL, 0x000fee0000041810ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x00000035040075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fdc0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000105157836ULL, 0x000fca0000000000ULL, 0x0000000c1500720cULL, 0x000fda0003f06070ULL,
0x0000000400d40947ULL, 0x000fea0003800000ULL, 0x0000000205157836ULL, 0x000fe20000000000ULL,
0x0000920000057ab9ULL, 0x000fc80000000800ULL, 0x0000000c1500720cULL, 0x000fe20003f06070ULL,
0x0000010044157836ULL, 0x000fc80000000000ULL, 0x0000000508377c24ULL, 0x000fd0000f8e0215ULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x000000150e147248ULL, 0x000fe20007fe0000ULL,
0x0000001007177824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001160dULL,
0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000114147824ULL, 0x000fe400078e0a15ULL,
0x0000000117347824ULL, 0x000fe400078e0216ULL, 0x0000000416357836ULL, 0x000fe20000000000ULL,
0x0000001417147248ULL, 0x000fe20007fe0000ULL, 0x0000000134157824ULL, 0x000fc400078e020dULL,
0x0000000834367824ULL, 0x000fe400078e00ffULL, 0x0000000114147824ULL, 0x000fc600078e0a17ULL,
0xfffffff8363d7812ULL, 0x000fe200078ee215ULL, 0x0000000816157836ULL, 0x000fe20000000000ULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x0000000c16167836ULL, 0x000fe20000000000ULL,
0x000000143500720cULL, 0x080fe20003f66070ULL, 0x0000000117367824ULL, 0x000fe200078e0235ULL,
0x000000141500720cULL, 0x080fe20003f46070ULL, 0x00000001173c7824ULL, 0x040fe200078e0215ULL,
0x000000141600720cULL, 0x000fe20003f06070ULL, 0x00000001173e7824ULL, 0x000fe400078e0216ULL,
0x0000000136147824ULL, 0x000fc400078e020dULL, 0x00000008363f7824ULL, 0x000fe400078e00ffULL,
0x0000000134167824ULL, 0x100fe400078e0237ULL, 0x0000000136347824ULL, 0x000fe200078e0237ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL, 0x000000013c157824ULL, 0x040fe400078e020dULL,
0x000000083c447824ULL, 0x000fe400078e00ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff844457812ULL, 0x000fe200078ee215ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x000fc600078efcffULL, 0x000000013c147824ULL, 0x100fe200078e0237ULL,
0x0000004334347212ULL, 0x080fe200078efcffULL, 0x000000013e367824ULL, 0x000fe200078e0237ULL,
0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000a34347c10ULL, 0x000fe4000ffde0ffULL, 0x0000000b17177c10ULL, 0x000fe2000affe4ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004314147212ULL, 0x080fe400078efcffULL,
0x0000000b35357c10ULL, 0x000fe2000b7fe4ffULL, 0x000000013e3c7824ULL, 0x000fe200078e020dULL,
0x0000004336367212ULL, 0x000fe200078efcffULL, 0x000000083e4b7824ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0242ULL,
0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0242ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee23cULL, 0x0000001045457824ULL, 0x100fe200078e0242ULL,
0x0000000b15157c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000163d7faeULL, 0x0003e2000e101c46ULL, 0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL,
0x000000104b4b7824ULL, 0x000fc400078e0242ULL, 0x00000000343f7faeULL, 0x0003e8000d901c46ULL,
0x0000000014457faeULL, 0x0003e8000d101c46ULL, 0x00000000364b7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001007147824ULL, 0x000fe200078e00ffULL,
0x00008e00000a7ab9ULL, 0x000fc80000000a00ULL, 0x000000140d167211ULL, 0x000fca00078fe8ffULL,
0x0000000116157824ULL, 0x040fe400078e020dULL, 0x0000000816347824ULL, 0x040fe400078e00ffULL,
0x00000008163c7836ULL, 0x000fe40000000000ULL, 0x0000000c163e7836ULL, 0x000fe20000000000ULL,
0xfffffff8343d7812ULL, 0x000fe200078ee215ULL, 0x0000000416347836ULL, 0x000fe40000000000ULL,
0x0000000116147824ULL, 0x000fc400078e0237ULL, 0x0000000134167824ULL, 0x040fe400078e0237ULL,
0x0000000134177824ULL, 0x040fe400078e020dULL, 0x0000000834447824ULL, 0x000fe400078e00ffULL,
0x000000013c367824ULL, 0x100fe400078e0237ULL, 0x000000013e347824ULL, 0x040fe200078e0237ULL,
0xfffffff8443f7812ULL, 0x000fe200078ee217ULL, 0x000000013e377824ULL, 0x000fc400078e020dULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000013c357824ULL, 0x000fe200078e020dULL,
0x0000004314147212ULL, 0x080fe200078efcffULL, 0x000000083e3e7824ULL, 0x000fe400078e00ffULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0xfffffff83e4b7812ULL, 0x000fe400078ee237ULL,
0xfffffff83c457812ULL, 0x000fe200078ee235ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x000fc400078efcffULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004336367212ULL, 0x080fe400078efcffULL,
0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0242ULL,
0x0000004334347212ULL, 0x000fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e0242ULL,
0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001045457824ULL, 0x100fe200078e0242ULL,
0x0000000a34347c10ULL, 0x000fe2000ff7e0ffULL, 0x000000104b4b7824ULL, 0x000fe200078e0242ULL,
0x0000000b17177c10ULL, 0x000fe200087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x0000000b37377c10ULL, 0x000fc400097fe4ffULL,
0x0000000b35357c10ULL, 0x000fe20009ffe4ffULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036457faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000010a147812ULL, 0x000fe200078ec0ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000000806157c11ULL, 0x000fe2000f8e28ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000080b377812ULL, 0x000fc600078ec0ffULL,
0x0000001014167824ULL, 0x000fe200078e0215ULL, 0x000000080a147c11ULL, 0x000fe2000f8e20ffULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0176a834141479a7ULL, 0x0002a2000850003fULL,
0x0000000137377824ULL, 0x000fc800078e0216ULL, 0x01766834373479a7ULL, 0x0022e4000850003fULL,
0x000000ffff4d7224ULL, 0x006fce00078e0015ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x01766835370075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x00afea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x00000016143d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003d16167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01766835370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000806147c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff457224ULL, 0x000fe200078e0052ULL,
0x0000018043157810ULL, 0x000fca0007ffe014ULL, 0x0000000146157824ULL, 0x000fca00078e0215ULL,
0x0170000015177984ULL, 0x000e680000000800ULL, 0x0172000015167984ULL, 0x0004a20000000800ULL,
0x000000521700720bULL, 0x002fda0003f1d000ULL, 0x0000000000147806ULL, 0x000fc800000e0100ULL,
0x0000ffff14357812ULL, 0x000fda000780c0ffULL, 0x0000000000f88947ULL, 0x004fea0003800000ULL,
0x0000000306147836ULL, 0x000fe20000000000ULL, 0x000000521700720bULL, 0x0c0fe40003f14000ULL,
0x0000005217457209ULL, 0x000fe40007810000ULL, 0x000000391400720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000083914ac11ULL, 0x000fc8000f8e38ffULL,
0x000000144646a210ULL, 0x000fe40007ffe043ULL, 0x0000991034147816ULL, 0x000fc600000000ffULL,
0x017400454600a388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x0000005245147221ULL, 0x000fe20000010100ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400367308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff157819ULL, 0x000fca000001160dULL,
0x00001f1536147589ULL, 0x006e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000003651517220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d157811ULL, 0x000fca00078ff0ffULL,
0x00001f1536147589ULL, 0x002e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x0000001745170221ULL, 0x000fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL,
0x0000001700020308ULL, 0x000ea40000000800ULL, 0x0000000216160220ULL, 0x004fce0000410000ULL,
0x0000005116517221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x002fe40000015200ULL,
0xfffffff00b177812ULL, 0x000fe200078ec0ffULL, 0x0000000439167824ULL, 0x000fc600078e00ffULL,
0x0176b055170075a7ULL, 0x000ea20008000148ULL, 0x00000008173d7c36ULL, 0x000fe20008000000ULL,
0x0000000416167812ULL, 0x000fc800078ec0ffULL, 0x0000000216357812ULL, 0x000fe200078efcffULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b0553d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000070d377812ULL, 0x000fe400078ec0ffULL, 0x0000991034147816ULL, 0x000fe400000000ffULL,
0x0000000837157812ULL, 0x000fe400078ef80dULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000000806147c11ULL, 0x000fe2000f8e58ffULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x000000080d367812ULL, 0x000fc800078ec0ffULL, 0xfffffff815157812ULL, 0x000fca00078ee24aULL,
0x0000001015147824ULL, 0x000fe200078e0214ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff167819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000816347836ULL, 0x000fe20000000000ULL, 0x0000541000157816ULL, 0x000fca0000000000ULL,
0x00001f1615037589ULL, 0x0002a800000e0000ULL, 0x00001f3415007589ULL, 0x0002e400000e0000ULL,
0x012800001414783bULL, 0x002e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x086fe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x088fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000350d427211ULL, 0x000fe200078fe0ffULL, 0x00000000493c783bULL, 0x000f220000004200ULL,
0x0000003736377212ULL, 0x000fca00078efcffULL, 0x0000000137347824ULL, 0x040fe400078e0242ULL,
0x0000000837357824ULL, 0x000fca00078e00ffULL, 0xfffffff835357812ULL, 0x000fca00078ee234ULL,
0x0000001035357824ULL, 0x000fcc00078e0248ULL, 0x000000003534783bULL, 0x000f620000004200ULL,
0x000001003c497824ULL, 0x050fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe2000001143cULL,
0x000001003d4b7824ULL, 0x040fe200078e00ffULL, 0x000088803c4a7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe4000001143dULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x000088803d5a7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fc4000001143cULL, 0x00000018ff547819ULL, 0x000fe4000001143eULL,
0x000088803e3c7816ULL, 0x040fe200000000ffULL, 0x00000049005f7306ULL, 0x0009e20000202400ULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff527819ULL, 0x000fe4000001143fULL, 0x000088803f587816ULL, 0x000fe200000000ffULL,
0x0000004b00637306ULL, 0x000be20000202400ULL, 0x000001003e497824ULL, 0x050fe200078e00ffULL,
0x00000018ff467819ULL, 0x028fe20000011434ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00008880344e7816ULL, 0x000fc400000000ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000003d005c7306ULL, 0x0007e20000202400ULL, 0x000001003f4b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011435ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000888035507816ULL, 0x000fe400000000ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000004a004a7306ULL, 0x000ea20000202400ULL, 0x00000018ff3d7819ULL, 0x008fe2000001143eULL,
0x00000100343e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011436ULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000005a005a7306ULL, 0x000ee20000202400ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff447819ULL, 0x000fca0000011437ULL,
0x00000049005b7306ULL, 0x0009f00000202400ULL, 0x0000004b00617306ULL, 0x000fe20000202400ULL,
0x0000010035497824ULL, 0x050fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000034004b7306ULL, 0x0009e20000202400ULL,
0x00000018ff357819ULL, 0x000fce0000011435ULL, 0x0000005d005d7306ULL, 0x000f620000202400ULL,
0x0000010037347824ULL, 0x010fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011434ULL,
0x00000035004f7306ULL, 0x0007e20000202400ULL, 0x000054104a347816ULL, 0x004fce000000005fULL,
0x0000005500557306ULL, 0x000ea20000202400ULL, 0x000054105a357816ULL, 0x008fce0000000063ULL,
0x000000341418723cULL, 0x002fe20000041818ULL, 0x0000003f00597306ULL, 0x0003ec0000202400ULL,
0x0000000306357836ULL, 0x000fe20000000000ULL, 0x000054105d347816ULL, 0x020fe20000000056ULL,
0x0000003c003c7306ULL, 0x000ee20000202400ULL, 0x00000100363f7824ULL, 0x002fc400078e00ffULL,
0x00000008355d7c11ULL, 0x000fe4000f8e58ffULL, 0x000054105c357816ULL, 0x004fe40000000055ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000003e00537306ULL, 0x0003e20000202400ULL,
0x000000104c5d7824ULL, 0x000fc600078e025dULL, 0x00000034142c723cULL, 0x000fe8000004182cULL,
0x0000004900577306ULL, 0x0005e20000202400ULL, 0x00008880363e7816ULL, 0x042fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x000054103c347816ULL, 0x008fc8000000005bULL,
0x00000018ff5a7819ULL, 0x000fe20000011436ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000888037497816ULL, 0x044fe200000000ffULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011437ULL, 0x0000003d003d7306ULL, 0x000e700000202400ULL,
0x0000005200527306ULL, 0x000ea20000202400ULL, 0x000054103d3c7816ULL, 0x002fce0000000054ULL,
0x0000005800587306ULL, 0x000e620000202400ULL, 0x00005410593d7816ULL, 0x004fce0000000052ULL,
0x0000004e004e7306ULL, 0x000ea20000202400ULL, 0x0000003c1428723cULL, 0x000fe20000041828ULL,
0x0000541058357816ULL, 0x002fcc0000000061ULL, 0x0000005000507306ULL, 0x000e620000202400ULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x000054104e3c7816ULL, 0x004fcc0000000053ULL,
0x0000003e003e7306ULL, 0x000fe20000202400ULL, 0x011000005d34783bULL, 0x0004a20000000200ULL,
0x00005410503d7816ULL, 0x002fcc0000000057ULL, 0x0000003f003f7306ULL, 0x000e620000202400ULL,
0x0000003c1424723cULL, 0x000fee0000041824ULL, 0x0000004600467306ULL, 0x000ee20000202400ULL,
0x000054103e3e7816ULL, 0x002fce000000003fULL, 0x0000004800487306ULL, 0x000e620000202400ULL,
0x000054104b4e7816ULL, 0x008fce0000000046ULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x000054104f4f7816ULL, 0x002fce0000000048ULL, 0x0000004400447306ULL, 0x000fe20000202400ULL,
0x0000004e1420723cULL, 0x000fee0000041820ULL, 0x0000004900497306ULL, 0x000ff00000202400ULL,
0x0000005e004a7306ULL, 0x000e700000202400ULL, 0x0000005a00567306ULL, 0x000ee20000202400ULL,
0x00005410493f7816ULL, 0x002fce000000004aULL, 0x0000004c00557306ULL, 0x000e620000202400ULL,
0x0000003e141c723cULL, 0x000fe2000004181cULL, 0x0000541056567816ULL, 0x008fe40000000043ULL,
0x0000541055577816ULL, 0x002fce0000000044ULL, 0x000000561410723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x004fde0003800000ULL,
0x0000000334347232ULL, 0x080fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x000140003b3b7836ULL, 0x000fe40000000000ULL, 0x0000000141427824ULL, 0x000fe400078e0242ULL,
0x00000010473c7824ULL, 0x000fe400078e023bULL, 0x0000000841417824ULL, 0x000fe400078e00ffULL,
0x0000000105057836ULL, 0x000fe40000000000ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0xfffffff841427812ULL, 0x000fe200078ee242ULL, 0x000001003c147824ULL, 0x002fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe2000001143dULL, 0x000001003d157824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fc4000001143eULL, 0x00000018ff497819ULL, 0x000fe20000011414ULL,
0x0000001042147824ULL, 0x000fe200078e023bULL, 0x00000018ff567819ULL, 0x000fe20000011415ULL,
0x000001003e3b7824ULL, 0x040fe200078e00ffULL, 0x000088803d4b7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x000088803e4a7816ULL, 0x000fe200000000ffULL,
0x000000001414783bULL, 0x000e620000004200ULL, 0x000088803c487816ULL, 0x000fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000004900497306ULL, 0x000fe20000202400ULL, 0x00000018ff477819ULL, 0x000fe2000001143cULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fc4000001143eULL,
0x00000018ff447819ULL, 0x000fe4000001143fULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004800487306ULL, 0x000ea20000202400ULL, 0x000088803f4e7816ULL, 0x000fe400000000ffULL,
0x00000018ff3b7819ULL, 0x000fca000001143bULL, 0x0000004b004b7306ULL, 0x000ff00000202400ULL,
0x0000005600567306ULL, 0x000ef00000202400ULL, 0x0000003d00577306ULL, 0x0009e20000202400ULL,
0x00000018ff417819ULL, 0x002fe20000011414ULL, 0x00000100175c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fca0000011415ULL, 0x0000003e00507306ULL, 0x0003e20000202400ULL,
0x00008880144c7816ULL, 0x040fe200000000ffULL, 0x00000100143d7824ULL, 0x050fe200078e00ffULL,
0x0000888015537816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003c00527306ULL, 0x0009e20000202400ULL, 0x00000100153e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0001000015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0000004700477306ULL, 0x000e620000202400ULL, 0x000001003f3c7824ULL, 0x050fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004600467306ULL, 0x000f220000202400ULL, 0x00000018ff3f7819ULL, 0x000fce000001143fULL,
0x0000001400547306ULL, 0x0005f00000202400ULL, 0x00000015005d7306ULL, 0x0007e20000202400ULL,
0x0000541048147816ULL, 0x004fce0000000049ULL, 0x0000004300437306ULL, 0x000ea20000202400ULL,
0x000054104b157816ULL, 0x008fce0000000056ULL, 0x0000004400447306ULL, 0x000fe20000202400ULL,
0x000000143418723cULL, 0x000fee0000041818ULL, 0x0000003f00557306ULL, 0x0007620000202400ULL,
0x0001000016157824ULL, 0x000fe200078e00ffULL, 0x0000541052147816ULL, 0x002fc80000000047ULL,
0x00000018ff477819ULL, 0x000fe40000011415ULL, 0x0000541057157816ULL, 0x010fe20000000046ULL,
0x00000100163f7824ULL, 0x008fe200078e00ffULL, 0x0000003c005b7306ULL, 0x0003e80000202400ULL,
0x00000018ff5a7819ULL, 0x000fe2000001143fULL, 0x00000014342c723cULL, 0x000fe2000004182cULL,
0x00008880173f7816ULL, 0x000fc400000000ffULL, 0x0000003b004f7306ULL, 0x0007e20000202400ULL,
0x00000018ff3c7819ULL, 0x002fe20000011417ULL, 0x0001000017177824ULL, 0x000fe400078e00ffULL,
0x0000541050147816ULL, 0x004fe20000000043ULL, 0x00000001ff437424ULL, 0x000fe200078e00ffULL,
0x0000541055157816ULL, 0x020fe40000000044ULL, 0x0000003d00597306ULL, 0x0003e20000202400ULL,
0x00000018ff3b7819ULL, 0x008fe40000011416ULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x000000143428723cULL, 0x000fe20000041828ULL, 0x00000043041479a7ULL, 0x0004e4000850003fULL,
0x0000003e00587306ULL, 0x000fe20000202400ULL, 0x00008880163d7816ULL, 0x002fce00000000ffULL,
0x0000004a004a7306ULL, 0x000e620000202400ULL, 0x0000000806047c11ULL, 0x004fc8000f8e18ffULL,
0x0176a04304ff79a7ULL, 0x0005e6000850003fULL, 0x0000004e004e7306ULL, 0x000f220000202400ULL,
0x000054104a4a7816ULL, 0x002fce000000004fULL, 0x0000004100417306ULL, 0x000e620000202400ULL,
0x000054104e4b7816ULL, 0x010fce000000005bULL, 0x0000004200427306ULL, 0x000f220000202400ULL,
0x0000004a3430723cULL, 0x000fe20000041830ULL, 0x0000541054547816ULL, 0x002fcc0000000041ULL,
0x0000003b003b7306ULL, 0x000fe20000202400ULL, 0x000054105d557816ULL, 0x010fce0000000042ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000000543420723cULL, 0x000fee0000041820ULL,
0x0000004c004c7306ULL, 0x000e700000202400ULL, 0x0000005300537306ULL, 0x000f220000202400ULL,
0x000054104c527816ULL, 0x002fce0000000059ULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x0000541053537816ULL, 0x010fce0000000058ULL, 0x0000005a003e7306ULL, 0x000e620000202400ULL,
0x000000523424723cULL, 0x000fee0000041824ULL, 0x0000003f003f7306ULL, 0x000fe20000202400ULL,
0x000054103d3e7816ULL, 0x002fce000000003eULL, 0x0000005c00167306ULL, 0x000e700000202400ULL,
0x0000004700467306ULL, 0x000f220000202400ULL, 0x000054103f3f7816ULL, 0x002fce0000000016ULL,
0x0000001700177306ULL, 0x000e620000202400ULL, 0x0000003e341c723cULL, 0x000fe2000004181cULL,
0x0000541046467816ULL, 0x010fe4000000003bULL, 0x0000541017477816ULL, 0x002fce000000003cULL,
0x000000463410723cULL, 0x000fee0000041810ULL, 0x000000ffff347224ULL, 0x008fe200078e0015ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff7400149947ULL, 0x004fde000383ffffULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000051007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000a53000047802ULL, 0x000fce0000000f00ULL,
0x0000007c007c7944ULL, 0x006fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005100007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000051ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009600ff027b82ULL, 0x000f240000000a00ULL,
0x0000000602037981ULL, 0x010f22000c1e9900ULL, 0x0000000000057919ULL, 0x000f640000000000ULL,
0x00000002ff0b7819ULL, 0x022fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f0b00047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000001a051a7220ULL, 0x044fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000000202120723eULL, 0x000fe400000010ffULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000323332723eULL, 0x000fc400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x000000121312723eULL, 0x000fe400000010ffULL,
0x0000763226217816ULL, 0x000fe40000000022ULL, 0x000000ff0a00720cULL, 0x000fc40003f05270ULL,
0x00000002ff057819ULL, 0x008fe40000011600ULL, 0x0000000200027812ULL, 0x042fe400078ec0ffULL,
0x00000008000b7811ULL, 0x000fe200078ff0ffULL, 0x00000008050d7824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050e7824ULL, 0x000fe200078e00ffULL,
0x0000000b02037211ULL, 0x000fe200078ff8ffULL, 0x000000080b147824ULL, 0x000fe400078e00ffULL,
0x0000000204027836ULL, 0x000fc40000000000ULL, 0x00000008050b7824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x0000000404067836ULL, 0x000fe20000000000ULL,
0x0000000807037c11ULL, 0x000fe4000f8e60ffULL, 0xfffffff80d087812ULL, 0x000fe400078ee202ULL,
0xfffffff80b027812ULL, 0x000fe200078ee204ULL, 0x00000006040b7836ULL, 0x000fe20000000000ULL,
0xfffffff80d0c7812ULL, 0x000fe200078ee206ULL, 0x0000000800047824ULL, 0x000fc400078e00ffULL,
0x000008000a057824ULL, 0x000fe200078e0203ULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee20bULL,
0x00000008040b7812ULL, 0x000fe200078ec0ffULL, 0x0000001002067824ULL, 0x100fe200078e0205ULL,
0x000000181902723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x0000002c2d04723eULL, 0x000fe200000010ffULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000002a2b19723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x0000541002167816ULL, 0x100fe20000000004ULL, 0x0000000106067824ULL, 0x000fe200078e020bULL,
0x0000763202177816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x000000303102723eULL, 0x000fe200000010ffULL, 0x000000010b147824ULL, 0x000fe200078e0214ULL,
0x000000282904723eULL, 0x000fe200000010ffULL, 0x000000010b087824ULL, 0x000fe200078e0208ULL,
0x000000242505723eULL, 0x000fe200000010ffULL, 0x000000010b0c7824ULL, 0x040fe200078e020cULL,
0x0000001606007388ULL, 0x0003e20000000a00ULL, 0x000000010b0b7824ULL, 0x000fe200078e020eULL,
0x00000010110e723eULL, 0x000fc400000010ffULL, 0x0000541005107816ULL, 0x140fe40000000020ULL,
0x0000763205117816ULL, 0x000fe40000000020ULL, 0x0000541032187816ULL, 0x140fe40000000019ULL,
0x0000763232197816ULL, 0x000fe40000000019ULL, 0x0000541002167816ULL, 0x142fe40000000004ULL,
0x0000763202177816ULL, 0x000fc40000000004ULL, 0x0000001a1b02723eULL, 0x000fe400000010ffULL,
0x0000002e2f04723eULL, 0x000fe200000010ffULL, 0x0000001608007388ULL, 0x000fe20000000a00ULL,
0x0000541026207816ULL, 0x000fc60000000022ULL, 0x000000100c007388ULL, 0x0003e40000000a00ULL,
0x000054101c107816ULL, 0x142fe4000000000eULL, 0x000076321c117816ULL, 0x000fca000000000eULL,
0x000000100b007388ULL, 0x0003e40000000a00ULL, 0x0000541002107816ULL, 0x142fe40000000004ULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x0000000109027824ULL, 0x000fe200078e0200ULL,
0x000076321e097816ULL, 0x000fc60000000012ULL, 0x0000001014007388ULL, 0x000fe20000000a00ULL,
0x0000001002047824ULL, 0x000fe400078e0203ULL, 0x000000ff00027306ULL, 0x000e620000202400ULL,
0x0004001808007388ULL, 0x0007e80000000a00ULL, 0x000400200c007388ULL, 0x000fe20000000a00ULL,
0x000054101e087816ULL, 0x008fca0000000012ULL, 0x000400080b007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000004107984ULL, 0x000e680000000c00ULL,
0x0004000004187984ULL, 0x000ee80000000c00ULL, 0x0008000004147984ULL, 0x000f280000000c00ULL,
0x000c0000041c7984ULL, 0x000f620000000c00ULL, 0x0000001302137230ULL, 0x002fc40000200800ULL,
0x0000001202127230ULL, 0x040fe40000200800ULL, 0x0000001102117230ULL, 0x040fe40000200800ULL,
0x0000001002107230ULL, 0x040fe40000200800ULL, 0x0000001b021b7230ULL, 0x048fe40000200800ULL,
0x0000001a021a7230ULL, 0x040fe40000200800ULL, 0x0000001902197230ULL, 0x000fc40000200800ULL,
0x0000001802027230ULL, 0x000fe40000200800ULL, 0x0000001713137230ULL, 0x010fe40000200000ULL,
0x0000001612127230ULL, 0x000fe40000200000ULL, 0x0000001511117230ULL, 0x000fe40000200000ULL,
0x0000001410107230ULL, 0x000fe40000200000ULL, 0x0000001f1b1b7230ULL, 0x024fc40000200000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000200000ULL, 0x0000001004007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000200000ULL, 0x0000001c02187230ULL, 0x000fca0000200000ULL,
0x0004001804007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff097819ULL, 0x000fe20000011600ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x000000380900720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00008600ff107b82ULL, 0x002e620000000800ULL,
0x0000000109027824ULL, 0x000fe200078e0200ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0x00000007000e7812ULL, 0x000fc600078ec0ffULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x00000008070d7824ULL, 0x000fe400078e020eULL, 0x0ffffff805027812ULL, 0x000fe200078ef800ULL,
0xffffffffff057424ULL, 0x000fc800078e00ffULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x000000103a027824ULL, 0x000fc600078e0209ULL, 0x0000000004087984ULL, 0x0004e20000000c00ULL,
0x0000001005127219ULL, 0x082fe400000006ffULL, 0x0000001040407219ULL, 0x000fe400000006ffULL,
0x0000001202057212ULL, 0x000fe400078e30ffULL, 0x00000010ff067219ULL, 0x000fe20000011602ULL,
0x000000040f027c24ULL, 0x000fe4000f8e02ffULL, 0x0000000140057824ULL, 0x000fc800078e0205ULL,
0x0000000f06057224ULL, 0x000fe400078e0205ULL, 0x0000002000067836ULL, 0x000fc60000000000ULL,
0x0000000502057210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff117819ULL, 0x000fc60000011606ULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x004fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f440cULL, 0x000000381100720cULL, 0x000fe20003f06070ULL,
0x000000100d047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e0211ULL,
0x000000103a117824ULL, 0x000fe400078e0211ULL, 0x00000040000c7836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000001211057212ULL, 0x000fe400078e30ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000001004087824ULL, 0x000fe200078e0203ULL, 0x00000010ff047219ULL, 0x000fe20000011611ULL,
0x0000000140057824ULL, 0x000fe200078e0205ULL, 0x00000003ff117819ULL, 0x000fe2000001160cULL,
0x00000008070d7824ULL, 0x000fe400078e0206ULL, 0x0000000008087984ULL, 0x000e620000000c00ULL,
0x0000000f04057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f440eULL, 0x000000381100720cULL, 0x000fe20003f06070ULL,
0x000000100d047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e0211ULL,
0x000000103a117824ULL, 0x000fe400078e0211ULL, 0x0000006000007836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x0000001211057212ULL, 0x000fe400078e30ffULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x00000010ff047219ULL, 0x000fe20000011611ULL,
0x0000000140057824ULL, 0x000fe200078e0205ULL, 0x00000003ff117819ULL, 0x000fe20000011600ULL,
0x00000008070d7824ULL, 0x000fe200078e020cULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000f04057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000100067824ULL, 0x002fc800078e0211ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f440eULL,
0x000000381100720cULL, 0x000fe20003f06070ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x00000007060d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff80d067812ULL, 0x000fe200078ef800ULL,
0x0000000804007986ULL, 0x0043ec000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x000000103a117824ULL, 0x000fc600078e0211ULL, 0x0000000006087984ULL, 0x002e620000000c00ULL,
0x0000000807077824ULL, 0x000fe200078e0200ULL, 0x0000001211037212ULL, 0x000fe400078e30ffULL,
0x00000010ff047219ULL, 0x000fc60000011611ULL, 0x0000000140037824ULL, 0x000fc800078e0203ULL,
0x0000000f04037224ULL, 0x000fca00078e0203ULL, 0x0000000302037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fc600080f4404ULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009600ff0a7b82ULL, 0x000e620000000a00ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x0000000211117824ULL, 0x000fe200078e00ffULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x000000060a057981ULL, 0x002322000c1e9900ULL, 0x00000001ff027424ULL, 0x000fe400078e00ffULL,
0x0000004039077824ULL, 0x000fe400078e00ffULL, 0x0000000911407224ULL, 0x000fe400078e0240ULL,
0x01760002ff0279a7ULL, 0x000ea40008500008ULL, 0x0000000440067c24ULL, 0x000fe2000f8e0207ULL,
0x0000000c00240947ULL, 0x002fec0003800000ULL, 0x00000003ff197819ULL, 0x000fe2000001160dULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x000000070e187248ULL, 0x000fc60007fe0000ULL,
0x00000004190b7836ULL, 0x000fe40000000000ULL, 0x0000000819137836ULL, 0x000fe40000000000ULL,
0x000000010b087824ULL, 0x040fe400078e020dULL, 0x000000080b0f7824ULL, 0x000fe400078e00ffULL,
0x0000000118187824ULL, 0x000fe400078e0a07ULL, 0x0000000113097824ULL, 0x040fe200078e020dULL,
0xfffffff80f227812ULL, 0x000fe200078ee208ULL, 0x0000000813247824ULL, 0x000fe200078e00ffULL,
0x000000180b00720cULL, 0x000fe20003fa6070ULL, 0x00000001060a7824ULL, 0x000fc400078e020bULL,
0x0000000106087824ULL, 0x000fe200078e0219ULL, 0xfffffff824247812ULL, 0x000fe200078ee209ULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000700a167812ULL, 0x000fc600078ef804ULL, 0x0000001019117836ULL, 0x000fe20000000000ULL,
0x0000007008147812ULL, 0x000fe200078ef804ULL, 0x0000000c191b7836ULL, 0x000fe20000000000ULL,
0x0000000416167c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000111087824ULL, 0x040fe200078e020dULL,
0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x000000050b177c10ULL, 0x000fe20008ffe4ffULL, 0x00000001060a7824ULL, 0x040fe200078e021bULL,
0x000000181b00720cULL, 0x080fe20003f46070ULL, 0x0000001819257836ULL, 0x000fe20000000000ULL,
0xfffffff815287812ULL, 0x000fe200078ee208ULL, 0x0000000106087824ULL, 0x000fe200078e0213ULL,
0x0000000509157c10ULL, 0x000fe200087fe4ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000181100720cULL, 0x000fc40003f06070ULL, 0x000000181300720cULL, 0x000fe20003f26070ULL,
0x00000001061e7824ULL, 0x000fe200078e0225ULL, 0x000000700a1a7812ULL, 0x000fe200078ef804ULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0x000000041a1a7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x00000070081c7812ULL, 0x000fc600078ef804ULL,
0x0000000106117824ULL, 0x000fe200078e0211ULL, 0x000000701e087812ULL, 0x000fe200078ef804ULL,
0x0000001419217836ULL, 0x000fe20000000000ULL, 0x000000041c1c7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000011b0f7824ULL, 0x140fe400078e020dULL, 0x000000081b267824ULL, 0x000fe200078e00ffULL,
0x000000050b1b7c10ULL, 0x000fe2000a7fe4ffULL, 0x00000001191e7824ULL, 0x000fe200078e020dULL,
0x0000000408087c10ULL, 0x000fe2000ff9e0ffULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fc400078ee20fULL, 0x00000005091d7c10ULL, 0x000fe20009ffe4ffULL,
0x0000000106127824ULL, 0x000fe200078e0221ULL, 0x00000008390f7c11ULL, 0x000fe2000f8e70ffULL,
0x0000001c19297836ULL, 0x000fe20000000000ULL, 0x000000051f097c10ULL, 0x000fe2000a7fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000071e207812ULL, 0x000fe400078ec0ffULL,
0x0000007010107812ULL, 0x000fe200078ef804ULL, 0x000010000f0f7836ULL, 0x000fe20000000000ULL,
0x000000181900720cULL, 0x000fe20003f86070ULL, 0x00000028192f7836ULL, 0x000fe20000000000ULL,
0x0ffffff820207812ULL, 0x000fe200078ef80dULL, 0x00000020192b7836ULL, 0x000fe20000000000ULL,
0x0000000410107c10ULL, 0x000fe2000ff7e0ffULL, 0x00000001211e7824ULL, 0x000fe200078e020dULL,
0x00000070120a7812ULL, 0x000fe200078ef804ULL, 0x0000001020237824ULL, 0x000fe200078e020fULL,
0x0000000511117c10ULL, 0x000fe20009ffe4ffULL, 0x0000000106127824ULL, 0x000fe200078e0229ULL,
0x000000040a0a7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000125277824ULL, 0x000fc400078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014237faeULL, 0x0003e2000e101c46ULL,
0x00000005130b7c10ULL, 0x000fe20009ffe4ffULL, 0x00000008252c7824ULL, 0x000fe200078e00ffULL,
0x000000182100720cULL, 0x0c0fe20003f66070ULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x000000182500720cULL, 0x000fe20003f86070ULL, 0x0000000106257824ULL, 0x000fe200078e022fULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee227ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff8212a7812ULL, 0x000fc600078ee21eULL, 0x00000001061f7824ULL, 0x000fe200078e022bULL,
0x0000007012127812ULL, 0x000fe200078ef804ULL, 0x00000024192d7836ULL, 0x000fe40000000000ULL,
0x0000001022237824ULL, 0x002fe200078e020fULL, 0x0000000412127c10ULL, 0x000fe2000ffde0ffULL,
0x0000008025147825ULL, 0x000fc600078e00ffULL, 0x0000000016237faeULL, 0x0003e2000e901c46ULL,
0x0000001024257824ULL, 0x000fe200078e020fULL, 0x0000000513137c10ULL, 0x000fe2000b7fe4ffULL,
0x000000801f1e7825ULL, 0x000fe200078e00ffULL, 0x000000182900720cULL, 0x080fe40003fa6070ULL,
0x000000001c257faeULL, 0x0007e2000c901c46ULL, 0x0000000106207824ULL, 0x000fe200078e022dULL,
0x000000701e1e7812ULL, 0x000fe200078ef804ULL, 0x000000012b247824ULL, 0x040fe200078e020dULL,
0x000000182b00720cULL, 0x000fe20003f26070ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000041e1e7c10ULL, 0x000fc4000ffde0ffULL, 0x0000007014147812ULL, 0x000fe200078ef804ULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000007020207812ULL, 0x000fe200078ef804ULL,
0x0000002c19317836ULL, 0x000fe20000000000ULL, 0x000000051f1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001026237824ULL, 0x002fe200078e020fULL, 0xfffffff82b247812ULL, 0x000fe200078ee224ULL,
0x0000000129227824ULL, 0x040fe200078e020dULL, 0x0000000420207c10ULL, 0x000fe2000ffde0ffULL,
0x00000010281d7824ULL, 0x008fe200078e020fULL, 0x000000001a237faeULL, 0x0003e2000d101c46ULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x000000182d00720cULL, 0x040fe20003f46070ULL,
0x0000000106167824ULL, 0x000fe200078e0231ULL, 0x00000000101d7faeULL, 0x0007e2000c101c46ULL,
0x00000030192b7836ULL, 0x000fe20000000000ULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x000000012d267824ULL, 0x000fe200078e020dULL, 0x0000000521217c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000414147c10ULL, 0x000fc6000ffde0ffULL,
0x000000102a1b7824ULL, 0x102fe200078e020fULL, 0x0000007016167812ULL, 0x000fe200078ef804ULL,
0x000000102c237824ULL, 0x000fe200078e020fULL, 0x0000000515157c10ULL, 0x000fe2000b7fe4ffULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x000000000a1b7faeULL, 0x0003e2000d901c46ULL,
0x0000000106107824ULL, 0x008fe200078e022bULL, 0x0000000416167c10ULL, 0x000fe2000ffde0ffULL,
0x0000001022257824ULL, 0x100fe200078e020fULL, 0x0000000008237faeULL, 0x0007e2000e101c46ULL,
0xfffffff82d267812ULL, 0x000fe200078ee226ULL, 0x00000034191d7836ULL, 0x000fe20000000000ULL,
0x0000000517177c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001024277824ULL, 0x100fe200078e020fULL,
0x0000000012257faeULL, 0x000be2000e901c46ULL, 0x0000001026297824ULL, 0x000fe200078e020fULL,
0x000000182f00720cULL, 0x080fe20003fa6070ULL, 0x00000038191b7836ULL, 0x002fe20000000000ULL,
0x000000001e277faeULL, 0x0003e2000c901c46ULL, 0x0000003c192d7836ULL, 0x000fe20000000000ULL,
0x000000183100720cULL, 0x080fe20003f86070ULL, 0x0000008010087825ULL, 0x008fe200078e00ffULL,
0x0000000020297faeULL, 0x0007e2000d101c46ULL, 0x000000182b00720cULL, 0x000fc40003f66070ULL,
0x00000001060a7824ULL, 0x000fe200078e021dULL, 0x0000007008107812ULL, 0x000fe200078ef804ULL,
0x000000012f117824ULL, 0x100fe200078e020dULL, 0x000000181d00720cULL, 0x080fe20003f46070ULL,
0x000000082f127824ULL, 0x024fe200078e00ffULL, 0x0000000410107c10ULL, 0x000fe2000ffde0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000181b00720cULL, 0x080fe40003f26070ULL,
0x000000182d00720cULL, 0x000fe20003f06070ULL, 0x0000000131087824ULL, 0x140fe200078e020dULL,
0xfffffff812187812ULL, 0x000fe200078ee211ULL, 0x0000000831317824ULL, 0x000fe200078e00ffULL,
0x0000000509117c10ULL, 0x000fe2000b7fe4ffULL, 0x000000012b097824ULL, 0x040fe200078e020dULL,
0x000000700a127812ULL, 0x000fe200078ef804ULL, 0x000000082b1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8311a7812ULL, 0x000fe200078ee208ULL, 0x00000001060a7824ULL, 0x000fe200078e021bULL,
0x0000000412127c10ULL, 0x000fe2000ffde0ffULL, 0x000000011d197824ULL, 0x000fe200078e020dULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x000000800a087825ULL, 0x000fe200078e00ffULL,
0x000000050b137c10ULL, 0x000fc6000b7fe4ffULL, 0x00000001060a7824ULL, 0x000fe200078e022dULL,
0x0000007008087812ULL, 0x000fe200078ef804ULL, 0x000000081d1e7824ULL, 0x002fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000408087c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff81e067812ULL, 0x000fe200078ee219ULL, 0x000000011b1d7824ULL, 0x140fe200078e020dULL,
0x000000700a047812ULL, 0x000fe200078ef804ULL, 0x000000081b207824ULL, 0x008fe200078e00ffULL,
0x0000000509097c10ULL, 0x000fe2000b7fe4ffULL, 0x000000012d0d7824ULL, 0x040fe200078e020dULL,
0x00000004040a7c10ULL, 0x000fe2000ffde0ffULL, 0x000000082d227824ULL, 0x000fe200078e00ffULL,
0xfffffff8201e7812ULL, 0x000fe200078ee21dULL, 0x000000101a197824ULL, 0x100fe200078e020fULL,
0x000000050b0b7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000101c1b7824ULL, 0x100fe200078e020fULL,
0xfffffff822207812ULL, 0x000fe200078ee20dULL, 0x00000010180d7824ULL, 0x000fc400078e020fULL,
0x00000010061d7824ULL, 0x100fe400078e020fULL, 0x000000101e1f7824ULL, 0x100fe200078e020fULL,
0x00000000140d7faeULL, 0x0003e2000e901c46ULL, 0x00000010200f7824ULL, 0x000fc600078e020fULL,
0x0000000016197faeULL, 0x0003e8000e101c46ULL, 0x00000000101b7faeULL, 0x0003e8000d901c46ULL,
0x00000000121d7faeULL, 0x0003e8000d101c46ULL, 0x00000000081f7faeULL, 0x0003e8000c901c46ULL,
0x000000000a0f7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d47947ULL, 0x000fea0003800000ULL,
0x000000040d0b7811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000c0d117811ULL, 0x040fe400078fe8ffULL, 0x000000140d157811ULL, 0x000fe200078fe8ffULL,
0x000000010b087824ULL, 0x100fe200078e020dULL, 0x000000100d147811ULL, 0x000fe200078fe8ffULL,
0x000000080b097824ULL, 0x000fe200078e00ffULL, 0x0000001c0d197811ULL, 0x000fe200078fe8ffULL,
0x0000000811167824ULL, 0x000fe200078e00ffULL, 0x000000080d0f7811ULL, 0x000fe200078fe8ffULL,
0x0000000115107824ULL, 0x100fe200078e020dULL, 0xfffffff809127812ULL, 0x000fe200078ee208ULL,
0x0000000111097824ULL, 0x100fe200078e020dULL, 0x000000240d1c7811ULL, 0x000fe200078fe8ffULL,
0x0000000815217824ULL, 0x000fe200078e00ffULL, 0x000000200d1a7811ULL, 0x040fe200078fe8ffULL,
0x00000001140a7824ULL, 0x140fe200078e020dULL, 0xfffffff8161d7812ULL, 0x000fe200078ee209ULL,
0x00000008141f7824ULL, 0x000fe200078e00ffULL, 0x0000002c0d297811ULL, 0x000fe200078fe8ffULL,
0x0000000119097824ULL, 0x140fe200078e020dULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x00000008191e7824ULL, 0x000fe200078e00ffULL, 0x000000180d177811ULL, 0x000fe200078fe8ffULL,
0x000000010f087824ULL, 0x140fe200078e020dULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL,
0x000000080f1b7824ULL, 0x000fe200078e00ffULL, 0x000000340d2f7811ULL, 0x040fe200078fe8ffULL,
0x000000011c107824ULL, 0x140fe200078e020dULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL,
0x000000081c257824ULL, 0x000fe200078e00ffULL, 0x000000300d2d7811ULL, 0x000fe200078fe8ffULL,
0x000000011a0a7824ULL, 0x140fe200078e020dULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x000000081a137824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee210ULL,
0x0000000129097824ULL, 0x100fe200078e020dULL, 0x000000280d207811ULL, 0x000fe200078fe8ffULL,
0x0000000829167824ULL, 0x000fe200078e00ffULL, 0xfffffff813227812ULL, 0x000fe200078ee20aULL,
0x0000000117087824ULL, 0x100fe200078e020dULL, 0x0000003c0d327811ULL, 0x000fe200078fe8ffULL,
0x0000000817237824ULL, 0x000fe200078e00ffULL, 0xfffffff8162b7812ULL, 0x000fe200078ee209ULL,
0x000000012f107824ULL, 0x100fe200078e020dULL, 0x0000000d0d097211ULL, 0x000fe200078fe8ffULL,
0x000000082f317824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee208ULL,
0x000000012d0a7824ULL, 0x000fc400078e020dULL, 0x000000082d137824ULL, 0x000fe200078e00ffULL,
0xfffffff831307812ULL, 0x000fe200078ee210ULL, 0x0000000120087824ULL, 0x040fe200078e020dULL,
0x000000380d317811ULL, 0x000fe200078fe8ffULL, 0x0000000820277824ULL, 0x000fe200078e00ffULL,
0xfffffff8132e7812ULL, 0x000fe200078ee20aULL, 0x0000000106107824ULL, 0x040fe200078e020fULL,
0x00000007090a7812ULL, 0x000fe200078ec0ffULL, 0x0000000106137824ULL, 0x040fe200078e0211ULL,
0xfffffff827277812ULL, 0x000fe200078ee208ULL, 0x0000000106267824ULL, 0x040fe200078e021aULL,
0x000000060d087211ULL, 0x000fe200078fe8ffULL, 0x0000000106287824ULL, 0x040fe200078e021cULL,
0x0ffffff80a0f7812ULL, 0x000fe200078ef80dULL, 0x00000001062a7824ULL, 0x040fe200078e0220ULL,
0x00000008390a7c11ULL, 0x000fe2000f8e70ffULL, 0x00000001060b7824ULL, 0x000fc400078e020bULL,
0x0000000106147824ULL, 0x040fe400078e0214ULL, 0x0000000106167824ULL, 0x040fe400078e0215ULL,
0x0000000106187824ULL, 0x040fe400078e0217ULL, 0x0000000106247824ULL, 0x040fe400078e0219ULL,
0x00000001062c7824ULL, 0x040fe400078e0229ULL, 0x0000000106207824ULL, 0x000fc400078e022dULL,
0x00000001061c7824ULL, 0x040fe400078e022fULL, 0x00000001061a7824ULL, 0x040fe400078e0231ULL,
0x0000000131117824ULL, 0x100fe400078e020dULL, 0x0000000106067824ULL, 0x000fe400078e0232ULL,
0x00000001320d7824ULL, 0x040fe400078e020dULL, 0x0000000832327824ULL, 0x000fc400078e00ffULL,
0x0000000831347824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffff832177812ULL, 0x000fe400078ee20dULL, 0xfffffff834157812ULL, 0x000fe200078ee211ULL,
0x000010000a327836ULL, 0x000fe20000000000ULL, 0x0000007008087812ULL, 0x000fe200078ef804ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000408087c10ULL, 0x000fe2000ff1e0ffULL,
0x000000100f0d7824ULL, 0x100fe200078e0232ULL, 0x0000007010107812ULL, 0x000fe200078ef804ULL,
0x00000010120f7824ULL, 0x000fe200078e0232ULL, 0x0000000509097c10ULL, 0x000fe200087fe4ffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x0000000410107c10ULL, 0x000fc6000ff1e0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fe200078ef804ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080d7faeULL, 0x0003e2000b901c46ULL,
0x0000000511117c10ULL, 0x000fe200087fe4ffULL, 0x0000001017457824ULL, 0x100fe200078e0232ULL,
0x000000700a0a7812ULL, 0x000fe200078ef804ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000412127c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040a0a7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001015437824ULL, 0x100fe200078e0232ULL, 0x0000007016167812ULL, 0x000fe200078ef804ULL,
0x0000001025377824ULL, 0x000fe200078e0232ULL, 0x0000000513137c10ULL, 0x000fe200087fe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000416167c10ULL, 0x000fc4000ff1e0ffULL,
0x000000050b0b7c10ULL, 0x000fe20008ffe4ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000007014147812ULL, 0x000fe400078ef804ULL, 0x0000000517177c10ULL, 0x000fe200087fe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000414147c10ULL, 0x000fe2000ff3e0ffULL,
0x000000000a0f7faeULL, 0x0003e4000b901c46ULL, 0x00000010273b7824ULL, 0x100fe200078e0232ULL,
0x0000007018187812ULL, 0x000fe200078ef804ULL, 0x000000102e3f7824ULL, 0x000fe200078e0232ULL,
0x00000070242e7812ULL, 0x000fe200078ef804ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000418187c10ULL, 0x000fc4000ff5e0ffULL, 0x000000042e2e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000102b3d7824ULL, 0x000fe200078e0232ULL, 0x0000000515157c10ULL, 0x000fe20008ffe4ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x00000005252f7c10ULL, 0x000fe400087fe4ffULL,
0x0000000519197c10ULL, 0x000fe200097fe4ffULL, 0x000000802a2a7825ULL, 0x000fc800078e00ffULL,
0x0000001030417824ULL, 0x100fe200078e0232ULL, 0x0000007026307812ULL, 0x000fe200078ef804ULL,
0x000000101b1b7824ULL, 0x100fe200078e0232ULL, 0x000000702a347812ULL, 0x000fe200078ef804ULL,
0x000000101d1d7824ULL, 0x100fe200078e0232ULL, 0x0000000430307c10ULL, 0x000fe2000ff3e0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0232ULL, 0x0000000434347c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0232ULL, 0x0000000527317c10ULL, 0x000fe20008ffe4ffULL,
0x0000001023237824ULL, 0x100fe200078e0232ULL, 0x000000052b357c10ULL, 0x000fe200097fe4ffULL,
0x000000101e1e7824ULL, 0x100fe200078e0232ULL, 0x00000000101b7faeULL, 0x0003e2000b901c46ULL,
0x0000001022227824ULL, 0x000fe200078e0232ULL, 0x0000007028327812ULL, 0x000fe200078ef804ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x00000000121d7faeULL, 0x0003e4000b901c46ULL,
0x0000000432327c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008020247825ULL, 0x000fe200078e00ffULL,
0x000000702c2c7812ULL, 0x000fe200078ef804ULL, 0x00000000141f7faeULL, 0x0003e2000b901c46ULL,
0x0000000529337c10ULL, 0x000fe200087fe4ffULL, 0x000000801c267825ULL, 0x000fe200078e00ffULL,
0x000000042c2c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000016217faeULL, 0x0003e2000b901c46ULL,
0x0000007024247812ULL, 0x000fe200078ef804ULL, 0x000000801a287825ULL, 0x000fe200078e00ffULL,
0x0000007026267812ULL, 0x000fe200078ef804ULL, 0x0000000018237faeULL, 0x0003e2000b901c46ULL,
0x000000052d2d7c10ULL, 0x000fe200087fe4ffULL, 0x00000080062a7825ULL, 0x000fe200078e00ffULL,
0x0000007028287812ULL, 0x000fe200078ef804ULL, 0x000000002e1e7faeULL, 0x0003e2000b901c46ULL,
0x0000000424247c10ULL, 0x000fc4000ff1e0ffULL, 0x000000702a047812ULL, 0x000fe200078ef804ULL,
0x0000000030227faeULL, 0x0003e2000b901c46ULL, 0x0000000426267c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000428287c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000032377faeULL, 0x0003e2000b901c46ULL,
0x00000004042a7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000525257c10ULL, 0x000fe200087fe4ffULL,
0x00000000343b7faeULL, 0x0003e2000b901c46ULL, 0x0000000527277c10ULL, 0x000fc40008ffe4ffULL,
0x0000000529297c10ULL, 0x000fe200097fe4ffULL, 0x000000002c3d7faeULL, 0x0003e2000b901c46ULL,
0x000000052b2b7c10ULL, 0x000fc60009ffe4ffULL, 0x00000000243f7faeULL, 0x0003e8000b901c46ULL,
0x0000000026417faeULL, 0x0003e8000b901c46ULL, 0x0000000028437faeULL, 0x0003e8000b901c46ULL,
0x000000002a457faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fce0000015200ULL, 0x01760003ff0075a7ULL, 0x004e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff067224ULL, 0x000fce00078e00ffULL,
0x000000100600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001140bULL,
0x0000000d04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000204047819ULL, 0x000fc8000000120bULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000106067836ULL, 0x000fce0000000000ULL,
0x01760003ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x00000001ff0a7424ULL, 0x000fe400078e00ffULL,
0x0000002039027824ULL, 0x002fca00078e0202ULL, 0x00000003ff037819ULL, 0x000fc80000011602ULL,
0x1ffffffe03097812ULL, 0x000fe400078ec0ffULL, 0x0000000f02037812ULL, 0x000fc600078ec0ffULL,
0x0000000102097824ULL, 0x000fe400078e0209ULL, 0x0000001003047824ULL, 0x000fe400078e00ffULL,
0x0000000109027836ULL, 0x000fe20000000000ULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x0000001003037824ULL, 0x000fc600078e00ffULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x000000f004097812ULL, 0x000fe400078ee209ULL, 0x000000f003027812ULL, 0x000fe400078ee202ULL,
0x0000000809097c11ULL, 0x000fe4000f8e20ffULL, 0x0000000802027c11ULL, 0x000fc6000f8e20ffULL,
0x0000000009147984ULL, 0x000e680000000c00ULL, 0x0000000002107984ULL, 0x000ea20000000c00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fc400078e0017ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff167224ULL, 0x000fe400078e0011ULL, 0x000000ffff177224ULL, 0x000fe200078e0013ULL,
0x0000001809007388ULL, 0x0003e80000000c00ULL, 0x0000001402007388ULL, 0x0003e20000000c00ULL,
0x0176000aff0a79a7ULL, 0x000ea40008500008ULL, 0x0000000000027805ULL, 0x002fce0000015200ULL,
0x0176000bff0075a7ULL, 0x004e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x00000008020d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e03ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011409ULL, 0x0000000d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000204047819ULL, 0x000fc80000001209ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x0176000bff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000010007027836ULL, 0x000fe20000000000ULL,
0x0000001f0a047890ULL, 0x000fe4000fffe03fULL, 0x8000000a0e087c36ULL, 0x000fe40008000000ULL,
0x3db504f305047820ULL, 0x010fe20000410000ULL, 0x0000000839057c11ULL, 0x040fe2000f8e18ffULL,
0x000000043f047899ULL, 0x000fe20008011604ULL, 0x0000000839067c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000008ff087819ULL, 0x000fe20000011608ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0xffffffff0a057890ULL, 0x000fc4000fffe03fULL,
0x000000090a097890ULL, 0x000fe4000fffe03fULL, 0x0ffffffe04047892ULL, 0x000fd8000f8ec03fULL,
0x0000000207097836ULL, 0x004fe20000000000ULL, 0x00009200000a7ab9ULL, 0x000fe20000000800ULL,
0x000000010b0a7812ULL, 0x000fc600078e0cffULL, 0x0000000c0900720cULL, 0x000fe20003f06070ULL,
0x0000010007097824ULL, 0x000fc800078e0202ULL, 0x0000000a40127c24ULL, 0x000fd0000f8e0209ULL,
0x0000000c00308947ULL, 0x000fea0003800000ULL, 0x00000003ff207819ULL, 0x002fe20000011603ULL,
0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000090e107248ULL, 0x000fc60007fe0000ULL,
0x0000000820167836ULL, 0x000fe40000000000ULL, 0x0000000420147836ULL, 0x000fe40000000000ULL,
0x00000001160f7824ULL, 0x040fe400078e0203ULL, 0x00000008162c7824ULL, 0x000fe400078e00ffULL,
0x0000000110137824ULL, 0x000fe400078e0a09ULL, 0x00000001140d7824ULL, 0x040fe200078e0203ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20fULL, 0x00000008142a7824ULL, 0x040fe200078e00ffULL,
0x000000131400720cULL, 0x000fe20003fa6070ULL, 0x00000010030f7824ULL, 0x000fc400078e00ffULL,
0x0000000114147824ULL, 0x100fe200078e0212ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20dULL,
0x0000000120107824ULL, 0x000fe200078e0212ULL, 0x000000700f0f7812ULL, 0x000fe200078ec0ffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000f14147212ULL, 0x000fc600078efcffULL, 0x00000010201a7836ULL, 0x000fe20000000000ULL,
0x0000000a14147c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000c20187836ULL, 0x000fe20000000000ULL,
0x0000000f10107212ULL, 0x000fe200078efcffULL, 0x000000011a177824ULL, 0x140fe200078e0203ULL,
0x0000000b15157c10ULL, 0x000fe20008ffe4ffULL, 0x000000081a307824ULL, 0x000fe200078e00ffULL,
0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL, 0x00000001180d7824ULL, 0x000fe200078e0203ULL,
0x000000131600720cULL, 0x0c0fe20003f26070ULL, 0x0000000116167824ULL, 0x100fe200078e0212ULL,
0x000000131800720cULL, 0x0c0fe20003f46070ULL, 0x00000008182e7824ULL, 0x040fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee217ULL, 0x0000000118187824ULL, 0x000fe200078e0212ULL,
0x0000000b11117c10ULL, 0x000fe200087fe4ffULL, 0x0000001420267836ULL, 0x000fe20000000000ULL,
0x000000131a00720cULL, 0x000fe20003f06070ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fc400078ee20dULL, 0x00000008390d7c11ULL, 0x000fe2000f8e70ffULL,
0x000000011a1a7824ULL, 0x000fe200078e0212ULL, 0x0000000f16167212ULL, 0x000fe200078efcffULL,
0x0000001820287836ULL, 0x000fe40000000000ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fc6000ff7e0ffULL, 0x00000001261e7824ULL, 0x100fe200078e0212ULL,
0x0000000f181c7212ULL, 0x080fe200078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000b17177c10ULL, 0x000fe40009ffe4ffULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000128227824ULL, 0x000fe200078e0212ULL, 0x0000000f1a187212ULL, 0x080fe200078efcffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000b191d7c10ULL, 0x000fe4000a7fe4ffULL,
0x0000000a18187c10ULL, 0x000fe2000ff7e0ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000000f1e1a7212ULL, 0x000fc400078efcffULL, 0x0000000b1b197c10ULL, 0x000fe20009ffe4ffULL,
0x0000000120247824ULL, 0x000fe200078e0203ULL, 0x0000000f221e7212ULL, 0x000fe200078efcffULL,
0x000020000a217824ULL, 0x000fe200078e020dULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000126257824ULL, 0x140fe200078e0203ULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000826327824ULL, 0x000fe200078e00ffULL, 0x0000000b1f1b7c10ULL, 0x000fe2000a7fe4ffULL,
0x0000100021217836ULL, 0x000fe20000000000ULL, 0x0000000724247812ULL, 0x000fe200078ec0ffULL,
0x0000001c20367836ULL, 0x000fe20000000000ULL, 0x000000132000720cULL, 0x080fe20003f86070ULL,
0x00000028203c7836ULL, 0x000fe20000000000ULL, 0x0000000b231f7c10ULL, 0x000fe20009ffe4ffULL,
0x0000000136227824ULL, 0x000fe200078e0212ULL, 0x000000132600720cULL, 0x000fe20003f66070ULL,
0x0000002020387836ULL, 0x000fe20000000000ULL, 0x0ffffff824267812ULL, 0x000fe200078ef803ULL,
0x00000001282b7824ULL, 0x040fe200078e0203ULL, 0xfffffff832327812ULL, 0x000fe200078ee225ULL,
0x0000000828347824ULL, 0x000fc400078e00ffULL, 0x0000001026297824ULL, 0x000fe400078e0221ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe400078ee22bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010297faeULL, 0x0003e2000e101c46ULL,
0x000000132800720cULL, 0x000fe20003f86070ULL, 0x000000013c287824ULL, 0x100fe200078e0212ULL,
0x0000000f22227212ULL, 0x000fe200078efcffULL, 0x0000000138247824ULL, 0x000fe400078e0212ULL,
0x00000024203a7836ULL, 0x000fe20000000000ULL, 0x0000000a22227c10ULL, 0x000fe2000ffde0ffULL,
0x00000008362b7824ULL, 0x000fc400078e00ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000000b23237c10ULL, 0x000fc6000b7fe4ffULL, 0x0000008028107825ULL, 0x002fe200078e00ffULL,
0x0000000f24247212ULL, 0x000fc600078efcffULL, 0x0000000136287824ULL, 0x000fe200078e0203ULL,
0x0000000a24247c10ULL, 0x000fe2000ffde0ffULL, 0x000000102a297824ULL, 0x100fe200078e0221ULL,
0x0000000f10107212ULL, 0x000fe200078efcffULL, 0x000000013a267824ULL, 0x100fe200078e0212ULL,
0xfffffff82b287812ULL, 0x000fe200078ee228ULL, 0x000000102c2b7824ULL, 0x000fe200078e0221ULL,
0x0000000014297faeULL, 0x0003e2000e901c46ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x000000133600720cULL, 0x000fe40003fa6070ULL, 0x00000000162b7faeULL, 0x0005e2000c901c46ULL,
0x00000001382a7824ULL, 0x100fe200078e0203ULL, 0x0000000f26267212ULL, 0x000fe200078efcffULL,
0x00000008382d7824ULL, 0x000fe200078e00ffULL, 0x0000000b25257c10ULL, 0x000fe2000b7fe4ffULL,
0x0000002c20367836ULL, 0x000fe20000000000ULL, 0x0000000a26267c10ULL, 0x000fe2000ffde0ffULL,
0x000000013a2c7824ULL, 0x000fe200078e0203ULL, 0xfffffff82d2a7812ULL, 0x000fe200078ee22aULL,
0x0000000136147824ULL, 0x002fe200078e0212ULL, 0x0000000b27277c10ULL, 0x000fe2000b7fe4ffULL,
0x000000102e297824ULL, 0x100fe200078e0221ULL, 0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL,
0x00000010282b7824ULL, 0x104fe200078e0221ULL, 0x000000133800720cULL, 0x080fe20003f26070ULL,
0x0000003020287836ULL, 0x000fe20000000000ULL, 0x000000001c297faeULL, 0x0003e2000d101c46ULL,
0x0000001030177824ULL, 0x000fe200078e0221ULL, 0x0000000b11117c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000133a00720cULL, 0x000fc40003f46070ULL,
0x0000000018177faeULL, 0x0005e2000c101c46ULL, 0x000000102a2d7824ULL, 0x100fe200078e0221ULL,
0x0000000f14147212ULL, 0x000fe200078efcffULL, 0x0000000128167824ULL, 0x000fe400078e0212ULL,
0x00000034202a7836ULL, 0x000fe20000000000ULL, 0x0000000a14147c10ULL, 0x000fe2000ffde0ffULL,
0x00000010321d7824ULL, 0x102fe400078e0221ULL, 0x000000083a2f7824ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001034297824ULL, 0x000fe200078e0221ULL,
0x000000001a1d7faeULL, 0x0003e2000d901c46ULL, 0x0000008016167825ULL, 0x004fe200078e00ffULL,
0xfffffff82f2c7812ULL, 0x000fc400078ee22cULL, 0x000000001e297faeULL, 0x0005e2000e101c46ULL,
0x000000012a187824ULL, 0x100fe200078e0212ULL, 0x0000000f16167212ULL, 0x000fe200078efcffULL,
0x000000102c2f7824ULL, 0x000fe200078e0221ULL, 0x00000000222b7faeULL, 0x0007e2000e901c46ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000a16167c10ULL, 0x000fe4000ffde0ffULL,
0x00000000242d7faeULL, 0x0009e2000c901c46ULL, 0x000000013c1a7824ULL, 0x142fe200078e0203ULL,
0x0000000b17177c10ULL, 0x000fe2000b7fe4ffULL, 0x000000083c1b7824ULL, 0x040fe200078e00ffULL,
0x00000000262f7faeULL, 0x0003e2000d101c46ULL, 0x00000038202c7836ULL, 0x000fe20000000000ULL,
0x000000133c00720cULL, 0x000fe20003fa6070ULL, 0x0000003c202e7836ULL, 0x000fe20000000000ULL,
0xfffffff81b1c7812ULL, 0x000fe200078ee21aULL, 0x00000001281b7824ULL, 0x100fe200078e0203ULL,
0x0000000f181a7212ULL, 0x000fe200078efcffULL, 0x0000000828207824ULL, 0x000fe200078e00ffULL,
0x000000133600720cULL, 0x080fe20003f86070ULL, 0x000000012c187824ULL, 0x100fe200078e0212ULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x00000008361e7824ULL, 0x004fe200078e00ffULL,
0x000000132800720cULL, 0x080fe20003f66070ULL, 0x000000012e127824ULL, 0x000fe200078e0212ULL,
0x000000132a00720cULL, 0x0c0fe20003f46070ULL, 0x000000012a1d7824ULL, 0x100fe200078e0203ULL,
0x000000132c00720cULL, 0x080fe20003f26070ULL, 0x000000082a227824ULL, 0x008fe200078e00ffULL,
0x000000132e00720cULL, 0x000fe20003f06070ULL, 0x0000000136137824ULL, 0x100fe200078e0203ULL,
0xfffffff820207812ULL, 0x000fe200078ee21bULL, 0x000000012c1f7824ULL, 0x000fe200078e0203ULL,
0x0000000b191b7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fc400078ee213ULL, 0xfffffff822227812ULL, 0x000fe200078ee21dULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000f18187212ULL, 0x000fc600078efcffULL,
0x000000082c247824ULL, 0x010fe200078e00ffULL, 0x0000000a18187c10ULL, 0x000fe2000ffde0ffULL,
0x000000012e237824ULL, 0x000fe200078e0203ULL, 0x0000000f12127212ULL, 0x000fe200078efcffULL,
0x000000082e267824ULL, 0x002fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee21fULL,
0x000000101c0f7824ULL, 0x100fe200078e0221ULL, 0x0000000b19197c10ULL, 0x000fe2000b7fe4ffULL,
0x000000101e1d7824ULL, 0x100fe200078e0221ULL, 0xfffffff826267812ULL, 0x000fe200078ee223ULL,
0x00000010201f7824ULL, 0x100fe200078e0221ULL, 0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL,
0x0000001022237824ULL, 0x100fe200078e0221ULL, 0x00000000100f7faeULL, 0x0003e2000e901c46ULL,
0x0000001024257824ULL, 0x100fe200078e0221ULL, 0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001026217824ULL, 0x000fe200078e0221ULL, 0x00000000141d7faeULL, 0x0003e8000e101c46ULL,
0x00000000161f7faeULL, 0x0003e8000d901c46ULL, 0x000000001a237faeULL, 0x0003e8000d101c46ULL,
0x0000000018257faeULL, 0x0003e8000c901c46ULL, 0x0000000012217faeULL, 0x0003e2000c101c46ULL,
0x0000000800e07947ULL, 0x000fea0003800000ULL, 0x0000000403137811ULL, 0x042fe200078fe8ffULL,
0x00000010033d7824ULL, 0x040fe200078e00ffULL, 0x0000000c03167811ULL, 0x040fe200078fe8ffULL,
0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL, 0x00000018031c7811ULL, 0x000fe200078fe8ffULL,
0x00000001130d7824ULL, 0x100fe200078e0203ULL, 0x00000014031a7811ULL, 0x000fe200078fe8ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x0000000803147811ULL, 0x040fe200078fe8ffULL,
0x00000008161e7824ULL, 0x000fe200078e00ffULL, 0x0000002c033e7811ULL, 0x040fe200078fe8ffULL,
0x000000011c117824ULL, 0x100fe200078e0203ULL, 0xfffffff810277812ULL, 0x000fe200078ee20dULL,
0x00000001160d7824ULL, 0x100fe200078e0203ULL, 0x0000002803247811ULL, 0x040fe200078fe8ffULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0x0000003403327811ULL, 0x040fe200078fe8ffULL,
0x000000011a107824ULL, 0x140fe200078e0203ULL, 0xfffffff81e2b7812ULL, 0x000fe200078ee20dULL,
0x000000081a2f7824ULL, 0x000fe200078e00ffULL, 0x0000001c031e7811ULL, 0x040fe200078fe8ffULL,
0x00000001140f7824ULL, 0x140fe200078e0203ULL, 0xfffffff822317812ULL, 0x000fe200078ee211ULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0x0000002403227811ULL, 0x040fe200078fe8ffULL,
0x000000011e0d7824ULL, 0x140fe200078e0203ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee210ULL,
0x000000081e267824ULL, 0x000fe200078e00ffULL, 0xfffffff818297812ULL, 0x000fe200078ee20fULL,
0x0000000122107824ULL, 0x140fe200078e0203ULL, 0x0000001003187811ULL, 0x040fe200078fe8ffULL,
0x0000000822377824ULL, 0x000fe200078e00ffULL, 0xfffffff826337812ULL, 0x000fe200078ee20dULL,
0x000000013e0d7824ULL, 0x140fe200078e0203ULL, 0x0000003c032e7811ULL, 0x040fe200078fe8ffULL,
0x000000083e267824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee210ULL,
0x0000000124117824ULL, 0x140fe200078e0203ULL, 0x0000003803307811ULL, 0x040fe200078fe8ffULL,
0x00000008242a7824ULL, 0x000fe200078e00ffULL, 0xfffffff826177812ULL, 0x000fe200078ee20dULL,
0x00000001180f7824ULL, 0x140fe200078e0203ULL, 0x0000003003347811ULL, 0x000fe200078fe8ffULL,
0x0000000818207824ULL, 0x000fe200078e00ffULL, 0xfffffff82a3b7812ULL, 0x000fe200078ee211ULL,
0x0000000132107824ULL, 0x140fe200078e0203ULL, 0x000000703d3d7812ULL, 0x000fe200078ec0ffULL,
0x00000008321b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8202d7812ULL, 0x000fe200078ee20fULL,
0x000000012e0d7824ULL, 0x140fe200078e0203ULL, 0x0000002003207811ULL, 0x040fe200078fe8ffULL,
0x000000082e267824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee210ULL,
0x0000000130117824ULL, 0x140fe200078e0203ULL, 0x0000001203107211ULL, 0x000fe200078fe8ffULL,
0x00000008302a7824ULL, 0x000fe200078e00ffULL, 0xfffffff826417812ULL, 0x000fe200078ee20dULL,
0x00000001200f7824ULL, 0x040fe200078e0203ULL, 0x00000008390d7c11ULL, 0x000fe2000f8e70ffULL,
0x0000000820287824ULL, 0x000fe200078e00ffULL, 0xfffffff82a1d7812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff828357812ULL, 0x000fe200078ee20fULL,
0x000020000a157824ULL, 0x000fe200078e020dULL, 0x0000003d10107212ULL, 0x000fe200078efcffULL,
0x0000000114147824ULL, 0x000fe400078e0212ULL, 0x0000100015367836ULL, 0x000fe20000000000ULL,
0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000000b11117c10ULL, 0x000fe200087fe4ffULL, 0x00000001340f7824ULL, 0x000fe200078e0203ULL,
0x0000003d14147212ULL, 0x000fe200078efcffULL, 0x0000000834287824ULL, 0x000fe400078e00ffULL,
0x0000000116167824ULL, 0x000fe200078e0212ULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001017267824ULL, 0x000fe200078e0236ULL, 0xfffffff828197812ULL, 0x000fe200078ee20fULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000003030f7211ULL, 0x000fc400078fe8ffULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x000000011a1a7824ULL, 0x000fe200078e0212ULL,
0x0000003d16167212ULL, 0x000fe200078efcffULL, 0x000000101b2a7824ULL, 0x000fe400078e0236ULL,
0x0000000113137824ULL, 0x100fe200078e0212ULL, 0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000118187824ULL, 0x100fe400078e0212ULL, 0x000000011c1c7824ULL, 0x100fe200078e0212ULL,
0x0000000b17177c10ULL, 0x000fe200087fe4ffULL, 0x000000011e1e7824ULL, 0x000fc400078e0212ULL,
0x0000000120207824ULL, 0x100fe400078e0212ULL, 0x0000000122227824ULL, 0x100fe400078e0212ULL,
0x0000000124247824ULL, 0x100fe400078e0212ULL, 0x000000013e3e7824ULL, 0x100fe400078e0212ULL,
0x0000000134347824ULL, 0x100fe400078e0212ULL, 0x0000000132327824ULL, 0x000fc400078e0212ULL,
0x0000000130307824ULL, 0x100fe400078e0212ULL, 0x000000012e2e7824ULL, 0x000fe200078e0212ULL,
0x000000070f127812ULL, 0x000fe200078ec0ffULL, 0x000000801a1a7825ULL, 0x000fc600078e00ffULL,
0x0ffffff8120f7812ULL, 0x000fe200078ef803ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000003d1a1a7212ULL, 0x000fc600078efcffULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x0000000a1a1a7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000003d1e1e7212ULL, 0x080fe200078efcffULL,
0x0000001019287824ULL, 0x100fe200078e0236ULL, 0x0000003d12127212ULL, 0x080fe200078efcffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000b1b1b7c10ULL, 0x000fe400087fe4ffULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000101d2c7824ULL, 0x000fe200078e0236ULL,
0x0000000a12127c10ULL, 0x000fe2000ff3e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003d22227212ULL, 0x000fc400078efcffULL, 0x0000000b1f1f7c10ULL, 0x000fe200087fe4ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000003d18187212ULL, 0x080fe400078efcffULL,
0x0000000b13137c10ULL, 0x000fe20008ffe4ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000003d1c1c7212ULL, 0x000fe400078efcffULL, 0x0000000a22227c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000000a18187c10ULL, 0x000fc4000ff3e0ffULL,
0x0000003d3e3e7212ULL, 0x080fe200078efcffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000000a1c1c7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000003d20207212ULL, 0x080fe200078efcffULL,
0x0000008034427825ULL, 0x000fe200078e00ffULL, 0x0000003d24247212ULL, 0x000fe400078efcffULL,
0x0000000b23237c10ULL, 0x000fe200087fe4ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0236ULL,
0x0000000b19197c10ULL, 0x000fe20008ffe4ffULL, 0x0000008032447825ULL, 0x000fe200078e00ffULL,
0x0000000a3e3e7c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000b1d1d7c10ULL, 0x000fe200097fe4ffULL,
0x0000001027277824ULL, 0x100fe200078e0236ULL, 0x0000000a20207c10ULL, 0x000fe2000ff3e0ffULL,
0x0000008030467825ULL, 0x000fe200078e00ffULL, 0x0000003d423c7212ULL, 0x080fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e2000b901c46ULL,
0x0000000a24247c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001029297824ULL, 0x100fe200078e0236ULL,
0x0000003d44427212ULL, 0x080fe200078efcffULL, 0x000000802e487825ULL, 0x000fe200078e00ffULL,
0x0000003d46447212ULL, 0x080fe200078efcffULL, 0x0000000012277faeULL, 0x0003e2000b901c46ULL,
0x0000000b3f3f7c10ULL, 0x000fe200087fe4ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0236ULL,
0x0000003d483d7212ULL, 0x000fe200078efcffULL, 0x000000102d2d7824ULL, 0x100fe200078e0236ULL,
0x0000000014297faeULL, 0x0003e2000b901c46ULL, 0x000000102f2f7824ULL, 0x100fe200078e0236ULL,
0x0000000b21217c10ULL, 0x000fe20008ffe4ffULL, 0x0000001031317824ULL, 0x100fe200078e0236ULL,
0x0000000a3c3c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001033337824ULL, 0x100fe200078e0236ULL,
0x00000000162b7faeULL, 0x0003e2000b901c46ULL, 0x0000001035357824ULL, 0x100fe200078e0236ULL,
0x0000000b25257c10ULL, 0x000fe200097fe4ffULL, 0x0000001037377824ULL, 0x100fe200078e0236ULL,
0x0000000a42427c10ULL, 0x000fe2000ff3e0ffULL, 0x00000000182d7faeULL, 0x0003e2000b901c46ULL,
0x000000103b3b7824ULL, 0x100fe200078e0236ULL, 0x0000000a44447c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001041417824ULL, 0x000fe200078e0236ULL, 0x000000001a2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000a3d467c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000b433d7c10ULL, 0x000fe200087fe4ffULL,
0x000000001c317faeULL, 0x0003e2000b901c46ULL, 0x0000000b45437c10ULL, 0x000fe40008ffe4ffULL,
0x0000000b47457c10ULL, 0x000fe200097fe4ffULL, 0x000000001e337faeULL, 0x0003e2000b901c46ULL,
0x0000000b49477c10ULL, 0x000fc60009ffe4ffULL, 0x0000000020357faeULL, 0x0003e8000b901c46ULL,
0x0000000022377faeULL, 0x0003e8000b901c46ULL, 0x00000000243b7faeULL, 0x0003e8000b901c46ULL,
0x000000003e267faeULL, 0x0003e8000b901c46ULL, 0x000000003c287faeULL, 0x0003e8000b901c46ULL,
0x00000000422a7faeULL, 0x0003e8000b901c46ULL, 0x00000000442c7faeULL, 0x0003e8000b901c46ULL,
0x0000000046417faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002003107836ULL, 0x002fe20000000000ULL, 0xfffffff8033a7812ULL, 0x000fe200078ec0ffULL,
0x000020000b0f7824ULL, 0x000fe200078e020dULL, 0x0000000703387812ULL, 0x000fe200078ec0ffULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe400078ec0ffULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x00000004ff0d7819ULL, 0x000fc40000011603ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000010000f0f7836ULL, 0x000fe20000000000ULL,
0x000000073a3a7812ULL, 0x000fe200078ef803ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000008383b7812ULL, 0x000fe400078ef803ULL, 0x00000007100b7812ULL, 0x000fce00078ef803ULL,
0x000000013a107824ULL, 0x140fe400078e0242ULL, 0x000000083a117824ULL, 0x000fe400078e00ffULL,
0x000000010b147824ULL, 0x040fe400078e0242ULL, 0x000000080b157824ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe200078ee210ULL, 0x00000002427a7824ULL, 0x000fc600078e020dULL,
0xfffffff815147812ULL, 0x000fe200078ee214ULL, 0x0000001010107824ULL, 0x000fc800078e020fULL,
0x0000001014147824ULL, 0x000fe400078e020fULL, 0x000000001010783bULL, 0x000e680000000200ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00000018ff5b7819ULL, 0x002fe20000011410ULL,
0x00010000101c7824ULL, 0x040fe200078e00ffULL, 0x0000888010557816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe20000011411ULL,
0x00010000111d7824ULL, 0x040fe200078e00ffULL, 0x0000888011717816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000018ff577819ULL, 0x000fc40000011412ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000888012567816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001000787306ULL, 0x0003e20000202400ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff677819ULL, 0x004fe40000011414ULL,
0x0000888014697816ULL, 0x000fc400000000ffULL, 0x00000018ff667819ULL, 0x000fe20000011413ULL,
0x0000001100747306ULL, 0x0005e20000202400ULL, 0x0001000012107824ULL, 0x042fe200078e00ffULL,
0x00008880136d7816ULL, 0x040fe200000000ffULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011417ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000013117824ULL, 0x044fe200078e00ffULL,
0x0000001c005e7306ULL, 0x0002a20000202400ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x0000888017597816ULL, 0x000fc400000000ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000001200727306ULL, 0x0007e20000202400ULL,
0x000000083a1c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011415ULL,
0x0000888015657816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fc40000011416ULL,
0x0000001100707306ULL, 0x0003e20000202400ULL, 0x0000000142127836ULL, 0x008fe20000000000ULL,
0x0000888016637816ULL, 0x000fe200000000ffULL, 0x0000000242427836ULL, 0x000fca0000000000ULL,
0x0000001d00767306ULL, 0x0007e20000202400ULL, 0x000000013a117824ULL, 0x102fe200078e0212ULL,
0x000000084200780cULL, 0x000fe20003f05270ULL, 0x000000010b127824ULL, 0x000fc600078e0212ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL, 0x0001000015117824ULL, 0x040fe200078e00ffULL,
0x00000010006f7306ULL, 0x0003e20000202400ULL, 0x0000010015157824ULL, 0x000fe400078e00ffULL,
0x000000101c1c7824ULL, 0x000fe200078e020fULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000013006b7306ULL, 0x0009e20000202400ULL,
0x000000001c1c783bULL, 0x008ee20000000200ULL, 0x0001000014107824ULL, 0x002fc400078e00ffULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x00000011006a7306ULL, 0x000fe20000202400ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x000000080b137824ULL, 0x010fca00078e00ffULL, 0xfffffff813127812ULL, 0x000fe200078ee212ULL,
0x00000014006c7306ULL, 0x0003e80000202400ULL, 0x0000001012127824ULL, 0x000fc800078e020fULL,
0x00000010006e7306ULL, 0x0009e20000202400ULL, 0x0001000017147824ULL, 0x042fe400078e00ffULL,
0x0000010017177824ULL, 0x000fc600078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0001000016107824ULL, 0x050fe200078e00ffULL,
0x0000001400627306ULL, 0x0007e20000202400ULL, 0x0000010016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011410ULL, 0x000000001210783bULL, 0x000e620000000200ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000001700607306ULL, 0x0009e20000202400ULL,
0x000100001c147824ULL, 0x048fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe4000001141cULL,
0x000088801c457816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x0000001500687306ULL, 0x0007e20000202400ULL,
0x000000103b177824ULL, 0x010fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff4b7819ULL, 0x000fe4000001141dULL, 0x000088801d4d7816ULL, 0x040fe400000000ffULL,
0x00000014004e7306ULL, 0x0009e20000202400ULL, 0x000100001d157824ULL, 0x048fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe2000001141eULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x000088801e4f7816ULL, 0x000fc400000000ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000001600617306ULL, 0x0007e20000202400ULL, 0x000000013b147824ULL, 0x010fe200078e027aULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff497819ULL, 0x000fe4000001141fULL,
0xfffffff017147812ULL, 0x000fe400078ee214ULL, 0x0000001500527306ULL, 0x0009e20000202400ULL,
0x000100001e167824ULL, 0x008fe200078e00ffULL, 0x0000000814147c11ULL, 0x000fe2000f8e20ffULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x000088801f517816ULL, 0x000fc400000000ffULL,
0x00000018ff587819ULL, 0x000fe40000011416ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000000001414783bULL, 0x010ee20000000200ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff487819ULL, 0x002fe40000011410ULL, 0x00000018ff477819ULL, 0x000fe40000011411ULL,
0x0000001c00507306ULL, 0x0003e20000202400ULL, 0x0000888011737816ULL, 0x000fc400000000ffULL,
0x000000023b7a7810ULL, 0x000fe40007ffe07aULL, 0x00000018ff447819ULL, 0x000fe40000011413ULL,
0x00000018ff467819ULL, 0x000fe20000011412ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x000100001f1c7824ULL, 0x042fe400078e00ffULL, 0x000001001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x00000018ff1f7819ULL, 0x000fce000001141fULL, 0x0000001d00547306ULL, 0x0003f00000202400ULL,
0x0000001c005c7306ULL, 0x0005e20000202400ULL, 0x00008880101d7816ULL, 0x002fce00000000ffULL,
0x0000005700577306ULL, 0x000e620000202400ULL, 0x00005410551c7816ULL, 0x004fce000000005eULL,
0x0000001d00557306ULL, 0x0005e20000202400ULL, 0x0000541072577816ULL, 0x002fce0000000057ULL,
0x0000005600567306ULL, 0x000e620000202400ULL, 0x00005410781d7816ULL, 0x004fce000000005bULL,
0x0000001c143c723cULL, 0x008fe2000004183cULL, 0x0000001e00537306ULL, 0x0005ec0000202400ULL,
0x00005410711c7816ULL, 0x000fe40000000076ULL, 0x00005410741d7816ULL, 0x000fe2000000005dULL,
0x00010000101e7824ULL, 0x044fe200078e00ffULL, 0x0000006600667306ULL, 0x000ea20000202400ULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x0000541056567816ULL, 0x002fe2000000006fULL,
0x000000ffff5d7224ULL, 0x000fe200078e0073ULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000001c1434723cULL, 0x000fe20000041834ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x0000006d006d7306ULL, 0x000e660000202400ULL, 0x000000561430723cULL, 0x000fe20000041830ULL,
0x00010000111d7824ULL, 0x000fc800078e00ffULL, 0x0000006700677306ULL, 0x000fe40000202400ULL,
0x0000010011577824ULL, 0x000fe200078e00ffULL, 0x000054106b117816ULL, 0x004fc80000000066ULL,
0x00000018ff667819ULL, 0x000fe20000011457ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x0000888012577816ULL, 0x000fce00000000ffULL, 0x00000010005b7306ULL, 0x0007f00000202400ULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x00000018ff107819ULL, 0x008fce000001141dULL,
0x0000001000567306ULL, 0x0003f00000202400ULL, 0x0000006500657306ULL, 0x000ee20000202400ULL,
0x000054106d107816ULL, 0x002fce0000000070ULL, 0x0000001f005a7306ULL, 0x0003e20000202400ULL,
0x00000010142c723cULL, 0x000fee000004182cULL, 0x0000541069107816ULL, 0x004fe2000000006eULL,
0x000000103b1f7824ULL, 0x002fe200078e00ffULL, 0x000054106c117816ULL, 0x000fe20000000067ULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x0001000012677824ULL, 0x000fc400078e00ffULL,
0xfffffff01f7a7812ULL, 0x000fc600078ee27aULL, 0x000000101428723cULL, 0x000fe20000041828ULL,
0x000000087a1c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x00000018ff677819ULL, 0x000fc80000011467ULL, 0x0000541065107816ULL, 0x008fe4000000006aULL,
0x0000541068117816ULL, 0x000fe2000000005fULL, 0x0000006400647306ULL, 0x000e6c0000202400ULL,
0x000000101424723cULL, 0x000fe40000041824ULL, 0x0000001e005e7306ULL, 0x0005ea0000202400ULL,
0x0000010012117824ULL, 0x000fe200078e00ffULL, 0x0000541063107816ULL, 0x002fc40000000064ULL,
0x0000004100417306ULL, 0x000e620000202400ULL, 0x000000001c1c783bULL, 0x004ea20000000200ULL,
0x00000018ff5f7819ULL, 0x000fe40000011411ULL, 0x0000541061117816ULL, 0x000fe4000000004cULL,
0x00008880134c7816ULL, 0x000fe400000000ffULL, 0x0000005900597306ULL, 0x000ee60000202400ULL,
0x000000101420723cULL, 0x000fea0000041820ULL, 0x0000004300437306ULL, 0x000fe40000202400ULL,
0x0000541060117816ULL, 0x002fe20000000041ULL, 0x000000ffff417224ULL, 0x000fe200078e004cULL,
0x0000541059107816ULL, 0x008fc80000000062ULL, 0x0000004500457306ULL, 0x000e660000202400ULL,
0x000000101418723cULL, 0x000fea0000041818ULL, 0x0000004b004b7306ULL, 0x000fe40000202400ULL,
0x0001000013117824ULL, 0x000fe200078e00ffULL, 0x0000541045107816ULL, 0x002fca000000004eULL,
0x0000004d004d7306ULL, 0x000e620000202400ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011411ULL, 0x0000541050117816ULL, 0x000fe40000000043ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000004900497306ULL, 0x000fe60000202400ULL,
0x000000101c3c723cULL, 0x004fea000004183cULL, 0x0000005100517306ULL, 0x000ea40000202400ULL,
0x000054104d107816ULL, 0x002fc40000000052ULL, 0x0000541054117816ULL, 0x000fc8000000004bULL,
0x0000004100147306ULL, 0x000fe60000202400ULL, 0x000000101c34723cULL, 0x000fea0000041834ULL,
0x0000001500157306ULL, 0x000e640000202400ULL, 0x0000541051107816ULL, 0x004fc4000000005cULL,
0x000054105a117816ULL, 0x000fe40000000049ULL, 0x00005410555a7816ULL, 0x000fe4000000005eULL,
0x0000004a004a7306ULL, 0x000ea60000202400ULL, 0x000000101c2c723cULL, 0x000fe2000004182cULL,
0x0000541014147816ULL, 0x002fc80000000015ULL, 0x0000004800487306ULL, 0x000e620000202400ULL,
0x0000541053537816ULL, 0x004fce000000004aULL, 0x0000004700477306ULL, 0x000fe20000202400ULL,
0x000054105b5b7816ULL, 0x002fce0000000048ULL, 0x0000004600467306ULL, 0x000fe20000202400ULL,
0x0000005a1c28723cULL, 0x000fee0000041828ULL, 0x0000004400447306ULL, 0x000ff00000202400ULL,
0x0000004f004f7306ULL, 0x000ff00000202400ULL, 0x0000005800587306ULL, 0x000e700000202400ULL,
0x0000005d005d7306ULL, 0x000ea20000202400ULL, 0x000054104f527816ULL, 0x002fce0000000058ULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x000000521c30723cULL, 0x000fe20000041830ULL,
0x000054105d107816ULL, 0x004fcc0000000056ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x0000541066117816ULL, 0x002fce0000000047ULL, 0x0000006700127306ULL, 0x000e620000202400ULL,
0x000000101c24723cULL, 0x000fee0000041824ULL, 0x0000005f005f7306ULL, 0x000ea20000202400ULL,
0x0000541057127816ULL, 0x002fce0000000012ULL, 0x0000001300177306ULL, 0x0004640000202400ULL,
0x000054105f137816ULL, 0x004fe40000000046ULL, 0x0000541017157816ULL, 0x002fca0000000044ULL,
0x000000121c20723cULL, 0x000fec0000041820ULL, 0x000000141c18723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff000280947ULL, 0x000fde000383ffffULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000043c0b7220ULL, 0x080fe20000410000ULL,
0x000000043d3d7220ULL, 0x080fe20000410000ULL, 0x000000043e3e7220ULL, 0x080fe20000410000ULL,
0x000000043f3f7220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x080fe20000410000ULL,
0x01768810051079a7ULL, 0x000e62000850003fULL, 0x0000000435357220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x0000000430307220ULL, 0x080fe20000410000ULL, 0x0000000431317220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x000000042c2c7220ULL, 0x080fe20000410000ULL, 0x000000042d2d7220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000429297220ULL, 0x080fe20000410000ULL,
0x000000042a2a7220ULL, 0x080fe20000410000ULL, 0x000000042b2b7220ULL, 0x080fe20000410000ULL,
0x0000000424247220ULL, 0x080fe20000410000ULL, 0x0000000425257220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x080fe20000410000ULL,
0x00000004180d7220ULL, 0x080fe20000410000ULL, 0x00000004190f7220ULL, 0x080fe20000410000ULL,
0x000000041a1f7220ULL, 0x080fe20000410000ULL, 0x000000041b3a7220ULL, 0x000fe20000410000ULL,
0x0000000000127805ULL, 0x000fe20000015200ULL, 0x01768811050075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff167224ULL, 0x000fce00078e00ffULL,
0x000000101600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000116167836ULL, 0x000fce0000000000ULL,
0x01768811050075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000403107824ULL, 0x000fe200078e00ffULL, 0x0000000839117c11ULL, 0x000fe4000f8e38ffULL,
0x000000080700720cULL, 0x000fe40003f06070ULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x00000001111e7824ULL, 0x000fca00078e0210ULL, 0x017400001e107984ULL, 0x0002a20000000c00ULL,
0x0000001000c48947ULL, 0x000fea0003800000ULL, 0xffffff0009097836ULL, 0x000fe20000000000ULL,
0x00008c00ff147b82ULL, 0x000ee20000000a00ULL, 0x0000000203417824ULL, 0x000fe200078e00ffULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0x00008400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000090e3c7248ULL, 0x000fe40007fe0000ULL, 0x0000000641417812ULL, 0x000fc600078ec0ffULL,
0x000000013c3c7824ULL, 0x000fe200078e0a09ULL, 0x0000000003097211ULL, 0x000fe200078ff0ffULL,
0x0000000941177c36ULL, 0x000fe40008000000ULL, 0x000000ffff507224ULL, 0x000fe200078e0a3cULL,
0x0000000aff167c19ULL, 0x000fe20008011609ULL, 0x0000000809187836ULL, 0x000fe20000000000ULL,
0x0000003c1700720cULL, 0x000fe20003f26070ULL, 0x0000000b41097c36ULL, 0x000fe20008000000ULL,
0x0000000517177e46ULL, 0x000fe4000b800050ULL, 0x0000000516167c48ULL, 0x000fc4000bfe0000ULL,
0x0000003c0900720cULL, 0x000fe40003f06070ULL, 0x00000005093b7e46ULL, 0x000fe2000b800050ULL,
0x00000004165b7c24ULL, 0x000fe2000f8e02ffULL, 0x00000004ff177819ULL, 0x000fe40000011617ULL,
0x000000ff3b3b7207ULL, 0x000fe40000000000ULL, 0x000000ff17167207ULL, 0x000fe40000800000ULL,
0x0000000aff187c19ULL, 0x000fc40008011618ULL, 0x0000001041457812ULL, 0x000fe200078efcffULL,
0x000000015b1b7824ULL, 0x000fe200078e0216ULL, 0x0000005b3b1d7211ULL, 0x000fe400078fe0ffULL,
0x0000000518187c48ULL, 0x000fe2000bfe0000ULL, 0x00000009454b7c36ULL, 0x000fe40008000000ULL,
0x0000000b45477c36ULL, 0x000fe40008000000ULL, 0x000000021d1c7825ULL, 0x008fc800078e0014ULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x000000054b487e46ULL, 0x000fe2000b800050ULL,
0x000000061c437981ULL, 0x000ee4000c1e9500ULL, 0x0000000418597c24ULL, 0x000fe2000f8e02ffULL,
0x0000003c4700720cULL, 0x080fe20003f06070ULL, 0x000000061a427981ULL, 0x0008e2000c1e9500ULL,
0x0000000547467e46ULL, 0x000fe2000b800050ULL, 0x0000000116197824ULL, 0x000fe200078e0259ULL,
0x0000003c4b00720cULL, 0x000fe40003f26070ULL, 0x00000020414b7812ULL, 0x000fc400078efcffULL,
0x000000593b177211ULL, 0x000fe400078fe0ffULL, 0x00000004ff487819ULL, 0x000fe40000011648ULL,
0x000000ff46467207ULL, 0x000fe20000000000ULL, 0x0000000b4b4f7c36ULL, 0x000fe20008000000ULL,
0x000000ff481a7207ULL, 0x012fe20000800000ULL, 0x0000000217167825ULL, 0x000fe200078e0014ULL,
0x0000005b461b7211ULL, 0x000fc600078fe0ffULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x0000003c4f00720cULL, 0x000fe20003f06070ULL, 0x0000000616447981ULL, 0x0042a2000c1e9500ULL,
0x000000054f527e46ULL, 0x000fe2000b800050ULL, 0x000000094b537c36ULL, 0x000fe40008000000ULL,
0x000000015b1d7824ULL, 0x000fe200078e021aULL, 0x0000000618497981ULL, 0x0008a2000c1e9500ULL,
0x000000ff52527207ULL, 0x000fe20000000000ULL, 0x000000021b167825ULL, 0x002fe200078e0014ULL,
0x00000059461b7211ULL, 0x000fc400078fe0ffULL, 0x00000005534c7e46ULL, 0x000fe2000b800050ULL,
0x000000021d187825ULL, 0x010fe200078e0014ULL, 0x0000000616487981ULL, 0x000322000c1e9500ULL,
0x0000003c5300720cULL, 0x000fe40003f26070ULL, 0x000000011a1d7824ULL, 0x000fe200078e0259ULL,
0x0000003041537812ULL, 0x000fe200078efcffULL, 0x000000021b1a7825ULL, 0x000fe200078e0014ULL,
0x00000004ff4c7819ULL, 0x000fe2000001164cULL, 0x00000006184d7981ULL, 0x000f22000c1e9500ULL,
0x0000005b52177211ULL, 0x002fe200078fe0ffULL, 0x000000021d1c7825ULL, 0x100fe200078e0014ULL,
0x000000ff4c4e7207ULL, 0x000fe20000800000ULL, 0x000000061a4a7981ULL, 0x000364000c1e9500ULL,
0x0000000217167825ULL, 0x000fc400078e0014ULL, 0x000000061c517981ULL, 0x000364000c1e9500ULL,
0x00000009535d7c36ULL, 0x000fe40008000000ULL, 0x00000006164c7981ULL, 0x000362000c1e9500ULL,
0x0000000b53557c36ULL, 0x000fe20008000000ULL, 0x00000059521b7211ULL, 0x002fe200078fe0ffULL,
0x000000015b197824ULL, 0x000fe400078e024eULL, 0x000000014e1d7824ULL, 0x000fe200078e0259ULL,
0x000000055d167e46ULL, 0x000fc6000b800050ULL, 0x000000021d1c7825ULL, 0x100fe200078e0014ULL,
0x0000003c5500720cULL, 0x080fe40003f06070ULL, 0x0000000555547e46ULL, 0x000fe2000b800050ULL,
0x0000000219187825ULL, 0x000fe200078e0014ULL, 0x0000003c5d00720cULL, 0x000fe20003f26070ULL,
0x000000061c1d7981ULL, 0x000f62000c1e9500ULL, 0x00000004ff167819ULL, 0x000fe20000011616ULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x000000ff54547207ULL, 0x000fe20000000000ULL,
0x0000000618577981ULL, 0x000362000c1e9500ULL, 0x000000ff16507207ULL, 0x000fc60000800000ULL,
0x000000061a4e7981ULL, 0x000362000c1e9500ULL, 0x0000005b54177211ULL, 0x000fe200078fe0ffULL,
0x000000015b197824ULL, 0x002fc800078e0250ULL, 0x0000000217167825ULL, 0x000fc800078e0014ULL,
0x0000000219187825ULL, 0x000fe400078e0014ULL, 0x0000000616167981ULL, 0x000f62000c1e9500ULL,
0x00000059541b7211ULL, 0x000fc600078fe0ffULL, 0x0000000618197981ULL, 0x000362000c1e9500ULL,
0x00000001505b7824ULL, 0x000fe400078e0259ULL, 0x000000021b1a7825ULL, 0x000fc800078e0014ULL,
0x000000025b147825ULL, 0x000fe400078e0014ULL, 0x000000061a1a7981ULL, 0x000f68000c1e9500ULL,
0x00000006145f7981ULL, 0x000362000c1e9500ULL, 0xfffffff03b3b7812ULL, 0x000fe400078ec0ffULL,
0xfffffff046467812ULL, 0x000fe400078ec0ffULL, 0x00000001417d7812ULL, 0x040fe200078efcffULL,
0x000000013c3b7824ULL, 0x000fe200078e023bULL, 0x00000008417b7812ULL, 0x000fc400078efcffULL,
0x0000000941797812ULL, 0x000fe200078efcffULL, 0x000000013c667824ULL, 0x000fe200078e0246ULL,
0xfffffff054547812ULL, 0x000fe200078ec0ffULL, 0x00000001ff507424ULL, 0x000fe400078e00ffULL,
0x0000000b7d1c7c36ULL, 0x000fe40008000000ULL, 0x0000000b7b187c36ULL, 0x002fe40008000000ULL,
0x0000000b79147c36ULL, 0x000fe40008000000ULL, 0x0000000109467824ULL, 0x000fc400078e0a3bULL,
0x000000013c5a7824ULL, 0x000fe400078e0254ULL, 0x000000011c587824ULL, 0x100fe400078e0a3bULL,
0x0000000118567824ULL, 0x100fe400078e0a3bULL, 0x0000000114547824ULL, 0x000fe200078e0a3bULL,
0x00000046503b7219ULL, 0x040fe400000006ffULL, 0x00000018416f7812ULL, 0x000fe400078efcffULL,
0x0000005650567219ULL, 0x000fc400000006ffULL, 0x0000005450547219ULL, 0x000fe400000006ffULL,
0xfffffff052527812ULL, 0x000fe200078ec0ffULL, 0x0000000b6f757c36ULL, 0x000fc80008000000ULL,
0x000000013c647824ULL, 0x000fe400078e0252ULL, 0x0000000147527824ULL, 0x100fe400078e0a66ULL,
0x00000001755c7824ULL, 0x000fe200078e0a66ULL, 0x0000001141717812ULL, 0x040fe400078efcffULL,
0x00000019416d7812ULL, 0x000fe400078efcffULL, 0x0000005850587219ULL, 0x040fe400000006ffULL,
0x0000005250527219ULL, 0x000fc400000006ffULL, 0x0000005c505c7219ULL, 0x000fe200000006ffULL,
0x0000000b71777c36ULL, 0x000fe40008000000ULL, 0x0000000b6d737c36ULL, 0x000fe40008000000ULL,
0x00000001776e7824ULL, 0x100fe400078e0a66ULL, 0x0000000173667824ULL, 0x000fe400078e0a66ULL,
0x000000014f6c7824ULL, 0x000fe200078e0a64ULL, 0x0000002141657812ULL, 0x000fc400078efcffULL,
0x0000002841637812ULL, 0x040fe400078efcffULL, 0x0000002941617812ULL, 0x000fe400078efcffULL,
0x0000006e50467219ULL, 0x040fe400000006ffULL, 0x0000006650667219ULL, 0x040fe400000006ffULL,
0x0000006c506c7219ULL, 0x000fe200000006ffULL, 0x0000000b656b7c36ULL, 0x000fe40008000000ULL,
0x0000000b63697c36ULL, 0x000fc40008000000ULL, 0x0000000b61677c36ULL, 0x000fe40008000000ULL,
0x000000016b6a7824ULL, 0x100fe400078e0a64ULL, 0x0000000169687824ULL, 0x100fe400078e0a64ULL,
0x0000000167647824ULL, 0x000fe400078e0a64ULL, 0x0000000155627824ULL, 0x000fe200078e0a5aULL,
0x00000031411b7812ULL, 0x040fe400078efcffULL, 0x0000003841177812ULL, 0x000fc400078efcffULL,
0x0000003941157812ULL, 0x000fe400078efcffULL, 0x0000006a506a7219ULL, 0x040fe400000006ffULL,
0x0000006850687219ULL, 0x040fe400000006ffULL, 0x0000006450647219ULL, 0x040fe400000006ffULL,
0x0000006250627219ULL, 0x000fe200000006ffULL, 0x0000000b1b5d7c36ULL, 0x000fe40008000000ULL,
0x0000000b175b7c36ULL, 0x000fc40008000000ULL, 0x0000000b15597c36ULL, 0x000fe40008000000ULL,
0x000000015d607824ULL, 0x100fe400078e0a5aULL, 0x000000015b5e7824ULL, 0x100fe400078e0a5aULL,
0x00000001595a7824ULL, 0x000fe200078e0a5aULL, 0x0000006050607219ULL, 0x040fe400000006ffULL,
0x0000005e505e7219ULL, 0x040fe400000006ffULL, 0x0000005a505a7219ULL, 0x000fc400000006ffULL,
0x0000541043437816ULL, 0x008fc80000000042ULL, 0x000000433bff7212ULL, 0x000fc8000780c0ffULL,
0x0000003c0900720cULL, 0x000fc80000701470ULL, 0x0000003c4100720cULL, 0x000fc800007a1070ULL,
0xff8000000b0b7808ULL, 0x000fe40002800000ULL, 0x0000541044497816ULL, 0x004fc80000000049ULL,
0x000000493bff7212ULL, 0x080fe4000784c0ffULL, 0x0000004956ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004954ff7212ULL, 0x000fe400078ac0ffULL, 0x0000003c0900720cULL, 0x080fe40001741470ULL,
0x0000003c1800720cULL, 0x080fe400037c1470ULL, 0x0000003c1400720cULL, 0x000fc40002fa1470ULL,
0x0000003c4100720cULL, 0x080fe40001741070ULL, 0x0000003c7b00720cULL, 0x080fe400037c1070ULL,
0x0000003c7900720cULL, 0x000fe40002fa1070ULL, 0x00005410484d7816ULL, 0x010fe4000000004dULL,
0xff8000003e3e7808ULL, 0x000fe40001000000ULL, 0x000054104a517816ULL, 0x020fc40000000051ULL,
0xff80000036367808ULL, 0x000fe40003000000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0x0000004358ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004356ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004354ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004958ff7212ULL, 0x000fc4000780c0ffULL,
0x0000004d52ff7212ULL, 0x040fe4000784c0ffULL, 0x0000005152ff7212ULL, 0x080fe400078cc0ffULL,
0x000000515cff7212ULL, 0x000fe400078ac0ffULL, 0x0000003c1c00720cULL, 0x0c0fe40000f21470ULL,
0x0000003c1c00720cULL, 0x080fe40000701470ULL, 0x0000003c1800720cULL, 0x000fc40001f61470ULL,
0x0000003c1400720cULL, 0x080fe40002781470ULL, 0x0000003c4700720cULL, 0x0c0fe40001741470ULL,
0x0000003c4700720cULL, 0x080fe400037c1470ULL, 0x0000003c7500720cULL, 0x080fe40002fa1470ULL,
0x0000003c7d00720cULL, 0x0c0fe40000f21070ULL, 0x0000003c7d00720cULL, 0x000fc40000701070ULL,
0x0000003c7b00720cULL, 0x080fe40001f61070ULL, 0x0000003c7900720cULL, 0x080fe40002781070ULL,
0x0000003c4500720cULL, 0x0c0fe40001741070ULL, 0x0000003c4500720cULL, 0x080fe400037c1070ULL,
0x0000003c6f00720cULL, 0x000fe40002fa1070ULL, 0x000054104c577816ULL, 0x000fc40000000057ULL,
0x000054104e1d7816ULL, 0x000fe4000000001dULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000000000ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000030307808ULL, 0x000fc40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0x0000004d46ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004d5cff7212ULL, 0x080fe4000780c0ffULL,
0x0000004d66ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005146ff7212ULL, 0x000fc4000788c0ffULL,
0x0000005166ff7212ULL, 0x000fe4000784c0ffULL, 0x000000576cff7212ULL, 0x040fe400078cc0ffULL,
0x0000001d6cff7212ULL, 0x000fe400078ac0ffULL, 0x0000003c7700720cULL, 0x0c0fe40000f21470ULL,
0x0000003c7700720cULL, 0x080fe40002781470ULL, 0x0000003c7500720cULL, 0x000fc40000701470ULL,
0x0000003c7300720cULL, 0x0c0fe40001f61470ULL, 0x0000003c7300720cULL, 0x080fe40001741470ULL,
0x0000003c4f00720cULL, 0x0c0fe400037c1470ULL, 0x0000003c4f00720cULL, 0x080fe40002fa1470ULL,
0x0000003c7100720cULL, 0x0c0fe40000f21070ULL, 0x0000003c7100720cULL, 0x000fc40002781070ULL,
0x0000003c6f00720cULL, 0x080fe40000701070ULL, 0x0000003c6d00720cULL, 0x0c0fe40001f61070ULL,
0x0000003c6d00720cULL, 0x080fe40001741070ULL, 0x0000003c4b00720cULL, 0x0c0fe400037c1070ULL,
0x0000003c4b00720cULL, 0x000fe40002fa1070ULL, 0x0000541016197816ULL, 0x000fc40000000019ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0xff80000033337808ULL, 0x000fe40002000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fc40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x000000576aff7212ULL, 0x080fe4000782c0ffULL,
0x0000005768ff7212ULL, 0x080fe4000788c0ffULL, 0x0000005764ff7212ULL, 0x000fe4000780c0ffULL,
0x0000001d6aff7212ULL, 0x080fe4000786c0ffULL, 0x0000001d68ff7212ULL, 0x000fc4000784c0ffULL,
0x0000001d64ff7212ULL, 0x000fe400078cc0ffULL, 0x0000001962ff7212ULL, 0x000fe400078ac0ffULL,
0x0000003c6b00720cULL, 0x0c0fe40000f21470ULL, 0x0000003c6b00720cULL, 0x080fe40001f61470ULL,
0x0000003c6900720cULL, 0x0c0fe40002781470ULL, 0x0000003c6900720cULL, 0x000fc40001741470ULL,
0x0000003c6700720cULL, 0x0c0fe40000701470ULL, 0x0000003c6700720cULL, 0x080fe400037c1470ULL,
0x0000003c5500720cULL, 0x080fe40002fa1470ULL, 0x0000003c6500720cULL, 0x0c0fe40000f21070ULL,
0x0000003c6500720cULL, 0x080fe40001f61070ULL, 0x0000003c6300720cULL, 0x000fc40002781070ULL,
0x0000003c6300720cULL, 0x080fe40001741070ULL, 0x0000003c6100720cULL, 0x0c0fe40000701070ULL,
0x0000003c6100720cULL, 0x080fe400037c1070ULL, 0x0000003c5300720cULL, 0x000fe40002fa1070ULL,
0x000054101a5f7816ULL, 0x000fe4000000005fULL, 0xff80000029297808ULL, 0x000fc40000800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40002000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40003000000ULL, 0xff80000020207808ULL, 0x000fc40002800000ULL,
0x0000001960ff7212ULL, 0x080fe4000782c0ffULL, 0x000000195eff7212ULL, 0x080fe4000786c0ffULL,
0x000000195aff7212ULL, 0x000fe4000788c0ffULL, 0x0000005f62ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005f60ff7212ULL, 0x080fe4000780c0ffULL, 0x0000005f5eff7212ULL, 0x000fc400078cc0ffULL,
0x0000005f5aff7212ULL, 0x000fe400078ac0ffULL, 0x0000003c5500720cULL, 0x080fe40001741470ULL,
0x0000003c5d00720cULL, 0x0c0fe40000f21470ULL, 0x0000003c5d00720cULL, 0x080fe40000701470ULL,
0x0000003c5b00720cULL, 0x0c0fe40001f61470ULL, 0x0000003c5b00720cULL, 0x000fc400037c1470ULL,
0x0000003c5900720cULL, 0x0c0fe40002781470ULL, 0x0000003c5900720cULL, 0x080fe40002fa1470ULL,
0x0000003c5300720cULL, 0x080fe40001741070ULL, 0x0000003c1b00720cULL, 0x0c0fe40000f21070ULL,
0x0000003c1b00720cULL, 0x080fe40000701070ULL, 0x0000003c1700720cULL, 0x000fc40001f61070ULL,
0x0000003c1700720cULL, 0x080fe400037c1070ULL, 0x0000003c1500720cULL, 0x0c0fe40002781070ULL,
0x0000003c1500720cULL, 0x000fe40002fa1070ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff8000000d0d7808ULL, 0x000fe40001800000ULL, 0xff8000000f0f7808ULL, 0x000fc40002000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fe40000000000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff8000003a3a7808ULL, 0x000fce0002800000ULL,
0x0000000b1000720bULL, 0x004fe20003f1e000ULL, 0x3f800000000a7882ULL, 0x000fe20000000000ULL,
0xfffffff8ff387812ULL, 0x000fe200078ee238ULL, 0x0000000aff1c7e24ULL, 0x000fe2000f8e00ffULL,
0x000000100b107208ULL, 0x000fe20004000000ULL, 0x0000000107077836ULL, 0x000fc60000000000ULL,
0x0000003d1000720bULL, 0x000fe40003f1e000ULL, 0x3f8000001c1c783eULL, 0x000fe400000010ffULL,
0x000000103d097208ULL, 0x000fc60004000000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e001cULL,
0x000000340900720bULL, 0x000fc80003f1e000ULL, 0x0000000934107208ULL, 0x000fc80004000000ULL,
0x000000351000720bULL, 0x000fc80003f1e000ULL, 0x0000001035097208ULL, 0x000fc80004000000ULL,
0x000000300900720bULL, 0x000fc80003f1e000ULL, 0x0000000930107208ULL, 0x000fc80004000000ULL,
0x000000311000720bULL, 0x000fc80003f1e000ULL, 0x0000001031097208ULL, 0x000fc80004000000ULL,
0x0000002c0900720bULL, 0x000fc80003f1e000ULL, 0x000000092c107208ULL, 0x000fc80004000000ULL,
0x0000002d1000720bULL, 0x000fc80003f1e000ULL, 0x000000102d097208ULL, 0x000fc80004000000ULL,
0x000000280900720bULL, 0x000fc80003f1e000ULL, 0x0000000928107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x0000001029097208ULL, 0x000fc80004000000ULL,
0x000000240900720bULL, 0x000fc80003f1e000ULL, 0x0000000924107208ULL, 0x000fe40004000000ULL,
0x0000003e1100720bULL, 0x000fe40003f1e000ULL, 0x000000251000720bULL, 0x000fc80003f3e000ULL,
0x0000001025097208ULL, 0x000fe40004800000ULL, 0x000000113e107208ULL, 0x000fe40004000000ULL,
0x000000200900720bULL, 0x000fe40003f3e000ULL, 0x0000003f1000720bULL, 0x000fe40003f1e000ULL,
0x0000000920147208ULL, 0x000fe40004800000ULL, 0x000000103f097208ULL, 0x000fc40004000000ULL,
0x000000211400720bULL, 0x000fe40003f3e000ULL, 0x000000360900720bULL, 0x000fe40003f1e000ULL,
0x0000001421147208ULL, 0x000fe40004800000ULL, 0x0000000936107208ULL, 0x000fe40004000000ULL,
0x0000000d1400720bULL, 0x000fe40003f3e000ULL, 0x000000371000720bULL, 0x000fc40003f1e000ULL,
0x000000140d147208ULL, 0x000fe40004800000ULL, 0x0000001037097208ULL, 0x000fe40004000000ULL,
0x0000000f1400720bULL, 0x000fe40003f3e000ULL, 0x000000320900720bULL, 0x000fe40003f1e000ULL,
0x000000140f147208ULL, 0x000fe40004800000ULL, 0x0000000932107208ULL, 0x000fc60004000000ULL,
0x0c401f0014117f89ULL, 0x000ea200000e0000ULL, 0x000000331000720bULL, 0x000fc80003f1e000ULL,
0x0000001033097208ULL, 0x000fc80004000000ULL, 0x0000002e0900720bULL, 0x000fc80003f1e000ULL,
0x000000092e107208ULL, 0x000fc80004000000ULL, 0x0000002f1000720bULL, 0x000fc80003f1e000ULL,
0x000000102f097208ULL, 0x000fe40004000000ULL, 0x000000111400720bULL, 0x004fe40003f3e000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001411117208ULL, 0x000fe40004800000ULL,
0x000000092a107208ULL, 0x000fc60004000000ULL, 0x0c201f0011147f89ULL, 0x000ea200000e0000ULL,
0x0000002b1000720bULL, 0x000fc80003f1e000ULL, 0x000000102b097208ULL, 0x000fc80004000000ULL,
0x000000260900720bULL, 0x000fc80003f1e000ULL, 0x0000000926107208ULL, 0x000fc80004000000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x0000001027097208ULL, 0x000fe40004000000ULL,
0x000000141100720bULL, 0x004fe40003f3e000ULL, 0x000000220900720bULL, 0x000fe40003f1e000ULL,
0x0000001114107208ULL, 0x000fe40004800000ULL, 0x0000000922147208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10167820ULL, 0x000fe20000410000ULL, 0x000000231400720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010816ULL, 0x0000001423147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010816ULL, 0x0000001f1400720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010816ULL, 0x000000141f097208ULL, 0x000fe20004000000ULL,
0x0000003d00187308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010816ULL, 0x0000003a0900720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010816ULL, 0x000000093a097208ULL, 0x000fe20004000000ULL,
0x0000002c001a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010816ULL,
0x0c401f0009147f89ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fc60000010816ULL,
0x00000024002c7308ULL, 0x000ff00000000800ULL, 0x00000020003d7308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x000000140900720bULL, 0x004fc80003f1e000ULL,
0x0000000914097208ULL, 0x000fc60004000000ULL, 0x0000003400347308ULL, 0x000fe40000000800ULL,
0x0c201f0009147f89ULL, 0x000eac00000e0000ULL, 0x0000003500357308ULL, 0x000ef00000000800ULL,
0x0000002100427308ULL, 0x000fe20000000800ULL, 0x000000343516723eULL, 0x008fce00000010ffULL,
0x00000028003b7308ULL, 0x000fe20000000800ULL, 0x000000140900720bULL, 0x004fc80003f1e000ULL,
0x0000000914117208ULL, 0x000fc60004000000ULL, 0x00000029003c7308ULL, 0x000fe20000000800ULL,
0x0000000b1814723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b11417820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010841ULL,
0x0000003e00157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2b097823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010841ULL,
0x0000003f00207308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b220b7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b3a3a7823ULL, 0x000fc80000010841ULL, 0x0000003600177308ULL, 0x000fe20000000800ULL,
0x000000152015723eULL, 0x004fce00000010ffULL, 0x0000003700247308ULL, 0x000ea20000000800ULL,
0x0000003b3c20723eULL, 0x000fce00000010ffULL, 0x0000002a00217308ULL, 0x0007e20000000800ULL,
0x000000172417723eULL, 0x004fce00000010ffULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0c401f0013247f89ULL, 0x000ea200000e0000ULL, 0x0000001c1428723cULL, 0x008fec00000418ffULL,
0x0000003100317308ULL, 0x000ef00000000800ULL, 0x0000002d002d7308ULL, 0x000f220000000800ULL,
0x000000303118723eULL, 0x008fce00000010ffULL, 0x0000003200197308ULL, 0x0007e20000000800ULL,
0x000000241300720bULL, 0x004fc80003f3e000ULL, 0x0000001324137208ULL, 0x000fe40004800000ULL,
0x0000001a2d1a723eULL, 0x010fe200000010ffULL, 0x0000003300467308ULL, 0x000ea20000000800ULL,
0x0000003d4224723eULL, 0x000fe200000010ffULL, 0x000000ffff2d7224ULL, 0x000fe200078e001cULL,
0x0c201f0013347f89ULL, 0x000f2600000e0000ULL, 0x000000ffff327224ULL, 0x008fe400078e0024ULL,
0x0000002e001b7308ULL, 0x000fe20000000800ULL, 0x000000194619723eULL, 0x004fce00000010ffULL,
0x0000002f003e7308ULL, 0x0004f00000000800ULL, 0x00000009002e7308ULL, 0x000b620000000800ULL,
0x000000ffff2f7224ULL, 0x004fe200078e001aULL, 0x000000341300720bULL, 0x010fc40003f3e000ULL,
0x0000001b3e1b723eULL, 0x008fc800000010ffULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x0c401f0012097f89ULL, 0x022e6200000e0000ULL, 0x0000001334137208ULL, 0x000fe20004800000ULL,
0x0000001c1828723cULL, 0x000fe20000041828ULL, 0x000000212e21723eULL, 0x000fc800000010ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x00000008382e7824ULL, 0x000fe200078e00ffULL,
0x0000002c2522723eULL, 0x004fcc00000010ffULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x00000008382c7836ULL, 0x000fe40000000000ULL, 0x000000ffff317224ULL, 0x000fca00078e0022ULL,
0x0000000f00447308ULL, 0x0007e20000000800ULL, 0x000000091200720bULL, 0x002fc80003f1e000ULL,
0x0000001209127208ULL, 0x000fe40004000000ULL, 0x00000003ff097819ULL, 0x000fe20000011603ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b230f7823ULL, 0x008fe20000010841ULL,
0x000000262723723eULL, 0x004fe400000010ffULL, 0x0000000309097812ULL, 0x000fc800078ec0ffULL,
0x0000000f00307308ULL, 0x000e620000000800ULL, 0x0000001c2028723cULL, 0x000fee0000041828ULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x00000001091d7824ULL, 0x000fe200078e022cULL,
0x0000000b3025723eULL, 0x002fcc00000010ffULL, 0x0000003a003a7308ULL, 0x000e620000000800ULL,
0x00000008380b7824ULL, 0x000fe400078e00ffULL, 0x0000000109387824ULL, 0x000fe400078e0238ULL,
0x0c201f0012097f89ULL, 0x000ea200000e0000ULL, 0x000000082c307824ULL, 0x000fe400078e00ffULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x00000004380f7836ULL, 0x000fe20000000000ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee238ULL, 0x0000000c38387836ULL, 0x000fe20000000000ULL,
0xfffffff8301d7812ULL, 0x000fe200078ee21dULL, 0x000000ffff307224ULL, 0x000fe200078e0020ULL,
0xfffffff82e0f7812ULL, 0x000fe200078ee20fULL, 0x000000ffff2e7224ULL, 0x000fe200078e0018ULL,
0x0000001f3a27723eULL, 0x002fe200000010ffULL, 0x000000082c1f7824ULL, 0x000fc400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fe400078e001cULL, 0x000000ffff187224ULL, 0x000fe200078e0021ULL,
0x0000000d4426723eULL, 0x008fe200000010ffULL, 0x000000ffff1a7224ULL, 0x000fe200078e0025ULL,
0x00000008390d7c11ULL, 0x000fc6000f8e58ffULL, 0x000000ffff337224ULL, 0x000fe200078e0026ULL,
0x000000091200720bULL, 0x004fe20003f1e000ULL, 0x0000002c2428723cULL, 0x000fe20000041828ULL,
0x000110000d1c7836ULL, 0x000fe20000000000ULL, 0xfffffff81f0d7812ULL, 0x000fe400078ee238ULL,
0x0000001209127208ULL, 0x000fe20004000000ULL, 0x000000100b0b7824ULL, 0x000fe200078e021cULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff2c7224ULL, 0x000fe400078e0014ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0016ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000100f0f7824ULL, 0x100fe200078e021cULL, 0x0000002c0b007844ULL, 0x0003e20000000200ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000101d1d7824ULL, 0x000fe200078e021cULL,
0x000000300f007844ULL, 0x0005e20000000200ULL, 0x000000ffff167224ULL, 0x000fe400078e0019ULL,
0x000000ffff177224ULL, 0x000fc400078e001bULL, 0x000000100d0d7824ULL, 0x000fe400078e021cULL,
0x000000ffff197224ULL, 0x000fe200078e0023ULL, 0x000000141d007844ULL, 0x0005e20000000200ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0027ULL, 0x000000ffff297224ULL, 0x000fe400078e002aULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000180d007844ULL, 0x0005e20000000200ULL,
0x000000ffff0b7224ULL, 0x002fc600078e000aULL, 0x017000101e008388ULL, 0x0005e80000000c00ULL,
0x017200281e008388ULL, 0x0005e20000000a00ULL, 0x0000000c0700720cULL, 0x000fe20003f06070ULL,
0x0176080906ff79a7ULL, 0x0005e2000850003fULL, 0x0176100906ff79a7ULL, 0x0005e2000850003fULL,
0x0176180906ff79a7ULL, 0x0005e2000850003fULL, 0x0176200906ff79a7ULL, 0x0005f2000850003fULL,
0xffffffb0000c8947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000051007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000005100008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff51ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000051027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffed802d87950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x000000000000057fULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000700ULL, 0x0000000000000258ULL,
0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000958ULL, 0x00000000000000e0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a38ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a8cULL, 0x0000000000000660ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001138ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000012580ULL,
0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013700ULL, 0x0000000000000048ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013750ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000013750ULL, 0x0000000000000268ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000013d38ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000013d38ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001138ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000012580ULL, 0x0000000000012580ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000050ULL,
0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000013750ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_90_cubin_len = 81544;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
