/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001f540ULL, 0x000000000001f1c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001d5a0ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001d720ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001d760ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001d7b0ULL, 0x0000000000000150ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001d900ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001d5a000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x0073f80400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001d5a000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080840828ULL,
0x2880808608288080ULL, 0x8088082880808708ULL, 0x082880809d082880ULL, 0x8080a5082880809fULL,
0xc508288080bc0828ULL, 0x288080ea08288080ULL, 0x80f008288080ef08ULL, 0x08288080f1082880ULL,
0x80828016288080ceULL, 0x0000000000031028ULL, 0x288080ce92000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001d72000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080840828ULL,
0x2880808608288080ULL, 0x8088082880808708ULL, 0x082880809d082880ULL, 0x8080a6082880809fULL,
0xc508288080bc0828ULL, 0x288080ea08288080ULL, 0x80f008288080ef08ULL, 0x08288080f1082880ULL,
0x80828016288080a5ULL, 0x0000000000031028ULL, 0x288080a592000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001d76000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80ea288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL, 0x8088082880808708ULL,
0x082880809d082880ULL, 0x8080a5082880809fULL, 0xc508288080bc0828ULL, 0x288080ea08288080ULL,
0x80f008288080ef08ULL, 0x08288080f1082880ULL, 0x80828016288080a6ULL, 0x0000000000031028ULL,
0x288080a692000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL,
0x0001d7b000000000ULL, 0x0000015000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000faULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0058016000000016ULL, 0x000c170400581903ULL, 0x0050000900000000ULL,
0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040021f000ULL, 0x0040000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040061f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000b0000043104ULL,
0xffffffff019c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x00000110019c2804ULL, 0x00000580000002e0ULL, 0x00002750000026c0ULL, 0x000029d000002860ULL,
0x00002ca000002b40ULL, 0x0000316000003120ULL, 0x000031a000003170ULL, 0x00006290000061f0ULL,
0x00006510000063a0ULL, 0x000067e000006680ULL, 0x00006c7000006c30ULL, 0x00006cb000006c80ULL,
0x00009cc000009c20ULL, 0x00009f4000009dd0ULL, 0x0000a2100000a0b0ULL, 0x0000a6b00000a670ULL,
0x0000a6f00000a6c0ULL, 0x0000d6100000d570ULL, 0x0000d8900000d720ULL, 0x0000db600000da00ULL,
0x0000e0000000dfc0ULL, 0x0000e0400000e010ULL, 0x0001043000010420ULL, 0x0001045000010440ULL,
0x0001ae800001ae40ULL, 0x0001aea00001ae90ULL, 0x0001af100001aef0ULL, 0x0001af400001af30ULL,
0x0001c4100001c3b0ULL, 0x0001c4c00001c470ULL, 0x0001c5600001c510ULL, 0x0001c6200001c5c0ULL,
0x0001c6e00001c680ULL, 0x0001c7a00001c740ULL, 0x0001c8500001c800ULL, 0x0001c8f00001c8a0ULL,
0x0001c9b00001c950ULL, 0x0001ca700001ca10ULL, 0x0001cb300001cad0ULL, 0x0001cbe00001cb90ULL,
0x0001cc800001cc30ULL, 0x0001cd400001cce0ULL, 0x0001ce000001cda0ULL, 0x0001cec00001ce60ULL,
0x0001cf700001cf20ULL, 0x0001d0100001cfc0ULL, 0x0001d0d00001d070ULL, 0x0001d1900001d130ULL,
0x0001d2800001d200ULL, 0x0001d3800001d300ULL, 0x0001d4800001d400ULL, 0x0001d5800001d500ULL,
0x000003b004403904ULL, 0x0001a600000000ffULL, 0x00000430003f0100ULL, 0x0001a6080000000bULL,
0x000004f0003f0120ULL, 0x0001a6880000000bULL, 0x00000520003f0120ULL, 0x0001a6a80000000bULL,
0x00000550003f0120ULL, 0x0001a6c80000000bULL, 0x00000b10003f0120ULL, 0x0001a600000000ffULL,
0x00000c70003f0107ULL, 0x0001a68c00000014ULL, 0x00000d00003f0102ULL, 0x0001a68800000014ULL,
0x00001630003f0101ULL, 0x00000000000000ffULL, 0x000016b000040107ULL, 0x00000000000000ffULL,
0x0000171000040101ULL, 0x0000002000000002ULL, 0x00001880003f0101ULL, 0x0001a6cc00000008ULL,
0x00001a50003f0105ULL, 0x0001a6cc00000008ULL, 0x00002270003f0105ULL, 0x0001a6b00000001fULL,
0x00002330003f0107ULL, 0x0001a6b00000001fULL, 0x00002390003f0101ULL, 0x0001a6080000001cULL,
0x000023d0003f0101ULL, 0x0001a60c00000020ULL, 0x000025b0003f0105ULL, 0x0001a60c00000020ULL,
0x00002e50003f0105ULL, 0x0001a6ac0000001fULL, 0x00003040003f0105ULL, 0x0001a6ac0000001fULL,
0x00005410003f0105ULL, 0x000000000000006aULL, 0x00005470003f0101ULL, 0x0001a6880000001fULL,
0x000054a0003f0101ULL, 0x000000040000000dULL, 0x00005660003f0105ULL, 0x000000040000000dULL,
0x00005db0003f0105ULL, 0x0000000000000008ULL, 0x00005e90003f0107ULL, 0x0000000000000008ULL,
0x00005ef0003f0101ULL, 0x0001a62800000020ULL, 0x00005f50003f0101ULL, 0x0001a62c00000021ULL,
0x00006120003f0105ULL, 0x0001a62c00000021ULL, 0x000069a0003f0105ULL, 0x0001a6b40000006aULL,
0x00006b70003f0105ULL, 0x0001a6b40000006aULL, 0x00008ea0003f0105ULL, 0x000000000000006aULL,
0x00008f00003f0101ULL, 0x0001a69000000026ULL, 0x00008f30003f0101ULL, 0x000000040000000dULL,
0x000090f0003f0105ULL, 0x000000040000000dULL, 0x00009870003f0105ULL, 0x00000008000000ffULL,
0x0000990000040107ULL, 0x0001a6b000000068ULL, 0x00009960003f0101ULL, 0x0001a64800000020ULL,
0x00009980003f0101ULL, 0x0001a64c00000020ULL, 0x00009b50003f0105ULL, 0x0001a64c00000020ULL,
0x0000a3d0003f0105ULL, 0x0000000400000008ULL, 0x0000a5a0003f0105ULL, 0x0000000400000008ULL,
0x0000c7c0003f0105ULL, 0x000000000000006aULL, 0x0000c820003f0101ULL, 0x0001a69800000023ULL,
0x0000c850003f0101ULL, 0x000000040000000dULL, 0x0000ca10003f0105ULL, 0x000000040000000dULL,
0x0000d1b0003f0105ULL, 0x00000000000000ffULL, 0x0000d26000040107ULL, 0x0000000000000008ULL,
0x0000d2c0003f0101ULL, 0x0001a6680000000cULL, 0x0000d2f0003f0101ULL, 0x0001a66c0000000cULL,
0x0000d4c0003f0105ULL, 0x0001a66c0000000cULL, 0x0000dd20003f0105ULL, 0x0001a6b400000020ULL,
0x0000def0003f0105ULL, 0x0001a6b400000020ULL, 0x00010170003f0105ULL, 0x000000000000000dULL,
0x000101f0003f0101ULL, 0x0000000000000008ULL, 0x00011fc0003f0101ULL, 0x0001a600000000ffULL,
0x000137d0003f0101ULL, 0x0001a604000000ffULL, 0x000139a0003f0105ULL, 0x0001a604000000ffULL,
0x00013d20003f0105ULL, 0x0001a600000000ffULL, 0x00013d50003f0101ULL, 0x0001a604000000ffULL,
0x00013f10003f0105ULL, 0x0001a604000000ffULL, 0x00018320003f0105ULL, 0x000000000000005dULL,
0x00018450003f0101ULL, 0x000000040000005dULL, 0x00018620003f0105ULL, 0x000000040000005dULL,
0x0001c1f0003f0105ULL, 0x000000000000005eULL, 0x0001c250003f0101ULL, 0x000000080000005eULL,
0x0001c2b0003f0101ULL, 0x000000100000005eULL, 0x0001c320003f0101ULL, 0x000000180000005eULL,
0x00053803003f0101ULL, 0x000113a000301c04ULL, 0x000115a0000113d0ULL, 0x0001186000011700ULL,
0x00011b20000119c0ULL, 0x00011e1000011c80ULL, 0x00013f7000011f10ULL, 0x000004010001c370ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL, 0x000000000000025cULL,
0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL, 0x00000000000000ccULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000303ULL,
0x0000001900000002ULL, 0x0000000000000233ULL, 0x0000001900000002ULL, 0x0000000000000173ULL,
0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL, 0x000000000001a700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0010757a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f280000002100ULL,
0x00000000000e7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff1a7819ULL, 0x010fc80000011607ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff1a1a7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000400031b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a1bULL,
0x0000040003007624ULL, 0x000fca00078e0210ULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x000000011b1b0810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x000000011b1b1810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff1baa12ULL, 0x000fc800078e33ffULL, 0x0000001b00007306ULL, 0x000e620000209000ULL,
0x000000ff1b00720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000031b047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603127227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a12ULL, 0x000000001b007224ULL, 0x000fca00078e0206ULL,
0x0000001b0000720cULL, 0x000fe20003f46070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000e6400000e0000ULL, 0x00000000020b7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003fa5270ULL, 0x0000000100002824ULL, 0x000fe200078e0a1bULL,
0x0000000112122810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000001b0000720cULL, 0x000fe40003f66070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL, 0xff317217ff088424ULL, 0x000fe400078e00ffULL,
0x0000000112123810ULL, 0x000fe20007ffe0ffULL, 0x01a60002ff00d388ULL, 0x0005e20000000a00ULL,
0x0000001bff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f64070ULL, 0x01a400080b008388ULL, 0x0007e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00005a0012187a19ULL, 0x000fe200000006ffULL,
0x000000ffff007224ULL, 0x000fc600078e0a12ULL, 0x01a608040b009388ULL, 0x0009e20000008a00ULL,
0x000000001b1b7224ULL, 0x000fe400078e0206ULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x000000201b007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x0000000400087c10ULL, 0x048fe2000fffe1ffULL,
0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x3fffff80ff04a424ULL, 0x010fe200078e00ffULL, 0x0000002008087817ULL, 0x000fe20003800000ULL,
0x7fffff80ff05a424ULL, 0x000fe200078e00ffULL, 0x01a688020b00a388ULL, 0x0005e40000008a00ULL,
0x000000ff08197207ULL, 0x000fe20000000000ULL, 0x0000000409087824ULL, 0x002fe200078e021aULL,
0x01a6a8040b00a388ULL, 0x000fe40000008a00ULL, 0x000000201900780cULL, 0x000fe20003f05270ULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x01a6c8060b00b388ULL, 0x000fe20000008a00ULL,
0x000058000e027a24ULL, 0x004fc800078e02ffULL, 0x0000007502027224ULL, 0x000fe200078e0218ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000819037217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x00000004ff047819ULL, 0x002fc80000011617ULL, 0x00000002040b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0204ULL, 0x000000030400720cULL, 0x080fe40003f06070ULL,
0x000000030b00720cULL, 0x000fe20003f26070ULL, 0x00000001080c7824ULL, 0x000fe400078e020bULL,
0x0000000100057824ULL, 0x040fe400078e020aULL, 0x00000001000d7824ULL, 0x000fe400078e020cULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000405077c12ULL, 0x000fc4000f8e30ffULL,
0x000000040d0f7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe20000011605ULL,
0x0000000102077824ULL, 0x040fe200078e0207ULL, 0x00005a00ff087a19ULL, 0x000fe2000001160dULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000007506047224ULL, 0x080fe400078e0207ULL,
0x0000001017027824ULL, 0x000fe400078e00ffULL, 0x0000007508067224ULL, 0x000fc400078e020fULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f002037812ULL, 0x000fc600078ec0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000304047212ULL, 0x000fc600078efcffULL,
0x000000010a087824ULL, 0x100fe200078e0217ULL, 0x0000000306037212ULL, 0x000fe200078efcffULL,
0x000000010c0a7824ULL, 0x000fe200078e0217ULL, 0x00005e0004047a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff00b087812ULL, 0x000fe400078ee208ULL,
0x00005e0003067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000001008037824ULL, 0x000fe200078e00ffULL, 0x00005f0005057a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e8000c101c48ULL,
0x00000000060b7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000817087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x00000010080c7824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011603ULL, 0x0000000108037824ULL, 0x000fe200078e0217ULL,
0x0000000406077c12ULL, 0x000fe2000f8e30ffULL, 0x0000000102057824ULL, 0x000fe200078e0205ULL,
0x00005a00ff067a19ULL, 0x000fe20000011606ULL, 0x000000010a087824ULL, 0x000fe200078e0217ULL,
0xfffffff00c037812ULL, 0x000fe200078ee203ULL, 0x0000000102077824ULL, 0x000fc400078e0207ULL,
0x0000007504047224ULL, 0x080fe400078e0205ULL, 0x0000001017027824ULL, 0x000fe400078e00ffULL,
0x0000007506067224ULL, 0x000fe400078e0207ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000f0020b7812ULL, 0x000fc600078ec0ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000b04047212ULL, 0x000fc600078efcffULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x0000000b06067212ULL, 0x000fe200078efcffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00005e0004047a10ULL, 0x000fe40007f1e0ffULL, 0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00b087812ULL, 0x000fe400078ee208ULL, 0x00005f0005057a10ULL, 0x000fe400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080b7824ULL, 0x000fc400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e8000b901c48ULL,
0x00000000060b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000037806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000300047300ULL, 0x000e7000000e0000ULL, 0x0000000300067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x00000004ff057424ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x004fe400078e0a06ULL, 0x000064000e047625ULL, 0x000fd000078e0005ULL,
0x01a60406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000804167981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x000000ff16037810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff157819ULL, 0x000fce0000011603ULL, 0x000112e000008947ULL, 0x000fea0003800000ULL,
0x000000081a147824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a68c0514ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0300780cULL, 0x000fe20003f04070ULL,
0x000000020e007824ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe2000001161aULL,
0x01a6880014ff7f8cULL, 0x0007e2000c80043fULL, 0x000000011a117812ULL, 0x000fe200078ec0ffULL,
0x0000590000057624ULL, 0x004fe400078e0210ULL, 0x0000002013747824ULL, 0x000fc400078e00ffULL,
0x0000000112127824ULL, 0x000fc800078e0205ULL, 0x0000660012007a24ULL, 0x000fe200078e0274ULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000007416037217ULL, 0x008fe20007800000ULL,
0x0000001011047824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc60000011617ULL,
0x0000000103037824ULL, 0x000fe200078e0a74ULL, 0x0000000405087810ULL, 0x040fe20007ffe0ffULL,
0x0000000104067824ULL, 0x002fe200078e0205ULL, 0x0000000c05097810ULL, 0x000fe40007ffe0ffULL,
0x0000000403037217ULL, 0x000fe20007800000ULL, 0x0000000106077824ULL, 0x040fe400078e0217ULL,
0x00000008060c7824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fc400078e0a04ULL,
0x00000001040a7824ULL, 0x000fe200078e0209ULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL,
0x0000000805077810ULL, 0x040fe20007ffe0ffULL, 0x00000001000d7824ULL, 0x040fe200078e020aULL,
0x000000030500720cULL, 0x080fe20003f66070ULL, 0x0000000100057824ULL, 0x000fe200078e0206ULL,
0x000000030800720cULL, 0x080fe20003f46070ULL, 0x0000000104087824ULL, 0x040fe200078e0208ULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x0000000104077824ULL, 0x000fe200078e0207ULL,
0x000000030900720cULL, 0x000fe20003f06070ULL, 0x0000008005047825ULL, 0x000fc800078e00ffULL,
0x0000000100067824ULL, 0x000fe200078e0208ULL, 0x00000070040b7812ULL, 0x000fe200078ef802ULL,
0x0000000108037824ULL, 0x040fe400078e0217ULL, 0x00000008080e7824ULL, 0x000fe400078e00ffULL,
0x0000000100087824ULL, 0x000fe400078e0207ULL, 0x0000000107097824ULL, 0x040fe200078e0217ULL,
0xfffffff80e007812ULL, 0x000fe200078ee203ULL, 0x0000000807107824ULL, 0x000fe200078e00ffULL,
0x0001600013037811ULL, 0x000fe200078e68ffULL, 0x000000010a047824ULL, 0x000fc400078e0217ULL,
0x000000080a077824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe20007f9e0ffULL,
0x00000010000f7824ULL, 0x000fe200078e0203ULL, 0xfffffff8100e7812ULL, 0x000fe400078ee209ULL,
0xfffffff807107812ULL, 0x000fe400078ee204ULL, 0x00006300050b7a10ULL, 0x000fe200027fe4ffULL,
0x0000008006047825ULL, 0x000fc800078e00ffULL, 0x0000008008067825ULL, 0x000fe200078e00ffULL,
0x0000007004007812ULL, 0x000fc600078ef802ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0x0000007006047812ULL, 0x000fc600078ef802ULL, 0x000000100c0d7824ULL, 0x100fe200078e0203ULL,
0x0000007008067812ULL, 0x000fe200078ef802ULL, 0x000000100e1d7824ULL, 0x100fe200078e0203ULL,
0x0000620000027a10ULL, 0x000fe20007f9e0ffULL, 0x00000010101f7824ULL, 0x000fe200078e0203ULL,
0x0000620004047a10ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000d901c48ULL, 0x0000620006067a10ULL, 0x000fe40007fde0ffULL,
0x0000630005037a10ULL, 0x000fe400027fe4ffULL, 0x0000630007057a10ULL, 0x000fc40002ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200037fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000d101c48ULL,
0x00000000041d7faeULL, 0x0003e8000c901c48ULL, 0x00000000061f7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011047824ULL, 0x008fe200078e00ffULL,
0x00016000131f7811ULL, 0x000fc800078e68ffULL, 0x0000000417037211ULL, 0x000fc800078fe8ffULL,
0x0000000403067810ULL, 0x042fe20007ffe0ffULL, 0x0000000103057824ULL, 0x040fe200078e0217ULL,
0x0000000c030a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008030c7824ULL, 0x040fe200078e00ffULL,
0x0000000803087810ULL, 0x000fe20007ffe0ffULL, 0x0000000100047824ULL, 0x040fe400078e0203ULL,
0x0000000100037824ULL, 0x000fe200078e0206ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000106077824ULL, 0x100fe200078e0217ULL,
0x00000070040b7812ULL, 0x000fe200078ef802ULL, 0x00000008060e7824ULL, 0x000fe400078e00ffULL,
0x00000001000d7824ULL, 0x000fe400078e020aULL, 0x000000010a047824ULL, 0x040fe400078e0217ULL,
0x000000080a0f7824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000100067824ULL, 0x000fe200078e0208ULL, 0xfffffff80e007812ULL, 0x000fe200078ee207ULL,
0x0000000108097824ULL, 0x040fe200078e0217ULL, 0xfffffff80f107812ULL, 0x000fe200078ee204ULL,
0x0000000808087824ULL, 0x000fe200078e00ffULL, 0x00006300050b7a10ULL, 0x000fe200007fe4ffULL,
0x0000008003047825ULL, 0x000fc600078e00ffULL, 0xfffffff8080e7812ULL, 0x000fe200078ee209ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000007004037812ULL, 0x000fc600078ef802ULL,
0x000000800d087825ULL, 0x000fe200078e00ffULL, 0x0000007006047812ULL, 0x000fc600078ef802ULL,
0x000000100c0d7824ULL, 0x100fe200078e021fULL, 0x0000007008067812ULL, 0x000fe200078ef802ULL,
0x00000010000f7824ULL, 0x100fe200078e021fULL, 0x0000620003027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100e1d7824ULL, 0x100fe200078e021fULL, 0x0000620004047a10ULL, 0x000fe20007f3e0ffULL,
0x00000010101f7824ULL, 0x000fe200078e021fULL, 0x0000620006067a10ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c48ULL,
0x0000630005037a10ULL, 0x000fe400007fe4ffULL, 0x0000630007057a10ULL, 0x000fc40000ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200017fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000b901c48ULL,
0x00000000041d7faeULL, 0x0003e8000b901c48ULL, 0x00000000061f7faeULL, 0x0003e4000b901c48ULL,
0x00000000130473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x0001a6a813027811ULL, 0x002fe200078e18ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0001a6a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x000000ffff557224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff207f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000ea7000008947ULL, 0x000fea0003800000ULL,
0x00000010130e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff107819ULL, 0x000fe2000001161aULL,
0x000000ffff007224ULL, 0x004fc400078e0003ULL, 0xff317217ff237424ULL, 0x000fe200078e00ffULL,
0x000000100e0e7812ULL, 0x000fe200078ee2ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x02afca00078e00ffULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x000000041a087824ULL, 0x000fca00078e00ffULL,
0xfffffff808087812ULL, 0x000fc800078ec0ffULL, 0x0001a6c8080d7810ULL, 0x000fe20007ffe0ffULL,
0x01a6cc00080b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000001d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc00080b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f007810ULL, 0x040fe20007ffe0ffULL,
0x000001000f0c7824ULL, 0x000fc600078e0274ULL, 0x000000150000720cULL, 0x000fe40003f46070ULL,
0x000000400c037810ULL, 0x000fca0007ffe0ffULL, 0x0000660012087a24ULL, 0x000fcc00078e0203ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x00000003ff0a7819ULL, 0x000fe20000011617ULL,
0x00000010110b7824ULL, 0x000fe200078e00ffULL, 0x0000000316007217ULL, 0x000fe40007800000ULL,
0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b027824ULL, 0x040fe200078e020aULL,
0x0000000c0a207810ULL, 0x002fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x00000001021c7824ULL, 0x040fe400078e0217ULL, 0x0000000802277824ULL, 0x000fe200078e00ffULL,
0x000000000b007217ULL, 0x000fe20007800000ULL, 0x0000001017037824ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e0208ULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b1f7824ULL, 0x000fe200078e021dULL, 0x0000007003257812ULL, 0x000fe200078ec0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x000000000a00720cULL, 0x080fe40003fa6070ULL,
0x000000001c00720cULL, 0x080fe20003f86070ULL, 0x000000010b1e7824ULL, 0x040fe200078e021cULL,
0x00000025021c7212ULL, 0x000fe200078efcffULL, 0x000000010b227824ULL, 0x000fe200078e0220ULL,
0x000000001d00720cULL, 0x080fe20003f66070ULL, 0x000000011e0a7824ULL, 0x000fe200078e0208ULL,
0x000000002000720cULL, 0x000fe20003f06070ULL, 0x000000011e007824ULL, 0x000fe200078e0217ULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x00006300031d7a10ULL, 0x000fe200037fe4ffULL, 0x000000081e697824ULL, 0x000fe200078e00ffULL,
0x000000250a1e7212ULL, 0x080fe200078efcffULL, 0x000000011f027824ULL, 0x100fe400078e0208ULL,
0x00000001220a7824ULL, 0x000fe200078e0208ULL, 0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0xfffffff869697812ULL, 0x000fe400078ee200ULL,
0x0001700013007811ULL, 0x000fe200078e68ffULL, 0x000000011f207824ULL, 0x040fe200078e0217ULL,
0x0000002502027212ULL, 0x000fe200078efcffULL, 0x000000081f6b7824ULL, 0x000fe200078e00ffULL,
0x000063000b1f7a10ULL, 0x000fe200037fe4ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000620002027a10ULL, 0x000fc40007fde0ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee220ULL,
0x0000000122087824ULL, 0x000fe200078e0217ULL, 0x000000250a0a7212ULL, 0x000fe200078efcffULL,
0x00000008226d7824ULL, 0x000fe200078e00ffULL, 0x0000630003037a10ULL, 0x000fe200037fe4ffULL,
0x0000001027257824ULL, 0x100fe200078e0200ULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001069277824ULL, 0x000fe200078e0200ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee208ULL,
0x000000106b697824ULL, 0x100fe200078e0200ULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c257faeULL, 0x0003e4000e901c48ULL,
0x000000106d6b7824ULL, 0x000fc400078e0200ULL, 0x000000001e277faeULL, 0x0003e8000e101c48ULL,
0x0000000002697faeULL, 0x0003e8000d901c48ULL, 0x000000000a6b7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001011007824ULL, 0x000fe400078e00ffULL,
0x0000001017027824ULL, 0x000fc600078e00ffULL, 0x0000000017007211ULL, 0x000fe400078fe8ffULL,
0x0000007002697812ULL, 0x000fe400078ec0ffULL, 0x0000000c001f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100037824ULL, 0x040fe200078e0217ULL, 0x00000008001d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008000a7824ULL, 0x040fe400078e00ffULL, 0x0000000100027824ULL, 0x000fe400078e0208ULL,
0x000000081f6d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a257812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x00000004000a7810ULL, 0x000fc60007ffe0ffULL,
0x000000011f1c7824ULL, 0x040fe200078e0208ULL, 0x00000069021e7212ULL, 0x000fe200078efcffULL,
0x000000011f027824ULL, 0x100fe400078e0217ULL, 0x000000010a0b7824ULL, 0x000fe200078e0217ULL,
0x000062001e1e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000080a207824ULL, 0x042fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee202ULL, 0x000000010a007824ULL, 0x100fe200078e0208ULL,
0x00006300031f7a10ULL, 0x000fe200007fe4ffULL, 0x000000011d0a7824ULL, 0x000fe200078e0208ULL,
0xfffffff820277812ULL, 0x000fe200078ee20bULL, 0x0000008000027825ULL, 0x000fc800078e00ffULL,
0x000000011d087824ULL, 0x040fe200078e0217ULL, 0x0000006902027212ULL, 0x080fe200078efcffULL,
0x000000081d6b7824ULL, 0x000fe400078e00ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000620002027a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee208ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000690a0a7212ULL, 0x000fe400078efcffULL,
0x0001700013087811ULL, 0x000fc400078e68ffULL, 0x000000691c1c7212ULL, 0x000fe400078efcffULL,
0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001025257824ULL, 0x100fe200078e0208ULL,
0x000062001c1c7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001027277824ULL, 0x100fe200078e0208ULL,
0x0000630003037a10ULL, 0x000fe200007fe4ffULL, 0x000000106b697824ULL, 0x100fe200078e0208ULL,
0x000063000b0b7a10ULL, 0x000fe20001ffe4ffULL, 0x000000106d6b7824ULL, 0x000fe200078e0208ULL,
0x000063001d1d7a10ULL, 0x000fe200027fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e257faeULL, 0x0003e8000b901c48ULL, 0x0000000002277faeULL, 0x0003e8000b901c48ULL,
0x000000000a697faeULL, 0x0003e8000b901c48ULL, 0x000000001c6b7faeULL, 0x0003e4000b901c48ULL,
0xfffffff0141f7812ULL, 0x042fe400078ec0ffULL, 0xffffffe014007812ULL, 0x000fc400078ec0ffULL,
0x000000001f0573c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001014037812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fc800078e0203ULL,
0x00000008111c7824ULL, 0x000fe200078e0200ULL, 0x0001a6b005057890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6b0001f687f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a608001c1c7f8cULL, 0x000ee4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x00000008140b7812ULL, 0x000fca00078ec0ffULL,
0x0000000100207824ULL, 0x000fca00078e020bULL, 0x01a60c00200b7984ULL, 0x000f240000000800ULL,
0x800000000bff7812ULL, 0x018fe4000780481dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a02257210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140bULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000200007819ULL, 0x000fc8000000120bULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a60c00200b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x008fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010170b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x000000201a007824ULL, 0x000fc600078e00ffULL,
0x000000700b0b7812ULL, 0x000fe400078ec0ffULL, 0xffffff8000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000000a007210ULL, 0x000fca0007ffe00bULL,
0x01a0000000027984ULL, 0x000ee80000000800ULL, 0x01a2000000037984ULL, 0x0002a20000000800ULL,
0x000000230200720bULL, 0x008fe20003f1d000ULL, 0x00019cc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x002fc800000e0100ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000074000007945ULL, 0x000fe20003800000ULL, 0x00000001ff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fd200078e0023ULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x0000001a1000720cULL, 0x000fe40003f05270ULL, 0x000000230200720bULL, 0x000fe20003f74000ULL,
0x00019c927f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x00000023021e7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x01a4001e25008388ULL, 0x0003e20000000800ULL, 0x000000ff1d00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000000231e087221ULL, 0x002fe20000010100ULL,
0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800277308ULL, 0x000e640000000800ULL,
0x0000002724247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x00019be27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x000fc40000410000ULL, 0x000000264c4c7220ULL, 0x080fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x00019ac27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00066400000e0000ULL,
0x0000002666667220ULL, 0x086fe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x000fc40000410000ULL,
0x000000264e4e7220ULL, 0x080fe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x000199a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x000000262c2c7220ULL, 0x080fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002628287220ULL, 0x080fe40000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x000198927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x000fc40000410000ULL, 0x000000262e2e7220ULL, 0x080fe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x000000262a2a7220ULL, 0x080fe40000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001d00ff7212ULL, 0x000fda00078030ffULL, 0x8000001e02020221ULL, 0x000fe20000010000ULL,
0x00007610ff220816ULL, 0x000fc60000000022ULL, 0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL,
0x0000000200090308ULL, 0x000e640000000800ULL, 0x0000000903030220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002403247221ULL, 0x004fc40000010000ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x01a6ac001f007984ULL, 0x000e620000000800ULL,
0x0001a6a81f087810ULL, 0x000fe40007ffe0ffULL, 0x8000000000ff7812ULL, 0x002fe20007804821ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c02237210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001141dULL, 0x0000002300007211ULL, 0x000fca00078110ffULL,
0x000000ffff1d7224ULL, 0x000fca00000e061dULL, 0x0000000200007819ULL, 0x000fc8000000121dULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01a6ac001f007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991022007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff027819ULL, 0x000fe40000011617ULL,
0x0000541000277816ULL, 0x008fe20000000000ULL, 0x000194627f007947ULL, 0x000fea000b800000ULL,
0x00001f0227077589ULL, 0x0002a400000e0000ULL, 0x0000000802267810ULL, 0x000fe20007ffe0ffULL,
0x000194a27f007947ULL, 0x000fea000b800000ULL, 0x0000001002007810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0027057589ULL, 0x0006a400000e0000ULL,
0x0000001802267810ULL, 0x008fe20007ffe0ffULL, 0x000195127f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000413227824ULL, 0x000fe200078e00ffULL, 0x0000000817007812ULL, 0x000fe200078ec0ffULL,
0x000004001a1d7824ULL, 0x000fe200078e00ffULL, 0x00000004ff267819ULL, 0x108fe20000011617ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000422227812ULL, 0x000fe200078ec0ffULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x0000000700037812ULL, 0x000fe200078ef817ULL,
0x00000004111f7824ULL, 0x000fe200078e0226ULL, 0x0000002217007211ULL, 0x000fc400078fe0ffULL,
0x0000001003027812ULL, 0x042fe200078efcffULL, 0x0000000803217824ULL, 0x040fe400078e00ffULL,
0x00000001031c7824ULL, 0x000fe400078e0200ULL, 0x0000000100007824ULL, 0x000fe400078e0202ULL,
0x0000000802237824ULL, 0x000fe200078e00ffULL, 0xfffffff8211c7812ULL, 0x000fe200078ee21cULL,
0x00000008036a7824ULL, 0x000fe200078e00ffULL, 0xfffff0001d217812ULL, 0x000fc400078ec0ffULL,
0xfffffff8231d7812ULL, 0x000fe200078ee200ULL, 0x0000000103237824ULL, 0x000fe200078e021fULL,
0x0001200021217810ULL, 0x000fe40007ffe0ffULL, 0x0001600013007811ULL, 0x000fe400078e68ffULL,
0xfffffff86a257812ULL, 0x000fe200078ee223ULL, 0x000000101c707824ULL, 0x100fe200078e0221ULL,
0x0000000223237810ULL, 0x000fe20007ffe0ffULL, 0x000000101d6c7824ULL, 0x000fe400078e0221ULL,
0x0000001025257824ULL, 0x000fc400078e0200ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000006c6c783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707231ULL, 0x086fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x000000056c6c7231ULL, 0x088fe400003400ffULL, 0x000000056e6e7231ULL, 0x000fe400003400ffULL,
0x000000046d6d7231ULL, 0x080fe400003400ffULL, 0x000000046f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff86a237812ULL, 0x000fe200078ee223ULL,
0x00000000257c783bULL, 0x000f220000004200ULL, 0x00000001021f7824ULL, 0x000fe200078e021fULL,
0x0000105000007945ULL, 0x000fe40003800000ULL, 0x0000001023237824ULL, 0x000fca00078e0200ULL,
0x000000002378783bULL, 0x000ee20000004200ULL, 0x000001007c917824ULL, 0x010fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001147eULL, 0x000001007d947824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe2000001147cULL, 0x0000007c006a7306ULL, 0x000fe20000009400ULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x000001007ea77824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011494ULL, 0x000001007fab7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x008fe20000011479ULL, 0x0000010078b97824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001147fULL, 0x0000008100ac7306ULL, 0x000fe20000209400ULL,
0x00000018ffa07819ULL, 0x000fe2000001147bULL, 0x0000010079bc7824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fc4000001147dULL, 0x00000018ff977819ULL, 0x000fe4000001147aULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x0000008100ad7306ULL, 0x000fe20000205400ULL,
0x00000018ffb07819ULL, 0x000fe400000114abULL, 0x00000018ffb97819ULL, 0x000fe400000114b9ULL,
0x00000018ffc27819ULL, 0x000fc600000114bcULL, 0x00000081008d7306ULL, 0x000ff0000020d400ULL,
0x0000009200c67306ULL, 0x000ff00000209400ULL, 0x0000009200c77306ULL, 0x000ff00000205400ULL,
0x0000009200817306ULL, 0x000ff0000020d400ULL, 0x0000009100927306ULL, 0x000ff00000209400ULL,
0x0000009100937306ULL, 0x000ef00000205400ULL, 0x0000002500967306ULL, 0x000ff00000209400ULL,
0x0000002500997306ULL, 0x000fe20000205400ULL, 0x000000939200720bULL, 0x008fce0003fbd000ULL,
0x0000002500987306ULL, 0x0007f0000020d400ULL, 0x0000007c006b7306ULL, 0x000f220000005400ULL,
0x00000018ff257819ULL, 0x008fce0000011478ULL, 0x0000007c00767306ULL, 0x0006b0000000d400ULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x000100007c7c7824ULL, 0x008fe200078e00ffULL,
0x0000006b6a00720bULL, 0x010fe20003fdd000ULL, 0x000001007a6a7824ULL, 0x000fc400078e00ffULL,
0x000001007b6b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000009d009f7306ULL, 0x000ee20000205400ULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000018ff6b7819ULL, 0x000fc8000001146bULL, 0x0000000176766812ULL, 0x004fe200078efcffULL,
0x0000008600b57306ULL, 0x000fe20000209400ULL, 0x000000999600720bULL, 0x000fce0003fdd000ULL,
0x0000008600b87306ULL, 0x000fe20000205400ULL, 0x0000009f9e00720bULL, 0x008fca0003f7d000ULL,
0x0000000198986812ULL, 0x000fe400078efcffULL, 0x0000008600857306ULL, 0x000ff0000020d400ULL,
0x0000002500be7306ULL, 0x000ff00000209400ULL, 0x0000002500bf7306ULL, 0x000ff00000205400ULL,
0x0000002500837306ULL, 0x000ff0000020d400ULL, 0x0000007d009a7306ULL, 0x000ff00000009400ULL,
0x0000007d009b7306ULL, 0x000eb00000005400ULL, 0x000000a000877306ULL, 0x000ff00000209400ULL,
0x000000a000867306ULL, 0x000fe20000205400ULL, 0x0000009b9a00720bULL, 0x004fce0003f9d000ULL,
0x000000a000257306ULL, 0x0005f0000020d400ULL, 0x0000008000a37306ULL, 0x000fe20000209400ULL,
0x000100007da07824ULL, 0x004fca00078e00ffULL, 0x00000018ffa07819ULL, 0x000fe400000114a0ULL,
0x0000008000a67306ULL, 0x000ff00000205400ULL, 0x0000008000777306ULL, 0x000ff0000020d400ULL,
0x0000009700887306ULL, 0x000ff00000209400ULL, 0x0000009700897306ULL, 0x000ff00000205400ULL,
0x0000009700807306ULL, 0x000ff0000020d400ULL, 0x0000009100957306ULL, 0x000eb0000020d400ULL,
0x0000007c00947306ULL, 0x000ff00000209400ULL, 0x0000007c00977306ULL, 0x000ee20000205400ULL,
0x0000000195955812ULL, 0x004fce00078efcffULL, 0x0000009d00a17306ULL, 0x000eb0000020d400ULL,
0x000000a000917306ULL, 0x000fe20000209400ULL, 0x000000979400720bULL, 0x008fce0003fbd000ULL,
0x000000a000a27306ULL, 0x000ee20000205400ULL, 0x00000001a1a13812ULL, 0x004fce00078efcffULL,
0x0000007d009c7306ULL, 0x000eb0000000d400ULL, 0x0000007c007d7306ULL, 0x000f22000020d400ULL,
0x000000a29100720bULL, 0x008fce0003f7d000ULL, 0x000000a7009d7306ULL, 0x000fe20000209400ULL,
0x000000019c9c4812ULL, 0x004fe400078efcffULL, 0x000000a6a300720bULL, 0x000fca0003f9d000ULL,
0x000000a700aa7306ULL, 0x000ea20000205400ULL, 0x000000017d7d5812ULL, 0x010fce00078efcffULL,
0x000000a000a47306ULL, 0x000ee2000020d400ULL, 0x0000000177774812ULL, 0x000fce00078efcffULL,
0x0000007e00a57306ULL, 0x000fe20000009400ULL, 0x000000aa9d00720bULL, 0x004fce0003fbd000ULL,
0x0000007e00a87306ULL, 0x000ea20000005400ULL, 0x00000001a4a43812ULL, 0x008fc800078efcffULL,
0x000000a47777723eULL, 0x000fc600000010ffULL, 0x0000007e00907306ULL, 0x000730000000d400ULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x000100007e7e7824ULL, 0x008fe200078e00ffULL,
0x000000a8a500720bULL, 0x004fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x000000b000b27306ULL, 0x000eae0000205400ULL, 0x0000000190906812ULL, 0x010fe200078efcffULL,
0x0000007f00ae7306ULL, 0x000fe20000009400ULL, 0x000000adac00720bULL, 0x000fce0003fdd000ULL,
0x0000007f00af7306ULL, 0x000ee20000005400ULL, 0x000000b2b100720bULL, 0x004fca0003f7d000ULL,
0x000000018d8d6812ULL, 0x000fe400078efcffULL, 0x0000007f008c7306ULL, 0x000530000000d400ULL,
0x000000a700a97306ULL, 0x000e62000020d400ULL, 0x000100007f7f7824ULL, 0x004fe200078e00ffULL,
0x000000afae00720bULL, 0x008fc80003f9d000ULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007e007c7306ULL, 0x000fee0000209400ULL, 0x000000018c8c4812ULL, 0x010fe200078efcffULL,
0x0000007e00ab7306ULL, 0x000ea20000205400ULL, 0x00000001a9a95812ULL, 0x002fc400078efcffULL,
0x000000b8b500720bULL, 0x000fca0003f9d000ULL, 0x000000b000b37306ULL, 0x000e70000020d400ULL,
0x0000007f00a77306ULL, 0x000fe20000209400ULL, 0x000000ab7c00720bULL, 0x004fe40003fbd000ULL,
0x0000000185854812ULL, 0x000fca00078efcffULL, 0x0000007f00b47306ULL, 0x000ea20000205400ULL,
0x00000001b3b33812ULL, 0x002fce00078efcffULL, 0x0000007e00a07306ULL, 0x000e70000020d400ULL,
0x000000b900b07306ULL, 0x000fe20000209400ULL, 0x000000b4a700720bULL, 0x004fce0003f7d000ULL,
0x000000b900bb7306ULL, 0x000ea20000205400ULL, 0x00000001a0a05812ULL, 0x002fce00078efcffULL,
0x0000007f00b67306ULL, 0x000e70000020d400ULL, 0x0000007800b77306ULL, 0x000fe20000009400ULL,
0x000000bbb000720bULL, 0x004fce0003fbd000ULL, 0x0000007800ba7306ULL, 0x000ea20000005400ULL,
0x00000001b6b63812ULL, 0x002fce00078efcffULL, 0x0000007800847306ULL, 0x0002f0000000d400ULL,
0x000000c200c37306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x000000bab700720bULL, 0x004fc80003fdd000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x000000c200c47306ULL, 0x000e6e0000205400ULL, 0x0000000184846812ULL, 0x008fe200078efcffULL,
0x0000007900c07306ULL, 0x000fe20000009400ULL, 0x000000bfbe00720bULL, 0x000fce0003fdd000ULL,
0x0000007900c17306ULL, 0x000ea20000005400ULL, 0x000000c4c300720bULL, 0x002fca0003f7d000ULL,
0x0000000183836812ULL, 0x000fe400078efcffULL, 0x0000007900827306ULL, 0x0002f0000000d400ULL,
0x000000b900bd7306ULL, 0x000f22000020d400ULL, 0x0001000079797824ULL, 0x002fe200078e00ffULL,
0x000000c1c000720bULL, 0x004fc80003f9d000ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x00000078007e7306ULL, 0x000fee0000209400ULL, 0x0000000182824812ULL, 0x008fe200078efcffULL,
0x00000078007f7306ULL, 0x000e620000205400ULL, 0x00000001bdbd5812ULL, 0x010fc800078efcffULL,
0x00000084bd84723eULL, 0x000fc600000010ffULL, 0x000000c200c57306ULL, 0x000eb0000020d400ULL,
0x0000007900927306ULL, 0x000fe20000209400ULL, 0x0000007f7e00720bULL, 0x002fce0003fbd000ULL,
0x0000007900937306ULL, 0x000e620000205400ULL, 0x00000001c5c53812ULL, 0x004fe400078efcffULL,
0x000000c7c600720bULL, 0x000fca0003f7d000ULL, 0x0000007800bc7306ULL, 0x000eb0000020d400ULL,
0x0000007900947306ULL, 0x000ee2000020d400ULL, 0x000000939200720bULL, 0x002fe40003f9d000ULL,
0x0000000181813812ULL, 0x000fca00078efcffULL, 0x0000006a00787306ULL, 0x000fe20000209400ULL,
0x00000001bcbc5812ULL, 0x004fc800078efcffULL, 0x000000bc83bc723eULL, 0x000fc600000010ffULL,
0x0000006a00797306ULL, 0x000e620000205400ULL, 0x0000000194944812ULL, 0x008fc800078efcffULL,
0x0000009481bd723eULL, 0x000fc600000010ffULL, 0x0000007a008e7306ULL, 0x000fe80000009400ULL,
0x000000bc7050723cULL, 0x080f680000041850ULL, 0x0000007a008f7306ULL, 0x000ea20000005400ULL,
0x000000797800720bULL, 0x002fe40003fbd000ULL, 0x0000008cb379723eULL, 0x000fe200000010ffULL,
0x000000bc6c30723cULL, 0x000f620000041830ULL, 0x00000090a978723eULL, 0x000fc600000010ffULL,
0x0000007b008a7306ULL, 0x000fe80000009400ULL, 0x00000078705c723cULL, 0x000f68000004185cULL,
0x0000007b008b7306ULL, 0x000e620000005400ULL, 0x0000008f8e00720bULL, 0x004fc60003fdd000ULL,
0x000000786c3c723cULL, 0x000f68000004183cULL, 0x0000007b00237306ULL, 0x0004f0000000d400ULL,
0x0000006b00917306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x0000008b8a00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff927819ULL, 0x000fe4000001147bULL,
0x0000006b009a7306ULL, 0x000e620000205400ULL, 0x000000b6857b723eULL, 0x000fe400000010ffULL,
0x00000082c585723eULL, 0x000fc800000010ffULL, 0x0000000123233812ULL, 0x008fe200078efcffULL,
0x0000007a00277306ULL, 0x0004e4000000d400ULL, 0x000000847054723cULL, 0x080f6c0000041854ULL,
0x0000009200937306ULL, 0x000fe20000209400ULL, 0x000100007a7a7824ULL, 0x004fe200078e00ffULL,
0x0000009a9100720bULL, 0x002fe20003f9d000ULL, 0x000000846c34723cULL, 0x000f660000041834ULL,
0x00000018ff7c7819ULL, 0x000fc4000001147aULL, 0x00000092008c7306ULL, 0x000e620000205400ULL,
0x0000000127276812ULL, 0x008fe400078efcffULL, 0x000000868700720bULL, 0x000fe40003fdd000ULL,
0x000000a08d7a723eULL, 0x000fc600000010ffULL, 0x0000006b009e7306ULL, 0x0004e8000020d400ULL,
0x0000007a7058723cULL, 0x080f680000041858ULL, 0x0000006a00967306ULL, 0x0008e2000020d400ULL,
0x0000008c9300720bULL, 0x002fe40003f7d000ULL, 0x0000000125256812ULL, 0x000fe200078efcffULL,
0x0000007a6c38723cULL, 0x000f620000041838ULL, 0x0000009ca16b723eULL, 0x004fc600000010ffULL,
0x0000007c007e7306ULL, 0x000fe20000209400ULL, 0x00000076956a723eULL, 0x010fe400000010ffULL,
0x000000019e9e4812ULL, 0x008fe400078efcffULL, 0x0000007d9876723eULL, 0x000fe400000010ffULL,
0x000000239e97723eULL, 0x000fe200000010ffULL, 0x0000007c007f7306ULL, 0x000e620000205400ULL,
0x0000000196965812ULL, 0x000fe200078efcffULL, 0x0000006a7064723cULL, 0x000f620000041864ULL,
0x000000898800720bULL, 0x000fc40003fbd000ULL, 0x0000000222237812ULL, 0x000fe400078efcffULL,
0x000000279696723eULL, 0x000fe200000010ffULL, 0x0000009200927306ULL, 0x000ea4000020d400ULL,
0x0000000126237824ULL, 0x000fe200078e0223ULL, 0x0000006a6c44723cULL, 0x000b620000041844ULL,
0x0000000802267824ULL, 0x000fe400078e00ffULL, 0x0000000103227824ULL, 0x100fe400078e0223ULL,
0x0000007c007d7306ULL, 0x000ee2000020d400ULL, 0x0000007f7e00720bULL, 0x002fe20003f9d000ULL,
0x0000000102237824ULL, 0x000fe200078e0223ULL, 0x0000000180805812ULL, 0x000fe200078efcffULL,
0x00000008026a7824ULL, 0x020fe200078e00ffULL, 0x000000767060723cULL, 0x000f640000041860ULL,
0xfffffff826267812ULL, 0x000fc400078ee223ULL, 0x0000000192923812ULL, 0x004fc600078efcffULL,
0x0000001026267824ULL, 0x000fe200078e0221ULL, 0x000000922581723eULL, 0x000fe200000010ffULL,
0x0000000803257824ULL, 0x000fe200078e00ffULL, 0x00000096704c723cULL, 0x000f62000004184cULL,
0x000000017d7d4812ULL, 0x008fc600078efcffULL, 0xfffffff825227812ULL, 0x000fe400078ee222ULL,
0x0000007d8080723eULL, 0x000fe400000010ffULL, 0x000000766c40723cULL, 0x000f620000041840ULL,
0x0000001022227824ULL, 0x000fe200078e0221ULL, 0xfffffff86a217812ULL, 0x000fe400078ee21fULL,
0x000000021f1f7810ULL, 0x000fc60007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x000000807048723cULL, 0x000b640000041848ULL, 0x000000002270783bULL, 0x0202ac0000000200ULL,
0x000000966c2c723cULL, 0x040f70000004182cULL, 0x000000806c28723cULL, 0x000b640000041828ULL,
0x00000000266c783bULL, 0x0202e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000770707231ULL, 0x084fe400003400ffULL,
0x0000000772727231ULL, 0x000fc400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fe400003400ffULL, 0x000000056c6c7231ULL, 0x088fe400003400ffULL,
0x000000056e6e7231ULL, 0x000fe400003400ffULL, 0x000000046d6d7231ULL, 0x080fe400003400ffULL,
0x000000046f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff86a1f7812ULL, 0x000fe200078ee21fULL, 0x000000002178783bULL, 0x000f280000004200ULL,
0x000000101f1f7824ULL, 0x000fca00078e0200ULL, 0x000000001f7c783bULL, 0x000e640000004200ULL,
0x0000007800227306ULL, 0x012fe20000009400ULL, 0x00000018ff217819ULL, 0x000fe20000011478ULL,
0x00000100788b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011479ULL,
0x00000100798e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe2000001147bULL,
0x000001007aa17824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001147aULL,
0x0000007800237306ULL, 0x000e620000005400ULL, 0x00000018ff917819ULL, 0x000fe2000001147eULL,
0x000001007ba57824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001147fULL,
0x000001007cb37824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe2000001148eULL,
0x000001007db67824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe2000001147dULL,
0x00000078008a7306ULL, 0x0008e2000000d400ULL, 0x00000018ff8b7819ULL, 0x000fc4000001148bULL,
0x00000018ffa17819ULL, 0x000fe400000114a1ULL, 0x00000018ffaa7819ULL, 0x000fe400000114a5ULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000002100907306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x010fe200078e00ffULL, 0x000000232200720bULL, 0x002fe20003f7d000ULL,
0x000001007e227824ULL, 0x000fe200078e00ffULL, 0x00000018ffbc7819ULL, 0x000fe200000114b6ULL,
0x000001007f237824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fc40000011478ULL,
0x0000002100937306ULL, 0x000fe20000205400ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff237819ULL, 0x000fc80000011423ULL, 0x000000018a8a3812ULL, 0x008fe200078efcffULL,
0x0000002100927306ULL, 0x0003f0000020d400ULL, 0x00000026009d7306ULL, 0x000fe20000209400ULL,
0x00000018ff217819ULL, 0x002fce000001147cULL, 0x0000002600a07306ULL, 0x000ff00000205400ULL,
0x0000002600897306ULL, 0x000ff0000020d400ULL, 0x0000009100817306ULL, 0x000ff00000209400ULL,
0x0000009100847306ULL, 0x000ff00000205400ULL, 0x0000009100267306ULL, 0x000ff0000020d400ULL,
0x0000008200af7306ULL, 0x000ff00000209400ULL, 0x0000008200b27306ULL, 0x000ff00000205400ULL,
0x0000008200777306ULL, 0x000ff0000020d400ULL, 0x0000002100b87306ULL, 0x000ff00000209400ULL,
0x0000002100b97306ULL, 0x000ff00000205400ULL, 0x00000021006b7306ULL, 0x000ff0000020d400ULL,
0x00000078008e7306ULL, 0x000ff00000209400ULL, 0x0000007800917306ULL, 0x000e700000205400ULL,
0x0000009a00857306ULL, 0x000ff00000209400ULL, 0x0000009a00827306ULL, 0x000fe20000205400ULL,
0x000000918e00720bULL, 0x002fce0003fdd000ULL, 0x0000009a00217306ULL, 0x0003f0000020d400ULL,
0x0000006a00a67306ULL, 0x000fe20000209400ULL, 0x00010000799a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe4000001149aULL, 0x0000006a00a77306ULL, 0x000ff00000205400ULL,
0x0000006a00877306ULL, 0x000ff0000020d400ULL, 0x0000008c00bf7306ULL, 0x000ff00000209400ULL,
0x0000008c00c47306ULL, 0x000ff00000205400ULL, 0x0000008c006a7306ULL, 0x000ff0000020d400ULL,
0x0000007900947306ULL, 0x000ff00000009400ULL, 0x0000007900957306ULL, 0x000e700000005400ULL,
0x0000008b008c7306ULL, 0x000ff00000209400ULL, 0x0000008b008d7306ULL, 0x000ee20000205400ULL,
0x000000959400720bULL, 0x002fce0003f9d000ULL, 0x0000008b008f7306ULL, 0x000e70000020d400ULL,
0x0000009a008b7306ULL, 0x000fe20000209400ULL, 0x0000008d8c00720bULL, 0x008fce0003f1d000ULL,
0x0000009a009c7306ULL, 0x000eec0000205400ULL, 0x000000018f8f0812ULL, 0x002fe400078efcffULL,
0x0000007900967306ULL, 0x000e62000000d400ULL, 0x000000939000720bULL, 0x000fce0003f1d000ULL,
0x0000009700987306ULL, 0x000fe20000209400ULL, 0x0000009c8b00720bULL, 0x008fca0003f7d000ULL,
0x0000000192920812ULL, 0x000fe400078efcffULL, 0x0000009700997306ULL, 0x000ee20000205400ULL,
0x0000000196964812ULL, 0x002fe400078efcffULL, 0x000000a09d00720bULL, 0x000fca0003f9d000ULL,
0x00000097009b7306ULL, 0x000e70000020d400ULL, 0x0000007800797306ULL, 0x000f22000020d400ULL,
0x000000999800720bULL, 0x008fe40003fbd000ULL, 0x0000000189894812ULL, 0x000fca00078efcffULL,
0x000000a100977306ULL, 0x000fec0000209400ULL, 0x000000019b9b5812ULL, 0x002fe400078efcffULL,
0x000000a100a47306ULL, 0x000e620000205400ULL, 0x0000000179796812ULL, 0x010fce00078efcffULL,
0x0000009a009e7306ULL, 0x000ef0000020d400ULL, 0x0000007b00a87306ULL, 0x000fe20000009400ULL,
0x000000a49700720bULL, 0x002fce0003fdd000ULL, 0x0000007b00a97306ULL, 0x000e620000005400ULL,
0x000000019e9e3812ULL, 0x008fce00078efcffULL, 0x000000a100a37306ULL, 0x000ef0000020d400ULL,
0x0000007a009f7306ULL, 0x000fe20000009400ULL, 0x000000a9a800720bULL, 0x002fce0003f7d000ULL,
0x0000007a00a27306ULL, 0x000e620000005400ULL, 0x00000001a3a36812ULL, 0x008fe400078efcffULL,
0x000000a7a600720bULL, 0x000fca0003fdd000ULL, 0x0000007a00887306ULL, 0x0007f0000000d400ULL,
0x0000007b00867306ULL, 0x0008a2000000d400ULL, 0x000100007a7a7824ULL, 0x008fe200078e00ffULL,
0x000000a29f00720bULL, 0x002fc40003fbd000ULL, 0x0000000187876812ULL, 0x000fe400078efcffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000100007b7b7824ULL, 0x010fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000aa00ac7306ULL, 0x000e620000205400ULL, 0x0000000186863812ULL, 0x004fe400078efcffULL,
0x0000000188885812ULL, 0x000fca00078efcffULL, 0x000000aa00ad7306ULL, 0x000eb0000020d400ULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x000000acab00720bULL, 0x002fce0003f1d000ULL,
0x0000007a00a57306ULL, 0x000e6c0000205400ULL, 0x00000001adad0812ULL, 0x004fe400078efcffULL,
0x000000b300aa7306ULL, 0x000fe20000209400ULL, 0x000000b2af00720bULL, 0x000fce0003f1d000ULL,
0x000000b300b57306ULL, 0x000ea20000205400ULL, 0x000000a57800720bULL, 0x002fe40003f9d000ULL,
0x000000799278723eULL, 0x000fe400000010ffULL, 0x0000009e8979723eULL, 0x000fe400000010ffULL,
0x0000000177770812ULL, 0x000fe200078efcffULL, 0x0000007b00a17306ULL, 0x000fe80000209400ULL,
0x000000787060723cULL, 0x000b680000041860ULL, 0x0000007b00ae7306ULL, 0x000e620000205400ULL,
0x000000b5aa00720bULL, 0x004fc60003f7d000ULL, 0x000000786c40723cULL, 0x000b680000041840ULL,
0x000000bc00bd7306ULL, 0x000ff00000209400ULL, 0x000000bc00be7306ULL, 0x000ea20000205400ULL,
0x000000aea100720bULL, 0x002fce0003fbd000ULL, 0x0000007c00b17306ULL, 0x000ff00000009400ULL,
0x0000007c00b47306ULL, 0x000fe20000005400ULL, 0x000000bebd00720bULL, 0x004fce0003fdd000ULL,
0x0000007c00767306ULL, 0x0003f0000000d400ULL, 0x0000007d00ba7306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00bb7306ULL, 0x000ff00000005400ULL, 0x0000007d00277306ULL, 0x0003f0000000d400ULL,
0x0000007a009a7306ULL, 0x000ea2000020d400ULL, 0x000100007d7d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007b00b07306ULL, 0x000e70000020d400ULL,
0x000000b300b77306ULL, 0x000ee2000020d400ULL, 0x000000019a9a4812ULL, 0x004fc400078efcffULL,
0x000000b4b100720bULL, 0x000fe40003f9d000ULL, 0x0000009a879a723eULL, 0x000fc600000010ffULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x00000001b0b05812ULL, 0x002fe400078efcffULL,
0x000000bbba00720bULL, 0x000fca0003fbd000ULL, 0x0000007c007b7306ULL, 0x000e620000205400ULL,
0x00000001b7b73812ULL, 0x008fe400078efcffULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x000000b9b800720bULL, 0x000fe40003f9d000ULL, 0x00000076b776723eULL, 0x000fe200000010ffULL,
0x000000bc00c07306ULL, 0x000ea2000020d400ULL, 0x0000000127275812ULL, 0x000fe400078efcffULL,
0x000000c4bf00720bULL, 0x000fca0003fbd000ULL, 0x0000007d00b37306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x002fe40003f7d000ULL, 0x000000016b6b4812ULL, 0x000fe400078efcffULL,
0x00000088a37a723eULL, 0x000fe400000010ffULL, 0x00000086ad7b723eULL, 0x000fe200000010ffULL,
0x0000007d00c27306ULL, 0x000e620000205400ULL, 0x00000001c0c06812ULL, 0x004fe400078efcffULL,
0x000000016a6a5812ULL, 0x000fc400078efcffULL, 0x000000848100720bULL, 0x000fe20003fbd000ULL,
0x0000007a705c723cULL, 0x080b64000004185cULL, 0x0000007c00b67306ULL, 0x000eac000020d400ULL,
0x0000007a6c3c723cULL, 0x000b64000004183cULL, 0x00000022007c7306ULL, 0x000fe20000209400ULL,
0x000000c2b300720bULL, 0x002fc40003fdd000ULL, 0x0000000126265812ULL, 0x000fca00078efcffULL,
0x00000022008b7306ULL, 0x000e620000205400ULL, 0x00000001b6b63812ULL, 0x004fc800078efcffULL,
0x000000b66bb6723eULL, 0x000fc600000010ffULL, 0x0000007d008d7306ULL, 0x000eb0000020d400ULL,
0x0000007e00c17306ULL, 0x000fe20000009400ULL, 0x0000008b7c00720bULL, 0x002fce0003f7d000ULL,
0x0000007e00c67306ULL, 0x000e620000005400ULL, 0x000000018d8d6812ULL, 0x004fc800078efcffULL,
0x0000008d6ab7723eULL, 0x000fe400000010ffULL, 0x0001a6c8136a7811ULL, 0x000fe200078e18ffULL,
0x00000023008e7306ULL, 0x000fe80000209400ULL, 0x000000b67050723cULL, 0x000b680000041850ULL,
0x0000002300917306ULL, 0x000ea20000205400ULL, 0x000000c6c100720bULL, 0x002fc60003f1d000ULL,
0x000000b66c30723cULL, 0x000b680000041830ULL, 0x0000007e00257306ULL, 0x0002f0000000d400ULL,
0x0000007f00807306ULL, 0x000fe20000009400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x000000918e00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00837306ULL, 0x000e620000005400ULL, 0x0000000125250812ULL, 0x008fce00078efcffULL,
0x0000007f001f7306ULL, 0x0004f0000000d400ULL, 0x00000022008c7306ULL, 0x0008e2000020d400ULL,
0x000100007f7f7824ULL, 0x004fe200078e00ffULL, 0x000000838000720bULL, 0x002fcc0003f9d000ULL,
0x0000002300907306ULL, 0x0002a2000020d400ULL, 0x0000008a8f22723eULL, 0x010fe400000010ffULL,
0x00000018ff8f7819ULL, 0x000fc8000001147fULL, 0x000000011f1f4812ULL, 0x008fe200078efcffULL,
0x0000007e007d7306ULL, 0x000fe20000209400ULL, 0x000000018c8c3812ULL, 0x000fe400078efcffULL,
0x000000828500720bULL, 0x000fe40003f7d000ULL, 0x000000969b23723eULL, 0x002fe400000010ffULL,
0x000000b0779b723eULL, 0x000fe200000010ffULL, 0x0000007e008a7306ULL, 0x000e620000205400ULL,
0x0000000190906812ULL, 0x004fc400078efcffULL, 0x00000027c077723eULL, 0x000fe200000010ffULL,
0x000000227064723cULL, 0x040b620000041864ULL, 0x000000258c8c723eULL, 0x000fe400000010ffULL,
0x0000001f908d723eULL, 0x000fe200000010ffULL, 0x0000008f00897306ULL, 0x000fe20000209400ULL,
0x0000000121213812ULL, 0x000fe200078efcffULL, 0x000000021a1f7824ULL, 0x000fe400078e00ffULL,
0x0000009a7058723cULL, 0x000b660000041858ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ec0ffULL,
0x0000008f007c7306ULL, 0x000ea20000205400ULL, 0x0000008a7d00720bULL, 0x002fc60003f1d000ULL,
0x000000767054723cULL, 0x040b680000041854ULL, 0x0000007e007f7306ULL, 0x000e68000020d400ULL,
0x0000008c704c723cULL, 0x000b68000004184cULL, 0x0000008f00807306ULL, 0x000ee2000020d400ULL,
0x0000007c8900720bULL, 0x004fc60003fdd000ULL, 0x000000226c44723cULL, 0x000b620000041844ULL,
0x000000017f7f0812ULL, 0x002fc800078efcffULL, 0x0000007f2626723eULL, 0x000fc600000010ffULL,
0x0000009a6c38723cULL, 0x000b640000041838ULL, 0x0000000180806812ULL, 0x008fc800078efcffULL,
0x000000802127723eULL, 0x000fe400000010ffULL, 0x000000766c34723cULL, 0x000b700000041834ULL,
0x000000267048723cULL, 0x000b700000041848ULL, 0x0000008c6c2c723cULL, 0x040b70000004182cULL,
0x000000266c28723cULL, 0x000b620000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a688001fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff217224ULL, 0x000fc600078e00ffULL, 0x0000000000227805ULL, 0x020fc80000015200ULL,
0x000004000d1f7984ULL, 0x004ea40000000800ULL, 0x800000001fff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e23ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000121217810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000800c217810ULL, 0x000fca0007ffe0ffULL,
0x0000660012257a24ULL, 0x000fe200078e0221ULL, 0x000003d00000a947ULL, 0x000fea0003800000ULL,
0x00000021161f7217ULL, 0x000fe20007800000ULL, 0x00000010116e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x000fc60000011617ULL, 0x000000011f1f7824ULL, 0x000fe200078e0a21ULL,
0x00000004276b7810ULL, 0x040fe20007ffe0ffULL, 0x000000016e227824ULL, 0x040fe200078e0227ULL,
0x00000008276d7810ULL, 0x040fe40007ffe0ffULL, 0x0000001f6e1f7217ULL, 0x000fe20007800000ULL,
0x0000000122217824ULL, 0x040fe200078e0217ULL, 0x0000000c276f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000822267824ULL, 0x000fe400078e00ffULL, 0x000000016e707824ULL, 0x000fc400078e026bULL,
0x0000000122227824ULL, 0x000fe200078e0225ULL, 0xfffffff826217812ULL, 0x000fe200078ee221ULL,
0x000000011f1f7824ULL, 0x000fe400078e0a6eULL, 0x0000000170267824ULL, 0x000fe400078e0225ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000001f2700720cULL, 0x080fe40003f06070ULL,
0x0000001f6b00720cULL, 0x000fe20003f86070ULL, 0x000000016e727824ULL, 0x000fe200078e026dULL,
0x0000000b226c7212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000001f6d00720cULL, 0x000fc40003f66070ULL, 0x000062006c6c7a10ULL, 0x000fe20007fbe0ffULL,
0x00000001726a7824ULL, 0x000fe200078e0225ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x000000016e6e7824ULL, 0x000fe200078e026fULL, 0x00006300236d7a10ULL, 0x000fe20002ffe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe40007fde0ffULL,
0x0000001f6f00720cULL, 0x000fe20003fa6070ULL, 0x000000016e227824ULL, 0x000fe200078e0225ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x0000000170257824ULL, 0x000fe200078e0217ULL,
0x0000630027277a10ULL, 0x000fe200037fe4ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x000062006a6a7a10ULL, 0x000fc60007fde0ffULL, 0x0000000870707824ULL, 0x000fe200078e00ffULL,
0x0000000b22227212ULL, 0x000fe200078efcffULL, 0x00000001721f7824ULL, 0x040fe200078e0217ULL,
0x000063006b6b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000872727824ULL, 0x000fe200078e00ffULL,
0xfffffff870257812ULL, 0x000fe200078ee225ULL, 0x000000016e6f7824ULL, 0x000fe200078e0217ULL,
0x0000620022227a10ULL, 0x000fe20007fde0ffULL, 0x000000086e6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8721f7812ULL, 0x000fe200078ee21fULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0x0000630023237a10ULL, 0x000fe200037fe4ffULL, 0x0000001025257824ULL, 0x100fe200078e0200ULL,
0xfffffff86e6f7812ULL, 0x000fe200078ee26fULL, 0x000000101f1f7824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c217faeULL, 0x0003e6000c101c48ULL,
0x000000106f6f7824ULL, 0x000fe200078e0200ULL, 0x0000000026257faeULL, 0x0003e8000e101c48ULL,
0x000000006a1f7faeULL, 0x0003e8000d901c48ULL, 0x00000000226f7faeULL, 0x0003e2000e901c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001011227824ULL, 0x000fca00078e00ffULL,
0x0000002217267211ULL, 0x000fc800078fe8ffULL, 0x00000004266a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001261f7824ULL, 0x140fe200078e0217ULL, 0x00000008266c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000826227824ULL, 0x000fe400078e00ffULL, 0x000000016a217824ULL, 0x040fe400078e0217ULL,
0x000000086a6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8221f7812ULL, 0x000fe200078ee21fULL,
0x000000016c237824ULL, 0x040fe400078e0217ULL, 0x000000086c707824ULL, 0x000fe200078e00ffULL,
0xfffffff86e217812ULL, 0x000fe200078ee221ULL, 0x0000000126227824ULL, 0x140fe200078e0225ULL,
0x0000000c266e7810ULL, 0x000fe20007ffe0ffULL, 0x000000016a267824ULL, 0x000fe200078e0225ULL,
0xfffffff8706f7812ULL, 0x000fe200078ee223ULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x000000016c6a7824ULL, 0x100fe200078e0225ULL, 0x0000000b22227212ULL, 0x000fe200078efcffULL,
0x000000016e6c7824ULL, 0x000fe400078e0225ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fc60007f1e0ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000630023237a10ULL, 0x000fe200007fe4ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000000b6a6a7212ULL, 0x080fe400078efcffULL,
0x0000620026267a10ULL, 0x000fe20007f7e0ffULL, 0x000000016e257824ULL, 0x000fe200078e0217ULL,
0x0000000b6c6c7212ULL, 0x000fe200078efcffULL, 0x000000086e6e7824ULL, 0x000fe200078e00ffULL,
0x000062006a6a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0200ULL,
0x000062006c6c7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0xfffffff86e257812ULL, 0x000fe200078ee225ULL, 0x000000106f6f7824ULL, 0x100fe200078e0200ULL,
0x0000630027277a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000221f7faeULL, 0x0003e2000b901c48ULL, 0x000063006b6b7a10ULL, 0x000fe200007fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0x000063006d6d7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026217faeULL, 0x0003e8000b901c48ULL, 0x000000006a6f7faeULL, 0x0003e8000b901c48ULL,
0x000000006c257faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000080503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a62800206a7f8cULL, 0x000664000c80043fULL,
0x0000000000227805ULL, 0x000fc40000015200ULL, 0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL,
0x0000001014267812ULL, 0x000fca00078ec0ffULL, 0x000000011f267824ULL, 0x000fc800078e0226ULL,
0x0000000811217824ULL, 0x000fca00078e0226ULL, 0x01a62c00211f7984ULL, 0x000f240000000800ULL,
0x800000001fff7812ULL, 0x012fe4000780486bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e23ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c00211f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a1f7824ULL, 0x000fca00078e00ffULL,
0xffffff801f227812ULL, 0x000fc800078ec0ffULL, 0x000000800b1f7810ULL, 0x000fca0007ffe022ULL,
0x000000010a1f7824ULL, 0x000fca00078e021fULL, 0x01a000001f217984ULL, 0x000e680000000800ULL,
0x01a200001f227984ULL, 0x0006a20000000800ULL, 0x0000001e2100720bULL, 0x002fe20003f1d000ULL,
0x000165227f007947ULL, 0x000fd8000b800000ULL, 0x00000000001f7806ULL, 0x008fc800000e0100ULL,
0x000000ff1f00720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e001eULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000110237810ULL, 0x000fe40007ffe0ffULL,
0x0000001e2100720bULL, 0x000fe40003f74000ULL, 0x0000001a2300720cULL, 0x000fe20003f05270ULL,
0x000164e27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000707806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x0000001e21237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a268824ULL, 0x000fca00078e0225ULL,
0x01a4002326008388ULL, 0x0003e20000000800ULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001e231e7221ULL, 0x002fe20000010100ULL,
0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e00277308ULL, 0x000e640000000800ULL,
0x0000002724247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x000164327f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x000fc40000410000ULL, 0x000000264c4c7220ULL, 0x080fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x000163127f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00066400000e0000ULL,
0x0000002666667220ULL, 0x086fe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x000fc40000410000ULL,
0x000000264e4e7220ULL, 0x080fe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x000161f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x000000262c2c7220ULL, 0x080fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002628287220ULL, 0x080fe40000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000070ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x000160e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x000fc40000410000ULL, 0x000000262e2e7220ULL, 0x080fe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x000000262a2a7220ULL, 0x080fe40000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000701fff7212ULL, 0x000fda00078030ffULL, 0x8000002321210221ULL, 0x000fe20000010000ULL,
0x00007610ff6e0816ULL, 0x000fc6000000006eULL, 0x3fb8aa3b21210820ULL, 0x000fc80000410000ULL,
0x0000002100090308ULL, 0x000e640000000800ULL, 0x0000000922220220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002422247221ULL, 0x004fc40000010000ULL,
0x00000000001e7805ULL, 0x000fca0000015200ULL, 0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL,
0x01a6b4006a217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x008fcc0000015200ULL, 0x000000261e227210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e1fULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc80000011426ULL,
0x0000002221217211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0626ULL,
0x0000000221217819ULL, 0x000fc80000001222ULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b4006a217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106e1e7816ULL, 0x000fc800000000ffULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff1e7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x008fe20000000004ULL,
0x00015ce27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e27077589ULL, 0x0002a400000e0000ULL,
0x000000081e267810ULL, 0x000fe20007ffe0ffULL, 0x00015d227f007947ULL, 0x000fea000b800000ULL,
0x000000101e047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000181e267810ULL, 0x008fe20007ffe0ffULL,
0x00015d927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x000000041a1e7824ULL, 0x042fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a217824ULL, 0x040fe200078e00ffULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x000010001a1f7824ULL, 0x000fe200078e00ffULL, 0x000000041e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000803267824ULL, 0x008fe200078e00ffULL, 0xfffff00021217812ULL, 0x000fe200078ec0ffULL,
0x0000000803277824ULL, 0x000fe200078e00ffULL, 0x0000001e171e7211ULL, 0x000fc400078fe0ffULL,
0x0001300021217810ULL, 0x000fe40007ffe0ffULL, 0xffffe0001f227812ULL, 0x000fe200078ec0ffULL,
0x00000001031f7824ULL, 0x000fe400078e021eULL, 0x000000101c707824ULL, 0x100fe200078e0221ULL,
0x0001700022257810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0221ULL,
0xfffffff8261c7812ULL, 0x000fe400078ee21fULL, 0x000000021f227810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000e640000000200ULL, 0x000000101c7c7824ULL, 0x000fc400078e0225ULL,
0x000000001d68783bULL, 0x0006a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707231ULL, 0x086fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fe400003400ffULL,
0x0000000568687231ULL, 0x080fe400003400ffULL, 0x000000056a6a7231ULL, 0x000fc400003400ffULL,
0x0000000469697231ULL, 0x080fe400003400ffULL, 0x000000046b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff827227812ULL, 0x000fe200078ee222ULL,
0x000000007c7c783bULL, 0x000f220000004200ULL, 0x0000109000007945ULL, 0x000fe60003800000ULL,
0x0000001022787824ULL, 0x000fcc00078e0225ULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x000001007c8f7824ULL, 0x010fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001147eULL,
0x000001007d927824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001147cULL,
0x0000007c00267306ULL, 0x000fe20000009400ULL, 0x00000018ff8f7819ULL, 0x000fe2000001148fULL,
0x000001007ea57824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011492ULL,
0x000001007fa97824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001147fULL,
0x0000010078b77824ULL, 0x008fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe20000011479ULL,
0x0000006f00aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff9e7819ULL, 0x000fe2000001147bULL,
0x0000010079ba7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fc4000001147dULL,
0x00000018ff957819ULL, 0x000fe4000001147aULL, 0x00000018ffa57819ULL, 0x000fe200000114a5ULL,
0x0000006f00ab7306ULL, 0x000fe20000205400ULL, 0x00000018ffae7819ULL, 0x000fe400000114a9ULL,
0x00000018ffb77819ULL, 0x000fe400000114b7ULL, 0x00000018ffc07819ULL, 0x000fc600000114baULL,
0x0000006f008b7306ULL, 0x000ff0000020d400ULL, 0x0000009000c47306ULL, 0x000ff00000209400ULL,
0x0000009000c57306ULL, 0x000ff00000205400ULL, 0x00000090006f7306ULL, 0x000ff0000020d400ULL,
0x0000008f00907306ULL, 0x000ff00000209400ULL, 0x0000008f00917306ULL, 0x000ef00000205400ULL,
0x0000001f00947306ULL, 0x000ff00000209400ULL, 0x0000001f00977306ULL, 0x000fe20000205400ULL,
0x000000919000720bULL, 0x008fce0003fbd000ULL, 0x0000001f00967306ULL, 0x0007f0000020d400ULL,
0x0000007c00277306ULL, 0x000f220000005400ULL, 0x00000018ff1f7819ULL, 0x008fce0000011478ULL,
0x0000007c00767306ULL, 0x0006b0000000d400ULL, 0x0000007d00987306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x008fe200078e00ffULL, 0x000000272600720bULL, 0x010fe20003fdd000ULL,
0x000001007a267824ULL, 0x000fc400078e00ffULL, 0x000001007b277824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00997306ULL, 0x000ee20000005400ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff277819ULL, 0x000fc80000011427ULL,
0x0000000176766812ULL, 0x004fe200078efcffULL, 0x0000009b009c7306ULL, 0x000fe20000209400ULL,
0x000000979400720bULL, 0x000fce0003fdd000ULL, 0x0000009b009d7306ULL, 0x000ea20000205400ULL,
0x000000999800720bULL, 0x008fca0003f9d000ULL, 0x0000000196966812ULL, 0x000fe400078efcffULL,
0x0000008600b37306ULL, 0x000ff00000209400ULL, 0x0000008600b67306ULL, 0x000fe20000205400ULL,
0x0000009d9c00720bULL, 0x004fce0003f7d000ULL, 0x0000008600837306ULL, 0x000ff0000020d400ULL,
0x0000001f00bc7306ULL, 0x000ff00000209400ULL, 0x0000001f00bd7306ULL, 0x000ff00000205400ULL,
0x0000001f00817306ULL, 0x000ff0000020d400ULL, 0x0000009e00897306ULL, 0x000ff00000209400ULL,
0x0000009e00867306ULL, 0x000ff00000205400ULL, 0x0000009e001f7306ULL, 0x0005f0000020d400ULL,
0x0000006e00a17306ULL, 0x000fe20000209400ULL, 0x000100007d9e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe4000001149eULL, 0x0000006e00a47306ULL, 0x000ff00000205400ULL,
0x0000006e00777306ULL, 0x000ff0000020d400ULL, 0x0000009500857306ULL, 0x000ff00000209400ULL,
0x0000009500887306ULL, 0x000ff00000205400ULL, 0x00000095006e7306ULL, 0x000ff0000020d400ULL,
0x0000008f00937306ULL, 0x000eb0000020d400ULL, 0x0000007c00927306ULL, 0x000ff00000209400ULL,
0x0000007c00957306ULL, 0x000ee20000205400ULL, 0x0000000193935812ULL, 0x004fce00078efcffULL,
0x0000007d009a7306ULL, 0x000eb0000000d400ULL, 0x0000009b009f7306ULL, 0x000f22000020d400ULL,
0x000000959200720bULL, 0x008fce0003fbd000ULL, 0x0000009e008f7306ULL, 0x000fe20000209400ULL,
0x000000019a9a4812ULL, 0x004fe400078efcffULL, 0x000000a4a100720bULL, 0x000fca0003f9d000ULL,
0x0000009e00a07306ULL, 0x000ea20000205400ULL, 0x000000019f9f3812ULL, 0x010fce00078efcffULL,
0x0000007c007d7306ULL, 0x000ee2000020d400ULL, 0x0000000177774812ULL, 0x000fce00078efcffULL,
0x000000a5009b7306ULL, 0x000fe20000209400ULL, 0x000000a08f00720bULL, 0x004fce0003f7d000ULL,
0x000000a500a87306ULL, 0x000ea20000205400ULL, 0x000000017d7d5812ULL, 0x008fce00078efcffULL,
0x0000009e00a27306ULL, 0x000ef0000020d400ULL, 0x0000007e00a37306ULL, 0x000fe20000009400ULL,
0x000000a89b00720bULL, 0x004fce0003fbd000ULL, 0x0000007e00a67306ULL, 0x000ea20000005400ULL,
0x00000001a2a23812ULL, 0x008fc800078efcffULL, 0x000000a27777723eULL, 0x000fc600000010ffULL,
0x0000007e008e7306ULL, 0x000730000000d400ULL, 0x0000007f00ac7306ULL, 0x000fe20000009400ULL,
0x000100007e7e7824ULL, 0x008fe200078e00ffULL, 0x000000a6a300720bULL, 0x004fc80003fdd000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007f00ad7306ULL, 0x000eae0000005400ULL,
0x000000018e8e6812ULL, 0x010fe200078efcffULL, 0x000000ae00af7306ULL, 0x000fe20000209400ULL,
0x000000abaa00720bULL, 0x000fce0003fdd000ULL, 0x000000ae00b07306ULL, 0x000ee20000205400ULL,
0x000000adac00720bULL, 0x004fca0003f9d000ULL, 0x000000018b8b6812ULL, 0x000fe400078efcffULL,
0x0000007f008a7306ULL, 0x000530000000d400ULL, 0x000000a500a77306ULL, 0x000e62000020d400ULL,
0x000100007f7f7824ULL, 0x004fe200078e00ffULL, 0x000000b0af00720bULL, 0x008fc80003f7d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000007e007c7306ULL, 0x000fe20000209400ULL,
0x000000018a8a4812ULL, 0x010fe400078efcffULL, 0x000000b6b300720bULL, 0x000fca0003f9d000ULL,
0x0000007e00a97306ULL, 0x000ea20000205400ULL, 0x00000001a7a75812ULL, 0x002fce00078efcffULL,
0x000000ae00b17306ULL, 0x000e62000020d400ULL, 0x0000000183834812ULL, 0x000fce00078efcffULL,
0x0000007f00a57306ULL, 0x000fe20000209400ULL, 0x000000a97c00720bULL, 0x004fce0003fbd000ULL,
0x0000007f00b27306ULL, 0x000ea20000205400ULL, 0x00000001b1b13812ULL, 0x002fce00078efcffULL,
0x0000007e009e7306ULL, 0x000e70000020d400ULL, 0x000000b700ae7306ULL, 0x000fe20000209400ULL,
0x000000b2a500720bULL, 0x004fce0003f7d000ULL, 0x000000b700b97306ULL, 0x000ea20000205400ULL,
0x000000019e9e5812ULL, 0x002fce00078efcffULL, 0x0000007f00b47306ULL, 0x000e70000020d400ULL,
0x0000007800b57306ULL, 0x000fe20000009400ULL, 0x000000b9ae00720bULL, 0x004fce0003fbd000ULL,
0x0000007800b87306ULL, 0x000ea20000005400ULL, 0x00000001b4b43812ULL, 0x002fce00078efcffULL,
0x0000007800827306ULL, 0x0002f0000000d400ULL, 0x0000007900be7306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x002fe200078e00ffULL, 0x000000b8b500720bULL, 0x004fc80003fdd000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900bf7306ULL, 0x000e6e0000005400ULL,
0x0000000182826812ULL, 0x008fe200078efcffULL, 0x000000c000c17306ULL, 0x000fe20000209400ULL,
0x000000bdbc00720bULL, 0x000fce0003fdd000ULL, 0x000000c000c27306ULL, 0x000ea20000205400ULL,
0x000000bfbe00720bULL, 0x002fca0003f9d000ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x0000007900807306ULL, 0x0002f0000000d400ULL, 0x000000b700bb7306ULL, 0x000f22000020d400ULL,
0x0001000079797824ULL, 0x002fe200078e00ffULL, 0x000000c2c100720bULL, 0x004fc80003f7d000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000078007e7306ULL, 0x000fe20000209400ULL,
0x0000000180804812ULL, 0x008fce00078efcffULL, 0x00000078007f7306ULL, 0x000e620000205400ULL,
0x00000001bbbb5812ULL, 0x010fc800078efcffULL, 0x00000082bb82723eULL, 0x000fc600000010ffULL,
0x000000c000c37306ULL, 0x000eb0000020d400ULL, 0x0000007900907306ULL, 0x000fe20000209400ULL,
0x0000007f7e00720bULL, 0x002fce0003fbd000ULL, 0x0000007900917306ULL, 0x000e620000205400ULL,
0x00000001c3c33812ULL, 0x004fe400078efcffULL, 0x000000c5c400720bULL, 0x000fca0003f7d000ULL,
0x0000007800ba7306ULL, 0x000eb0000020d400ULL, 0x0000007900927306ULL, 0x000ee2000020d400ULL,
0x000000919000720bULL, 0x002fe40003f9d000ULL, 0x000000016f6f3812ULL, 0x000fca00078efcffULL,
0x0000002600787306ULL, 0x000fe20000209400ULL, 0x00000001baba5812ULL, 0x004fc800078efcffULL,
0x000000ba81ba723eULL, 0x000fc600000010ffULL, 0x0000002600797306ULL, 0x000e620000205400ULL,
0x0000000192924812ULL, 0x008fc800078efcffULL, 0x000000926fbb723eULL, 0x000fc600000010ffULL,
0x0000007a008c7306ULL, 0x000fe80000009400ULL, 0x000000ba7050723cULL, 0x080f680000041850ULL,
0x0000007a008d7306ULL, 0x000ea20000005400ULL, 0x000000797800720bULL, 0x002fe40003fbd000ULL,
0x0000008ab179723eULL, 0x000fe200000010ffULL, 0x000000ba6830723cULL, 0x000f620000041830ULL,
0x0000008ea778723eULL, 0x000fc600000010ffULL, 0x0000007b00847306ULL, 0x000fe80000009400ULL,
0x00000078705c723cULL, 0x000f68000004185cULL, 0x0000007b00877306ULL, 0x000e620000005400ULL,
0x0000008d8c00720bULL, 0x004fc60003fdd000ULL, 0x00000078683c723cULL, 0x000f68000004183cULL,
0x00000027008f7306ULL, 0x000ff00000209400ULL, 0x0000002700987306ULL, 0x000ea20000205400ULL,
0x000000878400720bULL, 0x002fce0003f7d000ULL, 0x0000007a00257306ULL, 0x0002f0000000d400ULL,
0x0000007b001d7306ULL, 0x0008e2000000d400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x000000988f00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147aULL,
0x0000002600947306ULL, 0x0002a2000020d400ULL, 0x000100007b7b7824ULL, 0x010fe200078e00ffULL,
0x0000000125256812ULL, 0x008fe400078efcffULL, 0x000000868900720bULL, 0x000fe40003fdd000ULL,
0x00000018ff907819ULL, 0x000fe4000001147bULL, 0x00000027009c7306ULL, 0x000722000020d400ULL,
0x000000769326723eULL, 0x002fc400000010ffULL, 0x0000007d9676723eULL, 0x000fe400000010ffULL,
0x000000011d1d3812ULL, 0x000fe400078efcffULL, 0x000000b4837b723eULL, 0x000fe200000010ffULL,
0x0000007c007e7306ULL, 0x000fe20000209400ULL, 0x0000000194945812ULL, 0x004fe200078efcffULL,
0x000000767060723cULL, 0x080f620000041860ULL, 0x000000888500720bULL, 0x000fe40003fbd000ULL,
0x000000259494723eULL, 0x000fe200000010ffULL, 0x000000021a257824ULL, 0x000fe200078e00ffULL,
0x0000009a9f27723eULL, 0x008fe200000010ffULL, 0x0000007c007f7306ULL, 0x000e620000205400ULL,
0x000000019c9c4812ULL, 0x010fe200078efcffULL, 0x000000766840723cULL, 0x000f620000041840ULL,
0x000000011f1f6812ULL, 0x000fc400078efcffULL, 0x0000001d9c95723eULL, 0x000fe400000010ffULL,
0x00000004251d7812ULL, 0x000fe200078ec0ffULL, 0x0000009000917306ULL, 0x000fe20000209400ULL,
0x000000016e6e5812ULL, 0x000fe200078efcffULL, 0x000000267064723cULL, 0x000f620000041864ULL,
0x0000009e8b7a723eULL, 0x000fe400000010ffULL, 0x00000080c383723eULL, 0x000fc600000010ffULL,
0x00000090008a7306ULL, 0x000ea20000205400ULL, 0x0000007f7e00720bULL, 0x002fe20003f9d000ULL,
0x000000266844723cULL, 0x000b6c0000041844ULL, 0x0000007c007d7306ULL, 0x000e62000020d400ULL,
0x000000021d267812ULL, 0x020fe200078efcffULL, 0x0000007a7058723cULL, 0x000f620000041858ULL,
0x0000000102277824ULL, 0x000fc400078e021eULL, 0x0000002617267211ULL, 0x000fc600078fe0ffULL,
0x0000009000907306ULL, 0x000ee2000020d400ULL, 0x0000008a9100720bULL, 0x004fe20003f7d000ULL,
0x000000827054723cULL, 0x000f620000041854ULL, 0x00000001031d7824ULL, 0x100fe400078e0226ULL,
0x0000000102267824ULL, 0x000fe200078e0226ULL, 0x000000017d7d4812ULL, 0x002fc800078efcffULL,
0x00000094704c723cULL, 0x000f62000004184cULL, 0x0000007d6e6e723eULL, 0x000fc600000010ffULL,
0x0000000190903812ULL, 0x008fc800078efcffULL, 0x0000007a6838723cULL, 0x000f620000041838ULL,
0x000000901f6f723eULL, 0x000fe200000010ffULL, 0x00000008021f7824ULL, 0x000fca00078e00ffULL,
0xfffffff81f1e7812ULL, 0x000fe200078ee226ULL, 0x0000006e7048723cULL, 0x000b620000041848ULL,
0x0000100000267810ULL, 0x000fcc0007ffe0ffULL, 0x0000000803707824ULL, 0x020fe200078e00ffULL,
0x000000826834723cULL, 0x000f680000041834ULL, 0xfffffff8701d7812ULL, 0x000fe200078ee21dULL,
0x0000000802707824ULL, 0x000fc600078e00ffULL, 0x00000094682c723cULL, 0x040f64000004182cULL,
0xfffffff8701f7812ULL, 0x000fe200078ee227ULL, 0x000000101d707824ULL, 0x100fe200078e0221ULL,
0x0000000227277810ULL, 0x000fe20007ffe0ffULL, 0x000000101e217824ULL, 0x000fe400078e0221ULL,
0x000000101f787824ULL, 0x000fe200078e0226ULL, 0x0000006e6828723cULL, 0x000b620000041828ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002168783bULL, 0x0204e40000000200ULL,
0x00000008026e7824ULL, 0x000fe200078e00ffULL, 0x0000008000000947ULL, 0x000fd60003800000ULL,
0x0000000770707231ULL, 0x082fe400003400ffULL, 0x0000000772727231ULL, 0x000fc400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fe400003400ffULL,
0x0000000568687231ULL, 0x088fe400003400ffULL, 0x000000056a6a7231ULL, 0x000fe400003400ffULL,
0x0000000469697231ULL, 0x080fe400003400ffULL, 0x000000046b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff86e217812ULL, 0x004fe200078ee227ULL,
0x000000007878783bULL, 0x000ea80000004200ULL, 0x00000010217c7824ULL, 0x000fcc00078e0226ULL,
0x000000007c7c783bULL, 0x000f220000004200ULL, 0x0000007800267306ULL, 0x004fe20000009400ULL,
0x00000018ff777819ULL, 0x000fe20000011478ULL, 0x0000010078937824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011479ULL, 0x0000010079967824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe2000001147bULL, 0x000001007aa77824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe2000001147aULL, 0x0000007800277306ULL, 0x000ea20000005400ULL,
0x00000018ff9e7819ULL, 0x000fe20000011496ULL, 0x000001007bab7824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x010fe2000001147eULL, 0x000001007cbb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa27819ULL, 0x000fe2000001147fULL, 0x000001007dbd7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe2000001147dULL, 0x0000007800927306ULL, 0x0008e2000000d400ULL,
0x00000018ff937819ULL, 0x000fc40000011493ULL, 0x00000018ffa77819ULL, 0x000fe400000114a7ULL,
0x00000018ffb17819ULL, 0x000fe400000114abULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x00000079009a7306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x010fe200078e00ffULL,
0x000000272600720bULL, 0x004fe20003f7d000ULL, 0x000001007e267824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114bdULL, 0x000001007f277824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fc40000011478ULL, 0x00000079009d7306ULL, 0x000ea20000005400ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff277819ULL, 0x000fc80000011427ULL,
0x0000000192923812ULL, 0x008fe200078efcffULL, 0x0000007700987306ULL, 0x000ff00000209400ULL,
0x00000077009b7306ULL, 0x000fe20000205400ULL, 0x0000009d9a00720bULL, 0x004fce0003f9d000ULL,
0x00000077006e7306ULL, 0x0005f0000020d400ULL, 0x0000008100a37306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x004fce000001147cULL, 0x0000008100a87306ULL, 0x000ff00000205400ULL,
0x00000081006f7306ULL, 0x000ff0000020d400ULL, 0x0000009900887306ULL, 0x000ff00000209400ULL,
0x00000099008b7306ULL, 0x000ff00000205400ULL, 0x0000009900817306ULL, 0x000ff0000020d400ULL,
0x0000007800967306ULL, 0x000ff00000209400ULL, 0x0000007800997306ULL, 0x000eb00000205400ULL,
0x0000008900b77306ULL, 0x000ff00000209400ULL, 0x0000008900b87306ULL, 0x000fe20000205400ULL,
0x000000999600720bULL, 0x004fce0003fdd000ULL, 0x0000008900867306ULL, 0x000ff0000020d400ULL,
0x0000007700bf7306ULL, 0x000ff00000209400ULL, 0x0000007700c07306ULL, 0x000ff00000205400ULL,
0x0000007700847306ULL, 0x000ff0000020d400ULL, 0x000000a2008c7306ULL, 0x000ff00000209400ULL,
0x000000a200897306ULL, 0x000ff00000205400ULL, 0x000000a200777306ULL, 0x0005f0000020d400ULL,
0x00000079009c7306ULL, 0x000ee2000000d400ULL, 0x0001000079a27824ULL, 0x004fca00078e00ffULL,
0x00000018ffa27819ULL, 0x000fe400000114a2ULL, 0x0000008200ad7306ULL, 0x000ff00000209400ULL,
0x0000008200ae7306ULL, 0x000fe20000205400ULL, 0x000000019c9c4812ULL, 0x008fc400078efcffULL,
0x000000a8a300720bULL, 0x000fca0003f9d000ULL, 0x00000082008e7306ULL, 0x000ff0000020d400ULL,
0x0000009e009f7306ULL, 0x000fe20000209400ULL, 0x000000016f6f4812ULL, 0x000fce00078efcffULL,
0x0000009e00a07306ULL, 0x000eb00000205400ULL, 0x0000009400907306ULL, 0x000ff00000209400ULL,
0x0000009400917306ULL, 0x000fe20000205400ULL, 0x000000a09f00720bULL, 0x004fce0003fbd000ULL,
0x0000009400827306ULL, 0x000ff0000020d400ULL, 0x0000009300947306ULL, 0x000ff00000209400ULL,
0x0000009300957306ULL, 0x000eb00000205400ULL, 0x0000009300977306ULL, 0x000ef0000020d400ULL,
0x0000009e00a17306ULL, 0x000f22000020d400ULL, 0x000000959400720bULL, 0x004fce0003f1d000ULL,
0x0000007800797306ULL, 0x000eac000020d400ULL, 0x0000000197970812ULL, 0x008fe400078efcffULL,
0x000000a200937306ULL, 0x000fe20000209400ULL, 0x00000001a1a15812ULL, 0x010fe400078efcffULL,
0x0000009b9800720bULL, 0x000fca0003f1d000ULL, 0x000000a200a47306ULL, 0x000ee20000205400ULL,
0x0000000179796812ULL, 0x004fce00078efcffULL, 0x000000a7009e7306ULL, 0x000fe20000209400ULL,
0x000000016e6e0812ULL, 0x000fc800078efcffULL, 0x000000796e6e723eULL, 0x000fc600000010ffULL,
0x000000a700a97306ULL, 0x000ea20000205400ULL, 0x000000a49300720bULL, 0x008fce0003f7d000ULL,
0x0000007a00a57306ULL, 0x000ff00000009400ULL, 0x0000007a00aa7306ULL, 0x000ee20000005400ULL,
0x000000a99e00720bULL, 0x004fce0003fdd000ULL, 0x0000007a008f7306ULL, 0x0005f0000000d400ULL,
0x000000a200a67306ULL, 0x000862000020d400ULL, 0x000100007a7a7824ULL, 0x004fe200078e00ffULL,
0x000000aaa500720bULL, 0x008fc80003fbd000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x000000a700ac7306ULL, 0x000ea2000020d400ULL, 0x000100007ba27824ULL, 0x010fca00078e00ffULL,
0x00000018ffa27819ULL, 0x000fe400000114a2ULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x00000001a6a63812ULL, 0x002fe400078efcffULL, 0x000000018f8f5812ULL, 0x000fe400078efcffULL,
0x000000a66f6f723eULL, 0x000fc600000010ffULL, 0x0000007a00ab7306ULL, 0x000e620000205400ULL,
0x00000001acac6812ULL, 0x004fe400078efcffULL, 0x000000aead00720bULL, 0x000fe20003fdd000ULL,
0x0000006e7060723cULL, 0x080f680000041860ULL, 0x0000007b00af7306ULL, 0x000fe80000009400ULL,
0x0000006e6840723cULL, 0x000f680000041840ULL, 0x0000007b00b07306ULL, 0x000ea20000005400ULL,
0x000000ab7800720bULL, 0x002fe20003f9d000ULL, 0x000100007f787824ULL, 0x000fe200078e00ffULL,
0x000000018e8e6812ULL, 0x000fca00078efcffULL, 0x0000007b008d7306ULL, 0x000e70000000d400ULL,
0x0000007a007b7306ULL, 0x000ee2000020d400ULL, 0x000000b0af00720bULL, 0x004fce0003f7d000ULL,
0x0000007c00b97306ULL, 0x000fec0000009400ULL, 0x000000018d8d3812ULL, 0x002fe400078efcffULL,
0x0000007c00ba7306ULL, 0x000e620000005400ULL, 0x000000017b7b4812ULL, 0x008fc800078efcffULL,
0x0000007b8e8e723eULL, 0x000fc600000010ffULL, 0x000000a200a77306ULL, 0x000ff00000209400ULL,
0x000000a200b67306ULL, 0x000ea20000205400ULL, 0x000000bab900720bULL, 0x002fce0003f9d000ULL,
0x000000b100b27306ULL, 0x000ff00000209400ULL, 0x000000b100b37306ULL, 0x000e620000205400ULL,
0x000000b6a700720bULL, 0x004fce0003fbd000ULL, 0x000000b100b47306ULL, 0x000eb0000020d400ULL,
0x000000bb00b17306ULL, 0x000fe20000209400ULL, 0x000000b3b200720bULL, 0x002fce0003f1d000ULL,
0x000000bb00bc7306ULL, 0x000e6c0000205400ULL, 0x00000001b4b40812ULL, 0x004fe400078efcffULL,
0x000000c300c47306ULL, 0x000fe20000209400ULL, 0x000000b8b700720bULL, 0x000fe40003f1d000ULL,
0x0000008db479723eULL, 0x000fca00000010ffULL, 0x000000c300c57306ULL, 0x000ea20000205400ULL,
0x000000bcb100720bULL, 0x002fca0003f7d000ULL, 0x0000000186860812ULL, 0x000fe400078efcffULL,
0x0000007c00857306ULL, 0x0002f0000000d400ULL, 0x000000a200b57306ULL, 0x0008e2000020d400ULL,
0x000100007c7c7824ULL, 0x002fe200078e00ffULL, 0x000000c5c400720bULL, 0x004fc80003fdd000ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00c17306ULL, 0x000fe20000009400ULL,
0x000100007da27824ULL, 0x010fe200078e00ffULL, 0x0000000185854812ULL, 0x008fe400078efcffULL,
0x000000c0bf00720bULL, 0x000fe40003f9d000ULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x0000007d00c27306ULL, 0x000e620000005400ULL, 0x00000001b5b55812ULL, 0x000fce00078efcffULL,
0x000000bb00be7306ULL, 0x000ea2000020d400ULL, 0x0000000184844812ULL, 0x000fce00078efcffULL,
0x000000c300c67306ULL, 0x000ee2000020d400ULL, 0x000000c2c100720bULL, 0x002fce0003fbd000ULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x00000001bebe3812ULL, 0x004fc800078efcffULL,
0x00000085bebe723eULL, 0x000fc600000010ffULL, 0x0000007c00bd7306ULL, 0x000e620000205400ULL,
0x00000001c6c66812ULL, 0x008fce00078efcffULL, 0x000000a200bb7306ULL, 0x000ff00000209400ULL,
0x000000a200c87306ULL, 0x000ea20000205400ULL, 0x000000bd7a00720bULL, 0x002fce0003f7d000ULL,
0x0000007d00837306ULL, 0x000e70000000d400ULL, 0x0000007f00877306ULL, 0x000fe20000009400ULL,
0x000000c8bb00720bULL, 0x004fce0003fdd000ULL, 0x0000007f008a7306ULL, 0x000ea20000005400ULL,
0x0000000183835812ULL, 0x002fe400078efcffULL, 0x000000919000720bULL, 0x000fe40003fbd000ULL,
0x00000083c6bf723eULL, 0x000fc600000010ffULL, 0x0000007c007d7306ULL, 0x000e68000020d400ULL,
0x000000be7054723cULL, 0x080f680000041854ULL, 0x000000a200957306ULL, 0x000ee2000020d400ULL,
0x0000008a8700720bULL, 0x004fe40003f9d000ULL, 0x0000000182825812ULL, 0x000fe200078efcffULL,
0x000000be6834723cULL, 0x000f620000041834ULL, 0x0000008b8800720bULL, 0x000fc60003fbd000ULL,
0x0000007e00c77306ULL, 0x000fe20000009400ULL, 0x000000017d7d3812ULL, 0x002fc800078efcffULL,
0x0000007d8484723eULL, 0x000fc600000010ffULL, 0x0000007e00ca7306ULL, 0x000e620000005400ULL,
0x0000000195956812ULL, 0x008fe400078efcffULL, 0x0000000181815812ULL, 0x000fe400078efcffULL,
0x000000958285723eULL, 0x000fc600000010ffULL, 0x00000026007c7306ULL, 0x000fe80000209400ULL,
0x000000847050723cULL, 0x000f680000041850ULL, 0x0000002600937306ULL, 0x000ea20000205400ULL,
0x000000cac700720bULL, 0x002fc60003f1d000ULL, 0x000000846830723cULL, 0x000f680000041830ULL,
0x0000002700947306ULL, 0x000ff00000209400ULL, 0x00000027009b7306ULL, 0x000e620000205400ULL,
0x000000937c00720bULL, 0x004fce0003f7d000ULL, 0x0000007e00807306ULL, 0x0004f0000000d400ULL,
0x0000002600997306ULL, 0x0008e2000020d400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x0000009b9400720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00767306ULL, 0x000e62000000d400ULL, 0x000000929726723eULL, 0x010fe400000010ffULL,
0x00000018ff927819ULL, 0x000fe40000011478ULL, 0x0000000180800812ULL, 0x008fe400078efcffULL,
0x0000008fac78723eULL, 0x000fe200000010ffULL, 0x00000027009d7306ULL, 0x0004e2000020d400ULL,
0x0000000199993812ULL, 0x000fc400078efcffULL, 0x000000898c00720bULL, 0x000fe40003f7d000ULL,
0x000000b5868f723eULL, 0x000fe200000010ffULL, 0x00000078705c723cULL, 0x000f64000004185cULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000000176764812ULL, 0x002fe400078efcffULL,
0x0000009ca127723eULL, 0x004fc600000010ffULL, 0x0000008e7058723cULL, 0x040f640000041858ULL,
0x0000007e007a7306ULL, 0x000e620000205400ULL, 0x000000019d9d6812ULL, 0x008fe400078efcffULL,
0x0000000177773812ULL, 0x000fe400078efcffULL, 0x000000769d7b723eULL, 0x000fe200000010ffULL,
0x000000267064723cULL, 0x080f640000041864ULL, 0x0000009200907306ULL, 0x000fec0000209400ULL,
0x000000266844723cULL, 0x000b640000041844ULL, 0x0000009200877306ULL, 0x000ea20000205400ULL,
0x0000007a7f00720bULL, 0x002fc40003f1d000ULL, 0x00000080997a723eULL, 0x000fe400000010ffULL,
0xfffffff825267812ULL, 0x020fe200078ec0ffULL, 0x00000078683c723cULL, 0x000f64000004183cULL,
0x0000007e007e7306ULL, 0x000e6c000020d400ULL, 0x0000007a704c723cULL, 0x000f64000004184cULL,
0x0000009200927306ULL, 0x000ee2000020d400ULL, 0x000000879000720bULL, 0x004fca0003fdd000ULL,
0x0000008e6838723cULL, 0x000f620000041838ULL, 0x000000017e7e0812ULL, 0x002fc800078efcffULL,
0x0000007e8176723eULL, 0x000fc600000010ffULL, 0x0000007a682c723cULL, 0x000f62000004182cULL,
0x0000000192926812ULL, 0x008fc800078efcffULL, 0x000000927777723eULL, 0x000fce00000010ffULL,
0x000000767048723cULL, 0x080f700000041848ULL, 0x000000766828723cULL, 0x000b6e0000041828ULL,
0x0001a6c8136a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6900026ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff257224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x004fc80000015200ULL, 0x000004000d697984ULL, 0x000ea40000000800ULL,
0x8000000069ff7812ULL, 0x006fc4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000687805ULL, 0x000fcc0000015200ULL, 0x00000068266f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000169697824ULL, 0x000fe200000e0e27ULL, 0x003d09006f00780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406f00780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff687819ULL, 0x000fc80000011469ULL,
0x0000006f68687211ULL, 0x000fca00078110ffULL, 0x000000ffff697224ULL, 0x000fca00000e0669ULL,
0x0000000268687819ULL, 0x000fc80000001269ULL, 0x000000680000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d697984ULL, 0x000e640000000800ULL,
0x8000000069ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c00c277810ULL, 0x000fca0007ffe0ffULL, 0x00006600126f7a24ULL, 0x000fe200078e0227ULL,
0x000003e00000a947ULL, 0x000fea0003800000ULL, 0x0000002716257217ULL, 0x000fe20007800000ULL,
0x00000010116e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff687819ULL, 0x000fe40000011617ULL,
0x0000100000777810ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a27ULL,
0x0000000468697810ULL, 0x000fe20007ffe0ffULL, 0x000000016e267824ULL, 0x000fe200078e0268ULL,
0x00000008686b7810ULL, 0x000fe40007ffe0ffULL, 0x000000256e257217ULL, 0x000fe20007800000ULL,
0x0000000126277824ULL, 0x000fc400078e0217ULL, 0x0000000826707824ULL, 0x040fe400078e00ffULL,
0x0000000125257824ULL, 0x000fe400078e0a6eULL, 0x0000000126267824ULL, 0x000fe200078e026fULL,
0xfffffff870707812ULL, 0x000fe200078ee227ULL, 0x000000016e727824ULL, 0x000fe200078e0269ULL,
0x000000256900720cULL, 0x080fe20003f86070ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000c68697810ULL, 0x040fe40007ffe0ffULL, 0x000000256800720cULL, 0x080fe20003fa6070ULL,
0x0000000172687824ULL, 0x000fe200078e026fULL, 0x000000256900720cULL, 0x000fe20003f06070ULL,
0x000000016e787824ULL, 0x000fe200078e0269ULL, 0x0000000b266a7212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x000000256b00720cULL, 0x000fc40003f66070ULL,
0x000062006a6a7a10ULL, 0x000fe20007fde0ffULL, 0x000000016e767824ULL, 0x000fe200078e026bULL,
0x0000000b686e7212ULL, 0x000fe200078efcffULL, 0x0000000172257824ULL, 0x000fe200078e0217ULL,
0x00006300276b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000176267824ULL, 0x000fe200078e026fULL,
0x000062006e6e7a10ULL, 0x000fe20007fde0ffULL, 0x0000000872727824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x0000000178687824ULL, 0x000fe200078e026fULL, 0x00006300696f7a10ULL, 0x000fe200037fe4ffULL,
0x0000000176717824ULL, 0x000fe200078e0217ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fc600078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007fde0ffULL,
0x0000000876767824ULL, 0x000fe200078e00ffULL, 0x0000000b68687212ULL, 0x000fe200078efcffULL,
0x0000000178257824ULL, 0x040fe200078e0217ULL, 0x0000630027277a10ULL, 0x000fe200037fe4ffULL,
0x0000000878787824ULL, 0x000fe200078e00ffULL, 0xfffffff876767812ULL, 0x000fe200078ee271ULL,
0x0000001072717824ULL, 0x000fe200078e0277ULL, 0x0000620068687a10ULL, 0x000fe40007fde0ffULL,
0xfffffff878787812ULL, 0x000fe200078ee225ULL, 0x0000001070257824ULL, 0x100fe200078e0277ULL,
0x0000630069697a10ULL, 0x000fe200037fe4ffULL, 0x0000001076737824ULL, 0x000fc400078e0277ULL,
0x0000001078777824ULL, 0x000fe200078e0277ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a257faeULL, 0x0003e8000e901c48ULL, 0x000000006e717faeULL, 0x0003e8000e101c48ULL,
0x0000000026737faeULL, 0x0003e8000d901c48ULL, 0x0000000068777faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011267824ULL, 0x000fe200078e00ffULL,
0x0000100000777810ULL, 0x000fc80007ffe0ffULL, 0x0000002617687211ULL, 0x000fc800078fe8ffULL,
0x00000004686a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000168267824ULL, 0x040fe200078e026fULL,
0x0000000868727810ULL, 0x040fe20007ffe0ffULL, 0x0000000168257824ULL, 0x040fe200078e0217ULL,
0x0000000c68767810ULL, 0x040fe20007ffe0ffULL, 0x0000000868707824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff870707812ULL, 0x000fe200078ee225ULL,
0x000000016a257824ULL, 0x000fe200078e026fULL, 0x0000000b266e7212ULL, 0x000fe200078efcffULL,
0x000000016a697824ULL, 0x040fe400078e0217ULL, 0x000000086a787824ULL, 0x000fe200078e00ffULL,
0x000062006e6e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000172687824ULL, 0x100fe400078e026fULL,
0x00000001766a7824ULL, 0x040fe400078e026fULL, 0x0000000176267824ULL, 0x000fc400078e0217ULL,
0x00000008766f7824ULL, 0x000fe400078e00ffULL, 0x00000001726b7824ULL, 0x040fe400078e0217ULL,
0x00000008727a7824ULL, 0x000fe200078e00ffULL, 0xfffffff878727812ULL, 0x000fe200078ee269ULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0xfffffff86f787812ULL, 0x000fe400078ee226ULL,
0x00006300276f7a10ULL, 0x000fe200007fe4ffULL, 0x0000008025267825ULL, 0x000fe200078e00ffULL,
0xfffffff87a767812ULL, 0x000fc400078ee26bULL, 0x0000000b68687212ULL, 0x080fe200078efcffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000620068687a10ULL, 0x000fe20007f7e0ffULL, 0x0000001070257824ULL, 0x100fe200078e0277ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x0000001072717824ULL, 0x100fe200078e0277ULL,
0x0000620026267a10ULL, 0x000fe20007f1e0ffULL, 0x0000001076737824ULL, 0x100fe200078e0277ULL,
0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001078777824ULL, 0x000fe200078e0277ULL,
0x0000630027277a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e257faeULL, 0x0003e2000b901c48ULL, 0x0000630069697a10ULL, 0x000fc40001ffe4ffULL,
0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026717faeULL, 0x0003e8000b901c48ULL,
0x0000000068737faeULL, 0x0003e8000b901c48ULL, 0x000000006a777faeULL, 0x0003e4000b901c48ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff014687812ULL, 0x000fce00078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6b00068687f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a64800206e7f8cULL, 0x0004e4000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x01a64c0020257984ULL, 0x000f240000000800ULL, 0x8000000025ff7812ULL, 0x018fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006a7805ULL, 0x000fcc0000015200ULL, 0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL,
0x000000016b6b7824ULL, 0x000fe200000e0e27ULL, 0x003d09006a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001146bULL,
0x0000006a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff6a7224ULL, 0x000fca00000e066bULL,
0x0000000225257819ULL, 0x000fc8000000126aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a64c0020257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x008fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a207824ULL, 0x004fca00078e00ffULL, 0xffffff8020207812ULL, 0x000fc800078ec0ffULL,
0x000001000b257810ULL, 0x000fca0007ffe020ULL, 0x000000010a257824ULL, 0x000fca00078e0225ULL,
0x01a00000256e7984ULL, 0x000ea80000000800ULL, 0x01a20000256f7984ULL, 0x0006620000000800ULL,
0x000000236e00720bULL, 0x004fe20003f1d000ULL, 0x00012e827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000707806ULL, 0x008fc800000e0100ULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff207224ULL, 0x000fd200078e0023ULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000000210257810ULL, 0x000fe40007ffe0ffULL, 0x000000236e00720bULL, 0x000fe40003f74000ULL,
0x0000001a2500720cULL, 0x000fe20003f05270ULL, 0x00012e427f007947ULL, 0x000fd4000b800000ULL,
0x0000000000717806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x000000236e207209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x01a4002025008388ULL, 0x0005e20000000800ULL,
0x000000ff7100720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000002320237221ULL, 0x004fe20000010100ULL, 0x000000ff71ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b23237820ULL, 0x000fc80000410000ULL,
0x0000002300277308ULL, 0x000ea40000000800ULL, 0x0000002724247220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x00012d927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x000fc40000410000ULL,
0x000000264c4c7220ULL, 0x080fe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x00012c727f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x000fc40000410000ULL, 0x000000264e4e7220ULL, 0x080fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x00012b527f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x000000262c2c7220ULL, 0x080fe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002628287220ULL, 0x080fe40000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000071ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x00012a427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x000fc40000410000ULL,
0x000000262e2e7220ULL, 0x080fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x000000262a2a7220ULL, 0x080fe40000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000007170ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fd800078e00ffULL, 0x800000206e6e0221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00090308ULL, 0x000ea40000000800ULL, 0x000000096f6f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000246f247221ULL, 0x002fc40000010000ULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x0000040008237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006a7805ULL, 0x000fcc0000015200ULL,
0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL, 0x000000016b6b7824ULL, 0x000fe200000e0e27ULL,
0x003d09006a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001146bULL, 0x0000006a23237211ULL, 0x000fca00078110ffULL,
0x000000ffff6a7224ULL, 0x000fca00000e066bULL, 0x0000000223237819ULL, 0x000fc8000000126aULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040008237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991025237816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x000126327f007947ULL, 0x000fea000b800000ULL, 0x00001f6c27077589ULL, 0x0002a400000e0000ULL,
0x000000086c267810ULL, 0x000fe20007ffe0ffULL, 0x000126727f007947ULL, 0x000fea000b800000ULL,
0x000000106c047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000186c267810ULL, 0x008fe20007ffe0ffULL,
0x000126e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000021a237824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a277824ULL, 0x00afe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000008036b7824ULL, 0x000fe200078e00ffULL,
0x0000000423267812ULL, 0x000fe200078ec0ffULL, 0x00000008026c7824ULL, 0x000fe200078e00ffULL,
0xfffff000276a7812ULL, 0x000fe200078ec0ffULL, 0x000000101c787824ULL, 0x000fe200078e0200ULL,
0x0000002617257211ULL, 0x000fca00078fe0ffULL, 0x0000000103267824ULL, 0x100fe400078e0225ULL,
0x0000000102277824ULL, 0x000fe200078e0225ULL, 0x000140006a257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff86b267812ULL, 0x000fe400078ee226ULL, 0xfffffff86c6a7812ULL, 0x000fc600078ee227ULL,
0x0000001026267824ULL, 0x100fe400078e0225ULL, 0x000000106a6a7824ULL, 0x000fc600078e0225ULL,
0x000000002670783bULL, 0x0002e80000000200ULL, 0x000000006a6c783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707231ULL, 0x08cfe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x000000056c6c7231ULL, 0x080fe400003400ffULL,
0x000000056e6e7231ULL, 0x000fe400003400ffULL, 0x000000046d6d7231ULL, 0x080fe400003400ffULL,
0x000000046f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010227c7824ULL, 0x000fe200078e0200ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000f8000007945ULL, 0x000fe80003800000ULL, 0x000000007c7c783bULL, 0x000e620000004200ULL,
0x0000010078917824ULL, 0x010fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011478ULL,
0x0000010079947824ULL, 0x040fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011479ULL,
0x00000079009a7306ULL, 0x000fe20000009400ULL, 0x00000018ff877819ULL, 0x002fe2000001147cULL,
0x0001000079a07824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe2000001147eULL,
0x000001007aa77824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001147fULL,
0x000001007bad7824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011491ULL,
0x0000002200967306ULL, 0x000fe20000209400ULL, 0x00000018ff8c7819ULL, 0x000fe2000001147dULL,
0x000001007db47824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe2000001147aULL,
0x000001007fc97824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fc4000001147bULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x0000002200997306ULL, 0x000fe20000205400ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ffbb7819ULL, 0x000fe400000114b4ULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000002200987306ULL, 0x000ff0000020d400ULL, 0x0000008700b77306ULL, 0x000ff00000209400ULL,
0x0000008700b87306ULL, 0x000ff00000205400ULL, 0x0000008700857306ULL, 0x000ff0000020d400ULL,
0x0000007600a37306ULL, 0x000ff00000209400ULL, 0x0000007600a67306ULL, 0x000ff00000205400ULL,
0x00000076006b7306ULL, 0x000ff0000020d400ULL, 0x0000009d00887306ULL, 0x000ff00000209400ULL,
0x0000009d00877306ULL, 0x000ff00000205400ULL, 0x0000009d00227306ULL, 0x0003f0000020d400ULL,
0x00000079009b7306ULL, 0x000f220000005400ULL, 0x00000018ff9d7819ULL, 0x002fce0000011494ULL,
0x0000009200867306ULL, 0x000ff00000209400ULL, 0x0000009200897306ULL, 0x000fe20000205400ULL,
0x0000009b9a00720bULL, 0x010fce0003f9d000ULL, 0x0000009200767306ULL, 0x000ff0000020d400ULL,
0x0000009100927306ULL, 0x000ff00000209400ULL, 0x0000009100937306ULL, 0x000e700000205400ULL,
0x0000007800267306ULL, 0x000ff00000009400ULL, 0x0000007800277306ULL, 0x000f220000005400ULL,
0x000000939200720bULL, 0x002fce0003fbd000ULL, 0x0000009d009e7306ULL, 0x000ff00000209400ULL,
0x0000009d009f7306ULL, 0x000e620000205400ULL, 0x000000272600720bULL, 0x010fce0003fdd000ULL,
0x00000078006a7306ULL, 0x0008f0000000d400ULL, 0x00000079009c7306ULL, 0x000ea2000000d400ULL,
0x0001000078787824ULL, 0x010fe200078e00ffULL, 0x0000009f9e00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008c00c17306ULL, 0x000fe20000209400ULL,
0x000000016a6a6812ULL, 0x008fe400078efcffULL, 0x000000999600720bULL, 0x000fe20003fdd000ULL,
0x000100007f967824ULL, 0x000fc800078e00ffULL, 0x0000008c00c27306ULL, 0x000fe20000205400ULL,
0x000000019c9c4812ULL, 0x004fe400078efcffULL, 0x000000a6a300720bULL, 0x000fe40003f9d000ULL,
0x00000018ff967819ULL, 0x000fc60000011496ULL, 0x0000008c00837306ULL, 0x000fe2000020d400ULL,
0x0000000198986812ULL, 0x000fce00078efcffULL, 0x00000080008f7306ULL, 0x000fe20000209400ULL,
0x000000016b6b4812ULL, 0x000fce00078efcffULL, 0x0000008000907306ULL, 0x000ff00000205400ULL,
0x0000008000817306ULL, 0x000ff0000020d400ULL, 0x00000097008c7306ULL, 0x000ff00000209400ULL,
0x00000097008d7306ULL, 0x000ff00000205400ULL, 0x0000009700807306ULL, 0x000ff0000020d400ULL,
0x0000009100957306ULL, 0x000e70000020d400ULL, 0x0000007800947306ULL, 0x000ff00000209400ULL,
0x0000007800977306ULL, 0x000ea20000205400ULL, 0x0000000195955812ULL, 0x002fc800078efcffULL,
0x0000006a9526723eULL, 0x000fc600000010ffULL, 0x0000009d00a17306ULL, 0x000e70000020d400ULL,
0x000000a000917306ULL, 0x000fe20000209400ULL, 0x000000979400720bULL, 0x004fce0003fbd000ULL,
0x000000a000a27306ULL, 0x000ea20000205400ULL, 0x00000001a1a13812ULL, 0x002fc800078efcffULL,
0x0000009ca127723eULL, 0x000fc600000010ffULL, 0x0000007b00ab7306ULL, 0x000fe80000009400ULL,
0x000000267064723cULL, 0x000f680000041864ULL, 0x0000007b00ac7306ULL, 0x000e620000005400ULL,
0x000000a29100720bULL, 0x004fc60003f7d000ULL, 0x000000266c44723cULL, 0x000f680000041844ULL,
0x0000007800797306ULL, 0x0004f0000020d400ULL, 0x000000a7009d7306ULL, 0x000fe20000209400ULL,
0x000001007c787824ULL, 0x004fe200078e00ffULL, 0x000000acab00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x000000a700aa7306ULL, 0x000e620000205400ULL,
0x0000000179795812ULL, 0x008fc800078efcffULL, 0x00000079986a723eULL, 0x000fc600000010ffULL,
0x000000a000a47306ULL, 0x000eb0000020d400ULL, 0x0000007a00a57306ULL, 0x000fe20000009400ULL,
0x000000aa9d00720bULL, 0x002fce0003fbd000ULL, 0x0000007a00a87306ULL, 0x000e620000005400ULL,
0x00000001a4a43812ULL, 0x004fc800078efcffULL, 0x000000a46b6b723eULL, 0x000fc600000010ffULL,
0x000000ad00ae7306ULL, 0x000fe80000209400ULL, 0x0000006a7060723cULL, 0x000f680000041860ULL,
0x000000ad00af7306ULL, 0x000ea20000205400ULL, 0x000000a8a500720bULL, 0x002fc60003fdd000ULL,
0x0000006a6c40723cULL, 0x000f680000041840ULL, 0x0000007b008b7306ULL, 0x0002f0000000d400ULL,
0x0000007d00b97306ULL, 0x000fe20000009400ULL, 0x000000afae00720bULL, 0x004fe20003f7d000ULL,
0x000100007b7b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007d00ba7306ULL, 0x000e620000005400ULL, 0x000000018b8b4812ULL, 0x008fce00078efcffULL,
0x000000a700a97306ULL, 0x000eb0000020d400ULL, 0x0000007800a07306ULL, 0x000fe20000209400ULL,
0x000000bab900720bULL, 0x002fce0003f9d000ULL, 0x0000007800b37306ULL, 0x000e620000205400ULL,
0x00000001a9a95812ULL, 0x004fce00078efcffULL, 0x0000007a008e7306ULL, 0x0004f0000000d400ULL,
0x000000ad00b07306ULL, 0x000f22000020d400ULL, 0x000000b3a000720bULL, 0x002fe20003fbd000ULL,
0x000100007a7a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007c00b17306ULL, 0x000fe20000009400ULL, 0x000000018e8e6812ULL, 0x008fce00078efcffULL,
0x0000007c00b27306ULL, 0x000e620000005400ULL, 0x00000001b0b03812ULL, 0x010fc800078efcffULL,
0x0000008bb079723eULL, 0x000fc600000010ffULL, 0x000000bb00bc7306ULL, 0x000ff00000209400ULL,
0x000000bb00bd7306ULL, 0x000ea20000205400ULL, 0x000000b2b100720bULL, 0x002fce0003fdd000ULL,
0x0000007c008a7306ULL, 0x0002f0000000d400ULL, 0x0000007d00847306ULL, 0x0008e2000000d400ULL,
0x000100007c7c7824ULL, 0x002fe200078e00ffULL, 0x000000bdbc00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007800b57306ULL, 0x0002a2000020d400ULL,
0x000100007d7d7824ULL, 0x010fe200078e00ffULL, 0x000000018a8a6812ULL, 0x008fe400078efcffULL,
0x000000b8b700720bULL, 0x000fe40003fdd000ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007c00a77306ULL, 0x000fe20000209400ULL, 0x000001007e787824ULL, 0x002fe200078e00ffULL,
0x0000000184844812ULL, 0x000fc400078efcffULL, 0x000000c2c100720bULL, 0x000fe40003f9d000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007c00b47306ULL, 0x000e620000205400ULL,
0x00000001b5b55812ULL, 0x004fe400078efcffULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x0000008ab58a723eULL, 0x000fc600000010ffULL, 0x000000bb00bf7306ULL, 0x000ea2000020d400ULL,
0x0000000183834812ULL, 0x000fce00078efcffULL, 0x0000007d00ad7306ULL, 0x000fe20000209400ULL,
0x000000b4a700720bULL, 0x002fce0003fbd000ULL, 0x0000007d00be7306ULL, 0x000e620000205400ULL,
0x00000001bfbf3812ULL, 0x004fc800078efcffULL, 0x00000084bf8b723eULL, 0x000fc600000010ffULL,
0x0000007c00b67306ULL, 0x000ea8000020d400ULL, 0x0000008a7054723cULL, 0x000f680000041854ULL,
0x000000c900ca7306ULL, 0x000fe20000209400ULL, 0x000000bead00720bULL, 0x002fc60003f7d000ULL,
0x0000008a6c34723cULL, 0x000f680000041834ULL, 0x000000c9009b7306ULL, 0x000e620000205400ULL,
0x00000001b6b65812ULL, 0x004fc800078efcffULL, 0x000000b685b6723eULL, 0x000fc600000010ffULL,
0x0000007800bb7306ULL, 0x000ff00000209400ULL, 0x0000007800c67306ULL, 0x000ea20000205400ULL,
0x0000009bca00720bULL, 0x002fce0003f9d000ULL, 0x0000007d00c07306ULL, 0x000e70000020d400ULL,
0x0000007e00c37306ULL, 0x000fe20000009400ULL, 0x000000c6bb00720bULL, 0x004fce0003fbd000ULL,
0x0000007e00c47306ULL, 0x000ea20000005400ULL, 0x00000001c0c03812ULL, 0x002fc800078efcffULL,
0x000000c083b7723eULL, 0x000fc600000010ffULL, 0x0000007f00c77306ULL, 0x000fe80000009400ULL,
0x000000b67050723cULL, 0x000f680000041850ULL, 0x0000007f00c87306ULL, 0x000e620000005400ULL,
0x000000c4c300720bULL, 0x004fc60003fdd000ULL, 0x000000b66c30723cULL, 0x000f680000041830ULL,
0x0000007800c57306ULL, 0x000eb0000020d400ULL, 0x000000c900947306ULL, 0x000ee2000020d400ULL,
0x000000c8c700720bULL, 0x002fce0003f7d000ULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x00000001c5c55812ULL, 0x004fce00078efcffULL, 0x0000007a007d7306ULL, 0x000e620000205400ULL,
0x0000000194944812ULL, 0x008fce00078efcffULL, 0x0000007a007c7306ULL, 0x000eb0000020d400ULL,
0x0000007b00917306ULL, 0x000fe20000209400ULL, 0x0000007d7800720bULL, 0x002fe40003fbd000ULL,
0x0000008ea978723eULL, 0x000fca00000010ffULL, 0x0000007b007a7306ULL, 0x000e640000205400ULL,
0x00000078705c723cULL, 0x080f68000004185cULL, 0x000000017c7c5812ULL, 0x004fe400078efcffULL,
0x0000007e00827306ULL, 0x0004e2000000d400ULL, 0x000000898600720bULL, 0x000fe20003fbd000ULL,
0x000000786c3c723cULL, 0x000b6c000004183cULL, 0x0000007f00777306ULL, 0x000f22000000d400ULL,
0x000100007e7e7824ULL, 0x004fe200078e00ffULL, 0x0000007a9100720bULL, 0x002fe20003f9d000ULL,
0x000000101f787824ULL, 0x020fc600078e0200ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007b00937306ULL, 0x000e62000020d400ULL, 0x0000000182826812ULL, 0x008fe400078efcffULL,
0x000000908f00720bULL, 0x000fe40003fdd000ULL, 0x0000000176765812ULL, 0x000fe400078efcffULL,
0x00000082c582723eULL, 0x000fe200000010ffULL, 0x0000007e007f7306ULL, 0x000fe20000209400ULL,
0x0000000177773812ULL, 0x010fc400078efcffULL, 0x0000008d8c00720bULL, 0x000fe40003f7d000ULL,
0x000000779483723eULL, 0x000fc600000010ffULL, 0x0000007e00927306ULL, 0x000ea20000205400ULL,
0x0000000193934812ULL, 0x002fe400078efcffULL, 0x0000000181816812ULL, 0x000fe200078efcffULL,
0x00000082704c723cULL, 0x000f62000004184cULL, 0x000000878800720bULL, 0x000fe40003fdd000ULL,
0x0000007c817c723eULL, 0x000fe200000010ffULL, 0x00000096007d7306ULL, 0x000fe20000209400ULL,
0x0000000180803812ULL, 0x000fc600078efcffULL, 0x000000826c2c723cULL, 0x000f68000004182cULL,
0x00000096007a7306ULL, 0x000e620000205400ULL, 0x000000927f00720bULL, 0x004fe40003f9d000ULL,
0x0000000122226812ULL, 0x000fca00078efcffULL, 0x0000007e007b7306ULL, 0x000eb0000020d400ULL,
0x00000096007f7306ULL, 0x000ee2000020d400ULL, 0x0000007a7d00720bULL, 0x002fe40003f7d000ULL,
0x00000093807d723eULL, 0x000fc400000010ffULL, 0x000000017b7b4812ULL, 0x004fca00078efcffULL,
0x0000007c7058723cULL, 0x000f620000041858ULL, 0x0000007b7676723eULL, 0x000fc600000010ffULL,
0x000000017f7f3812ULL, 0x008fc800078efcffULL, 0x0000007c6c38723cULL, 0x000f620000041838ULL,
0x0000007f2277723eULL, 0x000fce00000010ffULL, 0x000000767048723cULL, 0x080b6e0000041848ULL,
0x000000101d707824ULL, 0x120fe200078e0225ULL, 0x000000766c6c723cULL, 0x000b620000041828ULL,
0x000000101e257824ULL, 0x000fc800078e0225ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002528783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000000770707231ULL, 0x082fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x0000000528287231ULL, 0x088fe400003400ffULL, 0x000000052a2a7231ULL, 0x000fe400003400ffULL,
0x0000000429297231ULL, 0x080fe400003400ffULL, 0x000000042b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010217c7824ULL, 0x000fe200078e0200ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0xfffffff823237812ULL, 0x000fc800078ec0ffULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x00000100788f7824ULL, 0x010fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011478ULL, 0x0000007800267306ULL, 0x000fe20000009400ULL,
0x00000018ff827819ULL, 0x000fe2000001147aULL, 0x0000010079927824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x004fe2000001147dULL, 0x000001007aa57824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x000001007ba97824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001147bULL, 0x0000002100947306ULL, 0x000fe20000209400ULL,
0x00000018ff9e7819ULL, 0x000fe2000001147fULL, 0x000001007cb57824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011492ULL, 0x000001007db87824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fc400000114a5ULL, 0x00000018ff257819ULL, 0x000fe20000011479ULL,
0x0000002100977306ULL, 0x000fe20000205400ULL, 0x00000018ff957819ULL, 0x000fe4000001147eULL,
0x00000018ffae7819ULL, 0x000fe400000114a9ULL, 0x00000018ffb57819ULL, 0x000fe400000114b5ULL,
0x00000018ffbe7819ULL, 0x000fe200000114b8ULL, 0x0000002100967306ULL, 0x0005f0000020d400ULL,
0x0000008200aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff217819ULL, 0x004fce000001147cULL,
0x0000008200ab7306ULL, 0x000ff00000205400ULL, 0x0000008200777306ULL, 0x000ff0000020d400ULL,
0x0000009000c17306ULL, 0x000ff00000209400ULL, 0x0000009000c67306ULL, 0x000ff00000205400ULL,
0x0000009000827306ULL, 0x000ff0000020d400ULL, 0x0000007800277306ULL, 0x000eb00000005400ULL,
0x0000007900987306ULL, 0x000ff00000009400ULL, 0x0000007900997306ULL, 0x000f220000005400ULL,
0x000000272600720bULL, 0x004fe20003f7d000ULL, 0x000001007e267824ULL, 0x000fc400078e00ffULL,
0x000001007f277824ULL, 0x000fc600078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000008f00907306ULL, 0x000fe20000209400ULL, 0x00000018ff277819ULL, 0x000fce0000011427ULL,
0x0000008f00917306ULL, 0x000ea20000205400ULL, 0x000000999800720bULL, 0x010fce0003fdd000ULL,
0x00000086008a7306ULL, 0x000ff00000209400ULL, 0x00000086008b7306ULL, 0x000fe20000205400ULL,
0x000000919000720bULL, 0x004fce0003f9d000ULL, 0x0000008600227306ULL, 0x000ff0000020d400ULL,
0x0000002100ba7306ULL, 0x000ff00000209400ULL, 0x0000002100bb7306ULL, 0x000ff00000205400ULL,
0x0000002100837306ULL, 0x000ff0000020d400ULL, 0x0000009e00877306ULL, 0x000ff00000209400ULL,
0x0000009e00867306ULL, 0x000ff00000205400ULL, 0x0000009e00217306ULL, 0x0005f0000020d400ULL,
0x00000078006a7306ULL, 0x0008e2000000d400ULL, 0x00010000799e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe4000001149eULL, 0x00000079009a7306ULL, 0x000ea2000000d400ULL,
0x0001000078787824ULL, 0x010fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000008f00937306ULL, 0x000f22000020d400ULL, 0x000000016a6a3812ULL, 0x008fce00078efcffULL,
0x0000009b009c7306ULL, 0x000fe20000209400ULL, 0x000000019a9a6812ULL, 0x004fce00078efcffULL,
0x0000009b009d7306ULL, 0x000ea20000205400ULL, 0x0000000193934812ULL, 0x010fe400078efcffULL,
0x000000979400720bULL, 0x000fe20003f9d000ULL, 0x000100007f947824ULL, 0x000fc800078e00ffULL,
0x0000009b009f7306ULL, 0x000ee2000020d400ULL, 0x00000018ff947819ULL, 0x000fce0000011494ULL,
0x0000009e008f7306ULL, 0x000fe20000209400ULL, 0x0000009d9c00720bULL, 0x004fe40003f1d000ULL,
0x0000000196964812ULL, 0x000fca00078efcffULL, 0x0000009e00a07306ULL, 0x000eac0000205400ULL,
0x000000019f9f0812ULL, 0x008fe400078efcffULL, 0x000000a5009b7306ULL, 0x000ff00000209400ULL,
0x000000a500a87306ULL, 0x000ee20000205400ULL, 0x000000a08f00720bULL, 0x004fce0003f7d000ULL,
0x0000002500a17306ULL, 0x000ff00000209400ULL, 0x0000002500a47306ULL, 0x000ea20000205400ULL,
0x000000a89b00720bULL, 0x008fce0003fdd000ULL, 0x00000025006b7306ULL, 0x000ef0000020d400ULL,
0x0000009500857306ULL, 0x000fe20000209400ULL, 0x000000a4a100720bULL, 0x004fce0003f1d000ULL,
0x0000009500887306ULL, 0x000fec0000205400ULL, 0x000000016b6b0812ULL, 0x008fe400078efcffULL,
0x0000009500257306ULL, 0x000ff0000020d400ULL, 0x0000009e00a27306ULL, 0x000eb0000020d400ULL,
0x000000a500a77306ULL, 0x000ef0000020d400ULL, 0x0000007b00ac7306ULL, 0x000fe20000009400ULL,
0x00000001a2a23812ULL, 0x004fc800078efcffULL, 0x000000a26b6b723eULL, 0x000fc600000010ffULL,
0x0000007b00ad7306ULL, 0x000ea20000005400ULL, 0x00000001a7a76812ULL, 0x008fe400078efcffULL,
0x000000abaa00720bULL, 0x000fca0003fdd000ULL, 0x0000007800927306ULL, 0x000ff00000209400ULL,
0x0000007800957306ULL, 0x000ee20000205400ULL, 0x000000adac00720bULL, 0x004fe40003f7d000ULL,
0x0000000177776812ULL, 0x000fca00078efcffULL, 0x000000ae00af7306ULL, 0x000ff00000209400ULL,
0x000000ae00b07306ULL, 0x000ea20000205400ULL, 0x000000959200720bULL, 0x008fce0003fbd000ULL,
0x0000007a00a37306ULL, 0x000ff00000009400ULL, 0x0000007a00a67306ULL, 0x000fe20000005400ULL,
0x000000b0af00720bULL, 0x004fce0003f9d000ULL, 0x0000007a008c7306ULL, 0x0005f0000000d400ULL,
0x0000007800797306ULL, 0x000722000020d400ULL, 0x000100007a7a7824ULL, 0x004fce00078e00ffULL,
0x0000007b00897306ULL, 0x000462000000d400ULL, 0x00000018ff787819ULL, 0x008fce000001147aULL,
0x000000ae00b27306ULL, 0x000ee2000020d400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x0000000179795812ULL, 0x010fe400078efcffULL, 0x000000a6a300720bULL, 0x000fe40003fbd000ULL,
0x00000018ffa57819ULL, 0x000fe4000001147bULL, 0x00000078009e7306ULL, 0x000fe20000209400ULL,
0x0000000189893812ULL, 0x002fce00078efcffULL, 0x0000007800a97306ULL, 0x000e620000205400ULL,
0x00000001b2b24812ULL, 0x008fe400078efcffULL, 0x000000018c8c5812ULL, 0x000fca00078efcffULL,
0x0000007c00b37306ULL, 0x000ff00000009400ULL, 0x0000007c00b67306ULL, 0x000ea20000005400ULL,
0x000000a99e00720bULL, 0x002fce0003f1d000ULL, 0x0000007d00bc7306ULL, 0x000ff00000009400ULL,
0x0000007d00bd7306ULL, 0x000e620000005400ULL, 0x000000b6b300720bULL, 0x004fce0003f7d000ULL,
0x000000b500ae7306ULL, 0x000ff00000209400ULL, 0x000000b500b77306ULL, 0x000ea20000205400ULL,
0x000000bdbc00720bULL, 0x002fce0003fdd000ULL, 0x0000007c00847306ULL, 0x0002f0000000d400ULL,
0x0000007d00817306ULL, 0x0008e2000000d400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000b7ae00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000078007a7306ULL, 0x000e62000020d400ULL, 0x000100007d7d7824ULL, 0x010fe200078e00ffULL,
0x0000000184843812ULL, 0x008fe400078efcffULL, 0x000000bbba00720bULL, 0x000fe40003f7d000ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x000000a500b17306ULL, 0x000fe20000209400ULL,
0x0000000181816812ULL, 0x000fce00078efcffULL, 0x000000a500b47306ULL, 0x000ea20000205400ULL,
0x000000017a7a0812ULL, 0x002fe400078efcffULL, 0x0000000183833812ULL, 0x000fe400078efcffULL,
0x0000007a777a723eULL, 0x000fc600000010ffULL, 0x000000a5007b7306ULL, 0x000e70000020d400ULL,
0x000000b500b97306ULL, 0x000ee2000020d400ULL, 0x000000b4b100720bULL, 0x004fce0003fbd000ULL,
0x000000be00bf7306ULL, 0x000fec0000209400ULL, 0x000000017b7b5812ULL, 0x002fe400078efcffULL,
0x000000be00c07306ULL, 0x000e620000205400ULL, 0x00000001b9b94812ULL, 0x008fce00078efcffULL,
0x0000007c00787306ULL, 0x000ff00000209400ULL, 0x0000007c00a57306ULL, 0x000ea20000205400ULL,
0x000000c0bf00720bULL, 0x002fce0003f1d000ULL, 0x0000007d00b57306ULL, 0x000ff00000209400ULL,
0x0000007d00c47306ULL, 0x000e620000205400ULL, 0x000000a57800720bULL, 0x004fe40003f9d000ULL,
0x0000008ca778723eULL, 0x000fca00000010ffULL, 0x000000be00c27306ULL, 0x000eb0000020d400ULL,
0x0000007c00b87306ULL, 0x000ee2000020d400ULL, 0x000000c4b500720bULL, 0x002fce0003fdd000ULL,
0x0000007d00917306ULL, 0x000e62000020d400ULL, 0x00000001c2c20812ULL, 0x004fe400078efcffULL,
0x000000c6c100720bULL, 0x000fca0003f1d000ULL, 0x0000007e00c37306ULL, 0x000fe20000009400ULL,
0x00000001b8b84812ULL, 0x008fc800078efcffULL, 0x000000b883b8723eULL, 0x000fc600000010ffULL,
0x0000007e00c87306ULL, 0x000ea20000005400ULL, 0x0000000191916812ULL, 0x002fe400078efcffULL,
0x0000000182820812ULL, 0x000fe400078efcffULL, 0x0000008b8a00720bULL, 0x000fc60003f1d000ULL,
0x0000007f008d7306ULL, 0x000ff00000009400ULL, 0x0000007f008e7306ULL, 0x000e620000005400ULL,
0x000000c8c300720bULL, 0x004fe40003fbd000ULL, 0x0000000122220812ULL, 0x000fc800078efcffULL,
0x0000007b227b723eULL, 0x000fe200000010ffULL, 0x00000026007c7306ULL, 0x000fec0000209400ULL,
0x0000007a2838723cULL, 0x000f640000041838ULL, 0x0000002600957306ULL, 0x000ea20000205400ULL,
0x0000008e8d00720bULL, 0x002fca0003f7d000ULL, 0x0000007a7058723cULL, 0x000f640000041858ULL,
0x00000027007d7306ULL, 0x000ff00000209400ULL, 0x0000002700927306ULL, 0x000e620000205400ULL,
0x000000957c00720bULL, 0x004fc40003f9d000ULL, 0x00000084b97c723eULL, 0x000fe400000010ffULL,
0x0000009182b9723eULL, 0x000fc600000010ffULL, 0x0000007e00807306ULL, 0x0004e8000000d400ULL,
0x000000b82830723cULL, 0x000f680000041830ULL, 0x00000026008f7306ULL, 0x0008e2000020d400ULL,
0x000100007e7e7824ULL, 0x004fe200078e00ffULL, 0x000000927d00720bULL, 0x002fc40003fdd000ULL,
0x00000081c27d723eULL, 0x000fe200000010ffULL, 0x000000b87050723cULL, 0x000f620000041850ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007f00767306ULL, 0x000e62000000d400ULL,
0x0000006a9326723eULL, 0x010fe400000010ffULL, 0x0000000180805812ULL, 0x008fe400078efcffULL,
0x000000868700720bULL, 0x000fe20003fbd000ULL, 0x0000007c2834723cULL, 0x000f620000041834ULL,
0x00000079966a723eULL, 0x000fe200000010ffULL, 0x0000002700977306ULL, 0x0004e2000020d400ULL,
0x000000018f8f4812ULL, 0x000fc400078efcffULL, 0x000000888500720bULL, 0x000fe40003f9d000ULL,
0x00000089b279723eULL, 0x000fe200000010ffULL, 0x0000006a2840723cULL, 0x040f620000041840ULL,
0x000000808f80723eULL, 0x000fe200000010ffULL, 0x0000007e007f7306ULL, 0x000fe20000209400ULL,
0x0000000176763812ULL, 0x002fe400078efcffULL, 0x0000000121215812ULL, 0x000fe400078efcffULL,
0x0000009a9f27723eULL, 0x004fe200000010ffULL, 0x00000078283c723cULL, 0x000f64000004183cULL,
0x0000007e00907306ULL, 0x000e620000205400ULL, 0x0000000197976812ULL, 0x008fc400078efcffULL,
0x0000000125254812ULL, 0x000fe400078efcffULL, 0x000000769781723eULL, 0x000fe200000010ffULL,
0x000000262844723cULL, 0x040f640000041844ULL, 0x0000009400937306ULL, 0x000fec0000209400ULL,
0x00000080282c723cULL, 0x000f64000004182cULL, 0x00000094008c7306ULL, 0x000ea20000205400ULL,
0x000000907f00720bULL, 0x002fca0003fdd000ULL, 0x000000267064723cULL, 0x040f640000041864ULL,
0x0000007e007e7306ULL, 0x000e6c000020d400ULL, 0x00000078705c723cULL, 0x000f64000004185cULL,
0x0000009400947306ULL, 0x000ee2000020d400ULL, 0x0000008c9300720bULL, 0x004fca0003f7d000ULL,
0x0000007c7054723cULL, 0x000f620000041854ULL, 0x000000017e7e6812ULL, 0x002fc800078efcffULL,
0x0000007e257e723eULL, 0x000fc600000010ffULL, 0x00000080704c723cULL, 0x000f62000004184cULL,
0x0000000194943812ULL, 0x008fc800078efcffULL, 0x00000094217f723eULL, 0x000fc600000010ffULL,
0x0000006a7060723cULL, 0x040b6e0000041860ULL, 0x0001a6c8136a7811ULL, 0x020fe200078e18ffULL,
0x0000007e7048723cULL, 0x080b700000041848ULL, 0x0000007e2828723cULL, 0x000b62000004186cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6980023ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff217224ULL, 0x000fc600078e00ffULL,
0x0000000000227805ULL, 0x004fc80000015200ULL, 0x000004000d257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e23ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000121217810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f227810ULL, 0x000fc80007ffe0ffULL, 0x000000152200720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x000000020f227810ULL, 0x000fe40007ffe0ffULL,
0x000001000c217810ULL, 0x000fe40007ffe0ffULL, 0x000000152200720cULL, 0x000fc60003f06070ULL,
0x0000660012257a24ULL, 0x000fd400078e0221ULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x00000021160c7217ULL, 0x000fe20007800000ULL, 0x00000010116b7824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x000fc60000011617ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a21ULL,
0x00000004276d7810ULL, 0x020fe20007ffe0ffULL, 0x000000016b227824ULL, 0x000fe200078e0227ULL,
0x00000008276f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c6b0c7217ULL, 0x000fe20007800000ULL,
0x0000000122217824ULL, 0x040fe200078e0217ULL, 0x0000000c27717810ULL, 0x000fe20007ffe0ffULL,
0x0000000822267824ULL, 0x000fe400078e00ffULL, 0x000000016b6e7824ULL, 0x000fc400078e026dULL,
0x0000000122227824ULL, 0x000fe200078e0225ULL, 0xfffffff826217812ULL, 0x000fe200078ee221ULL,
0x000000010c0c7824ULL, 0x000fe400078e0a6bULL, 0x000000016e267824ULL, 0x000fe400078e0225ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000c2700720cULL, 0x080fe40003f06070ULL,
0x0000000c6d00720cULL, 0x080fe20003f86070ULL, 0x000000016b707824ULL, 0x000fe200078e026fULL,
0x0000000b226c7212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000c6f00720cULL, 0x000fc40003f66070ULL, 0x000062006c6c7a10ULL, 0x000fe20007fbe0ffULL,
0x00000001706a7824ULL, 0x000fe200078e0225ULL, 0x0000000b26267212ULL, 0x080fe200078efcffULL,
0x000000016b727824ULL, 0x000fe200078e0271ULL, 0x00006300236d7a10ULL, 0x000fe20002ffe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe40007fde0ffULL,
0x0000000c7100720cULL, 0x000fe20003fa6070ULL, 0x0000000172227824ULL, 0x000fe200078e0225ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x000000016e257824ULL, 0x040fe200078e0217ULL,
0x0000630027277a10ULL, 0x000fe200037fe4ffULL, 0x000000086e6e7824ULL, 0x000fe200078e00ffULL,
0x000062006a6a7a10ULL, 0x000fe20007fde0ffULL, 0x0000008022227825ULL, 0x000fc600078e00ffULL,
0xfffffff86e257812ULL, 0x000fe200078ee225ULL, 0x00000001700c7824ULL, 0x100fe200078e0217ULL,
0x0000000b22227212ULL, 0x000fe200078efcffULL, 0x00000008706f7824ULL, 0x000fe200078e00ffULL,
0x000063006b6b7a10ULL, 0x000fe200037fe4ffULL, 0x00000001726e7824ULL, 0x000fe200078e0217ULL,
0x0000620022227a10ULL, 0x000fe20007fde0ffULL, 0x0000000872717824ULL, 0x000fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee20cULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0x0000630023237a10ULL, 0x000fe200037fe4ffULL, 0x0000001025257824ULL, 0x000fe200078e0200ULL,
0xfffffff871717812ULL, 0x000fe200078ee26eULL, 0x000000106f6f7824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c217faeULL, 0x0003e6000c101c48ULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0x0000000026257faeULL, 0x0003e8000e101c48ULL,
0x000000006a6f7faeULL, 0x0003e8000d901c48ULL, 0x0000000022717faeULL, 0x0003e2000e901c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x00000010110c7824ULL, 0x000fca00078e00ffULL,
0x0000000c170c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c267810ULL, 0x040fe20007ffe0ffULL,
0x000000010c217824ULL, 0x140fe200078e0217ULL, 0x000000080c6a7810ULL, 0x040fe20007ffe0ffULL,
0x000000080c6c7824ULL, 0x020fe400078e00ffULL, 0x0000000126227824ULL, 0x040fe400078e0217ULL,
0x00000008266f7824ULL, 0x000fe200078e00ffULL, 0xfffffff86c217812ULL, 0x000fe200078ee221ULL,
0x000000016a237824ULL, 0x040fe400078e0217ULL, 0x000000086a6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee222ULL, 0x000000010c227824ULL, 0x140fe200078e0225ULL,
0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000126267824ULL, 0x000fe200078e0225ULL,
0xfffffff86e717812ULL, 0x000fe200078ee223ULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x000000016a6a7824ULL, 0x100fe200078e0225ULL, 0x0000000b22227212ULL, 0x000fe200078efcffULL,
0x000000010c6c7824ULL, 0x000fe400078e0225ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fc60007f1e0ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000630023237a10ULL, 0x000fe200007fe4ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000000b6a6a7212ULL, 0x080fe400078efcffULL,
0x0000620026267a10ULL, 0x000fe20007f7e0ffULL, 0x000000010c257824ULL, 0x000fe200078e0217ULL,
0x0000000b6c6c7212ULL, 0x000fe200078efcffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x000062006a6a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0x000062006c6c7a10ULL, 0x000fe20007f9e0ffULL, 0x000000106f6f7824ULL, 0x100fe200078e0200ULL,
0xfffffff80c257812ULL, 0x000fe200078ee225ULL, 0x0000001071717824ULL, 0x100fe200078e0200ULL,
0x0000630027277a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022217faeULL, 0x0003e2000b901c48ULL, 0x000063006b6b7a10ULL, 0x000fe200007fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0x000063006d6d7a10ULL, 0x000fe200027fe4ffULL,
0x00000000266f7faeULL, 0x0003e8000b901c48ULL, 0x000000006a717faeULL, 0x0003e8000b901c48ULL,
0x000000006c257faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000814217812ULL, 0x000fe200078ec0ffULL, 0x00000020100c7824ULL, 0x000fc400078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x00000001210c7824ULL, 0x000fe200078e020cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000008227f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a668000c6a7f8cULL, 0x000662000c80043fULL, 0x000000ffff217224ULL, 0x004fc600078e0023ULL,
0x0000000000227805ULL, 0x000fc80000015200ULL, 0x01a66c000c257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fe4000780486bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6c7224ULL, 0x020fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622257210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e23ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011426ULL, 0x0000002508087211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0626ULL, 0x0000000208087819ULL, 0x000fc80000001225ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c000c257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018010087811ULL, 0x000fc800078e38ffULL,
0x000000080a087210ULL, 0x000fca0007ffe00bULL, 0x01a00000086d7984ULL, 0x000e680000000800ULL,
0x01a20000080c7984ULL, 0x0084e20000000800ULL, 0x000000206d00720bULL, 0x002fe20003f1d000ULL,
0x0000f8c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800000e0100ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0020ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000310237810ULL, 0x000fe40007ffe0ffULL,
0x000000206d00720bULL, 0x000fe40003f74000ULL, 0x0000001a2300720cULL, 0x000fe20003f05270ULL,
0x0000f8827f007947ULL, 0x000fd4000b800000ULL, 0x00000000006f7806ULL, 0x000fc400018e0100ULL,
0x000000801a0b8824ULL, 0x000fe200078e020bULL, 0x000000206d237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a0a8824ULL, 0x000fca00078e020bULL,
0x01a400230a008388ULL, 0x0003e20000000800ULL, 0x000000ff6f00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000020230a7221ULL, 0x002fe20000010100ULL,
0x000000ff6fff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00277308ULL, 0x000e640000000800ULL,
0x0000002724247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x0000f7d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002a400000e0000ULL, 0x0000002664647220ULL, 0x084fe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x000fc40000410000ULL, 0x000000264c4c7220ULL, 0x080fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006fff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x0000f6b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00046400000e0000ULL,
0x0000002666667220ULL, 0x086fe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x000fc40000410000ULL,
0x000000264e4e7220ULL, 0x080fe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006fff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x0000f5927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00046400000e0000ULL, 0x0000002644447220ULL, 0x086fe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x000000262c2c7220ULL, 0x080fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002628287220ULL, 0x080fe40000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x0000f4827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00046400000e0000ULL, 0x0000002646467220ULL, 0x086fe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x000fc40000410000ULL, 0x000000262e2e7220ULL, 0x080fe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x000000262a2a7220ULL, 0x080fe40000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006f08ff7212ULL, 0x000fda00078030ffULL, 0x0000006d236d0221ULL, 0x000fe20000010100ULL,
0x00007610ff220816ULL, 0x000fc60000000022ULL, 0x3fb8aa3b6d6d0820ULL, 0x000fc80000410000ULL,
0x0000006d00090308ULL, 0x000e640000000800ULL, 0x000000090c0c0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000240c247221ULL, 0x008fc40000010000ULL,
0x00000000000a7805ULL, 0x000fca0000015200ULL, 0xfffffff014207812ULL, 0x000fca00078ec0ffULL,
0x01a6b40020257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x000000260a257210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e0bULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011426ULL,
0x0000002508087211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0626ULL,
0x0000000208087819ULL, 0x000fc80000001225ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b40020257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991022087816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff087819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000f0727f007947ULL, 0x000fea000b800000ULL,
0x00001f0827077589ULL, 0x0002a400000e0000ULL, 0x0000000808267810ULL, 0x000fe20007ffe0ffULL,
0x0000f0b27f007947ULL, 0x000fea000b800000ULL, 0x0000001008047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x0000001808267810ULL, 0x008fe20007ffe0ffULL, 0x0000f1227f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000113087812ULL, 0x002fe200078ec0ffULL, 0x0000000803257824ULL, 0x000fe200078e00ffULL,
0x00000004ff0b7819ULL, 0x000fe20000011617ULL, 0x0000000802277824ULL, 0x008fe200078e00ffULL,
0x0000100000007810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x0000000408087824ULL, 0x000fc400078e020bULL,
0x000000041a0b7824ULL, 0x000fe400078e00ffULL, 0x00000001030a7824ULL, 0x100fe400078e0208ULL,
0x0000000102087824ULL, 0x000fe200078e0208ULL, 0x000000040b0c7812ULL, 0x000fe200078ec0ffULL,
0x000000101c787824ULL, 0x000fe200078e0200ULL, 0xfffffff8250b7812ULL, 0x000fe400078ee20aULL,
0xfffffff827257812ULL, 0x000fe400078ee208ULL, 0x00015000100a7811ULL, 0x000fc400078e60ffULL,
0x000000020c0c7812ULL, 0x000fc600078efcffULL, 0x000000100b0b7824ULL, 0x100fe200078e020aULL,
0x0000000c17087211ULL, 0x000fe200078fe0ffULL, 0x0000001025257824ULL, 0x000fe400078e020aULL,
0x00000008030c7824ULL, 0x040fe200078e00ffULL, 0x000000000b6c783bULL, 0x0002e20000000200ULL,
0x0000000103037824ULL, 0x000fc600078e0208ULL, 0x000000002568783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x000000076c6c7231ULL, 0x08cfe400003400ffULL,
0x000000076e6e7231ULL, 0x000fe400003400ffULL, 0x000000066d6d7231ULL, 0x080fe400003400ffULL,
0x000000066f6f7231ULL, 0x000fe400003400ffULL, 0x0000000568687231ULL, 0x080fe400003400ffULL,
0x000000056a6a7231ULL, 0x000fc400003400ffULL, 0x0000000469697231ULL, 0x080fe400003400ffULL,
0x000000046b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff80c037812ULL, 0x000fe200078ee203ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x000000101e1e7824ULL, 0x000fe200078e020aULL, 0x00000fa000007945ULL, 0x000fe20003800000ULL,
0x0000000102087824ULL, 0x000fe400078e0208ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000370783bULL, 0x000e620000004200ULL, 0x0000010078887824ULL, 0x010fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fe2000001147aULL, 0x00000100798b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x002fe20000011478ULL, 0x0000007800267306ULL, 0x000fe20000009400ULL,
0x00000018ff887819ULL, 0x000fe20000011488ULL, 0x000001007aa07824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001148bULL, 0x000001007ba47824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147bULL, 0x0000010070b27824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011471ULL, 0x0000002200a37306ULL, 0x000fe20000209400ULL,
0x00000018ff977819ULL, 0x000fe20000011473ULL, 0x0000010071b67824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc40000011479ULL, 0x00000018ff8e7819ULL, 0x000fe40000011472ULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x0000002200a67306ULL, 0x000fe20000205400ULL,
0x00000018ffa77819ULL, 0x000fe400000114a4ULL, 0x00000018ffb27819ULL, 0x000fe400000114b2ULL,
0x00000018ffb97819ULL, 0x000fc600000114b6ULL, 0x0000002200837306ULL, 0x000ff0000020d400ULL,
0x0000008900be7306ULL, 0x000ff00000209400ULL, 0x0000008900bf7306ULL, 0x000ff00000205400ULL,
0x0000008900227306ULL, 0x000ff0000020d400ULL, 0x0000008800897306ULL, 0x000ff00000209400ULL,
0x00000088008a7306ULL, 0x000e700000205400ULL, 0x0000000b008d7306ULL, 0x000ff00000209400ULL,
0x0000000b00907306ULL, 0x000fe20000205400ULL, 0x0000008a8900720bULL, 0x002fce0003fbd000ULL,
0x0000000b00927306ULL, 0x0003f0000020d400ULL, 0x0000007800277306ULL, 0x000f220000005400ULL,
0x00000018ff0b7819ULL, 0x002fce0000011470ULL, 0x0000007800877306ULL, 0x0002f0000000d400ULL,
0x00000079008f7306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x000000272600720bULL, 0x010fe20003fdd000ULL, 0x0000010072267824ULL, 0x000fc400078e00ffULL,
0x0000010073277824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007900947306ULL, 0x000e620000005400ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff277819ULL, 0x000fc80000011427ULL, 0x0000000187876812ULL, 0x008fe200078efcffULL,
0x0000009300957306ULL, 0x000fe20000209400ULL, 0x000000908d00720bULL, 0x000fce0003fdd000ULL,
0x0000009300967306ULL, 0x000ee20000205400ULL, 0x000000948f00720bULL, 0x002fca0003f9d000ULL,
0x0000000192926812ULL, 0x000fe400078efcffULL, 0x0000007e00ae7306ULL, 0x000ff00000209400ULL,
0x0000007e00af7306ULL, 0x000fe20000205400ULL, 0x000000969500720bULL, 0x008fce0003f7d000ULL,
0x0000007e00777306ULL, 0x000ff0000020d400ULL, 0x0000000b00b57306ULL, 0x000ff00000209400ULL,
0x0000000b00b87306ULL, 0x000ff00000205400ULL, 0x0000000b00257306ULL, 0x000ff0000020d400ULL,
0x0000009700817306ULL, 0x000ff00000209400ULL, 0x00000097007e7306ULL, 0x000ff00000205400ULL,
0x00000097000b7306ULL, 0x0003f0000020d400ULL, 0x0000001c009b7306ULL, 0x000fe20000209400ULL,
0x0001000079977824ULL, 0x002fca00078e00ffULL, 0x00000018ff977819ULL, 0x000fe40000011497ULL,
0x0000001c009c7306ULL, 0x000ff00000205400ULL, 0x0000001c009d7306ULL, 0x000ff0000020d400ULL,
0x0000008e007d7306ULL, 0x000ff00000209400ULL, 0x0000008e00807306ULL, 0x000ff00000205400ULL,
0x0000008e001c7306ULL, 0x000ff0000020d400ULL, 0x00000088008c7306ULL, 0x000e70000020d400ULL,
0x00000078008b7306ULL, 0x000ff00000209400ULL, 0x00000078008e7306ULL, 0x000ee20000205400ULL,
0x000000018c8c5812ULL, 0x002fce00078efcffULL, 0x0000007900917306ULL, 0x000e70000000d400ULL,
0x0000009300987306ULL, 0x000f22000020d400ULL, 0x0000008e8b00720bULL, 0x008fce0003fbd000ULL,
0x0000009700887306ULL, 0x000fe20000209400ULL, 0x0000000191914812ULL, 0x002fe400078efcffULL,
0x0000009c9b00720bULL, 0x000fca0003f9d000ULL, 0x0000009700997306ULL, 0x000e620000205400ULL,
0x0000000198983812ULL, 0x010fce00078efcffULL, 0x0000007800797306ULL, 0x000ee2000020d400ULL,
0x000000019d9d4812ULL, 0x000fce00078efcffULL, 0x000000a000937306ULL, 0x000fe20000209400ULL,
0x000000998800720bULL, 0x002fce0003f7d000ULL, 0x000000a000a27306ULL, 0x000e620000205400ULL,
0x0000000179795812ULL, 0x008fce00078efcffULL, 0x00000097009a7306ULL, 0x000ef0000020d400ULL,
0x0000007a009e7306ULL, 0x000fe20000009400ULL, 0x000000a29300720bULL, 0x002fce0003fbd000ULL,
0x0000007a009f7306ULL, 0x000e620000005400ULL, 0x000000019a9a3812ULL, 0x008fce00078efcffULL,
0x0000007a00867306ULL, 0x000730000000d400ULL, 0x0000007b00a57306ULL, 0x000fe20000009400ULL,
0x000100007a7a7824ULL, 0x008fe200078e00ffULL, 0x0000009f9e00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007b00a87306ULL, 0x000e6e0000005400ULL,
0x0000000186866812ULL, 0x010fe200078efcffULL, 0x000000a700a97306ULL, 0x000fe20000209400ULL,
0x000000a6a300720bULL, 0x000fce0003fdd000ULL, 0x000000a700aa7306ULL, 0x000ee20000205400ULL,
0x000000a8a500720bULL, 0x002fca0003f9d000ULL, 0x0000000183836812ULL, 0x000fe400078efcffULL,
0x0000007b00827306ULL, 0x000330000000d400ULL, 0x000000a000a17306ULL, 0x000ea2000020d400ULL,
0x000100007b7b7824ULL, 0x002fe200078e00ffULL, 0x000000aaa900720bULL, 0x008fc80003f7d000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x0000000182824812ULL, 0x010fe400078efcffULL, 0x000000afae00720bULL, 0x000fca0003f9d000ULL,
0x0000007a00977306ULL, 0x000e620000205400ULL, 0x00000001a1a15812ULL, 0x004fce00078efcffULL,
0x000000a700ab7306ULL, 0x000ea2000020d400ULL, 0x0000000177774812ULL, 0x000fce00078efcffULL,
0x0000007b00a07306ULL, 0x000fe20000209400ULL, 0x000000977800720bULL, 0x002fce0003fbd000ULL,
0x0000007b00ad7306ULL, 0x000e620000205400ULL, 0x00000001abab3812ULL, 0x004fce00078efcffULL,
0x0000007a00a47306ULL, 0x000eb0000020d400ULL, 0x000000b200a77306ULL, 0x000fe20000209400ULL,
0x000000ada000720bULL, 0x002fce0003f7d000ULL, 0x000000b200b47306ULL, 0x000e620000205400ULL,
0x00000001a4a45812ULL, 0x004fc800078efcffULL, 0x000000a483a4723eULL, 0x000fc600000010ffULL,
0x0000007b00ac7306ULL, 0x000eb0000020d400ULL, 0x0000007000b07306ULL, 0x000fe20000009400ULL,
0x000000b4a700720bULL, 0x002fce0003fbd000ULL, 0x0000007000b17306ULL, 0x000e620000005400ULL,
0x00000001acac3812ULL, 0x004fc800078efcffULL, 0x000000ac77a5723eULL, 0x000fc600000010ffULL,
0x0000007000767306ULL, 0x0004e8000000d400ULL, 0x000000a46c58723cULL, 0x000f680000041858ULL,
0x0000007100b77306ULL, 0x000fe20000009400ULL, 0x0001000070707824ULL, 0x004fe200078e00ffULL,
0x000000b1b000720bULL, 0x002fc40003fdd000ULL, 0x000000a46838723cULL, 0x000f640000041838ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000007100ba7306ULL, 0x000e6e0000005400ULL,
0x0000000176766812ULL, 0x008fe200078efcffULL, 0x000000b900bb7306ULL, 0x000fe20000209400ULL,
0x000000b8b500720bULL, 0x000fce0003fdd000ULL, 0x000000b900bc7306ULL, 0x000ea20000205400ULL,
0x000000bab700720bULL, 0x002fca0003f9d000ULL, 0x0000000125256812ULL, 0x000fe400078efcffULL,
0x0000007100207306ULL, 0x0002f0000000d400ULL, 0x000000b200b37306ULL, 0x000f22000020d400ULL,
0x0001000071717824ULL, 0x002fe200078e00ffULL, 0x000000bcbb00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x00000070007a7306ULL, 0x000fe20000209400ULL,
0x0000000120204812ULL, 0x008fce00078efcffULL, 0x00000070007b7306ULL, 0x000e620000205400ULL,
0x00000001b3b35812ULL, 0x010fc800078efcffULL, 0x00000076b376723eULL, 0x000fc600000010ffULL,
0x000000b900bd7306ULL, 0x000eb0000020d400ULL, 0x0000007100897306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x002fce0003fbd000ULL, 0x00000071008a7306ULL, 0x000e620000205400ULL,
0x00000001bdbd3812ULL, 0x004fe400078efcffULL, 0x000000bfbe00720bULL, 0x000fe40003f7d000ULL,
0x00000020bd77723eULL, 0x000fc600000010ffULL, 0x0000007000b67306ULL, 0x0004e8000020d400ULL,
0x000000766c54723cULL, 0x080f680000041854ULL, 0x0000002600887306ULL, 0x000fe20000209400ULL,
0x0000008a8900720bULL, 0x002fe40003f9d000ULL, 0x000000799270723eULL, 0x004fe200000010ffULL,
0x000000766834723cULL, 0x000f620000041834ULL, 0x0000000122223812ULL, 0x000fc600078efcffULL,
0x00000026008d7306ULL, 0x000e620000205400ULL, 0x00000001b6b65812ULL, 0x008fc800078efcffULL,
0x000000b625b6723eULL, 0x000fc600000010ffULL, 0x00000071008b7306ULL, 0x0004f0000020d400ULL,
0x0000007200847306ULL, 0x000fe20000009400ULL, 0x0000008d8800720bULL, 0x002fe40003fbd000ULL,
0x0000009a9d71723eULL, 0x004fca00000010ffULL, 0x0000007200857306ULL, 0x000e620000005400ULL,
0x000000018b8b4812ULL, 0x008fe200078efcffULL, 0x000000706c60723cULL, 0x000f660000041860ULL,
0x0000008b22b7723eULL, 0x000fc600000010ffULL, 0x00000073007c7306ULL, 0x000fe40000009400ULL,
0x000000706840723cULL, 0x000f6c0000041840ULL, 0x00000073007f7306ULL, 0x000ea20000005400ULL,
0x000000858400720bULL, 0x002fe20003fdd000ULL, 0x000000b66c50723cULL, 0x080f6c0000041850ULL,
0x00000027008e7306ULL, 0x000fe40000209400ULL, 0x000000b66830723cULL, 0x000f6c0000041830ULL,
0x0000002700937306ULL, 0x000e620000205400ULL, 0x0000007f7c00720bULL, 0x004fce0003f7d000ULL,
0x00000072000c7306ULL, 0x0004f0000000d400ULL, 0x0000007300037306ULL, 0x0008e2000000d400ULL,
0x0001000072727824ULL, 0x004fe200078e00ffULL, 0x000000938e00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff787819ULL, 0x000fe40000011472ULL, 0x00000026008f7306ULL, 0x0002a2000020d400ULL,
0x0001000073737824ULL, 0x010fe200078e00ffULL, 0x000000010c0c6812ULL, 0x008fe400078efcffULL,
0x0000007e8100720bULL, 0x000fe40003fdd000ULL, 0x00000086a172723eULL, 0x000fe400000010ffULL,
0x0000002700907306ULL, 0x000722000020d400ULL, 0x000000878c26723eULL, 0x002fc400000010ffULL,
0x00000018ff877819ULL, 0x000fe40000011473ULL, 0x00000082ab73723eULL, 0x000fe400000010ffULL,
0x0000000103033812ULL, 0x000fe200078efcffULL, 0x00000078007a7306ULL, 0x000fe20000209400ULL,
0x000000018f8f5812ULL, 0x004fe400078efcffULL, 0x000000807d00720bULL, 0x000fe20003fbd000ULL,
0x000000726c5c723cULL, 0x000f62000004185cULL, 0x000000010b0b6812ULL, 0x000fc400078efcffULL,
0x000000919827723eULL, 0x008fe200000010ffULL, 0x00000078007b7306ULL, 0x000e620000205400ULL,
0x0000000190904812ULL, 0x010fc600078efcffULL, 0x00000072683c723cULL, 0x000f68000004183cULL,
0x0000008700797306ULL, 0x000fe20000209400ULL, 0x000000011c1c5812ULL, 0x000fc600078efcffULL,
0x000000266c64723cULL, 0x000f680000041864ULL, 0x0000008700827306ULL, 0x000ea20000205400ULL,
0x0000007b7a00720bULL, 0x002fc60003f9d000ULL, 0x000000266844723cULL, 0x000f680000041844ULL,
0x00000078007d7306ULL, 0x0002f0000020d400ULL, 0x0000008700207306ULL, 0x000f22000020d400ULL,
0x000000827900720bULL, 0x004fc40003f7d000ULL, 0x0000000c8f78723eULL, 0x002fe400000010ffULL,
0x000000039079723eULL, 0x000fe200000010ffULL, 0x000000101d037824ULL, 0x000fe200078e020aULL,
0x000000017d7d4812ULL, 0x008fc800078efcffULL, 0x0000007d1c7a723eULL, 0x000fe200000010ffULL,
0x000000786c4c723cULL, 0x000f64000004184cULL, 0x0000000120203812ULL, 0x010fc800078efcffULL,
0x000000200b7b723eULL, 0x000fe400000010ffULL, 0x00000078682c723cULL, 0x000f62000004182cULL,
0x00000008020b7824ULL, 0x000fce00078e00ffULL, 0x0000007a6c48723cULL, 0x080b6e0000041848ULL,
0x000000101f6c7824ULL, 0x020fe200078e0200ULL, 0x0000007a6828723cULL, 0x000b620000041828ULL,
0x000000001e1c783bULL, 0x000e680000000200ULL, 0x000000000368783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fda0003800000ULL, 0x0000000768687231ULL, 0x088fe400003400ffULL,
0x000000076a6a7231ULL, 0x000fc400003400ffULL, 0x0000000669697231ULL, 0x080fe400003400ffULL,
0x000000066b6b7231ULL, 0x000fe400003400ffULL, 0x000000051c1c7231ULL, 0x082fe400003400ffULL,
0x000000051e1e7231ULL, 0x000fe400003400ffULL, 0x000000041d1d7231ULL, 0x080fe400003400ffULL,
0x000000041f1f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff80b037812ULL, 0x004fe200078ee208ULL, 0x000000006c6c783bULL, 0x000ea80000004200ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000370783bULL, 0x000f220000004200ULL,
0x00000018ff797819ULL, 0x004fe2000001146eULL, 0x000001006d7c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff027819ULL, 0x000fe2000001146cULL, 0x0000006c00267306ULL, 0x000fe20000009400ULL,
0x00000018ff087819ULL, 0x000fe2000001146dULL, 0x000100006d887824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001146fULL, 0x000001006f997824ULL, 0x000fe200078e00ffULL,
0x00000018ff227819ULL, 0x010fe20000011470ULL, 0x000001006e927824ULL, 0x000fc400078e00ffULL,
0x0000007900937306ULL, 0x000fe20000209400ULL, 0x00000018ff7a7819ULL, 0x000fe20000011471ULL,
0x0000010070a17824ULL, 0x000fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe20000011472ULL,
0x0000010071a77824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011473ULL,
0x0000010072b57824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011488ULL,
0x0000007900987306ULL, 0x000fe20000205400ULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x0000010073ba7824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fc40000011492ULL,
0x00000018ffa17819ULL, 0x000fe400000114a1ULL, 0x00000018ffaa7819ULL, 0x000fe200000114a7ULL,
0x00000079009a7306ULL, 0x0005e2000020d400ULL, 0x00000018ffb57819ULL, 0x000fe400000114b5ULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x00000002007e7306ULL, 0x000fe20000209400ULL,
0x000001006c797824ULL, 0x004fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000000200817306ULL, 0x000ff00000205400ULL, 0x0000000200807306ULL, 0x000ff0000020d400ULL,
0x00000008008c7306ULL, 0x000ff00000209400ULL, 0x00000008008d7306ULL, 0x000ff00000205400ULL,
0x00000008008e7306ULL, 0x000ff0000020d400ULL, 0x0000002200a67306ULL, 0x000ff00000209400ULL,
0x0000002200a97306ULL, 0x000ff00000205400ULL, 0x00000022000c7306ULL, 0x000ff0000020d400ULL,
0x0000007a00b17306ULL, 0x000ff00000209400ULL, 0x0000007a00b27306ULL, 0x000ff00000205400ULL,
0x0000007a000a7306ULL, 0x000ff0000020d400ULL, 0x0000007b00257306ULL, 0x000ff00000209400ULL,
0x0000007b00767306ULL, 0x000ff00000205400ULL, 0x0000007b00087306ULL, 0x000ff0000020d400ULL,
0x0000008500777306ULL, 0x000ff00000209400ULL, 0x0000008500227306ULL, 0x000ff00000205400ULL,
0x0000008500027306ULL, 0x0005f0000020d400ULL, 0x00000079007a7306ULL, 0x000fe20000209400ULL,
0x00000018ff857819ULL, 0x004fce000001147cULL, 0x00000079007b7306ULL, 0x000eb00000205400ULL,
0x0000006c00277306ULL, 0x000f300000005400ULL, 0x0000008500867306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x004fce0003f1d000ULL, 0x0000008500877306ULL, 0x000ea20000205400ULL,
0x000000272600720bULL, 0x010fce0003f9d000ULL, 0x00000079007d7306ULL, 0x000f30000020d400ULL,
0x0000006d00827306ULL, 0x000fe20000009400ULL, 0x000000878600720bULL, 0x004fce0003f7d000ULL,
0x0000006d00837306ULL, 0x000ea20000005400ULL, 0x000000017d7d0812ULL, 0x010fe400078efcffULL,
0x000000817e00720bULL, 0x000fca0003f1d000ULL, 0x0000006c00787306ULL, 0x0008f0000000d400ULL,
0x0000008500897306ULL, 0x000e62000020d400ULL, 0x000100006c6c7824ULL, 0x010fe200078e00ffULL,
0x000000838200720bULL, 0x004fc40003fdd000ULL, 0x0000000180800812ULL, 0x000fe400078efcffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000008800797306ULL, 0x000fe20000209400ULL,
0x0000000178784812ULL, 0x008fce00078efcffULL, 0x00000088008a7306ULL, 0x000ea20000205400ULL,
0x0000000189893812ULL, 0x002fe400078efcffULL, 0x0000008d8c00720bULL, 0x000fca0003f7d000ULL,
0x0000006d00847306ULL, 0x000e70000000d400ULL, 0x0000007f009d7306ULL, 0x000fe20000209400ULL,
0x0000008a7900720bULL, 0x004fe40003f9d000ULL, 0x000000018e8e3812ULL, 0x000fca00078efcffULL,
0x0000007f00a07306ULL, 0x000fe20000205400ULL, 0x0000000184846812ULL, 0x002fce00078efcffULL,
0x0000007f00a27306ULL, 0x000ff0000020d400ULL, 0x0000006c007c7306ULL, 0x000ff00000209400ULL,
0x0000006c007f7306ULL, 0x000e700000205400ULL, 0x0000006c006d7306ULL, 0x000eb0000020d400ULL,
0x00000099006c7306ULL, 0x000fe20000209400ULL, 0x0000007f7c00720bULL, 0x002fce0003fbd000ULL,
0x00000099009b7306ULL, 0x000e6c0000205400ULL, 0x000000016d6d5812ULL, 0x004fe400078efcffULL,
0x0000009200857306ULL, 0x000ff00000209400ULL, 0x0000009200947306ULL, 0x000ea20000205400ULL,
0x0000009b6c00720bULL, 0x002fce0003f1d000ULL, 0x00000088008b7306ULL, 0x000e70000020d400ULL,
0x0000006f00957306ULL, 0x000fe20000009400ULL, 0x000000948500720bULL, 0x004fce0003fdd000ULL,
0x0000006f009c7306ULL, 0x000ea20000005400ULL, 0x000000018b8b4812ULL, 0x002fce00078efcffULL,
0x000000a100887306ULL, 0x000ff00000209400ULL, 0x000000a100a37306ULL, 0x000e620000205400ULL,
0x0000009c9500720bULL, 0x004fce0003f9d000ULL, 0x00000070009f7306ULL, 0x000ff00000009400ULL,
0x0000007000a47306ULL, 0x000fe20000005400ULL, 0x000000a38800720bULL, 0x002fce0003f7d000ULL,
0x0000007000207306ULL, 0x0003f0000000d400ULL, 0x00000099009e7306ULL, 0x000ea2000020d400ULL,
0x0001000070707824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007100a87306ULL, 0x000ff00000009400ULL, 0x0000007100ab7306ULL, 0x000e620000005400ULL,
0x000000019e9e0812ULL, 0x004fce00078efcffULL, 0x0000009200967306ULL, 0x000eb0000020d400ULL,
0x0000006f00977306ULL, 0x000ee2000000d400ULL, 0x000000aba800720bULL, 0x002fce0003f1d000ULL,
0x000000a100a57306ULL, 0x000e62000020d400ULL, 0x0000000196966812ULL, 0x004fe400078efcffULL,
0x000000a49f00720bULL, 0x000fca0003fdd000ULL, 0x0000006e008f7306ULL, 0x000fe20000009400ULL,
0x0000000197974812ULL, 0x008fc800078efcffULL, 0x000000979e97723eULL, 0x000fc600000010ffULL,
0x0000006e00907306ULL, 0x000ea20000005400ULL, 0x00000001a5a53812ULL, 0x002fe400078efcffULL,
0x000000a9a600720bULL, 0x000fe40003f7d000ULL, 0x0000000120206812ULL, 0x000fc600078efcffULL,
0x0000006e00917306ULL, 0x0002f0000000d400ULL, 0x0000007000927306ULL, 0x000fe20000209400ULL,
0x000100006e6e7824ULL, 0x002fe200078e00ffULL, 0x000000908f00720bULL, 0x004fc40003fbd000ULL,
0x000000010c0c3812ULL, 0x000fe400078efcffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000007000997306ULL, 0x000e620000205400ULL, 0x000000a09d00720bULL, 0x000fcc0003f7d000ULL,
0x0000000191915812ULL, 0x008fe200078efcffULL, 0x00000071000b7306ULL, 0x0004e6000000d400ULL,
0x000000919696723eULL, 0x000fc600000010ffULL, 0x00000001a2a23812ULL, 0x000fe400078efcffULL,
0x0000006e00267306ULL, 0x000fe20000209400ULL, 0x0001000071717824ULL, 0x004fe200078e00ffULL,
0x000000999200720bULL, 0x002fe20003f9d000ULL, 0x00000096685c723cULL, 0x000b66000004185cULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000006e00277306ULL, 0x000e620000205400ULL,
0x000000010b0b0812ULL, 0x008fc400078efcffULL, 0x000000961c3c723cULL, 0x000b6a000004183cULL,
0x0000007100a17306ULL, 0x000ff00000209400ULL, 0x0000007100b07306ULL, 0x000ea20000205400ULL,
0x000000272600720bULL, 0x002fc40003f1d000ULL, 0x000000787d26723eULL, 0x000fe400000010ffULL,
0x000000848927723eULL, 0x000fc600000010ffULL, 0x0000007000a77306ULL, 0x0002e8000020d400ULL,
0x000000266864723cULL, 0x000b680000041864ULL, 0x000000aa00ac7306ULL, 0x000fe20000209400ULL,
0x000100006f707824ULL, 0x002fe200078e00ffULL, 0x000000b0a100720bULL, 0x004fc40003fdd000ULL,
0x000000261c44723cULL, 0x000b640000041844ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x000000aa00ad7306ULL, 0x000e620000205400ULL, 0x00000001a7a74812ULL, 0x008fe400078efcffULL,
0x000000989300720bULL, 0x000fca0003f9d000ULL, 0x0000006e006f7306ULL, 0x0004f0000020d400ULL,
0x0000007100af7306ULL, 0x000f22000020d400ULL, 0x000000adac00720bULL, 0x002fe20003fbd000ULL,
0x00010000736e7824ULL, 0x004fe200078e00ffULL, 0x000000019a9a4812ULL, 0x000fc800078efcffULL,
0x00000018ff787819ULL, 0x000fe2000001146eULL, 0x00000070006c7306ULL, 0x000fe20000209400ULL,
0x000000016f6f0812ULL, 0x008fe400078efcffULL, 0x000000b2b100720bULL, 0x000fe40003f1d000ULL,
0x0000006f9a9a723eULL, 0x000fe400000010ffULL, 0x00000020a56e723eULL, 0x000fe200000010ffULL,
0x0000007000717306ULL, 0x000e620000205400ULL, 0x00000001afaf6812ULL, 0x010fce00078efcffULL,
0x000000aa00ae7306ULL, 0x000ea2000020d400ULL, 0x000000010a0a0812ULL, 0x000fe400078efcffULL,
0x000000762500720bULL, 0x000fca0003f1d000ULL, 0x0000007200b37306ULL, 0x000fe20000009400ULL,
0x000000716c00720bULL, 0x002fe40003fdd000ULL, 0x0000006d806c723eULL, 0x000fe400000010ffULL,
0x0000008b8e6d723eULL, 0x000fc600000010ffULL, 0x0000007200b47306ULL, 0x000e620000005400ULL,
0x00000001aeae5812ULL, 0x004fe400078efcffULL, 0x0000000108080812ULL, 0x000fe200078efcffULL,
0x0000006c6860723cULL, 0x000b620000041860ULL, 0x0000000bae6f723eULL, 0x000fc600000010ffULL,
0x000000b500aa7306ULL, 0x000fe80000209400ULL, 0x0000006e6854723cULL, 0x000b680000041854ULL,
0x000000b500b77306ULL, 0x000ea20000205400ULL, 0x000000b4b300720bULL, 0x002fc60003fbd000ULL,
0x0000006c1c40723cULL, 0x040b680000041840ULL, 0x000000ba00bb7306ULL, 0x000fe80000209400ULL,
0x0000006e1c34723cULL, 0x000b680000041834ULL, 0x000000ba00bc7306ULL, 0x000e620000205400ULL,
0x000000b7aa00720bULL, 0x004fce0003f9d000ULL, 0x0000007200037306ULL, 0x0004f0000000d400ULL,
0x0000007300b87306ULL, 0x000fe20000009400ULL, 0x0001000072727824ULL, 0x004fe200078e00ffULL,
0x000000bcbb00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000007300b97306ULL, 0x000fe20000005400ULL, 0x0000000103035812ULL, 0x008fce00078efcffULL,
0x0000007300007306ULL, 0x000ff0000000d400ULL, 0x000000b500b67306ULL, 0x000e70000020d400ULL,
0x000000ba007b7306ULL, 0x000eb0000020d400ULL, 0x00000070009b7306ULL, 0x000ee2000020d400ULL,
0x00000001b6b64812ULL, 0x002fc400078efcffULL, 0x000000227700720bULL, 0x000fe40003f9d000ULL,
0x00000003b6b6723eULL, 0x000fc600000010ffULL, 0x0000007200737306ULL, 0x000fe20000209400ULL,
0x000000017b7b3812ULL, 0x004fce00078efcffULL, 0x0000007200707306ULL, 0x000e620000205400ULL,
0x000000019b9b6812ULL, 0x008fe400078efcffULL, 0x000000b9b800720bULL, 0x000fe40003fdd000ULL,
0x0000000102024812ULL, 0x000fe400078efcffULL, 0x0000009ba29b723eULL, 0x000fe200000010ffULL,
0x0000007800717306ULL, 0x000fec0000209400ULL, 0x0000009a6858723cULL, 0x000b640000041858ULL,
0x00000078007a7306ULL, 0x000ea20000205400ULL, 0x000000707300720bULL, 0x002fc40003fbd000ULL,
0x0000000100006812ULL, 0x000fe400078efcffULL, 0x000000a70c70723eULL, 0x000fe200000010ffULL,
0x0000009a1c38723cULL, 0x000b620000041838ULL, 0x000000007bb7723eULL, 0x000fe200000010ffULL,
0x0000007200257306ULL, 0x000e6c000020d400ULL, 0x000000b6684c723cULL, 0x000b64000004184cULL,
0x00000078000b7306ULL, 0x000ee2000020d400ULL, 0x0000007a7100720bULL, 0x004fc40003f7d000ULL,
0x000000af0a71723eULL, 0x000fc600000010ffULL, 0x000000b61c2c723cULL, 0x000b62000004182cULL,
0x0000000125255812ULL, 0x002fc800078efcffULL, 0x00000025080a723eULL, 0x000fc600000010ffULL,
0x000000706850723cULL, 0x000b620000041850ULL, 0x000000010b0b3812ULL, 0x008fc800078efcffULL,
0x0000000b020b723eULL, 0x000fc600000010ffULL, 0x000000701c30723cULL, 0x000b700000041830ULL,
0x0000000a6848723cULL, 0x080b700000041848ULL, 0x0000000a1c28723cULL, 0x000b620000041828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x000000000d027f8cULL, 0x0002a2000c80043fULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0001a6a010087811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000008ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x004fe200078e0003ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff160000007947ULL, 0x000fea000383ffffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff0f7224ULL, 0x020fe400078e002bULL, 0x000000ffff6a7224ULL, 0x000fe400078e002aULL,
0x000000ffff0d7224ULL, 0x002fe400078e002fULL, 0x000000ffff687224ULL, 0x000fc400078e002eULL,
0x000000ffff0b7224ULL, 0x000fe400078e0033ULL, 0x000000ffff207224ULL, 0x000fe400078e0032ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000024007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0001032000047802ULL, 0x000fc40000000f00ULL, 0x0000d28000007944ULL, 0x00cfea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002400037308ULL, 0x004e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000024ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006b00ff037624ULL, 0x000fe400078e00ffULL, 0x00006a00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x000f28000c1e9900ULL, 0x0000000000087919ULL, 0x008ee80000000000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000001808057811ULL, 0x048fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x002fe40000011604ULL,
0x0000001008157811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x014fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f1506027589ULL, 0x000f2200000e0000ULL,
0x0000006400647220ULL, 0x002fc40000410000ULL, 0x0000006500657220ULL, 0x040fe40000410000ULL,
0x0000006000607220ULL, 0x040fe40000410000ULL, 0x0000006100617220ULL, 0x040fe40000410000ULL,
0x0000005c005c7220ULL, 0x040fe40000410000ULL, 0x0000005d005d7220ULL, 0x040fe40000410000ULL,
0x0000005800587220ULL, 0x000fc40000410000ULL, 0x0000005900597220ULL, 0x040fe40000410000ULL,
0x0000005400547220ULL, 0x040fe40000410000ULL, 0x0000005500557220ULL, 0x040fe40000410000ULL,
0x0000005000507220ULL, 0x040fe40000410000ULL, 0x0000005100517220ULL, 0x040fe40000410000ULL,
0x0000004c004c7220ULL, 0x000fc40000410000ULL, 0x0000004d004d7220ULL, 0x040fe40000410000ULL,
0x0000004800487220ULL, 0x040fe40000410000ULL, 0x0000004900497220ULL, 0x000fe40000410000ULL,
0x0000004605467220ULL, 0x044fe40000410000ULL, 0x0000004705477220ULL, 0x040fe40000410000ULL,
0x0000004205427220ULL, 0x000fc40000410000ULL, 0x0000004305437220ULL, 0x040fe40000410000ULL,
0x0000003e053e7220ULL, 0x040fe40000410000ULL, 0x0000003f053f7220ULL, 0x040fe40000410000ULL,
0x0000003a053a7220ULL, 0x040fe40000410000ULL, 0x0000003b053b7220ULL, 0x040fe40000410000ULL,
0x0000003605367220ULL, 0x000fc40000410000ULL, 0x0000003705377220ULL, 0x040fe40000410000ULL,
0x0000002005207220ULL, 0x040fe40000410000ULL, 0x0000000b050b7220ULL, 0x040fe40000410000ULL,
0x0000006805687220ULL, 0x040fe40000410000ULL, 0x0000000d050d7220ULL, 0x040fe40000410000ULL,
0x0000006a056a7220ULL, 0x000fc40000410000ULL, 0x0000000f050f7220ULL, 0x000fe40000410000ULL,
0x0000000466667220ULL, 0x088fe40000410000ULL, 0x0000000467677220ULL, 0x080fe40000410000ULL,
0x0000000462627220ULL, 0x080fe40000410000ULL, 0x0000000463637220ULL, 0x080fe40000410000ULL,
0x000000045e5e7220ULL, 0x000fc40000410000ULL, 0x000000045f5f7220ULL, 0x080fe40000410000ULL,
0x000000045a5a7220ULL, 0x080fe40000410000ULL, 0x000000045b5b7220ULL, 0x080fe40000410000ULL,
0x0000000456567220ULL, 0x080fe40000410000ULL, 0x0000000457577220ULL, 0x080fe40000410000ULL,
0x0000000452527220ULL, 0x000fc40000410000ULL, 0x0000000453537220ULL, 0x080fe40000410000ULL,
0x000000044e4e7220ULL, 0x080fe40000410000ULL, 0x000000044f4f7220ULL, 0x080fe40000410000ULL,
0x000000044a4a7220ULL, 0x080fe40000410000ULL, 0x000000044b4b7220ULL, 0x000fe40000410000ULL,
0x0000000244447220ULL, 0x010fc40000410000ULL, 0x0000000245457220ULL, 0x080fe40000410000ULL,
0x0000000240407220ULL, 0x080fe40000410000ULL, 0x0000000241417220ULL, 0x080fe40000410000ULL,
0x000000023c3c7220ULL, 0x080fe40000410000ULL, 0x000000023d3d7220ULL, 0x080fe40000410000ULL,
0x0000000238387220ULL, 0x000fc40000410000ULL, 0x0000000239397220ULL, 0x080fe40000410000ULL,
0x0000000234347220ULL, 0x080fe40000410000ULL, 0x0000000235357220ULL, 0x080fe40000410000ULL,
0x0000000230307220ULL, 0x080fe40000410000ULL, 0x0000000231317220ULL, 0x080fe40000410000ULL,
0x000000022c2c7220ULL, 0x000fc40000410000ULL, 0x000000022d2d7220ULL, 0x080fe40000410000ULL,
0x0000000228287220ULL, 0x080fe40000410000ULL, 0x0000000229297220ULL, 0x000fc40000410000ULL,
0x0000000000037919ULL, 0x004e620000000000ULL, 0x000000666766723eULL, 0x000fe400000010ffULL,
0x000000626333723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000005e5f5e723eULL, 0x000fc400000010ffULL, 0x0000005a5b2f723eULL, 0x000fe400000010ffULL,
0x000000565756723eULL, 0x000fe400000010ffULL, 0x00000052532b723eULL, 0x000fe400000010ffULL,
0x0000004e4f4e723eULL, 0x000fe400000010ffULL, 0x0000004a4b27723eULL, 0x000fe400000010ffULL,
0x0000541066327816ULL, 0x000fc40000000033ULL, 0x0000000803057811ULL, 0x042fe400078ff0ffULL,
0x0000001003097811ULL, 0x040fe400078ff0ffULL, 0x0000000203007812ULL, 0x000fe200078ec0ffULL,
0x0000000805177824ULL, 0x000fe200078e00ffULL, 0x00000002ff077819ULL, 0x000fe20000011603ULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0x0000001803157811ULL, 0x000fe400078ff0ffULL,
0x0000000500047211ULL, 0x040fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000700027211ULL, 0x000fc400078ff8ffULL, 0x0000000900057211ULL, 0x040fe200078ff8ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000001500067211ULL, 0x000fe200078ff8ffULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe40007ffe0ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x008fe200078ee200ULL, 0x0000200011007824ULL, 0x000fe200078e00ffULL,
0xfffffff8170a7812ULL, 0x000fc400078ee204ULL, 0xfffffff815147812ULL, 0x000fe400078ee206ULL,
0xfffffff805047812ULL, 0x000fe200078ee202ULL, 0x0000100013057824ULL, 0x000fe200078e0200ULL,
0x0000000402067810ULL, 0x040fe40007ffe0ffULL, 0x0000000602077810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee206ULL,
0x0000001004067824ULL, 0x000fe200078e0205ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x000000100a107824ULL, 0x100fe200078e0205ULL, 0x0000000802077812ULL, 0x000fe200078ec0ffULL,
0x00000010080a7824ULL, 0x100fe200078e0205ULL, 0x000000646502723eULL, 0x000fe200000010ffULL,
0x0000001012127824ULL, 0x000fe200078e0205ULL, 0x000000606104723eULL, 0x000fe200000010ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000505106723eULL, 0x000fe200000010ffULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x00005410021c7816ULL, 0x100fe20000000004ULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x00007632021d7816ULL, 0x000fe20000000004ULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0x0000005c5d02723eULL, 0x000fe200000010ffULL,
0x0000000107107824ULL, 0x000fe200078e0210ULL, 0x000000585904723eULL, 0x000fe200000010ffULL,
0x0000001c08007388ULL, 0x0003e20000000a00ULL, 0x000000545505723eULL, 0x000fe200000010ffULL,
0x0000000107127824ULL, 0x000fe200078e0212ULL, 0x000000444544723eULL, 0x000fe200000010ffULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x000000404122723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x0000763266337816ULL, 0x000fe20000000033ULL,
0x00000001070c7824ULL, 0x040fe200078e020cULL, 0x000054105e2e7816ULL, 0x000fe2000000002fULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x0000004c4d07723eULL, 0x000fc400000010ffULL,
0x000000484908723eULL, 0x002fe400000010ffULL, 0x00005410021c7816ULL, 0x140fe40000000004ULL,
0x00007632021d7816ULL, 0x000fe40000000004ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x0000001c0a007388ULL, 0x000fe20000000a00ULL,
0x0000541007067816ULL, 0x000fc40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000040c007388ULL, 0x000fe20000000a00ULL, 0x0000003c3d3c723eULL, 0x000fe400000010ffULL,
0x00000038391e723eULL, 0x000fe200000010ffULL, 0x000000060e007388ULL, 0x0003e20000000a00ULL,
0x000076325e2f7816ULL, 0x000fe4000000002fULL, 0x00005410562a7816ULL, 0x140fe2000000002bULL,
0x0000003210007388ULL, 0x000fe20000000a00ULL, 0x00007632562b7816ULL, 0x000fc4000000002bULL,
0x000054104e267816ULL, 0x140fe20000000027ULL, 0x0004002e0a007388ULL, 0x000fe20000000a00ULL,
0x000076324e277816ULL, 0x000fe40000000027ULL, 0x000054103c087816ULL, 0x000fe2000000001eULL,
0x0004002a0c007388ULL, 0x000fe20000000a00ULL, 0x0000541044067816ULL, 0x142fe40000000022ULL,
0x0000763244077816ULL, 0x000fe20000000022ULL, 0x000400260e007388ULL, 0x000fe20000000a00ULL,
0x000076323c097816ULL, 0x000fc4000000001eULL, 0x000000343534723eULL, 0x000fe200000010ffULL,
0x0000000612007388ULL, 0x0003e20000000a00ULL, 0x00000030311a723eULL, 0x000fe400000010ffULL,
0x0000002c2d2c723eULL, 0x000fe200000010ffULL, 0x000800080a007388ULL, 0x0005e20000000a00ULL,
0x000000282916723eULL, 0x000fe400000010ffULL, 0x000000464702723eULL, 0x000fe400000010ffULL,
0x000000424304723eULL, 0x000fc400000010ffULL, 0x0000003e3f05723eULL, 0x000fe200000010ffULL,
0x0000000174077824ULL, 0x002fe200078e0203ULL, 0x0000003a3b06723eULL, 0x000fe400000010ffULL,
0x0000541034087816ULL, 0x044fe2000000001aULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000763234097816ULL, 0x000fca000000001aULL, 0x000800080c007388ULL, 0x0003e40000000a00ULL,
0x000054102c087816ULL, 0x142fe40000000016ULL, 0x000076322c097816ULL, 0x000fca0000000016ULL,
0x000800080e007388ULL, 0x0003e40000000a00ULL, 0x0000541002087816ULL, 0x142fe40000000004ULL,
0x0000763202097816ULL, 0x000fe40000000004ULL, 0x000000363702723eULL, 0x000fe400000010ffULL,
0x000000200b04723eULL, 0x000fe200000010ffULL, 0x0000000814007388ULL, 0x0003e60000000a00ULL,
0x00005410021c7816ULL, 0x000fc40000000004ULL, 0x00007632021d7816ULL, 0x000fe40000000004ULL,
0x000000ff00027306ULL, 0x000fe20000205400ULL, 0x0000541005087816ULL, 0x142fe40000000006ULL,
0x0000763205097816ULL, 0x000fca0000000006ULL, 0x000000ff00047306ULL, 0x000fe2000020d400ULL,
0x000000680d05723eULL, 0x000fe400000010ffULL, 0x0000006a0f06723eULL, 0x000fe200000010ffULL,
0x000c00080a007388ULL, 0x000fe60000000a00ULL, 0x00007632050d7816ULL, 0x140fe20000000006ULL,
0x000c001c0c007388ULL, 0x0003e40000000a00ULL, 0x00005410050c7816ULL, 0x002fc40000000006ULL,
0x000000ff00057306ULL, 0x000e660000209400ULL, 0x000c000c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000007087984ULL, 0x000ea20000000c00ULL,
0x000000020500720bULL, 0x002fc60003f1d000ULL, 0x00040000071c7984ULL, 0x000e680000000c00ULL,
0x0008000007247984ULL, 0x000ee80000000c00ULL, 0x000c0000070c7984ULL, 0x000f280000000c00ULL,
0x0010000007147984ULL, 0x000ee20000000c00ULL, 0x0000000104040812ULL, 0x000fc400078efcffULL,
0x000000ff1300720cULL, 0x000fe20003f05270ULL, 0x0014000007207984ULL, 0x000f220000000c00ULL,
0x000000040404723eULL, 0x000fc600000010ffULL, 0x0018000007287984ULL, 0x000f280000000c00ULL,
0x001c0000072c7984ULL, 0x000f220000000c00ULL, 0x3f803f80040b7831ULL, 0x044fe4000020000bULL,
0x3f803f80040a7831ULL, 0x040fe4000020000aULL, 0x3f803f8004097831ULL, 0x040fe40000200009ULL,
0x3f803f8004087831ULL, 0x000fc40000200008ULL, 0x3f803f80041f7831ULL, 0x042fe4000020001fULL,
0x3f803f80041e7831ULL, 0x040fe4000020001eULL, 0x3f803f80041d7831ULL, 0x040fe4000020001dULL,
0x3f803f80041c7831ULL, 0x040fe4000020001cULL, 0x3f803f8004277831ULL, 0x048fe40000200027ULL,
0x3f803f8004267831ULL, 0x000fc40000200026ULL, 0x3f803f8004257831ULL, 0x040fe40000200025ULL,
0x3f803f8004247831ULL, 0x040fe40000200024ULL, 0x3f803f80040f7831ULL, 0x050fe4000020000fULL,
0x3f803f80040e7831ULL, 0x040fe4000020000eULL, 0x3f803f80040d7831ULL, 0x040fe4000020000dULL,
0x3f803f80040c7831ULL, 0x000fc4000020000cULL, 0x3f803f800b0b7831ULL, 0x000fe40000200017ULL,
0x3f803f800a0a7831ULL, 0x000fe40000200016ULL, 0x3f803f8009097831ULL, 0x000fe40000200015ULL,
0x3f803f8008087831ULL, 0x000fe40000200014ULL, 0x3f803f801f1f7831ULL, 0x000fe40000200023ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200022ULL, 0x0000000807007388ULL, 0x000fe20000000c00ULL,
0x3f803f801d1d7831ULL, 0x000fc40000200021ULL, 0x3f803f801c1c7831ULL, 0x000fe40000200020ULL,
0x3f803f8027277831ULL, 0x000fe4000020002bULL, 0x3f803f8026267831ULL, 0x000fe2000020002aULL,
0x0004001c07007388ULL, 0x000fe20000000c00ULL, 0x3f803f8025257831ULL, 0x000fe40000200029ULL,
0x3f803f8024247831ULL, 0x000fe40000200028ULL, 0x3f803f800f0f7831ULL, 0x000fc4000020002fULL,
0x3f803f800e0e7831ULL, 0x000fe2000020002eULL, 0x0008002407007388ULL, 0x000fe20000000c00ULL,
0x3f803f800d0d7831ULL, 0x000fe4000020002dULL, 0x3f803f800c0c7831ULL, 0x000fca000020002cULL,
0x000c000c07007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x000000190400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0x0000000104027824ULL, 0x000fe200078e0203ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00000007030e7812ULL, 0x000fe200078ec0ffULL,
0x00005a0000067ab9ULL, 0x000fe40000000800ULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fc6000800063fULL, 0x0ffffff802057812ULL, 0x000fe200078ef803ULL,
0x000000201b027824ULL, 0x000fe200078e0204ULL, 0x0000580000067ab9ULL, 0x000fc60000000800ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x0000000502077c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000005087984ULL, 0x0004e20000000c00ULL,
0x0000000118077824ULL, 0x000fe200078e0207ULL, 0x00000006040472a4ULL, 0x002fc6000f8e023fULL,
0x0000007502077224ULL, 0x000fe200078e0207ULL, 0x0000002003027810ULL, 0x000fe40007ffe0ffULL,
0x0000000475067c24ULL, 0x000fca000f8e02ffULL, 0x0000000706077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0007047a11ULL, 0x000fc800078040ffULL,
0x00005d0007057a11ULL, 0x004fe200000f440cULL, 0x0000000811077824ULL, 0x000fe200078e020eULL,
0x00000003ff0c7819ULL, 0x000fc60000011602ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000190c00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0083f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000102047824ULL, 0x102fe400078e020cULL,
0x000000201b0c7824ULL, 0x000fc600078e020cULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x000000050c057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x000000750c057224ULL, 0x000fe200078e0205ULL,
0x00000040030c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811077824ULL, 0x002fc600078e0202ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0e7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000190e00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe200078e020eULL,
0x00000060030d7810ULL, 0x000fe20007ffe0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000702057812ULL, 0x002fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001005027824ULL, 0x000fe200078e0200ULL,
0x000000050e057c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL, 0x0000000002087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x000000750e057224ULL, 0x000fe200078e0205ULL,
0x00000003ff027819ULL, 0x002fc8000001160dULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000190200720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e0202ULL,
0x00000080030c7810ULL, 0x000fe20007ffe0ffULL, 0x000000201b027824ULL, 0x000fc600078e0202ULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804057812ULL, 0x000fca00078ef80dULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x0000007502057224ULL, 0x000fe200078e0205ULL,
0x000000070d027812ULL, 0x000fc800078ec0ffULL, 0x0000000506057210ULL, 0x000fe20007f1e0ffULL,
0x0000000811077824ULL, 0x002fc800078e0202ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0e7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000190e00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe200078e020eULL,
0x000000a0030d7810ULL, 0x000fe20007ffe0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000702057812ULL, 0x002fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001005027824ULL, 0x000fe200078e0200ULL,
0x000000050e057c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL, 0x0000000002087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x000000750e057224ULL, 0x000fe200078e0205ULL,
0x00000003ff027819ULL, 0x002fc8000001160dULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000190200720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e0202ULL,
0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL, 0x000000201b027824ULL, 0x000fc600078e0202ULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804057812ULL, 0x000fca00078ef80dULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x0000007502057224ULL, 0x000fe200078e0205ULL,
0x000000070d027812ULL, 0x000fc800078ec0ffULL, 0x0000000506057210ULL, 0x000fe20007f1e0ffULL,
0x0000000811077824ULL, 0x002fc800078e0202ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0e7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000190e00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe200078e020eULL,
0x000000e003047810ULL, 0x002fe20007ffe0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x000000050e077c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x00005a00ff0e7a19ULL, 0x000fe2000001160eULL,
0x0000000118077824ULL, 0x000fe200078e0207ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x000fe400078e0200ULL, 0x000000750e077224ULL, 0x000fe200078e0207ULL,
0x00000003ff0e7819ULL, 0x000fc40000011604ULL, 0x0000000005087984ULL, 0x0002a40000000c00ULL,
0x0000000706077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005c0007027a11ULL, 0x000fe200078040ffULL, 0x0000000811057824ULL, 0x002fc600078e020cULL,
0x00005d0007037a11ULL, 0x000fe200000f4410ULL, 0x0000000104077824ULL, 0x000fe200078e020eULL,
0x000000190e00720cULL, 0x000fc60003f06070ULL, 0x0000001005027825ULL, 0x000fe200078e0002ULL,
0x0000000707077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807077812ULL, 0x000fe200078ef804ULL,
0x0000000802007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000007087984ULL, 0x002e620000000c00ULL,
0x0000000811117824ULL, 0x000fe200078e0204ULL, 0x000000050e037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0e7a19ULL, 0x000fc6000001160eULL, 0x0000000118037824ULL, 0x000fc800078e0203ULL,
0x000000750e037224ULL, 0x000fca00078e0203ULL, 0x0000000306037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4400ULL, 0x0000001011027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006a00ff5c7624ULL, 0x000fe400078e00ffULL, 0x00006b00ff5d7624ULL, 0x000fca00078e00ffULL,
0x000000085c5c7981ULL, 0x000522000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0300780cULL, 0x000fe20003f04070ULL, 0x000000020e077824ULL, 0x000fe200078e00ffULL,
0x01a60000ff047f8cULL, 0x000ee2000c80043fULL, 0x000000401a1b7824ULL, 0x000fe400078e00ffULL,
0x0000590007147a24ULL, 0x000fc800078e0212ULL, 0x0000660014227a24ULL, 0x000fc800078e021bULL,
0x00000c7000000947ULL, 0x000fea0003800000ULL, 0x00000003ff387819ULL, 0x000fe40000011617ULL,
0x0000001b16067217ULL, 0x002fe40007800000ULL, 0x0000000438087810ULL, 0x040fe40007ffe0ffULL,
0x00000008380e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000106037824ULL, 0x000fe200078e0a1bULL,
0x00000010380c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108077824ULL, 0x100fe200078e0217ULL,
0x0000000c38187810ULL, 0x000fe20007ffe0ffULL, 0x0000000808247824ULL, 0x040fe200078e00ffULL,
0x000000030800720cULL, 0x080fe20003fa6070ULL, 0x0000000122067824ULL, 0x000fe200078e0238ULL,
0x00000014381e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010e097824ULL, 0x000fe200078e0217ULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x000000080e267824ULL, 0x000fe200078e00ffULL,
0x0000001838207810ULL, 0x000fe20007ffe0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000031800720cULL, 0x000fc40003f46070ULL, 0xfffffff826267812ULL, 0x000fe200078ee209ULL,
0x0000000122087824ULL, 0x000fe200078e0208ULL, 0x0000007006107812ULL, 0x100fe200078ef802ULL,
0x000000010c067824ULL, 0x100fe200078e0217ULL, 0x0000001c38307810ULL, 0x000fe20007ffe0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe40007f1e0ffULL,
0x0000002038327810ULL, 0x000fe20007ffe0ffULL, 0x000000080c0d7824ULL, 0x000fe200078e00ffULL,
0x0000007008127812ULL, 0x000fe200078ef802ULL, 0x00000001180a7824ULL, 0x040fe200078e0217ULL,
0x0000630007117a10ULL, 0x000fe200007fe4ffULL, 0x00000008180b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d2a7812ULL, 0x000fe200078ee206ULL, 0x0000000122067824ULL, 0x000fe200078e020eULL,
0x0000620012127a10ULL, 0x000fe20007f3e0ffULL, 0x0000000122087824ULL, 0x000fe200078e0218ULL,
0xfffffff80b287812ULL, 0x000fe200078ee20aULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000630009137a10ULL, 0x000fc40000ffe4ffULL, 0x000000030c00720cULL, 0x080fe20003f06070ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000030e00720cULL, 0x000fe40003f26070ULL,
0x0000007006187812ULL, 0x000fe200078ef802ULL, 0x00000001220a7824ULL, 0x000fe200078e020cULL,
0x00000070081c7812ULL, 0x000fe200078ef802ULL, 0x00000001220c7824ULL, 0x000fe200078e021eULL,
0x0000620018187a10ULL, 0x000fe20007f7e0ffULL, 0x00000001220e7824ULL, 0x000fe200078e0220ULL,
0x000062001c1c7a10ULL, 0x000fe20007f9e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000630007197a10ULL, 0x000fc40001ffe4ffULL, 0x00006300091d7a10ULL, 0x000fe200027fe4ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x100fe400078ef802ULL,
0x000020001a237811ULL, 0x000fe200078e70ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fe400078ef802ULL, 0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL,
0x0000000122067824ULL, 0x000fe200078e0230ULL, 0x000000700e0e7812ULL, 0x000fe200078ef802ULL,
0x0000000138087824ULL, 0x000fe200078e0217ULL, 0x000062000c0c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000062000e0e7a10ULL, 0x000fc40007fde0ffULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x000000081e097824ULL, 0x000fe200078e00ffULL,
0x00000070061f7812ULL, 0x000fe200078ef802ULL, 0x000000011e067824ULL, 0x000fe200078e0217ULL,
0x000063000b0b7a10ULL, 0x000fe20001ffe4ffULL, 0x0000000820297824ULL, 0x000fe200078e00ffULL,
0x000063000d0d7a10ULL, 0x000fe400027fe4ffULL, 0x000063000f0f7a10ULL, 0x000fe400037fe4ffULL,
0x000000033800720cULL, 0x000fc40003f86070ULL, 0x000000031e00720cULL, 0x000fe40003f66070ULL,
0x0ffffff8082e7812ULL, 0x000fe200078ef817ULL, 0x0000000122087824ULL, 0x000fe200078e0232ULL,
0x000062001f1e7a10ULL, 0x000fe40007fde0ffULL, 0xfffffff8092c7812ULL, 0x000fe200078ee206ULL,
0x000000102e257824ULL, 0x000fe200078e0223ULL, 0x00006300071f7a10ULL, 0x000fe200037fe4ffULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x0000002438347810ULL, 0x000fc40007ffe0ffULL,
0x0000002838367810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010257faeULL, 0x0003e2000e101c48ULL, 0x0000007006217812ULL, 0x000fe200078ef802ULL,
0x0000000122087824ULL, 0x000fe200078e0234ULL, 0x000000032000720cULL, 0x040fe20003f86070ULL,
0x0000000120067824ULL, 0x000fe200078e0217ULL, 0x0000620021207a10ULL, 0x000fe20007fde0ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff8292e7812ULL, 0x000fe200078ee206ULL,
0x0000000122277824ULL, 0x000fe200078e0236ULL, 0x0000630007217a10ULL, 0x000fe200037fe4ffULL,
0x0000001024257824ULL, 0x002fe200078e0223ULL, 0x0000007008087812ULL, 0x000fe200078ef802ULL,
0x0000008027067825ULL, 0x000fc600078e00ffULL, 0x0000000012257faeULL, 0x0003e2000e901c48ULL,
0x000000033000720cULL, 0x0c0fe20003fa6070ULL, 0x0000000130117824ULL, 0x000fe200078e0217ULL,
0x0000620008087a10ULL, 0x000fe20007fde0ffULL, 0x0000000830247824ULL, 0x000fe200078e00ffULL,
0x0000007006107812ULL, 0x000fe200078ef802ULL, 0x0000001026277824ULL, 0x000fe200078e0223ULL,
0x0000002c38307810ULL, 0x000fe20007ffe0ffULL, 0x0000000134267824ULL, 0x040fe200078e0217ULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x0000000834297824ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe20007fde0ffULL, 0x0000000122067824ULL, 0x000fe200078e0230ULL,
0xfffffff824247812ULL, 0x000fe200078ee211ULL, 0x0000000018277faeULL, 0x0005e2000c901c48ULL,
0x0000630007117a10ULL, 0x000fe200037fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000033200720cULL, 0x000fc40003f26070ULL, 0xfffffff829267812ULL, 0x000fe200078ee226ULL,
0x0000000132137824ULL, 0x002fe200078e0217ULL, 0x0000007006127812ULL, 0x000fe200078ef802ULL,
0x0000000832327824ULL, 0x000fe400078e00ffULL, 0x0000001028257824ULL, 0x100fe200078e0223ULL,
0x0000620012127a10ULL, 0x000fe20007fde0ffULL, 0x000000102a197824ULL, 0x004fe200078e0223ULL,
0xfffffff832067812ULL, 0x000fe200078ee213ULL, 0x0000001026297824ULL, 0x100fe200078e0223ULL,
0x0000003038187810ULL, 0x000fe20007ffe0ffULL, 0x000000001c257faeULL, 0x0003e2000d101c48ULL,
0x0000630007137a10ULL, 0x000fe200037fe4ffULL, 0x000000102c077824ULL, 0x100fe200078e0223ULL,
0x000000033400720cULL, 0x000fe20003f46070ULL, 0x0000001006277824ULL, 0x000fe200078e0223ULL,
0x000000000a197faeULL, 0x0005e2000c101c48ULL, 0x0000000122067824ULL, 0x000fe200078e0218ULL,
0x0000003838267810ULL, 0x000fc40007ffe0ffULL, 0x000000000c077faeULL, 0x0007e2000d901c48ULL,
0x0000003c38287810ULL, 0x000fe20007ffe0ffULL, 0x0000001024257824ULL, 0x102fe200078e0223ULL,
0x0000003438247810ULL, 0x000fe20007ffe0ffULL, 0x000000102e1d7824ULL, 0x000fe200078e0223ULL,
0x000000031800720cULL, 0x080fe20003f66070ULL, 0x00000001360b7824ULL, 0x004fe200078e0217ULL,
0x000000032800720cULL, 0x080fe40003f06070ULL, 0x000000000e1d7faeULL, 0x0003e2000e101c48ULL,
0x000000033000720cULL, 0x000fe20003f86070ULL, 0x0000008006067825ULL, 0x008fc400078e00ffULL,
0x000000001e257faeULL, 0x0005e2000e901c48ULL, 0x000000033600720cULL, 0x080fe20003fa6070ULL,
0x00000001220c7824ULL, 0x000fe200078e0224ULL, 0x00000070060a7812ULL, 0x000fe200078ef802ULL,
0x0000000020277faeULL, 0x0007e2000c901c48ULL, 0x0000000118067824ULL, 0x100fe200078e0217ULL,
0x000000032600720cULL, 0x080fe20003f26070ULL, 0x00000008180d7824ULL, 0x000fe200078e00ffULL,
0x0000000008297faeULL, 0x0007e2000d101c48ULL, 0x00000008360e7824ULL, 0x002fe200078e00ffULL,
0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x00000001260f7824ULL, 0x100fe200078e0217ULL,
0x000000032400720cULL, 0x000fe20003f46070ULL, 0x0000000130037824ULL, 0x000fe200078e0217ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x00006300070b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000122077824ULL, 0x000fe200078e0226ULL,
0xfffffff80d1c7812ULL, 0x000fe200078ee206ULL, 0x00000008241e7824ULL, 0x004fe200078e00ffULL,
0xfffffff830187812ULL, 0x000fe200078ee203ULL, 0x000000800c087825ULL, 0x008fc800078e00ffULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x00000070080c7812ULL, 0x000fc600078ef802ULL,
0x0000000122087824ULL, 0x000fe200078e0228ULL, 0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL,
0x0000000124037824ULL, 0x000fe200078e0217ULL, 0x0000007006067812ULL, 0x100fe200078ef802ULL,
0x0000000826207824ULL, 0x000fe200078e00ffULL, 0x00006300090d7a10ULL, 0x000fe200037fe4ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000620006067a10ULL, 0x000fe40007fde0ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x0000000128177824ULL, 0x000fe200078e0217ULL,
0x0000007008027812ULL, 0x000fe200078ef802ULL, 0x0000000828227824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20fULL, 0x000000100e0f7824ULL, 0x100fe200078e0223ULL,
0x0000630007077a10ULL, 0x000fe200037fe4ffULL, 0x000000101c197824ULL, 0x000fe200078e0223ULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x0000001018177824ULL, 0x100fe200078e0223ULL,
0x0000620002027a10ULL, 0x000fe20007fde0ffULL, 0x000000101e1d7824ULL, 0x100fe200078e0223ULL,
0x00000000100f7faeULL, 0x0003e2000e901c48ULL, 0x00000010201f7824ULL, 0x100fe200078e0223ULL,
0x0000630009037a10ULL, 0x000fe200037fe4ffULL, 0x0000001022237824ULL, 0x000fe200078e0223ULL,
0x0000000012177faeULL, 0x0003e8000e101c48ULL, 0x000000000a197faeULL, 0x0003e8000d901c48ULL,
0x000000000c1d7faeULL, 0x0003e8000d101c48ULL, 0x00000000061f7faeULL, 0x0003e8000c901c48ULL,
0x0000000002237faeULL, 0x0003e2000c101c48ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x0000000417077811ULL, 0x040fe400078fe8ffULL, 0x00000008170a7811ULL, 0x000fc400078fe8ffULL,
0x0000000c170b7811ULL, 0x000fe200078fe8ffULL, 0x0000000107037824ULL, 0x100fe200078e0217ULL,
0x0000001017107811ULL, 0x000fe200078fe8ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0x0000001417127811ULL, 0x040fe200078fe8ffULL, 0x000000010a067824ULL, 0x042fe200078e0217ULL,
0x00000018171c7811ULL, 0x000fe200078fe8ffULL, 0x000000080a0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL, 0x000000010b087824ULL, 0x100fe200078e0217ULL,
0x0000001c171e7811ULL, 0x000fe200078fe8ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL, 0x0000000110037824ULL, 0x140fe200078e0217ULL,
0x0000002017207811ULL, 0x040fe200078fe8ffULL, 0x00000008100e7824ULL, 0x000fe200078e00ffULL,
0x0000002417257811ULL, 0x000fe200078fe8ffULL, 0x0000000112067824ULL, 0x040fe200078e0217ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee208ULL, 0x0000000812137824ULL, 0x000fe200078e00ffULL,
0xfffffff80e117812ULL, 0x000fe200078ee203ULL, 0x000000011c087824ULL, 0x140fe200078e0217ULL,
0x0000002817277811ULL, 0x000fe200078fe8ffULL, 0x000000081c1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee206ULL, 0x000000011e097824ULL, 0x140fe200078e0217ULL,
0x0000002c17297811ULL, 0x000fe200078fe8ffULL, 0x000000081e187824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL, 0x0000000120037824ULL, 0x040fe200078e0217ULL,
0x00000030172b7811ULL, 0x000fe200078fe8ffULL, 0x00000008200e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8181f7812ULL, 0x000fe200078ee209ULL, 0x0000000125067824ULL, 0x000fe200078e0217ULL,
0x00000034172d7811ULL, 0x000fe200078fe8ffULL, 0x0000000825197824ULL, 0x000fe200078e00ffULL,
0xfffffff80e237812ULL, 0x000fe200078ee203ULL, 0x0000000127087824ULL, 0x100fe200078e0217ULL,
0x0000001717037211ULL, 0x000fe200078fe8ffULL, 0x0000000827217824ULL, 0x000fe200078e00ffULL,
0xfffffff819267812ULL, 0x000fe200078ee206ULL, 0x0000000129097824ULL, 0x000fe200078e0217ULL,
0x0000002217067211ULL, 0x000fe200078fe8ffULL, 0x00000008292a7824ULL, 0x000fe200078e00ffULL,
0xfffffff821287812ULL, 0x000fe200078ee208ULL, 0x00000001220e7824ULL, 0x040fe200078e020bULL,
0x0000000703087812ULL, 0x000fe200078ec0ffULL, 0x0000000122197824ULL, 0x000fe200078e0212ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL, 0x0000000122187824ULL, 0x000fe200078e0210ULL,
0x00000038172f7811ULL, 0x000fe200078fe8ffULL, 0x000000012b0b7824ULL, 0x100fe200078e0217ULL,
0x0000003c17317811ULL, 0x000fe200078fe8ffULL, 0x000000082b127824ULL, 0x000fe200078e00ffULL,
0x0ffffff808037812ULL, 0x000fe200078ef817ULL, 0x00000001222e7824ULL, 0x000fe200078e022dULL,
0x000020001a497811ULL, 0x000fe200078e70ffULL, 0x000000012d107824ULL, 0x000fe200078e0217ULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x0000000122097824ULL, 0x000fc400078e0207ULL,
0x000000082d2d7824ULL, 0x000fe400078e00ffULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000000122217824ULL, 0x000fe200078e021eULL, 0xfffffff82d1e7812ULL, 0x000fe200078ee210ULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x0000007006107812ULL, 0x000fc600078ef802ULL,
0x00000001220a7824ULL, 0x000fe200078e020aULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x0000000122247824ULL, 0x040fe400078e0220ULL, 0x00000001221c7824ULL, 0x040fe400078e021cULL,
0x0000000122257824ULL, 0x040fe400078e0225ULL, 0x0000000122277824ULL, 0x040fe400078e0227ULL,
0x0000000122297824ULL, 0x000fc400078e0229ULL, 0x00000001222c7824ULL, 0x040fe400078e022bULL,
0x0000000122307824ULL, 0x040fe400078e022fULL, 0x000000012f207824ULL, 0x000fe400078e0217ULL,
0x0000000122327824ULL, 0x000fe400078e0231ULL, 0x0000000131177824ULL, 0x040fe400078e0217ULL,
0x0000000831227824ULL, 0x000fc400078e00ffULL, 0x0000001012437824ULL, 0x000fe200078e0249ULL,
0x0000007008127812ULL, 0x100fe200078ef802ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe400078ee217ULL, 0x0000620012127a10ULL, 0x000fe20007f3e0ffULL,
0x0000001011337824ULL, 0x100fe200078e0249ULL, 0x0000630007117a10ULL, 0x000fe200007fe4ffULL,
0x000000082f2f7824ULL, 0x000fe400078e00ffULL, 0x0000001003177824ULL, 0x000fe200078e0249ULL,
0x000000700a037812ULL, 0x000fe200078ef802ULL, 0x000000800e067825ULL, 0x000fe200078e00ffULL,
0xfffffff82f207812ULL, 0x000fc400078ee220ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e2000b901c48ULL, 0x0000001013357824ULL, 0x000fe200078e0249ULL,
0x0000630009137a10ULL, 0x000fe20000ffe4ffULL, 0x0000008018087825ULL, 0x000fe200078e00ffULL,
0x0000620003187a10ULL, 0x000fc60007f1e0ffULL, 0x000000101d377824ULL, 0x100fe200078e0249ULL,
0x00000070061d7812ULL, 0x000fe200078ef802ULL, 0x000000100c2d7824ULL, 0x100fe400078e0249ULL,
0x000000100d2f7824ULL, 0x100fe400078e0249ULL, 0x00000080190c7825ULL, 0x000fe200078e00ffULL,
0x000063000b197a10ULL, 0x000fe200007fe4ffULL, 0x00000000122d7faeULL, 0x0003e4000b901c48ULL,
0x000000100f317824ULL, 0x000fc400078e0249ULL, 0x000000101e457824ULL, 0x100fe200078e0249ULL,
0x00000070081e7812ULL, 0x100fe200078ef802ULL, 0x000000801c0e7825ULL, 0x000fe200078e00ffULL,
0x000062001d1c7a10ULL, 0x000fe20007f1e0ffULL, 0x00000000182f7faeULL, 0x0003e2000b901c48ULL,
0x000062001e1e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000001020477824ULL, 0x100fe200078e0249ULL,
0x000000700c207812ULL, 0x000fe200078ef802ULL, 0x000000101f397824ULL, 0x000fe200078e0249ULL,
0x00006300071d7a10ULL, 0x000fe200007fe4ffULL, 0x0000008021067825ULL, 0x000fe200078e00ffULL,
0x0000620020207a10ULL, 0x000fc40007f1e0ffULL, 0x00006300091f7a10ULL, 0x000fe20000ffe4ffULL,
0x00000010233b7824ULL, 0x100fe200078e0249ULL, 0x000063000d217a10ULL, 0x000fe200007fe4ffULL,
0x00000010263d7824ULL, 0x100fe200078e0249ULL, 0x000000001c317faeULL, 0x0003e2000b901c48ULL,
0x00000010283f7824ULL, 0x100fe400078e0249ULL, 0x000000102a417824ULL, 0x100fe200078e0249ULL,
0x000000001e337faeULL, 0x0003e2000b901c48ULL, 0x0000001022497824ULL, 0x000fe200078e0249ULL,
0x000000700e227812ULL, 0x100fe200078ef802ULL, 0x0000008024087825ULL, 0x000fe200078e00ffULL,
0x0000007006247812ULL, 0x100fe200078ef802ULL, 0x0000000020357faeULL, 0x0003e2000b901c48ULL,
0x0000620022227a10ULL, 0x000fe20007f5e0ffULL, 0x00000080250a7825ULL, 0x000fe200078e00ffULL,
0x0000007008267812ULL, 0x000fc400078ef802ULL, 0x0000620024247a10ULL, 0x000fe20007f1e0ffULL,
0x00000080270c7825ULL, 0x000fe200078e00ffULL, 0x000000700a287812ULL, 0x100fe400078ef802ULL,
0x000063000f237a10ULL, 0x000fe200017fe4ffULL, 0x00000080290e7825ULL, 0x000fe200078e00ffULL,
0x000000700c2a7812ULL, 0x000fe400078ef802ULL, 0x0000620026267a10ULL, 0x000fe20007f3e0ffULL,
0x0000000022377faeULL, 0x0003e2000b901c48ULL, 0x0000630007257a10ULL, 0x000fe200007fe4ffULL,
0x000000802c067825ULL, 0x000fe200078e00ffULL, 0x0000620028287a10ULL, 0x000fc40007f1e0ffULL,
0x000062002a2a7a10ULL, 0x000fe20007f5e0ffULL, 0x0000000024397faeULL, 0x0003e2000b901c48ULL,
0x0000630009277a10ULL, 0x000fe20000ffe4ffULL, 0x000000802e087825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x100fe400078ef802ULL, 0x000063000b297a10ULL, 0x000fe200007fe4ffULL,
0x00000080300a7825ULL, 0x000fe200078e00ffULL, 0x000063000d2b7a10ULL, 0x000fe200017fe4ffULL,
0x00000000263b7faeULL, 0x0003e2000b901c48ULL, 0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000080320c7825ULL, 0x000fe200078e00ffULL, 0x0000007006037812ULL, 0x100fe200078ef802ULL,
0x00000000283d7faeULL, 0x0003e2000b901c48ULL, 0x0000007008067812ULL, 0x000fc400078ef802ULL,
0x000000700a087812ULL, 0x100fe200078ef802ULL, 0x000000002a3f7faeULL, 0x0003e2000b901c48ULL,
0x000063000f0f7a10ULL, 0x000fe400007fe4ffULL, 0x000000700c0a7812ULL, 0x000fe400078ef802ULL,
0x0000620003027a10ULL, 0x000fe20007f1e0ffULL, 0x000000000e417faeULL, 0x0003e2000b901c48ULL,
0x0000620006067a10ULL, 0x000fe40007f3e0ffULL, 0x0000620008087a10ULL, 0x000fc40007f5e0ffULL,
0x000062000a0a7a10ULL, 0x000fe40007f7e0ffULL, 0x0000630007037a10ULL, 0x000fe400007fe4ffULL,
0x0000630009077a10ULL, 0x000fe40000ffe4ffULL, 0x000063000b097a10ULL, 0x000fe200017fe4ffULL,
0x0000000002437faeULL, 0x0003e2000b901c48ULL, 0x000063000d0b7a10ULL, 0x000fc60001ffe4ffULL,
0x0000000006457faeULL, 0x0003e8000b901c48ULL, 0x0000000008477faeULL, 0x0003e8000b901c48ULL,
0x000000000a497faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x002fc40000015200ULL, 0x01a60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x00afc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000602097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x000000201a027824ULL, 0x002fca00078e0203ULL, 0x00000004ff037819ULL, 0x000fe40000011602ULL,
0x0000000102047810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe03057812ULL, 0x000fe400078ec0ffULL,
0x0000001f02037812ULL, 0x000fc600078ec0ffULL, 0x0000000105077824ULL, 0x040fe400078e0204ULL,
0x0000000102067824ULL, 0x000fe200078e0205ULL, 0x0000000805057810ULL, 0x000fe20007ffe0ffULL,
0x0000001003087824ULL, 0x000fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x0000001003097824ULL, 0x000fe200078e00ffULL, 0x0000000f06067812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x000001f008077812ULL, 0x000fe200078ee207ULL,
0x0000000102027824ULL, 0x000fe200078e0205ULL, 0x000001f009067812ULL, 0x000fe200078ee206ULL,
0x0000001003057824ULL, 0x040fe200078e00ffULL, 0x0000000f04047812ULL, 0x000fe200078ec0ffULL,
0x0000000007087984ULL, 0x000e62000000cc00ULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x0000000f02027812ULL, 0x000fc400078ec0ffULL, 0x00000000060c7984ULL, 0x000ee4000000cc00ULL,
0x000001f003047812ULL, 0x000fe400078ee204ULL, 0x000001f005027812ULL, 0x000fe200078ee202ULL,
0x000000ffff127224ULL, 0x002fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff107224ULL, 0x008fe400078e000cULL, 0x000000ffff117224ULL, 0x000fc400078e000eULL,
0x000000ffff1e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1f7224ULL, 0x000fe200078e000bULL,
0x0000001006007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1c7224ULL, 0x000fe400078e000dULL,
0x000000ffff1d7224ULL, 0x000fca00078e000fULL, 0x0000001c07007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000020c7984ULL, 0x000ee2000000cc00ULL,
0x000000ffff237224ULL, 0x002fe400078e000aULL, 0x000000ffff227224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff207224ULL, 0x008fe400078e000cULL,
0x000000ffff217224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000002002007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a60000ff067f8cULL, 0x000ee2000c80043fULL, 0x000000ffff087224ULL, 0x002fc600078e00ffULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01a60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x00afc40007804807ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0x0000001fff027424ULL, 0x000fe200078e00ffULL,
0x8000580016637a10ULL, 0x000fe20007ffe0ffULL, 0x00000001ff617424ULL, 0x000fe200078e00ffULL,
0x000001001b1b7810ULL, 0x000fe20007ffe0ffULL, 0x00005800ff627624ULL, 0x000fe200078e00ffULL,
0x0000580002027a10ULL, 0x000fe20007ffe0ffULL, 0x3db504f35c5c7820ULL, 0x010fe20000410000ULL,
0x0001a6881a5d7811ULL, 0x044fe200078e18ffULL, 0x000000ffff607224ULL, 0x000fe200078e00ffULL,
0x00000004ff027819ULL, 0x000fe20000011602ULL, 0x000000ffff5f7224ULL, 0x000fe200078e00ffULL,
0x0001a6081a5e7811ULL, 0x000fc400078e28ffULL, 0x0000580061617a10ULL, 0x000fe40007ffe1ffULL,
0x0000000962627810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x0ffffffe02647812ULL, 0x000fc400078ec0ffULL, 0x0000000260027810ULL, 0x040fe20007ffe0ffULL,
0x0000010060657824ULL, 0x000fe200078e021bULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000015f677812ULL, 0x000fe400078e0cffULL, 0x000000150200720cULL, 0x000fe20003f06070ULL,
0x0000660014027a24ULL, 0x000fd800078e0265ULL, 0x00000ca000008947ULL, 0x00cfea0003800000ULL,
0x00000003ff227819ULL, 0x002fe20000011617ULL, 0x0000001017057824ULL, 0x000fe200078e00ffULL,
0x0000006516047217ULL, 0x000fe20007800000ULL, 0x000000021a207824ULL, 0x000fe200078e0267ULL,
0x0000000422067810ULL, 0x040fe40007ffe0ffULL, 0x0000000822087810ULL, 0x000fe40007ffe0ffULL,
0x0000007005277812ULL, 0x000fe200078ec0ffULL, 0x0000000106037824ULL, 0x100fe200078e0217ULL,
0x00000010220c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008060a7824ULL, 0x000fe200078e00ffULL,
0x00000014221e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108077824ULL, 0x000fe200078e0217ULL,
0x0000001822247810ULL, 0x000fe20007ffe0ffULL, 0x000000080c297824ULL, 0x000fe200078e00ffULL,
0xfffffff80a1f7812ULL, 0x000fe200078ee203ULL, 0x0000000104037824ULL, 0x000fe200078e0a65ULL,
0x0000001c22287810ULL, 0x040fe20007ffe0ffULL, 0x0000000122047824ULL, 0x140fe200078e0202ULL,
0x00000020222a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008080a7824ULL, 0x000fe200078e00ffULL,
0x000000030600720cULL, 0x040fe20003fa6070ULL, 0x0000000106067824ULL, 0x000fe200078e0202ULL,
0x00000024222c7810ULL, 0x000fe20007ffe0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0xfffffff80a237812ULL, 0x000fc400078ee207ULL, 0x0000000c220a7810ULL, 0x000fe20007ffe0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x00000027040e7212ULL, 0x000fe400078efcffULL,
0x000000030a00720cULL, 0x000fe20003f46070ULL, 0x000000010c047824ULL, 0x100fe200078e0217ULL,
0x0000002706107212ULL, 0x000fe200078efcffULL, 0x000000010a097824ULL, 0x000fe200078e0217ULL,
0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000080a127824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee204ULL, 0x0000000108047824ULL, 0x100fe200078e0202ULL,
0x0000620010107a10ULL, 0x000fe20007f3e0ffULL, 0x000000010a067824ULL, 0x000fe200078e0202ULL,
0x00006300050f7a10ULL, 0x000fe200007fe4ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000630007117a10ULL, 0x000fc40000ffe4ffULL, 0x000000030800720cULL, 0x000fe20003f26070ULL,
0x000000010c087824ULL, 0x100fe200078e0202ULL, 0xfffffff812257812ULL, 0x000fe200078ee209ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000002704127212ULL, 0x000fe400078efcffULL,
0x000000030c00720cULL, 0x000fe20003f06070ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe40007f7e0ffULL, 0x0000002706187212ULL, 0x080fe200078efcffULL,
0x000000011e0a7824ULL, 0x100fe200078e0202ULL, 0x0000002708087212ULL, 0x000fe200078efcffULL,
0x00000001240c7824ULL, 0x100fe200078e0202ULL, 0x0000630005137a10ULL, 0x000fe20001ffe4ffULL,
0x0000000128047824ULL, 0x000fe200078e0202ULL, 0x0000620018187a10ULL, 0x000fe20007f9e0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000620008087a10ULL, 0x000fc40007f7e0ffULL,
0x0000630007197a10ULL, 0x000fe200027fe4ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000270a0a7212ULL, 0x080fe400078efcffULL, 0x0000630009097a10ULL, 0x000fe20001ffe4ffULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x000000270c0c7212ULL, 0x080fe400078efcffULL,
0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000000122067824ULL, 0x100fe200078e0217ULL,
0x00000027041c7212ULL, 0x000fe200078efcffULL, 0x000000012a047824ULL, 0x000fe200078e0202ULL,
0x000062000c0c7a10ULL, 0x000fe20007f9e0ffULL, 0x000000011e077824ULL, 0x100fe200078e0217ULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000124267824ULL, 0x040fe200078e0217ULL,
0x000063000b0b7a10ULL, 0x000fe20001ffe4ffULL, 0x00000008242d7824ULL, 0x000fe200078e00ffULL,
0x000063000d0d7a10ULL, 0x000fc400027fe4ffULL, 0x0000000706067812ULL, 0x000fe400078ec0ffULL,
0x000000032200720cULL, 0x080fe40003f86070ULL, 0x000000031e00720cULL, 0x040fe20003f66070ULL,
0x000000081e1e7824ULL, 0x000fe200078e00ffULL, 0x00006300051d7a10ULL, 0x000fe200037fe4ffULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000200020207811ULL, 0x000fe400078e68ffULL,
0x0ffffff806217812ULL, 0x000fe200078ef817ULL, 0x000000012c067824ULL, 0x000fe200078e0202ULL,
0xfffffff81e2b7812ULL, 0x000fe200078ee207ULL, 0x0000001023237824ULL, 0x100fe200078e0220ULL,
0x00000028222e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0220ULL,
0x00000027041e7212ULL, 0x000fe200078efcffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fc400078ee226ULL, 0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x000000012e047824ULL, 0x000fe200078e0202ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e217faeULL, 0x0003e2000e101c48ULL, 0x0000002706067212ULL, 0x000fe400078efcffULL,
0x000000032400720cULL, 0x000fe40003f86070ULL, 0x0000002c22247810ULL, 0x040fe40007ffe0ffULL,
0x0000003822267810ULL, 0x000fe20007ffe0ffULL, 0x000000101f217824ULL, 0x002fe200078e0220ULL,
0x00006300051f7a10ULL, 0x000fe200037fe4ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000620006067a10ULL, 0x000fc40007fde0ffULL, 0x0000000010217faeULL, 0x0003e2000e901c48ULL,
0x000000032800720cULL, 0x040fe20003fa6070ULL, 0x00000001280f7824ULL, 0x000fe200078e0217ULL,
0x00000027040e7212ULL, 0x000fe200078efcffULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000630007077a10ULL, 0x000fe200037fe4ffULL, 0x0000000124047824ULL, 0x000fe200078e0202ULL,
0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x0000000012237faeULL, 0x0005e2000c901c48ULL,
0xfffffff8282f7812ULL, 0x000fe400078ee20fULL, 0x00006300050f7a10ULL, 0x000fe200037fe4ffULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x000000032a00720cULL, 0x000fc60003f26070ULL,
0x000000012a117824ULL, 0x102fe200078e0217ULL, 0x0000002704107212ULL, 0x000fe200078efcffULL,
0x000000082a2a7824ULL, 0x000fe400078e00ffULL, 0x0000001025217824ULL, 0x100fe200078e0220ULL,
0x0000620010107a10ULL, 0x000fe20007fde0ffULL, 0x000000012c047824ULL, 0x000fe200078e0217ULL,
0x0000003022127810ULL, 0x004fe20007ffe0ffULL, 0x000000082c257824ULL, 0x000fe200078e00ffULL,
0xfffffff82a237812ULL, 0x000fe200078ee211ULL, 0x0000001029137824ULL, 0x100fe200078e0220ULL,
0x0000630005117a10ULL, 0x000fe200037fe4ffULL, 0x000000102b057824ULL, 0x000fe200078e0220ULL,
0xfffffff825257812ULL, 0x000fe200078ee204ULL, 0x0000000112047824ULL, 0x000fe200078e0202ULL,
0x0000000018217faeULL, 0x0003e2000d101c48ULL, 0x000000032c00720cULL, 0x000fe20003f46070ULL,
0x0000001023237824ULL, 0x000fc400078e0220ULL, 0x0000000008137faeULL, 0x0005e2000c101c48ULL,
0x0000001025257824ULL, 0x000fc600078e0220ULL, 0x000000000a057faeULL, 0x0007e2000d901c48ULL,
0x000000031200720cULL, 0x080fe20003f66070ULL, 0x000000102d197824ULL, 0x102fe200078e0220ULL,
0x0000003422187810ULL, 0x040fe20007ffe0ffULL, 0x000000102f217824ULL, 0x000fe200078e0220ULL,
0x0000003c22227810ULL, 0x000fe40007ffe0ffULL, 0x000000000c197faeULL, 0x0003e2000e101c48ULL,
0x0000000118097824ULL, 0x004fe200078e0202ULL, 0x000000032400720cULL, 0x080fe20003f86070ULL,
0x0000008004047825ULL, 0x008fe200078e00ffULL, 0x000000001c217faeULL, 0x0005e2000e901c48ULL,
0x000000032e00720cULL, 0x000fc40003fa6070ULL, 0x000000032200720cULL, 0x000fe20003f06070ULL,
0x000000001e237faeULL, 0x0007e2000c901c48ULL, 0x0000002704087212ULL, 0x000fe200078efcffULL,
0x0000000126047824ULL, 0x040fe200078e0202ULL, 0x000000032600720cULL, 0x080fe20003f26070ULL,
0x0000000006257faeULL, 0x0009e2000d101c48ULL, 0x0000620008087a10ULL, 0x000fe20007fde0ffULL,
0x000000012e0a7824ULL, 0x100fe200078e0217ULL, 0x000000031800720cULL, 0x000fe20003f46070ULL,
0x0000000124037824ULL, 0x040fe400078e0217ULL, 0x0000000824247824ULL, 0x000fc400078e00ffULL,
0x000000082e0b7824ULL, 0x000fe400078e00ffULL, 0x0000000122027824ULL, 0x000fe200078e0202ULL,
0xfffffff8240d7812ULL, 0x002fe200078ee203ULL, 0x0000008009067825ULL, 0x010fe200078e00ffULL,
0x0000630005097a10ULL, 0x000fe400037fe4ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee20aULL,
0x0000000112057824ULL, 0x000fe200078e0217ULL, 0x0000002706067212ULL, 0x000fe200078efcffULL,
0x0000000812127824ULL, 0x000fc400078e00ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x0000620006067a10ULL, 0x000fe40007fde0ffULL, 0xfffffff812137812ULL, 0x000fe200078ee205ULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000630007077a10ULL, 0x000fe400037fe4ffULL,
0x0000002702027212ULL, 0x080fe200078efcffULL, 0x00000001180a7824ULL, 0x000fe200078e0217ULL,
0x0000002704047212ULL, 0x000fe200078efcffULL, 0x0000000818197824ULL, 0x000fc400078e00ffULL,
0x00000001260c7824ULL, 0x100fe200078e0217ULL, 0x0000620004047a10ULL, 0x000fe20007fde0ffULL,
0x00000008261d7824ULL, 0x004fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee20aULL,
0x0000000122127824ULL, 0x040fe200078e0217ULL, 0x0000630005057a10ULL, 0x000fe200037fe4ffULL,
0x00000008221f7824ULL, 0x008fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x000000100b0b7824ULL, 0x100fe200078e0220ULL, 0x0000620002027a10ULL, 0x000fe20007fde0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0220ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL,
0x0000001013137824ULL, 0x100fe200078e0220ULL, 0x0000630003037a10ULL, 0x000fe200037fe4ffULL,
0x0000001019197824ULL, 0x100fe200078e0220ULL, 0x000000000e0b7faeULL, 0x0003e2000e901c48ULL,
0x000000101d1d7824ULL, 0x000fc400078e0220ULL, 0x000000101f1f7824ULL, 0x000fe200078e0220ULL,
0x00000000100d7faeULL, 0x0003e8000e101c48ULL, 0x0000000008137faeULL, 0x0003e8000d901c48ULL,
0x0000000006197faeULL, 0x0003e8000d101c48ULL, 0x00000000041d7faeULL, 0x0003e8000c901c48ULL,
0x00000000021f7faeULL, 0x0003e2000c101c48ULL, 0x00000b6000007947ULL, 0x000fea0003800000ULL,
0x0000000417047811ULL, 0x042fe400078fe8ffULL, 0x0000000817067811ULL, 0x000fc400078fe8ffULL,
0x00000018170b7811ULL, 0x040fe200078fe8ffULL, 0x0000000104037824ULL, 0x140fe200078e0217ULL,
0x0000000c17087811ULL, 0x040fe200078fe8ffULL, 0x0000000804107824ULL, 0x000fe200078e00ffULL,
0x00000014170a7811ULL, 0x040fe200078fe8ffULL, 0x0000000106057824ULL, 0x040fe200078e0217ULL,
0x0000001017097811ULL, 0x000fe200078fe8ffULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee203ULL, 0x000000010b0c7824ULL, 0x000fe200078e0217ULL,
0x0000002817227811ULL, 0x000fe200078fe8ffULL, 0x000000080b0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x0000000108037824ULL, 0x140fe200078e0217ULL,
0x0000001c171d7811ULL, 0x040fe200078fe8ffULL, 0x0000000808187824ULL, 0x000fe200078e00ffULL,
0x0000002417217811ULL, 0x040fe200078fe8ffULL, 0x000000010a077824ULL, 0x140fe200078e0217ULL,
0x0000002017207811ULL, 0x000fe200078fe8ffULL, 0x000000080a1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d247812ULL, 0x000fe200078ee20cULL, 0x0000000109057824ULL, 0x040fe200078e0217ULL,
0xfffffff818187812ULL, 0x000fe200078ee203ULL, 0x00000008091c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL, 0x00000001220c7824ULL, 0x040fe200078e0217ULL,
0x00000038172c7811ULL, 0x000fe200078fe8ffULL, 0x00000008220d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL, 0x000000011d037824ULL, 0x100fe200078e0217ULL,
0x0000002c17237811ULL, 0x000fe200078fe8ffULL, 0x000000081d267824ULL, 0x000fe200078e00ffULL,
0x00000034172a7811ULL, 0x000fe200078fe8ffULL, 0x0000000121077824ULL, 0x100fe200078e0217ULL,
0x0000003017287811ULL, 0x000fe200078fe8ffULL, 0x0000000821327824ULL, 0x000fe200078e00ffULL,
0xfffffff80d347812ULL, 0x000fe200078ee20cULL, 0x0000000120057824ULL, 0x000fe200078e0217ULL,
0xfffffff826267812ULL, 0x000fe200078ee203ULL, 0x0000000820307824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee207ULL, 0x000000012c0c7824ULL, 0x000fc400078e0217ULL,
0x000000082c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee205ULL,
0x0000000123037824ULL, 0x140fe400078e0217ULL, 0x0000000823367824ULL, 0x000fe200078e00ffULL,
0xfffffff80d3c7812ULL, 0x000fe200078ee20cULL, 0x000000012a077824ULL, 0x040fe200078e0217ULL,
0x0000003c170d7811ULL, 0x040fe200078fe8ffULL, 0x000000082a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee203ULL, 0x0000000128057824ULL, 0x040fe200078e0217ULL,
0x0000000217037211ULL, 0x040fe200078fe8ffULL, 0x0000000828387824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee207ULL, 0x000000021a0c7824ULL, 0x000fe200078e0267ULL,
0x0000001717077211ULL, 0x040fe200078fe8ffULL, 0x0000000104047824ULL, 0x100fe200078e0202ULL,
0xfffffff838387812ULL, 0x000fe200078ee205ULL, 0x0000001017057824ULL, 0x000fe200078e00ffULL,
0x00000007070e7812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x100fe200078e0202ULL,
0x000020000c477811ULL, 0x000fe200078e68ffULL, 0x0000000108087824ULL, 0x100fe200078e0202ULL,
0x0000007005497812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x100fe200078e0202ULL,
0x0ffffff80e0e7812ULL, 0x000fe200078ef817ULL, 0x000000010a0a7824ULL, 0x000fc400078e0202ULL,
0x000000010b0b7824ULL, 0x100fe400078e0202ULL, 0x000000011d1d7824ULL, 0x100fe400078e0202ULL,
0x0000000120207824ULL, 0x100fe400078e0202ULL, 0x0000000121217824ULL, 0x100fe400078e0202ULL,
0x0000000122227824ULL, 0x100fe400078e0202ULL, 0x0000000123237824ULL, 0x000fc400078e0202ULL,
0x0000000128287824ULL, 0x100fe400078e0202ULL, 0x000000012a2a7824ULL, 0x100fe400078e0202ULL,
0x000000012c2c7824ULL, 0x100fe400078e0202ULL, 0x000000010d2e7824ULL, 0x000fe400078e0202ULL,
0x0000008003027825ULL, 0x000fc800078e00ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x00000049020c7212ULL, 0x000fc600078efcffULL, 0x000000100e297824ULL, 0x000fe200078e0247ULL,
0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000049040e7212ULL, 0x000fc600078efcffULL, 0x000000010d0f7824ULL, 0x040fe200078e0217ULL,
0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x000000080d3e7824ULL, 0x000fe200078e00ffULL,
0x00006300030d7a10ULL, 0x000fe200007fe4ffULL, 0x00000010102b7824ULL, 0x000fe200078e0247ULL,
0x0000004906107212ULL, 0x080fe200078efcffULL, 0x0000008008027825ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c297faeULL, 0x0003e2000b901c48ULL, 0x00006300050f7a10ULL, 0x000fe20000ffe4ffULL,
0x00000010122d7824ULL, 0x000fe200078e0247ULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x0000008009047825ULL, 0x000fe200078e00ffULL, 0x0000004902127212ULL, 0x000fe200078efcffULL,
0x000000000e2b7faeULL, 0x0003e2000b901c48ULL, 0x0000630007117a10ULL, 0x000fe200007fe4ffULL,
0x000000800a087825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc60007f1e0ffULL,
0x00000010182f7824ULL, 0x100fe200078e0247ULL, 0x0000004904187212ULL, 0x080fe200078efcffULL,
0x000000101c317824ULL, 0x100fe200078e0247ULL, 0x00000049081c7212ULL, 0x080fe200078efcffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000620018187a10ULL, 0x000fe20007f3e0ffULL,
0x00000000102d7faeULL, 0x0003e2000b901c48ULL, 0x0000630003137a10ULL, 0x000fe200007fe4ffULL,
0x000000801d027825ULL, 0x000fe200078e00ffULL, 0x000062001c1c7a10ULL, 0x000fe40007f1e0ffULL,
0x0000630005197a10ULL, 0x000fe20000ffe4ffULL, 0x000000101e337824ULL, 0x100fe200078e0247ULL,
0x000000490a1e7212ULL, 0x080fe200078efcffULL, 0x0000008020047825ULL, 0x000fe200078e00ffULL,
0x00006300091d7a10ULL, 0x000fe200007fe4ffULL, 0x00000000122f7faeULL, 0x0003e2000b901c48ULL,
0x0000004902207212ULL, 0x080fe200078efcffULL, 0x0000008021067825ULL, 0x000fe200078e00ffULL,
0x000062001e1e7a10ULL, 0x000fe20007f5e0ffULL, 0x0000000018317faeULL, 0x0003e2000b901c48ULL,
0x0000620020207a10ULL, 0x000fe20007f1e0ffULL, 0x0000008022087825ULL, 0x000fe200078e00ffULL,
0x0000004904227212ULL, 0x080fe200078efcffULL, 0x000000001c337faeULL, 0x0003e2000b901c48ULL,
0x000063000b1f7a10ULL, 0x000fe200017fe4ffULL, 0x0000001024357824ULL, 0x100fe200078e0247ULL,
0x0000004906247212ULL, 0x080fe200078efcffULL, 0x0000001026377824ULL, 0x000fe200078e0247ULL,
0x0000004908267212ULL, 0x000fe200078efcffULL, 0x00000080230a7825ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fe20007f3e0ffULL, 0x000000001e357faeULL, 0x0003e2000b901c48ULL,
0x0000630003217a10ULL, 0x000fe200007fe4ffULL, 0x0000008028027825ULL, 0x000fe200078e00ffULL,
0x0000620024247a10ULL, 0x000fc40007f1e0ffULL, 0x0000620026267a10ULL, 0x000fe20007f5e0ffULL,
0x0000001030397824ULL, 0x000fe200078e0247ULL, 0x0000630005237a10ULL, 0x000fe20000ffe4ffULL,
0x000000802a047825ULL, 0x000fe200078e00ffULL, 0x000000490a0a7212ULL, 0x080fe200078efcffULL,
0x0000000020377faeULL, 0x0003e2000b901c48ULL, 0x0000630007257a10ULL, 0x000fe200007fe4ffULL,
0x000000802c067825ULL, 0x000fe200078e00ffULL, 0x0000630009277a10ULL, 0x000fe200017fe4ffULL,
0x0000000022397faeULL, 0x0003e2000b901c48ULL, 0x000062000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000802e087825ULL, 0x000fe200078e00ffULL, 0x0000004902027212ULL, 0x000fc400078efcffULL,
0x0000004904047212ULL, 0x080fe200078efcffULL, 0x00000010323b7824ULL, 0x100fe200078e0247ULL,
0x0000004906067212ULL, 0x080fe200078efcffULL, 0x00000010343d7824ULL, 0x100fe200078e0247ULL,
0x000063000b0b7a10ULL, 0x000fe200007fe4ffULL, 0x00000010363f7824ULL, 0x100fe200078e0247ULL,
0x0000004908087212ULL, 0x000fe200078efcffULL, 0x0000001038417824ULL, 0x100fe200078e0247ULL,
0x0000620002027a10ULL, 0x000fe20007f1e0ffULL, 0x000000103a437824ULL, 0x100fe200078e0247ULL,
0x0000620004047a10ULL, 0x000fe20007f3e0ffULL, 0x000000103c457824ULL, 0x100fe200078e0247ULL,
0x0000620006067a10ULL, 0x000fe20007f5e0ffULL, 0x00000000243b7faeULL, 0x0003e2000b901c48ULL,
0x0000620008087a10ULL, 0x000fe20007f7e0ffULL, 0x000000103e477824ULL, 0x000fe200078e0247ULL,
0x0000630003037a10ULL, 0x000fe200007fe4ffULL, 0x00000000263d7faeULL, 0x0003e2000b901c48ULL,
0x0000630005057a10ULL, 0x000fc40000ffe4ffULL, 0x0000630007077a10ULL, 0x000fe200017fe4ffULL,
0x000000000a3f7faeULL, 0x0003e2000b901c48ULL, 0x0000630009097a10ULL, 0x000fc60001ffe4ffULL,
0x0000000002417faeULL, 0x0003e8000b901c48ULL, 0x0000000004437faeULL, 0x0003e8000b901c48ULL,
0x0000000006457faeULL, 0x0003e8000b901c48ULL, 0x0000000008477faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff667224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x002fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff817027812ULL, 0x000fe200078ec0ffULL,
0x000000021a757824ULL, 0x020fe200078e025fULL, 0x0000000166767810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000702037812ULL, 0x000fc400078ef817ULL,
0x0000200075757811ULL, 0x000fe400078e68ffULL, 0x0000002017547810ULL, 0x000fe20007ffe0ffULL,
0x0000000103027824ULL, 0x040fe400078e0266ULL, 0x0000000803197824ULL, 0x000fe200078e00ffULL,
0xfffffff854547812ULL, 0x000fc800078ec0ffULL, 0xfffffff819027812ULL, 0x000fe400078ee202ULL,
0x0000000754777812ULL, 0x000fc600078ef817ULL, 0x00000010022c7824ULL, 0x000fe400078e0275ULL,
0x0000000803027824ULL, 0x040fe400078e00ffULL, 0x0000000103037824ULL, 0x000fe400078e0276ULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0x0000000177547824ULL, 0x040fe400078e0266ULL,
0xfffffff802027812ULL, 0x000fe200078ee203ULL, 0x0000000877597824ULL, 0x000fc400078e00ffULL,
0x0000000177767824ULL, 0x000fe400078e0276ULL, 0x0000001002307824ULL, 0x000fe200078e0275ULL,
0xfffffff859547812ULL, 0x000fe200078ee254ULL, 0x0000000877777824ULL, 0x000fc800078e00ffULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x0000001054547824ULL, 0x000fe200078e0275ULL,
0xfffffff877767812ULL, 0x000fc800078ee276ULL, 0x000000005458783bULL, 0x000ee20000000200ULL,
0x00000018ff567819ULL, 0x002fe2000001142dULL, 0x0000002c00f77306ULL, 0x000fe20000009400ULL,
0x00000018ff557819ULL, 0x000fe4000001142cULL, 0x00000018ff577819ULL, 0x000fca000001142eULL,
0x0000005600bf7306ULL, 0x000fe20000209400ULL, 0x00000018ff737819ULL, 0x004fe20000011431ULL,
0x0001000033797824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fca0000011433ULL,
0x0000005600ea7306ULL, 0x000ff00000205400ULL, 0x0000005600037306ULL, 0x0003f0000020d400ULL,
0x0000002c00967306ULL, 0x000ea20000005400ULL, 0x00000018ff567819ULL, 0x002fce0000011430ULL,
0x0000005600ab7306ULL, 0x000ff00000209400ULL, 0x0000005600ac7306ULL, 0x000fe20000205400ULL,
0x00000096f700720bULL, 0x004fce0003f1d000ULL, 0x00000056006b7306ULL, 0x0003f0000020d400ULL,
0x0000002c00187306ULL, 0x000522000000d400ULL, 0x000100002c567824ULL, 0x002fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000005700c37306ULL, 0x000fe20000209400ULL,
0x000001002c2c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000005700ec7306ULL, 0x000e620000205400ULL, 0x0000000118180812ULL, 0x010fce00078efcffULL,
0x0000005700ad7306ULL, 0x000530000020d400ULL, 0x0000002c00f07306ULL, 0x000fe20000209400ULL,
0x00000018ff577819ULL, 0x004fe40000011432ULL, 0x000000ecc300720bULL, 0x002fca0003f1d000ULL,
0x00000057006d7306ULL, 0x000ff00000209400ULL, 0x00000057006e7306ULL, 0x000fe20000205400ULL,
0x00000001adad0812ULL, 0x010fce00078efcffULL, 0x00000057006f7306ULL, 0x0003f0000020d400ULL,
0x0000002c00f37306ULL, 0x000ea20000205400ULL, 0x000100002d577824ULL, 0x002fce00078e00ffULL,
0x0000002c009e7306ULL, 0x000330000020d400ULL, 0x0000002d00f47306ULL, 0x000fe20000009400ULL,
0x000100002f2c7824ULL, 0x002fe200078e00ffULL, 0x000000f3f000720bULL, 0x004fc80003f7d000ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002d00977306ULL, 0x000e6e0000005400ULL,
0x000000019e9e3812ULL, 0x010fe200078efcffULL, 0x0000002d00027306ULL, 0x000530000000d400ULL,
0x00000073007d7306ULL, 0x000fe20000209400ULL, 0x000001002d2d7824ULL, 0x004fe200078e00ffULL,
0x00000097f400720bULL, 0x002fc80003f5d000ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000073007e7306ULL, 0x000fee0000205400ULL, 0x0000000102022812ULL, 0x010fe200078efcffULL,
0x00000073006c7306ULL, 0x0003f0000020d400ULL, 0x00000055009a7306ULL, 0x000fe20000209400ULL,
0x00000018ff737819ULL, 0x002fce0000011457ULL, 0x00000055009b7306ULL, 0x000e700000205400ULL,
0x0000005500197306ULL, 0x000530000020d400ULL, 0x0000007400707306ULL, 0x000fe20000209400ULL,
0x00000018ff557819ULL, 0x004fc4000001142fULL, 0x0000009b9a00720bULL, 0x002fca0003f3d000ULL,
0x0000007400717306ULL, 0x000ff00000205400ULL, 0x0000007400727306ULL, 0x0003e2000020d400ULL,
0x0000000119191812ULL, 0x010fc800078efcffULL, 0x0000009e1919723eULL, 0x000fc600000010ffULL,
0x0000005600997306ULL, 0x000fe20000209400ULL, 0x000100002e747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000005600f27306ULL, 0x000e700000205400ULL,
0x0000005600eb7306ULL, 0x000eb0000020d400ULL, 0x0000002c00be7306ULL, 0x000fe20000209400ULL,
0x000000f29900720bULL, 0x002fce0003fbd000ULL, 0x0000002c00ed7306ULL, 0x000fec0000205400ULL,
0x00000001ebeb5812ULL, 0x004fe400078efcffULL, 0x0000002c00d17306ULL, 0x0007e2000020d400ULL,
0x000000eabf00720bULL, 0x000fe40003fbd000ULL, 0x00000018eb18723eULL, 0x000fca00000010ffULL,
0x0000002e00987306ULL, 0x000fe20000009400ULL, 0x00000018ff2c7819ULL, 0x008fca000001145aULL,
0x0000000103035812ULL, 0x000fe400078efcffULL, 0x0000002e00f57306ULL, 0x000e700000005400ULL,
0x0000002e00d67306ULL, 0x0004f0000000d400ULL, 0x0000002f00cc7306ULL, 0x000fe20000009400ULL,
0x000001002e2e7824ULL, 0x004fe200078e00ffULL, 0x000000f59800720bULL, 0x002fc80003f9d000ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002f00f17306ULL, 0x000e6e0000005400ULL,
0x00000001d6d64812ULL, 0x008fe200078efcffULL, 0x0000002f00ca7306ULL, 0x0004f0000000d400ULL,
0x0000002d00567306ULL, 0x000fe20000209400ULL, 0x000001002f2f7824ULL, 0x004fe200078e00ffULL,
0x000000f1cc00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000002d00577306ULL, 0x000e6e0000205400ULL, 0x00000001caca6812ULL, 0x008fe200078efcffULL,
0x0000002d00e47306ULL, 0x0004f0000020d400ULL, 0x0000002c00b77306ULL, 0x000fe20000209400ULL,
0x00000018ff2d7819ULL, 0x004fc40000011458ULL, 0x000000575600720bULL, 0x002fca0003f5d000ULL,
0x0000002c00c67306ULL, 0x000ff00000205400ULL, 0x0000002c00ba7306ULL, 0x0003e2000020d400ULL,
0x00000001e4e42812ULL, 0x008fc800078efcffULL, 0x000000e40303723eULL, 0x000fc600000010ffULL,
0x0000002d00df7306ULL, 0x000fe20000209400ULL, 0x00010000312c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe2000001142cULL, 0x00000010762c7824ULL, 0x000fe200078e0275ULL,
0x0000002d00de7306ULL, 0x000e700000205400ULL, 0x0000002d00c27306ULL, 0x0004f0000020d400ULL,
0x0000002e00ce7306ULL, 0x000fe20000209400ULL, 0x00010000302d7824ULL, 0x004fe200078e00ffULL,
0x000000dedf00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002e00ef7306ULL, 0x000e6e0000205400ULL, 0x00000001c2c26812ULL, 0x008fe200078efcffULL,
0x0000002e00d87306ULL, 0x0004f0000020d400ULL, 0x0000002f00e87306ULL, 0x000fe20000209400ULL,
0x00000018ff2e7819ULL, 0x004fc40000011459ULL, 0x000000efce00720bULL, 0x002fca0003fbd000ULL,
0x0000002f00e97306ULL, 0x000e700000205400ULL, 0x0000002f00d07306ULL, 0x000522000020d400ULL,
0x00000001d8d85812ULL, 0x008fce00078efcffULL, 0x0000002e00d37306ULL, 0x000fe20000209400ULL,
0x00000018ff2f7819ULL, 0x004fe4000001145bULL, 0x000000e9e800720bULL, 0x002fca0003fbd000ULL,
0x0000002e00b07306ULL, 0x000ff00000205400ULL, 0x0000002e00c07306ULL, 0x000fe2000020d400ULL,
0x00000001d0d05812ULL, 0x010fce00078efcffULL, 0x0000002f00c87306ULL, 0x000ff00000209400ULL,
0x0000002f00cd7306ULL, 0x000ff00000205400ULL, 0x0000002f00b97306ULL, 0x000ff0000020d400ULL,
0x0000002d00b57306ULL, 0x000ff00000209400ULL, 0x0000002d00b67306ULL, 0x000ff00000205400ULL,
0x0000002d00907306ULL, 0x0003f0000020d400ULL, 0x0000003000b37306ULL, 0x000fe20000009400ULL,
0x000000002c2c783bULL, 0x002e6e0000000200ULL, 0x0000003000b47306ULL, 0x000ff00000005400ULL,
0x00000030007b7306ULL, 0x0005f0000000d400ULL, 0x00000074009c7306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x004fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000074009d7306ULL, 0x000eb00000205400ULL, 0x0000007400db7306ULL, 0x000ee2000020d400ULL,
0x000100002c9e7824ULL, 0x002fca00078e00ffULL, 0x00000018ffeb7819ULL, 0x000fe4000001149eULL,
0x0000003000af7306ULL, 0x000fe20000209400ULL, 0x0000009d9c00720bULL, 0x004fce0003f5d000ULL,
0x0000003000ae7306ULL, 0x000fec0000205400ULL, 0x00000001dbdb2812ULL, 0x008fe400078efcffULL,
0x0000003000747306ULL, 0x0003e2000020d400ULL, 0x000000edbe00720bULL, 0x000fce0003f5d000ULL,
0x0000003100a87306ULL, 0x000fe20000009400ULL, 0x0001000032307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100a57306ULL, 0x000fe20000005400ULL,
0x00000001d1d12812ULL, 0x000fce00078efcffULL, 0x0000003100687306ULL, 0x0003f0000000d400ULL,
0x00000030008f7306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000927306ULL, 0x000ff00000205400ULL,
0x0000003000767306ULL, 0x0003f0000020d400ULL, 0x0000003100a17306ULL, 0x000fe20000209400ULL,
0x00000018ff307819ULL, 0x002fce000001142cULL, 0x0000003000827306ULL, 0x000ff00000209400ULL,
0x0000003000857306ULL, 0x000ff00000205400ULL, 0x0000003000847306ULL, 0x0003f0000020d400ULL,
0x0000003100a27306ULL, 0x000fe20000205400ULL, 0x0001000058307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100757306ULL, 0x0003f0000020d400ULL,
0x0000003000e57306ULL, 0x000fe20000209400ULL, 0x00000018ff317819ULL, 0x002fce0000011479ULL,
0x0000003100797306ULL, 0x000ff00000209400ULL, 0x00000031007c7306ULL, 0x000ff00000205400ULL,
0x00000031007f7306ULL, 0x0003f0000020d400ULL, 0x0000003000e67306ULL, 0x000ea20000205400ULL,
0x00000018ff317819ULL, 0x002fce000001142eULL, 0x0000003000cb7306ULL, 0x0002f0000020d400ULL,
0x0000003200aa7306ULL, 0x000fe20000009400ULL, 0x000100005a307824ULL, 0x002fe200078e00ffULL,
0x000000e6e500720bULL, 0x004fc80003f5d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003200a77306ULL, 0x000fee0000005400ULL, 0x00000001cbcb2812ULL, 0x008fe200078efcffULL,
0x0000003200697306ULL, 0x0003f0000000d400ULL, 0x0000007300bc7306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000007300c17306ULL, 0x000e700000205400ULL, 0x0000003100897306ULL, 0x000ff00000209400ULL,
0x00000031008a7306ULL, 0x000fe20000205400ULL, 0x000000c1bc00720bULL, 0x002fce0003f3d000ULL,
0x00000031008b7306ULL, 0x0003f0000020d400ULL, 0x0000007300e77306ULL, 0x000ea2000020d400ULL,
0x0001000059317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000d47306ULL, 0x000ff00000209400ULL, 0x0000003000d77306ULL, 0x000e620000205400ULL,
0x00000001e7e71812ULL, 0x004fc800078efcffULL, 0x00000002e702723eULL, 0x000fc600000010ffULL,
0x0000003000c57306ULL, 0x0004f0000020d400ULL, 0x00000078009f7306ULL, 0x000fe20000209400ULL,
0x0000000817307812ULL, 0x004fe400078ec0ffULL, 0x000000d7d400720bULL, 0x002fc40003fdd000ULL,
0x0000000730bf7812ULL, 0x000fc600078ef817ULL, 0x0000007800a07306ULL, 0x000ff00000205400ULL,
0x0000007800737306ULL, 0x000fe2000020d400ULL, 0x00000001c5c56812ULL, 0x008fce00078efcffULL,
0x0000005a00e17306ULL, 0x000ff00000009400ULL, 0x0000005a00a47306ULL, 0x000e700000005400ULL,
0x0000005a00b27306ULL, 0x0004f0000000d400ULL, 0x0000003200777306ULL, 0x000fe20000209400ULL,
0x000001005a5a7824ULL, 0x004fe200078e00ffULL, 0x000000a4e100720bULL, 0x002fcc0003f1d000ULL,
0x0000003200787306ULL, 0x000fee0000205400ULL, 0x00000001b2b20812ULL, 0x008fe200078efcffULL,
0x00000032007a7306ULL, 0x0003e2000020d400ULL, 0x000000b6b500720bULL, 0x000fce0003f1d000ULL,
0x0000005900e27306ULL, 0x000fe20000009400ULL, 0x00000018ff327819ULL, 0x002fca000001142dULL,
0x0000000190900812ULL, 0x000fe400078efcffULL, 0x0000005900a37306ULL, 0x000e620000005400ULL,
0x000000a09f00720bULL, 0x000fce0003f1d000ULL, 0x0000005900bd7306ULL, 0x0004ec000000d400ULL,
0x0000000173730812ULL, 0x000fe400078efcffULL, 0x0000003100d97306ULL, 0x000fe20000209400ULL,
0x0000010059597824ULL, 0x004fe200078e00ffULL, 0x000000a3e200720bULL, 0x002fc40003f9d000ULL,
0x0000006e6d00720bULL, 0x000fe40003f1d000ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000003100da7306ULL, 0x000e6e0000205400ULL, 0x00000001bdbd4812ULL, 0x008fe200078efcffULL,
0x0000003100c47306ULL, 0x0004e2000020d400ULL, 0x000000cdc800720bULL, 0x000fc40003f9d000ULL,
0x000000016f6f0812ULL, 0x000fca00078efcffULL, 0x0000003200867306ULL, 0x000fe20000209400ULL,
0x00000004ff317819ULL, 0x004fe40000011617ULL, 0x000000dad900720bULL, 0x002fc60003f5d000ULL,
0x0000000266c17824ULL, 0x000fe200078e0231ULL, 0x00000001b9b94812ULL, 0x000fe200078efcffULL,
0x0000003200877306ULL, 0x000fe20000205400ULL, 0x000000a7aa00720bULL, 0x000fe20003f9d000ULL,
0x00000001bf307824ULL, 0x000fe200078e02c1ULL, 0x0000000266667810ULL, 0x000fca0007ffe0ffULL,
0x0000003200887306ULL, 0x0003e2000020d400ULL, 0x00000001c4c42812ULL, 0x008fe400078efcffULL,
0x000000c6b700720bULL, 0x000fc60003f5d000ULL, 0x0000000169694812ULL, 0x000fe400078efcffULL,
0x0000003300a67306ULL, 0x000fe20000009400ULL, 0x00000018ff327819ULL, 0x002fe4000001145aULL,
0x00000010bf5a7812ULL, 0x000fca00078efcffULL, 0x0000003300a97306ULL, 0x000fe20000005400ULL,
0x000000015a317824ULL, 0x040fe200078e02c1ULL, 0x00000002c1c17810ULL, 0x000fe20007ffe0ffULL,
0x000000105abc7824ULL, 0x000fe200078e00ffULL, 0x00000001baba2812ULL, 0x000fe400078efcffULL,
0x000000aeaf00720bULL, 0x000fe40003f5d000ULL, 0x00000033006a7306ULL, 0x0003e2000000d400ULL,
0xfffffff0bc317812ULL, 0x000fca00078ee231ULL, 0x0000001031317824ULL, 0x000fe400078e00ffULL,
0x0000005500cf7306ULL, 0x000fe20000209400ULL, 0x0000010033337824ULL, 0x002fe400078e00ffULL,
0x0000000174742812ULL, 0x000fe400078efcffULL, 0x0000007e7d00720bULL, 0x000fe40003f5d000ULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000005500ee7306ULL, 0x000e700000205400ULL,
0x0000005500b17306ULL, 0x000ea4000020d400ULL, 0x000000016c6c2812ULL, 0x000fcc00078efcffULL,
0x0000005800547306ULL, 0x000fe20000009400ULL, 0x000000eecf00720bULL, 0x002fce0003f7d000ULL,
0x0000005800557306ULL, 0x000e6c0000005400ULL, 0x00000001b1b13812ULL, 0x004fe400078efcffULL,
0x0000005900d27306ULL, 0x000ff00000209400ULL, 0x0000005900d57306ULL, 0x000fe20000205400ULL,
0x000000555400720bULL, 0x002fce0003f3d000ULL, 0x0000005900c77306ULL, 0x0003f0000020d400ULL,
0x0000005800b87306ULL, 0x0004e2000000d400ULL, 0x00000010bf597824ULL, 0x002fca00078e00ffULL,
0xfffffff059307812ULL, 0x000fe400078ee230ULL, 0x0000003300807306ULL, 0x000fe20000209400ULL,
0x0000010058587824ULL, 0x004fe400078e00ffULL, 0x0000001030ea7824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003300817306ULL, 0x000fe20000205400ULL,
0x00000000ea54783bULL, 0x000e620000000200ULL, 0x00000001b8b81812ULL, 0x008fe400078efcffULL,
0x000000b0d300720bULL, 0x000fc80003f3d000ULL, 0x0000003300837306ULL, 0x0005f0000020d400ULL,
0x0000005800e07306ULL, 0x000fe20000209400ULL, 0x00000018ff337819ULL, 0x004fe4000001142fULL,
0x00000001c0c01812ULL, 0x000fca00078efcffULL, 0x00000033008c7306ULL, 0x000ff00000209400ULL,
0x00000033008d7306ULL, 0x000ff00000205400ULL, 0x00000033008e7306ULL, 0x0005e2000020d400ULL,
0x000000185434723cULL, 0x042fee0000041834ULL, 0x0000005800e37306ULL, 0x000e620000205400ULL,
0x000100005b337824ULL, 0x004fe200078e00ffULL, 0x00000002543c723cULL, 0x000fe8000004183cULL,
0x00000018ffec7819ULL, 0x000fc40000011433ULL, 0x0000003200cc7306ULL, 0x000ff00000209400ULL,
0x0000003200cf7306ULL, 0x000fe20000205400ULL, 0x000000e3e000720bULL, 0x002fce0003fbd000ULL,
0x0000003200c37306ULL, 0x0003f0000020d400ULL, 0x0000005800c97306ULL, 0x000ea2000020d400ULL,
0x000000003130783bULL, 0x002e6e0000000200ULL, 0x0000005b00dc7306ULL, 0x000ff00000009400ULL,
0x0000005b00dd7306ULL, 0x000ee20000005400ULL, 0x00000001c9c95812ULL, 0x004fc400078efcffULL,
0x000000d5d200720bULL, 0x000fca0003fbd000ULL, 0x0000005b00bb7306ULL, 0x000530000000d400ULL,
0x000000ec00587306ULL, 0x000fe20000209400ULL, 0x000001005b5b7824ULL, 0x004fe200078e00ffULL,
0x00000001c7c75812ULL, 0x000fc400078efcffULL, 0x000000dddc00720bULL, 0x008fe40003f7d000ULL,
0x00000018ffea7819ULL, 0x000fe4000001145bULL, 0x000000ec00597306ULL, 0x000ea20000205400ULL,
0x000000183038723cULL, 0x002b620000041838ULL, 0x000000cfcc00720bULL, 0x000fcc0003fbd000ULL,
0x000000ea005b7306ULL, 0x000fe20000209400ULL, 0x000000d6db18723eULL, 0x020fe200000010ffULL,
0x000000023040723cULL, 0x000b620000041840ULL, 0x000000d8ad19723eULL, 0x000fe400000010ffULL,
0x00000001bbbb3812ULL, 0x010fe400078efcffULL, 0x00000001c3c35812ULL, 0x000fe200078efcffULL,
0x000000ea00ce7306ULL, 0x000e620000205400ULL, 0x000000595800720bULL, 0x004fe20003f3d000ULL,
0x000000185444723cULL, 0x000fe20000041844ULL, 0x000000d0b103723eULL, 0x020fc400000010ffULL,
0x000000cad102723eULL, 0x000fe400000010ffULL, 0x000000a5a800720bULL, 0x000fe20003f7d000ULL,
0x0000002c00917306ULL, 0x000fe20000009400ULL, 0x000000b8cb58723eULL, 0x000fe200000010ffULL,
0x000000183048723cULL, 0x000b620000041848ULL, 0x000000c9c259723eULL, 0x000fe200000010ffULL,
0x000100002fa57824ULL, 0x040fe200078e00ffULL, 0x000000a9a600720bULL, 0x000fe20003fbd000ULL,
0x000001002fa67824ULL, 0x000fe400078e00ffULL, 0x0000002c00947306ULL, 0x000ea20000005400ULL,
0x000000ce5b00720bULL, 0x002fe20003fdd000ULL, 0x000100002d187824ULL, 0x020fe200078e00ffULL,
0x00000002544c723cULL, 0x000f62000004184cULL, 0x000000c7c019723eULL, 0x000fe200000010ffULL,
0x000100002e5b7824ULL, 0x000fe200078e00ffULL, 0x0000000168683812ULL, 0x000fc400078efcffULL,
0x0000002c00937306ULL, 0x0003e2000000d400ULL, 0x00000018ffc67819ULL, 0x000fe40000011418ULL,
0x000000bdc418723eULL, 0x000fe200000010ffULL, 0x000000023050723cULL, 0x000b620000041850ULL,
0x000000787700720bULL, 0x000fe40003f7d000ULL, 0x000000016a6a5812ULL, 0x000fe200078efcffULL,
0x000000ec00bc7306ULL, 0x000ee2000020d400ULL, 0x000001002c2c7824ULL, 0x002fe200078e00ffULL,
0x000000949100720bULL, 0x004fc40003f5d000ULL, 0x000000b2c502723eULL, 0x020fe200000010ffULL,
0x000000585428723cULL, 0x040f620000041828ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x000000ea00be7306ULL, 0x000e62000020d400ULL, 0x000000c3ba03723eULL, 0x000fe400000010ffULL,
0x000000017a7a3812ULL, 0x000fe400078efcffULL, 0x000000185424723cULL, 0x000fe20000041824ULL,
0x000000818000720bULL, 0x000fc40003f7d000ULL, 0x0000002c00ad7306ULL, 0x000fe20000209400ULL,
0x00000001bcbc1812ULL, 0x008fe400078efcffULL, 0x000000b4b300720bULL, 0x000fe40003f3d000ULL,
0x00000002540c723cULL, 0x000fe2000004180cULL, 0x00000018ffb37819ULL, 0x000fe4000001145bULL,
0x0000002c00b07306ULL, 0x000ea20000205400ULL, 0x00000001bebe6812ULL, 0x002fe400078efcffULL,
0x000000acab00720bULL, 0x000fc40003fdd000ULL, 0x000000583008723cULL, 0x040f620000041808ULL,
0x0000000183833812ULL, 0x000fe400078efcffULL, 0x0000002c00b17306ULL, 0x0002e2000020d400ULL,
0x000000017b7b1812ULL, 0x000fe400078efcffULL, 0x000000a2a100720bULL, 0x000fe40003f3d000ULL,
0x00000018301c723cULL, 0x040f62000004181cULL, 0x000000858200720bULL, 0x000fe40003fbd000ULL,
0x0000002d00957306ULL, 0x000fe20000009400ULL, 0x00000010bf2c7824ULL, 0x002fe200078e00ffULL,
0x000000016b6b6812ULL, 0x000fe200078efcffULL, 0x00000001bfbf7824ULL, 0x100fe200078e02c1ULL,
0x000000928f00720bULL, 0x000fe20003fdd000ULL, 0x000000015ac17824ULL, 0x040fe200078e02c1ULL,
0x000000023004723cULL, 0x000b620000041804ULL, 0x000000105a5a7824ULL, 0x000fe200078e00ffULL,
0x0000002d00967306ULL, 0x000e620000005400ULL, 0xfffffff02cbf7812ULL, 0x000fc400078ee2bfULL,
0x000000bbbc2c723eULL, 0x000fe400000010ffULL, 0xfffffff05ac17812ULL, 0x000fe200078ee2c1ULL,
0x00000010bfbf7824ULL, 0x000fe200078e00ffULL, 0x0000000175751812ULL, 0x000fe200078efcffULL,
0x0000002d00977306ULL, 0x0009e2000000d400ULL, 0x0000000176766812ULL, 0x000fe200078efcffULL,
0x00000010c15a7824ULL, 0x000fe200078e00ffULL, 0x0000007b9002723eULL, 0x020fe400000010ffULL,
0x000000746b03723eULL, 0x000fc400000010ffULL, 0x000000717000720bULL, 0x000fe20003f3d000ULL,
0x000000005a58783bULL, 0x000e620000000200ULL, 0x000001002d2d7824ULL, 0x010fe200078e00ffULL,
0x000000eb009e7306ULL, 0x000fe20000209400ULL, 0x0000007c7900720bULL, 0x000fe40003fdd000ULL,
0x000000b0ad00720bULL, 0x004fe40003f7d000ULL, 0x00000018ffbd7819ULL, 0x000fe4000001142dULL,
0x000000beb92d723eULL, 0x000fe200000010ffULL, 0x000000eb00a37306ULL, 0x000ea20000205400ULL,
0x00000018ffa67819ULL, 0x000fc400000114a6ULL, 0x0000000172721812ULL, 0x000fe400078efcffULL,
0x0000000193932812ULL, 0x000fe200078efcffULL, 0x0000002c5420723cULL, 0x080b620000041820ULL,
0x000000017f7f6812ULL, 0x000fe200078efcffULL, 0x00000000bf54783bULL, 0x020f220000000200ULL,
0x000000c600b77306ULL, 0x000fe20000209400ULL, 0x00000001b1b13812ULL, 0x008fe400078efcffULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x0000002c3010723cULL, 0x000f620000041810ULL,
0x000000969500720bULL, 0x002fc40003f9d000ULL, 0x000000c600b87306ULL, 0x000e620000205400ULL,
0x000000a39e00720bULL, 0x004fe40003fdd000ULL, 0x000000878600720bULL, 0x000fe40003f7d000ULL,
0x000000687374723eULL, 0x000fe400000010ffULL, 0x000000756c75723eULL, 0x000fe200000010ffULL,
0x000000bd00ba7306ULL, 0x000fe20000209400ULL, 0x00000069766e723eULL, 0x000fe400000010ffULL,
0x0000000197974812ULL, 0x000fe200078efcffULL, 0x000000025838723cULL, 0x000f620000041838ULL,
0x0000008d8c00720bULL, 0x000fc60003f9d000ULL, 0x000000bd00bb7306ULL, 0x000ea20000205400ULL,
0x000000b8b700720bULL, 0x002fe40003f3d000ULL, 0x0000000188883812ULL, 0x000fe400078efcffULL,
0x0000007a6f6f723eULL, 0x000fe200000010ffULL, 0x000000745840723cULL, 0x000f620000041840ULL,
0x0000006a7f6a723eULL, 0x000fe200000010ffULL, 0x000000b300b47306ULL, 0x000fe20000209400ULL,
0x00000083726b723eULL, 0x000fe400000010ffULL, 0x000000018e8e4812ULL, 0x000fc600078efcffULL,
0x0000006e5848723cULL, 0x000f640000041848ULL, 0x000000b300197306ULL, 0x000e620000205400ULL,
0x000000bbba00720bULL, 0x004fca0003f5d000ULL, 0x000000025434723cULL, 0x050b640000041834ULL,
0x0000002e00987306ULL, 0x000fea0000009400ULL, 0x00000018ff037819ULL, 0x020fe200000114a5ULL,
0x00000074543c723cULL, 0x000b62000004183cULL, 0x000000b184a5723eULL, 0x000fe200000010ffULL,
0x0000002e00997306ULL, 0x000ea20000005400ULL, 0x00000019b400720bULL, 0x002fca0003fbd000ULL,
0x0000006e5444723cULL, 0x040b640000041844ULL, 0x0000002e009a7306ULL, 0x0002ec000000d400ULL,
0x0000006a544c723cULL, 0x000b64000004184cULL, 0x0000002f009b7306ULL, 0x000fe20000009400ULL,
0x000001002e2e7824ULL, 0x002fe200078e00ffULL, 0x000000999800720bULL, 0x004fc80003f1d000ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000006a5850723cULL, 0x000b620000041850ULL,
0x0000002f009c7306ULL, 0x000fee0000005400ULL, 0x000000019a9a0812ULL, 0x008fe200078efcffULL,
0x0000002f009d7306ULL, 0x000fe2000000d400ULL, 0x000000086600780cULL, 0x000fce0003f05270ULL,
0x000000eb00a47306ULL, 0x000e70000020d400ULL, 0x000000c600b27306ULL, 0x000eb0000020d400ULL,
0x000000bd00b97306ULL, 0x000ee2000020d400ULL, 0x00000001a4a46812ULL, 0x002fc400078efcffULL,
0x0000009c9b00720bULL, 0x000fe40003fdd000ULL, 0x00000093a4a4723eULL, 0x000fc600000010ffULL,
0x000000b3002f7306ULL, 0x000322000020d400ULL, 0x00000001b2b21812ULL, 0x004fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003f3d000ULL, 0x000000a45428723cULL, 0x000b620000041828ULL,
0x00000097b2b2723eULL, 0x000fc600000010ffULL, 0x0000002e00187306ULL, 0x000fe20000209400ULL,
0x00000001b9b92812ULL, 0x008fe400078efcffULL, 0x000000019d9d6812ULL, 0x000fe200078efcffULL,
0x000000a45808723cULL, 0x000b620000041808ULL, 0x000000b988b3723eULL, 0x002fc600000010ffULL,
0x0000002e002d7306ULL, 0x000e620000205400ULL, 0x000000012f2f5812ULL, 0x010fe400078efcffULL,
0x000000018b8b1812ULL, 0x000fe200078efcffULL, 0x000000b25424723cULL, 0x000b620000041824ULL,
0x0000009a2f8a723eULL, 0x000fc600000010ffULL, 0x00000003002c7306ULL, 0x000fe80000209400ULL,
0x000000b2581c723cULL, 0x000b68000004181cULL, 0x0000000300317306ULL, 0x000ea20000205400ULL,
0x0000002d1800720bULL, 0x002fce0003f5d000ULL, 0x000000a600307306ULL, 0x000ff00000209400ULL,
0x000000a600337306ULL, 0x000e620000205400ULL, 0x000000312c00720bULL, 0x004fce0003f7d000ULL,
0x0000002e00027306ULL, 0x000eb0000020d400ULL, 0x00000003002e7306ULL, 0x000ee2000020d400ULL,
0x000000333000720bULL, 0x002fce0003fbd000ULL, 0x000000a600197306ULL, 0x000e62000020d400ULL,
0x0000000102022812ULL, 0x004fc800078efcffULL, 0x000000028b8b723eULL, 0x000fe400000010ffULL,
0x000000012e2e3812ULL, 0x008fc800078efcffULL, 0x0000009d2e2e723eULL, 0x000fe200000010ffULL,
0x0000008a540c723cULL, 0x000b62000004180cULL, 0x0000000119195812ULL, 0x002fc800078efcffULL,
0x000000198e2f723eULL, 0x000fc600000010ffULL, 0x0000008a5804723cULL, 0x000b700000041804ULL,
0x0000002e5420723cULL, 0x080b700000041820ULL, 0x0000002e5810723cULL, 0x000b620000041810ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffdf5000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000007918ULL, 0x000fc40000000000ULL,
0x0000005c3f197220ULL, 0x0a0fe40000410000ULL, 0x0000005c44447220ULL, 0x000fc40000410000ULL,
0x0000005c28287220ULL, 0x080fe40000410000ULL, 0x0000005c203f7220ULL, 0x080fe40000410000ULL,
0x0000005c36367220ULL, 0x080fe40000410000ULL, 0x0000005c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000005c472d7220ULL, 0x080fe40000410000ULL, 0x0000005c29297220ULL, 0x000fc40000410000ULL,
0x0000005c24247220ULL, 0x080fe40000410000ULL, 0x0000005c22227220ULL, 0x080fe40000410000ULL,
0x0000005c23207220ULL, 0x080fe40000410000ULL, 0x0000005c34347220ULL, 0x080fe40000410000ULL,
0x0000005c35357220ULL, 0x080fe40000410000ULL, 0x0000005c37377220ULL, 0x000fc40000410000ULL,
0x0000005c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000005c45457220ULL, 0x080fe40000410000ULL,
0x0000005c462c7220ULL, 0x080fe40000410000ULL, 0x0000005c2a2e7220ULL, 0x080fe40000410000ULL,
0x0000005c2b2f7220ULL, 0x080fe40000410000ULL, 0x0000005c25257220ULL, 0x000fc40000410000ULL,
0x0000005c26267220ULL, 0x080fe40000410000ULL, 0x0000005c27307220ULL, 0x080fe40000410000ULL,
0x0000005c38387220ULL, 0x080fe40000410000ULL, 0x0000005c40317220ULL, 0x080fe40000410000ULL,
0x0000005c41327220ULL, 0x080fe40000410000ULL, 0x0000005c48337220ULL, 0x000fc40000410000ULL,
0x0000005c0a5b7220ULL, 0x080fe40000410000ULL, 0x0000005c3e187220ULL, 0x080fe40000410000ULL,
0x0000005c4c027220ULL, 0x080fe40000410000ULL, 0x0000005c4d037220ULL, 0x080fe40000410000ULL,
0x0000005c4e4e7220ULL, 0x080fe40000410000ULL, 0x0000005c4f4f7220ULL, 0x000fc40000410000ULL,
0x0000005c0c0c7220ULL, 0x080fe40000410000ULL, 0x0000005c0d0d7220ULL, 0x080fe40000410000ULL,
0x0000005c0e0e7220ULL, 0x080fe40000410000ULL, 0x0000005c0f0f7220ULL, 0x080fe40000410000ULL,
0x0000005c39397220ULL, 0x080fe40000410000ULL, 0x0000005c49547220ULL, 0x000fc40000410000ULL,
0x0000005c4a597220ULL, 0x080fe40000410000ULL, 0x0000005c50507220ULL, 0x080fe40000410000ULL,
0x0000005c51517220ULL, 0x080fe40000410000ULL, 0x0000005c08087220ULL, 0x080fe40000410000ULL,
0x0000005c09097220ULL, 0x080fe40000410000ULL, 0x0000005c1c1c7220ULL, 0x000fc40000410000ULL,
0x0000005c1d0a7220ULL, 0x080fe40000410000ULL, 0x0000005c04047220ULL, 0x080fe40000410000ULL,
0x0000005c05057220ULL, 0x080fe40000410000ULL, 0x0000005c10107220ULL, 0x080fe40000410000ULL,
0x0000005c3a557220ULL, 0x080fe40000410000ULL, 0x0000005c3b567220ULL, 0x000fc40000410000ULL,
0x0000005c43587220ULL, 0x080fe40000410000ULL, 0x0000005c1f667220ULL, 0x080fe40000410000ULL,
0x000000ffff4c7224ULL, 0x000fe400078e0044ULL, 0x000000ffff4a7224ULL, 0x000fe400078e0028ULL,
0x0000005c213e7220ULL, 0x080fe40000410000ULL, 0x0000005c42577220ULL, 0x000fc40000410000ULL,
0x0000005c4b5a7220ULL, 0x000fe40000410000ULL, 0x000000ffff477224ULL, 0x000fe400078e003dULL,
0x000000ffff447224ULL, 0x000fe400078e0029ULL, 0x000000ffff437224ULL, 0x000fe400078e0024ULL,
0x000000ffff287224ULL, 0x000fe400078e0036ULL, 0x000000ffff1f7224ULL, 0x000fc400078e002dULL,
0x000000ffff3b7224ULL, 0x000fe400078e0022ULL, 0x000000ffff3a7224ULL, 0x000fe400078e0020ULL,
0x000000ffff4d7224ULL, 0x000fe400078e0034ULL, 0x000000ffff467224ULL, 0x000fe400078e0035ULL,
0x000000ffff4b7224ULL, 0x000fe400078e003cULL, 0x000000ffff487224ULL, 0x000fc400078e0045ULL,
0x000000ffff427224ULL, 0x000fe400078e0025ULL, 0x000000ffff277224ULL, 0x000fe400078e0037ULL,
0x000000ffff217224ULL, 0x000fe400078e002cULL, 0x000000ffff2b7224ULL, 0x000fe400078e002eULL,
0x000000ffff3d7224ULL, 0x000fe400078e002fULL, 0x000000ffff2d7224ULL, 0x000fc400078e0026ULL,
0x000000ffff367224ULL, 0x000fe400078e0030ULL, 0x000000ffff297224ULL, 0x000fe400078e0038ULL,
0x000000ffff247224ULL, 0x000fe400078e0031ULL, 0x000000ffff227224ULL, 0x000fe400078e0032ULL,
0x000000ffff207224ULL, 0x000fe400078e0033ULL, 0x0000005c52527220ULL, 0x000fc40000410000ULL,
0x0000005c53537220ULL, 0x080fe40000410000ULL, 0x0000005c0b0b7220ULL, 0x080fe40000410000ULL,
0x0000005c1e5f7220ULL, 0x080fe40000410000ULL, 0x0000005c06687220ULL, 0x080fe40000410000ULL,
0x0000005c07697220ULL, 0x080fe40000410000ULL, 0x0000005c11117220ULL, 0x000fc40000410000ULL,
0x0000005c126a7220ULL, 0x080fe40000410000ULL, 0x0000005c136b7220ULL, 0x000fe40000410000ULL,
0x000000ffff457224ULL, 0x000fe400078e0002ULL, 0x000000ffff497224ULL, 0x000fe400078e0003ULL,
0x000000ffff417224ULL, 0x000fe400078e000cULL, 0x000000ffff407224ULL, 0x000fc400078e000dULL,
0x000000ffff257224ULL, 0x000fe400078e0018ULL, 0x000000ffff237224ULL, 0x000fe400078e0019ULL,
0x000000ffff2a7224ULL, 0x000fe400078e004eULL, 0x000000ffff2c7224ULL, 0x000fe400078e004fULL,
0x000000ffff2e7224ULL, 0x000fe400078e000eULL, 0x000000ffff2f7224ULL, 0x000fc400078e000fULL,
0x000000ffff267224ULL, 0x000fe400078e0039ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0054ULL,
0x000000ffff307224ULL, 0x000fe400078e0050ULL, 0x000000ffff317224ULL, 0x000fe400078e0051ULL,
0x000000ffff327224ULL, 0x000fe400078e0008ULL, 0x000000ffff337224ULL, 0x000fc400078e0009ULL,
0x000000ffff347224ULL, 0x000fe400078e001cULL, 0x000000ffff357224ULL, 0x000fe400078e000aULL,
0x000000ffff3c7224ULL, 0x000fe400078e0004ULL, 0x000000ffff377224ULL, 0x000fe400078e0005ULL,
0x000000ffff387224ULL, 0x000fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005d067f8cULL, 0x0002a2000c80043fULL, 0x000000ffff397224ULL, 0x000fc400078e0011ULL,
0x000000ffff0e7224ULL, 0x000fe400078e000bULL, 0x000000ffff1e7224ULL, 0x000fe400078e0055ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0056ULL, 0x000000ffff197224ULL, 0x000fe400078e0057ULL,
0x000000ffff187224ULL, 0x000fe400078e0058ULL, 0x000000ffff137224ULL, 0x000fc400078e0059ULL,
0x000000ffff127224ULL, 0x000fe400078e005aULL, 0x000000ffff117224ULL, 0x000fe400078e0052ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0053ULL, 0x000000ffff107224ULL, 0x000fe400078e005bULL,
0x000000ffff087224ULL, 0x000fe400078e005fULL, 0x000000ffff097224ULL, 0x000fc400078e0066ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0068ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0069ULL,
0x000000ffff0c7224ULL, 0x000fe400078e006aULL, 0x000000ffff0d7224ULL, 0x000fc400078e006bULL,
0x0000000000027805ULL, 0x006fca0000015200ULL, 0x000004005d057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x00000004024f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000004f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004005d057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000417027824ULL, 0x000fe200078e00ffULL,
0x000000636000720cULL, 0x000fc80003f06070ULL, 0xfffffff002037812ULL, 0x000fca00078ec0ffULL,
0x000000801a037824ULL, 0x000fca00078e0203ULL, 0x01a4000003047984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x00000002174f7824ULL, 0x040fe200078e00ffULL,
0x0000000017507211ULL, 0x000fe200078ff0ffULL, 0x00000002ff727424ULL, 0x000fe200078e00ffULL,
0xffffff0065657810ULL, 0x000fe40007ffe0ffULL, 0x0000000850517810ULL, 0x000fe40007ffe0ffULL,
0x00000065164e7217ULL, 0x000fe40007800000ULL, 0x000000064f4f7812ULL, 0x000fc400078ec0ffULL,
0x00005a00ff567a19ULL, 0x000fe20000011651ULL, 0x000000014e4e7824ULL, 0x000fe200078e0a65ULL,
0x000058004f517a10ULL, 0x000fe20007ffe0ffULL, 0x0000000162537824ULL, 0x000fe200078e024fULL,
0x00005a00ff527a19ULL, 0x000fe40000011650ULL, 0x0000001050577810ULL, 0x040fe20007ffe0ffULL,
0x0000000153547824ULL, 0x100fe200078e0a4eULL, 0x0000001850587810ULL, 0x000fe20007ffe0ffULL,
0x0000000151507824ULL, 0x040fe200078e0a4eULL, 0x0000004e5100720cULL, 0x000fc40003f06070ULL,
0x0000004e5300720cULL, 0x000fe40003f26070ULL, 0x0000005061507217ULL, 0x040fe40003800000ULL,
0x0000005461547217ULL, 0x040fe40003800000ULL, 0x0000005261537217ULL, 0x000fe40003800000ULL,
0x000000ff506d7207ULL, 0x000fe40000000000ULL, 0x00005a00ff507a19ULL, 0x000fe20000011657ULL,
0x0000005364787224ULL, 0x000fe200078e02ffULL, 0x00005a00ff587a19ULL, 0x000fc40000011658ULL,
0x00000004ff547819ULL, 0x000fe40000011654ULL, 0x0000005661557217ULL, 0x040fe40003800000ULL,
0x0000005061537217ULL, 0x040fe40003800000ULL, 0x00000058615f7217ULL, 0x000fe20003800000ULL,
0x0000005564847224ULL, 0x000fe200078e02ffULL, 0x000000ff545b7207ULL, 0x000fe20000800000ULL,
0x0000005364867224ULL, 0x040fe200078e02ffULL, 0x000000786d557211ULL, 0x040fe200078fe0ffULL,
0x0000005f648e7224ULL, 0x000fe200078e02ffULL, 0x000000846d597211ULL, 0x000fe200078fe0ffULL,
0x0000000178577824ULL, 0x000fc400078e025bULL, 0x000000015b697824ULL, 0x040fe400078e0284ULL,
0x000000015b6f7824ULL, 0x040fe400078e0286ULL, 0x000000015b757824ULL, 0x000fe200078e028eULL,
0x000000104f5b7812ULL, 0x000fe200078efcffULL, 0x0000600055547625ULL, 0x000fc800078e0072ULL,
0x0000600057567625ULL, 0x080fe200078e0072ULL, 0x000058005b5f7a10ULL, 0x000fe20007ffe0ffULL,
0x0000000854507981ULL, 0x000724000c1e9500ULL, 0x0000600059587625ULL, 0x000fe400078e0072ULL,
0x0000000856537981ULL, 0x000322000c1e9500ULL, 0x000000866d6b7211ULL, 0x000fe200078fe0ffULL,
0x0000000162657824ULL, 0x000fe400078e025bULL, 0x0000000858527981ULL, 0x000524000c1e9500ULL,
0x00000001655a7824ULL, 0x000fe200078e0a4eULL, 0x0000008e6d717211ULL, 0x000fe200078fe0ffULL,
0x000060006b6a7625ULL, 0x000fe200078e0072ULL, 0x0000004e5f00720cULL, 0x000fc60003f06070ULL,
0x000000015f587824ULL, 0x004fe400078e0a4eULL, 0x0000600069687625ULL, 0x000fe200078e0072ULL,
0x0000005a615a7217ULL, 0x040fe20003800000ULL, 0x000000086a547981ULL, 0x0084e2000c1e9500ULL,
0x0000005861587217ULL, 0x000fe20003800000ULL, 0x000060006f6e7625ULL, 0x080fe400078e0072ULL,
0x0000000868577981ULL, 0x0022e2000c1e9500ULL, 0x000000ff58897207ULL, 0x000fe20000000000ULL,
0x0000600071707625ULL, 0x000fc400078e0072ULL, 0x000000086e597981ULL, 0x0004e2000c1e9500ULL,
0x0000004e6500720cULL, 0x000fe40003f26070ULL, 0x00000004ff5a7819ULL, 0x000fe2000001165aULL,
0x0000600075747625ULL, 0x000fe200078e0072ULL, 0x0000000870557981ULL, 0x0004e2000c1e9500ULL,
0x0000007889697211ULL, 0x002fc600078fe0ffULL, 0x0000000874567981ULL, 0x0002e4000c1e9500ULL,
0x0000600069687625ULL, 0x000fe200078e0072ULL, 0x000000ff5a717207ULL, 0x004fc80000800000ULL,
0x0000000868587981ULL, 0x0004e2000c1e9500ULL, 0x00000084896f7211ULL, 0x000fe200078fe0ffULL,
0x00000001786b7824ULL, 0x000fe400078e0271ULL, 0x0000000171757824ULL, 0x002fe400078e0286ULL,
0x000060006b6a7625ULL, 0x000fc800078e0072ULL, 0x0000600075687625ULL, 0x084fe200078e0072ULL,
0x000000204f757812ULL, 0x000fe200078efcffULL, 0x000000086a657981ULL, 0x0002a4000c1e9500ULL,
0x000060006f6e7625ULL, 0x000fe200078e0072ULL, 0x00000086897d7211ULL, 0x000fe200078fe0ffULL,
0x0000000868797981ULL, 0x0002a4000c1e9500ULL, 0x0000000171737824ULL, 0x040fe400078e0284ULL,
0x0000000171777824ULL, 0x000fe200078e028eULL, 0x000000086e5a7981ULL, 0x0002a2000c1e9500ULL,
0x0000600073707625ULL, 0x000fc800078e0072ULL, 0x00000001626b7824ULL, 0x002fe200078e0275ULL,
0x0000000870737981ULL, 0x0002a2000c1e9500ULL, 0x00006000776e7625ULL, 0x000fe200078e0072ULL,
0x0000580075777a10ULL, 0x000fc60007ffe0ffULL, 0x000000016b747824ULL, 0x100fe200078e0a4eULL,
0x0000008e897f7211ULL, 0x000fe200078fe0ffULL, 0x00000001776a7824ULL, 0x000fe200078e0a4eULL,
0x0000004e6b00720cULL, 0x000fe20003f26070ULL, 0x000060007d7c7625ULL, 0x000fe200078e0072ULL,
0x0000007461747217ULL, 0x000fe20003800000ULL, 0x000000086e7b7981ULL, 0x0002a2000c1e9500ULL,
0x0000004e7700720cULL, 0x000fe20003f06070ULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x0000006a616a7217ULL, 0x000fe20003800000ULL, 0x000000087c667981ULL, 0x0002a2000c1e9500ULL,
0x00000004ff747819ULL, 0x000fc40000011674ULL, 0x000000ff6a8f7207ULL, 0x000fe20000000000ULL,
0x000000087e6c7981ULL, 0x0002a2000c1e9500ULL, 0x000000ff74697207ULL, 0x000fe40000800000ULL,
0x000000848f837211ULL, 0x000fc600078fe0ffULL, 0x0000000169717824ULL, 0x002fe400078e0284ULL,
0x0000600083827625ULL, 0x000fe200078e0072ULL, 0x000000788f6b7211ULL, 0x000fc600078fe0ffULL,
0x0000600071707625ULL, 0x080fe200078e0072ULL, 0x0000000882767981ULL, 0x0002a6000c1e9500ULL,
0x00000001787f7824ULL, 0x000fe200078e0269ULL, 0x0000000870cb7981ULL, 0x0002a2000c1e9500ULL,
0x000060006b6a7625ULL, 0x000fe200078e0072ULL, 0x000000868f6f7211ULL, 0x040fe400078fe0ffULL,
0x0000008e8f857211ULL, 0x000fe200078fe0ffULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x000000304fb17812ULL, 0x000fe200078efcffULL, 0x000000086a747981ULL, 0x0002a4000c1e9500ULL,
0x00000001697d7824ULL, 0x000fc400078e0286ULL, 0x0000000169877824ULL, 0x000fe200078e028eULL,
0x000000087e817981ULL, 0x0002a2000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x00005800b1b37a10ULL, 0x000fc60007ffe0ffULL, 0x0000600085687625ULL, 0x080fe200078e0072ULL,
0x000000086ecf7981ULL, 0x0002a6000c1e9500ULL, 0x000060007d7c7625ULL, 0x080fe200078e0072ULL,
0x0000000868d37981ULL, 0x0002a6000c1e9500ULL, 0x00006000876a7625ULL, 0x002fe200078e0072ULL,
0x000000087c8a7981ULL, 0x0002a6000c1e9500ULL, 0x00000001627f7824ULL, 0x000fe200078e02b1ULL,
0x000000086a907981ULL, 0x0002a6000c1e9500ULL, 0x000000017f7e7824ULL, 0x000fc400078e0a4eULL,
0x00000001b37a7824ULL, 0x000fc600078e0a4eULL, 0x0000007e617e7217ULL, 0x000fe40003800000ULL,
0x0000004e7f00720cULL, 0x080fe40003f26070ULL, 0x0000004eb300720cULL, 0x000fe40003f06070ULL,
0x0000007a617a7217ULL, 0x000fe40003800000ULL, 0x00000004ff7e7819ULL, 0x000fe4000001167eULL,
0x000000ff7a957207ULL, 0x000fc40000000000ULL, 0x000000ff7e837207ULL, 0x000fe40000800000ULL,
0x00000078957d7211ULL, 0x042fe400078fe0ffULL, 0x00000086956b7211ULL, 0x000fe200078fe0ffULL,
0x00000001787f7824ULL, 0x000fe400078e0283ULL, 0x00000001836f7824ULL, 0x000fe400078e0286ULL,
0x000060007d7c7625ULL, 0x000fc800078e0072ULL, 0x000060007f7e7625ULL, 0x080fe200078e0072ULL,
0x000000087cb57981ULL, 0x0002a6000c1e9500ULL, 0x000060006b6a7625ULL, 0x080fe200078e0072ULL,
0x000000087e807981ULL, 0x0002a6000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x000000086ad17981ULL, 0x0002a2000c1e9500ULL, 0x0000008495697211ULL, 0x000fc600078fe0ffULL,
0x000000086e8c7981ULL, 0x0002a2000c1e9500ULL, 0x0000000183717824ULL, 0x000fe400078e0284ULL,
0x0000600069687625ULL, 0x000fc800078e0072ULL, 0x0000600071707625ULL, 0x000fe200078e0072ULL,
0x0000000868cd7981ULL, 0x0002a4000c1e9500ULL, 0x0000008e957d7211ULL, 0x002fe400078fe0ffULL,
0x0000000870887981ULL, 0x0002a2000c1e9500ULL, 0x00000001837f7824ULL, 0x000fe400078e028eULL,
0x000060007d7c7625ULL, 0x000fc800078e0072ULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x000000087cd57981ULL, 0x0002a8000c1e9500ULL, 0x000000087e8e7981ULL, 0x0002a2000c1e9500ULL,
0xfffffff06d6d7812ULL, 0x000fe200078ec0ffULL, 0x00000001ffc97424ULL, 0x000fc800078e00ffULL,
0x000000014e687824ULL, 0x000fc800078e026dULL, 0x0000000151697824ULL, 0x000fe200078e0a68ULL,
0x000000014f837812ULL, 0x000fc800078efcffULL, 0x00000069c9697219ULL, 0x000fe400000006ffULL,
0x00005800836b7a10ULL, 0x000fe40007ffe0ffULL, 0x000000084f857812ULL, 0x000fc600078efcffULL,
0x000000016b6a7824ULL, 0x100fe200078e0a68ULL, 0x000000094f877812ULL, 0x000fe400078efcffULL,
0x00005800856f7a10ULL, 0x000fe40007ffe0ffULL, 0x0000006ac96d7219ULL, 0x000fe400000006ffULL,
0x00005800877d7a10ULL, 0x002fe20007ffe0ffULL, 0x000000016f6e7824ULL, 0x000fc800078e0a68ULL,
0x000000017d687824ULL, 0x000fe200078e0a68ULL, 0x000000114f8b7812ULL, 0x000fe400078efcffULL,
0xfffffff089897812ULL, 0x000fe400078ec0ffULL, 0x0000006ec9717219ULL, 0x040fe400000006ffULL,
0x00000068c97f7219ULL, 0x000fe200000006ffULL, 0x000000014e707824ULL, 0x000fe200078e0289ULL,
0x000058008b8d7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff08f8f7812ULL, 0x000fe200078ec0ffULL,
0x000000015f687824ULL, 0x000fc400078e0a70ULL, 0x000000018d6a7824ULL, 0x000fe200078e0a70ULL,
0x000000184f917812ULL, 0x040fe200078efcffULL, 0x000000014e727824ULL, 0x000fe200078e028fULL,
0x000000194f977812ULL, 0x000fe400078efcffULL, 0x0000541050507816ULL, 0x010fc80000000053ULL,
0x0000005069ff7212ULL, 0x000fc800078ac0ffULL, 0x0000004e5100720cULL, 0x000fc80002fa1470ULL,
0x0000004e4f00720cULL, 0x000fe40002fa1070ULL, 0x000000506dff7212ULL, 0x000fe4000782c0ffULL,
0xff8000004d4d7808ULL, 0x000fe40002800000ULL, 0x0000541052527816ULL, 0x008fe40000000057ULL,
0x0000541054547816ULL, 0x000fe40000000059ULL, 0x0000005269ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005469ff7212ULL, 0x000fe4000788c0ffULL, 0x000000526dff7212ULL, 0x000fe400078ac0ffULL,
0x0000004e5100720cULL, 0x0c0fe40001741470ULL, 0x0000004e5100720cULL, 0x080fe40002781470ULL,
0x0000004e6b00720cULL, 0x0c0fe40000f21470ULL, 0x0000004e6b00720cULL, 0x000fc40002fa1470ULL,
0x0000004e4f00720cULL, 0x0c0fe40001741070ULL, 0x0000004e4f00720cULL, 0x080fe40002781070ULL,
0x0000004e8300720cULL, 0x0c0fe40000f21070ULL, 0x0000004e8300720cULL, 0x000fe40002fa1070ULL,
0x0000541055567816ULL, 0x000fe40000000056ULL, 0xff80000028287808ULL, 0x000fc40001000000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff80000046467808ULL, 0x000fe40000800000ULL,
0xff80000027277808ULL, 0x000fe40002800000ULL, 0x0000005071ff7212ULL, 0x000fe4000786c0ffULL,
0x0000005669ff7212ULL, 0x000fe4000780c0ffULL, 0x000000546dff7212ULL, 0x000fc4000784c0ffULL,
0x000000566dff7212ULL, 0x000fe4000788c0ffULL, 0x000000527fff7212ULL, 0x000fe4000782c0ffULL,
0x0000005471ff7212ULL, 0x000fe400078ac0ffULL, 0x0000004e5100720cULL, 0x080fe40000701470ULL,
0x0000004e6b00720cULL, 0x0c0fe40001741470ULL, 0x0000004e6b00720cULL, 0x000fc40002781470ULL,
0x0000004e6f00720cULL, 0x0c0fe40001f61470ULL, 0x0000004e6f00720cULL, 0x080fe40002fa1470ULL,
0x0000004e7d00720cULL, 0x080fe40000f21470ULL, 0x0000004e4f00720cULL, 0x080fe40000701070ULL,
0x0000004e8300720cULL, 0x0c0fe40001741070ULL, 0x0000004e8300720cULL, 0x000fc40002781070ULL,
0x0000004e8500720cULL, 0x0c0fe40001f61070ULL, 0x0000004e8500720cULL, 0x080fe40002fa1070ULL,
0x0000004e8700720cULL, 0x000fe40000f21070ULL, 0x00000068c9897219ULL, 0x040fe400000006ffULL,
0x0000006ac98f7219ULL, 0x000fe400000006ffULL, 0x0000541058587816ULL, 0x004fc40000000065ULL,
0x000054105a5a7816ULL, 0x000fe40000000073ULL, 0x0000580091937a10ULL, 0x000fe40007ffe0ffULL,
0x0000580097997a10ULL, 0x000fe40007ffe0ffULL, 0xff8000001e1e7808ULL, 0x000fe40000000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff8000001c1c7808ULL, 0x000fc40002000000ULL,
0xff8000004b4b7808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0xff80000023237808ULL, 0x000fe40000800000ULL, 0x0000005271ff7212ULL, 0x000fe4000780c0ffULL,
0x000000547fff7212ULL, 0x000fe4000784c0ffULL, 0x0000005671ff7212ULL, 0x000fc4000788c0ffULL,
0x000000567fff7212ULL, 0x000fe4000786c0ffULL, 0x000000588fff7212ULL, 0x000fe400078ac0ffULL,
0x0000005a89ff7212ULL, 0x000fe2000782c0ffULL, 0x00000001936e7824ULL, 0x100fe200078e0a70ULL,
0xfffffff095957812ULL, 0x000fe200078ec0ffULL, 0x0000000199707824ULL, 0x000fe200078e0a70ULL,
0x0000004e6f00720cULL, 0x0c0fe40000701470ULL, 0x0000004e6f00720cULL, 0x000fc40002781470ULL,
0x0000004e7d00720cULL, 0x0c0fe40001741470ULL, 0x0000004e7d00720cULL, 0x080fe40001f61470ULL,
0x0000004e5f00720cULL, 0x080fe40000f21470ULL, 0x0000004e8d00720cULL, 0x080fe20002fa1470ULL,
0x000000014e7e7824ULL, 0x000fe200078e0295ULL, 0x0000004e8500720cULL, 0x0c0fe40000701070ULL,
0x0000004e8500720cULL, 0x000fc40002781070ULL, 0x0000004e8700720cULL, 0x0c0fe40001741070ULL,
0x0000004e8700720cULL, 0x080fe40001f61070ULL, 0x0000004e5b00720cULL, 0x080fe40000f21070ULL,
0x0000004e8b00720cULL, 0x000fe40002fa1070ULL, 0x0000006ec9957219ULL, 0x040fe400000006ffULL,
0x00000070c99b7219ULL, 0x000fc400000006ffULL, 0x0000541066667816ULL, 0x000fe40000000079ULL,
0x000054106c6c7816ULL, 0x000fe4000000007bULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0xff80000019197808ULL, 0x000fe40002000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff80000018187808ULL, 0x000fc40001800000ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff80000048487808ULL, 0x000fe40002800000ULL, 0x0000005889ff7212ULL, 0x080fe4000780c0ffULL,
0x0000005895ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006689ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006c89ff7212ULL, 0x000fc4000786c0ffULL, 0x000000668fff7212ULL, 0x000fe4000782c0ffULL,
0x0000005a9bff7212ULL, 0x000fe200078ac0ffULL, 0x0000000177787824ULL, 0x000fe200078e0a72ULL,
0x0000004e5f00720cULL, 0x0c0fe40000701470ULL, 0x0000004e5f00720cULL, 0x0c0fe40001741470ULL,
0x0000004e5f00720cULL, 0x080fe40001f61470ULL, 0x0000004e8d00720cULL, 0x000fc40000f21470ULL,
0x0000004e9300720cULL, 0x080fe40002781470ULL, 0x0000004e9900720cULL, 0x080fe40002fa1470ULL,
0x000000214f9f7812ULL, 0x000fe400078efcffULL, 0x0000004e5b00720cULL, 0x0c0fe40000701070ULL,
0x0000004e5b00720cULL, 0x0c0fe40001741070ULL, 0x0000004e5b00720cULL, 0x000fc40001f61070ULL,
0x0000004e8b00720cULL, 0x080fe40000f21070ULL, 0x0000004e9100720cULL, 0x080fe40002781070ULL,
0x0000004e9700720cULL, 0x000fe40002fa1070ULL, 0x00000078c99d7219ULL, 0x000fe400000006ffULL,
0x0000541076767816ULL, 0x000fe400000000cbULL, 0x000058009fa17a10ULL, 0x000fc40007ffe0ffULL,
0xff8000004c4c7808ULL, 0x000fe40000000000ULL, 0xff80000020207808ULL, 0x000fe40001000000ULL,
0xff80000013137808ULL, 0x000fe40001800000ULL, 0xff8000001d1d7808ULL, 0x000fe40000800000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0xff8000002c2c7808ULL, 0x000fc40002800000ULL,
0x0000005a8fff7212ULL, 0x040fe4000780c0ffULL, 0x0000006c8fff7212ULL, 0x000fe4000784c0ffULL,
0x0000005a95ff7212ULL, 0x000fe4000786c0ffULL, 0x000000669bff7212ULL, 0x040fe4000782c0ffULL,
0x0000006c9bff7212ULL, 0x000fe4000788c0ffULL, 0x000000769dff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a17a7824ULL, 0x000fe200078e0a72ULL, 0x0000004e8d00720cULL, 0x000fc40000701470ULL,
0x0000004e8d00720cULL, 0x080fe40001741470ULL, 0x0000004e9300720cULL, 0x080fe40001f61470ULL,
0x0000004e9900720cULL, 0x0c0fe40000f21470ULL, 0x0000004e9900720cULL, 0x080fe40002781470ULL,
0x0000004e7700720cULL, 0x000fe40002fa1470ULL, 0x000000284fa57812ULL, 0x000fc400078efcffULL,
0x000000294fab7812ULL, 0x000fe400078efcffULL, 0x0000004e8b00720cULL, 0x0c0fe40000701070ULL,
0x0000004e8b00720cULL, 0x080fe40001741070ULL, 0x0000004e9100720cULL, 0x080fe40001f61070ULL,
0x0000004e9700720cULL, 0x0c0fe40000f21070ULL, 0x0000004e9700720cULL, 0x000fc40002781070ULL,
0x0000004e7500720cULL, 0x000fe40002fa1070ULL, 0x0000007ac9a37219ULL, 0x000fe400000006ffULL,
0x0000541074747816ULL, 0x000fe40000000081ULL, 0x00005410cf8a7816ULL, 0x000fe4000000008aULL,
0x00005410d3907816ULL, 0x000fe40000000090ULL, 0x00005800a5a77a10ULL, 0x000fc40007ffe0ffULL,
0x00005800abad7a10ULL, 0x000fe40007ffe0ffULL, 0xff8000001f1f7808ULL, 0x000fe40000000000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0xff8000000f0f7808ULL, 0x000fc40002000000ULL,
0xff8000002b2b7808ULL, 0x000fe40002800000ULL, 0x000000507fff7212ULL, 0x000fe400078cc0ffULL,
0x0000006695ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006c95ff7212ULL, 0x000fe4000784c0ffULL,
0x000000749dff7212ULL, 0x040fe4000786c0ffULL, 0x0000008a9dff7212ULL, 0x000fc4000782c0ffULL,
0x000000909dff7212ULL, 0x000fe4000788c0ffULL, 0x0000008aa3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a77c7824ULL, 0x100fe200078e0a72ULL, 0x0000004e7d00720cULL, 0x080fe200037c1470ULL,
0x00000001ad727824ULL, 0x000fe200078e0a72ULL, 0x0000004e9300720cULL, 0x0c0fe40000701470ULL,
0x0000004e9300720cULL, 0x080fe40001741470ULL, 0x0000004e7700720cULL, 0x000fc40001f61470ULL,
0x0000004e7700720cULL, 0x0c0fe40000f21470ULL, 0x0000004e7700720cULL, 0x080fe40002781470ULL,
0x0000004ea100720cULL, 0x080fe40002fa1470ULL, 0x0000004e8700720cULL, 0x080fe400037c1070ULL,
0x0000004e9100720cULL, 0x0c0fe40000701070ULL, 0x0000004e9100720cULL, 0x000fc40001741070ULL,
0x0000004e7500720cULL, 0x0c0fe40001f61070ULL, 0x0000004e7500720cULL, 0x0c0fe40000f21070ULL,
0x0000004e7500720cULL, 0x080fe40002781070ULL, 0x0000004e9f00720cULL, 0x000fe40002fa1070ULL,
0x0000007cc9a97219ULL, 0x040fe400000006ffULL, 0x00000072c9af7219ULL, 0x000fc400000006ffULL,
0xff80000047477808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fe40000000000ULL,
0xff80000011117808ULL, 0x000fe40001000000ULL, 0xff8000004a4a7808ULL, 0x000fe40001800000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000010107808ULL, 0x000fc40002000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x000000589bff7212ULL, 0x000fe400078cc0ffULL,
0x00000074a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000074a9ff7212ULL, 0x000fe4000784c0ffULL,
0x00000076a3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000090a3ff7212ULL, 0x000fc4000782c0ffULL,
0x00000076a9ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008aafff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b3827824ULL, 0x000fe200078e0a7eULL, 0x0000004e9900720cULL, 0x080fe400037c1470ULL,
0x0000004ea100720cULL, 0x0c0fe40000701470ULL, 0x0000004ea100720cULL, 0x0c0fe40001f61470ULL,
0x0000004ea100720cULL, 0x000fc40000f21470ULL, 0x0000004ea700720cULL, 0x0c0fe40001741470ULL,
0x0000004ea700720cULL, 0x080fe40002781470ULL, 0x0000004ead00720cULL, 0x000fe40002fa1470ULL,
0x000000314fb97812ULL, 0x040fe400078efcffULL, 0x000000384fbf7812ULL, 0x040fe400078efcffULL,
0x000000394fc57812ULL, 0x000fc400078efcffULL, 0x0000004e9700720cULL, 0x080fe400037c1070ULL,
0x0000004e9f00720cULL, 0x0c0fe40000701070ULL, 0x0000004e9f00720cULL, 0x0c0fe40001f61070ULL,
0x0000004e9f00720cULL, 0x080fe40000f21070ULL, 0x0000004ea500720cULL, 0x0c0fe40001741070ULL,
0x0000004ea500720cULL, 0x000fc40002781070ULL, 0x0000004eab00720cULL, 0x000fe40002fa1070ULL,
0x00000082c9b77219ULL, 0x000fe400000006ffULL, 0x00005410b5807816ULL, 0x000fe40000000080ULL,
0x00005410d18c7816ULL, 0x000fe4000000008cULL, 0x00005800b9bb7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800bfc17a10ULL, 0x000fc40007ffe0ffULL, 0x00005800c5c77a10ULL, 0x000fe40007ffe0ffULL,
0xff80000049497808ULL, 0x000fe40003000000ULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff8000003d3d7808ULL, 0x000fe40001800000ULL, 0xff8000000e0e7808ULL, 0x000fe40000800000ULL,
0xff80000043437808ULL, 0x000fc40001000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff80000035357808ULL, 0x000fe40002800000ULL, 0x00000074afff7212ULL, 0x040fe400078cc0ffULL,
0x00000076afff7212ULL, 0x000fe4000780c0ffULL, 0x0000008aa9ff7212ULL, 0x040fe4000786c0ffULL,
0x00000090a9ff7212ULL, 0x000fc4000782c0ffULL, 0x00000090afff7212ULL, 0x000fe4000784c0ffULL,
0x00000080b7ff7212ULL, 0x040fe4000788c0ffULL, 0x0000008cb7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bb847824ULL, 0x100fe200078e0a7eULL, 0x0000004ea700720cULL, 0x080fe20001f61470ULL,
0x00000001c1867824ULL, 0x100fe200078e0a7eULL, 0x0000004ea700720cULL, 0x080fe20000f21470ULL,
0x00000001c77e7824ULL, 0x000fe200078e0a7eULL, 0x0000004ead00720cULL, 0x000fc400037c1470ULL,
0x0000004ead00720cULL, 0x0c0fe40000701470ULL, 0x0000004ead00720cULL, 0x080fe40001741470ULL,
0x0000004eb300720cULL, 0x0c0fe40002781470ULL, 0x0000004eb300720cULL, 0x000fe40002fa1470ULL,
0x00000084c9bd7219ULL, 0x040fe400000006ffULL, 0x00000086c9c37219ULL, 0x000fc400000006ffULL,
0x0000004ea500720cULL, 0x0c0fe40001f61070ULL, 0x0000004ea500720cULL, 0x080fe40000f21070ULL,
0x0000004eab00720cULL, 0x0c0fe400037c1070ULL, 0x0000004eab00720cULL, 0x0c0fe40000701070ULL,
0x0000004eab00720cULL, 0x080fe40001741070ULL, 0x0000004eb100720cULL, 0x000fc40002781070ULL,
0x0000004eb100720cULL, 0x000fe40002fa1070ULL, 0x0000007ec9c97219ULL, 0x000fe400000006ffULL,
0x00005410cd887816ULL, 0x000fe40000000088ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000008087808ULL, 0x000fe40000800000ULL, 0xff80000042427808ULL, 0x000fc40003000000ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff80000009097808ULL, 0x000fe40001000000ULL,
0xff80000041417808ULL, 0x000fe40002000000ULL, 0xff8000003c3c7808ULL, 0x000fe40002800000ULL,
0x00000080bdff7212ULL, 0x080fe4000786c0ffULL, 0x00000080c3ff7212ULL, 0x000fc4000782c0ffULL,
0x00000080c9ff7212ULL, 0x000fe400078cc0ffULL, 0x00000088b7ff7212ULL, 0x080fe4000780c0ffULL,
0x00000088bdff7212ULL, 0x080fe4000784c0ffULL, 0x00000088c3ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008cbdff7212ULL, 0x000fe400078ac0ffULL, 0x0000004eb300720cULL, 0x000fc40000701470ULL,
0x0000004ebb00720cULL, 0x0c0fe40001f61470ULL, 0x0000004ebb00720cULL, 0x0c0fe40001741470ULL,
0x0000004ebb00720cULL, 0x080fe40002fa1470ULL, 0x0000004ec100720cULL, 0x080fe40000f21470ULL,
0x0000004ec700720cULL, 0x080fe400037c1470ULL, 0x0000004ec100720cULL, 0x000fc40002781470ULL,
0x0000004eb100720cULL, 0x080fe40000701070ULL, 0x0000004eb900720cULL, 0x0c0fe40001f61070ULL,
0x0000004eb900720cULL, 0x0c0fe40001741070ULL, 0x0000004eb900720cULL, 0x080fe40002fa1070ULL,
0x0000004ebf00720cULL, 0x080fe40000f21070ULL, 0x0000004ec500720cULL, 0x000fc400037c1070ULL,
0x0000004ebf00720cULL, 0x000fe40002781070ULL, 0x00005410d58e7816ULL, 0x000fe4000000008eULL,
0xff8000002e2e7808ULL, 0x000fe40000000000ULL, 0xff80000040407808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000037377808ULL, 0x000fc40002800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0xff8000003e3e7808ULL, 0x000fe40003000000ULL,
0xff8000003b3b7808ULL, 0x000fe40002000000ULL, 0x00000088c9ff7212ULL, 0x000fe4000780c0ffULL,
0x0000008cc3ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008cc9ff7212ULL, 0x000fc4000784c0ffULL,
0x0000008eb7ff7212ULL, 0x080fe400078ac0ffULL, 0x0000008ebdff7212ULL, 0x080fe4000782c0ffULL,
0x0000008ec3ff7212ULL, 0x080fe400078cc0ffULL, 0x0000008ec9ff7212ULL, 0x000fe4000788c0ffULL,
0x0000004eb300720cULL, 0x080fe40002fa1470ULL, 0x0000004ebb00720cULL, 0x000fc40000f21470ULL,
0x0000004ec100720cULL, 0x0c0fe40001f61470ULL, 0x0000004ec100720cULL, 0x080fe400037c1470ULL,
0x0000004ec700720cULL, 0x0c0fe40000701470ULL, 0x0000004ec700720cULL, 0x0c0fe40001741470ULL,
0x0000004ec700720cULL, 0x080fe40002781470ULL, 0x0000004eb100720cULL, 0x000fc40002fa1070ULL,
0x0000004eb900720cULL, 0x080fe40000f21070ULL, 0x0000004ec500720cULL, 0x080fe40000701070ULL,
0x0000004ebf00720cULL, 0x0c0fe40001f61070ULL, 0x0000004ebf00720cULL, 0x080fe400037c1070ULL,
0x0000004ec500720cULL, 0x0c0fe40001741070ULL, 0x0000004ec500720cULL, 0x000fc40002781070ULL,
0xff8000003a3a7808ULL, 0x000fe40000000000ULL, 0xff80000038387808ULL, 0x000fe40001800000ULL,
0xff80000039397808ULL, 0x000fe40001000000ULL, 0xff8000000a0a7808ULL, 0x000fe40002800000ULL,
0xff8000000b0b7808ULL, 0x000fe40000800000ULL, 0xff8000000c0c7808ULL, 0x000fc40003000000ULL,
0xff8000000d0d7808ULL, 0x000fc40002000000ULL, 0x0000004d0400720bULL, 0x004fe40003f1e000ULL,
0x000000280500720bULL, 0x000fe40003f3e000ULL, 0x000000290600720bULL, 0x000fe40003f5e000ULL,
0x0000001e0700720bULL, 0x000fe40003f7e000ULL, 0x000000044d4f7208ULL, 0x000fe40004000000ULL,
0x0000000528047208ULL, 0x000fc40004800000ULL, 0x0000000629057208ULL, 0x000fe40005000000ULL,
0x000000071e077208ULL, 0x000fe40005800000ULL, 0x000000464f00720bULL, 0x000fe40003f1e000ULL,
0x000000270400720bULL, 0x000fe40003f3e000ULL, 0x000000260500720bULL, 0x000fe40003f5e000ULL,
0x0000001c0700720bULL, 0x000fc40003f7e000ULL, 0x0000004f46067208ULL, 0x000fe40004000000ULL,
0x0000000427047208ULL, 0x000fe40004800000ULL, 0x0000000526057208ULL, 0x000fe40005000000ULL,
0x000000071c4e7208ULL, 0x000fe40005800000ULL, 0x0000004b0600720bULL, 0x000fe40003f1e000ULL,
0x000000250400720bULL, 0x000fc40003f3e000ULL, 0x000000240500720bULL, 0x000fe40003f5e000ULL,
0x000000194e00720bULL, 0x000fe40003f7e000ULL, 0x000000064b067208ULL, 0x000fe40004000000ULL,
0x0000000425047208ULL, 0x000fe40004800000ULL, 0x0000000524057208ULL, 0x000fe40005000000ULL,
0x0000004e19077208ULL, 0x000fc40005800000ULL, 0x000000470600720bULL, 0x000fe40003f1e000ULL,
0x000000230400720bULL, 0x000fe40003f3e000ULL, 0x000000220500720bULL, 0x000fe40003f5e000ULL,
0x000000180700720bULL, 0x000fe40003f7e000ULL, 0x00000006474f7208ULL, 0x000fe40004000000ULL,
0x0000000423047208ULL, 0x000fc40004800000ULL, 0x0000000522057208ULL, 0x000fe40005000000ULL,
0x0000000718067208ULL, 0x000fe40005800000ULL, 0x0000004c4f00720bULL, 0x000fe40003f1e000ULL,
0x000000210400720bULL, 0x000fe40003f3e000ULL, 0x000000200500720bULL, 0x000fe40003f5e000ULL,
0x000000130600720bULL, 0x000fc40003f7e000ULL, 0x0000004f4c4f7208ULL, 0x000fe40004000000ULL,
0x0000000421047208ULL, 0x000fe40004800000ULL, 0x00000005204e7208ULL, 0x000fe40005000000ULL,
0x0000000613057208ULL, 0x000fe40005800000ULL, 0x000000484f00720bULL, 0x000fe40003f1e000ULL,
0x0000001f0400720bULL, 0x000fc40003f3e000ULL, 0x0000001d4e00720bULL, 0x000fe40003f5e000ULL,
0x000000120500720bULL, 0x000fe40003f7e000ULL, 0x0000004f48067208ULL, 0x000fe40004000000ULL,
0x000000041f077208ULL, 0x000fe40004800000ULL, 0x0000004e1d4f7208ULL, 0x000fe40005000000ULL,
0x0000000512047208ULL, 0x000fc40005800000ULL, 0x000000450600720bULL, 0x000fe40003f1e000ULL,
0x0000002a0700720bULL, 0x000fe40003f3e000ULL, 0x000000304f00720bULL, 0x000fe40003f5e000ULL,
0x000000110400720bULL, 0x000fe40003f7e000ULL, 0x0000000645067208ULL, 0x000fe40004000000ULL,
0x000000072a077208ULL, 0x000fc40004800000ULL, 0x0000004f304e7208ULL, 0x000fe40005000000ULL,
0x0000000411047208ULL, 0x000fe40005800000ULL, 0x000000490600720bULL, 0x000fe40003f1e000ULL,
0x0000002c0700720bULL, 0x000fe40003f3e000ULL, 0x000000314e00720bULL, 0x000fe40003f5e000ULL,
0x0000000f0400720bULL, 0x000fc40003f7e000ULL, 0x0000000649057208ULL, 0x000fe40004000000ULL,
0x000000072c067208ULL, 0x000fe40004800000ULL, 0x0000004e31077208ULL, 0x000fe40005000000ULL,
0x000000040f4f7208ULL, 0x000fe40005800000ULL, 0x0000004a0500720bULL, 0x000fe40003f1e000ULL,
0x0000002b0600720bULL, 0x000fc40003f3e000ULL, 0x000000320700720bULL, 0x000fe40003f5e000ULL,
0x000000104f00720bULL, 0x000fe40003f7e000ULL, 0x000000054a057208ULL, 0x000fe40004000000ULL,
0x000000062b067208ULL, 0x000fe40004800000ULL, 0x0000000732047208ULL, 0x000fe40005000000ULL,
0x0000004f104f7208ULL, 0x000fc40005800000ULL, 0x000000440500720bULL, 0x000fe40003f1e000ULL,
0x0000003d0600720bULL, 0x000fe40003f3e000ULL, 0x000000330400720bULL, 0x000fe40003f5e000ULL,
0x0000000e4f00720bULL, 0x000fe40003f7e000ULL, 0x00000005444e7208ULL, 0x000fe40004000000ULL,
0x000000063d067208ULL, 0x000fc40004800000ULL, 0x0000000433057208ULL, 0x000fe40005000000ULL,
0x0000004f0e4f7208ULL, 0x000fe40005800000ULL, 0x000000434e00720bULL, 0x000fe40003f1e000ULL,
0x0000002d0600720bULL, 0x000fe40003f3e000ULL, 0x000000340500720bULL, 0x000fe40003f5e000ULL,
0x000000084f00720bULL, 0x000fc40003f7e000ULL, 0x0000004e43077208ULL, 0x000fe40004000000ULL,
0x000000062d517208ULL, 0x000fe40004800000ULL, 0x0000000534047208ULL, 0x000fe40005000000ULL,
0x0000004f08067208ULL, 0x000fe40005800000ULL, 0x000000420700720bULL, 0x000fe40003f1e000ULL,
0x000000365100720bULL, 0x000fc40003f3e000ULL, 0x000000350400720bULL, 0x000fe40003f5e000ULL,
0x000000090600720bULL, 0x000fe40003f7e000ULL, 0x00000007424e7208ULL, 0x000fe40004000000ULL,
0x0000005136517208ULL, 0x000fe40004800000ULL, 0x0000000435057208ULL, 0x000fe40005000000ULL,
0x0000000609077208ULL, 0x000fc40005800000ULL, 0x000000414e00720bULL, 0x000fe40003f1e000ULL,
0x0000002e5100720bULL, 0x000fe40003f3e000ULL, 0x0000003c0500720bULL, 0x000fe40003f5e000ULL,
0x0000000a0700720bULL, 0x000fe40003f7e000ULL, 0x0000004e414f7208ULL, 0x000fe40004000000ULL,
0x000000512e047208ULL, 0x000fc40004800000ULL, 0x000000053c067208ULL, 0x000fe40005000000ULL,
0x000000070a4e7208ULL, 0x000fe40005800000ULL, 0x0000002f0400720bULL, 0x000fe40003f3e000ULL,
0x000000404f00720bULL, 0x000fe40003f1e000ULL, 0x000000370600720bULL, 0x000fe40003f5e000ULL,
0x0000000b4e00720bULL, 0x000fc40003f7e000ULL, 0x000000042f047208ULL, 0x000fe40004800000ULL,
0x0000004f40507208ULL, 0x000fe40004000000ULL, 0x0000000637057208ULL, 0x000fe40005000000ULL,
0x0000004e0b077208ULL, 0x000fe40005800000ULL, 0x0000003b0400720bULL, 0x000fe40003f3e000ULL,
0x0000003f5000720bULL, 0x000fc40003f1e000ULL, 0x000000380500720bULL, 0x000fe40003f5e000ULL,
0x0000000c0700720bULL, 0x000fe40003f7e000ULL, 0x000000043b517208ULL, 0x000fe40004800000ULL,
0x000000503f4f7208ULL, 0x000fe40004000000ULL, 0x0000000538047208ULL, 0x000fe40005000000ULL,
0x000000070c067208ULL, 0x000fc40005800000ULL, 0x0000003e4f00720bULL, 0x000fe40003f1e000ULL,
0x0000003a5100720bULL, 0x000fe40003f3e000ULL, 0x000000390400720bULL, 0x000fe40003f5e000ULL,
0x0000000d0600720bULL, 0x000fe40003f7e000ULL, 0x0000004f3e077208ULL, 0x000fe40004000000ULL,
0x000000513a507208ULL, 0x000fc40004800000ULL, 0x0000000439547208ULL, 0x000fe40005000000ULL,
0x000000060d537208ULL, 0x000fe20005800000ULL, 0x000023827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704557208ULL, 0x000fe20004000000ULL, 0x000023b27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0050047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0054057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0053067f89ULL, 0x000e6200000e0000ULL, 0x000000045000720bULL, 0x008fc40003f1e000ULL,
0x000000055400720bULL, 0x010fe40003f3e000ULL, 0x0000005004077208ULL, 0x006fe40004000000ULL,
0x00000054054e7208ULL, 0x000fe20004800000ULL, 0x0c201f0055047f89ULL, 0x000e6200000e0000ULL,
0x000000065300720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007527f89ULL, 0x000ea200000e0000ULL,
0x0000005306507208ULL, 0x000fc60004000000ULL, 0x0c201f004e4f7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0050517f89ULL, 0x0002e400000e0000ULL, 0x000000045500720bULL, 0x002fe40003f1e000ULL,
0x000000520700720bULL, 0x004fe40003f3e000ULL, 0x0000005504047208ULL, 0x000fc40004000000ULL,
0x0000004f4e00720bULL, 0x008fe40003f5e000ULL, 0x0000000752057208ULL, 0x000fe40004800000ULL,
0x0000004e4f067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x000000515000720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x00000002ff597819ULL, 0x000fe20000011617ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b46467823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b45527823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b47477823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010807ULL,
0x0000004600467308ULL, 0x000e620000000800ULL, 0x3fb8aa3b4a457823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010807ULL, 0x00000048004f7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b41417823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b40407823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b3f3f7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b3e3e7823ULL, 0x000fe20000010807ULL,
0x00000047004e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b06077820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b05487820ULL, 0x004fe40000410000ULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b24247823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b22227823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b20207823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30307823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b32327823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b34347823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b35357823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b38387823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b39397823ULL, 0x000fe20000010807ULL, 0x0000005051077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010848ULL, 0x0000000317ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010848ULL, 0x0000004900497308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b07517820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe40000010848ULL,
0x3fb8aa3b28287823ULL, 0x000fc40000010848ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010848ULL,
0x00000023004a7308ULL, 0x0009e20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe40000010848ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe40000010848ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe40000010848ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fe20000010848ULL, 0x0000002e00577308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fc40000010851ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010851ULL,
0x3fb8aa3b19197823ULL, 0x100fe40000010851ULL, 0x3fb8aa3b18237823ULL, 0x010fe20000010851ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe40000010848ULL,
0x3fb8aa3b21217823ULL, 0x100fe40000010848ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fc40000010848ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010848ULL, 0x0000002c00477308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe40000010848ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe40000010848ULL,
0x3fb8aa3b3a3a7823ULL, 0x000fe40000010848ULL, 0x0000000859507824ULL, 0x040fe200078e00ffULL,
0x0000002b00537308ULL, 0x000fe20000000800ULL, 0x00000004ff187e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000859667824ULL, 0x000fc400078e00ffULL,
0x00000008595a7824ULL, 0x040fe200078e00ffULL, 0x3f8000001818783eULL, 0x000fe200000010ffULL,
0x00000008595b7824ULL, 0x000fe200078e00ffULL, 0x0000002d00557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010851ULL, 0x3fb8aa3b12127823ULL, 0x100fe40000010851ULL,
0x3fb8aa3b11117823ULL, 0x100fe40000010851ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fe20000010851ULL,
0x0000001c002e7308ULL, 0x0003e20000000800ULL, 0x000000ffff6a7224ULL, 0x000fc400078e0018ULL,
0x000000ffff6b7224ULL, 0x000fe400078e0018ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe40000010851ULL,
0x3fb8aa3b08087823ULL, 0x000fe20000010851ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000004d461c723eULL, 0x002fe200000010ffULL, 0x00000008594d7824ULL, 0x000fcc00078e00ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002f00587308ULL, 0x000ff00000000800ULL,
0x00000024002b7308ULL, 0x0005f00000000800ULL, 0x00000022002c7308ULL, 0x0006620000000800ULL,
0x000000292624723eULL, 0x004fce00000010ffULL, 0x0000001e002d7308ULL, 0x0005e20000000800ULL,
0x000000524922723eULL, 0x008fe400000010ffULL, 0x0000000559497810ULL, 0x000fca0007ffe0ffULL,
0x00000019002f7308ULL, 0x0007e20000000800ULL, 0x00000004591e7810ULL, 0x004fe40007ffe0ffULL,
0x0000002b2c26723eULL, 0x002fe200000010ffULL, 0x000000ffff2c7224ULL, 0x000fe200078e0018ULL,
0xfffffff85b687812ULL, 0x000fe400078ee21eULL, 0x0000004b4e1e723eULL, 0x000fe200000010ffULL,
0x0000002300467308ULL, 0x000e620000000800ULL, 0x000000ffff197224ULL, 0x008fe200078e0018ULL,
0x00000006594b7810ULL, 0x040fe20007ffe0ffULL, 0x00000008594e7824ULL, 0x000fca00078e00ffULL,
0x0000001d00487308ULL, 0x0005e20000000800ULL, 0xfffffff84e4e7812ULL, 0x000fce00078ee24bULL,
0x0000002a002a7308ULL, 0x000ee20000000800ULL, 0x00000001591d7810ULL, 0x004fc80007ffe0ffULL,
0xfffffff850507812ULL, 0x000fe400078ee21dULL, 0x00000002591d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001f00547308ULL, 0x0005e60000000800ULL, 0xfffffff85a5a7812ULL, 0x000fe400078ee21dULL,
0x00000028271d723eULL, 0x000fe400000010ffULL, 0x0000002f4627723eULL, 0x002fe200000010ffULL,
0x0000003d00567308ULL, 0x000fe20000000800ULL, 0x00000003591f7810ULL, 0x004fc40007ffe0ffULL,
0x0000002a4723723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b10477823ULL, 0x000fe20000010851ULL,
0xfffffff866667812ULL, 0x000fe400078ee21fULL, 0x000000254a1f723eULL, 0x000fe200000010ffULL,
0x00000020003d7308ULL, 0x000e620000000800ULL, 0x0000002d2e25723eULL, 0x000fe200000010ffULL,
0x000000ffff2d7224ULL, 0x000fc800078e0018ULL, 0x000000181c28723cULL, 0x000b6400000418ffULL,
0x0000001300137308ULL, 0x000fec0000000800ULL, 0x0000002c242c723cULL, 0x000f6400000418ffULL,
0x00000012004a7308ULL, 0x0005e20000000800ULL, 0x0000003d4810723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b0a3d7823ULL, 0x000fc40000010851ULL, 0x3fb8aa3b0b487823ULL, 0x000fe40000010851ULL,
0x000000ffff0a7224ULL, 0x100fe400078e0018ULL, 0x0000004c004c7308ULL, 0x000e620000000800ULL,
0xffffffff59127810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fc600078e0018ULL,
0xfffffff84d527812ULL, 0x000fc600078ee212ULL, 0x0000002100217308ULL, 0x000eb00000000800ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x0000004c4f20723eULL, 0x002fe200000010ffULL,
0x00000008594c7824ULL, 0x000fca00078e00ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee249ULL,
0x0000003100317308ULL, 0x000e620000000800ULL, 0x000000215421723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b0c497823ULL, 0x000fe20000010851ULL, 0x0000000859547810ULL, 0x000fca0007ffe0ffULL,
0x0000001100197308ULL, 0x0205e20000000800ULL, 0x0000006a2028723cULL, 0x000b6e0000041828ULL,
0x0000000f00467308ULL, 0x000ee20000000800ULL, 0x000000134a11723eULL, 0x004fe200000010ffULL,
0x00000008594a7824ULL, 0x000fe200078e00ffULL, 0x000000303112723eULL, 0x002fe200000010ffULL,
0x0000000854317824ULL, 0x000fe200078e00ffULL, 0x00000010596a7810ULL, 0x020fc40007ffe0ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee259ULL, 0x0000003600367308ULL, 0x000e620000000800ULL,
0x0000001859597810ULL, 0x000fe20007ffe0ffULL, 0x000000086a4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff831547812ULL, 0x000fc600078ee254ULL, 0x00000008590c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84b6a7812ULL, 0x000fe200078ee26aULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x000000194613723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b09197823ULL, 0x100fe20000010851ULL,
0x000000535609723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b0d517823ULL, 0x000fc80000010851ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x0000000a102c723cULL, 0x000b6e000004182cULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x00000055360b723eULL, 0x022fe400000010ffULL,
0xfffffff80c367812ULL, 0x000fca00078ee259ULL, 0x0000004400447308ULL, 0x000ff00000000800ULL,
0x0000004300437308ULL, 0x000ff00000000800ULL, 0x0000004200427308ULL, 0x000e700000000800ULL,
0x0000003200327308ULL, 0x000ff00000000800ULL, 0x0000003300337308ULL, 0x000ea20000000800ULL,
0x00000043420a723eULL, 0x002fce00000010ffULL, 0x0000004700477308ULL, 0x000ff00000000800ULL,
0x0000000e00307308ULL, 0x0002e20000000800ULL, 0x00000032330c723eULL, 0x004fce00000010ffULL,
0x00000008000f7308ULL, 0x0005e20000000800ULL, 0x00000034350e723eULL, 0x002fe200000010ffULL,
0x000000ffff347224ULL, 0x100fe400078e0018ULL, 0x000000ffff357224ULL, 0x000fc800078e0018ULL,
0x0000001900467308ULL, 0x0003220000000800ULL, 0x000000454408723eULL, 0x004fe400000010ffULL,
0x00000047300d723eULL, 0x008fca00000010ffULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x000000ffff197224ULL, 0x002fe200078e0018ULL, 0x0000000f460f723eULL, 0x010fcc00000010ffULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0x000000180830723cULL, 0x000b6e0000041828ULL,
0x0000003f003f7308ULL, 0x000fe20000000800ULL, 0x000000340c2c723cULL, 0x000be4000004182cULL,
0x000120001a197811ULL, 0x020fc400078e60ffULL, 0x000000575829723eULL, 0x000fc600000010ffULL,
0x000000104a4a7824ULL, 0x100fe200078e0219ULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x0000000c02357812ULL, 0x000fe200078ec0ffULL, 0x0000001050507824ULL, 0x100fe200078e0219ULL,
0x000000414028723eULL, 0x002fe200000010ffULL, 0x000000105a5a7824ULL, 0x100fe400078e0219ULL,
0x0000001066667824ULL, 0x100fe400078e0219ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000001068687824ULL, 0x000fc400078e0219ULL, 0x000000ffff407224ULL, 0x100fe400078e0018ULL,
0x000000ffff417224ULL, 0x000fe400078e0018ULL, 0x000000104c4c7824ULL, 0x100fe200078e0219ULL,
0x0000003a003a7308ULL, 0x000e620000000800ULL, 0x0000003f3e2a723eULL, 0x004fe200000010ffULL,
0x0000000135507824ULL, 0x040fe400078e0250ULL, 0x000000104e4e7824ULL, 0x000fe400078e0219ULL,
0x00000001355a7824ULL, 0x000fc400078e025aULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x0000001052527824ULL, 0x100fe400078e0219ULL, 0x0000000135667824ULL, 0x040fe400078e0266ULL,
0x0000001054547824ULL, 0x000fe400078e0219ULL, 0x0000000135687824ULL, 0x000fe200078e0268ULL,
0x0000003900397308ULL, 0x000ea20000000800ULL, 0x0000003b3a2b723eULL, 0x002fe200000010ffULL,
0x000000014a3b7824ULL, 0x000fc400078e0235ULL, 0x00000001354c7824ULL, 0x040fe400078e024cULL,
0x00000001354e7824ULL, 0x040fe200078e024eULL, 0x0000001c3b007388ULL, 0x0003e20000000800ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000402830723cULL, 0x000f620000041830ULL,
0x0000000135527824ULL, 0x040fe200078e0252ULL, 0x0000001e50007388ULL, 0x0003e20000000800ULL,
0x0000000135547824ULL, 0x000fe400078e0254ULL, 0x000000106a6a7824ULL, 0x000fe200078e0219ULL,
0x000000205a007388ULL, 0x0003e20000000800ULL, 0x0000003700377308ULL, 0x000ee20000000800ULL,
0x00000038393e723eULL, 0x004fe200000010ffULL, 0x000000ffff387224ULL, 0x100fe200078e0018ULL,
0x0000002266007388ULL, 0x0003e20000000800ULL, 0x000000ffff397224ULL, 0x000fc400078e0018ULL,
0x0000001036367824ULL, 0x000fe200078e0219ULL, 0x0000000868007388ULL, 0x0003e20000000800ULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0x0000000135197824ULL, 0x040fe400078e026aULL,
0x0000000a4c007388ULL, 0x0003e20000000800ULL, 0x0000000135367824ULL, 0x000fc600078e0236ULL,
0x000000284e007388ULL, 0x0003e20000000800ULL, 0x0000004800487308ULL, 0x000ea20000000800ULL,
0x0000003c373c723eULL, 0x008fe200000010ffULL, 0x000000ffff317224ULL, 0x020fe200078e0032ULL,
0x0000002a52007388ULL, 0x0003e80000000800ULL, 0x0000001d54007388ULL, 0x0003e20000000800ULL,
0x0000004900497308ULL, 0x000fe60000000800ULL, 0x0004001f50007388ULL, 0x0003e80000000800ULL,
0x000400215a007388ULL, 0x0003e20000000800ULL, 0x0000005100027308ULL, 0x000ee20000000800ULL,
0x0000003d483d723eULL, 0x004fc400000010ffULL, 0x0004002366007388ULL, 0x0003e80000000800ULL,
0x0004000968007388ULL, 0x0003e80000000800ULL, 0x0004000b4c007388ULL, 0x0003e80000000800ULL,
0x000400294e007388ULL, 0x0003e20000000800ULL, 0x00000049023f723eULL, 0x008fc600000010ffULL,
0x0004002b52007388ULL, 0x0003e80000000800ULL, 0x000000383c2c723cULL, 0x000f62000004182cULL,
0x0000002419007388ULL, 0x0003e80000000800ULL, 0x0008002650007388ULL, 0x0003e80000000800ULL,
0x000800105a007388ULL, 0x0003e80000000800ULL, 0x0008001266007388ULL, 0x0003e80000000800ULL,
0x0008000c68007388ULL, 0x0003e80000000800ULL, 0x0008000e4c007388ULL, 0x0003e60000000800ULL,
0x000000ffff327224ULL, 0x020fe200078e002cULL, 0x0008003c4e007388ULL, 0x0003e20000000800ULL,
0x000000ffff337224ULL, 0x000fc600078e002eULL, 0x0008003e52007388ULL, 0x0003e80000000800ULL,
0x0000002536007388ULL, 0x0003e80000000800ULL, 0x000c002750007388ULL, 0x0003e80000000800ULL,
0x000c00115a007388ULL, 0x0003e80000000800ULL, 0x000c001366007388ULL, 0x0003e80000000800ULL,
0x000c000d68007388ULL, 0x0003e80000000800ULL, 0x000c000f4c007388ULL, 0x0003e80000000800ULL,
0x000c003d4e007388ULL, 0x0003e80000000800ULL, 0x000c003f52007388ULL, 0x0003e80000000800ULL,
0x01a0000403008388ULL, 0x0003e80000000c00ULL, 0x01a2003003008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005eff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008005eff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010005eff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000160607810ULL, 0x000fe20007ffe0ffULL,
0x000018005eff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff5f7224ULL, 0x000fc400078e0067ULL,
0x000000156000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff7d2000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x002fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001c3c000267802ULL, 0x000fc40000000f00ULL, 0x000013f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0xfffe62f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005800000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001c42000267802ULL, 0x000fc40000000f00ULL, 0x0000139000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0025ULL, 0xfffe632000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001c48000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000012e000007944ULL, 0x004fea0003c00000ULL,
0xfffe63e000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001c4d000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000129000007944ULL, 0x006fea0003c00000ULL, 0xfffe650000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001c52000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000124000007944ULL, 0x00efea0003c00000ULL,
0xfffe662000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001c57000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000011f000007944ULL, 0x00efea0003c00000ULL, 0xfffe673000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001c5d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000119000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffe6b4000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001c63000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000113000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001002267810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001c69000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000010d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffe6ad000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001c6f000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000107000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffe6aa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001c75000267802ULL, 0x000fc40000000f00ULL,
0x0000106000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xfffe9a9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005800000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001c7b000267802ULL, 0x000fc40000000f00ULL,
0x0000100000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff707224ULL, 0x000fe200078e0025ULL,
0xfffe9ad000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001c81000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000f5000007944ULL, 0x004fea0003c00000ULL, 0xfffe9b9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001c86000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000f0000007944ULL, 0x006fea0003c00000ULL,
0xfffe9cb000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001c8b000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000eb000007944ULL, 0x00efea0003c00000ULL, 0xfffe9dd000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001c90000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000e6000007944ULL, 0x00efea0003c00000ULL,
0xfffe9ee000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001eULL,
0x0001c96000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000e0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffea2c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001c9c000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000da000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000101e267810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001ca2000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000d4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffea25000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001ca8000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffea22000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001cae000267802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffed13000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005800000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001cb4000267802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff717224ULL, 0x000fe200078e0025ULL, 0xfffed17000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001cba000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000bc000007944ULL, 0x002fea0003c00000ULL,
0xfffed23000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001cbf000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000b7000007944ULL, 0x002fea0003c00000ULL, 0xfffed35000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001cc4000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000b2000007944ULL, 0x002fea0003c00000ULL,
0xfffed47000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001cc9000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000ad000007944ULL, 0x002fea0003c00000ULL, 0xfffed58000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0001ccf000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000a7000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffed97000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001cd5000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000a1000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x000000106c267810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001cdb000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000009b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffed90000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001ce1000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000095000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffed8d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x004fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001ce7000267802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0025ULL,
0xffff06f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005800000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001ced000267802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff6f7224ULL, 0x000fe200078e0025ULL,
0xffff073000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001cf3000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000083000007944ULL, 0x008fea0003c00000ULL, 0xffff07f000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001cf8000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000007e000007944ULL, 0x00afea0003c00000ULL,
0xffff091000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001cfd000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000079000007944ULL, 0x00afea0003c00000ULL, 0xffff0a3000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001d02000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000074000007944ULL, 0x00afea0003c00000ULL,
0xffff0b4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0008ULL,
0x0001d08000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000006e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xffff0f3000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001d0e000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000068000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x0000001008267810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001d14000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000062000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xffff0ec000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001d1a000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xffff0e9000007947ULL, 0x000fea000383ffffULL,
0x00000002ff527424ULL, 0x000fe200078e00ffULL, 0x0001d210004e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff517424ULL, 0x000fc400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0051ULL,
0xffffdc2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e0050ULL,
0x0001d290004e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff527424ULL, 0x000fe400078e00ffULL,
0x0000001fff517424ULL, 0x000fe400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000515000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x0001d310004e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff527424ULL, 0x000fe200078e00ffULL, 0x0000005051067208ULL, 0x000fe20004000000ULL,
0x0000001fff517424ULL, 0x000fc400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000515400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0053ULL, 0x0001d390004e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff527424ULL, 0x000fe200078e00ffULL, 0x0000005451547208ULL, 0x000fe20004000000ULL,
0x0000001fff517424ULL, 0x000fe400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000515300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0055ULL, 0x0001d410004e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff527424ULL, 0x000fe200078e00ffULL, 0x0000005351507208ULL, 0x000fe20004000000ULL,
0x0000001fff517424ULL, 0x000fc400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000515500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x0001d490004e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff527424ULL, 0x000fe200078e00ffULL, 0x0000005551047208ULL, 0x000fe20004000000ULL,
0x0000001fff517424ULL, 0x000fe400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000510600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x0001d510004e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff527424ULL, 0x000fe200078e00ffULL, 0x0000000651057208ULL, 0x000fe20004000000ULL,
0x0000001fff517424ULL, 0x000fc400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000515400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0050ULL, 0x0001d590004e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff527424ULL, 0x000fe200078e00ffULL, 0x0000005451067208ULL, 0x000fe20004000000ULL,
0x0000001fff517424ULL, 0x000fe400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffda1000007947ULL, 0x000fea000383ffffULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000024027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe28e002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff4f7424ULL, 0x000fe200078e00ffULL, 0x0000005600007348ULL, 0x000fe80003800000ULL,
0x0c00005207517389ULL, 0x0002a200000e0051ULL, 0xfffe28a04e007950ULL, 0x000fea0003c3ffffULL,
0x0000006a00007348ULL, 0x000fe80003800000ULL, 0x0000002627267389ULL, 0x0002a400000e006bULL,
0x000000ffff6a7224ULL, 0x002fc400078e0025ULL, 0x00000000ff6b7424ULL, 0x000fc800078e00ffULL,
0xfffe28506a007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f65070ULL,
0x0000002700007348ULL, 0x000fd80003800000ULL, 0x0000000000257806ULL, 0x000fc800058e0100ULL,
0x0000002725257212ULL, 0x000fe200078ec0ffULL, 0x00000000ff277424ULL, 0x000fc800078e00ffULL,
0xfffe27f026007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x00000000000008a0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001678ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000167cULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001d900ULL, 0xfa00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001f180ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001f1c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001f540ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001678ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001db08ULL,
0x000000000001db08ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001f180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001f540ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_80_cubin_len = 128544;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
