/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001d7c0ULL, 0x000000000001d440ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001b810ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001b990ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001b9d0ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001ba20ULL, 0x0000000000000160ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001bb80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001b81000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x006c940400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001b81000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080840828ULL,
0x2880808608288080ULL, 0x8088082880808708ULL, 0x082880808c082880ULL, 0x80809f082880809dULL,
0xc108288080a50828ULL, 0x288080ea08288080ULL, 0x80f008288080ef08ULL, 0x08288080f1082880ULL,
0x80828016288080ceULL, 0x0000000000031028ULL, 0x288080ce92000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001b99000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080840828ULL,
0x2880808608288080ULL, 0x8088082880808708ULL, 0x082880808c082880ULL, 0x80809f082880809dULL,
0xc108288080a60828ULL, 0x288080ea08288080ULL, 0x80f008288080ef08ULL, 0x08288080f1082880ULL,
0x80828016288080a5ULL, 0x0000000000031028ULL, 0x288080a592000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001b9d000000000ULL, 0x0000005000000000ULL,
0x0000040400000000ULL, 0x80ea288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL, 0x8088082880808708ULL,
0x082880808c082880ULL, 0x80809f082880809dULL, 0xc108288080a50828ULL, 0x288080ea08288080ULL,
0x80f008288080ef08ULL, 0x08288080f1082880ULL, 0x80828016288080a6ULL, 0x0000000000031028ULL,
0x288080a692000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL,
0x0001ba2000000000ULL, 0x0000016000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000f2ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x0000001600080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500009ULL,
0x00000000000c1704ULL, 0x0021f00000480008ULL, 0x00000000000c1704ULL, 0x0011f00000400007ULL,
0x00000000000c1704ULL, 0x0061f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x019c290400000b00ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x019c2804ffffffffULL,
0x000002e000000110ULL, 0x000026d000000580ULL, 0x0000289000002780ULL, 0x00002b7000002a00ULL,
0x0000315000002cd0ULL, 0x000031a000003190ULL, 0x00006210000031d0ULL, 0x000063c0000062b0ULL,
0x000066a000006530ULL, 0x00006c5000006800ULL, 0x00006ca000006c90ULL, 0x00009c3000006cd0ULL,
0x00009de000009cd0ULL, 0x0000a0c000009f50ULL, 0x0000a6800000a220ULL, 0x0000a6d00000a6c0ULL,
0x0000d5800000a700ULL, 0x0000d7300000d620ULL, 0x0000da100000d8a0ULL, 0x0000dfd00000db70ULL,
0x0000e0200000e010ULL, 0x000104300000e050ULL, 0x0001045000010440ULL, 0x0001966000010460ULL,
0x000196b0000196a0ULL, 0x00019710000196c0ULL, 0x0001975000019730ULL, 0x0001ab9000019760ULL,
0x0001ac200001abe0ULL, 0x0001ac800001ac50ULL, 0x0001acf00001acb0ULL, 0x0001ad700001ad30ULL,
0x0001ae000001adb0ULL, 0x0001ae900001ae50ULL, 0x0001aef00001aec0ULL, 0x0001af600001af20ULL,
0x0001afe00001afa0ULL, 0x0001b0700001b020ULL, 0x0001b1000001b0c0ULL, 0x0001b1600001b130ULL,
0x0001b1d00001b190ULL, 0x0001b2500001b210ULL, 0x0001b2e00001b290ULL, 0x0001b3700001b330ULL,
0x0001b3d00001b3a0ULL, 0x0001b4400001b400ULL, 0x0001b4c00001b480ULL, 0x0001b5500001b500ULL,
0x0001b6100001b5b0ULL, 0x0001b6d00001b670ULL, 0x0001b7900001b730ULL, 0x044039040001b7f0ULL,
0x000000ff000003b0ULL, 0x003f010000012600ULL, 0x0000000b00000430ULL, 0x003f012000012608ULL,
0x0000000b000004f0ULL, 0x003f012000012688ULL, 0x0000000b00000520ULL, 0x003f0120000126a8ULL,
0x0000000b00000550ULL, 0x003f0120000126c8ULL, 0x000000ff00000b10ULL, 0x003f010700012600ULL,
0x0000001400000c70ULL, 0x003f01020001268cULL, 0x0000001400000d00ULL, 0x003f010100012688ULL,
0x000000ff00001630ULL, 0x0004010700000000ULL, 0x000000ff000016b0ULL, 0x0004010100000000ULL,
0x0000000200001710ULL, 0x003f010100000020ULL, 0x0000000800001880ULL, 0x003f0105000126ccULL,
0x0000000800001a50ULL, 0x003f0105000126ccULL, 0x0000001f00002270ULL, 0x003f0107000126b0ULL,
0x0000001f00002330ULL, 0x003f0101000126b0ULL, 0x0000001c00002390ULL, 0x003f010100012608ULL,
0x00000020000023d0ULL, 0x003f01050001260cULL, 0x00000020000025b0ULL, 0x003f01050001260cULL,
0x0000001f00002e80ULL, 0x003f0105000126acULL, 0x0000001f00003070ULL, 0x003f0105000126acULL,
0x0000006a00005430ULL, 0x003f010100000000ULL, 0x0000001f00005490ULL, 0x003f010100012688ULL,
0x0000000d000054c0ULL, 0x003f010500000004ULL, 0x0000000d00005680ULL, 0x003f010500000004ULL,
0x0000000800005dd0ULL, 0x003f010700000000ULL, 0x0000000800005eb0ULL, 0x003f010100000000ULL,
0x0000002000005f10ULL, 0x003f010100012628ULL, 0x0000002100005f70ULL, 0x003f01050001262cULL,
0x0000002100006140ULL, 0x003f01050001262cULL, 0x0000006a000069c0ULL, 0x003f0105000126b4ULL,
0x0000006a00006b90ULL, 0x003f0105000126b4ULL, 0x0000006a00008eb0ULL, 0x003f010100000000ULL,
0x0000002600008f10ULL, 0x003f010100012690ULL, 0x0000000d00008f40ULL, 0x003f010500000004ULL,
0x0000000d00009100ULL, 0x003f010500000004ULL, 0x000000ff00009880ULL, 0x0004010700000008ULL,
0x0000006800009910ULL, 0x003f0101000126b0ULL, 0x0000002000009970ULL, 0x003f010100012648ULL,
0x0000002000009990ULL, 0x003f01050001264cULL, 0x0000002000009b60ULL, 0x003f01050001264cULL,
0x000000080000a3e0ULL, 0x003f010500000004ULL, 0x000000080000a5b0ULL, 0x003f010500000004ULL,
0x0000006a0000c7d0ULL, 0x003f010100000000ULL, 0x000000230000c830ULL, 0x003f010100012698ULL,
0x0000000d0000c860ULL, 0x003f010500000004ULL, 0x0000000d0000ca20ULL, 0x003f010500000004ULL,
0x000000ff0000d1c0ULL, 0x0004010700000000ULL, 0x000000080000d270ULL, 0x003f010100000000ULL,
0x0000000c0000d2d0ULL, 0x003f010100012668ULL, 0x0000000c0000d300ULL, 0x003f01050001266cULL,
0x0000000c0000d4d0ULL, 0x003f01050001266cULL, 0x000000200000dd30ULL, 0x003f0105000126b4ULL,
0x000000200000df00ULL, 0x003f0105000126b4ULL, 0x0000000d00010180ULL, 0x003f010100000000ULL,
0x0000000800010200ULL, 0x003f010100000000ULL, 0x000000ff00011fd0ULL, 0x003f010100012600ULL,
0x000000ff00012b80ULL, 0x003f010500012604ULL, 0x000000ff00012d50ULL, 0x003f010500012604ULL,
0x000000ff000130d0ULL, 0x003f010100012600ULL, 0x000000ff00013100ULL, 0x003f010500012604ULL,
0x000000ff000132c0ULL, 0x003f010500012604ULL, 0x0000005d00016b20ULL, 0x003f010100000000ULL,
0x0000005d00016c50ULL, 0x003f010500000004ULL, 0x0000005d00016e20ULL, 0x003f010500000004ULL,
0x0000005e0001a9f0ULL, 0x003f010100000000ULL, 0x0000005e0001aa50ULL, 0x003f010100000008ULL,
0x0000005e0001aab0ULL, 0x003f010100000010ULL, 0x0000005e0001ab20ULL, 0x003f010100000018ULL,
0x00301c0400053803ULL, 0x000113e0000113b0ULL, 0x00011710000115b0ULL, 0x000119d000011870ULL,
0x00011c9000011b30ULL, 0x00011f2000011e20ULL, 0x0001ab6000013320ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL, 0x000000000000025cULL,
0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL, 0x00000000000000ccULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000303ULL,
0x0000001900000002ULL, 0x0000000000000233ULL, 0x0000001900000002ULL, 0x0000000000000173ULL,
0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL, 0x0000000000012700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0010777a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f280000002100ULL,
0x00000000000e7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff1a7819ULL, 0x010fc80000011607ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff1a1a7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000400031b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a1bULL,
0x0000040003007624ULL, 0x000fca00078e0210ULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x000000011b1b0810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x000000011b1b1810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff1baa12ULL, 0x000fc800078e33ffULL, 0x0000001b00007306ULL, 0x000e620000209000ULL,
0x000000ff1b00720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000031b047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603127227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a12ULL, 0x000000001b007224ULL, 0x000fca00078e0206ULL,
0x0000001b0000720cULL, 0x000fe20003f46070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000e6400000e0000ULL, 0x00000000020b7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003fa5270ULL, 0x0000000100002824ULL, 0x000fe200078e0a1bULL,
0x0000000112122810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000001b0000720cULL, 0x000fe40003f66070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL, 0xff317217ff088424ULL, 0x000fe400078e00ffULL,
0x0000000112123810ULL, 0x000fe20007ffe0ffULL, 0x01260002ff00d388ULL, 0x0005e20000000a00ULL,
0x0000001bff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f64070ULL, 0x012400080b008388ULL, 0x0007e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00005a0012187a19ULL, 0x000fe200000006ffULL,
0x000000ffff007224ULL, 0x000fc600078e0a12ULL, 0x012608040b009388ULL, 0x0009e20000008a00ULL,
0x000000001b1b7224ULL, 0x000fe400078e0206ULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x000000201b007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x0000000400087c10ULL, 0x048fe2000fffe1ffULL,
0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x3fffff80ff04a424ULL, 0x010fe200078e00ffULL, 0x0000002008087817ULL, 0x000fe20003800000ULL,
0x7fffff80ff05a424ULL, 0x000fe200078e00ffULL, 0x012688020b00a388ULL, 0x0005e40000008a00ULL,
0x000000ff08197207ULL, 0x000fe20000000000ULL, 0x0000000409087824ULL, 0x002fe200078e021aULL,
0x0126a8040b00a388ULL, 0x000fe40000008a00ULL, 0x000000201900780cULL, 0x000fe20003f05270ULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x0126c8060b00b388ULL, 0x000fe20000008a00ULL,
0x000058000e027a24ULL, 0x004fc800078e02ffULL, 0x0000007702027224ULL, 0x000fe200078e0218ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000819037217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x00000004ff047819ULL, 0x002fc80000011617ULL, 0x00000002040b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0204ULL, 0x000000030400720cULL, 0x080fe40003f06070ULL,
0x000000030b00720cULL, 0x000fe20003f26070ULL, 0x00000001080c7824ULL, 0x000fe400078e020bULL,
0x0000000100057824ULL, 0x040fe400078e020aULL, 0x00000001000d7824ULL, 0x000fe400078e020cULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000405077c12ULL, 0x000fc4000f8e30ffULL,
0x000000040d0f7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe20000011605ULL,
0x0000000102077824ULL, 0x040fe200078e0207ULL, 0x00005a00ff087a19ULL, 0x000fe2000001160dULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000007706047224ULL, 0x080fe400078e0207ULL,
0x0000001017027824ULL, 0x000fe400078e00ffULL, 0x0000007708067224ULL, 0x000fc400078e020fULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f002037812ULL, 0x000fc600078ec0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000304047212ULL, 0x000fc600078efcffULL,
0x000000010a087824ULL, 0x100fe200078e0217ULL, 0x0000000306037212ULL, 0x000fe200078efcffULL,
0x000000010c0a7824ULL, 0x000fe200078e0217ULL, 0x00005e0004047a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff00b087812ULL, 0x000fe400078ee208ULL,
0x00005e0003067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000001008037824ULL, 0x000fe200078e00ffULL, 0x00005f0005057a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e8000c101c48ULL,
0x00000000060b7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000817087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x00000010080c7824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011603ULL, 0x0000000108037824ULL, 0x000fe200078e0217ULL,
0x0000000406077c12ULL, 0x000fe2000f8e30ffULL, 0x0000000102057824ULL, 0x000fe200078e0205ULL,
0x00005a00ff067a19ULL, 0x000fe20000011606ULL, 0x000000010a087824ULL, 0x000fe200078e0217ULL,
0xfffffff00c037812ULL, 0x000fe200078ee203ULL, 0x0000000102077824ULL, 0x000fc400078e0207ULL,
0x0000007704047224ULL, 0x080fe400078e0205ULL, 0x0000001017027824ULL, 0x000fe400078e00ffULL,
0x0000007706067224ULL, 0x000fe400078e0207ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000f0020b7812ULL, 0x000fc600078ec0ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000b04047212ULL, 0x000fc600078efcffULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x0000000b06067212ULL, 0x000fe200078efcffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00005e0004047a10ULL, 0x000fe40007f1e0ffULL, 0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00b087812ULL, 0x000fe400078ee208ULL, 0x00005f0005057a10ULL, 0x000fe400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080b7824ULL, 0x000fc400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e8000b901c48ULL,
0x00000000060b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000037806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000300047300ULL, 0x000e7000000e0000ULL, 0x0000000300067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x00000004ff057424ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x004fe400078e0a06ULL, 0x000064000e047625ULL, 0x000fd000078e0005ULL,
0x01260406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01260000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000804167981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x000000ff16037810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff157819ULL, 0x000fce0000011603ULL, 0x000112f000008947ULL, 0x000fea0003800000ULL,
0x000000081a147824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01268c0514ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0300780cULL, 0x000fe20003f04070ULL,
0x000000020e007824ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe2000001161aULL,
0x0126880014ff7f8cULL, 0x0007e2000c80043fULL, 0x000000011a117812ULL, 0x000fe200078ec0ffULL,
0x0000590000057624ULL, 0x004fe400078e0210ULL, 0x0000002013747824ULL, 0x000fc400078e00ffULL,
0x0000000112127824ULL, 0x000fc800078e0205ULL, 0x0000660012007a24ULL, 0x000fe200078e0274ULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000007416037217ULL, 0x008fe20007800000ULL,
0x0000001011047824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc60000011617ULL,
0x0000000103037824ULL, 0x000fe200078e0a74ULL, 0x0000000405087810ULL, 0x040fe20007ffe0ffULL,
0x0000000104067824ULL, 0x002fe200078e0205ULL, 0x0000000c05097810ULL, 0x000fe40007ffe0ffULL,
0x0000000403037217ULL, 0x000fe20007800000ULL, 0x0000000106077824ULL, 0x040fe400078e0217ULL,
0x00000008060c7824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fc400078e0a04ULL,
0x00000001040a7824ULL, 0x000fe200078e0209ULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL,
0x0000000805077810ULL, 0x040fe20007ffe0ffULL, 0x00000001000d7824ULL, 0x040fe200078e020aULL,
0x000000030500720cULL, 0x080fe20003f66070ULL, 0x0000000100057824ULL, 0x000fe200078e0206ULL,
0x000000030800720cULL, 0x080fe20003f46070ULL, 0x0000000104087824ULL, 0x040fe200078e0208ULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x0000000104077824ULL, 0x000fe200078e0207ULL,
0x000000030900720cULL, 0x000fe20003f06070ULL, 0x0000008005047825ULL, 0x000fc800078e00ffULL,
0x0000000100067824ULL, 0x000fe200078e0208ULL, 0x00000070040b7812ULL, 0x000fe200078ef802ULL,
0x0000000108037824ULL, 0x040fe400078e0217ULL, 0x00000008080e7824ULL, 0x000fe400078e00ffULL,
0x0000000100087824ULL, 0x000fe400078e0207ULL, 0x0000000107097824ULL, 0x040fe200078e0217ULL,
0xfffffff80e007812ULL, 0x000fe200078ee203ULL, 0x0000000807107824ULL, 0x000fe200078e00ffULL,
0x0000e00013037811ULL, 0x000fe200078e68ffULL, 0x000000010a047824ULL, 0x000fc400078e0217ULL,
0x000000080a077824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe20007f9e0ffULL,
0x00000010000f7824ULL, 0x000fe200078e0203ULL, 0xfffffff8100e7812ULL, 0x000fe400078ee209ULL,
0xfffffff807107812ULL, 0x000fe400078ee204ULL, 0x00006300050b7a10ULL, 0x000fe200027fe4ffULL,
0x0000008006047825ULL, 0x000fc800078e00ffULL, 0x0000008008067825ULL, 0x000fe200078e00ffULL,
0x0000007004007812ULL, 0x000fc600078ef802ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0x0000007006047812ULL, 0x000fc600078ef802ULL, 0x000000100c0d7824ULL, 0x100fe200078e0203ULL,
0x0000007008067812ULL, 0x000fe200078ef802ULL, 0x000000100e1d7824ULL, 0x100fe200078e0203ULL,
0x0000620000027a10ULL, 0x000fe20007f9e0ffULL, 0x00000010101f7824ULL, 0x000fe200078e0203ULL,
0x0000620004047a10ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000d901c48ULL, 0x0000620006067a10ULL, 0x000fe40007fde0ffULL,
0x0000630005037a10ULL, 0x000fe400027fe4ffULL, 0x0000630007057a10ULL, 0x000fc40002ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200037fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000d101c48ULL,
0x00000000041d7faeULL, 0x0003e8000c901c48ULL, 0x00000000061f7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011047824ULL, 0x008fe200078e00ffULL,
0x0000e000131f7811ULL, 0x000fc800078e68ffULL, 0x0000000417037211ULL, 0x000fc800078fe8ffULL,
0x0000000403067810ULL, 0x042fe20007ffe0ffULL, 0x0000000103057824ULL, 0x040fe200078e0217ULL,
0x0000000c030a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008030c7824ULL, 0x040fe200078e00ffULL,
0x0000000803087810ULL, 0x000fe20007ffe0ffULL, 0x0000000100047824ULL, 0x040fe400078e0203ULL,
0x0000000100037824ULL, 0x000fe200078e0206ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000106077824ULL, 0x100fe200078e0217ULL,
0x00000070040b7812ULL, 0x000fe200078ef802ULL, 0x00000008060e7824ULL, 0x000fe400078e00ffULL,
0x00000001000d7824ULL, 0x000fe400078e020aULL, 0x000000010a047824ULL, 0x040fe400078e0217ULL,
0x000000080a0f7824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000100067824ULL, 0x000fe200078e0208ULL, 0xfffffff80e007812ULL, 0x000fe200078ee207ULL,
0x0000000108097824ULL, 0x040fe200078e0217ULL, 0xfffffff80f107812ULL, 0x000fe200078ee204ULL,
0x0000000808087824ULL, 0x000fe200078e00ffULL, 0x00006300050b7a10ULL, 0x000fe200007fe4ffULL,
0x0000008003047825ULL, 0x000fc600078e00ffULL, 0xfffffff8080e7812ULL, 0x000fe200078ee209ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000007004037812ULL, 0x000fc600078ef802ULL,
0x000000800d087825ULL, 0x000fe200078e00ffULL, 0x0000007006047812ULL, 0x000fc600078ef802ULL,
0x000000100c0d7824ULL, 0x100fe200078e021fULL, 0x0000007008067812ULL, 0x000fe200078ef802ULL,
0x00000010000f7824ULL, 0x100fe200078e021fULL, 0x0000620003027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100e1d7824ULL, 0x100fe200078e021fULL, 0x0000620004047a10ULL, 0x000fe20007f3e0ffULL,
0x00000010101f7824ULL, 0x000fe200078e021fULL, 0x0000620006067a10ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c48ULL,
0x0000630005037a10ULL, 0x000fe400007fe4ffULL, 0x0000630007057a10ULL, 0x000fc40000ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200017fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000b901c48ULL,
0x00000000041d7faeULL, 0x0003e8000b901c48ULL, 0x00000000061f7faeULL, 0x0003e4000b901c48ULL,
0x00000000130473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000126a813027811ULL, 0x002fe200078e18ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x000126a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x000000ffff557224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff207f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000ea8000008947ULL, 0x000fea0003800000ULL,
0x00000010130e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff107819ULL, 0x000fe2000001161aULL,
0x000000ffff007224ULL, 0x004fc400078e0003ULL, 0xff317217ff237424ULL, 0x000fe200078e00ffULL,
0x000000100e0e7812ULL, 0x000fe200078ee2ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x00afca00078e00ffULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x000000041a087824ULL, 0x000fca00078e00ffULL,
0xfffffff808087812ULL, 0x000fc800078ec0ffULL, 0x000126c8080d7810ULL, 0x000fe20007ffe0ffULL,
0x0126cc00080b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000001d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc00080b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f007810ULL, 0x040fe20007ffe0ffULL,
0x000001000f0c7824ULL, 0x000fc600078e0274ULL, 0x000000150000720cULL, 0x000fe40003f46070ULL,
0x000000400c037810ULL, 0x000fca0007ffe0ffULL, 0x0000660012087a24ULL, 0x000fcc00078e0203ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x00000003ff0a7819ULL, 0x000fe20000011617ULL,
0x00000010110b7824ULL, 0x000fe200078e00ffULL, 0x0000000316007217ULL, 0x000fe40007800000ULL,
0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b027824ULL, 0x040fe200078e020aULL,
0x0000000c0a207810ULL, 0x002fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x00000001021c7824ULL, 0x040fe400078e0217ULL, 0x0000000802277824ULL, 0x000fe200078e00ffULL,
0x000000000b007217ULL, 0x000fe20007800000ULL, 0x0000001017037824ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e0208ULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b1f7824ULL, 0x000fe200078e021dULL, 0x0000007003257812ULL, 0x000fe200078ec0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x000000000a00720cULL, 0x080fe40003fa6070ULL,
0x000000001c00720cULL, 0x080fe20003f86070ULL, 0x000000010b1e7824ULL, 0x040fe200078e021cULL,
0x00000025021c7212ULL, 0x000fe200078efcffULL, 0x000000010b227824ULL, 0x000fe200078e0220ULL,
0x000000001d00720cULL, 0x080fe20003f66070ULL, 0x000000011e0a7824ULL, 0x000fe200078e0208ULL,
0x000000002000720cULL, 0x000fe20003f06070ULL, 0x000000011e007824ULL, 0x000fe200078e0217ULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x00006300031d7a10ULL, 0x000fe200037fe4ffULL, 0x000000081e697824ULL, 0x000fe200078e00ffULL,
0x000000250a1e7212ULL, 0x080fe200078efcffULL, 0x000000011f027824ULL, 0x100fe400078e0208ULL,
0x00000001220a7824ULL, 0x000fe200078e0208ULL, 0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0xfffffff869697812ULL, 0x000fe400078ee200ULL,
0x0000f00013007811ULL, 0x000fe200078e68ffULL, 0x000000011f207824ULL, 0x040fe200078e0217ULL,
0x0000002502027212ULL, 0x000fe200078efcffULL, 0x000000081f6b7824ULL, 0x000fe200078e00ffULL,
0x000063000b1f7a10ULL, 0x000fe200037fe4ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000620002027a10ULL, 0x000fc40007fde0ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee220ULL,
0x0000000122087824ULL, 0x000fe200078e0217ULL, 0x000000250a0a7212ULL, 0x000fe200078efcffULL,
0x00000008226d7824ULL, 0x000fe200078e00ffULL, 0x0000630003037a10ULL, 0x000fe200037fe4ffULL,
0x0000001027257824ULL, 0x100fe200078e0200ULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001069277824ULL, 0x000fe200078e0200ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee208ULL,
0x000000106b697824ULL, 0x100fe200078e0200ULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c257faeULL, 0x0003e4000e901c48ULL,
0x000000106d6b7824ULL, 0x000fc400078e0200ULL, 0x000000001e277faeULL, 0x0003e8000e101c48ULL,
0x0000000002697faeULL, 0x0003e8000d901c48ULL, 0x000000000a6b7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001011007824ULL, 0x000fe400078e00ffULL,
0x0000001017027824ULL, 0x000fc600078e00ffULL, 0x0000000017007211ULL, 0x000fe400078fe8ffULL,
0x0000007002697812ULL, 0x000fe400078ec0ffULL, 0x0000000c001f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100037824ULL, 0x040fe200078e0217ULL, 0x00000008001d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008000a7824ULL, 0x040fe400078e00ffULL, 0x0000000100027824ULL, 0x000fe400078e0208ULL,
0x000000081f6d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a257812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x00000004000a7810ULL, 0x000fc60007ffe0ffULL,
0x000000011f1c7824ULL, 0x040fe200078e0208ULL, 0x00000069021e7212ULL, 0x000fe200078efcffULL,
0x000000011f027824ULL, 0x100fe400078e0217ULL, 0x000000010a0b7824ULL, 0x000fe200078e0217ULL,
0x000062001e1e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000080a207824ULL, 0x042fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee202ULL, 0x000000010a007824ULL, 0x100fe200078e0208ULL,
0x00006300031f7a10ULL, 0x000fe200007fe4ffULL, 0x000000011d0a7824ULL, 0x000fe200078e0208ULL,
0xfffffff820277812ULL, 0x000fe200078ee20bULL, 0x0000008000027825ULL, 0x000fc800078e00ffULL,
0x000000011d087824ULL, 0x040fe200078e0217ULL, 0x0000006902027212ULL, 0x080fe200078efcffULL,
0x000000081d6b7824ULL, 0x000fe400078e00ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000620002027a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee208ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000690a0a7212ULL, 0x000fe400078efcffULL,
0x0000f00013087811ULL, 0x000fc400078e68ffULL, 0x000000691c1c7212ULL, 0x000fe400078efcffULL,
0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001025257824ULL, 0x100fe200078e0208ULL,
0x000062001c1c7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001027277824ULL, 0x100fe200078e0208ULL,
0x0000630003037a10ULL, 0x000fe200007fe4ffULL, 0x000000106b697824ULL, 0x100fe200078e0208ULL,
0x000063000b0b7a10ULL, 0x000fe20001ffe4ffULL, 0x000000106d6b7824ULL, 0x000fe200078e0208ULL,
0x000063001d1d7a10ULL, 0x000fe200027fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e257faeULL, 0x0003e8000b901c48ULL, 0x0000000002277faeULL, 0x0003e8000b901c48ULL,
0x000000000a697faeULL, 0x0003e8000b901c48ULL, 0x000000001c6b7faeULL, 0x0003e4000b901c48ULL,
0xfffffff0141f7812ULL, 0x042fe400078ec0ffULL, 0xffffffe014007812ULL, 0x000fc400078ec0ffULL,
0x000000001f0573c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001014037812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fc800078e0203ULL,
0x00000008111c7824ULL, 0x000fe200078e0200ULL, 0x000126b005057890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126b0001f687f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012608001c1c7f8cULL, 0x000ee4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x00000008140b7812ULL, 0x000fca00078ec0ffULL,
0x0000000100207824ULL, 0x000fca00078e020bULL, 0x01260c00200b7984ULL, 0x000f240000000800ULL,
0x800000000bff7812ULL, 0x018fe4000780481dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a02257210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140bULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000200007819ULL, 0x000fc8000000120bULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01260c00200b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x008fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010170b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x000000201a007824ULL, 0x000fe400078e00ffULL,
0xffffffffff757424ULL, 0x000fe200078e00ffULL, 0x000000700b0b7812ULL, 0x000fc400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000000a007210ULL, 0x000fca0007ffe00bULL, 0x0120000000027984ULL, 0x000ee80000000800ULL,
0x0122000000037984ULL, 0x0002a20000000800ULL, 0x000000230200720bULL, 0x008fe20003f1d000ULL,
0x000184a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x002fc800000e0100ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x000fc400078e0023ULL,
0x0000001fff797424ULL, 0x000fe400078e00ffULL, 0xffffffffff767424ULL, 0x000fca00078e00ffULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x0000001a1000720cULL, 0x000fe40003f05270ULL,
0x000000230200720bULL, 0x000fe20003f74000ULL, 0x000184427f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x00000023021e7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x0124001e25008388ULL, 0x0003e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x000000231e087221ULL, 0x002fe20000010100ULL, 0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x0000000800277308ULL, 0x000e640000000800ULL, 0x0000002724247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000183827f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000182427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00066400000e0000ULL, 0x0000002666667220ULL, 0x086fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000181027f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x00017fd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001d00ff7212ULL, 0x000fda00078030ffULL,
0x8000001e02020221ULL, 0x000fe20000010000ULL, 0x00007610ff220816ULL, 0x000fc60000000022ULL,
0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL, 0x0000000200090308ULL, 0x000e640000000800ULL,
0x0000000903030220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002403247221ULL, 0x004fc40000010000ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x0126ac001f007984ULL, 0x000e620000000800ULL, 0x000126a81f087810ULL, 0x000fe40007ffe0ffULL,
0x8000000000ff7812ULL, 0x002fe20007804821ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c02237210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001141dULL,
0x0000002300007211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x0000000200007819ULL, 0x000fc8000000121dULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126ac001f007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991022007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff027819ULL, 0x000fe40000011617ULL, 0x0000541000277816ULL, 0x008fe20000000000ULL,
0x00017b827f007947ULL, 0x000fea000b800000ULL, 0x00001f0227077589ULL, 0x0002a400000e0000ULL,
0x0000000802267810ULL, 0x000fe20007ffe0ffULL, 0x00017ba27f007947ULL, 0x000fea000b800000ULL,
0x0000001002007810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0027057589ULL, 0x0006a400000e0000ULL, 0x0000001802267810ULL, 0x008fe20007ffe0ffULL,
0x00017bd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000413227824ULL, 0x000fe200078e00ffULL,
0x0000000817007812ULL, 0x000fe200078ec0ffULL, 0x000004001a1d7824ULL, 0x000fe200078e00ffULL,
0x00000004ff267819ULL, 0x108fe20000011617ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000422227812ULL, 0x000fe200078ec0ffULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000000700037812ULL, 0x000fe200078ef817ULL, 0x00000004111f7824ULL, 0x000fe200078e0226ULL,
0x0000002217007211ULL, 0x000fc400078fe0ffULL, 0x0000001003027812ULL, 0x042fe200078efcffULL,
0x0000000803217824ULL, 0x040fe400078e00ffULL, 0x00000001031c7824ULL, 0x000fe400078e0200ULL,
0x0000000100007824ULL, 0x000fe400078e0202ULL, 0x0000000802237824ULL, 0x000fe200078e00ffULL,
0xfffffff8211c7812ULL, 0x000fe200078ee21cULL, 0x00000008036a7824ULL, 0x000fe200078e00ffULL,
0xfffff0001d217812ULL, 0x000fc400078ec0ffULL, 0xfffffff8231d7812ULL, 0x000fe200078ee200ULL,
0x0000000103237824ULL, 0x000fe200078e021fULL, 0x0000a00021217810ULL, 0x000fe40007ffe0ffULL,
0x0000e00013007811ULL, 0x000fe400078e68ffULL, 0xfffffff86a257812ULL, 0x000fe200078ee223ULL,
0x000000101c707824ULL, 0x100fe200078e0221ULL, 0x0000000223237810ULL, 0x000fe20007ffe0ffULL,
0x000000101d6c7824ULL, 0x000fe400078e0221ULL, 0x0000001025257824ULL, 0x000fc400078e0200ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000006c6c783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707231ULL, 0x086fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x000000056c6c7231ULL, 0x088fe400003400ffULL,
0x000000056e6e7231ULL, 0x000fe400003400ffULL, 0x000000046d6d7231ULL, 0x080fe400003400ffULL,
0x000000046f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000002580783bULL, 0x000f220000004200ULL, 0xfffffff86a237812ULL, 0x000fe200078ee223ULL,
0x00000001021f7824ULL, 0x000fe200078e021fULL, 0x0000105000007945ULL, 0x000fe60003800000ULL,
0x0000001023237824ULL, 0x000fca00078e0200ULL, 0x00000000237c783bULL, 0x000ee20000004200ULL,
0x00000100807b7824ULL, 0x010fe200078e00ffULL, 0x00000080006a7306ULL, 0x000fe20000009400ULL,
0x0000010081917824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011480ULL,
0x0000010083a67824ULL, 0x040fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000010082a37824ULL, 0x000fe200078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011491ULL,
0x0001000083af7824ULL, 0x000fe200078e00ffULL, 0x0000007b008f7306ULL, 0x000fe20000209400ULL,
0x00000018ff9e7819ULL, 0x000fe20000011481ULL, 0x000001007cb77824ULL, 0x008fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fc400000114a6ULL, 0x00000018ffa37819ULL, 0x000fe400000114a3ULL,
0x00000018ffa77819ULL, 0x000fe20000011482ULL, 0x0000007b00907306ULL, 0x0007220000205400ULL,
0x00000018ffaf7819ULL, 0x000fe400000114afULL, 0x00000018ffb77819ULL, 0x000fe400000114b7ULL,
0x00000018ffb27819ULL, 0x000fe40000011483ULL, 0x00000018ffb97819ULL, 0x000fe2000001147cULL,
0x00000080006b7306ULL, 0x000ea20000005400ULL, 0x0000007b007b7245ULL, 0x008fc4000020d400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001147dULL, 0x00000018ff277819ULL, 0x000fe4000001147eULL,
0x00000018ff787819ULL, 0x000fe2000001147fULL, 0x00000080007a7306ULL, 0x000662000000d400ULL,
0x000000908f00720bULL, 0x010fce0003fdd000ULL, 0x00000099009a7306ULL, 0x000fe20000209400ULL,
0x0001000080807824ULL, 0x008fe200078e00ffULL, 0x0000006b6a00720bULL, 0x004fe20003fbd000ULL,
0x000001007d6a7824ULL, 0x000fe200078e00ffULL, 0x00000099006b7245ULL, 0x000fe4000020d400ULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x00000099009b7306ULL, 0x000ea20000205400ULL,
0x000000017b7b6812ULL, 0x000fcc00078efcffULL, 0x000000017a7a5812ULL, 0x002fe200078efcffULL,
0x0000008100967306ULL, 0x000ff00000009400ULL, 0x0000008100977306ULL, 0x000e620000005400ULL,
0x0000009b9a00720bULL, 0x004fc40003f7d000ULL, 0x00000018ff9a7819ULL, 0x000fca000001146aULL,
0x0000008100987306ULL, 0x0004ec000000d400ULL, 0x000000016b6b3812ULL, 0x000fe400078efcffULL,
0x0000008000917306ULL, 0x000fe20000209400ULL, 0x0001000081817824ULL, 0x004fe200078e00ffULL,
0x000000979600720bULL, 0x002fc80003f9d000ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x0000008000927306ULL, 0x0002ae0000205400ULL, 0x0000000198984812ULL, 0x008fe200078efcffULL,
0x00000081009c7306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fc4000020d400ULL,
0x000000986b6b723eULL, 0x000fca00000010ffULL, 0x00000081009d7306ULL, 0x0002e20000205400ULL,
0x000000929100720bULL, 0x004fe20003fdd000ULL, 0x000100007d927824ULL, 0x000fcc00078e00ffULL,
0x0000009300947306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x0000009300957306ULL, 0x0002a20000205400ULL,
0x0000009d9c00720bULL, 0x008fce0003f7d000ULL, 0x0000008200a17306ULL, 0x000fe20000009400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x0000008200a27306ULL, 0x000e620000005400ULL, 0x000000959400720bULL, 0x004fe40003fbd000ULL,
0x00000018ff947819ULL, 0x000fe40000011492ULL, 0x000000b900927245ULL, 0x000fc6000020d400ULL,
0x0000009e009f7306ULL, 0x000fec0000209400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x0000009e00a07306ULL, 0x0004e20000205400ULL, 0x000000a2a100720bULL, 0x002fce0003fdd000ULL,
0x000000ac00ad7306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x004fce000020d400ULL,
0x000000ac00ae7306ULL, 0x0002a20000205400ULL, 0x000000a09f00720bULL, 0x008fce0003f9d000ULL,
0x00000082008e7306ULL, 0x000722000000d400ULL, 0x000000ac00ac7245ULL, 0x002fca000020d400ULL,
0x000000019e9e4812ULL, 0x000fe400078efcffULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x0001000082827824ULL, 0x008fe200078e00ffULL, 0x000000aead00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x000000a300a57306ULL, 0x0002a20000205400ULL,
0x000000018e8e6812ULL, 0x010fcc00078efcffULL, 0x00000001acac3812ULL, 0x000fe200078efcffULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fce000020d400ULL,
0x000000a700a97306ULL, 0x0002e20000205400ULL, 0x000000a5a400720bULL, 0x004fce0003fbd000ULL,
0x0000008300aa7306ULL, 0x000fe20000009400ULL, 0x000000a700a77245ULL, 0x002fca000020d400ULL,
0x00000001a3a35812ULL, 0x000fe400078efcffULL, 0x0000008300ab7306ULL, 0x000e620000005400ULL,
0x000000a9a800720bULL, 0x008fce0003fdd000ULL, 0x000000af00b07306ULL, 0x000fec0000209400ULL,
0x00000001a7a76812ULL, 0x000fe400078efcffULL, 0x000000af00b17306ULL, 0x0004e20000205400ULL,
0x000000abaa00720bULL, 0x002fce0003f9d000ULL, 0x00000083008d7306ULL, 0x000e62000000d400ULL,
0x000000af00af7245ULL, 0x004fce000020d400ULL, 0x0000008200a67306ULL, 0x000fe20000209400ULL,
0x000000b1b000720bULL, 0x008fce0003f7d000ULL, 0x0000008200837306ULL, 0x0004e20000205400ULL,
0x000000018d8d4812ULL, 0x002fca00078efcffULL, 0x00000001afaf3812ULL, 0x000fe400078efcffULL,
0x000000b700b87306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x004fce000020d400ULL,
0x000000b7008f7306ULL, 0x000e620000205400ULL, 0x00000083a600720bULL, 0x008fe20003fbd000ULL,
0x000001007e837824ULL, 0x000fca00078e00ffULL, 0x00000018ff977819ULL, 0x000fe20000011483ULL,
0x000000b200b37306ULL, 0x000fe20000209400ULL, 0x000001007f837824ULL, 0x000fca00078e00ffULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x000000b200b47306ULL, 0x0004e20000205400ULL,
0x0000008fb800720bULL, 0x002fe40003fdd000ULL, 0x00000018ff9b7819ULL, 0x000fe40000011483ULL,
0x0000009a008f7245ULL, 0x000fc6000020d400ULL, 0x0000007c00b57306ULL, 0x000fe20000009400ULL,
0x000000b200b27245ULL, 0x004fce000020d400ULL, 0x0000007c00b67306ULL, 0x000e620000005400ULL,
0x000000b4b300720bULL, 0x008fce0003f9d000ULL, 0x0000007c00877306ULL, 0x0004ec000000d400ULL,
0x00000001b2b24812ULL, 0x000fe400078efcffULL, 0x0000009a00907306ULL, 0x000fe20000209400ULL,
0x000100007c7c7824ULL, 0x004fe200078e00ffULL, 0x000000b6b500720bULL, 0x002fc80003fbd000ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000009a00917306ULL, 0x000e640000205400ULL,
0x0000007c00837245ULL, 0x000fca000020d400ULL, 0x0000000187875812ULL, 0x008fe200078efcffULL,
0x0000007d00bc7306ULL, 0x000ff00000009400ULL, 0x0000007d00bd7306ULL, 0x000ea20000005400ULL,
0x000000919000720bULL, 0x002fc40003f7d000ULL, 0x000000b700907245ULL, 0x000fc8000020d400ULL,
0x0000000190906812ULL, 0x000fe200078efcffULL, 0x0000007d00867306ULL, 0x000e6c000000d400ULL,
0x000000018f8f3812ULL, 0x000fe400078efcffULL, 0x0000007c006a7306ULL, 0x000fe20000209400ULL,
0x000000bdbc00720bULL, 0x004fce0003f9d000ULL, 0x0000007c007d7306ULL, 0x0004ec0000205400ULL,
0x0000000186864812ULL, 0x002fe400078efcffULL, 0x000000b900ba7306ULL, 0x000fe20000209400ULL,
0x0000008ea37c723eULL, 0x004fce00000010ffULL, 0x000000b900bb7306ULL, 0x000e620000205400ULL,
0x0000007d6a00720bULL, 0x008fe40003fdd000ULL, 0x0000007a7b6a723eULL, 0x000fe400000010ffULL,
0x00000080937a723eULL, 0x000fe400000010ffULL, 0x0000009400937245ULL, 0x000fe2000020d400ULL,
0x0000009400957306ULL, 0x000fe20000209400ULL, 0x0000008dac7d723eULL, 0x000fe200000010ffULL,
0x0000006a7064723cULL, 0x000f620000041864ULL, 0x000000819e7b723eULL, 0x000fc400000010ffULL,
0x000000868f81723eULL, 0x000fe400000010ffULL, 0x0000000183836812ULL, 0x000fe200078efcffULL,
0x0000009400967306ULL, 0x000ea20000205400ULL, 0x000000bbba00720bULL, 0x002fe20003fbd000ULL,
0x0000006a6c44723cULL, 0x000b620000041844ULL, 0x0000009b00867245ULL, 0x000fe4000020d400ULL,
0x000000879080723eULL, 0x000fc600000010ffULL, 0x0000008c00be7306ULL, 0x000fe20000209400ULL,
0x00000008026a7824ULL, 0x020fe200078e00ffULL, 0x0000007a7060723cULL, 0x040f680000041860ULL,
0x0000000192925812ULL, 0x000fe400078efcffULL, 0x0000008c00bf7306ULL, 0x0002e20000205400ULL,
0x000000969500720bULL, 0x004fe20003fdd000ULL, 0x0000007c705c723cULL, 0x000f62000004185cULL,
0x000000839292723eULL, 0x000fca00000010ffULL, 0x0000007e00c07306ULL, 0x000fe20000009400ULL,
0x0000008c008c7245ULL, 0x002fe2000020d400ULL, 0x000000807054723cULL, 0x000f680000041854ULL,
0x0000000193936812ULL, 0x000fe400078efcffULL, 0x0000007e00c17306ULL, 0x000e620000005400ULL,
0x000000bfbe00720bULL, 0x008fe20003f9d000ULL, 0x0000007a6c40723cULL, 0x040f6c0000041840ULL,
0x0000009700997306ULL, 0x000fe40000209400ULL, 0x0000007c6c3c723cULL, 0x000f68000004183cULL,
0x000000018c8c4812ULL, 0x000fc400078efcffULL, 0x00000097009c7306ULL, 0x000ea20000205400ULL,
0x000000c1c000720bULL, 0x002fe20003f7d000ULL, 0x000000806c34723cULL, 0x000f620000041834ULL,
0x000000938c93723eULL, 0x000fca00000010ffULL, 0x0000007f008b7306ULL, 0x000fe40000009400ULL,
0x000000927050723cULL, 0x080f6c0000041850ULL, 0x0000007f008a7306ULL, 0x000e620000005400ULL,
0x0000009c9900720bULL, 0x004fe20003fbd000ULL, 0x000000926c30723cULL, 0x000f6c0000041830ULL,
0x0000009b009d7306ULL, 0x000ff00000209400ULL, 0x0000009b00a07306ULL, 0x000ea20000205400ULL,
0x0000008a8b00720bULL, 0x002fce0003fdd000ULL, 0x0000007e00237306ULL, 0x0002f0000000d400ULL,
0x0000007f00257306ULL, 0x0008e2000000d400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x000000a09d00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff917819ULL, 0x000fe4000001147eULL,
0x0000002700887306ULL, 0x000fe20000209400ULL, 0x000100007f7f7824ULL, 0x010fe200078e00ffULL,
0x00000082a77e723eULL, 0x000fe400000010ffULL, 0x0000009700827245ULL, 0x000fe4000020d400ULL,
0x00000018ff967819ULL, 0x000fe4000001147fULL, 0x0000002700897306ULL, 0x000e620000205400ULL,
0x0000000182825812ULL, 0x000fc400078efcffULL, 0x0000000123233812ULL, 0x008fe400078efcffULL,
0x0000000186864812ULL, 0x000fe400078efcffULL, 0x0000000125256812ULL, 0x000fe200078efcffULL,
0x0000007800857306ULL, 0x000fe20000209400ULL, 0x000000238282723eULL, 0x000fe400000010ffULL,
0x0000000222237812ULL, 0x000fe400078efcffULL, 0x000000258683723eULL, 0x000fe200000010ffULL,
0x0000000803257824ULL, 0x000fe200078e00ffULL, 0x000000afb27f723eULL, 0x000fe200000010ffULL,
0x0000007800847306ULL, 0x0004e20000205400ULL, 0x000000898800720bULL, 0x002fe20003fbd000ULL,
0x0000000126237824ULL, 0x000fc400078e0223ULL, 0x0000000802267824ULL, 0x040fe200078e00ffULL,
0x00000082704c723cULL, 0x040f62000004184cULL, 0x0000000103227824ULL, 0x100fe400078e0223ULL,
0x00000091009a7306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x004fe2000020d400ULL,
0x0000000102237824ULL, 0x000fe200078e0223ULL, 0xfffffff825227812ULL, 0x000fe400078ee222ULL,
0x0000007e7058723cULL, 0x080f640000041858ULL, 0xfffffff826267812ULL, 0x000fe200078ee223ULL,
0x0000009100957306ULL, 0x0002a20000205400ULL, 0x000000848500720bULL, 0x008fe20003f7d000ULL,
0x0000001022227824ULL, 0x100fe200078e0221ULL, 0x0000002700847245ULL, 0x000fe2000020d400ULL,
0x0000001026267824ULL, 0x000fe200078e0221ULL, 0x0000009600857245ULL, 0x000fe2000020d400ULL,
0x0000007e6c38723cULL, 0x000f620000041838ULL, 0x0000000184845812ULL, 0x000fe200078efcffULL,
0x00000096008d7306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x002fc4000020d400ULL,
0xfffffff86a217812ULL, 0x000fe400078ee21fULL, 0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000826c2c723cULL, 0x000f62000004182cULL, 0x0000000178783812ULL, 0x000fe200078efcffULL,
0x00000096008a7306ULL, 0x000e620000205400ULL, 0x000000959a00720bULL, 0x004fe20003f9d000ULL,
0x0000001021217824ULL, 0x000fd800078e0200ULL, 0x0000000191914812ULL, 0x000fe400078efcffULL,
0x0000008a8d00720bULL, 0x002fe40003fdd000ULL, 0x000000918484723eULL, 0x000fd600000010ffULL,
0x0000000185856812ULL, 0x000fc800078efcffULL, 0x000000857885723eULL, 0x000fce00000010ffULL,
0x000000847048723cULL, 0x080b640000041848ULL, 0x000000002270783bULL, 0x0202ac0000000200ULL,
0x000000846c28723cULL, 0x000b640000041828ULL, 0x00000000266c783bULL, 0x0202e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707231ULL, 0x084fe400003400ffULL, 0x0000000772727231ULL, 0x000fc400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fe400003400ffULL,
0x000000056c6c7231ULL, 0x088fe400003400ffULL, 0x000000056e6e7231ULL, 0x000fe400003400ffULL,
0x000000046d6d7231ULL, 0x080fe400003400ffULL, 0x000000046f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000002180783bULL, 0x000f220000004200ULL,
0xfffffff86a1f7812ULL, 0x000fca00078ee21fULL, 0x000000101f1f7824ULL, 0x000fca00078e0200ULL,
0x000000001f7c783bULL, 0x000e620000004200ULL, 0x0000010080277824ULL, 0x010fe200078e00ffULL,
0x0000008000227306ULL, 0x002fe20000009400ULL, 0x00000018ff8f7819ULL, 0x000fe20000011480ULL,
0x00000100818d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011481ULL,
0x00000100829f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000010083a27824ULL, 0x040fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe2000001148dULL,
0x0000008000237306ULL, 0x000e620000005400ULL, 0x00000018ff9f7819ULL, 0x000fe2000001149fULL,
0x0001000083ab7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a2ULL,
0x000001007dbb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe20000011482ULL,
0x000001007cb37824ULL, 0x000fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x00000027008b7306ULL, 0x000fe20000209400ULL, 0x00000018ffae7819ULL, 0x000fc40000011483ULL,
0x00000018ffbb7819ULL, 0x000fe400000114bbULL, 0x00000018ffb67819ULL, 0x000fe4000001147cULL,
0x00000018ff6a7819ULL, 0x000fe2000001147eULL, 0x00000027008c7306ULL, 0x0008e20000205400ULL,
0x000000232200720bULL, 0x002fe40003f9d000ULL, 0x0000009500237245ULL, 0x000fe4000020d400ULL,
0x00000018ff257819ULL, 0x000fc4000001147fULL, 0x00000018ffb37819ULL, 0x000fe200000114b3ULL,
0x0000008000267306ULL, 0x0002a2000000d400ULL, 0x0000002700277245ULL, 0x010fe4000020d400ULL,
0x00000018ff867819ULL, 0x000fca000001147dULL, 0x0000008100927306ULL, 0x000fe20000009400ULL,
0x0001000080807824ULL, 0x002fe200078e00ffULL, 0x0000008c8b00720bULL, 0x008fe20003fdd000ULL,
0x000100007d8c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x0000008100937306ULL, 0x000e620000005400ULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x0000000126264812ULL, 0x004fc800078efcffULL, 0x0000000127276812ULL, 0x000fe200078efcffULL,
0x0000008f00907306ULL, 0x000ff00000209400ULL, 0x0000008f00917306ULL, 0x0004e20000205400ULL,
0x000000939200720bULL, 0x002fe20003f1d000ULL, 0x000001007e927824ULL, 0x000fc400078e00ffULL,
0x000100007e937824ULL, 0x000fc600078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011492ULL,
0x00000080008d7306ULL, 0x000fe20000209400ULL, 0x0000008f008f7245ULL, 0x004fce000020d400ULL,
0x00000080008e7306ULL, 0x0002a20000205400ULL, 0x000000919000720bULL, 0x008fce0003fbd000ULL,
0x0000008100947306ULL, 0x000722000000d400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x000000018f8f5812ULL, 0x000fe400078efcffULL, 0x0000009a009b7306ULL, 0x000fe20000209400ULL,
0x0000008e8d00720bULL, 0x004fe20003fdd000ULL, 0x0001000081817824ULL, 0x008fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000009a009c7306ULL, 0x0002a20000205400ULL,
0x0000000194940812ULL, 0x010fca00078efcffULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x0000009500967306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fce000020d400ULL,
0x0000009500977306ULL, 0x000e620000205400ULL, 0x0000009c9b00720bULL, 0x004fce0003f1d000ULL,
0x0000009f00a07306ULL, 0x000fec0000209400ULL, 0x000000019a9a0812ULL, 0x000fe400078efcffULL,
0x0000009f00a17306ULL, 0x0004e20000205400ULL, 0x000000979600720bULL, 0x002fe20003f7d000ULL,
0x000001007f967824ULL, 0x000fc400078e00ffULL, 0x000100007f977824ULL, 0x000fc600078e00ffULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x004fe4000020d400ULL, 0x00000018ff977819ULL, 0x000fc60000011497ULL,
0x0000000123233812ULL, 0x000fe400078efcffULL, 0x000000a800aa7306ULL, 0x0002a20000205400ULL,
0x000000a1a000720bULL, 0x008fe40003fdd000ULL, 0x000000942323723eULL, 0x000fca00000010ffULL,
0x00000082009d7306ULL, 0x000fe20000009400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x00000082009e7306ULL, 0x000e620000005400ULL,
0x000000aaa900720bULL, 0x004fce0003fbd000ULL, 0x0000008200887306ULL, 0x0004ec000000d400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000008300a67306ULL, 0x000fe20000009400ULL,
0x0001000082827824ULL, 0x004fe200078e00ffULL, 0x0000009e9d00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x0000008300a77306ULL, 0x000fee0000005400ULL,
0x0000000188884812ULL, 0x008fe200078efcffULL, 0x0000008300877306ULL, 0x000ff0000000d400ULL,
0x000000a300a47306ULL, 0x000ff00000209400ULL, 0x000000a300a57306ULL, 0x0002b00000205400ULL,
0x0000008100987306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fce000020d400ULL,
0x0000008100997306ULL, 0x0002e20000205400ULL, 0x000000a5a400720bULL, 0x004fce0003fdd000ULL,
0x0000008200a27306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x0000008200837306ULL, 0x000e620000205400ULL,
0x000000999800720bULL, 0x008fce0003f7d000ULL, 0x000000ab00ac7306ULL, 0x000fec0000209400ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x000000ab00ad7306ULL, 0x000ea20000205400ULL,
0x00000083a200720bULL, 0x002fe40003f1d000ULL, 0x000000a7a600720bULL, 0x000fca0003f7d000ULL,
0x0000007c00b17306ULL, 0x000ff00000009400ULL, 0x0000007c00b27306ULL, 0x000fe20000005400ULL,
0x000000adac00720bULL, 0x004fe40003fbd000ULL, 0x0000000187873812ULL, 0x000fca00078efcffULL,
0x0000007d00b97306ULL, 0x000ff00000009400ULL, 0x0000007d00ba7306ULL, 0x000ff00000005400ULL,
0x000000bb00bc7306ULL, 0x000ff00000209400ULL, 0x000000bb008b7306ULL, 0x000e700000205400ULL,
0x0000007c00787306ULL, 0x0004f0000000d400ULL, 0x0000007e00bd7306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x004fe200078e00ffULL, 0x0000008bbc00720bULL, 0x002fc40003fdd000ULL,
0x00000018ff8b7819ULL, 0x000fe40000011493ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007e00be7306ULL, 0x000ff00000005400ULL, 0x0000007e001f7306ULL, 0x0003f0000000d400ULL,
0x0000007f00bf7306ULL, 0x000fe20000009400ULL, 0x00000082007e7245ULL, 0x002fc4000020d400ULL,
0x000000bb00827245ULL, 0x000fe4000020d400ULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x000000b2b100720bULL, 0x000fe20003f1d000ULL, 0x0000007f00c07306ULL, 0x000fe20000005400ULL,
0x0000000182826812ULL, 0x000fe400078efcffULL, 0x0000007ea37e723eULL, 0x000fca00000010ffULL,
0x0000007f00217306ULL, 0x0003e8000000d400ULL, 0x0000000178780812ULL, 0x008fc800078efcffULL,
0x0000007d006b7306ULL, 0x000ea2000000d400ULL, 0x000000ab007f7245ULL, 0x002fc8000020d400ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x000000bab900720bULL, 0x000fe20003fbd000ULL,
0x000000ae00af7306ULL, 0x000ff00000209400ULL, 0x000000ae00b07306ULL, 0x0002e80000205400ULL,
0x000000016b6b5812ULL, 0x004fc800078efcffULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fce000020d400ULL, 0x000000b600b87306ULL, 0x000e620000205400ULL,
0x000000b0af00720bULL, 0x008fce0003f9d000ULL, 0x000000b300b47306ULL, 0x000fec0000209400ULL,
0x00000001aeae4812ULL, 0x000fe400078efcffULL, 0x000000b300b57306ULL, 0x0004e20000205400ULL,
0x000000b8b700720bULL, 0x002fe40003f1d000ULL, 0x000000bebd00720bULL, 0x000fc40003f9d000ULL,
0x0000007fae7f723eULL, 0x000fc600000010ffULL, 0x0000007c00227306ULL, 0x000fe20000209400ULL,
0x000000b300b37245ULL, 0x004fc6000020d400ULL, 0x0000007e7058723cULL, 0x080f680000041858ULL,
0x0000007c007d7306ULL, 0x000e620000205400ULL, 0x000000b5b400720bULL, 0x008fe40003f7d000ULL,
0x000000011f1f4812ULL, 0x000fe200078efcffULL, 0x0000007e6c38723cULL, 0x000f680000041838ULL,
0x0000008c008d7306ULL, 0x000fec0000209400ULL, 0x00000001b3b33812ULL, 0x000fc400078efcffULL,
0x0000008c008e7306ULL, 0x0004e20000205400ULL, 0x0000007d2200720bULL, 0x002fe40003fdd000ULL,
0x000000262722723eULL, 0x000fe400000010ffULL, 0x000000808f26723eULL, 0x000fe400000010ffULL,
0x000000819a27723eULL, 0x000fe200000010ffULL, 0x00000086008a7306ULL, 0x000fe20000209400ULL,
0x0000007c00807245ULL, 0x000fe2000020d400ULL, 0x000000227064723cULL, 0x000f620000041864ULL,
0x000000b600817245ULL, 0x000fc4000020d400ULL, 0x0000008c008c7245ULL, 0x004fe4000020d400ULL,
0x0000000180806812ULL, 0x000fe200078efcffULL, 0x0000008600897306ULL, 0x000e620000205400ULL,
0x0000008e8d00720bULL, 0x008fe20003fbd000ULL, 0x000000267060723cULL, 0x000f620000041860ULL,
0x0000000181810812ULL, 0x000fe400078efcffULL, 0x000000c0bf00720bULL, 0x000fe40003f7d000ULL,
0x000000889f7c723eULL, 0x000fe200000010ffULL, 0x0000009200837306ULL, 0x000fe20000209400ULL,
0x000000808180723eULL, 0x000fe200000010ffULL, 0x000000226c44723cULL, 0x000f620000041844ULL,
0x00000087a87d723eULL, 0x000fc600000010ffULL, 0x000000018c8c5812ULL, 0x000fe400078efcffULL,
0x0000009200907306ULL, 0x0004e20000205400ULL, 0x000000898a00720bULL, 0x002fe20003fdd000ULL,
0x0000007c705c723cULL, 0x000f62000004185cULL, 0x0000000121213812ULL, 0x000fca00078efcffULL,
0x0000009600957306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x004fe2000020d400ULL,
0x000000266c40723cULL, 0x040f6c0000041840ULL, 0x0000009600987306ULL, 0x0002a20000205400ULL,
0x000000908300720bULL, 0x008fe20003f1d000ULL, 0x0000007c6c3c723cULL, 0x000f62000004183cULL,
0x0000008600837245ULL, 0x000fc8000020d400ULL, 0x0000000183836812ULL, 0x000fe200078efcffULL,
0x0000006a007a7306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fe4000020d400ULL,
0x0000008c8381723eULL, 0x000fc600000010ffULL, 0x0000000192920812ULL, 0x000fe400078efcffULL,
0x0000006a00857306ULL, 0x0002e20000205400ULL, 0x000000989500720bULL, 0x004fe20003fbd000ULL,
0x000000807050723cULL, 0x000f620000041850ULL, 0x0000001f9292723eULL, 0x000fe200000010ffULL,
0x000000021a1f7824ULL, 0x000fc800078e00ffULL, 0x0000002500847306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x002fe2000020d400ULL, 0x000000806c30723cULL, 0x000f620000041830ULL,
0xfffffff81f1f7812ULL, 0x000fc600078ec0ffULL, 0x0000000196965812ULL, 0x000fe400078efcffULL,
0x00000025007b7306ULL, 0x000e620000205400ULL, 0x000000857a00720bULL, 0x008fe40003fdd000ULL,
0x00000078b37a723eULL, 0x000fe400000010ffULL, 0x000000219693723eULL, 0x000fe400000010ffULL,
0x0000002500787245ULL, 0x000fe2000020d400ULL, 0x0000008b00917306ULL, 0x000fe80000209400ULL,
0x00000092704c723cULL, 0x000f64000004184cULL, 0x000000016a6a6812ULL, 0x000fc400078efcffULL,
0x0000008b008e7306ULL, 0x0004e20000205400ULL, 0x0000007b8400720bULL, 0x002fe40003f1d000ULL,
0x0000006b827b723eULL, 0x000fe200000010ffULL, 0x000000926c2c723cULL, 0x000f62000004182cULL,
0x00000097006b7245ULL, 0x000fc6000020d400ULL, 0x0000009700897306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x004fc6000020d400ULL, 0x0000007a7054723cULL, 0x000f640000041854ULL,
0x0000000178780812ULL, 0x000fe400078efcffULL, 0x0000009700887306ULL, 0x000e620000205400ULL,
0x0000008e9100720bULL, 0x008fc60003f9d000ULL, 0x0000007a6c34723cULL, 0x000f740000041834ULL,
0x000000018b8b4812ULL, 0x000fc400078efcffULL, 0x000000888900720bULL, 0x002fe40003fbd000ULL,
0x0000008b6a6a723eULL, 0x000fd600000010ffULL, 0x000000016b6b5812ULL, 0x000fc800078efcffULL,
0x0000006b786b723eULL, 0x000fce00000010ffULL, 0x0000006a7048723cULL, 0x080f700000041848ULL,
0x0000006a6c28723cULL, 0x000b6e0000041828ULL, 0x000126c8136a7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012688001fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff217224ULL, 0x000fc600078e00ffULL, 0x0000000000227805ULL, 0x000fc80000015200ULL,
0x000004000d1f7984ULL, 0x004ea40000000800ULL, 0x800000001fff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e23ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000121217810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000800c217810ULL, 0x000fca0007ffe0ffULL,
0x0000660012257a24ULL, 0x000fe200078e0221ULL, 0x000003d00000a947ULL, 0x000fea0003800000ULL,
0x00000021161f7217ULL, 0x000fe20007800000ULL, 0x00000010116e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x000fc60000011617ULL, 0x000000011f1f7824ULL, 0x000fe200078e0a21ULL,
0x00000004276b7810ULL, 0x040fe20007ffe0ffULL, 0x000000016e227824ULL, 0x040fe200078e0227ULL,
0x00000008276d7810ULL, 0x040fe40007ffe0ffULL, 0x0000001f6e1f7217ULL, 0x000fe20007800000ULL,
0x0000000122217824ULL, 0x040fe200078e0217ULL, 0x0000000c276f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000822267824ULL, 0x000fe400078e00ffULL, 0x000000016e707824ULL, 0x000fc400078e026bULL,
0x0000000122227824ULL, 0x000fe200078e0225ULL, 0xfffffff826217812ULL, 0x000fe200078ee221ULL,
0x000000011f1f7824ULL, 0x000fe400078e0a6eULL, 0x0000000170267824ULL, 0x000fe400078e0225ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000001f2700720cULL, 0x080fe40003f06070ULL,
0x0000001f6b00720cULL, 0x000fe20003f86070ULL, 0x000000016e727824ULL, 0x000fe200078e026dULL,
0x0000000b226c7212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000001f6d00720cULL, 0x000fc40003f66070ULL, 0x000062006c6c7a10ULL, 0x000fe20007fbe0ffULL,
0x00000001726a7824ULL, 0x000fe200078e0225ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x000000016e6e7824ULL, 0x000fe200078e026fULL, 0x00006300236d7a10ULL, 0x000fe20002ffe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe40007fde0ffULL,
0x0000001f6f00720cULL, 0x000fe20003fa6070ULL, 0x000000016e227824ULL, 0x000fe200078e0225ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x0000000170257824ULL, 0x000fe200078e0217ULL,
0x0000630027277a10ULL, 0x000fe200037fe4ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x000062006a6a7a10ULL, 0x000fc60007fde0ffULL, 0x0000000870707824ULL, 0x000fe200078e00ffULL,
0x0000000b22227212ULL, 0x000fe200078efcffULL, 0x00000001721f7824ULL, 0x040fe200078e0217ULL,
0x000063006b6b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000872727824ULL, 0x000fe200078e00ffULL,
0xfffffff870257812ULL, 0x000fe200078ee225ULL, 0x000000016e6f7824ULL, 0x000fe200078e0217ULL,
0x0000620022227a10ULL, 0x000fe20007fde0ffULL, 0x000000086e6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8721f7812ULL, 0x000fe200078ee21fULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0x0000630023237a10ULL, 0x000fe200037fe4ffULL, 0x0000001025257824ULL, 0x100fe200078e0200ULL,
0xfffffff86e6f7812ULL, 0x000fe200078ee26fULL, 0x000000101f1f7824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c217faeULL, 0x0003e6000c101c48ULL,
0x000000106f6f7824ULL, 0x000fe200078e0200ULL, 0x0000000026257faeULL, 0x0003e8000e101c48ULL,
0x000000006a1f7faeULL, 0x0003e8000d901c48ULL, 0x00000000226f7faeULL, 0x0003e2000e901c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001011227824ULL, 0x000fca00078e00ffULL,
0x0000002217267211ULL, 0x000fc800078fe8ffULL, 0x00000004266a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001261f7824ULL, 0x140fe200078e0217ULL, 0x00000008266c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000826227824ULL, 0x000fe400078e00ffULL, 0x000000016a217824ULL, 0x040fe400078e0217ULL,
0x000000086a6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8221f7812ULL, 0x000fe200078ee21fULL,
0x000000016c237824ULL, 0x040fe400078e0217ULL, 0x000000086c707824ULL, 0x000fe200078e00ffULL,
0xfffffff86e217812ULL, 0x000fe200078ee221ULL, 0x0000000126227824ULL, 0x140fe200078e0225ULL,
0x0000000c266e7810ULL, 0x000fe20007ffe0ffULL, 0x000000016a267824ULL, 0x000fe200078e0225ULL,
0xfffffff8706f7812ULL, 0x000fe200078ee223ULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x000000016c6a7824ULL, 0x100fe200078e0225ULL, 0x0000000b22227212ULL, 0x000fe200078efcffULL,
0x000000016e6c7824ULL, 0x000fe400078e0225ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fc60007f1e0ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000630023237a10ULL, 0x000fe200007fe4ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000000b6a6a7212ULL, 0x080fe400078efcffULL,
0x0000620026267a10ULL, 0x000fe20007f7e0ffULL, 0x000000016e257824ULL, 0x000fe200078e0217ULL,
0x0000000b6c6c7212ULL, 0x000fe200078efcffULL, 0x000000086e6e7824ULL, 0x000fe200078e00ffULL,
0x000062006a6a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0200ULL,
0x000062006c6c7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0xfffffff86e257812ULL, 0x000fe200078ee225ULL, 0x000000106f6f7824ULL, 0x100fe200078e0200ULL,
0x0000630027277a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000221f7faeULL, 0x0003e2000b901c48ULL, 0x000063006b6b7a10ULL, 0x000fe200007fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0x000063006d6d7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026217faeULL, 0x0003e8000b901c48ULL, 0x000000006a6f7faeULL, 0x0003e8000b901c48ULL,
0x000000006c257faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000080503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01262800206a7f8cULL, 0x000664000c80043fULL,
0x0000000000227805ULL, 0x000fc40000015200ULL, 0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL,
0x0000001014267812ULL, 0x000fca00078ec0ffULL, 0x000000011f267824ULL, 0x000fc800078e0226ULL,
0x0000000811217824ULL, 0x000fca00078e0226ULL, 0x01262c00211f7984ULL, 0x000f240000000800ULL,
0x800000001fff7812ULL, 0x012fe4000780486bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e23ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01262c00211f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a1f7824ULL, 0x000fca00078e00ffULL,
0xffffff801f227812ULL, 0x000fc800078ec0ffULL, 0x000000800b1f7810ULL, 0x000fca0007ffe022ULL,
0x000000010a1f7824ULL, 0x000fca00078e021fULL, 0x012000001f217984ULL, 0x000e680000000800ULL,
0x012200001f227984ULL, 0x0006a20000000800ULL, 0x0000001e2100720bULL, 0x002fe20003f1d000ULL,
0x00014bd27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001f7806ULL, 0x008fc800000e0100ULL,
0x000000ff1f00720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e001eULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000110237810ULL, 0x000fe40007ffe0ffULL,
0x0000001e2100720bULL, 0x000fe40003f74000ULL, 0x0000001a2300720cULL, 0x000fe20003f05270ULL,
0x00014b827f007947ULL, 0x000fd4000b800000ULL, 0x0000000000707806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x0000001e21237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a268824ULL, 0x000fca00078e0225ULL,
0x0124002326008388ULL, 0x0003e20000000800ULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001e231e7221ULL, 0x002fe20000010100ULL,
0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e00277308ULL, 0x000e640000000800ULL,
0x0000002724247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x00014ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x000149827f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00066400000e0000ULL,
0x0000002666667220ULL, 0x086fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x000148427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000070ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x000147127f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000701fff7212ULL, 0x000fda00078030ffULL, 0x8000002321210221ULL, 0x000fe20000010000ULL,
0x00007610ff6e0816ULL, 0x000fc6000000006eULL, 0x3fb8aa3b21210820ULL, 0x000fc80000410000ULL,
0x0000002100090308ULL, 0x000e640000000800ULL, 0x0000000922220220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002422247221ULL, 0x004fc20000010000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL,
0x0126b4006a217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x008fcc0000015200ULL, 0x000000261e227210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e1fULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc80000011426ULL,
0x0000002221217211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0626ULL,
0x0000000221217819ULL, 0x000fc80000001222ULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4006a217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106e1e7816ULL, 0x000fc800000000ffULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff1e7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x008fe20000000004ULL,
0x000142f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e27077589ULL, 0x0002a400000e0000ULL,
0x000000081e267810ULL, 0x000fe20007ffe0ffULL, 0x000143127f007947ULL, 0x000fea000b800000ULL,
0x000000101e047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000181e267810ULL, 0x008fe20007ffe0ffULL,
0x000143427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x000000041a1e7824ULL, 0x042fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a217824ULL, 0x040fe200078e00ffULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x000010001a1f7824ULL, 0x000fe200078e00ffULL, 0x000000041e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000803267824ULL, 0x008fe200078e00ffULL, 0xfffff00021217812ULL, 0x000fe200078ec0ffULL,
0x0000000803277824ULL, 0x000fe200078e00ffULL, 0x0000001e171e7211ULL, 0x000fc400078fe0ffULL,
0x0000b00021217810ULL, 0x000fe40007ffe0ffULL, 0xffffe0001f227812ULL, 0x000fe200078ec0ffULL,
0x00000001031f7824ULL, 0x000fe400078e021eULL, 0x000000101c707824ULL, 0x100fe200078e0221ULL,
0x0000f00022257810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0221ULL,
0xfffffff8261c7812ULL, 0x000fe400078ee21fULL, 0x000000021f227810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000e640000000200ULL, 0x000000101c807824ULL, 0x000fc400078e0225ULL,
0x000000001d68783bULL, 0x0006a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707231ULL, 0x086fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fe400003400ffULL,
0x0000000568687231ULL, 0x080fe400003400ffULL, 0x000000056a6a7231ULL, 0x000fc400003400ffULL,
0x0000000469697231ULL, 0x080fe400003400ffULL, 0x000000046b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000008080783bULL, 0x000f220000004200ULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x0000108000007945ULL, 0x000fe80003800000ULL,
0x00000010227c7824ULL, 0x000fcc00078e0225ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000100806f7824ULL, 0x010fe200078e00ffULL, 0x0000008000267306ULL, 0x000fe20000009400ULL,
0x00000100818f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011480ULL,
0x0000010083a47824ULL, 0x040fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x0000010082a17824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe2000001148fULL,
0x0001000083ad7824ULL, 0x000fe200078e00ffULL, 0x0000006f008d7306ULL, 0x000fe20000209400ULL,
0x00000018ff9c7819ULL, 0x000fc40000011481ULL, 0x00000018ffaa7819ULL, 0x000fe200000114a4ULL,
0x000001007cb57824ULL, 0x008fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe40000011482ULL,
0x00000018ffa17819ULL, 0x000fe200000114a1ULL, 0x0000006f008e7306ULL, 0x0007220000205400ULL,
0x00000018ffad7819ULL, 0x000fe400000114adULL, 0x00000018ffb07819ULL, 0x000fe40000011483ULL,
0x00000018ffb57819ULL, 0x000fc400000114b5ULL, 0x00000018ffb77819ULL, 0x000fe2000001147cULL,
0x0000008000277306ULL, 0x000ea20000005400ULL, 0x0000006f006f7245ULL, 0x008fe4000020d400ULL,
0x00000018ff8a7819ULL, 0x000fe4000001147dULL, 0x00000018ff787819ULL, 0x000fe4000001147eULL,
0x00000018ff257819ULL, 0x000fe2000001147fULL, 0x00000080006e7306ULL, 0x000662000000d400ULL,
0x0000008e8d00720bULL, 0x010fce0003fdd000ULL, 0x0000009700987306ULL, 0x000fe20000209400ULL,
0x0001000080807824ULL, 0x008fe200078e00ffULL, 0x000000272600720bULL, 0x004fe20003fbd000ULL,
0x000001007d267824ULL, 0x000fe200078e00ffULL, 0x0000009700277245ULL, 0x000fe4000020d400ULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000009700997306ULL, 0x000ea20000205400ULL,
0x000000016f6f6812ULL, 0x000fcc00078efcffULL, 0x000000016e6e5812ULL, 0x002fe200078efcffULL,
0x0000008100947306ULL, 0x000ff00000009400ULL, 0x0000008100957306ULL, 0x000e620000005400ULL,
0x000000999800720bULL, 0x004fc40003f7d000ULL, 0x00000018ff987819ULL, 0x000fca0000011426ULL,
0x0000008100967306ULL, 0x0004ec000000d400ULL, 0x0000000127273812ULL, 0x000fe400078efcffULL,
0x00000080008f7306ULL, 0x000fe20000209400ULL, 0x0001000081817824ULL, 0x004fe200078e00ffULL,
0x000000959400720bULL, 0x002fc80003f9d000ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x0000008000907306ULL, 0x0002ae0000205400ULL, 0x0000000196964812ULL, 0x008fe200078efcffULL,
0x00000081009a7306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fc4000020d400ULL,
0x000000962727723eULL, 0x000fca00000010ffULL, 0x00000081009b7306ULL, 0x0002e20000205400ULL,
0x000000908f00720bULL, 0x004fe20003fdd000ULL, 0x000100007d907824ULL, 0x000fcc00078e00ffULL,
0x00000082009f7306ULL, 0x000fe20000009400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x0000008200a07306ULL, 0x000e620000005400ULL,
0x0000009b9a00720bULL, 0x008fce0003f7d000ULL, 0x0000009c009d7306ULL, 0x000fec0000209400ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000009c009e7306ULL, 0x0004e20000205400ULL,
0x000000a09f00720bULL, 0x002fce0003fdd000ULL, 0x0000009100927306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x004fce000020d400ULL, 0x0000009100937306ULL, 0x0002a20000205400ULL,
0x0000009e9d00720bULL, 0x008fce0003f9d000ULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x002fca000020d400ULL, 0x000000019c9c4812ULL, 0x000fe400078efcffULL,
0x000000aa00ac7306ULL, 0x0002e20000205400ULL, 0x000000939200720bULL, 0x004fe40003fbd000ULL,
0x00000018ff927819ULL, 0x000fe40000011490ULL, 0x000000b700907245ULL, 0x000fc6000020d400ULL,
0x00000082008c7306ULL, 0x000522000000d400ULL, 0x000000aa00aa7245ULL, 0x002fca000020d400ULL,
0x0000000191915812ULL, 0x000fe400078efcffULL, 0x0000008300a87306ULL, 0x000fe20000009400ULL,
0x000000acab00720bULL, 0x008fe20003f7d000ULL, 0x0001000082827824ULL, 0x004fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000008300a97306ULL, 0x000e620000005400ULL,
0x000000018c8c6812ULL, 0x010fca00078efcffULL, 0x00000001aaaa3812ULL, 0x000fe400078efcffULL,
0x000000a500a67306ULL, 0x000ff00000209400ULL, 0x000000a500a77306ULL, 0x0004e20000205400ULL,
0x000000a9a800720bULL, 0x002fce0003f9d000ULL, 0x000000a100a27306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x004fce000020d400ULL, 0x000000a100a37306ULL, 0x0002a20000205400ULL,
0x000000a7a600720bULL, 0x008fce0003fdd000ULL, 0x000000ad00ae7306ULL, 0x000fe20000209400ULL,
0x000000a100a17245ULL, 0x002fca000020d400ULL, 0x00000001a5a56812ULL, 0x000fe400078efcffULL,
0x000000ad00af7306ULL, 0x0002e20000205400ULL, 0x000000a3a200720bULL, 0x004fce0003fbd000ULL,
0x00000083008b7306ULL, 0x000ea2000000d400ULL, 0x000000ad00ad7245ULL, 0x002fca000020d400ULL,
0x00000001a1a15812ULL, 0x000fe400078efcffULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000afae00720bULL, 0x008fce0003f7d000ULL, 0x000000b000b27306ULL, 0x0002e20000205400ULL,
0x000000018b8b4812ULL, 0x004fca00078efcffULL, 0x00000001adad3812ULL, 0x000fe400078efcffULL,
0x000000b500b67306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x000000b5008d7306ULL, 0x000e620000205400ULL, 0x000000b2b100720bULL, 0x008fce0003f9d000ULL,
0x0000007c00b37306ULL, 0x000fec0000009400ULL, 0x00000001b0b04812ULL, 0x000fe400078efcffULL,
0x0000007c00b47306ULL, 0x000fe20000005400ULL, 0x0000008db600720bULL, 0x002fe40003fdd000ULL,
0x00000098008d7245ULL, 0x000fca000020d400ULL, 0x0000007c00877306ULL, 0x0003f0000000d400ULL,
0x0000008200a47306ULL, 0x000fe20000209400ULL, 0x000100007c7c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000008200837306ULL, 0x0002b00000205400ULL,
0x00000098008e7306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x002fce000020d400ULL,
0x00000098008f7306ULL, 0x000e620000205400ULL, 0x00000083a400720bULL, 0x004fe20003fbd000ULL,
0x000001007e837824ULL, 0x000fca00078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011483ULL,
0x0000007d00ba7306ULL, 0x000fe20000009400ULL, 0x000001007f837824ULL, 0x000fca00078e00ffULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x0000007d00bb7306ULL, 0x000ea20000005400ULL,
0x0000008f8e00720bULL, 0x002fe40003f7d000ULL, 0x000000b5008e7245ULL, 0x000fe4000020d400ULL,
0x000000b4b300720bULL, 0x000fe40003fbd000ULL, 0x000000018e8e6812ULL, 0x000fe200078efcffULL,
0x0000007d00847306ULL, 0x000e62000000d400ULL, 0x00000018ff997819ULL, 0x000fc40000011483ULL,
0x0000007c00837245ULL, 0x000fc6000020d400ULL, 0x000000018d8d3812ULL, 0x000fe400078efcffULL,
0x0000007c00267306ULL, 0x000fe20000209400ULL, 0x000000bbba00720bULL, 0x004fe40003f9d000ULL,
0x0000000187875812ULL, 0x000fca00078efcffULL, 0x0000007c007d7306ULL, 0x0004ec0000205400ULL,
0x0000000184844812ULL, 0x002fe400078efcffULL, 0x0000008a00bc7306ULL, 0x000fe20000209400ULL,
0x0000008ca17c723eULL, 0x004fce00000010ffULL, 0x0000008a00bd7306ULL, 0x0002a20000205400ULL,
0x0000007d2600720bULL, 0x008fe40003fdd000ULL, 0x0000006e6f26723eULL, 0x000fe400000010ffULL,
0x00000080916e723eULL, 0x000fe400000010ffULL, 0x0000009200917245ULL, 0x000fe2000020d400ULL,
0x0000009200937306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x002fe2000020d400ULL,
0x000000267064723cULL, 0x000f620000041864ULL, 0x0000008baa7d723eULL, 0x000fc400000010ffULL,
0x000000819c6f723eULL, 0x000fe400000010ffULL, 0x0000000183836812ULL, 0x000fe200078efcffULL,
0x0000009200947306ULL, 0x000e620000205400ULL, 0x000000bdbc00720bULL, 0x004fe20003f9d000ULL,
0x000000266844723cULL, 0x000b620000041844ULL, 0x000000848d81723eULL, 0x000fe400000010ffULL,
0x0000009900847245ULL, 0x000fe4000020d400ULL, 0x000000878e80723eULL, 0x000fe200000010ffULL,
0x000000b700b87306ULL, 0x000fe20000209400ULL, 0x0000000102277824ULL, 0x020fe200078e021eULL,
0x0000006e7060723cULL, 0x000f680000041860ULL, 0x000000018a8a4812ULL, 0x000fc400078efcffULL,
0x000000b700b97306ULL, 0x000ea20000205400ULL, 0x000000949300720bULL, 0x002fe20003fdd000ULL,
0x0000006e6840723cULL, 0x000b6c0000041840ULL, 0x0000007f00897306ULL, 0x000fe20000009400ULL,
0x00000008036e7824ULL, 0x020fe200078e00ffULL, 0x0000007c705c723cULL, 0x000f68000004185cULL,
0x0000000191916812ULL, 0x000fc400078efcffULL, 0x0000007f00887306ULL, 0x000e620000005400ULL,
0x000000b9b800720bULL, 0x004fe20003fbd000ULL, 0x000000807054723cULL, 0x000f620000041854ULL,
0x000000918a91723eULL, 0x000fca00000010ffULL, 0x00000099009b7306ULL, 0x000fe40000209400ULL,
0x0000007c683c723cULL, 0x040b68000004183cULL, 0x0000000190905812ULL, 0x000fe400078efcffULL,
0x00000099009e7306ULL, 0x000ea20000205400ULL, 0x000000888900720bULL, 0x002fe20003fdd000ULL,
0x000000806834723cULL, 0x000f620000041834ULL, 0x000000839090723eULL, 0x000fca00000010ffULL,
0x0000007e00be7306ULL, 0x000fe40000009400ULL, 0x000000907050723cULL, 0x080f6c0000041850ULL,
0x0000007e00bf7306ULL, 0x000e620000005400ULL, 0x0000009e9b00720bULL, 0x004fe20003f9d000ULL,
0x000000906830723cULL, 0x000f6c0000041830ULL, 0x0000009500977306ULL, 0x000fec0000209400ULL,
0x0000000184844812ULL, 0x000fc400078efcffULL, 0x00000095009a7306ULL, 0x000ea20000205400ULL,
0x000000bfbe00720bULL, 0x002fce0003f7d000ULL, 0x0000007e001d7306ULL, 0x0003f0000000d400ULL,
0x0000007f001f7306ULL, 0x000722000000d400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x0000009a9700720bULL, 0x004fc80003fbd000ULL, 0x00000018ff8f7819ULL, 0x000fe4000001147eULL,
0x0000007800857306ULL, 0x000fe20000209400ULL, 0x000100007f7f7824ULL, 0x008fe200078e00ffULL,
0x00000082a57e723eULL, 0x000fe400000010ffULL, 0x0000009500827245ULL, 0x000fe4000020d400ULL,
0x00000018ff947819ULL, 0x000fe4000001147fULL, 0x0000007800867306ULL, 0x0002a20000205400ULL,
0x000000011f1f6812ULL, 0x010fc400078efcffULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x0000001f8483723eULL, 0x000fe200000010ffULL, 0x00000008021f7824ULL, 0x000fe200078e00ffULL,
0x0000002500847245ULL, 0x000fe2000020d400ULL, 0x00000025007b7306ULL, 0x000fe20000209400ULL,
0x000000011d1d3812ULL, 0x000fe400078efcffULL, 0x0000007800787245ULL, 0x002fe4000020d400ULL,
0x0000001d8282723eULL, 0x000fc400000010ffULL, 0x000000adb07f723eULL, 0x000fe200000010ffULL,
0x00000025007a7306ULL, 0x0002e20000205400ULL, 0x000000868500720bULL, 0x004fc60003fbd000ULL,
0x00000082704c723cULL, 0x000f68000004184cULL, 0x0000008f00987306ULL, 0x000fe20000209400ULL,
0x000000021a257824ULL, 0x002fc600078e00ffULL, 0x0000007e7058723cULL, 0x080f640000041858ULL,
0x00000004251d7812ULL, 0x000fe400078ec0ffULL, 0x0000008f00937306ULL, 0x0002a20000205400ULL,
0x0000007a7b00720bULL, 0x008fe40003f7d000ULL, 0x000000021d267812ULL, 0x000fe200078efcffULL,
0x0000007e6838723cULL, 0x000f620000041838ULL, 0x00000094007b7245ULL, 0x000fe4000020d400ULL,
0x0000002617267211ULL, 0x000fe200078fe0ffULL, 0x00000094008b7306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x002fc4000020d400ULL, 0x0000000178785812ULL, 0x000fe200078efcffULL,
0x00000001031d7824ULL, 0x100fe200078e0226ULL, 0x00000082682c723cULL, 0x000f62000004182cULL,
0x0000000184843812ULL, 0x000fe200078efcffULL, 0x0000000102267824ULL, 0x000fe200078e0226ULL,
0x0000009400887306ULL, 0x000e620000205400ULL, 0x000000939800720bULL, 0x004fe40003f9d000ULL,
0xfffffff86e1d7812ULL, 0x000fe200078ee21dULL, 0x00000008026e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1e7812ULL, 0x000fc400078ee226ULL, 0x0000100000267810ULL, 0x000fe40007ffe0ffULL,
0xfffffff86e1f7812ULL, 0x000fe400078ee227ULL, 0x0000000227277810ULL, 0x000fc60007ffe0ffULL,
0x000000018f8f4812ULL, 0x000fe200078efcffULL, 0x000000101f7c7824ULL, 0x020fe200078e0226ULL,
0x000000888b00720bULL, 0x002fe40003fdd000ULL, 0x0000008f787a723eULL, 0x000fd600000010ffULL,
0x000000017b7b6812ULL, 0x000fc800078efcffULL, 0x0000007b847b723eULL, 0x000fce00000010ffULL,
0x0000007a7048723cULL, 0x080b6e0000041848ULL, 0x000000101d707824ULL, 0x120fe200078e0221ULL,
0x0000007a6828723cULL, 0x000b620000041828ULL, 0x000000101e217824ULL, 0x000fc800078e0221ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002168783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fd20003800000ULL, 0x0000000770707231ULL, 0x082fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x0000000568687231ULL, 0x088fe400003400ffULL,
0x000000056a6a7231ULL, 0x000fe400003400ffULL, 0x0000000469697231ULL, 0x080fe400003400ffULL,
0x000000046b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000f220000004200ULL, 0xfffffff86e217812ULL, 0x004fca00078ee227ULL,
0x0000001021807824ULL, 0x000fcc00078e0226ULL, 0x000000008080783bULL, 0x000ea20000004200ULL,
0x000001007c6f7824ULL, 0x010fe200078e00ffULL, 0x0000007c00267306ULL, 0x000fe20000009400ULL,
0x00000018ff937819ULL, 0x000fe2000001147cULL, 0x000001007d927824ULL, 0x040fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe2000001147dULL, 0x000100007d9c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x000001007ea47824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011492ULL, 0x0000007c00277306ULL, 0x000f220000005400ULL,
0x000001007fa77824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe2000001147eULL,
0x0000010081c07824ULL, 0x004fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe200000114a4ULL,
0x0000010080b87824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114a7ULL,
0x0001000083c77824ULL, 0x000fe200078e00ffULL, 0x0000006f00907306ULL, 0x000fe20000209400ULL,
0x00000018ffb37819ULL, 0x000fc4000001147fULL, 0x00000018ff9c7819ULL, 0x000fe4000001149cULL,
0x00000018ffc07819ULL, 0x000fe400000114c0ULL, 0x00000018ffbb7819ULL, 0x000fe20000011480ULL,
0x0000006f00917306ULL, 0x0004e20000205400ULL, 0x000000272600720bULL, 0x010fe40003f9d000ULL,
0x0000009900277245ULL, 0x000fe4000020d400ULL, 0x00000018ff8b7819ULL, 0x000fc40000011481ULL,
0x00000018ff847819ULL, 0x000fe20000011482ULL, 0x0000007c006e7306ULL, 0x000862000000d400ULL,
0x0000006f006f7245ULL, 0x004fe4000020d400ULL, 0x00000018ff7b7819ULL, 0x000fe40000011483ULL,
0x00000018ffb87819ULL, 0x000fe400000114b8ULL, 0x00000018ffc77819ULL, 0x000fe200000114c7ULL,
0x0000007d00967306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x010fe200078e00ffULL,
0x000000919000720bULL, 0x008fc80003fdd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00977306ULL, 0x000ea20000005400ULL, 0x000000016e6e4812ULL, 0x002fcc00078efcffULL,
0x000000016f6f6812ULL, 0x000fe200078efcffULL, 0x0000007d00987306ULL, 0x000e70000000d400ULL,
0x0000007c00927306ULL, 0x000fe20000209400ULL, 0x000000979600720bULL, 0x004fe20003f1d000ULL,
0x0001000082977824ULL, 0x000fca00078e00ffULL, 0x00000018ff977819ULL, 0x000fe20000011497ULL,
0x0000007c007d7306ULL, 0x0004ec0000205400ULL, 0x0000000198980812ULL, 0x002fe400078efcffULL,
0x0000009300947306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x004fce000020d400ULL,
0x0000009300957306ULL, 0x0002a20000205400ULL, 0x0000007d9200720bULL, 0x008fe40003fdd000ULL,
0x000000ae007d7245ULL, 0x000fca000020d400ULL, 0x000000a400a57306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x000000017c7c6812ULL, 0x000fe400078efcffULL,
0x000000a400a67306ULL, 0x0002e20000205400ULL, 0x000000959400720bULL, 0x004fce0003fbd000ULL,
0x0000009f00a07306ULL, 0x000fe20000209400ULL, 0x000000a400a47245ULL, 0x002fca000020d400ULL,
0x0000000193935812ULL, 0x000fe400078efcffULL, 0x0000009f00a17306ULL, 0x0002a20000205400ULL,
0x000000a6a500720bULL, 0x008fce0003fdd000ULL, 0x000000ae00af7306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fca000020d400ULL, 0x00000001a4a46812ULL, 0x000fe400078efcffULL,
0x000000ae00b07306ULL, 0x000e620000205400ULL, 0x000000a1a000720bULL, 0x004fce0003f1d000ULL,
0x0000007e00a27306ULL, 0x000fec0000009400ULL, 0x000000019f9f0812ULL, 0x000fe400078efcffULL,
0x0000007e00a37306ULL, 0x000ea20000005400ULL, 0x000000b0af00720bULL, 0x002fce0003fbd000ULL,
0x0000007e008d7306ULL, 0x0002ec000000d400ULL, 0x000000017d7d5812ULL, 0x000fe400078efcffULL,
0x0000007f00ac7306ULL, 0x000fe20000009400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x000000a3a200720bULL, 0x004fc80003f9d000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00ad7306ULL, 0x000fee0000005400ULL, 0x000000018d8d4812ULL, 0x008fe200078efcffULL,
0x0000007f008c7306ULL, 0x0003f0000000d400ULL, 0x00000099009a7306ULL, 0x000fe20000209400ULL,
0x000100007f7f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x00000099009b7306ULL, 0x000e700000205400ULL, 0x000000a900aa7306ULL, 0x000ff00000209400ULL,
0x000000a900ab7306ULL, 0x0004e20000205400ULL, 0x0000009b9a00720bULL, 0x002fe20003f7d000ULL,
0x00000100839a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x0000007e00a77306ULL, 0x000fe20000209400ULL, 0x000000a900a97245ULL, 0x004fca000020d400ULL,
0x0000000127273812ULL, 0x000fe400078efcffULL, 0x0000007e00a87306ULL, 0x0002a20000205400ULL,
0x000000abaa00720bULL, 0x008fe40003fdd000ULL, 0x000000982727723eULL, 0x000fca00000010ffULL,
0x0000007f00b17306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x002fca000020d400ULL,
0x00000001a9a96812ULL, 0x000fe400078efcffULL, 0x0000007f00b27306ULL, 0x0002e20000205400ULL,
0x000000a8a700720bULL, 0x004fce0003f1d000ULL, 0x0000009c009d7306ULL, 0x000fe20000209400ULL,
0x0000007f007f7245ULL, 0x002fca000020d400ULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x0000009c009e7306ULL, 0x0002a20000205400ULL, 0x000000b2b100720bULL, 0x008fe40003fbd000ULL,
0x0000007ea97e723eULL, 0x000fca00000010ffULL, 0x000000c000c17306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fca000020d400ULL, 0x000000017f7f5812ULL, 0x000fe400078efcffULL,
0x000000c000c27306ULL, 0x0002e20000205400ULL, 0x0000009e9d00720bULL, 0x004fce0003f7d000ULL,
0x0000008000b67306ULL, 0x000fe20000009400ULL, 0x000000c000c07245ULL, 0x002fca000020d400ULL,
0x000000019c9c3812ULL, 0x000fe400078efcffULL, 0x0000008000b77306ULL, 0x000e620000005400ULL,
0x000000c2c100720bULL, 0x008fe40003fdd000ULL, 0x000000adac00720bULL, 0x000fca0003f7d000ULL,
0x0000008100be7306ULL, 0x000fec0000009400ULL, 0x00000001c0c06812ULL, 0x000fe400078efcffULL,
0x0000008100bf7306ULL, 0x000ea20000005400ULL, 0x000000b7b600720bULL, 0x002fe40003f1d000ULL,
0x000000018c8c3812ULL, 0x000fc800078efcffULL, 0x0000008c7d7d723eULL, 0x000fe200000010ffULL,
0x0000008000887306ULL, 0x0002f0000000d400ULL, 0x0000008100857306ULL, 0x0008e2000000d400ULL,
0x0001000080807824ULL, 0x002fe200078e00ffULL, 0x000000bfbe00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff907819ULL, 0x000fe20000011480ULL, 0x0000010082807824ULL, 0x000fe200078e00ffULL,
0x0000008200c37306ULL, 0x000fe20000009400ULL, 0x0001000081817824ULL, 0x010fe200078e00ffULL,
0x0000000188880812ULL, 0x008fe400078efcffULL, 0x00000018ff947819ULL, 0x000fe40000011480ULL,
0x000000b300807245ULL, 0x000fe4000020d400ULL, 0x0000008200c47306ULL, 0x000fe20000005400ULL,
0x0000000185855812ULL, 0x000fce00078efcffULL, 0x00000082007a7306ULL, 0x0003f0000000d400ULL,
0x0000008300c57306ULL, 0x000fe20000009400ULL, 0x00000018ff827819ULL, 0x002fe40000011481ULL,
0x000000b800817245ULL, 0x000fca000020d400ULL, 0x0000008300c67306ULL, 0x000ff00000005400ULL,
0x0000008300787306ULL, 0x000ff0000000d400ULL, 0x0000009000267306ULL, 0x000ff00000209400ULL,
0x0000009000837306ULL, 0x0002b00000205400ULL, 0x000000b300b47306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x002fce000020d400ULL, 0x000000b300b57306ULL, 0x000e620000205400ULL,
0x000000832600720bULL, 0x004fe40003fdd000ULL, 0x0000006e6f26723eULL, 0x000fe400000010ffULL,
0x0000007c936e723eULL, 0x000fe400000010ffULL, 0x0000008da47c723eULL, 0x000fe200000010ffULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x0000009400837245ULL, 0x000fe2000020d400ULL,
0x000000267064723cULL, 0x000f620000041864ULL, 0x0000009c9f6f723eULL, 0x000fc600000010ffULL,
0x0000000190906812ULL, 0x000fe400078efcffULL, 0x000000bb00bd7306ULL, 0x0004e20000205400ULL,
0x000000b5b400720bULL, 0x002fe20003f9d000ULL, 0x0000006e7060723cULL, 0x040f6c0000041860ULL,
0x0000008200917306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x004fe2000020d400ULL,
0x0000007c705c723cULL, 0x000f68000004185cULL, 0x0000000180804812ULL, 0x000fc400078efcffULL,
0x0000008200927306ULL, 0x000e620000205400ULL, 0x000000bdbc00720bULL, 0x008fe20003f1d000ULL,
0x000000266844723cULL, 0x000b620000041844ULL, 0x000000c4c300720bULL, 0x000fe40003f9d000ULL,
0x0000007f807f723eULL, 0x000fc600000010ffULL, 0x000000b800b97306ULL, 0x000fe20000209400ULL,
0xfffffff825267812ULL, 0x020fe200078ec0ffULL, 0x0000006e6840723cULL, 0x000f680000041840ULL,
0x00000001bbbb0812ULL, 0x000fe400078efcffULL, 0x000000b800ba7306ULL, 0x000ea20000205400ULL,
0x000000929100720bULL, 0x002fe20003fbd000ULL, 0x0000007e7058723cULL, 0x000f620000041858ULL,
0x0000008200917245ULL, 0x000fc4000020d400ULL, 0x0000008b00827245ULL, 0x000fe4000020d400ULL,
0x000000017a7a4812ULL, 0x000fe200078efcffULL, 0x0000008b008f7306ULL, 0x000fe20000209400ULL,
0x00000090bb90723eULL, 0x000fe200000010ffULL, 0x0000007c683c723cULL, 0x040f68000004183cULL,
0x0000000191915812ULL, 0x000fe400078efcffULL, 0x0000008b008e7306ULL, 0x000e620000205400ULL,
0x000000bab900720bULL, 0x004fe20003f7d000ULL, 0x0000007e6838723cULL, 0x000f6c0000041838ULL,
0x0000009400957306ULL, 0x000fec0000209400ULL, 0x0000000181813812ULL, 0x000fc400078efcffULL,
0x0000009400967306ULL, 0x000ea20000205400ULL, 0x0000008e8f00720bULL, 0x002fe40003fdd000ULL,
0x000000c6c500720bULL, 0x000fe40003f7d000ULL, 0x000000888188723eULL, 0x000fe400000010ffULL,
0x0000009a00817245ULL, 0x000fe2000020d400ULL, 0x0000009a009b7306ULL, 0x000fec0000209400ULL,
0x0000000182826812ULL, 0x000fc400078efcffULL, 0x0000009a009e7306ULL, 0x000e620000205400ULL,
0x000000969500720bULL, 0x004fe40003f1d000ULL, 0x0000000178783812ULL, 0x000fe400078efcffULL,
0x000000918291723eULL, 0x000fc600000010ffULL, 0x0000008400867306ULL, 0x000fe80000209400ULL,
0x000000907050723cULL, 0x080f640000041850ULL, 0x0000000183830812ULL, 0x000fe400078efcffULL,
0x0000008400897306ULL, 0x0004e20000205400ULL, 0x0000009e9b00720bULL, 0x002fe40003fbd000ULL,
0x0000007a8380723eULL, 0x000fe200000010ffULL, 0x000000906830723cULL, 0x000f680000041830ULL,
0x0000007b008a7306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x004fca000020d400ULL,
0x0000000181815812ULL, 0x000fe400078efcffULL, 0x0000007b00877306ULL, 0x000e620000205400ULL,
0x000000898600720bULL, 0x008fe40003fdd000ULL, 0x00000085c089723eULL, 0x000fe400000010ffULL,
0x000000788181723eULL, 0x000fe400000010ffULL, 0x0000007b00787245ULL, 0x000fe2000020d400ULL,
0x0000009700997306ULL, 0x000fe20000209400ULL, 0x000000c700857245ULL, 0x000fe2000020d400ULL,
0x000000887054723cULL, 0x000f680000041854ULL, 0x0000000184846812ULL, 0x000fc400078efcffULL,
0x0000009700927306ULL, 0x0004e20000205400ULL, 0x000000878a00720bULL, 0x002fe20003f1d000ULL,
0x00000080704c723cULL, 0x000f6c000004184cULL, 0x000000c7008e7306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x004fe2000020d400ULL, 0x000000886834723cULL, 0x000f680000041834ULL,
0x0000000178780812ULL, 0x000fc400078efcffULL, 0x000000c7008d7306ULL, 0x000e620000205400ULL,
0x000000929900720bULL, 0x008fe20003f9d000ULL, 0x00000080682c723cULL, 0x000f58000004182cULL,
0x0000000197974812ULL, 0x000fe400078efcffULL, 0x0000008d8e00720bULL, 0x002fe40003fbd000ULL,
0x000000978484723eULL, 0x000fd600000010ffULL, 0x0000000185855812ULL, 0x000fc800078efcffULL,
0x000000857885723eULL, 0x000fce00000010ffULL, 0x000000847048723cULL, 0x080f700000041848ULL,
0x000000846828723cULL, 0x000b6e0000041828ULL, 0x000126c8136a7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126900026ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff257224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x004fc80000015200ULL,
0x000004000d697984ULL, 0x000ea40000000800ULL, 0x8000000069ff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000687805ULL, 0x000fcc0000015200ULL,
0x00000068266f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000169697824ULL, 0x000fe200000e0e27ULL,
0x003d09006f00780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406f00780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff687819ULL, 0x000fc80000011469ULL, 0x0000006f68687211ULL, 0x000fca00078110ffULL,
0x000000ffff697224ULL, 0x000fca00000e0669ULL, 0x0000000268687819ULL, 0x000fc80000001269ULL,
0x000000680000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d697984ULL, 0x000e640000000800ULL, 0x8000000069ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c00c277810ULL, 0x000fca0007ffe0ffULL,
0x00006600126f7a24ULL, 0x000fe200078e0227ULL, 0x000003e00000a947ULL, 0x000fea0003800000ULL,
0x0000002716257217ULL, 0x000fe20007800000ULL, 0x00000010116e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff687819ULL, 0x000fe40000011617ULL, 0x00001000007b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a27ULL, 0x0000000468697810ULL, 0x000fe20007ffe0ffULL,
0x000000016e267824ULL, 0x000fe200078e0268ULL, 0x00000008686b7810ULL, 0x000fe40007ffe0ffULL,
0x000000256e257217ULL, 0x000fe20007800000ULL, 0x0000000126277824ULL, 0x000fc400078e0217ULL,
0x0000000826707824ULL, 0x040fe400078e00ffULL, 0x0000000125257824ULL, 0x000fe400078e0a6eULL,
0x0000000126267824ULL, 0x000fe200078e026fULL, 0xfffffff870707812ULL, 0x000fe200078ee227ULL,
0x000000016e727824ULL, 0x000fe200078e0269ULL, 0x000000256900720cULL, 0x080fe20003f86070ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000c68697810ULL, 0x040fe40007ffe0ffULL,
0x000000256800720cULL, 0x080fe20003fa6070ULL, 0x0000000172687824ULL, 0x000fe200078e026fULL,
0x000000256900720cULL, 0x000fe20003f06070ULL, 0x000000016e7a7824ULL, 0x000fe200078e0269ULL,
0x0000000b266a7212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x000000256b00720cULL, 0x000fc40003f66070ULL, 0x000062006a6a7a10ULL, 0x000fe20007fde0ffULL,
0x000000016e787824ULL, 0x000fe200078e026bULL, 0x0000000b686e7212ULL, 0x000fe200078efcffULL,
0x0000000172257824ULL, 0x000fe200078e0217ULL, 0x00006300276b7a10ULL, 0x000fe200037fe4ffULL,
0x0000000178267824ULL, 0x000fe200078e026fULL, 0x000062006e6e7a10ULL, 0x000fe20007fde0ffULL,
0x0000000872727824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff872727812ULL, 0x000fe200078ee225ULL, 0x000000017a687824ULL, 0x000fe200078e026fULL,
0x00006300696f7a10ULL, 0x000fe200037fe4ffULL, 0x0000000178717824ULL, 0x000fe200078e0217ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fc600078e00ffULL,
0x0000620026267a10ULL, 0x000fe20007fde0ffULL, 0x0000000878787824ULL, 0x000fe200078e00ffULL,
0x0000000b68687212ULL, 0x000fe200078efcffULL, 0x000000017a257824ULL, 0x040fe200078e0217ULL,
0x0000630027277a10ULL, 0x000fe200037fe4ffULL, 0x000000087a7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee271ULL, 0x0000001072717824ULL, 0x000fe200078e027bULL,
0x0000620068687a10ULL, 0x000fe40007fde0ffULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee225ULL,
0x0000001070257824ULL, 0x100fe200078e027bULL, 0x0000630069697a10ULL, 0x000fe200037fe4ffULL,
0x0000001078737824ULL, 0x000fc400078e027bULL, 0x000000107a7b7824ULL, 0x000fe200078e027bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a257faeULL, 0x0003e8000e901c48ULL,
0x000000006e717faeULL, 0x0003e8000e101c48ULL, 0x0000000026737faeULL, 0x0003e8000d901c48ULL,
0x00000000687b7faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011267824ULL, 0x000fe200078e00ffULL, 0x00001000007b7810ULL, 0x000fc80007ffe0ffULL,
0x0000002617687211ULL, 0x000fc800078fe8ffULL, 0x00000004686a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000168267824ULL, 0x040fe200078e026fULL, 0x0000000868727810ULL, 0x040fe20007ffe0ffULL,
0x0000000168257824ULL, 0x040fe200078e0217ULL, 0x0000000c68787810ULL, 0x040fe20007ffe0ffULL,
0x0000000868707824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff870707812ULL, 0x000fe200078ee225ULL, 0x000000016a257824ULL, 0x000fe200078e026fULL,
0x0000000b266e7212ULL, 0x000fe200078efcffULL, 0x000000016a697824ULL, 0x040fe400078e0217ULL,
0x000000086a7a7824ULL, 0x000fe200078e00ffULL, 0x000062006e6e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000172687824ULL, 0x100fe400078e026fULL, 0x00000001786a7824ULL, 0x040fe400078e026fULL,
0x0000000178267824ULL, 0x000fc400078e0217ULL, 0x00000008786f7824ULL, 0x000fe400078e00ffULL,
0x00000001726b7824ULL, 0x040fe400078e0217ULL, 0x00000008727c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a727812ULL, 0x000fe200078ee269ULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0xfffffff86f7a7812ULL, 0x000fe400078ee226ULL, 0x00006300276f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008025267825ULL, 0x000fe200078e00ffULL, 0xfffffff87c787812ULL, 0x000fc400078ee26bULL,
0x0000000b68687212ULL, 0x080fe200078efcffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000620068687a10ULL, 0x000fe20007f7e0ffULL,
0x0000001070257824ULL, 0x100fe200078e027bULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x0000001072717824ULL, 0x100fe200078e027bULL, 0x0000620026267a10ULL, 0x000fe20007f1e0ffULL,
0x0000001078737824ULL, 0x100fe200078e027bULL, 0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x000000107a7b7824ULL, 0x000fe200078e027bULL, 0x0000630027277a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e257faeULL, 0x0003e2000b901c48ULL,
0x0000630069697a10ULL, 0x000fc40001ffe4ffULL, 0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026717faeULL, 0x0003e8000b901c48ULL, 0x0000000068737faeULL, 0x0003e8000b901c48ULL,
0x000000006a7b7faeULL, 0x0003e4000b901c48ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff014687812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126b00068687f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01264800206e7f8cULL, 0x0004e4000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x01264c0020257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x018fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006a7805ULL, 0x000fcc0000015200ULL,
0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL, 0x000000016b6b7824ULL, 0x000fe200000e0e27ULL,
0x003d09006a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146bULL, 0x0000006a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6a7224ULL, 0x000fca00000e066bULL, 0x0000000225257819ULL, 0x000fc8000000126aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01264c0020257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a207824ULL, 0x004fca00078e00ffULL,
0xffffff8020207812ULL, 0x000fc800078ec0ffULL, 0x000001000b257810ULL, 0x000fca0007ffe020ULL,
0x000000010a257824ULL, 0x000fca00078e0225ULL, 0x01200000256e7984ULL, 0x000ea80000000800ULL,
0x01220000256f7984ULL, 0x0006620000000800ULL, 0x000000236e00720bULL, 0x004fe20003f1d000ULL,
0x000114227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000707806ULL, 0x008fc800000e0100ULL,
0x000000ff7000720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff207224ULL, 0x000fd200078e0023ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000210257810ULL, 0x000fe40007ffe0ffULL,
0x000000236e00720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x000113d27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000717806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x000000236e207209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x0124002025008388ULL, 0x0005e20000000800ULL, 0x000000ff7100720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000002320237221ULL, 0x004fe20000010100ULL,
0x000000ff71ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b23237820ULL, 0x000fc80000410000ULL, 0x0000002300277308ULL, 0x000ea40000000800ULL,
0x0000002724247220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x000113127f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x000111d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x000110927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000071ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x00010f627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000007170ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fd800078e00ffULL,
0x800000206e6e0221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL, 0x0000006e00090308ULL, 0x000ea40000000800ULL,
0x000000096f6f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000246f247221ULL, 0x002fc20000010000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000040008237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006a7805ULL, 0x000fcc0000015200ULL, 0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL,
0x000000016b6b7824ULL, 0x000fe200000e0e27ULL, 0x003d09006a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc8000001146bULL,
0x0000006a23237211ULL, 0x000fca00078110ffULL, 0x000000ffff6a7224ULL, 0x000fca00000e066bULL,
0x0000000223237819ULL, 0x000fc8000000126aULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040008237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025237816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x00010b327f007947ULL, 0x000fea000b800000ULL,
0x00001f6c27077589ULL, 0x0002a400000e0000ULL, 0x000000086c267810ULL, 0x000fe20007ffe0ffULL,
0x00010b527f007947ULL, 0x000fea000b800000ULL, 0x000000106c047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000186c267810ULL, 0x008fe20007ffe0ffULL, 0x00010b827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021a237824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a277824ULL, 0x00afe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000008036b7824ULL, 0x000fe200078e00ffULL, 0x0000000423267812ULL, 0x000fe200078ec0ffULL,
0x00000008026c7824ULL, 0x000fe200078e00ffULL, 0xfffff000276a7812ULL, 0x000fe200078ec0ffULL,
0x000000101c7c7824ULL, 0x000fe200078e0200ULL, 0x0000002617257211ULL, 0x000fca00078fe0ffULL,
0x0000000103267824ULL, 0x100fe400078e0225ULL, 0x0000000102277824ULL, 0x000fe200078e0225ULL,
0x0000c0006a257810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86b267812ULL, 0x000fe400078ee226ULL,
0xfffffff86c6a7812ULL, 0x000fc600078ee227ULL, 0x0000001026267824ULL, 0x100fe400078e0225ULL,
0x000000106a6a7824ULL, 0x000fc600078e0225ULL, 0x000000002670783bULL, 0x0002e80000000200ULL,
0x000000006a6c783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707231ULL, 0x08cfe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x000000056c6c7231ULL, 0x080fe400003400ffULL, 0x000000056e6e7231ULL, 0x000fe400003400ffULL,
0x000000046d6d7231ULL, 0x080fe400003400ffULL, 0x000000046f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x0000001022807824ULL, 0x000fe200078e0200ULL, 0x00000f8000007945ULL, 0x000fea0003800000ULL,
0x000000008080783bULL, 0x000e620000004200ULL, 0x000001007c6b7824ULL, 0x010fe200078e00ffULL,
0x0000007c00267306ULL, 0x002fe20000009400ULL, 0x000001007d927824ULL, 0x040fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001147cULL, 0x000100007d9c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x000001007ea47824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011492ULL, 0x000001007fab7824ULL, 0x000fe200078e00ffULL,
0x0000006b00907306ULL, 0x000fe20000209400ULL, 0x00000018ff9f7819ULL, 0x000fe2000001147dULL,
0x0000010080b07824ULL, 0x000fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe2000001149cULL,
0x0000010081b37824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fc400000114a4ULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000006b00917306ULL, 0x0003220000205400ULL,
0x00000018ffb07819ULL, 0x000fe400000114b0ULL, 0x00000018ffba7819ULL, 0x000fe400000114b3ULL,
0x00000018ffb57819ULL, 0x000fe40000011480ULL, 0x00000018ffbf7819ULL, 0x000fe20000011481ULL,
0x0000007c00277306ULL, 0x000ee20000005400ULL, 0x0000006b006b7245ULL, 0x002fc4000020d400ULL,
0x00000018ff897819ULL, 0x000fe4000001147eULL, 0x00000018ff787819ULL, 0x000fe40000011482ULL,
0x00000018ff887819ULL, 0x000fe2000001147fULL, 0x0000007c006a7306ULL, 0x0002a2000000d400ULL,
0x000000919000720bULL, 0x010fe40003fbd000ULL, 0x000000ab00907245ULL, 0x000fe4000020d400ULL,
0x000000ba00917245ULL, 0x000fc4000020d400ULL, 0x00000018ff227819ULL, 0x000fe20000011483ULL,
0x0000007d00967306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000272600720bULL, 0x008fe20003fdd000ULL, 0x0000010082267824ULL, 0x000fe200078e00ffULL,
0x0000009900277245ULL, 0x000fe4000020d400ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00977306ULL, 0x000e620000005400ULL, 0x000000016b6b5812ULL, 0x000fcc00078efcffULL,
0x000000016a6a6812ULL, 0x004fe200078efcffULL, 0x00000099009a7306ULL, 0x000ff00000209400ULL,
0x00000099009b7306ULL, 0x000ea20000205400ULL, 0x000000979600720bULL, 0x002fc40003f9d000ULL,
0x00000018ff967819ULL, 0x000fe20000011426ULL, 0x0000010083267824ULL, 0x000fc800078e00ffULL,
0x0000007d00987306ULL, 0x000e70000000d400ULL, 0x0000007c00927306ULL, 0x000fe20000209400ULL,
0x0000009b9a00720bULL, 0x004fe40003f7d000ULL, 0x00000018ff9a7819ULL, 0x000fe20000011426ULL,
0x000100007f267824ULL, 0x000fc800078e00ffULL, 0x0000007c007d7306ULL, 0x0004e20000205400ULL,
0x0000000198984812ULL, 0x002fca00078efcffULL, 0x0000000127273812ULL, 0x000fe400078efcffULL,
0x0000009f00a07306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x004fe4000020d400ULL,
0x000000982727723eULL, 0x000fca00000010ffULL, 0x0000009f00a17306ULL, 0x0002a20000205400ULL,
0x0000007d9200720bULL, 0x008fe40003fbd000ULL, 0x000000a4007d7245ULL, 0x000fe4000020d400ULL,
0x000000b500927245ULL, 0x000fc6000020d400ULL, 0x0000009c009d7306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fca000020d400ULL, 0x000000017c7c5812ULL, 0x000fe400078efcffULL,
0x0000009c009e7306ULL, 0x0002e20000205400ULL, 0x000000a1a000720bULL, 0x004fce0003f9d000ULL,
0x0000009300947306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fca000020d400ULL,
0x000000019f9f4812ULL, 0x000fe400078efcffULL, 0x0000009300957306ULL, 0x0002a20000205400ULL,
0x0000009e9d00720bULL, 0x008fe20003f7d000ULL, 0x00010000839d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe2000001149dULL, 0x000000a400a57306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x000000019c9c3812ULL, 0x000fe400078efcffULL,
0x000000a400a67306ULL, 0x000e620000205400ULL, 0x000000959400720bULL, 0x004fce0003fdd000ULL,
0x0000007f00a97306ULL, 0x000fec0000009400ULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x0000007f00aa7306ULL, 0x000ea20000005400ULL, 0x000000a6a500720bULL, 0x002fce0003fbd000ULL,
0x000000ab00ac7306ULL, 0x000fec0000209400ULL, 0x000000017d7d5812ULL, 0x000fe400078efcffULL,
0x000000ab00ad7306ULL, 0x000e620000205400ULL, 0x000000aaa900720bULL, 0x004fce0003f9d000ULL,
0x0000007e00a27306ULL, 0x000ff00000009400ULL, 0x0000007e00a37306ULL, 0x000ea20000005400ULL,
0x000000adac00720bULL, 0x002fce0003f7d000ULL, 0x000000b000b17306ULL, 0x000fec0000209400ULL,
0x0000000190903812ULL, 0x000fe400078efcffULL, 0x000000b000b27306ULL, 0x0002e20000205400ULL,
0x000000a3a200720bULL, 0x004fce0003fdd000ULL, 0x0000008000ae7306ULL, 0x000fe20000009400ULL,
0x000000b000b07245ULL, 0x002fce000020d400ULL, 0x0000008000af7306ULL, 0x000fe20000005400ULL,
0x000000b2b100720bULL, 0x008fce0003fbd000ULL, 0x00000080008d7306ULL, 0x0003ec000000d400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x0000007f007b7306ULL, 0x000ea2000000d400ULL,
0x0001000080807824ULL, 0x002fca00078e00ffULL, 0x00000018ffb37819ULL, 0x000fe20000011480ULL,
0x0001000081807824ULL, 0x000fe200078e00ffULL, 0x0000008100b87306ULL, 0x000fe80000009400ULL,
0x00000018ffbd7819ULL, 0x000fc80000011480ULL, 0x0000008100b97306ULL, 0x000e620000005400ULL,
0x000000017b7b4812ULL, 0x004fc800078efcffULL, 0x0000007b907b723eULL, 0x000fc600000010ffULL,
0x000000ba00bb7306ULL, 0x000ff00000209400ULL, 0x000000ba00bc7306ULL, 0x000ea20000205400ULL,
0x000000b9b800720bULL, 0x002fce0003f9d000ULL, 0x0000007e007a7306ULL, 0x0002f0000000d400ULL,
0x00000081008c7306ULL, 0x000f22000000d400ULL, 0x000000bcbb00720bULL, 0x004fe20003f7d000ULL,
0x000100007e7e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x000000b300b47306ULL, 0x000fe20000209400ULL, 0x000000017a7a6812ULL, 0x008fe400078efcffULL,
0x000000afae00720bULL, 0x000fe40003fdd000ULL, 0x0000007a7d7a723eULL, 0x000fe400000010ffULL,
0x0000000191913812ULL, 0x000fe200078efcffULL, 0x000000b300817306ULL, 0x0002a20000205400ULL,
0x000000018c8c4812ULL, 0x010fc600078efcffULL, 0x0000007a705c723cULL, 0x000f62000004185cULL,
0x0000008c917d723eULL, 0x000fc600000010ffULL, 0x000000bf00c07306ULL, 0x000fe20000209400ULL,
0x000000018d8d6812ULL, 0x000fe400078efcffULL, 0x000000b300b37245ULL, 0x002fe2000020d400ULL,
0x0000007a6c3c723cULL, 0x000f68000004183cULL, 0x000000bf00c17306ULL, 0x000e620000205400ULL,
0x00000081b400720bULL, 0x004fe40003fbd000ULL, 0x00000018ff817819ULL, 0x000fc40000011426ULL,
0x0000006a6b26723eULL, 0x000fe400000010ffULL, 0x0000007c936a723eULL, 0x000fe200000010ffULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x0000009a00937245ULL, 0x000fe4000020d400ULL,
0x0000009c9f6b723eULL, 0x000fe200000010ffULL, 0x000000267064723cULL, 0x000f620000041864ULL,
0x0000008db07c723eULL, 0x000fe400000010ffULL, 0x00000001b3b35812ULL, 0x000fe200078efcffULL,
0x000000bd00977306ULL, 0x0004e20000205400ULL, 0x000000c1c000720bULL, 0x002fc60003f9d000ULL,
0x0000006a7060723cULL, 0x000f680000041860ULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x004fc6000020d400ULL, 0x0000007c7054723cULL, 0x000f680000041854ULL,
0x000000b500b77306ULL, 0x000e620000205400ULL, 0x00000097be00720bULL, 0x008fc60003f7d000ULL,
0x000000266c44723cULL, 0x040f680000041844ULL, 0x0000009600997306ULL, 0x000fe80000209400ULL,
0x0000006a6c40723cULL, 0x000f640000041840ULL, 0x00000001bdbd3812ULL, 0x000fc400078efcffULL,
0x0000009600947306ULL, 0x0004e20000205400ULL, 0x000000b7b600720bULL, 0x002fc60003fdd000ULL,
0x0000007c6c34723cULL, 0x000b680000041834ULL, 0x0000008300c47306ULL, 0x000fe20000009400ULL,
0x0000009600967245ULL, 0x004fe4000020d400ULL, 0x000000101f7c7824ULL, 0x020fc600078e0200ULL,
0x0000000192926812ULL, 0x000fe400078efcffULL, 0x0000008300c57306ULL, 0x000e620000005400ULL,
0x000000949900720bULL, 0x008fe40003fbd000ULL, 0x000000bf00947245ULL, 0x000fc8000020d400ULL,
0x0000000194944812ULL, 0x000fe200078efcffULL, 0x0000009a009b7306ULL, 0x000fec0000209400ULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x0000009a009e7306ULL, 0x000ea20000205400ULL,
0x000000c5c400720bULL, 0x002fce0003f7d000ULL, 0x0000008200c27306ULL, 0x000ff00000009400ULL,
0x0000008200c37306ULL, 0x000e620000005400ULL, 0x0000009e9b00720bULL, 0x004fce0003f9d000ULL,
0x0000008200877306ULL, 0x0004ec000000d400ULL, 0x0000000193934812ULL, 0x000fe400078efcffULL,
0x0000008300847306ULL, 0x000f22000000d400ULL, 0x0001000082827824ULL, 0x004fe200078e00ffULL,
0x000000c3c200720bULL, 0x002fc80003fdd000ULL, 0x00000018ff957819ULL, 0x000fe40000011482ULL,
0x00000088008f7306ULL, 0x000fee0000209400ULL, 0x0000000187876812ULL, 0x008fe200078efcffULL,
0x00000088008e7306ULL, 0x0002a20000205400ULL, 0x0000000184843812ULL, 0x010fc400078efcffULL,
0x000000879696723eULL, 0x000fca00000010ffULL, 0x0000008100827306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x002fce000020d400ULL, 0x0000008100837306ULL, 0x0002e20000205400ULL,
0x0000008e8f00720bULL, 0x004fce0003f9d000ULL, 0x0000008900a77306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x002fca000020d400ULL, 0x0000000188884812ULL, 0x000fe400078efcffULL,
0x0000008900a87306ULL, 0x0002a20000205400ULL, 0x000000838200720bULL, 0x008fce0003f7d000ULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fca000020d400ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000007e00807306ULL, 0x000e620000205400ULL,
0x000000a8a700720bULL, 0x004fe40003fbd000ULL, 0x000000818881723eULL, 0x000fca00000010ffULL,
0x00000078008b7306ULL, 0x000fec0000209400ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x00000078008a7306ULL, 0x0004e20000205400ULL, 0x000000807f00720bULL, 0x002fe40003fdd000ULL,
0x0000007e00807245ULL, 0x000fc4000020d400ULL, 0x000000b3927e723eULL, 0x000fe400000010ffULL,
0x000000bd947f723eULL, 0x000fe200000010ffULL, 0x0000002200867306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x004fca000020d400ULL, 0x0000000180806812ULL, 0x000fe200078efcffULL,
0x0000007e7050723cULL, 0x000f620000041850ULL, 0x0000002200857306ULL, 0x0002a20000205400ULL,
0x0000008a8b00720bULL, 0x008fe40003fdd000ULL, 0x000000808980723eULL, 0x000fc800000010ffULL,
0x0000007e6c30723cULL, 0x000f620000041830ULL, 0x0000009500977306ULL, 0x000fe20000209400ULL,
0x0000002200227245ULL, 0x002fca000020d400ULL, 0x0000000178786812ULL, 0x000fe200078efcffULL,
0x000000807058723cULL, 0x000f620000041858ULL, 0x0000009500987306ULL, 0x0002e20000205400ULL,
0x000000858600720bULL, 0x004fcc0003fbd000ULL, 0x000000806c38723cULL, 0x000f620000041838ULL,
0x0000009d008e7306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x002fca000020d400ULL,
0x0000000122225812ULL, 0x000fe400078efcffULL, 0x0000009d00837306ULL, 0x000e620000205400ULL,
0x000000989700720bULL, 0x008fe40003f7d000ULL, 0x000000849397723eULL, 0x000fce00000010ffULL,
0x00000096704c723cULL, 0x080f68000004184cULL, 0x0000000195953812ULL, 0x000fe400078efcffULL,
0x000000838e00720bULL, 0x002fe40003f9d000ULL, 0x0000009d00837245ULL, 0x000fe2000020d400ULL,
0x000000966c2c723cULL, 0x000f62000004182cULL, 0x000000957882723eULL, 0x000fd200000010ffULL,
0x0000000183834812ULL, 0x000fc800078efcffULL, 0x000000832283723eULL, 0x000fce00000010ffULL,
0x000000827048723cULL, 0x080b6e0000041848ULL, 0x000000101d707824ULL, 0x120fe200078e0225ULL,
0x000000826c6c723cULL, 0x000b620000041828ULL, 0x000000101e257824ULL, 0x000fc800078e0225ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002528783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fd20003800000ULL, 0x0000000770707231ULL, 0x082fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x0000000528287231ULL, 0x088fe400003400ffULL,
0x000000052a2a7231ULL, 0x000fe400003400ffULL, 0x0000000429297231ULL, 0x080fe400003400ffULL,
0x000000042b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000f220000004200ULL, 0x0000001021807824ULL, 0x000fe200078e0200ULL,
0xfffffff823237812ULL, 0x000fca00078ec0ffULL, 0x000000008080783bULL, 0x000ea20000004200ULL,
0x000001007d8d7824ULL, 0x010fe200078e00ffULL, 0x0000007c00267306ULL, 0x000fe20000009400ULL,
0x00000018ff8f7819ULL, 0x000fe2000001147cULL, 0x000001007c6b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe2000001147dULL, 0x000001007e9f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe2000001148dULL, 0x000001007fa27824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000007c00277306ULL, 0x000f220000005400ULL,
0x00000018ff9f7819ULL, 0x000fe2000001149fULL, 0x0000010081bb7824ULL, 0x004fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe2000001147eULL, 0x0000010080b37824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe2000001147fULL, 0x000100007fab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a2ULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x00000018ffb67819ULL, 0x000fc40000011480ULL, 0x00000018ffbb7819ULL, 0x000fe400000114bbULL,
0x00000018ffab7819ULL, 0x000fe400000114abULL, 0x00000018ff877819ULL, 0x000fe20000011481ULL,
0x0000009500977306ULL, 0x000ea20000205400ULL, 0x000000272600720bULL, 0x010fe40003fbd000ULL,
0x0000009500277245ULL, 0x000fe4000020d400ULL, 0x00000018ffb37819ULL, 0x000fc400000114b3ULL,
0x00000018ff227819ULL, 0x000fe20000011482ULL, 0x0000007c006a7306ULL, 0x0008e2000000d400ULL,
0x00000018ff217819ULL, 0x000fce0000011483ULL, 0x0000007d00927306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x010fe200078e00ffULL, 0x000000979600720bULL, 0x004fe20003f1d000ULL,
0x0000010083967824ULL, 0x040fe400078e00ffULL, 0x0001000083977824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00937306ULL, 0x000ea20000005400ULL,
0x000000016a6a5812ULL, 0x008fe400078efcffULL, 0x00000018ff967819ULL, 0x000fc40000011496ULL,
0x00000018ff977819ULL, 0x000fe40000011497ULL, 0x0000000127270812ULL, 0x000fe200078efcffULL,
0x0000007d00947306ULL, 0x000730000000d400ULL, 0x0000007c008d7306ULL, 0x000fe20000209400ULL,
0x000100007d7d7824ULL, 0x008fe200078e00ffULL, 0x000000939200720bULL, 0x004fe20003f9d000ULL,
0x0000010082927824ULL, 0x000fc400078e00ffULL, 0x0001000082937824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007c008e7306ULL, 0x0004e20000205400ULL,
0x00000018ff927819ULL, 0x000fe40000011492ULL, 0x00000018ff937819ULL, 0x000fc80000011493ULL,
0x0000000194944812ULL, 0x010fe200078efcffULL, 0x0000007d00987306ULL, 0x000fe20000209400ULL,
0x0000007c007c7245ULL, 0x004fe4000020d400ULL, 0x000000942727723eULL, 0x000fca00000010ffULL,
0x0000007d00997306ULL, 0x0005220000205400ULL, 0x0000008e8d00720bULL, 0x008fce0003fdd000ULL,
0x0000009f00a07306ULL, 0x000fe20000209400ULL, 0x0000007d007d7245ULL, 0x004fca000020d400ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000009f00a17306ULL, 0x0004e20000205400ULL,
0x000000999800720bULL, 0x010fce0003f1d000ULL, 0x0000007f00a67306ULL, 0x000fe20000009400ULL,
0x0000009f009f7245ULL, 0x004fca000020d400ULL, 0x000000017d7d0812ULL, 0x000fe400078efcffULL,
0x0000007f00a77306ULL, 0x000ea20000005400ULL, 0x000000a1a000720bULL, 0x008fce0003fdd000ULL,
0x0000008f00907306ULL, 0x000fec0000209400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x0000008f00917306ULL, 0x0007220000205400ULL, 0x000000a7a600720bULL, 0x004fce0003f1d000ULL,
0x0000006b008b7306ULL, 0x000fe20000209400ULL, 0x0000008f008f7245ULL, 0x008fce000020d400ULL,
0x0000006b008c7306ULL, 0x0004e20000205400ULL, 0x000000919000720bULL, 0x010fce0003fbd000ULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x0000006b006b7245ULL, 0x004fca000020d400ULL,
0x000000018f8f5812ULL, 0x000fe400078efcffULL, 0x000000a300a57306ULL, 0x0005220000205400ULL,
0x0000008c8b00720bULL, 0x008fe20003f7d000ULL, 0x00010000818c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000007f00897306ULL, 0x000ee2000000d400ULL,
0x000000a300a37245ULL, 0x004fca000020d400ULL, 0x000000016b6b3812ULL, 0x000fe400078efcffULL,
0x0000009a009b7306ULL, 0x000fe20000209400ULL, 0x000000a5a400720bULL, 0x010fce0003fdd000ULL,
0x0000009a009c7306ULL, 0x0005220000205400ULL, 0x0000000189890812ULL, 0x008fca00078efcffULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x000000ae00af7306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x004fce000020d400ULL, 0x000000ae00b07306ULL, 0x0004e20000205400ULL,
0x0000009c9b00720bULL, 0x010fce0003f9d000ULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x004fca000020d400ULL, 0x000000019a9a4812ULL, 0x000fe400078efcffULL,
0x000000a800aa7306ULL, 0x0005220000205400ULL, 0x000000b0af00720bULL, 0x008fce0003f1d000ULL,
0x0000007e009d7306ULL, 0x000fe20000009400ULL, 0x000000a800a87245ULL, 0x004fca000020d400ULL,
0x00000001aeae0812ULL, 0x000fe400078efcffULL, 0x0000007e009e7306ULL, 0x000ea20000005400ULL,
0x000000aaa900720bULL, 0x010fce0003fbd000ULL, 0x0000007e008a7306ULL, 0x00072c000000d400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000008000b17306ULL, 0x000fe20000009400ULL,
0x000100007e7e7824ULL, 0x008fe200078e00ffULL, 0x0000009e9d00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000008000b27306ULL, 0x000eae0000005400ULL,
0x000000018a8a3812ULL, 0x010fe200078efcffULL, 0x0000008000887306ULL, 0x000730000000d400ULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x0001000080807824ULL, 0x008fe200078e00ffULL,
0x000000b2b100720bULL, 0x004fc80003f7d000ULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x000000bb008b7306ULL, 0x0004ee0000205400ULL, 0x0000000188883812ULL, 0x010fe200078efcffULL,
0x0000008100b97306ULL, 0x000fe20000009400ULL, 0x000000bb00bb7245ULL, 0x004fce000020d400ULL,
0x0000008100ba7306ULL, 0x000fe20000005400ULL, 0x0000008bbc00720bULL, 0x008fce0003fdd000ULL,
0x0000008100867306ULL, 0x000fec000000d400ULL, 0x00000001bbbb6812ULL, 0x000fe400078efcffULL,
0x0000007e00a27306ULL, 0x000ff00000209400ULL, 0x0000007e007f7306ULL, 0x0004f00000205400ULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x004fce000020d400ULL,
0x000000ab00ad7306ULL, 0x000ea20000205400ULL, 0x0000007fa200720bULL, 0x008fe40003f9d000ULL,
0x000000ab007f7245ULL, 0x000fca000020d400ULL, 0x0000008000267306ULL, 0x000fec0000209400ULL,
0x000000017e7e4812ULL, 0x000fe400078efcffULL, 0x0000008000817306ULL, 0x0007220000205400ULL,
0x000000adac00720bULL, 0x004fe40003fbd000ULL, 0x0000007ea37e723eULL, 0x000fca00000010ffULL,
0x000000b600b77306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x008fca000020d400ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x000000b600b87306ULL, 0x000ea20000205400ULL,
0x000000812600720bULL, 0x010fe40003f1d000ULL, 0x000000bab900720bULL, 0x000fe40003fbd000ULL,
0x000000b600817245ULL, 0x000fe4000020d400ULL, 0x0000006a6b26723eULL, 0x000fe200000010ffULL,
0x0000008200bf7306ULL, 0x000fe20000009400ULL, 0x0000007c8f6a723eULL, 0x000fc400000010ffULL,
0x0000008a9f7c723eULL, 0x000fe400000010ffULL, 0x0000007d9a6b723eULL, 0x000fe200000010ffULL,
0x000000262844723cULL, 0x040f620000041844ULL, 0x0000000180800812ULL, 0x000fe200078efcffULL,
0x0000008200c07306ULL, 0x000fe20000005400ULL, 0x000000b8b700720bULL, 0x004fe40003fdd000ULL,
0x0000000186865812ULL, 0x000fe400078efcffULL, 0x00000089a87d723eULL, 0x000fe200000010ffULL,
0x0000006a2840723cULL, 0x000f620000041840ULL, 0x00000086bb89723eULL, 0x000fe200000010ffULL,
0x0000008200787306ULL, 0x000fe2000000d400ULL, 0x0000007fae7f723eULL, 0x000fca00000010ffULL,
0x0000000181816812ULL, 0x000fe200078efcffULL, 0x0000007c283c723cULL, 0x040f62000004183cULL,
0x0000008300c17306ULL, 0x000fee0000009400ULL, 0x0000007e2838723cULL, 0x000f620000041838ULL,
0x0000008300c27306ULL, 0x000eae0000005400ULL, 0x000000267064723cULL, 0x042f620000041864ULL,
0x0000008300257306ULL, 0x000e6e000000d400ULL, 0x0000007c705c723cULL, 0x000f62000004185cULL,
0x000000b300b47306ULL, 0x000fe20000209400ULL, 0x000000c2c100720bULL, 0x004fcc0003f7d000ULL,
0x0000007e7058723cULL, 0x040f620000041858ULL, 0x000000b300b57306ULL, 0x0004ec0000205400ULL,
0x0000000125253812ULL, 0x002fe200078efcffULL, 0x0000006a7060723cULL, 0x000b620000041860ULL,
0x0000008c00827306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x004fca000020d400ULL,
0x000126c8136a7811ULL, 0x020fe400078e18ffULL, 0x0000008c00837306ULL, 0x0002a20000205400ULL,
0x000000b5b400720bULL, 0x008fce0003f9d000ULL, 0x00000092008d7306ULL, 0x000fe20000209400ULL,
0x0000008c008c7245ULL, 0x002fca000020d400ULL, 0x00000001b3b34812ULL, 0x000fe400078efcffULL,
0x00000092008e7306ULL, 0x000e620000205400ULL, 0x000000838200720bULL, 0x004fe40003f1d000ULL,
0x000000c0bf00720bULL, 0x000fe40003f9d000ULL, 0x0000009200837245ULL, 0x000fe4000020d400ULL,
0x00000088b388723eULL, 0x000fe200000010ffULL, 0x0000008700bd7306ULL, 0x000fec0000209400ULL,
0x000000018c8c0812ULL, 0x000fe200078efcffULL, 0x000000882834723cULL, 0x000b620000041834ULL,
0x0000008700be7306ULL, 0x0004e20000205400ULL, 0x0000008e8d00720bULL, 0x002fc40003fdd000ULL,
0x0000000178784812ULL, 0x000fc800078efcffULL, 0x000000887054723cULL, 0x000b620000041854ULL,
0x0000009600907306ULL, 0x000fe20000209400ULL, 0x0000008700877245ULL, 0x004fca000020d400ULL,
0x0000000183836812ULL, 0x000fe400078efcffULL, 0x0000009600917306ULL, 0x0002a20000205400ULL,
0x000000bebd00720bULL, 0x008fce0003fbd000ULL, 0x00000022007a7306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x002fca000020d400ULL, 0x0000000187875812ULL, 0x000fe400078efcffULL,
0x00000022007b7306ULL, 0x0002e20000205400ULL, 0x000000919000720bULL, 0x004fce0003f1d000ULL,
0x0000002100847306ULL, 0x000fe20000209400ULL, 0x0000002200227245ULL, 0x002fca000020d400ULL,
0x0000000196960812ULL, 0x000fe400078efcffULL, 0x0000002100857306ULL, 0x000e620000205400ULL,
0x0000007b7a00720bULL, 0x008fe40003fbd000ULL, 0x00000080817a723eULL, 0x000fe400000010ffULL,
0x000000788380723eULL, 0x000fe400000010ffULL, 0x0000002100787245ULL, 0x000fe2000020d400ULL,
0x00000093008b7306ULL, 0x000fe20000209400ULL, 0x0000009700837245ULL, 0x000fc4000020d400ULL,
0x0000008c877b723eULL, 0x000fe400000010ffULL, 0x000000259681723eULL, 0x000fe400000010ffULL,
0x0000000122225812ULL, 0x000fe200078efcffULL, 0x0000009300827306ULL, 0x0004e20000205400ULL,
0x000000858400720bULL, 0x002fe20003fdd000ULL, 0x0000007a2830723cULL, 0x040b6c0000041830ULL,
0x00000097008d7306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x004fe2000020d400ULL,
0x00000080282c723cULL, 0x000b68000004182cULL, 0x0000000178786812ULL, 0x000fc400078efcffULL,
0x00000097008a7306ULL, 0x000e620000205400ULL, 0x000000828b00720bULL, 0x008fe20003f9d000ULL,
0x0000007a7050723cULL, 0x040b700000041850ULL, 0x00000080704c723cULL, 0x000b68000004184cULL,
0x0000000193934812ULL, 0x000fc400078efcffULL, 0x0000008a8d00720bULL, 0x002fe40003f1d000ULL,
0x000000932282723eULL, 0x000fd600000010ffULL, 0x0000000183830812ULL, 0x000fc800078efcffULL,
0x000000837883723eULL, 0x000fce00000010ffULL, 0x000000827048723cULL, 0x080b700000041848ULL,
0x000000822828723cULL, 0x000b62000004186cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126980023ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff217224ULL, 0x000fc600078e00ffULL, 0x0000000000227805ULL, 0x004fc80000015200ULL,
0x000004000d257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e23ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000121217810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f227810ULL, 0x000fc80007ffe0ffULL,
0x000000152200720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x000000020f227810ULL, 0x000fe40007ffe0ffULL, 0x000001000c217810ULL, 0x000fe40007ffe0ffULL,
0x000000152200720cULL, 0x000fc60003f06070ULL, 0x0000660012257a24ULL, 0x000fd400078e0221ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x00000021160c7217ULL, 0x000fe20007800000ULL,
0x00000010116b7824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fc60000011617ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a21ULL, 0x00000004276d7810ULL, 0x020fe20007ffe0ffULL,
0x000000016b227824ULL, 0x000fe200078e0227ULL, 0x00000008276f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c6b0c7217ULL, 0x000fe20007800000ULL, 0x0000000122217824ULL, 0x040fe200078e0217ULL,
0x0000000c27717810ULL, 0x000fe20007ffe0ffULL, 0x0000000822267824ULL, 0x000fe400078e00ffULL,
0x000000016b6e7824ULL, 0x000fc400078e026dULL, 0x0000000122227824ULL, 0x000fe200078e0225ULL,
0xfffffff826217812ULL, 0x000fe200078ee221ULL, 0x000000010c0c7824ULL, 0x000fe400078e0a6bULL,
0x000000016e267824ULL, 0x000fe400078e0225ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000000c2700720cULL, 0x080fe40003f06070ULL, 0x0000000c6d00720cULL, 0x080fe20003f86070ULL,
0x000000016b707824ULL, 0x000fe200078e026fULL, 0x0000000b226c7212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000c6f00720cULL, 0x000fc40003f66070ULL,
0x000062006c6c7a10ULL, 0x000fe20007fbe0ffULL, 0x00000001706a7824ULL, 0x000fe200078e0225ULL,
0x0000000b26267212ULL, 0x080fe200078efcffULL, 0x000000016b727824ULL, 0x000fe200078e0271ULL,
0x00006300236d7a10ULL, 0x000fe20002ffe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000620026267a10ULL, 0x000fe40007fde0ffULL, 0x0000000c7100720cULL, 0x000fe20003fa6070ULL,
0x0000000172227824ULL, 0x000fe200078e0225ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000016e257824ULL, 0x040fe200078e0217ULL, 0x0000630027277a10ULL, 0x000fe200037fe4ffULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0x000062006a6a7a10ULL, 0x000fe20007fde0ffULL,
0x0000008022227825ULL, 0x000fc600078e00ffULL, 0xfffffff86e257812ULL, 0x000fe200078ee225ULL,
0x00000001700c7824ULL, 0x100fe200078e0217ULL, 0x0000000b22227212ULL, 0x000fe200078efcffULL,
0x00000008706f7824ULL, 0x000fe200078e00ffULL, 0x000063006b6b7a10ULL, 0x000fe200037fe4ffULL,
0x00000001726e7824ULL, 0x000fe200078e0217ULL, 0x0000620022227a10ULL, 0x000fe20007fde0ffULL,
0x0000000872717824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee20cULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x0000630023237a10ULL, 0x000fe200037fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0xfffffff871717812ULL, 0x000fe200078ee26eULL,
0x000000106f6f7824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c217faeULL, 0x0003e6000c101c48ULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0x0000000026257faeULL, 0x0003e8000e101c48ULL, 0x000000006a6f7faeULL, 0x0003e8000d901c48ULL,
0x0000000022717faeULL, 0x0003e2000e901c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010110c7824ULL, 0x000fca00078e00ffULL, 0x0000000c170c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c267810ULL, 0x040fe20007ffe0ffULL, 0x000000010c217824ULL, 0x140fe200078e0217ULL,
0x000000080c6a7810ULL, 0x040fe20007ffe0ffULL, 0x000000080c6c7824ULL, 0x020fe400078e00ffULL,
0x0000000126227824ULL, 0x040fe400078e0217ULL, 0x00000008266f7824ULL, 0x000fe200078e00ffULL,
0xfffffff86c217812ULL, 0x000fe200078ee221ULL, 0x000000016a237824ULL, 0x040fe400078e0217ULL,
0x000000086a6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee222ULL,
0x000000010c227824ULL, 0x140fe200078e0225ULL, 0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000126267824ULL, 0x000fe200078e0225ULL, 0xfffffff86e717812ULL, 0x000fe200078ee223ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x000000016a6a7824ULL, 0x100fe200078e0225ULL,
0x0000000b22227212ULL, 0x000fe200078efcffULL, 0x000000010c6c7824ULL, 0x000fe400078e0225ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000620022227a10ULL, 0x000fc60007f1e0ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000630023237a10ULL, 0x000fe200007fe4ffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000000b6a6a7212ULL, 0x080fe400078efcffULL, 0x0000620026267a10ULL, 0x000fe20007f7e0ffULL,
0x000000010c257824ULL, 0x000fe200078e0217ULL, 0x0000000b6c6c7212ULL, 0x000fe200078efcffULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x000062006a6a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x000062006c6c7a10ULL, 0x000fe20007f9e0ffULL,
0x000000106f6f7824ULL, 0x100fe200078e0200ULL, 0xfffffff80c257812ULL, 0x000fe200078ee225ULL,
0x0000001071717824ULL, 0x100fe200078e0200ULL, 0x0000630027277a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022217faeULL, 0x0003e2000b901c48ULL,
0x000063006b6b7a10ULL, 0x000fe200007fe4ffULL, 0x0000001025257824ULL, 0x000fe200078e0200ULL,
0x000063006d6d7a10ULL, 0x000fe200027fe4ffULL, 0x00000000266f7faeULL, 0x0003e8000b901c48ULL,
0x000000006a717faeULL, 0x0003e8000b901c48ULL, 0x000000006c257faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000814217812ULL, 0x000fe200078ec0ffULL,
0x00000020100c7824ULL, 0x000fc400078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x00000001210c7824ULL, 0x000fe200078e020cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000008227f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012668000c6a7f8cULL, 0x000662000c80043fULL,
0x000000ffff217224ULL, 0x004fc600078e0023ULL, 0x0000000000227805ULL, 0x000fc80000015200ULL,
0x01266c000c257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fe4000780486bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6c7224ULL, 0x020fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622257210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e23ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011426ULL,
0x0000002508087211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0626ULL,
0x0000000208087819ULL, 0x000fc80000001225ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01266c000c257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018010087811ULL, 0x000fc800078e38ffULL, 0x000000080a087210ULL, 0x000fca0007ffe00bULL,
0x01200000086d7984ULL, 0x000e680000000800ULL, 0x01220000080c7984ULL, 0x0084e20000000800ULL,
0x000000206d00720bULL, 0x002fe20003f1d000ULL, 0x0000dd427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x004fc800000e0100ULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x00000001ff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e0020ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x0000000310237810ULL, 0x000fe40007ffe0ffULL, 0x000000206d00720bULL, 0x000fe40003f74000ULL,
0x0000001a2300720cULL, 0x000fe20003f05270ULL, 0x0000dcf27f007947ULL, 0x000fd4000b800000ULL,
0x00000000006f7806ULL, 0x000fc400018e0100ULL, 0x000000801a0b8824ULL, 0x000fe200078e020bULL,
0x000000206d237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a0a8824ULL, 0x000fca00078e020bULL, 0x012400230a008388ULL, 0x0003e20000000800ULL,
0x000000ff6f00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x00000020230a7221ULL, 0x002fe20000010100ULL, 0x000000ff6fff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL,
0x0000000a00277308ULL, 0x000e640000000800ULL, 0x0000002724247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x0000dc327f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002a400000e0000ULL,
0x0000002664647220ULL, 0x084fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006fff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x0000daf27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00046400000e0000ULL, 0x0000002666667220ULL, 0x086fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006fff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x0000d9b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00046400000e0000ULL,
0x0000002644447220ULL, 0x086fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x0000d8827f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00046400000e0000ULL,
0x0000002646467220ULL, 0x086fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006f08ff7212ULL, 0x000fda00078030ffULL,
0x0000006d236d0221ULL, 0x000fe20000010100ULL, 0x00007610ff220816ULL, 0x000fc60000000022ULL,
0x3fb8aa3b6d6d0820ULL, 0x000fc80000410000ULL, 0x0000006d00090308ULL, 0x000e640000000800ULL,
0x000000090c0c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000240c247221ULL, 0x008fc20000010000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0xfffffff014207812ULL, 0x000fca00078ec0ffULL, 0x0126b40020257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x000000260a257210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e0bULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011426ULL, 0x0000002508087211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0626ULL, 0x0000000208087819ULL, 0x000fc80000001225ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b40020257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991022087816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff087819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x0000d4527f007947ULL, 0x000fea000b800000ULL, 0x00001f0827077589ULL, 0x0002a400000e0000ULL,
0x0000000808267810ULL, 0x000fe20007ffe0ffULL, 0x0000d4727f007947ULL, 0x000fea000b800000ULL,
0x0000001008047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x0000001808267810ULL, 0x008fe20007ffe0ffULL,
0x0000d4a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000113087812ULL, 0x002fe200078ec0ffULL,
0x0000000803257824ULL, 0x000fe200078e00ffULL, 0x00000004ff0b7819ULL, 0x000fe20000011617ULL,
0x0000000802277824ULL, 0x008fe200078e00ffULL, 0x0000100000007810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x0000000408087824ULL, 0x000fc400078e020bULL, 0x000000041a0b7824ULL, 0x000fe400078e00ffULL,
0x00000001030a7824ULL, 0x100fe400078e0208ULL, 0x0000000102087824ULL, 0x000fe200078e0208ULL,
0x000000040b0c7812ULL, 0x000fe200078ec0ffULL, 0x000000101c787824ULL, 0x000fe200078e0200ULL,
0xfffffff8250b7812ULL, 0x000fe400078ee20aULL, 0xfffffff827257812ULL, 0x000fe400078ee208ULL,
0x0000d000100a7811ULL, 0x000fc400078e60ffULL, 0x000000020c0c7812ULL, 0x000fc600078efcffULL,
0x000000100b0b7824ULL, 0x100fe200078e020aULL, 0x0000000c17087211ULL, 0x000fe200078fe0ffULL,
0x0000001025257824ULL, 0x000fe400078e020aULL, 0x00000008030c7824ULL, 0x040fe200078e00ffULL,
0x000000000b6c783bULL, 0x0002e20000000200ULL, 0x0000000103037824ULL, 0x000fc600078e0208ULL,
0x000000002568783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x000000076c6c7231ULL, 0x08cfe400003400ffULL, 0x000000076e6e7231ULL, 0x000fe400003400ffULL,
0x000000066d6d7231ULL, 0x080fe400003400ffULL, 0x000000066f6f7231ULL, 0x000fe400003400ffULL,
0x0000000568687231ULL, 0x080fe400003400ffULL, 0x000000056a6a7231ULL, 0x000fc400003400ffULL,
0x0000000469697231ULL, 0x080fe400003400ffULL, 0x000000046b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0xfffffff80c037812ULL, 0x000fe200078ee203ULL, 0x000000101e1e7824ULL, 0x000fe200078e020aULL,
0x00000fa000007945ULL, 0x000fe20003800000ULL, 0x0000000102087824ULL, 0x000fe400078e0208ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000370783bULL, 0x000e620000004200ULL,
0x0000010078807824ULL, 0x010fe200078e00ffULL, 0x0000007800267306ULL, 0x000fe20000009400ULL,
0x0000010079837824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011478ULL,
0x000001007a967824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x000001007b997824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe40000011483ULL,
0x0000008000817306ULL, 0x000fe20000209400ULL, 0x00000018ff907819ULL, 0x000fe20000011479ULL,
0x0000010070ab7824ULL, 0x002fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fc40000011470ULL,
0x00000018ff9b7819ULL, 0x000fe4000001147aULL, 0x00000018ff967819ULL, 0x000fe20000011496ULL,
0x0000008000827306ULL, 0x000e620000205400ULL, 0x00000018ffa17819ULL, 0x000fe40000011499ULL,
0x00000018ffab7819ULL, 0x000fe400000114abULL, 0x00000018ffa67819ULL, 0x000fe4000001147bULL,
0x00000018ffb27819ULL, 0x000fe20000011471ULL, 0x0000007800277306ULL, 0x000f220000005400ULL,
0x00000018ff0c7819ULL, 0x000fc40000011472ULL, 0x00000018ff1c7819ULL, 0x000fca0000011473ULL,
0x00000078007f7306ULL, 0x0006a2000000d400ULL, 0x000000828100720bULL, 0x002fce0003fdd000ULL,
0x0000008b008c7306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x008fe200078e00ffULL,
0x000000272600720bULL, 0x010fe20003fbd000ULL, 0x0000010071267824ULL, 0x000fe200078e00ffULL,
0x0000008b00277245ULL, 0x000fe4000020d400ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000008b008d7306ULL, 0x000e6e0000205400ULL, 0x000000017f7f5812ULL, 0x004fe200078efcffULL,
0x0000007800837306ULL, 0x000ff00000209400ULL, 0x0000007800847306ULL, 0x000ea20000205400ULL,
0x0000008d8c00720bULL, 0x002fc40003f7d000ULL, 0x00000018ff8c7819ULL, 0x000fe40000011426ULL,
0x0000008000267245ULL, 0x000fc6000020d400ULL, 0x0000007900887306ULL, 0x000fe20000009400ULL,
0x0000000126266812ULL, 0x000fc800078efcffULL, 0x0000007f2626723eULL, 0x000fe400000010ffULL,
0x0000000127273812ULL, 0x000fe200078efcffULL, 0x0000007900897306ULL, 0x000e620000005400ULL,
0x000000848300720bULL, 0x004fe40003fdd000ULL, 0x000000b2007f7245ULL, 0x000fca000020d400ULL,
0x00000079008a7306ULL, 0x0004f0000000d400ULL, 0x0000007a00937306ULL, 0x000fe20000009400ULL,
0x0001000079797824ULL, 0x004fe200078e00ffULL, 0x000000898800720bULL, 0x002fc80003f9d000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007a00947306ULL, 0x000fee0000005400ULL,
0x000000018a8a4812ULL, 0x008fe200078efcffULL, 0x0000008500867306ULL, 0x000fe60000209400ULL,
0x0000008a2727723eULL, 0x000fca00000010ffULL, 0x0000008500877306ULL, 0x0002a40000205400ULL,
0x000000266c64723cULL, 0x080f6c0000041864ULL, 0x0000009000917306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x002fe2000020d400ULL, 0x000000266844723cULL, 0x000f6c0000041844ULL,
0x0000009000927306ULL, 0x0002e20000205400ULL, 0x000000878600720bULL, 0x004fce0003fbd000ULL,
0x0000007000a97306ULL, 0x000fe20000009400ULL, 0x0000009000907245ULL, 0x002fca000020d400ULL,
0x0000000185855812ULL, 0x000fe400078efcffULL, 0x0000007000aa7306ULL, 0x000fe20000005400ULL,
0x000000929100720bULL, 0x008fce0003f9d000ULL, 0x00000070007c7306ULL, 0x0003ec000000d400ULL,
0x0000000190904812ULL, 0x000fe400078efcffULL, 0x00000079008e7306ULL, 0x000fe20000209400ULL,
0x0001000070707824ULL, 0x002fca00078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011470ULL,
0x00000079008f7306ULL, 0x0002a20000205400ULL, 0x0000007800707245ULL, 0x000fe2000020d400ULL,
0x0001000071787824ULL, 0x000fc600078e00ffULL, 0x0000000170706812ULL, 0x000fe400078efcffULL,
0x000000949300720bULL, 0x000fe20003fdd000ULL, 0x0000007a00957306ULL, 0x000722000000d400ULL,
0x0000007900797245ULL, 0x002fe4000020d400ULL, 0x00000018ff847819ULL, 0x000fe20000011478ULL,
0x0000010072787824ULL, 0x000fe200078e00ffULL, 0x000000708570723eULL, 0x000fc600000010ffULL,
0x0000009b009c7306ULL, 0x000fe20000209400ULL, 0x000100007a7a7824ULL, 0x008fe200078e00ffULL,
0x0000008f8e00720bULL, 0x004fe40003f7d000ULL, 0x00000018ff897819ULL, 0x000fe40000011478ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000009b009d7306ULL, 0x0002a20000205400ULL,
0x0000000195956812ULL, 0x010fe400078efcffULL, 0x0000007a00787245ULL, 0x000fc8000020d400ULL,
0x0000000179793812ULL, 0x000fe200078efcffULL, 0x0000007b009e7306ULL, 0x000fe20000009400ULL,
0x0000009b009b7245ULL, 0x002fce000020d400ULL, 0x0000007b009f7306ULL, 0x000e620000005400ULL,
0x0000009d9c00720bULL, 0x004fce0003fdd000ULL, 0x0000009600977306ULL, 0x000fec0000209400ULL,
0x000000019b9b6812ULL, 0x000fe400078efcffULL, 0x0000009600987306ULL, 0x0004e20000205400ULL,
0x0000009f9e00720bULL, 0x002fce0003f9d000ULL, 0x000000a100a27306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x004fce000020d400ULL, 0x000000a100a37306ULL, 0x0002a20000205400ULL,
0x000000989700720bULL, 0x008fce0003fbd000ULL, 0x0000007b00a07306ULL, 0x000722000000d400ULL,
0x000000a100a17245ULL, 0x002fca000020d400ULL, 0x0000000196965812ULL, 0x000fe400078efcffULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x008fe200078e00ffULL,
0x000000a3a200720bULL, 0x004fc80003f7d000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000ab00817306ULL, 0x0002a20000205400ULL, 0x00000001a0a04812ULL, 0x010fcc00078efcffULL,
0x00000001a1a13812ULL, 0x000fe200078efcffULL, 0x000000a600a77306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fce000020d400ULL, 0x000000a600a87306ULL, 0x0002e20000205400ULL,
0x00000081ac00720bULL, 0x004fe20003fdd000ULL, 0x0000010073817824ULL, 0x000fcc00078e00ffULL,
0x0000007a00997306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x002fca000020d400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x0000007a009a7306ULL, 0x000e620000205400ULL,
0x000000a8a700720bULL, 0x008fce0003f9d000ULL, 0x0000007b00a47306ULL, 0x000fec0000209400ULL,
0x00000001a6a64812ULL, 0x000fe400078efcffULL, 0x0000007b00a57306ULL, 0x0004e20000205400ULL,
0x0000009a9900720bULL, 0x002fce0003fbd000ULL, 0x0000007100b07306ULL, 0x000fe20000009400ULL,
0x0000007b007b7245ULL, 0x004fca000020d400ULL, 0x0000000178785812ULL, 0x000fe400078efcffULL,
0x0000007100b17306ULL, 0x000e620000005400ULL, 0x000000a5a400720bULL, 0x008fe40003f7d000ULL,
0x000000aaa900720bULL, 0x000fe40003fbd000ULL, 0x000000789b78723eULL, 0x000fc600000010ffULL,
0x0000007100227306ULL, 0x000eac000000d400ULL, 0x000000017b7b3812ULL, 0x000fe400078efcffULL,
0x0000008000827306ULL, 0x000fe20000209400ULL, 0x000000b1b000720bULL, 0x002fe40003f9d000ULL,
0x000000017c7c5812ULL, 0x000fc800078efcffULL, 0x0000007cab7c723eULL, 0x000fe200000010ffULL,
0x0000008000717306ULL, 0x0002ec0000205400ULL, 0x0000000122224812ULL, 0x004fe400078efcffULL,
0x0000008c00887306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fce000020d400ULL,
0x0000008c00837306ULL, 0x000e620000205400ULL, 0x000000718200720bULL, 0x008fe40003fdd000ULL,
0x000000799071723eULL, 0x000fe400000010ffULL, 0x0000007ba679723eULL, 0x000fc600000010ffULL,
0x0000008400867306ULL, 0x000fe40000209400ULL, 0x000000706c60723cULL, 0x040f680000041860ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x0000008400877306ULL, 0x0004e20000205400ULL,
0x000000838800720bULL, 0x002fe20003f7d000ULL, 0x000000786c58723cULL, 0x000f620000041858ULL,
0x00000018ff887819ULL, 0x000fc40000011481ULL, 0x0000008c00817245ULL, 0x000fc6000020d400ULL,
0x000000ad00ae7306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x004fe2000020d400ULL,
0x000000706840723cULL, 0x040f680000041840ULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x000000ad00af7306ULL, 0x0002a20000205400ULL, 0x000000878600720bULL, 0x008fe20003fdd000ULL,
0x000000786838723cULL, 0x000f6c0000041838ULL, 0x000000b200b37306ULL, 0x000fe20000209400ULL,
0x000000ad00ad7245ULL, 0x002fca000020d400ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x000000b200b47306ULL, 0x000e620000205400ULL, 0x000000afae00720bULL, 0x004fce0003fbd000ULL,
0x00000073007e7306ULL, 0x000fec0000009400ULL, 0x00000001adad5812ULL, 0x000fe400078efcffULL,
0x00000073007d7306ULL, 0x000ea20000005400ULL, 0x000000b4b300720bULL, 0x002fe40003f9d000ULL,
0x00000080ad80723eULL, 0x000fca00000010ffULL, 0x0000007200b57306ULL, 0x000fec0000009400ULL,
0x000000017f7f4812ULL, 0x000fe400078efcffULL, 0x0000007200b67306ULL, 0x000e620000005400ULL,
0x0000007d7e00720bULL, 0x004fe40003fdd000ULL, 0x00000022817d723eULL, 0x000fc400000010ffULL,
0x000000847f81723eULL, 0x000fc600000010ffULL, 0x00000089007a7306ULL, 0x000fe40000209400ULL,
0x0000007c6c54723cULL, 0x040f6c0000041854ULL, 0x00000089008b7306ULL, 0x000ea20000205400ULL,
0x000000b6b500720bULL, 0x002fe20003f7d000ULL, 0x000000806c50723cULL, 0x000f6c0000041850ULL,
0x00000088008d7306ULL, 0x000fe40000209400ULL, 0x0000007c6834723cULL, 0x040f6c0000041834ULL,
0x00000088008c7306ULL, 0x0002e20000205400ULL, 0x0000008b7a00720bULL, 0x004fe20003fbd000ULL,
0x000000806830723cULL, 0x000f620000041830ULL, 0x00000089007a7245ULL, 0x000fca000020d400ULL,
0x0000007200037306ULL, 0x000522000000d400ULL, 0x0000008800887245ULL, 0x002fca000020d400ULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x00000073000b7306ULL, 0x000322000000d400ULL,
0x0001000072727824ULL, 0x004fe200078e00ffULL, 0x0000008c8d00720bULL, 0x008fc80003f9d000ULL,
0x00000018ff827819ULL, 0x000fe40000011472ULL, 0x0000000c00757306ULL, 0x000fe20000209400ULL,
0x0001000073737824ULL, 0x002fe200078e00ffULL, 0x0000000103033812ULL, 0x010fe400078efcffULL,
0x000000959672723eULL, 0x000fe400000010ffULL, 0x00000018ff857819ULL, 0x000fe40000011473ULL,
0x0000000c00767306ULL, 0x000e620000205400ULL, 0x0000000188884812ULL, 0x000fc400078efcffULL,
0x000000010b0b6812ULL, 0x000fe400078efcffULL, 0x000000037a7a723eULL, 0x000fe400000010ffULL,
0x0000000c00037245ULL, 0x000fe2000020d400ULL, 0x0000001c00257306ULL, 0x000fe20000209400ULL,
0x000000a0a173723eULL, 0x000fe400000010ffULL, 0x0000000b887b723eULL, 0x000fe200000010ffULL,
0x00000008020b7824ULL, 0x000fc800078e00ffULL, 0x0000001c00207306ULL, 0x0004e20000205400ULL,
0x000000767500720bULL, 0x002fe20003fbd000ULL, 0x000000726c5c723cULL, 0x040f6c000004185cULL,
0x0000008200837306ULL, 0x000fe20000209400ULL, 0x0000001c001c7245ULL, 0x004fe2000020d400ULL,
0x0000007a6c4c723cULL, 0x000f68000004184cULL, 0x0000000103035812ULL, 0x000fc400078efcffULL,
0x0000008200867306ULL, 0x0002a20000205400ULL, 0x000000202500720bULL, 0x008fe20003f7d000ULL,
0x00000072683c723cULL, 0x040f6c000004183cULL, 0x0000008500877306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x002fe2000020d400ULL, 0x0000007a682c723cULL, 0x000f68000004182cULL,
0x000000011c1c3812ULL, 0x000fc400078efcffULL, 0x00000085007e7306ULL, 0x000e620000205400ULL,
0x000000868300720bULL, 0x004fe40003f9d000ULL, 0x0000008500837245ULL, 0x000fd6000020d400ULL,
0x0000000182824812ULL, 0x000fe400078efcffULL, 0x0000007e8700720bULL, 0x002fe40003fdd000ULL,
0x000000820382723eULL, 0x000fe200000010ffULL, 0x000000101d037824ULL, 0x000fd400078e020aULL,
0x0000000183836812ULL, 0x000fc800078efcffULL, 0x000000831c83723eULL, 0x000fce00000010ffULL,
0x000000826c48723cULL, 0x080b6e0000041848ULL, 0x000000101f6c7824ULL, 0x020fe200078e0200ULL,
0x000000826828723cULL, 0x000b620000041828ULL, 0x000000001e1c783bULL, 0x000e680000000200ULL,
0x000000000368783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fda0003800000ULL,
0x0000000768687231ULL, 0x088fe400003400ffULL, 0x000000076a6a7231ULL, 0x000fc400003400ffULL,
0x0000000669697231ULL, 0x080fe400003400ffULL, 0x000000066b6b7231ULL, 0x000fe400003400ffULL,
0x000000051c1c7231ULL, 0x082fe400003400ffULL, 0x000000051e1e7231ULL, 0x000fe400003400ffULL,
0x000000041d1d7231ULL, 0x080fe400003400ffULL, 0x000000041f1f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000006c6c783bULL, 0x000f220000004200ULL,
0xfffffff80b037812ULL, 0x004fca00078ee208ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000370783bULL, 0x000ea20000004200ULL, 0x000001006c277824ULL, 0x010fe200078e00ffULL,
0x0000006c000a7306ULL, 0x000fe20000009400ULL, 0x000001006d7a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001146cULL, 0x000100006d847824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x000001006f967824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001147aULL, 0x000001006e8d7824ULL, 0x000fe200078e00ffULL,
0x0000002700787306ULL, 0x000fe20000209400ULL, 0x00000018ff877819ULL, 0x000fe2000001146dULL,
0x00000100709e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x0000010071a17824ULL, 0x000fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fc40000011496ULL,
0x00000018ff9e7819ULL, 0x000fe2000001149eULL, 0x0000002700797306ULL, 0x0005220000205400ULL,
0x00000018ffa87819ULL, 0x000fe400000114a1ULL, 0x00000018ffa37819ULL, 0x000fe40000011470ULL,
0x00000018ff907819ULL, 0x000fe4000001146eULL, 0x00000018ffae7819ULL, 0x000fe20000011471ULL,
0x0000006c000b7306ULL, 0x000ee20000005400ULL, 0x0000002700277245ULL, 0x004fc4000020d400ULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff997819ULL, 0x000fe4000001146fULL,
0x00000018ff007819ULL, 0x000fe20000011473ULL, 0x0000006c00267306ULL, 0x000462000000d400ULL,
0x000000797800720bULL, 0x010fe40003fbd000ULL, 0x000000a800797245ULL, 0x000fe4000020d400ULL,
0x00000018ff087819ULL, 0x000fc60000011472ULL, 0x0000008100827306ULL, 0x000fe20000209400ULL,
0x000100006c6c7824ULL, 0x004fe200078e00ffULL, 0x0000000b0a00720bULL, 0x008fe20003f1d000ULL,
0x00000100730a7824ULL, 0x000fe200078e00ffULL, 0x00000081000b7245ULL, 0x000fe4000020d400ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000008100837306ULL, 0x000ea20000205400ULL,
0x0000000127275812ULL, 0x000fcc00078efcffULL, 0x0000000126260812ULL, 0x002fe200078efcffULL,
0x0000006d007e7306ULL, 0x000ff00000009400ULL, 0x0000006d007f7306ULL, 0x000e620000005400ULL,
0x000000838200720bULL, 0x004fe20003f7d000ULL, 0x0001000073837824ULL, 0x000fca00078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0000006d00807306ULL, 0x000eac000000d400ULL,
0x000000010b0b3812ULL, 0x000fe400078efcffULL, 0x0000006c007a7306ULL, 0x000fe20000209400ULL,
0x0000007f7e00720bULL, 0x002fe20003fdd000ULL, 0x00010000727f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000006c006d7306ULL, 0x0002ec0000205400ULL,
0x0000000180806812ULL, 0x004fe400078efcffULL, 0x0000007b007c7306ULL, 0x000fe20000209400ULL,
0x0000006c006c7245ULL, 0x002fc4000020d400ULL, 0x000000800b0b723eULL, 0x000fca00000010ffULL,
0x0000007b007d7306ULL, 0x0002a20000205400ULL, 0x0000006d7a00720bULL, 0x008fce0003fbd000ULL,
0x0000008700887306ULL, 0x000fe20000209400ULL, 0x0000007b007b7245ULL, 0x002fca000020d400ULL,
0x000000016c6c5812ULL, 0x000fe400078efcffULL, 0x0000008700897306ULL, 0x0002e20000205400ULL,
0x0000007d7c00720bULL, 0x004fe40003f9d000ULL, 0x00000018ff7c7819ULL, 0x000fca000001140aULL,
0x0000008400857306ULL, 0x000fe20000209400ULL, 0x0000008700877245ULL, 0x002fca000020d400ULL,
0x000000017b7b4812ULL, 0x000fe400078efcffULL, 0x0000008400867306ULL, 0x0002a20000205400ULL,
0x000000898800720bULL, 0x008fce0003f1d000ULL, 0x0000006e008a7306ULL, 0x000fe20000009400ULL,
0x0000008400847245ULL, 0x002fca000020d400ULL, 0x0000000187870812ULL, 0x000fe400078efcffULL,
0x0000006e008b7306ULL, 0x000e620000005400ULL, 0x000000868500720bULL, 0x004fce0003f7d000ULL,
0x0000009600977306ULL, 0x000fec0000209400ULL, 0x0000000184843812ULL, 0x000fe400078efcffULL,
0x0000009600987306ULL, 0x0004e20000205400ULL, 0x0000008b8a00720bULL, 0x002fce0003fbd000ULL,
0x0000006f00937306ULL, 0x000fe20000009400ULL, 0x0000009600967245ULL, 0x004fce000020d400ULL,
0x0000006f00947306ULL, 0x000e620000005400ULL, 0x000000989700720bULL, 0x008fce0003f9d000ULL,
0x0000009e009f7306ULL, 0x000fec0000209400ULL, 0x0000000196964812ULL, 0x000fe400078efcffULL,
0x0000009e00a07306ULL, 0x000ea20000205400ULL, 0x000000949300720bULL, 0x002fce0003f7d000ULL,
0x00000070009c7306ULL, 0x000ff00000009400ULL, 0x00000070009d7306ULL, 0x000fe20000005400ULL,
0x000000a09f00720bULL, 0x004fce0003f1d000ULL, 0x0000007000207306ULL, 0x0003f0000000d400ULL,
0x0000006e008c7306ULL, 0x0004e2000000d400ULL, 0x0001000070707824ULL, 0x002fca00078e00ffULL,
0x00000018ffa17819ULL, 0x000fe20000011470ULL, 0x0001000071707824ULL, 0x000fe200078e00ffULL,
0x000000a800a97306ULL, 0x000fe20000209400ULL, 0x000100006e6e7824ULL, 0x004fc600078e00ffULL,
0x00000018ffab7819ULL, 0x000fe20000011470ULL, 0x0000010072707824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x000000a800aa7306ULL, 0x000e620000205400ULL,
0x000000018c8c5812ULL, 0x008fe400078efcffULL, 0x00000018ff787819ULL, 0x000fca0000011470ULL,
0x0000007100a67306ULL, 0x000ff00000009400ULL, 0x0000007100a77306ULL, 0x000ea20000005400ULL,
0x000000aaa900720bULL, 0x002fce0003fbd000ULL, 0x0000006f00957306ULL, 0x0002ec000000d400ULL,
0x0000000179795812ULL, 0x000fe400078efcffULL, 0x00000071000c7306ULL, 0x000f22000000d400ULL,
0x000100006f6f7824ULL, 0x002fe200078e00ffULL, 0x000000a7a600720bULL, 0x004fc80003f9d000ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x0000000195953812ULL, 0x008fce00078efcffULL, 0x000000a300a57306ULL, 0x000fe20000205400ULL,
0x000000010c0c4812ULL, 0x010fce00078efcffULL, 0x000000a100a27306ULL, 0x000ff00000209400ULL,
0x000000a100717306ULL, 0x0002b00000205400ULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x000000a100a17245ULL, 0x002fce000020d400ULL, 0x000000ab00ad7306ULL, 0x0002e20000205400ULL,
0x00000071a200720bULL, 0x004fce0003f7d000ULL, 0x0000008d008e7306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fca000020d400ULL, 0x00000001a1a13812ULL, 0x000fe400078efcffULL,
0x0000008d008f7306ULL, 0x0002a20000205400ULL, 0x000000adac00720bULL, 0x008fce0003fbd000ULL,
0x0000006e000a7306ULL, 0x000fe20000209400ULL, 0x0000008d008d7245ULL, 0x002fca000020d400ULL,
0x00000001abab5812ULL, 0x000fe400078efcffULL, 0x0000006e006d7306ULL, 0x000e620000205400ULL,
0x0000008f8e00720bULL, 0x004fce0003fdd000ULL, 0x0000007300b37306ULL, 0x000fec0000009400ULL,
0x000000018d8d6812ULL, 0x000fe400078efcffULL, 0x0000007300b47306ULL, 0x000ea20000005400ULL,
0x0000006d0a00720bULL, 0x002fe40003f9d000ULL, 0x0000006e006d7245ULL, 0x000fc4000020d400ULL,
0x0000009d9c00720bULL, 0x000fe40003fdd000ULL, 0x00000026270a723eULL, 0x000fe200000010ffULL,
0x0000007300027306ULL, 0x0002e2000000d400ULL, 0x0000006c7b26723eULL, 0x000fe400000010ffULL,
0x00000090006c7245ULL, 0x000fe4000020d400ULL, 0x000000848727723eULL, 0x000fe200000010ffULL,
0x0000000a6864723cULL, 0x000b620000041864ULL, 0x000000016d6d4812ULL, 0x000fe200078efcffULL,
0x0000009000917306ULL, 0x000fe20000209400ULL, 0x0000009e00737245ULL, 0x002fc4000020d400ULL,
0x0000000120206812ULL, 0x000fe400078efcffULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x000000266860723cULL, 0x000b620000041860ULL, 0x000000a5a400720bULL, 0x000fe20003f1d000ULL,
0x0000009000927306ULL, 0x000fe20000205400ULL, 0x000000b4b300720bULL, 0x004fe40003f7d000ULL,
0x0000008c8d6e723eULL, 0x000fc600000010ffULL, 0x0000000a1c44723cULL, 0x040b640000041844ULL,
0x0000006f00707306ULL, 0x000fec0000209400ULL, 0x0000000102023812ULL, 0x008fe200078efcffULL,
0x000000261c40723cULL, 0x000b620000041840ULL, 0x0000006f00717306ULL, 0x000e700000205400ULL,
0x00000099009a7306ULL, 0x000ff00000209400ULL, 0x00000099009b7306ULL, 0x0004e20000205400ULL,
0x000000717000720bULL, 0x002fc40003fbd000ULL, 0x0000006f00707245ULL, 0x000fe4000020d400ULL,
0x0000000c7971723eULL, 0x000fe400000010ffULL, 0x00000095966f723eULL, 0x000fe200000010ffULL,
0x0000007200b17306ULL, 0x000fe20000009400ULL, 0x0000009900997245ULL, 0x004fca000020d400ULL,
0x0000000170705812ULL, 0x000fe200078efcffULL, 0x0000006e685c723cULL, 0x000b62000004185cULL,
0x0000007200b27306ULL, 0x000e620000005400ULL, 0x0000009b9a00720bULL, 0x008fcc0003f9d000ULL,
0x0000006e1c3c723cULL, 0x000b62000004183cULL, 0x0000007200037306ULL, 0x0004ec000000d400ULL,
0x0000000199994812ULL, 0x000fe400078efcffULL, 0x000000ae00af7306ULL, 0x000fe20000209400ULL,
0x000000a300727245ULL, 0x004fc4000020d400ULL, 0x000000b2b100720bULL, 0x002fe40003fdd000ULL,
0x0000000172720812ULL, 0x000fe400078efcffULL, 0x000000929100720bULL, 0x000fe20003f1d000ULL,
0x000000ae00b07306ULL, 0x0002a20000205400ULL, 0x000000a17272723eULL, 0x000fce00000010ffULL,
0x00000078007e7306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x002fe4000020d400ULL,
0x0000000103036812ULL, 0x008fe400078efcffULL, 0x000000016c6c0812ULL, 0x000fc600078efcffULL,
0x00000078007d7306ULL, 0x0002e20000205400ULL, 0x000000b0af00720bULL, 0x004fe40003f1d000ULL,
0x0000006d6c6c723eULL, 0x000fe400000010ffULL, 0x00000070996d723eULL, 0x000fe400000010ffULL,
0x000000207370723eULL, 0x000fe200000010ffULL, 0x0000007c00817306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fc6000020d400ULL, 0x0000006c6858723cULL, 0x040b640000041858ULL,
0x00000001aeae0812ULL, 0x000fe400078efcffULL, 0x0000007c00827306ULL, 0x000e620000205400ULL,
0x0000007d7e00720bULL, 0x008fe40003fbd000ULL, 0x000000abae73723eULL, 0x000fe200000010ffULL,
0x000000706854723cULL, 0x040b680000041854ULL, 0x0000000800257306ULL, 0x000fe80000209400ULL,
0x000000726850723cULL, 0x000b640000041850ULL, 0x0000000178785812ULL, 0x000fc400078efcffULL,
0x0000000800767306ULL, 0x0004e20000205400ULL, 0x000000828100720bULL, 0x002fe40003f9d000ULL,
0x000000037878723eULL, 0x000fe200000010ffULL, 0x000000701c34723cULL, 0x000b620000041834ULL,
0x0000008300037245ULL, 0x000fc6000020d400ULL, 0x0000000000757306ULL, 0x000fe20000209400ULL,
0x0000000800087245ULL, 0x004fc6000020d400ULL, 0x000000721c30723cULL, 0x040b680000041830ULL,
0x0000000000227306ULL, 0x0002a20000205400ULL, 0x000000762500720bULL, 0x008fe40003f1d000ULL,
0x0000007c00257245ULL, 0x000fe2000020d400ULL, 0x0000006c1c38723cULL, 0x000b660000041838ULL,
0x0000000125254812ULL, 0x000fe200078efcffULL, 0x0000007f007a7306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x002fc4000020d400ULL, 0x000000022579723eULL, 0x000fc600000010ffULL,
0x0000000108080812ULL, 0x000fe400078efcffULL, 0x0000007f007b7306ULL, 0x0002e20000205400ULL,
0x000000227500720bULL, 0x004fe20003fbd000ULL, 0x00000078684c723cULL, 0x080b6c000004184cULL,
0x00000083007d7306ULL, 0x000fe20000209400ULL, 0x0000007f007f7245ULL, 0x002fe2000020d400ULL,
0x000000781c2c723cULL, 0x000b68000004182cULL, 0x0000000100005812ULL, 0x000fc400078efcffULL,
0x00000083007e7306ULL, 0x000e620000205400ULL, 0x0000007b7a00720bULL, 0x008fda0003fdd000ULL,
0x000000017f7f6812ULL, 0x000fe400078efcffULL, 0x0000007e7d00720bULL, 0x002fe40003f9d000ULL,
0x0000007f0802723eULL, 0x000fd600000010ffULL, 0x0000000103034812ULL, 0x000fc800078efcffULL,
0x000000030003723eULL, 0x000fce00000010ffULL, 0x000000026848723cULL, 0x080b700000041848ULL,
0x000000021c28723cULL, 0x000b620000041828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x000000000d027f8cULL, 0x0202a2000c80043fULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x000126a010087811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000008ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x004fe200078e0003ULL,
0x0000001000002944ULL, 0x000fe20003c00000ULL, 0xffff15f000007947ULL, 0x000fea000383ffffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff0f7224ULL, 0x000fe400078e002bULL,
0x000000ffff6a7224ULL, 0x000fe400078e002aULL, 0x000000ffff0d7224ULL, 0x002fe400078e002fULL,
0x000000ffff687224ULL, 0x000fc400078e002eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0033ULL,
0x000000ffff207224ULL, 0x000fe400078e0032ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0001033000047802ULL, 0x000fc40000000f00ULL,
0x0000b4e000007944ULL, 0x00cfea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002400037308ULL, 0x004e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000024ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006b00ff037624ULL, 0x000fe400078e00ffULL,
0x00006a00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000087919ULL, 0x008ee80000000000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000001808057811ULL, 0x048fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x002fe40000011604ULL, 0x0000001008157811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x014fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f1506027589ULL, 0x000f2200000e0000ULL, 0x0000006400647220ULL, 0x042fe20000410000ULL,
0x0000006500657220ULL, 0x040fe20000410000ULL, 0x0000006000607220ULL, 0x040fe20000410000ULL,
0x0000006100617220ULL, 0x040fe20000410000ULL, 0x0000005c005c7220ULL, 0x040fe20000410000ULL,
0x0000005d005d7220ULL, 0x040fe20000410000ULL, 0x0000005800587220ULL, 0x040fe20000410000ULL,
0x0000005900597220ULL, 0x040fe20000410000ULL, 0x0000005400547220ULL, 0x040fe20000410000ULL,
0x0000005500557220ULL, 0x040fe20000410000ULL, 0x0000005000507220ULL, 0x040fe20000410000ULL,
0x0000005100517220ULL, 0x040fe20000410000ULL, 0x0000004c004c7220ULL, 0x040fe20000410000ULL,
0x0000004d004d7220ULL, 0x040fe20000410000ULL, 0x0000004800487220ULL, 0x040fe20000410000ULL,
0x0000004900497220ULL, 0x000fe20000410000ULL, 0x0000004605467220ULL, 0x044fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000000b050b7220ULL, 0x040fe20000410000ULL, 0x0000006805687220ULL, 0x040fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000006a056a7220ULL, 0x040fe20000410000ULL,
0x0000000f050f7220ULL, 0x000fe20000410000ULL, 0x0000000466667220ULL, 0x088fe20000410000ULL,
0x0000000467677220ULL, 0x080fe20000410000ULL, 0x0000000462627220ULL, 0x080fe20000410000ULL,
0x0000000463637220ULL, 0x080fe20000410000ULL, 0x000000045e5e7220ULL, 0x080fe20000410000ULL,
0x000000045f5f7220ULL, 0x080fe20000410000ULL, 0x000000045a5a7220ULL, 0x080fe20000410000ULL,
0x000000045b5b7220ULL, 0x080fe20000410000ULL, 0x0000000456567220ULL, 0x080fe20000410000ULL,
0x0000000457577220ULL, 0x080fe20000410000ULL, 0x0000000452527220ULL, 0x080fe20000410000ULL,
0x0000000453537220ULL, 0x080fe20000410000ULL, 0x000000044e4e7220ULL, 0x080fe20000410000ULL,
0x000000044f4f7220ULL, 0x080fe20000410000ULL, 0x000000044a4a7220ULL, 0x080fe20000410000ULL,
0x000000044b4b7220ULL, 0x000fe20000410000ULL, 0x0000000244447220ULL, 0x090fe20000410000ULL,
0x0000000245457220ULL, 0x080fe20000410000ULL, 0x0000000240407220ULL, 0x080fe20000410000ULL,
0x0000000241417220ULL, 0x080fe20000410000ULL, 0x000000023c3c7220ULL, 0x080fe20000410000ULL,
0x000000023d3d7220ULL, 0x080fe20000410000ULL, 0x0000000238387220ULL, 0x080fe20000410000ULL,
0x0000000239397220ULL, 0x080fe20000410000ULL, 0x0000000234347220ULL, 0x080fe20000410000ULL,
0x0000000235357220ULL, 0x080fe20000410000ULL, 0x0000000230307220ULL, 0x080fe20000410000ULL,
0x0000000231317220ULL, 0x080fe20000410000ULL, 0x000000022c2c7220ULL, 0x080fe20000410000ULL,
0x000000022d2d7220ULL, 0x080fe20000410000ULL, 0x0000000228287220ULL, 0x080fe20000410000ULL,
0x0000000229297220ULL, 0x000fc20000410000ULL, 0x0000000000037919ULL, 0x004e620000000000ULL,
0x000000666766723eULL, 0x000fc400000010ffULL, 0x000000626333723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000005e5f5e723eULL, 0x000fe400000010ffULL,
0x0000005a5b2f723eULL, 0x000fe400000010ffULL, 0x000000565756723eULL, 0x000fc400000010ffULL,
0x00000052532b723eULL, 0x000fe400000010ffULL, 0x0000004e4f4e723eULL, 0x000fe400000010ffULL,
0x0000004a4b27723eULL, 0x000fe400000010ffULL, 0x0000541066327816ULL, 0x000fe40000000033ULL,
0x0000000803057811ULL, 0x042fe400078ff0ffULL, 0x0000001003097811ULL, 0x000fc400078ff0ffULL,
0x0000000203007812ULL, 0x000fe200078ec0ffULL, 0x0000000805177824ULL, 0x000fe200078e00ffULL,
0x00000002ff077819ULL, 0x000fe20000011603ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000001803157811ULL, 0x000fe400078ff0ffULL, 0x0000000500047211ULL, 0x040fe200078ff8ffULL,
0x00000008070e7824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x040fe400078ff8ffULL,
0x0000000900057211ULL, 0x040fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000001500067211ULL, 0x000fe200078ff8ffULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x0000000202007810ULL, 0x000fc40007ffe0ffULL, 0xfffffff812127812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x008fe200078ee200ULL,
0x0000200011007824ULL, 0x000fe200078e00ffULL, 0xfffffff8170a7812ULL, 0x000fe400078ee204ULL,
0xfffffff815147812ULL, 0x000fe400078ee206ULL, 0xfffffff805047812ULL, 0x000fe200078ee202ULL,
0x0000100013057824ULL, 0x000fe200078e0200ULL, 0x0000000402067810ULL, 0x000fc40007ffe0ffULL,
0x0000000602077810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff8090c7812ULL, 0x000fe200078ee206ULL, 0x0000001004067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x000000100a107824ULL, 0x100fe200078e0205ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x000000646502723eULL, 0x000fe200000010ffULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0x000000606104723eULL, 0x000fe200000010ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000505106723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x00005410021c7816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x00007632021d7816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x0000005c5d02723eULL, 0x000fe200000010ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000585904723eULL, 0x000fe200000010ffULL, 0x0000001c08007388ULL, 0x0003e20000000a00ULL,
0x000000545505723eULL, 0x000fe200000010ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x000000444544723eULL, 0x000fe200000010ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000404122723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000763266337816ULL, 0x000fe20000000033ULL, 0x00000001070c7824ULL, 0x040fe200078e020cULL,
0x000054105e2e7816ULL, 0x000fe2000000002fULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x0000004c4d07723eULL, 0x000fc400000010ffULL, 0x000000484908723eULL, 0x002fe400000010ffULL,
0x00005410021c7816ULL, 0x140fe40000000004ULL, 0x00007632021d7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000001c0a007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040c007388ULL, 0x000fe20000000a00ULL,
0x0000003c3d3c723eULL, 0x000fe400000010ffULL, 0x00000038391e723eULL, 0x000fe200000010ffULL,
0x000000060e007388ULL, 0x0003e20000000a00ULL, 0x000076325e2f7816ULL, 0x000fe4000000002fULL,
0x00005410562a7816ULL, 0x140fe2000000002bULL, 0x0000003210007388ULL, 0x000fe20000000a00ULL,
0x00007632562b7816ULL, 0x000fc4000000002bULL, 0x000054104e267816ULL, 0x140fe20000000027ULL,
0x0004002e0a007388ULL, 0x000fe20000000a00ULL, 0x000076324e277816ULL, 0x000fe40000000027ULL,
0x000054103c087816ULL, 0x000fe2000000001eULL, 0x0004002a0c007388ULL, 0x000fe20000000a00ULL,
0x0000541044067816ULL, 0x142fe40000000022ULL, 0x0000763244077816ULL, 0x000fe20000000022ULL,
0x000400260e007388ULL, 0x000fe20000000a00ULL, 0x000076323c097816ULL, 0x000fc4000000001eULL,
0x000000343534723eULL, 0x000fe200000010ffULL, 0x0000000612007388ULL, 0x0003e20000000a00ULL,
0x00000030311a723eULL, 0x000fe400000010ffULL, 0x0000002c2d2c723eULL, 0x000fe200000010ffULL,
0x000800080a007388ULL, 0x0005e20000000a00ULL, 0x000000282916723eULL, 0x000fe400000010ffULL,
0x000000464702723eULL, 0x000fe400000010ffULL, 0x000000424304723eULL, 0x000fc400000010ffULL,
0x0000003e3f05723eULL, 0x000fe200000010ffULL, 0x0000000174077824ULL, 0x002fe200078e0203ULL,
0x0000003a3b06723eULL, 0x000fe400000010ffULL, 0x0000541034087816ULL, 0x044fe2000000001aULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x0000763234097816ULL, 0x000fca000000001aULL,
0x000800080c007388ULL, 0x0003e40000000a00ULL, 0x000054102c087816ULL, 0x142fe40000000016ULL,
0x000076322c097816ULL, 0x000fca0000000016ULL, 0x000800080e007388ULL, 0x0003e40000000a00ULL,
0x0000541002087816ULL, 0x142fe40000000004ULL, 0x0000763202097816ULL, 0x000fe40000000004ULL,
0x000000363702723eULL, 0x000fe400000010ffULL, 0x000000200b04723eULL, 0x000fe200000010ffULL,
0x0000000814007388ULL, 0x0003e60000000a00ULL, 0x00005410021c7816ULL, 0x000fc40000000004ULL,
0x00007632021d7816ULL, 0x000fe40000000004ULL, 0x000000ff00027306ULL, 0x000fe20000205400ULL,
0x0000541005087816ULL, 0x142fe40000000006ULL, 0x0000763205097816ULL, 0x000fe40000000006ULL,
0x000000680d05723eULL, 0x000fe400000010ffULL, 0x0000006a0f06723eULL, 0x000fe200000010ffULL,
0x000c00080a007388ULL, 0x000fe60000000a00ULL, 0x00007632050d7816ULL, 0x140fe20000000006ULL,
0x000c001c0c007388ULL, 0x0003e40000000a00ULL, 0x00005410050c7816ULL, 0x002fc40000000006ULL,
0x000000ff00057306ULL, 0x000e660000209400ULL, 0x000c000c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000007087984ULL, 0x000ea20000000c00ULL,
0x000000020500720bULL, 0x002fc60003f1d000ULL, 0x00040000071c7984ULL, 0x000e620000000c00ULL,
0x000000ff00027245ULL, 0x000fc6000020d400ULL, 0x0008000007247984ULL, 0x000ee80000000c00ULL,
0x000c0000072c7984ULL, 0x000f280000000c00ULL, 0x0010000007147984ULL, 0x000ee20000000c00ULL,
0x0000000102020812ULL, 0x000fe400078efcffULL, 0x000000ff1300720cULL, 0x000fe20003f05270ULL,
0x0014000007207984ULL, 0x000f220000000c00ULL, 0x000000020204723eULL, 0x000fc600000010ffULL,
0x0018000007287984ULL, 0x000f280000000c00ULL, 0x001c0000070c7984ULL, 0x000f220000000c00ULL,
0x3f803f80040b7831ULL, 0x044fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fc40000200008ULL,
0x3f803f80041f7831ULL, 0x042fe4000020001fULL, 0x3f803f80041e7831ULL, 0x040fe4000020001eULL,
0x3f803f80041d7831ULL, 0x040fe4000020001dULL, 0x3f803f80041c7831ULL, 0x040fe4000020001cULL,
0x3f803f8004277831ULL, 0x048fe40000200027ULL, 0x3f803f8004267831ULL, 0x000fc40000200026ULL,
0x3f803f8004257831ULL, 0x040fe40000200025ULL, 0x3f803f8004247831ULL, 0x040fe40000200024ULL,
0x3f803f80042f7831ULL, 0x050fe4000020002fULL, 0x3f803f80042e7831ULL, 0x040fe4000020002eULL,
0x3f803f80042d7831ULL, 0x040fe4000020002dULL, 0x3f803f80042c7831ULL, 0x000fc4000020002cULL,
0x3f803f800b0b7831ULL, 0x000fe40000200017ULL, 0x3f803f800a0a7831ULL, 0x000fe40000200016ULL,
0x3f803f8009097831ULL, 0x000fe40000200015ULL, 0x3f803f8008087831ULL, 0x000fe40000200014ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000000807007388ULL, 0x000fe20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fc40000200021ULL,
0x3f803f801c1c7831ULL, 0x000fe40000200020ULL, 0x3f803f8027277831ULL, 0x000fe4000020002bULL,
0x3f803f8026267831ULL, 0x000fe2000020002aULL, 0x0004001c07007388ULL, 0x000fe20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200029ULL, 0x3f803f8024247831ULL, 0x000fe40000200028ULL,
0x3f803f802f2f7831ULL, 0x000fc4000020000fULL, 0x3f803f802e2e7831ULL, 0x000fe2000020000eULL,
0x0008002407007388ULL, 0x000fe20000000c00ULL, 0x3f803f802d2d7831ULL, 0x000fe4000020000dULL,
0x3f803f802c2c7831ULL, 0x000fca000020000cULL, 0x000c002c07007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x000000190400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x0000000104027824ULL, 0x000fe200078e0203ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00000007030e7812ULL, 0x000fe200078ec0ffULL, 0x00005a0000067ab9ULL, 0x000fe40000000800ULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fc6000800063fULL,
0x0ffffff802057812ULL, 0x000fe200078ef803ULL, 0x000000201b027824ULL, 0x000fe200078e0204ULL,
0x0000580000067ab9ULL, 0x000fc60000000800ULL, 0x0000001005057824ULL, 0x000fe200078e0200ULL,
0x0000000502077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000005087984ULL, 0x0004e20000000c00ULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0x00000006040472a4ULL, 0x002fc6000f8e023fULL, 0x0000007702077224ULL, 0x000fe200078e0207ULL,
0x0000002003027810ULL, 0x000fe40007ffe0ffULL, 0x0000000477067c24ULL, 0x000fca000f8e02ffULL,
0x0000000706077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0007047a11ULL, 0x000fc800078040ffULL, 0x00005d0007057a11ULL, 0x004fe200000f440cULL,
0x0000000811077824ULL, 0x000fe200078e020eULL, 0x00000003ff0c7819ULL, 0x000fc60000011602ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190c00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0083f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x102fe400078e020cULL, 0x000000201b0c7824ULL, 0x000fc600078e020cULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x000000050c057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000770c057224ULL, 0x000fe200078e0205ULL, 0x00000040030c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000811077824ULL, 0x002fc600078e0202ULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x00000060030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x002fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001005027824ULL, 0x000fe200078e0200ULL, 0x000000050e057c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000770e057224ULL, 0x000fe200078e0205ULL, 0x00000003ff027819ULL, 0x002fc8000001160dULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000190200720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e0202ULL, 0x00000080030c7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b027824ULL, 0x000fc600078e0202ULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804057812ULL, 0x000fca00078ef80dULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x0000007702057224ULL, 0x000fe200078e0205ULL, 0x000000070d027812ULL, 0x000fc800078ec0ffULL,
0x0000000506057210ULL, 0x000fe20007f1e0ffULL, 0x0000000811077824ULL, 0x002fc800078e0202ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x000000a0030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x002fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001005027824ULL, 0x000fe200078e0200ULL, 0x000000050e057c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x000000770e057224ULL, 0x000fe200078e0205ULL, 0x00000003ff027819ULL, 0x002fc8000001160dULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000190200720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e0202ULL, 0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL,
0x000000201b027824ULL, 0x000fc600078e0202ULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804057812ULL, 0x000fca00078ef80dULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000118057824ULL, 0x000fc800078e0205ULL,
0x0000007702057224ULL, 0x000fe200078e0205ULL, 0x000000070d027812ULL, 0x000fc800078ec0ffULL,
0x0000000506057210ULL, 0x000fe20007f1e0ffULL, 0x0000000811077824ULL, 0x002fc800078e0202ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0e7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000190e00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020eULL, 0x000000e003047810ULL, 0x002fe20007ffe0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x000000050e077c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x00005a00ff0e7a19ULL, 0x000fe2000001160eULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x000fe400078e0200ULL,
0x000000770e077224ULL, 0x000fe200078e0207ULL, 0x00000003ff0e7819ULL, 0x000fc40000011604ULL,
0x0000000005087984ULL, 0x0002a40000000c00ULL, 0x0000000706077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fe200078040ffULL,
0x0000000811057824ULL, 0x002fc600078e020cULL, 0x00005d0007037a11ULL, 0x000fe200000f4410ULL,
0x0000000104077824ULL, 0x000fe200078e020eULL, 0x000000190e00720cULL, 0x000fc60003f06070ULL,
0x0000001005027825ULL, 0x000fe200078e0002ULL, 0x0000000707077812ULL, 0x000fc800078ec0ffULL,
0xfffffff807077812ULL, 0x000fe200078ef804ULL, 0x0000000802007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000007087984ULL, 0x002e620000000c00ULL, 0x0000000811117824ULL, 0x000fe200078e0204ULL,
0x000000050e037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0e7a19ULL, 0x000fc6000001160eULL,
0x0000000118037824ULL, 0x000fc800078e0203ULL, 0x000000770e037224ULL, 0x000fca00078e0203ULL,
0x0000000306037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x0000001011027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006a00ff5c7624ULL, 0x000fe400078e00ffULL,
0x00006b00ff5d7624ULL, 0x000fca00078e00ffULL, 0x000000085c5c7981ULL, 0x000522000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0300780cULL, 0x000fe20003f04070ULL,
0x000000020e077824ULL, 0x000fe200078e00ffULL, 0x01260000ff047f8cULL, 0x000ee2000c80043fULL,
0x000000401a1b7824ULL, 0x000fe400078e00ffULL, 0x0000590007147a24ULL, 0x000fc800078e0212ULL,
0x0000660014187a24ULL, 0x000fc800078e021bULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x000fe40000011617ULL, 0x0000001717107211ULL, 0x000fe400078fe8ffULL,
0x0000000821117810ULL, 0x040fe20007ffe0ffULL, 0x0000000118067824ULL, 0x002fe200078e0221ULL,
0x0000001821237810ULL, 0x040fe40007ffe0ffULL, 0x0000001021227810ULL, 0x040fe20007ffe0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x00000020211d7810ULL, 0x000fc40007ffe0ffULL,
0x00000003101c7812ULL, 0x000fe200078ec0ffULL, 0x0000000118087824ULL, 0x000fe200078e0211ULL,
0x00000030060e7812ULL, 0x000fe200078ef802ULL, 0x00000001180c7824ULL, 0x000fe200078e0223ULL,
0x0000001b16067217ULL, 0x000fe20007800000ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe40007f1e0ffULL, 0x00000028211f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001180a7824ULL, 0x040fe200078e0222ULL, 0x00006300070f7a10ULL, 0x000fe200007fe4ffULL,
0x0000000118077824ULL, 0x000fe200078e021dULL, 0x0000003008087812ULL, 0x000fe200078ef802ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000020001a1e7811ULL, 0x000fc400078e68ffULL,
0x0000620008087a10ULL, 0x000fe20007f3e0ffULL, 0x0000000106037824ULL, 0x000fe200078e0a1bULL,
0x000000300c0c7812ULL, 0x100fe200078ef802ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000630009097a10ULL, 0x000fe40000ffe4ffULL, 0x000062000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x100fe400078ef802ULL,
0x000063000d0d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000411137824ULL, 0x000fe200078e00ffULL,
0x0000003006107812ULL, 0x000fe200078ef802ULL, 0x0000000118067824ULL, 0x000fe200078e021fULL,
0x000062000a0a7a10ULL, 0x000fc40007f1e0ffULL, 0x0000620010107a10ULL, 0x000fe40007f5e0ffULL,
0x000000031100720cULL, 0x080fe40003f26070ULL, 0x000063000b0b7a10ULL, 0x000fe400007fe4ffULL,
0x0000630007117a10ULL, 0x000fe200017fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000032100720cULL, 0x000fe40003f06070ULL, 0x0ffffffc1c177812ULL, 0x000fc400078ef817ULL,
0xfffffffc13137812ULL, 0x000fe400078ee21cULL, 0x0000003021207810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e021eULL, 0x0000003006127812ULL, 0x000fe200078ef802ULL,
0x0000001013197824ULL, 0x000fe200078e021eULL, 0x0000003821217810ULL, 0x000fe20007ffe0ffULL,
0x0000000118067824ULL, 0x000fe200078e0220ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e177faeULL, 0x0003e2000c101c48ULL,
0x000000032200720cULL, 0x000fc40003fa6070ULL, 0x0000630007137a10ULL, 0x000fe200037fe4ffULL,
0x0000000008197faeULL, 0x0005e2000c901c48ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000032300720cULL, 0x080fe40003f86070ULL, 0x000000031d00720cULL, 0x080fe40003f66070ULL,
0x000000031f00720cULL, 0x080fe40003f46070ULL, 0x000000032000720cULL, 0x080fe20003f26070ULL,
0x0000000423177824ULL, 0x002fe200078e00ffULL, 0x000000032100720cULL, 0x000fe20003f06070ULL,
0x0000000422037824ULL, 0x000fe200078e00ffULL, 0x0000003006067812ULL, 0x000fe200078ef802ULL,
0x0000000118087824ULL, 0x004fe200078e0221ULL, 0xfffffffc17177812ULL, 0x100fe200078ee21cULL,
0x000000041d197824ULL, 0x000fe200078e00ffULL, 0xfffffffc03037812ULL, 0x000fe200078ee21cULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000620006067a10ULL, 0x000fc40007fde0ffULL,
0xfffffffc19197812ULL, 0x000fe200078ee21cULL, 0x000000041f1d7824ULL, 0x000fe200078e00ffULL,
0x0000003008027812ULL, 0x000fe200078ef802ULL, 0x00000004201f7824ULL, 0x000fe200078e00ffULL,
0x0000630007077a10ULL, 0x000fe200037fe4ffULL, 0x0000000421217824ULL, 0x000fe200078e00ffULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee21cULL, 0x00000010030f7824ULL, 0x000fe200078e021eULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee21cULL, 0x0000001017177824ULL, 0x000fe200078e021eULL,
0xfffffffc21217812ULL, 0x000fe200078ee21cULL, 0x0000001019197824ULL, 0x100fe200078e021eULL,
0x0000620002027a10ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e021eULL,
0x000000000a0f7faeULL, 0x0003e2000e901c48ULL, 0x000000101f1f7824ULL, 0x100fe200078e021eULL,
0x0000630009037a10ULL, 0x000fe200037fe4ffULL, 0x0000001021217824ULL, 0x000fe200078e021eULL,
0x000000000c177faeULL, 0x0003e8000e101c48ULL, 0x0000000010197faeULL, 0x0003e8000d901c48ULL,
0x00000000121d7faeULL, 0x0003e8000d101c48ULL, 0x00000000061f7faeULL, 0x0003e8000c901c48ULL,
0x0000000002217faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000010170f7811ULL, 0x040fe400078ff0ffULL, 0x0000001817117811ULL, 0x000fc400078ff0ffULL,
0x0000001717087211ULL, 0x040fe200078fe8ffULL, 0x00000001180a7824ULL, 0x040fe200078e020fULL,
0x0000002017037811ULL, 0x000fe200078ff0ffULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x0000003017097811ULL, 0x040fe200078ff0ffULL, 0x00000001180c7824ULL, 0x040fe200078e0211ULL,
0x0000002817077811ULL, 0x000fe200078ff0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x00000038170b7811ULL, 0x000fe200078ff0ffULL, 0x0000000403137824ULL, 0x000fe200078e00ffULL,
0x00000008170d7811ULL, 0x000fe200078ff0ffULL, 0x0000000118207824ULL, 0x000fe200078e0209ULL,
0x0000000308107812ULL, 0x000fe200078ec0ffULL, 0x0000000407197824ULL, 0x000fe200078e00ffULL,
0x0000001817067211ULL, 0x002fe200078ff0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0xfffffffc0f0e7812ULL, 0x100fe200078ee210ULL, 0x0000000118227824ULL, 0x040fe200078e020bULL,
0xfffffffc110f7812ULL, 0x100fe200078ee210ULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc13117812ULL, 0x100fe200078ee210ULL, 0x0000000118087824ULL, 0x040fe200078e020dULL,
0xfffffffc19127812ULL, 0x100fe200078ee210ULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc09137812ULL, 0x100fe200078ee210ULL, 0x00000001181e7824ULL, 0x000fe200078e0207ULL,
0x000020001a247811ULL, 0x000fe200078e68ffULL, 0x00000001181c7824ULL, 0x000fe200078e0203ULL,
0xfffffffc0b187812ULL, 0x000fe200078ee210ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0ffffffc10177812ULL, 0x000fc400078ef817ULL, 0xfffffffc0d037812ULL, 0x000fe200078ee210ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000003006107812ULL, 0x000fc600078ef802ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fc60007f1e0ffULL,
0x0000001012237824ULL, 0x000fe200078e0224ULL, 0x0000003008127812ULL, 0x100fe200078ef802ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a197812ULL, 0x000fe400078ef802ULL,
0x0000620012127a10ULL, 0x000fe20007f3e0ffULL, 0x0000001018277824ULL, 0x100fe200078e0224ULL,
0x0000620019187a10ULL, 0x000fe20007f5e0ffULL, 0x0000001011217824ULL, 0x100fe200078e0224ULL,
0x0000630007117a10ULL, 0x000fe200007fe4ffULL, 0x0000001013257824ULL, 0x000fe200078e0224ULL,
0x000000300c0c7812ULL, 0x000fe200078ef802ULL, 0x000000801c067825ULL, 0x000fe200078e00ffULL,
0x0000630009137a10ULL, 0x000fc40000ffe4ffULL, 0x000063000b197a10ULL, 0x000fe200017fe4ffULL,
0x000000801e087825ULL, 0x000fe200078e00ffULL, 0x000062000c0c7a10ULL, 0x000fc60007f1e0ffULL,
0x000000100e1d7824ULL, 0x100fe200078e0224ULL, 0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x000000100f1f7824ULL, 0x000fe400078e0224ULL, 0x00000080200a7825ULL, 0x000fc800078e00ffULL,
0x0000001017297824ULL, 0x000fe400078e0224ULL, 0x00000080220e7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010297faeULL, 0x0003e2000b901c48ULL,
0x0000001003177824ULL, 0x000fe200078e0224ULL, 0x0000003006037812ULL, 0x100fe400078ef802ULL,
0x0000003008067812ULL, 0x100fe400078ef802ULL, 0x000000300a087812ULL, 0x100fe200078ef802ULL,
0x0000000012177faeULL, 0x0003e2000b901c48ULL, 0x000000300e0a7812ULL, 0x000fe400078ef802ULL,
0x0000620003027a10ULL, 0x000fe20007f1e0ffULL, 0x00000000181d7faeULL, 0x0003e2000b901c48ULL,
0x0000620006067a10ULL, 0x000fc40007f3e0ffULL, 0x0000620008087a10ULL, 0x000fe20007f5e0ffULL,
0x000000000c1f7faeULL, 0x0003e2000b901c48ULL, 0x000062000a0a7a10ULL, 0x000fe40007f7e0ffULL,
0x0000630007037a10ULL, 0x000fe400007fe4ffULL, 0x0000630009077a10ULL, 0x000fe40000ffe4ffULL,
0x000063000b097a10ULL, 0x000fe200017fe4ffULL, 0x0000000002217faeULL, 0x0003e2000b901c48ULL,
0x000063000f0b7a10ULL, 0x000fc60001ffe4ffULL, 0x0000000006237faeULL, 0x0003e8000b901c48ULL,
0x0000000008257faeULL, 0x0003e8000b901c48ULL, 0x000000000a277faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000027805ULL, 0x002fc40000015200ULL,
0x01260400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x00afc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000602097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x000000201a027824ULL, 0x002fca00078e0203ULL,
0x00000004ff037819ULL, 0x000fe40000011602ULL, 0x0000000102047810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe03057812ULL, 0x000fe400078ec0ffULL, 0x0000001f02037812ULL, 0x000fc600078ec0ffULL,
0x0000000105077824ULL, 0x040fe400078e0204ULL, 0x0000000102067824ULL, 0x000fe200078e0205ULL,
0x0000000805057810ULL, 0x000fe20007ffe0ffULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x0000001003097824ULL, 0x000fe200078e00ffULL,
0x0000000f06067812ULL, 0x000fe200078ec0ffULL, 0x0000000104047824ULL, 0x000fe200078e0205ULL,
0x000001f008077812ULL, 0x000fe200078ee207ULL, 0x0000000102027824ULL, 0x000fe200078e0205ULL,
0x000001f009067812ULL, 0x000fe200078ee206ULL, 0x0000001003057824ULL, 0x040fe200078e00ffULL,
0x0000000f04047812ULL, 0x000fe200078ec0ffULL, 0x0000000007087984ULL, 0x000e62000000cc00ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x0000000f02027812ULL, 0x000fc400078ec0ffULL,
0x00000000060c7984ULL, 0x000ee4000000cc00ULL, 0x000001f003047812ULL, 0x000fe400078ee204ULL,
0x000001f005027812ULL, 0x000fe200078ee202ULL, 0x000000ffff127224ULL, 0x002fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff107224ULL, 0x008fe400078e000cULL,
0x000000ffff117224ULL, 0x000fc400078e000eULL, 0x000000ffff1e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1f7224ULL, 0x000fe200078e000bULL, 0x0000001006007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1c7224ULL, 0x000fe400078e000dULL, 0x000000ffff1d7224ULL, 0x000fca00078e000fULL,
0x0000001c07007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x00000000020c7984ULL, 0x000ee2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e000aULL,
0x000000ffff227224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff207224ULL, 0x008fe400078e000cULL, 0x000000ffff217224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000002002007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01260000ff067f8cULL, 0x000ee2000c80043fULL,
0x000000ffff087224ULL, 0x002fc600078e00ffULL, 0x0000000000027805ULL, 0x000fc80000015200ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x00afc40007804807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402097210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000177919ULL, 0x000e620000000000ULL,
0x0000001fff027424ULL, 0x000fe200078e00ffULL, 0x8000580016637a10ULL, 0x000fe20007ffe0ffULL,
0x00000001ff617424ULL, 0x000fe200078e00ffULL, 0x3db504f35c5c7820ULL, 0x010fe20000410000ULL,
0x00005800ff627624ULL, 0x000fe200078e00ffULL, 0x0000580002027a10ULL, 0x000fe20007ffe0ffULL,
0x000000ffff607224ULL, 0x000fe200078e00ffULL, 0x000126881a5d7811ULL, 0x004fe200078e18ffULL,
0x000000ffff5f7224ULL, 0x000fe200078e00ffULL, 0x00000004ff027819ULL, 0x000fc40000011602ULL,
0x000126081a5e7811ULL, 0x000fe400078e28ffULL, 0x0000580061617a10ULL, 0x000fe40007ffe1ffULL,
0x0000000962627810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x0ffffffe02647812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff657224ULL, 0x000fe200078e005fULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff667224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x00cfc4000001ff00ULL,
0x000000016600780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x0000000160027810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff747224ULL, 0x000fe200078e0066ULL,
0x0000000166037810ULL, 0x000fc40007ffe0ffULL, 0x00000001655f7812ULL, 0x000fe400078e0cffULL,
0x000000020300780cULL, 0x000fe20003f06070ULL, 0x000000ffff667224ULL, 0x000fc800078e0003ULL,
0x000000ffff021224ULL, 0x000fc800078e0260ULL, 0x0000010002537824ULL, 0x060fe200078e021bULL,
0x0000000102187810ULL, 0x000fe40007ffe0ffULL, 0x000000ff03027207ULL, 0x000fe20000800000ULL,
0x0000660014587a24ULL, 0x000fe200078e0253ULL, 0x000000151800720cULL, 0x000fda0003f46070ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x0000001017037824ULL, 0x002fe200078e00ffULL,
0x00000002ff697819ULL, 0x000fe20000011617ULL, 0x000000021a577824ULL, 0x000fe200078e025fULL,
0x0000005316507217ULL, 0x000fe40007800000ULL, 0x0000003003037812ULL, 0x000fe200078ec0ffULL,
0x0000000169197824ULL, 0x140fe200078e0258ULL, 0x00000018696b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000150567824ULL, 0x000fe200078e0a53ULL, 0x0000000869557810ULL, 0x040fe20007ffe0ffULL,
0x0000004002027824ULL, 0x000fe200078e0203ULL, 0x0000001069597810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x00000020696d7810ULL, 0x000fe20007ffe0ffULL,
0x000000016b517824ULL, 0x000fe200078e0258ULL, 0x0000200057577811ULL, 0x000fe200078e60ffULL,
0x0000008019187825ULL, 0x000fe200078e0002ULL, 0x00000028696f7810ULL, 0x000fc40007ffe0ffULL,
0x0000003069717810ULL, 0x000fe20007ffe0ffULL, 0x00000001552d7824ULL, 0x000fe200078e0258ULL,
0x0000620018527a10ULL, 0x000fe20007f3e0ffULL, 0x0000008051507825ULL, 0x000fe200078e0002ULL,
0x0000001717187211ULL, 0x000fe400078fe8ffULL, 0x0000630019537a10ULL, 0x000fe20000ffe4ffULL,
0x00000001582f7824ULL, 0x000fe200078e0259ULL, 0x0000620050507a10ULL, 0x000fe20007f3e0ffULL,
0x000000802d2c7825ULL, 0x000fe200078e0002ULL, 0x00000003185a7812ULL, 0x000fc400078ec0ffULL,
0x0000630051517a10ULL, 0x000fe20000ffe4ffULL, 0x000000802f2e7825ULL, 0x000fe200078e0002ULL,
0x000062002c2c7a10ULL, 0x000fe40007f5e0ffULL, 0x000000566900720cULL, 0x080fe20003f26070ULL,
0x000000016d197824ULL, 0x000fe200078e0258ULL, 0x000062002e2e7a10ULL, 0x000fe20007f7e0ffULL,
0x00000004595b7824ULL, 0x000fe200078e00ffULL, 0x000063002d2d7a10ULL, 0x000fe200017fe4ffULL,
0x0000008019187825ULL, 0x000fe200078e0002ULL, 0x000000565500720cULL, 0x000fc40003f46070ULL,
0x0ffffffc5a687812ULL, 0x000fe200078ef817ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0x000063002f2f7a10ULL, 0x000fe40001ffe4ffULL, 0x0000620018547a10ULL, 0x000fe40007f9e0ffULL,
0x000000565900720cULL, 0x000fe20003f66070ULL, 0x0000001068597824ULL, 0x100fe200078e0257ULL,
0xfffffffc55187812ULL, 0x000fe400078ee25aULL, 0x0000630019557a10ULL, 0x000fe200027fe4ffULL,
0x000000016f197824ULL, 0x000fe200078e0258ULL, 0xfffffffc5b687812ULL, 0x000fe200078ee25aULL,
0x00000010185b7824ULL, 0x000fe200078e0257ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000052597faeULL, 0x0003e2000c901c48ULL, 0x0000008019187825ULL, 0x000fe200078e0002ULL,
0x0000003869697810ULL, 0x000fc40007ffe0ffULL, 0x000000002c5b7faeULL, 0x0005e2000d101c48ULL,
0x0000001068677824ULL, 0x000fe200078e0257ULL, 0x000000566b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000046b6b7824ULL, 0x000fe200078e00ffULL, 0x000000566d00720cULL, 0x0c0fe20003f86070ULL,
0x000000046d6d7824ULL, 0x000fe200078e00ffULL, 0x000000002e677faeULL, 0x0007e2000d901c48ULL,
0x0000620018187a10ULL, 0x000fe20007fde0ffULL, 0x0000000171537824ULL, 0x102fe200078e0258ULL,
0x000000566f00720cULL, 0x080fe20003f66070ULL, 0x0000000169597824ULL, 0x000fe200078e0258ULL,
0x000000567100720cULL, 0x080fe20003f46070ULL, 0x00000080532c7825ULL, 0x004fe200078e0002ULL,
0x000000566900720cULL, 0x000fc40003f26070ULL, 0x0000630019197a10ULL, 0x000fe200037fe4ffULL,
0x000000046f6f7824ULL, 0x000fe200078e00ffULL, 0x000062002c2c7a10ULL, 0x000fe20007fde0ffULL,
0x0000000471717824ULL, 0x000fe200078e00ffULL, 0xfffffffc6b2e7812ULL, 0x108fe200078ee25aULL,
0x0000000469697824ULL, 0x000fe200078e00ffULL, 0xfffffffc6d527812ULL, 0x000fe200078ee25aULL,
0x0000008059027825ULL, 0x000fe200078e0002ULL, 0xfffffffc6f567812ULL, 0x100fe400078ee25aULL,
0xfffffffc71587812ULL, 0x100fe200078ee25aULL, 0x000000102e2f7824ULL, 0x100fe200078e0257ULL,
0xfffffffc695a7812ULL, 0x000fe200078ee25aULL, 0x0000001052537824ULL, 0x100fe200078e0257ULL,
0x000063002d2d7a10ULL, 0x000fe200037fe4ffULL, 0x0000001056597824ULL, 0x100fe200078e0257ULL,
0x0000620002027a10ULL, 0x000fe20007fde0ffULL, 0x00000010585b7824ULL, 0x100fe200078e0257ULL,
0x00000000502f7faeULL, 0x0003e2000e901c48ULL, 0x000000105a577824ULL, 0x000fe200078e0257ULL,
0x0000630003037a10ULL, 0x000fc400037fe4ffULL, 0x0000000054537faeULL, 0x0003e8000e101c48ULL,
0x0000000018597faeULL, 0x0003e8000d901c48ULL, 0x000000002c5b7faeULL, 0x0003e8000d101c48ULL,
0x0000000002577faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000001017037824ULL, 0x042fe200078e00ffULL, 0x00000010172f7811ULL, 0x040fe200078ff0ffULL,
0x000000021a197824ULL, 0x000fe200078e025fULL, 0x0000001817517811ULL, 0x000fc400078ff0ffULL,
0x0000003003037812ULL, 0x000fe200078ec0ffULL, 0x000000012f2d7824ULL, 0x100fe200078e0258ULL,
0x0000002017537811ULL, 0x000fe200078ff0ffULL, 0x000000042f597824ULL, 0x000fe200078e00ffULL,
0x0000002817557811ULL, 0x040fe200078ff0ffULL, 0x0000004002567824ULL, 0x000fe200078e0203ULL,
0x0000000817037811ULL, 0x000fe200078ff0ffULL, 0x00000001512f7824ULL, 0x100fe200078e0258ULL,
0x0000003017577811ULL, 0x000fe200078ff0ffULL, 0x00000004515b7824ULL, 0x000fe200078e00ffULL,
0x00000038176f7811ULL, 0x000fe200078ff0ffULL, 0x0000000153517824ULL, 0x100fe200078e0258ULL,
0x0000001717187211ULL, 0x000fe200078fe8ffULL, 0x0000000453677824ULL, 0x000fe200078e00ffULL,
0x0000200019717811ULL, 0x000fe200078e60ffULL, 0x0000000103197824ULL, 0x100fe200078e0258ULL,
0x0000000318187812ULL, 0x000fe200078ec0ffULL, 0x0000000155537824ULL, 0x000fc400078e0258ULL,
0x0000000403037824ULL, 0x000fe200078e00ffULL, 0xfffffffc592c7812ULL, 0x100fe200078ee218ULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0xfffffffc5b2e7812ULL, 0x100fe200078ee218ULL,
0x0000000457697824ULL, 0x000fe200078e00ffULL, 0xfffffffc03027812ULL, 0x100fe200078ee218ULL,
0x000000046f6b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc67507812ULL, 0x100fe200078ee218ULL,
0x000000102c5b7824ULL, 0x100fe200078e0271ULL, 0xfffffffc55527812ULL, 0x000fe200078ee218ULL,
0x0000000157557824ULL, 0x000fe200078e0258ULL, 0xfffffffc69547812ULL, 0x100fe200078ee218ULL,
0x000000ffff577224ULL, 0x000fe200078e00ffULL, 0xfffffffc6b5a7812ULL, 0x000fe200078ee218ULL,
0x0000001002597824ULL, 0x000fe200078e0271ULL, 0x0ffffffc18187812ULL, 0x000fe200078ef817ULL,
0x000000102e677824ULL, 0x000fe200078e0271ULL, 0x0000005817037211ULL, 0x000fe200078ff0ffULL,
0x000000802d2c7825ULL, 0x000fc800078e0056ULL, 0x0000001018737824ULL, 0x000fe200078e0271ULL,
0x000062002c2c7a10ULL, 0x000fe20007f7e0ffULL, 0x0000008003027825ULL, 0x000fc600078e0056ULL,
0x000063002d2d7a10ULL, 0x000fe20001ffe4ffULL, 0x0000008019187825ULL, 0x000fe200078e0056ULL,
0x0000620002027a10ULL, 0x000fc60007f3e0ffULL, 0x000000802f2e7825ULL, 0x000fe200078e0056ULL,
0x0000620018187a10ULL, 0x000fe40007f5e0ffULL, 0x0000630003037a10ULL, 0x000fe20000ffe4ffULL,
0x000000016f6f7824ULL, 0x000fe200078e0258ULL, 0x000062002e2e7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001050697824ULL, 0x100fe200078e0271ULL, 0x0000630019197a10ULL, 0x000fe200017fe4ffULL,
0x00000010526b7824ULL, 0x000fe200078e0271ULL, 0x000063002f2f7a10ULL, 0x000fe200027fe4ffULL,
0x0000008051507825ULL, 0x000fe200078e0056ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002737faeULL, 0x0003e6000b901c48ULL, 0x00000010546d7824ULL, 0x000fe200078e0271ULL,
0x0000620050507a10ULL, 0x000fe20007f3e0ffULL, 0x0000008053527825ULL, 0x100fe200078e0056ULL,
0x0000000018597faeULL, 0x0003e4000b901c48ULL, 0x0000630051517a10ULL, 0x000fe20000ffe4ffULL,
0x0000008055547825ULL, 0x100fe200078e0056ULL, 0x0000620052527a10ULL, 0x000fe20007f5e0ffULL,
0x000000002c5b7faeULL, 0x0003e4000b901c48ULL, 0x000000806f567825ULL, 0x000fe200078e0056ULL,
0x0000620054547a10ULL, 0x000fe20007f7e0ffULL, 0x000000002e677faeULL, 0x0003e2000b901c48ULL,
0x0000630053537a10ULL, 0x000fe200017fe4ffULL, 0x000000105a717824ULL, 0x000fe200078e0271ULL,
0x0000620056567a10ULL, 0x000fe20007f9e0ffULL, 0x0000000050697faeULL, 0x0003e2000b901c48ULL,
0x0000630055557a10ULL, 0x000fc40001ffe4ffULL, 0x0000630057577a10ULL, 0x000fe200027fe4ffULL,
0x00000000526b7faeULL, 0x0003e8000b901c48ULL, 0x00000000546d7faeULL, 0x0003e8000b901c48ULL,
0x0000000056717faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000874687824ULL, 0x000fc400078e00ffULL,
0x000000ffffcd7224ULL, 0x000fe400078e00ffULL, 0x00000010ff697424ULL, 0x002fe200078e00ffULL,
0x00000012686a7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff677224ULL, 0x000fe200078e00ffULL,
0x0000000268687810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff817027812ULL, 0x000fe200078ec0ffULL, 0x000000021a507824ULL, 0x020fe200078e0265ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000167197810ULL, 0x000fe40007ffe0ffULL,
0x0000000702027812ULL, 0x000fc400078ef817ULL, 0x0000200050507811ULL, 0x000fe400078e60ffULL,
0x00000001ff187819ULL, 0x000fe20000011602ULL, 0x00000004022c7824ULL, 0x040fe200078e00ffULL,
0x0000002017527810ULL, 0x040fe20007ffe0ffULL, 0x00000004022d7824ULL, 0x000fe200078e00ffULL,
0x0000000817d67812ULL, 0x000fe200078ec0ffULL, 0x0000000118037824ULL, 0x000fe200078e0267ULL,
0xfffffff852527812ULL, 0x000fe200078ec0ffULL, 0x0000000118187824ULL, 0x000fc600078e0219ULL,
0xfffffffc2c037812ULL, 0x000fe400078ee203ULL, 0xfffffffc2d2d7812ULL, 0x000fe400078ee218ULL,
0x0000000752527812ULL, 0x000fe200078ef817ULL, 0x0000001003037824ULL, 0x100fe400078e0250ULL,
0x000000102d2d7824ULL, 0x000fe200078e0250ULL, 0x00000001ff6c7819ULL, 0x000fe20000011652ULL,
0x0000000452587824ULL, 0x040fe200078e00ffULL, 0x000000000354783bULL, 0x0002a20000000200ULL,
0x0000000452527824ULL, 0x000fc400078e00ffULL, 0x000000016c197824ULL, 0x040fe200078e0219ULL,
0x000000002d2c783bULL, 0x000ee20000000200ULL, 0x000000016c037824ULL, 0x002fc600078e0267ULL,
0xfffffffc52197812ULL, 0x000fe400078ee219ULL, 0x0000000267677810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc58037812ULL, 0x000fca00078ee203ULL, 0x0000001003037824ULL, 0x100fe400078e0250ULL,
0x0000001019507824ULL, 0x000fc600078e0250ULL, 0x000000000358783bULL, 0x000e680000000200ULL,
0x000000005050783bULL, 0x000f220000000200ULL, 0x0001000054d57824ULL, 0x044fe200078e00ffULL,
0x00000018ffe87819ULL, 0x000fe20000011454ULL, 0x0000010054d37824ULL, 0x000fe200078e00ffULL,
0x0000005400eb7306ULL, 0x000fe20000009400ULL, 0x0001000055e77824ULL, 0x000fe200078e00ffULL,
0x00000018ffd57819ULL, 0x000fe200000114d5ULL, 0x0000010056da7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x0001000057ce7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x0000010055e47824ULL, 0x000fe200078e00ffULL,
0x000000d500d47306ULL, 0x000fe20000209400ULL, 0x00000018ffe17819ULL, 0x000fe20000011455ULL,
0x000100002cae7824ULL, 0x048fe200078e00ffULL, 0x00000018ffca7819ULL, 0x000fe20000011456ULL,
0x000001002c9d7824ULL, 0x000fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x000100002d9b7824ULL, 0x040fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x000000d500ef7306ULL, 0x0004e20000205400ULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x000001002d957824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe20000011457ULL,
0x000100002e927824ULL, 0x040fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe2000001142cULL,
0x000001002e8e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001142dULL,
0x000000d300ed7306ULL, 0x000fe20000209400ULL, 0x000000d500d57245ULL, 0x004fe2000020d400ULL,
0x0000010057cf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fc4000001142eULL,
0x00000018ffc17819ULL, 0x002fe40000011458ULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x000000d300d07306ULL, 0x0002a20000205400ULL, 0x000000efd400720bULL, 0x008fe40003fbd000ULL,
0x00000007d6d47812ULL, 0x000fe400078ef817ULL, 0x00000018ffbb7819ULL, 0x000fe40000011459ULL,
0x00000018ff6e7819ULL, 0x000fe2000001142fULL, 0x000000e700e97306ULL, 0x000fe20000209400ULL,
0x000000d300d37245ULL, 0x002fe2000020d400ULL, 0x00000010d4ee7824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fc4000001145bULL, 0x00000018ffb57819ULL, 0x000fe4000001145aULL,
0x00000001d5d55812ULL, 0x000fe200078efcffULL, 0x000000e700ec7306ULL, 0x000e620000205400ULL,
0x000000d0ed00720bULL, 0x004fe40003f5d000ULL, 0x00000018ffae7819ULL, 0x000fe400000114aeULL,
0x00000018ff9d7819ULL, 0x000fe4000001149dULL, 0x00000018ff8e7819ULL, 0x000fe2000001148eULL,
0x0000005400887306ULL, 0x000ea20000005400ULL, 0x00000018ff7e7819ULL, 0x010fc40000011450ULL,
0x00000018ff9b7819ULL, 0x000fe4000001149bULL, 0x00000018ff957819ULL, 0x000fe40000011495ULL,
0x00000001d3d32812ULL, 0x000fe200078efcffULL, 0x0000005400187306ULL, 0x000722000000d400ULL,
0x000000ece900720bULL, 0x002fe40003fbd000ULL, 0x00000018ff817819ULL, 0x000fe40000011451ULL,
0x00000018ff847819ULL, 0x000fc40000011452ULL, 0x00000018ff877819ULL, 0x000fe20000011453ULL,
0x000000e800a07306ULL, 0x000fe20000209400ULL, 0x0001000056547824ULL, 0x008fe200078e00ffULL,
0x00000088eb00720bULL, 0x004fe20003f7d000ULL, 0x00000010d4eb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe40000011492ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x000000e800d77306ULL, 0x0002ae0000205400ULL, 0x0000000118183812ULL, 0x010fe200078efcffULL,
0x00000055009c7306ULL, 0x000fe20000009400ULL, 0x000000e800e87245ULL, 0x002fc4000020d400ULL,
0x00000018d518723eULL, 0x000fca00000010ffULL, 0x00000055008f7306ULL, 0x000e620000005400ULL,
0x000000d7a000720bULL, 0x004fce0003fdd000ULL, 0x0000005700cb7306ULL, 0x000fec0000009400ULL,
0x00000001e8e86812ULL, 0x000fe400078efcffULL, 0x0000005700e27306ULL, 0x000ea20000005400ULL,
0x0000008f9c00720bULL, 0x002fce0003f9d000ULL, 0x0000005400e57306ULL, 0x000ff00000209400ULL,
0x0000005400e67306ULL, 0x000e620000205400ULL, 0x000000e2cb00720bULL, 0x004fe40003f5d000ULL,
0x000000e700cb7245ULL, 0x000fc8000020d400ULL, 0x00000001cbcb5812ULL, 0x000fe200078efcffULL,
0x0000005500027306ULL, 0x000eb0000000d400ULL, 0x000000e100cc7306ULL, 0x000fe20000209400ULL,
0x000000e6e500720bULL, 0x002fce0003fbd000ULL, 0x000000e100e37306ULL, 0x0002e20000205400ULL,
0x0000000102024812ULL, 0x004fc800078efcffULL, 0x00000002cb02723eULL, 0x000fc600000010ffULL,
0x00000056008a7306ULL, 0x000fe20000009400ULL, 0x000000e100e17245ULL, 0x002fce000020d400ULL,
0x0000005600897306ULL, 0x000e620000005400ULL, 0x000000e3cc00720bULL, 0x008fe40003fdd000ULL,
0x000000e400cc7245ULL, 0x000fca000020d400ULL, 0x0000002c00e07306ULL, 0x000fec0000009400ULL,
0x00000001e1e16812ULL, 0x000fe400078efcffULL, 0x0000002c00dd7306ULL, 0x000ea20000005400ULL,
0x000000898a00720bULL, 0x002fe20003f3d000ULL, 0x000100002f8a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x000000ca00db7306ULL, 0x000ff00000209400ULL,
0x000000ca00dc7306ULL, 0x000e620000205400ULL, 0x000000dde000720bULL, 0x004fc40003f9d000ULL,
0x0000005400dd7245ULL, 0x000fc8000020d400ULL, 0x00000001dddd5812ULL, 0x000fe200078efcffULL,
0x0000005600bc7306ULL, 0x000eb0000000d400ULL, 0x000000da00557306ULL, 0x000fe20000209400ULL,
0x000000dcdb00720bULL, 0x002fe20003fbd000ULL, 0x000100005adc7824ULL, 0x000fcc00078e00ffULL,
0x000000da00567306ULL, 0x0002e20000205400ULL, 0x00000001bcbc1812ULL, 0x004fce00078efcffULL,
0x000000ce00d87306ULL, 0x000fe20000209400ULL, 0x000000da00da7245ULL, 0x002fce000020d400ULL,
0x000000ce00d97306ULL, 0x000e620000205400ULL, 0x000000565500720bULL, 0x008fce0003fdd000ULL,
0x0000002c007b7306ULL, 0x0004ec000000d400ULL, 0x00000001dada6812ULL, 0x000fe400078efcffULL,
0x0000002d00de7306ULL, 0x000fe20000009400ULL, 0x000000d6172c7211ULL, 0x004fe400078fe0ffULL,
0x000000d9d800720bULL, 0x002fc40003f3d000ULL, 0x000000ca00d97245ULL, 0x000fe4000020d400ULL,
0x00000018ffd87819ULL, 0x000fe200000114dcULL, 0x0000002d00df7306ULL, 0x000fe20000005400ULL,
0x00000001d9d95812ULL, 0x000fe400078efcffULL, 0x000000017b7b4812ULL, 0x008fca00078efcffULL,
0x0000002d007a7306ULL, 0x0003f0000000d400ULL, 0x0000002e00b17306ULL, 0x000fe20000009400ULL,
0x00000007172d7812ULL, 0x002fca00078ec0ffULL, 0x000000012d2c7824ULL, 0x000fe400078e022cULL,
0x0000002e00b07306ULL, 0x000fe20000005400ULL, 0x00000008742d7824ULL, 0x100fe400078e02cdULL,
0x000000682ca07210ULL, 0x040fe40007ffe0cdULL, 0x000000012c2d7824ULL, 0x040fe200078e022dULL,
0x0000006a2c9c7210ULL, 0x000fe20007ffe0cdULL, 0x0000010058cd7824ULL, 0x000fe200078e00ffULL,
0x0000002e00777306ULL, 0x0003e2000000d400ULL, 0xfffffff0eba07812ULL, 0x000fc400078ee2a0ULL,
0xfffffff0ee2d7812ULL, 0x000fe400078ee22dULL, 0x00000018ffcd7819ULL, 0x000fc600000114cdULL,
0x000000e400c37306ULL, 0x000fe20000209400ULL, 0x00010000582e7824ULL, 0x002fca00078e00ffULL,
0x00000018ffd07819ULL, 0x000fe4000001142eULL, 0x000000e400ea7306ULL, 0x000e620000205400ULL,
0x00000010d42e7812ULL, 0x000fce00078efcffULL, 0x000000c700c47306ULL, 0x000ff00000209400ULL,
0x000000c700197306ULL, 0x000ea20000205400ULL, 0x000000eac300720bULL, 0x002fce0003f7d000ULL,
0x0000005700b67306ULL, 0x0002ec000000d400ULL, 0x00000001cccc3812ULL, 0x000fe400078efcffULL,
0x0000005800c57306ULL, 0x000fe20000009400ULL, 0x0000000874577824ULL, 0x002fe200078e0269ULL,
0x00000019c400720bULL, 0x004fc40003fbd000ULL, 0x000000c700c47245ULL, 0x000fe2000020d400ULL,
0x000000012c2c7824ULL, 0x000fe200078e0257ULL, 0x000000dfde00720bULL, 0x000fe20003f7d000ULL,
0x000000102e577824ULL, 0x000fe200078e00ffULL, 0x0000005800c67306ULL, 0x000e620000005400ULL,
0x00010000592e7824ULL, 0x000fe200078e00ffULL, 0x00000001b6b62812ULL, 0x008fe400078efcffULL,
0xfffffff0572c7812ULL, 0x040fe400078ee22cULL, 0xfffffff0579c7812ULL, 0x000fe200078ee29cULL,
0x000000102d577824ULL, 0x000fe200078e00ffULL, 0x000000cf00d17306ULL, 0x000fe20000209400ULL,
0x000000102c2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fc4000001142eULL,
0x00000001c4c45812ULL, 0x000fe200078efcffULL, 0x000000005754783bULL, 0x000ea20000000200ULL,
0x000000d3e819723eULL, 0x000fe400000010ffULL, 0x000000cf00d27306ULL, 0x0007220000205400ULL,
0x000000c6c500720bULL, 0x002fe40003f5d000ULL, 0x000000017a7a3812ULL, 0x000fca00078efcffULL,
0x000000c100c97306ULL, 0x000fe20000209400ULL, 0x000000cf00cf7245ULL, 0x008fce000020d400ULL,
0x000000c100c87306ULL, 0x000e620000205400ULL, 0x000000d2d100720bULL, 0x010fe20003fdd000ULL,
0x000100005bd27824ULL, 0x040fe200078e00ffULL, 0x000000ce00d17245ULL, 0x000fe2000020d400ULL,
0x000001005bce7824ULL, 0x000fc600078e00ffULL, 0x00000001d1d11812ULL, 0x000fe200078efcffULL,
0x0000005900c07306ULL, 0x000fe20000009400ULL, 0x00000018ffc57819ULL, 0x000fe400000114d2ULL,
0x00000018ffce7819ULL, 0x000fc600000114ceULL, 0x00000001cfcf6812ULL, 0x000fe400078efcffULL,
0x0000005900bf7306ULL, 0x000fe20000005400ULL, 0x000000c8c900720bULL, 0x002fe20003fbd000ULL,
0x000000185430723cULL, 0x004fec0000041830ULL, 0x0000005900ab7306ULL, 0x0003f0000000d400ULL,
0x000000d000d67306ULL, 0x000fe20000209400ULL, 0x0000010059597824ULL, 0x002fca00078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x000000d000d77306ULL, 0x000e700000205400ULL,
0x0000005800ac7306ULL, 0x0004f0000000d400ULL, 0x000000cd00d47306ULL, 0x000fe20000209400ULL,
0x000001002f587824ULL, 0x004fe200078e00ffULL, 0x000000d7d600720bULL, 0x002fcc0003f3d000ULL,
0x000000cd00e97306ULL, 0x0002a20000205400ULL, 0x00000001acac2812ULL, 0x008fe400078efcffULL,
0x000000bfc000720bULL, 0x000fe40003f5d000ULL, 0x000000c100c07245ULL, 0x000fc6000020d400ULL,
0x0000002f00aa7306ULL, 0x000fe20000009400ULL, 0x00000001c0c05812ULL, 0x000fe400078efcffULL,
0x000000cd00cd7245ULL, 0x002fca000020d400ULL, 0x0000002f00a97306ULL, 0x000fe20000005400ULL,
0x000000e9d400720bULL, 0x004fe40003fdd000ULL, 0x00000001abab2812ULL, 0x000fca00078efcffULL,
0x0000002f00797306ULL, 0x0003ec000000d400ULL, 0x00000001cdcd6812ULL, 0x000fe400078efcffULL,
0x0000005900de7306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x002e6e0000000200ULL,
0x0000005900db7306ULL, 0x0004f00000205400ULL, 0x000000c300e27306ULL, 0x000fe20000209400ULL,
0x0000005900597245ULL, 0x004fce000020d400ULL, 0x000000c300e37306ULL, 0x000fe20000205400ULL,
0x000000dbde00720bULL, 0x008fce0003fbd000ULL, 0x0000005a00037306ULL, 0x000fec0000009400ULL,
0x0000000159595812ULL, 0x000fe400078efcffULL, 0x0000005a00c27306ULL, 0x000ea20000005400ULL,
0x000000182c34723cULL, 0x002b6e0000041834ULL, 0x000000d800ca7306ULL, 0x000fe20000209400ULL,
0x000000bcdd18723eULL, 0x020fc400000010ffULL, 0x000000dad919723eULL, 0x000fe400000010ffULL,
0x000000bb00bc7245ULL, 0x000fc6000020d400ULL, 0x000000d800d77306ULL, 0x0002e20000205400ULL,
0x000000c20300720bULL, 0x004fe20003fdd000ULL, 0x000000185440723cULL, 0x000fe20000041840ULL,
0x000000c300c27245ULL, 0x000fe4000020d400ULL, 0x000000cce103723eULL, 0x000fc600000010ffULL,
0x0000005b00b77306ULL, 0x000fe20000009400ULL, 0x000000d800d87245ULL, 0x002fe2000020d400ULL,
0x000000182c44723cULL, 0x000bec0000041844ULL, 0x0000005b00b87306ULL, 0x000e620000005400ULL,
0x000000d7ca00720bULL, 0x008fe20003f5d000ULL, 0x000000025438723cULL, 0x000f640000041838ULL,
0x000000b500197245ULL, 0x020fc8000020d400ULL, 0x0000005b00a27306ULL, 0x0004e4000000d400ULL,
0x000000022c3c723cULL, 0x000b68000004183cULL, 0x00000001d8d82812ULL, 0x000fe400078efcffULL,
0x000000bb00bd7306ULL, 0x000fe20000209400ULL, 0x000000d0005b7245ULL, 0x004fe4000020d400ULL,
0x000000b8b700720bULL, 0x002fc40003fbd000ULL, 0x000000015b5b1812ULL, 0x000fe400078efcffULL,
0x000000e3e200720bULL, 0x000fe20003f3d000ULL, 0x000000bb00be7306ULL, 0x000e620000205400ULL,
0x000000b6d102723eULL, 0x020fe400000010ffULL, 0x000000cfc403723eULL, 0x000fe400000010ffULL,
0x00000018ffb77819ULL, 0x000fc60000011458ULL, 0x0000005a00a37306ULL, 0x000522000000d400ULL,
0x00000001a2a25812ULL, 0x008fe200078efcffULL, 0x000000025448723cULL, 0x000f640000041848ULL,
0x00000001c2c21812ULL, 0x000fc800078efcffULL, 0x000000b500b97306ULL, 0x000fe20000209400ULL,
0x000001005a5a7824ULL, 0x004fe200078e00ffULL, 0x000000bebd00720bULL, 0x002fe20003f3d000ULL,
0x000000022c4c723cULL, 0x000b66000004184cULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x000000b500ba7306ULL, 0x000e620000205400ULL, 0x00000001a3a36812ULL, 0x010fe400078efcffULL,
0x0000005a00b87245ULL, 0x000fc4000020d400ULL, 0x000000abc202723eULL, 0x020fe200000010ffULL,
0x0000010052ab7824ULL, 0x000fe200078e00ffULL, 0x00000001bcbc1812ULL, 0x000fe200078efcffULL,
0x000000c500bf7306ULL, 0x000fe20000209400ULL, 0x000000a3d818723eULL, 0x000fe200000010ffULL,
0x0001000051a37824ULL, 0x000fe200078e00ffULL, 0x00000059bc03723eULL, 0x000fe400000010ffULL,
0x000000ad00597245ULL, 0x000fe4000020d400ULL, 0x00000018ffa37819ULL, 0x000fe200000114a3ULL,
0x000000c500c87306ULL, 0x0004e20000205400ULL, 0x000000bab900720bULL, 0x002fe20003f5d000ULL,
0x000000025420723cULL, 0x000fe20000041820ULL, 0x00000018ffab7819ULL, 0x000fca00000114abULL,
0x000000ae00b27306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x004fe2000020d400ULL,
0x000000022c0c723cULL, 0x000be8000004180cULL, 0x0000000119192812ULL, 0x000fe400078efcffULL,
0x000000ae00b37306ULL, 0x0002a20000205400ULL, 0x000000c8bf00720bULL, 0x008fce0003fdd000ULL,
0x000000ad00af7306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x00000001c5c56812ULL, 0x000fe400078efcffULL, 0x000000ad00b47306ULL, 0x0002e20000205400ULL,
0x000000b3b200720bULL, 0x004fe40003fbd000ULL, 0x000000a2c558723eULL, 0x000fe200000010ffULL,
0x0000010053a27824ULL, 0x000fc800078e00ffULL, 0x0000005a00c67306ULL, 0x000fe20000209400ULL,
0x0001000053ad7824ULL, 0x002fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fc800000114a2ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x0000005a00c77306ULL, 0x0002a20000205400ULL,
0x000000b4af00720bULL, 0x008fe20003fdd000ULL, 0x0001000050af7824ULL, 0x000fe200078e00ffULL,
0x0000007bae02723eULL, 0x020fe400000010ffULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x000000ce00bd7306ULL, 0x000fe20000209400ULL,
0x000000ac5b5a723eULL, 0x002fc400000010ffULL, 0x000000cdc05b723eULL, 0x000fe400000010ffULL,
0xfffffff469cd7810ULL, 0x000fe40007ffe0ffULL, 0x0000000159596812ULL, 0x000fe200078efcffULL,
0x000000ce00be7306ULL, 0x0002e20000205400ULL, 0x000000c7c600720bULL, 0x004fe20003f3d000ULL,
0x0000005a5428723cULL, 0x080f6c0000041828ULL, 0x0000009d00a77306ULL, 0x000fe20000209400ULL,
0x000000ce00ce7245ULL, 0x002fe2000020d400ULL, 0x0000005a2c08723cULL, 0x000b680000041808ULL,
0x00000001b8b81812ULL, 0x000fc400078efcffULL, 0x0000009d00a87306ULL, 0x0002a20000205400ULL,
0x000000bebd00720bULL, 0x008fe40003f5d000ULL, 0x000000b81919723eULL, 0x000fe400000010ffULL,
0x000000b0b100720bULL, 0x000fe40003f3d000ULL, 0x0000008b005a7245ULL, 0x020fe2000020d400ULL,
0x0000008b00997306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fe2000020d400ULL,
0x000000185404723cULL, 0x000f680000041804ULL, 0x00000001cece2812ULL, 0x000fc400078efcffULL,
0x0000008b009a7306ULL, 0x0002e20000205400ULL, 0x000000a8a700720bULL, 0x004fe20003fbd000ULL,
0x0000010051a87824ULL, 0x000fe200078e00ffULL, 0x000000ce5959723eULL, 0x000fe200000010ffULL,
0x000000182c10723cULL, 0x000f620000041810ULL, 0x000000a9aa00720bULL, 0x000fe20003f5d000ULL,
0x0001000052aa7824ULL, 0x000fe200078e00ffULL, 0x0000000177771812ULL, 0x000fe200078efcffULL,
0x0000009800a57306ULL, 0x000fe20000209400ULL, 0x00000018ffa87819ULL, 0x000fe400000114a8ULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000585424723cULL, 0x000b620000041824ULL,
0x000000b7008b7245ULL, 0x002fc4000020d400ULL, 0x000000019d9d5812ULL, 0x000fe200078efcffULL,
0x0000009800a67306ULL, 0x0002a20000205400ULL, 0x0000009a9900720bULL, 0x008fe40003fbd000ULL,
0x000000109c547824ULL, 0x020fe200078e00ffULL, 0x0000000179792812ULL, 0x000fe200078efcffULL,
0x000000582c1c723cULL, 0x000f62000004181cULL, 0x0000006b00187245ULL, 0x000fe4000020d400ULL,
0x00000050008c7306ULL, 0x000fe20000009400ULL, 0x000000005454783bULL, 0x000ee20000000200ULL,
0x0000009800987245ULL, 0x002fc8000020d400ULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x00000050008d7306ULL, 0x000fe20000005400ULL, 0x000000a6a500720bULL, 0x004fce0003fdd000ULL,
0x0000005000767306ULL, 0x0003ec000000d400ULL, 0x0000000198986812ULL, 0x000fe400078efcffULL,
0x0000008e00937306ULL, 0x000fe20000209400ULL, 0x0000010050507824ULL, 0x002fe200078e00ffULL,
0x0000009d9803723eULL, 0x000fc800000010ffULL, 0x00000018ffa57819ULL, 0x000fe20000011450ULL,
0x00000010a0507824ULL, 0x000fe200078e00ffULL, 0x0000008e00947306ULL, 0x000e700000205400ULL,
0x0000008a008f7306ULL, 0x000fe20000209400ULL, 0x000000025434723cULL, 0x008f6e0000041834ULL,
0x0000008a00b67306ULL, 0x0004e20000205400ULL, 0x000000949300720bULL, 0x002fc40003fbd000ULL,
0x0000008e00937245ULL, 0x000fca000020d400ULL, 0x00000051007c7306ULL, 0x000fe20000009400ULL,
0x0000008a008a7245ULL, 0x004fca000020d400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x00000051007d7306ULL, 0x000fe20000005400ULL, 0x000000b68f00720bULL, 0x008fce0003f3d000ULL,
0x00000051006d7306ULL, 0x000fec000000d400ULL, 0x000000018a8a1812ULL, 0x000fe400078efcffULL,
0x00000052006c7306ULL, 0x000fe40000009400ULL, 0x000000798a8a723eULL, 0x000fcc00000010ffULL,
0x0000005200737306ULL, 0x000ff00000005400ULL, 0x0000005200707306ULL, 0x000ff0000000d400ULL,
0x0000005300757306ULL, 0x000ff00000009400ULL, 0x0000005300787306ULL, 0x000ff00000005400ULL,
0x00000053006f7306ULL, 0x0003f0000000d400ULL, 0x0000009b00a17306ULL, 0x000fe20000209400ULL,
0x000000005050783bULL, 0x002e6e0000000200ULL, 0x0000009b00a47306ULL, 0x0004f00000205400ULL,
0x00000095009e7306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x004fce000020d400ULL,
0x00000095009f7306ULL, 0x0005220000205400ULL, 0x000000a4a100720bULL, 0x008fce0003f9d000ULL,
0x0000006e00727306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x004fca000020d400ULL,
0x000000019b9b4812ULL, 0x000fe400078efcffULL, 0x0000006e00717306ULL, 0x0004e20000205400ULL,
0x0000009f9e00720bULL, 0x010fe20003fdd000ULL, 0x000000025030723cULL, 0x002b620000041830ULL,
0x0000007a9b7a723eULL, 0x000fca00000010ffULL, 0x000000b700b07306ULL, 0x000fe20000209400ULL,
0x0000006e006e7245ULL, 0x004fe4000020d400ULL, 0x000000a300027245ULL, 0x020fe4000020d400ULL,
0x000000a800037245ULL, 0x000fe4000020d400ULL, 0x0000000195956812ULL, 0x000fe200078efcffULL,
0x000000b700b17306ULL, 0x000e620000205400ULL, 0x000000717200720bULL, 0x008fe40003f3d000ULL,
0x0000008d8c00720bULL, 0x000fc40003fdd000ULL, 0x000000ab00717245ULL, 0x000fe4000020d400ULL,
0x000000955a7b723eULL, 0x000fe200000010ffULL, 0x000000af00ac7306ULL, 0x000fec0000209400ULL,
0x000000016e6e1812ULL, 0x000fe200078efcffULL, 0x0000007a5038723cULL, 0x000f620000041838ULL,
0x000000af00a97306ULL, 0x0004e20000205400ULL, 0x000000b1b000720bULL, 0x002fc40003fbd000ULL,
0x0000000176766812ULL, 0x000fe400078efcffULL, 0x000000787500720bULL, 0x000fe40003fdd000ULL,
0x0000007a543c723cULL, 0x000f62000004183cULL, 0x0000009200967306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x004fca000020d400ULL, 0x000000018b8b5812ULL, 0x000fe400078efcffULL,
0x0000009200977306ULL, 0x0002a20000205400ULL, 0x000000a9ac00720bULL, 0x008fe40003f5d000ULL,
0x000000016f6f6812ULL, 0x000fe400078efcffULL, 0x0000008b6e8b723eULL, 0x000fc600000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x002fc6000020d400ULL,
0x0000008a5048723cULL, 0x080f640000041848ULL, 0x00000001afaf2812ULL, 0x000fe400078efcffULL,
0x0000007e00807306ULL, 0x0002e20000205400ULL, 0x000000979600720bULL, 0x004fe40003f9d000ULL,
0x00000076af76723eULL, 0x000fe200000010ffULL, 0x0000008a544c723cULL, 0x000f68000004184cULL,
0x000000a500a67306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x002fca000020d400ULL,
0x0000000192924812ULL, 0x000fe400078efcffULL, 0x000000a500a77306ULL, 0x0002a20000205400ULL,
0x000000807f00720bULL, 0x008fe40003f3d000ULL, 0x0000007d7c00720bULL, 0x000fe40003f9d000ULL,
0x000000779292723eULL, 0x000fc600000010ffULL, 0x000000a300a17306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x002fca000020d400ULL, 0x000000017e7e1812ULL, 0x000fe400078efcffULL,
0x000000a3009a7306ULL, 0x000e620000205400ULL, 0x000000a7a600720bULL, 0x004fe40003fbd000ULL,
0x000000016d6d4812ULL, 0x000fca00078efcffULL, 0x0000006b00917306ULL, 0x000fec0000209400ULL,
0x00000001a5a55812ULL, 0x000fe400078efcffULL, 0x0000006b00907306ULL, 0x000ea20000205400ULL,
0x0000009aa100720bULL, 0x002fe40003f5d000ULL, 0x000000a57e77723eULL, 0x000fca00000010ffULL,
0x0000008100827306ULL, 0x000fe40000209400ULL, 0x000000765028723cULL, 0x080f680000041828ULL,
0x0000000102022812ULL, 0x000fe400078efcffULL, 0x0000008100837306ULL, 0x000e620000205400ULL,
0x000000909100720bULL, 0x004fe20003f7d000ULL, 0x000000765408723cULL, 0x000f620000041808ULL,
0x0000006d0202723eULL, 0x000fca00000010ffULL, 0x000000a8005b7306ULL, 0x000fec0000209400ULL,
0x0000000118183812ULL, 0x000fe400078efcffULL, 0x000000a8008c7306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fe40003f3d000ULL, 0x000000736c00720bULL, 0x000fc40003f7d000ULL,
0x000000931893723eULL, 0x000fe400000010ffULL, 0x0000008100187245ULL, 0x000fe2000020d400ULL,
0x000000aa00197306ULL, 0x000fe80000209400ULL, 0x000000925040723cULL, 0x000f640000041840ULL,
0x0000000118181812ULL, 0x000fe400078efcffULL, 0x000000aa002c7306ULL, 0x000e620000205400ULL,
0x0000008c5b00720bULL, 0x004fc40003fbd000ULL, 0x0000000170703812ULL, 0x000fe200078efcffULL,
0x000000925444723cULL, 0x000f680000041844ULL, 0x000000ab002d7306ULL, 0x000fec0000209400ULL,
0x0000000103035812ULL, 0x000fc400078efcffULL, 0x000000ab002e7306ULL, 0x000ea20000205400ULL,
0x0000002c1900720bULL, 0x002fe40003f5d000ULL, 0x000000aa00197245ULL, 0x000fe4000020d400ULL,
0x000000031803723eULL, 0x000fe400000010ffULL, 0x000000ad00187245ULL, 0x000fe2000020d400ULL,
0x0000008400857306ULL, 0x000fe80000209400ULL, 0x000000025020723cULL, 0x000f640000041820ULL,
0x0000000119192812ULL, 0x000fc400078efcffULL, 0x0000008400867306ULL, 0x0002e20000205400ULL,
0x0000002e2d00720bULL, 0x004fe40003f3d000ULL, 0x000000701970723eULL, 0x000fe200000010ffULL,
0x00000002540c723cULL, 0x000b62000004180cULL, 0x000000a200197245ULL, 0x000fc6000020d400ULL,
0x0000008700887306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x002fe4000020d400ULL,
0x0000000469027810ULL, 0x020fc60007ffe0ffULL, 0x0000000171711812ULL, 0x000fe400078efcffULL,
0x0000008700897306ULL, 0x000e620000205400ULL, 0x000000868500720bULL, 0x008fe20003f9d000ULL,
0x000000ffff697224ULL, 0x000fe200078e0002ULL, 0x000000180200780cULL, 0x000fca0003f25270ULL,
0x000000ad002f7306ULL, 0x000fec0000209400ULL, 0x0000000184844812ULL, 0x000fe400078efcffULL,
0x000000ad00587306ULL, 0x000ea20000205400ULL, 0x000000898800720bULL, 0x002fe40003fbd000ULL,
0x000000718471723eULL, 0x000fca00000010ffULL, 0x000000a200597306ULL, 0x000fe40000209400ULL,
0x000000705004723cULL, 0x080b6c0000041804ULL, 0x000000a2002c7306ULL, 0x000e620000205400ULL,
0x000000582f00720bULL, 0x004fe20003f5d000ULL, 0x000000705410723cULL, 0x000b580000041810ULL,
0x0000000118182812ULL, 0x000fe400078efcffULL, 0x0000002c5900720bULL, 0x002fe40003f7d000ULL,
0x00000087002c7245ULL, 0x000fe4000020d400ULL, 0x0000006f1818723eULL, 0x000fe400000010ffULL,
0x000000012c2c5812ULL, 0x000fce00078efcffULL, 0x0000000119193812ULL, 0x000fc800078efcffULL,
0x000000192c19723eULL, 0x000fce00000010ffULL, 0x000000185024723cULL, 0x080b700000041824ULL,
0x00000018541c723cULL, 0x000b62000004181cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffdef000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff657224ULL, 0x000fe200078e005fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd25000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000005c4a197220ULL, 0x0a0fe20000410000ULL, 0x0000005c284a7220ULL, 0x080fe20000410000ULL,
0x0000005c25257220ULL, 0x080fe20000410000ULL, 0x0000005c38387220ULL, 0x080fe20000410000ULL,
0x0000005c39397220ULL, 0x080fe20000410000ULL, 0x0000005c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000005c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000005c22287220ULL, 0x080fe20000410000ULL,
0x0000005c24247220ULL, 0x080fe20000410000ULL, 0x0000005c36557220ULL, 0x080fe20000410000ULL,
0x0000005c30307220ULL, 0x080fe20000410000ULL, 0x0000005c31317220ULL, 0x080fe20000410000ULL,
0x0000005c32327220ULL, 0x080fe20000410000ULL, 0x0000005c33337220ULL, 0x080fe20000410000ULL,
0x0000005c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005c40407220ULL, 0x080fe20000410000ULL,
0x0000005c41417220ULL, 0x080fe20000410000ULL, 0x0000005c4b2c7220ULL, 0x080fe20000410000ULL,
0x0000005c29297220ULL, 0x080fe20000410000ULL, 0x0000005c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000005c232d7220ULL, 0x080fe20000410000ULL, 0x0000005c262e7220ULL, 0x080fe20000410000ULL,
0x0000005c272f7220ULL, 0x080fe20000410000ULL, 0x0000005c35357220ULL, 0x080fe20000410000ULL,
0x0000005c37567220ULL, 0x080fe20000410000ULL, 0x0000005c3c367220ULL, 0x080fe20000410000ULL,
0x0000005c42037220ULL, 0x080fe20000410000ULL, 0x0000005c43187220ULL, 0x080fe20000410000ULL,
0x0000005c48027220ULL, 0x080fe20000410000ULL, 0x0000005c04047220ULL, 0x080fe20000410000ULL,
0x0000005c05057220ULL, 0x080fe20000410000ULL, 0x0000005c06067220ULL, 0x080fe20000410000ULL,
0x0000005c07077220ULL, 0x080fe20000410000ULL, 0x0000005c34507220ULL, 0x080fe20000410000ULL,
0x0000005c3d377220ULL, 0x080fe20000410000ULL, 0x0000005c3e577220ULL, 0x080fe20000410000ULL,
0x0000005c44517220ULL, 0x080fe20000410000ULL, 0x0000005c45527220ULL, 0x080fe20000410000ULL,
0x0000005c4c537220ULL, 0x080fe20000410000ULL, 0x0000005c4d547220ULL, 0x080fe20000410000ULL,
0x0000005c08087220ULL, 0x080fe20000410000ULL, 0x0000005c09097220ULL, 0x080fe20000410000ULL,
0x0000005c0c0c7220ULL, 0x080fe20000410000ULL, 0x0000005c0d0d7220ULL, 0x080fe20000410000ULL,
0x0000005c10107220ULL, 0x080fe20000410000ULL, 0x0000005c11117220ULL, 0x080fe20000410000ULL,
0x0000005c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000005c21427220ULL, 0x080fe20000410000ULL,
0x0000005c3f587220ULL, 0x080fe20000410000ULL, 0x0000005c475a7220ULL, 0x080fe20000410000ULL,
0x0000005c0a5b7220ULL, 0x080fe20000410000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e0025ULL,
0x0000005c20437220ULL, 0x080fe20000410000ULL, 0x0000005c46597220ULL, 0x080fe20000410000ULL,
0x0000005c1d0a7220ULL, 0x080fe20000410000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0038ULL,
0x0000005c1f6a7220ULL, 0x080fe20000410000ULL, 0x000000ffff477224ULL, 0x000fe200078e0039ULL,
0x0000005c49497220ULL, 0x080fe20000410000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0024ULL,
0x0000005c4e4e7220ULL, 0x080fe20000410000ULL, 0x000000ffff217224ULL, 0x000fe200078e003bULL,
0x0000005c4f4f7220ULL, 0x080fe20000410000ULL, 0x000000ffff237224ULL, 0x000fe200078e002aULL,
0x0000005c0b0b7220ULL, 0x080fe20000410000ULL, 0x000000ffff257224ULL, 0x000fe200078e0028ULL,
0x0000005c0e657220ULL, 0x080fe20000410000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e0030ULL,
0x0000005c0f667220ULL, 0x080fe20000410000ULL, 0x000000ffff467224ULL, 0x000fe200078e0031ULL,
0x0000005c12677220ULL, 0x080fe20000410000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0040ULL,
0x0000005c13687220ULL, 0x080fe20000410000ULL, 0x000000ffff487224ULL, 0x000fe200078e0041ULL,
0x0000005c1e697220ULL, 0x000fe20000410000ULL, 0x000000ffff447224ULL, 0x000fc400078e0029ULL,
0x000000ffff207224ULL, 0x000fe400078e0032ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0033ULL,
0x000000ffff1d7224ULL, 0x000fe400078e003aULL, 0x000000ffff247224ULL, 0x000fe400078e002cULL,
0x000000ffff3b7224ULL, 0x000fe400078e002bULL, 0x000000ffff347224ULL, 0x000fc400078e002dULL,
0x000000ffff397224ULL, 0x000fe400078e002eULL, 0x000000ffff387224ULL, 0x000fe400078e002fULL,
0x000000ffff287224ULL, 0x000fe400078e0035ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0036ULL,
0x000000ffff457224ULL, 0x000fe400078e0002ULL, 0x000000ffff417224ULL, 0x000fc400078e0004ULL,
0x000000ffff407224ULL, 0x000fe400078e0005ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0003ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0018ULL, 0x000000ffff227224ULL, 0x000fe400078e0019ULL,
0x000000ffff267224ULL, 0x000fe400078e0006ULL, 0x000000ffff277224ULL, 0x000fc400078e0007ULL,
0x000000ffff297224ULL, 0x000fe400078e0050ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0037ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0051ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0052ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0053ULL, 0x000000ffff2f7224ULL, 0x000fc400078e0054ULL,
0x000000ffff307224ULL, 0x000fe400078e0008ULL, 0x000000ffff317224ULL, 0x000fe400078e0009ULL,
0x000000ffff327224ULL, 0x000fe400078e000cULL, 0x000000ffff337224ULL, 0x000fe400078e000dULL,
0x000000ffff3a7224ULL, 0x000fe400078e0010ULL, 0x000000ffff357224ULL, 0x000fc400078e0011ULL,
0x000000ffff367224ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005d067f8cULL, 0x0002a2000c80043fULL, 0x000000ffff377224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e000bULL, 0x000000ffff1e7224ULL, 0x000fe400078e0055ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0056ULL, 0x000000ffff197224ULL, 0x000fc400078e0057ULL,
0x000000ffff187224ULL, 0x000fe400078e0058ULL, 0x000000ffff137224ULL, 0x000fe400078e0059ULL,
0x000000ffff127224ULL, 0x000fe400078e005aULL, 0x000000ffff117224ULL, 0x000fe400078e004eULL,
0x000000ffff0f7224ULL, 0x000fe400078e004fULL, 0x000000ffff107224ULL, 0x000fc400078e005bULL,
0x000000ffff087224ULL, 0x000fe400078e0065ULL, 0x000000ffff097224ULL, 0x000fe400078e0066ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0067ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0068ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0069ULL, 0x000000ffff0d7224ULL, 0x000fc400078e006aULL,
0x0000000000027805ULL, 0x006fca0000015200ULL, 0x000004005d057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x00000004024f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000004f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004005d057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000417027824ULL, 0x000fe200078e00ffULL,
0x000000636000720cULL, 0x000fc80003f06070ULL, 0xfffffff002037812ULL, 0x000fca00078ec0ffULL,
0x000000801a037824ULL, 0x000fca00078e0203ULL, 0x0124000003047984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x00000100604f7824ULL, 0x000fe200078e021bULL,
0x0000000017507211ULL, 0x040fe200078ff0ffULL, 0x0000000217517824ULL, 0x000fe400078e00ffULL,
0x00000002ff727424ULL, 0x000fe200078e00ffULL, 0x0000004f164e7217ULL, 0x000fe40007800000ULL,
0x00005a00ff527a19ULL, 0x000fe40000011650ULL, 0x0000001050577810ULL, 0x000fe20007ffe0ffULL,
0x000000014e4e7824ULL, 0x000fe200078e0a4fULL, 0x00000006514f7812ULL, 0x000fc400078ec0ffULL,
0x0000000850517810ULL, 0x040fe40007ffe0ffULL, 0x0000001850587810ULL, 0x000fe20007ffe0ffULL,
0x0000000162537824ULL, 0x000fe200078e024fULL, 0x00005a00ff567a19ULL, 0x000fe40000011651ULL,
0x000058004f517a10ULL, 0x000fe20007ffe0ffULL, 0x0000000153547824ULL, 0x140fe200078e0a4eULL,
0x0000004e5300720cULL, 0x080fe40003f26070ULL, 0x0000004e5100720cULL, 0x040fe20003f06070ULL,
0x0000000151507824ULL, 0x000fe200078e0a4eULL, 0x0000005461547217ULL, 0x000fc40003800000ULL,
0x0000005261537217ULL, 0x040fe40003800000ULL, 0x0000005061507217ULL, 0x000fe40003800000ULL,
0x00005a00ff587a19ULL, 0x000fe20000011658ULL, 0x0000005364787224ULL, 0x000fe200078e02ffULL,
0x000000ff506d7207ULL, 0x000fe40000000000ULL, 0x00005a00ff507a19ULL, 0x000fe40000011657ULL,
0x00000004ff547819ULL, 0x000fc40000011654ULL, 0x0000005661557217ULL, 0x040fe40003800000ULL,
0x0000005061537217ULL, 0x040fe40003800000ULL, 0x0000005861657217ULL, 0x000fe20003800000ULL,
0x0000005564847224ULL, 0x000fe200078e02ffULL, 0x000000ff545b7207ULL, 0x000fe20000800000ULL,
0x0000005364867224ULL, 0x040fe200078e02ffULL, 0x000000786d557211ULL, 0x040fe200078fe0ffULL,
0x00000065648e7224ULL, 0x000fe200078e02ffULL, 0x000000846d597211ULL, 0x000fe200078fe0ffULL,
0x0000000178577824ULL, 0x000fc400078e025bULL, 0x000000015b677824ULL, 0x040fe400078e0284ULL,
0x000000015b6b7824ULL, 0x040fe400078e0286ULL, 0x000000015b717824ULL, 0x000fe200078e028eULL,
0x000000104f5b7812ULL, 0x000fe200078efcffULL, 0x0000600055547625ULL, 0x000fc800078e0072ULL,
0x0000600057567625ULL, 0x080fe200078e0072ULL, 0x000058005b657a10ULL, 0x000fe20007ffe0ffULL,
0x0000000854507981ULL, 0x000724000c1e9500ULL, 0x0000600059587625ULL, 0x000fe400078e0072ULL,
0x0000000856537981ULL, 0x000322000c1e9500ULL, 0x000000866d697211ULL, 0x000fe200078fe0ffULL,
0x0000000162737824ULL, 0x000fe400078e025bULL, 0x0000000858527981ULL, 0x000524000c1e9500ULL,
0x00000001735a7824ULL, 0x000fe200078e0a4eULL, 0x0000008e6d6f7211ULL, 0x000fe200078fe0ffULL,
0x0000600069687625ULL, 0x000fe200078e0072ULL, 0x0000004e6500720cULL, 0x000fc60003f06070ULL,
0x0000000165587824ULL, 0x004fe400078e0a4eULL, 0x0000600067667625ULL, 0x000fe200078e0072ULL,
0x0000005a615a7217ULL, 0x040fe20003800000ULL, 0x0000000868547981ULL, 0x0084e2000c1e9500ULL,
0x0000005861587217ULL, 0x000fe20003800000ULL, 0x000060006b6a7625ULL, 0x080fe400078e0072ULL,
0x0000000866577981ULL, 0x0022e2000c1e9500ULL, 0x000000ff58897207ULL, 0x000fe20000000000ULL,
0x000060006f6e7625ULL, 0x000fc400078e0072ULL, 0x000000086a597981ULL, 0x0002e2000c1e9500ULL,
0x0000004e7300720cULL, 0x000fe40003f26070ULL, 0x00000004ff5a7819ULL, 0x000fe2000001165aULL,
0x000000086e557981ULL, 0x0002e2000c1e9500ULL, 0x0000007889697211ULL, 0x004fe200078fe0ffULL,
0x0000600071707625ULL, 0x000fc800078e0072ULL, 0x0000600069687625ULL, 0x000fe200078e0072ULL,
0x00000084896b7211ULL, 0x002fe200078fe0ffULL, 0x0000000870567981ULL, 0x0002a2000c1e9500ULL,
0x000000ff5a6f7207ULL, 0x000fc60000800000ULL, 0x0000000868587981ULL, 0x0002a4000c1e9500ULL,
0x000000016f757824ULL, 0x000fe400078e0286ULL, 0x0000000178677824ULL, 0x000fe400078e026fULL,
0x000060006b6a7625ULL, 0x000fc800078e0072ULL, 0x0000600075687625ULL, 0x002fe200078e0072ULL,
0x000000204f757812ULL, 0x000fe200078efcffULL, 0x000000086a5a7981ULL, 0x0002a4000c1e9500ULL,
0x000000016f737824ULL, 0x040fe400078e0284ULL, 0x000000016f777824ULL, 0x000fe200078e028eULL,
0x0000008689717211ULL, 0x000fe200078fe0ffULL, 0x0000600067667625ULL, 0x000fe200078e0072ULL,
0x0000008e897d7211ULL, 0x000fe200078fe0ffULL, 0x0000000868797981ULL, 0x0002a4000c1e9500ULL,
0x00006000736e7625ULL, 0x000fc400078e0072ULL, 0x0000000866677981ULL, 0x0002a4000c1e9500ULL,
0x00000001627f7824ULL, 0x000fe400078e0275ULL, 0x00006000776a7625ULL, 0x002fe200078e0072ULL,
0x0000580075777a10ULL, 0x000fe20007ffe0ffULL, 0x000000086e737981ULL, 0x0002a4000c1e9500ULL,
0x000000017f767824ULL, 0x100fe400078e0a4eULL, 0x0000000177747824ULL, 0x000fe200078e0a4eULL,
0x0000004e7f00720cULL, 0x000fe20003f26070ULL, 0x0000600071707625ULL, 0x000fe200078e0072ULL,
0x0000007661767217ULL, 0x000fe20003800000ULL, 0x000000086a7b7981ULL, 0x0002a2000c1e9500ULL,
0x0000004e7700720cULL, 0x000fe20003f06070ULL, 0x000060007d7c7625ULL, 0x000fe200078e0072ULL,
0x0000007461747217ULL, 0x000fe20003800000ULL, 0x0000000870667981ULL, 0x0002a2000c1e9500ULL,
0x00000004ff767819ULL, 0x000fc40000011676ULL, 0x000000ff748f7207ULL, 0x000fe20000000000ULL,
0x000000087c6c7981ULL, 0x0002a2000c1e9500ULL, 0x000000ff76697207ULL, 0x000fe40000800000ULL,
0x000000848f837211ULL, 0x000fc600078fe0ffULL, 0x0000000169717824ULL, 0x002fe400078e0284ULL,
0x0000600083827625ULL, 0x000fe200078e0072ULL, 0x000000788f6b7211ULL, 0x000fc600078fe0ffULL,
0x0000600071707625ULL, 0x080fe200078e0072ULL, 0x0000000882767981ULL, 0x0002a6000c1e9500ULL,
0x00000001787f7824ULL, 0x000fe200078e0269ULL, 0x0000000870cb7981ULL, 0x0002a2000c1e9500ULL,
0x000060006b6a7625ULL, 0x000fe200078e0072ULL, 0x000000868f6f7211ULL, 0x040fe400078fe0ffULL,
0x0000008e8f857211ULL, 0x000fe200078fe0ffULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x000000304fb17812ULL, 0x000fe200078efcffULL, 0x000000086a747981ULL, 0x0002a4000c1e9500ULL,
0x00000001697d7824ULL, 0x000fc400078e0286ULL, 0x0000000169877824ULL, 0x000fe200078e028eULL,
0x000000087e817981ULL, 0x0002a2000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x00005800b1b37a10ULL, 0x000fc60007ffe0ffULL, 0x0000600085687625ULL, 0x080fe200078e0072ULL,
0x000000086ecf7981ULL, 0x0002a6000c1e9500ULL, 0x000060007d7c7625ULL, 0x080fe200078e0072ULL,
0x0000000868d37981ULL, 0x0002a6000c1e9500ULL, 0x00006000876a7625ULL, 0x002fe200078e0072ULL,
0x000000087c8a7981ULL, 0x0002a6000c1e9500ULL, 0x00000001627f7824ULL, 0x000fe200078e02b1ULL,
0x000000086a907981ULL, 0x0002a6000c1e9500ULL, 0x000000017f7e7824ULL, 0x000fc400078e0a4eULL,
0x00000001b37a7824ULL, 0x000fc600078e0a4eULL, 0x0000007e617e7217ULL, 0x000fe40003800000ULL,
0x0000004e7f00720cULL, 0x080fe40003f26070ULL, 0x0000004eb300720cULL, 0x000fe40003f06070ULL,
0x0000007a617a7217ULL, 0x000fe40003800000ULL, 0x00000004ff7e7819ULL, 0x000fe4000001167eULL,
0x000000ff7a957207ULL, 0x000fc40000000000ULL, 0x000000ff7e837207ULL, 0x000fe40000800000ULL,
0x00000078957d7211ULL, 0x042fe400078fe0ffULL, 0x00000086956b7211ULL, 0x000fe200078fe0ffULL,
0x00000001787f7824ULL, 0x000fe400078e0283ULL, 0x00000001836f7824ULL, 0x000fe400078e0286ULL,
0x000060007d7c7625ULL, 0x000fc800078e0072ULL, 0x000060007f7e7625ULL, 0x080fe200078e0072ULL,
0x000000087cb57981ULL, 0x0002a6000c1e9500ULL, 0x000060006b6a7625ULL, 0x080fe200078e0072ULL,
0x000000087e807981ULL, 0x0002a6000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x000000086ad17981ULL, 0x0002a2000c1e9500ULL, 0x0000008495697211ULL, 0x000fc600078fe0ffULL,
0x000000086e8c7981ULL, 0x0002a2000c1e9500ULL, 0x0000000183717824ULL, 0x000fe400078e0284ULL,
0x0000600069687625ULL, 0x000fc800078e0072ULL, 0x0000600071707625ULL, 0x000fe200078e0072ULL,
0x0000000868cd7981ULL, 0x0002a4000c1e9500ULL, 0x0000008e957d7211ULL, 0x002fe400078fe0ffULL,
0x0000000870887981ULL, 0x0002a2000c1e9500ULL, 0x00000001837f7824ULL, 0x000fe400078e028eULL,
0x000060007d7c7625ULL, 0x000fc800078e0072ULL, 0x000060007f7e7625ULL, 0x000fe200078e0072ULL,
0x000000087cd57981ULL, 0x0002a8000c1e9500ULL, 0x000000087e8e7981ULL, 0x0002a2000c1e9500ULL,
0xfffffff06d6d7812ULL, 0x000fe200078ec0ffULL, 0x00000001ffc97424ULL, 0x000fc800078e00ffULL,
0x000000014e687824ULL, 0x000fc800078e026dULL, 0x0000000151697824ULL, 0x000fe200078e0a68ULL,
0x000000014f837812ULL, 0x000fc800078efcffULL, 0x00000069c9697219ULL, 0x000fe400000006ffULL,
0x00005800836b7a10ULL, 0x000fe40007ffe0ffULL, 0x000000084f857812ULL, 0x000fc600078efcffULL,
0x000000016b6a7824ULL, 0x100fe200078e0a68ULL, 0x000000094f877812ULL, 0x000fe400078efcffULL,
0x00005800856f7a10ULL, 0x000fe40007ffe0ffULL, 0x0000006ac96d7219ULL, 0x000fe400000006ffULL,
0x00005800877d7a10ULL, 0x002fe20007ffe0ffULL, 0x000000016f6e7824ULL, 0x000fc800078e0a68ULL,
0x000000017d687824ULL, 0x000fe200078e0a68ULL, 0x000000114f8b7812ULL, 0x000fe400078efcffULL,
0xfffffff089897812ULL, 0x000fe400078ec0ffULL, 0x0000006ec9717219ULL, 0x040fe400000006ffULL,
0x00000068c97f7219ULL, 0x000fe200000006ffULL, 0x000000014e707824ULL, 0x000fe200078e0289ULL,
0x000058008b8d7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff08f8f7812ULL, 0x000fe200078ec0ffULL,
0x0000000165687824ULL, 0x000fc400078e0a70ULL, 0x000000018d6a7824ULL, 0x000fe200078e0a70ULL,
0x000000184f917812ULL, 0x040fe200078efcffULL, 0x000000014e727824ULL, 0x000fe200078e028fULL,
0x000000194f977812ULL, 0x000fe400078efcffULL, 0x00000068c9897219ULL, 0x040fe400000006ffULL,
0x0000006ac98f7219ULL, 0x000fe400000006ffULL, 0x0000541050507816ULL, 0x010fc80000000053ULL,
0x0000005069ff7212ULL, 0x000fc800078ac0ffULL, 0x0000004e5100720cULL, 0x000fc80002fa1470ULL,
0x0000004e4f00720cULL, 0x000fe40002fa1070ULL, 0x000000506dff7212ULL, 0x000fe4000782c0ffULL,
0xff8000004d4d7808ULL, 0x000fe40002800000ULL, 0x0000541052527816ULL, 0x008fe40000000057ULL,
0x0000541054547816ULL, 0x000fe40000000059ULL, 0x0000005269ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005469ff7212ULL, 0x000fe4000788c0ffULL, 0x000000526dff7212ULL, 0x000fe400078ac0ffULL,
0x0000004e5100720cULL, 0x0c0fe40001741470ULL, 0x0000004e5100720cULL, 0x080fe40002781470ULL,
0x0000004e6b00720cULL, 0x0c0fe40000f21470ULL, 0x0000004e6b00720cULL, 0x000fc40002fa1470ULL,
0x0000004e4f00720cULL, 0x0c0fe40001741070ULL, 0x0000004e4f00720cULL, 0x080fe40002781070ULL,
0x0000004e8300720cULL, 0x0c0fe40000f21070ULL, 0x0000004e8300720cULL, 0x000fe40002fa1070ULL,
0x0000541055567816ULL, 0x004fe40000000056ULL, 0xff80000020207808ULL, 0x000fc40001000000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff80000046467808ULL, 0x000fe40000800000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x0000005071ff7212ULL, 0x000fe4000786c0ffULL,
0x0000005669ff7212ULL, 0x000fe4000780c0ffULL, 0x000000546dff7212ULL, 0x000fc4000784c0ffULL,
0x000000566dff7212ULL, 0x000fe4000788c0ffULL, 0x000000527fff7212ULL, 0x000fe4000782c0ffULL,
0x0000005471ff7212ULL, 0x000fe400078ac0ffULL, 0x0000004e5100720cULL, 0x080fe40000701470ULL,
0x0000004e6b00720cULL, 0x0c0fe40001741470ULL, 0x0000004e6b00720cULL, 0x000fc40002781470ULL,
0x0000004e6f00720cULL, 0x0c0fe40001f61470ULL, 0x0000004e6f00720cULL, 0x080fe40002fa1470ULL,
0x0000004e7d00720cULL, 0x080fe40000f21470ULL, 0x0000004e4f00720cULL, 0x080fe40000701070ULL,
0x0000004e8300720cULL, 0x0c0fe40001741070ULL, 0x0000004e8300720cULL, 0x000fc40002781070ULL,
0x0000004e8500720cULL, 0x0c0fe40001f61070ULL, 0x0000004e8500720cULL, 0x080fe40002fa1070ULL,
0x0000004e8700720cULL, 0x000fe40000f21070ULL, 0x0000541058587816ULL, 0x000fe40000000067ULL,
0x000054105a5a7816ULL, 0x000fe40000000073ULL, 0x0000580091937a10ULL, 0x000fc40007ffe0ffULL,
0x0000580097997a10ULL, 0x000fe40007ffe0ffULL, 0xff8000001e1e7808ULL, 0x000fe40000000000ULL,
0xff80000028287808ULL, 0x000fe40001000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002000000ULL,
0xff8000004b4b7808ULL, 0x000fe40001800000ULL, 0xff8000002a2a7808ULL, 0x000fc40002800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0x0000005271ff7212ULL, 0x000fe4000780c0ffULL,
0x000000547fff7212ULL, 0x000fe4000784c0ffULL, 0x0000005671ff7212ULL, 0x080fe4000788c0ffULL,
0x000000567fff7212ULL, 0x000fe4000786c0ffULL, 0x000000588fff7212ULL, 0x000fc400078ac0ffULL,
0x0000005a89ff7212ULL, 0x000fe2000782c0ffULL, 0x00000001936e7824ULL, 0x100fe200078e0a70ULL,
0xfffffff095957812ULL, 0x000fe200078ec0ffULL, 0x0000000199707824ULL, 0x000fe200078e0a70ULL,
0x0000004e6f00720cULL, 0x0c0fe40000701470ULL, 0x0000004e6f00720cULL, 0x080fe40002781470ULL,
0x0000004e7d00720cULL, 0x0c0fe40001741470ULL, 0x0000004e7d00720cULL, 0x000fc40001f61470ULL,
0x0000004e6500720cULL, 0x080fe40000f21470ULL, 0x0000004e8d00720cULL, 0x080fe20002fa1470ULL,
0x000000014e7e7824ULL, 0x000fe200078e0295ULL, 0x0000004e8500720cULL, 0x0c0fe40000701070ULL,
0x0000004e8500720cULL, 0x080fe40002781070ULL, 0x0000004e8700720cULL, 0x0c0fe40001741070ULL,
0x0000004e8700720cULL, 0x000fc40001f61070ULL, 0x0000004e5b00720cULL, 0x080fe40000f21070ULL,
0x0000004e8b00720cULL, 0x000fe40002fa1070ULL, 0x0000006ec9957219ULL, 0x040fe400000006ffULL,
0x00000070c99b7219ULL, 0x000fe400000006ffULL, 0x0000541066667816ULL, 0x000fe40000000079ULL,
0x000054106c6c7816ULL, 0x000fc4000000007bULL, 0xff8000001d1d7808ULL, 0x000fe40000000000ULL,
0xff80000019197808ULL, 0x000fe40002000000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000018187808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40000800000ULL,
0xff80000048487808ULL, 0x000fc40002800000ULL, 0x0000005889ff7212ULL, 0x080fe4000780c0ffULL,
0x0000005895ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006689ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006c89ff7212ULL, 0x000fe4000786c0ffULL, 0x000000668fff7212ULL, 0x000fe4000782c0ffULL,
0x0000005a9bff7212ULL, 0x000fe200078ac0ffULL, 0x0000000177787824ULL, 0x000fe200078e0a72ULL,
0x0000004e6500720cULL, 0x000fc40000701470ULL, 0x0000004e6500720cULL, 0x0c0fe40001741470ULL,
0x0000004e6500720cULL, 0x080fe40001f61470ULL, 0x0000004e8d00720cULL, 0x080fe40000f21470ULL,
0x0000004e9300720cULL, 0x080fe40002781470ULL, 0x0000004e9900720cULL, 0x000fe40002fa1470ULL,
0x000000214f9f7812ULL, 0x000fc400078efcffULL, 0x0000004e5b00720cULL, 0x0c0fe40000701070ULL,
0x0000004e5b00720cULL, 0x0c0fe40001741070ULL, 0x0000004e5b00720cULL, 0x080fe40001f61070ULL,
0x0000004e8b00720cULL, 0x080fe40000f21070ULL, 0x0000004e9100720cULL, 0x080fe40002781070ULL,
0x0000004e9700720cULL, 0x000fc40002fa1070ULL, 0x00000078c99d7219ULL, 0x000fe400000006ffULL,
0x0000541076767816ULL, 0x000fe400000000cbULL, 0x000058009fa17a10ULL, 0x000fe40007ffe0ffULL,
0xff8000004c4c7808ULL, 0x000fe40000000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001000000ULL,
0xff80000013137808ULL, 0x000fc40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40000800000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0x0000005a8fff7212ULL, 0x040fe4000780c0ffULL, 0x0000006c8fff7212ULL, 0x000fe4000784c0ffULL,
0x0000005a95ff7212ULL, 0x000fc4000786c0ffULL, 0x000000669bff7212ULL, 0x040fe4000782c0ffULL,
0x0000006c9bff7212ULL, 0x000fe4000788c0ffULL, 0x000000769dff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a17a7824ULL, 0x000fe200078e0a72ULL, 0x0000004e8d00720cULL, 0x0c0fe40000701470ULL,
0x0000004e8d00720cULL, 0x080fe40001741470ULL, 0x0000004e9300720cULL, 0x000fc40001f61470ULL,
0x0000004e9900720cULL, 0x0c0fe40000f21470ULL, 0x0000004e9900720cULL, 0x080fe40002781470ULL,
0x0000004e7700720cULL, 0x080fe40002fa1470ULL, 0x000000284fa57812ULL, 0x040fe400078efcffULL,
0x000000294fab7812ULL, 0x000fe400078efcffULL, 0x0000004e8b00720cULL, 0x000fc40000701070ULL,
0x0000004e8b00720cULL, 0x080fe40001741070ULL, 0x0000004e9100720cULL, 0x080fe40001f61070ULL,
0x0000004e9700720cULL, 0x0c0fe40000f21070ULL, 0x0000004e9700720cULL, 0x080fe40002781070ULL,
0x0000004e7500720cULL, 0x000fe40002fa1070ULL, 0x0000007ac9a37219ULL, 0x000fc400000006ffULL,
0x0000541074747816ULL, 0x000fe40000000081ULL, 0x00005410cf8a7816ULL, 0x000fe4000000008aULL,
0x00005410d3907816ULL, 0x000fe40000000090ULL, 0x00005800a5a77a10ULL, 0x000fe40007ffe0ffULL,
0x00005800abad7a10ULL, 0x000fe40007ffe0ffULL, 0xff8000003c3c7808ULL, 0x000fc40000000000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff80000022227808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40000800000ULL, 0xff8000000f0f7808ULL, 0x000fe40002000000ULL,
0xff80000023237808ULL, 0x000fe40002800000ULL, 0x000000507fff7212ULL, 0x000fc400078cc0ffULL,
0x0000006695ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006c95ff7212ULL, 0x000fe4000784c0ffULL,
0x000000749dff7212ULL, 0x040fe4000786c0ffULL, 0x0000008a9dff7212ULL, 0x040fe4000782c0ffULL,
0x000000909dff7212ULL, 0x000fe4000788c0ffULL, 0x0000008aa3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a77c7824ULL, 0x100fe200078e0a72ULL, 0x0000004e7d00720cULL, 0x080fe200037c1470ULL,
0x00000001ad727824ULL, 0x000fe200078e0a72ULL, 0x0000004e9300720cULL, 0x000fc40000701470ULL,
0x0000004e9300720cULL, 0x080fe40001741470ULL, 0x0000004e7700720cULL, 0x0c0fe40001f61470ULL,
0x0000004e7700720cULL, 0x0c0fe40000f21470ULL, 0x0000004e7700720cULL, 0x080fe40002781470ULL,
0x0000004ea100720cULL, 0x080fe40002fa1470ULL, 0x0000004e8700720cULL, 0x000fc400037c1070ULL,
0x0000004e9100720cULL, 0x0c0fe40000701070ULL, 0x0000004e9100720cULL, 0x080fe40001741070ULL,
0x0000004e7500720cULL, 0x0c0fe40001f61070ULL, 0x0000004e7500720cULL, 0x0c0fe40000f21070ULL,
0x0000004e7500720cULL, 0x080fe40002781070ULL, 0x0000004e9f00720cULL, 0x000fc40002fa1070ULL,
0x0000007cc9a97219ULL, 0x040fe400000006ffULL, 0x00000072c9af7219ULL, 0x000fe400000006ffULL,
0xff80000047477808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40000000000ULL,
0xff80000011117808ULL, 0x000fe40001000000ULL, 0xff8000004a4a7808ULL, 0x000fc40001800000ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0xff80000010107808ULL, 0x000fe40002000000ULL,
0xff80000031317808ULL, 0x000fe40002800000ULL, 0x000000589bff7212ULL, 0x000fe400078cc0ffULL,
0x00000074a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000074a9ff7212ULL, 0x000fc4000784c0ffULL,
0x00000076a3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000090a3ff7212ULL, 0x000fe4000782c0ffULL,
0x00000076a9ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008aafff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b3827824ULL, 0x000fe200078e0a7eULL, 0x0000004e9900720cULL, 0x080fe400037c1470ULL,
0x0000004ea100720cULL, 0x000fc40000701470ULL, 0x0000004ea100720cULL, 0x0c0fe40001f61470ULL,
0x0000004ea100720cULL, 0x080fe40000f21470ULL, 0x0000004ea700720cULL, 0x0c0fe40001741470ULL,
0x0000004ea700720cULL, 0x080fe40002781470ULL, 0x0000004ead00720cULL, 0x000fe40002fa1470ULL,
0x000000314fb97812ULL, 0x000fc400078efcffULL, 0x000000384fbf7812ULL, 0x040fe400078efcffULL,
0x000000394fc57812ULL, 0x000fe400078efcffULL, 0x0000004e9700720cULL, 0x080fe400037c1070ULL,
0x0000004e9f00720cULL, 0x0c0fe40000701070ULL, 0x0000004e9f00720cULL, 0x0c0fe40001f61070ULL,
0x0000004e9f00720cULL, 0x000fc40000f21070ULL, 0x0000004ea500720cULL, 0x0c0fe40001741070ULL,
0x0000004ea500720cULL, 0x080fe40002781070ULL, 0x0000004eab00720cULL, 0x000fe40002fa1070ULL,
0x00000082c9b77219ULL, 0x000fe400000006ffULL, 0x00005410b5807816ULL, 0x000fe40000000080ULL,
0x00005410d18c7816ULL, 0x000fc4000000008cULL, 0x00005800b9bb7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL, 0x00005800c5c77a10ULL, 0x000fe40007ffe0ffULL,
0xff80000049497808ULL, 0x000fe40003000000ULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff8000003b3b7808ULL, 0x000fc40001800000ULL, 0xff8000000e0e7808ULL, 0x000fe40000800000ULL,
0xff80000043437808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x00000074afff7212ULL, 0x040fe400078cc0ffULL,
0x00000076afff7212ULL, 0x000fc4000780c0ffULL, 0x0000008aa9ff7212ULL, 0x040fe4000786c0ffULL,
0x00000090a9ff7212ULL, 0x080fe4000782c0ffULL, 0x00000090afff7212ULL, 0x000fe4000784c0ffULL,
0x00000080b7ff7212ULL, 0x040fe4000788c0ffULL, 0x0000008cb7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bb847824ULL, 0x100fe200078e0a7eULL, 0x0000004ea700720cULL, 0x080fe20001f61470ULL,
0x00000001c1867824ULL, 0x100fe200078e0a7eULL, 0x0000004ea700720cULL, 0x080fe20000f21470ULL,
0x00000001c77e7824ULL, 0x000fe200078e0a7eULL, 0x0000004ead00720cULL, 0x000fc400037c1470ULL,
0x0000004ead00720cULL, 0x0c0fe40000701470ULL, 0x0000004ead00720cULL, 0x080fe40001741470ULL,
0x0000004eb300720cULL, 0x0c0fe40002781470ULL, 0x0000004eb300720cULL, 0x000fe40002fa1470ULL,
0x00000084c9bd7219ULL, 0x040fe400000006ffULL, 0x00000086c9c37219ULL, 0x000fc400000006ffULL,
0x0000004ea500720cULL, 0x0c0fe40001f61070ULL, 0x0000004ea500720cULL, 0x080fe40000f21070ULL,
0x0000004eab00720cULL, 0x0c0fe400037c1070ULL, 0x0000004eab00720cULL, 0x0c0fe40000701070ULL,
0x0000004eab00720cULL, 0x080fe40001741070ULL, 0x0000004eb100720cULL, 0x000fc40002781070ULL,
0x0000004eb100720cULL, 0x000fe40002fa1070ULL, 0x0000007ec9c97219ULL, 0x000fe400000006ffULL,
0x00005410cd887816ULL, 0x000fe40000000088ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff80000008087808ULL, 0x000fe40000800000ULL, 0xff80000042427808ULL, 0x000fc40003000000ULL,
0xff80000034347808ULL, 0x000fe40000000000ULL, 0xff80000009097808ULL, 0x000fe40001000000ULL,
0xff80000041417808ULL, 0x000fe40002000000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0x00000080bdff7212ULL, 0x080fe4000786c0ffULL, 0x00000080c3ff7212ULL, 0x000fc4000782c0ffULL,
0x00000080c9ff7212ULL, 0x000fe400078cc0ffULL, 0x00000088b7ff7212ULL, 0x080fe4000780c0ffULL,
0x00000088bdff7212ULL, 0x080fe4000784c0ffULL, 0x00000088c3ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008cbdff7212ULL, 0x000fe400078ac0ffULL, 0x0000004eb300720cULL, 0x000fc40000701470ULL,
0x0000004ebb00720cULL, 0x0c0fe40001f61470ULL, 0x0000004ebb00720cULL, 0x0c0fe40001741470ULL,
0x0000004ebb00720cULL, 0x080fe40002fa1470ULL, 0x0000004ec100720cULL, 0x080fe40000f21470ULL,
0x0000004ec700720cULL, 0x080fe400037c1470ULL, 0x0000004ec100720cULL, 0x000fc40002781470ULL,
0x0000004eb100720cULL, 0x080fe40000701070ULL, 0x0000004eb900720cULL, 0x0c0fe40001f61070ULL,
0x0000004eb900720cULL, 0x0c0fe40001741070ULL, 0x0000004eb900720cULL, 0x080fe40002fa1070ULL,
0x0000004ebf00720cULL, 0x080fe40000f21070ULL, 0x0000004ec500720cULL, 0x000fc400037c1070ULL,
0x0000004ebf00720cULL, 0x000fe40002781070ULL, 0x00005410d58e7816ULL, 0x000fe4000000008eULL,
0xff80000026267808ULL, 0x000fe40000000000ULL, 0xff80000040407808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000035357808ULL, 0x000fc40002800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0xff8000003e3e7808ULL, 0x000fe40003000000ULL,
0xff80000039397808ULL, 0x000fe40002000000ULL, 0x00000088c9ff7212ULL, 0x000fe4000780c0ffULL,
0x0000008cc3ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008cc9ff7212ULL, 0x000fc4000784c0ffULL,
0x0000008eb7ff7212ULL, 0x080fe400078ac0ffULL, 0x0000008ebdff7212ULL, 0x080fe4000782c0ffULL,
0x0000008ec3ff7212ULL, 0x080fe400078cc0ffULL, 0x0000008ec9ff7212ULL, 0x000fe4000788c0ffULL,
0x0000004eb300720cULL, 0x080fe40002fa1470ULL, 0x0000004ebb00720cULL, 0x000fc40000f21470ULL,
0x0000004ec100720cULL, 0x0c0fe40001f61470ULL, 0x0000004ec100720cULL, 0x080fe400037c1470ULL,
0x0000004ec700720cULL, 0x0c0fe40000701470ULL, 0x0000004ec700720cULL, 0x0c0fe40001741470ULL,
0x0000004ec700720cULL, 0x080fe40002781470ULL, 0x0000004eb100720cULL, 0x000fc40002fa1070ULL,
0x0000004eb900720cULL, 0x080fe40000f21070ULL, 0x0000004ec500720cULL, 0x080fe40000701070ULL,
0x0000004ebf00720cULL, 0x0c0fe40001f61070ULL, 0x0000004ebf00720cULL, 0x080fe400037c1070ULL,
0x0000004ec500720cULL, 0x0c0fe40001741070ULL, 0x0000004ec500720cULL, 0x000fc40002781070ULL,
0xff80000038387808ULL, 0x000fe40000000000ULL, 0xff80000036367808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff8000000a0a7808ULL, 0x000fe40002800000ULL,
0xff8000000b0b7808ULL, 0x000fe40000800000ULL, 0xff8000000c0c7808ULL, 0x000fc40003000000ULL,
0xff8000000d0d7808ULL, 0x000fc40002000000ULL, 0x0000004d0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff567424ULL, 0x000fe200078e00ffULL, 0x000000200500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff577424ULL, 0x000fe200078e00ffULL, 0x000000290600720bULL, 0x000fe40003f5e000ULL,
0x0000001e0700720bULL, 0x000fe40003f7e000ULL, 0x000000044d4f7208ULL, 0x000fe40004000000ULL,
0x0000000520047208ULL, 0x000fc40004800000ULL, 0x0000000629057208ULL, 0x000fe40005000000ULL,
0x000000071e077208ULL, 0x000fe40005800000ULL, 0x000000464f00720bULL, 0x000fe40003f1e000ULL,
0x0000003d0400720bULL, 0x000fe40003f3e000ULL, 0x000000280500720bULL, 0x000fe40003f5e000ULL,
0x0000001c0700720bULL, 0x000fc40003f7e000ULL, 0x0000004f46067208ULL, 0x000fe40004000000ULL,
0x000000043d047208ULL, 0x000fe40004800000ULL, 0x0000000528057208ULL, 0x000fe40005000000ULL,
0x000000071c4e7208ULL, 0x000fe40005800000ULL, 0x0000004b0600720bULL, 0x000fe40003f1e000ULL,
0x0000001d0400720bULL, 0x000fc40003f3e000ULL, 0x0000002a0500720bULL, 0x000fe40003f5e000ULL,
0x000000194e00720bULL, 0x000fe40003f7e000ULL, 0x000000064b067208ULL, 0x000fe40004000000ULL,
0x000000041d047208ULL, 0x000fe40004800000ULL, 0x000000052a507208ULL, 0x000fe40005000000ULL,
0x0000004e19057208ULL, 0x000fc40005800000ULL, 0x000000470600720bULL, 0x000fe40003f1e000ULL,
0x000000210400720bULL, 0x000fe40003f3e000ULL, 0x0000002b5000720bULL, 0x000fe40003f5e000ULL,
0x000000180500720bULL, 0x000fe40003f7e000ULL, 0x0000000647077208ULL, 0x000fe40004000000ULL,
0x0000000421047208ULL, 0x000fc40004800000ULL, 0x000000502b4f7208ULL, 0x000fe40005000000ULL,
0x0000000518067208ULL, 0x000fe40005800000ULL, 0x0000004c0700720bULL, 0x000fe40003f1e000ULL,
0x0000001f0400720bULL, 0x000fe40003f3e000ULL, 0x0000002c4f00720bULL, 0x000fe40003f5e000ULL,
0x000000130600720bULL, 0x000fc40003f7e000ULL, 0x000000074c077208ULL, 0x000fe40004000000ULL,
0x000000041f057208ULL, 0x000fe40004800000ULL, 0x0000004f2c047208ULL, 0x000fe40005000000ULL,
0x00000006134f7208ULL, 0x000fe40005800000ULL, 0x000000480700720bULL, 0x000fe40003f1e000ULL,
0x0000003c0500720bULL, 0x000fc40003f3e000ULL, 0x0000002d0400720bULL, 0x000fe40003f5e000ULL,
0x000000124f00720bULL, 0x000fe40003f7e000ULL, 0x0000000748067208ULL, 0x000fe40004000000ULL,
0x000000053c057208ULL, 0x000fe40004800000ULL, 0x000000042d077208ULL, 0x000fe40005000000ULL,
0x0000004f12047208ULL, 0x000fc40005800000ULL, 0x000000450600720bULL, 0x000fe40003f1e000ULL,
0x000000220500720bULL, 0x000fe40003f3e000ULL, 0x0000002e0700720bULL, 0x000fe40003f5e000ULL,
0x000000110400720bULL, 0x000fe40003f7e000ULL, 0x0000000645067208ULL, 0x000fe40004000000ULL,
0x0000000522057208ULL, 0x000fc40004800000ULL, 0x000000072e4e7208ULL, 0x000fe40005000000ULL,
0x0000000411047208ULL, 0x000fe40005800000ULL, 0x000000490600720bULL, 0x000fe40003f1e000ULL,
0x000000240500720bULL, 0x000fe40003f3e000ULL, 0x0000002f4e00720bULL, 0x000fe40003f5e000ULL,
0x0000000f0400720bULL, 0x000fc40003f7e000ULL, 0x0000000649077208ULL, 0x000fe40004000000ULL,
0x0000000524067208ULL, 0x000fe40004800000ULL, 0x0000004e2f057208ULL, 0x000fe40005000000ULL,
0x000000040f4f7208ULL, 0x000fe40005800000ULL, 0x0000004a0700720bULL, 0x000fe40003f1e000ULL,
0x000000230600720bULL, 0x000fc40003f3e000ULL, 0x000000300500720bULL, 0x000fe40003f5e000ULL,
0x000000104f00720bULL, 0x000fe40003f7e000ULL, 0x000000074a077208ULL, 0x000fe40004000000ULL,
0x0000000623067208ULL, 0x000fe40004800000ULL, 0x0000000530047208ULL, 0x000fe40005000000ULL,
0x0000004f104f7208ULL, 0x000fc40005800000ULL, 0x000000440700720bULL, 0x000fe40003f1e000ULL,
0x0000003b0600720bULL, 0x000fe40003f3e000ULL, 0x000000310400720bULL, 0x000fe40003f5e000ULL,
0x0000000e4f00720bULL, 0x000fe40003f7e000ULL, 0x00000007444e7208ULL, 0x000fe40004000000ULL,
0x000000063b067208ULL, 0x000fc40004800000ULL, 0x0000000431057208ULL, 0x000fe40005000000ULL,
0x0000004f0e4f7208ULL, 0x000fe40005800000ULL, 0x000000434e00720bULL, 0x000fe40003f1e000ULL,
0x000000250600720bULL, 0x000fe40003f3e000ULL, 0x000000320500720bULL, 0x000fe40003f5e000ULL,
0x000000084f00720bULL, 0x000fc40003f7e000ULL, 0x0000004e43077208ULL, 0x000fe40004000000ULL,
0x0000000625517208ULL, 0x000fe40004800000ULL, 0x0000000532047208ULL, 0x000fe40005000000ULL,
0x0000004f08067208ULL, 0x000fe40005800000ULL, 0x000000420700720bULL, 0x000fe40003f1e000ULL,
0x000000345100720bULL, 0x000fc40003f3e000ULL, 0x000000330400720bULL, 0x000fe40003f5e000ULL,
0x000000090600720bULL, 0x000fe40003f7e000ULL, 0x00000007424e7208ULL, 0x000fe40004000000ULL,
0x0000005134517208ULL, 0x000fe40004800000ULL, 0x0000000433057208ULL, 0x000fe40005000000ULL,
0x0000000609077208ULL, 0x000fc40005800000ULL, 0x000000414e00720bULL, 0x000fe40003f1e000ULL,
0x000000265100720bULL, 0x000fe40003f3e000ULL, 0x0000003a0500720bULL, 0x000fe40003f5e000ULL,
0x0000000a0700720bULL, 0x000fe40003f7e000ULL, 0x0000004e414f7208ULL, 0x000fe40004000000ULL,
0x0000005126047208ULL, 0x000fc40004800000ULL, 0x000000053a067208ULL, 0x000fe40005000000ULL,
0x000000070a4e7208ULL, 0x000fe40005800000ULL, 0x000000270400720bULL, 0x000fe40003f3e000ULL,
0x000000404f00720bULL, 0x000fe40003f1e000ULL, 0x000000350600720bULL, 0x000fe40003f5e000ULL,
0x0000000b4e00720bULL, 0x000fc40003f7e000ULL, 0x0000000427047208ULL, 0x000fe40004800000ULL,
0x0000004f40507208ULL, 0x000fe40004000000ULL, 0x0000000635057208ULL, 0x000fe40005000000ULL,
0x0000004e0b077208ULL, 0x000fe40005800000ULL, 0x000000390400720bULL, 0x000fe40003f3e000ULL,
0x0000003f5000720bULL, 0x000fc40003f1e000ULL, 0x000000360500720bULL, 0x000fe40003f5e000ULL,
0x0000000c0700720bULL, 0x000fe40003f7e000ULL, 0x0000000439517208ULL, 0x000fe40004800000ULL,
0x000000503f4f7208ULL, 0x000fe40004000000ULL, 0x0000000536047208ULL, 0x000fe40005000000ULL,
0x000000070c067208ULL, 0x000fc40005800000ULL, 0x0000003e4f00720bULL, 0x000fe40003f1e000ULL,
0x000000385100720bULL, 0x000fe40003f3e000ULL, 0x000000370400720bULL, 0x000fe40003f5e000ULL,
0x0000000d0600720bULL, 0x000fe40003f7e000ULL, 0x0000004f3e077208ULL, 0x000fe40004000000ULL,
0x0000005138507208ULL, 0x000fc40004800000ULL, 0x0000000437547208ULL, 0x000fe40005000000ULL,
0x000000060d537208ULL, 0x000fe20005800000ULL, 0x00001ed27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704557208ULL, 0x000fe20004000000ULL, 0x00001ee27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0050047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0054057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0053067f89ULL, 0x000e6200000e0000ULL, 0x000000045000720bULL, 0x008fc40003f1e000ULL,
0x000000055400720bULL, 0x010fe40003f3e000ULL, 0x0000005004077208ULL, 0x006fe40004000000ULL,
0x00000054054e7208ULL, 0x000fe20004800000ULL, 0x0c201f0055047f89ULL, 0x000e6200000e0000ULL,
0x000000065300720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007527f89ULL, 0x000ea200000e0000ULL,
0x0000005306507208ULL, 0x000fc60004000000ULL, 0x0c201f004e4f7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0050517f89ULL, 0x0002e400000e0000ULL, 0x000000045500720bULL, 0x002fe40003f1e000ULL,
0x000000520700720bULL, 0x004fe40003f3e000ULL, 0x0000005504047208ULL, 0x000fc40004000000ULL,
0x0000004f4e00720bULL, 0x008fe40003f5e000ULL, 0x0000000752057208ULL, 0x000fe40004800000ULL,
0x0000004e4f067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x000000515000720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c02027812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b45527823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4a457823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3e3e7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL,
0x00000048004f7308ULL, 0x0003e60000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b05487820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b37377823ULL, 0x000fe20000010807ULL,
0x0000005051077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010848ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010848ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010848ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010848ULL, 0x3fb8aa3b07517820ULL, 0x000fe20000410000ULL,
0x00000047004e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010848ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010848ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010848ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010848ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010848ULL,
0x00000002ff507819ULL, 0x000fe20000011617ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010851ULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010848ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010848ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010848ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010848ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010848ULL,
0x0000004600467308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010848ULL,
0x3fb8aa3b38387823ULL, 0x000fe20000010848ULL, 0x00000008506d7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010851ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010851ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010851ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b08087823ULL, 0x000fe20000010851ULL, 0x0000000317ff7812ULL, 0x000fca000780c0ffULL,
0x0000002000477308ULL, 0x0003f00000000800ULL, 0x0000003d004a7308ULL, 0x000ea20000000800ULL,
0x0000000850207824ULL, 0x002fce00078e00ffULL, 0x0000001d00537308ULL, 0x0003f00000000800ULL,
0x0000002100547308ULL, 0x000fe20000000800ULL, 0x00000001501d7810ULL, 0x002fc80007ffe0ffULL,
0xfffffff820677812ULL, 0x000fe400078ee21dULL, 0x00000002501d7810ULL, 0x000fe20007ffe0ffULL,
0x00000024003d7308ULL, 0x000fe60000000800ULL, 0xfffffff820697812ULL, 0x000fe400078ee21dULL,
0x000000474a1d723eULL, 0x004fe200000010ffULL, 0x00000008504a7824ULL, 0x040fe200078e00ffULL,
0x0000000550477810ULL, 0x000fe20007ffe0ffULL, 0x0000002300577308ULL, 0x0003f00000000800ULL,
0x0000002500597308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b18237823ULL, 0x002fe20000010851ULL,
0x00000004ff187e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x3f8000001818783eULL, 0x000fe200000010ffULL, 0x00000026005a7308ULL, 0x000ff00000000800ULL,
0x00000027005b7308ULL, 0x000ff00000000800ULL, 0x0000002900247308ULL, 0x000ff00000000800ULL,
0x0000002800257308ULL, 0x000e700000000800ULL, 0x0000002a00267308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000ea20000000800ULL, 0x000000242524723eULL, 0x002fce00000010ffULL,
0x0000001e00277308ULL, 0x0003f00000000800ULL, 0x0000001c00287308ULL, 0x0007220000000800ULL,
0x00000004501e7810ULL, 0x002fe40007ffe0ffULL, 0x000000262b26723eULL, 0x004fc400000010ffULL,
0xfffffff86d6d7812ULL, 0x000fe400078ee21eULL, 0x0000004b4e1e723eULL, 0x000fe200000010ffULL,
0x0000003b00587308ULL, 0x000fe20000000800ULL, 0x0000004d461c723eULL, 0x008fe400000010ffULL,
0xfffffff84a4b7812ULL, 0x000fe200078ee247ULL, 0x3fb8aa3b0b477823ULL, 0x000fe20000010851ULL,
0x000000ffff0b7224ULL, 0x000fc600078e0018ULL, 0x0000002200567308ULL, 0x0002a20000000800ULL,
0x000000272825723eULL, 0x010fce00000010ffULL, 0x0000002c003b7308ULL, 0x000fe20000000800ULL,
0x0000000850227824ULL, 0x002fce00078e00ffULL, 0x0000002d00487308ULL, 0x000e700000000800ULL,
0x0000001f00557308ULL, 0x0007f00000000800ULL, 0x00000019002c7308ULL, 0x0009e20000000800ULL,
0x00000003501f7810ULL, 0x008fc80007ffe0ffULL, 0xfffffff8226b7812ULL, 0x000fe400078ee21fULL,
0x00000053541f723eULL, 0x000fe200000010ffULL, 0x00000023002d7308ULL, 0x0004e20000000800ULL,
0x000000ffff197224ULL, 0x110fe400078e0018ULL, 0x000000ffff537224ULL, 0x000fca00078e0018ULL,
0x0000003c003c7308ULL, 0x000f220000000800ULL, 0x000000181c28723cULL, 0x000f6200000418ffULL,
0x000000563d23723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b103d7823ULL, 0x100fe20000010851ULL,
0x0000003b4810723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b0a3b7823ULL, 0x100fe20000010851ULL,
0x000000ffff0a7224ULL, 0x100fe200078e0018ULL, 0x3fb8aa3b0c487823ULL, 0x000fe20000010851ULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x0000002c2d27723eULL, 0x008fe200000010ffULL,
0x000000ffff2c7224ULL, 0x000fc400078e0018ULL, 0x000000ffff2d7224ULL, 0x000fc800078e0018ULL,
0x0000004900497308ULL, 0x000e620000000800ULL, 0x000000553c21723eULL, 0x010fe400000010ffULL,
0x0000001050557810ULL, 0x000fca0007ffe0ffULL, 0x0000004c004c7308ULL, 0x000ea20000000800ULL,
0x00000008554a7824ULL, 0x000fca00078e00ffULL, 0xfffffff84a557812ULL, 0x000fe400078ee255ULL,
0x0000002e00657308ULL, 0x000fe20000000800ULL, 0x000000524922723eULL, 0x002fe200000010ffULL,
0x000000ffff527224ULL, 0x000fe200078e0018ULL, 0x0000000650497810ULL, 0x000fca0007ffe0ffULL,
0x0000002f00667308ULL, 0x0002e20000000800ULL, 0x0000004c4f20723eULL, 0x004fe200000010ffULL,
0x00000008504f7824ULL, 0x040fe400078e00ffULL, 0x00000008504c7824ULL, 0x000fc800078e00ffULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x0000002c242c723cULL, 0x002f6200000418ffULL,
0xfffffff84c4d7812ULL, 0x000fe200078ee249ULL, 0x0000000850497824ULL, 0x000fca00078e00ffULL,
0x00000012003c7308ULL, 0x0002a20000000800ULL, 0x000000522028723cULL, 0x020b620000041828ULL,
0xfffffff849497812ULL, 0x000fcc00078ee250ULL, 0x0000001100197308ULL, 0x0005e20000000800ULL,
0xffffffff50127810ULL, 0x042fe40007ffe0ffULL, 0x0000000850537810ULL, 0x020fe40007ffe0ffULL,
0xfffffff84f4f7812ULL, 0x000fe400078ee212ULL, 0x000000656612723eULL, 0x008fe200000010ffULL,
0x0000000f00467308ULL, 0x000e620000000800ULL, 0x000000133c11723eULL, 0x004fe400000010ffULL,
0x0000001850507810ULL, 0x000fca0007ffe0ffULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x000000194613723eULL, 0x002fe200000010ffULL, 0x0000000853467824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b09197823ULL, 0x000fca0000010851ULL, 0x0000004200427308ULL, 0x000e620000000800ULL,
0x3fb8aa3b0d517823ULL, 0x000fe20000010851ULL, 0x00000008500d7824ULL, 0x000fe200078e00ffULL,
0xfffffff846537812ULL, 0x000fe200078ee253ULL, 0x0000000a102c723cULL, 0x000b62000004182cULL,
0x000000575809723eULL, 0x000fc600000010ffULL, 0x0000004500457308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x00000043420a723eULL, 0x022fe200000010ffULL,
0x000000ffff427224ULL, 0x000fc400078e0018ULL, 0x000000ffff437224ULL, 0x000fc800078e0018ULL,
0x0000003400347308ULL, 0x000e700000000800ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x00000059340b723eULL, 0x002fce00000010ffULL,
0x0000003200327308ULL, 0x000ff00000000800ULL, 0x0000003300337308ULL, 0x000e620000000800ULL,
0x00000030310c723eULL, 0x004fce00000010ffULL, 0x0000003d003d7308ULL, 0x000ff00000000800ULL,
0x0000000e003c7308ULL, 0x0002b00000000800ULL, 0x00000008000f7308ULL, 0x0007e20000000800ULL,
0x00000032330e723eULL, 0x002fce00000010ffULL, 0x0000001900467308ULL, 0x0003220000000800ULL,
0x000000454408723eULL, 0x008fce00000010ffULL, 0x0000003f003f7308ULL, 0x000fe20000000800ULL,
0xfffffff80d197812ULL, 0x002fe200078ee250ULL, 0x000000420830723cULL, 0x000b620000041828ULL,
0x0000003d3c0d723eULL, 0x004fe400000010ffULL, 0x0000a0001a3c7811ULL, 0x000fe400078e60ffULL,
0x0000000f460f723eULL, 0x010fe200000010ffULL, 0x0000003e003e7308ULL, 0x000e640000000800ULL,
0x0000001049497824ULL, 0x100fe200078e023cULL, 0x0000005a5b29723eULL, 0x020fe200000010ffULL,
0x0000001067677824ULL, 0x000fc400078e023cULL, 0x0000001069697824ULL, 0x100fe200078e023cULL,
0x000000420c2c723cULL, 0x000fe2000004182cULL, 0x000000106b6b7824ULL, 0x100fe200078e023cULL,
0x0000003900397308ULL, 0x000fe20000000800ULL, 0x000000106d6d7824ULL, 0x000fe400078e023cULL,
0x0000000149497824ULL, 0x000fe400078e0202ULL, 0x000000104b4b7824ULL, 0x000fe400078e023cULL,
0x0000000102677824ULL, 0x000fe200078e0267ULL, 0x0000003800387308ULL, 0x000ea20000000800ULL,
0x0000003f3e2a723eULL, 0x002fe200000010ffULL, 0x000000ffff3e7224ULL, 0x100fe200078e0018ULL,
0x0000001c49007388ULL, 0x0003e20000000800ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0018ULL,
0x000000104d4d7824ULL, 0x100fe200078e023cULL, 0x0000001e67007388ULL, 0x0003e20000000800ULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x0000000102697824ULL, 0x040fe400078e0269ULL,
0x000000104f4f7824ULL, 0x100fe400078e023cULL, 0x00000001026b7824ULL, 0x000fe200078e026bULL,
0x0000002069007388ULL, 0x0003e20000000800ULL, 0x0000001053537824ULL, 0x000fe200078e023cULL,
0x0000004000407308ULL, 0x000ee20000000800ULL, 0x00000039382b723eULL, 0x004fe200000010ffULL,
0x00000001026d7824ULL, 0x040fe200078e026dULL, 0x000000226b007388ULL, 0x0003e20000000800ULL,
0x00000001024b7824ULL, 0x000fc400078e024bULL, 0x00000001024d7824ULL, 0x040fe200078e024dULL,
0x000000086d007388ULL, 0x0003e20000000800ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x00000001024f7824ULL, 0x000fe400078e024fULL, 0x0000000a4b007388ULL, 0x0003e20000000800ULL,
0x0000001055557824ULL, 0x100fe400078e023cULL, 0x0000001019197824ULL, 0x000fe400078e023cULL,
0x0000003500357308ULL, 0x000ea20000000800ULL, 0x000000414028723eULL, 0x008fe200000010ffULL,
0x0000000102557824ULL, 0x000fc800078e0255ULL, 0x000000284d007388ULL, 0x0003e40000000800ULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x0000003e2830723cULL, 0x000f620000041830ULL,
0x0000002a4f007388ULL, 0x0003ec0000000800ULL, 0x0000004700347308ULL, 0x000ee20000000800ULL,
0x0000003a3538723eULL, 0x004fe200000010ffULL, 0x000000ffff357224ULL, 0x000fcc00078e0018ULL,
0x0000003600367308ULL, 0x000ff00000000800ULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x0000003b3439723eULL, 0x008fe200000010ffULL, 0x000000ffff347224ULL, 0x000fc400078e0018ULL,
0x0000000102187824ULL, 0x040fe400078e0253ULL, 0x0000000102027824ULL, 0x000fe400078e0219ULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x0000001d18007388ULL, 0x0003e20000000800ULL,
0x000000ffff317224ULL, 0x020fc600078e0032ULL, 0x0004001f67007388ULL, 0x0003e60000000800ULL,
0x0000005100517308ULL, 0x000ee20000000800ULL, 0x00000036373a723eULL, 0x004fe200000010ffULL,
0x0004002169007388ULL, 0x0003e80000000800ULL, 0x000400236b007388ULL, 0x0003e80000000800ULL,
0x000400096d007388ULL, 0x0003e80000000800ULL, 0x0004000b4b007388ULL, 0x0003e20000000800ULL,
0x00000048513b723eULL, 0x008fc600000010ffULL, 0x000400294d007388ULL, 0x0003e80000000800ULL,
0x0004002b4f007388ULL, 0x0003e20000000800ULL, 0x00000034382c723cULL, 0x000f66000004182cULL,
0x0000002455007388ULL, 0x0003e80000000800ULL, 0x0008002667007388ULL, 0x0003e80000000800ULL,
0x0008001069007388ULL, 0x0003e80000000800ULL, 0x000800126b007388ULL, 0x0003e80000000800ULL,
0x0008000c6d007388ULL, 0x0003e80000000800ULL, 0x0008000e4b007388ULL, 0x0003e20000000800ULL,
0x000000ffff327224ULL, 0x020fc400078e002cULL, 0x000000ffff337224ULL, 0x000fe200078e002eULL,
0x000800384d007388ULL, 0x0003e80000000800ULL, 0x0008003a4f007388ULL, 0x0003e80000000800ULL,
0x0000002502007388ULL, 0x0003e80000000800ULL, 0x000c002767007388ULL, 0x0003e80000000800ULL,
0x000c001169007388ULL, 0x0003e80000000800ULL, 0x000c00136b007388ULL, 0x0003e80000000800ULL,
0x000c000d6d007388ULL, 0x0003e80000000800ULL, 0x000c000f4b007388ULL, 0x0003e80000000800ULL,
0x000c00394d007388ULL, 0x0003e80000000800ULL, 0x000c003b4f007388ULL, 0x0003e80000000800ULL,
0x0120000403008388ULL, 0x0003e80000000c00ULL, 0x0122003003008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005eff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008005eff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010005eff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000160607810ULL, 0x000fe20007ffe0ffULL,
0x000018005eff7f8cULL, 0x0003e6000c80043fULL, 0x000000156000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff88d000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff257807ULL, 0x002fe40004000000ULL,
0x0001aba000267802ULL, 0x000fc40000000f00ULL, 0x00000e8000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0xfffe7b2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x0001abf000267802ULL, 0x000fc40000000f00ULL,
0x00000e3000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0025ULL,
0xfffe7b8000007947ULL, 0x000fea000383ffffULL, 0x0001ac3000257802ULL, 0x000fc40000000f00ULL,
0x00000da000007944ULL, 0x004fea0003c00000ULL, 0xfffe7c6000007947ULL, 0x000fea000383ffffULL,
0x0001ac6000257802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x006fea0003c00000ULL,
0xfffe7da000007947ULL, 0x000fea000383ffffULL, 0x0001ac9000257802ULL, 0x000fc40000000f00ULL,
0x00000d4000007944ULL, 0x00efea0003c00000ULL, 0xfffe7ee000007947ULL, 0x000fea000383ffffULL,
0x0001acc000257802ULL, 0x000fc40000000f00ULL, 0x00000d1000007944ULL, 0x00efea0003c00000ULL,
0xfffe801000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x0001ad0000257802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffe844000007947ULL, 0x000fea000383ffffULL,
0x0001ad4000257802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x0000001002267810ULL, 0x000fe40007ffe0ffULL,
0x0001ad8000257802ULL, 0x000fc40000000f00ULL, 0x00000c5000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffe841000007947ULL, 0x000fea000383ffffULL,
0x0001adc000257802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffe840000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x0001ae1000267802ULL, 0x000fc40000000f00ULL,
0x00000c1000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xfffeb3f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001ae6000267802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffeb44000007947ULL, 0x000fea000383ffffULL,
0x0001aea000257802ULL, 0x000fc40000000f00ULL, 0x00000b3000007944ULL, 0x004fea0003c00000ULL,
0xfffeb52000007947ULL, 0x000fea000383ffffULL, 0x0001aed000257802ULL, 0x000fc40000000f00ULL,
0x00000b0000007944ULL, 0x006fea0003c00000ULL, 0xfffeb66000007947ULL, 0x000fea000383ffffULL,
0x0001af0000257802ULL, 0x000fc40000000f00ULL, 0x00000ad000007944ULL, 0x00efea0003c00000ULL,
0xfffeb7a000007947ULL, 0x000fea000383ffffULL, 0x0001af3000257802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x00efea0003c00000ULL, 0xfffeb8d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001eULL, 0x0001af7000257802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffebcd000007947ULL, 0x000fea000383ffffULL, 0x0001afb000257802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x000000101e267810ULL, 0x000fc40007ffe0ffULL, 0x0001aff000257802ULL, 0x000fc40000000f00ULL,
0x000009e000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffebca000007947ULL, 0x000fea000383ffffULL, 0x0001b03000257802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffebc9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x0001b08000267802ULL, 0x000fc40000000f00ULL, 0x000009a000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffeeba000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x0001b0d000267802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0025ULL,
0xfffeebf000007947ULL, 0x000fea000383ffffULL, 0x0001b11000257802ULL, 0x000fc40000000f00ULL,
0x000008c000007944ULL, 0x002fea0003c00000ULL, 0xfffeecd000007947ULL, 0x000fea000383ffffULL,
0x0001b14000257802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x002fea0003c00000ULL,
0xfffeee1000007947ULL, 0x000fea000383ffffULL, 0x0001b17000257802ULL, 0x000fc40000000f00ULL,
0x0000086000007944ULL, 0x002fea0003c00000ULL, 0xfffeef5000007947ULL, 0x000fea000383ffffULL,
0x0001b1a000257802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x002fea0003c00000ULL,
0xfffef08000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0001b1e000257802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffef49000007947ULL, 0x000fea000383ffffULL,
0x0001b22000257802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000106c267810ULL, 0x000fc40007ffe0ffULL,
0x0001b26000257802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffef46000007947ULL, 0x000fea000383ffffULL,
0x0001b2a000257802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffef45000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x004fe40004000000ULL, 0x0001b2f000267802ULL, 0x000fc40000000f00ULL,
0x0000073000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0025ULL,
0xffff228000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001b34000267802ULL, 0x000fc40000000f00ULL, 0x000006e000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff6f7224ULL, 0x000fe200078e0025ULL, 0xffff22d000007947ULL, 0x000fea000383ffffULL,
0x0001b38000257802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x008fea0003c00000ULL,
0xffff23b000007947ULL, 0x000fea000383ffffULL, 0x0001b3b000257802ULL, 0x000fc40000000f00ULL,
0x0000062000007944ULL, 0x00afea0003c00000ULL, 0xffff24f000007947ULL, 0x000fea000383ffffULL,
0x0001b3e000257802ULL, 0x000fc40000000f00ULL, 0x000005f000007944ULL, 0x00afea0003c00000ULL,
0xffff263000007947ULL, 0x000fea000383ffffULL, 0x0001b41000257802ULL, 0x000fc40000000f00ULL,
0x000005c000007944ULL, 0x00afea0003c00000ULL, 0xffff276000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0008ULL, 0x0001b45000257802ULL, 0x000fc40000000f00ULL,
0x0000058000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xffff2b7000007947ULL, 0x000fea000383ffffULL, 0x0001b49000257802ULL, 0x000fc40000000f00ULL,
0x0000054000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001008267810ULL, 0x000fc40007ffe0ffULL, 0x0001b4d000257802ULL, 0x000fc40000000f00ULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xffff2b4000007947ULL, 0x000fea000383ffffULL, 0x0001b51000257802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xffff2b3000007947ULL, 0x000fea000383ffffULL, 0x00000002ff527424ULL, 0x000fe200078e00ffULL,
0x0001b560004e7802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0051ULL, 0xffffe0f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e0050ULL, 0x0001b5c0004e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff527424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000515000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x0001b620004e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff527424ULL, 0x000fe200078e00ffULL,
0x0000005051067208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000515400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0053ULL,
0x0001b680004e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff527424ULL, 0x000fe200078e00ffULL,
0x0000005451547208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000515300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0055ULL,
0x0001b6e0004e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff527424ULL, 0x000fe200078e00ffULL,
0x0000005351507208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000515500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001b740004e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff527424ULL, 0x000fe200078e00ffULL,
0x0000005551047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000510600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x0001b7a0004e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff527424ULL, 0x000fe200078e00ffULL,
0x0000000651057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000515400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0050ULL,
0x0001b800004e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff527424ULL, 0x000fe200078e00ffULL,
0x0000005451067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffdfc000007947ULL, 0x000fea000383ffffULL, 0x0180000024007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002400008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000024027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002400007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe467002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff4f7424ULL, 0x000fe200078e00ffULL,
0x0000005700007348ULL, 0x000fe80003800000ULL, 0x0c00005207517389ULL, 0x0002a200000e0056ULL,
0xfffe46304e007950ULL, 0x000fea0003c3ffffULL, 0x000000ffff6a7224ULL, 0x000fe200078e0025ULL,
0x0000007600007348ULL, 0x000fe80003800000ULL, 0x00000000ff6b7424ULL, 0x000fe200078e00ffULL,
0x0000002627267389ULL, 0x0002a600000e0079ULL, 0xfffe45e06a007950ULL, 0x000fea0003c3ffffULL,
0x000000012500780cULL, 0x000fe20003f65070ULL, 0x00000000ff277424ULL, 0x000fe200078e00ffULL,
0x0000007500007348ULL, 0x000ff60003800000ULL, 0x0000000000257806ULL, 0x000fc800058e0100ULL,
0x0000007525257212ULL, 0x000fe200078ec0ffULL, 0xfffe458026007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x000000000000089cULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001678ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000167cULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001bb80ULL, 0xf200001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001d400ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001d440ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001d7c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001678ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001bd88ULL,
0x000000000001bd88ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001d400ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001d7c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_89_cubin_len = 120992;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
