/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019350ULL, 0x0000000000018fd0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x0000000000017440ULL,
0x0000000000000180ULL, 0x000b0022000004c4ULL, 0x00000000000175c0ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000017600ULL, 0x0000000000000050ULL, 0x000b002200000519ULL,
0x0000000000017650ULL, 0x0000000000000130ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000017780ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001744000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x005bd00400288080ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080820828ULL, 0x2880809c08288080ULL,
0x809e082880809d08ULL, 0x08288080a4082880ULL, 0x8080a608288080a5ULL, 0xab08288080aa0828ULL,
0x288080ac08288080ULL, 0x80c608288080c508ULL, 0x1628808084082880ULL, 0x0000031028808280ULL,
0x8492000000000000ULL, 0x0000002200288080ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0001744000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8c08288080820828ULL, 0x2880809008288080ULL, 0x809c082880809108ULL, 0x082880809d082880ULL,
0x8080a4082880809eULL, 0xa608288080a50828ULL, 0x288080ab08288080ULL, 0x80ae08288080ac08ULL,
0x08288080c5082880ULL, 0x80808808288080c6ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808892ULL, 0x0000001cffffffffULL, 0x0000014000000000ULL, 0x000175c000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8c08288080820828ULL, 0x2880809008288080ULL, 0x809c082880809108ULL, 0x082880809d082880ULL,
0x8080a4082880809eULL, 0xa608288080a50828ULL, 0x288080aa08288080ULL, 0x80c508288080ab08ULL,
0x08288080c6082880ULL, 0x80828016288080acULL, 0x0000000000031028ULL, 0x288080ac92000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000020000000000ULL, 0x0001760000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x80a6288080ac0900ULL, 0x0000000000002880ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8c08288080820828ULL, 0x2880809008288080ULL,
0x809c082880809108ULL, 0x082880809d082880ULL, 0x8080a4082880809eULL, 0xa608288080a50828ULL,
0x288080ac08288080ULL, 0x80c608288080c508ULL, 0x16288080ab082880ULL, 0x0000031028808280ULL,
0xab92000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x000002d000000000ULL,
0x0001765000000000ULL, 0x0000013000000000ULL, 0x0000140400000000ULL, 0x80a6288080ab0900ULL,
0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x00082304000000e1ULL, 0x0000000000000016ULL,
0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL,
0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0048016000000017ULL,
0x000c170400481903ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL,
0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001342804ULL,
0x0000040000000110ULL, 0x00001f4000001ea0ULL, 0x000021c000002050ULL, 0x0000265000002620ULL,
0x00002730000026c0ULL, 0x000056e000005640ULL, 0x0000596000005800ULL, 0x00005e5000005e20ULL,
0x00005f3000005ec0ULL, 0x00008c0000008b60ULL, 0x00008e9000008d30ULL, 0x0000933000009300ULL,
0x00009410000093a0ULL, 0x0000c1200000c080ULL, 0x0000c3a00000c240ULL, 0x0000c8400000c810ULL,
0x0000c9200000c8b0ULL, 0x0000ea000000e9f0ULL, 0x00015910000158d0ULL, 0x0001593000015920ULL,
0x000159a000015980ULL, 0x000159d0000159c0ULL, 0x000166a000016640ULL, 0x0001678000016710ULL,
0x0001688000016800ULL, 0x00016940000168e0ULL, 0x00016a20000169b0ULL, 0x00016b1000016aa0ULL,
0x00016bd000016b70ULL, 0x00016cb000016c40ULL, 0x00016da000016d30ULL, 0x00016e6000016e00ULL,
0x00016f4000016ed0ULL, 0x0001703000016fc0ULL, 0x00017120000170a0ULL, 0x00017220000171a0ULL,
0x00017320000172a0ULL, 0x00017420000173a0ULL, 0x0000021004403904ULL, 0x00017600000000ffULL,
0x000002a0003f0100ULL, 0x000176080000000dULL, 0x000002d0003f0120ULL, 0x000176880000000dULL,
0x000003a0003f0120ULL, 0x000176a80000000dULL, 0x000003d0003f0120ULL, 0x000176c80000000dULL,
0x00000460003f0120ULL, 0x00017600000000ffULL, 0x00000560003f0107ULL, 0x0001768c00000033ULL,
0x000005f0003f0102ULL, 0x0001768800000033ULL, 0x00000d60003f0101ULL, 0x000176a800000038ULL,
0x00000e70003f0107ULL, 0x000176a800000038ULL, 0x00000ed0003f0101ULL, 0x0000002000000024ULL,
0x00001030003f0101ULL, 0x000000040000003eULL, 0x00001210003f0105ULL, 0x000000040000003eULL,
0x00001a30003f0105ULL, 0x000176a800000030ULL, 0x00001b20003f0107ULL, 0x000176a800000030ULL,
0x00001b80003f0101ULL, 0x0001760800000026ULL, 0x00001bd0003f0101ULL, 0x0001760c00000024ULL,
0x00001da0003f0105ULL, 0x0001760c00000024ULL, 0x00002380003f0105ULL, 0x000176ac0000002cULL,
0x00002550003f0105ULL, 0x000176ac0000002cULL, 0x00004700003f0105ULL, 0x000000000000003eULL,
0x00004780003f0101ULL, 0x0001768800000050ULL, 0x00004800003f0101ULL, 0x000000040000003eULL,
0x000049d0003f0105ULL, 0x000000040000003eULL, 0x00005220003f0105ULL, 0x000176a800000052ULL,
0x00005310003f0107ULL, 0x000176a800000052ULL, 0x00005370003f0101ULL, 0x0001762800000024ULL,
0x000053c0003f0101ULL, 0x0001762c0000002aULL, 0x00005590003f0105ULL, 0x0001762c0000002aULL,
0x00005b50003f0105ULL, 0x000176ac00000026ULL, 0x00005d40003f0105ULL, 0x000176ac0000002aULL,
0x00007d30003f0105ULL, 0x000000000000003eULL, 0x00007da0003f0101ULL, 0x0001769000000050ULL,
0x00007e00003f0101ULL, 0x000000040000003eULL, 0x00007fd0003f0105ULL, 0x000000040000003eULL,
0x00008720003f0105ULL, 0x0000000000000040ULL, 0x00008860003f0107ULL, 0x000176a800000026ULL,
0x000088c0003f0101ULL, 0x000176480000002aULL, 0x000088e0003f0101ULL, 0x0001764c0000002aULL,
0x00008ab0003f0105ULL, 0x0001764c0000002aULL, 0x00009060003f0105ULL, 0x000176ac00000052ULL,
0x00009230003f0105ULL, 0x000176ac00000052ULL, 0x0000b230003f0105ULL, 0x000000000000003eULL,
0x0000b2a0003f0101ULL, 0x0001769800000050ULL, 0x0000b340003f0101ULL, 0x000176cc00000028ULL,
0x0000b510003f0105ULL, 0x000176cc00000028ULL, 0x0000bc60003f0105ULL, 0x0000000000000053ULL,
0x0000bd80003f0107ULL, 0x000176a800000052ULL, 0x0000bde0003f0101ULL, 0x000176680000002aULL,
0x0000be00003f0101ULL, 0x0001766c0000002aULL, 0x0000bfd0003f0105ULL, 0x0001766c0000002aULL,
0x0000c570003f0105ULL, 0x000176ac00000055ULL, 0x0000c740003f0105ULL, 0x000176ac00000055ULL,
0x0000e690003f0105ULL, 0x000000000000003eULL, 0x0000e6f0003f0101ULL, 0x000176a000000050ULL,
0x0000f5e0003f0101ULL, 0x00017600000000ffULL, 0x00010c30003f0101ULL, 0x00017604000000ffULL,
0x00010e00003f0105ULL, 0x00017604000000ffULL, 0x00011030003f0105ULL, 0x00017600000000ffULL,
0x00011060003f0101ULL, 0x00017604000000ffULL, 0x00011220003f0105ULL, 0x00017604000000ffULL,
0x00014d00003f0105ULL, 0x0000000000000038ULL, 0x00014e20003f0101ULL, 0x0000000400000038ULL,
0x00014ff0003f0105ULL, 0x0000000400000038ULL, 0x00016480003f0105ULL, 0x000000000000003aULL,
0x000164e0003f0101ULL, 0x000000080000003aULL, 0x00016540003f0101ULL, 0x000000100000003aULL,
0x000165b0003f0101ULL, 0x000000180000003aULL, 0x00053803003f0101ULL, 0x0000f2c000141c04ULL,
0x000112800000f530ULL, 0x0001660000011330ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000374ULL, 0x0000001a00000002ULL, 0x00000000000002acULL, 0x0000001a00000002ULL,
0x00000000000001ecULL, 0x0000001a00000002ULL, 0x0000000000000114ULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x000000000000034eULL, 0x0000001a00000002ULL,
0x0000000000000283ULL, 0x0000001a00000002ULL, 0x00000000000001c8ULL, 0x0000001a00000002ULL,
0x00000000000000eeULL, 0x0000001a00000002ULL, 0x0000000000017700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001200047300ULL, 0x000ee200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000f280000002200ULL, 0x0000000000327919ULL, 0x000ee20000000000ULL,
0x0000001200127309ULL, 0x000ea60000000000ULL, 0x0000000000347919ULL, 0x000ee80000002600ULL,
0x0000000000367919ULL, 0x000ee20000002700ULL, 0x00000005ff007819ULL, 0x002fc6000001160dULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x00001fff030b7589ULL, 0x0045e200000e0000ULL,
0x0000010003027a24ULL, 0x010fc600078e0202ULL, 0x00001fff00007589ULL, 0x000f2200000e0000ULL,
0x00000000020d7a24ULL, 0x000fe200078e020dULL, 0x00000004ff0c7819ULL, 0x008fe20000011632ULL,
0x00000010320e7824ULL, 0x000fe400078e00ffULL, 0x0000000834067824ULL, 0x000fe200078e00ffULL,
0x000000ff0d00720cULL, 0x040fe40003f45270ULL, 0x0000007f0d00780cULL, 0x000fe20003f84070ULL,
0x0000003607087224ULL, 0x000fe200078e0206ULL, 0x0000000f0d00780cULL, 0x000fc40003f64070ULL,
0x000000030d00780cULL, 0x000fe40003f24070ULL, 0x000000050400720cULL, 0x002fe40003f02070ULL,
0x000000f00e117812ULL, 0x000fc600078ec0ffULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x004fe400078e00ffULL, 0x000000040b097824ULL, 0x010fe400078e0200ULL,
0xff317217ff10c424ULL, 0x000fe200078e00ffULL, 0x01760002ff00a388ULL, 0x0003e20000000a00ULL,
0x0000000209097824ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f44070ULL,
0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL, 0x017400100d00c388ULL, 0x0005e20000004800ULL,
0x7fffffc0ff05b424ULL, 0x000fe200078e00ffULL, 0x00000008090a7817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fc400078e00ffULL, 0x7fffff60ff079424ULL, 0x000fe200078e00ffULL,
0x017608040d00b388ULL, 0x0007e20000008a00ULL, 0x000000010a0a7824ULL, 0x000fe400078e0a09ULL,
0x0000000109097824ULL, 0x000fe200078e020cULL, 0x017688060d009388ULL, 0x0009e20000008a00ULL,
0x00000100ff037424ULL, 0x002fe200078e00ffULL, 0x0000000a0c00720cULL, 0x000fe20003f66070ULL,
0x0000000108027824ULL, 0x000fe400078e0209ULL, 0x00000001090f7824ULL, 0x000fc400078e0232ULL,
0x0000001009107824ULL, 0x004fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0003ULL,
0xfffffff0100f7812ULL, 0x000fe200078ee20fULL, 0x3fffff80ff049424ULL, 0x008fe200078e00ffULL,
0x0000001102027210ULL, 0x000fe20007f9e0ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x0176a8040d009388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fe400020e0603ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x0176c8080d00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff067224ULL, 0x010fc400078e0a12ULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0003e2000d901c46ULL, 0x0000600036047625ULL, 0x000fc600078e0007ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01760406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604027981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0b00720cULL, 0x000fc40003f05270ULL,
0x000000ff02067810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff037819ULL, 0x000fce0000011606ULL,
0x0000f01000008947ULL, 0x000fea0003800000ULL, 0x0000000800337824ULL, 0x000fe400078e00ffULL,
0x00000003ff047424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01768c0433ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000236367824ULL, 0x000fe200078e00ffULL,
0x0000580034057a10ULL, 0x000fe20007ffe0ffULL, 0x0176880033ff7f8cULL, 0x0005e2000c80043fULL,
0x00000001ff347819ULL, 0x000fe40000011600ULL, 0x0000000100377812ULL, 0x000fe200078ec0ffULL,
0x0000580036367a24ULL, 0x000fc400078e0205ULL, 0x0000002034357824ULL, 0x000fc800078e00ffULL,
0x0000620036047a24ULL, 0x002fe200078e0235ULL, 0x000003c000000947ULL, 0x000fea0003800000ULL,
0x0000003502067217ULL, 0x004fe20007800000ULL, 0x0000001037057824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x100fe20000011632ULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x000000700e157812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a35ULL,
0x00000004070a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105097824ULL, 0x000fe200078e0207ULL,
0x0000000c070c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000506067217ULL, 0x000fe20007800000ULL,
0x0000000109087824ULL, 0x000fc400078e0232ULL, 0x00000008090d7824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fe400078e0a05ULL, 0x00000001050b7824ULL, 0x000fe200078e020aULL,
0xfffffff80d087812ULL, 0x000fe200078ee208ULL, 0x00000001050f7824ULL, 0x000fe200078e020cULL,
0x000000060a00720cULL, 0x080fe20003f46070ULL, 0x000000080b107824ULL, 0x000fe200078e00ffULL,
0x00000008070a7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f127824ULL, 0x000fe200078e00ffULL,
0x000000060700720cULL, 0x080fe20003f66070ULL, 0x000000010b077824ULL, 0x000fe200078e0232ULL,
0x000000060c00720cULL, 0x080fe20003f06070ULL, 0x00000001050d7824ULL, 0x000fe200078e020aULL,
0x000000060a00720cULL, 0x000fe20003f26070ULL, 0x0000000104057824ULL, 0x000fe200078e0209ULL,
0xfffffff8100c7812ULL, 0x000fe200078ee207ULL, 0x0000000104067824ULL, 0x000fc400078e020bULL,
0x0000000104077824ULL, 0x040fe400078e020dULL, 0x0000000104107824ULL, 0x000fe400078e020fULL,
0x00005e0005047625ULL, 0x000fc800078e0011ULL, 0x000000010f0b7824ULL, 0x100fe200078e0232ULL,
0x00000015040a7210ULL, 0x000fe20007f9e0ffULL, 0x000000010d097824ULL, 0x040fe400078e0232ULL,
0x000000080d0e7824ULL, 0x000fe200078e00ffULL, 0x00013000340d7811ULL, 0x000fe400078e68ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x000000ffff0b7224ULL, 0x000fe200020e0605ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x00005e0006047625ULL, 0x000fc800078e0011ULL,
0x00000010080f7824ULL, 0x000fe200078e020dULL, 0x0000001504047210ULL, 0x000fe20007f9e0ffULL,
0x00005e0007067625ULL, 0x000fc600078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e2000d901c46ULL, 0x00005e0010087625ULL, 0x000fe200078e0011ULL,
0x0000001506067210ULL, 0x000fc60007fbe0ffULL, 0x000000100c117824ULL, 0x000fe200078e020dULL,
0x0000001508087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fe400020e0605ULL,
0x000000100e137824ULL, 0x000fe400078e020dULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000000004117faeULL, 0x0003e2000d101c46ULL, 0x00000010120d7824ULL, 0x000fe400078e020dULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000000006137faeULL, 0x0003e8000c901c46ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x0000001037057824ULL, 0x004fe200078e00ffULL, 0x000000700e137812ULL, 0x000fe200078ec0ffULL,
0x00000080ff117424ULL, 0x000fc600078e00ffULL, 0x0000000532057211ULL, 0x000fc800078fe8ffULL,
0x00000008050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x040fe200078e0232ULL,
0x0000000c050d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe400078e00ffULL,
0x000000080b157824ULL, 0x000fe400078e00ffULL, 0x00000001040f7824ULL, 0x040fe200078e020dULL,
0xfffffff8070c7812ULL, 0x000fe200078ee206ULL, 0x0000000104067824ULL, 0x000fe200078e0205ULL,
0x0000000405077810ULL, 0x000fe20007ffe0ffULL, 0x000000080d127824ULL, 0x000fc800078e00ffULL,
0x0000000104087824ULL, 0x040fe400078e0207ULL, 0x0000000107097824ULL, 0x040fe400078e0232ULL,
0x00000008070e7824ULL, 0x000fe400078e00ffULL, 0x0000000104077824ULL, 0x000fe400078e020bULL,
0x00005e0006047625ULL, 0x000fe200078e0011ULL, 0xfffffff80e0e7812ULL, 0x000fc600078ee209ULL,
0x000000010b067824ULL, 0x100fe200078e0232ULL, 0x00000013040a7210ULL, 0x000fe20007f1e0ffULL,
0x000000010d0b7824ULL, 0x000fc600078e0232ULL, 0xfffffff815107812ULL, 0x000fe200078ee206ULL,
0x00005e0007067625ULL, 0x000fe200078e0011ULL, 0xfffffff812127812ULL, 0x000fe400078ee20bULL,
0x0001300034157811ULL, 0x000fe200078e68ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000001306067210ULL, 0x000fe20007f3e0ffULL, 0x00005e0008047625ULL, 0x000fc800078e0011ULL,
0x00005e000f087625ULL, 0x000fe200078e0011ULL, 0x0000001304047210ULL, 0x000fc60007f1e0ffULL,
0x000000100c0d7824ULL, 0x100fe200078e0215ULL, 0x0000001308087210ULL, 0x000fe20007f5e0ffULL,
0x000000100e0f7824ULL, 0x000fe400078e0215ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c46ULL,
0x0000001010117824ULL, 0x000fe400078e0215ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x00000000040f7faeULL, 0x0003e2000b901c46ULL, 0x0000001012137824ULL, 0x000fc400078e0215ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000000006117faeULL, 0x0003e8000b901c46ULL,
0x0000000008137faeULL, 0x0003e4000b901c46ULL, 0x0000001034387824ULL, 0x040fe200078e00ffULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000176a834247811ULL, 0x000fe200078e18ffULL, 0x00000000380473c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000176a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80038567f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200024247f8cULL, 0x000ee2000c80043fULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000d7e000008947ULL, 0x000fea0003800000ULL,
0x000000ffff2a7224ULL, 0x008fe400078e0025ULL, 0xff317217ff597424ULL, 0x000fc400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fc400078e00ffULL, 0x000001003c277824ULL, 0x000fca00078e00ffULL,
0x000000022700720cULL, 0x000fda0003f06070ULL, 0x0000d72000000947ULL, 0x026fea0003800000ULL,
0x000000ffff3d7224ULL, 0x000fc400078e0025ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x000176c8343e7811ULL, 0x000fca00078e18ffULL, 0x000004003e297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fe4000780482aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028262b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011429ULL,
0x0000002b24247211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000224247819ULL, 0x000fc80000001229ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x000004003e297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000013c247810ULL, 0x040fe20007ffe0ffULL,
0x000001003c3f7824ULL, 0x000fe200078e0235ULL, 0x0000000125417812ULL, 0x000fe400078e0cffULL,
0x000000032400720cULL, 0x000fe40003f06070ULL, 0x000000403f277810ULL, 0x000fca0007ffe0ffULL,
0x00006200362e7a24ULL, 0x000fcc00078e0227ULL, 0x000003e000008947ULL, 0x000fea0003800000ULL,
0x00000003ff2a7819ULL, 0x000fe20000011632ULL, 0x00000010372b7824ULL, 0x000fe200078e00ffULL,
0x0000002702247217ULL, 0x000fe20007800000ULL, 0x00000080ff317424ULL, 0x000fe200078e00ffULL,
0x000000042a287810ULL, 0x040fe20007ffe0ffULL, 0x000000012b297824ULL, 0x000fe200078e022aULL,
0x0000000c2a3a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000124247824ULL, 0x000fe400078e0a27ULL,
0x0000000129267824ULL, 0x040fe400078e0232ULL, 0x00000008292d7824ULL, 0x000fe200078e00ffULL,
0x000000242b247217ULL, 0x000fe20007800000ULL, 0x0000001032277824ULL, 0x000fc400078e00ffULL,
0x00000002342c7824ULL, 0x000fe200078e0241ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee226ULL,
0x0000000129267824ULL, 0x000fe200078e022eULL, 0x00000070273b7812ULL, 0x000fe200078ec0ffULL,
0x0000000124247824ULL, 0x000fe200078e0a2bULL, 0x000130002c2c7811ULL, 0x000fe200078e60ffULL,
0x000000012b297824ULL, 0x000fe400078e0228ULL, 0x00005e0026267625ULL, 0x000fe200078e0031ULL,
0x000000242800720cULL, 0x080fe40003f06070ULL, 0x000000242a00720cULL, 0x000fe20003fa6070ULL,
0x00000001292f7824ULL, 0x040fe200078e0232ULL, 0x0000003b26287210ULL, 0x000fe20007fde0ffULL,
0x0000000829307824ULL, 0x000fc400078e00ffULL, 0x0000000129267824ULL, 0x000fe400078e022eULL,
0x000000ffff297224ULL, 0x000fe200030e0627ULL, 0xfffffff8302f7812ULL, 0x000fe200078ee22fULL,
0x00005e0026267625ULL, 0x000fe200078e0031ULL, 0x000000082a307810ULL, 0x000fc60007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e022cULL, 0x0000003b262a7210ULL, 0x000fe20007fde0ffULL,
0x000000012b437824ULL, 0x040fe400078e0230ULL, 0x000000012b477824ULL, 0x000fe200078e023aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0007e2000e901c46ULL,
0x0000000143267824ULL, 0x000fe200078e022eULL, 0x000000243000720cULL, 0x080fe20003fa6070ULL,
0x000000ffff2b7224ULL, 0x000fe200030e0627ULL, 0x000000243a00720cULL, 0x000fe20003fc6070ULL,
0x000000102f2f7824ULL, 0x000fc400078e022cULL, 0x00005e0026267625ULL, 0x000fc600078e0031ULL,
0x000000002a2f7faeULL, 0x0009e2000c101c46ULL, 0x0000000147247824ULL, 0x000fe200078e022eULL,
0x0000003b26267210ULL, 0x000fe20007f1e0ffULL, 0x00000001432d7824ULL, 0x048fe400078e0232ULL,
0x00000008432e7824ULL, 0x000fe400078e00ffULL, 0x00005e0024287625ULL, 0x000fc600078e0031ULL,
0xfffffff82e2d7812ULL, 0x000fe200078ee22dULL, 0x0000000147247824ULL, 0x040fe400078e0232ULL,
0x0000000847317824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x0000003b28287210ULL, 0x000fe20007f1e0ffULL, 0x000000102d2b7824ULL, 0x010fe200078e022cULL,
0xfffffff831317812ULL, 0x000fc600078ee224ULL, 0x000000ffff297224ULL, 0x000fe200000e0629ULL,
0x00000000262b7faeULL, 0x0007e2000e901c46ULL, 0x00000010312d7824ULL, 0x000fca00078e022cULL,
0x00000000282d7faeULL, 0x0007e2000f101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001037277824ULL, 0x000fe400078e00ffULL, 0x00000080ff2b7424ULL, 0x000fc600078e00ffULL,
0x0000002732277211ULL, 0x000fc800078fe8ffULL, 0x0000000427297810ULL, 0x040fe20007ffe0ffULL,
0x0000000127247824ULL, 0x140fe200078e0232ULL, 0x00000008272d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008272f7824ULL, 0x040fe200078e00ffULL, 0x0000000c27437810ULL, 0x000fe20007ffe0ffULL,
0x0000000129267824ULL, 0x040fe400078e0232ULL, 0x0000000829317824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL, 0x0000001032247824ULL, 0x000fe400078e00ffULL,
0x000000012d287824ULL, 0x000fe200078e022eULL, 0xfffffff831317812ULL, 0x000fe200078ee226ULL,
0x0000000127267824ULL, 0x100fe200078e022eULL, 0x00000070243b7812ULL, 0x000fe200078ec0ffULL,
0x0000000129247824ULL, 0x000fc400078e022eULL, 0x00005e0026267625ULL, 0x000fc800078e002bULL,
0x00000001432a7824ULL, 0x000fe200078e022eULL, 0x0000003b262c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012d297824ULL, 0x140fe400078e0232ULL, 0x000000082d2e7824ULL, 0x000fe400078e00ffULL,
0x00000001432d7824ULL, 0x040fe400078e0232ULL, 0x0000000843307824ULL, 0x000fe200078e00ffULL,
0xfffffff82e437812ULL, 0x000fe200078ee229ULL, 0x0000000234267824ULL, 0x000fc400078e0241ULL,
0x00005e0028287625ULL, 0x000fe200078e002bULL, 0xfffffff830477812ULL, 0x000fe400078ee22dULL,
0x00013000262e7811ULL, 0x000fe200078e60ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e0627ULL,
0x0000003b28287210ULL, 0x000fe20007fbe0ffULL, 0x00005e0024267625ULL, 0x000fc800078e002bULL,
0x00005e002a2a7625ULL, 0x000fe200078e002bULL, 0x0000003b26267210ULL, 0x000fc60007f1e0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e022eULL, 0x0000003b2a2a7210ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x100fe400078e022eULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0007e2000b901c46ULL,
0x00000010433b7824ULL, 0x100fe400078e022eULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x0000000026317faeULL, 0x0007e2000b901c46ULL, 0x0000001047437824ULL, 0x000fc400078e022eULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0x00000000283b7faeULL, 0x0007e8000b901c46ULL,
0x000000002a437faeULL, 0x0007e4000b901c46ULL, 0xfffffff033247812ULL, 0x040fe200078ec0ffULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000001033277812ULL, 0x008fe400078ec0ffULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000000841307824ULL, 0x000fe200078e0224ULL,
0xffffffe033247812ULL, 0x000fc800078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000124267824ULL, 0x000fe200078e0227ULL, 0x000176a830407810ULL, 0x000fc60007ffe0ffULL,
0x0000000837267824ULL, 0x000fc400078e0226ULL, 0x00000000400403c2ULL, 0x000ee40000060000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20001f0f070ULL,
0xffffff8000003947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80030307f8cULL, 0x000ee2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760800262a7f8cULL, 0x0002e4000c80043fULL, 0x0000000000267805ULL, 0x002fc40000015200ULL,
0x0000001038297812ULL, 0x000fca00078ec0ffULL, 0x0000000124247824ULL, 0x000fc800078e0229ULL,
0x0000000837247824ULL, 0x000fca00078e0224ULL, 0x01760c0024297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x00afe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028262d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000002d28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760c0024297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001032247824ULL, 0x000fe200078e00ffULL,
0x00000001ff437819ULL, 0x000fe20000011632ULL, 0x0000002000427824ULL, 0x000fc600078e00ffULL,
0x00000070242f7812ULL, 0x000fe400078ec0ffULL, 0xffffff8042427812ULL, 0x000fe400078ec0ffULL,
0x0000000c43437812ULL, 0x000fc800078ec0ffULL, 0x0000004243247210ULL, 0x000fca0007ffe02fULL,
0x0170000024287984ULL, 0x000e680000000800ULL, 0x0172000024297984ULL, 0x0006a20000000800ULL,
0x000000592800720bULL, 0x002fe20003f1d000ULL, 0x000147727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff242d7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff847424ULL, 0x000fe400078e00ffULL,
0x000000ffff4c7224ULL, 0x000fd200078e0059ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe40000011600ULL, 0x000000592800720bULL, 0x000fe40003f14000ULL,
0x000000002700720cULL, 0x000fe20003fa5270ULL, 0x000147327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000247806ULL, 0x000fc400000e0100ULL, 0x000000800026d824ULL, 0x000fe200078e022fULL,
0x00000028594c7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000014327d824ULL, 0x000fe200078e0226ULL, 0x0000991024267816ULL, 0x000fc800000000ffULL,
0x0174004c2700d388ULL, 0x0003e20000000800ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000004c59267221ULL, 0x002fe20000010000ULL,
0x000000ff24ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL, 0x00000026002f7308ULL, 0x0002ec0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x002fe20000011632ULL,
0x000146827f007947ULL, 0x000fea000b800000ULL, 0x00001f262f267589ULL, 0x0082e400000e0000ULL,
0x000000260c0c7220ULL, 0x088fe40000410000ULL, 0x000000260d0d7220ULL, 0x080fe40000410000ULL,
0x0000002620207220ULL, 0x000fc40000410000ULL, 0x0000002621217220ULL, 0x080fe40000410000ULL,
0x0000002604047220ULL, 0x080fe40000410000ULL, 0x0000002605057220ULL, 0x080fe40000410000ULL,
0x000000261c1c7220ULL, 0x080fe40000410000ULL, 0x000000261d1d7220ULL, 0x080fe40000410000ULL,
0x0000002618187220ULL, 0x000fc40000410000ULL, 0x0000002619197220ULL, 0x080fe40000410000ULL,
0x0000002608087220ULL, 0x080fe40000410000ULL, 0x0000002609097220ULL, 0x080fe40000410000ULL,
0x0000002614147220ULL, 0x080fe40000410000ULL, 0x0000002615157220ULL, 0x080fe40000410000ULL,
0x0000002610107220ULL, 0x000fc40000410000ULL, 0x0000002611117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0024ff7812ULL, 0x000fe2000780c0ffULL,
0x0000002f39397220ULL, 0x008fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000832267811ULL, 0x002fe200078ff0ffULL, 0x000145827f007947ULL, 0x000fea000b800000ULL,
0x00001f262f267589ULL, 0x0002e400000e0000ULL, 0x000000260e0e7220ULL, 0x088fe40000410000ULL,
0x000000260f0f7220ULL, 0x080fe40000410000ULL, 0x0000002622227220ULL, 0x080fe40000410000ULL,
0x0000002623237220ULL, 0x080fe40000410000ULL, 0x0000002606067220ULL, 0x080fe40000410000ULL,
0x0000002607077220ULL, 0x000fc40000410000ULL, 0x000000261e1e7220ULL, 0x080fe40000410000ULL,
0x000000261f1f7220ULL, 0x080fe40000410000ULL, 0x000000261a1a7220ULL, 0x080fe40000410000ULL,
0x000000261b1b7220ULL, 0x080fe40000410000ULL, 0x000000260a0a7220ULL, 0x080fe40000410000ULL,
0x000000260b0b7220ULL, 0x000fc40000410000ULL, 0x0000002616167220ULL, 0x080fe40000410000ULL,
0x0000002617177220ULL, 0x080fe40000410000ULL, 0x0000002612127220ULL, 0x080fe40000410000ULL,
0x0000002613137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2dff7812ULL, 0x000fda0007806024ULL, 0x8000004c28280221ULL, 0x000fe20000010000ULL,
0x00007610ff840816ULL, 0x000fc60000000084ULL, 0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL,
0x0000002800440308ULL, 0x000e640000000800ULL, 0x0000004429290220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003929397221ULL, 0x004fc40000010000ULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x00000008252c7824ULL, 0x000fca00078e0238ULL,
0x0176ac002c247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804857ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028262b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011429ULL,
0x0000002b24247211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000224247819ULL, 0x000fc80000001229ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac002c247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991084247816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003fc5270ULL, 0x0000016000006947ULL, 0x000fea0003800000ULL,
0x00000044ff24723eULL, 0x000fe400000010ffULL, 0x00000002ff297819ULL, 0x000fe40000011632ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x000141927f007947ULL, 0x000fea000b800000ULL,
0x00001f2924457589ULL, 0x0002a400000e0000ULL, 0x0000000829467810ULL, 0x000fe20007ffe0ffULL,
0x000141e27f007947ULL, 0x000fea000b800000ULL, 0x00001f4624467589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001029267810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x000026d0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00014f3000007944ULL, 0x00efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001829267810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x004fe200078e0024ULL,
0x00002740002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x00014ec000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000732997812ULL, 0x000fe200078ec0ffULL,
0x00000200009b7824ULL, 0x000fe200078e00ffULL, 0x00000004ff497819ULL, 0x100fe20000011632ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000899997812ULL, 0x000fe400078ef832ULL,
0xfffff8009b9b7812ULL, 0x000fe200078ec0ffULL, 0x0000000434247824ULL, 0x00afe200078e0249ULL,
0x0000000832277812ULL, 0x000fc600078ec0ffULL, 0x00000001999d7824ULL, 0x040fe400078e0224ULL,
0x0000000899247824ULL, 0x000fca00078e00ffULL, 0xfffffff824247812ULL, 0x000fca00078ee29dULL,
0x0000001024477824ULL, 0x000fc400078e029bULL, 0x0000000727487812ULL, 0x000fe200078ef832ULL,
0x0000000437497824ULL, 0x000fe200078e0249ULL, 0x000000029d9d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000234247824ULL, 0x000fe200078e0225ULL, 0x0000001048527812ULL, 0x040fe200078efcffULL,
0x0000000148287824ULL, 0x040fe400078e0249ULL, 0x0000000848257824ULL, 0x000fe200078e00ffULL,
0x0001300024557811ULL, 0x000fe200078e60ffULL, 0x0000000848297824ULL, 0x000fe200078e00ffULL,
0x00000002283a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000149537824ULL, 0x000fe200078e0252ULL,
0xfffffff825247812ULL, 0x000fe200078ee228ULL, 0x0000000852287824ULL, 0x040fe200078e00ffULL,
0xfffffff8293a7812ULL, 0x000fe200078ee23aULL, 0x0000000852577824ULL, 0x000fc400078e00ffULL,
0x0000001024247824ULL, 0x000fe200078e0255ULL, 0xfffffff8283b7812ULL, 0x000fe200078ee253ULL,
0x000000103a2c7824ULL, 0x000fc800078e0255ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x000000103b287824ULL, 0x000fc600078e0255ULL, 0x000000002c2c783bULL, 0x000ee80000004200ULL,
0x000000002828783bULL, 0x004ea20000004200ULL, 0x0000002400b57306ULL, 0x002fe20000009400ULL,
0x00000018ff4a7819ULL, 0x000fe20000011424ULL, 0x0000010025517824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011425ULL, 0x000001002d637824ULL, 0x008fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011426ULL, 0x000001002c617824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000002400627306ULL, 0x000e620000005400ULL,
0x00000018ff637819ULL, 0x000fc40000011463ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x00000018ff527819ULL, 0x000fe4000001142eULL, 0x00000018ff4e7819ULL, 0x000fe20000011427ULL,
0x0000004a006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff547819ULL, 0x004fe40000011428ULL,
0x00000018ff5b7819ULL, 0x000fca000001142bULL, 0x0000004a00b37306ULL, 0x000fe20000205400ULL,
0x00000062b500720bULL, 0x002fce0003fbd000ULL, 0x0000004a00837306ULL, 0x0003f0000020d400ULL,
0x00000024008b7306ULL, 0x0004e2000000d400ULL, 0x00000100244a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000002500787306ULL, 0x000fe20000009400ULL,
0x0001000024247824ULL, 0x004fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000004a00c67306ULL, 0x000fe20000209400ULL, 0x000000018b8b5812ULL, 0x008fe400078efcffULL,
0x000000b36c00720bULL, 0x000fca0003fbd000ULL, 0x0000004a00c97306ULL, 0x000e700000205400ULL,
0x0000004a00947306ULL, 0x0004e2000020d400ULL, 0x0000000183835812ULL, 0x000fce00078efcffULL,
0x0000002500717306ULL, 0x000f220000005400ULL, 0x000000c9c600720bULL, 0x002fe20003f1d000ULL,
0x00000100264a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000002400cd7306ULL, 0x000fec0000209400ULL, 0x0000000194940812ULL, 0x008fe400078efcffULL,
0x0000002400ca7306ULL, 0x000e620000205400ULL, 0x000000717800720bULL, 0x010fce0003fbd000ULL,
0x0000002500857306ULL, 0x0004f0000000d400ULL, 0x0000002400887306ULL, 0x000922000020d400ULL,
0x000000cacd00720bULL, 0x002fe20003f1d000ULL, 0x0001000025257824ULL, 0x004fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000004b00ae7306ULL, 0x000fe20000209400ULL,
0x0000000185855812ULL, 0x008fe200078efcffULL, 0x0000010027247824ULL, 0x010fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000004b00ad7306ULL, 0x000e620000205400ULL,
0x0000000188880812ULL, 0x000fc800078efcffULL, 0x000000888388723eULL, 0x000fc600000010ffULL,
0x0000005100c57306ULL, 0x000ff00000209400ULL, 0x0000005100c07306ULL, 0x000ea20000205400ULL,
0x000000adae00720bULL, 0x002fce0003fbd000ULL, 0x0000004b007d7306ULL, 0x000e70000020d400ULL,
0x0000005100927306ULL, 0x000722000020d400ULL, 0x000000c0c500720bULL, 0x004fce0003f1d000ULL,
0x0000002600867306ULL, 0x000fe20000009400ULL, 0x000000017d7d5812ULL, 0x002fe400078efcffULL,
0x00000018ff517819ULL, 0x008fca000001142dULL, 0x00000026007f7306ULL, 0x000e620000005400ULL,
0x0000000192920812ULL, 0x010fce00078efcffULL, 0x0000002500c47306ULL, 0x000ff00000209400ULL,
0x0000002500c37306ULL, 0x000ea20000205400ULL, 0x0000007f8600720bULL, 0x002fce0003fbd000ULL,
0x0000002500807306ULL, 0x0002f0000020d400ULL, 0x00000026007b7306ULL, 0x0008e2000000d400ULL,
0x00000018ff257819ULL, 0x002fe4000001142cULL, 0x000000c3c400720bULL, 0x004fca0003f1d000ULL,
0x0000002c00aa7306ULL, 0x000fe20000009400ULL, 0x0001000026267824ULL, 0x010fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002c00a77306ULL, 0x000fe20000005400ULL,
0x0000000180800812ULL, 0x008fe400078efcffULL, 0x000000017b7b5812ULL, 0x000fca00078efcffULL,
0x0000002c00677306ULL, 0x0003f0000000d400ULL, 0x0000004d00a37306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000004d00a67306ULL, 0x000e700000205400ULL, 0x0000004a00c17306ULL, 0x000ff00000209400ULL,
0x0000004a00bc7306ULL, 0x000ea20000205400ULL, 0x000000a6a300720bULL, 0x002fce0003fbd000ULL,
0x0000006300bd7306ULL, 0x000ff00000209400ULL, 0x0000006300b87306ULL, 0x000fe20000205400ULL,
0x000000bcc100720bULL, 0x004fce0003f1d000ULL, 0x00000063006f7306ULL, 0x0003f0000020d400ULL,
0x0000002d00a87306ULL, 0x000fe20000009400ULL, 0x000001002f637824ULL, 0x002fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000002d00a57306ULL, 0x000ff00000005400ULL,
0x0000002d00667306ULL, 0x0003f0000000d400ULL, 0x0000002c00c77306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00c27306ULL, 0x000ff00000205400ULL, 0x0000002c00727306ULL, 0x0003f0000020d400ULL,
0x0000004d00757306ULL, 0x000ea2000020d400ULL, 0x00000100282c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000004a007e7306ULL, 0x0002f0000020d400ULL,
0x0000002700937306ULL, 0x000fe20000009400ULL, 0x00000002534a7810ULL, 0x002fc40007ffe0ffULL,
0x00000018ff537819ULL, 0x000fe4000001142fULL, 0x0000000175755812ULL, 0x004fe400078efcffULL,
0xfffffff8574a7812ULL, 0x000fe200078ee24aULL, 0x0000002700a47306ULL, 0x000e620000005400ULL,
0x000000017e7e0812ULL, 0x008fe400078efcffULL, 0x00000018ff577819ULL, 0x000fca000001142aULL,
0x0000002600bf7306ULL, 0x000ff00000209400ULL, 0x0000002600be7306ULL, 0x000ea20000205400ULL,
0x000000a49300720bULL, 0x002fce0003fbd000ULL, 0x0000006100ba7306ULL, 0x000ff00000209400ULL,
0x0000006100bb7306ULL, 0x000fe20000205400ULL, 0x000000bebf00720bULL, 0x004fce0003f1d000ULL,
0x00000061006e7306ULL, 0x0003f0000020d400ULL, 0x0000006300cf7306ULL, 0x000fe20000209400ULL,
0x000001002e617824ULL, 0x002fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006300cc7306ULL, 0x000ff00000205400ULL, 0x0000006300647306ULL, 0x000ff0000020d400ULL,
0x0000002e00a17306ULL, 0x000ff00000009400ULL, 0x0000002e00a27306ULL, 0x000ff00000005400ULL,
0x0000002e005f7306ULL, 0x0003f0000000d400ULL, 0x0000002f004b7306ULL, 0x000fe20000009400ULL,
0x000100002e2e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000002f009c7306ULL, 0x000ff00000005400ULL, 0x0000002f005d7306ULL, 0x0003f0000000d400ULL,
0x0000002d00ce7306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x0000002d00d17306ULL, 0x000ff00000205400ULL,
0x0000002d00687306ULL, 0x0003f0000020d400ULL, 0x0000002c00d47306ULL, 0x000fe20000209400ULL,
0x00000100292d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00d77306ULL, 0x000ff00000205400ULL, 0x0000002c00637306ULL, 0x0003f0000020d400ULL,
0x0000002700747306ULL, 0x0004e2000000d400ULL, 0x000001002b2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000026007a7306ULL, 0x000e62000020d400ULL,
0x0001000027277824ULL, 0x004fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000004e009e7306ULL, 0x000fe20000209400ULL, 0x0000000174745812ULL, 0x008fce00078efcffULL,
0x0000004e00a97306ULL, 0x000ea20000205400ULL, 0x000000017a7a0812ULL, 0x002fc800078efcffULL,
0x0000007a757a723eULL, 0x000fc600000010ffULL, 0x0000002400b77306ULL, 0x000ff00000209400ULL,
0x0000002400b47306ULL, 0x000e620000205400ULL, 0x000000a99e00720bULL, 0x004fce0003fbd000ULL,
0x0000006100c87306ULL, 0x000ff00000209400ULL, 0x0000006100cb7306ULL, 0x000fe20000205400ULL,
0x000000b4b700720bULL, 0x002fce0003f1d000ULL, 0x00000061006a7306ULL, 0x000ff0000020d400ULL,
0x0000002e00d27306ULL, 0x000ff00000209400ULL, 0x0000002e00d57306ULL, 0x000ff00000205400ULL,
0x0000002e00697306ULL, 0x000ff0000020d400ULL, 0x0000002f00d97306ULL, 0x000ff00000209400ULL,
0x0000002f00d67306ULL, 0x000ff00000205400ULL, 0x0000002f00617306ULL, 0x000ff0000020d400ULL,
0x0000002d00c67306ULL, 0x000ff00000209400ULL, 0x0000002d00b57306ULL, 0x000ff00000205400ULL,
0x0000002d006c7306ULL, 0x000ff0000020d400ULL, 0x0000002c00c37306ULL, 0x000ff00000209400ULL,
0x0000002c00ae7306ULL, 0x000ff00000205400ULL, 0x0000002c007f7306ULL, 0x0003f0000020d400ULL,
0x0000004e00737306ULL, 0x000ea2000020d400ULL, 0x01100000472c783bULL, 0x002e6e0000000200ULL,
0x0000002400797306ULL, 0x000730000020d400ULL, 0x0000002700b97306ULL, 0x000fe20000209400ULL,
0x0000000173735812ULL, 0x004fe200078efcffULL, 0x000000104a247824ULL, 0x008fe200078e0255ULL,
0x000000a7aa00720bULL, 0x000fc40003fbd000ULL, 0x00000018ff557819ULL, 0x000fc60000011429ULL,
0x0000002700b67306ULL, 0x000ea20000205400ULL, 0x0000000179790812ULL, 0x010fce00078efcffULL,
0x00000027007c7306ULL, 0x000ee2000020d400ULL, 0x0000000167675812ULL, 0x000fe400078efcffULL,
0x000000c2c700720bULL, 0x000fe40003fbd000ULL, 0x000000b6b900720bULL, 0x004fc60003f1d000ULL,
0x0000002500b17306ULL, 0x000fe20000209400ULL, 0x000000452c2ce231ULL, 0x082fe400003400ffULL,
0x000000452e2ee231ULL, 0x000fe400003400ffULL, 0x000000462d2de231ULL, 0x080fe400003400ffULL,
0x000000462f2fe231ULL, 0x000fe200003400ffULL, 0x0000002500b07306ULL, 0x000e620000205400ULL,
0x000000b8bd00720bULL, 0x000fe40003fdd000ULL, 0x0000000172725812ULL, 0x000fc400078efcffULL,
0x000000017c7c0812ULL, 0x008fe400078efcffULL, 0x000000bbba00720bULL, 0x000fe20003f1d000ULL,
0x0000005100b27306ULL, 0x000fec0000209400ULL, 0x000000016f6f6812ULL, 0x000fe400078efcffULL,
0x0000005100af7306ULL, 0x000ea20000205400ULL, 0x000000b0b100720bULL, 0x002fc60003fdd000ULL,
0x000000016e6e0812ULL, 0x000fe400078efcffULL, 0x000000a5a800720bULL, 0x000fe40003f1d000ULL,
0x00000025006b7306ULL, 0x0002e2000020d400ULL, 0x000000676e6e723eULL, 0x000fce00000010ffULL,
0x0000005100657306ULL, 0x000f22000020d400ULL, 0x000000002424783bULL, 0x002e620000004200ULL,
0x000000afb200720bULL, 0x004fe40003fbd000ULL, 0x0000000166660812ULL, 0x000fe400078efcffULL,
0x000000d1ce00720bULL, 0x000fe40003f1d000ULL, 0x0000002800897306ULL, 0x000fe20000009400ULL,
0x000000016b6b6812ULL, 0x008fe400078efcffULL, 0x000000cbc800720bULL, 0x000fc40003fdd000ULL,
0x000000726b72723eULL, 0x000fe400000010ffULL, 0x000000666f6f723eULL, 0x000fe200000010ffULL,
0x00000028008c7306ULL, 0x000fe20000005400ULL, 0x0000000165655812ULL, 0x010fe400078efcffULL,
0x000000cccf00720bULL, 0x000fe40003fbd000ULL, 0x0000000168680812ULL, 0x000fe200078efcffULL,
0x0000006e2c18723cULL, 0x000fe20000041818ULL, 0x000000a2a100720bULL, 0x000fe20003f1d000ULL,
0x0000002800507306ULL, 0x0005e2000000d400ULL, 0x000000016a6a6812ULL, 0x000fc400078efcffULL,
0x0000009c4b00720bULL, 0x000fca0003fdd000ULL, 0x0000005200ac7306ULL, 0x000fe20000209400ULL,
0x0001000028287824ULL, 0x004fe200078e00ffULL, 0x0000000164645812ULL, 0x000fe400078efcffULL,
0x000000d5d200720bULL, 0x000fe40003fbd000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000005200ab7306ULL, 0x000ea20000205400ULL, 0x000000015f5f0812ULL, 0x000fe400078efcffULL,
0x000000015d5d6812ULL, 0x000fc400078efcffULL, 0x000000d6d900720bULL, 0x000fe40003fdd000ULL,
0x0000005d646b723eULL, 0x000fe200000010ffULL, 0x0000002800d07306ULL, 0x000fe20000209400ULL,
0x0000000169695812ULL, 0x000fe400078efcffULL, 0x0000005f6a6a723eULL, 0x000fe200000010ffULL,
0x00010000275f7824ULL, 0x002fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fc60000011427ULL,
0x0000002800d37306ULL, 0x000fe20000205400ULL, 0x000000abac00720bULL, 0x004fe20003f1d000ULL,
0x0000006a2c14723cULL, 0x000fe20000041814ULL, 0x0000000161616812ULL, 0x000fe400078efcffULL,
0x0000008c8900720bULL, 0x000fe40003fdd000ULL, 0x0000991084897816ULL, 0x000fe200000000ffULL,
0x0000002800627306ULL, 0x0003e2000020d400ULL, 0x00000018ff5f7819ULL, 0x000fce000001145fULL,
0x00000053009f7306ULL, 0x000fe20000209400ULL, 0x000001002a287824ULL, 0x002fe200078e00ffULL,
0x0000000150506812ULL, 0x000fe400078efcffULL, 0x000000b5c600720bULL, 0x000fe40003fdd000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000005300a07306ULL, 0x000e700000205400ULL,
0x0000002800c57306ULL, 0x000fe20000209400ULL, 0x000000016c6c6812ULL, 0x000fce00078efcffULL,
0x0000002800c07306ULL, 0x000fe20000205400ULL, 0x000000a09f00720bULL, 0x002fce0003fbd000ULL,
0x0000002800787306ULL, 0x0003f0000020d400ULL, 0x0000005200607306ULL, 0x000ea2000020d400ULL,
0x00000018ff287819ULL, 0x002fce0000011424ULL, 0x0000002800a37306ULL, 0x000ff00000209400ULL,
0x0000002800a67306ULL, 0x000fe20000205400ULL, 0x0000000160600812ULL, 0x004fe400078efcffULL,
0x000000d7d400720bULL, 0x000fc40003f1d000ULL, 0x000000696060723eULL, 0x000fc600000010ffULL,
0x00000028009e7306ULL, 0x0003f0000020d400ULL, 0x00000053005e7306ULL, 0x000ea2000020d400ULL,
0x0000010024287824ULL, 0x002fe200078e00ffULL, 0x0000000163630812ULL, 0x000fc800078efcffULL,
0x00000018ffaf7819ULL, 0x000fe20000011428ULL, 0x0000000899287824ULL, 0x000fe200078e00ffULL,
0x00000029008f7306ULL, 0x000fe80000009400ULL, 0xfffffff828287812ULL, 0x000fc800078ee29dULL,
0x00000029008a7306ULL, 0x000e620000005400ULL, 0x00000010284b7824ULL, 0x000fe200078e029bULL,
0x000000015e5e5812ULL, 0x004fe200078efcffULL, 0x0000010025287824ULL, 0x000fe200078e00ffULL,
0x000000d3d000720bULL, 0x000fe40003fbd000ULL, 0x000000615e61723eULL, 0x000fe400000010ffULL,
0x00000029004d7306ULL, 0x0004e2000000d400ULL, 0x00000018ff9b7819ULL, 0x000fc80000011428ULL,
0x000000602c10723cULL, 0x000fe60000041810ULL, 0x0000002a008d7306ULL, 0x000fe20000009400ULL,
0x0001000029297824ULL, 0x004fe200078e00ffULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x0000008a8f00720bULL, 0x002fe40003fbd000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00907306ULL, 0x000ff00000005400ULL, 0x0000002a004f7306ULL, 0x0003e2000000d400ULL,
0x000000014d4d5812ULL, 0x008fce00078efcffULL, 0x0000002b008e7306ULL, 0x000fe20000009400ULL,
0x000100002a2a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002b00877306ULL, 0x000ff00000005400ULL, 0x0000002b004e7306ULL, 0x0003f0000000d400ULL,
0x0000002900ca7306ULL, 0x000fe20000209400ULL, 0x000100002b2b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000002900b37306ULL, 0x000e700000205400ULL,
0x0000002900717306ULL, 0x0004f0000020d400ULL, 0x0000002a00c17306ULL, 0x000fe20000209400ULL,
0x00000018ff297819ULL, 0x004fc40000011425ULL, 0x000000b3ca00720bULL, 0x002fca0003fdd000ULL,
0x0000002a00c47306ULL, 0x000e700000205400ULL, 0x0000002a00867306ULL, 0x0005e2000020d400ULL,
0x0000000171716812ULL, 0x008fe400078efcffULL, 0x000000908d00720bULL, 0x000fca0003fdd000ULL,
0x0000005400987306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x004fce0000011426ULL,
0x0000005400957306ULL, 0x000ea20000205400ULL, 0x000000014f4f6812ULL, 0x000fe400078efcffULL,
0x000000c4c100720bULL, 0x002fca0003fdd000ULL, 0x0000002b00bf7306ULL, 0x000ff00000209400ULL,
0x0000002b00bc7306ULL, 0x000e620000205400ULL, 0x000000959800720bULL, 0x004fe40003f1d000ULL,
0x0000000186866812ULL, 0x000fca00078efcffULL, 0x0000002b00937306ULL, 0x000eb0000020d400ULL,
0x0000002900a47306ULL, 0x000fe20000209400ULL, 0x000000bcbf00720bULL, 0x002fce0003fdd000ULL,
0x0000002900a77306ULL, 0x000fec0000205400ULL, 0x0000000193936812ULL, 0x004fe400078efcffULL,
0x0000002900a57306ULL, 0x000ff0000020d400ULL, 0x0000002a00a87306ULL, 0x000ff00000209400ULL,
0x0000002a00a97306ULL, 0x000ff00000205400ULL, 0x0000002a00aa7306ULL, 0x0003f0000020d400ULL,
0x0000005400517306ULL, 0x000ea2000020d400ULL, 0x011000004b28783bULL, 0x002e6e0000000200ULL,
0x00000055009a7306ULL, 0x000ff00000209400ULL, 0x0000005500977306ULL, 0x000ee20000205400ULL,
0x0000000151510812ULL, 0x004fc400078efcffULL, 0x000000ff8900720cULL, 0x000fe40003f05270ULL,
0x000000625162723eULL, 0x000fc600000010ffULL, 0x0000005500527306ULL, 0x000ea2000020d400ULL,
0x000000979a00720bULL, 0x008fce0003fbd000ULL, 0x0000005700967306ULL, 0x000ff00000209400ULL,
0x0000005700917306ULL, 0x000ee20000205400ULL, 0x0000004528288231ULL, 0x082fe400003400ffULL,
0x000000452a2a8231ULL, 0x000fe200003400ffULL, 0x0000000152525812ULL, 0x004fe200078efcffULL,
0x0000004629298231ULL, 0x080fe200003400ffULL, 0x000000aec300720bULL, 0x000fe20003fbd000ULL,
0x000000462b2b8231ULL, 0x000fe200003400ffULL, 0x000000c0c500720bULL, 0x000fe20003f1d000ULL,
0x0000005700537306ULL, 0x000e70000020d400ULL, 0x0000005b00817306ULL, 0x000fe40000209400ULL,
0x000000017f7f5812ULL, 0x000fc400078efcffULL, 0x0000000178780812ULL, 0x000fe400078efcffULL,
0x000000878e00720bULL, 0x000fe40003f1d000ULL, 0x0000005b00827306ULL, 0x000ea20000205400ULL,
0x000000919600720bULL, 0x008fe40003fbd000ULL, 0x0000004f7878723eULL, 0x000fca00000010ffULL,
0x000000af00b07306ULL, 0x000fe60000209400ULL, 0x000000014e4e0812ULL, 0x000fc600078efcffULL,
0x0000000153535812ULL, 0x002fe400078efcffULL, 0x000000af00997306ULL, 0x000e620000205400ULL,
0x000000828100720bULL, 0x004fe40003f1d000ULL, 0x000000865386723eULL, 0x000fca00000010ffULL,
0x0000005b00547306ULL, 0x000eb0000020d400ULL, 0x000000af009c7306ULL, 0x000ee2000020d400ULL,
0x00000099b000720bULL, 0x002fce0003fbd000ULL, 0x0000002400767306ULL, 0x000fe20000009400ULL,
0x0000000154540812ULL, 0x004fce00078efcffULL, 0x0000002400777306ULL, 0x000e620000005400ULL,
0x000000019c9c5812ULL, 0x008fce00078efcffULL, 0x00000025006d7306ULL, 0x000ff00000009400ULL,
0x0000002500707306ULL, 0x000ea20000005400ULL, 0x000000777600720bULL, 0x002fce0003fdd000ULL,
0x0000009b009d7306ULL, 0x000ff00000209400ULL, 0x0000009b008c7306ULL, 0x000e620000205400ULL,
0x000000706d00720bULL, 0x004fce0003f1d000ULL, 0x0000002400557306ULL, 0x0004f0000000d400ULL,
0x0000002500567306ULL, 0x0008e2000000d400ULL, 0x0001000024247824ULL, 0x004fe200078e00ffULL,
0x0000008c9d00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000009b00957306ULL, 0x000e62000020d400ULL, 0x0001000025257824ULL, 0x010fe200078e00ffULL,
0x0000000155556812ULL, 0x008fc800078efcffULL, 0x00000018ff897819ULL, 0x000fe40000011425ULL,
0x0000002400847306ULL, 0x000fe20000209400ULL, 0x000000859225723eULL, 0x000fe400000010ffULL,
0x0000000156560812ULL, 0x000fca00078efcffULL, 0x00000024009b7306ULL, 0x000ea20000205400ULL,
0x0000000195955812ULL, 0x002fe400078efcffULL, 0x000000a6a300720bULL, 0x000fe40003fbd000ULL,
0x000000569595723eULL, 0x000fc600000010ffULL, 0x00000089008a7306ULL, 0x000ff00000209400ULL,
0x00000089008d7306ULL, 0x000e620000205400ULL, 0x0000009b8400720bULL, 0x004fe40003fdd000ULL,
0x000000019e9e5812ULL, 0x000fca00078efcffULL, 0x00000024008f7306ULL, 0x0004f0000020d400ULL,
0x0000008900907306ULL, 0x0008e2000020d400ULL, 0x0000010026247824ULL, 0x004fe200078e00ffULL,
0x0000008d8a00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff877819ULL, 0x000fe40000011424ULL,
0x0000008b9424723eULL, 0x000fe200000010ffULL, 0x0000002600577306ULL, 0x000fe20000009400ULL,
0x000000807d89723eULL, 0x010fe400000010ffULL, 0x000000018f8f6812ULL, 0x008fe400078efcffULL,
0x000000a7a400720bULL, 0x000fe20003fdd000ULL, 0x000000242c0c723cULL, 0x000b62000004180cULL,
0x0000000190900812ULL, 0x000fe200078efcffULL, 0x0000002600587306ULL, 0x000e620000005400ULL,
0x000000559c94723eULL, 0x000fc400000010ffULL, 0x0000008f9e9e723eULL, 0x000fe400000010ffULL,
0x000000747925723eULL, 0x020fe200000010ffULL, 0x0000010027797824ULL, 0x000fe200078e00ffULL,
0x0000007b7e24723eULL, 0x000fe200000010ffULL, 0x0000008700857306ULL, 0x000fe20000209400ULL,
0x0000007c737b723eULL, 0x000fe200000010ffULL, 0x000000882c20723cULL, 0x000f620000041820ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x000000686573723eULL, 0x000fc400000010ffULL,
0x00000001a5a56812ULL, 0x000fe200078efcffULL, 0x0000008700807306ULL, 0x000ea20000205400ULL,
0x000000585700720bULL, 0x002fe20003fbd000ULL, 0x000000242c04723cULL, 0x000be20000041804ULL,
0x00000090a59f723eULL, 0x000fca00000010ffULL, 0x0000002600597306ULL, 0x0002e2000000d400ULL,
0x000000506324723eULL, 0x020fe200000010ffULL, 0x0000007a2c1c723cULL, 0x000f62000004181cULL,
0x0000004d6c25723eULL, 0x000fe200000010ffULL, 0x0000000200507824ULL, 0x000fe200078e00ffULL,
0x000000715263723eULL, 0x000fc600000010ffULL, 0x0000008700747306ULL, 0x000922000020d400ULL,
0x0001000026267824ULL, 0x002fe200078e00ffULL, 0x000000808500720bULL, 0x004fe20003f1d000ULL,
0x00000024280c723cULL, 0x000fe6000004180cULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000027005a7306ULL, 0x000fe20000009400ULL, 0x0000000159595812ULL, 0x008fe400078efcffULL,
0x000000722c08723cULL, 0x000f620000041808ULL, 0x000000935487723eULL, 0x010fc800000010ffULL,
0x00000027005b7306ULL, 0x000e620000005400ULL, 0x0000000174740812ULL, 0x000fe400078efcffULL,
0x000000622820723cULL, 0x000b640000041820ULL, 0x000000597474723eULL, 0x000fc600000010ffULL,
0x0000007900757306ULL, 0x000fe60000209400ULL, 0x00000086281c723cULL, 0x060b6a000004181cULL,
0x0000007900667306ULL, 0x000ea20000205400ULL, 0x0000005b5a00720bULL, 0x002fe40003f1d000ULL,
0x000000942818723cULL, 0x040b6a0000041818ULL, 0x00000026005d7306ULL, 0x000fe60000209400ULL,
0x0000009e2808723cULL, 0x000b6a0000041808ULL, 0x00000026005e7306ULL, 0x000e620000205400ULL,
0x000000667500720bULL, 0x004fce0003fdd000ULL, 0x00000027005c7306ULL, 0x000eb0000000d400ULL,
0x0000007900657306ULL, 0x000722000020d400ULL, 0x0000005e5d00720bULL, 0x002fce0003fbd000ULL,
0x0000002600277306ULL, 0x000e62000020d400ULL, 0x000000015c5c0812ULL, 0x004fe400078efcffULL,
0x0000004e7f79723eULL, 0x008fca00000010ffULL, 0x000000ad00a17306ULL, 0x000fe20000209400ULL,
0x0000000165656812ULL, 0x010fe200078efcffULL, 0x000000782804723cULL, 0x000b620000041804ULL,
0x000000a9a800720bULL, 0x000fe40003fdd000ULL, 0x0000005c6575723eULL, 0x000fc600000010ffULL,
0x000000ad00a27306ULL, 0x000ea20000205400ULL, 0x0000000127275812ULL, 0x002fc600078efcffULL,
0x000000742814723cULL, 0x000b680000041814ULL, 0x0000005f00247306ULL, 0x000fe20000209400ULL,
0x00000001aaaa6812ULL, 0x000fc800078efcffULL, 0x00000027aaaa723eULL, 0x000fc600000010ffULL,
0x0000005f00257306ULL, 0x000e620000205400ULL, 0x000000a2a100720bULL, 0x004fce0003f1d000ULL,
0x000000ad00267306ULL, 0x000eb0000020d400ULL, 0x0000005f00ab7306ULL, 0x000ee2000020d400ULL,
0x000000252400720bULL, 0x002fe40003fbd000ULL, 0x0000000126260812ULL, 0x004fd600078efcffULL,
0x00000001abab5812ULL, 0x008fc800078efcffULL, 0x000000ab26ab723eULL, 0x000fce00000010ffULL,
0x000000aa2810723cULL, 0x000b620000041810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000003e247f8cULL, 0x0002a2000c80043fULL, 0xfffffff850507812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000403c277811ULL, 0x000fe200078e40ffULL,
0x0176880050ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff2a7224ULL, 0x024fe400078e0025ULL,
0x000000022700720cULL, 0x000fe20003f06070ULL, 0x000000ffff597224ULL, 0x000fe400078e004cULL,
0x000000ffff577224ULL, 0x000fc400078e0031ULL, 0x000000ffff257224ULL, 0x000fd000078e0041ULL,
0x00009f3000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x008fc40000015200ULL,
0x000004003e277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003e277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000013c247810ULL, 0x000fe40007ffe0ffULL, 0x000000803f257810ULL, 0x000fe40007ffe0ffULL,
0x000000032400720cULL, 0x000fc60003f06070ULL, 0x00006200362c7a24ULL, 0x000fd400078e0225ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x00000003ff297819ULL, 0x100fe20000011632ULL,
0x00000010372e7824ULL, 0x000fe200078e00ffULL, 0x0000002502247217ULL, 0x000fe20007800000ULL,
0x00000080ff4d7424ULL, 0x000fe200078e00ffULL, 0x0000000c29537810ULL, 0x000fe20007ffe0ffULL,
0x000000012e2b7824ULL, 0x000fe400078e0229ULL, 0x0000000124257824ULL, 0x000fe400078e0a25ULL,
0x000000012b267824ULL, 0x040fe400078e0232ULL, 0x000000082b277824ULL, 0x000fe200078e00ffULL,
0x000000252e257217ULL, 0x000fe20007800000ULL, 0x000010003d247824ULL, 0x000fc400078e00ffULL,
0x000000012e557824ULL, 0x000fe200078e0253ULL, 0xfffffff827287812ULL, 0x000fe200078ee226ULL,
0x0000001032267824ULL, 0x000fe200078e00ffULL, 0x0000100024277812ULL, 0x000fe200078ec0ffULL,
0x000000012b247824ULL, 0x000fe200078e022cULL, 0x00000004292b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001252a7824ULL, 0x000fe200078e0a2eULL, 0x0000007026517812ULL, 0x000fe200078ec0ffULL,
0x00005e0024247625ULL, 0x000fc600078e004dULL, 0x0000002a2900720cULL, 0x080fe20003fa6070ULL,
0x000000012e2d7824ULL, 0x000fe200078e022bULL, 0x0000005124267210ULL, 0x000fe20007fde0ffULL,
0x0000200034277824ULL, 0x000fe200078e0227ULL, 0x0000002a2b00720cULL, 0x000fe20003f06070ULL,
0x000000012d2f7824ULL, 0x040fe400078e0232ULL, 0x000000082d4e7824ULL, 0x000fe200078e00ffULL,
0x00013000272b7810ULL, 0x000fe20007ffe0ffULL, 0x000000012d247824ULL, 0x000fe400078e022cULL,
0x000000ffff277224ULL, 0x000fe200030e0625ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee22fULL,
0x00005e0024247625ULL, 0x000fe200078e004dULL, 0x00000008292f7810ULL, 0x000fc60007ffe0ffULL,
0x00000010282d7824ULL, 0x000fe200078e022bULL, 0x0000005124287210ULL, 0x000fe20007fde0ffULL,
0x000000012e4f7824ULL, 0x000fc600078e022fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262d7faeULL, 0x0005e2000e901c46ULL, 0x000000014f247824ULL, 0x100fe200078e022cULL,
0x0000002a2f00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x0000002a5300720cULL, 0x000fe20003fc6070ULL, 0x000000104e2f7824ULL, 0x000fe400078e022bULL,
0x00000001552a7824ULL, 0x000fe400078e022cULL, 0x00005e0024247625ULL, 0x000fe200078e004dULL,
0x00000000282f7faeULL, 0x0007e6000c101c46ULL, 0x000000014f2c7824ULL, 0x000fe200078e0232ULL,
0x0000005124247210ULL, 0x000fe20007f1e0ffULL, 0x00005e002a267625ULL, 0x004fc800078e004dULL,
0x000000084f4f7824ULL, 0x000fe400078e00ffULL, 0x00000001552a7824ULL, 0x040fe400078e0232ULL,
0x0000000855557824ULL, 0x000fe200078e00ffULL, 0xfffffff84f2c7812ULL, 0x000fe200078ee22cULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000005126267210ULL, 0x000fe40007f1e0ffULL,
0xfffffff8552a7812ULL, 0x000fe200078ee22aULL, 0x000000102c297824ULL, 0x008fc400078e022bULL,
0x000000ffff277224ULL, 0x000fe400000e0627ULL, 0x000000102a2b7824ULL, 0x000fe200078e022bULL,
0x0000000024297faeULL, 0x0005e8000e901c46ULL, 0x00000000262b7faeULL, 0x0005e2000f101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001037257824ULL, 0x000fe400078e00ffULL,
0x0000001032517824ULL, 0x000fc400078e00ffULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x0000002532257211ULL, 0x000fe400078fe8ffULL, 0x0000007051517812ULL, 0x000fe400078ec0ffULL,
0x00000004252f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000125247824ULL, 0x140fe200078e0232ULL,
0x00000008254f7810ULL, 0x040fe20007ffe0ffULL, 0x00000008252d7824ULL, 0x040fe200078e00ffULL,
0x0000000c25537810ULL, 0x000fe20007ffe0ffULL, 0x000000012f267824ULL, 0x000fc400078e0232ULL,
0x000000082f4d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee224ULL,
0x000010003d247824ULL, 0x000fe400078e00ffULL, 0x0000000153287824ULL, 0x000fe200078e022cULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee226ULL, 0x000000012f267824ULL, 0x100fe200078e022cULL,
0x0000100024277812ULL, 0x000fe200078ec0ffULL, 0x0000000125247824ULL, 0x000fe400078e022cULL,
0x000000014f2e7824ULL, 0x000fc400078e0232ULL, 0x00005e0024247625ULL, 0x000fc800078e0029ULL,
0x00002000342b7824ULL, 0x000fe200078e0227ULL, 0x00000051242a7210ULL, 0x000fe20007f1e0ffULL,
0x000000014f277824ULL, 0x040fe400078e022cULL, 0x000000084f4f7824ULL, 0x000fe200078e00ffULL,
0x000130002b2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2b7224ULL, 0x000fe400000e0625ULL,
0x00005e0026247625ULL, 0x000fe200078e0029ULL, 0xfffffff84f4f7812ULL, 0x000fc600078ee22eULL,
0x00005e0027267625ULL, 0x000fe200078e0029ULL, 0x0000005124247210ULL, 0x000fc60007f1e0ffULL,
0x00000001532f7824ULL, 0x040fe200078e0232ULL, 0x0000005126267210ULL, 0x000fe20007fbe0ffULL,
0x00000008534e7824ULL, 0x000fe400078e00ffULL, 0x00005e0028287625ULL, 0x000fc600078e0029ULL,
0xfffffff84e537812ULL, 0x000fe200078ee22fULL, 0x000000102d2d7824ULL, 0x100fe200078e022cULL,
0x0000005128287210ULL, 0x000fe20007fde0ffULL, 0x000000104d2f7824ULL, 0x100fe400078e022cULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2d7faeULL, 0x0005e2000b901c46ULL, 0x000000104f4d7824ULL, 0x100fe400078e022cULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x00000000242f7faeULL, 0x0005e2000b901c46ULL,
0x00000010534f7824ULL, 0x000fc400078e022cULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x00000000264d7faeULL, 0x0005e8000b901c46ULL, 0x00000000284f7faeULL, 0x0005e4000b901c46ULL,
0x000000083d247824ULL, 0x004fe200078e00ffULL, 0xfffffff033257812ULL, 0x040fe200078ec0ffULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0xffffffe033267812ULL, 0x000fe400078ec0ffULL,
0x0000000824247812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x0000000125527824ULL, 0x000fe200078e0224ULL, 0x0000001033257812ULL, 0x000fc800078ec0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000126247824ULL, 0x000fe200078e0225ULL,
0x000176a852537810ULL, 0x000fc60007ffe0ffULL, 0x0000000837247824ULL, 0x000fc400078e0224ULL,
0x00000000530403c2ULL, 0x000ea40000040000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000170f070ULL, 0xffffff8000002947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80052567f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176280024287f8cULL, 0x0002a4000c80043fULL,
0x0000000000247805ULL, 0x002fc40000015200ULL, 0x0000001038277812ULL, 0x000fca00078ec0ffULL,
0x0000000126267824ULL, 0x000fc800078e0227ULL, 0x00000008372a7824ULL, 0x000fca00078e0226ULL,
0x01762c002a277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x006fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c002a277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008051247810ULL, 0x000fca0007ffe042ULL, 0x0000000143247824ULL, 0x000fca00078e0224ULL,
0x0170000024257984ULL, 0x000e680000000800ULL, 0x0172000024287984ULL, 0x0004e20000000800ULL,
0x0000004c2500720bULL, 0x002fe20003f1d000ULL, 0x000112727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x004fc800000e0100ULL, 0x0000ffff24ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff597224ULL, 0x000fd200078e004cULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x0000000100277811ULL, 0x000fe400078ff0ffULL, 0x0000004c2500720bULL, 0x000fe40003f14000ULL,
0x000000002700720cULL, 0x000fe20003fa5270ULL, 0x000112327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000297806ULL, 0x000fc400000e0100ULL, 0x000000800026d824ULL, 0x000fe200078e0251ULL,
0x0000004c25277209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x00000001432ad824ULL, 0x000fe200078e0226ULL, 0x0000991029267816ULL, 0x000fc800000000ffULL,
0x017400272a00d388ULL, 0x0003e20000000800ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000274c267221ULL, 0x002fe20000010000ULL,
0x000000ff29ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL, 0x00000026002e7308ULL, 0x000e640000000800ULL,
0x0000002e39397220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011632ULL, 0x000111727f007947ULL, 0x000fea000b800000ULL,
0x00001f262e267589ULL, 0x0002a400000e0000ULL, 0x000000260c0c7220ULL, 0x084fe40000410000ULL,
0x000000260d0d7220ULL, 0x080fe40000410000ULL, 0x0000002620207220ULL, 0x080fe40000410000ULL,
0x0000002621217220ULL, 0x080fe40000410000ULL, 0x0000002604047220ULL, 0x080fe40000410000ULL,
0x0000002605057220ULL, 0x000fc40000410000ULL, 0x000000261c1c7220ULL, 0x080fe40000410000ULL,
0x000000261d1d7220ULL, 0x080fe40000410000ULL, 0x0000002618187220ULL, 0x080fe40000410000ULL,
0x0000002619197220ULL, 0x080fe40000410000ULL, 0x0000002608087220ULL, 0x080fe40000410000ULL,
0x0000002609097220ULL, 0x000fc40000410000ULL, 0x0000002614147220ULL, 0x080fe40000410000ULL,
0x0000002615157220ULL, 0x080fe40000410000ULL, 0x0000002610107220ULL, 0x080fe40000410000ULL,
0x0000002611117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0029ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000832267811ULL, 0x000fe200078ff0ffULL, 0x000110827f007947ULL, 0x000fea000b800000ULL,
0x00001f262e267589ULL, 0x00046400000e0000ULL, 0x000000260e0e7220ULL, 0x082fe40000410000ULL,
0x000000260f0f7220ULL, 0x080fe40000410000ULL, 0x0000002622227220ULL, 0x080fe40000410000ULL,
0x0000002623237220ULL, 0x080fe40000410000ULL, 0x0000002606067220ULL, 0x080fe40000410000ULL,
0x0000002607077220ULL, 0x000fc40000410000ULL, 0x000000261e1e7220ULL, 0x080fe40000410000ULL,
0x000000261f1f7220ULL, 0x080fe40000410000ULL, 0x000000261a1a7220ULL, 0x080fe40000410000ULL,
0x000000261b1b7220ULL, 0x080fe40000410000ULL, 0x000000260a0a7220ULL, 0x080fe40000410000ULL,
0x000000260b0b7220ULL, 0x000fc40000410000ULL, 0x0000002616167220ULL, 0x080fe40000410000ULL,
0x0000002617177220ULL, 0x080fe40000410000ULL, 0x0000002612127220ULL, 0x080fe40000410000ULL,
0x0000002613137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff29ff7812ULL, 0x000fe20007800824ULL, 0x00000001ff297424ULL, 0x000fe200078e00ffULL,
0x0000004c25597209ULL, 0x000fd60007810000ULL, 0x8000005925250221ULL, 0x000fe20000010000ULL,
0x00007610ff290816ULL, 0x000fc60000000029ULL, 0x3fb8aa3b25250820ULL, 0x000fc80000410000ULL,
0x0000002500440308ULL, 0x000e640000000800ULL, 0x0000004428280220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003928397221ULL, 0x008fc40000010000ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x0000000841557824ULL, 0x000fc800078e00ffULL,
0x0000000138267824ULL, 0x000fca00078e0255ULL, 0x0176ac0026277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x00000001382a7824ULL, 0x000fc400078e0255ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176ac002a277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991029247816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000044ff24723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe40000011632ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x00010c327f007947ULL, 0x000fea000b800000ULL,
0x00001f2524457589ULL, 0x0002e400000e0000ULL, 0x0000000825267810ULL, 0x000fe20007ffe0ffULL,
0x00010c827f007947ULL, 0x000fea000b800000ULL, 0x00001f2624467589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001025267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00005ed0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0001173000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001825267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x004fe200078e0024ULL,
0x00005f40002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x000116c000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000148247824ULL, 0x042fe200078e0249ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000848257824ULL, 0x000fe400078e00ffULL,
0x0000000234697824ULL, 0x000fc600078e0241ULL, 0xfffffff825247812ULL, 0x000fe400078ee224ULL,
0x0001300069697811ULL, 0x000fca00078e60ffULL, 0x0000001024547824ULL, 0x100fe400078e0269ULL,
0x000000103a517824ULL, 0x100fe400078e0269ULL, 0x000000103b317824ULL, 0x100fe200078e0269ULL,
0x00000000544c783bULL, 0x000e620000004200ULL, 0x000000104a307824ULL, 0x000fc600078e0269ULL,
0x00000000512c783bULL, 0x004ea80000004200ULL, 0x000000003128783bULL, 0x000fe80000004200ULL,
0x000000003024783bULL, 0x000f220000004200ULL, 0x00000018ff587819ULL, 0x002fe2000001144cULL,
0x000001004c947824ULL, 0x000fe200078e00ffULL, 0x0000004c009d7306ULL, 0x000fe20000009400ULL,
0x00000018ff5f7819ULL, 0x000fe2000001144eULL, 0x000001004e9b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001144dULL, 0x000001002cd07824ULL, 0x004fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fc40000011494ULL, 0x00000018ffc77819ULL, 0x000fe2000001149bULL,
0x0000005800c07306ULL, 0x000fe20000209400ULL, 0x00000018ff617819ULL, 0x000fe4000001144fULL,
0x00000018ff977819ULL, 0x010fe40000011425ULL, 0x00000018ff9a7819ULL, 0x000fe40000011426ULL,
0x00000018ffd07819ULL, 0x000fe200000114d0ULL, 0x0000005800c17306ULL, 0x000fe20000205400ULL,
0x00000018ff627819ULL, 0x000fc4000001142fULL, 0x00000018ff6b7819ULL, 0x000fe40000011424ULL,
0x00000018ff6a7819ULL, 0x000fc60000011427ULL, 0x0000005800887306ULL, 0x0003f0000020d400ULL,
0x0000004c00ba7306ULL, 0x000ea20000005400ULL, 0x00000018ff587819ULL, 0x002fce000001142cULL,
0x0000005800b07306ULL, 0x000ff00000209400ULL, 0x0000005800af7306ULL, 0x000fe20000205400ULL,
0x000000ba9d00720bULL, 0x004fce0003fbd000ULL, 0x00000058007d7306ULL, 0x0003f0000020d400ULL,
0x00000094009f7306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x002fce0000011428ULL,
0x0000009400bc7306ULL, 0x000e700000205400ULL, 0x0000005800997306ULL, 0x000ff00000209400ULL,
0x0000005800967306ULL, 0x000fe20000205400ULL, 0x000000bc9f00720bULL, 0x002fce0003fdd000ULL,
0x00000058006e7306ULL, 0x000ff0000020d400ULL, 0x0000009700727306ULL, 0x000ff00000209400ULL,
0x0000009700737306ULL, 0x000ff00000205400ULL, 0x0000009700587306ULL, 0x0003f0000020d400ULL,
0x0000005f00b67306ULL, 0x000fe20000209400ULL, 0x000100004c977824ULL, 0x002fca00078e00ffULL,
0x00000018ff987819ULL, 0x000fe40000011497ULL, 0x0000005f00b57306ULL, 0x000ff00000205400ULL,
0x0000005f00827306ULL, 0x0003f0000020d400ULL, 0x0000004c008b7306ULL, 0x000ea2000000d400ULL,
0x00000018ff5f7819ULL, 0x002fce000001142eULL, 0x0000005f00a97306ULL, 0x000ff00000209400ULL,
0x0000005f00a87306ULL, 0x000fe20000205400ULL, 0x000000018b8b5812ULL, 0x004fe400078efcffULL,
0x000000c1c000720bULL, 0x000fca0003fbd000ULL, 0x0000005f00757306ULL, 0x0003f0000020d400ULL,
0x00000094004c7306ULL, 0x000ea2000020d400ULL, 0x00000018ff5f7819ULL, 0x002fe4000001142aULL,
0x0000000188885812ULL, 0x000fca00078efcffULL, 0x0000009800be7306ULL, 0x000ff00000209400ULL,
0x0000009800bf7306ULL, 0x000e620000205400ULL, 0x000000014c4c6812ULL, 0x004fce00078efcffULL,
0x0000005f00917306ULL, 0x000ff00000209400ULL, 0x0000005f008e7306ULL, 0x000fe20000205400ULL,
0x000000bfbe00720bULL, 0x002fce0003fdd000ULL, 0x0000005f006d7306ULL, 0x000ff0000020d400ULL,
0x0000009a00647306ULL, 0x000ff00000209400ULL, 0x0000009a005f7306ULL, 0x000ff00000205400ULL,
0x0000009a00687306ULL, 0x0003f0000020d400ULL, 0x0000009800977306ULL, 0x000522000020d400ULL,
0x000001004d9a7824ULL, 0x002fca00078e00ffULL, 0x00000018ffc27819ULL, 0x000fe4000001149aULL,
0x0000004d00a47306ULL, 0x000fe20000009400ULL, 0x000001004f987824ULL, 0x004fca00078e00ffULL,
0x00000018ffca7819ULL, 0x000fe40000011498ULL, 0x0000004d00bd7306ULL, 0x000e620000005400ULL,
0x0000000197976812ULL, 0x010fce00078efcffULL, 0x000000c200c37306ULL, 0x000ff00000209400ULL,
0x000000c200c47306ULL, 0x000ea20000205400ULL, 0x000000bda400720bULL, 0x002fce0003fbd000ULL,
0x0000004d00897306ULL, 0x000330000000d400ULL, 0x000000c2009a7306ULL, 0x000ee2000020d400ULL,
0x000100004d4d7824ULL, 0x002fe200078e00ffULL, 0x000000c4c300720bULL, 0x004fc80003fdd000ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000005a00ac7306ULL, 0x000fe20000209400ULL,
0x0000000189895812ULL, 0x010fce00078efcffULL, 0x0000005a00bb7306ULL, 0x000e620000205400ULL,
0x000000019a9a6812ULL, 0x008fce00078efcffULL, 0x0000004d00c57306ULL, 0x000ff00000209400ULL,
0x0000004d00c67306ULL, 0x000ea20000205400ULL, 0x000000bbac00720bULL, 0x002fe20003fbd000ULL,
0x000001002ebb7824ULL, 0x000fca00078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0000005a00877306ULL, 0x0002f0000020d400ULL, 0x0000004d00947306ULL, 0x000f22000020d400ULL,
0x000000c6c500720bULL, 0x004fc40003fdd000ULL, 0x00000018ff5a7819ULL, 0x002fca000001142dULL,
0x0000004e00b87306ULL, 0x000fe20000009400ULL, 0x0000000187875812ULL, 0x008fce00078efcffULL,
0x0000004e00b97306ULL, 0x000e620000005400ULL, 0x0000000194946812ULL, 0x010fce00078efcffULL,
0x000000c700c87306ULL, 0x000ff00000209400ULL, 0x000000c700c97306ULL, 0x000ea20000205400ULL,
0x000000b9b800720bULL, 0x002fe20003fbd000ULL, 0x000001002fb87824ULL, 0x000fca00078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe200000114b8ULL, 0x0000004e00867306ULL, 0x0002f0000000d400ULL,
0x000000c7009b7306ULL, 0x000922000020d400ULL, 0x000000c9c800720bULL, 0x004fe20003fdd000ULL,
0x000100004e4e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144eULL,
0x0000004f00b37306ULL, 0x000fe20000009400ULL, 0x0000000186865812ULL, 0x008fe200078efcffULL,
0x000100004f4e7824ULL, 0x000fca00078e00ffULL, 0x00000018ffc77819ULL, 0x010fe2000001144eULL,
0x0000004f00b27306ULL, 0x000e620000005400ULL, 0x000000019b9b6812ULL, 0x000fce00078efcffULL,
0x000000ca00cc7306ULL, 0x000ff00000209400ULL, 0x000000ca00cd7306ULL, 0x000ea20000205400ULL,
0x000000b2b300720bULL, 0x002fce0003fbd000ULL, 0x0000004f00857306ULL, 0x000e70000000d400ULL,
0x000000ca00987306ULL, 0x000ee2000020d400ULL, 0x000000cdcc00720bULL, 0x004fce0003fdd000ULL,
0x0000004d00c27306ULL, 0x000fe20000209400ULL, 0x0000000185855812ULL, 0x002fe400078efcffULL,
0x000000b5b600720bULL, 0x000fca0003fbd000ULL, 0x0000004d00cb7306ULL, 0x000e620000205400ULL,
0x0000000198986812ULL, 0x008fce00078efcffULL, 0x0000004d004f7306ULL, 0x0004e2000020d400ULL,
0x0000000182825812ULL, 0x000fce00078efcffULL, 0x0000006100b77306ULL, 0x000fe20000209400ULL,
0x000000cbc200720bULL, 0x002fe20003fdd000ULL, 0x000001002d4d7824ULL, 0x004fca00078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe2000001144dULL, 0x0000006100b47306ULL, 0x000e6c0000205400ULL,
0x000000014f4f6812ULL, 0x008fe400078efcffULL, 0x000000c700ce7306ULL, 0x000ff00000209400ULL,
0x000000c700cf7306ULL, 0x000ea20000205400ULL, 0x000000b4b700720bULL, 0x002fe20003fbd000ULL,
0x0000010028b47824ULL, 0x000fca00078e00ffULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0000006100817306ULL, 0x000e70000020d400ULL, 0x000000c7004e7306ULL, 0x000ee2000020d400ULL,
0x000000cfce00720bULL, 0x004fce0003fdd000ULL, 0x0000002c00ad7306ULL, 0x000fe20000009400ULL,
0x0000000181815812ULL, 0x002fce00078efcffULL, 0x0000002c00aa7306ULL, 0x000e620000005400ULL,
0x000000014e4e6812ULL, 0x008fce00078efcffULL, 0x000000d000ca7306ULL, 0x000ff00000209400ULL,
0x000000d000d17306ULL, 0x000ea20000205400ULL, 0x000000aaad00720bULL, 0x002fce0003fbd000ULL,
0x0000002c007e7306ULL, 0x0002f0000000d400ULL, 0x000000d0009f7306ULL, 0x000f22000020d400ULL,
0x000000d1ca00720bULL, 0x004fe20003fdd000ULL, 0x000100002c2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002d00ab7306ULL, 0x000fe20000009400ULL,
0x000000017e7e5812ULL, 0x008fce00078efcffULL, 0x0000002d00a67306ULL, 0x000e620000005400ULL,
0x000000019f9f6812ULL, 0x010fc800078efcffULL, 0x0000007e9f7e723eULL, 0x000fc600000010ffULL,
0x000000bc00d27306ULL, 0x000ff00000209400ULL, 0x000000bc00d37306ULL, 0x000ea20000205400ULL,
0x000000a6ab00720bULL, 0x002fce0003fbd000ULL, 0x0000002d007c7306ULL, 0x0002f0000000d400ULL,
0x000000bc009d7306ULL, 0x000f22000020d400ULL, 0x000000d3d200720bULL, 0x004fe20003fdd000ULL,
0x000100002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000002c004d7306ULL, 0x000fe20000209400ULL, 0x000000017c7c5812ULL, 0x008fe400078efcffULL,
0x000000afb000720bULL, 0x000fca0003fbd000ULL, 0x0000002c00ba7306ULL, 0x000e620000205400ULL,
0x000000019d9d6812ULL, 0x010fce00078efcffULL, 0x0000002c00a47306ULL, 0x000ea2000020d400ULL,
0x000000017d7d5812ULL, 0x000fce00078efcffULL, 0x0000005a00b17306ULL, 0x000fe20000209400ULL,
0x000000ba4d00720bULL, 0x002fce0003fdd000ULL, 0x0000005a00ae7306ULL, 0x000e6c0000205400ULL,
0x00000001a4a46812ULL, 0x004fe400078efcffULL, 0x0000002d00bc7306ULL, 0x000fe40000209400ULL,
0x000000a47da4723eULL, 0x000fcc00000010ffULL, 0x0000002d00bd7306ULL, 0x000ea20000205400ULL,
0x000000aeb100720bULL, 0x002fce0003fbd000ULL, 0x0000005a00797306ULL, 0x0002f0000020d400ULL,
0x0000002d00ac7306ULL, 0x000f22000020d400ULL, 0x000000bdbc00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff5a7819ULL, 0x002fca0000011429ULL, 0x0000002e00a57306ULL, 0x000fe20000009400ULL,
0x0000000179795812ULL, 0x008fce00078efcffULL, 0x0000002e00a07306ULL, 0x000e620000005400ULL,
0x00000001acac6812ULL, 0x010fce00078efcffULL, 0x000000bb002c7306ULL, 0x000ff00000209400ULL,
0x000000bb00bf7306ULL, 0x000ea20000205400ULL, 0x000000a0a500720bULL, 0x002fce0003fbd000ULL,
0x0000002e00787306ULL, 0x0002f0000000d400ULL, 0x000000bb00b97306ULL, 0x000f22000020d400ULL,
0x000000bf2c00720bULL, 0x004fe20003fdd000ULL, 0x000100002e2e7824ULL, 0x002fc400078e00ffULL,
0x000001002b2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000002f00a37306ULL, 0x000fe20000009400ULL, 0x0000000178785812ULL, 0x008fe400078efcffULL,
0x00000018ff2c7819ULL, 0x000fca000001142cULL, 0x0000002f009e7306ULL, 0x000e620000005400ULL,
0x00000001b9b96812ULL, 0x010fc800078efcffULL, 0x00000078b978723eULL, 0x000fc600000010ffULL,
0x000000be00c07306ULL, 0x000ff00000209400ULL, 0x000000be00c17306ULL, 0x000ea20000205400ULL,
0x0000009ea300720bULL, 0x002fce0003fbd000ULL, 0x0000002f00747306ULL, 0x0002f0000000d400ULL,
0x000000be00b37306ULL, 0x000f22000020d400ULL, 0x000000c1c000720bULL, 0x004fe20003fdd000ULL,
0x000100002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002e002d7306ULL, 0x000fe20000209400ULL, 0x0000000174745812ULL, 0x008fe400078efcffULL,
0x000000a8a900720bULL, 0x000fca0003fbd000ULL, 0x0000002e00b87306ULL, 0x000e620000205400ULL,
0x00000001b3b36812ULL, 0x010fce00078efcffULL, 0x0000002e00b67306ULL, 0x000ea2000020d400ULL,
0x0000000175755812ULL, 0x000fce00078efcffULL, 0x0000006200a77306ULL, 0x000fe20000209400ULL,
0x000000b82d00720bULL, 0x002fce0003fdd000ULL, 0x0000006200a27306ULL, 0x000e6c0000205400ULL,
0x00000001b6b66812ULL, 0x004fe400078efcffULL, 0x0000002f00b57306ULL, 0x000fe40000209400ULL,
0x000000b675b6723eULL, 0x000fcc00000010ffULL, 0x0000002f00be7306ULL, 0x000ea20000205400ULL,
0x000000a2a700720bULL, 0x002fce0003fbd000ULL, 0x0000006200717306ULL, 0x0002f0000020d400ULL,
0x0000002f00b27306ULL, 0x000922000020d400ULL, 0x000000beb500720bULL, 0x004fe40003fdd000ULL,
0x00000018ff627819ULL, 0x002fca000001142bULL, 0x00000028009c7306ULL, 0x000fe20000009400ULL,
0x0000000171715812ULL, 0x008fe200078efcffULL, 0x00000100292f7824ULL, 0x010fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002800a17306ULL, 0x000e620000005400ULL,
0x00000001b2b26812ULL, 0x000fce00078efcffULL, 0x000000b4002e7306ULL, 0x000ff00000209400ULL,
0x000000b400b77306ULL, 0x000ea20000205400ULL, 0x000000a19c00720bULL, 0x002fce0003fbd000ULL,
0x0000002800707306ULL, 0x0002f0000000d400ULL, 0x000000b400ad7306ULL, 0x000f22000020d400ULL,
0x0001000028287824ULL, 0x002fe200078e00ffULL, 0x000000b72e00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002900937306ULL, 0x000fe20000009400ULL,
0x0000000170705812ULL, 0x008fe400078efcffULL, 0x000000969900720bULL, 0x000fca0003fbd000ULL,
0x0000002800bb7306ULL, 0x000fe20000209400ULL, 0x00000001adad6812ULL, 0x010fc800078efcffULL,
0x00000070ad70723eULL, 0x000fc600000010ffULL, 0x0000002800c27306ULL, 0x000e620000205400ULL,
0x000000016e6e5812ULL, 0x000fce00078efcffULL, 0x0000002800ab7306ULL, 0x0004f0000020d400ULL,
0x0000002900907306ULL, 0x000f220000005400ULL, 0x000001002a287824ULL, 0x004fe200078e00ffULL,
0x000000c2bb00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000029005d7306ULL, 0x0002ae000000d400ULL, 0x00000001abab6812ULL, 0x008fe200078efcffULL,
0x0000002a008f7306ULL, 0x000fe20000009400ULL, 0x0001000029297824ULL, 0x002fe200078e00ffULL,
0x000000909300720bULL, 0x010fc40003fbd000ULL, 0x000000ab6e6e723eULL, 0x000fe400000010ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a008c7306ULL, 0x000fee0000005400ULL,
0x000000015d5d5812ULL, 0x004fe200078efcffULL, 0x0000002a00677306ULL, 0x0003f0000000d400ULL,
0x0000002b008d7306ULL, 0x000fe20000009400ULL, 0x000100002a2a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002b008a7306ULL, 0x000ff00000005400ULL,
0x0000002b00667306ULL, 0x0003f0000000d400ULL, 0x0000002800ae7306ULL, 0x000fe20000209400ULL,
0x000100002b2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ffa87819ULL, 0x000fe4000001142bULL,
0x0000002800af7306ULL, 0x000ff00000205400ULL, 0x0000002800a07306ULL, 0x0003f0000020d400ULL,
0x0000002f00b47306ULL, 0x000fe20000209400ULL, 0x0000010024287824ULL, 0x002fca00078e00ffULL,
0x00000018ffa77819ULL, 0x000fe40000011428ULL, 0x0000002f00c37306ULL, 0x000e700000205400ULL,
0x0000002f00a67306ULL, 0x000eb0000020d400ULL, 0x00000029004d7306ULL, 0x000fe20000209400ULL,
0x000000c3b400720bULL, 0x002fce0003fdd000ULL, 0x0000002900b07306ULL, 0x000e6c0000205400ULL,
0x00000001a6a66812ULL, 0x004fe400078efcffULL, 0x0000002900aa7306ULL, 0x000eb0000020d400ULL,
0x0000002c00b17306ULL, 0x000fe20000209400ULL, 0x000000b04d00720bULL, 0x002fce0003fbd000ULL,
0x0000002c00ba7306ULL, 0x000fec0000205400ULL, 0x00000001aaaa5812ULL, 0x004fe400078efcffULL,
0x0000002c00a37306ULL, 0x0003e2000020d400ULL, 0x0000008c8f00720bULL, 0x000fce0003fbd000ULL,
0x0000002a00a57306ULL, 0x000fe20000209400ULL, 0x01180000472c783bULL, 0x002e6a0000000200ULL,
0x0000000167675812ULL, 0x000fe400078efcffULL, 0x0000002a00b87306ULL, 0x000eb00000205400ULL,
0x0000002a009e7306ULL, 0x000730000020d400ULL, 0x0000005a00957306ULL, 0x000fe20000209400ULL,
0x011800004b28783bULL, 0x008ee20000000200ULL, 0x000000b8a500720bULL, 0x004fc40003fbd000ULL,
0x000000ac79a5723eULL, 0x000fe400000010ffULL, 0x00000074b379723eULL, 0x000fe400000010ffULL,
0x0000005a00927306ULL, 0x000eae0000205400ULL, 0x000000019e9e5812ULL, 0x010fe200078efcffULL,
0x0000005a00617306ULL, 0x000f22000020d400ULL, 0x000000452c2c8231ULL, 0x002fc400003400ffULL,
0x000000452e2e8231ULL, 0x080fe400003400ffULL, 0x000000462d2d8231ULL, 0x080fe400003400ffULL,
0x000000462f2f8231ULL, 0x000fe200003400ffULL, 0x000000929500720bULL, 0x004fe20003fdd000ULL,
0x0000006200847306ULL, 0x000fea0000209400ULL, 0x000000a42c08723cULL, 0x040fe60000041808ULL,
0x0000006200837306ULL, 0x000e680000205400ULL, 0x0000000161616812ULL, 0x010fe200078efcffULL,
0x000000782c14723cULL, 0x000fe20000041814ULL, 0x000000bab100720bULL, 0x000fe20003fdd000ULL,
0x0000004528288231ULL, 0x088fe200003400ffULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x000000452a2a8231ULL, 0x000fc400003400ffULL, 0x0000004629298231ULL, 0x080fe400003400ffULL,
0x000000462b2b8231ULL, 0x000fe200003400ffULL, 0x000000afae00720bULL, 0x000fe40003f1d000ULL,
0x000000a800bc7306ULL, 0x000ea20000205400ULL, 0x000000838400720bULL, 0x002fe40003fbd000ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x0000008e9100720bULL, 0x000fc60003fdd000ULL,
0x000000a7009c7306ULL, 0x000fe60000209400ULL, 0x00000001a0a00812ULL, 0x000fe400078efcffULL,
0x0000008a8d00720bULL, 0x000fc60003f1d000ULL, 0x000000a700b57306ULL, 0x000e640000205400ULL,
0x000000016d6d6812ULL, 0x000fc800078efcffULL, 0x0000009e6d9e723eULL, 0x000fe400000010ffULL,
0x000000a800a27306ULL, 0x000724000020d400ULL, 0x0000000166660812ULL, 0x000fe400078efcffULL,
0x000000bca900720bULL, 0x004fc80003f1d000ULL, 0x0000006200637306ULL, 0x000ea2000020d400ULL,
0x0000010025a87824ULL, 0x008fe200078e00ffULL, 0x000000b59c00720bULL, 0x002fc80003fdd000ULL,
0x00000018ffa87819ULL, 0x000fe400000114a8ULL, 0x000000a700a17306ULL, 0x000e62000020d400ULL,
0x00000001a2a20812ULL, 0x010fce00078efcffULL, 0x0000002400807306ULL, 0x000fe20000009400ULL,
0x0000000163635812ULL, 0x004fc800078efcffULL, 0x000000a2639f723eULL, 0x000fc600000010ffULL,
0x00000024007f7306ULL, 0x000ea20000005400ULL, 0x00000001a1a16812ULL, 0x002fce00078efcffULL,
0x00000025007b7306ULL, 0x000ff00000009400ULL, 0x00000025007a7306ULL, 0x000e620000005400ULL,
0x0000007f8000720bULL, 0x004fe40003f1d000ULL, 0x0000007c9d7f723eULL, 0x000fca00000010ffULL,
0x000000a800b77306ULL, 0x000fe40000209400ULL, 0x0000007e2c18723cULL, 0x000f6c0000041818ULL,
0x000000a800be7306ULL, 0x000ea20000205400ULL, 0x0000007a7b00720bULL, 0x002fce0003fbd000ULL,
0x00000025005b7306ULL, 0x0002f0000000d400ULL, 0x00000024005c7306ULL, 0x0008e2000000d400ULL,
0x0001000025257824ULL, 0x002fe200078e00ffULL, 0x000000beb700720bULL, 0x004fc40003fdd000ULL,
0x000000b271b7723eULL, 0x000fe400000010ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011425ULL,
0x0000010026257824ULL, 0x000fe200078e00ffULL, 0x000000a800967306ULL, 0x000e62000020d400ULL,
0x0001000024247824ULL, 0x010fe200078e00ffULL, 0x000000015b5b5812ULL, 0x008fe200078efcffULL,
0x000000b62c10723cULL, 0x000fe20000041810ULL, 0x00000018ff8a7819ULL, 0x000fe40000011425ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000006b00767306ULL, 0x000fe20000209400ULL,
0x000000899a25723eULL, 0x000fe400000010ffULL, 0x000000015c5c0812ULL, 0x000fe400078efcffULL,
0x0000005da671723eULL, 0x000fe400000010ffULL, 0x0000005ca15c723eULL, 0x000fe200000010ffULL,
0x0000006b00777306ULL, 0x000ea20000205400ULL, 0x0000000196966812ULL, 0x002fc800078efcffULL,
0x0000005b965d723eULL, 0x000fc600000010ffULL, 0x0000002400907306ULL, 0x000fe80000209400ULL,
0x0000005c2818723cULL, 0x020fe80000041818ULL, 0x0000002400997306ULL, 0x000e620000205400ULL,
0x000000777600720bULL, 0x004fce0003fdd000ULL, 0x0000002400937306ULL, 0x0004f0000020d400ULL,
0x0000004d00927306ULL, 0x000fe20000209400ULL, 0x0000008b4c24723eULL, 0x004fe400000010ffULL,
0x00000097884c723eULL, 0x000fc400000010ffULL, 0x000000999000720bULL, 0x002fc60003f1d000ULL,
0x0000004d00957306ULL, 0x000e620000205400ULL, 0x000000242c0c723cULL, 0x000b6e000004180cULL,
0x0000004d008f7306ULL, 0x0005e2000020d400ULL, 0x000000869b24723eULL, 0x020fe400000010ffULL,
0x000000859825723eULL, 0x000fc400000010ffULL, 0x0000000193930812ULL, 0x008fe400078efcffULL,
0x000000737200720bULL, 0x000fe20003f1d000ULL, 0x0000006b005a7306ULL, 0x000ee2000020d400ULL,
0x00000094874d723eULL, 0x004fe200000010ffULL, 0x000000242c04723cULL, 0x000fe20000041804ULL,
0x000000959200720bULL, 0x002fca0003fbd000ULL, 0x00000026005e7306ULL, 0x000fe40000009400ULL,
0x0000004c2c20723cULL, 0x000b640000041820ULL, 0x0000000158580812ULL, 0x000fc800078efcffULL,
0x00000026006f7306ULL, 0x000e620000005400ULL, 0x00000100274d7824ULL, 0x020fe200078e00ffULL,
0x0000004f824c723eULL, 0x000fe200000010ffULL, 0x00000070280c723cULL, 0x000fe2000004180cULL,
0x000000015a5a6812ULL, 0x008fe400078efcffULL, 0x00000018ff247819ULL, 0x000fe4000001144dULL,
0x0000008a00897306ULL, 0x000fe20000209400ULL, 0x0000004e814d723eULL, 0x000fe400000010ffULL,
0x000000018f8f5812ULL, 0x000fc400078efcffULL, 0x000000935a5a723eULL, 0x000fe400000010ffULL,
0x0000008f585b723eULL, 0x000fe200000010ffULL, 0x0000008a00887306ULL, 0x000ea20000205400ULL,
0x0000004c2c1c723cULL, 0x000f62000004181cULL, 0x0000006f5e00720bULL, 0x002fe40003fdd000ULL,
0x000000aa616f723eULL, 0x000fc800000010ffULL, 0x0000002600567306ULL, 0x0002e2000000d400ULL,
0x0000005a2808723cULL, 0x040f6e0000041808ULL, 0x0000002400257306ULL, 0x000fe20000209400ULL,
0x0001000026267824ULL, 0x002fe200078e00ffULL, 0x000000888900720bULL, 0x004fe20003fbd000ULL,
0x0000006e2820723cULL, 0x000f660000041820ULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x00000024004e7306ULL, 0x000e620000205400ULL, 0x0000000156566812ULL, 0x008fe400078efcffULL,
0x0000009e281c723cULL, 0x020f6a000004181cULL, 0x00000024004d7306ULL, 0x0004f0000020d400ULL,
0x0000002700657306ULL, 0x000fe20000009400ULL, 0x0001000027247824ULL, 0x004fe200078e00ffULL,
0x0000004e2500720bULL, 0x002fc40003f1d000ULL, 0x00000066a325723eULL, 0x000fe400000010ffULL,
0x00000018ff2c7819ULL, 0x000fe40000011424ULL, 0x00000027006c7306ULL, 0x000fe20000005400ULL,
0x00000067a024723eULL, 0x000fcc00000010ffULL, 0x000000014d4d0812ULL, 0x008fe200078efcffULL,
0x0000002700607306ULL, 0x000fe2000000d400ULL, 0x0000005f6400720bULL, 0x000fe20003f1d000ULL,
0x000000242804723cULL, 0x000b6c0000041804ULL, 0x0000008a00837306ULL, 0x000e6c000020d400ULL,
0x0000000168680812ULL, 0x000fc400078efcffULL, 0x00000026004c7306ULL, 0x000ff00000209400ULL,
0x0000002600277306ULL, 0x000ea20000205400ULL, 0x0000000183835812ULL, 0x002fe400078efcffULL,
0x0000006c6500720bULL, 0x000fc40003fbd000ULL, 0x000000568324723eULL, 0x020fc600000010ffULL,
0x00000026002d7306ULL, 0x000e70000020d400ULL, 0x0000006a00627306ULL, 0x000fe20000209400ULL,
0x000000274c00720bULL, 0x004fe40003fdd000ULL, 0x0000000160605812ULL, 0x000fc800078efcffULL,
0x000000604d25723eULL, 0x000fe200000010ffULL, 0x0000006a006b7306ULL, 0x000eac0000205400ULL,
0x000000012d2d6812ULL, 0x002fe200078efcffULL, 0x000000242814723cULL, 0x000b620000041814ULL,
0x0000002c002e7306ULL, 0x000fe40000209400ULL, 0x0000002d6826723eULL, 0x000fcc00000010ffULL,
0x0000002c002f7306ULL, 0x000e620000205400ULL, 0x0000006b6200720bULL, 0x004fce0003fbd000ULL,
0x0000006a006a7306ULL, 0x000eb0000020d400ULL, 0x0000002c00277306ULL, 0x000ee2000020d400ULL,
0x0000002f2e00720bULL, 0x002fe40003fdd000ULL, 0x000000016a6a5812ULL, 0x004fd600078efcffULL,
0x0000000127276812ULL, 0x008fc800078efcffULL, 0x000000276a27723eULL, 0x000fce00000010ffULL,
0x000000262810723cULL, 0x000b620000041810ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000003e247f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000803c277811ULL, 0x000fe200078e40ffULL,
0x0176900050ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff2a7224ULL, 0x004fe200078e0025ULL,
0x000000013d257812ULL, 0x000fe400078ec0ffULL, 0x000000022700720cULL, 0x000fda0003f06070ULL,
0x0000693000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x008fc40000015200ULL,
0x000004003e277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003e277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000013c247810ULL, 0x000fe40007ffe0ffULL, 0x000000c03f257810ULL, 0x000fe40007ffe0ffULL,
0x000000032400720cULL, 0x000fc60003f06070ULL, 0x00006200362c7a24ULL, 0x000fd400078e0225ULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x0000002502247217ULL, 0x000fe20007800000ULL,
0x0000001037297824ULL, 0x000fe200078e00ffULL, 0x00000003ff287819ULL, 0x000fe20000011632ULL,
0x0000001032267824ULL, 0x000fe400078e00ffULL, 0x0000000124247824ULL, 0x000fe200078e0a25ULL,
0x00000004282b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129277824ULL, 0x040fe200078e0228ULL,
0x00000070264f7812ULL, 0x000fe200078ec0ffULL, 0x00000080ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000002429247217ULL, 0x000fe20007800000ULL, 0x0000000127257824ULL, 0x000fc400078e022cULL,
0x0000000127267824ULL, 0x040fe400078e0232ULL, 0x00000008272d7824ULL, 0x000fe400078e00ffULL,
0x00000001242a7824ULL, 0x000fe400078e0a29ULL, 0x0000000129277824ULL, 0x000fe200078e022bULL,
0xfffffff82d2e7812ULL, 0x000fe200078ee226ULL, 0x00005e0025247625ULL, 0x000fe200078e002fULL,
0x0000002a2800720cULL, 0x080fe40003fa6070ULL, 0x0000002a2b00720cULL, 0x000fe20003f06070ULL,
0x00000001272d7824ULL, 0x040fe200078e0232ULL, 0x0000004f24267210ULL, 0x000fe20007fde0ffULL,
0x00000008274c7824ULL, 0x000fc400078e00ffULL, 0x0000000127247824ULL, 0x000fe400078e022cULL,
0x000000102e2b7824ULL, 0x000fe200078e0269ULL, 0xfffffff84c2e7812ULL, 0x000fe200078ee22dULL,
0x000000ffff277224ULL, 0x000fe200030e0625ULL, 0x00000008282d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000000c284c7810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0005e2000e901c46ULL,
0x00000001294d7824ULL, 0x040fe200078e022dULL, 0x0000004f24287210ULL, 0x000fe20007fde0ffULL,
0x00000001295b7824ULL, 0x000fe200078e024cULL, 0x0000002a2d00720cULL, 0x000fe20003fa6070ULL,
0x000000014d247824ULL, 0x000fc400078e022cULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x0000002a4c00720cULL, 0x000fe20003fc6070ULL, 0x000000102e2d7824ULL, 0x000fe400078e0269ULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0x00000000282d7faeULL, 0x0007e2000c101c46ULL,
0x000000015b2a7824ULL, 0x000fe200078e022cULL, 0x0000004f24247210ULL, 0x000fe20007f1e0ffULL,
0x000000014d2b7824ULL, 0x144fe400078e0232ULL, 0x000000084d2e7824ULL, 0x000fe400078e00ffULL,
0x000000015b2c7824ULL, 0x000fe400078e0232ULL, 0x00005e002a267625ULL, 0x000fe200078e002fULL,
0xfffffff82e2a7812ULL, 0x000fc600078ee22bULL, 0x000000085b5b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000004f26267210ULL, 0x000fe20007f1e0ffULL,
0x000000102a297824ULL, 0x008fe200078e0269ULL, 0xfffffff85b2c7812ULL, 0x000fc600078ee22cULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x0000000024297faeULL, 0x0005e2000e901c46ULL,
0x000000102c697824ULL, 0x000fca00078e0269ULL, 0x0000000026697faeULL, 0x0005e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x0000001037257824ULL, 0x000fe400078e00ffULL,
0x00000010324f7824ULL, 0x040fe400078e00ffULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x0000002532257211ULL, 0x000fe400078fe8ffULL, 0x000000704f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000008252d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000125247824ULL, 0x040fe200078e0232ULL,
0x0000000c254d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fc400078e00ffULL,
0x000000012d2f7824ULL, 0x000fe400078e0232ULL, 0x000000014d287824ULL, 0x000fe200078e022cULL,
0xfffffff8272e7812ULL, 0x000fe200078ee224ULL, 0x0000000125247824ULL, 0x040fe200078e022cULL,
0x0000000425277810ULL, 0x000fe20007ffe0ffULL, 0x000000082d4e7824ULL, 0x000fe400078e00ffULL,
0x00005e0024247625ULL, 0x000fc800078e0029ULL, 0x00000001272b7824ULL, 0x040fe200078e0232ULL,
0x0000004f242a7210ULL, 0x000fe20007f1e0ffULL, 0x00000008274c7824ULL, 0x040fe400078e00ffULL,
0x0000000127267824ULL, 0x100fe400078e022cULL, 0x000000012d277824ULL, 0x000fe200078e022cULL,
0xfffffff84c2c7812ULL, 0x000fe200078ee22bULL, 0x000000ffff2b7224ULL, 0x000fe200000e0625ULL,
0xfffffff84e4c7812ULL, 0x000fe200078ee22fULL, 0x00005e0026247625ULL, 0x000fc800078e0029ULL,
0x00005e0027267625ULL, 0x000fe200078e0029ULL, 0x0000004f24247210ULL, 0x000fc60007f1e0ffULL,
0x000000014d2d7824ULL, 0x040fe200078e0232ULL, 0x0000004f26267210ULL, 0x000fe20007fbe0ffULL,
0x000000084d567824ULL, 0x000fe400078e00ffULL, 0x00005e0028287625ULL, 0x000fc600078e0029ULL,
0xfffffff8564e7812ULL, 0x000fe200078ee22dULL, 0x000000102e2d7824ULL, 0x100fe200078e0269ULL,
0x0000004f28287210ULL, 0x000fe20007fde0ffULL, 0x000000102c2f7824ULL, 0x000fe400078e0269ULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2d7faeULL, 0x0005e2000b901c46ULL, 0x000000104c4d7824ULL, 0x000fe400078e0269ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x00000000242f7faeULL, 0x0005e2000b901c46ULL,
0x000000104e697824ULL, 0x000fc400078e0269ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x00000000264d7faeULL, 0x0005e8000b901c46ULL, 0x0000000028697faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0xfffffff033267812ULL, 0x040fe200078ec0ffULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0xffffffe033257812ULL, 0x040fe400078ec0ffULL,
0x00000010332a7812ULL, 0x000fe200078ec0ffULL, 0x0000000841267824ULL, 0x000fe200078e0226ULL,
0x0000000833247812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x00000025242a7210ULL, 0x000fd60007ffe02aULL, 0x00000000400403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a800265a7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017648002a287f8cULL, 0x0002a4000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x01764c002a277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x014fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01764c002a277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001004f247810ULL, 0x000fca0007ffe042ULL, 0x0000000143247824ULL, 0x000fca00078e0224ULL,
0x0170000024287984ULL, 0x000ea80000000800ULL, 0x0172000024257984ULL, 0x0002e20000000800ULL,
0x000000592800720bULL, 0x004fe20003f1d000ULL, 0x0000dfe27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x002fc800000e0100ULL, 0x0000ffff24ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff407224ULL, 0x000fd200078e0059ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000200277811ULL, 0x000fe400078ff0ffULL, 0x000000592800720bULL, 0x000fe40003f14000ULL,
0x000000002700720cULL, 0x000fe20003fa5270ULL, 0x0000dfa27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000297806ULL, 0x000fc400000e0100ULL, 0x00000080002ad824ULL, 0x000fe200078e024fULL,
0x000000285926d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991029277816ULL, 0x000fe200000000ffULL, 0x00000001432bd824ULL, 0x000fc600078e022aULL,
0x000000ff2700720cULL, 0x000fe40003f05270ULL, 0x017400262b00d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000002859267209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff29ff7812ULL, 0x000fc6000780c0ffULL,
0x8000002659267221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL,
0x00000026002e7308ULL, 0x000e640000000800ULL, 0x0000002e39397220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011632ULL,
0x0000ded27f007947ULL, 0x000fea000b800000ULL, 0x00001f262e267589ULL, 0x0002a400000e0000ULL,
0x000000260c0c7220ULL, 0x084fe40000410000ULL, 0x000000260d0d7220ULL, 0x080fe40000410000ULL,
0x0000002620207220ULL, 0x080fe40000410000ULL, 0x0000002621217220ULL, 0x000fc40000410000ULL,
0x0000002604047220ULL, 0x080fe40000410000ULL, 0x0000002605057220ULL, 0x080fe40000410000ULL,
0x000000261c1c7220ULL, 0x080fe40000410000ULL, 0x000000261d1d7220ULL, 0x080fe40000410000ULL,
0x0000002618187220ULL, 0x080fe40000410000ULL, 0x0000002619197220ULL, 0x000fc40000410000ULL,
0x0000002608087220ULL, 0x080fe40000410000ULL, 0x0000002609097220ULL, 0x080fe40000410000ULL,
0x0000002614147220ULL, 0x080fe40000410000ULL, 0x0000002615157220ULL, 0x080fe40000410000ULL,
0x0000002610107220ULL, 0x080fe40000410000ULL, 0x0000002611117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0029ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000832267811ULL, 0x000fe200078ff0ffULL,
0x0000dde27f007947ULL, 0x000fea000b800000ULL, 0x00001f262e267589ULL, 0x00046400000e0000ULL,
0x000000260e0e7220ULL, 0x082fe40000410000ULL, 0x000000260f0f7220ULL, 0x080fe40000410000ULL,
0x0000002622227220ULL, 0x080fe40000410000ULL, 0x0000002623237220ULL, 0x080fe40000410000ULL,
0x0000002606067220ULL, 0x080fe40000410000ULL, 0x0000002607077220ULL, 0x000fc40000410000ULL,
0x000000261e1e7220ULL, 0x080fe40000410000ULL, 0x000000261f1f7220ULL, 0x080fe40000410000ULL,
0x000000261a1a7220ULL, 0x080fe40000410000ULL, 0x000000261b1b7220ULL, 0x080fe40000410000ULL,
0x000000260a0a7220ULL, 0x080fe40000410000ULL, 0x000000260b0b7220ULL, 0x000fc40000410000ULL,
0x0000002616167220ULL, 0x080fe40000410000ULL, 0x0000002617177220ULL, 0x080fe40000410000ULL,
0x0000002612127220ULL, 0x080fe40000410000ULL, 0x0000002613137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff29ff7812ULL, 0x000fe20007800824ULL,
0x00000001ff297424ULL, 0x000fe200078e00ffULL, 0x0000002859407209ULL, 0x000fd60007810000ULL,
0x8000004028280221ULL, 0x000fe20000010000ULL, 0x00007610ff290816ULL, 0x000fc60000000029ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800440308ULL, 0x000e640000000800ULL,
0x0000004425250220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003925397221ULL, 0x008fc40000010000ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x0176ac0052267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804857ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0052267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991029247816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000044ff24723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe40000011632ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x0000d9e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2524457589ULL, 0x0002e400000e0000ULL, 0x0000000825267810ULL, 0x000fe20007ffe0ffULL,
0x0000da327f007947ULL, 0x000fea000b800000ULL, 0x00001f2624467589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001025267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x000093b0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0000e25000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001825267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x004fe200078e0024ULL,
0x00009420002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x0000e1e000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000010003d247824ULL, 0x002fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000148497824ULL, 0x040fe400078e0249ULL,
0x0000000848287824ULL, 0x000fe200078e00ffULL, 0x0000100024257812ULL, 0x000fc800078ec0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee249ULL, 0x0000200034257824ULL, 0x000fca00078e0225ULL,
0x0001300025497810ULL, 0x000fca0007ffe0ffULL, 0x0000001028287824ULL, 0x100fe400078e0249ULL,
0x000000103a2c7824ULL, 0x100fe400078e0249ULL, 0x000000103b4c7824ULL, 0x100fe400078e0249ULL,
0x000000002828783bULL, 0x004e620000004200ULL, 0x000000104a247824ULL, 0x000fc600078e0249ULL,
0x000000002c2c783bULL, 0x000ea80000004200ULL, 0x000000004c4c783bULL, 0x000f280000004200ULL,
0x000000002424783bULL, 0x000ee20000004200ULL, 0x00000100288f7824ULL, 0x002fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011429ULL, 0x00000028009a7306ULL, 0x000fe20000009400ULL,
0x00000018ff5c7819ULL, 0x000fe2000001142aULL, 0x000001002b997824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x000001002ccb7824ULL, 0x004fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fc40000011428ULL, 0x00000018ff5f7819ULL, 0x010fe2000001144eULL,
0x0000002800a97306ULL, 0x000e620000005400ULL, 0x00000018ffc67819ULL, 0x000fe40000011499ULL,
0x00000018ff927819ULL, 0x008fe40000011425ULL, 0x00000018ff947819ULL, 0x000fe40000011426ULL,
0x00000018ff5d7819ULL, 0x000fe2000001142bULL, 0x0000005900c27306ULL, 0x000fe20000209400ULL,
0x00000018ffcb7819ULL, 0x000fc400000114cbULL, 0x00000018ff667819ULL, 0x000fe40000011424ULL,
0x00000018ff677819ULL, 0x000fc60000011427ULL, 0x0000005900c37306ULL, 0x000fe20000205400ULL,
0x000000a99a00720bULL, 0x002fce0003fbd000ULL, 0x00000059003b7306ULL, 0x0003f0000020d400ULL,
0x0000008f009e7306ULL, 0x000fe20000209400ULL, 0x00000018ff597819ULL, 0x002fce000001142dULL,
0x0000008f00ad7306ULL, 0x000e700000205400ULL, 0x0000002800857306ULL, 0x0004f0000000d400ULL,
0x0000005c00b27306ULL, 0x000fe20000209400ULL, 0x0001000028287824ULL, 0x004fe200078e00ffULL,
0x000000ad9e00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000005c00b37306ULL, 0x000fe20000205400ULL, 0x0000000185855812ULL, 0x008fce00078efcffULL,
0x0000005c007f7306ULL, 0x0003f0000020d400ULL, 0x0000005900ae7306ULL, 0x000fe20000209400ULL,
0x00000018ff5c7819ULL, 0x002fce000001142eULL, 0x0000005900ab7306ULL, 0x000ff00000205400ULL,
0x0000005900767306ULL, 0x0003f0000020d400ULL, 0x0000005600ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff597819ULL, 0x002fce000001144dULL, 0x0000005600bb7306ULL, 0x000e700000205400ULL,
0x00000056003a7306ULL, 0x0004f0000020d400ULL, 0x0000005c00a87306ULL, 0x000fe20000209400ULL,
0x00000018ff567819ULL, 0x004fc4000001142cULL, 0x000000bbba00720bULL, 0x002fe20003fbd000ULL,
0x000001002eba7824ULL, 0x000fc800078e00ffULL, 0x0000005c00a77306ULL, 0x000fe20000205400ULL,
0x00000018ffba7819ULL, 0x000fce00000114baULL, 0x0000005c00727306ULL, 0x000fe2000020d400ULL,
0x000000013a3a5812ULL, 0x008fce00078efcffULL, 0x0000005600af7306ULL, 0x000ff00000209400ULL,
0x0000005600ac7306ULL, 0x000ff00000205400ULL, 0x00000056007a7306ULL, 0x0003f0000020d400ULL,
0x0000005900917306ULL, 0x000fe20000209400ULL, 0x00000018ff567819ULL, 0x002fce000001144cULL,
0x00000059008e7306ULL, 0x000ff00000205400ULL, 0x00000059005c7306ULL, 0x000ff0000020d400ULL,
0x00000092006e7306ULL, 0x000ff00000209400ULL, 0x00000092006d7306ULL, 0x000ff00000205400ULL,
0x0000009200597306ULL, 0x000ff0000020d400ULL, 0x0000008f00927306ULL, 0x0002b0000020d400ULL,
0x0000002800b87306ULL, 0x000fe20000209400ULL, 0x000001002a8f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001148fULL, 0x0000002800b97306ULL, 0x000e620000205400ULL,
0x0000000192926812ULL, 0x004fce00078efcffULL, 0x0000005600937306ULL, 0x000ff00000209400ULL,
0x0000005600907306ULL, 0x000fe20000205400ULL, 0x000000b9b800720bULL, 0x002fce0003fdd000ULL,
0x00000056006c7306ULL, 0x000ff0000020d400ULL, 0x0000005f008d7306ULL, 0x000ff00000209400ULL,
0x0000005f008c7306ULL, 0x000ff00000205400ULL, 0x0000005f00697306ULL, 0x000ff0000020d400ULL,
0x00000094005f7306ULL, 0x000ff00000209400ULL, 0x0000009400567306ULL, 0x000ff00000205400ULL,
0x0000009400647306ULL, 0x0003f0000020d400ULL, 0x0000002800957306ULL, 0x000ea2000020d400ULL,
0x0000010029947824ULL, 0x002fca00078e00ffULL, 0x00000018ff967819ULL, 0x000fe40000011494ULL,
0x0000002900bc7306ULL, 0x000ff00000009400ULL, 0x0000002900bd7306ULL, 0x000e620000005400ULL,
0x0000000195956812ULL, 0x004fc800078efcffULL, 0x000000953a3a723eULL, 0x000fc600000010ffULL,
0x0000009600be7306ULL, 0x000ff00000209400ULL, 0x0000009600bf7306ULL, 0x000ea20000205400ULL,
0x000000bdbc00720bULL, 0x002fce0003fbd000ULL, 0x0000002900847306ULL, 0x0002f0000000d400ULL,
0x00000096009b7306ULL, 0x000f22000020d400ULL, 0x0001000029297824ULL, 0x002fe200078e00ffULL,
0x000000bfbe00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00b77306ULL, 0x000fe20000009400ULL, 0x0000000184845812ULL, 0x008fe400078efcffULL,
0x000000c3c200720bULL, 0x000fca0003fbd000ULL, 0x0000002900c07306ULL, 0x000fe20000209400ULL,
0x000000019b9b6812ULL, 0x010fce00078efcffULL, 0x0000002900c17306ULL, 0x000e620000205400ULL,
0x000000013b3b5812ULL, 0x000fce00078efcffULL, 0x0000002900947306ULL, 0x000eb0000020d400ULL,
0x0000002a00b67306ULL, 0x000ee20000005400ULL, 0x000000c1c000720bULL, 0x002fce0003fdd000ULL,
0x0000008f00287306ULL, 0x000fec0000209400ULL, 0x0000000194946812ULL, 0x004fe400078efcffULL,
0x0000008f00c57306ULL, 0x000e620000205400ULL, 0x000000b6b700720bULL, 0x008fe40003fbd000ULL,
0x000000943b3b723eULL, 0x000fca00000010ffULL, 0x0000002a00837306ULL, 0x0004f0000000d400ULL,
0x0000008f00987306ULL, 0x000f22000020d400ULL, 0x000000c52800720bULL, 0x002fe20003fdd000ULL,
0x000100002a2a7824ULL, 0x004fc400078e00ffULL, 0x000001002f287824ULL, 0x000fc600078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000002b00b47306ULL, 0x000fe20000009400ULL,
0x0000000183835812ULL, 0x008fe400078efcffULL, 0x00000018ffb77819ULL, 0x000fca0000011428ULL,
0x0000002b00b57306ULL, 0x000e620000005400ULL, 0x0000000198986812ULL, 0x010fce00078efcffULL,
0x000000c600c77306ULL, 0x000ff00000209400ULL, 0x000000c600c87306ULL, 0x000ea20000205400ULL,
0x000000b5b400720bULL, 0x002fce0003fbd000ULL, 0x0000002b00827306ULL, 0x0002f0000000d400ULL,
0x000000c600997306ULL, 0x000f22000020d400ULL, 0x000000c8c700720bULL, 0x004fe20003fdd000ULL,
0x000100002b2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002a00297306ULL, 0x000fe20000209400ULL, 0x0000000182825812ULL, 0x008fe400078efcffULL,
0x000000b3b200720bULL, 0x000fca0003fbd000ULL, 0x0000002a00c47306ULL, 0x000e620000205400ULL,
0x0000000199996812ULL, 0x010fce00078efcffULL, 0x0000002a00967306ULL, 0x0004e2000020d400ULL,
0x000000017f7f5812ULL, 0x000fce00078efcffULL, 0x0000005d00b17306ULL, 0x000fe20000209400ULL,
0x000000c42900720bULL, 0x002fe20003fdd000ULL, 0x000001002d2a7824ULL, 0x004fca00078e00ffULL,
0x00000018ffad7819ULL, 0x000fe2000001142aULL, 0x0000005d00b07306ULL, 0x000e6c0000205400ULL,
0x0000000196966812ULL, 0x008fe400078efcffULL, 0x0000002b00c97306ULL, 0x000ff00000209400ULL,
0x0000002b00ca7306ULL, 0x000ea20000205400ULL, 0x000000b0b100720bULL, 0x002fe20003fbd000ULL,
0x000001004cb07824ULL, 0x000fca00078e00ffULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x0000005d007e7306ULL, 0x0002f0000020d400ULL, 0x0000002b008f7306ULL, 0x000f22000020d400ULL,
0x000000cac900720bULL, 0x004fc40003fdd000ULL, 0x00000018ff5d7819ULL, 0x002fca000001142fULL,
0x0000002c00aa7306ULL, 0x000fe20000009400ULL, 0x000000017e7e5812ULL, 0x008fce00078efcffULL,
0x0000002c00a57306ULL, 0x000e620000005400ULL, 0x000000018f8f6812ULL, 0x010fc800078efcffULL,
0x0000008f7e8f723eULL, 0x000fc600000010ffULL, 0x000000cb00c67306ULL, 0x000ff00000209400ULL,
0x000000cb00cd7306ULL, 0x000ea20000205400ULL, 0x000000a5aa00720bULL, 0x002fe20003fbd000ULL,
0x000100004ca57824ULL, 0x000fca00078e00ffULL, 0x00000018ffa57819ULL, 0x000fe200000114a5ULL,
0x0000002c007b7306ULL, 0x0002f0000000d400ULL, 0x000000cb009a7306ULL, 0x000f22000020d400ULL,
0x000000cdc600720bULL, 0x004fe20003fdd000ULL, 0x000100002c2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002d00a67306ULL, 0x000fe20000009400ULL,
0x000000017b7b5812ULL, 0x008fce00078efcffULL, 0x0000002d00a17306ULL, 0x000e620000005400ULL,
0x000000019a9a6812ULL, 0x010fc800078efcffULL, 0x0000007b9a9a723eULL, 0x000fc600000010ffULL,
0x000000ad00cc7306ULL, 0x000ff00000209400ULL, 0x000000ad00cf7306ULL, 0x000ea20000205400ULL,
0x000000a1a600720bULL, 0x002fce0003fbd000ULL, 0x0000002d00797306ULL, 0x0002f0000000d400ULL,
0x000000ad009e7306ULL, 0x000f22000020d400ULL, 0x000000cfcc00720bULL, 0x004fe20003fdd000ULL,
0x000100002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000002c002a7306ULL, 0x000fe20000209400ULL, 0x0000000179795812ULL, 0x008fe400078efcffULL,
0x000000acaf00720bULL, 0x000fca0003fbd000ULL, 0x0000002c002b7306ULL, 0x000e620000205400ULL,
0x000000019e9e6812ULL, 0x010fce00078efcffULL, 0x0000002c00a97306ULL, 0x000ea2000020d400ULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x000000abae00720bULL, 0x000fca0003fbd000ULL,
0x0000002d00b87306ULL, 0x000fe20000209400ULL, 0x0000002b2a00720bULL, 0x002fe20003fdd000ULL,
0x000100004d2a7824ULL, 0x000fe400078e00ffULL, 0x000001004e2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000002d00b97306ULL, 0x000e620000205400ULL,
0x0000000176765812ULL, 0x000fe400078efcffULL, 0x00000018ff2b7819ULL, 0x000fc6000001142bULL,
0x00000001a9a96812ULL, 0x004fe400078efcffULL, 0x0000002d00ad7306ULL, 0x000ea4000020d400ULL,
0x000000a97a7a723eULL, 0x000fcc00000010ffULL, 0x0000002e009f7306ULL, 0x000fe20000009400ULL,
0x000000b9b800720bULL, 0x002fce0003fdd000ULL, 0x0000002e00a27306ULL, 0x000e6c0000005400ULL,
0x00000001adad6812ULL, 0x004fe400078efcffULL, 0x000000ba002c7306ULL, 0x000fe40000209400ULL,
0x000000ad767b723eULL, 0x000fcc00000010ffULL, 0x000000ba00bb7306ULL, 0x000ea20000205400ULL,
0x000000a29f00720bULL, 0x002fce0003fbd000ULL, 0x0000002e00757306ULL, 0x0002f0000000d400ULL,
0x000000ba00b67306ULL, 0x000f22000020d400ULL, 0x000000bb2c00720bULL, 0x004fe20003fdd000ULL,
0x000100002e2e7824ULL, 0x002fc400078e00ffULL, 0x000001004f2c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000002f00a07306ULL, 0x000fe20000009400ULL,
0x0000000175755812ULL, 0x008fe400078efcffULL, 0x00000018ff2c7819ULL, 0x000fca000001142cULL,
0x0000002f009d7306ULL, 0x000e620000005400ULL, 0x00000001b6b66812ULL, 0x010fc800078efcffULL,
0x00000075b6b6723eULL, 0x000fc600000010ffULL, 0x000000b700bc7306ULL, 0x000ff00000209400ULL,
0x000000b700bd7306ULL, 0x000ea20000205400ULL, 0x0000009da000720bULL, 0x002fce0003fbd000ULL,
0x0000002f00717306ULL, 0x0002f0000000d400ULL, 0x000000b700b47306ULL, 0x000f22000020d400ULL,
0x000000bdbc00720bULL, 0x004fe20003fdd000ULL, 0x000100002f2f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002e00287306ULL, 0x000fe20000209400ULL,
0x0000000171715812ULL, 0x008fe400078efcffULL, 0x000000a7a800720bULL, 0x000fca0003fbd000ULL,
0x0000002e002d7306ULL, 0x000e620000205400ULL, 0x00000001b4b46812ULL, 0x010fce00078efcffULL,
0x0000002e00b37306ULL, 0x000ea2000020d400ULL, 0x0000000172725812ULL, 0x000fce00078efcffULL,
0x0000005d00a47306ULL, 0x000fe20000209400ULL, 0x0000002d2800720bULL, 0x002fe20003fdd000ULL,
0x0000010024287824ULL, 0x000fcc00078e00ffULL, 0x0000005d00a37306ULL, 0x000e6c0000205400ULL,
0x00000001b3b36812ULL, 0x004fe400078efcffULL, 0x0000002f00297306ULL, 0x000fe40000209400ULL,
0x000000b37272723eULL, 0x000fcc00000010ffULL, 0x0000002f00b27306ULL, 0x000ea20000205400ULL,
0x000000a3a400720bULL, 0x002fe40003fbd000ULL, 0x00000018ffa47819ULL, 0x000fca0000011428ULL,
0x0000005d00707306ULL, 0x0002f0000020d400ULL, 0x0000002f00b17306ULL, 0x000922000020d400ULL,
0x000000b22900720bULL, 0x004fe40003fdd000ULL, 0x00000018ff5d7819ULL, 0x002fca000001144fULL,
0x0000004c009c7306ULL, 0x000fe20000009400ULL, 0x0000000170705812ULL, 0x008fe200078efcffULL,
0x000001004d2f7824ULL, 0x010fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000004c00977306ULL, 0x000e620000005400ULL, 0x00000001b1b16812ULL, 0x000fce00078efcffULL,
0x000000b0002e7306ULL, 0x000ff00000209400ULL, 0x000000b000b57306ULL, 0x000ea20000205400ULL,
0x000000979c00720bULL, 0x002fce0003fbd000ULL, 0x0000004c006f7306ULL, 0x000e70000000d400ULL,
0x000000b0004c7306ULL, 0x000ee2000020d400ULL, 0x000000b52e00720bULL, 0x004fce0003fdd000ULL,
0x000000a500aa7306ULL, 0x000fe20000209400ULL, 0x000000016f6f5812ULL, 0x002fe400078efcffULL,
0x000000909300720bULL, 0x000fca0003fbd000ULL, 0x000000a500b77306ULL, 0x000e620000205400ULL,
0x000000014c4c6812ULL, 0x008fc800078efcffULL, 0x0000006f4c4c723eULL, 0x000fc600000010ffULL,
0x0000004e00887306ULL, 0x000fe20000009400ULL, 0x000000016c6c5812ULL, 0x000fce00078efcffULL,
0x0000004e00877306ULL, 0x000fe20000005400ULL, 0x000000b7aa00720bULL, 0x002fce0003fdd000ULL,
0x0000004e00637306ULL, 0x0003f0000000d400ULL, 0x000000a500a17306ULL, 0x000ea2000020d400ULL,
0x000100004e4e7824ULL, 0x002fce00078e00ffULL, 0x0000002a00ac7306ULL, 0x000ff00000209400ULL,
0x0000002a00af7306ULL, 0x000fe20000205400ULL, 0x00000001a1a16812ULL, 0x004fc800078efcffULL,
0x000000a16c6c723eULL, 0x000fc600000010ffULL, 0x0000002a00a57306ULL, 0x0003f0000020d400ULL,
0x0000004d008b7306ULL, 0x000fe20000009400ULL, 0x00000018ff2a7819ULL, 0x002fce000001144eULL,
0x0000004d008a7306ULL, 0x000e700000005400ULL, 0x0000002f00a67306ULL, 0x000ff00000209400ULL,
0x0000002f00bf7306ULL, 0x000ea20000205400ULL, 0x0000008a8b00720bULL, 0x002fce0003fbd000ULL,
0x0000004d00487306ULL, 0x000e70000000d400ULL, 0x0000002f004d7306ULL, 0x000ee2000020d400ULL,
0x000000bfa600720bULL, 0x004fce0003fdd000ULL, 0x0000002b00ab7306ULL, 0x000fe20000209400ULL,
0x0000000148485812ULL, 0x002fe400078efcffULL, 0x000000afac00720bULL, 0x000fca0003fbd000ULL,
0x0000002b00ae7306ULL, 0x000fe20000205400ULL, 0x000000014d4d6812ULL, 0x008fe400078efcffULL,
0x0000008e9100720bULL, 0x000fe40003fdd000ULL, 0x000000484d4d723eULL, 0x000fc600000010ffULL,
0x0000002b00a27306ULL, 0x000fe2000020d400ULL, 0x00000001a5a55812ULL, 0x000fe400078efcffULL,
0x000000878800720bULL, 0x000fca0003fbd000ULL, 0x0000002c00b07306ULL, 0x000fe20000209400ULL,
0x000000015c5c6812ULL, 0x000fce00078efcffULL, 0x0000002c00b97306ULL, 0x000e620000205400ULL,
0x0000000163635812ULL, 0x000fce00078efcffULL, 0x0000002c009d7306ULL, 0x0004f0000020d400ULL,
0x0000002a009f7306ULL, 0x000fe20000209400ULL, 0x01200000472c783bULL, 0x004ea20000000200ULL,
0x000000b9b000720bULL, 0x002fcc0003fdd000ULL, 0x0000002a00a07306ULL, 0x000e6e0000205400ULL,
0x000000019d9d6812ULL, 0x008fe200078efcffULL, 0x0000002a004e7306ULL, 0x000722000020d400ULL,
0x0000008c8d00720bULL, 0x000fce0003fdd000ULL, 0x0000004f00897306ULL, 0x000fe20000009400ULL,
0x012000004b28783bULL, 0x008ee20000000200ULL, 0x000000a09f00720bULL, 0x002fc80003fbd000ULL,
0x0000000169696812ULL, 0x000fe400078efcffULL, 0x0000004f00867306ULL, 0x000fee0000005400ULL,
0x000000014e4e5812ULL, 0x010fe200078efcffULL, 0x0000004f00627306ULL, 0x0003e2000000d400ULL,
0x000000452c2c8231ULL, 0x004fc400003400ffULL, 0x000000452e2e8231ULL, 0x000fe200003400ffULL,
0x0000004e694e723eULL, 0x000fe200000010ffULL, 0x000000462d2d8231ULL, 0x080fe400003400ffULL,
0x000000462f2f8231ULL, 0x000fe200003400ffULL, 0x0000005d00817306ULL, 0x000fe20000209400ULL,
0x000100004f4f7824ULL, 0x002fca00078e00ffULL, 0x00000018ffa77819ULL, 0x000fe2000001144fULL,
0x0000003a2c20723cULL, 0x040be20000041820ULL, 0x0000005d00807306ULL, 0x000e6c0000205400ULL,
0x00000100273a7824ULL, 0x020fe200078e00ffULL, 0x0000007a2c08723cULL, 0x000fe20000041808ULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x0000004528288231ULL, 0x008fc400003400ffULL,
0x000000452a2a8231ULL, 0x000fe200003400ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000004629298231ULL, 0x080fe400003400ffULL, 0x000000462b2b8231ULL, 0x000fe200003400ffULL,
0x000000aeab00720bULL, 0x000fe20003f1d000ULL, 0x000000a700a37306ULL, 0x000ea20000205400ULL,
0x000000808100720bULL, 0x002fce0003fbd000ULL, 0x000000a4009c7306ULL, 0x000fe80000209400ULL,
0x00000001a2a20812ULL, 0x000fe400078efcffULL, 0x000000868900720bULL, 0x000fe40003f1d000ULL,
0x000000a400b57306ULL, 0x000e700000205400ULL, 0x000000a7004f7306ULL, 0x000726000020d400ULL,
0x0000000162620812ULL, 0x000fc400078efcffULL, 0x000000a3a800720bULL, 0x004fe40003f1d000ULL,
0x000000629d9d723eULL, 0x000fe200000010ffULL, 0x0000005d00607306ULL, 0x000ea2000020d400ULL,
0x0000010025a77824ULL, 0x008fe200078e00ffULL, 0x000000b59c00720bULL, 0x002fe40003fdd000ULL,
0x00000063a29c723eULL, 0x000fe400000010ffULL, 0x00000018ffa77819ULL, 0x000fe400000114a7ULL,
0x000000a400977306ULL, 0x000e64000020d400ULL, 0x000000014f4f0812ULL, 0x010fcc00078efcffULL,
0x00000024007d7306ULL, 0x000fe20000009400ULL, 0x0000000160605812ULL, 0x004fc800078efcffULL,
0x0000004f604f723eULL, 0x000fc600000010ffULL, 0x00000024007c7306ULL, 0x000ea20000005400ULL,
0x0000000197976812ULL, 0x002fce00078efcffULL, 0x0000002500777306ULL, 0x000ff00000009400ULL,
0x0000002500787306ULL, 0x000e620000005400ULL, 0x0000007c7d00720bULL, 0x004fce0003f1d000ULL,
0x000000a700aa7306ULL, 0x000ff00000209400ULL, 0x000000a700b77306ULL, 0x000ea20000205400ULL,
0x000000787700720bULL, 0x002fce0003fbd000ULL, 0x0000002400687306ULL, 0x0002f0000000d400ULL,
0x00000025005e7306ULL, 0x0008e2000000d400ULL, 0x0001000024247824ULL, 0x002fe200078e00ffULL,
0x000000b7aa00720bULL, 0x004fc40003fdd000ULL, 0x00000071b4b7723eULL, 0x000fe400000010ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x000000a700937306ULL, 0x000e62000020d400ULL,
0x0001000025257824ULL, 0x010fe200078e00ffULL, 0x0000000168680812ULL, 0x008fe200078efcffULL,
0x000000b62c14723cULL, 0x000fe60000041814ULL, 0x00000018ff8e7819ULL, 0x000fe20000011425ULL,
0x0000010026257824ULL, 0x000fe200078e00ffULL, 0x0000006600737306ULL, 0x000fe20000209400ULL,
0x000000015e5e5812ULL, 0x000fc400078efcffULL, 0x000000689768723eULL, 0x000fca00000010ffULL,
0x0000006600747306ULL, 0x000ea20000205400ULL, 0x0000000193936812ULL, 0x002fc800078efcffULL,
0x0000005e9369723eULL, 0x000fc600000010ffULL, 0x00000024008b7306ULL, 0x000ff00000209400ULL,
0x0000002400907306ULL, 0x000e620000205400ULL, 0x000000747300720bULL, 0x004fe40003fdd000ULL,
0x000000b17073723eULL, 0x000fca00000010ffULL, 0x0000008e00917306ULL, 0x000fe40000209400ULL,
0x000000722c10723cULL, 0x000fec0000041810ULL, 0x0000008e00a47306ULL, 0x000ea20000205400ULL,
0x000000908b00720bULL, 0x002fce0003f1d000ULL, 0x00000024008a7306ULL, 0x0002f0000020d400ULL,
0x0000006600657306ULL, 0x000f22000020d400ULL, 0x000000859224723eULL, 0x002fe400000010ffULL,
0x00000018ff857819ULL, 0x000fc40000011425ULL, 0x000000849b25723eULL, 0x000fe400000010ffULL,
0x000000a49100720bULL, 0x004fe20003fbd000ULL, 0x0000008e00887306ULL, 0x0002a2000020d400ULL,
0x000000018a8a0812ULL, 0x008fe400078efcffULL, 0x0000006d6e00720bULL, 0x000fe20003f1d000ULL,
0x000000242c0c723cULL, 0x000b62000004180cULL, 0x000000799e9b723eULL, 0x000fe400000010ffULL,
0x000000a55c6d723eULL, 0x000fe200000010ffULL, 0x00000026004a7306ULL, 0x000fe20000009400ULL,
0x0000000165656812ULL, 0x010fc400078efcffULL, 0x000000839824723eULL, 0x020fe200000010ffULL,
0x0000009a2c18723cULL, 0x040fe20000041818ULL, 0x000000829925723eULL, 0x000fe400000010ffULL,
0x000000967f8e723eULL, 0x002fe200000010ffULL, 0x00000026006b7306ULL, 0x000e620000005400ULL,
0x0000000188885812ULL, 0x004fe400078efcffULL, 0x0000000159590812ULL, 0x000fe200078efcffULL,
0x000000242c04723cULL, 0x000f620000041804ULL, 0x0000008a658a723eULL, 0x000fc400000010ffULL,
0x00000088598b723eULL, 0x000fe200000010ffULL, 0x0000008500847306ULL, 0x000fe80000209400ULL,
0x0000008e2c1c723cULL, 0x000f68000004181cULL, 0x0000008500877306ULL, 0x000ea20000205400ULL,
0x0000006b4a00720bULL, 0x002fc60003fdd000ULL, 0x0000004c280c723cULL, 0x040b68000004180cULL,
0x0000002600587306ULL, 0x0002e8000000d400ULL, 0x0000006c2820723cULL, 0x000b680000041820ULL,
0x00000085003b7306ULL, 0x000f22000020d400ULL, 0x0001000026267824ULL, 0x002fe200078e00ffULL,
0x000000878400720bULL, 0x004fc40003fbd000ULL, 0x0000009c2804723cULL, 0x020b640000041804ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002700617306ULL, 0x000fe20000009400ULL,
0x0000000158586812ULL, 0x008fc600078efcffULL, 0x0000004e281c723cULL, 0x000b68000004181cULL,
0x00000027006a7306ULL, 0x000e620000005400ULL, 0x000000013b3b5812ULL, 0x010fc600078efcffULL,
0x000000682818723cULL, 0x040b680000041818ULL, 0x0000003a007e7306ULL, 0x000fe80000209400ULL,
0x0000008a2808723cULL, 0x000b680000041808ULL, 0x0000003a00777306ULL, 0x000ea20000205400ULL,
0x0000006a6100720bULL, 0x002fce0003fbd000ULL, 0x0000002600247306ULL, 0x000ff00000209400ULL,
0x0000002600257306ULL, 0x000e620000205400ULL, 0x000000777e00720bULL, 0x004fce0003f1d000ULL,
0x0000003a00767306ULL, 0x0004f0000020d400ULL, 0x0000002700577306ULL, 0x000f22000000d400ULL,
0x00010000273a7824ULL, 0x004fe200078e00ffULL, 0x000000252400720bULL, 0x002fc80003fdd000ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000002600277306ULL, 0x000e62000020d400ULL,
0x0000000176760812ULL, 0x008fe400078efcffULL, 0x000000565f00720bULL, 0x000fe40003f1d000ULL,
0x000000583b56723eULL, 0x000fc600000010ffULL, 0x00000067005d7306ULL, 0x000fe20000209400ULL,
0x0000000157575812ULL, 0x010fc800078efcffULL, 0x000000577657723eULL, 0x000fc600000010ffULL,
0x0000006700667306ULL, 0x000ea20000205400ULL, 0x0000000127276812ULL, 0x002fe400078efcffULL,
0x0000000164640812ULL, 0x000fe200078efcffULL, 0x000000562814723cULL, 0x000b660000041814ULL,
0x000000276464723eULL, 0x000fe200000010ffULL, 0x0000003a002c7306ULL, 0x000ff00000209400ULL,
0x0000003a002d7306ULL, 0x000e620000205400ULL, 0x000000665d00720bULL, 0x004fce0003fbd000ULL,
0x0000006700677306ULL, 0x000eb0000020d400ULL, 0x0000003a003a7306ULL, 0x000ee2000020d400ULL,
0x0000002d2c00720bULL, 0x002fe40003fdd000ULL, 0x0000000167675812ULL, 0x004fd600078efcffULL,
0x000000013a3a6812ULL, 0x008fc800078efcffULL, 0x0000003a6765723eULL, 0x000fce00000010ffULL,
0x000000642810723cULL, 0x000b620000041810ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000003e247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c03c277811ULL, 0x000fe200078e40ffULL,
0x0176980050ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff2a7224ULL, 0x024fe400078e0025ULL,
0x000000022700720cULL, 0x000fe20003f06070ULL, 0x000000ffff257224ULL, 0x000fe400078e0041ULL,
0x000000ffff597224ULL, 0x000fe400078e0040ULL, 0x000000ffff577224ULL, 0x000fd000078e005bULL,
0x0000341000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x008fc40000015200ULL,
0x0000000400267824ULL, 0x000fca00078e00ffULL, 0xfffffff826287812ULL, 0x000fca00078ec0ffULL,
0x0176cc0028277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176cc0028277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000023c247810ULL, 0x000fe40007ffe0ffULL, 0x000001003f3f7810ULL, 0x000fe40007ffe0ffULL,
0x000000032400720cULL, 0x000fc60003f06070ULL, 0x00006200362c7a24ULL, 0x000fd400078e023fULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x0000003f02247217ULL, 0x000fe20007800000ULL,
0x0000001037297824ULL, 0x000fe200078e00ffULL, 0x00000003ff287819ULL, 0x000fe20000011632ULL,
0x0000001032257824ULL, 0x000fe400078e00ffULL, 0x0000000124247824ULL, 0x000fe200078e0a3fULL,
0x00000004282b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129277824ULL, 0x000fe200078e0228ULL,
0x00000070253f7812ULL, 0x000fe200078ec0ffULL, 0x00000080ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000002429247217ULL, 0x000fe20007800000ULL, 0x0000000127257824ULL, 0x000fc400078e022cULL,
0x0000000127267824ULL, 0x040fe400078e0232ULL, 0x00000008272d7824ULL, 0x000fe400078e00ffULL,
0x00000001242a7824ULL, 0x000fe400078e0a29ULL, 0x0000000129277824ULL, 0x000fe200078e022bULL,
0xfffffff82d2e7812ULL, 0x000fe200078ee226ULL, 0x00005e0025247625ULL, 0x000fe200078e002fULL,
0x0000002a2800720cULL, 0x080fe40003fa6070ULL, 0x0000002a2b00720cULL, 0x000fe20003f06070ULL,
0x00000001272d7824ULL, 0x040fe200078e0232ULL, 0x0000003f24267210ULL, 0x000fe20007fde0ffULL,
0x00000008273a7824ULL, 0x000fc400078e00ffULL, 0x0000000127247824ULL, 0x000fe400078e022cULL,
0x000000102e2b7824ULL, 0x000fe200078e0249ULL, 0xfffffff83a2e7812ULL, 0x000fe200078ee22dULL,
0x000000ffff277224ULL, 0x000fe200030e0625ULL, 0x00000008282d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000000c283a7810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0005e2000e901c46ULL,
0x00000001293b7824ULL, 0x040fe200078e022dULL, 0x0000003f24287210ULL, 0x000fe20007fde0ffULL,
0x0000000129417824ULL, 0x000fe200078e023aULL, 0x0000002a2d00720cULL, 0x000fe20003fa6070ULL,
0x000000013b247824ULL, 0x000fc400078e022cULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x0000002a3a00720cULL, 0x000fe20003fc6070ULL, 0x000000102e2d7824ULL, 0x000fe400078e0249ULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0x00000000282d7faeULL, 0x0007e2000c101c46ULL,
0x00000001412a7824ULL, 0x000fe200078e022cULL, 0x0000003f24247210ULL, 0x000fe20007f1e0ffULL,
0x000000013b2b7824ULL, 0x144fe400078e0232ULL, 0x000000083b2e7824ULL, 0x000fe400078e00ffULL,
0x00000001412c7824ULL, 0x000fe400078e0232ULL, 0x00005e002a267625ULL, 0x000fe200078e002fULL,
0xfffffff82e2a7812ULL, 0x000fc600078ee22bULL, 0x0000000841417824ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000003f26267210ULL, 0x000fe20007f1e0ffULL,
0x000000102a297824ULL, 0x008fe200078e0249ULL, 0xfffffff8412c7812ULL, 0x000fc600078ee22cULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x0000000024297faeULL, 0x0005e2000e901c46ULL,
0x000000102c497824ULL, 0x000fca00078e0249ULL, 0x0000000026497faeULL, 0x0005e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x0000001037257824ULL, 0x000fe400078e00ffULL,
0x00000010323f7824ULL, 0x040fe400078e00ffULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x0000002532257211ULL, 0x000fe400078fe8ffULL, 0x000000703f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000008252d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000125247824ULL, 0x040fe200078e0232ULL,
0x0000000c253b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fc400078e00ffULL,
0x000000012d2f7824ULL, 0x000fe400078e0232ULL, 0x000000013b287824ULL, 0x000fe200078e022cULL,
0xfffffff8272e7812ULL, 0x000fe200078ee224ULL, 0x0000000125247824ULL, 0x040fe200078e022cULL,
0x0000000425277810ULL, 0x000fe20007ffe0ffULL, 0x000000082d487824ULL, 0x000fe400078e00ffULL,
0x00005e0024247625ULL, 0x000fc800078e0029ULL, 0x00000001272b7824ULL, 0x040fe200078e0232ULL,
0x0000003f242a7210ULL, 0x000fe20007f1e0ffULL, 0x00000008273a7824ULL, 0x040fe400078e00ffULL,
0x0000000127267824ULL, 0x100fe400078e022cULL, 0x000000012d277824ULL, 0x000fe200078e022cULL,
0xfffffff83a2c7812ULL, 0x000fe200078ee22bULL, 0x000000ffff2b7224ULL, 0x000fe200000e0625ULL,
0xfffffff8483a7812ULL, 0x000fe200078ee22fULL, 0x00005e0026247625ULL, 0x000fc800078e0029ULL,
0x00005e0027267625ULL, 0x000fe200078e0029ULL, 0x0000003f24247210ULL, 0x000fc60007f1e0ffULL,
0x000000013b2d7824ULL, 0x040fe200078e0232ULL, 0x0000003f26267210ULL, 0x000fe20007fbe0ffULL,
0x000000083b4a7824ULL, 0x000fe400078e00ffULL, 0x00005e0028287625ULL, 0x000fc600078e0029ULL,
0xfffffff84a487812ULL, 0x000fe200078ee22dULL, 0x000000102e2d7824ULL, 0x100fe200078e0249ULL,
0x0000003f28287210ULL, 0x000fe20007fde0ffULL, 0x000000102c2f7824ULL, 0x000fe400078e0249ULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2d7faeULL, 0x0005e2000b901c46ULL, 0x000000103a3b7824ULL, 0x000fe400078e0249ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x00000000242f7faeULL, 0x0005e2000b901c46ULL,
0x0000001048497824ULL, 0x000fc400078e0249ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x00000000263b7faeULL, 0x0005e8000b901c46ULL, 0x0000000028497faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0xffffffe033247812ULL, 0x040fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x0000001033257812ULL, 0x040fe400078ec0ffULL,
0x0000000833267812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x00000024262a7210ULL, 0x000fd60007ffe025ULL, 0x00000000530403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80052567f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017668002a287f8cULL, 0x0002a4000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x01766c002a277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x014fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c002a277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001803f427810ULL, 0x000fca0007ffe042ULL, 0x0000000143427824ULL, 0x000fca00078e0242ULL,
0x0170000042257984ULL, 0x000ea80000000800ULL, 0x0172000042247984ULL, 0x0002e20000000800ULL,
0x000000402500720bULL, 0x004fe20003f1d000ULL, 0x0000ad527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x002fc800000e0100ULL, 0x0000ffff28ff7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff597224ULL, 0x000fd200078e0040ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000300277811ULL, 0x000fe400078ff0ffULL, 0x000000402500720bULL, 0x000fe40003f14000ULL,
0x000000002700720cULL, 0x000fe20003fa5270ULL, 0x0000ad127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000297806ULL, 0x000fc400000e0100ULL, 0x000000800026d824ULL, 0x000fe200078e023fULL,
0x0000004025597209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x00000001432ad824ULL, 0x000fe200078e0226ULL, 0x0000991029267816ULL, 0x000fc800000000ffULL,
0x017400592a00d388ULL, 0x0003e20000000800ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000004059267221ULL, 0x002fe20000010100ULL,
0x000000ff29ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL, 0x00000026002e7308ULL, 0x000e640000000800ULL,
0x0000002e39397220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011632ULL, 0x0000ac527f007947ULL, 0x000fea000b800000ULL,
0x00001f262e267589ULL, 0x0002a400000e0000ULL, 0x000000260c0c7220ULL, 0x084fe40000410000ULL,
0x000000260d0d7220ULL, 0x080fe40000410000ULL, 0x0000002620207220ULL, 0x080fe40000410000ULL,
0x0000002621217220ULL, 0x080fe40000410000ULL, 0x0000002604047220ULL, 0x080fe40000410000ULL,
0x0000002605057220ULL, 0x000fc40000410000ULL, 0x000000261c1c7220ULL, 0x080fe40000410000ULL,
0x000000261d1d7220ULL, 0x080fe40000410000ULL, 0x0000002618187220ULL, 0x080fe40000410000ULL,
0x0000002619197220ULL, 0x080fe40000410000ULL, 0x0000002608087220ULL, 0x080fe40000410000ULL,
0x0000002609097220ULL, 0x000fc40000410000ULL, 0x0000002614147220ULL, 0x080fe40000410000ULL,
0x0000002615157220ULL, 0x080fe40000410000ULL, 0x0000002610107220ULL, 0x080fe40000410000ULL,
0x0000002611117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0029ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000832267811ULL, 0x000fe200078ff0ffULL, 0x0000ab627f007947ULL, 0x000fea000b800000ULL,
0x00001f262e267589ULL, 0x00046400000e0000ULL, 0x000000260e0e7220ULL, 0x082fe40000410000ULL,
0x000000260f0f7220ULL, 0x080fe40000410000ULL, 0x0000002622227220ULL, 0x080fe40000410000ULL,
0x0000002623237220ULL, 0x080fe40000410000ULL, 0x0000002606067220ULL, 0x080fe40000410000ULL,
0x0000002607077220ULL, 0x000fc40000410000ULL, 0x000000261e1e7220ULL, 0x080fe40000410000ULL,
0x000000261f1f7220ULL, 0x080fe40000410000ULL, 0x000000261a1a7220ULL, 0x080fe40000410000ULL,
0x000000261b1b7220ULL, 0x080fe40000410000ULL, 0x000000260a0a7220ULL, 0x080fe40000410000ULL,
0x000000260b0b7220ULL, 0x000fc40000410000ULL, 0x0000002616167220ULL, 0x080fe40000410000ULL,
0x0000002617177220ULL, 0x080fe40000410000ULL, 0x0000002612127220ULL, 0x080fe40000410000ULL,
0x0000002613137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff29ff7812ULL, 0x000fe20007800828ULL, 0x00000001ff297424ULL, 0x000fd800078e00ffULL,
0x0000002559250221ULL, 0x000fe20000010100ULL, 0x00007610ff290816ULL, 0x000fc60000000029ULL,
0x3fb8aa3b25250820ULL, 0x000fc80000410000ULL, 0x0000002500440308ULL, 0x000e640000000800ULL,
0x0000004424240220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003924397221ULL, 0x008fc40000010000ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x0000000138557824ULL, 0x000fca00078e0255ULL, 0x0176ac0055277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0055277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991029247816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000044ff24723eULL, 0x000fe400000010ffULL,
0x00000002ff257819ULL, 0x000fe40000011632ULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x0000a7627f007947ULL, 0x000fea000b800000ULL, 0x00001f2524457589ULL, 0x0002e400000e0000ULL,
0x0000000825267810ULL, 0x000fe20007ffe0ffULL, 0x0000a7b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2624467589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001025267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x0000c8c0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x0000ad4000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001825267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x004fe200078e0024ULL, 0x0000c930002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0000acd000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005428783bULL, 0x004ea80000004200ULL,
0x00000000512c783bULL, 0x000f280000004200ULL, 0x000000003140783bULL, 0x000e680000004200ULL,
0x000000003024783bULL, 0x002e620000004200ULL, 0x0000010028887824ULL, 0x004fe200078e00ffULL,
0x00000028008e7306ULL, 0x000fe20000009400ULL, 0x00000018ff547819ULL, 0x000fe20000011429ULL,
0x000001002b917824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011428ULL,
0x000001002cbe7824ULL, 0x010fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fc40000011488ULL,
0x00000018ff557819ULL, 0x000fe2000001142aULL, 0x0000002800a17306ULL, 0x000ea20000005400ULL,
0x00000018ff587819ULL, 0x000fe40000011442ULL, 0x00000018ff8a7819ULL, 0x002fe40000011425ULL,
0x00000018ff8b7819ULL, 0x000fe40000011426ULL, 0x00000018ffb87819ULL, 0x000fe20000011491ULL,
0x0000008900a07306ULL, 0x000fe20000209400ULL, 0x00000018ff567819ULL, 0x000fc4000001142bULL,
0x00000018ffbe7819ULL, 0x000fe400000114beULL, 0x00000018ff5d7819ULL, 0x000fe40000011424ULL,
0x00000018ff5e7819ULL, 0x000fe20000011427ULL, 0x0000008900a77306ULL, 0x000e620000205400ULL,
0x000000a18e00720bULL, 0x004fe20003fbd000ULL, 0x000100002da17824ULL, 0x000fcc00078e00ffULL,
0x00000028007b7306ULL, 0x000530000000d400ULL, 0x0000005400b07306ULL, 0x000fe20000209400ULL,
0x0001000028287824ULL, 0x004fe200078e00ffULL, 0x000000a7a000720bULL, 0x002fc80003fdd000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000005400b37306ULL, 0x000fe20000205400ULL,
0x000000017b7b5812ULL, 0x010fce00078efcffULL, 0x0000005400787306ULL, 0x0003f0000020d400ULL,
0x0000005500a47306ULL, 0x000fe20000209400ULL, 0x00000018ff547819ULL, 0x002fce000001142dULL,
0x0000005500a57306ULL, 0x000ff00000205400ULL, 0x0000005500737306ULL, 0x0003f0000020d400ULL,
0x00000054009f7306ULL, 0x000fe20000209400ULL, 0x00000018ff557819ULL, 0x002fce000001142eULL,
0x00000054009c7306ULL, 0x000ff00000205400ULL, 0x00000054006a7306ULL, 0x0003f0000020d400ULL,
0x0000008900887306ULL, 0x000522000020d400ULL, 0x00000018ff547819ULL, 0x002fce0000011441ULL,
0x0000005300a87306ULL, 0x000fe20000209400ULL, 0x000001002a897824ULL, 0x004fca00078e00ffULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x0000005300ab7306ULL, 0x000e620000205400ULL,
0x0000000188886812ULL, 0x010fce00078efcffULL, 0x0000002800a67306ULL, 0x000ff00000209400ULL,
0x0000002800a97306ULL, 0x000ea20000205400ULL, 0x000000aba800720bULL, 0x002fe40003fbd000ULL,
0x00000018ffa87819ULL, 0x000fca00000114a1ULL, 0x0000005500997306ULL, 0x000ff00000209400ULL,
0x0000005500987306ULL, 0x000fe20000205400ULL, 0x000000a9a600720bULL, 0x004fce0003fdd000ULL,
0x0000005500687306ULL, 0x000ff0000020d400ULL, 0x0000005400877306ULL, 0x000ff00000209400ULL,
0x0000005400847306ULL, 0x000ff00000205400ULL, 0x0000005400557306ULL, 0x000ff0000020d400ULL,
0x0000008a00637306ULL, 0x000ff00000209400ULL, 0x0000008a00627306ULL, 0x000ff00000205400ULL,
0x0000008a00547306ULL, 0x0003f0000020d400ULL, 0x00000053007a7306ULL, 0x000522000020d400ULL,
0x00000100298a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001148aULL,
0x00000028008d7306ULL, 0x000e62000020d400ULL, 0x00000018ff537819ULL, 0x004fce000001142cULL,
0x0000002900aa7306ULL, 0x000fe20000009400ULL, 0x000000017a7a5812ULL, 0x010fce00078efcffULL,
0x0000002900ad7306ULL, 0x000ea20000005400ULL, 0x000000018d8d6812ULL, 0x002fc800078efcffULL,
0x0000008d7a7a723eULL, 0x000fc600000010ffULL, 0x0000008c00ac7306ULL, 0x000ff00000209400ULL,
0x0000008c00af7306ULL, 0x000e620000205400ULL, 0x000000adaa00720bULL, 0x004fce0003fbd000ULL,
0x0000002900797306ULL, 0x000530000000d400ULL, 0x0000008c00927306ULL, 0x000ee2000020d400ULL,
0x0001000029297824ULL, 0x004fe200078e00ffULL, 0x000000afac00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000053009e7306ULL, 0x000fe20000209400ULL,
0x0000000179795812ULL, 0x010fe400078efcffULL, 0x000000b3b000720bULL, 0x000fca0003fbd000ULL,
0x0000002900ae7306ULL, 0x000fe20000209400ULL, 0x0000000192926812ULL, 0x008fce00078efcffULL,
0x0000002900b17306ULL, 0x000e620000205400ULL, 0x0000000178785812ULL, 0x000fce00078efcffULL,
0x00000053009d7306ULL, 0x000ff00000205400ULL, 0x00000053006e7306ULL, 0x0005e2000020d400ULL,
0x000000b1ae00720bULL, 0x002fce0003fdd000ULL, 0x0000005800837306ULL, 0x000fe20000209400ULL,
0x00000018ff537819ULL, 0x004fce0000011440ULL, 0x0000005300867306ULL, 0x000ff00000209400ULL,
0x0000005300857306ULL, 0x000ff00000205400ULL, 0x0000005300607306ULL, 0x000ff0000020d400ULL,
0x0000005800827306ULL, 0x000ff00000205400ULL, 0x00000058005f7306ULL, 0x000ff0000020d400ULL,
0x0000008b00587306ULL, 0x000ff00000209400ULL, 0x0000008b00537306ULL, 0x000ff00000205400ULL,
0x0000008b005b7306ULL, 0x000ff0000020d400ULL, 0x00000029008b7306ULL, 0x000e70000020d400ULL,
0x0000002a00b27306ULL, 0x000ff00000009400ULL, 0x0000002a00b57306ULL, 0x000ea20000005400ULL,
0x000000018b8b6812ULL, 0x002fce00078efcffULL, 0x0000008900287306ULL, 0x000ff00000209400ULL,
0x0000008900b77306ULL, 0x000e620000205400ULL, 0x000000b5b200720bULL, 0x004fce0003fbd000ULL,
0x0000002a00777306ULL, 0x0004f0000000d400ULL, 0x00000089008a7306ULL, 0x000f22000020d400ULL,
0x000000b72800720bULL, 0x002fe20003fdd000ULL, 0x000100002a2a7824ULL, 0x004fc400078e00ffULL,
0x000001002f287824ULL, 0x000fc600078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002b00b67306ULL, 0x000fe20000009400ULL, 0x0000000177775812ULL, 0x008fe400078efcffULL,
0x00000018ffac7819ULL, 0x000fe20000011428ULL, 0x000100002e287824ULL, 0x000fc800078e00ffULL,
0x0000002b00b97306ULL, 0x000e620000005400ULL, 0x000000018a8a6812ULL, 0x010fe400078efcffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x000000778a8a723eULL, 0x000fc600000010ffULL,
0x000000b800ba7306ULL, 0x000ff00000209400ULL, 0x000000b800bb7306ULL, 0x000ea20000205400ULL,
0x000000b9b600720bULL, 0x002fce0003fbd000ULL, 0x0000002b00767306ULL, 0x0002f0000000d400ULL,
0x000000b800917306ULL, 0x000f22000020d400ULL, 0x000000bbba00720bULL, 0x004fe20003fdd000ULL,
0x000100002b2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002a00297306ULL, 0x000fe20000209400ULL, 0x0000000176765812ULL, 0x008fe400078efcffULL,
0x000000a5a400720bULL, 0x000fca0003fbd000ULL, 0x0000002a00b47306ULL, 0x000e620000205400ULL,
0x0000000191916812ULL, 0x010fce00078efcffULL, 0x0000002a008c7306ULL, 0x0004e2000020d400ULL,
0x0000000173735812ULL, 0x000fce00078efcffULL, 0x0000005600a37306ULL, 0x000fe20000209400ULL,
0x000000b42900720bULL, 0x002fe20003fdd000ULL, 0x000001002d2a7824ULL, 0x004fe400078e00ffULL,
0x000100002f297824ULL, 0x000fc600078e00ffULL, 0x00000018ffa07819ULL, 0x000fe2000001142aULL,
0x0000005600a27306ULL, 0x000e620000205400ULL, 0x000100002c2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc80000011429ULL, 0x000000018c8c6812ULL, 0x008fe400078efcffULL,
0x0000002b00bc7306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x000fce000001142aULL,
0x0000002b00bd7306ULL, 0x000ea20000205400ULL, 0x000000a2a300720bULL, 0x002fe20003fbd000ULL,
0x0000010040a27824ULL, 0x000fca00078e00ffULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x0000005600727306ULL, 0x0002f0000020d400ULL, 0x0000002b00897306ULL, 0x000f22000020d400ULL,
0x000000bdbc00720bULL, 0x004fc40003fdd000ULL, 0x00000018ff567819ULL, 0x002fca000001142fULL,
0x0000002c009b7306ULL, 0x000fe20000009400ULL, 0x0000000172725812ULL, 0x008fce00078efcffULL,
0x0000002c00967306ULL, 0x000e620000005400ULL, 0x0000000189896812ULL, 0x010fc800078efcffULL,
0x000000897289723eULL, 0x000fc600000010ffULL, 0x000000be00b87306ULL, 0x000ff00000209400ULL,
0x000000be00bf7306ULL, 0x000ea20000205400ULL, 0x000000969b00720bULL, 0x002fe20003fbd000ULL,
0x0001000040967824ULL, 0x000fca00078e00ffULL, 0x00000018ff967819ULL, 0x000fe20000011496ULL,
0x0000002c006f7306ULL, 0x000e70000000d400ULL, 0x000000be008e7306ULL, 0x000ee2000020d400ULL,
0x000000bfb800720bULL, 0x004fce0003fdd000ULL, 0x0000002d00957306ULL, 0x000fe20000009400ULL,
0x000000016f6f5812ULL, 0x002fce00078efcffULL, 0x0000002d00947306ULL, 0x000e620000005400ULL,
0x000000018e8e6812ULL, 0x008fce00078efcffULL, 0x000000a000a77306ULL, 0x000ff00000209400ULL,
0x000000a000c07306ULL, 0x000ea20000205400ULL, 0x000000949500720bULL, 0x002fce0003fbd000ULL,
0x0000002d006b7306ULL, 0x000e70000000d400ULL, 0x000000a0002c7306ULL, 0x000722000020d400ULL,
0x000000c0a700720bULL, 0x004fce0003fdd000ULL, 0x0000002a002b7306ULL, 0x000fe20000209400ULL,
0x000000016b6b5812ULL, 0x002fe200078efcffULL, 0x000001002ea07824ULL, 0x008fe200078e00ffULL,
0x0000009d9e00720bULL, 0x000fc80003fbd000ULL, 0x00000018ffab7819ULL, 0x000fe200000114a0ULL,
0x0000002a00a67306ULL, 0x000e620000205400ULL, 0x000000012c2c6812ULL, 0x010fce00078efcffULL,
0x0000002a002d7306ULL, 0x000ea2000020d400ULL, 0x000000016e6e5812ULL, 0x000fe400078efcffULL,
0x0000009c9f00720bULL, 0x000fca0003fbd000ULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x000000a62b00720bULL, 0x002fe20003fdd000ULL, 0x00010000412b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000000a800aa7306ULL, 0x000e620000205400ULL,
0x000000016a6a5812ULL, 0x000fca00078efcffULL, 0x000000012d2d6812ULL, 0x004fe400078efcffULL,
0x000000a800a17306ULL, 0x000ea4000020d400ULL, 0x0000002d6e6e723eULL, 0x000fcc00000010ffULL,
0x0000002e00937306ULL, 0x000fe20000009400ULL, 0x000000aaa900720bULL, 0x002fce0003fdd000ULL,
0x0000002e00907306ULL, 0x000e6c0000005400ULL, 0x00000001a1a16812ULL, 0x004fe400078efcffULL,
0x000000ab002a7306ULL, 0x000ff00000209400ULL, 0x000000ab00ad7306ULL, 0x000ea20000205400ULL,
0x000000909300720bULL, 0x002fce0003fbd000ULL, 0x0000002e00697306ULL, 0x000e70000000d400ULL,
0x000000ab00a07306ULL, 0x000ee2000020d400ULL, 0x000000ad2a00720bULL, 0x004fce0003fdd000ULL,
0x0000002f008f7306ULL, 0x000fe20000009400ULL, 0x0000000169695812ULL, 0x002fce00078efcffULL,
0x0000002f004a7306ULL, 0x000e620000005400ULL, 0x00000001a0a06812ULL, 0x008fc800078efcffULL,
0x00000069a0a0723eULL, 0x000fc600000010ffULL, 0x000000ac00ae7306ULL, 0x000ff00000209400ULL,
0x000000ac00af7306ULL, 0x000ea20000205400ULL, 0x0000004a8f00720bULL, 0x002fce0003fbd000ULL,
0x0000002f00657306ULL, 0x000e70000000d400ULL, 0x000000ac002e7306ULL, 0x000ee2000020d400ULL,
0x000000afae00720bULL, 0x004fce0003fdd000ULL, 0x0000002800a87306ULL, 0x000fe20000209400ULL,
0x0000000165655812ULL, 0x002fe400078efcffULL, 0x000000989900720bULL, 0x000fca0003fbd000ULL,
0x0000002800ab7306ULL, 0x000e620000205400ULL, 0x000000012e2e6812ULL, 0x008fce00078efcffULL,
0x00000028002f7306ULL, 0x000ea2000020d400ULL, 0x0000000168685812ULL, 0x000fce00078efcffULL,
0x00000056009a7306ULL, 0x000fe20000209400ULL, 0x000000aba800720bULL, 0x002fce0003fdd000ULL,
0x0000005600977306ULL, 0x000e6c0000205400ULL, 0x000000012f2f6812ULL, 0x004fe400078efcffULL,
0x0000002900a47306ULL, 0x000fe40000209400ULL, 0x0000002f6868723eULL, 0x000fcc00000010ffULL,
0x0000002900a57306ULL, 0x000ea20000205400ULL, 0x000000979a00720bULL, 0x002fce0003fbd000ULL,
0x0000005600647306ULL, 0x0002f0000020d400ULL, 0x0000002900a37306ULL, 0x0008e2000020d400ULL,
0x000000a5a400720bULL, 0x004fe40003fdd000ULL, 0x00000018ff567819ULL, 0x002fca0000011443ULL,
0x0000004000487306ULL, 0x000fe20000009400ULL, 0x0000010041297824ULL, 0x010fe200078e00ffULL,
0x0000000164645812ULL, 0x008fc800078efcffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000004000497306ULL, 0x000e620000005400ULL, 0x00000001a3a36812ULL, 0x000fc800078efcffULL,
0x000000a36469723eULL, 0x000fc600000010ffULL, 0x000000a200287306ULL, 0x000ff00000209400ULL,
0x000000a200b17306ULL, 0x000ea20000205400ULL, 0x000000494800720bULL, 0x002fe40003fbd000ULL,
0x012800004b48783bULL, 0x000e6a0000000200ULL, 0x0000004000617306ULL, 0x000ef0000000d400ULL,
0x0000004100817306ULL, 0x000fe20000009400ULL, 0x000000b12800720bULL, 0x004fce0003fdd000ULL,
0x00000041007e7306ULL, 0x000ea20000005400ULL, 0x0000000161615812ULL, 0x008fe400078efcffULL,
0x000000858600720bULL, 0x000fca0003fbd000ULL, 0x0000004100307306ULL, 0x000ff0000000d400ULL,
0x000000a200407306ULL, 0x000ee2000020d400ULL, 0x0000000160605812ULL, 0x000fe400078efcffULL,
0x0000007e8100720bULL, 0x004fe20003fbd000ULL, 0x0000004548488231ULL, 0x002fc400003400ffULL,
0x000000454a4a8231ULL, 0x000fe400003400ffULL, 0x00000096009b7306ULL, 0x000fe20000209400ULL,
0x0000004649498231ULL, 0x080fe400003400ffULL, 0x000000464b4b8231ULL, 0x000fca00003400ffULL,
0x0000009600ac7306ULL, 0x000e620000205400ULL, 0x0000000140406812ULL, 0x008fe400078efcffULL,
0x0000000130305812ULL, 0x000fe400078efcffULL, 0x000000614040723eULL, 0x000fc600000010ffULL,
0x0000002900a27306ULL, 0x000ff00000209400ULL, 0x0000002900a77306ULL, 0x000fe20000205400ULL,
0x000000ac9b00720bULL, 0x002fe20003fdd000ULL, 0x00000100259b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe2000001149bULL, 0x0000002900417306ULL, 0x0003f0000020d400ULL,
0x0000009600957306ULL, 0x0004e2000020d400ULL, 0x0000010043297824ULL, 0x002fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe40000011429ULL, 0x0000004200807306ULL, 0x000fe20000009400ULL,
0x0000010042967824ULL, 0x004fca00078e00ffULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x00000042007f7306ULL, 0x000fe20000005400ULL, 0x0000000195956812ULL, 0x008fe400078efcffULL,
0x000000a7a200720bULL, 0x000fe40003fdd000ULL, 0x000000956060723eULL, 0x000fc600000010ffULL,
0x0000004200317306ULL, 0x0003f0000000d400ULL, 0x0000002a00a97306ULL, 0x000fe20000209400ULL,
0x0001000042427824ULL, 0x002fe200078e00ffULL, 0x0000000141416812ULL, 0x000fc400078efcffULL,
0x000000848700720bULL, 0x000fe40003fdd000ULL, 0x00000018ff297819ULL, 0x000fe40000011442ULL,
0x0000002a00aa7306ULL, 0x000e620000205400ULL, 0x000000304141723eULL, 0x000fce00000010ffULL,
0x0000002a008f7306ULL, 0x0004e2000020d400ULL, 0x0000000155556812ULL, 0x000fce00078efcffULL,
0x0000002b009d7306ULL, 0x000fe20000209400ULL, 0x00000100242a7824ULL, 0x004fe200078e00ffULL,
0x000000aaa900720bULL, 0x002fc80003fdd000ULL, 0x00000018ff997819ULL, 0x000fe4000001142aULL,
0x0000002b009e7306ULL, 0x000e6e0000205400ULL, 0x000000018f8f6812ULL, 0x008fe200078efcffULL,
0x0000002b00947306ULL, 0x000ea2000020d400ULL, 0x000000828300720bULL, 0x000fce0003fdd000ULL,
0x0000002900937306ULL, 0x000fe20000209400ULL, 0x0000009e9d00720bULL, 0x002fca0003fbd000ULL,
0x000000015f5f6812ULL, 0x000fe400078efcffULL, 0x0000002900a67306ULL, 0x000e6c0000205400ULL,
0x0000000194945812ULL, 0x004fe400078efcffULL, 0x0000002900427306ULL, 0x0004e2000020d400ULL,
0x0000007f8000720bULL, 0x000fc40003fbd000ULL, 0x000000945561723eULL, 0x000fca00000010ffULL,
0x00000096009c7306ULL, 0x000fe20000209400ULL, 0x012800004728783bULL, 0x004eaa0000000200ULL,
0x0000000131315812ULL, 0x000fe400078efcffULL, 0x00000096009f7306ULL, 0x000f220000205400ULL,
0x000000a69300720bULL, 0x002fce0003fbd000ULL, 0x0000009600907306ULL, 0x000e6c000020d400ULL,
0x0000000142425812ULL, 0x008fe400078efcffULL, 0x00000043007c7306ULL, 0x000fe40000009400ULL,
0x000000425f42723eULL, 0x000fcc00000010ffULL, 0x00000043007d7306ULL, 0x000ef00000005400ULL,
0x00000043003a7306ULL, 0x0003e2000000d400ULL, 0x0000004528288231ULL, 0x084fe400003400ffULL,
0x000000452a2a8231ULL, 0x000fc400003400ffULL, 0x0000004629298231ULL, 0x080fe400003400ffULL,
0x000000462b2b8231ULL, 0x000fe200003400ffULL, 0x0000009f9c00720bULL, 0x010fe20003f1d000ULL,
0x0001000043437824ULL, 0x002fe200078e00ffULL, 0x0000005600757306ULL, 0x000fe80000209400ULL,
0x00000018ff967819ULL, 0x000fe20000011443ULL, 0x000000682810723cULL, 0x000fe60000041810ULL,
0x0000005600747306ULL, 0x000e660000205400ULL, 0x0000000190900812ULL, 0x000fc400078efcffULL,
0x0000007d7c00720bULL, 0x008fc60003f1d000ULL, 0x0000009600987306ULL, 0x000ff00000209400ULL,
0x0000009600977306ULL, 0x000ea20000205400ULL, 0x000000747500720bULL, 0x002fe40003fbd000ULL,
0x000000013a3a0812ULL, 0x000fc800078efcffULL, 0x0000003a8f8f723eULL, 0x000fe200000010ffULL,
0x00000099009a7306ULL, 0x000ff00000209400ULL, 0x0000009900a57306ULL, 0x000e620000205400ULL,
0x000000979800720bULL, 0x004fce0003f1d000ULL, 0x0000009600437306ULL, 0x000eb0000020d400ULL,
0x00000056005a7306ULL, 0x000ee2000020d400ULL, 0x000000a59a00720bULL, 0x002fce0003fdd000ULL,
0x0000009900967306ULL, 0x000e62000020d400ULL, 0x0000000143430812ULL, 0x004fce00078efcffULL,
0x0000002400717306ULL, 0x000fe20000009400ULL, 0x000000015a5a5812ULL, 0x008fc800078efcffULL,
0x000000435a43723eULL, 0x000fc600000010ffULL, 0x0000002400707306ULL, 0x000ea20000005400ULL,
0x0000000196966812ULL, 0x002fce00078efcffULL, 0x00000025006c7306ULL, 0x000ff00000009400ULL,
0x00000025006d7306ULL, 0x000e620000005400ULL, 0x000000707100720bULL, 0x004fce0003f1d000ULL,
0x0000009b00857306ULL, 0x000ff00000209400ULL, 0x0000009b00867306ULL, 0x000ea20000205400ULL,
0x0000006d6c00720bULL, 0x002fce0003fbd000ULL, 0x00000024003b7306ULL, 0x0002f0000000d400ULL,
0x00000025003f7306ULL, 0x0008e2000000d400ULL, 0x0001000024247824ULL, 0x002fe200078e00ffULL,
0x000000868500720bULL, 0x004fc80003fdd000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000009b00a27306ULL, 0x000e62000020d400ULL, 0x0001000025257824ULL, 0x010fe200078e00ffULL,
0x000000013b3b0812ULL, 0x008fc800078efcffULL, 0x00000018ff847819ULL, 0x000fe20000011425ULL,
0x0000010026257824ULL, 0x000fe200078e00ffULL, 0x0000005d00667306ULL, 0x000fe20000209400ULL,
0x000000013f3f5812ULL, 0x000fe400078efcffULL, 0x0000003b9696723eULL, 0x000fe400000010ffULL,
0x00000018ff7c7819ULL, 0x000fe40000011425ULL, 0x000000799225723eULL, 0x000fe200000010ffULL,
0x0000005d00677306ULL, 0x000ea20000205400ULL, 0x00000001a2a26812ULL, 0x002fc800078efcffULL,
0x0000003fa297723eULL, 0x000fc600000010ffULL, 0x0000002400477306ULL, 0x000ff00000209400ULL,
0x00000024007e7306ULL, 0x000e620000205400ULL, 0x000000676600720bULL, 0x004fce0003fdd000ULL,
0x0000008400877306ULL, 0x000ff00000209400ULL, 0x00000084009c7306ULL, 0x000ea20000205400ULL,
0x0000007e4700720bULL, 0x002fce0003f1d000ULL, 0x0000002400817306ULL, 0x0002f0000020d400ULL,
0x0000005d005c7306ULL, 0x000f22000020d400ULL, 0x0000007b8824723eULL, 0x002fe400000010ffULL,
0x0000008b787b723eULL, 0x000fc400000010ffULL, 0x0000009c8700720bULL, 0x004fe40003fbd000ULL,
0x0000008c7388723eULL, 0x000fe200000010ffULL, 0x00000084007f7306ULL, 0x000e62000020d400ULL,
0x00000024280c723cULL, 0x040b62000004180cULL, 0x0000000181810812ULL, 0x008fe400078efcffULL,
0x000000626300720bULL, 0x000fe40003f1d000ULL, 0x00000076918b723eULL, 0x000fe400000010ffULL,
0x00000026004c7306ULL, 0x000fe20000009400ULL, 0x0000010027247824ULL, 0x020fe200078e00ffULL,
0x0000006b2c25723eULL, 0x000fe200000010ffULL, 0x0000007a2820723cULL, 0x000f620000041820ULL,
0x000000015c5c6812ULL, 0x010fc400078efcffULL, 0x00000018ff737819ULL, 0x000fe40000011424ULL,
0x00000026004d7306ULL, 0x000ea20000005400ULL, 0x0000006f8e24723eULL, 0x000fe400000010ffULL,
0x000000017f7f5812ULL, 0x002fe200078efcffULL, 0x0000008a2804723cULL, 0x000f620000041804ULL,
0x000000a16a6f723eULL, 0x000fe400000010ffULL, 0x000000652ea1723eULL, 0x000fe200000010ffULL,
0x0000007c00797306ULL, 0x000fe20000209400ULL, 0x0000000154540812ULL, 0x000fc400078efcffULL,
0x00000031908e723eULL, 0x000fe200000010ffULL, 0x000000242818723cULL, 0x000fe20000041818ULL,
0x000000815c5c723eULL, 0x000fc600000010ffULL, 0x0000007c00787306ULL, 0x000e620000205400ULL,
0x0000004d4c00720bULL, 0x004fc60003fdd000ULL, 0x00000088281c723cULL, 0x040f68000004181cULL,
0x00000026004e7306ULL, 0x0004e8000000d400ULL, 0x0000006e2808723cULL, 0x000fe80000041808ULL,
0x0000007c00757306ULL, 0x000f22000020d400ULL, 0x0001000026267824ULL, 0x004fe200078e00ffULL,
0x000000787900720bULL, 0x002fc40003fbd000ULL, 0x000000a02814723cULL, 0x000b640000041814ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000027004f7306ULL, 0x000fe20000009400ULL,
0x000000014e4e6812ULL, 0x008fc600078efcffULL, 0x00000040480c723cULL, 0x000b68000004180cULL,
0x0000002700527306ULL, 0x000e620000005400ULL, 0x0000000175755812ULL, 0x010fc600078efcffULL,
0x000000604820723cULL, 0x020b620000041820ULL, 0x0000004e754e723eULL, 0x000fc600000010ffULL,
0x0000007300727306ULL, 0x000fe80000209400ULL, 0x0000008e4804723cULL, 0x000b680000041804ULL,
0x00000073006b7306ULL, 0x000ea20000205400ULL, 0x000000524f00720bULL, 0x002fc60003fbd000ULL,
0x00000042481c723cULL, 0x040b68000004181cULL, 0x0000002600247306ULL, 0x000fe80000209400ULL,
0x000000964818723cULL, 0x000b680000041818ULL, 0x0000002600257306ULL, 0x000e620000205400ULL,
0x0000006b7200720bULL, 0x004fce0003f1d000ULL, 0x0000002700517306ULL, 0x0004f0000000d400ULL,
0x00000073002c7306ULL, 0x000f22000020d400ULL, 0x0001000027277824ULL, 0x004fe200078e00ffULL,
0x000000252400720bULL, 0x002fc80003fdd000ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002600287306ULL, 0x000e62000020d400ULL, 0x0000000151515812ULL, 0x008fce00078efcffULL,
0x0000005e00567306ULL, 0x000fe20000209400ULL, 0x000000012c2c0812ULL, 0x010fe400078efcffULL,
0x000000535800720bULL, 0x000fe40003f1d000ULL, 0x000000512c4f723eULL, 0x000fc600000010ffULL,
0x0000005e005d7306ULL, 0x000ea20000205400ULL, 0x0000000128286812ULL, 0x002fc600078efcffULL,
0x0000004e4814723cULL, 0x000b680000041814ULL, 0x0000002700297306ULL, 0x000fe20000209400ULL,
0x000000015b5b0812ULL, 0x000fc800078efcffULL, 0x000000285b28723eULL, 0x000fc600000010ffULL,
0x0000002700267306ULL, 0x000e620000205400ULL, 0x0000005d5600720bULL, 0x004fe40003fbd000ULL,
0x0000007f545d723eULL, 0x000fca00000010ffULL, 0x0000005e005e7306ULL, 0x000ea4000020d400ULL,
0x0000005c4808723cULL, 0x000b6c0000041808ULL, 0x0000002700277306ULL, 0x000ee2000020d400ULL,
0x000000262900720bULL, 0x002fe40003fdd000ULL, 0x000000015e5e5812ULL, 0x004fd600078efcffULL,
0x0000000127276812ULL, 0x008fc800078efcffULL, 0x000000275e29723eULL, 0x000fce00000010ffULL,
0x000000284810723cULL, 0x000b620000041810ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000003e3e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a00050ff7f8cULL, 0x0005e2000c80043fULL,
0x000000013d257812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x002fc400078e003fULL,
0x000000013c3c7810ULL, 0x008fc80007ffe0ffULL, 0x000000033c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff287000007947ULL, 0x000fea000383ffffULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x000000ffff297224ULL, 0x020fe400078e0016ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0013ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff287224ULL, 0x000fe400078e0017ULL, 0x000000ffff267224ULL, 0x000fe400078e0015ULL,
0x000000ffff277224ULL, 0x000fc400078e0014ULL, 0x000000ffff247224ULL, 0x008fe400078e000bULL,
0x000000ffff167224ULL, 0x000fe400078e0009ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0011ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e000aULL,
0x000000ffff177224ULL, 0x000fc400078e0008ULL, 0x000000ffff147224ULL, 0x000fe400078e0007ULL,
0x000000ffff157224ULL, 0x000fe400078e0006ULL, 0x000000ffff127224ULL, 0x000fe400078e0005ULL,
0x000000ffff137224ULL, 0x000fe400078e0004ULL, 0x000000ffff0b7224ULL, 0x000fe400078e000eULL,
0x000000ffff097224ULL, 0x000fe200078e000cULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000039007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000e91000047802ULL, 0x000fc40000000f00ULL,
0x00008b3000007944ULL, 0x006fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003900007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x008fc80000000039ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x008fe200078ff0ffULL,
0x0000000003057220ULL, 0x014fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000000900097220ULL, 0x042fe40000410000ULL,
0x0000000d000d7220ULL, 0x040fe40000410000ULL, 0x0000002000207220ULL, 0x040fe40000410000ULL,
0x0000002100217220ULL, 0x000fc40000410000ULL, 0x0000001300137220ULL, 0x040fe40000410000ULL,
0x0000001200127220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x040fe40000410000ULL,
0x0000001d001d7220ULL, 0x040fe40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x000fc40000410000ULL, 0x0000001700177220ULL, 0x040fe40000410000ULL,
0x0000001600167220ULL, 0x040fe40000410000ULL, 0x0000002700277220ULL, 0x040fe40000410000ULL,
0x0000002600267220ULL, 0x040fe40000410000ULL, 0x0000002b002b7220ULL, 0x040fe40000410000ULL,
0x0000002a002a7220ULL, 0x000fc40000410000ULL, 0x0000000b040b7220ULL, 0x044fe40000410000ULL,
0x0000000f040f7220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x040fe40000410000ULL, 0x0000001504157220ULL, 0x040fe40000410000ULL,
0x0000001404147220ULL, 0x000fc40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x040fe40000410000ULL, 0x0000002504257220ULL, 0x040fe40000410000ULL,
0x0000002404247220ULL, 0x000fc40000410000ULL, 0x0000002904297220ULL, 0x040fe40000410000ULL,
0x0000002804287220ULL, 0x040fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000002c042c7220ULL, 0x000fc40000410000ULL, 0x00000000002e7919ULL, 0x000ee80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000082e057811ULL, 0x008fc400078ff0ffULL,
0x00000002ff077819ULL, 0x000fe4000001162eULL, 0x000000022e007812ULL, 0x000fe200078ec0ffULL,
0x0000000805087824ULL, 0x000fe400078e00ffULL, 0x0000000807117824ULL, 0x040fe200078e00ffULL,
0x0000000700027211ULL, 0x040fe200078ff8ffULL, 0x00000008070c7824ULL, 0x040fe200078e00ffULL,
0x0000000500037211ULL, 0x000fe200078ff8ffULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000000202007810ULL, 0x000fc40007ffe0ffULL, 0xfffffff808087812ULL, 0x000fe200078ee203ULL,
0x0000000807037824ULL, 0x000fe200078e00ffULL, 0xfffffff805067812ULL, 0x000fe200078ee200ULL,
0x0000100037057824ULL, 0x000fe200078e00ffULL, 0x0000000402047810ULL, 0x000fe40007ffe0ffULL,
0xfffffff803007812ULL, 0x000fe200078ee202ULL, 0x0000080034037824ULL, 0x000fe200078e0205ULL,
0x0000000602077810ULL, 0x000fe20007ffe0ffULL, 0x000000082e027824ULL, 0x000fe200078e00ffULL,
0xfffffff8110a7812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e0203ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x00000010080e7824ULL, 0x100fe200078e0203ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x0000001006087824ULL, 0x100fe200078e0203ULL,
0x000000090d00723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0x000000202102723eULL, 0x000fe200000010ffULL, 0x0000000104067824ULL, 0x000fe200078e0207ULL,
0x000000171604723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x0000541000107816ULL, 0x040fe20000000002ULL, 0x00000001070e7824ULL, 0x040fe200078e020eULL,
0x0000763200117816ULL, 0x000fe20000000002ULL, 0x0000000107087824ULL, 0x040fe200078e0208ULL,
0x000000131200723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x0000001c1d02723eULL, 0x000fe200000010ffULL, 0x0000001006007388ULL, 0x0007e20000000a00ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000181903723eULL, 0x000fc400000010ffULL,
0x0000763200077816ULL, 0x140fe40000000002ULL, 0x0000541000067816ULL, 0x008fe40000000002ULL,
0x000000272600723eULL, 0x000fe400000010ffULL, 0x0000002b2a02723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x0007e40000000a00ULL, 0x0000541003067816ULL, 0x148fe40000000004ULL,
0x0000763203077816ULL, 0x000fc40000000004ULL, 0x0000000b0f03723eULL, 0x000fe400000010ffULL,
0x000000222304723eULL, 0x000fe200000010ffULL, 0x000000060a007388ULL, 0x0007e40000000a00ULL,
0x0000541000067816ULL, 0x148fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x000000151400723eULL, 0x000fe400000010ffULL, 0x0000001e1f02723eULL, 0x000fe200000010ffULL,
0x000000060c007388ULL, 0x0007e40000000a00ULL, 0x0000541003067816ULL, 0x008fc40000000004ULL,
0x0000763203077816ULL, 0x000fe40000000004ULL, 0x0000001a1b03723eULL, 0x000fe400000010ffULL,
0x000000252404723eULL, 0x000fe200000010ffULL, 0x000000060e007388ULL, 0x0007e40000000a00ULL,
0x0000541000067816ULL, 0x148fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x000000292800723eULL, 0x000fc400000010ffULL, 0x0000002d2c02723eULL, 0x000fe200000010ffULL,
0x0004000608007388ULL, 0x0007e40000000a00ULL, 0x0000541003067816ULL, 0x148fe40000000004ULL,
0x0000763203077816ULL, 0x000fe20000000004ULL, 0x0000000135047824ULL, 0x000fe200078e022eULL,
0x000000ff00037306ULL, 0x000fe60000205400ULL, 0x000400060a007388ULL, 0x0007e20000000a00ULL,
0x0000001004047824ULL, 0x000fe200078e0205ULL, 0x0000541000067816ULL, 0x008fc40000000002ULL,
0x0000763200077816ULL, 0x000fe40000000002ULL, 0x000000ff00007306ULL, 0x000ee60000209400ULL,
0x000400060c007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000004107984ULL, 0x000f220000000c00ULL, 0x000000ff00027306ULL, 0x000e62000020d400ULL,
0x000000030000720bULL, 0x008fc40003f1d000ULL, 0x0004000004087984ULL, 0x000ee80000000c00ULL,
0x0008000004147984ULL, 0x000ea80000000c00ULL, 0x000c000004187984ULL, 0x000ea60000000c00ULL,
0x0000000102020812ULL, 0x002fc400078efcffULL, 0x000000ff3400720cULL, 0x000fe40003f05270ULL,
0x000000020202723eULL, 0x000fca00000010ffULL, 0x3f803f8002137831ULL, 0x050fe40000200013ULL,
0x3f803f8002127831ULL, 0x040fe40000200012ULL, 0x3f803f8002117831ULL, 0x040fe40000200011ULL,
0x3f803f8002107831ULL, 0x040fe40000200010ULL, 0x3f803f80020b7831ULL, 0x048fe4000020000bULL,
0x3f803f80020a7831ULL, 0x000fc4000020000aULL, 0x3f803f8002097831ULL, 0x040fe40000200009ULL,
0x3f803f8002087831ULL, 0x000fe40000200008ULL, 0x3f803f8013137831ULL, 0x004fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fe40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fc40000200014ULL, 0x3f803f800b0b7831ULL, 0x000fe4000020001bULL,
0x3f803f800a0a7831ULL, 0x000fe2000020001aULL, 0x0000001004007388ULL, 0x000fe20000000c00ULL,
0x3f803f8009097831ULL, 0x000fe40000200019ULL, 0x3f803f8008087831ULL, 0x000fca0000200018ULL,
0x0004000804007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000202e067810ULL, 0x000fe20007ffe0ffULL,
0x0000000000047919ULL, 0x000e620000002600ULL, 0x00000003ff117819ULL, 0x000fe2000001162eULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff037819ULL, 0x000fe20000011606ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000111007824ULL, 0x000fe200078e022eULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000106027824ULL, 0x000fc600078e0203ULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0000000702077812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800007812ULL, 0x000fe400078ef82eULL, 0x0ffffff807027812ULL, 0x000fc600078ef806ULL,
0x0000001000007824ULL, 0x100fe400078e0205ULL, 0x0000001002057824ULL, 0x000fe400078e0205ULL,
0x0000000804027824ULL, 0x042fe200078e00ffULL, 0x0000000000087984ULL, 0x0002e20000000c00ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0x00000000050c7984ULL, 0x0005220000000c00ULL, 0xfffffff802027812ULL, 0x000fe200078ee211ULL,
0x0000000837117824ULL, 0x040fe200078e00ffULL, 0xfffffff804037812ULL, 0x000fe200078ee203ULL,
0x0000000837377824ULL, 0x000fe200078e00ffULL, 0x0000000402077c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000403107c10ULL, 0x000fc6000ff3e0ffULL, 0x000000ffff007224ULL, 0x002fe200000e06ffULL,
0x00005a0007027a11ULL, 0x040fe200078040ffULL, 0x000000ffff057224ULL, 0x004fe200008e06ffULL,
0x00005a0010047a11ULL, 0x040fe400078240ffULL, 0x00005b0007037a11ULL, 0x000fe400000f4400ULL,
0xfffffff811077812ULL, 0x000fe400078ee22eULL, 0x00005b0010057a11ULL, 0x000fe400008f4405ULL,
0xfffffff837117812ULL, 0x000fe200078ee206ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x008fe8000c101d06ULL,
0x0000000c04007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604377981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000236077824ULL, 0x000fe200078e00ffULL,
0x01760000ff047f8cULL, 0x002e62000c80043fULL, 0x0000004000357824ULL, 0x000fe400078e00ffULL,
0x0000580007347a24ULL, 0x000fc800078e0234ULL, 0x00006200341b7a24ULL, 0x000fc800078e0235ULL,
0x00000b9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff2f7819ULL, 0x100fe20000011632ULL,
0x00000080ff317424ULL, 0x000fe200078e00ffULL, 0x000000700e337812ULL, 0x000fe400078ec0ffULL,
0x000000042f097810ULL, 0x040fe20007ffe0ffULL, 0x000000012f167824ULL, 0x140fe200078e0232ULL,
0x000000082f0d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c2f0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109067824ULL, 0x100fe200078e0232ULL, 0x000000102f0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000809197824ULL, 0x000fe200078e00ffULL, 0x000000142f177810ULL, 0x000fe20007ffe0ffULL,
0x000000010d077824ULL, 0x000fe200078e0232ULL, 0x000000182f297810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee206ULL,
0x000000010f087824ULL, 0x040fe200078e0232ULL, 0x0000003502067217ULL, 0x000fe20007800000ULL,
0x000000080f237824ULL, 0x000fe200078e00ffULL, 0xfffffff80a217812ULL, 0x000fe200078ee207ULL,
0x000000011b077824ULL, 0x000fe200078e022fULL, 0x0000001c2f2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001061a7824ULL, 0x000fe200078e0a35ULL, 0xfffffff823237812ULL, 0x000fe200078ee208ULL,
0x00005e0007067625ULL, 0x000fe200078e0031ULL, 0x00001000001c7811ULL, 0x000fc400078e70ffULL,
0x0000001a0900720cULL, 0x080fe20003f86070ULL, 0x000000011b087824ULL, 0x040fe200078e0209ULL,
0x00000033060c7210ULL, 0x000fe20007f1e0ffULL, 0x000000011b097824ULL, 0x000fe200078e020dULL,
0x0000001a0d00720cULL, 0x080fe20003f46070ULL, 0x000000010b0a7824ULL, 0x000fe200078e0232ULL,
0x0000001a0f00720cULL, 0x080fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0607ULL,
0x0000001a0b00720cULL, 0x000fe20003f06070ULL, 0x00005e0008067625ULL, 0x000fe200078e0031ULL,
0x000000202f2d7810ULL, 0x000fc60007ffe0ffULL, 0x000000080b257824ULL, 0x000fe200078e00ffULL,
0x00000033060e7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0009087625ULL, 0x000fc600078e0031ULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000011b0a7824ULL, 0x040fe200078e020fULL,
0x0000003308107210ULL, 0x000fe20007fbe0ffULL, 0x000000011b087824ULL, 0x000fe400078e020bULL,
0x000000ffff0f7224ULL, 0x000fe400008e0607ULL, 0x00005e000a067625ULL, 0x000fc800078e0031ULL,
0x000000011b0b7824ULL, 0x000fe200078e0217ULL, 0x0000003306127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe400028e0609ULL, 0x00005e0008087625ULL, 0x000fc800078e0031ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0031ULL, 0x0000003308147210ULL, 0x000fc60007fbe0ffULL,
0x000000011b067824ULL, 0x000fe200078e0229ULL, 0x000000330a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0607ULL, 0x0000001a1700720cULL, 0x000fe20003f26070ULL,
0x00005e0006067625ULL, 0x000fc800078e0031ULL, 0x000000ffff157224ULL, 0x000fe200028e0609ULL,
0x0000000716097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000001a2f00720cULL, 0x000fe20003fa6070ULL, 0x0000000117087824ULL, 0x100fe200078e0232ULL,
0x0000003306167210ULL, 0x000fe20007fde0ffULL, 0x000000011b067824ULL, 0x000fe200078e022bULL,
0x0ffffff809097812ULL, 0x000fe200078ef832ULL, 0x0000000817277824ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400030e0607ULL, 0x00000010091d7824ULL, 0x000fe200078e021cULL,
0xfffffff827277812ULL, 0x000fe200078ee208ULL, 0x00005e0006067625ULL, 0x000fc600078e0031ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1d7faeULL, 0x0005e2000e901c46ULL,
0x00000010191f7824ULL, 0x000fe200078e021cULL, 0x0000003306187210ULL, 0x000fe20007fde0ffULL,
0x000000011b087824ULL, 0x000fe200078e022dULL, 0x0000001a2900720cULL, 0x080fe20003fa6070ULL,
0x000000012b067824ULL, 0x040fe200078e0232ULL, 0x000000000e1f7faeULL, 0x0007e2000e101c46ULL,
0x00005e0008087625ULL, 0x000fe200078e0031ULL, 0x0000001a2b00720cULL, 0x000fc60003f86070ULL,
0x00000001291e7824ULL, 0x000fe400078e0232ULL, 0x000000082b1d7824ULL, 0x004fe400078e00ffULL,
0x0000000829297824ULL, 0x000fe400078e00ffULL, 0x000000ffff197224ULL, 0x000fe200030e0607ULL,
0x000000242f1f7810ULL, 0x008fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e021cULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x0000001023237824ULL, 0x000fe200078e021cULL,
0x0000003308087210ULL, 0x000fe20007fde0ffULL, 0x000000011b067824ULL, 0x000fe200078e021fULL,
0xfffffff8290f7812ULL, 0x000fe200078ee21eULL, 0x000000012d0d7824ULL, 0x000fe200078e0232ULL,
0x0000000010217faeULL, 0x0005e2000d101c46ULL, 0x00005e0006067625ULL, 0x000fe200078e0031ULL,
0x0000001a1f00720cULL, 0x000fc40003f46070ULL, 0x0000000012237faeULL, 0x0007e2000d901c46ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x00000033060c7210ULL, 0x000fe20007fde0ffULL,
0x000000082d1e7824ULL, 0x040fe200078e00ffULL, 0x0000001a2d00720cULL, 0x080fe20003f66070ULL,
0x000000011f0e7824ULL, 0x000fe400078e0232ULL, 0x0000001025257824ULL, 0x100fe200078e021cULL,
0xfffffff81e117812ULL, 0x004fe200078ee20dULL, 0x000000ffff0d7224ULL, 0x000fe200030e0607ULL,
0x000000282f077810ULL, 0x000fe20007ffe0ffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000014257faeULL, 0x0005e2000c101c46ULL, 0x0000001027277824ULL, 0x100fe200078e021cULL,
0x0000001a0700720cULL, 0x000fe20003fc6070ULL, 0x000000100f0f7824ULL, 0x000fe200078e021cULL,
0xfffffff81f137812ULL, 0x008fe200078ee20eULL, 0x0000000107067824ULL, 0x000fe200078e0232ULL,
0x0000002c2f1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e021cULL,
0x000000000a277faeULL, 0x0007e2000c901c46ULL, 0x0000001011117824ULL, 0x100fe200078e021cULL,
0x000000302f217810ULL, 0x000fe20007ffe0ffULL, 0x0000001013137824ULL, 0x000fe200078e021cULL,
0x00000000160f7faeULL, 0x0003e2000e901c46ULL, 0x0000000807157824ULL, 0x004fe200078e00ffULL,
0x000000342f237810ULL, 0x000fe20007ffe0ffULL, 0x000000011b077824ULL, 0x000fe200078e0207ULL,
0x00000000181d7faeULL, 0x0005e2000e101c46ULL, 0x000000081f107824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee206ULL, 0x00005e0007067625ULL, 0x000fe200078e0031ULL,
0x0000000008117faeULL, 0x0005e2000d901c46ULL, 0x000000382f257810ULL, 0x000fc40007ffe0ffULL,
0x000000011f0b7824ULL, 0x108fe200078e0232ULL, 0x000000000c137faeULL, 0x0007e2000d101c46ULL,
0x00000033060a7210ULL, 0x000fe20007f5e0ffULL, 0x000000011b0e7824ULL, 0x000fe200078e0221ULL,
0x0000003c2f277810ULL, 0x000fe20007ffe0ffULL, 0x00000001210f7824ULL, 0x042fe200078e0232ULL,
0xfffffff810177812ULL, 0x000fe200078ee20bULL, 0x0000000821127824ULL, 0x000fe200078e00ffULL,
0x0000001a1f00720cULL, 0x080fe20003fa6070ULL, 0x000000011b087824ULL, 0x004fe200078e021fULL,
0x0000001a2100720cULL, 0x080fe20003f86070ULL, 0x000000ffff0b7224ULL, 0x000fe200010e0607ULL,
0x0000001a2300720cULL, 0x000fe20003f66070ULL, 0x00005e0008087625ULL, 0x000fe200078e0031ULL,
0xfffffff812137812ULL, 0x008fc400078ee20fULL, 0x0000001a2500720cULL, 0x080fe20003f26070ULL,
0x00005e000e067625ULL, 0x000fe200078e0031ULL, 0x00000033080c7210ULL, 0x080fe40007f5e0ffULL,
0x0000001a2700720cULL, 0x000fe20003f06070ULL, 0x000000011b087824ULL, 0x000fe400078e0223ULL,
0x00000001230f7824ULL, 0x040fe400078e0232ULL, 0x0000000823107824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0609ULL, 0x00000033060e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0031ULL, 0xfffffff810197812ULL, 0x000fc600078ee20fULL,
0x000000011b067824ULL, 0x000fe400078e0225ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0607ULL,
0x0000003308107210ULL, 0x000fe20007f5e0ffULL, 0x00005e0006067625ULL, 0x000fc800078e0031ULL,
0x000000011b147824ULL, 0x000fe400078e0227ULL, 0x000000ffff117224ULL, 0x000fe200010e0609ULL,
0x0000003306067210ULL, 0x000fe20007f5e0ffULL, 0x0000000125127824ULL, 0x140fe400078e0232ULL,
0x00000008251b7824ULL, 0x000fe400078e00ffULL, 0x0000000127327824ULL, 0x040fe400078e0232ULL,
0x00000008271d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee212ULL,
0x00005e0014087625ULL, 0x000fc600078e0031ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee232ULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x0000003308087210ULL, 0x000fe20007f5e0ffULL,
0x0000001015157824ULL, 0x100fe400078e021cULL, 0x0000001017177824ULL, 0x100fe400078e021cULL,
0x0000001013137824ULL, 0x100fe200078e021cULL, 0x000000000a157faeULL, 0x0003e2000f101c46ULL,
0x0000001019197824ULL, 0x100fe400078e021cULL, 0x000000101b1b7824ULL, 0x100fe200078e021cULL,
0x000000000c177faeULL, 0x0003e2000e901c46ULL, 0x000000101d1d7824ULL, 0x000fc400078e021cULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x000000000e137faeULL, 0x0003e8000e101c46ULL,
0x0000000010197faeULL, 0x0003e8000d901c46ULL, 0x00000000061b7faeULL, 0x0003e8000c901c46ULL,
0x00000000081d7faeULL, 0x0003e2000c101c46ULL, 0x00000a5000007947ULL, 0x000fea0003800000ULL,
0x00000010320c7811ULL, 0x040fe200078fe8ffULL, 0x00000080ff4b7424ULL, 0x000fe200078e00ffULL,
0x0000000432087811ULL, 0x000fc400078fe8ffULL, 0x00000008320a7811ULL, 0x000fe200078fe8ffULL,
0x000000010c107824ULL, 0x100fe200078e0232ULL, 0x0000000c320b7811ULL, 0x000fe200078fe8ffULL,
0x000000080c137824ULL, 0x000fe200078e00ffULL, 0x0000001832117811ULL, 0x000fe200078fe8ffULL,
0x0000000108067824ULL, 0x000fe200078e0232ULL, 0x0000001c32177811ULL, 0x000fe200078fe8ffULL,
0x00000008080d7824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee210ULL,
0x000000010a077824ULL, 0x000fe200078e0232ULL, 0x0000001432107811ULL, 0x000fe200078fe8ffULL,
0x000000080a127824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL,
0x000000010b097824ULL, 0x140fe200078e0232ULL, 0x00000024321f7811ULL, 0x000fe200078fe8ffULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0xfffffff8120f7812ULL, 0x000fe200078ee207ULL,
0x0000000110067824ULL, 0x100fe200078e0232ULL, 0x0000002832217811ULL, 0x000fe200078fe8ffULL,
0x0000000810197824ULL, 0x000fe200078e00ffULL, 0xfffffff814127812ULL, 0x000fe200078ee209ULL,
0x0000000111077824ULL, 0x040fe200078e0232ULL, 0x00000020321a7811ULL, 0x040fe200078fe8ffULL,
0x0000000811167824ULL, 0x000fe200078e00ffULL, 0xfffffff819147812ULL, 0x000fe200078ee206ULL,
0x0000000117097824ULL, 0x140fe200078e0232ULL, 0x0000002c32237811ULL, 0x000fe200078fe8ffULL,
0x0000000817187824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee207ULL,
0x000000011f067824ULL, 0x140fe200078e0232ULL, 0x0000003032257811ULL, 0x000fe200078fe8ffULL,
0x000000081f197824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x0000000121077824ULL, 0x040fe200078e0232ULL, 0x0000003432277811ULL, 0x000fe200078fe8ffULL,
0x0000000821227824ULL, 0x000fe200078e00ffULL, 0xfffffff819207812ULL, 0x000fe200078ee206ULL,
0x000000011a157824ULL, 0x100fe200078e0232ULL, 0x0000001b32067211ULL, 0x000fe200078fe8ffULL,
0x000000081a1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee207ULL,
0x0000000123097824ULL, 0x140fe200078e0232ULL, 0x0000003232077211ULL, 0x000fe200078fe8ffULL,
0x0000000823247824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee215ULL,
0x0000000125157824ULL, 0x040fe200078e0232ULL, 0x000000700e4d7812ULL, 0x000fe200078ec0ffULL,
0x0000000825287824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee209ULL,
0x000000011b197824ULL, 0x000fe200078e0211ULL, 0x0000000707097812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e004bULL, 0xfffffff828287812ULL, 0x000fc400078ee215ULL,
0x0000003832297811ULL, 0x000fe200078fe8ffULL, 0x000000011b157824ULL, 0x000fe200078e0210ULL,
0x0000004d06107210ULL, 0x000fe20007f1e0ffULL, 0x0000000127117824ULL, 0x040fe200078e0232ULL,
0x0000003c322b7811ULL, 0x000fe200078fe8ffULL, 0x0000000827307824ULL, 0x000fe200078e00ffULL,
0x0000100000497811ULL, 0x000fe200078e70ffULL, 0x000000011b087824ULL, 0x040fe400078e0208ULL,
0x000000011b1c7824ULL, 0x040fe200078e0217ULL, 0xfffffff830177812ULL, 0x000fe200078ee211ULL,
0x000000011b1d7824ULL, 0x000fc400078e021aULL, 0x000000011b2c7824ULL, 0x000fe400078e0229ULL,
0x00000001291a7824ULL, 0x000fe400078e0232ULL, 0x000000011b0a7824ULL, 0x040fe400078e020aULL,
0x000000011b0e7824ULL, 0x000fe200078e020cULL, 0x0ffffff8090c7812ULL, 0x000fe200078ef832ULL,
0x0000000829297824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fc400000e0607ULL,
0x00005e0008067625ULL, 0x000fe200078e004bULL, 0xfffffff8291a7812ULL, 0x000fc600078ee21aULL,
0x000000011b2e7824ULL, 0x000fe400078e022bULL, 0x000000012b327824ULL, 0x040fe400078e0232ULL,
0x000000082b2b7824ULL, 0x000fe400078e00ffULL, 0x000000011b0b7824ULL, 0x000fe400078e020bULL,
0x00005e000a087625ULL, 0x000fe200078e004bULL, 0xfffffff82b327812ULL, 0x000fc600078ee232ULL,
0x000000011b2a7824ULL, 0x000fe400078e0227ULL, 0x00000010122d7824ULL, 0x100fe200078e0249ULL,
0x0000004d06127210ULL, 0x000fe20007f1e0ffULL, 0x000000100c277824ULL, 0x100fe400078e0249ULL,
0x000000100d297824ULL, 0x000fe400078e0249ULL, 0x00005e000e0c7625ULL, 0x080fe200078e004bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010277faeULL, 0x0005e6000b901c46ULL,
0x00005e000b0a7625ULL, 0x000fc800078e004bULL, 0x0000001014317824ULL, 0x100fe200078e0249ULL,
0x0000004d08147210ULL, 0x000fe20007f3e0ffULL, 0x000000100f2b7824ULL, 0x100fe400078e0249ULL,
0x00000010132f7824ULL, 0x000fe400078e0249ULL, 0x00005e00150e7625ULL, 0x000fc800078e004bULL,
0x0000001018397824ULL, 0x000fe400078e0249ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x0000004d0c187210ULL, 0x080fe20007f1e0ffULL, 0x0000001016337824ULL, 0x100fe200078e0249ULL,
0x0000004d0a167210ULL, 0x000fe20007f5e0ffULL, 0x00005e0019067625ULL, 0x000fe200078e004bULL,
0x0000000012297faeULL, 0x0005e6000b901c46ULL, 0x000000101a477824ULL, 0x000fc400078e0249ULL,
0x000000ffff157224ULL, 0x000fe200008e0609ULL, 0x0000004d0e1a7210ULL, 0x000fe20007f3e0ffULL,
0x00005e001c087625ULL, 0x000fc600078e004bULL, 0x00000000142b7faeULL, 0x0005e2000b901c46ULL,
0x0000001017457824ULL, 0x000fe400078e0249ULL, 0x000000ffff197224ULL, 0x000fe200000e060dULL,
0x0000004d061c7210ULL, 0x000fe20007f1e0ffULL, 0x000000011b1f7824ULL, 0x040fe400078e021fULL,
0x000000ffff177224ULL, 0x000fe400010e060bULL, 0x000000011b217824ULL, 0x040fe400078e0221ULL,
0x000000011b237824ULL, 0x040fe200078e0223ULL, 0x00000000162d7faeULL, 0x0005e2000b901c46ULL,
0x000000011b267824ULL, 0x000fc400078e0225ULL, 0x00005e001d0a7625ULL, 0x000fe200078e004bULL,
0x00000000182f7faeULL, 0x0005e6000b901c46ULL, 0x000000101e3b7824ULL, 0x000fe400078e0249ULL,
0x000000ffff1b7224ULL, 0x000fe200008e060fULL, 0x0000004d081e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e001f0c7625ULL, 0x000fc600078e004bULL, 0x000000001a317faeULL, 0x0005e2000b901c46ULL,
0x00000010203d7824ULL, 0x000fe400078e0249ULL, 0x00005e00210e7625ULL, 0x000fc800078e004bULL,
0x000000ffff1d7224ULL, 0x000fe200000e0607ULL, 0x0000004d0a207210ULL, 0x000fe20007f1e0ffULL,
0x00005e0023067625ULL, 0x000fc600078e004bULL, 0x000000001c337faeULL, 0x0005e2000b901c46ULL,
0x00000010223f7824ULL, 0x000fe400078e0249ULL, 0x000000ffff1f7224ULL, 0x000fe200008e0609ULL,
0x0000004d0c227210ULL, 0x080fe20007f3e0ffULL, 0x0000001024417824ULL, 0x000fe200078e0249ULL,
0x0000004d0e247210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e060bULL,
0x0000004d06067210ULL, 0x000fe20007f1e0ffULL, 0x00005e0026087625ULL, 0x080fe200078e004bULL,
0x000000001e397faeULL, 0x0005e6000b901c46ULL, 0x000000ffff237224ULL, 0x000fe200008e060dULL,
0x00000000203b7faeULL, 0x0005e2000b901c46ULL, 0x00005e002a0a7625ULL, 0x000fc600078e004bULL,
0x00000000223d7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff257224ULL, 0x000fe200010e060fULL,
0x0000004d0a0a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e002c0c7625ULL, 0x000fc600078e004bULL,
0x00000000243f7faeULL, 0x0005e2000b901c46ULL, 0x00005e002e0e7625ULL, 0x000fe200078e004bULL,
0x0000004d0c0c7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000004d08087210ULL, 0x080fe20007f1e0ffULL, 0x0000001028437824ULL, 0x000fe200078e0249ULL,
0x0000004d0e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000000006417faeULL, 0x0005e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fe400000e0609ULL,
0x000000ffff0d7224ULL, 0x000fe400010e060dULL, 0x0000001032497824ULL, 0x000fe200078e0249ULL,
0x0000000008437faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x000000000a457faeULL, 0x0005e8000b901c46ULL, 0x000000000c477faeULL, 0x0005e8000b901c46ULL,
0x000000000e497faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x006fc40000015200ULL, 0x01760400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002000047824ULL, 0x002fca00078e0205ULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05077812ULL, 0x000fe400078ec0ffULL, 0x0000000f04057812ULL, 0x000fc600078ec0ffULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x0000001005097824ULL, 0x040fe400078e00ffULL,
0x0000001005067824ULL, 0x000fe200078e00ffULL, 0x0000000f07047812ULL, 0x040fe400078ec0ffULL,
0x0000000107077810ULL, 0x000fe40007ffe0ffULL, 0x000000f009047812ULL, 0x000fe400078ee204ULL,
0x0000000f07077812ULL, 0x000fc600078ec0ffULL, 0x00000000040c7984ULL, 0x000e62000000cc00ULL,
0x000000f006077812ULL, 0x000fca00078ee207ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001004007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01760400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000367919ULL, 0x000e620000000000ULL,
0x3db504f337377820ULL, 0x010fe20000410000ULL, 0x0001768800387811ULL, 0x040fe200078e18ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0xffffffff03397810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x00017608003a7811ULL, 0x000fc400078e28ffULL,
0x000001003c3d7824ULL, 0x000fe200078e0235ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003d0200720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000023c047810ULL, 0x000fe40007ffe0ffULL, 0x000001003d057810ULL, 0x000fe40007ffe0ffULL,
0x000000030400720cULL, 0x000fe40003f06070ULL, 0x000000013b3f7812ULL, 0x000fe200078e0cffULL,
0x0000620034217a24ULL, 0x000fd400078e0205ULL, 0x00000bb000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x102fe20000011636ULL, 0x00000080ff237424ULL, 0x000fe200078e00ffULL,
0x0000000502047217ULL, 0x000fe20007800000ULL, 0x0000000200197824ULL, 0x000fe200078e023fULL,
0x000000041f077810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1f0b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000104187824ULL, 0x000fe200078e0a05ULL, 0x000000101f0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe200078e0236ULL, 0x000000141f157810ULL, 0x000fe20007ffe0ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x000000180700720cULL, 0x000fe20003f86070ULL,
0x0000001036057824ULL, 0x000fe200078e00ffULL, 0x000000181f177810ULL, 0x040fe20007ffe0ffULL,
0x000000011f047824ULL, 0x000fe200078e0221ULL, 0xfffffff809167812ULL, 0x000fe200078ee206ULL,
0x000000010b087824ULL, 0x000fe200078e0236ULL, 0x0000007005257812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0023ULL, 0x000000081f097810ULL, 0x000fc40007ffe0ffULL,
0x000000180b00720cULL, 0x0c0fe20003f66070ULL, 0x000000080b117824ULL, 0x000fe200078e00ffULL,
0x00000025040c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000109067824ULL, 0x040fe200078e0236ULL,
0x000000180900720cULL, 0x0c0fe20003f46070ULL, 0x00000008090d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8111c7812ULL, 0x000fe200078ee208ULL, 0x0000000107047824ULL, 0x000fe200078e0221ULL,
0x0000100019197811ULL, 0x000fe200078e68ffULL, 0x000000010f0a7824ULL, 0x000fe200078e0236ULL,
0xfffffff80d1a7812ULL, 0x000fe200078ee206ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x000000180f00720cULL, 0x000fe20003f06070ULL, 0x00005e0004047625ULL, 0x000fe200078e0023ULL,
0x0000001c1f277810ULL, 0x000fc40007ffe0ffULL, 0x000000201f297810ULL, 0x000fe20007ffe0ffULL,
0x0000000109067824ULL, 0x100fe200078e0221ULL, 0x00000025040e7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f047824ULL, 0x000fe400078e0221ULL, 0x00005e0006067625ULL, 0x000fc800078e0023ULL,
0x000000080f137824ULL, 0x000fe400078e00ffULL, 0x000000010b087824ULL, 0x000fe400078e0221ULL,
0x000000ffff0f7224ULL, 0x000fe200008e0605ULL, 0x0000002506107210ULL, 0x000fe20007f3e0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0023ULL, 0xfffffff8131e7812ULL, 0x000fc600078ee20aULL,
0x00005e0008087625ULL, 0x000fc800078e0023ULL, 0x00000001150a7824ULL, 0x000fe200078e0221ULL,
0x0000002508087210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0607ULL,
0x0000002504127210ULL, 0x000fe20007f3e0ffULL, 0x00005e000a0a7625ULL, 0x000fc800078e0023ULL,
0x0000000117047824ULL, 0x000fe400078e0221ULL, 0x000000011f067824ULL, 0x000fe400078e0236ULL,
0x000000ffff137224ULL, 0x000fe200008e0605ULL, 0x000000181500720cULL, 0x000fe20003f26070ULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x000000250a0a7210ULL, 0x000fe20007fbe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0023ULL, 0x0000000706077812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e060bULL, 0x0000002504147210ULL, 0x000fe20007fde0ffULL,
0x0000000115067824ULL, 0x100fe200078e0236ULL, 0x0ffffff807047812ULL, 0x000fe200078ef836ULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0x000000181f00720cULL, 0x000fe20003fa6070ULL,
0x00000010161d7824ULL, 0x100fe400078e0219ULL, 0x00000010041b7824ULL, 0x000fe200078e0219ULL,
0xfffffff815207812ULL, 0x000fe200078ee206ULL, 0x0000000127047824ULL, 0x000fc400078e0221ULL,
0x000000ffff157224ULL, 0x000fe400030e0605ULL, 0x00005e0004047625ULL, 0x000fc800078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000e901c46ULL,
0x0000002504167210ULL, 0x000fe20007fde0ffULL, 0x0000000127047824ULL, 0x000fe200078e0236ULL,
0x000000181700720cULL, 0x080fe20003fa6070ULL, 0x000000000e1d7faeULL, 0x0005e2000e101c46ULL,
0x000000182700720cULL, 0x000fe20003f86070ULL, 0x0000000129067824ULL, 0x000fe400078e0221ULL,
0x0000000827277824ULL, 0x000fe400078e00ffULL, 0x00005e0006067625ULL, 0x000fc800078e0023ULL,
0x0000000117227824ULL, 0x000fe200078e0236ULL, 0x000000241f1d7810ULL, 0x004fe20007ffe0ffULL,
0x00000008172b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8270e7812ULL, 0x000fe200078ee204ULL,
0x000000ffff177224ULL, 0x000fe200030e0605ULL, 0x0000002506067210ULL, 0x000fe20007fde0ffULL,
0x000000011d047824ULL, 0x000fe200078e0221ULL, 0xfffffff82b227812ULL, 0x000fe200078ee222ULL,
0x000000101a0f7824ULL, 0x000fe200078e0219ULL, 0x0000002c1f277810ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fc600078e0023ULL, 0x00000000100f7faeULL, 0x0005e2000d101c46ULL,
0x000000101c1b7824ULL, 0x002fe200078e0219ULL, 0x000000181d00720cULL, 0x080fe20003f46070ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x00000025040c7210ULL, 0x000fe20007fde0ffULL,
0x00000001290d7824ULL, 0x140fe200078e0236ULL, 0x00000000081b7faeULL, 0x0003e2000d901c46ULL,
0x00000008291c7824ULL, 0x040fe200078e00ffULL, 0x000000182900720cULL, 0x000fe20003f66070ULL,
0x000000011d1a7824ULL, 0x000fe200078e0236ULL, 0x000000301f297810ULL, 0x000fe20007ffe0ffULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c047812ULL, 0x000fe200078ee20dULL,
0x000000101e0f7824ULL, 0x004fc400078e0219ULL, 0x000000ffff0d7224ULL, 0x000fe200030e0605ULL,
0xfffffff81d1a7812ULL, 0x000fe200078ee21aULL, 0x0000001020057824ULL, 0x100fe200078e0219ULL,
0x000000281f1d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000120f7faeULL, 0x0005e2000c101c46ULL,
0x00000010041b7824ULL, 0x102fe400078e0219ULL, 0x0000001022097824ULL, 0x100fe200078e0219ULL,
0x000000000a057faeULL, 0x0003e2000c901c46ULL, 0x000000011d047824ULL, 0x140fe200078e0236ULL,
0x000000181d00720cULL, 0x080fe20003fc6070ULL, 0x000000100e117824ULL, 0x000fe200078e0219ULL,
0x0000000014097faeULL, 0x0007e2000e901c46ULL, 0x000000182700720cULL, 0x000fe20003fa6070ULL,
0x00000001290e7824ULL, 0x000fc400078e0236ULL, 0x0000000016117faeULL, 0x0009e2000e101c46ULL,
0x000000341f0f7810ULL, 0x044fe40007ffe0ffULL, 0x000000381f137810ULL, 0x000fe20007ffe0ffULL,
0x000000081d057824ULL, 0x002fe200078e00ffULL, 0x00000000061b7faeULL, 0x0003e2000d901c46ULL,
0x000000101a0b7824ULL, 0x000fe200078e0219ULL, 0x0000003c1f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127097824ULL, 0x008fe200078e0236ULL, 0xfffffff805127812ULL, 0x000fe200078ee204ULL,
0x000000011d047824ULL, 0x000fe200078e0221ULL, 0x000000000c0b7faeULL, 0x0005e2000d101c46ULL,
0x0000000827147824ULL, 0x000fe200078e00ffULL, 0x000000182900720cULL, 0x080fe20003f86070ULL,
0x00005e0004047625ULL, 0x000fe200078e0023ULL, 0x000000180f00720cULL, 0x000fc40003f66070ULL,
0xfffffff814147812ULL, 0x000fe200078ee209ULL, 0x0000000127067824ULL, 0x102fe200078e0221ULL,
0x0000002504087210ULL, 0x000fe20007f5e0ffULL, 0x00000001290a7824ULL, 0x000fe200078e0221ULL,
0x000000181300720cULL, 0x080fe20003f26070ULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x000000181f00720cULL, 0x000fc60003f06070ULL, 0x000000ffff097224ULL, 0x000fe400010e0605ULL,
0x00005e000a047625ULL, 0x000fe200078e0023ULL, 0x00000025060a7210ULL, 0x000fc60007f5e0ffULL,
0x000000010f067824ULL, 0x040fe400078e0221ULL, 0x000000010f0d7824ULL, 0x044fe400078e0236ULL,
0x000000080f187824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e0607ULL,
0x00000025040c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee20dULL, 0x00005e0006067625ULL, 0x000fc600078e0023ULL,
0xfffffff829167812ULL, 0x010fe200078ee20eULL, 0x0000000113047824ULL, 0x000fe400078e0221ULL,
0x000000ffff0d7224ULL, 0x000fe200010e0605ULL, 0x00000025060e7210ULL, 0x000fe20007f5e0ffULL,
0x000000011f107824ULL, 0x040fe400078e0221ULL, 0x000000011f067824ULL, 0x000fe400078e0236ULL,
0x00005e0004047625ULL, 0x000fc800078e0023ULL, 0x000000081f1f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e0607ULL, 0x0000002504047210ULL, 0x000fe20007f5e0ffULL,
0x0000000113117824ULL, 0x000fe200078e0236ULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee206ULL,
0x00000008131a7824ULL, 0x000fe400078e00ffULL, 0x00005e0010067625ULL, 0x000fc600078e0023ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000002506067210ULL, 0x000fe20007f5e0ffULL, 0x0000001012117824ULL, 0x100fe400078e0219ULL,
0x0000001014137824ULL, 0x100fe400078e0219ULL, 0x0000001016157824ULL, 0x100fe200078e0219ULL,
0x0000000008117faeULL, 0x0003e2000f101c46ULL, 0x0000001018177824ULL, 0x100fe400078e0219ULL,
0x000000101a1b7824ULL, 0x100fe200078e0219ULL, 0x000000000a137faeULL, 0x0003e2000e901c46ULL,
0x000000101c197824ULL, 0x000fc400078e0219ULL, 0x000000ffff077224ULL, 0x000fe200010e0607ULL,
0x000000000c157faeULL, 0x0003e8000e101c46ULL, 0x000000000e177faeULL, 0x0003e8000d901c46ULL,
0x00000000041b7faeULL, 0x0003e8000c901c46ULL, 0x0000000006197faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x0000000836077811ULL, 0x042fe200078fe8ffULL,
0x00000080ff517424ULL, 0x000fe200078e00ffULL, 0x0000000436067811ULL, 0x000fc400078fe8ffULL,
0x00000014360c7811ULL, 0x040fe200078fe8ffULL, 0x0000000107057824ULL, 0x140fe200078e0236ULL,
0x0000000c36087811ULL, 0x040fe200078fe8ffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0x00000020361a7811ULL, 0x000fe200078fe8ffULL, 0x0000000106047824ULL, 0x100fe200078e0236ULL,
0x00000024361b7811ULL, 0x000fe200078fe8ffULL, 0x0000000806277824ULL, 0x000fe200078e00ffULL,
0xfffffff80a297812ULL, 0x000fe200078ee205ULL, 0x000000010c097824ULL, 0x000fe200078e0236ULL,
0x00000010360a7811ULL, 0x000fe200078fe8ffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee204ULL, 0x0000000108047824ULL, 0x100fe200078e0236ULL,
0x0000001c36197811ULL, 0x000fe200078fe8ffULL, 0x000000010a057824ULL, 0x100fe200078e0236ULL,
0x0000001836177811ULL, 0x000fe200078fe8ffULL, 0x000000080a0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8102f7812ULL, 0x000fe200078ee209ULL, 0x00000008082b7824ULL, 0x000fe200078e00ffULL,
0x0000003036247811ULL, 0x000fe200078fe8ffULL, 0x000000011b097824ULL, 0x100fe200078e0236ULL,
0xfffffff80e2d7812ULL, 0x000fe200078ee205ULL, 0x000000011a057824ULL, 0x040fe200078e0236ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL, 0x000000081a0e7824ULL, 0x000fe200078e00ffULL,
0x0000002c361f7811ULL, 0x040fe200078fe8ffULL, 0x000000081b107824ULL, 0x000fe200078e00ffULL,
0x00000028361d7811ULL, 0x000fe200078fe8ffULL, 0x0000000119047824ULL, 0x140fe200078e0236ULL,
0xfffffff80e417812ULL, 0x000fe200078ee205ULL, 0x0000000819337824ULL, 0x000fe200078e00ffULL,
0xfffffff810437812ULL, 0x000fe200078ee209ULL, 0x00000001170b7824ULL, 0x040fe200078e0236ULL,
0x0000003836287811ULL, 0x000fe200078fe8ffULL, 0x0000000817127824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee204ULL, 0x0000000124057824ULL, 0x100fe200078e0236ULL,
0x0000003436267811ULL, 0x000fe200078fe8ffULL, 0x0000000824107824ULL, 0x000fe200078e00ffULL,
0xfffffff8120b7812ULL, 0x000fe200078ee20bULL, 0x000000011f047824ULL, 0x000fc400078e0236ULL,
0x000000081f477824ULL, 0x000fe200078e00ffULL, 0xfffffff810497812ULL, 0x000fe200078ee205ULL,
0x000000011d0d7824ULL, 0x040fe400078e0236ULL, 0x000000081d127824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee204ULL, 0x00000001280e7824ULL, 0x000fe200078e0236ULL,
0x0000002136047211ULL, 0x000fe200078fe8ffULL, 0x00000008284d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8120d7812ULL, 0x000fe200078ee20dULL, 0x0000001036057824ULL, 0x000fc400078e00ffULL,
0x0000000126097824ULL, 0x040fe200078e0236ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee20eULL,
0x0000000826127824ULL, 0x000fe200078e00ffULL, 0x0000003c360e7811ULL, 0x000fe200078fe8ffULL,
0x0000000106067824ULL, 0x000fe200078e0221ULL, 0x0000007005537812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0051ULL, 0xfffffff8124b7812ULL, 0x000fe400078ee209ULL,
0x0000003636097211ULL, 0x000fe200078fe8ffULL, 0x000000010e2a7824ULL, 0x000fc400078e0221ULL,
0x000000010e0f7824ULL, 0x140fe200078e0236ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0x00000053040e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000200047824ULL, 0x000fe200078e023fULL, 0x0ffffff809257812ULL, 0x000fe200078ef836ULL,
0x0000000107077824ULL, 0x000fe200078e0221ULL, 0xfffffff8104f7812ULL, 0x000fe200078ee20fULL,
0x000000ffff0f7224ULL, 0x000fe200000e0605ULL, 0x0000100004107811ULL, 0x000fe200078e68ffULL,
0x00005e0006047625ULL, 0x000fc800078e0051ULL, 0x0000000108087824ULL, 0x100fe400078e0221ULL,
0x000000010a0a7824ULL, 0x000fe400078e0221ULL, 0x00005e0007067625ULL, 0x000fc800078e0051ULL,
0x0000001025257824ULL, 0x100fe200078e0210ULL, 0x0000005306127210ULL, 0x000fe20007f3e0ffULL,
0x0000001027277824ULL, 0x100fe400078e0210ULL, 0x0000001029297824ULL, 0x100fe200078e0210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e257faeULL, 0x0003e2000b901c46ULL,
0x000000102b2b7824ULL, 0x100fe400078e0210ULL, 0x000000102d2d7824ULL, 0x100fe400078e0210ULL,
0x000000102f2f7824ULL, 0x000fc400078e0210ULL, 0x000000100b317824ULL, 0x100fe400078e0210ULL,
0x0000001033337824ULL, 0x100fe400078e0210ULL, 0x0000001041417824ULL, 0x100fe400078e0210ULL,
0x0000001043437824ULL, 0x100fe400078e0210ULL, 0x000000100d457824ULL, 0x100fe400078e0210ULL,
0x0000001047477824ULL, 0x000fc400078e0210ULL, 0x0000001049497824ULL, 0x100fe400078e0210ULL,
0x000000104b4b7824ULL, 0x100fe400078e0210ULL, 0x000000104d4d7824ULL, 0x100fe400078e0210ULL,
0x000000104f4f7824ULL, 0x000fe200078e0210ULL, 0x0000005304107210ULL, 0x000fe20007f1e0ffULL,
0x000000010c0c7824ULL, 0x000fe400078e0221ULL, 0x00005e0008087625ULL, 0x000fc800078e0051ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0051ULL, 0x0000005308147210ULL, 0x000fc60007f5e0ffULL,
0x0000000117177824ULL, 0x000fe400078e0221ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0051ULL,
0x000000ffff117224ULL, 0x000fe200000e0605ULL, 0x000000530a167210ULL, 0x000fe20007f1e0ffULL,
0x0000000119197824ULL, 0x100fe400078e0221ULL, 0x000000011a1a7824ULL, 0x000fe200078e0221ULL,
0x0000000010277faeULL, 0x0003e2000b901c46ULL, 0x00005e0017047625ULL, 0x000fc800078e0051ULL,
0x000000ffff137224ULL, 0x000fe200008e0607ULL, 0x000000530c187210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe400010e0609ULL, 0x00005e0019067625ULL, 0x080fe200078e0051ULL,
0x0000000012297faeULL, 0x0003e6000b901c46ULL, 0x000000ffff177224ULL, 0x000fe200000e060bULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x00005e001a087625ULL, 0x000fe200078e0051ULL,
0x00000053041a7210ULL, 0x000fc40007f1e0ffULL, 0x00000000162d7faeULL, 0x0003e2000b901c46ULL,
0x000000011b1b7824ULL, 0x100fe400078e0221ULL, 0x000000011d1d7824ULL, 0x000fe400078e0221ULL,
0x000000ffff197224ULL, 0x000fe200008e060dULL, 0x00000053061c7210ULL, 0x000fe20007f3e0ffULL,
0x000000011f1f7824ULL, 0x000fe400078e0221ULL, 0x00005e001b0a7625ULL, 0x080fe200078e0051ULL,
0x00000000182f7faeULL, 0x0003e6000b901c46ULL, 0x00005e001d0c7625ULL, 0x000fc800078e0051ULL,
0x000000ffff1b7224ULL, 0x000fe200000e0605ULL, 0x00000053081e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e001f047625ULL, 0x000fe200078e0051ULL, 0x000000530c227210ULL, 0x080fe40007f5e0ffULL,
0x000000001a317faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1d7224ULL, 0x000fe200008e0607ULL,
0x000000530a207210ULL, 0x000fe20007f3e0ffULL, 0x0000000124247824ULL, 0x100fe400078e0221ULL,
0x0000000126267824ULL, 0x100fe200078e0221ULL, 0x000000001c337faeULL, 0x0003e2000b901c46ULL,
0x0000000128287824ULL, 0x000fc400078e0221ULL, 0x000000ffff1f7224ULL, 0x000fe200000e0609ULL,
0x0000005304047210ULL, 0x000fe20007f1e0ffULL, 0x00005e0024067625ULL, 0x000fc600078e0051ULL,
0x000000001e417faeULL, 0x0003e2000b901c46ULL, 0x000000ffff217224ULL, 0x000fe400008e060bULL,
0x00005e0026087625ULL, 0x000fc600078e0051ULL, 0x0000000020437faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fe200010e060dULL, 0x0000005308087210ULL, 0x000fe20007f3e0ffULL,
0x00005e00280a7625ULL, 0x000fc600078e0051ULL, 0x0000000022457faeULL, 0x0003e2000b901c46ULL,
0x00005e002a0c7625ULL, 0x000fe200078e0051ULL, 0x000000530a0a7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000005306067210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000530c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000004477faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fe400000e0607ULL, 0x000000ffff0d7224ULL, 0x000fc600018e060dULL,
0x0000000006497faeULL, 0x0003e8000b901c46ULL, 0x00000000084b7faeULL, 0x0003e8000b901c46ULL,
0x000000000a4d7faeULL, 0x0003e8000b901c46ULL, 0x000000000c4f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x002fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff836257812ULL, 0x020fe200078ec0ffULL,
0x0000000200297824ULL, 0x000fe200078e023bULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000013e287810ULL, 0x000fc40007ffe0ffULL, 0x0000000725257812ULL, 0x000fe400078ef836ULL,
0x0000100029297811ULL, 0x000fc600078e68ffULL, 0x0000000125247824ULL, 0x040fe400078e023eULL,
0x0000000825277824ULL, 0x040fe400078e00ffULL, 0x0000000825267824ULL, 0x040fe400078e00ffULL,
0x0000000125257824ULL, 0x000fe200078e0228ULL, 0xfffffff827247812ULL, 0x000fc800078ee224ULL,
0xfffffff826267812ULL, 0x000fe200078ee225ULL, 0x0000001024247824ULL, 0x000fe200078e0229ULL,
0x0000002036257810ULL, 0x000fc60007ffe0ffULL, 0x0000001026267824ULL, 0x000fe200078e0229ULL,
0x000000002430783bULL, 0x000e620000000200ULL, 0xfffffff825257812ULL, 0x000fc600078ec0ffULL,
0x00000000262c783bULL, 0x0004e20000000200ULL, 0x0000000725257812ULL, 0x000fca00078ef836ULL,
0x00000008252b7824ULL, 0x040fe400078e00ffULL, 0x0000000125287824ULL, 0x000fca00078e0228ULL,
0xfffffff82b287812ULL, 0x000fca00078ee228ULL, 0x0000001028287824ULL, 0x000fe200078e0229ULL,
0x00000018ff247819ULL, 0x002fe20000011430ULL, 0x00000030009c7306ULL, 0x000fe20000009400ULL,
0x00000018ff267819ULL, 0x004fe20000011431ULL, 0x0001000030507824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011432ULL, 0x0001000031517824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x008fe2000001142cULL, 0x000100002f5a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000002400967306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x000fc40000011433ULL, 0x00000018ff6c7819ULL, 0x000fe4000001145aULL,
0x00000018ff487819ULL, 0x000fe4000001142fULL, 0x00000018ff477819ULL, 0x000fe2000001142eULL,
0x00000024008b7306ULL, 0x000e620000205400ULL, 0x00000018ff427819ULL, 0x000fe4000001142dULL,
0x00000018ff517819ULL, 0x000fca0000011451ULL, 0x0000002400837306ULL, 0x0004f0000020d400ULL,
0x0000002600947306ULL, 0x000fe20000209400ULL, 0x0000000125247824ULL, 0x004fe200078e023eULL,
0x0000008b9600720bULL, 0x002fc80003f9d000ULL, 0xfffffff82b247812ULL, 0x000fe400078ee224ULL,
0x0000002600977306ULL, 0x000e660000205400ULL, 0x0000001024247824ULL, 0x000fe400078e0229ULL,
0x000000002828783bULL, 0x000ea40000000200ULL, 0x0000000183834812ULL, 0x008fe200078efcffULL,
0x0000002600767306ULL, 0x000ef0000020d400ULL, 0x0000002700957306ULL, 0x000fe20000209400ULL,
0x000000979400720bULL, 0x002fce0003f3d000ULL, 0x00000027008e7306ULL, 0x000fec0000205400ULL,
0x0000000176761812ULL, 0x008fe400078efcffULL, 0x0000002700707306ULL, 0x0003f0000020d400ULL,
0x0000003000a37306ULL, 0x000ee20000005400ULL, 0x000000002424783bULL, 0x002e620000000200ULL,
0x00000018ff6a7819ULL, 0x004fc4000001142aULL, 0x00000018ff5b7819ULL, 0x000fc80000011429ULL,
0x0000003000807306ULL, 0x000522000000d400ULL, 0x00000018ff567819ULL, 0x000fe40000011428ULL,
0x00000018ff6e7819ULL, 0x000fca000001142bULL, 0x0000003100937306ULL, 0x000fe20000009400ULL,
0x0000010030307824ULL, 0x004fe200078e00ffULL, 0x000000a39c00720bULL, 0x008fc80003fbd000ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000031008c7306ULL, 0x000eae0000005400ULL,
0x0000000180805812ULL, 0x010fe200078efcffULL, 0x0000003100777306ULL, 0x000730000000d400ULL,
0x0000003000b47306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x008fe200078e00ffULL,
0x0000008c9300720bULL, 0x004fc80003f7d000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000af7306ULL, 0x000eae0000205400ULL, 0x0000000177773812ULL, 0x010fe200078efcffULL,
0x0000003000a27306ULL, 0x000722000020d400ULL, 0x0000008e9500720bULL, 0x000fce0003f7d000ULL,
0x0000003100ba7306ULL, 0x000fe20000209400ULL, 0x0001000033307824ULL, 0x008fe200078e00ffULL,
0x000000afb400720bULL, 0x004fc80003f1d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003100b57306ULL, 0x000fe20000205400ULL, 0x0000000170703812ULL, 0x000fcc00078efcffULL,
0x00000001a2a20812ULL, 0x010fe200078efcffULL, 0x00000031009d7306ULL, 0x0003f0000020d400ULL,
0x0000005000ad7306ULL, 0x000fe20000209400ULL, 0x00000018ff317819ULL, 0x002fce0000011424ULL,
0x0000005000b27306ULL, 0x000e700000205400ULL, 0x0000005000a17306ULL, 0x0004f0000020d400ULL,
0x00000032008d7306ULL, 0x000fe20000009400ULL, 0x0001000032507824ULL, 0x004fe200078e00ffULL,
0x000000b2ad00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000003200887306ULL, 0x000e6e0000005400ULL, 0x00000001a1a16812ULL, 0x008fe200078efcffULL,
0x0000003200717306ULL, 0x0004e2000000d400ULL, 0x000000b5ba00720bULL, 0x000fce0003fdd000ULL,
0x0000003100c97306ULL, 0x000fe20000209400ULL, 0x0000010032327824ULL, 0x004fe200078e00ffULL,
0x000000888d00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003100cc7306ULL, 0x000fe20000205400ULL, 0x000000019d9d6812ULL, 0x000fcc00078efcffULL,
0x0000000171715812ULL, 0x008fe200078efcffULL, 0x0000003100857306ULL, 0x0003f0000020d400ULL,
0x0000002c007e7306ULL, 0x000fe20000009400ULL, 0x000100002c317824ULL, 0x002fce00078e00ffULL,
0x0000002c00817306ULL, 0x000ff00000005400ULL, 0x0000002c004f7306ULL, 0x0003f0000000d400ULL,
0x0000003000c57306ULL, 0x000fe20000209400ULL, 0x000001002c2c7824ULL, 0x002fce00078e00ffULL,
0x0000003000ca7306ULL, 0x000e700000205400ULL, 0x0000003000a07306ULL, 0x0004f0000020d400ULL,
0x00000033008a7306ULL, 0x000fe20000009400ULL, 0x00000018ff307819ULL, 0x004fc40000011426ULL,
0x000000cac500720bULL, 0x002fca0003f3d000ULL, 0x00000033008f7306ULL, 0x000e700000005400ULL,
0x00000033006f7306ULL, 0x000522000000d400ULL, 0x00000001a0a01812ULL, 0x008fce00078efcffULL,
0x0000003000be7306ULL, 0x000fe20000209400ULL, 0x0000010033337824ULL, 0x004fe200078e00ffULL,
0x0000008f8a00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003000b97306ULL, 0x000fee0000205400ULL, 0x000000016f6f4812ULL, 0x010fe200078efcffULL,
0x00000030005f7306ULL, 0x0003e6000020d400ULL, 0x0000006fa0a0723eULL, 0x000fca00000010ffULL,
0x0000003200c17306ULL, 0x000fe20000209400ULL, 0x00000018ff307819ULL, 0x002fe2000001142cULL,
0x000100002d2c7824ULL, 0x000fcc00078e00ffULL, 0x0000003200c67306ULL, 0x000ff00000205400ULL,
0x0000003200997306ULL, 0x0003f0000020d400ULL, 0x0000003300ce7306ULL, 0x000fe20000209400ULL,
0x00000018ff327819ULL, 0x002fce0000011425ULL, 0x0000003200d07306ULL, 0x000ff00000209400ULL,
0x0000003200cb7306ULL, 0x000ff00000205400ULL, 0x0000003200697306ULL, 0x0003f0000020d400ULL,
0x0000003300c77306ULL, 0x000fe20000205400ULL, 0x00000018ff327819ULL, 0x002fe2000001142cULL,
0x000001002d2c7824ULL, 0x000fcc00078e00ffULL, 0x0000003300927306ULL, 0x0003f0000020d400ULL,
0x0000006a00527306ULL, 0x000fe20000209400ULL, 0x00000018ff337819ULL, 0x002fce0000011427ULL,
0x0000003300c47306ULL, 0x000ff00000209400ULL, 0x0000003300bd7306ULL, 0x000ff00000205400ULL,
0x0000003300587306ULL, 0x0003f0000020d400ULL, 0x0000006a00537306ULL, 0x000fe20000205400ULL,
0x00000018ff337819ULL, 0x002fce000001142cULL, 0x0000003300b67306ULL, 0x000ff00000209400ULL,
0x0000003300b17306ULL, 0x000ff00000205400ULL, 0x00000033002c7306ULL, 0x000ff0000020d400ULL,
0x0000006a00337306ULL, 0x0003f0000020d400ULL, 0x0000005000b77306ULL, 0x000fe20000209400ULL,
0x00010000246a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x0000005000bc7306ULL, 0x000e700000205400ULL, 0x0000005000a67306ULL, 0x0004f0000020d400ULL,
0x0000004000987306ULL, 0x000fe20000209400ULL, 0x00000018ff507819ULL, 0x004fc40000011431ULL,
0x000000bcb700720bULL, 0x002fca0003f1d000ULL, 0x00000040009b7306ULL, 0x000e700000205400ULL,
0x0000002400ab7306ULL, 0x000fe20000009400ULL, 0x00000001a6a60812ULL, 0x008fe400078efcffULL,
0x000000c7ce00720bULL, 0x000fca0003f1d000ULL, 0x0000002400b07306ULL, 0x000ea20000005400ULL,
0x0000009b9800720bULL, 0x002fe40003fdd000ULL, 0x00000071a698723eULL, 0x000fca00000010ffULL,
0x00000024006b7306ULL, 0x0002e2000000d400ULL, 0x0000000192920812ULL, 0x000fe400078efcffULL,
0x000000ccc900720bULL, 0x000fca0003f1d000ULL, 0x0000005000bf7306ULL, 0x000fe20000209400ULL,
0x0000010024247824ULL, 0x002fe200078e00ffULL, 0x000000b0ab00720bULL, 0x004fcc0003fbd000ULL,
0x0000005000c27306ULL, 0x000fe20000205400ULL, 0x0000000185850812ULL, 0x000fcc00078efcffULL,
0x000000016b6b5812ULL, 0x008fe200078efcffULL, 0x00000050005e7306ULL, 0x0003f0000020d400ULL,
0x0000002f007f7306ULL, 0x000fe20000009400ULL, 0x000100002e507824ULL, 0x002fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000002f007c7306ULL, 0x000ff00000005400ULL,
0x0000002f00497306ULL, 0x0003f0000000d400ULL, 0x0000006a00d27306ULL, 0x000fe20000209400ULL,
0x000001002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff847819ULL, 0x000fe4000001142fULL,
0x0000006a00cd7306ULL, 0x000ff00000205400ULL, 0x0000006a009e7306ULL, 0x0003f0000020d400ULL,
0x0000006c00607306ULL, 0x000fe20000209400ULL, 0x00010000266a7824ULL, 0x002fca00078e00ffULL,
0x00000018ffd77819ULL, 0x000fe4000001146aULL, 0x0000006c005d7306ULL, 0x000ff00000205400ULL,
0x0000006c005c7306ULL, 0x0003f0000020d400ULL, 0x0000002600a97306ULL, 0x000fe20000009400ULL,
0x00000018ff6c7819ULL, 0x002fce0000011424ULL, 0x0000002600ac7306ULL, 0x000e700000005400ULL,
0x0000002e00797306ULL, 0x000ff00000009400ULL, 0x0000002e007a7306ULL, 0x000fe20000005400ULL,
0x000000aca900720bULL, 0x002fce0003f3d000ULL, 0x0000002e004a7306ULL, 0x0003f0000000d400ULL,
0x00000040006d7306ULL, 0x000ea2000020d400ULL, 0x000001002e2e7824ULL, 0x002fce00078e00ffULL,
0x0000006c00247306ULL, 0x000ff00000209400ULL, 0x0000006c00cf7306ULL, 0x000e620000205400ULL,
0x000000016d6d6812ULL, 0x004fe400078efcffULL, 0x000000cbd000720bULL, 0x000fca0003fdd000ULL,
0x0000006c00a87306ULL, 0x0004f0000020d400ULL, 0x0000002700917306ULL, 0x000fe20000009400ULL,
0x00010000276c7824ULL, 0x004fe200078e00ffULL, 0x0000000169696812ULL, 0x000fc400078efcffULL,
0x000000cf2400720bULL, 0x002fe20003f9d000ULL, 0x0001000029247824ULL, 0x000fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe4000001146cULL, 0x0000002700907306ULL, 0x000fe40000005400ULL,
0x00000018ff8a7819ULL, 0x000fcc0000011424ULL, 0x0000002700597306ULL, 0x0003e2000000d400ULL,
0x00000001a8a84812ULL, 0x008fce00078efcffULL, 0x0000003000c87306ULL, 0x000fe20000209400ULL,
0x0000010027277824ULL, 0x002fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000003000c37306ULL, 0x000ff00000205400ULL, 0x0000003000317306ULL, 0x000ff0000020d400ULL,
0x00000050009a7306ULL, 0x000ff00000209400ULL, 0x00000050009f7306ULL, 0x000ff00000205400ULL,
0x0000005000577306ULL, 0x000ff0000020d400ULL, 0x0000005b00307306ULL, 0x000ff00000209400ULL,
0x0000005b00557306ULL, 0x000ff00000205400ULL, 0x0000005b00507306ULL, 0x000ff0000020d400ULL,
0x0000002d007b7306ULL, 0x000ff00000009400ULL, 0x0000002d00787306ULL, 0x000ff00000005400ULL,
0x0000002d004c7306ULL, 0x000ff0000000d400ULL, 0x00000084005a7306ULL, 0x000ff00000209400ULL,
0x00000084005b7306ULL, 0x000ff00000205400ULL, 0x00000084002f7306ULL, 0x000ff0000020d400ULL,
0x0000003200c07306ULL, 0x000ff00000209400ULL, 0x0000003200bb7306ULL, 0x000ff00000205400ULL,
0x00000032002d7306ULL, 0x0003f0000020d400ULL, 0x000000d700d87306ULL, 0x000fe20000209400ULL,
0x00000018ff327819ULL, 0x002fce000001142eULL, 0x000000d700d97306ULL, 0x000e700000205400ULL,
0x000000d700847306ULL, 0x0005f0000020d400ULL, 0x0000002600637306ULL, 0x000722000000d400ULL,
0x0000000736d77812ULL, 0x004fc400078ec0ffULL, 0x000000d9d800720bULL, 0x002fe40003f9d000ULL,
0x00000008d7de7812ULL, 0x000fc600078ef836ULL, 0x0000005100b87306ULL, 0x000fe20000209400ULL,
0x0000010026267824ULL, 0x008fe400078e00ffULL, 0x00000010dead7824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000005100b37306ULL, 0x000e620000205400ULL,
0x0000000163631812ULL, 0x010fe400078efcffULL, 0x0000000184844812ULL, 0x000fe400078efcffULL,
0x000000787b00720bULL, 0x000fe40003f9d000ULL, 0x000000638484723eULL, 0x000fe200000010ffULL,
0x0000005100aa7306ULL, 0x000eb0000020d400ULL, 0x0000003200a57306ULL, 0x000fe20000209400ULL,
0x000000b3b800720bULL, 0x002fc40003f5d000ULL, 0x000000014c4c4812ULL, 0x000fe400078efcffULL,
0x0000009f9a00720bULL, 0x000fe40003f9d000ULL, 0x000000a8859f723eULL, 0x000fe200000010ffULL,
0x0000003200a47306ULL, 0x000fec0000205400ULL, 0x00000001aaaa2812ULL, 0x004fc400078efcffULL,
0x0000003200547306ULL, 0x000fe2000020d400ULL, 0x000000c6c100720bULL, 0x000fe40003f5d000ULL,
0x0000000157574812ULL, 0x000fca00078efcffULL, 0x0000005600647306ULL, 0x000fec0000209400ULL,
0x0000000199992812ULL, 0x000fe400078efcffULL, 0x0000005600657306ULL, 0x000fe20000205400ULL,
0x000000cdd200720bULL, 0x000fe40003f5d000ULL, 0x000000997099723eULL, 0x000fca00000010ffULL,
0x00000056002e7306ULL, 0x000fec000020d400ULL, 0x000000019e9e2812ULL, 0x000fe400078efcffULL,
0x0000006e00517306ULL, 0x000fe40000209400ULL, 0x0000006b9e9e723eULL, 0x000fcc00000010ffULL,
0x0000006e00567306ULL, 0x000ff00000205400ULL, 0x0000006e00327306ULL, 0x0003f0000020d400ULL,
0x0000002700d77306ULL, 0x000fe20000209400ULL, 0x00010000256e7824ULL, 0x002fca00078e00ffULL,
0x00000018ffd17819ULL, 0x000fe4000001146eULL, 0x0000002700b27306ULL, 0x000e700000205400ULL,
0x0000002500ae7306ULL, 0x000ff00000009400ULL, 0x0000002500a77306ULL, 0x000ea20000005400ULL,
0x000000b2d700720bULL, 0x002fce0003f3d000ULL, 0x0000002500687306ULL, 0x0002f0000000d400ULL,
0x000000db00dc7306ULL, 0x000fe20000209400ULL, 0x0000010025257824ULL, 0x002fe200078e00ffULL,
0x000000a7ae00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x000000db00dd7306ULL, 0x000e6e0000205400ULL, 0x0000000168683812ULL, 0x008fe200078efcffULL,
0x0000002500d57306ULL, 0x000fe20000209400ULL, 0x000000b9be00720bULL, 0x000fce0003f7d000ULL,
0x0000002500d67306ULL, 0x000ea20000205400ULL, 0x000000dddc00720bULL, 0x002fca0003fdd000ULL,
0x000000015f5f3812ULL, 0x000fe400078efcffULL, 0x00000027008b7306ULL, 0x000e62000020d400ULL,
0x0000007c7f00720bULL, 0x000fe20003f7d000ULL, 0x000100002a7c7824ULL, 0x000fe400078e00ffULL,
0x000100002b7f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x000000db006c7306ULL, 0x000ee2000020d400ULL, 0x000000d6d500720bULL, 0x004fe40003fbd000ULL,
0x00000018ff7f7819ULL, 0x000fc6000001147fULL, 0x0000000149493812ULL, 0x000fe400078efcffULL,
0x00000025006e7306ULL, 0x000522000020d400ULL, 0x000000018b8b1812ULL, 0x002fe400078efcffULL,
0x000000c3c800720bULL, 0x000fca0003f3d000ULL, 0x0000004100867306ULL, 0x000fe20000209400ULL,
0x00000004ff257819ULL, 0x004fe40000011636ULL, 0x000000016c6c6812ULL, 0x008fe400078efcffULL,
0x000000bdc400720bULL, 0x000fe20003fdd000ULL, 0x000000023e257824ULL, 0x040fe200078e0225ULL,
0x000000023e3e7810ULL, 0x000fe20007ffe0ffULL, 0x0000004100877306ULL, 0x000e620000205400ULL,
0x000000016e6e5812ULL, 0x010fe400078efcffULL, 0x000000909100720bULL, 0x000fc40003fbd000ULL,
0x0000000131311812ULL, 0x000fe400078efcffULL, 0x000000b1b600720bULL, 0x000fe20003f3d000ULL,
0x000000d100d37306ULL, 0x000fe20000209400ULL, 0x0000006e6969723eULL, 0x000fe400000010ffULL,
0x0000000158586812ULL, 0x000fca00078efcffULL, 0x000000d100d47306ULL, 0x000ea20000205400ULL,
0x000000878600720bULL, 0x002fe40003fdd000ULL, 0x0000000159595812ULL, 0x000fe400078efcffULL,
0x000000c2bf00720bULL, 0x000fe40003fbd000ULL, 0x000000012c2c1812ULL, 0x000fe200078efcffULL,
0x000000d100897306ULL, 0x000e62000020d400ULL, 0x000000a4a500720bULL, 0x000fe40003f3d000ULL,
0x000000596c6c723eULL, 0x000fca00000010ffULL, 0x0000002600d17306ULL, 0x000fe20000209400ULL,
0x000000d4d300720bULL, 0x004fe40003f5d000ULL, 0x000000015e5e5812ULL, 0x000fe400078efcffULL,
0x000000bbc000720bULL, 0x000fe40003fbd000ULL, 0x0000000154541812ULL, 0x000fe200078efcffULL,
0x0000002600da7306ULL, 0x000eac0000205400ULL, 0x0000000189892812ULL, 0x002fc400078efcffULL,
0x00000026006a7306ULL, 0x0003e2000020d400ULL, 0x000000817e00720bULL, 0x000fe20003f5d000ULL,
0x000001002a7e7824ULL, 0x000fe200078e00ffULL, 0x000000012d2d5812ULL, 0x000fe400078efcffULL,
0x000000688968723eULL, 0x000fe400000010ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000004100467306ULL, 0x000ee2000020d400ULL, 0x00000001de267824ULL, 0x142fe200078e0225ULL,
0x00000002de257810ULL, 0x040fe20007ffe025ULL, 0x00000010dede7824ULL, 0x000fe200078e00ffULL,
0x000000dad100720bULL, 0x004fc40003f1d000ULL, 0xfffffff0ad267812ULL, 0x000fe400078ee226ULL,
0xfffffff0de9c7812ULL, 0x000fe200078ee225ULL, 0x0001000028257824ULL, 0x000fe200078e00ffULL,
0x0000004800407306ULL, 0x000fe20000209400ULL, 0x0000001026267824ULL, 0x000fe200078e00ffULL,
0x000000014f4f2812ULL, 0x000fe400078efcffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000000146466812ULL, 0x008fc400078efcffULL, 0x00000048004b7306ULL, 0x000fe20000205400ULL,
0x000000016a6a0812ULL, 0x000fe400078efcffULL, 0x0000007a7900720bULL, 0x000fe40003f1d000ULL,
0x0000006a5f85723eULL, 0x000fe400000010ffULL, 0x0000004f5e5e723eULL, 0x000fe200000010ffULL,
0x0000004800447306ULL, 0x000fe2000020d400ULL, 0x00000031465f723eULL, 0x000fe400000010ffULL,
0x0000004c2d4c723eULL, 0x000fca00000010ffULL, 0x0000004700737306ULL, 0x000fe20000209400ULL,
0x000000014a4a0812ULL, 0x000fc800078efcffULL, 0x0000004a574a723eULL, 0x000fc600000010ffULL,
0x0000004700747306ULL, 0x000e700000205400ULL, 0x0000002800757306ULL, 0x000ff00000009400ULL,
0x0000002800727306ULL, 0x000ea20000005400ULL, 0x000000747300720bULL, 0x002fce0003fdd000ULL,
0x0000002800487306ULL, 0x0002f0000000d400ULL, 0x00000025008c7306ULL, 0x000fe20000209400ULL,
0x0000010028287824ULL, 0x002fe200078e00ffULL, 0x000000727500720bULL, 0x004fc80003fbd000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002500937306ULL, 0x000e6e0000205400ULL,
0x0000000148485812ULL, 0x008fe200078efcffULL, 0x00000025008d7306ULL, 0x0004f0000020d400ULL,
0x0000002800887306ULL, 0x000fe20000209400ULL, 0x000000002624783bULL, 0x004ea20000000200ULL,
0x000000938c00720bULL, 0x002fcc0003f9d000ULL, 0x0000002800957306ULL, 0x000e6e0000205400ULL,
0x000000018d8d4812ULL, 0x008fe200078efcffULL, 0x0000004700457306ULL, 0x000ee6000020d400ULL,
0x000000488d48723eULL, 0x000fca00000010ffULL, 0x00000028008f7306ULL, 0x0008a2000020d400ULL,
0x000000958800720bULL, 0x002fce0003f3d000ULL, 0x00000042007d7306ULL, 0x000fe20000209400ULL,
0x0000000145456812ULL, 0x008fe400078efcffULL, 0x000000656400720bULL, 0x000fe40003fdd000ULL,
0x00000080a128723eULL, 0x010fe200000010ffULL, 0x000001002b807824ULL, 0x000fe200078e00ffULL,
0x000000926da1723eULL, 0x000fe200000010ffULL, 0x0000004200827306ULL, 0x000e620000205400ULL,
0x000000018f8f1812ULL, 0x004fe200078efcffULL, 0x000000982420723cULL, 0x000fe20000041820ULL,
0x0000005d6000720bULL, 0x000fc40003f3d000ULL, 0x0000008b586d723eULL, 0x000fe400000010ffULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x0000008a008e7306ULL, 0x000fe20000209400ULL,
0x000000012e2e6812ULL, 0x000fe200078efcffULL, 0x000000a0241c723cULL, 0x000fe2000004181cULL,
0x0000004b4000720bULL, 0x000fe40003fdd000ULL, 0x00000054454b723eULL, 0x000fc600000010ffULL,
0x0000008a00817306ULL, 0x000ea20000205400ULL, 0x000000827d00720bULL, 0x002fe20003f5d000ULL,
0x0000009e2418723cULL, 0x040fe20000041818ULL, 0x000000015c5c1812ULL, 0x000fe400078efcffULL,
0x000000553000720bULL, 0x000fe40003f3d000ULL, 0x000000495c5c723eULL, 0x000fe200000010ffULL,
0x0000002900677306ULL, 0x000fe20000009400ULL, 0x0000000144446812ULL, 0x000fe200078efcffULL,
0x000000682414723cULL, 0x000fe20000041814ULL, 0x0000008f2e49723eULL, 0x000fca00000010ffULL,
0x0000002900667306ULL, 0x000fe20000005400ULL, 0x000000818e00720bULL, 0x004fe20003f9d000ULL,
0x000000842410723cULL, 0x000fe20000041810ULL, 0x0000000150501812ULL, 0x000fca00078efcffULL,
0x0000002900477306ULL, 0x0003e4000000d400ULL, 0x0000006c240c723cULL, 0x000fec000004180cULL,
0x0000002b004d7306ULL, 0x000fe20000009400ULL, 0x0000010029297824ULL, 0x002fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011429ULL, 0x0000002b004e7306ULL, 0x000e620000005400ULL,
0x000000a28329723eULL, 0x000fce00000010ffULL, 0x0000004200437306ULL, 0x000ea2000020d400ULL,
0x000000282408723cULL, 0x000b6e0000041808ULL, 0x0000002a00617306ULL, 0x000fe20000009400ULL,
0x000000109c287824ULL, 0x020fe200078e00ffULL, 0x0000004e4d00720bULL, 0x002fcc0003fbd000ULL,
0x0000002a00627306ULL, 0x000e620000005400ULL, 0x0000000143432812ULL, 0x004fe400078efcffULL,
0x000000666700720bULL, 0x000fe40003f5d000ULL, 0x0000002c434d723eULL, 0x000fc600000010ffULL,
0x0000008a00787306ULL, 0x000eb0000020d400ULL, 0x00000079007a7306ULL, 0x000fe20000209400ULL,
0x000000626100720bULL, 0x002fe40003f1d000ULL, 0x0000000147472812ULL, 0x000fc400078efcffULL,
0x000000565100720bULL, 0x000fc60003f5d000ULL, 0x00000079007b7306ULL, 0x000e620000205400ULL,
0x0000000178784812ULL, 0x004fe400078efcffULL, 0x0000005b5a00720bULL, 0x000fe40003f9d000ULL,
0x000000477878723eULL, 0x000fc600000010ffULL, 0x0000007c00717306ULL, 0x000fe40000209400ULL,
0x0000000132322812ULL, 0x000fcc00078efcffULL, 0x0000007c00707306ULL, 0x000ea20000205400ULL,
0x0000007b7a00720bULL, 0x002fe40003f7d000ULL, 0x000000012f2f4812ULL, 0x000fe400078efcffULL,
0x000000535200720bULL, 0x000fe40003f9d000ULL, 0x0000002f445d723eULL, 0x000fe200000010ffULL,
0x0000002a00427306ULL, 0x0002f0000000d400ULL, 0x0000002b00417306ULL, 0x0008e2000000d400ULL,
0x00000077aa2a723eULL, 0x002fc400000010ffULL, 0x000000707100720bULL, 0x004fe40003fdd000ULL,
0x0000000133334812ULL, 0x000fc600078efcffULL, 0x0000007f004e7306ULL, 0x000fe20000209400ULL,
0x0000009d762b723eULL, 0x010fe400000010ffULL, 0x0000000142420812ULL, 0x008fe400078efcffULL,
0x000000083e00780cULL, 0x000fc60003f05270ULL, 0x0000002a2404723cULL, 0x000b620000041804ULL,
0x0000007900777306ULL, 0x000e62000020d400ULL, 0x000000002828783bULL, 0x020ea20000000200ULL,
0x0000000141415812ULL, 0x000fcc00078efcffULL, 0x0000007f00257306ULL, 0x000ef00000205400ULL,
0x0000007c006f7306ULL, 0x000f22000020d400ULL, 0x0000000177773812ULL, 0x002fc800078efcffULL,
0x000000775079723eULL, 0x000fc600000010ffULL, 0x0000007e00667306ULL, 0x000fe20000209400ULL,
0x000000254e00720bULL, 0x008fce0003f3d000ULL, 0x0000007e00617306ULL, 0x000e620000205400ULL,
0x000000016f6f6812ULL, 0x010fc800078efcffULL, 0x000000426f42723eULL, 0x000fc600000010ffULL,
0x0000008000267306ULL, 0x000fe20000209400ULL, 0x0000005e2808723cULL, 0x044b6e0000041808ULL,
0x0000008000277306ULL, 0x000ea20000205400ULL, 0x000000616600720bULL, 0x002fe20003f7d000ULL,
0x0000004c2804723cULL, 0x040b6c0000041804ULL, 0x0000007e00627306ULL, 0x000e64000020d400ULL,
0x0000004a2820723cULL, 0x040b6c0000041820ULL, 0x0000007f00247306ULL, 0x000ee2000020d400ULL,
0x000000272600720bULL, 0x004fe20003fdd000ULL, 0x0000005c281c723cULL, 0x040b6c000004181cULL,
0x0000008000257306ULL, 0x000ea2000020d400ULL, 0x0000000162623812ULL, 0x002fe200078efcffULL,
0x000000482818723cULL, 0x000b660000041818ULL, 0x000000623343723eULL, 0x000fc400000010ffULL,
0x0000000124241812ULL, 0x008fc600078efcffULL, 0x000000782814723cULL, 0x000b620000041814ULL,
0x000000412424723eULL, 0x000fe400000010ffULL, 0x0000000125256812ULL, 0x004fca00078efcffULL,
0x000000422810723cULL, 0x000b620000041810ULL, 0x000000253225723eULL, 0x000fce00000010ffULL,
0x00000024280c723cULL, 0x000b62000004180cULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fcc000383ffffULL, 0x0000003706267220ULL, 0x0a0fe40000410000ULL,
0x0000003707277220ULL, 0x080fe40000410000ULL, 0x0000003718187220ULL, 0x080fe40000410000ULL,
0x0000003719197220ULL, 0x080fe40000410000ULL, 0x0000003708087220ULL, 0x080fe40000410000ULL,
0x0000003709097220ULL, 0x000fc40000410000ULL, 0x0000003704047220ULL, 0x080fe40000410000ULL,
0x0000003705057220ULL, 0x080fe40000410000ULL, 0x0000003720207220ULL, 0x080fe40000410000ULL,
0x0000003721217220ULL, 0x080fe40000410000ULL, 0x000000371c1c7220ULL, 0x080fe40000410000ULL,
0x000000371d1d7220ULL, 0x000fc40000410000ULL, 0x0000003714147220ULL, 0x080fe40000410000ULL,
0x0000003715157220ULL, 0x080fe40000410000ULL, 0x0000003710067220ULL, 0x080fe40000410000ULL,
0x0000003711077220ULL, 0x080fe40000410000ULL, 0x000000371a2a7220ULL, 0x080fe40000410000ULL,
0x000000371b2b7220ULL, 0x000fc40000410000ULL, 0x00000037122e7220ULL, 0x080fe40000410000ULL,
0x00000037132f7220ULL, 0x080fe40000410000ULL, 0x000000370a247220ULL, 0x080fe40000410000ULL,
0x000000370b257220ULL, 0x080fe40000410000ULL, 0x00000037162c7220ULL, 0x080fe40000410000ULL,
0x00000037172d7220ULL, 0x000fc40000410000ULL, 0x000000370c1a7220ULL, 0x080fe40000410000ULL,
0x000000370d1b7220ULL, 0x080fe40000410000ULL, 0x000000370e307220ULL, 0x080fe40000410000ULL,
0x000000370f317220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fe400078e0018ULL,
0x000000ffff137224ULL, 0x000fc400078e0019ULL, 0x0000003722227220ULL, 0x080fe40000410000ULL,
0x0000003723237220ULL, 0x080fe40000410000ULL, 0x000000371e287220ULL, 0x080fe40000410000ULL,
0x000000371f297220ULL, 0x000fe40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0009ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0005ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff107224ULL, 0x000fe400078e001cULL,
0x000000ffff117224ULL, 0x000fc400078e001dULL, 0x000000ffff167224ULL, 0x000fe400078e0014ULL,
0x000000ffff177224ULL, 0x000fe400078e0015ULL, 0x000000ffff187224ULL, 0x000fe400078e0006ULL,
0x000000ffff197224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000038087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe400078e0024ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0025ULL, 0x000000ffff207224ULL, 0x000fe400078e0022ULL,
0x000000ffff217224ULL, 0x000fe400078e0023ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0026ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0027ULL, 0x000000ffff227224ULL, 0x000fe400078e0028ULL,
0x000000ffff237224ULL, 0x000fc400078e0029ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fe400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fc400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0031ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040038077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604157210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040038077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000436157824ULL, 0x000fe200078e00ffULL, 0x000000393c00720cULL, 0x000fc80003f05270ULL,
0xfffffff015057812ULL, 0x000fca00078ec0ffULL, 0x0000008000147824ULL, 0x000fca00078e0205ULL,
0x0174000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000236087824ULL, 0x000fe400078e00ffULL, 0x00000001023d7824ULL, 0x000fc600078e0a3dULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x00000001082c7812ULL, 0x040fe400078efcffULL,
0x00000008082e7812ULL, 0x000fe400078efcffULL, 0x0000003d2c00720cULL, 0x080fe40003f26070ULL,
0x00000010082c7812ULL, 0x000fe400078efcffULL, 0x0000003d2e00720cULL, 0x080fe40003f06070ULL,
0x0000003d2c00720cULL, 0x000fc40003fc6070ULL, 0x00000011082e7812ULL, 0x040fe400078efcffULL,
0x00000018082c7812ULL, 0x040fe400078efcffULL, 0x0000003d0800720cULL, 0x080fe40003f46070ULL,
0x0000003d2e00720cULL, 0x080fe40003fa6070ULL, 0x0000003d2c00720cULL, 0x000fe40003f66070ULL,
0x0000000908307812ULL, 0x000fc400078efcffULL, 0x00000019082e7812ULL, 0x040fe400078efcffULL,
0x00000020082c7812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x0000003d3000720cULL, 0x080fe40003f86070ULL,
0x0000003d2e00720cULL, 0x080fe40003f46070ULL, 0x0000003d2c00720cULL, 0x000fe40003f26070ULL,
0x00000021082e7812ULL, 0x040fe400078efcffULL, 0x00000028082c7812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x0000003d2e00720cULL, 0x080fe40003f06070ULL, 0x0000003d2c00720cULL, 0x000fe40003f86070ULL,
0x00000029082e7812ULL, 0x000fc400078efcffULL, 0x00000030082c7812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x0000003d2e00720cULL, 0x000fc40003fc6070ULL, 0x0000003d2c00720cULL, 0x000fe40003fa6070ULL,
0x00000031082e7812ULL, 0x040fe400078efcffULL, 0x00000038082c7812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000024247808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x0000003d2e00720cULL, 0x080fe40003f66070ULL,
0x0000003d2c00720cULL, 0x000fc40003f46070ULL, 0x0000003d0800720cULL, 0x000fe40003f26070ULL,
0xff80000025257808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000028287808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff80000029297808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000002a2a7808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000002b2b7808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fe40003f3e000ULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000090c047208ULL, 0x000fe40004000000ULL, 0x000000051e087208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x000000040d057208ULL, 0x000fe40004000000ULL, 0x000000081f097208ULL, 0x000fc40004800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fc40003f3e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x0000000821097208ULL, 0x000fe40004800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fe40003f3e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x0000000922087208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fe40004800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000240900720bULL, 0x000fc40003f3e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x0000000924087208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000250800720bULL, 0x000fe40003f3e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x0000000825097208ULL, 0x000fc40004800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fe40003f3e000ULL,
0x0000000516047208ULL, 0x000fe40004000000ULL, 0x0000000926087208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fc40003f3e000ULL,
0x0000000417057208ULL, 0x000fe40004000000ULL, 0x0000000827097208ULL, 0x000fe40004800000ULL,
0x000000180500720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x0000000518047208ULL, 0x000fe40004000000ULL, 0x0000000928087208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x000000290800720bULL, 0x000fe40003f3e000ULL,
0x0000000419057208ULL, 0x000fe40004000000ULL, 0x0000000829097208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fc40003f3e000ULL,
0x000000051a047208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x000000041b2e7208ULL, 0x000fe40004000000ULL, 0x000000082b307208ULL, 0x000fe20004800000ULL,
0x000017927f007947ULL, 0x000fec000b800000ULL, 0x0c401f002e047f89ULL, 0x0004e400000e0000ULL,
0x000000042e00720bULL, 0x008fc80003f1e000ULL, 0x0000002e04317208ULL, 0x000fe20004000000ULL,
0x000017c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0030047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000e6200000e0000ULL,
0x000000043000720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000003004087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f0031047f89ULL, 0x000ee200000e0000ULL, 0x0000002c0700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000e6200000e0000ULL, 0x000000072c2c7208ULL, 0x000fc60004000000ULL,
0x0c201f00092e7f89ULL, 0x004ea800000e0000ULL, 0x0c201f002c2d7f89ULL, 0x0002a200000e0000ULL,
0x000000043100720bULL, 0x008fe40003f1e000ULL, 0x000000050800720bULL, 0x002fe40003f3e000ULL,
0x0000003104047208ULL, 0x000fe40004000000ULL, 0x0000002e0900720bULL, 0x004fc40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x000000092e067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b05317820ULL, 0x000fe20000410000ULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x0000000336ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x0000002d2c00720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b18187823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010831ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe40000010831ULL, 0x3fb8aa3b0a0a7823ULL, 0x000fe20000010807ULL,
0x00000018002e7308ULL, 0x002fe20000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010831ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fe40000010831ULL, 0x00000004ff327e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3f8000003232783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b10107823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b11117823ULL, 0x000fe40000010807ULL, 0x000000ffff337224ULL, 0x000fe200078e0032ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe40000010831ULL,
0x3fb8aa3b21217823ULL, 0x100fe40000010831ULL, 0x3fb8aa3b22227823ULL, 0x100fe40000010831ULL,
0x3fb8aa3b23237823ULL, 0x000fe20000010831ULL, 0x0000000d000d7308ULL, 0x000ea20000000800ULL,
0x000000080908723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b12127823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe40000010807ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b17177823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b19197823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010831ULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b25257823ULL, 0x000fc40000010831ULL,
0x3fb8aa3b26267823ULL, 0x100fe40000010831ULL, 0x3fb8aa3b27277823ULL, 0x000fe40000010831ULL,
0x0000001e000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b077823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b28287823ULL, 0x100fe40000010831ULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010831ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010831ULL, 0x0000001f00187308ULL, 0x000ea20000000800ULL,
0x0000001c1d09723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b2b2b7823ULL, 0x000fcc0000010831ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b180b723eULL, 0x004fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x00000032081c723cULL, 0x000f6e00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fce00000010ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x00000020210d723eULL, 0x002fe400000010ffULL, 0x00000002ff217819ULL, 0x000fc80000011636ULL,
0x0000000121107810ULL, 0x040fe20007ffe0ffULL, 0x00000019002f7308ULL, 0x000fe20000000800ULL,
0x0000000821117824ULL, 0x040fe200078e00ffULL, 0x0000000821447810ULL, 0x040fe20007ffe0ffULL,
0x0000000821427824ULL, 0x040fe400078e00ffULL, 0x00000008213e7824ULL, 0x000fe200078e00ffULL,
0xfffffff811207812ULL, 0x000fe400078ee210ULL, 0x00000022230f723eULL, 0x004fe200000010ffULL,
0x0000001a00307308ULL, 0x0003f00000000800ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x000000320c18723cULL, 0x022b6e000004181cULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x00000008211d7824ULL, 0x060fe200078e00ffULL, 0x00000004211c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008211f7824ULL, 0x000fca00078e00ffULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x000000161712723eULL, 0x004fe400000010ffULL, 0x0000000221167810ULL, 0x000fc40007ffe0ffULL,
0x0000000321177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81d227812ULL, 0x000fe200078ee216ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0xffffffff211d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000821167824ULL, 0x000fc600078e00ffULL, 0xfffffff842427812ULL, 0x000fe400078ee21dULL,
0xfffffff816167812ULL, 0x000fe200078ee221ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000242511723eULL, 0x002fe200000010ffULL, 0x0000000821247824ULL, 0x000fca00078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee217ULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x0000000521177810ULL, 0x000fc80007ffe0ffULL, 0xfffffff83e3e7812ULL, 0x000fe400078ee217ULL,
0x000000262713723eULL, 0x004fe200000010ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0xfffffff81f267812ULL, 0x000fe400078ee21cULL, 0x00000006211c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000844217824ULL, 0x000fe400078e00ffULL, 0x000000321018723cULL, 0x000f620000041818ULL,
0xfffffff81f407812ULL, 0x000fe200078ee21cULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x0000002e2f1c723eULL, 0x000fc400000010ffULL, 0x00000030071e723eULL, 0x002fe400000010ffULL,
0x0001100000077811ULL, 0x000fe400078e58ffULL, 0xfffffff821447812ULL, 0x000fe200078ee244ULL,
0x0000002a002a7308ULL, 0x000fe40000000800ULL, 0x0000001016167824ULL, 0x100fe400078e0207ULL,
0x0000001020207824ULL, 0x100fe400078e0207ULL, 0x0000001022227824ULL, 0x000fc400078e0207ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x00000028291d723eULL, 0x004fe200000010ffULL,
0x0000001024247824ULL, 0x100fe400078e0207ULL, 0x0000001026267824ULL, 0x000fe400078e0207ULL,
0x0000000116177824ULL, 0x000fe400078e0215ULL, 0x000000103e3e7824ULL, 0x100fe400078e0207ULL,
0x0000000115207824ULL, 0x000fe200078e0220ULL, 0x0000000817007388ULL, 0x0005e20000000800ULL,
0x0000001040407824ULL, 0x000fc400078e0207ULL, 0x0000000115227824ULL, 0x000fe200078e0222ULL,
0x0000000a20007388ULL, 0x0005e20000000800ULL, 0x0000002a2b1f723eULL, 0x002fe200000010ffULL,
0x0000001042427824ULL, 0x100fe400078e0207ULL, 0x0000000115247824ULL, 0x000fe200078e0224ULL,
0x0000000c22007388ULL, 0x0005e20000000800ULL, 0x0000001044447824ULL, 0x000fe200078e0207ULL,
0x0000002c2d077208ULL, 0x000fe20004800000ULL, 0x000000321c18723cULL, 0x020f620000041818ULL,
0x0000000115267824ULL, 0x040fe200078e0226ULL, 0x0000000e24007388ULL, 0x0005e20000000800ULL,
0x00000001153e7824ULL, 0x000fc400078e023eULL, 0x0000000115407824ULL, 0x040fe200078e0240ULL,
0x0000001026007388ULL, 0x0005e20000000800ULL, 0x0000000115427824ULL, 0x040fe400078e0242ULL,
0x0000000115447824ULL, 0x000fe200078e0244ULL, 0x000000123e007388ULL, 0x0005e80000000800ULL,
0x0000001c40007388ULL, 0x0005e80000000800ULL, 0x0000001e42007388ULL, 0x0005e80000000800ULL,
0x0000000944007388ULL, 0x0005e40000000800ULL, 0x000000ffff197224ULL, 0x020fc400078e001aULL,
0x0004000b20007388ULL, 0x0005e80000000800ULL, 0x0004000d22007388ULL, 0x0005e80000000800ULL,
0x0004000f24007388ULL, 0x0005e80000000800ULL, 0x0004001126007388ULL, 0x0005e80000000800ULL,
0x000400133e007388ULL, 0x0005e80000000800ULL, 0x0004001d40007388ULL, 0x0005e80000000800ULL,
0x0004001f42007388ULL, 0x0005e80000000800ULL, 0x0170000414008388ULL, 0x0005e80000000c00ULL,
0x0172001814008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003aff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000013c3c7810ULL, 0x000fe20007ffe0ffULL, 0x000018003aff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff3b7224ULL, 0x000fc400078e003fULL, 0x000000033c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffad0000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff267807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00016650002b7802ULL, 0x000fc40000000f00ULL,
0x0000100000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e002aULL,
0xfffeb84000007947ULL, 0x000fea000383ffffULL, 0x00000001ff267807ULL, 0x000fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x000166b0002b7802ULL, 0x000fc40000000f00ULL,
0x00000fa000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e002aULL,
0xfffeb88000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x008fe200078e002fULL,
0x00016720002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x00000ee000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002aULL, 0xfffeb92000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e002fULL, 0x00016790002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00000e7000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002aULL,
0xfffeba2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x00016810002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe400078e0029ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00000df000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff457224ULL, 0x004fe200078e002aULL,
0xfffebe0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0046ULL,
0x00016890002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0024ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00000d7000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff467224ULL, 0x004fe200078e002aULL,
0xfffebdb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff267807ULL, 0x004fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x000168f0002b7802ULL, 0x000fc40000000f00ULL,
0x00000d6000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e002aULL,
0xfffeed4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff267807ULL, 0x000fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00016950002b7802ULL, 0x000fc40000000f00ULL,
0x00000d0000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff297224ULL, 0x000fe200078e002aULL,
0xfffeed8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e002eULL,
0x000169c0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x00000c4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002aULL, 0xfffeee3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e002eULL, 0x00016a30002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00000bd000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002aULL,
0xfffeef2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x00016ab0002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe400078e0025ULL,
0x0000001fff2b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x00000b5000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff457224ULL, 0x004fe200078e002aULL,
0xfffef36000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x00016b20002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x00000ae000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff467224ULL, 0x004fe200078e002aULL, 0xfffef32000007947ULL, 0x000fea000383ffffULL,
0x00000001ff267807ULL, 0x002fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00016b80002b7802ULL, 0x000fc40000000f00ULL, 0x00000ad000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e002aULL, 0xffff1fd000007947ULL, 0x000fea000383ffffULL,
0x00000001ff267807ULL, 0x000fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00016be0002b7802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff297224ULL, 0x000fe200078e002aULL, 0xffff201000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e002eULL, 0x00016c50002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x000009b000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002aULL,
0xffff20d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e002eULL,
0x00016cc0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x0000094000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002aULL, 0xffff21c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00016d40002c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fe400078e0025ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x000008c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff457224ULL, 0x004fe200078e002aULL, 0xffff25b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00016db0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0000085000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff467224ULL, 0x004fe200078e002aULL,
0xffff257000007947ULL, 0x000fea000383ffffULL, 0x00000001ff267807ULL, 0x002fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00016e10002b7802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e002aULL,
0xffff526000007947ULL, 0x000fea000383ffffULL, 0x00000001ff267807ULL, 0x000fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00016e70002b7802ULL, 0x000fc40000000f00ULL,
0x000007e000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff297224ULL, 0x000fe200078e002aULL,
0xffff52a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e002eULL,
0x00016ee0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002aULL, 0xffff535000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e002eULL, 0x00016f50002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002aULL,
0xffff544000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x00016fd0002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe400078e0025ULL,
0x0000001fff2b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4d7424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff457224ULL, 0x004fe200078e002aULL,
0xffff583000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x00017040002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4d7424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff467224ULL, 0x004fe200078e002aULL, 0xffff57f000007947ULL, 0x000fea000383ffffULL,
0x00000002ff2f7424ULL, 0x000fe200078e00ffULL, 0x000170b000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff2d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002dULL,
0xffffe81000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x006fe200078e0030ULL,
0x0001713000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fc400078e00ffULL,
0x0000001fff2d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000002d3000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0006ULL, 0x000171b000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000302d307208ULL, 0x000fe20004000000ULL,
0x0000001fff2d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x0000002d0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0007ULL, 0x0001723000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000062d067208ULL, 0x000fe20004000000ULL,
0x0000001fff2d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002d0700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0031ULL, 0x000172b000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000072d2c7208ULL, 0x000fe20004000000ULL,
0x0000001fff2d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000002d3100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0030ULL, 0x0001733000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000312d047208ULL, 0x000fe20004000000ULL,
0x0000001fff2d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x0000002d3000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0006ULL, 0x000173b000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000302d057208ULL, 0x000fe20004000000ULL,
0x0000001fff2d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x0000002d0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e002cULL, 0x0001743000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000062d067208ULL, 0x000fe20004000000ULL,
0x0000001fff2d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe60000007947ULL, 0x000fea000383ffffULL,
0x0180000039007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000003900008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff39ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000039027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003900007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe8a4002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x0c00002f2e2d7389ULL, 0x0002a200000e002dULL, 0xfffe8a0008007950ULL, 0x000fea0003c3ffffULL,
0x0000004d00007348ULL, 0x000fe80003800000ULL, 0x000000262a2a7389ULL, 0x0002a200000e002bULL,
0x00000000ff277424ULL, 0x000fc400078e00ffULL, 0x000000ffff267224ULL, 0x002fc800078e002cULL,
0xfffe89b026007950ULL, 0x000fea0003c3ffffULL, 0x000000012600780cULL, 0x000fe20003f05070ULL,
0x0000002700007348ULL, 0x000fd80003800000ULL, 0x0000000000267806ULL, 0x000fc800040e0100ULL,
0x00000027262a7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff267224ULL, 0x000fe400078e002bULL,
0x00000000ff277424ULL, 0x000fc800078e00ffULL, 0xfffe894026007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000398ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d68ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e28ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015b0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015c0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001650ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001654ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000017780ULL, 0xe100001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018f80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018fd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019350ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001650ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017930ULL, 0x0000000000017930ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018f80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019350ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin_len = 103472;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
