/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017a50ULL, 0x00000000000176d0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x0000000000015a90ULL,
0x0000000000000180ULL, 0x000b0022000004c4ULL, 0x0000000000015c10ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000015c50ULL, 0x0000000000000050ULL, 0x000b002200000519ULL,
0x0000000000015ca0ULL, 0x0000000000000160ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000015e00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00015a9000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x0055640400288080ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9108288080820828ULL, 0x2880809308288080ULL,
0x8095082880809408ULL, 0x0828808096082880ULL, 0x80809c0828808097ULL, 0xa408288080a00828ULL,
0x288080a508288080ULL, 0x80aa08288080a608ULL, 0x08288080ab082880ULL, 0x8080c008288080beULL,
0xc808288080c70828ULL, 0x2880808408288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808084ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00015a9000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8c08288080820828ULL,
0x2880808e08288080ULL, 0x8091082880809008ULL, 0x0828808092082880ULL, 0x8080990828808093ULL,
0xa0082880809d0828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL, 0x08288080ab082880ULL,
0x8080c008288080beULL, 0xc808288080c70828ULL, 0x2880808808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808088ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL,
0x00015c1000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8c08288080820828ULL, 0x2880808e08288080ULL, 0x8091082880809008ULL,
0x0828808092082880ULL, 0x8080990828808093ULL, 0xa0082880809d0828ULL, 0x288080a408288080ULL,
0x80a608288080a508ULL, 0x08288080aa082880ULL, 0x8080c008288080beULL, 0xc808288080c70828ULL,
0x288080ab08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080abULL,
0x0000002cffffffffULL, 0x0000022800000000ULL, 0x00015c5000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x80a6288080ab0900ULL, 0x0000000000002880ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8c08288080820828ULL, 0x2880808e08288080ULL, 0x8091082880809008ULL,
0x0828808092082880ULL, 0x8080990828808093ULL, 0xa0082880809d0828ULL, 0x288080a408288080ULL,
0x80ab08288080a508ULL, 0x08288080be082880ULL, 0x8080c708288080c0ULL, 0xa608288080c80828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a6920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000030800000000ULL, 0x00015ca000000000ULL, 0x0000016000000000ULL,
0x0000000000000000ULL, 0x0000001a00082f04ULL, 0x00082304000000d3ULL, 0x0000000000000016ULL,
0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL,
0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0048016000000017ULL,
0x000c170400481903ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL,
0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000c001342804ULL,
0x00000400000000d0ULL, 0x00001f7000001eb0ULL, 0x000021f000002080ULL, 0x0000268000002650ULL,
0x00002720000026d0ULL, 0x000056c000005620ULL, 0x00005940000057e0ULL, 0x00005e3000005e00ULL,
0x00005ed000005e80ULL, 0x00008ba000008b00ULL, 0x00008e3000008cd0ULL, 0x000092d0000092a0ULL,
0x0000937000009320ULL, 0x0000c0900000bff0ULL, 0x0000c3100000c1b0ULL, 0x0000c7b00000c780ULL,
0x0000c8500000c800ULL, 0x0000ea100000ea00ULL, 0x000142f0000142b0ULL, 0x0001431000014300ULL,
0x0001438000014360ULL, 0x000143b0000143a0ULL, 0x0001505000015000ULL, 0x000150f0000150a0ULL,
0x000151b000015150ULL, 0x0001525000015200ULL, 0x000152f0000152a0ULL, 0x000153a000015350ULL,
0x00015440000153f0ULL, 0x000154e000015490ULL, 0x0001559000015540ULL, 0x00015630000155e0ULL,
0x000156d000015680ULL, 0x0001578000015730ULL, 0x00015830000157d0ULL, 0x000158f000015890ULL,
0x000159b000015950ULL, 0x00015a7000015a10ULL, 0x0000020004403904ULL, 0x0000f600000000ffULL,
0x00000260003f0100ULL, 0x0000f60800000003ULL, 0x00000370003f0120ULL, 0x0000f68800000003ULL,
0x000003a0003f0120ULL, 0x0000f6a800000003ULL, 0x000003d0003f0120ULL, 0x0000f6c800000003ULL,
0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000560003f0107ULL, 0x0000f68c00000035ULL,
0x000005f0003f0102ULL, 0x0000f68800000035ULL, 0x00000d60003f0101ULL, 0x0000f6a80000003aULL,
0x00000e70003f0107ULL, 0x0000f6a80000003aULL, 0x00000ed0003f0101ULL, 0x0000002000000024ULL,
0x00001030003f0101ULL, 0x000000040000003eULL, 0x00001210003f0105ULL, 0x000000040000003eULL,
0x00001a30003f0105ULL, 0x0000f6a800000030ULL, 0x00001b20003f0107ULL, 0x0000f6a800000030ULL,
0x00001b80003f0101ULL, 0x0000f60800000026ULL, 0x00001bd0003f0101ULL, 0x0000f60c00000024ULL,
0x00001da0003f0105ULL, 0x0000f60c00000024ULL, 0x000023b0003f0105ULL, 0x0000f6ac0000002cULL,
0x00002580003f0105ULL, 0x0000f6ac0000002cULL, 0x000046e0003f0105ULL, 0x000000000000003eULL,
0x00004760003f0101ULL, 0x0000f6880000004bULL, 0x000047e0003f0101ULL, 0x000000040000003eULL,
0x000049b0003f0105ULL, 0x000000040000003eULL, 0x00005210003f0105ULL, 0x0000f6a800000055ULL,
0x000052f0003f0107ULL, 0x0000f6a800000055ULL, 0x00005350003f0101ULL, 0x0000f62800000024ULL,
0x000053a0003f0101ULL, 0x0000f62c0000002aULL, 0x00005570003f0105ULL, 0x0000f62c0000002aULL,
0x00005b30003f0105ULL, 0x0000f6ac00000026ULL, 0x00005d20003f0105ULL, 0x0000f6ac0000002aULL,
0x00007cd0003f0105ULL, 0x000000000000003eULL, 0x00007d40003f0101ULL, 0x0000f6900000004bULL,
0x00007da0003f0101ULL, 0x000000040000003eULL, 0x00007f70003f0105ULL, 0x000000040000003eULL,
0x000086c0003f0105ULL, 0x0000000000000051ULL, 0x00008800003f0107ULL, 0x0000f6a800000026ULL,
0x00008860003f0101ULL, 0x0000f6480000002aULL, 0x00008880003f0101ULL, 0x0000f64c0000002aULL,
0x00008a50003f0105ULL, 0x0000f64c0000002aULL, 0x00009000003f0105ULL, 0x0000f6ac00000055ULL,
0x000091d0003f0105ULL, 0x0000f6ac00000055ULL, 0x0000b190003f0105ULL, 0x000000000000003eULL,
0x0000b200003f0101ULL, 0x0000f6980000004bULL, 0x0000b2a0003f0101ULL, 0x0000f6cc00000028ULL,
0x0000b470003f0105ULL, 0x0000f6cc00000028ULL, 0x0000bbc0003f0105ULL, 0x0000000000000056ULL,
0x0000bce0003f0107ULL, 0x0000f6a800000055ULL, 0x0000bd40003f0101ULL, 0x0000f6680000002aULL,
0x0000bd70003f0101ULL, 0x0000f66c0000002aULL, 0x0000bf40003f0105ULL, 0x0000f66c0000002aULL,
0x0000c4e0003f0105ULL, 0x0000f6ac00000057ULL, 0x0000c6b0003f0105ULL, 0x0000f6ac00000057ULL,
0x0000e5c0003f0105ULL, 0x000000000000003eULL, 0x0000e620003f0101ULL, 0x0000f6a00000004bULL,
0x0000f5f0003f0101ULL, 0x0000f600000000ffULL, 0x000100e0003f0101ULL, 0x0000f604000000ffULL,
0x000102b0003f0105ULL, 0x0000f604000000ffULL, 0x000104e0003f0105ULL, 0x0000f600000000ffULL,
0x00010510003f0101ULL, 0x0000f604000000ffULL, 0x000106d0003f0105ULL, 0x0000f604000000ffULL,
0x000136b0003f0105ULL, 0x0000000000000038ULL, 0x000137e0003f0101ULL, 0x0000000400000038ULL,
0x000139b0003f0105ULL, 0x0000000400000038ULL, 0x00014e60003f0105ULL, 0x000000000000003aULL,
0x00014ec0003f0101ULL, 0x000000080000003aULL, 0x00014f20003f0101ULL, 0x000000100000003aULL,
0x00014f90003f0101ULL, 0x000000180000003aULL, 0x00053803003f0101ULL, 0x0000f2d000141c04ULL,
0x000107300000f540ULL, 0x00014fd0000107e0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000003c4ULL, 0x0000001a00000002ULL, 0x00000000000002e4ULL, 0x0000001a00000002ULL,
0x0000000000000214ULL, 0x0000001a00000002ULL, 0x000000000000012cULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x000000000000039aULL, 0x0000001a00000002ULL,
0x00000000000002bfULL, 0x0000001a00000002ULL, 0x00000000000001efULL, 0x0000001a00000002ULL,
0x0000000000000107ULL, 0x0000001a00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000157806ULL, 0x000fe200038e0000ULL, 0x00005800ff097624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea40000002300ULL,
0x0000000809097824ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000ee80000002200ULL,
0x0000000000067919ULL, 0x000f280000000000ULL, 0x0000000000127919ULL, 0x000f280000002600ULL,
0x0000000000377919ULL, 0x000f220000002700ULL, 0x00000005ff007819ULL, 0x002fc60000011603ULL,
0x00001fff040f7589ULL, 0x0043e800000e0000ULL, 0x00001fff00007589ULL, 0x000ea200000e0000ULL,
0x0000010004027a24ULL, 0x008fe400078e0205ULL, 0x0000001500057300ULL, 0x000ee400000e0000ULL,
0x0000000002037a24ULL, 0x000fe400078e0203ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x0000000812087824ULL, 0x010fc400078e00ffULL, 0x000000ff0300720cULL, 0x040fe20003f45270ULL,
0x0000001500157309ULL, 0x000f220000000000ULL, 0x0000000f0300780cULL, 0x000fe20003f64070ULL,
0x00000037090a7224ULL, 0x000fe200078e0208ULL, 0x0000007f0300780cULL, 0x040fe40003f84070ULL,
0x000000030300780cULL, 0x000fe40003f24070ULL, 0x000000060500720cULL, 0x008fca0003f02070ULL,
0x3fffff80ff04a424ULL, 0x002fe400078e00ffULL, 0x000000040f0b7824ULL, 0x004fe400078e0200ULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x000000020b0b7824ULL, 0x000fe200078e00ffULL,
0x00000004ff107819ULL, 0x000fe20000011602ULL, 0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL,
0x00f60004ff00a388ULL, 0x0003e40000000a00ULL, 0x000000080b0c7817ULL, 0x000fe20007800000ULL,
0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL, 0x000000010300780cULL, 0x000fe20003f44070ULL,
0x0000001002117824ULL, 0x000fc400078e00ffULL, 0x000000010c0e7824ULL, 0x000fe200078e0a0bULL,
0x00f608060300b388ULL, 0x0005e20000008a00ULL, 0x000000010b0b7824ULL, 0x000fe400078e0210ULL,
0x00000100ff057424ULL, 0x002fe200078e00ffULL, 0x0000000e1000720cULL, 0x000fe20003f66070ULL,
0x000000010a047824ULL, 0x000fe400078e020bULL, 0xff317217ff14c424ULL, 0x000fe400078e00ffULL,
0x000000100b137824ULL, 0x000fc400078e00ffULL, 0x00005c0004047625ULL, 0x000fe200078e0005ULL,
0x000000f011077812ULL, 0x004fe200078ec0ffULL, 0x00f400140300c388ULL, 0x000fe40000004800ULL,
0x000000010b067824ULL, 0x000fe400078e0202ULL, 0x3fffff60ff089424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff099424ULL, 0x000fe200078e00ffULL, 0xfffffff0130e7812ULL, 0x000fe200078ee206ULL,
0x3fffff80ff0a9424ULL, 0x000fe200078e00ffULL, 0x0000000704067210ULL, 0x000fe20007f9e0ffULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x00f6880803009388ULL, 0x0003e20000008a00ULL,
0x3fffffc0ff0ca424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL,
0x00f6a80a03009388ULL, 0x000fe20000008a00ULL, 0x000000ffff077224ULL, 0x000fe400020e0605ULL,
0x00000004ff047424ULL, 0x000fe200078e00ffULL, 0x00f6c80c0300a388ULL, 0x000fe60000008a00ULL,
0x0000600037047625ULL, 0x000fc800078e0004ULL, 0x000000100e097824ULL, 0x002fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff087224ULL, 0x010fe200078e0a15ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fc40003f05270ULL,
0x000000ff03067810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff347819ULL, 0x000fce0000011606ULL,
0x0000f02000008947ULL, 0x000fea0003800000ULL, 0x0000000800357824ULL, 0x000fe400078e00ffULL,
0x00000003ff047424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f68c0435ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000000237377824ULL, 0x000fe200078e00ffULL,
0x0000580012047a10ULL, 0x002fe20007ffe0ffULL, 0x00f6880035ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001ff367819ULL, 0x000fe40000011600ULL, 0x0000000100397812ULL, 0x000fe200078ec0ffULL,
0x0000580037377a24ULL, 0x000fc400078e0204ULL, 0x0000002036387824ULL, 0x000fc800078e00ffULL,
0x0000620037047a24ULL, 0x000fe200078e0238ULL, 0x000003c000000947ULL, 0x000fea0003800000ULL,
0x0000003803057217ULL, 0x002fe20007800000ULL, 0x0000001039067824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fe20000011602ULL, 0x00000080ff137424ULL, 0x000fe200078e00ffULL,
0x0000007011157812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a38ULL,
0x00000004070a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0207ULL,
0x0000000c070c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000605057217ULL, 0x000fe20007800000ULL,
0x0000000109087824ULL, 0x000fc400078e0202ULL, 0x00000008090d7824ULL, 0x000fe400078e00ffULL,
0x0000000105057824ULL, 0x000fe400078e0a06ULL, 0x00000001060b7824ULL, 0x040fe200078e020aULL,
0xfffffff80d087812ULL, 0x000fe200078ee208ULL, 0x00000001060f7824ULL, 0x000fe200078e020cULL,
0x000000050a00720cULL, 0x080fe20003f46070ULL, 0x000000080b0e7824ULL, 0x000fe200078e00ffULL,
0x00000008070a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104107824ULL, 0x000fe200078e020fULL,
0x000000050700720cULL, 0x080fe20003f66070ULL, 0x000000010b077824ULL, 0x000fe200078e0202ULL,
0x000000050a00720cULL, 0x080fe20003f26070ULL, 0x00000001060d7824ULL, 0x000fe200078e020aULL,
0x000000050c00720cULL, 0x000fe20003f06070ULL, 0x0000000104057824ULL, 0x000fe200078e0209ULL,
0xfffffff80e0c7812ULL, 0x000fe200078ee207ULL, 0x0000000104067824ULL, 0x000fc400078e020bULL,
0x0000000104077824ULL, 0x000fe400078e020dULL, 0x00005e0005047625ULL, 0x000fc800078e0013ULL,
0x000000010f0b7824ULL, 0x140fe200078e0202ULL, 0x00000015040a7210ULL, 0x000fe20007f9e0ffULL,
0x000000080f127824ULL, 0x000fe400078e00ffULL, 0x000000010d097824ULL, 0x040fe400078e0202ULL,
0x000000080d0e7824ULL, 0x000fe200078e00ffULL, 0x0000b000360d7811ULL, 0x000fe400078e68ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x000000ffff0b7224ULL, 0x000fe200020e0605ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x00005e0006047625ULL, 0x000fc800078e0013ULL,
0x00000010080f7824ULL, 0x000fe200078e020dULL, 0x0000001504047210ULL, 0x000fe20007f9e0ffULL,
0x00005e0007067625ULL, 0x000fc600078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e2000d901c46ULL, 0x00005e0010087625ULL, 0x000fe200078e0013ULL,
0x0000001506067210ULL, 0x000fc60007fbe0ffULL, 0x000000100c117824ULL, 0x000fe200078e020dULL,
0x0000001508087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fe400020e0605ULL,
0x000000100e137824ULL, 0x000fe400078e020dULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000000004117faeULL, 0x0003e2000d101c46ULL, 0x00000010120d7824ULL, 0x000fe400078e020dULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000000006137faeULL, 0x0003e8000c901c46ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x0000001039057824ULL, 0x002fe200078e00ffULL, 0x0000007011137812ULL, 0x000fe200078ec0ffULL,
0x00000080ff117424ULL, 0x000fc600078e00ffULL, 0x0000000502057211ULL, 0x000fc800078fe8ffULL,
0x00000008050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x040fe200078e0202ULL,
0x0000000c050d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe400078e00ffULL,
0x000000080b157824ULL, 0x000fe400078e00ffULL, 0x00000001040f7824ULL, 0x040fe200078e020dULL,
0xfffffff8070c7812ULL, 0x000fe200078ee206ULL, 0x0000000104067824ULL, 0x000fe200078e0205ULL,
0x0000000405077810ULL, 0x000fe20007ffe0ffULL, 0x000000080d127824ULL, 0x000fc800078e00ffULL,
0x0000000104087824ULL, 0x040fe400078e0207ULL, 0x0000000107097824ULL, 0x040fe400078e0202ULL,
0x00000008070e7824ULL, 0x000fe400078e00ffULL, 0x0000000104077824ULL, 0x000fe400078e020bULL,
0x00005e0006047625ULL, 0x000fe200078e0011ULL, 0xfffffff80e0e7812ULL, 0x000fc600078ee209ULL,
0x000000010b067824ULL, 0x100fe200078e0202ULL, 0x00000013040a7210ULL, 0x000fe20007f1e0ffULL,
0x000000010d0b7824ULL, 0x000fc600078e0202ULL, 0xfffffff815107812ULL, 0x000fe200078ee206ULL,
0x00005e0007067625ULL, 0x000fe200078e0011ULL, 0xfffffff812127812ULL, 0x000fe400078ee20bULL,
0x0000b00036157811ULL, 0x000fe200078e68ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000001306067210ULL, 0x000fe20007f3e0ffULL, 0x00005e0008047625ULL, 0x000fc800078e0011ULL,
0x00005e000f087625ULL, 0x000fe200078e0011ULL, 0x0000001304047210ULL, 0x000fc60007f1e0ffULL,
0x000000100c0d7824ULL, 0x100fe200078e0215ULL, 0x0000001308087210ULL, 0x000fe20007f5e0ffULL,
0x000000100e0f7824ULL, 0x000fe400078e0215ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c46ULL,
0x0000001010117824ULL, 0x000fe400078e0215ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x00000000040f7faeULL, 0x0003e2000b901c46ULL, 0x0000001012137824ULL, 0x000fc400078e0215ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000000006117faeULL, 0x0003e8000b901c46ULL,
0x0000000008137faeULL, 0x0003e4000b901c46ULL, 0x00000010363a7824ULL, 0x000fe200078e00ffULL,
0x000000ff3400720cULL, 0x000fe20003f05270ULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x0000f6a836247811ULL, 0x000fe200078e18ffULL, 0x000000003a0473c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8003a587f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200024247f8cULL, 0x000ee2000c80043fULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000d71000008947ULL, 0x000fea0003800000ULL,
0x000000ffff2a7224ULL, 0x008fe400078e0025ULL, 0xff317217ff5b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fc400078e00ffULL, 0x000001003d247824ULL, 0x000fca00078e00ffULL,
0x000000032400720cULL, 0x000fda0003f06070ULL, 0x0000d65000000947ULL, 0x002fea0003800000ULL,
0x000000ffff3c7224ULL, 0x000fc400078e0025ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x0000f6c8363e7811ULL, 0x000fca00078e18ffULL, 0x000004003e297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fe4000780482aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028262b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011429ULL,
0x0000002b24247211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000224247819ULL, 0x000fc80000001229ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x000004003e297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000013d277810ULL, 0x040fe20007ffe0ffULL,
0x000001003d3f7824ULL, 0x000fe200078e0238ULL, 0x0000000125417812ULL, 0x000fe400078e0cffULL,
0x000000342700720cULL, 0x000fe40003f06070ULL, 0x000000403f267810ULL, 0x000fca0007ffe0ffULL,
0x00006200372e7a24ULL, 0x000fcc00078e0226ULL, 0x000003e000008947ULL, 0x000fea0003800000ULL,
0x00000003ff2a7819ULL, 0x000fe20000011602ULL, 0x00000010392b7824ULL, 0x000fe200078e00ffULL,
0x0000002603247217ULL, 0x000fe20007800000ULL, 0x0000001002287824ULL, 0x000fe200078e00ffULL,
0x0000000c2a327810ULL, 0x000fe20007ffe0ffULL, 0x000000012b277824ULL, 0x000fe400078e022aULL,
0x0000000124247824ULL, 0x000fe200078e0a26ULL, 0x0000007028337812ULL, 0x000fe200078ec0ffULL,
0x0000000127297824ULL, 0x040fe400078e0202ULL, 0x00000008272c7824ULL, 0x000fe200078e00ffULL,
0x000000242b247217ULL, 0x000fe20007800000ULL, 0x00000080ff317424ULL, 0x000fc400078e00ffULL,
0x0000000127267824ULL, 0x000fe200078e022eULL, 0xfffffff82c2d7812ULL, 0x000fe200078ee229ULL,
0x0000000124247824ULL, 0x000fe200078e0a2bULL, 0x000000042a297810ULL, 0x000fe20007ffe0ffULL,
0x00005e0026267625ULL, 0x000fc600078e0031ULL, 0x000000242a00720cULL, 0x080fe20003fa6070ULL,
0x000000012b2f7824ULL, 0x000fe200078e0229ULL, 0x0000003326287210ULL, 0x000fe20007fde0ffULL,
0x00000002362c7824ULL, 0x000fe200078e0241ULL, 0x000000242900720cULL, 0x000fe20003f06070ULL,
0x000000012f307824ULL, 0x040fe400078e0202ULL, 0x000000082f437824ULL, 0x040fe200078e00ffULL,
0x0000b0002c2c7811ULL, 0x000fe200078e60ffULL, 0x000000012f267824ULL, 0x000fe400078e022eULL,
0x000000ffff297224ULL, 0x000fe200030e0627ULL, 0xfffffff8432f7812ULL, 0x000fe200078ee230ULL,
0x00005e0026267625ULL, 0x000fe200078e0031ULL, 0x000000082a307810ULL, 0x000fc60007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e022cULL, 0x00000033262a7210ULL, 0x000fe20007fde0ffULL,
0x000000012b437824ULL, 0x040fe400078e0230ULL, 0x000000012b457824ULL, 0x000fe200078e0232ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0007e2000e901c46ULL,
0x0000000143267824ULL, 0x000fe200078e022eULL, 0x000000243000720cULL, 0x080fe20003fa6070ULL,
0x000000ffff2b7224ULL, 0x000fe200030e0627ULL, 0x000000243200720cULL, 0x000fe20003fc6070ULL,
0x000000102f2f7824ULL, 0x000fc400078e022cULL, 0x00005e0026267625ULL, 0x000fc600078e0031ULL,
0x000000002a2f7faeULL, 0x0009e2000c101c46ULL, 0x0000000145247824ULL, 0x000fe200078e022eULL,
0x0000003326267210ULL, 0x000fe20007f1e0ffULL, 0x00000001432d7824ULL, 0x048fe400078e0202ULL,
0x00000008432e7824ULL, 0x000fe400078e00ffULL, 0x00005e0024287625ULL, 0x000fc600078e0031ULL,
0xfffffff82e2d7812ULL, 0x000fe200078ee22dULL, 0x0000000145247824ULL, 0x040fe400078e0202ULL,
0x0000000845317824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x0000003328287210ULL, 0x000fe20007f1e0ffULL, 0x000000102d2b7824ULL, 0x010fe200078e022cULL,
0xfffffff831317812ULL, 0x000fc600078ee224ULL, 0x000000ffff297224ULL, 0x000fe200000e0629ULL,
0x00000000262b7faeULL, 0x0007e2000e901c46ULL, 0x00000010312d7824ULL, 0x000fca00078e022cULL,
0x00000000282d7faeULL, 0x0007e2000f101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001039277824ULL, 0x000fe400078e00ffULL, 0x00000080ff2b7424ULL, 0x000fc600078e00ffULL,
0x0000002702277211ULL, 0x000fc800078fe8ffULL, 0x0000000427297810ULL, 0x040fe20007ffe0ffULL,
0x0000000127247824ULL, 0x140fe200078e0202ULL, 0x00000008272d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008272f7824ULL, 0x040fe200078e00ffULL, 0x0000000c27437810ULL, 0x000fe20007ffe0ffULL,
0x0000000129267824ULL, 0x040fe400078e0202ULL, 0x0000000829317824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL, 0x0000001002247824ULL, 0x000fe400078e00ffULL,
0x000000012d287824ULL, 0x000fe200078e022eULL, 0xfffffff831317812ULL, 0x000fe200078ee226ULL,
0x0000000127267824ULL, 0x100fe200078e022eULL, 0x0000007024337812ULL, 0x000fe200078ec0ffULL,
0x0000000129247824ULL, 0x000fc400078e022eULL, 0x00005e0026267625ULL, 0x000fc800078e002bULL,
0x00000001432a7824ULL, 0x000fe200078e022eULL, 0x00000033262c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012d297824ULL, 0x140fe400078e0202ULL, 0x000000082d2e7824ULL, 0x000fe400078e00ffULL,
0x00000001432d7824ULL, 0x040fe400078e0202ULL, 0x0000000843307824ULL, 0x000fe200078e00ffULL,
0xfffffff82e437812ULL, 0x000fe200078ee229ULL, 0x0000000236267824ULL, 0x000fc400078e0241ULL,
0x00005e0028287625ULL, 0x000fe200078e002bULL, 0xfffffff830457812ULL, 0x000fe400078ee22dULL,
0x0000b000262e7811ULL, 0x000fe200078e60ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e0627ULL,
0x0000003328287210ULL, 0x000fe20007fbe0ffULL, 0x00005e0024267625ULL, 0x000fc800078e002bULL,
0x00005e002a2a7625ULL, 0x000fe200078e002bULL, 0x0000003326267210ULL, 0x000fc60007f1e0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e022eULL, 0x000000332a2a7210ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x100fe400078e022eULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0007e2000b901c46ULL,
0x0000001043337824ULL, 0x100fe400078e022eULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x0000000026317faeULL, 0x0007e2000b901c46ULL, 0x0000001045437824ULL, 0x000fc400078e022eULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0x0000000028337faeULL, 0x0007e8000b901c46ULL,
0x000000002a437faeULL, 0x0007e4000b901c46ULL, 0xfffffff035247812ULL, 0x040fe200078ec0ffULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000001035277812ULL, 0x008fe400078ec0ffULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000000841307824ULL, 0x000fe200078e0224ULL,
0xffffffe035247812ULL, 0x000fc800078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000124267824ULL, 0x000fe200078e0227ULL, 0x0000f6a830517810ULL, 0x000fc60007ffe0ffULL,
0x0000000839267824ULL, 0x000fc400078e0226ULL, 0x00000000510403c2ULL, 0x000ee40000060000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20001f0f070ULL,
0xffffff8000003947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80030307f8cULL, 0x000ee2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60800262a7f8cULL, 0x0002e4000c80043fULL, 0x0000000000267805ULL, 0x002fc40000015200ULL,
0x000000103a297812ULL, 0x000fca00078ec0ffULL, 0x0000000124247824ULL, 0x000fc800078e0229ULL,
0x0000000839247824ULL, 0x000fca00078e0224ULL, 0x00f60c0024297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x00afe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028262d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000002d28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c0024297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002247824ULL, 0x000fe200078e00ffULL,
0x00000001ff437819ULL, 0x000fe20000011602ULL, 0x0000002000407824ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe200078e00ffULL, 0x00000070242b7812ULL, 0x000fc400078ec0ffULL,
0xffffff8040407812ULL, 0x000fe400078ec0ffULL, 0x0000000c43437812ULL, 0x000fc800078ec0ffULL,
0x0000004043247210ULL, 0x000fca0007ffe02bULL, 0x00f0000024287984ULL, 0x000e680000000800ULL,
0x00f2000024297984ULL, 0x0006a20000000800ULL, 0x0000005b2800720bULL, 0x002fe20003f1d000ULL,
0x000131327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x008fc800000e0100ULL,
0x0000ffff242d7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff627424ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fc400078e005bULL,
0x0000001fff447424ULL, 0x000fe400078e00ffULL, 0xffffffffff457424ULL, 0x000fca00078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe40000011600ULL,
0x0000005b2800720bULL, 0x000fe40003f14000ULL, 0x000000002700720cULL, 0x000fe20003fa5270ULL,
0x000130c27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000247806ULL, 0x000fc400000e0100ULL,
0x000000800026d824ULL, 0x000fe200078e022bULL, 0x000000285b327209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x000000014327d824ULL, 0x000fe200078e0226ULL,
0x0000991024267816ULL, 0x000fc800000000ffULL, 0x00f400322700d388ULL, 0x0003e20000000800ULL,
0x000000ff2600720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000325b267221ULL, 0x002fe20000010000ULL, 0x000000ff24ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL,
0x00000026002f7308ULL, 0x0002ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x002fe20000011602ULL, 0x000130027f007947ULL, 0x000fea000b800000ULL,
0x00001f262f267589ULL, 0x0082e400000e0000ULL, 0x0000002608087220ULL, 0x088fe20000410000ULL,
0x0000002609097220ULL, 0x080fe20000410000ULL, 0x000000260c0c7220ULL, 0x080fe20000410000ULL,
0x000000260d0d7220ULL, 0x080fe20000410000ULL, 0x0000002610107220ULL, 0x080fe20000410000ULL,
0x0000002611117220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x0000002621217220ULL, 0x080fe20000410000ULL, 0x0000002604047220ULL, 0x080fe20000410000ULL,
0x0000002605057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0024ff7812ULL, 0x000fe2000780c0ffULL, 0x0000002f3b3b7220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802267811ULL, 0x002fe200078ff0ffULL,
0x00012ee27f007947ULL, 0x000fea000b800000ULL, 0x00001f262f267589ULL, 0x0002e400000e0000ULL,
0x000000260a0a7220ULL, 0x088fe20000410000ULL, 0x000000260b0b7220ULL, 0x080fe20000410000ULL,
0x000000260e0e7220ULL, 0x080fe20000410000ULL, 0x000000260f0f7220ULL, 0x080fe20000410000ULL,
0x0000002612127220ULL, 0x080fe20000410000ULL, 0x0000002613137220ULL, 0x080fe20000410000ULL,
0x0000002616167220ULL, 0x080fe20000410000ULL, 0x0000002617177220ULL, 0x080fe20000410000ULL,
0x000000261a1a7220ULL, 0x080fe20000410000ULL, 0x000000261b1b7220ULL, 0x080fe20000410000ULL,
0x000000261e1e7220ULL, 0x080fe20000410000ULL, 0x000000261f1f7220ULL, 0x080fe20000410000ULL,
0x0000002622227220ULL, 0x080fe20000410000ULL, 0x0000002623237220ULL, 0x080fe20000410000ULL,
0x0000002606067220ULL, 0x080fe20000410000ULL, 0x0000002607077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff2dff7812ULL, 0x000fda0007806024ULL,
0x8000003228280221ULL, 0x000fe20000010000ULL, 0x00007610ff620816ULL, 0x000fc60000000062ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800460308ULL, 0x000e640000000800ULL,
0x0000004629290220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003b293b7221ULL, 0x004fc20000010000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000008252c7824ULL, 0x000fca00078e023aULL, 0x00f6ac002c247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028262b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011429ULL, 0x0000002b24247211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000224247819ULL, 0x000fc80000001229ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac002c247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991062247816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003fc5270ULL,
0x0000012000006947ULL, 0x000fea0003800000ULL, 0x00000046ff24723eULL, 0x000fe400000010ffULL,
0x00000002ff297819ULL, 0x000fe40000011602ULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x00012ad27f007947ULL, 0x000fea000b800000ULL, 0x00001f2924477589ULL, 0x0002a400000e0000ULL,
0x0000000829487810ULL, 0x000fe20007ffe0ffULL, 0x00012b027f007947ULL, 0x000fea000b800000ULL,
0x00001f4824487589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001029267810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x000026e0002b7802ULL, 0x000fc40000000f00ULL, 0x0001357000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001829267810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x004fe200078e0024ULL, 0x00002730002b7802ULL, 0x000fc40000000f00ULL,
0x0001352000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000702277812ULL, 0x000fe200078ec0ffULL, 0x00000200004a7824ULL, 0x000fe200078e00ffULL,
0x00000004ff507819ULL, 0x100fe20000011602ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008277a7812ULL, 0x000fc400078ef802ULL, 0xfffff8004a4a7812ULL, 0x000fe200078ec0ffULL,
0x00000004367b7824ULL, 0x000fe200078e0250ULL, 0x00000008024f7812ULL, 0x000fe200078ec0ffULL,
0x000000087a247824ULL, 0x04afe400078e00ffULL, 0x000000017a7b7824ULL, 0x000fca00078e027bULL,
0xfffffff824497812ULL, 0x000fca00078ee27bULL, 0x0000001049497824ULL, 0x000fc400078e024aULL,
0x000000074f4f7812ULL, 0x000fe200078ef802ULL, 0x0000000439507824ULL, 0x000fe200078e0250ULL,
0x000000027b7b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000236257824ULL, 0x000fe200078e0225ULL,
0x000000104f557812ULL, 0x040fe200078efcffULL, 0x000000014f247824ULL, 0x040fe200078e0250ULL,
0x0000991062627816ULL, 0x000fe200000000ffULL, 0x000000084f277824ULL, 0x000fe200078e00ffULL,
0x0000b00025567811ULL, 0x000fe200078e60ffULL, 0x0000000150527824ULL, 0x000fe200078e0255ULL,
0x00000002244e7810ULL, 0x000fe20007ffe0ffULL, 0x000000087a7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff827257812ULL, 0x000fc400078ee224ULL, 0xfffffff8274e7812ULL, 0x000fe400078ee24eULL,
0xfffffff87a7b7812ULL, 0x000fe200078ee27bULL, 0x0000001025257824ULL, 0x100fe400078e0256ULL,
0x000000104e287824ULL, 0x000fe400078e0256ULL, 0x000000107b4a7824ULL, 0x000fe200078e024aULL,
0x00000000252c783bULL, 0x0002e80000004200ULL, 0x000000002828783bULL, 0x004ea20000004200ULL,
0x0000000855257824ULL, 0x002fca00078e00ffULL, 0xfffffff8254c7812ULL, 0x000fca00078ee252ULL,
0x000000104c247824ULL, 0x000fcc00078e0256ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x000001002c4d7824ULL, 0x008fe200078e00ffULL, 0x0000002c007d7306ULL, 0x000fe20000009400ULL,
0x00000018ffae7819ULL, 0x000fe2000001142cULL, 0x000001002fb47824ULL, 0x040fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe2000001142dULL, 0x000100002fa07824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe2000001144dULL, 0x0000010028a27824ULL, 0x044fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001142eULL, 0x0000002c00827306ULL, 0x000ea20000005400ULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000010029a37824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x0001000028a77824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001142fULL, 0x0001000029a67824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011428ULL, 0x0000008300947306ULL, 0x000fe20000209400ULL,
0x00000018ff997819ULL, 0x000fe20000011429ULL, 0x000001002aab7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fc4000001142aULL, 0x00000018ff807819ULL, 0x000fe4000001142bULL,
0x00000018ffa27819ULL, 0x000fe200000114a2ULL, 0x00000083009b7306ULL, 0x0007220000205400ULL,
0x000000827d00720bULL, 0x004fe40003f1d000ULL, 0x00000083007d7245ULL, 0x000fe4000020d400ULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x0000002c006c7306ULL, 0x000522000000d400ULL, 0x000000ae00837245ULL, 0x008fc4000020d400ULL,
0x00000018ffa67819ULL, 0x000fe400000114a6ULL, 0x00000018ffab7819ULL, 0x000fe400000114abULL,
0x00000018ff7c7819ULL, 0x002fe20000011424ULL, 0x000000ae00ad7306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x004fe200078e00ffULL, 0x0000009b9400720bULL, 0x010fe40003fbd000ULL,
0x000000bd009b7245ULL, 0x000fe4000020d400ULL, 0x00000018ff987819ULL, 0x000fe2000001142cULL,
0x000001002d2c7824ULL, 0x000fe200078e00ffULL, 0x000000ae00b07306ULL, 0x000e620000205400ULL,
0x000000016c6c0812ULL, 0x000fc400078efcffULL, 0x0000009800827245ULL, 0x000fe4000020d400ULL,
0x00000018ffb77819ULL, 0x000fe2000001142cULL, 0x000001002e2c7824ULL, 0x000fe200078e00ffULL,
0x000000017d7d5812ULL, 0x000fe200078efcffULL, 0x00000098009d7306ULL, 0x000fe20000209400ULL,
0x000000b700947245ULL, 0x000fe4000020d400ULL, 0x00000018ffc27819ULL, 0x000fe2000001142cULL,
0x00000008552c7824ULL, 0x000fe200078e00ffULL, 0x00000002524d7810ULL, 0x000fc40007ffe0ffULL,
0x00000018ff757819ULL, 0x000fe20000011425ULL, 0x00000098009e7306ULL, 0x000ea20000205400ULL,
0x000000b0ad00720bULL, 0x002fe20003f1d000ULL, 0x000001002bad7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011426ULL, 0x000100002ab07824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011427ULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x000000b700b87306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fc400000114b0ULL,
0xfffffff82c4d7812ULL, 0x000fe400078ee24dULL, 0x0000006c7d6c723eULL, 0x000fe400000010ffULL,
0x0000000183830812ULL, 0x000fe200078efcffULL, 0x000000b700b97306ULL, 0x0002e20000205400ULL,
0x0000009e9d00720bULL, 0x004fe20003fbd000ULL, 0x000000104d2c7824ULL, 0x000fe200078e0256ULL,
0x000000c2009d7245ULL, 0x000fca000020d400ULL, 0x0000002d00b27306ULL, 0x000fe20000009400ULL,
0x0001000024b77824ULL, 0x002fca00078e00ffULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x0000002d00b37306ULL, 0x000e620000005400ULL, 0x000000b9b800720bULL, 0x008fe40003fbd000ULL,
0x00000018ffb77819ULL, 0x000fe400000114b7ULL, 0x000000828382723eULL, 0x000fc600000010ffULL,
0x0000002d006b7306ULL, 0x0004ec000000d400ULL, 0x0000000194945812ULL, 0x000fe400078efcffULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x000100002d2d7824ULL, 0x004fe200078e00ffULL,
0x000000b3b200720bULL, 0x002fe20003f1d000ULL, 0x000100002bb37824ULL, 0x000fc400078e00ffULL,
0x0000010024b27824ULL, 0x000fe200078e00ffULL, 0x00000018ffba7819ULL, 0x000fe4000001142dULL,
0x000000bd00bf7306ULL, 0x000e620000205400ULL, 0x00000018ffb37819ULL, 0x000fe400000114b3ULL,
0x000000ba00987245ULL, 0x000fe4000020d400ULL, 0x00000018ffb27819ULL, 0x000fe400000114b2ULL,
0x000000016b6b0812ULL, 0x008fe200078efcffULL, 0x000000ba00bb7306ULL, 0x000ff00000209400ULL,
0x000000ba00bc7306ULL, 0x000ea20000205400ULL, 0x000000bfbe00720bULL, 0x002fce0003f1d000ULL,
0x000000c200c37306ULL, 0x000fec0000209400ULL, 0x000000019b9b0812ULL, 0x000fe400078efcffULL,
0x000000c200c47306ULL, 0x000e620000205400ULL, 0x000000bcbb00720bULL, 0x004fce0003fbd000ULL,
0x0000002e00c07306ULL, 0x000fec0000009400ULL, 0x0000000198985812ULL, 0x000fe400078efcffULL,
0x0000002e00c17306ULL, 0x000ea20000005400ULL, 0x000000c4c300720bULL, 0x002fe40003fbd000ULL,
0x000000989b83723eULL, 0x000fca00000010ffULL, 0x0000002e00667306ULL, 0x0002ec000000d400ULL,
0x000000019d9d5812ULL, 0x000fe400078efcffULL, 0x0000009300c87306ULL, 0x000fe20000209400ULL,
0x000100002e2e7824ULL, 0x002fe200078e00ffULL, 0x000000c1c000720bULL, 0x004fc80003f1d000ULL,
0x00000018ffc57819ULL, 0x000fe4000001142eULL, 0x0000009300c97306ULL, 0x0002a40000205400ULL,
0x000000c5009e7245ULL, 0x000fca000020d400ULL, 0x0000000166660812ULL, 0x008fe200078efcffULL,
0x000000c500c67306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fce000020d400ULL,
0x000000c500c77306ULL, 0x000e620000205400ULL, 0x000000c9c800720bULL, 0x004fce0003f1d000ULL,
0x000000b400ca7306ULL, 0x000fec0000209400ULL, 0x0000000193930812ULL, 0x000fe400078efcffULL,
0x000000b400cb7306ULL, 0x000ea20000205400ULL, 0x000000c7c600720bULL, 0x002fce0003fbd000ULL,
0x0000002f008f7306ULL, 0x000fec0000009400ULL, 0x000000019e9e5812ULL, 0x000fe400078efcffULL,
0x0000002f00927306ULL, 0x000e620000005400ULL, 0x000000cbca00720bULL, 0x004fce0003fbd000ULL,
0x000000a000b67306ULL, 0x000ff00000209400ULL, 0x000000a000b57306ULL, 0x0004e20000205400ULL,
0x000000928f00720bULL, 0x002fe40003f1d000ULL, 0x000000b4008f7245ULL, 0x000fc8000020d400ULL,
0x000000018f8f5812ULL, 0x000fe200078efcffULL, 0x00000028008c7306ULL, 0x000fe20000009400ULL,
0x000000a000a07245ULL, 0x004fce000020d400ULL, 0x00000028008d7306ULL, 0x000fe20000005400ULL,
0x000000b5b600720bULL, 0x008fce0003fbd000ULL, 0x00000028005f7306ULL, 0x000fec000000d400ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x0000002900897306ULL, 0x000ff00000009400ULL,
0x0000002900887306ULL, 0x000ff00000005400ULL, 0x00000029005e7306ULL, 0x000ff0000000d400ULL,
0x0000002a00867306ULL, 0x000ff00000009400ULL, 0x0000002a00857306ULL, 0x000ff00000005400ULL,
0x0000002a005c7306ULL, 0x000ff0000000d400ULL, 0x0000002b00847306ULL, 0x000ff00000009400ULL,
0x0000002b00817306ULL, 0x000ff00000005400ULL, 0x0000002b005d7306ULL, 0x0003f0000000d400ULL,
0x0000002f00687306ULL, 0x0004e2000000d400ULL, 0x009000004928783bULL, 0x002e6e0000000200ULL,
0x0000008e00917306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x004eae0000004200ULL,
0x0000008e00907306ULL, 0x000f220000205400ULL, 0x0000000168680812ULL, 0x008fc800078efcffULL,
0x000000688f8f723eULL, 0x000fc600000010ffULL, 0x000000a200cc7306ULL, 0x000ff00000209400ULL,
0x000000a200cd7306ULL, 0x0006a20000205400ULL, 0x000000909100720bULL, 0x010fe40003f1d000ULL,
0x0000008e00917245ULL, 0x000fca000020d400ULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x008fe2000020d400ULL, 0x000000472828e231ULL, 0x082fe400003400ffULL,
0x000000472a2ae231ULL, 0x000fe400003400ffULL, 0x0000000191910812ULL, 0x000fe200078efcffULL,
0x000000482929e231ULL, 0x080fe200003400ffULL, 0x000000a300a57306ULL, 0x0002e20000205400ULL,
0x000000cdcc00720bULL, 0x004fe20003fbd000ULL, 0x000000482b2be231ULL, 0x000fe200003400ffULL,
0x0000008d8c00720bULL, 0x000fe20003f1d000ULL, 0x000100002d687824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc4000001142cULL, 0x000000a09191723eULL, 0x000fe200000010ffULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fe2000020d400ULL,
0x00000082280c723cULL, 0x000f62000004180cULL, 0x00000018ff687819ULL, 0x000fc60000011468ULL,
0x00000001a2a25812ULL, 0x000fe400078efcffULL, 0x000000a700a97306ULL, 0x0002a20000205400ULL,
0x000000a5a400720bULL, 0x008fe40003fdd000ULL, 0x000000888900720bULL, 0x000fe40003fbd000ULL,
0x000000015f5f0812ULL, 0x000fe400078efcffULL, 0x0000009700887245ULL, 0x000fe2000020d400ULL,
0x00000097009c7306ULL, 0x000fe20000209400ULL, 0x000000a700a77245ULL, 0x002fc4000020d400ULL,
0x0000005fa2a2723eULL, 0x000fe200000010ffULL, 0x000001002e5f7824ULL, 0x000fe400078e00ffULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x0000009700a17306ULL, 0x000e620000205400ULL,
0x000000a9a800720bULL, 0x004fe40003f1d000ULL, 0x000000015e5e5812ULL, 0x000fe400078efcffULL,
0x00000018ff5f7819ULL, 0x000fc4000001145fULL, 0x0000005ea3a3723eULL, 0x000fe200000010ffULL,
0x000000a600aa7306ULL, 0x000fec0000209400ULL, 0x00000001a7a70812ULL, 0x000fe200078efcffULL,
0x000000a22818723cULL, 0x000fe20000041818ULL, 0x000000a600af7306ULL, 0x0004e20000205400ULL,
0x000000a19c00720bULL, 0x002fce0003fdd000ULL, 0x00000099009a7306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x004fca000020d400ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x00000099009f7306ULL, 0x0002a20000205400ULL, 0x000000afaa00720bULL, 0x008fe40003fbd000ULL,
0x000000a78888723eULL, 0x000fca00000010ffULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fca000020d400ULL, 0x00000001a6a65812ULL, 0x000fe400078efcffULL,
0x000000ab00b17306ULL, 0x0002e20000205400ULL, 0x0000009f9a00720bULL, 0x004fe40003f1d000ULL,
0x000000858600720bULL, 0x000fe40003fbd000ULL, 0x000000b200857245ULL, 0x000fe4000020d400ULL,
0x0000007c00867245ULL, 0x000fe2000020d400ULL, 0x000000ad00ae7306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fca000020d400ULL, 0x0000000199990812ULL, 0x000fe400078efcffULL,
0x000000ad00cf7306ULL, 0x000e620000205400ULL, 0x000000b1ac00720bULL, 0x008fe40003fdd000ULL,
0x000000015c5c5812ULL, 0x000fca00078efcffULL, 0x000000b000b87306ULL, 0x000fec0000209400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x000000b000b97306ULL, 0x0004e20000205400ULL,
0x000000cfae00720bULL, 0x002fe40003f1d000ULL, 0x000000818400720bULL, 0x000fc40003fdd000ULL,
0x000000ad00847245ULL, 0x000fe4000020d400ULL, 0x0000005cab5c723eULL, 0x000fe200000010ffULL,
0x0000008b00967306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x004fca000020d400ULL,
0x0000000184840812ULL, 0x000fe400078efcffULL, 0x0000008b00957306ULL, 0x0002a20000205400ULL,
0x000000b9b800720bULL, 0x008fe40003fbd000ULL, 0x000000015d5d6812ULL, 0x000fc800078efcffULL,
0x0000005d845d723eULL, 0x000fe200000010ffULL, 0x00000080008a7306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x00000001b0b05812ULL, 0x000fe200078efcffULL,
0x0000005c2820723cULL, 0x000fe20000041820ULL, 0x0000008000877306ULL, 0x0002e20000205400ULL,
0x000000959600720bULL, 0x004fce0003f1d000ULL, 0x0000002400797306ULL, 0x000fe20000009400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x000000018b8b0812ULL, 0x000fe400078efcffULL,
0x0000002400787306ULL, 0x000fe20000005400ULL, 0x000000878a00720bULL, 0x008fe40003fbd000ULL,
0x000000b08bb0723eULL, 0x000fca00000010ffULL, 0x0000002400547306ULL, 0x0003ec000000d400ULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x000000b200bc7306ULL, 0x000fe20000209400ULL,
0x0000010025247824ULL, 0x002fca00078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011424ULL,
0x0000010026247824ULL, 0x000fe200078e00ffULL, 0x000000b200bd7306ULL, 0x000e680000205400ULL,
0x00000018ff8c7819ULL, 0x000fe20000011424ULL, 0x0000010027247824ULL, 0x000fc600078e00ffULL,
0x000000b300ba7306ULL, 0x000fe40000209400ULL, 0x00000018ffa57819ULL, 0x000fcc0000011424ULL,
0x000000b300bb7306ULL, 0x0004e20000205400ULL, 0x000000bdbc00720bULL, 0x002fce0003f1d000ULL,
0x000000b700be7306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x004fca000020d400ULL,
0x0000000185850812ULL, 0x000fe400078efcffULL, 0x000000b700bf7306ULL, 0x000e620000205400ULL,
0x000000bbba00720bULL, 0x008fce0003fdd000ULL, 0x0000002500727306ULL, 0x000fec0000009400ULL,
0x00000001b3b36812ULL, 0x000fe400078efcffULL, 0x0000002500717306ULL, 0x000fe20000005400ULL,
0x000000bfbe00720bULL, 0x002fe40003fbd000ULL, 0x000000787900720bULL, 0x000fc40003fdd000ULL,
0x00000018ff787819ULL, 0x000fe4000001142dULL, 0x00000018ff797819ULL, 0x000fe2000001142eULL,
0x0000002500537306ULL, 0x0003e2000000d400ULL, 0x000000b380b1723eULL, 0x000fce00000010ffULL,
0x00000026006d7306ULL, 0x000fe20000009400ULL, 0x0001000025257824ULL, 0x002fe200078e00ffULL,
0x0000000154546812ULL, 0x000fe200078efcffULL, 0x000000b02804723cULL, 0x000fe60000041804ULL,
0x00000018ff907819ULL, 0x000fe40000011425ULL, 0x00000026006e7306ULL, 0x000ff00000005400ULL,
0x00000026004b7306ULL, 0x0003f0000000d400ULL, 0x00000027006f7306ULL, 0x000fe20000009400ULL,
0x0001000026267824ULL, 0x002fca00078e00ffULL, 0x00000018ff977819ULL, 0x000fe40000011426ULL,
0x0000002700707306ULL, 0x000ff00000005400ULL, 0x0000002700337306ULL, 0x0003f0000000d400ULL,
0x0000007c007f7306ULL, 0x000fe20000209400ULL, 0x0001000027277824ULL, 0x002fca00078e00ffULL,
0x00000018ffa87819ULL, 0x000fe40000011427ULL, 0x0000007c007e7306ULL, 0x000e620000205400ULL,
0x009000004a24783bULL, 0x000eae0000000200ULL, 0x0000009200b47306ULL, 0x000ff00000209400ULL,
0x0000009200b57306ULL, 0x0007220000205400ULL, 0x0000007e7f00720bULL, 0x002fc40003f1d000ULL,
0x000000b7007f7245ULL, 0x000fc8000020d400ULL, 0x000000017f7f5812ULL, 0x000fe200078efcffULL,
0x0000007500767306ULL, 0x000fe20000209400ULL, 0x000000717200720bULL, 0x000fe40003fbd000ULL,
0x0000009200927245ULL, 0x008fc6000020d400ULL, 0x0000000186860812ULL, 0x000fe400078efcffULL,
0x0000007500777306ULL, 0x0002e20000205400ULL, 0x000000ff6200720cULL, 0x000fe40003f05270ULL,
0x000000b5b400720bULL, 0x010fe40003fdd000ULL, 0x00000018ff627819ULL, 0x000fe4000001142fULL,
0x0000000153535812ULL, 0x000fe200078efcffULL, 0x0000008c00a47306ULL, 0x000fe20000209400ULL,
0x0000007500757245ULL, 0x002fca000020d400ULL, 0x0000004724248231ULL, 0x084fe400003400ffULL,
0x0000008c00897306ULL, 0x0002a20000205400ULL, 0x000000777600720bULL, 0x008fe20003fbd000ULL,
0x0000004726268231ULL, 0x000fe200003400ffULL, 0x0000000192926812ULL, 0x000fe200078efcffULL,
0x0000004825258231ULL, 0x080fe200003400ffULL, 0x000001002c767824ULL, 0x000fe200078e00ffULL,
0x0000004827278231ULL, 0x000fe400003400ffULL, 0x00000090008e7306ULL, 0x000fe20000209400ULL,
0x0000008c008c7245ULL, 0x002fc4000020d400ULL, 0x00000018ff877819ULL, 0x000fe40000011476ULL,
0x0000009000767245ULL, 0x000fe4000020d400ULL, 0x0000000175755812ULL, 0x000fe200078efcffULL,
0x00000090008d7306ULL, 0x0002e20000205400ULL, 0x00000089a400720bULL, 0x004fce0003f1d000ULL,
0x000000a5009c7306ULL, 0x000fe20000209400ULL, 0x0000009e9390723eULL, 0x002fca00000010ffULL,
0x000000018c8c0812ULL, 0x000fe400078efcffULL, 0x000000a500a17306ULL, 0x000e620000205400ULL,
0x0000008d8e00720bULL, 0x008fe20003fdd000ULL, 0x000000902814723cULL, 0x040f620000041814ULL,
0x000000706f00720bULL, 0x000fe40003f1d000ULL, 0x000000669d8e723eULL, 0x000fe400000010ffULL,
0x0000006700667245ULL, 0x000fe2000020d400ULL, 0x00000097009a7306ULL, 0x000fe80000209400ULL,
0x0000008e2810723cULL, 0x000f640000041810ULL, 0x0000000176766812ULL, 0x000fc400078efcffULL,
0x00000097009f7306ULL, 0x0004e20000205400ULL, 0x000000a19c00720bULL, 0x002fe40003fbd000ULL,
0x0000006e6d00720bULL, 0x000fe20003fdd000ULL, 0x000001002d6d7824ULL, 0x000fe200078e00ffULL,
0x000000a5006e7245ULL, 0x000fe4000020d400ULL, 0x0000000133330812ULL, 0x000fe200078efcffULL,
0x000000a800a97306ULL, 0x000fe20000209400ULL, 0x00000018ff8d7819ULL, 0x000fe4000001146dULL,
0x0000009700977245ULL, 0x004fc4000020d400ULL, 0x0000006b946d723eULL, 0x000fe400000010ffULL,
0x000000016e6e5812ULL, 0x000fe200078efcffULL, 0x000000a800aa7306ULL, 0x000e620000205400ULL,
0x0000009f9a00720bULL, 0x008fe40003fbd000ULL, 0x000000014b4b6812ULL, 0x000fe200078efcffULL,
0x0000006c2808723cULL, 0x000b620000041808ULL, 0x000000767575723eULL, 0x000fe400000010ffULL,
0x0000004b8c8c723eULL, 0x000fe200000010ffULL, 0x0000006700737306ULL, 0x000fe20000209400ULL,
0x00000002004b7824ULL, 0x000fc400078e00ffULL, 0x000100002f6c7824ULL, 0x020fc600078e00ffULL,
0x0000000197975812ULL, 0x000fe400078efcffULL, 0x0000006700747306ULL, 0x0004e20000205400ULL,
0x000000aaa900720bULL, 0x002fe40003f1d000ULL, 0x00000018ff6c7819ULL, 0x000fca000001146cULL,
0x0000006300697306ULL, 0x000fe20000209400ULL, 0x000000a800677245ULL, 0x004fca000020d400ULL,
0x0000000167670812ULL, 0x000fe400078efcffULL, 0x00000063006a7306ULL, 0x000e620000205400ULL,
0x000000747300720bULL, 0x008fe40003fdd000ULL, 0x0000007f8674723eULL, 0x000fca00000010ffULL,
0x0000008700897306ULL, 0x000fe40000209400ULL, 0x00000074240c723cULL, 0x000fe8000004180cULL,
0x0000000166666812ULL, 0x000fe400078efcffULL, 0x0000008700967306ULL, 0x0004e20000205400ULL,
0x0000006a6900720bULL, 0x002fe20003fbd000ULL, 0x000100002e697824ULL, 0x000fe200078e00ffULL,
0x000000976666723eULL, 0x000fe200000010ffULL, 0x000001002f6a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000002c00647306ULL, 0x000fe20000009400ULL,
0x0000008700877245ULL, 0x004fe4000020d400ULL, 0x00000018ff6a7819ULL, 0x000fca000001146aULL,
0x0000002c00657306ULL, 0x000e620000005400ULL, 0x000000968900720bULL, 0x008fe40003f1d000ULL,
0x000000a69989723eULL, 0x000fca00000010ffULL, 0x0000008d006f7306ULL, 0x000fe40000209400ULL,
0x00000088281c723cULL, 0x000b68000004181cULL, 0x0000000187870812ULL, 0x000fe400078efcffULL,
0x0000008d00707306ULL, 0x000ea20000205400ULL, 0x000000656400720bULL, 0x002fe40003fdd000ULL,
0x0000006300647245ULL, 0x000fc4000020d400ULL, 0x0000005f00287245ULL, 0x020fe4000020d400ULL,
0x0000000164645812ULL, 0x000fe200078efcffULL, 0x0000002c00527306ULL, 0x0002e6000000d400ULL,
0x000000676467723eULL, 0x000fca00000010ffULL, 0x0000002d00617306ULL, 0x000fe20000009400ULL,
0x000100002c2c7824ULL, 0x002fe200078e00ffULL, 0x000000706f00720bULL, 0x004fe20003fbd000ULL,
0x000000662414723cULL, 0x000f660000041814ULL, 0x00000018ff6b7819ULL, 0x000fe4000001142cULL,
0x0000002d00607306ULL, 0x000e620000005400ULL, 0x0000000152526812ULL, 0x008fc800078efcffULL,
0x000000528752723eULL, 0x000fc600000010ffULL, 0x0000002d00577306ULL, 0x000eb0000000d400ULL,
0x0000006b002c7306ULL, 0x000fe20000209400ULL, 0x000000606100720bULL, 0x002fce0003f1d000ULL,
0x0000006b002d7306ULL, 0x0003ec0000205400ULL, 0x0000000157570812ULL, 0x004fe400078efcffULL,
0x0000007a00817306ULL, 0x000fe20000209400ULL, 0x0000006b006b7245ULL, 0x002fce000020d400ULL,
0x0000007a008a7306ULL, 0x0002b00000205400ULL, 0x0000006800657306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x002fce000020d400ULL, 0x00000068005e7306ULL, 0x000e620000205400ULL,
0x0000008a8100720bULL, 0x004fce0003fdd000ULL, 0x0000002e00587306ULL, 0x000fec0000009400ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x0000002e005b7306ULL, 0x000fe20000005400ULL,
0x0000005e6500720bULL, 0x002fce0003f1d000ULL, 0x0000002e00557306ULL, 0x0003f0000000d400ULL,
0x00000078007b7306ULL, 0x000fe20000209400ULL, 0x0000008d002e7245ULL, 0x002fe4000020d400ULL,
0x000000336e8d723eULL, 0x000fc400000010ffULL, 0x000000012e2e5812ULL, 0x000fe400078efcffULL,
0x0000002d2c00720bULL, 0x000fe20003fbd000ULL, 0x00000078007e7306ULL, 0x0002a20000205400ULL,
0x00000054852c723eULL, 0x000fe200000010ffULL, 0x0000008c2410723cULL, 0x000f620000041810ULL,
0x00000053922d723eULL, 0x000fe400000010ffULL, 0x000000572e53723eULL, 0x000fc600000010ffULL,
0x0000005f00637306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x002fe2000020d400ULL,
0x0000002c2408723cULL, 0x000b640000041808ULL, 0x000000016b6b5812ULL, 0x000fc800078efcffULL,
0x0000005f00607306ULL, 0x000e620000205400ULL, 0x0000007e7b00720bULL, 0x004fe20003fbd000ULL,
0x000000522418723cULL, 0x000b620000041818ULL, 0x00000068007b7245ULL, 0x000fe4000020d400ULL,
0x0000006b7a7a723eULL, 0x000fe400000010ffULL, 0x000000017b7b0812ULL, 0x000fe200078efcffULL,
0x0000002f00597306ULL, 0x000fe20000009400ULL, 0x0000005b5800720bULL, 0x000fca0003f1d000ULL,
0x0000000178785812ULL, 0x000fe400078efcffULL, 0x0000002f00567306ULL, 0x000ea20000005400ULL,
0x000000606300720bULL, 0x002fe40003fdd000ULL, 0x0000007b787b723eULL, 0x000fc600000010ffULL,
0x0000000155550812ULL, 0x000fe400078efcffULL, 0x0000002f005a7306ULL, 0x000e64000000d400ULL,
0x0000007a241c723cULL, 0x000b68000004181cULL, 0x0000000128286812ULL, 0x000fe400078efcffULL,
0x0000006a002f7306ULL, 0x000fe20000209400ULL, 0x000000565900720bULL, 0x004fc40003fbd000ULL,
0x000000552828723eULL, 0x000fca00000010ffULL, 0x0000006a00547306ULL, 0x000eac0000205400ULL,
0x000000015a5a5812ULL, 0x002fe400078efcffULL, 0x0000006900297306ULL, 0x000ff00000209400ULL,
0x00000069002a7306ULL, 0x0002e20000205400ULL, 0x000000542f00720bULL, 0x004fce0003fdd000ULL,
0x00000079007c7306ULL, 0x000fe20000209400ULL, 0x0000006900697245ULL, 0x002fce000020d400ULL,
0x0000007900717306ULL, 0x000e620000205400ULL, 0x0000002a2900720bULL, 0x008fe40003f1d000ULL,
0x0000006a00297245ULL, 0x000fe4000020d400ULL, 0x00000079002a7245ULL, 0x000fe4000020d400ULL,
0x0000000129296812ULL, 0x000fe200078efcffULL, 0x0000006200727306ULL, 0x000fe60000209400ULL,
0x0000005a2929723eULL, 0x000fc600000010ffULL, 0x0000000169690812ULL, 0x000fe400078efcffULL,
0x0000006200777306ULL, 0x0004e20000205400ULL, 0x000000717c00720bULL, 0x002fe20003fdd000ULL,
0x000000282420723cULL, 0x000b6c0000041820ULL, 0x0000006c002b7306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fca000020d400ULL, 0x000000012a2a6812ULL, 0x000fe400078efcffULL,
0x0000006c002c7306ULL, 0x020e620000205400ULL, 0x000000777200720bULL, 0x008fe40003fbd000ULL,
0x000000692a2a723eULL, 0x000fd600000010ffULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x0000002c2b00720bULL, 0x002fe40003f1d000ULL, 0x0000006c002b7245ULL, 0x000fd6000020d400ULL,
0x000000012b2b0812ULL, 0x000fc800078efcffULL, 0x0000002b622b723eULL, 0x000fce00000010ffULL,
0x0000002a2404723cULL, 0x000b620000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000003e247f8cULL, 0x0202a2000c80043fULL, 0xfffffff84b4b7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000403d247811ULL, 0x004fe200078e40ffULL,
0x00f688004bff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0025ULL,
0x000000032400720cULL, 0x000fe20003f06070ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0032ULL,
0x000000ffff597224ULL, 0x000fc400078e0031ULL, 0x000000ffff257224ULL, 0x000fd000078e0041ULL,
0x00009e8000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x004fc40000015200ULL,
0x000004003e277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003e277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000013d257810ULL, 0x000fe40007ffe0ffULL, 0x000000803f267810ULL, 0x000fe40007ffe0ffULL,
0x000000342500720cULL, 0x000fc60003f06070ULL, 0x00006200372c7a24ULL, 0x000fd400078e0226ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x00000003ff297819ULL, 0x000fe20000011602ULL,
0x00000010392e7824ULL, 0x000fe200078e00ffULL, 0x0000002603247217ULL, 0x000fe20007800000ULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0x0000000c29557810ULL, 0x000fe20007ffe0ffULL,
0x000000012e2b7824ULL, 0x000fe400078e0229ULL, 0x0000000124257824ULL, 0x000fe400078e0a26ULL,
0x000000012b277824ULL, 0x040fe400078e0202ULL, 0x000000082b287824ULL, 0x000fe200078e00ffULL,
0x000000252e257217ULL, 0x000fe20007800000ULL, 0x000010003c247824ULL, 0x000fc400078e00ffULL,
0x0000001002267824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee227ULL,
0x00000001252a7824ULL, 0x000fe200078e0a2eULL, 0x0000100024277812ULL, 0x000fe200078ec0ffULL,
0x000000012b247824ULL, 0x000fe200078e022cULL, 0x00000004292b7810ULL, 0x040fe20007ffe0ffULL,
0x000000012e597824ULL, 0x000fe200078e0255ULL, 0x0000007026577812ULL, 0x000fe200078ec0ffULL,
0x00005e0024247625ULL, 0x000fe200078e0033ULL, 0x0000002a2900720cULL, 0x080fe40003fa6070ULL,
0x0000002a2b00720cULL, 0x000fe20003f06070ULL, 0x000000012e2d7824ULL, 0x000fe200078e022bULL,
0x0000005724267210ULL, 0x000fe20007fde0ffULL, 0x0000200036277824ULL, 0x000fc400078e0227ULL,
0x000000012d2f7824ULL, 0x040fe400078e0202ULL, 0x000000082d527824ULL, 0x000fe200078e00ffULL,
0x0000b000272b7810ULL, 0x000fe20007ffe0ffULL, 0x000000012d247824ULL, 0x000fe400078e022cULL,
0x000000ffff277224ULL, 0x000fe200030e0625ULL, 0xfffffff852527812ULL, 0x000fe200078ee22fULL,
0x00005e0024247625ULL, 0x000fe200078e0033ULL, 0x00000008292f7810ULL, 0x000fc60007ffe0ffULL,
0x00000010282d7824ULL, 0x000fe200078e022bULL, 0x0000005724287210ULL, 0x000fe20007fde0ffULL,
0x000000012e537824ULL, 0x000fc600078e022fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262d7faeULL, 0x0005e2000e901c46ULL, 0x0000000153247824ULL, 0x100fe200078e022cULL,
0x0000002a2f00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x0000002a5500720cULL, 0x000fe20003fc6070ULL, 0x00000010522f7824ULL, 0x000fe400078e022bULL,
0x00000001592a7824ULL, 0x000fe400078e022cULL, 0x00005e0024247625ULL, 0x000fe200078e0033ULL,
0x00000000282f7faeULL, 0x0007e6000c101c46ULL, 0x00000001532c7824ULL, 0x000fe200078e0202ULL,
0x0000005724247210ULL, 0x000fe20007f1e0ffULL, 0x00005e002a267625ULL, 0x004fc800078e0033ULL,
0x0000000853537824ULL, 0x000fe400078e00ffULL, 0x00000001592a7824ULL, 0x040fe400078e0202ULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0xfffffff8532c7812ULL, 0x000fe200078ee22cULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000005726267210ULL, 0x000fe40007f1e0ffULL,
0xfffffff8592a7812ULL, 0x000fe200078ee22aULL, 0x000000102c297824ULL, 0x008fc400078e022bULL,
0x000000ffff277224ULL, 0x000fe400000e0627ULL, 0x000000102a2b7824ULL, 0x000fe200078e022bULL,
0x0000000024297faeULL, 0x0005e8000e901c46ULL, 0x00000000262b7faeULL, 0x0005e2000f101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001039257824ULL, 0x000fe400078e00ffULL,
0x0000001002577824ULL, 0x000fc400078e00ffULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x0000002502257211ULL, 0x000fe400078fe8ffULL, 0x0000007057577812ULL, 0x000fe400078ec0ffULL,
0x00000004252f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000125247824ULL, 0x140fe200078e0202ULL,
0x0000000825537810ULL, 0x040fe20007ffe0ffULL, 0x00000008252d7824ULL, 0x040fe200078e00ffULL,
0x0000000c25557810ULL, 0x000fe20007ffe0ffULL, 0x000000012f267824ULL, 0x000fc400078e0202ULL,
0x000000082f337824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee224ULL,
0x000010003c247824ULL, 0x000fe400078e00ffULL, 0x0000000155287824ULL, 0x000fe200078e022cULL,
0xfffffff833337812ULL, 0x000fe200078ee226ULL, 0x000000012f267824ULL, 0x100fe200078e022cULL,
0x0000100024277812ULL, 0x000fe200078ec0ffULL, 0x0000000125247824ULL, 0x000fe400078e022cULL,
0x00000001532e7824ULL, 0x000fc400078e0202ULL, 0x00005e0024247625ULL, 0x000fc800078e0029ULL,
0x00002000362b7824ULL, 0x000fe200078e0227ULL, 0x00000057242a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000153277824ULL, 0x040fe400078e022cULL, 0x0000000853537824ULL, 0x000fe200078e00ffULL,
0x0000b0002b2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2b7224ULL, 0x000fe400000e0625ULL,
0x00005e0026247625ULL, 0x000fe200078e0029ULL, 0xfffffff853537812ULL, 0x000fc600078ee22eULL,
0x00005e0027267625ULL, 0x000fe200078e0029ULL, 0x0000005724247210ULL, 0x000fc60007f1e0ffULL,
0x00000001552f7824ULL, 0x040fe200078e0202ULL, 0x0000005726267210ULL, 0x000fe20007fbe0ffULL,
0x0000000855527824ULL, 0x000fe400078e00ffULL, 0x00005e0028287625ULL, 0x000fc600078e0029ULL,
0xfffffff852557812ULL, 0x000fe200078ee22fULL, 0x000000102d2d7824ULL, 0x100fe200078e022cULL,
0x0000005728287210ULL, 0x000fe20007fde0ffULL, 0x00000010332f7824ULL, 0x100fe400078e022cULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2d7faeULL, 0x0005e2000b901c46ULL, 0x0000001053337824ULL, 0x100fe400078e022cULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x00000000242f7faeULL, 0x0005e2000b901c46ULL,
0x0000001055537824ULL, 0x000fc400078e022cULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x0000000026337faeULL, 0x0005e8000b901c46ULL, 0x0000000028537faeULL, 0x0005e4000b901c46ULL,
0x000000083c247824ULL, 0x004fe200078e00ffULL, 0xfffffff035557812ULL, 0x040fe200078ec0ffULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0xffffffe035267812ULL, 0x000fe400078ec0ffULL,
0x0000000824247812ULL, 0x000fc400078ec0ffULL, 0x0000001035257812ULL, 0x000fe400078ec0ffULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000000155557824ULL, 0x000fe400078e0224ULL,
0x0000000126247824ULL, 0x000fc600078e0225ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000839247824ULL, 0x000fe200078e0224ULL, 0x0000f6a855567810ULL, 0x000fca0007ffe0ffULL,
0x00000000560403c2ULL, 0x000ea40000040000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000170f070ULL, 0xffffff8000002947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a80055587f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280024287f8cULL, 0x0002a4000c80043fULL,
0x0000000000247805ULL, 0x002fc40000015200ULL, 0x000000103a277812ULL, 0x000fca00078ec0ffULL,
0x0000000126267824ULL, 0x000fc800078e0227ULL, 0x00000008392a7824ULL, 0x000fca00078e0226ULL,
0x00f62c002a277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x006fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c002a277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008057247810ULL, 0x000fca0007ffe040ULL, 0x0000000143247824ULL, 0x000fca00078e0224ULL,
0x00f0000024257984ULL, 0x000e680000000800ULL, 0x00f2000024287984ULL, 0x0004e20000000800ULL,
0x000000322500720bULL, 0x002fe20003f1d000ULL, 0x0000fbc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x004fc800000e0100ULL, 0x0000ffff24ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff5b7224ULL, 0x000fd200078e0032ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x0000000100277811ULL, 0x000fe400078ff0ffULL, 0x000000322500720bULL, 0x000fe40003f14000ULL,
0x000000002700720cULL, 0x000fe20003fa5270ULL, 0x0000fb727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000297806ULL, 0x000fc400000e0100ULL, 0x000000800026d824ULL, 0x000fe200078e0257ULL,
0x0000003225277209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x00000001432ad824ULL, 0x000fe200078e0226ULL, 0x0000991029267816ULL, 0x000fc800000000ffULL,
0x00f400272a00d388ULL, 0x0003e20000000800ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000002732267221ULL, 0x002fe20000010000ULL,
0x000000ff29ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL, 0x00000026002c7308ULL, 0x000e640000000800ULL,
0x0000002c3b3b7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011602ULL, 0x0000faa27f007947ULL, 0x000fea000b800000ULL,
0x00001f262c267589ULL, 0x0002a400000e0000ULL, 0x0000002608087220ULL, 0x084fe20000410000ULL,
0x0000002609097220ULL, 0x080fe20000410000ULL, 0x000000260c0c7220ULL, 0x080fe20000410000ULL,
0x000000260d0d7220ULL, 0x080fe20000410000ULL, 0x0000002610107220ULL, 0x080fe20000410000ULL,
0x0000002611117220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x0000002621217220ULL, 0x080fe20000410000ULL, 0x0000002604047220ULL, 0x080fe20000410000ULL,
0x0000002605057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0029ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802267811ULL, 0x000fe200078ff0ffULL, 0x0000f9927f007947ULL, 0x000fea000b800000ULL,
0x00001f262c267589ULL, 0x00046400000e0000ULL, 0x000000260a0a7220ULL, 0x082fe20000410000ULL,
0x000000260b0b7220ULL, 0x080fe20000410000ULL, 0x000000260e0e7220ULL, 0x080fe20000410000ULL,
0x000000260f0f7220ULL, 0x080fe20000410000ULL, 0x0000002612127220ULL, 0x080fe20000410000ULL,
0x0000002613137220ULL, 0x080fe20000410000ULL, 0x0000002616167220ULL, 0x080fe20000410000ULL,
0x0000002617177220ULL, 0x080fe20000410000ULL, 0x000000261a1a7220ULL, 0x080fe20000410000ULL,
0x000000261b1b7220ULL, 0x080fe20000410000ULL, 0x000000261e1e7220ULL, 0x080fe20000410000ULL,
0x000000261f1f7220ULL, 0x080fe20000410000ULL, 0x0000002622227220ULL, 0x080fe20000410000ULL,
0x0000002623237220ULL, 0x080fe20000410000ULL, 0x0000002606067220ULL, 0x080fe20000410000ULL,
0x0000002607077220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff29ff7812ULL, 0x000fe20007800824ULL, 0x00000001ff297424ULL, 0x000fe200078e00ffULL,
0x00000032255b7209ULL, 0x000fd60007810000ULL, 0x8000005b25250221ULL, 0x000fe20000010000ULL,
0x00007610ff290816ULL, 0x000fc60000000029ULL, 0x3fb8aa3b25250820ULL, 0x000fc80000410000ULL,
0x0000002500460308ULL, 0x000e640000000800ULL, 0x0000004628280220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003b283b7221ULL, 0x008fc20000010000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000000841577824ULL, 0x000fc800078e00ffULL,
0x000000013a267824ULL, 0x000fca00078e0257ULL, 0x00f6ac0026277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000000013a2a7824ULL, 0x000fc400078e0257ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6ac002a277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991029247816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000046ff24723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe40000011602ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x0000f5227f007947ULL, 0x000fea000b800000ULL,
0x00001f2524477589ULL, 0x0002e400000e0000ULL, 0x0000000825267810ULL, 0x000fe20007ffe0ffULL,
0x0000f5527f007947ULL, 0x000fea000b800000ULL, 0x00001f2624487589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001025267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00005e90002b7802ULL, 0x000fc40000000f00ULL,
0x0000fdc000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001825267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x004fe200078e0024ULL,
0x00005ee0002b7802ULL, 0x000fc40000000f00ULL, 0x0000fd7000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000014f247824ULL, 0x042fe200078e0250ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000084f257824ULL, 0x000fc400078e00ffULL,
0x00000002366d7824ULL, 0x000fc600078e0241ULL, 0xfffffff825247812ULL, 0x000fe400078ee224ULL,
0x0000b0006d6d7811ULL, 0x000fca00078e60ffULL, 0x0000001024587824ULL, 0x100fe400078e026dULL,
0x000000104e547824ULL, 0x100fe400078e026dULL, 0x000000104c537824ULL, 0x100fe200078e026dULL,
0x000000005824783bULL, 0x000e620000004200ULL, 0x000000104d527824ULL, 0x000fc600078e026dULL,
0x000000005428783bULL, 0x004ea80000004200ULL, 0x000000005330783bULL, 0x000f280000004200ULL,
0x00000000522c783bULL, 0x000ee20000004200ULL, 0x00000100249e7824ULL, 0x042fe200078e00ffULL,
0x0000002400927306ULL, 0x000fe20000009400ULL, 0x00000018ffae7819ULL, 0x000fe20000011424ULL,
0x0001000024a97824ULL, 0x000fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fe20000011425ULL,
0x0000010025b47824ULL, 0x000fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe2000001149eULL,
0x0000010026be7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe200000114a9ULL,
0x0000002400997306ULL, 0x000e620000005400ULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0000010027c67824ULL, 0x000fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fc400000114beULL,
0x00000018ffc17819ULL, 0x000fe40000011426ULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x0000002400877306ULL, 0x000ee2000000d400ULL, 0x00000018ffca7819ULL, 0x000fe40000011427ULL,
0x00000018ffa47819ULL, 0x004fe40000011428ULL, 0x00000018ffa17819ULL, 0x000fe40000011429ULL,
0x00000018ff8e7819ULL, 0x010fe20000011430ULL, 0x0000009e00a77306ULL, 0x000fe20000209400ULL,
0x000000999200720bULL, 0x002fc40003fbd000ULL, 0x0000009e00927245ULL, 0x000fe4000020d400ULL,
0x000000a900997245ULL, 0x000fe4000020d400ULL, 0x00000018ff987819ULL, 0x000fe2000001142aULL,
0x0000009e00247306ULL, 0x0002a20000205400ULL, 0x00000018ff957819ULL, 0x000fe4000001142bULL,
0x00000018ff897819ULL, 0x000fe40000011431ULL, 0x00000018ff7d7819ULL, 0x000fc40000011432ULL,
0x0000000187875812ULL, 0x008fe200078efcffULL, 0x000000ae00b07306ULL, 0x000fe20000209400ULL,
0x00010000279e7824ULL, 0x002fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011433ULL,
0x00000018ff627819ULL, 0x000fe4000001142eULL, 0x00000018ffc97819ULL, 0x000fe4000001149eULL,
0x000000ae00b17306ULL, 0x0002e20000205400ULL, 0x00000024a700720bULL, 0x004fe20003fdd000ULL,
0x0000010028a77824ULL, 0x000fe200078e00ffULL, 0x000000ae009e7245ULL, 0x000fc4000020d400ULL,
0x00000018ff5f7819ULL, 0x000fe4000001142fULL, 0x00000018ff6c7819ULL, 0x000fe2000001142cULL,
0x000000a900aa7306ULL, 0x000fe20000209400ULL, 0x000000be00ae7245ULL, 0x002fe4000020d400ULL,
0x00000018ff607819ULL, 0x000fc6000001142dULL, 0x0000000192926812ULL, 0x000fe400078efcffULL,
0x000000a900af7306ULL, 0x0002a20000205400ULL, 0x000000b1b000720bULL, 0x008fe20003fbd000ULL,
0x000001002ab17824ULL, 0x000fcc00078e00ffULL, 0x0000002500b27306ULL, 0x000fe20000009400ULL,
0x000000b400a97245ULL, 0x002fca000020d400ULL, 0x000000019e9e5812ULL, 0x000fe400078efcffULL,
0x0000002500b37306ULL, 0x000e620000005400ULL, 0x000000afaa00720bULL, 0x004fe20003fdd000ULL,
0x0000010029aa7824ULL, 0x000fe200078e00ffULL, 0x000000c600af7245ULL, 0x000fca000020d400ULL,
0x000000b400b57306ULL, 0x000fec0000209400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x000000b400b67306ULL, 0x0004e20000205400ULL, 0x000000b3b200720bULL, 0x002fe20003fbd000ULL,
0x000001002bb37824ULL, 0x000fcc00078e00ffULL, 0x0000002500867306ULL, 0x000322000000d400ULL,
0x00000018ffb47819ULL, 0x004fce00000114a7ULL, 0x000000b900ba7306ULL, 0x000fe20000209400ULL,
0x0001000025257824ULL, 0x002fe200078e00ffULL, 0x000000b6b500720bULL, 0x008fc80003fdd000ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x000000b900bb7306ULL, 0x000e620000205400ULL,
0x0000000186865812ULL, 0x010fe400078efcffULL, 0x0000002500a77245ULL, 0x000fc8000020d400ULL,
0x00000001a9a96812ULL, 0x000fe200078efcffULL, 0x0000002500b77306ULL, 0x000ff00000209400ULL,
0x0000002500b87306ULL, 0x000ea20000205400ULL, 0x000000bbba00720bULL, 0x002fc40003fbd000ULL,
0x00000018ffba7819ULL, 0x000fe400000114aaULL, 0x000000b900aa7245ULL, 0x000fe4000020d400ULL,
0x00000018ffbb7819ULL, 0x000fe200000114b3ULL, 0x0000002600bc7306ULL, 0x000fe20000009400ULL,
0x000000ca00b37245ULL, 0x000fca000020d400ULL, 0x00000001aaaa5812ULL, 0x000fe400078efcffULL,
0x0000002600bd7306ULL, 0x000e620000005400ULL, 0x000000b8b700720bULL, 0x004fce0003fdd000ULL,
0x000000be00bf7306ULL, 0x000fec0000209400ULL, 0x00000001a7a76812ULL, 0x000fe400078efcffULL,
0x000000be00c07306ULL, 0x000ea20000205400ULL, 0x000000bdbc00720bULL, 0x002fce0003fbd000ULL,
0x0000002600817306ULL, 0x0002f0000000d400ULL, 0x0000002700c47306ULL, 0x000fe20000009400ULL,
0x000000c0bf00720bULL, 0x004fe20003fdd000ULL, 0x0001000026267824ULL, 0x002fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002700c57306ULL, 0x000e620000005400ULL,
0x0000000181815812ULL, 0x008fe400078efcffULL, 0x0000002600b07245ULL, 0x000fc6000020d400ULL,
0x00000001aeae6812ULL, 0x000fe400078efcffULL, 0x000000c600c77306ULL, 0x000ff00000209400ULL,
0x000000c600c87306ULL, 0x000ea20000205400ULL, 0x000000c5c400720bULL, 0x002fce0003fbd000ULL,
0x0000002700807306ULL, 0x000e70000000d400ULL, 0x000000c100c27306ULL, 0x000fe20000209400ULL,
0x000000c8c700720bULL, 0x004fce0003fdd000ULL, 0x000000c100c37306ULL, 0x000ea20000205400ULL,
0x0000000180805812ULL, 0x002fca00078efcffULL, 0x00000001afaf6812ULL, 0x000fe400078efcffULL,
0x0000002600247306ULL, 0x000ff00000209400ULL, 0x0000002600277306ULL, 0x0002e20000205400ULL,
0x000000c3c200720bULL, 0x004fce0003fbd000ULL, 0x000000ca00cb7306ULL, 0x000fe20000209400ULL,
0x00000018ff267819ULL, 0x002fe400000114b1ULL, 0x000000c100b17245ULL, 0x000fc8000020d400ULL,
0x00000001b1b15812ULL, 0x000fe200078efcffULL, 0x000000ca00cc7306ULL, 0x000e620000205400ULL,
0x000000272400720bULL, 0x008fce0003fdd000ULL, 0x000000c900b57306ULL, 0x000fec0000209400ULL,
0x00000001b0b06812ULL, 0x000fe400078efcffULL, 0x000000c900b27306ULL, 0x000ea20000205400ULL,
0x000000cccb00720bULL, 0x002fe40003fbd000ULL, 0x000000b0b1b0723eULL, 0x000fca00000010ffULL,
0x0000002800ad7306ULL, 0x000fec0000009400ULL, 0x00000001b3b35812ULL, 0x000fe400078efcffULL,
0x0000002800ac7306ULL, 0x000e620000005400ULL, 0x000000b2b500720bULL, 0x004fe40003fdd000ULL,
0x000000c900b27245ULL, 0x000fca000020d400ULL, 0x000000b400b67306ULL, 0x000fec0000209400ULL,
0x00000001b2b26812ULL, 0x000fe400078efcffULL, 0x000000b400b77306ULL, 0x0004e20000205400ULL,
0x000000acad00720bULL, 0x002fe40003fbd000ULL, 0x000000b400ad7245ULL, 0x000fc4000020d400ULL,
0x000000b2b3b1723eULL, 0x000fc600000010ffULL, 0x00000028007c7306ULL, 0x000322000000d400ULL,
0x0000010030b47824ULL, 0x004fca00078e00ffULL, 0x00000018ffb47819ULL, 0x000fe400000114b4ULL,
0x0000002900ab7306ULL, 0x000fe20000009400ULL, 0x000000b7b600720bULL, 0x008fe20003fdd000ULL,
0x0001000028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000002900a87306ULL, 0x000e620000005400ULL, 0x000000017c7c5812ULL, 0x010fca00078efcffULL,
0x00000001adad6812ULL, 0x000fe400078efcffULL, 0x000000ba00b97306ULL, 0x000fe40000209400ULL,
0x0000007cad7c723eULL, 0x000fcc00000010ffULL, 0x000000ba00bc7306ULL, 0x000ea20000205400ULL,
0x000000a8ab00720bULL, 0x002fe20003fbd000ULL, 0x000100002bab7824ULL, 0x000fe200078e00ffULL,
0x000000ba00a87245ULL, 0x000fc8000020d400ULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x00000029007b7306ULL, 0x0002f0000000d400ULL, 0x000000a400a67306ULL, 0x000fe20000209400ULL,
0x000000bcb900720bULL, 0x004fe20003fdd000ULL, 0x0001000029297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x000000a400a57306ULL, 0x0002a20000205400ULL,
0x000000017b7b5812ULL, 0x008fca00078efcffULL, 0x00000001a8a86812ULL, 0x000fe400078efcffULL,
0x0000002800257306ULL, 0x000fe20000209400ULL, 0x000000a400a47245ULL, 0x002fce000020d400ULL,
0x0000002800b87306ULL, 0x0002e20000205400ULL, 0x000000a5a600720bULL, 0x004fe40003fbd000ULL,
0x0000002800a57245ULL, 0x000fca000020d400ULL, 0x000000a100a37306ULL, 0x000fe20000209400ULL,
0x0001000030287824ULL, 0x002fca00078e00ffULL, 0x00000001a4a45812ULL, 0x000fe400078efcffULL,
0x000000a100a27306ULL, 0x0002a20000205400ULL, 0x000000b82500720bULL, 0x008fce0003fdd000ULL,
0x0000002900247306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fca000020d400ULL,
0x00000001a5a56812ULL, 0x000fe400078efcffULL, 0x0000002900277306ULL, 0x000e620000205400ULL,
0x000000a2a300720bULL, 0x004fe40003fbd000ULL, 0x00000018ffa27819ULL, 0x000fe20000011428ULL,
0x0000010031287824ULL, 0x000fe200078e00ffULL, 0x000000a5a4a4723eULL, 0x000fc600000010ffULL,
0x0000002a00a07306ULL, 0x000fec0000009400ULL, 0x00000001a1a15812ULL, 0x000fe400078efcffULL,
0x0000002a009f7306ULL, 0x000ea20000005400ULL, 0x000000272400720bULL, 0x002fce0003fdd000ULL,
0x0000002600b57306ULL, 0x000ff00000209400ULL, 0x0000002600be7306ULL, 0x0002e20000205400ULL,
0x0000009fa000720bULL, 0x004fe40003fbd000ULL, 0x0000002600a07245ULL, 0x000fc4000020d400ULL,
0x00000018ff9f7819ULL, 0x000fc60000011428ULL, 0x0000003000947306ULL, 0x000fe20000009400ULL,
0x0001000031267824ULL, 0x002fce00078e00ffULL, 0x0000003000937306ULL, 0x000ff00000005400ULL,
0x00000030006f7306ULL, 0x0003f0000000d400ULL, 0x0000002a00757306ULL, 0x000522000000d400ULL,
0x0000002900307245ULL, 0x002fc8000020d400ULL, 0x0000000130306812ULL, 0x000fe400078efcffULL,
0x000000beb500720bULL, 0x008fe20003fdd000ULL, 0x0000002b009d7306ULL, 0x000fe20000009400ULL,
0x000100002a2a7824ULL, 0x004fe200078e00ffULL, 0x00000030a1a5723eULL, 0x000fc800000010ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002b009c7306ULL, 0x000e620000005400ULL,
0x0000000175755812ULL, 0x010fc600078efcffULL, 0x00000001a0a06812ULL, 0x000fc800078efcffULL,
0x000000bb00b67306ULL, 0x000fe20000209400ULL, 0x00000075a030723eULL, 0x000fce00000010ffULL,
0x000000bb00b77306ULL, 0x000ea20000205400ULL, 0x0000009c9d00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff9d7819ULL, 0x000fe20000011426ULL, 0x0000010032267824ULL, 0x000fc800078e00ffULL,
0x0000002b00747306ULL, 0x000e70000000d400ULL, 0x00000098009b7306ULL, 0x000fe20000209400ULL,
0x000000b7b600720bULL, 0x004fe40003fdd000ULL, 0x00000018ffb67819ULL, 0x000fca0000011426ULL,
0x00000098009a7306ULL, 0x000ea20000205400ULL, 0x0000000174745812ULL, 0x002fce00078efcffULL,
0x0000002a00ac7306ULL, 0x000ff00000209400ULL, 0x0000002a002b7306ULL, 0x000e620000205400ULL,
0x0000009a9b00720bULL, 0x004fe40003fbd000ULL, 0x0000002a009a7245ULL, 0x000fc4000020d400ULL,
0x00000098009b7245ULL, 0x000fc6000020d400ULL, 0x00000031008c7306ULL, 0x000fec0000009400ULL,
0x000000019b9b5812ULL, 0x000fe400078efcffULL, 0x00000031008f7306ULL, 0x000ff00000005400ULL,
0x0000003100717306ULL, 0x0005f0000000d400ULL, 0x0000009500977306ULL, 0x000fe20000209400ULL,
0x000000bb00317245ULL, 0x004fc8000020d400ULL, 0x0000000131316812ULL, 0x000fe400078efcffULL,
0x0000002bac00720bULL, 0x002fe20003fdd000ULL, 0x0000009500967306ULL, 0x0002a20000205400ULL,
0x009800004928783bULL, 0x000ee20000000200ULL, 0x000000743131723eULL, 0x000fcc00000010ffULL,
0x000000ab00257306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x002fc6000020d400ULL,
0x000000019a9a6812ULL, 0x000fc800078efcffULL, 0x000000ab00a67306ULL, 0x000e620000205400ULL,
0x000000969700720bULL, 0x004fe40003fbd000ULL, 0x000000ab00967245ULL, 0x000fca000020d400ULL,
0x000000b400247306ULL, 0x000fec0000209400ULL, 0x0000000195955812ULL, 0x000fe400078efcffULL,
0x000000b400277306ULL, 0x000ea20000205400ULL, 0x000000a62500720bULL, 0x002fe20003fdd000ULL,
0x0000010033257824ULL, 0x000fe200078e00ffULL, 0x000000939400720bULL, 0x000fc80003fbd000ULL,
0x00000018ffa67819ULL, 0x000fe20000011425ULL, 0x0000008e00907306ULL, 0x000fe20000209400ULL,
0x0000004728288231ULL, 0x088fe400003400ffULL, 0x000000472a2a8231ULL, 0x000fe400003400ffULL,
0x0000004829298231ULL, 0x080fe200003400ffULL, 0x0000000196966812ULL, 0x000fe200078efcffULL,
0x000000482b2b8231ULL, 0x000fe200003400ffULL, 0x0000008e00917306ULL, 0x0002e20000205400ULL,
0x000000272400720bULL, 0x004fe20003fdd000ULL, 0x0001000032247824ULL, 0x000fe200078e00ffULL,
0x000000016f6f5812ULL, 0x000fc400078efcffULL, 0x000000969595723eULL, 0x000fe200000010ffULL,
0x000000b02814723cULL, 0x000fe20000041814ULL, 0x00000018ff937819ULL, 0x000fe20000011424ULL,
0x000000a200a37306ULL, 0x000fe20000209400ULL, 0x009800004a24783bULL, 0x000ea20000000200ULL,
0x0000008e008e7245ULL, 0x002fc8000020d400ULL, 0x000000a4281c723cULL, 0x000fe4000004181cULL,
0x000000a200b87306ULL, 0x000e620000205400ULL, 0x000000919000720bULL, 0x008fe20003fbd000ULL,
0x0001000033907824ULL, 0x000fc800078e00ffULL, 0x000000302820723cULL, 0x000fe20000041820ULL,
0x00000018ff907819ULL, 0x000fe20000011490ULL, 0x0000003200887306ULL, 0x000fec0000009400ULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x00000032008b7306ULL, 0x000ee20000005400ULL,
0x0000008f8c00720bULL, 0x000fc40003fbd000ULL, 0x0000009f008c7245ULL, 0x000fca000020d400ULL,
0x00000032005e7306ULL, 0x0008ec000000d400ULL, 0x0000000171715812ULL, 0x000fe400078efcffULL,
0x0000009f00b57306ULL, 0x000fe20000209400ULL, 0x000000b400327245ULL, 0x010fe2000020d400ULL,
0x0000004724248231ULL, 0x084fe200003400ffULL, 0x000001002eb47824ULL, 0x000fe200078e00ffULL,
0x0000004726268231ULL, 0x000fe200003400ffULL, 0x0000000132326812ULL, 0x000fe200078efcffULL,
0x0000004825258231ULL, 0x080fe200003400ffULL, 0x000000b8a300720bULL, 0x002fe20003fdd000ULL,
0x0000009f009c7306ULL, 0x000e620000205400ULL, 0x0000004827278231ULL, 0x000fe200003400ffULL,
0x0000008b8800720bULL, 0x008fe20003f1d000ULL, 0x000100002f887824ULL, 0x000fe200078e00ffULL,
0x000000b6008b7245ULL, 0x000fe2000020d400ULL, 0x000100002da37824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fc400000114b4ULL, 0x0000003300857306ULL, 0x000fe20000009400ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ffa37819ULL, 0x000fc800000114a3ULL,
0x000000015e5e0812ULL, 0x000fe200078efcffULL, 0x0000003300847306ULL, 0x000ff00000005400ULL,
0x00000033005d7306ULL, 0x0005f0000000d400ULL, 0x00000089008a7306ULL, 0x000fe20000209400ULL,
0x000000a200337245ULL, 0x004fe2000020d400ULL, 0x000001002ca27824ULL, 0x000fc600078e00ffULL,
0x0000000133336812ULL, 0x000fe400078efcffULL, 0x0000009cb500720bULL, 0x002fe20003fdd000ULL,
0x00000089008d7306ULL, 0x0002a20000205400ULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x000100002eb57824ULL, 0x000fe200078e00ffULL, 0x000000338e8e723eULL, 0x000fc800000010ffULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x0000009d00ac7306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x002fc6000020d400ULL, 0x000000018c8c6812ULL, 0x000fc800078efcffULL,
0x0000009d00b77306ULL, 0x000e620000205400ULL, 0x0000008d8a00720bULL, 0x004fe20003fdd000ULL,
0x000001002d8a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe2000001148aULL,
0x000000b600987306ULL, 0x000fe20000209400ULL, 0x0000009d008a7245ULL, 0x000fca000020d400ULL,
0x0000000189896812ULL, 0x000fe400078efcffULL, 0x000000b600977306ULL, 0x000ea20000205400ULL,
0x000000b7ac00720bULL, 0x002fe20003fbd000ULL, 0x000001002fb77824ULL, 0x000fca00078e00ffULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x000000a600ab7306ULL, 0x000fec0000209400ULL,
0x000000018a8a5812ULL, 0x000fe400078efcffULL, 0x000000a600ba7306ULL, 0x0002e20000205400ULL,
0x000000979800720bULL, 0x004fce0003fbd000ULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fca000020d400ULL, 0x000000018b8b5812ULL, 0x000fe400078efcffULL,
0x0000009300917306ULL, 0x0002a20000205400ULL, 0x000000baab00720bULL, 0x008fe40003fdd000ULL,
0x000000848500720bULL, 0x000fca0003fbd000ULL, 0x0000007d00827306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x00000001a6a66812ULL, 0x000fe400078efcffULL,
0x0000007d00837306ULL, 0x000e620000205400ULL, 0x000000919400720bULL, 0x004fe40003f1d000ULL,
0x000000015d5d5812ULL, 0x000fe400078efcffULL, 0x0000009a9b94723eULL, 0x000fc600000010ffULL,
0x00000090009c7306ULL, 0x000fe80000209400ULL, 0x000000942804723cULL, 0x000fe40000041804ULL,
0x0000000193930812ULL, 0x000fe400078efcffULL, 0x00000090008f7306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003fdd000ULL, 0x0000007a007f7306ULL, 0x000ff00000209400ULL,
0x0000007a007e7306ULL, 0x0002e20000205400ULL, 0x0000008f9c00720bULL, 0x004fe40003f1d000ULL,
0x0000008a898f723eULL, 0x000fca00000010ffULL, 0x000000a2008d7306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x002fce000020d400ULL, 0x000000a200ac7306ULL, 0x000e620000205400ULL,
0x0000007e7f00720bULL, 0x008fce0003fbd000ULL, 0x0000002e006b7306ULL, 0x000fec0000009400ULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x0000002e00647306ULL, 0x000ff00000005400ULL,
0x0000002e00637306ULL, 0x0005f0000000d400ULL, 0x0000002f00697306ULL, 0x000fe20000009400ULL,
0x000000999e2e723eULL, 0x004fce00000010ffULL, 0x0000002f006a7306ULL, 0x000ff00000005400ULL,
0x0000002f006e7306ULL, 0x0005f0000000d400ULL, 0x0000002c00797306ULL, 0x000fe20000009400ULL,
0x000000a7aa2f723eULL, 0x004fce00000010ffULL, 0x0000002c00787306ULL, 0x000ea20000005400ULL,
0x0000002e280c723cULL, 0x000b6e000004180cULL, 0x0000002c005c7306ULL, 0x000722000000d400ULL,
0x0000007d002e7245ULL, 0x020fe4000020d400ULL, 0x00000090002f7245ULL, 0x000fc4000020d400ULL,
0x000000012e2e6812ULL, 0x000fe400078efcffULL, 0x000000ac8d00720bULL, 0x002fe20003fdd000ULL,
0x0000002d00767306ULL, 0x000fe20000009400ULL, 0x000100002c2c7824ULL, 0x008fe200078e00ffULL,
0x000000012f2f0812ULL, 0x000fe400078efcffULL, 0x000000787900720bULL, 0x004fe40003f1d000ULL,
0x00000018ff977819ULL, 0x000fe4000001142cULL, 0x0000002d00777306ULL, 0x000e620000005400ULL,
0x00000087922c723eULL, 0x000fe200000010ffULL, 0x0000008e240c723cULL, 0x000fe2000004180cULL,
0x000000a200797245ULL, 0x000fc4000020d400ULL, 0x0000007ba87d723eULL, 0x000fe400000010ffULL,
0x0000000179796812ULL, 0x000fe200078efcffULL, 0x0000002d005a7306ULL, 0x0004e2000000d400ULL,
0x000000015c5c0812ULL, 0x010fe400078efcffULL, 0x000000932e2e723eULL, 0x000fe200000010ffULL,
0x0000007c2818723cULL, 0x000fe20000041818ULL, 0x0000002f7a2f723eULL, 0x000fe400000010ffULL,
0x0000005c795c723eULL, 0x000fe200000010ffULL, 0x0000009f009d7306ULL, 0x000fe20000209400ULL,
0x00000086a92d723eULL, 0x004fc400000010ffULL, 0x000000777600720bULL, 0x002fe20003fdd000ULL,
0x0000002e2414723cULL, 0x000fe80000041814ULL, 0x0000009f00987306ULL, 0x0002a80000205400ULL,
0x0000002c2808723cULL, 0x000be80000041808ULL, 0x0000006c00737306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fc4000020d400ULL, 0x00000081ae2c723eULL, 0x020fe400000010ffULL,
0x00000080af2d723eULL, 0x000fe400000010ffULL, 0x000000015a5a6812ULL, 0x008fe200078efcffULL,
0x0000006c00727306ULL, 0x0002e20000205400ULL, 0x000000989d00720bULL, 0x004fc60003fbd000ULL,
0x0000002c2810723cULL, 0x000b680000041810ULL, 0x0000009700867306ULL, 0x000fe20000209400ULL,
0x0000006c006c7245ULL, 0x002fe4000020d400ULL, 0x0000006f322c723eULL, 0x020fe400000010ffULL,
0x0000005e8b28723eULL, 0x000fe400000010ffULL, 0x000000019f9f5812ULL, 0x000fe200078efcffULL,
0x0000009700857306ULL, 0x0002a20000205400ULL, 0x000000727300720bULL, 0x008fc40003f1d000ULL,
0x0000005da629723eULL, 0x000fe400000010ffULL, 0x0000005a9f5d723eULL, 0x000fc600000010ffULL,
0x000000a300807306ULL, 0x000fe20000209400ULL, 0x0000009700977245ULL, 0x002fc6000020d400ULL,
0x000000282410723cULL, 0x000b640000041810ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x000000a3002d7306ULL, 0x0002e20000205400ULL, 0x000000858600720bULL, 0x004fc60003fbd000ULL,
0x0000005c2418723cULL, 0x000f680000041818ULL, 0x0000006000617306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x0000000197975812ULL, 0x000fe400078efcffULL,
0x0000006000707306ULL, 0x0002a20000205400ULL, 0x0000002d8000720bULL, 0x008fe40003fdd000ULL,
0x000000718c2d723eULL, 0x000fe400000010ffULL, 0x000000976c28723eULL, 0x020fc600000010ffULL,
0x000000b4007b7306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x002fe2000020d400ULL,
0x0000002c2408723cULL, 0x000f680000041808ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x000000b400787306ULL, 0x0002e20000205400ULL, 0x000000706100720bULL, 0x004fe40003fbd000ULL,
0x000000646b00720bULL, 0x000fca0003fdd000ULL, 0x000000b700747306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x002fca000020d400ULL, 0x0000000160605812ULL, 0x000fe400078efcffULL,
0x000000b700317306ULL, 0x0002a20000205400ULL, 0x000000787b00720bULL, 0x008fe40003f1d000ULL,
0x0000000163636812ULL, 0x000fe400078efcffULL, 0x000000a36029723eULL, 0x000fc600000010ffULL,
0x000000b5002a7306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fc6000020d400ULL,
0x00000028241c723cULL, 0x000b64000004181cULL, 0x00000001b4b40812ULL, 0x000fe400078efcffULL,
0x000000b5002b7306ULL, 0x000e620000205400ULL, 0x000000317400720bULL, 0x004fe40003fbd000ULL,
0x0000006a6900720bULL, 0x000fe40003f1d000ULL, 0x0000006200297245ULL, 0x020fe4000020d400ULL,
0x0000005f00287245ULL, 0x000fe2000020d400ULL, 0x0000006200677306ULL, 0x000fe20000209400ULL,
0x00000063b4b4723eULL, 0x000fca00000010ffULL, 0x00000001b7b75812ULL, 0x000fe400078efcffULL,
0x0000006200687306ULL, 0x000ea20000205400ULL, 0x0000002b2a00720bULL, 0x002fe40003fdd000ULL,
0x000000b5002a7245ULL, 0x000fe4000020d400ULL, 0x000000016e6e0812ULL, 0x000fe400078efcffULL,
0x00000088002b7245ULL, 0x000fe2000020d400ULL, 0x0000005f00657306ULL, 0x000fe20000209400ULL,
0x0000006eb7b5723eULL, 0x000fca00000010ffULL, 0x000000012a2a6812ULL, 0x000fe400078efcffULL,
0x0000005f00667306ULL, 0x000e620000205400ULL, 0x000000686700720bULL, 0x004fe20003fbd000ULL,
0x000000b42420723cULL, 0x000b6c0000041820ULL, 0x00000088002c7306ULL, 0x000fec0000209400ULL,
0x0000000129295812ULL, 0x000fc400078efcffULL, 0x00000088002d7306ULL, 0x000ea20000205400ULL,
0x000000666500720bULL, 0x002fe40003f1d000ULL, 0x0000002a292a723eULL, 0x000fd600000010ffULL,
0x0000000128280812ULL, 0x000fe400078efcffULL, 0x0000002d2c00720bULL, 0x004fda0003fdd000ULL,
0x000000012b2b6812ULL, 0x000fc800078efcffULL, 0x0000002b282b723eULL, 0x000fce00000010ffULL,
0x0000002a2404723cULL, 0x000b620000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000003e247f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000803d247811ULL, 0x004fe200078e40ffULL,
0x00f690004bff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff2a7224ULL, 0x000fe200078e0025ULL,
0x000000013c257812ULL, 0x000fe400078ec0ffULL, 0x000000032400720cULL, 0x000fda0003f06070ULL,
0x000068c000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x004fc40000015200ULL,
0x000004003e277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003e277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000013d257810ULL, 0x000fe40007ffe0ffULL, 0x000000c03f267810ULL, 0x000fe40007ffe0ffULL,
0x000000342500720cULL, 0x000fc60003f06070ULL, 0x00006200372c7a24ULL, 0x000fd400078e0226ULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x0000002603247217ULL, 0x000fe20007800000ULL,
0x0000001039297824ULL, 0x000fe200078e00ffULL, 0x00000003ff287819ULL, 0x000fe20000011602ULL,
0x0000001002257824ULL, 0x000fe400078e00ffULL, 0x0000000124247824ULL, 0x000fe200078e0a26ULL,
0x00000004282b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129277824ULL, 0x000fe200078e0228ULL,
0x0000007025337812ULL, 0x000fe200078ec0ffULL, 0x00000080ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000002429247217ULL, 0x000fe20007800000ULL, 0x0000000127257824ULL, 0x000fc400078e022cULL,
0x0000000127267824ULL, 0x040fe400078e0202ULL, 0x00000008272d7824ULL, 0x000fe400078e00ffULL,
0x00000001242a7824ULL, 0x000fe400078e0a29ULL, 0x0000000129277824ULL, 0x000fe200078e022bULL,
0xfffffff82d2e7812ULL, 0x000fe200078ee226ULL, 0x00005e0025247625ULL, 0x000fe200078e002fULL,
0x0000002a2800720cULL, 0x080fe40003fa6070ULL, 0x0000002a2b00720cULL, 0x000fe20003f06070ULL,
0x00000001272d7824ULL, 0x040fe200078e0202ULL, 0x0000003324267210ULL, 0x000fe20007fde0ffULL,
0x0000000827307824ULL, 0x000fc400078e00ffULL, 0x0000000127247824ULL, 0x000fe400078e022cULL,
0x000000102e2b7824ULL, 0x000fe200078e026dULL, 0xfffffff8302e7812ULL, 0x000fe200078ee22dULL,
0x000000ffff277224ULL, 0x000fe200030e0625ULL, 0x00000008282d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000000c28307810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0005e2000e901c46ULL,
0x0000000129317824ULL, 0x040fe200078e022dULL, 0x0000003324287210ULL, 0x000fe20007fde0ffULL,
0x00000001295d7824ULL, 0x000fe200078e0230ULL, 0x0000002a2d00720cULL, 0x000fe20003fa6070ULL,
0x0000000131247824ULL, 0x000fc400078e022cULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x0000002a3000720cULL, 0x000fe20003fc6070ULL, 0x000000102e2d7824ULL, 0x000fe400078e026dULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0x00000000282d7faeULL, 0x0007e2000c101c46ULL,
0x000000015d2a7824ULL, 0x000fe200078e022cULL, 0x0000003324247210ULL, 0x000fe20007f1e0ffULL,
0x00000001312b7824ULL, 0x144fe400078e0202ULL, 0x00000008312e7824ULL, 0x000fe400078e00ffULL,
0x000000015d2c7824ULL, 0x000fe400078e0202ULL, 0x00005e002a267625ULL, 0x000fe200078e002fULL,
0xfffffff82e2a7812ULL, 0x000fc600078ee22bULL, 0x000000085d5d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000003326267210ULL, 0x000fe20007f1e0ffULL,
0x000000102a297824ULL, 0x008fe200078e026dULL, 0xfffffff85d2c7812ULL, 0x000fc600078ee22cULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x0000000024297faeULL, 0x0005e2000e901c46ULL,
0x000000102c6d7824ULL, 0x000fca00078e026dULL, 0x00000000266d7faeULL, 0x0005e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x0000001039257824ULL, 0x000fe400078e00ffULL,
0x0000001002337824ULL, 0x040fe400078e00ffULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x0000002502257211ULL, 0x000fe400078fe8ffULL, 0x0000007033337812ULL, 0x000fe400078ec0ffULL,
0x00000008252d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000125247824ULL, 0x040fe200078e0202ULL,
0x0000000c25317810ULL, 0x040fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fc400078e00ffULL,
0x000000012d2f7824ULL, 0x000fe400078e0202ULL, 0x0000000131287824ULL, 0x000fe200078e022cULL,
0xfffffff8272e7812ULL, 0x000fe200078ee224ULL, 0x0000000125247824ULL, 0x040fe200078e022cULL,
0x0000000425277810ULL, 0x000fe20007ffe0ffULL, 0x000000082d327824ULL, 0x000fe400078e00ffULL,
0x00005e0024247625ULL, 0x000fc800078e0029ULL, 0x00000001272b7824ULL, 0x040fe200078e0202ULL,
0x00000033242a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000827307824ULL, 0x040fe400078e00ffULL,
0x0000000127267824ULL, 0x100fe400078e022cULL, 0x000000012d277824ULL, 0x000fe200078e022cULL,
0xfffffff8302c7812ULL, 0x000fe200078ee22bULL, 0x000000ffff2b7224ULL, 0x000fe200000e0625ULL,
0xfffffff832307812ULL, 0x000fe200078ee22fULL, 0x00005e0026247625ULL, 0x000fc800078e0029ULL,
0x00005e0027267625ULL, 0x000fe200078e0029ULL, 0x0000003324247210ULL, 0x000fc60007f1e0ffULL,
0x00000001312d7824ULL, 0x040fe200078e0202ULL, 0x0000003326267210ULL, 0x000fe20007fbe0ffULL,
0x00000008315a7824ULL, 0x000fe400078e00ffULL, 0x00005e0028287625ULL, 0x000fc600078e0029ULL,
0xfffffff85a327812ULL, 0x000fe200078ee22dULL, 0x000000102e2d7824ULL, 0x100fe200078e026dULL,
0x0000003328287210ULL, 0x000fe20007fde0ffULL, 0x000000102c2f7824ULL, 0x000fe400078e026dULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2d7faeULL, 0x0005e2000b901c46ULL, 0x0000001030317824ULL, 0x000fe400078e026dULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x00000000242f7faeULL, 0x0005e2000b901c46ULL,
0x00000010326d7824ULL, 0x000fc400078e026dULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x0000000026317faeULL, 0x0005e8000b901c46ULL, 0x00000000286d7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0xfffffff035267812ULL, 0x040fe200078ec0ffULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0xffffffe035257812ULL, 0x040fe400078ec0ffULL,
0x00000010352a7812ULL, 0x000fe200078ec0ffULL, 0x0000000841267824ULL, 0x000fe200078e0226ULL,
0x0000000835247812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x00000025242a7210ULL, 0x000fd60007ffe02aULL, 0x00000000510403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800265c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648002a287f8cULL, 0x0002a4000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x00f64c002a277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x014fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c002a277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010033247810ULL, 0x000fca0007ffe040ULL, 0x0000000143247824ULL, 0x000fca00078e0224ULL,
0x00f0000024287984ULL, 0x000ea80000000800ULL, 0x00f2000024257984ULL, 0x0002e20000000800ULL,
0x0000005b2800720bULL, 0x004fe20003f1d000ULL, 0x0000c8d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x002fc800000e0100ULL, 0x0000ffff24ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff5a7224ULL, 0x000fd200078e005bULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000200277811ULL, 0x000fe400078ff0ffULL, 0x0000005b2800720bULL, 0x000fe40003f14000ULL,
0x000000002700720cULL, 0x000fe20003fa5270ULL, 0x0000c8827f007947ULL, 0x000fd4000b800000ULL,
0x0000000000297806ULL, 0x000fc400000e0100ULL, 0x00000080002ad824ULL, 0x000fe200078e0233ULL,
0x000000285b26d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991029277816ULL, 0x000fe200000000ffULL, 0x00000001432bd824ULL, 0x000fc600078e022aULL,
0x000000ff2700720cULL, 0x000fe40003f05270ULL, 0x00f400262b00d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000285b267209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff29ff7812ULL, 0x000fc6000780c0ffULL,
0x800000265b267221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL,
0x00000026002c7308ULL, 0x000e640000000800ULL, 0x0000002c3b3b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011602ULL,
0x0000c7a27f007947ULL, 0x000fea000b800000ULL, 0x00001f262c267589ULL, 0x0002a400000e0000ULL,
0x0000002608087220ULL, 0x084fe20000410000ULL, 0x0000002609097220ULL, 0x080fe20000410000ULL,
0x000000260c0c7220ULL, 0x080fe20000410000ULL, 0x000000260d0d7220ULL, 0x080fe20000410000ULL,
0x0000002610107220ULL, 0x080fe20000410000ULL, 0x0000002611117220ULL, 0x080fe20000410000ULL,
0x0000002614147220ULL, 0x080fe20000410000ULL, 0x0000002615157220ULL, 0x080fe20000410000ULL,
0x0000002618187220ULL, 0x080fe20000410000ULL, 0x0000002619197220ULL, 0x080fe20000410000ULL,
0x000000261c1c7220ULL, 0x080fe20000410000ULL, 0x000000261d1d7220ULL, 0x080fe20000410000ULL,
0x0000002620207220ULL, 0x080fe20000410000ULL, 0x0000002621217220ULL, 0x080fe20000410000ULL,
0x0000002604047220ULL, 0x080fe20000410000ULL, 0x0000002605057220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0029ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802267811ULL, 0x000fe200078ff0ffULL,
0x0000c6927f007947ULL, 0x000fea000b800000ULL, 0x00001f262c267589ULL, 0x00046400000e0000ULL,
0x000000260a0a7220ULL, 0x082fe20000410000ULL, 0x000000260b0b7220ULL, 0x080fe20000410000ULL,
0x000000260e0e7220ULL, 0x080fe20000410000ULL, 0x000000260f0f7220ULL, 0x080fe20000410000ULL,
0x0000002612127220ULL, 0x080fe20000410000ULL, 0x0000002613137220ULL, 0x080fe20000410000ULL,
0x0000002616167220ULL, 0x080fe20000410000ULL, 0x0000002617177220ULL, 0x080fe20000410000ULL,
0x000000261a1a7220ULL, 0x080fe20000410000ULL, 0x000000261b1b7220ULL, 0x080fe20000410000ULL,
0x000000261e1e7220ULL, 0x080fe20000410000ULL, 0x000000261f1f7220ULL, 0x080fe20000410000ULL,
0x0000002622227220ULL, 0x080fe20000410000ULL, 0x0000002623237220ULL, 0x080fe20000410000ULL,
0x0000002606067220ULL, 0x080fe20000410000ULL, 0x0000002607077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff29ff7812ULL, 0x000fe20007800824ULL,
0x00000001ff297424ULL, 0x000fe200078e00ffULL, 0x000000285b5a7209ULL, 0x000fd60007810000ULL,
0x8000005a28280221ULL, 0x000fe20000010000ULL, 0x00007610ff290816ULL, 0x000fc60000000029ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800460308ULL, 0x000e640000000800ULL,
0x0000004625250220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003b253b7221ULL, 0x008fc40000010000ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x00f6ac0055267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0055267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991029247816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000046ff24723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe40000011602ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x0000c2727f007947ULL, 0x000fea000b800000ULL,
0x00001f2524477589ULL, 0x0002e400000e0000ULL, 0x0000000825267810ULL, 0x000fe20007ffe0ffULL,
0x0000c2a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2624487589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001025267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00009330002b7802ULL, 0x000fc40000000f00ULL,
0x0000c92000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001825267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x004fe200078e0024ULL,
0x00009380002b7802ULL, 0x000fc40000000f00ULL, 0x0000c8d000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000010003c247824ULL, 0x002fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014f507824ULL, 0x000fc400078e0250ULL,
0x000000084f4f7824ULL, 0x000fe200078e00ffULL, 0x0000100024257812ULL, 0x000fc800078ec0ffULL,
0xfffffff84f247812ULL, 0x000fe200078ee250ULL, 0x0000200036257824ULL, 0x000fca00078e0225ULL,
0x0000b000254f7810ULL, 0x000fca0007ffe0ffULL, 0x0000001024247824ULL, 0x100fe400078e024fULL,
0x000000104e287824ULL, 0x100fe400078e024fULL, 0x000000104c2c7824ULL, 0x104fe400078e024fULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x000000104d307824ULL, 0x000fc600078e024fULL,
0x000000002828783bULL, 0x000ea80000004200ULL, 0x000000002c2c783bULL, 0x000f280000004200ULL,
0x000000003030783bULL, 0x000ee20000004200ULL, 0x0000010024977824ULL, 0x002fe200078e00ffULL,
0x00000024008d7306ULL, 0x000fe20000009400ULL, 0x00000018ffa87819ULL, 0x000fe20000011424ULL,
0x0000010025ad7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe20000011425ULL,
0x0001000025af7824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe20000011497ULL,
0x0000010026b77824ULL, 0x000fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x00000024009a7306ULL, 0x000e620000005400ULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000010027ba7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fc400000114b7ULL,
0x00000018ffbb7819ULL, 0x000fe40000011426ULL, 0x00000018ffc07819ULL, 0x000fe200000114baULL,
0x0000009700a47306ULL, 0x000fe20000209400ULL, 0x00000018ffc37819ULL, 0x000fe40000011427ULL,
0x00000018ff9f7819ULL, 0x004fe40000011428ULL, 0x00000018ff9c7819ULL, 0x000fe40000011429ULL,
0x00000018ff937819ULL, 0x000fe2000001142aULL, 0x0000009700a57306ULL, 0x000ea20000205400ULL,
0x0000009a8d00720bULL, 0x002fe20003fbd000ULL, 0x00010000279a7824ULL, 0x000fe200078e00ffULL,
0x00000097008d7245ULL, 0x000fc4000020d400ULL, 0x00000018ff907819ULL, 0x000fe4000001142bULL,
0x00000018ff897819ULL, 0x010fe2000001142cULL, 0x0000002400827306ULL, 0x000322000000d400ULL,
0x00000018ff847819ULL, 0x000fe4000001142dULL, 0x00000018ff787819ULL, 0x000fe4000001142eULL,
0x00000018ff617819ULL, 0x008fe40000011430ULL, 0x00000018ff757819ULL, 0x000fe2000001142fULL,
0x000000a800a97306ULL, 0x000fe20000209400ULL, 0x0001000024247824ULL, 0x002fe200078e00ffULL,
0x000000a5a400720bULL, 0x004fe20003fdd000ULL, 0x0000010029a57824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011432ULL, 0x0000010028a47824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x000000a800aa7306ULL, 0x000e620000205400ULL,
0x0000000182825812ULL, 0x010fe400078efcffULL, 0x0000002400977245ULL, 0x000fe4000020d400ULL,
0x00000018ff627819ULL, 0x000fe40000011431ULL, 0x000000018d8d6812ULL, 0x000fe200078efcffULL,
0x0000002400a67306ULL, 0x000fe20000209400ULL, 0x00000018ff687819ULL, 0x000fce0000011433ULL,
0x0000002400a77306ULL, 0x0004e20000205400ULL, 0x000000aaa900720bULL, 0x002fe20003fbd000ULL,
0x000001002aaa7824ULL, 0x000fcc00078e00ffULL, 0x0000002500ab7306ULL, 0x000fe20000009400ULL,
0x00000018ff247819ULL, 0x004fe4000001149aULL, 0x000000a8009a7245ULL, 0x000fe4000020d400ULL,
0x000000c000a87245ULL, 0x000fe4000020d400ULL, 0x000000019a9a5812ULL, 0x000fe200078efcffULL,
0x0000002500ac7306ULL, 0x000e620000005400ULL, 0x000000a7a600720bULL, 0x008fe40003fdd000ULL,
0x000000ad00a67245ULL, 0x000fc4000020d400ULL, 0x000000b700a77245ULL, 0x000fc6000020d400ULL,
0x0000002500817306ULL, 0x000eac000000d400ULL, 0x0000000197976812ULL, 0x000fe400078efcffULL,
0x000000ad00ae7306ULL, 0x000fe20000209400ULL, 0x000000acab00720bULL, 0x002fe40003fbd000ULL,
0x0000002400ab7245ULL, 0x000fca000020d400ULL, 0x000000ad00257306ULL, 0x000e6c0000205400ULL,
0x0000000181815812ULL, 0x004fe400078efcffULL, 0x000000b200b37306ULL, 0x000ff00000209400ULL,
0x000000b200b47306ULL, 0x000ea20000205400ULL, 0x00000025ae00720bULL, 0x002fc40003fdd000ULL,
0x00000018ffae7819ULL, 0x000fe400000114a4ULL, 0x000000af00a47245ULL, 0x000fc6000020d400ULL,
0x000000af00b07306ULL, 0x000fec0000209400ULL, 0x00000001a6a66812ULL, 0x000fe400078efcffULL,
0x000000af00b17306ULL, 0x000e620000205400ULL, 0x000000b4b300720bULL, 0x004fce0003fbd000ULL,
0x0000002600b57306ULL, 0x000ff00000009400ULL, 0x0000002600b67306ULL, 0x000ea20000005400ULL,
0x000000b1b000720bULL, 0x002fe40003fdd000ULL, 0x00000018ffb17819ULL, 0x000fc400000114a5ULL,
0x000000b200a57245ULL, 0x000fc6000020d400ULL, 0x000000b700b87306ULL, 0x000fe20000209400ULL,
0x00000001a5a55812ULL, 0x000fca00078efcffULL, 0x00000001a4a46812ULL, 0x000fe400078efcffULL,
0x000000b700b97306ULL, 0x000e620000205400ULL, 0x000000b6b500720bULL, 0x004fce0003fbd000ULL,
0x00000026007c7306ULL, 0x0004f0000000d400ULL, 0x0000002700be7306ULL, 0x000fe20000009400ULL,
0x000000b9b800720bULL, 0x002fe20003fdd000ULL, 0x0001000026267824ULL, 0x004fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002700bf7306ULL, 0x000e620000005400ULL,
0x000000017c7c5812ULL, 0x008fe400078efcffULL, 0x0000002600a97245ULL, 0x000fc6000020d400ULL,
0x00000001a7a76812ULL, 0x000fe400078efcffULL, 0x000000c000c17306ULL, 0x000fe40000209400ULL,
0x0000007ca77c723eULL, 0x000fcc00000010ffULL, 0x000000c000c27306ULL, 0x000ea20000205400ULL,
0x000000bfbe00720bULL, 0x002fce0003fbd000ULL, 0x00000027007b7306ULL, 0x000e70000000d400ULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x000000c2c100720bULL, 0x004fce0003fdd000ULL,
0x000000bb00bd7306ULL, 0x000ea20000205400ULL, 0x000000017b7b5812ULL, 0x002fca00078efcffULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x0000002600ba7306ULL, 0x000ff00000209400ULL,
0x0000002600277306ULL, 0x0002e20000205400ULL, 0x000000bdbc00720bULL, 0x004fce0003fbd000ULL,
0x000000c300c47306ULL, 0x000fe20000209400ULL, 0x00000018ff267819ULL, 0x002fe400000114aaULL,
0x000000bb00aa7245ULL, 0x000fc8000020d400ULL, 0x00000001aaaa5812ULL, 0x000fe200078efcffULL,
0x000000c300c57306ULL, 0x000e620000205400ULL, 0x00000027ba00720bULL, 0x008fce0003fdd000ULL,
0x0000002400257306ULL, 0x000fec0000209400ULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x0000002400ac7306ULL, 0x000ea20000205400ULL, 0x000000c5c400720bULL, 0x002fe40003fbd000ULL,
0x000000a9aaaa723eULL, 0x000fca00000010ffULL, 0x0000002800c67306ULL, 0x000ff00000009400ULL,
0x0000002800c77306ULL, 0x000e620000005400ULL, 0x000000ac2500720bULL, 0x004fe20003fdd000ULL,
0x000001002bac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffb57819ULL, 0x000fe200000114acULL,
0x000000ae00ad7306ULL, 0x000fe20000209400ULL, 0x000000c300ac7245ULL, 0x000fc8000020d400ULL,
0x00000001acac5812ULL, 0x000fe400078efcffULL, 0x00000001abab6812ULL, 0x000fe200078efcffULL,
0x000000ae00b07306ULL, 0x0004e20000205400ULL, 0x000000c7c600720bULL, 0x002fe40003fbd000ULL,
0x000000abacab723eULL, 0x000fca00000010ffULL, 0x0000002800777306ULL, 0x000322000000d400ULL,
0x000000ae00ae7245ULL, 0x004fce000020d400ULL, 0x0000002900a37306ULL, 0x000fe20000009400ULL,
0x000000b0ad00720bULL, 0x008fe20003fdd000ULL, 0x0001000028287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000002900a27306ULL, 0x000e620000005400ULL,
0x0000000177775812ULL, 0x010fca00078efcffULL, 0x00000001aeae6812ULL, 0x000fe400078efcffULL,
0x000000b100b37306ULL, 0x000ff00000209400ULL, 0x000000b100b47306ULL, 0x000ea20000205400ULL,
0x000000a2a300720bULL, 0x002fe20003fbd000ULL, 0x000100002ba27824ULL, 0x000fe200078e00ffULL,
0x000000b100a37245ULL, 0x000fc8000020d400ULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x0000002900767306ULL, 0x0002f0000000d400ULL, 0x0000009f00a17306ULL, 0x000fe20000209400ULL,
0x000000b4b300720bULL, 0x004fe20003fdd000ULL, 0x0001000029297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000009f00a07306ULL, 0x0002a20000205400ULL,
0x0000000176765812ULL, 0x008fca00078efcffULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x0000002800af7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fe4000020d400ULL,
0x00000076a3a3723eULL, 0x000fca00000010ffULL, 0x0000002800b27306ULL, 0x000e620000205400ULL,
0x000000a0a100720bULL, 0x004fe20003fbd000ULL, 0x000001002ca17824ULL, 0x000fe200078e00ffULL,
0x0000002800a07245ULL, 0x000fc8000020d400ULL, 0x00000018ffa17819ULL, 0x000fe200000114a1ULL,
0x0000009c009e7306ULL, 0x000fec0000209400ULL, 0x000000019f9f5812ULL, 0x000fe400078efcffULL,
0x0000009c009d7306ULL, 0x0004e20000205400ULL, 0x000000b2af00720bULL, 0x002fce0003fdd000ULL,
0x0000002900277306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x004fca000020d400ULL,
0x00000001a0a06812ULL, 0x000fe400078efcffULL, 0x0000002900b67306ULL, 0x000e620000205400ULL,
0x0000009d9e00720bULL, 0x008fe40003fbd000ULL, 0x00000029009d7245ULL, 0x000fe4000020d400ULL,
0x000000a09fa0723eULL, 0x000fc600000010ffULL, 0x0000002a009b7306ULL, 0x000fec0000009400ULL,
0x000000019c9c5812ULL, 0x000fe400078efcffULL, 0x0000002a00987306ULL, 0x000ea20000005400ULL,
0x000000b62700720bULL, 0x002fce0003fdd000ULL, 0x0000002600257306ULL, 0x000fec0000209400ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x0000002600b87306ULL, 0x000e620000205400ULL,
0x000000989b00720bULL, 0x004fe40003fbd000ULL, 0x00000026009b7245ULL, 0x000fca000020d400ULL,
0x0000002a00707306ULL, 0x0004f0000000d400ULL, 0x0000002b00997306ULL, 0x000fe20000009400ULL,
0x000000b82500720bULL, 0x002fe20003fdd000ULL, 0x000100002a2a7824ULL, 0x004fc400078e00ffULL,
0x000001002d257824ULL, 0x000fc600078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002b00967306ULL, 0x000e620000005400ULL, 0x0000000170705812ULL, 0x008fe400078efcffULL,
0x00000018ff987819ULL, 0x000fc60000011425ULL, 0x000000019b9b6812ULL, 0x000fe400078efcffULL,
0x000000b500ad7306ULL, 0x000fe40000209400ULL, 0x000000709b70723eULL, 0x000fcc00000010ffULL,
0x000000b500b07306ULL, 0x000ea20000205400ULL, 0x000000969900720bULL, 0x002fe40003fbd000ULL,
0x000000b500967245ULL, 0x000fca000020d400ULL, 0x0000002b00717306ULL, 0x000e70000000d400ULL,
0x0000009300957306ULL, 0x000fe20000209400ULL, 0x000000b0ad00720bULL, 0x004fce0003fdd000ULL,
0x0000009300947306ULL, 0x0004e20000205400ULL, 0x0000000171715812ULL, 0x002fca00078efcffULL,
0x0000000196966812ULL, 0x000fe400078efcffULL, 0x0000002a00247306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x004fe4000020d400ULL, 0x000000719671723eULL, 0x000fca00000010ffULL,
0x0000002a002b7306ULL, 0x000e620000205400ULL, 0x000000949500720bULL, 0x008fe40003fbd000ULL,
0x0000002a00947245ULL, 0x000fca000020d400ULL, 0x0000009000927306ULL, 0x000fec0000209400ULL,
0x0000000193935812ULL, 0x000fe400078efcffULL, 0x0000009000917306ULL, 0x0004e20000205400ULL,
0x0000002b2400720bULL, 0x002fe20003fdd000ULL, 0x000001002e247824ULL, 0x000fca00078e00ffULL,
0x00000018ff957819ULL, 0x000fe20000011424ULL, 0x000000a200af7306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x004fe2000020d400ULL, 0x000001002f247824ULL, 0x000fc800078e00ffULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x000000a200b27306ULL, 0x0002a20000205400ULL,
0x000000919200720bULL, 0x008fe40003fbd000ULL, 0x000000a200917245ULL, 0x000fe4000020d400ULL,
0x000000949394723eULL, 0x000fc600000010ffULL, 0x0000002c008f7306ULL, 0x000fe20000009400ULL,
0x00000018ffa27819ULL, 0x002fca0000011424ULL, 0x0000000190905812ULL, 0x000fe400078efcffULL,
0x0000002c008e7306ULL, 0x000e620000005400ULL, 0x000000b2af00720bULL, 0x004fce0003fdd000ULL,
0x000000a100277306ULL, 0x000fec0000209400ULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x000000a100287306ULL, 0x0004e20000205400ULL, 0x0000008e8f00720bULL, 0x002fe40003fbd000ULL,
0x000000a1008e7245ULL, 0x000fca000020d400ULL, 0x0000002c006b7306ULL, 0x000322000000d400ULL,
0x0000009d9ca1723eULL, 0x004fce00000010ffULL, 0x00000089008b7306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x002fe200078e00ffULL, 0x000000282700720bULL, 0x008fe40003fdd000ULL,
0x00a000004928783bULL, 0x000e640000000200ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000089008c7306ULL, 0x000ea20000205400ULL, 0x000000016b6b5812ULL, 0x010fe200078efcffULL,
0x00a000004a24783bULL, 0x000eea0000000200ULL, 0x000000018e8e6812ULL, 0x000fe200078efcffULL,
0x0000002c009e7306ULL, 0x000ff00000209400ULL, 0x0000002c00b17306ULL, 0x0008620000205400ULL,
0x0000008c8b00720bULL, 0x004fe20003fbd000ULL, 0x000100002f8c7824ULL, 0x000fe200078e00ffULL,
0x0000002c008b7245ULL, 0x000fca000020d400ULL, 0x0000002d00877306ULL, 0x000fe20000009400ULL,
0x00000100302c7824ULL, 0x010fce00078e00ffULL, 0x0000002d008a7306ULL, 0x000ea20000005400ULL,
0x000000b19e00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff9e7819ULL, 0x000fe2000001148cULL,
0x0000004728288231ULL, 0x080fe200003400ffULL, 0x00000089008c7245ULL, 0x000fe2000020d400ULL,
0x000000472a2a8231ULL, 0x000fe400003400ffULL, 0x0000002d006c7306ULL, 0x000322000000d400ULL,
0x000000018c8c5812ULL, 0x000fe200078efcffULL, 0x0000004829298231ULL, 0x000fc400003400ffULL,
0x000000482b2b8231ULL, 0x080fe400003400ffULL, 0x000000018b8b6812ULL, 0x000fe200078efcffULL,
0x0000004724248231ULL, 0x088fe200003400ffULL, 0x0000009800ad7306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x002fe200078e00ffULL, 0x0000008a8700720bULL, 0x004fe20003fbd000ULL,
0x0000004726268231ULL, 0x000fe200003400ffULL, 0x0000009800877245ULL, 0x000fe2000020d400ULL,
0x0000004825258231ULL, 0x080fe200003400ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000004827278231ULL, 0x000fe200003400ffULL, 0x0000009800b07306ULL, 0x0002a20000205400ULL,
0x000000aa2814723cULL, 0x040fec0000041814ULL, 0x000000016c6c5812ULL, 0x010fe200078efcffULL,
0x0000002d00997306ULL, 0x000fe20000209400ULL, 0x00000018ff987819ULL, 0x002fe2000001142cULL,
0x00000100312c7824ULL, 0x000fe200078e00ffULL, 0x000000a0281c723cULL, 0x040fea000004181cULL,
0x0000002d00b47306ULL, 0x000e620000205400ULL, 0x000000b0ad00720bULL, 0x004fe20003fdd000ULL,
0x0000010033b07824ULL, 0x000fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fe2000001142cULL,
0x00010000302c7824ULL, 0x000fe200078e00ffULL, 0x000000702820723cULL, 0x000fe40000041820ULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0000008400857306ULL, 0x000fec0000209400ULL,
0x0000000187876812ULL, 0x000fc400078efcffULL, 0x0000008400887306ULL, 0x000ea20000205400ULL,
0x000000b49900720bULL, 0x002fe40003fbd000ULL, 0x0000006c8787723eULL, 0x000fca00000010ffULL,
0x0000009500af7306ULL, 0x000ff00000209400ULL, 0x0000009500927306ULL, 0x000e620000205400ULL,
0x000000888500720bULL, 0x004fe40003fdd000ULL, 0x0000002d00857245ULL, 0x000fc4000020d400ULL,
0x00000081a62d723eULL, 0x000fe400000010ffULL, 0x0000000185855812ULL, 0x000fe200078efcffULL,
0x0000002e00837306ULL, 0x000ff00000009400ULL, 0x0000002e00867306ULL, 0x000ea20000005400ULL,
0x00000092af00720bULL, 0x002fe20003fbd000ULL, 0x0000010032927824ULL, 0x000fc400078e00ffULL,
0x0001000032af7824ULL, 0x000fc600078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011492ULL,
0x000000a200b27306ULL, 0x000fe20000209400ULL, 0x00000018ffaf7819ULL, 0x000fce00000114afULL,
0x000000a200b37306ULL, 0x000fe20000205400ULL, 0x000000868300720bULL, 0x004fe20003f1d000ULL,
0x0001000031867824ULL, 0x000fcc00078e00ffULL, 0x0000002e005b7306ULL, 0x0002b0000000d400ULL,
0x0000002f007f7306ULL, 0x000fe20000009400ULL, 0x000100002e2e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001142eULL, 0x0000002f00807306ULL, 0x000fe20000005400ULL,
0x000000015b5b0812ULL, 0x004fce00078efcffULL, 0x0000003000747306ULL, 0x000ff00000009400ULL,
0x0000003000737306ULL, 0x000ff00000005400ULL, 0x00000030004e7306ULL, 0x0003f0000000d400ULL,
0x0000002f00597306ULL, 0x000fe2000000d400ULL, 0x0000008400307245ULL, 0x002fc8000020d400ULL,
0x0000000130306812ULL, 0x000fe400078efcffULL, 0x000000b3b200720bULL, 0x000fe20003fdd000ULL,
0x00000078007e7306ULL, 0x000fe20000209400ULL, 0x000000853085723eULL, 0x000fce00000010ffULL,
0x00000078007d7306ULL, 0x0003f00000205400ULL, 0x0000008f002e7306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fce000020d400ULL, 0x0000008f002f7306ULL, 0x0002b00000205400ULL,
0x00000032005e7306ULL, 0x000fe20000009400ULL, 0x0000008f008f7245ULL, 0x002fce000020d400ULL,
0x00000032004d7306ULL, 0x000fe20000005400ULL, 0x0000002f2e00720bULL, 0x004fe40003f1d000ULL,
0x000000979a2e723eULL, 0x000fe400000010ffULL, 0x000000a4a52f723eULL, 0x000fc600000010ffULL,
0x00000032004c7306ULL, 0x0003e8000000d400ULL, 0x0000002e280c723cULL, 0x000fe4000004180cULL,
0x000000018f8f0812ULL, 0x000fe400078efcffULL, 0x0000007500797306ULL, 0x000fe20000209400ULL,
0x0000009500327245ULL, 0x002fe4000020d400ULL, 0x000000919095723eULL, 0x000fc400000010ffULL,
0x0000000132325812ULL, 0x000fe400078efcffULL, 0x000000807f00720bULL, 0x000fe20003fbd000ULL,
0x00000075007a7306ULL, 0x000e620000205400ULL, 0x000000a200807245ULL, 0x000fe2000020d400ULL,
0x000000942804723cULL, 0x040fe20000041804ULL, 0x00000077aea2723eULL, 0x000fe400000010ffULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x0000007d7e00720bULL, 0x000fe20003fdd000ULL,
0x0000009e00897306ULL, 0x000fe20000209400ULL, 0x0000007ba87d723eULL, 0x000fe200000010ffULL,
0x000000a22818723cULL, 0x000fe20000041818ULL, 0x00000018ff7b7819ULL, 0x000fc40000011486ULL,
0x0000000159595812ULL, 0x000fe400078efcffULL, 0x0000006b8e86723eULL, 0x000fe200000010ffULL,
0x0000009e008a7306ULL, 0x000ea20000205400ULL, 0x0000007a7900720bULL, 0x002fe20003fbd000ULL,
0x0000007c2810723cULL, 0x000fe20000041810ULL, 0x0000009e00797245ULL, 0x000fe4000020d400ULL,
0x0000000178786812ULL, 0x000fc600078efcffULL, 0x0000009800887306ULL, 0x000fe20000209400ULL,
0x0000008f7878723eULL, 0x000fce00000010ffULL, 0x0000009800997306ULL, 0x000e620000205400ULL,
0x0000008a8900720bULL, 0x004fce0003f1d000ULL, 0x0000003100727306ULL, 0x000fec0000009400ULL,
0x0000000179790812ULL, 0x000fe400078efcffULL, 0x00000031006f7306ULL, 0x000fe20000005400ULL,
0x000000998800720bULL, 0x002fe40003fdd000ULL, 0x000000737400720bULL, 0x000fca0003f1d000ULL,
0x000000ad00837306ULL, 0x000ff00000209400ULL, 0x000000ad00847306ULL, 0x0002a20000205400ULL,
0x000000014e4e0812ULL, 0x000fce00078efcffULL, 0x0000003100607306ULL, 0x0007e2000000d400ULL,
0x000000ad00ad7245ULL, 0x002fce000020d400ULL, 0x00000061006e7306ULL, 0x000fe20000209400ULL,
0x00000018ff317819ULL, 0x008fe4000001142cULL, 0x000000828d2c723eULL, 0x000fca00000010ffULL,
0x00000061006d7306ULL, 0x000e640000205400ULL, 0x0000002c2808723cULL, 0x000b6c0000041808ULL,
0x0000003100817306ULL, 0x000fe20000209400ULL, 0x00000075002c7245ULL, 0x020fe4000020d400ULL,
0x00000098002d7245ULL, 0x000fc4000020d400ULL, 0x000000012c2c5812ULL, 0x000fe400078efcffULL,
0x000000012d2d6812ULL, 0x000fe200078efcffULL, 0x0000003100827306ULL, 0x0007220000205400ULL,
0x000000848300720bULL, 0x004fe40003fbd000ULL, 0x0000006f7200720bULL, 0x000fe40003fdd000ULL,
0x0000006d6e00720bULL, 0x002fe40003f1d000ULL, 0x00000061002a7245ULL, 0x000fe2000020d400ULL,
0x0000007b002e7306ULL, 0x000fe20000209400ULL, 0x0000003100317245ULL, 0x008fe2000020d400ULL,
0x000000862408723cULL, 0x000f620000041808ULL, 0x0000007b002b7245ULL, 0x000fc4000020d400ULL,
0x0000005b3228723eULL, 0x000fe400000010ffULL, 0x00000001adad5812ULL, 0x000fe200078efcffULL,
0x0000007b002f7306ULL, 0x000e620000205400ULL, 0x0000000160606812ULL, 0x000fe400078efcffULL,
0x000000828100720bULL, 0x010fe40003fbd000ULL, 0x000000012a2a0812ULL, 0x000fe400078efcffULL,
0x000000598029723eULL, 0x000fe200000010ffULL, 0x0000006200637306ULL, 0x000fe20000209400ULL,
0x0000008b8c84723eULL, 0x000fc400000010ffULL, 0x000000792c79723eULL, 0x000fc600000010ffULL,
0x000000282410723cULL, 0x040b640000041810ULL, 0x0000006200647306ULL, 0x0004e20000205400ULL,
0x0000002f2e00720bULL, 0x002fe40003fdd000ULL, 0x0000000131315812ULL, 0x000fe400078efcffULL,
0x00000092002f7245ULL, 0x000fe2000020d400ULL, 0x00000084240c723cULL, 0x000f64000004180cULL,
0x0000004e2d28723eULL, 0x020fe200000010ffULL, 0x0000009200757306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fc4000020d400ULL, 0x00000060ad29723eULL, 0x000fe400000010ffULL,
0x000000312a2a723eULL, 0x000fe200000010ffULL, 0x000000782414723cULL, 0x000f620000041814ULL,
0x000000012b2b6812ULL, 0x000fe200078efcffULL, 0x0000009200747306ULL, 0x000e620000205400ULL,
0x000000646300720bULL, 0x008fe40003fbd000ULL, 0x0000004d5e00720bULL, 0x000fc60003fdd000ULL,
0x000000282418723cULL, 0x000b640000041818ULL, 0x0000003300507306ULL, 0x000fea0000009400ULL,
0x0000006500287245ULL, 0x020fe4000020d400ULL, 0x0000000162625812ULL, 0x000fe200078efcffULL,
0x0000003300517306ULL, 0x000ea20000005400ULL, 0x000000747500720bULL, 0x002fc40003f1d000ULL,
0x000000014c4c6812ULL, 0x000fe400078efcffULL, 0x0000002b622b723eULL, 0x000fc600000010ffULL,
0x000000b0006f7306ULL, 0x000fe80000209400ULL, 0x0000002a241c723cULL, 0x000b64000004181cULL,
0x000000012f2f0812ULL, 0x000fe400078efcffULL, 0x000000b0006e7306ULL, 0x0002e20000205400ULL,
0x000000515000720bULL, 0x004fe40003f1d000ULL, 0x0000004c2f4c723eULL, 0x000fca00000010ffULL,
0x000000af002e7306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x000000af00617306ULL, 0x0002a20000205400ULL, 0x0000006e6f00720bULL, 0x008fce0003fbd000ULL,
0x00000033005f7306ULL, 0x000722000000d400ULL, 0x000000af00af7245ULL, 0x002fca000020d400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x0000006500667306ULL, 0x000fe20000209400ULL,
0x0001000033337824ULL, 0x008fe200078e00ffULL, 0x000000612e00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000006500677306ULL, 0x000e620000205400ULL,
0x000000015f5f0812ULL, 0x010fe400078efcffULL, 0x0000003300297245ULL, 0x000fc8000020d400ULL,
0x00000001afaf6812ULL, 0x000fe200078efcffULL, 0x0000006800697306ULL, 0x000ff00000209400ULL,
0x00000068006a7306ULL, 0x0004e20000205400ULL, 0x000000676600720bULL, 0x002fce0003fbd000ULL,
0x0000003300307306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x004fca000020d400ULL,
0x0000000128285812ULL, 0x000fe400078efcffULL, 0x00000033004d7306ULL, 0x000e620000205400ULL,
0x0000006a6900720bULL, 0x008fe40003f1d000ULL, 0x000000af2828723eULL, 0x000fd600000010ffULL,
0x0000000168680812ULL, 0x000fe400078efcffULL, 0x0000004d3000720bULL, 0x002fe40003fdd000ULL,
0x0000005fb04d723eULL, 0x000fce00000010ffULL, 0x0000004c2420723cULL, 0x000b680000041820ULL,
0x0000000129296812ULL, 0x000fc800078efcffULL, 0x000000296829723eULL, 0x000fce00000010ffULL,
0x000000282404723cULL, 0x000b620000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000003e247f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c03d247811ULL, 0x004fe200078e40ffULL,
0x00f698004bff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0025ULL,
0x000000032400720cULL, 0x000fe20003f06070ULL, 0x000000ffff257224ULL, 0x000fe400078e0041ULL,
0x000000ffff5b7224ULL, 0x000fe400078e005aULL, 0x000000ffff597224ULL, 0x000fd000078e005dULL,
0x000033e000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x004fc40000015200ULL,
0x0000000400267824ULL, 0x000fca00078e00ffULL, 0xfffffff826287812ULL, 0x000fca00078ec0ffULL,
0x00f6cc0028277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6cc0028277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000023d257810ULL, 0x000fe40007ffe0ffULL, 0x000001003f267810ULL, 0x000fe40007ffe0ffULL,
0x000000342500720cULL, 0x000fc60003f06070ULL, 0x00006200372c7a24ULL, 0x000fd400078e0226ULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x0000002603247217ULL, 0x000fe20007800000ULL,
0x0000001039297824ULL, 0x000fe200078e00ffULL, 0x00000003ff287819ULL, 0x000fe20000011602ULL,
0x0000001002257824ULL, 0x000fe400078e00ffULL, 0x0000000124247824ULL, 0x000fe200078e0a26ULL,
0x00000004282b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129277824ULL, 0x000fe200078e0228ULL,
0x0000007025337812ULL, 0x000fe200078ec0ffULL, 0x00000080ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000002429247217ULL, 0x000fe20007800000ULL, 0x0000000127257824ULL, 0x000fc400078e022cULL,
0x0000000127267824ULL, 0x040fe400078e0202ULL, 0x00000008272d7824ULL, 0x000fe400078e00ffULL,
0x00000001242a7824ULL, 0x000fe400078e0a29ULL, 0x0000000129277824ULL, 0x000fe200078e022bULL,
0xfffffff82d2e7812ULL, 0x000fe200078ee226ULL, 0x00005e0025247625ULL, 0x000fe200078e002fULL,
0x0000002a2800720cULL, 0x080fe40003fa6070ULL, 0x0000002a2b00720cULL, 0x000fe20003f06070ULL,
0x00000001272d7824ULL, 0x040fe200078e0202ULL, 0x0000003324267210ULL, 0x000fe20007fde0ffULL,
0x0000000827307824ULL, 0x000fc400078e00ffULL, 0x0000000127247824ULL, 0x000fe400078e022cULL,
0x000000102e2b7824ULL, 0x000fe200078e024fULL, 0xfffffff8302e7812ULL, 0x000fe200078ee22dULL,
0x000000ffff277224ULL, 0x000fe200030e0625ULL, 0x00000008282d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000000c28307810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0005e2000e901c46ULL,
0x0000000129317824ULL, 0x040fe200078e022dULL, 0x0000003324287210ULL, 0x000fe20007fde0ffULL,
0x00000001293f7824ULL, 0x000fe200078e0230ULL, 0x0000002a2d00720cULL, 0x000fe20003fa6070ULL,
0x0000000131247824ULL, 0x000fc400078e022cULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x0000002a3000720cULL, 0x000fe20003fc6070ULL, 0x000000102e2d7824ULL, 0x000fe400078e024fULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0x00000000282d7faeULL, 0x0007e2000c101c46ULL,
0x000000013f2a7824ULL, 0x000fe200078e022cULL, 0x0000003324247210ULL, 0x000fe20007f1e0ffULL,
0x00000001312b7824ULL, 0x144fe400078e0202ULL, 0x00000008312e7824ULL, 0x000fe400078e00ffULL,
0x000000013f2c7824ULL, 0x000fe400078e0202ULL, 0x00005e002a267625ULL, 0x000fe200078e002fULL,
0xfffffff82e2a7812ULL, 0x000fc600078ee22bULL, 0x000000083f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000003326267210ULL, 0x000fe20007f1e0ffULL,
0x000000102a297824ULL, 0x008fe200078e024fULL, 0xfffffff83f2c7812ULL, 0x000fc600078ee22cULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x0000000024297faeULL, 0x0005e2000e901c46ULL,
0x000000102c4f7824ULL, 0x000fca00078e024fULL, 0x00000000264f7faeULL, 0x0005e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x0000001039257824ULL, 0x000fe400078e00ffULL,
0x0000001002337824ULL, 0x040fe400078e00ffULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x0000002502257211ULL, 0x000fe400078fe8ffULL, 0x0000007033337812ULL, 0x000fe400078ec0ffULL,
0x00000008252d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000125247824ULL, 0x040fe200078e0202ULL,
0x0000000c25317810ULL, 0x040fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fc400078e00ffULL,
0x000000012d2f7824ULL, 0x000fe400078e0202ULL, 0x0000000131287824ULL, 0x000fe200078e022cULL,
0xfffffff8272e7812ULL, 0x000fe200078ee224ULL, 0x0000000125247824ULL, 0x040fe200078e022cULL,
0x0000000425277810ULL, 0x000fe20007ffe0ffULL, 0x000000082d327824ULL, 0x000fe400078e00ffULL,
0x00005e0024247625ULL, 0x000fc800078e0029ULL, 0x00000001272b7824ULL, 0x040fe200078e0202ULL,
0x00000033242a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000827307824ULL, 0x040fe400078e00ffULL,
0x0000000127267824ULL, 0x100fe400078e022cULL, 0x000000012d277824ULL, 0x000fe200078e022cULL,
0xfffffff8302c7812ULL, 0x000fe200078ee22bULL, 0x000000ffff2b7224ULL, 0x000fe200000e0625ULL,
0xfffffff832307812ULL, 0x000fe200078ee22fULL, 0x00005e0026247625ULL, 0x000fc800078e0029ULL,
0x00005e0027267625ULL, 0x000fe200078e0029ULL, 0x0000003324247210ULL, 0x000fc60007f1e0ffULL,
0x00000001312d7824ULL, 0x040fe200078e0202ULL, 0x0000003326267210ULL, 0x000fe20007fbe0ffULL,
0x00000008314c7824ULL, 0x000fe400078e00ffULL, 0x00005e0028287625ULL, 0x000fc600078e0029ULL,
0xfffffff84c327812ULL, 0x000fe200078ee22dULL, 0x000000102e2d7824ULL, 0x100fe200078e024fULL,
0x0000003328287210ULL, 0x000fe20007fde0ffULL, 0x000000102c2f7824ULL, 0x000fe400078e024fULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2d7faeULL, 0x0005e2000b901c46ULL, 0x0000001030317824ULL, 0x000fe400078e024fULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x00000000242f7faeULL, 0x0005e2000b901c46ULL,
0x00000010324f7824ULL, 0x000fc400078e024fULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x0000000026317faeULL, 0x0005e8000b901c46ULL, 0x00000000284f7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0xffffffe035247812ULL, 0x040fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x0000001035257812ULL, 0x040fe400078ec0ffULL,
0x0000000835267812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x00000024262a7210ULL, 0x000fd60007ffe025ULL, 0x00000000560403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80055247f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668002a287f8cULL, 0x0002a2000c80043fULL, 0x000000ffff597224ULL, 0x008fc600078e0025ULL,
0x0000000000247805ULL, 0x000fc80000015200ULL, 0x00f66c002a277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x00cfc40007804829ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c002a277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018033407810ULL, 0x000fca0007ffe040ULL,
0x0000000143407824ULL, 0x000fca00078e0240ULL, 0x00f0000040257984ULL, 0x000ea80000000800ULL,
0x00f2000040247984ULL, 0x0006620000000800ULL, 0x0000005a2500720bULL, 0x004fe20003f1d000ULL,
0x000095d27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000287806ULL, 0x008fc800000e0100ULL,
0x0000ffff28ff7812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff297424ULL, 0x000fe400078e00ffULL, 0x000000ffff5b7224ULL, 0x000fd200078e005aULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x0000000300277811ULL, 0x000fe400078ff0ffULL,
0x0000005a2500720bULL, 0x000fe40003f14000ULL, 0x000000002700720cULL, 0x000fe20003fa5270ULL,
0x000095827f007947ULL, 0x000fd4000b800000ULL, 0x0000000000297806ULL, 0x000fc400000e0100ULL,
0x000000800026d824ULL, 0x000fe200078e0233ULL, 0x0000005a255b7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x00000001432ad824ULL, 0x002fe200078e0226ULL,
0x0000991029267816ULL, 0x000fc800000000ffULL, 0x00f4005b2a00d388ULL, 0x0003e20000000800ULL,
0x000000ff2600720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000005a5b267221ULL, 0x002fe20000010100ULL, 0x000000ff29ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL,
0x00000026002c7308ULL, 0x000e640000000800ULL, 0x0000002c3b3b7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011602ULL,
0x000094b27f007947ULL, 0x000fea000b800000ULL, 0x00001f262c267589ULL, 0x0002a400000e0000ULL,
0x0000002608087220ULL, 0x084fe20000410000ULL, 0x0000002609097220ULL, 0x080fe20000410000ULL,
0x000000260c0c7220ULL, 0x080fe20000410000ULL, 0x000000260d0d7220ULL, 0x080fe20000410000ULL,
0x0000002610107220ULL, 0x080fe20000410000ULL, 0x0000002611117220ULL, 0x080fe20000410000ULL,
0x0000002614147220ULL, 0x080fe20000410000ULL, 0x0000002615157220ULL, 0x080fe20000410000ULL,
0x0000002618187220ULL, 0x080fe20000410000ULL, 0x0000002619197220ULL, 0x080fe20000410000ULL,
0x000000261c1c7220ULL, 0x080fe20000410000ULL, 0x000000261d1d7220ULL, 0x080fe20000410000ULL,
0x0000002620207220ULL, 0x080fe20000410000ULL, 0x0000002621217220ULL, 0x080fe20000410000ULL,
0x0000002604047220ULL, 0x080fe20000410000ULL, 0x0000002605057220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0029ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802267811ULL, 0x000fe200078ff0ffULL,
0x000093a27f007947ULL, 0x000fea000b800000ULL, 0x00001f262c267589ULL, 0x0004e400000e0000ULL,
0x000000260a0a7220ULL, 0x088fe20000410000ULL, 0x000000260b0b7220ULL, 0x080fe20000410000ULL,
0x000000260e0e7220ULL, 0x080fe20000410000ULL, 0x000000260f0f7220ULL, 0x080fe20000410000ULL,
0x0000002612127220ULL, 0x080fe20000410000ULL, 0x0000002613137220ULL, 0x080fe20000410000ULL,
0x0000002616167220ULL, 0x080fe20000410000ULL, 0x0000002617177220ULL, 0x080fe20000410000ULL,
0x000000261a1a7220ULL, 0x080fe20000410000ULL, 0x000000261b1b7220ULL, 0x080fe20000410000ULL,
0x000000261e1e7220ULL, 0x080fe20000410000ULL, 0x000000261f1f7220ULL, 0x080fe20000410000ULL,
0x0000002622227220ULL, 0x080fe20000410000ULL, 0x0000002623237220ULL, 0x080fe20000410000ULL,
0x0000002606067220ULL, 0x080fe20000410000ULL, 0x0000002607077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff29ff7812ULL, 0x000fe20007800828ULL,
0x00000001ff297424ULL, 0x000fd800078e00ffULL, 0x000000255b250221ULL, 0x000fe20000010100ULL,
0x00007610ff290816ULL, 0x000fc60000000029ULL, 0x3fb8aa3b25250820ULL, 0x000fc80000410000ULL,
0x0000002500460308ULL, 0x000e640000000800ULL, 0x0000004624240220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003b243b7221ULL, 0x002fc40000010000ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x000000013a577824ULL, 0x000fca00078e0257ULL,
0x00f6ac0057277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0057277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991029247816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000046ff24723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe40000011602ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x00008f827f007947ULL, 0x000fea000b800000ULL,
0x00001f2524477589ULL, 0x0002e400000e0000ULL, 0x0000000825267810ULL, 0x000fe20007ffe0ffULL,
0x00008fb27f007947ULL, 0x000fea000b800000ULL, 0x00001f2624487589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001025267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x0000c810002b7802ULL, 0x000fc40000000f00ULL,
0x0000944000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001825267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x004fe200078e0024ULL,
0x0000c860002b7802ULL, 0x000fc40000000f00ULL, 0x000093f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005824783bULL, 0x002e680000004200ULL, 0x000000005454783bULL, 0x000f280000004200ULL,
0x00000000532c783bULL, 0x004ea80000004200ULL, 0x000000005230783bULL, 0x000ee20000004200ULL,
0x00000100248c7824ULL, 0x042fe200078e00ffULL, 0x0000002400867306ULL, 0x000fe20000009400ULL,
0x00000018ff917819ULL, 0x000fe20000011424ULL, 0x00010000248e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011425ULL, 0x0000010025967824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000010026a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001148eULL, 0x00000024008b7306ULL, 0x000e620000005400ULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x0000010027a87824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fc400000114a0ULL, 0x00000018ffa37819ULL, 0x000fe40000011426ULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x0000002400757306ULL, 0x000ea2000000d400ULL,
0x00000018ffab7819ULL, 0x000fe40000011427ULL, 0x00000018ffb07819ULL, 0x010fe40000011454ULL,
0x00000018ff897819ULL, 0x000fe40000011455ULL, 0x00000018ff827819ULL, 0x000fe20000011456ULL,
0x0000008c008d7306ULL, 0x000fe20000209400ULL, 0x0000008b8600720bULL, 0x002fc40003fbd000ULL,
0x0000008c00867245ULL, 0x000fe4000020d400ULL, 0x0000008e008b7245ULL, 0x000fe4000020d400ULL,
0x00000018ff297819ULL, 0x000fe20000011457ULL, 0x0000008c00247306ULL, 0x0003220000205400ULL,
0x00000018ff797819ULL, 0x004fe4000001142cULL, 0x00000018ff7c7819ULL, 0x000fe4000001142dULL,
0x00000018ff6c7819ULL, 0x000fc4000001142eULL, 0x0000000175755812ULL, 0x000fe200078efcffULL,
0x0000009100927306ULL, 0x000fe20000209400ULL, 0x00010000278c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe4000001142fULL, 0x00000018ff427819ULL, 0x008fe40000011432ULL,
0x00000018ff3f7819ULL, 0x000fe40000011433ULL, 0x0000009100937306ULL, 0x000e620000205400ULL,
0x000000248d00720bULL, 0x010fe20003fdd000ULL, 0x00000100548d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fc40000011430ULL, 0x00000018ff407819ULL, 0x000fc60000011431ULL,
0x0000008e008f7306ULL, 0x000fec0000209400ULL, 0x0000000186866812ULL, 0x000fe400078efcffULL,
0x0000008e00907306ULL, 0x0004e20000205400ULL, 0x000000939200720bULL, 0x002fe40003fbd000ULL,
0x00000018ff927819ULL, 0x000fc4000001148cULL, 0x00000091008c7245ULL, 0x000fe4000020d400ULL,
0x000000a000917245ULL, 0x000fe2000020d400ULL, 0x0000002500947306ULL, 0x000fe20000009400ULL,
0x00000100558e7824ULL, 0x004fe200078e00ffULL, 0x000000758686723eULL, 0x000fc800000010ffULL,
0x000000018c8c5812ULL, 0x000fe400078efcffULL, 0x0000002500957306ULL, 0x000e620000005400ULL,
0x000000908f00720bULL, 0x008fe20003fdd000ULL, 0x0000010056907824ULL, 0x000fe200078e00ffULL,
0x00000096008f7245ULL, 0x000fca000020d400ULL, 0x0000009600977306ULL, 0x000fec0000209400ULL,
0x000000018b8b6812ULL, 0x000fe400078efcffULL, 0x0000009600987306ULL, 0x000ea20000205400ULL,
0x000000959400720bULL, 0x002fe40003fbd000ULL, 0x00000018ff957819ULL, 0x000fc4000001148dULL,
0x0000008b8c8c723eULL, 0x000fc600000010ffULL, 0x0000002500767306ULL, 0x0002f0000000d400ULL,
0x0000009b009c7306ULL, 0x000fe20000209400ULL, 0x0001000025257824ULL, 0x002fe200078e00ffULL,
0x000000989700720bULL, 0x004fc80003fdd000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000009b009d7306ULL, 0x000e620000205400ULL, 0x0000000176765812ULL, 0x008fe400078efcffULL,
0x00000025008d7245ULL, 0x000fc8000020d400ULL, 0x000000018f8f6812ULL, 0x000fe200078efcffULL,
0x0000002500997306ULL, 0x000ff00000209400ULL, 0x00000025009a7306ULL, 0x000ea20000205400ULL,
0x0000009d9c00720bULL, 0x002fce0003fbd000ULL, 0x00000026009e7306ULL, 0x000ff00000009400ULL,
0x00000026009f7306ULL, 0x000e620000005400ULL, 0x0000009a9900720bULL, 0x004fe40003fdd000ULL,
0x00000018ff9a7819ULL, 0x000fc4000001148eULL, 0x0000009b008e7245ULL, 0x000fc6000020d400ULL,
0x000000a000a17306ULL, 0x000fe20000209400ULL, 0x000000018e8e5812ULL, 0x000fca00078efcffULL,
0x000000018d8d6812ULL, 0x000fe400078efcffULL, 0x000000a000a27306ULL, 0x000ea20000205400ULL,
0x0000009f9e00720bULL, 0x002fe40003fbd000ULL, 0x0000008d8e8d723eULL, 0x000fca00000010ffULL,
0x0000002600707306ULL, 0x0002f0000000d400ULL, 0x0000002700a67306ULL, 0x000fe20000009400ULL,
0x000000a2a100720bULL, 0x004fe20003fdd000ULL, 0x0001000026267824ULL, 0x002fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002700a77306ULL, 0x000e620000005400ULL,
0x0000000170705812ULL, 0x008fca00078efcffULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x000000a800a97306ULL, 0x000fe40000209400ULL, 0x000000709170723eULL, 0x000fcc00000010ffULL,
0x000000a800aa7306ULL, 0x000ea20000205400ULL, 0x000000a7a600720bULL, 0x002fce0003fbd000ULL,
0x00000027006f7306ULL, 0x000e70000000d400ULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x000000aaa900720bULL, 0x004fce0003fdd000ULL, 0x000000a300a57306ULL, 0x000ea20000205400ULL,
0x000000016f6f5812ULL, 0x002fce00078efcffULL, 0x0000002600247306ULL, 0x000ff00000209400ULL,
0x0000002600277306ULL, 0x000e620000205400ULL, 0x000000a5a400720bULL, 0x004fce0003fbd000ULL,
0x0000005400ae7306ULL, 0x000ff00000009400ULL, 0x0000005400af7306ULL, 0x000ff00000005400ULL,
0x00000054006b7306ULL, 0x0005f0000000d400ULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x0001000054547824ULL, 0x004fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011454ULL,
0x000000a800547245ULL, 0x000fe2000020d400ULL, 0x000000ab00ad7306ULL, 0x000ea60000205400ULL,
0x0000000154546812ULL, 0x000fe400078efcffULL, 0x000000272400720bULL, 0x002fc60003fdd000ULL,
0x0000005500b37306ULL, 0x000ff00000009400ULL, 0x0000005500b47306ULL, 0x000ff00000005400ULL,
0x00000055006a7306ULL, 0x0003f0000000d400ULL, 0x0000009200937306ULL, 0x000fe20000209400ULL,
0x0001000055557824ULL, 0x002fca00078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe40000011455ULL,
0x0000009200947306ULL, 0x0002e20000205400ULL, 0x0000002600557245ULL, 0x000fe4000020d400ULL,
0x00000018ff267819ULL, 0x000fe40000011490ULL, 0x000000a300907245ULL, 0x000fe4000020d400ULL,
0x0000000155556812ULL, 0x000fe200078efcffULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x0000000190905812ULL, 0x000fc400078efcffULL, 0x000000adac00720bULL, 0x004fe40003fbd000ULL,
0x0000009200927245ULL, 0x002fe4000020d400ULL, 0x000000559090723eULL, 0x000fe200000010ffULL,
0x0000009500977306ULL, 0x000e620000205400ULL, 0x000000949300720bULL, 0x008fe20003fdd000ULL,
0x0000010057937824ULL, 0x000fe400078e00ffULL, 0x0001000056947824ULL, 0x000fc600078e00ffULL,
0x00000018ffa07819ULL, 0x000fe20000011493ULL, 0x0000009a009b7306ULL, 0x000fe20000209400ULL,
0x000000ab00937245ULL, 0x000fc8000020d400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x000000afae00720bULL, 0x000fe20003fbd000ULL, 0x0000009a009c7306ULL, 0x000ea20000205400ULL,
0x0000000192926812ULL, 0x000fe400078efcffULL, 0x000000979600720bULL, 0x002fe40003fdd000ULL,
0x00000018ff967819ULL, 0x000fe20000011494ULL, 0x000001002c947824ULL, 0x000fe200078e00ffULL,
0x0000002600977245ULL, 0x000fe2000020d400ULL, 0x00000056008a7306ULL, 0x000fe20000009400ULL,
0x000000929391723eULL, 0x000fc400000010ffULL, 0x00000018ffa37819ULL, 0x000fe40000011494ULL,
0x000000016b6b5812ULL, 0x000fe400078efcffULL, 0x000000b4b300720bULL, 0x000fe20003fbd000ULL,
0x0000005600877306ULL, 0x000fe20000005400ULL, 0x000000b000947245ULL, 0x000fce000020d400ULL,
0x0000005600647306ULL, 0x0003e8000000d400ULL, 0x000000016a6a5812ULL, 0x000fc800078efcffULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x0000009500567245ULL, 0x002fe4000020d400ULL,
0x0000009a00957245ULL, 0x000fe4000020d400ULL, 0x0000000156566812ULL, 0x000fe400078efcffULL,
0x0000009c9b00720bULL, 0x004fe20003fdd000ULL, 0x000000b000b27306ULL, 0x000e700000205400ULL,
0x0000002500987306ULL, 0x000fe80000209400ULL, 0x0000000195956812ULL, 0x000fc800078efcffULL,
0x0000002500997306ULL, 0x000ea20000205400ULL, 0x000000b2b100720bULL, 0x002fce0003fbd000ULL,
0x0000008900b57306ULL, 0x000fec0000209400ULL, 0x0000000194945812ULL, 0x000fe400078efcffULL,
0x0000008900b67306ULL, 0x0002e20000205400ULL, 0x000000999800720bULL, 0x004fce0003fdd000ULL,
0x0000009d00247306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fce000020d400ULL,
0x0000009d00277306ULL, 0x000fe20000205400ULL, 0x000000b6b500720bULL, 0x008fce0003fbd000ULL,
0x0000005700887306ULL, 0x000fec0000009400ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x0000005700857306ULL, 0x000e620000005400ULL, 0x000000878a00720bULL, 0x000fe40003fbd000ULL,
0x000000a3008a7245ULL, 0x000fca000020d400ULL, 0x0000005700657306ULL, 0x0004ec000000d400ULL,
0x0000000164645812ULL, 0x000fe400078efcffULL, 0x00000026009e7306ULL, 0x000fe20000209400ULL,
0x0001000057577824ULL, 0x004fe200078e00ffULL, 0x000000858800720bULL, 0x002fc40003fbd000ULL,
0x000000a000887245ULL, 0x000fe4000020d400ULL, 0x00000018ff9a7819ULL, 0x000fe40000011457ULL,
0x0000002500577245ULL, 0x000fe2000020d400ULL, 0x00000026009f7306ULL, 0x0002a60000205400ULL,
0x0000000157576812ULL, 0x000fe400078efcffULL, 0x000000272400720bULL, 0x000fe20003fdd000ULL,
0x000100002c277824ULL, 0x000fe200078e00ffULL, 0x0000000165655812ULL, 0x008fe200078efcffULL,
0x0000002c002b7306ULL, 0x000fe20000009400ULL, 0x000001002e267824ULL, 0x002fe200078e00ffULL,
0x000000579494723eULL, 0x000fcc00000010ffULL, 0x0000002c00287306ULL, 0x000ff00000005400ULL,
0x0000002c005f7306ULL, 0x0003f0000000d400ULL, 0x000000a000a17306ULL, 0x000fe20000209400ULL,
0x0000009d002c7245ULL, 0x002fc4000020d400ULL, 0x00000018ff9d7819ULL, 0x000fe20000011427ULL,
0x000001002d277824ULL, 0x000fe200078e00ffULL, 0x000000012c2c6812ULL, 0x000fe400078efcffULL,
0x0000009f9e00720bULL, 0x004fe20003fdd000ULL, 0x000000a000a27306ULL, 0x000e620000205400ULL,
0x00000018ff9f7819ULL, 0x000fce0000011427ULL, 0x0000008200847306ULL, 0x000fe80000209400ULL,
0x0000000197976812ULL, 0x000fc800078efcffULL, 0x0000008200837306ULL, 0x0004e20000205400ULL,
0x000000a2a100720bULL, 0x002fe40003fdd000ULL, 0x000000649764723eULL, 0x000fca00000010ffULL,
0x00000096009b7306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x004fca000020d400ULL,
0x0000000188886812ULL, 0x000fe400078efcffULL, 0x00000096009c7306ULL, 0x000e620000205400ULL,
0x000000838400720bULL, 0x008fe40003fbd000ULL, 0x0000002900847245ULL, 0x000fe4000020d400ULL,
0x00000018ff837819ULL, 0x000fe20000011426ULL, 0x000001002f267824ULL, 0x000fe200078e00ffULL,
0x000000658865723eULL, 0x000fe200000010ffULL, 0x0000002900817306ULL, 0x000fe60000209400ULL,
0x00000018ffa07819ULL, 0x000fc60000011426ULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x00000029002a7306ULL, 0x000ea20000205400ULL, 0x0000009c9b00720bULL, 0x002fce0003fdd000ULL,
0x0000009a00987306ULL, 0x000ff00000209400ULL, 0x0000009a00997306ULL, 0x000e620000205400ULL,
0x0000002a8100720bULL, 0x004fe40003fbd000ULL, 0x0000009a00817245ULL, 0x000fca000020d400ULL,
0x0000002d00777306ULL, 0x000fec0000009400ULL, 0x0000000184845812ULL, 0x000fe400078efcffULL,
0x0000002d007a7306ULL, 0x000fe20000005400ULL, 0x000000282b00720bULL, 0x000fe40003fbd000ULL,
0x00a800004a28783bULL, 0x000eaa0000000200ULL, 0x0000002d00607306ULL, 0x0007ec000000d400ULL,
0x000000015f5f5812ULL, 0x000fc400078efcffULL, 0x000000a300247306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x008fca00078e00ffULL, 0x00000018ff857819ULL, 0x000fe4000001142dULL,
0x00000096002d7245ULL, 0x000fe2000020d400ULL, 0x000000a300257306ULL, 0x000ee60000205400ULL,
0x000000012d2d6812ULL, 0x000fe400078efcffULL, 0x000000999800720bULL, 0x002fc60003fdd000ULL,
0x00000079007f7306ULL, 0x000ff00000209400ULL, 0x0000007900807306ULL, 0x0003240000205400ULL,
0x0000000181816812ULL, 0x000fe200078efcffULL, 0x0000004728288231ULL, 0x084fe200003400ffULL,
0x000000252400720bULL, 0x008fe20003fdd000ULL, 0x000000472a2a8231ULL, 0x000fe200003400ffULL,
0x00a800004924783bULL, 0x000ea20000000200ULL, 0x0000004829298231ULL, 0x080fe200003400ffULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x0000007900797245ULL, 0x002fe2000020d400ULL,
0x000000482b2b8231ULL, 0x000fe200003400ffULL, 0x000000818481723eULL, 0x000fca00000010ffULL,
0x0000009d00877306ULL, 0x000e620000205400ULL, 0x000000807f00720bULL, 0x010fe40003fbd000ULL,
0x000000018a8a6812ULL, 0x000fc800078efcffULL, 0x0000005f8a8a723eULL, 0x000fe200000010ffULL,
0x0000009f00a17306ULL, 0x000fec0000209400ULL, 0x0000000179795812ULL, 0x000fe400078efcffULL,
0x0000009f00a27306ULL, 0x0007e20000205400ULL, 0x000000879e00720bULL, 0x002fc40003fdd000ULL,
0x0000007a7700720bULL, 0x000fe40003fbd000ULL, 0x000000768f87723eULL, 0x000fc600000010ffULL,
0x0000002e00787306ULL, 0x000fe20000009400ULL, 0x0000009f009f7245ULL, 0x008fe2000020d400ULL,
0x0000004724248231ULL, 0x004fcc00003400ffULL, 0x0000002e007d7306ULL, 0x000e620000005400ULL,
0x0000000160605812ULL, 0x000fe200078efcffULL, 0x0000004726268231ULL, 0x000fe400003400ffULL,
0x0000004825258231ULL, 0x080fe400003400ffULL, 0x0000004827278231ULL, 0x000fe400003400ffULL,
0x0000002e00537306ULL, 0x0004ea000000d400ULL, 0x000000862408723cULL, 0x000f660000041808ULL,
0x00000085009b7306ULL, 0x000fe20000209400ULL, 0x000100002e2e7824ULL, 0x004fe200078e00ffULL,
0x0000007d7800720bULL, 0x002fc60003f1d000ULL, 0x0000008c240c723cULL, 0x000f62000004180cULL,
0x00000018ff987819ULL, 0x000fe4000001142eULL, 0x00000085009c7306ULL, 0x000e620000205400ULL,
0x0000009d002e7245ULL, 0x000fe2000020d400ULL, 0x00010000339d7824ULL, 0x000fc600078e00ffULL,
0x000000012e2e6812ULL, 0x000fe200078efcffULL, 0x000000902414723cULL, 0x040fe20000041814ULL,
0x000000a2a100720bULL, 0x000fe20003fdd000ULL, 0x0000007c007b7306ULL, 0x000fe20000209400ULL,
0x0000000153530812ULL, 0x008fe400078efcffULL, 0x0000002e792e723eULL, 0x000fe400000010ffULL,
0x00000018ff9d7819ULL, 0x000fe2000001149dULL, 0x000000642420723cULL, 0x000fe40000041820ULL,
0x0000007c007e7306ULL, 0x0004e20000205400ULL, 0x0000009c9b00720bULL, 0x002fe20003fbd000ULL,
0x00010000329b7824ULL, 0x000fc400078e00ffULL, 0x000000019f9f6812ULL, 0x000fe200078efcffULL,
0x00000100339c7824ULL, 0x000fe400078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe2000001149bULL,
0x0000002f00747306ULL, 0x000fe20000009400ULL, 0x0000007c007c7245ULL, 0x004fe4000020d400ULL,
0x00000018ff9c7819ULL, 0x000fe4000001149cULL, 0x000000609f8b723eULL, 0x000fc600000010ffULL,
0x0000002f00737306ULL, 0x000fe20000005400ULL, 0x0000007e7b00720bULL, 0x008fc60003fdd000ULL,
0x0000008a2808723cULL, 0x020fe80000041808ULL, 0x0000002f00527306ULL, 0x0003ec000000d400ULL,
0x000000017c7c6812ULL, 0x000fc400078efcffULL, 0x0000008300967306ULL, 0x000fe20000209400ULL,
0x000100002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001142fULL,
0x00000100302f7824ULL, 0x000fe200078e00ffULL, 0x0000008300997306ULL, 0x000e680000205400ULL,
0x00000018ff7a7819ULL, 0x000fe2000001142fULL, 0x00000100312f7824ULL, 0x000fc600078e00ffULL,
0x000000a000a47306ULL, 0x000fe40000209400ULL, 0x00000018ff807819ULL, 0x000fe4000001142fULL,
0x00000085002f7245ULL, 0x000fe2000020d400ULL, 0x0000010032857824ULL, 0x000fc600078e00ffULL,
0x000000a000a57306ULL, 0x000ea20000205400ULL, 0x000000012f2f5812ULL, 0x000fe400078efcffULL,
0x000000999600720bULL, 0x002fe40003fbd000ULL, 0x0000007f00997245ULL, 0x000fe4000020d400ULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000006c00717306ULL, 0x000fe20000209400ULL,
0x0000002f7c2f723eULL, 0x000fce00000010ffULL, 0x0000006c00727306ULL, 0x000fe20000205400ULL,
0x000000a5a400720bULL, 0x004fe20003fdd000ULL, 0x0000002e280c723cULL, 0x000fec000004180cULL,
0x00000098009a7306ULL, 0x000ff00000209400ULL, 0x0000009800497306ULL, 0x0002b00000205400ULL,
0x00000032005d7306ULL, 0x000fe20000009400ULL, 0x0000009800987245ULL, 0x002fce000020d400ULL,
0x0000003200447306ULL, 0x000fe20000005400ULL, 0x000000499a00720bULL, 0x004fe40003f1d000ULL,
0x0000006c00497245ULL, 0x000fca000020d400ULL, 0x0000003200437306ULL, 0x0003ec000000d400ULL,
0x0000000198980812ULL, 0x000fe400078efcffULL, 0x0000003300507306ULL, 0x000fe20000009400ULL,
0x0000008300327245ULL, 0x002fc8000020d400ULL, 0x0000000132325812ULL, 0x000fe400078efcffULL,
0x000000737400720bULL, 0x000fe20003fbd000ULL, 0x0000003300517306ULL, 0x000fe20000005400ULL,
0x000000533232723eULL, 0x000fce00000010ffULL, 0x00000033005a7306ULL, 0x0003e8000000d400ULL,
0x0000000152525812ULL, 0x000fc800078efcffULL, 0x00000069006e7306ULL, 0x000fe20000209400ULL,
0x000000a000337245ULL, 0x002fc8000020d400ULL, 0x0000000133336812ULL, 0x000fe400078efcffULL,
0x000000727100720bULL, 0x000fe20003fdd000ULL, 0x00000069006d7306ULL, 0x000e620000205400ULL,
0x0000006f5471723eULL, 0x000fe400000010ffULL, 0x000000523333723eULL, 0x000fca00000010ffULL,
0x0000007f004a7306ULL, 0x000fe20000209400ULL, 0x000000702410723cULL, 0x000f660000041810ULL,
0x0000000149496812ULL, 0x000fc800078efcffULL, 0x0000007f00777306ULL, 0x000ea20000205400ULL,
0x0000006d6e00720bULL, 0x002fe40003fbd000ULL, 0x000000984998723eULL, 0x000fca00000010ffULL,
0x0000007a007b7306ULL, 0x000ff00000209400ULL, 0x0000007a007e7306ULL, 0x0002e20000205400ULL,
0x000000774a00720bULL, 0x004fe20003f1d000ULL, 0x000000322810723cULL, 0x020fe20000041810ULL,
0x00000069004a7245ULL, 0x000fc8000020d400ULL, 0x000000014a4a5812ULL, 0x000fe200078efcffULL,
0x00000080007d7306ULL, 0x000fe20000209400ULL, 0x0000007a007a7245ULL, 0x002fca000020d400ULL,
0x0000000199990812ULL, 0x000fe400078efcffULL, 0x0000008000967306ULL, 0x0002a20000205400ULL,
0x0000007e7b00720bULL, 0x008fe40003fdd000ULL, 0x00000080007b7245ULL, 0x000fe4000020d400ULL,
0x000000994a99723eULL, 0x000fc600000010ffULL, 0x0000003000687306ULL, 0x000fe20000009400ULL,
0x0000002d8280723eULL, 0x002fc600000010ffULL, 0x000000982814723cULL, 0x000fe40000041814ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x0000003000677306ULL, 0x000e620000005400ULL,
0x000000967d00720bULL, 0x004fc60003fbd000ULL, 0x000000802404723cULL, 0x000fe80000041804ULL,
0x0000003100667306ULL, 0x000fec0000009400ULL, 0x000000017b7b5812ULL, 0x000fc400078efcffULL,
0x0000003100637306ULL, 0x000ea20000005400ULL, 0x000000676800720bULL, 0x002fce0003f1d000ULL,
0x00000030004f7306ULL, 0x0002f0000000d400ULL, 0x00000031005e7306ULL, 0x0008e2000000d400ULL,
0x0001000030307824ULL, 0x002fe200078e00ffULL, 0x000000636600720bULL, 0x004fc80003fdd000ULL,
0x00000018ff787819ULL, 0x000fe40000011430ULL, 0x0000005800617306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x010fe200078e00ffULL, 0x000000014f4f0812ULL, 0x008fe400078efcffULL,
0x0000006b5630723eULL, 0x000fe400000010ffULL, 0x00000018ff547819ULL, 0x000fe40000011431ULL,
0x0000007800757306ULL, 0x000fe20000209400ULL, 0x0000006a9531723eULL, 0x000fc400000010ffULL,
0x0000002c8995723eULL, 0x000fe400000010ffULL, 0x000000015e5e6812ULL, 0x000fe400078efcffULL,
0x0000005400797245ULL, 0x000fe2000020d400ULL, 0x0000007800747306ULL, 0x0002a20000205400ULL,
0x000000302418723cULL, 0x000f620000041818ULL, 0x0000004f7a7a723eULL, 0x000fe400000010ffULL,
0x0000005e7b7b723eULL, 0x000fc800000010ffULL, 0x0000005800627306ULL, 0x000ee20000205400ULL,
0x0000007800787245ULL, 0x002fe2000020d400ULL, 0x00000094241c723cULL, 0x000b6c000004181cULL,
0x00000054006f7306ULL, 0x000fe20000209400ULL, 0x000000747500720bULL, 0x004fe40003fbd000ULL,
0x0000005800257245ULL, 0x020fc4000020d400ULL, 0x0000008500247245ULL, 0x000fc6000020d400ULL,
0x00000054006c7306ULL, 0x000e620000205400ULL, 0x000000626100720bULL, 0x008fe20003f1d000ULL,
0x0000007a2818723cULL, 0x000b680000041818ULL, 0x0000000178785812ULL, 0x000fe400078efcffULL,
0x0000004000417306ULL, 0x000fec0000209400ULL, 0x0000000125250812ULL, 0x000fc400078efcffULL,
0x00000040005c7306ULL, 0x0004e20000205400ULL, 0x0000006c6f00720bULL, 0x002fe40003fdd000ULL,
0x000000782578723eULL, 0x000fca00000010ffULL, 0x0000008500557306ULL, 0x000fe20000209400ULL,
0x0000004000407245ULL, 0x004fca000020d400ULL, 0x0000000179796812ULL, 0x000fe400078efcffULL,
0x00000085002c7306ULL, 0x000e620000205400ULL, 0x0000005c4100720bULL, 0x008fe40003fbd000ULL,
0x000000445d00720bULL, 0x000fca0003fdd000ULL, 0x0000009c00307306ULL, 0x000fec0000209400ULL,
0x0000000140405812ULL, 0x000fe400078efcffULL, 0x0000009c002d7306ULL, 0x000ea20000205400ULL,
0x0000002c5500720bULL, 0x002fe40003f1d000ULL, 0x0000000143436812ULL, 0x000fc400078efcffULL,
0x000000794079723eULL, 0x000fc600000010ffULL, 0x0000009b00267306ULL, 0x000fe80000209400ULL,
0x00000078281c723cULL, 0x000b64000004181cULL, 0x0000000124240812ULL, 0x000fe400078efcffULL,
0x0000009b00277306ULL, 0x0002e20000205400ULL, 0x0000002d3000720bULL, 0x004fe40003fbd000ULL,
0x000000515000720bULL, 0x000fc40003f1d000ULL, 0x000000432424723eULL, 0x000fe400000010ffULL,
0x0000009d00437245ULL, 0x000fe2000020d400ULL, 0x00000042004d7306ULL, 0x000fe20000209400ULL,
0x0000009b009b7245ULL, 0x002fce000020d400ULL, 0x00000042004e7306ULL, 0x0002a20000205400ULL,
0x000000272600720bULL, 0x008fe40003fdd000ULL, 0x0000009c00277245ULL, 0x000fe4000020d400ULL,
0x000000015a5a0812ULL, 0x000fe400078efcffULL, 0x0000000127275812ULL, 0x000fe200078efcffULL,
0x0000003f00457306ULL, 0x000fe20000209400ULL, 0x0000004200427245ULL, 0x002fe4000020d400ULL,
0x0000003f00267245ULL, 0x000fc4000020d400ULL, 0x0000005a2725723eULL, 0x000fe400000010ffULL,
0x000000019b9b6812ULL, 0x000fe200078efcffULL, 0x0000003f004c7306ULL, 0x000e620000205400ULL,
0x0000004e4d00720bULL, 0x004fc60003fbd000ULL, 0x000000242820723cULL, 0x000b680000041820ULL,
0x0000009d002c7306ULL, 0x000fec0000209400ULL, 0x0000000142425812ULL, 0x000fc400078efcffULL,
0x0000009d002d7306ULL, 0x000ea20000205400ULL, 0x0000004c4500720bULL, 0x002fe40003f1d000ULL,
0x0000009b4242723eULL, 0x000fd600000010ffULL, 0x0000000126260812ULL, 0x000fe400078efcffULL,
0x0000002d2c00720bULL, 0x004fda0003fdd000ULL, 0x0000000143436812ULL, 0x000fc800078efcffULL,
0x000000432643723eULL, 0x000fce00000010ffULL, 0x000000422804723cULL, 0x000b620000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000003e3e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a0004bff7f8cULL, 0x0005e2000c80043fULL, 0x000000013c257812ULL, 0x020fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x002fc400078e003fULL, 0x000000013d3d7810ULL, 0x004fc80007ffe0ffULL,
0x000000343d00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff294000007947ULL, 0x000fea000383ffffULL, 0x000000ff3400720cULL, 0x000fe20003f05270ULL,
0x000000ffff277224ULL, 0x000fe400078e0022ULL, 0x000000ffff227224ULL, 0x000fe400078e001fULL,
0x000000ffff257224ULL, 0x008fe400078e0020ULL, 0x000000ffff1f7224ULL, 0x000fe400078e001aULL,
0x000000ffff267224ULL, 0x000fe400078e0023ULL, 0x000000ffff247224ULL, 0x000fc400078e0021ULL,
0x000000ffff207224ULL, 0x000fe400078e001dULL, 0x000000ffff1a7224ULL, 0x000fe400078e0017ULL,
0x000000ffff237224ULL, 0x000fe400078e001eULL, 0x000000ffff217224ULL, 0x000fe400078e001cULL,
0x000000ffff1d7224ULL, 0x000fe400078e0018ULL, 0x000000ffff177224ULL, 0x000fc400078e0012ULL,
0x000000ffff1e7224ULL, 0x000fe400078e001bULL, 0x000000ffff1c7224ULL, 0x000fe400078e0019ULL,
0x000000ffff187224ULL, 0x000fe400078e0015ULL, 0x000000ffff127224ULL, 0x000fe400078e000fULL,
0x000000ffff1b7224ULL, 0x000fe400078e0016ULL, 0x000000ffff197224ULL, 0x000fc400078e0014ULL,
0x000000ffff157224ULL, 0x000fe400078e0010ULL, 0x000000ffff0f7224ULL, 0x000fe400078e000bULL,
0x000000ffff167224ULL, 0x000fe400078e0013ULL, 0x000000ffff147224ULL, 0x000fe400078e0011ULL,
0x000000ffff107224ULL, 0x000fe400078e000dULL, 0x000000ffff0b7224ULL, 0x000fc400078e0009ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0007ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0006ULL,
0x000000ffff287224ULL, 0x000fe400078e0005ULL, 0x000000ffff297224ULL, 0x000fe400078e0004ULL,
0x000000ffff137224ULL, 0x000fe400078e000eULL, 0x000000ffff117224ULL, 0x000fc400078e000cULL,
0x000000ffff0d7224ULL, 0x000fe400078e000aULL, 0x000000ffff097224ULL, 0x000fe200078e0008ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000003b007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000e92000047802ULL, 0x000fc40000000f00ULL, 0x0000717000007944ULL, 0x006fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003b00007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x008fc8000000003bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x000e680000000000ULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x00000002ff067819ULL, 0x002fe40000011604ULL,
0x0000000807047811ULL, 0x008fe200078ff0ffULL, 0x0000000003057220ULL, 0x014fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000000900097220ULL, 0x042fe20000410000ULL, 0x0000000b000b7220ULL, 0x040fe20000410000ULL,
0x0000001100117220ULL, 0x040fe20000410000ULL, 0x0000001000107220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x000fe20000410000ULL,
0x0000000d040d7220ULL, 0x044fe20000410000ULL, 0x0000000f040f7220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x000fc20000410000ULL,
0x00000000002d7919ULL, 0x000ee80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000082d057811ULL, 0x008fe200078ff0ffULL, 0x0000000138387824ULL, 0x100fe200078e022dULL,
0x00000002ff077819ULL, 0x000fc4000001162dULL, 0x000000022d007812ULL, 0x000fe200078ec0ffULL,
0x0000000805087824ULL, 0x000fe400078e00ffULL, 0x00000008072f7824ULL, 0x040fe200078e00ffULL,
0x0000000700027211ULL, 0x040fe200078ff8ffULL, 0x00000008070c7824ULL, 0x040fe200078e00ffULL,
0x0000000500037211ULL, 0x000fe200078ff8ffULL, 0x0000000807057824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe40007ffe0ffULL, 0xfffffff808087812ULL, 0x000fe200078ee203ULL,
0x0000000807037824ULL, 0x000fe200078e00ffULL, 0xfffffff805067812ULL, 0x000fe200078ee200ULL,
0x0000100039057824ULL, 0x000fe200078e00ffULL, 0x0000000402047810ULL, 0x000fc40007ffe0ffULL,
0xfffffff803007812ULL, 0x000fe200078ee202ULL, 0x0000080036037824ULL, 0x000fe200078e0205ULL,
0x0000000602077810ULL, 0x000fe20007ffe0ffULL, 0x000000082d027824ULL, 0x000fe200078e00ffULL,
0xfffffff82f0a7812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e0203ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x00000010080e7824ULL, 0x100fe200078e0203ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x0000001006087824ULL, 0x100fe200078e0203ULL,
0x000000090b00723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0x000000111002723eULL, 0x000fe200000010ffULL, 0x0000000104067824ULL, 0x000fe200078e0207ULL,
0x000000212004723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x0000541000107816ULL, 0x040fe20000000002ULL, 0x00000001070e7824ULL, 0x040fe200078e020eULL,
0x0000763200117816ULL, 0x000fe20000000002ULL, 0x0000000107087824ULL, 0x040fe200078e0208ULL,
0x000000151400723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x000000191802723eULL, 0x000fe200000010ffULL, 0x0000001006007388ULL, 0x0007e20000000a00ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x0000001d1c03723eULL, 0x000fe200000010ffULL,
0x0000001038387824ULL, 0x000fe200078e0205ULL, 0x0000763200077816ULL, 0x000fc40000000002ULL,
0x0000541000067816ULL, 0x008fe40000000002ULL, 0x000000252400723eULL, 0x000fe400000010ffULL,
0x000000292802723eULL, 0x000fe200000010ffULL, 0x0000000608007388ULL, 0x0007e40000000a00ULL,
0x0000541003067816ULL, 0x148fe40000000004ULL, 0x0000763203077816ULL, 0x000fe40000000004ULL,
0x0000000d0f03723eULL, 0x000fc400000010ffULL, 0x000000131204723eULL, 0x000fe200000010ffULL,
0x000000060a007388ULL, 0x0007e40000000a00ULL, 0x0000541000067816ULL, 0x148fe40000000002ULL,
0x0000763200077816ULL, 0x000fe40000000002ULL, 0x000000171600723eULL, 0x000fe400000010ffULL,
0x0000001b1a02723eULL, 0x000fe200000010ffULL, 0x000000060c007388ULL, 0x0007e40000000a00ULL,
0x0000541003067816ULL, 0x008fc40000000004ULL, 0x0000763203077816ULL, 0x000fe40000000004ULL,
0x0000001f1e03723eULL, 0x000fe400000010ffULL, 0x000000232204723eULL, 0x000fe200000010ffULL,
0x000000060e007388ULL, 0x0007e40000000a00ULL, 0x0000541000067816ULL, 0x148fe40000000002ULL,
0x0000763200077816ULL, 0x000fe40000000002ULL, 0x000000272600723eULL, 0x000fc400000010ffULL,
0x0000002b2a02723eULL, 0x000fe200000010ffULL, 0x0004000608007388ULL, 0x0007e40000000a00ULL,
0x0000541003067816ULL, 0x148fe40000000004ULL, 0x0000763203077816ULL, 0x000fe40000000004ULL,
0x000000ff00037306ULL, 0x000fe60000205400ULL, 0x000400060a007388ULL, 0x0007e40000000a00ULL,
0x0000541000067816ULL, 0x008fc40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x000000ff00007306ULL, 0x000ee60000209400ULL, 0x000400060c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000038107984ULL, 0x000f220000000c00ULL,
0x000000030000720bULL, 0x008fc60003f1d000ULL, 0x0004000038087984ULL, 0x000ee20000000c00ULL,
0x000000ff00007245ULL, 0x000fc6000020d400ULL, 0x0008000038147984ULL, 0x000e680000000c00ULL,
0x000c000038187984ULL, 0x000ea40000000c00ULL, 0x0000000100000812ULL, 0x000fe400078efcffULL,
0x000000ff3600720cULL, 0x000fe40003f05270ULL, 0x000000000004723eULL, 0x000fca00000010ffULL,
0x3f803f8004137831ULL, 0x050fe40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x040fe40000200010ULL,
0x3f803f80040b7831ULL, 0x048fe4000020000bULL, 0x3f803f80040a7831ULL, 0x000fc4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x002fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fc40000200014ULL,
0x3f803f800b0b7831ULL, 0x004fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x0000001038007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x0004000838007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000202d067810ULL, 0x000fe20007ffe0ffULL, 0x0000000000047919ULL, 0x000e620000002600ULL,
0x00000003ff107819ULL, 0x100fe2000001162dULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff037819ULL, 0x000fe20000011606ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000839127824ULL, 0x000fe200078e00ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000110007824ULL, 0x000fc400078e022dULL, 0x0000000106027824ULL, 0x000fe400078e0203ULL,
0x0000000839117824ULL, 0x000fe200078e00ffULL, 0x0000000700007812ULL, 0x000fe400078ec0ffULL,
0x0000000702077812ULL, 0x000fe400078ec0ffULL, 0x0ffffff800007812ULL, 0x000fe400078ef82dULL,
0x0ffffff807027812ULL, 0x100fe400078ef806ULL, 0xfffffff811117812ULL, 0x000fe200078ee206ULL,
0x0000001000007824ULL, 0x000fc400078e0205ULL, 0x0000001002057824ULL, 0x000fe400078e0205ULL,
0x0000000804077824ULL, 0x042fe200078e00ffULL, 0x0000000000087984ULL, 0x0002e20000000c00ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0x00000000050c7984ULL, 0x0005220000000c00ULL, 0xfffffff807027812ULL, 0x000fe400078ee210ULL,
0xfffffff804037812ULL, 0x000fc400078ee203ULL, 0x0000000402077c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000403107c10ULL, 0x000fc6000ff3e0ffULL, 0x000000ffff007224ULL, 0x002fe200000e06ffULL,
0x00005a0007027a11ULL, 0x040fe200078040ffULL, 0x000000ffff057224ULL, 0x004fe200008e06ffULL,
0x00005a0010047a11ULL, 0x000fe400078240ffULL, 0x00005b0007037a11ULL, 0x000fe400000f4400ULL,
0xfffffff812077812ULL, 0x000fe400078ee22dULL, 0x00005b0010057a11ULL, 0x000fc600008f4405ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x00000006041c7981ULL, 0x000322000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x0000000237357824ULL, 0x000fe200078e00ffULL, 0x00f60000ff047f8cULL, 0x002e62000c80043fULL,
0x0000004000367824ULL, 0x000fe400078e00ffULL, 0x0000580035357a24ULL, 0x000fc800078e0212ULL,
0x0000620035177a24ULL, 0x000fc800078e0236ULL, 0x000005a000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1a7819ULL, 0x000fe20000011602ULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0x00000030111f7812ULL, 0x000fe400078ec0ffULL, 0x000000081a137810ULL, 0x040fe20007ffe0ffULL,
0x0000000117067824ULL, 0x040fe200078e021aULL, 0x000000101a1e7810ULL, 0x040fe40007ffe0ffULL,
0x000000181a207810ULL, 0x040fe20007ffe0ffULL, 0x0000000117087824ULL, 0x000fe200078e0213ULL,
0x000000201a167810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x00000036030f7217ULL, 0x000fc40007800000ULL, 0x0000000202127211ULL, 0x000fe200078fe8ffULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0x0000001f060a7210ULL, 0x080fe40007f1e0ffULL,
0x0000100000197811ULL, 0x000fe200078e68ffULL, 0x00000001170e7824ULL, 0x040fe200078e021eULL,
0x0000001f080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000117087824ULL, 0x000fe200078e0220ULL,
0x000000281a187810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe400000e0607ULL,
0x00005e000e067625ULL, 0x000fc800078e0021ULL, 0x000000ffff0d7224ULL, 0x000fe200008e0609ULL,
0x0000001f060e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0008087625ULL, 0x000fc800078e0021ULL,
0x0000000117067824ULL, 0x000fe200078e0216ULL, 0x0000001f08107210ULL, 0x000fe20007f3e0ffULL,
0x000000010f087824ULL, 0x000fe400078e0a36ULL, 0x000000ffff0f7224ULL, 0x000fe400000e0607ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x000000081a00720cULL, 0x080fe40003f06070ULL,
0x000000081e00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff117224ULL, 0x000fe200008e0609ULL,
0x0000000312097812ULL, 0x000fe200078ec0ffULL, 0x0000000413147824ULL, 0x040fe200078e00ffULL,
0x0000001f06127210ULL, 0x000fe20007f5e0ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x000000081300720cULL, 0x000fc40003f26070ULL, 0xfffffffc14067812ULL, 0x000fe200078ee209ULL,
0x000000ffff137224ULL, 0x000fe200010e0607ULL, 0x0ffffffc09027812ULL, 0x000fe400078ef802ULL,
0x000000082000720cULL, 0x080fe20003f86070ULL, 0x00000010061d7824ULL, 0x100fe200078e0219ULL,
0x000000081600720cULL, 0x080fe20003f66070ULL, 0x0000000117067824ULL, 0x000fe200078e0218ULL,
0x000000081800720cULL, 0x000fe20003f46070ULL, 0x00000010021b7824ULL, 0x000fe200078e0219ULL,
0x000000301a027810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x000000381a1a7810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1b7faeULL, 0x0005e4000c101c46ULL, 0x0000001f06147210ULL, 0x000fe20007fde0ffULL,
0x0000000117067824ULL, 0x040fe200078e0202ULL, 0x000000000c1d7faeULL, 0x0007e2000c901c46ULL,
0x000000080200720cULL, 0x080fe40003f26070ULL, 0x000000081a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff157224ULL, 0x000fe400030e0607ULL, 0x0000000117087824ULL, 0x000fc400078e021aULL,
0x00000004200a7824ULL, 0x004fe400078e00ffULL, 0x000000041a1a7824ULL, 0x000fe400078e00ffULL,
0x00000004160c7824ULL, 0x008fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee209ULL,
0x0000000418167824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a1a7812ULL, 0x100fe200078ee209ULL,
0x0000000402187824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e027812ULL, 0x100fe200078ee209ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0xfffffffc0c0c7812ULL, 0x000fc400078ee209ULL,
0xfffffffc16167812ULL, 0x000fe200078ee209ULL, 0x00000010020b7824ULL, 0x100fe200078e0219ULL,
0x0000001f06067210ULL, 0x000fe20007fde0ffULL, 0x000000100a0d7824ULL, 0x000fe200078e0219ULL,
0xfffffffc18187812ULL, 0x000fe200078ee209ULL, 0x00005e0008087625ULL, 0x000fe200078e0021ULL,
0x000000000e0b7faeULL, 0x0005e6000e901c46ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000001f08087210ULL, 0x000fe20007fde0ffULL, 0x000000100c177824ULL, 0x100fe200078e0219ULL,
0x00000000100d7faeULL, 0x0005e2000e101c46ULL, 0x00000010161b7824ULL, 0x000fc400078e0219ULL,
0x00000010181d7824ULL, 0x100fe200078e0219ULL, 0x0000000012177faeULL, 0x0005e2000d901c46ULL,
0x000000101a197824ULL, 0x000fe400078e0219ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x00000000141b7faeULL, 0x0005e8000d101c46ULL, 0x00000000061d7faeULL, 0x0005e8000c901c46ULL,
0x0000000008197faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x0000001702067211ULL, 0x040fe200078ff0ffULL, 0x00000080ff257424ULL, 0x000fe200078e00ffULL,
0x0000000202077211ULL, 0x000fc400078fe8ffULL, 0x0000000802167811ULL, 0x040fe400078ff0ffULL,
0x0000002802107811ULL, 0x000fe400078ff0ffULL, 0x0000000307157812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x0000003011277812ULL, 0x000fe400078ec0ffULL,
0x00000010020a7811ULL, 0x040fe200078ff0ffULL, 0x0000000117087824ULL, 0x040fe200078e0216ULL,
0x0000003002127811ULL, 0x000fe200078ff0ffULL, 0x00000004161e7824ULL, 0x000fe200078e00ffULL,
0x00000020020e7811ULL, 0x040fe200078ff0ffULL, 0x0000000117167824ULL, 0x040fe200078e0210ULL,
0x00000018020c7811ULL, 0x000fe200078ff0ffULL, 0x0000000410247824ULL, 0x000fe200078e00ffULL,
0x0000002706107210ULL, 0x000fe20007f1e0ffULL, 0x0000000117097824ULL, 0x040fe200078e020aULL,
0x0000003802147811ULL, 0x000fe200078ff0ffULL, 0x0000000117187824ULL, 0x040fe200078e0212ULL,
0x0000100000237811ULL, 0x000fe200078e68ffULL, 0x0000000412267824ULL, 0x000fe200078e00ffULL,
0xfffffffc24127812ULL, 0x000fe200078ee215ULL, 0x00000001170f7824ULL, 0x000fc400078e020eULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0xfffffffc26137812ULL, 0x100fe200078ee215ULL,
0x000000040a207824ULL, 0x000fe400078e00ffULL, 0x000000040c227824ULL, 0x000fe400078e00ffULL,
0x000000040e0e7824ULL, 0x000fe400078e00ffULL, 0x00000001171a7824ULL, 0x000fe200078e0214ULL,
0xfffffffc220d7812ULL, 0x100fe200078ee215ULL, 0x0000000414287824ULL, 0x000fe200078e00ffULL,
0x0ffffffc15147812ULL, 0x000fe200078ef802ULL, 0x00005e0008067625ULL, 0x000fe200078e0025ULL,
0xfffffffc1e027812ULL, 0x000fc400078ee215ULL, 0xfffffffc0e0e7812ULL, 0x100fe200078ee215ULL,
0x00000001170a7824ULL, 0x000fe200078e020cULL, 0xfffffffc200c7812ULL, 0x100fe200078ee215ULL,
0x00005e0009087625ULL, 0x000fe200078e0025ULL, 0xfffffffc28157812ULL, 0x000fc600078ee215ULL,
0x00000010121f7824ULL, 0x000fe200078e0223ULL, 0x0000002706127210ULL, 0x000fe20007f1e0ffULL,
0x00005e000a0a7625ULL, 0x000fc800078e0025ULL, 0x0000001014297824ULL, 0x100fe200078e0223ULL,
0x0000002708147210ULL, 0x000fe20007f3e0ffULL, 0x0000001013217824ULL, 0x100fe400078e0223ULL,
0x0000001002177824ULL, 0x100fe200078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010297faeULL, 0x0005e2000b901c46ULL, 0x000000100c197824ULL, 0x100fe400078e0223ULL,
0x000000100d1b7824ULL, 0x100fe400078e0223ULL, 0x000000100e1d7824ULL, 0x000fc400078e0223ULL,
0x000000ffff137224ULL, 0x000fe200000e0607ULL, 0x000000270a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001015237824ULL, 0x000fe400078e0223ULL, 0x000000ffff157224ULL, 0x000fe200008e0609ULL,
0x0000000012177faeULL, 0x0005e2000b901c46ULL, 0x00005e000f067625ULL, 0x000fc600078e0025ULL,
0x0000000014197faeULL, 0x0005e2000b901c46ULL, 0x00005e0016087625ULL, 0x000fc800078e0025ULL,
0x00005e00180c7625ULL, 0x000fe200078e0025ULL, 0x0000002708087210ULL, 0x000fc60007f3e0ffULL,
0x00005e001a0e7625ULL, 0x000fe200078e0025ULL, 0x000000270c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002706067210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000270e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000000a1b7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fe400000e0607ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x00000000061d7faeULL, 0x0005e8000b901c46ULL, 0x00000000081f7faeULL, 0x0005e8000b901c46ULL,
0x000000000c217faeULL, 0x0005e8000b901c46ULL, 0x000000000e237faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x004fc40000015200ULL,
0x00f60400ff097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011409ULL,
0x0000000b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000202027819ULL, 0x000fc80000001209ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fca00078e0205ULL,
0x00000003ff047819ULL, 0x000fc80000011602ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f02047812ULL, 0x000fc600078ec0ffULL, 0x0000000102057824ULL, 0x000fe400078e0205ULL,
0x0000001004077824ULL, 0x040fe400078e00ffULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0x0000000f05027812ULL, 0x040fe400078ec0ffULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000000f007027812ULL, 0x000fe400078ee202ULL, 0x0000000f05057812ULL, 0x000fc600078ec0ffULL,
0x00000000020c7984ULL, 0x000e62000000cc00ULL, 0x000000f004057812ULL, 0x000fca00078ee205ULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001002007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x3db504f31c377820ULL, 0x010fe20000410000ULL,
0x0000f68800387811ULL, 0x000fe200078e18ffULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0xffffffff34397810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000f608003a7811ULL, 0x000fc400078e28ffULL, 0x000001003b3c7824ULL, 0x004fe200078e0236ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003c0300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x008fea0003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e003dULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fc4000001ff00ULL, 0x000000013e247810ULL, 0x000fe20007ffe0ffULL,
0x00000a8000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e003eULL,
0x000000013f3d7812ULL, 0x000fc400078e0cffULL, 0x0000003b24257211ULL, 0x040fe200078ff8ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0024ULL, 0x000000022400780cULL, 0x040fe40003f06070ULL,
0x0000000125277810ULL, 0x040fe20007ffe0ffULL, 0x0000010025287824ULL, 0x020fe200078e0236ULL,
0x0000000124257812ULL, 0x000fe400078ec0ffULL, 0x000000342700720cULL, 0x000fe20003f26070ULL,
0x00006200352d7a24ULL, 0x000fd800078e0228ULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x0000000425317824ULL, 0x000fe200078e00ffULL, 0x0000000202257211ULL, 0x002fe200078fe8ffULL,
0x0000000200307824ULL, 0x000fe200078e023dULL, 0x0000002803247217ULL, 0x000fe20007800000ULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0x00000002ff2a7819ULL, 0x000fe40000011602ULL,
0x00000003252f7812ULL, 0x000fe200078ec0ffULL, 0x0000000124287824ULL, 0x000fe200078e0a28ULL,
0x000000082a257810ULL, 0x040fe20007ffe0ffULL, 0x000000012a247824ULL, 0x000fe200078e022dULL,
0xfffffffc31317812ULL, 0x000fc400078ee202ULL, 0x000000282a00720cULL, 0x080fe20003f26070ULL,
0x0000000125267824ULL, 0x040fe200078e022dULL, 0x000000282500720cULL, 0x040fe20003f46070ULL,
0x00000004252c7824ULL, 0x000fe200078e00ffULL, 0x0000100030307811ULL, 0x000fe200078e60ffULL,
0x00005e0024247625ULL, 0x080fe200078e0033ULL, 0x0ffffffc2f297812ULL, 0x000fe400078ef802ULL,
0xfffffffc2c2b7812ULL, 0x000fe200078ee22fULL, 0x00005e0026267625ULL, 0x000fe200078e0033ULL,
0x000000102a2c7810ULL, 0x000fc40007ffe0ffULL, 0x000000182a2e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e0230ULL, 0x000000202a327810ULL, 0x040fe20007ffe0ffULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x000000282a417810ULL, 0x040fe40007ffe0ffULL,
0x000000302a427810ULL, 0x040fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0230ULL,
0x000000382a437810ULL, 0x000fe20007ffe0ffULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e2000c901c46ULL,
0x000000282c00720cULL, 0x000fc40003f26070ULL, 0x000000283200720cULL, 0x080fe20003f66070ULL,
0x00000000262b7faeULL, 0x0005e2000d101c46ULL, 0x000000282e00720cULL, 0x080fe20003f46070ULL,
0x000000042c447824ULL, 0x000fe200078e00ffULL, 0x000000284100720cULL, 0x0c0fe20003f86070ULL,
0x000000042e467824ULL, 0x000fe200078e00ffULL, 0x000000284200720cULL, 0x080fe20003fa6070ULL,
0x0000000441487824ULL, 0x000fe200078e00ffULL, 0x000000284300720cULL, 0x000fe20003fc6070ULL,
0x000000012c247824ULL, 0x102fe400078e022dULL, 0x0000000132287824ULL, 0x000fe200078e022dULL,
0xfffffffc48477812ULL, 0x000fe200078ee22fULL, 0x00000001422c7824ULL, 0x000fc400078e022dULL,
0x0000000432327824ULL, 0x000fe400078e00ffULL, 0x0000000442427824ULL, 0x000fe400078e00ffULL,
0x00000004434a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc32457812ULL, 0x000fe200078ee22fULL,
0x000000012e267824ULL, 0x004fe200078e022dULL, 0xfffffffc42497812ULL, 0x000fe200078ee22fULL,
0x00000001412a7824ULL, 0x000fe200078e022dULL, 0xfffffffc44417812ULL, 0x000fe200078ee22fULL,
0x00000001432e7824ULL, 0x000fe200078e022dULL, 0xfffffffc46437812ULL, 0x100fe200078ee22fULL,
0x00005e0024247625ULL, 0x000fe200078e0033ULL, 0xfffffffc4a4b7812ULL, 0x000fc600078ee22fULL,
0x00005e0026267625ULL, 0x000fc800078e0033ULL, 0x00005e0028287625ULL, 0x000fc800078e0033ULL,
0x00005e002a2a7625ULL, 0x000fc800078e0033ULL, 0x00005e002c2c7625ULL, 0x000fc800078e0033ULL,
0x00005e002e2e7625ULL, 0x000fc800078e0033ULL, 0x0000001031247825ULL, 0x000fc800078e0024ULL,
0x0000001031267825ULL, 0x000fc800078e0026ULL, 0x0000001031287825ULL, 0x000fc800078e0028ULL,
0x00000010312a7825ULL, 0x000fc800078e002aULL, 0x00000010312c7825ULL, 0x000fc800078e002cULL,
0x00000010312e7825ULL, 0x000fc800078e002eULL, 0x0000001041317824ULL, 0x100fe400078e0230ULL,
0x0000001043337824ULL, 0x100fe400078e0230ULL, 0x0000001045417824ULL, 0x100fe200078e0230ULL,
0x0000000024317faeULL, 0x0003e2000c901c46ULL, 0x0000001047437824ULL, 0x100fe400078e0230ULL,
0x0000001049457824ULL, 0x100fe200078e0230ULL, 0x0000000026337faeULL, 0x0003e2000d101c46ULL,
0x000000104b477824ULL, 0x000fc600078e0230ULL, 0x0000000028417faeULL, 0x0003e8000d901c46ULL,
0x000000002a437faeULL, 0x0003e8000e101c46ULL, 0x000000002c457faeULL, 0x0003e8000e901c46ULL,
0x000000002e477faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x0000000200267824ULL, 0x000fe200078e023dULL, 0x0000000802287811ULL, 0x042fe200078ff0ffULL,
0x0000000425417824ULL, 0x000fe200078e00ffULL, 0x00000010022a7811ULL, 0x040fe200078ff0ffULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0x00000018022c7811ULL, 0x000fe200078ff0ffULL,
0x0000000428447824ULL, 0x000fe200078e00ffULL, 0x00000020022e7811ULL, 0x000fe200078ff0ffULL,
0x000000042a467824ULL, 0x000fe200078e00ffULL, 0x0000002802307811ULL, 0x000fe200078ff0ffULL,
0x000000042c487824ULL, 0x000fe200078e00ffULL, 0x0000003002327811ULL, 0x000fe200078ff0ffULL,
0x000000042e4a7824ULL, 0x000fe200078e00ffULL, 0x0000003802427811ULL, 0x000fe200078ff0ffULL,
0x00000004304c7824ULL, 0x000fe200078e00ffULL, 0x00001000264d7811ULL, 0x000fe200078e60ffULL,
0x0000000128267824ULL, 0x100fe200078e022dULL, 0x0000000202257211ULL, 0x000fe200078fe8ffULL,
0x000000012a287824ULL, 0x100fe200078e022dULL, 0x0000002d02247211ULL, 0x000fe200078ff0ffULL,
0x000000012c2a7824ULL, 0x100fe200078e022dULL, 0x0000000325277812ULL, 0x000fe200078ec0ffULL,
0x000000012e2c7824ULL, 0x000fe200078e022dULL, 0xfffffffc41417812ULL, 0x000fe200078ee202ULL,
0x00000004324e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x100fe200078ee227ULL,
0x0000000442507824ULL, 0x000fe200078e00ffULL, 0xfffffffc46467812ULL, 0x000fe200078ee227ULL,
0x00000001302e7824ULL, 0x000fe200078e022dULL, 0xfffffffc48487812ULL, 0x000fe200078ee227ULL,
0x0000000132307824ULL, 0x000fe200078e022dULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee227ULL,
0x0000000142327824ULL, 0x000fe200078e022dULL, 0xfffffffc4c4c7812ULL, 0x100fe200078ee227ULL,
0x00005e0024247625ULL, 0x000fe200078e0033ULL, 0xfffffffc4e4e7812ULL, 0x000fc400078ee227ULL,
0xfffffffc50507812ULL, 0x000fe200078ee227ULL, 0x00005e0028287625ULL, 0x000fe200078e0033ULL,
0x0ffffffc27427812ULL, 0x000fc600078ef802ULL, 0x00005e0026267625ULL, 0x000fc800078e0033ULL,
0x00005e002a2a7625ULL, 0x000fc800078e0033ULL, 0x00005e002c2c7625ULL, 0x000fc800078e0033ULL,
0x00005e002e2e7625ULL, 0x000fc800078e0033ULL, 0x00005e0030307625ULL, 0x000fc800078e0033ULL,
0x00005e0032327625ULL, 0x000fc800078e0033ULL, 0x0000001041247825ULL, 0x000fc800078e0024ULL,
0x0000001041267825ULL, 0x000fc800078e0026ULL, 0x0000001041287825ULL, 0x000fc800078e0028ULL,
0x00000010412a7825ULL, 0x000fc800078e002aULL, 0x00000010412c7825ULL, 0x000fc800078e002cULL,
0x00000010412e7825ULL, 0x000fc800078e002eULL, 0x0000001041307825ULL, 0x000fc800078e0030ULL,
0x0000001041327825ULL, 0x000fc800078e0032ULL, 0x00000010424f7824ULL, 0x100fe400078e024dULL,
0x0000001044417824ULL, 0x100fe400078e024dULL, 0x0000001046437824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000244f7faeULL, 0x0003e2000b901c46ULL,
0x0000001048457824ULL, 0x100fe400078e024dULL, 0x000000104a477824ULL, 0x100fe200078e024dULL,
0x0000000026417faeULL, 0x0003e2000b901c46ULL, 0x000000104c497824ULL, 0x000fc400078e024dULL,
0x000000104e4b7824ULL, 0x100fe200078e024dULL, 0x0000000028437faeULL, 0x0003e2000b901c46ULL,
0x00000010504d7824ULL, 0x000fc600078e024dULL, 0x000000002a457faeULL, 0x0003e8000b901c46ULL,
0x000000002c477faeULL, 0x0003e8000b901c46ULL, 0x000000002e497faeULL, 0x0003e8000b901c46ULL,
0x00000000304b7faeULL, 0x0003e8000b901c46ULL, 0x00000000324d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff417224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff802257812ULL, 0x000fe200078ec0ffULL, 0x0000000200297824ULL, 0x020fe200078e023fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000020022b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000725257812ULL, 0x100fe400078ef802ULL, 0x0000100029297811ULL, 0x000fe400078e60ffULL,
0x00000001ff247819ULL, 0x000fe20000011625ULL, 0x0000000425277824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x0000000141477810ULL, 0x000fe20007ffe0ffULL, 0x0000000124267824ULL, 0x000fe200078e0241ULL,
0x000000072b2b7812ULL, 0x000fc400078ef802ULL, 0x0000000702cb7812ULL, 0x000fe200078ec0ffULL,
0x0000000124247824ULL, 0x000fe200078e0247ULL, 0xfffffffc27267812ULL, 0x000fe200078ee226ULL,
0x000000042b2d7824ULL, 0x040fe200078e00ffULL, 0x00000001ff287819ULL, 0x000fe2000001162bULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc25247812ULL, 0x000fe200078ee224ULL,
0x0000001026307824ULL, 0x000fe200078e0229ULL, 0x00000008cbce7812ULL, 0x000fe200078ef802ULL,
0x00000001282a7824ULL, 0x000fe400078e0241ULL, 0x0000001024247824ULL, 0x000fc400078e0229ULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0xfffffffc2d2a7812ULL, 0x000fe200078ee22aULL,
0x0000000128287824ULL, 0x000fe400078e0247ULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x00000010ced07824ULL, 0x000fe400078e00ffULL, 0x000000102a2a7824ULL, 0x000fe200078e0229ULL,
0xfffffffc2b287812ULL, 0x000fe200078ee228ULL, 0x00000010cecf7824ULL, 0x000fc600078e00ffULL,
0x000000002a2c783bULL, 0x000ee20000000200ULL, 0x0000001028287824ULL, 0x000fcc00078e0229ULL,
0x000000002828783bULL, 0x000f220000000200ULL, 0x0000003000af7306ULL, 0x002fe20000009400ULL,
0x00000018ffa97819ULL, 0x000fe20000011430ULL, 0x0001000030517824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe20000011431ULL, 0x0001000025827824ULL, 0x044fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011425ULL, 0x0000010025847824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe20000011451ULL, 0x0000003000b07306ULL, 0x000e620000005400ULL,
0x0001000033a87824ULL, 0x040fe200078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011432ULL,
0x0000010032aa7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x008fe2000001142cULL,
0x0001000026757824ULL, 0x040fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000010026737824ULL, 0x000fe200078e00ffULL, 0x0000003000637306ULL, 0x0004e2000000d400ULL,
0x00000018ff947819ULL, 0x000fe2000001142dULL, 0x0000010033a77824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe20000011426ULL, 0x00010000247d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011433ULL, 0x0000010024837824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011427ULL, 0x000000b400b57306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x004fe200078e00ffULL, 0x000000b0af00720bULL, 0x002fc40003f9d000ULL,
0x00000018ffaa7819ULL, 0x000fe400000114aaULL, 0x00000018ffb77819ULL, 0x000fe20000011430ULL,
0x0001000031307824ULL, 0x000fe200078e00ffULL, 0x000000b400b67306ULL, 0x000e620000205400ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ff8e7819ULL, 0x000fe4000001142eULL,
0x00000018ffba7819ULL, 0x000fe20000011430ULL, 0x0001000032307824ULL, 0x000fe200078e00ffULL,
0x0000000163634812ULL, 0x008fe200078efcffULL, 0x0000003100ab7306ULL, 0x000fe20000009400ULL,
0x00000018ff887819ULL, 0x000fc4000001142fULL, 0x00000018ffc07819ULL, 0x000fe40000011430ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff727819ULL, 0x000fe20000011424ULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x000000b6b500720bULL, 0x002fe20003f5d000ULL,
0x0001000027b57824ULL, 0x040fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0000010027b67824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fc40000011483ULL,
0x00000018ff847819ULL, 0x000fe20000011484ULL, 0x000000ba00bc7306ULL, 0x000e620000205400ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff307819ULL, 0x010fe40000011428ULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000003100a67306ULL, 0x000ea20000005400ULL, 0x00000018ff517819ULL, 0x000fc4000001142aULL,
0x00000018ff547819ULL, 0x000fca000001142bULL, 0x0000003200a07306ULL, 0x000fe20000009400ULL,
0x000000bcbb00720bULL, 0x002fce0003fbd000ULL, 0x0000003200a17306ULL, 0x000e620000005400ULL,
0x000000a6ab00720bULL, 0x004fe40003f3d000ULL, 0x000000b400a67245ULL, 0x000fc8000020d400ULL,
0x00000001a6a62812ULL, 0x000fe200078efcffULL, 0x000000b700b87306ULL, 0x000fe60000209400ULL,
0x00000063a6a6723eULL, 0x000fca00000010ffULL, 0x000000b700b97306ULL, 0x000ea20000205400ULL,
0x000000a1a000720bULL, 0x002fe40003f5d000ULL, 0x000000ba00a17245ULL, 0x000fe4000020d400ULL,
0x000000a900a07245ULL, 0x000fe4000020d400ULL, 0x00000001a1a15812ULL, 0x000fe200078efcffULL,
0x0000003100627306ULL, 0x0002f0000000d400ULL, 0x0000009e00ae7306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x002fe200078e00ffULL, 0x000000b9b800720bULL, 0x004fc80003f7d000ULL,
0x00000018ffbd7819ULL, 0x000fe40000011431ULL, 0x0000009e00c17306ULL, 0x000e620000205400ULL,
0x0000000162621812ULL, 0x008fe400078efcffULL, 0x00000018ff317819ULL, 0x000fe40000011429ULL,
0x00000062a162723eULL, 0x000fc600000010ffULL, 0x000000c000c27306ULL, 0x000ff00000209400ULL,
0x000000c000c37306ULL, 0x000ea20000205400ULL, 0x000000c1ae00720bULL, 0x002fce0003f9d000ULL,
0x000000a900b27306ULL, 0x000ff00000209400ULL, 0x000000a900b37306ULL, 0x0002e20000205400ULL,
0x000000c3c200720bULL, 0x004fce0003fbd000ULL, 0x0000002500667306ULL, 0x000fe20000009400ULL,
0x000100002ea97824ULL, 0x002fce00078e00ffULL, 0x0000002500697306ULL, 0x000fe20000005400ULL,
0x000000b3b200720bULL, 0x008fe20003fdd000ULL, 0x000001002fb27824ULL, 0x000fca00078e00ffULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x0000002500427306ULL, 0x0003ec000000d400ULL,
0x00000001a0a06812ULL, 0x000fe400078efcffULL, 0x0000002c00917306ULL, 0x000fe20000009400ULL,
0x000100002c257824ULL, 0x002fce00078e00ffULL, 0x0000002c00907306ULL, 0x000ff00000005400ULL,
0x0000002c005a7306ULL, 0x0003f0000000d400ULL, 0x0000002400987306ULL, 0x000fe20000009400ULL,
0x000001002c2c7824ULL, 0x002fca00078e00ffULL, 0x00000018ffc97819ULL, 0x000fe2000001142cULL,
0x000100002d2c7824ULL, 0x000fe200078e00ffULL, 0x0000002400977306ULL, 0x000e680000005400ULL,
0x00000018ffcc7819ULL, 0x000fc8000001142cULL, 0x000000bd00be7306ULL, 0x000ff00000209400ULL,
0x000000bd00bf7306ULL, 0x000fe20000205400ULL, 0x000000979800720bULL, 0x002fe40003f3d000ULL,
0x0000009e00977245ULL, 0x000fe2000020d400ULL, 0x000001002e9e7824ULL, 0x000fe200078e00ffULL,
0x000000c000987245ULL, 0x000fc4000020d400ULL, 0x0000000197974812ULL, 0x000fe200078efcffULL,
0x0000002d007f7306ULL, 0x000fe20000009400ULL, 0x0000000198985812ULL, 0x000fe400078efcffULL,
0x00000018ff9e7819ULL, 0x000fca000001149eULL, 0x0000002d007c7306ULL, 0x000ff00000005400ULL,
0x0000002d00577306ULL, 0x0003f0000000d400ULL, 0x00000026006a7306ULL, 0x000fe20000009400ULL,
0x000001002d2d7824ULL, 0x002fce00078e00ffULL, 0x0000002600677306ULL, 0x000ff00000005400ULL,
0x0000002600437306ULL, 0x0003f0000000d400ULL, 0x0000009900a27306ULL, 0x000fe20000209400ULL,
0x00000018ff267819ULL, 0x002fe20000011425ULL, 0x0000000440257824ULL, 0x000fe200078e0241ULL,
0x0000000241417810ULL, 0x000fc60007ffe0ffULL, 0x0000000225257824ULL, 0x000fe400078e00ffULL,
0x0000009900a57306ULL, 0x0002a60000205400ULL, 0x0000000225cd7810ULL, 0x000fe40007ffe0ffULL,
0x0000002502257211ULL, 0x040fe400078fe0ffULL, 0x000000cd02cd7211ULL, 0x000fe200078fe0ffULL,
0x000000a800b17306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fe2000020d400ULL,
0x00000001ce257824ULL, 0x000fc400078e0225ULL, 0x00000001ce2c7824ULL, 0x000fc600078e02cdULL,
0xfffffff0d0257812ULL, 0x000fe200078ee225ULL, 0x000000a800c67306ULL, 0x0002e20000205400ULL,
0x000000a5a200720bULL, 0x004fe20003f9d000ULL, 0x000100002fa57824ULL, 0x000fe200078e00ffULL,
0xfffffff0cf2c7812ULL, 0x000fe200078ee22cULL, 0x0000001025257824ULL, 0x000fc600078e00ffULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x00000033009f7306ULL, 0x000fe20000009400ULL,
0x000000a800a87245ULL, 0x002fca000020d400ULL, 0x0000000199994812ULL, 0x000fe400078efcffULL,
0x00000033009c7306ULL, 0x000e620000005400ULL, 0x000000c6b100720bULL, 0x008fce0003fbd000ULL,
0x0000002700647306ULL, 0x000fec0000009400ULL, 0x00000001a8a85812ULL, 0x000fe400078efcffULL,
0x0000002700657306ULL, 0x000fe20000005400ULL, 0x0000009c9f00720bULL, 0x002fe40003fdd000ULL,
0x000000bd009c7245ULL, 0x000fc4000020d400ULL, 0x00000018ff9f7819ULL, 0x000fe400000114a9ULL,
0x000000909100720bULL, 0x000fe20003fbd000ULL, 0x0000002700447306ULL, 0x0003e2000000d400ULL,
0x0000008900907245ULL, 0x000fe4000020d400ULL, 0x000000a700a97245ULL, 0x000fca000020d400ULL,
0x00000032005f7306ULL, 0x000ea2000000d400ULL, 0x00000018ff277819ULL, 0x002fe4000001142dULL,
0x000000b7002d7245ULL, 0x000fe4000020d400ULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x000000012d2d3812ULL, 0x000fe200078efcffULL, 0x00000089009b7306ULL, 0x000fe20000209400ULL,
0x000000bfbe00720bULL, 0x000fce0003f7d000ULL, 0x00000089009a7306ULL, 0x000e620000205400ULL,
0x000000015f5f2812ULL, 0x004fc800078efcffULL, 0x0000005f9898723eULL, 0x000fe400000010ffULL,
0x000000019c9c3812ULL, 0x000fe200078efcffULL, 0x000000aa00c47306ULL, 0x000fe60000209400ULL,
0x0000009c9763723eULL, 0x000fca00000010ffULL, 0x000000aa00c57306ULL, 0x0004e20000205400ULL,
0x0000009a9b00720bULL, 0x002fe40003f5d000ULL, 0x0000009d009a7245ULL, 0x000fca000020d400ULL,
0x0000002600c77306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x004fca000020d400ULL,
0x0000000190902812ULL, 0x000fe400078efcffULL, 0x0000002600c87306ULL, 0x000e620000205400ULL,
0x000000c5c400720bULL, 0x008fce0003f7d000ULL, 0x000000cc00cd7306ULL, 0x000fec0000209400ULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x000000cc00b07306ULL, 0x000ea20000205400ULL,
0x000000c8c700720bULL, 0x002fe40003f9d000ULL, 0x000000aa9999723eULL, 0x000fca00000010ffULL,
0x000000a700ad7306ULL, 0x000ff00000209400ULL, 0x000000a700ac7306ULL, 0x0002e20000205400ULL,
0x000000b0cd00720bULL, 0x004fce0003f5d000ULL, 0x00000033005b7306ULL, 0x000ea2000000d400ULL,
0x0000002da0a7723eULL, 0x002fce00000010ffULL, 0x0000009d00a37306ULL, 0x000fe20000209400ULL,
0x000000acad00720bULL, 0x008fce0003f7d000ULL, 0x0000009d00a47306ULL, 0x000e620000205400ULL,
0x000000015b5b6812ULL, 0x004fc800078efcffULL, 0x0000005ba8a8723eULL, 0x000fe400000010ffULL,
0x00000001a9a93812ULL, 0x000fe200078efcffULL, 0x0000002e007a7306ULL, 0x000fe60000009400ULL,
0x000000a990a9723eULL, 0x000fca00000010ffULL, 0x0000002e007b7306ULL, 0x000fe20000005400ULL,
0x000000a4a300720bULL, 0x002fce0003fdd000ULL, 0x0000002e00507306ULL, 0x000fec000000d400ULL,
0x000000019a9a6812ULL, 0x000fe400078efcffULL, 0x0000009f00af7306ULL, 0x000ff00000209400ULL,
0x0000009f002e7306ULL, 0x0003f00000205400ULL, 0x000000c900ca7306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fce000020d400ULL, 0x000000c900cb7306ULL, 0x0002b00000205400ULL,
0x0000002f00767306ULL, 0x000fe20000009400ULL, 0x000000c900c97245ULL, 0x002fce000020d400ULL,
0x0000002f00777306ULL, 0x000fe20000005400ULL, 0x000000cbca00720bULL, 0x004fce0003f7d000ULL,
0x0000002f004b7306ULL, 0x0003ec000000d400ULL, 0x00000001c9c93812ULL, 0x000fe400078efcffULL,
0x0000002700ab7306ULL, 0x000fe20000209400ULL, 0x00000026002f7245ULL, 0x002fe4000020d400ULL,
0x0000007b7a00720bULL, 0x000fc40003f7d000ULL, 0x000000012f2f4812ULL, 0x000fe400078efcffULL,
0x0000007c7f00720bULL, 0x000fe20003f9d000ULL, 0x0000002700ae7306ULL, 0x000e620000205400ULL,
0x000000cc007c7245ULL, 0x000fe4000020d400ULL, 0x00000027007a7245ULL, 0x000fe4000020d400ULL,
0x000000017c7c2812ULL, 0x000fe400078efcffULL, 0x0000002eaf00720bULL, 0x000fe20003f5d000ULL,
0x0000009400957306ULL, 0x000fe20000209400ULL, 0x00000094007b7245ULL, 0x000fc4000020d400ULL,
0x0000000150503812ULL, 0x000fe400078efcffULL, 0x0000000157574812ULL, 0x000fe400078efcffULL,
0x00000018ff2e7819ULL, 0x000fe200000114b5ULL, 0x0000009400967306ULL, 0x000ea20000205400ULL,
0x000000aeab00720bULL, 0x002fe40003fbd000ULL, 0x0000005a2f5a723eULL, 0x000fe400000010ffULL,
0x000000019f9f2812ULL, 0x000fc400078efcffULL, 0x000000777600720bULL, 0x000fe20003f5d000ULL,
0x0000009e00a27306ULL, 0x000fe20000209400ULL, 0x0000008e00777245ULL, 0x000fe4000020d400ULL,
0x0000002e002f7245ULL, 0x000fe4000020d400ULL, 0x000000c99a5b723eULL, 0x000fe400000010ffULL,
0x000000017a7a5812ULL, 0x000fe200078efcffULL, 0x0000009e009b7306ULL, 0x0002e20000205400ULL,
0x000000969500720bULL, 0x004fc40003fdd000ULL, 0x000000577c7c723eULL, 0x000fe400000010ffULL,
0x000000014b4b2812ULL, 0x000fc600078efcffULL, 0x0000008e00937306ULL, 0x000fe20000209400ULL,
0x0000009e009e7245ULL, 0x002fca000020d400ULL, 0x000000017b7b6812ULL, 0x000fe400078efcffULL,
0x0000008e00927306ULL, 0x000e620000205400ULL, 0x0000009ba200720bULL, 0x008fce0003f9d000ULL,
0x000000a500917306ULL, 0x000fec0000209400ULL, 0x000000019e9e4812ULL, 0x000fe400078efcffULL,
0x000000a500267306ULL, 0x000ea20000205400ULL, 0x000000929300720bULL, 0x002fe40003fbd000ULL,
0x000000696600720bULL, 0x000fe20003f9d000ULL, 0x0001000028697824ULL, 0x000fe200078e00ffULL,
0x000000a500667245ULL, 0x000fc6000020d400ULL, 0x0000007d008a7306ULL, 0x000fec0000209400ULL,
0x0000000177775812ULL, 0x000fe400078efcffULL, 0x0000007d008f7306ULL, 0x0002e20000205400ULL,
0x000000269100720bULL, 0x004fe40003fdd000ULL, 0x000000676a00720bULL, 0x000fc40003fbd000ULL,
0x0000007d006a7245ULL, 0x000fe4000020d400ULL, 0x000000b200677245ULL, 0x000fe2000020d400ULL,
0x000000b2007f7306ULL, 0x000fe20000209400ULL, 0x00000018ff7d7819ULL, 0x002fe20000011469ULL,
0x0001000029697824ULL, 0x000fe200078e00ffULL, 0x0000000142424812ULL, 0x000fe400078efcffULL,
0x0000009e772d723eULL, 0x000fe400000010ffULL, 0x0000000166666812ULL, 0x000fe200078efcffULL,
0x000000b200967306ULL, 0x000e620000205400ULL, 0x0000008f8a00720bULL, 0x008fc40003f5d000ULL,
0x0000000143435812ULL, 0x000fe400078efcffULL, 0x0000004b6666723eULL, 0x000fc600000010ffULL,
0x00000088008c7306ULL, 0x000fec0000209400ULL, 0x000000016a6a2812ULL, 0x000fe400078efcffULL,
0x00000088008d7306ULL, 0x0004e20000205400ULL, 0x000000967f00720bULL, 0x002fce0003f7d000ULL,
0x00000072006c7306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x004fca000020d400ULL,
0x0000000167673812ULL, 0x000fe400078efcffULL, 0x00000072006d7306ULL, 0x0002a20000205400ULL,
0x0000008d8c00720bULL, 0x008fce0003fdd000ULL, 0x0000002400457306ULL, 0x000ee2000000d400ULL,
0x0000007200727245ULL, 0x002fca000020d400ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x0000008200807306ULL, 0x000fe20000209400ULL, 0x0000006d6c00720bULL, 0x004fe40003f5d000ULL,
0x000000656400720bULL, 0x000fe20003fdd000ULL, 0x0000010028647824ULL, 0x000fe200078e00ffULL,
0x0000008200657245ULL, 0x000fe4000020d400ULL, 0x000000678867723eULL, 0x000fe200000010ffULL,
0x0000008200857306ULL, 0x0002a20000205400ULL, 0x0000000145451812ULL, 0x008fc400078efcffULL,
0x00000018ff6c7819ULL, 0x000fe40000011464ULL, 0x0000007500647245ULL, 0x000fe4000020d400ULL,
0x0000000172722812ULL, 0x000fe200078efcffULL, 0x00000083008b7306ULL, 0x000fe20000209400ULL,
0x000001002b827824ULL, 0x002fe200078e00ffULL, 0x0000000144446812ULL, 0x000fe400078efcffULL,
0x000000456a6a723eULL, 0x000fe400000010ffULL, 0x00000018ff827819ULL, 0x000fc40000011482ULL,
0x0000008300247306ULL, 0x0002e20000205400ULL, 0x000000858000720bULL, 0x004fe20003f3d000ULL,
0x000100002a807824ULL, 0x040fe400078e00ffULL, 0x000001002a857824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x00000068006e7306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x002fe4000020d400ULL, 0x00000018ff857819ULL, 0x000fc60000011485ULL,
0x0000000165651812ULL, 0x000fe400078efcffULL, 0x00000068006b7306ULL, 0x000e620000205400ULL,
0x000000248b00720bULL, 0x008fe40003f7d000ULL, 0x000000002524783bULL, 0x000eaa0000000200ULL,
0x0000005e00707306ULL, 0x000fec0000209400ULL, 0x0000000183833812ULL, 0x000fc400078efcffULL,
0x0000005e006f7306ULL, 0x0007220000205400ULL, 0x0000006b6e00720bULL, 0x002fe40003f5d000ULL,
0x00000083726b723eULL, 0x000fca00000010ffULL, 0x0000008400867306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x008fce000020d400ULL, 0x0000008400877306ULL, 0x0002e20000205400ULL,
0x0000006f7000720bULL, 0x010fe40003f3d000ULL, 0x00000018ff6f7819ULL, 0x000fe40000011469ULL,
0x0000006800697245ULL, 0x000fc6000020d400ULL, 0x0000007300787306ULL, 0x000fe20000209400ULL,
0x0000000169692812ULL, 0x000fe400078efcffULL, 0x0000008400847245ULL, 0x002fe2000020d400ULL,
0x000000622420723cULL, 0x004f640000041820ULL, 0x000000015e5e1812ULL, 0x000fe400078efcffULL,
0x0000007300797306ULL, 0x0002a20000205400ULL, 0x000000878600720bULL, 0x008fe20003f7d000ULL,
0x000100002b867824ULL, 0x000fc400078e00ffULL, 0x000000a62418723cULL, 0x000f660000041818ULL,
0x00000018ff867819ULL, 0x000fe20000011486ULL, 0x0000002e00897306ULL, 0x000fe20000209400ULL,
0x0000007300737245ULL, 0x002fc6000020d400ULL, 0x00000098241c723cULL, 0x000fe4000004181cULL,
0x0000000184843812ULL, 0x000fe400078efcffULL, 0x0000002e00767306ULL, 0x000e620000205400ULL,
0x000000797800720bULL, 0x004fc60003f5d000ULL, 0x000000a82414723cULL, 0x040f680000041814ULL,
0x0000002800717306ULL, 0x000fe80000009400ULL, 0x0000005a2410723cULL, 0x000f640000041810ULL,
0x0000000173732812ULL, 0x000fc400078efcffULL, 0x0000002800747306ULL, 0x000ea20000005400ULL,
0x000000768900720bULL, 0x002fc60003f3d000ULL, 0x000000662404723cULL, 0x000fe80000041804ULL,
0x0000002800497306ULL, 0x000e6c000000d400ULL, 0x000000012f2f1812ULL, 0x000fc400078efcffULL,
0x00000075007e7306ULL, 0x000fe20000209400ULL, 0x000000747100720bULL, 0x004fe40003f9d000ULL,
0x000000442f44723eULL, 0x000fca00000010ffULL, 0x0000007500817306ULL, 0x000eac0000205400ULL,
0x0000000149494812ULL, 0x002fe400078efcffULL, 0x0000007d008b7306ULL, 0x000ff00000209400ULL,
0x0000007d00287306ULL, 0x000e620000205400ULL, 0x000000817e00720bULL, 0x004fc40003f7d000ULL,
0x0000008500817245ULL, 0x000fca000020d400ULL, 0x0000002a005d7306ULL, 0x000fec0000009400ULL,
0x0000000164643812ULL, 0x000fe400078efcffULL, 0x0000002a005c7306ULL, 0x000ea20000005400ULL,
0x000000288b00720bULL, 0x002fe20003fbd000ULL, 0x000000102c287824ULL, 0x000fe200078e00ffULL,
0x000000509f2c723eULL, 0x000fc400000010ffULL, 0x000000436464723eULL, 0x000fc600000010ffULL,
0x0000004a004e7306ULL, 0x000fe40000209400ULL, 0x0000002c2408723cULL, 0x000bec0000041808ULL,
0x0000004a004f7306ULL, 0x000e620000205400ULL, 0x0000005c5d00720bULL, 0x004fe40003f5d000ULL,
0x0000007d005c7245ULL, 0x000fc4000020d400ULL, 0x0000004a002d7245ULL, 0x020fe4000020d400ULL,
0x000000015c5c5812ULL, 0x000fe200078efcffULL, 0x000000b6007f7306ULL, 0x000fe20000209400ULL,
0x0000007a7b7d723eULL, 0x000fe400000010ffULL, 0x0000006c005d7245ULL, 0x000fe4000020d400ULL,
0x000000495c5c723eULL, 0x000fc600000010ffULL, 0x000000b6008a7306ULL, 0x0004e20000205400ULL,
0x0000004f4e00720bULL, 0x002fe20003f3d000ULL, 0x0000007c240c723cULL, 0x000b6c000004180cULL,
0x0000002900617306ULL, 0x000fe20000009400ULL, 0x000000b600b67245ULL, 0x004fe4000020d400ULL,
0x000000426524723eULL, 0x020fc400000010ffULL, 0x000000846925723eULL, 0x000fe400000010ffULL,
0x000000012d2d1812ULL, 0x000fe200078efcffULL, 0x0000002900607306ULL, 0x000e620000005400ULL,
0x0000008a7f00720bULL, 0x008fe40003f9d000ULL, 0x000000735e65723eULL, 0x000fca00000010ffULL,
0x0000006c006d7306ULL, 0x000fec0000209400ULL, 0x00000001b6b64812ULL, 0x000fe400078efcffULL,
0x0000006c006e7306ULL, 0x000ea20000205400ULL, 0x000000606100720bULL, 0x002fe40003f7d000ULL,
0x000000b62d45723eULL, 0x000fca00000010ffULL, 0x0000003000587306ULL, 0x000ff00000209400ULL,
0x0000003000597306ULL, 0x0002e20000205400ULL, 0x0000006e6d00720bULL, 0x004fce0003fbd000ULL,
0x0000002900487306ULL, 0x000522000000d400ULL, 0x0000003000307245ULL, 0x002fca000020d400ULL,
0x000000015d5d5812ULL, 0x000fe400078efcffULL, 0x0000002a00477306ULL, 0x000e62000000d400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x000000595800720bULL, 0x008fc80003fdd000ULL,
0x00000018ff627819ULL, 0x000fe40000011429ULL, 0x0000002b004c7306ULL, 0x000fe20000009400ULL,
0x0000000148483812ULL, 0x010fcc00078efcffULL, 0x0000000130306812ULL, 0x000fe200078efcffULL,
0x0000002b004d7306ULL, 0x000ea20000005400ULL, 0x0000000147472812ULL, 0x002fe400078efcffULL,
0x0000005d305d723eULL, 0x000fca00000010ffULL, 0x0000002b00467306ULL, 0x0002f0000000d400ULL,
0x0000003100327306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000004d4c00720bULL, 0x004fcc0003fbd000ULL, 0x0000003100337306ULL, 0x00052e0000205400ULL,
0x0000000146465812ULL, 0x008fe200078efcffULL, 0x0000006f00687306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x004fce000020d400ULL, 0x0000006f005f7306ULL, 0x0004e20000205400ULL,
0x000000333200720bULL, 0x010fce0003f3d000ULL, 0x0000006200607306ULL, 0x000fe20000209400ULL,
0x0000006f006f7245ULL, 0x004fca000020d400ULL, 0x0000000131311812ULL, 0x000fe400078efcffULL,
0x0000006200617306ULL, 0x0005220000205400ULL, 0x0000005f6800720bULL, 0x008fe20003f9d000ULL,
0x000000242820723cULL, 0x042b6c0000041820ULL, 0x0000008000637306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fe2000020d400ULL, 0x0000006a2818723cULL, 0x000b640000041818ULL,
0x0000005100247245ULL, 0x020fc4000020d400ULL, 0x0000008600257245ULL, 0x000fe4000020d400ULL,
0x000000016f6f4812ULL, 0x000fe200078efcffULL, 0x00000080006e7306ULL, 0x0002a20000205400ULL,
0x000000616000720bULL, 0x010fe20003fdd000ULL, 0x000000442814723cULL, 0x000b620000041814ULL,
0x000000486f48723eULL, 0x000fca00000010ffULL, 0x00000085002e7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fe2000020d400ULL, 0x00000064281c723cULL, 0x040b68000004181cULL,
0x0000000162626812ULL, 0x000fe400078efcffULL, 0x00000085004b7306ULL, 0x000e620000205400ULL,
0x0000006e6300720bULL, 0x004fe20003f7d000ULL, 0x0000005c2810723cULL, 0x000b620000041810ULL,
0x000000623149723eULL, 0x000fca00000010ffULL, 0x0000005100527306ULL, 0x000fe40000209400ULL,
0x00000048280c723cULL, 0x000b68000004180cULL, 0x0000000180803812ULL, 0x000fe400078efcffULL,
0x0000005100537306ULL, 0x000ea20000205400ULL, 0x0000004b2e00720bULL, 0x002fe40003f3d000ULL,
0x000000478080723eULL, 0x000fc400000010ffULL, 0x0000008200477245ULL, 0x000fc6000020d400ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x0000000181811812ULL, 0x000fe400078efcffULL,
0x0000005400567306ULL, 0x0002e20000205400ULL, 0x000000535200720bULL, 0x004fe40003f9d000ULL,
0x000000044100780cULL, 0x000fca0003f25270ULL, 0x00000086002c7306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x002fca000020d400ULL, 0x0000000124244812ULL, 0x000fe400078efcffULL,
0x0000008600277306ULL, 0x000e620000205400ULL, 0x000000565500720bULL, 0x008fe40003fdd000ULL,
0x000000812481723eULL, 0x000fca00000010ffULL, 0x0000008200267306ULL, 0x000fe40000209400ULL,
0x000000802808723cULL, 0x000b680000041808ULL, 0x0000000154546812ULL, 0x000fe400078efcffULL,
0x00000082002d7306ULL, 0x000ea20000205400ULL, 0x000000272c00720bULL, 0x002fda0003f7d000ULL,
0x0000000125253812ULL, 0x000fe400078efcffULL, 0x0000002d2600720bULL, 0x004fe40003f5d000ULL,
0x000000462546723eULL, 0x000fd600000010ffULL, 0x0000000147472812ULL, 0x000fc800078efcffULL,
0x000000475447723eULL, 0x000fce00000010ffULL, 0x000000462804723cULL, 0x000b620000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e003dULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd5b000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000003716287220ULL, 0x0a0fe20000410000ULL,
0x000000371a247220ULL, 0x080fe20000410000ULL, 0x0000003717297220ULL, 0x080fe20000410000ULL,
0x0000003710167220ULL, 0x080fe20000410000ULL, 0x0000003718187220ULL, 0x080fe20000410000ULL,
0x0000003719197220ULL, 0x080fe20000410000ULL, 0x000000371b257220ULL, 0x080fe20000410000ULL,
0x0000003711177220ULL, 0x080fe20000410000ULL, 0x000000370c1a7220ULL, 0x080fe20000410000ULL,
0x0000003720207220ULL, 0x080fe20000410000ULL, 0x0000003721217220ULL, 0x080fe20000410000ULL,
0x000000371c1c7220ULL, 0x080fe20000410000ULL, 0x000000371d1d7220ULL, 0x080fe20000410000ULL,
0x0000003714147220ULL, 0x080fe20000410000ULL, 0x0000003715157220ULL, 0x080fe20000410000ULL,
0x000000370d1b7220ULL, 0x080fe20000410000ULL, 0x0000003708087220ULL, 0x080fe20000410000ULL,
0x0000003709097220ULL, 0x080fe20000410000ULL, 0x0000003704047220ULL, 0x080fe20000410000ULL,
0x00000037122a7220ULL, 0x080fe20000410000ULL, 0x00000037132b7220ULL, 0x080fe20000410000ULL,
0x000000370a2e7220ULL, 0x080fe20000410000ULL, 0x000000370b2f7220ULL, 0x080fe20000410000ULL,
0x000000ffff127224ULL, 0x000fe200078e0016ULL, 0x000000370e2c7220ULL, 0x080fe20000410000ULL,
0x000000370f2d7220ULL, 0x080fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0018ULL,
0x0000003722227220ULL, 0x080fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0019ULL,
0x0000003723237220ULL, 0x080fe20000410000ULL, 0x000000ffff137224ULL, 0x000fe200078e0017ULL,
0x000000371e267220ULL, 0x080fe20000410000ULL, 0x000000ffff167224ULL, 0x000fe200078e001aULL,
0x000000371f277220ULL, 0x080fe20000410000ULL, 0x0000003705057220ULL, 0x080fe20000410000ULL,
0x0000003706067220ULL, 0x080fe20000410000ULL, 0x0000003707077220ULL, 0x000fe20000410000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0020ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0021ULL,
0x000000ffff0e7224ULL, 0x000fe400078e001cULL, 0x000000ffff0f7224ULL, 0x000fe400078e001dULL,
0x000000ffff107224ULL, 0x000fe400078e0014ULL, 0x000000ffff117224ULL, 0x000fe400078e0015ULL,
0x000000ffff177224ULL, 0x000fc400078e001bULL, 0x000000ffff187224ULL, 0x000fe400078e0008ULL,
0x000000ffff197224ULL, 0x000fe400078e0009ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000038087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0024ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0022ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0023ULL,
0x000000ffff207224ULL, 0x000fe400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e0028ULL, 0x000000ffff237224ULL, 0x000fe400078e0029ULL,
0x000000ffff247224ULL, 0x000fc400078e002aULL, 0x000000ffff257224ULL, 0x000fe400078e002bULL,
0x000000ffff1b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fc400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040038077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604157210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040038077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000402157824ULL, 0x000fe200078e00ffULL, 0x000000393b00720cULL, 0x000fc80003f05270ULL,
0xfffffff015057812ULL, 0x000fca00078ec0ffULL, 0x0000008000147824ULL, 0x000fca00078e0205ULL,
0x00f4000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000202087824ULL, 0x000fe400078e00ffULL, 0x00000001033c7824ULL, 0x000fc600078e0a3cULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x00000001092d7812ULL, 0x040fe400078efcffULL,
0x00000008092f7812ULL, 0x000fe400078efcffULL, 0x0000003c2d00720cULL, 0x080fe40003f26070ULL,
0x00000010092d7812ULL, 0x000fe400078efcffULL, 0x0000003c2f00720cULL, 0x080fe40003f06070ULL,
0x0000003c2d00720cULL, 0x000fc40003fc6070ULL, 0x00000011092f7812ULL, 0x040fe400078efcffULL,
0x00000018092d7812ULL, 0x040fe400078efcffULL, 0x0000003c0900720cULL, 0x080fe40003f46070ULL,
0x0000003c2f00720cULL, 0x080fe40003fa6070ULL, 0x0000003c2d00720cULL, 0x000fe40003f66070ULL,
0x0000000909317812ULL, 0x000fc400078efcffULL, 0x00000019092f7812ULL, 0x040fe400078efcffULL,
0x00000020092d7812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x0000003c3100720cULL, 0x080fe40003f86070ULL,
0x0000003c2f00720cULL, 0x080fe40003f46070ULL, 0x0000003c2d00720cULL, 0x000fe40003f26070ULL,
0x00000021092f7812ULL, 0x040fe400078efcffULL, 0x00000028092d7812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x0000003c2f00720cULL, 0x080fe40003f06070ULL, 0x0000003c2d00720cULL, 0x000fe40003f86070ULL,
0x00000029092f7812ULL, 0x000fc400078efcffULL, 0x00000030092d7812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x0000003c2f00720cULL, 0x000fc40003fc6070ULL, 0x0000003c2d00720cULL, 0x000fe40003fa6070ULL,
0x00000031092f7812ULL, 0x040fe400078efcffULL, 0x00000038092d7812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000024247808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x0000003c2f00720cULL, 0x080fe40003f66070ULL,
0x0000003c2d00720cULL, 0x000fc40003f46070ULL, 0x0000003c0900720cULL, 0x000fe40003f26070ULL,
0xff80000025257808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000028287808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff80000029297808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000002a2a7808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000002b2b7808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff327424ULL, 0x000fe200078e00ffULL,
0x0000001c0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff337424ULL, 0x000fe200078e00ffULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000090c047208ULL, 0x000fe40004000000ULL, 0x000000051e087208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x000000040d057208ULL, 0x000fe40004000000ULL, 0x000000081f097208ULL, 0x000fc40004800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fc40003f3e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x0000000821097208ULL, 0x000fe40004800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fe40003f3e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x0000000922087208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fe40004800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000240900720bULL, 0x000fc40003f3e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x0000000924087208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000250800720bULL, 0x000fe40003f3e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x0000000825097208ULL, 0x000fc40004800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fe40003f3e000ULL,
0x0000000516047208ULL, 0x000fe40004000000ULL, 0x0000000926087208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fc40003f3e000ULL,
0x0000000417057208ULL, 0x000fe40004000000ULL, 0x0000000827097208ULL, 0x000fe40004800000ULL,
0x000000180500720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x0000000518047208ULL, 0x000fe40004000000ULL, 0x0000000928087208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x000000290800720bULL, 0x000fe40003f3e000ULL,
0x0000000419057208ULL, 0x000fe40004000000ULL, 0x0000000829097208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fc40003f3e000ULL,
0x000000051a047208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x000000041b2e7208ULL, 0x000fe40004000000ULL, 0x000000082b307208ULL, 0x000fe20004800000ULL,
0x000015027f007947ULL, 0x000fec000b800000ULL, 0x0c401f002e047f89ULL, 0x0004e400000e0000ULL,
0x000000042e00720bULL, 0x008fc80003f1e000ULL, 0x0000002e04317208ULL, 0x000fe20004000000ULL,
0x000015127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0030047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000e6200000e0000ULL,
0x000000043000720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000003004087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f0031047f89ULL, 0x000ee200000e0000ULL, 0x0000002c0700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000e6200000e0000ULL, 0x000000072c2c7208ULL, 0x000fc60004000000ULL,
0x0c201f00092e7f89ULL, 0x004ea800000e0000ULL, 0x0c201f002c2d7f89ULL, 0x0002a200000e0000ULL,
0x000000043100720bULL, 0x008fe40003f1e000ULL, 0x000000050800720bULL, 0x002fe40003f3e000ULL,
0x0000003104047208ULL, 0x000fe40004000000ULL, 0x0000002e0900720bULL, 0x004fc40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x000000092e067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05317820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b0a0a7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fe20000010831ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x00000004ff327e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x000fe20000010807ULL, 0x3f8000003232783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010831ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010831ULL,
0x000000ffff337224ULL, 0x000fe200078e0032ULL, 0x3fb8aa3b23237823ULL, 0x000fe20000010831ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x00000018002e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010831ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x000000080908723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b27277823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b1b077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe20000010831ULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x0000000302ff7812ULL, 0x000fc4000780c0ffULL, 0x0000002d2c00720bULL, 0x004fca0003f3e000ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000001d001d7308ULL, 0x000ea20000000800ULL,
0x0000000c0d0a723eULL, 0x002fce00000010ffULL, 0x0000001e000b7308ULL, 0x000ff00000000800ULL,
0x0000001f00187308ULL, 0x000e620000000800ULL, 0x0000001c1d09723eULL, 0x004fce00000010ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b180b723eULL, 0x002fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x00000032081c723cULL, 0x000f6e00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fce00000010ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x00000020210d723eULL, 0x002fe400000010ffULL, 0x00000002ff217819ULL, 0x000fc80000011602ULL,
0x0000000121107810ULL, 0x040fe20007ffe0ffULL, 0x00000019002f7308ULL, 0x000fe20000000800ULL,
0x0000000821117824ULL, 0x040fe200078e00ffULL, 0x0000000821427810ULL, 0x040fe20007ffe0ffULL,
0x0000000821407824ULL, 0x040fe400078e00ffULL, 0x00000008213c7824ULL, 0x000fe200078e00ffULL,
0xfffffff811207812ULL, 0x000fe400078ee210ULL, 0x00000022230f723eULL, 0x004fe200000010ffULL,
0x0000001a00307308ULL, 0x0003f00000000800ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x000000320c18723cULL, 0x022b6e000004181cULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x00000008211d7824ULL, 0x060fe200078e00ffULL, 0x00000004211c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008211f7824ULL, 0x000fca00078e00ffULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x000000161712723eULL, 0x004fe400000010ffULL, 0x0000000221167810ULL, 0x000fc40007ffe0ffULL,
0x0000000321177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81d227812ULL, 0x000fe200078ee216ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0xffffffff211d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000821167824ULL, 0x000fc600078e00ffULL, 0xfffffff840407812ULL, 0x000fe400078ee21dULL,
0xfffffff816167812ULL, 0x000fe200078ee221ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000242511723eULL, 0x002fe200000010ffULL, 0x0000000821247824ULL, 0x000fca00078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee217ULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x0000000521177810ULL, 0x000fc80007ffe0ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee217ULL,
0x000000262713723eULL, 0x004fe200000010ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0xfffffff81f267812ULL, 0x000fe400078ee21cULL, 0x00000006211c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000842217824ULL, 0x000fe400078e00ffULL, 0x000000321018723cULL, 0x000f620000041818ULL,
0xfffffff81f3e7812ULL, 0x000fe200078ee21cULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x0000002e2f1c723eULL, 0x000fc400000010ffULL, 0x00000030071e723eULL, 0x002fe400000010ffULL,
0x0000900000077811ULL, 0x000fe400078e58ffULL, 0xfffffff821427812ULL, 0x000fe200078ee242ULL,
0x0000002a002a7308ULL, 0x000fe40000000800ULL, 0x0000001016167824ULL, 0x100fe400078e0207ULL,
0x0000001020207824ULL, 0x100fe400078e0207ULL, 0x0000001022227824ULL, 0x000fc400078e0207ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x00000028291d723eULL, 0x004fe200000010ffULL,
0x0000001024247824ULL, 0x100fe400078e0207ULL, 0x0000001026267824ULL, 0x000fe400078e0207ULL,
0x0000000116177824ULL, 0x000fe400078e0215ULL, 0x000000103c3c7824ULL, 0x100fe400078e0207ULL,
0x0000000115207824ULL, 0x000fe200078e0220ULL, 0x0000000817007388ULL, 0x0005e20000000800ULL,
0x000000103e3e7824ULL, 0x000fc400078e0207ULL, 0x0000000115227824ULL, 0x000fe200078e0222ULL,
0x0000000a20007388ULL, 0x0005e20000000800ULL, 0x0000002a2b1f723eULL, 0x002fe200000010ffULL,
0x0000001040407824ULL, 0x100fe400078e0207ULL, 0x0000000115247824ULL, 0x000fe200078e0224ULL,
0x0000000c22007388ULL, 0x0005e20000000800ULL, 0x0000001042427824ULL, 0x000fe200078e0207ULL,
0x0000002c2d077208ULL, 0x000fe20004800000ULL, 0x000000321c18723cULL, 0x020f620000041818ULL,
0x0000000115267824ULL, 0x040fe200078e0226ULL, 0x0000000e24007388ULL, 0x0005e20000000800ULL,
0x00000001153c7824ULL, 0x000fc400078e023cULL, 0x00000001153e7824ULL, 0x040fe200078e023eULL,
0x0000001026007388ULL, 0x0005e20000000800ULL, 0x0000000115407824ULL, 0x040fe400078e0240ULL,
0x0000000115427824ULL, 0x000fe200078e0242ULL, 0x000000123c007388ULL, 0x0005e80000000800ULL,
0x0000001c3e007388ULL, 0x0005e80000000800ULL, 0x0000001e40007388ULL, 0x0005e80000000800ULL,
0x0000000942007388ULL, 0x0005e40000000800ULL, 0x000000ffff197224ULL, 0x020fc400078e001aULL,
0x0004000b20007388ULL, 0x0005e80000000800ULL, 0x0004000d22007388ULL, 0x0005e80000000800ULL,
0x0004000f24007388ULL, 0x0005e80000000800ULL, 0x0004001126007388ULL, 0x0005e80000000800ULL,
0x000400133c007388ULL, 0x0005e80000000800ULL, 0x0004001d3e007388ULL, 0x0005e80000000800ULL,
0x0004001f40007388ULL, 0x0005e80000000800ULL, 0x00f0000414008388ULL, 0x0005e80000000c00ULL,
0x00f2001814008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003aff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000013b3b7810ULL, 0x000fe20007ffe0ffULL, 0x000018003aff7f8cULL, 0x0003e6000c80043fULL,
0x000000343b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb7e000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff277807ULL, 0x008fe40004000000ULL, 0x0001501000267802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e002aULL,
0xfffece9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe40004000000ULL,
0x0001506000267802ULL, 0x000fc40000000f00ULL, 0x00000c4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e002aULL, 0xfffecf0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x008fe200078e002fULL, 0x000150b0002b7802ULL, 0x000fc40000000f00ULL,
0x00000ba000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002aULL,
0xfffecfc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e002fULL,
0x00015100002b7802ULL, 0x000fc40000000f00ULL, 0x00000b5000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002aULL, 0xfffed0e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00015160002b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fc400078e0029ULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e002aULL, 0xfffed4e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0048ULL, 0x000151c0002b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0024ULL, 0x00000a9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff487224ULL, 0x004fe200078e002aULL, 0xfffed4b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x004fe40004000000ULL, 0x0001521000267802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e002aULL,
0xffff040000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe40004000000ULL,
0x0001526000267802ULL, 0x000fc40000000f00ULL, 0x00000a4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff297224ULL, 0x000fe200078e002aULL, 0xffff045000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e002cULL, 0x000152b0002b7802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002aULL,
0xffff052000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e002cULL,
0x00015300002b7802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002aULL, 0xffff063000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00015360002b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fc400078e0025ULL, 0x000008f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e002aULL, 0xffff0a9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x000153b0002b7802ULL, 0x000fc40000000f00ULL,
0x000008a000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e002aULL,
0xffff0a7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x002fe40004000000ULL,
0x0001540000267802ULL, 0x000fc40000000f00ULL, 0x000008a000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e002aULL, 0xffff36f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x000fe40004000000ULL, 0x0001545000267802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff297224ULL, 0x000fe200078e002aULL,
0xffff374000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e002cULL,
0x000154a0002b7802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002aULL, 0xffff382000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e002cULL, 0x000154f0002b7802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002aULL,
0xffff393000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x00015550002b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e0025ULL,
0x0000070000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff477224ULL, 0x004fe200078e002aULL,
0xffff3d4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x000155a0002b7802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff487224ULL, 0x004fe200078e002aULL, 0xffff3d2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x008fe40004000000ULL, 0x000155f000267802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e002aULL,
0xffff69f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe40004000000ULL,
0x0001564000267802ULL, 0x000fc40000000f00ULL, 0x0000066000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff297224ULL, 0x000fe200078e002aULL, 0xffff6a4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e002cULL, 0x00015690002b7802ULL, 0x000fc40000000f00ULL,
0x000005c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002aULL,
0xffff6b1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e002cULL,
0x000156e0002b7802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002aULL, 0xffff6c2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00015740002b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fc400078e0025ULL, 0x0000051000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e002aULL, 0xffff703000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0024ULL, 0x00015790002b7802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e002aULL,
0xffff701000007947ULL, 0x000fea000383ffffULL, 0x00000002ff2f7424ULL, 0x000fe200078e00ffULL,
0x000157e000087802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002dULL, 0xffffeac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x006fe200078e0030ULL, 0x0001584000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000002d3000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0006ULL,
0x000158a000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000302d307208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000002d0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0007ULL,
0x0001590000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000062d067208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000002d0700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0031ULL,
0x0001596000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000072d2c7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000002d3100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0030ULL,
0x000159c000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000312d047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000002d3000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0006ULL,
0x00015a2000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000302d057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000002d0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e002cULL,
0x00015a8000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000062d067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe99000007947ULL, 0x000fea000383ffffULL, 0x018000003b007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000003b00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff3bff7812ULL, 0x040fe4000780c0ffULL,
0x800000003b027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003b00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffea3f002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003300007348ULL, 0x000fe80003800000ULL, 0x0c00002f2e2d7389ULL, 0x0002a200000e0032ULL,
0xfffea3b008007950ULL, 0x000fea0003c3ffffULL, 0x0000004500007348ULL, 0x000fe80003800000ULL,
0x000000262a2a7389ULL, 0x0002a200000e0044ULL, 0x00000000ff277424ULL, 0x000fc400078e00ffULL,
0x000000ffff267224ULL, 0x002fc800078e002bULL, 0xfffea36026007950ULL, 0x000fea0003c3ffffULL,
0x000000012700780cULL, 0x000fe20003f05070ULL, 0x0000004200007348ULL, 0x000fd80003800000ULL,
0x0000000000277806ULL, 0x000fc800040e0100ULL, 0x00000042272a7212ULL, 0x000fe200078ec0ffULL,
0x00000000ff277424ULL, 0x000fc800078e00ffULL, 0xfffea30026007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x00000000000003d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000da8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e68ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001600ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001690ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001694ULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000015e00ULL, 0xd300001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017680ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000176d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017a50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001690ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015ff0ULL, 0x0000000000015ff0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017a50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin_len = 97072;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
