/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b2d0ULL, 0x000000000001af50ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x00000000000193a0ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000019520ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000019560ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x00000000000195b0ULL, 0x0000000000000150ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019700ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000193a000000000ULL, 0x0000040400000000ULL, 0x810c000000180400ULL, 0x0064c40408288080ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9408288080820828ULL,
0x2880809508288080ULL, 0x80be08288080b108ULL, 0x1628808084082880ULL, 0x0000031028808280ULL,
0x8492000000000000ULL, 0x0000002200288080ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x000193a000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9408288080820828ULL, 0x2880809508288080ULL, 0x80be08288080b108ULL, 0x1628808088082880ULL,
0x0000031028808280ULL, 0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000011800000000ULL, 0x0001952000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9408288080820828ULL, 0x2880809508288080ULL,
0x80be08288080b108ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080be9200ULL,
0x0000002cffffffffULL, 0x000001a800000000ULL, 0x0001956000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8094288080be0900ULL, 0x0000000000002880ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9408288080820828ULL, 0x288080b108288080ULL, 0x809508288080be08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080959200ULL, 0x0000002cffffffffULL,
0x0000024000000000ULL, 0x000195b000000000ULL, 0x0000015000000000ULL, 0x0000080400000000ULL,
0x8094288080950900ULL, 0x0000000000002880ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000008ULL, 0x000000080000001bULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0060016000000018ULL, 0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0x0000092000043104ULL, 0xffffffff01342904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000045001342804ULL, 0x000005a000000480ULL,
0x00002660000025d0ULL, 0x000028e000002780ULL, 0x00002d8000002d50ULL, 0x00002e6000002df0ULL,
0x00005d2000005c90ULL, 0x00005fb000005e50ULL, 0x0000647000006440ULL, 0x00006550000064e0ULL,
0x00009240000091a0ULL, 0x000094c000009360ULL, 0x0000997000009940ULL, 0x00009a50000099e0ULL,
0x0000c7a00000c700ULL, 0x0000ca200000c8c0ULL, 0x0000cf300000cf00ULL, 0x0000d0100000cfa0ULL,
0x0000f1a00000f190ULL, 0x000178f0000178b0ULL, 0x0001791000017900ULL, 0x0001798000017960ULL,
0x000179b0000179a0ULL, 0x000186c000018670ULL, 0x0001879000018730ULL, 0x0001887000018800ULL,
0x00018920000188d0ULL, 0x000189f000018990ULL, 0x00018ad000018a60ULL, 0x00018b8000018b30ULL,
0x00018c5000018bf0ULL, 0x00018d3000018cc0ULL, 0x00018de000018d90ULL, 0x00018eb000018e50ULL,
0x00018f9000018f20ULL, 0x0001908000019000ULL, 0x0001918000019100ULL, 0x0001928000019200ULL,
0x0001938000019300ULL, 0x000003e004403904ULL, 0x00017600000000ffULL, 0x000004e0003f0100ULL,
0x000176080000000dULL, 0x00000500003f0120ULL, 0x000176880000000dULL, 0x00000530003f0120ULL,
0x000176a80000000dULL, 0x00000570003f0120ULL, 0x000176c80000000dULL, 0x00000930003f0120ULL,
0x00017600000000ffULL, 0x00000b30003f0107ULL, 0x0000000400000004ULL, 0x00000be0003f0102ULL,
0x0000000000000004ULL, 0x00001450003f0101ULL, 0x00000000000000ffULL, 0x000014d000040107ULL,
0x00000000000000ffULL, 0x0000153000040101ULL, 0x0000002000000006ULL, 0x000016a0003f0101ULL,
0x000176cc0000000eULL, 0x00001890003f0105ULL, 0x000176cc0000000eULL, 0x00002200003f0105ULL,
0x000176b0000000ffULL, 0x0000228000050107ULL, 0x000176b0000000ffULL, 0x000022e000050101ULL,
0x0001760800000009ULL, 0x00002300003f0101ULL, 0x0001760c00000009ULL, 0x000024d0003f0105ULL,
0x0001760c00000009ULL, 0x00002ab0003f0105ULL, 0x000176ac00000013ULL, 0x00002c80003f0105ULL,
0x000176ac00000013ULL, 0x00004e70003f0105ULL, 0x0000000000000012ULL, 0x00004ed0003f0101ULL,
0x000176880000006fULL, 0x00004f00003f0101ULL, 0x000000040000000aULL, 0x000050c0003f0105ULL,
0x000000040000000aULL, 0x000058e0003f0105ULL, 0x000176a800000010ULL, 0x00005970003f0107ULL,
0x000176a800000010ULL, 0x000059d0003f0101ULL, 0x0001762800000009ULL, 0x000059f0003f0101ULL,
0x0001762c00000009ULL, 0x00005bc0003f0105ULL, 0x0001762c00000009ULL, 0x000061a0003f0105ULL,
0x000176b40000003cULL, 0x00006370003f0105ULL, 0x000176b40000003cULL, 0x00008330003f0105ULL,
0x0000000000000016ULL, 0x00008390003f0101ULL, 0x0001769000000014ULL, 0x000083c0003f0101ULL,
0x000000040000000aULL, 0x00008580003f0105ULL, 0x000000040000000aULL, 0x00008d90003f0105ULL,
0x00000008000000ffULL, 0x00008e8000040107ULL, 0x000176b000000016ULL, 0x00008ee0003f0101ULL,
0x0001764800000009ULL, 0x00008f00003f0101ULL, 0x0001764c00000009ULL, 0x000090d0003f0105ULL,
0x0001764c00000009ULL, 0x000096a0003f0105ULL, 0x000176ac0000003cULL, 0x00009870003f0105ULL,
0x000176ac0000003cULL, 0x0000b890003f0105ULL, 0x0000000000000012ULL, 0x0000b8f0003f0101ULL,
0x0000000000000002ULL, 0x0000b920003f0101ULL, 0x000000040000000aULL, 0x0000bae0003f0105ULL,
0x000000040000000aULL, 0x0000c310003f0105ULL, 0x00000000000000ffULL, 0x0000c3f000040107ULL,
0x00000000000000ffULL, 0x0000c45000040101ULL, 0x000176680000000aULL, 0x0000c480003f0101ULL,
0x0001766c0000000aULL, 0x0000c650003f0105ULL, 0x0001766c0000000aULL, 0x0000cbe0003f0105ULL,
0x0000000c000000ffULL, 0x0000ce1000040105ULL, 0x0000000c000000ffULL, 0x0000ef6000040105ULL,
0x0000000000000004ULL, 0x0000efe0003f0101ULL, 0x000000000000000aULL, 0x00010190003f0101ULL,
0x00017600000000ffULL, 0x00011a90003f0101ULL, 0x00017604000000ffULL, 0x00011c60003f0105ULL,
0x00017604000000ffULL, 0x00011e90003f0105ULL, 0x00017600000000ffULL, 0x00011ec0003f0101ULL,
0x00017604000000ffULL, 0x00012080003f0105ULL, 0x00017604000000ffULL, 0x00015e30003f0105ULL,
0x000000000000007aULL, 0x00015ec0003f0101ULL, 0x000000040000007aULL, 0x00016090003f0105ULL,
0x000000040000007aULL, 0x000184b0003f0105ULL, 0x000000000000007bULL, 0x00018510003f0101ULL,
0x000000080000007bULL, 0x00018570003f0101ULL, 0x000000100000007bULL, 0x000185e0003f0101ULL,
0x000000180000007bULL, 0x00053803003f0101ULL, 0x0000fa7000201c04ULL, 0x0000fcb00000faa0ULL,
0x0000ffa00000fe10ULL, 0x000120e0000100a0ULL, 0x0000040100018630ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000002b4ULL, 0x0000001b00000002ULL, 0x000000000000021cULL, 0x0000001b00000002ULL,
0x0000000000000194ULL, 0x0000001b00000002ULL, 0x00000000000000ecULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000291ULL, 0x0000001b00000002ULL,
0x00000000000001f9ULL, 0x0000001b00000002ULL, 0x000000000000016eULL, 0x0000001b00000002ULL,
0x00000000000000c6ULL, 0x0000001b00000002ULL, 0x0000000000017700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff7c7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000087919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0xfffffff801017810ULL, 0x000fe20007ffe0ffULL, 0x00005a0000057ab9ULL, 0x000fe20000000800ULL,
0x00000000000a7919ULL, 0x000ee20000002300ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x00000000000b7919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003097a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a09ULL, 0x0000040003007624ULL, 0x000fca00078e027cULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109090810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09aa12ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000e620000209000ULL, 0x000000ff0900720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000309047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x00000008037b7227ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ee40000002200ULL, 0x000000ffff007224ULL, 0x000fc800078e0a7bULL,
0x0000000009007224ULL, 0x000fca00078e0208ULL, 0x000000090000720cULL, 0x000fda0003f66070ULL,
0x0000000100003824ULL, 0x000fe200078e0a09ULL, 0x000000017b7b3810ULL, 0x000fe20007ffe0ffULL,
0x000001000a027a24ULL, 0x008fe400078e0203ULL, 0x0000000000037919ULL, 0x000e620000002700ULL,
0x000000090000720cULL, 0x000fe20003f86070ULL, 0x00000000020d7a24ULL, 0x010fca00078e020bULL,
0x000000ff0d00720cULL, 0x040fe40003f45270ULL, 0x0000007f0d00780cULL, 0x040fe40003f04070ULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000030d00780cULL, 0x000fe40003f64070ULL,
0x000000017b7b4810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff7bd212ULL, 0x000fc400078e33ffULL,
0x000000010d00780cULL, 0x000fe20003f84070ULL, 0x3fffff80ff04a424ULL, 0x000fe200078e00ffULL,
0x00005a007b0f7a19ULL, 0x000fe200000006ffULL, 0x000000ffff007224ULL, 0x000fe400078e0a7bULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x00000000090c7224ULL, 0x000fe200078e0208ULL,
0x00000005ff007819ULL, 0x000fe2000001160bULL, 0xff317217ff028424ULL, 0x000fe200078e00ffULL,
0x01760004ff00a388ULL, 0x0005e20000000a00ULL, 0x000000100c717824ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL, 0x017400020d008388ULL, 0x0007e20000004800ULL,
0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL, 0x0000000471007c0cULL, 0x040fe2000bf03070ULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x00001fff0a0b7589ULL, 0x0009e200000e0000ULL,
0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff04b424ULL, 0x004fe200078e00ffULL,
0x00001fff00007589ULL, 0x000ea200000e0000ULL, 0x7fffff80ff05b424ULL, 0x000fe200078e00ffULL,
0x0000000471027c10ULL, 0x008fc4000fffe1ffULL, 0x0000000c01007387ULL, 0x000fe20000100800ULL,
0x00005a007c0a7a19ULL, 0x010fe400000006ffULL, 0x0000001002027817ULL, 0x000fe20003800000ULL,
0x017608060d009388ULL, 0x0007e60000008a00ULL, 0x000000ff027d7207ULL, 0x000fe20000000000ULL,
0x017688080d00b388ULL, 0x000fe20000008a00ULL, 0x0000580003027a24ULL, 0x002fe400078e02ffULL,
0x000000107d00780cULL, 0x000fe20003f05270ULL, 0x0176a8040d00b388ULL, 0x0005e20000008a00ULL,
0x0000000a02027224ULL, 0x000fc400078e020fULL, 0x3fffffc0ff06c424ULL, 0x008fe400078e00ffULL,
0x7fffffc0ff07c424ULL, 0x000fca00078e00ffULL, 0x0176c8060d00c388ULL, 0x000fe20000008a00ULL,
0x000000040b047824ULL, 0x004fc800078e0200ULL, 0x0000000204047824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff077819ULL, 0x002fca000001160cULL, 0x0000000104087824ULL, 0x000fc800078e0207ULL,
0x0000000171057824ULL, 0x000fca00078e0208ULL, 0x0000000405097c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe40000011605ULL, 0x000000047d057217ULL, 0x000fe20007800000ULL,
0x0000000102097824ULL, 0x000fe400078e0209ULL, 0x000000100c027824ULL, 0x000fe400078e00ffULL,
0x0000000a06097224ULL, 0x000fe400078e0209ULL, 0x0000000105067824ULL, 0x000fc400078e0a04ULL,
0x0000010009047825ULL, 0x000fe200078e00ffULL, 0x000000f002097812ULL, 0x000fe400078ec0ffULL,
0x000000060700720cULL, 0x000fe20003f06070ULL, 0x0000000108067824ULL, 0x000fe200078e020cULL,
0x0000000904097212ULL, 0x000fe200078efcffULL, 0x0000001008077824ULL, 0x000fc600078e00ffULL,
0x00005e0009047a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff007067812ULL, 0x000fe400078ee206ULL,
0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL, 0x0000001006077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x00000000000c7919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x000000040c067211ULL, 0x002fca00078fe0ffULL,
0x0000000171047824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x040fe400078e020cULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000404057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe40000011604ULL, 0xfffffff006077812ULL, 0x000fe200078ee207ULL,
0x0000000102057824ULL, 0x000fc400078e0205ULL, 0x000000100c027824ULL, 0x000fe400078e00ffULL,
0x0000000a04047224ULL, 0x000fe400078e0205ULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0x000000f002097812ULL, 0x000fe200078ec0ffULL, 0x0000010004047825ULL, 0x000fca00078e00ffULL,
0x0000000904047212ULL, 0x000fc800078efcffULL, 0x00005e0004047a10ULL, 0x000fc80007f1e0ffULL,
0x00005f0005057a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000077806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000700047300ULL, 0x000e7000000e0000ULL, 0x0000000700067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x000000ffff087224ULL, 0x004fc400078e0a06ULL,
0x00000004ff067424ULL, 0x000fc800078e00ffULL, 0x0000660003047625ULL, 0x000fcc00078e0006ULL,
0x01760408ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01760000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000804707981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f70787810ULL, 0x044fe40007ffe0ffULL,
0x000000ff70087810ULL, 0x002fc40007ffe0ffULL, 0x00000007ff787819ULL, 0x000fe40000011678ULL,
0x00000008ff737819ULL, 0x000fca0000011608ULL, 0x0000f63000008947ULL, 0x000fea0003800000ULL,
0x00000003ff667819ULL, 0x000fe20000011600ULL, 0x00000003ff097424ULL, 0x000fe400078e00ffULL,
0xffffffffff0d7424ULL, 0x000fe200078e00ffULL, 0x01ffffff66667812ULL, 0x000fc800078ec0ffULL,
0x000000786600720cULL, 0x000fda0003f06070ULL, 0x0000000203048824ULL, 0x000fe400078e00ffULL,
0x00006800ff058624ULL, 0x000fc800078e00ffULL, 0x0000680004058624ULL, 0x000fe200078e0205ULL,
0x0001768800047811ULL, 0x000fc600078e18ffULL, 0x0000000166058824ULL, 0x000fe200078e0205ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040904ff738cULL, 0x0003e20000000000ULL,
0x0000640005068625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000008060d8981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x000000807b727824ULL, 0x000fe200078e00ffULL, 0x00000001ff717819ULL, 0x000fe20000011600ULL,
0x0000000004ff7f8cULL, 0x0007e2000c80043fULL, 0x00000001007c7812ULL, 0x000fc600078ec0ffULL,
0x0000002071097824ULL, 0x002fca00078e00ffULL, 0x0000006072087812ULL, 0x000fe200078ef809ULL,
0x000059000d057a24ULL, 0x004fc800078e02ffULL, 0x0000008005177824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000000970047217ULL, 0x008fe20007800000ULL,
0x000000107c057824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fe4000001160cULL,
0x0000620017137a11ULL, 0x000fe200078838ffULL, 0x0000000104047824ULL, 0x000fe200078e0a09ULL,
0x00000004060a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x00000008060b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000504047217ULL, 0x000fe20007800000ULL,
0x0000000107097824ULL, 0x040fe200078e020cULL, 0x0000000c060f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x0000630017177a11ULL, 0x000fe200020f3cffULL,
0x0000000104047824ULL, 0x000fc400078e0a05ULL, 0x0000000105117824ULL, 0x040fe200078e020fULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x0000000105097824ULL, 0x000fe200078e020aULL,
0x000000040b00720cULL, 0x080fe20003f26070ULL, 0x00000001050b7824ULL, 0x000fe200078e020bULL,
0x000000040600720cULL, 0x080fe20003f66070ULL, 0x0000000109057824ULL, 0x040fe200078e020cULL,
0x000000040a00720cULL, 0x080fe20003f46070ULL, 0x0000000809107824ULL, 0x000fe200078e00ffULL,
0x000000040f00720cULL, 0x000fe20003f06070ULL, 0x0000000108077824ULL, 0x000fc400078e0207ULL,
0x000000010b067824ULL, 0x040fe200078e020cULL, 0xfffffff810107812ULL, 0x000fe200078ee205ULL,
0x000000080b157824ULL, 0x000fe400078e00ffULL, 0x0000008007047825ULL, 0x000fc600078e00ffULL,
0xfffffff815127812ULL, 0x000fe200078ee206ULL, 0x0000000108067824ULL, 0x000fe200078e0209ULL,
0x0000007004047812ULL, 0x000fe200078ef802ULL, 0x0000000108097824ULL, 0x040fe400078e020bULL,
0x00000001080a7824ULL, 0x000fe200078e0211ULL, 0x0000000413047210ULL, 0x000fe20007f9e0ffULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fc600078ef802ULL, 0x00000001110f7824ULL, 0x040fe200078e020cULL,
0x0000007008087812ULL, 0x100fe200078ef802ULL, 0x0000000811147824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001308087210ULL, 0x000fe40007fbe0ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20fULL, 0x0000000105057824ULL, 0x100fe200020e0617ULL,
0x000000700a027812ULL, 0x000fe200078ef802ULL, 0x0000000109097824ULL, 0x000fe200028e0617ULL,
0x00013000710f7811ULL, 0x000fc400078e68ffULL, 0x0000001306067210ULL, 0x080fe40007f9e0ffULL,
0x00000013020a7210ULL, 0x000fe20007fde0ffULL, 0x000000100e117824ULL, 0x100fe400078e020fULL,
0x0000001010137824ULL, 0x000fe400078e020fULL, 0x0000000107077824ULL, 0x000fe200020e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004117faeULL, 0x0003e2000d901c48ULL,
0x0000001012157824ULL, 0x100fe400078e020fULL, 0x00000010140f7824ULL, 0x000fe200078e020fULL,
0x0000000006137faeULL, 0x0003e2000d101c48ULL, 0x000000010b0b7824ULL, 0x000fc600030e0617ULL,
0x0000000008157faeULL, 0x0003e8000c901c48ULL, 0x000000000a0f7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000107c057824ULL, 0x008fe200078e00ffULL,
0x0000620017117a11ULL, 0x000fe400078038ffULL, 0x0001300071157811ULL, 0x000fe400078e68ffULL,
0x000000050c057211ULL, 0x000fc400078fe8ffULL, 0x0000630017177a11ULL, 0x000fe400000f3cffULL,
0x0000000405077810ULL, 0x040fe20007ffe0ffULL, 0x0000000105047824ULL, 0x140fe200078e020cULL,
0x0000000805097810ULL, 0x040fe20007ffe0ffULL, 0x00000008050b7824ULL, 0x000fe400078e00ffULL,
0x0000000107067824ULL, 0x100fe400078e020cULL, 0x00000001090a7824ULL, 0x000fe200078e020cULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee204ULL, 0x00000008070b7824ULL, 0x000fc400078e00ffULL,
0x0000000108047824ULL, 0x040fe400078e0205ULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b107812ULL, 0x000fe200078ee206ULL, 0x0000000108077824ULL, 0x000fe200078e0207ULL,
0x0000000c050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0xfffffff80f127812ULL, 0x000fc600078ee20aULL, 0x0000000108097824ULL, 0x000fe200078e0209ULL,
0x0000007004047812ULL, 0x000fe200078ef802ULL, 0x00000001080a7824ULL, 0x000fe400078e020bULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x0000000411047210ULL, 0x000fc60007f1e0ffULL,
0x000000010b0f7824ULL, 0x040fe200078e020cULL, 0x0000007006067812ULL, 0x000fe200078ef802ULL,
0x000000080b147824ULL, 0x000fe400078e00ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20fULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc600078ef802ULL, 0x0000000105057824ULL, 0x000fe200000e0617ULL,
0x000000700a027812ULL, 0x000fe200078ef802ULL, 0x000000100e0f7824ULL, 0x100fe200078e0215ULL,
0x0000000611067210ULL, 0x040fe20007f1e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0215ULL,
0x0000000811087210ULL, 0x040fe40007f3e0ffULL, 0x00000002110a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001010117824ULL, 0x000fe200078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e2000b901c48ULL, 0x0000000107077824ULL, 0x000fc400000e0617ULL,
0x0000000109097824ULL, 0x000fe400008e0617ULL, 0x0000001014157824ULL, 0x000fe200078e0215ULL,
0x0000000006117faeULL, 0x0003e2000b901c48ULL, 0x000000010b0b7824ULL, 0x000fc600010e0617ULL,
0x0000000008137faeULL, 0x0003e8000b901c48ULL, 0x000000000a157faeULL, 0x0003e4000b901c48ULL,
0x00000000710473c2ULL, 0x000ea200000e0000ULL, 0x000000ff7300720cULL, 0x000fe20003f05270ULL,
0x000000ffff0f7224ULL, 0x002fe200078e00ffULL, 0x000176a871067811ULL, 0x000fe200078e18ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000176a804047891ULL, 0x004fd2000f8e203fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff047f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000da4000008947ULL, 0x000fea0003800000ULL,
0x0000000203777824ULL, 0x000fe200078e00ffULL, 0x00000002ff797819ULL, 0x000fe20000011600ULL,
0x00006800ff047624ULL, 0x002fc400078e00ffULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x000000ffff097224ULL, 0x004fe400078e0007ULL, 0x0000680077777624ULL, 0x000fe400078e0204ULL,
0xff317217ff037424ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc400078e00ffULL, 0x0000000000047805ULL, 0x034fca0000015200ULL,
0x00000004000a7824ULL, 0x000fca00078e00ffULL, 0xfffffff80a0e7812ULL, 0x000fca00078ec0ffULL,
0x0176cc000e0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe40007804809ULL,
0x000176c80e0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000001004137210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e05ULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000001310107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176cc000e107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x000000010b107810ULL, 0x000fe20007ffe0ffULL, 0x000059000d0d7a24ULL, 0x000fc600078e02ffULL,
0xffffffe0040e7812ULL, 0x000fe200078ec0ffULL, 0x000000800d3d7824ULL, 0x000fe200078e00ffULL,
0x000000731000720cULL, 0x000fc60003f26070ULL, 0x000001000b0e7824ULL, 0x000fca00078e020eULL,
0x000000400e097810ULL, 0x000fc80007ffe0ffULL, 0x0000006009057812ULL, 0x000fca00078ec0ffULL,
0x0000000172127824ULL, 0x000fe200078e0205ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001004057812ULL, 0x000fe400078ec0ffULL, 0x0000000970047217ULL, 0x000fe40007800000ULL,
0x00000003ff0e7819ULL, 0x000fe4000001160cULL, 0x000062003d377a11ULL, 0x000fe200078a38ffULL,
0x0000000104047824ULL, 0x000fe200078e0a09ULL, 0x000000040e117810ULL, 0x040fe20007ffe0ffULL,
0x000000010e097824ULL, 0x040fe200078e0205ULL, 0x000000080e137810ULL, 0x000fc40007ffe0ffULL,
0x0000000504047217ULL, 0x000fe20007800000ULL, 0x00000001090d7824ULL, 0x000fe200078e020cULL,
0x000063003d3d7a11ULL, 0x000fe200028f3cffULL, 0x0000000809107824ULL, 0x000fe400078e00ffULL,
0x0000000104047824ULL, 0x000fc600078e0a05ULL, 0xfffffff8100d7812ULL, 0x000fe200078ee20dULL,
0x000000100c107824ULL, 0x000fe200078e00ffULL, 0x000000040e00720cULL, 0x0c0fe40003f86070ULL,
0x0000000c0e0e7810ULL, 0x000fe40007ffe0ffULL, 0x000000041100720cULL, 0x0c0fe20003f66070ULL,
0x0000000111117824ULL, 0x100fe200078e0205ULL, 0x000000041300720cULL, 0x0c0fe20003f46070ULL,
0x0000000113137824ULL, 0x100fe200078e0205ULL, 0x000000040e00720cULL, 0x040fe20003f06070ULL,
0x000000010e357824ULL, 0x000fe200078e0205ULL, 0x00000070103f7812ULL, 0x000fe200078ec0ffULL,
0x0000000111057824ULL, 0x000fc400078e020cULL, 0x0000000811147824ULL, 0x000fe400078e00ffULL,
0x0000000112047824ULL, 0x000fe400078e0209ULL, 0x00000001130e7824ULL, 0x000fe200078e020cULL,
0xfffffff814097812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000000112147824ULL, 0x000fe200078e0211ULL, 0x0000003f04047212ULL, 0x080fe200078efcffULL,
0x0000000813177824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000437047210ULL, 0x000fe40007fbe0ffULL, 0xfffffff817177812ULL, 0x000fe200078ee20eULL,
0x0000000112107824ULL, 0x000fe200078e0213ULL, 0x0000003f14147212ULL, 0x000fe200078efcffULL,
0x0000000112127824ULL, 0x000fc400078e0235ULL, 0x00000001350e7824ULL, 0x000fe400078e020cULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x0000003f10107212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee20eULL, 0x0000000105057824ULL, 0x100fe200028e063dULL,
0x0000003714147210ULL, 0x000fe40007fbe0ffULL, 0x0000003f12127212ULL, 0x000fe400078efcffULL,
0x00014000710e7811ULL, 0x000fe200078e68ffULL, 0x0000000115157824ULL, 0x000fe200028e063dULL,
0x0000003710107210ULL, 0x080fe40007fbe0ffULL, 0x0000003712127210ULL, 0x000fe20007fde0ffULL,
0x000000100d0d7824ULL, 0x000fc400078e020eULL, 0x0000001009097824ULL, 0x100fe400078e020eULL,
0x0000001017177824ULL, 0x100fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000e101c48ULL, 0x0000000111117824ULL, 0x100fe400028e063dULL,
0x0000001035357824ULL, 0x000fe200078e020eULL, 0x0000000014097faeULL, 0x0003e2000d901c48ULL,
0x0000000113137824ULL, 0x000fc600030e063dULL, 0x0000000010177faeULL, 0x0003e8000d101c48ULL,
0x0000000012357faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001004057812ULL, 0x000fe400078ec0ffULL, 0x000062003d357a11ULL, 0x040fe400078038ffULL,
0x000000050c057211ULL, 0x000fe400078fe8ffULL, 0x000063003d3d7a11ULL, 0x000fc400000f3cffULL,
0x00000004050d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105047824ULL, 0x140fe200078e020cULL,
0x0000000805117810ULL, 0x040fe20007ffe0ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0001400071377811ULL, 0x000fe200078e68ffULL, 0x000000010d0e7824ULL, 0x040fe400078e020cULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee204ULL,
0x0000000111107824ULL, 0x040fe400078e020cULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0xfffffff8130e7812ULL, 0x000fe200078ee20eULL, 0x000000100c137824ULL, 0x000fc400078e00ffULL,
0x0000000112047824ULL, 0x040fe200078e0205ULL, 0xfffffff815167812ULL, 0x000fe200078ee210ULL,
0x0000000112107824ULL, 0x040fe200078e020dULL, 0x0000007013177812ULL, 0x000fe200078ec0ffULL,
0x0000000112147824ULL, 0x000fe200078e0211ULL, 0x0000000c05137810ULL, 0x000fe20007ffe0ffULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000112127824ULL, 0x000fe200078e0213ULL,
0x0000001704047212ULL, 0x000fe200078efcffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000000435047210ULL, 0x000fe20007f1e0ffULL, 0x00000001130d7824ULL, 0x040fe200078e020cULL,
0x0000001710107212ULL, 0x000fe200078efcffULL, 0x0000000813347824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee20dULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001714147212ULL, 0x000fc600078efcffULL,
0x0000000105057824ULL, 0x000fe200000e063dULL, 0x0000001712127212ULL, 0x000fe200078efcffULL,
0x0000001009097824ULL, 0x100fe200078e0237ULL, 0x0000001035107210ULL, 0x040fe20007f1e0ffULL,
0x000000100e0d7824ULL, 0x100fe200078e0237ULL, 0x0000001435147210ULL, 0x040fe20007f5e0ffULL,
0x0000001016177824ULL, 0x000fe200078e0237ULL, 0x0000001235127210ULL, 0x000fe20007f7e0ffULL,
0x0000000111117824ULL, 0x100fe200000e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e2000b901c48ULL, 0x0000000115157824ULL, 0x000fc400010e063dULL,
0x0000001034357824ULL, 0x000fe200078e0237ULL, 0x00000000100d7faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x000fc600018e063dULL, 0x0000000014177faeULL, 0x0003e8000b901c48ULL,
0x0000000012357faeULL, 0x0003e4000b901c48ULL, 0x0000000800047824ULL, 0x002fe200078e00ffULL,
0x0000000166107810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0d7424ULL, 0x000fe400078e00ffULL,
0x00000000040573c2ULL, 0x000e6200000e0000ULL, 0x000000781000720cULL, 0x000fe40003f06070ULL,
0x0000000804057812ULL, 0x000fc400078ec0ffULL, 0xffffffe004097812ULL, 0x040fe400078ec0ffULL,
0x00000010040e7812ULL, 0x000fce00078ec0ffULL, 0x0000000177108824ULL, 0x000fe400078e0210ULL,
0x00000004ff118424ULL, 0x000fe200078e00ffULL, 0xfffffff005057892ULL, 0x002fc6000f8ec03fULL,
0x0000640010108625ULL, 0x000fe200078e0011ULL, 0x000176b005067890ULL, 0x000fe2000fffe03fULL,
0x0000000905097210ULL, 0x000fc60007ffe00eULL, 0x00000008100d8981ULL, 0x000328000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176b000ff167f8cULL, 0x000ea2000c800405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176080009147f8cULL, 0x000664000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x01760c0009057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012100e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e11ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011412ULL,
0x0000000e05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0612ULL,
0x0000000205057819ULL, 0x000fc8000000120eULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760c0009057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100c5e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff7a7819ULL, 0x000fe2000001160cULL,
0x0000002000057824ULL, 0x000fc600078e00ffULL, 0x000000705e5e7812ULL, 0x000fe400078ec0ffULL,
0xffffff8005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c7a7a7812ULL, 0x000fc800078ec0ffULL,
0x000000057a057210ULL, 0x000fca0007ffe05eULL, 0x0170000005107984ULL, 0x000e680000000800ULL,
0x0172000005117984ULL, 0x0006a20000000800ULL, 0x000000031000720bULL, 0x002fe20003f1d000ULL,
0x000160727f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c347812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff127424ULL, 0x000fe400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fd200078e0003ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000007900720cULL, 0x000fe40003f05270ULL,
0x000000031000720bULL, 0x000fe20003f54000ULL, 0x000160327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000057806ULL, 0x000fc400010e0100ULL, 0x0000008000138824ULL, 0x000fe200078e025eULL,
0x00000003100e7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991005127816ULL, 0x000fe200000000ffULL, 0x000000017a138824ULL, 0x000fca00078e0213ULL,
0x0174000e13008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000030e037221ULL, 0x002fe20000010100ULL,
0x000000ff05ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b03037820ULL, 0x000fcc0000410000ULL, 0x0000000300037308ULL, 0x000e640000000800ULL,
0x000000030f0f7220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe2000001160cULL, 0x00015f727f007947ULL, 0x000fea000b800000ULL,
0x00001f14033c7589ULL, 0x0002e400000e0000ULL, 0x0000003c18187220ULL, 0x08cfe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x000fc40000410000ULL, 0x0000003c20207220ULL, 0x080fe40000410000ULL,
0x0000003c21217220ULL, 0x080fe40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c28287220ULL, 0x080fe40000410000ULL,
0x0000003c29297220ULL, 0x000fc40000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x080fe40000410000ULL, 0x0000003c38387220ULL, 0x080fe40000410000ULL,
0x0000003c39397220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0005ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080c147811ULL, 0x002fe200078ff0ffULL, 0x00015e727f007947ULL, 0x000fea000b800000ULL,
0x00001f14033c7589ULL, 0x0002e400000e0000ULL, 0x0000003c1a1a7220ULL, 0x08cfe40000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c22227220ULL, 0x080fe40000410000ULL,
0x0000003c23237220ULL, 0x000fc40000410000ULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000003c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x080fe40000410000ULL, 0x0000003c3a3a7220ULL, 0x080fe40000410000ULL,
0x0000003c3b3b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff34ff7812ULL, 0x000fe20007806005ULL, 0x00000001ff127424ULL, 0x000fd800078e00ffULL,
0x8000000e10100221ULL, 0x000fe20000010000ULL, 0x00007610ff120816ULL, 0x000fc60000000012ULL,
0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL, 0x0000001000080308ULL, 0x000e640000000800ULL,
0x0000000811110220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f110f7221ULL, 0x004fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0xfffffff004137812ULL, 0x000fca00078ec0ffULL, 0x0176ac0013037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804802ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000410047210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e11ULL,
0x003d09000400780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400400780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011405ULL, 0x0000000403037211ULL, 0x000fca00078110ffULL,
0x000000ffff047224ULL, 0x000fca00000e0605ULL, 0x0000000203037819ULL, 0x000fc80000001204ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0013037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804802ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991012027816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0200720cULL, 0x000fda0003fc5270ULL,
0x0000016000006947ULL, 0x000fea0003800000ULL, 0x00000008ff02723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe4000001160cULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x00015a627f007947ULL, 0x000fea000b800000ULL, 0x00001f0302077589ULL, 0x0002a400000e0000ULL,
0x0000000803147810ULL, 0x000fe20007ffe0ffULL, 0x00015ab27f007947ULL, 0x000fea000b800000ULL,
0x00001f1402067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001003147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0002ULL,
0x00002e00003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0001676000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001803147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0002ULL, 0x00002e70003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x004fc400078e00ffULL,
0x000166f000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002006f7824ULL, 0x000fe200078e00ffULL, 0x000000070c027812ULL, 0x00afe200078ec0ffULL,
0x00000200004c7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000080c537812ULL, 0x000fe400078ec0ffULL, 0x000000046f037812ULL, 0x000fe400078ec0ffULL,
0x00000008024b7812ULL, 0x000fe400078ef80cULL, 0x000000030c047211ULL, 0x000fc400078fe0ffULL,
0xfffff8004c4c7812ULL, 0x000fe200078ec0ffULL, 0x000000084b107824ULL, 0x040fe400078e00ffULL,
0x000000014b5f7824ULL, 0x000fca00078e0204ULL, 0xfffffff810037812ULL, 0x000fca00078ee25fULL,
0x0000001003447824ULL, 0x000fc400078e024cULL, 0x0000000400057824ULL, 0x000fe200078e00ffULL,
0x00000004ff747819ULL, 0x000fe4000001160cULL, 0x0000000253037212ULL, 0x000fe400078efcffULL,
0x0000000405057812ULL, 0x000fe400078ec0ffULL, 0x00013000716c7811ULL, 0x000fe200078e68ffULL,
0x00000008036e7824ULL, 0x000fe200078e00ffULL, 0x0000001053537812ULL, 0x000fe200078efe02ULL,
0x0000000174047824ULL, 0x000fe200078e0205ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ec0ffULL,
0x0000000803057824ULL, 0x000fc400078e00ffULL, 0x00000001033c7824ULL, 0x004fe400078e0204ULL,
0x0000000853117824ULL, 0x000fe400078e00ffULL, 0x0000000104027824ULL, 0x000fe200078e0253ULL,
0xfffffff805057812ULL, 0x000fe200078ee23cULL, 0x0000000471747824ULL, 0x000fe200078e0274ULL,
0x000000023c037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff811047812ULL, 0x000fe200078ee202ULL,
0x0000001005347824ULL, 0x000fe200078e026cULL, 0xfffffff86e037812ULL, 0x000fc400078ee203ULL,
0x0000000202027810ULL, 0x000fe20007ffe0ffULL, 0x0000001004107824ULL, 0x100fe200078e026cULL,
0x0000000274747810ULL, 0x000fe20007ffe04bULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x00000010033c7824ULL, 0x000fc600078e026cULL, 0x000000001010783bULL, 0x000ea20000004200ULL,
0x00000018ff3d7819ULL, 0x002fe20000011435ULL, 0x00000034005a7306ULL, 0x000fe20000009400ULL,
0x00000018ff3e7819ULL, 0x000fe40000011436ULL, 0x00000018ff157819ULL, 0x000fe40000011434ULL,
0x00000018ff4e7819ULL, 0x004fe40000011410ULL, 0x00000018ff3f7819ULL, 0x000fe20000011437ULL,
0x0000003d00457306ULL, 0x000fe20000209400ULL, 0x00000018ff527819ULL, 0x000fce0000011411ULL,
0x0000003d00467306ULL, 0x000ff00000205400ULL, 0x0000003d00577306ULL, 0x0003f0000020d400ULL,
0x0000003400697306ULL, 0x000ea20000005400ULL, 0x00000100343d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003400507306ULL, 0x0002f0000000d400ULL,
0x0000003e00427306ULL, 0x000fe20000209400ULL, 0x0001000034347824ULL, 0x002fe200078e00ffULL,
0x000000695a00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003e00437306ULL, 0x000fee0000205400ULL, 0x0000000150503812ULL, 0x008fe200078efcffULL,
0x0000003e005c7306ULL, 0x0003f0000020d400ULL, 0x0000003d00557306ULL, 0x000fe20000209400ULL,
0x00000100353e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003d00687306ULL, 0x000e700000205400ULL, 0x0000003d004d7306ULL, 0x0004f0000020d400ULL,
0x0000001500547306ULL, 0x000fe20000209400ULL, 0x00000100363d7824ULL, 0x004fe200078e00ffULL,
0x000000685500720bULL, 0x002fcc0003fbd000ULL, 0x0000001500677306ULL, 0x000e6e0000205400ULL,
0x000000014d4d5812ULL, 0x008fe200078efcffULL, 0x0000001500567306ULL, 0x000ea6000020d400ULL,
0x000000504d50723eULL, 0x000fca00000010ffULL, 0x0000004e00497306ULL, 0x000fe20000209400ULL,
0x000000675400720bULL, 0x002fce0003f5d000ULL, 0x0000004e00477306ULL, 0x000fec0000205400ULL,
0x0000000156562812ULL, 0x004fe400078efcffULL, 0x0000004e00417306ULL, 0x000ff0000020d400ULL,
0x0000003400637306ULL, 0x000ff00000209400ULL, 0x0000003400647306ULL, 0x000e700000205400ULL,
0x00000034004f7306ULL, 0x0004f0000020d400ULL, 0x0000003f00147306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fc4000001143dULL, 0x000000646300720bULL, 0x002fca0003f9d000ULL,
0x0000003f00157306ULL, 0x000ff00000205400ULL, 0x0000003f005b7306ULL, 0x000fe2000020d400ULL,
0x000000014f4f4812ULL, 0x008fe400078efcffULL, 0x000000464500720bULL, 0x000fc40003f9d000ULL,
0x0000004f5656723eULL, 0x000fe200000010ffULL, 0x00010000104f7824ULL, 0x000fe400078e00ffULL,
0x0000003e00607306ULL, 0x000fe60000209400ULL, 0x00000018ff4f7819ULL, 0x000fca000001144fULL,
0x0000003e00617306ULL, 0x000e620000205400ULL, 0x0000000157574812ULL, 0x000fce00078efcffULL,
0x0000003e004e7306ULL, 0x0004f0000020d400ULL, 0x00000035005d7306ULL, 0x000fe20000009400ULL,
0x000000003c3c783bULL, 0x004ea20000004200ULL, 0x000000616000720bULL, 0x002fcc0003fbd000ULL,
0x00000035006a7306ULL, 0x000e6e0000005400ULL, 0x000000014e4e5812ULL, 0x008fe200078efcffULL,
0x0000003500517306ULL, 0x0006b0000000d400ULL, 0x0000003400587306ULL, 0x000fe20000209400ULL,
0x0001000035357824ULL, 0x008fe200078e00ffULL, 0x0000006a5d00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400597306ULL, 0x000e6e0000205400ULL,
0x0000000151510812ULL, 0x004fe200078efcffULL, 0x0000003400657306ULL, 0x0004e2000020d400ULL,
0x000000434200720bULL, 0x000fc40003f1d000ULL, 0x000000514e51723eULL, 0x000fca00000010ffULL,
0x00000036005a7306ULL, 0x000fe20000009400ULL, 0x0001000036347824ULL, 0x004fe200078e00ffULL,
0x000000595800720bULL, 0x002fe20003f5d000ULL, 0x0001000037587824ULL, 0x000fc600078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011434ULL, 0x00000036005d7306ULL, 0x000e620000005400ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x000000015c5c0812ULL, 0x000fc800078efcffULL,
0x0000000165652812ULL, 0x008fe200078efcffULL, 0x0000003600697306ULL, 0x0004f0000000d400ULL,
0x0000003500627306ULL, 0x000fe20000209400ULL, 0x000001003c367824ULL, 0x004fe200078e00ffULL,
0x0000005d5a00720bULL, 0x002fc40003fbd000ULL, 0x00000018ff5a7819ULL, 0x000fe4000001143cULL,
0x00000018ff647819ULL, 0x000fe40000011436ULL, 0x00000035006b7306ULL, 0x000e6e0000205400ULL,
0x0000000169695812ULL, 0x008fe200078efcffULL, 0x0000005200487306ULL, 0x000ff00000209400ULL,
0x00000052004a7306ULL, 0x000fe20000205400ULL, 0x0000006b6200720bULL, 0x002fce0003f7d000ULL,
0x0000005200407306ULL, 0x000ff0000020d400ULL, 0x0000003500527306ULL, 0x0002b0000020d400ULL,
0x0000006400367306ULL, 0x000fe20000209400ULL, 0x0000010037357824ULL, 0x002fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011435ULL, 0x00000064006d7306ULL, 0x000e620000205400ULL,
0x0000000152523812ULL, 0x004fe400078efcffULL, 0x000000151400720bULL, 0x000fe40003f7d000ULL,
0x000000525757723eULL, 0x000fc600000010ffULL, 0x0000006a00547306ULL, 0x000ff00000209400ULL,
0x0000006a00557306ULL, 0x000ea20000205400ULL, 0x0000006d3600720bULL, 0x002fe20003f5d000ULL,
0x000001003d367824ULL, 0x000fe200078e00ffULL, 0x000000015b5b3812ULL, 0x000fc400078efcffULL,
0x00000018ff6d7819ULL, 0x000fe40000011413ULL, 0x00000018ff437819ULL, 0x000fe20000011436ULL,
0x0000003700607306ULL, 0x000ff00000009400ULL, 0x00000037006b7306ULL, 0x000e620000005400ULL,
0x000000555400720bULL, 0x004fc40003f9d000ULL, 0x00000018ff557819ULL, 0x000fca0000011412ULL,
0x0000006800347306ULL, 0x000ff00000209400ULL, 0x0000006800357306ULL, 0x000fe20000205400ULL,
0x0000006b6000720bULL, 0x002fce0003fbd000ULL, 0x0000006800637306ULL, 0x000ff0000020d400ULL,
0x0000003700687306ULL, 0x000e70000000d400ULL, 0x0000006a00677306ULL, 0x000eb0000020d400ULL,
0x0000006400617306ULL, 0x000ee2000020d400ULL, 0x0000000168685812ULL, 0x002fc400078efcffULL,
0x000000353400720bULL, 0x000fca0003fbd000ULL, 0x0000003c00457306ULL, 0x000fe20000009400ULL,
0x0000000167674812ULL, 0x004fce00078efcffULL, 0x0000003c00467306ULL, 0x000e620000005400ULL,
0x0000000161612812ULL, 0x008fe400078efcffULL, 0x0000000163635812ULL, 0x000fca00078efcffULL,
0x0000004300547306ULL, 0x000ff00000209400ULL, 0x0000004300597306ULL, 0x000ea20000205400ULL,
0x000000464500720bULL, 0x002fce0003f9d000ULL, 0x0000003c00627306ULL, 0x0002f0000000d400ULL,
0x0000004300607306ULL, 0x000ee2000020d400ULL, 0x000000595400720bULL, 0x004fe20003f5d000ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fc4000001143dULL,
0x00000018ff547819ULL, 0x000fe4000001143eULL, 0x00000018ff6e7819ULL, 0x000fe2000001143cULL,
0x0000003d00147306ULL, 0x000fe20000009400ULL, 0x0000000162624812ULL, 0x008fe400078efcffULL,
0x00000069653c723eULL, 0x000fe200000010ffULL, 0x000100003d697824ULL, 0x000fc800078e00ffULL,
0x0000003d00157306ULL, 0x000e620000005400ULL, 0x0000000160602812ULL, 0x000fe400078efcffULL,
0x00000018ff697819ULL, 0x000fca0000011469ULL, 0x0000005a00367306ULL, 0x000ff00000209400ULL,
0x0000005a00357306ULL, 0x000ea20000205400ULL, 0x000000151400720bULL, 0x002fce0003f9d000ULL,
0x0000003d005d7306ULL, 0x0002e2000000d400ULL, 0x000000353600720bULL, 0x004fce0003f5d000ULL,
0x0000005900347306ULL, 0x000fe20000209400ULL, 0x00000068673d723eULL, 0x002fe400000010ffULL,
0x000000015d5d4812ULL, 0x008fca00078efcffULL, 0x0000005900157306ULL, 0x000e700000205400ULL,
0x0000005400147306ULL, 0x000ff00000209400ULL, 0x0000005400357306ULL, 0x000ea20000205400ULL,
0x000000153400720bULL, 0x002fce0003f9d000ULL, 0x00000058006b7306ULL, 0x000ff00000209400ULL,
0x0000005800647306ULL, 0x000e620000205400ULL, 0x000000351400720bULL, 0x004fe40003fbd000ULL,
0x011000004434783bULL, 0x000eaa0000000200ULL, 0x0000005500427306ULL, 0x000fe20000209400ULL,
0x000000646b00720bULL, 0x002fce0003f1d000ULL, 0x0000005500437306ULL, 0x000fe20000205400ULL,
0x00000018ff6b7819ULL, 0x000fce000001143fULL, 0x0000005800647306ULL, 0x000e70000020d400ULL,
0x0000006b006a7306ULL, 0x000ff00000209400ULL, 0x0000006b004d7306ULL, 0x000ee20000205400ULL,
0x0000000164640812ULL, 0x002fe200078efcffULL, 0x000000073434e231ULL, 0x004fc400003400ffULL,
0x000000073636e231ULL, 0x000fe400003400ffULL, 0x000000063535e231ULL, 0x080fe400003400ffULL,
0x0000005500157306ULL, 0x000fe2000020d400ULL, 0x000000063737e231ULL, 0x000fce00003400ffULL,
0x0000006b00557306ULL, 0x000e62000020d400ULL, 0x0000004d6a00720bULL, 0x008fe20003f1d000ULL,
0x0000003c3420723cULL, 0x040bec0000041820ULL, 0x0000006e006a7306ULL, 0x000fe20000209400ULL,
0x000001003e3c7824ULL, 0x020fe200078e00ffULL, 0x00000056341c723cULL, 0x000be2000004181cULL,
0x000000645b3d723eULL, 0x000fca00000010ffULL, 0x0000006e006b7306ULL, 0x000ea20000205400ULL,
0x0000000155550812ULL, 0x002fe200078efcffULL, 0x000000503418723cULL, 0x000f6c0000041818ULL,
0x0000006900577306ULL, 0x020fe20000209400ULL, 0x0000006b6a00720bULL, 0x004fce0003f7d000ULL,
0x0000006900677306ULL, 0x000ff0000020d400ULL, 0x00000069006a7306ULL, 0x0003f00000205400ULL,
0x0000006e00657306ULL, 0x000ea2000020d400ULL, 0x00000018ff697819ULL, 0x002fc4000001143cULL,
0x000000635c3c723eULL, 0x000fca00000010ffULL, 0x0000005900597306ULL, 0x000e64000020d400ULL,
0x0000003c3424723cULL, 0x000bec0000041824ULL, 0x0000003e00687306ULL, 0x000fe20000009400ULL,
0x000001003f3d7824ULL, 0x020fe200078e00ffULL, 0x0000000165653812ULL, 0x004fc400078efcffULL,
0x0000006a5700720bULL, 0x000fe40003f7d000ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003e00637306ULL, 0x000ea20000005400ULL, 0x0000000159594812ULL, 0x002fce00078efcffULL,
0x0000003d003c7306ULL, 0x000fe20000209400ULL, 0x0000000167673812ULL, 0x000fce00078efcffULL,
0x0000003d006b7306ULL, 0x000e620000205400ULL, 0x000000636800720bULL, 0x004fce0003f7d000ULL,
0x0000005a005a7306ULL, 0x000eb0000020d400ULL, 0x00000069005c7306ULL, 0x000fe20000209400ULL,
0x0000006b3c00720bULL, 0x002fe20003f9d000ULL, 0x000100003e3c7824ULL, 0x000fcc00078e00ffULL,
0x0000006900577306ULL, 0x000e620000205400ULL, 0x000000015a5a2812ULL, 0x004fce00078efcffULL,
0x0000003e00637306ULL, 0x0004e2000000d400ULL, 0x000000575c00720bULL, 0x002fce0003f5d000ULL,
0x0000003f00687306ULL, 0x000fe20000009400ULL, 0x00000018ff3e7819ULL, 0x004fe2000001143cULL,
0x0000010011577824ULL, 0x000fe200078e00ffULL, 0x00000062613c723eULL, 0x000fc800000010ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011457ULL, 0x0000003f00627306ULL, 0x000e620000005400ULL,
0x0000000163633812ULL, 0x008fce00078efcffULL, 0x0000003d00617306ULL, 0x0004f0000020d400ULL,
0x0000006a005b7306ULL, 0x000fe20000209400ULL, 0x0000005d603d723eULL, 0x004fe400000010ffULL,
0x000000626800720bULL, 0x002fca0003f7d000ULL, 0x0000003c3428723cULL, 0x000b620000041828ULL,
0x0000006a005c7306ULL, 0x000fe20000205400ULL, 0x0000000161614812ULL, 0x008fca00078efcffULL,
0x000000655a3c723eULL, 0x020fe200000010ffULL, 0x000100003f5a7824ULL, 0x000fe200078e00ffULL,
0x0000006a00577306ULL, 0x000fe2000020d400ULL, 0x00000067593d723eULL, 0x000fc600000010ffULL,
0x00000018ff657819ULL, 0x000fc8000001145aULL, 0x0000006900647306ULL, 0x000e62000020d400ULL,
0x0000003c342c723cULL, 0x000b6e000004182cULL, 0x0000003e00697306ULL, 0x000ff00000209400ULL,
0x0000003e006a7306ULL, 0x000ea20000205400ULL, 0x0000000164642812ULL, 0x002fc800078efcffULL,
0x00000063643c723eULL, 0x020fc600000010ffULL, 0x0000003f00607306ULL, 0x0002f0000000d400ULL,
0x0000006500627306ULL, 0x000fe20000209400ULL, 0x0000006a6900720bULL, 0x004fe20003f5d000ULL,
0x00010000113f7824ULL, 0x002fc400078e00ffULL, 0x00000100126a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000006500677306ULL, 0x000e620000205400ULL,
0x0000000160603812ULL, 0x008fe400078efcffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000060613d723eULL, 0x000fc600000010ffULL, 0x0000003e003e7306ULL, 0x000ea8000020d400ULL,
0x0000003c3430723cULL, 0x000b680000041830ULL, 0x0000005400547306ULL, 0x000ee2000020d400ULL,
0x000000676200720bULL, 0x002fce0003f7d000ULL, 0x00000011005d7306ULL, 0x000fe20000009400ULL,
0x000000013e3e2812ULL, 0x004fce00078efcffULL, 0x0000001100597306ULL, 0x000e620000005400ULL,
0x0000000154545812ULL, 0x008fc800078efcffULL, 0x0000003e5454723eULL, 0x000fc600000010ffULL,
0x00000011005a7306ULL, 0x0004f0000000d400ULL, 0x0000006500647306ULL, 0x000ee2000020d400ULL,
0x0000000853117824ULL, 0x004fe200078e00ffULL, 0x000000595d00720bULL, 0x002fc80003f9d000ULL,
0xfffffff811027812ULL, 0x000fe200078ee202ULL, 0x0000010013117824ULL, 0x000fe200078e00ffULL,
0x0000003f00617306ULL, 0x000fe60000209400ULL, 0x00000010023c7824ULL, 0x020fc800078e026cULL,
0x000000015a5a4812ULL, 0x008fe200078efcffULL, 0x0000003f00607306ULL, 0x000e620000205400ULL,
0x0000000164643812ULL, 0x000fc800078efcffULL, 0x000000645555723eULL, 0x000fe400000010ffULL,
0x00000018ff647819ULL, 0x000fe20000011411ULL, 0x0000003f00537306ULL, 0x0004e8000020d400ULL,
0x000000543438723cULL, 0x000b680000041838ULL, 0x0000006d00457306ULL, 0x000fe20000209400ULL,
0x000000003c3c783bULL, 0x004ea20000004200ULL, 0x000000606100720bULL, 0x002fe20003f9d000ULL,
0x0001000012377824ULL, 0x020fca00078e00ffULL, 0x0000006d00467306ULL, 0x000e620000205400ULL,
0x00000018ff377819ULL, 0x000fcc0000011437ULL, 0x0000000153534812ULL, 0x008fe200078efcffULL,
0x0000006d00147306ULL, 0x0006b0000020d400ULL, 0x0000001300117306ULL, 0x000fe20000009400ULL,
0x00000100106d7824ULL, 0x008fe200078e00ffULL, 0x000000464500720bULL, 0x002fc80003f9d000ULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000001300347306ULL, 0x000e6e0000005400ULL,
0x0000000114144812ULL, 0x004fe200078efcffULL, 0x0000006d00517306ULL, 0x000ff00000209400ULL,
0x0000006d00527306ULL, 0x000ea20000205400ULL, 0x000000341100720bULL, 0x002fe20003f1d000ULL,
0x000000084b117824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc8000001143dULL,
0xfffffff811117812ULL, 0x000fe200078ee274ULL, 0x00000010004e7306ULL, 0x000fe80000009400ULL,
0x0000001011117824ULL, 0x000fe400078e024cULL, 0x000001003c4c7824ULL, 0x000fe400078e00ffULL,
0x0000001000507306ULL, 0x000e620000005400ULL, 0x000000525100720bULL, 0x004fc40003f7d000ULL,
0x00000018ff4c7819ULL, 0x000fca000001144cULL, 0x00000010004d7306ULL, 0x000eb0000000d400ULL,
0x0000006d00107306ULL, 0x000ee2000020d400ULL, 0x000000504e00720bULL, 0x002fe20003fbd000ULL,
0x00010000134e7824ULL, 0x000fcc00078e00ffULL, 0x0000001200357306ULL, 0x000fec0000009400ULL,
0x000000014d4d5812ULL, 0x004fe400078efcffULL, 0x0000001200367306ULL, 0x000e620000005400ULL,
0x0000000110103812ULL, 0x008fe400078efcffULL, 0x000000474900720bULL, 0x000fca0003f7d000ULL,
0x0000004f00587306ULL, 0x000ff00000209400ULL, 0x0000004f00567306ULL, 0x000ea20000205400ULL,
0x000000363500720bULL, 0x002fe40003f5d000ULL, 0x0000000141413812ULL, 0x000fc400078efcffULL,
0x0000005c5b00720bULL, 0x000fc60003f7d000ULL, 0x0000006a00627306ULL, 0x000ff00000209400ULL,
0x0000006a00637306ULL, 0x000fe20000205400ULL, 0x000000565800720bULL, 0x004fe40003fbd000ULL,
0x00000018ff567819ULL, 0x000fc4000001143eULL, 0x0000000157573812ULL, 0x000fe400078efcffULL,
0x000000434200720bULL, 0x000fe20003f7d000ULL, 0x0000006a00677306ULL, 0x000fe2000020d400ULL,
0x00000018ff587819ULL, 0x000fe2000001143fULL, 0x000001003d427824ULL, 0x000fe200078e00ffULL,
0x0000005a5757723eULL, 0x000fca00000010ffULL, 0x0000006400687306ULL, 0x000fe80000209400ULL,
0x0000000115153812ULL, 0x000fc800078efcffULL, 0x0000006400697306ULL, 0x000ff00000205400ULL,
0x0000006400547306ULL, 0x000ff0000020d400ULL, 0x00000037006a7306ULL, 0x000ff00000209400ULL,
0x00000037006b7306ULL, 0x000ff00000205400ULL, 0x0000003700647306ULL, 0x000ff0000020d400ULL,
0x0000003400517306ULL, 0x000ff00000209400ULL, 0x0000003400597306ULL, 0x000ff00000205400ULL,
0x0000003400477306ULL, 0x0003f0000020d400ULL, 0x0000004f004f7306ULL, 0x000ea2000020d400ULL,
0x011000001134783bULL, 0x002e6e0000000200ULL, 0x0000001300557306ULL, 0x0006e2000000d400ULL,
0x000000014f4f5812ULL, 0x004fce00078efcffULL, 0x0000001200657306ULL, 0x000462000000d400ULL,
0x0000004a4800720bULL, 0x000fe40003fbd000ULL, 0x00000018ff137819ULL, 0x008fe4000001143cULL,
0x0000000155550812ULL, 0x000fc600078efcffULL, 0x0000001300527306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x004fca000001144eULL, 0x0000000140405812ULL, 0x000fe400078efcffULL,
0x00000013006e7306ULL, 0x000ea20000205400ULL, 0x000000696800720bULL, 0x000fe40003fbd000ULL,
0x0000000165652812ULL, 0x002fe400078efcffULL, 0x000000534053723eULL, 0x000fc600000010ffULL,
0x00000013004e7306ULL, 0x000e62000020d400ULL, 0x000000073434e231ULL, 0x080fe400003400ffULL,
0x000000073636e231ULL, 0x000fe400003400ffULL, 0x000000063535e231ULL, 0x080fe200003400ffULL,
0x0000000154545812ULL, 0x000fe200078efcffULL, 0x000000063737e231ULL, 0x000fe200003400ffULL,
0x0000005600497306ULL, 0x000fe20000209400ULL, 0x000000636200720bULL, 0x000fe40003fdd000ULL,
0x0000006b6a00720bULL, 0x000fca0003fbd000ULL, 0x00000056004b7306ULL, 0x000eec0000205400ULL,
0x0000000167676812ULL, 0x000fe400078efcffULL, 0x0000005600137306ULL, 0x000fe2000020d400ULL,
0x0000000164645812ULL, 0x000fe400078efcffULL, 0x0000006e5200720bULL, 0x004fc40003fbd000ULL,
0x000000641564723eULL, 0x000fc600000010ffULL, 0x0000004c00567306ULL, 0x000ff00000209400ULL,
0x0000004c00747306ULL, 0x000ea20000205400ULL, 0x000000014e4e5812ULL, 0x002fe400078efcffULL,
0x0000004b4900720bULL, 0x008fca0003fbd000ULL, 0x0000004c00437306ULL, 0x000e70000020d400ULL,
0x0000003c004c7306ULL, 0x000fe20000009400ULL, 0x000000745600720bULL, 0x004fe40003f7d000ULL,
0x0000004d1056723eULL, 0x000fc400000010ffULL, 0x0000000113135812ULL, 0x000fc600078efcffULL,
0x0000003c005b7306ULL, 0x000ea40000005400ULL, 0x000000563418723cULL, 0x000b680000041818ULL,
0x0000000143433812ULL, 0x002fe400078efcffULL, 0x00000012006d7306ULL, 0x000fe20000209400ULL,
0x000100003e577824ULL, 0x020fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000012005d7306ULL, 0x000e620000205400ULL, 0x0000005b4c00720bULL, 0x004fe20003fdd000ULL,
0x000100003c4c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001144cULL,
0x0000003d00467306ULL, 0x000ff00000009400ULL, 0x0000003d00617306ULL, 0x000ea20000005400ULL,
0x0000005d6d00720bULL, 0x002fce0003f1d000ULL, 0x0000001200507306ULL, 0x000e70000020d400ULL,
0x0000005800487306ULL, 0x000fe20000209400ULL, 0x000000614600720bULL, 0x004fe20003f5d000ULL,
0x000100003d467824ULL, 0x000fca00078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011446ULL,
0x00000058004a7306ULL, 0x000fe20000205400ULL, 0x0000000150500812ULL, 0x002fce00078efcffULL,
0x0000005800127306ULL, 0x0003f0000020d400ULL, 0x0000005b00637306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x002fce0000011442ULL, 0x0000005800757306ULL, 0x000ff00000209400ULL,
0x0000005800767306ULL, 0x000e700000205400ULL, 0x0000005b00687306ULL, 0x000eb00000205400ULL,
0x0000003e00527306ULL, 0x000fe20000009400ULL, 0x000000767500720bULL, 0x002fce0003f1d000ULL,
0x0000003e004d7306ULL, 0x000e620000005400ULL, 0x000000686300720bULL, 0x004fce0003f9d000ULL,
0x0000005800427306ULL, 0x000eb0000020d400ULL, 0x0000003c00587306ULL, 0x0006a2000000d400ULL,
0x0000004d5200720bULL, 0x002fe40003f7d000ULL, 0x0000004f4152723eULL, 0x000fe200000010ffULL,
0x000100003f4f7824ULL, 0x000fc800078e00ffULL, 0x0000003d00457306ULL, 0x000e62000000d400ULL,
0x000001003e3c7824ULL, 0x008fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe2000001144fULL,
0x00000052341c723cULL, 0x000b62000004181cULL, 0x0000000142420812ULL, 0x004fe400078efcffULL,
0x00000018ff697819ULL, 0x000fe2000001143cULL, 0x000001003f3c7824ULL, 0x000fe200078e00ffULL,
0x0000005b004c7306ULL, 0x000ea2000020d400ULL, 0x0000000158586812ULL, 0x000fc600078efcffULL,
0x00000018ff6a7819ULL, 0x000fe4000001143cULL, 0x000000584358723eULL, 0x000fe400000010ffULL,
0x0000005c00617306ULL, 0x000fe20000209400ULL, 0x0000000145452812ULL, 0x002fe400078efcffULL,
0x000000595100720bULL, 0x000fe40003f5d000ULL, 0x000000454259723eULL, 0x000fc600000010ffULL,
0x0000005c00627306ULL, 0x000e620000205400ULL, 0x000000014c4c4812ULL, 0x004fc600078efcffULL,
0x000000583428723cULL, 0x000b620000041828ULL, 0x0000004c4e4e723eULL, 0x000fc600000010ffULL,
0x0000006900607306ULL, 0x000fe20000209400ULL, 0x0000000147472812ULL, 0x000fce00078efcffULL,
0x00000069005d7306ULL, 0x000ea20000205400ULL, 0x000000626100720bULL, 0x002fce0003f1d000ULL,
0x0000005c003d7306ULL, 0x000e70000020d400ULL, 0x0000006900467306ULL, 0x000ee2000020d400ULL,
0x0000005d6000720bULL, 0x004fce0003f9d000ULL, 0x0000006a005c7306ULL, 0x000fe20000209400ULL,
0x000000013d3d0812ULL, 0x002fe400078efcffULL, 0x0000004a4800720bULL, 0x000fca0003f1d000ULL,
0x0000006a005b7306ULL, 0x000e620000205400ULL, 0x0000000146464812ULL, 0x008fce00078efcffULL,
0x0000003f005a7306ULL, 0x000fe20000009400ULL, 0x0000000112120812ULL, 0x000fce00078efcffULL,
0x0000003f00637306ULL, 0x000ea20000005400ULL, 0x0000005b5c00720bULL, 0x002fce0003f5d000ULL,
0x0000003e004d7306ULL, 0x0002f0000000d400ULL, 0x0000005700567306ULL, 0x000fe20000209400ULL,
0x00000065673e723eULL, 0x002fe400000010ffULL, 0x000000501465723eULL, 0x000fc400000010ffULL,
0x000000635a00720bULL, 0x004fc60003fdd000ULL, 0x0000005700417306ULL, 0x000e620000205400ULL,
0x000000014d4d3812ULL, 0x008fe200078efcffULL, 0x000000643424723cULL, 0x000b660000041824ULL,
0x0000004d4646723eULL, 0x000fc600000010ffULL, 0x00000040004f7306ULL, 0x000ff00000209400ULL,
0x0000004000527306ULL, 0x020ea20000205400ULL, 0x000000415600720bULL, 0x002fce0003f9d000ULL,
0x0000006a003c7306ULL, 0x000e70000020d400ULL, 0x0000003f00107306ULL, 0x0006e2000000d400ULL,
0x000000524f00720bULL, 0x004fe40003f7d000ULL, 0x0000003d474f723eULL, 0x000fca00000010ffULL,
0x0000005700147306ULL, 0x000ea2000020d400ULL, 0x000000013c3c2812ULL, 0x002fe200078efcffULL,
0x0000004e342c723cULL, 0x000b62000004182cULL, 0x00000055543f723eULL, 0x008fca00000010ffULL,
0x0000004000157306ULL, 0x000e62000020d400ULL, 0x0000000110106812ULL, 0x000fe200078efcffULL,
0x0000003e3420723cULL, 0x000b660000041820ULL, 0x000000103c47723eULL, 0x000fe400000010ffULL,
0x0000000114144812ULL, 0x004fc800078efcffULL, 0x000000141314723eULL, 0x000fe200000010ffULL,
0x000000463430723cULL, 0x000b620000041830ULL, 0x0000000115153812ULL, 0x002fc800078efcffULL,
0x000000151215723eULL, 0x000fe400000010ffULL, 0x000176c871127811ULL, 0x000fca00078e18ffULL,
0x000000143434723cULL, 0x000b620000041838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017688006fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff107224ULL, 0x000fc600078e00ffULL, 0x0000000000147805ULL, 0x020fc80000015200ULL,
0x000004000a397984ULL, 0x000ee40000000800ULL, 0x8000000039ff7812ULL, 0x00afe40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038143b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e15ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000107824ULL, 0x000fe400078e00ffULL,
0x000059000d0d7a24ULL, 0x010fc600078e02ffULL, 0xffffffe010127812ULL, 0x000fe200078ec0ffULL,
0x000000800d0d7824ULL, 0x000fc800078e00ffULL, 0x000001000b127824ULL, 0x000fca00078e0212ULL,
0x0000008012157810ULL, 0x000fc80007ffe0ffULL, 0x0000006015137812ULL, 0x000fca00078ec0ffULL,
0x00000001723a7824ULL, 0x000fe200078e0213ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000001010137812ULL, 0x000fe400078ec0ffULL, 0x0000001570107217ULL, 0x000fe40007800000ULL,
0x00000003ff127819ULL, 0x000fe4000001160cULL, 0x000062000d3d7a11ULL, 0x000fe200078a38ffULL,
0x0000000110107824ULL, 0x000fe200078e0a15ULL, 0x0000000412387810ULL, 0x040fe20007ffe0ffULL,
0x0000000112157824ULL, 0x040fe200078e0213ULL, 0x0000000c123b7810ULL, 0x000fc40007ffe0ffULL,
0x0000001013107217ULL, 0x000fe20007800000ULL, 0x0000000115147824ULL, 0x000fe200078e020cULL,
0x000063000d3f7a11ULL, 0x000fe200028f3cffULL, 0x0000000815417824ULL, 0x000fe400078e00ffULL,
0x0000000110107824ULL, 0x100fe400078e0a13ULL, 0x000000013b477824ULL, 0x000fe200078e0213ULL,
0xfffffff841417812ULL, 0x000fe400078ee214ULL, 0x0000000812147810ULL, 0x000fc40007ffe0ffULL,
0x000000101200720cULL, 0x080fe20003f86070ULL, 0x0000000115127824ULL, 0x000fe200078e023aULL,
0x000000101400720cULL, 0x080fe20003f46070ULL, 0x0000000138157824ULL, 0x140fe200078e0213ULL,
0x000000103800720cULL, 0x080fe20003f66070ULL, 0x0000000114397824ULL, 0x000fe200078e0213ULL,
0x000000103b00720cULL, 0x000fe20003f06070ULL, 0x0000000115137824ULL, 0x040fe400078e020cULL,
0x0000000815147824ULL, 0x000fe400078e00ffULL, 0x0000000139387824ULL, 0x000fc400078e023aULL,
0x0000000139107824ULL, 0x000fe200078e020cULL, 0xfffffff814437812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000000115147824ULL, 0x100fe200078e023aULL,
0x0000005e12127212ULL, 0x000fe200078efcffULL, 0x00000001473a7824ULL, 0x000fe400078e023aULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000123d127210ULL, 0x000fc60007fbe0ffULL,
0x0000000839457824ULL, 0x000fe200078e00ffULL, 0x0000005e14147212ULL, 0x000fe200078efcffULL,
0x0000008038387825ULL, 0x000fc600078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee210ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005e38387212ULL, 0x000fc600078efcffULL,
0x0000000113137824ULL, 0x100fe200028e063fULL, 0x0000003d14147210ULL, 0x080fe20007fbe0ffULL,
0x0000000147107824ULL, 0x040fe200078e020cULL, 0x0000005e3a3a7212ULL, 0x000fe200078efcffULL,
0x0000000847477824ULL, 0x000fe400078e00ffULL, 0x0000000115157824ULL, 0x100fe200028e063fULL,
0x0000003d38387210ULL, 0x080fe40007fbe0ffULL, 0x0000003d3a3a7210ULL, 0x000fe20007fde0ffULL,
0x00000010413d7824ULL, 0x000fe200078e026cULL, 0xfffffff847477812ULL, 0x000fe200078ee210ULL,
0x0000000139397824ULL, 0x000fc400028e063fULL, 0x000000013b3b7824ULL, 0x000fe200030e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123d7faeULL, 0x0003e2000e101c48ULL,
0x00000010433f7824ULL, 0x100fe400078e026cULL, 0x0000001045417824ULL, 0x100fe400078e026cULL,
0x0000001047437824ULL, 0x000fe200078e026cULL, 0x00000000143f7faeULL, 0x0003e8000d901c48ULL,
0x0000000038417faeULL, 0x0003e8000d101c48ULL, 0x000000003a437faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001010137812ULL, 0x000fe400078ec0ffULL,
0x000062000d417a11ULL, 0x000fc400078038ffULL, 0x000000130c137211ULL, 0x000fe400078fe8ffULL,
0x000063000d437a11ULL, 0x000fe400000f3cffULL, 0x0000000413157810ULL, 0x040fe20007ffe0ffULL,
0x0000000113107824ULL, 0x040fe200078e020cULL, 0x0000000813397810ULL, 0x040fe20007ffe0ffULL,
0x00000008133f7824ULL, 0x040fe400078e00ffULL, 0x0000000113127824ULL, 0x140fe200078e023aULL,
0x0000000c13137810ULL, 0x000fe20007ffe0ffULL, 0x00000001153c7824ULL, 0x000fe200078e023aULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee210ULL, 0x0000000115107824ULL, 0x000fc400078e020cULL,
0x0000000815457824ULL, 0x000fe400078e00ffULL, 0x0000000139387824ULL, 0x100fe400078e023aULL,
0x00000001133a7824ULL, 0x000fe200078e023aULL, 0xfffffff845457812ULL, 0x000fe200078ee210ULL,
0x0000000139147824ULL, 0x140fe400078e020cULL, 0x0000000839477824ULL, 0x000fe400078e00ffULL,
0x0000000113157824ULL, 0x000fc400078e020cULL, 0x00000008133e7824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee214ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff83e497812ULL, 0x000fe200078ee215ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000005e12147212ULL, 0x000fc600078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000005e3c127212ULL, 0x000fe400078efcffULL, 0x0000001441147210ULL, 0x040fe20007f1e0ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005e38387212ULL, 0x000fe400078efcffULL,
0x0000001241127210ULL, 0x000fe20007f5e0ffULL, 0x0000000113157824ULL, 0x100fe200000e0643ULL,
0x0000005e3a3a7212ULL, 0x000fe400078efcffULL, 0x0000003841387210ULL, 0x000fe20007f1e0ffULL,
0x000000013d137824ULL, 0x000fe200010e0643ULL, 0x0000003a413a7210ULL, 0x000fe20007f7e0ffULL,
0x000000103f3d7824ULL, 0x000fc400078e026cULL, 0x00000010453f7824ULL, 0x100fe400078e026cULL,
0x0000000139397824ULL, 0x100fe200000e0643ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c48ULL, 0x000000013b3b7824ULL, 0x000fe400018e0643ULL,
0x0000001047417824ULL, 0x100fe200078e026cULL, 0x00000000123f7faeULL, 0x0003e2000b901c48ULL,
0x0000001049437824ULL, 0x000fc600078e026cULL, 0x0000000038417faeULL, 0x0003e8000b901c48ULL,
0x000000003a437faeULL, 0x0003e4000b901c48ULL, 0x0000000800107824ULL, 0x000fca00078e00ffULL,
0xfffffff010107812ULL, 0x000fc800078ec0ffULL, 0x00000000100573c2ULL, 0x000ee200000e0000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000176a805057890ULL, 0x008fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80010127f8cULL, 0x0002e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176280009387f8cULL, 0x0002a4000c80043fULL,
0x0000000000147805ULL, 0x000fc40000015200ULL, 0x01762c00093b7984ULL, 0x000f240000000800ULL,
0x800000003bff7812ULL, 0x014fe40007804839ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a143d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e15ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x002fc8000001143bULL, 0x0000003d10107211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x0000000210107819ULL, 0x000fc8000000123bULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01762c00093b7984ULL, 0x000ea40000000800ULL, 0x800000003bff7812ULL, 0x004fe40007804839ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000107824ULL, 0x002fca00078e00ffULL,
0xffffff8010157812ULL, 0x000fc800078ec0ffULL, 0x000000805e157810ULL, 0x000fca0007ffe015ULL,
0x000000017a157824ULL, 0x000fca00078e0215ULL, 0x0170000015397984ULL, 0x000e680000000800ULL,
0x0172000015107984ULL, 0x0004e20000000800ULL, 0x0000000e3900720bULL, 0x002fe20003f1d000ULL,
0x00012c127f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff3c3b7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3a7424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000179157810ULL, 0x000fe40007ffe0ffULL, 0x0000000e3900720bULL, 0x000fe40003f54000ULL,
0x000000001500720cULL, 0x000fe20003f05270ULL, 0x00012bd27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000387806ULL, 0x000fc400010e0100ULL, 0x0000008000158824ULL, 0x000fe200078e025eULL,
0x0000000e39148209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000017a3d8824ULL, 0x000fe200078e0215ULL, 0x0000991038157816ULL, 0x000fc800000000ffULL,
0x017400143d008388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000e39157209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff38ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000e15147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x00000014003a7308ULL, 0x000e640000000800ULL, 0x0000003a0f0f7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe2000001160cULL,
0x00012b027f007947ULL, 0x000fea000b800000ULL, 0x00001f143a3c7589ULL, 0x0002a400000e0000ULL,
0x0000003c18187220ULL, 0x084fe40000410000ULL, 0x0000003c19197220ULL, 0x080fe40000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x000fc40000410000ULL,
0x0000003c20207220ULL, 0x080fe40000410000ULL, 0x0000003c21217220ULL, 0x080fe40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x080fe40000410000ULL,
0x0000003c28287220ULL, 0x080fe40000410000ULL, 0x0000003c29297220ULL, 0x000fc40000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000003c30307220ULL, 0x080fe40000410000ULL, 0x0000003c31317220ULL, 0x080fe40000410000ULL,
0x0000003c34347220ULL, 0x080fe40000410000ULL, 0x0000003c35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0038ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080c147811ULL, 0x002fe200078ff0ffULL,
0x00012a027f007947ULL, 0x000fea000b800000ULL, 0x00001f143a3c7589ULL, 0x0002a400000e0000ULL,
0x0000003c1a1a7220ULL, 0x084fe40000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c22227220ULL, 0x080fe40000410000ULL, 0x0000003c23237220ULL, 0x000fc40000410000ULL,
0x0000003c26267220ULL, 0x080fe40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003c2f2f7220ULL, 0x000fc40000410000ULL,
0x0000003c32327220ULL, 0x080fe40000410000ULL, 0x0000003c33337220ULL, 0x080fe40000410000ULL,
0x0000003c36367220ULL, 0x080fe40000410000ULL, 0x0000003c37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe20007806038ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000000e390e7209ULL, 0x000fd60007810000ULL,
0x8000000e39390221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL, 0x0000003900080308ULL, 0x000e640000000800ULL,
0x0000000810100220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f100f7221ULL, 0x008fc40000010000ULL, 0x0000000000147805ULL, 0x000fca0000015200ULL,
0x0000000800107824ULL, 0x000fca00078e00ffULL, 0xfffffff0103c7812ULL, 0x000fca00078ec0ffULL,
0x0176b4003c397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038143b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e15ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011439ULL,
0x0000003b10107211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000210107819ULL, 0x000fc80000001239ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176b4003c397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103a107816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f85270ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fe400000010ffULL, 0x00000002ff177819ULL, 0x000fe4000001160cULL,
0x0000541006107816ULL, 0x000fe20000000006ULL, 0x000125d27f007947ULL, 0x000fea000b800000ULL,
0x00001f1710077589ULL, 0x0002a400000e0000ULL, 0x0000000817147810ULL, 0x000fe20007ffe0ffULL,
0x000126227f007947ULL, 0x000fea000b800000ULL, 0x00001f1410067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001017147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0010ULL, 0x000064f0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0001307000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001817147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0010ULL,
0x00006560003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x0001300000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000010006c107810ULL, 0x00afca0007ffe0ffULL, 0x00000010053c7824ULL, 0x104fe400078e0210ULL,
0x0000001003147824ULL, 0x100fe400078e0210ULL, 0x0000001004387824ULL, 0x000fe400078e0210ULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x000000001414783bULL, 0x000ea80000004200ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x00000018ff407819ULL, 0x002fe2000001143cULL,
0x0000003c00697306ULL, 0x000fe20000005400ULL, 0x00000018ff427819ULL, 0x000fe2000001143dULL,
0x000100003c6a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x004fc40000011415ULL,
0x00000018ff597819ULL, 0x000fe40000011417ULL, 0x00000018ff437819ULL, 0x000fe2000001143eULL,
0x0000004000567306ULL, 0x000fe20000209400ULL, 0x00000018ff6b7819ULL, 0x008fe40000011439ULL,
0x00000018ff6e7819ULL, 0x000fca000001146aULL, 0x0000004000417306ULL, 0x000e700000205400ULL,
0x0000004000587306ULL, 0x0004f0000020d400ULL, 0x0000004600497306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x004fc4000001143fULL, 0x000000415600720bULL, 0x002fe20003f5d000ULL,
0x000001003d567824ULL, 0x000fc800078e00ffULL, 0x0000004000527306ULL, 0x000ff00000209400ULL,
0x00000040004b7306ULL, 0x000fe20000205400ULL, 0x0000000158582812ULL, 0x008fce00078efcffULL,
0x0000004000637306ULL, 0x0003f0000020d400ULL, 0x0000004600507306ULL, 0x000fe20000205400ULL,
0x000001003c407824ULL, 0x002fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe40000011440ULL,
0x00000046005c7306ULL, 0x000ff0000020d400ULL, 0x00000042006d7306ULL, 0x000ff00000209400ULL,
0x00000042004a7306ULL, 0x000e700000205400ULL, 0x0000004200557306ULL, 0x0005f0000020d400ULL,
0x0000003c00467306ULL, 0x000ee20000009400ULL, 0x00000018ff427819ULL, 0x004fc40000011414ULL,
0x0000004a6d00720bULL, 0x002fca0003f1d000ULL, 0x0000005900457306ULL, 0x000ff00000209400ULL,
0x0000005900577306ULL, 0x000fe20000205400ULL, 0x000000694600720bULL, 0x008fe40003f7d000ULL,
0x0000000155550812ULL, 0x000fca00078efcffULL, 0x00000059004f7306ULL, 0x000ff0000020d400ULL,
0x0000006800607306ULL, 0x000ff00000209400ULL, 0x0000006800597306ULL, 0x000e700000205400ULL,
0x0000004200627306ULL, 0x000ff00000209400ULL, 0x0000004200537306ULL, 0x000fe20000205400ULL,
0x000000596000720bULL, 0x002fce0003fdd000ULL, 0x00000042005d7306ULL, 0x0003f0000020d400ULL,
0x0000004300657306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x002fce0000011438ULL,
0x0000004300547306ULL, 0x000ff00000205400ULL, 0x0000004300647306ULL, 0x0003f0000020d400ULL,
0x00000042004d7306ULL, 0x000fe20000209400ULL, 0x00000018ff437819ULL, 0x002fce0000011416ULL,
0x00000042004c7306ULL, 0x000ff00000205400ULL, 0x0000004200487306ULL, 0x000ff0000020d400ULL,
0x0000003d00427306ULL, 0x000ff00000009400ULL, 0x0000003d00677306ULL, 0x000e700000005400ULL,
0x0000006800407306ULL, 0x0004f0000020d400ULL, 0x0000006b005b7306ULL, 0x000fe20000209400ULL,
0x00000018ff687819ULL, 0x004fc40000011456ULL, 0x000000674200720bULL, 0x002fca0003fbd000ULL,
0x0000006b005a7306ULL, 0x000fe20000205400ULL, 0x0000000140406812ULL, 0x008fce00078efcffULL,
0x0000006b00477306ULL, 0x000ff0000020d400ULL, 0x0000004300617306ULL, 0x000ff00000209400ULL,
0x00000043004e7306ULL, 0x000ff00000205400ULL, 0x0000004300517306ULL, 0x000ff0000020d400ULL,
0x0000006e006b7306ULL, 0x000ff00000209400ULL, 0x0000006e00467306ULL, 0x000e700000205400ULL,
0x0000003c00437306ULL, 0x0004f0000000d400ULL, 0x0000006800697306ULL, 0x000fe20000209400ULL,
0x000100003d3c7824ULL, 0x004fe200078e00ffULL, 0x000000466b00720bULL, 0x002fe20003fdd000ULL,
0x000001003f467824ULL, 0x000fc600078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001143cULL,
0x0000006800567306ULL, 0x000e620000205400ULL, 0x0000000143433812ULL, 0x008fe400078efcffULL,
0x00000018ff6d7819ULL, 0x000fe40000011446ULL, 0x000000434040723eULL, 0x000fc600000010ffULL,
0x0000003d00417306ULL, 0x0004f0000000d400ULL, 0x0000006e006a7306ULL, 0x0008e2000020d400ULL,
0x000001003e3d7824ULL, 0x004fe200078e00ffULL, 0x000000566900720bULL, 0x002fcc0003f7d000ULL,
0x0000006f00677306ULL, 0x000fe20000209400ULL, 0x00000018ff6e7819ULL, 0x010fe4000001143dULL,
0x0000000141415812ULL, 0x008fca00078efcffULL, 0x0000006f003c7306ULL, 0x000e620000205400ULL,
0x000000016a6a6812ULL, 0x000fe400078efcffULL, 0x000000546500720bULL, 0x000fca0003fdd000ULL,
0x0000006800427306ULL, 0x000eb0000020d400ULL, 0x0000006e003d7306ULL, 0x000fe20000209400ULL,
0x0000003c6700720bULL, 0x002fe20003f5d000ULL, 0x000100003e3c7824ULL, 0x000fe200078e00ffULL,
0x0000000164646812ULL, 0x000fc400078efcffULL, 0x0000004e6100720bULL, 0x000fc60003fdd000ULL,
0x0000006e00607306ULL, 0x000e620000205400ULL, 0x0000000142423812ULL, 0x004fc800078efcffULL,
0x000000414241723eULL, 0x000fc600000010ffULL, 0x0000003e00687306ULL, 0x000fe40000009400ULL,
0x0000000151516812ULL, 0x000fe400078efcffULL, 0x0000004c4d00720bULL, 0x000fc80003fdd000ULL,
0x0000003e006b7306ULL, 0x000ea20000005400ULL, 0x000000603d00720bULL, 0x002fce0003f7d000ULL,
0x0000006f00597306ULL, 0x0002e2000020d400ULL, 0x0000000148486812ULL, 0x000fe400078efcffULL,
0x0000005a5b00720bULL, 0x000fca0003fdd000ULL, 0x0000006d00567306ULL, 0x000fe20000209400ULL,
0x0000006b6800720bULL, 0x004fe40003fbd000ULL, 0x00000018ff6b7819ULL, 0x000fe4000001143cULL,
0x00000018ff6f7819ULL, 0x002fc6000001143bULL, 0x0000006d00697306ULL, 0x000e620000205400ULL,
0x0000000159592812ULL, 0x008fe400078efcffULL, 0x0000000147476812ULL, 0x000fca00078efcffULL,
0x0000003f00607306ULL, 0x000ff00000009400ULL, 0x0000003f00657306ULL, 0x000ea20000005400ULL,
0x000000695600720bULL, 0x002fce0003f5d000ULL, 0x0000006e004a7306ULL, 0x000e70000020d400ULL,
0x0000006b003c7306ULL, 0x000fe20000209400ULL, 0x000000656000720bULL, 0x004fce0003f1d000ULL,
0x0000006b003d7306ULL, 0x000ea20000205400ULL, 0x000000014a4a3812ULL, 0x002fce00078efcffULL,
0x0000003e00547306ULL, 0x0002f0000000d400ULL, 0x0000006d00467306ULL, 0x000f22000020d400ULL,
0x000100003f3e7824ULL, 0x002fe200078e00ffULL, 0x0000003d3c00720bULL, 0x004fe20003f7d000ULL,
0x00000100143c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff697819ULL, 0x000fe4000001143eULL,
0x00000018ff6e7819ULL, 0x000fe2000001143cULL, 0x0000003f00567306ULL, 0x0002a2000000d400ULL,
0x0000000154545812ULL, 0x008fe400078efcffULL, 0x0000000146462812ULL, 0x010fca00078efcffULL,
0x0000006900607306ULL, 0x000fe20000209400ULL, 0x01180000443c783bULL, 0x002e620000000200ULL,
0x0000004b5200720bULL, 0x000fcc0003f5d000ULL, 0x00000069006d7306ULL, 0x000ee20000205400ULL,
0x0000000156560812ULL, 0x004fe400078efcffULL, 0x000000536200720bULL, 0x000fc80003f1d000ULL,
0x0000000163632812ULL, 0x000fe200078efcffULL, 0x0000006900677306ULL, 0x000530000020d400ULL,
0x0000006e00657306ULL, 0x000fe20000209400ULL, 0x0000006d6000720bULL, 0x008fe20003fbd000ULL,
0x0000010015697824ULL, 0x004fe200078e00ffULL, 0x000000015d5d0812ULL, 0x000fc800078efcffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000006e00747306ULL, 0x000eac0000205400ULL,
0x0000000167675812ULL, 0x010fe400078efcffULL, 0x0000006e00607306ULL, 0x000722000020d400ULL,
0x000000073c3cc231ULL, 0x002fc400003400ffULL, 0x000000073e3ec231ULL, 0x000fe400003400ffULL,
0x000000063d3dc231ULL, 0x080fe400003400ffULL, 0x000000063f3fc231ULL, 0x000fe200003400ffULL,
0x0000006900427306ULL, 0x000fe20000209400ULL, 0x000000746500720bULL, 0x004fe20003fbd000ULL,
0x00010000146e7824ULL, 0x008fc800078e00ffULL, 0x000000403c18723cULL, 0x000b620000041818ULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000006900437306ULL, 0x000e6a0000205400ULL,
0x0000001002407824ULL, 0x020fe200078e0210ULL, 0x0000000160605812ULL, 0x010fe400078efcffULL,
0x0000006b00687306ULL, 0x0004f0000020d400ULL, 0x00000014004b7306ULL, 0x000fe20000009400ULL,
0x000000434200720bULL, 0x002fc40003fbd000ULL, 0x00000018ff6b7819ULL, 0x004fe2000001143aULL,
0x000000004040783bULL, 0x000e680000004200ULL, 0x0000001400527306ULL, 0x000ea20000005400ULL,
0x0000000168683812ULL, 0x008fe400078efcffULL, 0x000000504900720bULL, 0x000fca0003f7d000ULL,
0x0000001400617306ULL, 0x000ef0000000d400ULL, 0x0000006900697306ULL, 0x000f22000020d400ULL,
0x000000524b00720bULL, 0x004fe40003f5d000ULL, 0x000000015c5c3812ULL, 0x000fca00078efcffULL,
0x0000006e00657306ULL, 0x000fec0000209400ULL, 0x0000000161612812ULL, 0x008fe400078efcffULL,
0x0000006e00147306ULL, 0x000ea20000205400ULL, 0x0000000169695812ULL, 0x010fce00078efcffULL,
0x0000001500497306ULL, 0x000ff00000009400ULL, 0x0000001500627306ULL, 0x000ee20000005400ULL,
0x000000146500720bULL, 0x004fe20003fbd000ULL, 0x0001000015147824ULL, 0x000fcc00078e00ffULL,
0x0000006b00507306ULL, 0x000ff00000209400ULL, 0x0000006b004e7306ULL, 0x000fe20000205400ULL,
0x000000624900720bULL, 0x008fce0003f5d000ULL, 0x0000006b004b7306ULL, 0x0005f0000020d400ULL,
0x0000006e00627306ULL, 0x0002e2000020d400ULL, 0x00000018ff6b7819ULL, 0x004fe40000011414ULL,
0x0000006a5814723eULL, 0x000fca00000010ffULL, 0x0000006b006d7306ULL, 0x000fe20000209400ULL,
0x00000018ff6e7819ULL, 0x002fce0000011441ULL, 0x0000006b00587306ULL, 0x000e620000205400ULL,
0x0000000162625812ULL, 0x008fce00078efcffULL, 0x0000001500657306ULL, 0x0004e2000000d400ULL,
0x000000586d00720bULL, 0x002fce0003fbd000ULL, 0x0000006b006a7306ULL, 0x000e62000020d400ULL,
0x000000595515723eULL, 0x004fe200000010ffULL, 0x00000100176d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc80000011440ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x000000143c1c723cULL, 0x000b62000004181cULL, 0x0000000165652812ULL, 0x008fe200078efcffULL,
0x0000005900557306ULL, 0x000fe20000209400ULL, 0x000000574500720bULL, 0x000fc80003f5d000ULL,
0x0000010016147824ULL, 0x020fe200078e00ffULL, 0x000000564615723eULL, 0x000fe400000010ffULL,
0x0000006d00467306ULL, 0x000fe20000209400ULL, 0x000000016a6a5812ULL, 0x002fe400078efcffULL,
0x00000018ff6b7819ULL, 0x000fe40000011414ULL, 0x000000544a14723eULL, 0x000fe400000010ffULL,
0x000000014f4f2812ULL, 0x000fe200078efcffULL, 0x0000006b004a7306ULL, 0x000fe80000209400ULL,
0x000000143c20723cULL, 0x000be80000041820ULL, 0x0000006d00157306ULL, 0x020e660000205400ULL,
0x000000686414723eULL, 0x000fca00000010ffULL, 0x0000006b00547306ULL, 0x000ea20000205400ULL,
0x000000154600720bULL, 0x002fce0003fbd000ULL, 0x0000006b006b7306ULL, 0x000e62000020d400ULL,
0x000000676315723eULL, 0x000fe400000010ffULL, 0x000000544a00720bULL, 0x004fca0003f1d000ULL,
0x0000006d00637306ULL, 0x000ea2000020d400ULL, 0x000000143c24723cULL, 0x000b6e0000041824ULL,
0x00000017006d7306ULL, 0x000fe20000009400ULL, 0x0001000016157824ULL, 0x020fe200078e00ffULL,
0x000000016b6b0812ULL, 0x002fcc00078efcffULL, 0x0000001700147306ULL, 0x000e620000005400ULL,
0x0000000163635812ULL, 0x004fce00078efcffULL, 0x0000005900577306ULL, 0x000ff00000205400ULL,
0x0000005900457306ULL, 0x000fe2000020d400ULL, 0x000000146d00720bULL, 0x002fe20003f1d000ULL,
0x0001000017147824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011414ULL,
0x0000006e00587306ULL, 0x000fe20000209400ULL, 0x000000616014723eULL, 0x000fce00000010ffULL,
0x0000006e00597306ULL, 0x000ff00000205400ULL, 0x0000006e004a7306ULL, 0x000ff0000020d400ULL,
0x00000016006e7306ULL, 0x000ff00000009400ULL, 0x0000001600647306ULL, 0x000e700000005400ULL,
0x0000006f00537306ULL, 0x000ff00000209400ULL, 0x0000006f00527306ULL, 0x000fe20000205400ULL,
0x000000646e00720bULL, 0x002fce0003f7d000ULL, 0x0000006f00497306ULL, 0x0003f0000020d400ULL,
0x0000001600677306ULL, 0x000ea2000000d400ULL, 0x00000018ff6f7819ULL, 0x002fce0000011442ULL,
0x0000006f00547306ULL, 0x000ff00000209400ULL, 0x0000006f00567306ULL, 0x000fe20000205400ULL,
0x0000000167673812ULL, 0x004fce00078efcffULL, 0x0000006f00467306ULL, 0x0003f0000020d400ULL,
0x00000074006e7306ULL, 0x000fe20000209400ULL, 0x00000018ff6f7819ULL, 0x002fe40000011415ULL,
0x000000656915723eULL, 0x000fca00000010ffULL, 0x0000006f00687306ULL, 0x000fe40000209400ULL,
0x000000143c28723cULL, 0x000b6c0000041828ULL, 0x0000006f006d7306ULL, 0x000e620000205400ULL,
0x000000625d14723eULL, 0x020fe400000010ffULL, 0x0000006a5c15723eULL, 0x000fca00000010ffULL,
0x0000007400657306ULL, 0x000ea40000205400ULL, 0x000000143c2c723cULL, 0x000b6c000004182cULL,
0x0000001700647306ULL, 0x000ee2000000d400ULL, 0x0000006d6800720bULL, 0x002fe40003f7d000ULL,
0x000000676b14723eULL, 0x020fca00000010ffULL, 0x0000006f00167306ULL, 0x000e62000020d400ULL,
0x000000656e00720bULL, 0x004fce0003fbd000ULL, 0x0000007400177306ULL, 0x000ea2000020d400ULL,
0x0000000164640812ULL, 0x008fc800078efcffULL, 0x000000646315723eULL, 0x000fe400000010ffULL,
0x00000018ff647819ULL, 0x000fe20000011443ULL, 0x0000003800607306ULL, 0x000fe20000009400ULL,
0x0000000116163812ULL, 0x002fc600078efcffULL, 0x000000143c30723cULL, 0x000b620000041830ULL,
0x0000000117175812ULL, 0x004fc600078efcffULL, 0x0000003800617306ULL, 0x000e660000005400ULL,
0x000000165114723eULL, 0x020fe200000010ffULL, 0x0000010038167824ULL, 0x000fe200078e00ffULL,
0x000000174f15723eULL, 0x000fc800000010ffULL, 0x00000018ff637819ULL, 0x000fe20000011416ULL,
0x00000064005c7306ULL, 0x000fe40000209400ULL, 0x000000143c34723cULL, 0x000b620000041834ULL,
0x000000616000720bULL, 0x002fca0003f5d000ULL, 0x0000006300167306ULL, 0x000fe20000209400ULL,
0x0001000038147824ULL, 0x020fe400078e00ffULL, 0x00000100393d7824ULL, 0x040fe400078e00ffULL,
0x000001003a3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe40000011414ULL,
0x0000006300157306ULL, 0x000e620000205400ULL, 0x00000018ff6b7819ULL, 0x000fe2000001143dULL,
0x00010000393d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc8000001143eULL,
0x00000018ff6d7819ULL, 0x000fe2000001143dULL, 0x0000003c00147306ULL, 0x000ff00000209400ULL,
0x0000003c00177306ULL, 0x000ea20000205400ULL, 0x000000151600720bULL, 0x002fce0003f7d000ULL,
0x0000006400627306ULL, 0x000ff00000205400ULL, 0x0000006400517306ULL, 0x000fe2000020d400ULL,
0x000000171400720bULL, 0x004fe20003f1d000ULL, 0x000100003a147824ULL, 0x000fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011414ULL, 0x00000038005d7306ULL, 0x000e62000000d400ULL,
0x000100003b147824ULL, 0x000fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011414ULL,
0x0000003c00647306ULL, 0x0004f0000020d400ULL, 0x0000003a00157306ULL, 0x000fe20000009400ULL,
0x000000015d5d2812ULL, 0x002fe200078efcffULL, 0x000001003b3c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe2000001143cULL, 0x0000003a00167306ULL, 0x000e620000005400ULL,
0x0000000164640812ULL, 0x008fce00078efcffULL, 0x0000003b00177306ULL, 0x000ff00000009400ULL,
0x0000003b004c7306ULL, 0x000ea20000005400ULL, 0x000000161500720bULL, 0x002fce0003f5d000ULL,
0x0000003900657306ULL, 0x000ff00000009400ULL, 0x0000003900677306ULL, 0x000e620000005400ULL,
0x0000004c1700720bULL, 0x004fe40003f1d000ULL, 0x011800001114783bULL, 0x000eaa0000000200ULL,
0x00000039004f7306ULL, 0x000ef0000000d400ULL, 0x0000006d003d7306ULL, 0x000fe20000209400ULL,
0x000000676500720bULL, 0x002fce0003fbd000ULL, 0x0000006d006a7306ULL, 0x000e6c0000205400ULL,
0x000000014f4f5812ULL, 0x008fe400078efcffULL, 0x0000006300387306ULL, 0x000ef0000020d400ULL,
0x0000006b00687306ULL, 0x000fe20000209400ULL, 0x0000006a3d00720bULL, 0x002fe20003fbd000ULL,
0x000000071414c231ULL, 0x004fc400003400ffULL, 0x000000071616c231ULL, 0x000fe400003400ffULL,
0x000000061515c231ULL, 0x080fe400003400ffULL, 0x0000006b00697306ULL, 0x000e620000205400ULL,
0x0000000138383812ULL, 0x008fe200078efcffULL, 0x000000061717c231ULL, 0x000fc600003400ffULL,
0x0000005d3838723eULL, 0x000fc600000010ffULL, 0x0000006d00637306ULL, 0x000eb0000020d400ULL,
0x0000006f003e7306ULL, 0x000fe20000209400ULL, 0x000000696800720bULL, 0x002fce0003f7d000ULL,
0x0000006f003f7306ULL, 0x000e620000205400ULL, 0x0000000163635812ULL, 0x004fce00078efcffULL,
0x0000006100747306ULL, 0x000ff00000209400ULL, 0x00000061006e7306ULL, 0x000ea20000205400ULL,
0x0000003f3e00720bULL, 0x002fce0003f9d000ULL, 0x0000006b00397306ULL, 0x000e70000020d400ULL,
0x0000006f00607306ULL, 0x000ee2000020d400ULL, 0x0000006e7400720bULL, 0x004fce0003fbd000ULL,
0x00000061003c7306ULL, 0x000ea2000020d400ULL, 0x0000000139393812ULL, 0x002fe400078efcffULL,
0x0000004e5000720bULL, 0x000fe20003f7d000ULL, 0x0000010042507824ULL, 0x000fe200078e00ffULL,
0x0000004f3939723eULL, 0x000fc600000010ffULL, 0x0000004d006d7306ULL, 0x000fe20000209400ULL,
0x0000000160604812ULL, 0x008fc600078efcffULL, 0x000000381418723cULL, 0x040b680000041818ULL,
0x0000004d006f7306ULL, 0x000e620000205400ULL, 0x000000013c3c5812ULL, 0x004fe400078efcffULL,
0x000000014b4b3812ULL, 0x000fe400078efcffULL, 0x000000644838723eULL, 0x020fe400000010ffULL,
0x000000634739723eULL, 0x000fe200000010ffULL, 0x0000004d00657306ULL, 0x000eac000020d400ULL,
0x00000038141c723cULL, 0x000b64000004181cULL, 0x00000040004d7306ULL, 0x000fe20000009400ULL,
0x0000006f6d00720bULL, 0x002fc40003fbd000ULL, 0x00000018ff6d7819ULL, 0x000fca0000011450ULL,
0x00000040003e7306ULL, 0x000e6c0000005400ULL, 0x0000000165655812ULL, 0x004fe400078efcffULL,
0x0000003a00677306ULL, 0x0004e2000000d400ULL, 0x000000575500720bULL, 0x000fe40003fbd000ULL,
0x000000654b48723eULL, 0x000fca00000010ffULL, 0x0000003b00617306ULL, 0x0008e2000000d400ULL,
0x00000100403a7824ULL, 0x044fe200078e00ffULL, 0x0000003e4d00720bULL, 0x002fe20003fdd000ULL,
0x00010000403e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000007500697306ULL, 0x000fe20000209400ULL, 0x00000100413b7824ULL, 0x010fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143eULL, 0x0000000167672812ULL, 0x008fe400078efcffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000007500117306ULL, 0x000e620000205400ULL,
0x0000000161610812ULL, 0x000fc400078efcffULL, 0x000000525300720bULL, 0x000fe40003f5d000ULL,
0x0000000145455812ULL, 0x000fe400078efcffULL, 0x000000565400720bULL, 0x000fe20003fbd000ULL,
0x0000003a005b7306ULL, 0x000ff00000209400ULL, 0x0000003a00687306ULL, 0x000ea20000205400ULL,
0x000000116900720bULL, 0x002fe20003f1d000ULL, 0x0000010043117824ULL, 0x000fe200078e00ffULL,
0x0000000149492812ULL, 0x000fc400078efcffULL, 0x0000000146465812ULL, 0x000fe400078efcffULL,
0x00000018ff697819ULL, 0x000fe20000011411ULL, 0x0000003a004e7306ULL, 0x000e70000020d400ULL,
0x0000003b006b7306ULL, 0x000fe20000209400ULL, 0x000000685b00720bULL, 0x004fe20003f7d000ULL,
0x00010000425b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000003b006a7306ULL, 0x000fec0000205400ULL, 0x000000014e4e3812ULL, 0x002fe400078efcffULL,
0x0000003b003d7306ULL, 0x000ff0000020d400ULL, 0x00000041003a7306ULL, 0x000ff00000009400ULL,
0x00000041003b7306ULL, 0x000e700000005400ULL, 0x00000075004c7306ULL, 0x0004f0000020d400ULL,
0x0000003f006e7306ULL, 0x000fe20000209400ULL, 0x0000003b3a00720bULL, 0x002fe20003f9d000ULL,
0x00010000413a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff757819ULL, 0x004fe2000001143aULL,
0x0000003f00747306ULL, 0x000e620000205400ULL, 0x000000014c4c0812ULL, 0x008fe400078efcffULL,
0x0000006a6b00720bULL, 0x000fe40003f1d000ULL, 0x0000004c4949723eULL, 0x000fc600000010ffULL,
0x0000004200557306ULL, 0x000fe80000009400ULL, 0x000000481424723cULL, 0x000f680000041824ULL,
0x0000004200577306ULL, 0x000ea20000005400ULL, 0x000000746e00720bULL, 0x002fe40003f5d000ULL,
0x000000013d3d0812ULL, 0x000fca00078efcffULL, 0x00000040004d7306ULL, 0x000e70000000d400ULL,
0x0000004100407306ULL, 0x000ee2000000d400ULL, 0x000000575500720bULL, 0x004fe20003f7d000ULL,
0x0001000043577824ULL, 0x000fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000003f00417306ULL, 0x000ea2000020d400ULL, 0x000000014d4d6812ULL, 0x002fce00078efcffULL,
0x00000075003a7306ULL, 0x000fe20000209400ULL, 0x0000000140404812ULL, 0x008fe400078efcffULL,
0x000000595800720bULL, 0x000fe40003f9d000ULL, 0x000000403d3d723eULL, 0x000fc600000010ffULL,
0x00000075003b7306ULL, 0x000e620000205400ULL, 0x0000000141412812ULL, 0x004fce00078efcffULL,
0x0000006d00537306ULL, 0x000fe20000209400ULL, 0x000000014a4a4812ULL, 0x000fce00078efcffULL,
0x0000006d005a7306ULL, 0x000ea20000205400ULL, 0x0000003b3a00720bULL, 0x002fe40003f1d000ULL,
0x00000067603a723eULL, 0x000fe400000010ffULL, 0x000000613c3b723eULL, 0x000fe400000010ffULL,
0x0000004d4e3c723eULL, 0x000fe200000010ffULL, 0x00000042004f7306ULL, 0x000e68000000d400ULL,
0x0000003a1420723cULL, 0x000b680000041820ULL, 0x00000075003e7306ULL, 0x000ee2000020d400ULL,
0x0000005a5300720bULL, 0x004fc60003f5d000ULL, 0x0000003c1428723cULL, 0x000f680000041828ULL,
0x0000006d003f7306ULL, 0x000ea2000020d400ULL, 0x000000014f4f3812ULL, 0x002fce00078efcffULL,
0x00000043005d7306ULL, 0x000fe20000009400ULL, 0x000000013e3e0812ULL, 0x008fe400078efcffULL,
0x000000625c00720bULL, 0x000fe40003f1d000ULL, 0x0000003e4a39723eULL, 0x020fc600000010ffULL,
0x0000004300687306ULL, 0x000e620000005400ULL, 0x000000013f3f2812ULL, 0x004fc800078efcffULL,
0x0000004f3f3a723eULL, 0x000fc600000010ffULL, 0x0000004300427306ULL, 0x000ea2000000d400ULL,
0x0000000151510812ULL, 0x000fce00078efcffULL, 0x0000006900507306ULL, 0x000fe20000209400ULL,
0x000000685d00720bULL, 0x002fce0003fdd000ULL, 0x0000006900527306ULL, 0x000e6c0000205400ULL,
0x0000000142426812ULL, 0x004fe400078efcffULL, 0x0000005b00557306ULL, 0x000ff00000209400ULL,
0x0000005b00437306ULL, 0x000ea20000205400ULL, 0x000000525000720bULL, 0x002fce0003f9d000ULL,
0x0000005700477306ULL, 0x000ff00000209400ULL, 0x0000005700387306ULL, 0x000e620000205400ULL,
0x000000435500720bULL, 0x004fce0003f5d000ULL, 0x0000006900117306ULL, 0x000eb0000020d400ULL,
0x0000005b005b7306ULL, 0x000ee2000020d400ULL, 0x000000384700720bULL, 0x002fe40003f7d000ULL,
0x000000414538723eULL, 0x000fca00000010ffULL, 0x0000005700407306ULL, 0x000e62000020d400ULL,
0x0000000111114812ULL, 0x004fe200078efcffULL, 0x00000038142c723cULL, 0x000f66000004182cULL,
0x00000042113b723eULL, 0x000fe200000010ffULL, 0x0000000200117824ULL, 0x000fe200078e00ffULL,
0x000000015b5b2812ULL, 0x008fc800078efcffULL, 0x0000005b4646723eULL, 0x000fe200000010ffULL,
0x0000003a1430723cULL, 0x000f620000041830ULL, 0x0000000140403812ULL, 0x002fc800078efcffULL,
0x000000405147723eULL, 0x000fce00000010ffULL, 0x000000461434723cULL, 0x000b6e0000041834ULL,
0x000176c871167811ULL, 0x020fe400078e18ffULL, 0xfffffff811147812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000016167f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176900014ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff117224ULL, 0x000fc600078e00ffULL, 0x0000000000147805ULL, 0x004fc80000015200ULL,
0x000004000a397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x006fc40007804817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038143b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e15ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002071387824ULL, 0x000fc800078e00ffULL,
0x000001000b117824ULL, 0x000fca00078e0238ULL, 0x000000c011177810ULL, 0x000fc80007ffe0ffULL,
0x0000006017157812ULL, 0x000fca00078ec0ffULL, 0x00000001723a7824ULL, 0x000fe200078e0215ULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x0000001770147217ULL, 0x000fe20007800000ULL,
0x0000001000157824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe4000001160cULL,
0x000062000d3f7a11ULL, 0x000fe200078a38ffULL, 0x0000000114147824ULL, 0x000fe200078e0a17ULL,
0x0000001015157812ULL, 0x000fe400078ec0ffULL, 0x0000000416387810ULL, 0x040fe40007ffe0ffULL,
0x0000001415147217ULL, 0x000fe20007800000ULL, 0x0000000116177824ULL, 0x140fe200078e0215ULL,
0x00000008163b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000138397824ULL, 0x100fe200078e0215ULL,
0x0000000c163c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a15ULL,
0x000063000d417a11ULL, 0x000fe200028f3cffULL, 0x0000000839437824ULL, 0x000fc400078e00ffULL,
0x000000013c477824ULL, 0x100fe200078e0215ULL, 0x000000143b00720cULL, 0x0c0fe20003f46070ULL,
0x000000013b3b7824ULL, 0x000fe200078e0215ULL, 0x000000143800720cULL, 0x080fe20003f66070ULL,
0x0000000117157824ULL, 0x040fe200078e020cULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000817387824ULL, 0x040fe200078e00ffULL, 0x000000143c00720cULL, 0x000fe20003f06070ULL,
0x0000000117147824ULL, 0x000fe400078e023aULL, 0x0000000139167824ULL, 0x100fe200078e020cULL,
0xfffffff8383d7812ULL, 0x000fe200078ee215ULL, 0x000000013b177824ULL, 0x000fc400078e020cULL,
0x000000083b387824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee216ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff838457812ULL, 0x000fe200078ee217ULL,
0x0000000139167824ULL, 0x100fe200078e023aULL, 0x0000005e14147212ULL, 0x000fe200078efcffULL,
0x000000013b387824ULL, 0x000fe400078e023aULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003f14147210ULL, 0x000fc60007fbe0ffULL, 0x00000001473a7824ULL, 0x000fe200078e023aULL,
0x0000005e16167212ULL, 0x000fe200078efcffULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005e38387212ULL, 0x000fc600078efcffULL,
0x0000000115157824ULL, 0x100fe200028e0641ULL, 0x0000003f16167210ULL, 0x080fe20007fbe0ffULL,
0x00000001470d7824ULL, 0x040fe200078e020cULL, 0x0000005e3a3a7212ULL, 0x000fe200078efcffULL,
0x00000008473c7824ULL, 0x000fe400078e00ffULL, 0x0000000117177824ULL, 0x000fe200028e0641ULL,
0x0000003f38387210ULL, 0x080fe40007fbe0ffULL, 0x0000003f3a3a7210ULL, 0x000fe20007fde0ffULL,
0x00000010453f7824ULL, 0x100fe200078e0210ULL, 0xfffffff83c477812ULL, 0x000fe200078ee20dULL,
0x000000103d0d7824ULL, 0x000fc400078e0210ULL, 0x00000010433d7824ULL, 0x100fe400078e0210ULL,
0x0000000139397824ULL, 0x100fe200028e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e2000e101c48ULL, 0x000000013b3b7824ULL, 0x000fe400030e0641ULL,
0x0000001047417824ULL, 0x000fe200078e0210ULL, 0x00000000163d7faeULL, 0x0003e8000d901c48ULL,
0x00000000383f7faeULL, 0x0003e8000d101c48ULL, 0x000000003a417faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000147824ULL, 0x000fe200078e00ffULL,
0x000062000d417a11ULL, 0x000fc800078038ffULL, 0x0000001014157812ULL, 0x000fe400078ec0ffULL,
0x000063000d437a11ULL, 0x000fe400000f3cffULL, 0x000000150c157211ULL, 0x000fc800078fe8ffULL,
0x0000000415177810ULL, 0x040fe20007ffe0ffULL, 0x0000000115167824ULL, 0x040fe200078e020cULL,
0x0000000815397810ULL, 0x040fe20007ffe0ffULL, 0x00000008153f7824ULL, 0x040fe200078e00ffULL,
0x0000000c153b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000115147824ULL, 0x000fe400078e023aULL,
0x0000000117157824ULL, 0x000fe200078e020cULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL,
0x00000008173e7824ULL, 0x000fe400078e00ffULL, 0x0000000139167824ULL, 0x000fc400078e020cULL,
0x0000000839477824ULL, 0x000fe200078e00ffULL, 0xfffffff83e457812ULL, 0x000fe200078ee215ULL,
0x00000001173c7824ULL, 0x000fe400078e023aULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fc600078ee216ULL, 0x0000000139387824ULL, 0x100fe200078e023aULL,
0x0000005e14167212ULL, 0x000fe200078efcffULL, 0x000000013b3a7824ULL, 0x000fe400078e023aULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004116167210ULL, 0x000fc60007f1e0ffULL,
0x000000013b177824ULL, 0x040fe200078e020cULL, 0x0000005e3c147212ULL, 0x080fe200078efcffULL,
0x000000083b407824ULL, 0x000fe400078e00ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000004114147210ULL, 0x000fe40007f5e0ffULL, 0xfffffff840497812ULL, 0x000fe200078ee217ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005e38387212ULL, 0x000fc600078efcffULL,
0x0000000115177824ULL, 0x100fe200000e0643ULL, 0x0000005e3a3a7212ULL, 0x000fe200078efcffULL,
0x000000013d157824ULL, 0x100fe200010e0643ULL, 0x0000004138387210ULL, 0x080fe20007f1e0ffULL,
0x000000103f0d7824ULL, 0x100fe200078e0210ULL, 0x000000413a3a7210ULL, 0x000fe20007f7e0ffULL,
0x00000010453d7824ULL, 0x100fe400078e0210ULL, 0x0000000139397824ULL, 0x000fe200000e0643ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000160d7faeULL, 0x0003e2000b901c48ULL,
0x00000010473f7824ULL, 0x000fc400078e0210ULL, 0x000000013b3b7824ULL, 0x000fe200018e0643ULL,
0x00000000143d7faeULL, 0x0003e2000b901c48ULL, 0x0000001049417824ULL, 0x000fc600078e0210ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a417faeULL, 0x0003e4000b901c48ULL,
0x0000000266667810ULL, 0x000fe20007ffe0ffULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff0d7424ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000786600720cULL, 0x000fcc0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fee0008000a05ULL,
0x0000000166148824ULL, 0x000fe400078e0277ULL, 0x00000004ff158424ULL, 0x000fc800078e00ffULL,
0x0000640014148625ULL, 0x000fca00078e0015ULL, 0x00000008140d8981ULL, 0x000322000c1e1900ULL,
0x0000000800167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176b00016167f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176480009147f8cULL, 0x0022e4000c80043fULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01764c00093b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x00afe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01764c00093b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000097824ULL, 0x000fca00078e00ffULL, 0xffffff8009097812ULL, 0x000fc800078ec0ffULL,
0x000001005e097810ULL, 0x000fca0007ffe009ULL, 0x000000017a097824ULL, 0x000fca00078e0209ULL,
0x0170000009397984ULL, 0x000e680000000800ULL, 0x0172000009387984ULL, 0x0006a20000000800ULL,
0x0000000e3900720bULL, 0x002fe20003f1d000ULL, 0x0000f9627f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c3b7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fd200078e000eULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000279097810ULL, 0x000fe40007ffe0ffULL, 0x0000000e3900720bULL, 0x000fe40003f54000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x0000f9127f007947ULL, 0x000fd4000b800000ULL,
0x00000000003a7806ULL, 0x000fc400010e0100ULL, 0x0000008000158824ULL, 0x000fe200078e025eULL,
0x0000000e39097209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099103a147816ULL, 0x000fe200000000ffULL, 0x000000017a3c8824ULL, 0x000fca00078e0215ULL,
0x017400093c008388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000e090e7221ULL, 0x002fe20000010100ULL,
0x000000ff3aff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fcc0000410000ULL, 0x0000000e000e7308ULL, 0x000e640000000800ULL,
0x0000000e0f0f7220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe2000001160cULL, 0x0000f8527f007947ULL, 0x000fea000b800000ULL,
0x00001f140e3c7589ULL, 0x0002e400000e0000ULL, 0x0000003c18187220ULL, 0x08cfe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x000fc40000410000ULL, 0x0000003c20207220ULL, 0x080fe40000410000ULL,
0x0000003c21217220ULL, 0x080fe40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c28287220ULL, 0x080fe40000410000ULL,
0x0000003c29297220ULL, 0x000fc40000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x080fe40000410000ULL, 0x0000003c34347220ULL, 0x080fe40000410000ULL,
0x0000003c35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff003aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080c147811ULL, 0x002fe200078ff0ffULL, 0x0000f7527f007947ULL, 0x000fea000b800000ULL,
0x00001f140e3c7589ULL, 0x0002e400000e0000ULL, 0x0000003c1a1a7220ULL, 0x08cfe40000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c22227220ULL, 0x080fe40000410000ULL,
0x0000003c23237220ULL, 0x000fc40000410000ULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000003c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x080fe40000410000ULL, 0x0000003c36367220ULL, 0x080fe40000410000ULL,
0x0000003c37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3bff7812ULL, 0x000fe2000780603aULL, 0x00000001ff3a7424ULL, 0x000fd800078e00ffULL,
0x8000000939390221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL, 0x0000003900080308ULL, 0x000e640000000800ULL,
0x0000000838380220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f380f7221ULL, 0x004fc40000010000ULL, 0x0000000000147805ULL, 0x000fca0000015200ULL,
0x00000008000e7824ULL, 0x000fca00078e00ffULL, 0xfffffff00e3c7812ULL, 0x000fca00078ec0ffULL,
0x0176ac003c397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038143b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e15ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011439ULL,
0x0000003b0e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x000000020e0e7819ULL, 0x000fc80000001239ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac003c397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103a0e7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fe400000010ffULL, 0x00000002ff137819ULL, 0x000fe4000001160cULL,
0x00005410060e7816ULL, 0x000fe20000000006ULL, 0x0000f3327f007947ULL, 0x000fea000b800000ULL,
0x00001f130e077589ULL, 0x0002a400000e0000ULL, 0x0000000813147810ULL, 0x000fe20007ffe0ffULL,
0x0000f3827f007947ULL, 0x000fea000b800000ULL, 0x00001f140e067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001013147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e000eULL, 0x000099f0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000fb7000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001813147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00009a60003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x0000fb0000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001005407824ULL, 0x100fe200078e026cULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001003387824ULL, 0x100fe400078e026cULL,
0x00000010043c7824ULL, 0x004fe400078e026cULL, 0x000000004040783bULL, 0x000ea80000004200ULL,
0x000000003838783bULL, 0x000ee80000004200ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x0000004000547306ULL, 0x004fe20000009400ULL, 0x00000018ff047819ULL, 0x000fc40000011443ULL,
0x00000018ff0e7819ULL, 0x00afe40000011442ULL, 0x00000018ff127819ULL, 0x000fe40000011439ULL,
0x00000018ff037819ULL, 0x000fe20000011440ULL, 0x0000004000677306ULL, 0x000e620000005400ULL,
0x00000018ff607819ULL, 0x000fe4000001143dULL, 0x00000018ff697819ULL, 0x000fe4000001143eULL,
0x00000018ff057819ULL, 0x000fc40000011441ULL, 0x00000018ff6d7819ULL, 0x000fe2000001143fULL,
0x0000000400477306ULL, 0x000ff00000209400ULL, 0x0000000400627306ULL, 0x000fe20000205400ULL,
0x000000675400720bULL, 0x002fe20003f7d000ULL, 0x0001000040547824ULL, 0x000fcc00078e00ffULL,
0x00000004005d7306ULL, 0x0003f0000020d400ULL, 0x0000001200457306ULL, 0x000fe20000209400ULL,
0x00000018ff047819ULL, 0x002fce000001143bULL, 0x0000001200467306ULL, 0x000ff00000205400ULL,
0x00000012005a7306ULL, 0x000ff0000020d400ULL, 0x00000060005c7306ULL, 0x000ff00000209400ULL,
0x0000006000597306ULL, 0x000ff00000205400ULL, 0x0000006000137306ULL, 0x000ff0000020d400ULL,
0x0000006900487306ULL, 0x000ff00000209400ULL, 0x00000069004a7306ULL, 0x000ff00000205400ULL,
0x0000006900127306ULL, 0x000ff0000020d400ULL, 0x0000000e004b7306ULL, 0x000ff00000209400ULL,
0x0000000e006a7306ULL, 0x000ff00000205400ULL, 0x0000000e00617306ULL, 0x0003f0000020d400ULL,
0x0000004100607306ULL, 0x000fe20000009400ULL, 0x00000018ff0e7819ULL, 0x002fce000001143aULL,
0x0000004100697306ULL, 0x000e700000005400ULL, 0x0000000400577306ULL, 0x000ff00000209400ULL,
0x0000000400587306ULL, 0x000fe20000205400ULL, 0x000000696000720bULL, 0x002fe20003f9d000ULL,
0x0001000041697824ULL, 0x000fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011469ULL,
0x0000000400567306ULL, 0x0003f0000020d400ULL, 0x00000003004c7306ULL, 0x000fe20000209400ULL,
0x0000010040047824ULL, 0x002fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011404ULL,
0x00000003004f7306ULL, 0x000e700000205400ULL, 0x00000003004e7306ULL, 0x000eb0000020d400ULL,
0x0000000500637306ULL, 0x000fe20000209400ULL, 0x0000004f4c00720bULL, 0x002fce0003f5d000ULL,
0x0000000500687306ULL, 0x000fec0000205400ULL, 0x000000014e4e2812ULL, 0x004fe400078efcffULL,
0x00000005004d7306ULL, 0x0003e2000020d400ULL, 0x0000006a4b00720bULL, 0x000fce0003f5d000ULL,
0x0000000e00037306ULL, 0x000fe20000209400ULL, 0x00000018ff057819ULL, 0x002fca0000011438ULL,
0x0000000161612812ULL, 0x000fe400078efcffULL, 0x0000000e00527306ULL, 0x000e700000205400ULL,
0x0000000e00557306ULL, 0x000eb0000020d400ULL, 0x0000006d00497306ULL, 0x000fe20000209400ULL,
0x000000520300720bULL, 0x002fce0003f5d000ULL, 0x0000006d00157306ULL, 0x000fec0000205400ULL,
0x0000000155552812ULL, 0x004fe400078efcffULL, 0x0000006d000e7306ULL, 0x0003f0000020d400ULL,
0x0000000500537306ULL, 0x000fe20000209400ULL, 0x00000018ff6d7819ULL, 0x002fce0000011454ULL,
0x0000000500647306ULL, 0x000ff00000205400ULL, 0x00000005005b7306ULL, 0x0003f0000020d400ULL,
0x0000006b006e7306ULL, 0x000fe20000209400ULL, 0x00000018ff057819ULL, 0x002fce000001143cULL,
0x0000006b00657306ULL, 0x000e700000205400ULL, 0x0000006d00547306ULL, 0x000ff00000209400ULL,
0x0000006d00677306ULL, 0x000ea20000205400ULL, 0x000000656e00720bULL, 0x002fce0003fdd000ULL,
0x0000000500507306ULL, 0x000ff00000209400ULL, 0x0000000500517306ULL, 0x000fe20000205400ULL,
0x000000675400720bULL, 0x004fce0003fbd000ULL, 0x0000000500147306ULL, 0x000ff0000020d400ULL,
0x0000004000057306ULL, 0x0002b0000000d400ULL, 0x0000006b00047306ULL, 0x0006a2000020d400ULL,
0x0000010041407824ULL, 0x002fce00078e00ffULL, 0x0000006d004f7306ULL, 0x000e62000020d400ULL,
0x00000018ff6b7819ULL, 0x008fe40000011440ULL, 0x0000000105053812ULL, 0x004fca00078efcffULL,
0x0000006f00697306ULL, 0x000fe20000209400ULL, 0x0000000104046812ULL, 0x000fe400078efcffULL,
0x000000686300720bULL, 0x000fe40003fdd000ULL, 0x000000050404723eULL, 0x000fc600000010ffULL,
0x0000006f00747306ULL, 0x000ea20000205400ULL, 0x000000014f4f5812ULL, 0x002fce00078efcffULL,
0x0000006b00407306ULL, 0x000fe20000209400ULL, 0x000000014d4d6812ULL, 0x000fce00078efcffULL,
0x0000006b00657306ULL, 0x000e620000205400ULL, 0x000000746900720bULL, 0x004fce0003fbd000ULL,
0x00000041004c7306ULL, 0x0004f0000000d400ULL, 0x0000006f00547306ULL, 0x000ee2000020d400ULL,
0x0000010042417824ULL, 0x004fe200078e00ffULL, 0x000000654000720bULL, 0x002fe20003f7d000ULL,
0x0000010043407824ULL, 0x000fc600078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011441ULL,
0x0000006b00607306ULL, 0x0002a2000020d400ULL, 0x000000014c4c4812ULL, 0x008fe400078efcffULL,
0x000000645300720bULL, 0x000fca0003f9d000ULL, 0x0000006700417306ULL, 0x000fe20000209400ULL,
0x00000018ff6b7819ULL, 0x002fe40000011440ULL, 0x0000000154545812ULL, 0x000fca00078efcffULL,
0x00000067006e7306ULL, 0x000e620000205400ULL, 0x0000000160603812ULL, 0x004fe400078efcffULL,
0x000000624700720bULL, 0x000fe40003f7d000ULL, 0x0000004c6005723eULL, 0x000fe400000010ffULL,
0x000000015b5b4812ULL, 0x000fe200078efcffULL, 0x0000006700687306ULL, 0x000eb0000020d400ULL,
0x0000004200657306ULL, 0x000fe20000009400ULL, 0x0000006e4100720bULL, 0x002fe20003fbd000ULL,
0x0001000042417824ULL, 0x000fe200078e00ffULL, 0x000000015d5d3812ULL, 0x000fc800078efcffULL,
0x00000018ff477819ULL, 0x000fe20000011441ULL, 0x0000004200747306ULL, 0x000e6c0000005400ULL,
0x0000000168685812ULL, 0x004fe400078efcffULL, 0x0000006b00637306ULL, 0x000ff00000209400ULL,
0x0000006b00407306ULL, 0x000ea20000205400ULL, 0x000000746500720bULL, 0x002fce0003fdd000ULL,
0x0000004200697306ULL, 0x0002f0000000d400ULL, 0x00000043004b7306ULL, 0x000fe20000009400ULL,
0x000000406300720bULL, 0x004fe20003fbd000ULL, 0x0001000043427824ULL, 0x002fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011442ULL, 0x0000004300627306ULL, 0x000e620000005400ULL,
0x0000000169696812ULL, 0x008fe200078efcffULL, 0x0000001002427824ULL, 0x000fcc00078e026cULL,
0x0000006b00677306ULL, 0x000eb0000020d400ULL, 0x0000004700417306ULL, 0x000fe20000209400ULL,
0x000000624b00720bULL, 0x002fe20003fdd000ULL, 0x0000010038627824ULL, 0x000fca00078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0000004700407306ULL, 0x000e620000205400ULL,
0x0000000167675812ULL, 0x004fce00078efcffULL, 0x00000043006a7306ULL, 0x0004f0000000d400ULL,
0x0000004700637306ULL, 0x0006e2000020d400ULL, 0x000000404100720bULL, 0x002fe40003fbd000ULL,
0x000000004240783bULL, 0x004e6a0000004200ULL, 0x0000005300657306ULL, 0x000fe20000209400ULL,
0x000000016a6a6812ULL, 0x008fc400078efcffULL, 0x000000464500720bULL, 0x000fe40003fdd000ULL,
0x012000004444783bULL, 0x000ea60000000200ULL, 0x0000005300027306ULL, 0x000ee20000205400ULL,
0x0000000163635812ULL, 0x000fce00078efcffULL, 0x0000005300647306ULL, 0x000e62000020d400ULL,
0x000000015a5a6812ULL, 0x000fe400078efcffULL, 0x000000026500720bULL, 0x008fe20003fbd000ULL,
0x0000010039657824ULL, 0x000fc800078e00ffULL, 0x00000062004b7306ULL, 0x000fe20000209400ULL,
0x00000018ff657819ULL, 0x000fce0000011465ULL, 0x0000006500027306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x002fe40000011440ULL, 0x0000000164645812ULL, 0x000fca00078efcffULL,
0x00000065006d7306ULL, 0x000e620000205400ULL, 0x0000000744448231ULL, 0x084fe400003400ffULL,
0x0000000746468231ULL, 0x000fe400003400ffULL, 0x0000000645458231ULL, 0x000fc600003400ffULL,
0x00000062006e7306ULL, 0x000ea20000205400ULL, 0x0000000647478231ULL, 0x000fce00003400ffULL,
0x0000006200627306ULL, 0x000ee2000020d400ULL, 0x0000006d0200720bULL, 0x002fe20003f7d000ULL,
0x000000044418723cULL, 0x000bec0000041818ULL, 0x00000038006b7306ULL, 0x000fe20000009400ULL,
0x0000006e4b00720bULL, 0x004fe40003fbd000ULL, 0x0000004f4e04723eULL, 0x020fc400000010ffULL,
0x000000544d05723eULL, 0x000fe400000010ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011441ULL,
0x00000038006d7306ULL, 0x000e620000005400ULL, 0x00000018ff4f7819ULL, 0x000fc60000011442ULL,
0x00000004441c723cULL, 0x000b64000004181cULL, 0x0000000162625812ULL, 0x008fe400078efcffULL,
0x0000006500607306ULL, 0x000ea2000020d400ULL, 0x0000006d6b00720bULL, 0x002fe20003fbd000ULL,
0x00010000386d7824ULL, 0x000fcc00078e00ffULL, 0x0000003800657306ULL, 0x000e62000000d400ULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000000160603812ULL, 0x004fca00078efcffULL,
0x0000006d00387306ULL, 0x000ff00000209400ULL, 0x0000006d00057306ULL, 0x020ea20000205400ULL,
0x0000000165655812ULL, 0x002fce00078efcffULL, 0x00000039006b7306ULL, 0x000ff00000009400ULL,
0x00000039004e7306ULL, 0x000e620000005400ULL, 0x000000053800720bULL, 0x004fe40003f7d000ULL,
0x000000696838723eULL, 0x000fe200000010ffULL, 0x0001000039697824ULL, 0x000fc800078e00ffULL,
0x0000006f00527306ULL, 0x000fe20000209400ULL, 0x0000004e6b00720bULL, 0x002fce0003fbd000ULL,
0x0000006f00537306ULL, 0x000ff00000205400ULL, 0x00000039006b7306ULL, 0x0002b0000000d400ULL,
0x0000006f00037306ULL, 0x0007e2000020d400ULL, 0x0000006a6739723eULL, 0x002fc400000010ffULL,
0x00000018ff677819ULL, 0x000fca0000011469ULL, 0x0000006700697306ULL, 0x000fe20000209400ULL,
0x000000384420723cULL, 0x000be20000041820ULL, 0x000000016b6b5812ULL, 0x004fcc00078efcffULL,
0x00000067006a7306ULL, 0x000e620000205400ULL, 0x000001003a387824ULL, 0x020fe200078e00ffULL,
0x000000645d39723eULL, 0x000fc800000010ffULL, 0x00000018ff6f7819ULL, 0x008fe40000011438ULL,
0x000000636138723eULL, 0x000fe200000010ffULL, 0x0000006e004b7306ULL, 0x000fec0000209400ULL,
0x000000384424723cULL, 0x000b620000041824ULL, 0x0000006a6900720bULL, 0x002fe20003fbd000ULL,
0x0000006e004c7306ULL, 0x000fea0000205400ULL, 0x000001003b397824ULL, 0x020fc600078e00ffULL,
0x0000006e00027306ULL, 0x0003e4000020d400ULL, 0x00000018ff397819ULL, 0x000fcc0000011439ULL,
0x0000004f004d7306ULL, 0x000fe20000209400ULL, 0x00000018ff6e7819ULL, 0x002fce0000011443ULL,
0x0000004f00547306ULL, 0x000ff00000205400ULL, 0x0000004f00047306ULL, 0x000ff0000020d400ULL,
0x0000006700677306ULL, 0x000e70000020d400ULL, 0x0000006e004e7306ULL, 0x000ff00000209400ULL,
0x0000006e004f7306ULL, 0x000fe20000205400ULL, 0x0000000167675812ULL, 0x002fce00078efcffULL,
0x0000006e00057306ULL, 0x000ff0000020d400ULL, 0x0000006d00687306ULL, 0x000e70000020d400ULL,
0x0000003b00697306ULL, 0x000ff00000009400ULL, 0x0000003b00387306ULL, 0x000ea20000005400ULL,
0x0000000168683812ULL, 0x002fce00078efcffULL, 0x0000006f006d7306ULL, 0x000ff00000209400ULL,
0x0000006f006e7306ULL, 0x000e620000205400ULL, 0x000000386900720bULL, 0x004fe20003fbd000ULL,
0x000100003a387824ULL, 0x000fcc00078e00ffULL, 0x0000003a00637306ULL, 0x000ff00000009400ULL,
0x0000003a00647306ULL, 0x000ea20000005400ULL, 0x0000006e6d00720bULL, 0x002fce0003f7d000ULL,
0x00000039006d7306ULL, 0x000ff00000209400ULL, 0x00000039006e7306ULL, 0x000e620000205400ULL,
0x000000646300720bULL, 0x004fce0003f9d000ULL, 0x0000006f00617306ULL, 0x0004f0000020d400ULL,
0x0000003b00697306ULL, 0x0006e2000000d400ULL, 0x00000018ff6f7819ULL, 0x004fe20000011438ULL,
0x000100003b387824ULL, 0x000fe200078e00ffULL, 0x0000006e6d00720bULL, 0x002fca0003fdd000ULL,
0x00000039005d7306ULL, 0x0002a2000020d400ULL, 0x00000018ff3b7819ULL, 0x008fe40000011438ULL,
0x000000656238723eULL, 0x000fe400000010ffULL, 0x0000000161613812ULL, 0x000fc600078efcffULL,
0x0000003a006a7306ULL, 0x000ee2000000d400ULL, 0x0000006b6039723eULL, 0x002fe400000010ffULL,
0x0000000169695812ULL, 0x000fe400078efcffULL, 0x000000585700720bULL, 0x000fc60003fbd000ULL,
0x0000006f00637306ULL, 0x000fe20000209400ULL, 0x000000384428723cULL, 0x000be20000041828ULL,
0x000000015d5d6812ULL, 0x004fcc00078efcffULL, 0x0000006f00647306ULL, 0x000e620000205400ULL,
0x000000685b38723eULL, 0x020fe200000010ffULL, 0x000001003c687824ULL, 0x000fe200078e00ffULL,
0x000000675a39723eULL, 0x000fe400000010ffULL, 0x000000016a6a4812ULL, 0x008fe400078efcffULL,
0x0000000156565812ULL, 0x000fe200078efcffULL, 0x0000003b00627306ULL, 0x000fe20000209400ULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x00000038442c723cULL, 0x000b6c000004182cULL,
0x0000003b00657306ULL, 0x000ea20000205400ULL, 0x000100003c387824ULL, 0x020fe200078e00ffULL,
0x000000646300720bULL, 0x002fc40003f7d000ULL, 0x000000695d39723eULL, 0x000fc800000010ffULL,
0x0000006f003a7306ULL, 0x0002f0000020d400ULL, 0x0000003b003b7306ULL, 0x000ee2000020d400ULL,
0x000000656200720bULL, 0x004fe40003f9d000ULL, 0x00000018ff6f7819ULL, 0x002fc40000011438ULL,
0x0000006a6138723eULL, 0x000fe400000010ffULL, 0x000000013a3a3812ULL, 0x008fe200078efcffULL,
0x0000003d00587306ULL, 0x000fe80000009400ULL, 0x000000384430723cULL, 0x000be40000041830ULL,
0x000000013b3b4812ULL, 0x000fe400078efcffULL, 0x0000003d005d7306ULL, 0x000e660000005400ULL,
0x000001003d387824ULL, 0x060fe200078e00ffULL, 0x0000003b5639723eULL, 0x000fe200000010ffULL,
0x000100003d3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011438ULL,
0x0000003d00577306ULL, 0x0004e2000000d400ULL, 0x0000003a5538723eULL, 0x000fe400000010ffULL,
0x00000018ff3b7819ULL, 0x000fca000001143bULL, 0x000000384434723cULL, 0x000b620000041834ULL,
0x0000003c00607306ULL, 0x000fe20000009400ULL, 0x0000005d5800720bULL, 0x002fca0003fdd000ULL,
0x000001003e387824ULL, 0x020fe400078e00ffULL, 0x0000003e00397306ULL, 0x000fe20000005400ULL,
0x000001003f447824ULL, 0x000fe400078e00ffULL, 0x00000018ff3d7819ULL, 0x004fc60000011438ULL,
0x0000000157576812ULL, 0x008fe400078efcffULL, 0x0000003e00387306ULL, 0x000e700000009400ULL,
0x0000003c005b7306ULL, 0x000eb00000005400ULL, 0x0000006800677306ULL, 0x000fe20000209400ULL,
0x000000393800720bULL, 0x002fe20003f7d000ULL, 0x000100003f397824ULL, 0x000fc400078e00ffULL,
0x000100003e387824ULL, 0x000fc800078e00ffULL, 0x00000068006b7306ULL, 0x000e620000205400ULL,
0x0000005b6000720bULL, 0x004fe20003fbd000ULL, 0x0000010041607824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc80000011438ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000003e005b7306ULL, 0x0004f0000000d400ULL, 0x0000006f006e7306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x004fc40000011439ULL, 0x000000070c397812ULL, 0x000fe400078ec0ffULL,
0x0000006b6700720bULL, 0x002fe40003f5d000ULL, 0x0000000839397812ULL, 0x000fe200078ef80cULL,
0x0000006f006d7306ULL, 0x000e620000205400ULL, 0x000000015b5b3812ULL, 0x008fce00078efcffULL,
0x0000003c005a7306ULL, 0x000eb0000000d400ULL, 0x00000038005d7306ULL, 0x000fe20000209400ULL,
0x0000006d6e00720bULL, 0x002fce0003f9d000ULL, 0x0000003800677306ULL, 0x000e620000205400ULL,
0x000000015a5a5812ULL, 0x004fe400078efcffULL, 0x000000515000720bULL, 0x000fca0003fbd000ULL,
0x0000003800587306ULL, 0x0004f0000020d400ULL, 0x0000003d00647306ULL, 0x000fe20000209400ULL,
0x0000000839387824ULL, 0x004fe200078e00ffULL, 0x0000000114145812ULL, 0x000fe200078efcffULL,
0x0000020000397824ULL, 0x000fe200078e00ffULL, 0x000000595c00720bULL, 0x000fc40003fbd000ULL,
0x000000675d00720bULL, 0x002fe40003f7d000ULL, 0x0000003d00657306ULL, 0x000ff00000205400ULL,
0x0000003d00457306ULL, 0x0003e2000020d400ULL, 0x0000000113135812ULL, 0x000fc400078efcffULL,
0x000000154900720bULL, 0x000fe20003fbd000ULL, 0x0000010042157824ULL, 0x000fe200078e00ffULL,
0x0000000158583812ULL, 0x008fe400078efcffULL, 0x000000535200720bULL, 0x000fe20003f7d000ULL,
0x00000068003c7306ULL, 0x000ea2000020d400ULL, 0x000000025f3d7810ULL, 0x002fe20007ffe0ffULL,
0x0001000042537824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0xfffffff8383d7812ULL, 0x000fe200078ee23dULL, 0x0000010040387824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000006f00687306ULL, 0x0002e2000020d400ULL,
0x000000010e0e5812ULL, 0x000fc400078efcffULL, 0x00000018ff507819ULL, 0x000fe40000011438ULL,
0xfffff80039387812ULL, 0x000fe400078ec0ffULL, 0x0000000103033812ULL, 0x000fe200078efcffULL,
0x0000003b00567306ULL, 0x000fe20000209400ULL, 0x000000013c3c2812ULL, 0x004fe200078efcffULL,
0x000000103d387824ULL, 0x000fe200078e0238ULL, 0x00000018ff6f7819ULL, 0x002fe40000011444ULL,
0x000000544d00720bULL, 0x000fc60003f7d000ULL, 0x0000003b006a7306ULL, 0x000e620000205400ULL,
0x0000000168684812ULL, 0x008fc800078efcffULL, 0x000000681468723eULL, 0x000fc600000010ffULL,
0x0000003b00697306ULL, 0x000ea4000020d400ULL, 0x0000000104043812ULL, 0x000fcc00078efcffULL,
0x0000006200617306ULL, 0x000fe20000209400ULL, 0x0000006a5600720bULL, 0x002fce0003fdd000ULL,
0x00000062003a7306ULL, 0x000e6c0000205400ULL, 0x0000000169696812ULL, 0x004fe400078efcffULL,
0x0000003f003b7306ULL, 0x000fe20000009400ULL, 0x000000656400720bULL, 0x000fe40003fdd000ULL,
0x000000691369723eULL, 0x000fca00000010ffULL, 0x0000003f00467306ULL, 0x000ea20000005400ULL,
0x0000003a6100720bULL, 0x002fca0003f9d000ULL, 0x0000000145456812ULL, 0x000fe400078efcffULL,
0x0000006200557306ULL, 0x000e62000020d400ULL, 0x000000463b00720bULL, 0x004fce0003f5d000ULL,
0x0000006f00637306ULL, 0x000fe20000209400ULL, 0x012000003838783bULL, 0x000ea20000000200ULL,
0x0000000155554812ULL, 0x002fcc00078efcffULL, 0x0000006f00627306ULL, 0x000e620000205400ULL,
0x0000004a4800720bULL, 0x000fe20003f9d000ULL, 0x00010000404a7824ULL, 0x000fe200078e00ffULL,
0x000000575557723eULL, 0x000fc800000010ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001144aULL,
0x0000004000597306ULL, 0x000fec0000009400ULL, 0x0000000112124812ULL, 0x000fe400078efcffULL,
0x0000004000487306ULL, 0x000ee20000005400ULL, 0x000000626300720bULL, 0x002fc40003fdd000ULL,
0x000000581212723eULL, 0x000fca00000010ffULL, 0x0000006f00447306ULL, 0x000e70000020d400ULL,
0x0000003e00517306ULL, 0x000fe20000209400ULL, 0x0000000738388231ULL, 0x084fe400003400ffULL,
0x000000073a3a8231ULL, 0x000fc400003400ffULL, 0x0000000639398231ULL, 0x080fe400003400ffULL,
0x000000063b3b8231ULL, 0x000fe200003400ffULL, 0x0000003e00747306ULL, 0x000ea20000205400ULL,
0x000000485900720bULL, 0x008fe40003f1d000ULL, 0x0000000144446812ULL, 0x002fc600078efcffULL,
0x00000068381c723cULL, 0x000f64000004181cULL, 0x0000003f00477306ULL, 0x000e70000000d400ULL,
0x00000050006e7306ULL, 0x000fe20000209400ULL, 0x000000745100720bULL, 0x004fe20003fdd000ULL,
0x0000010043517824ULL, 0x000fca00078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011451ULL,
0x00000050006b7306ULL, 0x000ea20000205400ULL, 0x0000000147472812ULL, 0x002fce00078efcffULL,
0x00000050003f7306ULL, 0x000e70000020d400ULL, 0x0000003e00467306ULL, 0x000ee2000020d400ULL,
0x0000006b6e00720bULL, 0x004fce0003f9d000ULL, 0x0000004000507306ULL, 0x0004ec000000d400ULL,
0x000000013f3f4812ULL, 0x002fe400078efcffULL, 0x00000060006d7306ULL, 0x000fe20000209400ULL,
0x0001000041407824ULL, 0x004fe200078e00ffULL, 0x0000000146466812ULL, 0x008fc800078efcffULL,
0x00000018ff757819ULL, 0x000fe40000011440ULL, 0x00000060006f7306ULL, 0x000e620000205400ULL,
0x0000000150500812ULL, 0x000fe400078efcffULL, 0x000000460e13723eULL, 0x000fe400000010ffULL,
0x000000503f50723eULL, 0x000fc600000010ffULL, 0x0000005c006a7306ULL, 0x000fe40000209400ULL,
0x000000123824723cULL, 0x000b6c0000041824ULL, 0x0000005c00657306ULL, 0x000ea20000205400ULL,
0x0000006f6d00720bULL, 0x002fe40003fdd000ULL, 0x000176c871127811ULL, 0x020fca00078e18ffULL,
0x0000004100567306ULL, 0x000ff00000009400ULL, 0x0000004100597306ULL, 0x000e620000005400ULL,
0x000000656a00720bULL, 0x004fce0003f1d000ULL, 0x0000004200497306ULL, 0x000ff00000009400ULL,
0x0000004200627306ULL, 0x000ea20000005400ULL, 0x000000595600720bULL, 0x002fe40003f5d000ULL,
0x0000005a3c56723eULL, 0x000fe200000010ffULL, 0x00010000435a7824ULL, 0x000fc800078e00ffULL,
0x00000060003e7306ULL, 0x000e62000020d400ULL, 0x00000018ff147819ULL, 0x000fe2000001145aULL,
0x000000563818723cULL, 0x000b6c0000041818ULL, 0x0000005c004a7306ULL, 0x000ee2000020d400ULL,
0x000000624900720bULL, 0x004fce0003fbd000ULL, 0x0000007500617306ULL, 0x000fe20000209400ULL,
0x000000013e3e6812ULL, 0x002fce00078efcffULL, 0x0000007500647306ULL, 0x000e620000205400ULL,
0x000000014a4a0812ULL, 0x008fc800078efcffULL, 0x0000004a034a723eULL, 0x000fc600000010ffULL,
0x00000015005c7306ULL, 0x000ff00000209400ULL, 0x0000001500607306ULL, 0x000ea20000205400ULL,
0x000000646100720bULL, 0x002fce0003fdd000ULL, 0x0000004100487306ULL, 0x000e70000000d400ULL,
0x0000004200497306ULL, 0x000662000000d400ULL, 0x000000605c00720bULL, 0x004fce0003f1d000ULL,
0x0000007500407306ULL, 0x000ea2000020d400ULL, 0x0000005b4542723eULL, 0x008fe400000010ffULL,
0x0000000148482812ULL, 0x002fe400078efcffULL, 0x0000004c4b00720bULL, 0x000fc60003f5d000ULL,
0x0000001500417306ULL, 0x000e62000020d400ULL, 0x0000000149495812ULL, 0x000fce00078efcffULL,
0x0000005300527306ULL, 0x000fe20000209400ULL, 0x0000000140406812ULL, 0x004fe400078efcffULL,
0x0000004f4e00720bULL, 0x000fe40003fdd000ULL, 0x0000000102022812ULL, 0x000fc600078efcffULL,
0x0000005300557306ULL, 0x000ea20000205400ULL, 0x0000000141410812ULL, 0x002fe400078efcffULL,
0x00000040024b723eULL, 0x000fe400000010ffULL, 0x000000494102723eULL, 0x000fc600000010ffULL,
0x0000001400567306ULL, 0x020fe20000209400ULL, 0x0000000105056812ULL, 0x000fe200078efcffULL,
0x0000004a382c723cULL, 0x000f6c000004182cULL, 0x0000001400457306ULL, 0x000e620000205400ULL,
0x000000555200720bULL, 0x004fce0003f1d000ULL, 0x0000005300537306ULL, 0x000eb0000020d400ULL,
0x0000001400147306ULL, 0x000ee2000020d400ULL, 0x000000455600720bULL, 0x002fce0003fbd000ULL,
0x0000006300517306ULL, 0x000fe20000209400ULL, 0x0000000153530812ULL, 0x004fc800078efcffULL,
0x000000530404723eULL, 0x000fc600000010ffULL, 0x0000006300597306ULL, 0x000e620000205400ULL,
0x0000000114145812ULL, 0x008fc800078efcffULL, 0x000000140505723eULL, 0x000fc600000010ffULL,
0x00000043005d7306ULL, 0x000fe80000009400ULL, 0x000000043834723cULL, 0x000f680000041834ULL,
0x00000043006e7306ULL, 0x000ea20000005400ULL, 0x000000595100720bULL, 0x002fe40003f5d000ULL,
0x000000483e51723eULL, 0x000fca00000010ffULL, 0x0000006300157306ULL, 0x000e64000020d400ULL,
0x000000503828723cULL, 0x000f6c0000041828ULL, 0x00000043003c7306ULL, 0x0006e2000000d400ULL,
0x0000006e5d00720bULL, 0x004fe40003f9d000ULL, 0x0000000115152812ULL, 0x002fc400078efcffULL,
0x000000474443723eULL, 0x008fd200000010ffULL, 0x000000013c3c4812ULL, 0x000fe200078efcffULL,
0x000000423820723cULL, 0x000f660000041820ULL, 0x0000003c1503723eULL, 0x000fce00000010ffULL,
0x000000023830723cULL, 0x000b6e0000041830ULL, 0x0001769879027811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000002ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0e7224ULL, 0x000fc600078e00ffULL, 0x0000000000027805ULL, 0x004fc80000015200ULL,
0x000004000a057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x006fc40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402157210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000001504047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010b027810ULL, 0x000fc80007ffe0ffULL,
0x000000730200720cULL, 0x000fda0003f06070ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x000000020b027810ULL, 0x000fe20007ffe0ffULL, 0x000059000d0a7a24ULL, 0x010fe200078e02ffULL,
0x0000010011117810ULL, 0x000fe40007ffe0ffULL, 0x000000730200720cULL, 0x000fe20003f06070ULL,
0x000000800a0a7824ULL, 0x000fe200078e00ffULL, 0x0000006011037812ULL, 0x000fca00078ec0ffULL,
0x0000000172037824ULL, 0x000fcc00078e0203ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000001170027217ULL, 0x000fe20007800000ULL, 0x0000001000047824ULL, 0x000fc800078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e0a11ULL, 0x0000001004057812ULL, 0x000fe400078ec0ffULL,
0x00000003ff047819ULL, 0x000fe4000001160cULL, 0x0000000205027217ULL, 0x000fe40007800000ULL,
0x00000004040e7810ULL, 0x040fe40007ffe0ffULL, 0x0000000804117810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x100fe200078e0a05ULL, 0x0000000c04127810ULL, 0x000fe20007ffe0ffULL,
0x000000010e147824ULL, 0x000fc400078e0205ULL, 0x0000000111137824ULL, 0x140fe200078e0205ULL,
0x000000020400720cULL, 0x0c0fe20003f86070ULL, 0x0000000104047824ULL, 0x000fe200078e0205ULL,
0x000000020e00720cULL, 0x080fe20003f66070ULL, 0x0000000814387824ULL, 0x000fe200078e00ffULL,
0x000000021100720cULL, 0x080fe20003f46070ULL, 0x00000001040e7824ULL, 0x100fe200078e020cULL,
0x000000021200720cULL, 0x000fe20003f06070ULL, 0x00000008043b7824ULL, 0x000fe400078e00ffULL,
0x0000000114117824ULL, 0x000fc400078e020cULL, 0x0000000112157824ULL, 0x000fe200078e0205ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL, 0x0000000104127824ULL, 0x000fe200078e0203ULL,
0xfffffff8383f7812ULL, 0x000fe200078ee211ULL, 0x0000000114147824ULL, 0x100fe200078e0203ULL,
0x000062000a117a11ULL, 0x040fe200078a38ffULL, 0x0000000113027824ULL, 0x040fe400078e0203ULL,
0x0000000113057824ULL, 0x040fe200078e020cULL, 0x000063000a397a11ULL, 0x000fe200028f3cffULL,
0x00000008130e7824ULL, 0x000fc400078e00ffULL, 0x0000000115047824ULL, 0x040fe400078e0203ULL,
0x0000000115037824ULL, 0x040fe200078e020cULL, 0xfffffff80e417812ULL, 0x000fe200078ee205ULL,
0x0000000815387824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff838437812ULL, 0x000fe200078ee203ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000005e12127212ULL, 0x000fc600078efcffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x0000005e14147212ULL, 0x000fe400078efcffULL, 0x0000001211127210ULL, 0x000fe20007fbe0ffULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000001114147210ULL, 0x080fe40007fde0ffULL,
0x0000005e02027212ULL, 0x080fe200078efcffULL, 0x0000000113137824ULL, 0x100fe200028e0639ULL,
0x0000005e04047212ULL, 0x000fe200078efcffULL, 0x0000000115157824ULL, 0x000fe200030e0639ULL,
0x0000001102027210ULL, 0x080fe20007fbe0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e026cULL,
0x0000001104047210ULL, 0x000fe20007fde0ffULL, 0x000000103f3f7824ULL, 0x000fc400078e026cULL,
0x0000001041417824ULL, 0x100fe200078e026cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123b7faeULL, 0x0003e2000e101c48ULL, 0x0000000103037824ULL, 0x100fe400028e0639ULL,
0x0000001043437824ULL, 0x000fe200078e026cULL, 0x00000000143f7faeULL, 0x0003e2000d901c48ULL,
0x0000000105057824ULL, 0x000fc600030e0639ULL, 0x0000000002417faeULL, 0x0003e8000d101c48ULL,
0x0000000004437faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x000062000a397a11ULL, 0x000fc800078038ffULL,
0x0000001002057812ULL, 0x000fe400078ec0ffULL, 0x000063000a3b7a11ULL, 0x000fe400000f3cffULL,
0x000000050c057211ULL, 0x000fc800078fe8ffULL, 0x00000004050e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105047824ULL, 0x140fe200078e020cULL, 0x0000000805137810ULL, 0x040fe20007ffe0ffULL,
0x0000000805117824ULL, 0x040fe200078e00ffULL, 0x0000000c05157810ULL, 0x040fe20007ffe0ffULL,
0x0000000105027824ULL, 0x100fe400078e0203ULL, 0x000000010e057824ULL, 0x040fe200078e020cULL,
0xfffffff811117812ULL, 0x000fe200078ee204ULL, 0x000000010e047824ULL, 0x040fe400078e0203ULL,
0x000000080e387824ULL, 0x000fc400078e00ffULL, 0x0000000113127824ULL, 0x100fe400078e0203ULL,
0x0000000115147824ULL, 0x000fe200078e0203ULL, 0xfffffff8383f7812ULL, 0x000fe200078ee205ULL,
0x00000001130e7824ULL, 0x040fe400078e020cULL, 0x0000000813417824ULL, 0x000fe400078e00ffULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee20eULL,
0x0000000115137824ULL, 0x040fe200078e020cULL, 0x0000005e02027212ULL, 0x000fe200078efcffULL,
0x00000008153a7824ULL, 0x000fe400078e00ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000000239027210ULL, 0x000fe40007f1e0ffULL, 0xfffffff83a437812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000005e04047212ULL, 0x000fc600078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000005e12127212ULL, 0x000fc600078efcffULL,
0x0000000103037824ULL, 0x100fe200000e063bULL, 0x0000005e14147212ULL, 0x000fe200078efcffULL,
0x0000001011117824ULL, 0x100fe200078e026cULL, 0x0000000439047210ULL, 0x000fe20007f1e0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e026cULL, 0x0000001239127210ULL, 0x000fe20007f5e0ffULL,
0x0000001041417824ULL, 0x000fe200078e026cULL, 0x0000001439147210ULL, 0x000fe20007f7e0ffULL,
0x0000000105057824ULL, 0x100fe200000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002117faeULL, 0x0003e2000b901c48ULL, 0x0000000113137824ULL, 0x000fc400010e063bULL,
0x0000001043437824ULL, 0x000fe200078e026cULL, 0x00000000043f7faeULL, 0x0003e2000b901c48ULL,
0x0000000115157824ULL, 0x000fc600018e063bULL, 0x0000000012417faeULL, 0x0003e8000b901c48ULL,
0x0000000014437faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000001071027824ULL, 0x000fe400078e00ffULL, 0x0000000800037824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x0000001002027812ULL, 0x000fc400078ee2ffULL,
0x0000000803037812ULL, 0x000fc600078ec0ffULL, 0x0000002079027824ULL, 0x000fc800078e0202ULL,
0x00000001030a7824ULL, 0x000fe200078e0202ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff027f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017668000a147f8cULL, 0x0004e2000c80043fULL,
0x000000ffff027224ULL, 0x002fc600078e0003ULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01766c000a037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012040e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e05ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011412ULL,
0x0000000e03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0612ULL,
0x0000000203037819ULL, 0x000fc8000000120eULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c000a037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018079037811ULL, 0x000fc800078e38ffULL, 0x000000037a037210ULL, 0x000fca0007ffe05eULL,
0x0170000003047984ULL, 0x000e680000000800ULL, 0x0172000003057984ULL, 0x0006a20000000800ULL,
0x000000090400720bULL, 0x002fe20003f1d000ULL, 0x0000c6627f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c117812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0a7424ULL, 0x004fe400078e00ffULL,
0x000000ffff037224ULL, 0x000fd200078e0009ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000379037810ULL, 0x000fe40007ffe0ffULL, 0x000000090400720bULL, 0x000fe40003f54000ULL,
0x000000000300720cULL, 0x000fe20003f05270ULL, 0x0000c6127f007947ULL, 0x000fd4000b800000ULL,
0x00000000000a7806ULL, 0x000fc400010e0100ULL, 0x0000008000138824ULL, 0x000fe200078e025eULL,
0x0000000904037209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099100a0e7816ULL, 0x000fe200000000ffULL, 0x000000017a7a8824ULL, 0x000fca00078e0213ULL,
0x017400037a008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000903097221ULL, 0x002fe20000010100ULL,
0x000000ff0aff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009000e7308ULL, 0x000e640000000800ULL,
0x0000000e0f0f7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe2000001160cULL, 0x0000c5527f007947ULL, 0x000fea000b800000ULL,
0x00001f140e3c7589ULL, 0x0002a400000e0000ULL, 0x0000003c18187220ULL, 0x084fe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000003c20207220ULL, 0x080fe40000410000ULL,
0x0000003c21217220ULL, 0x000fc40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c28287220ULL, 0x080fe40000410000ULL,
0x0000003c29297220ULL, 0x080fe40000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000003c2d2d7220ULL, 0x000fc40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x080fe40000410000ULL, 0x0000003c34347220ULL, 0x080fe40000410000ULL,
0x0000003c35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080c147811ULL, 0x002fe200078ff0ffULL, 0x0000c4527f007947ULL, 0x000fea000b800000ULL,
0x00001f140e3c7589ULL, 0x0002a400000e0000ULL, 0x0000003c1a1a7220ULL, 0x084fe40000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c22227220ULL, 0x080fe40000410000ULL,
0x0000003c23237220ULL, 0x000fc40000410000ULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000003c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x080fe40000410000ULL, 0x0000003c36367220ULL, 0x080fe40000410000ULL,
0x0000003c37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff11ff7812ULL, 0x000fe2000780600aULL, 0x00000001ff0a7424ULL, 0x000fd800078e00ffULL,
0x0000000403040221ULL, 0x000fe20000010100ULL, 0x00007610ff0a0816ULL, 0x000fc6000000000aULL,
0x3fb8aa3b04040820ULL, 0x000fc80000410000ULL, 0x0000000400080308ULL, 0x000e640000000800ULL,
0x0000000805050220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f050f7221ULL, 0x000fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x00000c04ff057984ULL, 0x000e620008000800ULL, 0x0000000400047824ULL, 0x000fe400078e00ffULL,
0x000000ffff147224ULL, 0x000fe400078e00ffULL, 0x000000047c097824ULL, 0x000fe200078e00ffULL,
0x0000000404047812ULL, 0x000fc800078ec0ffULL, 0x00000002040e7810ULL, 0x000fe40007ffe0ffULL,
0x8000000005ff7812ULL, 0x002fe20007804817ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e000eULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000412117210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e13ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000001104047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000c04ff057984ULL, 0x000e640008000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fc400078e000eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100a047816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0400720cULL, 0x000fda0003f65270ULL, 0x0000016000003947ULL, 0x000fea0003800000ULL,
0x00000008ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff117819ULL, 0x000fe4000001160cULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x0000bfd27f007947ULL, 0x000fea000b800000ULL,
0x00001f1104077589ULL, 0x0002a400000e0000ULL, 0x0000000811147810ULL, 0x000fe20007ffe0ffULL,
0x0000c0227f007947ULL, 0x000fea000b800000ULL, 0x00001f1404067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001011147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0004ULL, 0x0000cfb0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000c5b000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001811147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0004ULL,
0x0000d020003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x0000c54000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070c117812ULL, 0x042fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000379167810ULL, 0x000fe40007ffe0ffULL,
0x0000000811047812ULL, 0x008fe400078ef80cULL, 0x000000080c0e7812ULL, 0x000fe200078ec0ffULL,
0x0000080016167824ULL, 0x000fe400078e00ffULL, 0x0000000804047824ULL, 0x000fca00078e00ffULL,
0xfffffff8045f7812ULL, 0x000fca00078ee25fULL, 0x000000105f147824ULL, 0x000fc400078e0216ULL,
0x000000090c0a7211ULL, 0x000fe400078fe0ffULL, 0x000000110e157212ULL, 0x040fe400078efcffULL,
0x000000100e4d7812ULL, 0x000fe400078efe11ULL, 0x000000050c137211ULL, 0x000fe200078fe0ffULL,
0x0000000115047824ULL, 0x040fe400078e020aULL, 0x0000000815097824ULL, 0x000fe400078e00ffULL,
0x000000084d117824ULL, 0x000fc400078e00ffULL, 0x0000000115057824ULL, 0x000fe200078e0213ULL,
0xfffffff809097812ULL, 0x000fe200078ee204ULL, 0x000000014d047824ULL, 0x000fc800078e020aULL,
0x0000001009097824ULL, 0x000fe200078e0210ULL, 0xfffffff811117812ULL, 0x000fc800078ee204ULL,
0x000000000948783bULL, 0x000e620000004200ULL, 0x0000001011117824ULL, 0x000fca00078e0210ULL,
0x000000001144783bULL, 0x000ee20000004200ULL, 0x00000018ff0e7819ULL, 0x002fe20000011449ULL,
0x0000004800537306ULL, 0x000fe20000009400ULL, 0x00000018ff0a7819ULL, 0x000fe40000011448ULL,
0x00000018ff117819ULL, 0x008fe40000011444ULL, 0x00000018ff127819ULL, 0x000fc60000011445ULL,
0x0000000e00397306ULL, 0x000fe20000209400ULL, 0x00000018ff4e7819ULL, 0x000fe40000011447ULL,
0x00000018ff3f7819ULL, 0x000fca0000011446ULL, 0x0000000e00527306ULL, 0x000ff00000205400ULL,
0x0000000e00097306ULL, 0x0003f0000020d400ULL, 0x00000011003b7306ULL, 0x000fe20000209400ULL,
0x00000008150e7824ULL, 0x002fca00078e00ffULL, 0xfffffff80e057812ULL, 0x000fe200078ee205ULL,
0x000000014d0e7824ULL, 0x000fe200078e0213ULL, 0x0000001100547306ULL, 0x000fe60000205400ULL,
0x0000001005057824ULL, 0x000fca00078e0210ULL, 0x00000011004c7306ULL, 0x0003e2000020d400ULL,
0x000000000540783bULL, 0x0006ae0000004200ULL, 0x0000001200177306ULL, 0x000fe20000209400ULL,
0x000000084d117824ULL, 0x002fe200078e00ffULL, 0x00000018ff057819ULL, 0x008fc8000001144bULL,
0xfffffff811117812ULL, 0x000fe400078ee20eULL, 0x00000012003a7306ULL, 0x000fe60000205400ULL,
0x0000001011117824ULL, 0x000fca00078e0210ULL, 0x00000012003e7306ULL, 0x0003f0000020d400ULL,
0x0000004800587306ULL, 0x000ee20000005400ULL, 0x000000001110783bULL, 0x002e6e0000004200ULL,
0x0000000a005b7306ULL, 0x000fe20000209400ULL, 0x00000018ff577819ULL, 0x004fc40000011441ULL,
0x00000018ff617819ULL, 0x000fe40000011443ULL, 0x00000018ff5a7819ULL, 0x000fc60000011442ULL,
0x0000000a00047306ULL, 0x000ea20000205400ULL, 0x000000585300720bULL, 0x008fe20003fbd000ULL,
0x0001000048537824ULL, 0x000fcc00078e00ffULL, 0x0000000a00597306ULL, 0x000670000020d400ULL,
0x0000005700637306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x008fe4000001144aULL,
0x000000045b00720bULL, 0x004fe20003f5d000ULL, 0x00010000495b7824ULL, 0x000fc800078e00ffULL,
0x0000005700647306ULL, 0x000fe20000205400ULL, 0x00000018ff6d7819ULL, 0x002fe40000011410ULL,
0x00000018ff757819ULL, 0x000fca000001145bULL, 0x0000005700557306ULL, 0x0003e2000020d400ULL,
0x0000000159592812ULL, 0x000fce00078efcffULL, 0x0000000a00157306ULL, 0x000fe20000209400ULL,
0x0000010048577824ULL, 0x002fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe40000011457ULL,
0x0000000a00387306ULL, 0x000ff00000205400ULL, 0x0000000a005f7306ULL, 0x0003f0000020d400ULL,
0x0000004e004d7306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x002fce0000011440ULL,
0x0000004e00747306ULL, 0x000ff00000205400ULL, 0x0000004e000e7306ULL, 0x000ff0000020d400ULL,
0x0000000500677306ULL, 0x000ff00000209400ULL, 0x00000005006e7306ULL, 0x000ff00000205400ULL,
0x00000005005e7306ULL, 0x000ff0000020d400ULL, 0x0000006100057306ULL, 0x000ff00000209400ULL,
0x00000061005d7306ULL, 0x000ff00000205400ULL, 0x00000061004e7306ULL, 0x000ff0000020d400ULL,
0x0000004900617306ULL, 0x000ff00000009400ULL, 0x0000004900627306ULL, 0x000e700000005400ULL,
0x0000005a00657306ULL, 0x000ff00000209400ULL, 0x0000005a006a7306ULL, 0x000fe20000205400ULL,
0x000000626100720bULL, 0x002fce0003fdd000ULL, 0x0000005a004f7306ULL, 0x000ff0000020d400ULL,
0x0000003f00507306ULL, 0x000ff00000209400ULL, 0x0000003f00517306ULL, 0x000ff00000205400ULL,
0x0000003f003c7306ULL, 0x000ff0000020d400ULL, 0x0000006800697306ULL, 0x000ff00000209400ULL,
0x00000068005a7306ULL, 0x000e700000205400ULL, 0x0000000a003f7306ULL, 0x000ff00000209400ULL,
0x0000000a00607306ULL, 0x000fe20000205400ULL, 0x0000005a6900720bULL, 0x002fce0003f9d000ULL,
0x0000000a00567306ULL, 0x000ff0000020d400ULL, 0x0000006d006c7306ULL, 0x000ff00000209400ULL,
0x0000006d006b7306ULL, 0x000ff00000205400ULL, 0x0000006d000a7306ULL, 0x0003f0000020d400ULL,
0x0000004800577306ULL, 0x0004e2000000d400ULL, 0x00000018ff6d7819ULL, 0x002fce0000011453ULL,
0x0000006d00537306ULL, 0x000fe20000209400ULL, 0x0000010049487824ULL, 0x004fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011448ULL, 0x0000006d00587306ULL, 0x000e620000205400ULL,
0x0000000157575812ULL, 0x008fe400078efcffULL, 0x000000523900720bULL, 0x000fca0003fbd000ULL,
0x00000068005c7306ULL, 0x000eb0000020d400ULL, 0x0000006f00487306ULL, 0x000fe20000209400ULL,
0x000000585300720bULL, 0x002fe40003f1d000ULL, 0x0000000109095812ULL, 0x000fc400078efcffULL,
0x000000381500720bULL, 0x000fe20003fbd000ULL, 0x000000103d387824ULL, 0x000fe400078e0216ULL,
0x0000006f00617306ULL, 0x000e620000205400ULL, 0x000000015c5c4812ULL, 0x004fe200078efcffULL,
0x00000100443d7824ULL, 0x000fcc00078e00ffULL, 0x0000004900047306ULL, 0x0004e4000000d400ULL,
0x000000015f5f5812ULL, 0x000fcc00078efcffULL, 0x0000006d005a7306ULL, 0x000ee2000020d400ULL,
0x000001004a497824ULL, 0x004fe200078e00ffULL, 0x000000614800720bULL, 0x002fc80003f9d000ULL,
0x00000018ff537819ULL, 0x000fe40000011449ULL, 0x0000006f00627306ULL, 0x000e62000020d400ULL,
0x0000000104046812ULL, 0x008fce00078efcffULL, 0x0000005300497306ULL, 0x000fe20000209400ULL,
0x000000015a5a0812ULL, 0x000fe400078efcffULL, 0x000000543b00720bULL, 0x000fca0003f1d000ULL,
0x0000005300767306ULL, 0x000ea20000205400ULL, 0x0000000162624812ULL, 0x002fce00078efcffULL,
0x0000007500687306ULL, 0x000fe20000209400ULL, 0x000000014c4c0812ULL, 0x000fce00078efcffULL,
0x0000007500697306ULL, 0x000e620000205400ULL, 0x000000764900720bULL, 0x004fe20003f9d000ULL,
0x000001004b497824ULL, 0x000fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000004a00397306ULL, 0x000ff00000009400ULL, 0x0000004a00487306ULL, 0x000ea20000005400ULL,
0x000000696800720bULL, 0x002fce0003f5d000ULL, 0x00000075005b7306ULL, 0x000e70000020d400ULL,
0x0000005300587306ULL, 0x000ee2000020d400ULL, 0x000000483900720bULL, 0x004fce0003fdd000ULL,
0x0000004b003b7306ULL, 0x000fe20000009400ULL, 0x000000015b5b2812ULL, 0x002fe400078efcffULL,
0x0000003a1700720bULL, 0x000fe40003f5d000ULL, 0x011000001414783bULL, 0x000e660000000200ULL,
0x0000004b00527306ULL, 0x000ea20000005400ULL, 0x0000000158584812ULL, 0x008fce00078efcffULL,
0x0000004a00697306ULL, 0x0006e2000000d400ULL, 0x000000013e3e2812ULL, 0x000fce00078efcffULL,
0x0000004900537306ULL, 0x000fe20000209400ULL, 0x000000523b00720bULL, 0x004fe20003f9d000ULL,
0x000100004a4a7824ULL, 0x008fe200078e00ffULL, 0x011000003838783bULL, 0x000ea20000000200ULL,
0x00000018ff527819ULL, 0x000fc8000001143dULL, 0x0000004900547306ULL, 0x000ee20000205400ULL,
0x0000000169696812ULL, 0x000fce00078efcffULL, 0x0000004900687306ULL, 0x0006a2000020d400ULL,
0x000000071414b231ULL, 0x082fe400003400ffULL, 0x000000071616b231ULL, 0x000fca00003400ffULL,
0x0000004400487306ULL, 0x000fe20000009400ULL, 0x000000545300720bULL, 0x008fe20003fdd000ULL,
0x0001000044497824ULL, 0x000fe200078e00ffULL, 0x000000061515b231ULL, 0x080fe400003400ffULL,
0x000000061717b231ULL, 0x000fc600003400ffULL, 0x00000044006d7306ULL, 0x000e6c0000005400ULL,
0x0000000168686812ULL, 0x004fe400078efcffULL, 0x0000004b00617306ULL, 0x0004e2000000d400ULL,
0x000000073838b231ULL, 0x080fe400003400ffULL, 0x000000073a3ab231ULL, 0x000fc400003400ffULL,
0x000000063939b231ULL, 0x080fe200003400ffULL, 0x0000006d4800720bULL, 0x002fe40003fdd000ULL,
0x00000052003d7306ULL, 0x000fe20000209400ULL, 0x00000018ff6d7819ULL, 0x000fe20000011449ULL,
0x000000063b3bb231ULL, 0x000fe200003400ffULL, 0x000100004b4b7824ULL, 0x004fe200078e00ffULL,
0x0000000161614812ULL, 0x008fc800078efcffULL, 0x0000005200487306ULL, 0x000e620000205400ULL,
0x000000515000720bULL, 0x000fce0003f9d000ULL, 0x0000004400537306ULL, 0x000eac000000d400ULL,
0x000000013c3c4812ULL, 0x000fe400078efcffULL, 0x0000006d00497306ULL, 0x000fe20000209400ULL,
0x000000483d00720bULL, 0x002fe20003f7d000ULL, 0x00000100453d7824ULL, 0x000fe200078e00ffULL,
0x0000006a6500720bULL, 0x000fe20003f9d000ULL, 0x0001000045487824ULL, 0x000fc400078e00ffULL,
0x00000100416a7824ULL, 0x000fe400078e00ffULL, 0x0000006d00507306ULL, 0x000e620000205400ULL,
0x0000000153536812ULL, 0x004fce00078efcffULL, 0x0000005200547306ULL, 0x000ea2000020d400ULL,
0x000000014f4f4812ULL, 0x000fce00078efcffULL, 0x0000006d00517306ULL, 0x000ee2000020d400ULL,
0x000000504900720bULL, 0x002fe40003fdd000ULL, 0x00000018ff497819ULL, 0x000fca000001143dULL,
0x0000004500447306ULL, 0x000fe20000009400ULL, 0x0000000154543812ULL, 0x004fc800078efcffULL,
0x000000535454723eULL, 0x000fe200000010ffULL, 0x0001000013537824ULL, 0x000fe400078e00ffULL,
0x00000045006d7306ULL, 0x000e620000005400ULL, 0x0000000151516812ULL, 0x008fe400078efcffULL,
0x000000744d00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x000000514c4c723eULL, 0x000fe200000010ffULL, 0x00000049003d7306ULL, 0x000fe20000209400ULL,
0x0000006d4400720bULL, 0x002fce0003f7d000ULL, 0x0000004500507306ULL, 0x000e62000000d400ULL,
0x00000018ff6d7819ULL, 0x000fe40000011448ULL, 0x000000010e0e6812ULL, 0x000fca00078efcffULL,
0x0000004900447306ULL, 0x000eb00000205400ULL, 0x0000006d00487306ULL, 0x000fe20000209400ULL,
0x0000000150503812ULL, 0x002fce00078efcffULL, 0x0000006d00457306ULL, 0x000e620000205400ULL,
0x000000443d00720bULL, 0x004fe20003f1d000ULL, 0x0000010046447824ULL, 0x000fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe20000011444ULL, 0x00000046003d7306ULL, 0x000ff00000009400ULL,
0x0000004600747306ULL, 0x000ea20000005400ULL, 0x000000454800720bULL, 0x002fce0003f7d000ULL,
0x0000004900527306ULL, 0x000e70000020d400ULL, 0x0000006d004d7306ULL, 0x000ee2000020d400ULL,
0x000000743d00720bULL, 0x004fe20003f5d000ULL, 0x00000100473d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fca000001144aULL, 0x0000006f00447306ULL, 0x000fe20000209400ULL,
0x0000000152520812ULL, 0x002fe400078efcffULL, 0x0000006e6700720bULL, 0x000fca0003f1d000ULL,
0x0000006f00457306ULL, 0x000e620000205400ULL, 0x000000014d4d3812ULL, 0x008fc800078efcffULL,
0x0000004d3e4d723eULL, 0x000fc600000010ffULL, 0x0000006f00497306ULL, 0x0004e2000020d400ULL,
0x000000015e5e0812ULL, 0x000fe400078efcffULL, 0x0000005d0500720bULL, 0x000fca0003f1d000ULL,
0x0000004600487306ULL, 0x0006e2000000d400ULL, 0x000000454400720bULL, 0x002fe40003f7d000ULL,
0x00000018ff6f7819ULL, 0x004fca000001143dULL, 0x0000004700447306ULL, 0x000fe20000009400ULL,
0x0001000046467824ULL, 0x008fe200078e00ffULL, 0x000000014e4e0812ULL, 0x000fc800078efcffULL,
0x0000000149493812ULL, 0x000fe400078efcffULL, 0x0000004700677306ULL, 0x000e620000005400ULL,
0x0000000148482812ULL, 0x000fe400078efcffULL, 0x00000018ff757819ULL, 0x000fe40000011446ULL,
0x000000484948723eULL, 0x000fc600000010ffULL, 0x0000006f00457306ULL, 0x000ff00000209400ULL,
0x0000006f006e7306ULL, 0x000ea20000205400ULL, 0x000000674400720bULL, 0x002fce0003f5d000ULL,
0x0000006f003d7306ULL, 0x000ff0000020d400ULL, 0x0000004700447306ULL, 0x0002e2000000d400ULL,
0x0000006e4500720bULL, 0x004fe40003f7d000ULL, 0x00000018ff6e7819ULL, 0x000fca000001144bULL,
0x00000074004a7306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x002fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe40000011447ULL, 0x00000074006d7306ULL, 0x000e620000205400ULL,
0x0000000144442812ULL, 0x008fe400078efcffULL, 0x000000013d3d3812ULL, 0x000fe400078efcffULL,
0x000000603f00720bULL, 0x000fe40003f5d000ULL, 0x000000443d49723eULL, 0x000fe200000010ffULL,
0x0000007400677306ULL, 0x000eb0000020d400ULL, 0x0000007500467306ULL, 0x000fe20000209400ULL,
0x0000006d4a00720bULL, 0x002fc40003f7d000ULL, 0x0000000156562812ULL, 0x000fca00078efcffULL,
0x00000075006f7306ULL, 0x000e6c0000205400ULL, 0x0000000167673812ULL, 0x004fe400078efcffULL,
0x0000007600477306ULL, 0x000ff00000209400ULL, 0x0000007600607306ULL, 0x000ea20000205400ULL,
0x0000006f4600720bULL, 0x002fe20003f7d000ULL, 0x0000010040467824ULL, 0x000fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe20000011446ULL, 0x0000007500457306ULL, 0x000e70000020d400ULL,
0x00000076003f7306ULL, 0x000ee2000020d400ULL, 0x000000604700720bULL, 0x004fce0003fbd000ULL,
0x0000006e004a7306ULL, 0x000fe20000209400ULL, 0x0000000145453812ULL, 0x002fe400078efcffULL,
0x000000646300720bULL, 0x000fe40003f7d000ULL, 0x000000453c3c723eULL, 0x000fc600000010ffULL,
0x0000006e006d7306ULL, 0x000e620000205400ULL, 0x000000013f3f5812ULL, 0x008fc800078efcffULL,
0x0000003f0e3d723eULL, 0x000fc600000010ffULL, 0x0000006f00467306ULL, 0x000fe20000209400ULL,
0x0000000155553812ULL, 0x000fce00078efcffULL, 0x0000006f004b7306ULL, 0x000ea20000205400ULL,
0x0000006d4a00720bULL, 0x002fe20003fbd000ULL, 0x00010000416d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000006e00477306ULL, 0x0002f0000020d400ULL,
0x0000004000637306ULL, 0x000fe20000009400ULL, 0x0000004b4600720bULL, 0x004fc40003fdd000ULL,
0x00000018ff6e7819ULL, 0x002fca0000011411ULL, 0x0000004000647306ULL, 0x000e620000005400ULL,
0x0000000147475812ULL, 0x008fce00078efcffULL, 0x00000040004a7306ULL, 0x000eb0000000d400ULL,
0x0000004100657306ULL, 0x000fe20000009400ULL, 0x000000646300720bULL, 0x002fce0003fbd000ULL,
0x0000004100467306ULL, 0x000e6c0000005400ULL, 0x000000014a4a5812ULL, 0x004fe400078efcffULL,
0x0000006f00607306ULL, 0x0004e2000020d400ULL, 0x000000466500720bULL, 0x002fe20003fbd000ULL,
0x0001000040467824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x004fca000001146aULL,
0x0000006e00647306ULL, 0x000fe20000209400ULL, 0x000000575c40723eULL, 0x000fe200000010ffULL,
0x00000100425c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000000160606812ULL, 0x008fe400078efcffULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000006f006a7306ULL, 0x000fe20000209400ULL, 0x0000004a604a723eULL, 0x000fce00000010ffULL,
0x0000006f004b7306ULL, 0x000e700000205400ULL, 0x0000006e00637306ULL, 0x000ff00000205400ULL,
0x0000006e00057306ULL, 0x000fe2000020d400ULL, 0x0000004b6a00720bULL, 0x002fce0003fdd000ULL,
0x00000041005d7306ULL, 0x0002b0000000d400ULL, 0x0000006d006e7306ULL, 0x000fe20000209400ULL,
0x000000046241723eULL, 0x002fce00000010ffULL, 0x0000006d00577306ULL, 0x000e620000205400ULL,
0x000000401418723cULL, 0x000be20000041818ULL, 0x000000015d5d5812ULL, 0x004fcc00078efcffULL,
0x0000006f004b7306ULL, 0x0004e2000020d400ULL, 0x0000010043407824ULL, 0x020fe200078e00ffULL,
0x0000005b0941723eULL, 0x000fcc00000010ffULL, 0x0000004600657306ULL, 0x000fe20000209400ULL,
0x000000576e00720bULL, 0x002fe40003fbd000ULL, 0x00000018ff6f7819ULL, 0x004fca0000011412ULL,
0x0000004600747306ULL, 0x000e620000205400ULL, 0x000000014b4b6812ULL, 0x008fc800078efcffULL,
0x0000005d4b4b723eULL, 0x000fc600000010ffULL, 0x0000006d00577306ULL, 0x0004e8000020d400ULL,
0x0000004a1428723cULL, 0x000be80000041828ULL, 0x0000004600467306ULL, 0x000ee2000020d400ULL,
0x00000018ff6d7819ULL, 0x004fe40000011440ULL, 0x0000005a5940723eULL, 0x000fe200000010ffULL,
0x00000100124a7824ULL, 0x020fe200078e00ffULL, 0x000000746500720bULL, 0x002fc60003fdd000ULL,
0x0000005c00627306ULL, 0x000fe20000209400ULL, 0x0000000157575812ULL, 0x008fe200078efcffULL,
0x00000040141c723cULL, 0x000b66000004181cULL, 0x000000575557723eULL, 0x000fc600000010ffULL,
0x0000005c006e7306ULL, 0x000e640000205400ULL, 0x0000000146466812ULL, 0x000fc800078efcffULL,
0x000000465656723eULL, 0x000fe400000010ffULL, 0x00000042005a7306ULL, 0x000fea0000009400ULL,
0x00000056142c723cULL, 0x000fe6000004182cULL, 0x0000004200417306ULL, 0x020ea20000005400ULL,
0x0000006e6200720bULL, 0x002fc80003fdd000ULL, 0x0000004c381c723cULL, 0x000fe6000004181cULL,
0x00000043005b7306ULL, 0x000ff00000009400ULL, 0x00000043006e7306ULL, 0x000e620000005400ULL,
0x000000415a00720bULL, 0x004fe20003fbd000ULL, 0x0001000042417824ULL, 0x000fca00078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000006f006a7306ULL, 0x000ff00000209400ULL,
0x0000006f00657306ULL, 0x000fe20000205400ULL, 0x0000006e5b00720bULL, 0x002fce0003f7d000ULL,
0x0000006f00047306ULL, 0x000ff0000020d400ULL, 0x0000006d006f7306ULL, 0x000ff00000209400ULL,
0x0000006d00097306ULL, 0x000e700000205400ULL, 0x0000005c005c7306ULL, 0x000eb0000020d400ULL,
0x0000006d00597306ULL, 0x000ee2000020d400ULL, 0x000000096f00720bULL, 0x002fc40003f5d000ULL,
0x00000018ff6f7819ULL, 0x000fca0000011413ULL, 0x00000042005b7306ULL, 0x0002e2000000d400ULL,
0x000000015c5c6812ULL, 0x004fce00078efcffULL, 0x00000041006d7306ULL, 0x000fe20000209400ULL,
0x000000695842723eULL, 0x002fe200000010ffULL, 0x0001000043697824ULL, 0x000fe200078e00ffULL,
0x0000000159592812ULL, 0x008fca00078efcffULL, 0x00000041006e7306ULL, 0x000e620000205400ULL,
0x000000015b5b5812ULL, 0x000fce00078efcffULL, 0x00000043005a7306ULL, 0x0004f0000000d400ULL,
0x0000006f00627306ULL, 0x000fe20000209400ULL, 0x000000616843723eULL, 0x004fe400000010ffULL,
0x00000018ff617819ULL, 0x000fc40000011469ULL, 0x0000006e6d00720bULL, 0x002fc60003fdd000ULL,
0x000000421420723cULL, 0x000b620000041820ULL, 0x0000006f00407306ULL, 0x000fe20000205400ULL,
0x000000015a5a3812ULL, 0x008fc800078efcffULL, 0x0000005a594b723eULL, 0x000fe200000010ffULL,
0x0000010010427824ULL, 0x020fe200078e00ffULL, 0x000000475e43723eULL, 0x000fe200000010ffULL,
0x0000006f00097306ULL, 0x000fe2000020d400ULL, 0x00000100135a7824ULL, 0x000fe400078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011442ULL, 0x000000675f42723eULL, 0x000fe400000010ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000006100697306ULL, 0x000fe80000209400ULL,
0x000000421424723cULL, 0x000b680000041824ULL, 0x00000061006f7306ULL, 0x000e660000205400ULL,
0x0000010011427824ULL, 0x020fe200078e00ffULL, 0x000000483820723cULL, 0x000fe20000041820ULL,
0x0001000010437824ULL, 0x000fc600078e00ffULL, 0x0000001000477306ULL, 0x000ff00000009400ULL,
0x00000010005e7306ULL, 0x000ea20000005400ULL, 0x0000006f6900720bULL, 0x002fe40003fbd000ULL,
0x00000018ff6f7819ULL, 0x000fe20000011442ULL, 0x0000003c3824723cULL, 0x000fe80000041824ULL,
0x00000011006d7306ULL, 0x000ff00000009400ULL, 0x00000011006e7306ULL, 0x000e620000005400ULL,
0x0000005e4700720bULL, 0x004fc40003f5d000ULL, 0x00000018ff5e7819ULL, 0x000fe20000011443ULL,
0x0001000011437824ULL, 0x000fc800078e00ffULL, 0x0000004100587306ULL, 0x000ea2000020d400ULL,
0x00000018ff437819ULL, 0x000fce0000011443ULL, 0x0000007400687306ULL, 0x000fe20000209400ULL,
0x0000006e6d00720bULL, 0x002fce0003f7d000ULL, 0x00000074005f7306ULL, 0x000e620000205400ULL,
0x0000000158586812ULL, 0x004fc800078efcffULL, 0x000000584f58723eULL, 0x000fe200000010ffULL,
0x00010000124f7824ULL, 0x000fe400078e00ffULL, 0x0000001000477306ULL, 0x000ea6000000d400ULL,
0x00000018ff4f7819ULL, 0x000fca000001144fULL, 0x0000006100617306ULL, 0x000ee2000020d400ULL,
0x0000005f6800720bULL, 0x002fce0003fdd000ULL, 0x0000006f00677306ULL, 0x000fe20000209400ULL,
0x0000000147472812ULL, 0x004fce00078efcffULL, 0x0000006f00697306ULL, 0x000e620000205400ULL,
0x0000000161615812ULL, 0x008fce00078efcffULL, 0x0000005e006e7306ULL, 0x000ff00000209400ULL,
0x0000005e006d7306ULL, 0x000ea20000205400ULL, 0x000000696700720bULL, 0x002fce0003f9d000ULL,
0x0000001300687306ULL, 0x000ff00000009400ULL, 0x0000001300597306ULL, 0x000e620000005400ULL,
0x0000006d6e00720bULL, 0x004fce0003f5d000ULL, 0x0000007400417306ULL, 0x0004f0000020d400ULL,
0x0000001100107306ULL, 0x000ee2000000d400ULL, 0x00000018ff747819ULL, 0x004fe4000001144aULL,
0x0000005b5c4a723eULL, 0x000fc400000010ffULL, 0x000000596800720bULL, 0x002fe40003f1d000ULL,
0x000000614e59723eULL, 0x000fe200000010ffULL, 0x0000006f00427306ULL, 0x000e62000020d400ULL,
0x0000000141416812ULL, 0x008fe200078efcffULL, 0x0000004a1430723cULL, 0x000f620000041830ULL,
0x0000006b6c00720bULL, 0x000fca0003fdd000ULL, 0x0000005e00117306ULL, 0x000ea2000020d400ULL,
0x0000000110103812ULL, 0x000fe200078efcffULL, 0x000000581414723cULL, 0x000b620000041834ULL,
0x000000636400720bULL, 0x000fca0003f7d000ULL, 0x00000043006f7306ULL, 0x000fe20000209400ULL,
0x0000000142424812ULL, 0x002fe400078efcffULL, 0x000000010a0a6812ULL, 0x000fe400078efcffULL,
0x000000656a00720bULL, 0x000fe40003fdd000ULL, 0x000000474134723eULL, 0x020fe200000010ffULL,
0x0000004300607306ULL, 0x000e620000205400ULL, 0x0000000111112812ULL, 0x004fe400078efcffULL,
0x0000000105053812ULL, 0x000fc400078efcffULL, 0x000000104235723eULL, 0x000fe400000010ffULL,
0x000000110a42723eULL, 0x000fe200000010ffULL, 0x00000074005d7306ULL, 0x000fe40000209400ULL,
0x0000000104046812ULL, 0x000fe400078efcffULL, 0x000000343828723cULL, 0x000b680000041828ULL,
0x00000074005e7306ULL, 0x000ea20000205400ULL, 0x000000606f00720bULL, 0x002fce0003f9d000ULL,
0x0000001200557306ULL, 0x000ff00000009400ULL, 0x00000012005f7306ULL, 0x000e620000005400ULL,
0x0000005e5d00720bULL, 0x004fce0003f5d000ULL, 0x00000012004b7306ULL, 0x000eb0000000d400ULL,
0x0000004300437306ULL, 0x000ee2000020d400ULL, 0x0000005f5500720bULL, 0x002fe40003fbd000ULL,
0x000000505255723eULL, 0x000fca00000010ffULL, 0x0000007400467306ULL, 0x000e64000020d400ULL,
0x000000543818723cULL, 0x000b680000041818ULL, 0x000000014b4b5812ULL, 0x004fe400078efcffULL,
0x0000005a00567306ULL, 0x000fe20000209400ULL, 0x0000000143434812ULL, 0x008fe400078efcffULL,
0x000000406200720bULL, 0x000fc40003f9d000ULL, 0x000000430543723eULL, 0x000fc600000010ffULL,
0x0000005a00577306ULL, 0x000ea20000205400ULL, 0x0000000146462812ULL, 0x002fc600078efcffULL,
0x00000042382c723cULL, 0x000b62000004182cULL, 0x0000004b4646723eULL, 0x000fc600000010ffULL,
0x0000001300127306ULL, 0x000e62000000d400ULL, 0x0000000109094812ULL, 0x000fce00078efcffULL,
0x0000004f004e7306ULL, 0x000fe20000209400ULL, 0x000000575600720bULL, 0x004fce0003f7d000ULL,
0x0000004f00137306ULL, 0x000ea20000205400ULL, 0x0000000112120812ULL, 0x002fce00078efcffULL,
0x0000005300367306ULL, 0x000ff00000209400ULL, 0x0000005300377306ULL, 0x000e620000205400ULL,
0x000000134e00720bULL, 0x004fce0003f5d000ULL, 0x0000005a004a7306ULL, 0x000eb0000020d400ULL,
0x0000004f004f7306ULL, 0x000ee2000020d400ULL, 0x000000373600720bULL, 0x002fce0003fbd000ULL,
0x00000053000e7306ULL, 0x000e62000020d400ULL, 0x000000014a4a3812ULL, 0x004fc800078efcffULL,
0x000000124a47723eULL, 0x000fe400000010ffULL, 0x000000014f4f2812ULL, 0x008fc800078efcffULL,
0x0000004f0410723eULL, 0x000fe200000010ffULL, 0x000000463830723cULL, 0x000b620000041830ULL,
0x0000000471047810ULL, 0x000fe40007ffe0ffULL, 0x000000010e0e5812ULL, 0x002fe400078efcffULL,
0x000176a804047811ULL, 0x000fe400078e18ffULL, 0x0000000e0911723eULL, 0x000fce00000010ffULL,
0x000000103838723cULL, 0x000b620000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000004047f8cULL, 0x000e62000c80043fULL, 0x000000010b0b7810ULL, 0x000fe40007ffe0ffULL,
0x000176a0790a7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000aff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff097224ULL, 0x002fe200078e0005ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff265000007947ULL, 0x000fea000383ffffULL,
0x000000ff7300720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000f007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000f0b000047802ULL, 0x002fc40000000f00ULL,
0x0000a2f000007944ULL, 0x034fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000f00007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x008fc8000000000fULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x002e680000000000ULL, 0x0000000000077919ULL, 0x004ea20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000001800187220ULL, 0x062fe40000410000ULL,
0x0000001900197220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x040fe40000410000ULL,
0x0000001d001d7220ULL, 0x000fc40000410000ULL, 0x0000002000207220ULL, 0x040fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x040fe40000410000ULL,
0x0000002500257220ULL, 0x040fe40000410000ULL, 0x0000002800287220ULL, 0x040fe40000410000ULL,
0x0000002900297220ULL, 0x000fc40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x040fe40000410000ULL,
0x0000003900397220ULL, 0x000fc40000410000ULL, 0x0000001a041a7220ULL, 0x044fe40000410000ULL,
0x0000001b041b7220ULL, 0x040fe40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fc40000410000ULL, 0x0000002604267220ULL, 0x040fe40000410000ULL,
0x0000002704277220ULL, 0x040fe40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x040fe40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x000fc40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x000fc40000410000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000002c2d2c723eULL, 0x020fe200000010ffULL, 0x0000002071127824ULL, 0x000fe200078e00ffULL,
0x000000303130723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000222322723eULL, 0x000fc400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x0000002e2f15723eULL, 0x000fe400000010ffULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x00000002ff057819ULL, 0x00afe40000011602ULL, 0x0000000202007812ULL, 0x040fe400078ec0ffULL,
0x0000000802077811ULL, 0x004fe200078ff0ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000500037211ULL, 0x000fc400078ff8ffULL, 0x0000000700047211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000000203007810ULL, 0x000fe20007ffe0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000403067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8090e7812ULL, 0x000fe200078ee204ULL, 0x0000000805047824ULL, 0x000fe200078e00ffULL,
0xfffffff807087812ULL, 0x000fe200078ee200ULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0000000603077810ULL, 0x000fe20007ffe0ffULL, 0x000010007c007824ULL, 0x000fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x0000000802057824ULL, 0x000fe200078e00ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000080071037824ULL, 0x000fe200078e0200ULL,
0xfffffff80c0c7812ULL, 0x000fc400078ee207ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x0000001c1d04723eULL, 0x000fe200000010ffULL,
0x000000100e0f7824ULL, 0x100fe400078e0203ULL, 0x0000001008097824ULL, 0x000fe200078e0203ULL,
0x000054102a087816ULL, 0x000fe20000000015ULL, 0x000000100a0b7824ULL, 0x100fe400078e0203ULL,
0x000000100c0d7824ULL, 0x010fe200078e0203ULL, 0x000000181903723eULL, 0x000fe200000010ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x000000282905723eULL, 0x000fe200000010ffULL,
0x00000001060f7824ULL, 0x040fe200078e020fULL, 0x0000541003107816ULL, 0x140fe20000000004ULL,
0x0000000106097824ULL, 0x040fe200078e0209ULL, 0x0000763203117816ULL, 0x000fe20000000004ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x000000202103723eULL, 0x000fe200000010ffULL,
0x00000001060d7824ULL, 0x000fe200078e020dULL, 0x000000242504723eULL, 0x000fe200000010ffULL,
0x0000001007007388ULL, 0x0003e20000000a00ULL, 0x000000383918723eULL, 0x000fc400000010ffULL,
0x0000541003067816ULL, 0x000fe40000000004ULL, 0x0000003a3b19723eULL, 0x000fc800000010ffULL,
0x00005410320e7816ULL, 0x000fe40000000019ULL, 0x0000763203077816ULL, 0x002fe40000000004ULL,
0x0000001a1b03723eULL, 0x000fe400000010ffULL, 0x0000001e1f04723eULL, 0x000fe200000010ffULL,
0x0000000609007388ULL, 0x0003e20000000a00ULL, 0x000000262711723eULL, 0x000fc800000010ffULL,
0x0000541022107816ULL, 0x140fe40000000011ULL, 0x0000763222117816ULL, 0x000fe40000000011ULL,
0x0000541005067816ULL, 0x142fe4000000002cULL, 0x0000763205077816ULL, 0x000fe4000000002cULL,
0x000000ff00057306ULL, 0x000fe6000020d400ULL, 0x000000060b007388ULL, 0x0003e40000000a00ULL,
0x0000541030067816ULL, 0x002fc40000000018ULL, 0x0000763230077816ULL, 0x000fca0000000018ULL,
0x000000060d007388ULL, 0x0003e40000000a00ULL, 0x0000541003067816ULL, 0x142fe40000000004ULL,
0x0000763203077816ULL, 0x000fe20000000004ULL, 0x0000000112037824ULL, 0x000fe200078e0202ULL,
0x000000ff00047306ULL, 0x000fe60000205400ULL, 0x000000060f007388ULL, 0x0003e80000000a00ULL,
0x0004001009007388ULL, 0x0005e20000000a00ULL, 0x00007632320f7816ULL, 0x002fe20000000019ULL,
0x0000001003067824ULL, 0x000fc400078e0200ULL, 0x000000ff00037306ULL, 0x000e620000209400ULL,
0x000076322a097816ULL, 0x004fca0000000015ULL, 0x000400080b007388ULL, 0x000fe80000000a00ULL,
0x0004000e0d007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000006107984ULL, 0x000ea20000000c00ULL, 0x000000040300720bULL, 0x002fc60003f1d000ULL,
0x0004000006087984ULL, 0x000e680000000c00ULL, 0x0008000006147984ULL, 0x000ee80000000c00ULL,
0x000c000006187984ULL, 0x000ee40000000c00ULL, 0x0000000105050812ULL, 0x000fc400078efcffULL,
0x000000ff7100720cULL, 0x000fe40003f05270ULL, 0x000000050505723eULL, 0x000fca00000010ffULL,
0x3f803f8005137831ULL, 0x044fe40000200013ULL, 0x3f803f8005127831ULL, 0x040fe40000200012ULL,
0x3f803f8005117831ULL, 0x040fe40000200011ULL, 0x3f803f8005107831ULL, 0x040fe40000200010ULL,
0x3f803f80050b7831ULL, 0x042fe4000020000bULL, 0x3f803f80050a7831ULL, 0x000fc4000020000aULL,
0x3f803f8005097831ULL, 0x040fe40000200009ULL, 0x3f803f8005087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fc40000200014ULL,
0x3f803f800b0b7831ULL, 0x000fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x0000001006007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x0004000806007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fc80000011602ULL, 0x0000007d0500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000011d7983ULL, 0x000ea20000100800ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0x0000000105037824ULL, 0x000fe200078e0202ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00005900ff1c7624ULL, 0x000fe200078e00ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x00005a007b7b7a19ULL, 0x000fe200000006ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x0000000703037812ULL, 0x000fe400078ec0ffULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x00005a001c1c7a19ULL, 0x000fc400000006ffULL,
0x0ffffff803037812ULL, 0x000fe400078ef802ULL, 0x0000002002077810ULL, 0x040fe40007ffe0ffULL,
0x00000007020d7812ULL, 0x000fe200078ec0ffULL, 0x0000001003047824ULL, 0x000fca00078e0200ULL,
0x0000000004087984ULL, 0x0007220000000c00ULL, 0x00000006040472a4ULL, 0x002fcc000f8e023fULL,
0x000000041c067c24ULL, 0x000fe4000f8e02ffULL, 0x000000101d037824ULL, 0x004fca00078e0205ULL,
0x0000000503057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff037a19ULL, 0x000fc60000011603ULL,
0x000000017b0c7824ULL, 0x000fc800078e0205ULL, 0x0000001c03037224ULL, 0x000fca00078e020cULL,
0x0000000306037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0003047a11ULL, 0x008fc800078040ffULL, 0x00005d0003057a11ULL, 0x000fe200000f440cULL,
0x000000087c037824ULL, 0x000fe200078e020dULL, 0x00000003ff0c7819ULL, 0x000fc60000011607ULL,
0x0000001003047825ULL, 0x000fe200078e0004ULL, 0x0000007d0c00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0103f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107037824ULL, 0x100fe400078e020cULL, 0x000000101d0c7824ULL, 0x000fc600078e020cULL,
0x0000000703047812ULL, 0x002fc800078ec0ffULL, 0x0ffffff804037812ULL, 0x000fe400078ef807ULL,
0x000000050c047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe2000001160cULL,
0x0000001003037824ULL, 0x000fe200078e0200ULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x000000017b057824ULL, 0x000fc600078e0204ULL, 0x0000000003087984ULL, 0x0002a20000000c00ULL,
0x0000001c0c057224ULL, 0x000fe200078e0205ULL, 0x00000040020c7810ULL, 0x000fe20007ffe0ffULL,
0x000000087c077824ULL, 0x000fc600078e0207ULL, 0x0000000506057210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff037819ULL, 0x002fc6000001160cULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x0000007d0300720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x142fe200078e0203ULL, 0x000000070c077812ULL, 0x000fe200078ec0ffULL,
0x000000101d037824ULL, 0x000fc600078e0203ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x000000087c077824ULL, 0x000fe200078e0207ULL, 0x0000000503047c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x00005a00ff037a19ULL, 0x000fe20000011603ULL,
0x000000017b047824ULL, 0x000fe400078e0204ULL, 0x0000001005057824ULL, 0x000fe400078e0200ULL,
0x0000001c03037224ULL, 0x000fe200078e0204ULL, 0x0000006002047810ULL, 0x000fc40007ffe0ffULL,
0x0000000005087984ULL, 0x0002a40000000c00ULL, 0x0000000306037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x040fe400078040ffULL,
0x00000003ff057819ULL, 0x002fe40000011604ULL, 0x00005d0003037a11ULL, 0x000fe400000f440eULL,
0x0000007d0500720cULL, 0x000fe20003f06070ULL, 0x00000001040c7824ULL, 0x000fe400078e0205ULL,
0x0000001007027825ULL, 0x000fc600078e0002ULL, 0x000000070c077812ULL, 0x000fc800078ec0ffULL,
0xfffffff807077812ULL, 0x000fe200078ef804ULL, 0x0000000802007986ULL, 0x0043e4000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001007077824ULL, 0x000fe400078e0200ULL,
0x000000101d057824ULL, 0x000fc600078e0205ULL, 0x0000000007087984ULL, 0x002e640000000c00ULL,
0x0000000505007c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fc60000011605ULL,
0x000000017b007824ULL, 0x000fc800078e0200ULL, 0x0000001c05057224ULL, 0x000fca00078e0200ULL,
0x0000000506067210ULL, 0x000fe40007f1e0ffULL, 0x0000000704057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005c0006027a11ULL, 0x000fe200078040ffULL,
0x000000087c057824ULL, 0x000fc600078e0205ULL, 0x00005d0006037a11ULL, 0x000fca00000f4403ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff677819ULL, 0x000fe20000011600ULL,
0xffffffffff2f7424ULL, 0x000fc600078e00ffULL, 0x000000786700720cULL, 0x000fda0003f06070ULL,
0x0000000203048824ULL, 0x000fc800078e00ffULL, 0x00006800040b8a24ULL, 0x000fc800078e0267ULL,
0x000064000b0a8625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006c00ff0e7624ULL, 0x000fe200078e00ffULL, 0x000000080a2f8981ULL, 0x000ea2000c1e1900ULL,
0x00006d00ff0f7624ULL, 0x000fc600078e00ffULL, 0x01760000ff047f8cULL, 0x000e68000c80043fULL,
0x000000080e077981ULL, 0x000722000c1e9900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x000000807b727824ULL, 0x000fe400078e00ffULL, 0x0000004000757824ULL, 0x000fe400078e00ffULL,
0x000000807c7c7824ULL, 0x000fc600078e00ffULL, 0x0000004072097812ULL, 0x000fe200078ef875ULL,
0x0000002f7c2f7224ULL, 0x004fc800078e02ffULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x00000003ff1b7819ULL, 0x10afe4000001160cULL, 0x00000075701c7217ULL, 0x000fe40007800000ULL,
0x000000081b137810ULL, 0x000fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x000fe200078e021bULL,
0x000000041b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e0a75ULL,
0x0000000c1b157810ULL, 0x000fe20007ffe0ffULL, 0x00000001130b7824ULL, 0x100fe200078e020cULL,
0x000000101b117810ULL, 0x000fe20007ffe0ffULL, 0x00000008130e7824ULL, 0x000fe200078e00ffULL,
0x000062002f0d7a11ULL, 0x000fe200078038ffULL, 0x000000010f087824ULL, 0x040fe200078e020cULL,
0x0000001c0f00720cULL, 0x040fe20003fa6070ULL, 0x000000080f237824ULL, 0x000fe200078e00ffULL,
0xfffffff80e257812ULL, 0x000fe200078ee20bULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000141b1d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee208ULL,
0x00000001150e7824ULL, 0x040fe200078e020cULL, 0x000000700a1e7812ULL, 0x000fe200078ef802ULL,
0x0000000815277824ULL, 0x000fe200078e00ffULL, 0x000063002f087a11ULL, 0x000fe200000f3cffULL,
0x00000001110a7824ULL, 0x000fe200078e020cULL, 0x0000001e0d1e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000811297824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20eULL,
0x00000001090e7824ULL, 0x000fe200078e0213ULL, 0x0000001c1300720cULL, 0x080fe20003f26070ULL,
0x000000010b1f7824ULL, 0x000fe200000e0608ULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x00000001090a7824ULL, 0x000fe200078e020fULL, 0x0000001c1100720cULL, 0x000fe20003f06070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000181b2d7810ULL, 0x000fc40007ffe0ffULL,
0x0000001c1500720cULL, 0x000fe20003f46070ULL, 0x0000000109167824ULL, 0x000fe200078e0211ULL,
0x000000700e127812ULL, 0x100fe200078ef802ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001c1b2f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000d12127210ULL, 0x000fe20007f9e0ffULL,
0x0000000109107824ULL, 0x000fe200078e0215ULL, 0x000000700a187812ULL, 0x000fe200078ef802ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00001000001a7811ULL, 0x000fc400078e70ffULL,
0x0000000d18187210ULL, 0x080fe20007f7e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000070160e7812ULL, 0x000fe400078ef802ULL, 0x000000201b317810ULL, 0x000fe20007ffe0ffULL,
0x000000010f137824ULL, 0x000fe200020e0608ULL, 0x0000007010147812ULL, 0x000fe200078ef802ULL,
0x0000000109207824ULL, 0x000fe200078e021dULL, 0x0000000d0e0e7210ULL, 0x080fe20007f9e0ffULL,
0x000000011b167824ULL, 0x040fe200078e020cULL, 0x000000241b337810ULL, 0x000fe20007ffe0ffULL,
0x000000010b197824ULL, 0x000fe200018e0608ULL, 0x0000000d14147210ULL, 0x000fe20007f7e0ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x000000281b357810ULL, 0x000fc60007ffe0ffULL,
0x00000001170f7824ULL, 0x100fe200020e0608ULL, 0x0000000716177812ULL, 0x000fe200078ec0ffULL,
0x0000000109107824ULL, 0x000fe200078e022dULL, 0x0000001c1b00720cULL, 0x080fe20003f86070ULL,
0x0000000111157824ULL, 0x000fe200018e0608ULL, 0x00000070200a7812ULL, 0x000fe200078ef802ULL,
0x000000011d167824ULL, 0x140fe200078e020cULL, 0x0000001c1d00720cULL, 0x040fe20003f66070ULL,
0x000000081d2b7824ULL, 0x000fe200078e00ffULL, 0x0ffffff8171d7812ULL, 0x000fe200078ef80cULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000d0a0a7210ULL, 0x000fc40007fde0ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee216ULL, 0x0000000109177824ULL, 0x000fe200078e022fULL,
0x0000007010107812ULL, 0x000fe200078ef802ULL, 0x000000101d1d7824ULL, 0x000fe400078e021aULL,
0x0000008017167825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0003e2000e101c48ULL, 0x00000001210b7824ULL, 0x000fe200030e0608ULL,
0x0000000d10107210ULL, 0x000fe20007fde0ffULL, 0x0000000109207824ULL, 0x000fe200078e0231ULL,
0x0000001c2d00720cULL, 0x040fe20003f86070ULL, 0x000000012d227824ULL, 0x040fe200078e020cULL,
0x0000007016167812ULL, 0x000fe200078ef802ULL, 0x000000082d2d7824ULL, 0x000fe400078e00ffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee222ULL,
0x0000000111117824ULL, 0x000fe200030e0608ULL, 0x0000000d16167210ULL, 0x000fe20007fde0ffULL,
0x0000000109247824ULL, 0x000fe200078e0233ULL, 0x00000070201e7812ULL, 0x002fe200078ef802ULL,
0x00000010231d7824ULL, 0x000fe400078e021aULL, 0x0000008024227825ULL, 0x000fc600078e00ffULL,
0x00000000181d7faeULL, 0x0003e2000e901c48ULL, 0x0000000117177824ULL, 0x000fe200030e0608ULL,
0x0000000d1e1e7210ULL, 0x080fe20007fde0ffULL, 0x0000001025257824ULL, 0x000fe200078e021aULL,
0x0000007022207812ULL, 0x000fe200078ef802ULL, 0x0000001027277824ULL, 0x000fe200078e021aULL,
0x0000001c2f00720cULL, 0x0c0fe20003fa6070ULL, 0x000000012f247824ULL, 0x040fe200078e020cULL,
0x0000000012257faeULL, 0x0005e2000c901c48ULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x0000001c3100720cULL, 0x080fe20003f26070ULL, 0x00000001211f7824ULL, 0x000fe200030e0608ULL,
0x0000000d20207210ULL, 0x000fe20007fde0ffULL, 0x0000000109187824ULL, 0x002fe200078e0235ULL,
0x0000000014277faeULL, 0x0003e2000d101c48ULL, 0x0000001029297824ULL, 0x000fe200078e021aULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000001c3300720cULL, 0x000fc40003f46070ULL, 0x000000000e297faeULL, 0x0007e2000c101c48ULL,
0x000000102b2b7824ULL, 0x000fe200078e021aULL, 0x0000007018187812ULL, 0x000fe200078ef802ULL,
0x0000000123217824ULL, 0x000fe200030e0608ULL, 0x000000301b237810ULL, 0x000fe20007ffe0ffULL,
0x00000001311d7824ULL, 0x100fe200078e020cULL, 0x0000002c1b157810ULL, 0x002fe20007ffe0ffULL,
0x0000000831247824ULL, 0x000fe200078e00ffULL, 0x000000000a2b7faeULL, 0x0003e2000d901c48ULL,
0x0000000133227824ULL, 0x000fe200078e020cULL, 0x0000000d18187210ULL, 0x000fe20007fde0ffULL,
0x0000000109127824ULL, 0x004fe200078e0215ULL, 0xfffffff8241d7812ULL, 0x000fe200078ee21dULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x000000341b257810ULL, 0x000fe20007ffe0ffULL,
0x00000001090e7824ULL, 0x008fe200078e0223ULL, 0x000000381b277810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e021aULL, 0xfffffff833137812ULL, 0x000fe200078ee222ULL,
0x000000102f2f7824ULL, 0x000fe200078e021aULL, 0x0000003c1b297810ULL, 0x000fe20007ffe0ffULL,
0x00000080120a7825ULL, 0x002fe200078e00ffULL, 0x00000000102d7faeULL, 0x0003e2000e101c48ULL,
0x0000001c1500720cULL, 0x000fc40003f86070ULL, 0x000000101d1d7824ULL, 0x000fe200078e021aULL,
0x000000700a0a7812ULL, 0x000fe200078ef802ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000162f7faeULL, 0x0005e2000e901c48ULL, 0x0000001c3500720cULL, 0x080fe40003fa6070ULL,
0x0000000119197824ULL, 0x000fe200030e0608ULL, 0x0000000d0a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001013137824ULL, 0x000fe200078e021aULL, 0x000000001e1d7faeULL, 0x0007e2000c901c48ULL,
0x0000000109107824ULL, 0x002fe200078e0225ULL, 0x000000700e127812ULL, 0x000fe200078ef802ULL,
0x0000000115147824ULL, 0x140fe200078e020cULL, 0x0000000020137faeULL, 0x0003e2000d101c48ULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x0000001c2500720cULL, 0x080fe20003f46070ULL,
0x00000001230e7824ULL, 0x040fe200078e020cULL, 0x0000001c2300720cULL, 0x000fe20003f66070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fc400078ee214ULL,
0x0000001c2700720cULL, 0x080fe20003f26070ULL, 0x00000008231d7824ULL, 0x008fe200078e00ffULL,
0x0000007010147812ULL, 0x000fe200078ef802ULL, 0x000000010b0b7824ULL, 0x000fe200030e0608ULL,
0x0000000d12127210ULL, 0x080fe20007fde0ffULL, 0x0000000135137824ULL, 0x002fe200078e020cULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20eULL, 0x0000000835167824ULL, 0x004fe200078e00ffULL,
0x0000001c2900720cULL, 0x000fe20003f06070ULL, 0x00000001090e7824ULL, 0x000fe400078e0227ULL,
0x0000000125107824ULL, 0x000fe200078e020cULL, 0xfffffff816177812ULL, 0x000fe200078ee213ULL,
0x000000010f137824ULL, 0x000fe200030e0608ULL, 0x0000000d14147210ULL, 0x000fe20007fde0ffULL,
0x0000000825257824ULL, 0x000fc400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x00000001091c7824ULL, 0x000fe200078e0229ULL, 0xfffffff825097812ULL, 0x000fe200078ee210ULL,
0x0000000111157824ULL, 0x000fe200030e0608ULL, 0x000000700e0e7812ULL, 0x000fe200078ef802ULL,
0x000000801c107825ULL, 0x000fc600078e00ffULL, 0x0000000d0e0e7210ULL, 0x080fe20007fde0ffULL,
0x0000000127167824ULL, 0x040fe200078e020cULL, 0x0000007010027812ULL, 0x000fe200078ef802ULL,
0x00000008271f7824ULL, 0x000fe400078e00ffULL, 0x00000001290c7824ULL, 0x040fe400078e020cULL,
0x0000000829217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL,
0x000000010f0f7824ULL, 0x000fe400030e0608ULL, 0x0000001017177824ULL, 0x000fe200078e021aULL,
0xfffffff821217812ULL, 0x000fe200078ee20cULL, 0x000000101b1b7824ULL, 0x100fe200078e021aULL,
0x0000000d020c7210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e021aULL,
0x0000000018177faeULL, 0x0003e2000e901c48ULL, 0x0000001009097824ULL, 0x000fc400078e021aULL,
0x000000101f1f7824ULL, 0x100fe200078e021aULL, 0x000000000a1b7faeULL, 0x0003e2000e101c48ULL,
0x0000001021217824ULL, 0x000fe400078e021aULL, 0x00000001110d7824ULL, 0x000fe200030e0608ULL,
0x00000000121d7faeULL, 0x0003e8000d901c48ULL, 0x0000000014097faeULL, 0x0003e8000d101c48ULL,
0x000000000e1f7faeULL, 0x0003e8000c901c48ULL, 0x000000000c217faeULL, 0x0003e2000c101c48ULL,
0x00000b5000007947ULL, 0x000fea0003800000ULL, 0x0000000c0c0f7811ULL, 0x04afe400078fe8ffULL,
0x000000080c0e7811ULL, 0x000fc400078fe8ffULL, 0x000000040c0d7811ULL, 0x040fe200078fe8ffULL,
0x000000010f0b7824ULL, 0x140fe200078e020cULL, 0x000000180c137811ULL, 0x040fe200078fe8ffULL,
0x000000080f127824ULL, 0x000fe200078e00ffULL, 0x000000100c107811ULL, 0x000fe200078fe8ffULL,
0x000000010e0a7824ULL, 0x100fe200078e020cULL, 0x0000001c0c157811ULL, 0x000fe200078fe8ffULL,
0x000000080e1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff812217812ULL, 0x000fe200078ee20bULL,
0x000000010d087824ULL, 0x040fe200078e020cULL, 0x000000140c127811ULL, 0x040fe200078fe8ffULL,
0x000000080d1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL,
0x00000001130a7824ULL, 0x040fe200078e020cULL, 0x000000280c317811ULL, 0x000fe200078fe8ffULL,
0x0000000813277824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x0000000110117824ULL, 0x100fe200078e020cULL, 0x000000200c177811ULL, 0x000fe200078fe8ffULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0x000000240c327811ULL, 0x000fe200078fe8ffULL,
0x0000000112087824ULL, 0x040fe200078e020cULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x0000000812257824ULL, 0x000fe200078e00ffULL, 0x0000002c0c307811ULL, 0x000fe200078fe8ffULL,
0x00000001150b7824ULL, 0x040fe200078e020cULL, 0xfffffff814117812ULL, 0x000fe200078ee211ULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x00000001310a7824ULL, 0x140fe200078e020cULL, 0x000000300c2e7811ULL, 0x000fe200078fe8ffULL,
0x00000008311f7824ULL, 0x000fe200078e00ffULL, 0xfffffff816297812ULL, 0x000fe200078ee20bULL,
0x0000000117147824ULL, 0x040fe200078e020cULL, 0x000000340c187811ULL, 0x000fe200078fe8ffULL,
0x00000008172b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee20aULL,
0x0000000132087824ULL, 0x000fe200078e020cULL, 0x0000000c0c0a7211ULL, 0x000fe200078fe8ffULL,
0x0000000832197824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee214ULL,
0x00000001300b7824ULL, 0x000fe200078e020cULL, 0x0000003c0c1f7811ULL, 0x000fe200078fe8ffULL,
0x0000000830207824ULL, 0x000fe200078e00ffULL, 0xfffffff8191a7812ULL, 0x000fe200078ee208ULL,
0x000000012e147824ULL, 0x000fe200078e020cULL, 0x000000380c197811ULL, 0x000fe200078fe8ffULL,
0x000000082e237824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x0000000109167824ULL, 0x040fe200078e0215ULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x00000001090a7824ULL, 0x000fe200078e020dULL, 0xfffffff823227812ULL, 0x000fe200078ee214ULL,
0x00000001090d7824ULL, 0x040fe200078e020eULL, 0x000000090c087211ULL, 0x000fe200078fe8ffULL,
0x0000000109147824ULL, 0x000fe200078e0213ULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef80cULL,
0x00000001092d7824ULL, 0x000fe200078e0218ULL, 0x0000100000287811ULL, 0x000fe200078e70ffULL,
0x00000001180e7824ULL, 0x000fc400078e020cULL, 0x0000000818157824ULL, 0x000fe400078e00ffULL,
0x0000000119137824ULL, 0x040fe400078e020cULL, 0x0000000819187824ULL, 0x000fe200078e00ffULL,
0xfffffff8150e7812ULL, 0x000fe200078ee20eULL, 0x00000001092c7824ULL, 0x000fe400078e021fULL,
0x000000011f0c7824ULL, 0x040fe200078e020cULL, 0xfffffff818137812ULL, 0x000fe200078ee213ULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x000062002f187a11ULL, 0x000fe200078038ffULL,
0x00000001090f7824ULL, 0x000fc400078e020fULL, 0x0000000109107824ULL, 0x000fe200078e0210ULL,
0xfffffff81f0c7812ULL, 0x000fe200078ee20cULL, 0x0000000109127824ULL, 0x000fe200078e0212ULL,
0x000063002f2f7a11ULL, 0x000fe200000f3cffULL, 0x00000001091e7824ULL, 0x040fe400078e0217ULL,
0x0000000109327824ULL, 0x040fe400078e0232ULL, 0x0000000109317824ULL, 0x040fe400078e0231ULL,
0x0000000109307824ULL, 0x000fc400078e0230ULL, 0x00000001092e7824ULL, 0x040fe400078e022eULL,
0x00000001092a7824ULL, 0x000fe400078e0219ULL, 0x0000008008087825ULL, 0x000fc800078e00ffULL,
0x000000100b197824ULL, 0x100fe400078e0228ULL, 0x000000101b1b7824ULL, 0x100fe400078e0228ULL,
0x000000101d1d7824ULL, 0x100fe400078e0228ULL, 0x0000001021217824ULL, 0x100fe400078e0228ULL,
0x0000001011237824ULL, 0x100fe400078e0228ULL, 0x0000001025257824ULL, 0x000fc400078e0228ULL,
0x0000001027277824ULL, 0x100fe400078e0228ULL, 0x0000001029297824ULL, 0x100fe400078e0228ULL,
0x000000102b2b7824ULL, 0x100fe400078e0228ULL, 0x000000101a1a7824ULL, 0x100fe400078e0228ULL,
0x000000101c1c7824ULL, 0x100fe400078e0228ULL, 0x0000001020207824ULL, 0x000fc400078e0228ULL,
0x0000001022227824ULL, 0x100fe400078e0228ULL, 0x000000100e247824ULL, 0x100fe400078e0228ULL,
0x0000001013267824ULL, 0x000fe200078e0228ULL, 0x0000007008137812ULL, 0x000fe200078ef802ULL,
0x000000100c287824ULL, 0x000fe400078e0228ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000001318087210ULL, 0x000fc60007f1e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000700c157812ULL, 0x000fc600078ef802ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700a177812ULL, 0x000fc600078ef802ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x00000017180a7210ULL, 0x000fc60007f3e0ffULL, 0x0000000109097824ULL, 0x100fe200000e062fULL,
0x00000015180c7210ULL, 0x000fe20007f1e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000007010157812ULL, 0x100fe400078ef802ULL, 0x000000700e137812ULL, 0x100fe200078ef802ULL,
0x000000010d0d7824ULL, 0x000fe200000e062fULL, 0x0000001518107210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000013180e7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008197faeULL, 0x0003e2000b901c48ULL,
0x000000701e337812ULL, 0x100fe200078ef802ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007016357812ULL, 0x000fc400078ef802ULL, 0x00000033181e7210ULL, 0x000fe20007f7e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007014377812ULL, 0x000fc600078ef802ULL,
0x000000010f0f7824ULL, 0x000fe200010e062fULL, 0x0000007012397812ULL, 0x000fe200078ef802ULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000003518167210ULL, 0x000fc60007f5e0ffULL,
0x000000010b0b7824ULL, 0x100fe200008e062fULL, 0x0000003718147210ULL, 0x000fe20007f3e0ffULL,
0x0000008031347825ULL, 0x000fe200078e00ffULL, 0x0000007032497812ULL, 0x100fe400078ef802ULL,
0x000000000a1b7faeULL, 0x0003e2000b901c48ULL, 0x0000000111117824ULL, 0x000fe200000e062fULL,
0x0000003918127210ULL, 0x000fe20007f1e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000007034477812ULL, 0x100fe200078ef802ULL, 0x000000000c1d7faeULL, 0x0003e4000b901c48ULL,
0x000000802e367825ULL, 0x000fe200078e00ffULL, 0x0000007030457812ULL, 0x100fe200078ef802ULL,
0x000000000e217faeULL, 0x0003e4000b901c48ULL, 0x000000802d387825ULL, 0x000fe200078e00ffULL,
0x0000007036437812ULL, 0x100fe200078ef802ULL, 0x0000000010237faeULL, 0x0003e4000b901c48ULL,
0x000000802a3a7825ULL, 0x000fe200078e00ffULL, 0x0000007038417812ULL, 0x000fc600078ef802ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x000000703a3f7812ULL, 0x100fe400078ef802ULL,
0x0000004118387210ULL, 0x040fe20007f9e0ffULL, 0x0000000113137824ULL, 0x100fe200000e062fULL,
0x0000004918327210ULL, 0x040fe20007f1e0ffULL, 0x0000000115157824ULL, 0x100fe200008e062fULL,
0x0000004718347210ULL, 0x000fe20007f3e0ffULL, 0x0000000117177824ULL, 0x100fe200010e062fULL,
0x000000702c3d7812ULL, 0x000fe200078ef802ULL, 0x000000011f1f7824ULL, 0x100fe200018e062fULL,
0x0000004518307210ULL, 0x040fe20007f5e0ffULL, 0x0000000133337824ULL, 0x100fe200000e062fULL,
0x0000004318367210ULL, 0x040fe20007f7e0ffULL, 0x0000000135357824ULL, 0x100fe200008e062fULL,
0x0000003f183a7210ULL, 0x040fe20007fbe0ffULL, 0x0000000012257faeULL, 0x0003e2000b901c48ULL,
0x0000003d182c7210ULL, 0x000fe20007fde0ffULL, 0x0000000131317824ULL, 0x000fc400010e062fULL,
0x0000000014277faeULL, 0x0003e2000b901c48ULL, 0x0000000137377824ULL, 0x100fe400018e062fULL,
0x0000000139397824ULL, 0x100fe200020e062fULL, 0x0000000016297faeULL, 0x0003e2000b901c48ULL,
0x000000013b3b7824ULL, 0x100fe400028e062fULL, 0x000000012d2d7824ULL, 0x000fe200030e062fULL,
0x000000001e2b7faeULL, 0x0003e8000b901c48ULL, 0x00000000321a7faeULL, 0x0003e8000b901c48ULL,
0x00000000341c7faeULL, 0x0003e8000b901c48ULL, 0x0000000030207faeULL, 0x0003e8000b901c48ULL,
0x0000000036227faeULL, 0x0003e8000b901c48ULL, 0x0000000038247faeULL, 0x0003e8000b901c48ULL,
0x000000003a267faeULL, 0x0003e8000b901c48ULL, 0x000000002c287faeULL, 0x0003e4000b901c48ULL,
0x0000000267677810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff697424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000786700720cULL, 0x000fda0003f06070ULL,
0x0000000203028824ULL, 0x000fc800078e00ffULL, 0x0000680002098a24ULL, 0x002fc800078e0267ULL,
0x0000640009088625ULL, 0x000fca00078e0006ULL, 0x0000000808698981ULL, 0x000324000c1e1900ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01760400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc8000001140bULL, 0x0000000d02027211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000202027819ULL, 0x000fc8000000120bULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0205ULL, 0x00000003ff047819ULL, 0x000fc80000011602ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000f02047812ULL, 0x000fc600078ec0ffULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x0000001004097824ULL, 0x040fe400078e00ffULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x0000000f05027812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f009027812ULL, 0x000fe400078ee202ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x00000000020c7984ULL, 0x000e62000000cc00ULL,
0x000000f004057812ULL, 0x000fca00078ee205ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001002007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff067224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01760400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008040d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e05ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011409ULL, 0x0000000d02027211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000202027819ULL, 0x000fc80000001209ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff7300720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x00005800ff6a7624ULL, 0x000fe200078e00ffULL, 0x8000580070747a10ULL, 0x000fe20007ffe0ffULL,
0x00006800037d7a24ULL, 0x000fe200078e02ffULL, 0x0000010075757810ULL, 0x000fe20007ffe0ffULL,
0x3db504f307037820ULL, 0x010fe20000410000ULL, 0x0000001f6a047810ULL, 0x040fe20007ffe0ffULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0xffffffff6a797810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff047819ULL, 0x000fc40000011604ULL, 0x00017688007a7811ULL, 0x040fe400078e18ffULL,
0x00017608007b7811ULL, 0x000fe400078e28ffULL, 0x000000096a6a7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x0ffffffe046f7812ULL, 0x000fc400078ec0ffULL,
0x0000000263047810ULL, 0x040fe20007ffe0ffULL, 0x0000010063667824ULL, 0x000fe200078e0275ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000697c697224ULL, 0x010fe200078e02ffULL,
0x000000730400720cULL, 0x000fc40003f06070ULL, 0x0000004066057812ULL, 0x000fe400078ec0ffULL,
0x0000000162687812ULL, 0x000fc600078e0cffULL, 0x0000000172057824ULL, 0x000fcc00078e0205ULL,
0x00000cc000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff167819ULL, 0x102fe40000011602ULL,
0x0000620069087a11ULL, 0x000fe400078038ffULL, 0x00000004160a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000116067824ULL, 0x040fe200078e0205ULL, 0x00000008160c7810ULL, 0x000fe40007ffe0ffULL,
0x0000006670197217ULL, 0x000fe20007800000ULL, 0x000000010a047824ULL, 0x100fe200078e0202ULL,
0x0000001016147810ULL, 0x000fe20007ffe0ffULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0x0000000c160e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010c077824ULL, 0x000fe200078e0202ULL,
0x00000014161c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080c227824ULL, 0x000fe200078e00ffULL,
0xfffffff809207812ULL, 0x000fe200078ee204ULL, 0x0000001002097824ULL, 0x000fe200078e00ffULL,
0x0000630069047a11ULL, 0x000fe200000f3cffULL, 0x0000000119197824ULL, 0x000fe200078e0a66ULL,
0xfffffff822227812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000007009097812ULL, 0x000fc400078ec0ffULL, 0x000000190a00720cULL, 0x000fe20003fa6070ULL,
0x0000000114187824ULL, 0x100fe200078e0202ULL, 0x0000000906137212ULL, 0x000fe200078efcffULL,
0x000000010a067824ULL, 0x000fe200078e0205ULL, 0x000000190c00720cULL, 0x000fe20003f26070ULL,
0x00000008140d7824ULL, 0x000fe200078e00ffULL, 0x0000001308127210ULL, 0x000fe20007f1e0ffULL,
0x000000010e0b7824ULL, 0x040fe200078e0202ULL, 0x000000190e00720cULL, 0x0c0fe20003f46070ULL,
0x000000080e247824ULL, 0x000fe200078e00ffULL, 0xfffffff80d187812ULL, 0x000fe200078ee218ULL,
0x0000000107137824ULL, 0x000fe200000e0604ULL, 0x000000191400720cULL, 0x000fe20003f06070ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fc400078ee20bULL,
0x0000001816287810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0a7824ULL, 0x100fe200078e0205ULL,
0x0000000906117212ULL, 0x080fe200078efcffULL, 0x000000010e0c7824ULL, 0x000fe200078e0205ULL,
0x0000001c162a7810ULL, 0x000fe20007ffe0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000811067210ULL, 0x000fe40007f7e0ffULL, 0x00000020162c7810ULL, 0x000fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000090a0f7212ULL, 0x000fc400078efcffULL,
0x00000024162e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114147824ULL, 0x100fe200078e0205ULL,
0x000000090c117212ULL, 0x000fe200078efcffULL, 0x000000011c1a7824ULL, 0x000fe200078e0205ULL,
0x000000080f0e7210ULL, 0x000fe20007f9e0ffULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000000107077824ULL, 0x000fe200018e0604ULL, 0x0000000811107210ULL, 0x000fe20007f7e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000914177212ULL, 0x000fc600078efcffULL,
0x000000010d117824ULL, 0x100fe200018e0604ULL, 0x00000008170c7210ULL, 0x080fe20007f7e0ffULL,
0x000000010b0f7824ULL, 0x100fe200020e0604ULL, 0x000000091a0b7212ULL, 0x000fe200078efcffULL,
0x0000000128147824ULL, 0x000fe400078e0205ULL, 0x00000001150d7824ULL, 0x000fe200018e0604ULL,
0x000000080b0a7210ULL, 0x000fe20007f9e0ffULL, 0x00000001161a7824ULL, 0x000fe200078e0202ULL,
0x000000191c00720cULL, 0x000fe20003f66070ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x000000071a1d7812ULL, 0x000fe200078ec0ffULL, 0x000000011b0b7824ULL, 0x000fe200020e0604ULL,
0x00000009141b7212ULL, 0x000fe200078efcffULL, 0x0000000200177824ULL, 0x000fe200078e0268ULL,
0x000000191600720cULL, 0x000fe20003f86070ULL, 0x000000012a1a7824ULL, 0x000fe200078e0205ULL,
0x000000081b147210ULL, 0x000fe20007fde0ffULL, 0x000000011c1e7824ULL, 0x140fe200078e0202ULL,
0x0000100017177811ULL, 0x000fe200078e68ffULL, 0x000000081c1f7824ULL, 0x000fe200078e00ffULL,
0x0ffffff81d1c7812ULL, 0x000fe200078ef802ULL, 0x000000801a1a7825ULL, 0x000fc600078e00ffULL,
0xfffffff81f267812ULL, 0x000fe200078ee21eULL, 0x000000101c1f7824ULL, 0x000fe200078e0217ULL,
0x000000091a1d7212ULL, 0x000fe200078efcffULL, 0x000000012c1c7824ULL, 0x100fe400078e0205ULL,
0x0000000115157824ULL, 0x000fe200030e0604ULL, 0x000000081d1a7210ULL, 0x000fe20007fde0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121f7faeULL, 0x0003e2000e101c48ULL, 0x000000192800720cULL, 0x000fe40003f86070ULL,
0x000000012e1e7824ULL, 0x000fc400078e0205ULL, 0x0000000128217824ULL, 0x040fe400078e0202ULL,
0x0000000828287824ULL, 0x000fe400078e00ffULL, 0x000000011b1b7824ULL, 0x000fe400030e0604ULL,
0x000000082a257824ULL, 0x000fe200078e00ffULL, 0x000000091c137212ULL, 0x082fe200078efcffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe400078ee221ULL,
0x0000000813127210ULL, 0x000fe20007fde0ffULL, 0x0000001020217824ULL, 0x000fe200078e0217ULL,
0x000000091e237212ULL, 0x000fe200078efcffULL, 0x000000012a207824ULL, 0x000fc400078e0202ULL,
0x000000011d137824ULL, 0x100fe200030e0604ULL, 0x00000008231c7210ULL, 0x000fe20007fde0ffULL,
0x0000000006217faeULL, 0x0003e2000e901c48ULL, 0x000000192a00720cULL, 0x080fe20003fa6070ULL,
0x0000001022237824ULL, 0x100fe200078e0217ULL, 0x00000028162a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1d7824ULL, 0x000fe200030e0604ULL, 0xfffffff825207812ULL, 0x000fe200078ee220ULL,
0x00000010241f7824ULL, 0x000fe200078e0217ULL, 0x000000000e237faeULL, 0x0005e2000c901c48ULL,
0x000000012c1e7824ULL, 0x140fe200078e0202ULL, 0x000000192c00720cULL, 0x0c0fe20003f26070ULL,
0x000000082c257824ULL, 0x000fe200078e00ffULL, 0x00000000101f7faeULL, 0x0007e2000d101c48ULL,
0x000000012a067824ULL, 0x002fe200078e0205ULL, 0x000000192e00720cULL, 0x040fe20003f46070ULL,
0x000000012e227824ULL, 0x000fe200078e0202ULL, 0xfffffff8251e7812ULL, 0x000fe200078ee21eULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000003c16247810ULL, 0x000fc60007ffe0ffULL,
0x00000010180f7824ULL, 0x104fe200078e0217ULL, 0x0000002c16187810ULL, 0x000fe20007ffe0ffULL,
0x000000082e277824ULL, 0x000fe200078e00ffULL, 0x0000000906217212ULL, 0x000fe200078efcffULL,
0x0000001026117824ULL, 0x008fe200078e0217ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c48ULL,
0x00000001180e7824ULL, 0x000fe200078e0205ULL, 0xfffffff827227812ULL, 0x000fe200078ee222ULL,
0x000000101e237824ULL, 0x100fe200078e0217ULL, 0x000000000a117faeULL, 0x0005e2000d901c48ULL,
0x00000030161e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010281f7824ULL, 0x100fe200078e0217ULL,
0x0000000821067210ULL, 0x000fe20007fde0ffULL, 0x0000001020217824ULL, 0x100fe200078e0217ULL,
0x0000003416207810ULL, 0x000fe20007ffe0ffULL, 0x0000001022257824ULL, 0x000fe200078e0217ULL,
0x00000000141f7faeULL, 0x0007e2000e101c48ULL, 0x000000011e0c7824ULL, 0x002fe200078e0205ULL,
0x0000003816227810ULL, 0x000fe20007ffe0ffULL, 0x0000000107077824ULL, 0x000fe200030e0604ULL,
0x000000001a217faeULL, 0x0003e2000e901c48ULL, 0x000000800e0a7825ULL, 0x004fe200078e00ffULL,
0x000000192a00720cULL, 0x000fc40003fa6070ULL, 0x0000000012237faeULL, 0x0005e2000c901c48ULL,
0x00000001200e7824ULL, 0x000fe200078e0205ULL, 0x000000090a0d7212ULL, 0x000fe200078efcffULL,
0x000000012a107824ULL, 0x100fe200078e0202ULL, 0x000000001c257faeULL, 0x0009e2000d101c48ULL,
0x000000191800720cULL, 0x080fe20003f86070ULL, 0x000000082a157824ULL, 0x008fe200078e00ffULL,
0x000000080d0a7210ULL, 0x000fe20007fde0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000191e00720cULL, 0x080fe40003f66070ULL, 0x000000192000720cULL, 0x080fe20003f46070ULL,
0x0000000118127824ULL, 0x104fe200078e0202ULL, 0x000000192200720cULL, 0x080fe20003f26070ULL,
0x000000011e137824ULL, 0x000fe200078e0202ULL, 0x000000192400720cULL, 0x000fe20003f06070ULL,
0x0000000818197824ULL, 0x000fe200078e00ffULL, 0x000000090c117212ULL, 0x000fe200078efcffULL,
0x000000081e187824ULL, 0x000fe200078e00ffULL, 0xfffffff815147812ULL, 0x000fe200078ee210ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff819167812ULL, 0x000fc400078ee212ULL,
0xfffffff818187812ULL, 0x000fe200078ee213ULL, 0x000000010b0b7824ULL, 0x000fe200030e0604ULL,
0x00000008110c7210ULL, 0x080fe20007fde0ffULL, 0x0000000122107824ULL, 0x000fe200078e0205ULL,
0x000000090e137212ULL, 0x000fe200078efcffULL, 0x0000000120157824ULL, 0x000fe400078e0202ULL,
0x000000010d0d7824ULL, 0x000fe200030e0604ULL, 0x0000000813127210ULL, 0x000fe20007fde0ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x00000008201a7824ULL, 0x002fe400078e00ffULL,
0x00000001240e7824ULL, 0x000fe200078e0205ULL, 0x0000000910057212ULL, 0x000fe200078efcffULL,
0x000000010f137824ULL, 0x000fe200030e0604ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee215ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000805107210ULL, 0x000fc60007fde0ffULL,
0x0000000122157824ULL, 0x100fe200078e0202ULL, 0x000000090e097212ULL, 0x000fe200078efcffULL,
0x0000000822227824ULL, 0x000fe400078e00ffULL, 0x0000000124197824ULL, 0x040fe400078e0202ULL,
0x00000008241c7824ULL, 0x010fe200078e00ffULL, 0xfffffff8220e7812ULL, 0x000fe200078ee215ULL,
0x0000000111117824ULL, 0x000fe200030e0604ULL, 0x0000000809087210ULL, 0x000fe20007fde0ffULL,
0x0000001014057824ULL, 0x000fe200078e0217ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee219ULL,
0x0000001016157824ULL, 0x000fc400078e0217ULL, 0x0000001018197824ULL, 0x100fe200078e0217ULL,
0x0000000006057faeULL, 0x0003e2000e901c48ULL, 0x000000101a1b7824ULL, 0x100fe400078e0217ULL,
0x000000100e1d7824ULL, 0x100fe200078e0217ULL, 0x000000000a157faeULL, 0x0003e2000e101c48ULL,
0x000000101c177824ULL, 0x000fe400078e0217ULL, 0x000000010f097824ULL, 0x000fe200030e0604ULL,
0x000000000c197faeULL, 0x0003e8000d901c48ULL, 0x00000000121b7faeULL, 0x0003e8000d101c48ULL,
0x00000000101d7faeULL, 0x0003e8000c901c48ULL, 0x0000000008177faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x0000000c020e7811ULL, 0x042fe200078fe8ffULL,
0x0000001002437824ULL, 0x040fe200078e00ffULL, 0x0000000402087811ULL, 0x000fc400078fe8ffULL,
0x0000001802117811ULL, 0x000fe200078fe8ffULL, 0x000000010e097824ULL, 0x100fe200078e0202ULL,
0x0000000802067811ULL, 0x000fe200078fe8ffULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0x00000010020c7811ULL, 0x000fe200078fe8ffULL, 0x0000000108047824ULL, 0x100fe200078e0202ULL,
0x00000024021c7811ULL, 0x000fe200078fe8ffULL, 0x00000008083d7824ULL, 0x000fe200078e00ffULL,
0xfffffff810397812ULL, 0x000fe200078ee209ULL, 0x0000000111097824ULL, 0x040fe200078e0202ULL,
0x0000001402107811ULL, 0x000fe200078fe8ffULL, 0x0000000811147824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL, 0x0000000106077824ULL, 0x100fe200078e0202ULL,
0x0000001c02127811ULL, 0x000fe200078fe8ffULL, 0x00000008060a7824ULL, 0x000fe200078e00ffULL,
0xfffffff814337812ULL, 0x000fe200078ee209ULL, 0x000000010c047824ULL, 0x100fe200078e0202ULL,
0x0000002002147811ULL, 0x000fe200078fe8ffULL, 0x000000080c377824ULL, 0x000fe200078e00ffULL,
0xfffffff80a3b7812ULL, 0x000fe200078ee207ULL, 0x000000011c097824ULL, 0x000fe200078e0202ULL,
0x00000028021a7811ULL, 0x000fe200078fe8ffULL, 0x000000081c167824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee204ULL, 0x0000000110077824ULL, 0x100fe200078e0202ULL,
0x0000002c02187811ULL, 0x000fe200078fe8ffULL, 0x00000008100a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8162d7812ULL, 0x000fe200078ee209ULL, 0x0000000112047824ULL, 0x100fe200078e0202ULL,
0x0000003002167811ULL, 0x000fe200078fe8ffULL, 0x0000000812317824ULL, 0x000fe200078e00ffULL,
0xfffffff80a357812ULL, 0x000fe200078ee207ULL, 0x0000000114077824ULL, 0x000fe200078e0202ULL,
0x00000034021e7811ULL, 0x000fe200078fe8ffULL, 0x00000008140a7824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee204ULL, 0x0000000116097824ULL, 0x100fe200078e0202ULL,
0x0000003c02227811ULL, 0x000fe200078fe8ffULL, 0x0000000816207824ULL, 0x000fe200078e00ffULL,
0xfffffff80a2f7812ULL, 0x000fe200078ee207ULL, 0x000000011a047824ULL, 0x140fe200078e0202ULL,
0x0000007043437812ULL, 0x000fe200078ec0ffULL, 0x000000081a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff820277812ULL, 0x000fe200078ee209ULL, 0x0000000118077824ULL, 0x000fe200078e0202ULL,
0x0000003802207811ULL, 0x000fe200078fe8ffULL, 0x00000008180a7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL, 0x000000011e047824ULL, 0x140fe200078e0202ULL,
0x0000620069287a11ULL, 0x040fe200078038ffULL, 0x000000081e0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a297812ULL, 0x000fe200078ee207ULL, 0x0000000120077824ULL, 0x040fe200078e0202ULL,
0x0000630069417a11ULL, 0x000fe200000f3cffULL, 0x00000008200a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee204ULL, 0x0000000122097824ULL, 0x000fe200078e0202ULL,
0x0000000202047211ULL, 0x000fe200078fe8ffULL, 0x0000000822247824ULL, 0x000fe200078e00ffULL,
0xfffffff80a257812ULL, 0x000fe200078ee207ULL, 0x0000000108087824ULL, 0x100fe200078e0205ULL,
0x0000000704077812ULL, 0x000fe200078ec0ffULL, 0x0000000106047824ULL, 0x100fe200078e0205ULL,
0x0000000502067211ULL, 0x000fe200078fe8ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0205ULL,
0xfffffff8240d7812ULL, 0x000fe200078ee209ULL, 0x0000000200097824ULL, 0x000fe200078e0268ULL,
0x0ffffff8073f7812ULL, 0x000fe200078ef802ULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0x0000100009247811ULL, 0x000fe200078e68ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000004306137212ULL, 0x000fc600078efcffULL, 0x000000010c0c7824ULL, 0x100fe200078e0205ULL,
0x00000013280a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000110107824ULL, 0x100fe400078e0205ULL,
0x0000000111117824ULL, 0x100fe400078e0205ULL, 0x0000000112127824ULL, 0x100fe400078e0205ULL,
0x0000000114147824ULL, 0x100fe400078e0205ULL, 0x000000011c1c7824ULL, 0x000fc400078e0205ULL,
0x000000011a1a7824ULL, 0x100fe400078e0205ULL, 0x0000000118187824ULL, 0x100fe400078e0205ULL,
0x0000000116167824ULL, 0x100fe400078e0205ULL, 0x000000011e1e7824ULL, 0x100fe400078e0205ULL,
0x0000000120207824ULL, 0x100fe400078e0205ULL, 0x0000000122227824ULL, 0x000fc400078e0205ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000004304157212ULL, 0x000fc600078efcffULL, 0x000000100b267824ULL, 0x100fe200078e0224ULL,
0x00000043080b7212ULL, 0x080fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e0224ULL,
0x000000430e137212ULL, 0x000fe200078efcffULL, 0x000000103d3d7824ULL, 0x100fe200078e0224ULL,
0x0000000b28087210ULL, 0x040fe20007f3e0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0224ULL,
0x0000001328047210ULL, 0x000fe20007f5e0ffULL, 0x0000001039397824ULL, 0x100fe400078e0224ULL,
0x0000001037377824ULL, 0x000fc400078e0224ULL, 0x0000001035357824ULL, 0x100fe400078e0224ULL,
0x0000001033337824ULL, 0x100fe400078e0224ULL, 0x0000001031317824ULL, 0x100fe400078e0224ULL,
0x000000102f2f7824ULL, 0x100fe400078e0224ULL, 0x000000102d2d7824ULL, 0x100fe400078e0224ULL,
0x000000102b2b7824ULL, 0x000fc400078e0224ULL, 0x0000001029297824ULL, 0x100fe400078e0224ULL,
0x0000001027277824ULL, 0x100fe400078e0224ULL, 0x0000001025257824ULL, 0x100fe400078e0224ULL,
0x000000100d247824ULL, 0x000fe400078e0224ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x00000001070b7824ULL, 0x100fe200000e0641ULL, 0x0000001528067210ULL, 0x000fe20007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000430c137212ULL, 0x000fe400078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a3f7faeULL, 0x0003e2000b901c48ULL,
0x0000000105077824ULL, 0x100fe200000e0641ULL, 0x00000013280c7210ULL, 0x000fe20007f1e0ffULL,
0x000000010f057824ULL, 0x000fe200010e0641ULL, 0x0000004314177212ULL, 0x000fe200078efcffULL,
0x00000080100e7825ULL, 0x000fc600078e00ffULL, 0x0000001728147210ULL, 0x000fe20007f7e0ffULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x000000430e1d7212ULL, 0x000fc600078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000043101b7212ULL, 0x000fc600078efcffULL,
0x000000010d0d7824ULL, 0x100fe200000e0641ULL, 0x0000004312197212ULL, 0x000fe200078efcffULL,
0x0000000109097824ULL, 0x000fe200008e0641ULL, 0x0000001d280e7210ULL, 0x000fe20007f1e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000001b28107210ULL, 0x040fe40007f3e0ffULL,
0x0000001928127210ULL, 0x000fe20007f5e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000431c4f7212ULL, 0x080fe200078efcffULL, 0x00000000083d7faeULL, 0x0003e4000b901c48ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000431a4d7212ULL, 0x080fe200078efcffULL,
0x00000000063b7faeULL, 0x0003e4000b901c48ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000043184b7212ULL, 0x080fe200078efcffULL, 0x0000000004397faeULL, 0x0003e4000b901c48ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000004316497212ULL, 0x080fe200078efcffULL,
0x000000000c377faeULL, 0x0003e4000b901c48ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000431e477212ULL, 0x000fc600078efcffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000004320457212ULL, 0x000fe400078efcffULL, 0x00000047281e7210ULL, 0x040fe20007f9e0ffULL,
0x000000010f0f7824ULL, 0x100fe200000e0641ULL, 0x0000004f281c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000111117824ULL, 0x100fe200008e0641ULL, 0x0000004d281a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000113137824ULL, 0x100fe200010e0641ULL, 0x0000004322437212ULL, 0x000fe200078efcffULL,
0x0000000115157824ULL, 0x100fe200018e0641ULL, 0x0000004b28187210ULL, 0x040fe20007f5e0ffULL,
0x000000011d1d7824ULL, 0x100fe200000e0641ULL, 0x0000004928167210ULL, 0x040fe20007f7e0ffULL,
0x000000011b1b7824ULL, 0x100fe200008e0641ULL, 0x0000004528207210ULL, 0x040fe20007fbe0ffULL,
0x000000000e357faeULL, 0x0003e2000b901c48ULL, 0x0000004328227210ULL, 0x000fe20007fde0ffULL,
0x0000000119197824ULL, 0x000fc400010e0641ULL, 0x0000000010337faeULL, 0x0003e2000b901c48ULL,
0x0000000117177824ULL, 0x100fe400018e0641ULL, 0x000000011f1f7824ULL, 0x100fe200020e0641ULL,
0x0000000012317faeULL, 0x0003e2000b901c48ULL, 0x0000000121217824ULL, 0x100fe400028e0641ULL,
0x0000000123237824ULL, 0x000fe200030e0641ULL, 0x00000000142f7faeULL, 0x0003e8000b901c48ULL,
0x000000001c2d7faeULL, 0x0003e8000b901c48ULL, 0x000000001a2b7faeULL, 0x0003e8000b901c48ULL,
0x0000000018297faeULL, 0x0003e8000b901c48ULL, 0x0000000016277faeULL, 0x0003e8000b901c48ULL,
0x000000001e267faeULL, 0x0003e8000b901c48ULL, 0x0000000020257faeULL, 0x0003e8000b901c48ULL,
0x0000000022247faeULL, 0x0003e4000b901c48ULL, 0x0000000267677810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff697424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000786700720cULL, 0x000fda0003f06070ULL, 0x000000027d068824ULL, 0x002fe400078e0267ULL,
0x00000004ff078424ULL, 0x000fc800078e00ffULL, 0x0000640006068625ULL, 0x000fe200078e0007ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000806698981ULL, 0x000322000c1e1900ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x002fc80000000000ULL, 0xfffffff802057812ULL, 0x000fe200078ec0ffULL,
0x00000002003c7824ULL, 0x000fe200078e0262ULL, 0x00000001043d7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000705057812ULL, 0x000fc400078ef802ULL,
0x000010003c3c7811ULL, 0x000fc600078e68ffULL, 0x0000000105067824ULL, 0x060fe400078e0204ULL,
0x0000000805077824ULL, 0x000fca00078e00ffULL, 0xfffffff807077812ULL, 0x000fe200078ee206ULL,
0x0000000805067824ULL, 0x040fe400078e00ffULL, 0x0000000105057824ULL, 0x000fe400078e023dULL,
0x0000001007077824ULL, 0x000fc600078e023cULL, 0xfffffff806057812ULL, 0x000fe400078ee205ULL,
0x000000000710783bULL, 0x000e660000000200ULL, 0x0000001005147824ULL, 0x000fcc00078e023cULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00000018ff0b7819ULL, 0x002fe20000011413ULL,
0x00000010005a7306ULL, 0x000fe20000009400ULL, 0x00000018ff057819ULL, 0x000fe40000011410ULL,
0x00000018ff077819ULL, 0x000fe40000011412ULL, 0x00000018ff067819ULL, 0x000fe40000011411ULL,
0x00000018ff0d7819ULL, 0x004fe20000011415ULL, 0x0000000b00187306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x000fc40000011414ULL, 0x00000018ff0e7819ULL, 0x000fe40000011416ULL,
0x00000018ff0f7819ULL, 0x000fc60000011417ULL, 0x0000000b00097306ULL, 0x000ff00000205400ULL,
0x0000000b00507306ULL, 0x0003f0000020d400ULL, 0x00000010005d7306ULL, 0x000ea20000005400ULL,
0x00010000100b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000001000467306ULL, 0x0002f0000000d400ULL, 0x00000005004d7306ULL, 0x000fe20000209400ULL,
0x0000010010107824ULL, 0x002fe200078e00ffULL, 0x0000005d5a00720bULL, 0x004fe20003fbd000ULL,
0x00010000135a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000005004c7306ULL, 0x000e620000205400ULL, 0x00000018ff657819ULL, 0x000fcc000001145aULL,
0x0000000146465812ULL, 0x008fe200078efcffULL, 0x0000000500477306ULL, 0x000eb0000020d400ULL,
0x0000000d003f7306ULL, 0x000fe20000209400ULL, 0x0000004c4d00720bULL, 0x002fce0003fdd000ULL,
0x0000000d000a7306ULL, 0x000fec0000205400ULL, 0x0000000147476812ULL, 0x004fe400078efcffULL,
0x0000000d00057306ULL, 0x0003f0000020d400ULL, 0x0000000c00457306ULL, 0x000fe20000209400ULL,
0x00000020020d7810ULL, 0x002fc80007ffe0ffULL, 0xfffffff80d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000000c00407306ULL, 0x000ff00000205400ULL, 0x0000000c00087306ULL, 0x0003f0000020d400ULL,
0x0000001000557306ULL, 0x000fe20000209400ULL, 0x00010000110c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000001000577306ULL, 0x000e700000205400ULL,
0x0000001000437306ULL, 0x0004f0000020d400ULL, 0x0000000c00197306ULL, 0x000fe20000209400ULL,
0x000000070d107812ULL, 0x004fc400078ef802ULL, 0x000000575500720bULL, 0x002fc60003f1d000ULL,
0x00000008100d7824ULL, 0x040fe400078e00ffULL, 0x0000000c001a7306ULL, 0x000e620000205400ULL,
0x00000001103d7824ULL, 0x000fce00078e023dULL, 0x0000000c006e7306ULL, 0x000462000020d400ULL,
0x0000000143430812ULL, 0x008fc800078efcffULL, 0x000000434747723eULL, 0x000fc600000010ffULL,
0x0000001100567306ULL, 0x000fe20000009400ULL, 0x00000001100c7824ULL, 0x044fe200078e0204ULL,
0x0000001a1900720bULL, 0x002fe20003f1d000ULL, 0x0000000810107824ULL, 0x000fc600078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe400078ee20cULL, 0x0000001100517306ULL, 0x000e620000005400ULL,
0xfffffff8103d7812ULL, 0x000fe400078ee23dULL, 0x000000100d0d7824ULL, 0x000fc600078e023cULL,
0x000000103d107824ULL, 0x000fe200078e023cULL, 0x000000016e6e0812ULL, 0x000fe200078efcffULL,
0x00000011006c7306ULL, 0x0004f0000000d400ULL, 0x00000007001b7306ULL, 0x000fe20000209400ULL,
0x0000010011117824ULL, 0x004fe200078e00ffULL, 0x000000515600720bULL, 0x002fe20003f3d000ULL,
0x0000010013517824ULL, 0x000fca00078e00ffULL, 0x0000000700447306ULL, 0x000e620000205400ULL,
0x00000018ff567819ULL, 0x000fcc0000011451ULL, 0x000000016c6c1812ULL, 0x008fe200078efcffULL,
0x00000007004a7306ULL, 0x000ea2000020d400ULL, 0x000000091800720bULL, 0x000fce0003f3d000ULL,
0x0000000e00417306ULL, 0x000fe20000209400ULL, 0x000000441b00720bULL, 0x002fca0003fbd000ULL,
0x0000000150501812ULL, 0x000fe400078efcffULL, 0x0000000e003e7306ULL, 0x000fec0000205400ULL,
0x000000014a4a5812ULL, 0x004fe400078efcffULL, 0x0000000e00077306ULL, 0x0003f0000020d400ULL,
0x0000000b00527306ULL, 0x000fe20000209400ULL, 0x00000018ff0e7819ULL, 0x002fce0000011411ULL,
0x0000000b00537306ULL, 0x000e700000205400ULL, 0x0000000600497306ULL, 0x000ff00000209400ULL,
0x00000006004e7306ULL, 0x000fe20000205400ULL, 0x000000535200720bULL, 0x002fce0003f5d000ULL,
0x00000006006b7306ULL, 0x000ff0000020d400ULL, 0x0000000f005c7306ULL, 0x000ff00000209400ULL,
0x0000000f005b7306ULL, 0x000ff00000205400ULL, 0x0000000f00067306ULL, 0x000ff0000020d400ULL,
0x0000000e00117306ULL, 0x000ff00000209400ULL, 0x0000000e00487306ULL, 0x000e700000205400ULL,
0x0000000e006d7306ULL, 0x0005f0000020d400ULL, 0x0000000b00427306ULL, 0x0006e2000020d400ULL,
0x000000000d0c783bULL, 0x004ea20000000200ULL, 0x000000481100720bULL, 0x002fe20003fdd000ULL,
0x0001000014117824ULL, 0x000fca00078e00ffULL, 0x00000012004f7306ULL, 0x000fe20000009400ULL,
0x00010000120b7824ULL, 0x008fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001140bULL,
0x0000001200547306ULL, 0x000e620000005400ULL, 0x0000000142422812ULL, 0x000fe400078efcffULL,
0x0000004e4900720bULL, 0x000fe40003f5d000ULL, 0x000000016d6d6812ULL, 0x000fe400078efcffULL,
0x000000464246723eULL, 0x000fe200000010ffULL, 0x00000012004b7306ULL, 0x0006b0000000d400ULL,
0x0000005e000b7306ULL, 0x000fe20000209400ULL, 0x0000010012127824ULL, 0x008fe200078e00ffULL,
0x000000016b6b2812ULL, 0x000fc400078efcffULL, 0x000000544f00720bULL, 0x002fe40003f9d000ULL,
0x00000018ff5f7819ULL, 0x000fe40000011412ULL, 0x0000005e00767306ULL, 0x000e620000205400ULL,
0x00000018ff557819ULL, 0x004fce000001140eULL, 0x0000001400197306ULL, 0x000fe20000009400ULL,
0x000000014b4b4812ULL, 0x000fce00078efcffULL, 0x00000014001a7306ULL, 0x000ea20000005400ULL,
0x000000760b00720bULL, 0x002fe20003fdd000ULL, 0x00010000150b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe2000001140bULL, 0x0000005f00587306ULL, 0x000ff00000209400ULL,
0x0000005f00597306ULL, 0x000e620000205400ULL, 0x0000001a1900720bULL, 0x004fe20003f1d000ULL,
0x0000010014197824ULL, 0x000fca00078e00ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000001300127306ULL, 0x000ff00000009400ULL, 0x0000001300777306ULL, 0x000ea20000005400ULL,
0x000000595800720bULL, 0x002fe20003f5d000ULL, 0x000100000c587824ULL, 0x000fcc00078e00ffULL,
0x0000005e00617306ULL, 0x000e70000020d400ULL, 0x00000065005a7306ULL, 0x000fe20000209400ULL,
0x000000771200720bULL, 0x004fe40003f7d000ULL, 0x00000018ff127819ULL, 0x000fc4000001140cULL,
0x00000018ff777819ULL, 0x000fc6000001140dULL, 0x00000065005d7306ULL, 0x000ea20000205400ULL,
0x0000000161616812ULL, 0x002fce00078efcffULL, 0x0000005f00607306ULL, 0x000e70000020d400ULL,
0x0000001400487306ULL, 0x000ee2000000d400ULL, 0x0000005d5a00720bULL, 0x004fe40003fdd000ULL,
0x00000018ff5a7819ULL, 0x000fca0000011458ULL, 0x0000000c00147306ULL, 0x000fe20000009400ULL,
0x0000000160602812ULL, 0x002fce00078efcffULL, 0x0000000c00597306ULL, 0x000e620000005400ULL,
0x0000000148480812ULL, 0x008fce00078efcffULL, 0x00000056005e7306ULL, 0x000ff00000209400ULL,
0x00000056005f7306ULL, 0x000ea20000205400ULL, 0x000000591400720bULL, 0x002fe20003f5d000ULL,
0x000001000c147824ULL, 0x000fcc00078e00ffULL, 0x00000012004f7306ULL, 0x000ff00000209400ULL,
0x0000001200547306ULL, 0x000e620000205400ULL, 0x0000005f5e00720bULL, 0x004fce0003f9d000ULL,
0x0000001300647306ULL, 0x000eb0000000d400ULL, 0x0000005a00587306ULL, 0x000fe20000209400ULL,
0x000000544f00720bULL, 0x002fce0003fbd000ULL, 0x0000005a00597306ULL, 0x000e620000205400ULL,
0x0000000164643812ULL, 0x004fce00078efcffULL, 0x0000006500657306ULL, 0x000eb0000020d400ULL,
0x0000005600517306ULL, 0x000ee2000020d400ULL, 0x000000595800720bULL, 0x002fce0003f7d000ULL,
0x0000007700537306ULL, 0x000fe20000209400ULL, 0x0000000165656812ULL, 0x004fce00078efcffULL,
0x0000007700567306ULL, 0x000e620000205400ULL, 0x0000000151514812ULL, 0x008fce00078efcffULL,
0x0000000c005e7306ULL, 0x000eb0000000d400ULL, 0x0000001200527306ULL, 0x0006a2000020d400ULL,
0x000000565300720bULL, 0x002fe20003fdd000ULL, 0x000100000d537824ULL, 0x000fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011453ULL, 0x0000000d000c7306ULL, 0x000fe20000009400ULL,
0x00000018ff127819ULL, 0x008fe4000001140fULL, 0x000000015e5e2812ULL, 0x004fca00078efcffULL,
0x0000000d004f7306ULL, 0x000e620000005400ULL, 0x0000000152525812ULL, 0x000fce00078efcffULL,
0x0000007700577306ULL, 0x0004f0000020d400ULL, 0x00000019001a7306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x004fe40000011411ULL, 0x0000004f0c00720bULL, 0x002fe20003f9d000ULL,
0x000001000d0c7824ULL, 0x000fc800078e00ffULL, 0x00000019001b7306ULL, 0x000fe20000205400ULL,
0x0000000157576812ULL, 0x008fce00078efcffULL, 0x0000001900097306ULL, 0x000ff0000020d400ULL,
0x0000007600187306ULL, 0x000ff00000209400ULL, 0x0000007600197306ULL, 0x000e700000205400ULL,
0x00000076000b7306ULL, 0x0004f0000020d400ULL, 0x0000001200137306ULL, 0x000fe20000209400ULL,
0x00000018ff767819ULL, 0x004fc40000011414ULL, 0x000000191800720bULL, 0x002fe40003f1d000ULL,
0x0000000702197812ULL, 0x000fc600078ec0ffULL, 0x0000001200447306ULL, 0x000ff00000205400ULL,
0x0000001200497306ULL, 0x000fe2000020d400ULL, 0x000000010b0b0812ULL, 0x008fce00078efcffULL,
0x0000007700117306ULL, 0x000ff00000209400ULL, 0x0000007700127306ULL, 0x000ff00000205400ULL,
0x00000077004e7306ULL, 0x000ff0000020d400ULL, 0x0000005a005f7306ULL, 0x000e70000020d400ULL,
0x00000055004c7306ULL, 0x000ff00000209400ULL, 0x00000055004d7306ULL, 0x000ea20000205400ULL,
0x000000015f5f3812ULL, 0x002fce00078efcffULL, 0x0000007600147306ULL, 0x000ff00000209400ULL,
0x0000007600777306ULL, 0x000e620000205400ULL, 0x0000004d4c00720bULL, 0x004fce0003f3d000ULL,
0x00000076005d7306ULL, 0x0004e2000020d400ULL, 0x000000771400720bULL, 0x002fce0003f7d000ULL,
0x0000005600537306ULL, 0x000fe20000209400ULL, 0x00000018ff767819ULL, 0x004fce000001140cULL,
0x0000005600547306ULL, 0x000e620000205400ULL, 0x000000015d5d3812ULL, 0x008fce00078efcffULL,
0x0000000e00147306ULL, 0x000ff00000009400ULL, 0x0000000e004d7306ULL, 0x000ea20000005400ULL,
0x000000545300720bULL, 0x002fce0003f5d000ULL, 0x00000076004f7306ULL, 0x000ff00000209400ULL,
0x00000076000c7306ULL, 0x000e620000205400ULL, 0x0000004d1400720bULL, 0x004fe20003f7d000ULL,
0x000001000e147824ULL, 0x000fca00078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011414ULL,
0x0000000d00587306ULL, 0x0004f0000000d400ULL, 0x0000007600597306ULL, 0x0006e2000020d400ULL,
0x000100000e0d7824ULL, 0x004fe200078e00ffULL, 0x0000000c4f00720bULL, 0x002fe20003fbd000ULL,
0x000100000f0c7824ULL, 0x000fca00078e00ffULL, 0x00000056005a7306ULL, 0x000e62000020d400ULL,
0x00000018ff767819ULL, 0x008fe4000001140dULL, 0x0000000158584812ULL, 0x000fca00078efcffULL,
0x0000000e00547306ULL, 0x000ea2000000d400ULL, 0x0000000159595812ULL, 0x000fce00078efcffULL,
0x00000076000d7306ULL, 0x000fe20000209400ULL, 0x000000015a5a2812ULL, 0x002fce00078efcffULL,
0x00000076004c7306ULL, 0x000e620000205400ULL, 0x0000000154543812ULL, 0x004fe400078efcffULL,
0x0000000a3f00720bULL, 0x000fca0003f7d000ULL, 0x0000000f000e7306ULL, 0x000ff00000009400ULL,
0x0000000f004f7306ULL, 0x000ea20000005400ULL, 0x0000004c0d00720bULL, 0x002fe40003f5d000ULL,
0x00000018ff4c7819ULL, 0x000fc4000001140cULL, 0x0000000105053812ULL, 0x000fc600078efcffULL,
0x0000007700567306ULL, 0x000ff00000209400ULL, 0x00000077004d7306ULL, 0x000e620000205400ULL,
0x0000004f0e00720bULL, 0x004fe20003fbd000ULL, 0x000001000f0e7824ULL, 0x000fcc00078e00ffULL,
0x0000000f004f7306ULL, 0x000eb0000000d400ULL, 0x0000004c000c7306ULL, 0x000fe20000209400ULL,
0x0000004d5600720bULL, 0x002fce0003f9d000ULL, 0x0000004c000d7306ULL, 0x000e620000205400ULL,
0x000000014f4f5812ULL, 0x004fe400078efcffULL, 0x000000441300720bULL, 0x000fca0003fbd000ULL,
0x0000007600537306ULL, 0x0004f0000020d400ULL, 0x0000007700147306ULL, 0x000ee2000020d400ULL,
0x0000000d0c00720bULL, 0x002fe20003fdd000ULL, 0x00000100150c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x004fc4000001140eULL, 0x0000000149495812ULL, 0x000fe400078efcffULL,
0x0000001b1a00720bULL, 0x000fe20003fbd000ULL, 0x0000004c004d7306ULL, 0x000e62000020d400ULL,
0x0000000153532812ULL, 0x008fe400078efcffULL, 0x000000404500720bULL, 0x000fe40003f5d000ULL,
0x00000018ff407819ULL, 0x000fe4000001140cULL, 0x000000545354723eULL, 0x000fe200000010ffULL,
0x0000001500567306ULL, 0x000fe20000009400ULL, 0x0000000114144812ULL, 0x000fc400078efcffULL,
0x0000003e4100720bULL, 0x000fe40003f9d000ULL, 0x0000000109095812ULL, 0x000fc600078efcffULL,
0x0000001500777306ULL, 0x000ea20000005400ULL, 0x000000014d4d6812ULL, 0x002fe400078efcffULL,
0x0000000108082812ULL, 0x000fca00078efcffULL, 0x00000015000a7306ULL, 0x0002e2000000d400ULL,
0x0000000107074812ULL, 0x000fce00078efcffULL, 0x0000005500557306ULL, 0x000ee2000020d400ULL,
0x0001000016157824ULL, 0x002fe200078e00ffULL, 0x000000775600720bULL, 0x004fe40003fdd000ULL,
0x0000000819567812ULL, 0x000fe400078ef802ULL, 0x00000018ff417819ULL, 0x000fe20000011415ULL,
0x0000010016157824ULL, 0x000fe200078e00ffULL, 0x00000076000e7306ULL, 0x000fe20000209400ULL,
0x0000001056187824ULL, 0x000fcc00078e00ffULL, 0x000000010a0a6812ULL, 0x008fe200078efcffULL,
0x00000076000d7306ULL, 0x000e620000205400ULL, 0x0000000155551812ULL, 0x000fe400078efcffULL,
0x0000000a0b0a723eULL, 0x000fe400000010ffULL, 0x000000145555723eULL, 0x000fc600000010ffULL,
0x00000040000f7306ULL, 0x000ff00000209400ULL, 0x00000040003e7306ULL, 0x000ea20000205400ULL,
0x0000000d0e00720bULL, 0x002fce0003f3d000ULL, 0x00000040000c7306ULL, 0x0003f0000020d400ULL,
0x00000076004c7306ULL, 0x000ee2000020d400ULL, 0x00000018ff407819ULL, 0x002fe40000011415ULL,
0x00000004ff157819ULL, 0x000fc40000011602ULL, 0x0000003e0f00720bULL, 0x004fc60003fbd000ULL,
0x0000000204157824ULL, 0x040fe200078e0215ULL, 0x00000016000e7306ULL, 0x000fe20000009400ULL,
0x0000000204047810ULL, 0x000fe40007ffe0ffULL, 0x00000001560f7824ULL, 0x140fe200078e0215ULL,
0x0000000256157810ULL, 0x040fe20007ffe015ULL, 0x0000001056567824ULL, 0x000fe200078e00ffULL,
0x000000014c4c1812ULL, 0x008fe400078efcffULL, 0x00000016003f7306ULL, 0x000e620000005400ULL,
0xfffffff018187812ULL, 0x000fc400078ee20fULL, 0x000000121100720bULL, 0x000fe40003f3d000ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x0000001018187824ULL, 0x000fe200078e00ffULL,
0x000000010c0c5812ULL, 0x000fe200078efcffULL, 0x00000016000d7306ULL, 0x000ee2000000d400ULL,
0xfffffff056157812ULL, 0x000fe400078ee215ULL, 0x0000000c050b723eULL, 0x000fe200000010ffULL,
0x000000001818783bULL, 0x000ea40000000200ULL, 0x0000001015157824ULL, 0x000fc400078e00ffULL,
0x000000014e4e1812ULL, 0x000fe200078efcffULL, 0x0000004000167306ULL, 0x000fe20000209400ULL,
0x0000003f0e00720bULL, 0x002fe40003f3d000ULL, 0x000000484e48723eULL, 0x000fca00000010ffULL,
0x00000040003f7306ULL, 0x000e6c0000205400ULL, 0x000000010d0d1812ULL, 0x008fe400078efcffULL,
0x00000041003c7306ULL, 0x000ff00000209400ULL, 0x00000041003d7306ULL, 0x000ee20000205400ULL,
0x0000003f1600720bULL, 0x002fc40003f1d000ULL, 0x00000018ff457819ULL, 0x004fe20000011410ULL,
0x00000100134e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fc60000011411ULL,
0x00000041000e7306ULL, 0x000e62000020d400ULL, 0x00000018ff777819ULL, 0x000fe20000011412ULL,
0x000000461820723cULL, 0x000be20000041820ULL, 0x00000018ff4e7819ULL, 0x000fca000001144eULL,
0x0000004500417306ULL, 0x000fe20000209400ULL, 0x0000003d3c00720bULL, 0x008fe40003f5d000ULL,
0x0000006c6e46723eULL, 0x020fe200000010ffULL, 0x000000541824723cULL, 0x040be20000041824ULL,
0x0000006d6b47723eULL, 0x000fe200000010ffULL, 0x00010000176d7824ULL, 0x000fe400078e00ffULL,
0x0000004500447306ULL, 0x000ea60000205400ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x000000461838723cULL, 0x000b640000041838ULL, 0x0000004f4d54723eULL, 0x020fe200000010ffULL,
0x00010000134f7824ULL, 0x000fe200078e00ffULL, 0x000000010e0e2812ULL, 0x002fe200078efcffULL,
0x0000001700167306ULL, 0x000fe20000009400ULL, 0x0000004c4955723eULL, 0x000fc400000010ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x000000090849723eULL, 0x000fe400000010ffULL,
0x0000000d0e0e723eULL, 0x000fe200000010ffULL, 0x00000017006c7306ULL, 0x000e620000005400ULL,
0x000000444100720bULL, 0x004fe20003fdd000ULL, 0x00000054181c723cULL, 0x000fec000004181cULL,
0x00000076003d7306ULL, 0x000ff00000209400ULL, 0x00000076003e7306ULL, 0x000fe20000205400ULL,
0x0000006c1600720bULL, 0x002fc40003fbd000ULL, 0x0000004b6116723eULL, 0x000fca00000010ffULL,
0x00000076003f7306ULL, 0x0003f0000020d400ULL, 0x0000006d006b7306ULL, 0x000fe20000209400ULL,
0x00000018ff767819ULL, 0x002fce0000011413ULL, 0x0000006d006e7306ULL, 0x000e700000205400ULL,
0x00000045003c7306ULL, 0x000eb0000020d400ULL, 0x0000007600437306ULL, 0x000fe20000209400ULL,
0x0000006e6b00720bULL, 0x002fce0003f7d000ULL, 0x0000007600447306ULL, 0x000fe20000205400ULL,
0x000000013c3c6812ULL, 0x004fe400078efcffULL, 0x0000005b5c00720bULL, 0x000fca0003fdd000ULL,
0x0000007600457306ULL, 0x0003f0000020d400ULL, 0x0000001700477306ULL, 0x0004e2000000d400ULL,
0x0000010017767824ULL, 0x002fe200078e00ffULL, 0x0000000106066812ULL, 0x000fc800078efcffULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000040000f7306ULL, 0x000e62000020d400ULL,
0x000000604a17723eULL, 0x004fce00000010ffULL, 0x000000161834723cULL, 0x000b620000041834ULL,
0x0000007700407306ULL, 0x000fe20000209400ULL, 0x0000000147475812ULL, 0x008fca00078efcffULL,
0x0001000010167824ULL, 0x020fe200078e00ffULL, 0x000000515017723eULL, 0x000fe200000010ffULL,
0x0000007700417306ULL, 0x000fe20000205400ULL, 0x000000010f0f0812ULL, 0x002fe400078efcffULL,
0x00000018ff6b7819ULL, 0x000fe40000011416ULL, 0x000000646516723eULL, 0x000fe200000010ffULL,
0x0000010010647824ULL, 0x000fe200078e00ffULL, 0x0000000f070f723eULL, 0x000fe200000010ffULL,
0x0000007700427306ULL, 0x000fe6000020d400ULL, 0x00000018ff507819ULL, 0x000fe20000011464ULL,
0x00000016182c723cULL, 0x000b68000004182cULL, 0x0000007600617306ULL, 0x000fe60000209400ULL,
0x0001000011167824ULL, 0x020fe200078e00ffULL, 0x0000005d5217723eULL, 0x000fc800000010ffULL,
0x0000007600607306ULL, 0x000ff00000205400ULL, 0x00000076004a7306ULL, 0x000ff0000020d400ULL,
0x0000001100767306ULL, 0x000ff00000009400ULL, 0x0000001100777306ULL, 0x000e700000005400ULL,
0x0000006d00467306ULL, 0x000eb0000020d400ULL, 0x00000010006c7306ULL, 0x000fe20000009400ULL,
0x000000777600720bULL, 0x002fe20003f3d000ULL, 0x0000010011767824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fc40000011416ULL, 0x0000005e5f16723eULL, 0x000fe400000010ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x00000010006d7306ULL, 0x000e620000005400ULL,
0x0000000146463812ULL, 0x004fe400078efcffULL, 0x0000003e3d00720bULL, 0x000fe20003f7d000ULL,
0x000000161828723cULL, 0x000b620000041828ULL, 0x000000474646723eULL, 0x000fc600000010ffULL,
0x00000010004b7306ULL, 0x000ea6000000d400ULL, 0x000000585a16723eULL, 0x020fe400000010ffULL,
0x000000595717723eULL, 0x000fe400000010ffULL, 0x0000006d6c00720bULL, 0x002fe20003f5d000ULL,
0x0000006b006e7306ULL, 0x000fe20000205400ULL, 0x000000013f3f3812ULL, 0x000fc600078efcffULL,
0x000000161830723cULL, 0x000b680000041830ULL, 0x0000006b006d7306ULL, 0x000e660000209400ULL,
0x0001000012167824ULL, 0x020fe200078e00ffULL, 0x000000014b4b2812ULL, 0x004fc800078efcffULL,
0x0000006b00107306ULL, 0x000eb0000020d400ULL, 0x00000050006b7306ULL, 0x000fe20000209400ULL,
0x0000006e6d00720bULL, 0x002fce0003f1d000ULL, 0x00000050006c7306ULL, 0x000e6c0000205400ULL,
0x0000000110100812ULL, 0x004fe400078efcffULL, 0x0000007700647306ULL, 0x000fe20000209400ULL,
0x0000006c6b00720bULL, 0x002fce0003f9d000ULL, 0x0000007700657306ULL, 0x000e620000205400ULL,
0x00000018ff6c7819ULL, 0x000fe40000011416ULL, 0x000000001514783bULL, 0x000eaa0000000200ULL,
0x00000012006d7306ULL, 0x000ff00000009400ULL, 0x0000001200587306ULL, 0x000ee20000005400ULL,
0x000000656400720bULL, 0x002fce0003f5d000ULL, 0x0000001100517306ULL, 0x000e70000000d400ULL,
0x0000007700117306ULL, 0x000ea2000020d400ULL, 0x000000586d00720bULL, 0x008fce0003f1d000ULL,
0x00000076005e7306ULL, 0x000fe20000209400ULL, 0x0000000151511812ULL, 0x002fe200078efcffULL,
0x0000000a1438723cULL, 0x004f620000041838ULL, 0x000000444300720bULL, 0x000fca0003f3d000ULL,
0x00000076005d7306ULL, 0x000e620000205400ULL, 0x0000000111112812ULL, 0x000fe400078efcffULL,
0x000000606100720bULL, 0x000fe20003f5d000ULL, 0x000000481420723cULL, 0x000f620000041820ULL,
0x00000051113e723eULL, 0x000fc600000010ffULL, 0x0000006c00567306ULL, 0x000fe20000209400ULL,
0x0000000145451812ULL, 0x000fc600078efcffULL, 0x0000000e1434723cULL, 0x000f680000041834ULL,
0x0000006c00597306ULL, 0x000ea20000205400ULL, 0x0000005d5e00720bULL, 0x002fe40003fbd000ULL,
0x000000014a4a2812ULL, 0x000fe400078efcffULL, 0x000000414000720bULL, 0x000fe40003f5d000ULL,
0x0000004a0647723eULL, 0x000fe200000010ffULL, 0x0000001200577306ULL, 0x0002e2000000d400ULL,
0x0000004b1006723eULL, 0x000fca00000010ffULL, 0x00000046142c723cULL, 0x000f64000004182cULL,
0x0000005000507306ULL, 0x000ee2000020d400ULL, 0x0000010012127824ULL, 0x002fe200078e00ffULL,
0x000000595600720bULL, 0x004fe40003fdd000ULL, 0x0000000142422812ULL, 0x000fe400078efcffULL,
0x00000018ff6d7819ULL, 0x000fe40000011412ULL, 0x0000007600527306ULL, 0x000e62000020d400ULL,
0x0000000157570812ULL, 0x008fc400078efcffULL, 0x000000080400780cULL, 0x000fca0003f05270ULL,
0x0000006c00537306ULL, 0x000ea2000020d400ULL, 0x0000000150504812ULL, 0x000fc800078efcffULL,
0x000000503c07723eULL, 0x000fc600000010ffULL, 0x00000013005f7306ULL, 0x000fe20000009400ULL,
0x0000000152525812ULL, 0x002fc600078efcffULL, 0x000000061428723cULL, 0x000b620000041828ULL,
0x000000523f3f723eULL, 0x000fc600000010ffULL, 0x00000013006b7306ULL, 0x000e620000005400ULL,
0x0000000153536812ULL, 0x004fc600078efcffULL, 0x0000003e1430723cULL, 0x000b640000041830ULL,
0x000000575306723eULL, 0x020fe400000010ffULL, 0x0000006d00587306ULL, 0x000ff00000209400ULL,
0x0000006d005a7306ULL, 0x000ea20000205400ULL, 0x0000006b5f00720bULL, 0x002fce0003f9d000ULL,
0x0000004f004d7306ULL, 0x000ff00000209400ULL, 0x0000004f00087306ULL, 0x000e620000205400ULL,
0x0000005a5800720bULL, 0x004fce0003fbd000ULL, 0x0000004e00057306ULL, 0x000ff00000209400ULL,
0x0000004e000a7306ULL, 0x000ea20000205400ULL, 0x000000084d00720bULL, 0x002fce0003f7d000ULL,
0x0000006d00127306ULL, 0x000e70000020d400ULL, 0x00000013004c7306ULL, 0x000ee2000000d400ULL,
0x0000000a0500720bULL, 0x004fce0003fdd000ULL, 0x0000004f004f7306ULL, 0x000ea2000020d400ULL,
0x0000000112125812ULL, 0x002fc800078efcffULL, 0x000000124207723eULL, 0x000fc600000010ffULL,
0x0000004e004e7306ULL, 0x000e62000020d400ULL, 0x000000014c4c4812ULL, 0x008fc600078efcffULL,
0x000000061424723cULL, 0x000b620000041824ULL, 0x000000014f4f3812ULL, 0x004fc800078efcffULL,
0x0000004c4f44723eULL, 0x000fe400000010ffULL, 0x000000014e4e6812ULL, 0x002fc800078efcffULL,
0x0000004e4545723eULL, 0x000fce00000010ffULL, 0x00000044141c723cULL, 0x000b62000004181cULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffe11000007947ULL, 0x000fcc000383ffffULL,
0x000000032c2c7220ULL, 0x080fe40000410000ULL, 0x0000000329297220ULL, 0x080fe40000410000ULL,
0x0000000321217220ULL, 0x080fe40000410000ULL, 0x0000000338387220ULL, 0x080fe40000410000ULL,
0x0000000339397220ULL, 0x080fe40000410000ULL, 0x0000000334347220ULL, 0x000fc40000410000ULL,
0x0000000335357220ULL, 0x080fe40000410000ULL, 0x000000032d047220ULL, 0x080fe40000410000ULL,
0x0000000331057220ULL, 0x080fe40000410000ULL, 0x0000000325067220ULL, 0x0a0fe40000410000ULL,
0x000000032f097220ULL, 0x080fe40000410000ULL, 0x000000032b107220ULL, 0x000fc40000410000ULL,
0x0000000326157220ULL, 0x080fe40000410000ULL, 0x0000000327167220ULL, 0x080fe40000410000ULL,
0x0000000320137220ULL, 0x080fe40000410000ULL, 0x0000000322077220ULL, 0x080fe40000410000ULL,
0x0000000323127220ULL, 0x080fe40000410000ULL, 0x00000003282f7220ULL, 0x000fc40000410000ULL,
0x000000032a117220ULL, 0x080fe40000410000ULL, 0x00000003242b7220ULL, 0x080fe40000410000ULL,
0x000000ffff267224ULL, 0x000fe400078e002cULL, 0x000000ffff277224ULL, 0x000fe400078e0029ULL,
0x000000033a3a7220ULL, 0x080fe40000410000ULL, 0x000000033b3b7220ULL, 0x000fc40000410000ULL,
0x0000000336207220ULL, 0x080fe40000410000ULL, 0x0000000337377220ULL, 0x080fe40000410000ULL,
0x000000032e087220ULL, 0x080fe40000410000ULL, 0x0000000330287220ULL, 0x080fe40000410000ULL,
0x00000003321b7220ULL, 0x080fe40000410000ULL, 0x0000000333337220ULL, 0x000fc40000410000ULL,
0x000000031c227220ULL, 0x080fe40000410000ULL, 0x000000031d1a7220ULL, 0x080fe40000410000ULL,
0x000000031e177220ULL, 0x080fe40000410000ULL, 0x000000031f187220ULL, 0x000fe40000410000ULL,
0x000000ffff237224ULL, 0x000fe400078e0021ULL, 0x000000ffff247224ULL, 0x000fc400078e0038ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0039ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0034ULL,
0x000000ffff257224ULL, 0x000fe400078e0035ULL, 0x000000ffff317224ULL, 0x000fe400078e0004ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0005ULL, 0x000000ffff297224ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007a047f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1e7224ULL, 0x000fc400078e0007ULL, 0x000000ffff1d7224ULL, 0x000fe400078e003aULL,
0x000000ffff2e7224ULL, 0x000fe400078e003bULL, 0x000000ffff1f7224ULL, 0x000fe400078e0037ULL,
0x000000ffff217224ULL, 0x000fe400078e0008ULL, 0x000000ffff307224ULL, 0x000fe400078e0009ULL,
0x000000ffff1c7224ULL, 0x000fc400078e0033ULL, 0x0000000000067805ULL, 0x002fca0000015200ULL,
0x000004007a097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004007a097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000402197824ULL, 0x000fe200078e00ffULL, 0x000000746300720cULL, 0x000fc80003f06070ULL,
0xfffffff019057812ULL, 0x000fca00078ec0ffULL, 0x0000008000147824ULL, 0x000fca00078e0205ULL,
0x0174000014047984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0xffffff0066097810ULL, 0x000fe20007ffe0ffULL, 0x0000000202337824ULL, 0x040fe200078e00ffULL,
0x0000007102087211ULL, 0x000fe200078ff0ffULL, 0x00000002ff487424ULL, 0x000fe200078e00ffULL,
0x0000000970327217ULL, 0x000fe40007800000ULL, 0x0000000633337812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff0a7a19ULL, 0x000fe20000011608ULL, 0x0000000132327824ULL, 0x000fe200078e0a09ULL,
0x0000580033357a10ULL, 0x000fe20007ffe0ffULL, 0x000000016a097824ULL, 0x000fe200078e0233ULL,
0x0000000a790a7217ULL, 0x000fc40003800000ULL, 0x000000323500720cULL, 0x080fe20003f06070ULL,
0x00000001090e7824ULL, 0x140fe200078e0a32ULL, 0x000000320900720cULL, 0x000fe20003f26070ULL,
0x00000001350c7824ULL, 0x000fe400078e0a32ULL, 0x0000000a6f4f7224ULL, 0x000fe200078e02ffULL,
0x0000000e790e7217ULL, 0x040fe40003800000ULL, 0x0000000c790c7217ULL, 0x000fe40003800000ULL,
0x00000004ff0e7819ULL, 0x000fc4000001160eULL, 0x000000ff0c407207ULL, 0x000fe40000000000ULL,
0x000000ff0e0e7207ULL, 0x000fe40000800000ULL, 0x0000004f40097211ULL, 0x000fe400078fe0ffULL,
0x00000008080c7810ULL, 0x000fe20007ffe0ffULL, 0x000000014f0b7824ULL, 0x000fe200078e020eULL,
0x00000010333b7812ULL, 0x000fe200078efcffULL, 0x0000600009087625ULL, 0x000fe200078e0048ULL,
0x00005a00ff0c7a19ULL, 0x000fc4000001160cULL, 0x000058003b377a10ULL, 0x000fe20007ffe0ffULL,
0x000060000b0a7625ULL, 0x000fe200078e0048ULL, 0x0000000c790c7217ULL, 0x000fe20003800000ULL,
0x0000000808467981ULL, 0x0046a2000c1e9500ULL, 0x0000002033397812ULL, 0x000fc600078efcffULL,
0x000000080a4d7981ULL, 0x0002a2000c1e9500ULL, 0x0000000c6f517224ULL, 0x000fe400078e02ffULL,
0x0000000137087824ULL, 0x148fe400078e0a32ULL, 0x000000016a097824ULL, 0x000fe200078e023bULL,
0x000000323700720cULL, 0x000fe20003f06070ULL, 0x000000010e0f7824ULL, 0x000fe200078e0251ULL,
0x0000000879087217ULL, 0x000fe20003800000ULL, 0x00000001090a7824ULL, 0x002fe200078e0a32ULL,
0x00005800393f7a10ULL, 0x000fe20007ffe0ffULL, 0x000060000f0e7625ULL, 0x000fe200078e0048ULL,
0x00000051400d7211ULL, 0x000fc400078fe0ffULL, 0x000000ff08347207ULL, 0x000fe20000000000ULL,
0x000000013f3a7824ULL, 0x000fe200078e0a32ULL, 0x0000000a790a7217ULL, 0x000fe20003800000ULL,
0x000060000d0c7625ULL, 0x000fe200078e0048ULL, 0x000000320900720cULL, 0x080fe20003f26070ULL,
0x000000080e4b7981ULL, 0x0002e2000c1e9500ULL, 0x0000004f34097211ULL, 0x000fe200078fe0ffULL,
0x000000016a437824ULL, 0x000fe200078e0239ULL, 0x00000004ff0a7819ULL, 0x000fe2000001160aULL,
0x000000080c427981ULL, 0x0002e2000c1e9500ULL, 0x000000323f00720cULL, 0x000fc40003f06070ULL,
0x0000003a793a7217ULL, 0x000fe20003800000ULL, 0x0000600009087625ULL, 0x000fc600078e0048ULL,
0x000000ff3a3a7207ULL, 0x000fe20000000000ULL, 0x00000001433c7824ULL, 0x040fe200078e0a32ULL,
0x0000000808367981ULL, 0x0002e4000c1e9500ULL, 0x000000ff0a0c7207ULL, 0x002fe40000800000ULL,
0x000000324300720cULL, 0x000fe40003f26070ULL, 0x0000003033437812ULL, 0x000fe200078efcffULL,
0x000000014f0b7824ULL, 0x000fe200078e020cULL, 0x00000051340d7211ULL, 0x000fe200078fe0ffULL,
0x000000010c0f7824ULL, 0x000fe200078e0251ULL, 0x0000003c793c7217ULL, 0x000fc40003800000ULL,
0x0000004f3a097211ULL, 0x000fe200078fe0ffULL, 0x000000016a537824ULL, 0x000fe200078e0243ULL,
0x00000004ff3c7819ULL, 0x000fe2000001163cULL, 0x000060000b0a7625ULL, 0x000fe200078e0048ULL,
0x0000580043457a10ULL, 0x000fc60007ffe0ffULL, 0x000060000d0c7625ULL, 0x000fc800078e0048ULL,
0x000060000f0e7625ULL, 0x080fe200078e0048ULL, 0x000000ff3c3e7207ULL, 0x000fe20000800000ULL,
0x000000080a3d7981ULL, 0x0002e4000c1e9500ULL, 0x0000600009087625ULL, 0x000fe400078e0048ULL,
0x000000080c387981ULL, 0x0002e4000c1e9500ULL, 0x0000000153447824ULL, 0x000fe400078e0a32ULL,
0x000000080e417981ULL, 0x0002e8000c1e9500ULL, 0x00000008083c7981ULL, 0x0002e2000c1e9500ULL,
0x0000004479447217ULL, 0x000fe20003800000ULL, 0x000000014f0b7824ULL, 0x002fe200078e023eULL,
0x000000513a0d7211ULL, 0x000fe200078fe0ffULL, 0x000000013e0f7824ULL, 0x000fc400078e0251ULL,
0x0000000145087824ULL, 0x040fe200078e0a32ULL, 0x000000324500720cULL, 0x000fe20003f06070ULL,
0x000060000b0a7625ULL, 0x000fe200078e0048ULL, 0x000000325300720cULL, 0x000fe40003f26070ULL,
0x0000000879087217ULL, 0x000fe20003800000ULL, 0x000060000d0c7625ULL, 0x080fe200078e0048ULL,
0x00000004ff097819ULL, 0x000fe20000011644ULL, 0x000000080a477981ULL, 0x0002e4000c1e9500ULL,
0x000060000f0e7625ULL, 0x000fe200078e0048ULL, 0x000000ff08447207ULL, 0x000fe20000000000ULL,
0x000000080c3e7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff094a7207ULL, 0x000fc60000800000ULL,
0x000000080e497981ULL, 0x0002e2000c1e9500ULL, 0x0000004f44097211ULL, 0x000fe200078fe0ffULL,
0x000000014f0b7824ULL, 0x002fc800078e024aULL, 0x0000600009087625ULL, 0x000fc800078e0048ULL,
0x000060000b0a7625ULL, 0x000fe400078e0048ULL, 0x0000000808087981ULL, 0x0002e2000c1e9500ULL,
0x00000051440d7211ULL, 0x000fc600078fe0ffULL, 0x000000080a0b7981ULL, 0x0002e2000c1e9500ULL,
0x000000014a0f7824ULL, 0x000fe400078e0251ULL, 0x000060000d0c7625ULL, 0x000fc800078e0048ULL,
0x000060000f0e7625ULL, 0x000fe400078e0048ULL, 0x000000080c0c7981ULL, 0x0002e8000c1e9500ULL,
0x000000080e0f7981ULL, 0x0002e2000c1e9500ULL, 0xfffffff0404f7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff407424ULL, 0x000fc800078e00ffULL, 0x0000000132487824ULL, 0x000fe200078e024fULL,
0x0000000133097812ULL, 0x002fc600078efcffULL, 0x0000000135557824ULL, 0x100fe200078e0a48ULL,
0x0000000933517812ULL, 0x000fe400078efcffULL, 0x0000580009537a10ULL, 0x000fe40007ffe0ffULL,
0x0000005540557219ULL, 0x000fe400000006ffULL, 0x00005800510d7a10ULL, 0x000fe20007ffe0ffULL,
0x0000000153577824ULL, 0x000fc800078e0a48ULL, 0x000000010d5b7824ULL, 0x000fe200078e0a48ULL,
0x0000005740577219ULL, 0x040fe400000006ffULL, 0x00000011330a7812ULL, 0x040fe400078efcffULL,
0x0000005b405b7219ULL, 0x000fe400000006ffULL, 0x0000001833777812ULL, 0x040fe400078efcffULL,
0x00000019336d7812ULL, 0x000fc800078efcffULL, 0x000058006d0e7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff03a4a7812ULL, 0x000fca00078ec0ffULL, 0x00000001324a7824ULL, 0x000fe200078e024aULL,
0x00000021335f7812ULL, 0x000fc600078efcffULL, 0x000000013f587824ULL, 0x000fe200078e0a4aULL,
0x00000028335d7812ULL, 0x000fe400078efcffULL, 0xfffffff044447812ULL, 0x000fe400078ec0ffULL,
0x000058005f6b7a10ULL, 0x000fe40007ffe0ffULL, 0x000058005d657a10ULL, 0x000fe20007ffe0ffULL,
0x00000001324c7824ULL, 0x000fe400078e0244ULL, 0x000000016b5a7824ULL, 0x000fc400078e0a4aULL,
0x00000001655c7824ULL, 0x000fe400078e0a4aULL, 0x00000001454e7824ULL, 0x000fca00078e0a4cULL,
0x0000004e404e7219ULL, 0x000fe400000006ffULL, 0x0000541046467816ULL, 0x004fe4000000004dULL,
0x00000008334d7812ULL, 0x000fe400078efcffULL, 0x0000004655ff7212ULL, 0x000fe4000780c0ffULL,
0x000058004d4f7a10ULL, 0x000fe40007ffe0ffULL, 0x000000323500720cULL, 0x000fc60000701470ULL,
0x000000014f597824ULL, 0x000fe200078e0a48ULL, 0x000000323300720cULL, 0x000fe40000701070ULL,
0xfffffff034487812ULL, 0x000fe400078ec0ffULL, 0x0000005940597219ULL, 0x000fe400000006ffULL,
0x0000004657ff7212ULL, 0x080fe2000786c0ffULL, 0x0000000132487824ULL, 0x000fe200078e0248ULL,
0x0000004659ff7212ULL, 0x080fe4000784c0ffULL, 0x000000465bff7212ULL, 0x000fc4000782c0ffULL,
0x0000541042427816ULL, 0x008fe4000000004bULL, 0xff80000013137808ULL, 0x000fe40000000000ULL,
0x0000004255ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004257ff7212ULL, 0x080fe400078ac0ffULL,
0x0000004259ff7212ULL, 0x080fe400078cc0ffULL, 0x000000425bff7212ULL, 0x000fc4000780c0ffULL,
0x000058000a467a10ULL, 0x000fe40007ffe0ffULL, 0x0000580077427a10ULL, 0x000fe20007ffe0ffULL,
0x0000000137507824ULL, 0x100fe200078e0a48ULL, 0x000000323500720cULL, 0x080fe20002781470ULL,
0x0000000146527824ULL, 0x100fe200078e0a48ULL, 0x000000324f00720cULL, 0x080fe200037c1470ULL,
0x0000000142547824ULL, 0x100fe200078e0a48ULL, 0x000000320d00720cULL, 0x000fe20000701470ULL,
0x000000010e567824ULL, 0x000fe200078e0a48ULL, 0x0000005040487219ULL, 0x000fc400000006ffULL,
0x0000005240507219ULL, 0x040fe400000006ffULL, 0x000000323300720cULL, 0x080fe40002781070ULL,
0x000000324d00720cULL, 0x080fe400037c1070ULL, 0x000000325100720cULL, 0x000fe40000701070ULL,
0x0000005440527219ULL, 0x000fe400000006ffULL, 0x00005410363d7816ULL, 0x000fc4000000003dULL,
0x000000320d00720cULL, 0x000fe40000f21470ULL, 0xff8000001e1e7808ULL, 0x000fe40002000000ULL,
0x0000541038417816ULL, 0x000fe40000000041ULL, 0xff8000001d1d7808ULL, 0x000fe40003000000ULL,
0xff8000002e2e7808ULL, 0x000fe40000000000ULL, 0x0000003d48ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004148ff7212ULL, 0x080fe400078cc0ffULL, 0x0000004152ff7212ULL, 0x000fe4000780c0ffULL,
0x000000325100720cULL, 0x080fe40000f21070ULL, 0x000000325300720cULL, 0x0c0fe40001f61470ULL,
0x000000325300720cULL, 0x080fe40002fa1470ULL, 0x000000324f00720cULL, 0x000fc40001741470ULL,
0x000000323700720cULL, 0x0c0fe40002781470ULL, 0x000000323700720cULL, 0x080fe400037c1470ULL,
0x000000324200720cULL, 0x080fe40000701470ULL, 0xff8000002d2d7808ULL, 0x000fe40000800000ULL,
0x00000029335b7812ULL, 0x000fe400078efcffULL, 0x000000320900720cULL, 0x000fc40001f61070ULL,
0x000000320900720cULL, 0x080fe40002fa1070ULL, 0x000000324d00720cULL, 0x080fe40001741070ULL,
0x000000323b00720cULL, 0x0c0fe40002721070ULL, 0x000000323b00720cULL, 0x080fe400037c1070ULL,
0x000000327700720cULL, 0x000fe40000701070ULL, 0x0000005640567219ULL, 0x000fc400000006ffULL,
0x0000005840547219ULL, 0x000fe400000006ffULL, 0x000054103c477816ULL, 0x000fe40000000047ULL,
0x000054103e497816ULL, 0x000fe40000000049ULL, 0x000058005b617a10ULL, 0x000fe40007ffe0ffULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff80000012127808ULL, 0x000fc40002800000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0x0000003d50ff7212ULL, 0x080fe4000786c0ffULL, 0x0000003d52ff7212ULL, 0x000fc400078ac0ffULL,
0x0000003d56ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004150ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004156ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004754ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004954ff7212ULL, 0x000fe2000780c0ffULL, 0x00000001615e7824ULL, 0x000fe200078e0a4aULL,
0x000000324600720cULL, 0x000fc40001f61470ULL, 0x000000324600720cULL, 0x080fe40002781470ULL,
0x000000324200720cULL, 0x080fe40002fa1470ULL, 0x000000320e00720cULL, 0x0c0fe40001741470ULL,
0x000000320e00720cULL, 0x080fe40000f21470ULL, 0x000000323f00720cULL, 0x0c0fe400037c1470ULL,
0x000000323f00720cULL, 0x000fc40000701470ULL, 0x0000003133577812ULL, 0x040fe400078efcffULL,
0x0000003833557812ULL, 0x040fe400078efcffULL, 0x00000039334b7812ULL, 0x000fe400078efcffULL,
0x0000005a40587219ULL, 0x000fe400000006ffULL, 0x000000320a00720cULL, 0x0c0fe40001f61070ULL,
0x000000320a00720cULL, 0x000fc40002781070ULL, 0x000000327700720cULL, 0x080fe40002fa1070ULL,
0x000000326d00720cULL, 0x0c0fe40001741070ULL, 0x000000326d00720cULL, 0x080fe40000f21070ULL,
0x000000323900720cULL, 0x0c0fe400037c1070ULL, 0x000000323900720cULL, 0x000fe40000701070ULL,
0x0000005c405a7219ULL, 0x000fc400000006ffULL, 0x0000005e405e7219ULL, 0x000fe400000006ffULL,
0x00005410080b7816ULL, 0x000fe4000000000bULL, 0x0000580057597a10ULL, 0x000fe40007ffe0ffULL,
0x0000580055347a10ULL, 0x000fe40007ffe0ffULL, 0x000058004b3a7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000025257808ULL, 0x000fc40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0xff80000031317808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0xff8000002f2f7808ULL, 0x000fe40003000000ULL,
0xff80000011117808ULL, 0x000fc40000000000ULL, 0x0000004758ff7212ULL, 0x080fe4000786c0ffULL,
0x000000475aff7212ULL, 0x080fe4000788c0ffULL, 0x000000475eff7212ULL, 0x000fe400078ac0ffULL,
0x0000004958ff7212ULL, 0x080fe4000784c0ffULL, 0x000000495aff7212ULL, 0x080fe4000782c0ffULL,
0x000000495eff7212ULL, 0x000fc400078cc0ffULL, 0x0000000b4eff7212ULL, 0x000fe2000780c0ffULL,
0x00000001594a7824ULL, 0x100fe200078e0a4cULL, 0x000000326b00720cULL, 0x0c0fe20001f61470ULL,
0x0000000134447824ULL, 0x100fe200078e0a4cULL, 0x000000326b00720cULL, 0x080fe20001741470ULL,
0x000000013a4c7824ULL, 0x000fe200078e0a4cULL, 0x000000326500720cULL, 0x0c0fe40002781470ULL,
0x000000326500720cULL, 0x080fe40000f21470ULL, 0x000000326100720cULL, 0x000fc40002fa1470ULL,
0x000000326100720cULL, 0x080fe400037c1470ULL, 0x000000324500720cULL, 0x080fe40000701470ULL,
0x000000325f00720cULL, 0x0c0fe40001f61070ULL, 0x000000325f00720cULL, 0x080fe40001741070ULL,
0x000000325d00720cULL, 0x0c0fe40002781070ULL, 0x000000325d00720cULL, 0x000fc40000f21070ULL,
0x000000325b00720cULL, 0x0c0fe40002fa1070ULL, 0x000000325b00720cULL, 0x080fe400037c1070ULL,
0x000000324300720cULL, 0x000fe40000701070ULL, 0x0000004a404a7219ULL, 0x040fe400000006ffULL,
0x0000004440447219ULL, 0x040fe400000006ffULL, 0x0000004c404c7219ULL, 0x000fc400000006ffULL,
0x000054100c0f7816ULL, 0x000fe4000000000fULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000010107808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40002000000ULL,
0xff8000001b1b7808ULL, 0x000fe40000800000ULL, 0xff8000002c2c7808ULL, 0x000fc40002800000ULL,
0xff8000001c1c7808ULL, 0x000fe40003000000ULL, 0xff8000002b2b7808ULL, 0x000fe40000000000ULL,
0x0000000b4aff7212ULL, 0x080fe4000786c0ffULL, 0x0000000b44ff7212ULL, 0x080fe4000784c0ffULL,
0x0000000b4cff7212ULL, 0x000fe4000788c0ffULL, 0x0000000f4eff7212ULL, 0x000fc4000782c0ffULL,
0x0000000f4aff7212ULL, 0x080fe400078ac0ffULL, 0x0000000f44ff7212ULL, 0x080fe400078cc0ffULL,
0x0000000f4cff7212ULL, 0x000fe4000780c0ffULL, 0x000000324500720cULL, 0x080fe40000f21470ULL,
0x000000325900720cULL, 0x0c0fe40001f61470ULL, 0x000000325900720cULL, 0x000fc40002fa1470ULL,
0x000000323400720cULL, 0x0c0fe40001741470ULL, 0x000000323400720cULL, 0x080fe400037c1470ULL,
0x000000323a00720cULL, 0x0c0fe40002781470ULL, 0x000000323a00720cULL, 0x080fe40000701470ULL,
0x000000324300720cULL, 0x080fe40000f21070ULL, 0x000000325700720cULL, 0x000fc40001f61070ULL,
0x000000325700720cULL, 0x080fe40002fa1070ULL, 0x000000325500720cULL, 0x0c0fe40001741070ULL,
0x000000325500720cULL, 0x080fe400037c1070ULL, 0x000000324b00720cULL, 0x0c0fe40002781070ULL,
0x000000324b00720cULL, 0x000fe40000701070ULL, 0xff80000029297808ULL, 0x000fc40001800000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff8000001a1a7808ULL, 0x000fe40002000000ULL,
0xff80000015157808ULL, 0x000fe40000800000ULL, 0xff80000016167808ULL, 0x000fe40002800000ULL,
0xff80000017177808ULL, 0x000fe40003000000ULL, 0xff80000018187808ULL, 0x000fc40000000000ULL,
0x000000130400720bULL, 0x004fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x0000000413047208ULL, 0x000fe40004000000ULL, 0x000000051e057208ULL, 0x000fe40004800000ULL,
0x000000230400720bULL, 0x000fe40003f1e000ULL, 0x000000120500720bULL, 0x000fe40003f3e000ULL,
0x0000000423097208ULL, 0x000fe40004000000ULL, 0x0000000512047208ULL, 0x000fc40004800000ULL,
0x000000240900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x0000000924087208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x0000002e0500720bULL, 0x000fc40003f3e000ULL,
0x000000082d097208ULL, 0x000fe40004000000ULL, 0x000000052e057208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x000000200500720bULL, 0x000fe40003f3e000ULL,
0x000000092a047208ULL, 0x000fe40004000000ULL, 0x0000000520087208ULL, 0x000fc40004800000ULL,
0x000000250400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x0000000425057208ULL, 0x000fe40004000000ULL, 0x000000081f087208ULL, 0x000fe40004800000ULL,
0x000000260500720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fc40003f3e000ULL,
0x0000000526047208ULL, 0x000fe40004000000ULL, 0x0000000821057208ULL, 0x000fe40004800000ULL,
0x000000310400720bULL, 0x000fe40003f1e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000000431047208ULL, 0x000fe40004000000ULL, 0x0000000530087208ULL, 0x000fc40004800000ULL,
0x0000002f0400720bULL, 0x000fe40003f1e000ULL, 0x000000110800720bULL, 0x000fe40003f3e000ULL,
0x000000042f047208ULL, 0x000fe40004000000ULL, 0x0000000811057208ULL, 0x000fe40004800000ULL,
0x000000270400720bULL, 0x000fe40003f1e000ULL, 0x000000100500720bULL, 0x000fc40003f3e000ULL,
0x0000000427097208ULL, 0x000fe40004000000ULL, 0x0000000510047208ULL, 0x000fe40004800000ULL,
0x000000280900720bULL, 0x000fe40003f1e000ULL, 0x0000001b0400720bULL, 0x000fe40003f3e000ULL,
0x0000000928097208ULL, 0x000fe40004000000ULL, 0x000000041b057208ULL, 0x000fc40004800000ULL,
0x0000002c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fe40003f3e000ULL,
0x000000092c047208ULL, 0x000fe40004000000ULL, 0x000000051c087208ULL, 0x000fe40004800000ULL,
0x0000002b0400720bULL, 0x000fe40003f1e000ULL, 0x000000150800720bULL, 0x000fc40003f3e000ULL,
0x000000042b047208ULL, 0x000fe40004000000ULL, 0x0000000815057208ULL, 0x000fe40004800000ULL,
0x000000290400720bULL, 0x000fe40003f1e000ULL, 0x000000160500720bULL, 0x000fe40003f3e000ULL,
0x0000000429097208ULL, 0x000fe40004000000ULL, 0x0000000516047208ULL, 0x000fc40004800000ULL,
0x000000220900720bULL, 0x000fe40003f1e000ULL, 0x000000170400720bULL, 0x000fe40003f3e000ULL,
0x0000000922097208ULL, 0x000fe40004000000ULL, 0x0000000417057208ULL, 0x000fe40004800000ULL,
0x0000001a0900720bULL, 0x000fe40003f1e000ULL, 0x000000180500720bULL, 0x000fc40003f3e000ULL,
0x000000091a0a7208ULL, 0x000fe40004000000ULL, 0x00000005180c7208ULL, 0x000fe20004800000ULL,
0x000017127f007947ULL, 0x000fec000b800000ULL, 0x0c401f000a047f89ULL, 0x0004e400000e0000ULL,
0x000000040a00720bULL, 0x008fc80003f1e000ULL, 0x0000000a040d7208ULL, 0x000fe20004000000ULL,
0x000017427f007947ULL, 0x000fea000b800000ULL, 0x0c401f000c047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000e6800000e0000ULL, 0x0c401f0007327f89ULL, 0x000ea200000e0000ULL,
0x000000040c00720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x002fe40003f3e000ULL,
0x0000000c04087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f000d047f89ULL, 0x000e6200000e0000ULL, 0x000000320700720bULL, 0x004fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000ea200000e0000ULL, 0x0000000732327208ULL, 0x000fc60004000000ULL,
0x0c201f00090a7f89ULL, 0x000ee800000e0000ULL, 0x0c201f0032337f89ULL, 0x0002e400000e0000ULL,
0x000000040d00720bULL, 0x002fe40003f1e000ULL, 0x000000050800720bULL, 0x004fe40003f3e000ULL,
0x0000000d04047208ULL, 0x000fc40004000000ULL, 0x0000000a0900720bULL, 0x008fe40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x000000090a067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04347820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c19197812ULL, 0x000fe400078ec0ffULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010834ULL,
0x000000333200720bULL, 0x004fe20003f3e000ULL, 0x00000026000e7308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b23237823ULL, 0x000fc40000010834ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b24247823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010834ULL,
0x0000001300087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29267823ULL, 0x102fe40000010834ULL,
0x3fb8aa3b05297820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b31317823ULL, 0x000fc40000010834ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010829ULL, 0x0000002300097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010829ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fc40000010829ULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b2a077823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b21217823ULL, 0x000fe20000010829ULL, 0x00000012000b7308ULL, 0x000ea20000000800ULL,
0x000000080908723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b2f237823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b272a7823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b28277823ULL, 0x000fc40000010834ULL,
0x00000024000a7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b22227823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b1a1a7823ULL, 0x000fe20000010834ULL, 0x0000002d002d7308ULL, 0x000ee20000000800ULL,
0x00000004ff247e24ULL, 0x002fe2000f8e00ffULL, 0x0000001e0b09723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b101e7823ULL, 0x100fe20000010829ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010829ULL, 0x3f8000002424783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010829ULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b17177823ULL, 0x000fc40000010829ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0024ULL,
0x3fb8aa3b18187823ULL, 0x000fc60000010829ULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x0000000a2d0a723eULL, 0x008fce00000010ffULL, 0x00000025000d7308ULL, 0x0005e20000000800ULL,
0x0000001d2e0b723eULL, 0x002fe200000010ffULL, 0x000000ffff257224ULL, 0x004fcc00078e0024ULL,
0x00000007000c7308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b111d7823ULL, 0x000fe40000010829ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0024ULL, 0x000000240810723cULL, 0x000b6800000418ffULL,
0x0000003100317308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b2b077823ULL, 0x002fe40000010834ULL,
0x00000002ff257819ULL, 0x020fca0000011602ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x0000000c0d0c723eULL, 0x004fe200000010ffULL, 0x0000000825347824ULL, 0x040fe200078e00ffULL,
0x0000000825387810ULL, 0x040fe20007ffe0ffULL, 0x0000000825367824ULL, 0x000fc800078e00ffULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x0000000e310e723eULL, 0x008fe200000010ffULL,
0x000000ffff317224ULL, 0x000fcc00078e0024ULL, 0x00000021000f7308ULL, 0x0005f00000000800ULL,
0x0000003000307308ULL, 0x000ee20000000800ULL, 0x000000201f0d723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b1b217823ULL, 0x004fc40000010829ULL, 0x00000008251f7824ULL, 0x000fc800078e00ffULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x0000000f300f723eULL, 0x008fce00000010ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000ffff307224ULL, 0x000fe200078e0024ULL,
0x0000002e0c10723cULL, 0x000b6c0000041810ULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002c002c7308ULL, 0x000e700000000800ULL, 0x0000001d001d7308ULL, 0x000ff00000000800ULL,
0x0000001e00287308ULL, 0x0004f00000000800ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x00000001251e7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff81f2e7812ULL, 0x020fe400078ee21eULL,
0x000000272c1e723eULL, 0x002fe200000010ffULL, 0x0000001c00207308ULL, 0x0002a20000000800ULL,
0x0000001d281d723eULL, 0x008fe200000010ffULL, 0x0000000825277824ULL, 0x040fe400078e00ffULL,
0x00000008252c7824ULL, 0x000fc800078e00ffULL, 0x0000001a001b7308ULL, 0x0007e20000000800ULL,
0x000000232a1c723eULL, 0x002fe200000010ffULL, 0x0000000825237824ULL, 0x000fe200078e00ffULL,
0x00000021201f723eULL, 0x004fca00000010ffULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x00000002251a7810ULL, 0x048fe40007ffe0ffULL, 0x0000000325207810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823287812ULL, 0x000fe200078ee21aULL, 0x000000301c10723cULL, 0x000b620000041810ULL,
0x0000000425217810ULL, 0x040fe20007ffe0ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x00000008251a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8272a7812ULL, 0x000fc400078ee220ULL,
0xfffffff82c2c7812ULL, 0x000fe400078ee221ULL, 0x0000000525207810ULL, 0x040fe40007ffe0ffULL,
0x0000002200227308ULL, 0x000ea20000000800ULL, 0x0000000625217810ULL, 0x040fe40007ffe0ffULL,
0xffffffff25237810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee225ULL,
0x0000000838257824ULL, 0x000fe200078e00ffULL, 0xfffffff827307812ULL, 0x020fe200078ee220ULL,
0x0000001500157308ULL, 0x000fe20000000800ULL, 0xfffffff834347812ULL, 0x000fc400078ee221ULL,
0xfffffff836367812ULL, 0x000fe400078ee223ULL, 0xfffffff825387812ULL, 0x000fe200078ee238ULL,
0x000000ffff257224ULL, 0x000fe200078e0024ULL, 0x000000072620723eULL, 0x002fe200000010ffULL,
0x0000001600167308ULL, 0x000e620000000800ULL, 0x000000221b22723eULL, 0x004fe400000010ffULL,
0x0001100000077811ULL, 0x000fca00078e58ffULL, 0x0000001700177308ULL, 0x000fe20000000800ULL,
0x000000101a1a7824ULL, 0x100fe400078e0207ULL, 0x000000102e2e7824ULL, 0x100fe400078e0207ULL,
0x0000001028287824ULL, 0x100fe400078e0207ULL, 0x000000102a2a7824ULL, 0x100fe200078e0207ULL,
0x0000001800187308ULL, 0x000ea20000000800ULL, 0x000000151621723eULL, 0x002fe200000010ffULL,
0x000000102c2c7824ULL, 0x000fc400078e0207ULL, 0x000000011a157824ULL, 0x000fe400078e0219ULL,
0x0000001030307824ULL, 0x100fe400078e0207ULL, 0x00000001192e7824ULL, 0x040fe200078e022eULL,
0x0000000815007388ULL, 0x0003e20000000800ULL, 0x0000001034347824ULL, 0x100fe400078e0207ULL,
0x0000000119287824ULL, 0x040fe200078e0228ULL, 0x0000000a2e007388ULL, 0x0003e20000000800ULL,
0x0000001036367824ULL, 0x100fe200078e0207ULL, 0x000000171823723eULL, 0x004fe200000010ffULL,
0x00000001192a7824ULL, 0x000fe200078e022aULL, 0x0000000c28007388ULL, 0x0003e20000000800ULL,
0x0000001038387824ULL, 0x000fe200078e0207ULL, 0x0000003233077208ULL, 0x000fe20004800000ULL,
0x00000001192c7824ULL, 0x040fe200078e022cULL, 0x0000000e2a007388ULL, 0x0003e20000000800ULL,
0x000000242010723cULL, 0x000f620000041810ULL, 0x0000000119307824ULL, 0x000fc400078e0230ULL,
0x0000000119347824ULL, 0x040fe200078e0234ULL, 0x0000001c2c007388ULL, 0x0003e20000000800ULL,
0x0000000119367824ULL, 0x040fe400078e0236ULL, 0x0000000119387824ULL, 0x000fe200078e0238ULL,
0x0000001e30007388ULL, 0x0003e80000000800ULL, 0x0000002034007388ULL, 0x0003e80000000800ULL,
0x0000002236007388ULL, 0x0003e80000000800ULL, 0x0000000938007388ULL, 0x0003e80000000800ULL,
0x0004000b2e007388ULL, 0x0003e20000000800ULL, 0x000000ffff117224ULL, 0x020fc600078e0012ULL,
0x0004000d28007388ULL, 0x0003e80000000800ULL, 0x0004000f2a007388ULL, 0x0003e80000000800ULL,
0x0004001d2c007388ULL, 0x0003e80000000800ULL, 0x0004001f30007388ULL, 0x0003e80000000800ULL,
0x0004002134007388ULL, 0x0003e80000000800ULL, 0x0004002336007388ULL, 0x0003e80000000800ULL,
0x0170000414008388ULL, 0x0003e80000000c00ULL, 0x0172001014008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007bff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008007bff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010007bff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000163637810ULL, 0x000fe20007ffe0ffULL,
0x000018007bff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff627224ULL, 0x000fc400078e0068ULL,
0x000000736300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff9bb000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x0001868000157802ULL, 0x000fc40000000f00ULL, 0x00000f3000007944ULL, 0x014fea0003c00000ULL,
0xfffe9f5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x000186d000157802ULL, 0x000fc40000000f00ULL,
0x00000ee000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff057224ULL, 0x000fe200078e003cULL,
0xfffe9f8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0003ULL,
0x00018740003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000e2000007944ULL, 0x014fea0003c00000ULL,
0xfffea04000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0003ULL,
0x000187a0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000dc000007944ULL, 0x014fea0003c00000ULL,
0xfffea14000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0002ULL,
0x00018810003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0003ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000d5000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e003cULL,
0xfffea53000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0002ULL,
0x00018880003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e003cULL, 0xfffea4f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x004fe20004000000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x000188e000157802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x008fea0003c00000ULL,
0xfffed3b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x0001893000157802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff387224ULL, 0x000fe200078e003cULL,
0xfffed3e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e003aULL,
0x000189a0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000bc000007944ULL, 0x008fea0003c00000ULL,
0xfffed4b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e003aULL,
0x00018a00003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000b6000007944ULL, 0x008fea0003c00000ULL,
0xfffed5b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0010ULL,
0x00018a70003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0017ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e003cULL,
0xfffed9c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0010ULL,
0x00018ae0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000a8000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e003cULL, 0xfffed98000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x00018b4000157802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x014fea0003c00000ULL,
0xffff066000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x00018b9000157802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e003cULL,
0xffff06a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00018c00003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000096000007944ULL, 0x014fea0003c00000ULL,
0xffff076000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00018c60003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000090000007944ULL, 0x014fea0003c00000ULL,
0xffff086000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00018cd0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0013ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000089000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e003cULL,
0xffff0c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00018d40003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000082000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e003cULL, 0xffff0c2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x00018da000157802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x014fea0003c00000ULL,
0xffff396000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x00018df000157802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e003cULL,
0xffff39a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00018e60003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000070000007944ULL, 0x010fea0003c00000ULL,
0xffff3a6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00018ec0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x010fea0003c00000ULL,
0xffff3b6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0004ULL,
0x00018f30003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0011ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e003cULL,
0xffff3fc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0004ULL,
0x00018fa0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e003cULL, 0xffff3f8000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0001901000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0033ULL,
0xffffe89000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x006fe200078e000cULL,
0x0001909000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x010fea0003c00000ULL, 0x000000330c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0006ULL, 0x0001911000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c330c7208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000330600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0007ULL, 0x0001919000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000633067208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000330700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e000dULL, 0x0001921000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000733327208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000330d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e000cULL, 0x0001929000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000d33047208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000330c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0006ULL, 0x0001931000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c33057208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000330600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0032ULL, 0x0001939000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000633067208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe68000007947ULL, 0x000fea000383ffffULL,
0x018000000f007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000f00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0fff7812ULL, 0x040fe4000780c0ffULL, 0x800000000f027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000f00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe6ae002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000e00007348ULL, 0x000fe80003800000ULL,
0x0c00000b0a337389ULL, 0x0002a200000e0033ULL, 0xfffe6aa008007950ULL, 0x000fea0003c3ffffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x00000014153c7389ULL, 0x0002a400000e003fULL,
0x000000ffff147224ULL, 0x002fc400078e003eULL, 0x00000000ff157424ULL, 0x000fc800078e00ffULL,
0xfffe6a5014007950ULL, 0x000fea0003c3ffffULL, 0x000000011400780cULL, 0x000fe20003f45070ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x0000003e00007348ULL, 0x000fe80003800000ULL,
0x00000000ff157424ULL, 0x000fce00078e00ffULL, 0x00000000003c7806ULL, 0x000fc800050e0100ULL,
0x0000003e3c3c7212ULL, 0x000fe200078ec0ffULL, 0xfffe69e014007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x00000000000002d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cd0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d90ULL, 0x00000000000007c0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001550ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001560ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f4ULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000019700ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001af00ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001af50ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b2d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019910ULL, 0x0000000000019910ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001af00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b2d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_80_cubin_len = 111536;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
