/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019550ULL, 0x00000000000191d0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000017670ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x00000000000177f0ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000017830ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000017880ULL, 0x0000000000000100ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000017980ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001767000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x005c2c0400288080ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9508288080940828ULL,
0x288080ae08288080ULL, 0x8280162880808408ULL, 0x0000000003102880ULL, 0x8080849200000000ULL,
0x0000000000220028ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001767000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9208288080840828ULL,
0x2880809408288080ULL, 0x80ae082880809508ULL, 0x1628808090082880ULL, 0x0000031028808280ULL,
0x9092000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000011000000000ULL,
0x000177f000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x9408288080840828ULL, 0x288080ae08288080ULL, 0x8280162880809508ULL,
0x0000000003102880ULL, 0x8080959200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL,
0x000001a000000000ULL, 0x0001783000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x8094288080950900ULL, 0x0000000000002880ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9508288080840828ULL, 0x288080ae08288080ULL, 0x8280162880809408ULL, 0x0000000003102880ULL,
0x8080949200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000023800000000ULL,
0x0001788000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL,
0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0060016000000018ULL, 0x000c170400601903ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0x0000090000043104ULL,
0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002c001342804ULL,
0x00000580000003d0ULL, 0x00002670000025c0ULL, 0x000028f000002790ULL, 0x00002d9000002d60ULL,
0x00002e3000002de0ULL, 0x00005ce000005c50ULL, 0x00005f7000005e10ULL, 0x0000643000006400ULL,
0x000064d000006480ULL, 0x000091c000009120ULL, 0x00009440000092e0ULL, 0x000098f0000098c0ULL,
0x0000999000009940ULL, 0x0000c6e00000c640ULL, 0x0000c9600000c800ULL, 0x0000ce500000ce20ULL,
0x0000cef00000cea0ULL, 0x0000f0800000f070ULL, 0x00015f6000015f20ULL, 0x00015f8000015f70ULL,
0x00015ff000015f90ULL, 0x0001603000016010ULL, 0x00016cf000016cb0ULL, 0x00016d8000016d40ULL,
0x00016e2000016dd0ULL, 0x00016eb000016e70ULL, 0x00016f4000016f00ULL, 0x00016fe000016f90ULL,
0x0001707000017030ULL, 0x00017100000170c0ULL, 0x000171a000017150ULL, 0x00017230000171f0ULL,
0x000172c000017280ULL, 0x0001736000017310ULL, 0x00017410000173b0ULL, 0x000174d000017470ULL,
0x0001759000017530ULL, 0x00017650000175f0ULL, 0x0000039004403904ULL, 0x0000f600000000ffULL,
0x00000430003f0100ULL, 0x0000f6080000000dULL, 0x000004b0003f0120ULL, 0x0000f6880000000dULL,
0x000004f0003f0120ULL, 0x0000f6a80000000dULL, 0x00000530003f0120ULL, 0x0000f6c80000000dULL,
0x00000920003f0120ULL, 0x0000f600000000ffULL, 0x00000b10003f0107ULL, 0x0000000400000003ULL,
0x00000bc0003f0102ULL, 0x0000000000000003ULL, 0x000013b0003f0101ULL, 0x0000f6a80000006bULL,
0x000014c0003f0107ULL, 0x0000f6a80000006bULL, 0x00001520003f0101ULL, 0x0000f6c800000004ULL,
0x00001690003f0101ULL, 0x0000f6cc0000000aULL, 0x00001870003f0105ULL, 0x0000f6cc0000000aULL,
0x000021e0003f0105ULL, 0x0000f6b0000000ffULL, 0x0000226000050107ULL, 0x0000f6b0000000ffULL,
0x000022c000050101ULL, 0x0000f60800000009ULL, 0x000022e0003f0101ULL, 0x0000f60c00000009ULL,
0x000024b0003f0105ULL, 0x0000f60c00000009ULL, 0x00002ac0003f0105ULL, 0x0000f6ac0000002cULL,
0x00002c90003f0105ULL, 0x0000f6ac0000002cULL, 0x00004e30003f0105ULL, 0x000000000000000cULL,
0x00004e90003f0101ULL, 0x0000f68800000053ULL, 0x00004ec0003f0101ULL, 0x0000000400000003ULL,
0x00005080003f0105ULL, 0x0000000400000003ULL, 0x000058a0003f0105ULL, 0x0000f6a80000000aULL,
0x00005930003f0107ULL, 0x0000f6a80000000aULL, 0x00005990003f0101ULL, 0x0000f62800000009ULL,
0x000059b0003f0101ULL, 0x0000f62c00000009ULL, 0x00005b80003f0105ULL, 0x0000f62c00000009ULL,
0x00006160003f0105ULL, 0x0000f6b400000034ULL, 0x00006330003f0105ULL, 0x0000f6b400000034ULL,
0x000082b0003f0105ULL, 0x000000000000000cULL, 0x00008310003f0101ULL, 0x0000f69000000014ULL,
0x00008340003f0101ULL, 0x0000000400000003ULL, 0x00008500003f0105ULL, 0x0000000400000003ULL,
0x00008d00003f0105ULL, 0x0000f6b00000006bULL, 0x00008e00003f0107ULL, 0x0000f6b000000008ULL,
0x00008e60003f0101ULL, 0x0000f64800000009ULL, 0x00008e80003f0101ULL, 0x0000f64c00000009ULL,
0x00009050003f0105ULL, 0x0000f64c00000009ULL, 0x00009620003f0105ULL, 0x0000f6ac00000036ULL,
0x000097f0003f0105ULL, 0x0000f6ac00000036ULL, 0x0000b7e0003f0105ULL, 0x000000000000000eULL,
0x0000b840003f0101ULL, 0x0000000000000009ULL, 0x0000b870003f0101ULL, 0x0000000400000003ULL,
0x0000ba30003f0105ULL, 0x0000000400000003ULL, 0x0000c290003f0105ULL, 0x00000000000000ffULL,
0x0000c34000040107ULL, 0x0000f6a80000006bULL, 0x0000c3a0003f0101ULL, 0x0000f66800000003ULL,
0x0000c3c0003f0101ULL, 0x0000f66c00000003ULL, 0x0000c590003f0105ULL, 0x0000f66c00000003ULL,
0x0000cb20003f0105ULL, 0x0000f6b40000006bULL, 0x0000cd40003f0105ULL, 0x0000f6b40000006bULL,
0x0000ee40003f0105ULL, 0x0000000000000003ULL, 0x0000eec0003f0101ULL, 0x000000000000000aULL,
0x00010020003f0101ULL, 0x0000f600000000ffULL, 0x00010c50003f0101ULL, 0x0000f604000000ffULL,
0x00010e20003f0105ULL, 0x0000f604000000ffULL, 0x00011050003f0105ULL, 0x0000f600000000ffULL,
0x00011080003f0101ULL, 0x0000f604000000ffULL, 0x00011240003f0105ULL, 0x0000f604000000ffULL,
0x00014450003f0105ULL, 0x0000000000000078ULL, 0x00014510003f0101ULL, 0x0000000400000078ULL,
0x000146e0003f0105ULL, 0x0000000400000078ULL, 0x00016b10003f0105ULL, 0x000000000000007aULL,
0x00016b70003f0101ULL, 0x000000080000007aULL, 0x00016bd0003f0101ULL, 0x000000100000007aULL,
0x00016c40003f0101ULL, 0x000000180000007aULL, 0x00053803003f0101ULL, 0x0000f93000201c04ULL,
0x0000fb400000f960ULL, 0x0000fe300000fca0ULL, 0x000112a00000ff30ULL, 0x0000040100016c80ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000002acULL, 0x0000001b00000002ULL, 0x0000000000000214ULL,
0x0000001b00000002ULL, 0x000000000000018cULL, 0x0000001b00000002ULL, 0x00000000000000e4ULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000284ULL,
0x0000001b00000002ULL, 0x00000000000001ecULL, 0x0000001b00000002ULL, 0x0000000000000166ULL,
0x0000001b00000002ULL, 0x00000000000000bcULL, 0x0000001b00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e7c7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL,
0x00000005ff0a7819ULL, 0x010fc80000011607ULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003757a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a75ULL,
0x0000040003007624ULL, 0x000fca00078e020eULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000175750810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000175751810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff75aa12ULL, 0x000fc800078e33ffULL, 0x0000007500007306ULL, 0x000e620000209000ULL,
0x000000ff7500720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000375047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603707227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a70ULL, 0x0000000075007224ULL, 0x000fca00078e0206ULL,
0x000000750000720cULL, 0x000fe20003f66070ULL, 0x000001000b027a24ULL, 0x008fe400078e0204ULL,
0x00001fff0b0b7589ULL, 0x000fe400000e0000ULL, 0x00000000020d7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0d00720cULL, 0x000fc60003f45270ULL, 0x0000000100003824ULL, 0x000fe200078e0a75ULL,
0x0000000170703810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0d00780cULL, 0x040fe40003f04070ULL,
0x000000750000720cULL, 0x000fe40003f86070ULL, 0x0000000f0d00780cULL, 0x040fe40003f24070ULL,
0x000000030d00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL, 0xff317217ff0c8424ULL, 0x000fe400078e00ffULL,
0x0000000170704810ULL, 0x000fe20007ffe0ffULL, 0x00f60002ff00a388ULL, 0x000fe20000000a00ULL,
0x00000075ff70d212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f84070ULL, 0x00001fff0a027589ULL, 0x0002a200000e0000ULL,
0x7fffffc0ff059424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fe200078e0a70ULL,
0x00f4000c0d008388ULL, 0x000fe20000004800ULL, 0x7fffff60ff07b424ULL, 0x000fc400078e00ffULL,
0x0000000075757224ULL, 0x000fe200078e0206ULL, 0x00f608040d009388ULL, 0x0007e20000008a00ULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x00005a00700a7a19ULL, 0x002fe200000006ffULL,
0x0000001075737824ULL, 0x000fe200078e00ffULL, 0x0000000000007919ULL, 0x000e620000002700ULL,
0x3fffff80ff08b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff09b424ULL, 0x000fe200078e00ffULL,
0x0000000473037c10ULL, 0x040fe2000fffe1ffULL, 0x00f688060d00b388ULL, 0x0005e20000008a00ULL,
0x0000000473007c0cULL, 0x000fc4000bf03070ULL, 0x0000001003037817ULL, 0x000fe20003800000ULL,
0x3fffffc0ff04c424ULL, 0x008fe200078e00ffULL, 0x00f6a8080d00b388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL, 0x000000ff03747207ULL, 0x000fc80000000000ULL,
0x000000107400780cULL, 0x000fe20003f05270ULL, 0x00f6c8040d00c388ULL, 0x000fe20000008a00ULL,
0x000000040b067824ULL, 0x004fc800078e0202ULL, 0x0000000206077824ULL, 0x000fe400078e00ffULL,
0x0000580000037a24ULL, 0x002fc800078e02ffULL, 0x0000007c03037224ULL, 0x000fe200078e020aULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000447919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff087819ULL, 0x002fca0000011644ULL, 0x0000000107097824ULL, 0x000fc800078e0208ULL,
0x0000000173047824ULL, 0x000fca00078e0209ULL, 0x0000000404067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe40000011604ULL, 0x0000000774047217ULL, 0x000fe20007800000ULL,
0x0000000103067824ULL, 0x000fc800078e0206ULL, 0x0000007c05067224ULL, 0x000fe400078e0206ULL,
0x0000001044057824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe400078e0a07ULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x000000f005037812ULL, 0x000fe400078ec0ffULL,
0x000000040800720cULL, 0x000fe20003f06070ULL, 0x0000000109047824ULL, 0x040fe200078e0244ULL,
0x0000000306037212ULL, 0x000fe200078efcffULL, 0x0000001009097824ULL, 0x000fc600078e00ffULL,
0x00005e0003067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff009047812ULL, 0x000fe400078ee204ULL,
0x00005f0007077a10ULL, 0x000fc60000ffe4ffULL, 0x0000001004037824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000447919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000744047211ULL, 0x002fca00078fe0ffULL,
0x0000000173057824ULL, 0x000fca00078e0204ULL, 0x0000000405067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fc60000011605ULL, 0x0000000103067824ULL, 0x000fe400078e0206ULL,
0x0000000104037824ULL, 0x000fe400078e0244ULL, 0x0000007c05067224ULL, 0x000fe400078e0206ULL,
0x0000001044057824ULL, 0x000fe400078e00ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000f005097812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x000fc600078e00ffULL,
0x0000000906067212ULL, 0x000fe400078efcffULL, 0xfffffff004037812ULL, 0x000fe400078ee203ULL,
0x00005e0006067a10ULL, 0x000fc60007f1e0ffULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x00005f0007077a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e8000b901c48ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x0000000000037806ULL, 0x000fe200038e0000ULL, 0x00000004ff097424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000300047300ULL, 0x000e7000000e0000ULL,
0x0000000300067309ULL, 0x000ea20000000000ULL, 0x000000070400720cULL, 0x002fe20003f02070ULL,
0x000000ffff047224ULL, 0x004fc400078e0a06ULL, 0x0000660000067625ULL, 0x000fd400078e0009ULL,
0x00f60404ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008066d7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f6d6f7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff6d0c7810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff6f7819ULL, 0x000fe4000001166fULL,
0x00000008ff6e7819ULL, 0x000fca000001160cULL, 0x0000f4e000008947ULL, 0x000fea0003800000ULL,
0x00000003ff667819ULL, 0x000fe20000011602ULL, 0xffffffffff457424ULL, 0x000fc600078e00ffULL,
0x01ffffff66667812ULL, 0x000fc800078ec0ffULL, 0x0000006f6600720cULL, 0x000fda0003f06070ULL,
0x0000000200038824ULL, 0x000fe400078e00ffULL, 0x00006800ff048624ULL, 0x002fc800078e00ffULL,
0x0000680003078624ULL, 0x000fe200078e0204ULL, 0x0000f68802037811ULL, 0x000fe200078e18ffULL,
0x00000003ff047424ULL, 0x000fe400078e00ffULL, 0x0000000166078824ULL, 0x000fe200078e0207ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040403ff738cULL, 0x0003e20000000000ULL,
0x0000640007068625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000806458981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x0000008070677824ULL, 0x000fe200078e00ffULL, 0x00000001ff467819ULL, 0x000fe20000011602ULL,
0x0000000003ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000102727812ULL, 0x000fc600078ec0ffULL,
0x0000002046787824ULL, 0x000fca00078e00ffULL, 0x0000006067047812ULL, 0x002fe200078ef878ULL,
0x0000590045087a24ULL, 0x004fc800078e02ffULL, 0x0000008008157824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x000000786d037217ULL, 0x008fe20007800000ULL,
0x0000001072067824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x000fe40000011644ULL,
0x00006200150f7a11ULL, 0x000fe200078838ffULL, 0x0000000103037824ULL, 0x000fe200078e0a78ULL,
0x00000004070a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0207ULL,
0x0000000c070c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000603037217ULL, 0x000fe20007800000ULL,
0x0000000109087824ULL, 0x000fe200078e0244ULL, 0x0000630015157a11ULL, 0x000fe200020f3cffULL,
0x00000008090b7824ULL, 0x000fc400078e00ffULL, 0x0000000103037824ULL, 0x000fe400078e0a06ULL,
0x00000001060d7824ULL, 0x000fe200078e020cULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee208ULL,
0x0000000807087810ULL, 0x000fe20007ffe0ffULL, 0x000000080d147824ULL, 0x000fe200078e00ffULL,
0x000000030700720cULL, 0x080fe20003f66070ULL, 0x0000000104077824ULL, 0x000fe200078e0209ULL,
0x000000030800720cULL, 0x080fe20003f26070ULL, 0x0000000106097824ULL, 0x000fe200078e020aULL,
0x000000030c00720cULL, 0x080fe20003f06070ULL, 0x00000001060b7824ULL, 0x000fe200078e0208ULL,
0x000000030a00720cULL, 0x000fe20003f46070ULL, 0x0000000109067824ULL, 0x000fc400078e0244ULL,
0x0000000809117824ULL, 0x000fe400078e00ffULL, 0x000000010b087824ULL, 0x040fe400078e0244ULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0xfffffff811107812ULL, 0x000fe200078ee206ULL,
0x0000008007067825ULL, 0x000fc600078e00ffULL, 0xfffffff813127812ULL, 0x000fe200078ee208ULL,
0x0000000104097824ULL, 0x000fe200078e0209ULL, 0x0000007006067812ULL, 0x000fe200078ef805ULL,
0x00000001040b7824ULL, 0x040fe400078e020bULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x000000060f067210ULL, 0x000fe20007f9e0ffULL, 0x0000008009087825ULL, 0x000fc800078e00ffULL,
0x000000010d037824ULL, 0x000fe200078e0244ULL, 0x0000007008047812ULL, 0x000fe200078ef805ULL,
0x000000800b0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee203ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a087812ULL, 0x000fe400078ef805ULL,
0x0000b00046037811ULL, 0x000fe200078e68ffULL, 0x0000000107077824ULL, 0x000fe200020e0615ULL,
0x000000700c057812ULL, 0x000fe400078ef805ULL, 0x0000000f04047210ULL, 0x080fe20007f9e0ffULL,
0x0000001010117824ULL, 0x100fe200078e0203ULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x0000001012137824ULL, 0x100fe200078e0203ULL, 0x0000000f050a7210ULL, 0x000fe20007fde0ffULL,
0x000000100e0f7824ULL, 0x000fc400078e0203ULL, 0x0000000109057824ULL, 0x100fe400020e0615ULL,
0x000000010b097824ULL, 0x000fe200028e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000d901c48ULL, 0x0000001014037824ULL, 0x000fe400078e0203ULL,
0x000000010d0b7824ULL, 0x000fe200030e0615ULL, 0x0000000004117faeULL, 0x0003e8000d101c48ULL,
0x0000000008137faeULL, 0x0003e8000c901c48ULL, 0x000000000a037faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001072037824ULL, 0x008fe200078e00ffULL,
0x0000620015117a11ULL, 0x000fc400078038ffULL, 0x0000b00046137811ULL, 0x000fe400078e68ffULL,
0x0000000344037211ULL, 0x000fe400078fe8ffULL, 0x0000630015157a11ULL, 0x000fe400000f3cffULL,
0x0000000403097810ULL, 0x040fe20007ffe0ffULL, 0x0000000103067824ULL, 0x040fe200078e0244ULL,
0x00000008030b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000803077824ULL, 0x000fe400078e00ffULL,
0x00000008090a7824ULL, 0x000fc400078e00ffULL, 0x000000010b087824ULL, 0x000fe200078e0244ULL,
0xfffffff8070e7812ULL, 0x000fe200078ee206ULL, 0x0000000109077824ULL, 0x000fe400078e0244ULL,
0x0000000104067824ULL, 0x000fe200078e0203ULL, 0x0000000c03037810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0f7812ULL, 0x000fe200078ee207ULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee208ULL,
0x0000000104097824ULL, 0x000fe200078e0209ULL, 0x0000007006067812ULL, 0x000fe200078ef805ULL,
0x00000001040b7824ULL, 0x040fe400078e020bULL, 0x00000001040c7824ULL, 0x000fe200078e0203ULL,
0x0000000611067210ULL, 0x000fe20007f1e0ffULL, 0x0000000103047824ULL, 0x040fe400078e0244ULL,
0x0000000803037824ULL, 0x000fe400078e00ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0xfffffff803127812ULL, 0x000fe200078ee204ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008047812ULL, 0x000fc600078ef805ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a087812ULL, 0x000fc600078ef805ULL, 0x0000000107077824ULL, 0x000fe200000e0615ULL,
0x000000700c057812ULL, 0x000fe200078ef805ULL, 0x000000100e037824ULL, 0x100fe200078e0213ULL,
0x0000000411047210ULL, 0x000fe20007f1e0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0213ULL,
0x0000000811087210ULL, 0x040fe40007f3e0ffULL, 0x00000005110a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000109057824ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e2000b901c48ULL, 0x0000001010117824ULL, 0x000fc400078e0213ULL,
0x000000010b097824ULL, 0x000fe200008e0615ULL, 0x00000000040f7faeULL, 0x0003e2000b901c48ULL,
0x0000001012137824ULL, 0x000fe400078e0213ULL, 0x000000010d0b7824ULL, 0x000fe200010e0615ULL,
0x0000000008117faeULL, 0x0003e8000b901c48ULL, 0x000000000a137faeULL, 0x0003e4000b901c48ULL,
0x00000010466b7824ULL, 0x000fe200078e00ffULL, 0x000000ff6e00720cULL, 0x000fe20003f05270ULL,
0x0000000846047824ULL, 0x002fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000006b0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8006b0c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6c80004047f8cULL, 0x000ee2000c80043fULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000d93000008947ULL, 0x000fea0003800000ULL, 0x0000000200697824ULL, 0x000fe200078e00ffULL,
0x00000002ff6a7819ULL, 0x000fe20000011602ULL, 0x00006800ff007624ULL, 0x000fc400078e00ffULL,
0x000000ffff077224ULL, 0x008fe400078e0005ULL, 0x0000680069697624ULL, 0x000fe400078e0200ULL,
0xff317217ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fc400078e00ffULL, 0x0000000000087805ULL, 0x01afca0000015200ULL,
0x0000000402037824ULL, 0x000fca00078e00ffULL, 0xfffffff8030a7812ULL, 0x000fc800078ec0ffULL,
0x0000f6c80a037810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc000a0c7984ULL, 0x004ea40000000800ULL,
0x800000000cff7812ULL, 0x004fe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014080f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e09ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011414ULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e0614ULL,
0x000000020c0c7819ULL, 0x000fc8000000120fULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc000a0c7984ULL, 0x000ea40000000800ULL,
0x800000000cff7812ULL, 0x004fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002077824ULL, 0x000fe200078e00ffULL,
0x00000001000f7810ULL, 0x000fe20007ffe0ffULL, 0x0000590045457a24ULL, 0x000fc600078e02ffULL,
0xffffffe007097812ULL, 0x000fe200078ec0ffULL, 0x0000008045457824ULL, 0x000fe200078e00ffULL,
0x0000006e0f00720cULL, 0x000fc60003f26070ULL, 0x0000010000097824ULL, 0x000fca00078e0209ULL,
0x00000040090a7810ULL, 0x000fc80007ffe0ffULL, 0x000000600a087812ULL, 0x000fca00078ec0ffULL,
0x0000000167387824ULL, 0x000fe200078e0208ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001007087812ULL, 0x000fe200078ec0ffULL, 0x0000001044147824ULL, 0x000fe200078e00ffULL,
0x0000000a6d077217ULL, 0x000fe40007800000ULL, 0x00000003ff0c7819ULL, 0x000fe40000011644ULL,
0x0000007014397812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x000fe200078e0a0aULL,
0x000000040c0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010c097824ULL, 0x000fe200078e0208ULL,
0x00006200452f7a11ULL, 0x000fc400078a38ffULL, 0x0000000807077217ULL, 0x000fe20007800000ULL,
0x00000001090a7824ULL, 0x000fe200078e0244ULL, 0x00006300453b7a11ULL, 0x000fe200028f3cffULL,
0x0000000809157824ULL, 0x000fe400078e00ffULL, 0x0000000107077824ULL, 0x000fe400078e0a08ULL,
0x0000000138097824ULL, 0x000fe200078e0209ULL, 0xfffffff8150a7812ULL, 0x000fe400078ee20aULL,
0x000000080c157810ULL, 0x000fc40007ffe0ffULL, 0x000000070c00720cULL, 0x0c0fe40003f86070ULL,
0x0000000c0c0c7810ULL, 0x000fe40007ffe0ffULL, 0x000000071500720cULL, 0x0c0fe20003f46070ULL,
0x0000000115157824ULL, 0x100fe200078e0208ULL, 0x000000070f00720cULL, 0x0c0fe20003f66070ULL,
0x000000010f0f7824ULL, 0x100fe200078e0208ULL, 0x000000070c00720cULL, 0x040fe20003f06070ULL,
0x000000010c177824ULL, 0x000fe400078e0208ULL, 0x0000000115087824ULL, 0x000fc400078e0244ULL,
0x00000008152d7824ULL, 0x000fe400078e00ffULL, 0x00000001382c7824ULL, 0x000fe400078e020fULL,
0x000000010f077824ULL, 0x000fe200078e0244ULL, 0xfffffff82d2e7812ULL, 0x000fe200078ee208ULL,
0x0000008009087825ULL, 0x000fc800078e00ffULL, 0x000000080f0c7824ULL, 0x000fe200078e00ffULL,
0x0000003908087212ULL, 0x000fe200078efcffULL, 0x000000802c2c7825ULL, 0x000fc600078e00ffULL,
0x000000082f087210ULL, 0x000fe20007fbe0ffULL, 0x0000000138157824ULL, 0x000fe200078e0215ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000000138167824ULL, 0x000fe200078e0217ULL,
0x000000392c2c7212ULL, 0x000fe200078efcffULL, 0x0000000117077824ULL, 0x040fe400078e0244ULL,
0x0000000817387824ULL, 0x000fe400078e00ffULL, 0x0000008015147825ULL, 0x000fc600078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee207ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003914147212ULL, 0x000fe400078efcffULL, 0x0000c00046077811ULL, 0x000fe200078e68ffULL,
0x0000000109097824ULL, 0x000fe200028e063bULL, 0x0000002f2c2c7210ULL, 0x000fe40007fbe0ffULL,
0x0000003916167212ULL, 0x000fe200078efcffULL, 0x000000100a0f7824ULL, 0x000fe400078e0207ULL,
0x000000012d2d7824ULL, 0x000fe200028e063bULL, 0x0000002f14147210ULL, 0x080fe20007fbe0ffULL,
0x000000102e397824ULL, 0x100fe200078e0207ULL, 0x0000002f16167210ULL, 0x000fe20007fde0ffULL,
0x000000100c2f7824ULL, 0x000fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x0005e2000e101c48ULL, 0x0000000115157824ULL, 0x000fc400028e063bULL,
0x0000001038077824ULL, 0x000fe200078e0207ULL, 0x000000002c2f7faeULL, 0x0005e2000d901c48ULL,
0x0000000117177824ULL, 0x000fc600030e063bULL, 0x0000000014397faeULL, 0x0005e8000d101c48ULL,
0x0000000016077faeULL, 0x0005e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001007077812ULL, 0x000fe400078ec0ffULL, 0x0000620045397a11ULL, 0x040fe400078038ffULL,
0x0000000744077211ULL, 0x000fe400078fe8ffULL, 0x0000630045457a11ULL, 0x000fc400000f3cffULL,
0x00000004070f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000107087824ULL, 0x140fe200078e0244ULL,
0x0000000807157810ULL, 0x040fe20007ffe0ffULL, 0x0000000807177824ULL, 0x000fe200078e00ffULL,
0x0000c000463b7811ULL, 0x000fe200078e68ffULL, 0x000000010f097824ULL, 0x040fe400078e0244ULL,
0x000000080f0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8170a7812ULL, 0x000fe200078ee208ULL,
0x0000000115147824ULL, 0x040fe400078e0244ULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x0000001044097824ULL, 0x000fc400078e00ffULL,
0x0000000138087824ULL, 0x040fe200078e0207ULL, 0x0000000c07077810ULL, 0x000fe20007ffe0ffULL,
0x0000000138167824ULL, 0x000fe200078e0215ULL, 0x00000070092f7812ULL, 0x000fe200078ec0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0xfffffff8172e7812ULL, 0x000fc600078ee214ULL,
0x0000000138147824ULL, 0x000fe200078e020fULL, 0x0000002f08087212ULL, 0x000fe200078efcffULL,
0x00000001382c7824ULL, 0x000fe400078e0207ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000839087210ULL, 0x000fc60007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000002f14147212ULL, 0x000fc600078efcffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000002f16167212ULL, 0x000fc600078efcffULL, 0x00000001070f7824ULL, 0x040fe200078e0244ULL,
0x0000002f2c2c7212ULL, 0x000fe200078efcffULL, 0x0000000807387824ULL, 0x000fe200078e00ffULL,
0x0000001639167210ULL, 0x000fe20007f5e0ffULL, 0x0000000109097824ULL, 0x000fe200000e0645ULL,
0x0000001439147210ULL, 0x040fe20007f1e0ffULL, 0x000000100a077824ULL, 0x000fe200078e023bULL,
0xfffffff838387812ULL, 0x000fe200078ee20fULL, 0x000000100c0f7824ULL, 0x000fe200078e023bULL,
0x0000002c392c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000115157824ULL, 0x000fe200000e0645ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0005e2000b901c48ULL,
0x000000102e2f7824ULL, 0x000fc400078e023bULL, 0x0000000117177824ULL, 0x000fe200010e0645ULL,
0x00000000140f7faeULL, 0x0005e2000b901c48ULL, 0x0000001038397824ULL, 0x000fe400078e023bULL,
0x000000012d2d7824ULL, 0x000fe200018e0645ULL, 0x00000000162f7faeULL, 0x0005e8000b901c48ULL,
0x000000002c397faeULL, 0x0005e4000b901c48ULL, 0x00000008020a7824ULL, 0x000fe200078e00ffULL,
0x0000000166147810ULL, 0x004fe20007ffe0ffULL, 0xffffffffff087424ULL, 0x000fc400078e00ffULL,
0x000000000a0573c2ULL, 0x000ea200000e0000ULL, 0x0000006f1400720cULL, 0x000fe40003f06070ULL,
0x000000080a077812ULL, 0x040fe400078ec0ffULL, 0xffffffe00a097812ULL, 0x040fe400078ec0ffULL,
0x000000100a0c7812ULL, 0x000fce00078ec0ffULL, 0x0000000169148824ULL, 0x000fe400078e0214ULL,
0x00000004ff158424ULL, 0x000fe200078e00ffULL, 0xfffffff005057892ULL, 0x004fc6000f8ec03fULL,
0x0000640014148625ULL, 0x000fe200078e0015ULL, 0x0000f6b005067890ULL, 0x000fe2000fffe03fULL,
0x0000000907097210ULL, 0x000fc60007ffe00cULL, 0x0000000814088981ULL, 0x000528000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b000ff167f8cULL, 0x000ee2000c800405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60800092e7f8cULL, 0x0002a4000c80043fULL, 0x0000000000147805ULL, 0x004fc40000015200ULL,
0x00f60c0009077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fc4000780482fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c140c7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2c7824ULL, 0x000fe200000e0e15ULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc8000001142cULL,
0x0000000c07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e062cULL,
0x0000000207077819ULL, 0x000fc8000000120cULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c0009077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe4000780482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010444d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff627819ULL, 0x000fe20000011644ULL,
0x0000002002077824ULL, 0x000fe400078e00ffULL, 0xffffffffff797424ULL, 0x000fe200078e00ffULL,
0x000000704d4d7812ULL, 0x000fc400078ec0ffULL, 0xffffff8007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c62627812ULL, 0x000fc800078ec0ffULL, 0x0000000762077210ULL, 0x000fca0007ffe04dULL,
0x00f00000070f7984ULL, 0x000ea80000000800ULL, 0x00f20000072c7984ULL, 0x0002e20000000800ULL,
0x0000000e0f00720bULL, 0x004fe20003f1d000ULL, 0x000146d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x002fc800000e0100ULL, 0x0000ffff0c2e7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fc400078e000eULL, 0x0000001fff7b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff7a7424ULL, 0x000fca00078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000026a00720cULL, 0x000fe40003f05270ULL, 0x0000000e0f00720bULL, 0x000fe20003f54000ULL,
0x000146627f007947ULL, 0x000fd8000b800000ULL, 0x00000000002d7806ULL, 0x000fc400010e0100ULL,
0x0000008002158824ULL, 0x000fe200078e024dULL, 0x0000000e0f077209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099102d147816ULL, 0x000fe200000000ffULL,
0x00000001620c8824ULL, 0x000fca00078e0215ULL, 0x00f400070c008388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000e070c7221ULL, 0x002fe20000010100ULL, 0x000000ff2dff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c002f7308ULL, 0x000e640000000800ULL, 0x0000002f0b0b7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011644ULL,
0x000145927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c2f0c7589ULL, 0x0002a400000e0000ULL,
0x0000000c30307220ULL, 0x084fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c18187220ULL, 0x080fe20000410000ULL, 0x0000000c19197220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff002dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008440c7811ULL, 0x000fe200078ff0ffULL,
0x000144727f007947ULL, 0x000fea000b800000ULL, 0x00001f0c2f0c7589ULL, 0x00046400000e0000ULL,
0x0000000c32327220ULL, 0x086fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff2eff7812ULL, 0x000fe2000780602dULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x800000070f0f0221ULL, 0x000fe20000010000ULL,
0x00007610ff0c0816ULL, 0x000fc6000000000cULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00040308ULL, 0x000e640000000800ULL, 0x000000042c2c0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b2c0b7221ULL, 0x008fc20000010000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0xfffffff00a2c7812ULL, 0x000fca00078ec0ffULL,
0x00f6ac002c0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x000000140e2d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e0fULL, 0x003d09002d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc80000011415ULL,
0x0000002d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x000000020a0a7819ULL, 0x000fc80000001215ULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac002c0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100c0a7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000004ff05723eULL, 0x000fe400000010ffULL, 0x00000002ff0a7819ULL, 0x000fe40000011644ULL,
0x00005410050d7816ULL, 0x000fe20000000005ULL, 0x000140427f007947ULL, 0x000fea000b800000ULL,
0x00001f0a0d057589ULL, 0x0002a400000e0000ULL, 0x000000080a0c7810ULL, 0x000fe20007ffe0ffULL,
0x000140727f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100a0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e000dULL, 0x00002df000157802ULL, 0x000fc40000000f00ULL,
0x00014a4000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180a0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e000dULL,
0x00002e4000157802ULL, 0x000fc40000000f00ULL, 0x000149f000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000202537824ULL, 0x000fe200078e00ffULL,
0x00000007440d7812ULL, 0x00afe200078ec0ffULL, 0x0000020002407824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000844567812ULL, 0x000fc400078ec0ffULL,
0x00000004530f7812ULL, 0x000fe400078ec0ffULL, 0x000000080d527812ULL, 0x000fe400078ef844ULL,
0x0000000f440f7211ULL, 0x000fe400078fe0ffULL, 0xfffff80040407812ULL, 0x000fe200078ec0ffULL,
0x0000000852157824ULL, 0x040fe400078e00ffULL, 0x0000000152607824ULL, 0x000fca00078e020fULL,
0xfffffff8150f7812ULL, 0x000fca00078ee260ULL, 0x000000100f4c7824ULL, 0x000fc400078e0240ULL,
0x00000004020a7824ULL, 0x000fe200078e00ffULL, 0x00000004ff5d7819ULL, 0x000fe40000011644ULL,
0x0000000d56387212ULL, 0x000fe400078efcffULL, 0x000000040a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000b00046617811ULL, 0x000fe200078e68ffULL, 0x0000000838637824ULL, 0x000fe200078e00ffULL,
0x0000001056567812ULL, 0x000fe200078efe0dULL, 0x000000015d477824ULL, 0x000fe200078e020aULL,
0x009000004c0c783bULL, 0x004e620000000200ULL, 0x00000008380a7824ULL, 0x040fe200078e00ffULL,
0xfffffff853537812ULL, 0x000fe200078ec0ffULL, 0x0000000138397824ULL, 0x000fc400078e0247ULL,
0x0000000147477824ULL, 0x000fc600078e0256ULL, 0xfffffff80a417812ULL, 0x000fe200078ee239ULL,
0x00000008560a7824ULL, 0x000fe200078e00ffULL, 0x0000000239427810ULL, 0x000fc60007ffe0ffULL,
0x00000010413c7824ULL, 0x000fe200078e0261ULL, 0xfffffff863427812ULL, 0x000fe400078ee242ULL,
0xfffffff80a437812ULL, 0x000fe400078ee247ULL, 0x0000000247477810ULL, 0x000fe20007ffe0ffULL,
0x000000003c3c783bULL, 0x000ea20000004200ULL, 0x0000001042387824ULL, 0x100fe400078e0261ULL,
0x00000010432c7824ULL, 0x000fcc00078e0261ULL, 0x000000002c2c783bULL, 0x000fe20000004200ULL,
0x000000050c0c8231ULL, 0x082fe400003400ffULL, 0x000000050e0e8231ULL, 0x000fe400003400ffULL,
0x000000060d0d8231ULL, 0x080fe400003400ffULL, 0x000000060f0f8231ULL, 0x000fe200003400ffULL,
0x000001003d5e7824ULL, 0x004fe200078e00ffULL, 0x0000003d00457306ULL, 0x000fe20000009400ULL,
0x000001003c497824ULL, 0x000fc400078e00ffULL, 0x000100003c637824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x0000003d00647306ULL, 0x000e620000005400ULL, 0x00000018ff637819ULL, 0x000fce0000011463ULL,
0x0000005e005f7306ULL, 0x000ff00000209400ULL, 0x0000005e00687306ULL, 0x0004e20000205400ULL,
0x000000644500720bULL, 0x002fce0003f9d000ULL, 0x0000003c00157306ULL, 0x000fe20000009400ULL,
0x0000005e005e7245ULL, 0x004fce000020d400ULL, 0x0000003c003a7306ULL, 0x000e620000005400ULL,
0x000000685f00720bULL, 0x008fce0003fbd000ULL, 0x00000049003b7306ULL, 0x000fec0000209400ULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x0000004900487306ULL, 0x0004e20000205400ULL,
0x0000003a1500720bULL, 0x002fce0003f5d000ULL, 0x0000003d00557306ULL, 0x000e62000000d400ULL,
0x0000004900497245ULL, 0x004fce000020d400ULL, 0x0000003c00547306ULL, 0x000ea2000000d400ULL,
0x000000483b00720bULL, 0x008fe40003f7d000ULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x0000000155554812ULL, 0x002fc800078efcffULL, 0x0000003f005c7306ULL, 0x000fe20000009400ULL,
0x000000555e55723eULL, 0x000fca00000010ffULL, 0x0000000149493812ULL, 0x000fe400078efcffULL,
0x0000000154542812ULL, 0x004fe200078efcffULL, 0x0000003f00577306ULL, 0x000e620000005400ULL,
0x00000018ff5e7819ULL, 0x000fe4000001143cULL, 0x000000544954723eULL, 0x000fca00000010ffULL,
0x0000005e005f7306ULL, 0x000fe40000209400ULL, 0x000000540c30723cULL, 0x000b6c0000041830ULL,
0x0000005e006c7306ULL, 0x000ea20000205400ULL, 0x00000018ff547819ULL, 0x020fe2000001143dULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x000000575c00720bULL, 0x002fe20003f7d000ULL,
0x000001003e577824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000006300657306ULL, 0x000fe20000209400ULL, 0x00000018ff577819ULL, 0x000fce0000011457ULL,
0x0000006300687306ULL, 0x000e620000205400ULL, 0x0000006c5f00720bULL, 0x004fce0003fdd000ULL,
0x0000005400557306ULL, 0x000ff00000209400ULL, 0x00000054003c7306ULL, 0x0004e20000205400ULL,
0x000000686500720bULL, 0x002fce0003f9d000ULL, 0x0000003d00647306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x004fce000020d400ULL, 0x0000003d005f7306ULL, 0x0002a20000205400ULL,
0x0000003c5500720bULL, 0x008fe40003fbd000ULL, 0x00000063003c7245ULL, 0x000fe2000020d400ULL,
0x000001003f637824ULL, 0x000fc600078e00ffULL, 0x000000013c3c4812ULL, 0x000fe200078efcffULL,
0x00000057005c7306ULL, 0x000fe20000209400ULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x0000003d003d7245ULL, 0x002fc6000020d400ULL, 0x0000000154545812ULL, 0x000fe400078efcffULL,
0x0000005700657306ULL, 0x000e620000205400ULL, 0x0000005f6400720bULL, 0x004fe40003f9d000ULL,
0x0000005e005f7245ULL, 0x000fe4000020d400ULL, 0x00000063005e7245ULL, 0x000fe4000020d400ULL,
0x000000015f5f6812ULL, 0x000fe200078efcffULL, 0x0000003e005a7306ULL, 0x000fe60000009400ULL,
0x0000003c5f3c723eULL, 0x000fc600000010ffULL, 0x000000013d3d4812ULL, 0x000fe400078efcffULL,
0x0000003e005b7306ULL, 0x000ea20000005400ULL, 0x000000655c00720bULL, 0x002fe40003fdd000ULL,
0x0000003d543d723eULL, 0x000fca00000010ffULL, 0x0000006300647306ULL, 0x000fe40000209400ULL,
0x0000003c0c34723cULL, 0x000bec0000041834ULL, 0x0000006300657306ULL, 0x0002e20000205400ULL,
0x0000005b5a00720bULL, 0x004fe40003f5d000ULL, 0x00000057003d7245ULL, 0x020fc8000020d400ULL,
0x000000013d3d6812ULL, 0x000fe200078efcffULL, 0x0000003e00587306ULL, 0x000ea2000000d400ULL,
0x000100003e637824ULL, 0x002fca00078e00ffULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x0000003f00597306ULL, 0x000e62000000d400ULL, 0x000000656400720bULL, 0x008fce0003f9d000ULL,
0x00000038005a7306ULL, 0x000fe20000009400ULL, 0x0000000158582812ULL, 0x004fc800078efcffULL,
0x000000583d3c723eULL, 0x000fe400000010ffULL, 0x000000015e5e4812ULL, 0x000fe200078efcffULL,
0x00000038005b7306ULL, 0x000ea20000005400ULL, 0x0000000159593812ULL, 0x002fc800078efcffULL,
0x000000595e3d723eULL, 0x000fe400000010ffULL, 0x00000018ff597819ULL, 0x000fe2000001143eULL,
0x00000039005c7306ULL, 0x000fe20000009400ULL, 0x000100003f3e7824ULL, 0x000fc600078e00ffULL,
0x0000003c0c28723cULL, 0x000b640000041828ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000039005f7306ULL, 0x000e620000005400ULL, 0x0000005b5a00720bULL, 0x004fe40003f5d000ULL,
0x00000018ff3c7819ULL, 0x020fca000001143fULL, 0x0000006300647306ULL, 0x000ff00000209400ULL,
0x00000063005b7306ULL, 0x000ea20000205400ULL, 0x0000005f5c00720bULL, 0x002fe20003f7d000ULL,
0x00000100385f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x00000059005e7306ULL, 0x000ff00000209400ULL, 0x0000005900657306ULL, 0x000e620000205400ULL,
0x0000005b6400720bULL, 0x004fce0003f9d000ULL, 0x0000003c003d7306ULL, 0x000ff00000209400ULL,
0x0000003c00687306ULL, 0x000ea20000205400ULL, 0x000000655e00720bULL, 0x002fe40003fdd000ULL,
0x00000059005e7245ULL, 0x000fca000020d400ULL, 0x0000005f005b7306ULL, 0x000fec0000209400ULL,
0x000000015e5e6812ULL, 0x000fe400078efcffULL, 0x0000005f00647306ULL, 0x000e620000205400ULL,
0x000000683d00720bULL, 0x004fe40003fbd000ULL, 0x00000063003d7245ULL, 0x000fe2000020d400ULL,
0x0000010039637824ULL, 0x000fc600078e00ffULL, 0x000000013d3d4812ULL, 0x000fe200078efcffULL,
0x0000003e003f7306ULL, 0x000fe20000209400ULL, 0x00000018ff637819ULL, 0x000fce0000011463ULL,
0x0000003e005c7306ULL, 0x0004e20000205400ULL, 0x000000645b00720bULL, 0x002fce0003fdd000ULL,
0x0000006300657306ULL, 0x000fe20000209400ULL, 0x0000003e003e7245ULL, 0x004fe4000020d400ULL,
0x0000005c3f00720bULL, 0x008fca0003f9d000ULL, 0x0000006300647306ULL, 0x000e620000205400ULL,
0x0000003c003f7245ULL, 0x000fe4000020d400ULL, 0x0000003d5e3c723eULL, 0x000fe400000010ffULL,
0x000000013f3f5812ULL, 0x000fe400078efcffULL, 0x00000018ff5e7819ULL, 0x000fe20000011438ULL,
0x0000003800557306ULL, 0x000ea2000000d400ULL, 0x000000013e3e4812ULL, 0x000fce00078efcffULL,
0x0000003900547306ULL, 0x000ee2000000d400ULL, 0x000000646500720bULL, 0x002fe40003f9d000ULL,
0x0000003e3f3d723eULL, 0x000fe400000010ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001142cULL,
0x0000000155552812ULL, 0x004fe200078efcffULL, 0x0000003a00577306ULL, 0x000fe40000009400ULL,
0x0000003c0c24723cULL, 0x000be20000041824ULL, 0x0000000154543812ULL, 0x008fca00078efcffULL,
0x0000003a00587306ULL, 0x000e620000005400ULL, 0x0000005f003c7245ULL, 0x020fe4000020d400ULL,
0x00000063003d7245ULL, 0x000fe4000020d400ULL, 0x000000013c3c6812ULL, 0x000fe400078efcffULL,
0x000000013d3d4812ULL, 0x000fe200078efcffULL, 0x0000005e005f7306ULL, 0x000fe20000209400ULL,
0x000000553c3c723eULL, 0x000fe400000010ffULL, 0x000000543d3d723eULL, 0x000fc400000010ffULL,
0x00000018ff547819ULL, 0x000fc60000011439ULL, 0x0000005e00647306ULL, 0x000ea20000205400ULL,
0x000000585700720bULL, 0x002fe20003f9d000ULL, 0x0000003c0c20723cULL, 0x000b620000041820ULL,
0x0001000039577824ULL, 0x000fca00078e00ffULL, 0x0000005400557306ULL, 0x000fe20000209400ULL,
0x00010000383d7824ULL, 0x020fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff387819ULL, 0x000fe4000001143aULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000054003c7306ULL, 0x000e620000205400ULL, 0x000000645f00720bULL, 0x004fe40003f5d000ULL,
0x00000057005f7245ULL, 0x000fca000020d400ULL, 0x0000003d00637306ULL, 0x000ff00000209400ULL,
0x0000003d00587306ULL, 0x0004e20000205400ULL, 0x0000003c5500720bULL, 0x002fe40003fdd000ULL,
0x0000003d003c7245ULL, 0x000fca000020d400ULL, 0x0000003b005c7306ULL, 0x000fe20000009400ULL,
0x00000018ff3d7819ULL, 0x004fce000001143bULL, 0x0000003b00597306ULL, 0x000e620000005400ULL,
0x000000586300720bULL, 0x008fe20003fbd000ULL, 0x000001003a587824ULL, 0x000fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000005700657306ULL, 0x000fec0000209400ULL,
0x000000013c3c5812ULL, 0x000fe400078efcffULL, 0x0000005700647306ULL, 0x000ea20000205400ULL,
0x000000595c00720bULL, 0x002fc40003f7d000ULL, 0x0000005e00597245ULL, 0x000fe2000020d400ULL,
0x000100003a5e7824ULL, 0x000fc600078e00ffULL, 0x0000000159592812ULL, 0x000fe200078efcffULL,
0x0000003800397306ULL, 0x000fe20000209400ULL, 0x00000018ff5e7819ULL, 0x000fce000001145eULL,
0x0000003800687306ULL, 0x000e620000205400ULL, 0x000000646500720bULL, 0x004fce0003fbd000ULL,
0x00000058005c7306ULL, 0x000fec0000209400ULL, 0x000000015f5f5812ULL, 0x000fe400078efcffULL,
0x0000005800637306ULL, 0x000ea20000205400ULL, 0x000000683900720bULL, 0x002fe20003f5d000ULL,
0x000001003b397824ULL, 0x000fe200078e00ffULL, 0x0000005400687245ULL, 0x000fc8000020d400ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000003d00557306ULL, 0x000fe20000209400ULL,
0x0000000168686812ULL, 0x000fce00078efcffULL, 0x0000003d00647306ULL, 0x000e620000205400ULL,
0x000000635c00720bULL, 0x004fe20003fbd000ULL, 0x000100003b5c7824ULL, 0x000fe200078e00ffULL,
0x0000005800637245ULL, 0x000fe4000020d400ULL, 0x00000018ff587819ULL, 0x000fe4000001142eULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000003a005a7306ULL, 0x000eac000000d400ULL,
0x0000000163635812ULL, 0x000fc400078efcffULL, 0x0000003b005b7306ULL, 0x000ee2000000d400ULL,
0x000000645500720bULL, 0x002fe40003fdd000ULL, 0x00000018ff557819ULL, 0x000fca000001142dULL,
0x0000005e003a7306ULL, 0x000fe20000209400ULL, 0x000000015a5a4812ULL, 0x004fce00078efcffULL,
0x0000005e003b7306ULL, 0x000e620000205400ULL, 0x000000015b5b3812ULL, 0x008fce00078efcffULL,
0x0000003900577306ULL, 0x000ff00000209400ULL, 0x00000039006c7306ULL, 0x000ea20000205400ULL,
0x0000003b3a00720bULL, 0x002fe20003f9d000ULL, 0x00000008563a7824ULL, 0x000fe200078e00ffULL,
0x0000005f683b723eULL, 0x000fc400000010ffULL, 0x00000038005f7245ULL, 0x000fe4000020d400ULL,
0xfffffff83a477812ULL, 0x000fe200078ee247ULL, 0x0000005c00657306ULL, 0x000fe20000209400ULL,
0x0000003c593a723eULL, 0x000fe400000010ffULL, 0x0000005e003c7245ULL, 0x000fe4000020d400ULL,
0x000000015f5f2812ULL, 0x000fe400078efcffULL, 0x000000013c3c4812ULL, 0x000fe200078efcffULL,
0x0000005c00647306ULL, 0x000e620000205400ULL, 0x0000006c5700720bULL, 0x004fe20003fbd000ULL,
0x0000003a0c1c723cULL, 0x000b62000004181cULL, 0x0000003d005e7245ULL, 0x000fc4000020d400ULL,
0x0000003c5f3c723eULL, 0x000fe200000010ffULL, 0x00000004465f7824ULL, 0x000fe200078e025dULL,
0x0000005c003d7245ULL, 0x000fe2000020d400ULL, 0x0000002d00507306ULL, 0x000fe20000009400ULL,
0x000000015e5e6812ULL, 0x000fe200078efcffULL, 0x00000010473a7824ULL, 0x020fe200078e0261ULL,
0x000000025f5f7810ULL, 0x000fe20007ffe052ULL, 0x0000000852527824ULL, 0x000fe200078e00ffULL,
0x0000005a6338723eULL, 0x000fe200000010ffULL, 0x000001002c637824ULL, 0x000fe200078e00ffULL,
0x000000646500720bULL, 0x002fe20003f7d000ULL, 0x0000002d004e7306ULL, 0x000e620000005400ULL,
0x0000003900647245ULL, 0x000fc4000020d400ULL, 0xfffffff8525f7812ULL, 0x000fe400078ee25fULL,
0x0000000164645812ULL, 0x000fe400078efcffULL, 0x00000018ff5d7819ULL, 0x000fe20000011463ULL,
0x0000002c004a7306ULL, 0x000fe20000009400ULL, 0x0000005b6439723eULL, 0x000fe200000010ffULL,
0x000000105f407824ULL, 0x000fe200078e0240ULL, 0x00000018ff5b7819ULL, 0x000fe4000001142fULL,
0x000000013d3d3812ULL, 0x000fc600078efcffULL, 0x0000002c00517306ULL, 0x000ea20000005400ULL,
0x0000003d5e3d723eULL, 0x000fe200000010ffULL, 0x000000380c18723cULL, 0x040b620000041818ULL,
0x0000004e5000720bULL, 0x002fe20003f9d000ULL, 0x000000003a38783bULL, 0x020fe80000004200ULL,
0x0000002d004b7306ULL, 0x000e64000000d400ULL, 0x0000003c0c0c723cULL, 0x000b6c0000041810ULL,
0x0000002e000a7306ULL, 0x000fe20000009400ULL, 0x000001002d107824ULL, 0x020fe200078e00ffULL,
0x000000514a00720bULL, 0x004fc40003f5d000ULL, 0x0000005d004a7245ULL, 0x000fe4000020d400ULL,
0x00000018ff657819ULL, 0x000fe40000011410ULL, 0x0000002e00147306ULL, 0x000ea20000005400ULL,
0x009000004010783bULL, 0x000ee20000000200ULL, 0x000000014b4b4812ULL, 0x002fcc00078efcffULL,
0x0000002c004f7306ULL, 0x0002b0000000d400ULL, 0x0000005d003c7306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x002fe200078e00ffULL, 0x000000140a00720bULL, 0x004fe20003f9d000ULL,
0x000100002d147824ULL, 0x000fc600078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000005d003d7306ULL, 0x000e620000205400ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x000000014f4f2812ULL, 0x000fca00078efcffULL, 0x0000006500687306ULL, 0x000ff00000209400ULL,
0x0000006500717306ULL, 0x000ea20000205400ULL, 0x0000003d3c00720bULL, 0x002fe20003f7d000ULL,
0x0000000510108231ULL, 0x088fe200003400ffULL, 0x00000065003c7245ULL, 0x000fe2000020d400ULL,
0x0000000512128231ULL, 0x000fc400003400ffULL, 0x0000000611118231ULL, 0x080fe400003400ffULL,
0x0000002c000a7306ULL, 0x000fe20000209400ULL, 0x0000000613138231ULL, 0x000fca00003400ffULL,
0x000000014a4a3812ULL, 0x000fe400078efcffULL, 0x0000002c005d7306ULL, 0x0002e20000205400ULL,
0x000000716800720bULL, 0x004fe40003fbd000ULL, 0x0000004f4a4a723eULL, 0x000fca00000010ffULL,
0x0000002f00457306ULL, 0x000fe20000009400ULL, 0x0000002c002c7245ULL, 0x002fca000020d400ULL,
0x000000013c3c5812ULL, 0x000fe400078efcffULL, 0x0000002f00487306ULL, 0x000e620000005400ULL,
0x0000005d0a00720bULL, 0x008fe40003fdd000ULL, 0x0000004b3c4b723eULL, 0x000fca00000010ffULL,
0x0000003e003f7306ULL, 0x000fe40000209400ULL, 0x0000004a1030723cULL, 0x000b680000041830ULL,
0x000000012c2c6812ULL, 0x000fe400078efcffULL, 0x0000003e00547306ULL, 0x000ea20000205400ULL,
0x000000484500720bULL, 0x002fe20003f5d000ULL, 0x000001002e487824ULL, 0x000fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x00000014002d7306ULL, 0x000ff00000209400ULL,
0x0000001400687306ULL, 0x000e620000205400ULL, 0x000000543f00720bULL, 0x004fce0003f7d000ULL,
0x0000005500577306ULL, 0x000ff00000209400ULL, 0x0000005500567306ULL, 0x000ea20000205400ULL,
0x000000682d00720bULL, 0x002fe40003fdd000ULL, 0x0000003e002d7245ULL, 0x000fc4000020d400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143bULL, 0x000000012d2d3812ULL, 0x000fe200078efcffULL,
0x0000005800597306ULL, 0x000fe60000209400ULL, 0x0000002c2d2c723eULL, 0x000fca00000010ffULL,
0x00000058005a7306ULL, 0x000e620000205400ULL, 0x000000565700720bULL, 0x004fe20003f1d000ULL,
0x000001002f567824ULL, 0x000fe400078e00ffULL, 0x000100002e577824ULL, 0x000fc600078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x00000048003f7306ULL, 0x000fe20000209400ULL,
0x00000018ff577819ULL, 0x000fce0000011457ULL, 0x0000004800547306ULL, 0x0004e20000205400ULL,
0x0000005a5900720bULL, 0x002fe20003fbd000ULL, 0x000100002f597824ULL, 0x000fca00078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000002f00497306ULL, 0x0002e2000000d400ULL,
0x0000004800487245ULL, 0x004fce000020d400ULL, 0x00000056000a7306ULL, 0x000fe20000209400ULL,
0x00000014002f7245ULL, 0x002fc8000020d400ULL, 0x000000012f2f6812ULL, 0x000fe400078efcffULL,
0x000000543f00720bULL, 0x008fe20003fdd000ULL, 0x0000005600737306ULL, 0x0002a20000205400ULL,
0x0000005500547245ULL, 0x000fe4000020d400ULL, 0x0000005900557245ULL, 0x000fe4000020d400ULL,
0x0000000154540812ULL, 0x000fe400078efcffULL, 0x0000000149492812ULL, 0x000fe200078efcffULL,
0x0000005700457306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x002fc4000020d400ULL,
0x00000018ff3f7819ULL, 0x000fe40000011439ULL, 0x0000000148486812ULL, 0x000fe400078efcffULL,
0x0000002f542d723eULL, 0x000fe200000010ffULL, 0x0000005700717306ULL, 0x0002e20000205400ULL,
0x000000730a00720bULL, 0x004fe40003fdd000ULL, 0x00000018ff0a7819ULL, 0x000fca000001143aULL,
0x0000003800637306ULL, 0x000fe20000009400ULL, 0x0000005700577245ULL, 0x002fca000020d400ULL,
0x0000000156566812ULL, 0x000fe400078efcffULL, 0x00000038005f7306ULL, 0x000e620000005400ULL,
0x000000714500720bULL, 0x008fe40003fdd000ULL, 0x000000495649723eULL, 0x000fca00000010ffULL,
0x0000005900687306ULL, 0x000fec0000209400ULL, 0x0000000157576812ULL, 0x000fe400078efcffULL,
0x00000059006c7306ULL, 0x0004e20000205400ULL, 0x0000005f6300720bULL, 0x002fe20003f1d000ULL,
0x00000100385f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000002e00157306ULL, 0x000262000000d400ULL, 0x000001003a597824ULL, 0x004fca00078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000003900517306ULL, 0x000fe20000009400ULL,
0x0000006c6800720bULL, 0x008fe40003fdd000ULL, 0x00000018ff2e7819ULL, 0x002fc80000011438ULL,
0x0000002e00567245ULL, 0x000fe2000020d400ULL, 0x0000003900647306ULL, 0x000e620000005400ULL,
0x0000000115154812ULL, 0x000fc800078efcffULL, 0x000000154848723eULL, 0x000fe400000010ffULL,
0x0000000155556812ULL, 0x000fe200078efcffULL, 0x0000005b005c7306ULL, 0x000fe80000209400ULL,
0x000000481028723cULL, 0x000f680000041828ULL, 0x0000005b005e7306ULL, 0x0004e20000205400ULL,
0x000000645100720bULL, 0x002fe20003f9d000ULL, 0x0000010039647824ULL, 0x000fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000005f00717306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x004fce000020d400ULL, 0x0000005f00687306ULL, 0x000e620000205400ULL,
0x0000005e5c00720bULL, 0x008fe40003f7d000ULL, 0x00000058005c7245ULL, 0x000fe4000020d400ULL,
0x0000005f00587245ULL, 0x000fe4000020d400ULL, 0x000000015c5c5812ULL, 0x000fe200078efcffULL,
0x0000003a004e7306ULL, 0x000fec0000009400ULL, 0x000000015b5b3812ULL, 0x000fc400078efcffULL,
0x0000003a00507306ULL, 0x000ea20000005400ULL, 0x000000687100720bULL, 0x002fe40003fdd000ULL,
0x000000555b15723eULL, 0x000fca00000010ffULL, 0x0000003b004f7306ULL, 0x000fec0000009400ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x0000003b004b7306ULL, 0x020e620000005400ULL,
0x000000504e00720bULL, 0x004fe20003f5d000ULL, 0x0001000038507824ULL, 0x000fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000006400637306ULL, 0x000ff00000209400ULL,
0x00000064006c7306ULL, 0x000ea20000205400ULL, 0x0000004b4f00720bULL, 0x002fe20003fbd000ULL,
0x00010000394b7824ULL, 0x000fe200078e00ffULL, 0x00000064004f7245ULL, 0x000fca000020d400ULL,
0x0000002e005e7306ULL, 0x000ff00000209400ULL, 0x0000002e00657306ULL, 0x0002e20000205400ULL,
0x0000006c6300720bULL, 0x004fce0003fdd000ULL, 0x0000003800527306ULL, 0x000ea2000000d400ULL,
0x0000002c102c723cULL, 0x002b6a0000041834ULL, 0x000000014f4f6812ULL, 0x000fe400078efcffULL,
0x00000039003d7306ULL, 0x000e62000000d400ULL, 0x000000655e00720bULL, 0x008fe40003f7d000ULL,
0x00000018ff5e7819ULL, 0x000fe2000001144bULL, 0x000001003b4b7824ULL, 0x000fc800078e00ffULL,
0x0000005000387306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000000152520812ULL, 0x004fc600078efcffULL, 0x0000000156563812ULL, 0x000fe400078efcffULL,
0x0000005000397306ULL, 0x0004e20000205400ULL, 0x000000013d3d4812ULL, 0x002fe400078efcffULL,
0x000000525834723eULL, 0x020fe400000010ffULL, 0x0000003d4f35723eULL, 0x000fe400000010ffULL,
0x0000004b003d7245ULL, 0x000fe2000020d400ULL, 0x0000003f005a7306ULL, 0x000fe20000209400ULL,
0x0000005000507245ULL, 0x004fc6000020d400ULL, 0x000000341020723cULL, 0x000f680000041820ULL,
0x0000003f005d7306ULL, 0x0002a20000205400ULL, 0x000000393800720bULL, 0x008fe20003fdd000ULL,
0x000100003a387824ULL, 0x000fe400078e00ffULL, 0x000100003b397824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000005e00657306ULL, 0x000fe20000209400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003f003f7245ULL, 0x002fc6000020d400ULL,
0x0000000150506812ULL, 0x000fe400078efcffULL, 0x0000005e00687306ULL, 0x0002e20000205400ULL,
0x0000005d5a00720bULL, 0x004fce0003f1d000ULL, 0x00000059005f7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x002fca000020d400ULL, 0x000000013f3f0812ULL, 0x000fe400078efcffULL,
0x0000005900637306ULL, 0x0002a20000205400ULL, 0x000000686500720bULL, 0x008fce0003f9d000ULL,
0x0000000a00147306ULL, 0x000fe20000209400ULL, 0x0000005900597245ULL, 0x002fca000020d400ULL,
0x000000015e5e4812ULL, 0x000fe400078efcffULL, 0x0000000a00517306ULL, 0x000e620000205400ULL,
0x000000635f00720bULL, 0x004fce0003f7d000ULL, 0x0000003a003c7306ULL, 0x000eac000000d400ULL,
0x0000000159593812ULL, 0x000fe400078efcffULL, 0x0000003b004a7306ULL, 0x000ee2000000d400ULL,
0x000000511400720bULL, 0x002fe40003fdd000ULL, 0x000000575c14723eULL, 0x000fca00000010ffULL,
0x0000004b005a7306ULL, 0x000fe20000209400ULL, 0x000000013c3c2812ULL, 0x004fe200078efcffULL,
0x000000141024723cULL, 0x000b660000041824ULL, 0x0000003c593c723eULL, 0x000fc600000010ffULL,
0x0000004b005d7306ULL, 0x000e620000205400ULL, 0x000000505614723eULL, 0x020fe400000010ffULL,
0x0000005e3f15723eULL, 0x000fe400000010ffULL, 0x000000014a4a5812ULL, 0x008fc600078efcffULL,
0x00000038003a7306ULL, 0x000fe40000209400ULL, 0x00000014101c723cULL, 0x000b6c000004181cULL,
0x00000038003b7306ULL, 0x000ea20000205400ULL, 0x0000005d5a00720bULL, 0x002fe40003f1d000ULL,
0x0000000a00157245ULL, 0x020fc4000020d400ULL, 0x0000003800147245ULL, 0x000fe4000020d400ULL,
0x0000000115156812ULL, 0x000fe200078efcffULL, 0x0000003e00457306ULL, 0x000fec0000209400ULL,
0x000000013d3d0812ULL, 0x000fe400078efcffULL, 0x0000003e004e7306ULL, 0x0002e20000205400ULL,
0x0000003b3a00720bULL, 0x004fc40003f7d000ULL, 0x0000004a3d3d723eULL, 0x000fca00000010ffULL,
0x0000003900547306ULL, 0x000fe20000209400ULL, 0x0000003e003e7245ULL, 0x002fe2000020d400ULL,
0x0000003c1018723cULL, 0x000f680000041818ULL, 0x0000000114143812ULL, 0x000fe400078efcffULL,
0x0000003900377306ULL, 0x0002a20000205400ULL, 0x0000004e4500720bULL, 0x008fe40003f9d000ULL,
0x000000141514723eULL, 0x000fc400000010ffULL, 0x0000003900397245ULL, 0x002fd2000020d400ULL,
0x000000013e3e4812ULL, 0x000fe400078efcffULL, 0x000000375400720bULL, 0x004fda0003f5d000ULL,
0x0000000139392812ULL, 0x000fc800078efcffULL, 0x000000393e15723eULL, 0x000fce00000010ffULL,
0x000000141010723cULL, 0x000b6e000004180cULL, 0x0000f6c8460c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000000c0c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6880053ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x00000000000e7805ULL, 0x000fc80000015200ULL,
0x0000040003157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x00afc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140e357210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0fULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000003514147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040003157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010020d7824ULL, 0x000fe400078e00ffULL,
0x0000590008087a24ULL, 0x010fc600078e02ffULL, 0xffffffe00d0f7812ULL, 0x000fe200078ec0ffULL,
0x0000008008087824ULL, 0x000fc800078e00ffULL, 0x00000100000c7824ULL, 0x000fca00078e020fULL,
0x000000800c0c7810ULL, 0x000fc80007ffe0ffULL, 0x000000600c0a7812ULL, 0x000fca00078ec0ffULL,
0x00000001670f7824ULL, 0x000fe200078e020aULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000000c6d0a7217ULL, 0x000fe40007800000ULL, 0x000000100d0d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0e7819ULL, 0x000fe20000011644ULL, 0x000000010a0a7824ULL, 0x000fe200078e0a0cULL,
0x0000620008377a11ULL, 0x000fe400078a38ffULL, 0x000000040e157810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0c7824ULL, 0x000fe200078e020dULL, 0x0000000a0d0a7217ULL, 0x000fc40007800000ULL,
0x000000080e347810ULL, 0x000fe20007ffe0ffULL, 0x000000010c147824ULL, 0x000fe200078e0244ULL,
0x0000630008397a11ULL, 0x000fe200028f3cffULL, 0x000000010a0a7824ULL, 0x000fe400078e0a0dULL,
0x000000080c357824ULL, 0x040fe400078e00ffULL, 0x000000010c0c7824ULL, 0x000fe200078e020fULL,
0x0000000a0e00720cULL, 0x040fe40003f86070ULL, 0x0000000c0e0e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff835367812ULL, 0x000fe200078ee214ULL, 0x0000000115147824ULL, 0x140fe200078e020dULL,
0x0000000a3400720cULL, 0x0c0fe20003f46070ULL, 0x0000000134347824ULL, 0x100fe200078e020dULL,
0x0000000a1500720cULL, 0x080fe20003f66070ULL, 0x000000010e3a7824ULL, 0x040fe200078e020dULL,
0x0000000a0e00720cULL, 0x000fe20003f06070ULL, 0x00000001140d7824ULL, 0x140fe400078e0244ULL,
0x0000000814387824ULL, 0x000fe400078e00ffULL, 0x00000001340e7824ULL, 0x000fc400078e0244ULL,
0x0000000834157824ULL, 0x000fe200078e00ffULL, 0xfffffff8380a7812ULL, 0x000fe200078ee20dULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff815387812ULL, 0x000fe200078ee20eULL,
0x0000000114147824ULL, 0x100fe200078e020fULL, 0x0000004d0c0c7212ULL, 0x000fe200078efcffULL,
0x0000000134347824ULL, 0x000fe400078e020fULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000c370c7210ULL, 0x000fc60007fbe0ffULL, 0x000000013a0e7824ULL, 0x000fe200078e020fULL,
0x0000004d14147212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000004d34347212ULL, 0x000fc600078efcffULL,
0x000000010d0d7824ULL, 0x100fe200028e0639ULL, 0x0000003714147210ULL, 0x000fe20007fbe0ffULL,
0x000000013a3b7824ULL, 0x000fe200078e0244ULL, 0x0000004d0e0e7212ULL, 0x000fe200078efcffULL,
0x000000083a3a7824ULL, 0x000fe400078e00ffULL, 0x0000000115157824ULL, 0x000fe200028e0639ULL,
0x0000003734347210ULL, 0x080fe40007fbe0ffULL, 0x000000370e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001036377824ULL, 0x000fe200078e0261ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee23bULL,
0x0000000135357824ULL, 0x000fc400028e0639ULL, 0x000000010f0f7824ULL, 0x000fe200030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c377faeULL, 0x0003e2000e101c48ULL,
0x000000100a397824ULL, 0x100fe400078e0261ULL, 0x00000010383b7824ULL, 0x100fe400078e0261ULL,
0x000000103a3d7824ULL, 0x000fe200078e0261ULL, 0x0000000014397faeULL, 0x0003e8000d901c48ULL,
0x00000000343b7faeULL, 0x0003e8000d101c48ULL, 0x000000000e3d7faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x000000100d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000620008377a11ULL, 0x000fc400078038ffULL, 0x0000000d440d7211ULL, 0x000fe400078fe8ffULL,
0x0000630008397a11ULL, 0x000fe400000f3cffULL, 0x000000040d0c7810ULL, 0x040fe20007ffe0ffULL,
0x000000010d0a7824ULL, 0x040fe200078e0244ULL, 0x0000000c0d367810ULL, 0x040fe20007ffe0ffULL,
0x000000080d157824ULL, 0x040fe400078e00ffULL, 0x000000010d0e7824ULL, 0x100fe400078e020fULL,
0x000000010c147824ULL, 0x040fe200078e020fULL, 0xfffffff8150a7812ULL, 0x000fe200078ee20aULL,
0x000000080c387824ULL, 0x040fe200078e00ffULL, 0x000000080d157810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x000fc400078e0244ULL, 0x00000001360c7824ULL, 0x140fe400078e020fULL,
0x0000000115347824ULL, 0x040fe400078e020fULL, 0x0000000115357824ULL, 0x140fe400078e0244ULL,
0x00000008153a7824ULL, 0x000fe400078e00ffULL, 0x0000000136157824ULL, 0x040fe400078e0244ULL,
0x00000008363c7824ULL, 0x000fe200078e00ffULL, 0xfffffff838367812ULL, 0x000fe200078ee20dULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff83a387812ULL, 0x000fc400078ee235ULL,
0xfffffff83c3a7812ULL, 0x000fe200078ee215ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004d0e0e7212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000000e370e7210ULL, 0x040fe40007f1e0ffULL, 0x0000004d14147212ULL, 0x080fe200078efcffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000004d34347212ULL, 0x080fe400078efcffULL,
0x0000001437147210ULL, 0x000fe20007f5e0ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0639ULL,
0x0000004d0c0c7212ULL, 0x000fe200078efcffULL, 0x00000010383b7824ULL, 0x000fe200078e0261ULL,
0x0000003437347210ULL, 0x000fe20007f1e0ffULL, 0x0000000115157824ULL, 0x000fe200010e0639ULL,
0x0000000c370c7210ULL, 0x000fe20007f7e0ffULL, 0x000000100a377824ULL, 0x000fc400078e0261ULL,
0x0000000135357824ULL, 0x100fe400000e0639ULL, 0x000000010d0d7824ULL, 0x000fe200018e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e377faeULL, 0x0003e2000b901c48ULL,
0x0000001036397824ULL, 0x100fe400078e0261ULL, 0x000000103a3d7824ULL, 0x000fc600078e0261ULL,
0x0000000014397faeULL, 0x0003e8000b901c48ULL, 0x00000000343b7faeULL, 0x0003e8000b901c48ULL,
0x000000000c3d7faeULL, 0x0003e4000b901c48ULL, 0x00000008020a7824ULL, 0x000fca00078e00ffULL,
0xfffffff00a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000000a0573c2ULL, 0x000ee200000e0000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000f6a805057890ULL, 0x008fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000a0e7f8cULL, 0x0002e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f62800090c7f8cULL, 0x0002a4000c80043fULL,
0x0000000000147805ULL, 0x000fc40000015200ULL, 0x00f62c0009357984ULL, 0x000f240000000800ULL,
0x8000000035ff7812ULL, 0x014fe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003414377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x002fc80000011435ULL, 0x000000370a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x000000020a0a7819ULL, 0x000fc80000001235ULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c0009357984ULL, 0x000ea40000000800ULL, 0x8000000035ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020020a7824ULL, 0x002fca00078e00ffULL,
0xffffff800a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000804d0d7810ULL, 0x000fca0007ffe00aULL,
0x00000001620d7824ULL, 0x000fca00078e020dULL, 0x00f000000d0a7984ULL, 0x000e680000000800ULL,
0x00f200000d347984ULL, 0x0004e20000000800ULL, 0x000000070a00720bULL, 0x002fe20003f1d000ULL,
0x000112027f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c367812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff357424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000016a0d7810ULL, 0x000fe40007ffe0ffULL, 0x000000070a00720bULL, 0x000fe40003f54000ULL,
0x000000020d00720cULL, 0x000fe20003f05270ULL, 0x000111b27f007947ULL, 0x000fd4000b800000ULL,
0x00000000000d7806ULL, 0x000fc400010e0100ULL, 0x0000008002158824ULL, 0x000fe200078e024dULL,
0x000000070a0c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100d147816ULL, 0x000fe200000000ffULL, 0x0000000162158824ULL, 0x000fca00078e0215ULL,
0x00f4000c15008388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000070a0c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL,
0x000000070c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00387308ULL, 0x000e640000000800ULL, 0x000000380b0b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011644ULL,
0x000110d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c380c7589ULL, 0x0002a400000e0000ULL,
0x0000000c30307220ULL, 0x084fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c18187220ULL, 0x080fe20000410000ULL, 0x0000000c19197220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008440c7811ULL, 0x000fe200078ff0ffULL,
0x00010fb27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c380c7589ULL, 0x00046400000e0000ULL,
0x0000000c32327220ULL, 0x086fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe2000780600dULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x000000070a077209ULL, 0x000fd60007810000ULL,
0x800000070a0a0221ULL, 0x000fe20000010000ULL, 0x00007610ff350816ULL, 0x000fc60000000035ULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00040308ULL, 0x000e640000000800ULL,
0x0000000434340220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b340b7221ULL, 0x008fc20000010000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x00000008020a7824ULL, 0x000fca00078e00ffULL, 0xfffffff00a347812ULL, 0x000fca00078ec0ffULL,
0x00f6b40034157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x000000140c377210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e0dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc80000011415ULL,
0x000000370a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x000000020a0a7819ULL, 0x000fc80000001215ULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40034157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910350a7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f65270ULL, 0x0000012000003947ULL, 0x000fea0003800000ULL,
0x00000004ff05723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011644ULL,
0x00005410050a7816ULL, 0x000fe20000000005ULL, 0x00010b627f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0a057589ULL, 0x0002a400000e0000ULL, 0x000000080d0c7810ULL, 0x000fe20007ffe0ffULL,
0x00010b927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0a067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x0000649000157802ULL, 0x000fc40000000f00ULL,
0x000113a000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e000aULL,
0x000064e000157802ULL, 0x000fc40000000f00ULL, 0x0001135000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00001000610a7810ULL, 0x00afca0007ffe0ffULL, 0x00000010413c7824ULL, 0x100fe400078e020aULL,
0x0000001042387824ULL, 0x100fe400078e020aULL, 0x0000001043147824ULL, 0x000fe400078e020aULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x000000003838783bULL, 0x000fe80000004200ULL,
0x000000001414783bULL, 0x000fe20000004200ULL, 0x000001003c347824ULL, 0x002fe200078e00ffULL,
0x0000003c000c7306ULL, 0x004fe20000009400ULL, 0x000001003f737824ULL, 0x000fc600078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011434ULL, 0x000001003d347824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000003c000d7306ULL, 0x000e640000005400ULL,
0x00000018ff647819ULL, 0x000fe40000011434ULL, 0x009800004c34783bULL, 0x000ea80000000200ULL,
0x0000003d004e7306ULL, 0x000ff00000009400ULL, 0x0000003d00657306ULL, 0x000ee20000005400ULL,
0x0000000d0c00720bULL, 0x002fce0003f1d000ULL, 0x0000004500487306ULL, 0x000ff00000209400ULL,
0x0000004500637306ULL, 0x0003220000205400ULL, 0x000000654e00720bULL, 0x008fe40003f9d000ULL,
0x00000018ff4e7819ULL, 0x000fca000001143cULL, 0x0000006400687306ULL, 0x000fe20000209400ULL,
0x0000004500457245ULL, 0x002fe2000020d400ULL, 0x000000053434b231ULL, 0x084fe400003400ffULL,
0x000000053636b231ULL, 0x000fc800003400ffULL, 0x0000006400717306ULL, 0x0002a20000205400ULL,
0x000000634800720bULL, 0x010fe20003f5d000ULL, 0x000000063535b231ULL, 0x080fe400003400ffULL,
0x000000063737b231ULL, 0x000fc800003400ffULL, 0x0000003c004a7306ULL, 0x000722000000d400ULL,
0x0000006400647245ULL, 0x002fca000020d400ULL, 0x0000000145452812ULL, 0x000fe400078efcffULL,
0x0000003d004b7306ULL, 0x000e62000000d400ULL, 0x000000716800720bULL, 0x004fe20003fbd000ULL,
0x000100003c3c7824ULL, 0x008fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000003e00497306ULL, 0x000fe20000009400ULL, 0x000000014a4a0812ULL, 0x010fc800078efcffULL,
0x0000004a454a723eULL, 0x000fe400000010ffULL, 0x0000000164645812ULL, 0x000fe200078efcffULL,
0x0000003e00587306ULL, 0x000ea20000005400ULL, 0x000000014b4b4812ULL, 0x002fc800078efcffULL,
0x0000004b644b723eULL, 0x000fe400000010ffULL, 0x00000018ff647819ULL, 0x000fe2000001143dULL,
0x0000003c00657306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x0000004a3430723cULL, 0x000b640000041830ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000000584900720bULL, 0x004fe20003f9d000ULL, 0x0000003f005a7306ULL, 0x000ff00000009400ULL,
0x0000003c00587306ULL, 0x0002b00000205400ULL, 0x0000003f005f7306ULL, 0x000ee20000005400ULL,
0x0000003c003c7245ULL, 0x002fce000020d400ULL, 0x00000064004a7306ULL, 0x020fe20000209400ULL,
0x000000586500720bULL, 0x004fe20003fbd000ULL, 0x000001003e587824ULL, 0x000fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000006400717306ULL, 0x000e620000205400ULL,
0x0000005f5a00720bULL, 0x008fca0003f5d000ULL, 0x000000013c3c5812ULL, 0x000fe400078efcffULL,
0x0000004e00637306ULL, 0x000ff00000209400ULL, 0x0000004e00687306ULL, 0x000ea20000205400ULL,
0x000000714a00720bULL, 0x002fce0003f1d000ULL, 0x0000003d004a7306ULL, 0x000ff00000209400ULL,
0x0000003d005f7306ULL, 0x0002e20000205400ULL, 0x000000686300720bULL, 0x004fe40003fdd000ULL,
0x0000004e00637245ULL, 0x000fca000020d400ULL, 0x0000005800657306ULL, 0x000fe20000209400ULL,
0x0000003d003d7245ULL, 0x002fca000020d400ULL, 0x0000000163636812ULL, 0x000fe400078efcffULL,
0x0000005800687306ULL, 0x000e620000205400ULL, 0x0000005f4a00720bULL, 0x008fe40003fbd000ULL,
0x0000003c633c723eULL, 0x000fe400000010ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001143eULL,
0x00000018ff637819ULL, 0x000fe2000001143fULL, 0x00000073005a7306ULL, 0x000fec0000209400ULL,
0x000000013d3d5812ULL, 0x000fc400078efcffULL, 0x0000007300717306ULL, 0x0004e20000205400ULL,
0x000000686500720bULL, 0x002fe40003fdd000ULL, 0x0000006400687245ULL, 0x000fc8000020d400ULL,
0x0000000168680812ULL, 0x000fe200078efcffULL, 0x0000003e00567306ULL, 0x000322000000d400ULL,
0x0000007300737245ULL, 0x004fe4000020d400ULL, 0x0000003d683d723eULL, 0x000fca00000010ffULL,
0x0000003f00557306ULL, 0x000522000000d400ULL, 0x000100003e3e7824ULL, 0x002fe200078e00ffULL,
0x000000715a00720bULL, 0x008fe20003fbd000ULL, 0x0000003c342c723cULL, 0x000be6000004182cULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000005f004a7306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x004fe200078e00ffULL, 0x00000058003d7245ULL, 0x020fc4000020d400ULL,
0x0000000156564812ULL, 0x010fe400078efcffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005f00657306ULL, 0x0002a20000205400ULL, 0x000000013d3d6812ULL, 0x000fe400078efcffULL,
0x0000000155552812ULL, 0x000fe400078efcffULL, 0x0000000173735812ULL, 0x000fe400078efcffULL,
0x000000563d3c723eULL, 0x000fe200000010ffULL, 0x00000063005a7306ULL, 0x000fe20000209400ULL,
0x00000055733d723eULL, 0x000fc400000010ffULL, 0x0000005f005f7245ULL, 0x002fca000020d400ULL,
0x0000006300647306ULL, 0x000e620000205400ULL, 0x000000654a00720bULL, 0x004fe20003f5d000ULL,
0x0000003c3428723cULL, 0x000b6c0000041828ULL, 0x0000003e00687306ULL, 0x000fe20000209400ULL,
0x0000003e003c7245ULL, 0x020fe4000020d400ULL, 0x0000003f003d7245ULL, 0x000fc6000020d400ULL,
0x000000015f5f2812ULL, 0x000fe400078efcffULL, 0x0000003e00717306ULL, 0x000ea20000205400ULL,
0x000000645a00720bULL, 0x002fe40003fbd000ULL, 0x0000006300647245ULL, 0x000fca000020d400ULL,
0x0000003f006c7306ULL, 0x000fec0000209400ULL, 0x0000000164645812ULL, 0x000fe400078efcffULL,
0x0000003f00767306ULL, 0x000e620000205400ULL, 0x000000716800720bULL, 0x004fe20003f1d000ULL,
0x0000010038687824ULL, 0x000fc400078e00ffULL, 0x0001000039717824ULL, 0x000fc600078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x00000039005d7306ULL, 0x000fe20000009400ULL,
0x00000018ff717819ULL, 0x000fca0000011471ULL, 0x000000013c3c0812ULL, 0x000fe400078efcffULL,
0x000000766c00720bULL, 0x002fe20003f9d000ULL, 0x00000100396c7824ULL, 0x000fe200078e00ffULL,
0x0000003c5f3c723eULL, 0x000fe200000010ffULL, 0x00000039005e7306ULL, 0x000e620000005400ULL,
0x00000018ff5f7819ULL, 0x000fe40000011438ULL, 0x00000018ff6c7819ULL, 0x000fca000001146cULL,
0x0000006c003f7306ULL, 0x000fe40000209400ULL, 0x000000013d3d4812ULL, 0x000fc800078efcffULL,
0x0000003d643d723eULL, 0x000fe400000010ffULL, 0x00000038005b7306ULL, 0x000fe20000009400ULL,
0x0000005e5d00720bULL, 0x002fe40003f9d000ULL, 0x00000018ff647819ULL, 0x000fe40000011439ULL,
0x0000003c3424723cULL, 0x000b660000041824ULL, 0x0000006c003c7306ULL, 0x0202a80000205400ULL,
0x00000010473d7824ULL, 0x000fc800078e020aULL, 0x00000038005c7306ULL, 0x000ee20000005400ULL,
0x0000006c006c7245ULL, 0x002fce000020d400ULL, 0x00000068003e7306ULL, 0x000fe20000209400ULL,
0x0000003c3f00720bULL, 0x004fce0003fbd000ULL, 0x0000006800657306ULL, 0x000e620000205400ULL,
0x0000005c5b00720bULL, 0x008fca0003f1d000ULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x0000003900577306ULL, 0x000eb0000000d400ULL, 0x0000003800597306ULL, 0x000722000000d400ULL,
0x000000653e00720bULL, 0x002fe20003f5d000ULL, 0x0001000038657824ULL, 0x000fe200078e00ffULL,
0x000000003d3c783bULL, 0x000e680000004200ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000005f00637306ULL, 0x000fe20000209400ULL, 0x0000000157574812ULL, 0x004fc400078efcffULL,
0x0000006800387245ULL, 0x008fe4000020d400ULL, 0x000000576c39723eULL, 0x000fe400000010ffULL,
0x0000000138382812ULL, 0x000fe200078efcffULL, 0x0000005f00737306ULL, 0x0004e20000205400ULL,
0x0000000159590812ULL, 0x010fc800078efcffULL, 0x000000593838723eULL, 0x000fc600000010ffULL,
0x00000064005d7306ULL, 0x000fe20000209400ULL, 0x0000005f005f7245ULL, 0x004fc6000020d400ULL,
0x000000383420723cULL, 0x000b680000041820ULL, 0x0000006400767306ULL, 0x000ea20000205400ULL,
0x000000736300720bULL, 0x008fe20003f5d000ULL, 0x000001003a637824ULL, 0x000fe200078e00ffULL,
0x0000007100397245ULL, 0x020fe2000020d400ULL, 0x000001003b387824ULL, 0x000fc600078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x00000065005e7306ULL, 0x000fec0000209400ULL,
0x000000015f5f2812ULL, 0x000fe400078efcffULL, 0x0000006500777306ULL, 0x000ee20000205400ULL,
0x000000765d00720bULL, 0x004fc40003fbd000ULL, 0x0000006400767245ULL, 0x000fe4000020d400ULL,
0x00000018ff647819ULL, 0x000fe40000011438ULL, 0x0000006500387245ULL, 0x000fe2000020d400ULL,
0x0000007100687306ULL, 0x000fec0000209400ULL, 0x0000000176765812ULL, 0x000fc400078efcffULL,
0x0000007100577306ULL, 0x000ea20000205400ULL, 0x000000775e00720bULL, 0x008fce0003f1d000ULL,
0x0000003b00537306ULL, 0x000fec0000009400ULL, 0x0000000138380812ULL, 0x000fe400078efcffULL,
0x000000576800720bULL, 0x004fe20003f9d000ULL, 0x0000003b00527306ULL, 0x000ea20000005400ULL,
0x000000385f38723eULL, 0x000fce00000010ffULL, 0x0000006400657306ULL, 0x000fe80000209400ULL,
0x0000000139394812ULL, 0x000fc800078efcffULL, 0x0000006400717306ULL, 0x000ee20000205400ULL,
0x000000397639723eULL, 0x000fe400000010ffULL, 0x000000525300720bULL, 0x004fe40003fbd000ULL,
0x00000018ff527819ULL, 0x000fe4000001143aULL, 0x00000018ff537819ULL, 0x000fe2000001143bULL,
0x0000006300687306ULL, 0x000fe20000209400ULL, 0x00000038341c723cULL, 0x000b6e000004181cULL,
0x00000063006c7306ULL, 0x0005220000205400ULL, 0x000000716500720bULL, 0x008fe20003fdd000ULL,
0x000100003a657824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000003a00517306ULL, 0x000fe20000009400ULL, 0x0000006300637245ULL, 0x004fce000020d400ULL,
0x0000003a004f7306ULL, 0x000ea20000005400ULL, 0x0000006c6800720bULL, 0x010fe20003f9d000ULL,
0x000100003b687824ULL, 0x000fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000005200387306ULL, 0x020fec0000209400ULL, 0x0000000163634812ULL, 0x000fe400078efcffULL,
0x0000005200397306ULL, 0x000ee20000205400ULL, 0x0000004f5100720bULL, 0x004fce0003f5d000ULL,
0x0000003a00547306ULL, 0x000eb0000000d400ULL, 0x0000003b00507306ULL, 0x000f22000000d400ULL,
0x000000393800720bULL, 0x008fe40003f1d000ULL, 0x0000006400397245ULL, 0x000fc8000020d400ULL,
0x0000000139396812ULL, 0x000fe200078efcffULL, 0x0000006500717306ULL, 0x000fe20000209400ULL,
0x0000000154542812ULL, 0x004fc800078efcffULL, 0x000000546338723eULL, 0x000fe400000010ffULL,
0x00000018ff547819ULL, 0x000fe20000011414ULL, 0x0000006500737306ULL, 0x000ea20000205400ULL,
0x0000000150505812ULL, 0x010fc800078efcffULL, 0x000000503939723eULL, 0x000fc600000010ffULL,
0x0000005300517306ULL, 0x000fe80000209400ULL, 0x000000383418723cULL, 0x000b680000041818ULL,
0x00000053006c7306ULL, 0x0007220000205400ULL, 0x000000737100720bULL, 0x004fe40003f5d000ULL,
0x0000005200397245ULL, 0x020fc4000020d400ULL, 0x0000006500387245ULL, 0x000fe4000020d400ULL,
0x0000006800527245ULL, 0x000fe2000020d400ULL, 0x00000068003b7306ULL, 0x000fe20000209400ULL,
0x0000005300537245ULL, 0x008fe4000020d400ULL, 0x0000000139390812ULL, 0x000fc600078efcffULL,
0x0000000138382812ULL, 0x000fe400078efcffULL, 0x0000006800767306ULL, 0x000ea20000205400ULL,
0x0000006c5100720bULL, 0x010fe40003fbd000ULL, 0x000000383938723eULL, 0x000fca00000010ffULL,
0x00000014000d7306ULL, 0x000fec0000009400ULL, 0x0000000153535812ULL, 0x000fe400078efcffULL,
0x000000763b00720bULL, 0x004fe20003f9d000ULL, 0x0000001400487306ULL, 0x000eb00000005400ULL,
0x0000005400687306ULL, 0x000fe80000209400ULL, 0x0000000152524812ULL, 0x000fc800078efcffULL,
0x000000525339723eULL, 0x000fe200000010ffULL, 0x0000005400657306ULL, 0x0007e20000205400ULL,
0x000000480d00720bULL, 0x004fe20003f9d000ULL, 0x00000100150d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011415ULL, 0x00000018ff487819ULL, 0x000fe20000011417ULL,
0x000000383434723cULL, 0x000b620000041810ULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000001700567306ULL, 0x000fe20000009400ULL, 0x0000005400547245ULL, 0x008fc8000020d400ULL,
0x0000010014107824ULL, 0x020fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011416ULL,
0x00000017005a7306ULL, 0x000ea40000005400ULL, 0x00000018ff717819ULL, 0x000fcc0000011410ULL,
0x0000007100117306ULL, 0x000ff00000209400ULL, 0x0000007100127306ULL, 0x0007220000205400ULL,
0x0000005a5600720bULL, 0x004fe20003fbd000ULL, 0x00010000145a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x00000014000c7306ULL, 0x000ea2000000d400ULL,
0x0000007100717245ULL, 0x008fe4000020d400ULL, 0x000000121100720bULL, 0x010fca0003f5d000ULL,
0x0000000d00107306ULL, 0x000fe20000209400ULL, 0x000000010c0c4812ULL, 0x004fce00078efcffULL,
0x0000000d00117306ULL, 0x000ea20000205400ULL, 0x0000000171712812ULL, 0x000fe400078efcffULL,
0x000000656800720bULL, 0x000fca0003f5d000ULL, 0x0000003c005b7306ULL, 0x002fe20000009400ULL,
0x0000000d00687245ULL, 0x000fe4000020d400ULL, 0x0000000c710c723eULL, 0x000fca00000010ffULL,
0x0000003c005c7306ULL, 0x000e620000005400ULL, 0x000000111000720bULL, 0x004fe40003f9d000ULL,
0x009800004010783bULL, 0x0004e20000000200ULL, 0x0000000154542812ULL, 0x000fc800078efcffULL,
0x0000001500457306ULL, 0x000fe20000009400ULL, 0x00000018ff407819ULL, 0x004fca000001143dULL,
0x0000000168684812ULL, 0x000fe400078efcffULL, 0x00000015004b7306ULL, 0x000ea20000005400ULL,
0x0000005c5b00720bULL, 0x002fe20003f5d000ULL, 0x00000100165c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000001500497306ULL, 0x000330000000d400ULL,
0x0000005a00147306ULL, 0x000fe20000209400ULL, 0x0000004b4500720bULL, 0x004fe20003f1d000ULL,
0x0001000015157824ULL, 0x002fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fc8000001143cULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000005a005b7306ULL, 0x0002a20000205400ULL,
0x000000051010b231ULL, 0x088fe400003400ffULL, 0x000000051212b231ULL, 0x000fc600003400ffULL,
0x0000000149490812ULL, 0x010fe200078efcffULL, 0x000000061111b231ULL, 0x080fe200003400ffULL,
0x0000003d005d7306ULL, 0x000fe20000009400ULL, 0x0000005a005a7245ULL, 0x002fe2000020d400ULL,
0x000000061313b231ULL, 0x000fe200003400ffULL, 0x00000049680d723eULL, 0x000fca00000010ffULL,
0x0000003d005e7306ULL, 0x000e620000005400ULL, 0x0000005b1400720bULL, 0x004fe20003f1d000ULL,
0x0000000c1030723cULL, 0x000b6c0000041830ULL, 0x0000001500147306ULL, 0x000fe20000209400ULL,
0x00000015000d7245ULL, 0x020fe2000020d400ULL, 0x00010000160c7824ULL, 0x000fc800078e00ffULL,
0x000000015a5a0812ULL, 0x000fe400078efcffULL, 0x00000015005b7306ULL, 0x000ea20000205400ULL,
0x0000005e5d00720bULL, 0x002fe20003f9d000ULL, 0x00000100175d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fc8000001140cULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000005c00497306ULL, 0x000ff00000209400ULL, 0x0000005c005e7306ULL, 0x0002e20000205400ULL,
0x0000005b1400720bULL, 0x004fc40003f1d000ULL, 0x00000018ff147819ULL, 0x000fca000001143eULL,
0x00000016004e7306ULL, 0x000fe20000009400ULL, 0x0000005c005c7245ULL, 0x002fca000020d400ULL,
0x000000010d0d0812ULL, 0x000fe400078efcffULL, 0x0000001600587306ULL, 0x000e620000005400ULL,
0x0000005e4900720bULL, 0x008fe40003f1d000ULL, 0x00000052005e7245ULL, 0x000fca000020d400ULL,
0x00000016004a7306ULL, 0x000eac000000d400ULL, 0x000000015c5c0812ULL, 0x000fe400078efcffULL,
0x0000005d00157306ULL, 0x000fe20000209400ULL, 0x000000584e00720bULL, 0x002fce0003fdd000ULL,
0x0000005d00167306ULL, 0x0002ec0000205400ULL, 0x000000014a4a6812ULL, 0x004fe400078efcffULL,
0x0000000c00657306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x002fe4000020d400ULL,
0x0000004a5c4a723eULL, 0x000fca00000010ffULL, 0x0000000c00687306ULL, 0x000e620000205400ULL,
0x000000161500720bULL, 0x008fe20003f1d000ULL, 0x0001000017167824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fc8000001143fULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000005200537306ULL, 0x000fec0000209400ULL, 0x000000015d5d0812ULL, 0x000fe400078efcffULL,
0x00000052006c7306ULL, 0x000ea20000205400ULL, 0x000000686500720bULL, 0x002fe20003fdd000ULL,
0x000100003c657824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000003f00507306ULL, 0x000ff00000009400ULL, 0x0000003f00517306ULL, 0x000e620000005400ULL,
0x0000006c5300720bULL, 0x004fce0003f7d000ULL, 0x0000001700557306ULL, 0x000eac000000d400ULL,
0x000000015e5e3812ULL, 0x000fe400078efcffULL, 0x0000003800397306ULL, 0x000fe20000209400ULL,
0x000000515000720bULL, 0x002fe20003f1d000ULL, 0x000001003c507824ULL, 0x000fe200078e00ffULL,
0x0000003800517245ULL, 0x000fc4000020d400ULL, 0x0000000d5e0d723eULL, 0x000fc600000010ffULL,
0x0000003800637306ULL, 0x000e620000205400ULL, 0x0000000155555812ULL, 0x004fce00078efcffULL,
0x0000003e005f7306ULL, 0x000ff00000009400ULL, 0x0000003e004f7306ULL, 0x000ea20000005400ULL,
0x000000633900720bULL, 0x002fe40003fbd000ULL, 0x00000018ff637819ULL, 0x000fc40000011450ULL,
0x0000000c00507245ULL, 0x000fe2000020d400ULL, 0x000001003d0c7824ULL, 0x000fe200078e00ffULL,
0x0000001600397245ULL, 0x000fe2000020d400ULL, 0x0000001600177306ULL, 0x000fe20000209400ULL,
0x0000000150506812ULL, 0x000fe400078efcffULL, 0x00000018ff0c7819ULL, 0x000fc6000001140cULL,
0x0000000151515812ULL, 0x000fe400078efcffULL, 0x0000001600687306ULL, 0x000e620000205400ULL,
0x0000004f5f00720bULL, 0x004fce0003f7d000ULL, 0x0000004800647306ULL, 0x000ff00000209400ULL,
0x00000048004b7306ULL, 0x0004e20000205400ULL, 0x000000681700720bULL, 0x002fce0003fdd000ULL,
0x00000063005f7306ULL, 0x000fe20000209400ULL, 0x0000004800487245ULL, 0x004fca000020d400ULL,
0x0000000139396812ULL, 0x000fe400078efcffULL, 0x0000006300687306ULL, 0x000e620000205400ULL,
0x0000004b6400720bULL, 0x008fce0003fbd000ULL, 0x00000045004e7306ULL, 0x000fec0000209400ULL,
0x0000000148485812ULL, 0x000fe400078efcffULL, 0x0000004500567306ULL, 0x0004e20000205400ULL,
0x000000685f00720bULL, 0x002fe20003fdd000ULL, 0x000100003d5f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000000c00387306ULL, 0x000fe20000209400ULL,
0x0000004500457245ULL, 0x004fce000020d400ULL, 0x0000000c004b7306ULL, 0x000e620000205400ULL,
0x000000564e00720bULL, 0x008fe20003fbd000ULL, 0x000001003e4e7824ULL, 0x000fe200078e00ffULL,
0x0000006300567245ULL, 0x000fc8000020d400ULL, 0x0000000156566812ULL, 0x000fe200078efcffULL,
0x0000003d00577306ULL, 0x000ea2000000d400ULL, 0x00000018ff4e7819ULL, 0x000fca000001144eULL,
0x0000000145455812ULL, 0x000fe400078efcffULL, 0x0000006500167306ULL, 0x000fe20000209400ULL,
0x0000004b3800720bULL, 0x002fe20003fdd000ULL, 0x000001003f387824ULL, 0x000fe200078e00ffULL,
0x000000555d4b723eULL, 0x000fc800000010ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x00000065003d7306ULL, 0x000fe20000205400ULL, 0x0000000157574812ULL, 0x004fe200078efcffULL,
0x0000004a1028723cULL, 0x000f6c0000041828ULL, 0x0000005f00177306ULL, 0x000ff00000209400ULL,
0x0000005f00687306ULL, 0x0002b00000205400ULL, 0x0000003c00597306ULL, 0x000722000000d400ULL,
0x0000005f005f7245ULL, 0x002fce000020d400ULL, 0x0000004000587306ULL, 0x000fe20000209400ULL,
0x0000000c003c7245ULL, 0x008fe4000020d400ULL, 0x000000681700720bULL, 0x004fe20003f9d000ULL,
0x000100003f177824ULL, 0x000fe200078e00ffULL, 0x000000013c3c6812ULL, 0x000fe400078efcffULL,
0x0000003d1600720bULL, 0x000fe20003fdd000ULL, 0x00000040005b7306ULL, 0x0002a20000205400ULL,
0x000100003e167824ULL, 0x000fe200078e00ffULL, 0x0000005a540c723eULL, 0x000fc400000010ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000004e00637306ULL, 0x000fe20000209400ULL, 0x0000000159592812ULL, 0x010fe200078efcffULL,
0x0000000c102c723cULL, 0x000b62000004182cULL, 0x0000004000407245ULL, 0x002fe4000020d400ULL,
0x000000015f5f4812ULL, 0x000fe400078efcffULL, 0x000000595656723eULL, 0x000fe200000010ffULL,
0x0000004e00647306ULL, 0x000e620000205400ULL, 0x0000005b5800720bULL, 0x004fc40003f5d000ULL,
0x00000050510c723eULL, 0x020fe400000010ffULL, 0x00000039480d723eULL, 0x000fe400000010ffULL,
0x0000004e00397245ULL, 0x000fe2000020d400ULL, 0x0000003e003a7306ULL, 0x000ea2000000d400ULL,
0x000000573c57723eULL, 0x000fc600000010ffULL, 0x0000000c1024723cULL, 0x040b640000041824ULL,
0x0000000140402812ULL, 0x000fe400078efcffULL, 0x0000001400537306ULL, 0x000fe20000209400ULL,
0x000000646300720bULL, 0x002fe40003fbd000ULL, 0x0000005f400d723eULL, 0x020fe200000010ffULL,
0x000000561020723cULL, 0x000f680000041820ULL, 0x0000001400527306ULL, 0x000fe20000205400ULL,
0x000000013a3a3812ULL, 0x004fca00078efcffULL, 0x0000000139395812ULL, 0x000fe400078efcffULL,
0x0000003800587306ULL, 0x000fe40000209400ULL, 0x0000003a393a723eULL, 0x000fcc00000010ffULL,
0x00000038005b7306ULL, 0x0002b00000205400ULL, 0x00000016003d7306ULL, 0x000fe20000209400ULL,
0x0000003800387245ULL, 0x002fce000020d400ULL, 0x00000016003e7306ULL, 0x000e620000205400ULL,
0x0000005b5800720bULL, 0x004fce0003f5d000ULL, 0x0000001500497306ULL, 0x000fec0000209400ULL,
0x0000000138382812ULL, 0x000fe400078efcffULL, 0x00000015004f7306ULL, 0x000ea20000205400ULL,
0x0000003e3d00720bULL, 0x002fce0003fbd000ULL, 0x0000001700547306ULL, 0x000ff00000209400ULL,
0x0000001700517306ULL, 0x0002e20000205400ULL, 0x0000004f4900720bULL, 0x004fce0003f9d000ULL,
0x0000003f003b7306ULL, 0x000522000000d400ULL, 0x0000001700177245ULL, 0x002fe4000020d400ULL,
0x000000515400720bULL, 0x008fe40003f7d000ULL, 0x00000065003f7245ULL, 0x004fc8000020d400ULL,
0x000000013f3f6812ULL, 0x000fe400078efcffULL, 0x000000525300720bULL, 0x000fe40003fdd000ULL,
0x0000003f450c723eULL, 0x000fe400000010ffULL, 0x000000013b3b0812ULL, 0x010fe400078efcffULL,
0x0000000117173812ULL, 0x000fe400078efcffULL, 0x0000003b383b723eULL, 0x000fe200000010ffULL,
0x0000000c101c723cULL, 0x040b6e000004181cULL, 0x00000014000d7245ULL, 0x020fe2000020d400ULL,
0x0000003a1018723cULL, 0x000f620000041818ULL, 0x00000016000c7245ULL, 0x000fc4000020d400ULL,
0x0000001500147245ULL, 0x000fe4000020d400ULL, 0x000000010d0d6812ULL, 0x000fe400078efcffULL,
0x000000010c0c5812ULL, 0x000fe400078efcffULL, 0x0000000114144812ULL, 0x000fe400078efcffULL,
0x0000000c0d0c723eULL, 0x000fe400000010ffULL, 0x00000017140d723eULL, 0x000fe200000010ffULL,
0x0000000202147824ULL, 0x000fca00078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ec0ffULL,
0x0000000c1010723cULL, 0x000b6e0000041834ULL, 0x0000f6c8460c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000000c0c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6900014ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff347224ULL, 0x000fc600078e00ffULL, 0x0000000000147805ULL, 0x004fc80000015200ULL,
0x0000040003177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040003177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000100000d7824ULL, 0x000fca00078e0278ULL,
0x000000c00d147810ULL, 0x000fc80007ffe0ffULL, 0x00000060140c7812ULL, 0x000fca00078ec0ffULL,
0x0000000167157824ULL, 0x000fe200078e020cULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x000000146d0c7217ULL, 0x000fe20007800000ULL, 0x0000001002167824ULL, 0x000fe200078e00ffULL,
0x00006200083b7a11ULL, 0x000fc600078a38ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a14ULL,
0x0000001016177812ULL, 0x000fe400078ec0ffULL, 0x00000003ff147819ULL, 0x000fe40000011644ULL,
0x0000000c170c7217ULL, 0x000fe40007800000ULL, 0x0000000414167810ULL, 0x040fe40007ffe0ffULL,
0x0000000814357810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x100fe200078e0a17ULL,
0x0000000c14367810ULL, 0x000fe20007ffe0ffULL, 0x0000000116347824ULL, 0x000fe200078e0217ULL,
0x00006300083d7a11ULL, 0x000fc400028f3cffULL, 0x0000000c1400720cULL, 0x0c0fe20003f86070ULL,
0x0000000114147824ULL, 0x100fe200078e0217ULL, 0x0000000c1600720cULL, 0x080fe20003f66070ULL,
0x0000000136387824ULL, 0x000fe200078e0217ULL, 0x0000000c3500720cULL, 0x0c0fe20003f46070ULL,
0x0000000114167824ULL, 0x000fe200078e0215ULL, 0x0000000c3600720cULL, 0x000fe20003f06070ULL,
0x0000000135357824ULL, 0x000fe400078e0217ULL, 0x00000001140c7824ULL, 0x040fe400078e0244ULL,
0x0000000814397824ULL, 0x000fc400078e00ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee20cULL, 0x0000000134147824ULL, 0x100fe200078e0244ULL,
0x0000004d16167212ULL, 0x000fe200078efcffULL, 0x00000008343f7824ULL, 0x040fe400078e00ffULL,
0x0000000134347824ULL, 0x100fe200078e0215ULL, 0x0000003b16167210ULL, 0x000fe20007fbe0ffULL,
0x00000001350c7824ULL, 0x000fe200078e0244ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL,
0x0000000835457824ULL, 0x040fe400078e00ffULL, 0x0000000135367824ULL, 0x000fc400078e0215ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fc600078ee20cULL,
0x0000000138147824ULL, 0x000fe200078e0215ULL, 0x0000004d34347212ULL, 0x000fe200078efcffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004d36367212ULL, 0x000fc600078efcffULL, 0x0000000117177824ULL, 0x100fe200028e063dULL,
0x0000003b34347210ULL, 0x000fe20007fbe0ffULL, 0x0000000138087824ULL, 0x000fe200078e0244ULL,
0x0000004d14147212ULL, 0x000fe200078efcffULL, 0x0000000838497824ULL, 0x000fe400078e00ffULL,
0x0000000135357824ULL, 0x100fe200028e063dULL, 0x0000003b36367210ULL, 0x080fe20007fbe0ffULL,
0x0000001039397824ULL, 0x100fe200078e020aULL, 0x0000003b14147210ULL, 0x000fe20007fde0ffULL,
0x000000103f3b7824ULL, 0x000fe200078e020aULL, 0xfffffff849497812ULL, 0x000fe200078ee208ULL,
0x0000000137377824ULL, 0x100fe200028e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016397faeULL, 0x0003e2000e101c48ULL, 0x0000000115157824ULL, 0x000fc400030e063dULL,
0x00000010453d7824ULL, 0x100fe200078e020aULL, 0x00000000343b7faeULL, 0x0003e2000d901c48ULL,
0x00000010493f7824ULL, 0x000fc600078e020aULL, 0x00000000363d7faeULL, 0x0003e8000d101c48ULL,
0x00000000143f7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010020c7824ULL, 0x000fe200078e00ffULL, 0x00006200083b7a11ULL, 0x000fc800078038ffULL,
0x000000100c177812ULL, 0x000fe400078ec0ffULL, 0x00006300083d7a11ULL, 0x000fe400000f3cffULL,
0x0000001744177211ULL, 0x000fc800078fe8ffULL, 0x0000000417147810ULL, 0x040fe20007ffe0ffULL,
0x00000001170c7824ULL, 0x040fe200078e0244ULL, 0x0000000817357810ULL, 0x040fe20007ffe0ffULL,
0x0000000817397824ULL, 0x040fe400078e00ffULL, 0x0000000117347824ULL, 0x140fe200078e0215ULL,
0x0000000c17177810ULL, 0x000fe20007ffe0ffULL, 0x0000000114367824ULL, 0x040fe200078e0215ULL,
0xfffffff839397812ULL, 0x000fe200078ee20cULL, 0x00000001140c7824ULL, 0x040fe400078e0244ULL,
0x00000008143f7824ULL, 0x000fc400078e00ffULL, 0x0000000135167824ULL, 0x100fe400078e0215ULL,
0x0000000117147824ULL, 0x000fe200078e0215ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee20cULL,
0x0000000135157824ULL, 0x140fe400078e0244ULL, 0x0000000835387824ULL, 0x000fe400078e00ffULL,
0x0000000117377824ULL, 0x040fe400078e0244ULL, 0x00000008173a7824ULL, 0x000fe200078e00ffULL,
0xfffffff838457812ULL, 0x000fe200078ee215ULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff83a497812ULL, 0x000fe200078ee237ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004d34347212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003b34347210ULL, 0x000fe40007f1e0ffULL, 0x0000004d36367212ULL, 0x080fe200078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004d16167212ULL, 0x000fe400078efcffULL,
0x0000003b36367210ULL, 0x000fe20007f5e0ffULL, 0x0000000135357824ULL, 0x100fe200000e063dULL,
0x0000004d14147212ULL, 0x000fe200078efcffULL, 0x0000001039397824ULL, 0x100fe200078e020aULL,
0x0000003b16167210ULL, 0x080fe20007f1e0ffULL, 0x0000000137377824ULL, 0x100fe200010e063dULL,
0x0000003b14147210ULL, 0x000fe20007f7e0ffULL, 0x000000103f3b7824ULL, 0x000fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e2000b901c48ULL,
0x0000000117177824ULL, 0x000fc400000e063dULL, 0x0000000115157824ULL, 0x000fe200018e063dULL,
0x00000000363b7faeULL, 0x0003e2000b901c48ULL, 0x00000010453d7824ULL, 0x100fe400078e020aULL,
0x00000010493f7824ULL, 0x000fc600078e020aULL, 0x00000000163d7faeULL, 0x0003e8000b901c48ULL,
0x00000000143f7faeULL, 0x0003e4000b901c48ULL, 0x000000006b0573c2ULL, 0x000ea200000e0000ULL,
0x0000000266667810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000006f6600720cULL, 0x000fda0003f06070ULL,
0x0000000166148824ULL, 0x002fe400078e0269ULL, 0x00000004ff158424ULL, 0x000fe200078e00ffULL,
0x0000f6b005057890ULL, 0x004fc6000fffe03fULL, 0x0000640014148625ULL, 0x000fca00078e0015ULL,
0x0000000814458981ULL, 0x000322000c1e1900ULL, 0x0000000802087824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a05ULL, 0xfffffff008087812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b00008167f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480009147f8cULL, 0x0022a4000c80043fULL, 0x0000000000347805ULL, 0x000fc40000015200ULL,
0x00f64c0009377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011437ULL,
0x0000003908087211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000208087819ULL, 0x000fc80000001237ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c0009377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002087824ULL, 0x000fca00078e00ffULL, 0xffffff8008087812ULL, 0x000fc800078ec0ffULL,
0x000001004d097810ULL, 0x000fca0007ffe008ULL, 0x0000000162097824ULL, 0x000fca00078e0209ULL,
0x00f0000009347984ULL, 0x000e680000000800ULL, 0x00f2000009357984ULL, 0x0004e20000000800ULL,
0x000000073400720bULL, 0x002fe20003f1d000ULL, 0x0000def27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0c367812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fd200078e0007ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000026a097810ULL, 0x000fe40007ffe0ffULL, 0x000000073400720bULL, 0x000fe40003f54000ULL,
0x000000020900720cULL, 0x000fe20003f05270ULL, 0x0000de927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000097806ULL, 0x000fc400010e0100ULL, 0x0000008002158824ULL, 0x000fe200078e024dULL,
0x0000000734087209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910090c7816ULL, 0x000fe200000000ffULL, 0x0000000162158824ULL, 0x000fca00078e0215ULL,
0x00f4000815008388ULL, 0x0003e20000000800ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000708077221ULL, 0x002fe20000010100ULL,
0x000000ff09ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL, 0x0000000700387308ULL, 0x000e640000000800ULL,
0x000000380b0b7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011644ULL, 0x0000ddc27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c380c7589ULL, 0x0002a400000e0000ULL, 0x0000000c30307220ULL, 0x084fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c18187220ULL, 0x080fe20000410000ULL,
0x0000000c19197220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008440c7811ULL, 0x000fe200078ff0ffULL, 0x0000dca27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c380c7589ULL, 0x00046400000e0000ULL, 0x0000000c32327220ULL, 0x086fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff36ff7812ULL, 0x000fe20007806009ULL, 0x00000001ff097424ULL, 0x000fd800078e00ffULL,
0x8000000834340221ULL, 0x000fe20000010000ULL, 0x00007610ff090816ULL, 0x000fc60000000009ULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400040308ULL, 0x000e640000000800ULL,
0x0000000435350220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b350b7221ULL, 0x008fc20000010000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000000802077824ULL, 0x000fca00078e00ffULL, 0xfffffff007367812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0036077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x00000034140c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000135347824ULL, 0x000fe200000e0e15ULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011434ULL,
0x0000000c07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e0634ULL,
0x0000000207077819ULL, 0x000fc8000000120cULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000137377810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0036077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991009077816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0700720cULL, 0x000fda0003f65270ULL, 0x0000012000003947ULL, 0x000fea0003800000ULL,
0x00000004ff05723eULL, 0x000fe400000010ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011644ULL,
0x0000541005077816ULL, 0x000fe20000000005ULL, 0x0000d8627f007947ULL, 0x000fea000b800000ULL,
0x00001f0e07057589ULL, 0x0002a400000e0000ULL, 0x000000080e0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000d8927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c07067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0007ULL, 0x0000995000157802ULL, 0x000fc40000000f00ULL,
0x0000dee000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0007ULL,
0x000099a000157802ULL, 0x000fc40000000f00ULL, 0x0000de9000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001041487824ULL, 0x100fe200078e0261ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001043347824ULL, 0x000fc400078e0261ULL,
0x0000001042387824ULL, 0x000fe400078e0261ULL, 0x000000004848783bULL, 0x000ee80000004200ULL,
0x000000003838783bULL, 0x000fe80000004200ULL, 0x000000003434783bULL, 0x000fe20000004200ULL,
0x00000048000c7306ULL, 0x00cfe20000009400ULL, 0x00000100484e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x002fe20000011448ULL, 0x000001004b737824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fc40000011449ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000048003d7306ULL, 0x000e620000005400ULL, 0x00000018ff737819ULL, 0x000fce0000011473ULL,
0x0000004900587306ULL, 0x000ff00000009400ULL, 0x0000004900637306ULL, 0x000ea20000005400ULL,
0x0000003d0c00720bULL, 0x002fe20003fbd000ULL, 0x00000100490c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x0000000e003e7306ULL, 0x000ff00000209400ULL,
0x0000000e00437306ULL, 0x000e620000205400ULL, 0x000000635800720bULL, 0x004fce0003f9d000ULL,
0x0000004e003c7306ULL, 0x000ff00000209400ULL, 0x0000004e003f7306ULL, 0x000ea20000205400ULL,
0x000000433e00720bULL, 0x002fe20003f1d000ULL, 0x0001000048437824ULL, 0x000fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000004200647306ULL, 0x000ff00000209400ULL,
0x0000004200657306ULL, 0x0002e20000205400ULL, 0x0000003f3c00720bULL, 0x004fc40003fdd000ULL,
0x00a000004c3c783bULL, 0x000eaa0000000200ULL, 0x0000000c00587306ULL, 0x000fe20000209400ULL,
0x0000004200427245ULL, 0x002fce000020d400ULL, 0x0000000c00637306ULL, 0x0002620000205400ULL,
0x000000656400720bULL, 0x008fe40003f5d000ULL, 0x0000004e00657245ULL, 0x000fe4000020d400ULL,
0x00000018ff647819ULL, 0x000fe4000001144aULL, 0x0000000165656812ULL, 0x000fe200078efcffULL,
0x0000004800407306ULL, 0x000ee2000000d400ULL, 0x0000000c000c7245ULL, 0x002fca000020d400ULL,
0x0000000142422812ULL, 0x000fe400078efcffULL, 0x000000635800720bULL, 0x000fe20003fdd000ULL,
0x0001000049637824ULL, 0x000fe200078e00ffULL, 0x0000004900417306ULL, 0x000e68000000d400ULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000000140405812ULL, 0x008fc400078efcffULL,
0x00000043004e7306ULL, 0x000fe20000209400ULL, 0x000000053c3cb231ULL, 0x084fe200003400ffULL,
0x000000406540723eULL, 0x000fe200000010ffULL, 0x000000053e3eb231ULL, 0x000fe200003400ffULL,
0x000000010c0c6812ULL, 0x000fe200078efcffULL, 0x000000063d3db231ULL, 0x080fe400003400ffULL,
0x000000063f3fb231ULL, 0x000fe200003400ffULL, 0x0000004300497306ULL, 0x000ea20000205400ULL,
0x0000000141414812ULL, 0x002fc800078efcffULL, 0x000000410c41723eULL, 0x000fc600000010ffULL,
0x0000006300587306ULL, 0x000fe80000209400ULL, 0x000000403c30723cULL, 0x000b680000041830ULL,
0x0000006300657306ULL, 0x0002e20000205400ULL, 0x000000494e00720bULL, 0x004fe40003f9d000ULL,
0x0000000e00417245ULL, 0x020fc4000020d400ULL, 0x0000004300407245ULL, 0x000fe4000020d400ULL,
0x0000000141410812ULL, 0x000fe200078efcffULL, 0x0000004a00557306ULL, 0x000fe20000009400ULL,
0x0000006300637245ULL, 0x002fca000020d400ULL, 0x0000000140404812ULL, 0x000fe400078efcffULL,
0x000000655800720bULL, 0x008fe20003fbd000ULL, 0x000001004a587824ULL, 0x000fe200078e00ffULL,
0x000000404140723eULL, 0x000fe200000010ffULL, 0x0000007300657306ULL, 0x000fe60000209400ULL,
0x00000018ff587819ULL, 0x000fca0000011458ULL, 0x0000004a005b7306ULL, 0x000e640000005400ULL,
0x0000000163635812ULL, 0x000fc800078efcffULL, 0x000000634241723eULL, 0x000fe400000010ffULL,
0x0000004b00597306ULL, 0x000fea0000009400ULL, 0x000000403c40723cULL, 0x000be6000004182cULL,
0x00000073002c7306ULL, 0x020ea20000205400ULL, 0x0000005b5500720bULL, 0x002fe20003f1d000ULL,
0x000100004b5b7824ULL, 0x000fc400078e00ffULL, 0x00000010472d7824ULL, 0x000fc600078e0261ULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000004b005a7306ULL, 0x000e700000005400ULL,
0x0000005800687306ULL, 0x000fe20000209400ULL, 0x0000002c6500720bULL, 0x004fe20003fbd000ULL,
0x000100004a657824ULL, 0x000fe200078e00ffULL, 0x000000002d2c783bULL, 0x000ea80000004200ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000005800717306ULL, 0x000ee20000205400ULL,
0x0000005a5900720bULL, 0x002fc40003f9d000ULL, 0x00000018ff5a7819ULL, 0x000fca000001144bULL,
0x0000004a00567306ULL, 0x000270000000d400ULL, 0x0000004b00577306ULL, 0x0002a2000000d400ULL,
0x000000716800720bULL, 0x008fe40003f5d000ULL, 0x00000073004a7245ULL, 0x002fc8000020d400ULL,
0x000000014a4a5812ULL, 0x000fe200078efcffULL, 0x0000006400637306ULL, 0x000fe20000209400ULL,
0x00000058004b7245ULL, 0x000fe4000020d400ULL, 0x0000000156560812ULL, 0x000fc600078efcffULL,
0x000000014b4b2812ULL, 0x000fe400078efcffULL, 0x0000006400597306ULL, 0x000e620000205400ULL,
0x0000000157574812ULL, 0x004fe400078efcffULL, 0x000000564b56723eULL, 0x000fe400000010ffULL,
0x000000574a57723eULL, 0x000fc600000010ffULL, 0x0000006500477306ULL, 0x000fe80000209400ULL,
0x000000563c28723cULL, 0x000be80000041828ULL, 0x0000006500717306ULL, 0x0004e20000205400ULL,
0x000000596300720bULL, 0x002fe40003f5d000ULL, 0x0000006400577245ULL, 0x020fe2000020d400ULL,
0x0000010038647824ULL, 0x000fe200078e00ffULL, 0x0000006500567245ULL, 0x000fc4000020d400ULL,
0x00000018ff637819ULL, 0x000fe20000011438ULL, 0x0000005a00687306ULL, 0x000fe20000209400ULL,
0x0000010039657824ULL, 0x004fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fc80000011464ULL,
0x0000000157572812ULL, 0x000fe400078efcffULL, 0x0000005a006c7306ULL, 0x0002a20000205400ULL,
0x000000714700720bULL, 0x008fe40003f1d000ULL, 0x00000018ff657819ULL, 0x000fca0000011465ULL,
0x0000005b00737306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x002fca000020d400ULL,
0x0000000156560812ULL, 0x000fe400078efcffULL, 0x0000005b00767306ULL, 0x000e620000205400ULL,
0x0000006c6800720bULL, 0x004fe40003fbd000ULL, 0x000000565756723eULL, 0x000fe400000010ffULL,
0x0000005b00577245ULL, 0x000fc6000020d400ULL, 0x00000039005f7306ULL, 0x000fec0000009400ULL,
0x000000015a5a5812ULL, 0x000fe400078efcffULL, 0x000000767300720bULL, 0x002fe20003f9d000ULL,
0x00000039005e7306ULL, 0x000e700000005400ULL, 0x0000006300717306ULL, 0x000fe80000209400ULL,
0x0000000157574812ULL, 0x000fc800078efcffULL, 0x0000006300737306ULL, 0x0004e20000205400ULL,
0x000000575a57723eULL, 0x000fe400000010ffULL, 0x0000005e5f00720bULL, 0x002fe20003f1d000ULL,
0x00010000395f7824ULL, 0x000fc800078e00ffULL, 0x00000038005d7306ULL, 0x000fe20000009400ULL,
0x000000563c24723cULL, 0x000be20000041824ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000006300637245ULL, 0x004fc8000020d400ULL, 0x0000003800157306ULL, 0x000e620000005400ULL,
0x00000018ff567819ULL, 0x020fe20000011439ULL, 0x0001000038577824ULL, 0x000fe200078e00ffULL,
0x000000737100720bULL, 0x008fc80003f5d000ULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x00000038005c7306ULL, 0x000eb0000000d400ULL, 0x0000006500687306ULL, 0x000fe20000209400ULL,
0x000000155d00720bULL, 0x002fc40003fdd000ULL, 0x0000000163632812ULL, 0x000fca00078efcffULL,
0x00000065006c7306ULL, 0x000e6c0000205400ULL, 0x000000015c5c6812ULL, 0x004fe400078efcffULL,
0x00000056005e7306ULL, 0x000ff00000209400ULL, 0x0000005600737306ULL, 0x000ea20000205400ULL,
0x0000006c6800720bULL, 0x002fce0003fbd000ULL, 0x0000006400767306ULL, 0x000ff00000209400ULL,
0x0000006400777306ULL, 0x000e620000205400ULL, 0x000000735e00720bULL, 0x004fce0003fdd000ULL,
0x00000039000f7306ULL, 0x0004f0000000d400ULL, 0x0000005700687306ULL, 0x000fe20000209400ULL,
0x000000777600720bULL, 0x002fe40003f9d000ULL, 0x0000006400397245ULL, 0x004fc4000020d400ULL,
0x0000006500647245ULL, 0x000fc6000020d400ULL, 0x0000005700717306ULL, 0x000e620000205400ULL,
0x000000010f0f0812ULL, 0x008fe400078efcffULL, 0x0000000164645812ULL, 0x000fc600078efcffULL,
0x0000000139394812ULL, 0x000fe400078efcffULL, 0x0000005f006c7306ULL, 0x000fe40000209400ULL,
0x0000005c3938723eULL, 0x000fe400000010ffULL, 0x0000000f6439723eULL, 0x000fe400000010ffULL,
0x0000005600647245ULL, 0x000fe4000020d400ULL, 0x0000005f00737306ULL, 0x0004e20000205400ULL,
0x000000716800720bULL, 0x002fc40003f1d000ULL, 0x0000005700567245ULL, 0x000fe2000020d400ULL,
0x000000383c20723cULL, 0x000f620000041820ULL, 0x0000005f00577245ULL, 0x000fe4000020d400ULL,
0x0000000164646812ULL, 0x000fe200078efcffULL, 0x0000003a00547306ULL, 0x000fe20000009400ULL,
0x00000018ff5f7819ULL, 0x004fca000001143aULL, 0x0000000156560812ULL, 0x000fe400078efcffULL,
0x000000736c00720bULL, 0x008fe20003f9d000ULL, 0x0000003a00527306ULL, 0x000e620000005400ULL,
0x000000566356723eULL, 0x000fce00000010ffULL, 0x0000003b00537306ULL, 0x000fe80000009400ULL,
0x0000000157574812ULL, 0x000fc800078efcffULL, 0x000000576457723eULL, 0x000fe200000010ffULL,
0x0000003b00517306ULL, 0x000ea20000005400ULL, 0x000000525400720bULL, 0x002fe20003fdd000ULL,
0x000001003b527824ULL, 0x000fc800078e00ffULL, 0x000000563c1c723cULL, 0x000b62000004181cULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000005f00637306ULL, 0x000fea0000209400ULL,
0x000001003a567824ULL, 0x020fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe4000001143bULL,
0x000000515300720bULL, 0x004fe20003fbd000ULL, 0x0000005200547306ULL, 0x000fe20000209400ULL,
0x00000018ff567819ULL, 0x000fce0000011456ULL, 0x0000005600647306ULL, 0x000ff00000209400ULL,
0x0000005600657306ULL, 0x000e700000205400ULL, 0x0000005200517306ULL, 0x000ea20000205400ULL,
0x000000656400720bULL, 0x002fce0003f5d000ULL, 0x0000005f00687306ULL, 0x0002e20000205400ULL,
0x000000515400720bULL, 0x004fce0003f9d000ULL, 0x0000005700647306ULL, 0x000fe20000209400ULL,
0x0000005600517245ULL, 0x000fe4000020d400ULL, 0x0000005f005f7245ULL, 0x002fe4000020d400ULL,
0x0000000151512812ULL, 0x000fe400078efcffULL, 0x00000018ff567819ULL, 0x000fe20000011435ULL,
0x0000005700657306ULL, 0x0002a20000205400ULL, 0x000000686300720bULL, 0x008fe40003f1d000ULL,
0x0000005700687245ULL, 0x000fca000020d400ULL, 0x0000003a00507306ULL, 0x0006a2000000d400ULL,
0x00000018ff577819ULL, 0x002fca0000011436ULL, 0x000000015f5f0812ULL, 0x000fe400078efcffULL,
0x0000003b004f7306ULL, 0x000262000000d400ULL, 0x000100003a3a7824ULL, 0x008fe200078e00ffULL,
0x000000656400720bULL, 0x004fc80003f5d000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000000150506812ULL, 0x000fe200078efcffULL, 0x000100003b3b7824ULL, 0x002fe200078e00ffULL,
0x0000003a00537306ULL, 0x000fe40000209400ULL, 0x000000505150723eULL, 0x000fe400000010ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x000000014f4f5812ULL, 0x000fc400078efcffULL,
0x0000003a00547306ULL, 0x0002a20000205400ULL, 0x0000000168682812ULL, 0x000fce00078efcffULL,
0x0000003b00637306ULL, 0x000fe20000209400ULL, 0x0000003a003a7245ULL, 0x002fce000020d400ULL,
0x0000003b00647306ULL, 0x0002e20000205400ULL, 0x000000545300720bULL, 0x004fe40003fdd000ULL,
0x0000005200547245ULL, 0x000fe4000020d400ULL, 0x00000018ff537819ULL, 0x000fe40000011434ULL,
0x0000000154544812ULL, 0x000fe200078efcffULL, 0x0000003400077306ULL, 0x000fe20000009400ULL,
0x0000003b003b7245ULL, 0x002fe4000020d400ULL, 0x0000004f5451723eULL, 0x000fc600000010ffULL,
0x000000013a3a6812ULL, 0x000fe400078efcffULL, 0x000000646300720bULL, 0x008fe20003f9d000ULL,
0x0000003400147306ULL, 0x000e620000005400ULL, 0x0000003a5f3a723eULL, 0x000fe200000010ffULL,
0x000000503c18723cULL, 0x000b6c0000041818ULL, 0x00000035004c7306ULL, 0x000fe20000009400ULL,
0x00000018ff517819ULL, 0x020fc60000011437ULL, 0x000000013b3b4812ULL, 0x000fc800078efcffULL,
0x0000003b683b723eULL, 0x000fe200000010ffULL, 0x0000003500487306ULL, 0x000ea20000005400ULL,
0x000000140700720bULL, 0x002fe20003f1d000ULL, 0x0001000034147824ULL, 0x000fc800078e00ffULL,
0x0000003a3c3c723cULL, 0x000b620000041810ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000003600497306ULL, 0x000fea0000009400ULL, 0x0000010034107824ULL, 0x020fe200078e00ffULL,
0x0000000744137812ULL, 0x000fe400078ec0ffULL, 0x00000036004e7306ULL, 0x000e620000005400ULL,
0x000000484c00720bULL, 0x004fe20003fbd000ULL, 0x0000010035487824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fc40000011410ULL, 0x0000000813137812ULL, 0x000fe400078ef844ULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000001000127306ULL, 0x000fe20000209400ULL,
0x00000018ff3a7819ULL, 0x000fe2000001142cULL, 0x00000008134c7824ULL, 0x000fcc00078e00ffULL,
0x0000001000077306ULL, 0x000ea20000205400ULL, 0x0000004e4900720bULL, 0x002fe40003f9d000ULL,
0x0000001000497245ULL, 0x000fca000020d400ULL, 0x0000003700557306ULL, 0x000ff00000009400ULL,
0x00000037004b7306ULL, 0x000e620000005400ULL, 0x000000071200720bULL, 0x004fe20003f5d000ULL,
0x0000020002127824ULL, 0x000fe200078e00ffULL, 0x0000000260077810ULL, 0x000fc80007ffe0ffULL,
0xfffffff84c077812ULL, 0x000fe200078ee207ULL, 0x0000003400097306ULL, 0x000ea2000000d400ULL,
0xfffff80012127812ULL, 0x000fe400078ec0ffULL, 0x00000014004c7245ULL, 0x000fc6000020d400ULL,
0x0000001007107824ULL, 0x000fe200078e0212ULL, 0x0000000149492812ULL, 0x000fe200078efcffULL,
0x0000001400117306ULL, 0x000fe20000209400ULL, 0x0000004b5500720bULL, 0x002fce0003fdd000ULL,
0x0000001400347306ULL, 0x000e620000205400ULL, 0x0000000109090812ULL, 0x004fce00078efcffULL,
0x0000005300527306ULL, 0x000ff00000209400ULL, 0x00000053004f7306ULL, 0x0004e20000205400ULL,
0x000000341100720bULL, 0x002fe40003f5d000ULL, 0x00a000001010783bULL, 0x000e620000000200ULL,
0x00000018ff347819ULL, 0x000fc8000001142dULL, 0x0000004800687306ULL, 0x000fe20000209400ULL,
0x0000005300537245ULL, 0x004fca000020d400ULL, 0x000000014c4c2812ULL, 0x000fe400078efcffULL,
0x00000048004b7306ULL, 0x000ea20000205400ULL, 0x0000004f5200720bULL, 0x008fe20003f1d000ULL,
0x00010000354f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x00000035000c7306ULL, 0x00066c000000d400ULL, 0x0000000153530812ULL, 0x000fe400078efcffULL,
0x0000004b6800720bULL, 0x004fe20003f5d000ULL, 0x0000004f00147306ULL, 0x000fe20000209400ULL,
0x0000010036357824ULL, 0x008fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000004f004b7306ULL, 0x0004e20000205400ULL, 0x000000010c0c5812ULL, 0x002fe200078efcffULL,
0x000000051010b231ULL, 0x080fe400003400ffULL, 0x000000051212b231ULL, 0x000fe400003400ffULL,
0x000000061111b231ULL, 0x080fe400003400ffULL, 0x0000002c00587306ULL, 0x000fe20000009400ULL,
0x000000061313b231ULL, 0x000fe200003400ffULL, 0x0000004f004f7245ULL, 0x004fcc000020d400ULL,
0x0000002c00597306ULL, 0x000e620000005400ULL, 0x0000004b1400720bULL, 0x008fe40003fbd000ULL,
0x00000018ff147819ULL, 0x000fca000001142eULL, 0x0000005600547306ULL, 0x000fec0000209400ULL,
0x000000014f4f5812ULL, 0x000fe400078efcffULL, 0x0000005600647306ULL, 0x0004e20000205400ULL,
0x000000595800720bULL, 0x002fe20003f1d000ULL, 0x0000010037587824ULL, 0x000fe200078e00ffULL,
0x0000004800597245ULL, 0x000fc8000020d400ULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000002d005b7306ULL, 0x000fe20000009400ULL, 0x0000000159592812ULL, 0x000fe400078efcffULL,
0x0000005600567245ULL, 0x004fca000020d400ULL, 0x0000002d005a7306ULL, 0x000e620000005400ULL,
0x000000645400720bULL, 0x008fe40003f7d000ULL, 0x0000003500547245ULL, 0x000fca000020d400ULL,
0x0000003500527306ULL, 0x000fec0000209400ULL, 0x0000000156563812ULL, 0x000fe400078efcffULL,
0x00000035004b7306ULL, 0x0004e20000205400ULL, 0x0000005a5b00720bULL, 0x002fce0003f5d000ULL,
0x0000002e005d7306ULL, 0x000fe20000009400ULL, 0x00000018ff357819ULL, 0x004fce000001142fULL,
0x0000002e005e7306ULL, 0x000e620000005400ULL, 0x0000004b5200720bULL, 0x008fe20003fbd000ULL,
0x0001000036527824ULL, 0x000fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x00000058005a7306ULL, 0x000fec0000209400ULL, 0x0000000154545812ULL, 0x000fe400078efcffULL,
0x0000005800717306ULL, 0x0004e20000205400ULL, 0x0000005e5d00720bULL, 0x002fce0003f7d000ULL,
0x00000036000e7306ULL, 0x000e62000000d400ULL, 0x0000005800587245ULL, 0x004fce000020d400ULL,
0x00000052005b7306ULL, 0x000fe20000209400ULL, 0x000000715a00720bULL, 0x008fe20003fbd000ULL,
0x00010000375a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x00000052005e7306ULL, 0x0004e20000205400ULL, 0x000000010e0e4812ULL, 0x002fca00078efcffULL,
0x0000000158585812ULL, 0x000fe400078efcffULL, 0x0000002f005c7306ULL, 0x000fe20000009400ULL,
0x0000005200527245ULL, 0x004fce000020d400ULL, 0x0000002f00397306ULL, 0x000e620000005400ULL,
0x0000005e5b00720bULL, 0x008fe20003f9d000ULL, 0x000100002c5b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x00000037004a7306ULL, 0x000eac000000d400ULL,
0x0000000152524812ULL, 0x000fe400078efcffULL, 0x0000005700507306ULL, 0x000fe20000209400ULL,
0x000000395c00720bULL, 0x002fe20003fbd000ULL, 0x000001002c5c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x00000057005f7306ULL, 0x0002e20000205400ULL,
0x000000014a4a6812ULL, 0x004fce00078efcffULL, 0x0000005a005d7306ULL, 0x000fe20000209400ULL,
0x0000005700577245ULL, 0x002fce000020d400ULL, 0x0000005a005e7306ULL, 0x0002a20000205400ULL,
0x0000005f5000720bULL, 0x008fe20003fdd000ULL, 0x000001002d5f7824ULL, 0x000fe200078e00ffULL,
0x0000005a00507245ULL, 0x000fc8000020d400ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000005100637306ULL, 0x000fe20000209400ULL, 0x000100002d5a7824ULL, 0x002fca00078e00ffULL,
0x0000000157576812ULL, 0x000fe400078efcffULL, 0x0000005100657306ULL, 0x0002e20000205400ULL,
0x0000005e5d00720bULL, 0x004fe40003f9d000ULL, 0x00000018ff5a7819ULL, 0x000fca000001145aULL,
0x0000005c00647306ULL, 0x000fe20000209400ULL, 0x0000005100517245ULL, 0x002fca000020d400ULL,
0x0000000150504812ULL, 0x000fe400078efcffULL, 0x0000005c005d7306ULL, 0x000e620000205400ULL,
0x000000656300720bULL, 0x008fce0003fdd000ULL, 0x0000002c00477306ULL, 0x000eac000000d400ULL,
0x0000000151516812ULL, 0x000fe400078efcffULL, 0x0000005f00397306ULL, 0x000fe20000209400ULL,
0x0000005d6400720bULL, 0x002fce0003f9d000ULL, 0x0000005f002c7306ULL, 0x000e620000205400ULL,
0x0000000147470812ULL, 0x004fce00078efcffULL, 0x0000003a003b7306ULL, 0x000ff00000209400ULL,
0x0000003a004e7306ULL, 0x0004e20000205400ULL, 0x0000002c3900720bULL, 0x002fe20003f1d000ULL,
0x000001002f397824ULL, 0x000fe200078e00ffULL, 0x00000009492c723eULL, 0x000fe200000010ffULL,
0x000100002e097824ULL, 0x000fe200078e00ffULL, 0x0000005f00497245ULL, 0x000fe2000020d400ULL,
0x000100002f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000005b00637306ULL, 0x000fe20000209400ULL, 0x00000018ff097819ULL, 0x000fc40000011409ULL,
0x0000003a003a7245ULL, 0x004fc6000020d400ULL, 0x0000000149490812ULL, 0x000fe400078efcffULL,
0x0000005b00647306ULL, 0x0002a20000205400ULL, 0x0000004e3b00720bULL, 0x008fe20003fdd000ULL,
0x000001002e4e7824ULL, 0x000fe200078e00ffULL, 0x0000005c003b7245ULL, 0x000fc8000020d400ULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000003400557306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x002fe4000020d400ULL, 0x000000013b3b4812ULL, 0x000fc600078efcffULL,
0x000000013a3a6812ULL, 0x000fe400078efcffULL, 0x0000003400687306ULL, 0x000e620000205400ULL,
0x000000646300720bULL, 0x004fce0003f1d000ULL, 0x0000001400487306ULL, 0x000fec0000209400ULL,
0x000000015b5b0812ULL, 0x000fe400078efcffULL, 0x00000014004b7306ULL, 0x0004e20000205400ULL,
0x000000685500720bULL, 0x002fce0003f9d000ULL, 0x0000002d00157306ULL, 0x0002e2000000d400ULL,
0x0000001400147245ULL, 0x004fce000020d400ULL, 0x0000005a00657306ULL, 0x000fe20000209400ULL,
0x0000000c592d723eULL, 0x002fe400000010ffULL, 0x0000004b4800720bULL, 0x008fe40003f1d000ULL,
0x000000473b48723eULL, 0x000fc600000010ffULL, 0x0000005a006c7306ULL, 0x0002a20000205400ULL,
0x0000002c1030723cULL, 0x000b620000041830ULL, 0x0000000115152812ULL, 0x000fc800078efcffULL,
0x000000154949723eULL, 0x000fe400000010ffULL, 0x0000004e005d7306ULL, 0x000fe20000209400ULL,
0x0000000e542c723eULL, 0x020fe400000010ffULL, 0x0000004a582d723eULL, 0x000fe400000010ffULL,
0x0000005a005a7245ULL, 0x002fe2000020d400ULL, 0x000000481020723cULL, 0x000f620000041820ULL,
0x0000000114140812ULL, 0x000fe200078efcffULL, 0x0000004e005e7306ULL, 0x0002e20000205400ULL,
0x0000006c6500720bULL, 0x004fca0003f5d000ULL, 0x0000002c1028723cULL, 0x000b640000041828ULL,
0x0000002e000f7306ULL, 0x0004e2000000d400ULL, 0x0000004e004e7245ULL, 0x002fc8000020d400ULL,
0x00000034002d7245ULL, 0x020fe4000020d400ULL, 0x000000015a5a2812ULL, 0x000fe200078efcffULL,
0x0000003900557306ULL, 0x000fe20000209400ULL, 0x0000004c532e723eULL, 0x004fe400000010ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001145fULL, 0x0000005e5d00720bULL, 0x008fe40003fdd000ULL,
0x000000012d2d4812ULL, 0x000fe200078efcffULL, 0x00000039005c7306ULL, 0x0002a20000205400ULL,
0x000000010f0f3812ULL, 0x000fc400078efcffULL, 0x0000004c00157245ULL, 0x000fe4000020d400ULL,
0x0000005b3a2c723eULL, 0x000fe400000010ffULL, 0x0000005a2d2d723eULL, 0x000fe200000010ffULL,
0x0000003500367306ULL, 0x000fe20000209400ULL, 0x0000003900397245ULL, 0x002fe4000020d400ULL,
0x000000014e4e6812ULL, 0x000fc600078efcffULL, 0x0000002c101c723cULL, 0x000f64000004181cULL,
0x0000003500377306ULL, 0x000e620000205400ULL, 0x0000005c5500720bULL, 0x004fce0003f9d000ULL,
0x00000009000c7306ULL, 0x000fec0000209400ULL, 0x0000000139394812ULL, 0x000fe400078efcffULL,
0x0000000900597306ULL, 0x0004e20000205400ULL, 0x000000373600720bULL, 0x002fce0003f5d000ULL,
0x0000004c000e7306ULL, 0x000fe20000209400ULL, 0x0000000900097245ULL, 0x004fce000020d400ULL,
0x0000004c004b7306ULL, 0x000e620000205400ULL, 0x000000590c00720bULL, 0x008fe40003fdd000ULL,
0x00000035000c7245ULL, 0x000fc8000020d400ULL, 0x000000010c0c2812ULL, 0x000fe200078efcffULL,
0x0000002f00387306ULL, 0x0004ec000000d400ULL, 0x0000000109096812ULL, 0x000fe400078efcffULL,
0x0000004b0e00720bULL, 0x002fe40003f7d000ULL, 0x0000004f562f723eULL, 0x004fc400000010ffULL,
0x0000000f4e0e723eULL, 0x000fe400000010ffULL, 0x000000091414723eULL, 0x000fe400000010ffULL,
0x0000000138385812ULL, 0x008fe200078efcffULL, 0x0000002e1040723cULL, 0x000b620000041840ULL,
0x0000f6986a097811ULL, 0x000fe400078e18ffULL, 0x00000038390f723eULL, 0x000fe400000010ffULL,
0x0000000115153812ULL, 0x000fc400078efcffULL, 0x00000052572e723eULL, 0x020fe400000010ffULL,
0x00000050512f723eULL, 0x000fe200000010ffULL, 0x0000000e1018723cULL, 0x000b620000041818ULL,
0x000000150c15723eULL, 0x000fcc00000010ffULL, 0x0000f6c8460e7811ULL, 0x020fe200078e18ffULL,
0x0000002e1024723cULL, 0x040b700000041824ULL, 0x000000141010723cULL, 0x000b62000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000000e0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000009ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x0000000000147805ULL, 0x020fc80000015200ULL, 0x0000040003097984ULL, 0x004ea40000000800ULL,
0x8000000009ff7812ULL, 0x006fc4000780480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c142c7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e15ULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001142dULL,
0x0000002c09097211ULL, 0x000fca00078110ffULL, 0x000000ffff2c7224ULL, 0x000fca00000e062dULL,
0x0000000209097819ULL, 0x000fc8000000122cULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040003097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000100037810ULL, 0x000fc80007ffe0ffULL, 0x0000006e0300720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x0000000200037810ULL, 0x000fe20007ffe0ffULL,
0x0000590045097a24ULL, 0x010fe200078e02ffULL, 0x000001000d0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000006e0300720cULL, 0x000fe20003f06070ULL, 0x0000008009037824ULL, 0x000fe200078e00ffULL,
0x000000600e0c7812ULL, 0x000fca00078ec0ffULL, 0x00000001670d7824ULL, 0x000fcc00078e020cULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x0000000e6d097217ULL, 0x000fe20007800000ULL,
0x00000010020c7824ULL, 0x000fc800078e00ffULL, 0x0000000109097824ULL, 0x000fe200078e0a0eULL,
0x000000100c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0e7819ULL, 0x000fe40000011644ULL,
0x000000090c097217ULL, 0x000fe40007800000ULL, 0x000000040e0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000080e157810ULL, 0x040fe20007ffe0ffULL, 0x0000000109097824ULL, 0x100fe200078e0a0cULL,
0x0000000c0e2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f147824ULL, 0x000fc400078e020cULL,
0x00000001152d7824ULL, 0x100fe200078e020cULL, 0x000000090e00720cULL, 0x0c0fe20003f86070ULL,
0x000000010e0e7824ULL, 0x100fe200078e020cULL, 0x000000090f00720cULL, 0x080fe20003f66070ULL,
0x000000012c2f7824ULL, 0x040fe200078e020cULL, 0x000000092c00720cULL, 0x080fe20003f06070ULL,
0x000000010e0f7824ULL, 0x040fe200078e0244ULL, 0x000000091500720cULL, 0x000fe20003f46070ULL,
0x000000080e2e7824ULL, 0x040fe400078e00ffULL, 0x000000010e2c7824ULL, 0x000fc400078e020dULL,
0x00000001140e7824ULL, 0x000fe200078e020dULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x0000000114157824ULL, 0x140fe400078e0244ULL, 0x0000000814347824ULL, 0x000fe400078e00ffULL,
0x000000012d097824ULL, 0x040fe400078e0244ULL, 0x000000082d367824ULL, 0x040fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee215ULL, 0x000000012d0c7824ULL, 0x000fc400078e020dULL,
0x000000012f147824ULL, 0x040fe200078e020dULL, 0xfffffff836367812ULL, 0x000fe200078ee209ULL,
0x000000012f0d7824ULL, 0x000fe200078e0244ULL, 0x0000620003097a11ULL, 0x000fe200078a38ffULL,
0x000000082f387824ULL, 0x000fe400078e00ffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000630003037a11ULL, 0x000fe400028f3cffULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000004d2c2c7212ULL, 0x000fc600078efcffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000004d0e0e7212ULL, 0x000fe400078efcffULL,
0x0000002c092c7210ULL, 0x000fe20007fbe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000090e0e7210ULL, 0x000fe40007fde0ffULL, 0x0000004d0c0c7212ULL, 0x080fe200078efcffULL,
0x000000012d2d7824ULL, 0x100fe200028e0603ULL, 0x0000004d14147212ULL, 0x000fe200078efcffULL,
0x000000010f0f7824ULL, 0x000fe200030e0603ULL, 0x000000090c0c7210ULL, 0x080fe20007fbe0ffULL,
0x00000010342f7824ULL, 0x100fe200078e0261ULL, 0x0000000914147210ULL, 0x000fe20007fde0ffULL,
0x000000102e097824ULL, 0x000fc400078e0261ULL, 0x0000001036357824ULL, 0x000fe400078e0261ULL,
0x000000010d0d7824ULL, 0x000fe200028e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c097faeULL, 0x0003e2000e101c48ULL, 0x0000001038617824ULL, 0x000fe400078e0261ULL,
0x0000000115157824ULL, 0x000fe200030e0603ULL, 0x000000000e2f7faeULL, 0x0003e8000d901c48ULL,
0x000000000c357faeULL, 0x0003e8000d101c48ULL, 0x0000000014617faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001002097824ULL, 0x000fca00078e00ffULL,
0x0000001009097812ULL, 0x000fc800078ec0ffULL, 0x0000000944097211ULL, 0x000fc800078fe8ffULL,
0x00000004090f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090e7824ULL, 0x040fe200078e0244ULL,
0x0000000c092d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000809157824ULL, 0x040fe400078e00ffULL,
0x00000001090c7824ULL, 0x100fe400078e020dULL, 0x000000080f347824ULL, 0x000fe200078e00ffULL,
0xfffffff8152e7812ULL, 0x000fe200078ee20eULL, 0x000000010f0e7824ULL, 0x000fe200078e020dULL,
0x0000000809157810ULL, 0x000fe20007ffe0ffULL, 0x000000010f097824ULL, 0x000fc400078e0244ULL,
0x000000012d2c7824ULL, 0x100fe400078e020dULL, 0x0000000115147824ULL, 0x040fe200078e020dULL,
0xfffffff834347812ULL, 0x000fe200078ee209ULL, 0x00000001150f7824ULL, 0x100fe200078e0244ULL,
0x0000620003097a11ULL, 0x000fe200078038ffULL, 0x0000000815367824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000630003037a11ULL, 0x000fe400000f3cffULL,
0xfffffff836367812ULL, 0x000fe200078ee20fULL, 0x000000012d157824ULL, 0x040fe200078e0244ULL,
0x0000004d0c0c7212ULL, 0x000fe200078efcffULL, 0x000000082d387824ULL, 0x000fc400078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000c090c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff838387812ULL, 0x000fe200078ee215ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004d0e0e7212ULL, 0x000fc600078efcffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000004d14147212ULL, 0x000fc600078efcffULL, 0x000000010d0d7824ULL, 0x000fe200000e0603ULL,
0x0000004d2c2c7212ULL, 0x000fe200078efcffULL, 0x00000010342f7824ULL, 0x100fe200078e0261ULL,
0x0000000e090e7210ULL, 0x040fe20007f1e0ffULL, 0x0000001036357824ULL, 0x100fe200078e0261ULL,
0x0000001409147210ULL, 0x040fe40007f5e0ffULL, 0x0000002c092c7210ULL, 0x000fe20007f7e0ffULL,
0x000000102e097824ULL, 0x000fe400078e0261ULL, 0x000000010f0f7824ULL, 0x000fc400000e0603ULL,
0x0000000115157824ULL, 0x000fe200010e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c097faeULL, 0x0003e2000b901c48ULL, 0x0000001038617824ULL, 0x000fe400078e0261ULL,
0x000000012d2d7824ULL, 0x000fe200018e0603ULL, 0x000000000e2f7faeULL, 0x0003e8000b901c48ULL,
0x0000000014357faeULL, 0x0003e8000b901c48ULL, 0x000000002c617faeULL, 0x0003e4000b901c48ULL,
0x0000000802097824ULL, 0x002fe400078e00ffULL, 0x0000001046037824ULL, 0x000fc600078e00ffULL,
0x00000008090c7812ULL, 0x000fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001003037812ULL, 0x000fc600078ee2ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x000000206a037824ULL, 0x000fc800078e0203ULL, 0x000000010c037824ULL, 0x000fe200078e0203ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8006b0c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f66800030e7f8cULL, 0x000664000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f66c0003097984ULL, 0x000ee40000000800ULL, 0x8000000009ff7812ULL, 0x00afe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c140c7210ULL, 0x004fca0007f1e1ffULL,
0x000000012d2c7824ULL, 0x000fe200000e0e15ULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001142cULL,
0x0000000c09097211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e062cULL,
0x0000000209097819ULL, 0x000fc8000000120cULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c0003097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001806a037811ULL, 0x000fc800078e38ffULL, 0x0000000362037210ULL, 0x000fca0007ffe04dULL,
0x00f0000003097984ULL, 0x000e680000000800ULL, 0x00f20000030f7984ULL, 0x0006a20000000800ULL,
0x000000080900720bULL, 0x002fe20003f1d000ULL, 0x0000ab927f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x00cfc800000e0100ULL, 0x0000ffff0c2c7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff037424ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fd200078e0008ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000036a037810ULL, 0x000fe40007ffe0ffULL, 0x000000080900720bULL, 0x000fe40003f54000ULL,
0x000000020300720cULL, 0x000fe20003f05270ULL, 0x0000ab327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000037806ULL, 0x000fc400010e0100ULL, 0x00000080024d8824ULL, 0x000fe200078e024dULL,
0x00000008090e7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910030c7816ULL, 0x000fe200000000ffULL, 0x00000001624d8824ULL, 0x000fca00078e024dULL,
0x00f4000e4d008388ULL, 0x0003e20000000800ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000080e087221ULL, 0x002fe20000010100ULL,
0x000000ff03ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fcc0000410000ULL, 0x0000000800087308ULL, 0x000e640000000800ULL,
0x000000080b0b7220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011644ULL, 0x0000aa627f007947ULL, 0x000fea000b800000ULL,
0x00001f0c080c7589ULL, 0x0002a400000e0000ULL, 0x0000000c30307220ULL, 0x084fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c18187220ULL, 0x080fe20000410000ULL,
0x0000000c19197220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0003ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008440c7811ULL, 0x000fe200078ff0ffULL, 0x0000a9427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c080c7589ULL, 0x0004e400000e0000ULL, 0x0000000c32327220ULL, 0x08cfe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2cff7812ULL, 0x000fe20007806003ULL, 0x00000001ff037424ULL, 0x000fd800078e00ffULL,
0x000000090e090221ULL, 0x000fe20000010100ULL, 0x00007610ff030816ULL, 0x000fc60000000003ULL,
0x3fb8aa3b09090820ULL, 0x000fc80000410000ULL, 0x0000000900040308ULL, 0x000e640000000800ULL,
0x000000040f0f0220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b0f0b7221ULL, 0x000fc20000010000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00f6b4006b0f7984ULL, 0x000e620000000800ULL, 0x00000004020c7824ULL, 0x000fca00078e00ffULL,
0x000000040c2c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x000000022c2c7810ULL, 0x000fe40007ffe0ffULL, 0x800000000fff7812ULL, 0x002fe20007804817ULL,
0x00000004720f7824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x00000014082d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e09ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000002d14147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6b4006b157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991003037816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003fa5270ULL, 0x0000012000005947ULL, 0x000fea0003800000ULL,
0x00000004ff03723eULL, 0x000fe400000010ffULL, 0x00000002ff087819ULL, 0x000fe40000011644ULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000a4c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0803057589ULL, 0x0002a400000e0000ULL, 0x00000008080c7810ULL, 0x000fe20007ffe0ffULL,
0x0000a4f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c03067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010080c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0003ULL, 0x0000ceb000157802ULL, 0x000fc40000000f00ULL,
0x0000a98000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018080c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0003ULL,
0x0000cf0000157802ULL, 0x000fc40000000f00ULL, 0x0000a93000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000744097812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000036a567810ULL, 0x000fc40007ffe0ffULL,
0x0000000809037812ULL, 0x00afe400078ef844ULL, 0x0000000844087812ULL, 0x000fe200078ec0ffULL,
0x0000080056567824ULL, 0x000fe400078e00ffULL, 0x0000000803037824ULL, 0x000fca00078e00ffULL,
0xfffffff803037812ULL, 0x000fca00078ee260ULL, 0x00000010033c7824ULL, 0x000fc400078e0256ULL,
0x0000000f440f7211ULL, 0x000fe400078fe0ffULL, 0x00000009080c7212ULL, 0x044fe400078efcffULL,
0x0000001008357812ULL, 0x000fe400078efe09ULL, 0x0000002c44347211ULL, 0x000fe200078fe0ffULL,
0x000000010c037824ULL, 0x140fe400078e020fULL, 0x000000080c147824ULL, 0x000fe400078e00ffULL,
0x0000000135087824ULL, 0x000fc400078e020fULL, 0x0000000835097824ULL, 0x000fe200078e00ffULL,
0xfffffff814037812ULL, 0x000fc800078ee203ULL, 0xfffffff809097812ULL, 0x000fe200078ee208ULL,
0x0000001003037824ULL, 0x000fe400078e020aULL, 0x000000010c087824ULL, 0x040fe400078e0234ULL,
0x00000010092c7824ULL, 0x000fe200078e020aULL, 0x000000000338783bULL, 0x000e620000004200ULL,
0x0000000135347824ULL, 0x040fe400078e0234ULL, 0x000000080c097824ULL, 0x000fe400078e00ffULL,
0x0000000835357824ULL, 0x000fe200078e00ffULL, 0x000000002c2c783bULL, 0x000fe40000004200ULL,
0xfffffff809097812ULL, 0x000fc400078ee208ULL, 0xfffffff835357812ULL, 0x000fc600078ee234ULL,
0x0000001009147824ULL, 0x100fe400078e020aULL, 0x0000001035357824ULL, 0x000fc800078e020aULL,
0x000000001414783bULL, 0x000fe20000004200ULL, 0x00000100393d7824ULL, 0x002fe200078e00ffULL,
0x0000003900507306ULL, 0x000fe20000009400ULL, 0x0000010038347824ULL, 0x000fc600078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001143dULL, 0x009000003c3c783bULL, 0x000e620000000200ULL,
0x00000018ff0a7819ULL, 0x000fe20000011434ULL, 0x0000003900037306ULL, 0x000ea40000005400ULL,
0x000000003534783bULL, 0x000fec0000004200ULL, 0x0000006c00717306ULL, 0x000ff00000209400ULL,
0x0000006c00767306ULL, 0x0006620000205400ULL, 0x000000035000720bULL, 0x004fc40003f7d000ULL,
0x0000000a00037245ULL, 0x000fca000020d400ULL, 0x00000038005c7306ULL, 0x000fe20000009400ULL,
0x0000006c006c7245ULL, 0x008fce000020d400ULL, 0x00000038004f7306ULL, 0x000ea20000005400ULL,
0x000000767100720bULL, 0x002fe20003f9d000ULL, 0x000000053c3cd231ULL, 0x000fcc00003400ffULL,
0x0000000a00577306ULL, 0x000fe20000209400ULL, 0x000000053e3ed231ULL, 0x000fe400003400ffULL,
0x000000063d3dd231ULL, 0x080fe400003400ffULL, 0x000000063f3fd231ULL, 0x000fe200003400ffULL,
0x000000016c6c4812ULL, 0x000fe400078efcffULL, 0x0000000a00687306ULL, 0x0002e20000205400ULL,
0x0000004f5c00720bULL, 0x004fce0003f1d000ULL, 0x0000003900097306ULL, 0x000ea2000000d400ULL,
0x00000018ff0a7819ULL, 0x002fce0000011438ULL, 0x0000003800087306ULL, 0x000e62000000d400ULL,
0x000000685700720bULL, 0x008fce0003f5d000ULL, 0x0000003a00547306ULL, 0x000fe20000009400ULL,
0x0000000109093812ULL, 0x004fc800078efcffULL, 0x000000096c09723eULL, 0x000fe200000010ffULL,
0x00010000386c7824ULL, 0x000fe200078e00ffULL, 0x0000000103032812ULL, 0x000fe200078efcffULL,
0x0000003a00537306ULL, 0x000ea20000005400ULL, 0x0000000108080812ULL, 0x002fe400078efcffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x000000080308723eULL, 0x000fc600000010ffULL,
0x0000003b00527306ULL, 0x000fe80000009400ULL, 0x000000083c30723cULL, 0x000be20000041830ULL,
0x000000535400720bULL, 0x004fc60003f1d000ULL, 0x0000006c00097306ULL, 0x020fe60000209400ULL,
0x00000018ff087819ULL, 0x000fe20000011439ULL, 0x0001000039397824ULL, 0x000fc800078e00ffULL,
0x0000006c00547306ULL, 0x000e620000205400ULL, 0x00000018ff397819ULL, 0x000fce0000011439ULL,
0x0000003b00517306ULL, 0x000eb00000005400ULL, 0x0000000a00687306ULL, 0x000fe20000209400ULL,
0x000000540900720bULL, 0x002fe20003f7d000ULL, 0x000001003a097824ULL, 0x000fca00078e00ffULL,
0x00000018ff097819ULL, 0x000fe20000011409ULL, 0x0000000a00717306ULL, 0x000e620000205400ULL,
0x000000515200720bULL, 0x004fce0003f5d000ULL, 0x0000000800387306ULL, 0x000ff00000209400ULL,
0x0000000800737306ULL, 0x000ea20000205400ULL, 0x000000716800720bULL, 0x002fe20003fdd000ULL,
0x000001003b687824ULL, 0x000fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000003900537306ULL, 0x000ff00000209400ULL, 0x0000003900527306ULL, 0x0002e20000205400ULL,
0x000000733800720bULL, 0x004fc40003f9d000ULL, 0x0000006c00387245ULL, 0x000fc8000020d400ULL,
0x0000000138383812ULL, 0x000fe200078efcffULL, 0x0000000900547306ULL, 0x000fe20000209400ULL,
0x0000003900397245ULL, 0x002fce000020d400ULL, 0x0000000900717306ULL, 0x000e620000205400ULL,
0x000000525300720bULL, 0x008fe40003f7d000ULL, 0x0000000a00537245ULL, 0x000fe4000020d400ULL,
0x00000008000a7245ULL, 0x000fe4000020d400ULL, 0x0000000153536812ULL, 0x000fe200078efcffULL,
0x00000068006c7306ULL, 0x000fe20000209400ULL, 0x000000010a0a4812ULL, 0x000fe400078efcffULL,
0x000000385338723eULL, 0x000fc600000010ffULL, 0x0000000139393812ULL, 0x000fe400078efcffULL,
0x000000715400720bULL, 0x002fe20003fdd000ULL, 0x0000001400607306ULL, 0x000fe20000009400ULL,
0x000000390a39723eULL, 0x000fe400000010ffULL, 0x00000018ff0a7819ULL, 0x000fca000001143aULL,
0x0000006800717306ULL, 0x0002a20000205400ULL, 0x000000383c40723cULL, 0x000bee0000041840ULL,
0x0000001400617306ULL, 0x000ee20000005400ULL, 0x0000006800687245ULL, 0x002fe4000020d400ULL,
0x0000000900387245ULL, 0x020fc8000020d400ULL, 0x0000000138386812ULL, 0x000fe200078efcffULL,
0x0000003b00657306ULL, 0x000e62000000d400ULL, 0x000000716c00720bULL, 0x004fce0003f7d000ULL,
0x0000003a00557306ULL, 0x000eac000000d400ULL, 0x0000000168683812ULL, 0x000fe400078efcffULL,
0x000000616000720bULL, 0x008fe20003f7d000ULL, 0x000100003a607824ULL, 0x000fe200078e00ffULL,
0x0000000165652812ULL, 0x002fe200078efcffULL, 0x0000001500627306ULL, 0x000fe20000009400ULL,
0x000100003b617824ULL, 0x000fc400078e00ffULL, 0x000000656839723eULL, 0x000fe400000010ffULL,
0x0000000155550812ULL, 0x004fe400078efcffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000001500647306ULL, 0x000e620000005400ULL, 0x000000553838723eULL, 0x000fe400000010ffULL,
0x00000018ff617819ULL, 0x000fca0000011461ULL, 0x0000000a00657306ULL, 0x000fe20000209400ULL,
0x000000383c28723cULL, 0x000bee0000041828ULL, 0x0000000a00687306ULL, 0x000ea20000205400ULL,
0x00000018ff387819ULL, 0x020fe2000001143bULL, 0x00000100143b7824ULL, 0x000fe200078e00ffULL,
0x000000646200720bULL, 0x002fc80003f5d000ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x00000060003a7306ULL, 0x000ff00000209400ULL, 0x0000006000717306ULL, 0x000e620000205400ULL,
0x000000686500720bULL, 0x004fce0003fdd000ULL, 0x0000003800397306ULL, 0x000ff00000209400ULL,
0x00000038006c7306ULL, 0x000ea20000205400ULL, 0x000000713a00720bULL, 0x002fe20003f9d000ULL,
0x00000100153a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000006100627306ULL, 0x000ff00000209400ULL, 0x0000006100657306ULL, 0x000e620000205400ULL,
0x0000006c3900720bULL, 0x004fc40003f1d000ULL, 0x0000006000397245ULL, 0x000fe4000020d400ULL,
0x0000003b006c7245ULL, 0x000fe4000020d400ULL, 0x0000000139394812ULL, 0x000fe200078efcffULL,
0x0000003b00647306ULL, 0x000ff00000209400ULL, 0x0000003b00717306ULL, 0x0004e20000205400ULL,
0x000000656200720bULL, 0x002fc40003f9d000ULL, 0x0000000a00627245ULL, 0x000fc8000020d400ULL,
0x0000000162626812ULL, 0x000fe200078efcffULL, 0x0000003a00687306ULL, 0x000fe20000209400ULL,
0x00000018ff3b7819ULL, 0x004fce0000011414ULL, 0x0000003a00657306ULL, 0x000e620000205400ULL,
0x000000716400720bULL, 0x008fe40003fdd000ULL, 0x0000006100647245ULL, 0x000fe4000020d400ULL,
0x0000003800717245ULL, 0x000fe4000020d400ULL, 0x0000000164644812ULL, 0x000fe200078efcffULL,
0x00000015005e7306ULL, 0x000ea2000000d400ULL, 0x0000000171710812ULL, 0x000fe400078efcffULL,
0x000000396238723eULL, 0x000fc400000010ffULL, 0x000000647139723eULL, 0x000fe400000010ffULL,
0x000000016c6c6812ULL, 0x000fe200078efcffULL, 0x00000014005f7306ULL, 0x0006e2000000d400ULL,
0x000000656800720bULL, 0x002fe40003f9d000ULL, 0x00000018ff617819ULL, 0x000fe2000001142cULL,
0x000000383c24723cULL, 0x000b620000041824ULL, 0x00000018ff627819ULL, 0x000fe4000001142dULL,
0x000000015e5e2812ULL, 0x004fe200078efcffULL, 0x0001000014147824ULL, 0x008fe200078e00ffULL,
0x0000001600597306ULL, 0x000fe40000009400ULL, 0x0000003a00397245ULL, 0x020fc4000020d400ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000000139394812ULL, 0x000fe400078efcffULL,
0x000000015f5f3812ULL, 0x000fe200078efcffULL, 0x00000016005a7306ULL, 0x000e620000005400ULL,
0x0000005e3939723eULL, 0x000fe400000010ffULL, 0x0000005f6c38723eULL, 0x000fe200000010ffULL,
0x00000100176c7824ULL, 0x000fc800078e00ffULL, 0x00000017005b7306ULL, 0x000fe20000009400ULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x000000383c20723cULL, 0x000b6c0000041820ULL,
0x00000017005c7306ULL, 0x000ea20000005400ULL, 0x0001000015397824ULL, 0x020fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011415ULL, 0x0000010016157824ULL, 0x000fe200078e00ffULL,
0x0000005a5900720bULL, 0x002fc40003f7d000ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000014005e7306ULL, 0x000fe20000209400ULL, 0x00000018ff157819ULL, 0x000fce0000011415ULL,
0x0000001400717306ULL, 0x0002e20000205400ULL, 0x0000005c5b00720bULL, 0x004fce0003f5d000ULL,
0x0000003b003a7306ULL, 0x000fe20000209400ULL, 0x0000001400147245ULL, 0x002fe4000020d400ULL,
0x000000715e00720bULL, 0x008fca0003f9d000ULL, 0x0000003b005f7306ULL, 0x0002a20000205400ULL,
0x00000018ff5e7819ULL, 0x000fce000001142eULL, 0x0000003800597306ULL, 0x000fe20000209400ULL,
0x0000003b003b7245ULL, 0x002fe4000020d400ULL, 0x0000000114144812ULL, 0x000fca00078efcffULL,
0x00000038005a7306ULL, 0x000e620000205400ULL, 0x0000005f3a00720bULL, 0x004fe40003fdd000ULL,
0x00000038003a7245ULL, 0x000fe4000020d400ULL, 0x00000018ff5f7819ULL, 0x000fc6000001142fULL,
0x00000039005c7306ULL, 0x000fec0000209400ULL, 0x000000013b3b6812ULL, 0x000fe400078efcffULL,
0x0000003900717306ULL, 0x0004e20000205400ULL, 0x0000005a5900720bULL, 0x002fe40003f1d000ULL,
0x000000143b38723eULL, 0x000fca00000010ffULL, 0x0000001500737306ULL, 0x000fe20000209400ULL,
0x0000003900397245ULL, 0x004fca000020d400ULL, 0x000000013a3a0812ULL, 0x000fe400078efcffULL,
0x0000001500767306ULL, 0x0002a20000205400ULL, 0x000000715c00720bULL, 0x008fe40003f9d000ULL,
0x00000018ff717819ULL, 0x000fca0000011417ULL, 0x0000006c005b7306ULL, 0x000fe20000209400ULL,
0x0000001500157245ULL, 0x002fca000020d400ULL, 0x0000000139394812ULL, 0x000fe400078efcffULL,
0x0000006c007a7306ULL, 0x0002e20000205400ULL, 0x000000767300720bULL, 0x004fe40003fdd000ULL,
0x000000393a39723eULL, 0x000fe200000010ffULL, 0x00000010073a7824ULL, 0x000fe200078e0256ULL,
0x00000018ff567819ULL, 0x000fc60000011416ULL, 0x0000001600587306ULL, 0x000ea2000000d400ULL,
0x0000006c006c7245ULL, 0x002fe2000020d400ULL, 0x000000383c1c723cULL, 0x000b64000004181cULL,
0x009000003a38783bULL, 0x020e640000000200ULL, 0x0000000115156812ULL, 0x000fe400078efcffULL,
0x0000001700577306ULL, 0x000ea2000000d400ULL, 0x0000007a5b00720bULL, 0x008fe40003f9d000ULL,
0x0000000158583812ULL, 0x004fca00078efcffULL, 0x0000002e004c7306ULL, 0x000fe20000009400ULL,
0x000000581514723eULL, 0x000fca00000010ffULL, 0x000000016c6c4812ULL, 0x000fe400078efcffULL,
0x0000000157572812ULL, 0x000fe200078efcffULL, 0x0000002e00487306ULL, 0x000ea60000005400ULL,
0x000000576c15723eULL, 0x000fca00000010ffULL, 0x0000002c00637306ULL, 0x000fe40000009400ULL,
0x000000143c18723cULL, 0x000b6c0000041818ULL, 0x0000002c005d7306ULL, 0x000ee20000005400ULL,
0x000001002c147824ULL, 0x020fe200078e00ffULL, 0x000000484c00720bULL, 0x004fe20003f7d000ULL,
0x000000053838d231ULL, 0x002fc400003400ffULL, 0x000000053a3ad231ULL, 0x000fe200003400ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000000063939d231ULL, 0x080fe200003400ffULL,
0x0000002c00497306ULL, 0x0002a2000000d400ULL, 0x000000063b3bd231ULL, 0x000fce00003400ffULL,
0x0000001400157306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x002fe200078e00ffULL,
0x0000005d6300720bULL, 0x008fc80003f9d000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000001400767306ULL, 0x000e6e0000205400ULL, 0x0000000149494812ULL, 0x004fe200078efcffULL,
0x0000003400507306ULL, 0x000ff00000009400ULL, 0x00000034004f7306ULL, 0x000ea20000005400ULL,
0x000000761500720bULL, 0x002fc40003fbd000ULL, 0x00000018ff157819ULL, 0x000fca0000011435ULL,
0x0000002f004a7306ULL, 0x000ff00000009400ULL, 0x0000002f004b7306ULL, 0x000e620000005400ULL,
0x0000004f5000720bULL, 0x004fe20003f1d000ULL, 0x000001002d4f7824ULL, 0x000fe200078e00ffULL,
0x0000001400507245ULL, 0x000fc4000020d400ULL, 0x00000018ff147819ULL, 0x000fe40000011436ULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000002c00737306ULL, 0x000fe20000209400ULL,
0x0000000150505812ULL, 0x000fce00078efcffULL, 0x0000002c00487306ULL, 0x000ea20000205400ULL,
0x0000004b4a00720bULL, 0x002fe20003fdd000ULL, 0x000100002d4b7824ULL, 0x000fe200078e00ffULL,
0x0000002c004a7245ULL, 0x000fc8000020d400ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000006100657306ULL, 0x000ff00000209400ULL, 0x0000006100647306ULL, 0x0002e20000205400ULL,
0x000000487300720bULL, 0x004fce0003f9d000ULL, 0x0000002d004d7306ULL, 0x000fe20000009400ULL,
0x0000006100617245ULL, 0x002fca000020d400ULL, 0x000000014a4a4812ULL, 0x000fe400078efcffULL,
0x0000002d004e7306ULL, 0x000e620000005400ULL, 0x000000646500720bULL, 0x008fce0003fbd000ULL,
0x0000002d00477306ULL, 0x000eac000000d400ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x0000004f00487306ULL, 0x000fe20000209400ULL, 0x0000004e4d00720bULL, 0x002fe40003f5d000ULL,
0x00000018ff4d7819ULL, 0x000fc40000011434ULL, 0x0000004a614a723eULL, 0x000fc600000010ffULL,
0x0000004f002d7306ULL, 0x0002ec0000205400ULL, 0x0000000147472812ULL, 0x004fe400078efcffULL,
0x0000003500517306ULL, 0x000fe20000009400ULL, 0x0000004f004f7245ULL, 0x002fce000020d400ULL,
0x0000003500527306ULL, 0x000e620000005400ULL, 0x0000002d4800720bULL, 0x008fce0003fbd000ULL,
0x0000004b00737306ULL, 0x000fec0000209400ULL, 0x000000014f4f5812ULL, 0x000fe400078efcffULL,
0x0000004b00767306ULL, 0x0004e20000205400ULL, 0x000000525100720bULL, 0x002fe20003f9d000ULL,
0x000001002e517824ULL, 0x000fc400078e00ffULL, 0x000001002f527824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000006200687306ULL, 0x000fe20000209400ULL,
0x0000004b004b7245ULL, 0x004fe4000020d400ULL, 0x00000018ff527819ULL, 0x000fca0000011452ULL,
0x00000062005a7306ULL, 0x0002a20000205400ULL, 0x000000767300720bULL, 0x008fce0003f5d000ULL,
0x0000003600537306ULL, 0x000fe20000009400ULL, 0x0000006200627245ULL, 0x002fca000020d400ULL,
0x000000014b4b2812ULL, 0x000fe400078efcffULL, 0x0000003600547306ULL, 0x000e620000005400ULL,
0x0000005a6800720bULL, 0x004fce0003fbd000ULL, 0x0000005100657306ULL, 0x000fec0000209400ULL,
0x0000000162625812ULL, 0x000fe400078efcffULL, 0x00000051005a7306ULL, 0x0004e20000205400ULL,
0x000000545300720bULL, 0x002fe20003f5d000ULL, 0x000100002e547824ULL, 0x000fe200078e00ffULL,
0x0000004b624b723eULL, 0x000fc800000010ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000002e000f7306ULL, 0x000e62000000d400ULL, 0x0000005100517245ULL, 0x004fce000020d400ULL,
0x0000005e00597306ULL, 0x000fe20000209400ULL, 0x0000005a6500720bULL, 0x008fce0003fbd000ULL,
0x0000005e005b7306ULL, 0x0004e20000205400ULL, 0x000000010f0f3812ULL, 0x002fca00078efcffULL,
0x0000000151515812ULL, 0x000fe400078efcffULL, 0x00000052002c7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x004fce000020d400ULL, 0x0000005200737306ULL, 0x0002a20000205400ULL,
0x0000005b5900720bULL, 0x008fce0003f7d000ULL, 0x0000002f000c7306ULL, 0x0006a2000000d400ULL,
0x0000005200527245ULL, 0x002fca000020d400ULL, 0x000000015e5e3812ULL, 0x000fe400078efcffULL,
0x0000005400537306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x008fe200078e00ffULL,
0x000000732c00720bULL, 0x004fe40003fbd000ULL, 0x00000018ff2c7819ULL, 0x000fe40000011437ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00000054005a7306ULL, 0x000e620000205400ULL,
0x000000010c0c6812ULL, 0x000fcc00078efcffULL, 0x0000000152525812ULL, 0x000fe200078efcffULL,
0x0000002f00597306ULL, 0x000ff00000209400ULL, 0x0000002f00767306ULL, 0x000ea20000205400ULL,
0x0000005a5300720bULL, 0x002fe20003fdd000ULL, 0x00010000165a7824ULL, 0x000fc400078e00ffULL,
0x0001000017537824ULL, 0x000fe200078e00ffULL, 0x0000005400177245ULL, 0x000fe4000020d400ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000005f005c7306ULL, 0x000fe20000209400ULL,
0x00000018ff537819ULL, 0x000fca0000011453ULL, 0x0000000117176812ULL, 0x000fe400078efcffULL,
0x0000005f00077306ULL, 0x0002e20000205400ULL, 0x000000765900720bULL, 0x004fe20003fbd000ULL,
0x0000010034597824ULL, 0x000fe200078e00ffULL, 0x000000175e5e723eULL, 0x000fc800000010ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000005a00687306ULL, 0x000fe20000209400ULL,
0x0000005f005f7245ULL, 0x002fce000020d400ULL, 0x0000005a00737306ULL, 0x000e620000205400ULL,
0x000000075c00720bULL, 0x008fe40003fdd000ULL, 0x0000002f00077245ULL, 0x000fc8000020d400ULL,
0x0000000107075812ULL, 0x000fe200078efcffULL, 0x0000005600577306ULL, 0x000fec0000209400ULL,
0x000000015f5f6812ULL, 0x000fe400078efcffULL, 0x00000056006c7306ULL, 0x000ea20000205400ULL,
0x000000736800720bULL, 0x002fc40003fbd000ULL, 0x0000005600737245ULL, 0x000fe4000020d400ULL,
0x000000075f5f723eULL, 0x000fc600000010ffULL, 0x0000005300547306ULL, 0x000fe80000209400ULL,
0x0000005e3824723cULL, 0x000fe80000041824ULL, 0x0000005300657306ULL, 0x000e620000205400ULL,
0x0000006c5700720bULL, 0x004fe20003f7d000ULL, 0x0000010035577824ULL, 0x000fe200078e00ffULL,
0x0000005a006c7245ULL, 0x000fc8000020d400ULL, 0x000000016c6c5812ULL, 0x000fe200078efcffULL,
0x0000007100587306ULL, 0x000fe20000209400ULL, 0x00000018ff577819ULL, 0x000fca0000011457ULL,
0x0000000173733812ULL, 0x000fe400078efcffULL, 0x00000071005d7306ULL, 0x000ea20000205400ULL,
0x000000655400720bULL, 0x002fe20003fbd000ULL, 0x0001000035547824ULL, 0x000fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x00000059005b7306ULL, 0x000ff00000209400ULL,
0x0000005900767306ULL, 0x000fe20000205400ULL, 0x0000005d5800720bULL, 0x004fe20003fdd000ULL,
0x0001000034587824ULL, 0x000fca00078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000003700557306ULL, 0x000ff00000009400ULL, 0x0000003700607306ULL, 0x000e700000005400ULL,
0x0000003500087306ULL, 0x0005f0000000d400ULL, 0x0000003400037306ULL, 0x000ee2000000d400ULL,
0x0000005300357245ULL, 0x004fe2000020d400ULL, 0x0000010036537824ULL, 0x000fe200078e00ffULL,
0x000000605500720bULL, 0x002fe20003f7d000ULL, 0x0001000037607824ULL, 0x000fe200078e00ffULL,
0x0000000135355812ULL, 0x000fc400078efcffULL, 0x000000765b00720bULL, 0x000fe20003fbd000ULL,
0x0000004d004e7306ULL, 0x000fe20000209400ULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000007100767245ULL, 0x000fe4000020d400ULL, 0x0000005900557245ULL, 0x000fe4000020d400ULL,
0x0000000176766812ULL, 0x000fe200078efcffULL, 0x0000004d00637306ULL, 0x0002a20000205400ULL,
0x0000000103030812ULL, 0x008fc400078efcffULL, 0x000000357635723eULL, 0x000fe400000010ffULL,
0x0000000155555812ULL, 0x000fe400078efcffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x00000057002f7306ULL, 0x000fe20000209400ULL, 0x0000004d004d7245ULL, 0x002fe4000020d400ULL,
0x0000000108084812ULL, 0x000fca00078efcffULL, 0x0000005700347306ULL, 0x000e620000205400ULL,
0x000000634e00720bULL, 0x004fe20003fdd000ULL, 0x00000100374e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x00000015004c7306ULL, 0x000fec0000209400ULL,
0x000000014d4d6812ULL, 0x000fe400078efcffULL, 0x0000001500647306ULL, 0x0004e20000205400ULL,
0x000000342f00720bULL, 0x002fe20003fbd000ULL, 0x00010000362f7824ULL, 0x000fe200078e00ffULL,
0x0000006c7334723eULL, 0x000fc800000010ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x00000058005c7306ULL, 0x000fe20000209400ULL, 0x0000001500157245ULL, 0x004fe2000020d400ULL,
0x000000343c10723cULL, 0x000b6c0000041810ULL, 0x00000058005d7306ULL, 0x0002a20000205400ULL,
0x000000644c00720bULL, 0x008fc40003f1d000ULL, 0x00000057004c7245ULL, 0x000fe4000020d400ULL,
0x0000000f513c723eULL, 0x020fe400000010ffULL, 0x000000014c4c5812ULL, 0x000fe200078efcffULL,
0x0000005400657306ULL, 0x000fe20000209400ULL, 0x0000000c523d723eULL, 0x000fe400000010ffULL,
0x0000005800587245ULL, 0x002fe4000020d400ULL, 0x00000053000c7245ULL, 0x000fc4000020d400ULL,
0x0000000115150812ULL, 0x000fe200078efcffULL, 0x0000005400687306ULL, 0x0002e20000205400ULL,
0x0000005d5c00720bULL, 0x004fe20003fbd000ULL, 0x0000003c3828723cULL, 0x000f620000041828ULL,
0x000000084c17723eULL, 0x000fca00000010ffULL, 0x00000053005a7306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x002fca000020d400ULL, 0x0000000158585812ULL, 0x000fe400078efcffULL,
0x00000053005b7306ULL, 0x000e620000205400ULL, 0x000000686500720bULL, 0x008fe40003f9d000ULL,
0x000000584d58723eULL, 0x000fca00000010ffULL, 0x0000003600097306ULL, 0x0004ec000000d400ULL,
0x0000000154544812ULL, 0x000fe400078efcffULL, 0x00000037000a7306ULL, 0x0006e2000000d400ULL,
0x000000495036723eULL, 0x004fe400000010ffULL, 0x0000005b5a00720bULL, 0x002fca0003fdd000ULL,
0x00000014002d7306ULL, 0x000fe20000209400ULL, 0x000000474f37723eULL, 0x008fe400000010ffULL,
0x0000000109092812ULL, 0x000fca00078efcffULL, 0x000000363830723cULL, 0x040f620000041830ULL,
0x0000001400487306ULL, 0x0002a20000205400ULL, 0x000000010c0c6812ULL, 0x000fe400078efcffULL,
0x000000010a0a3812ULL, 0x000fe400078efcffULL, 0x000000090c08723eULL, 0x000fe400000010ffULL,
0x0000004a3834723cULL, 0x000b620000041840ULL, 0x0000002c002e7306ULL, 0x000fe20000209400ULL,
0x0000001400147245ULL, 0x002fce000020d400ULL, 0x0000002c00167306ULL, 0x0002e20000205400ULL,
0x000000482d00720bULL, 0x004fce0003fbd000ULL, 0x0000004e00567306ULL, 0x000fe20000209400ULL,
0x0000002c002c7245ULL, 0x002fca000020d400ULL, 0x0000000114145812ULL, 0x000fe400078efcffULL,
0x0000004e00597306ULL, 0x000e620000205400ULL, 0x000000162e00720bULL, 0x008fe40003f9d000ULL,
0x000000035516723eULL, 0x000fe400000010ffULL, 0x0000004e00037245ULL, 0x000fc6000020d400ULL,
0x0000002f00577306ULL, 0x000fe40000209400ULL, 0x000000163820723cULL, 0x000b680000041820ULL,
0x000000012c2c4812ULL, 0x000fe400078efcffULL, 0x0000002f003e7306ULL, 0x0004e20000205400ULL,
0x000000595600720bULL, 0x002fe40003f1d000ULL, 0x000000541559723eULL, 0x000fc400000010ffULL,
0x0000006000157245ULL, 0x000fc6000020d400ULL, 0x00000060000f7306ULL, 0x000fe20000209400ULL,
0x0000002f002f7245ULL, 0x004fe2000020d400ULL, 0x00000058381c723cULL, 0x000b68000004181cULL,
0x0000000103030812ULL, 0x000fe400078efcffULL, 0x0000006000407306ULL, 0x020e620000205400ULL,
0x0000003e5700720bULL, 0x008fe40003fdd000ULL, 0x0000000a0309723eULL, 0x000fc400000010ffULL,
0x0000000446037810ULL, 0x000fc80007ffe0ffULL, 0x0000f6a803037811ULL, 0x000fe200078e18ffULL,
0x000000083818723cULL, 0x000b680000041818ULL, 0x000000012f2f6812ULL, 0x000fe400078efcffULL,
0x000000400f00720bULL, 0x002fe40003f5d000ULL, 0x0000002f1414723eULL, 0x000fd600000010ffULL,
0x0000000115152812ULL, 0x000fc800078efcffULL, 0x000000152c15723eULL, 0x000fce00000010ffULL,
0x000000143810723cULL, 0x000b620000041810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000003087f8cULL, 0x0202a2000c80043fULL, 0x0000000100007810ULL, 0x000fe40007ffe0ffULL,
0x0000f6a06a0a7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000aff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff077224ULL, 0x004fe200078e0009ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff275000007947ULL, 0x000fea000383ffffULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000b007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000ef9000047802ULL, 0x008fc40000000f00ULL,
0x000086e000007944ULL, 0x016fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000b00007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc8000000000bULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003000307220ULL, 0x042fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000001000107220ULL, 0x040fe20000410000ULL,
0x0000001100117220ULL, 0x000fe20000410000ULL, 0x0000003204327220ULL, 0x044fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x000fc20000410000ULL, 0x0000000000057919ULL, 0x008ee20000000000ULL,
0x0000001c1d1c723eULL, 0x000fc400000010ffULL, 0x000000181918723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fc400000010ffULL,
0x00000002ff077819ULL, 0x108fe20000011605ULL, 0x0000000178787824ULL, 0x000fe200078e0205ULL,
0x0000000205007812ULL, 0x040fe400078ec0ffULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x00000008070b7824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x040fe200078ff8ffULL,
0x00000008070d7824ULL, 0x004fe200078e00ffULL, 0x0000000900037211ULL, 0x002fe200078ff8ffULL,
0x00000008090e7824ULL, 0x000fe200078e00ffULL, 0x0000000202007810ULL, 0x040fe20007ffe0ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000000402047810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000100072037824ULL, 0x000fe200078e00ffULL,
0xfffffff80b067812ULL, 0x000fe400078ee200ULL, 0xfffffff809007812ULL, 0x000fe200078ee202ULL,
0x0000080046077824ULL, 0x000fe200078e0203ULL, 0x0000000602087810ULL, 0x000fe20007ffe0ffULL,
0x0000000805027824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x100fe200078e0207ULL, 0x000000303100723eULL, 0x000fe200000010ffULL,
0x000000100e0e7824ULL, 0x100fe200078e0207ULL, 0x0000000802097812ULL, 0x000fe200078ec0ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0207ULL, 0x000000343502723eULL, 0x000fe200000010ffULL,
0x0000001078787824ULL, 0x000fe200078e0203ULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee208ULL,
0x0000001006087824ULL, 0x000fe200078e0207ULL, 0x0000541000147816ULL, 0x100fe20000000002ULL,
0x0000000104067824ULL, 0x000fe200078e0209ULL, 0x0000763200157816ULL, 0x000fe20000000002ULL,
0x000000100c0c7824ULL, 0x000fe200078e0207ULL, 0x000000282900723eULL, 0x000fe200000010ffULL,
0x0000000109087824ULL, 0x000fe200078e0208ULL, 0x000000242502723eULL, 0x000fe200000010ffULL,
0x0000001406007388ULL, 0x0003e20000000a00ULL, 0x000000202104723eULL, 0x000fe200000010ffULL,
0x00000001090e7824ULL, 0x040fe200078e020eULL, 0x0000763200077816ULL, 0x000fe20000000002ULL,
0x00000001090a7824ULL, 0x000fe200078e020aULL, 0x00000012130d723eULL, 0x000fe200000010ffULL,
0x0000000109097824ULL, 0x000fe200078e020cULL, 0x00000010110c723eULL, 0x000fc400000010ffULL,
0x0000001e1f11723eULL, 0x000fe400000010ffULL, 0x000076321a0b7816ULL, 0x000fe4000000000dULL,
0x0000541000067816ULL, 0x002fe40000000002ULL, 0x000000323300723eULL, 0x000fe400000010ffULL,
0x000000363702723eULL, 0x000fe200000010ffULL, 0x0000000608007388ULL, 0x0003e20000000a00ULL,
0x000000262715723eULL, 0x000fc800000010ffULL, 0x000054102a147816ULL, 0x140fe40000000015ULL,
0x000076322a157816ULL, 0x000fe40000000015ULL, 0x0000541004067816ULL, 0x142fe4000000001cULL,
0x0000763204077816ULL, 0x000fca000000001cULL, 0x000000060a007388ULL, 0x0003e40000000a00ULL,
0x0000541018067816ULL, 0x142fe4000000000cULL, 0x0000763218077816ULL, 0x000fca000000000cULL,
0x0000000609007388ULL, 0x0003e40000000a00ULL, 0x0000541000067816ULL, 0x142fe40000000002ULL,
0x0000763200077816ULL, 0x000fe40000000002ULL, 0x000000ff00007306ULL, 0x000fe60000205400ULL,
0x000000060e007388ULL, 0x0003e80000000a00ULL, 0x0004001408007388ULL, 0x0005e20000000a00ULL,
0x000000ff00077306ULL, 0x002e620000209400ULL, 0x0000541022147816ULL, 0x004fc40000000011ULL,
0x0000763222157816ULL, 0x000fca0000000011ULL, 0x000400140a007388ULL, 0x0005e20000000a00ULL,
0x000000000700720bULL, 0x002fe40003f1d000ULL, 0x000000ff00007245ULL, 0x000fe4000020d400ULL,
0x000054101a0a7816ULL, 0x004fca000000000dULL, 0x0004000a09007388ULL, 0x000fe80000000a00ULL,
0x0000000100000812ULL, 0x000fe200078efcffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000780c7984ULL, 0x000e620000000c00ULL, 0x000000000006723eULL, 0x000fc400000010ffULL,
0x000000ff4600720cULL, 0x000fe20003f05270ULL, 0x0004000078147984ULL, 0x000ea80000000c00ULL,
0x0008000078107984ULL, 0x000ee80000000c00ULL, 0x000c000078187984ULL, 0x000ee20000000c00ULL,
0x3f803f80060f7831ULL, 0x002fc4000020000fULL, 0x3f803f80060e7831ULL, 0x040fe4000020000eULL,
0x3f803f80060d7831ULL, 0x040fe4000020000dULL, 0x3f803f80060c7831ULL, 0x040fe4000020000cULL,
0x3f803f8006177831ULL, 0x044fe40000200017ULL, 0x3f803f8006167831ULL, 0x040fe40000200016ULL,
0x3f803f8006157831ULL, 0x000fc40000200015ULL, 0x3f803f8006147831ULL, 0x000fe40000200014ULL,
0x3f803f800f0f7831ULL, 0x008fe40000200013ULL, 0x3f803f800e0e7831ULL, 0x000fe40000200012ULL,
0x3f803f800d0d7831ULL, 0x000fe40000200011ULL, 0x3f803f800c0c7831ULL, 0x000fe40000200010ULL,
0x3f803f8017177831ULL, 0x000fc4000020001bULL, 0x3f803f8016167831ULL, 0x000fe2000020001aULL,
0x0000000c78007388ULL, 0x000fe20000000c00ULL, 0x3f803f8015157831ULL, 0x000fe40000200019ULL,
0x3f803f8014147831ULL, 0x000fca0000200018ULL, 0x0004001478007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x000fc80000011605ULL, 0x000000740400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104007824ULL, 0x100fe200078e0205ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a0070117a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007050d7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff800007812ULL, 0x000fe200078ef805ULL,
0x0000580000067ab9ULL, 0x000fc40000000800ULL, 0x00000008720d7824ULL, 0x000fe400078e020dULL,
0x0000001000027824ULL, 0x000fe400078e0203ULL, 0x0000001075007824ULL, 0x000fc600078e0204ULL,
0x0000000002087984ULL, 0x0004e40000000c00ULL, 0x0000000500047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fe20000011600ULL, 0x00000006040472a4ULL, 0x002fe4000f8e023fULL,
0x0000000111047824ULL, 0x000fe200078e0204ULL, 0x0000002005027810ULL, 0x004fc60007ffe0ffULL,
0x0000007c07077224ULL, 0x000fe200078e0204ULL, 0x00000003ff0f7819ULL, 0x000fe20000011602ULL,
0x000000047c007c24ULL, 0x000fca000f8e02ffULL, 0x0000000700077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f4404ULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000102047824ULL, 0x140fe200078e020fULL,
0x00000040050c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010750f7824ULL, 0x000fe200078e020fULL,
0x00000007020d7812ULL, 0x000fe400078ec0ffULL, 0x0000000704077812ULL, 0x002fc400078ec0ffULL,
0x000000050f067c12ULL, 0x000fe2000f8e30ffULL, 0x00000008720d7824ULL, 0x000fe200078e020dULL,
0x0ffffff807047812ULL, 0x000fe400078ef802ULL, 0x00005a00ff0f7a19ULL, 0x000fe2000001160fULL,
0x0000000111067824ULL, 0x000fe400078e0206ULL, 0x0000001004047824ULL, 0x000fe400078e0203ULL,
0x0000007c0f0f7224ULL, 0x000fc600078e0206ULL, 0x0000000004087984ULL, 0x000e640000000c00ULL,
0x0000000f000f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000f067a11ULL, 0x000fc800078040ffULL, 0x00005d000f077a11ULL, 0x000fe400000f440eULL,
0x00000003ff0f7819ULL, 0x000fc6000001160cULL, 0x000000100d067825ULL, 0x000fe200078e0006ULL,
0x000000740f00720cULL, 0x000fc80003f06070ULL, 0x0000000806007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe200078e020fULL,
0x0000006005067810ULL, 0x002fe20007ffe0ffULL, 0x00000010750f7824ULL, 0x000fc600078e020fULL,
0x0000000702077812ULL, 0x000fe400078ec0ffULL, 0x000000050f047c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff807027812ULL, 0x000fe400078ef80cULL, 0x00005a00ff0f7a19ULL, 0x000fe2000001160fULL,
0x0000000111047824ULL, 0x000fe200078e0204ULL, 0x00000003ff0d7819ULL, 0x000fe20000011606ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x000000070c077812ULL, 0x000fe200078ec0ffULL,
0x0000007c0f0f7224ULL, 0x000fc600078e0204ULL, 0x0000000002087984ULL, 0x0002a20000000c00ULL,
0x0000000872077824ULL, 0x000fe200078e0207ULL, 0x0000000f000f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fe200078040ffULL,
0x0000000106027824ULL, 0x002fc600078e020dULL, 0x00005d000f057a11ULL, 0x000fe400000f440eULL,
0x000000740d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000702077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807027812ULL, 0x000fe200078ef806ULL,
0x0000000804007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e0203ULL, 0x0000000706057812ULL, 0x000fe200078ec0ffULL,
0x00000010750d7824ULL, 0x000fc600078e020dULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000872057824ULL, 0x000fe200078e0205ULL, 0x000000050d027c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0d7a19ULL, 0x000fc6000001160dULL, 0x0000000111027824ULL, 0x000fc800078e0202ULL,
0x0000007c0d0d7224ULL, 0x000fca00078e0202ULL, 0x0000000d000d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005c000d027a11ULL, 0x000fc800078040ffULL,
0x00005d000d037a11ULL, 0x000fca00000f4400ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff037819ULL, 0x000fe20000011602ULL, 0xffffffffff047424ULL, 0x002fc600078e00ffULL,
0x0000006f0300720cULL, 0x000fda0003f06070ULL, 0x00000002000a8824ULL, 0x000fc800078e00ffULL,
0x000068000a0a8a24ULL, 0x000fc800078e0203ULL, 0x000064000a0a8625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff087624ULL, 0x000fe200078e00ffULL,
0x000000080a048981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff097624ULL, 0x000fc600078e00ffULL,
0x00f60000ff067f8cULL, 0x000e68000c80043fULL, 0x0000000808087981ULL, 0x000722000c1e9900ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000008070707824ULL, 0x000fe400078e00ffULL,
0x0000004002797824ULL, 0x000fe400078e00ffULL, 0x000000800e757824ULL, 0x000fc600078e00ffULL,
0x0000004070197812ULL, 0x000fe200078ef879ULL, 0x0000007504257224ULL, 0x004fc800078e02ffULL,
0x0000062000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x00afe40000011644ULL,
0x0000620025237a11ULL, 0x000fe400078038ffULL, 0x000000081e1a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001190a7824ULL, 0x040fe200078e021eULL, 0x000000101e207810ULL, 0x040fe40007ffe0ffULL,
0x000000181e227810ULL, 0x000fe20007ffe0ffULL, 0x00000001190c7824ULL, 0x000fe200078e021aULL,
0x0000630025257a11ULL, 0x000fe200000f3cffULL, 0x00000001190e7824ULL, 0x000fe200078e0220ULL,
0x00001000021d7811ULL, 0x000fe200078e68ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000201e187810ULL, 0x000fc40007ffe0ffULL, 0x000000301e1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119107824ULL, 0x000fe200078e0222ULL, 0x000000300c147812ULL, 0x000fe200078ef805ULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x0000002314147210ULL, 0x000fe20007f3e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000300a127812ULL, 0x000fc600078ef805ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000300e0a7812ULL, 0x000fe400078ef805ULL,
0x000000796d0e7217ULL, 0x000fe20007800000ULL, 0x000000010d157824ULL, 0x000fe200008e0625ULL,
0x00000030100c7812ULL, 0x000fe200078ef805ULL, 0x0000000119167824ULL, 0x000fe200078e0218ULL,
0x0000004444107211ULL, 0x000fe200078fe8ffULL, 0x000000010e097824ULL, 0x000fe200078e0a79ULL,
0x000000230c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000041c267824ULL, 0x000fe200078e00ffULL,
0x00000003101b7812ULL, 0x000fe200078ec0ffULL, 0x000000041a107824ULL, 0x040fe200078e00ffULL,
0x0000001223127210ULL, 0x000fe20007f1e0ffULL, 0x00000001110d7824ULL, 0x000fe200008e0625ULL,
0x000000091a00720cULL, 0x000fc40003f26070ULL, 0x000000281e1a7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b137824ULL, 0x000fe200000e0625ULL, 0xfffffffc10107812ULL, 0x000fe400078ee21bULL,
0x000000230a0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000119117824ULL, 0x000fe200078e021aULL,
0x0ffffffc1b447812ULL, 0x000fe200078ef844ULL, 0x0000001010217824ULL, 0x000fe200078e021dULL,
0x000000092200720cULL, 0x080fe20003f86070ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x000000092000720cULL, 0x000fc40003fa6070ULL, 0x000000091800720cULL, 0x080fe20003f66070ULL,
0x000000010f0b7824ULL, 0x000fe200000e0625ULL, 0x000000091e00720cULL, 0x000fe20003f06070ULL,
0x00000080160e7825ULL, 0x000fe200078e00ffULL, 0x0000003010167812ULL, 0x000fe400078ef805ULL,
0x000000381e1e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010441f7824ULL, 0x000fe200078e021dULL,
0x0000002316167210ULL, 0x000fe20007fde0ffULL, 0x0000000119107824ULL, 0x000fe200078e021cULL,
0x000000300e0e7812ULL, 0x000fe200078ef805ULL, 0x0000000422227824ULL, 0x000fc400078e00ffULL,
0x0000000111177824ULL, 0x000fe200030e0625ULL, 0x000000230e0e7210ULL, 0x000fe20007f5e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121f7faeULL, 0x0003e2000c101c48ULL, 0x000000091e00720cULL, 0x080fe40003f06070ULL,
0x000000041a247824ULL, 0x000fe200078e00ffULL, 0x0000000014217faeULL, 0x0005e2000c901c48ULL,
0x0000003010107812ULL, 0x000fe200078ef805ULL, 0x000000010f0f7824ULL, 0x000fe200010e0625ULL,
0x000000091a00720cULL, 0x000fe20003f46070ULL, 0x000000041e287824ULL, 0x000fe200078e00ffULL,
0x0000002310107210ULL, 0x000fc40007fde0ffULL, 0x000000091c00720cULL, 0x000fe20003f26070ULL,
0x0000000119127824ULL, 0x002fe200078e021eULL, 0xfffffffc241c7812ULL, 0x000fe200078ee21bULL,
0x0000000111117824ULL, 0x000fe200030e0625ULL, 0xfffffffc261e7812ULL, 0x000fe200078ee21bULL,
0x0000000420147824ULL, 0x004fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffffc14147812ULL, 0x000fe200078ee21bULL, 0x0000000418207824ULL, 0x000fe200078e00ffULL,
0x0000003012057812ULL, 0x000fe200078ef805ULL, 0x000000101c197824ULL, 0x000fe200078e021dULL,
0xfffffffc22187812ULL, 0x100fe400078ee21bULL, 0xfffffffc201a7812ULL, 0x000fe400078ee21bULL,
0x0000002305127210ULL, 0x000fe20007fde0ffULL, 0x0000001014057824ULL, 0x000fe200078e021dULL,
0xfffffffc28207812ULL, 0x000fe200078ee21bULL, 0x0000001018097824ULL, 0x000fc400078e021dULL,
0x000000101a157824ULL, 0x100fe200078e021dULL, 0x000000000a057faeULL, 0x0003e2000e901c48ULL,
0x000000101e1b7824ULL, 0x100fe400078e021dULL, 0x00000010201d7824ULL, 0x000fe200078e021dULL,
0x000000000c097faeULL, 0x0003e2000e101c48ULL, 0x0000000113137824ULL, 0x000fc600030e0625ULL,
0x000000000e157faeULL, 0x0003e8000d901c48ULL, 0x0000000016197faeULL, 0x0003e8000d101c48ULL,
0x00000000101b7faeULL, 0x0003e8000c901c48ULL, 0x00000000121d7faeULL, 0x0003e2000c101c48ULL,
0x0000056000007947ULL, 0x000fea0003800000ULL, 0x0000004444097211ULL, 0x04afe400078fe8ffULL,
0x0000000844187811ULL, 0x000fc400078ff0ffULL, 0x00000019440a7211ULL, 0x040fe400078ff0ffULL,
0x00000003091b7812ULL, 0x000fe200078ec0ffULL, 0x0000000119097824ULL, 0x040fe200078e0218ULL,
0x00000010440c7811ULL, 0x000fe200078ff0ffULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x0000003044147811ULL, 0x000fe200078ff0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x00000018440e7811ULL, 0x040fe400078ff0ffULL, 0x0000002044107811ULL, 0x040fe200078ff0ffULL,
0x00000001190d7824ULL, 0x000fe200078e020cULL, 0x0000003844167811ULL, 0x000fe200078ff0ffULL,
0x000000040c1a7824ULL, 0x000fe200078e00ffULL, 0x0000620025297a11ULL, 0x000fe200078038ffULL,
0x0000000414227824ULL, 0x000fe200078e00ffULL, 0x0000002844127811ULL, 0x000fe200078ff0ffULL,
0x000000040e1c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc180c7812ULL, 0x000fe200078ee21bULL,
0x00000004101e7824ULL, 0x000fe200078e00ffULL, 0x000000300a187812ULL, 0x000fe200078ef805ULL,
0x0000000119177824ULL, 0x000fe200078e0216ULL, 0x00006300252b7a11ULL, 0x000fe200000f3cffULL,
0x0000000412207824ULL, 0x000fe200078e00ffULL, 0x0000100002277811ULL, 0x000fe200078e68ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0xfffffffc220a7812ULL, 0x100fe200078ee21bULL,
0x00000001190f7824ULL, 0x000fe200078e020eULL, 0x0000001829187210ULL, 0x000fe20007f1e0ffULL,
0x0000000119117824ULL, 0x040fe200078e0210ULL, 0xfffffffc1a0e7812ULL, 0x100fe200078ee21bULL,
0x0000000119137824ULL, 0x040fe200078e0212ULL, 0xfffffffc1c107812ULL, 0x100fe200078ee21bULL,
0x0000000119157824ULL, 0x000fe200078e0214ULL, 0xfffffffc1e127812ULL, 0x000fe200078ee21bULL,
0x000000100a257824ULL, 0x000fe200078e0227ULL, 0x0ffffffc1b447812ULL, 0x000fe200078ef844ULL,
0x000000010b197824ULL, 0x000fe200000e062bULL, 0xfffffffc20147812ULL, 0x100fe200078ee21bULL,
0x00000080090a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc16167812ULL, 0x000fc600078ee21bULL,
0x000000100c1b7824ULL, 0x000fe200078e0227ULL, 0x000000300a0a7812ULL, 0x000fe200078ef805ULL,
0x000000100e1d7824ULL, 0x000fe400078e0227ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000000a290a7210ULL, 0x000fc60007f1e0ffULL, 0x00000010101f7824ULL, 0x000fe200078e0227ULL,
0x000000300c0c7812ULL, 0x000fe200078ef805ULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0x0000000c290c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001012217824ULL, 0x000fe200078e0227ULL,
0x000000300e0e7812ULL, 0x000fe200078ef805ULL, 0x0000008011107825ULL, 0x000fc600078e00ffULL,
0x0000000e290e7210ULL, 0x000fe20007f5e0ffULL, 0x00000010442d7824ULL, 0x000fe200078e0227ULL,
0x0000003010107812ULL, 0x000fe200078ef805ULL, 0x0000001014237824ULL, 0x100fe400078e0227ULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x0000001029107210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000182d7faeULL, 0x0003e4000b901c48ULL,
0x0000001016277824ULL, 0x000fe200078e0227ULL, 0x0000003012127812ULL, 0x000fe200078ef805ULL,
0x0000008015147825ULL, 0x000fc600078e00ffULL, 0x0000001229127210ULL, 0x000fe20007f9e0ffULL,
0x0000008017167825ULL, 0x000fe200078e00ffULL, 0x0000003014147812ULL, 0x000fc600078ef805ULL,
0x000000010b0b7824ULL, 0x000fe200000e062bULL, 0x0000003016057812ULL, 0x000fe200078ef805ULL,
0x000000010d0d7824ULL, 0x100fe200008e062bULL, 0x0000001429147210ULL, 0x000fe20007fbe0ffULL,
0x000000010f0f7824ULL, 0x100fe200010e062bULL, 0x0000000529167210ULL, 0x000fe20007fde0ffULL,
0x0000000111117824ULL, 0x100fe200018e062bULL, 0x000000000a1b7faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x100fe400020e062bULL, 0x0000000115157824ULL, 0x100fe200028e062bULL,
0x000000000c1d7faeULL, 0x0003e2000b901c48ULL, 0x0000000117177824ULL, 0x000fc600030e062bULL,
0x000000000e1f7faeULL, 0x0003e8000b901c48ULL, 0x0000000010217faeULL, 0x0003e8000b901c48ULL,
0x0000000012237faeULL, 0x0003e8000b901c48ULL, 0x0000000014257faeULL, 0x0003e8000b901c48ULL,
0x0000000016277faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000a7805ULL, 0x002fc40000015200ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140dULL, 0x0000000c05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e060dULL, 0x0000000205057819ULL, 0x000fc8000000120cULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002002057824ULL, 0x002fca00078e0205ULL, 0x00000003ff067819ULL, 0x000fc80000011605ULL,
0x1ffffffe060a7812ULL, 0x000fe400078ec0ffULL, 0x0000000f05067812ULL, 0x000fc600078ec0ffULL,
0x00000001050a7824ULL, 0x000fe400078e020aULL, 0x00000010060c7824ULL, 0x040fe400078e00ffULL,
0x0000001006077824ULL, 0x000fe200078e00ffULL, 0x0000000f0a057812ULL, 0x040fe400078ec0ffULL,
0x000000010a0a7810ULL, 0x000fe40007ffe0ffULL, 0x000000f00c057812ULL, 0x000fe400078ee205ULL,
0x0000000f0a0a7812ULL, 0x000fc600078ec0ffULL, 0x0000000005107984ULL, 0x000e62000000cc00ULL,
0x000000f0070a7812ULL, 0x000fca00078ee20aULL, 0x000000000a0c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001405007388ULL, 0x0003e8000000cc00ULL, 0x000000100a007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff0c7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff097224ULL, 0x000fc600078e00ffULL, 0x0000000000067805ULL, 0x000fc80000015200ULL,
0x00f60400ff057984ULL, 0x002e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6e00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00005800ff717624ULL, 0x000fe200078e00ffULL, 0x800058006d767a10ULL, 0x000fe20007ffe0ffULL,
0x0000680000747a24ULL, 0x000fe200078e02ffULL, 0x3db504f308067820ULL, 0x010fe20000410000ULL,
0x0000f68802787811ULL, 0x000fe200078e18ffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000001f71007810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0xffffffff71777810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff007819ULL, 0x000fc40000011600ULL,
0x0000f608027a7811ULL, 0x000fe400078e28ffULL, 0x0000000971717810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff767819ULL, 0x000fe40000011676ULL, 0x0ffffffe00727812ULL, 0x000fc400078ec0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff097224ULL, 0x000fe200078e0008ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x01cfc4000001ff00ULL, 0x000000010a00780cULL, 0x000fe20003f25270ULL,
0x00000c2000007945ULL, 0x000fe20003800000ULL, 0x0000000107007810ULL, 0x000fe20007ffe0ffULL,
0x00000075043c7224ULL, 0x030fe200078e02ffULL, 0x000000010a0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000109087812ULL, 0x000fe400078e0cffULL, 0x000000020c00780cULL, 0x000fca0003f06070ULL,
0x000000ffff001224ULL, 0x000fc800078e0207ULL, 0x00000100003a7824ULL, 0x040fe200078e0279ULL,
0x00000001000b7810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0c007207ULL, 0x000fe40000800000ULL,
0x0000006e0b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff0b7224ULL, 0x000fe200078e000aULL,
0x000000403a0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0a7224ULL, 0x000fc800078e000cULL,
0x0000000170387824ULL, 0x000fcc00078e020dULL, 0x000005f00000a947ULL, 0x000fea0003800000ULL,
0x00000010050d7824ULL, 0x002fe200078e00ffULL, 0x0000003a6d0c7217ULL, 0x000fe20007800000ULL,
0x00000002023e7824ULL, 0x000fe200078e0208ULL, 0x00000002ff457819ULL, 0x000fe40000011605ULL,
0x000000300d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000010c3a7824ULL, 0x000fe200078e0a3aULL,
0x0000001845477810ULL, 0x040fe20007ffe0ffULL, 0x00000001450f7824ULL, 0x140fe200078e0238ULL,
0x00000008453f7810ULL, 0x040fe20007ffe0ffULL, 0x00000040000c7824ULL, 0x000fe200078e020dULL,
0x000062003c3b7a11ULL, 0x040fe200078238ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000001045417810ULL, 0x000fe20007ffe0ffULL, 0x00000001473d7824ULL, 0x000fe200078e0238ULL,
0x000063003c397a11ULL, 0x000fe200008f3cffULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x00000028454b7810ULL, 0x000fc40007ffe0ffULL, 0x0000002045497810ULL, 0x000fe20007ffe0ffULL,
0x000000013f197824ULL, 0x100fe200078e0238ULL, 0x0000003b0e1c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001411f7824ULL, 0x000fe200078e0238ULL, 0x000010003e3e7811ULL, 0x000fe200078e60ffULL,
0x000000803d3c7825ULL, 0x100fe200078e000cULL, 0x00000030454d7810ULL, 0x000fe40007ffe0ffULL,
0x0000003a4700720cULL, 0x000fe20003fa6070ULL, 0x0000008019187825ULL, 0x000fc800078e000cULL,
0x000000801f1e7825ULL, 0x000fe200078e000cULL, 0x0000003b181a7210ULL, 0x000fe40007f5e0ffULL,
0x0000000505187211ULL, 0x000fe200078fe8ffULL, 0x000000010f1d7824ULL, 0x100fe200008e0639ULL,
0x0000003b3c0e7210ULL, 0x080fe20007f3e0ffULL, 0x00000001191b7824ULL, 0x100fe200010e0639ULL,
0x0000003b1e1e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000441437824ULL, 0x000fe200078e00ffULL,
0x0000000318407812ULL, 0x000fe200078ec0ffULL, 0x000000013d0f7824ULL, 0x100fe200008e0639ULL,
0x0000003a4500720cULL, 0x080fe20003f26070ULL, 0x000000043f3d7824ULL, 0x040fe200078e00ffULL,
0x0000003a3f00720cULL, 0x080fe20003f46070ULL, 0x000000011f1f7824ULL, 0x000fe200018e0639ULL,
0x0000003a4100720cULL, 0x000fe20003f66070ULL, 0x0000000149197824ULL, 0x000fe200078e0238ULL,
0x0ffffffc403f7812ULL, 0x000fc400078ef805ULL, 0xfffffffc3d417812ULL, 0x000fe200078ee240ULL,
0x000000014b3d7824ULL, 0x000fe200078e0238ULL, 0xfffffffc43437812ULL, 0x000fe200078ee240ULL,
0x000000103f3f7824ULL, 0x100fe200078e023eULL, 0x0000003845457810ULL, 0x000fe20007ffe0ffULL,
0x0000001041417824ULL, 0x000fe400078e023eULL, 0x000000803d3c7825ULL, 0x100fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c3f7faeULL, 0x0003e2000c901c48ULL,
0x0000003a4500720cULL, 0x080fe40003f26070ULL, 0x0000008019187825ULL, 0x000fe200078e000cULL,
0x000000001a417faeULL, 0x0005e2000d101c48ULL, 0x0000003a4d00720cULL, 0x000fc40003f46070ULL,
0x0000001043437824ULL, 0x000fe200078e023eULL, 0x0000003b18187210ULL, 0x000fe20007f9e0ffULL,
0x000000014d1d7824ULL, 0x002fc600078e0238ULL, 0x000000001e437faeULL, 0x0003e2000d901c48ULL,
0x00000001453f7824ULL, 0x000fe200078e0238ULL, 0x0000003a4b00720cULL, 0x000fe20003f66070ULL,
0x000000801d1c7825ULL, 0x000fe200078e000cULL, 0x0000003b3c1a7210ULL, 0x004fc60007fde0ffULL,
0x000000803f0c7825ULL, 0x000fc800078e000cULL, 0x000000013d1b7824ULL, 0x100fe200030e0639ULL,
0x0000003b1c1c7210ULL, 0x080fe20007fde0ffULL, 0x00000004471f7824ULL, 0x002fe400078e00ffULL,
0x00000004493d7824ULL, 0x000fe400078e00ffULL, 0x0000000119197824ULL, 0x100fe200020e0639ULL,
0x0000003a4900720cULL, 0x000fe20003f86070ULL, 0x000000044b3f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1f1f7812ULL, 0x100fe200078ee240ULL, 0x000000044d417824ULL, 0x000fe200078e00ffULL,
0xfffffffc3d3d7812ULL, 0x100fe200078ee240ULL, 0x0000000445437824ULL, 0x000fe200078e00ffULL,
0xfffffffc3f3f7812ULL, 0x100fe200078ee240ULL, 0x000000011d1d7824ULL, 0x000fe200030e0639ULL,
0xfffffffc41417812ULL, 0x000fe200078ee240ULL, 0x000000101f1f7824ULL, 0x000fe200078e023eULL,
0xfffffffc43437812ULL, 0x000fe200078ee240ULL, 0x000000103d3d7824ULL, 0x100fe200078e023eULL,
0x0000003b0c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000103f3b7824ULL, 0x100fe200078e023eULL,
0x000000000e1f7faeULL, 0x0003e2000e901c48ULL, 0x00000010413f7824ULL, 0x000fc400078e023eULL,
0x0000001043417824ULL, 0x000fe200078e023eULL, 0x00000000183d7faeULL, 0x0003e2000e101c48ULL,
0x000000010d0d7824ULL, 0x000fc600030e0639ULL, 0x000000001a3b7faeULL, 0x0003e8000d901c48ULL,
0x000000001c3f7faeULL, 0x0003e8000d101c48ULL, 0x000000000c417faeULL, 0x0003e2000c901c48ULL,
0x0000053000007947ULL, 0x000fea0003800000ULL, 0x00000002020f7824ULL, 0x000fe200078e0208ULL,
0x00000008051b7811ULL, 0x042fe200078ff0ffULL, 0x00000010050c7824ULL, 0x040fe200078e00ffULL,
0x00000010051d7811ULL, 0x000fc400078ff0ffULL, 0x00000018051f7811ULL, 0x000fe200078ff0ffULL,
0x000000011b197824ULL, 0x100fe200078e0238ULL, 0x0000002005397811ULL, 0x000fe200078ff0ffULL,
0x000000041d3f7824ULL, 0x000fe200078e00ffULL, 0x00000028053b7811ULL, 0x000fe200078ff0ffULL,
0x000000041f417824ULL, 0x000fe200078e00ffULL, 0x000010000f4b7811ULL, 0x000fe200078e60ffULL,
0x000000041b0f7824ULL, 0x000fe200078e00ffULL, 0x00000030053d7811ULL, 0x000fe200078ff0ffULL,
0x000000011d1b7824ULL, 0x100fe200078e0238ULL, 0x0000003805497811ULL, 0x000fe200078ff0ffULL,
0x000000011f1d7824ULL, 0x100fe200078e0238ULL, 0x00000005050e7211ULL, 0x000fe200078fe8ffULL,
0x00000001391f7824ULL, 0x140fe200078e0238ULL, 0x000000300c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000439437824ULL, 0x000fe200078e00ffULL, 0x000000030e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000013b397824ULL, 0x040fe200078e0238ULL, 0x000062003c4d7a11ULL, 0x000fe200078238ffULL,
0x000000043b457824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f187812ULL, 0x000fe200078ee20eULL,
0x000000013d3b7824ULL, 0x000fe200078e0238ULL, 0xfffffffc3f1a7812ULL, 0x100fe200078ee20eULL,
0x000000043d3d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc411c7812ULL, 0x100fe200078ee20eULL,
0x0000000449477824ULL, 0x000fe200078e00ffULL, 0xfffffffc431e7812ULL, 0x100fe200078ee20eULL,
0x00000040000c7824ULL, 0x000fe200078e020dULL, 0xfffffffc453a7812ULL, 0x100fe200078ee20eULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0xfffffffc3d3e7812ULL, 0x000fe200078ee20eULL,
0x0000000149497824ULL, 0x000fe200078e0238ULL, 0xfffffffc47407812ULL, 0x000fe200078ee20eULL,
0x00000010183d7824ULL, 0x000fe200078e024bULL, 0x0ffffffc0e0e7812ULL, 0x000fe200078ef805ULL,
0x000000101a3f7824ULL, 0x100fe200078e024bULL, 0x00000038050f7211ULL, 0x000fe200078ff0ffULL,
0x000000101c417824ULL, 0x000fc400078e024bULL, 0x000000100e4f7824ULL, 0x000fe400078e024bULL,
0x000000800f0e7825ULL, 0x000fc800078e000cULL, 0x000000101e437824ULL, 0x100fe400078e024bULL,
0x000000103a457824ULL, 0x000fe400078e024bULL, 0x0000008019187825ULL, 0x000fc800078e000cULL,
0x000000801b1a7825ULL, 0x000fe200078e000cULL, 0x0000004d18187210ULL, 0x000fc60007f5e0ffULL,
0x000000801d1c7825ULL, 0x000fe200078e000cULL, 0x0000004d1a1a7210ULL, 0x000fc60007f7e0ffULL,
0x000000801f1e7825ULL, 0x000fe200078e000cULL, 0x0000004d1c1c7210ULL, 0x000fc60007f9e0ffULL,
0x0000008039387825ULL, 0x000fc800078e000cULL, 0x000000803b3a7825ULL, 0x000fc800078e000cULL,
0x00000080490c7825ULL, 0x000fe200078e000cULL, 0x000063003c497a11ULL, 0x000fe400008f3cffULL,
0x0000004d0e0e7210ULL, 0x080fe20007f3e0ffULL, 0x000000103e477824ULL, 0x000fe400078e024bULL,
0x0000000119197824ULL, 0x100fe200010e0649ULL, 0x0000004d38387210ULL, 0x080fe20007f5e0ffULL,
0x000000010f0f7824ULL, 0x100fe200008e0649ULL, 0x0000004d1e1e7210ULL, 0x080fe20007f3e0ffULL,
0x000000011b1b7824ULL, 0x100fe200018e0649ULL, 0x0000004d3a3a7210ULL, 0x080fe20007f7e0ffULL,
0x000000011d1d7824ULL, 0x100fe200020e0649ULL, 0x0000004d0c0c7210ULL, 0x000fe20007f9e0ffULL,
0x000000011f1f7824ULL, 0x100fe200008e0649ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e4f7faeULL, 0x0003e2000b901c48ULL, 0x0000000139397824ULL, 0x000fc400010e0649ULL,
0x000000013b3b7824ULL, 0x000fe200018e0649ULL, 0x00000000183d7faeULL, 0x0003e2000b901c48ULL,
0x00000010404b7824ULL, 0x000fe400078e024bULL, 0x000000010d0d7824ULL, 0x000fe200020e0649ULL,
0x000000001a3f7faeULL, 0x0003e8000b901c48ULL, 0x000000001c417faeULL, 0x0003e8000b901c48ULL,
0x000000001e437faeULL, 0x0003e8000b901c48ULL, 0x0000000038457faeULL, 0x0003e8000b901c48ULL,
0x000000003a477faeULL, 0x0003e8000b901c48ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000203037810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff047424ULL, 0x000fc600078e00ffULL,
0x0000006f0300720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x00000002740c7824ULL, 0x002fe400078e0203ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000064000c0c7625ULL, 0x000fca00078e000dULL, 0x000000080c047981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff805007812ULL, 0x040fe200078ec0ffULL, 0x0000000202647824ULL, 0x000fe200078e0209ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000010c507810ULL, 0x000fe40007ffe0ffULL,
0x0000000700007812ULL, 0x000fe400078ef805ULL, 0x0000100064647811ULL, 0x000fe400078e60ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011600ULL, 0x00000004000f7824ULL, 0x040fe200078e00ffULL,
0x0000002005627810ULL, 0x000fe20007ffe0ffULL, 0x0000000400007824ULL, 0x000fc400078e00ffULL,
0x000000010d0e7824ULL, 0x040fe200078e020cULL, 0xfffffff862627812ULL, 0x000fe200078ec0ffULL,
0x000000010d0d7824ULL, 0x000fc600078e0250ULL, 0xfffffffc0f0f7812ULL, 0x000fe400078ee20eULL,
0xfffffffc000d7812ULL, 0x000fe400078ee20dULL, 0x0000000762627812ULL, 0x000fe200078ef805ULL,
0x000000100f0f7824ULL, 0x100fe400078e0264ULL, 0x000000100d0d7824ULL, 0x000fe200078e0264ULL,
0x00000001ff657819ULL, 0x000fe40000011662ULL, 0x000000000f44783bULL, 0x000e660000000200ULL,
0x0000000165007824ULL, 0x040fe200078e020cULL, 0x000000000d1c783bULL, 0x0205e20000000200ULL,
0x0000000165657824ULL, 0x000fc400078e0250ULL, 0x00000004620d7824ULL, 0x044fe400078e00ffULL,
0x0000000462627824ULL, 0x000fc600078e00ffULL, 0xfffffffc0d0d7812ULL, 0x000fca00078ee200ULL,
0x000000100d3c7824ULL, 0x000fcc00078e0264ULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x0000004400677306ULL, 0x002fe20000009400ULL, 0x00010000441a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011444ULL, 0x00000018ff637819ULL, 0x000fe40000011445ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000004400687306ULL, 0x000e620000005400ULL,
0x00000018ff597819ULL, 0x000fc40000011446ULL, 0x00000018ff407819ULL, 0x000fca0000011447ULL,
0x0000004600667306ULL, 0x000ff00000009400ULL, 0x0000004600497306ULL, 0x000ee20000005400ULL,
0x000000686700720bULL, 0x002fe40003fbd000ULL, 0x0000001a00677245ULL, 0x000fe2000020d400ULL,
0x000001003d6a7824ULL, 0x004fc800078e00ffULL, 0x0000004700437306ULL, 0x000fe20000009400ULL,
0x00000018ff6a7819ULL, 0x000fce000001146aULL, 0x00000047004a7306ULL, 0x000e620000005400ULL,
0x000000496600720bULL, 0x008fe20003f5d000ULL, 0x000000040b497824ULL, 0x000fe200078e020cULL,
0x0000000705667812ULL, 0x000fe400078ec0ffULL, 0x000000020c0c7810ULL, 0x000fc60007ffe0ffULL,
0x0000001a00617306ULL, 0x000ff00000209400ULL, 0x0000001a00687306ULL, 0x000ea20000205400ULL,
0x0000004a4300720bULL, 0x002fe20003f3d000ULL, 0x00000002494a7824ULL, 0x000fe200078e00ffULL,
0x0000000866497812ULL, 0x000fc800078ef805ULL, 0x0000004a05667211ULL, 0x000fe200078fe0ffULL,
0x00000045005f7306ULL, 0x000fe20000009400ULL, 0x0000001049437824ULL, 0x040fe200078e00ffULL,
0x000000024a4a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000149667824ULL, 0x000fe400078e0266ULL,
0x0000004a054a7211ULL, 0x000fe400078fe0ffULL, 0x00000045005e7306ULL, 0x000e620000005400ULL,
0x000000686100720bULL, 0x004fe20003f9d000ULL, 0x0001000045617824ULL, 0x000fe200078e00ffULL,
0xfffffff043667812ULL, 0x000fc800078ee266ULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000004e001b7306ULL, 0x000fe20000209400ULL, 0x00000010661a7824ULL, 0x000fe400078e00ffULL,
0x0000010045667824ULL, 0x000fc600078e00ffULL, 0x0000000167674812ULL, 0x000fe400078efcffULL,
0x0000004e00607306ULL, 0x000ea20000205400ULL, 0x0000005e5f00720bULL, 0x002fe40003f7d000ULL,
0x00000018ff667819ULL, 0x000fca0000011466ULL, 0x0000006300187306ULL, 0x000ff00000209400ULL,
0x0000006300197306ULL, 0x000e620000205400ULL, 0x000000601b00720bULL, 0x004fce0003fdd000ULL,
0x0000004400387306ULL, 0x0004e2000000d400ULL, 0x000000191800720bULL, 0x002fe20003f9d000ULL,
0x0000010044447824ULL, 0x004fe200078e00ffULL, 0x000000001a18783bULL, 0x000e6a0000000200ULL,
0x0000006100607306ULL, 0x000fe20000209400ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000000138385812ULL, 0x008fca00078efcffULL, 0x00000044005f7306ULL, 0x000fe20000209400ULL,
0x000000386738723eULL, 0x000fe400000010ffULL, 0x0000006100677245ULL, 0x000fca000020d400ULL,
0x0000004400687306ULL, 0x0004f00000205400ULL, 0x0000006100697306ULL, 0x0006620000205400ULL,
0x0000004400447245ULL, 0x004fe4000020d400ULL, 0x000000685f00720bULL, 0x008fca0003fbd000ULL,
0x0000005900397306ULL, 0x000fe20000209400ULL, 0x0001000046617824ULL, 0x000fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000005900547306ULL, 0x000ea20000205400ULL,
0x0000000144445812ULL, 0x000fe400078efcffULL, 0x000000696000720bULL, 0x002fe40003fbd000ULL,
0x0000004e00697245ULL, 0x000fc6000020d400ULL, 0x0000004500427306ULL, 0x000e62000000d400ULL,
0x0000000169696812ULL, 0x000fe400078efcffULL, 0x000000543900720bULL, 0x004fca0003fdd000ULL,
0x0000006600457306ULL, 0x000fe20000209400ULL, 0x000000446939723eULL, 0x000fe400000010ffULL,
0x0000000167675812ULL, 0x000fe400078efcffULL, 0xfffffffc62697812ULL, 0x000fe400078ee265ULL,
0x00000018ff547819ULL, 0x000fe2000001141cULL, 0x000000381830723cULL, 0x000be20000041830ULL,
0x0000006600687306ULL, 0x000ea20000205400ULL, 0x0000000142423812ULL, 0x002fe200078efcffULL,
0x0000001069647824ULL, 0x000fc800078e0264ULL, 0x0000010046387824ULL, 0x020fe200078e00ffULL,
0x0000006600397245ULL, 0x000fe2000020d400ULL, 0x0000004600587306ULL, 0x0002e2000000d400ULL,
0x000000684500720bULL, 0x004fce0003fbd000ULL, 0x0000006100507306ULL, 0x000fe20000209400ULL,
0x0000006300467245ULL, 0x002fe2000020d400ULL, 0x000100003d687824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011438ULL, 0x000000426738723eULL, 0x000fe200000010ffULL,
0x0001000047427824ULL, 0x000fe200078e00ffULL, 0x0000000146464812ULL, 0x000fe200078efcffULL,
0x0000006300627306ULL, 0x000fe20000209400ULL, 0x0000000158582812ULL, 0x008fe400078efcffULL,
0x00000018ff427819ULL, 0x000fc40000011442ULL, 0x0000000139395812ULL, 0x000fe400078efcffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000006300677306ULL, 0x000e620000205400ULL,
0x000000394639723eULL, 0x000fce00000010ffULL, 0x0000006100657306ULL, 0x0004e20000205400ULL,
0x000000381834723cULL, 0x000bee0000041834ULL, 0x00000040003a7306ULL, 0x000fe20000209400ULL,
0x000000676200720bULL, 0x002fe20003f9d000ULL, 0x0000010047627824ULL, 0x000fe200078e00ffULL,
0x0000006100617245ULL, 0x004fc8000020d400ULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x00000040003b7306ULL, 0x0002a20000205400ULL, 0x000000655000720bULL, 0x008fe40003fbd000ULL,
0x00000018ff507819ULL, 0x000fca000001141dULL, 0x0000004200467306ULL, 0x000fe20000209400ULL,
0x0000004000407245ULL, 0x002fca000020d400ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x0000004200697306ULL, 0x000e620000205400ULL, 0x0000003b3a00720bULL, 0x004fe40003f7d000ULL,
0x000000006438783bULL, 0x0204e20000000200ULL, 0x000000586158723eULL, 0x000fc800000010ffULL,
0x0000006200667306ULL, 0x000fe20000209400ULL, 0x0000005900647245ULL, 0x004fe4000020d400ULL,
0x0000006300597245ULL, 0x000fe4000020d400ULL, 0x0000000164646812ULL, 0x000fc600078efcffULL,
0x0000006200677306ULL, 0x000ea20000205400ULL, 0x0000000159594812ULL, 0x000fe400078efcffULL,
0x000000694600720bULL, 0x002fe40003f5d000ULL, 0x000000596459723eULL, 0x000fe400000010ffULL,
0x0000000140403812ULL, 0x000fe200078efcffULL, 0x00000047000f7306ULL, 0x000e62000000d400ULL,
0x00000018ff697819ULL, 0x000fe4000001143dULL, 0x00000018ff467819ULL, 0x000fe2000001141eULL,
0x000000581828723cULL, 0x000be20000041828ULL, 0x000000676600720bULL, 0x004fc60003f9d000ULL,
0x0000003c005d7306ULL, 0x000fe60000009400ULL, 0x0000004200587245ULL, 0x020fe4000020d400ULL,
0x0000006200597245ULL, 0x000fe4000020d400ULL, 0x0000000158582812ULL, 0x000fe400078efcffULL,
0x000000010f0f1812ULL, 0x002fe200078efcffULL, 0x0000003c00527306ULL, 0x000e620000005400ULL,
0x0000000159594812ULL, 0x000fc400078efcffULL, 0x0000000f5858723eULL, 0x000fe400000010ffULL,
0x000000594059723eULL, 0x000fc600000010ffULL, 0x0000001c005c7306ULL, 0x000fe80000009400ULL,
0x000000581810723cULL, 0x000b680000041810ULL, 0x0000001c00577306ULL, 0x000ea20000005400ULL,
0x000000525d00720bULL, 0x002fe40003f5d000ULL, 0x000100003c587824ULL, 0x020fca00078e00ffULL,
0x0000001d004f7306ULL, 0x000fe20000009400ULL, 0x00000018ff587819ULL, 0x000fce0000011458ULL,
0x0000001d005a7306ULL, 0x000e620000005400ULL, 0x000000575c00720bULL, 0x004fe20003f3d000ULL,
0x000001003c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fc8000001143cULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000005800597306ULL, 0x000ff00000209400ULL,
0x0000005800527306ULL, 0x000ea20000205400ULL, 0x0000005a4f00720bULL, 0x002fce0003fbd000ULL,
0x0000001e005b7306ULL, 0x000ff00000009400ULL, 0x0000001e00557306ULL, 0x000e620000005400ULL,
0x000000525900720bULL, 0x004fe40003f9d000ULL, 0x0000005800527245ULL, 0x000fe2000020d400ULL,
0x000100003e587824ULL, 0x000fc800078e00ffULL, 0x0000003d00567306ULL, 0x000fe20000009400ULL,
0x00000018ff587819ULL, 0x000fca0000011458ULL, 0x0000000152524812ULL, 0x000fe400078efcffULL,
0x0000003d00517306ULL, 0x000ea20000005400ULL, 0x000000555b00720bULL, 0x002fe20003f7d000ULL,
0x000100001c5b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000005c005d7306ULL, 0x000ff00000209400ULL, 0x0000005c005a7306ULL, 0x0002e20000205400ULL,
0x000000515600720bULL, 0x004fc40003fdd000ULL, 0x0000005c00517245ULL, 0x000fca000020d400ULL,
0x0000003c004b7306ULL, 0x000ea2000000d400ULL, 0x00000018ff5c7819ULL, 0x002fce000001141fULL,
0x00000057003c7306ULL, 0x000fe20000209400ULL, 0x0000005a5d00720bULL, 0x008fe40003f9d000ULL,
0x00000018ff5d7819ULL, 0x000fca000001143eULL, 0x0000005700557306ULL, 0x000e620000205400ULL,
0x000000014b4b2812ULL, 0x004fca00078efcffULL, 0x0000000151514812ULL, 0x000fe400078efcffULL,
0x0000006800567306ULL, 0x000ff00000209400ULL, 0x0000006800597306ULL, 0x0004e20000205400ULL,
0x000000553c00720bULL, 0x002fce0003f5d000ULL, 0x0000003e00537306ULL, 0x000fe20000009400ULL,
0x0000006800687245ULL, 0x004fce000020d400ULL, 0x0000003e005e7306ULL, 0x000fe20000005400ULL,
0x000000595600720bULL, 0x008fe20003f9d000ULL, 0x000001003e597824ULL, 0x000fca00078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000006a003c7306ULL, 0x000fec0000209400ULL,
0x0000000168684812ULL, 0x000fe400078efcffULL, 0x0000006a00557306ULL, 0x0002b00000205400ULL,
0x0000003d00487306ULL, 0x0006a2000000d400ULL, 0x0000006a006a7245ULL, 0x002fce000020d400ULL,
0x00000069004f7306ULL, 0x000fe20000209400ULL, 0x00000057003d7245ULL, 0x008fe2000020d400ULL,
0x000001003f577824ULL, 0x000fe200078e00ffULL, 0x000000553c00720bULL, 0x004fe40003f9d000ULL,
0x000000013d3d2812ULL, 0x000fe400078efcffULL, 0x0000005e5300720bULL, 0x000fe20003f5d000ULL,
0x0000006900567306ULL, 0x0002a20000205400ULL, 0x0000000148486812ULL, 0x000fe200078efcffULL,
0x000100003f5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fc40000011457ULL,
0x000000486848723eULL, 0x000fe400000010ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000005800537306ULL, 0x000fe20000209400ULL, 0x000000016a6a4812ULL, 0x000fe400078efcffULL,
0x0000006900697245ULL, 0x002fca000020d400ULL, 0x00000058005a7306ULL, 0x0002e20000205400ULL,
0x000000564f00720bULL, 0x004fce0003fdd000ULL, 0x0000003e00437306ULL, 0x000ea2000000d400ULL,
0x0000005800587245ULL, 0x002fca000020d400ULL, 0x0000000169696812ULL, 0x000fe400078efcffULL,
0x0000005a5300720bULL, 0x008fe20003f9d000ULL, 0x0000005d003c7306ULL, 0x000fe20000209400ULL,
0x0000000143432812ULL, 0x004fce00078efcffULL, 0x00000059003e7306ULL, 0x000fe80000209400ULL,
0x0000000158584812ULL, 0x000fc800078efcffULL, 0x00000059004f7306ULL, 0x0002a20000205400ULL,
0x000000435858723eULL, 0x000fe200000010ffULL, 0x000001003a437824ULL, 0x000fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000005d00537306ULL, 0x0006e20000205400ULL,
0x0000005900597245ULL, 0x002fce000020d400ULL, 0x0000001f004c7306ULL, 0x000fe20000009400ULL,
0x0000004f3e00720bULL, 0x004fe40003f9d000ULL, 0x0000005d005d7245ULL, 0x008fca000020d400ULL,
0x0000001f004d7306ULL, 0x000e620000005400ULL, 0x000000533c00720bULL, 0x000fe20003f5d000ULL,
0x000001001c537824ULL, 0x000fc800078e00ffULL, 0x0000000159594812ULL, 0x000fe400078efcffULL,
0x0000005e00557306ULL, 0x000fe20000209400ULL, 0x00000018ff537819ULL, 0x000fca0000011453ULL,
0x000000015d5d2812ULL, 0x000fe400078efcffULL, 0x0000005e00567306ULL, 0x0004e20000205400ULL,
0x0000004d4c00720bULL, 0x002fe40003f5d000ULL, 0x000000595d59723eULL, 0x000fca00000010ffULL,
0x0000003f005f7306ULL, 0x000fe20000009400ULL, 0x0000005e005e7245ULL, 0x004fe2000020d400ULL,
0x00000058182c723cULL, 0x000bec000004182cULL, 0x0000003f00607306ULL, 0x000e620000005400ULL,
0x000000565500720bULL, 0x008fe20003f9d000ULL, 0x000001003b597824ULL, 0x020fca00078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000003f00447306ULL, 0x0004ec000000d400ULL,
0x000000015e5e4812ULL, 0x000fe400078efcffULL, 0x00000057003c7306ULL, 0x000fe20000209400ULL,
0x00000018ff3f7819ULL, 0x004fc4000001143fULL, 0x000000605f00720bULL, 0x002fe40003fdd000ULL,
0x0000003f005a7245ULL, 0x000fc6000020d400ULL, 0x00000057004f7306ULL, 0x0002b00000205400ULL,
0x0000003f003e7306ULL, 0x000fe20000209400ULL, 0x0000000144446812ULL, 0x008fe400078efcffULL,
0x0000005700577245ULL, 0x002fca000020d400ULL, 0x0000003f004d7306ULL, 0x000e620000205400ULL,
0x0000004f3c00720bULL, 0x004fce0003f9d000ULL, 0x0000001c00417306ULL, 0x000eac000000d400ULL,
0x0000000157574812ULL, 0x000fe400078efcffULL, 0x00000053004f7306ULL, 0x000fe20000209400ULL,
0x0000004d3e00720bULL, 0x002fe20003fdd000ULL, 0x000100001d3e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000005300567306ULL, 0x0002e20000205400ULL,
0x0000000141411812ULL, 0x004fca00078efcffULL, 0x000000015a5a6812ULL, 0x000fe400078efcffULL,
0x0000005b00557306ULL, 0x000fe20000209400ULL, 0x0000005300537245ULL, 0x002fce000020d400ULL,
0x0000005b001c7306ULL, 0x0002a20000205400ULL, 0x000000564f00720bULL, 0x008fe20003fdd000ULL,
0x000001001d4f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000005400457306ULL, 0x000fe20000209400ULL, 0x0000005b005b7245ULL, 0x002fca000020d400ULL,
0x0000000153536812ULL, 0x000fe400078efcffULL, 0x00000054004e7306ULL, 0x0002e20000205400ULL,
0x0000001c5500720bULL, 0x004fe40003f9d000ULL, 0x00000018ff557819ULL, 0x000fca0000011438ULL,
0x0000003e003f7306ULL, 0x000fe20000209400ULL, 0x0000005400547245ULL, 0x002fca000020d400ULL,
0x000000015b5b4812ULL, 0x000fe400078efcffULL, 0x0000003e00567306ULL, 0x0002a20000205400ULL,
0x0000004e4500720bULL, 0x008fe20003f9d000ULL, 0x000001001e457824ULL, 0x000fe200078e00ffULL,
0x0000003e004e7245ULL, 0x000fc8000020d400ULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000001d000e7306ULL, 0x000ee2000000d400ULL, 0x00000018ff3e7819ULL, 0x002fca0000011439ULL,
0x0000000154544812ULL, 0x000fe400078efcffULL, 0x0000004f001c7306ULL, 0x000fe20000209400ULL,
0x000000563f00720bULL, 0x004fe20003fdd000ULL, 0x000100001e3f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000004f001d7306ULL, 0x0002a20000205400ULL,
0x000000010e0e5812ULL, 0x008fca00078efcffULL, 0x000000014e4e6812ULL, 0x000fe400078efcffULL,
0x0000003f00567306ULL, 0x000fe20000209400ULL, 0x0000004f004f7245ULL, 0x002fe4000020d400ULL,
0x0000000e4e4e723eULL, 0x000fca00000010ffULL, 0x0000003f005f7306ULL, 0x0002e20000205400ULL,
0x0000001d1c00720bULL, 0x004fce0003f9d000ULL, 0x0000003800617306ULL, 0x000fe20000009400ULL,
0x0000003f003f7245ULL, 0x002fca000020d400ULL, 0x000000014f4f4812ULL, 0x000fe400078efcffULL,
0x0000003800647306ULL, 0x000e620000005400ULL, 0x0000005f5600720bULL, 0x008fce0003f9d000ULL,
0x0000004600477306ULL, 0x000fec0000209400ULL, 0x000000013f3f4812ULL, 0x000fe400078efcffULL,
0x0000004600637306ULL, 0x0004e20000205400ULL, 0x000000646100720bULL, 0x002fe20003fbd000ULL,
0x0001000038647824ULL, 0x000fca00078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x00000045001c7306ULL, 0x000fe20000209400ULL, 0x0000004600467245ULL, 0x004fce000020d400ULL,
0x00000045001d7306ULL, 0x0002a20000205400ULL, 0x000000634700720bULL, 0x008fce0003fdd000ULL,
0x0000005000657306ULL, 0x000fe20000209400ULL, 0x0000004500457245ULL, 0x002fca000020d400ULL,
0x0000000146466812ULL, 0x000fe400078efcffULL, 0x00000050006b7306ULL, 0x0002e20000205400ULL,
0x0000001d1c00720bULL, 0x004fe40003f9d000ULL, 0x000000513d1d723eULL, 0x000fe400000010ffULL,
0x00000018ff3d7819ULL, 0x000fc6000001143bULL, 0x0000006400477306ULL, 0x000fe20000209400ULL,
0x0000005000507245ULL, 0x002fca000020d400ULL, 0x0000000145454812ULL, 0x000fe400078efcffULL,
0x00000064001c7306ULL, 0x000e620000205400ULL, 0x0000006b6500720bULL, 0x008fce0003f3d000ULL,
0x0000003900667306ULL, 0x000fec0000009400ULL, 0x0000000150501812ULL, 0x000fe400078efcffULL,
0x0000003900677306ULL, 0x000ea20000005400ULL, 0x0000001c4700720bULL, 0x002fe40003f9d000ULL,
0x0000004b521c723eULL, 0x000fc400000010ffULL, 0x00000064004b7245ULL, 0x000fe4000020d400ULL,
0x0000004f504f723eULL, 0x000fe200000010ffULL, 0x0000001e000d7306ULL, 0x0002e4000000d400ULL,
0x0000001c1820723cULL, 0x000be80000041820ULL, 0x000000014b4b4812ULL, 0x000fe400078efcffULL,
0x0000003a00627306ULL, 0x000fe20000009400ULL, 0x00000100381e7824ULL, 0x002fe200078e00ffULL,
0x000000676600720bULL, 0x004fe20003f3d000ULL, 0x000100001f1c7824ULL, 0x020fc600078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000003a006c7306ULL, 0x000e620000005400ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x000000010d0d3812ULL, 0x008fca00078efcffULL,
0x0000001e00667306ULL, 0x000ff00000209400ULL, 0x0000001e00677306ULL, 0x000ea20000205400ULL,
0x0000006c6200720bULL, 0x002fce0003f7d000ULL, 0x0000003b00607306ULL, 0x000ff00000009400ULL,
0x0000003b004c7306ULL, 0x000e620000005400ULL, 0x000000676600720bULL, 0x004fe20003fdd000ULL,
0x000001001f677824ULL, 0x000fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000003800427306ULL, 0x0004f0000000d400ULL, 0x0000005c004d7306ULL, 0x000fe20000209400ULL,
0x0000004c6000720bULL, 0x002fe20003f9d000ULL, 0x0001000039607824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x004fca000001143aULL, 0x0000005c00657306ULL, 0x0002a20000205400ULL,
0x0000000142425812ULL, 0x008fce00078efcffULL, 0x0000001c00627306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x002fce000020d400ULL, 0x0000001c006b7306ULL, 0x000e620000205400ULL,
0x000000654d00720bULL, 0x004fe40003fbd000ULL, 0x0000001e004d7245ULL, 0x000fe4000020d400ULL,
0x0000001c00657245ULL, 0x000fe4000020d400ULL, 0x000000014d4d6812ULL, 0x000fe200078efcffULL,
0x0000001f00007306ULL, 0x0004ec000000d400ULL, 0x000000015c5c5812ULL, 0x000fc400078efcffULL,
0x00000067001d7306ULL, 0x000fe20000209400ULL, 0x00000001491f7824ULL, 0x044fe200078e024aULL,
0x00000018ff4a7819ULL, 0x000fe20000011460ULL, 0x0000001049607824ULL, 0x000fe200078e00ffULL,
0x0000006b6200720bULL, 0x002fe40003fdd000ULL, 0x0000006a6949723eULL, 0x000fe400000010ffULL,
0x00000067001e7306ULL, 0x0002a20000205400ULL, 0xfffffff0601f7812ULL, 0x000fe200078ee21fULL,
0x000100003a607824ULL, 0x000fe200078e00ffULL, 0x0000000100002812ULL, 0x008fc400078efcffULL,
0x000000481824723cULL, 0x000b620000041824ULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000005500617306ULL, 0x000fe20000209400ULL,
0x0000000165656812ULL, 0x000fe400078efcffULL, 0x0000006700677245ULL, 0x002fe4000020d400ULL,
0x000000445e48723eULL, 0x020fe200000010ffULL, 0x000100003b447824ULL, 0x000fe200078e00ffULL,
0x000000575a49723eULL, 0x000fe200000010ffULL, 0x0000005500637306ULL, 0x000e620000205400ULL,
0x0000001e1d00720bULL, 0x004fc40003fdd000ULL, 0x000000001f1c783bULL, 0x000ea20000000200ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x000000481814723cULL, 0x000b640000041814ULL,
0x0000003900407306ULL, 0x00066a000000d400ULL, 0x000000006518723eULL, 0x020fc400000010ffULL,
0x0000000167676812ULL, 0x000fe200078efcffULL, 0x0000006000647306ULL, 0x000fe20000209400ULL,
0x0000010039397824ULL, 0x008fe200078e00ffULL, 0x000000636100720bULL, 0x002fe40003f5d000ULL,
0x000000675c19723eULL, 0x000fe400000010ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000006000687306ULL, 0x0002e20000205400ULL, 0x00000055001a7245ULL, 0x000fc4000020d400ULL,
0x0000000140401812ULL, 0x000fe400078efcffULL, 0x0000004a001b7245ULL, 0x000fe4000020d400ULL,
0x000000011a1a2812ULL, 0x000fe200078efcffULL, 0x0000003e00567306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x002fe4000020d400ULL, 0x0000004300617245ULL, 0x000fe4000020d400ULL,
0x0000004d1a4d723eULL, 0x000fc600000010ffULL, 0x0000003e005f7306ULL, 0x0002620000205400ULL,
0x000000686400720bULL, 0x008fe20003f3d000ULL, 0x000000181c10723cULL, 0x044b6c0000041810ULL,
0x0000004a006b7306ULL, 0x000fe20000209400ULL, 0x0000003e003e7245ULL, 0x002fe4000020d400ULL,
0x0000000d3f18723eULL, 0x020fe200000010ffULL, 0x0000004e1c34723cULL, 0x000f620000041834ULL,
0x000000454619723eULL, 0x000fc400000010ffULL, 0x0000000160601812ULL, 0x000fe200078efcffULL,
0x0000004a006c7306ULL, 0x000e620000205400ULL, 0x0000005f5600720bULL, 0x000fc60003fbd000ULL,
0x000000181c28723cULL, 0x000f680000041828ULL, 0x0000003900627306ULL, 0x000fec0000209400ULL,
0x000000013e3e5812ULL, 0x000fc400078efcffULL, 0x0000003900667306ULL, 0x000ea20000205400ULL,
0x0000006c6b00720bULL, 0x002fce0003fdd000ULL, 0x0000003a000f7306ULL, 0x0002ec000000d400ULL,
0x000000011b1b6812ULL, 0x000fe400078efcffULL, 0x0000003b003c7306ULL, 0x0006e2000000d400ULL,
0x000000415b3a723eULL, 0x002fe400000010ffULL, 0x000000666200720bULL, 0x004fc40003f5d000ULL,
0x0000003900417245ULL, 0x000fe4000020d400ULL, 0x000000401b40723eULL, 0x000fe200000010ffULL,
0x0000004400577306ULL, 0x000fe20000209400ULL, 0x00000053543b723eULL, 0x008fe400000010ffULL,
0x000000010f0f3812ULL, 0x000fc800078efcffULL, 0x0000000f6060723eULL, 0x000fe200000010ffULL,
0x0000004400007306ULL, 0x000e620000205400ULL, 0x0000003a1c30723cULL, 0x040b620000041830ULL,
0x0000000141412812ULL, 0x000fe400078efcffULL, 0x000000013c3c4812ULL, 0x000fe400078efcffULL,
0x000000413e41723eULL, 0x000fe400000010ffULL, 0x0000003800517306ULL, 0x000fea0000209400ULL,
0x000000401c24723cULL, 0x000b660000041824ULL, 0x0000003800527306ULL, 0x0004e20000205400ULL,
0x000000005700720bULL, 0x002fc40003f3d000ULL, 0x0000003d00007245ULL, 0x000fca000020d400ULL,
0x0000003d00477306ULL, 0x000fe20000209400ULL, 0x0000003800387245ULL, 0x004fce000020d400ULL,
0x0000003d004c7306ULL, 0x0002a20000205400ULL, 0x000000525100720bULL, 0x008fce0003fdd000ULL,
0x00000043005d7306ULL, 0x000fe20000209400ULL, 0x00000059003d7245ULL, 0x002fca000020d400ULL,
0x0000000138386812ULL, 0x000fe400078efcffULL, 0x0000004300587306ULL, 0x000e620000205400ULL,
0x0000004c4700720bULL, 0x004fe40003f5d000ULL, 0x000000424b4c723eULL, 0x000fca00000010ffULL,
0x00000059003a7306ULL, 0x020fe40000209400ULL, 0x0000004c1c20723cULL, 0x000b680000041820ULL,
0x0000000100002812ULL, 0x000fe400078efcffULL, 0x00000059000d7306ULL, 0x000ea20000205400ULL,
0x000000585d00720bULL, 0x002fda0003fbd000ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x0000000d3a00720bULL, 0x004fe40003f7d000ULL, 0x00000044000d7245ULL, 0x000fe4000020d400ULL,
0x000000613861723eULL, 0x000fe400000010ffULL, 0x000000010d0d1812ULL, 0x000fe400078efcffULL,
0x000000040c00780cULL, 0x000fc40003f25270ULL, 0x0000003c0d3c723eULL, 0x000fe200000010ffULL,
0x000000601c2c723cULL, 0x000b64000004182cULL, 0x000000013d3d3812ULL, 0x000fc800078efcffULL,
0x0000003d003d723eULL, 0x000fce00000010ffULL, 0x0000003c1c14723cULL, 0x000b620000041814ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff097224ULL, 0x000fe200078e0008ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd35000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000000631317220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x080fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000628007220ULL, 0x080fe20000410000ULL, 0x0000000611117220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x000000062c097220ULL, 0x0a0fe20000410000ULL,
0x000000062a0a7220ULL, 0x080fe20000410000ULL, 0x00000006270f7220ULL, 0x080fe20000410000ULL,
0x00000006331a7220ULL, 0x080fe20000410000ULL, 0x00000006102a7220ULL, 0x080fe20000410000ULL,
0x000000ffff277224ULL, 0x000fe200078e0031ULL, 0x00000006301b7220ULL, 0x080fe20000410000ULL,
0x000000062b0b7220ULL, 0x080fe20000410000ULL, 0x0000000620337220ULL, 0x080fe20000410000ULL,
0x00000006260e7220ULL, 0x080fe20000410000ULL, 0x000000062e107220ULL, 0x080fe20000410000ULL,
0x000000062f1c7220ULL, 0x080fe20000410000ULL, 0x000000ffff317224ULL, 0x000fe200078e0035ULL,
0x0000000632327220ULL, 0x080fe20000410000ULL, 0x0000000636367220ULL, 0x080fe20000410000ULL,
0x0000000637377220ULL, 0x080fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x0000000612127220ULL, 0x080fe20000410000ULL, 0x0000000613137220ULL, 0x080fe20000410000ULL,
0x00000006212b7220ULL, 0x080fe20000410000ULL, 0x0000000622197220ULL, 0x080fe20000410000ULL,
0x0000000623187220ULL, 0x080fe20000410000ULL, 0x0000000625307220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x0000000614267220ULL, 0x080fe20000410000ULL,
0x0000000615207220ULL, 0x080fe20000410000ULL, 0x00000006161d7220ULL, 0x080fe20000410000ULL,
0x00000006171e7220ULL, 0x000fe20000410000ULL, 0x000000ffff287224ULL, 0x000fc400078e0034ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0000ULL, 0x000000ffff357224ULL, 0x000fe400078e0011ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0024ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000780c7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff227224ULL, 0x000fe400078e0032ULL, 0x000000ffff217224ULL, 0x000fc400078e0036ULL,
0x000000ffff327224ULL, 0x000fe400078e0037ULL, 0x000000ffff247224ULL, 0x000fe400078e000aULL,
0x000000ffff237224ULL, 0x000fe400078e000bULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff347224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x000fc400078e000eULL,
0x000000ffff177224ULL, 0x000fe400078e000fULL, 0x000000ffff097224ULL, 0x000fc400078e0010ULL,
0x00000000000a7805ULL, 0x002fca0000015200ULL, 0x00000400780f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x006fe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0a117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0bULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140fULL, 0x0000001100007211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x0000000200007819ULL, 0x000fc8000000120fULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400780f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004051f7824ULL, 0x000fe200078e00ffULL,
0x000000760700720cULL, 0x000fc80003f06070ULL, 0xfffffff01f0b7812ULL, 0x000fca00078ec0ffULL,
0x0000008002007824ULL, 0x000fca00078e020bULL, 0x00f40000000c7984ULL, 0x0002a20000000c00ULL,
0x0000136000008947ULL, 0x000fea0003800000ULL, 0x0000010007367824ULL, 0x000fe200078e0279ULL,
0x00000073050a7211ULL, 0x040fe200078ff0ffULL, 0x0000000205377824ULL, 0x000fe400078e00ffULL,
0x00000002ff4c7424ULL, 0x000fe200078e00ffULL, 0x000000366d0b7217ULL, 0x000fe40007800000ULL,
0x0000000637377812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff107a19ULL, 0x000fe2000001160aULL,
0x000000010b367824ULL, 0x000fe200078e0a36ULL, 0x0000580037397a10ULL, 0x000fe20007ffe0ffULL,
0x00000001710b7824ULL, 0x000fe200078e0237ULL, 0x0000001077537217ULL, 0x000fc40003800000ULL,
0x000000363900720cULL, 0x080fe20003f06070ULL, 0x000000010b147824ULL, 0x140fe200078e0a36ULL,
0x000000360b00720cULL, 0x000fe20003f26070ULL, 0x0000000139127824ULL, 0x000fe400078e0a36ULL,
0x0000005372537224ULL, 0x000fe200078e02ffULL, 0x0000001477147217ULL, 0x040fe40003800000ULL,
0x0000001277127217ULL, 0x000fe40003800000ULL, 0x00000004ff147819ULL, 0x000fc40000011614ULL,
0x000000ff12447207ULL, 0x000fe40000000000ULL, 0x000000ff14147207ULL, 0x000fe40000800000ULL,
0x00000053440b7211ULL, 0x000fe400078fe0ffULL, 0x000000080a127810ULL, 0x000fe20007ffe0ffULL,
0x0000000153117824ULL, 0x000fe200078e0214ULL, 0x00000010373f7812ULL, 0x000fe200078efcffULL,
0x000060000b0a7625ULL, 0x000fe200078e004cULL, 0x00005a00ff127a19ULL, 0x000fc60000011612ULL,
0x0000600011107625ULL, 0x000fe200078e004cULL, 0x000058003f3b7a10ULL, 0x000fe20007ffe0ffULL,
0x000000080a4a7981ULL, 0x0046a2000c1e9500ULL, 0x0000001277557217ULL, 0x000fc60003800000ULL,
0x0000000810517981ULL, 0x0002a2000c1e9500ULL, 0x00000020373d7812ULL, 0x000fe200078efcffULL,
0x0000005572557224ULL, 0x000fe400078e02ffULL, 0x000000013b0a7824ULL, 0x108fe400078e0a36ULL,
0x00000001710b7824ULL, 0x000fe200078e023fULL, 0x000000363b00720cULL, 0x000fe20003f06070ULL,
0x0000000114157824ULL, 0x000fe200078e0255ULL, 0x0000000a770a7217ULL, 0x000fe20003800000ULL,
0x000000010b107824ULL, 0x002fe200078e0a36ULL, 0x000058003d437a10ULL, 0x000fe20007ffe0ffULL,
0x0000600015147625ULL, 0x000fe200078e004cULL, 0x0000005544137211ULL, 0x000fc400078fe0ffULL,
0x000000ff0a387207ULL, 0x000fe20000000000ULL, 0x00000001433e7824ULL, 0x000fe200078e0a36ULL,
0x0000001077107217ULL, 0x000fe20003800000ULL, 0x0000600013127625ULL, 0x000fe200078e004cULL,
0x000000360b00720cULL, 0x080fe20003f26070ULL, 0x00000008144f7981ULL, 0x0002e2000c1e9500ULL,
0x00000053380b7211ULL, 0x000fe200078fe0ffULL, 0x0000000171477824ULL, 0x000fe200078e023dULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x0000000812467981ULL, 0x0002e2000c1e9500ULL,
0x000000364300720cULL, 0x000fc40003f06070ULL, 0x0000003e773e7217ULL, 0x000fe20003800000ULL,
0x000060000b0a7625ULL, 0x000fc600078e004cULL, 0x000000ff3e3e7207ULL, 0x000fe20000000000ULL,
0x0000000147407824ULL, 0x040fe200078e0a36ULL, 0x000000080a3a7981ULL, 0x0002e4000c1e9500ULL,
0x000000ff10127207ULL, 0x002fe40000800000ULL, 0x000000364700720cULL, 0x000fe40003f26070ULL,
0x0000003037477812ULL, 0x000fe200078efcffULL, 0x0000000153117824ULL, 0x000fe200078e0212ULL,
0x0000005538137211ULL, 0x000fe200078fe0ffULL, 0x0000000112157824ULL, 0x000fe200078e0255ULL,
0x0000004077407217ULL, 0x000fc40003800000ULL, 0x000000533e0b7211ULL, 0x000fe200078fe0ffULL,
0x0000000171577824ULL, 0x000fe200078e0247ULL, 0x00000004ff407819ULL, 0x000fe20000011640ULL,
0x0000600011107625ULL, 0x000fe200078e004cULL, 0x0000580047497a10ULL, 0x000fc60007ffe0ffULL,
0x0000600013127625ULL, 0x000fc800078e004cULL, 0x0000600015147625ULL, 0x080fe200078e004cULL,
0x000000ff40427207ULL, 0x000fe20000800000ULL, 0x0000000810417981ULL, 0x0002e4000c1e9500ULL,
0x000060000b0a7625ULL, 0x000fe400078e004cULL, 0x00000008123c7981ULL, 0x0002e4000c1e9500ULL,
0x0000000157487824ULL, 0x000fe400078e0a36ULL, 0x0000000814457981ULL, 0x0002e8000c1e9500ULL,
0x000000080a407981ULL, 0x0002e2000c1e9500ULL, 0x0000004877487217ULL, 0x000fe20003800000ULL,
0x0000000153117824ULL, 0x002fe200078e0242ULL, 0x000000553e137211ULL, 0x000fe200078fe0ffULL,
0x0000000142157824ULL, 0x000fc400078e0255ULL, 0x00000001490a7824ULL, 0x040fe200078e0a36ULL,
0x000000364900720cULL, 0x000fe20003f06070ULL, 0x0000600011107625ULL, 0x000fe200078e004cULL,
0x000000365700720cULL, 0x000fe40003f26070ULL, 0x0000000a770a7217ULL, 0x000fe20003800000ULL,
0x0000600013127625ULL, 0x080fe200078e004cULL, 0x00000004ff0b7819ULL, 0x000fe20000011648ULL,
0x00000008104b7981ULL, 0x0002e4000c1e9500ULL, 0x0000600015147625ULL, 0x000fe200078e004cULL,
0x000000ff0a487207ULL, 0x000fe20000000000ULL, 0x0000000812427981ULL, 0x0002e2000c1e9500ULL,
0x000000ff0b4e7207ULL, 0x000fc60000800000ULL, 0x00000008144d7981ULL, 0x0002e2000c1e9500ULL,
0x00000053480b7211ULL, 0x000fe200078fe0ffULL, 0x0000000153117824ULL, 0x002fc800078e024eULL,
0x000060000b0a7625ULL, 0x000fc800078e004cULL, 0x0000600011107625ULL, 0x000fe400078e004cULL,
0x000000080a0a7981ULL, 0x0002e2000c1e9500ULL, 0x0000005548137211ULL, 0x000fc600078fe0ffULL,
0x0000000810117981ULL, 0x0002e2000c1e9500ULL, 0x000000014e157824ULL, 0x000fe400078e0255ULL,
0x0000600013127625ULL, 0x000fc800078e004cULL, 0x0000600015147625ULL, 0x000fe400078e004cULL,
0x0000000812127981ULL, 0x0002e8000c1e9500ULL, 0x0000000814157981ULL, 0x0002e2000c1e9500ULL,
0xfffffff044537812ULL, 0x000fe200078ec0ffULL, 0x00000001ff447424ULL, 0x000fe200078e00ffULL,
0x00000001370b7812ULL, 0x002fc600078efcffULL, 0x00000001364c7824ULL, 0x000fe200078e0253ULL,
0x0000000937557812ULL, 0x000fc600078efcffULL, 0x0000000139597824ULL, 0x100fe200078e0a4cULL,
0x000058000b577a10ULL, 0x000fe40007ffe0ffULL, 0x0000580055137a10ULL, 0x000fe40007ffe0ffULL,
0x0000005944597219ULL, 0x000fe200000006ffULL, 0x00000001575b7824ULL, 0x100fe400078e0a4cULL,
0x00000001135f7824ULL, 0x000fc600078e0a4cULL, 0x0000005b445b7219ULL, 0x040fe400000006ffULL,
0x0000005f445f7219ULL, 0x000fe400000006ffULL, 0x00000011377d7812ULL, 0x040fe400078efcffULL,
0x00000018377b7812ULL, 0x040fe400078efcffULL, 0x00000019376b7812ULL, 0x000fe400078efcffULL,
0x000058007b147a10ULL, 0x000fc40007ffe0ffULL, 0x000058006b107a10ULL, 0x000fe40007ffe0ffULL,
0x0000002137637812ULL, 0x040fe400078efcffULL, 0x0000002837617812ULL, 0x000fe400078efcffULL,
0xfffffff048487812ULL, 0x000fe400078ec0ffULL, 0x0000580063697a10ULL, 0x000fe40007ffe0ffULL,
0x0000580061677a10ULL, 0x000fe20007ffe0ffULL, 0x00000001364e7824ULL, 0x000fc800078e0248ULL,
0x0000000149507824ULL, 0x000fca00078e0a4eULL, 0x0000005044507219ULL, 0x000fe400000006ffULL,
0x000054104a4a7816ULL, 0x004fe40000000051ULL, 0x0000000837517812ULL, 0x000fc800078efcffULL,
0x0000580051537a10ULL, 0x000fe40007ffe0ffULL, 0x0000004a59ff7212ULL, 0x000fc6000780c0ffULL,
0x00000001535d7824ULL, 0x000fe200078e0a4cULL, 0x000000363900720cULL, 0x000fc80000701470ULL,
0x0000005d445d7219ULL, 0x000fe400000006ffULL, 0x0000004a5bff7212ULL, 0x080fe4000786c0ffULL,
0x0000004a5dff7212ULL, 0x080fe4000784c0ffULL, 0x0000004a5fff7212ULL, 0x000fe4000782c0ffULL,
0x000000363700720cULL, 0x000fe40000701070ULL, 0x0000541046467816ULL, 0x008fc4000000004fULL,
0xfffffff0384a7812ULL, 0x000fe400078ec0ffULL, 0xff8000001b1b7808ULL, 0x000fe40000000000ULL,
0x0000004659ff7212ULL, 0x080fe2000788c0ffULL, 0x00000001364a7824ULL, 0x000fe200078e024aULL,
0x000000465bff7212ULL, 0x080fe400078ac0ffULL, 0x000000465dff7212ULL, 0x080fe400078cc0ffULL,
0x000000465fff7212ULL, 0x000fc4000780c0ffULL, 0x000058007d467a10ULL, 0x000fe20007ffe0ffULL,
0x000000013b527824ULL, 0x100fe200078e0a4aULL, 0x000000363900720cULL, 0x080fe20002781470ULL,
0x0000000114567824ULL, 0x100fe200078e0a4aULL, 0x000000365300720cULL, 0x080fe200037c1470ULL,
0x0000000146547824ULL, 0x100fe200078e0a4aULL, 0x000000361300720cULL, 0x000fe20000701470ULL,
0x0000000110587824ULL, 0x000fe200078e0a4aULL, 0x00000052444a7219ULL, 0x000fe400000006ffULL,
0xfffffff03e4c7812ULL, 0x000fc400078ec0ffULL, 0x0000005444527219ULL, 0x040fe400000006ffULL,
0x000000363700720cULL, 0x080fe40002781070ULL, 0x000000365100720cULL, 0x080fe400037c1070ULL,
0x000000365500720cULL, 0x000fe40000701070ULL, 0x0000005644547219ULL, 0x000fe400000006ffULL,
0x000054103a417816ULL, 0x000fe20000000041ULL, 0x00000001364c7824ULL, 0x000fe200078e024cULL,
0x000000361300720cULL, 0x000fc40000f21470ULL, 0x000054103c457816ULL, 0x000fe40000000045ULL,
0xff80000022227808ULL, 0x000fe40002000000ULL, 0xff80000021217808ULL, 0x000fe40003000000ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0x000000414aff7212ULL, 0x040fe4000788c0ffULL,
0x000000454aff7212ULL, 0x000fc400078cc0ffULL, 0x0000004554ff7212ULL, 0x000fe2000780c0ffULL,
0x00000001435a7824ULL, 0x000fe200078e0a4cULL, 0x000000365500720cULL, 0x080fe40000f21070ULL,
0x000000365700720cULL, 0x0c0fe40001f61470ULL, 0x000000365700720cULL, 0x080fe40002fa1470ULL,
0x000000365300720cULL, 0x080fe40001741470ULL, 0x000000363b00720cULL, 0x000fc40002781470ULL,
0x000000363b00720cULL, 0x080fe400037c1470ULL, 0x000000361400720cULL, 0x080fe40000701470ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0x00000029375f7812ULL, 0x000fe400078efcffULL,
0x000000360b00720cULL, 0x0c0fe40001f61070ULL, 0x000000360b00720cULL, 0x000fc40002fa1070ULL,
0x000000365100720cULL, 0x080fe40001741070ULL, 0x000000363f00720cULL, 0x0c0fe40002721070ULL,
0x000000363f00720cULL, 0x080fe400037c1070ULL, 0x000000367b00720cULL, 0x000fe40000701070ULL,
0x0000005844587219ULL, 0x040fe400000006ffULL, 0x0000005a44567219ULL, 0x000fc400000006ffULL,
0x00005410404b7816ULL, 0x000fe4000000004bULL, 0x00005410424d7816ULL, 0x000fe4000000004dULL,
0x000058005f657a10ULL, 0x000fe40007ffe0ffULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff8000001a1a7808ULL, 0x000fe40002800000ULL, 0xff80000028287808ULL, 0x000fc40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40000800000ULL, 0xff80000024247808ULL, 0x000fe40003000000ULL,
0xff80000025257808ULL, 0x000fe40000000000ULL, 0x0000004152ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004154ff7212ULL, 0x080fe400078ac0ffULL, 0x0000004158ff7212ULL, 0x000fc4000784c0ffULL,
0x0000004552ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004558ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004b56ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004d56ff7212ULL, 0x000fe2000780c0ffULL,
0x00000001695c7824ULL, 0x100fe200078e0a4cULL, 0x000000364600720cULL, 0x0c0fe20001f61470ULL,
0x00000001675e7824ULL, 0x100fe200078e0a4cULL, 0x000000364600720cULL, 0x080fe20002781470ULL,
0x0000000165607824ULL, 0x000fe200078e0a4cULL, 0x000000361400720cULL, 0x000fc40002fa1470ULL,
0x000000361000720cULL, 0x0c0fe40001741470ULL, 0x000000361000720cULL, 0x080fe40000f21470ULL,
0x000000364300720cULL, 0x0c0fe400037c1470ULL, 0x000000364300720cULL, 0x000fe40000701470ULL,
0x00000031375b7812ULL, 0x040fe400078efcffULL, 0x0000003837597812ULL, 0x000fc400078efcffULL,
0x00000039374f7812ULL, 0x000fe400078efcffULL, 0x0000005c445a7219ULL, 0x000fe400000006ffULL,
0x000000367d00720cULL, 0x0c0fe40001f61070ULL, 0x000000367d00720cULL, 0x080fe40002781070ULL,
0x000000367b00720cULL, 0x080fe40002fa1070ULL, 0x000000366b00720cULL, 0x000fc40001741070ULL,
0x000000366b00720cULL, 0x080fe40000f21070ULL, 0x000000363d00720cULL, 0x0c0fe400037c1070ULL,
0x000000363d00720cULL, 0x000fe40000701070ULL, 0x0000005e445c7219ULL, 0x040fe400000006ffULL,
0x0000006044607219ULL, 0x000fe400000006ffULL, 0x000054100a117816ULL, 0x000fc40000000011ULL,
0x000058005b5d7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580059387a10ULL, 0x000fe40007ffe0ffULL,
0x000058004f3e7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000023237808ULL, 0x000fe40002000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002800000ULL,
0xff80000035357808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff80000033337808ULL, 0x000fe40003000000ULL, 0xff80000019197808ULL, 0x000fe40000000000ULL,
0x0000004b5aff7212ULL, 0x080fe4000786c0ffULL, 0x0000004b5cff7212ULL, 0x000fc4000788c0ffULL,
0x0000004b60ff7212ULL, 0x000fe400078ac0ffULL, 0x0000004d5aff7212ULL, 0x080fe4000784c0ffULL,
0x0000004d5cff7212ULL, 0x080fe4000782c0ffULL, 0x0000004d60ff7212ULL, 0x000fe400078cc0ffULL,
0x0000001150ff7212ULL, 0x000fe2000780c0ffULL, 0x000000015d4c7824ULL, 0x100fe200078e0a4eULL,
0x000000366900720cULL, 0x0c0fe20001f61470ULL, 0x0000000138487824ULL, 0x100fe200078e0a4eULL,
0x000000366900720cULL, 0x080fe20001741470ULL, 0x000000013e4e7824ULL, 0x000fe200078e0a4eULL,
0x000000366700720cULL, 0x000fc40002781470ULL, 0x000000366700720cULL, 0x080fe40000f21470ULL,
0x000000366500720cULL, 0x0c0fe40002fa1470ULL, 0x000000366500720cULL, 0x080fe400037c1470ULL,
0x000000364900720cULL, 0x080fe40000701470ULL, 0x000000366300720cULL, 0x0c0fe40001f61070ULL,
0x000000366300720cULL, 0x000fc40001741070ULL, 0x000000366100720cULL, 0x0c0fe40002781070ULL,
0x000000366100720cULL, 0x080fe40000f21070ULL, 0x000000365f00720cULL, 0x0c0fe40002fa1070ULL,
0x000000365f00720cULL, 0x080fe400037c1070ULL, 0x000000364700720cULL, 0x000fe40000701070ULL,
0x0000004c444c7219ULL, 0x000fc400000006ffULL, 0x0000004844487219ULL, 0x040fe400000006ffULL,
0x0000004e444e7219ULL, 0x000fe400000006ffULL, 0x0000541012157816ULL, 0x000fe40000000015ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000018187808ULL, 0x000fe40001000000ULL,
0xff8000002c2c7808ULL, 0x000fc40002000000ULL, 0xff80000016167808ULL, 0x000fe40000800000ULL,
0xff80000030307808ULL, 0x000fe40002800000ULL, 0xff80000017177808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0x000000114cff7212ULL, 0x080fe4000786c0ffULL,
0x0000001148ff7212ULL, 0x000fc4000784c0ffULL, 0x000000114eff7212ULL, 0x000fe4000788c0ffULL,
0x0000001550ff7212ULL, 0x080fe4000782c0ffULL, 0x000000154cff7212ULL, 0x080fe400078ac0ffULL,
0x0000001548ff7212ULL, 0x080fe400078cc0ffULL, 0x000000154eff7212ULL, 0x000fe4000780c0ffULL,
0x000000364900720cULL, 0x000fc40000f21470ULL, 0x000000365d00720cULL, 0x0c0fe40001f61470ULL,
0x000000365d00720cULL, 0x080fe40002fa1470ULL, 0x000000363800720cULL, 0x0c0fe40001741470ULL,
0x000000363800720cULL, 0x080fe400037c1470ULL, 0x000000363e00720cULL, 0x0c0fe40002781470ULL,
0x000000363e00720cULL, 0x000fc40000701470ULL, 0x000000364700720cULL, 0x080fe40000f21070ULL,
0x000000365b00720cULL, 0x0c0fe40001f61070ULL, 0x000000365b00720cULL, 0x080fe40002fa1070ULL,
0x000000365900720cULL, 0x0c0fe40001741070ULL, 0x000000365900720cULL, 0x080fe400037c1070ULL,
0x000000364f00720cULL, 0x000fc40002781070ULL, 0x000000364f00720cULL, 0x000fe40000701070ULL,
0xff8000002d2d7808ULL, 0x000fe40001800000ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff80000020207808ULL, 0x000fe40002000000ULL, 0xff80000009097808ULL, 0x000fe40000800000ULL,
0xff8000001c1c7808ULL, 0x000fc40002800000ULL, 0xff8000001d1d7808ULL, 0x000fe40003000000ULL,
0xff8000001e1e7808ULL, 0x000fc40000000000ULL, 0x0000001b0c00720bULL, 0x004fe20003f1e000ULL,
0x0000001fff157424ULL, 0x000fe200078e00ffULL, 0x000000220d00720bULL, 0x000fe20003f3e000ULL,
0xffffffffff387424ULL, 0x000fe200078e00ffULL, 0x0000000c1b0c7208ULL, 0x000fe40004000000ULL,
0x0000000d220d7208ULL, 0x000fe40004800000ULL, 0x000000270c00720bULL, 0x000fc40003f1e000ULL,
0x0000001a0d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c270b7208ULL, 0x000fe40004000000ULL,
0x0000000d1a0a7208ULL, 0x000fe40004800000ULL, 0x000000280b00720bULL, 0x000fe40003f1e000ULL,
0x000000210a00720bULL, 0x000fe40003f3e000ULL, 0x0000000b280c7208ULL, 0x000fc40004000000ULL,
0x0000000a210b7208ULL, 0x000fe40004800000ULL, 0x000000310c00720bULL, 0x000fe40003f1e000ULL,
0x000000320b00720bULL, 0x000fe40003f3e000ULL, 0x0000000c310d7208ULL, 0x000fe40004000000ULL,
0x0000000b320b7208ULL, 0x000fe40004800000ULL, 0x0000002e0d00720bULL, 0x000fc40003f1e000ULL,
0x000000240b00720bULL, 0x000fe40003f3e000ULL, 0x0000000d2e0a7208ULL, 0x000fe40004000000ULL,
0x0000000b240c7208ULL, 0x000fe40004800000ULL, 0x000000290a00720bULL, 0x000fe40003f1e000ULL,
0x000000230c00720bULL, 0x000fe40003f3e000ULL, 0x0000000a290b7208ULL, 0x000fc40004000000ULL,
0x0000000c230c7208ULL, 0x000fe40004800000ULL, 0x0000002a0b00720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fe40003f3e000ULL, 0x0000000b2a0a7208ULL, 0x000fe40004000000ULL,
0x0000000c250b7208ULL, 0x000fe40004800000ULL, 0x000000350a00720bULL, 0x000fc40003f1e000ULL,
0x000000340b00720bULL, 0x000fe40003f3e000ULL, 0x0000000a350a7208ULL, 0x000fe40004000000ULL,
0x0000000b340c7208ULL, 0x000fe40004800000ULL, 0x000000330a00720bULL, 0x000fe40003f1e000ULL,
0x000000190c00720bULL, 0x000fe40003f3e000ULL, 0x0000000a330a7208ULL, 0x000fc40004000000ULL,
0x0000000c190b7208ULL, 0x000fe40004800000ULL, 0x0000002b0a00720bULL, 0x000fe40003f1e000ULL,
0x000000180b00720bULL, 0x000fe40003f3e000ULL, 0x0000000a2b0d7208ULL, 0x000fe40004000000ULL,
0x0000000b180b7208ULL, 0x000fe40004800000ULL, 0x0000002c0d00720bULL, 0x000fc40003f1e000ULL,
0x000000160b00720bULL, 0x000fe40003f3e000ULL, 0x0000000d2c0d7208ULL, 0x000fe40004000000ULL,
0x0000000b160a7208ULL, 0x000fe40004800000ULL, 0x000000300d00720bULL, 0x000fe40003f1e000ULL,
0x000000170a00720bULL, 0x000fe40003f3e000ULL, 0x0000000d300c7208ULL, 0x000fc40004000000ULL,
0x0000000a170a7208ULL, 0x000fe40004800000ULL, 0x0000002f0c00720bULL, 0x000fe40003f1e000ULL,
0x000000090a00720bULL, 0x000fe40003f3e000ULL, 0x0000000c2f0c7208ULL, 0x000fe40004000000ULL,
0x0000000a090b7208ULL, 0x000fe40004800000ULL, 0x0000002d0c00720bULL, 0x000fc40003f1e000ULL,
0x0000001c0b00720bULL, 0x000fe40003f3e000ULL, 0x0000000c2d0d7208ULL, 0x000fe40004000000ULL,
0x0000000b1c0a7208ULL, 0x000fe40004800000ULL, 0x000000260d00720bULL, 0x000fe40003f1e000ULL,
0x0000001d0a00720bULL, 0x000fe40003f3e000ULL, 0x0000000d260d7208ULL, 0x000fc40004000000ULL,
0x0000000a1d0b7208ULL, 0x000fe40004800000ULL, 0x000000200d00720bULL, 0x000fe40003f1e000ULL,
0x0000001e0b00720bULL, 0x000fe40003f3e000ULL, 0x0000000d20127208ULL, 0x000fe40004000000ULL,
0x0000000b1e147208ULL, 0x000fe20004800000ULL, 0x000014727f007947ULL, 0x000fec000b800000ULL,
0x0c401f00120a7f89ULL, 0x0004e400000e0000ULL, 0x0000000a1200720bULL, 0x008fc80003f1e000ULL,
0x000000120a367208ULL, 0x000fe20004000000ULL, 0x000014827f007947ULL, 0x000fea000b800000ULL,
0x0c401f00140a7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0b7f89ULL, 0x000e6800000e0000ULL,
0x0c401f000f0c7f89ULL, 0x000ea800000e0000ULL, 0x0c201f00360d7f89ULL, 0x000ea200000e0000ULL,
0x0000000a1400720bULL, 0x008fc40003f1e000ULL, 0x0000000b0e00720bULL, 0x002fe40003f3e000ULL,
0x000000140a107208ULL, 0x000fe40004000000ULL, 0x0000000e0b117208ULL, 0x000fe40004800000ULL,
0x0000000c0f00720bULL, 0x004fe20003f1e000ULL, 0x0c201f0010137f89ULL, 0x000e6600000e0000ULL,
0x0000000f0c0a7208ULL, 0x000fe20004000000ULL, 0x0c201f0011127f89ULL, 0x000ea200000e0000ULL,
0x0000000d3600720bULL, 0x000fc60003f1e000ULL, 0x0c201f000a0b7f89ULL, 0x0006e200000e0000ULL,
0x000000360d0c7208ULL, 0x000fe40004000000ULL, 0x000000131000720bULL, 0x002fe40003f3e000ULL,
0x000000121100720bULL, 0x004fe40003f5e000ULL, 0x00000010130d7208ULL, 0x000fe40004800000ULL,
0x00000011120e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c367820ULL, 0x008fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000305ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010836ULL,
0x0000002a00377308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2e0f7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2b2e7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b2c2b7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010836ULL,
0x0000001b00107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2d2a7823ULL, 0x108fe20000010836ULL,
0x3fb8aa3b0d2d7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010836ULL, 0x0000000b0a00720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082dULL,
0x0000002700117308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082dULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b33277823ULL, 0x004fe20000010836ULL,
0x3fb8aa3b1e1e7823ULL, 0x000fcc000001082dULL, 0x0000001a00137308ULL, 0x002e620000000800ULL,
0x000000101110723eULL, 0x008fce00000010ffULL, 0x0000002800127308ULL, 0x0005f00000000800ULL,
0x0000003100317308ULL, 0x000ee20000000800ULL, 0x00000004ff287e24ULL, 0x004fe2000f8e00ffULL,
0x000000221311723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b18227823ULL, 0x000fe2000001082dULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x3f8000002828783eULL, 0x000fc400000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x000000123112723eULL, 0x008fce00000010ffULL, 0x0000002900157308ULL, 0x0005e20000000800ULL,
0x000000213213723eULL, 0x002fe200000010ffULL, 0x000000ffff297224ULL, 0x004fe200078e0028ULL,
0x3fb8aa3b19217823ULL, 0x000fca000001082dULL, 0x0000000f00147308ULL, 0x0002a20000000800ULL,
0x00000002ff327819ULL, 0x000fe20000011605ULL, 0x000000281018723cULL, 0x000b6800000418ffULL,
0x0000000832337824ULL, 0x040fe200078e00ffULL, 0x0000000832397810ULL, 0x000fe20007ffe0ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2f0f7823ULL, 0x002fe20000010836ULL,
0x3fb8aa3b172f7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b16297823ULL, 0x020fca000001082dULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x000000141514723eULL, 0x004fce00000010ffULL,
0x0000003500387308ULL, 0x0004f00000000800ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000253417723eULL, 0x002fe200000010ffULL, 0x000000ffff347224ULL, 0x000fc400078e0028ULL,
0x000000ffff357224ULL, 0x004fc800078e0028ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x000000373816723eULL, 0x008fe200000010ffULL, 0x0000000832377824ULL, 0x000fcc00078e00ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000242315723eULL, 0x002fce00000010ffULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x0000000832237824ULL, 0x040fe200078e00ffULL,
0x000000341418723cULL, 0x000f6c0000041818ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000e700000000800ULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x00000022002c7308ULL, 0x0004f00000000800ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x0000000132227810ULL, 0x004fc80007ffe0ffULL, 0xfffffff8232d7812ULL, 0x000fe400078ee222ULL,
0x0000002b3022723eULL, 0x002fe200000010ffULL, 0x0000002f00247308ULL, 0x000e620000000800ULL,
0x000000212c21723eULL, 0x008fe200000010ffULL, 0x00000008322c7824ULL, 0x040fe400078e00ffULL,
0x00000008322b7824ULL, 0x000fe400078e00ffULL, 0x0000000839307824ULL, 0x000fe400078e00ffULL,
0x0000002000257308ULL, 0x0005e60000000800ULL, 0xfffffff830397812ULL, 0x000fc400078ee239ULL,
0x000000292423723eULL, 0x002fc600000010ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000272e20723eULL, 0x004fe200000010ffULL, 0x00000008322e7824ULL, 0x040fe200078e00ffULL,
0x0000000332277810ULL, 0x040fe40007ffe0ffULL, 0x0000000232247810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82c2f7812ULL, 0x000fe200078ee227ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x000000342018723cULL, 0x020b620000041818ULL, 0xfffffff82b2b7812ULL, 0x000fc400078ee224ULL,
0x0000000632277810ULL, 0x040fe40007ffe0ffULL, 0x0000000532247810ULL, 0x040fe40007ffe0ffULL,
0x0000001c001c7308ULL, 0x000ea20000000800ULL, 0x0000000432297810ULL, 0x000fe40007ffe0ffULL,
0x000000262526723eULL, 0x002fe400000010ffULL, 0xfffffff82e357812ULL, 0x060fe400078ee227ULL,
0xfffffff833337812ULL, 0x000fe200078ee224ULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0xfffffff82e317812ULL, 0x000fe200078ee229ULL, 0x0000000832297824ULL, 0x040fe200078e00ffULL,
0xffffffff322c7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff829297812ULL, 0x000fe200078ee232ULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x000000091c25723eULL, 0x004fe400000010ffULL,
0x0000000c1f1c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1f7224ULL, 0x000fe200078e0028ULL,
0xfffffff837377812ULL, 0x000fc600078ee22cULL, 0x0000000f000f7308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000ea20000000800ULL, 0x0000001d1e27723eULL, 0x002fe200000010ffULL,
0x000000ffff1e7224ULL, 0x000fe200078e0028ULL, 0x0000000f2a24723eULL, 0x004fc400000010ffULL,
0x00009000022a7811ULL, 0x000fe400078e58ffULL, 0x0000000a0b0f7208ULL, 0x000fc60004800000ULL,
0x0000001e2418723cULL, 0x000f620000041818ULL, 0x0000001029297824ULL, 0x100fe400078e022aULL,
0x000000102d2d7824ULL, 0x100fe400078e022aULL, 0x000000102b2b7824ULL, 0x100fe400078e022aULL,
0x000000102f2f7824ULL, 0x100fe400078e022aULL, 0x0000001031317824ULL, 0x000fe400078e022aULL,
0x0000000129297824ULL, 0x000fc400078e021cULL, 0x0000001033337824ULL, 0x100fe400078e022aULL,
0x000000011c2d7824ULL, 0x040fe200078e022dULL, 0x0000001029007388ULL, 0x0003e20000000800ULL,
0x0000001035357824ULL, 0x100fe400078e022aULL, 0x000000011c2b7824ULL, 0x040fe200078e022bULL,
0x000000122d007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x100fe400078e022aULL,
0x000000011c2f7824ULL, 0x000fe200078e022fULL, 0x000000142b007388ULL, 0x0003e20000000800ULL,
0x0000001039397824ULL, 0x000fc400078e022aULL, 0x000000011c317824ULL, 0x040fe200078e0231ULL,
0x000000162f007388ULL, 0x0003e20000000800ULL, 0x000000011c337824ULL, 0x040fe400078e0233ULL,
0x000000011c357824ULL, 0x040fe200078e0235ULL, 0x0000002031007388ULL, 0x0003e20000000800ULL,
0x000000011c377824ULL, 0x040fe400078e0237ULL, 0x000000011c1c7824ULL, 0x000fe200078e0239ULL,
0x0000002233007388ULL, 0x0003e20000000800ULL, 0x000000ffff197224ULL, 0x020fc600078e001aULL,
0x0000002435007388ULL, 0x0003e80000000800ULL, 0x0000002637007388ULL, 0x0003e80000000800ULL,
0x000000111c007388ULL, 0x0003e80000000800ULL, 0x000400132d007388ULL, 0x0003e80000000800ULL,
0x000400152b007388ULL, 0x0003e80000000800ULL, 0x000400172f007388ULL, 0x0003e80000000800ULL,
0x0004002131007388ULL, 0x0003e80000000800ULL, 0x0004002333007388ULL, 0x0003e80000000800ULL,
0x0004002535007388ULL, 0x0003e80000000800ULL, 0x0004002737007388ULL, 0x0003e80000000800ULL,
0x00f0000c00008388ULL, 0x0003e80000000c00ULL, 0x00f2001800008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007aff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008007aff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010007aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000107077810ULL, 0x000fe20007ffe0ffULL,
0x000018007aff7f8cULL, 0x0003e6000c80043fULL, 0x0000006e0700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa72000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x002fe40004000000ULL,
0x00016cc000147802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x018fea0003c00000ULL,
0xfffeb90000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x00016d0000147802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e000cULL, 0xfffeb96000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e002fULL, 0x00016d5000157802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x018fea0003c00000ULL, 0xfffeba4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e002fULL, 0x00016d9000157802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x01afea0003c00000ULL, 0xfffebb6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e000dULL, 0x00016de000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000aULL, 0x00000a5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000cULL, 0xfffebf7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e000dULL, 0x00016e3000157802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xfffebf5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe40004000000ULL,
0x00016e8000147802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x008fea0003c00000ULL,
0xfffeedd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x00016ec000147802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000cULL, 0xfffeee1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0038ULL, 0x00016f1000157802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x008fea0003c00000ULL, 0xfffeef0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0038ULL, 0x00016f5000157802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x00afea0003c00000ULL, 0xfffef02000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x00016fa000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000dULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000cULL, 0xfffef45000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x00016ff000157802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xfffef43000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe40004000000ULL,
0x0001704000147802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x018fea0003c00000ULL,
0xffff20e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x0001708000147802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff097224ULL, 0x000fe200078e000cULL, 0xffff213000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0038ULL, 0x000170d000157802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x018fea0003c00000ULL, 0xffff221000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0038ULL, 0x0001711000157802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x01afea0003c00000ULL, 0xffff233000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0007ULL, 0x0001716000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000eULL, 0x000006d000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000cULL, 0xffff275000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0007ULL, 0x000171b000157802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xffff273000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x00cfe40004000000ULL,
0x0001720000147802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x010fea0003c00000ULL,
0xffff544000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x0001724000147802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e000cULL, 0xffff549000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0008ULL, 0x0001729000157802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x010fea0003c00000ULL, 0xffff557000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0008ULL, 0x000172d000157802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x012fea0003c00000ULL, 0xffff569000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0003ULL, 0x0001732000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0008ULL, 0x0000051000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000cULL, 0xffff5af000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0003ULL, 0x0001737000157802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xffff5ad000007947ULL, 0x000fea000383ffffULL, 0x00000002ff137424ULL, 0x000fe200078e00ffULL,
0x000173c000107802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e000bULL, 0xffffeb5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x006fe200078e0014ULL, 0x0001742000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff137424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x0000000b1400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff127224ULL, 0x002fe200078e000eULL,
0x0001748000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff137424ULL, 0x000fe200078e00ffULL,
0x000000140b147208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff127224ULL, 0x002fe200078e000fULL,
0x000174e000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff137424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff127224ULL, 0x002fe200078e0036ULL,
0x0001754000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x0000000f0b0a7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000000b3600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff127224ULL, 0x002fe200078e0014ULL,
0x000175a000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x000000360b0c7208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff127224ULL, 0x002fe200078e000eULL,
0x0001760000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x000000140b0d7208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff127224ULL, 0x002fe200078e000aULL,
0x0001766000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffea2000007947ULL, 0x000fea000383ffffULL, 0x018000000b007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000b00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0bff7812ULL, 0x040fe4000780c0ffULL,
0x800000000b027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000b00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe881002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000003800007348ULL, 0x000fe80003800000ULL, 0x0c000013120b7389ULL, 0x0002a200000e0015ULL,
0xfffe87d010007950ULL, 0x000fea0003c3ffffULL, 0x0000007a00007348ULL, 0x000fe80003800000ULL,
0x0000000c140c7389ULL, 0x0002a400000e007bULL, 0x000000ffff147224ULL, 0x002fc400078e0015ULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffe878014007950ULL, 0x000fea0003c3ffffULL,
0x000000010c00780cULL, 0x000fe20003f45070ULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000007900007348ULL, 0x000ff60003800000ULL, 0x00000000000c7806ULL, 0x000fc800050e0100ULL,
0x000000790c0c7212ULL, 0x000fe200078ec0ffULL, 0xfffe872014007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x00000000000002c0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cb8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d78ULL, 0x00000000000007c0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001538ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001548ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015d8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015dcULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000017980ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019180ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000191d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019550ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015d8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017ba8ULL, 0x0000000000017ba8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000019180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019550ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_86_cubin_len = 103984;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
