/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000143c0ULL, 0x0000000000014040ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x0000000000012980ULL, 0x0000000000000280ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000012c00ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001298000000000ULL, 0x0001080400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x0001298000000000ULL, 0x0000028000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x000823040000007fULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000e000942804ULL, 0x00000960000002c0ULL,
0x00002920000028a0ULL, 0x00002b30000029f0ULL, 0x000030a000003090ULL, 0x00004ce000004c80ULL,
0x00004f2000004de0ULL, 0x0000533000005320ULL, 0x00006ee000006e80ULL, 0x0000712000006fe0ULL,
0x0000753000007520ULL, 0x00009130000090d0ULL, 0x0000937000009230ULL, 0x0000986000009850ULL,
0x0000a9d00000a9c0ULL, 0x00011e0000011d50ULL, 0x000120b000012010ULL, 0x000123e000012280ULL,
0x00012690000125b0ULL, 0x0000047004303904ULL, 0x00017600000000ffULL, 0x0000055000040100ULL,
0x0001760800000000ULL, 0x00000660003f0100ULL, 0x0001768800000000ULL, 0x00000790003f0100ULL,
0x000176a800000003ULL, 0x000008a0003f0100ULL, 0x000176c800000002ULL, 0x00000e00003f0100ULL,
0x00017600000000ffULL, 0x00000f70000a0107ULL, 0x0001768800000000ULL, 0x000018b0003f0101ULL,
0x00000000000000ffULL, 0x000018e000040107ULL, 0x00000000000000ffULL, 0x0000196000040101ULL,
0x0000002000000002ULL, 0x00001ab0003f0101ULL, 0x000176c800000017ULL, 0x00001c40000a0109ULL,
0x000176c800000035ULL, 0x00002550003f0109ULL, 0x000176b000000034ULL, 0x00002620000a0107ULL,
0x000176b000000056ULL, 0x00002630003f0101ULL, 0x000176080000004cULL, 0x00002650003f0101ULL,
0x000176080000004cULL, 0x000027c0003f0109ULL, 0x000176080000004cULL, 0x00002cf0003f0109ULL,
0x000176a80000003cULL, 0x00002e70000a0109ULL, 0x000176a800000036ULL, 0x00003f70003f0109ULL,
0x000176c800000034ULL, 0x00003f90003f0101ULL, 0x0001768800000052ULL, 0x00004040000a0101ULL,
0x0000000000000044ULL, 0x000041b0003f0109ULL, 0x0000000000000044ULL, 0x000049e0003f0109ULL,
0x000176a800000014ULL, 0x00004a30000a0107ULL, 0x000176a800000054ULL, 0x00004a40003f0101ULL,
0x000176280000004cULL, 0x00004a60003f0101ULL, 0x000176280000004cULL, 0x00004bd0003f0109ULL,
0x000176280000004cULL, 0x000050f0003f0109ULL, 0x000176b000000017ULL, 0x00005270000a0109ULL,
0x000176b000000037ULL, 0x00006140003f0109ULL, 0x000176c800000034ULL, 0x00006160003f0101ULL,
0x000176900000003eULL, 0x00006200000a0101ULL, 0x0000000000000044ULL, 0x00006370003f0109ULL,
0x0000000000000044ULL, 0x00006b60003f0109ULL, 0x00000008000000ffULL, 0x00006c3000040107ULL,
0x0000000800000052ULL, 0x00006c40003f0101ULL, 0x000176480000004cULL, 0x00006c60003f0101ULL,
0x000176480000004cULL, 0x00006dd0003f0109ULL, 0x000176480000004cULL, 0x000072f0003f0109ULL,
0x000176a800000017ULL, 0x00007470000a0109ULL, 0x000176a800000037ULL, 0x000083d0003f0109ULL,
0x000176c800000034ULL, 0x000083f0003f0101ULL, 0x0001769800000037ULL, 0x000084a0003f0101ULL,
0x0000000000000044ULL, 0x00008610003f0109ULL, 0x0000000000000044ULL, 0x00008e40003f0109ULL,
0x00000000000000ffULL, 0x00008e9000040107ULL, 0x000176a800000014ULL, 0x00008ea0003f0101ULL,
0x0001766800000006ULL, 0x00008ed0003f0101ULL, 0x0001766800000006ULL, 0x00009040003f0109ULL,
0x0001766800000006ULL, 0x00009530003f0109ULL, 0x000176b00000003dULL, 0x000096e0003f0109ULL,
0x000176b00000003dULL, 0x0000a670003f0109ULL, 0x000176a800000014ULL, 0x0000a6d0003f0101ULL,
0x000176a000000014ULL, 0x0000b910003f0101ULL, 0x00017600000000ffULL, 0x0000d270000a0101ULL,
0x00017600000000ffULL, 0x0000d3e0000a0109ULL, 0x00017600000000ffULL, 0x0000d5c0000a0109ULL,
0x00017600000000ffULL, 0x0000d5e0000a0101ULL, 0x00017600000000ffULL, 0x0000d750000a0109ULL,
0x00017600000000ffULL, 0x000103a0000a0109ULL, 0x0001768800000009ULL, 0x00010570003f0101ULL,
0x0001768800000009ULL, 0x000106e0003f0109ULL, 0x0001768800000009ULL, 0x00012910003f0109ULL,
0x000176080000000aULL, 0x00012930003f0101ULL, 0x000176100000000aULL, 0x00012940003f0101ULL,
0x000176180000000aULL, 0x00012950003f0101ULL, 0x000176200000000aULL, 0x00053803003f0101ULL,
0x0000b24000201c04ULL, 0x0000b4600000b2a0ULL, 0x0000b7500000b5c0ULL, 0x0000d7800000b850ULL,
0x000c050400012970ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL,
0x0000001800080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001700000002ULL,
0x0000000000012980ULL, 0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff047b82ULL, 0x000ea20000000a00ULL,
0x00000000000b7919ULL, 0x000ee20000002200ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x0000000000097919ULL, 0x000f2a0000002100ULL, 0x00000400ff067b82ULL, 0x000f620000000800ULL,
0x0000000000407919ULL, 0x000ea20000002600ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000157919ULL, 0x000eaa0000002700ULL, 0x00008600ff0a7b82ULL, 0x000ee20000000800ULL,
0x0000000500007306ULL, 0x004ea20000209000ULL, 0x000000ff0500720cULL, 0x000fc40003f45070ULL,
0x00000005ff3a7819ULL, 0x010fca0000011609ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x00001fff3a3a7589ULL, 0x000f2200000e0000ULL, 0x0ffffffe00027836ULL, 0x004fcc0000000000ULL,
0x0000000200037305ULL, 0x0004e4000021f000ULL, 0x000000ffff027224ULL, 0x004fe400078e00ffULL,
0x000000ffff087224ULL, 0x008fc800078e0a03ULL, 0x0000000508077224ULL, 0x000fe400078e02ffULL,
0x0000000000087919ULL, 0x000ea40000002300ULL, 0x0000000703037227ULL, 0x000fcc00078e0002ULL,
0x0000000603077227ULL, 0x022fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000000305007224ULL, 0x000fca00078e0206ULL, 0x000000050000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a05ULL, 0x0000000107070836ULL, 0x000fc60000000000ULL,
0x000000050000720cULL, 0x000fda0003f26070ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x00000005ff07a212ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027836ULL, 0x002fe40000000000ULL, 0x0000000408007c24ULL, 0x004fe2000f8e020bULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307067224ULL, 0x004fc800078e02ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a06ULL, 0x0000000d03037227ULL, 0x000fc800078e0002ULL,
0x0000000400027c24ULL, 0x000fe4000f8e0209ULL, 0x0000004003417227ULL, 0x000fe200078e00ffULL,
0x00001fff08097589ULL, 0x00092400000e0000ULL, 0x0000007f0200780cULL, 0x040fe20003f64070ULL,
0x000000ffff037224ULL, 0x000fe200078e0a41ULL, 0x000000030200780cULL, 0x000fc60003f84070ULL,
0x0000000307007224ULL, 0x000fca00078e0240ULL, 0x000000070000720cULL, 0x000fc60003f06070ULL,
0x000000000006b919ULL, 0x000e620000008800ULL, 0x000004000003b802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a07ULL, 0x0000000141410836ULL, 0x000fe20000000000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000070000720cULL, 0x000fda0003f26070ULL,
0x0000000141411836ULL, 0x000fe20000000000ULL, 0x00000007ff41a212ULL, 0x000fe400078e33ffULL,
0x0000000f0200780cULL, 0x000fe40003f24070ULL, 0x000006540603b816ULL, 0x002fe20000000003ULL,
0x000000ffff007224ULL, 0x000fe200078e0a41ULL, 0x000000010200780cULL, 0x000fe20003f44070ULL,
0xff317217ff06b424ULL, 0x000fe400078e00ffULL, 0x0000000007407224ULL, 0x000fc400078e0240ULL,
0x000000040203b824ULL, 0x000fe200078e0203ULL, 0x0000000000240947ULL, 0x010fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01760006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01760804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000402007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01768804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x017400060300b388ULL, 0x0003e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000001040007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000030612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a00ULL, 0x0000000a04037219ULL, 0x002fe200000006ffULL,
0x0000000415047224ULL, 0x000fe200078e02ffULL, 0x0000000a050f7219ULL, 0x000fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000820000087ab9ULL, 0x000fe20000000a00ULL, 0x00000010033b7446ULL, 0x000fe20003800002ULL,
0x0000000409037824ULL, 0x000fe200078e023aULL, 0x0000000a41027219ULL, 0x000fc400000006ffULL,
0x000000ff3b3b7207ULL, 0x000fc60000000000ULL, 0x0000000f04027224ULL, 0x000fe200078e0202ULL,
0x000000103b00780cULL, 0x000fe20003f05270ULL, 0x0000000203047824ULL, 0x000fd800078e00ffULL,
0x0000000000848947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0xffffffffff037424ULL, 0x000fe200078e00ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000087919ULL, 0x000ea60000008800ULL, 0x0000000a03067219ULL, 0x000fe400000006ffULL,
0x00000004ff0b7819ULL, 0x002fca000001160eULL, 0x00000001040d7824ULL, 0x000fc800078e020bULL,
0x0000000100037824ULL, 0x000fca00078e020dULL, 0x0000000603077212ULL, 0x000fe400078e30ffULL,
0x0000000aff067219ULL, 0x000fe40000011603ULL, 0x0000040000037802ULL, 0x000fe20000000f00ULL,
0x0000000102027824ULL, 0x000fe200078e0207ULL, 0x000000043b077248ULL, 0x000fe40007fe0000ULL,
0x0000065408087816ULL, 0x004fe20000000003ULL, 0x0000000f06067224ULL, 0x000fe400078e0202ULL,
0x000000100e037824ULL, 0x000fe200078e00ffULL, 0x00000000080a72caULL, 0x000fe200000e0000ULL,
0x0000000107047824ULL, 0x000fc400078e0a04ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x000000f003117812ULL, 0x000fe400078ec0ffULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x000000010d027824ULL, 0x040fe200078e020eULL, 0x0000001106117212ULL, 0x000fe200078efcffULL,
0x000000100d0d7824ULL, 0x000fc600078e00ffULL, 0x0000000411067c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff00d027812ULL, 0x000fe400078ee202ULL, 0x0000000507077c10ULL, 0x000fe40008ffe4ffULL,
0x0000000a020b7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e2000c101c48ULL, 0x0000000000707947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0xffffffffff037424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000008800ULL,
0x000000040e0b7211ULL, 0x002fe400078fe0ffULL, 0x0000000a03047219ULL, 0x000fc600000006ffULL,
0x0000000100037824ULL, 0x000fca00078e020bULL, 0x0000000403077212ULL, 0x000fe400078e30ffULL,
0x0000000aff047219ULL, 0x000fe20000011603ULL, 0x000000100e037824ULL, 0x000fe400078e00ffULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x0000040000027802ULL, 0x000fc60000000f00ULL,
0x0000000f04077224ULL, 0x000fe200078e0207ULL, 0x000006540d027816ULL, 0x004fe40000000002ULL,
0x000000f0030d7812ULL, 0x000fe200078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x00000000020a72caULL, 0x000fc600000e0000ULL, 0x000000010b027824ULL, 0x040fe200078e020eULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fc600078e00ffULL,
0x0000000406067c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff00b027812ULL, 0x000fe400078ee202ULL,
0x0000000507077c10ULL, 0x000fe400087fe4ffULL, 0x0000000a020b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e4000b901c48ULL,
0x000176000a047890ULL, 0x000fe2000fffe03fULL, 0x00009200ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000415067825ULL, 0x002fe200078e0006ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000806387981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x0000007f38397836ULL, 0x004fe40000000000ULL,
0x000000ff38027836ULL, 0x000fc60000000000ULL, 0x00000007ff397819ULL, 0x000fe40000011639ULL,
0x00000008ff0d7819ULL, 0x000fca0000011602ULL, 0x000000a800688947ULL, 0x000fea0003800000ULL,
0x00000003ff0c7819ULL, 0x000fe2000001163aULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0x01ffffff0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000390c00720cULL, 0x000fda0003f06070ULL, 0x00009400ff098b82ULL, 0x000e620000000800ULL,
0x0000000215008824ULL, 0x000fce00078e00ffULL, 0x00009000ff068b82ULL, 0x000ea20000000a00ULL,
0x0000000900098224ULL, 0x002fe200078e0209ULL, 0x0000000a3a007c11ULL, 0x000fc6000f8e18ffULL,
0x000000010c098824ULL, 0x000fe200078e0209ULL, 0x0176880b00ff79a7ULL, 0x0003e6000850003fULL,
0x0000000409068825ULL, 0x004fca00078e0006ULL, 0x00000008064e8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x00000080410a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x002fe4000001163aULL, 0x000000013a087812ULL, 0x000fc600078ec0ffULL,
0x000000200b097824ULL, 0x000fca00078e00ffULL, 0x000000600a007812ULL, 0x000fe200078ef809ULL,
0x000000054e057224ULL, 0x004fc800078e02ffULL, 0x0000008005197824ULL, 0x000fe200078e00ffULL,
0x0000000400080947ULL, 0x000fec0003800000ULL, 0x0000000938027248ULL, 0x000fe20007fe0000ULL,
0x0000001008057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fe2000001160eULL,
0x00008e00ff1e7b82ULL, 0x000e640000000a00ULL, 0x0000000102027824ULL, 0x000fe400078e0a09ULL,
0x0000000105077824ULL, 0x000fe400078e0204ULL, 0x0000000404107836ULL, 0x000fe20000000000ULL,
0x0000000502027248ULL, 0x000fe20007fe0000ULL, 0x0000000107067824ULL, 0x000fc400078e020eULL,
0x0000000807117824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fc600078e0a05ULL,
0xfffffff811147812ULL, 0x000fe200078ee206ULL, 0x0000000804067836ULL, 0x000fe20000000000ULL,
0x000000020400720cULL, 0x080fe20003f66070ULL, 0x0000000105117824ULL, 0x040fe200078e0210ULL,
0x000000021000720cULL, 0x080fe20003f46070ULL, 0x0000000c04047836ULL, 0x000fe20000000000ULL,
0x000000020600720cULL, 0x080fe20003f26070ULL, 0x0000000105137824ULL, 0x000fe400078e0206ULL,
0x0000000111067824ULL, 0x040fe200078e020eULL, 0x000000020400720cULL, 0x000fe20003f06070ULL,
0x00000008111b7824ULL, 0x000fc400078e00ffULL, 0x0000000105177824ULL, 0x000fe400078e0204ULL,
0x0000000100047824ULL, 0x040fe200078e0207ULL, 0xfffffff81b167812ULL, 0x000fe200078ee206ULL,
0x0000000100067824ULL, 0x040fe400078e0211ULL, 0x0000000100107824ULL, 0x040fe400078e0213ULL,
0x0000000100127824ULL, 0x000fe400078e0217ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000000117027824ULL, 0x140fe200078e020eULL, 0x0000007004047812ULL, 0x000fe200078ef803ULL,
0x0000000817077824ULL, 0x000fe200078e00ffULL, 0x0000001e19177211ULL, 0x002fe200078838ffULL,
0x0000000113007824ULL, 0x040fe400078e020eULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0xfffffff8071a7812ULL, 0x000fe200078ee202ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000001f191f7211ULL, 0x000fe400020f3cffULL, 0xfffffff813187812ULL, 0x000fe200078ee200ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000417047210ULL, 0x000fc40007f9e0ffULL,
0x0000000a0b007c11ULL, 0x000fe2000f8e68ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007006027812ULL, 0x000fe400078ef803ULL, 0x0000007010067812ULL, 0x000fe200078ef803ULL,
0x0000000105057824ULL, 0x000fe200020e061fULL, 0x0000007012107812ULL, 0x000fe200078ef803ULL,
0x0001300000037836ULL, 0x000fe20000000000ULL, 0x0000001702027210ULL, 0x000fe40007f9e0ffULL,
0x0000001706067210ULL, 0x000fe20007fbe0ffULL, 0x0000001016197824ULL, 0x100fe200078e0203ULL,
0x0000001710107210ULL, 0x000fe20007fde0ffULL, 0x0000001014177824ULL, 0x000fc400078e0203ULL,
0x00000010181b7824ULL, 0x100fe400078e0203ULL, 0x000000101a1d7824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000d901c48ULL,
0x0000000107037824ULL, 0x100fe400020e061fULL, 0x0000000111077824ULL, 0x100fe400028e061fULL,
0x0000000113117824ULL, 0x000fe200030e061fULL, 0x0000000002197faeULL, 0x0003e8000d101c48ULL,
0x00000000061b7faeULL, 0x0003e8000c901c48ULL, 0x00000000101d7faeULL, 0x0003e2000c101c48ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x0000001008057824ULL, 0x000fe200078e00ffULL,
0x00008e00ff1a7b82ULL, 0x000e680000000a00ULL, 0x000000050e057211ULL, 0x000fca00078fe8ffULL,
0x0000000105027824ULL, 0x140fe400078e020eULL, 0x0000000805117824ULL, 0x000fe400078e00ffULL,
0x0000000405077836ULL, 0x000fe40000000000ULL, 0x0000000c05137836ULL, 0x000fe20000000000ULL,
0xfffffff811147812ULL, 0x000fe200078ee202ULL, 0x0000000107027824ULL, 0x040fe400078e020eULL,
0x0000000807177824ULL, 0x000fc400078e00ffULL, 0x0000000805117836ULL, 0x000fe40000000000ULL,
0x0000000100047824ULL, 0x040fe200078e0205ULL, 0xfffffff817167812ULL, 0x000fe200078ee202ULL,
0x0000000100077824ULL, 0x040fe200078e0207ULL, 0x0000001a19177211ULL, 0x042fe200078038ffULL,
0x0000000100107824ULL, 0x040fe400078e0211ULL, 0x0000000100127824ULL, 0x000fe200078e0213ULL,
0x0000001b191f7211ULL, 0x000fe200000f3cffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000000a0b197c11ULL, 0x000fc6000f8e68ffULL, 0x0000000111007824ULL, 0x140fe200078e020eULL,
0x0000007004047812ULL, 0x000fe200078ef803ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x0000000113027824ULL, 0x040fe200078e020eULL, 0x0000000417047210ULL, 0x000fe20007f1e0ffULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0xfffffff811007812ULL, 0x000fe200078ee200ULL,
0x0000008007067825ULL, 0x000fc600078e00ffULL, 0xfffffff813187812ULL, 0x000fe200078ee202ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000007006027812ULL, 0x000fc600078ef803ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007010067812ULL, 0x000fc600078ef803ULL,
0x0000000105057824ULL, 0x000fe200000e061fULL, 0x0000007012037812ULL, 0x000fe200078ef803ULL,
0x00013000191d7836ULL, 0x000fe20000000000ULL, 0x0000000217027210ULL, 0x000fe40007f1e0ffULL,
0x0000000617067210ULL, 0x000fe20007f3e0ffULL, 0x0000001016197824ULL, 0x100fe200078e021dULL,
0x0000000317107210ULL, 0x000fe20007f5e0ffULL, 0x0000001014177824ULL, 0x000fe400078e021dULL,
0x0000000107037824ULL, 0x000fc400000e061fULL, 0x00000010001b7824ULL, 0x000fe200078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x0000000111077824ULL, 0x000fe400008e061fULL, 0x00000010181d7824ULL, 0x000fe200078e021dULL,
0x0000000002197faeULL, 0x0003e2000b901c48ULL, 0x0000000113117824ULL, 0x000fc600010e061fULL,
0x00000000061b7faeULL, 0x0003e8000b901c48ULL, 0x00000000101d7faeULL, 0x0003e4000b901c48ULL,
0x0000000aff007e24ULL, 0x000fe2000f8e00ffULL, 0x000000000b0472caULL, 0x000fe200000e0000ULL,
0x00000001ff037424ULL, 0x002fe200078e00ffULL, 0x000000ff0d00720cULL, 0x000fe20003f05270ULL,
0x000176a800007836ULL, 0x000fe20000000000ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff4f7224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000572caULL, 0x000fc400000e0000ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe400078e00ffULL, 0x000000080b027824ULL, 0x000fe400078e0200ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000003ff4679a7ULL, 0x0002a20008500004ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00002003020279a7ULL, 0x002e62000850003fULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000008c00a08947ULL, 0x000fec0003800000ULL,
0x00009400ff047b82ULL, 0x000ee20000000800ULL, 0x00000002ff077819ULL, 0x000fe2000001163aULL,
0x000000083a027824ULL, 0x002fe200078e00ffULL, 0x000000010b007812ULL, 0x000fe200078ec0ffULL,
0x0000000215157824ULL, 0x000fe200078e00ffULL, 0x0000000a07057c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff347224ULL, 0x000fe200078e0003ULL, 0x0000000802027812ULL, 0x000fe200078ec0ffULL,
0xff317217ff507424ULL, 0x000fe400078e00ffULL, 0x0000001000057824ULL, 0x000fc400078e0205ULL,
0x000000ffff137224ULL, 0x000fe400078e00ffULL, 0x0000000102067824ULL, 0x000fe400078e0205ULL,
0x0000000415057224ULL, 0x008fe400078e0204ULL, 0x000000ffff047224ULL, 0x000fce00078e00ffULL,
0x0000000000147805ULL, 0x010fce0000015200ULL, 0x000000043a167824ULL, 0x000fca00078e00ffULL,
0xfffffff816177812ULL, 0x000fc800078ec0ffULL, 0x0176c834170075a7ULL, 0x000e62000800014aULL,
0x0000000a17357c36ULL, 0x000fc80008000000ULL, 0x000176c835447836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176c834350075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000103a147824ULL, 0x000fe200078e00ffULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x0000000104167836ULL, 0x000fe40000000000ULL, 0x000000054e347c24ULL, 0x000fe2000f8e02ffULL,
0xffffffe014157812ULL, 0x000fe400078ec0ffULL, 0x0000000d1600720cULL, 0x000fe20003f26070ULL,
0x0000008034347824ULL, 0x000fe400078e00ffULL, 0x0000010004157824ULL, 0x000fc800078e0215ULL,
0x0000004015357836ULL, 0x000fca0000000000ULL, 0x0000006035157812ULL, 0x000fca00078ec0ffULL,
0x000000010a487824ULL, 0x000fe200078e0215ULL, 0x0000000400109947ULL, 0x000fec0003800000ULL,
0x0000001014177812ULL, 0x000fe400078ec0ffULL, 0x0000003538147248ULL, 0x000fe40007fe0000ULL,
0x00000003ff377819ULL, 0x000fc6000001160eULL, 0x0000000114147824ULL, 0x000fe400078e0a35ULL,
0x0000000137357824ULL, 0x100fe400078e0217ULL, 0x0000000c373c7836ULL, 0x000fe20000000000ULL,
0x0000001714167248ULL, 0x000fe20007fe0000ULL, 0x0000000135367824ULL, 0x040fe200078e020eULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x00000008353d7824ULL, 0x000fe400078e00ffULL,
0x0000000116167824ULL, 0x000fc400078e0a17ULL, 0x000000013c3f7824ULL, 0x140fe200078e0217ULL,
0xfffffff83d3e7812ULL, 0x000fe200078ee236ULL, 0x0000000437367836ULL, 0x000fe20000000000ULL,
0x000000163700720cULL, 0x080fe20003f86070ULL, 0x00000008373d7836ULL, 0x000fe20000000000ULL,
0x000000163c00720cULL, 0x080fe20003f06070ULL, 0x0000000136377824ULL, 0x140fe200078e0217ULL,
0x000000163600720cULL, 0x080fe20003f66070ULL, 0x000000100e367824ULL, 0x000fe200078e00ffULL,
0x000000163d00720cULL, 0x040fe20003f46070ULL, 0x000000013d3d7824ULL, 0x000fc400078e0217ULL,
0x0000000137167824ULL, 0x140fe400078e020eULL, 0x0000000837437824ULL, 0x000fe400078e00ffULL,
0x00000001483c7824ULL, 0x000fe400078e0235ULL, 0x000000013d177824ULL, 0x040fe200078e020eULL,
0xfffffff843427812ULL, 0x000fe200078ee216ULL, 0x000000083d467824ULL, 0x004fe200078e00ffULL,
0x0000007036437812ULL, 0x000fe200078ec0ffULL, 0x0000000148357824ULL, 0x000fc400078e023dULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fc600078ee217ULL,
0x0000000148167824ULL, 0x040fe400078e0237ULL, 0x0000000148367824ULL, 0x000fe400078e023fULL,
0x000000013f377824ULL, 0x040fe400078e020eULL, 0x000000083f487824ULL, 0x000fe200078e00ffULL,
0x00000014343f7211ULL, 0x002fe200078a38ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000433c147212ULL, 0x000fe400078efcffULL, 0x0000001534497211ULL, 0x000fe200028f3cffULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x000000143f147210ULL, 0x000fc40007fbe0ffULL,
0x0000004316167212ULL, 0x080fe400078efcffULL, 0xfffffff8483c7812ULL, 0x000fe200078ee237ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004334347212ULL, 0x000fc600078efcffULL,
0x000000013d157824ULL, 0x100fe200028e0649ULL, 0x0000000a0b3d7c11ULL, 0x000fe4000f8e68ffULL,
0x0000003f16167210ULL, 0x000fe40007fbe0ffULL, 0x0000004336367212ULL, 0x000fe200078efcffULL,
0x000140003d3d7836ULL, 0x000fe40000000000ULL, 0x0000000117177824ULL, 0x000fe200028e0649ULL,
0x0000003f34347210ULL, 0x000fe20007fbe0ffULL, 0x0000001042437824ULL, 0x100fe200078e023dULL,
0x0000003f36367210ULL, 0x000fe20007fde0ffULL, 0x000000103e3f7824ULL, 0x000fc400078e023dULL,
0x0000001046457824ULL, 0x000fe400078e023dULL, 0x0000000135357824ULL, 0x000fe200028e0649ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143f7faeULL, 0x0003e2000e101c48ULL,
0x000000103c3d7824ULL, 0x000fe400078e023dULL, 0x0000000137377824ULL, 0x000fe200030e0649ULL,
0x0000000016437faeULL, 0x0003e8000d901c48ULL, 0x0000000034457faeULL, 0x0003e8000d101c48ULL,
0x00000000363d7faeULL, 0x0003e2000c101c48ULL, 0x0000000000dc7947ULL, 0x000fea0003800000ULL,
0x0000001014177812ULL, 0x000fe400078ec0ffULL, 0x00008e00ff147b82ULL, 0x000e640000000a00ULL,
0x000000170e177211ULL, 0x000fca00078fe8ffULL, 0x0000000117167824ULL, 0x140fe400078e020eULL,
0x0000000817377824ULL, 0x000fe400078e00ffULL, 0x0000000417357836ULL, 0x000fe40000000000ULL,
0x00000001483c7824ULL, 0x000fe200078e0217ULL, 0xfffffff8373e7812ULL, 0x000fe200078ee216ULL,
0x0000000135367824ULL, 0x040fe400078e020eULL, 0x00000008353f7824ULL, 0x000fc400078e00ffULL,
0x000000100e167824ULL, 0x000fe400078e00ffULL, 0x0000000817377836ULL, 0x000fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee236ULL, 0x0000000c17437836ULL, 0x000fe20000000000ULL,
0x0000007016457812ULL, 0x000fe200078ec0ffULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x0000000148167824ULL, 0x040fe400078e0235ULL, 0x0000000148367824ULL, 0x040fe400078e0237ULL,
0x0000000137177824ULL, 0x140fe400078e020eULL, 0x0000000837427824ULL, 0x000fe400078e00ffULL,
0x0000000148357824ULL, 0x000fe400078e0243ULL, 0x0000000143377824ULL, 0x000fc400078e020eULL,
0x0000000843467824ULL, 0x004fe200078e00ffULL, 0x0000001434437211ULL, 0x002fe400078038ffULL,
0x000000453c147212ULL, 0x000fe400078efcffULL, 0x0000001534497211ULL, 0x000fe200000f3cffULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x0000001443147210ULL, 0x000fe40007f1e0ffULL,
0xfffffff8423c7812ULL, 0x000fe200078ee217ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff846427812ULL, 0x000fc400078ee237ULL, 0x0000004534347212ULL, 0x080fe200078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004516167212ULL, 0x080fe400078efcffULL,
0x0000003443347210ULL, 0x000fe20007f7e0ffULL, 0x000000013d157824ULL, 0x100fe200000e0649ULL,
0x0000000a0b3d7c11ULL, 0x000fe4000f8e68ffULL, 0x0000004536367212ULL, 0x000fe200078efcffULL,
0x0000000135357824ULL, 0x000fe200018e0649ULL, 0x0000001643167210ULL, 0x000fe20007f1e0ffULL,
0x000140003d457836ULL, 0x000fe20000000000ULL, 0x0000003643367210ULL, 0x000fc60007f5e0ffULL,
0x000000103e3d7824ULL, 0x100fe400078e0245ULL, 0x000000103f3f7824ULL, 0x000fe400078e0245ULL,
0x0000000117177824ULL, 0x000fe200000e0649ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c48ULL, 0x000000103c437824ULL, 0x000fe400078e0245ULL,
0x0000000137377824ULL, 0x000fe200010e0649ULL, 0x00000000163f7faeULL, 0x0003e2000b901c48ULL,
0x0000001042457824ULL, 0x000fc600078e0245ULL, 0x0000000036437faeULL, 0x0003e8000b901c48ULL,
0x0000000034457faeULL, 0x0003e4000b901c48ULL, 0x000000010c167836ULL, 0x002fe40000000000ULL,
0xffffffffff517424ULL, 0x000fc600078e00ffULL, 0x000000391600720cULL, 0x000fe20003f06070ULL,
0x000000083a3c7824ULL, 0x000fca00078e00ffULL, 0xfffffff03c347812ULL, 0x000fca00078ec0ffULL,
0x0000000a34567c36ULL, 0x000fe40008000000ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x0000000105178824ULL, 0x000fe200078e0216ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000560572caULL, 0x000fda00000e0000ULL, 0x000176b005057890ULL, 0x000fe2000fffe03fULL,
0x0000000417148825ULL, 0x002fd000078e0014ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a45ULL,
0x0000000814518981ULL, 0x000322000c1e1900ULL, 0xffffffe03c167812ULL, 0x040fe200078ec0ffULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x000000103c177812ULL, 0x000fc800078ec0ffULL,
0x0000000a17167c10ULL, 0x000fe4000fffe016ULL, 0x000000083c177812ULL, 0x000fca00078ec0ffULL,
0x00000001164c7824ULL, 0x000fe200078e0217ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x0176b035565679a7ULL, 0x0002a4000850003fULL, 0x017608354c3479a7ULL, 0x0022e4000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x017608354c0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017608354c0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000100e427824ULL, 0x000fe200078e00ffULL, 0x00000001ff457819ULL, 0x000fe2000001160eULL,
0x000000203a147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000007042427812ULL, 0x000fe400078ec0ffULL, 0xffffff8014157812ULL, 0x000fe400078ec0ffULL,
0x0000000c45457812ULL, 0x000fe400078ec0ffULL, 0x0000000a42147c10ULL, 0x000fca000fffe015ULL,
0x0000000114147824ULL, 0x000fca00078e0245ULL, 0x0170000014157984ULL, 0x000ee80000000800ULL,
0x0172000014177984ULL, 0x000b620000000800ULL, 0x000000501500720bULL, 0x008fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16367812ULL, 0x000fda000780c0ffULL,
0x0000000000fc8947ULL, 0x026fea0003800000ULL, 0x0000003a0700720cULL, 0x000fe40003f45270ULL,
0x000000501500720bULL, 0x000fd60003f14000ULL, 0x0000000a3a16ac11ULL, 0x000fe4000f8e38ffULL,
0x000000501514a209ULL, 0x000fe40007810000ULL, 0x000000164535a210ULL, 0x000fe40007ffe042ULL,
0x0000000000377806ULL, 0x000fc600000e0100ULL, 0x017400143500a388ULL, 0x0003e20000000800ULL,
0x0000991037167816ULL, 0x000fc800000000ffULL, 0x000000ff1600720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005015357209ULL, 0x000fe40007810000ULL,
0x000000ff37ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0037ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005035147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400357308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160eULL, 0x00001f1435147589ULL, 0x004e6400000e0000ULL,
0x0000001418187220ULL, 0x082fe20000410000ULL, 0x0000001419197220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x0000001410107220ULL, 0x080fe20000410000ULL, 0x0000001411117220ULL, 0x000fce0000410000ULL,
0x000000354f4f7220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1435147589ULL, 0x000e6400000e0000ULL,
0x000000141a1a7220ULL, 0x082fe20000410000ULL, 0x000000141b1b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x000000141e1e7220ULL, 0x080fe20000410000ULL, 0x000000141f1f7220ULL, 0x080fe20000410000ULL,
0x0000001412127220ULL, 0x080fe20000410000ULL, 0x0000001413137220ULL, 0x000fce0000410000ULL,
0x0000ffff36ff7812ULL, 0x000fe20007806037ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005015507209ULL, 0x000fd60007810000ULL, 0x8000005015150221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL,
0x0000001500020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000004f174f7221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0xfffffff03c3c7812ULL, 0x000fc800078ec0ffULL, 0x0176a8473c0075a7ULL, 0x000e62000800014aULL,
0x0000000a3c367c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176a847360075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034157816ULL, 0x000fe200000000ffULL,
0x000000023a527824ULL, 0x000fe200078e00ffULL, 0x000000070e5b7812ULL, 0x000fe200078ec0ffULL,
0x000002003a147824ULL, 0x040fe200078e00ffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000043a497824ULL, 0x000fe200078e00ffULL, 0x0000000452157812ULL, 0x000fe400078ec0ffULL,
0xfffff800144e7812ULL, 0x000fe400078ec0ffULL, 0x000000085b597812ULL, 0x000fc400078ef80eULL,
0x000000150e147211ULL, 0x040fe200078fe0ffULL, 0x0000000a4e4e7c36ULL, 0x000fe20008000000ULL,
0x000000080e587812ULL, 0x000fe200078ec0ffULL, 0x0000000859347824ULL, 0x040fe200078e00ffULL,
0x00000004ff5a7819ULL, 0x000fe2000001160eULL, 0x0000000159437824ULL, 0x000fe200078e0214ULL,
0x0000000449497812ULL, 0x000fe400078ec0ffULL, 0x0000005b58167212ULL, 0x000fe400078efcffULL,
0x0000000a0b487c11ULL, 0x000fe2000f8e68ffULL, 0x000000015a497824ULL, 0x000fe200078e0249ULL,
0xfffffff834157812ULL, 0x000fe200078ee243ULL, 0x00000008164d7824ULL, 0x000fc400078e00ffULL,
0x0000000116147824ULL, 0x040fe400078e0249ULL, 0x0001300048467836ULL, 0x000fe40000000000ULL,
0x0000000816347824ULL, 0x000fe200078e00ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee214ULL,
0x00000002144b7836ULL, 0x000fe40000000000ULL, 0x00000010154a7824ULL, 0x000fe200078e024eULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011000004a14783bULL, 0x0022e20000000200ULL,
0x000000104d3c7824ULL, 0x000fe200078e0246ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0xfffffff8344b7812ULL, 0x000fe400078ee24bULL,
0x0000001058587812ULL, 0x000fc600078efe5bULL, 0x000000104b347824ULL, 0x000fcc00078e0246ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x00000018ff6a7819ULL, 0x022fe2000001143dULL,
0x000001003d5d7824ULL, 0x040fe200078e00ffULL, 0x000088803d6f7816ULL, 0x040fe200000000ffULL,
0x000001003c5c7824ULL, 0x040fe200078e00ffULL, 0x000088803c617816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001143cULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff5f7819ULL, 0x008fe40000011434ULL, 0x0000888034647816ULL, 0x000fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000005c006e7306ULL, 0x0003e20000202400ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff5e7819ULL, 0x000fe40000011435ULL,
0x0000888035627816ULL, 0x000fc400000000ffULL, 0x000088803e687816ULL, 0x040fe200000000ffULL,
0x0000003d00717306ULL, 0x0007e20000202400ULL, 0x000001003e5c7824ULL, 0x042fe200078e00ffULL,
0x000088803f667816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe2000001143eULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000006100617306ULL, 0x000fe20000202400ULL, 0x00000100343d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011436ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011437ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005d00707306ULL, 0x000e620000202400ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff557819ULL, 0x000fe4000001143fULL, 0x00000018ff3e7819ULL, 0x000fc6000001143eULL,
0x0000005c006b7306ULL, 0x0007f00000202400ULL, 0x0000003400607306ULL, 0x000be20000202400ULL,
0x00000100355c7824ULL, 0x048fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000003c006d7306ULL, 0x0007e20000202400ULL,
0x0000010037347824ULL, 0x024fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006c006c7306ULL, 0x000ea20000202400ULL,
0x000001003f3c7824ULL, 0x048fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006a006a7306ULL, 0x000ee20000202400ULL,
0x00000018ff3f7819ULL, 0x000fce000001143fULL, 0x0000003500637306ULL, 0x0003f00000202400ULL,
0x00000034005d7306ULL, 0x000be20000202400ULL, 0x000054106f357816ULL, 0x002fce0000000070ULL,
0x0000006800687306ULL, 0x000e620000202400ULL, 0x0000541061347816ULL, 0x020fce000000006eULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x000000341418723cULL, 0x000fee0000041818ULL,
0x0000003c00697306ULL, 0x000a620000202400ULL, 0x000054106d347816ULL, 0x004fe4000000006cULL,
0x0000541071357816ULL, 0x008fca000000006aULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x00000100363c7824ULL, 0x020fe200078e00ffULL, 0x00000034142c723cULL, 0x000fe8000004182cULL,
0x00000018ff727819ULL, 0x000fe4000001143cULL, 0x0000003d00657306ULL, 0x0004e20000202400ULL,
0x0000541068347816ULL, 0x002fe4000000006bULL, 0x0000541066357816ULL, 0x000fc40000000069ULL,
0x00008880373c7816ULL, 0x040fe200000000ffULL, 0x0001000037377824ULL, 0x000fe400078e00ffULL,
0x0000006200627306ULL, 0x000fe20000202400ULL, 0x00008880363d7816ULL, 0x044fe200000000ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fc80000011437ULL, 0x0000005c00677306ULL, 0x000e620000202400ULL,
0x0000541064347816ULL, 0x008fe40000000065ULL, 0x00000018ff367819ULL, 0x000fca0000011436ULL,
0x0000005f005f7306ULL, 0x000ea20000202400ULL, 0x0000541062357816ULL, 0x002fce0000000067ULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x000000341424723cULL, 0x000fee0000041824ULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x0000541060347816ULL, 0x004fe4000000005fULL,
0x0000541063357816ULL, 0x002fca000000005eULL, 0x00000072005c7306ULL, 0x000e620000202400ULL,
0x000000040b5e7824ULL, 0x000fe200078e025aULL, 0x000000341420723cULL, 0x000fe80000041820ULL,
0x000000025e5e7810ULL, 0x000fe40007ffe059ULL, 0x0000003c003c7306ULL, 0x000ea20000202400ULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0x000054103d347816ULL, 0x002fcc000000005cULL,
0x0000003e00617306ULL, 0x000fe20000202400ULL, 0x00000008583d7824ULL, 0x000fe200078e00ffULL,
0x000054103c357816ULL, 0x004fcc000000005dULL, 0x0000005400547306ULL, 0x000e620000202400ULL,
0x00000034141c723cULL, 0x000fee000004181cULL, 0x0000004700477306ULL, 0x000fe20000202400ULL,
0xfffffff859357812ULL, 0x000fe200078ee25eULL, 0x0000000149347824ULL, 0x000fe200078e0258ULL,
0x0000541061547816ULL, 0x002fca0000000054ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x00000010354e7824ULL, 0x000fe200078e024eULL, 0xfffffff83d497812ULL, 0x000fcc00078ee234ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000010493c7824ULL, 0x000fce00078e0246ULL,
0x0000003600367306ULL, 0x000e700000202400ULL, 0x0000003f003e7306ULL, 0x000ea20000202400ULL,
0x0000541036367816ULL, 0x002fce0000000047ULL, 0x00000037005a7306ULL, 0x000e620000202400ULL,
0x000054103e557816ULL, 0x004fce0000000055ULL, 0x000000541428723cULL, 0x000fe20000041828ULL,
0x000054105a377816ULL, 0x002fce0000000053ULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x011000004e14783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000000858587824ULL, 0x000fe200078e00ffULL, 0xfffffff852527812ULL, 0x000fe200078ec0ffULL,
0x0000000234477836ULL, 0x000fca0000000000ULL, 0xfffffff858477812ULL, 0x000fca00078ee247ULL,
0x0000001047347824ULL, 0x000fcc00078e0246ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x00000018ff637819ULL, 0x008fe2000001143cULL, 0x000001003c597824ULL, 0x040fe200078e00ffULL,
0x000088803c667816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe2000001143dULL, 0x000001003d5a7824ULL, 0x040fe200078e00ffULL,
0x000088803d6b7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x00000018ff597819ULL, 0x000fc40000011459ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5f7819ULL, 0x000fe2000001143eULL,
0x0000003c006a7306ULL, 0x0007e20000202400ULL, 0x000088803e647816ULL, 0x000fe400000000ffULL,
0x00000018ff587819ULL, 0x022fe40000011434ULL, 0x00000018ff557819ULL, 0x000fc40000011435ULL,
0x00008880345b7816ULL, 0x000fe200000000ffULL, 0x0000005900697306ULL, 0x0003620000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x000088803f657816ULL, 0x040fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001143fULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x000001003e597824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011437ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000005a006c7306ULL, 0x0002e20000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff537819ULL, 0x000fca0000011436ULL,
0x0000003d006d7306ULL, 0x0007e20000202400ULL, 0x00008880355a7816ULL, 0x002fce00000000ffULL,
0x0000003c00687306ULL, 0x0003e20000202400ULL, 0x00000100343d7824ULL, 0x04cfe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006300637306ULL, 0x000ea20000202400ULL, 0x00000100353c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143cULL, 0x0000006200627306ULL, 0x000e620000202400ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880363c7816ULL, 0x000fca00000000ffULL,
0x0000005900677306ULL, 0x000ff00000202400ULL, 0x0000003e00607306ULL, 0x000ff00000202400ULL,
0x0000003400597306ULL, 0x000bf00000202400ULL, 0x00000035003e7306ULL, 0x0007e20000202400ULL,
0x0000541066347816ULL, 0x020fe20000000069ULL, 0x0000010037667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000006400647306ULL, 0x000f620000202400ULL,
0x000054106b357816ULL, 0x008fce000000006cULL, 0x0000006500657306ULL, 0x000ee20000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x000054106a347816ULL, 0x004fe20000000063ULL,
0x0000005f005f7306ULL, 0x000ea20000202400ULL, 0x000054106d357816ULL, 0x002fce0000000062ULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x00000034142c723cULL, 0x000fee000004182cULL,
0x0000003f00617306ULL, 0x0002a20000202400ULL, 0x0001000036357824ULL, 0x000fe200078e00ffULL,
0x0000541064347816ULL, 0x020fc80000000067ULL, 0x00000018ff627819ULL, 0x000fe40000011435ULL,
0x0000541065357816ULL, 0x008fe20000000068ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x00008880373f7816ULL, 0x042fe200000000ffULL, 0x0001000037377824ULL, 0x000fc800078e00ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000003d005c7306ULL, 0x0002ea0000202400ULL, 0x0000541060347816ULL, 0x004fe4000000005fULL,
0x0000541061357816ULL, 0x000fe2000000005eULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x00000100363d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x0000005d005d7306ULL, 0x000e6c0000202400ULL,
0x000054105b347816ULL, 0x008fe4000000005cULL, 0x0000005800587306ULL, 0x000ea20000202400ULL,
0x000054105a357816ULL, 0x002fce000000005dULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x000000341424723cULL, 0x000fee0000041824ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541059347816ULL, 0x004fe40000000058ULL, 0x000054103e357816ULL, 0x002fca0000000055ULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x00000001ff557424ULL, 0x000fe200078e00ffULL,
0x000000341420723cULL, 0x000fec0000041820ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x0000000a0b347c11ULL, 0x000fe4000f8e18ffULL, 0x000054103c3c7816ULL, 0x002fca000000003dULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0176c855343479a7ULL, 0x00026e000850003fULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x0176885552ff79a7ULL, 0x0003ee000850000aULL,
0x0000006600367306ULL, 0x000eb00000202400ULL, 0x0000006200627306ULL, 0x000ee20000202400ULL,
0x000054103f3d7816ULL, 0x004fce0000000036ULL, 0x0000003700377306ULL, 0x000ea20000202400ULL,
0x0000003c141c723cULL, 0x000fe2000004181cULL, 0x0000541062627816ULL, 0x008fe40000000053ULL,
0x0000541037637816ULL, 0x004fce0000000054ULL, 0x000000621410723cULL, 0x002fde0000041810ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035440075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035440075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000103a147824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe40000000800ULL, 0x0000000551517c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe014157812ULL, 0x000fe400078ec0ffULL, 0x0000008051527824ULL, 0x000fc600078e00ffULL,
0x0000010004157824ULL, 0x000fc800078e0215ULL, 0x0000008015177836ULL, 0x000fca0000000000ULL,
0x0000006017157812ULL, 0x000fca00078ec0ffULL, 0x000000010a157824ULL, 0x000fe200078e0215ULL,
0x0000000400009947ULL, 0x000fec0003800000ULL, 0x0000001014377812ULL, 0x000fe400078ec0ffULL,
0x00000003ff167819ULL, 0x000fe4000001160eULL, 0x0000001738147248ULL, 0x000fc60007fe0000ULL,
0x00000001163c7824ULL, 0x000fe400078e0237ULL, 0x0000000114147824ULL, 0x000fe400078e0a17ULL,
0x000000013c177824ULL, 0x040fe400078e020eULL, 0x000000083c347824ULL, 0x000fe200078e00ffULL,
0x0000001437147248ULL, 0x000fe20007fe0000ULL, 0x0000000416367836ULL, 0x000fe40000000000ULL,
0x0000000c163d7836ULL, 0x000fe20000000000ULL, 0xfffffff834517812ULL, 0x000fe200078ee217ULL,
0x0000000114147824ULL, 0x000fe200078e0a37ULL, 0x00008e00ff347b82ULL, 0x000e620000000a00ULL,
0x0000000816177836ULL, 0x000fc40000000000ULL, 0x000000013c3c7824ULL, 0x000fe200078e0215ULL,
0x000000143600720cULL, 0x0c0fe20003f66070ULL, 0x0000000136367824ULL, 0x100fe200078e0237ULL,
0x000000141600720cULL, 0x080fe40003f86070ULL, 0x000000141700720cULL, 0x080fe20003f46070ULL,
0x0000000136167824ULL, 0x040fe200078e020eULL, 0x000000143d00720cULL, 0x000fe20003f06070ULL,
0x0000000836537824ULL, 0x000fe400078e00ffULL, 0x0000000117177824ULL, 0x000fc400078e0237ULL,
0x000000013d377824ULL, 0x000fe200078e0237ULL, 0xfffffff853537812ULL, 0x000fe200078ee216ULL,
0x0000000136367824ULL, 0x100fe400078e0215ULL, 0x0000000117167824ULL, 0x100fe400078e0215ULL,
0x0000000137147824ULL, 0x000fe400078e0215ULL, 0x0000000117157824ULL, 0x040fe200078e020eULL,
0x00000034523f7211ULL, 0x002fe200078a38ffULL, 0x00000008173e7824ULL, 0x000fc400078e00ffULL,
0x0000000137177824ULL, 0x040fe200078e020eULL, 0x0000003552557211ULL, 0x000fe200028f3cffULL,
0x0000000837547824ULL, 0x000fe200078e00ffULL, 0xfffffff83e597812ULL, 0x000fe200078ee215ULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff8545b7812ULL, 0x000fe200078ee217ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000423c347212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004236367212ULL, 0x080fe400078efcffULL,
0x000000343f347210ULL, 0x000fe20007fbe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003f36367210ULL, 0x000fe40007fde0ffULL, 0x0000004216167212ULL, 0x080fe200078efcffULL,
0x000000013d357824ULL, 0x100fe200028e0655ULL, 0x0000004214147212ULL, 0x000fe200078efcffULL,
0x0000000137377824ULL, 0x000fe200030e0655ULL, 0x0000003f16167210ULL, 0x000fe20007fbe0ffULL,
0x00000010513d7824ULL, 0x100fe200078e0246ULL, 0x0000003f14147210ULL, 0x000fe20007fde0ffULL,
0x00000010533f7824ULL, 0x000fc400078e0246ULL, 0x0000001059517824ULL, 0x100fe200078e0246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343d7faeULL, 0x0003e2000e101c48ULL,
0x0000000117177824ULL, 0x100fe400028e0655ULL, 0x000000105b537824ULL, 0x000fe200078e0246ULL,
0x00000000363f7faeULL, 0x0003e2000d901c48ULL, 0x0000000115157824ULL, 0x000fc600030e0655ULL,
0x0000000016517faeULL, 0x0003e8000d101c48ULL, 0x0000000014537faeULL, 0x0003e2000c101c48ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000001014177812ULL, 0x000fc800078ec0ffULL,
0x000000170e147211ULL, 0x000fe400078fe8ffULL, 0x00008e00ff167b82ULL, 0x000e660000000a00ULL,
0x0000000114347824ULL, 0x040fe400078e020eULL, 0x00000008143f7824ULL, 0x000fe400078e00ffULL,
0x0000000414357836ULL, 0x000fe40000000000ULL, 0x00000008143d7836ULL, 0x000fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee234ULL, 0x0000000c143e7836ULL, 0x000fc40000000000ULL,
0x00000001143c7824ULL, 0x100fe400078e0215ULL, 0x0000000135367824ULL, 0x100fe400078e0215ULL,
0x000000013d347824ULL, 0x100fe400078e0215ULL, 0x000000013e147824ULL, 0x000fe400078e0215ULL,
0x0000000135377824ULL, 0x140fe400078e020eULL, 0x0000000835547824ULL, 0x000fe200078e00ffULL,
0x0000001652517211ULL, 0x002fe200078038ffULL, 0x000000013d157824ULL, 0x000fc400078e020eULL,
0x000000083d587824ULL, 0x000fe200078e00ffULL, 0xfffffff854537812ULL, 0x000fe200078ee237ULL,
0x000000013e357824ULL, 0x000fe200078e020eULL, 0x0000001752557211ULL, 0x000fe200000f3cffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff858597812ULL, 0x000fc600078ee215ULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0x000000423c167212ULL, 0x000fe200078efcffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff83e5b7812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000001651167210ULL, 0x000fe40007f1e0ffULL,
0x0000004236367212ULL, 0x080fe200078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004234347212ULL, 0x000fc600078efcffULL, 0x000000013d177824ULL, 0x100fe200000e0655ULL,
0x0000004214147212ULL, 0x000fe200078efcffULL, 0x000000103f3d7824ULL, 0x100fe200078e0246ULL,
0x0000003651367210ULL, 0x000fe20007f1e0ffULL, 0x00000010533f7824ULL, 0x100fe200078e0246ULL,
0x0000003451347210ULL, 0x000fe20007f5e0ffULL, 0x000000105b537824ULL, 0x100fe200078e0246ULL,
0x0000001451147210ULL, 0x000fe20007f7e0ffULL, 0x0000000137377824ULL, 0x000fe200000e0655ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000163d7faeULL, 0x0003e2000b901c48ULL,
0x0000001059517824ULL, 0x000fc400078e0246ULL, 0x0000000135357824ULL, 0x100fe200010e0655ULL,
0x00000000363f7faeULL, 0x0003e2000b901c48ULL, 0x0000000115157824ULL, 0x000fc600018e0655ULL,
0x0000000034517faeULL, 0x0003e8000b901c48ULL, 0x0000000014537faeULL, 0x0003e4000b901c48ULL,
0x000000083a147824ULL, 0x002fe400078e00ffULL, 0x00000001ff177424ULL, 0x000fc600078e00ffULL,
0xfffffff014147812ULL, 0x000fca00078ec0ffULL, 0x0000000a14547c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000000540572caULL, 0x000fda00000e0000ULL,
0x000176a805057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0176a817545479a7ULL, 0x0002a4000850003fULL,
0x017628174c1679a7ULL, 0x0022e4000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x017628174c0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003414377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017628174c0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000203a147824ULL, 0x000fe400078e00ffULL,
0x0000000aff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000008015147810ULL, 0x000fc80007ffe014ULL,
0x0000001445147210ULL, 0x000fca0007ffe042ULL, 0x0170000014157984ULL, 0x000ee80000000800ULL,
0x0172000014177984ULL, 0x0009220000000800ULL, 0x000000501500720bULL, 0x008fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16367812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x016fea0003800000ULL, 0x0000000107357836ULL, 0x000fe20000000000ULL,
0x000000501500720bULL, 0x000fc80003f14000ULL, 0x0000003a3500720cULL, 0x000fd20003f45270ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x0000000a3a16ac11ULL, 0x000fe4000f8e38ffULL,
0x000000501514a209ULL, 0x000fe40007810000ULL, 0x000000164537a210ULL, 0x000fe40007ffe042ULL,
0x0000991035167816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005015377209ULL, 0x000fe40007810000ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005037147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400167308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff377819ULL, 0x000fca000001160eULL,
0x00001f3716147589ULL, 0x006e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x000000164f4f7220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e377811ULL, 0x000fca00078ff0ffULL,
0x00001f3716147589ULL, 0x002e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff36ff7812ULL, 0x000fe20007806035ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005015507209ULL, 0x000fd60007810000ULL,
0x8000005015150221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL, 0x0000001500020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000004f174f7221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x002fe20000015200ULL, 0x000000083a167824ULL, 0x000fca00078e00ffULL,
0xfffffff016177812ULL, 0x000fc800078ec0ffULL, 0x0176b057170075a7ULL, 0x000ea2000800014aULL,
0x0000000a17377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x0001400048467836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000104d3c7824ULL, 0x000fd800078e0246ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011800004a14783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0x000000104b347824ULL, 0x000fcc00078e0246ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x00000018ff637819ULL, 0x010fe2000001143cULL,
0x000001003c587824ULL, 0x040fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe2000001143dULL,
0x000001003d597824ULL, 0x040fe200078e00ffULL, 0x000088803c667816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d697816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff577819ULL, 0x022fe40000011434ULL,
0x00008880345b7816ULL, 0x000fe200000000ffULL, 0x00000058006b7306ULL, 0x0003e20000202400ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5e7819ULL, 0x000fe4000001143fULL,
0x000088803f657816ULL, 0x000fc400000000ffULL, 0x00000018ff567819ULL, 0x000fe20000011435ULL,
0x0000003c006a7306ULL, 0x0009e20000202400ULL, 0x000001003e587824ULL, 0x042fe200078e00ffULL,
0x00008880355a7816ULL, 0x000fe400000000ffULL, 0x000088803e647816ULL, 0x040fe400000000ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003d006d7306ULL, 0x0003e20000202400ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011436ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x00000100343d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff537819ULL, 0x000fca0000011437ULL, 0x00000059006c7306ULL, 0x000e700000202400ULL,
0x0000005800677306ULL, 0x000ff00000202400ULL, 0x0000003c00687306ULL, 0x0009f00000202400ULL,
0x0000003400587306ULL, 0x000be20000202400ULL, 0x00000100353c7824ULL, 0x010fc400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001143cULL,
0x0000006200627306ULL, 0x000f220000202400ULL, 0x0000010037347824ULL, 0x028fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003f00617306ULL, 0x000ff00000202400ULL,
0x0000003500597306ULL, 0x0003f00000202400ULL, 0x00000034003f7306ULL, 0x0007e20000202400ULL,
0x0000541069357816ULL, 0x002fce000000006cULL, 0x0000006400647306ULL, 0x000e620000202400ULL,
0x0000541066347816ULL, 0x008fce000000006bULL, 0x0000006500657306ULL, 0x000ee20000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x000054106a347816ULL, 0x000fe20000000063ULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x000054106d357816ULL, 0x010fce0000000062ULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x00000034142c723cULL, 0x000fee000004182cULL,
0x0000003e00607306ULL, 0x0009620000202400ULL, 0x0000541064347816ULL, 0x002fe40000000067ULL,
0x0000541065357816ULL, 0x008fca0000000068ULL, 0x0000003d005c7306ULL, 0x0003e20000202400ULL,
0x00008880373e7816ULL, 0x050fe200000000ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x000000341430723cULL, 0x000fe80000041830ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000005b005b7306ULL, 0x000ee20000202400ULL, 0x00000100363d7824ULL, 0x002fe200078e00ffULL,
0x0000541060347816ULL, 0x024fe2000000005fULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x0000541061357816ULL, 0x000fc4000000005eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x000000341428723cULL, 0x000fea0000041828ULL, 0x0000005d005d7306ULL, 0x000e640000202400ULL,
0x000054105b347816ULL, 0x008fcc000000005cULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x000054105a357816ULL, 0x002fce000000005dULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x000000341424723cULL, 0x000fee0000041824ULL, 0x0000005700577306ULL, 0x000ea20000202400ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000005600567306ULL, 0x000e620000202400ULL,
0x0000541058347816ULL, 0x004fce0000000057ULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x0000541059357816ULL, 0x002fce0000000056ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x000000341420723cULL, 0x000fee0000041820ULL, 0x0000003e003e7306ULL, 0x000e700000202400ULL,
0x0000003600367306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000003700627306ULL, 0x000e620000202400ULL, 0x0000003c141c723cULL, 0x000fe2000004181cULL,
0x0000541036367816ULL, 0x004fcc0000000051ULL, 0x00000010493c7824ULL, 0x000fe200078e0246ULL,
0x0000541062377816ULL, 0x002fce0000000053ULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x011800004e14783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000001047347824ULL, 0x000fcc00078e0246ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x00000018ff617819ULL, 0x008fe2000001143cULL, 0x000001003c587824ULL, 0x040fe200078e00ffULL,
0x000088803c577816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe2000001143dULL, 0x000001003d597824ULL, 0x040fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000006100617306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000088803d657816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fc40000011459ULL,
0x00000018ff5d7819ULL, 0x000fe2000001143eULL, 0x0000005800687306ULL, 0x0007e20000202400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5c7819ULL, 0x000fe4000001143fULL,
0x000088803e627816ULL, 0x040fe400000000ffULL, 0x000088803f647816ULL, 0x000fe200000000ffULL,
0x0000003c00667306ULL, 0x000be20000202400ULL, 0x000001003e587824ULL, 0x048fe200078e00ffULL,
0x00000018ff567819ULL, 0x010fe20000011434ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011435ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000005700577306ULL, 0x000ee20000202400ULL, 0x000001003f3c7824ULL, 0x062fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00008880376b7816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x00000018ff3f7819ULL, 0x000fc4000001143fULL,
0x00000018ff4e7819ULL, 0x000fe40000011436ULL, 0x00000018ff517819ULL, 0x000fc60000011437ULL,
0x00000059006a7306ULL, 0x0003300000202400ULL, 0x0000003d00677306ULL, 0x000be20000202400ULL,
0x0000888034597816ULL, 0x002fce00000000ffULL, 0x0000005800637306ULL, 0x0003e20000202400ULL,
0x00000100343d7824ULL, 0x064fe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00697306ULL, 0x0005e20000202400ULL,
0x0000888035587816ULL, 0x002fe400000000ffULL, 0x00000018ff347819ULL, 0x000fca0000011434ULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x00000100353c7824ULL, 0x044fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001143cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003e005e7306ULL, 0x000fe20000202400ULL,
0x00008880363c7816ULL, 0x000fce00000000ffULL, 0x0000003f005f7306ULL, 0x000ff00000202400ULL,
0x00000034003f7306ULL, 0x0007f00000202400ULL, 0x00000035003e7306ULL, 0x0009e20000202400ULL,
0x0000541057347816ULL, 0x008fe20000000068ULL, 0x000000ffff577224ULL, 0x000fcc00078e006bULL,
0x0000006200627306ULL, 0x000ea20000202400ULL, 0x0000541065357816ULL, 0x010fe2000000006aULL,
0x0000010037657824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000006400647306ULL, 0x000ee20000202400ULL, 0x000000341418723cULL, 0x000fee0000041818ULL,
0x0000541066347816ULL, 0x000fe20000000061ULL, 0x0000005d005d7306ULL, 0x000f220000202400ULL,
0x0000541067357816ULL, 0x002fe20000000060ULL, 0x0001000037617824ULL, 0x000fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000005c005c7306ULL, 0x000e620000202400ULL,
0x00000034142c723cULL, 0x000fee000004182cULL, 0x0001000036357824ULL, 0x000fe200078e00ffULL,
0x0000541062347816ULL, 0x004fe20000000063ULL, 0x0000005900597306ULL, 0x000fe60000202400ULL,
0x00000018ff607819ULL, 0x000fc40000011435ULL, 0x0000541064357816ULL, 0x008fc60000000069ULL,
0x0000003d005a7306ULL, 0x0004e80000202400ULL, 0x000000341430723cULL, 0x000fe80000041830ULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x00000100363d7824ULL, 0x004fe400078e00ffULL,
0x000054105e347816ULL, 0x010fc4000000005dULL, 0x000054105f357816ULL, 0x002fe4000000005cULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000005b005b7306ULL, 0x000e680000202400ULL,
0x000000341428723cULL, 0x000fe80000041828ULL, 0x0000005600567306ULL, 0x000ea60000202400ULL,
0x0000541059347816ULL, 0x008fc4000000005aULL, 0x0000541058357816ULL, 0x002fc6000000005bULL,
0x0000005300537306ULL, 0x000e680000202400ULL, 0x000000341424723cULL, 0x000fe80000041824ULL,
0x0000003c003c7306ULL, 0x000fe60000202400ULL, 0x000054103f347816ULL, 0x004fe20000000056ULL,
0x00000001ff3f7424ULL, 0x000fe200078e00ffULL, 0x000054103e357816ULL, 0x002fc60000000053ULL,
0x0000003d003d7306ULL, 0x000e680000202400ULL, 0x000000341420723cULL, 0x000fe80000041820ULL,
0x0000005700577306ULL, 0x000fe60000202400ULL, 0x000000023a357824ULL, 0x000fe200078e00ffULL,
0x0000000a0b347c11ULL, 0x000fc8000f8e18ffULL, 0x0000006500367306ULL, 0x000ea20000202400ULL,
0x000054103c3c7816ULL, 0x002fe4000000003dULL, 0xfffffff8353e7812ULL, 0x000fe400078ec0ffULL,
0x0176c83f343479a7ULL, 0x000e66000850003fULL, 0x0000004e004e7306ULL, 0x000fe20000202400ULL,
0x0176903f3eff79a7ULL, 0x0007e2000850000aULL, 0x00005410573d7816ULL, 0x004fcc0000000036ULL,
0x0000006000377306ULL, 0x000ea20000202400ULL, 0x0000003c141c723cULL, 0x000fee000004181cULL,
0x0000005100517306ULL, 0x000fe20000202400ULL, 0x0000541037367816ULL, 0x004fce000000004eULL,
0x0000006100587306ULL, 0x000ea40000202400ULL, 0x0000541058377816ULL, 0x004fce0000000051ULL,
0x000000361410723cULL, 0x000fee0000041810ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x00000035440075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x00afdc0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035440075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000010004517824ULL, 0x000fc800078e0209ULL,
0x000000c051177836ULL, 0x000fca0000000000ULL, 0x0000006017157812ULL, 0x000fca00078ec0ffULL,
0x000000010a3c7824ULL, 0x000fe200078e0215ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x0000001738147248ULL, 0x000fe20007fe0000ULL, 0x000000103a157824ULL, 0x000fe200078e00ffULL,
0x00000003ff347819ULL, 0x000fc6000001160eULL, 0x0000000114147824ULL, 0x000fe200078e0a17ULL,
0x0000001015177812ULL, 0x000fe200078ec0ffULL, 0x0000000434367836ULL, 0x000fe40000000000ULL,
0x0000000834377836ULL, 0x000fe20000000000ULL, 0x0000001417167248ULL, 0x000fe20007fe0000ULL,
0x0000000c343e7836ULL, 0x000fe20000000000ULL, 0x00008e00ff147b82ULL, 0x000e620000000a00ULL,
0x0000000134357824ULL, 0x100fe400078e0217ULL, 0x0000000116167824ULL, 0x000fc400078e0a17ULL,
0x00000001363d7824ULL, 0x100fe400078e0217ULL, 0x0000000137577824ULL, 0x100fe200078e0217ULL,
0x000000163400720cULL, 0x080fe20003f86070ULL, 0x00000008353f7824ULL, 0x040fe200078e00ffULL,
0x000000163600720cULL, 0x080fe20003f66070ULL, 0x0000000135367824ULL, 0x000fe200078e023cULL,
0x000000163700720cULL, 0x080fe20003f46070ULL, 0x000000013e5d7824ULL, 0x040fe200078e0217ULL,
0x000000163e00720cULL, 0x000fe20003f06070ULL, 0x0000000135167824ULL, 0x000fc400078e020eULL,
0x000000013d177824ULL, 0x140fe400078e020eULL, 0x000000083d3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL, 0x0000000157347824ULL, 0x040fe400078e020eULL,
0x00000008575b7824ULL, 0x000fe200078e00ffULL, 0x0000001452537211ULL, 0x002fe200078a38ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0xfffffff83e597812ULL, 0x000fe400078ee217ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee234ULL, 0x000000013d167824ULL, 0x100fe200078e023cULL,
0x0000004236147212ULL, 0x000fe200078efcffULL, 0x0000000157347824ULL, 0x000fe200078e023cULL,
0x0000001552577211ULL, 0x000fe200028f3cffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000005314147210ULL, 0x000fc60007fbe0ffULL, 0x000000015d3c7824ULL, 0x000fe200078e023cULL,
0x0000004216167212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004234347212ULL, 0x000fc600078efcffULL,
0x0000000137157824ULL, 0x100fe200028e0657ULL, 0x0000005316167210ULL, 0x000fe20007fbe0ffULL,
0x000000015d377824ULL, 0x040fe200078e020eULL, 0x000000423c367212ULL, 0x000fe200078efcffULL,
0x000000085d3c7824ULL, 0x000fe400078e00ffULL, 0x0000000117177824ULL, 0x100fe200028e0657ULL,
0x0000005334347210ULL, 0x000fe20007fbe0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0246ULL,
0x0000005336367210ULL, 0x000fe20007fde0ffULL, 0x0000001059597824ULL, 0x100fe200078e0246ULL,
0xfffffff83c537812ULL, 0x000fe200078ee237ULL, 0x0000000135357824ULL, 0x000fe200028e0657ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143f7faeULL, 0x0003e2000e101c48ULL,
0x000000105b5b7824ULL, 0x000fc400078e0246ULL, 0x000000013d377824ULL, 0x000fe200030e0657ULL,
0x0000000016597faeULL, 0x0003e2000d901c48ULL, 0x0000001053537824ULL, 0x000fc600078e0246ULL,
0x00000000345b7faeULL, 0x0003e8000d101c48ULL, 0x0000000036537faeULL, 0x0003e2000c101c48ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x000000103a147824ULL, 0x000fca00078e00ffULL,
0x0000001014157812ULL, 0x000fc800078ec0ffULL, 0x000000150e177211ULL, 0x000fe400078fe8ffULL,
0x00008e00ff147b82ULL, 0x000e660000000a00ULL, 0x0000000117167824ULL, 0x040fe400078e020eULL,
0x00000008173f7824ULL, 0x040fe400078e00ffULL, 0x0000000417357836ULL, 0x000fe40000000000ULL,
0x0000000817377836ULL, 0x000fe20000000000ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL,
0x0000000117167824ULL, 0x000fc400078e023cULL, 0x0000000c173d7836ULL, 0x000fe40000000000ULL,
0x0000000135177824ULL, 0x040fe400078e020eULL, 0x00000008353e7824ULL, 0x040fe400078e00ffULL,
0x0000000135347824ULL, 0x100fe400078e023cULL, 0x0000000137367824ULL, 0x040fe200078e023cULL,
0xfffffff83e597812ULL, 0x000fe200078ee217ULL, 0x0000000137357824ULL, 0x040fe200078e020eULL,
0x0000001452537211ULL, 0x002fe200078038ffULL, 0x00000008374e7824ULL, 0x000fc400078e00ffULL,
0x000000013d377824ULL, 0x040fe200078e020eULL, 0x0000001552577211ULL, 0x000fe200000f3cffULL,
0x000000083d567824ULL, 0x000fe200078e00ffULL, 0xfffffff84e5b7812ULL, 0x000fe200078ee235ULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff8565d7812ULL, 0x000fe200078ee237ULL,
0x000000013d3c7824ULL, 0x000fe200078e023cULL, 0x0000004216147212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0x0000005314147210ULL, 0x000fe20007f1e0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004234167212ULL, 0x000fc600078efcffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004236347212ULL, 0x080fe400078efcffULL,
0x0000005316167210ULL, 0x000fe20007f5e0ffULL, 0x0000000117157824ULL, 0x100fe200000e0657ULL,
0x000000423c367212ULL, 0x000fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e0246ULL,
0x0000005334347210ULL, 0x000fe20007f1e0ffULL, 0x0000000135177824ULL, 0x100fe200010e0657ULL,
0x0000005336367210ULL, 0x000fe20007f7e0ffULL, 0x0000001059597824ULL, 0x000fe200078e0246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143f7faeULL, 0x0003e2000b901c48ULL,
0x0000000137357824ULL, 0x000fc400000e0657ULL, 0x000000105b5b7824ULL, 0x100fe200078e0246ULL,
0x0000000016597faeULL, 0x0003e2000b901c48ULL, 0x000000013d377824ULL, 0x000fe400018e0657ULL,
0x000000105d5d7824ULL, 0x000fe200078e0246ULL, 0x00000000345b7faeULL, 0x0003e8000b901c48ULL,
0x00000000365d7faeULL, 0x0003e4000b901c48ULL, 0x000000020c0c7836ULL, 0x000fe20000000000ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0xffffffffff4e7424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x000000390c00720cULL, 0x000fca0003f06070ULL,
0x00000000ff0079b0ULL, 0x000ff00008000a45ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x000000010c178824ULL, 0x000fe400078e0205ULL, 0x000000083a167824ULL, 0x000fc400078e00ffULL,
0x0000000417148825ULL, 0x002fca00078e0014ULL, 0x00000008144e8981ULL, 0x000322000c1e1900ULL,
0x0000000aff177e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff016167812ULL, 0x000fc800078ec0ffULL,
0x000176a816527810ULL, 0x000fe20007ffe017ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000817525279a7ULL, 0x0004e4000850003fULL,
0x017648174c1679a7ULL, 0x004464000850003fULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x017648174c0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003414377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017648174c0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000203a147824ULL, 0x000fe400078e00ffULL,
0x0000000aff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000010015147810ULL, 0x000fc80007ffe014ULL,
0x0000001445147210ULL, 0x000fca0007ffe042ULL, 0x0170000014157984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x000b620000000800ULL, 0x000000501500720bULL, 0x002fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16367812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x02cfea0003800000ULL, 0x0000000207357836ULL, 0x000fe20000000000ULL,
0x000000501500720bULL, 0x000fc80003f14000ULL, 0x0000003a3500720cULL, 0x000fd20003f45270ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x0000000a3a16ac11ULL, 0x000fe4000f8e38ffULL,
0x000000501514a209ULL, 0x000fe40007810000ULL, 0x000000164537a210ULL, 0x000fe40007ffe042ULL,
0x0000991035167816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005015377209ULL, 0x000fe40007810000ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005037147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400167308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff377819ULL, 0x000fca000001160eULL,
0x00001f3716147589ULL, 0x006e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x000000164f4f7220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e377811ULL, 0x000fca00078ff0ffULL,
0x00001f3716147589ULL, 0x002e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff36ff7812ULL, 0x000fe20007806035ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005015507209ULL, 0x000fd60007810000ULL,
0x8000005015150221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL, 0x0000001500020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000004f174f7221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x000000083a167824ULL, 0x000fca00078e00ffULL,
0xfffffff016177812ULL, 0x000fc800078ec0ffULL, 0x0176a855170075a7ULL, 0x000e62000800014aULL,
0x0000000a17377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176a855370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x0001300048487836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000104d3c7824ULL, 0x000fd800078e0248ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x012000004a14783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000104b347824ULL, 0x000fcc00078e0248ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x00000018ff5c7819ULL, 0x022fe2000001143cULL,
0x000001003c547824ULL, 0x040fe200078e00ffULL, 0x000088803c587816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001143dULL,
0x000001003d557824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x000088803d637816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff5a7819ULL, 0x000fe2000001143eULL,
0x0000005400657306ULL, 0x0003e20000202400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff597819ULL, 0x000fe4000001143fULL, 0x000088803e5d7816ULL, 0x000fc400000000ffULL,
0x000088803f5e7816ULL, 0x040fe200000000ffULL, 0x0000003c00617306ULL, 0x000be20000202400ULL,
0x000001003e547824ULL, 0x042fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x008fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011435ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005800587306ULL, 0x000e620000202400ULL,
0x000001003f3c7824ULL, 0x064fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fc40000011436ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff4c7819ULL, 0x000fe40000011437ULL,
0x0000888037687816ULL, 0x000fc600000000ffULL, 0x0000005500667306ULL, 0x0004f00000202400ULL,
0x0000003d00647306ULL, 0x000be20000202400ULL, 0x0000888034557816ULL, 0x004fce00000000ffULL,
0x0000005400607306ULL, 0x0005e20000202400ULL, 0x00000100343d7824ULL, 0x060fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00677306ULL, 0x000be20000202400ULL, 0x0000888035547816ULL, 0x004fe400000000ffULL,
0x00000018ff347819ULL, 0x000fca0000011434ULL, 0x0000003e005f7306ULL, 0x000fe20000202400ULL,
0x00000100353c7824ULL, 0x060fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003f00627306ULL, 0x000fe20000202400ULL, 0x00008880363c7816ULL, 0x000fce00000000ffULL,
0x0000005b005b7306ULL, 0x000eb00000202400ULL, 0x00000034003f7306ULL, 0x0003f00000202400ULL,
0x00000035003e7306ULL, 0x0007e20000202400ULL, 0x0000541058347816ULL, 0x002fe20000000065ULL,
0x000000ffff587224ULL, 0x000fcc00078e0068ULL, 0x0000005d005d7306ULL, 0x000e620000202400ULL,
0x0000541063357816ULL, 0x008fce0000000066ULL, 0x0000005e005e7306ULL, 0x000ee20000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x0000010037357824ULL, 0x000fe200078e00ffULL,
0x0000541061347816ULL, 0x000fe2000000005cULL, 0x0000005a005a7306ULL, 0x000f620000202400ULL,
0x0001000037377824ULL, 0x000fc400078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011435ULL,
0x0000541064357816ULL, 0x004fe4000000005bULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000005900597306ULL, 0x000ea80000202400ULL, 0x00000034142c723cULL, 0x000fe8000004182cULL,
0x0000005500557306ULL, 0x000fe60000202400ULL, 0x000054105d347816ULL, 0x002fc40000000060ULL,
0x000054105e357816ULL, 0x008fc60000000067ULL, 0x0000003d00567306ULL, 0x0002e80000202400ULL,
0x000000341430723cULL, 0x000fe80000041830ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00000100363d7824ULL, 0x042fe400078e00ffULL, 0x000054105f347816ULL, 0x020fe2000000005aULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000541062357816ULL, 0x004fc40000000059ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000005700577306ULL, 0x000e620000202400ULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x000000341428723cULL, 0x000fe80000041828ULL,
0x0000004a004a7306ULL, 0x000ea60000202400ULL, 0x0000541055347816ULL, 0x008fe40000000056ULL,
0x000000070e557812ULL, 0x000fe400078ec0ffULL, 0x0000541054357816ULL, 0x002fe20000000057ULL,
0x0000004d004d7306ULL, 0x000e620000202400ULL, 0x0000000855557812ULL, 0x000fca00078ef80eULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x0000000855557824ULL, 0x000fe200078e00ffULL,
0x0000003c003c7306ULL, 0x000fea0000202400ULL, 0x000002003a357824ULL, 0x000fe200078e00ffULL,
0x000054103f347816ULL, 0x004fe2000000004aULL, 0x00000002434a7836ULL, 0x000fe20000000000ULL,
0x0000003d003d7306ULL, 0x000ea40000202400ULL, 0xfffff800353f7812ULL, 0x000fc400078ec0ffULL,
0x000054103e357816ULL, 0x002fe4000000004dULL, 0xfffffff8554a7812ULL, 0x000fe200078ee24aULL,
0x0000000a3f3f7c36ULL, 0x000fe20008000000ULL, 0x0000004b004b7306ULL, 0x000fe60000202400ULL,
0x000000341420723cULL, 0x000fe20000041820ULL, 0x000054103c3c7816ULL, 0x004fc8000000003dULL,
0x0000004c004c7306ULL, 0x000fe40000202400ULL, 0x000000104a347824ULL, 0x000fcc00078e023fULL,
0x0000005800587306ULL, 0x000ff00000202400ULL, 0x0000005c005b7306ULL, 0x000e700000202400ULL,
0x0000003600367306ULL, 0x000ea20000202400ULL, 0x00005410583d7816ULL, 0x002fce000000005bULL,
0x0000003700377306ULL, 0x000e620000202400ULL, 0x0000003c141c723cULL, 0x000fe2000004181cULL,
0x0000541036367816ULL, 0x004fcc000000004bULL, 0x00000010493c7824ULL, 0x000fe200078e0248ULL,
0x0000541037377816ULL, 0x002fce000000004cULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x012000003414783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000001047347824ULL, 0x002fcc00078e0248ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x00000018ff5a7819ULL, 0x008fe2000001143cULL, 0x000001003c4d7824ULL, 0x040fe200078e00ffULL,
0x000088803c597816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001143dULL, 0x000001003d547824ULL, 0x040fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000088803d627816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff587819ULL, 0x000fe2000001143eULL, 0x0000004d00607306ULL, 0x0007e20000202400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff577819ULL, 0x000fe4000001143fULL,
0x000088803e5c7816ULL, 0x040fe400000000ffULL, 0x000088803f5d7816ULL, 0x000fe200000000ffULL,
0x0000003c00637306ULL, 0x000be20000202400ULL, 0x000001003e4d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x002fe20000011434ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc40000011435ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000005900597306ULL, 0x000e620000202400ULL, 0x000001003f3c7824ULL, 0x064fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000888037677816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006200627306ULL, 0x000fe20000202400ULL, 0x00000018ff3f7819ULL, 0x000fc4000001143fULL,
0x00000018ff497819ULL, 0x000fe40000011437ULL, 0x00000018ff477819ULL, 0x000fc60000011436ULL,
0x0000005400657306ULL, 0x0004f00000202400ULL, 0x0000003d00647306ULL, 0x000be20000202400ULL,
0x0000888034547816ULL, 0x004fce00000000ffULL, 0x0000004d005f7306ULL, 0x0005e20000202400ULL,
0x00000100343d7824ULL, 0x060fe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00667306ULL, 0x000be20000202400ULL,
0x00008880354d7816ULL, 0x004fe400000000ffULL, 0x00000018ff347819ULL, 0x000fca0000011434ULL,
0x0000005b005b7306ULL, 0x000ea20000202400ULL, 0x00000100353c7824ULL, 0x060fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe4000001143cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003e00617306ULL, 0x000fe20000202400ULL,
0x00008880363c7816ULL, 0x000fce00000000ffULL, 0x0000003f005e7306ULL, 0x000ff00000202400ULL,
0x00000034003e7306ULL, 0x0003f00000202400ULL, 0x00000035003f7306ULL, 0x0007e20000202400ULL,
0x0000541059347816ULL, 0x002fe20000000060ULL, 0x0000010037607824ULL, 0x000fc400078e00ffULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x000000ffff597224ULL, 0x000fe200078e0067ULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000005c005c7306ULL, 0x000e620000202400ULL,
0x0000541062357816ULL, 0x008fce0000000065ULL, 0x0000005d005d7306ULL, 0x000ee20000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x0000541063347816ULL, 0x000fe2000000005aULL,
0x0000005800587306ULL, 0x000f620000202400ULL, 0x0000541064357816ULL, 0x004fce000000005bULL,
0x0000005700577306ULL, 0x000ea20000202400ULL, 0x00000034142c723cULL, 0x000fee000004182cULL,
0x0001000036357824ULL, 0x000fe200078e00ffULL, 0x000054105c347816ULL, 0x002fe2000000005fULL,
0x0000005400547306ULL, 0x000fe60000202400ULL, 0x00000018ff5a7819ULL, 0x000fc40000011435ULL,
0x000054105d357816ULL, 0x008fc60000000066ULL, 0x0000003d00557306ULL, 0x0002e80000202400ULL,
0x000000341430723cULL, 0x000fe80000041830ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x00000100363d7824ULL, 0x002fe400078e00ffULL, 0x0000541061347816ULL, 0x020fc40000000058ULL,
0x000054105e357816ULL, 0x004fe40000000057ULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000005600567306ULL, 0x000e620000202400ULL, 0x00000018ff577819ULL, 0x000fe40000011437ULL,
0x0000000a07377c11ULL, 0x000fe2000f8e18ffULL, 0x000000341428723cULL, 0x000fe80000041828ULL,
0x0000004b004b7306ULL, 0x000ea60000202400ULL, 0x0000541054347816ULL, 0x008fc40000000055ULL,
0x000054104d357816ULL, 0x002fc60000000056ULL, 0x0000004c004c7306ULL, 0x000e680000202400ULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x000054103e3e7816ULL, 0x004fc6000000004bULL,
0x0000003c003c7306ULL, 0x000fe60000202400ULL, 0x0000000a0b347c11ULL, 0x000fe4000f8e18ffULL,
0x000054103f3f7816ULL, 0x002fc6000000004cULL, 0x0000003d003d7306ULL, 0x000e680000202400ULL,
0x0000003e1420723cULL, 0x000fe80000041820ULL, 0x0000004700477306ULL, 0x000fe60000202400ULL,
0x00000001ff3e7424ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x002fc8000000003dULL,
0x0000004900497306ULL, 0x000fe20000202400ULL, 0x0176c83e343479a7ULL, 0x00026e000850003fULL,
0x0000005900597306ULL, 0x000fe20000202400ULL, 0x0176983e37ff79a7ULL, 0x0003ee000850003fULL,
0x0000006000367306ULL, 0x000eb00000202400ULL, 0x0000005a005a7306ULL, 0x000ee20000202400ULL,
0x00005410593d7816ULL, 0x004fce0000000036ULL, 0x0000005700547306ULL, 0x000ea20000202400ULL,
0x0000003c141c723cULL, 0x000fe2000004181cULL, 0x000054105a5a7816ULL, 0x008fe40000000047ULL,
0x00005410545b7816ULL, 0x004fce0000000049ULL, 0x0000005a1410723cULL, 0x002fde0000041810ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035440075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035440075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000104147836ULL, 0x000fca0000000000ULL,
0x0000000d1400720cULL, 0x000fda0003f06070ULL, 0x0000000400f80947ULL, 0x000fea0003800000ULL,
0x0000000204147836ULL, 0x000fe20000000000ULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x0000010051517836ULL, 0x000fe40000000000ULL, 0x000000054e3e7c24ULL, 0x010fe2000f8e02ffULL,
0x0000000d1400720cULL, 0x000fe40003f06070ULL, 0x0000006051157812ULL, 0x000fe200078ec0ffULL,
0x000000803e3e7824ULL, 0x000fc800078e00ffULL, 0x000000010a177824ULL, 0x000fcc00078e0215ULL,
0x0000000400048947ULL, 0x000fea0003800000ULL, 0x0000005138147248ULL, 0x000fe20007fe0000ULL,
0x000000103a157824ULL, 0x000fe200078e00ffULL, 0x00000003ff347819ULL, 0x000fc6000001160eULL,
0x0000000114147824ULL, 0x000fe200078e0a51ULL, 0x0000001015357812ULL, 0x000fe200078ec0ffULL,
0x0000000434367836ULL, 0x000fe40000000000ULL, 0x00000008343c7836ULL, 0x000fe20000000000ULL,
0x0000001435167248ULL, 0x000fe20007fe0000ULL, 0x0000000c343f7836ULL, 0x000fe20000000000ULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x0000000136377824ULL, 0x100fe400078e0235ULL,
0x0000000116167824ULL, 0x000fc400078e0a35ULL, 0x000000013c3d7824ULL, 0x100fe400078e0235ULL,
0x00000008374b7824ULL, 0x000fe200078e00ffULL, 0x000000163400720cULL, 0x0c0fe20003f86070ULL,
0x0000000134347824ULL, 0x100fe200078e0235ULL, 0x000000163600720cULL, 0x080fe20003f66070ULL,
0x000000013f447824ULL, 0x040fe200078e0235ULL, 0x000000163c00720cULL, 0x080fe20003f46070ULL,
0x0000000134367824ULL, 0x040fe200078e020eULL, 0x000000163f00720cULL, 0x000fe20003f06070ULL,
0x0000000834497824ULL, 0x000fc400078e00ffULL, 0x00000001373c7824ULL, 0x100fe400078e020eULL,
0x000000013d357824ULL, 0x040fe200078e020eULL, 0xfffffff849497812ULL, 0x000fe200078ee236ULL,
0x000000083d4c7824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee23cULL,
0x0000000134167824ULL, 0x100fe200078e0217ULL, 0x000000143e3f7211ULL, 0x042fe200078a38ffULL,
0x0000000137347824ULL, 0x100fe200078e0217ULL, 0xfffffff84c4d7812ULL, 0x000fe200078ee235ULL,
0x000000013d367824ULL, 0x100fe200078e0217ULL, 0x000000153e477211ULL, 0x000fe200028f3cffULL,
0x00000001443c7824ULL, 0x000fc400078e0217ULL, 0x0000000144377824ULL, 0x040fe400078e020eULL,
0x0000000844447824ULL, 0x000fe400078e00ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff844517812ULL, 0x000fe200078ee237ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004216147212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004234167212ULL, 0x080fe400078efcffULL, 0x000000143f147210ULL, 0x000fe20007fbe0ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000003f16167210ULL, 0x000fe40007fde0ffULL,
0x0000004236347212ULL, 0x080fe200078efcffULL, 0x0000000117157824ULL, 0x100fe200028e0647ULL,
0x000000423c367212ULL, 0x000fe200078efcffULL, 0x0000000135177824ULL, 0x000fe200030e0647ULL,
0x0000003f34347210ULL, 0x000fe20007fbe0ffULL, 0x0000001049497824ULL, 0x100fe200078e0248ULL,
0x0000003f36367210ULL, 0x000fe20007fde0ffULL, 0x000000104b4b7824ULL, 0x000fc400078e0248ULL,
0x000000104d4d7824ULL, 0x100fe200078e0248ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014497faeULL, 0x0003e2000e101c48ULL, 0x0000000137357824ULL, 0x100fe400028e0647ULL,
0x0000001051517824ULL, 0x000fe200078e0248ULL, 0x00000000164b7faeULL, 0x0003e2000d901c48ULL,
0x000000013d377824ULL, 0x000fc600030e0647ULL, 0x00000000344d7faeULL, 0x0003e8000d101c48ULL,
0x0000000036517faeULL, 0x0003e2000c101c48ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x000000103a147824ULL, 0x000fca00078e00ffULL, 0x0000001014157812ULL, 0x000fc800078ec0ffULL,
0x000000150e167211ULL, 0x000fe400078fe8ffULL, 0x00008e00ff147b82ULL, 0x000e660000000a00ULL,
0x0000000116347824ULL, 0x040fe400078e020eULL, 0x00000008163f7824ULL, 0x000fe400078e00ffULL,
0x0000000416357836ULL, 0x000fe40000000000ULL, 0x00000008163d7836ULL, 0x000fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee234ULL, 0x0000000c16447836ULL, 0x000fc40000000000ULL,
0x0000000116347824ULL, 0x100fe400078e0217ULL, 0x0000000135167824ULL, 0x100fe400078e0217ULL,
0x000000013d3c7824ULL, 0x100fe400078e0217ULL, 0x0000000144367824ULL, 0x000fe400078e0217ULL,
0x0000000135377824ULL, 0x140fe400078e020eULL, 0x00000008354c7824ULL, 0x000fe200078e00ffULL,
0x000000143e477211ULL, 0x002fe200078038ffULL, 0x000000013d177824ULL, 0x000fc400078e020eULL,
0x000000083d547824ULL, 0x000fe200078e00ffULL, 0xfffffff84c4b7812ULL, 0x000fe200078ee237ULL,
0x00000001443d7824ULL, 0x000fe200078e020eULL, 0x000000153e497211ULL, 0x000fe200000f3cffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff8544d7812ULL, 0x000fc600078ee217ULL,
0x0000000844447824ULL, 0x000fe200078e00ffULL, 0x0000004234147212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff844517812ULL, 0x000fe200078ee23dULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000001447147210ULL, 0x000fe40007f1e0ffULL,
0x0000004216167212ULL, 0x080fe200078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000423c347212ULL, 0x000fc600078efcffULL, 0x0000000135157824ULL, 0x100fe200000e0649ULL,
0x0000004236367212ULL, 0x000fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e0248ULL,
0x0000001647167210ULL, 0x000fe20007f1e0ffULL, 0x000000104b4b7824ULL, 0x100fe200078e0248ULL,
0x0000003447347210ULL, 0x000fe20007f5e0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e0248ULL,
0x0000003647367210ULL, 0x000fe20007f7e0ffULL, 0x0000000117177824ULL, 0x100fe200000e0649ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143f7faeULL, 0x0003e2000b901c48ULL,
0x000000013d357824ULL, 0x000fc400010e0649ULL, 0x0000001051517824ULL, 0x000fe200078e0248ULL,
0x00000000164b7faeULL, 0x0003e2000b901c48ULL, 0x0000000137377824ULL, 0x000fc600018e0649ULL,
0x00000000344d7faeULL, 0x0003e8000b901c48ULL, 0x0000000036517faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000a0b147c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0176a835141479a7ULL, 0x0002a4000850003fULL,
0x01766835063479a7ULL, 0x0022e4000850003fULL, 0x000000ffff477224ULL, 0x006fce00078e0015ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x01766835060075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01766835060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000a07157c11ULL, 0x000fe2000f8e38ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0x0000018042147810ULL, 0x000fca0007ffe015ULL, 0x0000000145147824ULL, 0x000fca00078e0214ULL,
0x0170000014157984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000501500720bULL, 0x002fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff16367812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x004fea0003800000ULL,
0x0000000307357836ULL, 0x000fe20000000000ULL, 0x000000501500720bULL, 0x000fc80003f14000ULL,
0x0000003a3500720cULL, 0x000fd20003f45270ULL, 0x0000000000357806ULL, 0x000fc800000e0100ULL,
0x0000000a3a16ac11ULL, 0x000fe4000f8e38ffULL, 0x000000501514a209ULL, 0x000fe40007810000ULL,
0x000000164545a210ULL, 0x000fe40007ffe042ULL, 0x0000991035167816ULL, 0x000fc600000000ffULL,
0x017400144500a388ULL, 0x0003e20000000800ULL, 0x000000ff1600720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005015377209ULL, 0x000fe40007810000ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005037147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400167308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x000fca000001160eULL, 0x00001f3716147589ULL, 0x006e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x000000164f4f7220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e377811ULL, 0x000fca00078ff0ffULL, 0x00001f3716147589ULL, 0x002e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff36ff7812ULL, 0x000fe20007806035ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005015507209ULL, 0x000fd60007810000ULL, 0x8000005015150221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL,
0x0000001500020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000004f174f7221ULL, 0x000fe20000010000ULL, 0x0000000a0b3d7c11ULL, 0x000fce000f8e20ffULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x0176b0533d0075a7ULL, 0x000e62000800017fULL,
0x000000043a167824ULL, 0x000fe400078e00ffULL, 0x0000000408357824ULL, 0x000fc600078e00ffULL,
0x0000000416167812ULL, 0x000fca00078ec0ffULL, 0x0000000216367836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3c7224ULL, 0x000fce00078e00ffULL,
0x000000103c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013c3c7836ULL, 0x000fce0000000000ULL,
0x0176b0533d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000070e457812ULL, 0x040fe200078ec0ffULL, 0x00000003075b7836ULL, 0x000fe20000000000ULL,
0x000000080e447812ULL, 0x000fe400078ec0ffULL, 0x0000991034157816ULL, 0x000fe400000000ffULL,
0x000000350e487211ULL, 0x000fe400078fe0ffULL, 0x0000000845147812ULL, 0x000fe400078ef80eULL,
0x0000004544357212ULL, 0x000fc400078efcffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x0000000a5b5b7c11ULL, 0x000fe2000f8e58ffULL,
0x0000000135147824ULL, 0x040fe400078e0248ULL, 0x0000000835177824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fc800078ee243ULL, 0xfffffff817157812ULL, 0x000fe200078ee214ULL,
0x0000001016147824ULL, 0x000fc800078e025bULL, 0x00000010153c7824ULL, 0x000fe200078e0246ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff167819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000816347836ULL, 0x000fe20000000000ULL,
0x0000541000157816ULL, 0x000fca0000000000ULL, 0x00001f1615037589ULL, 0x0002a800000e0000ULL,
0x00001f3415007589ULL, 0x0002e400000e0000ULL, 0x011000001414783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x088fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000360e427211ULL, 0x000fe200078fe0ffULL,
0x000000003c3c783bULL, 0x000f680000004200ULL, 0x0000000135347824ULL, 0x040fe400078e0242ULL,
0x0000000835357824ULL, 0x000fca00078e00ffULL, 0xfffffff835357812ULL, 0x000fca00078ee234ULL,
0x0000001035357824ULL, 0x000fcc00078e0246ULL, 0x000000003534783bULL, 0x000f640000004200ULL,
0x00000018ff567819ULL, 0x028fe2000001143cULL, 0x000001003c4d7824ULL, 0x040fe200078e00ffULL,
0x000088803c5e7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001143dULL, 0x000001003d517824ULL, 0x040fe200078e00ffULL,
0x000088803d617816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff627819ULL, 0x000fe4000001143dULL,
0x00000018ff597819ULL, 0x000fe4000001143eULL, 0x000088803e3d7816ULL, 0x000fe200000000ffULL,
0x0000004d00637306ULL, 0x0007e20000202400ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff577819ULL, 0x000fe4000001143fULL, 0x00000018ff4b7819ULL, 0x004fc40000011434ULL,
0x0000888034557816ULL, 0x000fe200000000ffULL, 0x0000003c00657306ULL, 0x0005e20000202400ULL,
0x000001003e4d7824ULL, 0x048fe200078e00ffULL, 0x000088803f5f7816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011435ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000006100617306ULL, 0x000fe20000202400ULL,
0x000001003f3c7824ULL, 0x004fe200078e00ffULL, 0x0000888035537816ULL, 0x000fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011436ULL,
0x00000018ff647819ULL, 0x000fe4000001143cULL, 0x00000018ff3c7819ULL, 0x000fe2000001143eULL,
0x00000100343e7824ULL, 0x040fe200078e00ffULL, 0x0000005100667306ULL, 0x000ea20000202400ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x0000004d00607306ULL, 0x0007e20000202400ULL, 0x00000018ff497819ULL, 0x000fce0000011437ULL,
0x0000003400547306ULL, 0x000be20000202400ULL, 0x00000100354d7824ULL, 0x048fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000005600567306ULL, 0x000ee20000202400ULL, 0x0000010037347824ULL, 0x022fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fc80000011435ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000005d005d7306ULL, 0x000ff00000202400ULL, 0x0000006200627306ULL, 0x000e700000202400ULL,
0x0000003f005c7306ULL, 0x000bf00000202400ULL, 0x0000003e00587306ULL, 0x0003e20000202400ULL,
0x00000100363f7824ULL, 0x020fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000004d005a7306ULL, 0x000be20000202400ULL, 0x00008880363e7816ULL, 0x042fe200000000ffULL,
0x0001000036367824ULL, 0x000fcc00078e00ffULL, 0x0000003500517306ULL, 0x0005e20000202400ULL,
0x00008880374d7816ULL, 0x060fe200000000ffULL, 0x0001000037377824ULL, 0x000fcc00078e00ffULL,
0x0000003400527306ULL, 0x0003e20000202400ULL, 0x0000541061357816ULL, 0x004fce0000000066ULL,
0x0000003d003d7306ULL, 0x000ea20000202400ULL, 0x000054105e347816ULL, 0x002fe40000000063ULL,
0x00000018ff5e7819ULL, 0x000fe20000011436ULL, 0x000000104a367824ULL, 0x000fe200078e025bULL,
0x00000018ff4a7819ULL, 0x000fc60000011437ULL, 0x0000005900597306ULL, 0x000fe20000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x0000005700577306ULL, 0x000e620000202400ULL,
0x0000541065347816ULL, 0x008fe40000000056ULL, 0x0000541062357816ULL, 0x000fca000000005dULL,
0x0000003c003c7306ULL, 0x000ee40000202400ULL, 0x00000034142c723cULL, 0x000fec000004182cULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x000054103d347816ULL, 0x004fe40000000060ULL,
0x000054105c3d7816ULL, 0x002fc40000000057ULL, 0x000054103c3c7816ULL, 0x008fc60000000059ULL,
0x0000006400647306ULL, 0x000e680000202400ULL, 0x0000003c1428723cULL, 0x000fe80000041828ULL,
0x0000005500557306ULL, 0x000ea20000202400ULL, 0x000054105f357816ULL, 0x002fce0000000064ULL,
0x0000003e003e7306ULL, 0x000fe20000202400ULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00005410553c7816ULL, 0x004fcc0000000058ULL, 0x0000003f003f7306ULL, 0x000e620000202400ULL,
0x011000003634783bULL, 0x000eae0000000200ULL, 0x0000004b004b7306ULL, 0x000ee20000202400ULL,
0x000054103e3e7816ULL, 0x002fce000000003fULL, 0x0000004c004c7306ULL, 0x000e620000202400ULL,
0x0000541054547816ULL, 0x008fce000000004bULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x0000541051557816ULL, 0x002fce000000004cULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x000000541420723cULL, 0x000fee0000041820ULL, 0x0000005300537306ULL, 0x000e700000202400ULL,
0x0000004d004d7306ULL, 0x000ee20000202400ULL, 0x00005410533d7816ULL, 0x002fce000000005aULL,
0x0000005e00567306ULL, 0x000e620000202400ULL, 0x0000003c1424723cULL, 0x000fe20000041824ULL,
0x000054104d3f7816ULL, 0x008fcc0000000052ULL, 0x0000004a004a7306ULL, 0x000ee20000202400ULL,
0x0000003e141c723cULL, 0x000fe2000004181cULL, 0x0000541056567816ULL, 0x002fe40000000043ULL,
0x000054104a577816ULL, 0x008fce0000000049ULL, 0x000000561410723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x004fde0003800000ULL,
0x0000000334347232ULL, 0x080fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x0000001044457812ULL, 0x000fe200078efe45ULL, 0x0000000104047836ULL, 0x000fc80000000000ULL,
0x0000000145487824ULL, 0x040fe400078e0248ULL, 0x0000000845157824ULL, 0x040fe400078e00ffULL,
0x0000000145427824ULL, 0x000fc600078e0242ULL, 0xfffffff815157812ULL, 0x000fca00078ee248ULL,
0x00000010153c7824ULL, 0x000fe400078e0246ULL, 0x0000000845157824ULL, 0x000fc800078e00ffULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0xfffffff815157812ULL, 0x000fca00078ee242ULL,
0x0000001015157824ULL, 0x000fcc00078e0246ULL, 0x000000001514783bULL, 0x000ea20000004200ULL,
0x00000018ff497819ULL, 0x002fe2000001143cULL, 0x000001003c4b7824ULL, 0x040fe200078e00ffULL,
0x000088803c4c7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe2000001143dULL, 0x000001003d4d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x000001003e517824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000004c004c7306ULL, 0x000fe20000202400ULL,
0x000088803d577816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x00000100165e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fc4000001143eULL, 0x00000018ff467819ULL, 0x000fe2000001143fULL,
0x0000003c00587306ULL, 0x0003e20000202400ULL, 0x000088803f527816ULL, 0x040fe400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff447819ULL, 0x000fe40000011414ULL,
0x00000018ff457819ULL, 0x000fe20000011415ULL, 0x0000004b00537306ULL, 0x0004e20000202400ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00008880175f7816ULL, 0x000fc400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x000088803e4b7816ULL, 0x044fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe4000001143fULL, 0x00008880153f7816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe2000001143eULL, 0x0000004d005c7306ULL, 0x000e620000202400ULL,
0x00008880143e7816ULL, 0x000fc400000000ffULL, 0x00000018ff427819ULL, 0x000fe40000011416ULL,
0x00000018ff437819ULL, 0x000fe40000011417ULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000003d005b7306ULL, 0x0005f00000202400ULL, 0x0000003c005d7306ULL, 0x000be20000202400ULL,
0x00000100143d7824ULL, 0x004fc400078e00ffULL, 0x0001000014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x00000100153c7824ULL, 0x060fe200078e00ffULL, 0x0000004900497306ULL, 0x000ea20000202400ULL,
0x0001000015157824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000004a004a7306ULL, 0x000f700000202400ULL,
0x00000014004d7306ULL, 0x0007f00000202400ULL, 0x0000001500567306ULL, 0x0003e20000202400ULL,
0x000054104c147816ULL, 0x008fe20000000053ULL, 0x000000ffff4c7224ULL, 0x000fcc00078e005fULL,
0x0000004b004b7306ULL, 0x000fe20000202400ULL, 0x0000541057157816ULL, 0x002fce000000005cULL,
0x0000005100547306ULL, 0x000e620000202400ULL, 0x000000143418723cULL, 0x000fee0000041818ULL,
0x0000005200527306ULL, 0x000ee20000202400ULL, 0x0000010017157824ULL, 0x000fe200078e00ffULL,
0x0000541058147816ULL, 0x004fc80000000049ULL, 0x00000018ff497819ULL, 0x000fe40000011415ULL,
0x000054105b157816ULL, 0x020fe2000000004aULL, 0x0000003e003e7306ULL, 0x000fec0000202400ULL,
0x00000014342c723cULL, 0x000fe4000004182cULL, 0x0000003d00517306ULL, 0x00056a0000202400ULL,
0x000054104b147816ULL, 0x002fc40000000054ULL, 0x0000541052157816ULL, 0x008fe2000000005dULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x00008880163d7816ULL, 0x044fe200000000ffULL,
0x0001000016167824ULL, 0x000fc800078e00ffULL, 0x000000143430723cULL, 0x000fe20000041830ULL,
0x000054103e3e7816ULL, 0x020fe20000000051ULL, 0x0000003c005a7306ULL, 0x000e620000202400ULL,
0x00000018ff167819ULL, 0x000fc80000011416ULL, 0x0001000017147824ULL, 0x000fc600078e00ffULL,
0x0000003d003d7306ULL, 0x000fe40000202400ULL, 0x00000018ff4a7819ULL, 0x000fe20000011414ULL,
0x000000040b147836ULL, 0x000fe20000000000ULL, 0x000054103f3f7816ULL, 0x002fc8000000005aULL,
0x0000005e003c7306ULL, 0x000e620000202400ULL, 0x0000000a14147c11ULL, 0x000fe4000f8e18ffULL,
0x0000003e3424723cULL, 0x000fea0000041824ULL, 0x0000004800487306ULL, 0x000fe40000202400ULL,
0x00000001ff3f7424ULL, 0x000fe200078e00ffULL, 0x000054103d3c7816ULL, 0x002fca000000003cULL,
0x0000004600467306ULL, 0x000fe20000202400ULL, 0x0176a83f141479a7ULL, 0x000e6e000850003fULL,
0x0000004400447306ULL, 0x000eb00000202400ULL, 0x0000004500457306ULL, 0x000ee20000202400ULL,
0x000054104d447816ULL, 0x004fce0000000044ULL, 0x0000004200427306ULL, 0x000fe20000202400ULL,
0x0000000a07147c11ULL, 0x002fc8000f8e18ffULL, 0x0176a03f14ff79a7ULL, 0x0003e2000850003fULL,
0x0000541056457816ULL, 0x008fe40000000045ULL, 0x0000004300437306ULL, 0x000fea0000202400ULL,
0x000000443420723cULL, 0x000fe60000041820ULL, 0x0000005500557306ULL, 0x000eb00000202400ULL,
0x0000005900597306ULL, 0x000ee20000202400ULL, 0x0000541055487816ULL, 0x004fce0000000048ULL,
0x0000004c004c7306ULL, 0x000ff00000202400ULL, 0x0000004900537306ULL, 0x0006b00000202400ULL,
0x0000001600177306ULL, 0x000f620000202400ULL, 0x0000541059497816ULL, 0x008fc40000000046ULL,
0x000054104c3d7816ULL, 0x004fca0000000053ULL, 0x0000004a004a7306ULL, 0x000ea20000202400ULL,
0x000000483428723cULL, 0x000fe20000041828ULL, 0x0000541017427816ULL, 0x020fca0000000042ULL,
0x0000003c341c723cULL, 0x000fe2000004181cULL, 0x000054104a437816ULL, 0x004fce0000000043ULL,
0x000000423410723cULL, 0x000fee0000041810ULL, 0x000000ffff347224ULL, 0x000fe200078e0015ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff7000989947ULL, 0x002fde000383ffffULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x000000ffff347224ULL, 0x000fe400078e0025ULL,
0x000000ffff257224ULL, 0x000fe400078e0024ULL, 0x000000ffff247224ULL, 0x000fe400078e001bULL,
0x000000ffff167224ULL, 0x000fe400078e001aULL, 0x000000ffff1b7224ULL, 0x000fc800078e0019ULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x018000004f007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000a90000047802ULL, 0x000fce0000000f00ULL, 0x0000008000207944ULL, 0x016fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000004f00007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc8000000004fULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff027b82ULL, 0x000f640000000a00ULL, 0x0000000802037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000001804187220ULL, 0x042fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x000fe20000410000ULL,
0x0000001605167220ULL, 0x044fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001305137220ULL, 0x000fce0000410000ULL,
0x0000000000027919ULL, 0x002e620000000000ULL, 0x000000202120723eULL, 0x000fe400000010ffULL,
0x0000001c1d1c723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000323332723eULL, 0x000fc400000010ffULL, 0x000000262726723eULL, 0x000fe400000010ffULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000001e1f1e723eULL, 0x000fe400000010ffULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x000000ff0b00720cULL, 0x000fe40003f05270ULL,
0x00000002ff057819ULL, 0x102fe20000011602ULL, 0x0000000109097824ULL, 0x000fe200078e0202ULL,
0x0000000202007812ULL, 0x000fc400078ec0ffULL, 0x0000000802077811ULL, 0x000fe200078ff0ffULL,
0x00000008050e7824ULL, 0x000fe200078e00ffULL, 0x0000000500037211ULL, 0x040fe400078ff8ffULL,
0x0000000700047211ULL, 0x000fe200078ff8ffULL, 0x00000008070d7824ULL, 0x000fe400078e00ffULL,
0x0000000805077824ULL, 0x040fe400078e00ffULL, 0x0000000203007836ULL, 0x000fe20000000000ULL,
0xfffffff80d147812ULL, 0x000fe200078ee204ULL, 0x0000000805047824ULL, 0x000fc400078e00ffULL,
0x00000008050d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8070a7812ULL, 0x000fe200078ee200ULL,
0x0000000403067836ULL, 0x000fe20000000000ULL, 0x0000000a08007c11ULL, 0x000fe2000f8e60ffULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x0000000802057824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee206ULL,
0x000008000b037824ULL, 0x100fe200078e0200ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x0000001009097824ULL, 0x000fe200078e0200ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x0000002c2d04723eULL, 0x000fe200000010ffULL,
0x0000001014197824ULL, 0x100fe200078e0203ULL, 0x000054101e147816ULL, 0x000fe20000000012ULL,
0x000000100a0d7824ULL, 0x000fc400078e0203ULL, 0x000000100c157824ULL, 0x100fe200078e0203ULL,
0x00005410260c7816ULL, 0x000fe20000000022ULL, 0x000000100e177824ULL, 0x000fe200078e0203ULL,
0x000000181b03723eULL, 0x000fe200000010ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x000000253405723eULL, 0x000fe200000010ffULL, 0x00000001060a7824ULL, 0x040fe200078e0219ULL,
0x00005410031a7816ULL, 0x140fe20000000004ULL, 0x00000001060d7824ULL, 0x040fe200078e020dULL,
0x00007632031b7816ULL, 0x000fe20000000004ULL, 0x0000000106157824ULL, 0x040fe200078e0215ULL,
0x000000303103723eULL, 0x000fe200000010ffULL, 0x0000000106177824ULL, 0x000fe200078e0217ULL,
0x000000282904723eULL, 0x000fe200000010ffULL, 0x0000001a07007388ULL, 0x0003e20000000a00ULL,
0x00000010110e723eULL, 0x000fc400000010ffULL, 0x0000541003067816ULL, 0x000fe40000000004ULL,
0x0000002a2b19723eULL, 0x000fc800000010ffULL, 0x0000541032187816ULL, 0x140fe40000000019ULL,
0x0000763232197816ULL, 0x000fe40000000019ULL, 0x0000763203077816ULL, 0x002fe40000000004ULL,
0x000000162403723eULL, 0x000fe400000010ffULL, 0x0000002e2f04723eULL, 0x000fe200000010ffULL,
0x000000060d007388ULL, 0x0003e40000000a00ULL, 0x0000541005067816ULL, 0x002fc40000000020ULL,
0x0000763205077816ULL, 0x000fca0000000020ULL, 0x0000000615007388ULL, 0x0003e40000000a00ULL,
0x000054101c067816ULL, 0x142fe4000000000eULL, 0x000076321c077816ULL, 0x000fca000000000eULL,
0x0000000617007388ULL, 0x0003e40000000a00ULL, 0x0000541003067816ULL, 0x142fe40000000004ULL,
0x0000763203077816ULL, 0x000fe40000000004ULL, 0x000000ff00037306ULL, 0x000e660000202400ULL,
0x000000060a007388ULL, 0x000fe80000000a00ULL, 0x000400180d007388ULL, 0x0007e40000000a00ULL,
0x00007632260d7816ULL, 0x008fca0000000022ULL, 0x0004000c15007388ULL, 0x0007e40000000a00ULL,
0x000076321e157816ULL, 0x008fca0000000012ULL, 0x0004001417007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000009047984ULL, 0x000e680000000c00ULL,
0x0004000009187984ULL, 0x000ee80000000c00ULL, 0x0008000009107984ULL, 0x000f680000000c00ULL,
0x000c0000091c7984ULL, 0x000f620000000c00ULL, 0x0000000703077230ULL, 0x002fc40000200800ULL,
0x0000000603067230ULL, 0x040fe40000200800ULL, 0x0000000503057230ULL, 0x040fe40000200800ULL,
0x0000000403047230ULL, 0x040fe40000200800ULL, 0x0000001b031b7230ULL, 0x048fe40000200800ULL,
0x0000001a031a7230ULL, 0x040fe40000200800ULL, 0x0000001903197230ULL, 0x000fc40000200800ULL,
0x0000001803037230ULL, 0x000fe40000200800ULL, 0x0000001307077230ULL, 0x024fe40000200000ULL,
0x0000001206067230ULL, 0x000fe40000200000ULL, 0x0000001105057230ULL, 0x000fe40000200000ULL,
0x0000001004047230ULL, 0x000fe40000200000ULL, 0x0000001f1b1b7230ULL, 0x000fc40000200000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000200000ULL, 0x0000000409007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000200000ULL, 0x0000001c03187230ULL, 0x000fca0000200000ULL,
0x0004001809007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff057819ULL, 0x002fe20000011602ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x0000003b0500720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00008600ff0b7b82ULL, 0x000e620000000800ULL,
0x0000000105037824ULL, 0x000fe200078e0202ULL, 0x0000880000067ab9ULL, 0x000fe20000000a00ULL,
0xffffffffff067424ULL, 0x000fe400078e00ffULL, 0x0000002002077836ULL, 0x000fe20000000000ULL,
0x0000000703037812ULL, 0x000fc800078ec0ffULL, 0x0ffffff803037812ULL, 0x000fca00078ef802ULL,
0x0000001003047824ULL, 0x000fe400078e0200ULL, 0x0000001040037824ULL, 0x000fc600078e0205ULL,
0x0000000004107984ULL, 0x0004e20000000c00ULL, 0x0000000b060d7219ULL, 0x082fe200000006ffULL,
0x000000040f067c24ULL, 0x000fe2000f8e02ffULL, 0x0000000b41417219ULL, 0x000fe400000006ffULL,
0x0000000d03057212ULL, 0x000fe400078e30ffULL, 0x0000000bff0a7219ULL, 0x000fe40000011603ULL,
0x0000000702037812ULL, 0x000fe200078ec0ffULL, 0x0000000141057824ULL, 0x000fc800078e0205ULL,
0x0000000f0a057224ULL, 0x000fe400078e0205ULL, 0x0000000808037824ULL, 0x000fc600078e0203ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000605047c11ULL, 0x004fc8000f8040ffULL, 0x0000000705057c11ULL, 0x000fe400080f440aULL,
0x00000003ff0a7819ULL, 0x000fe20000011607ULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0x0000003b0a00720cULL, 0x000fe40003f06070ULL, 0x0000001004007986ULL, 0x0083f6000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107037824ULL, 0x100fe400078e020aULL,
0x00000010400a7824ULL, 0x000fe400078e020aULL, 0x0000004002097836ULL, 0x000fe20000000000ULL,
0x0000000703047812ULL, 0x002fc800078ec0ffULL, 0x0ffffff804037812ULL, 0x000fe400078ef807ULL,
0x0000000d0a047212ULL, 0x000fe400078e30ffULL, 0x0000000bff0a7219ULL, 0x000fe2000001160aULL,
0x0000001003037824ULL, 0x000fe200078e0200ULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x0000000141047824ULL, 0x000fc600078e0204ULL, 0x0000000003107984ULL, 0x000e620000000c00ULL,
0x0000000f0a057224ULL, 0x000fe400078e0204ULL, 0x0000000808077824ULL, 0x000fc600078e0207ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000605047c11ULL, 0x000fc8000f8040ffULL, 0x0000000705057c11ULL, 0x000fe400080f440aULL,
0x00000003ff0a7819ULL, 0x000fe20000011609ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x0000003b0a00720cULL, 0x000fe40003f06070ULL, 0x0000001004007986ULL, 0x0023f6000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000109037824ULL, 0x100fe400078e020aULL,
0x00000010400a7824ULL, 0x000fe400078e020aULL, 0x0000006002057836ULL, 0x002fe20000000000ULL,
0x0000000703047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804037812ULL, 0x000fe400078ef809ULL,
0x0000000709097812ULL, 0x000fc600078ec0ffULL, 0x0000001003047824ULL, 0x000fe200078e0200ULL,
0x0000000d0a037212ULL, 0x000fe200078e30ffULL, 0x0000000808097824ULL, 0x000fe200078e0209ULL,
0x0000000bff0a7219ULL, 0x000fe4000001160aULL, 0x0000000004107984ULL, 0x0002a20000000c00ULL,
0x0000000141037824ULL, 0x000fc800078e0203ULL, 0x0000000f0a037224ULL, 0x000fe200078e0203ULL,
0x00000003ff047819ULL, 0x002fc80000011605ULL, 0x0000000306037210ULL, 0x000fe20007f1e0ffULL,
0x0000000105077824ULL, 0x000fc800078e0204ULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000603027c11ULL, 0x000fc8000f8040ffULL, 0x0000000703037c11ULL, 0x000fe400080f440aULL,
0x0000003b0400720cULL, 0x000fe40003f06070ULL, 0x00000007070a7812ULL, 0x000fe200078ec0ffULL,
0x0000001009027825ULL, 0x000fc600078e0002ULL, 0xfffffff80a077812ULL, 0x000fe400078ef805ULL,
0x0000001002007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x0000001040047824ULL, 0x000fc600078e0204ULL, 0x0000000007107984ULL, 0x002e620000000c00ULL,
0x0000000808057824ULL, 0x000fe200078e0205ULL, 0x0000000d04007212ULL, 0x000fe400078e30ffULL,
0x0000000bff047219ULL, 0x000fc60000011604ULL, 0x0000000141007824ULL, 0x000fc800078e0200ULL,
0x0000000f040f7224ULL, 0x000fca00078e0200ULL, 0x0000000f060f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x000000060f027c11ULL, 0x000fc8000f8040ffULL,
0x000000070f037c11ULL, 0x000fc600080f4400ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000001002007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fe2000001163aULL, 0x00009800ff107b82ULL, 0x000e620000000a00ULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000000390400720cULL, 0x000fda0003f06070ULL,
0x00009400ff068b82ULL, 0x000ea20000000800ULL, 0x0000000215078824ULL, 0x000fce00078e00ffULL,
0x00009000ff0a8b82ULL, 0x000ee20000000a00ULL, 0x0000000810087981ULL, 0x002322000c1e9900ULL,
0x0000000607078224ULL, 0x004fe400078e0204ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x00000004070a8825ULL, 0x008fc800078e000aULL, 0x01760006ff0679a7ULL, 0x000e62000850000aULL,
0x000000080a338981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x0000008041417824ULL, 0x000fe400078e00ffULL, 0x000000403a097824ULL, 0x000fe400078e00ffULL,
0x0000008005027824ULL, 0x000fc600078e00ffULL, 0x0000004041057812ULL, 0x000fe200078ef809ULL,
0x0000003302337224ULL, 0x004fc800078e02ffULL, 0x0000000c002c0947ULL, 0x002fea0003800000ULL,
0x00008e00ff107b82ULL, 0x000e620000000a00ULL, 0x00000003ff1e7819ULL, 0x000fca000001160eULL,
0x000000041e127836ULL, 0x000fe40000000000ULL, 0x000000081e167836ULL, 0x000fe40000000000ULL,
0x00000001120b7824ULL, 0x140fe400078e020eULL, 0x00000008120c7824ULL, 0x000fe400078e00ffULL,
0x00000001160f7824ULL, 0x040fe400078e020eULL, 0x0000000816147824ULL, 0x000fe200078e00ffULL,
0xfffffff80c277812ULL, 0x000fe200078ee20bULL, 0x00000001050a7824ULL, 0x000fc400078e021eULL,
0x0000000c1e187836ULL, 0x000fe20000000000ULL, 0xfffffff814297812ULL, 0x000fe200078ee20fULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000010330c7211ULL, 0x002fc600078038ffULL,
0x000000101e147836ULL, 0x000fe20000000000ULL, 0x000000700a217812ULL, 0x000fe200078ef803ULL,
0x00000008181a7824ULL, 0x000fe200078e00ffULL, 0x00000011330f7211ULL, 0x000fe200000f3cffULL,
0x00000001140a7824ULL, 0x140fe200078e020eULL, 0x0000000938107248ULL, 0x000fe20007fe0000ULL,
0x00000008142d7824ULL, 0x000fe200078e00ffULL, 0x000000210c207210ULL, 0x000fe20007f1e0ffULL,
0x0000000118117824ULL, 0x000fe400078e020eULL, 0x00000001101f7824ULL, 0x000fe200078e0a09ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL, 0x00000001050a7824ULL, 0x000fe200078e0212ULL,
0xfffffff81a2b7812ULL, 0x000fe200078ee211ULL, 0x000000010b217824ULL, 0x000fe200000e060fULL,
0x0000001f1200720cULL, 0x080fe20003fa6070ULL, 0x0000000105107824ULL, 0x000fe200078e0216ULL,
0x0000001f1600720cULL, 0x080fe20003f26070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001f1800720cULL, 0x000fc40003f46070ULL, 0x0000001f1400720cULL, 0x000fe20003f06070ULL,
0x000000141e247836ULL, 0x000fe20000000000ULL, 0x000000700a1b7812ULL, 0x000fe200078ef803ULL,
0x0000000105127824ULL, 0x000fe400078e0218ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000c1b1a7210ULL, 0x000fc60007f7e0ffULL, 0x0000000105227824ULL, 0x000fe200078e0224ULL,
0x0000007010177812ULL, 0x000fe200078ef803ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x0000000c17167210ULL, 0x000fe20007f9e0ffULL, 0x00000001051c7824ULL, 0x000fe200078e0214ULL,
0x0000007012197812ULL, 0x000fe200078ef803ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000000a3a147c11ULL, 0x000fc6000f8e70ffULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x000000010b1b7824ULL, 0x100fe200018e060fULL, 0x00000070220b7812ULL, 0x000fe200078ef803ULL,
0x000000181e227836ULL, 0x000fe20000000000ULL, 0x0000000c19187210ULL, 0x000fe20007f7e0ffULL,
0x0000000111177824ULL, 0x100fe200020e060fULL, 0x000000701c117812ULL, 0x000fe200078ef803ULL,
0x0000000105127824ULL, 0x000fe200078e0222ULL, 0x0000000c0b0a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000113197824ULL, 0x000fe200018e060fULL, 0x0000000c11107210ULL, 0x000fe20007f7e0ffULL,
0x000000011e1c7824ULL, 0x000fc400078e020eULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x00000001230b7824ULL, 0x100fe200020e060fULL, 0x000000071c237812ULL, 0x000fe200078ec0ffULL,
0x000000011d117824ULL, 0x000fe200018e060fULL, 0x0000001f1e00720cULL, 0x080fe20003f86070ULL,
0x0000001c1e267836ULL, 0x000fe20000000000ULL, 0x00000070121d7812ULL, 0x000fe200078ef803ULL,
0x00000001241c7824ULL, 0x040fe200078e020eULL, 0x0ffffff823237812ULL, 0x000fe200078ef80eULL,
0x00000008242f7824ULL, 0x040fe200078e00ffULL, 0x0000000c1d127210ULL, 0x000fe20007fde0ffULL,
0x0000100014147836ULL, 0x000fe20000000000ULL, 0x0000001f2400720cULL, 0x000fe20003f66070ULL,
0x00000001051d7824ULL, 0x000fe200078e0226ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee21cULL,
0x000000201e287836ULL, 0x000fc40000000000ULL, 0x0000001023257824ULL, 0x000fe400078e0214ULL,
0x000000801d1c7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e2000e101c48ULL, 0x0000000105237824ULL, 0x000fe200078e0228ULL,
0x0000001f2200720cULL, 0x040fe20003f86070ULL, 0x000000241e2a7836ULL, 0x000fe20000000000ULL,
0x000000701c317812ULL, 0x000fe200078ef803ULL, 0x0000000122247824ULL, 0x040fe400078e020eULL,
0x0000000822337824ULL, 0x000fe400078e00ffULL, 0x0000008023227825ULL, 0x000fc800078e00ffULL,
0x0000000113137824ULL, 0x000fe200030e060fULL, 0x0000000c311c7210ULL, 0x000fe20007fde0ffULL,
0x00000001052c7824ULL, 0x000fe200078e022aULL, 0x0000007022257812ULL, 0x002fe200078ef803ULL,
0x0000001027277824ULL, 0x000fe200078e0214ULL, 0xfffffff833317812ULL, 0x000fe200078ee224ULL,
0x000000802c207825ULL, 0x000fc600078e00ffULL, 0x000000001a277faeULL, 0x0003e2000e901c48ULL,
0x000000281e2c7836ULL, 0x000fe20000000000ULL, 0x0000001f2600720cULL, 0x0c0fe20003fa6070ULL,
0x0000001029297824ULL, 0x000fe400078e0214ULL, 0x000000011d1d7824ULL, 0x000fe200030e060fULL,
0x0000000c25227210ULL, 0x000fe20007fde0ffULL, 0x0000000126247824ULL, 0x040fe200078e020eULL,
0x0000007020257812ULL, 0x000fe200078ef803ULL, 0x0000000826337824ULL, 0x000fe200078e00ffULL,
0x0000000016297faeULL, 0x0005e2000c901c48ULL, 0x000000102b2b7824ULL, 0x000fe200078e0214ULL,
0x0000001f2800720cULL, 0x000fe20003f26070ULL, 0x00000001051a7824ULL, 0x002fc400078e022cULL,
0x0000000123237824ULL, 0x000fe200030e060fULL, 0x0000000c25207210ULL, 0x000fe20007fde0ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0214ULL, 0xfffffff833257812ULL, 0x000fe200078ee224ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x00000000182b7faeULL, 0x0003e2000d101c48ULL,
0x0000001f2a00720cULL, 0x000fe40003f46070ULL, 0x0000002c1e167836ULL, 0x004fe20000000000ULL,
0x00000000102d7faeULL, 0x000fe2000c101c48ULL, 0x000000102f2f7824ULL, 0x000fe200078e0214ULL,
0x000000701a277812ULL, 0x000fe200078ef803ULL, 0x0000000128247824ULL, 0x000fc400078e020eULL,
0x0000000828337824ULL, 0x000fe200078e00ffULL, 0x000000000a2f7faeULL, 0x0005e2000d901c48ULL,
0x000000012a267824ULL, 0x040fe400078e020eULL, 0x0000000105187824ULL, 0x002fe200078e0216ULL,
0xfffffff833177812ULL, 0x000fe200078ee224ULL, 0x000000082a357824ULL, 0x000fe400078e00ffULL,
0x0000000121217824ULL, 0x000fe200030e060fULL, 0x0000000c271a7210ULL, 0x000fe20007fde0ffULL,
0x000000301e247836ULL, 0x000fe20000000000ULL, 0xfffffff835197812ULL, 0x000fe200078ee226ULL,
0x0000001031317824ULL, 0x000fc400078e0214ULL, 0x00000080180a7825ULL, 0x004fe200078e00ffULL,
0x0000001f2400720cULL, 0x080fe40003f66070ULL, 0x0000000012317faeULL, 0x0003e2000e101c48ULL,
0x0000000105107824ULL, 0x000fe200078e0224ULL, 0x000000700a117812ULL, 0x000fe200078ef803ULL,
0x0000001025257824ULL, 0x100fe200078e0214ULL, 0x0000001f1600720cULL, 0x080fe20003f86070ULL,
0x000000011b1b7824ULL, 0x000fe200030e060fULL, 0x0000000c110a7210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x100fe200078e0214ULL, 0x000000001c257faeULL, 0x000fe2000e901c48ULL,
0x0000001019197824ULL, 0x000fe200078e0214ULL, 0x0000001f2c00720cULL, 0x000fe20003fa6070ULL,
0x000000341e267836ULL, 0x000fe20000000000ULL, 0x0000000022177faeULL, 0x000fe2000c901c48ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000020197faeULL, 0x0005e2000d101c48ULL,
0x000000381e287836ULL, 0x000fe20000000000ULL, 0x0000001f2600720cULL, 0x080fe20003f46070ULL,
0x0000003c1e1e7836ULL, 0x000fe40000000000ULL, 0x0000000105127824ULL, 0x002fe200078e0226ULL,
0x0000001f2800720cULL, 0x080fe20003f26070ULL, 0x000000010b0b7824ULL, 0x000fe200030e060fULL,
0x0000001f1e00720cULL, 0x000fe20003f06070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007010197812ULL, 0x004fc600078ef803ULL, 0x0000000124107824ULL, 0x140fe400078e020eULL,
0x0000000824217824ULL, 0x000fe400078e00ffULL, 0x000000012c177824ULL, 0x140fe400078e020eULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x0000000116187824ULL, 0x040fe400078e020eULL, 0x00000008161f7824ULL, 0x000fe200078e00ffULL,
0x0000000c19167210ULL, 0x000fe20007fde0ffULL, 0x0000000105107824ULL, 0x000fe200078e0228ULL,
0x0000007012197812ULL, 0x000fe200078ef803ULL, 0x0000000126127824ULL, 0x040fe200078e020eULL,
0xfffffff82c1d7812ULL, 0x000fe200078ee217ULL, 0x0000000111177824ULL, 0x000fe200030e060fULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee218ULL, 0x0000000826237824ULL, 0x000fe200078e00ffULL,
0x0000000c19187210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000105207824ULL, 0x000fe200078e021eULL, 0xfffffff823057812ULL, 0x000fe200078ee212ULL,
0x0000000113197824ULL, 0x000fe200030e060fULL, 0x0000007010237812ULL, 0x000fe200078ef803ULL,
0x0000008020127825ULL, 0x000fc600078e00ffULL, 0x0000000c23107210ULL, 0x000fe20007fde0ffULL,
0x00000001281c7824ULL, 0x140fe200078e020eULL, 0x0000007012257812ULL, 0x000fe200078ef803ULL,
0x0000000828277824ULL, 0x000fe400078e00ffULL, 0x000000011e0e7824ULL, 0x040fe400078e020eULL,
0x000000081e297824ULL, 0x000fe200078e00ffULL, 0xfffffff827037812ULL, 0x000fe200078ee21cULL,
0x0000000111117824ULL, 0x000fe400030e060fULL, 0x000000101d1d7824ULL, 0x100fe200078e0214ULL,
0xfffffff829237812ULL, 0x000fe200078ee20eULL, 0x000000101f1f7824ULL, 0x100fe200078e0214ULL,
0x0000000c250e7210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x100fe200078e0214ULL,
0x000000001a1d7faeULL, 0x0003e2000e901c48ULL, 0x0000001005057824ULL, 0x000fc400078e0214ULL,
0x0000001003037824ULL, 0x100fe200078e0214ULL, 0x000000000a1f7faeULL, 0x0003e2000e101c48ULL,
0x0000001023237824ULL, 0x000fe400078e0214ULL, 0x00000001130f7824ULL, 0x000fe200030e060fULL,
0x0000000016217faeULL, 0x0003e8000d901c48ULL, 0x0000000018057faeULL, 0x0003e8000d101c48ULL,
0x0000000010037faeULL, 0x0003e8000c901c48ULL, 0x000000000e237faeULL, 0x0003e2000c101c48ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x000000040e107811ULL, 0x040fe400078fe8ffULL,
0x000000080e127811ULL, 0x040fe400078fe8ffULL, 0x0000000c0e137811ULL, 0x000fe200078fe8ffULL,
0x00000001100a7824ULL, 0x100fe200078e020eULL, 0x000000140e177811ULL, 0x000fe200078fe8ffULL,
0x00000008101d7824ULL, 0x000fe200078e00ffULL, 0x000000180e197811ULL, 0x000fe200078fe8ffULL,
0x00000001120b7824ULL, 0x100fe200078e020eULL, 0x0000001c0e1b7811ULL, 0x000fe200078fe8ffULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL,
0x00000001130c7824ULL, 0x140fe200078e020eULL, 0x000000100e147811ULL, 0x040fe200078fe8ffULL,
0x0000000813237824ULL, 0x000fe200078e00ffULL, 0xfffffff8161f7812ULL, 0x000fe200078ee20bULL,
0x00000001170a7824ULL, 0x140fe200078e020eULL, 0x000000240e357811ULL, 0x040fe200078fe8ffULL,
0x0000000817297824ULL, 0x000fe200078e00ffULL, 0x000000280e347811ULL, 0x040fe200078fe8ffULL,
0x00000001190b7824ULL, 0x140fe200078e020eULL, 0xfffffff823237812ULL, 0x000fe200078ee20cULL,
0x0000000819167824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x000000011b0c7824ULL, 0x140fe200078e020eULL, 0x0000002c0e327811ULL, 0x000fe200078fe8ffULL,
0x000000081b2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8162b7812ULL, 0x000fe200078ee20bULL,
0x00000001140f7824ULL, 0x100fe200078e020eULL, 0x000000200e1c7811ULL, 0x000fe200078fe8ffULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20cULL,
0x00000001350a7824ULL, 0x140fe200078e020eULL, 0x000000300e317811ULL, 0x000fe200078fe8ffULL,
0x0000000835117824ULL, 0x000fe200078e00ffULL, 0xfffffff818277812ULL, 0x000fe200078ee20fULL,
0x00000001340b7824ULL, 0x100fe200078e020eULL, 0x000000340e267811ULL, 0x000fe200078fe8ffULL,
0x0000000834167824ULL, 0x000fe200078e00ffULL, 0xfffffff8111e7812ULL, 0x000fe200078ee20aULL,
0x00000001320c7824ULL, 0x100fe200078e020eULL, 0x000000380e287811ULL, 0x000fe200078fe8ffULL,
0x0000000832257824ULL, 0x000fe200078e00ffULL, 0xfffffff816217812ULL, 0x000fe200078ee20bULL,
0x000000011c0f7824ULL, 0x040fe200078e020eULL, 0x00008e00ff0a7b82ULL, 0x000e620000000a00ULL,
0x000000081c187824ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe200078ee20cULL,
0x0000000105107824ULL, 0x040fe200078e0210ULL, 0x0000000e0e0c7211ULL, 0x040fe200078fe8ffULL,
0x0000000105127824ULL, 0x000fe200078e0212ULL, 0xfffffff8182f7812ULL, 0x000fe200078ee20fULL,
0x00000001310f7824ULL, 0x040fe200078e020eULL, 0x0000003c0e2e7811ULL, 0x000fe200078fe8ffULL,
0x0000000831187824ULL, 0x000fe200078e00ffULL, 0x000000070c117812ULL, 0x000fe200078ec0ffULL,
0x0000000105167824ULL, 0x040fe200078e0213ULL, 0x0000000a3a377c11ULL, 0x000fe2000f8e70ffULL,
0x00000001051a7824ULL, 0x040fe200078e0217ULL, 0xfffffff818257812ULL, 0x000fe200078ee20fULL,
0x0000000105187824ULL, 0x040fe200078e0214ULL, 0x000000050e0f7211ULL, 0x000fe200078fe8ffULL,
0x0000000105207824ULL, 0x000fc400078e0219ULL, 0x0000000105247824ULL, 0x040fe400078e021bULL,
0x0000000105367824ULL, 0x040fe400078e021cULL, 0x0000000105357824ULL, 0x040fe400078e0235ULL,
0x0000000105347824ULL, 0x040fe400078e0234ULL, 0x0000000105327824ULL, 0x040fe400078e0232ULL,
0x0000000105317824ULL, 0x000fc400078e0231ULL, 0x0000000105307824ULL, 0x040fe400078e0226ULL,
0x00000001052a7824ULL, 0x040fe400078e0228ULL, 0x00000001052c7824ULL, 0x000fe200078e022eULL,
0x0ffffff811057812ULL, 0x000fe200078ef80eULL, 0x00000001260c7824ULL, 0x100fe400078e020eULL,
0x0000000128137824ULL, 0x100fe400078e020eULL, 0x000000012e0e7824ULL, 0x000fc400078e020eULL,
0x000000082e117824ULL, 0x000fe400078e00ffULL, 0x0000000828287824ULL, 0x000fe400078e00ffULL,
0x0000000826177824ULL, 0x000fe200078e00ffULL, 0xfffffff8112e7812ULL, 0x000fe200078ee20eULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff828137812ULL, 0x000fe400078ee213ULL,
0xfffffff817267812ULL, 0x000fe200078ee20cULL, 0x00001000373c7836ULL, 0x000fe20000000000ULL,
0x0000000a330c7211ULL, 0x002fe200078038ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e1b7812ULL, 0x000fc400078ef803ULL, 0x0000000b33337211ULL, 0x000fe200000f3cffULL,
0x0000001013287824ULL, 0x100fe200078e023cULL, 0x00000070100b7812ULL, 0x000fe200078ef803ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001b0c0a7210ULL, 0x000fe40007f1e0ffULL,
0x0000000b0c0e7210ULL, 0x000fe20007f3e0ffULL, 0x00000010211c7824ULL, 0x000fe200078e023cULL,
0x0000007012217812ULL, 0x000fe200078ef803ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000070161b7812ULL, 0x000fc600078ef803ULL,
0x000000010f0b7824ULL, 0x100fe200000e0633ULL, 0x000000210c107210ULL, 0x000fe20007f1e0ffULL,
0x00000001110f7824ULL, 0x100fe200008e0633ULL, 0x0000007018217812ULL, 0x000fe200078ef803ULL,
0x000000101e147824ULL, 0x100fe200078e023cULL, 0x0000001b0c127210ULL, 0x000fe20007f5e0ffULL,
0x0000000113117824ULL, 0x000fe200000e0633ULL, 0x000000210c167210ULL, 0x000fe20007f1e0ffULL,
0x00000010221e7824ULL, 0x000fe400078e023cULL, 0x000000801a1a7825ULL, 0x000fc800078e00ffULL,
0x0000001025227824ULL, 0x000fe200078e023cULL, 0x000000701a3f7812ULL, 0x000fe200078ef803ULL,
0x0000008020207825ULL, 0x000fc800078e00ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x00000070203d7812ULL, 0x000fc600078ef803ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000070243b7812ULL, 0x000fe400078ef803ULL, 0x0000003d0c1a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000117137824ULL, 0x100fe200010e0633ULL, 0x0000003b0c207210ULL, 0x000fe20007f5e0ffULL,
0x0000000119177824ULL, 0x100fe200000e0633ULL, 0x0000007036197812ULL, 0x000fe200078ef803ULL,
0x0000001005057824ULL, 0x100fe200078e023cULL, 0x0000003f0c187210ULL, 0x000fe20007f1e0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e023cULL, 0x000000190c247210ULL, 0x000fe20007f7e0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e023cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a057faeULL, 0x0003e2000b901c48ULL, 0x000000011b197824ULL, 0x000fc400000e0633ULL,
0x00000001211b7824ULL, 0x100fe200008e0633ULL, 0x000000000e1d7faeULL, 0x0003e2000b901c48ULL,
0x0000000125217824ULL, 0x100fe400010e0633ULL, 0x0000000137257824ULL, 0x000fe200018e0633ULL,
0x00000000101f7faeULL, 0x0003e2000b901c48ULL, 0x0000008035367825ULL, 0x000fc800078e00ffULL,
0x0000001023237824ULL, 0x100fe200078e023cULL, 0x00000070364f7812ULL, 0x000fe200078ef803ULL,
0x0000001027277824ULL, 0x100fe400078e023cULL, 0x0000001029297824ULL, 0x100fe200078e023cULL,
0x0000004f0c367210ULL, 0x000fe20007f1e0ffULL, 0x000000102b2b7824ULL, 0x100fe200078e023cULL,
0x0000000012237faeULL, 0x0003e2000b901c48ULL, 0x000000102d2d7824ULL, 0x100fe400078e023cULL,
0x000000102f2f7824ULL, 0x100fe200078e023cULL, 0x0000000016277faeULL, 0x0003e2000b901c48ULL,
0x0000001026267824ULL, 0x000fc400078e023cULL, 0x000000102e2e7824ULL, 0x000fe200078e023cULL,
0x0000000018297faeULL, 0x0003e2000b901c48ULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0x000000001a2b7faeULL, 0x0003e2000b901c48ULL, 0x00000080323c7825ULL, 0x000fe200078e00ffULL,
0x00000070344d7812ULL, 0x000fe400078ef803ULL, 0x00000000202d7faeULL, 0x0003e2000b901c48ULL,
0x00000080313e7825ULL, 0x000fe200078e00ffULL, 0x000000703c4b7812ULL, 0x000fe400078ef803ULL,
0x0000004d0c347210ULL, 0x000fe20007f3e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x000000703e497812ULL, 0x000fe200078ef803ULL, 0x00000000242f7faeULL, 0x0003e2000b901c48ULL,
0x0000004b0c3c7210ULL, 0x000fe20007f5e0ffULL, 0x000000802a427825ULL, 0x000fe200078e00ffULL,
0x0000007030477812ULL, 0x000fc400078ef803ULL, 0x000000490c3e7210ULL, 0x000fe20007f7e0ffULL,
0x000000802c447825ULL, 0x000fe200078e00ffULL, 0x00000070423b7812ULL, 0x000fe400078ef803ULL,
0x000000470c307210ULL, 0x000fe20007f9e0ffULL, 0x0000000137377824ULL, 0x100fe200000e0633ULL,
0x0000007044037812ULL, 0x000fe200078ef803ULL, 0x0000000135357824ULL, 0x100fe200008e0633ULL,
0x0000003b0c427210ULL, 0x000fe20007fbe0ffULL, 0x000000013d3d7824ULL, 0x100fe200010e0633ULL,
0x000000030c327210ULL, 0x000fe20007fde0ffULL, 0x000000013f3f7824ULL, 0x100fe200018e0633ULL,
0x0000000036147faeULL, 0x0003e2000b901c48ULL, 0x0000000131317824ULL, 0x000fc400020e0633ULL,
0x0000000143437824ULL, 0x100fe200028e0633ULL, 0x00000000341c7faeULL, 0x0003e2000b901c48ULL,
0x0000000145337824ULL, 0x000fc600030e0633ULL, 0x000000003c1e7faeULL, 0x0003e8000b901c48ULL,
0x000000003e227faeULL, 0x0003e8000b901c48ULL, 0x0000000030267faeULL, 0x0003e8000b901c48ULL,
0x0000000042287faeULL, 0x0003e8000b901c48ULL, 0x00000000322e7faeULL, 0x0003e4000b901c48ULL,
0x0000000204047836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e280000000000ULL,
0x000000390400720cULL, 0x000fda0003f06070ULL, 0x00009400ff038b82ULL, 0x002e620000000800ULL,
0x0000000215058824ULL, 0x000fce00078e00ffULL, 0x00009000ff0a8b82ULL, 0x000ea20000000a00ULL,
0x0000000305058224ULL, 0x002fe400078e0204ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x00000004050a8825ULL, 0x004fca00078e000aULL, 0x000000080a038981ULL, 0x000324000c1e1900ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x01760007ff0075a7ULL, 0x000e64000800014aULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff107224ULL, 0x000fce00078e00ffULL,
0x000000101000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fce0000015200ULL, 0x0000000e0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0e7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140eULL,
0x0000000c05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060eULL,
0x0000000205057819ULL, 0x000fc8000000120cULL, 0x000000050000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000110107836ULL, 0x000fce0000000000ULL,
0x01760007ff0075a7ULL, 0x000e64000800014aULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00000001ff0e7424ULL, 0x000fe400078e00ffULL,
0x000000203a057824ULL, 0x002fca00078e0205ULL, 0x00000003ff067819ULL, 0x000fc80000011605ULL,
0x1ffffffe060a7812ULL, 0x000fe400078ec0ffULL, 0x0000000f05067812ULL, 0x000fc600078ec0ffULL,
0x00000001050a7824ULL, 0x000fe400078e020aULL, 0x0000001006077824ULL, 0x000fe400078e00ffULL,
0x000000010a057836ULL, 0x000fe20000000000ULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x000fc600078e00ffULL, 0x0000000f05057812ULL, 0x000fe400078ec0ffULL,
0x000000f0070a7812ULL, 0x000fe400078ee20aULL, 0x000000f006057812ULL, 0x000fe400078ee205ULL,
0x0000000a0a0a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a05057c11ULL, 0x000fc6000f8e20ffULL,
0x000000000a187984ULL, 0x000e680000000c00ULL, 0x0000000005107984ULL, 0x000ea20000000c00ULL,
0x000000ffff1c7224ULL, 0x002fe400078e0018ULL, 0x000000ffff187224ULL, 0x000fe400078e0019ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001aULL, 0x000000ffff197224ULL, 0x000fc400078e001bULL,
0x000000ffff1e7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0012ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1b7224ULL, 0x000fe200078e0013ULL,
0x0000001c0a007388ULL, 0x0003e80000000c00ULL, 0x0000001805007388ULL, 0x0003e20000000c00ULL,
0x0176000eff0e79a7ULL, 0x000ea4000850000aULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0176000fff0075a7ULL, 0x004ea4000800014aULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x0176000fff0075a7ULL, 0x000ea4000800014aULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009400ff067b82ULL, 0x000ea20000000800ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000840000077ab9ULL, 0x000fe20000000800ULL,
0x3db504f308087820ULL, 0x010fe20000410000ULL, 0x0000001f07047890ULL, 0x000fe4000fffe03fULL,
0x80000007380c7c36ULL, 0x000fe20008000000ULL, 0x0000000a3a0a7c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x00000008ff0c7819ULL, 0x000fe2000001160cULL,
0xffffffff07057890ULL, 0x000fc4000fffe03fULL, 0x0000000907067890ULL, 0x000fe4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x0000000615077224ULL, 0x004fe400078e02ffULL,
0x0000010009067836ULL, 0x000fe20000000000ULL, 0x0000000a3a097c11ULL, 0x000fd0000f8e18ffULL,
0x000000020b0e7836ULL, 0x000fe40000000000ULL, 0x000001000b0f7824ULL, 0x004fe400078e0206ULL,
0x0000000302127224ULL, 0x010fe200078e02ffULL, 0x0000000d0e00720cULL, 0x000fe40003f06070ULL,
0x000000400f107812ULL, 0x000fe400078ec0ffULL, 0x00000001140e7812ULL, 0x000fc600078e0cffULL,
0x0000000141107824ULL, 0x000fcc00078e0210ULL, 0x0000000c00388947ULL, 0x000fea0003800000ULL,
0x00008e00ff187b82ULL, 0x000ea20000000a00ULL, 0x00000003ff177819ULL, 0x002fe40000011605ULL,
0x0000000f38247248ULL, 0x000fc60007fe0000ULL, 0x0000000417157836ULL, 0x000fe40000000000ULL,
0x00000008171b7836ULL, 0x000fe40000000000ULL, 0x0000000115037824ULL, 0x140fe400078e0205ULL,
0x00000008152e7824ULL, 0x000fe400078e00ffULL, 0x000000011b167824ULL, 0x040fe400078e0205ULL,
0x000000081b1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee203ULL,
0x0000000117137824ULL, 0x000fc400078e0210ULL, 0x0000000124247824ULL, 0x000fe200078e0a0fULL,
0xfffffff81d307812ULL, 0x000fe200078ee216ULL, 0x0000001005167824ULL, 0x000fe200078e00ffULL,
0x0000001812117211ULL, 0x044fe200078038ffULL, 0x00000010171d7836ULL, 0x000fe20000000000ULL,
0x000000241b00720cULL, 0x0c0fe20003f26070ULL, 0x000000011b1a7824ULL, 0x000fe200078e0210ULL,
0x0000001912037211ULL, 0x000fe200000f3cffULL, 0x0000000c17197836ULL, 0x000fe20000000000ULL,
0x0000007016167812ULL, 0x000fe200078ec0ffULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x000000241500720cULL, 0x000fc40003fa6070ULL, 0x000000241900720cULL, 0x040fe20003f46070ULL,
0x0000000119187824ULL, 0x040fe200078e0205ULL, 0x0000001612127212ULL, 0x000fe200078efcffULL,
0x00000008191f7824ULL, 0x040fe400078e00ffULL, 0x00000001191c7824ULL, 0x100fe200078e0210ULL,
0x0000001211127210ULL, 0x000fe20007f1e0ffULL, 0x0000001417297836ULL, 0x000fe20000000000ULL,
0xfffffff81f327812ULL, 0x000fe200078ee218ULL, 0x0000000115187824ULL, 0x000fe200078e0210ULL,
0x0000000a3a157c11ULL, 0x000fe2000f8e70ffULL, 0x0000000113137824ULL, 0x000fe200000e0603ULL,
0x000000241d00720cULL, 0x000fe20003f06070ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x000000011d2c7824ULL, 0x040fe200078e0205ULL, 0x0000001618207212ULL, 0x000fe200078efcffULL,
0x000000081d217824ULL, 0x040fe400078e00ffULL, 0x000000011d227824ULL, 0x000fe200078e0210ULL,
0x0000001120207210ULL, 0x000fe20007f7e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0xfffffff8212c7812ULL, 0x000fc600078ee22cULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000161a1a7212ULL, 0x000fc600078efcffULL, 0x0000000129267824ULL, 0x000fe200078e0210ULL,
0x000000161c1e7212ULL, 0x000fe200078efcffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x000000111a1a7210ULL, 0x000fc60007f9e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000001622187212ULL, 0x000fc600078efcffULL, 0x0000000119217824ULL, 0x000fe200018e0603ULL,
0x000000111e1e7210ULL, 0x000fe20007f7e0ffULL, 0x00000018172d7836ULL, 0x000fe20000000000ULL,
0x00000016261c7212ULL, 0x000fe200078efcffULL, 0x0000000117267824ULL, 0x000fe400078e0205ULL,
0x000000011b1b7824ULL, 0x100fe200020e0603ULL, 0x0000001118187210ULL, 0x000fe20007f9e0ffULL,
0x000000011d1f7824ULL, 0x000fe200018e0603ULL, 0x000000111c1c7210ULL, 0x000fe20007f7e0ffULL,
0x000000012d227824ULL, 0x000fe200078e0210ULL, 0x0000000726267812ULL, 0x000fe200078ec0ffULL,
0x0000001c17317836ULL, 0x000fc40000000000ULL, 0x0000000123197824ULL, 0x100fe200020e0603ULL,
0x0ffffff826287812ULL, 0x000fe200078ef805ULL, 0x00000001271d7824ULL, 0x000fe200018e0603ULL,
0x000000241700720cULL, 0x080fe20003f86070ULL, 0x000020000e257824ULL, 0x000fe200078e0215ULL,
0x000000242900720cULL, 0x000fe20003f66070ULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x0000000129277824ULL, 0x040fe200078e0205ULL, 0x0000001622227212ULL, 0x000fe200078efcffULL,
0x0000000829347824ULL, 0x000fe400078e00ffULL, 0x0000000131267824ULL, 0x000fe200078e0210ULL,
0x0000001122227210ULL, 0x000fe20007fde0ffULL, 0x0000100025257836ULL, 0x000fe20000000000ULL,
0xfffffff834347812ULL, 0x000fe200078ee227ULL, 0x0000002017337836ULL, 0x000fe40000000000ULL,
0x0000008026267825ULL, 0x000fc800078e00ffULL, 0x00000010282b7824ULL, 0x000fe200078e0225ULL,
0x0000001626267212ULL, 0x000fe200078efcffULL, 0x0000000133287824ULL, 0x000fe400078e0210ULL,
0x0000002417357836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000122b7faeULL, 0x0003e2000e101c48ULL, 0x000000012d2f7824ULL, 0x040fe200078e0205ULL,
0x000000242d00720cULL, 0x040fe20003f86070ULL, 0x000000082d367824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee22fULL,
0x0000000123237824ULL, 0x000fe200030e0603ULL, 0x0000001126267210ULL, 0x000fe20007fde0ffULL,
0x00000001352a7824ULL, 0x000fe200078e0210ULL, 0x0000001628287212ULL, 0x000fe200078efcffULL,
0x000000102e2d7824ULL, 0x000fe400078e0225ULL, 0x000000802a127825ULL, 0x002fc600078e00ffULL,
0x00000000202d7faeULL, 0x0003e2000e901c48ULL, 0x00000010302f7824ULL, 0x000fe200078e0225ULL,
0x00000016122a7212ULL, 0x000fe200078efcffULL, 0x0000000127277824ULL, 0x000fe200030e0603ULL,
0x0000001128287210ULL, 0x000fe20007fde0ffULL, 0x0000000835307824ULL, 0x000fe200078e00ffULL,
0x000000001a2f7faeULL, 0x0005e2000c901c48ULL, 0x000000243300720cULL, 0x080fe20003f26070ULL,
0x0000002817377836ULL, 0x000fe20000000000ULL, 0x000000243100720cULL, 0x040fe20003fa6070ULL,
0x00000001312b7824ULL, 0x000fc400078e0205ULL, 0x0000000133207824ULL, 0x102fe400078e0205ULL,
0x00000001352d7824ULL, 0x000fe400078e0205ULL, 0x0000000833337824ULL, 0x000fe400078e00ffULL,
0x00000008312e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8301a7812ULL, 0x004fe200078ee22dULL,
0x0000000129297824ULL, 0x000fe200030e0603ULL, 0x000000112a2a7210ULL, 0x000fe20007fde0ffULL,
0x0000000137127824ULL, 0x000fe200078e0210ULL, 0xfffffff833207812ULL, 0x000fe200078ee220ULL,
0x0000001032217824ULL, 0x000fe200078e0225ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee22bULL,
0x0000002c17337836ULL, 0x000fc40000000000ULL, 0x00000001132b7824ULL, 0x000fe200030e0603ULL,
0x000000001e217faeULL, 0x0003e2000d101c48ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000243500720cULL, 0x000fc60003f46070ULL, 0x000000102c1b7824ULL, 0x100fe200078e0225ULL,
0x0000001612127212ULL, 0x000fe200078efcffULL, 0x000000101a317824ULL, 0x100fe400078e0225ULL,
0x00000001331a7824ULL, 0x000fe200078e0210ULL, 0x00000000181b7faeULL, 0x0005e2000c101c48ULL,
0x0000003017357836ULL, 0x000fe20000000000ULL, 0x0000001112127210ULL, 0x000fe20007fde0ffULL,
0x00000010341f7824ULL, 0x102fe400078e0225ULL, 0x0000001036217824ULL, 0x000fc400078e0225ULL,
0x00000034173b7836ULL, 0x000fe20000000000ULL, 0x000000001c1f7faeULL, 0x0003e2000d901c48ULL,
0x000000102e2d7824ULL, 0x000fe200078e0225ULL, 0x000000243500720cULL, 0x080fe20003f66070ULL,
0x0000000113137824ULL, 0x000fe200030e0603ULL, 0x0000000022217faeULL, 0x0007e2000e101c48ULL,
0x000000801a187825ULL, 0x004fe200078e00ffULL, 0x000000243300720cULL, 0x000fe40003f86070ULL,
0x00000000262d7faeULL, 0x0005e2000e901c48ULL, 0x00000001351a7824ULL, 0x000fe200078e0210ULL,
0x0000001618187212ULL, 0x000fe200078efcffULL, 0x00000010202f7824ULL, 0x000fe200078e0225ULL,
0x000000243700720cULL, 0x000fe20003fa6070ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000001118187210ULL, 0x000fc40007fde0ffULL, 0x00000000282f7faeULL, 0x0009e2000c901c48ULL,
0x000000013b1c7824ULL, 0x042fe200078e0210ULL, 0x000000161a1a7212ULL, 0x000fe200078efcffULL,
0x0000003817237836ULL, 0x008fe20000000000ULL, 0x000000002a317faeULL, 0x0003e2000d101c48ULL,
0x0000003c173d7836ULL, 0x000fe20000000000ULL, 0x000000243b00720cULL, 0x080fe20003f46070ULL,
0x00000001331e7824ULL, 0x000fe200078e0205ULL, 0x000000242300720cULL, 0x080fe20003f26070ULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x000000243d00720cULL, 0x000fe20003f06070ULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0xfffffff833247812ULL, 0x000fe200078ee21eULL,
0x0000000119197824ULL, 0x000fe200030e0603ULL, 0x000000111a1a7210ULL, 0x000fe20007fde0ffULL,
0x00000001351f7824ULL, 0x140fe200078e0205ULL, 0x000000161c207212ULL, 0x000fe200078efcffULL,
0x0000000835267824ULL, 0x004fe400078e00ffULL, 0x00000001231e7824ULL, 0x000fe400078e0210ULL,
0x0000000137177824ULL, 0x040fe200078e0205ULL, 0xfffffff826267812ULL, 0x000fe200078ee21fULL,
0x0000000837227824ULL, 0x000fc400078e00ffULL, 0x000000011b1b7824ULL, 0x000fe200030e0603ULL,
0x0000001120207210ULL, 0x000fe20007fde0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fc600078ee217ULL, 0x000000013d1c7824ULL, 0x000fe200078e0210ULL,
0x000000161e1e7212ULL, 0x000fe200078efcffULL, 0x000000013b177824ULL, 0x040fe400078e0205ULL,
0x000000083b287824ULL, 0x010fe400078e00ffULL, 0x000000011d217824ULL, 0x000fe200030e0603ULL,
0x000000111e1e7210ULL, 0x000fe20007fde0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fc600078ee217ULL, 0x0000000123177824ULL, 0x140fe200078e0205ULL,
0x000000161c107212ULL, 0x000fe200078efcffULL, 0x00000008232a7824ULL, 0x002fe400078e00ffULL,
0x000000013d237824ULL, 0x040fe400078e0205ULL, 0x000000083d2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a167812ULL, 0x000fe200078ee217ULL, 0x000000011f1f7824ULL, 0x000fe200030e0603ULL,
0x0000001110107210ULL, 0x000fe20007fde0ffULL, 0x0000001022177824ULL, 0x100fe200078e0225ULL,
0xfffffff82c1c7812ULL, 0x000fe200078ee223ULL, 0x0000001024237824ULL, 0x000fc400078e0225ULL,
0x0000001026277824ULL, 0x100fe200078e0225ULL, 0x0000000012177faeULL, 0x0003e2000e901c48ULL,
0x0000001028297824ULL, 0x100fe400078e0225ULL, 0x00000010162b7824ULL, 0x100fe200078e0225ULL,
0x0000000018237faeULL, 0x0003e2000e101c48ULL, 0x000000101c257824ULL, 0x000fe400078e0225ULL,
0x000000011d117824ULL, 0x000fe200030e0603ULL, 0x000000001a277faeULL, 0x0003e8000d901c48ULL,
0x0000000020297faeULL, 0x0003e8000d101c48ULL, 0x000000001e2b7faeULL, 0x0003e8000c901c48ULL,
0x0000000010257faeULL, 0x0003e2000c101c48ULL, 0x0000000800e87947ULL, 0x000fea0003800000ULL,
0x0000000405137811ULL, 0x042fe200078fe8ffULL, 0x00008e00ff507b82ULL, 0x000e620000000a00ULL,
0x0000000805167811ULL, 0x040fe200078fe8ffULL, 0x0000001005537824ULL, 0x040fe200078e00ffULL,
0x00000014051c7811ULL, 0x000fe200078fe8ffULL, 0x0000000113037824ULL, 0x100fe200078e0205ULL,
0x00000018051e7811ULL, 0x000fe200078fe8ffULL, 0x0000000813187824ULL, 0x000fe200078e00ffULL,
0x0000002805307811ULL, 0x040fe200078fe8ffULL, 0x0000000116117824ULL, 0x140fe200078e0205ULL,
0x0000002c052e7811ULL, 0x040fe200078fe8ffULL, 0x00000008161a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8184d7812ULL, 0x000fe200078ee203ULL, 0x000000011c157824ULL, 0x140fe200078e0205ULL,
0x0000000c05187811ULL, 0x040fe200078fe8ffULL, 0x000000081c247824ULL, 0x000fe200078e00ffULL,
0xfffffff81a4b7812ULL, 0x000fe200078ee211ULL, 0x000000011e177824ULL, 0x100fe200078e0205ULL,
0x00000010051a7811ULL, 0x040fe200078fe8ffULL, 0x0000000118037824ULL, 0x140fe200078e0205ULL,
0xfffffff824457812ULL, 0x000fe200078ee215ULL, 0x0000000818207824ULL, 0x000fe200078e00ffULL,
0x0000002405247811ULL, 0x040fe200078fe8ffULL, 0x000000011a117824ULL, 0x140fe200078e0205ULL,
0x0000003c051f7811ULL, 0x040fe200078fe8ffULL, 0x000000081a227824ULL, 0x000fe200078e00ffULL,
0xfffffff820497812ULL, 0x000fe200078ee203ULL, 0x000000081e267824ULL, 0x000fe200078e00ffULL,
0x0000001c05207811ULL, 0x040fe200078fe8ffULL, 0x0000000124157824ULL, 0x140fe200078e0205ULL,
0xfffffff822477812ULL, 0x000fe200078ee211ULL, 0x00000008242a7824ULL, 0x000fe200078e00ffULL,
0x0000002005227811ULL, 0x040fe200078fe8ffULL, 0x0000000130197824ULL, 0x140fe200078e0205ULL,
0xfffffff826177812ULL, 0x000fe200078ee217ULL, 0x00000008302c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a3b7812ULL, 0x000fe200078ee215ULL, 0x0000000120037824ULL, 0x140fe200078e0205ULL,
0x00000034052a7811ULL, 0x040fe200078fe8ffULL, 0x0000000820267824ULL, 0x000fe200078e00ffULL,
0xfffffff82c197812ULL, 0x000fe200078ee219ULL, 0x0000000122117824ULL, 0x140fe200078e0205ULL,
0x00000030052c7811ULL, 0x000fe200078fe8ffULL, 0x0000000822287824ULL, 0x000fe200078e00ffULL,
0xfffffff8263f7812ULL, 0x000fe200078ee203ULL, 0x000000012e037824ULL, 0x140fe200078e0205ULL,
0x0000007053537812ULL, 0x000fe200078ec0ffULL, 0x000000082e267824ULL, 0x000fe200078e00ffULL,
0xfffffff8283d7812ULL, 0x000fe200078ee211ULL, 0x000000012a157824ULL, 0x140fe200078e0205ULL,
0x0000003805287811ULL, 0x040fe200078fe8ffULL, 0x000000082a347824ULL, 0x000fe200078e00ffULL,
0xfffffff826357812ULL, 0x000fe200078ee203ULL, 0x000000012c117824ULL, 0x140fe200078e0205ULL,
0x0000000505037211ULL, 0x000fe200078fe8ffULL, 0x000000082c327824ULL, 0x000fe200078e00ffULL,
0xfffffff834337812ULL, 0x000fe200078ee215ULL, 0x00000001281d7824ULL, 0x000fe200078e0205ULL,
0x0000000a3a157c11ULL, 0x000fe2000f8e70ffULL, 0x0000000828367824ULL, 0x000fe200078e00ffULL,
0xfffffff8321b7812ULL, 0x000fe200078ee211ULL, 0x0000000113137824ULL, 0x100fe200078e0210ULL,
0x0000001005117211ULL, 0x000fe200078fe8ffULL, 0x0000000116167824ULL, 0x100fe200078e0210ULL,
0xfffffff8361d7812ULL, 0x000fe200078ee21dULL, 0x0000000118187824ULL, 0x100fe200078e0210ULL,
0x0000005012367211ULL, 0x002fe200078038ffULL, 0x000000011a1a7824ULL, 0x000fc400078e0210ULL,
0x000000011c1c7824ULL, 0x100fe200078e0210ULL, 0x0000005112517211ULL, 0x000fe200000f3cffULL,
0x000000011e1e7824ULL, 0x100fe400078e0210ULL, 0x0000000120207824ULL, 0x100fe400078e0210ULL,
0x0000000122227824ULL, 0x100fe400078e0210ULL, 0x0000000124247824ULL, 0x100fe400078e0210ULL,
0x0000000130307824ULL, 0x000fc400078e0210ULL, 0x000000012e2e7824ULL, 0x100fe400078e0210ULL,
0x000000012c2c7824ULL, 0x100fe400078e0210ULL, 0x000000012a2a7824ULL, 0x100fe400078e0210ULL,
0x0000000128287824ULL, 0x100fe400078e0210ULL, 0x000000011f267824ULL, 0x000fe200078e0210ULL,
0x0000000703107812ULL, 0x000fe200078ec0ffULL, 0x000020000e037824ULL, 0x000fc400078e0215ULL,
0x000000011f217824ULL, 0x040fe200078e0205ULL, 0x0ffffff8104f7812ULL, 0x000fe200078ef805ULL,
0x000000081f327824ULL, 0x000fe400078e00ffULL, 0x00001000033c7836ULL, 0x000fe40000000000ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0xfffffff832217812ULL, 0x000fc600078ee221ULL,
0x000000101d327824ULL, 0x100fe200078e023cULL, 0x00000053101d7212ULL, 0x000fe200078efcffULL,
0x0000001017437824ULL, 0x000fe400078e023cULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001d36107210ULL, 0x000fc60007f1e0ffULL, 0x0000001019377824ULL, 0x100fe200078e023cULL,
0x00000053161f7212ULL, 0x000fe200078efcffULL, 0x000000101b347824ULL, 0x000fe400078e023cULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x00000053181d7212ULL, 0x000fc600078efcffULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x0000001d36187210ULL, 0x000fc60007f5e0ffULL, 0x0000000111117824ULL, 0x000fe200000e0651ULL,
0x0000001f36167210ULL, 0x000fe20007f1e0ffULL, 0x0000001021037824ULL, 0x000fe200078e023cULL,
0x000000531a1f7212ULL, 0x080fe200078efcffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000005312217212ULL, 0x000fc600078efcffULL, 0x0000000117177824ULL, 0x000fe200000e0651ULL,
0x0000001f361a7210ULL, 0x000fe20007f1e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000002136127210ULL, 0x000fe40007f3e0ffULL, 0x0000005322257212ULL, 0x080fe200078efcffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000531c2b7212ULL, 0x080fe400078efcffULL,
0x0000002536227210ULL, 0x000fe20007f7e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000531e297212ULL, 0x000fc600078efcffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000005320277212ULL, 0x000fc600078efcffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x00000053245f7212ULL, 0x000fc600078efcffULL, 0x000000011b1b7824ULL, 0x000fe200000e0651ULL,
0x0000002b361c7210ULL, 0x000fe20007f1e0ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x00000053305d7212ULL, 0x000fc600078efcffULL, 0x0000000113137824ULL, 0x000fe200008e0651ULL,
0x00000029361e7210ULL, 0x000fe20007f3e0ffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x000000532e5b7212ULL, 0x000fc600078efcffULL, 0x0000000119197824ULL, 0x000fe200010e0651ULL,
0x0000002736207210ULL, 0x000fe20007f5e0ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x000000532c597212ULL, 0x000fc600078efcffULL, 0x000000104f4f7824ULL, 0x000fe200078e023cULL,
0x000000532a577212ULL, 0x000fe200078efcffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000104f7faeULL, 0x0003e2000b901c48ULL,
0x000000104d4d7824ULL, 0x100fe200078e023cULL, 0x0000005328557212ULL, 0x080fe200078efcffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x00000057362a7210ULL, 0x000fe40007f9e0ffULL,
0x00000000124d7faeULL, 0x0003e2000b901c48ULL, 0x000000104b4b7824ULL, 0x100fe200078e023cULL,
0x0000005326537212ULL, 0x000fe200078efcffULL, 0x0000001049497824ULL, 0x100fe200078e023cULL,
0x0000005536287210ULL, 0x000fe20007fbe0ffULL, 0x000000011d1d7824ULL, 0x100fe200000e0651ULL,
0x0000005f36247210ULL, 0x000fe20007f1e0ffULL, 0x0000001047477824ULL, 0x100fe200078e023cULL,
0x00000000164b7faeULL, 0x0003e2000b901c48ULL, 0x000000011f1f7824ULL, 0x100fe200008e0651ULL,
0x0000005d36307210ULL, 0x000fe20007f3e0ffULL, 0x0000001045457824ULL, 0x100fe200078e023cULL,
0x0000000018497faeULL, 0x0003e2000b901c48ULL, 0x0000000121217824ULL, 0x100fe200010e0651ULL,
0x0000005b362e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000123237824ULL, 0x100fe200018e0651ULL,
0x00000059362c7210ULL, 0x000fe20007f7e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e023cULL,
0x000000001a477faeULL, 0x0003e2000b901c48ULL, 0x000000103d3d7824ULL, 0x100fe200078e023cULL,
0x0000005336267210ULL, 0x000fe20007fde0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e023cULL,
0x000000001c457faeULL, 0x0003e2000b901c48ULL, 0x0000000125257824ULL, 0x000fc400000e0651ULL,
0x0000000131317824ULL, 0x100fe200008e0651ULL, 0x000000001e437faeULL, 0x0003e2000b901c48ULL,
0x0000001035357824ULL, 0x100fe400078e023cULL, 0x000000012f2f7824ULL, 0x100fe200010e0651ULL,
0x00000000203f7faeULL, 0x0003e2000b901c48ULL, 0x000000012d2d7824ULL, 0x100fe400018e0651ULL,
0x0000001033337824ULL, 0x000fe200078e023cULL, 0x00000000223d7faeULL, 0x0003e2000b901c48ULL,
0x000000012b2b7824ULL, 0x000fc400020e0651ULL, 0x0000000129297824ULL, 0x100fe200028e0651ULL,
0x00000000243b7faeULL, 0x0003e2000b901c48ULL, 0x0000000127277824ULL, 0x000fc600030e0651ULL,
0x0000000030377faeULL, 0x0003e8000b901c48ULL, 0x000000002e357faeULL, 0x0003e8000b901c48ULL,
0x000000002c347faeULL, 0x0003e8000b901c48ULL, 0x000000002a337faeULL, 0x0003e8000b901c48ULL,
0x0000000028327faeULL, 0x0003e8000b901c48ULL, 0x0000000026037faeULL, 0x0003e4000b901c48ULL,
0x0000000204047836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff037424ULL, 0x002fc600078e00ffULL, 0x000000390400720cULL, 0x000fda0003f06070ULL,
0x00009000ff108b82ULL, 0x000e620000000a00ULL, 0x0000000207138824ULL, 0x000fe400078e0204ULL,
0x0000002005127836ULL, 0x000fe20000000000ULL, 0xfffffff805447812ULL, 0x040fe200078ec0ffULL,
0x0000200014437824ULL, 0x000fe200078e0215ULL, 0x0000000705427812ULL, 0x000fe200078ec0ffULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x00000004ff407819ULL, 0x000fe40000011605ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000000413108825ULL, 0x002fe200078e0010ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000810038981ULL, 0x000322000c1e1900ULL, 0x0000100043437836ULL, 0x000fe20000000000ULL,
0x0000000744447812ULL, 0x000fe400078ef805ULL, 0x0000000842457812ULL, 0x000fe400078ef805ULL,
0xfffffff812107812ULL, 0x002fc800078ec0ffULL, 0x00000007103b7812ULL, 0x000fce00078ef805ULL,
0x0000000144107824ULL, 0x140fe400078e0247ULL, 0x0000000844117824ULL, 0x000fe400078e00ffULL,
0x000000013b147824ULL, 0x040fe400078e0247ULL, 0x000000083b157824ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe200078ee210ULL, 0x0000000247607824ULL, 0x000fc600078e0240ULL,
0xfffffff815147812ULL, 0x000fe200078ee214ULL, 0x0000001010107824ULL, 0x000fc800078e0243ULL,
0x0000001014147824ULL, 0x000fe400078e0243ULL, 0x000000001010783bULL, 0x000e680000000200ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00000018ff567819ULL, 0x002fe20000011410ULL,
0x00010000101c7824ULL, 0x040fe200078e00ffULL, 0x00008880105a7816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011411ULL,
0x00010000111d7824ULL, 0x040fe200078e00ffULL, 0x00008880115d7816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005600567306ULL, 0x000fe20000202400ULL, 0x00000018ff657819ULL, 0x000fc40000011412ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880125e7816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x00000010005f7306ULL, 0x0002e20000202400ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff687819ULL, 0x004fe40000011414ULL,
0x00008880146c7816ULL, 0x000fc400000000ffULL, 0x00000018ff647819ULL, 0x000fe20000011415ULL,
0x00000011005c7306ULL, 0x0005e20000202400ULL, 0x0001000012107824ULL, 0x042fe200078e00ffULL,
0x00008880156a7816ULL, 0x000fe200000000ffULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011413ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000013117824ULL, 0x044fe200078e00ffULL,
0x0000001c00797306ULL, 0x0003e20000202400ULL, 0x0000888013707816ULL, 0x040fe200000000ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011416ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff467819ULL, 0x000fe20000011417ULL,
0x0000001200727306ULL, 0x0005e20000202400ULL, 0x00000008441c7824ULL, 0x002fe200078e00ffULL,
0x0000888016667816ULL, 0x000fe400000000ffULL, 0x0000888017627816ULL, 0x000fe400000000ffULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000001100757306ULL, 0x0003e20000202400ULL,
0x0000000147127836ULL, 0x004fc40000000000ULL, 0x0000000247477836ULL, 0x000fca0000000000ULL,
0x0000001d00747306ULL, 0x0005e20000202400ULL, 0x0000000144117824ULL, 0x102fe200078e0212ULL,
0x000000084700780cULL, 0x000fe20003f05270ULL, 0x000000013b127824ULL, 0x000fc600078e0212ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL, 0x0001000015117824ULL, 0x040fe200078e00ffULL,
0x0000001000777306ULL, 0x0003e20000202400ULL, 0x0000010015157824ULL, 0x000fe400078e00ffULL,
0x000000101c1c7824ULL, 0x000fe200078e0243ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000013006e7306ULL, 0x000be20000202400ULL,
0x000000001c1c783bULL, 0x004ea20000000200ULL, 0x0001000014107824ULL, 0x002fc400078e00ffULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x00000015006d7306ULL, 0x0003e20000202400ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x000000083b137824ULL, 0x020fca00078e00ffULL, 0xfffffff813127812ULL, 0x000fe200078ee212ULL,
0x0000001400717306ULL, 0x000be20000202400ULL, 0x0000001045157824ULL, 0x002fc600078e00ffULL,
0x0000001012127824ULL, 0x000fc800078e0243ULL, 0x0000001000737306ULL, 0x0003e20000202400ULL,
0x0001000017147824ULL, 0x060fe400078e00ffULL, 0x0000010017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0001000016107824ULL, 0x042fe200078e00ffULL, 0x0000001400637306ULL, 0x0005e20000202400ULL,
0x0000010016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011410ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000001700617306ULL, 0x000fe20000202400ULL,
0x000100001c147824ULL, 0x044fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe4000001141cULL,
0x000088801c4a7816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011414ULL, 0x0000000145147824ULL, 0x000fe200078e0260ULL,
0x0000001600697306ULL, 0x0003e20000202400ULL, 0x00000018ff507819ULL, 0x000fc4000001141dULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0xfffffff015147812ULL, 0x000fe200078ee214ULL,
0x000100001d157824ULL, 0x040fe200078e00ffULL, 0x000088801d527816ULL, 0x040fe200000000ffULL,
0x00000011006f7306ULL, 0x0005e20000202400ULL, 0x0000000a14147c11ULL, 0x000fe2000f8e20ffULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011415ULL,
0x00000018ff4f7819ULL, 0x000fc4000001141eULL, 0x000000001414783bULL, 0x002fe20000000200ULL,
0x0000005a005a7306ULL, 0x000e620000202400ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x000000001210783bULL, 0x004ea20000000200ULL, 0x000088801e547816ULL, 0x040fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001141fULL, 0x0000001c00537306ULL, 0x000bf00000202400ULL,
0x0000001d00557306ULL, 0x0007e20000202400ULL, 0x000100001e1c7824ULL, 0x020fc400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x000054105f1d7816ULL, 0x008fe40000000056ULL,
0x00000018ff1e7819ULL, 0x000fca000001141eULL, 0x0000001c00597306ULL, 0x0003f00000202400ULL,
0x0000005d005d7306ULL, 0x000ee20000202400ULL, 0x000054105a1c7816ULL, 0x002fe40000000079ULL,
0x00000018ff4d7819ULL, 0x004fc40000011410ULL, 0x000088801f5a7816ULL, 0x000fe400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011411ULL, 0x0000001c143c723cULL, 0x000fe2000004183cULL,
0x0000006500657306ULL, 0x000e620000202400ULL, 0x00000018ff4b7819ULL, 0x000fe40000011412ULL,
0x00000018ff497819ULL, 0x000fc60000011413ULL, 0x000100001f1d7824ULL, 0x000fe200078e00ffULL,
0x000054105d1c7816ULL, 0x008fe20000000074ULL, 0x0000005e005e7306ULL, 0x000ea20000202400ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888011747816ULL, 0x000fe400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001d005f7306ULL, 0x0007f00000202400ULL, 0x0000001e00567306ULL, 0x000be20000202400ULL,
0x000054105c1d7816ULL, 0x008fe2000000005bULL, 0x00010000105c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000001c1434723cULL, 0x000fe20000041834ULL,
0x00008880101e7816ULL, 0x060fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x0000006700677306ULL, 0x000ee80000202400ULL, 0x00000018ff1c7819ULL, 0x000fe20000011410ULL,
0x00000010451d7824ULL, 0x040fe200078e00ffULL, 0x0000000245107810ULL, 0x000fc40007ffe060ULL,
0x0000007000707306ULL, 0x000f640000202400ULL, 0xfffffff01d107812ULL, 0x000fe400078ee210ULL,
0x00005410721d7816ULL, 0x002fe20000000065ULL, 0x0000010011727824ULL, 0x000fe200078e00ffULL,
0x0000000a10107c11ULL, 0x000fe4000f8e20ffULL, 0x0000001c00607306ULL, 0x0005f00000202400ULL,
0x0000001e005b7306ULL, 0x0003e20000202400ULL, 0x000054105e1c7816ULL, 0x004fce0000000077ULL,
0x0000006c006c7306ULL, 0x000ea20000202400ULL, 0x00010000111e7824ULL, 0x002fe200078e00ffULL,
0x0000001c1430723cULL, 0x000fe20000041830ULL, 0x000054106e117816ULL, 0x008fe20000000067ULL,
0x00010000126e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011472ULL,
0x00000018ff657819ULL, 0x000fe2000001141eULL, 0x0000001f005d7306ULL, 0x0003f00000202400ULL,
0x0000006800687306ULL, 0x000ee20000202400ULL, 0x00000000101c783bULL, 0x002a6e0000000200ULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x0000541070107816ULL, 0x020fce0000000075ULL,
0x0000006a006a7306ULL, 0x000f620000202400ULL, 0x00000010142c723cULL, 0x000fee000004182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x000054106c107816ULL, 0x004fe20000000073ULL, 0x0000010012127824ULL, 0x000fc400078e00ffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0011ULL, 0x0000541071117816ULL, 0x008fe40000000068ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000006600667306ULL, 0x000fe80000202400ULL,
0x000000101428723cULL, 0x000fe80000041828ULL, 0x0000006b006b7306ULL, 0x000ea60000202400ULL,
0x000054106a107816ULL, 0x020fc4000000006fULL, 0x000054106d117816ULL, 0x000fe40000000064ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146eULL, 0x0000004600467306ULL, 0x000fe80000202400ULL,
0x000000101424723cULL, 0x000fe80000041824ULL, 0x0000006200627306ULL, 0x000ee60000202400ULL,
0x0000541066107816ULL, 0x004fc4000000006bULL, 0x0000541069117816ULL, 0x000fe40000000058ULL,
0x0000888013587816ULL, 0x000fe200000000ffULL, 0x0000004800487306ULL, 0x000fe80000202400ULL,
0x000000101420723cULL, 0x000fe80000041820ULL, 0x0000004a004a7306ULL, 0x000fe60000202400ULL,
0x0000541062107816ULL, 0x008fc40000000063ULL, 0x0000541061117816ULL, 0x000fe20000000046ULL,
0x000000ffff467224ULL, 0x000fe400078e0058ULL, 0x0000005100517306ULL, 0x000ea80000202400ULL,
0x000000101418723cULL, 0x000fe80000041818ULL, 0x0000005000507306ULL, 0x000ee60000202400ULL,
0x0001000013117824ULL, 0x000fc400078e00ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x000054104a107816ULL, 0x004fe40000000051ULL, 0x0000004e004e7306ULL, 0x000ea20000202400ULL,
0x00000018ff157819ULL, 0x000fe40000011411ULL, 0x0000541053117816ULL, 0x000fe40000000048ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000541055537816ULL, 0x008fe20000000050ULL,
0x0000005a005a7306ULL, 0x000ee40000202400ULL, 0x000000101c3c723cULL, 0x002fe2000004183cULL,
0x000054105d177816ULL, 0x004fca000000004eULL, 0x0000004f004f7306ULL, 0x000e620000202400ULL,
0x000054105a167816ULL, 0x008fce000000005fULL, 0x0000004d004d7306ULL, 0x000ea20000202400ULL,
0x000000161c2c723cULL, 0x000fe2000004182cULL, 0x0000541056557816ULL, 0x002fcc000000004fULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x00005410605d7816ULL, 0x004fce000000004dULL,
0x0000004b004b7306ULL, 0x000ff00000202400ULL, 0x0000004900497306ULL, 0x000ff00000202400ULL,
0x0000005200527306ULL, 0x000ff00000202400ULL, 0x0000005700577306ULL, 0x000e700000202400ULL,
0x0000005400547306ULL, 0x000ea20000202400ULL, 0x0000541052527816ULL, 0x002fce0000000057ULL,
0x0000005c005c7306ULL, 0x000e620000202400ULL, 0x000000521c34723cULL, 0x000fe20000041834ULL,
0x0000541054547816ULL, 0x004fcc0000000059ULL, 0x00000074005e7306ULL, 0x000fe20000202400ULL,
0x000000541c30723cULL, 0x000fe20000041830ULL, 0x000054105b5c7816ULL, 0x002fcc000000005cULL,
0x0000006500657306ULL, 0x000e620000202400ULL, 0x0000005c1c28723cULL, 0x000fee0000041828ULL,
0x0000006700677306ULL, 0x000ea20000202400ULL, 0x000054105e5e7816ULL, 0x002fce0000000065ULL,
0x0000006c00687306ULL, 0x000fe20000202400ULL, 0x00005410675f7816ULL, 0x004fce000000004cULL,
0x0000006d006d7306ULL, 0x000e620000202400ULL, 0x0000005e1c24723cULL, 0x000fee0000041824ULL,
0x0000001200127306ULL, 0x000ea20000202400ULL, 0x00005410684a7816ULL, 0x002fce000000006dULL,
0x0000004600147306ULL, 0x000fe20000202400ULL, 0x00005410124b7816ULL, 0x004fce000000004bULL,
0x0000001500117306ULL, 0x000e620000202400ULL, 0x0000004a1c20723cULL, 0x000fee0000041820ULL,
0x0000001300107306ULL, 0x000ea20000202400ULL, 0x0000541014147816ULL, 0x002fe40000000011ULL,
0x0000541010157816ULL, 0x004fce0000000049ULL, 0x000000141c18723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff000280947ULL, 0x000fde000383ffffULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000083c177220ULL, 0x080fe20000410000ULL,
0x0000000824167220ULL, 0x080fe20000410000ULL, 0x00000008213c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x000000083e3e7220ULL, 0x080fe20000410000ULL,
0x01768810091079a7ULL, 0x000262000850003fULL, 0x000000083f3f7220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000836367220ULL, 0x080fe20000410000ULL, 0x0000000837377220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000832327220ULL, 0x080fe20000410000ULL, 0x0000000833337220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x000000082e2e7220ULL, 0x080fe20000410000ULL, 0x000000082f2f7220ULL, 0x080fe20000410000ULL,
0x0000000828287220ULL, 0x080fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000082a2a7220ULL, 0x080fe20000410000ULL, 0x000000082b2b7220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000826267220ULL, 0x080fe20000410000ULL,
0x0000000827277220ULL, 0x080fe20000410000ULL, 0x00000008203b7220ULL, 0x080fe20000410000ULL,
0x0000000822227220ULL, 0x080fe20000410000ULL, 0x0000000823237220ULL, 0x080fe20000410000ULL,
0x0000000818407220ULL, 0x080fe20000410000ULL, 0x0000000819437220ULL, 0x080fe20000410000ULL,
0x000000081a217220ULL, 0x080fe20000410000ULL, 0x000000081b247220ULL, 0x002fce0000410000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x01768811090075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001412197210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x01768811090075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000405107824ULL, 0x000fe200078e00ffULL, 0x0000000a3a117c11ULL, 0x000fe4000f8e38ffULL,
0x0000000c0b00720cULL, 0x000fe40003f06070ULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x0000000111207824ULL, 0x000fca00078e0210ULL, 0x0174000020107984ULL, 0x0002a20000000c00ULL,
0x0000001000c48947ULL, 0x000fea0003800000ULL, 0xffffff000f0f7836ULL, 0x000fe20000000000ULL,
0x0000000005187211ULL, 0x040fe200078ff0ffULL, 0x0000000205447824ULL, 0x000fe200078e00ffULL,
0x0000860000077ab9ULL, 0x000fe20000000800ULL, 0x00008400000b7ab9ULL, 0x000fe20000000800ULL,
0x0000000f38147248ULL, 0x000fe40007fe0000ULL, 0x0000000644447812ULL, 0x000fe400078ec0ffULL,
0x00000007ff197c19ULL, 0x000fe20008011618ULL, 0x00000001140f7824ULL, 0x000fc400078e0a0fULL,
0x00008c00ff147b82ULL, 0x000ee20000000a00ULL, 0x00000006441a7c36ULL, 0x000fe20008000000ULL,
0x0000000519197c48ULL, 0x000fe2000bfe0000ULL, 0x000000ffff557224ULL, 0x000fe400078e0a0fULL,
0x0000000b44467c36ULL, 0x000fe20008000000ULL, 0x0000000f1a00720cULL, 0x080fe20003f26070ULL,
0x0000000818187836ULL, 0x000fe20000000000ULL, 0x000000051a1a7e46ULL, 0x000fe2000b800055ULL,
0x00000004195e7c24ULL, 0x000fe2000f8e02ffULL, 0x0000000f4600720cULL, 0x000fc40003f06070ULL,
0x0000000546517e46ULL, 0x000fe4000b800055ULL, 0x00000004ff1a7819ULL, 0x000fe4000001161aULL,
0x000000ff51517207ULL, 0x000fe40000000000ULL, 0x000000ff1a197207ULL, 0x000fe40000800000ULL,
0x00000007ff187c19ULL, 0x000fe40008011618ULL, 0x0000005e511f7211ULL, 0x000fe200078fe0ffULL,
0x000000015e1d7824ULL, 0x000fe200078e0219ULL, 0x0000000518187c48ULL, 0x000fc4000bfe0000ULL,
0x00000010444a7812ULL, 0x000fe200078efcffULL, 0x000000021f1e7825ULL, 0x008fc800078e0014ULL,
0x000000021d1c7825ULL, 0x000fe200078e0014ULL, 0x000000081e577981ULL, 0x0044e6000c1e9500ULL,
0x0000000418607c24ULL, 0x000fe2000f8e02ffULL, 0x000000081c5c7981ULL, 0x000ae2000c1e9500ULL,
0x0000000b4a487c36ULL, 0x000fe40008000000ULL, 0x0000000119197824ULL, 0x000fe200078e0260ULL,
0x00000060511b7211ULL, 0x000fe200078fe0ffULL, 0x000000064a1e7c36ULL, 0x004fe20008000000ULL,
0x0000000f4800720cULL, 0x000fe20003f06070ULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x0000000548457e46ULL, 0x000fc4000b800055ULL, 0x00000020444e7812ULL, 0x000fe200078efcffULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x000000ff45457207ULL, 0x000fe20000000000ULL,
0x00000008185a7981ULL, 0x0004e2000c1e9500ULL, 0x000000051e1c7e46ULL, 0x022fe2000b800055ULL,
0x0000000b4e507c36ULL, 0x000fe20008000000ULL, 0x0000000f1e00720cULL, 0x080fe20003f26070ULL,
0x000000081a537981ULL, 0x000362000c1e9500ULL, 0x00000004ff1c7819ULL, 0x000fe2000001161cULL,
0x000000064e547c36ULL, 0x000fe20008000000ULL, 0x0000000f5000720cULL, 0x000fc40003f06070ULL,
0x0000005e45197211ULL, 0x004fe400078fe0ffULL, 0x00000005504b7e46ULL, 0x000fe4000b800055ULL,
0x000000ff1c1d7207ULL, 0x000fe20000800000ULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x000000ff4b4b7207ULL, 0x000fe40000000000ULL, 0x00000060451f7211ULL, 0x000fe200078fe0ffULL,
0x000000015e1b7824ULL, 0x002fe200078e021dULL, 0x00000005544d7e46ULL, 0x000fe2000b800055ULL,
0x0000000818477981ULL, 0x0002a2000c1e9500ULL, 0x000000011d497824ULL, 0x000fe200078e0260ULL,
0x0000000f5400720cULL, 0x000fe20003f26070ULL, 0x000000021f1c7825ULL, 0x000fe200078e0014ULL,
0x0000003044547812ULL, 0x000fc400078efcffULL, 0x00000004ff4d7819ULL, 0x000fe2000001164dULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x0000005e4b197211ULL, 0x002fc600078fe0ffULL,
0x00000002491e7825ULL, 0x100fe200078e0014ULL, 0x000000ff4d4f7207ULL, 0x000fe20000800000ULL,
0x000000081a4c7981ULL, 0x0002a4000c1e9500ULL, 0x0000000219187825ULL, 0x000fe400078e0014ULL,
0x000000081c497981ULL, 0x0002a4000c1e9500ULL, 0x0000000654627c36ULL, 0x000fe40008000000ULL,
0x000000081e527981ULL, 0x0002a2000c1e9500ULL, 0x0000000b54567c36ULL, 0x000fc60008000000ULL,
0x00000008184d7981ULL, 0x0002a4000c1e9500ULL, 0x000000015e1b7824ULL, 0x002fe200078e024fULL,
0x000000604b1d7211ULL, 0x000fe200078fe0ffULL, 0x000000014f1f7824ULL, 0x000fe200078e0260ULL,
0x0000000562187e46ULL, 0x000fc6000b800055ULL, 0x000000021f1e7825ULL, 0x100fe200078e0014ULL,
0x0000000f5600720cULL, 0x080fe40003f06070ULL, 0x0000000556557e46ULL, 0x000fe2000b800055ULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x0000000f6200720cULL, 0x000fe20003f26070ULL,
0x000000081e1e7981ULL, 0x000ea2000c1e9500ULL, 0x00000004ff187819ULL, 0x000fe20000011618ULL,
0x000000021d1c7825ULL, 0x000fe200078e0014ULL, 0x000000ff55557207ULL, 0x000fe20000000000ULL,
0x000000081a587981ULL, 0x0002a2000c1e9500ULL, 0x000000ff18597207ULL, 0x000fc60000800000ULL,
0x000000081c4f7981ULL, 0x0002a2000c1e9500ULL, 0x0000005e55197211ULL, 0x000fe200078fe0ffULL,
0x000000015e1b7824ULL, 0x002fc800078e0259ULL, 0x0000000219187825ULL, 0x000fc800078e0014ULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x00000060551d7211ULL, 0x000fe200078fe0ffULL,
0x0000000818187981ULL, 0x0002a8000c1e9500ULL, 0x000000081a1b7981ULL, 0x0002a2000c1e9500ULL,
0x0000000159597824ULL, 0x000fe400078e0260ULL, 0x000000021d1c7825ULL, 0x000fc800078e0014ULL,
0x0000000259147825ULL, 0x000fe400078e0014ULL, 0x000000081c1c7981ULL, 0x000ea8000c1e9500ULL,
0x0000000814157981ULL, 0x0002a2000c1e9500ULL, 0xfffffff0515e7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff1f7424ULL, 0x000fc800078e00ffULL, 0x000000010f197824ULL, 0x002fc800078e025eULL,
0x0000000146647824ULL, 0x100fe200078e0a19ULL, 0x0000000844627812ULL, 0x040fe400078efcffULL,
0x0000000944607812ULL, 0x000fe400078efcffULL, 0x000000641f647219ULL, 0x000fe200000006ffULL,
0x0000000b621a7c36ULL, 0x000fe40008000000ULL, 0x0000000b60147c36ULL, 0x000fe40008000000ULL,
0x000000011a687824ULL, 0x000fc400078e0a19ULL, 0x00000001146a7824ULL, 0x000fe200078e0a19ULL,
0x00000018447a7812ULL, 0x040fe400078efcffULL, 0x000000681f687219ULL, 0x040fe400000006ffULL,
0x0000006a1f6a7219ULL, 0x000fe400000006ffULL, 0xfffffff045457812ULL, 0x000fe200078ec0ffULL,
0x0000000b7a1d7c36ULL, 0x000fe20008000000ULL, 0x00000011447c7812ULL, 0x040fe400078efcffULL,
0x0000001944787812ULL, 0x000fc400078efcffULL, 0xfffffff055557812ULL, 0x000fe200078ec0ffULL,
0x0000000b7c517c36ULL, 0x000fc80008000000ULL, 0x000000010f637824ULL, 0x000fe200078e0255ULL,
0x00000021446e7812ULL, 0x040fe400078efcffULL, 0x00000028446c7812ULL, 0x000fc600078efcffULL,
0x0000000b6e747c36ULL, 0x000fe40008000000ULL, 0x0000000b6c727c36ULL, 0x000fe40008000000ULL,
0x0000000156657824ULL, 0x000fca00078e0a63ULL, 0x000000651f657219ULL, 0x000fe400000006ffULL,
0x0000541057577816ULL, 0x008fe4000000005cULL, 0x00000001445c7812ULL, 0x000fe400078efcffULL,
0x0000005764ff7212ULL, 0x000fc6000780c0ffULL, 0x0000000b5c5e7c36ULL, 0x000fe20008000000ULL,
0x0000000f4600720cULL, 0x000fc60000701470ULL, 0x000000015e667824ULL, 0x000fe200078e0a19ULL,
0x0000000f4400720cULL, 0x000fc800007a1070ULL, 0x000000661f667219ULL, 0x000fe400000006ffULL,
0x0000541053537816ULL, 0x020fe4000000005aULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0x0000005364ff7212ULL, 0x080fe4000784c0ffULL, 0x0000005366ff7212ULL, 0x080fe4000780c0ffULL,
0x0000005368ff7212ULL, 0x000fc400078cc0ffULL, 0x000000536aff7212ULL, 0x000fe400078ac0ffULL,
0xfffffff04b537812ULL, 0x000fe200078ec0ffULL, 0x000000010f4b7824ULL, 0x040fe200078e0245ULL,
0x0000005766ff7212ULL, 0x080fe2000782c0ffULL, 0x0000000b78197c36ULL, 0x000fe20008000000ULL,
0x0000005768ff7212ULL, 0x080fe2000786c0ffULL, 0x000000010f5b7824ULL, 0x000fe200078e0253ULL,
0x000000576aff7212ULL, 0x000fe2000788c0ffULL, 0x0000000148537824ULL, 0x100fe200078e0a4bULL,
0x0000000f4600720cULL, 0x080fe20001741470ULL, 0x000000011d577824ULL, 0x000fe200078e0a4bULL,
0x0000000f1a00720cULL, 0x000fc400037c1470ULL, 0x0000000f1400720cULL, 0x080fe20002fa1470ULL,
0x0000000151557824ULL, 0x100fe200078e0a4bULL, 0x0000000f4400720cULL, 0x080fe20001741070ULL,
0x0000000119597824ULL, 0x000fe200078e0a4bULL, 0x0000000f6200720cULL, 0x080fe400037c1070ULL,
0x0000000f6000720cULL, 0x000fe40002fa1070ULL, 0x000000531f4b7219ULL, 0x040fe400000006ffULL,
0x000000571f577219ULL, 0x000fc400000006ffULL, 0x00005410474c7816ULL, 0x004fe4000000004cULL,
0x0000541049527816ULL, 0x000fe40000000052ULL, 0xff8000003e3e7808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40003000000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0x0000004c4bff7212ULL, 0x000fc4000784c0ffULL, 0x000000524bff7212ULL, 0x080fe400078cc0ffULL,
0x0000005257ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001505d7824ULL, 0x000fe200078e0a5bULL,
0x0000000f5e00720cULL, 0x0c0fe40000f21470ULL, 0x0000000f5e00720cULL, 0x080fe40000701470ULL,
0x0000000f1a00720cULL, 0x080fe40001f61470ULL, 0x0000000f1400720cULL, 0x000fc40002781470ULL,
0x0000000f4800720cULL, 0x0c0fe40001741470ULL, 0x0000000f4800720cULL, 0x080fe400037c1470ULL,
0x0000000f1d00720cULL, 0x080fe40002fa1470ULL, 0x00000029446a7812ULL, 0x000fe400078efcffULL,
0x0000000f5c00720cULL, 0x0c0fe40000f21070ULL, 0x0000000f5c00720cULL, 0x000fc40000701070ULL,
0x0000000f6200720cULL, 0x080fe40001f61070ULL, 0x0000000f6000720cULL, 0x080fe40002781070ULL,
0x0000000f4a00720cULL, 0x0c0fe40001741070ULL, 0x0000000f4a00720cULL, 0x080fe400037c1070ULL,
0x0000000f7a00720cULL, 0x000fe40002fa1070ULL, 0x000000551f537219ULL, 0x000fc400000006ffULL,
0x000000591f597219ULL, 0x040fe400000006ffULL, 0x0000005d1f5d7219ULL, 0x000fe400000006ffULL,
0x000054104d4d7816ULL, 0x000fe40000000058ULL, 0x000054104f1e7816ULL, 0x000fe2000000001eULL,
0x0000000b6a707c36ULL, 0x000fe20008000000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000003f3f7808ULL, 0x000fc40000000000ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0x0000004c53ff7212ULL, 0x000fc4000782c0ffULL, 0x0000004c57ff7212ULL, 0x080fe4000780c0ffULL,
0x0000004c59ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005253ff7212ULL, 0x080fe4000788c0ffULL,
0x0000005259ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004d5dff7212ULL, 0x040fe400078cc0ffULL,
0x0000001e5dff7212ULL, 0x000fe200078ac0ffULL, 0x00000001745f7824ULL, 0x100fe200078e0a5bULL,
0x0000000f5100720cULL, 0x0c0fe20000f21470ULL, 0x0000000172617824ULL, 0x100fe200078e0a5bULL,
0x0000000f5100720cULL, 0x080fe20002781470ULL, 0x00000001705b7824ULL, 0x000fe200078e0a5bULL,
0x0000000f1d00720cULL, 0x000fc40000701470ULL, 0x0000000f1900720cULL, 0x0c0fe40001f61470ULL,
0x0000000f1900720cULL, 0x080fe40001741470ULL, 0x0000000f5000720cULL, 0x0c0fe400037c1470ULL,
0x0000000f5000720cULL, 0x000fe40002fa1470ULL, 0x0000003144667812ULL, 0x040fe400078efcffULL,
0x0000003844647812ULL, 0x000fc400078efcffULL, 0x00000039445a7812ULL, 0x000fe400078efcffULL,
0x0000000f7c00720cULL, 0x0c0fe40000f21070ULL, 0x0000000f7c00720cULL, 0x080fe40002781070ULL,
0x0000000f7a00720cULL, 0x080fe40000701070ULL, 0x0000000f7800720cULL, 0x0c0fe40001f61070ULL,
0x0000000f7800720cULL, 0x000fc40001741070ULL, 0x0000000f4e00720cULL, 0x0c0fe400037c1070ULL,
0x0000000f4e00720cULL, 0x000fe40002fa1070ULL, 0x0000005f1f5f7219ULL, 0x040fe400000006ffULL,
0x000000611f617219ULL, 0x040fe400000006ffULL, 0x0000005b1f5b7219ULL, 0x000fe400000006ffULL,
0x0000541018187816ULL, 0x000fe2000000001bULL, 0x0000000b66687c36ULL, 0x000fe20008000000ULL,
0xff80000031317808ULL, 0x000fe20000800000ULL, 0x0000000b64767c36ULL, 0x000fe20008000000ULL,
0xff80000033337808ULL, 0x000fe20002000000ULL, 0x0000000b5a457c36ULL, 0x000fe20008000000ULL,
0xff8000002c2c7808ULL, 0x000fc40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x0000004d5fff7212ULL, 0x080fe4000782c0ffULL,
0x0000004d61ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004d5bff7212ULL, 0x000fe4000780c0ffULL,
0x0000001e5fff7212ULL, 0x080fe4000786c0ffULL, 0x0000001e61ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001e5bff7212ULL, 0x000fe400078cc0ffULL, 0x0000001865ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000168677824ULL, 0x100fe200078e0a63ULL, 0x0000000f7400720cULL, 0x080fe20000f21470ULL,
0x0000000176697824ULL, 0x100fe200078e0a63ULL, 0x0000000f7400720cULL, 0x080fe20001f61470ULL,
0x0000000145637824ULL, 0x000fe200078e0a63ULL, 0x0000000f7200720cULL, 0x000fc40002781470ULL,
0x0000000f7200720cULL, 0x080fe40001741470ULL, 0x0000000f7000720cULL, 0x0c0fe40000701470ULL,
0x0000000f7000720cULL, 0x080fe400037c1470ULL, 0x0000000f5600720cULL, 0x080fe40002fa1470ULL,
0x0000000f6e00720cULL, 0x0c0fe40000f21070ULL, 0x0000000f6e00720cULL, 0x000fc40001f61070ULL,
0x0000000f6c00720cULL, 0x0c0fe40002781070ULL, 0x0000000f6c00720cULL, 0x080fe40001741070ULL,
0x0000000f6a00720cULL, 0x0c0fe40000701070ULL, 0x0000000f6a00720cULL, 0x080fe400037c1070ULL,
0x0000000f5400720cULL, 0x000fe40002fa1070ULL, 0x000000671f677219ULL, 0x000fc400000006ffULL,
0x000000691f697219ULL, 0x040fe400000006ffULL, 0x000000631f637219ULL, 0x000fe400000006ffULL,
0x000054101c1c7816ULL, 0x000fe40000000015ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000016167808ULL, 0x000fc40002000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40003000000ULL, 0xff8000003b3b7808ULL, 0x000fe40002800000ULL,
0x0000001867ff7212ULL, 0x080fe4000782c0ffULL, 0x0000001869ff7212ULL, 0x000fc4000786c0ffULL,
0x0000001863ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001c65ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001c67ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001c69ff7212ULL, 0x080fe400078cc0ffULL,
0x0000001c63ff7212ULL, 0x000fe400078ac0ffULL, 0x0000000f5600720cULL, 0x000fc40001741470ULL,
0x0000000f6800720cULL, 0x0c0fe40000f21470ULL, 0x0000000f6800720cULL, 0x080fe40000701470ULL,
0x0000000f7600720cULL, 0x0c0fe40001f61470ULL, 0x0000000f7600720cULL, 0x080fe400037c1470ULL,
0x0000000f4500720cULL, 0x0c0fe40002781470ULL, 0x0000000f4500720cULL, 0x000fc40002fa1470ULL,
0x0000000f5400720cULL, 0x080fe40001741070ULL, 0x0000000f6600720cULL, 0x0c0fe40000f21070ULL,
0x0000000f6600720cULL, 0x080fe40000701070ULL, 0x0000000f6400720cULL, 0x0c0fe40001f61070ULL,
0x0000000f6400720cULL, 0x080fe400037c1070ULL, 0x0000000f5a00720cULL, 0x000fc40002781070ULL,
0x0000000f5a00720cULL, 0x000fe40002fa1070ULL, 0xff8000003c3c7808ULL, 0x000fe40000800000ULL,
0xff80000040407808ULL, 0x000fe40001800000ULL, 0xff80000043437808ULL, 0x000fe40002000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fc40000000000ULL,
0xff80000021217808ULL, 0x000fe40003000000ULL, 0xff80000024247808ULL, 0x000fce0002800000ULL,
0x000000171000720bULL, 0x004fe20003f1e000ULL, 0x3f80000000077882ULL, 0x000fe20000000000ULL,
0xfffffff8ff427812ULL, 0x000fe200078ee242ULL, 0x000000010b0b7836ULL, 0x000fe20000000000ULL,
0x0000001017107208ULL, 0x000fc80004000000ULL, 0x0000003d1000720bULL, 0x000fc80003f1e000ULL,
0x000000103d0f7208ULL, 0x000fc80004000000ULL, 0x000000340f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f34107208ULL, 0x000fc80004000000ULL, 0x000000351000720bULL, 0x000fc80003f1e000ULL,
0x00000010350f7208ULL, 0x000fc80004000000ULL, 0x000000300f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f30107208ULL, 0x000fc80004000000ULL, 0x000000311000720bULL, 0x000fc80003f1e000ULL,
0x00000010310f7208ULL, 0x000fc80004000000ULL, 0x0000002c0f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f2c107208ULL, 0x000fc80004000000ULL, 0x0000002d1000720bULL, 0x000fc80003f1e000ULL,
0x000000102d0f7208ULL, 0x000fc80004000000ULL, 0x000000280f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f28107208ULL, 0x000fc80004000000ULL, 0x000000291000720bULL, 0x000fc80003f1e000ULL,
0x00000010290f7208ULL, 0x000fc80004000000ULL, 0x000000160f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f16107208ULL, 0x000fe40004000000ULL, 0x0000003e1100720bULL, 0x000fe40003f1e000ULL,
0x000000251000720bULL, 0x000fc80003f3e000ULL, 0x0000001025147208ULL, 0x000fe40004800000ULL,
0x000000113e107208ULL, 0x000fe40004000000ULL, 0x0000003b1400720bULL, 0x000fe40003f3e000ULL,
0x0000003f1000720bULL, 0x000fe40003f1e000ULL, 0x000000143b117208ULL, 0x000fe40004800000ULL,
0x000000103f0f7208ULL, 0x000fc40004000000ULL, 0x0000003c1100720bULL, 0x000fe40003f3e000ULL,
0x000000360f00720bULL, 0x000fe40003f1e000ULL, 0x000000113c117208ULL, 0x000fe40004800000ULL,
0x0000000f36107208ULL, 0x000fe40004000000ULL, 0x000000401100720bULL, 0x000fe40003f3e000ULL,
0x000000371000720bULL, 0x000fc40003f1e000ULL, 0x0000001140147208ULL, 0x000fe40004800000ULL,
0x00000010370f7208ULL, 0x000fe40004000000ULL, 0x000000431400720bULL, 0x000fe40003f3e000ULL,
0x000000320f00720bULL, 0x000fe40003f1e000ULL, 0x0000001443147208ULL, 0x000fe40004800000ULL,
0x0000000f32107208ULL, 0x000fc60004000000ULL, 0x0c401f0014117f89ULL, 0x000ea200000e0000ULL,
0x000000331000720bULL, 0x000fc80003f1e000ULL, 0x00000010330f7208ULL, 0x000fc80004000000ULL,
0x0000002e0f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f2e107208ULL, 0x000fc80004000000ULL,
0x0000002f1000720bULL, 0x000fc80003f1e000ULL, 0x000000102f0f7208ULL, 0x000fe40004000000ULL,
0x000000111400720bULL, 0x004fe40003f3e000ULL, 0x0000002a0f00720bULL, 0x000fe40003f1e000ULL,
0x0000001411117208ULL, 0x000fe40004800000ULL, 0x0000000f2a107208ULL, 0x000fc60004000000ULL,
0x0c201f0011147f89ULL, 0x000ea200000e0000ULL, 0x0000002b1000720bULL, 0x000fc80003f1e000ULL,
0x000000102b0f7208ULL, 0x000fc80004000000ULL, 0x000000260f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f26107208ULL, 0x000fc80004000000ULL, 0x000000271000720bULL, 0x000fc80003f1e000ULL,
0x00000010270f7208ULL, 0x000fe40004000000ULL, 0x000000141100720bULL, 0x004fe40003f3e000ULL,
0x000000220f00720bULL, 0x000fe40003f1e000ULL, 0x0000001114107208ULL, 0x000fe40004800000ULL,
0x0000000f22147208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b10187820ULL, 0x000fe20000410000ULL,
0x000000231400720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b251d7823ULL, 0x100fe20000010818ULL,
0x0000001423147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3b257823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010818ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010818ULL,
0x000000211400720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010818ULL, 0x0000003d001a7308ULL, 0x000fe20000000800ULL,
0x00000014210f7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010818ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010818ULL,
0x000000240f00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010818ULL, 0x0000001700177308ULL, 0x000fe20000000800ULL,
0x0000000f240f7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010818ULL,
0x3fb8aa3b40407823ULL, 0x000fc60000010818ULL, 0x0c401f000f147f89ULL, 0x000ea400000e0000ULL,
0x0000003400157308ULL, 0x0007f00000000800ULL, 0x00000035001c7308ULL, 0x000f620000000800ULL,
0x3fb8aa3b3c347823ULL, 0x008fce0000010818ULL, 0x0000002c001b7308ULL, 0x0007e20000000800ULL,
0x000000140f00720bULL, 0x004fce0003f1e000ULL, 0x0000003100447308ULL, 0x000fe20000000800ULL,
0x00000007ff2c7e24ULL, 0x008fe2000f8e00ffULL, 0x0000000f14117208ULL, 0x000fc80004000000ULL,
0x3f8000002c2c783eULL, 0x000fe200000010ffULL, 0x0c201f0011147f89ULL, 0x000ea200000e0000ULL,
0x0000001600317308ULL, 0x000bf00000000800ULL, 0x0000002d00467308ULL, 0x0006a20000000800ULL,
0x000000151c16723eULL, 0x022fce00000010ffULL, 0x0000001d00487308ULL, 0x000fe20000000800ULL,
0x000000ffff2d7224ULL, 0x008fe200078e002cULL, 0x000000141100720bULL, 0x004fcc0003f1e000ULL,
0x0000003000197308ULL, 0x0003e20000000800ULL, 0x0000001114117208ULL, 0x000fe40004000000ULL,
0x000000171a14723eULL, 0x000fe400000010ffULL, 0x0000001b461a723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b113b7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b29307823ULL, 0x102fe20000010818ULL,
0x3fb8aa3b43187823ULL, 0x000fe20000010818ULL, 0x00000028000f7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001083bULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b27287823ULL, 0x102fe2000001083bULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001083bULL,
0x0c401f0012277f89ULL, 0x000e6200000e0000ULL, 0x0000003f003f7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b23237823ULL, 0x000fce000001083bULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x0000003e3f15723eULL, 0x004fce00000010ffULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x000000271200720bULL, 0x002fce0003f1e000ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000001227127208ULL, 0x000fe40004000000ULL, 0x000000363717723eULL, 0x004fca00000010ffULL,
0x0000003300337308ULL, 0x000fe40000000800ULL, 0x0000002c141c723cULL, 0x000fec00000418ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e700000000800ULL,
0x0000001800357308ULL, 0x0005e20000000800ULL, 0x0000002e2f1b723eULL, 0x002fce00000010ffULL,
0x0000002a003c7308ULL, 0x0003e20000000800ULL, 0x000000194418723eULL, 0x004fe200000010ffULL,
0x00000008422f7824ULL, 0x000fe200078e00ffULL, 0x000000323319723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b22327823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b243b7823ULL, 0x000fe2000001083bULL,
0x0c401f0013227f89ULL, 0x000ea400000e0000ULL, 0x0000002b003d7308ULL, 0x0007620000000800ULL,
0x000000ffff2a7224ULL, 0x002fce00078e002cULL, 0x00000028002d7308ULL, 0x0003e20000000800ULL,
0x000000ffff2b7224ULL, 0x008fce00078e002cULL, 0x0000002600267308ULL, 0x000ee20000000800ULL,
0x0000002a1828723cULL, 0x002fe2000004181cULL, 0x000000221300720bULL, 0x004fcc0003f3e000ULL,
0x0000003000307308ULL, 0x000e620000000800ULL, 0x00000031481e723eULL, 0x000fe200000010ffULL,
0x000000ffff317224ULL, 0x100fe200078e002cULL, 0x0000003c3d1d723eULL, 0x020fe400000010ffULL,
0x0000001322137208ULL, 0x000fe20004800000ULL, 0x0000000842227836ULL, 0x000fe20000000000ULL,
0x000000262d1f723eULL, 0x008fe200000010ffULL, 0x000000ffff2d7224ULL, 0x100fe200078e002cULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x0000000f301c723eULL, 0x002fe200000010ffULL,
0x000000ffff307224ULL, 0x000fcc00078e002cULL, 0x0000003b002e7308ULL, 0x000e620000000800ULL,
0x00000003ff0f7819ULL, 0x000fe20000011605ULL, 0x0000002c1c28723cULL, 0x000fe60000041828ULL,
0x000000030f0f7812ULL, 0x000fc600078ec0ffULL, 0x0000002500257308ULL, 0x000fe40000000800ULL,
0x000000010f2d7824ULL, 0x000fe200078e0222ULL, 0x000000212e27723eULL, 0x002fca00000010ffULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x0000000842217824ULL, 0x000fe400078e00ffULL,
0x000000010f427824ULL, 0x000fe400078e0242ULL, 0x0c201f00120f7f89ULL, 0x000ea200000e0000ULL,
0x00000008222e7824ULL, 0x000fe400078e00ffULL, 0x0000004000407308ULL, 0x000ee20000000800ULL,
0x00000004422c7836ULL, 0x000fe20000000000ULL, 0xfffffff821217812ULL, 0x000fe200078ee242ULL,
0x0000000c42427836ULL, 0x000fe20000000000ULL, 0xfffffff82e2d7812ULL, 0x000fe200078ee22dULL,
0x000000ffff2e7224ULL, 0x000fe200078e0018ULL, 0x000000253424723eULL, 0x002fc400000010ffULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x000000ffff187224ULL, 0x000fe200078e001dULL,
0x000000403526723eULL, 0x008fcc00000010ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000000822357824ULL, 0x000fe400078e00ffULL, 0x0c201f0013227f89ULL, 0x000ee200000e0000ULL,
0x000000ffff337224ULL, 0x000fe200078e0026ULL, 0x0000000f1200720bULL, 0x004fe40003f1e000ULL,
0xfffffff835357812ULL, 0x000fe400078ee242ULL, 0x000000120f127208ULL, 0x000fe20004000000ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000305ff7812ULL, 0x000fc4000780c0ffULL,
0x000000322325723eULL, 0x002fe200000010ffULL, 0x000000ffff327224ULL, 0x000fe200078e0024ULL,
0x0000000a3a237c11ULL, 0x000fca000f8e58ffULL, 0x000000302428723cULL, 0x000fe20000041828ULL,
0x0001100023347836ULL, 0x000fe20000000000ULL, 0xfffffff82f237812ULL, 0x000fe200078ee22cULL,
0x000000ffff2c7224ULL, 0x000fe400078e0014ULL, 0x0000001021217824ULL, 0x000fe200078e0234ULL,
0x000000221300720bULL, 0x008fe20003f3e000ULL, 0x000000ffff2f7224ULL, 0x000fe400078e001aULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x0000001322137208ULL, 0x000fe20004800000ULL,
0x0000001023237824ULL, 0x000fc400078e0234ULL, 0x000000ffff307224ULL, 0x000fe400078e001cULL,
0x000000ffff317224ULL, 0x000fe400078e001eULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff177224ULL, 0x000fe400078e001bULL, 0x000000102d297824ULL, 0x000fe400078e0234ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0016ULL, 0x000000ffff167224ULL, 0x000fe400078e0019ULL,
0x0000001035357824ULL, 0x000fe200078e0234ULL, 0x0000002c21007844ULL, 0x000fe20000000200ULL,
0x000000ffff197224ULL, 0x000fe400078e001fULL, 0x000000ffff1a7224ULL, 0x000fe200078e0025ULL,
0x0000003023007844ULL, 0x000fe20000000200ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0027ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0028ULL, 0x0000001429007844ULL, 0x0003e20000000200ULL,
0x000000ffff1d7224ULL, 0x000fc600078e002aULL, 0x0000001835007844ULL, 0x0005e80000000200ULL,
0x0170001020008388ULL, 0x0005e80000000c00ULL, 0x0172001c20008388ULL, 0x0005e20000000a00ULL,
0x0000000d0b00720cULL, 0x000fe20003f06070ULL, 0x0176080f0aff79a7ULL, 0x0005e2000850003fULL,
0x000000ffff147224ULL, 0x002fe200078e000eULL, 0x0176100f0aff79a7ULL, 0x0005e2000850003fULL,
0x0176180f0aff79a7ULL, 0x0005e2000850003fULL, 0x0176200f0aff79a7ULL, 0x0005f0000850003fULL,
0xffffffac00cc8947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x018000004f007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000004f00008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff4fff7812ULL, 0x040fe4000780c0ffULL, 0x800000004f027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000004f00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffed402407950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x000000000000057fULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000700ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000958ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a38ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a8cULL,
0x0000000000000660ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001138ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000012c00ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013d80ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013dd0ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000013dd0ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x00000000000143c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000143c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001138ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012c00ULL, 0x0000000000012c00ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013d80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000013dd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_90_cubin_len = 83216;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
