/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001f9c0ULL, 0x000000000001f640ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001da40ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001dbc0ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001dc00ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001dc50ULL, 0x0000000000000130ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001dd80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001da4000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x00751c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001da4000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL,
0x2880808808288080ULL, 0x808c082880808908ULL, 0x082880808d082880ULL, 0x80808f082880808eULL,
0xa808288080a50828ULL, 0x288080aa08288080ULL, 0x80f308288080f208ULL, 0x08288080f8082880ULL,
0x8082801628808092ULL, 0x0000000000031028ULL, 0x2880809292000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001dbc000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL,
0x2880808808288080ULL, 0x808c082880808908ULL, 0x082880808d082880ULL, 0x80808f082880808eULL,
0xa908288080a50828ULL, 0x288080aa08288080ULL, 0x80f308288080f208ULL, 0x08288080f8082880ULL,
0x80828016288080a8ULL, 0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001dc0000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808808288080ULL, 0x808c082880808908ULL,
0x082880808d082880ULL, 0x80808f082880808eULL, 0xa808288080a50828ULL, 0x288080aa08288080ULL,
0x80f308288080f208ULL, 0x08288080f8082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL,
0x288080a992000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000028000000000ULL,
0x0001dc5000000000ULL, 0x0000013000000000ULL, 0x0000180400000000ULL, 0x80aa288080a90900ULL,
0x0000000000002880ULL, 0x0000001900082f04ULL, 0x00082304000000faULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL,
0x0000000000000019ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000016ULL,
0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000b0000043104ULL, 0xffffffff019c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00000110019c2804ULL, 0x0000058000000310ULL,
0x00002960000028d0ULL, 0x00002be000002a70ULL, 0x00002eb000002d50ULL, 0x0000337000003330ULL,
0x000033b000003380ULL, 0x0000652000006490ULL, 0x000067b000006640ULL, 0x00006a8000006920ULL,
0x00006f4000006f00ULL, 0x00006f8000006f50ULL, 0x00009ef000009e50ULL, 0x0000a1700000a000ULL,
0x0000a4400000a2e0ULL, 0x0000a8d00000a890ULL, 0x0000a9100000a8e0ULL, 0x0000d8300000d790ULL,
0x0000dab00000d940ULL, 0x0000dd800000dc20ULL, 0x0000e2300000e1f0ULL, 0x0000e2700000e240ULL,
0x000105f0000105e0ULL, 0x0001061000010600ULL, 0x0001b1400001b100ULL, 0x0001b1600001b150ULL,
0x0001b1d00001b170ULL, 0x0001b2100001b1f0ULL, 0x0001c6b00001c650ULL, 0x0001c7800001c720ULL,
0x0001c8400001c7e0ULL, 0x0001c9200001c8b0ULL, 0x0001ca000001c990ULL, 0x0001cac00001ca60ULL,
0x0001cb900001cb30ULL, 0x0001cc500001cbf0ULL, 0x0001cd300001ccc0ULL, 0x0001ce100001cda0ULL,
0x0001ced00001ce70ULL, 0x0001cfa00001cf40ULL, 0x0001d0600001d000ULL, 0x0001d1400001d0d0ULL,
0x0001d2200001d1b0ULL, 0x0001d2e00001d280ULL, 0x0001d3b00001d350ULL, 0x0001d4700001d410ULL,
0x0001d5500001d4e0ULL, 0x0001d6300001d5c0ULL, 0x0001d7100001d6a0ULL, 0x0001d8100001d790ULL,
0x0001d9100001d890ULL, 0x0001da100001d990ULL, 0x000003e004403904ULL, 0x0001a600000000ffULL,
0x00000440003f0100ULL, 0x0001a6080000000bULL, 0x000004d0003f0120ULL, 0x0001a6880000000bULL,
0x00000530003f0120ULL, 0x0001a6a80000000bULL, 0x00000560003f0120ULL, 0x0001a6c80000000bULL,
0x00000b10003f0120ULL, 0x0001a600000000ffULL, 0x00000d10003f0107ULL, 0x0000000400000006ULL,
0x00000dc0003f0102ULL, 0x0000000000000006ULL, 0x00001730003f0101ULL, 0x00000000000000ffULL,
0x000017b000040107ULL, 0x00000000000000ffULL, 0x0000181000040101ULL, 0x0000002000000004ULL,
0x000019c0003f0101ULL, 0x0001a6cc00000008ULL, 0x00001b90003f0105ULL, 0x0001a6cc00000008ULL,
0x000024d0003f0105ULL, 0x0001a6b00000000aULL, 0x00002580003f0107ULL, 0x0001a6b00000000aULL,
0x000025e0003f0101ULL, 0x0001a60800000023ULL, 0x00002600003f0101ULL, 0x0001a60c00000023ULL,
0x000027d0003f0105ULL, 0x0001a60c00000023ULL, 0x00003060003f0105ULL, 0x0001a6ac0000000aULL,
0x00003250003f0105ULL, 0x0001a6ac0000000aULL, 0x00005650003f0105ULL, 0x000000000000006cULL,
0x000056b0003f0101ULL, 0x0001a68800000025ULL, 0x000056e0003f0101ULL, 0x0000000400000014ULL,
0x000058a0003f0105ULL, 0x0000000400000014ULL, 0x00006090003f0105ULL, 0x0000000000000010ULL,
0x00006170003f0107ULL, 0x0000000000000010ULL, 0x000061d0003f0101ULL, 0x0001a62800000023ULL,
0x000061f0003f0101ULL, 0x0001a62c00000023ULL, 0x000063c0003f0105ULL, 0x0001a62c00000023ULL,
0x00006c70003f0105ULL, 0x0001a6b40000006eULL, 0x00006e40003f0105ULL, 0x0001a6b40000006eULL,
0x00008ff0003f0105ULL, 0x000000000000006eULL, 0x00009050003f0101ULL, 0x0001a69000000028ULL,
0x00009080003f0101ULL, 0x0000000400000014ULL, 0x00009240003f0105ULL, 0x0000000400000014ULL,
0x00009a40003f0105ULL, 0x00000008000000ffULL, 0x00009b3000040107ULL, 0x0001a6b00000002aULL,
0x00009b90003f0101ULL, 0x0001a64800000023ULL, 0x00009bb0003f0101ULL, 0x0001a64c00000023ULL,
0x00009d80003f0105ULL, 0x0001a64c00000023ULL, 0x0000a600003f0105ULL, 0x0000000400000010ULL,
0x0000a7d0003f0105ULL, 0x0000000400000010ULL, 0x0000c940003f0105ULL, 0x0000000000000014ULL,
0x0000c9a0003f0101ULL, 0x0001a69800000002ULL, 0x0000c9d0003f0101ULL, 0x0000000400000014ULL,
0x0000cb90003f0105ULL, 0x0000000400000014ULL, 0x0000d3f0003f0105ULL, 0x00000000000000ffULL,
0x0000d48000040107ULL, 0x0000000000000010ULL, 0x0000d4e0003f0101ULL, 0x0001a66800000006ULL,
0x0000d510003f0101ULL, 0x0001a66c00000006ULL, 0x0000d6e0003f0105ULL, 0x0001a66c00000006ULL,
0x0000df50003f0105ULL, 0x0001a6b400000021ULL, 0x0000e120003f0105ULL, 0x0001a6b400000021ULL,
0x00010390003f0105ULL, 0x0000000000000014ULL, 0x00010410003f0101ULL, 0x0000000000000006ULL,
0x000121e0003f0101ULL, 0x0001a600000000ffULL, 0x00013ae0003f0101ULL, 0x0001a604000000ffULL,
0x00013cb0003f0105ULL, 0x0001a604000000ffULL, 0x00014030003f0105ULL, 0x0001a600000000ffULL,
0x00014060003f0101ULL, 0x0001a604000000ffULL, 0x00014220003f0105ULL, 0x0001a604000000ffULL,
0x00018650003f0105ULL, 0x0000000000000008ULL, 0x00018710003f0101ULL, 0x0000000400000008ULL,
0x000188e0003f0105ULL, 0x0000000400000008ULL, 0x0001c490003f0105ULL, 0x00000000000000bbULL,
0x0001c4f0003f0101ULL, 0x00000008000000bbULL, 0x0001c550003f0101ULL, 0x00000010000000bbULL,
0x0001c5c0003f0101ULL, 0x00000018000000bbULL, 0x00053803003f0101ULL, 0x0001157000301c04ULL,
0x00011780000115a0ULL, 0x00011a40000118e0ULL, 0x00011d0000011ba0ULL, 0x00011ff000011e60ULL,
0x00014280000120f0ULL, 0x000004010001c610ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL,
0x0000001900000002ULL, 0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL,
0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x0000000000000303ULL, 0x0000001900000002ULL, 0x0000000000000233ULL,
0x0000001900000002ULL, 0x0000000000000173ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL,
0x0000001900000002ULL, 0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ffbc7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000767919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a00bc807a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x0000000000be7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff207819ULL, 0x010fc80000011609ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff20207589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e02bcULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fe400078e0002ULL,
0x0000000000057919ULL, 0x000ee80000002200ULL, 0x0000007603197227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a19ULL, 0x0000000007007224ULL, 0x000fca00078e0276ULL,
0x000000070000720cULL, 0x000fe20003f46070ULL, 0x000001000a027a24ULL, 0x008fc800078e0205ULL,
0x00000000020b7a24ULL, 0x000fd000078e0209ULL, 0x0000000100002824ULL, 0x000fe200078e0a07ULL,
0x0000000119192810ULL, 0x000fe20007ffe0ffULL, 0x00001fff0a097589ULL, 0x000e6200000e0000ULL,
0x000000ff0b00720cULL, 0x040fe40003fa5270ULL, 0x000000070000720cULL, 0x000fe40003f66070ULL,
0x0000007f0b00780cULL, 0x040fe40003f04070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff02d424ULL, 0x000fe400078e00ffULL,
0x0000000119193810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff03d424ULL, 0x000fe200078e00ffULL,
0x00000007ff19c212ULL, 0x000fe200078e33ffULL, 0xff317217ff088424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f64070ULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x01a60002ff00d388ULL, 0x0005e20000000a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a19ULL,
0x00005a0019757a19ULL, 0x000fe200000006ffULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x01a400080b008388ULL, 0x0007e20000004800ULL, 0x0000000007767224ULL, 0x000fc600078e0276ULL,
0x01a608040b009388ULL, 0x0009e20000008a00ULL, 0x0000002076007824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe200078e00ffULL,
0x0000000400087c10ULL, 0x048fe2000fffe1ffULL, 0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL,
0x0000000400007c0cULL, 0x000fe2000bf03070ULL, 0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL,
0x0000002008087817ULL, 0x000fe20003800000ULL, 0x01a688020b00a388ULL, 0x0005e20000008a00ULL,
0x3fffff80ff04a424ULL, 0x010fc400078e00ffULL, 0x000000ff08747207ULL, 0x000fe20000000000ULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x0000000409087824ULL, 0x002fe200078e0220ULL,
0x000000207400780cULL, 0x000fe40003f05270ULL, 0x01a6a8040b00a388ULL, 0x000fe20000008a00ULL,
0x0000000408087824ULL, 0x000fe400078e00ffULL, 0x00005800be027a24ULL, 0x004fe200078e02ffULL,
0x01a6c8060b00b388ULL, 0x000fe60000008a00ULL, 0x0000008002027224ULL, 0x000fe200078e0275ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000874037217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff057819ULL, 0x002fc8000001161fULL,
0x00000002050b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001080a7824ULL, 0x000fc800078e0205ULL,
0x00000001080c7824ULL, 0x000fe400078e020bULL, 0x0000000100047824ULL, 0x040fe400078e020aULL,
0x0000000100067824ULL, 0x000fe400078e020cULL, 0x0000000103087824ULL, 0x000fe200078e0a08ULL,
0x0000000404077c12ULL, 0x000fe4000f8e30ffULL, 0x00000004060d7c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fe20000011604ULL, 0x0000000102077824ULL, 0x040fe200078e0207ULL,
0x000000080500720cULL, 0x000fe20003f06070ULL, 0x0000000102027824ULL, 0x000fe200078e020dULL,
0x00005a00ff0d7a19ULL, 0x000fe20000011606ULL, 0x0000008003047224ULL, 0x000fe200078e0207ULL,
0x000000080b00720cULL, 0x000fe20003f26070ULL, 0x000000101f037824ULL, 0x000fc400078e00ffULL,
0x000000800d027224ULL, 0x000fe400078e0202ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000f0030b7812ULL, 0x000fc600078ec0ffULL, 0x0000010002067825ULL, 0x000fe200078e00ffULL,
0x0000000b04047212ULL, 0x000fc600078efcffULL, 0x000000010a027824ULL, 0x100fe200078e021fULL,
0x0000000b06067212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x00005e0004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000010c087824ULL, 0x000fe200078e021fULL,
0x00005e0006067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100c0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d027812ULL, 0x000fe400078ee202ULL, 0x00005f0005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00b087812ULL, 0x000fe200078ee208ULL, 0x00000010020b7824ULL, 0x000fe200078e00ffULL,
0x00005f0007077a10ULL, 0x000fc60001ffe4ffULL, 0x00000010080d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000c101c48ULL,
0x00000000060d7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x000000081f087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x0000000100047824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fe40000011603ULL, 0x0000000404077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fc800078e0205ULL, 0x0000000102027824ULL, 0x000fe200078e0207ULL,
0x00005a00ff077a19ULL, 0x000fe20000011604ULL, 0x0000008003057224ULL, 0x080fe400078e0205ULL,
0x000000101f037824ULL, 0x000fe400078e00ffULL, 0x0000008007077224ULL, 0x000fe400078e0202ULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f0030b7812ULL, 0x000fc600078ec0ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000b04047212ULL, 0x000fc600078efcffULL,
0x0000000108027824ULL, 0x100fe200078e021fULL, 0x0000000b06067212ULL, 0x000fe200078efcffULL,
0x000000010a087824ULL, 0x000fe200078e021fULL, 0x00005e0004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d027812ULL, 0x000fe400078ee202ULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee208ULL,
0x00000010020b7824ULL, 0x000fe200078e00ffULL, 0x00005f0005057a10ULL, 0x000fc400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x00000000060d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200047300ULL, 0x000e7000000e0000ULL, 0x0000000200067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x00000004ff057424ULL, 0x000fc400078e00ffULL,
0x000000ffff047224ULL, 0x004fe400078e0a06ULL, 0x00006600be067625ULL, 0x000fd000078e0005ULL,
0x01a60404ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008061e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x0000007f1e1d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff1e027810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff1d7819ULL, 0x000fe4000001161dULL,
0x00000008ff1c7819ULL, 0x000fca0000011602ULL, 0x000114a000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1b7819ULL, 0x000fe20000011620ULL, 0xffffffffff247424ULL, 0x000fe200078e00ffULL,
0x0001a68820067811ULL, 0x000fe400078e18ffULL, 0x01ffffff1b1b7812ULL, 0x000fc800078ec0ffULL,
0x0000001d1b00720cULL, 0x000fda0003f06070ULL, 0x00000002be008824ULL, 0x000fe400078e00ffULL,
0x00006800ff078624ULL, 0x000fc800078e00ffULL, 0x0000680000008624ULL, 0x000fe400078e0207ULL,
0x00000003ff077424ULL, 0x000fe400078e00ffULL, 0x000000011b008824ULL, 0x000fe200078e0200ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040706ff738cULL, 0x0005e20000000000ULL,
0x0000640000048625ULL, 0x002fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000804248981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x0000008019197824ULL, 0x000fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011620ULL,
0x0000000006ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000120007812ULL, 0x000fc600078ec0ffULL,
0x000000201a777824ULL, 0x000fca00078e00ffULL, 0x0000006019027812ULL, 0x000fe200078ef877ULL,
0x0000590024077a24ULL, 0x00cfc800078e02ffULL, 0x0000008007157824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x002fe200078e00ffULL,
0x000000771e007217ULL, 0x000fe40007800000ULL, 0x00000003ff047819ULL, 0x000fe4000001161fULL,
0x00006200150d7a11ULL, 0x000fe200078838ffULL, 0x0000000100007824ULL, 0x000fe200078e0a77ULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x000fe200078e0204ULL,
0x0000000c04097810ULL, 0x000fc40007ffe0ffULL, 0x0000000500007217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x040fe200078e021fULL, 0x0000630015157a11ULL, 0x000fe200020f3cffULL,
0x00000008060c7824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a05ULL,
0x00000001050a7824ULL, 0x040fe200078e0209ULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL,
0x0000000804077810ULL, 0x000fe20007ffe0ffULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0x000000000800720cULL, 0x080fe20003f46070ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x000000000700720cULL, 0x080fe20003f26070ULL, 0x0000000105077824ULL, 0x000fe200078e0207ULL,
0x000000000400720cULL, 0x080fe20003f66070ULL, 0x0000000108057824ULL, 0x040fe200078e021fULL,
0x000000000900720cULL, 0x000fe20003f06070ULL, 0x00000008080e7824ULL, 0x000fc400078e00ffULL,
0x0000000102047824ULL, 0x000fe400078e0206ULL, 0x0000000107067824ULL, 0x040fe200078e021fULL,
0xfffffff80e007812ULL, 0x000fe200078ee205ULL, 0x00000008070b7824ULL, 0x000fe400078e00ffULL,
0x0000008004047825ULL, 0x000fc600078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe200078ee206ULL,
0x0000000102067824ULL, 0x000fe200078e0208ULL, 0x0000007004047812ULL, 0x000fe200078ef803ULL,
0x0000000102087824ULL, 0x040fe400078e0207ULL, 0x00000001020b7824ULL, 0x000fe200078e020aULL,
0x000000040d047210ULL, 0x000fe20007f9e0ffULL, 0x000000010a027824ULL, 0x000fe400078e021fULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee202ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007006027812ULL, 0x000fc600078ef803ULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008067812ULL, 0x000fc600078ef803ULL,
0x0000000105057824ULL, 0x000fe200020e0615ULL, 0x000000700a087812ULL, 0x000fe400078ef803ULL,
0x000160001a037811ULL, 0x000fe400078e68ffULL, 0x0000000d02027210ULL, 0x080fe40007f9e0ffULL,
0x0000000d06067210ULL, 0x080fe20007fbe0ffULL, 0x00000010000f7824ULL, 0x100fe200078e0203ULL,
0x0000000d08087210ULL, 0x000fe20007fde0ffULL, 0x000000100c0d7824ULL, 0x000fc400078e0203ULL,
0x000000100e117824ULL, 0x100fe400078e0203ULL, 0x0000001010137824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000d901c48ULL,
0x0000000107037824ULL, 0x100fe400020e0615ULL, 0x0000000109077824ULL, 0x100fe400028e0615ULL,
0x000000010b097824ULL, 0x000fe200030e0615ULL, 0x00000000020f7faeULL, 0x0003e8000d101c48ULL,
0x0000000006117faeULL, 0x0003e8000c901c48ULL, 0x0000000008137faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x002fe200078e00ffULL,
0x00006200150d7a11ULL, 0x000fc400078038ffULL, 0x000160001a137811ULL, 0x000fe400078e68ffULL,
0x000000001f007211ULL, 0x000fe400078fe8ffULL, 0x0000630015157a11ULL, 0x000fe400000f3cffULL,
0x0000000400067810ULL, 0x040fe20007ffe0ffULL, 0x0000000100047824ULL, 0x040fe200078e021fULL,
0x0000000800077810ULL, 0x040fe20007ffe0ffULL, 0x0000000800057824ULL, 0x000fe400078e00ffULL,
0x00000008060e7824ULL, 0x000fc400078e00ffULL, 0x0000000107087824ULL, 0x100fe200078e021fULL,
0xfffffff8050c7812ULL, 0x000fe200078ee204ULL, 0x0000000106057824ULL, 0x000fe400078e021fULL,
0x0000000102047824ULL, 0x000fe200078e0200ULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee205ULL,
0x0000008004047825ULL, 0x000fc600078e00ffULL, 0xfffffff809107812ULL, 0x000fe200078ee208ULL,
0x0000000102067824ULL, 0x000fe200078e0206ULL, 0x0000007004047812ULL, 0x000fe200078ef803ULL,
0x0000000102087824ULL, 0x040fe400078e0207ULL, 0x00000001020a7824ULL, 0x000fe200078e0200ULL,
0x000000040d047210ULL, 0x000fe20007f1e0ffULL, 0x0000000100027824ULL, 0x040fe400078e021fULL,
0x00000008000f7824ULL, 0x000fe400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff80f007812ULL, 0x000fe200078ee202ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000007006027812ULL, 0x000fc600078ef803ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008067812ULL, 0x000fc600078ef803ULL, 0x0000000105057824ULL, 0x000fe200000e0615ULL,
0x000000700a037812ULL, 0x000fe200078ef803ULL, 0x000000100e0f7824ULL, 0x100fe200078e0213ULL,
0x000000020d027210ULL, 0x040fe20007f1e0ffULL, 0x0000001010117824ULL, 0x100fe200078e0213ULL,
0x000000060d067210ULL, 0x040fe40007f3e0ffULL, 0x000000030d087210ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe400078e0213ULL, 0x0000000107037824ULL, 0x000fc400000e0615ULL,
0x0000000109077824ULL, 0x000fe200008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000b901c48ULL, 0x0000001000137824ULL, 0x000fe400078e0213ULL,
0x000000010b097824ULL, 0x000fe200010e0615ULL, 0x00000000020f7faeULL, 0x0003e8000b901c48ULL,
0x0000000006117faeULL, 0x0003e8000b901c48ULL, 0x0000000008137faeULL, 0x0003e4000b901c48ULL,
0x000000001a0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x0001a6a81a047811ULL, 0x002fe200078e18ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0001a6a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3d7224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff027f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200004047f8cULL, 0x000ea2000c80043fULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000eb9000008947ULL, 0x000fea0003800000ULL,
0x000000101a157824ULL, 0x000fe200078e00ffULL, 0x00000002ff177819ULL, 0x000fe20000011620ULL,
0x00000002be187824ULL, 0x000fc400078e00ffULL, 0x00006800ff077624ULL, 0x000fe200078e00ffULL,
0x0000001015157812ULL, 0x000fe200078ee2ffULL, 0x000000ffff007224ULL, 0x002fe400078e0003ULL,
0x000000ffff037224ULL, 0x004fe400078e0005ULL, 0x0000680018187624ULL, 0x000fe400078e0207ULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x000fc400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0a7224ULL, 0x01afca00078e00ffULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x0000000420067824ULL, 0x000fca00078e00ffULL,
0xfffffff806087812ULL, 0x000fc800078ec0ffULL, 0x0001a6c808147810ULL, 0x000fe20007ffe0ffULL,
0x01a6cc0008067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020037824ULL, 0x000fe200078e00ffULL,
0x0000000116077810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x000fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000008024247824ULL, 0x000fe200078e00ffULL,
0x0000001c0700720cULL, 0x000fc60003f46070ULL, 0x0000010016057824ULL, 0x000fca00078e0205ULL,
0x0000004005057810ULL, 0x000fc80007ffe0ffULL, 0x0000006005047812ULL, 0x000fca00078ec0ffULL,
0x00000001190b7824ULL, 0x000fe200078e0204ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101f087824ULL, 0x000fe200078e00ffULL,
0x000000051e037217ULL, 0x000fe40007800000ULL, 0x00000003ff077819ULL, 0x000fe4000001161fULL,
0x0000007008237812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a05ULL,
0x0000000407087810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x040fe200078e0204ULL,
0x0000000807097810ULL, 0x000fc40007ffe0ffULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x0000000106057824ULL, 0x040fe200078e021fULL, 0x0000000c070a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0x0000620024217a11ULL, 0x000fe200078c38ffULL,
0x0000000103037824ULL, 0x100fe400078e0a04ULL, 0x000000010a267824ULL, 0x000fe200078e0204ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fe200078e0206ULL,
0x000000030800720cULL, 0x0c0fe20003f86070ULL, 0x0000000108067824ULL, 0x100fe200078e0204ULL,
0x000000030700720cULL, 0x080fe20003fa6070ULL, 0x0000000109087824ULL, 0x040fe200078e0204ULL,
0x000000030a00720cULL, 0x080fe20003f06070ULL, 0x0000000106077824ULL, 0x040fe200078e021fULL,
0x000000030900720cULL, 0x000fe20003f66070ULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0x0000630024257a11ULL, 0x000fe200030f3cffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0x00000023040a7212ULL, 0x000fe200078efcffULL, 0x000000010b097824ULL, 0x000fe400078e0208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000a210a7210ULL, 0x000fc60007fde0ffULL,
0x0000000108037824ULL, 0x000fe200078e021fULL, 0x0000002306067212ULL, 0x000fe200078efcffULL,
0x0000000808247824ULL, 0x000fe400078e00ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee203ULL, 0x000000010b047824ULL, 0x000fe200078e0226ULL,
0x0000002308087212ULL, 0x000fe200078efcffULL, 0x00000001050b7824ULL, 0x000fe200030e0625ULL,
0x0000002106067210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x000170001a037811ULL, 0x000fc600078e68ffULL, 0x0000000107077824ULL, 0x000fe200030e0625ULL,
0x0000002108087210ULL, 0x000fe20007fde0ffULL, 0x0000000126137824ULL, 0x000fe200078e021fULL,
0x0000002304047212ULL, 0x000fe200078efcffULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe200030e0625ULL, 0x0000002104047210ULL, 0x000fe20007fde0ffULL,
0x0000001012217824ULL, 0x000fe200078e0203ULL, 0xfffffff826267812ULL, 0x000fe200078ee213ULL,
0x0000001010137824ULL, 0x000fc400078e0203ULL, 0x0000001024237824ULL, 0x100fe400078e0203ULL,
0x0000001026037824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000e901c48ULL, 0x0000000105057824ULL, 0x000fc600030e0625ULL,
0x0000000006217faeULL, 0x0003e8000e101c48ULL, 0x0000000008237faeULL, 0x0003e8000d901c48ULL,
0x0000000004037faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101f097824ULL, 0x000fe200078e00ffULL,
0x0000620024257a11ULL, 0x000fc400078038ffULL, 0x000000041f047211ULL, 0x000fe400078fe8ffULL,
0x0000007009217812ULL, 0x000fe400078ec0ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104037824ULL, 0x140fe200078e021fULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x000fe200078e00ffULL, 0x0000630024277a11ULL, 0x000fe200000f3cffULL,
0x0000000106057824ULL, 0x040fe400078e021fULL, 0x0000000806107824ULL, 0x000fe200078e00ffULL,
0xfffffff80a037812ULL, 0x000fe200078ee203ULL, 0x0000000108077824ULL, 0x000fe200078e021fULL,
0x0000000c040a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000808127824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fc400078e0204ULL,
0x000000010b067824ULL, 0x000fe200078e0206ULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x0000008005047825ULL, 0x000fc800078e00ffULL, 0x000000010b087824ULL, 0x040fe200078e0208ULL,
0x0000002104047212ULL, 0x000fe200078efcffULL, 0x000000010b0b7824ULL, 0x000fe400078e020aULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000425047210ULL, 0x000fc60007f1e0ffULL,
0x000000010a137824ULL, 0x000fe200078e021fULL, 0x0000002106067212ULL, 0x000fe200078efcffULL,
0x000000080a247824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff824237812ULL, 0x000fe200078ee213ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000002108087212ULL, 0x080fe400078efcffULL, 0x000170001a247811ULL, 0x000fe200078e68ffULL,
0x0000000105057824ULL, 0x100fe200000e0627ULL, 0x000000210a0a7212ULL, 0x000fe400078efcffULL,
0x0000000625067210ULL, 0x000fe20007f1e0ffULL, 0x0000001003037824ULL, 0x100fe200078e0224ULL,
0x0000000825087210ULL, 0x040fe20007f7e0ffULL, 0x0000001010137824ULL, 0x100fe200078e0224ULL,
0x0000000a250a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000107077824ULL, 0x000fe200000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c48ULL,
0x0000001012217824ULL, 0x000fc400078e0224ULL, 0x0000000109097824ULL, 0x100fe200018e0627ULL,
0x0000000006137faeULL, 0x0003e2000b901c48ULL, 0x0000001023237824ULL, 0x000fe400078e0224ULL,
0x000000010b0b7824ULL, 0x000fe200020e0627ULL, 0x0000000008217faeULL, 0x0003e8000b901c48ULL,
0x000000000a237faeULL, 0x0003e4000b901c48ULL, 0x0000000820037824ULL, 0x002fe200078e00ffULL,
0x000000011b047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001d0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0573c2ULL, 0x000e6200000e0000ULL, 0xffffffe003237812ULL, 0x040fe400078ec0ffULL,
0x0000001003067812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000118048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002303237210ULL, 0x000fe40007ffe006ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640004048625ULL, 0x000fca00078e0005ULL, 0x0000000804248981ULL, 0x000522000c1e1900ULL,
0x0001a6b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b0000a267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6080023087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01a60c0023037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60c0023037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101f137824ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe2000001161fULL,
0x0000002020037824ULL, 0x000fc600078e00ffULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0xffffff8003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000312037210ULL, 0x000fca0007ffe013ULL, 0x01a0000003057984ULL, 0x000e680000000800ULL,
0x01a2000003047984ULL, 0x0006a20000000800ULL, 0x000000020500720bULL, 0x002fe20003f1d000ULL,
0x00019d527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x008fc800000e0100ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x000fd200078e0002ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000201700720cULL, 0x000fe40003f05270ULL,
0x000000020500720bULL, 0x000fe20003f74000ULL, 0x00019d227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x000fc400018e0100ULL, 0x0000008020078824ULL, 0x000fe200078e0213ULL,
0x0000000205217209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000112108824ULL, 0x000fca00078e0207ULL, 0x01a4002110008388ULL, 0x0003e20000000800ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000000221027221ULL, 0x002fe20000010100ULL, 0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL,
0x0000000200027308ULL, 0x000e640000000800ULL, 0x0000000222227220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161fULL,
0x00019c727f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000292c2c7220ULL, 0x08cfe40000410000ULL, 0x000000292d2d7220ULL, 0x080fe40000410000ULL,
0x0000002930307220ULL, 0x080fe40000410000ULL, 0x0000002931317220ULL, 0x000fc40000410000ULL,
0x0000002934347220ULL, 0x080fe40000410000ULL, 0x0000002935357220ULL, 0x080fe40000410000ULL,
0x0000002938387220ULL, 0x080fe40000410000ULL, 0x0000002939397220ULL, 0x080fe40000410000ULL,
0x000000293c3c7220ULL, 0x080fe40000410000ULL, 0x000000293d3d7220ULL, 0x000fc40000410000ULL,
0x0000002940407220ULL, 0x080fe40000410000ULL, 0x0000002941417220ULL, 0x080fe40000410000ULL,
0x0000002944447220ULL, 0x080fe40000410000ULL, 0x0000002945457220ULL, 0x080fe40000410000ULL,
0x0000002948487220ULL, 0x080fe40000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081f297811ULL, 0x000fe200078ff0ffULL, 0x00019b627f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x00066400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe40000410000ULL,
0x000000292f2f7220ULL, 0x080fe40000410000ULL, 0x0000002932327220ULL, 0x080fe40000410000ULL,
0x0000002933337220ULL, 0x080fe40000410000ULL, 0x0000002936367220ULL, 0x080fe40000410000ULL,
0x0000002937377220ULL, 0x000fc40000410000ULL, 0x000000293a3a7220ULL, 0x080fe40000410000ULL,
0x000000293b3b7220ULL, 0x080fe40000410000ULL, 0x000000293e3e7220ULL, 0x080fe40000410000ULL,
0x000000293f3f7220ULL, 0x080fe40000410000ULL, 0x0000002942427220ULL, 0x080fe40000410000ULL,
0x0000002943437220ULL, 0x000fc40000410000ULL, 0x0000002946467220ULL, 0x080fe40000410000ULL,
0x0000002947477220ULL, 0x080fe40000410000ULL, 0x000000294a4a7220ULL, 0x080fe40000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101f297811ULL, 0x000fe200078ff0ffULL,
0x00019a527f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000294c4c7220ULL, 0x08cfe40000410000ULL, 0x000000294d4d7220ULL, 0x080fe40000410000ULL,
0x0000002950507220ULL, 0x080fe40000410000ULL, 0x0000002951517220ULL, 0x080fe40000410000ULL,
0x0000002954547220ULL, 0x080fe40000410000ULL, 0x0000002955557220ULL, 0x000fc40000410000ULL,
0x0000002958587220ULL, 0x080fe40000410000ULL, 0x0000002959597220ULL, 0x080fe40000410000ULL,
0x000000295c5c7220ULL, 0x080fe40000410000ULL, 0x000000295d5d7220ULL, 0x080fe40000410000ULL,
0x0000002960607220ULL, 0x080fe40000410000ULL, 0x0000002961617220ULL, 0x000fc40000410000ULL,
0x0000002964647220ULL, 0x080fe40000410000ULL, 0x0000002965657220ULL, 0x080fe40000410000ULL,
0x0000002968687220ULL, 0x080fe40000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181f297811ULL, 0x000fe200078ff0ffULL,
0x000199527f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000294e4e7220ULL, 0x08cfe40000410000ULL, 0x000000294f4f7220ULL, 0x080fe40000410000ULL,
0x0000002952527220ULL, 0x080fe40000410000ULL, 0x0000002953537220ULL, 0x080fe40000410000ULL,
0x0000002956567220ULL, 0x080fe40000410000ULL, 0x0000002957577220ULL, 0x000fc40000410000ULL,
0x000000295a5a7220ULL, 0x080fe40000410000ULL, 0x000000295b5b7220ULL, 0x080fe40000410000ULL,
0x000000295e5e7220ULL, 0x080fe40000410000ULL, 0x000000295f5f7220ULL, 0x080fe40000410000ULL,
0x0000002962627220ULL, 0x080fe40000410000ULL, 0x0000002963637220ULL, 0x000fc40000410000ULL,
0x0000002966667220ULL, 0x080fe40000410000ULL, 0x0000002967677220ULL, 0x080fe40000410000ULL,
0x000000296a6a7220ULL, 0x080fe40000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000803ff7212ULL, 0x000fda00078030ffULL,
0x8000002105050221ULL, 0x000fe20000010000ULL, 0x00007610ff060816ULL, 0x000fc60000000006ULL,
0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL, 0x0000000500110308ULL, 0x000e640000000800ULL,
0x0000001104040220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002204227221ULL, 0x004fc40000010000ULL, 0x0000000000027805ULL, 0x008fca0000015200ULL,
0x01a6ac000a057984ULL, 0x000e620000000800ULL, 0x0001a6a80a107810ULL, 0x000fe40007ffe0ffULL,
0x8000000005ff7812ULL, 0x002fe20007804800ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6ac000a057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991006007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000011ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe4000001161fULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x000195327f007947ULL, 0x000fea000b800000ULL, 0x00001f03000f7589ULL, 0x0002a400000e0000ULL,
0x0000000803297810ULL, 0x000fe20007ffe0ffULL, 0x000195827f007947ULL, 0x000fea000b800000ULL,
0x00000010030d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f29000e7589ULL, 0x00066a00000e0000ULL,
0x00001f0d000d7589ULL, 0x0006a400000e0000ULL, 0x0000001803297810ULL, 0x008fe20007ffe0ffULL,
0x000196127f007947ULL, 0x000fea000b800000ULL, 0x00001f29000c7589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000220257824ULL, 0x040fe200078e00ffULL,
0x000000081f007812ULL, 0x00afe200078ec0ffULL, 0x0000000420047824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100020057824ULL, 0x000fe200078e00ffULL,
0x0000000425027812ULL, 0x000fe200078ec0ffULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x00000007000b7812ULL, 0x000fc400078ef81fULL, 0x000000021f007211ULL, 0x000fe400078fe0ffULL,
0x000000100b0a7812ULL, 0x040fe200078efcffULL, 0x000000080b067824ULL, 0x040fe200078e00ffULL,
0x0000000404047812ULL, 0x000fe200078ec0ffULL, 0x000000010b097824ULL, 0x000fe200078e0200ULL,
0xffffe00005057812ULL, 0x000fe200078ec0ffULL, 0x0000000100087824ULL, 0x000fe400078e020aULL,
0x0000040020007824ULL, 0x000fe200078e00ffULL, 0xfffffff806097812ULL, 0x000fe200078ee209ULL,
0x000000080a037824ULL, 0x000fe200078e00ffULL, 0x0001600005057810ULL, 0x000fe20007ffe0ffULL,
0x000000080b077824ULL, 0x040fe200078e00ffULL, 0xfffff00000007812ULL, 0x000fe200078ec0ffULL,
0x000000080b797824ULL, 0x000fe200078e00ffULL, 0xfffffff803087812ULL, 0x000fc400078ee208ULL,
0x000000041f037211ULL, 0x000fe400078fe0ffULL, 0x0001200000007810ULL, 0x000fc60007ffe0ffULL,
0x000000010b047824ULL, 0x000fe400078e0203ULL, 0x00000010096c7824ULL, 0x100fe400078e0200ULL,
0x0000001008287824ULL, 0x000fe200078e0200ULL, 0xfffffff807077812ULL, 0x000fe400078ee204ULL,
0x0000000204067810ULL, 0x000fe20007ffe0ffULL, 0x000000006c6c783bULL, 0x000e640000000200ULL,
0x0000001007707824ULL, 0x000fc400078e0205ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7231ULL, 0x086fe400003400ffULL,
0x0000000f6e6e7231ULL, 0x000fe400003400ffULL, 0x0000000e6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000e6f6f7231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x088fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fc400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff879067812ULL, 0x000fe200078ee206ULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x0000000202027812ULL, 0x000fe200078efcffULL, 0x0000106000007945ULL, 0x000fe40003800000ULL,
0x0000001006787824ULL, 0x000fe200078e0205ULL, 0x000000021f027211ULL, 0x000fca00078fe0ffULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0x0000010070957824ULL, 0x008fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011470ULL, 0x0000010071987824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011472ULL, 0x0000007000047306ULL, 0x000fe20000009400ULL,
0x00000018ff957819ULL, 0x000fe20000011495ULL, 0x0000010072a97824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe20000011498ULL, 0x0000010073ac7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe20000011473ULL, 0x0000010078bb7824ULL, 0x004fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fe20000011479ULL, 0x0000007d009a7306ULL, 0x000fe20000209400ULL,
0x00000018ffa37819ULL, 0x000fe2000001147bULL, 0x0000010079be7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fc40000011471ULL, 0x00000018ff9b7819ULL, 0x000fe4000001147aULL,
0x00000018ffa97819ULL, 0x000fe200000114a9ULL, 0x0000007d009d7306ULL, 0x000fe20000205400ULL,
0x00000018ffb27819ULL, 0x000fe400000114acULL, 0x00000018ffbb7819ULL, 0x000fe400000114bbULL,
0x00000018ffc47819ULL, 0x000fc600000114beULL, 0x0000007d00927306ULL, 0x0005f0000020d400ULL,
0x0000008100ae7306ULL, 0x000fe20000209400ULL, 0x00000018ff7d7819ULL, 0x004fce0000011478ULL,
0x0000008100af7306ULL, 0x000ff00000205400ULL, 0x00000081008d7306ULL, 0x000ff0000020d400ULL,
0x0000009600c87306ULL, 0x000ff00000209400ULL, 0x0000009600c97306ULL, 0x000ff00000205400ULL,
0x0000009600817306ULL, 0x000ff0000020d400ULL, 0x0000007000937306ULL, 0x000eb00000005400ULL,
0x00000071009c7306ULL, 0x000ff00000009400ULL, 0x00000071009f7306ULL, 0x000ee20000005400ULL,
0x000000930400720bULL, 0x004fe20003fdd000ULL, 0x000001007a047824ULL, 0x000fca00078e00ffULL,
0x00000018ff047819ULL, 0x000fe20000011404ULL, 0x0000009500967306ULL, 0x000ff00000209400ULL,
0x0000009500977306ULL, 0x000ea20000205400ULL, 0x0000009f9c00720bULL, 0x008fe20003f9d000ULL,
0x000100007b9c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe2000001149cULL,
0x0000009e00a07306ULL, 0x000ff00000209400ULL, 0x0000009e00a17306ULL, 0x000ee20000205400ULL,
0x000000979600720bULL, 0x004fe20003fbd000ULL, 0x000001007b977824ULL, 0x000fca00078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011497ULL, 0x0000008800b77306ULL, 0x000ff00000209400ULL,
0x0000008800ba7306ULL, 0x000fe20000205400ULL, 0x000000a1a000720bULL, 0x008fce0003f7d000ULL,
0x0000008800857306ULL, 0x000ff0000020d400ULL, 0x0000007d00c07306ULL, 0x000ff00000209400ULL,
0x0000007d00c17306ULL, 0x000ff00000205400ULL, 0x0000007d00837306ULL, 0x000ff0000020d400ULL,
0x0000007000947306ULL, 0x0004f0000000d400ULL, 0x000000a3008b7306ULL, 0x000fe20000209400ULL,
0x0001000070707824ULL, 0x004fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x000000a300887306ULL, 0x000fe20000205400ULL, 0x0000000194946812ULL, 0x008fe400078efcffULL,
0x0000009d9a00720bULL, 0x000fca0003fdd000ULL, 0x000000a3007d7306ULL, 0x0005f0000020d400ULL,
0x0000007f00a57306ULL, 0x000fe20000209400ULL, 0x0001000071a37824ULL, 0x004fe200078e00ffULL,
0x0000000192926812ULL, 0x000fc800078efcffULL, 0x00000018ffa37819ULL, 0x000fe400000114a3ULL,
0x0000007f00a87306ULL, 0x000ff00000205400ULL, 0x0000007f00917306ULL, 0x000ff0000020d400ULL,
0x0000007100057306ULL, 0x000eb0000000d400ULL, 0x0000009b00877306ULL, 0x000ff00000209400ULL,
0x0000009b008a7306ULL, 0x000fe20000205400ULL, 0x0000000105054812ULL, 0x004fc400078efcffULL,
0x000000a8a500720bULL, 0x000fca0003f9d000ULL, 0x0000009b007f7306ULL, 0x000ff0000020d400ULL,
0x0000009500997306ULL, 0x000ea2000020d400ULL, 0x0000000191914812ULL, 0x000fce00078efcffULL,
0x0000009e00a27306ULL, 0x000ef0000020d400ULL, 0x0000007000987306ULL, 0x000fe20000209400ULL,
0x0000000199995812ULL, 0x004fce00078efcffULL, 0x00000070009b7306ULL, 0x000ea20000205400ULL,
0x00000001a2a23812ULL, 0x008fc800078efcffULL, 0x00000005a205723eULL, 0x000fc600000010ffULL,
0x000000a300957306ULL, 0x000ff00000209400ULL, 0x000000a300a47306ULL, 0x000ee20000205400ULL,
0x0000009b9800720bULL, 0x004fce0003fbd000ULL, 0x0000007000717306ULL, 0x000eb0000020d400ULL,
0x000000a300a67306ULL, 0x000e62000020d400ULL, 0x000000a49500720bULL, 0x008fce0003f7d000ULL,
0x0000007200a77306ULL, 0x000fe20000009400ULL, 0x0000000171715812ULL, 0x004fce00078efcffULL,
0x0000007200aa7306ULL, 0x000ea20000005400ULL, 0x00000001a6a63812ULL, 0x002fce00078efcffULL,
0x0000007300b07306ULL, 0x000ff00000009400ULL, 0x0000007300b17306ULL, 0x000e620000005400ULL,
0x000000aaa700720bULL, 0x004fce0003fdd000ULL, 0x000000a9009e7306ULL, 0x000ff00000209400ULL,
0x000000a900ab7306ULL, 0x000ea20000205400ULL, 0x000000b1b000720bULL, 0x002fce0003f9d000ULL,
0x000000b200b37306ULL, 0x000ff00000209400ULL, 0x000000b200b47306ULL, 0x000e620000205400ULL,
0x000000ab9e00720bULL, 0x004fce0003fbd000ULL, 0x0000007200907306ULL, 0x0004f0000000d400ULL,
0x00000073008c7306ULL, 0x0006e2000000d400ULL, 0x0001000072727824ULL, 0x004fe200078e00ffULL,
0x000000b4b300720bULL, 0x002fc80003f7d000ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x000000a900ad7306ULL, 0x000e62000020d400ULL, 0x0001000073737824ULL, 0x008fe200078e00ffULL,
0x0000000190906812ULL, 0x000fe400078efcffULL, 0x000000afae00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x000000b200b57306ULL, 0x000ea2000020d400ULL,
0x000000018c8c4812ULL, 0x000fc400078efcffULL, 0x000000bab700720bULL, 0x000fca0003f9d000ULL,
0x0000007200707306ULL, 0x000fe20000209400ULL, 0x00000001adad5812ULL, 0x002fe400078efcffULL,
0x000000018d8d6812ULL, 0x000fca00078efcffULL, 0x0000007200a37306ULL, 0x000e620000205400ULL,
0x00000001b5b53812ULL, 0x004fe400078efcffULL, 0x0000000185854812ULL, 0x000fca00078efcffULL,
0x0000007300a97306ULL, 0x000ff00000209400ULL, 0x0000007300b67306ULL, 0x000ea20000205400ULL,
0x000000a37000720bULL, 0x002fe40003fbd000ULL, 0x000000719270723eULL, 0x000fc400000010ffULL,
0x000000a69171723eULL, 0x000fc600000010ffULL, 0x0000007200ac7306ULL, 0x000e68000020d400ULL,
0x000000706c30723cULL, 0x000f680000041830ULL, 0x0000007300b87306ULL, 0x000ee2000020d400ULL,
0x000000b6a900720bULL, 0x004fc60003f7d000ULL, 0x000000702850723cULL, 0x000f680000041850ULL,
0x0000007800b97306ULL, 0x000fe20000009400ULL, 0x00000001acac5812ULL, 0x002fce00078efcffULL,
0x0000007800bc7306ULL, 0x000e620000005400ULL, 0x00000001b8b83812ULL, 0x008fce00078efcffULL,
0x0000007900c27306ULL, 0x000ff00000009400ULL, 0x0000007900c37306ULL, 0x000ea20000005400ULL,
0x000000bcb900720bULL, 0x002fce0003fdd000ULL, 0x000000bb00b27306ULL, 0x000ff00000209400ULL,
0x000000bb00bd7306ULL, 0x000e620000205400ULL, 0x000000c3c200720bULL, 0x004fce0003f9d000ULL,
0x000000c400c57306ULL, 0x000ff00000209400ULL, 0x000000c400c67306ULL, 0x000ea20000205400ULL,
0x000000bdb200720bULL, 0x002fce0003fbd000ULL, 0x0000007800847306ULL, 0x0002f0000000d400ULL,
0x0000007900827306ULL, 0x0006e2000000d400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x000000c6c500720bULL, 0x004fc80003f7d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x000000bb00bf7306ULL, 0x000e62000020d400ULL, 0x0001000079797824ULL, 0x008fe200078e00ffULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x000000c1c000720bULL, 0x000fe40003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x000000c400c77306ULL, 0x000ea2000020d400ULL,
0x0000000182824812ULL, 0x000fce00078efcffULL, 0x0000007800727306ULL, 0x000fe20000209400ULL,
0x00000001bfbf5812ULL, 0x002fe400078efcffULL, 0x0000000183836812ULL, 0x000fe400078efcffULL,
0x00000084bf84723eULL, 0x000fc600000010ffULL, 0x0000007800737306ULL, 0x000e620000205400ULL,
0x00000001c7c73812ULL, 0x004fe400078efcffULL, 0x000000c9c800720bULL, 0x000fca0003f7d000ULL,
0x0000007900937306ULL, 0x000ff00000209400ULL, 0x0000007900967306ULL, 0x000ea20000205400ULL,
0x000000737200720bULL, 0x002fe40003fbd000ULL, 0x0000008cb573723eULL, 0x000fc400000010ffULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x00000090ad72723eULL, 0x000fe200000010ffULL,
0x0000007800be7306ULL, 0x000e6c000020d400ULL, 0x000000726c34723cULL, 0x000f640000041834ULL,
0x0000007900987306ULL, 0x000ee2000020d400ULL, 0x000000969300720bULL, 0x004fca0003f9d000ULL,
0x000000722854723cULL, 0x000f640000041854ULL, 0x0000007a008e7306ULL, 0x000fe20000009400ULL,
0x00000001bebe5812ULL, 0x002fc800078efcffULL, 0x000000be83be723eULL, 0x000fc600000010ffULL,
0x0000007a008f7306ULL, 0x000e620000005400ULL, 0x0000000198984812ULL, 0x008fc800078efcffULL,
0x0000009881bf723eULL, 0x000fc600000010ffULL, 0x0000007b00867306ULL, 0x000fe80000009400ULL,
0x000000be6c40723cULL, 0x000f680000041840ULL, 0x0000007b00897306ULL, 0x000ea20000005400ULL,
0x0000008f8e00720bULL, 0x002fc60003fdd000ULL, 0x000000be2860723cULL, 0x000f680000041860ULL,
0x0000000400787306ULL, 0x000ff00000209400ULL, 0x0000000400797306ULL, 0x000e620000205400ULL,
0x000000898600720bULL, 0x004fce0003f7d000ULL, 0x00000097009a7306ULL, 0x000ff00000209400ULL,
0x00000097009b7306ULL, 0x000ea20000205400ULL, 0x000000797800720bULL, 0x002fe40003fbd000ULL,
0x000000b88579723eULL, 0x000fc400000010ffULL, 0x000000ac8d78723eULL, 0x000fe400000010ffULL,
0x00000082c785723eULL, 0x000fe200000010ffULL, 0x0000007a007e7306ULL, 0x0002e8000000d400ULL,
0x000000786c38723cULL, 0x000f680000041838ULL, 0x0000000400957306ULL, 0x0006e2000020d400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x0000009b9a00720bULL, 0x004fc40003f9d000ULL,
0x000000846c3c723cULL, 0x000f64000004183cULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007b007c7306ULL, 0x000e62000000d400ULL, 0x000000949904723eULL, 0x008fe400000010ffULL,
0x000000017e7e6812ULL, 0x000fe200078efcffULL, 0x000000782858723cULL, 0x000b620000041858ULL,
0x000000888b00720bULL, 0x000fc60003fdd000ULL, 0x00000097009d7306ULL, 0x000ea2000020d400ULL,
0x0000000195955812ULL, 0x000fe400078efcffULL, 0x0000008a8700720bULL, 0x000fe20003fbd000ULL,
0x000000046c2c723cULL, 0x080f64000004182cULL, 0x000000080a797824ULL, 0x020fe400078e00ffULL,
0x0000007a007b7306ULL, 0x000fe20000209400ULL, 0x000000017c7c3812ULL, 0x002fe400078efcffULL,
0x000000017d7d6812ULL, 0x000fe200078efcffULL, 0x00000004284c723cULL, 0x000b68000004184cULL,
0x0000007a00947306ULL, 0x000e620000205400ULL, 0x000000019d9d4812ULL, 0x004fc400078efcffULL,
0x000000017f7f5812ULL, 0x000fe200078efcffULL, 0x000000010b057824ULL, 0x120fe200078e0202ULL,
0x00000084285c723cULL, 0x000f62000004185cULL, 0x000000010a047824ULL, 0x040fe400078e0202ULL,
0x0000009c00917306ULL, 0x000fe20000209400ULL, 0x000000080a027824ULL, 0x000fce00078e00ffULL,
0x0000009c008c7306ULL, 0x000ea20000205400ULL, 0x000000947b00720bULL, 0x002fe40003f9d000ULL,
0x0000007c9d7b723eULL, 0x000fca00000010ffULL, 0x0000007a00867306ULL, 0x0002f0000020d400ULL,
0x0000009c009c7306ULL, 0x000ee2000020d400ULL, 0x0000008c9100720bULL, 0x004fe40003f7d000ULL,
0x0000007e957a723eULL, 0x002fc400000010ffULL, 0x0000000186864812ULL, 0x008fca00078efcffULL,
0x0000007a6c44723cULL, 0x000f620000041844ULL, 0x000000867f7c723eULL, 0x000fc600000010ffULL,
0x000000019c9c3812ULL, 0x000fc800078efcffULL, 0x0000007a2864723cULL, 0x000f620000041864ULL,
0x0000009c7d7d723eULL, 0x000fce00000010ffULL, 0x0000007c6c48723cULL, 0x080b6e0000041848ULL,
0x000000080b6c7824ULL, 0x020fe200078e00ffULL, 0x0000007c2868723cULL, 0x000b620000041868ULL,
0x000000080a6f7824ULL, 0x040fe400078e00ffULL, 0x000000010a6d7824ULL, 0x000fe200078e0203ULL,
0xfffffff86c057812ULL, 0x000fc400078ee205ULL, 0xfffffff86f047812ULL, 0x000fe400078ee204ULL,
0x000160001a037811ULL, 0x000fe200078e68ffULL, 0x00000010056c7824ULL, 0x100fe200078e0200ULL,
0xfffffff802027812ULL, 0x000fe200078ee26dULL, 0x0000001004007824ULL, 0x000fe200078e0200ULL,
0x000000026d787810ULL, 0x000fc60007ffe0ffULL, 0x000000006c6c783bULL, 0x000e620000000200ULL,
0x0000001002707824ULL, 0x000fc600078e0203ULL, 0x000000000028783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7231ULL, 0x082fe400003400ffULL,
0x0000000f6e6e7231ULL, 0x000fe400003400ffULL, 0x0000000e6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000e6f6f7231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x088fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fc400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff879007812ULL, 0x004fe200078ee278ULL, 0x000000007070783bULL, 0x000ea20000004200ULL,
0xfffffff825257812ULL, 0x000fc600078ec0ffULL, 0x0000001000787824ULL, 0x000fcc00078e0203ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x0000007000987306ULL, 0x004fe20000009400ULL,
0x00000018ff7c7819ULL, 0x000fe20000011470ULL, 0x00000100709a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011471ULL, 0x00000100719f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011472ULL, 0x0000010072af7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe20000011473ULL, 0x00000070009b7306ULL, 0x000ea20000005400ULL,
0x00000018ffa67819ULL, 0x000fe2000001149fULL, 0x0000010073b27824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x008fe2000001147aULL, 0x0000010078c17824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011479ULL, 0x0000010079c47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe2000001147bULL, 0x0000007000957306ULL, 0x000662000000d400ULL,
0x00000018ff9a7819ULL, 0x000fc4000001149aULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ffb87819ULL, 0x000fe400000114b2ULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000007100a47306ULL, 0x000fe20000009400ULL, 0x0001000070707824ULL, 0x008fe200078e00ffULL,
0x0000009b9800720bULL, 0x004fe20003f7d000ULL, 0x000001007a9b7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe400000114c4ULL, 0x00000018ff707819ULL, 0x000fc40000011470ULL,
0x0000007100a57306ULL, 0x000ea20000005400ULL, 0x00000018ff9b7819ULL, 0x000fcc000001149bULL,
0x0000000195953812ULL, 0x002fe200078efcffULL, 0x0000007f00ab7306ULL, 0x000ff00000209400ULL,
0x0000007f00ae7306ULL, 0x000fe20000205400ULL, 0x000000a5a400720bULL, 0x004fce0003f9d000ULL,
0x0000007f008f7306ULL, 0x000ff0000020d400ULL, 0x000000a000877306ULL, 0x000ff00000209400ULL,
0x000000a0008a7306ULL, 0x000ff00000205400ULL, 0x000000a0007f7306ULL, 0x000ff0000020d400ULL,
0x00000070009f7306ULL, 0x000ff00000209400ULL, 0x0000007000a07306ULL, 0x000e700000205400ULL,
0x0000007100937306ULL, 0x0004f0000000d400ULL, 0x0000007c00a27306ULL, 0x000fe20000209400ULL,
0x0001000071717824ULL, 0x004fe200078e00ffULL, 0x000000a09f00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000007c00a37306ULL, 0x000fe20000205400ULL,
0x0000000193934812ULL, 0x008fe400078efcffULL, 0x000000aeab00720bULL, 0x000fca0003f9d000ULL,
0x0000007c00927306ULL, 0x0003f0000020d400ULL, 0x0000008100b47306ULL, 0x000fe20000209400ULL,
0x00000018ff7c7819ULL, 0x002fe40000011478ULL, 0x000000018f8f4812ULL, 0x000fca00078efcffULL,
0x0000008100b57306ULL, 0x000ff00000205400ULL, 0x00000081008d7306ULL, 0x000ff0000020d400ULL,
0x0000008800bd7306ULL, 0x000ff00000209400ULL, 0x0000008800c07306ULL, 0x000ff00000205400ULL,
0x0000008800857306ULL, 0x000ff0000020d400ULL, 0x0000007c00c67306ULL, 0x000ff00000209400ULL,
0x0000007c00c77306ULL, 0x000ff00000205400ULL, 0x0000007c00837306ULL, 0x000ff0000020d400ULL,
0x0000009c00907306ULL, 0x000ff00000209400ULL, 0x0000009c00917306ULL, 0x000ff00000205400ULL,
0x0000009c00817306ULL, 0x000ff0000020d400ULL, 0x000000a1008b7306ULL, 0x000ff00000209400ULL,
0x000000a100887306ULL, 0x000ff00000205400ULL, 0x000000a1007c7306ULL, 0x000ff0000020d400ULL,
0x0000009a009c7306ULL, 0x000ff00000209400ULL, 0x0000009a009d7306ULL, 0x000e700000205400ULL,
0x0000009a009e7306ULL, 0x000eb0000020d400ULL, 0x000000a600a77306ULL, 0x000fe20000209400ULL,
0x0000009d9c00720bULL, 0x002fce0003f1d000ULL, 0x000000a600a87306ULL, 0x000e6c0000205400ULL,
0x000000019e9e0812ULL, 0x004fe400078efcffULL, 0x000000a600aa7306ULL, 0x000ea2000020d400ULL,
0x000000a3a200720bULL, 0x000fce0003f1d000ULL, 0x0000007000a17306ULL, 0x000ee2000020d400ULL,
0x000000a8a700720bULL, 0x002fca0003fbd000ULL, 0x0000000192920812ULL, 0x000fe400078efcffULL,
0x00000071009a7306ULL, 0x000fec0000209400ULL, 0x00000001aaaa5812ULL, 0x004fe400078efcffULL,
0x0000007100a97306ULL, 0x000e620000205400ULL, 0x00000001a1a16812ULL, 0x008fce00078efcffULL,
0x000000af00a67306ULL, 0x000ff00000209400ULL, 0x000000af00b17306ULL, 0x000ea20000205400ULL,
0x000000a99a00720bULL, 0x002fce0003f7d000ULL, 0x0000007200ad7306ULL, 0x000ff00000009400ULL,
0x0000007200b07306ULL, 0x000e620000005400ULL, 0x000000b1a600720bULL, 0x004fce0003fdd000ULL,
0x00000072008e7306ULL, 0x0004f0000000d400ULL, 0x0000007100ac7306ULL, 0x000ee2000020d400ULL,
0x0001000072727824ULL, 0x004fe200078e00ffULL, 0x000000b0ad00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x000000af00b37306ULL, 0x000e6e000020d400ULL,
0x000000018e8e5812ULL, 0x008fe200078efcffULL, 0x0000007200707306ULL, 0x000fe20000209400ULL,
0x00000001acac3812ULL, 0x000fce00078efcffULL, 0x0000007200717306ULL, 0x000ea20000205400ULL,
0x00000001b3b36812ULL, 0x002fe400078efcffULL, 0x000000b5b400720bULL, 0x000fca0003fdd000ULL,
0x0000007300b67306ULL, 0x000ff00000009400ULL, 0x0000007300b77306ULL, 0x000e620000005400ULL,
0x000000717000720bULL, 0x004fe40003f9d000ULL, 0x000000018d8d6812ULL, 0x000fc400078efcffULL,
0x00000093aa71723eULL, 0x000fe400000010ffULL, 0x000000959e70723eULL, 0x000fe200000010ffULL,
0x00000073008c7306ULL, 0x0004ec000000d400ULL, 0x00000070284c723cULL, 0x000f64000004184cULL,
0x0000007200b27306ULL, 0x000ee2000020d400ULL, 0x0001000073737824ULL, 0x004fe200078e00ffULL,
0x000000b7b600720bULL, 0x002fc80003f7d000ULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x000000706c2c723cULL, 0x000f62000004182cULL, 0x0000007800bf7306ULL, 0x000fee0000009400ULL,
0x000000018c8c3812ULL, 0x008fe200078efcffULL, 0x0000007800c27306ULL, 0x000e620000005400ULL,
0x00000001b2b24812ULL, 0x000fce00078efcffULL, 0x000000b800b97306ULL, 0x000ff00000209400ULL,
0x000000b800ba7306ULL, 0x000ea20000205400ULL, 0x000000c2bf00720bULL, 0x002fce0003f9d000ULL,
0x000000b800bb7306ULL, 0x000e70000020d400ULL, 0x0000007300af7306ULL, 0x000fe20000209400ULL,
0x000000bab900720bULL, 0x004fce0003f1d000ULL, 0x0000007300bc7306ULL, 0x000eac0000205400ULL,
0x00000001bbbb0812ULL, 0x002fe400078efcffULL, 0x000000c100b87306ULL, 0x000fe20000209400ULL,
0x000000c0bd00720bULL, 0x000fce0003f1d000ULL, 0x000000c100c37306ULL, 0x000e620000205400ULL,
0x000000bcaf00720bULL, 0x004fca0003fbd000ULL, 0x0000000185850812ULL, 0x000fe400078efcffULL,
0x000000c800c97306ULL, 0x000ff00000209400ULL, 0x000000c800ca7306ULL, 0x000ea20000205400ULL,
0x000000c3b800720bULL, 0x002fce0003f7d000ULL, 0x0000007800847306ULL, 0x0002f0000000d400ULL,
0x0000007900967306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x000000cac900720bULL, 0x004fc80003fdd000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007900997306ULL, 0x000fe20000005400ULL, 0x0000000184844812ULL, 0x008fe400078efcffULL,
0x000000c7c600720bULL, 0x000fca0003f9d000ULL, 0x0000007900827306ULL, 0x0003f0000000d400ULL,
0x0000007300be7306ULL, 0x000ea2000020d400ULL, 0x0001000079797824ULL, 0x002fe200078e00ffULL,
0x0000000183834812ULL, 0x000fc800078efcffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x000000c100c57306ULL, 0x000e70000020d400ULL, 0x000000c800cb7306ULL, 0x000ee2000020d400ULL,
0x00000001bebe5812ULL, 0x004fc400078efcffULL, 0x000000999600720bULL, 0x000fca0003fbd000ULL,
0x0000007800727306ULL, 0x000fe20000209400ULL, 0x00000001c5c53812ULL, 0x002fc800078efcffULL,
0x00000084c584723eULL, 0x000fc600000010ffULL, 0x0000007800737306ULL, 0x000e620000205400ULL,
0x00000001cbcb6812ULL, 0x008fe400078efcffULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x000000919000720bULL, 0x000fc60003fbd000ULL, 0x0000007900c17306ULL, 0x000ff00000209400ULL,
0x0000007900cc7306ULL, 0x000ea20000205400ULL, 0x000000737200720bULL, 0x002fe40003f7d000ULL,
0x000000a19272723eULL, 0x000fc400000010ffULL, 0x000000ac8f73723eULL, 0x000fe400000010ffULL,
0x0000000181815812ULL, 0x000fe200078efcffULL, 0x0000007900987306ULL, 0x0002e2000020d400ULL,
0x0000008a8700720bULL, 0x000fc60003fbd000ULL, 0x000000722850723cULL, 0x080f680000041850ULL,
0x0000007b00867306ULL, 0x000fe20000009400ULL, 0x000001007b797824ULL, 0x002fe200078e00ffULL,
0x000000ccc100720bULL, 0x004fe40003fdd000ULL, 0x000000726c30723cULL, 0x000f640000041830ULL,
0x00000018ff797819ULL, 0x000fc40000011479ULL, 0x0000007b00897306ULL, 0x000e620000005400ULL,
0x000000017f7f5812ULL, 0x000fcc00078efcffULL, 0x0000000198986812ULL, 0x008fe200078efcffULL,
0x0000007800c47306ULL, 0x000ea6000020d400ULL, 0x0000009881c5723eULL, 0x000fca00000010ffULL,
0x0000009b00787306ULL, 0x000fe20000209400ULL, 0x000000898600720bULL, 0x002fce0003f9d000ULL,
0x0000009b009d7306ULL, 0x000e620000205400ULL, 0x00000001c4c43812ULL, 0x004fc800078efcffULL,
0x000000c483c4723eULL, 0x000fc600000010ffULL, 0x0000009b009f7306ULL, 0x000ea8000020d400ULL,
0x000000c42860723cULL, 0x080f680000041860ULL, 0x0000007a00977306ULL, 0x000fe20000009400ULL,
0x0000009d7800720bULL, 0x002fe40003f7d000ULL, 0x0000008eb378723eULL, 0x000fe200000010ffULL,
0x000000c46c40723cULL, 0x000f680000041840ULL, 0x0000007a00947306ULL, 0x000e6c0000005400ULL,
0x000000019f9f3812ULL, 0x004fc400078efcffULL, 0x00000079009c7306ULL, 0x000fe20000209400ULL,
0x000000888b00720bULL, 0x000fce0003f7d000ULL, 0x00000079009b7306ULL, 0x000ea20000205400ULL,
0x000000949700720bULL, 0x002fca0003f1d000ULL, 0x000000017c7c3812ULL, 0x000fe400078efcffULL,
0x0000007a007e7306ULL, 0x0002f0000000d400ULL, 0x0000007b007d7306ULL, 0x0006e2000000d400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x0000009b9c00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff9a7819ULL, 0x000fe4000001147aULL, 0x0000007900a07306ULL, 0x0002a2000020d400ULL,
0x000100007b7b7824ULL, 0x008fe200078e00ffULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x000000b28d7a723eULL, 0x000fe400000010ffULL, 0x00000018ff927819ULL, 0x000fe4000001147bULL,
0x0000009a00967306ULL, 0x000fe20000209400ULL, 0x000000017d7d4812ULL, 0x000fc400078efcffULL,
0x000000be857b723eULL, 0x000fe400000010ffULL, 0x00000082cb85723eULL, 0x000fe400000010ffULL,
0x0000008cbb79723eULL, 0x002fe200000010ffULL, 0x0000009a00937306ULL, 0x000e620000205400ULL,
0x00000001a0a06812ULL, 0x004fe200078efcffULL, 0x0000007a2858723cULL, 0x000f620000041858ULL,
0x0000007e9f82723eULL, 0x000fe400000010ffULL, 0x0000007da083723eULL, 0x000fc600000010ffULL,
0x00000092008f7306ULL, 0x000fe40000209400ULL, 0x000000782854723cULL, 0x040f6c0000041854ULL,
0x0000009200867306ULL, 0x000ea20000205400ULL, 0x000000939600720bULL, 0x002fe20003f1d000ULL,
0x00000084285c723cULL, 0x040f6c000004185cULL, 0x0000009a009a7306ULL, 0x000e64000020d400ULL,
0x000000822864723cULL, 0x000f6c0000041864ULL, 0x00000092009b7306ULL, 0x000ee2000020d400ULL,
0x000000868f00720bULL, 0x004fe20003fdd000ULL, 0x000000786c34723cULL, 0x000f620000041834ULL,
0x000000019a9a0812ULL, 0x002fce00078efcffULL, 0x0000007a6c38723cULL, 0x000f620000041838ULL,
0x0000009a7f9a723eULL, 0x000fc600000010ffULL, 0x000000019b9b6812ULL, 0x008fc800078efcffULL,
0x000000846c3c723cULL, 0x000f62000004183cULL, 0x0000009b7c9b723eULL, 0x000fce00000010ffULL,
0x000000826c44723cULL, 0x000f700000041844ULL, 0x0000009a2868723cULL, 0x080f700000041868ULL,
0x0000009a6c48723cULL, 0x000b6e0000041848ULL, 0x0001a6c81a6c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6e7224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x0000040014257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040014257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020257824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fc600078e02ffULL, 0xffffffe025297812ULL, 0x000fe200078ec0ffULL,
0x0000008024247824ULL, 0x000fc800078e00ffULL, 0x0000010016297824ULL, 0x000fca00078e0229ULL,
0x0000008029297810ULL, 0x000fc80007ffe0ffULL, 0x0000006029287812ULL, 0x000fca00078ec0ffULL,
0x0000000119707824ULL, 0x000fe200078e0228ULL, 0x000003f00000a947ULL, 0x000fea0003800000ULL,
0x0000001025727812ULL, 0x000fe400078ec0ffULL, 0x000000291e257217ULL, 0x000fe40007800000ULL,
0x00000003ff2b7819ULL, 0x000fe4000001161fULL, 0x0000620024717a11ULL, 0x000fe200078838ffULL,
0x0000000125257824ULL, 0x000fe200078e0a29ULL, 0x000000042b2a7810ULL, 0x040fe20007ffe0ffULL,
0x000000012b287824ULL, 0x040fe200078e0272ULL, 0x000000082b6f7810ULL, 0x000fc40007ffe0ffULL,
0x0000002572257217ULL, 0x000fe20007800000ULL, 0x0000000128297824ULL, 0x040fe200078e021fULL,
0x0000000c2b7b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000828787824ULL, 0x000fe200078e00ffULL,
0x0000630024737a11ULL, 0x000fe200020f3cffULL, 0x0000000125257824ULL, 0x100fe400078e0a72ULL,
0x000000012a797824ULL, 0x000fe200078e0272ULL, 0xfffffff878787812ULL, 0x000fe200078ee229ULL,
0x0000000128287824ULL, 0x100fe200078e0270ULL, 0x000000252a00720cULL, 0x080fe20003f66070ULL,
0x00000001792a7824ULL, 0x000fe200078e0270ULL, 0x000000252b00720cULL, 0x080fe20003f06070ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000256f00720cULL, 0x000fc60003f86070ULL,
0x000000016f7a7824ULL, 0x000fe200078e0272ULL, 0x00000013286e7212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x0000006e716e7210ULL, 0x000fe20007fbe0ffULL,
0x000000017a6c7824ULL, 0x000fe200078e0270ULL, 0x000000132a2a7212ULL, 0x000fe200078efcffULL,
0x000000017b727824ULL, 0x000fe400078e0272ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x000000712a2a7210ULL, 0x000fc60007fde0ffULL, 0x0000000172287824ULL, 0x000fe200078e0270ULL,
0x000000136c6c7212ULL, 0x000fe200078efcffULL, 0x00000001296f7824ULL, 0x000fe200028e0673ULL,
0x000000257b00720cULL, 0x000fe20003fa6070ULL, 0x0000000179707824ULL, 0x040fe400078e021fULL,
0x0000000879797824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff879707812ULL, 0x000fe200078ee270ULL, 0x000000012b2b7824ULL, 0x000fe200030e0673ULL,
0x000000716c6c7210ULL, 0x000fe20007fde0ffULL, 0x000000017a257824ULL, 0x100fe200078e021fULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000087a7a7824ULL, 0x000fe400078e00ffULL,
0x0000000172797824ULL, 0x040fe400078e021fULL, 0x00000008727c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a727812ULL, 0x000fe200078ee225ULL, 0x000000016d6d7824ULL, 0x000fe200030e0673ULL,
0x0000007128287210ULL, 0x000fe20007fde0ffULL, 0x0000001078257824ULL, 0x000fe200078e0203ULL,
0xfffffff87c787812ULL, 0x000fe200078ee279ULL, 0x0000001070717824ULL, 0x000fc400078e0203ULL,
0x0000000129297824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e257faeULL, 0x0003e2000c101c48ULL, 0x0000001072737824ULL, 0x100fe400078e0203ULL,
0x0000001078797824ULL, 0x000fe200078e0203ULL, 0x000000002a717faeULL, 0x0003e8000d901c48ULL,
0x000000006c737faeULL, 0x0003e8000e101c48ULL, 0x0000000028797faeULL, 0x0003e2000e901c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001025287812ULL, 0x000fc800078ec0ffULL,
0x000000281f257211ULL, 0x000fc800078fe8ffULL, 0x00000004252b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000125297824ULL, 0x040fe200078e021fULL, 0x0000000c256d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000825727824ULL, 0x040fe400078e00ffULL, 0x0000000125287824ULL, 0x100fe400078e0270ULL,
0x000000012b2a7824ULL, 0x040fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee229ULL,
0x000000082b787824ULL, 0x000fe200078e00ffULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000000012b257824ULL, 0x000fc400078e021fULL, 0x000000016d6f7824ULL, 0x100fe400078e021fULL,
0x00000001296c7824ULL, 0x040fe400078e0270ULL, 0x00000001292b7824ULL, 0x040fe400078e021fULL,
0x00000008297a7824ULL, 0x000fe400078e00ffULL, 0x000000086d7c7824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x000000016d6e7824ULL, 0x000fe200078e0270ULL,
0xfffffff878707812ULL, 0x000fe200078ee225ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff87a787812ULL, 0x000fe400078ee22bULL, 0x0000620024257a11ULL, 0x000fe200078038ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe400078ee26fULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x0000630024717a11ULL, 0x000fc400000f3cffULL, 0x0000002825287210ULL, 0x000fe20007f1e0ffULL,
0x0000001078737824ULL, 0x100fe200078e0203ULL, 0x000000132a2a7212ULL, 0x080fe200078efcffULL,
0x000000107a797824ULL, 0x000fe200078e0203ULL, 0x000000136c6c7212ULL, 0x080fe200078efcffULL,
0x0000000129297824ULL, 0x000fe200000e0671ULL, 0x000000136e6e7212ULL, 0x000fe400078efcffULL,
0x0000002a252a7210ULL, 0x040fe40007f7e0ffULL, 0x0000006c256c7210ULL, 0x000fc40007f1e0ffULL,
0x0000006e256e7210ULL, 0x000fe20007f9e0ffULL, 0x000000012b2b7824ULL, 0x000fe400018e0671ULL,
0x0000001072257824ULL, 0x000fe400078e0203ULL, 0x000000016d6d7824ULL, 0x100fe400000e0671ULL,
0x000000016f6f7824ULL, 0x000fe200020e0671ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028257faeULL, 0x0003e2000b901c48ULL, 0x0000001070717824ULL, 0x000fca00078e0203ULL,
0x000000002a717faeULL, 0x0003e8000b901c48ULL, 0x000000006c737faeULL, 0x0003e8000b901c48ULL,
0x000000006e797faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000100503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000106c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a62800236e7f8cULL, 0x000664000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x01a62c0023257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fc4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c0023257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002020257824ULL, 0x000fca00078e00ffULL,
0xffffff8025287812ULL, 0x000fc800078ec0ffULL, 0x0000008013257810ULL, 0x000fca0007ffe028ULL,
0x0000000112257824ULL, 0x000fca00078e0225ULL, 0x01a00000256e7984ULL, 0x000e680000000800ULL,
0x01a20000256f7984ULL, 0x0006a20000000800ULL, 0x000000216e00720bULL, 0x002fe20003f1d000ULL,
0x000165a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000117297810ULL, 0x000fe40007ffe0ffULL, 0x000000216e00720bULL, 0x000fe40003f74000ULL,
0x000000202900720cULL, 0x000fe20003f05270ULL, 0x000165727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000727806ULL, 0x000fc400018e0100ULL, 0x0000008020298824ULL, 0x000fe200078e0213ULL,
0x000000216e288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000112298824ULL, 0x000fca00078e0229ULL, 0x01a4002829008388ULL, 0x0003e20000000800ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x000000216e287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff72ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002128287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800717308ULL, 0x000e640000000800ULL,
0x0000007122227220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x000164b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2971297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0072ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x000163a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2971297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000072ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x000162927f007947ULL, 0x000fea000b800000ULL,
0x00001f2971297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000072ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x000161927f007947ULL, 0x000fea000b800000ULL,
0x00001f2971297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007225ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff707424ULL, 0x000fe200078e00ffULL,
0x000000216e217209ULL, 0x000fd60007810000ULL, 0x800000216e6e0221ULL, 0x000fe20000010000ULL,
0x00007610ff700816ULL, 0x000fc60000000070ULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00110308ULL, 0x000e640000000800ULL, 0x000000116f6f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000226f227221ULL, 0x004fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0000000820257824ULL, 0x000fca00078e00ffULL,
0xfffffff0256e7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006e257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016f6f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006e257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991070257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x00015d727f007947ULL, 0x000fea000b800000ULL,
0x00001f250c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x00015dc27f007947ULL, 0x000fea000b800000ULL, 0x00000010250d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001825297810ULL, 0x002fe20007ffe0ffULL, 0x00015e527f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x0000040020257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100020267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026277812ULL, 0x000fe400078ec0ffULL, 0x0001300025267810ULL, 0x000fe40007ffe0ffULL,
0x0001700027257810ULL, 0x000fc60007ffe0ffULL, 0x0000001009707824ULL, 0x100fe400078e0226ULL,
0x0000001008287824ULL, 0x000fe400078e0226ULL, 0x0000001007787824ULL, 0x000fe400078e0225ULL,
0x000000007070783bULL, 0x008ee80000000200ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707231ULL, 0x08cfe400003400ffULL,
0x0000000f72727231ULL, 0x000fc400003400ffULL, 0x0000000e71717231ULL, 0x080fe400003400ffULL,
0x0000000e73737231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x082fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fe400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010067c7824ULL, 0x000fe200078e0225ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000f9000007945ULL, 0x000fe80003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x0000010078977824ULL, 0x010fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001147aULL,
0x00000100799a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011478ULL,
0x0000007800957306ULL, 0x000fe20000009400ULL, 0x00000018ff987819ULL, 0x008fe2000001147dULL,
0x000001007aab7824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe20000011497ULL,
0x000001007bae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x000fe2000001149aULL,
0x000001007cbd7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001147bULL,
0x0000008300b07306ULL, 0x000fe20000209400ULL, 0x00000018ffa57819ULL, 0x000fe2000001147fULL,
0x000001007dc07824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc40000011479ULL,
0x00000018ff9d7819ULL, 0x000fe4000001147eULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000008300b17306ULL, 0x000fe20000205400ULL, 0x00000018ffb47819ULL, 0x000fe400000114aeULL,
0x00000018ffbd7819ULL, 0x000fe400000114bdULL, 0x00000018ffc67819ULL, 0x000fc600000114c0ULL,
0x00000083008f7306ULL, 0x000ff0000020d400ULL, 0x0000009800ca7306ULL, 0x000ff00000209400ULL,
0x0000009800cb7306ULL, 0x000ff00000205400ULL, 0x0000009800837306ULL, 0x000ff0000020d400ULL,
0x0000009700987306ULL, 0x000ff00000209400ULL, 0x0000009700997306ULL, 0x000ef00000205400ULL,
0x00000027009c7306ULL, 0x000ff00000209400ULL, 0x00000027009f7306ULL, 0x000fe20000205400ULL,
0x000000999800720bULL, 0x008fce0003fbd000ULL, 0x0000002700947306ULL, 0x0007f0000020d400ULL,
0x0000007800967306ULL, 0x000f220000005400ULL, 0x00000018ff277819ULL, 0x008fce000001147cULL,
0x00000078006e7306ULL, 0x0006b0000000d400ULL, 0x00000079009e7306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x000000969500720bULL, 0x010fc80003fdd000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900a17306ULL, 0x000eee0000005400ULL,
0x000000016e6e6812ULL, 0x004fe200078efcffULL, 0x000000a000a27306ULL, 0x000fe20000209400ULL,
0x0000009f9c00720bULL, 0x000fce0003fdd000ULL, 0x000000a000a37306ULL, 0x000ea20000205400ULL,
0x000000a19e00720bULL, 0x008fca0003f9d000ULL, 0x0000000194946812ULL, 0x000fe400078efcffULL,
0x0000008a00b97306ULL, 0x000ff00000209400ULL, 0x0000008a00bc7306ULL, 0x000fe20000205400ULL,
0x000000a3a200720bULL, 0x004fce0003f7d000ULL, 0x0000008a00877306ULL, 0x000ff0000020d400ULL,
0x0000002700c27306ULL, 0x000ff00000209400ULL, 0x0000002700c37306ULL, 0x000ff00000205400ULL,
0x0000002700857306ULL, 0x000ff0000020d400ULL, 0x000000a5008d7306ULL, 0x000ff00000209400ULL,
0x000000a5008a7306ULL, 0x000ff00000205400ULL, 0x000000a500277306ULL, 0x0005f0000020d400ULL,
0x0000008200a77306ULL, 0x000fe20000209400ULL, 0x0001000079a57824ULL, 0x004fca00078e00ffULL,
0x00000018ffa57819ULL, 0x000fe400000114a5ULL, 0x0000008200aa7306ULL, 0x000ff00000205400ULL,
0x0000008200937306ULL, 0x000ff0000020d400ULL, 0x0000009d00897306ULL, 0x000ff00000209400ULL,
0x0000009d008c7306ULL, 0x000ff00000205400ULL, 0x0000009d00827306ULL, 0x000ff0000020d400ULL,
0x00000097009b7306ULL, 0x000eb0000020d400ULL, 0x00000078009a7306ULL, 0x000ff00000209400ULL,
0x00000078009d7306ULL, 0x000ee20000205400ULL, 0x000000019b9b5812ULL, 0x004fc800078efcffULL,
0x0000006e9b6e723eULL, 0x000fc600000010ffULL, 0x00000079006f7306ULL, 0x000eb0000000d400ULL,
0x000000a000a47306ULL, 0x000f22000020d400ULL, 0x0000009d9a00720bULL, 0x008fe20003fbd000ULL,
0x000100007f9d7824ULL, 0x000fcc00078e00ffULL, 0x000000a500977306ULL, 0x000fe20000209400ULL,
0x000000016f6f4812ULL, 0x004fe400078efcffULL, 0x000000aaa700720bULL, 0x000fca0003f9d000ULL,
0x000000a500a67306ULL, 0x000ea20000205400ULL, 0x00000001a4a43812ULL, 0x010fc800078efcffULL,
0x0000006fa46f723eULL, 0x000fc600000010ffULL, 0x0000007800797306ULL, 0x000ee2000020d400ULL,
0x0000000193934812ULL, 0x000fc600078efcffULL, 0x0000006e702c723cULL, 0x000f68000004182cULL,
0x000000ab00a07306ULL, 0x000fe20000209400ULL, 0x000000a69700720bULL, 0x004fc60003f7d000ULL,
0x0000006e284c723cULL, 0x002f68000004184cULL, 0x000000ab00ad7306ULL, 0x000e620000205400ULL,
0x0000000179795812ULL, 0x008fce00078efcffULL, 0x000000a500a87306ULL, 0x000eb0000020d400ULL,
0x0000007a00a97306ULL, 0x000fe20000009400ULL, 0x000000ada000720bULL, 0x002fce0003fbd000ULL,
0x0000007a00ac7306ULL, 0x000e620000005400ULL, 0x00000001a8a83812ULL, 0x004fce00078efcffULL,
0x0000007a00927306ULL, 0x0004f0000000d400ULL, 0x0000007b00b27306ULL, 0x000fe20000009400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x000000aca900720bULL, 0x002fc80003fdd000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007b00b37306ULL, 0x000e6e0000005400ULL,
0x0000000192926812ULL, 0x008fe200078efcffULL, 0x000000b400b57306ULL, 0x000fe20000209400ULL,
0x000000b1b000720bULL, 0x000fce0003fdd000ULL, 0x000000b400b67306ULL, 0x000ea20000205400ULL,
0x000000b3b200720bULL, 0x002fca0003f9d000ULL, 0x000000018f8f6812ULL, 0x000fe400078efcffULL,
0x0000007b008e7306ULL, 0x0002f0000000d400ULL, 0x000000ab00af7306ULL, 0x000f22000020d400ULL,
0x000100007b7b7824ULL, 0x002fe200078e00ffULL, 0x000000b6b500720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x000000018e8e4812ULL, 0x008fe400078efcffULL, 0x000000bcb900720bULL, 0x000fca0003f9d000ULL,
0x0000007a00a57306ULL, 0x000e620000205400ULL, 0x00000001afaf5812ULL, 0x010fce00078efcffULL,
0x000000b400b77306ULL, 0x000ea2000020d400ULL, 0x0000000187874812ULL, 0x000fce00078efcffULL,
0x0000007b00ab7306ULL, 0x000fe20000209400ULL, 0x000000a57800720bULL, 0x002fe40003fbd000ULL,
0x000000799478723eULL, 0x000fe400000010ffULL, 0x00000018ff947819ULL, 0x000fe4000001149dULL,
0x000000a89379723eULL, 0x000fe200000010ffULL, 0x0000007b00b87306ULL, 0x000e620000205400ULL,
0x00000001b7b73812ULL, 0x004fca00078efcffULL, 0x000000787030723cULL, 0x080f640000041830ULL,
0x0000007a00ae7306ULL, 0x000eac000020d400ULL, 0x000000782850723cULL, 0x000f640000041850ULL,
0x000000bd00b47306ULL, 0x000fe20000209400ULL, 0x000000b8ab00720bULL, 0x002fce0003f7d000ULL,
0x000000bd00bf7306ULL, 0x000e620000205400ULL, 0x00000001aeae5812ULL, 0x004fce00078efcffULL,
0x0000007b00ba7306ULL, 0x000eb0000020d400ULL, 0x0000007c00bb7306ULL, 0x000fe20000009400ULL,
0x000000bfb400720bULL, 0x002fce0003fbd000ULL, 0x0000007c00be7306ULL, 0x000e620000005400ULL,
0x00000001baba3812ULL, 0x004fce00078efcffULL, 0x0000007c00867306ULL, 0x0004f0000000d400ULL,
0x0000007d00c47306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000bebb00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00c57306ULL, 0x000e6e0000005400ULL, 0x0000000186866812ULL, 0x008fe200078efcffULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x000000c3c200720bULL, 0x000fce0003fdd000ULL,
0x000000c600c87306ULL, 0x000ea20000205400ULL, 0x000000c5c400720bULL, 0x002fca0003f9d000ULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x0000007d00847306ULL, 0x0002f0000000d400ULL,
0x000000bd00c17306ULL, 0x000f22000020d400ULL, 0x000100007d7d7824ULL, 0x002fe200078e00ffULL,
0x000000c8c700720bULL, 0x004fc80003f7d000ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x0000000184844812ULL, 0x008fce00078efcffULL,
0x0000007c007b7306ULL, 0x000e620000205400ULL, 0x00000001c1c15812ULL, 0x010fc800078efcffULL,
0x00000086c186723eULL, 0x000fc600000010ffULL, 0x000000c600c97306ULL, 0x000eb0000020d400ULL,
0x0000007c00c07306ULL, 0x000722000020d400ULL, 0x0000007b7a00720bULL, 0x002fe40003fbd000ULL,
0x0000008eb77b723eULL, 0x000fc400000010ffULL, 0x00000092af7a723eULL, 0x000fc600000010ffULL,
0x0000007d00957306ULL, 0x000fe20000209400ULL, 0x000001007e7c7824ULL, 0x008fe200078e00ffULL,
0x00000001c9c93812ULL, 0x004fe400078efcffULL, 0x000000cbca00720bULL, 0x000fe20003f7d000ULL,
0x0000007a7034723cULL, 0x000f620000041834ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00967306ULL, 0x000e620000205400ULL, 0x00000001c0c05812ULL, 0x010fc800078efcffULL,
0x000000c085c0723eULL, 0x000fe200000010ffULL, 0x0000007a2854723cULL, 0x000f640000041854ULL,
0x0000007d00987306ULL, 0x0004e2000020d400ULL, 0x0000000183833812ULL, 0x000fce00078efcffULL,
0x0000007c00977306ULL, 0x000fe20000209400ULL, 0x000001007f7d7824ULL, 0x004fe200078e00ffULL,
0x000000969500720bULL, 0x002fc80003f9d000ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007c009a7306ULL, 0x000e6e0000205400ULL, 0x0000000198984812ULL, 0x008fe200078efcffULL,
0x0000007c009c7306ULL, 0x000ea6000020d400ULL, 0x0000009883c1723eULL, 0x000fca00000010ffULL,
0x0000007e00907306ULL, 0x000fe20000009400ULL, 0x0000009a9700720bULL, 0x002fe20003fbd000ULL,
0x000000c07040723cULL, 0x080f6c0000041840ULL, 0x0000007e00917306ULL, 0x000e640000005400ULL,
0x000000c02860723cULL, 0x000f680000041860ULL, 0x000000019c9c5812ULL, 0x004fc400078efcffULL,
0x0000007f00887306ULL, 0x000fe20000009400ULL, 0x0000008c8900720bULL, 0x000fce0003fbd000ULL,
0x0000007f008b7306ULL, 0x000ea20000005400ULL, 0x000000919000720bULL, 0x002fca0003fdd000ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x0000007d00997306ULL, 0x000ff00000209400ULL,
0x0000007d007c7306ULL, 0x000e620000205400ULL, 0x0000008b8800720bULL, 0x004fce0003f7d000ULL,
0x0000007e00817306ULL, 0x0004f0000000d400ULL, 0x0000007f00257306ULL, 0x000f22000000d400ULL,
0x000100007e7e7824ULL, 0x004fe200078e00ffULL, 0x0000007c9900720bULL, 0x002fc40003f9d000ULL,
0x000000ae8f7c723eULL, 0x000fe400000010ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007d00a07306ULL, 0x0002a2000020d400ULL, 0x0000000181816812ULL, 0x008fe400078efcffULL,
0x0000008a8d00720bULL, 0x000fe40003fdd000ULL, 0x000000819c9c723eULL, 0x000fc600000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000000125253812ULL, 0x010fe400078efcffULL,
0x000000ba877d723eULL, 0x002fe400000010ffULL, 0x00000084c987723eULL, 0x000fc600000010ffULL,
0x0000007e009e7306ULL, 0x000e620000205400ULL, 0x00000001a0a04812ULL, 0x004fe200078efcffULL,
0x0000007c7038723cULL, 0x040f620000041838ULL, 0x0000000127276812ULL, 0x000fe400078efcffULL,
0x00000025a09d723eULL, 0x000fe400000010ffULL, 0x0000100003257810ULL, 0x000fe20007ffe0ffULL,
0x0000009400937306ULL, 0x000fe40000209400ULL, 0x00000086703c723cULL, 0x040f6c000004183cULL,
0x00000094008e7306ULL, 0x000ea20000205400ULL, 0x0000009e7f00720bULL, 0x002fe20003f9d000ULL,
0x0000009c7044723cULL, 0x000f6c0000041844ULL, 0x0000007e00897306ULL, 0x000e64000020d400ULL,
0x0000007c2858723cULL, 0x040f6c0000041858ULL, 0x0000009400947306ULL, 0x000ee2000020d400ULL,
0x0000008e9300720bULL, 0x004fe20003f7d000ULL, 0x00000086285c723cULL, 0x000f62000004185cULL,
0x0000000189894812ULL, 0x002fce00078efcffULL, 0x0000009c2864723cULL, 0x000f620000041864ULL,
0x000000898282723eULL, 0x000fc600000010ffULL, 0x0000000194943812ULL, 0x008fc800078efcffULL,
0x000000942783723eULL, 0x000fe200000010ffULL, 0x0000001004277824ULL, 0x000fcc00078e0226ULL,
0x000000827048723cULL, 0x080b6e0000041848ULL, 0x0000001005707824ULL, 0x020fe200078e0226ULL,
0x000000822868723cULL, 0x000b620000041868ULL, 0x0000001002267824ULL, 0x000fe200078e0225ULL,
0x000000002728783bULL, 0x0202a80000000200ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fd80003800000ULL, 0x0000000f70707231ULL, 0x088fe400003400ffULL,
0x0000000f72727231ULL, 0x000fc400003400ffULL, 0x0000000e71717231ULL, 0x080fe400003400ffULL,
0x0000000e73737231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x084fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fe400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010007c7824ULL, 0x000fe200078e0225ULL, 0x000000002678783bULL, 0x000f2a0000004200ULL,
0x000000007c7c783bULL, 0x000e620000004200ULL, 0x00000078009e7306ULL, 0x010fe20000009400ULL,
0x00000018ff817819ULL, 0x000fe20000011478ULL, 0x0000010078a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011479ULL, 0x0000010079a47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x002fe2000001147eULL, 0x000001007ab47824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe2000001147aULL, 0x00000078009f7306ULL, 0x000e620000005400ULL,
0x00000018ffab7819ULL, 0x000fe200000114a4ULL, 0x000001007bb77824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe2000001147dULL, 0x000001007cc47824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001147bULL, 0x000001007dc77824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x0000007800967306ULL, 0x0008e2000000d400ULL,
0x00000018ffa67819ULL, 0x000fe2000001147fULL, 0x000100007dcb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fc400000114b4ULL, 0x00000018ffbd7819ULL, 0x000fe400000114b7ULL,
0x00000018ffc47819ULL, 0x000fe200000114c4ULL, 0x0000007900a97306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x010fe200078e00ffULL, 0x0000009f9e00720bULL, 0x002fe20003f7d000ULL,
0x000001007e9e7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe400000114c7ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900aa7306ULL, 0x000e620000005400ULL,
0x00000018ffcb7819ULL, 0x000fc400000114cbULL, 0x00000018ff9e7819ULL, 0x000fc8000001149eULL,
0x0000000196963812ULL, 0x008fe200078efcffULL, 0x0000008300b07306ULL, 0x000ff00000209400ULL,
0x0000008300b37306ULL, 0x000fe20000205400ULL, 0x000000aaa900720bULL, 0x002fce0003f9d000ULL,
0x0000008300927306ULL, 0x000ff0000020d400ULL, 0x000000a500897306ULL, 0x000ff00000209400ULL,
0x000000a5008c7306ULL, 0x000ff00000205400ULL, 0x000000a500837306ULL, 0x000ff0000020d400ULL,
0x0000007800a47306ULL, 0x000ff00000209400ULL, 0x0000007800a57306ULL, 0x000e700000205400ULL,
0x00000079006f7306ULL, 0x000730000000d400ULL, 0x0000008100a77306ULL, 0x000fe20000209400ULL,
0x0001000079797824ULL, 0x008fe200078e00ffULL, 0x000000a5a400720bULL, 0x002fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000008100a87306ULL, 0x000fe20000205400ULL,
0x000000016f6f4812ULL, 0x010fe400078efcffULL, 0x000000b3b000720bULL, 0x000fca0003f9d000ULL,
0x0000008100957306ULL, 0x0003f0000020d400ULL, 0x0000008400b97306ULL, 0x000fe20000209400ULL,
0x00000018ff817819ULL, 0x002fe4000001147cULL, 0x0000000192924812ULL, 0x000fca00078efcffULL,
0x0000008400ba7306ULL, 0x000ff00000205400ULL, 0x0000008400907306ULL, 0x000ff0000020d400ULL,
0x000000a100937306ULL, 0x000ff00000209400ULL, 0x000000a100947306ULL, 0x000ff00000205400ULL,
0x000000a100847306ULL, 0x000ff0000020d400ULL, 0x000000a000a17306ULL, 0x000ff00000209400ULL,
0x000000a000a27306ULL, 0x000e700000205400ULL, 0x0000008a00c27306ULL, 0x000ff00000209400ULL,
0x0000008a00c57306ULL, 0x000fe20000205400ULL, 0x000000a2a100720bULL, 0x002fce0003f1d000ULL,
0x0000008a00887306ULL, 0x000ff0000020d400ULL, 0x00000081009c7306ULL, 0x000ff00000209400ULL,
0x00000081009b7306ULL, 0x000ff00000205400ULL, 0x0000008100867306ULL, 0x000ff0000020d400ULL,
0x000000a6008b7306ULL, 0x000ff00000209400ULL, 0x000000a6008a7306ULL, 0x000ff00000205400ULL,
0x000000a600817306ULL, 0x000ff0000020d400ULL, 0x000000a000a37306ULL, 0x000e70000020d400ULL,
0x000000ab00ac7306ULL, 0x000ff00000209400ULL, 0x000000ab00ad7306ULL, 0x000ee20000205400ULL,
0x00000001a3a30812ULL, 0x002fc400078efcffULL, 0x000000a8a700720bULL, 0x000fca0003f1d000ULL,
0x000000ab00ae7306ULL, 0x000e70000020d400ULL, 0x0000007800a67306ULL, 0x000f22000020d400ULL,
0x000000adac00720bULL, 0x008fe40003fbd000ULL, 0x0000000195950812ULL, 0x000fca00078efcffULL,
0x0000007900a07306ULL, 0x000fec0000209400ULL, 0x00000001aeae5812ULL, 0x002fe400078efcffULL,
0x0000007900af7306ULL, 0x000e620000205400ULL, 0x00000001a6a66812ULL, 0x010fe400078efcffULL,
0x0000006fae6f723eULL, 0x000fca00000010ffULL, 0x000000b400ab7306ULL, 0x000ff00000209400ULL,
0x000000b400b67306ULL, 0x000ee20000205400ULL, 0x000000afa000720bULL, 0x002fe20003f7d000ULL,
0x000001007fa07824ULL, 0x000fca00078e00ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x0000007a00b27306ULL, 0x000ff00000009400ULL, 0x0000007a00b57306ULL, 0x000e620000005400ULL,
0x000000b6ab00720bULL, 0x008fce0003fdd000ULL, 0x0000007a00917306ULL, 0x000730000000d400ULL,
0x0000007900b17306ULL, 0x000ea2000020d400ULL, 0x000100007a7a7824ULL, 0x008fe200078e00ffULL,
0x000000b5b200720bULL, 0x002fc80003fbd000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x000000b400b87306ULL, 0x000e6e000020d400ULL, 0x0000000191915812ULL, 0x010fe200078efcffULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x00000001b1b13812ULL, 0x004fce00078efcffULL,
0x0000007a00797306ULL, 0x000ea20000205400ULL, 0x00000001b8b86812ULL, 0x002fe400078efcffULL,
0x000000bab900720bULL, 0x000fca0003fdd000ULL, 0x0000007b00bb7306ULL, 0x000ff00000009400ULL,
0x0000007b00bc7306ULL, 0x000e620000005400ULL, 0x000000797800720bULL, 0x004fe20003f9d000ULL,
0x000100007f797824ULL, 0x000fe200078e00ffULL, 0x0000000190906812ULL, 0x000fc400078efcffULL,
0x000000a69578723eULL, 0x000fe400000010ffULL, 0x00000018ff957819ULL, 0x000fe20000011479ULL,
0x0000007b008f7306ULL, 0x0004e2000000d400ULL, 0x000000b19279723eULL, 0x000fce00000010ffULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x000000bcbb00720bULL, 0x002fe20003f7d000ULL, 0x000000787030723cULL, 0x080f660000041830ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000bd00bf7306ULL, 0x000e660000205400ULL,
0x000000782850723cULL, 0x000f680000041850ULL, 0x000000018f8f3812ULL, 0x008fe200078efcffULL,
0x0000007a00b77306ULL, 0x000eb0000020d400ULL, 0x0000007c009d7306ULL, 0x000fe20000009400ULL,
0x000000bfbe00720bULL, 0x002fce0003f1d000ULL, 0x0000007c009a7306ULL, 0x000e620000005400ULL,
0x00000001b7b74812ULL, 0x004fc800078efcffULL, 0x000000b79090723eULL, 0x000fc600000010ffULL,
0x000000bd00c07306ULL, 0x000eb0000020d400ULL, 0x0000007b00b47306ULL, 0x000fe20000209400ULL,
0x0000009a9d00720bULL, 0x002fce0003f9d000ULL, 0x0000007b00c17306ULL, 0x000e620000205400ULL,
0x00000001c0c00812ULL, 0x004fe400078efcffULL, 0x000000c5c200720bULL, 0x000fca0003f1d000ULL,
0x000000c400bd7306ULL, 0x000ff00000209400ULL, 0x000000c400c67306ULL, 0x000ea20000205400ULL,
0x000000c1b400720bULL, 0x002fe40003fbd000ULL, 0x0000000188880812ULL, 0x000fca00078efcffULL,
0x000000c700c97306ULL, 0x000ff00000209400ULL, 0x000000c700ca7306ULL, 0x000e620000205400ULL,
0x000000c6bd00720bULL, 0x004fce0003f7d000ULL, 0x0000007c00877306ULL, 0x0004f0000000d400ULL,
0x0000007b00c37306ULL, 0x000f22000020d400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000cac900720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x000000c400c87306ULL, 0x000e62000020d400ULL, 0x0000000187874812ULL, 0x008fe400078efcffULL,
0x0000009b9c00720bULL, 0x000fca0003f9d000ULL, 0x000000c700cc7306ULL, 0x000ea2000020d400ULL,
0x00000001c3c35812ULL, 0x010fce00078efcffULL, 0x0000007d00987306ULL, 0x000fe20000009400ULL,
0x00000001c8c83812ULL, 0x002fe400078efcffULL, 0x0000000186864812ULL, 0x000fe400078efcffULL,
0x00000087c8c8723eULL, 0x000fc600000010ffULL, 0x0000007d00997306ULL, 0x000e620000005400ULL,
0x00000001cccc6812ULL, 0x004fce00078efcffULL, 0x0000007c007a7306ULL, 0x000ff00000209400ULL,
0x0000007c007b7306ULL, 0x000ea20000205400ULL, 0x000000999800720bULL, 0x002fce0003fbd000ULL,
0x000000cb00c47306ULL, 0x000ff00000209400ULL, 0x000000cb00cd7306ULL, 0x000e620000205400ULL,
0x0000007b7a00720bULL, 0x004fe40003f7d000ULL, 0x00000091b87a723eULL, 0x000fc400000010ffULL,
0x000000c38891723eULL, 0x000fe400000010ffULL, 0x0000008fc07b723eULL, 0x000fe200000010ffULL,
0x0000007e00977306ULL, 0x000fe80000009400ULL, 0x000000907038723cULL, 0x000f680000041838ULL,
0x0000007e006e7306ULL, 0x000ea20000005400ULL, 0x000000cdc400720bULL, 0x002fc60003fdd000ULL,
0x0000007a7034723cULL, 0x080f680000041834ULL, 0x0000007f008d7306ULL, 0x000fe80000009400ULL,
0x0000007a2854723cULL, 0x000f680000041854ULL, 0x0000007f008e7306ULL, 0x000e620000005400ULL,
0x0000006e9700720bULL, 0x004fc40003f1d000ULL, 0x00000096a36e723eULL, 0x000fe200000010ffULL,
0x000000902858723cULL, 0x000f680000041858ULL, 0x0000007d00857306ULL, 0x000ea8000000d400ULL,
0x0000006e702c723cULL, 0x000f68000004182cULL, 0x0000007c007d7306ULL, 0x000ee2000020d400ULL,
0x0000008e8d00720bULL, 0x002fc60003f9d000ULL, 0x0000006e284c723cULL, 0x000b68000004184cULL,
0x000000cb009f7306ULL, 0x000e62000020d400ULL, 0x0000000185855812ULL, 0x004fe400078efcffULL,
0x000000949300720bULL, 0x000fe40003fbd000ULL, 0x00000085ccc9723eULL, 0x000fe400000010ffULL,
0x0001a6c81a6e7811ULL, 0x020fe200078e18ffULL, 0x0000009e007c7306ULL, 0x000fe20000209400ULL,
0x000000017d7d3812ULL, 0x008fc600078efcffULL, 0x000000c8703c723cULL, 0x000f62000004183cULL,
0x0000007d8686723eULL, 0x000fc600000010ffULL, 0x0000009e00a17306ULL, 0x000ea20000205400ULL,
0x000000019f9f6812ULL, 0x002fe400078efcffULL, 0x0000000184845812ULL, 0x000fe200078efcffULL,
0x000000c8285c723cULL, 0x000f62000004185cULL, 0x0000008c8900720bULL, 0x000fe40003fbd000ULL,
0x0000009f8487723eULL, 0x000fe200000010ffULL, 0x000000a000a27306ULL, 0x000fec0000209400ULL,
0x000000867040723cULL, 0x000f640000041840ULL, 0x000000a000a77306ULL, 0x000e620000205400ULL,
0x000000a17c00720bULL, 0x004fc40003f7d000ULL, 0x0000000183835812ULL, 0x000fc600078efcffULL,
0x000000862860723cULL, 0x000f640000041860ULL, 0x0000007e00827306ULL, 0x0004f0000000d400ULL,
0x0000009e00a57306ULL, 0x000f22000020d400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x000000a7a200720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00277306ULL, 0x000e62000000d400ULL, 0x0000000182820812ULL, 0x008fce00078efcffULL,
0x000000a0009e7306ULL, 0x000ea2000020d400ULL, 0x00000001a5a53812ULL, 0x010fe400078efcffULL,
0x0000008a8b00720bULL, 0x000fe40003f7d000ULL, 0x00000082a57c723eULL, 0x000fc600000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000000127274812ULL, 0x002fce00078efcffULL,
0x0000007e00967306ULL, 0x000e620000205400ULL, 0x000000019e9e6812ULL, 0x004fe400078efcffULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x000000279e7d723eULL, 0x000fe200000010ffULL,
0x0000000220277824ULL, 0x000fe400078e00ffULL, 0x0000009500927306ULL, 0x000fe80000209400ULL,
0x0000007c7044723cULL, 0x000f680000041844ULL, 0x00000095008d7306ULL, 0x000ea20000205400ULL,
0x000000967f00720bULL, 0x002fc60003f1d000ULL, 0x0000007c2864723cULL, 0x000f680000041864ULL,
0x0000007e007e7306ULL, 0x000e70000020d400ULL, 0x0000009500887306ULL, 0x000ee2000020d400ULL,
0x0000008d9200720bULL, 0x004fc40003fdd000ULL, 0x000000017e7e0812ULL, 0x002fc800078efcffULL,
0x0000007e837e723eULL, 0x000fce00000010ffULL, 0x0000000188886812ULL, 0x008fc800078efcffULL,
0x00000088817f723eULL, 0x000fce00000010ffULL, 0x0000007e7048723cULL, 0x080f700000041848ULL,
0x0000007e2868723cULL, 0x000b6e0000041868ULL, 0xfffffff827287812ULL, 0x020fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006e6e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6900028ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff277224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x004fc80000015200ULL,
0x00000400142b7984ULL, 0x000ea40000000800ULL, 0x800000002bff7812ULL, 0x006fc4000780486fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a28717210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x000000712a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000127277810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400142b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010016277824ULL, 0x000fca00078e0277ULL,
0x000000c027297810ULL, 0x000fc80007ffe0ffULL, 0x0000006029287812ULL, 0x000fca00078ec0ffULL,
0x0000000119727824ULL, 0x000fe200078e0228ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x00000010202a7824ULL, 0x000fe200078e00ffULL, 0x000000291e287217ULL, 0x000fe40007800000ULL,
0x00000003ff707819ULL, 0x000fe4000001161fULL, 0x000000102a737812ULL, 0x000fe200078ec0ffULL,
0x0000000128287824ULL, 0x000fe200078e0a29ULL, 0x00000004706e7810ULL, 0x040fe40007ffe0ffULL,
0x00000008707c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000170787824ULL, 0x100fe200078e0273ULL,
0x0000002873287217ULL, 0x000fe20007800000ULL, 0x000000016e7a7824ULL, 0x000fe200078e0273ULL,
0x0000620024797a11ULL, 0x000fe200078038ffULL, 0x0000000178297824ULL, 0x000fc400078e0272ULL,
0x0000000128717824ULL, 0x100fe200078e0a73ULL, 0x00006300247b7a11ULL, 0x000fe200000f3cffULL,
0x0000008029287825ULL, 0x000fe200078e00ffULL, 0x0000000c70247810ULL, 0x000fe40007ffe0ffULL,
0x000000716e00720cULL, 0x000fe20003f66070ULL, 0x000000017a2a7824ULL, 0x000fe200078e0272ULL,
0x00000013286e7212ULL, 0x000fe200078efcffULL, 0x000000017c7d7824ULL, 0x000fe200078e0273ULL,
0x000000717000720cULL, 0x000fe20003f86070ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x000000796e6e7210ULL, 0x000fc40007fbe0ffULL, 0x000000717c00720cULL, 0x000fe20003f06070ULL,
0x000000017d287824ULL, 0x000fe200078e0272ULL, 0x000000132a707212ULL, 0x000fe200078efcffULL,
0x00000001247c7824ULL, 0x000fe400078e0273ULL, 0x00000001296f7824ULL, 0x000fe200028e067bULL,
0x0000007970707210ULL, 0x000fe20007fde0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x000000712400720cULL, 0x000fc60003fa6070ULL, 0x000000017c2a7824ULL, 0x000fe200078e0272ULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000012b717824ULL, 0x000fe400030e067bULL,
0x0000000178247824ULL, 0x000fe200078e021fULL, 0x0000007928287210ULL, 0x000fe20007fde0ffULL,
0x0000000878737824ULL, 0x000fe400078e00ffULL, 0x000000802a2a7825ULL, 0x000fc600078e00ffULL,
0xfffffff873247812ULL, 0x000fe200078ee224ULL, 0x000000017a727824ULL, 0x100fe200078e021fULL,
0x000000132a2a7212ULL, 0x000fe200078efcffULL, 0x000000087a7f7824ULL, 0x000fe400078e00ffULL,
0x000000017d737824ULL, 0x140fe400078e021fULL, 0x000000087d787824ULL, 0x000fe200078e00ffULL,
0xfffffff87f727812ULL, 0x000fe200078ee272ULL, 0x000000017c7a7824ULL, 0x040fe400078e021fULL,
0x000000087c7d7824ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee273ULL,
0x0000000129297824ULL, 0x000fe200030e067bULL, 0x000000792a2a7210ULL, 0x000fe20007fde0ffULL,
0x0000001024737824ULL, 0x100fe200078e0225ULL, 0xfffffff87d7a7812ULL, 0x000fe200078ee27aULL,
0x0000001072797824ULL, 0x000fc400078e0225ULL, 0x000000012b2b7824ULL, 0x000fe200030e067bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e737faeULL, 0x0003e2000e101c48ULL,
0x00000010787b7824ULL, 0x100fe400078e0225ULL, 0x000000107a7d7824ULL, 0x000fe200078e0225ULL,
0x0000000070797faeULL, 0x0003e8000d901c48ULL, 0x00000000287b7faeULL, 0x0003e8000c101c48ULL,
0x000000002a7d7faeULL, 0x0003e2000e901c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001020287824ULL, 0x000fe200078e00ffULL, 0x0000620024737a11ULL, 0x000fc800078038ffULL,
0x0000001028287812ULL, 0x000fe400078ec0ffULL, 0x0000630024797a11ULL, 0x000fe400000f3cffULL,
0x000000281f297211ULL, 0x000fc800078fe8ffULL, 0x00000004292b7810ULL, 0x040fe20007ffe0ffULL,
0x00000001292a7824ULL, 0x140fe200078e021fULL, 0x0000000c29717810ULL, 0x040fe20007ffe0ffULL,
0x00000008296f7824ULL, 0x040fe400078e00ffULL, 0x0000000129287824ULL, 0x000fe400078e0272ULL,
0x000000082b7a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86f787812ULL, 0x000fe200078ee22aULL,
0x000000012b2a7824ULL, 0x000fe200078e0272ULL, 0x00000008296f7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b297824ULL, 0x000fc400078e021fULL, 0x0000000171707824ULL, 0x100fe400078e0272ULL,
0x000000016f6e7824ULL, 0x040fe200078e0272ULL, 0xfffffff87a727812ULL, 0x000fe200078ee229ULL,
0x000000016f2b7824ULL, 0x140fe400078e021fULL, 0x000000086f7c7824ULL, 0x000fe400078e00ffULL,
0x00000001716f7824ULL, 0x040fe400078e021fULL, 0x00000008717e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87c7a7812ULL, 0x000fe200078ee22bULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff87e7c7812ULL, 0x000fe200078ee26fULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001328287212ULL, 0x000fc600078efcffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x0000007328287210ULL, 0x000fe40007f1e0ffULL, 0x000000132a2a7212ULL, 0x080fe200078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000136e6e7212ULL, 0x000fe400078efcffULL,
0x000000732a2a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000129297824ULL, 0x000fe200000e0679ULL,
0x0000001370707212ULL, 0x000fe200078efcffULL, 0x000000107a7b7824ULL, 0x000fe200078e0225ULL,
0x000000736e6e7210ULL, 0x080fe20007f1e0ffULL, 0x000000012b2b7824ULL, 0x000fe200018e0679ULL,
0x0000007370707210ULL, 0x000fe20007f9e0ffULL, 0x0000001078737824ULL, 0x000fc400078e0225ULL,
0x000000016f6f7824ULL, 0x100fe400000e0679ULL, 0x0000000171717824ULL, 0x000fe200020e0679ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028737faeULL, 0x0003e2000b901c48ULL,
0x0000001072797824ULL, 0x100fe400078e0225ULL, 0x000000107c7d7824ULL, 0x000fc600078e0225ULL,
0x000000002a797faeULL, 0x0003e8000b901c48ULL, 0x000000006e7b7faeULL, 0x0003e8000b901c48ULL,
0x00000000707d7faeULL, 0x0003e4000b901c48ULL, 0x000000021b1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0xffffffffff247424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000001d1b00720cULL, 0x000fcc0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fee0008000a05ULL, 0x000000011b288824ULL, 0x000fe400078e0218ULL,
0x00000004ff298424ULL, 0x000fc800078e00ffULL, 0x0000640028288625ULL, 0x000fca00078e0029ULL,
0x0000000828248981ULL, 0x000322000c1e1900ULL, 0x00000008202a7824ULL, 0x000fca00078e00ffULL,
0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6b0002a6e7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6480023707f8cULL, 0x0002a4000c80043fULL,
0x0000000000287805ULL, 0x002fc40000015200ULL, 0x01a64c00232b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x006fe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a28737210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09007300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x000000732a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a64c00232b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002020237824ULL, 0x000fca00078e00ffULL,
0xffffff8023287812ULL, 0x000fc800078ec0ffULL, 0x0000010013237810ULL, 0x000fca0007ffe028ULL,
0x0000000112237824ULL, 0x000fca00078e0223ULL, 0x01a0000023727984ULL, 0x000e680000000800ULL,
0x01a2000023717984ULL, 0x0004e20000000800ULL, 0x000000217200720bULL, 0x002fe20003f1d000ULL,
0x00012ff27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000737806ULL, 0x004fc800000e0100ULL,
0x000000ff7300720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0021ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000217237810ULL, 0x000fe40007ffe0ffULL,
0x000000217200720bULL, 0x000fe40003f74000ULL, 0x000000202300720cULL, 0x000fe20003f05270ULL,
0x00012fb27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000787806ULL, 0x000fc400018e0100ULL,
0x0000008020298824ULL, 0x000fe200078e0213ULL, 0x0000002172237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000112288824ULL, 0x000fca00078e0229ULL,
0x01a4002328008388ULL, 0x0003e20000000800ULL, 0x000000ff7800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000002123217221ULL, 0x002fe20000010100ULL,
0x000000ff78ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b21217820ULL, 0x000fcc0000410000ULL, 0x0000002100217308ULL, 0x000e640000000800ULL,
0x0000002122227220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x00012f027f007947ULL, 0x000fea000b800000ULL,
0x00001f2921297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0078ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x00012df27f007947ULL, 0x000fea000b800000ULL, 0x00001f2921297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000078ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x00012ce27f007947ULL, 0x000fea000b800000ULL,
0x00001f2921297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000078ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x00012be27f007947ULL, 0x000fea000b800000ULL,
0x00001f2921297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007873ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff707424ULL, 0x000fd800078e00ffULL,
0x8000002372720221ULL, 0x000fe20000010000ULL, 0x00007610ff700816ULL, 0x000fc60000000070ULL,
0x3fb8aa3b72720820ULL, 0x000fc80000410000ULL, 0x0000007200110308ULL, 0x000e640000000800ULL,
0x0000001171710220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002271227221ULL, 0x008fc40000010000ULL, 0x0000000000287805ULL, 0x000fca0000015200ULL,
0x0000040010217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc8000001142bULL,
0x0000002a21217211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000221217819ULL, 0x000fc8000000122aULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000171717810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040010217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991070217816ULL, 0x000fc800000000ffULL, 0x000000ff2100720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000011ff0c723eULL, 0x000fe400000010ffULL,
0x00000002ff217819ULL, 0x000fe4000001161fULL, 0x000054100c0c7816ULL, 0x000fe2000000000cULL,
0x000127f27f007947ULL, 0x000fea000b800000ULL, 0x00001f210c0f7589ULL, 0x0002a400000e0000ULL,
0x0000000821297810ULL, 0x000fe20007ffe0ffULL, 0x000128427f007947ULL, 0x000fea000b800000ULL,
0x00000010210d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f290c0e7589ULL, 0x00066a00000e0000ULL,
0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL, 0x0000001821297810ULL, 0x008fe20007ffe0ffULL,
0x000128d27f007947ULL, 0x000fea000b800000ULL, 0x00001f290c0c7589ULL, 0x0022e400000e0000ULL,
0x0000040020217824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000001007787824ULL, 0x000fc400078e0203ULL,
0xfffff00021217812ULL, 0x000fc800078ec0ffULL, 0x0001400021217810ULL, 0x000fca0007ffe0ffULL,
0x0000001009097824ULL, 0x100fe400078e0221ULL, 0x0000001008087824ULL, 0x000fc600078e0221ULL,
0x000000000970783bULL, 0x0002e80000000200ULL, 0x000000000828783bULL, 0x0022a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707231ULL, 0x08cfe400003400ffULL,
0x0000000f72727231ULL, 0x000fe400003400ffULL, 0x0000000e71717231ULL, 0x080fe400003400ffULL,
0x0000000e73737231ULL, 0x000fc400003400ffULL, 0x0000000d28287231ULL, 0x080fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fe400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010067c7824ULL, 0x000fe200078e0203ULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x00000f8000007945ULL, 0x000fe80003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000100789a7824ULL, 0x002fe200078e00ffULL, 0x00000018ff067819ULL, 0x000fe20000011478ULL,
0x00000100799e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011479ULL,
0x0000007900a27306ULL, 0x000fe20000009400ULL, 0x00000018ff8a7819ULL, 0x008fe2000001147cULL,
0x0001000079a77824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe2000001147eULL,
0x000001007aaf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe2000001147fULL,
0x000001007bb47824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x0000000600a07306ULL, 0x000fe20000209400ULL, 0x00000018ff8f7819ULL, 0x000fe2000001147dULL,
0x000001007dbb7824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001147aULL,
0x000001007fcb7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fc4000001147bULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x0000000600a17306ULL, 0x000fe20000205400ULL,
0x00000018ffaf7819ULL, 0x000fe400000114afULL, 0x00000018ffb47819ULL, 0x000fe400000114b4ULL,
0x00000018ffc17819ULL, 0x000fe400000114bbULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x00000006006c7306ULL, 0x000ff0000020d400ULL, 0x0000008a00bd7306ULL, 0x000ff00000209400ULL,
0x0000008a00be7306ULL, 0x000ff00000205400ULL, 0x0000008a00887306ULL, 0x000ff0000020d400ULL,
0x0000008100ab7306ULL, 0x000ff00000209400ULL, 0x0000008100ac7306ULL, 0x000ff00000205400ULL,
0x00000081006d7306ULL, 0x000ff0000020d400ULL, 0x000000a4008b7306ULL, 0x000ff00000209400ULL,
0x000000a4008a7306ULL, 0x000ff00000205400ULL, 0x000000a400067306ULL, 0x0003f0000020d400ULL,
0x0000009b00897306ULL, 0x000fe20000209400ULL, 0x00000018ffa47819ULL, 0x002fce000001149eULL,
0x0000009b008c7306ULL, 0x000ff00000205400ULL, 0x0000009b00817306ULL, 0x000ff0000020d400ULL,
0x0000007900a37306ULL, 0x000e700000005400ULL, 0x0000009a009b7306ULL, 0x000ff00000209400ULL,
0x0000009a009c7306ULL, 0x000ee20000205400ULL, 0x000000a3a200720bULL, 0x002fce0003f9d000ULL,
0x0000007800987306ULL, 0x000ff00000009400ULL, 0x0000007800997306ULL, 0x000e620000005400ULL,
0x0000009c9b00720bULL, 0x008fce0003fbd000ULL, 0x000000a400a57306ULL, 0x000ff00000209400ULL,
0x000000a400a67306ULL, 0x000ee20000205400ULL, 0x000000999800720bULL, 0x002fce0003fdd000ULL,
0x0000007800087306ULL, 0x0002b0000000d400ULL, 0x0000008f00c87306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x002fe200078e00ffULL, 0x000000a6a500720bULL, 0x008fc80003f7d000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008f00c97306ULL, 0x000fe20000205400ULL,
0x0000000108086812ULL, 0x004fe400078efcffULL, 0x000000a1a000720bULL, 0x000fca0003fdd000ULL,
0x0000008f00867306ULL, 0x000ff0000020d400ULL, 0x0000008300927306ULL, 0x000fe20000209400ULL,
0x000000016c6c6812ULL, 0x000fce00078efcffULL, 0x0000008300937306ULL, 0x000ff00000205400ULL,
0x0000008300847306ULL, 0x000ff0000020d400ULL, 0x0000007900097306ULL, 0x000e70000000d400ULL,
0x0000009f008f7306ULL, 0x000ff00000209400ULL, 0x0000009f00907306ULL, 0x000fe20000205400ULL,
0x0000000109094812ULL, 0x002fc400078efcffULL, 0x000000acab00720bULL, 0x000fca0003f9d000ULL,
0x0000009f00837306ULL, 0x000ff0000020d400ULL, 0x0000009a009d7306ULL, 0x000e62000020d400ULL,
0x000000016d6d4812ULL, 0x000fce00078efcffULL, 0x00000078009e7306ULL, 0x000ff00000209400ULL,
0x00000078009f7306ULL, 0x000ea20000205400ULL, 0x000000019d9d5812ULL, 0x002fc800078efcffULL,
0x000000089d08723eULL, 0x000fc600000010ffULL, 0x000000a400a87306ULL, 0x000e70000020d400ULL,
0x000000a7009a7306ULL, 0x000fe20000209400ULL, 0x0000009f9e00720bULL, 0x004fce0003fbd000ULL,
0x000000a700a97306ULL, 0x000ea20000205400ULL, 0x00000001a8a83812ULL, 0x002fc800078efcffULL,
0x00000009a809723eULL, 0x000fc600000010ffULL, 0x0000007800797306ULL, 0x0002e8000020d400ULL,
0x00000008702c723cULL, 0x000f68000004182cULL, 0x0000007b00b27306ULL, 0x000fe20000009400ULL,
0x000001007c787824ULL, 0x002fe200078e00ffULL, 0x000000a99a00720bULL, 0x004fc40003f7d000ULL,
0x00000008284c723cULL, 0x000f64000004184cULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007b00b37306ULL, 0x000e620000005400ULL, 0x0000000179795812ULL, 0x008fc800078efcffULL,
0x000000796c6c723eULL, 0x000fc600000010ffULL, 0x000000af00a47306ULL, 0x000ff00000209400ULL,
0x000000af00b17306ULL, 0x000ea20000205400ULL, 0x000000b3b200720bULL, 0x002fce0003f9d000ULL,
0x000000a700aa7306ULL, 0x000e70000020d400ULL, 0x0000007a00ad7306ULL, 0x000fe20000009400ULL,
0x000000b1a400720bULL, 0x004fce0003fbd000ULL, 0x0000007a00ae7306ULL, 0x000ea20000005400ULL,
0x00000001aaaa3812ULL, 0x002fc800078efcffULL, 0x000000aa6d6d723eULL, 0x000fc600000010ffULL,
0x000000b400b57306ULL, 0x000fe80000209400ULL, 0x0000006c7030723cULL, 0x000f680000041830ULL,
0x000000b400b67306ULL, 0x000e620000205400ULL, 0x000000aead00720bULL, 0x004fc60003fdd000ULL,
0x0000006c2850723cULL, 0x000f680000041850ULL, 0x0000007b008e7306ULL, 0x0004f0000000d400ULL,
0x000000af00b07306ULL, 0x000ee2000020d400ULL, 0x000000b6b500720bULL, 0x002fe20003f7d000ULL,
0x000100007b7b7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007d00bf7306ULL, 0x000fe20000009400ULL, 0x000000018e8e4812ULL, 0x008fce00078efcffULL,
0x0000007d00c07306ULL, 0x000e620000005400ULL, 0x00000001b0b05812ULL, 0x000fce00078efcffULL,
0x0000007800a77306ULL, 0x000ff00000209400ULL, 0x0000007800ba7306ULL, 0x000ea20000205400ULL,
0x000000c0bf00720bULL, 0x002fce0003f9d000ULL, 0x0000007a00917306ULL, 0x0002f0000000d400ULL,
0x000000b400b77306ULL, 0x000ee2000020d400ULL, 0x000000baa700720bULL, 0x004fe20003fbd000ULL,
0x000100007a7a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007c00b87306ULL, 0x000fe20000009400ULL, 0x0000000191916812ULL, 0x008fce00078efcffULL,
0x0000007c00b97306ULL, 0x000e620000005400ULL, 0x00000001b7b73812ULL, 0x000fc800078efcffULL,
0x0000008eb779723eULL, 0x000fc600000010ffULL, 0x000000c100c27306ULL, 0x000ff00000209400ULL,
0x000000c100c37306ULL, 0x000ea20000205400ULL, 0x000000b9b800720bULL, 0x002fce0003fdd000ULL,
0x0000007c008d7306ULL, 0x0002f0000000d400ULL, 0x0000007d00877306ULL, 0x0006e2000000d400ULL,
0x000100007c7c7824ULL, 0x002fe200078e00ffULL, 0x000000c3c200720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007800bc7306ULL, 0x0002a2000020d400ULL,
0x000100007d7d7824ULL, 0x008fe200078e00ffULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x000000bebd00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007c00af7306ULL, 0x000fe20000209400ULL, 0x000001007e787824ULL, 0x002fe200078e00ffULL,
0x0000000187874812ULL, 0x000fc400078efcffULL, 0x000000c9c800720bULL, 0x000fe40003f9d000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007c00b47306ULL, 0x000e620000205400ULL,
0x00000001bcbc5812ULL, 0x004fe400078efcffULL, 0x0000000188886812ULL, 0x000fca00078efcffULL,
0x000000c100c47306ULL, 0x000ea2000020d400ULL, 0x0000000186864812ULL, 0x000fce00078efcffULL,
0x0000007d00c57306ULL, 0x000fe20000209400ULL, 0x000000b4af00720bULL, 0x002fce0003fbd000ULL,
0x0000007d00c67306ULL, 0x000e620000205400ULL, 0x00000001c4c43812ULL, 0x004fce00078efcffULL,
0x0000007c00bb7306ULL, 0x000eb0000020d400ULL, 0x0000007800c17306ULL, 0x000fe20000209400ULL,
0x000000c6c500720bULL, 0x002fce0003f7d000ULL, 0x0000007800ca7306ULL, 0x000e620000205400ULL,
0x00000001bbbb5812ULL, 0x004fc800078efcffULL, 0x000000bb8888723eULL, 0x000fc600000010ffULL,
0x000000cb009c7306ULL, 0x000ff00000209400ULL, 0x000000cb00a37306ULL, 0x000ea20000205400ULL,
0x000000cac100720bULL, 0x002fce0003fbd000ULL, 0x0000007d00c77306ULL, 0x000e70000020d400ULL,
0x0000007e00967306ULL, 0x000fe20000009400ULL, 0x000000a39c00720bULL, 0x004fce0003f9d000ULL,
0x0000007e00977306ULL, 0x000ea20000005400ULL, 0x00000001c7c73812ULL, 0x002fce00078efcffULL,
0x0000007f00957306ULL, 0x000ff00000009400ULL, 0x0000007f00947306ULL, 0x000e620000005400ULL,
0x000000979600720bULL, 0x004fce0003fdd000ULL, 0x0000007800cc7306ULL, 0x000eb0000020d400ULL,
0x000000cb00cd7306ULL, 0x000ee2000020d400ULL, 0x000000949500720bULL, 0x002fce0003f7d000ULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x00000001cccc5812ULL, 0x004fce00078efcffULL,
0x0000007a007d7306ULL, 0x000e620000205400ULL, 0x00000001cdcd4812ULL, 0x008fce00078efcffULL,
0x0000007b007c7306ULL, 0x000ff00000209400ULL, 0x0000007b009b7306ULL, 0x000ea20000205400ULL,
0x0000007d7800720bULL, 0x002fe40003fbd000ULL, 0x00000091b078723eULL, 0x000fca00000010ffULL,
0x0000007a00997306ULL, 0x0002e4000020d400ULL, 0x000000787034723cULL, 0x080f6c0000041834ULL,
0x0000007e00857306ULL, 0x000ee2000000d400ULL, 0x000100007e7a7824ULL, 0x002fe200078e00ffULL,
0x0000009b7c00720bULL, 0x004fe20003f9d000ULL, 0x000000782854723cULL, 0x000b660000041854ULL,
0x00000018ff987819ULL, 0x000fe2000001147aULL, 0x000100007f7a7824ULL, 0x000fe200078e00ffULL,
0x0000007f00827306ULL, 0x000e62000000d400ULL, 0x0000000199995812ULL, 0x008fe200078efcffULL,
0x0000001002787824ULL, 0x020fe200078e0203ULL, 0x0000008c8900720bULL, 0x000fc40003fbd000ULL,
0x00000018ff957819ULL, 0x000fe4000001147aULL, 0x0000008dbc7a723eULL, 0x000fe200000010ffULL,
0x0000007b007e7306ULL, 0x000ea2000020d400ULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x000000939200720bULL, 0x000fe40003fdd000ULL, 0x000000c78689723eULL, 0x000fe400000010ffULL,
0x00000085cccc723eULL, 0x000fe200000010ffULL, 0x00000098007f7306ULL, 0x000fe20000209400ULL,
0x0000000182823812ULL, 0x002fc400078efcffULL, 0x000000908f00720bULL, 0x000fe20003f7d000ULL,
0x000000887040723cULL, 0x080f620000041840ULL, 0x0000000181815812ULL, 0x000fe400078efcffULL,
0x00000082cdcd723eULL, 0x000fe200000010ffULL, 0x0000009800947306ULL, 0x000e620000205400ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x000000017e7e4812ULL, 0x004fe200078efcffULL,
0x000000882860723cULL, 0x000f620000041860ULL, 0x0000008a8b00720bULL, 0x000fc40003fdd000ULL,
0x000000998482723eULL, 0x000fe200000010ffULL, 0x00000095007d7306ULL, 0x000fe20000209400ULL,
0x0000000183833812ULL, 0x000fe400078efcffULL, 0x00000087c47b723eULL, 0x000fe200000010ffULL,
0x000000cc7044723cULL, 0x000f620000041844ULL, 0x0000007e8383723eULL, 0x000fc600000010ffULL,
0x00000095007c7306ULL, 0x000ea20000205400ULL, 0x000000947f00720bULL, 0x002fe40003f9d000ULL,
0x0000000106066812ULL, 0x000fe200078efcffULL, 0x0000007a703c723cULL, 0x040f68000004183cULL,
0x0000009800987306ULL, 0x000e68000020d400ULL, 0x000000827038723cULL, 0x000f680000041838ULL,
0x0000009500957306ULL, 0x000ee2000020d400ULL, 0x0000007c7d00720bULL, 0x004fc60003f7d000ULL,
0x0000007a285c723cULL, 0x000f62000004185cULL, 0x0000000198984812ULL, 0x002fc800078efcffULL,
0x000000988198723eULL, 0x000fc600000010ffULL, 0x000000cc2864723cULL, 0x000f640000041864ULL,
0x0000000195953812ULL, 0x008fc800078efcffULL, 0x000000950699723eULL, 0x000fe400000010ffULL,
0x000000822858723cULL, 0x000f700000041858ULL, 0x000000987048723cULL, 0x080b6e0000041848ULL,
0x0000001005707824ULL, 0x120fe200078e0221ULL, 0x000000982828723cULL, 0x000b620000041868ULL,
0x0000001004217824ULL, 0x000fc800078e0221ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002168783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000000f70707231ULL, 0x082fe400003400ffULL, 0x0000000f72727231ULL, 0x000fe400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fc400003400ffULL,
0x0000000d68687231ULL, 0x088fe400003400ffULL, 0x0000000d6a6a7231ULL, 0x000fe400003400ffULL,
0x0000000c69697231ULL, 0x080fe400003400ffULL, 0x0000000c6b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010007c7824ULL, 0x000fe200078e0203ULL,
0x000000007878783bULL, 0x000eaa0000004200ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x0000010078917824ULL, 0x004fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe2000001147aULL,
0x0000007800087306ULL, 0x000fe20000009400ULL, 0x00000018ff007819ULL, 0x000fe20000011478ULL,
0x0000010079947824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x008fe2000001147dULL,
0x000001007aa77824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011491ULL,
0x000001007bab7824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001147bULL,
0x0000000000967306ULL, 0x000fe20000209400ULL, 0x00000018ffa07819ULL, 0x000fe2000001147fULL,
0x000001007cb77824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe20000011494ULL,
0x000001007dba7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fc400000114a7ULL,
0x00000018ffb07819ULL, 0x000fe200000114abULL, 0x0000000000997306ULL, 0x000fe20000205400ULL,
0x00000018ff067819ULL, 0x000fe40000011479ULL, 0x00000018ff977819ULL, 0x000fe4000001147eULL,
0x00000018ffb77819ULL, 0x000fe400000114b7ULL, 0x00000018ffc07819ULL, 0x000fe200000114baULL,
0x0000000000987306ULL, 0x0005f0000020d400ULL, 0x0000008400ac7306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x004fce000001147cULL, 0x0000008400ad7306ULL, 0x000ff00000205400ULL,
0x0000008400817306ULL, 0x000ff0000020d400ULL, 0x0000009200c37306ULL, 0x000ff00000209400ULL,
0x0000009200c87306ULL, 0x000ff00000205400ULL, 0x0000009200847306ULL, 0x000ff0000020d400ULL,
0x0000009100927306ULL, 0x000ff00000209400ULL, 0x0000009100937306ULL, 0x000eb00000205400ULL,
0x0000007800097306ULL, 0x000ef00000005400ULL, 0x00000079009a7306ULL, 0x000fe20000009400ULL,
0x000000939200720bULL, 0x004fce0003f9d000ULL, 0x00000079009b7306ULL, 0x000ea20000005400ULL,
0x000000090800720bULL, 0x008fe20003f7d000ULL, 0x000001007e087824ULL, 0x000fe400078e00ffULL,
0x000001007f097824ULL, 0x000fc600078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x00000086008c7306ULL, 0x000fe20000209400ULL, 0x00000018ff097819ULL, 0x000fce0000011409ULL,
0x00000086008d7306ULL, 0x000fe20000205400ULL, 0x0000009b9a00720bULL, 0x004fce0003fdd000ULL,
0x0000008600027306ULL, 0x000ff0000020d400ULL, 0x0000000000bc7306ULL, 0x000ff00000209400ULL,
0x0000000000bd7306ULL, 0x000ff00000205400ULL, 0x0000000000857306ULL, 0x000ff0000020d400ULL,
0x000000a000877306ULL, 0x000ff00000209400ULL, 0x000000a000867306ULL, 0x000ff00000205400ULL,
0x000000a000007306ULL, 0x0005f0000020d400ULL, 0x0000009100957306ULL, 0x000ee2000020d400ULL,
0x0001000079a07824ULL, 0x004fca00078e00ffULL, 0x00000018ffa07819ULL, 0x000fe400000114a0ULL,
0x00000078006c7306ULL, 0x000470000000d400ULL, 0x000000a000917306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x004fe200078e00ffULL, 0x0000000195954812ULL, 0x008fc400078efcffULL,
0x000000999600720bULL, 0x000fe20003f9d000ULL, 0x000100007f997824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x000000a000a27306ULL, 0x000ea20000205400ULL,
0x000000016c6c3812ULL, 0x002fe400078efcffULL, 0x00000018ff997819ULL, 0x000fca0000011499ULL,
0x00000079009c7306ULL, 0x000e62000000d400ULL, 0x0000000198984812ULL, 0x000fce00078efcffULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x000000a29100720bULL, 0x004fce0003f7d000ULL,
0x0000009d009f7306ULL, 0x000ea20000205400ULL, 0x000000019c9c6812ULL, 0x002fce00078efcffULL,
0x0000009d00a17306ULL, 0x000e70000020d400ULL, 0x000000a7009d7306ULL, 0x000fe20000209400ULL,
0x0000009f9e00720bULL, 0x004fce0003f1d000ULL, 0x000000a700aa7306ULL, 0x000eac0000205400ULL,
0x00000001a1a10812ULL, 0x002fe400078efcffULL, 0x000000a000a47306ULL, 0x000e70000020d400ULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x000000aa9d00720bULL, 0x004fce0003fdd000ULL,
0x000000b000b27306ULL, 0x000ea20000205400ULL, 0x00000001a4a43812ULL, 0x002fce00078efcffULL,
0x0000007b00ae7306ULL, 0x000ff00000009400ULL, 0x0000007b00af7306ULL, 0x000e620000005400ULL,
0x000000b2b100720bULL, 0x004fce0003f9d000ULL, 0x0000000600a37306ULL, 0x000ff00000209400ULL,
0x0000000600a67306ULL, 0x000ea20000205400ULL, 0x000000afae00720bULL, 0x002fce0003f7d000ULL,
0x00000006006d7306ULL, 0x000e70000020d400ULL, 0x0000009700887306ULL, 0x000fe20000209400ULL,
0x000000a6a300720bULL, 0x004fce0003f1d000ULL, 0x0000009700897306ULL, 0x000fec0000205400ULL,
0x000000016d6d0812ULL, 0x002fe400078efcffULL, 0x0000009700067306ULL, 0x000fe4000020d400ULL,
0x000000a46d6d723eULL, 0x000fcc00000010ffULL, 0x000000a700a97306ULL, 0x000e70000020d400ULL,
0x0000007800947306ULL, 0x000ff00000209400ULL, 0x0000007800977306ULL, 0x000ea20000205400ULL,
0x00000001a9a96812ULL, 0x002fc400078efcffULL, 0x000000adac00720bULL, 0x000fca0003fdd000ULL,
0x0000007a00a57306ULL, 0x000ff00000009400ULL, 0x0000007a00a87306ULL, 0x000fe20000005400ULL,
0x000000979400720bULL, 0x004fe40003fbd000ULL, 0x0000000181816812ULL, 0x000fca00078efcffULL,
0x0000007a00907306ULL, 0x0003f0000000d400ULL, 0x0000007800797306ULL, 0x0004e2000020d400ULL,
0x000100007a7a7824ULL, 0x002fce00078e00ffULL, 0x000000b000b47306ULL, 0x000e62000020d400ULL,
0x00000018ff787819ULL, 0x004fce000001147aULL, 0x0000007b008b7306ULL, 0x000462000000d400ULL,
0x0000000179795812ULL, 0x008fe400078efcffULL, 0x000000a8a500720bULL, 0x000fca0003fbd000ULL,
0x000000b700b07306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x00000001b4b44812ULL, 0x002fc800078efcffULL, 0x00000018ffa77819ULL, 0x000fe4000001147bULL,
0x000000b700b97306ULL, 0x000e620000205400ULL, 0x000000018b8b3812ULL, 0x000fe400078efcffULL,
0x0000000190905812ULL, 0x000fca00078efcffULL, 0x0000007c00b57306ULL, 0x000ff00000009400ULL,
0x0000007c00b87306ULL, 0x000ea20000005400ULL, 0x000000b9b000720bULL, 0x002fce0003f9d000ULL,
0x0000007800a07306ULL, 0x000ff00000209400ULL, 0x0000007800ab7306ULL, 0x000e620000205400ULL,
0x000000b8b500720bULL, 0x004fce0003f7d000ULL, 0x0000007c008a7306ULL, 0x0004f0000000d400ULL,
0x0000007d00be7306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000aba000720bULL, 0x002fc80003f1d000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00bf7306ULL, 0x000e620000005400ULL, 0x000000018a8a3812ULL, 0x008fe400078efcffULL,
0x000000bdbc00720bULL, 0x000fca0003f7d000ULL, 0x0000007d00837306ULL, 0x0004f0000000d400ULL,
0x00000078007a7306ULL, 0x000ee2000020d400ULL, 0x000100007d7d7824ULL, 0x004fe200078e00ffULL,
0x000000bfbe00720bULL, 0x002fc40003fdd000ULL, 0x0000000185853812ULL, 0x000fe400078efcffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x000000a700b37306ULL, 0x000fee0000209400ULL,
0x0000000183836812ULL, 0x008fe200078efcffULL, 0x000000a700b67306ULL, 0x000e620000205400ULL,
0x000000017a7a0812ULL, 0x000fc800078efcffULL, 0x0000007a817a723eULL, 0x000fc600000010ffULL,
0x000000a7007b7306ULL, 0x000eb0000020d400ULL, 0x000000b700bb7306ULL, 0x000ee2000020d400ULL,
0x000000b6b300720bULL, 0x002fce0003fbd000ULL, 0x0000007c00787306ULL, 0x000fec0000209400ULL,
0x000000017b7b5812ULL, 0x004fe400078efcffULL, 0x0000007c00a77306ULL, 0x000e620000205400ULL,
0x00000001bbbb4812ULL, 0x008fc800078efcffULL, 0x0000008abb8a723eULL, 0x000fc600000010ffULL,
0x000000c000c17306ULL, 0x000ff00000209400ULL, 0x000000c000c27306ULL, 0x000ea20000205400ULL,
0x000000a77800720bULL, 0x002fe40003f9d000ULL, 0x00000090a978723eULL, 0x000fca00000010ffULL,
0x0000007d00b77306ULL, 0x000ff00000209400ULL, 0x0000007d00c67306ULL, 0x000e620000205400ULL,
0x000000c2c100720bULL, 0x004fce0003f1d000ULL, 0x0000007c00ba7306ULL, 0x000eb0000020d400ULL,
0x00000008007c7306ULL, 0x000fe20000209400ULL, 0x000000c6b700720bULL, 0x002fce0003fdd000ULL,
0x0000000800977306ULL, 0x000e620000205400ULL, 0x00000001baba4812ULL, 0x004fc800078efcffULL,
0x000000ba85ba723eULL, 0x000fc600000010ffULL, 0x0000007f008e7306ULL, 0x000ff00000009400ULL,
0x0000007f008f7306ULL, 0x000ea20000005400ULL, 0x000000977c00720bULL, 0x002fce0003f9d000ULL,
0x000000c000c47306ULL, 0x000e70000020d400ULL, 0x0000007d00937306ULL, 0x000ee2000020d400ULL,
0x0000008f8e00720bULL, 0x004fce0003f7d000ULL, 0x0000007e00c57306ULL, 0x000fe20000009400ULL,
0x00000001c4c40812ULL, 0x002fe400078efcffULL, 0x000000c8c300720bULL, 0x000fca0003f1d000ULL,
0x0000007e00ca7306ULL, 0x000e620000005400ULL, 0x0000000193936812ULL, 0x008fce00078efcffULL,
0x0000000900917306ULL, 0x000fe20000209400ULL, 0x0000000184840812ULL, 0x000fe400078efcffULL,
0x0000008d8c00720bULL, 0x000fe40003f1d000ULL, 0x0000009384bb723eULL, 0x000fc600000010ffULL,
0x0000000900947306ULL, 0x000ea20000205400ULL, 0x000000cac500720bULL, 0x002fc60003fbd000ULL,
0x000000ba6860723cULL, 0x000b680000041860ULL, 0x0000007e00827306ULL, 0x0002e2000000d400ULL,
0x0000000102020812ULL, 0x000fc600078efcffULL, 0x000000ba7040723cULL, 0x000b620000041840ULL,
0x0000007b027b723eULL, 0x000fc600000010ffULL, 0x00000008007d7306ULL, 0x0006e2000020d400ULL,
0x000100007e7e7824ULL, 0x002fe200078e00ffULL, 0x000000949100720bULL, 0x004fe40003fdd000ULL,
0x0000007a6858723cULL, 0x080b640000041858ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00217306ULL, 0x000e62000000d400ULL, 0x0000000182825812ULL, 0x008fe400078efcffULL,
0x000000868700720bULL, 0x000fe20003fbd000ULL, 0x0000007a7038723cULL, 0x000b620000041838ULL,
0x0000006c9508723eULL, 0x000fc400000010ffULL, 0x00000079986c723eULL, 0x000fe200000010ffULL,
0x0000000900967306ULL, 0x0004e2000020d400ULL, 0x000000017d7d4812ULL, 0x000fe400078efcffULL,
0x000000898800720bULL, 0x000fe40003f9d000ULL, 0x0000008bb479723eULL, 0x000fe200000010ffULL,
0x0000006c6850723cULL, 0x000b620000041850ULL, 0x00000083c48b723eULL, 0x000fe200000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000000121213812ULL, 0x002fc400078efcffULL,
0x0000000100005812ULL, 0x000fe400078efcffULL, 0x0000009ca109723eULL, 0x004fe200000010ffULL,
0x000000786854723cULL, 0x040b620000041854ULL, 0x000000827d82723eULL, 0x000fe200000010ffULL,
0x0000007e00927306ULL, 0x000e620000205400ULL, 0x0000000196966812ULL, 0x008fe400078efcffULL,
0x0000000106064812ULL, 0x000fe400078efcffULL, 0x000000219683723eULL, 0x000fe200000010ffULL,
0x00000008684c723cULL, 0x040b64000004184cULL, 0x00000099007c7306ULL, 0x000fec0000209400ULL,
0x0000008a685c723cULL, 0x000b64000004185cULL, 0x00000099008f7306ULL, 0x000ea20000205400ULL,
0x000000927f00720bULL, 0x002fca0003fdd000ULL, 0x000000826864723cULL, 0x000b640000041864ULL,
0x0000007e00897306ULL, 0x000e6c000020d400ULL, 0x00000008702c723cULL, 0x000b64000004182cULL,
0x0000009900997306ULL, 0x000ee2000020d400ULL, 0x0000008f7c00720bULL, 0x004fca0003f7d000ULL,
0x0000006c7030723cULL, 0x000b620000041830ULL, 0x0000000189896812ULL, 0x002fc800078efcffULL,
0x00000089067c723eULL, 0x000fc600000010ffULL, 0x000000787034723cULL, 0x000b620000041834ULL,
0x0000000199993812ULL, 0x008fc800078efcffULL, 0x00000099007d723eULL, 0x000fe200000010ffULL,
0x0000000220007824ULL, 0x000fe400078e00ffULL, 0x0000008a703c723cULL, 0x000b66000004183cULL,
0xfffffff800027812ULL, 0x000fca00078ec0ffULL, 0x000000827044723cULL, 0x040b700000041844ULL,
0x0000007c7048723cULL, 0x080b700000041848ULL, 0x0000007c6868723cULL, 0x000b620000041828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000142a7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6980002ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x000fc600078e00ffULL,
0x0000000000087805ULL, 0x000fc80000015200ULL, 0x0000040014217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002808217210ULL, 0x000fca0007f1e1ffULL,
0x0000000129287824ULL, 0x000fe200000e0e09ULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x008fc80000011428ULL,
0x0000002102027211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0628ULL,
0x0000000202027819ULL, 0x000fc80000001221ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000100007810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040014217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000116097810ULL, 0x000fc80007ffe0ffULL, 0x0000001c0900720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x0000000216097810ULL, 0x000fe20007ffe0ffULL,
0x0000590024027a24ULL, 0x018fe200078e02ffULL, 0x0000010027277810ULL, 0x000fe40007ffe0ffULL,
0x0000001c0900720cULL, 0x000fe20003f06070ULL, 0x0000008002067824ULL, 0x000fe200078e00ffULL,
0x0000006027007812ULL, 0x000fca00078ec0ffULL, 0x0000000119027824ULL, 0x000fcc00078e0200ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x000000271e007217ULL, 0x000fe20007800000ULL,
0x0000001020087824ULL, 0x000fe200078e00ffULL, 0x00000003ff287819ULL, 0x000fe4000001161fULL,
0x0000620006217a11ULL, 0x000fe200078038ffULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x00000010082b7812ULL, 0x000fe400078ec0ffULL, 0x0000000428097810ULL, 0x040fe40007ffe0ffULL,
0x000000002b007217ULL, 0x000fe20007800000ULL, 0x0000000128297824ULL, 0x100fe200078e022bULL,
0x0000630006277a11ULL, 0x000fe200000f3cffULL, 0x00000001096d7824ULL, 0x100fe200078e022bULL,
0x0000000828067810ULL, 0x000fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a2bULL,
0x0000000c286c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129087824ULL, 0x000fc400078e0202ULL,
0x0000000106707824ULL, 0x000fe200078e022bULL, 0x000000000900720cULL, 0x080fe20003f86070ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000002800720cULL, 0x080fe40003fa6070ULL,
0x000000000600720cULL, 0x080fe20003f66070ULL, 0x000000016d287824ULL, 0x000fe200078e0202ULL,
0x00000013082a7212ULL, 0x000fe200078efcffULL, 0x0000000129067824ULL, 0x040fe200078e021fULL,
0x000000006c00720cULL, 0x000fe20003f06070ULL, 0x0000000829717824ULL, 0x000fe200078e00ffULL,
0x0000002a212a7210ULL, 0x000fe20007fde0ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff871067812ULL, 0x000fe200078ee206ULL, 0x000000016c727824ULL, 0x000fe200078e022bULL,
0x00000013286c7212ULL, 0x000fe200078efcffULL, 0x0000000170087824ULL, 0x000fe400078e0202ULL,
0x000000016d007824ULL, 0x000fe400078e021fULL, 0x00000001092b7824ULL, 0x000fe200030e0627ULL,
0x000000216c6c7210ULL, 0x000fe20007fde0ffULL, 0x000000086d6d7824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff86d007812ULL, 0x000fe200078ee200ULL,
0x0000000172287824ULL, 0x000fe200078e0202ULL, 0x0000001308087212ULL, 0x000fe200078efcffULL,
0x00000001296d7824ULL, 0x000fe400030e0627ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000002108087210ULL, 0x000fc60007fde0ffULL, 0x0000000170717824ULL, 0x100fe200078e021fULL,
0x0000001328027212ULL, 0x000fe200078efcffULL, 0x0000000870787824ULL, 0x000fe400078e00ffULL,
0x0000000172707824ULL, 0x040fe400078e021fULL, 0x0000000872737824ULL, 0x000fe200078e00ffULL,
0xfffffff878287812ULL, 0x000fe200078ee271ULL, 0x0000000109097824ULL, 0x000fe200030e0627ULL,
0x0000002102027210ULL, 0x000fe20007fde0ffULL, 0x0000001006217824ULL, 0x100fe200078e0203ULL,
0xfffffff873707812ULL, 0x000fe200078ee270ULL, 0x0000001000717824ULL, 0x000fc400078e0203ULL,
0x0000001028737824ULL, 0x100fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a217faeULL, 0x0003e2000e901c48ULL, 0x0000001070797824ULL, 0x000fe400078e0203ULL,
0x0000000129037824ULL, 0x000fe200030e0627ULL, 0x000000006c717faeULL, 0x0003e8000e101c48ULL,
0x0000000008737faeULL, 0x0003e8000d901c48ULL, 0x0000000002797faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001020007824ULL, 0x000fca00078e00ffULL,
0x0000001000007812ULL, 0x000fc800078ec0ffULL, 0x000000001f007211ULL, 0x000fc800078fe8ffULL,
0x0000000400217810ULL, 0x040fe20007ffe0ffULL, 0x0000000100097824ULL, 0x040fe200078e021fULL,
0x0000000c00277810ULL, 0x040fe20007ffe0ffULL, 0x0000000800707824ULL, 0x040fe400078e00ffULL,
0x0000000100087824ULL, 0x100fe400078e0202ULL, 0x0000000121287824ULL, 0x040fe200078e0202ULL,
0xfffffff870707812ULL, 0x000fe200078ee209ULL, 0x0000000821297824ULL, 0x040fe200078e00ffULL,
0x0000000800097810ULL, 0x000fe20007ffe0ffULL, 0x0000000121007824ULL, 0x000fc400078e021fULL,
0x00000001276c7824ULL, 0x100fe400078e0202ULL, 0x00000001092a7824ULL, 0x000fe200078e0202ULL,
0xfffffff829007812ULL, 0x000fe200078ee200ULL, 0x0000000127217824ULL, 0x140fe400078e021fULL,
0x0000000827787824ULL, 0x000fe400078e00ffULL, 0x0000000109027824ULL, 0x040fe400078e021fULL,
0x00000008092b7824ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee221ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000620006217a11ULL, 0x000fc400078038ffULL,
0xfffffff82b727812ULL, 0x000fe200078ee202ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000001308087212ULL, 0x080fe400078efcffULL, 0x0000630006277a11ULL, 0x000fe200000f3cffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000821087210ULL, 0x000fe40007f1e0ffULL,
0x0000001328027212ULL, 0x080fe200078efcffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x000000132a287212ULL, 0x000fc600078efcffULL, 0x0000000109097824ULL, 0x000fe200000e0627ULL,
0x000000136c2a7212ULL, 0x000fe200078efcffULL, 0x0000001000717824ULL, 0x100fe200078e0203ULL,
0x0000000221027210ULL, 0x040fe20007f1e0ffULL, 0x0000001072737824ULL, 0x100fe200078e0203ULL,
0x0000002821287210ULL, 0x040fe20007f7e0ffULL, 0x0000001078797824ULL, 0x100fe200078e0203ULL,
0x0000002a212a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001070217824ULL, 0x000fe400078e0203ULL,
0x0000000129037824ULL, 0x000fc400000e0627ULL, 0x000000012b297824ULL, 0x100fe200018e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008217faeULL, 0x0003e2000b901c48ULL,
0x000000016d2b7824ULL, 0x000fc600020e0627ULL, 0x0000000002717faeULL, 0x0003e8000b901c48ULL,
0x0000000028737faeULL, 0x0003e8000b901c48ULL, 0x000000002a797faeULL, 0x0003e4000b901c48ULL,
0x0000000820027824ULL, 0x00afe400078e00ffULL, 0x0000002017007824ULL, 0x000fc600078e0215ULL,
0x0000000802037812ULL, 0x000fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000000103067824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000010027f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6680006287f8cULL, 0x000662000c80043fULL, 0x000000ffff007224ULL, 0x004fc600078e0003ULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01a66c0006097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x006fc40007804829ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000802217210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e03ULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000002108087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c0006097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018017027811ULL, 0x000fc800078e38ffULL,
0x0000000212027210ULL, 0x000fca0007ffe013ULL, 0x01a0000002067984ULL, 0x008e680000000800ULL,
0x01a2000002037984ULL, 0x0004e20000000800ULL, 0x000000230600720bULL, 0x002fe20003f1d000ULL,
0x0000fac27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800000e0100ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fd200078e0023ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000317097810ULL, 0x000fe40007ffe0ffULL,
0x000000230600720bULL, 0x000fe40003f74000ULL, 0x000000200900720cULL, 0x000fe20003f05270ULL,
0x0000fa827f007947ULL, 0x000fd4000b800000ULL, 0x0000000000097806ULL, 0x000fc400018e0100ULL,
0x0000008020138824ULL, 0x000fe200078e0213ULL, 0x0000002306027209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000112138824ULL, 0x000fca00078e0213ULL,
0x01a4000213008388ULL, 0x0003e20000000800ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000002302127221ULL, 0x002fe20000010100ULL,
0x000000ff09ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL, 0x0000001200137308ULL, 0x000e640000000800ULL,
0x0000001322227220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x0000f9d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2913297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x080fe40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x000fc40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x080fe40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x000fc40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0009ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x0000f8c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2913297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000009ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x0000f7b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2913297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000009ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x0000f6b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2913297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000908ff7212ULL, 0x000fda00078030ffULL, 0x0000000602060221ULL, 0x000fe20000010100ULL,
0x00007610ff100816ULL, 0x000fc60000000010ULL, 0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL,
0x0000000600110308ULL, 0x000e640000000800ULL, 0x0000001103030220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002203227221ULL, 0x008fc40000010000ULL,
0x0000000000087805ULL, 0x000fca0000015200ULL, 0x0000000820037824ULL, 0x000fca00078e00ffULL,
0xfffffff003217812ULL, 0x000fca00078ec0ffULL, 0x01a6b40021037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001208067210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e09ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011412ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0612ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000123237810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b40021037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991010037816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000011ff03723eULL, 0x000fe400000010ffULL,
0x00000002ff067819ULL, 0x000fe4000001161fULL, 0x0000541003037816ULL, 0x000fe20000000003ULL,
0x0000f2a27f007947ULL, 0x000fea000b800000ULL, 0x00001f06030f7589ULL, 0x0002a400000e0000ULL,
0x0000000806297810ULL, 0x000fe20007ffe0ffULL, 0x0000f2f27f007947ULL, 0x000fea000b800000ULL,
0x0000001006087810ULL, 0x000fe20007ffe0ffULL, 0x00001f29030e7589ULL, 0x00066800000e0000ULL,
0x00001f08030d7589ULL, 0x0006a400000e0000ULL, 0x0000001806297810ULL, 0x008fe20007ffe0ffULL,
0x0000f3827f007947ULL, 0x000fea000b800000ULL, 0x00001f29030c7589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011a037812ULL, 0x00afe200078ec0ffULL,
0x000000080b097824ULL, 0x000fe200078e00ffULL, 0x00000004ff067819ULL, 0x000fe2000001161fULL,
0x0000000420087824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000080a107824ULL, 0x000fe200078e00ffULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x0000000403037824ULL, 0x000fe200078e0206ULL, 0x0000000408087812ULL, 0x000fe200078ec0ffULL,
0x0000001007787824ULL, 0x000fc400078e0225ULL, 0x000000010b067824ULL, 0x100fe200078e0203ULL,
0x0000000208087812ULL, 0x000fe200078efcffULL, 0x000000010a037824ULL, 0x000fc600078e0203ULL,
0xfffffff809097812ULL, 0x000fe400078ee206ULL, 0x0001500017067811ULL, 0x000fe400078e60ffULL,
0xfffffff810137812ULL, 0x000fe400078ee203ULL, 0x000000081f037211ULL, 0x000fe200078fe0ffULL,
0x0000001009097824ULL, 0x100fe400078e0206ULL, 0x0000001013137824ULL, 0x000fe400078e0206ULL,
0x000000080b087824ULL, 0x040fe200078e00ffULL, 0x00000000096c783bULL, 0x0002e20000000200ULL,
0x000000010b0b7824ULL, 0x000fc600078e0203ULL, 0x000000001328783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7231ULL, 0x08cfe400003400ffULL,
0x0000000f6e6e7231ULL, 0x000fe400003400ffULL, 0x0000000e6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000e6f6f7231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x080fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fc400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff808087812ULL, 0x000fe200078ee20bULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x0000001004047824ULL, 0x000fe200078e0206ULL, 0x00000fa000007945ULL, 0x000fe20003800000ULL,
0x000000010a037824ULL, 0x000fe400078e0203ULL, 0x0000001008087824ULL, 0x000fca00078e0225ULL,
0x000000000870783bULL, 0x0006a20000004200ULL, 0x00000100788a7824ULL, 0x002fe200078e00ffULL,
0x00000018ff087819ULL, 0x008fe20000011478ULL, 0x00000100798d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe2000001147aULL, 0x0000007800127306ULL, 0x000fe20000009400ULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x000001007aa27824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe2000001148dULL, 0x000001007ba67824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147bULL, 0x0000010070b47824ULL, 0x004fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe20000011471ULL, 0x0000007800137306ULL, 0x000e620000005400ULL,
0x00000018ff997819ULL, 0x000fe20000011473ULL, 0x0000010071b97824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fc40000011479ULL, 0x00000018ff907819ULL, 0x000fe40000011472ULL,
0x00000018ffa27819ULL, 0x000fe200000114a2ULL, 0x00000008008f7306ULL, 0x000fe20000209400ULL,
0x00000018ffa97819ULL, 0x000fe400000114a6ULL, 0x00000018ffb47819ULL, 0x000fe400000114b4ULL,
0x00000018ffb97819ULL, 0x000fc600000114b9ULL, 0x0000000800927306ULL, 0x000fe20000205400ULL,
0x000000131200720bULL, 0x002fe20003fdd000ULL, 0x0000010072127824ULL, 0x000fe400078e00ffULL,
0x0000010073137824ULL, 0x000fc600078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000000800947306ULL, 0x0003e2000020d400ULL, 0x00000018ff137819ULL, 0x000fce0000011413ULL,
0x0000002100a57306ULL, 0x000fe20000209400ULL, 0x00000018ff087819ULL, 0x002fce0000011470ULL,
0x0000002100a87306ULL, 0x000ff00000205400ULL, 0x0000002100857306ULL, 0x000ff0000020d400ULL,
0x0000008b00bf7306ULL, 0x000ff00000209400ULL, 0x0000008b00c27306ULL, 0x000ff00000205400ULL,
0x0000008b00217306ULL, 0x000ff0000020d400ULL, 0x0000007900917306ULL, 0x000ff00000009400ULL,
0x0000007900967306ULL, 0x000e700000005400ULL, 0x0000008a008b7306ULL, 0x000ff00000209400ULL,
0x0000008a008c7306ULL, 0x000ea20000205400ULL, 0x000000969100720bULL, 0x002fce0003f9d000ULL,
0x0000009500977306ULL, 0x000ff00000209400ULL, 0x0000009500987306ULL, 0x000e620000205400ULL,
0x0000008c8b00720bULL, 0x004fce0003fbd000ULL, 0x0000007f00b07306ULL, 0x000ff00000209400ULL,
0x0000007f00b17306ULL, 0x000fe20000205400ULL, 0x000000989700720bULL, 0x002fce0003f7d000ULL,
0x0000007f007c7306ULL, 0x000ff0000020d400ULL, 0x0000000800b57306ULL, 0x000ff00000209400ULL,
0x0000000800bc7306ULL, 0x000ff00000205400ULL, 0x0000000800237306ULL, 0x000ff0000020d400ULL,
0x0000007800897306ULL, 0x0002b0000000d400ULL, 0x0000009900847306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000099007f7306ULL, 0x000fe20000205400ULL, 0x0000000189896812ULL, 0x004fe400078efcffULL,
0x000000928f00720bULL, 0x000fca0003fdd000ULL, 0x0000009900087306ULL, 0x0003f0000020d400ULL,
0x0000000b009d7306ULL, 0x000fe20000209400ULL, 0x0001000079997824ULL, 0x002fe200078e00ffULL,
0x0000000194946812ULL, 0x000fc800078efcffULL, 0x00000018ff997819ULL, 0x000fe40000011499ULL,
0x0000000b009e7306ULL, 0x000ff00000205400ULL, 0x0000000b009f7306ULL, 0x000ff0000020d400ULL,
0x0000007900937306ULL, 0x000e70000000d400ULL, 0x00000090007e7306ULL, 0x000ff00000209400ULL,
0x0000009000817306ULL, 0x000fe20000205400ULL, 0x0000000193934812ULL, 0x002fc400078efcffULL,
0x0000009e9d00720bULL, 0x000fca0003f9d000ULL, 0x00000090000b7306ULL, 0x000ff0000020d400ULL,
0x0000008a008e7306ULL, 0x000e62000020d400ULL, 0x000000019f9f4812ULL, 0x000fce00078efcffULL,
0x00000095009a7306ULL, 0x000eb0000020d400ULL, 0x00000078008d7306ULL, 0x000fe20000209400ULL,
0x000000018e8e5812ULL, 0x002fce00078efcffULL, 0x0000007800907306ULL, 0x000e620000205400ULL,
0x000000019a9a3812ULL, 0x004fce00078efcffULL, 0x00000099008a7306ULL, 0x000ff00000209400ULL,
0x00000099009b7306ULL, 0x000ea20000205400ULL, 0x000000908d00720bULL, 0x002fce0003fbd000ULL,
0x0000007a00a07306ULL, 0x000ff00000009400ULL, 0x0000007a00a17306ULL, 0x000e620000005400ULL,
0x0000009b8a00720bULL, 0x004fce0003f7d000ULL, 0x0000007800797306ULL, 0x000eb0000020d400ULL,
0x00000099009c7306ULL, 0x000ee2000020d400ULL, 0x000000a1a000720bULL, 0x002fce0003fdd000ULL,
0x0000007b00a77306ULL, 0x000fe20000009400ULL, 0x0000000179795812ULL, 0x004fce00078efcffULL,
0x0000007b00aa7306ULL, 0x000e620000005400ULL, 0x000000019c9c3812ULL, 0x008fce00078efcffULL,
0x000000a200957306ULL, 0x000ff00000209400ULL, 0x000000a200a47306ULL, 0x000ea20000205400ULL,
0x000000aaa700720bULL, 0x002fce0003f9d000ULL, 0x000000a900ab7306ULL, 0x000ff00000209400ULL,
0x000000a900ac7306ULL, 0x000e620000205400ULL, 0x000000a49500720bULL, 0x004fce0003fbd000ULL,
0x0000007a00887306ULL, 0x0004f0000000d400ULL, 0x0000007b00837306ULL, 0x0006e2000000d400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x000000acab00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x000000a200a37306ULL, 0x000e62000020d400ULL,
0x000100007b7b7824ULL, 0x008fe200078e00ffULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x000000a8a500720bULL, 0x000fe40003fdd000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000a900ae7306ULL, 0x000ea2000020d400ULL, 0x0000000183834812ULL, 0x000fc400078efcffULL,
0x000000b1b000720bULL, 0x000fca0003f9d000ULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x00000001a3a35812ULL, 0x002fe400078efcffULL, 0x0000000185856812ULL, 0x000fca00078efcffULL,
0x0000007a00997306ULL, 0x000e620000205400ULL, 0x00000001aeae3812ULL, 0x004fe400078efcffULL,
0x000000017c7c4812ULL, 0x000fca00078efcffULL, 0x0000007b00a27306ULL, 0x000ff00000209400ULL,
0x0000007b00ad7306ULL, 0x000ea20000205400ULL, 0x000000997800720bULL, 0x002fce0003fbd000ULL,
0x0000007000b27306ULL, 0x000ff00000009400ULL, 0x0000007000b37306ULL, 0x000e620000005400ULL,
0x000000ada200720bULL, 0x004fce0003f7d000ULL, 0x0000007a00a67306ULL, 0x000eb0000020d400ULL,
0x0000007b00af7306ULL, 0x000ee2000020d400ULL, 0x000000b3b200720bULL, 0x002fce0003fdd000ULL,
0x0000007100b77306ULL, 0x000fe20000009400ULL, 0x00000001a6a65812ULL, 0x004fc800078efcffULL,
0x000000a685a6723eULL, 0x000fc600000010ffULL, 0x0000007100be7306ULL, 0x000e620000005400ULL,
0x00000001afaf3812ULL, 0x008fc800078efcffULL, 0x000000af7ca7723eULL, 0x000fc600000010ffULL,
0x000000b400a97306ULL, 0x000fe80000209400ULL, 0x000000a66c38723cULL, 0x000b680000041838ULL,
0x000000b400b67306ULL, 0x000ea20000205400ULL, 0x000000beb700720bULL, 0x002fc60003f9d000ULL,
0x000000a62858723cULL, 0x000b680000041858ULL, 0x000000b900bb7306ULL, 0x000ff00000209400ULL,
0x000000b900c07306ULL, 0x000e620000205400ULL, 0x000000b6a900720bULL, 0x004fce0003fbd000ULL,
0x0000007000277306ULL, 0x0004f0000000d400ULL, 0x0000007100107306ULL, 0x0006e2000000d400ULL,
0x0001000070707824ULL, 0x004fe200078e00ffULL, 0x000000c0bb00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x000000b400b87306ULL, 0x000e62000020d400ULL,
0x0001000071717824ULL, 0x008fe200078e00ffULL, 0x0000000127276812ULL, 0x000fe400078efcffULL,
0x000000bcb500720bULL, 0x000fe40003fdd000ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x000000b900bd7306ULL, 0x000ea2000020d400ULL, 0x0000000110104812ULL, 0x000fce00078efcffULL,
0x00000070007a7306ULL, 0x000fe20000209400ULL, 0x00000001b8b85812ULL, 0x002fe400078efcffULL,
0x0000000123236812ULL, 0x000fe400078efcffULL, 0x00000027b8b8723eULL, 0x000fc600000010ffULL,
0x00000070007b7306ULL, 0x000e620000205400ULL, 0x00000001bdbd3812ULL, 0x004fe400078efcffULL,
0x000000c2bf00720bULL, 0x000fe40003f7d000ULL, 0x00000010bdb9723eULL, 0x000fe200000010ffULL,
0x000000080a107824ULL, 0x000fe400078e00ffULL, 0x00000071008b7306ULL, 0x000fe80000209400ULL,
0x000000b86c3c723cULL, 0x000b68000004183cULL, 0x00000071008c7306ULL, 0x000ea20000205400ULL,
0x0000007b7a00720bULL, 0x002fc40003fbd000ULL, 0x0000000121213812ULL, 0x000fe200078efcffULL,
0x000000b8285c723cULL, 0x000b68000004185cULL, 0x0000007200867306ULL, 0x000ff00000009400ULL,
0x0000007200877306ULL, 0x000e620000005400ULL, 0x0000008c8b00720bULL, 0x004fce0003f9d000ULL,
0x0000007000ba7306ULL, 0x0004f0000020d400ULL, 0x0000007100907306ULL, 0x0006e2000020d400ULL,
0x000000799470723eULL, 0x004fe400000010ffULL, 0x000000878600720bULL, 0x002fca0003fdd000ULL,
0x00000073007d7306ULL, 0x000fe20000009400ULL, 0x00000001baba5812ULL, 0x008fe400078efcffULL,
0x0000009c9f71723eULL, 0x000fe400000010ffULL, 0x000000ba23ba723eULL, 0x000fc600000010ffULL,
0x0000007300827306ULL, 0x000e620000005400ULL, 0x0000000190904812ULL, 0x000fe200078efcffULL,
0x000000706c30723cULL, 0x000b660000041830ULL, 0x0000009021bb723eULL, 0x000fc600000010ffULL,
0x00000012008a7306ULL, 0x000fe40000209400ULL, 0x000000702850723cULL, 0x000b6c0000041850ULL,
0x00000012008d7306ULL, 0x000ea20000205400ULL, 0x000000827d00720bULL, 0x002fe20003f7d000ULL,
0x000000ba6c40723cULL, 0x080b6c0000041840ULL, 0x00000013008f7306ULL, 0x000fe40000209400ULL,
0x000000ba2860723cULL, 0x000b6c0000041860ULL, 0x0000001300967306ULL, 0x000e620000205400ULL,
0x0000008d8a00720bULL, 0x004fce0003fbd000ULL, 0x0000007200097306ULL, 0x0004f0000000d400ULL,
0x0000007300077306ULL, 0x0006e2000000d400ULL, 0x0001000072727824ULL, 0x004fe200078e00ffULL,
0x000000968f00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff787819ULL, 0x000fe40000011472ULL,
0x0000001200927306ULL, 0x0002a2000020d400ULL, 0x0001000073737824ULL, 0x008fe200078e00ffULL,
0x0000000109096812ULL, 0x000fe400078efcffULL, 0x0000007f8400720bULL, 0x000fe40003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011473ULL, 0x0000001300987306ULL, 0x0006e2000020d400ULL,
0x000000898e12723eULL, 0x002fc400000010ffULL, 0x0000000107073812ULL, 0x000fe400078efcffULL,
0x00000088a372723eULL, 0x000fe400000010ffULL, 0x00000083ae73723eULL, 0x000fe200000010ffULL,
0x00000078007a7306ULL, 0x000fe20000209400ULL, 0x0000000192925812ULL, 0x004fe400078efcffULL,
0x000000817e00720bULL, 0x000fe40003fbd000ULL, 0x0000000108086812ULL, 0x000fe200078efcffULL,
0x000000726c34723cULL, 0x000b620000041834ULL, 0x000000939a13723eULL, 0x008fe200000010ffULL,
0x00000078007b7306ULL, 0x000e620000205400ULL, 0x0000000198984812ULL, 0x000fc400078efcffULL,
0x000000099292723eULL, 0x000fe400000010ffULL, 0x000000079893723eULL, 0x000fe200000010ffULL,
0x000000126c2c723cULL, 0x000b64000004182cULL, 0x0000007900897306ULL, 0x000fe20000209400ULL,
0x000000010b0b5812ULL, 0x000fca00078efcffULL, 0x000000926c44723cULL, 0x000b640000041844ULL,
0x0000007900867306ULL, 0x000ea20000205400ULL, 0x0000007b7a00720bULL, 0x002fca0003f9d000ULL,
0x00000012284c723cULL, 0x040b64000004184cULL, 0x0000007800787306ULL, 0x000e6c000020d400ULL,
0x000000722854723cULL, 0x000b640000041854ULL, 0x0000007900797306ULL, 0x000ee2000020d400ULL,
0x000000868900720bULL, 0x004fca0003f7d000ULL, 0x000000922864723cULL, 0x000b620000041864ULL,
0x0000000178784812ULL, 0x002fc800078efcffULL, 0x000000780b78723eULL, 0x000fc600000010ffULL,
0x0000000179793812ULL, 0x008fc800078efcffULL, 0x000000790879723eULL, 0x000fe200000010ffULL,
0x0000001005087824ULL, 0x000fe400078e0206ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x000000786c48723cULL, 0x080b620000041848ULL, 0x000000000808783bULL, 0x000eae0000000200ULL,
0x000000782868723cULL, 0x000b620000041868ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f08087231ULL, 0x084fe400003400ffULL,
0x0000000f0a0a7231ULL, 0x000fc400003400ffULL, 0x0000000e09097231ULL, 0x080fe400003400ffULL,
0x0000000e0b0b7231ULL, 0x000fe400003400ffULL, 0x0000000d04047231ULL, 0x082fe400003400ffULL,
0x0000000d06067231ULL, 0x000fe400003400ffULL, 0x0000000c05057231ULL, 0x080fe400003400ffULL,
0x0000000c07077231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff810107812ULL, 0x000fe200078ee203ULL, 0x000000002628783bULL, 0x020ee80000004200ULL,
0x0000001010107824ULL, 0x000fca00078e0225ULL, 0x00000000106c783bULL, 0x0004620000004200ULL,
0x00000018ff267819ULL, 0x008fe2000001142bULL, 0x0000002800277306ULL, 0x000fe20000009400ULL,
0x00000018ff107819ULL, 0x004fe20000011428ULL, 0x0000010029817824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe20000011429ULL, 0x000001002a987824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe2000001142aULL, 0x000001002b9d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011481ULL, 0x0000002600a77306ULL, 0x000fe20000209400ULL,
0x00000018ff867819ULL, 0x002fe2000001146eULL, 0x000001006cab7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001146fULL, 0x000100002ba37824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001146dULL, 0x000001006dae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x0000002600a87306ULL, 0x000fe20000205400ULL,
0x00000018ff9d7819ULL, 0x000fc4000001149dULL, 0x00000018ffab7819ULL, 0x000fe400000114abULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x00000018ffb37819ULL, 0x000fe200000114aeULL,
0x0000002600717306ULL, 0x0003f0000020d400ULL, 0x00000028007e7306ULL, 0x000ea20000005400ULL,
0x0000010028267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000028007d7306ULL, 0x0002f0000000d400ULL, 0x0000001000837306ULL, 0x000fe20000209400ULL,
0x0001000028287824ULL, 0x002fe200078e00ffULL, 0x0000007e2700720bULL, 0x004fe20003f7d000ULL,
0x000001006e277824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000001000887306ULL, 0x000fe20000205400ULL, 0x00000018ff277819ULL, 0x000fcc0000011427ULL,
0x000000017d7d3812ULL, 0x008fe200078efcffULL, 0x00000010008a7306ULL, 0x0003f0000020d400ULL,
0x0000001300927306ULL, 0x000fe20000209400ULL, 0x00000018ff107819ULL, 0x002fce000001146cULL,
0x0000001300937306ULL, 0x000ff00000205400ULL, 0x0000001300947306ULL, 0x000ff0000020d400ULL,
0x0000008600737306ULL, 0x000ff00000209400ULL, 0x00000086007a7306ULL, 0x000ff00000205400ULL,
0x0000008600137306ULL, 0x000ff0000020d400ULL, 0x0000001000af7306ULL, 0x000ff00000209400ULL,
0x0000001000b07306ULL, 0x000ff00000205400ULL, 0x0000001000257306ULL, 0x000ff0000020d400ULL,
0x0000002800817306ULL, 0x000ff00000209400ULL, 0x0000002800867306ULL, 0x000e700000205400ULL,
0x0000008d007b7306ULL, 0x000ff00000209400ULL, 0x0000008d00727306ULL, 0x000fe20000205400ULL,
0x000000868100720bULL, 0x002fce0003fdd000ULL, 0x0000008d00107306ULL, 0x0003f0000020d400ULL,
0x0000002100997306ULL, 0x000fe20000209400ULL, 0x00010000298d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000021009e7306ULL, 0x000ff00000205400ULL,
0x0000002100a07306ULL, 0x000ff0000020d400ULL, 0x0000007f00b77306ULL, 0x000ff00000209400ULL,
0x0000007f00ba7306ULL, 0x000ff00000205400ULL, 0x0000007f00217306ULL, 0x000ff0000020d400ULL,
0x00000026007f7306ULL, 0x000ff00000209400ULL, 0x0000002600827306ULL, 0x000e700000205400ULL,
0x0000002600847306ULL, 0x000eb0000020d400ULL, 0x0000008d00267306ULL, 0x000fe20000209400ULL,
0x000000827f00720bULL, 0x002fce0003f1d000ULL, 0x0000008d008f7306ULL, 0x000e6c0000205400ULL,
0x0000000184840812ULL, 0x004fe400078efcffULL, 0x0000002900857306ULL, 0x000fe20000009400ULL,
0x000000888300720bULL, 0x000fe20003f1d000ULL, 0x000100006f837824ULL, 0x000fca00078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x00000029008c7306ULL, 0x000ea20000005400ULL,
0x0000008f2600720bULL, 0x002fe20003f7d000ULL, 0x000001006f267824ULL, 0x000fc800078e00ffULL,
0x000000018a8a0812ULL, 0x000fe400078efcffULL, 0x0000002900877306ULL, 0x000e62000000d400ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x00000089008b7306ULL, 0x000fe20000209400ULL,
0x0000008c8500720bULL, 0x004fce0003f9d000ULL, 0x00000089008e7306ULL, 0x000eac0000205400ULL,
0x0000000187874812ULL, 0x002fe400078efcffULL, 0x0000008900907306ULL, 0x000e62000020d400ULL,
0x000000939200720bULL, 0x000fce0003f9d000ULL, 0x0000002800297306ULL, 0x000ee2000020d400ULL,
0x0000008e8b00720bULL, 0x004fca0003fbd000ULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x0000009800897306ULL, 0x000fec0000209400ULL, 0x0000000190905812ULL, 0x002fe400078efcffULL,
0x00000098009a7306ULL, 0x000e620000205400ULL, 0x0000000129296812ULL, 0x008fce00078efcffULL,
0x0000008d00917306ULL, 0x000eb0000020d400ULL, 0x0000002b009b7306ULL, 0x000fe20000009400ULL,
0x0000009a8900720bULL, 0x002fce0003fdd000ULL, 0x0000002b00a27306ULL, 0x000e620000005400ULL,
0x0000000191913812ULL, 0x004fce00078efcffULL, 0x00000098009c7306ULL, 0x000eb0000020d400ULL,
0x0000002a00957306ULL, 0x000fe20000009400ULL, 0x000000a29b00720bULL, 0x002fce0003f7d000ULL,
0x0000002a00967306ULL, 0x000e620000005400ULL, 0x000000019c9c6812ULL, 0x004fe400078efcffULL,
0x0000009e9900720bULL, 0x000fca0003fdd000ULL, 0x0000002a00977306ULL, 0x0004f0000000d400ULL,
0x0000002b007c7306ULL, 0x000ee2000000d400ULL, 0x000100002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000969500720bULL, 0x002fc40003fbd000ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000009d009f7306ULL, 0x000fee0000209400ULL,
0x0000000197975812ULL, 0x008fe200078efcffULL, 0x0000009d00a47306ULL, 0x000e620000205400ULL,
0x000000017c7c3812ULL, 0x000fc400078efcffULL, 0x000000979c9c723eULL, 0x000fca00000010ffULL,
0x0000009d00a17306ULL, 0x000eb0000020d400ULL, 0x000000ab009d7306ULL, 0x000fe20000209400ULL,
0x000000a49f00720bULL, 0x002fce0003f1d000ULL, 0x000000ab00ac7306ULL, 0x000e6c0000205400ULL,
0x00000001a1a10812ULL, 0x004fe400078efcffULL, 0x0000002a00287306ULL, 0x000fe20000209400ULL,
0x000000a8a700720bULL, 0x000fce0003f1d000ULL, 0x0000002a008d7306ULL, 0x000ea20000205400ULL,
0x000000ac9d00720bULL, 0x002fe40003f7d000ULL, 0x0000007ca19d723eULL, 0x000fc600000010ffULL,
0x0000000171710812ULL, 0x000fe400078efcffULL, 0x000000a300987306ULL, 0x000fe40000209400ULL,
0x0000009c0834723cULL, 0x080b6c0000041834ULL, 0x000000a300a57306ULL, 0x000e620000205400ULL,
0x0000008d2800720bULL, 0x004fe20003f9d000ULL, 0x0000009c0454723cULL, 0x000b620000041854ULL,
0x000000298a28723eULL, 0x000fc400000010ffULL, 0x000000919429723eULL, 0x000fc600000010ffULL,
0x000000b300b47306ULL, 0x000fe80000209400ULL, 0x000000280830723cULL, 0x000b680000041830ULL,
0x000000b300b57306ULL, 0x000ea20000205400ULL, 0x000000a59800720bULL, 0x002fc60003fbd000ULL,
0x000000280450723cULL, 0x000b680000041850ULL, 0x0000006c00a97306ULL, 0x000ff00000009400ULL,
0x0000006c00aa7306ULL, 0x000fe20000005400ULL, 0x000000b5b400720bULL, 0x004fce0003fdd000ULL,
0x0000006c00707306ULL, 0x0003f0000000d400ULL, 0x0000006d00b17306ULL, 0x000fe20000009400ULL,
0x000100006c6c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000006d00b27306ULL, 0x000ff00000005400ULL, 0x0000006d00237306ULL, 0x0003f0000000d400ULL,
0x0000002a002b7306ULL, 0x000ea2000020d400ULL, 0x000100006d6d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x000000a300a67306ULL, 0x000e70000020d400ULL,
0x000000ab00ad7306ULL, 0x000ee2000020d400ULL, 0x000000012b2b4812ULL, 0x004fc400078efcffULL,
0x000000aaa900720bULL, 0x000fe40003f9d000ULL, 0x0000002ba0a0723eULL, 0x000fc600000010ffULL,
0x0000006c002a7306ULL, 0x000fe20000209400ULL, 0x00000001a6a65812ULL, 0x002fe400078efcffULL,
0x000000b2b100720bULL, 0x000fe40003fbd000ULL, 0x000000a671a1723eULL, 0x000fc600000010ffULL,
0x0000006c00a37306ULL, 0x000e620000205400ULL, 0x00000001adad3812ULL, 0x008fe400078efcffULL,
0x0000000170704812ULL, 0x000fe200078efcffULL, 0x000000a00838723cULL, 0x080b620000041838ULL,
0x000000b0af00720bULL, 0x000fe40003f9d000ULL, 0x00000070ad70723eULL, 0x000fe200000010ffULL,
0x000000b300b67306ULL, 0x000ea2000020d400ULL, 0x0000000123235812ULL, 0x000fe400078efcffULL,
0x000000bab700720bULL, 0x000fe20003fbd000ULL, 0x000000a00458723cULL, 0x000b680000041858ULL,
0x0000006d00ab7306ULL, 0x000fe20000209400ULL, 0x000000a32a00720bULL, 0x002fc40003f7d000ULL,
0x0000000125254812ULL, 0x000fca00078efcffULL, 0x0000006d00b87306ULL, 0x000e620000205400ULL,
0x00000001b6b66812ULL, 0x004fe400078efcffULL, 0x0000000121215812ULL, 0x000fe400078efcffULL,
0x0000007a7300720bULL, 0x000fe40003fbd000ULL, 0x00000023b671723eULL, 0x000fe200000010ffULL,
0x0000006e00b97306ULL, 0x000fec0000009400ULL, 0x00000070083c723cULL, 0x000b64000004183cULL,
0x0000006e00bc7306ULL, 0x000ea20000005400ULL, 0x000000b8ab00720bULL, 0x002fc40003fdd000ULL,
0x0000000113135812ULL, 0x000fc600078efcffULL, 0x00000070045c723cULL, 0x000b64000004185cULL,
0x0000006c00ae7306ULL, 0x000e70000020d400ULL, 0x00000027006c7306ULL, 0x000fe20000209400ULL,
0x000000bcb900720bULL, 0x004fce0003f1d000ULL, 0x00000027007f7306ULL, 0x000ea20000205400ULL,
0x00000001aeae3812ULL, 0x002fc800078efcffULL, 0x000000ae25ae723eULL, 0x000fc600000010ffULL,
0x0000006d007e7306ULL, 0x000e70000020d400ULL, 0x0000006e00127306ULL, 0x000662000000d400ULL,
0x0000007f6c00720bULL, 0x004fce0003f7d000ULL, 0x0000002600817306ULL, 0x000fe20000209400ULL,
0x000100006e6e7824ULL, 0x008fe200078e00ffULL, 0x000000017e7e6812ULL, 0x002fc800078efcffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000002600827306ULL, 0x000e620000205400ULL,
0x0000000112120812ULL, 0x000fe400078efcffULL, 0x0000007e21af723eULL, 0x000fca00000010ffULL,
0x0000006f00787306ULL, 0x000fe40000009400ULL, 0x000000ae0840723cULL, 0x080b6c0000041840ULL,
0x0000006f00797306ULL, 0x000ea20000005400ULL, 0x000000828100720bULL, 0x002fe20003fdd000ULL,
0x000000ae0460723cULL, 0x000b6c0000041860ULL, 0x0000006f00037306ULL, 0x000e70000000d400ULL,
0x0000006e006f7306ULL, 0x000fe20000209400ULL, 0x000000797800720bULL, 0x004fce0003f9d000ULL,
0x0000006e002a7306ULL, 0x000eac0000205400ULL, 0x0000000103034812ULL, 0x002fe400078efcffULL,
0x0000002600867306ULL, 0x0002f0000020d400ULL, 0x00000027006d7306ULL, 0x0006e2000020d400ULL,
0x0000007d8426723eULL, 0x002fc400000010ffULL, 0x0000002a6f00720bULL, 0x004fca0003f1d000ULL,
0x00000083007d7306ULL, 0x000fe20000209400ULL, 0x0000000186866812ULL, 0x008fe400078efcffULL,
0x000000879027723eULL, 0x000fe400000010ffULL, 0x00000003862b723eULL, 0x000fc600000010ffULL,
0x00000083006c7306ULL, 0x000e620000205400ULL, 0x000000016d6d3812ULL, 0x000fe200078efcffULL,
0x00000026082c723cULL, 0x000b62000004182cULL, 0x000000727b00720bULL, 0x000fe40003f7d000ULL,
0x000000126d2a723eULL, 0x000fc600000010ffULL, 0x0000006e006e7306ULL, 0x000ea4000020d400ULL,
0x00000026044c723cULL, 0x000b6c000004184cULL, 0x00000083006f7306ULL, 0x000ee2000020d400ULL,
0x0000006c7d00720bULL, 0x002fe20003fdd000ULL, 0x0000002a0844723cULL, 0x000b620000041844ULL,
0x0000000110103812ULL, 0x000fc400078efcffULL, 0x000000016e6e0812ULL, 0x004fca00078efcffULL,
0x0000002a0464723cULL, 0x000b620000041864ULL, 0x0000006e136e723eULL, 0x000fc600000010ffULL,
0x000000016f6f6812ULL, 0x008fc800078efcffULL, 0x0000006f106f723eULL, 0x000fce00000010ffULL,
0x0000006e0848723cULL, 0x080b700000041848ULL, 0x0000006e0468723cULL, 0x000b620000041868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000014047f8cULL, 0x0202a2000c80043fULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0001a6a017067811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000006ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff037224ULL, 0x004fe200078e0005ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff152000007947ULL, 0x000fea000383ffffULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x000104e000047802ULL, 0x004fc40000000f00ULL, 0x0000d56000007944ULL, 0x01afea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002200037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000022ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000e680000000000ULL,
0x0000000000047919ULL, 0x004ea20000000000ULL, 0x0000001808057811ULL, 0x042fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x004fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x002fc40000410000ULL, 0x0000002d002d7220ULL, 0x040fe40000410000ULL,
0x0000003000307220ULL, 0x040fe40000410000ULL, 0x0000003100317220ULL, 0x040fe40000410000ULL,
0x0000003400347220ULL, 0x040fe40000410000ULL, 0x0000003500357220ULL, 0x040fe40000410000ULL,
0x0000003800387220ULL, 0x000fc40000410000ULL, 0x0000003900397220ULL, 0x040fe40000410000ULL,
0x0000003c003c7220ULL, 0x040fe40000410000ULL, 0x0000003d003d7220ULL, 0x040fe40000410000ULL,
0x0000004000407220ULL, 0x040fe40000410000ULL, 0x0000004100417220ULL, 0x040fe40000410000ULL,
0x0000004400447220ULL, 0x000fc40000410000ULL, 0x0000004500457220ULL, 0x040fe40000410000ULL,
0x0000004800487220ULL, 0x040fe40000410000ULL, 0x0000004900497220ULL, 0x000fe40000410000ULL,
0x0000004e054e7220ULL, 0x044fe40000410000ULL, 0x0000004f054f7220ULL, 0x040fe40000410000ULL,
0x0000005205527220ULL, 0x000fc40000410000ULL, 0x0000005305537220ULL, 0x040fe40000410000ULL,
0x0000005605567220ULL, 0x040fe40000410000ULL, 0x0000005705577220ULL, 0x040fe40000410000ULL,
0x0000005a055a7220ULL, 0x040fe40000410000ULL, 0x0000005b055b7220ULL, 0x040fe40000410000ULL,
0x0000005e055e7220ULL, 0x000fc40000410000ULL, 0x0000005f055f7220ULL, 0x040fe40000410000ULL,
0x0000006205627220ULL, 0x040fe40000410000ULL, 0x0000006305637220ULL, 0x040fe40000410000ULL,
0x0000006605667220ULL, 0x040fe40000410000ULL, 0x0000006705677220ULL, 0x040fe40000410000ULL,
0x0000006a056a7220ULL, 0x000fc40000410000ULL, 0x0000006b056b7220ULL, 0x000fe40000410000ULL,
0x000000042e2e7220ULL, 0x088fe40000410000ULL, 0x000000042f2f7220ULL, 0x080fe40000410000ULL,
0x0000000432327220ULL, 0x080fe40000410000ULL, 0x0000000433337220ULL, 0x080fe40000410000ULL,
0x0000000436367220ULL, 0x000fc40000410000ULL, 0x0000000437377220ULL, 0x080fe40000410000ULL,
0x000000043a3a7220ULL, 0x080fe40000410000ULL, 0x000000043b3b7220ULL, 0x080fe40000410000ULL,
0x000000043e3e7220ULL, 0x080fe40000410000ULL, 0x000000043f3f7220ULL, 0x080fe40000410000ULL,
0x0000000442427220ULL, 0x000fc40000410000ULL, 0x0000000443437220ULL, 0x080fe40000410000ULL,
0x0000000446467220ULL, 0x080fe40000410000ULL, 0x0000000447477220ULL, 0x080fe40000410000ULL,
0x000000044a4a7220ULL, 0x080fe40000410000ULL, 0x000000044b4b7220ULL, 0x000fe40000410000ULL,
0x000000024c4c7220ULL, 0x000fc40000410000ULL, 0x000000024d4d7220ULL, 0x080fe40000410000ULL,
0x0000000250507220ULL, 0x080fe40000410000ULL, 0x0000000251517220ULL, 0x080fe40000410000ULL,
0x0000000254547220ULL, 0x080fe40000410000ULL, 0x0000000255557220ULL, 0x080fe40000410000ULL,
0x0000000258587220ULL, 0x000fc40000410000ULL, 0x0000000259597220ULL, 0x080fe40000410000ULL,
0x000000025c5c7220ULL, 0x080fe40000410000ULL, 0x000000025d5d7220ULL, 0x080fe40000410000ULL,
0x0000000260607220ULL, 0x080fe40000410000ULL, 0x0000000261617220ULL, 0x080fe40000410000ULL,
0x0000000264647220ULL, 0x000fc40000410000ULL, 0x0000000265657220ULL, 0x080fe40000410000ULL,
0x0000000268687220ULL, 0x080fe40000410000ULL, 0x0000000269697220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000323317723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fc400000010ffULL, 0x0000003a3b1b723eULL, 0x000fe400000010ffULL,
0x0000003e3f3e723eULL, 0x000fe400000010ffULL, 0x00000042431f723eULL, 0x000fe400000010ffULL,
0x000000464746723eULL, 0x000fe400000010ffULL, 0x0000004a4b23723eULL, 0x000fe400000010ffULL,
0x000054102e167816ULL, 0x000fc40000000017ULL, 0x0000000800057811ULL, 0x04cfe400078ff0ffULL,
0x0000000200027812ULL, 0x042fe400078ec0ffULL, 0x0000001800097811ULL, 0x000fe200078ff0ffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fe400078ff8ffULL,
0x0000001000057811ULL, 0x000fe200078ff0ffULL, 0x0000000809147824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fc400078ee203ULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe400078ff8ffULL,
0x0000000902057211ULL, 0x040fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x040fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x0000200020037824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fc40007ffe0ffULL, 0x0000200003037812ULL, 0x000fe400078ee2ffULL,
0xfffffff809087812ULL, 0x000fe400078ee202ULL, 0xfffffff805027812ULL, 0x000fe200078ee204ULL,
0x000010001a057824ULL, 0x000fe200078e0203ULL, 0x0000000404067810ULL, 0x040fe40007ffe0ffULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090c7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x000000100a107824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000010ffULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0x000000303104723eULL, 0x000fe200000010ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000404106723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x0000541002187816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x0000763202197816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000010ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000383904723eULL, 0x000fe200000010ffULL, 0x0000001808007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d05723eULL, 0x000fe200000010ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x0000004c4d4c723eULL, 0x000fe200000010ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000505126723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x000076322e177816ULL, 0x000fe20000000017ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000545554723eULL, 0x000fe200000010ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000444507723eULL, 0x000fc400000010ffULL, 0x000000484908723eULL, 0x002fe400000010ffULL,
0x0000541002187816ULL, 0x140fe40000000004ULL, 0x0000763202197816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000180a007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040c007388ULL, 0x0003e20000000a00ULL,
0x00000058592a723eULL, 0x000fe400000010ffULL, 0x000054103e1e7816ULL, 0x140fe2000000001fULL,
0x000000060e007388ULL, 0x0005e20000000a00ULL, 0x000076323e1f7816ULL, 0x000fe4000000001fULL,
0x0000541046227816ULL, 0x140fe20000000023ULL, 0x0000001610007388ULL, 0x000fe20000000a00ULL,
0x0000763246237816ULL, 0x000fc40000000023ULL, 0x0000541054087816ULL, 0x000fe4000000002aULL,
0x0000541036047816ULL, 0x142fe4000000001bULL, 0x0000763236057816ULL, 0x000fe4000000001bULL,
0x000054104c067816ULL, 0x144fe40000000026ULL, 0x000076324c077816ULL, 0x000fe20000000026ULL,
0x000400040a007388ULL, 0x0003e20000000a00ULL, 0x0000763254097816ULL, 0x000fc4000000002aULL,
0x0000005c5d5c723eULL, 0x000fe200000010ffULL, 0x0004001e0c007388ULL, 0x000fe20000000a00ULL,
0x000000606160723eULL, 0x000fe400000010ffULL, 0x000000646564723eULL, 0x000fe200000010ffULL,
0x000400220e007388ULL, 0x000fe20000000a00ULL, 0x000000686932723eULL, 0x000fe400000010ffULL,
0x0000004e4f02723eULL, 0x000fe200000010ffULL, 0x0000000612007388ULL, 0x0005e20000000a00ULL,
0x000000525304723eULL, 0x002fc400000010ffULL, 0x000000565705723eULL, 0x000fe200000010ffULL,
0x000800080a007388ULL, 0x0003e20000000a00ULL, 0x0000005a5b06723eULL, 0x004fe400000010ffULL,
0x000054105c087816ULL, 0x142fe40000000060ULL, 0x000076325c097816ULL, 0x000fca0000000060ULL,
0x000800080c007388ULL, 0x0003e40000000a00ULL, 0x0000541064087816ULL, 0x142fe40000000032ULL,
0x0000763264097816ULL, 0x000fca0000000032ULL, 0x000800080e007388ULL, 0x0003e40000000a00ULL,
0x0000541002087816ULL, 0x142fe40000000004ULL, 0x0000763202097816ULL, 0x000fe40000000004ULL,
0x0000005e5f02723eULL, 0x000fe400000010ffULL, 0x000000626304723eULL, 0x000fe200000010ffULL,
0x0000000814007388ULL, 0x0003e60000000a00ULL, 0x0000763202157816ULL, 0x000fc40000000004ULL,
0x0000541005087816ULL, 0x142fe40000000006ULL, 0x0000763205097816ULL, 0x000fe40000000006ULL,
0x0000541002147816ULL, 0x000fe20000000004ULL, 0x0000000177027824ULL, 0x000fe200078e0200ULL,
0x000000666705723eULL, 0x000fe200000010ffULL, 0x000c00080a007388ULL, 0x000fe20000000a00ULL,
0x0000006a6b06723eULL, 0x000fe200000010ffULL, 0x000000ff00047306ULL, 0x000fe40000205400ULL,
0x000c00140c007388ULL, 0x0003e20000000a00ULL, 0x00007632050d7816ULL, 0x000fc40000000006ULL,
0x00005410050c7816ULL, 0x002fe20000000006ULL, 0x0000001002067824ULL, 0x000fe400078e0203ULL,
0x000000ff00057306ULL, 0x000e640000209400ULL, 0x000c000c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000006087984ULL, 0x000ea20000000c00ULL,
0x000000ff00027306ULL, 0x000ee2000020d400ULL, 0x000000040500720bULL, 0x002fc40003f1d000ULL,
0x0004000006147984ULL, 0x000e680000000c00ULL, 0x0008000006247984ULL, 0x010e680000000c00ULL,
0x000c0000060c7984ULL, 0x000e680000000c00ULL, 0x0010000006107984ULL, 0x000e620000000c00ULL,
0x0000000102020812ULL, 0x008fc400078efcffULL, 0x000000ff1a00720cULL, 0x000fe20003f05270ULL,
0x00140000061c7984ULL, 0x000ee20000000c00ULL, 0x000000020204723eULL, 0x000fc600000010ffULL,
0x0018000006287984ULL, 0x000ee80000000c00ULL, 0x001c0000062c7984ULL, 0x000ee20000000c00ULL,
0x3f803f80040b7831ULL, 0x044fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fc40000200008ULL,
0x3f803f8004177831ULL, 0x042fe40000200017ULL, 0x3f803f8004167831ULL, 0x040fe40000200016ULL,
0x3f803f8004157831ULL, 0x040fe40000200015ULL, 0x3f803f8004147831ULL, 0x040fe40000200014ULL,
0x3f803f8004277831ULL, 0x040fe40000200027ULL, 0x3f803f8004267831ULL, 0x000fc40000200026ULL,
0x3f803f8004257831ULL, 0x040fe40000200025ULL, 0x3f803f8004247831ULL, 0x040fe40000200024ULL,
0x3f803f80040f7831ULL, 0x040fe4000020000fULL, 0x3f803f80040e7831ULL, 0x040fe4000020000eULL,
0x3f803f80040d7831ULL, 0x040fe4000020000dULL, 0x3f803f80040c7831ULL, 0x000fc4000020000cULL,
0x3f803f800b0b7831ULL, 0x000fe40000200013ULL, 0x3f803f800a0a7831ULL, 0x000fe40000200012ULL,
0x3f803f8009097831ULL, 0x000fe40000200011ULL, 0x3f803f8008087831ULL, 0x000fe40000200010ULL,
0x3f803f8017177831ULL, 0x008fe4000020001fULL, 0x3f803f8016167831ULL, 0x000fe2000020001eULL,
0x0000000806007388ULL, 0x000fe20000000c00ULL, 0x3f803f8015157831ULL, 0x000fc4000020001dULL,
0x3f803f8014147831ULL, 0x000fe4000020001cULL, 0x3f803f8027277831ULL, 0x000fe4000020002bULL,
0x3f803f8026267831ULL, 0x000fe2000020002aULL, 0x0004001406007388ULL, 0x000fe20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200029ULL, 0x3f803f8024247831ULL, 0x000fe40000200028ULL,
0x3f803f800f0f7831ULL, 0x000fc4000020002fULL, 0x3f803f800e0e7831ULL, 0x000fe2000020002eULL,
0x0008002406007388ULL, 0x000fe20000000c00ULL, 0x3f803f800d0d7831ULL, 0x000fe4000020002dULL,
0x3f803f800c0c7831ULL, 0x000fca000020002cULL, 0x000c000c06007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000740700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x100fe200078e0200ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000000120117812ULL, 0x000fe200078ec0ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000702057812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007000e7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe200078ef800ULL,
0x0000580000067ab9ULL, 0x000fc80000000800ULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000002076027824ULL, 0x000fe400078e0207ULL, 0x0000000811077824ULL, 0x000fe200078e020eULL,
0x0000000004087984ULL, 0x0004e40000000c00ULL, 0x0000000502067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe20000011602ULL, 0x00000006040472a4ULL, 0x002fc4000f8e023fULL,
0x0000000175067824ULL, 0x000fc800078e0206ULL, 0x0000008005057224ULL, 0x000fe200078e0206ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x0000000480027c24ULL, 0x000fc6000f8e02ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011606ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x004fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440cULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe200078e020dULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020760d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fe400078e0204ULL, 0x0000000811077824ULL, 0x002fc600078e0206ULL,
0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000d047a11ULL, 0x000fc800078040ffULL, 0x00005d000d057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0d7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000740d00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x00000060000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x0000008000077810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000800f0f7224ULL, 0x000fca00078e0204ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x00000003ff0f7819ULL, 0x000fc60000011607ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000740f00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107047824ULL, 0x102fe200078e020fULL,
0x000000a0000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0d7819ULL, 0x000fe4000001160cULL,
0x0ffffff804047812ULL, 0x000fe400078ef807ULL, 0x0000000707077812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e0207ULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800f0f7224ULL, 0x000fca00078e0204ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440eULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x000000c0000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x000000e000007810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff077819ULL, 0x000fe40000011600ULL,
0x0ffffff804047812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800f0f7224ULL, 0x000fe400078e0204ULL, 0x0000000100067824ULL, 0x002fc600078e0207ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x000000740700720cULL, 0x000fc60003f06070ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x00000007060d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff80d067812ULL, 0x000fe200078ef800ULL,
0x0000000804007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000002076077824ULL, 0x000fc600078e0207ULL, 0x0000000006087984ULL, 0x002e620000000c00ULL,
0x0000000811057824ULL, 0x000fe200078e0200ULL, 0x0000000507047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fc60000011607ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x0000008007077224ULL, 0x000fca00078e0204ULL, 0x0000000702077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fc800078040ffULL,
0x00005d0007037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x002fe20000011620ULL, 0xffffffffff0f7424ULL, 0x000fc600078e00ffULL,
0x0000001d0400720cULL, 0x000fda0003f06070ULL, 0x00000002be078824ULL, 0x000fc800078e00ffULL,
0x00006800070a8a24ULL, 0x000fc800078e0204ULL, 0x000064000a0a8625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff0c7624ULL, 0x000fe200078e00ffULL,
0x000000080a0f8981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff0d7624ULL, 0x000fc600078e00ffULL,
0x01a60000ff067f8cULL, 0x000e68000c80043fULL, 0x000000080c087981ULL, 0x000722000c1e9900ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x0000008019027824ULL, 0x000fe400078e00ffULL,
0x0000004020097824ULL, 0x000fe400078e00ffULL, 0x00000080bcbc7824ULL, 0x000fc600078e00ffULL,
0x0000004002247812ULL, 0x000fe200078ef809ULL, 0x0000000fbc3e7224ULL, 0x004fc800078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff387819ULL, 0x10afe4000001161fULL,
0x000062003e2d7a11ULL, 0x000fe400078038ffULL, 0x00000004380e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001240a7824ULL, 0x000fe200078e0238ULL, 0x0000000838127810ULL, 0x040fe40007ffe0ffULL,
0x0000001038107810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0b7824ULL, 0x100fe200078e021fULL,
0x0000000c38167810ULL, 0x000fe20007ffe0ffULL, 0x000000080e267824ULL, 0x000fe200078e00ffULL,
0x000063003e2f7a11ULL, 0x000fe200000f3cffULL, 0x00000001120c7824ULL, 0x000fe200078e021fULL,
0x00000014381a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008120d7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001c38327810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80d287812ULL, 0x000fe200078ee20cULL,
0x00000008100f7824ULL, 0x000fe200078e00ffULL, 0x000000700a147812ULL, 0x000fe200078ef803ULL,
0x00000001100a7824ULL, 0x100fe200078e021fULL, 0x000000091e0c7217ULL, 0x000fe20007800000ULL,
0x00000001160d7824ULL, 0x040fe200078e021fULL, 0x000000142d147210ULL, 0x000fe20007f1e0ffULL,
0x00000008162a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f2c7812ULL, 0x000fe200078ee20aULL,
0x000000010c217824ULL, 0x000fe200078e0a09ULL, 0x0000200020257811ULL, 0x000fe200078e70ffULL,
0x00000001240a7824ULL, 0x000fe200078e020eULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20dULL,
0x00000001240c7824ULL, 0x000fe200078e0212ULL, 0x000000210e00720cULL, 0x080fe20003fa6070ULL,
0x000000010b157824ULL, 0x000fe200000e062fULL, 0x000000211200720cULL, 0x080fe20003f26070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000211600720cULL, 0x000fc40003f46070ULL,
0x000000211000720cULL, 0x000fe20003f06070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000002038347810ULL, 0x040fe40007ffe0ffULL, 0x0000002438367810ULL, 0x000fe20007ffe0ffULL,
0x00000001240e7824ULL, 0x000fe200078e0216ULL, 0x000000700a167812ULL, 0x100fe200078ef803ULL,
0x0000000124107824ULL, 0x000fe200078e0210ULL, 0x000000700c187812ULL, 0x000fe200078ef803ULL,
0x0000000124127824ULL, 0x000fe200078e021aULL, 0x00000018380c7810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000002d16167210ULL, 0x000fc40007f7e0ffULL,
0x0000002d18187210ULL, 0x000fe20007f9e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc600078ef803ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007010107812ULL, 0x000fc600078ef803ULL, 0x00000001240a7824ULL, 0x000fe200078e020cULL,
0x0000007012127812ULL, 0x000fe200078ef803ULL, 0x000000010b177824ULL, 0x000fe200018e062fULL,
0x0000002d0e0e7210ULL, 0x080fe20007f7e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002d12127210ULL, 0x000fc60007fde0ffULL, 0x000000010d197824ULL, 0x000fe200020e062fULL,
0x0000002d10107210ULL, 0x000fe20007f9e0ffULL, 0x00000001380d7824ULL, 0x000fe200078e021fULL,
0x000000700a1b7812ULL, 0x000fe200078ef803ULL, 0x000000010f0f7824ULL, 0x100fe200018e062fULL,
0x000000211a00720cULL, 0x080fe20003f66070ULL, 0x0000000111117824ULL, 0x100fe200020e062fULL,
0x000000070d227812ULL, 0x000fe200078ec0ffULL, 0x0000000113137824ULL, 0x000fe200030e062fULL,
0x000000213800720cULL, 0x000fe20003f86070ULL, 0x000000011a0a7824ULL, 0x100fe200078e021fULL,
0x0ffffff822227812ULL, 0x000fe200078ef81fULL, 0x000000081a237824ULL, 0x000fe200078e00ffULL,
0x0000002d1b1a7210ULL, 0x000fe20007fde0ffULL, 0x00000001240d7824ULL, 0x000fc400078e0232ULL,
0x0000001022277824ULL, 0x000fe200078e0225ULL, 0xfffffff8232e7812ULL, 0x000fe200078ee20aULL,
0x000000010b1b7824ULL, 0x000fe400030e062fULL, 0x000000800d0a7825ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014277faeULL, 0x0003e2000e101c48ULL,
0x000000210c00720cULL, 0x000fe20003f86070ULL, 0x00000001240d7824ULL, 0x000fe200078e0234ULL,
0x000000700a227812ULL, 0x000fe200078ef803ULL, 0x000000010c0a7824ULL, 0x000fc400078e021fULL,
0x000000080c237824ULL, 0x000fe200078e00ffULL, 0x0000002d22227210ULL, 0x000fe20007fde0ffULL,
0x000000800d0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff823307812ULL, 0x000fe200078ee20aULL,
0x0000000124297824ULL, 0x000fe200078e0236ULL, 0x000000700c0c7812ULL, 0x000fe200078ef803ULL,
0x0000001026277824ULL, 0x002fe400078e0225ULL, 0x000000010b237824ULL, 0x000fe200030e062fULL,
0x0000002d0c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000080290a7825ULL, 0x000fe200078e00ffULL,
0x0000000016277faeULL, 0x0003e2000e901c48ULL, 0x000000213200720cULL, 0x040fe40003fa6070ULL,
0x0000000132157824ULL, 0x000fe200078e021fULL, 0x000000700a147812ULL, 0x000fe200078ef803ULL,
0x0000000832267824ULL, 0x000fe200078e00ffULL, 0x0000002838327810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200030e062fULL, 0x0000002d14147210ULL, 0x000fe20007fde0ffULL,
0x0000001028297824ULL, 0x000fe200078e0225ULL, 0xfffffff826267812ULL, 0x000fe200078ee215ULL,
0x00000001240a7824ULL, 0x000fc400078e0232ULL, 0x000000010b157824ULL, 0x000fe200030e062fULL,
0x0000000018297faeULL, 0x0005e2000c901c48ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000213400720cULL, 0x000fc60003f26070ULL, 0x0000000134177824ULL, 0x002fe200078e021fULL,
0x000000700a167812ULL, 0x000fe200078ef803ULL, 0x0000000834347824ULL, 0x000fe400078e00ffULL,
0x000000102a277824ULL, 0x000fe200078e0225ULL, 0x0000002d16167210ULL, 0x000fe20007fde0ffULL,
0x0000000136287824ULL, 0x000fe200078e021fULL, 0xfffffff8340a7812ULL, 0x000fe200078ee217ULL,
0x000000102c197824ULL, 0x004fe200078e0225ULL, 0x0000002c38187810ULL, 0x000fe20007ffe0ffULL,
0x000000010b177824ULL, 0x000fe200030e062fULL, 0x000000000e277faeULL, 0x0003e2000d101c48ULL,
0x000000102e0b7824ULL, 0x100fe200078e0225ULL, 0x000000213600720cULL, 0x080fe20003f46070ULL,
0x000000100a297824ULL, 0x100fe200078e0225ULL, 0x0000000010197faeULL, 0x0005e2000c101c48ULL,
0x00000001240a7824ULL, 0x000fe200078e0218ULL, 0x0000003c382a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008362b7824ULL, 0x000fe200078e00ffULL, 0x00000000120b7faeULL, 0x0007e4000d901c48ULL,
0x000000212a00720cULL, 0x080fe20003f06070ULL, 0x00000010300f7824ULL, 0x102fe200078e0225ULL,
0xfffffff82b287812ULL, 0x000fe200078ee228ULL, 0x0000001026277824ULL, 0x000fe200078e0225ULL,
0x0000003438267810ULL, 0x000fe20007ffe0ffULL, 0x0000000132117824ULL, 0x004fe200078e021fULL,
0x0000003038107810ULL, 0x000fe20007ffe0ffULL, 0x000000001a0f7faeULL, 0x0003e2000e101c48ULL,
0x00000010282b7824ULL, 0x000fe200078e0225ULL, 0x0000003838287810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x008fe200078e00ffULL, 0x0000000022277faeULL, 0x0005e2000e901c48ULL,
0x000000211000720cULL, 0x000fc40003f66070ULL, 0x0000000118127824ULL, 0x000fe200078e021fULL,
0x000000700a0e7812ULL, 0x000fe200078ef803ULL, 0x00000001240a7824ULL, 0x000fe200078e0210ULL,
0x000000000c297faeULL, 0x0007e2000c901c48ULL, 0x0000000810197824ULL, 0x000fe200078e00ffULL,
0x0000002d0e0e7210ULL, 0x000fe40007fde0ffULL, 0x00000000142b7faeULL, 0x0005e2000d101c48ULL,
0x000000211800720cULL, 0x080fe40003f86070ULL, 0x000000010b0f7824ULL, 0x002fe200030e062fULL,
0x000000213200720cULL, 0x080fe20003fa6070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000212600720cULL, 0x000fc40003f46070ULL, 0x000000212800720cULL, 0x000fe20003f26070ULL,
0x00000001240c7824ULL, 0x008fe200078e0226ULL, 0x000000700a137812ULL, 0x000fe200078ef803ULL,
0x00000001100a7824ULL, 0x000fe400078e021fULL, 0x0000000818157824ULL, 0x004fe200078e00ffULL,
0x0000002d13107210ULL, 0x000fe20007fde0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff8191a7812ULL, 0x000fe400078ee20aULL, 0xfffffff815187812ULL, 0x000fe200078ee212ULL,
0x0000000832147824ULL, 0x000fe200078e00ffULL, 0x000000700c127812ULL, 0x000fe200078ef803ULL,
0x00000001240a7824ULL, 0x000fc400078e0228ULL, 0x00000001260c7824ULL, 0x000fe200078e021fULL,
0xfffffff814147812ULL, 0x000fe200078ee211ULL, 0x000000010b117824ULL, 0x000fe200030e062fULL,
0x0000002d12127210ULL, 0x000fe20007fde0ffULL, 0x0000000826137824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff813227812ULL, 0x000fe200078ee20cULL,
0x0000000124247824ULL, 0x000fe200078e022aULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x000000010d137824ULL, 0x000fe400030e062fULL, 0x00000080240c7825ULL, 0x000fe200078e00ffULL,
0x0000002d0a0a7210ULL, 0x000fc60007fde0ffULL, 0x0000000128157824ULL, 0x000fe200078e021fULL,
0x000000700c037812ULL, 0x000fe200078ef803ULL, 0x0000000828247824ULL, 0x000fe400078e00ffULL,
0x000000012a1f7824ULL, 0x040fe400078e021fULL, 0x000000082a267824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee215ULL, 0x000000010b0b7824ULL, 0x000fe200030e062fULL,
0x0000002d030c7210ULL, 0x000fe20007fde0ffULL, 0x0000001014037824ULL, 0x000fe200078e0225ULL,
0xfffffff826267812ULL, 0x000fe200078ee21fULL, 0x0000001018157824ULL, 0x000fc400078e0225ULL,
0x000000101a197824ULL, 0x100fe200078e0225ULL, 0x0000000016037faeULL, 0x0003e2000e901c48ULL,
0x00000010221b7824ULL, 0x100fe400078e0225ULL, 0x00000010241f7824ULL, 0x100fe200078e0225ULL,
0x000000000e157faeULL, 0x0003e2000e101c48ULL, 0x0000001026257824ULL, 0x000fe400078e0225ULL,
0x000000010d0d7824ULL, 0x000fe200030e062fULL, 0x0000000010197faeULL, 0x0003e8000d901c48ULL,
0x00000000121b7faeULL, 0x0003e8000d101c48ULL, 0x000000000a1f7faeULL, 0x0003e8000c901c48ULL,
0x000000000c257faeULL, 0x0003e2000c101c48ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x000000101f137811ULL, 0x04afe400078fe8ffULL, 0x0000000c1f117811ULL, 0x000fc400078fe8ffULL,
0x000000081f0f7811ULL, 0x000fe200078fe8ffULL, 0x0000000113147824ULL, 0x100fe200078e021fULL,
0x000000041f0d7811ULL, 0x000fe200078fe8ffULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0x000000201f1b7811ULL, 0x000fe200078fe8ffULL, 0x00000001110c7824ULL, 0x100fe200078e021fULL,
0x0000002c1f297811ULL, 0x000fe200078fe8ffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0xfffffff819147812ULL, 0x000fe200078ee214ULL, 0x000000010f0b7824ULL, 0x100fe200078e021fULL,
0x0000001c1f197811ULL, 0x000fe200078fe8ffULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0xfffffff817127812ULL, 0x000fe200078ee20cULL, 0x000000010d0a7824ULL, 0x000fe200078e021fULL,
0x000000181f177811ULL, 0x000fe200078fe8ffULL, 0x000000080d157824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee20bULL, 0x00000001190c7824ULL, 0x100fe200078e021fULL,
0x000000301f2b7811ULL, 0x000fe200078fe8ffULL, 0x0000000819257824ULL, 0x000fe200078e00ffULL,
0xfffffff8150e7812ULL, 0x000fe200078ee20aULL, 0x00000001170b7824ULL, 0x100fe200078e021fULL,
0x000000141f157811ULL, 0x000fe200078fe8ffULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0xfffffff8251a7812ULL, 0x000fe200078ee20cULL, 0x000000011b217824ULL, 0x000fe200078e021fULL,
0x000000281f257811ULL, 0x000fe200078fe8ffULL, 0x000000081b227824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee20bULL, 0x00000001150a7824ULL, 0x000fe200078e021fULL,
0x000000381f2e7811ULL, 0x000fe200078fe8ffULL, 0x0000000815237824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee221ULL, 0x00000001250b7824ULL, 0x100fe200078e021fULL,
0x000000241f217811ULL, 0x000fe200078fe8ffULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0xfffffff823167812ULL, 0x000fe200078ee20aULL, 0x00000001290c7824ULL, 0x000fe200078e021fULL,
0x0000003c1f2f7811ULL, 0x000fe200078fe8ffULL, 0x00000008292d7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x00000001210a7824ULL, 0x100fe200078e021fULL,
0x0000001f1f0b7211ULL, 0x000fe200078fe8ffULL, 0x0000000821237824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2a7812ULL, 0x000fe200078ee20cULL, 0x000000012b277824ULL, 0x000fe200078e021fULL,
0x000000341f2d7811ULL, 0x000fe200078fe8ffULL, 0x000000082b2c7824ULL, 0x000fe200078e00ffULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000124287824ULL, 0x000fe200078e021bULL,
0xfffffff823237812ULL, 0x000fe200078ee20aULL, 0x000000012d0b7824ULL, 0x000fe200078e021fULL,
0x000000241f0a7211ULL, 0x000fe200078fe8ffULL, 0x000000082d407824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee227ULL, 0x00000001240d7824ULL, 0x000fe200078e020dULL,
0x0ffffff80c0c7812ULL, 0x000fe200078ef81fULL, 0x00000001240f7824ULL, 0x000fe200078e020fULL,
0x00002000204b7811ULL, 0x000fe200078e70ffULL, 0x0000000124117824ULL, 0x000fe200078e0211ULL,
0x000062003e4d7a11ULL, 0x000fe200078038ffULL, 0x0000000124137824ULL, 0x000fc400078e0213ULL,
0x0000000124157824ULL, 0x000fe200078e0215ULL, 0x000063003e4f7a11ULL, 0x000fe200000f3cffULL,
0x0000000124177824ULL, 0x040fe400078e0217ULL, 0x0000000124277824ULL, 0x000fe200078e0219ULL,
0xfffffff840197812ULL, 0x000fe200078ee20bULL, 0x0000000124307824ULL, 0x040fe400078e0221ULL,
0x0000000124327824ULL, 0x040fe400078e0225ULL, 0x0000000124347824ULL, 0x000fc400078e0229ULL,
0x0000000124367824ULL, 0x040fe400078e022bULL, 0x0000000124387824ULL, 0x040fe400078e022dULL,
0x00000001243a7824ULL, 0x000fe400078e022eULL, 0x000000012e1b7824ULL, 0x000fe400078e021fULL,
0x00000001243c7824ULL, 0x000fe400078e022fULL, 0x000000012f1f7824ULL, 0x000fc400078e021fULL,
0x000000082f247824ULL, 0x000fe400078e00ffULL, 0x000000082e2e7824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe400078ee21fULL,
0xfffffff82e1b7812ULL, 0x000fe200078ee21bULL, 0x000000100c1f7824ULL, 0x100fe400078e024bULL,
0x0000001018397824ULL, 0x000fe200078e024bULL, 0x000000700a187812ULL, 0x000fe200078ef803ULL,
0x000000100e217824ULL, 0x000fc400078e024bULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000000184d187210ULL, 0x000fc60007f1e0ffULL, 0x0000001010317824ULL, 0x000fe400078e024bULL,
0x000000800f0e7825ULL, 0x000fc800078e00ffULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x000000101a3b7824ULL, 0x000fe200078e024bULL, 0x000000700c1a7812ULL, 0x000fe200078ef803ULL,
0x0000001012337824ULL, 0x100fe400078e024bULL, 0x0000001014357824ULL, 0x100fe200078e024bULL,
0x0000001a4d1a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001016377824ULL, 0x100fe400078e024bULL,
0x00000010223d7824ULL, 0x000fe200078e024bULL, 0x000000700e227812ULL, 0x000fe200078ef803ULL,
0x00000010233f7824ULL, 0x000fc400078e024bULL, 0x0000001026417824ULL, 0x100fe400078e024bULL,
0x000000102a437824ULL, 0x100fe400078e024bULL, 0x000000102c457824ULL, 0x100fe400078e024bULL,
0x0000001019477824ULL, 0x100fe400078e024bULL, 0x000000101b497824ULL, 0x100fe400078e024bULL,
0x00000010244b7824ULL, 0x000fe200078e024bULL, 0x0000007010247812ULL, 0x000fe200078ef803ULL,
0x0000008013127825ULL, 0x000fc600078e00ffULL, 0x000000244d247210ULL, 0x000fe20007f5e0ffULL,
0x000000010b197824ULL, 0x100fe200000e064fULL, 0x000000224d227210ULL, 0x000fe20007f1e0ffULL,
0x000000010d1b7824ULL, 0x000fe200008e064fULL, 0x0000007012267812ULL, 0x000fe200078ef803ULL,
0x00000080150a7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181f7faeULL, 0x0003e6000b901c48ULL, 0x000000010f237824ULL, 0x100fe200000e064fULL,
0x000000264d267210ULL, 0x000fe20007f1e0ffULL, 0x00000080170c7825ULL, 0x000fe200078e00ffULL,
0x000000001a217faeULL, 0x0003e6000b901c48ULL, 0x0000000111257824ULL, 0x000fe200010e064fULL,
0x000000700c2a7812ULL, 0x100fe200078ef803ULL, 0x00000080270e7825ULL, 0x000fe200078e00ffULL,
0x0000000022317faeULL, 0x0003e4000b901c48ULL, 0x0000002a4d2a7210ULL, 0x000fe20007f3e0ffULL,
0x0000008028107825ULL, 0x000fe200078e00ffULL, 0x000000700a287812ULL, 0x100fe200078ef803ULL,
0x0000000024337faeULL, 0x0003e2000b901c48ULL, 0x000000700e2c7812ULL, 0x000fe200078ef803ULL,
0x0000000113277824ULL, 0x000fe200000e064fULL, 0x00000070102e7812ULL, 0x000fe200078ef803ULL,
0x000000010d2b7824ULL, 0x100fe200008e064fULL, 0x000000284d287210ULL, 0x040fe20007f1e0ffULL,
0x00000080320c7825ULL, 0x000fe200078e00ffULL, 0x0000002c4d2c7210ULL, 0x040fe20007f5e0ffULL,
0x0000000026357faeULL, 0x0003e2000b901c48ULL, 0x0000002e4d2e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010b297824ULL, 0x000fe200000e064fULL, 0x000000700c0c7812ULL, 0x000fe200078ef803ULL,
0x00000080300a7825ULL, 0x000fc600078e00ffULL, 0x0000000c4d0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f2d7824ULL, 0x000fe200010e064fULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x00000001112f7824ULL, 0x000fe200018e064fULL, 0x0000000028377faeULL, 0x0003e2000b901c48ULL,
0x00000080340e7825ULL, 0x000fe200078e00ffULL, 0x0000000a4d0a7210ULL, 0x000fe40007f1e0ffULL,
0x000000002a397faeULL, 0x0003e2000b901c48ULL, 0x0000008036107825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc400078ef803ULL, 0x000000002c3b7faeULL, 0x0003e2000b901c48ULL,
0x0000008038127825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x100fe400078ef803ULL,
0x0000000e4d0e7210ULL, 0x040fe20007f5e0ffULL, 0x000000803a147825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x100fe200078ef803ULL, 0x000000002e3d7faeULL, 0x0003e2000b901c48ULL,
0x000000104d107210ULL, 0x000fe20007f7e0ffULL, 0x000000803c167825ULL, 0x000fe200078e00ffULL,
0x0000007014147812ULL, 0x000fc400078ef803ULL, 0x000000124d127210ULL, 0x000fe20007f9e0ffULL,
0x000000010b0b7824ULL, 0x000fe200000e064fULL, 0x0000007016037812ULL, 0x000fe200078ef803ULL,
0x000000010d0d7824ULL, 0x100fe200008e064fULL, 0x000000144d147210ULL, 0x000fe20007fbe0ffULL,
0x000000010f0f7824ULL, 0x100fe200010e064fULL, 0x000000034d167210ULL, 0x000fe20007fde0ffULL,
0x0000000111117824ULL, 0x100fe200018e064fULL, 0x000000000a3f7faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x100fe400020e064fULL, 0x0000000115157824ULL, 0x100fe200028e064fULL,
0x000000000c417faeULL, 0x0003e2000b901c48ULL, 0x0000000117177824ULL, 0x000fc600030e064fULL,
0x000000000e437faeULL, 0x0003e8000b901c48ULL, 0x0000000010457faeULL, 0x0003e8000b901c48ULL,
0x0000000012477faeULL, 0x0003e8000b901c48ULL, 0x0000000014497faeULL, 0x0003e8000b901c48ULL,
0x00000000164b7faeULL, 0x0003e4000b901c48ULL, 0x0000000204037810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000001d0300720cULL, 0x000fda0003f06070ULL, 0x00000002be0a8824ULL, 0x000fc800078e00ffULL,
0x000068000a0a8a24ULL, 0x000fc800078e0203ULL, 0x000064000a0a8625ULL, 0x000fca00078e0005ULL,
0x000000080a048981ULL, 0x000324000c1e1900ULL, 0x00000000000a7805ULL, 0x002fc40000015200ULL,
0x01a60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140dULL,
0x0000000c05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000205057819ULL, 0x000fc8000000120cULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002020057824ULL, 0x002fca00078e0205ULL,
0x00000004ff067819ULL, 0x000fe40000011605ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe060a7812ULL, 0x000fe400078ec0ffULL, 0x0000001f05067812ULL, 0x000fc600078ec0ffULL,
0x000000010a0c7824ULL, 0x040fe400078e0207ULL, 0x00000001050b7824ULL, 0x000fe200078e020aULL,
0x000000080a0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010060d7824ULL, 0x000fe200078e00ffULL,
0x0000000f0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x000fe200078e020aULL,
0x000001f00d0c7812ULL, 0x000fe200078ee20cULL, 0x0000000105057824ULL, 0x000fe200078e020aULL,
0x000001f00e0b7812ULL, 0x000fe200078ee20bULL, 0x00000010060a7824ULL, 0x040fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x000000000c107984ULL, 0x000e62000000cc00ULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000f05057812ULL, 0x000fc400078ec0ffULL,
0x000000000b147984ULL, 0x000ea4000000cc00ULL, 0x000001f006077812ULL, 0x000fe400078ee207ULL,
0x000001f00a057812ULL, 0x000fe200078ee205ULL, 0x000000ffff1a7224ULL, 0x002fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff187224ULL, 0x004fe400078e0014ULL,
0x000000ffff197224ULL, 0x000fc400078e0016ULL, 0x000000ffff267224ULL, 0x000fe400078e0011ULL,
0x000000ffff277224ULL, 0x000fe200078e0013ULL, 0x000000180b007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff247224ULL, 0x000fe400078e0015ULL, 0x000000ffff257224ULL, 0x000fca00078e0017ULL,
0x000000240c007388ULL, 0x000fe8000000cc00ULL, 0x0000000007107984ULL, 0x000e68000000cc00ULL,
0x0000000005147984ULL, 0x000ea2000000cc00ULL, 0x000000ffff2b7224ULL, 0x002fe400078e0012ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff287224ULL, 0x004fe400078e0014ULL, 0x000000ffff297224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x0000002805007388ULL, 0x0003e8000000cc00ULL, 0x0000001007007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a60000ff0c7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0e7224ULL, 0x000fc600078e00ffULL, 0x0000000000067805ULL, 0x002fc80000015200ULL,
0x01a60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00005800ff0c7624ULL, 0x000fe200078e00ffULL, 0x800058001e0d7a10ULL, 0x000fe20007ffe0ffULL,
0x3db504f308077820ULL, 0x010fe20000410000ULL, 0x0000010009067810ULL, 0x000fe20007ffe0ffULL,
0x00006800bebe7a24ULL, 0x000fe200078e02ffULL, 0x0000001f0c0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0001a68820087811ULL, 0x000fe200078e18ffULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00000004ff0e7819ULL, 0x000fc4000001160bULL,
0xffffffff0c0b7810ULL, 0x000fe40007ffe0ffULL, 0x0001a60820bb7811ULL, 0x000fe400078e28ffULL,
0x000000090c0c7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff0d7819ULL, 0x000fe4000001160dULL,
0x0ffffffe0e0e7812ULL, 0x000fc400078ec0ffULL, 0x0000000209117810ULL, 0x040fe20007ffe0ffULL,
0x00000100090f7824ULL, 0x000fe200078e0206ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000004bc337224ULL, 0x010fe200078e02ffULL, 0x0000001c1100720cULL, 0x000fc40003f06070ULL,
0x000000400f117812ULL, 0x000fe400078ec0ffULL, 0x000000010a107812ULL, 0x000fc600078e0cffULL,
0x0000000102047824ULL, 0x000fcc00078e0211ULL, 0x00000cc000008947ULL, 0x00cfea0003800000ULL,
0x00000003ff2c7819ULL, 0x102fe20000011605ULL, 0x00000002201f7824ULL, 0x000fe200078e0210ULL,
0x0000620033317a11ULL, 0x040fe400078038ffULL, 0x000000042c167810ULL, 0x040fe20007ffe0ffULL,
0x000000012c127824ULL, 0x040fe200078e0204ULL, 0x000000082c187810ULL, 0x040fe40007ffe0ffULL,
0x000000102c247810ULL, 0x000fe20007ffe0ffULL, 0x0000000116117824ULL, 0x100fe200078e0205ULL,
0x0000000c2c1a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008162e7824ULL, 0x000fe200078e00ffULL,
0x0000000f1e147217ULL, 0x000fe20007800000ULL, 0x0000000118137824ULL, 0x040fe200078e0205ULL,
0x0000630033337a11ULL, 0x000fe200000f3cffULL, 0x0000000818307824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee211ULL, 0x0000001005117824ULL, 0x000fe200078e00ffULL,
0x000000142c2a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000824157824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007011357812ULL, 0x000fc400078ec0ffULL, 0x000000182c387810ULL, 0x000fe20007ffe0ffULL,
0x000000011a117824ULL, 0x100fe200078e0205ULL, 0x0000003512227212ULL, 0x000fe200078efcffULL,
0x0000000124127824ULL, 0x000fe200078e0205ULL, 0x0000001c2c3a7810ULL, 0x000fe20007ffe0ffULL,
0x000000081a327824ULL, 0x000fe200078e00ffULL, 0x0000002231227210ULL, 0x000fe20007f1e0ffULL,
0x000000082a367824ULL, 0x000fe200078e00ffULL, 0xfffffff815347812ULL, 0x000fe200078ee212ULL,
0x0000000116127824ULL, 0x100fe200078e0204ULL, 0xfffffff832327812ULL, 0x000fe200078ee211ULL,
0x0000000114117824ULL, 0x000fe200078e0a0fULL, 0x000020001f1f7811ULL, 0x000fe200078e68ffULL,
0x0000000118147824ULL, 0x000fe200078e0204ULL, 0x000000202c3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113237824ULL, 0x000fe200000e0633ULL, 0x000000111600720cULL, 0x080fe20003fa6070ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000111800720cULL, 0x000fc40003f26070ULL,
0x000000111a00720cULL, 0x080fe20003f46070ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000112400720cULL, 0x000fe40003f06070ULL, 0x000000242c3e7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a167824ULL, 0x100fe200078e0204ULL, 0x0000003514267212ULL, 0x080fe200078efcffULL,
0x0000000124187824ULL, 0x100fe200078e0204ULL, 0x0000003512247212ULL, 0x000fe200078efcffULL,
0x000000012a1a7824ULL, 0x100fe200078e0204ULL, 0x0000003126267210ULL, 0x080fe20007f9e0ffULL,
0x0000000138127824ULL, 0x000fe200078e0204ULL, 0x0000003124247210ULL, 0x000fe20007f7e0ffULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000351a1a7212ULL, 0x000fc600078efcffULL, 0x0000000113257824ULL, 0x000fe200018e0633ULL,
0x0000003516167212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x0000003116167210ULL, 0x080fe20007f7e0ffULL, 0x0000000115277824ULL, 0x000fe200020e0633ULL,
0x000000311a1a7210ULL, 0x000fe20007f9e0ffULL, 0x000000012c147824ULL, 0x000fe200078e0205ULL,
0x0000003512287212ULL, 0x000fe200078efcffULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0x0000000714147812ULL, 0x000fe200078ec0ffULL, 0x000000011b1b7824ULL, 0x100fe200020e0633ULL,
0x000000112c00720cULL, 0x000fe20003f86070ULL, 0x000000013a127824ULL, 0x000fe200078e0204ULL,
0x0000003518187212ULL, 0x000fe200078efcffULL, 0x0000000117177824ULL, 0x000fe200018e0633ULL,
0x0000003128287210ULL, 0x080fe20007fde0ffULL, 0x000000012a157824ULL, 0x100fe200078e0205ULL,
0x0ffffff814147812ULL, 0x100fe200078ef805ULL, 0x00000001382b7824ULL, 0x000fe200078e0205ULL,
0x0000003118187210ULL, 0x000fe20007f7e0ffULL, 0x0000000113297824ULL, 0x000fe200030e0633ULL,
0xfffffff836367812ULL, 0x000fe200078ee215ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000001014217824ULL, 0x000fe400078e021fULL, 0x0000000119197824ULL, 0x000fe200018e0633ULL,
0x000000112a00720cULL, 0x000fe20003f66070ULL, 0x000000013c147824ULL, 0x000fe200078e0204ULL,
0x00000035122a7212ULL, 0x000fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022217faeULL, 0x0003e2000e101c48ULL, 0x000000113800720cULL, 0x040fe20003f86070ULL,
0x0000000838387824ULL, 0x000fe200078e00ffULL, 0x000000312a2a7210ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee22bULL,
0x000000013e127824ULL, 0x000fe200078e0204ULL, 0x0000003514147212ULL, 0x000fe200078efcffULL,
0x00000001132b7824ULL, 0x000fe400030e0633ULL, 0x000000102e217824ULL, 0x002fe200078e021fULL,
0x0000003114147210ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x0000000024217faeULL, 0x0003e2000e901c48ULL, 0x000000113a00720cULL, 0x040fe20003fa6070ULL,
0x000000013a237824ULL, 0x000fe200078e0205ULL, 0x0000003512227212ULL, 0x000fe200078efcffULL,
0x000000083a2e7824ULL, 0x000fe200078e00ffULL, 0x000000282c3a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000115157824ULL, 0x000fe200030e0633ULL, 0x0000003122227210ULL, 0x000fe20007fde0ffULL,
0x00000010302d7824ULL, 0x000fe200078e021fULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee223ULL,
0x000000013a127824ULL, 0x000fe200078e0204ULL, 0x000000342c307810ULL, 0x000fe20007ffe0ffULL,
0x0000000113237824ULL, 0x000fe200030e0633ULL, 0x00000000262d7faeULL, 0x0005e2000c901c48ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000113c00720cULL, 0x000fc60003f26070ULL,
0x000000013c257824ULL, 0x002fe200078e0205ULL, 0x0000003512247212ULL, 0x000fe200078efcffULL,
0x000000083c3c7824ULL, 0x000fe400078e00ffULL, 0x0000001032217824ULL, 0x000fe200078e021fULL,
0x0000003124247210ULL, 0x000fe20007fde0ffULL, 0x000000013e2f7824ULL, 0x000fe200078e0205ULL,
0xfffffff83c127812ULL, 0x000fe200078ee225ULL, 0x0000001034277824ULL, 0x004fe200078e021fULL,
0x0000002c2c267810ULL, 0x000fe20007ffe0ffULL, 0x0000000016217faeULL, 0x0003e2000d101c48ULL,
0x000000113e00720cULL, 0x000fe20003f46070ULL, 0x0000000113257824ULL, 0x000fe200030e0633ULL,
0x000000382c327810ULL, 0x000fe20007ffe0ffULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0x0000000018277faeULL, 0x0005e2000c101c48ULL, 0x0000001036137824ULL, 0x000fc400078e021fULL,
0x00000010122d7824ULL, 0x000fe400078e021fULL, 0x0000000126127824ULL, 0x000fe200078e0204ULL,
0x000000001a137faeULL, 0x0007e2000d901c48ULL, 0xfffffff83e167812ULL, 0x002fe200078ee22fULL,
0x000000102e217824ULL, 0x100fe200078e021fULL, 0x000000302c2e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001038177824ULL, 0x100fe200078e021fULL, 0x0000003c2c2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010162f7824ULL, 0x000fe200078e021fULL, 0x000000112e00720cULL, 0x080fe20003f66070ULL,
0x0000000126197824ULL, 0x044fe200078e0205ULL, 0x0000000028177faeULL, 0x0003e2000e101c48ULL,
0x000000112600720cULL, 0x0c0fe20003f86070ULL, 0x0000000826267824ULL, 0x000fe200078e00ffULL,
0x000000112c00720cULL, 0x080fe20003f06070ULL, 0x0000008012127825ULL, 0x008fe200078e00ffULL,
0x000000002a217faeULL, 0x0005e2000e901c48ULL, 0x000000113a00720cULL, 0x000fc40003fa6070ULL,
0x000000082e1b7824ULL, 0x000fe200078e00ffULL, 0x0000003512167212ULL, 0x000fe200078efcffULL,
0x000000012e127824ULL, 0x000fe200078e0204ULL, 0x00000000142d7faeULL, 0x0007e2000c901c48ULL,
0x000000113200720cULL, 0x000fe40003f26070ULL, 0x0000003116167210ULL, 0x000fe20007fde0ffULL,
0x00000000222f7faeULL, 0x0009e2000d101c48ULL, 0x000000113000720cULL, 0x000fe20003f46070ULL,
0x000000013a117824ULL, 0x000fe200078e0205ULL, 0xfffffff826267812ULL, 0x000fe200078ee219ULL,
0x0000000113177824ULL, 0x002fc400030e0633ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000130147824ULL, 0x008fe200078e0204ULL, 0x0000003512187212ULL, 0x000fe200078efcffULL,
0x000000012e127824ULL, 0x000fe400078e0205ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003118187210ULL, 0x000fe40007fde0ffULL, 0xfffffff81b287812ULL, 0x000fe200078ee212ULL,
0x000000083a227824ULL, 0x010fe200078e00ffULL, 0x00000035141a7212ULL, 0x000fe200078efcffULL,
0x0000000132127824ULL, 0x000fc400078e0204ULL, 0x0000000113197824ULL, 0x000fe200030e0633ULL,
0x000000311a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fc600078ee211ULL, 0x0000000130117824ULL, 0x000fe200078e0205ULL,
0x0000003512127212ULL, 0x000fe200078efcffULL, 0x000000012c147824ULL, 0x000fe400078e0204ULL,
0x0000000830307824ULL, 0x000fe400078e00ffULL, 0x00000001151b7824ULL, 0x000fe200030e0633ULL,
0x0000003112127210ULL, 0x000fe20007fde0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff830047812ULL, 0x000fc600078ee211ULL, 0x0000000132117824ULL, 0x100fe200078e0205ULL,
0x0000003514147212ULL, 0x000fe200078efcffULL, 0x00000008322a7824ULL, 0x004fe400078e00ffULL,
0x000000012c217824ULL, 0x040fe400078e0205ULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL, 0x0000000113137824ULL, 0x000fe200030e0633ULL,
0x0000003114147210ULL, 0x000fe20007fde0ffULL, 0x0000001022117824ULL, 0x000fe200078e021fULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee221ULL, 0x0000001026217824ULL, 0x000fc400078e021fULL,
0x0000001028237824ULL, 0x100fe200078e021fULL, 0x0000000024117faeULL, 0x0003e2000e901c48ULL,
0x0000001004277824ULL, 0x100fe400078e021fULL, 0x000000102a297824ULL, 0x100fe200078e021fULL,
0x0000000016217faeULL, 0x0003e2000e101c48ULL, 0x000000102c1f7824ULL, 0x000fe400078e021fULL,
0x0000000115157824ULL, 0x000fe200030e0633ULL, 0x0000000018237faeULL, 0x0003e8000d901c48ULL,
0x000000001a277faeULL, 0x0003e8000d101c48ULL, 0x0000000012297faeULL, 0x0003e8000c901c48ULL,
0x00000000141f7faeULL, 0x0003e2000c101c48ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000405147811ULL, 0x042fe400078fe8ffULL, 0x0000000c05187811ULL, 0x000fc400078fe8ffULL,
0x0000000805167811ULL, 0x040fe200078fe8ffULL, 0x0000000114117824ULL, 0x140fe200078e0205ULL,
0x0000001805237811ULL, 0x040fe200078fe8ffULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0x0000002405387811ULL, 0x040fe200078fe8ffULL, 0x0000000118137824ULL, 0x040fe200078e0205ULL,
0x0000002005257811ULL, 0x040fe200078fe8ffULL, 0x0000000818227824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1f7812ULL, 0x000fe200078ee211ULL, 0x0000000116127824ULL, 0x040fe200078e0205ULL,
0x00000010051a7811ULL, 0x000fe200078fe8ffULL, 0x0000000816217824ULL, 0x000fe200078e00ffULL,
0xfffffff822397812ULL, 0x000fe200078ee213ULL, 0x0000000123137824ULL, 0x100fe200078e0205ULL,
0x0000001405227811ULL, 0x000fe200078fe8ffULL, 0x000000011a117824ULL, 0x140fe200078e0205ULL,
0xfffffff821217812ULL, 0x000fe200078ee212ULL, 0x000000081a247824ULL, 0x000fe200078e00ffULL,
0x00000030053e7811ULL, 0x000fe200078fe8ffULL, 0x0000000823267824ULL, 0x000fe200078e00ffULL,
0x0000002c053c7811ULL, 0x040fe200078fe8ffULL, 0x0000000122127824ULL, 0x000fe200078e0205ULL,
0xfffffff8243b7812ULL, 0x000fe200078ee211ULL, 0x00000008223d7824ULL, 0x000fe200078e00ffULL,
0x0000001c05247811ULL, 0x000fe200078fe8ffULL, 0x0000000838287824ULL, 0x000fe200078e00ffULL,
0xfffffff8263f7812ULL, 0x000fe200078ee213ULL, 0x0000000138137824ULL, 0x100fe200078e0205ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee212ULL, 0x0000000125127824ULL, 0x000fe200078e0205ULL,
0x00000028053a7811ULL, 0x000fe200078fe8ffULL, 0x0000000825437824ULL, 0x000fe200078e00ffULL,
0xfffffff828457812ULL, 0x000fe200078ee213ULL, 0x0000000124117824ULL, 0x140fe200078e0205ULL,
0x0000003c05447811ULL, 0x000fe200078fe8ffULL, 0x0000000824267824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee212ULL, 0x000000013e137824ULL, 0x040fe200078e0205ULL,
0x0000003805427811ULL, 0x040fe200078fe8ffULL, 0x000000083e287824ULL, 0x000fe200078e00ffULL,
0xfffffff826417812ULL, 0x000fe200078ee211ULL, 0x000000013c127824ULL, 0x040fe200078e0205ULL,
0x0000003405407811ULL, 0x000fe200078fe8ffULL, 0x000000083c497824ULL, 0x000fe200078e00ffULL,
0xfffffff8284b7812ULL, 0x000fe200078ee213ULL, 0x000000013a117824ULL, 0x140fe200078e0205ULL,
0x0000620033557a11ULL, 0x000fe200078038ffULL, 0x000000083a267824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee212ULL, 0x0000000144137824ULL, 0x040fe200078e0205ULL,
0x0000630033577a11ULL, 0x000fe200000f3cffULL, 0x0000000844287824ULL, 0x000fe200078e00ffULL,
0xfffffff826477812ULL, 0x000fe200078ee211ULL, 0x0000000142127824ULL, 0x000fc400078e0205ULL,
0x00000008424f7824ULL, 0x000fe200078e00ffULL, 0xfffffff828517812ULL, 0x000fe200078ee213ULL,
0x0000000140117824ULL, 0x040fe400078e0205ULL, 0x0000000840267824ULL, 0x000fe200078e00ffULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee212ULL, 0x0000000220137824ULL, 0x000fe200078e0210ULL,
0x0000000405127211ULL, 0x040fe200078fe8ffULL, 0x0000000114147824ULL, 0x100fe200078e0204ULL,
0xfffffff8264d7812ULL, 0x000fe200078ee211ULL, 0x0000000116167824ULL, 0x100fe200078e0204ULL,
0x0000000505117211ULL, 0x000fe200078fe8ffULL, 0x0000000118187824ULL, 0x100fe200078e0204ULL,
0x0000200013287811ULL, 0x000fe200078e68ffULL, 0x000000011a1a7824ULL, 0x100fe200078e0204ULL,
0x0000000711267812ULL, 0x000fe200078ec0ffULL, 0x0000000122227824ULL, 0x000fc400078e0204ULL,
0x0000000123237824ULL, 0x100fe200078e0204ULL, 0x0ffffff826117812ULL, 0x000fe200078ef805ULL,
0x0000000124247824ULL, 0x100fe400078e0204ULL, 0x0000000125257824ULL, 0x100fe400078e0204ULL,
0x0000000138387824ULL, 0x100fe400078e0204ULL, 0x000000013a3a7824ULL, 0x100fe400078e0204ULL,
0x000000013c3c7824ULL, 0x000fc400078e0204ULL, 0x000000013e3e7824ULL, 0x100fe400078e0204ULL,
0x0000000140407824ULL, 0x100fe400078e0204ULL, 0x0000000142427824ULL, 0x100fe400078e0204ULL,
0x0000000144447824ULL, 0x000fe400078e0204ULL, 0x0000001005047824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000007004537812ULL, 0x000fe200078ec0ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x0000005312267212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000002655267210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000053162a7212ULL, 0x000fc600078efcffULL,
0x0000001011117824ULL, 0x100fe200078e0228ULL, 0x00000053182c7212ULL, 0x000fe200078efcffULL,
0x000000101f1f7824ULL, 0x100fe400078e0228ULL, 0x0000001021217824ULL, 0x100fe200078e0228ULL,
0x0000002c552c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001039397824ULL, 0x100fe400078e0228ULL,
0x000000103b3b7824ULL, 0x100fe400078e0228ULL, 0x000000103d3d7824ULL, 0x000fc400078e0228ULL,
0x000000103f3f7824ULL, 0x100fe400078e0228ULL, 0x0000001041417824ULL, 0x100fe400078e0228ULL,
0x0000001043437824ULL, 0x100fe400078e0228ULL, 0x0000001045457824ULL, 0x100fe400078e0228ULL,
0x0000001047477824ULL, 0x100fe400078e0228ULL, 0x0000001049497824ULL, 0x000fc400078e0228ULL,
0x000000104b4b7824ULL, 0x100fe400078e0228ULL, 0x000000104d4d7824ULL, 0x100fe400078e0228ULL,
0x000000104f4f7824ULL, 0x100fe400078e0228ULL, 0x0000001051517824ULL, 0x000fe200078e0228ULL,
0x0000005314287212ULL, 0x000fe200078efcffULL, 0x000000801a1a7825ULL, 0x000fc600078e00ffULL,
0x0000002855287210ULL, 0x000fe20007f3e0ffULL, 0x0000000113277824ULL, 0x100fe200000e0657ULL,
0x0000002a552a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008022127825ULL, 0x000fe200078e00ffULL,
0x000000531a2e7212ULL, 0x080fe400078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026117faeULL, 0x0003e2000b901c48ULL, 0x0000000115297824ULL, 0x100fe200008e0657ULL,
0x0000005312307212ULL, 0x080fe200078efcffULL, 0x00000001172b7824ULL, 0x100fe200000e0657ULL,
0x0000002e552e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008023147825ULL, 0x000fe200078e00ffULL,
0x00000000281f7faeULL, 0x0003e6000b901c48ULL, 0x00000001192d7824ULL, 0x100fe200010e0657ULL,
0x0000005314327212ULL, 0x080fe200078efcffULL, 0x0000008024167825ULL, 0x000fe200078e00ffULL,
0x000000002a217faeULL, 0x0003e4000b901c48ULL, 0x0000003255327210ULL, 0x000fe20007f3e0ffULL,
0x0000008025187825ULL, 0x000fe200078e00ffULL, 0x0000005316347212ULL, 0x080fe200078efcffULL,
0x000000002c397faeULL, 0x0003e4000b901c48ULL, 0x000000011b2f7824ULL, 0x100fe200000e0657ULL,
0x0000005318367212ULL, 0x080fe200078efcffULL, 0x0000000115337824ULL, 0x100fe200008e0657ULL,
0x0000003055307210ULL, 0x040fe20007f1e0ffULL, 0x000000803a147825ULL, 0x000fe200078e00ffULL,
0x0000003455347210ULL, 0x040fe20007f5e0ffULL, 0x000000002e3b7faeULL, 0x0003e2000b901c48ULL,
0x0000003655367210ULL, 0x000fe20007f7e0ffULL, 0x0000000113317824ULL, 0x000fe200000e0657ULL,
0x0000005314147212ULL, 0x000fe200078efcffULL, 0x0000008038127825ULL, 0x000fc600078e00ffULL,
0x0000001455147210ULL, 0x000fe20007f3e0ffULL, 0x0000000117357824ULL, 0x100fe200010e0657ULL,
0x0000005312127212ULL, 0x080fe200078efcffULL, 0x0000000119377824ULL, 0x000fe200018e0657ULL,
0x00000000303d7faeULL, 0x0003e2000b901c48ULL, 0x000000803c167825ULL, 0x000fe200078e00ffULL,
0x0000001255127210ULL, 0x000fe40007f1e0ffULL, 0x00000000323f7faeULL, 0x0003e2000b901c48ULL,
0x000000803e187825ULL, 0x000fe200078e00ffULL, 0x0000005316167212ULL, 0x000fc400078efcffULL,
0x0000000034417faeULL, 0x0003e2000b901c48ULL, 0x00000080401a7825ULL, 0x000fe200078e00ffULL,
0x0000005318187212ULL, 0x080fe400078efcffULL, 0x0000001655167210ULL, 0x040fe20007f5e0ffULL,
0x0000008042227825ULL, 0x000fe200078e00ffULL, 0x000000531a1a7212ULL, 0x080fe200078efcffULL,
0x0000000036437faeULL, 0x0003e2000b901c48ULL, 0x0000001855187210ULL, 0x000fe20007f7e0ffULL,
0x0000008044247825ULL, 0x000fe200078e00ffULL, 0x0000005322227212ULL, 0x000fc400078efcffULL,
0x0000001a551a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000113137824ULL, 0x100fe200000e0657ULL,
0x0000005324247212ULL, 0x000fe200078efcffULL, 0x0000000115157824ULL, 0x100fe200008e0657ULL,
0x0000002255227210ULL, 0x000fe20007fbe0ffULL, 0x0000000117177824ULL, 0x100fe200010e0657ULL,
0x0000002455247210ULL, 0x000fe20007fde0ffULL, 0x0000000119197824ULL, 0x100fe200018e0657ULL,
0x0000000012457faeULL, 0x0003e2000b901c48ULL, 0x000000011b1b7824ULL, 0x100fe400020e0657ULL,
0x0000000123237824ULL, 0x100fe200028e0657ULL, 0x0000000014477faeULL, 0x0003e2000b901c48ULL,
0x0000000125257824ULL, 0x000fc600030e0657ULL, 0x0000000016497faeULL, 0x0003e8000b901c48ULL,
0x00000000184b7faeULL, 0x0003e8000b901c48ULL, 0x000000001a4d7faeULL, 0x0003e8000b901c48ULL,
0x00000000224f7faeULL, 0x0003e8000b901c48ULL, 0x0000000024517faeULL, 0x0003e4000b901c48ULL,
0x0000000203037810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000001d0300720cULL, 0x000fda0003f06070ULL,
0x00000002be128824ULL, 0x002fe400078e0203ULL, 0x00000004ff138424ULL, 0x000fc800078e00ffULL,
0x0000640012128625ULL, 0x000fe200078e0013ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000000812048981ULL, 0x000322000c1e1900ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000727805ULL, 0x000fe2000001ff00ULL,
0x0000000000707805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000006a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x002fc80000000000ULL,
0xfffffff805127812ULL, 0x000fe200078ec0ffULL, 0x0000000220237824ULL, 0x000fe200078e020aULL,
0x0000000111757810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000712127812ULL, 0x000fc400078ef805ULL, 0x0000200023237811ULL, 0x000fe400078e68ffULL,
0x0000002005167810ULL, 0x000fe20007ffe0ffULL, 0x0000000112137824ULL, 0x040fe400078e0211ULL,
0x0000000812147824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fc800078ec0ffULL,
0xfffffff814147812ULL, 0x000fe200078ee213ULL, 0x0000000812137824ULL, 0x000fe200078e00ffULL,
0x0000000716747812ULL, 0x000fe200078ef805ULL, 0x0000000112127824ULL, 0x000fe400078e0275ULL,
0x0000001014147824ULL, 0x000fe400078e0223ULL, 0x0000000174157824ULL, 0x040fe200078e0211ULL,
0xfffffff813127812ULL, 0x000fe200078ee212ULL, 0x0000000874167824ULL, 0x040fe200078e00ffULL,
0x00000000142c783bULL, 0x000e620000000200ULL, 0x0000000174757824ULL, 0x000fc400078e0275ULL,
0x0000001012127824ULL, 0x000fe200078e0223ULL, 0xfffffff816167812ULL, 0x000fc800078ee215ULL,
0x000000001234783bULL, 0x020ea20000000200ULL, 0x0000001016167824ULL, 0x000fca00078e0223ULL,
0x000000001630783bULL, 0x0006e20000000200ULL, 0x0000002c00f67306ULL, 0x002fe20000009400ULL,
0x00000018ff177819ULL, 0x000fe4000001142cULL, 0x00000018ff187819ULL, 0x000fe4000001142dULL,
0x00000018ff197819ULL, 0x000fe4000001142eULL, 0x00000018ff1a7819ULL, 0x000fe2000001142fULL,
0x0000002c00e37306ULL, 0x000e620000005400ULL, 0x00000018ff217819ULL, 0x004fc40000011435ULL,
0x00000018ff227819ULL, 0x000fe40000011436ULL, 0x00000018ff1b7819ULL, 0x000fe40000011434ULL,
0x00000018ff767819ULL, 0x000fe20000011437ULL, 0x00000021008a7306ULL, 0x000ff00000209400ULL,
0x00000021008b7306ULL, 0x000fe20000205400ULL, 0x000000e3f600720bULL, 0x002fce0003f1d000ULL,
0x0000002100167306ULL, 0x0083f0000020d400ULL, 0x0000002c006c7306ULL, 0x0004e2000000d400ULL,
0x000100002c217824ULL, 0x002fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000001700927306ULL, 0x000fe20000209400ULL, 0x000001002c2c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002100917306ULL, 0x000fe20000209400ULL,
0x000000016c6c0812ULL, 0x008fce00078efcffULL, 0x0000002100f27306ULL, 0x000e700000205400ULL,
0x0000002100a17306ULL, 0x0004f0000020d400ULL, 0x0000001700937306ULL, 0x000ee20000205400ULL,
0x000100002e217824ULL, 0x004fe200078e00ffULL, 0x000000f29100720bULL, 0x002fc80003f3d000ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000017006d7306ULL, 0x000e6e000020d400ULL,
0x00000001a1a11812ULL, 0x008fe200078efcffULL, 0x0000001800c47306ULL, 0x000fe20000209400ULL,
0x000000939200720bULL, 0x000fc40003f7d000ULL, 0x0000006ca16c723eULL, 0x000fca00000010ffULL,
0x0000001800c57306ULL, 0x000eac0000205400ULL, 0x000000016d6d3812ULL, 0x002fe400078efcffULL,
0x00000018006f7306ULL, 0x000e70000020d400ULL, 0x0000001900c67306ULL, 0x000fe20000209400ULL,
0x000000c5c400720bULL, 0x004fce0003f3d000ULL, 0x0000001900cf7306ULL, 0x000eac0000205400ULL,
0x000000016f6f1812ULL, 0x002fe400078efcffULL, 0x0000001900b17306ULL, 0x000e70000020d400ULL,
0x0000002200177306ULL, 0x000fe20000209400ULL, 0x000000cfc600720bULL, 0x004fc40003f1d000ULL,
0x00000004ffc67819ULL, 0x000fca0000011605ULL, 0x0000002200187306ULL, 0x000fe20000205400ULL,
0x0000000211c67824ULL, 0x040fe200078e02c6ULL, 0x0000000211117810ULL, 0x000fc80007ffe0ffULL,
0x00000001b1b10812ULL, 0x002fe400078efcffULL, 0x0000002200197306ULL, 0x0003f0000020d400ULL,
0x0000002c00ce7306ULL, 0x000fe20000209400ULL, 0x000100002d227824ULL, 0x002fca00078e00ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000002c00f37306ULL, 0x000e700000205400ULL,
0x0000002c00a07306ULL, 0x0004f0000020d400ULL, 0x0000002d00e47306ULL, 0x000fe20000009400ULL,
0x00000018ff2c7819ULL, 0x004fc40000011431ULL, 0x000000f3ce00720bULL, 0x002fca0003f5d000ULL,
0x0000002d00f77306ULL, 0x000e700000005400ULL, 0x0000002d006e7306ULL, 0x000462000000d400ULL,
0x00000001a0a02812ULL, 0x008fc800078efcffULL, 0x000000a06d6d723eULL, 0x000fc600000010ffULL,
0x0000002e00c17306ULL, 0x000fe20000009400ULL, 0x000001002d2d7824ULL, 0x004fe200078e00ffULL,
0x000000f7e400720bULL, 0x002fc80003f9d000ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002e00f47306ULL, 0x000e6e0000005400ULL, 0x000000016e6e4812ULL, 0x000fe200078efcffULL,
0x0000002e00dc7306ULL, 0x0004f0000000d400ULL, 0x0000002100947306ULL, 0x000fe20000209400ULL,
0x000001002e2e7824ULL, 0x004fe200078e00ffULL, 0x000000f4c100720bULL, 0x002fc80003fdd000ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002100957306ULL, 0x000e6e0000205400ULL,
0x00000001dcdc6812ULL, 0x008fe200078efcffULL, 0x0000002100df7306ULL, 0x0004f0000020d400ULL,
0x0000002c00b77306ULL, 0x000fe20000209400ULL, 0x00000018ff217819ULL, 0x004fc40000011430ULL,
0x000000959400720bULL, 0x002fca0003f9d000ULL, 0x0000002c00d67306ULL, 0x000ff00000205400ULL,
0x0000002c00997306ULL, 0x0003e2000020d400ULL, 0x00000001dfdf4812ULL, 0x008fce00078efcffULL,
0x0000002200d37306ULL, 0x000fe20000209400ULL, 0x00000008742c7824ULL, 0x002fe400078e00ffULL,
0x0001000037747824ULL, 0x000fc600078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe400078ee275ULL,
0x0000002200f07306ULL, 0x000e660000205400ULL, 0x000000102c2c7824ULL, 0x000fca00078e0223ULL,
0x0000002200a37306ULL, 0x0004f0000020d400ULL, 0x0000002f00907306ULL, 0x000fe20000009400ULL,
0x000100002f227824ULL, 0x004fe200078e00ffULL, 0x000000f0d300720bULL, 0x002fc80003f5d000ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000002f00f57306ULL, 0x000e6e0000005400ULL,
0x00000001a3a32812ULL, 0x008fe200078efcffULL, 0x0000002f00d07306ULL, 0x0004e6000000d400ULL,
0x0000006ea36e723eULL, 0x000fca00000010ffULL, 0x0000002100e17306ULL, 0x000fe20000209400ULL,
0x000001002f2f7824ULL, 0x004fe200078e00ffULL, 0x000000f59000720bULL, 0x002fc80003fbd000ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x0000002100e27306ULL, 0x000e6e0000205400ULL,
0x00000001d0d05812ULL, 0x008fe200078efcffULL, 0x00000021009f7306ULL, 0x0004f0000020d400ULL,
0x0000002d00d47306ULL, 0x000fe20000209400ULL, 0x0001000034217824ULL, 0x004fe200078e00ffULL,
0x000000e2e100720bULL, 0x002fcc0003fbd000ULL, 0x0000002d00f17306ULL, 0x000e6e0000205400ULL,
0x000000019f9f5812ULL, 0x008fe200078efcffULL, 0x0000002d00e87306ULL, 0x0004f0000020d400ULL,
0x0000002e00967306ULL, 0x000fe20000209400ULL, 0x00000018ff2d7819ULL, 0x004fc40000011433ULL,
0x000000f1d400720bULL, 0x002fca0003f5d000ULL, 0x0000002e00ef7306ULL, 0x000e700000205400ULL,
0x0000002e00de7306ULL, 0x000462000020d400ULL, 0x00000001e8e82812ULL, 0x008fc800078efcffULL,
0x000000e86f6f723eULL, 0x000fc600000010ffULL, 0x0000002f00a27306ULL, 0x000fe20000209400ULL,
0x00000018ff2e7819ULL, 0x004fe40000011421ULL, 0x000000ef9600720bULL, 0x002fca0003f5d000ULL,
0x0000002f00eb7306ULL, 0x000e700000205400ULL, 0x0000002f00d57306ULL, 0x000ea2000020d400ULL,
0x00000001dede2812ULL, 0x000fce00078efcffULL, 0x0000002d00cc7306ULL, 0x000fe20000209400ULL,
0x000000eba200720bULL, 0x002fce0003f5d000ULL, 0x0000002d00cd7306ULL, 0x000fec0000205400ULL,
0x00000001d5d52812ULL, 0x004fe400078efcffULL, 0x0000002d009b7306ULL, 0x000ff0000020d400ULL,
0x0000002e00b97306ULL, 0x000ff00000209400ULL, 0x0000002e00ba7306ULL, 0x000ff00000205400ULL,
0x0000002e008d7306ULL, 0x0003f0000020d400ULL, 0x0000003400b67306ULL, 0x000fe20000009400ULL,
0x000000002c2c783bULL, 0x002e6e0000000200ULL, 0x0000003400b57306ULL, 0x000ff00000005400ULL,
0x00000034008c7306ULL, 0x0005f0000000d400ULL, 0x0000002200ed7306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x004fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000002200ee7306ULL, 0x000eb00000205400ULL, 0x0000003400b37306ULL, 0x000fe20000209400ULL,
0x000100002ca27824ULL, 0x002fca00078e00ffULL, 0x00000018ffeb7819ULL, 0x000fe400000114a2ULL,
0x0000003400b27306ULL, 0x000fe20000205400ULL, 0x000000eeed00720bULL, 0x004fce0003fdd000ULL,
0x0000003400217306ULL, 0x0003f0000020d400ULL, 0x0000002200d77306ULL, 0x0004e2000020d400ULL,
0x0001000036347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500ab7306ULL, 0x000fe20000009400ULL, 0x00000018ff227819ULL, 0x004fce0000011432ULL,
0x0000002200bd7306ULL, 0x000fe20000209400ULL, 0x00000001d7d76812ULL, 0x008fce00078efcffULL,
0x0000002200c07306ULL, 0x000ff00000205400ULL, 0x00000022009a7306ULL, 0x0003f0000020d400ULL,
0x0000003500a97306ULL, 0x000fe20000005400ULL, 0x0001000035227824ULL, 0x002fce00078e00ffULL,
0x0000003500127306ULL, 0x0003f0000000d400ULL, 0x00000034008e7306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000034008f7306ULL, 0x000ff00000205400ULL, 0x0000003400777306ULL, 0x0003f0000020d400ULL,
0x0000003000ec7306ULL, 0x000fe20000009400ULL, 0x00000018ff347819ULL, 0x002fce000001142cULL,
0x00000034007d7306ULL, 0x000ff00000209400ULL, 0x00000034007e7306ULL, 0x000ff00000205400ULL,
0x00000034007a7306ULL, 0x0003f0000020d400ULL, 0x0000003000977306ULL, 0x000ea20000005400ULL,
0x0001000030347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000030009e7306ULL, 0x0002f0000000d400ULL, 0x0000003500a77306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fe200078e00ffULL, 0x00000097ec00720bULL, 0x004fc80003f3d000ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003500a87306ULL, 0x000fee0000205400ULL,
0x000000019e9e1812ULL, 0x008fe200078efcffULL, 0x0000003500237306ULL, 0x0003e2000020d400ULL,
0x000000d6b700720bULL, 0x000fce0003f3d000ULL, 0x0000003000e57306ULL, 0x000fe20000209400ULL,
0x00000018ff357819ULL, 0x002fca0000011474ULL, 0x0000000199991812ULL, 0x000fe400078efcffULL,
0x0000003500797306ULL, 0x000ff00000209400ULL, 0x0000003500747306ULL, 0x000ff00000205400ULL,
0x0000003500887306ULL, 0x0003f0000020d400ULL, 0x0000003000e67306ULL, 0x000ea20000205400ULL,
0x00000018ff357819ULL, 0x002fce000001142eULL, 0x0000003000ca7306ULL, 0x0002f0000020d400ULL,
0x0000003500857306ULL, 0x000fe20000209400ULL, 0x0001000032307824ULL, 0x002fe200078e00ffULL,
0x000000e6e500720bULL, 0x004fc80003f5d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003500867306ULL, 0x000fee0000205400ULL, 0x00000001caca2812ULL, 0x008fe200078efcffULL,
0x0000003500817306ULL, 0x0003e6000020d400ULL, 0x000000ca9f9f723eULL, 0x000fca00000010ffULL,
0x00000031009d7306ULL, 0x000fe20000009400ULL, 0x0001000031357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000031009c7306ULL, 0x000e700000005400ULL,
0x0000003100987306ULL, 0x0004f0000000d400ULL, 0x0000001a00bf7306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x004fe200078e00ffULL, 0x0000009c9d00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000001a00c27306ULL, 0x000e6e0000205400ULL,
0x0000000198984812ULL, 0x008fe200078efcffULL, 0x0000003000db7306ULL, 0x000fe20000209400ULL,
0x000000cdcc00720bULL, 0x000fce0003f9d000ULL, 0x0000003000da7306ULL, 0x000ea20000205400ULL,
0x000000c2bf00720bULL, 0x002fca0003f7d000ULL, 0x000000019b9b4812ULL, 0x000fe400078efcffULL,
0x0000003000c77306ULL, 0x0002f0000020d400ULL, 0x0000003100d97306ULL, 0x000fe20000209400ULL,
0x0001000033307824ULL, 0x002fe200078e00ffULL, 0x000000dadb00720bULL, 0x004fcc0003fbd000ULL,
0x0000003100d87306ULL, 0x000e6e0000205400ULL, 0x00000001c7c75812ULL, 0x008fe200078efcffULL,
0x0000003100c87306ULL, 0x0004f0000020d400ULL, 0x0000003300e37306ULL, 0x000fe20000009400ULL,
0x00000018ff317819ULL, 0x004fc40000011430ULL, 0x0000000805307812ULL, 0x000fe400078ec0ffULL,
0x000000d8d900720bULL, 0x002fe40003f5d000ULL, 0x0000000730c57812ULL, 0x000fe200078ef805ULL,
0x0000003300e47306ULL, 0x000fe60000005400ULL, 0x00000010c5bf7812ULL, 0x040fe200078efcffULL,
0x00000001c5307824ULL, 0x000fc800078e02c6ULL, 0x0000003300c17306ULL, 0x0003e4000000d400ULL,
0x00000001c8c82812ULL, 0x008fc800078efcffULL, 0x000000c89999723eULL, 0x000fe400000010ffULL,
0x0000003400e77306ULL, 0x000fe20000209400ULL, 0x0000010033337824ULL, 0x002fca00078e00ffULL,
0x00000018fff07819ULL, 0x000fe20000011433ULL, 0x00000010c5337824ULL, 0x000fe200078e00ffULL,
0x0000003400ea7306ULL, 0x000e680000205400ULL, 0xfffffff033307812ULL, 0x000fc800078ee230ULL,
0x0000003400cb7306ULL, 0x0004f0000020d400ULL, 0x0000003600ad7306ULL, 0x000fe20000009400ULL,
0x0000010032347824ULL, 0x004fe200078e00ffULL, 0x000000eae700720bULL, 0x002fc80003fdd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003600ac7306ULL, 0x000e6e0000005400ULL,
0x00000001cbcb6812ULL, 0x008fe200078efcffULL, 0x0000003600137306ULL, 0x0004e6000000d400ULL,
0x0000009ecb9e723eULL, 0x000fca00000010ffULL, 0x0000003700aa7306ULL, 0x000fe20000009400ULL,
0x0000010036367824ULL, 0x004fe200078e00ffULL, 0x000000acad00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003700ae7306ULL, 0x000fee0000005400ULL,
0x0000000113134812ULL, 0x008fe200078efcffULL, 0x0000003700147306ULL, 0x0003f0000000d400ULL,
0x0000003200a67306ULL, 0x000fe20000009400ULL, 0x0000010037377824ULL, 0x002fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003200e97306ULL, 0x000e700000005400ULL,
0x0000003200b87306ULL, 0x0004f0000000d400ULL, 0x0000003100ce7306ULL, 0x000fe20000209400ULL,
0x00000010bf327824ULL, 0x004fe200078e00ffULL, 0x000000e9a600720bULL, 0x002fcc0003f1d000ULL,
0x0000003100cf7306ULL, 0x000e6e0000205400ULL, 0x00000001b8b80812ULL, 0x008fe200078efcffULL,
0x0000003100c47306ULL, 0x0004e2000020d400ULL, 0x000000bab900720bULL, 0x000fce0003f1d000ULL,
0x0000001a00b47306ULL, 0x000ee2000020d400ULL, 0x00000001bf317824ULL, 0x004fe200078e02c6ULL,
0x000000cfce00720bULL, 0x002fe40003f3d000ULL, 0x00000002c6c67810ULL, 0x000fe40007ffe0ffULL,
0xfffffff032317812ULL, 0x000fe400078ee231ULL, 0x0000001b00af7306ULL, 0x000fe20000209400ULL,
0x000000018d8d0812ULL, 0x000fe400078efcffULL, 0x0000001031317824ULL, 0x000fc800078e00ffULL,
0x00000001c4c41812ULL, 0x008fe200078efcffULL, 0x0000001b00b07306ULL, 0x000fe20000205400ULL,
0x00000001b4b43812ULL, 0x000fe400078efcffULL, 0x000000e4e300720bULL, 0x000fe40003f7d000ULL,
0x000000b5b600720bULL, 0x000fc60003f3d000ULL, 0x0000001b00157306ULL, 0x000ff0000020d400ULL,
0x00000076001a7306ULL, 0x000fe20000209400ULL, 0x00000001c1c13812ULL, 0x000fe400078efcffULL,
0x000000a9ab00720bULL, 0x000fc40003f7d000ULL, 0x000000018c8c1812ULL, 0x000fe400078efcffULL,
0x000000a8a700720bULL, 0x000fe20003f3d000ULL, 0x00000076001b7306ULL, 0x000e620000205400ULL,
0x0000008c8d8c723eULL, 0x000fce00000010ffULL, 0x00000076001f7306ULL, 0x0004e2000020d400ULL,
0x0000000112123812ULL, 0x000fc600078efcffULL, 0x0000000123231812ULL, 0x000fc800078efcffULL,
0x0000003600757306ULL, 0x000fe20000205400ULL, 0x00000018ff767819ULL, 0x004fe40000011422ULL,
0x0000001b1a00720bULL, 0x002fca0003f3d000ULL, 0x0000007600a47306ULL, 0x000ff00000209400ULL,
0x0000007600a57306ULL, 0x000e620000205400ULL, 0x000000011f1f1812ULL, 0x008fce00078efcffULL,
0x0000007600227306ULL, 0x000eb0000020d400ULL, 0x0000003600767306ULL, 0x000ee20000209400ULL,
0x000000a5a400720bULL, 0x002fce0003f1d000ULL, 0x0000003600787306ULL, 0x0002ec000020d400ULL,
0x0000000122220812ULL, 0x004fe400078efcffULL, 0x0000003700897306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fe4000001142dULL, 0x000000757600720bULL, 0x008fc40003f7d000ULL,
0x000000181700720bULL, 0x000fe40003f1d000ULL, 0x000000122222723eULL, 0x000fe200000010ffULL,
0x00000037007f7306ULL, 0x000e700000205400ULL, 0x00000037007c7306ULL, 0x0004e2000020d400ULL,
0x0000000178783812ULL, 0x000fc400078efcffULL, 0x0000000119190812ULL, 0x000fc800078efcffULL,
0x000000781919723eULL, 0x000fe200000010ffULL, 0x0000003400d17306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x004fe4000001142fULL, 0x0000007f8900720bULL, 0x002fca0003f7d000ULL,
0x0000003400d27306ULL, 0x000e700000205400ULL, 0x0000003400c37306ULL, 0x000462000020d400ULL,
0x000000017c7c3812ULL, 0x008fce00078efcffULL, 0x00000036007b7306ULL, 0x000fe20000209400ULL,
0x0000001030347824ULL, 0x004fe200078e00ffULL, 0x000000d2d100720bULL, 0x002fe20003f5d000ULL,
0x000000003130783bULL, 0x000e6a0000000200ULL, 0x0000003600877306ULL, 0x000fee0000205400ULL,
0x00000001c3c32812ULL, 0x000fe200078efcffULL, 0x0000003600827306ULL, 0x000fe2000020d400ULL,
0x000000b2b300720bULL, 0x000fce0003f5d000ULL, 0x0000003700837306ULL, 0x000fec0000209400ULL,
0x0000000121212812ULL, 0x000fe400078efcffULL, 0x0000003700847306ULL, 0x000fe20000205400ULL,
0x0000008b8a00720bULL, 0x000fce0003f5d000ULL, 0x0000003700807306ULL, 0x000fe2000020d400ULL,
0x0000006e305c723cULL, 0x042fea000004185cULL, 0x0000000116162812ULL, 0x000fe400078efcffULL,
0x0000003500dd7306ULL, 0x000fe40000209400ULL, 0x000000231623723eULL, 0x000fe200000010ffULL,
0x0000006c3064723cULL, 0x040fea0000041864ULL, 0x0000003500e07306ULL, 0x000e660000205400ULL,
0x0000009e303c723cULL, 0x000fea000004183cULL, 0x0000003500c97306ULL, 0x0004f0000020d400ULL,
0x000000f000d37306ULL, 0x000fe20000209400ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x000000e0dd00720bULL, 0x002fcc0003fdd000ULL, 0x000000f000d47306ULL, 0x000e6e0000205400ULL,
0x00000001c9c96812ULL, 0x008fe200078efcffULL, 0x000000f000c27306ULL, 0x000ee2000020d400ULL,
0x000000c0bd00720bULL, 0x000fe40003fdd000ULL, 0x00000098c998723eULL, 0x000fc400000010ffULL,
0x000000d4d300720bULL, 0x002fc60003fbd000ULL, 0x0000002c00907306ULL, 0x000fe40000009400ULL,
0x000000983038723cULL, 0x000fe80000041838ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x000000b0af00720bULL, 0x000fe20003fdd000ULL, 0x0000002c00917306ULL, 0x000e620000005400ULL,
0x00000001c2c25812ULL, 0x008fc400078efcffULL, 0x000000aeaa00720bULL, 0x000fe20003fbd000ULL,
0x0000006e3460723cULL, 0x004be80000041860ULL, 0x0000002c00927306ULL, 0x0004e2000000d400ULL,
0x000000c29b9b723eULL, 0x000fc600000010ffULL, 0x0000000115156812ULL, 0x000fe400078efcffULL,
0x0000008f8e00720bULL, 0x000fe40003fdd000ULL, 0x000000d0d76e723eULL, 0x020fe200000010ffULL,
0x0000006c3468723cULL, 0x000be20000041868ULL, 0x000000d5b46f723eULL, 0x000fe200000010ffULL,
0x000001002c2c7824ULL, 0x004fe200078e00ffULL, 0x0000002d00937306ULL, 0x000fe20000009400ULL,
0x0000000114145812ULL, 0x000fe400078efcffULL, 0x000000919000720bULL, 0x002fc40003f5d000ULL,
0x000000dcdf6c723eULL, 0x020fe200000010ffULL, 0x0000006e3450723cULL, 0x080fe20000041850ULL,
0x000000deb16d723eULL, 0x000fe200000010ffULL, 0x0000002d00947306ULL, 0x000e620000005400ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000000177776812ULL, 0x000fe400078efcffULL,
0x000000747900720bULL, 0x000fe20003fdd000ULL, 0x0000006e304c723cULL, 0x000be2000004184cULL,
0x0000007e7d00720bULL, 0x000fe20003fbd000ULL, 0x0000002d00957306ULL, 0x0005e2000000d400ULL,
0x000000137718723eULL, 0x000fc400000010ffULL, 0x00000021158d723eULL, 0x000fe400000010ffULL,
0x00000010c56e7824ULL, 0x060fe200078e00ffULL, 0x0000006c3458723cULL, 0x080fe20000041858ULL,
0x00000001c5c57824ULL, 0x100fe200078e02c6ULL, 0x0000002c00b17306ULL, 0x000fe20000209400ULL,
0x00000001bfc67824ULL, 0x040fe200078e02c6ULL, 0x0000000188886812ULL, 0x000fe200078efcffULL,
0x00000010bfbf7824ULL, 0x000fe200078e00ffULL, 0xfffffff06ec57812ULL, 0x000fe400078ee2c5ULL,
0x0000006c3054723cULL, 0x000b620000041854ULL, 0x0000000192922812ULL, 0x008fe200078efcffULL,
0x0000002c00b77306ULL, 0x000ee20000205400ULL, 0xfffffff0bfc67812ULL, 0x000fc400078ee2c6ULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x000100002d6c7824ULL, 0x060fe200078e00ffULL,
0x0000009e3448723cULL, 0x040f620000041848ULL, 0x000001002d6d7824ULL, 0x000fe200078e00ffULL,
0x0000002c00b47306ULL, 0x0006e2000020d400ULL, 0x000000c39a2d723eULL, 0x004fe400000010ffULL,
0x000000c1c49a723eULL, 0x000fe400000010ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x000000983444723cULL, 0x000b620000041844ULL, 0x000000949300720bULL, 0x002fe20003f9d000ULL,
0x000000eb00a27306ULL, 0x000fe20000209400ULL, 0x000000b8c72c723eULL, 0x008fc400000010ffULL,
0x00000018ffc77819ULL, 0x000fe4000001146dULL, 0x000000b7b100720bULL, 0x000fe20003f7d000ULL,
0x0000009a3470723cULL, 0x040fe20000041870ULL, 0x000100002f987824ULL, 0x020fe200078e00ffULL,
0x0000006c00bd7306ULL, 0x000fe20000209400ULL, 0x000000148814723eULL, 0x000fe400000010ffULL,
0x0000007c1f15723eULL, 0x000fe400000010ffULL, 0x00000018ff987819ULL, 0x000fe20000011498ULL,
0x0000002c3440723cULL, 0x000b620000041840ULL, 0x0000000195954812ULL, 0x000fe200078efcffULL,
0x0000006c00c07306ULL, 0x000e620000205400ULL, 0x000000848300720bULL, 0x000fc40003f9d000ULL,
0x00000001b4b43812ULL, 0x000fe400078efcffULL, 0x000100002e357824ULL, 0x020fe200078e00ffULL,
0x0000002c3024723cULL, 0x040b620000041824ULL, 0x00000010c6347824ULL, 0x000fe200078e00ffULL,
0x0000006c00b87306ULL, 0x0004e2000020d400ULL, 0x000000877b00720bULL, 0x000fe40003f7d000ULL,
0x00000018ffb57819ULL, 0x000fe40000011435ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000009a3028723cULL, 0x000f620000041828ULL, 0x0000000180804812ULL, 0x000fe200078efcffULL,
0x000000eb00a37306ULL, 0x000ee20000205400ULL, 0x00000010c56c7824ULL, 0x004fe200078e00ffULL,
0x000000c0bd00720bULL, 0x002fc40003f3d000ULL, 0x000000b47a93723eULL, 0x000fe400000010ffULL,
0x0000000182823812ULL, 0x000fe200078efcffULL, 0x000000006c6c783bULL, 0x000e620000000200ULL,
0x000000c700c37306ULL, 0x000fee0000209400ULL, 0x00000001b8b81812ULL, 0x008fe200078efcffULL,
0x000000c700c27306ULL, 0x000ea20000205400ULL, 0x000000a3a200720bULL, 0x000fc40003fdd000ULL,
0x000000868500720bULL, 0x000fe40003f3d000ULL, 0x00000095b8b8723eULL, 0x000fc600000010ffULL,
0x000000b5009e7306ULL, 0x000ff00000209400ULL, 0x000000b500997306ULL, 0x000ee20000205400ULL,
0x000000c2c300720bULL, 0x004fe40003f5d000ULL, 0x0000000181811812ULL, 0x000fe200078efcffULL,
0x000000183454723cULL, 0x040f680000041854ULL, 0x0000002e00967306ULL, 0x000fe80000009400ULL,
0x0000008c3464723cULL, 0x000f680000041864ULL, 0x0000002e00977306ULL, 0x000ea20000005400ULL,
0x000000999e00720bULL, 0x008fc60003fbd000ULL, 0x000000186c58723cULL, 0x042b680000041858ULL,
0x0000002e009c7306ULL, 0x0002e8000000d400ULL, 0x0000008c6c68723cULL, 0x000b680000041868ULL,
0x0000002f009d7306ULL, 0x000fe20000009400ULL, 0x000001002e2e7824ULL, 0x002fe200078e00ffULL,
0x000000979600720bULL, 0x004fc40003f1d000ULL, 0x000000226c60723cULL, 0x080b640000041860ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002f00a07306ULL, 0x000fe80000005400ULL,
0x00000022345c723cULL, 0x000b66000004185cULL, 0x000000019c9c0812ULL, 0x008fe200078efcffULL,
0x0000002f00a17306ULL, 0x0003e2000000d400ULL, 0x000000081100780cULL, 0x000fc60003f05270ULL,
0x000000146c50723cULL, 0x000b680000041850ULL, 0x000000eb00a67306ULL, 0x000ea2000020d400ULL,
0x000001002f2f7824ULL, 0x002fc600078e00ffULL, 0x00000014344c723cULL, 0x000b64000004184cULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x000000c700bf7306ULL, 0x000e70000020d400ULL,
0x000000b5002d7306ULL, 0x020ee2000020d400ULL, 0x00000001a6a66812ULL, 0x004fc400078efcffULL,
0x000000a09d00720bULL, 0x000fe40003fdd000ULL, 0x00000092a692723eULL, 0x000fc600000010ffULL,
0x0000002e00217306ULL, 0x000fe20000209400ULL, 0x00000001bfbf2812ULL, 0x002fc600078efcffULL,
0x000000926c48723cULL, 0x000b620000041848ULL, 0x000000bf82b9723eULL, 0x000fc600000010ffULL,
0x0000002e001a7306ULL, 0x000e620000205400ULL, 0x000000012d2d5812ULL, 0x008fe400078efcffULL,
0x00000001a1a16812ULL, 0x000fe200078efcffULL, 0x000000b86c44723cULL, 0x000b620000041844ULL,
0x0000009c2d9c723eULL, 0x000fc600000010ffULL, 0x0000009800167306ULL, 0x000fe80000209400ULL,
0x00000092343c723cULL, 0x000b68000004183cULL, 0x0000009800137306ULL, 0x000ea20000205400ULL,
0x0000001a2100720bULL, 0x002fc60003f5d000ULL, 0x000000b83438723cULL, 0x000b680000041838ULL,
0x0000002f00177306ULL, 0x000ff00000209400ULL, 0x0000002f00187306ULL, 0x000e620000205400ULL,
0x000000131600720bULL, 0x004fce0003f7d000ULL, 0x0000002e00127306ULL, 0x000eb0000020d400ULL,
0x0000009800987306ULL, 0x000ee2000020d400ULL, 0x000000181700720bULL, 0x002fce0003fbd000ULL,
0x0000002f00997306ULL, 0x000e62000020d400ULL, 0x0000000112122812ULL, 0x004fc800078efcffULL,
0x00000012819d723eULL, 0x000fe400000010ffULL, 0x0000000198983812ULL, 0x008fc800078efcffULL,
0x000000a19898723eULL, 0x000fe200000010ffULL, 0x0000009c6c40723cULL, 0x000b620000041840ULL,
0x0000000199995812ULL, 0x002fc800078efcffULL, 0x000000998099723eULL, 0x000fc600000010ffULL,
0x0000009c3424723cULL, 0x000b700000041824ULL, 0x000000986c70723cULL, 0x080b700000041870ULL,
0x000000983428723cULL, 0x000b620000041828ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffdf5000007947ULL, 0x000fcc000383ffffULL, 0x0000000759597220ULL, 0x080fe40000410000ULL,
0x0000000760607220ULL, 0x000fc40000410000ULL, 0x0000000761617220ULL, 0x080fe40000410000ULL,
0x0000000758587220ULL, 0x080fe40000410000ULL, 0x0000000750507220ULL, 0x080fe40000410000ULL,
0x0000000744447220ULL, 0x0a0fe40000410000ULL, 0x0000000751517220ULL, 0x080fe40000410000ULL,
0x0000000748487220ULL, 0x000fc40000410000ULL, 0x0000000749497220ULL, 0x080fe40000410000ULL,
0x000000074b4b7220ULL, 0x080fe40000410000ULL, 0x0000000745457220ULL, 0x080fe40000410000ULL,
0x0000000741417220ULL, 0x080fe40000410000ULL, 0x0000000742427220ULL, 0x080fe40000410000ULL,
0x0000000743437220ULL, 0x000fc40000410000ULL, 0x000000073c3c7220ULL, 0x080fe40000410000ULL,
0x000000073d3d7220ULL, 0x080fe40000410000ULL, 0x0000000768687220ULL, 0x080fe40000410000ULL,
0x0000000769697220ULL, 0x080fe40000410000ULL, 0x000000076a6a7220ULL, 0x080fe40000410000ULL,
0x000000076b6b7220ULL, 0x000fc40000410000ULL, 0x0000000762627220ULL, 0x080fe40000410000ULL,
0x0000000763637220ULL, 0x080fe40000410000ULL, 0x000000075a0a7220ULL, 0x080fe40000410000ULL,
0x000000075b117220ULL, 0x080fe40000410000ULL, 0x0000000752127220ULL, 0x080fe40000410000ULL,
0x0000000753137220ULL, 0x000fc40000410000ULL, 0x000000074a147220ULL, 0x080fe40000410000ULL,
0x0000000746157220ULL, 0x080fe40000410000ULL, 0x0000000747167220ULL, 0x080fe40000410000ULL,
0x0000000740407220ULL, 0x080fe40000410000ULL, 0x0000000772727220ULL, 0x080fe40000410000ULL,
0x0000000773737220ULL, 0x000fc40000410000ULL, 0x000000074c177220ULL, 0x080fe40000410000ULL,
0x000000074d187220ULL, 0x080fe40000410000ULL, 0x0000000738197220ULL, 0x080fe40000410000ULL,
0x00000007391a7220ULL, 0x080fe40000410000ULL, 0x0000000724247220ULL, 0x080fe40000410000ULL,
0x0000000764337220ULL, 0x000fc40000410000ULL, 0x000000075c347220ULL, 0x080fe40000410000ULL,
0x000000075d357220ULL, 0x080fe40000410000ULL, 0x00000007572c7220ULL, 0x080fe40000410000ULL,
0x000000073e217220ULL, 0x080fe40000410000ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0059ULL,
0x0000000754367220ULL, 0x000fc40000410000ULL, 0x00000007562d7220ULL, 0x080fe40000410000ULL,
0x000000073a237220ULL, 0x080fe40000410000ULL, 0x000000073b647220ULL, 0x080fe40000410000ULL,
0x00000007253e7220ULL, 0x000fe40000410000ULL, 0x000000ffff5d7224ULL, 0x000fe400078e0060ULL,
0x000000ffff5c7224ULL, 0x000fc400078e0061ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0058ULL,
0x000000ffff597224ULL, 0x000fe400078e0050ULL, 0x000000ffff577224ULL, 0x000fe400078e0044ULL,
0x0000000765327220ULL, 0x080fe40000410000ULL, 0x000000075e2f7220ULL, 0x080fe40000410000ULL,
0x000000075f307220ULL, 0x000fc40000410000ULL, 0x0000000755377220ULL, 0x080fe40000410000ULL,
0x000000074e1b7220ULL, 0x080fe40000410000ULL, 0x000000074f1f7220ULL, 0x080fe40000410000ULL,
0x000000073f227220ULL, 0x080fe40000410000ULL, 0x0000000727257220ULL, 0x000fe40000410000ULL,
0x000000ffff607224ULL, 0x000fc400078e0051ULL, 0x000000ffff617224ULL, 0x000fe400078e0048ULL,
0x000000ffff587224ULL, 0x000fe400078e0049ULL, 0x000000ffff567224ULL, 0x000fe400078e0045ULL,
0x000000ffff547224ULL, 0x000fe400078e0041ULL, 0x000000ffff507224ULL, 0x000fe400078e004bULL,
0x000000ffff4c7224ULL, 0x000fc400078e0042ULL, 0x000000ffff447224ULL, 0x000fe400078e0043ULL,
0x000000ffff3a7224ULL, 0x000fe400078e003cULL, 0x000000ffff3b7224ULL, 0x000fe400078e003dULL,
0x0000000770537220ULL, 0x080fe40000410000ULL, 0x0000000771527220ULL, 0x080fe40000410000ULL,
0x00000007662e7220ULL, 0x000fc40000410000ULL, 0x0000000767317220ULL, 0x080fe40000410000ULL,
0x0000000726267220ULL, 0x080fe40000410000ULL, 0x00000007283f7220ULL, 0x080fe40000410000ULL,
0x0000000729297220ULL, 0x080fe40000410000ULL, 0x000000072a277220ULL, 0x080fe40000410000ULL,
0x000000072b657220ULL, 0x000fc40000410000ULL, 0x000000ffff5f7224ULL, 0x000fe400078e0068ULL,
0x000000ffff5e7224ULL, 0x000fe400078e0069ULL, 0x000000ffff557224ULL, 0x000fe400078e0040ULL,
0x000000ffff4e7224ULL, 0x000fe400078e006aULL, 0x000000ffff4d7224ULL, 0x000fe400078e006bULL,
0x000000ffff457224ULL, 0x000fc400078e0062ULL, 0x000000ffff477224ULL, 0x000fe400078e0063ULL,
0x000000ffff467224ULL, 0x000fe400078e000aULL, 0x000000ffff517224ULL, 0x000fe400078e0011ULL,
0x000000ffff487224ULL, 0x000fe400078e0012ULL, 0x000000ffff4a7224ULL, 0x000fe400078e0013ULL,
0x000000ffff497224ULL, 0x000fc400078e0014ULL, 0x000000ffff4b7224ULL, 0x000fe400078e0015ULL,
0x000000ffff4f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff437224ULL, 0x000fe400078e0072ULL,
0x000000ffff417224ULL, 0x000fe400078e0073ULL, 0x000000ffff387224ULL, 0x000fe400078e0017ULL,
0x000000ffff397224ULL, 0x000fc400078e0018ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0019ULL,
0x000000ffff3d7224ULL, 0x000fe400078e001aULL, 0x000000ffff427224ULL, 0x000fe200078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000008167f8cULL, 0x0002a2000c80043fULL,
0x000000ffff407224ULL, 0x000fe400078e0029ULL, 0x000000ffff247224ULL, 0x000fe400078e0026ULL,
0x000000ffff297224ULL, 0x000fc400078e001fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff267224ULL, 0x000fe400078e0027ULL, 0x000000ffff2b7224ULL, 0x000fe400078e001bULL,
0x000000ffff287224ULL, 0x000fe400078e0022ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0023ULL,
0x000000ffff217224ULL, 0x000fc400078e0064ULL, 0x000000ffff277224ULL, 0x000fc400078e0065ULL,
0x0000000000127805ULL, 0x002fca0000015200ULL, 0x0000040008117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x006fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412117210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e13ULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc80000011414ULL, 0x000000110a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0614ULL, 0x000000020a0a7819ULL, 0x000fc80000001211ULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040008117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000405117824ULL, 0x000fe200078e00ffULL,
0x0000000d0900720cULL, 0x000fc80003f06070ULL, 0xfffffff011137812ULL, 0x000fca00078ec0ffULL,
0x00000080200a7824ULL, 0x000fca00078e0213ULL, 0x01a400000a147984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x0000000205627824ULL, 0x000fe200078e00ffULL,
0xffffff000f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000002ff797424ULL, 0x000fe200078e00ffULL,
0x0000000005137211ULL, 0x000fe400078ff0ffULL, 0x0000000f1e127217ULL, 0x000fe40007800000ULL,
0x0000000662627812ULL, 0x000fe400078ec0ffULL, 0x0000000813197810ULL, 0x000fe20007ffe0ffULL,
0x00000001120f7824ULL, 0x000fe200078e0a0fULL, 0x00005a00ff127a19ULL, 0x000fe20000011613ULL,
0x000000010c187824ULL, 0x000fe200078e0262ULL, 0x0000580062647a10ULL, 0x000fc40007ffe0ffULL,
0x00000010131b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000f1800720cULL, 0x040fe20003f26070ULL,
0x0000000118187824ULL, 0x100fe200078e0a0fULL, 0x0000001813227810ULL, 0x000fe40007ffe0ffULL,
0x000000120b137217ULL, 0x040fe20003800000ULL, 0x0000000164127824ULL, 0x000fe200078e0a0fULL,
0x000000180b187217ULL, 0x000fe40003800000ULL, 0x00005a00ff1a7a19ULL, 0x000fe20000011619ULL,
0x000000130e887224ULL, 0x000fe200078e02ffULL, 0x00000004ff187819ULL, 0x000fc40000011618ULL,
0x0000000f6400720cULL, 0x000fe40003f06070ULL, 0x000000120b127217ULL, 0x040fe40003800000ULL,
0x0000001a0b197217ULL, 0x000fe40003800000ULL, 0x00005a00ff1a7a19ULL, 0x000fe4000001161bULL,
0x00005a00ff227a19ULL, 0x000fe20000011622ULL, 0x000000190e8e7224ULL, 0x000fe200078e02ffULL,
0x000000ff181b7207ULL, 0x000fc40000800000ULL, 0x000000ff12777207ULL, 0x000fe40000000000ULL,
0x000000220b637217ULL, 0x000fe20003800000ULL, 0x0000000188667824ULL, 0x000fe200078e021bULL,
0x0000008877127211ULL, 0x000fe400078fe0ffULL, 0x0000001a0b237217ULL, 0x000fe20003800000ULL,
0x000000630e927224ULL, 0x000fe200078e02ffULL, 0x0000001062747812ULL, 0x000fe200078efcffULL,
0x0000600066667625ULL, 0x000fe200078e0079ULL, 0x0000008e77187211ULL, 0x000fc600078fe0ffULL,
0x0000600012127625ULL, 0x000fe400078e0079ULL, 0x0000000866667981ULL, 0x0046a4000c1e9500ULL,
0x000000011b687824ULL, 0x040fe400078e0292ULL, 0x000000230e907224ULL, 0x000fe200078e02ffULL,
0x0000000812637981ULL, 0x0002a2000c1e9500ULL, 0x000000011b6e7824ULL, 0x040fe400078e028eULL,
0x000000011b707824ULL, 0x000fe200078e0290ULL, 0x00000090771a7211ULL, 0x000fe200078fe0ffULL,
0x0000600018187625ULL, 0x000fc800078e0079ULL, 0x0000600068127625ULL, 0x082fe200078e0079ULL,
0x0000009277227211ULL, 0x000fe200078fe0ffULL, 0x0000000818657981ULL, 0x0002a4000c1e9500ULL,
0x000000010c687824ULL, 0x000fe400078e0274ULL, 0x000060006e6e7625ULL, 0x000fe200078e0079ULL,
0x0000580074727a10ULL, 0x000fe20007ffe0ffULL, 0x00000008126d7981ULL, 0x0002a4000c1e9500ULL,
0x00000001686a7824ULL, 0x000fc400078e0a0fULL, 0x0000600070707625ULL, 0x080fe200078e0079ULL,
0x000000086e6e7981ULL, 0x0002a6000c1e9500ULL, 0x000060001a1a7625ULL, 0x080fe200078e0079ULL,
0x0000006a0b6a7217ULL, 0x000fe20003800000ULL, 0x0000000870707981ULL, 0x0002a4000c1e9500ULL,
0x0000600022227625ULL, 0x000fe400078e0079ULL, 0x000000081a677981ULL, 0x0086a2000c1e9500ULL,
0x0000000f6800720cULL, 0x080fe20003f26070ULL, 0x0000000172187824ULL, 0x042fe200078e0a0fULL,
0x00000004ff6a7819ULL, 0x000fe2000001166aULL, 0x00000008226c7981ULL, 0x0002a2000c1e9500ULL,
0x0000000f7200720cULL, 0x000fc40003f06070ULL, 0x000000180b187217ULL, 0x000fe40003800000ULL,
0x000000ff6a237207ULL, 0x002fe40000800000ULL, 0x000000ff187f7207ULL, 0x000fc60000000000ULL,
0x0000000188187824ULL, 0x000fe200078e0223ULL, 0x0000008e7f1a7211ULL, 0x008fe200078fe0ffULL,
0x0000000123227824ULL, 0x000fe200078e028eULL, 0x000000887f127211ULL, 0x000fe200078fe0ffULL,
0x0000600018187625ULL, 0x000fe200078e0079ULL, 0x00000020627c7812ULL, 0x000fc600078efcffULL,
0x000060001a1a7625ULL, 0x080fe200078e0079ULL, 0x0000000818767981ULL, 0x0002e6000c1e9500ULL,
0x00000001237a7824ULL, 0x040fe200078e0290ULL, 0x000000081a717981ULL, 0x0002e2000c1e9500ULL,
0x0000000123807824ULL, 0x000fe400078e0292ULL, 0x0000600012127625ULL, 0x000fe200078e0079ULL,
0x000058007c7e7a10ULL, 0x000fc60007ffe0ffULL, 0x0000600022227625ULL, 0x080fe200078e0079ULL,
0x00000008126f7981ULL, 0x0002e6000c1e9500ULL, 0x000000010c187824ULL, 0x002fe200078e027cULL,
0x0000000822787981ULL, 0x0002e6000c1e9500ULL, 0x00000001181a7824ULL, 0x100fe200078e0a0fULL,
0x000000907f687211ULL, 0x040fe400078fe0ffULL, 0x000000927f6a7211ULL, 0x000fe200078fe0ffULL,
0x000000017e127824ULL, 0x000fe200078e0a0fULL, 0x0000001a0b1a7217ULL, 0x000fe20003800000ULL,
0x000060007a7a7625ULL, 0x000fe200078e0079ULL, 0x0000000f7e00720cULL, 0x000fc40003f06070ULL,
0x000000120b127217ULL, 0x000fe20003800000ULL, 0x0000600080807625ULL, 0x000fe200078e0079ULL,
0x0000000f1800720cULL, 0x000fe20003f26070ULL, 0x000000087a7a7981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff1a7819ULL, 0x000fe2000001161aULL, 0x0000600068687625ULL, 0x000fc800078e0079ULL,
0x000060006a6a7625ULL, 0x000fe200078e0079ULL, 0x000000ff12857207ULL, 0x000fe20000000000ULL,
0x0000000868737981ULL, 0x0002e2000c1e9500ULL, 0x000000ff1a137207ULL, 0x000fc60000800000ULL,
0x000000086a757981ULL, 0x0002e2000c1e9500ULL, 0x0000008e851a7211ULL, 0x000fc600078fe0ffULL,
0x0000000880807981ULL, 0x0002e2000c1e9500ULL, 0x0000008885187211ULL, 0x000fe200078fe0ffULL,
0x0000000113127824ULL, 0x040fe400078e028eULL, 0x0000000113847824ULL, 0x040fe400078e0290ULL,
0x00000001886a7824ULL, 0x002fe400078e0213ULL, 0x0000000113867824ULL, 0x000fe400078e0292ULL,
0x000060001a1a7625ULL, 0x000fc800078e0079ULL, 0x0000600012127625ULL, 0x080fe200078e0079ULL,
0x000000081a7d7981ULL, 0x0002e6000c1e9500ULL, 0x0000600018187625ULL, 0x000fe200078e0079ULL,
0x0000000812d27981ULL, 0x0002e2000c1e9500ULL, 0x0000009085687211ULL, 0x000fc600078fe0ffULL,
0x00000008187b7981ULL, 0x0002e2000c1e9500ULL, 0x0000009285227211ULL, 0x000fe200078fe0ffULL,
0x000060006a6a7625ULL, 0x000fc800078e0079ULL, 0x0000600084187625ULL, 0x082fe200078e0079ULL,
0x0000003062847812ULL, 0x000fe200078efcffULL, 0x000000086a827981ULL, 0x0002e4000c1e9500ULL,
0x0000600068687625ULL, 0x080fe400078e0079ULL, 0x0000000818d67981ULL, 0x0002e4000c1e9500ULL,
0x0000600022227625ULL, 0x080fe400078e0079ULL, 0x0000000868817981ULL, 0x0002e4000c1e9500ULL,
0x00006000861a7625ULL, 0x000fe200078e0079ULL, 0x0000580084867a10ULL, 0x000fe20007ffe0ffULL,
0x0000000822837981ULL, 0x0002e4000c1e9500ULL, 0x000000010c8a7824ULL, 0x000fc400078e0284ULL,
0x000000081ada7981ULL, 0x0002e4000c1e9500ULL, 0x000000018a8c7824ULL, 0x100fe400078e0a0fULL,
0x00000001866a7824ULL, 0x002fc600078e0a0fULL, 0x0000008c0b8c7217ULL, 0x040fe40003800000ULL,
0x0000000f8a00720cULL, 0x080fe40003f26070ULL, 0x0000000f8600720cULL, 0x000fe40003f06070ULL,
0x0000006a0b6a7217ULL, 0x000fe40003800000ULL, 0x00000004ff8c7819ULL, 0x000fe4000001168cULL,
0x000000ff6a877207ULL, 0x000fc40000000000ULL, 0x000000ff8c897207ULL, 0x000fe40000800000ULL,
0x0000008887687211ULL, 0x040fe400078fe0ffULL, 0x0000009087187211ULL, 0x000fe200078fe0ffULL,
0x00000001886a7824ULL, 0x000fe400078e0289ULL, 0x0000000189227824ULL, 0x000fe400078e0290ULL,
0x0000600068687625ULL, 0x000fc800078e0079ULL, 0x000060006a6a7625ULL, 0x080fe200078e0079ULL,
0x0000000868b87981ULL, 0x0002e6000c1e9500ULL, 0x0000600018187625ULL, 0x080fe200078e0079ULL,
0x000000086a8b7981ULL, 0x0002e6000c1e9500ULL, 0x0000600022227625ULL, 0x000fe200078e0079ULL,
0x0000000818d87981ULL, 0x0002e2000c1e9500ULL, 0x0000008e87127211ULL, 0x000fc600078fe0ffULL,
0x00000008228f7981ULL, 0x0002e2000c1e9500ULL, 0x00000001891a7824ULL, 0x000fe400078e028eULL,
0x0000600012127625ULL, 0x000fc800078e0079ULL, 0x000060001a1a7625ULL, 0x080fe200078e0079ULL,
0x0000000812d47981ULL, 0x0002e4000c1e9500ULL, 0x0000009287687211ULL, 0x002fe400078fe0ffULL,
0x000000081a8d7981ULL, 0x0002e2000c1e9500ULL, 0x00000001896a7824ULL, 0x000fe400078e0292ULL,
0x0000600068687625ULL, 0x000fc800078e0079ULL, 0x000060006a6a7625ULL, 0x000fe200078e0079ULL,
0x0000000868dc7981ULL, 0x0002e8000c1e9500ULL, 0x000000086a917981ULL, 0x0002e2000c1e9500ULL,
0xfffffff077127812ULL, 0x000fe200078ec0ffULL, 0x00000001ffd07424ULL, 0x000fc800078e00ffULL,
0x000000010f137824ULL, 0x000fc800078e0212ULL, 0x0000000164127824ULL, 0x000fe200078e0a13ULL,
0x0000000162887812ULL, 0x000fc800078efcffULL, 0x00000012d0127219ULL, 0x000fe400000006ffULL,
0x0000580088187a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff07f1a7812ULL, 0x002fc600078ec0ffULL,
0x0000000118197824ULL, 0x100fe200078e0a13ULL, 0x00000008628a7812ULL, 0x040fe200078efcffULL,
0x000000010f237824ULL, 0x000fe200078e021aULL, 0x00000009628c7812ULL, 0x000fe400078efcffULL,
0x00000019d01a7219ULL, 0x000fe400000006ffULL, 0x000058008a227a10ULL, 0x000fe40007ffe0ffULL,
0x000058008c6a7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff085687812ULL, 0x000fe200078ec0ffULL,
0x00000001221b7824ULL, 0x100fe200078e0a13ULL, 0xfffffff0878e7812ULL, 0x000fe200078ec0ffULL,
0x000000016a137824ULL, 0x000fe200078e0a13ULL, 0x0000001162927812ULL, 0x000fe200078efcffULL,
0x000000010f697824ULL, 0x040fe200078e0268ULL, 0x0000001bd0687219ULL, 0x040fe200000006ffULL,
0x000000010f7f7824ULL, 0x000fe200078e028eULL, 0x00000013d08e7219ULL, 0x000fc400000006ffULL,
0x0000580092947a10ULL, 0x000fe40007ffe0ffULL, 0x0000541063637816ULL, 0x004fc80000000066ULL,
0x0000006312ff7212ULL, 0x000fc800078ac0ffULL, 0x0000000f6400720cULL, 0x000fc80002fa1470ULL,
0x0000000f6200720cULL, 0x000fe40002fa1070ULL, 0x000000631aff7212ULL, 0x000fe4000782c0ffULL,
0xff8000005f5f7808ULL, 0x000fe40002800000ULL, 0x0000541065657816ULL, 0x000fc8000000006eULL,
0x0000006512ff7212ULL, 0x080fe4000784c0ffULL, 0x0000541067677816ULL, 0x000fe40000000070ULL,
0x000000651aff7212ULL, 0x000fe400078ac0ffULL, 0x0000006712ff7212ULL, 0x000fe4000788c0ffULL,
0x0000000f6400720cULL, 0x0c0fe40001741470ULL, 0x0000000f6400720cULL, 0x000fc40002781470ULL,
0x0000000f1800720cULL, 0x0c0fe40000f21470ULL, 0x0000000f1800720cULL, 0x080fe40002fa1470ULL,
0x0000000f6200720cULL, 0x0c0fe40001741070ULL, 0x0000000f6200720cULL, 0x080fe40002781070ULL,
0x0000000f8800720cULL, 0x0c0fe40000f21070ULL, 0x0000000f8800720cULL, 0x000fc40002fa1070ULL,
0x000054106c6d7816ULL, 0x000fe4000000006dULL, 0xff8000004e4e7808ULL, 0x000fe40001000000ULL,
0xff80000033337808ULL, 0x000fe40002000000ULL, 0xff8000005e5e7808ULL, 0x000fe40000800000ULL,
0xff8000004d4d7808ULL, 0x000fe40002800000ULL, 0x0000006368ff7212ULL, 0x000fc4000786c0ffULL,
0x0000006d12ff7212ULL, 0x000fe4000780c0ffULL, 0x000000671aff7212ULL, 0x040fe4000784c0ffULL,
0x0000006d1aff7212ULL, 0x000fe4000788c0ffULL, 0x000000658eff7212ULL, 0x000fe4000782c0ffULL,
0x0000006768ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000172137824ULL, 0x100fe200078e0a23ULL,
0x0000000f6400720cULL, 0x080fe20000701470ULL, 0x0000000194197824ULL, 0x000fe200078e0a23ULL,
0x0000000f1800720cULL, 0x000fc40001741470ULL, 0x0000000f1800720cULL, 0x080fe40002781470ULL,
0x0000000f2200720cULL, 0x0c0fe40001f61470ULL, 0x0000000f2200720cULL, 0x080fe40002fa1470ULL,
0x0000000f6a00720cULL, 0x000fe40000f21470ULL, 0x0000001862987812ULL, 0x040fe400078efcffULL,
0x00000019629e7812ULL, 0x000fc400078efcffULL, 0x0000000f6200720cULL, 0x080fe40000701070ULL,
0x0000000f8800720cULL, 0x0c0fe40001741070ULL, 0x0000000f8800720cULL, 0x080fe40002781070ULL,
0x0000000f8a00720cULL, 0x0c0fe40001f61070ULL, 0x0000000f8a00720cULL, 0x080fe40002fa1070ULL,
0x0000000f8c00720cULL, 0x000fc40000f21070ULL, 0x00000013d0907219ULL, 0x040fe400000006ffULL,
0x00000019d0967219ULL, 0x000fe400000006ffULL, 0x000054106f6f7816ULL, 0x008fe40000000076ULL,
0x0000541071717816ULL, 0x000fe40000000078ULL, 0x00005800989a7a10ULL, 0x000fe40007ffe0ffULL,
0x000058009ea07a10ULL, 0x000fc40007ffe0ffULL, 0xff8000002e2e7808ULL, 0x000fe40000000000ULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000005d5d7808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0xff80000047477808ULL, 0x000fc40000800000ULL, 0x0000006568ff7212ULL, 0x000fe4000780c0ffULL,
0x000000678eff7212ULL, 0x000fe4000784c0ffULL, 0x0000006d68ff7212ULL, 0x080fe4000788c0ffULL,
0x0000006d8eff7212ULL, 0x000fe4000786c0ffULL, 0x0000006f96ff7212ULL, 0x000fe400078ac0ffULL,
0x0000007190ff7212ULL, 0x000fe2000782c0ffULL, 0x000000019a1b7824ULL, 0x100fe200078e0a23ULL,
0x0000000f2200720cULL, 0x080fe20000701470ULL, 0x00000001a0237824ULL, 0x000fe200078e0a23ULL,
0x0000000f2200720cULL, 0x000fc40002781470ULL, 0x0000000f6a00720cULL, 0x0c0fe40001741470ULL,
0x0000000f6a00720cULL, 0x080fe40001f61470ULL, 0x0000000f7200720cULL, 0x080fe40000f21470ULL,
0x0000000f9400720cULL, 0x080fe40002fa1470ULL, 0x0000000f8a00720cULL, 0x0c0fe40000701070ULL,
0x0000000f8a00720cULL, 0x000fc40002781070ULL, 0x0000000f8c00720cULL, 0x0c0fe40001741070ULL,
0x0000000f8c00720cULL, 0x080fe40001f61070ULL, 0x0000000f7400720cULL, 0x080fe40000f21070ULL,
0x0000000f9200720cULL, 0x000fe40002fa1070ULL, 0x0000001bd09c7219ULL, 0x040fe400000006ffULL,
0x00000023d0a27219ULL, 0x000fc400000006ffULL, 0x0000541073737816ULL, 0x000fe4000000007aULL,
0x0000541075757816ULL, 0x000fe40000000080ULL, 0xff80000045457808ULL, 0x000fe40000000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000035357808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fc40001800000ULL, 0xff80000046467808ULL, 0x000fe40000800000ULL,
0xff8000005a5a7808ULL, 0x000fe40002800000ULL, 0x0000006f90ff7212ULL, 0x080fe4000780c0ffULL,
0x0000006f9cff7212ULL, 0x000fe4000788c0ffULL, 0x0000007390ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007590ff7212ULL, 0x000fc4000786c0ffULL, 0x0000007396ff7212ULL, 0x000fe4000782c0ffULL,
0x00000071a2ff7212ULL, 0x000fe200078ac0ffULL, 0x000000017e6b7824ULL, 0x000fe200078e0a69ULL,
0x0000000f7200720cULL, 0x0c0fe40000701470ULL, 0x0000000f7200720cULL, 0x0c0fe40001741470ULL,
0x0000000f7200720cULL, 0x080fe40001f61470ULL, 0x0000000f9400720cULL, 0x000fc40000f21470ULL,
0x0000000f9a00720cULL, 0x080fe40002781470ULL, 0x0000000fa000720cULL, 0x080fe40002fa1470ULL,
0x0000002162a67812ULL, 0x000fe400078efcffULL, 0x0000000f7400720cULL, 0x0c0fe40000701070ULL,
0x0000000f7400720cULL, 0x0c0fe40001741070ULL, 0x0000000f7400720cULL, 0x000fc40001f61070ULL,
0x0000000f9200720cULL, 0x080fe40000f21070ULL, 0x0000000f9800720cULL, 0x080fe40002781070ULL,
0x0000000f9e00720cULL, 0x000fe40002fa1070ULL, 0x0000006bd0a47219ULL, 0x000fe400000006ffULL,
0x000054107d7d7816ULL, 0x000fe400000000d2ULL, 0x00005800a6a87a10ULL, 0x000fc40007ffe0ffULL,
0xff8000005b5b7808ULL, 0x000fe40000000000ULL, 0xff80000036367808ULL, 0x000fe40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40000800000ULL,
0xff80000059597808ULL, 0x000fe40002000000ULL, 0xff8000004a4a7808ULL, 0x000fc40002800000ULL,
0x0000007196ff7212ULL, 0x040fe4000780c0ffULL, 0x0000007596ff7212ULL, 0x000fe4000784c0ffULL,
0x000000719cff7212ULL, 0x000fe4000786c0ffULL, 0x00000073a2ff7212ULL, 0x040fe4000782c0ffULL,
0x00000075a2ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007da4ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a8777824ULL, 0x000fe200078e0a69ULL, 0x0000000f9400720cULL, 0x000fc40000701470ULL,
0x0000000f9400720cULL, 0x080fe40001741470ULL, 0x0000000f9a00720cULL, 0x080fe40001f61470ULL,
0x0000000fa000720cULL, 0x0c0fe40000f21470ULL, 0x0000000fa000720cULL, 0x080fe40002781470ULL,
0x0000000f7e00720cULL, 0x000fe40002fa1470ULL, 0x0000002862ac7812ULL, 0x000fc400078efcffULL,
0x0000002962b27812ULL, 0x000fe400078efcffULL, 0x0000000f9200720cULL, 0x0c0fe40000701070ULL,
0x0000000f9200720cULL, 0x080fe40001741070ULL, 0x0000000f9800720cULL, 0x080fe40001f61070ULL,
0x0000000f9e00720cULL, 0x0c0fe40000f21070ULL, 0x0000000f9e00720cULL, 0x000fc40002781070ULL,
0x0000000f7c00720cULL, 0x000fe40002fa1070ULL, 0x00000077d0aa7219ULL, 0x000fe400000006ffULL,
0x000054107b7b7816ULL, 0x000fe40000000082ULL, 0x0000541081817816ULL, 0x000fe400000000d6ULL,
0x0000541083837816ULL, 0x000fe400000000daULL, 0x00005800acae7a10ULL, 0x000fc40007ffe0ffULL,
0x00005800b2b47a10ULL, 0x000fe40007ffe0ffULL, 0xff80000051517808ULL, 0x000fe40000000000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000039397808ULL, 0x000fe40000800000ULL, 0xff80000029297808ULL, 0x000fc40002000000ULL,
0xff80000049497808ULL, 0x000fe40002800000ULL, 0x000000638eff7212ULL, 0x000fe400078cc0ffULL,
0x000000739cff7212ULL, 0x040fe4000780c0ffULL, 0x000000759cff7212ULL, 0x000fe4000784c0ffULL,
0x0000007ba4ff7212ULL, 0x040fe4000786c0ffULL, 0x00000081a4ff7212ULL, 0x000fc4000782c0ffULL,
0x00000083a4ff7212ULL, 0x000fe4000788c0ffULL, 0x00000081aaff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ae797824ULL, 0x100fe200078e0a69ULL, 0x0000000f6a00720cULL, 0x080fe200037c1470ULL,
0x00000001b4697824ULL, 0x000fe200078e0a69ULL, 0x0000000f9a00720cULL, 0x0c0fe40000701470ULL,
0x0000000f9a00720cULL, 0x080fe40001741470ULL, 0x0000000f7e00720cULL, 0x000fc40001f61470ULL,
0x0000000f7e00720cULL, 0x0c0fe40000f21470ULL, 0x0000000f7e00720cULL, 0x080fe40002781470ULL,
0x0000000fa800720cULL, 0x080fe40002fa1470ULL, 0x0000000f8c00720cULL, 0x080fe400037c1070ULL,
0x0000000f9800720cULL, 0x0c0fe40000701070ULL, 0x0000000f9800720cULL, 0x000fc40001741070ULL,
0x0000000f7c00720cULL, 0x0c0fe40001f61070ULL, 0x0000000f7c00720cULL, 0x0c0fe40000f21070ULL,
0x0000000f7c00720cULL, 0x080fe40002781070ULL, 0x0000000fa600720cULL, 0x000fe40002fa1070ULL,
0x00000079d0b07219ULL, 0x040fe400000006ffULL, 0x00000069d0b67219ULL, 0x000fc400000006ffULL,
0xff8000005c5c7808ULL, 0x000fe40003000000ULL, 0xff80000038387808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000061617808ULL, 0x000fe40001800000ULL,
0xff8000003a3a7808ULL, 0x000fe40000800000ULL, 0xff8000002a2a7808ULL, 0x000fc40002000000ULL,
0xff8000003b3b7808ULL, 0x000fe40002800000ULL, 0x0000006fa2ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007baaff7212ULL, 0x080fe4000780c0ffULL, 0x0000007bb0ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007daaff7212ULL, 0x040fe4000786c0ffULL, 0x00000083aaff7212ULL, 0x000fc4000782c0ffULL,
0x0000007db0ff7212ULL, 0x000fe4000788c0ffULL, 0x00000081b6ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000186857824ULL, 0x000fe200078e0a7fULL, 0x0000000fa000720cULL, 0x080fe400037c1470ULL,
0x0000000fa800720cULL, 0x0c0fe40000701470ULL, 0x0000000fa800720cULL, 0x0c0fe40001f61470ULL,
0x0000000fa800720cULL, 0x000fc40000f21470ULL, 0x0000000fae00720cULL, 0x0c0fe40001741470ULL,
0x0000000fae00720cULL, 0x080fe40002781470ULL, 0x0000000fb400720cULL, 0x000fe40002fa1470ULL,
0x0000003162c07812ULL, 0x040fe400078efcffULL, 0x0000003862c67812ULL, 0x040fe400078efcffULL,
0x0000003962cc7812ULL, 0x000fc400078efcffULL, 0x0000000f9e00720cULL, 0x080fe400037c1070ULL,
0x0000000fa600720cULL, 0x0c0fe40000701070ULL, 0x0000000fa600720cULL, 0x0c0fe40001f61070ULL,
0x0000000fa600720cULL, 0x080fe40000f21070ULL, 0x0000000fac00720cULL, 0x0c0fe40001741070ULL,
0x0000000fac00720cULL, 0x000fc40002781070ULL, 0x0000000fb200720cULL, 0x000fe40002fa1070ULL,
0x00000085d0ba7219ULL, 0x000fe400000006ffULL, 0x00005410b88b7816ULL, 0x000fe4000000008bULL,
0x00005410d88f7816ULL, 0x000fe4000000008fULL, 0x00005800c0c27a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c6c87a10ULL, 0x000fc40007ffe0ffULL, 0x00005800ccce7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000060607808ULL, 0x000fe40003000000ULL, 0xff80000058587808ULL, 0x000fe40000000000ULL,
0xff80000050507808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fe40000800000ULL,
0xff80000057577808ULL, 0x000fc40001000000ULL, 0xff8000004b4b7808ULL, 0x000fe40002000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x0000007bb6ff7212ULL, 0x040fe400078cc0ffULL,
0x0000007db6ff7212ULL, 0x000fe4000780c0ffULL, 0x00000081b0ff7212ULL, 0x040fe4000786c0ffULL,
0x00000083b0ff7212ULL, 0x000fc4000782c0ffULL, 0x00000083b6ff7212ULL, 0x000fe4000784c0ffULL,
0x0000008bbaff7212ULL, 0x040fe4000788c0ffULL, 0x0000008fbaff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c2877824ULL, 0x100fe200078e0a7fULL, 0x0000000fae00720cULL, 0x080fe20001f61470ULL,
0x00000001c8897824ULL, 0x100fe200078e0a7fULL, 0x0000000fae00720cULL, 0x080fe20000f21470ULL,
0x00000001ce7f7824ULL, 0x000fe200078e0a7fULL, 0x0000000fb400720cULL, 0x000fc400037c1470ULL,
0x0000000fb400720cULL, 0x0c0fe40000701470ULL, 0x0000000fb400720cULL, 0x080fe40001741470ULL,
0x0000000f8600720cULL, 0x0c0fe40002781470ULL, 0x0000000f8600720cULL, 0x000fe40002fa1470ULL,
0x00000087d0c47219ULL, 0x040fe400000006ffULL, 0x00000089d0ca7219ULL, 0x000fc400000006ffULL,
0x0000000fac00720cULL, 0x0c0fe40001f61070ULL, 0x0000000fac00720cULL, 0x080fe40000f21070ULL,
0x0000000fb200720cULL, 0x0c0fe400037c1070ULL, 0x0000000fb200720cULL, 0x0c0fe40000701070ULL,
0x0000000fb200720cULL, 0x080fe40001741070ULL, 0x0000000f8400720cULL, 0x000fc40002781070ULL,
0x0000000f8400720cULL, 0x000fe40002fa1070ULL, 0x0000007fd0d07219ULL, 0x000fe400000006ffULL,
0x00005410d48d7816ULL, 0x000fe4000000008dULL, 0xff8000003c3c7808ULL, 0x000fe40001800000ULL,
0xff8000001f1f7808ULL, 0x000fe40000800000ULL, 0xff80000056567808ULL, 0x000fc40003000000ULL,
0xff8000004f4f7808ULL, 0x000fe40000000000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000055557808ULL, 0x000fe40002000000ULL, 0xff80000042427808ULL, 0x000fe40002800000ULL,
0x0000008bc4ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008bcaff7212ULL, 0x000fc4000782c0ffULL,
0x0000008bd0ff7212ULL, 0x000fe400078cc0ffULL, 0x0000008dbaff7212ULL, 0x080fe4000780c0ffULL,
0x0000008dc4ff7212ULL, 0x080fe4000784c0ffULL, 0x0000008dcaff7212ULL, 0x000fe4000788c0ffULL,
0x0000008fc4ff7212ULL, 0x000fe400078ac0ffULL, 0x0000000f8600720cULL, 0x000fc40000701470ULL,
0x0000000fc200720cULL, 0x0c0fe40001f61470ULL, 0x0000000fc200720cULL, 0x0c0fe40001741470ULL,
0x0000000fc200720cULL, 0x080fe40002fa1470ULL, 0x0000000fc800720cULL, 0x080fe40000f21470ULL,
0x0000000fce00720cULL, 0x080fe400037c1470ULL, 0x0000000fc800720cULL, 0x000fc40002781470ULL,
0x0000000f8400720cULL, 0x080fe40000701070ULL, 0x0000000fc000720cULL, 0x0c0fe40001f61070ULL,
0x0000000fc000720cULL, 0x0c0fe40001741070ULL, 0x0000000fc000720cULL, 0x080fe40002fa1070ULL,
0x0000000fc600720cULL, 0x080fe40000f21070ULL, 0x0000000fcc00720cULL, 0x000fc400037c1070ULL,
0x0000000fc600720cULL, 0x000fe40002781070ULL, 0x00005410dc917816ULL, 0x000fe40000000091ULL,
0xff8000004c4c7808ULL, 0x000fe40000000000ULL, 0xff80000054547808ULL, 0x000fe40001800000ULL,
0xff80000044447808ULL, 0x000fe40001000000ULL, 0xff8000003e3e7808ULL, 0x000fc40002800000ULL,
0xff80000053537808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fe40003000000ULL,
0xff80000043437808ULL, 0x000fe40002000000ULL, 0x0000008dd0ff7212ULL, 0x000fe4000780c0ffULL,
0x0000008fcaff7212ULL, 0x080fe4000786c0ffULL, 0x0000008fd0ff7212ULL, 0x000fc4000784c0ffULL,
0x00000091baff7212ULL, 0x080fe400078ac0ffULL, 0x00000091c4ff7212ULL, 0x080fe4000782c0ffULL,
0x00000091caff7212ULL, 0x080fe400078cc0ffULL, 0x00000091d0ff7212ULL, 0x000fe4000788c0ffULL,
0x0000000f8600720cULL, 0x080fe40002fa1470ULL, 0x0000000fc200720cULL, 0x000fc40000f21470ULL,
0x0000000fc800720cULL, 0x0c0fe40001f61470ULL, 0x0000000fc800720cULL, 0x080fe400037c1470ULL,
0x0000000fce00720cULL, 0x0c0fe40000701470ULL, 0x0000000fce00720cULL, 0x0c0fe40001741470ULL,
0x0000000fce00720cULL, 0x080fe40002781470ULL, 0x0000000f8400720cULL, 0x000fc40002fa1070ULL,
0x0000000fc000720cULL, 0x080fe40000f21070ULL, 0x0000000fcc00720cULL, 0x080fe40000701070ULL,
0x0000000fc600720cULL, 0x0c0fe40001f61070ULL, 0x0000000fc600720cULL, 0x080fe400037c1070ULL,
0x0000000fcc00720cULL, 0x0c0fe40001741070ULL, 0x0000000fcc00720cULL, 0x000fc40002781070ULL,
0xff80000041417808ULL, 0x000fe40000000000ULL, 0xff8000003f3f7808ULL, 0x000fe40001800000ULL,
0xff80000040407808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fc40003000000ULL,
0xff80000027277808ULL, 0x000fc40002000000ULL, 0x0000005f1400720bULL, 0x004fe40003f1e000ULL,
0x0000004e1500720bULL, 0x000fe40003f3e000ULL, 0x000000331600720bULL, 0x000fe40003f5e000ULL,
0x0000002e1700720bULL, 0x000fe40003f7e000ULL, 0x000000145f0f7208ULL, 0x000fe40004000000ULL,
0x000000154e127208ULL, 0x000fc40004800000ULL, 0x0000001633137208ULL, 0x000fe40005000000ULL,
0x000000172e147208ULL, 0x000fe40005800000ULL, 0x0000005e0f00720bULL, 0x000fe40003f1e000ULL,
0x0000004d1200720bULL, 0x000fe40003f3e000ULL, 0x000000321300720bULL, 0x000fe40003f5e000ULL,
0x000000311400720bULL, 0x000fc40003f7e000ULL, 0x0000000f5e167208ULL, 0x000fe40004000000ULL,
0x000000124d127208ULL, 0x000fe40004800000ULL, 0x0000001332137208ULL, 0x000fe40005000000ULL,
0x0000001431147208ULL, 0x000fe40005800000ULL, 0x0000005d1600720bULL, 0x000fe40003f1e000ULL,
0x000000451200720bULL, 0x000fc40003f3e000ULL, 0x000000341300720bULL, 0x000fe40003f5e000ULL,
0x0000002f1400720bULL, 0x000fe40003f7e000ULL, 0x000000165d0f7208ULL, 0x000fe40004000000ULL,
0x0000001245127208ULL, 0x000fe40004800000ULL, 0x0000001334167208ULL, 0x000fe40005000000ULL,
0x000000142f137208ULL, 0x000fc40005800000ULL, 0x0000005c0f00720bULL, 0x000fe40003f1e000ULL,
0x000000471200720bULL, 0x000fe40003f3e000ULL, 0x000000351600720bULL, 0x000fe40003f5e000ULL,
0x000000301300720bULL, 0x000fe40003f7e000ULL, 0x0000000f5c147208ULL, 0x000fe40004000000ULL,
0x00000012470f7208ULL, 0x000fc40004800000ULL, 0x0000001635157208ULL, 0x000fe40005000000ULL,
0x0000001330127208ULL, 0x000fe40005800000ULL, 0x0000005b1400720bULL, 0x000fe40003f1e000ULL,
0x000000460f00720bULL, 0x000fe40003f3e000ULL, 0x000000361500720bULL, 0x000fe40003f5e000ULL,
0x0000002d1200720bULL, 0x000fc40003f7e000ULL, 0x000000145b137208ULL, 0x000fe40004000000ULL,
0x0000000f46147208ULL, 0x000fe40004800000ULL, 0x0000001536167208ULL, 0x000fe40005000000ULL,
0x000000122d0f7208ULL, 0x000fe40005800000ULL, 0x0000005a1300720bULL, 0x000fe40003f1e000ULL,
0x000000511400720bULL, 0x000fc40003f3e000ULL, 0x000000371600720bULL, 0x000fe40003f5e000ULL,
0x0000002c0f00720bULL, 0x000fe40003f7e000ULL, 0x000000135a127208ULL, 0x000fe40004000000ULL,
0x0000001451137208ULL, 0x000fe40004800000ULL, 0x0000001637157208ULL, 0x000fe40005000000ULL,
0x0000000f2c147208ULL, 0x000fc40005800000ULL, 0x000000591200720bULL, 0x000fe40003f1e000ULL,
0x000000481300720bULL, 0x000fe40003f3e000ULL, 0x000000381500720bULL, 0x000fe40003f5e000ULL,
0x0000002b1400720bULL, 0x000fe40003f7e000ULL, 0x00000012590f7208ULL, 0x000fe40004000000ULL,
0x0000001348137208ULL, 0x000fc40004800000ULL, 0x0000001538127208ULL, 0x000fe40005000000ULL,
0x000000142b147208ULL, 0x000fe40005800000ULL, 0x000000600f00720bULL, 0x000fe40003f1e000ULL,
0x0000004a1300720bULL, 0x000fe40003f3e000ULL, 0x000000391200720bULL, 0x000fe40003f5e000ULL,
0x000000291400720bULL, 0x000fc40003f7e000ULL, 0x0000000f60167208ULL, 0x000fe40004000000ULL,
0x000000134a187208ULL, 0x000fe40004800000ULL, 0x00000012390f7208ULL, 0x000fe40005000000ULL,
0x0000001429137208ULL, 0x000fe40005800000ULL, 0x000000611600720bULL, 0x000fe40003f1e000ULL,
0x000000491800720bULL, 0x000fc40003f3e000ULL, 0x0000003a0f00720bULL, 0x000fe40003f5e000ULL,
0x0000002a1300720bULL, 0x000fe40003f7e000ULL, 0x0000001661157208ULL, 0x000fe40004000000ULL,
0x0000001849177208ULL, 0x000fe40004800000ULL, 0x0000000f3a127208ULL, 0x000fe40005000000ULL,
0x000000132a137208ULL, 0x000fc40005800000ULL, 0x000000581500720bULL, 0x000fe40003f1e000ULL,
0x000000501700720bULL, 0x000fe40003f3e000ULL, 0x0000003b1200720bULL, 0x000fe40003f5e000ULL,
0x000000281300720bULL, 0x000fe40003f7e000ULL, 0x0000001558147208ULL, 0x000fe40004000000ULL,
0x0000001750167208ULL, 0x000fc40004800000ULL, 0x000000123b0f7208ULL, 0x000fe40005000000ULL,
0x0000001328127208ULL, 0x000fe40005800000ULL, 0x000000571400720bULL, 0x000fe40003f1e000ULL,
0x0000004b1600720bULL, 0x000fe40003f3e000ULL, 0x0000003c0f00720bULL, 0x000fe40003f5e000ULL,
0x0000001f1200720bULL, 0x000fc40003f7e000ULL, 0x0000001457137208ULL, 0x000fe40004000000ULL,
0x000000164b167208ULL, 0x000fe40004800000ULL, 0x0000000f3c147208ULL, 0x000fe40005000000ULL,
0x000000121f127208ULL, 0x000fe40005800000ULL, 0x000000561300720bULL, 0x000fe40003f1e000ULL,
0x0000004f1600720bULL, 0x000fc40003f3e000ULL, 0x0000003d1400720bULL, 0x000fe40003f5e000ULL,
0x000000211200720bULL, 0x000fe40003f7e000ULL, 0x0000001356187208ULL, 0x000fe40004000000ULL,
0x000000164f0f7208ULL, 0x000fe40004800000ULL, 0x000000143d137208ULL, 0x000fe40005000000ULL,
0x0000001221157208ULL, 0x000fc40005800000ULL, 0x0000004c0f00720bULL, 0x000fe40003f3e000ULL,
0x000000551800720bULL, 0x000fe40003f1e000ULL, 0x000000421300720bULL, 0x000fe40003f5e000ULL,
0x000000241500720bULL, 0x000fe40003f7e000ULL, 0x0000000f4c0f7208ULL, 0x000fe40004800000ULL,
0x0000001855177208ULL, 0x000fc40004000000ULL, 0x0000001342137208ULL, 0x000fe40005000000ULL,
0x0000001524127208ULL, 0x000fe40005800000ULL, 0x000000440f00720bULL, 0x000fe40003f3e000ULL,
0x000000541700720bULL, 0x000fe40003f1e000ULL, 0x0000003e1300720bULL, 0x000fe40003f5e000ULL,
0x000000251200720bULL, 0x000fc40003f7e000ULL, 0x0000000f44167208ULL, 0x000fe40004800000ULL,
0x0000001754147208ULL, 0x000fe40004000000ULL, 0x000000133e187208ULL, 0x000fe40005000000ULL,
0x00000012250f7208ULL, 0x000fe40005800000ULL, 0x000000531400720bULL, 0x000fe40003f1e000ULL,
0x000000431600720bULL, 0x000fc40003f3e000ULL, 0x0000003f1800720bULL, 0x000fe40003f5e000ULL,
0x000000260f00720bULL, 0x000fe40003f7e000ULL, 0x0000001453137208ULL, 0x000fe40004000000ULL,
0x0000001643167208ULL, 0x000fe40004800000ULL, 0x000000183f157208ULL, 0x000fe40005000000ULL,
0x0000000f26127208ULL, 0x000fc40005800000ULL, 0x000000521300720bULL, 0x000fe40003f1e000ULL,
0x000000411600720bULL, 0x000fe40003f3e000ULL, 0x000000401500720bULL, 0x000fe40003f5e000ULL,
0x000000271200720bULL, 0x000fe40003f7e000ULL, 0x0000001352187208ULL, 0x000fe40004000000ULL,
0x00000016411a7208ULL, 0x000fc40004800000ULL, 0x0000001540157208ULL, 0x000fe40005000000ULL,
0x0000001227227208ULL, 0x000fe20005800000ULL, 0x000025627f007947ULL, 0x000fea000b800000ULL,
0x0c401f00180f7f89ULL, 0x0004e400000e0000ULL, 0x0000000f1800720bULL, 0x00cfc80003f1e000ULL,
0x000000180f1b7208ULL, 0x000fe20004000000ULL, 0x000025827f007947ULL, 0x000fea000b800000ULL,
0x0c401f001a0f7f89ULL, 0x000ea800000e0000ULL, 0x0c401f0015127f89ULL, 0x000ee800000e0000ULL,
0x0c401f0022137f89ULL, 0x000e6800000e0000ULL, 0x0c201f001b147f89ULL, 0x000e6200000e0000ULL,
0x0000000f1a00720bULL, 0x004fc40003f1e000ULL, 0x000000121500720bULL, 0x008fe40003f3e000ULL,
0x0000001a0f0f7208ULL, 0x000fe40004000000ULL, 0x0000001512127208ULL, 0x000fe40004800000ULL,
0x000000132200720bULL, 0x002fe20003f1e000ULL, 0x0c201f000f167f89ULL, 0x000e6600000e0000ULL,
0x0000002213177208ULL, 0x000fe20004000000ULL, 0x0c201f0012197f89ULL, 0x000ea200000e0000ULL,
0x000000141b00720bULL, 0x000fc60003f1e000ULL, 0x0c201f0017187f89ULL, 0x0006e200000e0000ULL,
0x0000001b14147208ULL, 0x000fe40004000000ULL, 0x000000160f00720bULL, 0x002fe40003f3e000ULL,
0x000000191200720bULL, 0x004fe40003f5e000ULL, 0x0000000f16157208ULL, 0x000fe40004800000ULL,
0x0000001219167208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b14127820ULL, 0x008fe20000410000ULL,
0x000000181700720bULL, 0x000fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x00000002ff6d7819ULL, 0x000fe20000011605ULL, 0x3fb8aa3b590f7823ULL, 0x100fe20000010812ULL,
0x0000001718177208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b5f5f7823ULL, 0x100fe20000010812ULL,
0x000000036d187810ULL, 0x000fe20007ffe0ffULL, 0x0000000f00197308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b5e5e7823ULL, 0x100fe20000010812ULL, 0x0000000305ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b5d5d7823ULL, 0x000fc40000010812ULL, 0x3fb8aa3b5c5c7823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010812ULL, 0x0000005d001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b5a5a7823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b60607823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b61597823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010812ULL,
0x0000005c00137308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b57577823ULL, 0x000fc40000010812ULL,
0x3fb8aa3b56567823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b550f7823ULL, 0x102fe40000010812ULL,
0x3fb8aa3b54227823ULL, 0x100fe20000010812ULL, 0x0000006000607308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b53237823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b52527823ULL, 0x000fe40000010812ULL,
0x3fb8aa3b15127820ULL, 0x000fc40000410000ULL, 0x3fb8aa3b176c7820ULL, 0x000fe20000410000ULL,
0x0000005f005f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010812ULL,
0x0000001a131a723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010812ULL,
0x00000045001b7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b46467823ULL, 0x000fc40000010812ULL,
0x3fb8aa3b51517823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b48487823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010812ULL, 0x0000005e005e7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b49497823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b50507823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b4b4b7823ULL, 0x000fc40000010812ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010812ULL,
0x0000004a00537308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4c457823ULL, 0x102fe40000010812ULL,
0x3fb8aa3b44447823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b43437823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b41127823ULL, 0x000fe20000010812ULL, 0x0000004f005c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16417820ULL, 0x000fc40000410000ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001086cULL,
0x3fb8aa3b38387823ULL, 0x100fe40000010841ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010841ULL,
0x00000012004a7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b35357823ULL, 0x100fe40000010841ULL,
0x3fb8aa3b3c3c7823ULL, 0x000fe40000010841ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fc4000001086cULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010841ULL, 0x00000038004f7308ULL, 0x000fe20000000800ULL,
0x000000086d657824ULL, 0x040fe200078e00ffULL, 0x000000016d127810ULL, 0x002fe20007ffe0ffULL,
0x3fb8aa3b33337823ULL, 0x100fe40000010841ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010841ULL,
0xfffffff865657812ULL, 0x000fe200078ee212ULL, 0x3fb8aa3b31317823ULL, 0x000fe2000001086cULL,
0x0000002e00387308ULL, 0x0003e20000000800ULL, 0x000000086d677824ULL, 0x040fe200078e00ffULL,
0x000000026d127810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b3d3d7823ULL, 0x000fc40000010841ULL,
0x000000086d6b7824ULL, 0x000fe200078e00ffULL, 0xfffffff867677812ULL, 0x000fe200078ee212ULL,
0x00000004ff127e24ULL, 0x000fe2000f8e00ffULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b302e7823ULL, 0x002fe2000001086cULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000086d697824ULL, 0x000fe200078e00ffULL, 0x3f8000001212783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe40000010841ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010841ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010841ULL,
0xfffffff869697812ULL, 0x000fe200078ee218ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010841ULL,
0x0000005f5e18723eULL, 0x004fe200000010ffULL, 0x000000ffff137224ULL, 0x000fe200078e0012ULL,
0x000000106d5f7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010841ULL,
0x0000003c005d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b42427823ULL, 0x000fc40000010841ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe40000010841ULL, 0x3fb8aa3b3f3f7823ULL, 0x000fe20000010841ULL,
0xffffffff6d417810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001086cULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29297823ULL, 0x000fe4000001086cULL,
0x000000ffff6e7224ULL, 0x100fe400078e0012ULL, 0x000000ffff6f7224ULL, 0x000fc400078e0012ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001086cULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001086cULL, 0x3fb8aa3b28287823ULL, 0x100fe4000001086cULL,
0x3fb8aa3b21217823ULL, 0x000fc6000001086cULL, 0x0000004700547308ULL, 0x000e700000000800ULL,
0x0000003900627308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x0000001b541b723eULL, 0x002fce00000010ffULL, 0x0000002e003c7308ULL, 0x0002b00000000800ULL,
0x0000003300477308ULL, 0x000fe20000000800ULL, 0x00000034352e723eULL, 0x002fe400000010ffULL,
0x000000066d347810ULL, 0x000fca0007ffe0ffULL, 0x00000032004c7308ULL, 0x0002e20000000800ULL,
0x0000002f3c2f723eULL, 0x004fe200000010ffULL, 0x000000ffff3c7224ULL, 0x000fcc00078e0012ULL,
0x0000003100397308ULL, 0x000ea20000000800ULL, 0x000000046d327810ULL, 0x002fc80007ffe0ffULL,
0xfffffff86b6b7812ULL, 0x000fe400078ee232ULL, 0x000000196032723eULL, 0x000fe200000010ffULL,
0x0000003d00667308ULL, 0x0003e20000000800ULL, 0x0000004e4d19723eULL, 0x000fe200000010ffULL,
0x000000ffff4d7224ULL, 0x000fcc00078e0012ULL, 0x0000004800487308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b2c3d7823ULL, 0x002fe2000001086cULL, 0x000000474c2c723eULL, 0x008fe200000010ffULL,
0x000000ffff4c7224ULL, 0x000fca00078e0012ULL, 0x0000003a00557308ULL, 0x0003f00000000800ULL,
0x0000003d00357308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b2d3a7823ULL, 0x002fe2000001086cULL,
0x00000038392d723eULL, 0x004fc400000010ffULL, 0x000000485333723eULL, 0x000fe200000010ffULL,
0x000000086d537824ULL, 0x040fe400078e00ffULL, 0x000000086d487824ULL, 0x000fe200078e00ffULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000ffff3d7224ULL, 0x008fe200078e0012ULL,
0xfffffff853537812ULL, 0x000fcc00078ee234ULL, 0x0000003700377308ULL, 0x000e700000000800ULL,
0x00000040006a7308ULL, 0x000ff00000000800ULL, 0x0000003b00647308ULL, 0x000fe20000000800ULL,
0x000000363734723eULL, 0x002fc400000010ffULL, 0x0000004f6236723eULL, 0x000fe400000010ffULL,
0x000000086d4f7810ULL, 0x000fc60007ffe0ffULL, 0x0000003a00407308ULL, 0x0002b00000000800ULL,
0x0000003e00687308ULL, 0x000fe20000000800ULL, 0x000000121838723cULL, 0x002b6e00000418ffULL,
0x0000003f00637308ULL, 0x0003e20000000800ULL, 0x000000403535723eULL, 0x004fc400000010ffULL,
0x000000056d137810ULL, 0x020fca0007ffe0ffULL, 0x0000005b005b7308ULL, 0x000fe20000000800ULL,
0x0000003c2c3c723cULL, 0x002f6e00000418ffULL, 0x0000005a005a7308ULL, 0x000e700000000800ULL,
0x0000004600467308ULL, 0x000ff00000000800ULL, 0x0000005100517308ULL, 0x000ea20000000800ULL,
0x0000005b5a30723eULL, 0x002fc400000010ffULL, 0xfffffff8485b7812ULL, 0x000fe200078ee241ULL,
0x3fb8aa3b24417823ULL, 0x000fe4000001086cULL, 0x000000086d247824ULL, 0x000fe400078e00ffULL,
0x0000004200617308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x000000465131723eULL, 0x004fe200000010ffULL, 0x000000086d467824ULL, 0x000fca00078e00ffULL,
0xfffffff846517812ULL, 0x000fe200078ee213ULL, 0x0000002900427308ULL, 0x000e620000000800ULL,
0x0000004c3038723cULL, 0x000b620000041838ULL, 0x3fb8aa3b25467823ULL, 0x000fcc000001086cULL,
0x0000005700577308ULL, 0x000fe20000000800ULL, 0xfffffff8244d7812ULL, 0x020fe200078ee26dULL,
0x3fb8aa3b264c7823ULL, 0x100fe2000001086cULL, 0x000000186d6d7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b276c7823ULL, 0x000fe2000001086cULL, 0x0000002b4237723eULL, 0x002fe200000010ffULL,
0x000000084f427824ULL, 0x000fe400078e00ffULL, 0x0000005600567308ULL, 0x000e660000000800ULL,
0xfffffff8424f7812ULL, 0x000fe200078ee24fULL, 0x0000006e343c723cULL, 0x000f68000004183cULL,
0x0000005900597308ULL, 0x000ff00000000800ULL, 0x0000005800587308ULL, 0x000ea20000000800ULL,
0x000000575626723eULL, 0x002fe200000010ffULL, 0x000000ffff567224ULL, 0x000fc400078e0012ULL,
0x000000ffff577224ULL, 0x000fc800078e0012ULL, 0x0000004900497308ULL, 0x000ff00000000800ULL,
0x0000005000507308ULL, 0x000e620000000800ULL, 0x000000595824723eULL, 0x004fce00000010ffULL,
0x0000004b004b7308ULL, 0x000eb00000000800ULL, 0x0000002a00137308ULL, 0x0007e20000000800ULL,
0x000000495025723eULL, 0x002fce00000010ffULL, 0x0000002800407308ULL, 0x0002620000000800ULL,
0x000000085f2a7824ULL, 0x008fe200078e00ffULL, 0x0000004b5c27723eULL, 0x004fc800000010ffULL,
0xfffffff82a5f7812ULL, 0x000fe400078ee25fULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x000000086d287824ULL, 0x002fe200078e00ffULL, 0x0000005d662a723eULL, 0x000fe200000010ffULL,
0x000000562438723cULL, 0x000f6a0000041838ULL, 0x0000002100427308ULL, 0x0002a20000000800ULL,
0x000000134029723eULL, 0x000fe200000010ffULL, 0x000000ffff137224ULL, 0x000fcc00078e0012ULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0xfffffff828217812ULL, 0x002fe400078ee26dULL,
0x000000556428723eULL, 0x000fca00000010ffULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x0000001f422b723eULL, 0x004fce00000010ffULL, 0x0000004300437308ULL, 0x000ea20000000800ULL,
0x00000012283c723cULL, 0x020fee000004183cULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x0000000f2240723eULL, 0x002fe400000010ffULL, 0x0001200020227811ULL, 0x000fca00078e60ffULL,
0x0000004400447308ULL, 0x000e620000000800ULL, 0x000000434a43723eULL, 0x004fe200000010ffULL,
0x000000104d4d7824ULL, 0x100fe200078e0222ULL, 0x0000000c114a7812ULL, 0x000fe200078ec0ffULL,
0x0000001065657824ULL, 0x100fe400078e0222ULL, 0x0000001067677824ULL, 0x100fe400078e0222ULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x0000001069697824ULL, 0x100fe400078e0222ULL,
0x000000106b6b7824ULL, 0x000fc400078e0222ULL, 0x0000001051517824ULL, 0x100fe400078e0222ULL,
0x0000001053537824ULL, 0x100fe200078e0222ULL, 0x0000005200527308ULL, 0x000ea20000000800ULL,
0x000000105b5b7824ULL, 0x000fe400078e0222ULL, 0x000000014d4d7824ULL, 0x000fe400078e024aULL,
0x000000104f4f7824ULL, 0x100fe400078e0222ULL, 0x000000105f5f7824ULL, 0x100fe200078e0222ULL,
0x0000004100477308ULL, 0x0003e20000000800ULL, 0x0000001021217824ULL, 0x000fe200078e0222ULL,
0x000000184d007388ULL, 0x0007e20000000800ULL, 0x000000ffff227224ULL, 0x000fc400078e0012ULL,
0x000000014a657824ULL, 0x040fe400078e0265ULL, 0x000000014a677824ULL, 0x000fe200078e0267ULL,
0x0000004600487308ULL, 0x0006e20000000800ULL, 0x000000454441723eULL, 0x002fe200000010ffULL,
0x000000014a697824ULL, 0x000fe200078e0269ULL, 0x000000235242723eULL, 0x004fe200000010ffULL,
0x000000ffff237224ULL, 0x000fe200078e0012ULL, 0x000000616844723eULL, 0x000fe200000010ffULL,
0x000000014a6b7824ULL, 0x000fe200078e026bULL, 0x0000001a65007388ULL, 0x0003e20000000800ULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x000000636a46723eULL, 0x008fe200000010ffULL,
0x000000014a517824ULL, 0x040fe200078e0251ULL, 0x000000124038723cULL, 0x000b620000041838ULL,
0x000000014a537824ULL, 0x040fe200078e0253ULL, 0x0000003067007388ULL, 0x0003e20000000800ULL,
0x000000014a5b7824ULL, 0x000fc400078e025bULL, 0x0000006c000f7308ULL, 0x000ea20000000800ULL,
0x000000474845723eULL, 0x000fe200000010ffULL, 0x000000014a127824ULL, 0x060fe200078e024fULL,
0x0000003269007388ULL, 0x0003e20000000800ULL, 0x000000014a5f7824ULL, 0x040fe400078e025fULL,
0x000000014a4a7824ULL, 0x000fe200078e0221ULL, 0x000000246b007388ULL, 0x0003e80000000800ULL,
0x0000002651007388ULL, 0x0003e80000000800ULL, 0x0000004053007388ULL, 0x0003e20000000800ULL,
0x0000004c0f47723eULL, 0x004fc600000010ffULL, 0x000000425b007388ULL, 0x0003e20000000800ULL,
0x000000ffff397224ULL, 0x000fc600078e003aULL, 0x00000022443c723cULL, 0x000f62000004183cULL,
0x0000001912007388ULL, 0x0003e80000000800ULL, 0x0004001b65007388ULL, 0x0003e80000000800ULL,
0x0004003167007388ULL, 0x0003e80000000800ULL, 0x0004003369007388ULL, 0x0003e80000000800ULL,
0x000400256b007388ULL, 0x0003e80000000800ULL, 0x0004002751007388ULL, 0x0003e60000000800ULL,
0x000000ffff3a7224ULL, 0x020fe200078e003cULL, 0x0004004153007388ULL, 0x0003e20000000800ULL,
0x000000ffff3b7224ULL, 0x000fc600078e003eULL, 0x000400435b007388ULL, 0x0003e80000000800ULL,
0x0000002c5f007388ULL, 0x0003e80000000800ULL, 0x0008002e65007388ULL, 0x0003e80000000800ULL,
0x0008003467007388ULL, 0x0003e80000000800ULL, 0x0008003669007388ULL, 0x0003e80000000800ULL,
0x000800286b007388ULL, 0x0003e80000000800ULL, 0x0008002a51007388ULL, 0x0003e80000000800ULL,
0x0008004453007388ULL, 0x0003e80000000800ULL, 0x000800465b007388ULL, 0x0003e80000000800ULL,
0x0000002d4a007388ULL, 0x0003e80000000800ULL, 0x000c002f65007388ULL, 0x0003e80000000800ULL,
0x000c003567007388ULL, 0x0003e80000000800ULL, 0x000c003769007388ULL, 0x0003e80000000800ULL,
0x000c00296b007388ULL, 0x0003e80000000800ULL, 0x000c002b51007388ULL, 0x0003e80000000800ULL,
0x000c004553007388ULL, 0x0003e80000000800ULL, 0x000c00475b007388ULL, 0x0003e80000000800ULL,
0x01a000140a008388ULL, 0x0003e80000000c00ULL, 0x01a200380a008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000bbff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000800bbff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00001000bbff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000109097810ULL, 0x000fe20007ffe0ffULL,
0x00001800bbff7f8cULL, 0x0003e4000c80043fULL, 0x000000ffff0a7224ULL, 0x002fe200078e0010ULL,
0x0000001c0900720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff7d8000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff287807ULL, 0x008fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001c66000297802ULL, 0x000fc40000000f00ULL, 0x000015f000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0028ULL, 0xfffe626000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001c6c000297802ULL, 0x000fc40000000f00ULL, 0x0000159000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0028ULL, 0xfffe629000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001c73000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000014d000007944ULL, 0x014fea0003c00000ULL, 0xfffe634000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001c79000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000147000007944ULL, 0x016fea0003c00000ULL, 0xfffe645000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001c7f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000141000007944ULL, 0x01efea0003c00000ULL, 0xfffe656000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001c85000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000013b000007944ULL, 0x01efea0003c00000ULL, 0xfffe666000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001c8c000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0003ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000134000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffe6a6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001c93000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000012d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001003297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001c9a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000126000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffe69d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001ca1000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000011f000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffe699000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x008fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001ca7000297802ULL, 0x000fc40000000f00ULL,
0x000011e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff257224ULL, 0x000fe200078e0028ULL,
0xfffe9a1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001cad000297802ULL, 0x000fc40000000f00ULL,
0x0000118000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0028ULL,
0xfffe9a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0071ULL,
0x0001cb4000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000010c000007944ULL, 0x004fea0003c00000ULL,
0xfffe9b0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0071ULL,
0x0001cba000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000106000007944ULL, 0x006fea0003c00000ULL,
0xfffe9c1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0071ULL,
0x0001cc0000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000100000007944ULL, 0x00efea0003c00000ULL,
0xfffe9d2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0071ULL,
0x0001cc6000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000fa000007944ULL, 0x00efea0003c00000ULL,
0xfffe9e2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001ccd000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e0025ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000f3000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffea22000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001cd4000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000ec000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001025297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001cdb000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000e5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffea19000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001ce2000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000de000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffea15000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001ce8000297802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff737224ULL, 0x000fe200078e0028ULL, 0xfffecfc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001cee000297802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff787224ULL, 0x000fe200078e0028ULL, 0xfffed00000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0021ULL, 0x0001cf5000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000cb000007944ULL, 0x018fea0003c00000ULL, 0xfffed0b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0021ULL, 0x0001cfb000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000c5000007944ULL, 0x01afea0003c00000ULL, 0xfffed1c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0021ULL, 0x0001d01000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000bf000007944ULL, 0x01afea0003c00000ULL, 0xfffed2d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0021ULL, 0x0001d07000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000b9000007944ULL, 0x01afea0003c00000ULL, 0xfffed3d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001d0e000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0021ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000b2000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffed7a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001d15000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000ab000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001021297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001d1c000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000a4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffed71000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001d23000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000009d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffed6d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001d29000297802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0028ULL,
0xffff04f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001d2f000297802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff097224ULL, 0x000fe200078e0028ULL,
0xffff053000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0013ULL,
0x0001d36000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000008a000007944ULL, 0x018fea0003c00000ULL,
0xffff05e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0013ULL,
0x0001d3c000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000084000007944ULL, 0x01afea0003c00000ULL,
0xffff06f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0013ULL,
0x0001d42000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000007e000007944ULL, 0x01afea0003c00000ULL,
0xffff080000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0013ULL,
0x0001d48000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000078000007944ULL, 0x01afea0003c00000ULL,
0xffff090000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x0001d4f000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e0006ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000071000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xffff0cf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x0001d56000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001006297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001d5d000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xffff0c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x0001d64000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xffff0c2000007947ULL, 0x000fea000383ffffULL,
0x00000002ff197424ULL, 0x000fe200078e00ffULL, 0x0001d6b000127802ULL, 0x000fe20000000f00ULL,
0x0000001fff0f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff627424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x012fea0003c00000ULL, 0xffffda5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x002fe200078e001aULL, 0x0001d72000127802ULL, 0x000fe20000000f00ULL,
0x00000002ff197424ULL, 0x000fc400078e00ffULL, 0x0000001fff0f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff627424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x010fea0003c00000ULL,
0x0000000f1a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0001d7a000127802ULL, 0x000fe20000000f00ULL, 0x00000002ff197424ULL, 0x000fe200078e00ffULL,
0x0000001a0f167208ULL, 0x000fe20004000000ULL, 0x0000001fff0f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff627424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000000f1500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff187224ULL, 0x002fe200078e0022ULL,
0x0001d82000127802ULL, 0x000fe20000000f00ULL, 0x00000002ff197424ULL, 0x000fe200078e00ffULL,
0x000000150f1a7208ULL, 0x000fe20004000000ULL, 0x0000001fff0f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff627424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000000f2200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff187224ULL, 0x002fe200078e001bULL,
0x0001d8a000127802ULL, 0x000fe20000000f00ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x000000220f177208ULL, 0x000fe20004000000ULL, 0x0000001fff0f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff627424ULL, 0x000fc400078e00ffULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x0000000f1b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff187224ULL, 0x002fe200078e0016ULL,
0x0001d92000127802ULL, 0x000fe20000000f00ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x0000001b0f147208ULL, 0x000fe20004000000ULL, 0x0000001fff0f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff627424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000000f1600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff187224ULL, 0x002fe200078e001aULL,
0x0001d9a000127802ULL, 0x000fe20000000f00ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x000000160f157208ULL, 0x000fe20004000000ULL, 0x0000001fff0f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff627424ULL, 0x000fc400078e00ffULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x0000000f1a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff187224ULL, 0x002fe200078e0017ULL,
0x0001da2000127802ULL, 0x000fe20000000f00ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x0000001a0f167208ULL, 0x000fe20004000000ULL, 0x0000001fff0f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff627424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff187224ULL, 0x006fe200078e000fULL, 0xffffd83000007947ULL, 0x000fea000383ffffULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000022027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe244002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff137424ULL, 0x000fe200078e00ffULL, 0x0000006200007348ULL, 0x000fe80003800000ULL,
0x0c000019180f7389ULL, 0x0002a200000e000fULL, 0xfffe240012007950ULL, 0x000fea0003c3ffffULL,
0x0000002b00007348ULL, 0x000fe80003800000ULL, 0x000000292a297389ULL, 0x0002a400000e0070ULL,
0x000000ffff2a7224ULL, 0x002fc400078e0028ULL, 0x00000000ff2b7424ULL, 0x000fc800078e00ffULL,
0xfffe23b02a007950ULL, 0x000fea0003c3ffffULL, 0x000000012800780cULL, 0x000fe20003f65070ULL,
0x0000002a00007348ULL, 0x000fe80003800000ULL, 0x00000000ff2b7424ULL, 0x000fd000078e00ffULL,
0x0000000000287806ULL, 0x000fc800058e0100ULL, 0x0000002a28287212ULL, 0x000fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fc800078e0029ULL, 0xfffe23402a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000350ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c88ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d48ULL,
0x00000000000008a0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001688ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000168cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001dd80ULL, 0xfa00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001f600ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001f640ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001f9c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001688ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001df78ULL,
0x000000000001df78ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001f600ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001f9c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_80_cubin_len = 129696;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
