/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001abd0ULL, 0x000000000001a850ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x0000000000018bb0ULL,
0x0000000000000190ULL, 0x000b0022000004c4ULL, 0x0000000000018d40ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000018d80ULL, 0x0000000000000050ULL, 0x000b002200000519ULL,
0x0000000000018dd0ULL, 0x0000000000000130ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000018f00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00018bb000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x0061ac0400288080ULL, 0x0000000000000000ULL,
0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9508288080930828ULL, 0x2880809608288080ULL,
0x8098082880809708ULL, 0x0828808099082880ULL, 0x8080a0082880809cULL, 0xa408288080a10828ULL,
0x288080a708288080ULL, 0x80ab08288080aa08ULL, 0x08288080ac082880ULL, 0x8080b008288080adULL,
0xb208288080b10828ULL, 0x288080c708288080ULL, 0x808508288080c808ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080859200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x00018bb000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL,
0x0900000004042880ULL, 0x2880808228808085ULL, 0x000000b4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8c082880808b0828ULL, 0x2880808d08288080ULL, 0x808f082880808e08ULL, 0x0828808090082880ULL,
0x8080960828808092ULL, 0x9a08288080980828ULL, 0x288080a008288080ULL, 0x80a408288080a308ULL,
0x08288080a7082880ULL, 0x8080ab08288080aaULL, 0xb008288080ac0828ULL, 0x288080b108288080ULL,
0x80c708288080b208ULL, 0x08288080c8082880ULL, 0x8082801628808088ULL, 0x0000000000031028ULL,
0x2880808892000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x00018d4000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000acffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8c082880808b0828ULL, 0x2880808d08288080ULL, 0x808f082880808e08ULL,
0x0828808090082880ULL, 0x8080960828808092ULL, 0x9a08288080980828ULL, 0x288080a008288080ULL,
0x80a408288080a308ULL, 0x08288080a7082880ULL, 0x8080ab08288080aaULL, 0xb008288080ac0828ULL,
0x288080b108288080ULL, 0x80c808288080c708ULL, 0x16288080b2082880ULL, 0x0000031028808280ULL,
0xb292000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000024800000000ULL,
0x00018d8000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL, 0x80aa288080b20900ULL,
0x0000000000002880ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8c082880808b0828ULL,
0x2880808d08288080ULL, 0x808f082880808e08ULL, 0x0828808090082880ULL, 0x8080960828808092ULL,
0x9a08288080980828ULL, 0x288080a008288080ULL, 0x80a408288080a308ULL, 0x08288080a7082880ULL,
0x8080ab08288080aaULL, 0xb208288080ac0828ULL, 0x288080c708288080ULL, 0x80b108288080c808ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b19200ULL, 0x0000002cffffffffULL,
0x0000033800000000ULL, 0x00018dd000000000ULL, 0x0000013000000000ULL, 0x0000140400000000ULL,
0x80aa288080b10900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x00082304000000e8ULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0050016000000017ULL, 0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000003000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f001342804ULL, 0x0000040000000110ULL, 0x000023a000002300ULL, 0x00002620000024b0ULL,
0x00002ac000002a90ULL, 0x00002ba000002b30ULL, 0x00005cc000005c20ULL, 0x00005f5000005df0ULL,
0x000063f0000063c0ULL, 0x000064d000006460ULL, 0x00009370000092d0ULL, 0x00009600000094a0ULL,
0x00009aa000009a70ULL, 0x00009b8000009b10ULL, 0x0000ca000000c960ULL, 0x0000cc800000cb20ULL,
0x0000d1000000d0d0ULL, 0x0000d1e00000d170ULL, 0x0000f3c00000f3b0ULL, 0x0001705000017010ULL,
0x0001707000017060ULL, 0x000170e0000170c0ULL, 0x0001711000017100ULL, 0x00017e1000017db0ULL,
0x00017ef000017e80ULL, 0x00017ff000017f70ULL, 0x000180b000018050ULL, 0x0001819000018120ULL,
0x0001828000018210ULL, 0x00018340000182e0ULL, 0x00018420000183b0ULL, 0x00018510000184a0ULL,
0x000185d000018570ULL, 0x000186b000018640ULL, 0x000187a000018730ULL, 0x0001889000018810ULL,
0x0001899000018910ULL, 0x00018a9000018a10ULL, 0x00018b9000018b10ULL, 0x000001f004403904ULL,
0x00017600000000ffULL, 0x00000260003f0100ULL, 0x000176080000000fULL, 0x000002e0003f0120ULL,
0x000176880000000fULL, 0x000003a0003f0120ULL, 0x000176a80000000fULL, 0x000003d0003f0120ULL,
0x000176c80000000fULL, 0x00000460003f0120ULL, 0x00017600000000ffULL, 0x00000600003f0107ULL,
0x0000000400000009ULL, 0x000006b0003f0102ULL, 0x0000000000000009ULL, 0x00001000003f0101ULL,
0x00000000000000ffULL, 0x0000108000040107ULL, 0x00000000000000ffULL, 0x000010e000040101ULL,
0x0000002000000028ULL, 0x000012b0003f0101ULL, 0x000176cc00000030ULL, 0x00001480003f0105ULL,
0x000176cc00000030ULL, 0x00001e40003f0105ULL, 0x000176a800000041ULL, 0x00001fb0003f0107ULL,
0x000176a800000041ULL, 0x00002010003f0101ULL, 0x0001760800000042ULL, 0x00002030003f0101ULL,
0x0001760c00000042ULL, 0x00002200003f0105ULL, 0x0001760c00000042ULL, 0x000027f0003f0105ULL,
0x000176ac00000030ULL, 0x000029c0003f0105ULL, 0x000176ac00000030ULL, 0x00004b80003f0105ULL,
0x000176c800000028ULL, 0x00004c00003f0101ULL, 0x0001768800000050ULL, 0x00004c90003f0101ULL,
0x000000040000003fULL, 0x00004e60003f0105ULL, 0x000000040000003fULL, 0x00005850003f0105ULL,
0x000176a800000055ULL, 0x00005920003f0107ULL, 0x000176a800000055ULL, 0x00005980003f0101ULL,
0x0001762800000042ULL, 0x000059a0003f0101ULL, 0x0001762c00000042ULL, 0x00005b70003f0105ULL,
0x0001762c00000042ULL, 0x00006120003f0105ULL, 0x000176ac00000041ULL, 0x000062f0003f0105ULL,
0x000176ac00000041ULL, 0x000082e0003f0105ULL, 0x0000000000000028ULL, 0x00008350003f0101ULL,
0x0001769000000050ULL, 0x000083c0003f0101ULL, 0x000000040000003fULL, 0x00008590003f0105ULL,
0x000000040000003fULL, 0x00008e70003f0105ULL, 0x0000000000000043ULL, 0x00008fd0003f0107ULL,
0x000176a800000041ULL, 0x00009030003f0101ULL, 0x0001764800000042ULL, 0x00009050003f0101ULL,
0x0001764c00000042ULL, 0x00009220003f0105ULL, 0x0001764c00000042ULL, 0x000097d0003f0105ULL,
0x000176ac00000055ULL, 0x000099a0003f0105ULL, 0x000176ac00000055ULL, 0x0000b9b0003f0105ULL,
0x0000000000000028ULL, 0x0000ba20003f0101ULL, 0x0001769800000050ULL, 0x0000bab0003f0101ULL,
0x000000040000003fULL, 0x0000bc80003f0105ULL, 0x000000040000003fULL, 0x0000c580003f0105ULL,
0x0000000000000056ULL, 0x0000c660003f0107ULL, 0x000176a800000055ULL, 0x0000c6c0003f0101ULL,
0x0001766800000042ULL, 0x0000c6e0003f0101ULL, 0x0001766c00000042ULL, 0x0000c8b0003f0105ULL,
0x0001766c00000042ULL, 0x0000ce30003f0105ULL, 0x000176ac00000041ULL, 0x0000d000003f0105ULL,
0x000176ac00000041ULL, 0x0000ef60003f0105ULL, 0x0000000000000028ULL, 0x0000efc0003f0101ULL,
0x000176a000000050ULL, 0x00010000003f0101ULL, 0x00017600000000ffULL, 0x00011ce0003f0101ULL,
0x00017604000000ffULL, 0x00011eb0003f0105ULL, 0x00017604000000ffULL, 0x000120e0003f0105ULL,
0x00017600000000ffULL, 0x00012110003f0101ULL, 0x00017604000000ffULL, 0x000122d0003f0105ULL,
0x00017604000000ffULL, 0x00016440003f0105ULL, 0x000000000000003fULL, 0x00016560003f0101ULL,
0x000000040000003fULL, 0x00016730003f0105ULL, 0x000000040000003fULL, 0x00017bf0003f0105ULL,
0x0000000000000041ULL, 0x00017c50003f0101ULL, 0x0000000800000041ULL, 0x00017cb0003f0101ULL,
0x0000001000000041ULL, 0x00017d20003f0101ULL, 0x0000001800000041ULL, 0x00053803003f0101ULL,
0x0000fc9000141c04ULL, 0x000123300000ff10ULL, 0x00017d70000123f0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000003fcULL, 0x0000001a00000002ULL, 0x0000000000000314ULL,
0x0000001a00000002ULL, 0x0000000000000234ULL, 0x0000001a00000002ULL, 0x0000000000000134ULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x00000000000003d9ULL,
0x0000001a00000002ULL, 0x00000000000002eeULL, 0x0000001a00000002ULL, 0x000000000000020bULL,
0x0000001a00000002ULL, 0x0000000000000111ULL, 0x0000001a00000002ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x00005800ff397624ULL, 0x000fe200078e00ffULL, 0x0000000000127806ULL, 0x000fe200038e0000ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000000839077824ULL, 0x000fe200078e00ffULL, 0x0000001200047300ULL, 0x000ee400000e0000ULL,
0x0000000000027919ULL, 0x000f280000002200ULL, 0x0000000000387919ULL, 0x000ee40000002600ULL,
0x0000001200127309ULL, 0x000ee40000000000ULL, 0x00000000003d7919ULL, 0x000ee80000002700ULL,
0x0000000000257919ULL, 0x000ee20000000000ULL, 0x00000005ff007819ULL, 0x002fc6000001160fULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x00001fff030d7589ULL, 0x0045e200000e0000ULL,
0x0000010003027a24ULL, 0x010fc600078e0202ULL, 0x00001fff00007589ULL, 0x000f2200000e0000ULL,
0x00000000020f7a24ULL, 0x000fe400078e020fULL, 0x0000000838067824ULL, 0x008fc600078e00ffULL,
0x000000ff0f00720cULL, 0x000fe20003f45270ULL, 0x0000003d07067224ULL, 0x000fe200078e0206ULL,
0x0000000f0f00780cULL, 0x040fe40003f64070ULL, 0x0000007f0f00780cULL, 0x040fe40003f84070ULL,
0x00000004ff0e7819ULL, 0x000fe40000011625ULL, 0x000000030f00780cULL, 0x000fe40003f24070ULL,
0x000000050400720cULL, 0x002fc60003f02070ULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x004fe400078e00ffULL, 0x000000040d087824ULL, 0x010fe400078e0200ULL,
0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL, 0x01760002ff00a388ULL, 0x0003e20000000a00ULL,
0x0000000208077824ULL, 0x000fe200078e00ffULL, 0x000000010f00780cULL, 0x000fe20003f44070ULL,
0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL, 0xff317217ff10c424ULL, 0x000fe200078e00ffULL,
0x00000008070a7817ULL, 0x040fe20007800000ULL, 0x3fffff60ff089424ULL, 0x000fe200078e00ffULL,
0x017608040f00b388ULL, 0x0005e20000008a00ULL, 0x7fffff60ff099424ULL, 0x000fe400078e00ffULL,
0x000000010a0c7824ULL, 0x000fe200078e0a07ULL, 0x017400100f00c388ULL, 0x000fe20000004800ULL,
0x00000001070a7824ULL, 0x000fe400078e020eULL, 0x0000001025077824ULL, 0x000fe200078e00ffULL,
0x0000000c0e00720cULL, 0x000fe20003f66070ULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x017688080f009388ULL, 0x0003e20000008a00ULL, 0x0000000106027824ULL, 0x000fe200078e020aULL,
0x000000f007117812ULL, 0x000fe200078ec0ffULL, 0x000000010a067824ULL, 0x000fc400078e0225ULL,
0x000000100a137824ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0003ULL,
0xfffffff0130c7812ULL, 0x000fe200078ee206ULL, 0x3fffff80ff049424ULL, 0x004fe200078e00ffULL,
0x0000001102027210ULL, 0x000fe20007f9e0ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x0176a8040f009388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fe400020e0603ULL,
0x000000100c097824ULL, 0x002fe200078e00ffULL, 0x0176c80a0f00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff087224ULL, 0x000fc400078e0a12ULL, 0x00000004ff067424ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000d901c46ULL, 0x000062003d047625ULL, 0x000fc600078e0006ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01760408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604027981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fc40003f05270ULL,
0x0000007f02037810ULL, 0x044fe40007ffe0ffULL, 0x000000ff02087810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff037819ULL, 0x000fe40000011603ULL, 0x00000008ff247819ULL, 0x000fca0000011608ULL,
0x0000f9d000008947ULL, 0x000fea0003800000ULL, 0x00000003ff547819ULL, 0x000fe20000011600ULL,
0x00000003ff0a7424ULL, 0x000fe200078e00ffULL, 0x0001768800097811ULL, 0x000fe200078e18ffULL,
0xffffffffff267424ULL, 0x000fe200078e00ffULL, 0x01ffffff54547812ULL, 0x000fc800078ec0ffULL,
0x000000035400720cULL, 0x000fda0003f06070ULL, 0x000000023d048824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640004058624ULL, 0x000fc800078e0205ULL,
0x0000000154058824ULL, 0x000fe200078e0205ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040a09ff738cULL, 0x0003e20000000000ULL, 0x0000600005048625ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000604268981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000008038387824ULL, 0x000fe200078e00ffULL,
0x00000001ff277819ULL, 0x000fe20000011600ULL, 0x0000000009ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000100067812ULL, 0x000fc600078ec0ffULL, 0x0000002027397824ULL, 0x000fca00078e00ffULL,
0x0000006038087812ULL, 0x000fe200078ef839ULL, 0x00005800260a7a24ULL, 0x006fc800078e02ffULL,
0x000000800a0f7824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000003902047217ULL, 0x008fe20007800000ULL, 0x0000001006057824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fe40000011625ULL, 0x0000007007177812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a39ULL, 0x00000004060b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105097824ULL, 0x000fe200078e0206ULL, 0x00000008060c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000504047217ULL, 0x000fe20007800000ULL, 0x00000001090a7824ULL, 0x000fc400078e0225ULL,
0x00000008090d7824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe400078e0a05ULL,
0x0000000108097824ULL, 0x000fe200078e0209ULL, 0xfffffff80d0a7812ULL, 0x000fe400078ee20aULL,
0x0000000c060d7810ULL, 0x000fe40007ffe0ffULL, 0x000000040b00720cULL, 0x080fe20003f46070ULL,
0x00000001050b7824ULL, 0x000fe200078e020bULL, 0x000000090f137210ULL, 0x000fe20007f1e0ffULL,
0x0000000105097824ULL, 0x040fe200078e020dULL, 0x000000040c00720cULL, 0x080fe20003f26070ULL,
0x00000001050c7824ULL, 0x000fe200078e020cULL, 0x000000040600720cULL, 0x000fe20003f66070ULL,
0x000000010b067824ULL, 0x000fe200078e0225ULL, 0x00005e0013147a11ULL, 0x000fe200078838ffULL,
0x000000080b117824ULL, 0x000fc400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x000000040d00720cULL, 0x000fe20003f06070ULL, 0x00000001080b7824ULL, 0x040fe200078e020bULL,
0xfffffff811067812ULL, 0x000fe200078ee206ULL, 0x0000000108047824ULL, 0x040fe200078e020cULL,
0x00005f0013137a11ULL, 0x000fe200020f3c0eULL, 0x0000000108087824ULL, 0x000fe200078e0209ULL,
0x0000000b0f127210ULL, 0x040fe20007f9e0ffULL, 0x000000010c057824ULL, 0x140fe200078e0225ULL,
0x000000040f0e7210ULL, 0x040fe20007fbe0ffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x000000080f0b7210ULL, 0x000fe20007fde0ffULL, 0x0000000109047824ULL, 0x000fc400078e0225ULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c087812ULL, 0x000fe200078ee205ULL,
0x000000ffff057224ULL, 0x000fe200020e06ffULL, 0x00005e0012107a11ULL, 0x040fe200078838ffULL,
0x000000ffff157224ULL, 0x000fe200028e06ffULL, 0x0001300027097811ULL, 0x000fe400078e68ffULL,
0xfffffff80d0c7812ULL, 0x000fe400078ee204ULL, 0x00005f0012127a11ULL, 0x000fe200020f3c05ULL,
0x0000001008117824ULL, 0x100fe200078e0209ULL, 0x0000001417047210ULL, 0x000fe20007f9e0ffULL,
0x000000100a0d7824ULL, 0x100fe200078e0209ULL, 0x00005e000e077a11ULL, 0x000fe200078a38ffULL,
0x000000ffff087224ULL, 0x000fe200030e06ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078c38ffULL,
0x00000010060f7824ULL, 0x000fc400078e0209ULL, 0x000000ffff057224ULL, 0x000fe200020e0613ULL,
0x0000001710067210ULL, 0x080fe20007f9e0ffULL, 0x000000100c137824ULL, 0x000fe200078e0209ULL,
0x00005f000e097a11ULL, 0x000fe400028f3c15ULL, 0x00005f000b0b7a11ULL, 0x000fe200030f3c08ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000d901c46ULL,
0x0000001707087210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200020e0612ULL,
0x000000170a0a7210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e0609ULL,
0x00000000060f7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff0b7224ULL, 0x000fc600020e060bULL,
0x0000000008117faeULL, 0x0003e8000c901c46ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001006047824ULL, 0x008fe200078e00ffULL,
0x0001300027137811ULL, 0x000fe400078e68ffULL, 0x0000007007157812ULL, 0x000fe400078ec0ffULL,
0x0000000425047211ULL, 0x000fc800078fe8ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104057824ULL, 0x140fe400078e0225ULL, 0x00000008040a7824ULL, 0x000fe400078e00ffULL,
0x0000000106097824ULL, 0x040fe400078e0225ULL, 0x00000008060c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a057812ULL, 0x000fe200078ee205ULL, 0x0000000108067824ULL, 0x000fe200078e0206ULL,
0x00000008040a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80c097812ULL, 0x000fe400078ee209ULL,
0x0000000c040c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108047824ULL, 0x040fe200078e0204ULL,
0x000000060f127210ULL, 0x040fe20007f5e0ffULL, 0x00000001080b7824ULL, 0x000fe400078e020aULL,
0x000000080a0d7824ULL, 0x040fe200078e00ffULL, 0x000000040f147210ULL, 0x040fe20007f3e0ffULL,
0x000000010a047824ULL, 0x000fe200078e0225ULL, 0x0000000b0f0e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000108087824ULL, 0x000fc400078e020cULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x00005e00140a7a11ULL, 0x000fe200078238ffULL, 0x000000010c067824ULL, 0x040fe200078e0225ULL,
0xfffffff80d047812ULL, 0x000fe200078ee204ULL, 0x00000010050d7824ULL, 0x000fe200078e0213ULL,
0x000000080f087210ULL, 0x000fe20007f1e0ffULL, 0x000000080c0f7824ULL, 0x000fe200078e00ffULL,
0x00005f0014147a11ULL, 0x000fe200008f3c0bULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x00005e0012107a11ULL, 0x000fe200078238ffULL, 0x0000001004117824ULL, 0x100fe200078e0213ULL,
0xfffffff80f067812ULL, 0x000fe200078ee206ULL, 0x00000010090f7824ULL, 0x000fe200078e0213ULL,
0x00005f0012077a11ULL, 0x000fe200008f3c05ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x00005e000e097a11ULL, 0x000fe200078438ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x0000000a15047210ULL, 0x000fe20007f3e0ffULL, 0x0000001006137824ULL, 0x000fe200078e0213ULL,
0x00005e00080a7a11ULL, 0x000fc400078638ffULL, 0x00005f000e0c7a11ULL, 0x000fe200010f3c05ULL,
0x000000ffff057224ULL, 0x000fe200008e0614ULL, 0x0000001015067210ULL, 0x040fe40007f1e0ffULL,
0x00005f00080b7a11ULL, 0x000fe400018f3c0bULL, 0x0000000915087210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000a150a7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e4000b901c46ULL,
0x000000ffff097224ULL, 0x000fc400008e060cULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x00000000060f7faeULL, 0x0003e8000b901c46ULL, 0x0000000008117faeULL, 0x0003e8000b901c46ULL,
0x000000000a137faeULL, 0x0003e4000b901c46ULL, 0x00000000270473c2ULL, 0x000ea200000e0000ULL,
0x000000ff2400720cULL, 0x000fe20003f05270ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x000176a827287811ULL, 0x000fe200078e18ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x000176a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff587f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200028287f8cULL, 0x000ea2000c80043fULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000deb000008947ULL, 0x000fea0003800000ULL, 0x000000023d3b7824ULL, 0x000fe400078e00ffULL,
0x00006400ff287624ULL, 0x004fc400078e00ffULL, 0x000000ffff2e7224ULL, 0x000fe400078e0029ULL,
0x000064003b3b7624ULL, 0x000fe400078e0228ULL, 0xff317217ff587424ULL, 0x002fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e00ffULL, 0x000001003c297824ULL, 0x000fca00078e00ffULL,
0x000000022900720cULL, 0x000fda0003f06070ULL, 0x0000ddc000000947ULL, 0x030fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fe400078e0054ULL, 0x000000ffff3d7224ULL, 0x000fc400078e0028ULL,
0x00000000002a7805ULL, 0x000fca0000015200ULL, 0x0000000400297824ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fc600078e00ffULL, 0xfffffff829307812ULL, 0x000fc800078ec0ffULL,
0x000176c8303f7810ULL, 0x000fe20007ffe0ffULL, 0x0176cc00302d7984ULL, 0x000e640000000800ULL,
0x800000002dff7812ULL, 0x002fe4000780482eULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a317210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09003100780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403100780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x000000312c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff2d7224ULL, 0x000fca00000e062dULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012f2f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176cc00302d7984ULL, 0x000e640000000800ULL, 0x800000002dff7812ULL, 0x002fe4000780482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010002a7824ULL, 0x000fe200078e00ffULL, 0x000000013c2d7810ULL, 0x000fe20007ffe0ffULL,
0x0000580026267a24ULL, 0x000fe200078e02ffULL, 0x0000000128407812ULL, 0x000fe400078e0cffULL,
0x000000242d00720cULL, 0x000fe20003f06070ULL, 0x0000008026437824ULL, 0x000fe200078e00ffULL,
0xffffffe02a2b7812ULL, 0x000fca00078ec0ffULL, 0x000001003c2b7824ULL, 0x000fca00078e022bULL,
0x000000402b2b7810ULL, 0x000fc80007ffe0ffULL, 0x0000006038417812ULL, 0x000fe200078ef82bULL,
0x0000049000008947ULL, 0x000fea0003800000ULL, 0x000000102a2d7812ULL, 0x000fe200078ec0ffULL,
0x00000002272f7824ULL, 0x000fe200078e0240ULL, 0x00000003ff347819ULL, 0x000fc80000011625ULL,
0x0000000434327810ULL, 0x040fe20007ffe0ffULL, 0x00000001342a7824ULL, 0x140fe200078e022dULL,
0x000130002f2f7811ULL, 0x000fe400078e60ffULL, 0x0000000834377810ULL, 0x000fe20007ffe0ffULL,
0x0000000141267824ULL, 0x000fe400078e022aULL, 0x00000001322e7824ULL, 0x000fe400078e022dULL,
0x000000082a427824ULL, 0x000fe200078e00ffULL, 0x0000002643317210ULL, 0x000fe20007f1e0ffULL,
0x000000082e457824ULL, 0x000fe200078e00ffULL, 0x0000002b02267217ULL, 0x000fc60007800000ULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078038ffULL,
0x0000000126267824ULL, 0x000fe400078e0a2bULL, 0x00000010252b7824ULL, 0x000fe200078e00ffULL,
0x00005f0031317a11ULL, 0x000fe200000f3c2cULL, 0x00000001412c7824ULL, 0x000fe200078e022eULL,
0x0000002d26267217ULL, 0x000fe40007800000ULL, 0x000000702b367812ULL, 0x000fe200078ec0ffULL,
0x000000012a2b7824ULL, 0x000fe200078e0225ULL, 0x0000002c43357210ULL, 0x000fe20007fde0ffULL,
0x0000000126267824ULL, 0x000fe200078e0a2dULL, 0x00000036302a7210ULL, 0x000fc40007fbe0ffULL,
0xfffffff8422c7812ULL, 0x000fe200078ee22bULL, 0x000000ffff307224ULL, 0x000fe200030e06ffULL,
0x000000263400720cULL, 0x080fe20003f06070ULL, 0x000000ffff2b7224ULL, 0x000fe200028e0631ULL,
0x00005e0035337a11ULL, 0x000fe200078c38ffULL, 0x000000102c317824ULL, 0x000fe200078e022fULL,
0x000000263200720cULL, 0x000fe20003fa6070ULL, 0x0000000137327824ULL, 0x000fe200078e022dULL,
0x00005f0035357a11ULL, 0x000fe200030f3c30ULL, 0x000000012e307824ULL, 0x000fe200078e0225ULL,
0x0000000c34427810ULL, 0x000fe20007ffe0ffULL, 0x00000001412e7824ULL, 0x000fc600078e0232ULL,
0xfffffff845307812ULL, 0x000fe200078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a317faeULL, 0x0003e2000c101c46ULL, 0x00000036332c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000142347824ULL, 0x000fe200078e022dULL, 0x0000002e432e7210ULL, 0x000fc60007fde0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e0635ULL, 0x000000263700720cULL, 0x000fe20003f06070ULL,
0x000000ffff337224ULL, 0x000fe400030e06ffULL, 0x0000000832357824ULL, 0x000fe400078e00ffULL,
0x0000001030317824ULL, 0x002fe400078e022fULL, 0x00000001412a7824ULL, 0x000fc600078e0234ULL,
0x000000002c317faeULL, 0x0003e2000e901c46ULL, 0x00005e002e2b7a11ULL, 0x040fe400078a38ffULL,
0x0000002a43307210ULL, 0x000fe40007fde0ffULL, 0x00005f002e2e7a11ULL, 0x000fe400028f3c33ULL,
0x000000264200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff337224ULL, 0x000fe200030e06ffULL,
0x000000362b2a7210ULL, 0x000fe20007fde0ffULL, 0x0000000132267824ULL, 0x000fc400078e0225ULL,
0x00000001342d7824ULL, 0x002fe400078e0225ULL, 0x000000ffff2b7224ULL, 0x000fe200030e062eULL,
0x00005e00302c7a11ULL, 0x000fe200078c38ffULL, 0x00000008342e7824ULL, 0x000fe200078e00ffULL,
0xfffffff835267812ULL, 0x000fe400078ee226ULL, 0x00005f0030307a11ULL, 0x000fe400030f3c33ULL,
0x000000362c2c7210ULL, 0x000fe20007fde0ffULL, 0x0000001026317824ULL, 0x000fe200078e022fULL,
0xfffffff82e2e7812ULL, 0x000fc600078ee22dULL, 0x000000ffff2d7224ULL, 0x000fe200030e0630ULL,
0x000000002a317faeULL, 0x0003e2000c101c46ULL, 0x000000102e2f7824ULL, 0x000fca00078e022fULL,
0x000000002c2f7faeULL, 0x0003e2000e901c46ULL, 0x000003c000007947ULL, 0x000fea0003800000ULL,
0x000000102a267812ULL, 0x000fc800078ec0ffULL, 0x0000002625267211ULL, 0x000fc800078fe8ffULL,
0x00000004262c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001412a7824ULL, 0x000fe400078e0226ULL,
0x00000001262b7824ULL, 0x140fe400078e0225ULL, 0x00000008262e7824ULL, 0x000fe200078e00ffULL,
0x0000002a43377210ULL, 0x000fe20007f1e0ffULL, 0x000000012c2d7824ULL, 0x000fe200078e0225ULL,
0x00000008262a7810ULL, 0x000fe20007ffe0ffULL, 0x000000082c307824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2f7812ULL, 0x000fe200078ee22bULL, 0x00000001412c7824ULL, 0x040fe200078e022cULL,
0x0000000c262e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000141267824ULL, 0x000fe200078e022aULL,
0xfffffff830317812ULL, 0x000fe200078ee22dULL, 0x000000082a2d7824ULL, 0x040fe200078e00ffULL,
0x0000002c43337210ULL, 0x000fe20007fde0ffULL, 0x00000001412b7824ULL, 0x000fe200078e022eULL,
0x0000002643367210ULL, 0x000fe20007fbe0ffULL, 0x000000012a267824ULL, 0x000fc400078e0225ULL,
0x000000012e2a7824ULL, 0x040fe400078e0225ULL, 0x000000082e417824ULL, 0x000fe200078e00ffULL,
0xfffffff82d267812ULL, 0x000fe200078ee226ULL, 0x000000ffff307224ULL, 0x000fe200000e06ffULL,
0x00005e0037357a11ULL, 0x000fe200078038ffULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0x00005e00332c7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff2d7224ULL, 0x000fe200028e06ffULL,
0xfffffff841327812ULL, 0x000fe200078ee22aULL, 0x00000010252a7824ULL, 0x000fe200078e00ffULL,
0x00005f0037377a11ULL, 0x000fc400000f3c30ULL, 0x00005f0033337a11ULL, 0x000fe400030f3c2eULL,
0x0000002b432b7210ULL, 0x000fe40007f1e0ffULL, 0x00005e00362e7a11ULL, 0x000fe400078a38ffULL,
0x000000702a417812ULL, 0x000fe200078ec0ffULL, 0x000000ffff347224ULL, 0x000fe200000e06ffULL,
0x00005f0036367a11ULL, 0x000fe200028f3c2dULL, 0x00000002272d7824ULL, 0x000fe200078e0240ULL,
0x00005e002b307a11ULL, 0x000fc400078c38ffULL, 0x00000041352a7210ULL, 0x080fe40007f1e0ffULL,
0x000000412c2c7210ULL, 0x080fe40007fbe0ffULL, 0x00005f002b347a11ULL, 0x000fe200030f3c34ULL,
0x000000ffff2b7224ULL, 0x000fe200000e0637ULL, 0x000130002d427811ULL, 0x000fe200078e60ffULL,
0x000000ffff2d7224ULL, 0x000fe200028e0633ULL, 0x000000412e2e7210ULL, 0x080fe40007f1e0ffULL,
0x0000004130307210ULL, 0x000fe20007fbe0ffULL, 0x000000102f337824ULL, 0x000fc400078e0242ULL,
0x0000001031357824ULL, 0x100fe400078e0242ULL, 0x0000001026377824ULL, 0x000fe200078e0242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a337faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2f7224ULL, 0x000fe400000e0636ULL, 0x0000001032417824ULL, 0x000fe200078e0242ULL,
0x000000002c357faeULL, 0x0003e2000b901c46ULL, 0x000000ffff317224ULL, 0x000fc600028e0634ULL,
0x000000002e377faeULL, 0x0003e8000b901c46ULL, 0x0000000030417faeULL, 0x0003e4000b901c46ULL,
0x00000008002c7824ULL, 0x002fe200078e00ffULL, 0x0000000154267810ULL, 0x000fc80007ffe0ffULL,
0xfffffff02c417812ULL, 0x000fe400078ec0ffULL, 0x000000032600720cULL, 0x000fe20003f06070ULL,
0xffffffffff267424ULL, 0x000fe400078e00ffULL, 0x0000000840417824ULL, 0x000fca00078e0241ULL,
0x0000000000007918ULL, 0x000fea0000000000ULL, 0x000000013b2a8810ULL, 0x000fe20007ffe054ULL,
0x00000004ff2b8424ULL, 0x000fe200078e00ffULL, 0xffffffe02c427812ULL, 0x040fe400078ec0ffULL,
0x000000102c2d7812ULL, 0x000fe200078ec0ffULL, 0x000060002a2a8625ULL, 0x000fe200078e002bULL,
0x000000082c2c7812ULL, 0x000fe200078ec0ffULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000176a841437810ULL, 0x000fc40007ffe0ffULL, 0x000000062a268981ULL, 0x000322000c1e1900ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x000000422c427210ULL, 0x000fd60007ffe02dULL,
0x00000000430403c2ULL, 0x000ea40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80041527f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760800422e7f8cULL, 0x0002a4000c80043fULL,
0x00000000002a7805ULL, 0x002fc40000015200ULL, 0x01760c00422d7984ULL, 0x000e640000000800ULL,
0x800000002dff7812ULL, 0x006fc4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a317210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09003100780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403100780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x000000312c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff2d7224ULL, 0x000fca00000e062dULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000130307810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760c00422d7984ULL, 0x000e640000000800ULL, 0x800000002dff7812ULL, 0x002fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010252a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff457819ULL, 0x000fe20000011625ULL, 0x0000002000447824ULL, 0x000fc600078e00ffULL,
0x000000702a357812ULL, 0x000fe400078ec0ffULL, 0xffffff8044447812ULL, 0x000fe400078ec0ffULL,
0x0000000c45457812ULL, 0x000fc800078ec0ffULL, 0x00000044452a7210ULL, 0x000fca0007ffe035ULL,
0x017000002a2d7984ULL, 0x000e680000000800ULL, 0x017200002a2f7984ULL, 0x0004e20000000800ULL,
0x000000582d00720bULL, 0x002fe20003f1d000ULL, 0x00015a827f007947ULL, 0x000fd8000b800000ULL,
0x00000000002a7806ULL, 0x004fc800000e0100ULL, 0x0000ffff2a337812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff517224ULL, 0x000fd200078e0058ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x00000002ff2b7819ULL, 0x000fe40000011600ULL, 0x000000582d00720bULL, 0x000fe40003f14000ULL,
0x000000002b00720cULL, 0x000fe20003fa5270ULL, 0x00015a427f007947ULL, 0x000fd4000b800000ULL,
0x00000000002c7806ULL, 0x000fc400000e0100ULL, 0x00000080002ad824ULL, 0x000fe200078e0235ULL,
0x0000002d58517209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099102c2b7816ULL, 0x000fe200000000ffULL, 0x00000001452ad824ULL, 0x000fc600078e022aULL,
0x000000ff2b00720cULL, 0x000fe40003f05270ULL, 0x017400512a00d388ULL, 0x0003f60000000800ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x80000051582a7221ULL, 0x002fe20000010000ULL,
0x000000ff2cff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b2a2a7820ULL, 0x000fc80000410000ULL, 0x0000002a00357308ULL, 0x0002ac0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff2a7819ULL, 0x002fe20000011625ULL,
0x000159927f007947ULL, 0x000fea000b800000ULL, 0x00001f2a352a7589ULL, 0x0042a400000e0000ULL,
0x0000002a04047220ULL, 0x084fe40000410000ULL, 0x0000002a05057220ULL, 0x080fe40000410000ULL,
0x0000002a08087220ULL, 0x000fc40000410000ULL, 0x0000002a09097220ULL, 0x080fe40000410000ULL,
0x0000002a0c0c7220ULL, 0x080fe40000410000ULL, 0x0000002a0d0d7220ULL, 0x080fe40000410000ULL,
0x0000002a10107220ULL, 0x080fe40000410000ULL, 0x0000002a11117220ULL, 0x080fe40000410000ULL,
0x0000002a14147220ULL, 0x000fc40000410000ULL, 0x0000002a15157220ULL, 0x080fe40000410000ULL,
0x0000002a18187220ULL, 0x080fe40000410000ULL, 0x0000002a19197220ULL, 0x080fe40000410000ULL,
0x0000002a1c1c7220ULL, 0x080fe40000410000ULL, 0x0000002a1d1d7220ULL, 0x080fe40000410000ULL,
0x0000002a20207220ULL, 0x000fc40000410000ULL, 0x0000002a21217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff002cff7812ULL, 0x000fe2000780c0ffULL,
0x000000353a3a7220ULL, 0x004fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008252a7811ULL, 0x002fe200078ff0ffULL, 0x000158927f007947ULL, 0x000fea000b800000ULL,
0x00001f2a352a7589ULL, 0x0002a400000e0000ULL, 0x0000002a06067220ULL, 0x084fe40000410000ULL,
0x0000002a07077220ULL, 0x080fe40000410000ULL, 0x0000002a0a0a7220ULL, 0x080fe40000410000ULL,
0x0000002a0b0b7220ULL, 0x080fe40000410000ULL, 0x0000002a0e0e7220ULL, 0x080fe40000410000ULL,
0x0000002a0f0f7220ULL, 0x000fc40000410000ULL, 0x0000002a12127220ULL, 0x080fe40000410000ULL,
0x0000002a13137220ULL, 0x080fe40000410000ULL, 0x0000002a16167220ULL, 0x080fe40000410000ULL,
0x0000002a17177220ULL, 0x080fe40000410000ULL, 0x0000002a1a1a7220ULL, 0x080fe40000410000ULL,
0x0000002a1b1b7220ULL, 0x000fc40000410000ULL, 0x0000002a1e1e7220ULL, 0x080fe40000410000ULL,
0x0000002a1f1f7220ULL, 0x080fe40000410000ULL, 0x0000002a22227220ULL, 0x080fe40000410000ULL,
0x0000002a23237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fda000780602cULL, 0x800000512d2d0221ULL, 0x000fe20000010000ULL,
0x00007610ff2e0816ULL, 0x000fc6000000002eULL, 0x3fb8aa3b2d2d0820ULL, 0x000fc80000410000ULL,
0x0000002d00460308ULL, 0x000e640000000800ULL, 0x000000462f2f0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003a2f3a7221ULL, 0x008fc40000010000ULL,
0x00000000002a7805ULL, 0x000fca0000015200ULL, 0x00000002272c7824ULL, 0x000fc800078e0228ULL,
0x000000082c307824ULL, 0x000fca00078e00ffULL, 0x0176ac00302c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x0000002f2c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff2d7224ULL, 0x000fca00000e062dULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000131317810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac00302c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099102e2a7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff2a00720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000046ff2a723eULL, 0x000fe400000010ffULL,
0x00000002ff2c7819ULL, 0x000fe40000011625ULL, 0x000054102a2d7816ULL, 0x000fe2000000002aULL,
0x000154927f007947ULL, 0x000fea000b800000ULL, 0x00001f2c2d477589ULL, 0x0002a400000e0000ULL,
0x000000082c487810ULL, 0x000fe20007ffe0ffULL, 0x000154e27f007947ULL, 0x000fea000b800000ULL,
0x00001f482d487589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000102c2a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e002dULL,
0x00002b4000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x0001624000007944ULL, 0x01efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000182c2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x004fe200078e002dULL, 0x00002bb000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x000161d000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000725867812ULL, 0x000fe200078ec0ffULL, 0x00000002005a7824ULL, 0x040fe200078e00ffULL,
0x00000004ff887819ULL, 0x100fe20000011625ULL, 0x00000200004f7824ULL, 0x000fe200078e00ffULL,
0x0000000886867812ULL, 0x000fe200078ef825ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000045a2b7812ULL, 0x000fe400078ec0ffULL, 0xfffff8004f4f7812ULL, 0x000fe200078ec0ffULL,
0x00000008862a7824ULL, 0x040fe200078e00ffULL, 0x0000002b862b7210ULL, 0x000fc40007ffe088ULL,
0x00000008254a7812ULL, 0x000fe400078ec0ffULL, 0xfffffff82a2a7812ULL, 0x000fca00078ee22bULL,
0x000000102a497824ULL, 0x000fc400078e024fULL, 0x0000000429297812ULL, 0x000fe200078ec0ffULL,
0x0000000227567824ULL, 0x000fe200078e0228ULL, 0x000000074a4a7812ULL, 0x000fc600078ef825ULL,
0x00000001884b7824ULL, 0x000fe200078e0229ULL, 0x0001300056567811ULL, 0x000fe200078e60ffULL,
0x000000084a297824ULL, 0x040fe200078e00ffULL, 0x000000104a2e7812ULL, 0x040fe200078efcffULL,
0x000000014a287824ULL, 0x040fe400078e024bULL, 0x000000084a2c7824ULL, 0x002fe400078e00ffULL,
0x000000014b2d7824ULL, 0x008fe200078e022eULL, 0xfffffff829297812ULL, 0x000fe200078ee228ULL,
0x000000082e4c7824ULL, 0x000fe200078e00ffULL, 0x00000002284d7810ULL, 0x000fc40007ffe0ffULL,
0x000000022d4e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001029297824ULL, 0x100fe200078e0256ULL,
0xfffffff82c4d7812ULL, 0x000fe400078ee24dULL, 0xfffffff84c4c7812ULL, 0x000fe400078ee22dULL,
0x000000002934783bULL, 0x000e620000004200ULL, 0x000000104d2c7824ULL, 0x100fe400078e0256ULL,
0x000000104c307824ULL, 0x004fcc00078e0256ULL, 0x000000003030783bULL, 0x000ea20000004200ULL,
0x0000010034657824ULL, 0x002fe200078e00ffULL, 0x0000003400a77306ULL, 0x000fe20000009400ULL,
0x00000018ff297819ULL, 0x000fe20000011434ULL, 0x0000010035677824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe40000011435ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000003400aa7306ULL, 0x000e620000005400ULL,
0x00000018ff2b7819ULL, 0x000fc40000011436ULL, 0x00000018ff507819ULL, 0x000fe40000011437ULL,
0x00000018ff557819ULL, 0x004fe40000011430ULL, 0x00000018ff587819ULL, 0x000fe20000011433ULL,
0x0000006500ab7306ULL, 0x000ff00000209400ULL, 0x0000006500ae7306ULL, 0x000ea20000205400ULL,
0x000000aaa700720bULL, 0x002fce0003fbd000ULL, 0x00000034007f7306ULL, 0x0002f0000000d400ULL,
0x0000006500927306ULL, 0x0006e2000020d400ULL, 0x0001000034347824ULL, 0x002fe200078e00ffULL,
0x000000aeab00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000002900ac7306ULL, 0x000fe20000209400ULL, 0x000000017f7f5812ULL, 0x008fe200078efcffULL,
0x0000010036657824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000002900a97306ULL, 0x000e620000205400ULL, 0x0000000192926812ULL, 0x000fce00078efcffULL,
0x0000003400b17306ULL, 0x000ff00000209400ULL, 0x0000003400b47306ULL, 0x000ea20000205400ULL,
0x000000a9ac00720bULL, 0x002fe20003fbd000ULL, 0x0000010033a97824ULL, 0x000fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114a9ULL, 0x00000029007e7306ULL, 0x0002f0000020d400ULL,
0x0000003400917306ULL, 0x0006e2000020d400ULL, 0x000000b4b100720bULL, 0x004fe20003fdd000ULL,
0x000000082e297824ULL, 0x002fc400078e00ffULL, 0x000000002c2c783bULL, 0x000e660000004200ULL,
0xfffffff8294e7812ULL, 0x000fe200078ee24eULL, 0x0000003500997306ULL, 0x000fe20000009400ULL,
0x000000017e7e5812ULL, 0x008fe200078efcffULL, 0x0000010037347824ULL, 0x000fe400078e00ffULL,
0x000000104e287824ULL, 0x000fe200078e0256ULL, 0x00000018ff567819ULL, 0x000fe40000011431ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x00000035006a7306ULL, 0x000ea20000005400ULL,
0x0000000191916812ULL, 0x000fce00078efcffULL, 0x0000006700bf7306ULL, 0x000ff00000209400ULL,
0x0000006700c27306ULL, 0x000ee20000205400ULL, 0x0000006a9900720bULL, 0x004fce0003fbd000ULL,
0x0000003500687306ULL, 0x000470000000d400ULL, 0x0000006700957306ULL, 0x000e62000020d400ULL,
0x0001000035357824ULL, 0x004fe200078e00ffULL, 0x000000c2bf00720bULL, 0x008fc80003fdd000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000002a009a7306ULL, 0x000fe20000209400ULL,
0x0000000168685812ULL, 0x002fce00078efcffULL, 0x0000002a006d7306ULL, 0x000e620000205400ULL,
0x0000000195956812ULL, 0x000fce00078efcffULL, 0x0000003500c17306ULL, 0x000ff00000209400ULL,
0x0000003500c47306ULL, 0x000ea20000205400ULL, 0x0000006d9a00720bULL, 0x002fce0003fbd000ULL,
0x0000002a00697306ULL, 0x000e70000020d400ULL, 0x0000003500947306ULL, 0x0006e2000020d400ULL,
0x000000c4c100720bULL, 0x004fce0003fdd000ULL, 0x0000003600977306ULL, 0x000fe20000009400ULL,
0x0000000169695812ULL, 0x002fe400078efcffULL, 0x00000018ff357819ULL, 0x008fca000001142cULL,
0x00000036006e7306ULL, 0x000e620000005400ULL, 0x0000000194946812ULL, 0x000fc800078efcffULL,
0x000000946969723eULL, 0x000fc600000010ffULL, 0x0000006500c37306ULL, 0x000ff00000209400ULL,
0x0000006500c67306ULL, 0x000ea20000205400ULL, 0x0000006e9700720bULL, 0x002fce0003fbd000ULL,
0x00000036007b7306ULL, 0x0002f0000000d400ULL, 0x0000006500967306ULL, 0x000ee2000020d400ULL,
0x0001000036367824ULL, 0x002fe200078e00ffULL, 0x000000c6c300720bULL, 0x004fc80003fdd000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000002b00737306ULL, 0x000fe20000209400ULL,
0x000000017b7b5812ULL, 0x008fce00078efcffULL, 0x0000002b00bc7306ULL, 0x000e620000205400ULL,
0x0000000196966812ULL, 0x000fce00078efcffULL, 0x0000003600c57306ULL, 0x000ff00000209400ULL,
0x0000003600c87306ULL, 0x000ea20000205400ULL, 0x000000bc7300720bULL, 0x002fce0003fbd000ULL,
0x00000037009c7306ULL, 0x000ff00000009400ULL, 0x0000003700b77306ULL, 0x000fe20000005400ULL,
0x000000c8c500720bULL, 0x004fce0003fdd000ULL, 0x0000003700797306ULL, 0x0003f0000000d400ULL,
0x0000003500c07306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x002fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003500bd7306ULL, 0x000ff00000205400ULL,
0x0000003500757306ULL, 0x0003f0000020d400ULL, 0x0000003000987306ULL, 0x000fe20000009400ULL,
0x0000010030357824ULL, 0x002fca00078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011435ULL,
0x0000010031357824ULL, 0x000fe200078e00ffULL, 0x0000003000937306ULL, 0x000ff00000005400ULL,
0x0000003000647306ULL, 0x0003f0000000d400ULL, 0x0000002b00787306ULL, 0x0004e2000020d400ULL,
0x0001000030307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003600857306ULL, 0x000262000020d400ULL, 0x000000002828783bULL, 0x004eae0000004200ULL,
0x0000003400c77306ULL, 0x000fe20000209400ULL, 0x0000000178785812ULL, 0x008fc400078efcffULL,
0x000000b79c00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff367819ULL, 0x002fc6000001142dULL,
0x0000003400ca7306ULL, 0x000e620000205400ULL, 0x0000000185856812ULL, 0x000fc800078efcffULL,
0x000000857878723eULL, 0x000fc600000010ffULL, 0x00000034008e7306ULL, 0x0006a2000020d400ULL,
0x0000000179795812ULL, 0x000fce00078efcffULL, 0x0000003700c97306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x008fe4000001142eULL, 0x000000cac700720bULL, 0x002fca0003fdd000ULL,
0x0000003700cc7306ULL, 0x000e620000205400ULL, 0x00000018ffbf7819ULL, 0x004fe40000011428ULL,
0x00000018ffc17819ULL, 0x000fca0000011429ULL, 0x0000003700877306ULL, 0x0004e2000020d400ULL,
0x000000018e8e6812ULL, 0x000fce00078efcffULL, 0x0000003400b87306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x004fe4000001142fULL, 0x000000ccc900720bULL, 0x002fca0003fdd000ULL,
0x0000003400b37306ULL, 0x000ff00000205400ULL, 0x00000034006b7306ULL, 0x000fe2000020d400ULL,
0x0000000187876812ULL, 0x008fce00078efcffULL, 0x0000003000a37306ULL, 0x000ff00000209400ULL,
0x0000003000a67306ULL, 0x000ff00000205400ULL, 0x0000003000347306ULL, 0x0003f0000020d400ULL,
0x0000003700b67306ULL, 0x000fe20000209400ULL, 0x0000010032307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003700af7306ULL, 0x000ff00000205400ULL,
0x0000003700657306ULL, 0x0003f0000020d400ULL, 0x0000005000b27306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x002fce0000011435ULL, 0x0000005000b57306ULL, 0x000e700000205400ULL,
0x00000050007a7306ULL, 0x0004f0000020d400ULL, 0x0000003100897306ULL, 0x000fe20000009400ULL,
0x00000018ff507819ULL, 0x004fc40000011432ULL, 0x000000b5b200720bULL, 0x002fca0003fbd000ULL,
0x0000003100847306ULL, 0x000ff00000005400ULL, 0x0000003100607306ULL, 0x0003e2000000d400ULL,
0x000000017a7a5812ULL, 0x008fce00078efcffULL, 0x0000003200827306ULL, 0x000fe20000009400ULL,
0x0001000031317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003200837306ULL, 0x000ff00000005400ULL, 0x00000032005e7306ULL, 0x0003f0000000d400ULL,
0x0000003700a47306ULL, 0x000fe20000209400ULL, 0x0001000032327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003700a17306ULL, 0x000ff00000205400ULL,
0x0000003700357306ULL, 0x000ff0000020d400ULL, 0x0000003000aa7306ULL, 0x000ff00000209400ULL,
0x0000003000a77306ULL, 0x000ff00000205400ULL, 0x0000003000377306ULL, 0x0003f0000020d400ULL,
0x0000003300807306ULL, 0x000fe20000009400ULL, 0x000001002c307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003300817306ULL, 0x000ff00000005400ULL,
0x0000003300597306ULL, 0x0003f0000000d400ULL, 0x0000003600be7306ULL, 0x000fe20000209400ULL,
0x0001000033337824ULL, 0x002fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003600bb7306ULL, 0x000ff00000205400ULL, 0x0000003600707306ULL, 0x000ff0000020d400ULL,
0x0000009f00ad7306ULL, 0x000ff00000209400ULL, 0x0000009f00b07306ULL, 0x000ff00000205400ULL,
0x0000009f00677306ULL, 0x000ff0000020d400ULL, 0x0000003100a27306ULL, 0x000ff00000209400ULL,
0x00000031009f7306ULL, 0x000ff00000205400ULL, 0x0000003100367306ULL, 0x000ff0000020d400ULL,
0x0000003200b17306ULL, 0x000ff00000209400ULL, 0x0000003200b47306ULL, 0x000ff00000205400ULL,
0x00000032006d7306ULL, 0x000ff0000020d400ULL, 0x0000002c00ba7306ULL, 0x000ff00000009400ULL,
0x0000002c00b97306ULL, 0x000e700000005400ULL, 0x0000003000317306ULL, 0x000ff00000209400ULL,
0x0000003000327306ULL, 0x000ea20000205400ULL, 0x000000b9ba00720bULL, 0x002fce0003fbd000ULL,
0x000000ab00ac7306ULL, 0x000ff00000209400ULL, 0x000000ab00a97306ULL, 0x000fe20000205400ULL,
0x000000323100720bULL, 0x004fce0003fdd000ULL, 0x000000ab006a7306ULL, 0x000ff0000020d400ULL,
0x0000003300ae7306ULL, 0x000ff00000209400ULL, 0x0000003300ab7306ULL, 0x000ff00000205400ULL,
0x00000033006e7306ULL, 0x0003f0000020d400ULL, 0x0000002c00717306ULL, 0x0004e2000000d400ULL,
0x000001002d337824ULL, 0x002fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003000b27306ULL, 0x000e62000020d400ULL, 0x000100002c2c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002d00a87306ULL, 0x000fe20000009400ULL,
0x0000000171715812ULL, 0x008fce00078efcffULL, 0x0000002d00a57306ULL, 0x000ea20000005400ULL,
0x00000001b2b26812ULL, 0x002fce00078efcffULL, 0x0000003300b77306ULL, 0x000ff00000209400ULL,
0x0000003300bc7306ULL, 0x000e620000205400ULL, 0x000000a5a800720bULL, 0x004fce0003fbd000ULL,
0x0000002d00727306ULL, 0x0004f0000000d400ULL, 0x0000003300b57306ULL, 0x000ee2000020d400ULL,
0x000000bcb700720bULL, 0x002fe20003fdd000ULL, 0x000100002d2d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000002c00307306ULL, 0x000fe20000209400ULL,
0x0000000172725812ULL, 0x008fe400078efcffULL, 0x000000bdc000720bULL, 0x000fca0003fbd000ULL,
0x0000002c00317306ULL, 0x000e620000205400ULL, 0x00000001b5b56812ULL, 0x000fc800078efcffULL,
0x00000072b5b5723eULL, 0x000fc600000010ffULL, 0x0000002c00a87306ULL, 0x000ea2000020d400ULL,
0x0000000175755812ULL, 0x000fe400078efcffULL, 0x000000bbbe00720bULL, 0x000fca0003fbd000ULL,
0x0000002d00327306ULL, 0x000fe20000209400ULL, 0x000000313000720bULL, 0x002fe20003fdd000ULL,
0x000001002e307824ULL, 0x000fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000002d00337306ULL, 0x000e620000205400ULL, 0x0000000170705812ULL, 0x000fca00078efcffULL,
0x00000001a8a86812ULL, 0x004fe400078efcffULL, 0x0000002d00a57306ULL, 0x000eb0000020d400ULL,
0x0000002e00a07306ULL, 0x000fe20000009400ULL, 0x000000333200720bULL, 0x002fe20003fdd000ULL,
0x000001002f327824ULL, 0x000fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000002e009d7306ULL, 0x000e6c0000005400ULL, 0x00000001a5a56812ULL, 0x004fe400078efcffULL,
0x00000030002c7306ULL, 0x000fe40000209400ULL, 0x000000a570a5723eULL, 0x000fcc00000010ffULL,
0x0000003000317306ULL, 0x000ea20000205400ULL, 0x0000009da000720bULL, 0x002fce0003fbd000ULL,
0x0000002e006c7306ULL, 0x0002f0000000d400ULL, 0x0000003000b77306ULL, 0x000ee2000020d400ULL,
0x000000312c00720bULL, 0x004fe20003fdd000ULL, 0x000100002e2e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000002f009e7306ULL, 0x000fe20000009400ULL,
0x000000016c6c5812ULL, 0x008fce00078efcffULL, 0x0000002f009b7306ULL, 0x000e620000005400ULL,
0x00000001b7b76812ULL, 0x000fce00078efcffULL, 0x0000003200337306ULL, 0x000ff00000209400ULL,
0x0000003200ba7306ULL, 0x000ea20000205400ULL, 0x0000009b9e00720bULL, 0x002fce0003fbd000ULL,
0x0000002f00667306ULL, 0x0002f0000000d400ULL, 0x0000003200b97306ULL, 0x000ee2000020d400ULL,
0x000000ba3300720bULL, 0x004fe20003fdd000ULL, 0x000100002f2f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002e002c7306ULL, 0x000fe20000209400ULL,
0x0000000166665812ULL, 0x008fe400078efcffULL, 0x000000b3b800720bULL, 0x000fca0003fbd000ULL,
0x0000002e002d7306ULL, 0x000e620000205400ULL, 0x00000001b9b96812ULL, 0x000fce00078efcffULL,
0x0000002e00ba7306ULL, 0x0004e2000020d400ULL, 0x000000016b6b5812ULL, 0x000fe400078efcffULL,
0x000000afb600720bULL, 0x000fe40003fbd000ULL, 0x00000018ffaf7819ULL, 0x000fc6000001142bULL,
0x0000002f00307306ULL, 0x000fe20000209400ULL, 0x0000002d2c00720bULL, 0x002fe20003fdd000ULL,
0x00000004272d7824ULL, 0x000fe200078e0288ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142aULL,
0x00000100282e7824ULL, 0x004fc600078e00ffULL, 0x000000022d2d7810ULL, 0x000fe20007ffe086ULL,
0x0000002f00317306ULL, 0x000e620000205400ULL, 0x0000000165655812ULL, 0x000fe200078efcffULL,
0x0000000886867824ULL, 0x000fe200078e00ffULL, 0x000000939800720bULL, 0x000fc60003fbd000ULL,
0x00000001baba6812ULL, 0x008fe400078efcffULL, 0x0000002f00b87306ULL, 0x000ea4000020d400ULL,
0x000000ba6bba723eULL, 0x000fe400000010ffULL, 0x000000313000720bULL, 0x002fc80003fdd000ULL,
0x0000005500907306ULL, 0x000fe20000209400ULL, 0x0000000164645812ULL, 0x000fe200078efcffULL,
0x011000004930783bULL, 0x000e6c0000000200ULL, 0x00000055008f7306ULL, 0x000ee20000205400ULL,
0x00000001b8b86812ULL, 0x004fe400078efcffULL, 0x000000b0ad00720bULL, 0x000fca0003fdd000ULL,
0x0000002c00a07306ULL, 0x000fe20000209400ULL, 0x00000018ffad7819ULL, 0x000fce000001142eULL,
0x0000002c009d7306ULL, 0x000fe20000205400ULL, 0x0000008f9000720bULL, 0x008fe20003fbd000ULL,
0x00000100298f7824ULL, 0x000fe200078e00ffULL, 0x0000000167676812ULL, 0x000fe400078efcffULL,
0x000000a6a300720bULL, 0x000fe40003fdd000ULL, 0x00000018ffa37819ULL, 0x000fe2000001148fULL,
0x0000002c009e7306ULL, 0x0005e2000020d400ULL, 0x000000646764723eULL, 0x000fce00000010ffULL,
0x0000005500617306ULL, 0x000ee2000020d400ULL, 0xfffffff8862c7812ULL, 0x004fe200078ee22dULL,
0x0000004730308231ULL, 0x082fe200003400ffULL, 0x0000000134346812ULL, 0x000fe200078efcffULL,
0x0000004732328231ULL, 0x000fe200003400ffULL, 0x000000a1a400720bULL, 0x000fe20003fdd000ULL,
0x000000102c4f7824ULL, 0x000fe200078e024fULL, 0x0000004831318231ULL, 0x080fe200003400ffULL,
0x00000056008d7306ULL, 0x000fe20000209400ULL, 0x0000004833338231ULL, 0x000fe200003400ffULL,
0x000000a875a4723eULL, 0x000fe200000010ffULL, 0x011000004f2c783bULL, 0x000e6a0000000200ULL,
0x00000056008c7306ULL, 0x000ea20000205400ULL, 0x0000000161615812ULL, 0x008fe200078efcffULL,
0x000000a43018723cULL, 0x000fe20000041818ULL, 0x000000848900720bULL, 0x000fc40003fbd000ULL,
0x0000000135356812ULL, 0x000fe400078efcffULL, 0x000000346134723eULL, 0x000fe200000010ffULL,
0x00000056005f7306ULL, 0x000ef0000020d400ULL, 0x0000000160605812ULL, 0x000fe200078efcffULL,
0x00000050008b7306ULL, 0x000fe20000209400ULL, 0x0000008c8d00720bULL, 0x004fc40003fdd000ULL,
0x0000009fa200720bULL, 0x000fca0003fbd000ULL, 0x00000050008a7306ULL, 0x000eac0000205400ULL,
0x000000015f5f6812ULL, 0x008fe400078efcffULL, 0x0000000136365812ULL, 0x000fe200078efcffULL,
0x00000050005c7306ULL, 0x000ee2000020d400ULL, 0x000000472c2c8231ULL, 0x082fe200003400ffULL,
0x000000838200720bULL, 0x000fe20003fbd000ULL, 0x000000472e2e8231ULL, 0x000fe200003400ffULL,
0x000000a9ac00720bULL, 0x000fe20003fdd000ULL, 0x000000482d2d8231ULL, 0x000fc400003400ffULL,
0x000000482f2f8231ULL, 0x000fe200003400ffULL, 0x000000a7aa00720bULL, 0x000fe20003f1d000ULL,
0x00000058007c7306ULL, 0x000fec0000209400ULL, 0x000000015e5e5812ULL, 0x000fe400078efcffULL,
0x00000058007d7306ULL, 0x000e620000205400ULL, 0x000000016a6a6812ULL, 0x000fc400078efcffULL,
0x000000b4b100720bULL, 0x000fe40003fbd000ULL, 0x0000000137370812ULL, 0x000fe400078efcffULL,
0x000000818000720bULL, 0x000fe20003f1d000ULL, 0x000000ad00937306ULL, 0x000fe20000209400ULL,
0x0000008a8b00720bULL, 0x004fe40003fdd000ULL, 0x00000071b2b4723eULL, 0x000fe400000010ffULL,
0x0000005e375e723eULL, 0x000fc600000010ffULL, 0x000000ad00987306ULL, 0x000ea20000205400ULL,
0x000000016d6d5812ULL, 0x000fe200078efcffULL, 0x000000b43014723cULL, 0x000fe20000041814ULL,
0x000000abae00720bULL, 0x000fe40003fbd000ULL, 0x0000000159590812ULL, 0x000fe400078efcffULL,
0x000000015c5c6812ULL, 0x008fe200078efcffULL, 0x0000005800577306ULL, 0x000ee2000020d400ULL,
0x0000007d7c00720bULL, 0x002fe40003f1d000ULL, 0x0000006d5c5c723eULL, 0x000fca00000010ffULL,
0x000000ad00867306ULL, 0x000e62000020d400ULL, 0x000000989300720bULL, 0x004fe40003fdd000ULL,
0x000000016e6e5812ULL, 0x000fca00078efcffULL, 0x0000002800767306ULL, 0x000fe20000009400ULL,
0x0000000157570812ULL, 0x008fce00078efcffULL, 0x0000002800777306ULL, 0x000ea20000005400ULL,
0x0000000186866812ULL, 0x002fce00078efcffULL, 0x00000029006f7306ULL, 0x000ff00000009400ULL,
0x0000002900747306ULL, 0x000e620000005400ULL, 0x000000777600720bULL, 0x004fce0003fbd000ULL,
0x000000a300a67306ULL, 0x000ff00000209400ULL, 0x000000a300bb7306ULL, 0x000ea20000205400ULL,
0x000000746f00720bULL, 0x002fce0003f1d000ULL, 0x00000028005b7306ULL, 0x0002f0000000d400ULL,
0x0000002900567306ULL, 0x0006e2000000d400ULL, 0x0001000028287824ULL, 0x002fe200078e00ffULL,
0x000000bba600720bULL, 0x004fc40003fdd000ULL, 0x000000b865bb723eULL, 0x000fe400000010ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x000000a300897306ULL, 0x000e62000020d400ULL,
0x0001000029297824ULL, 0x008fe200078e00ffULL, 0x000000015b5b5812ULL, 0x000fe200078efcffULL,
0x000000ba3020723cULL, 0x000fe20000041820ULL, 0x000000603565723eULL, 0x000fe400000010ffULL,
0x00000018ff8c7819ULL, 0x000fc40000011429ULL, 0x00000028008f7306ULL, 0x000fe20000209400ULL,
0x000000689529723eULL, 0x000fe400000010ffULL, 0x000000917e68723eULL, 0x000fe400000010ffULL,
0x0000000156560812ULL, 0x000fe400078efcffULL, 0x000000365f35723eULL, 0x000fe200000010ffULL,
0x0000002800907306ULL, 0x000ea20000205400ULL, 0x0000000189896812ULL, 0x002fe200078efcffULL,
0x000000683008723cULL, 0x000b620000041808ULL, 0x000000596a5f723eULL, 0x000fc400000010ffULL,
0x0000005b8686723eULL, 0x000fc600000010ffULL, 0x0000002800847306ULL, 0x0002e2000020d400ULL,
0x000001002b697824ULL, 0x020fca00078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x000000bf00977306ULL, 0x000fe20000209400ULL, 0x000001002a287824ULL, 0x002fe200078e00ffULL,
0x000000908f00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff807819ULL, 0x000fe40000011428ULL,
0x000000bf009a7306ULL, 0x000e620000205400ULL, 0x0000007f9228723eULL, 0x000fe200000010ffULL,
0x000000342c08723cULL, 0x000fea0000041808ULL, 0x0000000184845812ULL, 0x008fe200078efcffULL,
0x0000008c008d7306ULL, 0x000fe40000209400ULL, 0x000000283004723cULL, 0x000b6c0000041804ULL,
0x0000008c00827306ULL, 0x000ea20000205400ULL, 0x0000007b9628723eULL, 0x020fc400000010ffULL,
0x000000798e29723eULL, 0x000fe400000010ffULL, 0x0000009a9700720bULL, 0x002fe40003fdd000ULL,
0x000000877a79723eULL, 0x000fe200000010ffULL, 0x000000bf00737306ULL, 0x000e62000020d400ULL,
0x000000568987723eULL, 0x000fe200000010ffULL, 0x00000028300c723cULL, 0x040b6c000004180cULL,
0x0000008c00a27306ULL, 0x000ee2000020d400ULL, 0x000000828d00720bULL, 0x004fe20003f1d000ULL,
0x000000783010723cULL, 0x000f640000041810ULL, 0x0000006cb728723eULL, 0x020fc400000010ffULL,
0x00000066b929723eULL, 0x000fe400000010ffULL, 0x0000002a00627306ULL, 0x000fe20000009400ULL,
0x0000000173736812ULL, 0x002fe200078efcffULL, 0x000000642c04723cULL, 0x000fe60000041804ULL,
0x000000847384723eULL, 0x000fc600000010ffULL, 0x0000002a00637306ULL, 0x000e620000005400ULL,
0x00000001a2a20812ULL, 0x008fe200078efcffULL, 0x00000028301c723cULL, 0x000b6c000004181cULL,
0x000000c100997306ULL, 0x000fe20000209400ULL, 0x000100002b287824ULL, 0x020fe200078e00ffULL,
0x0000005e2c0c723cULL, 0x000b68000004180cULL, 0x00000018ff287819ULL, 0x000fc40000011428ULL,
0x000000c1009c7306ULL, 0x000ea20000205400ULL, 0x000000636200720bULL, 0x002fe20003fdd000ULL,
0x000000862c14723cULL, 0x000b6c0000041814ULL, 0x00000080007f7306ULL, 0x000ff00000209400ULL,
0x00000080007c7306ULL, 0x000e620000205400ULL, 0x0000009c9900720bULL, 0x004fce0003fbd000ULL,
0x0000002a00557306ULL, 0x0004f0000000d400ULL, 0x000000c1009b7306ULL, 0x000ee2000020d400ULL,
0x000100002a2a7824ULL, 0x004fe200078e00ffULL, 0x0000007c7f00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000008000687306ULL, 0x000e62000020d400ULL,
0x0000000155556812ULL, 0x008fce00078efcffULL, 0x0000002b00587306ULL, 0x000fe20000009400ULL,
0x000000019b9b5812ULL, 0x000fc800078efcffULL, 0x000000a29b85723eULL, 0x000fc600000010ffULL,
0x0000002b005d7306ULL, 0x000ea20000005400ULL, 0x0000000168680812ULL, 0x002fc600078efcffULL,
0x000000842c18723cULL, 0x000b620000041818ULL, 0x000000556868723eULL, 0x000fc600000010ffULL,
0x00000069007a7306ULL, 0x000ff00000209400ULL, 0x00000069006f7306ULL, 0x000e620000205400ULL,
0x0000005d5800720bULL, 0x004fe40003f1d000ULL, 0x0000006e575d723eULL, 0x000fca00000010ffULL,
0x0000002a00667306ULL, 0x000fe40000209400ULL, 0x0000005c2c10723cULL, 0x000b6c0000041810ULL,
0x0000002a00297306ULL, 0x000ea20000205400ULL, 0x0000006f7a00720bULL, 0x002fce0003fbd000ULL,
0x0000002b00507306ULL, 0x000e70000000d400ULL, 0x0000006900717306ULL, 0x000ee2000020d400ULL,
0x000000296600720bULL, 0x004fce0003fdd000ULL, 0x0000002a002b7306ULL, 0x000ea2000020d400ULL,
0x0000000150500812ULL, 0x002fce00078efcffULL, 0x000000af00887306ULL, 0x000fe20000209400ULL,
0x0000000171715812ULL, 0x008fe400078efcffULL, 0x0000009da000720bULL, 0x000fe40003fbd000ULL,
0x000000507169723eULL, 0x000fc600000010ffULL, 0x000000af00b37306ULL, 0x000e620000205400ULL,
0x000000012b2b6812ULL, 0x004fc600078efcffULL, 0x000000682c1c723cULL, 0x000b68000004181cULL,
0x0000002800307306ULL, 0x000fe20000209400ULL, 0x000000019e9e5812ULL, 0x000fc800078efcffULL,
0x0000002b9e9e723eULL, 0x000fc600000010ffULL, 0x0000002800317306ULL, 0x000ea20000205400ULL,
0x000000b38800720bULL, 0x002fce0003f1d000ULL, 0x000000af002a7306ULL, 0x000e70000020d400ULL,
0x00000028009f7306ULL, 0x0006e2000020d400ULL, 0x000000313000720bULL, 0x004fe40003fdd000ULL,
0x000000012a2a0812ULL, 0x002fe200078efcffULL, 0x0000000827287824ULL, 0x008fd400078e00ffULL,
0x000000019f9f6812ULL, 0x000fc800078efcffULL, 0x0000009f2a9f723eULL, 0x000fce00000010ffULL,
0x0000009e2c20723cULL, 0x000b620000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0176c80028287f8cULL, 0x000e62000c80043fULL, 0xfffffff85a507812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000403c2b7811ULL, 0x000fe200078e40ffULL,
0x0176880050ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff2e7224ULL, 0x022fe200078e0029ULL,
0x0000000154547810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff587224ULL, 0x000fe200078e0051ULL,
0x000000022b00720cULL, 0x000fe20003f06070ULL, 0x000000ffff597224ULL, 0x000fe400078e0053ULL,
0x000000ffff287224ULL, 0x000fd400078e0040ULL, 0x0000a38000000947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x004fc40000015200ULL, 0x000004003f2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780482eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x0000002d2a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004003f2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe4000780482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000287824ULL, 0x000fe200078e00ffULL,
0x000000013c297810ULL, 0x000fe20007ffe0ffULL, 0x00005800265a7a24ULL, 0x010fc600078e02ffULL,
0x000000242900720cULL, 0x000fe20003f06070ULL, 0x000000805a5a7824ULL, 0x000fe200078e00ffULL,
0xffffffe0282b7812ULL, 0x000fca00078ec0ffULL, 0x000001003c2b7824ULL, 0x000fca00078e022bULL,
0x000000802b297810ULL, 0x000fc80007ffe0ffULL, 0x0000006038307812ULL, 0x000fe200078ef829ULL,
0x000004b000008947ULL, 0x000fea0003800000ULL, 0x0000001028337812ULL, 0x000fe200078ec0ffULL,
0x00000010252c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff317819ULL, 0x000fe40000011625ULL,
0x0000002902287217ULL, 0x000fe40007800000ULL, 0x00000004312f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001312a7824ULL, 0x040fe200078e0233ULL, 0x000000702c577812ULL, 0x000fe200078ec0ffULL,
0x0000000128287824ULL, 0x000fe200078e0a29ULL, 0x0000000831377810ULL, 0x040fe20007ffe0ffULL,
0x000000012a297824ULL, 0x040fe200078e0230ULL, 0x0000000c31557810ULL, 0x000fe20007ffe0ffULL,
0x000000012f327824ULL, 0x000fe200078e0233ULL, 0x0000002833287217ULL, 0x000fe20007800000ULL,
0x000000012a2b7824ULL, 0x000fe200078e0225ULL, 0x000000295a2d7210ULL, 0x000fe20007f1e0ffULL,
0x000000082a347824ULL, 0x000fc400078e00ffULL, 0x0000000132297824ULL, 0x000fe400078e0230ULL,
0x00000001282e7824ULL, 0x000fe200078e0a33ULL, 0xfffffff834347812ULL, 0x000fe200078ee22bULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x000000295a2b7210ULL, 0x000fe20007fde0ffULL,
0x000010003d297824ULL, 0x000fe200078e00ffULL, 0x00005e002d287a11ULL, 0x000fe200078038ffULL,
0x0000000137547824ULL, 0x000fe200078e0233ULL, 0x0000002e2f00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff2c7224ULL, 0x000fe200030e06ffULL, 0x00005f002d2d7a11ULL, 0x000fe200000f3c2aULL,
0x0000000132357824ULL, 0x040fe200078e0225ULL, 0x00005e002b2a7a11ULL, 0x000fe200078c38ffULL,
0x0000000832367824ULL, 0x000fe200078e00ffULL, 0x0000005728287210ULL, 0x000fc40007f1e0ffULL,
0x00005f002b2b7a11ULL, 0x000fe400030f3c2cULL, 0x00001000292c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff297224ULL, 0x000fe200000e062dULL, 0x000000572a2a7210ULL, 0x000fe20007fde0ffULL,
0x00000001542d7824ULL, 0x000fe200078e0230ULL, 0x0000002e3100720cULL, 0x000fe20003f06070ULL,
0x00002000272c7824ULL, 0x000fe200078e022cULL, 0xfffffff836367812ULL, 0x000fe200078ee235ULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0x0000002d5a2d7210ULL, 0x000fc40007fde0ffULL,
0x000130002c2f7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff327224ULL, 0x000fe200030e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078c38ffULL, 0x0000001034317824ULL, 0x000fe400078e022fULL,
0x0000000155347824ULL, 0x000fe200078e0233ULL, 0x00005f002d327a11ULL, 0x000fe200030f3c32ULL,
0x0000001036337824ULL, 0x000fe200078e022fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e2000c101c46ULL, 0x00000001342d7824ULL, 0x000fe200078e0230ULL,
0x000000572c2c7210ULL, 0x000fe40007f1e0ffULL, 0x000000002a337faeULL, 0x0005e2000e901c46ULL,
0x0000002e3700720cULL, 0x080fe20003fa6070ULL, 0x0000000854377824ULL, 0x000fe200078e00ffULL,
0x0000002d5a307210ULL, 0x000fe20007fde0ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e0632ULL,
0x0000002e5500720cULL, 0x000fe20003f06070ULL, 0x00000001542e7824ULL, 0x000fc400078e0225ULL,
0x000000ffff357224ULL, 0x000fe200030e06ffULL, 0x00005e0030287a11ULL, 0x002fe200078c38ffULL,
0x0000000134317824ULL, 0x040fe200078e0225ULL, 0xfffffff8372e7812ULL, 0x000fe200078ee22eULL,
0x0000000834347824ULL, 0x000fe200078e00ffULL, 0x00005f0030297a11ULL, 0x000fe400030f3c35ULL,
0x0000005728287210ULL, 0x000fe20007fde0ffULL, 0x000000102e2b7824ULL, 0x004fe200078e022fULL,
0xfffffff8342a7812ULL, 0x000fc600078ee231ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x000000002c2b7faeULL, 0x0003e2000e901c46ULL, 0x000000102a2f7824ULL, 0x000fca00078e022fULL,
0x00000000282f7faeULL, 0x0003e2000c101c46ULL, 0x000003e000007947ULL, 0x000fea0003800000ULL,
0x0000001028287812ULL, 0x000fe200078ec0ffULL, 0x0000001025577824ULL, 0x000fc600078e00ffULL,
0x0000002825287211ULL, 0x000fe400078fe8ffULL, 0x0000007057577812ULL, 0x000fe400078ec0ffULL,
0x00000008282c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000128297824ULL, 0x140fe200078e0225ULL,
0x00000004282a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008282e7824ULL, 0x000fe400078e00ffULL,
0x000000012c2d7824ULL, 0x040fe400078e0225ULL, 0x000000082c347824ULL, 0x000fe200078e00ffULL,
0xfffffff82e317812ULL, 0x000fe200078ee229ULL, 0x0000000128297824ULL, 0x140fe200078e0230ULL,
0x0000000c28287810ULL, 0x000fe20007ffe0ffULL, 0x000000012a2b7824ULL, 0x000fe200078e0225ULL,
0xfffffff834377812ULL, 0x000fe200078ee22dULL, 0x000000082a327824ULL, 0x000fe200078e00ffULL,
0x000000295a347210ULL, 0x000fe20007f1e0ffULL, 0x000000012a297824ULL, 0x000fc400078e0230ULL,
0x00000001282d7824ULL, 0x100fe200078e0230ULL, 0xfffffff832357812ULL, 0x000fe200078ee22bULL,
0x000000012c2b7824ULL, 0x000fe200078e0230ULL, 0x000000295a297210ULL, 0x000fe20007fbe0ffULL,
0x00000001282c7824ULL, 0x040fe400078e0225ULL, 0x0000000828557824ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fe200000e06ffULL, 0x00005e0034337a11ULL, 0x040fe200078038ffULL,
0x000000ffff327224ULL, 0x000fe200028e06ffULL, 0x00005e00292a7a11ULL, 0x000fe200078a38ffULL,
0x000010003d287824ULL, 0x000fe200078e00ffULL, 0x00005f0034347a11ULL, 0x000fc400000f3c2fULL,
0x00005f0029327a11ULL, 0x000fe400028f3c32ULL, 0x0000100028287812ULL, 0x000fe400078ec0ffULL,
0x0000002b5a2b7210ULL, 0x040fe40007f1e0ffULL, 0x0000002d5a2d7210ULL, 0x000fe20007fbe0ffULL,
0x0000200027297824ULL, 0x000fe200078e0228ULL, 0xfffffff855557812ULL, 0x000fe200078ee22cULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x00005e002b2c7a11ULL, 0x000fe200078038ffULL,
0x000000ffff287224ULL, 0x000fe200028e06ffULL, 0x00005e002d2e7a11ULL, 0x000fc400078a38ffULL,
0x00005f002b307a11ULL, 0x000fe400000f3c30ULL, 0x00005f002d2f7a11ULL, 0x000fe400028f3c28ULL,
0x0000005733287210ULL, 0x080fe40007f1e0ffULL, 0x000000572a2a7210ULL, 0x080fe40007fbe0ffULL,
0x0001300029367810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff297224ULL, 0x000fe200000e0634ULL,
0x000000572c2c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200028e0632ULL,
0x000000572e2e7210ULL, 0x000fe20007fbe0ffULL, 0x0000001031317824ULL, 0x000fc400078e0236ULL,
0x0000001035337824ULL, 0x100fe400078e0236ULL, 0x0000001037357824ULL, 0x000fe200078e0236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x000fe400000e0630ULL, 0x0000001055377824ULL, 0x000fe200078e0236ULL,
0x000000002a337faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2f7224ULL, 0x000fc600028e062fULL,
0x000000002c357faeULL, 0x0003e8000b901c46ULL, 0x000000002e377faeULL, 0x0003e4000b901c46ULL,
0x0000000800297824ULL, 0x002fe200078e00ffULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000083d287824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0xfffffff029297812ULL, 0x000fe400078ec0ffULL, 0x0000000828287812ULL, 0x000fca00078ec0ffULL,
0x0000000129557824ULL, 0x000fca00078e0228ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000176a855567810ULL, 0x000fc80007ffe0ffULL, 0x00000000560403c2ULL, 0x000e640000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x002fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80055587f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01762800422c7f8cULL, 0x000664000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x01762c00422b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x012fe4000780482dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x0000002f2a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c00422b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008057287810ULL, 0x000fca0007ffe044ULL, 0x0000000145287824ULL, 0x000fca00078e0228ULL,
0x01700000282c7984ULL, 0x000e680000000800ULL, 0x0172000028297984ULL, 0x0006a20000000800ULL,
0x000000512c00720bULL, 0x002fe20003f1d000ULL, 0x000124027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x008fc800000e0100ULL, 0x0000ffff28ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff587224ULL, 0x004fd200078e0051ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000001002b7811ULL, 0x000fe400078ff0ffULL, 0x000000512c00720bULL, 0x000fe40003f14000ULL,
0x000000002b00720cULL, 0x000fe20003fa5270ULL, 0x000123c27f007947ULL, 0x000fd4000b800000ULL,
0x00000000002d7806ULL, 0x000fc400000e0100ULL, 0x00000080002ed824ULL, 0x000fe200078e0257ULL,
0x000000512c2ad209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099102d2b7816ULL, 0x000fe200000000ffULL, 0x00000001452fd824ULL, 0x000fc600078e022eULL,
0x000000ff2b00720cULL, 0x000fe40003f05270ULL, 0x0174002a2f00d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000512c2a7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff2dff7812ULL, 0x000fc6000780c0ffULL,
0x000000512a2a7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b2a2a7820ULL, 0x000fc80000410000ULL,
0x0000002a002f7308ULL, 0x000e640000000800ULL, 0x0000002f3a3a7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff2a7819ULL, 0x000fe20000011625ULL,
0x000122f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2a2f2a7589ULL, 0x0002a400000e0000ULL,
0x0000002a04047220ULL, 0x084fe40000410000ULL, 0x0000002a05057220ULL, 0x080fe40000410000ULL,
0x0000002a08087220ULL, 0x080fe40000410000ULL, 0x0000002a09097220ULL, 0x000fc40000410000ULL,
0x0000002a0c0c7220ULL, 0x080fe40000410000ULL, 0x0000002a0d0d7220ULL, 0x080fe40000410000ULL,
0x0000002a10107220ULL, 0x080fe40000410000ULL, 0x0000002a11117220ULL, 0x080fe40000410000ULL,
0x0000002a14147220ULL, 0x080fe40000410000ULL, 0x0000002a15157220ULL, 0x000fc40000410000ULL,
0x0000002a18187220ULL, 0x080fe40000410000ULL, 0x0000002a19197220ULL, 0x080fe40000410000ULL,
0x0000002a1c1c7220ULL, 0x080fe40000410000ULL, 0x0000002a1d1d7220ULL, 0x080fe40000410000ULL,
0x0000002a20207220ULL, 0x080fe40000410000ULL, 0x0000002a21217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff002dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008252a7811ULL, 0x000fe200078ff0ffULL,
0x000122027f007947ULL, 0x000fea000b800000ULL, 0x00001f2a2f2a7589ULL, 0x0004e400000e0000ULL,
0x0000002a06067220ULL, 0x088fe40000410000ULL, 0x0000002a07077220ULL, 0x080fe40000410000ULL,
0x0000002a0a0a7220ULL, 0x080fe40000410000ULL, 0x0000002a0b0b7220ULL, 0x080fe40000410000ULL,
0x0000002a0e0e7220ULL, 0x080fe40000410000ULL, 0x0000002a0f0f7220ULL, 0x000fc40000410000ULL,
0x0000002a12127220ULL, 0x080fe40000410000ULL, 0x0000002a13137220ULL, 0x080fe40000410000ULL,
0x0000002a16167220ULL, 0x080fe40000410000ULL, 0x0000002a17177220ULL, 0x080fe40000410000ULL,
0x0000002a1a1a7220ULL, 0x080fe40000410000ULL, 0x0000002a1b1b7220ULL, 0x000fc40000410000ULL,
0x0000002a1e1e7220ULL, 0x080fe40000410000ULL, 0x0000002a1f1f7220ULL, 0x080fe40000410000ULL,
0x0000002a22227220ULL, 0x080fe40000410000ULL, 0x0000002a23237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff2dff7812ULL, 0x000fe20007800828ULL,
0x00000001ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000512c587209ULL, 0x000fd60007810000ULL,
0x800000582c2c0221ULL, 0x000fe20000010000ULL, 0x00007610ff2d0816ULL, 0x000fc6000000002dULL,
0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL, 0x0000002c00460308ULL, 0x000e640000000800ULL,
0x0000004629290220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003a293a7221ULL, 0x000fc40000010000ULL, 0x0000000000287805ULL, 0x000fca0000015200ULL,
0x0176ac00412b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282f7210ULL, 0x004fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x0000002f2a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac00412b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099102d287816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff2800720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000046ff28723eULL, 0x000fe400000010ffULL, 0x00000002ff297819ULL, 0x000fe40000011625ULL,
0x0000541028287816ULL, 0x000fe20000000028ULL, 0x00011e027f007947ULL, 0x000fea000b800000ULL,
0x00001f2928477589ULL, 0x0002e400000e0000ULL, 0x00000008292a7810ULL, 0x000fe20007ffe0ffULL,
0x00011e527f007947ULL, 0x000fea000b800000ULL, 0x00001f2a28487589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010292a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200078e0028ULL, 0x0000647000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x0001291000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018292a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x004fe200078e0028ULL,
0x000064e000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x000128a000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000014a287824ULL, 0x042fe200078e024bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000084a297824ULL, 0x000fe400078e00ffULL,
0x00000002275b7824ULL, 0x000fc600078e0240ULL, 0xfffffff829287812ULL, 0x000fe400078ee228ULL,
0x000130005b5b7811ULL, 0x000fca00078e60ffULL, 0x0000001028577824ULL, 0x100fe400078e025bULL,
0x000000104d537824ULL, 0x100fe400078e025bULL, 0x000000104c527824ULL, 0x100fe200078e025bULL,
0x000000005730783bULL, 0x004e620000004200ULL, 0x000000104e517824ULL, 0x000fc600078e025bULL,
0x00000000532c783bULL, 0x000ea80000004200ULL, 0x000000005234783bULL, 0x000fe80000004200ULL,
0x000000005128783bULL, 0x000f220000004200ULL, 0x0000010030967824ULL, 0x002fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011432ULL, 0x00000030009f7306ULL, 0x000fe20000009400ULL,
0x00000018ff5e7819ULL, 0x000fe20000011431ULL, 0x0000010033a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x000001002cd27824ULL, 0x004fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc40000011430ULL, 0x00000018ff627819ULL, 0x000fe20000011433ULL,
0x0000003000a27306ULL, 0x000e620000005400ULL, 0x00000018ffcd7819ULL, 0x000fe400000114a0ULL,
0x00000018ff997819ULL, 0x010fe40000011429ULL, 0x00000018ff9b7819ULL, 0x000fe4000001142aULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x0000006100be7306ULL, 0x000fe20000209400ULL,
0x00000018ff637819ULL, 0x000fc4000001142fULL, 0x00000018ff6a7819ULL, 0x000fe40000011428ULL,
0x00000018ff6c7819ULL, 0x000fc6000001142bULL, 0x0000006100bb7306ULL, 0x000fe20000205400ULL,
0x000000a29f00720bULL, 0x002fce0003fbd000ULL, 0x0000006100847306ULL, 0x0003f0000020d400ULL,
0x0000009600c17306ULL, 0x000fe20000209400ULL, 0x00000018ff617819ULL, 0x002fce000001142eULL,
0x0000009600c27306ULL, 0x000e700000205400ULL, 0x00000030008c7306ULL, 0x000530000000d400ULL,
0x0000006100ae7306ULL, 0x000fe20000209400ULL, 0x0001000030307824ULL, 0x004fe200078e00ffULL,
0x000000c2c100720bULL, 0x002fc80003fdd000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000006100ad7306ULL, 0x000fe20000205400ULL, 0x000000018c8c5812ULL, 0x010fce00078efcffULL,
0x0000006100787306ULL, 0x0003f0000020d400ULL, 0x0000005e00ac7306ULL, 0x000fe20000209400ULL,
0x00000018ff617819ULL, 0x002fce0000011436ULL, 0x0000005e00bf7306ULL, 0x000ff00000205400ULL,
0x0000005e00897306ULL, 0x0003f0000020d400ULL, 0x0000006100917306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x002fce000001142dULL, 0x0000005e00b67306ULL, 0x000ff00000209400ULL,
0x0000005e00b37306ULL, 0x000ff00000205400ULL, 0x0000005e007b7306ULL, 0x0003f0000020d400ULL,
0x0000006100907306ULL, 0x000fe20000205400ULL, 0x00000018ff5e7819ULL, 0x002fce0000011435ULL,
0x00000061006e7306ULL, 0x000ff0000020d400ULL, 0x0000009900737306ULL, 0x000ff00000209400ULL,
0x0000009900727306ULL, 0x000ff00000205400ULL, 0x0000009900617306ULL, 0x000ff0000020d400ULL,
0x0000009600997306ULL, 0x0002b0000020d400ULL, 0x0000005400c57306ULL, 0x000fe20000209400ULL,
0x0000010032967824ULL, 0x002fca00078e00ffULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x0000005400c67306ULL, 0x000e620000205400ULL, 0x0000000199996812ULL, 0x004fce00078efcffULL,
0x0000003000c37306ULL, 0x000ff00000209400ULL, 0x0000003000c47306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fce0003fbd000ULL, 0x0000006200bc7306ULL, 0x000ff00000209400ULL,
0x0000006200b97306ULL, 0x000fe20000205400ULL, 0x000000c4c300720bULL, 0x004fce0003fdd000ULL,
0x0000006200837306ULL, 0x000ff0000020d400ULL, 0x0000005e00987306ULL, 0x000ff00000209400ULL,
0x0000005e00957306ULL, 0x000ff00000205400ULL, 0x0000005e00627306ULL, 0x000ff0000020d400ULL,
0x0000009b00657306ULL, 0x000ff00000209400ULL, 0x0000009b005e7306ULL, 0x000ff00000205400ULL,
0x0000009b00697306ULL, 0x0003f0000020d400ULL, 0x00000054008b7306ULL, 0x000522000020d400ULL,
0x00000100319b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe4000001149bULL,
0x00000030009e7306ULL, 0x000e62000020d400ULL, 0x00000018ff547819ULL, 0x004fce000001142cULL,
0x0000003100af7306ULL, 0x000fe20000009400ULL, 0x000000018b8b5812ULL, 0x010fce00078efcffULL,
0x0000003100c07306ULL, 0x000ea20000005400ULL, 0x000000019e9e6812ULL, 0x002fce00078efcffULL,
0x0000009b00c77306ULL, 0x000ff00000209400ULL, 0x0000009b00c87306ULL, 0x000e620000205400ULL,
0x000000c0af00720bULL, 0x004fce0003fbd000ULL, 0x00000031008a7306ULL, 0x000530000000d400ULL,
0x0000009b00a17306ULL, 0x000ee2000020d400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x000000c8c700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003200bd7306ULL, 0x000fe20000009400ULL, 0x000000018a8a5812ULL, 0x010fe400078efcffULL,
0x000000bfac00720bULL, 0x000fe20003fbd000ULL, 0x000001002ebf7824ULL, 0x000fc800078e00ffULL,
0x0000003100c97306ULL, 0x000fe20000209400ULL, 0x00000001a1a16812ULL, 0x008fe400078efcffULL,
0x00000018ffbf7819ULL, 0x000fca00000114bfULL, 0x0000003100ca7306ULL, 0x000e620000205400ULL,
0x0000000189895812ULL, 0x000fce00078efcffULL, 0x00000031009c7306ULL, 0x000eb0000020d400ULL,
0x0000003200ba7306ULL, 0x000ee20000005400ULL, 0x000000cac900720bULL, 0x002fce0003fdd000ULL,
0x0000009600307306ULL, 0x000fec0000209400ULL, 0x000000019c9c6812ULL, 0x004fe400078efcffULL,
0x0000009600cb7306ULL, 0x000e620000205400ULL, 0x000000babd00720bULL, 0x008fce0003fbd000ULL,
0x0000003200887306ULL, 0x0004f0000000d400ULL, 0x00000096009d7306ULL, 0x000f22000020d400ULL,
0x000000cb3000720bULL, 0x002fe20003fdd000ULL, 0x0001000032327824ULL, 0x004fc400078e00ffULL,
0x000001002f307824ULL, 0x000fc600078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000003300b87306ULL, 0x000fe20000009400ULL, 0x0000000188885812ULL, 0x008fe400078efcffULL,
0x00000018ffba7819ULL, 0x000fca0000011430ULL, 0x0000003300b77306ULL, 0x000e620000005400ULL,
0x000000019d9d6812ULL, 0x010fce00078efcffULL, 0x000000cd00ce7306ULL, 0x000ff00000209400ULL,
0x000000cd00cf7306ULL, 0x000ea20000205400ULL, 0x000000b7b800720bULL, 0x002fce0003fbd000ULL,
0x0000003300877306ULL, 0x0002f0000000d400ULL, 0x000000cd00a07306ULL, 0x000f22000020d400ULL,
0x000000cfce00720bULL, 0x004fe20003fdd000ULL, 0x0001000033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000003200317306ULL, 0x000fe20000209400ULL,
0x0000000187875812ULL, 0x008fe400078efcffULL, 0x000000bbbe00720bULL, 0x000fca0003fbd000ULL,
0x0000003200cc7306ULL, 0x000e620000205400ULL, 0x00000001a0a06812ULL, 0x010fce00078efcffULL,
0x00000032009b7306ULL, 0x0004e2000020d400ULL, 0x0000000184845812ULL, 0x000fe400078efcffULL,
0x000000b9bc00720bULL, 0x000fe20003fbd000ULL, 0x0000010034b97824ULL, 0x000fc800078e00ffULL,
0x0000003300d07306ULL, 0x000fe20000209400ULL, 0x000000cc3100720bULL, 0x002fe20003fdd000ULL,
0x000001002d327824ULL, 0x004fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fc800000114b9ULL,
0x00000018ffc17819ULL, 0x000fe20000011432ULL, 0x0000003300d17306ULL, 0x000e620000205400ULL,
0x0000000183835812ULL, 0x000fca00078efcffULL, 0x000000019b9b6812ULL, 0x008fe400078efcffULL,
0x0000003300967306ULL, 0x000eb0000020d400ULL, 0x0000002c00b27306ULL, 0x000fe20000009400ULL,
0x000000d1d000720bULL, 0x002fce0003fdd000ULL, 0x0000002c00b17306ULL, 0x000e6c0000005400ULL,
0x0000000196966812ULL, 0x004fe400078efcffULL, 0x000000d200cd7306ULL, 0x000ff00000209400ULL,
0x000000d200d47306ULL, 0x000ea20000205400ULL, 0x000000b1b200720bULL, 0x002fce0003fbd000ULL,
0x0000002c00807306ULL, 0x0002f0000000d400ULL, 0x000000d2009f7306ULL, 0x000f22000020d400ULL,
0x000000d4cd00720bULL, 0x004fe20003fdd000ULL, 0x000100002c2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002d00b07306ULL, 0x000fe20000009400ULL,
0x0000000180805812ULL, 0x008fce00078efcffULL, 0x0000002d00ab7306ULL, 0x000e620000005400ULL,
0x000000019f9f6812ULL, 0x010fc800078efcffULL, 0x000000809f80723eULL, 0x000fc600000010ffULL,
0x000000c100c27306ULL, 0x000ff00000209400ULL, 0x000000c100d37306ULL, 0x000ea20000205400ULL,
0x000000abb000720bULL, 0x002fce0003fbd000ULL, 0x0000002d007f7306ULL, 0x0002f0000000d400ULL,
0x000000c100a27306ULL, 0x000f22000020d400ULL, 0x000000d3c200720bULL, 0x004fe20003fdd000ULL,
0x000100002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000005400b57306ULL, 0x000fe20000209400ULL, 0x000000017f7f5812ULL, 0x008fce00078efcffULL,
0x0000005400b47306ULL, 0x000e620000205400ULL, 0x00000001a2a26812ULL, 0x010fce00078efcffULL,
0x0000002c00327306ULL, 0x000ff00000209400ULL, 0x0000002c00337306ULL, 0x000ea20000205400ULL,
0x000000b4b500720bULL, 0x002fce0003fbd000ULL, 0x00000054007e7306ULL, 0x0002f0000020d400ULL,
0x0000002c00af7306ULL, 0x000f22000020d400ULL, 0x000000333200720bULL, 0x004fe20003fdd000ULL,
0x0000010036327824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x002fc80000011434ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000002d00c07306ULL, 0x000fe20000209400ULL,
0x000000017e7e5812ULL, 0x008fe400078efcffULL, 0x000000b3b600720bULL, 0x000fca0003fbd000ULL,
0x0000002d00c17306ULL, 0x000e620000205400ULL, 0x00000001afaf6812ULL, 0x010fc800078efcffULL,
0x000000af7e7e723eULL, 0x000fc600000010ffULL, 0x0000002d00ac7306ULL, 0x000ea2000020d400ULL,
0x000000017b7b5812ULL, 0x000fce00078efcffULL, 0x0000002e00a87306ULL, 0x000fe20000009400ULL,
0x000000c1c000720bULL, 0x002fce0003fdd000ULL, 0x0000002e00a77306ULL, 0x000e6c0000005400ULL,
0x00000001acac6812ULL, 0x004fe400078efcffULL, 0x000000bf002c7306ULL, 0x000ff00000209400ULL,
0x000000bf00c37306ULL, 0x000ea20000205400ULL, 0x000000a7a800720bULL, 0x002fce0003fbd000ULL,
0x0000002e007a7306ULL, 0x0002f0000000d400ULL, 0x000000bf00bd7306ULL, 0x000f22000020d400ULL,
0x000000c32c00720bULL, 0x004fe20003fdd000ULL, 0x000100002e2e7824ULL, 0x002fc400078e00ffULL,
0x00000100372c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000002f00a67306ULL, 0x000fe20000009400ULL, 0x000000017a7a5812ULL, 0x008fce00078efcffULL,
0x0000002f00a57306ULL, 0x000e620000005400ULL, 0x00000001bdbd6812ULL, 0x010fc800078efcffULL,
0x0000007abd7a723eULL, 0x000fc600000010ffULL, 0x000000ba00c47306ULL, 0x000ff00000209400ULL,
0x000000ba00c57306ULL, 0x000ea20000205400ULL, 0x000000a5a600720bULL, 0x002fce0003fbd000ULL,
0x0000002f00777306ULL, 0x0002f0000000d400ULL, 0x000000ba00b87306ULL, 0x000f22000020d400ULL,
0x000000c5c400720bULL, 0x004fe20003fdd000ULL, 0x000100002f2f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002e002d7306ULL, 0x000fe20000209400ULL,
0x0000000177775812ULL, 0x008fe400078efcffULL, 0x000000adae00720bULL, 0x000fca0003fbd000ULL,
0x0000002e00307306ULL, 0x000e620000205400ULL, 0x00000001b8b86812ULL, 0x010fce00078efcffULL,
0x0000002e00b77306ULL, 0x000ea2000020d400ULL, 0x0000000178785812ULL, 0x000fce00078efcffULL,
0x0000006300aa7306ULL, 0x000fe20000209400ULL, 0x000000302d00720bULL, 0x002fe20003fdd000ULL,
0x00010000372d7824ULL, 0x000fca00078e00ffULL, 0x00000018ffad7819ULL, 0x000fe2000001142dULL,
0x0000006300a97306ULL, 0x000e620000205400ULL, 0x00000100282d7824ULL, 0x000fca00078e00ffULL,
0x00000001b7b76812ULL, 0x004fe400078efcffULL, 0x0000002f00317306ULL, 0x000fe40000209400ULL,
0x000000b77878723eULL, 0x000fcc00000010ffULL, 0x0000002f00be7306ULL, 0x000ea20000205400ULL,
0x000000a9aa00720bULL, 0x002fe40003fbd000ULL, 0x00000018ffaa7819ULL, 0x000fca000001142dULL,
0x0000006300757306ULL, 0x0002f0000020d400ULL, 0x0000002f00ba7306ULL, 0x0008e2000020d400ULL,
0x000000be3100720bULL, 0x004fe40003fdd000ULL, 0x00000018ff637819ULL, 0x002fca0000011437ULL,
0x0000003400a47306ULL, 0x000fe20000009400ULL, 0x00000100352f7824ULL, 0x010fe200078e00ffULL,
0x0000000175755812ULL, 0x008fc800078efcffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000003400a37306ULL, 0x000e620000005400ULL, 0x00000001baba6812ULL, 0x000fce00078efcffULL,
0x000000b9002e7306ULL, 0x000ff00000209400ULL, 0x000000b900bb7306ULL, 0x000ea20000205400ULL,
0x000000a3a400720bULL, 0x002fce0003fbd000ULL, 0x0000003400747306ULL, 0x0002f0000000d400ULL,
0x000000b900b17306ULL, 0x000f22000020d400ULL, 0x0001000034347824ULL, 0x002fe200078e00ffULL,
0x000000bb2e00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000054009a7306ULL, 0x000fe20000209400ULL, 0x0000000174745812ULL, 0x008fce00078efcffULL,
0x0000005400977306ULL, 0x000e620000205400ULL, 0x00000001b1b16812ULL, 0x010fc800078efcffULL,
0x00000074b174723eULL, 0x000fc600000010ffULL, 0x0000003400b27306ULL, 0x000ff00000209400ULL,
0x0000003400bf7306ULL, 0x000ea20000205400ULL, 0x000000979a00720bULL, 0x002fce0003fbd000ULL,
0x0000003500947306ULL, 0x000ff00000009400ULL, 0x0000003500937306ULL, 0x000fe20000005400ULL,
0x000000bfb200720bULL, 0x004fce0003fdd000ULL, 0x00000035005c7306ULL, 0x0003f0000000d400ULL,
0x0000002f00b97306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000002f00bc7306ULL, 0x000ff00000205400ULL,
0x0000002f00ab7306ULL, 0x0003f0000020d400ULL, 0x0000005400717306ULL, 0x000ea2000020d400ULL,
0x00000018ff2f7819ULL, 0x002fe2000001142cULL, 0x00010000362c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000003400b07306ULL, 0x000e70000020d400ULL,
0x0000003600927306ULL, 0x000fe20000009400ULL, 0x0000000171715812ULL, 0x004fc400078efcffULL,
0x000000939400720bULL, 0x000fca0003fbd000ULL, 0x00000036008f7306ULL, 0x000fe20000005400ULL,
0x00000001b0b06812ULL, 0x002fe400078efcffULL, 0x000000bcb900720bULL, 0x000fe40003fdd000ULL,
0x000000b071b0723eULL, 0x000fc600000010ffULL, 0x0000003600687306ULL, 0x000fe2000000d400ULL,
0x000000015c5c5812ULL, 0x000fce00078efcffULL, 0x00000037008e7306ULL, 0x000fe20000009400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x000000959800720bULL, 0x000fca0003fdd000ULL,
0x00000037008d7306ULL, 0x000ff00000005400ULL, 0x0000003700677306ULL, 0x000fe2000000d400ULL,
0x0000000162626812ULL, 0x000fce00078efcffULL, 0x0000003500347306ULL, 0x000ff00000209400ULL,
0x0000003500b57306ULL, 0x000e700000205400ULL, 0x0000003500b37306ULL, 0x000eb0000020d400ULL,
0x0000003200b47306ULL, 0x000fe20000209400ULL, 0x000000b53400720bULL, 0x002fce0003fbd000ULL,
0x0000003200c17306ULL, 0x000fec0000205400ULL, 0x00000001b3b35812ULL, 0x004fe400078efcffULL,
0x0000003200a77306ULL, 0x0003e2000020d400ULL, 0x0000008f9200720bULL, 0x000fe40003fbd000ULL,
0x000000b362b1723eULL, 0x000fca00000010ffULL, 0x0000002f00a87306ULL, 0x000fe20000209400ULL,
0x011800004930783bULL, 0x002e6a0000000200ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x0000002f00c37306ULL, 0x000eb00000205400ULL, 0x0000002f00367306ULL, 0x000ef0000020d400ULL,
0x0000002c00357306ULL, 0x000fe20000209400ULL, 0x000000c3a800720bULL, 0x004fce0003fdd000ULL,
0x0000002c00a67306ULL, 0x000eac0000205400ULL, 0x0000000136366812ULL, 0x008fe400078efcffULL,
0x0000002c00377306ULL, 0x000722000020d400ULL, 0x0000004730308231ULL, 0x082fe200003400ffULL,
0x000000909100720bULL, 0x000fe20003fdd000ULL, 0x0000004732328231ULL, 0x000fc400003400ffULL,
0x0000004831318231ULL, 0x080fe400003400ffULL, 0x0000004833338231ULL, 0x000fe200003400ffULL,
0x0000006300867306ULL, 0x000fe20000209400ULL, 0x011800004f2c783bULL, 0x008e620000000200ULL,
0x000000a63500720bULL, 0x004fe40003fbd000ULL, 0x0000009c8935723eULL, 0x000fc600000010ffULL,
0x000000016e6e6812ULL, 0x000fe200078efcffULL, 0x0000006300857306ULL, 0x000eae0000205400ULL,
0x0000000137375812ULL, 0x010fe200078efcffULL, 0x000000ad00ae7306ULL, 0x000fe60000209400ULL,
0x000000376e6e723eULL, 0x000fca00000010ffULL, 0x000000ad00a97306ULL, 0x000fe20000205400ULL,
0x000000858600720bULL, 0x004fce0003fbd000ULL, 0x000000aa00a37306ULL, 0x000ff00000209400ULL,
0x000000aa00b67306ULL, 0x000ea20000205400ULL, 0x000000472c2c8231ULL, 0x082fe400003400ffULL,
0x000000472e2e8231ULL, 0x000fc400003400ffULL, 0x000000482d2d8231ULL, 0x080fe400003400ffULL,
0x000000482f2f8231ULL, 0x000fe200003400ffULL, 0x000000c1b400720bULL, 0x000fe20003f1d000ULL,
0x000000ad00a57306ULL, 0x0003e2000020d400ULL, 0x000000b6a300720bULL, 0x004fce0003fdd000ULL,
0x0000006300547306ULL, 0x000ea2000020d400ULL, 0x0000010029ad7824ULL, 0x002fc600078e00ffULL,
0x00000001a7a70812ULL, 0x000fe400078efcffULL, 0x0000008d8e00720bULL, 0x000fe40003f1d000ULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x000000aa00a47306ULL, 0x000e62000020d400ULL,
0x0000000154545812ULL, 0x004fce00078efcffULL, 0x0000002800827306ULL, 0x000fe40000009400ULL,
0x0000000167670812ULL, 0x000fe400078efcffULL, 0x000000a9ae00720bULL, 0x000fc80003f1d000ULL,
0x0000002800817306ULL, 0x000ea20000005400ULL, 0x00000001a4a46812ULL, 0x002fce00078efcffULL,
0x00000029007c7306ULL, 0x000fe20000009400ULL, 0x00000001a5a50812ULL, 0x000fce00078efcffULL,
0x00000029007d7306ULL, 0x000e620000005400ULL, 0x000000818200720bULL, 0x004fe40003f1d000ULL,
0x0000007fa281723eULL, 0x000fe400000010ffULL, 0x000000ac7b7f723eULL, 0x000fe400000010ffULL,
0x00000077b87b723eULL, 0x000fe200000010ffULL, 0x000000ad00b27306ULL, 0x000fe40000209400ULL,
0x000000803014723cULL, 0x040fec0000041814ULL, 0x000000ad00bb7306ULL, 0x000ea20000205400ULL,
0x0000007d7c00720bULL, 0x002fe20003fbd000ULL, 0x0000007e3018723cULL, 0x040fec0000041818ULL,
0x00000028006d7306ULL, 0x0002e4000000d400ULL, 0x0000007a301c723cULL, 0x000fec000004181cULL,
0x0000002900647306ULL, 0x0008e2000000d400ULL, 0x0001000028287824ULL, 0x002fe200078e00ffULL,
0x000000bbb200720bULL, 0x004fc80003fdd000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x000000ad00977306ULL, 0x000e62000020d400ULL, 0x0001000029297824ULL, 0x010fe200078e00ffULL,
0x000000016d6d0812ULL, 0x008fc800078efcffULL, 0x00000018ff347819ULL, 0x000fe20000011429ULL,
0x000001002a297824ULL, 0x000fe200078e00ffULL, 0x0000006a00767306ULL, 0x000fe20000209400ULL,
0x0000000164645812ULL, 0x000fce00078efcffULL, 0x0000006a00797306ULL, 0x000ea20000205400ULL,
0x0000000197976812ULL, 0x002fc800078efcffULL, 0x000000649797723eULL, 0x000fc600000010ffULL,
0x0000002800937306ULL, 0x000ff00000209400ULL, 0x00000028009a7306ULL, 0x000e620000205400ULL,
0x000000797600720bULL, 0x004fe40003fdd000ULL, 0x000000ba7579723eULL, 0x000fc400000010ffULL,
0x0000005cab75723eULL, 0x000fc600000010ffULL, 0x0000002800947306ULL, 0x0004e4000020d400ULL,
0x000000783020723cULL, 0x000fec0000041820ULL, 0x0000003400957306ULL, 0x000fe20000209400ULL,
0x0000008c9928723eULL, 0x004fe400000010ffULL, 0x00000018ff8c7819ULL, 0x000fc40000011429ULL,
0x0000008aa129723eULL, 0x000fe400000010ffULL, 0x0000009a9300720bULL, 0x002fe20003f1d000ULL,
0x0000003400987306ULL, 0x000e680000205400ULL, 0x000000283004723cULL, 0x000b680000041804ULL,
0x0000003400927306ULL, 0x0005e6000020d400ULL, 0x000000889d28723eULL, 0x020fc400000010ffULL,
0x00000087a029723eULL, 0x000fe400000010ffULL, 0x0000000194940812ULL, 0x008fe200078efcffULL,
0x0000006a006b7306ULL, 0x000ee2000020d400ULL, 0x0000009e8b34723eULL, 0x004fe400000010ffULL,
0x000000989500720bULL, 0x002fe20003fbd000ULL, 0x00000028300c723cULL, 0x000fe2000004180cULL,
0x000000727300720bULL, 0x000fc60003f1d000ULL, 0x0000002a005d7306ULL, 0x000fe80000009400ULL,
0x000000343008723cULL, 0x000b680000041808ULL, 0x0000002a00707306ULL, 0x000e620000005400ULL,
0x000000016b6b6812ULL, 0x008fe400078efcffULL, 0x000001002b357824ULL, 0x020fe200078e00ffULL,
0x0000009b8434723eULL, 0x000fe200000010ffULL, 0x000000742c04723cULL, 0x000fe20000041804ULL,
0x0000000192925812ULL, 0x000fc400078efcffULL, 0x0000008c008a7306ULL, 0x000fe20000209400ULL,
0x00000018ff287819ULL, 0x000fe40000011435ULL, 0x000000968335723eULL, 0x000fe400000010ffULL,
0x0000000161610812ULL, 0x000fe400078efcffULL, 0x0000006da496723eULL, 0x000fe200000010ffULL,
0x0000008c00897306ULL, 0x000ea20000205400ULL, 0x000000705d00720bULL, 0x002fe20003fdd000ULL,
0x000000343010723cULL, 0x000b620000041810ULL, 0x000000946b94723eULL, 0x000fc400000010ffULL,
0x000000926195723eULL, 0x000fc600000010ffULL, 0x0000002a00607306ULL, 0x0002e4000000d400ULL,
0x000000b02c08723cULL, 0x040f6c0000041808ULL, 0x0000002800297306ULL, 0x000fe20000209400ULL,
0x000100002a2a7824ULL, 0x002fe200078e00ffULL, 0x000000898a00720bULL, 0x004fe20003fbd000ULL,
0x000000962c14723cULL, 0x000f660000041814ULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x00000028007c7306ULL, 0x000e620000205400ULL, 0x0000000160606812ULL, 0x008fe400078efcffULL,
0x000000942c18723cULL, 0x000f6a0000041818ULL, 0x0000002800807306ULL, 0x0004f0000020d400ULL,
0x0000002b00667306ULL, 0x000fe20000009400ULL, 0x000100002b287824ULL, 0x004fe200078e00ffULL,
0x0000007c2900720bULL, 0x002fc40003f1d000ULL, 0x000000673629723eULL, 0x000fe400000010ffULL,
0x00000018ff317819ULL, 0x020fe40000011428ULL, 0x0000002b006f7306ULL, 0x000fe20000005400ULL,
0x00000068a728723eULL, 0x000fcc00000010ffULL, 0x0000000180800812ULL, 0x008fe200078efcffULL,
0x0000002b005f7306ULL, 0x000fe2000000d400ULL, 0x0000005e6500720bULL, 0x000fe20003f1d000ULL,
0x000000282c0c723cULL, 0x000b6c000004180cULL, 0x0000008c00857306ULL, 0x000e62000020d400ULL,
0x000176c827287811ULL, 0x020fca00078e18ffULL, 0x0000000169690812ULL, 0x000fe400078efcffULL,
0x0000002a00347306ULL, 0x000ff00000209400ULL, 0x0000002a002b7306ULL, 0x000ea20000205400ULL,
0x0000000185855812ULL, 0x002fc400078efcffULL, 0x0000006f6600720bULL, 0x000fe40003fbd000ULL,
0x000000a5546f723eULL, 0x000fe400000010ffULL, 0x00000060855e723eULL, 0x000fe200000010ffULL,
0x0000002a00307306ULL, 0x000e68000020d400ULL, 0x0000006e2c10723cULL, 0x000b680000041810ULL,
0x0000006c00637306ULL, 0x000fe20000209400ULL, 0x0000002b3400720bULL, 0x004fc40003fdd000ULL,
0x000000015f5f5812ULL, 0x000fc800078efcffULL, 0x0000005f805f723eULL, 0x000fe200000010ffULL,
0x0000006c006a7306ULL, 0x000eac0000205400ULL, 0x0000000130306812ULL, 0x002fe200078efcffULL,
0x0000005e2c1c723cULL, 0x000b62000004181cULL, 0x0000003100327306ULL, 0x000fe40000209400ULL,
0x000000306930723eULL, 0x000fcc00000010ffULL, 0x0000003100337306ULL, 0x000e620000205400ULL,
0x0000006a6300720bULL, 0x004fce0003fbd000ULL, 0x0000006c006c7306ULL, 0x000eb0000020d400ULL,
0x0000003100317306ULL, 0x000ee2000020d400ULL, 0x000000333200720bULL, 0x002fe40003fdd000ULL,
0x000000016c6c5812ULL, 0x004fd600078efcffULL, 0x0000000131316812ULL, 0x008fc800078efcffULL,
0x000000316c31723eULL, 0x000fce00000010ffULL, 0x000000302c20723cULL, 0x000b620000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000028287f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000803c2b7811ULL, 0x000fe200078e40ffULL, 0x0176900050ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff2e7224ULL, 0x022fe200078e0029ULL, 0x000000013e547810ULL, 0x000fe40007ffe0ffULL,
0x000000022b00720cULL, 0x000fe40003f06070ULL, 0x000000013d287812ULL, 0x000fd600078ec0ffULL,
0x00006c5000000947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x004fc40000015200ULL,
0x000004003f2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe4000780482eULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc8000001142bULL,
0x0000002d26267211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x0000000226267819ULL, 0x000fc8000000122bULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003f2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780482eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000267824ULL, 0x000fe200078e00ffULL, 0x000000013c297810ULL, 0x000fc80007ffe0ffULL,
0x000000242900720cULL, 0x000fe40003f06070ULL, 0xffffffe0262b7812ULL, 0x000fca00078ec0ffULL,
0x000001003c2b7824ULL, 0x000fca00078e022bULL, 0x000000c02b2b7810ULL, 0x000fc80007ffe0ffULL,
0x0000006038317812ULL, 0x000fe200078ef82bULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000010262f7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff2c7819ULL, 0x000fe40000011625ULL,
0x0000002b02267217ULL, 0x000fe40007800000ULL, 0x000000042c327810ULL, 0x040fe20007ffe0ffULL,
0x000000012c2e7824ULL, 0x040fe200078e022fULL, 0x0000000c2c337810ULL, 0x000fe20007ffe0ffULL,
0x0000000126267824ULL, 0x000fc400078e0a2bULL, 0x000000012e297824ULL, 0x000fe400078e0231ULL,
0x00000010252b7824ULL, 0x000fe200078e00ffULL, 0x000000262f267217ULL, 0x000fe20007800000ULL,
0x0000000132347824ULL, 0x100fe200078e022fULL, 0x000000295a297210ULL, 0x000fe20007f1e0ffULL,
0x000000082e307824ULL, 0x000fe200078e00ffULL, 0x000000702b377812ULL, 0x000fe200078ec0ffULL,
0x0000000126267824ULL, 0x000fe400078e0a2fULL, 0x000000ffff2a7224ULL, 0x000fe200000e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078038ffULL, 0x000000012e2b7824ULL, 0x000fc400078e0225ULL,
0x0000000834357824ULL, 0x040fe200078e00ffULL, 0x00005f00292a7a11ULL, 0x000fe200000f3c2aULL,
0x0000000134297824ULL, 0x000fe200078e0231ULL, 0x0000003728287210ULL, 0x000fe40007fbe0ffULL,
0x000000262c00720cULL, 0x080fe40003f06070ULL, 0x000000295a2e7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff297224ULL, 0x000fe200028e062aULL, 0xfffffff830307812ULL, 0x000fe400078ee22bULL,
0x000000263200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff2b7224ULL, 0x000fe200030e06ffULL,
0x000000082c327810ULL, 0x000fe20007ffe0ffULL, 0x00000010302d7824ULL, 0x000fe200078e025bULL,
0x00005e002e2a7a11ULL, 0x000fe200078c38ffULL, 0x0000000134307824ULL, 0x000fc400078e0225ULL,
0x0000000132367824ULL, 0x000fe200078e022fULL, 0x00005f002e2e7a11ULL, 0x000fe200030f3c2bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0003e2000c101c46ULL,
0x000000372a2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001362b7824ULL, 0x000fe200078e0231ULL,
0xfffffff835307812ULL, 0x000fe200078ee230ULL, 0x0000000133347824ULL, 0x000fc600078e022fULL,
0x0000002b5a2c7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e062eULL,
0x000000263200720cULL, 0x000fe20003f06070ULL, 0x00000008342e7824ULL, 0x000fe400078e00ffULL,
0x00000010302d7824ULL, 0x002fe400078e025bULL, 0x0000000134297824ULL, 0x000fe400078e0231ULL,
0x000000ffff2f7224ULL, 0x000fe200030e06ffULL, 0x000000002a2d7faeULL, 0x0003e2000e901c46ULL,
0x00005e002c287a11ULL, 0x000fe200078a38ffULL, 0x0000000836317824ULL, 0x000fe200078e00ffULL,
0x000000295a5a7210ULL, 0x000fc40007fde0ffULL, 0x00005f002c297a11ULL, 0x000fe400028f3c2fULL,
0x000000263300720cULL, 0x000fe20003fa6070ULL, 0x000000ffff2f7224ULL, 0x000fe200030e06ffULL,
0x0000003728287210ULL, 0x000fe20007fde0ffULL, 0x0000000136267824ULL, 0x100fe400078e0225ULL,
0x00000001342b7824ULL, 0x002fe400078e0225ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x00005e005a2a7a11ULL, 0x000fc400078c38ffULL, 0xfffffff8312c7812ULL, 0x000fe400078ee226ULL,
0x00005f005a267a11ULL, 0x000fe400030f3c2fULL, 0x000000372a2a7210ULL, 0x000fe20007fde0ffULL,
0x000000102c2d7824ULL, 0x000fe200078e025bULL, 0xfffffff82e2e7812ULL, 0x000fc600078ee22bULL,
0x000000ffff2b7224ULL, 0x000fe200030e0626ULL, 0x00000000282d7faeULL, 0x0003e2000c101c46ULL,
0x000000102e5b7824ULL, 0x000fca00078e025bULL, 0x000000002a5b7faeULL, 0x0003e2000e901c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001026267812ULL, 0x000fe200078ec0ffULL,
0x0000001025377824ULL, 0x000fc600078e00ffULL, 0x0000002625267211ULL, 0x000fe400078fe8ffULL,
0x0000007037377812ULL, 0x000fe400078ec0ffULL, 0x00000004262a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126297824ULL, 0x040fe200078e0231ULL, 0x0000000c262e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126287824ULL, 0x100fe400078e0225ULL, 0x000000012a2b7824ULL, 0x000fe200078e0225ULL,
0x000000295a327210ULL, 0x000fe20007f1e0ffULL, 0x000000082a367824ULL, 0x000fc400078e00ffULL,
0x00000008262d7824ULL, 0x000fe400078e00ffULL, 0x000000012a297824ULL, 0x000fe200078e0231ULL,
0xfffffff836367812ULL, 0x000fe200078ee22bULL, 0x000000ffff2b7224ULL, 0x000fe200000e06ffULL,
0xfffffff82d347812ULL, 0x000fe400078ee228ULL, 0x00005e0032307a11ULL, 0x000fe200078038ffULL,
0x0000001036337824ULL, 0x000fe200078e025bULL, 0x0000000826287810ULL, 0x000fe40007ffe0ffULL,
0x00005f0032327a11ULL, 0x000fc400000f3c2bULL, 0x000000295a2f7210ULL, 0x000fe20007f1e0ffULL,
0x00000001282b7824ULL, 0x100fe400078e0231ULL, 0x000000012e297824ULL, 0x000fe400078e0231ULL,
0x00000001282c7824ULL, 0x100fe200078e0225ULL, 0x0000002b5a2b7210ULL, 0x000fe20007fbe0ffULL,
0x00000008282d7824ULL, 0x000fe200078e00ffULL, 0x000000295a297210ULL, 0x000fe20007fde0ffULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x00005e002f2a7a11ULL, 0x000fe200078038ffULL,
0x000000082e5a7824ULL, 0x040fe200078e00ffULL, 0xfffffff82d547812ULL, 0x000fe200078ee22cULL,
0x000000012e2d7824ULL, 0x000fe200078e0225ULL, 0x00005f002f2f7a11ULL, 0x000fe200000f3c26ULL,
0x000000ffff287224ULL, 0x000fe200028e06ffULL, 0x00005e002b2c7a11ULL, 0x000fe200078038ffULL,
0x000000ffff267224ULL, 0x000fe200030e06ffULL, 0x00005e00292e7a11ULL, 0x000fe200078a38ffULL,
0x0000001034317824ULL, 0x000fe200078e025bULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee22dULL,
0x0000001054357824ULL, 0x000fe200078e025bULL, 0x00005f002b2d7a11ULL, 0x000fc400000f3c28ULL,
0x00005f0029267a11ULL, 0x000fe200028f3c26ULL, 0x000000105a5b7824ULL, 0x000fe200078e025bULL,
0x0000003730287210ULL, 0x080fe40007f1e0ffULL, 0x000000372a2a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe200000e0632ULL, 0x000000372c2c7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e062fULL, 0x000000372e2e7210ULL, 0x000fe40007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x000fe400000e062dULL, 0x000000ffff2f7224ULL, 0x000fe200028e0626ULL,
0x000000002a337faeULL, 0x0003e8000b901c46ULL, 0x000000002c357faeULL, 0x0003e8000b901c46ULL,
0x000000002e5b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000023e267810ULL, 0x000fc40007ffe0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x000000032600720cULL, 0x000fe20003fa6070ULL, 0xffffffffff267424ULL, 0x000fd800078e00ffULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x000000023b287810ULL, 0x000fe20007ffe03eULL,
0x00000004ff297424ULL, 0x000fc800078e00ffULL, 0x0000600028287625ULL, 0x000fca00078e0029ULL,
0x0000000628267981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000430403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a800415a7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01764800422c7f8cULL, 0x0002a4000c80043fULL,
0x0000000000287805ULL, 0x002fc40000015200ULL, 0x01764c00422b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x006fe4000780482dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x0000002f2a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c00422b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe4000780482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010037287810ULL, 0x000fca0007ffe044ULL,
0x0000000145287824ULL, 0x000fca00078e0228ULL, 0x0170000028297984ULL, 0x000e680000000800ULL,
0x01720000282d7984ULL, 0x0004e20000000800ULL, 0x000000582900720bULL, 0x002fe20003f1d000ULL,
0x0000efe27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000287806ULL, 0x004fc800000e0100ULL,
0x0000ffff28ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff437224ULL, 0x000fd200078e0058ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000002002b7811ULL, 0x000fe400078ff0ffULL,
0x000000582900720bULL, 0x000fe40003f14000ULL, 0x000000002b00720cULL, 0x000fe20003fa5270ULL,
0x0000efa27f007947ULL, 0x000fd4000b800000ULL, 0x00000000002f7806ULL, 0x000fc400000e0100ULL,
0x00000080002cd824ULL, 0x000fe200078e0237ULL, 0x00000029582ad209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099102f2b7816ULL, 0x000fe200000000ffULL,
0x000000014531d824ULL, 0x000fc600078e022cULL, 0x000000ff2b00720cULL, 0x000fe40003f05270ULL,
0x0174002a3100d388ULL, 0x0003f60000000800ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000029582b7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff2fff7812ULL, 0x000fc6000780c0ffULL, 0x8000002b582a7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b2a2a7820ULL, 0x000fc80000410000ULL, 0x0000002a00337308ULL, 0x000e640000000800ULL,
0x000000333a3a7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff2a7819ULL, 0x000fe20000011625ULL, 0x0000eed27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a332a7589ULL, 0x0002a400000e0000ULL, 0x0000002a04047220ULL, 0x084fe40000410000ULL,
0x0000002a05057220ULL, 0x080fe40000410000ULL, 0x0000002a08087220ULL, 0x080fe40000410000ULL,
0x0000002a09097220ULL, 0x000fc40000410000ULL, 0x0000002a0c0c7220ULL, 0x080fe40000410000ULL,
0x0000002a0d0d7220ULL, 0x080fe40000410000ULL, 0x0000002a10107220ULL, 0x080fe40000410000ULL,
0x0000002a11117220ULL, 0x080fe40000410000ULL, 0x0000002a14147220ULL, 0x080fe40000410000ULL,
0x0000002a15157220ULL, 0x000fc40000410000ULL, 0x0000002a18187220ULL, 0x080fe40000410000ULL,
0x0000002a19197220ULL, 0x080fe40000410000ULL, 0x0000002a1c1c7220ULL, 0x080fe40000410000ULL,
0x0000002a1d1d7220ULL, 0x080fe40000410000ULL, 0x0000002a20207220ULL, 0x080fe40000410000ULL,
0x0000002a21217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff002fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008252a7811ULL, 0x000fe200078ff0ffULL, 0x0000ede27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a332a7589ULL, 0x00046400000e0000ULL, 0x0000002a06067220ULL, 0x082fe40000410000ULL,
0x0000002a07077220ULL, 0x080fe40000410000ULL, 0x0000002a0a0a7220ULL, 0x080fe40000410000ULL,
0x0000002a0b0b7220ULL, 0x080fe40000410000ULL, 0x0000002a0e0e7220ULL, 0x080fe40000410000ULL,
0x0000002a0f0f7220ULL, 0x000fc40000410000ULL, 0x0000002a12127220ULL, 0x080fe40000410000ULL,
0x0000002a13137220ULL, 0x080fe40000410000ULL, 0x0000002a16167220ULL, 0x080fe40000410000ULL,
0x0000002a17177220ULL, 0x080fe40000410000ULL, 0x0000002a1a1a7220ULL, 0x080fe40000410000ULL,
0x0000002a1b1b7220ULL, 0x000fc40000410000ULL, 0x0000002a1e1e7220ULL, 0x080fe40000410000ULL,
0x0000002a1f1f7220ULL, 0x080fe40000410000ULL, 0x0000002a22227220ULL, 0x080fe40000410000ULL,
0x0000002a23237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2fff7812ULL, 0x000fe20007800828ULL, 0x00000001ff2c7424ULL, 0x000fe200078e00ffULL,
0x0000002958437209ULL, 0x000fd60007810000ULL, 0x8000004329290221ULL, 0x000fe20000010000ULL,
0x00007610ff2c0816ULL, 0x000fc6000000002cULL, 0x3fb8aa3b29290820ULL, 0x000fc80000410000ULL,
0x0000002900460308ULL, 0x000e640000000800ULL, 0x000000462d2d0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003a2d3a7221ULL, 0x008fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0176ac00552a7984ULL, 0x000e640000000800ULL,
0x800000002aff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x0000002d2a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac00552a7984ULL, 0x000e640000000800ULL, 0x800000002aff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099102c287816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff2800720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000046ff28723eULL, 0x000fe400000010ffULL,
0x00000002ff297819ULL, 0x000fe40000011625ULL, 0x0000541028287816ULL, 0x000fe20000000028ULL,
0x0000e9e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2928477589ULL, 0x0002e400000e0000ULL,
0x00000008292a7810ULL, 0x000fe20007ffe0ffULL, 0x0000ea327f007947ULL, 0x000fea000b800000ULL,
0x00001f2a28487589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010292a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0028ULL,
0x00009b2000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x0000f26000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018292a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x004fe200078e0028ULL, 0x00009b9000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x0000f1f000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000010003d287824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000014a4b7824ULL, 0x040fe400078e024bULL, 0x000000084a2c7824ULL, 0x000fe200078e00ffULL,
0x0000100028287812ULL, 0x000fc800078ec0ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee24bULL,
0x0000200027287824ULL, 0x000fca00078e0228ULL, 0x00013000284b7810ULL, 0x000fca0007ffe0ffULL,
0x000000102c2c7824ULL, 0x100fe400078e024bULL, 0x000000104d307824ULL, 0x104fe400078e024bULL,
0x000000104c347824ULL, 0x100fe400078e024bULL, 0x000000002c2c783bULL, 0x000e620000004200ULL,
0x000000104e287824ULL, 0x000fc600078e024bULL, 0x000000003030783bULL, 0x000ea80000004200ULL,
0x000000003434783bULL, 0x000ee80000004200ULL, 0x000000002828783bULL, 0x000ee20000004200ULL,
0x000001002c917824ULL, 0x002fe200078e00ffULL, 0x0000002c00967306ULL, 0x000fe20000009400ULL,
0x00000018ff607819ULL, 0x000fe2000001142cULL, 0x000001002f9b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe2000001142dULL, 0x0000010030cc7824ULL, 0x004fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fc40000011491ULL, 0x00000018ff657819ULL, 0x008fe20000011435ULL,
0x0000002c009f7306ULL, 0x000e620000005400ULL, 0x00000018ff627819ULL, 0x000fe4000001142eULL,
0x00000018ff637819ULL, 0x000fe4000001142fULL, 0x00000018ff927819ULL, 0x000fe40000011429ULL,
0x00000018ff667819ULL, 0x000fe20000011436ULL, 0x0000009100aa7306ULL, 0x000fe20000209400ULL,
0x00000018ff677819ULL, 0x000fc40000011437ULL, 0x00000018ff977819ULL, 0x000fe4000001142aULL,
0x00000018ffc67819ULL, 0x000fe4000001149bULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x0000009100bb7306ULL, 0x000ea20000205400ULL, 0x0000009f9600720bULL, 0x002fe40003fbd000ULL,
0x00000018ff647819ULL, 0x000fe40000011434ULL, 0x00000018ff6b7819ULL, 0x000fc40000011428ULL,
0x00000018ff697819ULL, 0x000fe2000001142bULL, 0x0000002c00897306ULL, 0x0002f0000000d400ULL,
0x0000006100b97306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x002fe200078e00ffULL,
0x000000bbaa00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000006100ae7306ULL, 0x000fe20000205400ULL, 0x0000000189895812ULL, 0x008fce00078efcffULL,
0x0000006100837306ULL, 0x0003f0000020d400ULL, 0x0000009100947306ULL, 0x0004e2000020d400ULL,
0x00000018ff617819ULL, 0x002fce0000011431ULL, 0x0000006000bc7306ULL, 0x000fe20000209400ULL,
0x000001002e917824ULL, 0x004fca00078e00ffULL, 0x00000018ff917819ULL, 0x000fe40000011491ULL,
0x0000006000bf7306ULL, 0x000e620000205400ULL, 0x0000000194946812ULL, 0x008fce00078efcffULL,
0x0000002c00ba7306ULL, 0x000ff00000209400ULL, 0x0000002c00bd7306ULL, 0x000ea20000205400ULL,
0x000000bfbc00720bULL, 0x002fce0003fbd000ULL, 0x0000006100af7306ULL, 0x000ff00000209400ULL,
0x0000006100ac7306ULL, 0x000fe20000205400ULL, 0x000000bdba00720bULL, 0x004fce0003fdd000ULL,
0x0000006100757306ULL, 0x000ff0000020d400ULL, 0x0000006500937306ULL, 0x000ff00000209400ULL,
0x00000065008e7306ULL, 0x000ff00000205400ULL, 0x0000006500617306ULL, 0x000ff0000020d400ULL,
0x0000006200b37306ULL, 0x000ff00000209400ULL, 0x0000006200b47306ULL, 0x000ff00000205400ULL,
0x00000062007e7306ULL, 0x0003f0000020d400ULL, 0x0000006300b27306ULL, 0x000fe20000209400ULL,
0x00000018ff627819ULL, 0x002fce0000011432ULL, 0x0000006300b17306ULL, 0x000ff00000205400ULL,
0x00000063007c7306ULL, 0x0003f0000020d400ULL, 0x00000092006d7306ULL, 0x000fe20000209400ULL,
0x00000018ff637819ULL, 0x002fce0000011433ULL, 0x00000092006c7306ULL, 0x000ff00000205400ULL,
0x0000009200657306ULL, 0x0003f0000020d400ULL, 0x0000006200a97306ULL, 0x000fe20000209400ULL,
0x000001002d927824ULL, 0x002fca00078e00ffULL, 0x00000018ff987819ULL, 0x000fe40000011492ULL,
0x0000006200a87306ULL, 0x000ff00000205400ULL, 0x0000006200727306ULL, 0x000ff0000020d400ULL,
0x0000006300a57306ULL, 0x000ff00000209400ULL, 0x0000006300a47306ULL, 0x000ff00000205400ULL,
0x00000063006f7306ULL, 0x000ff0000020d400ULL, 0x00000066008f7306ULL, 0x000ff00000209400ULL,
0x00000066008c7306ULL, 0x000ff00000205400ULL, 0x0000006600627306ULL, 0x000ff0000020d400ULL,
0x0000006700807306ULL, 0x000ff00000209400ULL, 0x00000067007f7306ULL, 0x000ff00000205400ULL,
0x0000006700637306ULL, 0x000ff0000020d400ULL, 0x0000009700667306ULL, 0x000ff00000209400ULL,
0x0000009700677306ULL, 0x000ff00000205400ULL, 0x0000009700687306ULL, 0x000ff0000020d400ULL,
0x0000006000847306ULL, 0x0002b0000020d400ULL, 0x0000002c00977306ULL, 0x000ee2000020d400ULL,
0x00000018ff607819ULL, 0x002fce0000011430ULL, 0x0000002d00be7306ULL, 0x000fe20000009400ULL,
0x0000000184845812ULL, 0x004fce00078efcffULL, 0x0000002d00c17306ULL, 0x000e620000005400ULL,
0x0000000197976812ULL, 0x008fce00078efcffULL, 0x0000009800c07306ULL, 0x000ff00000209400ULL,
0x0000009800c37306ULL, 0x000ea20000205400ULL, 0x000000c1be00720bULL, 0x002fce0003fbd000ULL,
0x0000002d00857306ULL, 0x0002f0000000d400ULL, 0x00000098009c7306ULL, 0x000ee2000020d400ULL,
0x000100002d2d7824ULL, 0x002fe200078e00ffULL, 0x000000c3c000720bULL, 0x004fc80003fdd000ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002e00b87306ULL, 0x000fe20000009400ULL,
0x0000000185855812ULL, 0x008fe400078efcffULL, 0x000000aeb900720bULL, 0x000fe20003fbd000ULL,
0x0000010032b97824ULL, 0x000fc800078e00ffULL, 0x0000002d00c27306ULL, 0x000fe20000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x00000018ffb97819ULL, 0x000fca00000114b9ULL,
0x0000002d00c57306ULL, 0x000e620000205400ULL, 0x0000000183835812ULL, 0x000fce00078efcffULL,
0x0000002d00927306ULL, 0x000eb0000020d400ULL, 0x0000002e00b77306ULL, 0x000ee20000005400ULL,
0x000000c5c200720bULL, 0x002fce0003fdd000ULL, 0x00000091002c7306ULL, 0x000fec0000209400ULL,
0x0000000192926812ULL, 0x004fe400078efcffULL, 0x0000009100c77306ULL, 0x000e620000205400ULL,
0x000000b7b800720bULL, 0x008fce0003fbd000ULL, 0x0000002e00827306ULL, 0x0004f0000000d400ULL,
0x0000009100997306ULL, 0x000ee2000020d400ULL, 0x000000c72c00720bULL, 0x002fe20003fdd000ULL,
0x000100002e2e7824ULL, 0x004fc400078e00ffULL, 0x00000100332c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000002f00b67306ULL, 0x000fe20000009400ULL,
0x0000000182825812ULL, 0x008fe400078efcffULL, 0x00000018ffb87819ULL, 0x000fca000001142cULL,
0x0000002f00b57306ULL, 0x000e620000005400ULL, 0x0000000199996812ULL, 0x000fce00078efcffULL,
0x000000c600c87306ULL, 0x000ff00000209400ULL, 0x000000c600c97306ULL, 0x000ea20000205400ULL,
0x000000b5b600720bULL, 0x002fce0003fbd000ULL, 0x0000002f00817306ULL, 0x0002f0000000d400ULL,
0x000000c600987306ULL, 0x000ee2000020d400ULL, 0x000000c9c800720bULL, 0x004fe20003fdd000ULL,
0x000100002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002e002d7306ULL, 0x000fe20000209400ULL, 0x0000000181815812ULL, 0x008fe400078efcffULL,
0x000000b4b300720bULL, 0x000fca0003fbd000ULL, 0x0000002e00c47306ULL, 0x000e620000205400ULL,
0x0000000198986812ULL, 0x000fce00078efcffULL, 0x0000002e009b7306ULL, 0x0004e2000020d400ULL,
0x000000017e7e5812ULL, 0x000fe400078efcffULL, 0x000000b1b200720bULL, 0x000fe20003fbd000ULL,
0x0000010034b17824ULL, 0x000fc800078e00ffULL, 0x0000002f00ca7306ULL, 0x000fe20000209400ULL,
0x000000c42d00720bULL, 0x002fe20003fdd000ULL, 0x00000100312e7824ULL, 0x004fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fc800000114b1ULL, 0x00000018ffbb7819ULL, 0x000fe2000001142eULL,
0x0000002f00cb7306ULL, 0x000e620000205400ULL, 0x000000017c7c5812ULL, 0x000fca00078efcffULL,
0x000000019b9b6812ULL, 0x008fe400078efcffULL, 0x0000002f00917306ULL, 0x000ea4000020d400ULL,
0x0000009b7e7e723eULL, 0x000fcc00000010ffULL, 0x0000003000ab7306ULL, 0x000fe20000009400ULL,
0x000000cbca00720bULL, 0x002fce0003fdd000ULL, 0x0000003000a67306ULL, 0x000e6c0000005400ULL,
0x0000000191916812ULL, 0x004fe400078efcffULL, 0x000000cc00c67306ULL, 0x000ff00000209400ULL,
0x000000cc00cd7306ULL, 0x000ea20000205400ULL, 0x000000a6ab00720bULL, 0x002fce0003fbd000ULL,
0x00000030007b7306ULL, 0x0002f0000000d400ULL, 0x000000cc00967306ULL, 0x000ee2000020d400ULL,
0x000000cdc600720bULL, 0x004fe20003fdd000ULL, 0x0001000030307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000003100a77306ULL, 0x000fe20000009400ULL,
0x000000017b7b5812ULL, 0x008fce00078efcffULL, 0x0000003100a27306ULL, 0x000e620000005400ULL,
0x0000000196966812ULL, 0x000fc800078efcffULL, 0x0000007b9696723eULL, 0x000fc600000010ffULL,
0x000000bb00ce7306ULL, 0x000ff00000209400ULL, 0x000000bb00cf7306ULL, 0x000ea20000205400ULL,
0x000000a2a700720bULL, 0x002fce0003fbd000ULL, 0x0000003100787306ULL, 0x0002f0000000d400ULL,
0x000000bb009f7306ULL, 0x000ee2000020d400ULL, 0x000000cfce00720bULL, 0x004fe20003fdd000ULL,
0x0001000031317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000006000b07306ULL, 0x000fe20000209400ULL, 0x0000000178785812ULL, 0x008fce00078efcffULL,
0x0000006000ad7306ULL, 0x000e620000205400ULL, 0x000000019f9f6812ULL, 0x000fce00078efcffULL,
0x00000030002e7306ULL, 0x000ff00000209400ULL, 0x00000030002f7306ULL, 0x000ea20000205400ULL,
0x000000adb000720bULL, 0x002fce0003fbd000ULL, 0x0000006000797306ULL, 0x000e70000020d400ULL,
0x0000003000aa7306ULL, 0x000ee2000020d400ULL, 0x0000002f2e00720bULL, 0x004fe20003fdd000ULL,
0x00000100372f7824ULL, 0x000fc400078e00ffULL, 0x00000100362e7824ULL, 0x000fc800078e00ffULL,
0x0000003100ba7306ULL, 0x000fe20000209400ULL, 0x0000000179795812ULL, 0x002fe400078efcffULL,
0x000000acaf00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff2e7819ULL, 0x000fc6000001142eULL,
0x0000003100bb7306ULL, 0x000e620000205400ULL, 0x00000001aaaa6812ULL, 0x008fce00078efcffULL,
0x0000003100ae7306ULL, 0x000ea2000020d400ULL, 0x0000000175755812ULL, 0x000fce00078efcffULL,
0x0000003200a37306ULL, 0x000fe20000009400ULL, 0x000000bbba00720bULL, 0x002fce0003fdd000ULL,
0x0000003200a07306ULL, 0x000e6c0000005400ULL, 0x00000001aeae6812ULL, 0x004fe400078efcffULL,
0x000000b900307306ULL, 0x000ff00000209400ULL, 0x000000b900bd7306ULL, 0x000ea20000205400ULL,
0x000000a0a300720bULL, 0x002fce0003fbd000ULL, 0x0000003200747306ULL, 0x0002f0000000d400ULL,
0x000000b900b77306ULL, 0x000ee2000020d400ULL, 0x000000bd3000720bULL, 0x004fe20003fdd000ULL,
0x0001000032327824ULL, 0x002fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe2000001142fULL,
0x00010000362f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000003300a17306ULL, 0x000fe20000009400ULL, 0x0000000174745812ULL, 0x008fe400078efcffULL,
0x00000018ff2f7819ULL, 0x000fca000001142fULL, 0x00000033009e7306ULL, 0x000e620000005400ULL,
0x00000001b7b76812ULL, 0x000fc800078efcffULL, 0x00000074b774723eULL, 0x000fc600000010ffULL,
0x000000b800bc7306ULL, 0x000ff00000209400ULL, 0x000000b800bf7306ULL, 0x000ea20000205400ULL,
0x0000009ea100720bULL, 0x002fce0003fbd000ULL, 0x0000003300717306ULL, 0x0002f0000000d400ULL,
0x000000b800b67306ULL, 0x000ee2000020d400ULL, 0x000000bfbc00720bULL, 0x004fe20003fdd000ULL,
0x0001000033337824ULL, 0x002fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x00000032002c7306ULL, 0x000fe20000209400ULL, 0x0000000171715812ULL, 0x008fe400078efcffULL,
0x000000a8a900720bULL, 0x000fca0003fbd000ULL, 0x0000003200317306ULL, 0x000e620000205400ULL,
0x00000001b6b66812ULL, 0x000fce00078efcffULL, 0x0000003200b37306ULL, 0x000ea2000020d400ULL,
0x0000000172725812ULL, 0x000fe400078efcffULL, 0x000000a4a500720bULL, 0x000fca0003fbd000ULL,
0x00000033002d7306ULL, 0x000fe20000209400ULL, 0x000000312c00720bULL, 0x002fe20003fdd000ULL,
0x00010000372c7824ULL, 0x000fca00078e00ffULL, 0x00000018ffa17819ULL, 0x000fe2000001142cULL,
0x0000003300b47306ULL, 0x000e620000205400ULL, 0x000000016f6f5812ULL, 0x000fe200078efcffULL,
0x00000100282c7824ULL, 0x000fc800078e00ffULL, 0x00000001b3b36812ULL, 0x004fe400078efcffULL,
0x0000003300b27306ULL, 0x0004e2000020d400ULL, 0x00000018ffa47819ULL, 0x000fe4000001142cULL,
0x000000b37272723eULL, 0x000fca00000010ffULL, 0x00000034009d7306ULL, 0x000fe20000009400ULL,
0x000000b42d00720bULL, 0x002fe20003fdd000ULL, 0x0000010035337824ULL, 0x004fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x00000034009a7306ULL, 0x000e6c0000005400ULL,
0x00000001b2b26812ULL, 0x008fe400078efcffULL, 0x000000b100327306ULL, 0x000ff00000209400ULL,
0x000000b100b57306ULL, 0x000ea20000205400ULL, 0x0000009a9d00720bULL, 0x002fce0003fbd000ULL,
0x00000034006e7306ULL, 0x0002f0000000d400ULL, 0x000000b100ab7306ULL, 0x000ee2000020d400ULL,
0x0001000034347824ULL, 0x002fe200078e00ffULL, 0x000000b53200720bULL, 0x004fc80003fdd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006400957306ULL, 0x000fe20000209400ULL,
0x000000016e6e5812ULL, 0x008fce00078efcffULL, 0x0000006400907306ULL, 0x000e620000205400ULL,
0x00000001abab6812ULL, 0x000fc800078efcffULL, 0x0000006eab6e723eULL, 0x000fc600000010ffULL,
0x0000003400a67306ULL, 0x000ff00000209400ULL, 0x0000003400b97306ULL, 0x000ea20000205400ULL,
0x000000909500720bULL, 0x002fce0003fbd000ULL, 0x00000035008d7306ULL, 0x000ff00000009400ULL,
0x00000035008a7306ULL, 0x000fe20000005400ULL, 0x000000b9a600720bULL, 0x004fce0003fdd000ULL,
0x00000035004a7306ULL, 0x0003f0000000d400ULL, 0x0000006400607306ULL, 0x000ea2000020d400ULL,
0x0001000035357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400a77306ULL, 0x000e70000020d400ULL, 0x0000003300b17306ULL, 0x000fe20000209400ULL,
0x0000000160605812ULL, 0x004fc400078efcffULL, 0x0000008a8d00720bULL, 0x000fca0003fbd000ULL,
0x0000003300b87306ULL, 0x000ea20000205400ULL, 0x00000001a7a76812ULL, 0x002fc800078efcffULL,
0x000000a76060723eULL, 0x000fc600000010ffULL, 0x0000003600887306ULL, 0x000fe20000009400ULL,
0x000000014a4a5812ULL, 0x000fce00078efcffULL, 0x0000003600877306ULL, 0x000fe20000005400ULL,
0x000000b8b100720bULL, 0x004fce0003fdd000ULL, 0x00000036004c7306ULL, 0x000ff0000000d400ULL,
0x00000037008b7306ULL, 0x000ff00000009400ULL, 0x0000003700867306ULL, 0x000ff00000005400ULL,
0x00000037004d7306ULL, 0x000ff0000000d400ULL, 0x0000003500347306ULL, 0x000ff00000209400ULL,
0x0000003500c17306ULL, 0x000e700000205400ULL, 0x0000003500a27306ULL, 0x000eb0000020d400ULL,
0x0000003300ad7306ULL, 0x000ee2000020d400ULL, 0x000000c13400720bULL, 0x002fce0003fbd000ULL,
0x0000002e00ac7306ULL, 0x000fec0000209400ULL, 0x00000001a2a25812ULL, 0x004fe400078efcffULL,
0x0000002e00af7306ULL, 0x000fe20000205400ULL, 0x00000001adad6812ULL, 0x008fe400078efcffULL,
0x0000008e9300720bULL, 0x000fc40003fdd000ULL, 0x000000878800720bULL, 0x000fc60003fbd000ULL,
0x0000002e00a37306ULL, 0x000ff0000020d400ULL, 0x0000003000b07306ULL, 0x000fe20000209400ULL,
0x0000000161616812ULL, 0x000fe400078efcffULL, 0x000000014c4c5812ULL, 0x000fc400078efcffULL,
0x000000a26161723eULL, 0x000fc600000010ffULL, 0x0000003000bb7306ULL, 0x000e700000205400ULL,
0x0000003000367306ULL, 0x0004f0000020d400ULL, 0x0000002f00357306ULL, 0x000fe20000209400ULL,
0x012000004930783bULL, 0x004ea20000000200ULL, 0x000000bbb000720bULL, 0x002fcc0003fdd000ULL,
0x0000002f00a07306ULL, 0x000e6e0000205400ULL, 0x0000000136366812ULL, 0x008fe200078efcffULL,
0x0000002f00377306ULL, 0x0006a2000020d400ULL, 0x0000008c8f00720bULL, 0x000fce0003fdd000ULL,
0x000000a100a87306ULL, 0x000fe20000209400ULL, 0x012000004f2c783bULL, 0x008ee20000000200ULL,
0x000000a03500720bULL, 0x002fe40003fbd000ULL, 0x000000928335723eULL, 0x000fe400000010ffULL,
0x0000000162626812ULL, 0x000fe400078efcffULL, 0x000000a100a57306ULL, 0x000fee0000205400ULL,
0x0000000137375812ULL, 0x004fe200078efcffULL, 0x000000a4009a7306ULL, 0x000fe20000209400ULL,
0x0000004730308231ULL, 0x080fe200003400ffULL, 0x0000007f8000720bULL, 0x000fe20003fbd000ULL,
0x0000004732328231ULL, 0x080fe200003400ffULL, 0x000000917c7f723eULL, 0x000fe200000010ffULL,
0x0000004831318231ULL, 0x080fe200003400ffULL, 0x000000376262723eULL, 0x000fe200000010ffULL,
0x0000004833338231ULL, 0x080fe200003400ffULL, 0x000000a400a97306ULL, 0x000e6c0000205400ULL,
0x0000007e3010723cULL, 0x000f620000041810ULL, 0x0000000163635812ULL, 0x000fe200078efcffULL,
0x000000a1009e7306ULL, 0x0005f0000020d400ULL, 0x000000a4009d7306ULL, 0x000e62000020d400ULL,
0x000000472c2c8231ULL, 0x088fe200003400ffULL, 0x0000010029a17824ULL, 0x004fe200078e00ffULL,
0x000000472e2e8231ULL, 0x000fe200003400ffULL, 0x000000a99a00720bULL, 0x002fe20003fdd000ULL,
0x000000482d2d8231ULL, 0x000fc400003400ffULL, 0x000000482f2f8231ULL, 0x000fe200003400ffULL,
0x000000afac00720bULL, 0x000fe20003f1d000ULL, 0x00000028007a7306ULL, 0x000fe20000009400ULL,
0x00000018ff907819ULL, 0x000fce00000114a1ULL, 0x00000028007d7306ULL, 0x000fe20000005400ULL,
0x000000019d9d6812ULL, 0x000fc600078efcffULL, 0x00000001a3a30812ULL, 0x000fe400078efcffULL,
0x000000868b00720bULL, 0x000fe40003f1d000ULL, 0x0000002900767306ULL, 0x000fe20000009400ULL,
0x0000004ca34c723eULL, 0x000fce00000010ffULL, 0x0000002900777306ULL, 0x000e660000005400ULL,
0x000000014d4d0812ULL, 0x000fe400078efcffULL, 0x000000a5a800720bULL, 0x000fe40003f1d000ULL,
0x0000004d364d723eULL, 0x000fe200000010ffULL, 0x0000009000a67306ULL, 0x000ff00000209400ULL,
0x0000009000b57306ULL, 0x000ea20000205400ULL, 0x000000777600720bULL, 0x002fc40003fbd000ULL,
0x000000019e9e0812ULL, 0x000fe400078efcffULL, 0x0000007d7a00720bULL, 0x000fe40003f1d000ULL,
0x0000009e6363723eULL, 0x000fe200000010ffULL, 0x00000028004e7306ULL, 0x0002ec000000d400ULL,
0x000000622c10723cULL, 0x020fe40000041810ULL, 0x0000002900547306ULL, 0x0006e2000000d400ULL,
0x0001000028287824ULL, 0x002fe200078e00ffULL, 0x000000b5a600720bULL, 0x004fc80003fdd000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000009000957306ULL, 0x000e62000020d400ULL,
0x0001000029297824ULL, 0x008fe200078e00ffULL, 0x000000014e4e0812ULL, 0x000fc800078efcffULL,
0x00000018ff347819ULL, 0x000fe20000011429ULL, 0x000001002a297824ULL, 0x000fe200078e00ffULL,
0x0000006b00707306ULL, 0x000fe20000209400ULL, 0x0000000154545812ULL, 0x000fc600078efcffULL,
0x00000018ff867819ULL, 0x000fe40000011429ULL, 0x000000859c29723eULL, 0x000fe400000010ffULL,
0x0000006b00737306ULL, 0x000ea20000205400ULL, 0x0000000195956812ULL, 0x002fc800078efcffULL,
0x000000549595723eULL, 0x000fc600000010ffULL, 0x00000028008a7306ULL, 0x000ff00000209400ULL,
0x0000002800a17306ULL, 0x000e620000205400ULL, 0x000000737000720bULL, 0x004fe40003fdd000ULL,
0x000000b26f73723eULL, 0x000fc400000010ffULL, 0x0000004aad6f723eULL, 0x000fc600000010ffULL,
0x00000034008e7306ULL, 0x000fe40000209400ULL, 0x000000723020723cULL, 0x000fec0000041820ULL,
0x0000003400937306ULL, 0x000ea20000205400ULL, 0x000000a18a00720bULL, 0x002fce0003f1d000ULL,
0x00000028008d7306ULL, 0x0002f0000020d400ULL, 0x0000003400887306ULL, 0x0006e2000020d400ULL,
0x000000899428723eULL, 0x002fe400000010ffULL, 0x000000938e00720bULL, 0x004fc40003fbd000ULL,
0x0000004e9d94723eULL, 0x000fc600000010ffULL, 0x000000283004723cULL, 0x040b620000041804ULL,
0x000000978434723eULL, 0x008fe200000010ffULL, 0x0000006b00647306ULL, 0x000e62000020d400ULL,
0x000000018d8d0812ULL, 0x000fe400078efcffULL, 0x0000006c6d00720bULL, 0x000fe40003f1d000ULL,
0x000000829928723eULL, 0x020fe200000010ffULL, 0x000000343008723cULL, 0x000b620000041808ULL,
0x000000819829723eULL, 0x000fe200000010ffULL, 0x0000002a00587306ULL, 0x000fe20000009400ULL,
0x0000000188885812ULL, 0x000fc400078efcffULL, 0x000000789f97723eULL, 0x000fe400000010ffULL,
0x000001002b347824ULL, 0x020fe200078e00ffULL, 0x00000028300c723cULL, 0x040b64000004180cULL,
0x0000002a00597306ULL, 0x000ea20000005400ULL, 0x0000000164646812ULL, 0x002fe400078efcffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x000000aa7928723eULL, 0x020fe200000010ffULL,
0x000000963014723cULL, 0x000f620000041814ULL, 0x000000ae7529723eULL, 0x000fe200000010ffULL,
0x0000008600857306ULL, 0x000fe20000209400ULL, 0x00000071b675723eULL, 0x000fc400000010ffULL,
0x0000000165650812ULL, 0x000fe400078efcffULL, 0x0000008d6464723eULL, 0x000fe200000010ffULL,
0x000000283018723cULL, 0x000f620000041818ULL, 0x000000886565723eULL, 0x000fe200000010ffULL,
0x0000008600847306ULL, 0x000e620000205400ULL, 0x000000595800720bULL, 0x004fca0003fdd000ULL,
0x00000074301c723cULL, 0x000f64000004181cULL, 0x0000002a005c7306ULL, 0x0004ec000000d400ULL,
0x0000006e2c04723cULL, 0x000b640000041804ULL, 0x0000008600357306ULL, 0x000ee2000020d400ULL,
0x000100002a2a7824ULL, 0x004fe200078e00ffULL, 0x000000848500720bULL, 0x002fc80003fbd000ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000000602c08723cULL, 0x000b620000041808ULL,
0x0000002b005d7306ULL, 0x000fe20000009400ULL, 0x000000015c5c6812ULL, 0x008fcc00078efcffULL,
0x0000004c2c0c723cULL, 0x000b62000004180cULL, 0x0000002b005e7306ULL, 0x000e620000005400ULL,
0x0000000135355812ULL, 0x000fc800078efcffULL, 0x0000005c355c723eULL, 0x000fe400000010ffULL,
0x000000942c14723cULL, 0x060b620000041814ULL, 0x00000034007c7306ULL, 0x000fee0000209400ULL,
0x000000642c18723cULL, 0x000b620000041818ULL, 0x0000003400777306ULL, 0x000ea20000205400ULL,
0x0000005e5d00720bULL, 0x002fce0003fbd000ULL, 0x0000002a00287306ULL, 0x000ff00000209400ULL,
0x0000002a00297306ULL, 0x000e620000205400ULL, 0x000000777c00720bULL, 0x004fce0003f1d000ULL,
0x0000003400767306ULL, 0x0004f0000020d400ULL, 0x0000002b005f7306ULL, 0x000ee2000000d400ULL,
0x000100002b347824ULL, 0x004fe200078e00ffULL, 0x000000292800720bULL, 0x002fc40003fdd000ULL,
0x000176c827287811ULL, 0x000fe400078e18ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000002a002b7306ULL, 0x000e62000020d400ULL, 0x0000000176760812ULL, 0x008fe400078efcffULL,
0x000000676600720bULL, 0x000fca0003f1d000ULL, 0x00000069006a7306ULL, 0x000fe20000209400ULL,
0x000000015f5f5812ULL, 0x000fc800078efcffULL, 0x0000005f765d723eULL, 0x000fc600000010ffULL,
0x00000069006b7306ULL, 0x000ea20000205400ULL, 0x000000012b2b6812ULL, 0x002fe400078efcffULL,
0x0000000168680812ULL, 0x000fe200078efcffULL, 0x0000005c2c1c723cULL, 0x000b66000004181cULL,
0x0000002b6868723eULL, 0x000fe200000010ffULL, 0x0000003400307306ULL, 0x000ff00000209400ULL,
0x0000003400317306ULL, 0x000e620000205400ULL, 0x0000006b6a00720bULL, 0x004fce0003fbd000ULL,
0x0000006900697306ULL, 0x000eb0000020d400ULL, 0x0000003400347306ULL, 0x000ee2000020d400ULL,
0x000000313000720bULL, 0x002fe40003fdd000ULL, 0x0000000169695812ULL, 0x004fd600078efcffULL,
0x0000000134346812ULL, 0x008fc800078efcffULL, 0x000000346969723eULL, 0x000fce00000010ffULL,
0x000000682c20723cULL, 0x000b620000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000028287f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c03c2b7811ULL, 0x000fe200078e40ffULL,
0x0176980050ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff2e7224ULL, 0x022fe200078e0029ULL,
0x000000023e547810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200078e0040ULL,
0x000000022b00720cULL, 0x000fe20003f06070ULL, 0x000000ffff587224ULL, 0x000fe400078e0043ULL,
0x000000ffff597224ULL, 0x000fd400078e005bULL, 0x0000356000000947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x004fc40000015200ULL, 0x000004003f2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780482eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x0000002d2a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004003f2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe4000780482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000023c297810ULL, 0x040fe20007ffe0ffULL,
0x000001003c287824ULL, 0x000fe400078e0239ULL, 0x00005800262a7a24ULL, 0x010fe200078e02ffULL,
0x000000242900720cULL, 0x000fe40003f06070ULL, 0x00000100282b7810ULL, 0x000fe20007ffe0ffULL,
0x000000802a317824ULL, 0x000fc600078e00ffULL, 0x00000060382f7812ULL, 0x000fce00078ef82bULL,
0x0000048000008947ULL, 0x000fea0003800000ULL, 0x0000001000287824ULL, 0x000fe200078e00ffULL,
0x00000003ff307819ULL, 0x000fe20000011625ULL, 0x00000010252c7824ULL, 0x000fc600078e00ffULL,
0x0000001028337812ULL, 0x000fe400078ec0ffULL, 0x0000002b02287217ULL, 0x000fe40007800000ULL,
0x0000000430347810ULL, 0x040fe20007ffe0ffULL, 0x00000001302e7824ULL, 0x000fe200078e0233ULL,
0x000000702c377812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x000fe200078e0a2bULL,
0x0000000c30357810ULL, 0x000fe20007ffe0ffULL, 0x000000012e297824ULL, 0x000fe400078e022fULL,
0x0000000134367824ULL, 0x000fe200078e0233ULL, 0x0000002833287217ULL, 0x000fe20007800000ULL,
0x000000082e327824ULL, 0x000fe200078e00ffULL, 0x00000029312a7210ULL, 0x000fe20007f1e0ffULL,
0x00000008363f7824ULL, 0x000fc400078e00ffULL, 0x00000001282c7824ULL, 0x000fe400078e0a33ULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x00005e002a297a11ULL, 0x000fe200078038ffULL,
0x0000000136287824ULL, 0x000fc600078e022fULL, 0x00005f002a2a7a11ULL, 0x000fe200000f3c2bULL,
0x000000012e2b7824ULL, 0x000fe200078e0225ULL, 0x00000028312e7210ULL, 0x000fe40007fde0ffULL,
0x0000003729287210ULL, 0x000fe40007fbe0ffULL, 0x0000002c3000720cULL, 0x080fe40003f06070ULL,
0xfffffff832327812ULL, 0x000fe200078ee22bULL, 0x000000ffff297224ULL, 0x000fe200028e062aULL,
0x0000002c3400720cULL, 0x000fe20003fa6070ULL, 0x000000ffff2b7224ULL, 0x000fe200030e06ffULL,
0x0000000830347810ULL, 0x000fe20007ffe0ffULL, 0x00000010322d7824ULL, 0x000fe200078e024bULL,
0x00005e002e2a7a11ULL, 0x000fe200078c38ffULL, 0x0000000136327824ULL, 0x000fc400078e0225ULL,
0x0000000134407824ULL, 0x000fe200078e0233ULL, 0x00005f002e2e7a11ULL, 0x000fe200030f3c2bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0003e2000c101c46ULL,
0x000000372a2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001402b7824ULL, 0x000fe200078e022fULL,
0xfffffff83f327812ULL, 0x000fe200078ee232ULL, 0x0000000135367824ULL, 0x000fc600078e0233ULL,
0x0000002b31307210ULL, 0x040fe20007fde0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e062eULL,
0x0000002c3400720cULL, 0x000fe20003f06070ULL, 0x00000010322d7824ULL, 0x002fe400078e024bULL,
0x0000000136287824ULL, 0x000fe400078e022fULL, 0x000000ffff2f7224ULL, 0x000fe200030e06ffULL,
0x000000002a2d7faeULL, 0x0003e2000e901c46ULL, 0x00005e0030297a11ULL, 0x000fe400078a38ffULL,
0x00000028312e7210ULL, 0x000fe20007fde0ffULL, 0x0000000840317824ULL, 0x000fe200078e00ffULL,
0x00005f0030307a11ULL, 0x000fc400028f3c2fULL, 0x0000002c3500720cULL, 0x000fe20003fa6070ULL,
0x000000ffff2f7224ULL, 0x000fe200030e06ffULL, 0x0000003729287210ULL, 0x000fe20007fde0ffULL,
0x00000001402c7824ULL, 0x100fe400078e0225ULL, 0x00000001362d7824ULL, 0x002fe400078e0225ULL,
0x000000ffff297224ULL, 0x000fe200030e0630ULL, 0x00005e002e2a7a11ULL, 0x000fe200078c38ffULL,
0x0000000836367824ULL, 0x000fe200078e00ffULL, 0xfffffff8312c7812ULL, 0x000fc400078ee22cULL,
0x00005f002e2b7a11ULL, 0x000fe400030f3c2fULL, 0x000000372a2a7210ULL, 0x000fe40007fde0ffULL,
0xfffffff8362e7812ULL, 0x000fe200078ee22dULL, 0x000000102c2d7824ULL, 0x000fe400078e024bULL,
0x000000ffff2b7224ULL, 0x000fe400030e062bULL, 0x000000102e4b7824ULL, 0x000fe200078e024bULL,
0x00000000282d7faeULL, 0x0003e8000c101c46ULL, 0x000000002a4b7faeULL, 0x0003e2000e901c46ULL,
0x000003b000007947ULL, 0x000fea0003800000ULL, 0x0000001000287824ULL, 0x000fe400078e00ffULL,
0x0000001025377824ULL, 0x000fc600078e00ffULL, 0x0000001028287812ULL, 0x000fe400078ec0ffULL,
0x0000007037377812ULL, 0x000fe400078ec0ffULL, 0x00000028252a7211ULL, 0x000fc800078fe8ffULL,
0x000000042a2c7810ULL, 0x040fe20007ffe0ffULL, 0x000000012a287824ULL, 0x040fe200078e022fULL,
0x000000082a2e7810ULL, 0x040fe20007ffe0ffULL, 0x000000012a297824ULL, 0x040fe400078e0225ULL,
0x000000082a367824ULL, 0x000fe200078e00ffULL, 0x0000002831347210ULL, 0x040fe20007f1e0ffULL,
0x000000012c287824ULL, 0x040fe400078e022fULL, 0x000000012c2b7824ULL, 0x000fe200078e0225ULL,
0xfffffff836367812ULL, 0x000fe200078ee229ULL, 0x000000ffff297224ULL, 0x000fe200000e06ffULL,
0x00005e0034327a11ULL, 0x000fe200078038ffULL, 0x000000082c407824ULL, 0x000fe200078e00ffULL,
0x0000000c2a2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000012e2a7824ULL, 0x000fe200078e0225ULL,
0x00005f0034347a11ULL, 0x000fe200000f3c29ULL, 0x000000012e297824ULL, 0x100fe200078e022fULL,
0x0000002831307210ULL, 0x040fe20007f1e0ffULL, 0x000000012c287824ULL, 0x000fe200078e022fULL,
0xfffffff840407812ULL, 0x000fe200078ee22bULL, 0x000000082e2f7824ULL, 0x000fe200078e00ffULL,
0x0000002931297210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e06ffULL,
0x00005e00302b7a11ULL, 0x000fe200078038ffULL, 0x000000082c4c7824ULL, 0x000fe200078e00ffULL,
0x0000002831287210ULL, 0x000fe20007fde0ffULL, 0x0000001036317824ULL, 0x000fe200078e024bULL,
0x00005f0030307a11ULL, 0x000fe200000f3c2dULL, 0x000000012c2d7824ULL, 0x000fe200078e0225ULL,
0xfffffff82f4a7812ULL, 0x000fe200078ee22aULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x00005e00292c7a11ULL, 0x040fe200078038ffULL, 0x000000ffff2f7224ULL, 0x000fe200030e06ffULL,
0x00005e00282e7a11ULL, 0x000fe200078a38ffULL, 0x0000001040337824ULL, 0x000fe200078e024bULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee22dULL, 0x000000104a357824ULL, 0x000fe200078e024bULL,
0x00005f00292d7a11ULL, 0x000fc400000f3c2aULL, 0x00005f00282f7a11ULL, 0x000fe200028f3c2fULL,
0x000000104c4b7824ULL, 0x000fe200078e024bULL, 0x0000003732287210ULL, 0x080fe40007f1e0ffULL,
0x000000372b2a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe200000e0634ULL,
0x000000372c2c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200028e0630ULL,
0x000000372e2e7210ULL, 0x000fe40007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2d7224ULL, 0x000fe400000e062dULL,
0x000000ffff2f7224ULL, 0x000fe200028e062fULL, 0x000000002a337faeULL, 0x0003e8000b901c46ULL,
0x000000002c357faeULL, 0x0003e8000b901c46ULL, 0x000000002e4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000560403c2ULL, 0x000e640000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x002fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80055587f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01766800422c7f8cULL, 0x000664000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x01766c00422b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x012fc4000780482dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x0000002f2a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c00422b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018037447810ULL, 0x000fca0007ffe044ULL, 0x0000000145447824ULL, 0x000fca00078e0244ULL,
0x0170000044287984ULL, 0x000e680000000800ULL, 0x0172000044297984ULL, 0x0006a20000000800ULL,
0x000000432800720bULL, 0x002fe20003f1d000ULL, 0x0000bbe27f007947ULL, 0x000fd8000b800000ULL,
0x00000000002a7806ULL, 0x008fc800000e0100ULL, 0x0000ffff2a2e7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff587224ULL, 0x004fd200078e0043ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x00000003002b7811ULL, 0x000fe400078ff0ffULL, 0x000000432800720bULL, 0x000fe40003f14000ULL,
0x000000002b00720cULL, 0x000fe20003fa5270ULL, 0x0000bba27f007947ULL, 0x000fd4000b800000ULL,
0x00000000002d7806ULL, 0x000fc400000e0100ULL, 0x00000080002ad824ULL, 0x000fe200078e0237ULL,
0x0000004328587209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000014545d824ULL, 0x000fe200078e022aULL, 0x000099102d2a7816ULL, 0x000fc800000000ffULL,
0x017400584500d388ULL, 0x0003e20000000800ULL, 0x000000ff2a00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x00000043582a7221ULL, 0x002fe20000010100ULL,
0x000000ff2dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b2a2a7820ULL, 0x000fc80000410000ULL, 0x0000002a002f7308ULL, 0x000e640000000800ULL,
0x0000002f3a3a7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff2a7819ULL, 0x000fe20000011625ULL, 0x0000bae27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a2f2a7589ULL, 0x0002a400000e0000ULL, 0x0000002a04047220ULL, 0x084fe40000410000ULL,
0x0000002a05057220ULL, 0x080fe40000410000ULL, 0x0000002a08087220ULL, 0x080fe40000410000ULL,
0x0000002a09097220ULL, 0x080fe40000410000ULL, 0x0000002a0c0c7220ULL, 0x080fe40000410000ULL,
0x0000002a0d0d7220ULL, 0x000fc40000410000ULL, 0x0000002a10107220ULL, 0x080fe40000410000ULL,
0x0000002a11117220ULL, 0x080fe40000410000ULL, 0x0000002a14147220ULL, 0x080fe40000410000ULL,
0x0000002a15157220ULL, 0x080fe40000410000ULL, 0x0000002a18187220ULL, 0x080fe40000410000ULL,
0x0000002a19197220ULL, 0x000fc40000410000ULL, 0x0000002a1c1c7220ULL, 0x080fe40000410000ULL,
0x0000002a1d1d7220ULL, 0x080fe40000410000ULL, 0x0000002a20207220ULL, 0x080fe40000410000ULL,
0x0000002a21217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff002dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008252a7811ULL, 0x000fe200078ff0ffULL, 0x0000b9f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a2f2a7589ULL, 0x0004e400000e0000ULL, 0x0000002a06067220ULL, 0x088fe40000410000ULL,
0x0000002a07077220ULL, 0x080fe40000410000ULL, 0x0000002a0a0a7220ULL, 0x080fe40000410000ULL,
0x0000002a0b0b7220ULL, 0x080fe40000410000ULL, 0x0000002a0e0e7220ULL, 0x080fe40000410000ULL,
0x0000002a0f0f7220ULL, 0x000fc40000410000ULL, 0x0000002a12127220ULL, 0x080fe40000410000ULL,
0x0000002a13137220ULL, 0x080fe40000410000ULL, 0x0000002a16167220ULL, 0x080fe40000410000ULL,
0x0000002a17177220ULL, 0x080fe40000410000ULL, 0x0000002a1a1a7220ULL, 0x080fe40000410000ULL,
0x0000002a1b1b7220ULL, 0x000fc40000410000ULL, 0x0000002a1e1e7220ULL, 0x080fe40000410000ULL,
0x0000002a1f1f7220ULL, 0x080fe40000410000ULL, 0x0000002a22227220ULL, 0x080fe40000410000ULL,
0x0000002a23237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2eff7812ULL, 0x000fda000780602dULL, 0x0000002858280221ULL, 0x000fe20000010100ULL,
0x00007610ff2c0816ULL, 0x000fc6000000002cULL, 0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL,
0x0000002800460308ULL, 0x000e640000000800ULL, 0x0000004629290220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003a293a7221ULL, 0x000fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0176ac00412b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x0000002d2a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac00412b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099102c287816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff2800720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000046ff28723eULL, 0x000fe400000010ffULL,
0x00000002ff297819ULL, 0x000fe40000011625ULL, 0x0000541028287816ULL, 0x000fe20000000028ULL,
0x0000b6127f007947ULL, 0x000fea000b800000ULL, 0x00001f2928477589ULL, 0x0002e400000e0000ULL,
0x00000008292a7810ULL, 0x000fe20007ffe0ffULL, 0x0000b6627f007947ULL, 0x000fea000b800000ULL,
0x00001f2a28487589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010292a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0028ULL,
0x0000d18000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x0000bc0000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018292a7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x004fe200078e0028ULL, 0x0000d1f000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x0000bb9000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005754783bULL, 0x000f280000004200ULL,
0x00000000532c783bULL, 0x004ea80000004200ULL, 0x000000005230783bULL, 0x000e680000004200ULL,
0x000000005128783bULL, 0x0022e20000004200ULL, 0x00000018ff4b7819ULL, 0x010fe20000011455ULL,
0x0000010054887824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x002fe20000011456ULL,
0x00000054008a7306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x000fe20000011454ULL,
0x000001002cbe7824ULL, 0x004fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fc40000011488ULL,
0x00000018ff537819ULL, 0x000fe40000011432ULL, 0x00000018ff527819ULL, 0x000fe20000011457ULL,
0x0000004b00ae7306ULL, 0x000fe20000209400ULL, 0x00000018ff897819ULL, 0x008fe40000011429ULL,
0x00000018ff8b7819ULL, 0x000fe4000001142aULL, 0x00000018ffbe7819ULL, 0x000fe400000114beULL,
0x00000018ff5d7819ULL, 0x000fe20000011428ULL, 0x0000004b00b17306ULL, 0x000fe20000205400ULL,
0x00000018ff5e7819ULL, 0x000fce000001142bULL, 0x0000004b00787306ULL, 0x0003f0000020d400ULL,
0x0000005100a17306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x002fce000001142dULL,
0x0000005100a47306ULL, 0x000ff00000205400ULL, 0x0000005100737306ULL, 0x0003f0000020d400ULL,
0x0000004b009d7306ULL, 0x000fe20000209400ULL, 0x00000018ff517819ULL, 0x002fce000001142eULL,
0x0000004b009a7306ULL, 0x000ff00000205400ULL, 0x0000004b006a7306ULL, 0x0003f0000020d400ULL,
0x00000054009f7306ULL, 0x000ea20000005400ULL, 0x00000018ff4b7819ULL, 0x002fce0000011431ULL,
0x0000008800907306ULL, 0x000ff00000209400ULL, 0x0000008800a57306ULL, 0x000e620000205400ULL,
0x0000009f8a00720bULL, 0x004fce0003fbd000ULL, 0x0000005100977306ULL, 0x000ff00000209400ULL,
0x0000005100967306ULL, 0x000fe20000205400ULL, 0x000000a59000720bULL, 0x002fe20003fdd000ULL,
0x000001002d907824ULL, 0x000fca00078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011490ULL,
0x0000005100687306ULL, 0x000ff0000020d400ULL, 0x0000004b00877306ULL, 0x000ff00000209400ULL,
0x0000004b00847306ULL, 0x000ff00000205400ULL, 0x0000004b00517306ULL, 0x000ff0000020d400ULL,
0x0000008900637306ULL, 0x000ff00000209400ULL, 0x0000008900627306ULL, 0x000ff00000205400ULL,
0x00000089004b7306ULL, 0x0003f0000020d400ULL, 0x00000054007b7306ULL, 0x000ea2000000d400ULL,
0x0001000054897824ULL, 0x002fca00078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe20000011489ULL,
0x0000010055897824ULL, 0x000fe200078e00ffULL, 0x0000008800547306ULL, 0x0002e8000020d400ULL,
0x00000018ffa87819ULL, 0x000fc80000011489ULL, 0x0000004a00a07306ULL, 0x000fe20000209400ULL,
0x000000017b7b5812ULL, 0x004fe200078efcffULL, 0x0000010056887824ULL, 0x002fca00078e00ffULL,
0x00000018ffb27819ULL, 0x000fe20000011488ULL, 0x0000004a00a97306ULL, 0x000e620000205400ULL,
0x0000000154546812ULL, 0x008fce00078efcffULL, 0x0000004a007a7306ULL, 0x0004f0000020d400ULL,
0x0000008f009e7306ULL, 0x000fe20000209400ULL, 0x00000018ff4a7819ULL, 0x004fe4000001142cULL,
0x000000a9a000720bULL, 0x002fe20003fbd000ULL, 0x000001002fa07824ULL, 0x000fc800078e00ffULL,
0x0000008f00a77306ULL, 0x000e700000205400ULL, 0x0000004a009c7306ULL, 0x000fe20000209400ULL,
0x000000017a7a5812ULL, 0x008fce00078efcffULL, 0x0000004a009b7306ULL, 0x000fe20000205400ULL,
0x000000a79e00720bULL, 0x002fe20003fdd000ULL, 0x000001002e9e7824ULL, 0x000fca00078e00ffULL,
0x00000018ffa97819ULL, 0x000fe2000001149eULL, 0x0000004a006e7306ULL, 0x0003f0000020d400ULL,
0x0000005300837306ULL, 0x000fe20000209400ULL, 0x00000018ff4a7819ULL, 0x002fce0000011430ULL,
0x0000004a00867306ULL, 0x000ff00000209400ULL, 0x0000004a00857306ULL, 0x000ff00000205400ULL,
0x0000004a00607306ULL, 0x000ff0000020d400ULL, 0x0000005300827306ULL, 0x000ff00000205400ULL,
0x00000053005f7306ULL, 0x000ff0000020d400ULL, 0x0000008b00537306ULL, 0x000ff00000209400ULL,
0x0000008b004a7306ULL, 0x000ff00000205400ULL, 0x0000008b005b7306ULL, 0x000ff0000020d400ULL,
0x0000008f008b7306ULL, 0x0002b0000020d400ULL, 0x0000005500a67306ULL, 0x000fe20000009400ULL,
0x00000100578f7824ULL, 0x002fca00078e00ffULL, 0x00000018ffba7819ULL, 0x000fe4000001148fULL,
0x0000005500ab7306ULL, 0x000e620000005400ULL, 0x000000018b8b6812ULL, 0x004fc800078efcffULL,
0x0000008b7a7a723eULL, 0x000fc600000010ffULL, 0x000000a800aa7306ULL, 0x000ff00000209400ULL,
0x000000a800ad7306ULL, 0x000ea20000205400ULL, 0x000000aba600720bULL, 0x002fce0003fbd000ULL,
0x0000005500797306ULL, 0x0002f0000000d400ULL, 0x000000a8008e7306ULL, 0x000f22000020d400ULL,
0x0001000055557824ULL, 0x002fe200078e00ffULL, 0x000000adaa00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005600b07306ULL, 0x000fe20000009400ULL,
0x0000000179795812ULL, 0x008fe400078efcffULL, 0x000000b1ae00720bULL, 0x000fca0003fbd000ULL,
0x0000005500ac7306ULL, 0x000fe20000209400ULL, 0x000000018e8e6812ULL, 0x010fce00078efcffULL,
0x0000005500af7306ULL, 0x000e620000205400ULL, 0x0000000178785812ULL, 0x000fce00078efcffULL,
0x0000005500897306ULL, 0x000eb0000020d400ULL, 0x0000005600b37306ULL, 0x000ee20000005400ULL,
0x000000afac00720bULL, 0x002fe40003fdd000ULL, 0x00000018ffac7819ULL, 0x000fca00000114a0ULL,
0x000000b200b47306ULL, 0x000fec0000209400ULL, 0x0000000189896812ULL, 0x004fe400078efcffULL,
0x000000b200b57306ULL, 0x000e620000205400ULL, 0x000000b3b000720bULL, 0x008fce0003fbd000ULL,
0x0000005600777306ULL, 0x0004f0000000d400ULL, 0x000000b200887306ULL, 0x000f22000020d400ULL,
0x000000b5b400720bULL, 0x002fe20003fdd000ULL, 0x0001000056567824ULL, 0x004fca00078e00ffULL,
0x00000018ffa87819ULL, 0x000fe20000011456ULL, 0x0000005700b87306ULL, 0x000fe20000009400ULL,
0x0000000177775812ULL, 0x008fce00078efcffULL, 0x0000005700b97306ULL, 0x000e620000005400ULL,
0x0000000188886812ULL, 0x010fc800078efcffULL, 0x000000778888723eULL, 0x000fc600000010ffULL,
0x000000ba00bb7306ULL, 0x000ff00000209400ULL, 0x000000ba00bc7306ULL, 0x000ea20000205400ULL,
0x000000b9b800720bULL, 0x002fce0003fbd000ULL, 0x0000005700767306ULL, 0x0002f0000000d400ULL,
0x000000ba008f7306ULL, 0x000f22000020d400ULL, 0x000000bcbb00720bULL, 0x004fe20003fdd000ULL,
0x0001000057577824ULL, 0x002fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x000000a800b67306ULL, 0x000fe20000209400ULL, 0x0000000176765812ULL, 0x008fe400078efcffULL,
0x000000a4a100720bULL, 0x000fca0003fbd000ULL, 0x000000a800b77306ULL, 0x000e620000205400ULL,
0x000000018f8f6812ULL, 0x010fce00078efcffULL, 0x000000a800567306ULL, 0x000ea2000020d400ULL,
0x0000000173735812ULL, 0x000fce00078efcffULL, 0x0000005200a37306ULL, 0x000fe20000209400ULL,
0x000000b7b600720bULL, 0x002fce0003fdd000ULL, 0x0000005200a27306ULL, 0x000e6c0000205400ULL,
0x0000000156566812ULL, 0x004fe400078efcffULL, 0x0000005700b27306ULL, 0x000ff00000209400ULL,
0x0000005700bd7306ULL, 0x000ea20000205400ULL, 0x000000a2a300720bULL, 0x002fe20003fbd000ULL,
0x0000010030a27824ULL, 0x000fca00078e00ffULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x0000005200727306ULL, 0x0002f0000020d400ULL, 0x0000005700557306ULL, 0x000f22000020d400ULL,
0x000000bdb200720bULL, 0x004fc40003fdd000ULL, 0x00000018ff527819ULL, 0x002fca000001142fULL,
0x0000002c00997306ULL, 0x000fe20000009400ULL, 0x0000000172725812ULL, 0x008fce00078efcffULL,
0x0000002c00947306ULL, 0x000e620000005400ULL, 0x0000000155556812ULL, 0x010fc800078efcffULL,
0x000000557255723eULL, 0x000fc600000010ffULL, 0x000000be00ba7306ULL, 0x000ff00000209400ULL,
0x000000be00bf7306ULL, 0x000ea20000205400ULL, 0x000000949900720bULL, 0x002fe20003fbd000ULL,
0x0001000030947824ULL, 0x000fca00078e00ffULL, 0x00000018ff947819ULL, 0x000fe20000011494ULL,
0x0000002c006f7306ULL, 0x0002f0000000d400ULL, 0x000000be008a7306ULL, 0x000f22000020d400ULL,
0x000000bfba00720bULL, 0x004fe20003fdd000ULL, 0x000100002c2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002d00937306ULL, 0x000fe20000009400ULL,
0x000000016f6f5812ULL, 0x008fce00078efcffULL, 0x0000002d00927306ULL, 0x000e620000005400ULL,
0x000000018a8a6812ULL, 0x010fc800078efcffULL, 0x0000006f8a8a723eULL, 0x000fc600000010ffULL,
0x0000009f00c07306ULL, 0x000ff00000209400ULL, 0x0000009f00c17306ULL, 0x000ea20000205400ULL,
0x000000929300720bULL, 0x002fe20003fbd000ULL, 0x0001000031927824ULL, 0x000fcc00078e00ffULL,
0x0000002d006b7306ULL, 0x0002f0000000d400ULL, 0x0000009f00907306ULL, 0x000f22000020d400ULL,
0x000000c1c000720bULL, 0x004fe20003fdd000ULL, 0x000100002d2d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000002c00a57306ULL, 0x000fe20000209400ULL,
0x000000016b6b5812ULL, 0x008fe400078efcffULL, 0x0000009b9c00720bULL, 0x000fe40003fbd000ULL,
0x00000018ff9b7819ULL, 0x000fc60000011492ULL, 0x0000002c00a87306ULL, 0x000e620000205400ULL,
0x0000000190906812ULL, 0x010fc800078efcffULL, 0x0000006b908b723eULL, 0x000fc600000010ffULL,
0x0000002c00577306ULL, 0x000ea2000020d400ULL, 0x000000016e6e5812ULL, 0x000fe400078efcffULL,
0x0000009a9d00720bULL, 0x000fca0003fbd000ULL, 0x0000002d00a67306ULL, 0x000fe20000209400ULL,
0x000000a8a500720bULL, 0x002fce0003fdd000ULL, 0x0000002d00a77306ULL, 0x000e620000205400ULL,
0x000000016a6a5812ULL, 0x000fca00078efcffULL, 0x0000000157576812ULL, 0x004fe400078efcffULL,
0x0000002d009f7306ULL, 0x000ea4000020d400ULL, 0x000000576e6e723eULL, 0x000fcc00000010ffULL,
0x0000002e00917306ULL, 0x000fe20000009400ULL, 0x000000a7a600720bULL, 0x002fce0003fdd000ULL,
0x0000002e008c7306ULL, 0x000e6c0000005400ULL, 0x000000019f9f6812ULL, 0x004fe400078efcffULL,
0x000000a9002c7306ULL, 0x000fe40000209400ULL, 0x0000009f6a6f723eULL, 0x000fcc00000010ffULL,
0x000000a900ab7306ULL, 0x000ea20000205400ULL, 0x0000008c9100720bULL, 0x002fce0003fbd000ULL,
0x0000002e00697306ULL, 0x0002f0000000d400ULL, 0x000000a9009e7306ULL, 0x000f22000020d400ULL,
0x000000ab2c00720bULL, 0x004fe20003fdd000ULL, 0x000100002e2e7824ULL, 0x002fc400078e00ffULL,
0x00000100332c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000002f008d7306ULL, 0x000fe20000009400ULL, 0x0000000169695812ULL, 0x008fce00078efcffULL,
0x0000002f004e7306ULL, 0x000e620000005400ULL, 0x000000019e9e6812ULL, 0x010fc800078efcffULL,
0x000000699e9e723eULL, 0x000fc600000010ffULL, 0x000000ac00ad7306ULL, 0x000ff00000209400ULL,
0x000000ac00ae7306ULL, 0x000ea20000205400ULL, 0x0000004e8d00720bULL, 0x002fce0003fbd000ULL,
0x0000002f00657306ULL, 0x0002f0000000d400ULL, 0x000000ac00a07306ULL, 0x000f22000020d400ULL,
0x000000aead00720bULL, 0x004fe20003fdd000ULL, 0x000100002f2f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002e002d7306ULL, 0x000fe20000209400ULL,
0x0000000165655812ULL, 0x008fe400078efcffULL, 0x000000969700720bULL, 0x000fca0003fbd000ULL,
0x0000002e00aa7306ULL, 0x000e620000205400ULL, 0x00000001a0a06812ULL, 0x010fc800078efcffULL,
0x00000065a09f723eULL, 0x000fc600000010ffULL, 0x0000002e00a17306ULL, 0x000ea2000020d400ULL,
0x0000000168685812ULL, 0x000fce00078efcffULL, 0x0000005200987306ULL, 0x000fe20000209400ULL,
0x000000aa2d00720bULL, 0x002fe20003fdd000ULL, 0x00000100282d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001142dULL, 0x0000005200957306ULL, 0x000e6c0000205400ULL,
0x00000001a1a16812ULL, 0x004fe400078efcffULL, 0x0000002f00a47306ULL, 0x000fe40000209400ULL,
0x000000a16868723eULL, 0x000fcc00000010ffULL, 0x0000002f00a97306ULL, 0x000ea20000205400ULL,
0x000000959800720bULL, 0x002fce0003fbd000ULL, 0x0000005200647306ULL, 0x0002f0000020d400ULL,
0x0000002f00a37306ULL, 0x0008e2000020d400ULL, 0x000000a9a400720bULL, 0x004fe40003fdd000ULL,
0x00000018ff527819ULL, 0x002fca0000011433ULL, 0x00000030004c7306ULL, 0x000fe20000009400ULL,
0x00000100312f7824ULL, 0x010fe200078e00ffULL, 0x0000000164645812ULL, 0x008fc800078efcffULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00000030004d7306ULL, 0x000e620000005400ULL,
0x00000001a3a36812ULL, 0x000fc800078efcffULL, 0x000000a36469723eULL, 0x000fc600000010ffULL,
0x000000a2002e7306ULL, 0x000ff00000209400ULL, 0x000000a200af7306ULL, 0x000ea20000205400ULL,
0x0000004d4c00720bULL, 0x002fe40003fbd000ULL, 0x012800004f4c783bULL, 0x000e6a0000000200ULL,
0x0000003000617306ULL, 0x000ef0000000d400ULL, 0x000000a200307306ULL, 0x000f22000020d400ULL,
0x000000af2e00720bULL, 0x004fce0003fdd000ULL, 0x0000009400997306ULL, 0x000fe20000209400ULL,
0x0000000161615812ULL, 0x008fe400078efcffULL, 0x000000858600720bULL, 0x000fca0003fbd000ULL,
0x0000009400ac7306ULL, 0x000ea20000205400ULL, 0x0000000130306812ULL, 0x010fc800078efcffULL,
0x000000613030723eULL, 0x000fc600000010ffULL, 0x0000009400937306ULL, 0x000722000020d400ULL,
0x0000000160605812ULL, 0x000fe200078efcffULL, 0x000000474c4c8231ULL, 0x082fe400003400ffULL,
0x000000474e4e8231ULL, 0x000fe400003400ffULL, 0x000000484d4d8231ULL, 0x080fe400003400ffULL,
0x0000003200807306ULL, 0x000fe20000009400ULL, 0x0000010032947824ULL, 0x008fe200078e00ffULL,
0x000000ac9900720bULL, 0x004fe20003fdd000ULL, 0x000000484f4f8231ULL, 0x000fe200003400ffULL,
0x0000010029997824ULL, 0x000fc400078e00ffULL, 0x00000018ff947819ULL, 0x000fe40000011494ULL,
0x00000032007f7306ULL, 0x000fe20000005400ULL, 0x00000018ff997819ULL, 0x000fcc0000011499ULL,
0x0000000193936812ULL, 0x010fe200078efcffULL, 0x0000003200357306ULL, 0x0003e6000000d400ULL,
0x000000936060723eULL, 0x000fca00000010ffULL, 0x0000003100817306ULL, 0x000fe20000009400ULL,
0x0001000032327824ULL, 0x002fce00078e00ffULL, 0x00000031007e7306ULL, 0x000e700000005400ULL,
0x0000003100347306ULL, 0x000eb0000000d400ULL, 0x0000002f00a27306ULL, 0x000fe20000209400ULL,
0x0000007e8100720bULL, 0x002fce0003fbd000ULL, 0x0000002f00b17306ULL, 0x000e6c0000205400ULL,
0x0000000134345812ULL, 0x004fe400078efcffULL, 0x0000002f00317306ULL, 0x0004f0000020d400ULL,
0x0000009b009c7306ULL, 0x000fe20000209400ULL, 0x00000018ff2f7819ULL, 0x004fc4000001142cULL,
0x00000018ff2c7819ULL, 0x000fe40000011432ULL, 0x000000b1a200720bULL, 0x002fc60003fdd000ULL,
0x0000009b00a57306ULL, 0x000e700000205400ULL, 0x0000009b00927306ULL, 0x000ea4000020d400ULL,
0x0000000131316812ULL, 0x008fc400078efcffULL, 0x000000848700720bULL, 0x000fe40003fdd000ULL,
0x000000343131723eULL, 0x000fe400000010ffULL, 0x0000002f009b7306ULL, 0x000fe20000209400ULL,
0x000000a59c00720bULL, 0x002fce0003fbd000ULL, 0x0000002f00a87306ULL, 0x000e620000205400ULL,
0x0000000151516812ULL, 0x000fca00078efcffULL, 0x0000000192925812ULL, 0x004fe400078efcffULL,
0x0000002f008d7306ULL, 0x000ea2000020d400ULL, 0x0000007f8000720bULL, 0x000fe40003fbd000ULL,
0x000000925161723eULL, 0x000fca00000010ffULL, 0x0000002c00917306ULL, 0x000fe20000209400ULL,
0x000000a89b00720bULL, 0x002fca0003fdd000ULL, 0x0000000135355812ULL, 0x000fe400078efcffULL,
0x0000002c00a67306ULL, 0x000e6c0000205400ULL, 0x000000018d8d6812ULL, 0x004fe400078efcffULL,
0x0000002c00327306ULL, 0x0004e2000020d400ULL, 0x000000828300720bULL, 0x000fce0003fdd000ULL,
0x00000094009a7306ULL, 0x000fe20000209400ULL, 0x01280000492c783bULL, 0x004ea20000000200ULL,
0x000000a69100720bULL, 0x002fc80003fbd000ULL, 0x000000015f5f6812ULL, 0x000fe400078efcffULL,
0x00000094009d7306ULL, 0x000e6e0000205400ULL, 0x0000000132325812ULL, 0x008fe200078efcffULL,
0x00000094008c7306ULL, 0x000ee6000020d400ULL, 0x000000325f32723eULL, 0x000fca00000010ffULL,
0x00000033007c7306ULL, 0x000ff00000009400ULL, 0x00000033007d7306ULL, 0x000f300000005400ULL,
0x0000003300367306ULL, 0x0007e2000000d400ULL, 0x000000472c2c8231ULL, 0x004fc400003400ffULL,
0x000000472e2e8231ULL, 0x000fe400003400ffULL, 0x000000482d2d8231ULL, 0x080fe400003400ffULL,
0x000000482f2f8231ULL, 0x000fe200003400ffULL, 0x0000009d9a00720bULL, 0x002fe20003f1d000ULL,
0x0001000033337824ULL, 0x008fe200078e00ffULL, 0x0000005200757306ULL, 0x000fe80000209400ULL,
0x00000018ff947819ULL, 0x000fe20000011433ULL, 0x0000008a2c14723cULL, 0x000f660000041814ULL,
0x0000005200747306ULL, 0x000e660000205400ULL, 0x000000018c8c0812ULL, 0x000fc400078efcffULL,
0x0000007d7c00720bULL, 0x010fe20003f1d000ULL, 0x0000006e2c18723cULL, 0x040fe20000041818ULL,
0x000000358c8c723eULL, 0x000fe200000010ffULL, 0x0000009400967306ULL, 0x000fec0000209400ULL,
0x0000009e2c1c723cULL, 0x000fe4000004181cULL, 0x0000009400957306ULL, 0x000ea20000205400ULL,
0x000000747500720bULL, 0x002fe20003fbd000ULL, 0x000001002b747824ULL, 0x000fe200078e00ffULL,
0x0000000136360812ULL, 0x000fc600078efcffULL, 0x000000682c20723cULL, 0x000fe20000041820ULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000009700987306ULL, 0x000fe20000209400ULL,
0x000000368d8d723eULL, 0x000fce00000010ffULL, 0x0000009700a77306ULL, 0x000e620000205400ULL,
0x000000959600720bULL, 0x004fce0003f1d000ULL, 0x0000009400337306ULL, 0x000eb0000020d400ULL,
0x00000052005a7306ULL, 0x000ee2000020d400ULL, 0x000000a79800720bULL, 0x002fce0003fdd000ULL,
0x0000009700947306ULL, 0x000e62000020d400ULL, 0x0000000133330812ULL, 0x004fce00078efcffULL,
0x0000002800717306ULL, 0x000fe20000009400ULL, 0x000000015a5a5812ULL, 0x008fc800078efcffULL,
0x000000335a33723eULL, 0x000fc600000010ffULL, 0x0000002800707306ULL, 0x000ea20000005400ULL,
0x0000000194946812ULL, 0x002fce00078efcffULL, 0x00000029006c7306ULL, 0x000ff00000009400ULL,
0x00000029006d7306ULL, 0x000e620000005400ULL, 0x000000707100720bULL, 0x004fce0003f1d000ULL,
0x0000009900857306ULL, 0x000ff00000209400ULL, 0x0000009900867306ULL, 0x000ea20000205400ULL,
0x0000006d6c00720bULL, 0x002fce0003fbd000ULL, 0x0000002800377306ULL, 0x0002f0000000d400ULL,
0x00000029003f7306ULL, 0x0008e2000000d400ULL, 0x0001000028287824ULL, 0x002fe200078e00ffULL,
0x000000868500720bULL, 0x004fc80003fdd000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000009900a27306ULL, 0x000e62000020d400ULL, 0x0001000029297824ULL, 0x010fe200078e00ffULL,
0x0000000137370812ULL, 0x008fc800078efcffULL, 0x00000018ff847819ULL, 0x000fe20000011429ULL,
0x000001002a297824ULL, 0x000fe200078e00ffULL, 0x0000005d00667306ULL, 0x000fe20000209400ULL,
0x000000013f3f5812ULL, 0x000fe400078efcffULL, 0x000000379494723eULL, 0x000fe400000010ffULL,
0x00000018ff7c7819ULL, 0x000fe40000011429ULL, 0x000000798e29723eULL, 0x000fe200000010ffULL,
0x0000005d00677306ULL, 0x000ea20000205400ULL, 0x00000001a2a26812ULL, 0x002fc800078efcffULL,
0x0000003fa295723eULL, 0x000fc600000010ffULL, 0x0000002800497306ULL, 0x000fe80000209400ULL,
0x000000944c14723cULL, 0x020fe80000041814ULL, 0x00000028007e7306ULL, 0x000e620000205400ULL,
0x000000676600720bULL, 0x004fce0003fdd000ULL, 0x0000008400877306ULL, 0x000ff00000209400ULL,
0x00000084009a7306ULL, 0x000ea20000205400ULL, 0x0000007e4900720bULL, 0x002fce0003f1d000ULL,
0x0000002800817306ULL, 0x0002f0000020d400ULL, 0x0000005d005c7306ULL, 0x000f22000020d400ULL,
0x0000007b5428723eULL, 0x002fe400000010ffULL, 0x0000009a8700720bULL, 0x004fc40003fbd000ULL,
0x000000567354723eULL, 0x000fe400000010ffULL, 0x00000089787b723eULL, 0x000fe200000010ffULL,
0x0000008400807306ULL, 0x000e62000020d400ULL, 0x000000282c04723cULL, 0x040b620000041804ULL,
0x0000000181810812ULL, 0x008fe400078efcffULL, 0x000000626300720bULL, 0x000fe40003f1d000ULL,
0x000000768f89723eULL, 0x000fe400000010ffULL, 0x0000002a00407306ULL, 0x000fe20000009400ULL,
0x000000542c10723cULL, 0x000fe20000041810ULL, 0x000000015c5c6812ULL, 0x010fcc00078efcffULL,
0x0000002a00417306ULL, 0x000ea20000005400ULL, 0x0000000180805812ULL, 0x002fe200078efcffULL,
0x0000007a2c08723cULL, 0x000f620000041808ULL, 0x000000014b4b0812ULL, 0x000fc800078efcffULL,
0x000000804b4b723eULL, 0x000fe200000010ffULL, 0x0000007c00797306ULL, 0x000fe40000209400ULL,
0x000000882c0c723cULL, 0x000f6c000004180cULL, 0x0000007c00287306ULL, 0x020e620000205400ULL,
0x000000414000720bULL, 0x004fe20003fdd000ULL, 0x000000304c04723cULL, 0x040b6c0000041804ULL,
0x0000002a00427306ULL, 0x0004e4000000d400ULL, 0x000000604c08723cULL, 0x040b6c0000041808ULL,
0x0000007c00297306ULL, 0x000f22000020d400ULL, 0x000100002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000287900720bULL, 0x002fe20003fbd000ULL, 0x0000008c4c0c723cULL, 0x000b66000004180cULL,
0x00000018ff2a7819ULL, 0x000fc4000001142aULL, 0x0000002b00437306ULL, 0x000fe20000009400ULL,
0x0000000142426812ULL, 0x008fe400078efcffULL, 0x000000324c10723cULL, 0x000b6a0000041810ULL,
0x0000002b00447306ULL, 0x000e620000005400ULL, 0x0000000129295812ULL, 0x010fc800078efcffULL,
0x000000422942723eULL, 0x000fc600000010ffULL, 0x0000007400567306ULL, 0x000ff00000209400ULL,
0x0000007400557306ULL, 0x000ea20000205400ULL, 0x000000444300720bULL, 0x002fce0003fbd000ULL,
0x0000002a00497306ULL, 0x000ff00000209400ULL, 0x0000002a00547306ULL, 0x000e620000205400ULL,
0x000000555600720bULL, 0x004fce0003f1d000ULL, 0x0000002b00457306ULL, 0x0004f0000000d400ULL,
0x00000074006a7306ULL, 0x000f22000020d400ULL, 0x000100002b2b7824ULL, 0x004fe200078e00ffULL,
0x000000544900720bULL, 0x002fc80003fdd000ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000002a002c7306ULL, 0x000e62000020d400ULL, 0x0000000145455812ULL, 0x008fce00078efcffULL,
0x0000005e00527306ULL, 0x000fe20000209400ULL, 0x000000016a6a0812ULL, 0x010fe400078efcffULL,
0x0000004a5300720bULL, 0x000fe40003f1d000ULL, 0x000000815c4a723eULL, 0x000fe400000010ffULL,
0x000000456a43723eULL, 0x000fe200000010ffULL, 0x0000005e005d7306ULL, 0x000ea20000205400ULL,
0x000000012c2c6812ULL, 0x002fc600078efcffULL, 0x0000004a4c18723cULL, 0x000b680000041818ULL,
0x0000002b00287306ULL, 0x000fe20000209400ULL, 0x000000015b5b0812ULL, 0x000fc600078efcffULL,
0x000000424c1c723cULL, 0x000b62000004181cULL, 0x0000002c5b2c723eULL, 0x000fc600000010ffULL,
0x0000002b002d7306ULL, 0x000e620000205400ULL, 0x0000005d5200720bULL, 0x004fce0003fbd000ULL,
0x0000005e005e7306ULL, 0x000eb0000020d400ULL, 0x0000002b002b7306ULL, 0x000ee2000020d400ULL,
0x0000002d2800720bULL, 0x002fe40003fdd000ULL, 0x000176c827287811ULL, 0x000fc400078e18ffULL,
0x000000015e5e5812ULL, 0x004fd200078efcffULL, 0x000000012b2b6812ULL, 0x008fc800078efcffULL,
0x0000002b5e2d723eULL, 0x000fce00000010ffULL, 0x0000002c4c20723cULL, 0x000b620000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000028287f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a00050ff7f8cULL, 0x0005e2000c80043fULL, 0x000000023e547810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x002fe200078e0029ULL, 0x000000013d287812ULL, 0x000fc400078ec0ffULL,
0x000000013c3c7810ULL, 0x004fc80007ffe0ffULL, 0x000000243c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff21d000007947ULL, 0x000fea000383ffffULL,
0x000000ff2400720cULL, 0x000fe20003f05270ULL, 0x000000ffff2d7224ULL, 0x020fe400078e0023ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0022ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff297224ULL, 0x004fe400078e001fULL, 0x000000ffff237224ULL, 0x000fe400078e001bULL,
0x000000ffff227224ULL, 0x000fc400078e0019ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff287224ULL, 0x000fe400078e001eULL, 0x000000ffff267224ULL, 0x010fe400078e001dULL,
0x000000ffff257224ULL, 0x000fe400078e001cULL, 0x000000ffff1f7224ULL, 0x000fe400078e0017ULL,
0x000000ffff207224ULL, 0x000fc400078e0016ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0013ULL,
0x000000ffff197224ULL, 0x000fe400078e0010ULL, 0x000000ffff247224ULL, 0x000fe400078e001aULL,
0x000000ffff217224ULL, 0x000fe400078e0018ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0014ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0012ULL,
0x000000ffff177224ULL, 0x000fe400078e000fULL, 0x000000ffff167224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe400078e000bULL, 0x000000ffff107224ULL, 0x000fe400078e0009ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0011ULL, 0x000000ffff187224ULL, 0x000fe400078e000eULL,
0x000000ffff157224ULL, 0x000fe400078e000cULL, 0x000000ffff147224ULL, 0x000fe400078e000aULL,
0x000000ffff0f7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0007ULL,
0x000000ffff127224ULL, 0x000fc400078e0006ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff097224ULL, 0x000fe200078e0004ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000003a027810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000f2d000057802ULL, 0x000fc40000000f00ULL,
0x000098e000007944ULL, 0x002fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003a00037308ULL, 0x000ea40000001000ULL, 0xbf80000003027423ULL, 0x004fc8000000003aULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203047223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee80000000000ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011605ULL, 0x0000000808057811ULL, 0x010fe200078ff0ffULL,
0x0000000403067220ULL, 0x004fca0000410000ULL, 0x00001f0706047589ULL, 0x000ea800000e0000ULL,
0x00001f0506057589ULL, 0x000ee200000e0000ULL, 0x0000000904097220ULL, 0x044fe40000410000ULL,
0x0000000b040b7220ULL, 0x040fe40000410000ULL, 0x0000000f040f7220ULL, 0x040fe40000410000ULL,
0x0000001004107220ULL, 0x000fc40000410000ULL, 0x0000001504157220ULL, 0x040fe40000410000ULL,
0x0000001604167220ULL, 0x040fe40000410000ULL, 0x0000001904197220ULL, 0x040fe40000410000ULL,
0x0000001a041a7220ULL, 0x040fe40000410000ULL, 0x0000001d041d7220ULL, 0x040fe40000410000ULL,
0x0000001e041e7220ULL, 0x000fc40000410000ULL, 0x0000002104217220ULL, 0x040fe40000410000ULL,
0x0000002204227220ULL, 0x040fe40000410000ULL, 0x0000002504257220ULL, 0x040fe40000410000ULL,
0x0000002604267220ULL, 0x040fe40000410000ULL, 0x0000002b042b7220ULL, 0x040fe40000410000ULL,
0x0000002a042a7220ULL, 0x000fc40000410000ULL, 0x0000001205127220ULL, 0x048fe40000410000ULL,
0x0000000d050d7220ULL, 0x040fe40000410000ULL, 0x0000001405147220ULL, 0x040fe40000410000ULL,
0x0000001305137220ULL, 0x040fe40000410000ULL, 0x0000001805187220ULL, 0x040fe40000410000ULL,
0x0000001705177220ULL, 0x000fc40000410000ULL, 0x0000001c051c7220ULL, 0x040fe40000410000ULL,
0x0000001b051b7220ULL, 0x040fe40000410000ULL, 0x0000002005207220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x040fe40000410000ULL, 0x0000002405247220ULL, 0x040fe40000410000ULL,
0x0000002305237220ULL, 0x000fc40000410000ULL, 0x0000002805287220ULL, 0x040fe40000410000ULL,
0x0000002905297220ULL, 0x040fe40000410000ULL, 0x0000002c052c7220ULL, 0x040fe40000410000ULL,
0x0000002d052d7220ULL, 0x000fc40000410000ULL, 0x00000000002e7919ULL, 0x000ea20000000000ULL,
0x0000100000067824ULL, 0x000fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000100006067812ULL, 0x000fe400078ee2ffULL, 0x00000002ff057819ULL, 0x104fe2000001162eULL,
0x0000000139397824ULL, 0x000fe200078e022eULL, 0x000000022e027812ULL, 0x000fc400078ec0ffULL,
0x000000082e077811ULL, 0x000fe200078ff0ffULL, 0x00000008050a7824ULL, 0x040fe200078e00ffULL,
0x0000000502037211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x0000000807117824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe400078e00ffULL,
0x0000001039397824ULL, 0x000fe200078e0206ULL, 0xfffffff8110e7812ULL, 0x000fe200078ee204ULL,
0x000000082e047824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee202ULL,
0x0000000805027824ULL, 0x000fe200078e00ffULL, 0x0000000403057810ULL, 0x000fc40007ffe0ffULL,
0x0000000603077810ULL, 0x000fe40007ffe0ffULL, 0xfffffff802027812ULL, 0x000fe200078ee203ULL,
0x0000080027037824ULL, 0x000fe200078e0206ULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100e0e7824ULL, 0x100fe200078e0203ULL,
0x0000000804057812ULL, 0x000fe200078ec0ffULL, 0x0000001002047824ULL, 0x100fe200078e0203ULL,
0x000000090b02723eULL, 0x000fe200000010ffULL, 0x0000001008087824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x100fe400078e0203ULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x0000000f1003723eULL, 0x000fe200000010ffULL, 0x0000000104077824ULL, 0x000fe200078e0205ULL,
0x0000001d1e04723eULL, 0x000fe200000010ffULL, 0x0000000105087824ULL, 0x040fe200078e0208ULL,
0x0000541002107816ULL, 0x140fe20000000003ULL, 0x00000001050e7824ULL, 0x040fe200078e020eULL,
0x0000763202117816ULL, 0x000fe20000000003ULL, 0x00000001050a7824ULL, 0x040fe200078e020aULL,
0x000000151602723eULL, 0x000fe200000010ffULL, 0x00000001050c7824ULL, 0x000fe200078e020cULL,
0x000000191a03723eULL, 0x000fe200000010ffULL, 0x0000001007007388ULL, 0x0005e20000000a00ULL,
0x000000212205723eULL, 0x000fc400000010ffULL, 0x0000541002107816ULL, 0x144fe40000000003ULL,
0x0000763202117816ULL, 0x000fe40000000003ULL, 0x000000252602723eULL, 0x000fe400000010ffULL,
0x0000002b2a03723eULL, 0x000fe200000010ffULL, 0x0000001008007388ULL, 0x0005e40000000a00ULL,
0x0000541004107816ULL, 0x144fe40000000005ULL, 0x0000763204117816ULL, 0x000fc40000000005ULL,
0x000000120d04723eULL, 0x000fe400000010ffULL, 0x000000141305723eULL, 0x000fe200000010ffULL,
0x000000100a007388ULL, 0x0005e40000000a00ULL, 0x0000541002107816ULL, 0x144fe40000000003ULL,
0x0000763202117816ULL, 0x000fe40000000003ULL, 0x000000181702723eULL, 0x000fe400000010ffULL,
0x0000001c1b03723eULL, 0x000fe200000010ffULL, 0x000000100c007388ULL, 0x0005e60000000a00ULL,
0x00007632020f7816ULL, 0x000fc40000000003ULL, 0x0000541004107816ULL, 0x144fe40000000005ULL,
0x0000763204117816ULL, 0x000fe40000000005ULL, 0x000000201f04723eULL, 0x000fe400000010ffULL,
0x000000242305723eULL, 0x000fe200000010ffULL, 0x000000100e007388ULL, 0x0005e60000000a00ULL,
0x0000763204097816ULL, 0x000fc40000000005ULL, 0x00005410020e7816ULL, 0x004fe40000000003ULL,
0x000000282902723eULL, 0x000fe400000010ffULL, 0x0000002c2d03723eULL, 0x000fe200000010ffULL,
0x0004000e08007388ULL, 0x0005e40000000a00ULL, 0x0000541004087816ULL, 0x004fe40000000005ULL,
0x00005410020e7816ULL, 0x140fe20000000003ULL, 0x000000ff00047306ULL, 0x000fe20000205400ULL,
0x00007632020f7816ULL, 0x000fe20000000003ULL, 0x000400080a007388ULL, 0x000fe80000000a00ULL,
0x0004000e0c007388ULL, 0x000fe40000000a00ULL, 0x000000ff00037306ULL, 0x000ea40000209400ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000039107984ULL, 0x000ee20000000c00ULL,
0x000000ff00027306ULL, 0x000f26000020d400ULL, 0x0004000039087984ULL, 0x000e680000000c00ULL,
0x0008000039147984ULL, 0x000e620000000c00ULL, 0x000000040300720bULL, 0x004fc60003f1d000ULL,
0x000c000039187984ULL, 0x000eb40000000c00ULL, 0x0000000102020812ULL, 0x010fc400078efcffULL,
0x000000ff2700720cULL, 0x000fe40003f05270ULL, 0x000000020204723eULL, 0x000fca00000010ffULL,
0x3f803f8004137831ULL, 0x048fe40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x040fe40000200010ULL,
0x3f803f80040b7831ULL, 0x042fe4000020000bULL, 0x3f803f80040a7831ULL, 0x000fc4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x000fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fc40000200014ULL,
0x3f803f800b0b7831ULL, 0x004fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x0000001039007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x0004000839007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000202e0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000047919ULL, 0x000e620000002600ULL,
0x00000003ff0d7819ULL, 0x000fe2000001162eULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff057819ULL, 0x000fe2000001160cULL, 0x0000580000047ab9ULL, 0x000fc40000000800ULL,
0x000000010d027824ULL, 0x000fe200078e022eULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x000000010c037824ULL, 0x000fc600078e0205ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000703077812ULL, 0x000fe400078ec0ffULL, 0x0ffffff802037812ULL, 0x000fe400078ef82eULL,
0x0ffffff807077812ULL, 0x000fc600078ef80cULL, 0x0000001003037824ULL, 0x100fe400078e0206ULL,
0x0000001007077824ULL, 0x000fe400078e0206ULL, 0x0000000804027824ULL, 0x042fe200078e00ffULL,
0x0000000003087984ULL, 0x000e620000000c00ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x0000000007107984ULL, 0x0004e20000000c00ULL,
0xfffffff802027812ULL, 0x000fc400078ee20dULL, 0xfffffff804057812ULL, 0x000fe400078ee205ULL,
0x00000001000d7812ULL, 0x000fe400078ec0ffULL, 0x0000000402067c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe2000ff3e0ffULL, 0x000000080d077824ULL, 0x004fe400078e00ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0006027a11ULL, 0x040fe200078040ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fe200078240ffULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0x00005b0006037a11ULL, 0x000fc400000f4403ULL,
0xfffffff807077812ULL, 0x000fe400078ee22eULL, 0x00005b0005057a11ULL, 0x000fe400008f4400ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff3a7819ULL, 0x000fe20000011600ULL, 0xffffffffff0e7424ULL, 0x000fc600078e00ffULL,
0x000000033a00720cULL, 0x000fda0003f06070ULL, 0x000000023d0d8824ULL, 0x000fc800078e00ffULL,
0x000064000d0d8a24ULL, 0x000fc800078e023aULL, 0x000060000d0c8625ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff3e7624ULL, 0x000fe200078e00ffULL,
0x000000060c0e8981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff3f7624ULL, 0x000fc600078e00ffULL,
0x01760000ff047f8cULL, 0x000e68000c80043fULL, 0x000000063e3e7981ULL, 0x000722000c1e9900ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000008038387824ULL, 0x000fe400078e00ffULL,
0x00000040003b7824ULL, 0x000fe400078e00ffULL, 0x0000008039397824ULL, 0x000fc600078e00ffULL,
0x00000040380a7812ULL, 0x000fe200078ef83bULL, 0x0000000e39087224ULL, 0x004fc800078e02ffULL,
0x00000e8000000947ULL, 0x000fea0003800000ULL, 0x00000003ff287819ULL, 0x00afe40000011625ULL,
0x0000003b020c7217ULL, 0x000fe40007800000ULL, 0x00000004280e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0228ULL, 0x0000000828107810ULL, 0x000fe20007ffe0ffULL,
0x000000010c097824ULL, 0x000fe200078e0a3bULL, 0x0000000c28207810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0c7824ULL, 0x100fe200078e0225ULL, 0x0000000b081e7210ULL, 0x000fe20007f3e0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e020eULL, 0x000000090e00720cULL, 0x040fe20003f06070ULL,
0x000000080e117824ULL, 0x000fe200078e00ffULL, 0x00000014281a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001100d7824ULL, 0x000fe200078e0225ULL, 0x0000000b080b7210ULL, 0x000fe20007f5e0ffULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0xfffffff811127812ULL, 0x000fe200078ee20cULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x00005e001e187a11ULL, 0x000fe200078238ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x00005e000b157a11ULL, 0x040fe200078438ffULL,
0x000000010a117824ULL, 0x000fe200078e021aULL, 0xfffffff814147812ULL, 0x000fe200078ee20dULL,
0x000000010a0d7824ULL, 0x040fe200078e0220ULL, 0x00005f000b1f7a11ULL, 0x000fe200010f3c0eULL,
0x000000010a0b7824ULL, 0x000fe200078e0210ULL, 0x00000010280e7810ULL, 0x000fc40007ffe0ffULL,
0x00005f001e1e7a11ULL, 0x000fe400008f3c0fULL, 0x0000000d080d7210ULL, 0x000fe20007fbe0ffULL,
0x000000010a0f7824ULL, 0x000fe200078e020eULL, 0x000000091000720cULL, 0x000fe40003f26070ULL,
0x0000001108117210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff107224ULL, 0x000fe200028e06ffULL,
0x0000000f080f7210ULL, 0x000fe40007f5e0ffULL, 0x00005e000d1d7a11ULL, 0x000fe200078a38ffULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x00000018281c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000000b080b7210ULL, 0x000fc40007f9e0ffULL,
0x00005f000d277a11ULL, 0x000fe200028f3c10ULL, 0x000000010a0d7824ULL, 0x000fe200078e021cULL,
0x00005e000f177a11ULL, 0x000fe200078438ffULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005e0011237a11ULL, 0x000fe400078638ffULL, 0x00000070072a7812ULL, 0x000fe400078ec0ffULL,
0x00005e000b137a11ULL, 0x000fe400078838ffULL, 0x00005f000f197a11ULL, 0x000fe200010f3c0cULL,
0x000000010e0f7824ULL, 0x000fe200078e0225ULL, 0x00005f0011267a11ULL, 0x000fc400018f3c26ULL,
0x0000000d08227210ULL, 0x000fe40007fde0ffULL, 0x0000002a180c7210ULL, 0x000fe20007f7e0ffULL,
0x000000080e187824ULL, 0x000fe200078e00ffULL, 0x00005f000b1b7a11ULL, 0x000fe200020f3c16ULL,
0x00000001280b7824ULL, 0x100fe200078e0225ULL, 0x000000090e00720cULL, 0x000fe20003f86070ULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x0000100000077811ULL, 0x000fe200078e70ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e061eULL, 0x00005e0022217a11ULL, 0x000fe200078638ffULL,
0x0000000820167824ULL, 0x040fe200078e00ffULL, 0x000000070b107812ULL, 0x000fe200078ec0ffULL,
0x00000001200b7824ULL, 0x000fe200078e0225ULL, 0x0000001c281e7810ULL, 0x000fc40007ffe0ffULL,
0x00005f0022227a11ULL, 0x000fe400018f3c11ULL, 0x0ffffff810107812ULL, 0x000fe400078ef825ULL,
0x0000002a150e7210ULL, 0x080fe20007f7e0ffULL, 0x000000010a157824ULL, 0x000fe200078e021eULL,
0x000000092800720cULL, 0x000fe40003f46070ULL, 0xfffffff816167812ULL, 0x000fe200078ee20bULL,
0x00000010100b7824ULL, 0x000fe200078e0207ULL, 0xfffffff818187812ULL, 0x000fe200078ee20fULL,
0x000000ffff0f7224ULL, 0x000fe200018e061fULL, 0x0000002a13107210ULL, 0x000fe20007f7e0ffULL,
0x000000011a137824ULL, 0x000fe200078e0225ULL, 0x0000001508157210ULL, 0x000fc40007fde0ffULL,
0x000000092000720cULL, 0x080fe20003fa6070ULL, 0x000000ffff117224ULL, 0x000fe200018e061bULL,
0x000000091c00720cULL, 0x080fe20003f66070ULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x00005e00151b7a11ULL, 0x040fe200078c38ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000d101c46ULL, 0x000000091a00720cULL, 0x040fe20003f46070ULL,
0x000000081a1a7824ULL, 0x000fe200078e00ffULL, 0x00005f00151f7a11ULL, 0x000fe200030f3c20ULL,
0x0000001014157824ULL, 0x000fe200078e0207ULL, 0x0000002028207810ULL, 0x000fe20007ffe0ffULL,
0x000000011e147824ULL, 0x000fe200078e0225ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x00000010120b7824ULL, 0x002fc400078e0207ULL, 0x000000011c0c7824ULL, 0x040fe400078e0225ULL,
0x000000081c0d7824ULL, 0x000fe200078e00ffULL, 0x000000000e0b7faeULL, 0x0003e2000c101c46ULL,
0x000000091e00720cULL, 0x000fc60003f06070ULL, 0xfffffff80d1c7812ULL, 0x000fe200078ee20cULL,
0x0000000010157faeULL, 0x0005e2000c901c46ULL, 0x0000002a1d0c7210ULL, 0x080fe20007fde0ffULL,
0x000000081e1d7824ULL, 0x000fe200078e00ffULL, 0x0000002a17127210ULL, 0x080fe20007f3e0ffULL,
0x000000010a177824ULL, 0x000fe400078e0220ULL, 0x000000ffff0d7224ULL, 0x000fe200030e0627ULL,
0xfffffff81d147812ULL, 0x000fe200078ee214ULL, 0x00000001200b7824ULL, 0x002fe200078e0225ULL,
0x0000001708177210ULL, 0x000fe20007fde0ffULL, 0x00000008201e7824ULL, 0x000fe200078e00ffULL,
0x0000002428107810ULL, 0x004fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0619ULL,
0x000000092000720cULL, 0x000fe20003f26070ULL, 0x000000ffff0e7224ULL, 0x000fe200030e06ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x00000010160b7824ULL, 0x100fe200078e0207ULL,
0x00005e0017197a11ULL, 0x040fe200078c38ffULL, 0x000000010a0f7824ULL, 0x000fe200078e0210ULL,
0x0000003c28207810ULL, 0x000fe20007ffe0ffULL, 0x0000001018117824ULL, 0x000fe200078e0207ULL,
0x00005f00171d7a11ULL, 0x000fe200030f3c0eULL, 0x000000000c0b7faeULL, 0x0003e2000e901c46ULL,
0x0000000f08177210ULL, 0x000fe20007fde0ffULL, 0x0000000110157824ULL, 0x040fe200078e0225ULL,
0x0000002a230e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000012117faeULL, 0x0005e2000e101c46ULL,
0x000000091000720cULL, 0x040fe20003f86070ULL, 0x0000000810167824ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x000fe200030e06ffULL, 0x00005e0017187a11ULL, 0x000fe200078c38ffULL,
0x000000ffff0f7224ULL, 0x000fe200028e0626ULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x000000101a0b7824ULL, 0x102fe200078e0207ULL, 0x0000002a210c7210ULL, 0x080fe40007fbe0ffULL,
0x00005f0017157a11ULL, 0x000fe200030f3c10ULL, 0x000000101c177824ULL, 0x100fe200078e0207ULL,
0x000000000e0b7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff0d7224ULL, 0x000fe200028e0622ULL,
0x0000002a1b107210ULL, 0x000fe20007f5e0ffULL, 0x000000101e1b7824ULL, 0x000fe200078e0207ULL,
0x00000038281c7810ULL, 0x000fc40007ffe0ffULL, 0x000000000c177faeULL, 0x0007e2000d901c46ULL,
0x0000002a19127210ULL, 0x084fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe400010e061fULL,
0x0000001014197824ULL, 0x000fe200078e0207ULL, 0x0000002a18147210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200018e061dULL, 0x0000002c280e7810ULL, 0x002fe20007ffe0ffULL,
0x00000010161d7824ULL, 0x000fe200078e0207ULL, 0x0000000010197faeULL, 0x0003e2000c101c46ULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x0000003028167810ULL, 0x000fe20007ffe0ffULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0x00000028280c7810ULL, 0x048fe20007ffe0ffULL,
0x00000000121b7faeULL, 0x0005e2000c901c46ULL, 0x0000003428187810ULL, 0x000fc40007ffe0ffULL,
0x000000090c00720cULL, 0x080fe20003fa6070ULL, 0x000000010a0b7824ULL, 0x000fe200078e020cULL,
0x00000000141d7faeULL, 0x0007e2000e101c46ULL, 0x000000010c0d7824ULL, 0x100fe200078e0225ULL,
0x000000090e00720cULL, 0x000fe20003f86070ULL, 0x000000080c107824ULL, 0x002fe200078e00ffULL,
0x0000000b080f7210ULL, 0x000fe20007f1e0ffULL, 0x000000010e0b7824ULL, 0x000fe200078e0225ULL,
0x000000091600720cULL, 0x080fe20003f66070ULL, 0x000000080e127824ULL, 0x004fe200078e00ffULL,
0x00005e000f0c7a11ULL, 0x000fe200078c38ffULL, 0x0000000818137824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee20dULL, 0x000000ffff147224ULL, 0x008fe200000e06ffULL,
0x000000091800720cULL, 0x080fe20003f46070ULL, 0x000000010a157824ULL, 0x000fe200078e0220ULL,
0x000000091c00720cULL, 0x000fc40003f26070ULL, 0x00005f000f0d7a11ULL, 0x000fe200030f3c14ULL,
0x0000000816147824ULL, 0x000fe200078e00ffULL, 0x000000092000720cULL, 0x000fe20003f06070ULL,
0x000000010a097824ULL, 0x000fe200078e020eULL, 0x0000002a0c0c7210ULL, 0x080fe20007fde0ffULL,
0x00000001180e7824ULL, 0x000fe200078e0225ULL, 0xfffffff812127812ULL, 0x000fe200078ee20bULL,
0x00000001160b7824ULL, 0x000fe400078e0225ULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x0000000908117210ULL, 0x000fe20007fde0ffULL, 0x000000011c097824ULL, 0x000fe200078e0225ULL,
0xfffffff814147812ULL, 0x000fe200078ee20bULL, 0x0000000120257824ULL, 0x000fe200078e0225ULL,
0xfffffff8131a7812ULL, 0x000fe200078ee20eULL, 0x000000ffff227224ULL, 0x000fe200030e06ffULL,
0x00005e00110f7a11ULL, 0x040fe200078c38ffULL, 0x000000010a137824ULL, 0x000fe200078e021cULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL, 0x000000010a097824ULL, 0x040fe200078e0216ULL,
0x00005f00110b7a11ULL, 0x000fe200030f3c22ULL, 0x000000010a117824ULL, 0x000fe200078e0218ULL,
0x0000002a0f0e7210ULL, 0x000fe20007fde0ffULL, 0x00000008200a7824ULL, 0x000fc800078e00ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e060bULL, 0x0000000908197210ULL, 0x000fe20007fde0ffULL,
0x0000001010097824ULL, 0x000fe200078e0207ULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee225ULL,
0x00000010120b7824ULL, 0x100fe400078e0207ULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x00005e0019187a11ULL, 0x040fe200078c38ffULL, 0x000000000c097faeULL, 0x0003e6000e901c46ULL,
0x00005f0019197a11ULL, 0x000fe200030f3c16ULL, 0x000000000e0b7faeULL, 0x0005e2000e101c46ULL,
0x0000001108167210ULL, 0x000fe20007fbe0ffULL, 0x0000001014117824ULL, 0x100fe200078e0207ULL,
0x0000001308127210ULL, 0x000fe20007f9e0ffULL, 0x000000101a137824ULL, 0x100fe200078e0207ULL,
0x0000001508107210ULL, 0x000fe20007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200028e06ffULL,
0x00005e0016147a11ULL, 0x000fe200078a38ffULL, 0x000000101e157824ULL, 0x000fc400078e0207ULL,
0x000000100a077824ULL, 0x000fe200078e0207ULL, 0x00005f0016167a11ULL, 0x000fe200028f3c17ULL,
0x000000ffff0d7224ULL, 0x002fe200020e06ffULL, 0x0000002a18087210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x004fe200030e06ffULL, 0x00005e00120c7a11ULL, 0x000fe400078838ffULL,
0x00005e00100e7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff097224ULL, 0x000fe200028e0619ULL,
0x0000002a140a7210ULL, 0x000fe40007fbe0ffULL, 0x00005f00120d7a11ULL, 0x000fc400020f3c0dULL,
0x0000002a0c0c7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0616ULL,
0x00005f00100f7a11ULL, 0x000fe200030f3c0fULL, 0x0000000008117faeULL, 0x0003e2000d901c46ULL,
0x0000002a0e0e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe400020e060dULL,
0x000000000a137faeULL, 0x0003e4000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fe400028e060fULL,
0x000000000c157faeULL, 0x0003e8000c901c46ULL, 0x000000000e077faeULL, 0x0003e2000c101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x0000000c25117811ULL, 0x04afe400078fe8ffULL,
0x00000004250d7811ULL, 0x000fc400078fe8ffULL, 0x0000001c25197811ULL, 0x000fe200078fe8ffULL,
0x00000001110c7824ULL, 0x100fe200078e0225ULL, 0x0000001025137811ULL, 0x000fe200078fe8ffULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0x00000008250f7811ULL, 0x000fe200078fe8ffULL,
0x000000010d097824ULL, 0x100fe200078e0225ULL, 0x00000020251b7811ULL, 0x000fe200078fe8ffULL,
0x000000080d0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff815127812ULL, 0x000fe200078ee20cULL,
0x00000001190c7824ULL, 0x000fe200078e0225ULL, 0x0000001425157811ULL, 0x000fe200078fe8ffULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x0000000113147824ULL, 0x100fe200078e0225ULL, 0x0000002c25217811ULL, 0x000fe200078fe8ffULL,
0x0000000115097824ULL, 0x100fe200078e0225ULL, 0xfffffff81d1a7812ULL, 0x000fe200078ee20cULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0x00000024251d7811ULL, 0x000fe200078fe8ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000003025237811ULL, 0x000fe200078fe8ffULL,
0x000000010f0b7824ULL, 0x000fe200078e0225ULL, 0xfffffff816167812ULL, 0x000fe200078ee209ULL,
0x000000011d097824ULL, 0x100fe200078e0225ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x000000081d1e7824ULL, 0x000fe200078e00ffULL, 0x0000001825177811ULL, 0x000fe200078fe8ffULL,
0x000000080f107824ULL, 0x000fe200078e00ffULL, 0x0000003825287811ULL, 0x000fe200078fe8ffULL,
0x000000011b1c7824ULL, 0x040fe200078e0225ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL,
0x000000081b1f7824ULL, 0x000fe200078e00ffULL, 0x0000000a25097211ULL, 0x000fe200078fe8ffULL,
0x000000010a137824ULL, 0x000fe200078e0213ULL, 0xfffffff810107812ULL, 0x000fe200078ee20bULL,
0x000000010a0f7824ULL, 0x000fe200078e020fULL, 0x00000009084c7210ULL, 0x000fe20007f1e0ffULL,
0x000000010a117824ULL, 0x000fe200078e0211ULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x00000001170b7824ULL, 0x000fe200078e0225ULL, 0x00000028251f7811ULL, 0x000fe200078fe8ffULL,
0x0000000817187824ULL, 0x000fe200078e00ffULL, 0x0000001308137210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e004c4b7a11ULL, 0x000fe200078038ffULL,
0x000000010a0d7824ULL, 0x000fe200078e020dULL, 0x0000000f080f7210ULL, 0x040fe20007f3e0ffULL,
0x000000081f207824ULL, 0x000fe200078e00ffULL, 0x0000001108117210ULL, 0x000fe20007f5e0ffULL,
0x00000001210c7824ULL, 0x000fe200078e0225ULL, 0xfffffff818187812ULL, 0x000fe200078ee20bULL,
0x000000011f0b7824ULL, 0x000fe200078e0225ULL, 0x00005f004c4c7a11ULL, 0x000fe200000f3c2dULL,
0x0000000821277824ULL, 0x000fe200078e00ffULL, 0x0000000d080d7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff427224ULL, 0x000fe200018e06ffULL, 0x00005e0013407a11ULL, 0x000fe200078638ffULL,
0x000000010a1b7824ULL, 0x000fe200078e021bULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0x00005e000f477a11ULL, 0x000fe200078238ffULL,
0x000000ffff467224ULL, 0x000fe200010e06ffULL, 0x00005e0011447a11ULL, 0x000fe200078438ffULL,
0x000000010a177824ULL, 0x040fe200078e0217ULL, 0xfffffff827227812ULL, 0x000fe200078ee20cULL,
0x000000010a197824ULL, 0x040fe200078e0219ULL, 0x00000025250b7211ULL, 0x000fe200078fe8ffULL,
0x0000000123267824ULL, 0x000fe200078e0225ULL, 0x0000003425277811ULL, 0x000fe200078fe8ffULL,
0x0000000823297824ULL, 0x000fe200078e00ffULL, 0x00005f0013427a11ULL, 0x000fe200018f3c42ULL,
0x000000ffff4a7224ULL, 0x000fe200000e06ffULL, 0x00005f000f487a11ULL, 0x000fe200008f3c48ULL,
0x000000010a157824ULL, 0x040fe200078e0215ULL, 0x00005f0011467a11ULL, 0x000fe200010f3c46ULL,
0x000000010a097824ULL, 0x000fe200078e0227ULL, 0x0000001b081b7210ULL, 0x000fe20007f7e0ffULL,
0x00000008272c7824ULL, 0x000fe200078e00ffULL, 0x00005e000d497a11ULL, 0x000fe200078038ffULL,
0x000000010a1d7824ULL, 0x000fe200078e021dULL, 0x0000001708367210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x0000001908347210ULL, 0x000fe20007f5e0ffULL,
0x000000010a1f7824ULL, 0x040fe200078e021fULL, 0x000000070b0c7812ULL, 0x000fe200078ec0ffULL,
0x00000001270b7824ULL, 0x100fe200078e0225ULL, 0xfffffff829267812ULL, 0x000fe200078ee226ULL,
0x000000010a277824ULL, 0x000fe200078e0228ULL, 0x0000003c252a7811ULL, 0x000fe200078fe8ffULL,
0x0000000128297824ULL, 0x040fe200078e0225ULL, 0x00005f000d4a7a11ULL, 0x000fe200000f3c4aULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x00000015083c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x00005e001b197a11ULL, 0x040fe200078638ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0x00005e0036157a11ULL, 0x000fe200078238ffULL,
0x000000010a237824ULL, 0x000fe200078e0223ULL, 0x00005e0034177a11ULL, 0x000fe200078438ffULL,
0x000000010a217824ULL, 0x000fe200078e0221ULL, 0x0ffffff80c0c7812ULL, 0x100fe200078ef825ULL,
0x000000010a2b7824ULL, 0x000fe200078e022aULL, 0x00005f001b327a11ULL, 0x000fe200018f3c32ULL,
0x000000012a257824ULL, 0x000fe200078e0225ULL, 0xfffffff82c0b7812ULL, 0x000fe200078ee20bULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8280a7812ULL, 0x000fe200078ee229ULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005f0036367a11ULL, 0x000fc400008f3c0fULL,
0x00005f0034347a11ULL, 0x000fe400010f3c0dULL, 0x0000100000457811ULL, 0x000fe400078e70ffULL,
0x0000001d08307210ULL, 0x000fe40007f7e0ffULL, 0x00005e003c137a11ULL, 0x000fe200078038ffULL,
0x000000100b417824ULL, 0x100fe200078e0245ULL, 0x0000001f081d7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x00000023082e7210ULL, 0x000fe20007f3e0ffULL,
0x000000100a437824ULL, 0x000fe200078e0245ULL, 0xfffffff82a287812ULL, 0x000fe200078ee225ULL,
0x000000101c317824ULL, 0x000fe200078e0245ULL, 0x00005f003c3c7a11ULL, 0x000fe200000f3c11ULL,
0x0000001020357824ULL, 0x100fe200078e0245ULL, 0x00000021081f7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x00000009082c7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x00000027082a7210ULL, 0x000fe20007f9e0ffULL,
0x000000100c217824ULL, 0x100fe200078e0245ULL, 0x0000002b08097210ULL, 0x000fe20007fbe0ffULL,
0x000000100e237824ULL, 0x100fe200078e0245ULL, 0x00005e001d1c7a11ULL, 0x000fe200078438ffULL,
0x0000001010257824ULL, 0x100fe200078e0245ULL, 0x00005e002e207a11ULL, 0x000fe200078238ffULL,
0x0000001012277824ULL, 0x100fe200078e0245ULL, 0x00000070074d7812ULL, 0x000fe200078ec0ffULL,
0x0000001014297824ULL, 0x100fe200078e0245ULL, 0x00005f001d1d7a11ULL, 0x000fe200010f3c0aULL,
0x00000010162b7824ULL, 0x000fe200078e0245ULL, 0x00005f002e2e7a11ULL, 0x000fe200008f3c0bULL,
0x00000010182d7824ULL, 0x100fe200078e0245ULL, 0x00005e00301b7a11ULL, 0x000fe200078c38ffULL,
0x000000101a2f7824ULL, 0x000fc400078e0245ULL, 0x000000101e337824ULL, 0x000fe200078e0245ULL,
0x00005f0030307a11ULL, 0x000fe200030f3c0dULL, 0x0000001022377824ULL, 0x100fe200078e0245ULL,
0x00005e002c227a11ULL, 0x000fe200078238ffULL, 0x00000010263f7824ULL, 0x100fe200078e0245ULL,
0x00005e002a267a11ULL, 0x000fe200078438ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078038ffULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x000000134d127210ULL, 0x000fe20007f9e0ffULL, 0x0000001028457824ULL, 0x000fe200078e0245ULL,
0x00005f001f1f7a11ULL, 0x000fe200000f3c08ULL, 0x000000ffff0b7224ULL, 0x000fe200018e06ffULL,
0x00005e0009287a11ULL, 0x000fe200078638ffULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x00005f002a2a7a11ULL, 0x000fe200010f3c07ULL, 0x000000ffff137224ULL, 0x000fe200020e063cULL,
0x0000004b4d087210ULL, 0x000fc40007f1e0ffULL, 0x00005f002c2c7a11ULL, 0x000fe400008f3c0bULL,
0x00005f0009077a11ULL, 0x000fe200018f3c0aULL, 0x000000ffff097224ULL, 0x000fe200000e064cULL,
0x000000494d0a7210ULL, 0x040fe40007f3e0ffULL, 0x000000474d0c7210ULL, 0x040fe40007f5e0ffULL,
0x000000444d0e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e064aULL,
0x000000404d107210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0648ULL,
0x000000154d147210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0646ULL,
0x000000174d167210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0642ULL,
0x000000194d187210ULL, 0x040fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008217faeULL, 0x0003e2000b901c46ULL, 0x0000001b4d1a7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e0636ULL, 0x0000001c4d1c7210ULL, 0x040fe20007fbe0ffULL,
0x000000000a237faeULL, 0x0005e2000b901c46ULL, 0x0000001e4d1e7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0634ULL, 0x000000204d207210ULL, 0x040fe20007f1e0ffULL,
0x000000000c257faeULL, 0x0007e2000b901c46ULL, 0x000000224d227210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0632ULL, 0x000000264d267210ULL, 0x040fe20007f5e0ffULL,
0x000000000e277faeULL, 0x0007e2000b901c46ULL, 0x000000ffff1b7224ULL, 0x000fe200018e0630ULL,
0x000000284d287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x0000000010297faeULL, 0x0007e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fc400020e061fULL,
0x000000ffff217224ULL, 0x002fe200000e062eULL, 0x00000000122b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x004fc600008e062cULL, 0x00000000142d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff277224ULL, 0x008fc600010e062aULL, 0x00000000162f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fc600018e0607ULL, 0x0000000018317faeULL, 0x0003e8000b901c46ULL,
0x000000001a337faeULL, 0x0003e8000b901c46ULL, 0x000000001c357faeULL, 0x0003e8000b901c46ULL,
0x000000001e377faeULL, 0x0003e8000b901c46ULL, 0x00000000203f7faeULL, 0x0003e8000b901c46ULL,
0x0000000022417faeULL, 0x0003e8000b901c46ULL, 0x0000000026437faeULL, 0x0003e8000b901c46ULL,
0x0000000028457faeULL, 0x0003e4000b901c46ULL, 0x000000023a3a7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff3c7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000033a00720cULL, 0x000fda0003f06070ULL, 0x000000023d078824ULL, 0x002fc800078e00ffULL,
0x0000640007078a24ULL, 0x000fc800078e023aULL, 0x0000600007068625ULL, 0x000fca00078e0006ULL,
0x00000006063c8981ULL, 0x000324000c1e1900ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01760400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002000047824ULL, 0x002fca00078e0205ULL,
0x00000003ff057819ULL, 0x000fc80000011604ULL, 0x1ffffffe05077812ULL, 0x000fe400078ec0ffULL,
0x0000000f04057812ULL, 0x000fc600078ec0ffULL, 0x0000000104077824ULL, 0x000fe400078e0207ULL,
0x0000001005097824ULL, 0x040fe400078e00ffULL, 0x0000001005067824ULL, 0x000fe200078e00ffULL,
0x0000000f07047812ULL, 0x040fe400078ec0ffULL, 0x0000000107077810ULL, 0x000fe40007ffe0ffULL,
0x000000f009047812ULL, 0x000fe400078ee204ULL, 0x0000000f07077812ULL, 0x000fc600078ec0ffULL,
0x00000000040c7984ULL, 0x000e62000000cc00ULL, 0x000000f006077812ULL, 0x000fca00078ee207ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001004007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000257919ULL, 0x000e620000000000ULL, 0x000064003d3d7a24ULL, 0x000fe200078e02ffULL,
0x00017688003f7811ULL, 0x000fe200078e18ffULL, 0x3db504f33e3e7820ULL, 0x010fe20000410000ULL,
0xffffffff24407810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x0001760800417811ULL, 0x000fe200078e28ffULL, 0x000000ffff457224ULL, 0x000fc400078e00ffULL,
0x0000010043477824ULL, 0x000fe200078e023bULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000470200720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x0000000243057810ULL, 0x000fe20007ffe0ffULL, 0x0000003c393c7224ULL, 0x000fe200078e02ffULL,
0x0000010047067810ULL, 0x000fe40007ffe0ffULL, 0x000000240500720cULL, 0x000fe40003f06070ULL,
0x0000004006057812ULL, 0x000fe400078ec0ffULL, 0x0000000145497812ULL, 0x000fc600078e0cffULL,
0x0000000138047824ULL, 0x000fcc00078e0205ULL, 0x00000ea000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1e7819ULL, 0x002fe20000011625ULL, 0x0000000200107824ULL, 0x000fe200078e0249ULL,
0x0000000602057217ULL, 0x000fe40007800000ULL, 0x000000081e0a7810ULL, 0x040fe20007ffe0ffULL,
0x000000011e077824ULL, 0x040fe200078e0204ULL, 0x000000041e087810ULL, 0x040fe20007ffe0ffULL,
0x0000000105057824ULL, 0x000fe200078e0a06ULL, 0x0000000c1e187810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x100fe200078e0225ULL, 0x000000073c167210ULL, 0x000fe20007f1e0ffULL,
0x000000080a0e7824ULL, 0x000fe200078e00ffULL, 0x000000050800720cULL, 0x0c0fe20003f86070ULL,
0x0000000108097824ULL, 0x000fe200078e0225ULL, 0x000000101e207810ULL, 0x000fe20007ffe0ffULL,
0x00000008080c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e217812ULL, 0x000fe200078ee20bULL,
0x0000000108077824ULL, 0x100fe200078e0204ULL, 0x000000050a00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0xfffffff80c1f7812ULL, 0x000fe200078ee209ULL,
0x000000010a097824ULL, 0x100fe200078e0204ULL, 0x000000073c157210ULL, 0x000fe20007f3e0ffULL,
0x0000000118077824ULL, 0x000fe200078e0204ULL, 0x00005e00160d7a11ULL, 0x000fc400078038ffULL,
0x000000093c097210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005f0016167a11ULL, 0x000fe400000f3c0bULL, 0x00005e00150f7a11ULL, 0x000fe200078038ffULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x00005e00090a7a11ULL, 0x000fe400078238ffULL,
0x00005f0015157a11ULL, 0x000fe200000f3c08ULL, 0x0000001025087824ULL, 0x000fe200078e00ffULL,
0x000000073c147210ULL, 0x000fe20007f1e0ffULL, 0x0000000120077824ULL, 0x000fe200078e0204ULL,
0x000000181e267810ULL, 0x000fc40007ffe0ffULL, 0x00005f0009117a11ULL, 0x000fe200008f3c06ULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x000000073c0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000126077824ULL, 0x100fe200078e0204ULL, 0x00005e0014137a11ULL, 0x000fe400078038ffULL,
0x000000141e227810ULL, 0x000fe40007ffe0ffULL, 0x00005f0014147a11ULL, 0x000fe200000f3c0bULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x000000073c077210ULL, 0x000fe20007f7e0ffULL,
0x0000000122097824ULL, 0x000fe200078e0204ULL, 0x00005e000e0c7a11ULL, 0x000fe200078038ffULL,
0x0000000822297824ULL, 0x000fe200078e00ffULL, 0x0000001c1e287810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff067224ULL, 0x000fe200018e06ffULL, 0x00005f000e0e7a11ULL, 0x000fe200000f3c0bULL,
0x00000001200b7824ULL, 0x000fe200078e0225ULL, 0x000000093c097210ULL, 0x000fc40007f5e0ffULL,
0x00005e00071a7a11ULL, 0x000fe400078038ffULL, 0x00005e0009127a11ULL, 0x000fe200078238ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x00005f00071b7a11ULL, 0x000fe200000f3c06ULL,
0x000000011e067824ULL, 0x100fe200078e0225ULL, 0x00000070081d7812ULL, 0x000fe200078ec0ffULL,
0x0000000128077824ULL, 0x000fe200078e0204ULL, 0x00005f00091c7a11ULL, 0x000fe200008f3c1cULL,
0x0000000118097824ULL, 0x000fe200078e0225ULL, 0x0000000706087812ULL, 0x000fc400078ec0ffULL,
0x000000073c197210ULL, 0x000fe40007fde0ffULL, 0x0000001d0d067210ULL, 0x000fe40007f3e0ffULL,
0x000000052000720cULL, 0x0c0fe20003f46070ULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0x0ffffff8080d7812ULL, 0x100fe200078ef825ULL, 0x000000ffff087224ULL, 0x000fe200030e06ffULL,
0x000000051e00720cULL, 0x000fe20003f06070ULL, 0x000000ffff077224ULL, 0x000fe200008e0616ULL,
0x00005e0019177a11ULL, 0x000fe200078238ffULL, 0x0000000122167824ULL, 0x000fe200078e0225ULL,
0xfffffff820277812ULL, 0x000fc400078ee20bULL, 0x000000201e207810ULL, 0x000fe40007ffe0ffULL,
0x000000051800720cULL, 0x040fe20003f66070ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x00005f0019197a11ULL, 0x000fe200008f3c08ULL, 0x00000008202b7824ULL, 0x040fe200078e00ffULL,
0x0000001d0f087210ULL, 0x080fe20007f3e0ffULL, 0x00000001200f7824ULL, 0x000fe200078e0204ULL,
0x0000100010107811ULL, 0x000fe400078e68ffULL, 0xfffffff818237812ULL, 0x000fe200078ee209ULL,
0x000000ffff097224ULL, 0x000fe200008e0615ULL, 0x0000001d0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0210ULL, 0x0000000f3c187210ULL, 0x000fe20007fde0ffULL,
0x000000101f0f7824ULL, 0x000fe200078e0210ULL, 0xfffffff829297812ULL, 0x000fe200078ee216ULL,
0x000000ffff0b7224ULL, 0x000fe200008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e2000c101c46ULL, 0x0000001021117824ULL, 0x000fe200078e0210ULL,
0x000000052200720cULL, 0x080fe20003f06070ULL, 0x0000000828217824ULL, 0x000fe200078e00ffULL,
0x000000241e227810ULL, 0x000fe20007ffe0ffULL, 0x00000000080f7faeULL, 0x0005e2000e101c46ULL,
0x000000052600720cULL, 0x000fc40003f26070ULL, 0x000000052800720cULL, 0x000fe20003f86070ULL,
0x000000000a117faeULL, 0x0007e2000e901c46ULL, 0x0000001d0c0c7210ULL, 0x080fe20007fbe0ffULL,
0x0000000126067824ULL, 0x142fe400078e0225ULL, 0x00000008260d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200030e06ffULL, 0x00005e0018157a11ULL, 0x000fe200078c38ffULL,
0x0000000120087824ULL, 0x004fe200078e0225ULL, 0xfffffff80d1f7812ULL, 0x000fe200078ee206ULL,
0x000000ffff0d7224ULL, 0x000fe200028e060eULL, 0x00005f0018187a11ULL, 0x000fe200030f3c07ULL,
0x00000010230b7824ULL, 0x008fe200078e0210ULL, 0x0000001d13067210ULL, 0x000fe20007fde0ffULL,
0x0000000122137824ULL, 0x000fe200078e0204ULL, 0x000000052000720cULL, 0x000fe20003fa6070ULL,
0x00000010270f7824ULL, 0x000fe200078e0210ULL, 0x000000281e207810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200030e0614ULL, 0x000000133c137210ULL, 0x000fe20007fde0ffULL,
0x0000000128147824ULL, 0x100fe200078e0225ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee208ULL,
0x0000000120097824ULL, 0x000fe200078e0204ULL, 0x00000000060b7faeULL, 0x0003e2000d901c46ULL,
0x000000ffff167224ULL, 0x000fe200030e06ffULL, 0x00005e00130e7a11ULL, 0x000fe200078c38ffULL,
0x00000001220a7824ULL, 0x000fe200078e0225ULL, 0x0000001d12087210ULL, 0x000fe20007f7e0ffULL,
0x0000000822237824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee214ULL,
0x0000001029117824ULL, 0x000fe200078e0210ULL, 0x00005f0013167a11ULL, 0x000fe200030f3c16ULL,
0x000000000c0f7faeULL, 0x0005e2000d101c46ULL, 0x000000093c147210ULL, 0x000fe20007fde0ffULL,
0x000000ffff097224ULL, 0x000fe200018e061cULL, 0xfffffff823237812ULL, 0x000fc400078ee20aULL,
0x0000001d1a067210ULL, 0x082fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0000000008117faeULL, 0x0003e2000c101c46ULL, 0x0000001d170a7210ULL, 0x000fe20007f1e0ffULL,
0x000000102b177824ULL, 0x100fe200078e0210ULL, 0x00005e0014127a11ULL, 0x000fe200078c38ffULL,
0x000000ffff077224ULL, 0x000fe200018e061bULL, 0x000000052200720cULL, 0x000fe20003f46070ULL,
0x000000ffff0b7224ULL, 0x000fe200000e0619ULL, 0x0000001d0e0e7210ULL, 0x080fe40007f1e0ffULL,
0x00005f0014147a11ULL, 0x000fe200030f3c13ULL, 0x000000101f137824ULL, 0x000fe200078e0210ULL,
0x000000341e1a7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x004fe200000e0616ULL,
0x0000002c1e167810ULL, 0x040fe20007ffe0ffULL, 0x0000001023097824ULL, 0x102fe200078e0210ULL,
0x0000000006137faeULL, 0x0003e2000c901c46ULL, 0x0000001d150c7210ULL, 0x000fe20007f3e0ffULL,
0x0000001021157824ULL, 0x000fe200078e0210ULL, 0x000000381e1c7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e0618ULL, 0x000000000a157faeULL, 0x0005e2000e101c46ULL,
0x000000301e187810ULL, 0x040fe40007ffe0ffULL, 0x0000003c1e1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000000c177faeULL, 0x0007e2000e901c46ULL, 0x0000000116077824ULL, 0x102fe200078e0204ULL,
0x0000001d12067210ULL, 0x000fe20007f1e0ffULL, 0x0000000818137824ULL, 0x000fe200078e00ffULL,
0x000000000e097faeULL, 0x0003e2000d101c46ULL, 0x000000052000720cULL, 0x080fe20003f86070ULL,
0x000000011e117824ULL, 0x000fe200078e0204ULL, 0x000000051600720cULL, 0x000fe20003fa6070ULL,
0x00000001200b7824ULL, 0x104fe200078e0225ULL, 0x000000073c0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0614ULL, 0x000000051800720cULL, 0x080fe20003f66070ULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0x00005e000a087a11ULL, 0x000fe200078c38ffULL,
0x00000001180c7824ULL, 0x008fe200078e0225ULL, 0x000000051a00720cULL, 0x080fe20003f46070ULL,
0x000000ffff097224ULL, 0x002fe200008e06ffULL, 0x000000051c00720cULL, 0x080fe20003f26070ULL,
0x00000008160f7824ULL, 0x000fe200078e00ffULL, 0x000000051e00720cULL, 0x000fe20003f06070ULL,
0x0000000118057824ULL, 0x000fe200078e0204ULL, 0x00005f000a097a11ULL, 0x000fe200030f3c09ULL,
0x00000001160a7824ULL, 0x000fe200078e0225ULL, 0x0000001d08087210ULL, 0x000fe20007fde0ffULL,
0x000000081a157824ULL, 0x000fe200078e00ffULL, 0xfffffff8200b7812ULL, 0x000fe200078ee20bULL,
0x000000011e147824ULL, 0x000fe200078e0225ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x000000053c0e7210ULL, 0x000fe20007fde0ffULL,
0x000000100b057824ULL, 0x000fe200078e0210ULL, 0xfffffff813137812ULL, 0x000fe200078ee20cULL,
0x000000100f0b7824ULL, 0x000fc400078e0210ULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x00005e000e0a7a11ULL, 0x000fe200078c38ffULL, 0x0000000006057faeULL, 0x0003e2000e101c46ULL,
0x000000011c0f7824ULL, 0x100fe400078e0204ULL, 0x00005f000e0e7a11ULL, 0x000fe200030f3c0dULL,
0x000000011a0d7824ULL, 0x040fe200078e0204ULL, 0x00000000080b7faeULL, 0x0005e2000e901c46ULL,
0x000000011a0c7824ULL, 0x100fe400078e0225ULL, 0x000000081e197824ULL, 0x000fe200078e00ffULL,
0x0000000d3c047210ULL, 0x000fe20007fbe0ffULL, 0x00000010130d7824ULL, 0x000fe200078e0210ULL,
0xfffffff815157812ULL, 0x000fe200078ee20cULL, 0x000000011c127824ULL, 0x000fe200078e0225ULL,
0xfffffff819057812ULL, 0x002fe200078ee214ULL, 0x000000ffff077224ULL, 0x000fe200028e06ffULL,
0x00005e0004067a11ULL, 0x000fe200078a38ffULL, 0x000000081c177824ULL, 0x000fe200078e00ffULL,
0x0000000f3c0c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001005137824ULL, 0x100fe200078e0210ULL,
0x00005f0004077a11ULL, 0x000fe200028f3c07ULL, 0x00000010150f7824ULL, 0x000fe200078e0210ULL,
0x0000001d0a047210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x004fe200020e06ffULL,
0x000000113c3c7210ULL, 0x000fc40007fde0ffULL, 0x00005e000c087a11ULL, 0x000fe200078838ffULL,
0x000000ffff057224ULL, 0x000fe200028e060eULL, 0x0000001d06067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0x00005e003c0a7a11ULL, 0x000fe400078c38ffULL,
0x00005f000c097a11ULL, 0x000fe200020f3c09ULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0xfffffff817117812ULL, 0x000fe200078ee212ULL, 0x00000000040d7faeULL, 0x0003e2000d901c46ULL,
0x0000001d08087210ULL, 0x000fc40007f9e0ffULL, 0x00005f003c0b7a11ULL, 0x000fe200030f3c0bULL,
0x0000001011117824ULL, 0x000fe200078e0210ULL, 0x0000001d0a0a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x00000000060f7faeULL, 0x0003e6000d101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200028e060bULL, 0x0000000008117faeULL, 0x0003e8000c901c46ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x00000d6000007947ULL, 0x000fea0003800000ULL,
0x0000000825067811ULL, 0x042fe400078fe8ffULL, 0x0000000425077811ULL, 0x000fc400078fe8ffULL,
0x0000000c250a7811ULL, 0x040fe200078fe8ffULL, 0x0000000106087824ULL, 0x140fe200078e0225ULL,
0x00000014250c7811ULL, 0x040fe200078fe8ffULL, 0x00000008060b7824ULL, 0x000fe200078e00ffULL,
0x00000018250d7811ULL, 0x000fe200078fe8ffULL, 0x0000000107057824ULL, 0x100fe200078e0225ULL,
0x0000001c250f7811ULL, 0x000fe200078fe8ffULL, 0x0000000807167824ULL, 0x000fe200078e00ffULL,
0xfffffff80b187812ULL, 0x000fe200078ee208ULL, 0x000000010a097824ULL, 0x040fe200078e0225ULL,
0x0000001025087811ULL, 0x040fe200078fe8ffULL, 0x000000080a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee205ULL, 0x000000080c1e7824ULL, 0x000fe200078e00ffULL,
0x0000002025107811ULL, 0x040fe200078fe8ffULL, 0x0000000108057824ULL, 0x000fe200078e0225ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL, 0x00000008081c7824ULL, 0x000fe200078e00ffULL,
0x0000002425117811ULL, 0x040fe200078fe8ffULL, 0x000000010c097824ULL, 0x100fe200078e0225ULL,
0x0000002825177811ULL, 0x000fe200078fe8ffULL, 0x000000010d0b7824ULL, 0x040fe200078e0225ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL, 0x000000080d207824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL, 0x000000010f057824ULL, 0x000fe200078e0225ULL,
0x0000002c25197811ULL, 0x000fe200078fe8ffULL, 0x000000080f227824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20bULL, 0x0000000110097824ULL, 0x040fe200078e0225ULL,
0x00000030251b7811ULL, 0x000fe200078fe8ffULL, 0x0000000810267824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x00000001110b7824ULL, 0x000fe200078e0225ULL,
0x00000034251d7811ULL, 0x000fe200078fe8ffULL, 0x0000000811287824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee209ULL, 0x0000000117057824ULL, 0x000fe200078e0225ULL,
0x00000038251f7811ULL, 0x000fe200078fe8ffULL, 0x00000008172a7824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee20bULL, 0x0000000119097824ULL, 0x000fe200078e0225ULL,
0x0000003c25217811ULL, 0x000fe200078fe8ffULL, 0x00000008192c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL, 0x000000011b0b7824ULL, 0x000fe200078e0225ULL,
0x0000000425057211ULL, 0x000fe200078fe8ffULL, 0x000000081b4c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee209ULL, 0x0000000107077824ULL, 0x000fe200078e0204ULL,
0x000000053c4a7210ULL, 0x000fe20007f1e0ffULL, 0x000000011d097824ULL, 0x040fe200078e0225ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee20bULL, 0x000000081d4e7824ULL, 0x000fe200078e00ffULL,
0x000000073c467210ULL, 0x000fe20007f3e0ffULL, 0x000000011f0b7824ULL, 0x000fc400078e0225ULL,
0x000000081f507824ULL, 0x000fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee209ULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e0046447a11ULL, 0x000fe200078238ffULL,
0x000000010a077824ULL, 0x100fe200078e0204ULL, 0xfffffff850507812ULL, 0x000fe200078ee20bULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e004a487a11ULL, 0x000fe200078038ffULL,
0x0000000106057824ULL, 0x000fe200078e0204ULL, 0x00005f0046467a11ULL, 0x000fe400008f3c09ULL,
0x00005f004a4a7a11ULL, 0x000fc400000f3c0bULL, 0x000000073c347210ULL, 0x000fe20007f3e0ffULL,
0x000000010c077824ULL, 0x100fe200078e0204ULL, 0x000000053c427210ULL, 0x000fe20007f1e0ffULL,
0x0000000108057824ULL, 0x100fe400078e0204ULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e00340a7a11ULL, 0x000fe200078238ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x000000053c327210ULL, 0x000fe20007f5e0ffULL, 0x000000010d057824ULL, 0x100fe200078e0204ULL,
0x00005e0042367a11ULL, 0x000fe200078038ffULL, 0x000000011d0d7824ULL, 0x000fe200078e0204ULL,
0x00005f0034347a11ULL, 0x000fc400008f3c09ULL, 0x000000073c307210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200010e06ffULL, 0x00005f0042427a11ULL, 0x000fe200000f3c0bULL,
0x000000011b0b7824ULL, 0x100fe200078e0204ULL, 0x00005e00320c7a11ULL, 0x000fe200078038ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e00300e7a11ULL, 0x000fe400078238ffULL,
0x00005f0032327a11ULL, 0x000fe200000f3c07ULL, 0x000000010f077824ULL, 0x100fe200078e0204ULL,
0x000000053c2e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000110057824ULL, 0x100fe200078e0204ULL,
0x00005f0030307a11ULL, 0x000fe200008f3c09ULL, 0x000000011f0f7824ULL, 0x000fe200078e0204ULL,
0x000000073c077210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x000000053c057210ULL, 0x000fc40007f5e0ffULL, 0x00005e002e107a11ULL, 0x040fe200078038ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e0007127a11ULL, 0x000fe200078238ffULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x00005f002e2e7a11ULL, 0x000fe200000f3c09ULL,
0x0000000119097824ULL, 0x000fe200078e0204ULL, 0x00005e0005147a11ULL, 0x000fe400078038ffULL,
0x00005f0007137a11ULL, 0x000fe200008f3c08ULL, 0x0000000200087824ULL, 0x000fe200078e0249ULL,
0x0000002525077211ULL, 0x000fc400078fe8ffULL, 0x00005f0005157a11ULL, 0x000fe200000f3c06ULL,
0x0000000111057824ULL, 0x100fe200078e0204ULL, 0x0000000707067812ULL, 0x000fe200078ec0ffULL,
0x0000000117077824ULL, 0x100fe200078e0204ULL, 0x00001000084f7811ULL, 0x000fe200078e68ffULL,
0x0000000121117824ULL, 0x040fe200078e0204ULL, 0x000000053c057210ULL, 0x040fe20007fde0ffULL,
0x0000000121047824ULL, 0x140fe200078e0225ULL, 0x0000000b3c0b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0x0ffffff806067812ULL, 0x000fe200078ef825ULL,
0x00000010161f7824ULL, 0x100fe200078e024fULL, 0x000000093c097210ULL, 0x000fe20007f1e0ffULL,
0x000000102c357824ULL, 0x100fe200078e024fULL, 0xfffffff821087812ULL, 0x000fe200078ee204ULL,
0x000000ffff047224ULL, 0x000fe200030e06ffULL, 0x00005e0005167a11ULL, 0x040fe200078c38ffULL,
0x000000101c277824ULL, 0x100fe200078e024fULL, 0x000000073c077210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff2c7224ULL, 0x000fe200008e06ffULL, 0x0000000d3c0d7210ULL, 0x000fe20007f5e0ffULL,
0x00000010061d7824ULL, 0x100fe200078e024fULL, 0x00005f0005177a11ULL, 0x000fe200030f3c04ULL,
0x0000001025057824ULL, 0x000fe200078e00ffULL, 0x0000000f3c0f7210ULL, 0x000fe20007f7e0ffULL,
0x000000101a237824ULL, 0x100fe200078e024fULL, 0x00005e000b1c7a11ULL, 0x000fe200078238ffULL,
0x000000102a337824ULL, 0x100fe200078e024fULL, 0x000000113c117210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005e00091a7a11ULL, 0x000fe200078038ffULL,
0x0000001018217824ULL, 0x100fe200078e024fULL, 0x00005f000b2c7a11ULL, 0x000fe200008f3c2cULL,
0x000000101e297824ULL, 0x100fe200078e024fULL, 0x0000007005517812ULL, 0x000fe200078ec0ffULL,
0x0000001028317824ULL, 0x100fe200078e024fULL, 0x00005e000d1e7a11ULL, 0x000fe200078238ffULL,
0x000000ffff067224ULL, 0x000fe200028e06ffULL, 0x00005e0007187a11ULL, 0x000fe200078a38ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005f00091b7a11ULL, 0x000fe200000f3c04ULL,
0x00000010202b7824ULL, 0x100fe200078e024fULL, 0x00005e000f207a11ULL, 0x000fe200078438ffULL,
0x00000010262f7824ULL, 0x100fe200078e024fULL, 0x00005f0007197a11ULL, 0x000fe200028f3c06ULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x0000005148047210ULL, 0x080fe20007f1e0ffULL,
0x00000010222d7824ULL, 0x100fe200078e024fULL, 0x00005e0011227a11ULL, 0x000fe200078638ffULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x00005f000d2a7a11ULL, 0x000fe200008f3c2aULL,
0x000000104c377824ULL, 0x100fe200078e024fULL, 0x00005f000f287a11ULL, 0x000fe200010f3c28ULL,
0x000000104e4b7824ULL, 0x100fe200078e024fULL, 0x0000005144067210ULL, 0x080fe20007f3e0ffULL,
0x00000010504d7824ULL, 0x100fe200078e024fULL, 0x00005f0011267a11ULL, 0x000fe200018f3c26ULL,
0x00000010084f7824ULL, 0x000fe200078e024fULL, 0x0000005136087210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e064aULL, 0x000000510a0a7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0646ULL, 0x000000510c0c7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0642ULL, 0x000000510e0e7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0634ULL, 0x0000005110107210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e0632ULL, 0x0000005112127210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e0630ULL, 0x0000005114147210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041d7faeULL, 0x0003e2000b901c46ULL,
0x0000005116167210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e062eULL,
0x0000005118187210ULL, 0x080fe20007fbe0ffULL, 0x00000000061f7faeULL, 0x0005e2000b901c46ULL,
0x000000511a1a7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x000000511c1c7210ULL, 0x080fe20007f1e0ffULL, 0x0000000008217faeULL, 0x0007e2000b901c46ULL,
0x000000511e1e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x0000005120207210ULL, 0x080fe20007f5e0ffULL, 0x000000000a237faeULL, 0x0009e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fe200018e0617ULL, 0x0000005122227210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x000000000c277faeULL, 0x0009e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fc400020e061bULL, 0x000000ffff1d7224ULL, 0x002fe200000e062cULL,
0x000000000e297faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x004fe400008e062aULL,
0x000000ffff217224ULL, 0x008fe200010e0628ULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x010fc600018e0626ULL, 0x00000000122d7faeULL, 0x0003e8000b901c46ULL,
0x00000000142f7faeULL, 0x0003e8000b901c46ULL, 0x0000000016317faeULL, 0x0003e8000b901c46ULL,
0x0000000018337faeULL, 0x0003e8000b901c46ULL, 0x000000001a357faeULL, 0x0003e8000b901c46ULL,
0x000000001c377faeULL, 0x0003e8000b901c46ULL, 0x000000001e4b7faeULL, 0x0003e8000b901c46ULL,
0x00000000204d7faeULL, 0x0003e8000b901c46ULL, 0x00000000224f7faeULL, 0x0003e4000b901c46ULL,
0x000000023a3a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000000033a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x002fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fd4000001ff00ULL, 0x000000023d048824ULL, 0x000fe400078e023aULL,
0x00000004ff058424ULL, 0x000fc800078e00ffULL, 0x0000600004048625ULL, 0x000fe200078e0005ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000006043c8981ULL, 0x000322000c1e1900ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x002fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff825267812ULL, 0x060fe200078ec0ffULL, 0x00000002002d7824ULL, 0x000fe200078e0245ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000020252c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000726277812ULL, 0x100fe400078ef825ULL, 0x000010002d2d7811ULL, 0x000fe400078e68ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ec0ffULL, 0x0000000127267824ULL, 0x040fe200078e0242ULL,
0x0000000142327810ULL, 0x000fe20007ffe0ffULL, 0x0000000827297824ULL, 0x040fe200078e00ffULL,
0x000000072c2f7812ULL, 0x100fe200078ef825ULL, 0x0000000827287824ULL, 0x000fe200078e00ffULL,
0x0000000725e27812ULL, 0x000fe200078ec0ffULL, 0x0000000127277824ULL, 0x000fe200078e0232ULL,
0xfffffff829267812ULL, 0x000fe200078ee226ULL, 0x000000012f2c7824ULL, 0x040fe200078e0242ULL,
0x00000004ffe37819ULL, 0x000fe20000011625ULL, 0x000000082f337824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee227ULL, 0x0000001026267824ULL, 0x000fe200078e022dULL,
0x00000008e2e57812ULL, 0x000fc400078ef825ULL, 0xfffffff8332c7812ULL, 0x000fe200078ee22cULL,
0x0000001028287824ULL, 0x000fe200078e022dULL, 0x000000002634783bULL, 0x000e6a0000000200ULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x00000018ff307819ULL, 0x002fe20000011435ULL,
0x0001000034577824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011436ULL,
0x0000003400af7306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x000fe20000011434ULL,
0x0001000035587824ULL, 0x000fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fc40000011457ULL,
0x00000018ff467819ULL, 0x004fe40000011428ULL, 0x00000018ff4e7819ULL, 0x000fe2000001142aULL,
0x0000003000aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff447819ULL, 0x000fe40000011437ULL, 0x00000018ff487819ULL, 0x000fe40000011429ULL,
0x00000018ff4f7819ULL, 0x000fe2000001142bULL, 0x0000003000ab7306ULL, 0x000e700000205400ULL,
0x00000030008c7306ULL, 0x0004f0000020d400ULL, 0x00000031009f7306ULL, 0x000fe20000209400ULL,
0x000000102c307824ULL, 0x004fe200078e022dULL, 0x000000abaa00720bULL, 0x002fe20003f3d000ULL,
0x000000012f2c7824ULL, 0x000fc400078e0232ULL, 0x000000082f2f7824ULL, 0x000fc600078e00ffULL,
0x0000003100a07306ULL, 0x000fe40000205400ULL, 0xfffffff82f2c7812ULL, 0x000fca00078ee22cULL,
0x000000102c2c7824ULL, 0x000fe200078e022dULL, 0x0000003100847306ULL, 0x0003e2000020d400ULL,
0x000000018c8c1812ULL, 0x008fce00078efcffULL, 0x0000003400ac7306ULL, 0x000ea20000005400ULL,
0x000000003030783bULL, 0x002e6e0000000200ULL, 0x0000003400907306ULL, 0x0006b0000000d400ULL,
0x0000003500a27306ULL, 0x000fe20000009400ULL, 0x0000010034347824ULL, 0x008fe200078e00ffULL,
0x000000acaf00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500a77306ULL, 0x000eae0000005400ULL, 0x0000000190905812ULL, 0x000fe200078efcffULL,
0x00000035008e7306ULL, 0x000670000000d400ULL, 0x0000005700b67306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x008fe200078e00ffULL, 0x000000a7a200720bULL, 0x004fc80003f7d000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000005700b97306ULL, 0x000eae0000205400ULL,
0x000000018e8e3812ULL, 0x002fe200078efcffULL, 0x00000057009d7306ULL, 0x0002e2000020d400ULL,
0x000000a09f00720bULL, 0x000fce0003f7d000ULL, 0x0000003600a37306ULL, 0x000fe20000009400ULL,
0x0001000036577824ULL, 0x002fe200078e00ffULL, 0x000000b9b600720bULL, 0x004fe20003fdd000ULL,
0x00000010e5b97824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000036009e7306ULL, 0x000e620000005400ULL, 0x0000000184843812ULL, 0x000fcc00078efcffULL,
0x000000019d9d6812ULL, 0x008fe200078efcffULL, 0x0000003600887306ULL, 0x0004f0000000d400ULL,
0x0000003400bb7306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x0000009ea300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003400b87306ULL, 0x000e6e0000205400ULL, 0x0000000188885812ULL, 0x008fe200078efcffULL,
0x0000003400a67306ULL, 0x0004f0000020d400ULL, 0x0000003500bc7306ULL, 0x000fe20000209400ULL,
0x0001000037347824ULL, 0x004fe200078e00ffULL, 0x000000b8bb00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500c17306ULL, 0x000e6e0000205400ULL,
0x00000001a6a60812ULL, 0x008fe200078efcffULL, 0x00000035008f7306ULL, 0x0004f0000020d400ULL,
0x0000002e00a97306ULL, 0x000fe20000209400ULL, 0x00000018ff357819ULL, 0x004fc40000011430ULL,
0x000000c1bc00720bULL, 0x002fca0003fdd000ULL, 0x0000002e00a87306ULL, 0x000e700000205400ULL,
0x0000002e00277306ULL, 0x000462000020d400ULL, 0x000000018f8f6812ULL, 0x008fce00078efcffULL,
0x0000003500d07306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x004ea20000000200ULL,
0x000000a8a900720bULL, 0x002fcc0003f9d000ULL, 0x0000003500d37306ULL, 0x000fee0000205400ULL,
0x0000000127274812ULL, 0x000fe200078efcffULL, 0x0000003500767306ULL, 0x0003e6000020d400ULL,
0x000000a62727723eULL, 0x000fca00000010ffULL, 0x0000002800967306ULL, 0x000fe20000009400ULL,
0x0001000028357824ULL, 0x002fce00078e00ffULL, 0x0000002800977306ULL, 0x000ff00000005400ULL,
0x0000002800567306ULL, 0x0003e2000000d400ULL, 0x00000018ff607819ULL, 0x004fe2000001142cULL,
0x000100002ca87824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fc4000001142fULL,
0x00000018ff647819ULL, 0x000fe4000001142eULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000003600ca7306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000003600cd7306ULL, 0x000ff00000205400ULL,
0x0000003600897306ULL, 0x0003f0000020d400ULL, 0x0000003400cc7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fce0000011431ULL, 0x0000003400cf7306ULL, 0x000e700000205400ULL,
0x0000003400877306ULL, 0x0004f0000020d400ULL, 0x0000003600d57306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fc40000011432ULL, 0x000000cfcc00720bULL, 0x002fca0003f3d000ULL,
0x0000003600d27306ULL, 0x000ff00000205400ULL, 0x0000003600717306ULL, 0x0003e2000020d400ULL,
0x0000000187871812ULL, 0x008fce00078efcffULL, 0x0000003400c97306ULL, 0x000fe20000209400ULL,
0x000100002a367824ULL, 0x002fce00078e00ffULL, 0x0000003400c87306ULL, 0x000ff00000205400ULL,
0x00000034006e7306ULL, 0x000ff0000020d400ULL, 0x0000002a00937306ULL, 0x000ff00000009400ULL,
0x0000002a00947306ULL, 0x000ff00000005400ULL, 0x0000002a00517306ULL, 0x0003f0000000d400ULL,
0x0000002800cb7306ULL, 0x000fe20000209400ULL, 0x000001002a2a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002800c67306ULL, 0x000ff00000205400ULL,
0x0000002800347306ULL, 0x0003f0000020d400ULL, 0x0000005700c47306ULL, 0x000fe20000209400ULL,
0x00000018ff287819ULL, 0x002fce0000011436ULL, 0x0000005700c77306ULL, 0x000e700000205400ULL,
0x00000057008d7306ULL, 0x0004f0000020d400ULL, 0x00000028007f7306ULL, 0x000fe20000209400ULL,
0x00000018ff577819ULL, 0x004fe20000011435ULL, 0x0001000029357824ULL, 0x000fe200078e00ffULL,
0x000000c7c400720bULL, 0x002fca0003f1d000ULL, 0x0000002800827306ULL, 0x000ff00000205400ULL,
0x0000002800367306ULL, 0x0003e2000020d400ULL, 0x000000018d8d0812ULL, 0x008fc800078efcffULL,
0x000000888d88723eULL, 0x000fc600000010ffULL, 0x0000005700c27306ULL, 0x000fe20000209400ULL,
0x000100002b287824ULL, 0x002fce00078e00ffULL, 0x0000005700c37306ULL, 0x000ff00000205400ULL,
0x0000005700697306ULL, 0x000ff0000020d400ULL, 0x0000002a00867306ULL, 0x000ff00000209400ULL,
0x0000002a00857306ULL, 0x000ff00000205400ULL, 0x0000002a00577306ULL, 0x0003f0000020d400ULL,
0x0000003000b57306ULL, 0x000fe20000009400ULL, 0x00000018ff2a7819ULL, 0x002fe20000011428ULL,
0x0001000030287824ULL, 0x000fcc00078e00ffULL, 0x0000003000b27306ULL, 0x000e700000005400ULL,
0x0000003000757306ULL, 0x0004f0000000d400ULL, 0x0000005800bd7306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x004fe200078e00ffULL, 0x000000b2b500720bULL, 0x002fc80003fbd000ULL,
0x00000018ffd67819ULL, 0x000fe20000011430ULL, 0x0001000031307824ULL, 0x000fe200078e00ffULL,
0x0000005800ba7306ULL, 0x000e680000205400ULL, 0x00000018ffd97819ULL, 0x000fc60000011430ULL,
0x0000000175755812ULL, 0x008fe200078efcffULL, 0x0000003700a17306ULL, 0x000ff00000009400ULL,
0x00000037009c7306ULL, 0x000ea20000005400ULL, 0x000000babd00720bULL, 0x002fce0003f5d000ULL,
0x00000037007c7306ULL, 0x0002f0000000d400ULL, 0x0000003100b07306ULL, 0x000fe20000009400ULL,
0x0000010037377824ULL, 0x002fe200078e00ffULL, 0x0000009ca100720bULL, 0x004fc80003f9d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003100b17306ULL, 0x000e6e0000005400ULL,
0x000000017c7c4812ULL, 0x008fe200078efcffULL, 0x0000003100727306ULL, 0x0004e6000000d400ULL,
0x0000007c877c723eULL, 0x000fca00000010ffULL, 0x0000002900957306ULL, 0x000fe20000009400ULL,
0x0000010031317824ULL, 0x004fe200078e00ffULL, 0x000000b1b000720bULL, 0x002fc80003f7d000ULL,
0x00000018ffde7819ULL, 0x000fe20000011431ULL, 0x0001000032317824ULL, 0x000fe200078e00ffULL,
0x0000002900927306ULL, 0x000fe80000005400ULL, 0x00000018ffe07819ULL, 0x000fc60000011431ULL,
0x0000000172723812ULL, 0x008fe200078efcffULL, 0x0000002900527306ULL, 0x0003e2000000d400ULL,
0x000000c8c900720bULL, 0x000fce0003f7d000ULL, 0x0000003200b37306ULL, 0x000fe20000009400ULL,
0x0000010029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000003200ae7306ULL, 0x000e620000005400ULL, 0x000000016e6e3812ULL, 0x000fce00078efcffULL,
0x00000032006c7306ULL, 0x0004f0000000d400ULL, 0x0000004400a47306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x004fe200078e00ffULL, 0x000000aeb300720bULL, 0x002fc80003f3d000ULL,
0x00000018ffe17819ULL, 0x000fe20000011432ULL, 0x0001000033327824ULL, 0x000fe200078e00ffULL,
0x0000004400a57306ULL, 0x000e6e0000205400ULL, 0x000000016c6c1812ULL, 0x008fe200078efcffULL,
0x0000005800ad7306ULL, 0x0004f0000020d400ULL, 0x0000003700ce7306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x004fc40000011435ULL, 0x000000a5a400720bULL, 0x002fca0003fdd000ULL,
0x0000003700d17306ULL, 0x000e620000205400ULL, 0x00000001adad2812ULL, 0x008fe400078efcffULL,
0x000000cdca00720bULL, 0x000fca0003f5d000ULL, 0x00000037007d7306ULL, 0x0004f0000020d400ULL,
0x0000005800bf7306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x004fe40000011433ULL,
0x0000000189892812ULL, 0x000fc400078efcffULL, 0x000000d1ce00720bULL, 0x002fe40003f1d000ULL,
0x000000898489723eULL, 0x000fe200000010ffULL, 0x0000003700c57306ULL, 0x000ff00000209400ULL,
0x0000003700c07306ULL, 0x000fe40000205400ULL, 0x000000017d7d0812ULL, 0x008fc400078efcffULL,
0x000000d3d000720bULL, 0x000fc80003f1d000ULL, 0x0000003700637306ULL, 0x000ff0000020d400ULL,
0x0000005800be7306ULL, 0x000fe20000205400ULL, 0x0000000176760812ULL, 0x000fce00078efcffULL,
0x0000005800357306ULL, 0x000ff0000020d400ULL, 0x0000002900b77306ULL, 0x000ff00000209400ULL,
0x0000002900b47306ULL, 0x000ff00000205400ULL, 0x0000002900377306ULL, 0x0003f0000020d400ULL,
0x00000060006f7306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x002fce000001142dULL,
0x0000006000707306ULL, 0x000ff00000205400ULL, 0x0000006000587306ULL, 0x000ff0000020d400ULL,
0x00000077005f7306ULL, 0x000ff00000209400ULL, 0x0000007700607306ULL, 0x000ff00000205400ULL,
0x0000007700617306ULL, 0x0003f0000020d400ULL, 0x000000de00da7306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x002fce0000011428ULL, 0x000000de00dd7306ULL, 0x000e700000205400ULL,
0x000000de00307306ULL, 0x0005f0000020d400ULL, 0x0000004400787306ULL, 0x000ee2000020d400ULL,
0x00000018ffde7819ULL, 0x004fe20000011432ULL, 0x0000010033327824ULL, 0x000fe200078e00ffULL,
0x000000ddda00720bULL, 0x002fca0003fbd000ULL, 0x0000002b00267306ULL, 0x000ff00000009400ULL,
0x0000002b00917306ULL, 0x000e620000005400ULL, 0x0000000178786812ULL, 0x008fe400078efcffULL,
0x000000d2d500720bULL, 0x000fc40003fdd000ULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x0000007d787d723eULL, 0x000fe200000010ffULL, 0x0000002b00507306ULL, 0x0004f0000000d400ULL,
0x0000002900597306ULL, 0x000fe20000209400ULL, 0x000001002b2b7824ULL, 0x004fe200078e00ffULL,
0x0000000171716812ULL, 0x000fc400078efcffULL, 0x000000912600720bULL, 0x002fe40003f7d000ULL,
0x00000018ff797819ULL, 0x000fe4000001142bULL, 0x00000029005a7306ULL, 0x000fe20000205400ULL,
0x000000909d26723eULL, 0x000fe200000010ffULL, 0x000100002e907824ULL, 0x000fca00078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011490ULL, 0x00000029005b7306ULL, 0x000fe2000020d400ULL,
0x0000000150503812ULL, 0x008fce00078efcffULL, 0x0000007700297306ULL, 0x000ff00000209400ULL,
0x0000007700287306ULL, 0x000e700000205400ULL, 0x00000077007a7306ULL, 0x000eb0000020d400ULL,
0x000000e000db7306ULL, 0x000fe20000209400ULL, 0x000000282900720bULL, 0x002fe20003f5d000ULL,
0x000100002d297824ULL, 0x000fca00078e00ffULL, 0x00000018ffa07819ULL, 0x000fe20000011429ULL,
0x000000e000d87306ULL, 0x000fec0000205400ULL, 0x000000017a7a2812ULL, 0x004fe400078efcffULL,
0x000000e000777306ULL, 0x0003e4000020d400ULL, 0x000000757a7a723eULL, 0x000fcc00000010ffULL,
0x0000002a00687306ULL, 0x000fe20000209400ULL, 0x00000018ffe07819ULL, 0x002fe20000011432ULL,
0x0000000242327824ULL, 0x040fe200078e02e3ULL, 0x0000000242427810ULL, 0x000fc60007ffe0ffULL,
0x00000001e5b67824ULL, 0x140fe200078e0232ULL, 0x00000002e5327810ULL, 0x040fe20007ffe032ULL,
0x0000002a006b7306ULL, 0x000fe20000205400ULL, 0x00000010e5e57824ULL, 0x000fe400078e00ffULL,
0xfffffff0b9b67812ULL, 0x000fc600078ee2b6ULL, 0xfffffff0e5ac7812ULL, 0x000fe400078ee232ULL,
0x0000002a00657306ULL, 0x000fe2000020d400ULL, 0x00000010b6287824ULL, 0x000fce00078e00ffULL,
0x000000d6002a7306ULL, 0x000ff00000209400ULL, 0x000000d6002b7306ULL, 0x000e700000205400ULL,
0x00000064005c7306ULL, 0x000ff00000209400ULL, 0x00000064005d7306ULL, 0x000fe20000205400ULL,
0x0000002b2a00720bULL, 0x002fc40003f9d000ULL, 0x000000002828783bULL, 0x000e6a0000000200ULL,
0x00000064005e7306ULL, 0x000ff0000020d400ULL, 0x0000007900647306ULL, 0x000ff00000209400ULL,
0x0000007900677306ULL, 0x000ff00000205400ULL, 0x0000007900667306ULL, 0x000ff0000020d400ULL,
0x00000033009a7306ULL, 0x000fe20000009400ULL, 0x000000262808723cULL, 0x042bee0000041808ULL,
0x00000033009b7306ULL, 0x000e620000005400ULL, 0x000000882820723cULL, 0x040fee0000041820ULL,
0x0000003300627306ULL, 0x000ea2000000d400ULL, 0x0000007c281c723cULL, 0x000fee000004181cULL,
0x000000d6007b7306ULL, 0x000ee2000020d400ULL, 0x0000009b9a00720bULL, 0x002fce0003fbd000ULL,
0x000000d900d47306ULL, 0x000fec0000209400ULL, 0x0000000162625812ULL, 0x004fe400078efcffULL,
0x000000d900d77306ULL, 0x000e620000205400ULL, 0x000000017b7b4812ULL, 0x008fe400078efcffULL,
0x000000d8db00720bULL, 0x000fc40003f9d000ULL, 0x000000c3c200720bULL, 0x000fe40003fbd000ULL,
0x0000007b767b723eULL, 0x000fe200000010ffULL, 0x000000d900797306ULL, 0x000eac000020d400ULL,
0x0000007a2818723cULL, 0x000fe40000041818ULL, 0x000000e100df7306ULL, 0x000fe20000209400ULL,
0x000000d7d400720bULL, 0x002fc40003f5d000ULL, 0x0000000177774812ULL, 0x000fe400078efcffULL,
0x000000929500720bULL, 0x000fe40003f9d000ULL, 0x0000000169695812ULL, 0x000fe200078efcffULL,
0x000000e100dc7306ULL, 0x000e620000205400ULL, 0x000000bebf00720bULL, 0x000fca0003fbd000ULL,
0x0000000179792812ULL, 0x004fe400078efcffULL, 0x000000e100317306ULL, 0x000ea2000020d400ULL,
0x000000979600720bULL, 0x000fe20003f5d000ULL, 0x000001002f967824ULL, 0x000fe200078e00ffULL,
0x0000000152524812ULL, 0x000fe400078efcffULL, 0x000000827f00720bULL, 0x000fe40003f9d000ULL,
0x000000727972723eULL, 0x000fe200000010ffULL, 0x000000de00d67306ULL, 0x000fe20000209400ULL,
0x000000dcdf00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x0000000135355812ULL, 0x000fe400078efcffULL, 0x0000000156562812ULL, 0x000fe200078efcffULL,
0x000000de00d97306ULL, 0x000e620000205400ULL, 0x000000523552723eULL, 0x000fe400000010ffULL,
0x0000000136364812ULL, 0x000fc600078efcffULL, 0x0000000131310812ULL, 0x004fe400078efcffULL,
0x000000de00337306ULL, 0x000ea2000020d400ULL, 0x000000949300720bULL, 0x000fe20003f1d000ULL,
0x000100002f947824ULL, 0x000fe200078e00ffULL, 0x000000316e31723eULL, 0x000fc800000010ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x000000e000e17306ULL, 0x000fe20000209400ULL,
0x000000d9d600720bULL, 0x002fca0003fdd000ULL, 0x0000000151510812ULL, 0x000fe400078efcffULL,
0x000000e000de7306ULL, 0x000e640000205400ULL, 0x000000513636723eULL, 0x000fc800000010ffULL,
0x0000000133336812ULL, 0x004fe400078efcffULL, 0x000000e000327306ULL, 0x000ea2000020d400ULL,
0x000000c0c500720bULL, 0x000fe40003fdd000ULL, 0x000000623362723eULL, 0x000fe400000010ffULL,
0x000000dee100720bULL, 0x002fc60003f3d000ULL, 0x0000004600987306ULL, 0x000fec0000209400ULL,
0x0000000163636812ULL, 0x000fe400078efcffULL, 0x0000004600997306ULL, 0x000e640000205400ULL,
0x0000000132321812ULL, 0x004fc400078efcffULL, 0x000000c6cb00720bULL, 0x000fc80003f3d000ULL,
0x0000004f00447306ULL, 0x000fe20000209400ULL, 0x000000326363723eULL, 0x000fce00000010ffULL,
0x0000004f00537306ULL, 0x000fe20000205400ULL, 0x000000999800720bULL, 0x002fe20003fdd000ULL,
0x00000062280c723cULL, 0x000fe2000004180cULL, 0x0000000134341812ULL, 0x000fe400078efcffULL,
0x000000b4b700720bULL, 0x000fc60003f3d000ULL, 0x0000004f004b7306ULL, 0x000ff0000020d400ULL,
0x0000002c00837306ULL, 0x000fe40000009400ULL, 0x0000000137371812ULL, 0x000fc400078efcffULL,
0x000000858600720bULL, 0x000fc80003f3d000ULL, 0x0000002c007e7306ULL, 0x000e700000005400ULL,
0x0000002c004f7306ULL, 0x0004e2000000d400ULL, 0x0000000157571812ULL, 0x000fce00078efcffULL,
0x0000004e00807306ULL, 0x000fe20000209400ULL, 0x000001002c2c7824ULL, 0x004fe200078e00ffULL,
0x0000007e8300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000004e00817306ULL, 0x000fee0000205400ULL, 0x000000014f4f5812ULL, 0x008fe200078efcffULL,
0x0000004e004c7306ULL, 0x000ff0000020d400ULL, 0x0000002d00747306ULL, 0x000ff00000009400ULL,
0x0000002d00737306ULL, 0x000ff00000005400ULL, 0x0000002d004e7306ULL, 0x0003f0000000d400ULL,
0x00000046004d7306ULL, 0x000ea2000020d400ULL, 0x000001002d2d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff917819ULL, 0x000fe4000001142dULL, 0x0000002c009e7306ULL, 0x000fe20000209400ULL,
0x0000008f8c2d723eULL, 0x000fce00000010ffULL, 0x0000002c00a37306ULL, 0x000e620000205400ULL,
0x000000014d4d6812ULL, 0x004fe400078efcffULL, 0x000000818000720bULL, 0x000fe40003fdd000ULL,
0x000000344d27723eULL, 0x020fc600000010ffULL, 0x0000002c009f7306ULL, 0x0004f0000020d400ULL,
0x00000048008a7306ULL, 0x000fe20000209400ULL, 0x0000008ead2c723eULL, 0x004fe400000010ffULL,
0x000000014c4c6812ULL, 0x000fc400078efcffULL, 0x000000a39e00720bULL, 0x002fe40003f3d000ULL,
0x000000706f00720bULL, 0x000fe20003fdd000ULL, 0x00000048008b7306ULL, 0x000e620000205400ULL,
0x0000002c2804723cULL, 0x000b6e0000041804ULL, 0x00000048004a7306ULL, 0x000ea2000020d400ULL,
0x00000010ac2c7824ULL, 0x020fe200078e00ffULL, 0x000000019f9f1812ULL, 0x008fc400078efcffULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x0000006b6800720bULL, 0x000fe40003f3d000ULL,
0x0000002e006a7306ULL, 0x000fe20000009400ULL, 0x0000008b8a00720bULL, 0x002fe40003f5d000ULL,
0x000000534400720bULL, 0x000fe40003fdd000ULL, 0x0000009f589d723eULL, 0x000fc600000010ffULL,
0x0000002e006d7306ULL, 0x000e660000005400ULL, 0x0000000165651812ULL, 0x000fe400078efcffULL,
0x0000005a5900720bULL, 0x000fe40003f3d000ULL, 0x000000014a4a2812ULL, 0x004fe200078efcffULL,
0x0000002e00487306ULL, 0x0004e2000000d400ULL, 0x000000737400720bULL, 0x000fe40003f5d000ULL,
0x000000307173723eULL, 0x000fc400000010ffULL, 0x0000006c7730723eULL, 0x000fe400000010ffULL,
0x000000014b4b6812ULL, 0x000fe200078efcffULL, 0x0000002f00547306ULL, 0x000fe20000009400ULL,
0x000001002e2e7824ULL, 0x004fe200078e00ffULL, 0x0000006d6a00720bULL, 0x002fe20003f1d000ULL,
0x000000722814723cULL, 0x000f620000041814ULL, 0x000000015b5b1812ULL, 0x000fe400078efcffULL,
0x00000018ff267819ULL, 0x000fe4000001142eULL, 0x0000002f00557306ULL, 0x000e620000005400ULL,
0x000000014e4e2812ULL, 0x000fc400078efcffULL, 0x000000302810723cULL, 0x000b620000041810ULL,
0x000000605f00720bULL, 0x000fe40003f5d000ULL, 0x000000374a53723eULL, 0x000fe400000010ffULL,
0x0000002f00467306ULL, 0x000462000000d400ULL, 0x0000000148480812ULL, 0x008fe400078efcffULL,
0x000000084200780cULL, 0x000fe40003f05270ULL, 0x000000574c37723eULL, 0x000fc400000010ffULL,
0x00000050654a723eULL, 0x000fe200000010ffULL, 0x000000a800a27306ULL, 0x000fe20000209400ULL,
0x000000002c2c783bULL, 0x004ea20000000200ULL, 0x000000555400720bULL, 0x002fe40003fbd000ULL,
0x0000000161612812ULL, 0x000fc800078efcffULL, 0x000000a800a17306ULL, 0x000e6e0000205400ULL,
0x0000000146465812ULL, 0x000fe200078efcffULL, 0x000000a8009c7306ULL, 0x000ef0000020d400ULL,
0x000000a000a47306ULL, 0x000fe20000209400ULL, 0x000000a1a200720bULL, 0x002fce0003f9d000ULL,
0x000000a000977306ULL, 0x000e6c0000205400ULL, 0x000000019c9c4812ULL, 0x008fe400078efcffULL,
0x000000a000937306ULL, 0x000ee2000020d400ULL, 0x000000522c04723cULL, 0x004f620000041804ULL,
0x0000004f9c9c723eULL, 0x000fcc00000010ffULL, 0x0000009100927306ULL, 0x000fe20000209400ULL,
0x00000097a400720bULL, 0x002fe20003f9d000ULL, 0x000000362c20723cULL, 0x040f6c0000041820ULL,
0x0000009100957306ULL, 0x000e640000205400ULL, 0x0000009c2c18723cULL, 0x000f680000041818ULL,
0x0000000193934812ULL, 0x008fc400078efcffULL, 0x00000090008a7306ULL, 0x000fe20000209400ULL,
0x000000676400720bULL, 0x000fe40003f9d000ULL, 0x0000004e934e723eULL, 0x000fca00000010ffULL,
0x0000009000817306ULL, 0x000ea20000205400ULL, 0x000000959200720bULL, 0x002fca0003f7d000ULL,
0x0000000166664812ULL, 0x000fe400078efcffULL, 0x0000002600747306ULL, 0x000fe20000209400ULL,
0x0000005d5c00720bULL, 0x000fe40003f9d000ULL, 0x000000664b4b723eULL, 0x000fca00000010ffULL,
0x00000026006d7306ULL, 0x000fe20000205400ULL, 0x000000818a00720bULL, 0x004fe20003fdd000ULL,
0x0000004a2c1c723cULL, 0x000f68000004181cULL, 0x000000015e5e4812ULL, 0x000fe400078efcffULL,
0x00000026006f7306ULL, 0x0003f0000020d400ULL, 0x00000091008e7306ULL, 0x000ea2000020d400ULL,
0x000000566926723eULL, 0x002fce00000010ffULL, 0x00000090007f7306ULL, 0x000e62000020d400ULL,
0x000000262c08723cULL, 0x000b6e0000041808ULL, 0x0000009400307306ULL, 0x020fe20000209400ULL,
0x000000018e8e3812ULL, 0x004fe400078efcffULL, 0x0000006d7400720bULL, 0x000fc40003f7d000ULL,
0x0000008e5b4f723eULL, 0x000fc600000010ffULL, 0x0000009400297306ULL, 0x000ea20000205400ULL,
0x000000017f7f6812ULL, 0x002fc600078efcffULL, 0x0000004e2c14723cULL, 0x000b680000041814ULL,
0x0000009600267306ULL, 0x000fe20000209400ULL, 0x000000016f6f3812ULL, 0x000fce00078efcffULL,
0x0000009600277306ULL, 0x000e620000205400ULL, 0x000000293000720bULL, 0x004fce0003f3d000ULL,
0x00000094002b7306ULL, 0x000eb0000020d400ULL, 0x0000009600967306ULL, 0x000ee2000020d400ULL,
0x000000272600720bULL, 0x002fe40003fdd000ULL, 0x000000487f26723eULL, 0x000fc400000010ffULL,
0x0000006f5e27723eULL, 0x000fe400000010ffULL, 0x000000012b2b1812ULL, 0x004fc800078efcffULL,
0x000000462b60723eULL, 0x000fe200000010ffULL, 0x000000262c10723cULL, 0x000b640000041810ULL,
0x0000000196966812ULL, 0x008fc800078efcffULL, 0x000000966161723eULL, 0x000fce00000010ffULL,
0x000000602c0c723cULL, 0x000b62000004180cULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe11000007947ULL, 0x000fcc000383ffffULL, 0x0000003e06287220ULL, 0x080fe40000410000ULL,
0x0000003e07297220ULL, 0x080fe40000410000ULL, 0x0000003e18187220ULL, 0x080fe40000410000ULL,
0x0000003e19197220ULL, 0x080fe40000410000ULL, 0x0000003e08087220ULL, 0x080fe40000410000ULL,
0x0000003e09097220ULL, 0x000fc40000410000ULL, 0x0000003e04047220ULL, 0x080fe40000410000ULL,
0x0000003e05057220ULL, 0x080fe40000410000ULL, 0x0000003e20207220ULL, 0x080fe40000410000ULL,
0x0000003e21217220ULL, 0x080fe40000410000ULL, 0x0000003e1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003e1d1d7220ULL, 0x000fc40000410000ULL, 0x0000003e14147220ULL, 0x0a0fe40000410000ULL,
0x0000003e15157220ULL, 0x080fe40000410000ULL, 0x0000003e10067220ULL, 0x080fe40000410000ULL,
0x0000003e11077220ULL, 0x080fe40000410000ULL, 0x0000003e1a2c7220ULL, 0x080fe40000410000ULL,
0x0000003e1b2d7220ULL, 0x000fc40000410000ULL, 0x0000003e12307220ULL, 0x080fe40000410000ULL,
0x0000003e13317220ULL, 0x080fe40000410000ULL, 0x0000003e0a267220ULL, 0x080fe40000410000ULL,
0x0000003e0b277220ULL, 0x080fe40000410000ULL, 0x0000003e162e7220ULL, 0x080fe40000410000ULL,
0x0000003e172f7220ULL, 0x000fc40000410000ULL, 0x0000003e0c1a7220ULL, 0x080fe40000410000ULL,
0x0000003e0d1b7220ULL, 0x080fe40000410000ULL, 0x0000003e0e327220ULL, 0x080fe40000410000ULL,
0x0000003e0f337220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fe400078e0018ULL,
0x000000ffff137224ULL, 0x000fc400078e0019ULL, 0x0000003e22227220ULL, 0x080fe40000410000ULL,
0x0000003e23237220ULL, 0x080fe40000410000ULL, 0x0000003e1e2a7220ULL, 0x080fe40000410000ULL,
0x0000003e1f2b7220ULL, 0x000fe40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0009ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0005ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff107224ULL, 0x000fe400078e001cULL,
0x000000ffff117224ULL, 0x000fc400078e001dULL, 0x000000ffff167224ULL, 0x000fe400078e0014ULL,
0x000000ffff177224ULL, 0x000fe400078e0015ULL, 0x000000ffff187224ULL, 0x000fe400078e0006ULL,
0x000000ffff197224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003f087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe400078e0026ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0027ULL, 0x000000ffff207224ULL, 0x000fe400078e0022ULL,
0x000000ffff217224ULL, 0x000fe400078e0023ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0029ULL, 0x000000ffff227224ULL, 0x000fe400078e002aULL,
0x000000ffff237224ULL, 0x000fc400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0031ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0033ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004003f077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604157210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003f077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000425157824ULL, 0x000fe200078e00ffULL, 0x000000404300720cULL, 0x000fc80003f05270ULL,
0xfffffff015057812ULL, 0x000fca00078ec0ffULL, 0x0000008000147824ULL, 0x000fca00078e0205ULL,
0x0174000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000225087824ULL, 0x000fe400078e00ffULL, 0x0000000102477824ULL, 0x000fc600078e0a47ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x00000001082e7812ULL, 0x040fe400078efcffULL,
0x0000000808307812ULL, 0x000fe400078efcffULL, 0x000000472e00720cULL, 0x080fe40003f26070ULL,
0x00000010082e7812ULL, 0x000fe400078efcffULL, 0x000000473000720cULL, 0x080fe40003f06070ULL,
0x000000472e00720cULL, 0x000fc40003fc6070ULL, 0x0000001108307812ULL, 0x040fe400078efcffULL,
0x00000018082e7812ULL, 0x040fe400078efcffULL, 0x000000470800720cULL, 0x080fe40003f46070ULL,
0x000000473000720cULL, 0x080fe40003fa6070ULL, 0x000000472e00720cULL, 0x000fe40003f66070ULL,
0x0000000908327812ULL, 0x000fc400078efcffULL, 0x0000001908307812ULL, 0x040fe400078efcffULL,
0x00000020082e7812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x000000473200720cULL, 0x080fe40003f86070ULL,
0x000000473000720cULL, 0x080fe40003f46070ULL, 0x000000472e00720cULL, 0x000fe40003f26070ULL,
0x0000002108307812ULL, 0x040fe400078efcffULL, 0x00000028082e7812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000473000720cULL, 0x080fe40003f06070ULL, 0x000000472e00720cULL, 0x000fe40003f86070ULL,
0x0000002908307812ULL, 0x000fc400078efcffULL, 0x00000030082e7812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000473000720cULL, 0x000fc40003fc6070ULL, 0x000000472e00720cULL, 0x000fe40003fa6070ULL,
0x0000003108307812ULL, 0x040fe400078efcffULL, 0x00000038082e7812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000026267808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000473000720cULL, 0x080fe40003f66070ULL,
0x000000472e00720cULL, 0x000fc40003f46070ULL, 0x000000470800720cULL, 0x000fe40003f26070ULL,
0xff80000027277808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000028287808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000029297808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff8000002b2b7808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000002c2c7808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fe40003f3e000ULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000090c047208ULL, 0x000fe40004000000ULL, 0x000000051e087208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x000000040d057208ULL, 0x000fe40004000000ULL, 0x000000081f097208ULL, 0x000fc40004800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fc40003f3e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x0000000821097208ULL, 0x000fe40004800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fe40003f3e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x0000000922087208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fe40004800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fc40003f3e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x0000000926087208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fe40003f3e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x0000000827097208ULL, 0x000fc40004800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x0000000516047208ULL, 0x000fe40004000000ULL, 0x0000000928087208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000290800720bULL, 0x000fc40003f3e000ULL,
0x0000000417057208ULL, 0x000fe40004000000ULL, 0x0000000829097208ULL, 0x000fe40004800000ULL,
0x000000180500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000518047208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x0000000419057208ULL, 0x000fe40004000000ULL, 0x000000082b097208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x0000002c0900720bULL, 0x000fc40003f3e000ULL,
0x000000051a047208ULL, 0x000fe40004000000ULL, 0x000000092c087208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002d0800720bULL, 0x000fe40003f3e000ULL,
0x000000041b307208ULL, 0x000fe40004000000ULL, 0x000000082d327208ULL, 0x000fe20004800000ULL,
0x000017c27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0030047f89ULL, 0x0004e400000e0000ULL,
0x000000043000720bULL, 0x008fc80003f1e000ULL, 0x0000003004337208ULL, 0x000fe20004000000ULL,
0x000017f27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0032047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000e6800000e0000ULL, 0x0c401f00072e7f89ULL, 0x000ea200000e0000ULL,
0x000000043200720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x002fe40003f3e000ULL,
0x0000003204087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f0033047f89ULL, 0x000e6200000e0000ULL, 0x0000002e0700720bULL, 0x004fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000ea200000e0000ULL, 0x000000072e2e7208ULL, 0x000fc60004000000ULL,
0x0c201f0009307f89ULL, 0x000ee800000e0000ULL, 0x0c201f002e2f7f89ULL, 0x0002e400000e0000ULL,
0x000000043300720bULL, 0x002fe40003f1e000ULL, 0x000000050800720bULL, 0x004fe40003f3e000ULL,
0x0000003304047208ULL, 0x000fc40004000000ULL, 0x000000300900720bULL, 0x008fe40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x0000000930067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b05307820ULL, 0x002fe20000410000ULL, 0x00000002ff317819ULL, 0x000fe20000011625ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x0000000325ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x0000002f2e00720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b0d0d7823ULL, 0x000fe20000010807ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fc40000010830ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010830ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe40000010830ULL,
0x00000004ff347e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3f8000003434783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b10107823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b11117823ULL, 0x000fe40000010807ULL,
0x000000ffff357224ULL, 0x000fe400078e0034ULL, 0x0000000d000d7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b20207823ULL, 0x000fc40000010830ULL, 0x3fb8aa3b21217823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b22227823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b23237823ULL, 0x000fe20000010830ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x000000080908723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b16167823ULL, 0x000fc40000010807ULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b17177823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010830ULL,
0x0000001e000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b29297823ULL, 0x000fc40000010830ULL, 0x3fb8aa3b18187823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL, 0x0000001f00327308ULL, 0x000ea20000000800ULL,
0x0000001c1d09723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b2b2b7823ULL, 0x000fe40000010830ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b077823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fe40000010830ULL,
0x0000000831307824ULL, 0x040fe200078e00ffULL, 0x0000000b320b723eULL, 0x004fe200000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000000831337824ULL, 0x040fe400078e00ffULL,
0x0000000831377824ULL, 0x000fc600078e00ffULL, 0x00000034081c723cULL, 0x000f6400000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fe400000010ffULL,
0x0000000131107810ULL, 0x000fca0007ffe0ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x00000020210d723eULL, 0x002fe200000010ffULL,
0x0000000831217824ULL, 0x040fe200078e00ffULL, 0x0000000431207810ULL, 0x000fc80007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000022230f723eULL, 0x004fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000000831237824ULL, 0x040fe400078e00ffULL, 0x0000000831227824ULL, 0x000fe200078e00ffULL,
0x000000340c1c723cULL, 0x020f68000004181cULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000161712723eULL, 0x004fe400000010ffULL, 0x0000000231167810ULL, 0x000fc40007ffe0ffULL,
0x0000000331177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee216ULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x000000262711723eULL, 0x002fc400000010ffULL, 0xfffffff822277812ULL, 0x000fe400078ee217ULL,
0x0000000631227810ULL, 0x040fe40007ffe0ffULL, 0xffffffff31267810ULL, 0x000fe20007ffe0ffULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0xfffffff830177812ULL, 0x000fe400078ee231ULL,
0x000000282913723eULL, 0x004fca00000010ffULL, 0x0000001900197308ULL, 0x000e620000000800ULL,
0x0000000831297824ULL, 0x040fe200078e00ffULL, 0x0000000831287810ULL, 0x000fe20007ffe0ffULL,
0x00000034101c723cULL, 0x020b66000004181cULL, 0xfffffff829297812ULL, 0x000fe400078ee220ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x0000000531207810ULL, 0x000fe20007ffe0ffULL,
0x0000000828457824ULL, 0x000fc400078e00ffULL, 0x0000000831357824ULL, 0x020fe200078e00ffULL,
0xfffffff833317812ULL, 0x000fc600078ee220ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x000000181918723eULL, 0x002fe400000010ffULL, 0x0001100000207811ULL, 0x000fe400078e58ffULL,
0xfffffff835337812ULL, 0x000fe400078ee222ULL, 0xfffffff837357812ULL, 0x000fe200078ee226ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000001017177824ULL, 0x100fe400078e0220ULL,
0x0000001021217824ULL, 0x000fc400078e0220ULL, 0x0000001023237824ULL, 0x100fe400078e0220ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x0000002a2b19723eULL, 0x004fe200000010ffULL, 0x000000ffff2a7224ULL, 0x100fe400078e0034ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0034ULL, 0x0000001029297824ULL, 0x100fe400078e0220ULL,
0x0000002c001b7308ULL, 0x000fe20000000800ULL, 0x0000001031317824ULL, 0x000fc400078e0220ULL,
0x0000001033337824ULL, 0x100fe400078e0220ULL, 0x0000001035357824ULL, 0x000fc600078e0220ULL,
0x0000002d00167308ULL, 0x0004e20000000800ULL, 0x0000001a071a723eULL, 0x002fe400000010ffULL,
0x0000002e2f077208ULL, 0x000fe40004800000ULL, 0xfffffff8452d7812ULL, 0x004fca00078ee228ULL,
0x000000102d2d7824ULL, 0x000fe200078e0220ULL, 0x0000001b161b723eULL, 0x008fe400000010ffULL,
0x0000000c15167812ULL, 0x000fca00078ec0ffULL, 0x0000002a181c723cULL, 0x000f62000004181cULL,
0x0000000117177824ULL, 0x000fe400078e0216ULL, 0x0000000116217824ULL, 0x040fe400078e0221ULL,
0x0000000116237824ULL, 0x040fe200078e0223ULL, 0x0000000817007388ULL, 0x0003e20000000800ULL,
0x0000000116277824ULL, 0x040fe400078e0227ULL, 0x0000000116297824ULL, 0x040fe200078e0229ULL,
0x0000000a21007388ULL, 0x0003e20000000800ULL, 0x0000000116317824ULL, 0x000fc400078e0231ULL,
0x0000000116337824ULL, 0x040fe200078e0233ULL, 0x0000000c23007388ULL, 0x0003e20000000800ULL,
0x0000000116357824ULL, 0x040fe400078e0235ULL, 0x0000000116167824ULL, 0x000fe200078e022dULL,
0x0000000e27007388ULL, 0x0003e80000000800ULL, 0x0000001029007388ULL, 0x0003e40000000800ULL,
0x000000ffff1d7224ULL, 0x020fc400078e001eULL, 0x0000001231007388ULL, 0x0003e80000000800ULL,
0x0000001833007388ULL, 0x0003e80000000800ULL, 0x0000001a35007388ULL, 0x0003e80000000800ULL,
0x0000000916007388ULL, 0x0003e80000000800ULL, 0x0004000b21007388ULL, 0x0003e80000000800ULL,
0x0004000d23007388ULL, 0x0003e80000000800ULL, 0x0004000f27007388ULL, 0x0003e80000000800ULL,
0x0004001129007388ULL, 0x0003e80000000800ULL, 0x0004001331007388ULL, 0x0003e80000000800ULL,
0x0004001933007388ULL, 0x0003e80000000800ULL, 0x0004001b35007388ULL, 0x0003e80000000800ULL,
0x0170000414008388ULL, 0x0003e80000000c00ULL, 0x0172001c14008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000041ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080041ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100041ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000143437810ULL, 0x000fe20007ffe0ffULL,
0x0000180041ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff457224ULL, 0x000fc400078e0049ULL,
0x000000244300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffa65000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff2a7807ULL, 0x004fe20004000000ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x00017dc000317802ULL, 0x000fc40000000f00ULL, 0x0000101000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0030ULL, 0xfffea53000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x000fe20004000000ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x00017e2000317802ULL, 0x000fc40000000f00ULL, 0x00000fb000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0030ULL, 0xfffea57000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x004fe200078e0035ULL, 0x00017e9000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x00000ef000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e0030ULL,
0xfffea61000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0035ULL,
0x00017f0000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x00000e8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e0030ULL, 0xfffea71000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e002dULL, 0x00017f8000327802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e002cULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x00000e0000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e0030ULL, 0xfffeab0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0048ULL, 0x0001800000327802ULL, 0x000fe20000000f00ULL,
0x000000ffff307224ULL, 0x000fc400078e002dULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x00000d8000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff487224ULL, 0x004fe200078e0030ULL, 0xfffeaab000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x008fe20004000000ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x0001806000317802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e0030ULL, 0xfffedbb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x000fe20004000000ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x000180c000317802ULL, 0x000fc40000000f00ULL, 0x00000d1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0030ULL, 0xfffedbf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e002fULL, 0x0001813000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x00000c5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e0030ULL,
0xfffedcb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e002fULL,
0x000181a000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x00000be000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e0030ULL, 0xfffedda000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0028ULL, 0x0001822000327802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0029ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x00000b6000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e0030ULL, 0xfffee19000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0028ULL, 0x0001829000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x00000af000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e0030ULL,
0xfffee15000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2a7807ULL, 0x004fe20004000000ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x000182f000317802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e0030ULL,
0xffff0fd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2a7807ULL, 0x000fe20004000000ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x0001835000317802ULL, 0x000fc40000000f00ULL,
0x00000a8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0030ULL,
0xffff101000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0033ULL,
0x000183c000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x000009c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e0030ULL, 0xffff10d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0033ULL, 0x0001843000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x0000095000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e0030ULL,
0xffff11c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0028ULL,
0x000184b000327802ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0029ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x000008d000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff477224ULL, 0x004fe200078e0030ULL,
0xffff15b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0028ULL,
0x0001852000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x0000086000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff487224ULL, 0x004fe200078e0030ULL, 0xffff157000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x008fe20004000000ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x0001858000317802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0030ULL, 0xffff43d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x000fe20004000000ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x000185e000317802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0030ULL, 0xffff441000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e002fULL, 0x0001865000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x0000073000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e0030ULL,
0xffff44c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e002fULL,
0x000186c000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x000006c000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e0030ULL, 0xffff45b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0028ULL, 0x0001874000327802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0029ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff377424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff477224ULL, 0x004fe200078e0030ULL, 0xffff498000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0028ULL, 0x000187b000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e0030ULL,
0xffff494000007947ULL, 0x000fea000383ffffULL, 0x00000002ff317424ULL, 0x000fe200078e00ffULL,
0x0001882000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002fULL, 0xffffe7e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x006fe200078e0032ULL, 0x000188a000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fc400078e00ffULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x010fea0003c00000ULL,
0x0000002f3200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff307224ULL, 0x002fe200078e0006ULL,
0x0001892000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fe200078e00ffULL,
0x000000322f327208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff307224ULL, 0x002fe200078e0007ULL,
0x000189a000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fe200078e00ffULL,
0x000000062f067208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff307224ULL, 0x002fe200078e0033ULL,
0x00018a2000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fe200078e00ffULL,
0x000000072f2e7208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x0000002f3300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff307224ULL, 0x002fe200078e0032ULL,
0x00018aa000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fe200078e00ffULL,
0x000000332f047208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000002f3200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff307224ULL, 0x002fe200078e0006ULL,
0x00018b2000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fe200078e00ffULL,
0x000000322f057208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff307224ULL, 0x002fe200078e002eULL,
0x00018ba000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fe200078e00ffULL,
0x000000062f067208ULL, 0x000fe20004000000ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0xffffe5d000007947ULL, 0x000fea000383ffffULL, 0x018000003a027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000003a00028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff3aff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x800000003a037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003a00027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe72c002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003400007348ULL, 0x000fe80003800000ULL,
0x0c000031302f7389ULL, 0x0002a200000e002fULL, 0xfffe728008007950ULL, 0x000fea0003c3ffffULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x0000002a30307389ULL, 0x0002a200000e0031ULL,
0x00000000ff2b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff2a7224ULL, 0x002fc800078e0032ULL,
0xfffe72302a007950ULL, 0x000fea0003c3ffffULL, 0x000000012a00780cULL, 0x000fe20003f05070ULL,
0x0000002b00007348ULL, 0x000fd80003800000ULL, 0x00000000002a7806ULL, 0x000fc800040e0100ULL,
0x0000002b2a307212ULL, 0x000fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe400078e0031ULL,
0x00000000ff2b7424ULL, 0x000fc800078e00ffULL, 0xfffe71c02a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000420ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000df0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eb0ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001638ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001648ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016d8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016dcULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000018f00ULL, 0xe800001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a800ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a850ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001abd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000016d8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019128ULL, 0x0000000000019128ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001a800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001abd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 109744;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
