/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018a50ULL, 0x00000000000186d0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x0000000000016ae0ULL,
0x0000000000000190ULL, 0x000b0022000004c4ULL, 0x0000000000016c70ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000016cb0ULL, 0x0000000000000050ULL, 0x000b002200000519ULL,
0x0000000000016d00ULL, 0x0000000000000100ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000016e00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00016ae000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x0059780400288080ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0xa408288080a30828ULL, 0x288080a508288080ULL,
0x80a708288080a608ULL, 0x08288080a8082880ULL, 0x8080aa08288080a9ULL, 0xac08288080ab0828ULL,
0x288080ae08288080ULL, 0x80b008288080af08ULL, 0x08288080b1082880ULL, 0x8082801628808085ULL,
0x0000000000031028ULL, 0x2880808592000000ULL, 0x0000000000002200ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x00016ae000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL,
0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL, 0x000000a4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x9a08288080840828ULL, 0x2880809b08288080ULL, 0x809f082880809c08ULL,
0x08288080a0082880ULL, 0x8080a208288080a1ULL, 0xa408288080a30828ULL, 0x288080a508288080ULL,
0x80a708288080a608ULL, 0x08288080a8082880ULL, 0x8080ac08288080aaULL, 0xaf08288080ae0828ULL,
0x288080b108288080ULL, 0x8280162880808808ULL, 0x0000000003102880ULL, 0x8080889200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000014800000000ULL, 0x00016c7000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9b082880809a0828ULL, 0x2880809c08288080ULL, 0x80a0082880809f08ULL, 0x08288080a1082880ULL,
0x8080a308288080a2ULL, 0xa508288080a40828ULL, 0x288080a608288080ULL, 0x80a808288080a708ULL,
0x08288080aa082880ULL, 0x8080ae08288080acULL, 0xb008288080af0828ULL, 0x288080b108288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b1ULL, 0x0000002cffffffffULL,
0x0000022000000000ULL, 0x00016cb000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x80a6288080b10900ULL, 0x0000000000002880ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9b082880809a0828ULL, 0x2880809c08288080ULL, 0x80a0082880809f08ULL, 0x08288080a1082880ULL,
0x8080a308288080a2ULL, 0xa508288080a40828ULL, 0x288080a608288080ULL, 0x80a808288080a708ULL,
0x08288080aa082880ULL, 0x8080ae08288080acULL, 0xb108288080af0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080b1920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000030000000000ULL, 0x00016d0000000000ULL, 0x0000010000000000ULL, 0x0000180400000000ULL,
0x80a6288080b10900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x00082304000000d7ULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0050016000000017ULL, 0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000002000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f001342804ULL, 0x0000040000000110ULL, 0x000023d000002310ULL, 0x00002650000024e0ULL,
0x00002af000002ac0ULL, 0x00002b9000002b40ULL, 0x00005cb000005c10ULL, 0x00005f4000005de0ULL,
0x000063e0000063b0ULL, 0x0000648000006430ULL, 0x0000931000009270ULL, 0x000095a000009440ULL,
0x00009a4000009a10ULL, 0x00009ae000009a90ULL, 0x0000c9600000c8c0ULL, 0x0000cbe00000ca80ULL,
0x0000d0600000d030ULL, 0x0000d1000000d0b0ULL, 0x0000f2e00000f2d0ULL, 0x00015310000152d0ULL,
0x0001533000015320ULL, 0x000153a000015380ULL, 0x000153d0000153c0ULL, 0x000160a000016050ULL,
0x00016140000160f0ULL, 0x00016200000161a0ULL, 0x000162a000016250ULL, 0x00016340000162f0ULL,
0x000163f0000163a0ULL, 0x0001649000016440ULL, 0x00016530000164e0ULL, 0x000165e000016590ULL,
0x0001668000016630ULL, 0x00016720000166d0ULL, 0x000167d000016780ULL, 0x0001688000016820ULL,
0x00016940000168e0ULL, 0x00016a00000169a0ULL, 0x00016ac000016a60ULL, 0x0000021004403904ULL,
0x0000f600000000ffULL, 0x000002a0003f0100ULL, 0x0000f6080000000dULL, 0x000002d0003f0120ULL,
0x0000f6880000000dULL, 0x000003a0003f0120ULL, 0x0000f6a80000000dULL, 0x000003d0003f0120ULL,
0x0000f6c80000000dULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000600003f0107ULL,
0x0000000400000007ULL, 0x000006b0003f0102ULL, 0x0000000000000007ULL, 0x00001000003f0101ULL,
0x00000000000000ffULL, 0x0000108000040107ULL, 0x00000000000000ffULL, 0x000010e000040101ULL,
0x0000002000000024ULL, 0x000012b0003f0101ULL, 0x0000f6cc0000002dULL, 0x00001480003f0105ULL,
0x0000f6cc0000002dULL, 0x00001e40003f0105ULL, 0x0000f6a80000003fULL, 0x00001fb0003f0107ULL,
0x0000f6a80000003fULL, 0x00002010003f0101ULL, 0x0000f6080000003eULL, 0x00002030003f0101ULL,
0x0000f60c0000003eULL, 0x00002200003f0105ULL, 0x0000f60c0000003eULL, 0x00002820003f0105ULL,
0x0000f6ac0000002dULL, 0x000029f0003f0105ULL, 0x0000f6ac0000002dULL, 0x00004b70003f0105ULL,
0x0000f6c800000024ULL, 0x00004bf0003f0101ULL, 0x0000f68800000050ULL, 0x00004c80003f0101ULL,
0x0000000400000041ULL, 0x00004e50003f0105ULL, 0x0000000400000041ULL, 0x00005840003f0105ULL,
0x0000f6a800000058ULL, 0x00005910003f0107ULL, 0x0000f6a800000058ULL, 0x00005970003f0101ULL,
0x0000f6280000003eULL, 0x00005990003f0101ULL, 0x0000f62c0000003eULL, 0x00005b60003f0105ULL,
0x0000f62c0000003eULL, 0x00006110003f0105ULL, 0x0000f6ac0000003fULL, 0x000062e0003f0105ULL,
0x0000f6ac0000003fULL, 0x00008280003f0105ULL, 0x0000000000000024ULL, 0x000082f0003f0101ULL,
0x0000f69000000050ULL, 0x00008360003f0101ULL, 0x0000000400000041ULL, 0x00008530003f0105ULL,
0x0000000400000041ULL, 0x00008e10003f0105ULL, 0x0000000000000053ULL, 0x00008f70003f0107ULL,
0x0000f6a80000003fULL, 0x00008fd0003f0101ULL, 0x0000f6480000003eULL, 0x00008ff0003f0101ULL,
0x0000f64c0000003eULL, 0x000091c0003f0105ULL, 0x0000f64c0000003eULL, 0x00009770003f0105ULL,
0x0000f6ac00000058ULL, 0x00009940003f0105ULL, 0x0000f6ac00000058ULL, 0x0000b900003f0105ULL,
0x0000000000000024ULL, 0x0000b970003f0101ULL, 0x0000f69800000050ULL, 0x0000ba00003f0101ULL,
0x0000000400000041ULL, 0x0000bbd0003f0105ULL, 0x0000000400000041ULL, 0x0000c4d0003f0105ULL,
0x0000000000000059ULL, 0x0000c5b0003f0107ULL, 0x0000f6a800000058ULL, 0x0000c610003f0101ULL,
0x0000f6680000003eULL, 0x0000c640003f0101ULL, 0x0000f66c0000003eULL, 0x0000c810003f0105ULL,
0x0000f66c0000003eULL, 0x0000cd90003f0105ULL, 0x0000f6ac0000003fULL, 0x0000cf60003f0105ULL,
0x0000f6ac0000003fULL, 0x0000ee80003f0105ULL, 0x0000000000000024ULL, 0x0000eee0003f0101ULL,
0x0000f6a000000050ULL, 0x0000ff20003f0101ULL, 0x0000f600000000ffULL, 0x00010d30003f0101ULL,
0x0000f604000000ffULL, 0x00010f00003f0105ULL, 0x0000f604000000ffULL, 0x00011130003f0105ULL,
0x0000f600000000ffULL, 0x00011160003f0101ULL, 0x0000f604000000ffULL, 0x00011320003f0105ULL,
0x0000f604000000ffULL, 0x000146d0003f0105ULL, 0x0000000000000040ULL, 0x00014800003f0101ULL,
0x0000000400000040ULL, 0x000149d0003f0105ULL, 0x0000000400000040ULL, 0x00015eb0003f0105ULL,
0x0000000000000042ULL, 0x00015f10003f0101ULL, 0x0000000800000042ULL, 0x00015f70003f0101ULL,
0x0000001000000042ULL, 0x00015fe0003f0101ULL, 0x0000001800000042ULL, 0x00053803003f0101ULL,
0x0000fbb000141c04ULL, 0x000113800000fe30ULL, 0x0001602000011440ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000003bcULL, 0x0000001a00000002ULL, 0x00000000000002dcULL,
0x0000001a00000002ULL, 0x000000000000020cULL, 0x0000001a00000002ULL, 0x000000000000011cULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000392ULL,
0x0000001a00000002ULL, 0x00000000000002b7ULL, 0x0000001a00000002ULL, 0x00000000000001e4ULL,
0x0000001a00000002ULL, 0x00000000000000f3ULL, 0x0000001a00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff387624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001200047300ULL, 0x000ee200000e0000ULL, 0x0000000838077824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000f280000002200ULL, 0x00000000004b7919ULL, 0x000ee20000000000ULL,
0x0000001200127309ULL, 0x000ea60000000000ULL, 0x00000000002f7919ULL, 0x000ee80000002600ULL,
0x00000000003f7919ULL, 0x000ee20000002700ULL, 0x00000005ff007819ULL, 0x002fc6000001160dULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x00001fff030b7589ULL, 0x0045e200000e0000ULL,
0x0000010003027a24ULL, 0x010fc600078e0202ULL, 0x00001fff00007589ULL, 0x000f2200000e0000ULL,
0x00000000020d7a24ULL, 0x000fe200078e020dULL, 0x00000004ff0c7819ULL, 0x008fe2000001164bULL,
0x000000104b0e7824ULL, 0x000fe400078e00ffULL, 0x000000082f067824ULL, 0x000fe200078e00ffULL,
0x000000ff0d00720cULL, 0x040fe40003f45270ULL, 0x0000007f0d00780cULL, 0x000fe20003f84070ULL,
0x0000003f07087224ULL, 0x000fe200078e0206ULL, 0x0000000f0d00780cULL, 0x000fc40003f64070ULL,
0x000000030d00780cULL, 0x000fe40003f24070ULL, 0x000000050400720cULL, 0x002fe40003f02070ULL,
0x000000f00e117812ULL, 0x000fc600078ec0ffULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x004fe400078e00ffULL, 0x000000040b097824ULL, 0x010fe400078e0200ULL,
0xff317217ff10c424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x0000000209097824ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f44070ULL,
0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL, 0x00f400100d00c388ULL, 0x0005e20000004800ULL,
0x7fffffc0ff05b424ULL, 0x000fe200078e00ffULL, 0x00000008090a7817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fc400078e00ffULL, 0x7fffff60ff079424ULL, 0x000fe200078e00ffULL,
0x00f608040d00b388ULL, 0x0007e20000008a00ULL, 0x000000010a0a7824ULL, 0x000fe400078e0a09ULL,
0x0000000109097824ULL, 0x000fe200078e020cULL, 0x00f688060d009388ULL, 0x0009e20000008a00ULL,
0x00000100ff037424ULL, 0x002fe200078e00ffULL, 0x0000000a0c00720cULL, 0x000fe20003f66070ULL,
0x0000000108027824ULL, 0x000fe400078e0209ULL, 0x00000001090f7824ULL, 0x000fc400078e024bULL,
0x0000001009107824ULL, 0x004fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0003ULL,
0xfffffff0100f7812ULL, 0x000fe200078ee20fULL, 0x3fffff80ff049424ULL, 0x008fe200078e00ffULL,
0x0000001102027210ULL, 0x000fe20007f9e0ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f6a8040d009388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fe400020e0603ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x00f6c8080d00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff067224ULL, 0x010fc400078e0a12ULL, 0x00000004ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0003e2000d901c46ULL, 0x000062003f047625ULL, 0x000fc600078e000cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604027981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0b00720cULL, 0x000fc40003f05270ULL,
0x0000007f02037810ULL, 0x044fe40007ffe0ffULL, 0x000000ff020a7810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff037819ULL, 0x000fe40000011603ULL, 0x00000008ff2c7819ULL, 0x000fca000001160aULL,
0x0000f8f000008947ULL, 0x000fea0003800000ULL, 0x00000003ff567819ULL, 0x000fe20000011600ULL,
0x00000003ff067424ULL, 0x000fe200078e00ffULL, 0x0000f68800077811ULL, 0x000fe200078e18ffULL,
0xffffffffff4a7424ULL, 0x000fe200078e00ffULL, 0x01ffffff56567812ULL, 0x000fc800078ec0ffULL,
0x000000035600720cULL, 0x000fda0003f06070ULL, 0x000000023f048824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640004058624ULL, 0x000fc800078e0205ULL,
0x0000000156058824ULL, 0x000fe200078e0205ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040607ff738cULL, 0x0003e20000000000ULL, 0x0000600005048625ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006044a8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x000000802f487824ULL, 0x000fe200078e00ffULL,
0x00000001ff497819ULL, 0x000fe20000011600ULL, 0x0000000007ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000100067812ULL, 0x002fc600078ec0ffULL, 0x0000002049477824ULL, 0x000fca00078e00ffULL,
0x0000006048087812ULL, 0x000fe200078ef847ULL, 0x000058004a097a24ULL, 0x004fc800078e02ffULL,
0x00000080090f7824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000004702047217ULL, 0x008fe20007800000ULL, 0x0000001006057824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fe4000001164bULL, 0x000000700e177812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a47ULL, 0x00000004060a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x00000008060b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000504047217ULL, 0x000fe20007800000ULL, 0x0000000107097824ULL, 0x000fc400078e024bULL,
0x00000008070c7824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe400078e0a05ULL,
0x0000000108077824ULL, 0x000fe200078e0207ULL, 0xfffffff80c097812ULL, 0x000fe400078ee209ULL,
0x000000040a00720cULL, 0x080fe20003f46070ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x000000070f077210ULL, 0x000fe40007f1e0ffULL, 0x000000040600720cULL, 0x080fe20003f66070ULL,
0x000000080a117824ULL, 0x000fe200078e00ffULL, 0x0000000c060c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a067824ULL, 0x000fe200078e024bULL, 0x000000040b00720cULL, 0x080fe20003f26070ULL,
0x00000001050b7824ULL, 0x000fe200078e020bULL, 0x00005e0007127a11ULL, 0x000fe200078838ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x000000040c00720cULL, 0x000fe20003f06070ULL,
0x00000001080a7824ULL, 0x000fc400078e020aULL, 0x0000000108047824ULL, 0x040fe200078e020bULL,
0x00005f0007137a11ULL, 0x000fe200020f3c10ULL, 0x00000001050d7824ULL, 0x000fe200078e020cULL,
0x0000000a0f0a7210ULL, 0x000fe20007f9e0ffULL, 0x000000080b077824ULL, 0x000fe200078e00ffULL,
0xfffffff811057812ULL, 0x000fe200078ee206ULL, 0x000000010b067824ULL, 0x000fe200078e024bULL,
0x000000040f0c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000108087824ULL, 0x000fe400078e020dULL,
0x000000010d047824ULL, 0x000fe200078e024bULL, 0xfffffff807077812ULL, 0x000fe200078ee206ULL,
0x000000080d0b7824ULL, 0x000fe200078e00ffULL, 0x0000b00049067811ULL, 0x000fe200078e68ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0x00005e000a107a11ULL, 0x040fe200078838ffULL,
0x000000ffff157224ULL, 0x000fe200028e06ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee204ULL,
0x0000001007117824ULL, 0x100fe200078e0206ULL, 0x00005f000a0e7a11ULL, 0x000fe200020f3c0dULL,
0x00000010090d7824ULL, 0x000fe200078e0206ULL, 0x0000001217047210ULL, 0x000fc40007f9e0ffULL,
0x000000080f087210ULL, 0x000fe20007fde0ffULL, 0x00000010050f7824ULL, 0x100fe200078e0206ULL,
0x00005e000c097a11ULL, 0x000fe200078a38ffULL, 0x000000ffff057224ULL, 0x000fe400020e0613ULL,
0x000000ffff077224ULL, 0x000fe200030e06ffULL, 0x00005e00080a7a11ULL, 0x000fe200078c38ffULL,
0x000000100b137824ULL, 0x000fe200078e0206ULL, 0x0000001710067210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000d901c46ULL,
0x00005f000c0c7a11ULL, 0x000fc400028f3c15ULL, 0x00005f00080b7a11ULL, 0x000fe200030f3c07ULL,
0x000000ffff077224ULL, 0x000fe200020e060eULL, 0x0000001709087210ULL, 0x080fe40007fbe0ffULL,
0x000000170a0a7210ULL, 0x000fe40007f9e0ffULL, 0x00000000060f7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff097224ULL, 0x000fe400028e060cULL, 0x000000ffff0b7224ULL, 0x000fc600020e060bULL,
0x0000000008117faeULL, 0x0003e8000c901c46ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001006047824ULL, 0x008fe200078e00ffULL,
0x0000b00049137811ULL, 0x000fe400078e68ffULL, 0x000000700e147812ULL, 0x000fe400078ec0ffULL,
0x000000044b047211ULL, 0x000fc800078fe8ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104057824ULL, 0x140fe200078e024bULL, 0x0000000804097810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x040fe200078e00ffULL, 0x0000000c040b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108047824ULL, 0x000fe400078e0204ULL, 0x0000000106077824ULL, 0x000fe200078e024bULL,
0xfffffff80a057812ULL, 0x000fe200078ee205ULL, 0x00000008060c7824ULL, 0x000fe200078e00ffULL,
0x000000040f127210ULL, 0x000fe20007f3e0ffULL, 0x0000000108067824ULL, 0x000fc400078e0206ULL,
0x00000001080a7824ULL, 0x000fe200078e0209ULL, 0xfffffff80c077812ULL, 0x000fe200078ee207ULL,
0x0000000109047824ULL, 0x000fe200078e024bULL, 0x000000060f107210ULL, 0x000fe20007f5e0ffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x0000000a0f0c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000108087824ULL, 0x000fe400078e020bULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e00120a7a11ULL, 0x040fe200078238ffULL, 0x000000010b067824ULL, 0x000fe200078e024bULL,
0xfffffff80d047812ULL, 0x000fe200078ee204ULL, 0x00000010050d7824ULL, 0x100fe200078e0213ULL,
0x000000080f087210ULL, 0x000fe20007f1e0ffULL, 0x00000010070f7824ULL, 0x000fe200078e0213ULL,
0x00005f0012127a11ULL, 0x000fe200008f3c09ULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x00005e0010077a11ULL, 0x000fe200078238ffULL, 0x000000080b0b7824ULL, 0x000fe200078e00ffULL,
0x00005e000c097a11ULL, 0x000fe200078438ffULL, 0x0000001004117824ULL, 0x000fe200078e0213ULL,
0x00005f00100e7a11ULL, 0x000fe200008f3c05ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0xfffffff80b067812ULL, 0x000fe200078ee206ULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x0000000a14047210ULL, 0x000fc40007f3e0ffULL, 0x00005e00080a7a11ULL, 0x000fe200078638ffULL,
0x0000001006137824ULL, 0x000fe200078e0213ULL, 0x00005f000c0c7a11ULL, 0x000fe200010f3c05ULL,
0x000000ffff057224ULL, 0x000fe200008e0612ULL, 0x0000000714067210ULL, 0x000fe40007f1e0ffULL,
0x00005f00080b7a11ULL, 0x000fe400018f3c0bULL, 0x0000000914087210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e060eULL, 0x0000000a140a7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e4000b901c46ULL,
0x000000ffff097224ULL, 0x000fc400008e060cULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x00000000060f7faeULL, 0x0003e8000b901c46ULL, 0x0000000008117faeULL, 0x0003e8000b901c46ULL,
0x000000000a137faeULL, 0x0003e4000b901c46ULL, 0x00000000490473c2ULL, 0x000ea200000e0000ULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x0000f6a849247811ULL, 0x000fe200078e18ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff5a7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200024247f8cULL, 0x000ea2000c80043fULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000ddd000008947ULL, 0x000fea0003800000ULL, 0x000000023f447824ULL, 0x000fe400078e00ffULL,
0x00006400ff237624ULL, 0x000fc400078e00ffULL, 0x000000ffff2a7224ULL, 0x004fe400078e0025ULL,
0x0000640044447624ULL, 0x000fe400078e0223ULL, 0xff317217ff5c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff457224ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e00ffULL, 0x0000010045257824ULL, 0x000fca00078e00ffULL,
0x000000022500720cULL, 0x000fda0003f06070ULL, 0x0000dce000000947ULL, 0x032fea0003800000ULL,
0x000000ffff437224ULL, 0x000fe400078e0056ULL, 0x000000ffff427224ULL, 0x000fc400078e0024ULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x0000000400257824ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fc600078e00ffULL, 0xfffffff8252d7812ULL, 0x000fc800078ec0ffULL,
0x0000f6c82d417810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc002d297984ULL, 0x000ea40000000800ULL,
0x8000000029ff7812ULL, 0x004fe4000780482aULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826317210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09003100780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403100780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000003128287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc002d297984ULL, 0x000ea40000000800ULL, 0x8000000029ff7812ULL, 0x004fe4000780482aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000267824ULL, 0x000fe200078e00ffULL, 0x0000000145277810ULL, 0x000fe20007ffe0ffULL,
0x000058004a4a7a24ULL, 0x000fe200078e02ffULL, 0x0000000124407812ULL, 0x000fe400078e0cffULL,
0x0000002c2700720cULL, 0x000fe20003f06070ULL, 0x000000804a3b7824ULL, 0x000fe200078e00ffULL,
0xffffffe026287812ULL, 0x000fca00078ec0ffULL, 0x0000010045287824ULL, 0x000fca00078e0228ULL,
0x0000004028277810ULL, 0x000fc80007ffe0ffULL, 0x0000006048377812ULL, 0x000fe200078ef827ULL,
0x0000049000008947ULL, 0x000fea0003800000ULL, 0x0000001026297812ULL, 0x000fe200078ec0ffULL,
0x00000002492b7824ULL, 0x000fe200078e0240ULL, 0x00000003ff337819ULL, 0x000fc8000001164bULL,
0x0000000433397810ULL, 0x040fe20007ffe0ffULL, 0x0000000133287824ULL, 0x100fe200078e0229ULL,
0x0000b0002b2b7811ULL, 0x000fe400078e60ffULL, 0x0000000c333a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000137267824ULL, 0x000fe400078e0228ULL, 0x0000000139307824ULL, 0x000fc600078e0229ULL,
0x000000263b317210ULL, 0x000fe40007f1e0ffULL, 0x0000002702267217ULL, 0x000fc60007800000ULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x00005e00312d7a11ULL, 0x000fe200078038ffULL,
0x0000000126267824ULL, 0x000fe400078e0a27ULL, 0x000000104b277824ULL, 0x000fe200078e00ffULL,
0x00005f0031317a11ULL, 0x000fe400000f3c2aULL, 0x0000002926267217ULL, 0x000fe40007800000ULL,
0x0000007027367812ULL, 0x000fe200078ec0ffULL, 0x0000000128277824ULL, 0x000fc400078e024bULL,
0x00000001262a7824ULL, 0x000fe400078e0a29ULL, 0x0000000137267824ULL, 0x000fe400078e0230ULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000002a3300720cULL, 0x000fe40003f06070ULL,
0x000000263b357210ULL, 0x000fe40007fde0ffULL, 0x000000362d267210ULL, 0x000fe40007fbe0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee227ULL, 0x000000ffff327224ULL, 0x000fe200030e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078c38ffULL, 0x000000ffff277224ULL, 0x000fe200028e0631ULL,
0x0000002a3900720cULL, 0x000fe20003fa6070ULL, 0x00000010282d7824ULL, 0x000fe200078e022bULL,
0x0000000833397810ULL, 0x000fe20007ffe0ffULL, 0x0000000130317824ULL, 0x040fe200078e024bULL,
0x00005f0035357a11ULL, 0x000fe200030f3c32ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0005e2000c101c46ULL,
0x0000000139327824ULL, 0x100fe200078e0229ULL, 0x0000003634287210ULL, 0x000fe20007f1e0ffULL,
0x000000013a347824ULL, 0x000fe200078e0229ULL, 0xfffffff830307812ULL, 0x000fe200078ee231ULL,
0x0000000137337824ULL, 0x000fc400078e0232ULL, 0x000000ffff297224ULL, 0x000fe200000e0635ULL,
0x0000002a3900720cULL, 0x000fe20003f06070ULL, 0x0000000832357824ULL, 0x000fe200078e00ffULL,
0x000000333b337210ULL, 0x000fe20007fde0ffULL, 0x00000010302d7824ULL, 0x004fe400078e022bULL,
0x0000000137267824ULL, 0x000fe400078e0234ULL, 0x000000ffff307224ULL, 0x000fe200030e06ffULL,
0x00000000282d7faeULL, 0x0005e2000e901c46ULL, 0x00005e0033277a11ULL, 0x000fc400078a38ffULL,
0x000000263b317210ULL, 0x000fe40007fde0ffULL, 0x00005f0033337a11ULL, 0x000fe400028f3c30ULL,
0x0000002a3a00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff307224ULL, 0x000fe200030e06ffULL,
0x0000003627267210ULL, 0x000fe20007fde0ffULL, 0x00000001322a7824ULL, 0x100fe400078e024bULL,
0x0000000134297824ULL, 0x044fe400078e024bULL, 0x000000ffff277224ULL, 0x000fe200030e0633ULL,
0x00005e0031287a11ULL, 0x000fe200078c38ffULL, 0x0000000834347824ULL, 0x000fe200078e00ffULL,
0xfffffff8352a7812ULL, 0x000fc400078ee22aULL, 0x00005f0031317a11ULL, 0x000fe400030f3c30ULL,
0x0000003628287210ULL, 0x000fe20007fde0ffULL, 0x000000102a2d7824ULL, 0x000fe200078e022bULL,
0xfffffff834307812ULL, 0x000fc600078ee229ULL, 0x000000ffff297224ULL, 0x000fe200030e0631ULL,
0x00000000262d7faeULL, 0x0005e2000c101c46ULL, 0x00000010302b7824ULL, 0x000fca00078e022bULL,
0x00000000282b7faeULL, 0x0005e2000e901c46ULL, 0x000003c000007947ULL, 0x000fea0003800000ULL,
0x0000001026267812ULL, 0x000fc800078ec0ffULL, 0x000000264b267211ULL, 0x000fc800078fe8ffULL,
0x00000004262a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000137277824ULL, 0x000fe400078e0226ULL,
0x0000000126287824ULL, 0x100fe400078e024bULL, 0x000000012a297824ULL, 0x040fe200078e024bULL,
0x000000273b337210ULL, 0x000fe20007f1e0ffULL, 0x000000082a307824ULL, 0x000fe400078e00ffULL,
0x00000008262b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fe200000e06ffULL,
0xfffffff830317812ULL, 0x000fe200078ee229ULL, 0x00000001372a7824ULL, 0x000fe200078e022aULL,
0x0000000c26307810ULL, 0x000fc40007ffe0ffULL, 0xfffffff82b2b7812ULL, 0x000fe400078ee228ULL,
0x0000000826287810ULL, 0x000fe20007ffe0ffULL, 0x0000000137277824ULL, 0x000fe200078e0230ULL,
0x00005e00332d7a11ULL, 0x000fe200078038ffULL, 0x0000000830347824ULL, 0x000fe200078e00ffULL,
0x0000002a3b2a7210ULL, 0x000fe20007fde0ffULL, 0x0000000137267824ULL, 0x000fe200078e0228ULL,
0x00005f0033337a11ULL, 0x000fe200000f3c32ULL, 0x0000000828357824ULL, 0x000fe200078e00ffULL,
0x000000273b367210ULL, 0x040fe20007f1e0ffULL, 0x0000000130277824ULL, 0x100fe200078e024bULL,
0x000000263b397210ULL, 0x000fe20007fbe0ffULL, 0x0000000128267824ULL, 0x000fc400078e024bULL,
0x000000ffff297224ULL, 0x000fe200030e06ffULL, 0x00005e002a287a11ULL, 0x000fe200078c38ffULL,
0x0000000249377824ULL, 0x000fe200078e0240ULL, 0xfffffff834347812ULL, 0x000fe200078ee227ULL,
0x000000104b277824ULL, 0x000fe200078e00ffULL, 0xfffffff835327812ULL, 0x000fe200078ee226ULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x00005f002a297a11ULL, 0x000fe400030f3c29ULL,
0x00005e00392a7a11ULL, 0x000fe400078a38ffULL, 0x0000007027357812ULL, 0x000fe200078ec0ffULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x00005f0039397a11ULL, 0x000fc400028f3c26ULL,
0x00005e0036307a11ULL, 0x000fe400078c38ffULL, 0x000000352d267210ULL, 0x080fe40007f1e0ffULL,
0x0000003528287210ULL, 0x080fe40007fbe0ffULL, 0x00005f0036367a11ULL, 0x000fe200030f3c27ULL,
0x000000ffff277224ULL, 0x000fe200000e0633ULL, 0x0000b00037377811ULL, 0x000fe200078e60ffULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x000000352a2a7210ULL, 0x000fc40007f1e0ffULL,
0x0000003530307210ULL, 0x000fe20007fbe0ffULL, 0x000000102b2d7824ULL, 0x100fe400078e0237ULL,
0x0000001031337824ULL, 0x100fe400078e0237ULL, 0x0000001032357824ULL, 0x000fe200078e0237ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff2b7224ULL, 0x000fe400000e0639ULL, 0x0000001034377824ULL, 0x000fe200078e0237ULL,
0x0000000028337faeULL, 0x0005e2000b901c46ULL, 0x000000ffff317224ULL, 0x000fc600028e0636ULL,
0x000000002a357faeULL, 0x0005e8000b901c46ULL, 0x0000000030377faeULL, 0x0005e4000b901c46ULL,
0x0000000800287824ULL, 0x004fe200078e00ffULL, 0x0000000156267810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff4a7424ULL, 0x000fc600078e00ffULL, 0xfffffff0283f7812ULL, 0x000fe400078ec0ffULL,
0x000000032600720cULL, 0x000fc60003f06070ULL, 0x00000008403f7824ULL, 0x000fca00078e023fULL,
0x0000000000007918ULL, 0x000fea0000000000ULL, 0x0000000144268810ULL, 0x000fe20007ffe056ULL,
0x00000004ff278424ULL, 0x000fe200078e00ffULL, 0xffffffe0283e7812ULL, 0x040fe400078ec0ffULL,
0x0000001028297812ULL, 0x000fe200078ec0ffULL, 0x0000600026268625ULL, 0x000fe200078e0027ULL,
0x0000000828287812ULL, 0x000fe200078ec0ffULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x0000f6a83f537810ULL, 0x000fc40007ffe0ffULL, 0x00000006264a8981ULL, 0x000522000c1e1900ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000003e283e7210ULL, 0x000fd60007ffe029ULL,
0x00000000530403c2ULL, 0x000ee40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8003f547f8cULL, 0x0006a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f608003e2a7f8cULL, 0x0006a4000c80043fULL,
0x0000000000267805ULL, 0x004fc40000015200ULL, 0x00f60c003e297984ULL, 0x000ea40000000800ULL,
0x8000000029ff7812ULL, 0x004fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028262d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000002d28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000130307810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c003e297984ULL, 0x000ea40000000800ULL, 0x8000000029ff7812ULL, 0x004fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000104b267824ULL, 0x000fe200078e00ffULL,
0x00000001ff3c7819ULL, 0x000fe2000001164bULL, 0x00000020003d7824ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe200078e00ffULL, 0x0000007026337812ULL, 0x000fc400078ec0ffULL,
0xffffff803d3d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c3c3c7812ULL, 0x000fc800078ec0ffULL,
0x0000003d3c267210ULL, 0x000fca0007ffe033ULL, 0x00f0000026297984ULL, 0x000ea80000000800ULL,
0x00f20000262b7984ULL, 0x0006620000000800ULL, 0x0000005c2900720bULL, 0x004fe20003f1d000ULL,
0x00013d227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000267806ULL, 0x008fc800000e0100ULL,
0x0000ffff262d7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff577224ULL, 0x000fc400078e005cULL,
0x0000001fff3a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fca00078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe40000011600ULL,
0x0000005c2900720bULL, 0x000fe40003f14000ULL, 0x000000002700720cULL, 0x000fe20003fa5270ULL,
0x00013cb27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000287806ULL, 0x000fc400000e0100ULL,
0x000000800027d824ULL, 0x000fe200078e0233ULL, 0x000000295c577209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x000000013c26d824ULL, 0x000fe200078e0227ULL,
0x0000991028277816ULL, 0x000fc800000000ffULL, 0x00f400572600d388ULL, 0x0005e20000000800ULL,
0x000000ff2700720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000575c267221ULL, 0x004fe20000010000ULL, 0x000000ff28ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL,
0x0000002600337308ULL, 0x0004ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x004fe2000001164bULL, 0x00013bf27f007947ULL, 0x000fea000b800000ULL,
0x00001f2633267589ULL, 0x0084e400000e0000ULL, 0x0000002604047220ULL, 0x088fe20000410000ULL,
0x0000002605057220ULL, 0x080fe20000410000ULL, 0x0000002608087220ULL, 0x080fe20000410000ULL,
0x0000002609097220ULL, 0x080fe20000410000ULL, 0x000000260c0c7220ULL, 0x080fe20000410000ULL,
0x000000260d0d7220ULL, 0x080fe20000410000ULL, 0x0000002610107220ULL, 0x080fe20000410000ULL,
0x0000002611117220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x0000002621217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0028ff7812ULL, 0x000fe2000780c0ffULL, 0x0000003346467220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000084b267811ULL, 0x004fe200078ff0ffULL,
0x00013ad27f007947ULL, 0x000fea000b800000ULL, 0x00001f2633267589ULL, 0x0004e400000e0000ULL,
0x0000002606067220ULL, 0x088fe20000410000ULL, 0x0000002607077220ULL, 0x080fe20000410000ULL,
0x000000260a0a7220ULL, 0x080fe20000410000ULL, 0x000000260b0b7220ULL, 0x080fe20000410000ULL,
0x000000260e0e7220ULL, 0x080fe20000410000ULL, 0x000000260f0f7220ULL, 0x080fe20000410000ULL,
0x0000002612127220ULL, 0x080fe20000410000ULL, 0x0000002613137220ULL, 0x080fe20000410000ULL,
0x0000002616167220ULL, 0x080fe20000410000ULL, 0x0000002617177220ULL, 0x080fe20000410000ULL,
0x000000261a1a7220ULL, 0x080fe20000410000ULL, 0x000000261b1b7220ULL, 0x080fe20000410000ULL,
0x000000261e1e7220ULL, 0x080fe20000410000ULL, 0x000000261f1f7220ULL, 0x080fe20000410000ULL,
0x0000002622227220ULL, 0x080fe20000410000ULL, 0x0000002623237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff2dff7812ULL, 0x000fda0007806028ULL,
0x8000005729290221ULL, 0x000fe20000010000ULL, 0x00007610ff2a0816ULL, 0x000fc6000000002aULL,
0x3fb8aa3b29290820ULL, 0x000fc80000410000ULL, 0x0000002900380308ULL, 0x000ea40000000800ULL,
0x000000382b2b0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000462b467221ULL, 0x002fc20000010000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000000249287824ULL, 0x000fc800078e0224ULL, 0x00000008282d7824ULL, 0x000fca00078e00ffULL,
0x00f6ac002d287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028262b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000002b28287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac002d287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099102a267816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff2600720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000038ff26723eULL, 0x000fe400000010ffULL, 0x00000002ff287819ULL, 0x000fe4000001164bULL,
0x0000541026297816ULL, 0x000fe20000000026ULL, 0x000136b27f007947ULL, 0x000fea000b800000ULL,
0x00001f28292f7589ULL, 0x0002a400000e0000ULL, 0x00000008282e7810ULL, 0x000fe20007ffe0ffULL,
0x000136e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2e292e7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001028267810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200078e0029ULL, 0x00002b5000317802ULL, 0x000fc40000000f00ULL,
0x0001416000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001828267810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x004fe200078e0029ULL,
0x00002ba000317802ULL, 0x000fc40000000f00ULL, 0x0001411000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000074b827812ULL, 0x000fe200078ec0ffULL,
0x0000000200607824ULL, 0x040fe200078e00ffULL, 0x00000004ff837819ULL, 0x100fe2000001164bULL,
0x00000200004c7824ULL, 0x000fe200078e00ffULL, 0x0000000882827812ULL, 0x000fe200078ef84bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000460267812ULL, 0x000fc400078ec0ffULL,
0xfffff8004c4c7812ULL, 0x000fe200078ec0ffULL, 0x00000008822d7824ULL, 0x040fe200078e00ffULL,
0x0000002682267210ULL, 0x000fc80007ffe083ULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee226ULL,
0x000000084b267812ULL, 0x000fc600078ec0ffULL, 0x000000102d2d7824ULL, 0x000fc400078e024cULL,
0x0000000425527812ULL, 0x000fe200078ec0ffULL, 0x0000000249327824ULL, 0x000fe200078e0224ULL,
0x0000000726517812ULL, 0x000fc600078ef84bULL, 0x0000000183527824ULL, 0x000fe200078e0252ULL,
0x0000b00032327811ULL, 0x000fe200078e60ffULL, 0x0000000851257824ULL, 0x040fe200078e00ffULL,
0x0000001051317812ULL, 0x040fe200078efcffULL, 0x0000000151287824ULL, 0x042fe400078e0252ULL,
0x00000008512a7824ULL, 0x000fe400078e00ffULL, 0x0000000152307824ULL, 0x004fe200078e0231ULL,
0xfffffff825247812ULL, 0x000fe200078ee228ULL, 0x0000000831257824ULL, 0x040fe200078e00ffULL,
0x00000002284f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000831507824ULL, 0x000fe200078e00ffULL,
0x00000002304d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001024347824ULL, 0x000fe200078e0232ULL,
0xfffffff8254e7812ULL, 0x000fe200078ee230ULL, 0x0000000449837824ULL, 0x000fe200078e0283ULL,
0xfffffff82a4f7812ULL, 0x000fc400078ee24fULL, 0xfffffff8504d7812ULL, 0x000fe200078ee24dULL,
0x000000003434783bULL, 0x000e620000004200ULL, 0x000000104e247824ULL, 0x000fe200078e0232ULL,
0x0000000283837810ULL, 0x000fe20007ffe082ULL, 0x000000104f287824ULL, 0x100fe400078e0232ULL,
0x0000000882827824ULL, 0x000fe400078e00ffULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x000000104d307824ULL, 0x000fe400078e0232ULL, 0xfffffff882837812ULL, 0x000fe200078ee283ULL,
0x000000002828783bULL, 0x008ee80000004200ULL, 0x000000003030783bULL, 0x000ee20000004200ULL,
0x00000010834c7824ULL, 0x000fc400078e024cULL, 0x0000010034887824ULL, 0x042fe200078e00ffULL,
0x0000003400867306ULL, 0x000fe20000009400ULL, 0x00000018ff8e7819ULL, 0x000fe20000011434ULL,
0x00010000348a7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x000fe20000011435ULL,
0x00000100358b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x0000003400877306ULL, 0x000e620000005400ULL,
0x00000018ff957819ULL, 0x000fe2000001148bULL, 0x00000100248b7824ULL, 0x004fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fc40000011436ULL, 0x00000018ffab7819ULL, 0x000fe40000011437ULL,
0x00000018ff787819ULL, 0x000fe20000011425ULL, 0x0000003400777306ULL, 0x000ea2000000d400ULL,
0x00000018ff6e7819ULL, 0x000fe40000011426ULL, 0x00000018ffb07819ULL, 0x008fe40000011428ULL,
0x00000018ffae7819ULL, 0x000fe40000011429ULL, 0x00000018ffa87819ULL, 0x000fe2000001142aULL,
0x0000008800897306ULL, 0x000fe20000209400ULL, 0x000000878600720bULL, 0x002fe20003fbd000ULL,
0x0000010026867824ULL, 0x000fe200078e00ffULL, 0x00000018ffa17819ULL, 0x000fc4000001142bULL,
0x00000018ff8b7819ULL, 0x000fe4000001148bULL, 0x00000018ff7f7819ULL, 0x000fe20000011424ULL,
0x0000008800347306ULL, 0x000e620000205400ULL, 0x00000018ff6a7819ULL, 0x000fe40000011427ULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x00000018ff827819ULL, 0x000fe40000011431ULL,
0x0000000177775812ULL, 0x004fe200078efcffULL, 0x0000008e00907306ULL, 0x000ff00000209400ULL,
0x0000008e00917306ULL, 0x000ea20000205400ULL, 0x000000348900720bULL, 0x002fe20003fdd000ULL,
0x0001000024347824ULL, 0x000fc400078e00ffULL, 0x0000010027897824ULL, 0x000fc600078e00ffULL,
0x00000018ff877819ULL, 0x000fe20000011434ULL, 0x0000008a008c7306ULL, 0x000fe20000209400ULL,
0x0000008800347245ULL, 0x000fe2000020d400ULL, 0x0001000026887824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fc60000011489ULL, 0x0000000134346812ULL, 0x000fe400078efcffULL,
0x0000008a008f7306ULL, 0x000e620000205400ULL, 0x000000919000720bULL, 0x004fe20003fbd000ULL,
0x0001000025907824ULL, 0x000fe200078e00ffULL, 0x0000009500917245ULL, 0x000fe4000020d400ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x0000003500927306ULL, 0x000fe20000009400ULL, 0x000000773434723eULL, 0x000fc400000010ffULL,
0x0000007800777245ULL, 0x000fca000020d400ULL, 0x0000003500937306ULL, 0x000fe20000005400ULL,
0x0000008f8c00720bULL, 0x002fe40003fdd000ULL, 0x000000a0008f7245ULL, 0x000fca000020d400ULL,
0x0000003500767306ULL, 0x0003f0000000d400ULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x0001000035357824ULL, 0x002fca00078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011435ULL,
0x0000010036357824ULL, 0x000fe200078e00ffULL, 0x0000009500997306ULL, 0x000e680000205400ULL,
0x00000018ffb97819ULL, 0x000fe20000011435ULL, 0x0000010037357824ULL, 0x000fc600078e00ffULL,
0x0000003600b77306ULL, 0x000fe40000009400ULL, 0x00000018ffc37819ULL, 0x000fe20000011435ULL,
0x0000010025357824ULL, 0x000fca00078e00ffULL, 0x0000003600ba7306ULL, 0x000fe20000005400ULL,
0x00000018ff357819ULL, 0x000fce0000011435ULL, 0x0000003600757306ULL, 0x0005f0000000d400ULL,
0x0000003700ac7306ULL, 0x000fe20000009400ULL, 0x0001000036367824ULL, 0x004fca00078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe40000011436ULL, 0x0000003700b57306ULL, 0x000fe20000005400ULL,
0x0000008a00367245ULL, 0x000fe4000020d400ULL, 0x00000098008a7245ULL, 0x000fe4000020d400ULL,
0x0000000136366812ULL, 0x000fe400078efcffULL, 0x000000999600720bULL, 0x002fe20003fdd000ULL,
0x0000003700737306ULL, 0x0003f0000000d400ULL, 0x000000a000a77306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x002fc600078e00ffULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x00000018ffc67819ULL, 0x000fe40000011437ULL, 0x0000008e00377245ULL, 0x000fe2000020d400ULL,
0x000000a000b87306ULL, 0x000e620000205400ULL, 0x000000bd008e7245ULL, 0x000fe4000020d400ULL,
0x0000000137375812ULL, 0x000fe400078efcffULL, 0x000000939200720bULL, 0x000fc40003fbd000ULL,
0x000000c000937245ULL, 0x000fe2000020d400ULL, 0x00000098009b7306ULL, 0x000fe20000209400ULL,
0x000000363736723eULL, 0x000fce00000010ffULL, 0x00000098009e7306ULL, 0x0004e40000205400ULL,
0x0000000176765812ULL, 0x000fe400078efcffULL, 0x000000b8a700720bULL, 0x002fc80003fbd000ULL,
0x000000b900bb7306ULL, 0x000fe20000209400ULL, 0x000000b900987245ULL, 0x004fce000020d400ULL,
0x000000b900bc7306ULL, 0x000e620000205400ULL, 0x0000009e9b00720bULL, 0x008fe40003fdd000ULL,
0x000000018f8f5812ULL, 0x000fe400078efcffULL, 0x000000bab700720bULL, 0x000fe20003fbd000ULL,
0x0000010029b77824ULL, 0x000fe400078e00ffULL, 0x000000c000c17306ULL, 0x000fe60000209400ULL,
0x00000018ffb77819ULL, 0x000fc600000114b7ULL, 0x000000018a8a6812ULL, 0x000fe400078efcffULL,
0x000000c000c27306ULL, 0x000ea20000205400ULL, 0x000000bcbb00720bULL, 0x002fe40003fdd000ULL,
0x0000000175755812ULL, 0x000fe400078efcffULL, 0x0000008a8f37723eULL, 0x000fc600000010ffULL,
0x000000bd00be7306ULL, 0x000fec0000209400ULL, 0x0000000198986812ULL, 0x000fe400078efcffULL,
0x000000bd00bf7306ULL, 0x000e620000205400ULL, 0x000000c2c100720bULL, 0x004fce0003fbd000ULL,
0x000000c300c47306ULL, 0x000fec0000209400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x000000c300c57306ULL, 0x000ea20000205400ULL, 0x000000bfbe00720bULL, 0x002fe40003fdd000ULL,
0x000000b5ac00720bULL, 0x000fc40003fbd000ULL, 0x000000c300ac7245ULL, 0x000fc6000020d400ULL,
0x000000ab00b37306ULL, 0x000fec0000209400ULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x000000ab00a67306ULL, 0x0002e20000205400ULL, 0x000000c5c400720bULL, 0x004fe40003fdd000ULL,
0x0000000173735812ULL, 0x000fc400078efcffULL, 0x0000008e938e723eULL, 0x000fc600000010ffULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000c600c87306ULL, 0x000e620000205400ULL,
0x000000a6b300720bULL, 0x008fe40003fbd000ULL, 0x000000c600a67245ULL, 0x000fca000020d400ULL,
0x00000025007d7306ULL, 0x000fec0000009400ULL, 0x00000001abab5812ULL, 0x000fe400078efcffULL,
0x00000025007e7306ULL, 0x000fe20000005400ULL, 0x000000c8c700720bULL, 0x002fce0003fdd000ULL,
0x0000002500627306ULL, 0x0003ec000000d400ULL, 0x00000001a6a66812ULL, 0x000fe400078efcffULL,
0x00000026007a7306ULL, 0x000fe20000009400ULL, 0x0000010028257824ULL, 0x002fe200078e00ffULL,
0x000000a6ab8f723eULL, 0x000fc800000010ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002600797306ULL, 0x000ff00000005400ULL, 0x00000026005b7306ULL, 0x000ff0000000d400ULL,
0x0000002800ad7306ULL, 0x000ff00000009400ULL, 0x0000002800b47306ULL, 0x000e700000005400ULL,
0x0000002500267306ULL, 0x000ff00000209400ULL, 0x0000002500b57306ULL, 0x000ea20000205400ULL,
0x000000b4ad00720bULL, 0x002fe20003fbd000ULL, 0x0001000029b47824ULL, 0x000fe200078e00ffULL,
0x0000002500ad7245ULL, 0x000fc8000020d400ULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x00000028006c7306ULL, 0x0002f0000000d400ULL, 0x0000002900a27306ULL, 0x000fe20000009400ULL,
0x000000b52600720bULL, 0x004fe20003fdd000ULL, 0x0001000028287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000002900a37306ULL, 0x000e620000005400ULL,
0x000000016c6c5812ULL, 0x008fca00078efcffULL, 0x00000001adad6812ULL, 0x000fe400078efcffULL,
0x000000b700b87306ULL, 0x000fe40000209400ULL, 0x0000006cad6c723eULL, 0x000fcc00000010ffULL,
0x000000b700b37306ULL, 0x000ea20000205400ULL, 0x000000a3a200720bULL, 0x002fe20003fbd000ULL,
0x000001002aa37824ULL, 0x000fe200078e00ffULL, 0x000000b700a27245ULL, 0x000fca000020d400ULL,
0x00000029006b7306ULL, 0x000e70000000d400ULL, 0x000000b000b67306ULL, 0x000fe20000209400ULL,
0x000000b3b800720bULL, 0x004fe40003fdd000ULL, 0x00000018ffb37819ULL, 0x000fc400000114a3ULL,
0x0000002800a37245ULL, 0x000fc6000020d400ULL, 0x000000b000b17306ULL, 0x0004e20000205400ULL,
0x000000016b6b5812ULL, 0x002fca00078efcffULL, 0x00000001a2a26812ULL, 0x000fe400078efcffULL,
0x0000002800267306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x004fce000020d400ULL,
0x0000002800297306ULL, 0x000e620000205400ULL, 0x000000b1b600720bULL, 0x008fe20003fbd000ULL,
0x000001002bb17824ULL, 0x000fca00078e00ffULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x000000ae00b27306ULL, 0x000fec0000209400ULL, 0x00000001b0b05812ULL, 0x000fe400078efcffULL,
0x000000ae00af7306ULL, 0x0004e20000205400ULL, 0x000000292600720bULL, 0x002fce0003fdd000ULL,
0x000000b400257306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x004fca000020d400ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x000000b400b87306ULL, 0x000e620000205400ULL,
0x000000afb200720bULL, 0x008fe40003fbd000ULL, 0x000000b400af7245ULL, 0x000fe4000020d400ULL,
0x0000008b00b27245ULL, 0x000fe4000020d400ULL, 0x000000a3b0b0723eULL, 0x000fe200000010ffULL,
0x0000002a009d7306ULL, 0x000fec0000009400ULL, 0x00000001aeae5812ULL, 0x000fc400078efcffULL,
0x0000002a009c7306ULL, 0x000ea20000005400ULL, 0x000000b82500720bULL, 0x002fce0003fdd000ULL,
0x000000b300267306ULL, 0x000fec0000209400ULL, 0x00000001afaf6812ULL, 0x000fe400078efcffULL,
0x000000b300297306ULL, 0x000e620000205400ULL, 0x0000009c9d00720bULL, 0x004fe40003fbd000ULL,
0x000000b3009c7245ULL, 0x000fc4000020d400ULL, 0x000000b1009d7245ULL, 0x000fc6000020d400ULL,
0x0000002a00657306ULL, 0x0004f0000000d400ULL, 0x0000002b009a7306ULL, 0x000fe20000009400ULL,
0x000000292600720bULL, 0x002fe20003fdd000ULL, 0x000100002a2a7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000002b00977306ULL, 0x000e620000005400ULL,
0x0000000165655812ULL, 0x008fca00078efcffULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x000000b100287306ULL, 0x000fe40000209400ULL, 0x000000659c9c723eULL, 0x000fcc00000010ffULL,
0x000000b100b57306ULL, 0x0004e20000205400ULL, 0x000000979a00720bULL, 0x002fe40003fbd000ULL,
0x0000002a009a7245ULL, 0x000fe4000020d400ULL, 0x00000018ff977819ULL, 0x000fc60000011430ULL,
0x0000002b00667306ULL, 0x000262000000d400ULL, 0x0001000027b17824ULL, 0x004fca00078e00ffULL,
0x00000018ffb17819ULL, 0x000fe400000114b1ULL, 0x000000a800aa7306ULL, 0x000fe20000209400ULL,
0x000000b52800720bULL, 0x008fe20003fdd000ULL, 0x000100002b2b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000000a800a97306ULL, 0x000e620000205400ULL,
0x0000000166665812ULL, 0x000fca00078efcffULL, 0x000000019d9d6812ULL, 0x000fe400078efcffULL,
0x0000002a00257306ULL, 0x000fe40000209400ULL, 0x000000669d9d723eULL, 0x000fcc00000010ffULL,
0x0000002a00267306ULL, 0x000ea20000205400ULL, 0x000000a9aa00720bULL, 0x002fe40003fbd000ULL,
0x000000a800a97245ULL, 0x000fe4000020d400ULL, 0x000000a100a87245ULL, 0x000fe4000020d400ULL,
0x0000007f00aa7245ULL, 0x000fe2000020d400ULL, 0x000000a100a57306ULL, 0x000fec0000209400ULL,
0x00000001a9a95812ULL, 0x000fc400078efcffULL, 0x000000a100a47306ULL, 0x000e620000205400ULL,
0x000000262500720bULL, 0x004fce0003fdd000ULL, 0x0000002b00287306ULL, 0x000fec0000209400ULL,
0x000000019a9a6812ULL, 0x000fe400078efcffULL, 0x0000002b00297306ULL, 0x000ea20000205400ULL,
0x000000a4a500720bULL, 0x002fe40003fbd000ULL, 0x0000002b00a57245ULL, 0x000fc4000020d400ULL,
0x0000009aa99a723eULL, 0x000fc600000010ffULL, 0x0000002400857306ULL, 0x000fec0000009400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000002400847306ULL, 0x000e620000005400ULL,
0x000000292800720bULL, 0x004fe40003fdd000ULL, 0x009000002d28783bULL, 0x000eaa0000000200ULL,
0x0000002400637306ULL, 0x000eec000000d400ULL, 0x00000001a5a56812ULL, 0x000fc400078efcffULL,
0x0000008b009f7306ULL, 0x000fe20000209400ULL, 0x000000848500720bULL, 0x002fe40003fbd000ULL,
0x0000003500857245ULL, 0x000fca000020d400ULL, 0x0000008b00247306ULL, 0x000e6c0000205400ULL,
0x0000000163635812ULL, 0x008fe400078efcffULL, 0x0000007f00807306ULL, 0x000ff00000209400ULL,
0x0000007f00817306ULL, 0x000ee20000205400ULL, 0x000000249f00720bULL, 0x002fe20003fdd000ULL,
0x0000002f28288231ULL, 0x004fc400003400ffULL, 0x0000002f2a2a8231ULL, 0x000fe400003400ffULL,
0x0000002e29298231ULL, 0x080fe400003400ffULL, 0x00000087008d7306ULL, 0x000fe20000209400ULL,
0x0000002e2b2b8231ULL, 0x000fca00003400ffULL, 0x00000001b2b26812ULL, 0x000fe400078efcffULL,
0x0000008700947306ULL, 0x0002a20000205400ULL, 0x000000818000720bULL, 0x008fe20003fbd000ULL,
0x000000362808723cULL, 0x000fe20000041808ULL, 0x00000018ff807819ULL, 0x000fe40000011432ULL,
0x00000063b2b2723eULL, 0x000fc600000010ffULL, 0x00000035008c7306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fe2000020d400ULL, 0x0000008e2810723cULL, 0x040fe80000041810ULL,
0x00000001aaaa5812ULL, 0x000fe400078efcffULL, 0x0000003500997306ULL, 0x0002e20000205400ULL,
0x000000948d00720bULL, 0x004fe20003fdd000ULL, 0x0000009c281c723cULL, 0x000fe2000004181cULL,
0x0000007e7d00720bULL, 0x000fc40003fbd000ULL, 0x00000018ff7d7819ULL, 0x000fc60000011433ULL,
0x0000002700727306ULL, 0x000fe20000009400ULL, 0x0000010030357824ULL, 0x002fca00078e00ffULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x00000027006f7306ULL, 0x000fe20000005400ULL,
0x000000998c00720bULL, 0x008fe40003fdd000ULL, 0x0000000162625812ULL, 0x000fca00078efcffULL,
0x00000027005a7306ULL, 0x0003ec000000d400ULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x00000078007b7306ULL, 0x000fe20000209400ULL, 0x009000004c24783bULL, 0x002e6e0000000200ULL,
0x00000078007c7306ULL, 0x000eb00000205400ULL, 0x0000009000927306ULL, 0x000ff00000209400ULL,
0x00000090009b7306ULL, 0x0006620000205400ULL, 0x0000007c7b00720bULL, 0x004fc40003fdd000ULL,
0x00000018ff7b7819ULL, 0x000fe20000011435ULL, 0x0000010031357824ULL, 0x000fc800078e00ffULL,
0x0000008600957306ULL, 0x000fe20000209400ULL, 0x0000009000907245ULL, 0x008fca000020d400ULL,
0x0000000177776812ULL, 0x000fe400078efcffULL, 0x00000086009e7306ULL, 0x000ea20000205400ULL,
0x0000009b9200720bULL, 0x002fe20003fbd000ULL, 0x0000002f24248231ULL, 0x080fe200003400ffULL,
0x000000a5a89b723eULL, 0x000fe200000010ffULL, 0x0000002f26268231ULL, 0x000fe400003400ffULL,
0x0000002e25258231ULL, 0x080fe400003400ffULL, 0x0000008900a07306ULL, 0x000fe20000209400ULL,
0x0000002e27278231ULL, 0x000fe200003400ffULL, 0x000000797a00720bULL, 0x000fe20003f1d000ULL,
0x0000009a2820723cULL, 0x000fe20000041820ULL, 0x00000018ff797819ULL, 0x000fc40000011435ULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x0000008900a77306ULL, 0x0002e20000205400ULL,
0x0000009e9500720bULL, 0x004fe40003fbd000ULL, 0x000000769135723eULL, 0x000fe400000010ffULL,
0x0000008600867245ULL, 0x000fe4000020d400ULL, 0x000000015b5b0812ULL, 0x000fe200078efcffULL,
0x0000006e00747306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fe2000020d400ULL,
0x000000342804723cULL, 0x000b620000041804ULL, 0x000000907777723eULL, 0x000fc600000010ffULL,
0x0000000186865812ULL, 0x000fe400078efcffULL, 0x0000006e00717306ULL, 0x000e620000205400ULL,
0x000000a7a000720bULL, 0x008fe40003fdd000ULL, 0x000000759834723eULL, 0x020fe400000010ffULL,
0x00000073ac35723eULL, 0x000fe400000010ffULL, 0x0000006f7200720bULL, 0x000fe20003fbd000ULL,
0x0000008800967306ULL, 0x000fe20000209400ULL, 0x0000010033727824ULL, 0x000fe200078e00ffULL,
0x0000005b8686723eULL, 0x000fc400000010ffULL, 0x00000034280c723cULL, 0x000b64000004180cULL,
0x0000000189896812ULL, 0x000fe400078efcffULL, 0x0000008800b37306ULL, 0x0004e20000205400ULL,
0x000000717400720bULL, 0x002fe20003f1d000ULL, 0x0001000032717824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0001000033747824ULL, 0x000fe200078e00ffULL,
0x000000015a5a5812ULL, 0x000fe400078efcffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000006a006d7306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x004fc4000020d400ULL,
0x00000018ff747819ULL, 0x000fca0000011474ULL, 0x0000006a00707306ULL, 0x000e620000205400ULL,
0x000000b39600720bULL, 0x008fe40003fdd000ULL, 0x0000006285b3723eULL, 0x000fca00000010ffULL,
0x000000b100b47306ULL, 0x000fe40000209400ULL, 0x000000b22404723cULL, 0x000fe80000041804ULL,
0x0000000188886812ULL, 0x000fe400078efcffULL, 0x000000b100b57306ULL, 0x000ea20000205400ULL,
0x000000706d00720bULL, 0x002fe40003fdd000ULL, 0x0000006ba26d723eULL, 0x000fca00000010ffULL,
0x0000007b007c7306ULL, 0x000fe40000209400ULL, 0x0000006c2814723cULL, 0x000f6c0000041814ULL,
0x0000007b008b7306ULL, 0x000e620000205400ULL, 0x000000b5b400720bULL, 0x004fce0003fbd000ULL,
0x0000003100677306ULL, 0x000ff00000009400ULL, 0x0000003100647306ULL, 0x000ff00000005400ULL,
0x0000003100587306ULL, 0x0005f0000000d400ULL, 0x0000003000697306ULL, 0x000fe20000009400ULL,
0x0001000031317824ULL, 0x004fca00078e00ffULL, 0x00000018ff347819ULL, 0x020fe40000011431ULL,
0x0000006e00317245ULL, 0x000fe2000020d400ULL, 0x0000003000687306ULL, 0x000ea60000005400ULL,
0x0000000131310812ULL, 0x000fe400078efcffULL, 0x0000008b7c00720bULL, 0x002fe40003f1d000ULL,
0x000000883188723eULL, 0x000fe200000010ffULL, 0x0000003000597306ULL, 0x0002f0000000d400ULL,
0x0000007900767306ULL, 0x000fe20000209400ULL, 0x0001000030307824ULL, 0x002fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011430ULL, 0x0000010032307824ULL, 0x000fe200078e00ffULL,
0x00000079008d7306ULL, 0x0002e80000205400ULL, 0x00000018ff6f7819ULL, 0x000fe40000011430ULL,
0x000000b100307245ULL, 0x000fe4000020d400ULL, 0x00000032005f7306ULL, 0x000fe20000009400ULL,
0x0000007900797245ULL, 0x002fc4000020d400ULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x000000686900720bULL, 0x004fe40003fbd000ULL, 0x000000afaeb1723eULL, 0x000fe200000010ffULL,
0x00000032005c7306ULL, 0x000fec0000005400ULL, 0x000000b02818723cULL, 0x000b640000041818ULL,
0x0000003200507306ULL, 0x0003e4000000d400ULL, 0x0000000159595812ULL, 0x008fc600078efcffULL,
0x0000009700287245ULL, 0x020fe4000020d400ULL, 0x0000003400297245ULL, 0x000fe2000020d400ULL,
0x00000033005d7306ULL, 0x000fe20000009400ULL, 0x0000007b00327245ULL, 0x002fc8000020d400ULL,
0x0000000132320812ULL, 0x000fe400078efcffULL, 0x000000646700720bULL, 0x000fe20003f1d000ULL,
0x00000033005e7306ULL, 0x000fe20000005400ULL, 0x000000593232723eULL, 0x000fce00000010ffULL,
0x0000003300617306ULL, 0x0003e8000000d400ULL, 0x0000000158580812ULL, 0x000fc800078efcffULL,
0x0000009700a47306ULL, 0x000fe20000209400ULL, 0x0000006a00337245ULL, 0x002fc8000020d400ULL,
0x0000000133336812ULL, 0x000fe400078efcffULL, 0x0000008d7600720bULL, 0x000fe20003fdd000ULL,
0x00000097009f7306ULL, 0x000e620000205400ULL, 0x00000087aa76723eULL, 0x000fe400000010ffULL,
0x0000005a8987723eULL, 0x000fe400000010ffULL, 0x000000303389723eULL, 0x000fc600000010ffULL,
0x0000007300367306ULL, 0x000fe20000209400ULL, 0x000000762408723cULL, 0x000f660000041808ULL,
0x0000000179796812ULL, 0x000fc800078efcffULL, 0x0000007300357306ULL, 0x0004e20000205400ULL,
0x0000009fa400720bULL, 0x002fe20003fbd000ULL, 0x00000086240c723cULL, 0x000f62000004180cULL,
0x000000587933723eULL, 0x000fca00000010ffULL, 0x0000003400377306ULL, 0x000fe20000209400ULL,
0x0000007300737245ULL, 0x004fe2000020d400ULL, 0x000000882410723cULL, 0x040f680000041810ULL,
0x0000000128285812ULL, 0x000fe400078efcffULL, 0x00000034006e7306ULL, 0x000e620000205400ULL,
0x000000353600720bULL, 0x008fe20003fdd000ULL, 0x000000322414723cULL, 0x000f6c0000041814ULL,
0x0000008200837306ULL, 0x000fec0000209400ULL, 0x0000000173736812ULL, 0x000fc400078efcffULL,
0x0000008200947306ULL, 0x0004e20000205400ULL, 0x0000006e3700720bULL, 0x002fe40003f1d000ULL,
0x000000732828723eULL, 0x000fca00000010ffULL, 0x0000006f006a7306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x004fca000020d400ULL, 0x0000000129290812ULL, 0x000fe400078efcffULL,
0x0000006f00697306ULL, 0x0002a20000205400ULL, 0x000000948300720bULL, 0x008fe40003fdd000ULL,
0x0000005c5f00720bULL, 0x000fca0003f1d000ULL, 0x0000007200647306ULL, 0x000fe20000209400ULL,
0x0000006f006f7245ULL, 0x002fca000020d400ULL, 0x0000000182826812ULL, 0x000fe400078efcffULL,
0x0000007200357306ULL, 0x0002e20000205400ULL, 0x000000696a00720bULL, 0x004fe40003fbd000ULL,
0x0000000150500812ULL, 0x000fe400078efcffULL, 0x000000298229723eULL, 0x000fc600000010ffULL,
0x00000071002a7306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x002fc6000020d400ULL,
0x000000282418723cULL, 0x000b640000041818ULL, 0x000000016f6f5812ULL, 0x000fe400078efcffULL,
0x00000071002b7306ULL, 0x0002a20000205400ULL, 0x000000356400720bULL, 0x008fe40003fdd000ULL,
0x0000005e5d00720bULL, 0x000fe40003fbd000ULL, 0x0000007d00287245ULL, 0x020fc6000020d400ULL,
0x0000008000817306ULL, 0x000fe20000209400ULL, 0x0000007100717245ULL, 0x002fca000020d400ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x0000008000847306ULL, 0x0002e20000205400ULL,
0x0000002b2a00720bULL, 0x004fe40003f1d000ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x000000506f2a723eULL, 0x000fe400000010ffULL, 0x00000061722b723eULL, 0x000fe200000010ffULL,
0x0000007d007e7306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x0000000171710812ULL, 0x000fe200078efcffULL, 0x0000002a241c723cULL, 0x000f62000004181cULL,
0x0000007d007f7306ULL, 0x000e620000205400ULL, 0x000000848100720bULL, 0x008fe40003fdd000ULL,
0x0000007400817245ULL, 0x000fca000020d400ULL, 0x0000007400347306ULL, 0x000fec0000209400ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x0000007400317306ULL, 0x000ea20000205400ULL,
0x0000007f7e00720bULL, 0x002fe40003fbd000ULL, 0x000000718080723eULL, 0x000fd600000010ffULL,
0x0000000128285812ULL, 0x000fe400078efcffULL, 0x000000313400720bULL, 0x004fda0003f1d000ULL,
0x0000000181810812ULL, 0x000fc800078efcffULL, 0x000000812881723eULL, 0x000fce00000010ffULL,
0x000000802420723cULL, 0x000b6e0000041820ULL, 0x0000000849247824ULL, 0x020fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd00000008000ULL, 0x00f6c80024247f8cULL, 0x000e62000c80043fULL,
0xfffffff860507812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004045277811ULL, 0x000fe200078e40ffULL, 0x00f6880050ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff2a7224ULL, 0x002fe200078e0025ULL, 0x0000000156567810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5c7224ULL, 0x000fe200078e0057ULL, 0x000000022700720cULL, 0x000fe20003f06070ULL,
0x000000ffff5b7224ULL, 0x000fc400078e0055ULL, 0x000000ffff247224ULL, 0x000fd400078e0040ULL,
0x0000a2b000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x004fc40000015200ULL,
0x0000040041277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040041277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000247824ULL, 0x000fe200078e00ffULL, 0x0000000145257810ULL, 0x000fe20007ffe0ffULL,
0x000058004a5d7a24ULL, 0x010fc600078e02ffULL, 0x0000002c2500720cULL, 0x000fe20003f06070ULL,
0x000000805d5d7824ULL, 0x000fe200078e00ffULL, 0xffffffe024267812ULL, 0x000fca00078ec0ffULL,
0x0000010045267824ULL, 0x000fca00078e0226ULL, 0x0000008026257810ULL, 0x000fc80007ffe0ffULL,
0x0000006048327812ULL, 0x000fe200078ef825ULL, 0x000004b000008947ULL, 0x000fea0003800000ULL,
0x0000001024337812ULL, 0x000fe400078ec0ffULL, 0x0000002502247217ULL, 0x000fe40007800000ULL,
0x00000003ff317819ULL, 0x000fc6000001164bULL, 0x0000000124247824ULL, 0x000fe200078e0a25ULL,
0x0000000431287810ULL, 0x040fe20007ffe0ffULL, 0x0000000131277824ULL, 0x140fe200078e0233ULL,
0x0000000831587810ULL, 0x000fe40007ffe0ffULL, 0x0000002433247217ULL, 0x000fe20007800000ULL,
0x0000000127267824ULL, 0x040fe400078e0232ULL, 0x0000000128357824ULL, 0x000fe400078e0233ULL,
0x0000000127257824ULL, 0x000fe200078e024bULL, 0x000000265d267210ULL, 0x000fe20007f1e0ffULL,
0x0000000827347824ULL, 0x000fc400078e00ffULL, 0x00000001242a7824ULL, 0x000fe400078e0a33ULL,
0x0000000135247824ULL, 0x100fe200078e0232ULL, 0xfffffff834347812ULL, 0x000fe200078ee225ULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x00005e0026297a11ULL, 0x000fe200078038ffULL,
0x000000104b257824ULL, 0x000fe200078e00ffULL, 0x000000245d277210ULL, 0x000fe20007fde0ffULL,
0x0000000158597824ULL, 0x000fe200078e0233ULL, 0x0000002a2800720cULL, 0x000fe20003fa6070ULL,
0x0000000135377824ULL, 0x000fe200078e024bULL, 0x00005f00262b7a11ULL, 0x000fe200000f3c2bULL,
0x000000ffff287224ULL, 0x000fe200030e06ffULL, 0x0000007025367812ULL, 0x000fe200078ec0ffULL,
0x0000100042257824ULL, 0x000fe200078e00ffULL, 0x00005e0027267a11ULL, 0x000fe200078c38ffULL,
0x0000000159307824ULL, 0x000fe200078e0232ULL, 0x0000003629247210ULL, 0x000fe20007f1e0ffULL,
0x0000000835567824ULL, 0x000fe200078e00ffULL, 0x00005f0027277a11ULL, 0x000fc400030f3c28ULL,
0x0000100025287812ULL, 0x000fe200078ec0ffULL, 0x000000ffff257224ULL, 0x000fe200000e062bULL,
0x0000003626267210ULL, 0x000fe40007fde0ffULL, 0x0000002a3100720cULL, 0x000fe20003f06070ULL,
0x0000200049287824ULL, 0x000fe200078e0228ULL, 0x0000000c31357810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000305d307210ULL, 0x000fe40007fde0ffULL,
0x0000b000282b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff856567812ULL, 0x000fe200078ee237ULL,
0x000000ffff297224ULL, 0x000fe200030e06ffULL, 0x00005e0030287a11ULL, 0x000fe200078c38ffULL,
0x0000001034317824ULL, 0x000fe400078e022bULL, 0x0000000135347824ULL, 0x000fe200078e0233ULL,
0x00005f0030297a11ULL, 0x000fe200030f3c29ULL, 0x0000001056337824ULL, 0x000fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000c101c46ULL,
0x0000000134307824ULL, 0x000fe200078e0232ULL, 0x0000003628287210ULL, 0x000fc40007f1e0ffULL,
0x0000000026337faeULL, 0x0005e2000e901c46ULL, 0x0000002a5800720cULL, 0x000fe40003fa6070ULL,
0x000000305d307210ULL, 0x000fe20007fde0ffULL, 0x000000ffff297224ULL, 0x000fe200000e0629ULL,
0x0000002a3500720cULL, 0x000fe20003f06070ULL, 0x00000001592a7824ULL, 0x140fe400078e024bULL,
0x0000000859597824ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fe200030e06ffULL,
0x00005e0030247a11ULL, 0x002fe200078c38ffULL, 0x0000000134317824ULL, 0x040fe200078e024bULL,
0xfffffff8592a7812ULL, 0x000fe200078ee22aULL, 0x0000000834347824ULL, 0x000fe200078e00ffULL,
0x00005f0030257a11ULL, 0x000fc400030f3c35ULL, 0x0000003624247210ULL, 0x000fe20007fde0ffULL,
0x000000102a277824ULL, 0x004fe200078e022bULL, 0xfffffff834267812ULL, 0x000fc600078ee231ULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x0000000028277faeULL, 0x0003e2000e901c46ULL,
0x00000010262b7824ULL, 0x000fca00078e022bULL, 0x00000000242b7faeULL, 0x0003e2000c101c46ULL,
0x000003e000007947ULL, 0x000fea0003800000ULL, 0x0000001024247812ULL, 0x000fe200078ec0ffULL,
0x000000104b367824ULL, 0x000fc600078e00ffULL, 0x000000244b257211ULL, 0x000fe400078fe8ffULL,
0x0000007036367812ULL, 0x000fe400078ec0ffULL, 0x0000000425267810ULL, 0x040fe20007ffe0ffULL,
0x0000000125247824ULL, 0x140fe200078e024bULL, 0x0000000825287810ULL, 0x040fe20007ffe0ffULL,
0x0000000825317824ULL, 0x000fe400078e00ffULL, 0x0000000126277824ULL, 0x100fe400078e024bULL,
0x0000000128297824ULL, 0x040fe200078e024bULL, 0xfffffff831317812ULL, 0x000fe200078ee224ULL,
0x0000000125247824ULL, 0x040fe200078e0232ULL, 0x0000000c25257810ULL, 0x000fe20007ffe0ffULL,
0x0000000828307824ULL, 0x000fc400078e00ffULL, 0x00000008262a7824ULL, 0x040fe200078e00ffULL,
0x000000245d347210ULL, 0x000fe20007f1e0ffULL, 0x0000000126247824ULL, 0x100fe200078e0232ULL,
0xfffffff830377812ULL, 0x000fe200078ee229ULL, 0x0000000128267824ULL, 0x100fe200078e0232ULL,
0xfffffff82a357812ULL, 0x000fe200078ee227ULL, 0x0000000125287824ULL, 0x000fe200078e0232ULL,
0x000000245d247210ULL, 0x000fe20007fbe0ffULL, 0x00000001252b7824ULL, 0x040fe400078e024bULL,
0x0000000825307824ULL, 0x000fc400078e00ffULL, 0x000000ffff297224ULL, 0x000fe200000e06ffULL,
0x00005e0034337a11ULL, 0x000fe200078038ffULL, 0x000000ffff257224ULL, 0x000fe200028e06ffULL,
0x00005e0024277a11ULL, 0x000fe200078a38ffULL, 0x00001000422a7824ULL, 0x000fe200078e00ffULL,
0x00005f0034347a11ULL, 0x000fe400000f3c29ULL, 0x00005f0024327a11ULL, 0x000fe400028f3c25ULL,
0x000010002a2a7812ULL, 0x000fe400078ec0ffULL, 0x000000265d267210ULL, 0x000fc40007f1e0ffULL,
0x000000285d287210ULL, 0x000fe20007fbe0ffULL, 0x0000200049247824ULL, 0x000fe200078e022aULL,
0xfffffff830597812ULL, 0x000fe200078ee22bULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005e0026297a11ULL, 0x000fe200078038ffULL, 0x000000ffff2b7224ULL, 0x000fe200028e06ffULL,
0x00005e00282a7a11ULL, 0x000fe400078a38ffULL, 0x0000b00024567810ULL, 0x000fe40007ffe0ffULL,
0x00005f0026307a11ULL, 0x000fc400000f3c25ULL, 0x00005f00282b7a11ULL, 0x000fe200028f3c2bULL,
0x0000001031317824ULL, 0x100fe200078e0256ULL, 0x0000003633247210ULL, 0x080fe20007f1e0ffULL,
0x0000001035337824ULL, 0x100fe200078e0256ULL, 0x0000003627267210ULL, 0x080fe20007fbe0ffULL,
0x0000001037357824ULL, 0x000fe400078e0256ULL, 0x000000ffff257224ULL, 0x000fe200000e0634ULL,
0x0000003629287210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200028e0632ULL,
0x000000362a2a7210ULL, 0x000fe20007fbe0ffULL, 0x0000001059377824ULL, 0x000fe200078e0256ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fc400000e0630ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x0000000026337faeULL, 0x0003e8000b901c46ULL, 0x0000000028357faeULL, 0x0003e8000b901c46ULL,
0x000000002a377faeULL, 0x0003e4000b901c46ULL, 0x0000000800257824ULL, 0x002fe200078e00ffULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000000842247824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0xfffffff025257812ULL, 0x000fe400078ec0ffULL,
0x0000000824247812ULL, 0x000fca00078ec0ffULL, 0x0000000125587824ULL, 0x000fca00078e0224ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a858597810ULL, 0x000fc80007ffe0ffULL,
0x00000000590403c2ULL, 0x000e640000040000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00a9b0ULL, 0x002fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000170f070ULL, 0xffffff8000002947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800585a7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628003e287f8cULL, 0x000664000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x00f62c003e277984ULL, 0x000f240000000800ULL,
0x8000000027ff7812ULL, 0x012fe40007804829ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c003e277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008036257810ULL, 0x000fca0007ffe03dULL,
0x000000013c257824ULL, 0x000fca00078e0225ULL, 0x00f0000025247984ULL, 0x000e680000000800ULL,
0x00f2000025297984ULL, 0x0006a20000000800ULL, 0x000000572400720bULL, 0x002fe20003f1d000ULL,
0x000106227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x0000ffff25ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff287424ULL, 0x000fe400078e00ffULL, 0x000000ffff5c7224ULL, 0x000fd200078e0057ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000100277811ULL, 0x000fe400078ff0ffULL,
0x000000572400720bULL, 0x000fe40003f14000ULL, 0x000000002700720cULL, 0x000fe20003fa5270ULL,
0x000105d27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000287806ULL, 0x000fc400000e0100ULL,
0x000000800027d824ULL, 0x000fe200078e0236ULL, 0x000000572426d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x000000013c2bd824ULL, 0x000fe200078e0227ULL,
0x0000991028277816ULL, 0x000fc800000000ffULL, 0x00f400262b00d388ULL, 0x0003e20000000800ULL,
0x000000ff2700720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000005724267209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff28ff7812ULL, 0x000fc6000780c0ffULL, 0x0000005726267221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL, 0x00000026002b7308ULL, 0x000e640000000800ULL,
0x0000002b46467220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe2000001164bULL, 0x000104f27f007947ULL, 0x000fea000b800000ULL,
0x00001f262b267589ULL, 0x0002e400000e0000ULL, 0x0000002604047220ULL, 0x088fe20000410000ULL,
0x0000002605057220ULL, 0x080fe20000410000ULL, 0x0000002608087220ULL, 0x080fe20000410000ULL,
0x0000002609097220ULL, 0x080fe20000410000ULL, 0x000000260c0c7220ULL, 0x080fe20000410000ULL,
0x000000260d0d7220ULL, 0x080fe20000410000ULL, 0x0000002610107220ULL, 0x080fe20000410000ULL,
0x0000002611117220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x0000002621217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0028ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000084b267811ULL, 0x000fe200078ff0ffULL, 0x000103e27f007947ULL, 0x000fea000b800000ULL,
0x00001f262b267589ULL, 0x00066400000e0000ULL, 0x0000002606067220ULL, 0x082fe20000410000ULL,
0x0000002607077220ULL, 0x080fe20000410000ULL, 0x000000260a0a7220ULL, 0x080fe20000410000ULL,
0x000000260b0b7220ULL, 0x080fe20000410000ULL, 0x000000260e0e7220ULL, 0x080fe20000410000ULL,
0x000000260f0f7220ULL, 0x080fe20000410000ULL, 0x0000002612127220ULL, 0x080fe20000410000ULL,
0x0000002613137220ULL, 0x080fe20000410000ULL, 0x0000002616167220ULL, 0x080fe20000410000ULL,
0x0000002617177220ULL, 0x080fe20000410000ULL, 0x000000261a1a7220ULL, 0x080fe20000410000ULL,
0x000000261b1b7220ULL, 0x080fe20000410000ULL, 0x000000261e1e7220ULL, 0x080fe20000410000ULL,
0x000000261f1f7220ULL, 0x080fe20000410000ULL, 0x0000002622227220ULL, 0x080fe20000410000ULL,
0x0000002623237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff28ff7812ULL, 0x000fe20007800825ULL, 0x00000001ff287424ULL, 0x000fe200078e00ffULL,
0x00000057245c7209ULL, 0x000fd60007810000ULL, 0x8000005c24240221ULL, 0x000fe20000010000ULL,
0x00007610ff280816ULL, 0x000fc60000000028ULL, 0x3fb8aa3b24240820ULL, 0x000fc80000410000ULL,
0x0000002400380308ULL, 0x000e640000000800ULL, 0x0000003829290220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004629467221ULL, 0x004fc20000010000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x00f6ac003f277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804855ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac003f277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804855ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991028247816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000038ff24723eULL, 0x000fe400000010ffULL,
0x00000002ff257819ULL, 0x000fe4000001164bULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x0000ffc27f007947ULL, 0x000fea000b800000ULL, 0x00001f25242f7589ULL, 0x0002a400000e0000ULL,
0x0000000825267810ULL, 0x000fe20007ffe0ffULL, 0x0000fff27f007947ULL, 0x000fea000b800000ULL,
0x00001f26242e7589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001025267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0024ULL,
0x0000644000317802ULL, 0x000fc40000000f00ULL, 0x0001087000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001825267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x004fe200078e0024ULL, 0x0000649000317802ULL, 0x000fc40000000f00ULL,
0x0001082000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000151247824ULL, 0x042fe200078e0252ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000851257824ULL, 0x000fc400078e00ffULL, 0x00000002495e7824ULL, 0x000fc600078e0240ULL,
0xfffffff825257812ULL, 0x000fe400078ee224ULL, 0x0000b0005e5e7811ULL, 0x000fca00078e60ffULL,
0x00000010255a7824ULL, 0x100fe400078e025eULL, 0x000000104f577824ULL, 0x100fe400078e025eULL,
0x000000104e557824ULL, 0x100fe200078e025eULL, 0x000000005a24783bULL, 0x000e620000004200ULL,
0x000000104d547824ULL, 0x000fc600078e025eULL, 0x000000005728783bULL, 0x008ee80000004200ULL,
0x000000005534783bULL, 0x000f280000004200ULL, 0x000000005430783bULL, 0x004ea20000004200ULL,
0x0000010024a07824ULL, 0x042fe200078e00ffULL, 0x0000002400947306ULL, 0x000fe20000009400ULL,
0x00000018ffb27819ULL, 0x000fe20000011424ULL, 0x0001000024ab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe20000011425ULL, 0x0000010025b77824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x0001000025b97824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x00000024009b7306ULL, 0x000e620000005400ULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x0000010026c17824ULL, 0x000fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000010027c97824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fc40000011426ULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000002400897306ULL, 0x000ea2000000d400ULL, 0x00000018ffc97819ULL, 0x000fe400000114c9ULL,
0x00000018ffb07819ULL, 0x000fe40000011427ULL, 0x00000018ffa67819ULL, 0x008fe40000011428ULL,
0x00000018ffa37819ULL, 0x000fe20000011429ULL, 0x000000a000a97306ULL, 0x000fe20000209400ULL,
0x0000009b9400720bULL, 0x002fc40003fbd000ULL, 0x000000a000947245ULL, 0x000fe4000020d400ULL,
0x000000ab009b7245ULL, 0x000fe4000020d400ULL, 0x00000018ff907819ULL, 0x010fe20000011434ULL,
0x000000a000247306ULL, 0x0002e20000205400ULL, 0x00000018ff9a7819ULL, 0x000fe4000001142aULL,
0x00000018ff977819ULL, 0x000fe4000001142bULL, 0x00000018ff8b7819ULL, 0x000fc40000011435ULL,
0x0000000189895812ULL, 0x004fe200078efcffULL, 0x000000b200b37306ULL, 0x000fe20000209400ULL,
0x0001000027a07824ULL, 0x002fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe40000011437ULL,
0x00000018ff7f7819ULL, 0x000fe40000011436ULL, 0x00000018ffcc7819ULL, 0x000fe400000114a0ULL,
0x000000b200b47306ULL, 0x0002a20000205400ULL, 0x00000024a900720bULL, 0x008fe20003fdd000ULL,
0x0000010028a97824ULL, 0x000fe200078e00ffULL, 0x000000b200a07245ULL, 0x000fc4000020d400ULL,
0x00000018ff6e7819ULL, 0x000fe40000011430ULL, 0x00000018ff607819ULL, 0x000fe20000011431ULL,
0x000000ab00ae7306ULL, 0x000fe20000209400ULL, 0x000000c100b27245ULL, 0x002fe4000020d400ULL,
0x00000018ff627819ULL, 0x000fe40000011432ULL, 0x00000018ff5f7819ULL, 0x000fe40000011433ULL,
0x0000000194946812ULL, 0x000fe200078efcffULL, 0x000000ab00b17306ULL, 0x0002e20000205400ULL,
0x000000b4b300720bULL, 0x004fe20003fbd000ULL, 0x000001002ab47824ULL, 0x000fcc00078e00ffULL,
0x0000002500b57306ULL, 0x000fe20000009400ULL, 0x000000b700ab7245ULL, 0x002fca000020d400ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x0000002500b67306ULL, 0x000e620000005400ULL,
0x000000b1ae00720bULL, 0x008fe20003fdd000ULL, 0x0000010029ae7824ULL, 0x000fe200078e00ffULL,
0x000000c900b17245ULL, 0x000fca000020d400ULL, 0x0000002500887306ULL, 0x000eac000000d400ULL,
0x000000019b9b6812ULL, 0x000fe400078efcffULL, 0x000000b700b87306ULL, 0x000fe20000209400ULL,
0x000000b6b500720bULL, 0x002fe40003fbd000ULL, 0x000000cc00b57245ULL, 0x000fca000020d400ULL,
0x000000b700257306ULL, 0x0002ec0000205400ULL, 0x0000000188885812ULL, 0x004fe400078efcffULL,
0x000000bc00bd7306ULL, 0x000fe20000209400ULL, 0x00000018ffb77819ULL, 0x002fe400000114a9ULL,
0x000000b900a97245ULL, 0x000fca000020d400ULL, 0x000000bc00be7306ULL, 0x000e620000205400ULL,
0x00000025b800720bULL, 0x008fce0003fdd000ULL, 0x000000b900ba7306ULL, 0x000fec0000209400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x000000b900bb7306ULL, 0x000ea20000205400ULL,
0x000000bebd00720bULL, 0x002fe20003fbd000ULL, 0x000001002bbe7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fc400000114aeULL, 0x000000bc00ae7245ULL, 0x000fe4000020d400ULL,
0x00000018ffbe7819ULL, 0x000fe200000114beULL, 0x0000002600bf7306ULL, 0x000fec0000009400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x0000002600c07306ULL, 0x000e620000005400ULL,
0x000000bbba00720bULL, 0x004fce0003fdd000ULL, 0x000000c100c27306ULL, 0x000fec0000209400ULL,
0x00000001a9a96812ULL, 0x000fe400078efcffULL, 0x000000c100c37306ULL, 0x000ea20000205400ULL,
0x000000c0bf00720bULL, 0x002fce0003fbd000ULL, 0x0000002600837306ULL, 0x0002f0000000d400ULL,
0x0000002700c77306ULL, 0x000fe20000009400ULL, 0x000000c3c200720bULL, 0x004fe20003fdd000ULL,
0x0001000026267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000002700c87306ULL, 0x000e620000005400ULL, 0x0000000183835812ULL, 0x008fe400078efcffULL,
0x0000002600b37245ULL, 0x000fc6000020d400ULL, 0x00000001b2b26812ULL, 0x000fe400078efcffULL,
0x000000c900ca7306ULL, 0x000ff00000209400ULL, 0x000000c900cb7306ULL, 0x000ea20000205400ULL,
0x000000c8c700720bULL, 0x002fce0003fbd000ULL, 0x0000002700827306ULL, 0x000e70000000d400ULL,
0x000000c400c57306ULL, 0x000fe20000209400ULL, 0x000000cbca00720bULL, 0x004fce0003fdd000ULL,
0x000000c400c67306ULL, 0x000ea20000205400ULL, 0x0000000182825812ULL, 0x002fca00078efcffULL,
0x00000001b1b16812ULL, 0x000fe400078efcffULL, 0x0000002600247306ULL, 0x000ff00000209400ULL,
0x0000002600277306ULL, 0x0002e20000205400ULL, 0x000000c6c500720bULL, 0x004fce0003fbd000ULL,
0x000000b000cd7306ULL, 0x000fe20000209400ULL, 0x00000018ff267819ULL, 0x002fe400000114b4ULL,
0x000000c400b47245ULL, 0x000fc8000020d400ULL, 0x00000001b4b45812ULL, 0x000fe200078efcffULL,
0x000000b000ce7306ULL, 0x0002a20000205400ULL, 0x000000272400720bULL, 0x008fce0003fdd000ULL,
0x000000cc00257306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fca000020d400ULL,
0x00000001b3b36812ULL, 0x000fe400078efcffULL, 0x000000cc00b67306ULL, 0x000e620000205400ULL,
0x000000cecd00720bULL, 0x004fce0003fbd000ULL, 0x0000002800af7306ULL, 0x000fec0000009400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x0000002800ac7306ULL, 0x000ea20000005400ULL,
0x000000b62500720bULL, 0x002fce0003fdd000ULL, 0x000000b700b87306ULL, 0x000fec0000209400ULL,
0x00000001b5b56812ULL, 0x000fe400078efcffULL, 0x000000b700bb7306ULL, 0x000e620000205400ULL,
0x000000acaf00720bULL, 0x004fe40003fbd000ULL, 0x000000b700af7245ULL, 0x000fca000020d400ULL,
0x00000028007e7306ULL, 0x0004f0000000d400ULL, 0x0000002900ad7306ULL, 0x000fe20000009400ULL,
0x000000bbb800720bULL, 0x002fe20003fdd000ULL, 0x0001000028287824ULL, 0x004fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000002900aa7306ULL, 0x000e620000005400ULL,
0x000000017e7e5812ULL, 0x008fca00078efcffULL, 0x00000001afaf6812ULL, 0x000fe400078efcffULL,
0x000000bd00bc7306ULL, 0x000fe40000209400ULL, 0x0000007eaf7e723eULL, 0x000fcc00000010ffULL,
0x000000bd00bf7306ULL, 0x000ea20000205400ULL, 0x000000aaad00720bULL, 0x002fe20003fbd000ULL,
0x000100002bad7824ULL, 0x000fe200078e00ffULL, 0x000000bd00aa7245ULL, 0x000fc8000020d400ULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x00000029007d7306ULL, 0x0002f0000000d400ULL,
0x000000a600a87306ULL, 0x000fe20000209400ULL, 0x000000bfbc00720bULL, 0x004fe20003fdd000ULL,
0x0001000029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x000000a600a77306ULL, 0x0002a20000205400ULL, 0x000000017d7d5812ULL, 0x008fca00078efcffULL,
0x00000001aaaa6812ULL, 0x000fe400078efcffULL, 0x0000002800b97306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fce000020d400ULL, 0x0000002800ba7306ULL, 0x0002e20000205400ULL,
0x000000a7a800720bULL, 0x004fe40003fbd000ULL, 0x0000002800a77245ULL, 0x000fca000020d400ULL,
0x000000a300a57306ULL, 0x000fe20000209400ULL, 0x0001000034287824ULL, 0x002fca00078e00ffULL,
0x00000001a6a65812ULL, 0x000fe400078efcffULL, 0x000000a300a47306ULL, 0x0002a20000205400ULL,
0x000000bab900720bULL, 0x008fe20003fdd000ULL, 0x0000010034b97824ULL, 0x000fca00078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000002900247306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x00000001a7a76812ULL, 0x000fe400078efcffULL,
0x0000002900277306ULL, 0x000e620000205400ULL, 0x000000a4a500720bULL, 0x004fe40003fbd000ULL,
0x00000018ffa47819ULL, 0x000fca0000011428ULL, 0x0000002a00a27306ULL, 0x000fec0000009400ULL,
0x00000001a3a35812ULL, 0x000fe400078efcffULL, 0x0000002a00a17306ULL, 0x000ea20000005400ULL,
0x000000272400720bULL, 0x002fce0003fdd000ULL, 0x0000002600257306ULL, 0x000ff00000209400ULL,
0x0000002600b67306ULL, 0x000e620000205400ULL, 0x000000a1a200720bULL, 0x004fe40003fbd000ULL,
0x0000002600a17245ULL, 0x000fca000020d400ULL, 0x0000003400967306ULL, 0x000ff00000009400ULL,
0x0000003400957306ULL, 0x000ff00000005400ULL, 0x0000003400727306ULL, 0x0005f0000000d400ULL,
0x0000002a00787306ULL, 0x000722000000d400ULL, 0x0000002900347245ULL, 0x004fc8000020d400ULL,
0x0000000134346812ULL, 0x000fe400078efcffULL, 0x000000b62500720bULL, 0x002fe20003fdd000ULL,
0x0000002b009f7306ULL, 0x000fe20000009400ULL, 0x000100002a2a7824ULL, 0x008fe200078e00ffULL,
0x00000034a3a3723eULL, 0x000fe200000010ffULL, 0x0000010035257824ULL, 0x000fc600078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002b009e7306ULL, 0x000e620000005400ULL,
0x0000000178785812ULL, 0x010fe400078efcffULL, 0x00000018ffb67819ULL, 0x000fe20000011425ULL,
0x0001000035257824ULL, 0x000fe200078e00ffULL, 0x00000001a1a16812ULL, 0x000fc600078efcffULL,
0x000000be00b87306ULL, 0x000fe20000209400ULL, 0x00000078a134723eULL, 0x000fce00000010ffULL,
0x000000be00bb7306ULL, 0x000ea20000205400ULL, 0x0000009e9f00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff9e7819ULL, 0x000fe20000011425ULL, 0x0000010036257824ULL, 0x000fc800078e00ffULL,
0x0000002b00767306ULL, 0x000e62000000d400ULL, 0x00000018ffba7819ULL, 0x000fe20000011425ULL,
0x0000010037257824ULL, 0x000fcc00078e00ffULL, 0x0000009a009d7306ULL, 0x000fe20000209400ULL,
0x000000bbb800720bULL, 0x004fce0003fdd000ULL, 0x0000009a009c7306ULL, 0x000ea20000205400ULL,
0x0000000176765812ULL, 0x002fce00078efcffULL, 0x0000002a00ac7306ULL, 0x000ff00000209400ULL,
0x0000002a002b7306ULL, 0x000e620000205400ULL, 0x0000009c9d00720bULL, 0x004fe40003fbd000ULL,
0x0000009a009d7245ULL, 0x000fc4000020d400ULL, 0x0000002a009c7245ULL, 0x000fc6000020d400ULL,
0x00000035008e7306ULL, 0x000fec0000009400ULL, 0x000000019d9d5812ULL, 0x000fe400078efcffULL,
0x0000003500917306ULL, 0x000ff00000005400ULL, 0x0000003500737306ULL, 0x0005f0000000d400ULL,
0x0000009700997306ULL, 0x000fe20000209400ULL, 0x000000be00357245ULL, 0x004fc8000020d400ULL,
0x0000000135356812ULL, 0x000fe400078efcffULL, 0x0000002bac00720bULL, 0x002fe20003fdd000ULL,
0x0000009700987306ULL, 0x0002a20000205400ULL, 0x009800002d28783bULL, 0x000ee20000000200ULL,
0x000000763535723eULL, 0x000fcc00000010ffULL, 0x000000ad00b77306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fc6000020d400ULL, 0x000000019c9c6812ULL, 0x000fc800078efcffULL,
0x000000ad00a87306ULL, 0x000e620000205400ULL, 0x000000989900720bULL, 0x004fe40003fbd000ULL,
0x000000ad00987245ULL, 0x000fca000020d400ULL, 0x000000b900247306ULL, 0x000fec0000209400ULL,
0x0000000197975812ULL, 0x000fe400078efcffULL, 0x000000b900277306ULL, 0x000ea20000205400ULL,
0x000000a8b700720bULL, 0x002fe40003fdd000ULL, 0x000000959600720bULL, 0x000fc40003fbd000ULL,
0x000000b900957245ULL, 0x000fe4000020d400ULL, 0x00000018ffa87819ULL, 0x000fe20000011425ULL,
0x0000009000927306ULL, 0x000fe20000209400ULL, 0x0000002f28288231ULL, 0x088fe400003400ffULL,
0x0000002f2a2a8231ULL, 0x000fe400003400ffULL, 0x0000002e29298231ULL, 0x080fe200003400ffULL,
0x0000000198986812ULL, 0x000fe200078efcffULL, 0x0000002e2b2b8231ULL, 0x000fe200003400ffULL,
0x0000009000937306ULL, 0x000e620000205400ULL, 0x000000272400720bULL, 0x004fc40003fdd000ULL,
0x0000000172725812ULL, 0x000fe200078efcffULL, 0x009800004c24783bULL, 0x000ea20000000200ULL,
0x000000989797723eULL, 0x000fe200000010ffULL, 0x00000034281c723cULL, 0x000fe4000004181cULL,
0x000000a400a57306ULL, 0x000fec0000209400ULL, 0x0000000195956812ULL, 0x000fc400078efcffULL,
0x000000a400a27306ULL, 0x000ee20000205400ULL, 0x000000939200720bULL, 0x002fe40003fbd000ULL,
0x000000729572723eULL, 0x000fca00000010ffULL, 0x000000b600b87306ULL, 0x000ff00000209400ULL,
0x000000b6009f7306ULL, 0x000fe20000205400ULL, 0x000000a2a500720bULL, 0x008fce0003fdd000ULL,
0x0000003700867306ULL, 0x000fe20000009400ULL, 0x0000002f24248231ULL, 0x084fe400003400ffULL,
0x0000002f26268231ULL, 0x000fca00003400ffULL, 0x0000003700877306ULL, 0x000fe20000005400ULL,
0x0000002e25258231ULL, 0x080fe400003400ffULL, 0x0000002e27278231ULL, 0x000fca00003400ffULL,
0x00000037006b7306ULL, 0x0003f0000000d400ULL, 0x00000036008a7306ULL, 0x000fe20000009400ULL,
0x0001000037377824ULL, 0x002fca00078e00ffULL, 0x00000018ff927819ULL, 0x000fe40000011437ULL,
0x00000036008d7306ULL, 0x000e620000005400ULL, 0x0000009000377245ULL, 0x000fc8000020d400ULL,
0x0000000137375812ULL, 0x000fe400078efcffULL, 0x000000918e00720bULL, 0x000fe20003fbd000ULL,
0x00000036006c7306ULL, 0x0004e2000000d400ULL, 0x000000b6008e7245ULL, 0x000fe2000020d400ULL,
0x0001000032b67824ULL, 0x000fca00078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000009e00ac7306ULL, 0x000fe20000209400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x0000008d8a00720bULL, 0x002fe20003f1d000ULL, 0x00010000338a7824ULL, 0x000fe200078e00ffULL,
0x0000000173735812ULL, 0x000fe400078efcffULL, 0x00000018ff967819ULL, 0x000fe40000011436ULL,
0x000000a400367245ULL, 0x000fe2000020d400ULL, 0x0000009e00bb7306ULL, 0x000e620000205400ULL,
0x000000ba008d7245ULL, 0x000fc4000020d400ULL, 0x0000000136366812ULL, 0x000fe400078efcffULL,
0x0000009fb800720bULL, 0x000fe20003fdd000ULL, 0x00000100309f7824ULL, 0x000fe200078e00ffULL,
0x000000016c6c0812ULL, 0x008fe200078efcffULL, 0x0000008b008c7306ULL, 0x000fe20000209400ULL,
0x0000010033b87824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001148aULL,
0x00000018ff9f7819ULL, 0x000fe4000001149fULL, 0x00000018ffb87819ULL, 0x000fc400000114b8ULL,
0x0000008b008f7306ULL, 0x0004e20000205400ULL, 0x000000bbac00720bULL, 0x002fe20003fbd000ULL,
0x0000010032ac7824ULL, 0x000fe200078e00ffULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x000000363736723eULL, 0x000fe400000010ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x000000ba009a7306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x004fe4000020d400ULL,
0x000000738e73723eULL, 0x000fca00000010ffULL, 0x000000ba00997306ULL, 0x000e620000205400ULL,
0x0000008f8c00720bULL, 0x008fe20003fdd000ULL, 0x00000100318c7824ULL, 0x000fca00078e00ffULL,
0x00000018ffa57819ULL, 0x000fe2000001148cULL, 0x000000a800ad7306ULL, 0x000fe20000209400ULL,
0x0000009e008c7245ULL, 0x000fc8000020d400ULL, 0x000000018c8c5812ULL, 0x000fe400078efcffULL,
0x000000018b8b6812ULL, 0x000fe200078efcffULL, 0x000000a800bc7306ULL, 0x0004e20000205400ULL,
0x000000999a00720bULL, 0x002fe20003fbd000ULL, 0x00010000319a7824ULL, 0x000fe200078e00ffULL,
0x0000008c8b37723eULL, 0x000fc800000010ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x0000007f00857306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x004fca000020d400ULL,
0x000000018d8d5812ULL, 0x000fe400078efcffULL, 0x0000007f00847306ULL, 0x000e620000205400ULL,
0x000000bcad00720bULL, 0x008fe40003fdd000ULL, 0x000000878600720bULL, 0x000fe40003fbd000ULL,
0x0000006c8d6c723eULL, 0x000fc600000010ffULL, 0x0000009600a27306ULL, 0x000fec0000209400ULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x0000009600937306ULL, 0x000ea20000205400ULL,
0x000000848500720bULL, 0x002fe40003fdd000ULL, 0x000000016b6b5812ULL, 0x000fca00078efcffULL,
0x0000007b00817306ULL, 0x000ff00000209400ULL, 0x0000007b00807306ULL, 0x000e620000205400ULL,
0x00000093a200720bULL, 0x004fe40003f1d000ULL, 0x000000a7a6a2723eULL, 0x000fca00000010ffULL,
0x00000030007c7306ULL, 0x000fe40000009400ULL, 0x000000a22818723cULL, 0x000fec0000041818ULL,
0x0000003000797306ULL, 0x000fe20000005400ULL, 0x000000808100720bULL, 0x002fe40003fbd000ULL,
0x0000007f00817245ULL, 0x000fc4000020d400ULL, 0x0000007daa7f723eULL, 0x000fe400000010ffULL,
0x0000000181816812ULL, 0x000fe200078efcffULL, 0x0000003000567306ULL, 0x0003e8000000d400ULL,
0x0000007e2814723cULL, 0x000fe80000041814ULL, 0x0000009200907306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x002fca00078e00ffULL, 0x00000018ff997819ULL, 0x000fe40000011430ULL,
0x0000009200917306ULL, 0x000fe20000205400ULL, 0x000000899430723eULL, 0x000fce00000010ffULL,
0x0000009f008f7306ULL, 0x000ff00000209400ULL, 0x0000009f00a47306ULL, 0x0002b00000205400ULL,
0x00000031007a7306ULL, 0x000fe20000009400ULL, 0x0000009f009f7245ULL, 0x002fce000020d400ULL,
0x0000003100777306ULL, 0x000e620000005400ULL, 0x000000a48f00720bULL, 0x004fce0003fdd000ULL,
0x0000003100717306ULL, 0x0004ec000000d400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000a5009e7306ULL, 0x000fe20000209400ULL, 0x00000088ab31723eULL, 0x004fe400000010ffULL,
0x000000777a00720bULL, 0x002fca0003fdd000ULL, 0x000000302804723cULL, 0x000b620000041804ULL,
0x000000a500b77306ULL, 0x000e6c0000205400ULL, 0x00000082b131723eULL, 0x020fe400000010ffULL,
0x0000009600827245ULL, 0x000fe2000020d400ULL, 0x00000032006d7306ULL, 0x000fe20000009400ULL,
0x00000083b230723eULL, 0x000fc400000010ffULL, 0x0000000182820812ULL, 0x000fe400078efcffULL,
0x000000919000720bULL, 0x000fe40003f1d000ULL, 0x0000009200837245ULL, 0x000fe2000020d400ULL,
0x0000003200647306ULL, 0x000fe20000005400ULL, 0x00000030280c723cULL, 0x000be2000004180cULL,
0x0000000171716812ULL, 0x008fe400078efcffULL, 0x0000009c9d96723eULL, 0x000fe400000010ffULL,
0x000000828182723eULL, 0x000fc400000010ffULL, 0x0000003200637306ULL, 0x0005e2000000d400ULL,
0x0000007b00307245ULL, 0x020fe2000020d400ULL, 0x000000722404723cULL, 0x000fe20000041804ULL,
0x0000000183830812ULL, 0x000fe400078efcffULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x000000797c00720bULL, 0x000fe20003f1d000ULL, 0x0000003300697306ULL, 0x000fe20000009400ULL,
0x0000009ba032723eULL, 0x004fe200000010ffULL, 0x000000962820723cULL, 0x000fe20000041820ULL,
0x000000b79e00720bULL, 0x002fc40003fbd000ULL, 0x0000008a00b77245ULL, 0x000fe4000020d400ULL,
0x000000833083723eULL, 0x000fe200000010ffULL, 0x00000033006a7306ULL, 0x000fe80000005400ULL,
0x0000000156560812ULL, 0x000fc800078efcffULL, 0x00000033006f7306ULL, 0x0003f0000000d400ULL,
0x0000006e00757306ULL, 0x000fe20000209400ULL, 0x000000a9ae33723eULL, 0x002fce00000010ffULL,
0x0000006e00747306ULL, 0x0002a20000205400ULL, 0x000000322808723cULL, 0x000b6e0000041808ULL,
0x0000009900887306ULL, 0x000fe20000209400ULL, 0x000000b3b432723eULL, 0x020fe400000010ffULL,
0x000000b5b033723eULL, 0x000fc400000010ffULL, 0x0000006e006e7245ULL, 0x002fc6000020d400ULL,
0x0000009900877306ULL, 0x0002e20000205400ULL, 0x000000747500720bULL, 0x004fe20003f1d000ULL,
0x000000322810723cULL, 0x000b6c0000041810ULL, 0x0000009a00847306ULL, 0x000fe20000209400ULL,
0x000000a500327245ULL, 0x020fe2000020d400ULL, 0x000000362408723cULL, 0x000f620000041808ULL,
0x0000009900997245ULL, 0x002fc4000020d400ULL, 0x0000000132325812ULL, 0x000fe400078efcffULL,
0x0000009a00297245ULL, 0x000fe2000020d400ULL, 0x0000009a00317306ULL, 0x000e620000205400ULL,
0x000000878800720bULL, 0x008fe40003fbd000ULL, 0x000000016e6e0812ULL, 0x000fe400078efcffULL,
0x000000713271723eULL, 0x000fc600000010ffULL, 0x0000006000617306ULL, 0x000fe40000209400ULL,
0x000000822410723cULL, 0x000f680000041810ULL, 0x0000000199995812ULL, 0x000fe400078efcffULL,
0x0000006000707306ULL, 0x0004e20000205400ULL, 0x000000318400720bULL, 0x002fce0003fdd000ULL,
0x000000ac00337306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x004fca000020d400ULL,
0x0000000129296812ULL, 0x000fe400078efcffULL, 0x000000ac007c7306ULL, 0x0002a20000205400ULL,
0x000000706100720bULL, 0x008fe40003fbd000ULL, 0x000000646d00720bULL, 0x000fe40003fdd000ULL,
0x0000006ba86d723eULL, 0x000fe400000010ffULL, 0x000000569f70723eULL, 0x000fe200000010ffULL,
0x000000b800767306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x002fc6000020d400ULL,
0x0000006c240c723cULL, 0x040f64000004180cULL, 0x0000000160605812ULL, 0x000fe400078efcffULL,
0x000000b800357306ULL, 0x0002e20000205400ULL, 0x0000007c3300720bULL, 0x004fe40003f1d000ULL,
0x0000000163636812ULL, 0x000fe200078efcffULL, 0x000000702414723cULL, 0x000f620000041814ULL,
0x000000296029723eULL, 0x000fc600000010ffULL, 0x000000b600287306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x002fca000020d400ULL, 0x00000001acac0812ULL, 0x000fe400078efcffULL,
0x000000b6002b7306ULL, 0x0002a20000205400ULL, 0x000000357600720bULL, 0x008fe40003fbd000ULL,
0x0000006a6900720bULL, 0x000fca0003f1d000ULL, 0x0000006200677306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x002fca000020d400ULL, 0x00000001b8b85812ULL, 0x000fe400078efcffULL,
0x0000006200687306ULL, 0x000e620000205400ULL, 0x0000002b2800720bULL, 0x004fe40003fdd000ULL,
0x000000016f6f0812ULL, 0x000fe400078efcffULL, 0x000000996e28723eULL, 0x000fe400000010ffULL,
0x00000063ac6e723eULL, 0x000fe200000010ffULL, 0x0000005f00657306ULL, 0x000fe20000209400ULL,
0x0000006fb86f723eULL, 0x000fc600000010ffULL, 0x000000282418723cULL, 0x040b640000041818ULL,
0x00000001b6b66812ULL, 0x000fe400078efcffULL, 0x0000005f00667306ULL, 0x000ea20000205400ULL,
0x000000686700720bULL, 0x002fe40003fbd000ULL, 0x0000006200297245ULL, 0x020fe2000020d400ULL,
0x0000006e241c723cULL, 0x000f62000004181cULL, 0x0000005f00287245ULL, 0x000fc6000020d400ULL,
0x0000008a002a7306ULL, 0x000fec0000209400ULL, 0x0000000129295812ULL, 0x000fe400078efcffULL,
0x0000008a00317306ULL, 0x000e620000205400ULL, 0x000000666500720bULL, 0x004fe40003f1d000ULL,
0x000000b629b6723eULL, 0x000fd600000010ffULL, 0x0000000128280812ULL, 0x000fe400078efcffULL,
0x000000312a00720bULL, 0x002fda0003fdd000ULL, 0x00000001b7b76812ULL, 0x000fc800078efcffULL,
0x000000b728b7723eULL, 0x000fce00000010ffULL, 0x000000b62420723cULL, 0x000b6e0000041820ULL,
0x0000f6c849247811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000024247f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008045277811ULL, 0x000fe200078e40ffULL, 0x00f6900050ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff2a7224ULL, 0x002fe200078e0025ULL, 0x0000000143567810ULL, 0x000fc40007ffe0ffULL,
0x000000022700720cULL, 0x000fe40003f06070ULL, 0x0000000142247812ULL, 0x000fd600078ec0ffULL,
0x00006bd000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x004fc40000015200ULL,
0x0000040041277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040041277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000247824ULL, 0x000fe200078e00ffULL, 0x0000000145257810ULL, 0x000fc80007ffe0ffULL,
0x0000002c2500720cULL, 0x000fe40003f06070ULL, 0xffffffe024267812ULL, 0x000fca00078ec0ffULL,
0x0000010045267824ULL, 0x000fca00078e0226ULL, 0x000000c026257810ULL, 0x000fc80007ffe0ffULL,
0x00000060482b7812ULL, 0x000fe200078ef825ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000001024317812ULL, 0x000fe200078ec0ffULL, 0x000000104b287824ULL, 0x000fe200078e00ffULL,
0x00000003ff307819ULL, 0x000fe4000001164bULL, 0x0000002502247217ULL, 0x000fe40007800000ULL,
0x0000000430327810ULL, 0x040fe20007ffe0ffULL, 0x00000001302a7824ULL, 0x000fe200078e0231ULL,
0x0000007028617812ULL, 0x000fe200078ec0ffULL, 0x0000000124247824ULL, 0x000fe200078e0a25ULL,
0x0000000830357810ULL, 0x000fe20007ffe0ffULL, 0x000000012a267824ULL, 0x000fc400078e022bULL,
0x0000000132347824ULL, 0x000fe200078e0231ULL, 0x0000002431247217ULL, 0x000fe20007800000ULL,
0x000000012a297824ULL, 0x040fe200078e024bULL, 0x000000265d267210ULL, 0x000fe20007f1e0ffULL,
0x000000082a2a7824ULL, 0x000fe400078e00ffULL, 0x0000000124287824ULL, 0x000fe400078e0a31ULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x00005e0026257a11ULL, 0x000fe200078038ffULL,
0x0000000134247824ULL, 0x000fe200078e022bULL, 0xfffffff82a297812ULL, 0x000fe200078ee229ULL,
0x0000000834337824ULL, 0x000fe200078e00ffULL, 0x00005f0026267a11ULL, 0x000fe200000f3c27ULL,
0x0000000135367824ULL, 0x000fe200078e0231ULL, 0x000000283000720cULL, 0x000fe20003f06070ULL,
0x0000001029297824ULL, 0x000fe200078e025eULL, 0x000000245d277210ULL, 0x000fc40007fde0ffULL,
0x0000006125247210ULL, 0x080fe40007fbe0ffULL, 0x0000000c30307810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe400030e06ffULL, 0x000000ffff257224ULL, 0x000fe200028e0626ULL,
0x000000283200720cULL, 0x000fe20003fa6070ULL, 0x0000000134327824ULL, 0x000fe200078e024bULL,
0x00005e0027267a11ULL, 0x040fe400078c38ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e4000c101c46ULL, 0x00005f0027277a11ULL, 0x000fe200030f3c2aULL,
0x00000001362a7824ULL, 0x000fe200078e022bULL, 0x0000006126267210ULL, 0x000fc40007f1e0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee232ULL, 0x0000000130327824ULL, 0x000fe200078e0231ULL,
0x0000002a5d2a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000283500720cULL, 0x000fe20003f06070ULL, 0x0000000836317824ULL, 0x000fe400078e00ffULL,
0x0000001033297824ULL, 0x002fe400078e025eULL, 0x0000000132247824ULL, 0x000fe400078e022bULL,
0x000000ffff2b7224ULL, 0x000fe200030e06ffULL, 0x0000000026297faeULL, 0x0003e2000e901c46ULL,
0x00005e002a257a11ULL, 0x000fc400078a38ffULL, 0x000000245d5d7210ULL, 0x000fe40007fde0ffULL,
0x00005f002a2b7a11ULL, 0x000fe400028f3c2bULL, 0x000000283000720cULL, 0x000fe20003fa6070ULL,
0x000000ffff2a7224ULL, 0x000fe200030e06ffULL, 0x0000006125247210ULL, 0x000fe20007fde0ffULL,
0x0000000136287824ULL, 0x000fc800078e024bULL, 0x000000ffff257224ULL, 0x000fe200030e062bULL,
0x00005e005d267a11ULL, 0x002fe200078c38ffULL, 0x00000001322b7824ULL, 0x040fe200078e024bULL,
0xfffffff831297812ULL, 0x000fe200078ee228ULL, 0x0000000832327824ULL, 0x000fe200078e00ffULL,
0x00005f005d277a11ULL, 0x000fe400030f3c2aULL, 0x0000006126267210ULL, 0x000fe20007fde0ffULL,
0x0000001029297824ULL, 0x000fe200078e025eULL, 0xfffffff8322b7812ULL, 0x000fc600078ee22bULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x0000000024297faeULL, 0x0003e2000c101c46ULL,
0x000000102b2b7824ULL, 0x000fca00078e025eULL, 0x00000000262b7faeULL, 0x0003e2000e901c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001024247812ULL, 0x000fe200078ec0ffULL,
0x000000104b617824ULL, 0x000fc600078e00ffULL, 0x000000244b267211ULL, 0x000fe400078fe8ffULL,
0x0000007061617812ULL, 0x000fe400078ec0ffULL, 0x0000000426287810ULL, 0x040fe20007ffe0ffULL,
0x0000000126247824ULL, 0x040fe200078e022bULL, 0x0000000c26367810ULL, 0x040fe20007ffe0ffULL,
0x0000000126257824ULL, 0x140fe400078e024bULL, 0x00000008262a7824ULL, 0x000fe200078e00ffULL,
0x000000245d347210ULL, 0x000fe20007f1e0ffULL, 0x0000000128277824ULL, 0x000fc400078e024bULL,
0x0000000828307824ULL, 0x000fe200078e00ffULL, 0xfffffff82a317812ULL, 0x000fe200078ee225ULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0x00005e0034327a11ULL, 0x000fe200078038ffULL,
0x0000000128247824ULL, 0x000fe200078e022bULL, 0x00000008262a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031317824ULL, 0x000fe200078e025eULL, 0xfffffff830337812ULL, 0x000fe400078ee227ULL,
0x00005f0034347a11ULL, 0x000fe200000f3c25ULL, 0x000000012a267824ULL, 0x100fe200078e022bULL,
0x000000245d307210ULL, 0x000fe20007f1e0ffULL, 0x0000000136247824ULL, 0x000fc400078e022bULL,
0x000000012a287824ULL, 0x040fe200078e024bULL, 0x000000265d267210ULL, 0x040fe20007fbe0ffULL,
0x000000082a357824ULL, 0x000fe200078e00ffULL, 0x000000245d247210ULL, 0x000fe20007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0x00005e0030277a11ULL, 0x040fe200078038ffULL,
0x000000ffff297224ULL, 0x000fe200028e06ffULL, 0xfffffff835357812ULL, 0x000fe200078ee228ULL,
0x000000ffff2b7224ULL, 0x000fe200030e06ffULL, 0x00005f0030307a11ULL, 0x000fe200000f3c25ULL,
0x0000000136257824ULL, 0x000fe200078e024bULL, 0x00005e0026287a11ULL, 0x000fe200078038ffULL,
0x0000000836367824ULL, 0x000fe200078e00ffULL, 0x00005e00242a7a11ULL, 0x000fe200078a38ffULL,
0x0000001033337824ULL, 0x100fe200078e025eULL, 0x00005f0026297a11ULL, 0x000fe200000f3c29ULL,
0x0000001035357824ULL, 0x000fe200078e025eULL, 0x00005f00242b7a11ULL, 0x000fc400028f3c2bULL,
0x0000006132247210ULL, 0x080fe40007f1e0ffULL, 0x0000006127267210ULL, 0x080fe40007fbe0ffULL,
0xfffffff836377812ULL, 0x000fe200078ee225ULL, 0x000000ffff257224ULL, 0x000fe200000e0634ULL,
0x0000006128287210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200028e0630ULL,
0x000000612a2a7210ULL, 0x000fe20007fbe0ffULL, 0x0000001037377824ULL, 0x000fe200078e025eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fc400000e0629ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x0000000026337faeULL, 0x0003e8000b901c46ULL, 0x0000000028357faeULL, 0x0003e8000b901c46ULL,
0x000000002a377faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000243247810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff4a7424ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x000000032400720cULL, 0x000fda0003fa6070ULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x0000000244247810ULL, 0x000fe20007ffe043ULL,
0x00000004ff257424ULL, 0x000fc800078e00ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000006244a7981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000530403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8003f5e7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f648003e287f8cULL, 0x0002a4000c80043fULL,
0x0000000000247805ULL, 0x002fc40000015200ULL, 0x00f64c003e277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x006fe40007804829ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c003e277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010061257810ULL, 0x000fca0007ffe03dULL,
0x000000013c257824ULL, 0x000fca00078e0225ULL, 0x00f0000025297984ULL, 0x000e680000000800ULL,
0x00f20000252b7984ULL, 0x0004e20000000800ULL, 0x0000005c2900720bULL, 0x002fe20003f1d000ULL,
0x0000d1b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x004fc800000e0100ULL,
0x0000ffff24ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff287424ULL, 0x000fe400078e00ffULL, 0x000000ffff537224ULL, 0x000fd200078e005cULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000200257811ULL, 0x000fe400078ff0ffULL,
0x0000005c2900720bULL, 0x000fe40003f14000ULL, 0x000000002500720cULL, 0x000fe20003fa5270ULL,
0x0000d1627f007947ULL, 0x000fd4000b800000ULL, 0x0000000000257806ULL, 0x000fc400000e0100ULL,
0x000000800061d824ULL, 0x000fe200078e0261ULL, 0x000000295c26d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991025277816ULL, 0x000fe200000000ffULL,
0x000000013c61d824ULL, 0x000fc600078e0261ULL, 0x000000ff2700720cULL, 0x000fe40003f05270ULL,
0x00f400266100d388ULL, 0x0003f60000000800ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000295c277209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff25ff7812ULL, 0x000fc6000780c0ffULL, 0x800000275c267221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL, 0x0000002600337308ULL, 0x000e640000000800ULL,
0x0000003346467220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe2000001164bULL, 0x0000d0827f007947ULL, 0x000fea000b800000ULL,
0x00001f2633267589ULL, 0x0002a400000e0000ULL, 0x0000002604047220ULL, 0x084fe20000410000ULL,
0x0000002605057220ULL, 0x080fe20000410000ULL, 0x0000002608087220ULL, 0x080fe20000410000ULL,
0x0000002609097220ULL, 0x080fe20000410000ULL, 0x000000260c0c7220ULL, 0x080fe20000410000ULL,
0x000000260d0d7220ULL, 0x080fe20000410000ULL, 0x0000002610107220ULL, 0x080fe20000410000ULL,
0x0000002611117220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x0000002621217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000084b267811ULL, 0x000fe200078ff0ffULL, 0x0000cf727f007947ULL, 0x000fea000b800000ULL,
0x00001f2633267589ULL, 0x00046400000e0000ULL, 0x0000002606067220ULL, 0x082fe20000410000ULL,
0x0000002607077220ULL, 0x080fe20000410000ULL, 0x000000260a0a7220ULL, 0x080fe20000410000ULL,
0x000000260b0b7220ULL, 0x080fe20000410000ULL, 0x000000260e0e7220ULL, 0x080fe20000410000ULL,
0x000000260f0f7220ULL, 0x080fe20000410000ULL, 0x0000002612127220ULL, 0x080fe20000410000ULL,
0x0000002613137220ULL, 0x080fe20000410000ULL, 0x0000002616167220ULL, 0x080fe20000410000ULL,
0x0000002617177220ULL, 0x080fe20000410000ULL, 0x000000261a1a7220ULL, 0x080fe20000410000ULL,
0x000000261b1b7220ULL, 0x080fe20000410000ULL, 0x000000261e1e7220ULL, 0x080fe20000410000ULL,
0x000000261f1f7220ULL, 0x080fe20000410000ULL, 0x0000002622227220ULL, 0x080fe20000410000ULL,
0x0000002623237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff25ff7812ULL, 0x000fe20007800824ULL, 0x00000001ff287424ULL, 0x000fe200078e00ffULL,
0x000000295c537209ULL, 0x000fd60007810000ULL, 0x8000005329290221ULL, 0x000fe20000010000ULL,
0x00007610ff280816ULL, 0x000fc60000000028ULL, 0x3fb8aa3b29290820ULL, 0x000fc80000410000ULL,
0x0000002900380308ULL, 0x000e640000000800ULL, 0x000000382b2b0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000462b467221ULL, 0x008fc20000010000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x00f6ac0058267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0058267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991028247816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000038ff24723eULL, 0x000fe400000010ffULL,
0x00000002ff257819ULL, 0x000fe4000001164bULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x0000cb527f007947ULL, 0x000fea000b800000ULL, 0x00001f25242f7589ULL, 0x0002e400000e0000ULL,
0x0000000825267810ULL, 0x000fe20007ffe0ffULL, 0x0000cb827f007947ULL, 0x000fea000b800000ULL,
0x00001f26242e7589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001025267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0024ULL,
0x00009aa000317802ULL, 0x000fc40000000f00ULL, 0x0000d21000007944ULL, 0x01cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001825267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x004fe200078e0024ULL, 0x00009af000317802ULL, 0x000fc40000000f00ULL,
0x0000d1c000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000100042247824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000151527824ULL, 0x000fc400078e0252ULL, 0x0000000851257824ULL, 0x000fe200078e00ffULL,
0x0000100024247812ULL, 0x000fc800078ec0ffULL, 0xfffffff825257812ULL, 0x000fe200078ee252ULL,
0x0000200049247824ULL, 0x000fca00078e0224ULL, 0x0000b00024527810ULL, 0x000fca0007ffe0ffULL,
0x0000001025247824ULL, 0x100fe400078e0252ULL, 0x000000104f287824ULL, 0x100fe400078e0252ULL,
0x000000104e307824ULL, 0x104fe400078e0252ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x000000104d347824ULL, 0x000fc600078e0252ULL, 0x000000002828783bULL, 0x000ea80000004200ULL,
0x000000003030783bULL, 0x000ee80000004200ULL, 0x000000003434783bULL, 0x000ea20000004200ULL,
0x0000010024987824ULL, 0x042fe200078e00ffULL, 0x00000024008e7306ULL, 0x000fe20000009400ULL,
0x00000018ffa97819ULL, 0x000fe20000011424ULL, 0x0001000024a67824ULL, 0x000fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe20000011425ULL, 0x0000010025ae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x0000010026b87824ULL, 0x000fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe200000114a6ULL, 0x00000024009b7306ULL, 0x000e620000005400ULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x0000010027c07824ULL, 0x000fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fc400000114b8ULL, 0x00000018ffbb7819ULL, 0x000fe40000011426ULL,
0x00000018ffc07819ULL, 0x000fe200000114c0ULL, 0x0000002400837306ULL, 0x000ee2000000d400ULL,
0x00000018ffc47819ULL, 0x000fe40000011427ULL, 0x00000018ffa07819ULL, 0x004fe40000011428ULL,
0x00000018ff9d7819ULL, 0x000fe40000011429ULL, 0x00000018ff947819ULL, 0x000fe2000001142aULL,
0x0000009800a57306ULL, 0x000fe20000209400ULL, 0x0000009b8e00720bULL, 0x002fe20003fbd000ULL,
0x00010000279b7824ULL, 0x000fe200078e00ffULL, 0x00000098008e7245ULL, 0x000fc4000020d400ULL,
0x00000018ff917819ULL, 0x000fe4000001142bULL, 0x00000018ffc37819ULL, 0x000fe2000001149bULL,
0x0000009800247306ULL, 0x0002a20000205400ULL, 0x000000a9009b7245ULL, 0x000fe4000020d400ULL,
0x00000018ff8a7819ULL, 0x008fe40000011430ULL, 0x00000018ff857819ULL, 0x000fe40000011431ULL,
0x0000000183835812ULL, 0x000fe200078efcffULL, 0x000000a900aa7306ULL, 0x000fe20000209400ULL,
0x000000a600987245ULL, 0x002fc4000020d400ULL, 0x00000018ff797819ULL, 0x000fe40000011432ULL,
0x00000018ff767819ULL, 0x000fe40000011433ULL, 0x00000018ff677819ULL, 0x000fe20000011434ULL,
0x000000a900ab7306ULL, 0x0002e20000205400ULL, 0x00000024a500720bULL, 0x004fe20003fdd000ULL,
0x0000010028a57824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011436ULL,
0x00000018ff4e7819ULL, 0x000fc40000011435ULL, 0x00000018ff4d7819ULL, 0x000fe20000011437ULL,
0x000000a600a77306ULL, 0x000fe20000209400ULL, 0x000000c000a97245ULL, 0x002fca000020d400ULL,
0x000000018e8e6812ULL, 0x000fe400078efcffULL, 0x000000a600a87306ULL, 0x0002a20000205400ULL,
0x000000abaa00720bULL, 0x008fe20003fbd000ULL, 0x000001002aab7824ULL, 0x000fcc00078e00ffULL,
0x0000002500ac7306ULL, 0x000fe20000009400ULL, 0x000000ae00a67245ULL, 0x002fca000020d400ULL,
0x000000019b9b5812ULL, 0x000fe400078efcffULL, 0x0000002500ad7306ULL, 0x000e620000005400ULL,
0x000000a8a700720bULL, 0x004fe20003fdd000ULL, 0x0000010029a77824ULL, 0x000fe200078e00ffULL,
0x000000b300a87245ULL, 0x000fca000020d400ULL, 0x000000ae00af7306ULL, 0x000fec0000209400ULL,
0x0000000198986812ULL, 0x000fe400078efcffULL, 0x000000ae00b07306ULL, 0x0004e20000205400ULL,
0x000000adac00720bULL, 0x002fe20003fbd000ULL, 0x000001002bad7824ULL, 0x000fcc00078e00ffULL,
0x0000002500817306ULL, 0x0002e2000000d400ULL, 0x00000018ffae7819ULL, 0x004fce00000114a5ULL,
0x000000b300b47306ULL, 0x000fe20000209400ULL, 0x0001000025257824ULL, 0x002fe200078e00ffULL,
0x000000b0af00720bULL, 0x008fc80003fdd000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x000000b300b57306ULL, 0x000e620000205400ULL, 0x0000000181815812ULL, 0x000fe400078efcffULL,
0x0000002500a57245ULL, 0x000fc8000020d400ULL, 0x00000001a6a66812ULL, 0x000fe200078efcffULL,
0x0000002500b17306ULL, 0x000ff00000209400ULL, 0x0000002500b27306ULL, 0x000ea20000205400ULL,
0x000000b5b400720bULL, 0x002fc40003fbd000ULL, 0x00000018ffb47819ULL, 0x000fe400000114a7ULL,
0x000000b800a77245ULL, 0x000fc6000020d400ULL, 0x0000002600b67306ULL, 0x000fec0000009400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000002600b77306ULL, 0x000e620000005400ULL,
0x000000b2b100720bULL, 0x004fce0003fdd000ULL, 0x000000b800b97306ULL, 0x000fec0000209400ULL,
0x00000001a5a56812ULL, 0x000fe400078efcffULL, 0x000000b800ba7306ULL, 0x000ea20000205400ULL,
0x000000b7b600720bULL, 0x002fe40003fbd000ULL, 0x00000018ffb77819ULL, 0x000fc400000114adULL,
0x000000c400ad7245ULL, 0x000fc6000020d400ULL, 0x00000026007e7306ULL, 0x0002f0000000d400ULL,
0x0000002700be7306ULL, 0x000fe20000009400ULL, 0x000000bab900720bULL, 0x004fe20003fdd000ULL,
0x0001000026267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000002700bf7306ULL, 0x000e620000005400ULL, 0x000000017e7e5812ULL, 0x008fe400078efcffULL,
0x0000002600aa7245ULL, 0x000fc6000020d400ULL, 0x00000001a7a76812ULL, 0x000fe400078efcffULL,
0x000000c000c17306ULL, 0x000fe40000209400ULL, 0x0000007ea77e723eULL, 0x000fcc00000010ffULL,
0x000000c000c27306ULL, 0x000ea20000205400ULL, 0x000000bfbe00720bULL, 0x002fce0003fbd000ULL,
0x00000027007c7306ULL, 0x000e70000000d400ULL, 0x000000bb00bc7306ULL, 0x000fe20000209400ULL,
0x000000c2c100720bULL, 0x004fce0003fdd000ULL, 0x000000bb00bd7306ULL, 0x000ea20000205400ULL,
0x000000017c7c5812ULL, 0x002fca00078efcffULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x0000002600247306ULL, 0x000ff00000209400ULL, 0x0000002600277306ULL, 0x0002e20000205400ULL,
0x000000bdbc00720bULL, 0x004fce0003fbd000ULL, 0x000000c400c57306ULL, 0x000fe20000209400ULL,
0x00000018ff267819ULL, 0x002fe400000114abULL, 0x000000bb00ab7245ULL, 0x000fc8000020d400ULL,
0x00000001abab5812ULL, 0x000fe200078efcffULL, 0x000000c400c67306ULL, 0x000e620000205400ULL,
0x000000272400720bULL, 0x008fce0003fdd000ULL, 0x000000c300af7306ULL, 0x000fec0000209400ULL,
0x00000001aaaa6812ULL, 0x000fe400078efcffULL, 0x000000c300ac7306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fe40003fbd000ULL, 0x000000aaabaa723eULL, 0x000fca00000010ffULL,
0x0000002800c77306ULL, 0x000fec0000009400ULL, 0x00000001adad5812ULL, 0x000fe400078efcffULL,
0x0000002800c87306ULL, 0x000e620000005400ULL, 0x000000acaf00720bULL, 0x004fe40003fdd000ULL,
0x000000c300ac7245ULL, 0x000fc4000020d400ULL, 0x000000ae00af7245ULL, 0x000fc6000020d400ULL,
0x000000ae00b07306ULL, 0x000fec0000209400ULL, 0x00000001acac6812ULL, 0x000fe400078efcffULL,
0x000000ae00b17306ULL, 0x000ea20000205400ULL, 0x000000c8c700720bULL, 0x002fe40003fbd000ULL,
0x000000acadab723eULL, 0x000fca00000010ffULL, 0x0000002800787306ULL, 0x0002f0000000d400ULL,
0x0000002900a47306ULL, 0x000fe20000009400ULL, 0x000000b1b000720bULL, 0x004fe20003fdd000ULL,
0x0001000028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000002900a37306ULL, 0x000e620000005400ULL, 0x0000000178785812ULL, 0x008fca00078efcffULL,
0x00000001afaf6812ULL, 0x000fe400078efcffULL, 0x000000b400b37306ULL, 0x000fe40000209400ULL,
0x00000078af78723eULL, 0x000fcc00000010ffULL, 0x000000b400b67306ULL, 0x000ea20000205400ULL,
0x000000a3a400720bULL, 0x002fe20003fbd000ULL, 0x000100002ba37824ULL, 0x000fe200078e00ffULL,
0x000000b400a47245ULL, 0x000fc8000020d400ULL, 0x00000018ffa37819ULL, 0x000fe200000114a3ULL,
0x0000002900777306ULL, 0x0002f0000000d400ULL, 0x000000a000a27306ULL, 0x000fe20000209400ULL,
0x000000b6b300720bULL, 0x004fe20003fdd000ULL, 0x0001000029297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x000000a000a17306ULL, 0x0002a20000205400ULL,
0x0000000177775812ULL, 0x008fca00078efcffULL, 0x00000001a4a46812ULL, 0x000fe400078efcffULL,
0x0000002800257306ULL, 0x000fe20000209400ULL, 0x000000a000a07245ULL, 0x002fce000020d400ULL,
0x0000002800b27306ULL, 0x0002e20000205400ULL, 0x000000a1a200720bULL, 0x004fe40003fbd000ULL,
0x0000002800a17245ULL, 0x000fca000020d400ULL, 0x0000009d009f7306ULL, 0x000fe20000209400ULL,
0x0000010031287824ULL, 0x002fca00078e00ffULL, 0x00000001a0a05812ULL, 0x000fe400078efcffULL,
0x0000009d009e7306ULL, 0x0002a20000205400ULL, 0x000000b22500720bULL, 0x008fe20003fdd000ULL,
0x0000010030b27824ULL, 0x000fca00078e00ffULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x0000002900247306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fca000020d400ULL,
0x00000001a1a16812ULL, 0x000fe400078efcffULL, 0x0000002900277306ULL, 0x000e620000205400ULL,
0x0000009e9f00720bULL, 0x004fe40003fbd000ULL, 0x00000029009e7245ULL, 0x000fe4000020d400ULL,
0x000000a1a0a0723eULL, 0x000fc600000010ffULL, 0x0000002a009c7306ULL, 0x000fec0000009400ULL,
0x000000019d9d5812ULL, 0x000fe400078efcffULL, 0x0000002a00997306ULL, 0x000ea20000005400ULL,
0x000000272400720bULL, 0x002fce0003fdd000ULL, 0x0000002600b57306ULL, 0x000fec0000209400ULL,
0x000000019e9e6812ULL, 0x000fe400078efcffULL, 0x0000002600b87306ULL, 0x0002e20000205400ULL,
0x000000999c00720bULL, 0x004fe40003fbd000ULL, 0x00000026009c7245ULL, 0x000fc4000020d400ULL,
0x00000018ff997819ULL, 0x000fe40000011428ULL, 0x0000009e9da1723eULL, 0x000fe200000010ffULL,
0x0000002a00717306ULL, 0x0004a2000000d400ULL, 0x0001000031267824ULL, 0x002fce00078e00ffULL,
0x0000002b009a7306ULL, 0x000fe20000009400ULL, 0x000000b8b500720bULL, 0x008fe20003fdd000ULL,
0x000100002a2a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002b00977306ULL, 0x000e620000005400ULL, 0x0000000171715812ULL, 0x000fca00078efcffULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000b700b07306ULL, 0x000ff00000209400ULL,
0x000000b700b17306ULL, 0x000ea20000205400ULL, 0x000000979a00720bULL, 0x002fc40003fbd000ULL,
0x000000b700977245ULL, 0x000fe4000020d400ULL, 0x00000018ff9a7819ULL, 0x000fe20000011426ULL,
0x0000010032267824ULL, 0x000fe400078e00ffULL, 0x0000002b00727306ULL, 0x000e70000000d400ULL,
0x0000009400967306ULL, 0x000fe20000209400ULL, 0x000000b1b000720bULL, 0x004fce0003fdd000ULL,
0x0000009400957306ULL, 0x0004e20000205400ULL, 0x0000000172725812ULL, 0x002fca00078efcffULL,
0x0000000197976812ULL, 0x000fe400078efcffULL, 0x0000002a00ae7306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x004fe4000020d400ULL, 0x000000729797723eULL, 0x000fca00000010ffULL,
0x0000002a002b7306ULL, 0x000e620000205400ULL, 0x000000959600720bULL, 0x008fe40003fbd000ULL,
0x0000002a00957245ULL, 0x000fe4000020d400ULL, 0x00000018ff967819ULL, 0x000fc60000011426ULL,
0x0000009100937306ULL, 0x000fec0000209400ULL, 0x0000000194945812ULL, 0x000fe400078efcffULL,
0x0000009100927306ULL, 0x0004e20000205400ULL, 0x0000002bae00720bULL, 0x002fe40003fdd000ULL,
0x00a000002d28783bULL, 0x000e6a0000000200ULL, 0x000000a300257306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x004fca000020d400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x000000a300a27306ULL, 0x000ea20000205400ULL, 0x000000929300720bULL, 0x008fe40003fbd000ULL,
0x000000a300927245ULL, 0x000fca000020d400ULL, 0x0000003000907306ULL, 0x000fec0000009400ULL,
0x0000000191915812ULL, 0x000fe400078efcffULL, 0x00000030008f7306ULL, 0x000ee20000005400ULL,
0x000000a22500720bULL, 0x004fe20003fdd000ULL, 0x0000010033257824ULL, 0x000fca00078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011425ULL, 0x000000b200247306ULL, 0x000fe20000209400ULL,
0x0000002f28288231ULL, 0x082fe400003400ffULL, 0x0000002f2a2a8231ULL, 0x000fc600003400ffULL,
0x0000000192926812ULL, 0x000fe200078efcffULL, 0x0000002e29298231ULL, 0x080fe200003400ffULL,
0x000000b200277306ULL, 0x000e620000205400ULL, 0x0000008f9000720bULL, 0x008fe20003fbd000ULL,
0x0000002e2b2b8231ULL, 0x000fe200003400ffULL, 0x000000b2008f7245ULL, 0x000fe4000020d400ULL,
0x000000929191723eULL, 0x000fc600000010ffULL, 0x00000030006c7306ULL, 0x0004e2000000d400ULL,
0x000000aa2810723cULL, 0x040fee0000041810ULL, 0x0000008a008c7306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x004fe200078e00ffULL, 0x000000272400720bULL, 0x002fe20003fdd000ULL,
0x000000a02818723cULL, 0x000fe20000041818ULL, 0x00a000004c24783bULL, 0x000e640000000200ULL,
0x00000018ff307819ULL, 0x000fc40000011430ULL, 0x0000008a008d7306ULL, 0x000ea20000205400ULL,
0x000000016c6c5812ULL, 0x008fcc00078efcffULL, 0x000000018f8f6812ULL, 0x000fe200078efcffULL,
0x00000030009f7306ULL, 0x000fe60000209400ULL, 0x0000006c8f6c723eULL, 0x000fca00000010ffULL,
0x0000003000b47306ULL, 0x0006620000205400ULL, 0x0000008d8c00720bULL, 0x004fe20003fbd000ULL,
0x00010000338d7824ULL, 0x000fe200078e00ffULL, 0x00000030008c7245ULL, 0x000fca000020d400ULL,
0x0000003100887306ULL, 0x000fe20000009400ULL, 0x0000010034307824ULL, 0x008fce00078e00ffULL,
0x00000031008b7306ULL, 0x000ea20000005400ULL, 0x000000b49f00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff9f7819ULL, 0x000fe2000001148dULL, 0x0000002f24248231ULL, 0x080fe200003400ffULL,
0x0000008a008d7245ULL, 0x000fe2000020d400ULL, 0x0000002f26268231ULL, 0x000fe400003400ffULL,
0x00000031006d7306ULL, 0x000e62000000d400ULL, 0x000000018d8d5812ULL, 0x000fe200078efcffULL,
0x0000002e25258231ULL, 0x000fc400003400ffULL, 0x0000002e27278231ULL, 0x000fe400003400ffULL,
0x000000018c8c6812ULL, 0x000fe400078efcffULL, 0x0000009900b07306ULL, 0x000fe20000209400ULL,
0x0000008b8800720bULL, 0x004fe40003fbd000ULL, 0x0000009900887245ULL, 0x000fe4000020d400ULL,
0x0000008c8d8c723eULL, 0x000fc600000010ffULL, 0x0000009900317306ULL, 0x0004ec0000205400ULL,
0x000000016d6d5812ULL, 0x002fe400078efcffULL, 0x0000008500867306ULL, 0x000fe20000209400ULL,
0x00000018ff997819ULL, 0x004fe20000011430ULL, 0x0000010035307824ULL, 0x000fcc00078e00ffULL,
0x0000008500897306ULL, 0x0002a20000205400ULL, 0x00000031b000720bULL, 0x008fe40003fdd000ULL,
0x00000018ffb07819ULL, 0x000fe40000011430ULL, 0x000000838e30723eULL, 0x000fe400000010ffULL,
0x00000081a631723eULL, 0x000fe200000010ffULL, 0x0000009a00ae7306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x002fca000020d400ULL, 0x0000000188886812ULL, 0x000fe200078efcffULL,
0x000000302804723cULL, 0x000b620000041804ULL, 0x0000009a00b17306ULL, 0x0002e20000205400ULL,
0x000000898600720bULL, 0x004fe40003fdd000ULL, 0x0000009a00867245ULL, 0x000fe4000020d400ULL,
0x0000006d886d723eULL, 0x000fe400000010ffULL, 0x0000007900317245ULL, 0x020fe2000020d400ULL,
0x0000003200847306ULL, 0x000fe20000009400ULL, 0x00000100369a7824ULL, 0x002fca00078e00ffULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x0000003200877306ULL, 0x000e620000005400ULL,
0x000000b1ae00720bULL, 0x008fe20003fbd000ULL, 0x0000010037b17824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fc8000001149aULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x0000009600a27306ULL, 0x000fe20000209400ULL, 0x0000006c2404723cULL, 0x000fea0000041804ULL,
0x0000000186865812ULL, 0x000fe400078efcffULL, 0x0000009600937306ULL, 0x000ea20000205400ULL,
0x000000878400720bULL, 0x002fc40003f1d000ULL, 0x00000086858d723eULL, 0x000fca00000010ffULL,
0x000000a300b37306ULL, 0x000ff00000209400ULL, 0x000000a300b67306ULL, 0x000e620000205400ULL,
0x00000093a200720bULL, 0x004fe20003fbd000ULL, 0x0001000036a27824ULL, 0x000fc400078e00ffULL,
0x0001000035937824ULL, 0x000fc600078e00ffULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x0000003200667306ULL, 0x0004e2000000d400ULL, 0x00000018ff937819ULL, 0x000fce0000011493ULL,
0x0000003300827306ULL, 0x000fe20000009400ULL, 0x0001000032327824ULL, 0x004fe200078e00ffULL,
0x000000b6b300720bULL, 0x002fc80003fdd000ULL, 0x00000018ff907819ULL, 0x000fe40000011432ULL,
0x00000033007f7306ULL, 0x000fe20000005400ULL, 0x0000000166660812ULL, 0x008fe400078efcffULL,
0x0000009000307245ULL, 0x000fca000020d400ULL, 0x0000003300657306ULL, 0x000ff0000000d400ULL,
0x0000007900807306ULL, 0x000ff00000209400ULL, 0x00000079007d7306ULL, 0x0003f00000205400ULL,
0x0000009000327306ULL, 0x000fe20000209400ULL, 0x00000077a479723eULL, 0x002fce00000010ffULL,
0x0000009000337306ULL, 0x0002a20000205400ULL, 0x000000782814723cULL, 0x000fee0000041814ULL,
0x0000003400747306ULL, 0x000fe20000009400ULL, 0x000000959490723eULL, 0x002fce00000010ffULL,
0x0000003400757306ULL, 0x000fe20000005400ULL, 0x000000333200720bULL, 0x004fe20003f1d000ULL,
0x000000902820723cULL, 0x000fe20000041820ULL, 0x000000989b32723eULL, 0x000fe400000010ffULL,
0x000000a5a833723eULL, 0x000fc600000010ffULL, 0x0000003400627306ULL, 0x0003e8000000d400ULL,
0x000000322808723cULL, 0x000f640000041808ULL, 0x0000000130300812ULL, 0x000fe400078efcffULL,
0x0000003600687306ULL, 0x000fe20000009400ULL, 0x0001000034347824ULL, 0x002fce00078e00ffULL,
0x00000036005b7306ULL, 0x000ff00000005400ULL, 0x0000003600567306ULL, 0x0003e8000000d400ULL,
0x0000008c2408723cULL, 0x020fe80000041808ULL, 0x0000003500737306ULL, 0x000fe20000009400ULL,
0x00000018ff367819ULL, 0x002fc40000011434ULL, 0x000000a300347245ULL, 0x000fc8000020d400ULL,
0x0000000134346812ULL, 0x000fe200078efcffULL, 0x0000003500707306ULL, 0x000fe20000005400ULL,
0x0000007d8000720bULL, 0x000fce0003fdd000ULL, 0x00000035006b7306ULL, 0x0003ec000000d400ULL,
0x0000000131316812ULL, 0x000fe400078efcffULL, 0x00000076007a7306ULL, 0x000fe20000209400ULL,
0x0000009600357245ULL, 0x002fe4000020d400ULL, 0x000000719c96723eULL, 0x000fc400000010ffULL,
0x0000000135355812ULL, 0x000fe400078efcffULL, 0x0000007f8200720bULL, 0x000fe20003fbd000ULL,
0x00000076007b7306ULL, 0x0002a20000205400ULL, 0x0000007ca97f723eULL, 0x000fe200000010ffULL,
0x00000096281c723cULL, 0x000fe2000004181cULL, 0x000000663566723eULL, 0x000fe400000010ffULL,
0x000000303130723eULL, 0x000fc600000010ffULL, 0x0000009f008a7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fe2000020d400ULL, 0x0000007e280c723cULL, 0x000b64000004180cULL,
0x0000000165655812ULL, 0x000fc800078efcffULL, 0x0000009f008b7306ULL, 0x0002e20000205400ULL,
0x0000007b7a00720bULL, 0x004fe40003fbd000ULL, 0x0000006700297245ULL, 0x020fe4000020d400ULL,
0x0000009a002b7245ULL, 0x000fc6000020d400ULL, 0x0000009900897306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fca000020d400ULL, 0x0000000176765812ULL, 0x000fe400078efcffULL,
0x0000009900ae7306ULL, 0x0002a20000205400ULL, 0x0000008b8a00720bULL, 0x008fce0003f1d000ULL,
0x000000b000847306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x000000019f9f0812ULL, 0x000fe400078efcffULL, 0x000000b000877306ULL, 0x0002e20000205400ULL,
0x000000ae8900720bULL, 0x004fe40003fdd000ULL, 0x000000757400720bULL, 0x000fe40003f1d000ULL,
0x0000009f7631723eULL, 0x000fc600000010ffULL, 0x00000067006f7306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fc6000020d400ULL, 0x000000302410723cULL, 0x000f640000041810ULL,
0x0000000199996812ULL, 0x000fe400078efcffULL, 0x00000067006e7306ULL, 0x0002a20000205400ULL,
0x000000878400720bULL, 0x008fe40003fbd000ULL, 0x000000707300720bULL, 0x000fe40003fdd000ULL,
0x0000000162620812ULL, 0x000fc600078efcffULL, 0x0000003600817306ULL, 0x000fe20000209400ULL,
0x000000653467723eULL, 0x002fe400000010ffULL, 0x000000629962723eULL, 0x000fc600000010ffULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x0000003600827306ULL, 0x0002e20000205400ULL,
0x000000016b6b6812ULL, 0x000fe200078efcffULL, 0x00000066240c723cULL, 0x000f62000004180cULL,
0x0000006e6f00720bULL, 0x004fca0003f1d000ULL, 0x0000009300327306ULL, 0x000fe20000209400ULL,
0x0000003600367245ULL, 0x002fce000020d400ULL, 0x0000009300337306ULL, 0x0002a20000205400ULL,
0x000000828100720bULL, 0x008fe40003fbd000ULL, 0x0000000129290812ULL, 0x000fca00078efcffULL,
0x0000004e004f7306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fca000020d400ULL,
0x0000000136365812ULL, 0x000fe400078efcffULL, 0x0000004e006a7306ULL, 0x0002e20000205400ULL,
0x000000333200720bULL, 0x004fe40003fdd000ULL, 0x000000362936723eULL, 0x000fca00000010ffULL,
0x0000009a00777306ULL, 0x000fe20000209400ULL, 0x0000004e004e7245ULL, 0x002fca000020d400ULL,
0x0000000193936812ULL, 0x000fe400078efcffULL, 0x0000009a00747306ULL, 0x000e620000205400ULL,
0x0000006a4f00720bULL, 0x008fe40003fbd000ULL, 0x0000005b6800720bULL, 0x000fca0003fdd000ULL,
0x0000003700637306ULL, 0x000fec0000009400ULL, 0x000000014e4e5812ULL, 0x000fe400078efcffULL,
0x0000003700647306ULL, 0x000ea20000005400ULL, 0x000000747700720bULL, 0x002fe40003f1d000ULL,
0x0000000156566812ULL, 0x000fca00078efcffULL, 0x000000b100707306ULL, 0x000fec0000209400ULL,
0x000000012b2b0812ULL, 0x000fe400078efcffULL, 0x000000b1006f7306ULL, 0x000e620000205400ULL,
0x000000646300720bULL, 0x004fe40003f1d000ULL, 0x0000006bb063723eULL, 0x000fc400000010ffULL,
0x000000562b68723eULL, 0x000fc600000010ffULL, 0x000000a200287306ULL, 0x000fe40000209400ULL,
0x000000622414723cULL, 0x000f6c0000041814ULL, 0x000000a200337306ULL, 0x0004e20000205400ULL,
0x0000006f7000720bULL, 0x002fce0003fbd000ULL, 0x0000003700697306ULL, 0x0002e2000000d400ULL,
0x000000a200a27245ULL, 0x004fce000020d400ULL, 0x0000005100607306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x002fe200078e00ffULL, 0x000000332800720bULL, 0x008fe40003fdd000ULL,
0x000000b100287245ULL, 0x000fe4000020d400ULL, 0x00000018ff2a7819ULL, 0x000fe40000011437ULL,
0x0000005100617306ULL, 0x0002a20000205400ULL, 0x0000000128285812ULL, 0x000fe400078efcffULL,
0x0000000169690812ULL, 0x000fc400078efcffULL, 0x0000002a00a37245ULL, 0x000fe4000020d400ULL,
0x00000001a2a26812ULL, 0x000fe200078efcffULL, 0x0000004d005c7306ULL, 0x000fe20000209400ULL,
0x000000692869723eULL, 0x000fe400000010ffULL, 0x0000005100517245ULL, 0x002fe4000020d400ULL,
0x0000004d00287245ULL, 0x000fe4000020d400ULL, 0x000000934e37723eULL, 0x000fe200000010ffULL,
0x0000004d005d7306ULL, 0x000e620000205400ULL, 0x000000616000720bULL, 0x004fe20003fbd000ULL,
0x00000068241c723cULL, 0x040f6c000004181cULL, 0x0000002a00327306ULL, 0x000fe40000209400ULL,
0x000000362418723cULL, 0x000f680000041818ULL, 0x0000000151515812ULL, 0x000fc400078efcffULL,
0x0000002a00357306ULL, 0x000ea20000205400ULL, 0x0000005d5c00720bULL, 0x002fe40003f1d000ULL,
0x000000a251a2723eULL, 0x000fd600000010ffULL, 0x0000000128280812ULL, 0x000fe400078efcffULL,
0x000000353200720bULL, 0x004fda0003fdd000ULL, 0x00000001a3a36812ULL, 0x000fc800078efcffULL,
0x000000a328a3723eULL, 0x000fce00000010ffULL, 0x000000a22420723cULL, 0x000b6e0000041820ULL,
0x0000f6c849247811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000024247f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c045277811ULL, 0x000fe200078e40ffULL, 0x00f6980050ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff2a7224ULL, 0x002fe200078e0025ULL, 0x0000000243567810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff247224ULL, 0x000fe200078e0040ULL, 0x000000022700720cULL, 0x000fe20003f06070ULL,
0x000000ffff5c7224ULL, 0x000fc400078e0053ULL, 0x000000ffff5b7224ULL, 0x000fd400078e005fULL,
0x0000353000000947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x004fc40000015200ULL,
0x0000040041277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040041277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000245257810ULL, 0x040fe20007ffe0ffULL, 0x0000010045247824ULL, 0x000fe400078e0247ULL,
0x000058004a267a24ULL, 0x010fe200078e02ffULL, 0x0000002c2500720cULL, 0x000fe40003f06070ULL,
0x0000010024277810ULL, 0x000fe20007ffe0ffULL, 0x0000008026317824ULL, 0x000fc600078e00ffULL,
0x00000060482b7812ULL, 0x000fce00078ef827ULL, 0x0000048000008947ULL, 0x000fea0003800000ULL,
0x0000001000247824ULL, 0x000fe200078e00ffULL, 0x00000003ff307819ULL, 0x000fe2000001164bULL,
0x000000104b287824ULL, 0x000fc600078e00ffULL, 0x0000001024337812ULL, 0x000fe400078ec0ffULL,
0x0000002702247217ULL, 0x000fe40007800000ULL, 0x0000000430327810ULL, 0x040fe20007ffe0ffULL,
0x00000001302a7824ULL, 0x000fe200078e0233ULL, 0x0000007028417812ULL, 0x000fe200078ec0ffULL,
0x0000000124247824ULL, 0x000fe400078e0a27ULL, 0x000000012a257824ULL, 0x000fe400078e022bULL,
0x0000000132347824ULL, 0x000fe200078e0233ULL, 0x0000002433247217ULL, 0x000fe20007800000ULL,
0x000000082a367824ULL, 0x000fe200078e00ffULL, 0x0000002531267210ULL, 0x000fe20007f1e0ffULL,
0x0000000834357824ULL, 0x000fc400078e00ffULL, 0x0000000124287824ULL, 0x000fe400078e0a33ULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x00005e0026257a11ULL, 0x000fe200078038ffULL,
0x0000000134247824ULL, 0x000fc600078e022bULL, 0x00005f0026267a11ULL, 0x000fe200000f3c27ULL,
0x000000012a277824ULL, 0x000fe200078e024bULL, 0x000000283000720cULL, 0x000fe40003f06070ULL,
0x00000024312a7210ULL, 0x000fe40007fde0ffULL, 0x0000004125247210ULL, 0x080fe40007fbe0ffULL,
0xfffffff836297812ULL, 0x000fe200078ee227ULL, 0x000000ffff277224ULL, 0x000fe200030e06ffULL,
0x0000000830367810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200028e0626ULL,
0x00005e002a267a11ULL, 0x000fe200078c38ffULL, 0x0000001029297824ULL, 0x000fe200078e0252ULL,
0x000000283200720cULL, 0x000fe20003fa6070ULL, 0x0000000136407824ULL, 0x000fe200078e0233ULL,
0x00005f002a2a7a11ULL, 0x000fe200030f3c27ULL, 0x0000000134327824ULL, 0x000fe200078e024bULL,
0x0000000c30347810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e2000c101c46ULL, 0x0000000140277824ULL, 0x000fe200078e022bULL,
0x0000004126267210ULL, 0x000fc40007f1e0ffULL, 0xfffffff835357812ULL, 0x000fe200078ee232ULL,
0x0000000134327824ULL, 0x000fe200078e0233ULL, 0x0000002731307210ULL, 0x000fe20007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200000e062aULL, 0x000000283600720cULL, 0x000fe20003f06070ULL,
0x0000000832337824ULL, 0x040fe400078e00ffULL, 0x0000001035297824ULL, 0x002fe400078e0252ULL,
0x0000000132247824ULL, 0x000fe400078e022bULL, 0x000000ffff2b7224ULL, 0x000fe200030e06ffULL,
0x0000000026297faeULL, 0x0003e2000e901c46ULL, 0x00005e0030257a11ULL, 0x000fc400078a38ffULL,
0x00000024312a7210ULL, 0x000fe20007fde0ffULL, 0x0000000840317824ULL, 0x000fe200078e00ffULL,
0x00005f0030307a11ULL, 0x000fe400028f3c2bULL, 0x000000283400720cULL, 0x000fe20003fa6070ULL,
0x000000ffff2b7224ULL, 0x000fe200030e06ffULL, 0x0000004125247210ULL, 0x000fe20007fde0ffULL,
0x0000000140287824ULL, 0x000fc800078e024bULL, 0x000000ffff257224ULL, 0x000fe200030e0630ULL,
0x00005e002a267a11ULL, 0x002fe200078c38ffULL, 0x0000000132307824ULL, 0x000fe200078e024bULL,
0xfffffff831297812ULL, 0x000fe400078ee228ULL, 0x00005f002a277a11ULL, 0x000fe400030f3c2bULL,
0x0000004126267210ULL, 0x000fe20007fde0ffULL, 0x0000001029297824ULL, 0x000fe200078e0252ULL,
0xfffffff8332b7812ULL, 0x000fc600078ee230ULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x0000000024297faeULL, 0x0003e2000c101c46ULL, 0x000000102b2b7824ULL, 0x000fca00078e0252ULL,
0x00000000262b7faeULL, 0x0003e2000e901c46ULL, 0x000003b000007947ULL, 0x000fea0003800000ULL,
0x0000001000247824ULL, 0x000fe400078e00ffULL, 0x000000104b417824ULL, 0x000fc600078e00ffULL,
0x0000001024247812ULL, 0x000fe400078ec0ffULL, 0x0000007041417812ULL, 0x000fe400078ec0ffULL,
0x000000244b267211ULL, 0x000fc800078fe8ffULL, 0x0000000426287810ULL, 0x040fe20007ffe0ffULL,
0x0000000126247824ULL, 0x040fe400078e022bULL, 0x0000000126257824ULL, 0x140fe400078e024bULL,
0x00000008262a7824ULL, 0x000fe200078e00ffULL, 0x0000002431347210ULL, 0x000fe20007f1e0ffULL,
0x0000000128277824ULL, 0x040fe400078e024bULL, 0x0000000828307824ULL, 0x000fe200078e00ffULL,
0xfffffff82a337812ULL, 0x000fe200078ee225ULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005e0034327a11ULL, 0x000fe200078038ffULL, 0x0000000128247824ULL, 0x000fe200078e022bULL,
0x00000008262a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c26287810ULL, 0x000fe40007ffe0ffULL,
0xfffffff830357812ULL, 0x000fe200078ee227ULL, 0x000000012a267824ULL, 0x000fe200078e024bULL,
0x00005f0034347a11ULL, 0x000fe200000f3c25ULL, 0x000000012a257824ULL, 0x100fe200078e022bULL,
0x0000002431307210ULL, 0x040fe20007f1e0ffULL, 0x0000000128247824ULL, 0x000fe400078e022bULL,
0x000000082a377824ULL, 0x000fe200078e00ffULL, 0x0000002531257210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe200000e06ffULL, 0x00005e0030277a11ULL, 0x000fe200078038ffULL,
0x0000000828367824ULL, 0x000fe200078e00ffULL, 0x0000002431247210ULL, 0x000fe20007fde0ffULL,
0x0000001033317824ULL, 0x000fe200078e0252ULL, 0x00005f0030307a11ULL, 0x000fe200000f3c29ULL,
0x0000000128297824ULL, 0x000fe200078e024bULL, 0xfffffff837377812ULL, 0x000fe200078ee226ULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x00005e0025287a11ULL, 0x000fe200078038ffULL,
0x000000ffff2b7224ULL, 0x000fe200030e06ffULL, 0x00005e00242a7a11ULL, 0x000fe200078a38ffULL,
0x0000001035337824ULL, 0x100fe200078e0252ULL, 0xfffffff8364d7812ULL, 0x000fe200078ee229ULL,
0x0000001037357824ULL, 0x000fe200078e0252ULL, 0x00005f0025297a11ULL, 0x000fc400000f3c26ULL,
0x00005f00242b7a11ULL, 0x000fe200028f3c2bULL, 0x000000104d377824ULL, 0x000fe200078e0252ULL,
0x0000004132247210ULL, 0x080fe40007f1e0ffULL, 0x0000004127267210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0634ULL, 0x0000004128287210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe200028e0630ULL, 0x000000412a2a7210ULL, 0x000fe40007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fe400000e0629ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x0000000026337faeULL, 0x0003e8000b901c46ULL, 0x0000000028357faeULL, 0x0003e8000b901c46ULL,
0x000000002a377faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000590403c2ULL, 0x000e640000080000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00c9b0ULL, 0x002fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000270f070ULL, 0xffffff8000004947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a80058587f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f668003e287f8cULL, 0x0004e2000c80043fULL,
0x000000ffff5b7224ULL, 0x002fc600078e0059ULL, 0x0000000000247805ULL, 0x000fc80000015200ULL,
0x00f66c003e277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x00afc40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c003e277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180413d7810ULL, 0x000fca0007ffe03dULL, 0x000000013c3d7824ULL, 0x000fca00078e023dULL,
0x00f000003d247984ULL, 0x000e680000000800ULL, 0x00f200003d257984ULL, 0x0006a20000000800ULL,
0x000000532400720bULL, 0x002fe20003f1d000ULL, 0x00009d527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000267806ULL, 0x008fc800000e0100ULL, 0x0000ffff262a7812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff287424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x000fd200078e0053ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x0000000300277811ULL, 0x000fe400078ff0ffULL, 0x000000532400720bULL, 0x000fe40003f14000ULL,
0x000000002700720cULL, 0x000fe20003fa5270ULL, 0x00009d027f007947ULL, 0x000fd4000b800000ULL,
0x0000000000297806ULL, 0x000fc400000e0100ULL, 0x000000800041d824ULL, 0x000fe200078e0241ULL,
0x00000053245c7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991029267816ULL, 0x000fe200000000ffULL, 0x000000013c41d824ULL, 0x000fc600078e0241ULL,
0x000000ff2600720cULL, 0x000fe40003f05270ULL, 0x00f4005c4100d388ULL, 0x0003f60000000800ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000535c267221ULL, 0x002fe20000010100ULL,
0x000000ff29ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL, 0x00000026002b7308ULL, 0x000e640000000800ULL,
0x0000002b46467220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe2000001164bULL, 0x00009c327f007947ULL, 0x000fea000b800000ULL,
0x00001f262b267589ULL, 0x0002e400000e0000ULL, 0x0000002604047220ULL, 0x088fe20000410000ULL,
0x0000002605057220ULL, 0x080fe20000410000ULL, 0x0000002608087220ULL, 0x080fe20000410000ULL,
0x0000002609097220ULL, 0x080fe20000410000ULL, 0x000000260c0c7220ULL, 0x080fe20000410000ULL,
0x000000260d0d7220ULL, 0x080fe20000410000ULL, 0x0000002610107220ULL, 0x080fe20000410000ULL,
0x0000002611117220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x0000002621217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0029ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000084b267811ULL, 0x000fe200078ff0ffULL, 0x00009b227f007947ULL, 0x000fea000b800000ULL,
0x00001f262b267589ULL, 0x00066400000e0000ULL, 0x0000002606067220ULL, 0x082fe20000410000ULL,
0x0000002607077220ULL, 0x080fe20000410000ULL, 0x000000260a0a7220ULL, 0x080fe20000410000ULL,
0x000000260b0b7220ULL, 0x080fe20000410000ULL, 0x000000260e0e7220ULL, 0x080fe20000410000ULL,
0x000000260f0f7220ULL, 0x080fe20000410000ULL, 0x0000002612127220ULL, 0x080fe20000410000ULL,
0x0000002613137220ULL, 0x080fe20000410000ULL, 0x0000002616167220ULL, 0x080fe20000410000ULL,
0x0000002617177220ULL, 0x080fe20000410000ULL, 0x000000261a1a7220ULL, 0x080fe20000410000ULL,
0x000000261b1b7220ULL, 0x080fe20000410000ULL, 0x000000261e1e7220ULL, 0x080fe20000410000ULL,
0x000000261f1f7220ULL, 0x080fe20000410000ULL, 0x0000002622227220ULL, 0x080fe20000410000ULL,
0x0000002623237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2aff7812ULL, 0x000fda0007806029ULL, 0x000000245c240221ULL, 0x000fe20000010100ULL,
0x00007610ff280816ULL, 0x000fc60000000028ULL, 0x3fb8aa3b24240820ULL, 0x000fc80000410000ULL,
0x0000002400380308ULL, 0x000e640000000800ULL, 0x0000003825250220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004625467221ULL, 0x004fc40000010000ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x00f6ac003f277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780485fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac003f277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780485fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991028247816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000038ff24723eULL, 0x000fe400000010ffULL,
0x00000002ff257819ULL, 0x000fe4000001164bULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x000097227f007947ULL, 0x000fea000b800000ULL, 0x00001f25242f7589ULL, 0x0002a400000e0000ULL,
0x0000000825267810ULL, 0x000fe20007ffe0ffULL, 0x000097527f007947ULL, 0x000fea000b800000ULL,
0x00001f26242e7589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001025267810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0024ULL,
0x0000d0c000317802ULL, 0x000fc40000000f00ULL, 0x00009bf000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001825267810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x004fe200078e0024ULL, 0x0000d11000317802ULL, 0x000fc40000000f00ULL,
0x00009ba000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005a24783bULL, 0x002e680000004200ULL,
0x000000005734783bULL, 0x000f280000004200ULL, 0x000000005528783bULL, 0x008ee80000004200ULL,
0x000000005430783bULL, 0x004ea20000004200ULL, 0x00000100248b7824ULL, 0x042fe200078e00ffULL,
0x0000002400857306ULL, 0x000fe20000009400ULL, 0x00000018ff917819ULL, 0x000fe20000011424ULL,
0x00010000248e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011425ULL,
0x0000010025967824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x0000010026a07824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe2000001148eULL,
0x00000024008c7306ULL, 0x000e620000005400ULL, 0x00000018ff967819ULL, 0x000fe20000011496ULL,
0x0000010027a87824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x000fc400000114a0ULL,
0x00000018ffa37819ULL, 0x000fe40000011426ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000002400747306ULL, 0x000ea2000000d400ULL, 0x00000018ffb07819ULL, 0x010fe40000011434ULL,
0x00000018ffab7819ULL, 0x000fe40000011427ULL, 0x00000018ff8a7819ULL, 0x000fe40000011435ULL,
0x00000018ff4e7819ULL, 0x000fe20000011437ULL, 0x0000008b008d7306ULL, 0x000fe20000209400ULL,
0x0000008c8500720bULL, 0x002fe20003fbd000ULL, 0x00010000278c7824ULL, 0x000fe200078e00ffULL,
0x0000008b00857245ULL, 0x000fc4000020d400ULL, 0x00000018ff817819ULL, 0x000fe40000011436ULL,
0x00000018ff787819ULL, 0x008fe20000011428ULL, 0x0000008b00247306ULL, 0x0002e20000205400ULL,
0x00000018ff7b7819ULL, 0x000fe40000011429ULL, 0x00000018ff687819ULL, 0x000fe4000001142bULL,
0x00000018ff6b7819ULL, 0x000fe4000001142aULL, 0x0000000174745812ULL, 0x004fe200078efcffULL,
0x0000009100927306ULL, 0x000fe20000209400ULL, 0x0000008e008b7245ULL, 0x002fc4000020d400ULL,
0x00000018ff587819ULL, 0x000fe40000011430ULL, 0x00000018ff3a7819ULL, 0x000fe40000011431ULL,
0x00000018ff3c7819ULL, 0x000fe20000011432ULL, 0x0000009100937306ULL, 0x000e620000205400ULL,
0x000000248d00720bULL, 0x008fe20003fdd000ULL, 0x00000100348d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fca0000011433ULL, 0x0000008e008f7306ULL, 0x000fec0000209400ULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x0000008e00907306ULL, 0x0004e20000205400ULL,
0x000000939200720bULL, 0x002fe20003fbd000ULL, 0x0000010036927824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fc4000001148cULL, 0x00000091008c7245ULL, 0x000fe4000020d400ULL,
0x000000748574723eULL, 0x000fe200000010ffULL, 0x0000002500947306ULL, 0x000fe20000009400ULL,
0x00000096008e7245ULL, 0x004fca000020d400ULL, 0x000000018c8c5812ULL, 0x000fe400078efcffULL,
0x0000002500957306ULL, 0x000e620000005400ULL, 0x000000908f00720bULL, 0x008fe20003fdd000ULL,
0x00000100358f7824ULL, 0x000fe200078e00ffULL, 0x0000009b00907245ULL, 0x000fca000020d400ULL,
0x0000009600977306ULL, 0x000fec0000209400ULL, 0x000000018b8b6812ULL, 0x000fe400078efcffULL,
0x0000009600987306ULL, 0x000ea20000205400ULL, 0x000000959400720bULL, 0x002fe40003fbd000ULL,
0x00000018ff957819ULL, 0x000fc4000001148dULL, 0x0000008b8c8c723eULL, 0x000fc600000010ffULL,
0x0000002500757306ULL, 0x0002f0000000d400ULL, 0x0000009b009c7306ULL, 0x000fe20000209400ULL,
0x0001000025257824ULL, 0x002fe200078e00ffULL, 0x000000989700720bULL, 0x004fc80003fdd000ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000009b009d7306ULL, 0x000e620000205400ULL,
0x0000000175755812ULL, 0x008fe400078efcffULL, 0x00000025008d7245ULL, 0x000fc8000020d400ULL,
0x000000018e8e6812ULL, 0x000fe200078efcffULL, 0x0000002500997306ULL, 0x000fe60000209400ULL,
0x000000758e75723eULL, 0x000fca00000010ffULL, 0x00000025009a7306ULL, 0x0004e20000205400ULL,
0x0000009d9c00720bULL, 0x002fce0003fbd000ULL, 0x00000026009e7306ULL, 0x000fe20000009400ULL,
0x0001000034257824ULL, 0x004fca00078e00ffULL, 0x0000000190905812ULL, 0x000fe400078efcffULL,
0x00000026009f7306ULL, 0x000e620000005400ULL, 0x0000009a9900720bULL, 0x008fe40003fdd000ULL,
0x00000018ff9a7819ULL, 0x000fe2000001148fULL, 0x00010000358f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fc60000011425ULL, 0x000000a000a17306ULL, 0x000fe20000209400ULL,
0x00000018ff9d7819ULL, 0x000fca000001148fULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x000000a000a27306ULL, 0x000ea20000205400ULL, 0x0000009f9e00720bULL, 0x002fe40003fbd000ULL,
0x0000008d908d723eULL, 0x000fca00000010ffULL, 0x00000026006f7306ULL, 0x0002f0000000d400ULL,
0x0000002700a67306ULL, 0x000fe20000009400ULL, 0x000000a2a100720bULL, 0x004fe20003fdd000ULL,
0x0001000026267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000002700a77306ULL, 0x000e620000005400ULL, 0x000000016f6f5812ULL, 0x008fe400078efcffULL,
0x00000026008f7245ULL, 0x000fca000020d400ULL, 0x000000a800a97306ULL, 0x000ff00000209400ULL,
0x000000a800aa7306ULL, 0x000ea20000205400ULL, 0x000000a7a600720bULL, 0x002fce0003fbd000ULL,
0x0000003400ae7306ULL, 0x000ff00000009400ULL, 0x0000003400af7306ULL, 0x000ff00000005400ULL,
0x00000034006a7306ULL, 0x0003f0000000d400ULL, 0x00000027006e7306ULL, 0x000ee2000000d400ULL,
0x000000a000347245ULL, 0x002fc8000020d400ULL, 0x0000000134346812ULL, 0x000fe400078efcffULL,
0x000000aaa900720bULL, 0x004fe20003fdd000ULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x0000006f3434723eULL, 0x000fce00000010ffULL, 0x000000a300a57306ULL, 0x000e620000205400ULL,
0x000000016e6e5812ULL, 0x008fce00078efcffULL, 0x0000002600247306ULL, 0x000ff00000209400ULL,
0x0000002600277306ULL, 0x0004e20000205400ULL, 0x000000a5a400720bULL, 0x002fce0003fbd000ULL,
0x0000003500b37306ULL, 0x000fe20000009400ULL, 0x00000018ff267819ULL, 0x004fe40000011492ULL,
0x000000a300927245ULL, 0x000fc8000020d400ULL, 0x0000000192925812ULL, 0x000fe200078efcffULL,
0x0000003500b47306ULL, 0x000ff00000005400ULL, 0x0000003500697306ULL, 0x0003f0000000d400ULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x000000a800357245ULL, 0x002fc8000020d400ULL,
0x0000000135356812ULL, 0x000fe400078efcffULL, 0x000000272400720bULL, 0x008fe20003fdd000ULL,
0x000000ab00ad7306ULL, 0x000e620000205400ULL, 0x0000006e3535723eULL, 0x000fce00000010ffULL,
0x0000009300917306ULL, 0x000fe80000209400ULL, 0x000000018f8f6812ULL, 0x000fc800078efcffULL,
0x0000009300947306ULL, 0x000ea20000205400ULL, 0x000000adac00720bULL, 0x002fe40003fbd000ULL,
0x0000008f9290723eULL, 0x000fca00000010ffULL, 0x0000009500967306ULL, 0x000ff00000209400ULL,
0x0000009500977306ULL, 0x0002e20000205400ULL, 0x000000949100720bULL, 0x004fe20003fdd000ULL,
0x0000010037947824ULL, 0x000fe200078e00ffULL, 0x0000009300917245ULL, 0x000fc4000020d400ULL,
0x0000009500937245ULL, 0x000fe4000020d400ULL, 0x00000018ffa07819ULL, 0x000fe20000011494ULL,
0x0000009a009b7306ULL, 0x000fe20000209400ULL, 0x000000ab00947245ULL, 0x000fe4000020d400ULL,
0x0000008a00957245ULL, 0x002fe4000020d400ULL, 0x0000000194945812ULL, 0x000fe400078efcffULL,
0x000000afae00720bULL, 0x000fe20003fbd000ULL, 0x0000009a009c7306ULL, 0x000e620000205400ULL,
0x0000000191916812ULL, 0x000fc400078efcffULL, 0x000000979600720bULL, 0x008fe40003fdd000ULL,
0x0000009a00967245ULL, 0x000fe4000020d400ULL, 0x000000919491723eULL, 0x000fe200000010ffULL,
0x000000b000b17306ULL, 0x000fe80000209400ULL, 0x000000016a6a5812ULL, 0x000fe400078efcffULL,
0x000000b4b300720bULL, 0x000fc40003fbd000ULL, 0x000000b000b27306ULL, 0x000ea20000205400ULL,
0x0000000193936812ULL, 0x000fe400078efcffULL, 0x0000009c9b00720bULL, 0x002fe40003fdd000ULL,
0x0000006a936a723eULL, 0x000fc600000010ffULL, 0x0000002500987306ULL, 0x000fe60000209400ULL,
0x0000000169695812ULL, 0x000fca00078efcffULL, 0x0000002500997306ULL, 0x000e620000205400ULL,
0x000000b2b100720bULL, 0x004fe40003fbd000ULL, 0x0000000196966812ULL, 0x000fca00078efcffULL,
0x0000003700877306ULL, 0x000ff00000009400ULL, 0x0000003700867306ULL, 0x000fe20000005400ULL,
0x000000999800720bULL, 0x002fce0003fdd000ULL, 0x0000003700647306ULL, 0x0003f0000000d400ULL,
0x0000008a00b57306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x002fca00078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011437ULL, 0x0000010028377824ULL, 0x000fe200078e00ffULL,
0x0000008a00b67306ULL, 0x000e680000205400ULL, 0x00000018ffa37819ULL, 0x000fe40000011437ULL,
0x000000b000377245ULL, 0x000fe4000020d400ULL, 0x0000009d00247306ULL, 0x000fe40000209400ULL,
0x0000000137375812ULL, 0x000fcc00078efcffULL, 0x0000009d00277306ULL, 0x000fe20000205400ULL,
0x000000b6b500720bULL, 0x002fce0003fbd000ULL, 0x0000003600897306ULL, 0x000fec0000009400ULL,
0x0000000195955812ULL, 0x000fe400078efcffULL, 0x0000003600887306ULL, 0x000e700000005400ULL,
0x0000003600637306ULL, 0x0004f0000000d400ULL, 0x00000026009e7306ULL, 0x000fe20000209400ULL,
0x0001000036367824ULL, 0x004fe200078e00ffULL, 0x000000888900720bULL, 0x002fc40003fbd000ULL,
0x0000002600887245ULL, 0x000fe4000020d400ULL, 0x00000018ff977819ULL, 0x000fe40000011436ULL,
0x0000002500367245ULL, 0x000fe2000020d400ULL, 0x00000026009f7306ULL, 0x0002a60000205400ULL,
0x0000000136366812ULL, 0x000fe400078efcffULL, 0x000000272400720bULL, 0x000fe20003fdd000ULL,
0x0001000028277824ULL, 0x000fe200078e00ffULL, 0x0000000163635812ULL, 0x008fe200078efcffULL,
0x0000002800807306ULL, 0x000fe20000009400ULL, 0x000000868700720bULL, 0x000fe20003fbd000ULL,
0x0001000029267824ULL, 0x002fe200078e00ffULL, 0x000000363736723eULL, 0x000fc800000010ffULL,
0x00000018ff877819ULL, 0x000fe20000011426ULL, 0x00000028004d7306ULL, 0x000fe20000005400ULL,
0x000001002a267824ULL, 0x000fca00078e00ffULL, 0x0000000164645812ULL, 0x000fe400078efcffULL,
0x00000028005e7306ULL, 0x0003f0000000d400ULL, 0x000000a000a17306ULL, 0x000fe20000209400ULL,
0x0000009d00287245ULL, 0x002fc4000020d400ULL, 0x00000018ff9d7819ULL, 0x000fe20000011427ULL,
0x0000010029277824ULL, 0x000fe200078e00ffULL, 0x0000000128286812ULL, 0x000fe400078efcffULL,
0x0000009f9e00720bULL, 0x004fe20003fdd000ULL, 0x000000a000a27306ULL, 0x000e620000205400ULL,
0x00000018ff9e7819ULL, 0x000fe40000011427ULL, 0x000000289537723eULL, 0x000fca00000010ffULL,
0x0000008100847306ULL, 0x000fe80000209400ULL, 0x0000000188886812ULL, 0x000fc800078efcffULL,
0x0000008100837306ULL, 0x000ea20000205400ULL, 0x000000a2a100720bULL, 0x002fe40003fdd000ULL,
0x000000638828723eULL, 0x000fca00000010ffULL, 0x00000097009b7306ULL, 0x000ff00000209400ULL,
0x00000097009c7306ULL, 0x0002e20000205400ULL, 0x000000838400720bULL, 0x004fe40003fbd000ULL,
0x0000008100847245ULL, 0x000fc4000020d400ULL, 0x0000009700837245ULL, 0x000fe4000020d400ULL,
0x0000009a00817245ULL, 0x000fe2000020d400ULL, 0x0000002900767306ULL, 0x000fe20000009400ULL,
0x00000018ff977819ULL, 0x002fe20000011426ULL, 0x000001002b267824ULL, 0x000fc800078e00ffULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x0000002900797306ULL, 0x000ff00000005400ULL,
0x00000029005f7306ULL, 0x0003f0000000d400ULL, 0x0000004e00827306ULL, 0x000fe20000209400ULL,
0x000000a000297245ULL, 0x002fc8000020d400ULL, 0x0000000129296812ULL, 0x000fe400078efcffULL,
0x0000009c9b00720bULL, 0x008fe20003fdd000ULL, 0x0000004e004f7306ULL, 0x000e620000205400ULL,
0x000000642929723eULL, 0x000fce00000010ffULL, 0x0000009a00987306ULL, 0x000fe80000209400ULL,
0x0000000183836812ULL, 0x000fc800078efcffULL, 0x0000009a00997306ULL, 0x0004e20000205400ULL,
0x0000004f8200720bULL, 0x002fe40003fbd000ULL, 0x0000004e00827245ULL, 0x000fca000020d400ULL,
0x000000a300247306ULL, 0x000fe20000209400ULL, 0x00000018ff9a7819ULL, 0x004fca0000011426ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x000000a300257306ULL, 0x0002a20000205400ULL,
0x000000999800720bULL, 0x008fe40003fdd000ULL, 0x0000004d8000720bULL, 0x000fe40003fbd000ULL,
0x00a800004c4c783bULL, 0x000ee60000000200ULL, 0x00000078007e7306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x00000078007f7306ULL, 0x000e620000205400ULL, 0x000000252400720bULL, 0x004fe40003fdd000ULL,
0x000000015e5e5812ULL, 0x000fe200078efcffULL, 0x00a800002d24783bULL, 0x0005220000000200ULL,
0x000000818281723eULL, 0x000fc600000010ffULL, 0x0000009d008a7306ULL, 0x000fe20000209400ULL,
0x00000100302d7824ULL, 0x004fca00078e00ffULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x0000009d00897306ULL, 0x000ea20000205400ULL, 0x0000007f7e00720bULL, 0x002fe40003fbd000ULL,
0x0000005ea35e723eULL, 0x000fca00000010ffULL, 0x0000009e009f7306ULL, 0x000fe20000209400ULL,
0x0000002f4c4c8231ULL, 0x088fe400003400ffULL, 0x0000002f4e4e8231ULL, 0x000fca00003400ffULL,
0x0000009e00867306ULL, 0x0003e20000205400ULL, 0x000000898a00720bULL, 0x004fe20003fdd000ULL,
0x0000002e4d4d8231ULL, 0x080fe200003400ffULL, 0x00010000318a7824ULL, 0x000fe200078e00ffULL,
0x0000002e4f4f8231ULL, 0x000fc800003400ffULL, 0x0000002b00737306ULL, 0x000fe20000009400ULL,
0x0000009e009e7245ULL, 0x002fe4000020d400ULL, 0x00000018ff8a7819ULL, 0x000fe2000001148aULL,
0x0000002f24248231ULL, 0x090fe400003400ffULL, 0x0000002f26268231ULL, 0x000fe400003400ffULL,
0x0000002b00727306ULL, 0x000fe20000005400ULL, 0x0000002e25258231ULL, 0x080fe400003400ffULL,
0x0000002e27278231ULL, 0x000fca00003400ffULL, 0x0000002b00557306ULL, 0x0003e4000000d400ULL,
0x00000034240c723cULL, 0x040fec000004180cULL, 0x0000002a00777306ULL, 0x000fe20000009400ULL,
0x000100002b2b7824ULL, 0x002fe200078e00ffULL, 0x000000742404723cULL, 0x000f680000041804ULL,
0x00000018ff7f7819ULL, 0x000fc4000001142bULL, 0x0000002a007c7306ULL, 0x000e620000005400ULL,
0x00000078002b7245ULL, 0x000fe2000020d400ULL, 0x0000008c2408723cULL, 0x040f660000041808ULL,
0x000000012b2b5812ULL, 0x000fe400078efcffULL, 0x000000797600720bULL, 0x000fe20003fbd000ULL,
0x0000002a00567306ULL, 0x0004e2000000d400ULL, 0x00000018ff767819ULL, 0x000fe2000001142dULL,
0x00000100312d7824ULL, 0x000fe200078e00ffULL, 0x000000902410723cULL, 0x040f6a0000041810ULL,
0x00000087009b7306ULL, 0x000fe20000209400ULL, 0x000100002a2a7824ULL, 0x004fe200078e00ffULL,
0x0000007c7700720bULL, 0x002fe20003f1d000ULL, 0x000000362418723cULL, 0x000fe20000041818ULL,
0x000000015f5f5812ULL, 0x000fc400078efcffULL, 0x00000018ff807819ULL, 0x000fe4000001142aULL,
0x00000087009c7306ULL, 0x0002a20000205400ULL, 0x0000009d002a7245ULL, 0x000fe4000020d400ULL,
0x00000028241c723cULL, 0x000fe4000004181cULL, 0x000000012a2a6812ULL, 0x000fe400078efcffULL,
0x000000869f00720bULL, 0x000fe20003fdd000ULL, 0x0000007b007a7306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fc4000020d400ULL, 0x00000018ff867819ULL, 0x000fe2000001142dULL,
0x00010000302d7824ULL, 0x000fe200078e00ffULL, 0x0000000156560812ULL, 0x008fe400078efcffULL,
0x0000002a2b2a723eULL, 0x000fe200000010ffULL, 0x0000007b007d7306ULL, 0x000e620000205400ULL,
0x0000009c9b00720bULL, 0x004fe20003fbd000ULL, 0x00000100339b7824ULL, 0x040fe400078e00ffULL,
0x000000019e9e6812ULL, 0x000fe200078efcffULL, 0x00010000339c7824ULL, 0x000fc400078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe2000001149bULL, 0x0000009700987306ULL, 0x000fe20000209400ULL,
0x0000005f9e5f723eULL, 0x000fe400000010ffULL, 0x00000018ff9c7819ULL, 0x000fc6000001149cULL,
0x0000000187875812ULL, 0x000fe400078efcffULL, 0x0000009700997306ULL, 0x0004e20000205400ULL,
0x0000007d7a00720bULL, 0x002fe20003fdd000ULL, 0x0000005e4c04723cULL, 0x020fec0000041804ULL,
0x0000009a00a07306ULL, 0x000fe20000209400ULL, 0x0000009700977245ULL, 0x004fce000020d400ULL,
0x0000009a00a17306ULL, 0x0002a20000205400ULL, 0x000000999800720bULL, 0x008fe20003fbd000ULL,
0x0000010032987824ULL, 0x040fe400078e00ffULL, 0x0001000032997824ULL, 0x000fc600078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x0000003000677306ULL, 0x000fe20000009400ULL,
0x0000009a009a7245ULL, 0x002fe4000020d400ULL, 0x00000018ff997819ULL, 0x000fc60000011499ULL,
0x0000000197975812ULL, 0x000fe400078efcffULL, 0x0000003000667306ULL, 0x000fe20000005400ULL,
0x000000727300720bULL, 0x000fe40003fbd000ULL, 0x000000569756723eULL, 0x000fca00000010ffULL,
0x0000003000517306ULL, 0x0003ec000000d400ULL, 0x0000000155555812ULL, 0x000fe400078efcffULL,
0x0000006b00707306ULL, 0x000fe20000209400ULL, 0x0000007b00307245ULL, 0x002fc8000020d400ULL,
0x0000000130306812ULL, 0x000fe400078efcffULL, 0x000000a1a000720bULL, 0x004fe20003fdd000ULL,
0x0000006b00717306ULL, 0x000e620000205400ULL, 0x00000087302b723eULL, 0x000fce00000010ffULL,
0x0000008000897306ULL, 0x000fe20000209400ULL, 0x0000002a4c08723cULL, 0x000fe60000041808ULL,
0x000000019a9a6812ULL, 0x000fc800078efcffULL, 0x00000080007e7306ULL, 0x000ea20000205400ULL,
0x000000717000720bULL, 0x002fce0003fdd000ULL, 0x00000068006d7306ULL, 0x000ff00000209400ULL,
0x00000068006c7306ULL, 0x0002e20000205400ULL, 0x0000007e8900720bULL, 0x004fce0003f1d000ULL,
0x0000007f00787306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x002fce000020d400ULL,
0x0000007f00797306ULL, 0x000e620000205400ULL, 0x0000006c6d00720bULL, 0x008fce0003fbd000ULL,
0x00000076007a7306ULL, 0x000fec0000209400ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x00000076007d7306ULL, 0x0004f00000205400ULL, 0x0000003100657306ULL, 0x000fe20000009400ULL,
0x0000007600767245ULL, 0x004fce000020d400ULL, 0x0000003100627306ULL, 0x000eb00000005400ULL,
0x00000031005d7306ULL, 0x0009f0000000d400ULL, 0x0000003200577306ULL, 0x000fe20000009400ULL,
0x00000018ff317819ULL, 0x010fc4000001142dULL, 0x00000080002d7245ULL, 0x000fe4000020d400ULL,
0x000000838480723eULL, 0x000fe400000010ffULL, 0x000000012d2d0812ULL, 0x000fe200078efcffULL,
0x00000032003e7306ULL, 0x000fe20000005400ULL, 0x000000797800720bULL, 0x002fc60003f1d000ULL,
0x000000802420723cULL, 0x000fe80000041820ULL, 0x00000032003d7306ULL, 0x0003f0000000d400ULL,
0x00000086007c7306ULL, 0x000fe20000209400ULL, 0x0000006b00327245ULL, 0x002fc4000020d400ULL,
0x00000069966b723eULL, 0x000fe400000010ffULL, 0x0000000132326812ULL, 0x000fe400078efcffULL,
0x0000007d7a00720bULL, 0x008fe20003fdd000ULL, 0x00000086007b7306ULL, 0x0002e20000205400ULL,
0x0000002d3232723eULL, 0x000fe200000010ffULL, 0x0000006a2414723cULL, 0x000b6c0000041814ULL,
0x0000003300537306ULL, 0x000fe20000009400ULL, 0x0000008600867245ULL, 0x002fc4000020d400ULL,
0x0000008a00257245ULL, 0x020fe4000020d400ULL, 0x0000000176766812ULL, 0x000fe400078efcffULL,
0x000000626500720bULL, 0x004fe20003fdd000ULL, 0x0000003300547306ULL, 0x000fe20000005400ULL,
0x0000007b7c00720bULL, 0x008fe40003fbd000ULL, 0x0000009b00267245ULL, 0x000fca000020d400ULL,
0x0000003300597306ULL, 0x0003e8000000d400ULL, 0x000000015d5d6812ULL, 0x000fe400078efcffULL,
0x0000000186865812ULL, 0x000fe400078efcffULL, 0x0000003100777306ULL, 0x000fe20000209400ULL,
0x0000007f00337245ULL, 0x002fc8000020d400ULL, 0x0000000133330812ULL, 0x000fe400078efcffULL,
0x000000666700720bULL, 0x000fe20003f1d000ULL, 0x0000003100727306ULL, 0x0002a20000205400ULL,
0x000000336833723eULL, 0x000fce00000010ffULL, 0x0000005800607306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fe2000020d400ULL, 0x000000324c10723cULL, 0x000f640000041810ULL,
0x0000000151510812ULL, 0x000fc800078efcffULL, 0x0000005800617306ULL, 0x0002e20000205400ULL,
0x000000727700720bULL, 0x004fe40003fbd000ULL, 0x000000517676723eULL, 0x000fe400000010ffULL,
0x0000005d8677723eULL, 0x000fc600000010ffULL, 0x0000008a006e7306ULL, 0x000fe20000209400ULL,
0x0000005800587245ULL, 0x002fc6000020d400ULL, 0x000000764c14723cULL, 0x000f640000041814ULL,
0x0000000131315812ULL, 0x000fe400078efcffULL, 0x0000008a00357306ULL, 0x000e620000205400ULL,
0x000000616000720bULL, 0x008fce0003f1d000ULL, 0x0000003a003b7306ULL, 0x000fec0000209400ULL,
0x0000000158580812ULL, 0x000fe400078efcffULL, 0x0000003a005a7306ULL, 0x0004e20000205400ULL,
0x000000356e00720bULL, 0x002fce0003fdd000ULL, 0x0000009800347306ULL, 0x000fe20000209400ULL,
0x0000003a003a7245ULL, 0x004fca000020d400ULL, 0x0000000125256812ULL, 0x000fe400078efcffULL,
0x0000009800677306ULL, 0x0002a20000205400ULL, 0x0000005a3b00720bULL, 0x008fe40003fbd000ULL,
0x0000003e5700720bULL, 0x000fe40003fdd000ULL, 0x000000559a57723eULL, 0x000fc600000010ffULL,
0x0000009b00367306ULL, 0x000fe20000209400ULL, 0x0000009800987245ULL, 0x002fc6000020d400ULL,
0x000000564c0c723cULL, 0x000f64000004180cULL, 0x000000013a3a5812ULL, 0x000fe400078efcffULL,
0x0000009b00297306ULL, 0x000e620000205400ULL, 0x000000673400720bULL, 0x004fe40003f1d000ULL,
0x000000013d3d6812ULL, 0x000fe400078efcffULL, 0x000000253a25723eULL, 0x000fc600000010ffULL,
0x0000009900247306ULL, 0x000fec0000209400ULL, 0x0000000198980812ULL, 0x000fe400078efcffULL,
0x0000009900277306ULL, 0x0004e20000205400ULL, 0x000000293600720bULL, 0x002fe40003fbd000ULL,
0x000000545300720bULL, 0x000fca0003f1d000ULL, 0x0000003c00417306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x004fca000020d400ULL, 0x0000000126265812ULL, 0x000fe400078efcffULL,
0x0000003c00527306ULL, 0x0002a20000205400ULL, 0x000000272400720bULL, 0x008fe40003fdd000ULL,
0x0000000159590812ULL, 0x000fe400078efcffULL, 0x000000315824723eULL, 0x000fe400000010ffULL,
0x0000003d9858723eULL, 0x000fe200000010ffULL, 0x00000039003f7306ULL, 0x000fe20000209400ULL,
0x0000003c003c7245ULL, 0x002fc4000020d400ULL, 0x0000009c003d7245ULL, 0x000fe2000020d400ULL,
0x000000244c18723cULL, 0x040b620000041818ULL, 0x000000592659723eULL, 0x000fe400000010ffULL,
0x0000000199996812ULL, 0x000fe200078efcffULL, 0x0000003900407306ULL, 0x000e620000205400ULL,
0x000000524100720bULL, 0x004fe40003fbd000ULL, 0x0000003900247245ULL, 0x020fe2000020d400ULL,
0x000000584c1c723cULL, 0x000b68000004181cULL, 0x0000009c00287306ULL, 0x000fec0000209400ULL,
0x000000013c3c5812ULL, 0x000fc400078efcffULL, 0x0000009c00297306ULL, 0x000ea20000205400ULL,
0x000000403f00720bULL, 0x002fe40003f1d000ULL, 0x000000993c3c723eULL, 0x000fd600000010ffULL,
0x0000000124240812ULL, 0x000fe400078efcffULL, 0x000000292800720bULL, 0x004fda0003fdd000ULL,
0x000000013d3d6812ULL, 0x000fc800078efcffULL, 0x0000003d243d723eULL, 0x000fe400000010ffULL,
0x0000f6c849247811ULL, 0x000fca00078e18ffULL, 0x0000003c4c20723cULL, 0x000b620000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000024247f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00050ff7f8cULL, 0x0005e2000c80043fULL, 0x0000000243567810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x002fe200078e0025ULL, 0x0000000142247812ULL, 0x000fc400078ec0ffULL,
0x0000000145457810ULL, 0x004fc80007ffe0ffULL, 0x0000002c4500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff22b000007947ULL, 0x000fea000383ffffULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x000000ffff2b7224ULL, 0x020fe400078e0023ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0022ULL, 0x000000ffff297224ULL, 0x000fe400078e0020ULL,
0x000000ffff277224ULL, 0x000fe400078e001fULL, 0x000000ffff237224ULL, 0x000fe400078e001bULL,
0x000000ffff227224ULL, 0x000fc400078e0019ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff287224ULL, 0x000fe400078e001eULL, 0x000000ffff267224ULL, 0x000fe400078e001dULL,
0x000000ffff257224ULL, 0x004fe400078e001cULL, 0x000000ffff1f7224ULL, 0x000fe400078e0017ULL,
0x000000ffff207224ULL, 0x000fc400078e0016ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0013ULL,
0x000000ffff197224ULL, 0x000fe400078e0010ULL, 0x000000ffff247224ULL, 0x000fe400078e001aULL,
0x000000ffff217224ULL, 0x000fe400078e0018ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0014ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0012ULL,
0x000000ffff177224ULL, 0x000fe400078e000fULL, 0x000000ffff167224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe400078e000bULL, 0x000000ffff107224ULL, 0x000fe400078e0009ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0011ULL, 0x000000ffff187224ULL, 0x000fe400078e000eULL,
0x000000ffff157224ULL, 0x000fe400078e000cULL, 0x000000ffff147224ULL, 0x000fe400078e000aULL,
0x000000ffff0f7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0007ULL,
0x000000ffff127224ULL, 0x000fc400078e0006ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff097224ULL, 0x000fe200078e0004ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000046027810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000f1f000057802ULL, 0x000fc40000000f00ULL,
0x000078f000007944ULL, 0x012fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000004600037308ULL, 0x000ea40000001000ULL, 0xbf80000003027423ULL, 0x004fc80000000046ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203047223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee80000000000ULL, 0x0000000000087919ULL, 0x000e620000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011605ULL, 0x0000000808057811ULL, 0x002fe200078ff0ffULL,
0x0000000403067220ULL, 0x004fca0000410000ULL, 0x00001f0706047589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea200000e0000ULL, 0x0000000904097220ULL, 0x042fe20000410000ULL,
0x0000000b040b7220ULL, 0x040fe20000410000ULL, 0x0000000f040f7220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x000fe20000410000ULL, 0x0000001205127220ULL, 0x044fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000001705177220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x000fc20000410000ULL, 0x00000000002d7919ULL, 0x000ea20000000000ULL,
0x0000100000067824ULL, 0x000fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000100006067812ULL, 0x000fe400078ee2ffULL, 0x00000002ff057819ULL, 0x104fe2000001162dULL,
0x0000000147477824ULL, 0x000fe200078e022dULL, 0x000000022d027812ULL, 0x000fc400078ec0ffULL,
0x000000082d077811ULL, 0x000fe200078ff0ffULL, 0x00000008050a7824ULL, 0x040fe200078e00ffULL,
0x0000000502037211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x0000000807117824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe400078e00ffULL,
0x0000001047477824ULL, 0x000fe200078e0206ULL, 0xfffffff8110e7812ULL, 0x000fe200078ee204ULL,
0x000000082d047824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee202ULL,
0x0000000805027824ULL, 0x000fe200078e00ffULL, 0x0000000403057810ULL, 0x000fc40007ffe0ffULL,
0x0000000603077810ULL, 0x000fe40007ffe0ffULL, 0xfffffff802027812ULL, 0x000fe200078ee203ULL,
0x0000080049037824ULL, 0x000fe200078e0206ULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100e0e7824ULL, 0x100fe200078e0203ULL,
0x0000000804057812ULL, 0x000fe200078ec0ffULL, 0x0000001002047824ULL, 0x100fe200078e0203ULL,
0x000000090b02723eULL, 0x000fe200000010ffULL, 0x0000001008087824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x100fe400078e0203ULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x0000000f1003723eULL, 0x000fe200000010ffULL, 0x0000000104077824ULL, 0x000fe200078e0205ULL,
0x0000001d1e04723eULL, 0x000fe200000010ffULL, 0x0000000105087824ULL, 0x040fe200078e0208ULL,
0x0000541002107816ULL, 0x140fe20000000003ULL, 0x00000001050e7824ULL, 0x040fe200078e020eULL,
0x0000763202117816ULL, 0x000fe20000000003ULL, 0x00000001050a7824ULL, 0x040fe200078e020aULL,
0x000000151602723eULL, 0x000fe200000010ffULL, 0x00000001050c7824ULL, 0x000fe200078e020cULL,
0x000000191a03723eULL, 0x000fe200000010ffULL, 0x0000001007007388ULL, 0x0005e20000000a00ULL,
0x000000212205723eULL, 0x000fc400000010ffULL, 0x0000541002107816ULL, 0x144fe40000000003ULL,
0x0000763202117816ULL, 0x000fe40000000003ULL, 0x000000252602723eULL, 0x000fe400000010ffULL,
0x000000292a03723eULL, 0x000fe200000010ffULL, 0x0000001008007388ULL, 0x0005e40000000a00ULL,
0x0000541004107816ULL, 0x144fe40000000005ULL, 0x0000763204117816ULL, 0x000fc40000000005ULL,
0x000000120d04723eULL, 0x000fe400000010ffULL, 0x000000141305723eULL, 0x000fe200000010ffULL,
0x000000100a007388ULL, 0x0005e40000000a00ULL, 0x0000541002107816ULL, 0x144fe40000000003ULL,
0x0000763202117816ULL, 0x000fe40000000003ULL, 0x000000181702723eULL, 0x000fe400000010ffULL,
0x0000001c1b03723eULL, 0x000fe200000010ffULL, 0x000000100c007388ULL, 0x0005e60000000a00ULL,
0x00007632020f7816ULL, 0x000fc40000000003ULL, 0x0000541004107816ULL, 0x144fe40000000005ULL,
0x0000763204117816ULL, 0x000fe40000000005ULL, 0x000000201f04723eULL, 0x000fe400000010ffULL,
0x000000242305723eULL, 0x000fe200000010ffULL, 0x000000100e007388ULL, 0x0005e60000000a00ULL,
0x0000763204097816ULL, 0x000fc40000000005ULL, 0x00005410020e7816ULL, 0x004fe40000000003ULL,
0x000000282702723eULL, 0x000fe400000010ffULL, 0x0000002c2b03723eULL, 0x000fe200000010ffULL,
0x0004000e08007388ULL, 0x0005e40000000a00ULL, 0x0000541004087816ULL, 0x004fe40000000005ULL,
0x00005410020e7816ULL, 0x140fe20000000003ULL, 0x000000ff00047306ULL, 0x000fe20000205400ULL,
0x00007632020f7816ULL, 0x000fe20000000003ULL, 0x000400080a007388ULL, 0x000fe20000000a00ULL,
0x000000ff00027245ULL, 0x000fc6000020d400ULL, 0x0004000e0c007388ULL, 0x000fe40000000a00ULL,
0x000000ff00037306ULL, 0x000ea40000209400ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000047107984ULL, 0x000ee80000000c00ULL, 0x0004000047087984ULL, 0x000e680000000c00ULL,
0x0008000047147984ULL, 0x000e620000000c00ULL, 0x000000040300720bULL, 0x004fc60003f1d000ULL,
0x000c000047187984ULL, 0x000eb40000000c00ULL, 0x0000000102020812ULL, 0x000fc400078efcffULL,
0x000000ff4900720cULL, 0x000fe40003f05270ULL, 0x000000020204723eULL, 0x000fca00000010ffULL,
0x3f803f8004137831ULL, 0x048fe40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x040fe40000200010ULL,
0x3f803f80040b7831ULL, 0x042fe4000020000bULL, 0x3f803f80040a7831ULL, 0x000fc4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x000fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fc40000200014ULL,
0x3f803f800b0b7831ULL, 0x004fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x0000001047007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x0004000847007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000202d0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000047919ULL, 0x000e620000002600ULL,
0x00000003ff0e7819ULL, 0x000fe2000001162dULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff057819ULL, 0x000fe2000001160cULL, 0x0000580000047ab9ULL, 0x000fc40000000800ULL,
0x000000010e027824ULL, 0x000fe200078e022dULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x000000010c037824ULL, 0x000fc600078e0205ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000703077812ULL, 0x000fe400078ec0ffULL, 0x0ffffff802037812ULL, 0x000fe400078ef82dULL,
0x0ffffff807077812ULL, 0x000fc600078ef80cULL, 0x0000001003037824ULL, 0x100fe400078e0206ULL,
0x0000001007077824ULL, 0x000fe400078e0206ULL, 0x00000008040d7824ULL, 0x042fe200078e00ffULL,
0x0000000003087984ULL, 0x0002e20000000c00ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x0000000007107984ULL, 0x0004e20000000c00ULL,
0xfffffff80d027812ULL, 0x000fc400078ee20eULL, 0xfffffff804057812ULL, 0x000fe400078ee205ULL,
0x00000001000d7812ULL, 0x000fe400078ec0ffULL, 0x0000000402067c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe2000ff3e0ffULL, 0x000000080d0e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x002fe200000e06ffULL, 0x00005a0006027a11ULL, 0x040fe200078040ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fe200078240ffULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0x00005b0006037a11ULL, 0x000fc400000f4403ULL,
0xfffffff80e077812ULL, 0x004fe400078ee22dULL, 0x00005b0005057a11ULL, 0x000fe400008f4400ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x008fe8000c101d06ULL,
0x0000001004007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff2e7819ULL, 0x000fe20000011600ULL, 0xffffffffff2d7424ULL, 0x000fc600078e00ffULL,
0x000000032e00720cULL, 0x000fda0003f06070ULL, 0x000000023f058824ULL, 0x000fc800078e00ffULL,
0x0000640005068a24ULL, 0x000fc800078e022eULL, 0x0000600006068625ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x00000006062d8981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x00f60000ff047f8cULL, 0x000e68000c80043fULL, 0x00000006083e7981ULL, 0x000722000c1e9900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x000000802f2f7824ULL, 0x000fe400078e00ffULL,
0x0000004000397824ULL, 0x000fe400078e00ffULL, 0x0000008038387824ULL, 0x000fc600078e00ffULL,
0x000000402f0c7812ULL, 0x000fe200078ef839ULL, 0x000000382d1f7224ULL, 0x004fc800078e02ffULL,
0x0000071000000947ULL, 0x000fea0003800000ULL, 0x00000002ff167819ULL, 0x00afe4000001164bULL,
0x000000300e1d7812ULL, 0x000fe400078ec0ffULL, 0x0000000816137810ULL, 0x000fe20007ffe0ffULL,
0x000000010c067824ULL, 0x000fe200078e0216ULL, 0x0000001816197810ULL, 0x040fe40007ffe0ffULL,
0x0000001016157810ULL, 0x000fe20007ffe0ffULL, 0x000000010c077824ULL, 0x000fe200078e0213ULL,
0x000000061f117210ULL, 0x000fc40007f1e0ffULL, 0x00001000000e7811ULL, 0x000fe200078e68ffULL,
0x000000010c067824ULL, 0x040fe200078e0215ULL, 0x000000071f127210ULL, 0x040fe20007f3e0ffULL,
0x000000010c077824ULL, 0x000fe400078e0219ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x000000061f0b7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e00120f7a11ULL, 0x000fe400078238ffULL, 0x000000071f187210ULL, 0x000fc40007f7e0ffULL,
0x00005f0012127a11ULL, 0x000fe400008f3c09ULL, 0x0000003902067217ULL, 0x000fe20007800000ULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x00005e0011147a11ULL, 0x000fe400078038ffULL,
0x00005e0018177a11ULL, 0x000fe200078238ffULL, 0x00000001060d7824ULL, 0x000fe200078e0a39ULL,
0x0000004b4b077211ULL, 0x000fe400078fe8ffULL, 0x00005f0011117a11ULL, 0x000fe200000f3c08ULL,
0x000000ffff087224ULL, 0x000fe200010e06ffULL, 0x00005f0018187a11ULL, 0x000fe200008f3c09ULL,
0x0000000413097824ULL, 0x000fe200078e00ffULL, 0x000000141d067210ULL, 0x000fc40007f7e0ffULL,
0x00005e000b0a7a11ULL, 0x000fe400078038ffULL, 0x0000000307107812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200018e0611ULL, 0x00005f000b0b7a11ULL, 0x000fe400000f3c08ULL,
0xfffffffc09097812ULL, 0x000fe400078ee210ULL, 0x0000001d0f087210ULL, 0x000fe40007f7e0ffULL,
0x0000000d1600720cULL, 0x000fe20003f06070ULL, 0x00000010090f7824ULL, 0x000fe200078e020eULL,
0x0ffffffc104b7812ULL, 0x000fe200078ef84bULL, 0x000000ffff097224ULL, 0x000fe200018e0612ULL,
0x0000002016127810ULL, 0x000fc40007ffe0ffULL, 0x0000000d1300720cULL, 0x000fe20003f26070ULL,
0x000000104b4b7824ULL, 0x000fe200078e020eULL, 0x0000001d0a0a7210ULL, 0x000fe20007f9e0ffULL,
0x000000010c137824ULL, 0x000fe200078e0212ULL, 0x0000000d1500720cULL, 0x040fe20003f46070ULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0x0000002816147810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000064b7faeULL, 0x0003e2000c101c46ULL,
0x000000131f137210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e060bULL,
0x0000000d1900720cULL, 0x040fe20003f86070ULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0x00005e00131a7a11ULL, 0x000fe200078c38ffULL, 0x00000000080f7faeULL, 0x0005e2000c901c46ULL,
0xfffffffc15117812ULL, 0x000fc400078ee210ULL, 0x0000003016157810ULL, 0x040fe40007ffe0ffULL,
0x0000003816167810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e020eULL,
0x0000001d17067210ULL, 0x002fe40007fbe0ffULL, 0x0000000d1200720cULL, 0x080fe40003f66070ULL,
0x000000000a117faeULL, 0x0003e2000d101c46ULL, 0x000000ffff087224ULL, 0x004fe200000e06ffULL,
0xfffffffc19097812ULL, 0x000fe200078ee210ULL, 0x000000ffff077224ULL, 0x000fe200028e0618ULL,
0x0000000d1400720cULL, 0x080fe20003f46070ULL, 0x00000004160f7824ULL, 0x000fe200078e00ffULL,
0x00005f00131b7a11ULL, 0x000fe200030f3c08ULL, 0x000000010c087824ULL, 0x000fe200078e0214ULL,
0x0000000d1500720cULL, 0x080fe20003f26070ULL, 0x0000001009097824ULL, 0x000fe200078e020eULL,
0x0000000d1600720cULL, 0x000fe20003f06070ULL, 0x00000004140d7824ULL, 0x000fe200078e00ffULL,
0x000000081f197210ULL, 0x000fe20007fbe0ffULL, 0x00000004120b7824ULL, 0x002fe200078e00ffULL,
0x0000000006097faeULL, 0x0003e2000e101c46ULL, 0x000000010c0a7824ULL, 0x040fe200078e0215ULL,
0xfffffffc0d0d7812ULL, 0x100fe200078ee210ULL, 0x0000000415137824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b0b7812ULL, 0x000fe200078ee210ULL, 0x000000010c0c7824ULL, 0x000fe200078e0216ULL,
0x0000000a1f187210ULL, 0x000fe20007f9e0ffULL, 0x000000100d117824ULL, 0x000fe200078e020eULL,
0xfffffffc13137812ULL, 0x000fc400078ee210ULL, 0x0000000c1f177210ULL, 0x000fe20007fde0ffULL,
0x000000ffff067224ULL, 0x002fe200028e06ffULL, 0x00005e0019087a11ULL, 0x000fe200078a38ffULL,
0x0000001013137824ULL, 0x000fe200078e020eULL, 0xfffffffc0f077812ULL, 0x000fe200078ee210ULL,
0x000000100b0f7824ULL, 0x000fe200078e020eULL, 0x00005f0019097a11ULL, 0x000fe200028f3c06ULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0x0000001d1a067210ULL, 0x080fe20007fbe0ffULL,
0x0000001007157824ULL, 0x000fe200078e020eULL, 0x00005e00180a7a11ULL, 0x000fe200078838ffULL,
0x000000ffff0e7224ULL, 0x000fe200030e06ffULL, 0x00005e00170c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff077224ULL, 0x000fe200028e061bULL, 0x0000001d08087210ULL, 0x000fc40007fbe0ffULL,
0x00005f00180b7a11ULL, 0x000fe400020f3c0bULL, 0x0000001d0a0a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x00005f00170d7a11ULL, 0x000fe200030f3c0eULL,
0x00000000060f7faeULL, 0x0003e2000d901c46ULL, 0x0000001d0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe400020e060bULL, 0x0000000008117faeULL, 0x0003e4000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fc400028e060dULL, 0x000000000a137faeULL, 0x0003e8000c901c46ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000000c4b067211ULL, 0x04afe400078ff0ffULL, 0x000000104b077811ULL, 0x000fe400078ff0ffULL,
0x000000061f067210ULL, 0x000fe40007f1e0ffULL, 0x000000184b097811ULL, 0x040fe200078ff0ffULL,
0x000000010c087824ULL, 0x040fe200078e0207ULL, 0x000000204b0b7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0x000000304b117811ULL, 0x040fe200078ff0ffULL,
0x000000010c0a7824ULL, 0x040fe200078e0209ULL, 0x0000004b4b147211ULL, 0x000fe200078fe8ffULL,
0x000000010c0d7824ULL, 0x000fe200078e020bULL, 0x00005e0006247a11ULL, 0x000fe200078038ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0x000000084b177811ULL, 0x000fe200078ff0ffULL,
0x000000010c127824ULL, 0x000fe200078e0211ULL, 0x0000000314147812ULL, 0x000fe200078ec0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x00005f0006257a11ULL, 0x000fe200000f3c25ULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x000000081f1e7210ULL, 0x000fe20007fbe0ffULL,
0x000000010c067824ULL, 0x000fe200078e0217ULL, 0xfffffffc09087812ULL, 0x100fe200078ee214ULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b097812ULL, 0x000fe200078ee214ULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x000000284b0f7811ULL, 0x000fc400078ff0ffULL,
0x0000100000237811ULL, 0x000fe400078e68ffULL, 0xfffffffc110b7812ULL, 0x100fe200078ee214ULL,
0x000000010c107824ULL, 0x040fe200078e020fULL, 0x000000384b137811ULL, 0x000fe200078ff0ffULL,
0x000000040f197824ULL, 0x000fe200078e00ffULL, 0x0000000a1f1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000100b217824ULL, 0x000fe200078e0223ULL, 0x000000061f227210ULL, 0x000fe20007fde0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0213ULL, 0xfffffffc07077812ULL, 0x100fe200078ee214ULL,
0x00000010091d7824ULL, 0x100fe200078e0223ULL, 0x0000000d1f187210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e001a097a11ULL, 0x000fe200078038ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x00005e0022207a11ULL, 0x000fe200078c38ffULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0xfffffffc17067812ULL, 0x100fe200078ee214ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0xfffffffc190a7812ULL, 0x000fe200078ee214ULL,
0x0000001007197824ULL, 0x100fe200078e0223ULL, 0x000000121f0d7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000000c1f157210ULL, 0x040fe20007f9e0ffULL,
0x0000001006177824ULL, 0x000fe200078e0223ULL, 0x00005f001a1a7a11ULL, 0x000fe200000f3c0bULL,
0x00000010081b7824ULL, 0x100fe200078e0223ULL, 0x000000300e0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fe200020e06ffULL, 0x000000101f167210ULL, 0x000fe20007f5e0ffULL,
0x000000100a1f7824ULL, 0x000fe200078e0223ULL, 0x00005f0022227a11ULL, 0x000fe200030f3c0fULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x00005e001e1c7a11ULL, 0x000fc400078a38ffULL,
0x00005e00180f7a11ULL, 0x000fe400078238ffULL, 0x0ffffffc144b7812ULL, 0x000fe400078ef84bULL,
0xfffffffc130c7812ULL, 0x000fe400078ee214ULL, 0x000000240b067210ULL, 0x000fe20007f1e0ffULL,
0x000000104b4b7824ULL, 0x000fe200078e0223ULL, 0x00005f001e1e7a11ULL, 0x000fe200028f3c11ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078638ffULL,
0x000000100c237824ULL, 0x000fe200078e0223ULL, 0x00005f0018187a11ULL, 0x000fe200008f3c07ULL,
0x000000ffff077224ULL, 0x000fe200000e0625ULL, 0x00005e0016107a11ULL, 0x000fc400078238ffULL,
0x00005e000d127a11ULL, 0x000fe400078438ffULL, 0x00005f0015157a11ULL, 0x000fe200018f3c08ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000064b7faeULL, 0x0003e2000b901c46ULL,
0x000000200b087210ULL, 0x000fe40007f1e0ffULL, 0x00005f0016117a11ULL, 0x000fe400008f3c11ULL,
0x00005f000d137a11ULL, 0x000fe400010f3c0aULL, 0x0000001c0b0a7210ULL, 0x000fc40007f3e0ffULL,
0x000000090b0c7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0622ULL,
0x0000000f0b0e7210ULL, 0x040fe40007f7e0ffULL, 0x000000100b107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061aULL, 0x000000120b127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0618ULL, 0x000000140b147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e061eULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fc400020e0611ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc600000e0615ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002000047824ULL, 0x002fca00078e0205ULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05077812ULL, 0x000fe400078ec0ffULL, 0x0000000f04057812ULL, 0x000fc600078ec0ffULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x0000001005097824ULL, 0x040fe400078e00ffULL,
0x0000001005067824ULL, 0x000fe200078e00ffULL, 0x0000000f07047812ULL, 0x040fe400078ec0ffULL,
0x0000000107077810ULL, 0x000fe40007ffe0ffULL, 0x000000f009047812ULL, 0x000fe400078ee204ULL,
0x0000000f07077812ULL, 0x000fc600078ec0ffULL, 0x00000000040c7984ULL, 0x000e62000000cc00ULL,
0x000000f006077812ULL, 0x000fca00078ee207ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001004007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff2c00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000000003a7919ULL, 0x000e620000000000ULL,
0x000064003f3f7a24ULL, 0x000fe200078e02ffULL, 0x3db504f33e3e7820ULL, 0x010fe20000410000ULL,
0x0000f68800407811ULL, 0x000fe200078e18ffULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0xffffffff2c417810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x0000f60800427811ULL, 0x000fc400078e28ffULL, 0x0000010044457824ULL, 0x000fe200078e0239ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000450200720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e0043ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fc4000001ff00ULL, 0x0000000146257810ULL, 0x000fe20007ffe0ffULL,
0x00000d8000007945ULL, 0x000fe20003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e0046ULL,
0x0000000147437812ULL, 0x000fe200078e0cffULL, 0x000000382d377224ULL, 0x010fe200078e02ffULL,
0x0000004425247211ULL, 0x040fe200078ff8ffULL, 0x000000ffff467224ULL, 0x000fe200078e0025ULL,
0x000000022500780cULL, 0x000fc40003f06070ULL, 0x0000000124277810ULL, 0x040fe20007ffe0ffULL,
0x00000100243b7824ULL, 0x000fe200078e0239ULL, 0x0000000125577812ULL, 0x000fe400078ec0ffULL,
0x0000002c2700720cULL, 0x000fe40003f26070ULL, 0x000000403b247812ULL, 0x000fca00078ec0ffULL,
0x000000012f337824ULL, 0x020fcc00078e0224ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x002fe2000001163aULL, 0x00000004573d7824ULL, 0x000fe200078e00ffULL,
0x0000003b02257217ULL, 0x000fe20007800000ULL, 0x00000002003c7824ULL, 0x000fe200078e0243ULL,
0x0000001034507810ULL, 0x040fe20007ffe0ffULL, 0x0000000134247824ULL, 0x040fe200078e0233ULL,
0x00000008344a7810ULL, 0x040fe20007ffe0ffULL, 0x00000001253b7824ULL, 0x000fe200078e0a3bULL,
0x0000001834527810ULL, 0x000fe20007ffe0ffULL, 0x0000000150277824ULL, 0x100fe200078e0233ULL,
0x0000002437317210ULL, 0x000fe20007f3e0ffULL, 0x000000014a267824ULL, 0x000fe200078e0233ULL,
0x0000002034547810ULL, 0x000fc40007ffe0ffULL, 0x0000002737297210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x00000026372b7210ULL, 0x000fe40007f5e0ffULL,
0x00005e0031247a11ULL, 0x000fe200078238ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078638ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e002b267a11ULL, 0x000fe400078438ffULL, 0x00005f0029297a11ULL, 0x000fe200018f3c2aULL,
0x00000001522a7824ULL, 0x000fe200078e0233ULL, 0x0000002834567810ULL, 0x000fc40007ffe0ffULL,
0x00005f002b277a11ULL, 0x000fe200010f3c30ULL, 0x00000001542b7824ULL, 0x100fe200078e0233ULL,
0x00005f0031257a11ULL, 0x000fe200008f3c32ULL, 0x0000000156307824ULL, 0x100fe200078e0233ULL,
0x0000002a37367210ULL, 0x040fe40007f3e0ffULL, 0x0000003034587810ULL, 0x040fe40007ffe0ffULL,
0x00000038345a7810ULL, 0x040fe40007ffe0ffULL, 0x0000003b3400720cULL, 0x000fe20003f46070ULL,
0x0000000158317824ULL, 0x100fe200078e0233ULL, 0x0000002b37347210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e06ffULL, 0x00005e00362a7a11ULL, 0x000fe200078238ffULL,
0x000000015a327824ULL, 0x000fe200078e0233ULL, 0x0000003037337210ULL, 0x000fc40007fde0ffULL,
0x0000003a3a307211ULL, 0x000fe400078fe8ffULL, 0x00005f00362b7a11ULL, 0x000fe200008f3c2bULL,
0x000000ffff4e7224ULL, 0x000fe200030e06ffULL, 0x0000003b4a00720cULL, 0x040fe20003f26070ULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x00000003304d7812ULL, 0x000fe400078ec0ffULL,
0x0000003137357210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x0000003237377210ULL, 0x000fc40007f7e0ffULL, 0x000010003c3c7811ULL, 0x000fe200078e60ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0ffffffc4d497812ULL, 0x100fe400078ef83aULL,
0xfffffffc3d3d7812ULL, 0x000fe400078ee23aULL, 0xfffffffc4a4b7812ULL, 0x000fe200078ee24dULL,
0x0000001049497824ULL, 0x000fe200078e023cULL, 0x00005e0034307a11ULL, 0x040fe200078a38ffULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078838ffULL,
0x000000103d247825ULL, 0x000fe200078e0024ULL, 0x00005f0034317a11ULL, 0x000fc400028f3c31ULL,
0x00005e0035347a11ULL, 0x000fe200078638ffULL, 0x000000104b4b7824ULL, 0x000fe200078e023cULL,
0x00005e0033327a11ULL, 0x000fe200078a38ffULL, 0x000000103d267825ULL, 0x000fe200078e0026ULL,
0x00005f0037377a11ULL, 0x000fe200020f3c4aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024497faeULL, 0x0003e2000d101c46ULL, 0x0000003b5600720cULL, 0x0c0fe20003f86070ULL,
0x0000000456567824ULL, 0x000fe200078e00ffULL, 0x00005f0035357a11ULL, 0x000fe200018f3c4cULL,
0x00000000264b7faeULL, 0x0005e2000c901c46ULL, 0x0000003b5000720cULL, 0x0c0fe20003f26070ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x0000003b5200720cULL, 0x040fe20003f46070ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x00005f0033337a11ULL, 0x000fc400028f3c4eULL,
0x0000003b5400720cULL, 0x0c0fe20003f66070ULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0x0000003b5800720cULL, 0x0c0fe20003fa6070ULL, 0x0000000458587824ULL, 0x000fe200078e00ffULL,
0x0000003b5a00720cULL, 0x040fe20003fc6070ULL, 0x000000045a5a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc56257812ULL, 0x002fe200078ee24dULL, 0x000000103d267825ULL, 0x044fe200078e002aULL,
0xfffffffc503b7812ULL, 0x100fe400078ee24dULL, 0xfffffffc52497812ULL, 0x000fe200078ee24dULL,
0x000000103d2a7825ULL, 0x000fe200078e0032ULL, 0xfffffffc544b7812ULL, 0x000fc400078ee24dULL,
0xfffffffc584f7812ULL, 0x100fe200078ee24dULL, 0x000000103b3b7824ULL, 0x100fe200078e023cULL,
0xfffffffc5a517812ULL, 0x000fe200078ee24dULL, 0x00000010254d7824ULL, 0x000fe400078e023cULL,
0x000000103d247825ULL, 0x000fc800078e0028ULL, 0x0000001049497824ULL, 0x100fe200078e023cULL,
0x00000000243b7faeULL, 0x0003e2000c901c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e023cULL,
0x000000103d287825ULL, 0x000fe200078e0030ULL, 0x0000000026497faeULL, 0x0003e6000d101c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e023cULL, 0x00000000284b7faeULL, 0x0003e2000d901c46ULL,
0x000000103d307825ULL, 0x000fc600078e0034ULL, 0x000000002a4d7faeULL, 0x0003e2000e101c46ULL,
0x0000001051517824ULL, 0x000fe400078e023cULL, 0x000000103d327825ULL, 0x000fe200078e0036ULL,
0x00000000304f7faeULL, 0x0003e8000e901c46ULL, 0x0000000032517faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x000000083a307811ULL, 0x042fe200078ff0ffULL,
0x0000000457537824ULL, 0x000fe200078e00ffULL, 0x000000333a247211ULL, 0x000fc400078ff0ffULL,
0x000000183a327811ULL, 0x000fe200078ff0ffULL, 0x0000000130257824ULL, 0x040fe200078e0233ULL,
0x0000002437297210ULL, 0x040fe20007f3e0ffULL, 0x00000004304c7824ULL, 0x000fe200078e00ffULL,
0x000000203a347811ULL, 0x000fe400078ff0ffULL, 0x0000002537277210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0029247a11ULL, 0x000fe200078238ffULL,
0x0000000434507824ULL, 0x000fe200078e00ffULL, 0x000000303a3c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x00005e0027267a11ULL, 0x000fc400078438ffULL,
0x00005f0029257a11ULL, 0x000fe200008f3c2aULL, 0x000000013c307824ULL, 0x000fe200078e0233ULL,
0x00005f0027277a11ULL, 0x000fe200010f3c28ULL, 0x0000000200287824ULL, 0x000fe200078e0243ULL,
0x0000003a3a297211ULL, 0x000fe200078fe8ffULL, 0x000000043c547824ULL, 0x000fe200078e00ffULL,
0x000000103a2a7811ULL, 0x000fe400078ff0ffULL, 0x0000000329357812ULL, 0x000fe200078ec0ffULL,
0x0000000132297824ULL, 0x100fe200078e0233ULL, 0x0000100028517811ULL, 0x000fe200078e60ffULL,
0x000000012a287824ULL, 0x000fe200078e0233ULL, 0x000000283a367811ULL, 0x000fe200078ff0ffULL,
0x0000000432327824ULL, 0x000fe200078e00ffULL, 0x000000383a4a7811ULL, 0x000fe200078ff0ffULL,
0x000000042a4e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc4c3c7812ULL, 0x000fe200078ee235ULL,
0x00000001342a7824ULL, 0x100fe200078e0233ULL, 0x0000002837347210ULL, 0x040fe20007f7e0ffULL,
0x00000001362b7824ULL, 0x000fe200078e0233ULL, 0xfffffffc324c7812ULL, 0x100fe200078ee235ULL,
0x0000000436527824ULL, 0x000fe200078e00ffULL, 0x0000002937327210ULL, 0x040fe20007f5e0ffULL,
0x000000044a567824ULL, 0x000fe200078e00ffULL, 0xfffffffc50507812ULL, 0x000fe200078ee235ULL,
0x000000014a317824ULL, 0x000fe200078e0233ULL, 0xfffffffc4e4a7812ULL, 0x000fe200078ee235ULL,
0x000000ffff297224ULL, 0x000fe200018e06ffULL, 0x0000002a374e7210ULL, 0x040fe20007f3e0ffULL,
0x000000104c497824ULL, 0x000fe200078e0251ULL, 0x0000002b37337210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0xfffffffc52527812ULL, 0x000fe200078ee235ULL,
0x000000104a3d7824ULL, 0x000fe200078e0251ULL, 0xfffffffc54547812ULL, 0x100fe200078ee235ULL,
0x000000ffff4c7224ULL, 0x000fe200018e06ffULL, 0xfffffffc56567812ULL, 0x000fe200078ee235ULL,
0x000000103c3b7824ULL, 0x100fe200078e0251ULL, 0x0ffffffc35367812ULL, 0x100fe200078ef83aULL,
0x00000010504b7824ULL, 0x100fe200078e0251ULL, 0x0000003037357210ULL, 0x040fe20007f9e0ffULL,
0x00000010524d7824ULL, 0x100fe200078e0251ULL, 0x00005e00322a7a11ULL, 0x000fe200078438ffULL,
0x0000001036557824ULL, 0x000fe200078e0251ULL, 0x00005e0034287a11ULL, 0x000fe200078c38ffULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x0000003137377210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x00005f00322b7a11ULL, 0x000fe200010f3c2bULL,
0x00000010544f7824ULL, 0x100fe200078e0251ULL, 0xfffffffc53537812ULL, 0x000fe200078ee23aULL,
0x000000ffff3c7224ULL, 0x000fe200028e06ffULL, 0x00005e004e307a11ULL, 0x000fe200078238ffULL,
0x0000001056517824ULL, 0x000fe200078e0251ULL, 0x00005f0034297a11ULL, 0x000fe200030f3c29ULL,
0x0000001053247825ULL, 0x000fe200078e0024ULL, 0x00005e0033327a11ULL, 0x000fc400078438ffULL,
0x00005e0035347a11ULL, 0x000fe200078638ffULL, 0x0000001053267825ULL, 0x000fe200078e0026ULL,
0x00005e0037367a11ULL, 0x000fe200078838ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024557faeULL, 0x0003e2000b901c46ULL, 0x00005f004e317a11ULL, 0x000fe200008f3c31ULL,
0x0000001053287825ULL, 0x000fe200078e0028ULL, 0x00005f0033337a11ULL, 0x000fe200010f3c4cULL,
0x00000000263b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0035357a11ULL, 0x000fe200018f3c4aULL,
0x00000010532a7825ULL, 0x000fe200078e002aULL, 0x00005f0037377a11ULL, 0x000fe200020f3c3cULL,
0x00000000283d7faeULL, 0x0003e4000b901c46ULL, 0x0000001053307825ULL, 0x000fc400078e0030ULL,
0x000000002a497faeULL, 0x0003e4000b901c46ULL, 0x0000001053327825ULL, 0x040fe400078e0032ULL,
0x00000000304b7faeULL, 0x0003e4000b901c46ULL, 0x0000001053347825ULL, 0x040fe400078e0034ULL,
0x00000000324d7faeULL, 0x0003e4000b901c46ULL, 0x0000001053367825ULL, 0x000fc400078e0036ULL,
0x00000000344f7faeULL, 0x0003e8000b901c46ULL, 0x0000000036517faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5700720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x000000022e2e7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff2d7424ULL, 0x000fc600078e00ffULL,
0x000000032e00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000023f247824ULL, 0x002fe400078e022eULL, 0x00000004ff257424ULL, 0x000fc800078e00ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000006242d7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff497224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83a257812ULL, 0x000fe200078ec0ffULL, 0x0000000200297824ULL, 0x020fe200078e0247ULL,
0x000000203a2b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000725257812ULL, 0x100fe400078ef83aULL, 0x0000100029297811ULL, 0x000fe400078e60ffULL,
0x00000001ff247819ULL, 0x000fe20000011625ULL, 0x0000000425277824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x00000001493b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000124267824ULL, 0x000fe200078e0249ULL,
0x000000072b2b7812ULL, 0x000fc400078ef83aULL, 0x000000073abf7812ULL, 0x000fe200078ec0ffULL,
0x0000000124247824ULL, 0x000fe200078e023bULL, 0xfffffffc27267812ULL, 0x000fe200078ee226ULL,
0x000000042b317824ULL, 0x040fe200078e00ffULL, 0x00000001ff287819ULL, 0x000fe2000001162bULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc25247812ULL, 0x000fe200078ee224ULL,
0x0000001026347824ULL, 0x000fe200078e0229ULL, 0x00000008bfd27812ULL, 0x000fe200078ef83aULL,
0x00000001282a7824ULL, 0x000fe400078e0249ULL, 0x0000001024247824ULL, 0x000fc400078e0229ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0xfffffffc312a7812ULL, 0x000fe200078ee22aULL,
0x00000010d2d47824ULL, 0x000fe400078e00ffULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x0000000128287824ULL, 0x000fe400078e023bULL, 0x000000102a2a7824ULL, 0x000fc600078e0229ULL,
0xfffffffc2b287812ULL, 0x000fe400078ee228ULL, 0x000000002a30783bULL, 0x000ee60000000200ULL,
0x0000001028287824ULL, 0x000fcc00078e0229ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000003400b67306ULL, 0x002fe20000009400ULL, 0x00000018ffac7819ULL, 0x000fe20000011434ULL,
0x0001000034507824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe20000011435ULL,
0x0001000035bd7824ULL, 0x040fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x004fe20000011427ULL,
0x0000010035c27824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe20000011450ULL,
0x0000003400b57306ULL, 0x000e620000005400ULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x0001000036b87824ULL, 0x040fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0001000031bf7824ULL, 0x008fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011431ULL,
0x0000010036af7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x0000003400687306ULL, 0x0004e2000000d400ULL, 0x0001000037ae7824ULL, 0x040fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011436ULL, 0x0000010037ab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0001000025877824ULL, 0x040fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x0000010025897824ULL, 0x000fe200078e00ffULL,
0x000000c300c47306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x004fe200078e00ffULL,
0x000000b5b600720bULL, 0x002fe20003f9d000ULL, 0x0001000030bb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011425ULL, 0x0001000026797824ULL, 0x040fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe20000011434ULL, 0x0000010026787824ULL, 0x000fe200078e00ffULL,
0x000000c300c57306ULL, 0x000e620000205400ULL, 0x00000018ff8d7819ULL, 0x000fe20000011437ULL,
0x0001000024827824ULL, 0x040fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000010024887824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fc400000114bbULL,
0x0000000168684812ULL, 0x008fe200078efcffULL, 0x000000c600c77306ULL, 0x000fe20000209400ULL,
0x00000018ff637819ULL, 0x000fe40000011426ULL, 0x00000018ffbf7819ULL, 0x000fe400000114bfULL,
0x00000018ff9f7819ULL, 0x000fe40000011430ULL, 0x00000018ff8e7819ULL, 0x000fe20000011433ULL,
0x000000c600c87306ULL, 0x000ea20000205400ULL, 0x000000c5c400720bULL, 0x002fe20003f5d000ULL,
0x0001000027c47824ULL, 0x040fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fe20000011432ULL,
0x0000010027c57824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc40000011482ULL,
0x00000018ff887819ULL, 0x000fe20000011488ULL, 0x000000bd00c97306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x000fe40000011424ULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x000000bd00ca7306ULL, 0x000e620000205400ULL, 0x000000c8c700720bULL, 0x004fc40003f7d000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff347819ULL, 0x000fe40000011428ULL,
0x00000018ff507819ULL, 0x000fe2000001142aULL, 0x0000003500b07306ULL, 0x000fe20000009400ULL,
0x00000018ff537819ULL, 0x000fce000001142bULL, 0x0000003500ad7306ULL, 0x000ea20000005400ULL,
0x000000cac900720bULL, 0x002fce0003fbd000ULL, 0x000000ac00b97306ULL, 0x000ff00000209400ULL,
0x000000ac00bc7306ULL, 0x0002e20000205400ULL, 0x000000adb000720bULL, 0x004fe40003f3d000ULL,
0x000000c600ad7245ULL, 0x000fc8000020d400ULL, 0x00000001adad3812ULL, 0x000fe200078efcffULL,
0x0000003600a67306ULL, 0x000fe20000009400ULL, 0x000000ac00ac7245ULL, 0x002fce000020d400ULL,
0x0000003600a57306ULL, 0x000fe20000005400ULL, 0x000000bcb900720bULL, 0x008fce0003fdd000ULL,
0x000000c200cb7306ULL, 0x000fec0000209400ULL, 0x00000001acac6812ULL, 0x000fe400078efcffULL,
0x000000c200cc7306ULL, 0x000e700000205400ULL, 0x0000003100847306ULL, 0x000ff00000009400ULL,
0x0000003100817306ULL, 0x000fe20000005400ULL, 0x000000cccb00720bULL, 0x002fce0003f7d000ULL,
0x00000031005e7306ULL, 0x0003f0000000d400ULL, 0x000000a400b37306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x002fce00078e00ffULL, 0x000000a400ba7306ULL, 0x000e700000205400ULL,
0x000000b800cd7306ULL, 0x000ff00000209400ULL, 0x000000b800ce7306ULL, 0x000fe20000205400ULL,
0x000000bab300720bULL, 0x002fe20003f9d000ULL, 0x0001000032b37824ULL, 0x000fca00078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000003700a37306ULL, 0x000ff00000009400ULL,
0x0000003700a27306ULL, 0x000e700000005400ULL, 0x0000002700697306ULL, 0x000ff00000009400ULL,
0x00000027006a7306ULL, 0x000fe20000005400ULL, 0x000000a2a300720bULL, 0x002fc40003fdd000ULL,
0x000000c200a27245ULL, 0x000fe4000020d400ULL, 0x000000b800a37245ULL, 0x000fe4000020d400ULL,
0x00000001a2a23812ULL, 0x000fe200078efcffULL, 0x00000027004d7306ULL, 0x0003f0000000d400ULL,
0x0000003500677306ULL, 0x0004e2000000d400ULL, 0x00000018ff277819ULL, 0x002fc40000011431ULL,
0x000000c300317245ULL, 0x000fc8000020d400ULL, 0x0000000131312812ULL, 0x000fe200078efcffULL,
0x0000002400a07306ULL, 0x000fe20000009400ULL, 0x000000a5a600720bULL, 0x000fe40003f5d000ULL,
0x000000bd00a67245ULL, 0x000fe4000020d400ULL, 0x00000018ff357819ULL, 0x004fe40000011429ULL,
0x00000001a6a65812ULL, 0x000fe200078efcffULL, 0x0000002400a17306ULL, 0x000e620000005400ULL,
0x000000cecd00720bULL, 0x000fc40003fbd000ULL, 0x0000000167671812ULL, 0x008fe400078efcffULL,
0x000000683168723eULL, 0x000fc600000010ffULL, 0x000000af00c17306ULL, 0x000fec0000209400ULL,
0x00000001a3a35812ULL, 0x000fe400078efcffULL, 0x000000af00be7306ULL, 0x0004e20000205400ULL,
0x000000a1a000720bULL, 0x002fe40003f3d000ULL, 0x000000a400a17245ULL, 0x000fc8000020d400ULL,
0x00000001a1a14812ULL, 0x000fe200078efcffULL, 0x00000025006d7306ULL, 0x000fe20000009400ULL,
0x000000af00af7245ULL, 0x004fe4000020d400ULL, 0x000000a2a1a1723eULL, 0x000fca00000010ffULL,
0x0000002500707306ULL, 0x000fe20000005400ULL, 0x000000bec100720bULL, 0x008fce0003f7d000ULL,
0x00000025003d7306ULL, 0x0003ec000000d400ULL, 0x00000001afaf3812ULL, 0x000fe400078efcffULL,
0x0000009a00a77306ULL, 0x000fe20000209400ULL, 0x0000000448257824ULL, 0x002fe200078e0249ULL,
0x0000000249497810ULL, 0x000fc60007ffe0ffULL, 0x0000000225257824ULL, 0x000fc600078e00ffULL,
0x0000009a00aa7306ULL, 0x0002a40000205400ULL, 0x0000000225d37810ULL, 0x000fe40007ffe0ffULL,
0x000000253a257211ULL, 0x040fe400078fe0ffULL, 0x000000d33ad37211ULL, 0x000fe400078fe0ffULL,
0x000000ae00b47306ULL, 0x000fe20000209400ULL, 0x00000001d2257824ULL, 0x000fe200078e0225ULL,
0x0000009a009a7245ULL, 0x002fc8000020d400ULL, 0xfffffff0d4257812ULL, 0x000fe400078ee225ULL,
0x000000ae00b77306ULL, 0x000e620000205400ULL, 0x000000aaa700720bULL, 0x004fe20003f9d000ULL,
0x0001000033a77824ULL, 0x040fe400078e00ffULL, 0x0000010033aa7824ULL, 0x000fe400078e00ffULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x0000003600647306ULL, 0x000ea2000000d400ULL, 0x00000018ffaa7819ULL, 0x000fca00000114aaULL,
0x000000019a9a4812ULL, 0x000fe400078efcffULL, 0x0000008d009c7306ULL, 0x000fe20000209400ULL,
0x000000b7b400720bULL, 0x002fce0003fbd000ULL, 0x0000008d00977306ULL, 0x000e620000205400ULL,
0x0000000164642812ULL, 0x004fce00078efcffULL, 0x000000ab00b27306ULL, 0x000ff00000209400ULL,
0x000000ab00b17306ULL, 0x0004e20000205400ULL, 0x000000979c00720bULL, 0x002fce0003f5d000ULL,
0x00000026006e7306ULL, 0x000fe20000009400ULL, 0x000000ab00ab7245ULL, 0x004fce000020d400ULL,
0x00000026006b7306ULL, 0x000fe20000005400ULL, 0x000000b1b200720bULL, 0x008fce0003f7d000ULL,
0x00000026003c7306ULL, 0x0003ec000000d400ULL, 0x00000001abab3812ULL, 0x000fe400078efcffULL,
0x0000003000907306ULL, 0x000fe20000009400ULL, 0x0000010030267824ULL, 0x002fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000030008f7306ULL, 0x000ff00000005400ULL,
0x000000bb00cf7306ULL, 0x000ff00000209400ULL, 0x000000bb00d07306ULL, 0x000e700000205400ULL,
0x00000030005f7306ULL, 0x0005f0000000d400ULL, 0x000000bf00b57306ULL, 0x000fe20000205400ULL,
0x00000001d2307824ULL, 0x044fe200078e02d3ULL, 0x000000d0cf00720bULL, 0x002fe20003f9d000ULL,
0x00000010d2d37824ULL, 0x000fca00078e00ffULL, 0x000000bf00d27306ULL, 0x000fe20000209400ULL,
0xfffffff0d3307812ULL, 0x000fce00078ee230ULL, 0x0000002600c07306ULL, 0x000ff00000209400ULL,
0x0000002600d17306ULL, 0x000e700000205400ULL, 0x00000033007b7306ULL, 0x000ff00000009400ULL,
0x00000033007c7306ULL, 0x000fe20000005400ULL, 0x000000d1c000720bULL, 0x002fce0003f7d000ULL,
0x00000033005a7306ULL, 0x0003f0000000d400ULL, 0x0000003700607306ULL, 0x000ea2000000d400ULL,
0x000000ae00337245ULL, 0x002fc8000020d400ULL, 0x0000000133335812ULL, 0x000fe400078efcffULL,
0x0000008f9000720bULL, 0x000fe20003fbd000ULL, 0x0000002700b07306ULL, 0x000fe20000209400ULL,
0x0000008d00907245ULL, 0x000fc8000020d400ULL, 0x0000000190902812ULL, 0x000fe400078efcffULL,
0x000000b5d200720bULL, 0x000fe20003f5d000ULL, 0x0000002700a57306ULL, 0x000e620000205400ULL,
0x0000000160606812ULL, 0x004fe400078efcffULL, 0x000000ab90ab723eULL, 0x000fe400000010ffULL,
0x000000015f5f5812ULL, 0x000fc600078efcffULL, 0x0000009f00a87306ULL, 0x000ff00000209400ULL,
0x0000009f00a97306ULL, 0x0004e20000205400ULL, 0x000000a5b000720bULL, 0x002fce0003fbd000ULL,
0x00000032007f7306ULL, 0x000fe20000009400ULL, 0x0000009f009f7245ULL, 0x004fce000020d400ULL,
0x0000003200807306ULL, 0x000fe20000005400ULL, 0x000000a9a800720bULL, 0x008fce0003fdd000ULL,
0x00000032005d7306ULL, 0x0003ec000000d400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000b300b67306ULL, 0x000fe20000209400ULL, 0x0000010032327824ULL, 0x002fca00078e00ffULL,
0x00000018ffa07819ULL, 0x000fe40000011432ULL, 0x000000b300b97306ULL, 0x000e620000205400ULL,
0x000000bb00327245ULL, 0x000fc8000020d400ULL, 0x0000000132324812ULL, 0x000fe400078efcffULL,
0x000000818400720bULL, 0x000fe20003f9d000ULL, 0x0000009600997306ULL, 0x000fe20000209400ULL,
0x000000bf00817245ULL, 0x000fe4000020d400ULL, 0x0000002600847245ULL, 0x000fe4000020d400ULL,
0x0000000181812812ULL, 0x000fe400078efcffULL, 0x0000000184843812ULL, 0x000fe200078efcffULL,
0x0000009600987306ULL, 0x0004e20000205400ULL, 0x000000b9b600720bULL, 0x002fc40003f5d000ULL,
0x000000807f00720bULL, 0x000fe40003f7d000ULL, 0x0000002700807245ULL, 0x000fe4000020d400ULL,
0x000000015e5e4812ULL, 0x000fe200078efcffULL, 0x0000009b009d7306ULL, 0x000fe20000209400ULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x0000009600967245ULL, 0x004fe4000020d400ULL,
0x00000018ff7f7819ULL, 0x000fc400000114c4ULL, 0x0000005f3232723eULL, 0x000fe200000010ffULL,
0x0000009b009e7306ULL, 0x0002a20000205400ULL, 0x000000989900720bULL, 0x008fe40003fbd000ULL,
0x000000b300987245ULL, 0x000fe4000020d400ULL, 0x000000015d5d3812ULL, 0x000fe400078efcffULL,
0x0000000198982812ULL, 0x000fe200078efcffULL, 0x000000a7008f7306ULL, 0x000fe20000209400ULL,
0x0000007c7b00720bULL, 0x000fc40003f5d000ULL, 0x0000009b009b7245ULL, 0x002fe4000020d400ULL,
0x000000a000997245ULL, 0x000fe4000020d400ULL, 0x0000000196965812ULL, 0x000fe200078efcffULL,
0x000000a7009c7306ULL, 0x0002e20000205400ULL, 0x0000009e9d00720bULL, 0x004fe40003fdd000ULL,
0x0000006b6e00720bULL, 0x000fe40003fbd000ULL, 0x000000aa006b7245ULL, 0x000fc4000020d400ULL,
0x000000015a5a2812ULL, 0x000fe200078efcffULL, 0x000000aa00267306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x002fe4000020d400ULL, 0x0000005e815e723eULL, 0x000fe400000010ffULL,
0x0000005d9898723eULL, 0x000fe400000010ffULL, 0x000000019b9b6812ULL, 0x000fe200078efcffULL,
0x000000aa008d7306ULL, 0x0002a20000205400ULL, 0x0000009c8f00720bULL, 0x008fe20003fdd000ULL,
0x000001002a8f7824ULL, 0x000fe200078e00ffULL, 0x000000013c3c5812ULL, 0x000fc400078efcffULL,
0x000000809b5f723eULL, 0x000fe400000010ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001148fULL,
0x0000008200927306ULL, 0x000fe20000209400ULL, 0x0000006033aa723eULL, 0x002fe400000010ffULL,
0x000000849f33723eULL, 0x000fc600000010ffULL, 0x00000001a7a76812ULL, 0x000fe400078efcffULL,
0x0000008200957306ULL, 0x0002e20000205400ULL, 0x0000008d2600720bULL, 0x004fce0003f7d000ULL,
0x000000a000a47306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x002fca000020d400ULL,
0x000000016b6b3812ULL, 0x000fe400078efcffULL, 0x000000a000977306ULL, 0x0002a20000205400ULL,
0x000000959200720bULL, 0x008fce0003f5d000ULL, 0x00000024004f7306ULL, 0x000ee2000000d400ULL,
0x00000067a6a0723eULL, 0x002fca00000010ffULL, 0x0000000182822812ULL, 0x000fe400078efcffULL,
0x0000008e00937306ULL, 0x000fe20000209400ULL, 0x00000097a400720bULL, 0x004fce0003f9d000ULL,
0x0000008e00947306ULL, 0x0002a20000205400ULL, 0x000000014f4f1812ULL, 0x008fc800078efcffULL,
0x0000004f8282723eULL, 0x000fe400000010ffULL, 0x0000000199994812ULL, 0x000fe200078efcffULL,
0x0000008800917306ULL, 0x000fe20000209400ULL, 0x000000706d00720bULL, 0x000fe20003f9d000ULL,
0x0001000028707824ULL, 0x000fe200078e00ffULL, 0x0000008e008e7245ULL, 0x002fe4000020d400ULL,
0x00000018ff6d7819ULL, 0x000fe400000114c5ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000008800247306ULL, 0x0002e20000205400ULL, 0x000000949300720bULL, 0x004fc40003fdd000ULL,
0x000000999699723eULL, 0x000fc600000010ffULL, 0x000000013d3d4812ULL, 0x000fe400078efcffULL,
0x0000007700717306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fca000020d400ULL,
0x000000018e8e6812ULL, 0x000fe400078efcffULL, 0x0000007700727306ULL, 0x0002a20000205400ULL,
0x000000249100720bULL, 0x008fe20003f7d000ULL, 0x000100002b917824ULL, 0x000fe200078e00ffULL,
0x000000002524783bULL, 0x000ee20000000200ULL, 0x0000006a6900720bULL, 0x000fe40003fdd000ULL,
0x00000087006a7245ULL, 0x000fe4000020d400ULL, 0x0000008700857306ULL, 0x000fe20000209400ULL,
0x0000007700777245ULL, 0x002fc4000020d400ULL, 0x000000adac69723eULL, 0x000fe400000010ffULL,
0x0000006b8e31723eULL, 0x000fe400000010ffULL, 0x0000000188883812ULL, 0x000fe200078efcffULL,
0x00000087008a7306ULL, 0x0002620000205400ULL, 0x000000727100720bULL, 0x004fe40003f5d000ULL,
0x000000014d4d6812ULL, 0x000fe400078efcffULL, 0x00000018ff917819ULL, 0x000fc60000011491ULL,
0x0000006c00747306ULL, 0x000fe20000209400ULL, 0x000001002b877824ULL, 0x002fca00078e00ffULL,
0x0000000177772812ULL, 0x000fe400078efcffULL, 0x0000006c006f7306ULL, 0x0002a20000205400ULL,
0x0000008a8500720bULL, 0x000fe20003f3d000ULL, 0x00010000298a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fc80000011487ULL, 0x00000018ff8a7819ULL, 0x000fe2000001148aULL,
0x00000089008b7306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fe2000020d400ULL,
0x000000322410723cULL, 0x008be80000041810ULL, 0x000000016a6a1812ULL, 0x000fe400078efcffULL,
0x00000089008c7306ULL, 0x0002e20000205400ULL, 0x0000006f7400720bULL, 0x004fc40003f5d000ULL,
0x0000007f00327245ULL, 0x020fe2000020d400ULL, 0x000000682418723cULL, 0x000f620000041818ULL,
0x0000006d00337245ULL, 0x000fe4000020d400ULL, 0x0000003d6a6a723eULL, 0x000fe200000010ffULL,
0x0000006300767306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fc6000020d400ULL,
0x000000a02420723cULL, 0x040fe40000041820ULL, 0x000000016c6c2812ULL, 0x000fe400078efcffULL,
0x0000006300737306ULL, 0x0002a20000205400ULL, 0x0000008c8b00720bULL, 0x008fe20003f7d000ULL,
0x00000100298b7824ULL, 0x000fe400078e00ffULL, 0x000100002a8c7824ULL, 0x000fe200078e00ffULL,
0x000000aa2414723cULL, 0x000f640000041814ULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x0000007900837306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x002fc4000020d400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001148cULL, 0x0000005e240c723cULL, 0x040fe2000004180cULL,
0x0000000189893812ULL, 0x000fe400078efcffULL, 0x0000007900867306ULL, 0x0002e20000205400ULL,
0x000000737600720bULL, 0x004fe40003f3d000ULL, 0x000000896c6b723eULL, 0x000fe400000010ffULL,
0x000000982408723cULL, 0x000fe60000041808ULL, 0x00000078007d7306ULL, 0x000fe20000209400ULL,
0x0000007900797245ULL, 0x002fca000020d400ULL, 0x0000000163631812ULL, 0x000fe400078efcffULL,
0x00000078007e7306ULL, 0x0002a20000205400ULL, 0x000000868300720bULL, 0x008fe40003f7d000ULL,
0x000000887783723eULL, 0x000fca00000010ffULL, 0x00000070008d7306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fca000020d400ULL, 0x0000000179793812ULL, 0x000fe400078efcffULL,
0x0000007000727306ULL, 0x0002e20000205400ULL, 0x0000007e7d00720bULL, 0x004fe40003f5d000ULL,
0x0000003c793c723eULL, 0x000fca00000010ffULL, 0x0000007f00977306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fca000020d400ULL, 0x0000000178782812ULL, 0x000fe400078efcffULL,
0x0000007f007c7306ULL, 0x000e620000205400ULL, 0x000000728d00720bULL, 0x008fe40003fbd000ULL,
0x0000008f008d7245ULL, 0x000fe4000020d400ULL, 0x00000078633d723eULL, 0x000fc600000010ffULL,
0x0000002800757306ULL, 0x000fec0000009400ULL, 0x0000000170705812ULL, 0x000fe400078efcffULL,
0x00000028007a7306ULL, 0x000ea20000005400ULL, 0x0000007c9700720bULL, 0x002fce0003f3d000ULL,
0x00000028003b7306ULL, 0x0002ec000000d400ULL, 0x0000000132321812ULL, 0x000fe400078efcffULL,
0x0000002900667306ULL, 0x000fe20000009400ULL, 0x0000010028287824ULL, 0x002fe200078e00ffULL,
0x0000007a7500720bULL, 0x004fc40003f9d000ULL, 0x0000004d3232723eULL, 0x000fe400000010ffULL,
0x00000018ff717819ULL, 0x000fe40000011428ULL, 0x0000002900657306ULL, 0x000e620000005400ULL,
0x00000064a328723eULL, 0x000fe400000010ffULL, 0x0000008b004d7245ULL, 0x000fc8000020d400ULL,
0x000000013b3b4812ULL, 0x008fe200078efcffULL, 0x0000002a00627306ULL, 0x000fe60000009400ULL,
0x0000003b7070723eULL, 0x000fca00000010ffULL, 0x0000002a00617306ULL, 0x000ea20000005400ULL,
0x000000656600720bULL, 0x002fce0003f7d000ULL, 0x0000007100857306ULL, 0x000ff00000209400ULL,
0x0000007100747306ULL, 0x0002e20000205400ULL, 0x000000616200720bULL, 0x004fce0003f5d000ULL,
0x0000004e00567306ULL, 0x000fe20000209400ULL, 0x0000007100717245ULL, 0x002fce000020d400ULL,
0x0000004e00597306ULL, 0x0002a20000205400ULL, 0x000000748500720bULL, 0x008fce0003fbd000ULL,
0x00000034005b7306ULL, 0x000fe20000209400ULL, 0x0000004e004e7245ULL, 0x002fca000020d400ULL,
0x0000000171715812ULL, 0x000fe400078efcffULL, 0x00000034005c7306ULL, 0x0002e20000205400ULL,
0x000000595600720bULL, 0x004fce0003f3d000ULL, 0x0000006d006e7306ULL, 0x000fe20000209400ULL,
0x0000003400347245ULL, 0x002fca000020d400ULL, 0x000000014e4e1812ULL, 0x000fe400078efcffULL,
0x0000006d007b7306ULL, 0x000e620000205400ULL, 0x0000005c5b00720bULL, 0x008fce0003fdd000ULL,
0x00000029004c7306ULL, 0x0004ec000000d400ULL, 0x0000000134346812ULL, 0x000fe400078efcffULL,
0x0000002b00587306ULL, 0x000fe20000009400ULL, 0x000000af9a29723eULL, 0x004fe400000010ffULL,
0x0000007b6e00720bULL, 0x002fc40003f9d000ULL, 0x000000713471723eULL, 0x000fc600000010ffULL,
0x0000002b00577306ULL, 0x000e620000005400ULL, 0x00000028241c723cULL, 0x000b62000004181cULL,
0x000000014c4c3812ULL, 0x008fcc00078efcffULL, 0x0000003500367306ULL, 0x000fe20000209400ULL,
0x0000001030287824ULL, 0x020fe200078e00ffULL, 0x0000005aa730723eULL, 0x000fe400000010ffULL,
0x0000000133334812ULL, 0x000fc800078efcffULL, 0x0000003500377306ULL, 0x000ea20000205400ULL,
0x000000575800720bULL, 0x002fe20003fbd000ULL, 0x000000302404723cULL, 0x000b620000041804ULL,
0x000000334e33723eULL, 0x000fca00000010ffULL, 0x0000008a006f7306ULL, 0x000fe20000209400ULL,
0x0000003500247245ULL, 0x020fe4000020d400ULL, 0x0000008a00257245ULL, 0x000fca000020d400ULL,
0x0000008a00647306ULL, 0x000e620000205400ULL, 0x000000373600720bULL, 0x004fce0003f3d000ULL,
0x0000008b00657306ULL, 0x000fec0000209400ULL, 0x0000000124241812ULL, 0x000fe400078efcffULL,
0x0000008b00607306ULL, 0x000ea20000205400ULL, 0x000000646f00720bULL, 0x002fce0003f9d000ULL,
0x0000008c00617306ULL, 0x000fec0000209400ULL, 0x0000000125254812ULL, 0x000fe400078efcffULL,
0x0000008c00627306ULL, 0x0002e20000205400ULL, 0x000000606500720bULL, 0x004fe40003fdd000ULL,
0x0000004c254c723eULL, 0x000fca00000010ffULL, 0x0000008f005d7306ULL, 0x000fe20000209400ULL,
0x0000008c008c7245ULL, 0x002fca000020d400ULL, 0x000000014d4d6812ULL, 0x000fe400078efcffULL,
0x0000008f00567306ULL, 0x000e620000205400ULL, 0x000000626100720bULL, 0x008fe40003f7d000ULL,
0x0000004d244d723eULL, 0x000fe400000010ffULL, 0x0000005300247245ULL, 0x000fc6000020d400ULL,
0x0000002a004b7306ULL, 0x000eac000000d400ULL, 0x000000018c8c3812ULL, 0x000fe400078efcffULL,
0x0000002b004a7306ULL, 0x0006a2000000d400ULL, 0x000000565d00720bULL, 0x002fce0003f3d000ULL,
0x0000005000517306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x008e620000000200ULL,
0x000000014b4b2812ULL, 0x004fc800078efcffULL, 0x0000004b8c8c723eULL, 0x000fe400000010ffULL,
0x0000005000527306ULL, 0x0004e20000205400ULL, 0x00000087004b7245ULL, 0x000fe4000020d400ULL,
0x000000018d8d1812ULL, 0x000fe400078efcffULL, 0x000000044900780cULL, 0x000fe40003f25270ULL,
0x000000014a4a5812ULL, 0x000fe200078efcffULL, 0x0000005300547306ULL, 0x000fe20000209400ULL,
0x0000005000507245ULL, 0x004fce000020d400ULL, 0x0000005300557306ULL, 0x000ea20000205400ULL,
0x000000525100720bULL, 0x008fce0003f9d000ULL, 0x0000009100577306ULL, 0x000fec0000209400ULL,
0x0000000150504812ULL, 0x000fe400078efcffULL, 0x0000009100267306ULL, 0x0006e20000205400ULL,
0x000000555400720bULL, 0x004fe20003fdd000ULL, 0x000000822818723cULL, 0x002b620000041818ULL,
0x0000008d508d723eULL, 0x000fca00000010ffULL, 0x0000008700277306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x008fe2000020d400ULL, 0x000000322814723cULL, 0x040b680000041814ULL,
0x0000000124246812ULL, 0x000fe400078efcffULL, 0x0000008700307306ULL, 0x000e620000205400ULL,
0x000000265700720bULL, 0x000fe20003f7d000ULL, 0x0000006a2820723cULL, 0x040b700000041820ULL,
0x0000003c281c723cULL, 0x000b68000004181cULL, 0x0000000191913812ULL, 0x000fc400078efcffULL,
0x000000302700720bULL, 0x002fe40003f5d000ULL, 0x0000004a914a723eULL, 0x000fe200000010ffULL,
0x000000702810723cULL, 0x040b700000041810ULL, 0x0000004c280c723cULL, 0x000b64000004180cULL,
0x000000014b4b2812ULL, 0x000fc800078efcffULL, 0x0000004b244b723eULL, 0x000fe400000010ffULL,
0x0000008c2808723cULL, 0x040b700000041808ULL, 0x0000004a2804723cULL, 0x000b620000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff477224ULL, 0x000fe200078e0043ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd1f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000003e16287220ULL, 0x0a0fe20000410000ULL,
0x0000003e1a247220ULL, 0x080fe20000410000ULL, 0x0000003e17297220ULL, 0x080fe20000410000ULL,
0x0000003e10167220ULL, 0x080fe20000410000ULL, 0x0000003e18187220ULL, 0x080fe20000410000ULL,
0x0000003e19197220ULL, 0x080fe20000410000ULL, 0x0000003e1b257220ULL, 0x080fe20000410000ULL,
0x0000003e11177220ULL, 0x080fe20000410000ULL, 0x0000003e0c1a7220ULL, 0x080fe20000410000ULL,
0x0000003e20207220ULL, 0x080fe20000410000ULL, 0x0000003e21217220ULL, 0x080fe20000410000ULL,
0x0000003e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003e14147220ULL, 0x080fe20000410000ULL, 0x0000003e15157220ULL, 0x080fe20000410000ULL,
0x0000003e0d1b7220ULL, 0x080fe20000410000ULL, 0x0000003e08087220ULL, 0x080fe20000410000ULL,
0x0000003e09097220ULL, 0x080fe20000410000ULL, 0x0000003e04047220ULL, 0x080fe20000410000ULL,
0x0000003e122a7220ULL, 0x080fe20000410000ULL, 0x0000003e132b7220ULL, 0x080fe20000410000ULL,
0x0000003e0a327220ULL, 0x080fe20000410000ULL, 0x0000003e0b337220ULL, 0x080fe20000410000ULL,
0x000000ffff127224ULL, 0x000fe200078e0016ULL, 0x0000003e0e307220ULL, 0x080fe20000410000ULL,
0x0000003e0f317220ULL, 0x080fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0018ULL,
0x0000003e22227220ULL, 0x080fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0019ULL,
0x0000003e23237220ULL, 0x080fe20000410000ULL, 0x000000ffff137224ULL, 0x000fe200078e0017ULL,
0x0000003e1e267220ULL, 0x080fe20000410000ULL, 0x000000ffff167224ULL, 0x000fe200078e001aULL,
0x0000003e1f277220ULL, 0x080fe20000410000ULL, 0x0000003e05057220ULL, 0x080fe20000410000ULL,
0x0000003e06067220ULL, 0x080fe20000410000ULL, 0x0000003e07077220ULL, 0x000fe20000410000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0020ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0021ULL,
0x000000ffff0e7224ULL, 0x000fe400078e001cULL, 0x000000ffff0f7224ULL, 0x000fe400078e001dULL,
0x000000ffff107224ULL, 0x000fe400078e0014ULL, 0x000000ffff117224ULL, 0x000fe400078e0015ULL,
0x000000ffff177224ULL, 0x000fc400078e001bULL, 0x000000ffff187224ULL, 0x000fe400078e0008ULL,
0x000000ffff197224ULL, 0x000fe400078e0009ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000040087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0024ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0022ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0023ULL,
0x000000ffff207224ULL, 0x000fe400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e0028ULL, 0x000000ffff237224ULL, 0x000fe400078e0029ULL,
0x000000ffff247224ULL, 0x000fc400078e002aULL, 0x000000ffff257224ULL, 0x000fe400078e002bULL,
0x000000ffff1b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff267224ULL, 0x000fe400078e0030ULL,
0x000000ffff277224ULL, 0x000fe400078e0031ULL, 0x000000ffff287224ULL, 0x000fe400078e0032ULL,
0x000000ffff297224ULL, 0x000fc400078e0033ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040040077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604157210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040040077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000043a157824ULL, 0x000fe200078e00ffULL, 0x000000414400720cULL, 0x000fc80003f05270ULL,
0xfffffff015057812ULL, 0x000fca00078ec0ffULL, 0x0000008000147824ULL, 0x000fca00078e0205ULL,
0x00f4000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000023a087824ULL, 0x000fe400078e00ffULL, 0x0000000102457824ULL, 0x000fc600078e0a45ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108307812ULL, 0x040fe400078efcffULL,
0x0000000808327812ULL, 0x000fe400078efcffULL, 0x000000453000720cULL, 0x080fe40003f26070ULL,
0x0000001008307812ULL, 0x000fe400078efcffULL, 0x000000453200720cULL, 0x080fe40003f06070ULL,
0x000000453000720cULL, 0x000fc40003fc6070ULL, 0x0000001108327812ULL, 0x040fe400078efcffULL,
0x0000001808307812ULL, 0x040fe400078efcffULL, 0x000000450800720cULL, 0x080fe40003f46070ULL,
0x000000453200720cULL, 0x080fe40003fa6070ULL, 0x000000453000720cULL, 0x000fe40003f66070ULL,
0x0000000908347812ULL, 0x000fc400078efcffULL, 0x0000001908327812ULL, 0x040fe400078efcffULL,
0x0000002008307812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x000000453400720cULL, 0x080fe40003f86070ULL,
0x000000453200720cULL, 0x080fe40003f46070ULL, 0x000000453000720cULL, 0x000fe40003f26070ULL,
0x0000002108327812ULL, 0x040fe400078efcffULL, 0x0000002808307812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000453200720cULL, 0x080fe40003f06070ULL, 0x000000453000720cULL, 0x000fe40003f86070ULL,
0x0000002908327812ULL, 0x000fc400078efcffULL, 0x0000003008307812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000453200720cULL, 0x000fc40003fc6070ULL, 0x000000453000720cULL, 0x000fe40003fa6070ULL,
0x0000003108327812ULL, 0x040fe400078efcffULL, 0x0000003808307812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000024247808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000453200720cULL, 0x080fe40003f66070ULL,
0x000000453000720cULL, 0x000fc40003f46070ULL, 0x000000450800720cULL, 0x000fe40003f26070ULL,
0xff80000025257808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000028287808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff80000029297808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000002a2a7808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000002b2b7808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff367424ULL, 0x000fe200078e00ffULL,
0x0000001c0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000090c047208ULL, 0x000fe40004000000ULL, 0x000000051e087208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x000000040d057208ULL, 0x000fe40004000000ULL, 0x000000081f097208ULL, 0x000fc40004800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fc40003f3e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x0000000821097208ULL, 0x000fe40004800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fe40003f3e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x0000000922087208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fe40004800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000240900720bULL, 0x000fc40003f3e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x0000000924087208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000250800720bULL, 0x000fe40003f3e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x0000000825097208ULL, 0x000fc40004800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fe40003f3e000ULL,
0x0000000516047208ULL, 0x000fe40004000000ULL, 0x0000000926087208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fc40003f3e000ULL,
0x0000000417057208ULL, 0x000fe40004000000ULL, 0x0000000827097208ULL, 0x000fe40004800000ULL,
0x000000180500720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x0000000518047208ULL, 0x000fe40004000000ULL, 0x0000000928087208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x000000290800720bULL, 0x000fe40003f3e000ULL,
0x0000000419057208ULL, 0x000fe40004000000ULL, 0x0000000829097208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fc40003f3e000ULL,
0x000000051a047208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x000000041b327208ULL, 0x000fe40004000000ULL, 0x000000082b347208ULL, 0x000fe20004800000ULL,
0x000015327f007947ULL, 0x000fec000b800000ULL, 0x0c401f0032047f89ULL, 0x0004e400000e0000ULL,
0x000000043200720bULL, 0x008fc80003f1e000ULL, 0x0000003204357208ULL, 0x000fe20004000000ULL,
0x000015427f007947ULL, 0x000fea000b800000ULL, 0x0c401f0034047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000e6800000e0000ULL, 0x0c401f0007307f89ULL, 0x000ea200000e0000ULL,
0x000000043400720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x002fe40003f3e000ULL,
0x0000003404087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f0035047f89ULL, 0x000e6200000e0000ULL, 0x000000300700720bULL, 0x004fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000ea200000e0000ULL, 0x0000000730307208ULL, 0x000fc60004000000ULL,
0x0c201f0009327f89ULL, 0x000ee800000e0000ULL, 0x0c201f0030317f89ULL, 0x0002e400000e0000ULL,
0x000000043500720bULL, 0x002fe40003f1e000ULL, 0x000000050800720bULL, 0x004fe40003f3e000ULL,
0x0000003504047208ULL, 0x000fc40004000000ULL, 0x000000320900720bULL, 0x008fe40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x0000000932067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05327820ULL, 0x002fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x00000002ff337819ULL, 0x000fe2000001163aULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010832ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x00000004ff367e24ULL, 0x000fe2000f8e00ffULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3f8000003636783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010832ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b22227823ULL, 0x000fe20000010832ULL, 0x000000ffff377224ULL, 0x000fe200078e0036ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010832ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1b077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010832ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x000fe20000010832ULL,
0x0000000833327824ULL, 0x040fe200078e00ffULL, 0x000000033aff7812ULL, 0x000fe2000780c0ffULL,
0x0000000833357824ULL, 0x040fe200078e00ffULL, 0x000000313000720bULL, 0x004fe20003f3e000ULL,
0x00000008333b7824ULL, 0x000fc400078e00ffULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000010ffULL, 0x0000001e000b7308ULL, 0x000ff00000000800ULL,
0x0000001f00347308ULL, 0x000ea20000000800ULL, 0x0000001c1d09723eULL, 0x002fce00000010ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b340b723eULL, 0x004fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x00000036081c723cULL, 0x000f6e00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fe400000010ffULL,
0x0000000133107810ULL, 0x000fca0007ffe0ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x00000020210d723eULL, 0x002fe200000010ffULL,
0x0000000833217824ULL, 0x040fe200078e00ffULL, 0x0000000433207810ULL, 0x000fc80007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000022230f723eULL, 0x004fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000000833237824ULL, 0x040fe400078e00ffULL, 0x0000000833227824ULL, 0x000fe200078e00ffULL,
0x000000360c1c723cULL, 0x020f68000004181cULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x000000161712723eULL, 0x004fe400000010ffULL, 0x0000000233167810ULL, 0x000fc40007ffe0ffULL,
0x0000000333177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee216ULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000242511723eULL, 0x002fc400000010ffULL, 0xfffffff822257812ULL, 0x000fe400078ee217ULL,
0x0000000633227810ULL, 0x040fe40007ffe0ffULL, 0xffffffff33247810ULL, 0x000fe20007ffe0ffULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0xfffffff832177812ULL, 0x000fe400078ee233ULL,
0x000000262713723eULL, 0x004fca00000010ffULL, 0x0000001900197308ULL, 0x000e620000000800ULL,
0x0000000833277824ULL, 0x040fe200078e00ffULL, 0x0000000833267810ULL, 0x000fe20007ffe0ffULL,
0x00000036101c723cULL, 0x020b66000004181cULL, 0xfffffff827277812ULL, 0x000fe400078ee220ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000000533207810ULL, 0x000fe20007ffe0ffULL,
0x00000008263d7824ULL, 0x000fc400078e00ffULL, 0x0000000833377824ULL, 0x020fe200078e00ffULL,
0xfffffff835337812ULL, 0x000fc600078ee220ULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x000000181918723eULL, 0x002fe400000010ffULL, 0x0000900000207811ULL, 0x000fe400078e58ffULL,
0xfffffff837357812ULL, 0x000fe400078ee222ULL, 0xfffffff83b377812ULL, 0x000fe200078ee224ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000001017177824ULL, 0x100fe400078e0220ULL,
0x0000001021217824ULL, 0x000fc400078e0220ULL, 0x0000001023237824ULL, 0x100fe400078e0220ULL,
0x0000001025257824ULL, 0x000fe200078e0220ULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x000000282919723eULL, 0x004fe200000010ffULL, 0x000000ffff287224ULL, 0x100fe400078e0036ULL,
0x000000ffff297224ULL, 0x000fe400078e0036ULL, 0x0000001027277824ULL, 0x100fe400078e0220ULL,
0x0000002a001b7308ULL, 0x000fe20000000800ULL, 0x0000001033337824ULL, 0x000fc400078e0220ULL,
0x0000001035357824ULL, 0x100fe400078e0220ULL, 0x0000001037377824ULL, 0x000fc600078e0220ULL,
0x0000002b00167308ULL, 0x0004e20000000800ULL, 0x0000001a071a723eULL, 0x002fe400000010ffULL,
0x0000003031077208ULL, 0x000fe40004800000ULL, 0xfffffff83d2b7812ULL, 0x004fca00078ee226ULL,
0x000000102b2b7824ULL, 0x000fe200078e0220ULL, 0x0000001b161b723eULL, 0x008fe400000010ffULL,
0x0000000c15167812ULL, 0x000fca00078ec0ffULL, 0x00000028181c723cULL, 0x000f62000004181cULL,
0x0000000117177824ULL, 0x000fe400078e0216ULL, 0x0000000116217824ULL, 0x040fe400078e0221ULL,
0x0000000116237824ULL, 0x040fe200078e0223ULL, 0x0000000817007388ULL, 0x0003e20000000800ULL,
0x0000000116257824ULL, 0x040fe400078e0225ULL, 0x0000000116277824ULL, 0x040fe200078e0227ULL,
0x0000000a21007388ULL, 0x0003e20000000800ULL, 0x0000000116337824ULL, 0x000fc400078e0233ULL,
0x0000000116357824ULL, 0x040fe200078e0235ULL, 0x0000000c23007388ULL, 0x0003e20000000800ULL,
0x0000000116377824ULL, 0x040fe400078e0237ULL, 0x0000000116167824ULL, 0x000fe200078e022bULL,
0x0000000e25007388ULL, 0x0003e80000000800ULL, 0x0000001027007388ULL, 0x0003e40000000800ULL,
0x000000ffff1d7224ULL, 0x020fc400078e001eULL, 0x0000001233007388ULL, 0x0003e80000000800ULL,
0x0000001835007388ULL, 0x0003e80000000800ULL, 0x0000001a37007388ULL, 0x0003e80000000800ULL,
0x0000000916007388ULL, 0x0003e80000000800ULL, 0x0004000b21007388ULL, 0x0003e80000000800ULL,
0x0004000d23007388ULL, 0x0003e80000000800ULL, 0x0004000f25007388ULL, 0x0003e80000000800ULL,
0x0004001127007388ULL, 0x0003e80000000800ULL, 0x0004001333007388ULL, 0x0003e80000000800ULL,
0x0004001935007388ULL, 0x0003e80000000800ULL, 0x0004001b37007388ULL, 0x0003e80000000800ULL,
0x00f0000414008388ULL, 0x0003e80000000c00ULL, 0x00f2001c14008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000042ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080042ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100042ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000144447810ULL, 0x000fe20007ffe0ffULL,
0x0000180042ff7f8cULL, 0x0003e6000c80043fULL, 0x0000002c4400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb3f000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff267807ULL, 0x008fe40004000000ULL,
0x0001606000317802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff267224ULL, 0x000fe200078e0030ULL, 0xfffec2a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff267807ULL, 0x000fe40004000000ULL, 0x000160b000317802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e0030ULL,
0xfffec31000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x008fe200078e0033ULL,
0x0001610000317802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e0030ULL, 0xfffec3d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0033ULL, 0x0001615000317802ULL, 0x000fc40000000f00ULL,
0x00000b6000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e0030ULL,
0xfffec4f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0029ULL,
0x000161b000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e0028ULL,
0x00000b0000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0030ULL,
0xfffec90000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e002eULL,
0x0001621000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fc400078e0029ULL,
0x00000aa000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0030ULL,
0xfffec8d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff267807ULL, 0x008fe40004000000ULL,
0x0001626000317802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0030ULL, 0xfffef9a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff267807ULL, 0x000fe40004000000ULL, 0x000162b000317802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e0030ULL,
0xfffef9f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e002bULL,
0x0001630000317802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e0030ULL, 0xfffefad000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e002bULL, 0x0001635000317802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e0030ULL,
0xfffefbe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0024ULL,
0x000163b000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e0025ULL,
0x0000090000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0030ULL,
0xfffefff000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0024ULL,
0x0001640000317802ULL, 0x000fc40000000f00ULL, 0x000008b000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff2e7224ULL, 0x004fe200078e0030ULL, 0xfffeffd000007947ULL, 0x000fea000383ffffULL,
0x00000001ff267807ULL, 0x004fe40004000000ULL, 0x0001645000317802ULL, 0x000fc40000000f00ULL,
0x000008b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0030ULL,
0xffff2e1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff267807ULL, 0x000fe40004000000ULL,
0x000164a000317802ULL, 0x000fc40000000f00ULL, 0x0000086000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0030ULL, 0xffff2e6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0033ULL, 0x000164f000317802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e0030ULL,
0xffff2f4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0033ULL,
0x0001654000317802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x01afea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e0030ULL, 0xffff305000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0024ULL, 0x000165a000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fc400078e0025ULL, 0x0000071000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e0030ULL, 0xffff346000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0024ULL, 0x000165f000317802ULL, 0x000fc40000000f00ULL,
0x000006c000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0030ULL,
0xffff344000007947ULL, 0x000fea000383ffffULL, 0x00000001ff267807ULL, 0x008fe40004000000ULL,
0x0001664000317802ULL, 0x000fc40000000f00ULL, 0x000006c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff267224ULL, 0x000fe200078e0030ULL, 0xffff627000007947ULL, 0x000fea000383ffffULL,
0x00000001ff267807ULL, 0x000fe40004000000ULL, 0x0001669000317802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff297224ULL, 0x000fe200078e0030ULL,
0xffff62c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e002bULL,
0x000166e000317802ULL, 0x000fc40000000f00ULL, 0x000005d000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e0030ULL, 0xffff639000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e002bULL, 0x0001673000317802ULL, 0x000fc40000000f00ULL,
0x0000058000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e0030ULL,
0xffff64a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0024ULL,
0x0001679000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e0025ULL,
0x0000052000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0030ULL,
0xffff689000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0024ULL,
0x000167e000317802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff2e7224ULL, 0x004fe200078e0030ULL, 0xffff687000007947ULL, 0x000fea000383ffffULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x0001683000087802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0031ULL,
0xffffea9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x006fe200078e0034ULL,
0x0001689000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x010fea0003c00000ULL, 0x000000313400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0006ULL, 0x000168f000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x0000003431347208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000310600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0007ULL, 0x0001695000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x0000000631067208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000310700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0035ULL, 0x000169b000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x0000000731307208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x000000313500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0034ULL, 0x00016a1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x0000003531047208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x000000313400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0006ULL, 0x00016a7000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x0000003431057208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000310600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff327224ULL, 0x002fe200078e0030ULL, 0x00016ad000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe200078e00ffULL, 0x0000000631067208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe96000007947ULL, 0x000fea000383ffffULL,
0x0180000046027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000004600028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff46ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000046037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000004600027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe939002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x0c00003332317389ULL, 0x0002a200000e0036ULL,
0xfffe935008007950ULL, 0x000fea0003c3ffffULL, 0x0000003900007348ULL, 0x000fe80003800000ULL,
0x0000002630307389ULL, 0x0002a200000e003aULL, 0x00000000ff277424ULL, 0x000fc400078e00ffULL,
0x000000ffff267224ULL, 0x002fc800078e0031ULL, 0xfffe930026007950ULL, 0x000fea0003c3ffffULL,
0x000000012600780cULL, 0x000fe20003f05070ULL, 0x0000003b00007348ULL, 0x000fe80003800000ULL,
0x00000000ff277424ULL, 0x000fd000078e00ffULL, 0x0000000000267806ULL, 0x000fc800040e0100ULL,
0x0000003b26307212ULL, 0x000fe200078ec0ffULL, 0x000000ffff267224ULL, 0x000fc800078e0031ULL,
0xfffe929026007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x00000000000003e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e70ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015f8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001608ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001698ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000169cULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000016e00ULL, 0xd700001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018680ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000186d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018a50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001698ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016fe8ULL, 0x0000000000016fe8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018a50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_86_cubin_len = 101168;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
