/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000013530ULL, 0x00000000000131b0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454536316a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL,
0x326a4c4545326a4cULL, 0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x324545386a4c4538ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL,
0x4536316a4c454534ULL, 0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x5f5f240000000000ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x756265642e006675ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x632e766e2e00656dULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL,
0x000000000061686dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000376ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000b0001000003bcULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b00010000040aULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b00010000044fULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a0022000004aaULL, 0x0000000000011bc0ULL, 0x0000000000000240ULL,
0x0004000300000520ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000011e00ULL, 0x000d000300000550ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00011bc000000000ULL, 0x0000ac0400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x00011bc000000000ULL, 0x0000024000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001600082f04ULL, 0x000823040000007cULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000013000942804ULL, 0x000007c000000150ULL,
0x0000259000002500ULL, 0x0000279000002650ULL, 0x00002cc000002cb0ULL, 0x00004b5000004ac0ULL,
0x00004d6000004c20ULL, 0x0000519000005180ULL, 0x00006e1000006db0ULL, 0x0000705000006f10ULL,
0x0000749000007480ULL, 0x000090f000009080ULL, 0x00009310000091d0ULL, 0x000096c0000096b0ULL,
0x0000a7200000a710ULL, 0x0001103000010f80ULL, 0x000112e000011260ULL, 0x000115c000011550ULL,
0x00011920000117e0ULL, 0x0000030004303904ULL, 0x00017600000000ffULL, 0x000003e000040100ULL,
0x000176080000000fULL, 0x000004f0003f0100ULL, 0x000176880000000fULL, 0x00000610003f0100ULL,
0x000176a800000006ULL, 0x00000720003f0100ULL, 0x000176c800000005ULL, 0x000008c0003f0100ULL,
0x000176000000000eULL, 0x00000a30003f0107ULL, 0x0001768800000005ULL, 0x00001430003f0101ULL,
0x00000000000000ffULL, 0x0000146000040107ULL, 0x00000000000000ffULL, 0x000014e000040101ULL,
0x0000002000000038ULL, 0x00001620003f0101ULL, 0x000176c800000038ULL, 0x000017a0003f0109ULL,
0x000176c800000038ULL, 0x00002220003f0109ULL, 0x000176a800000041ULL, 0x00002270003f0107ULL,
0x000176a800000041ULL, 0x00002280003f0101ULL, 0x0001760800000046ULL, 0x000022a0003f0101ULL,
0x0001760800000046ULL, 0x00002410003f0109ULL, 0x0001760800000046ULL, 0x00002940003f0109ULL,
0x000176a80000003cULL, 0x00002ab0003f0109ULL, 0x000176a80000003cULL, 0x00003b80003f0109ULL,
0x000176c80000003aULL, 0x00003ba0003f0101ULL, 0x0001768800000040ULL, 0x00003cf0003f0101ULL,
0x0000000000000047ULL, 0x00003e60003f0109ULL, 0x0000000000000047ULL, 0x00004850003f0109ULL,
0x000176a80000004fULL, 0x00004890003f0107ULL, 0x000176a80000004fULL, 0x000048a0003f0101ULL,
0x0001762800000046ULL, 0x000048c0003f0101ULL, 0x0001762800000046ULL, 0x00004a30003f0109ULL,
0x0001762800000046ULL, 0x00004f10003f0109ULL, 0x000176a800000041ULL, 0x00005080003f0109ULL,
0x000176a800000041ULL, 0x00005f50003f0109ULL, 0x000176c80000005bULL, 0x00005f70003f0101ULL,
0x0001769000000040ULL, 0x00006080003f0101ULL, 0x0000000000000047ULL, 0x000061f0003f0109ULL,
0x0000000000000047ULL, 0x00006ac0003f0109ULL, 0x00000000000000ffULL, 0x00006b8000040107ULL,
0x000176a800000041ULL, 0x00006b90003f0101ULL, 0x0001764800000046ULL, 0x00006bb0003f0101ULL,
0x0001764800000046ULL, 0x00006d20003f0109ULL, 0x0001764800000046ULL, 0x00007200003f0109ULL,
0x000176a80000004fULL, 0x00007370003f0109ULL, 0x000176a80000004fULL, 0x00008290003f0109ULL,
0x000176c80000005bULL, 0x000082d0003f0101ULL, 0x0001769800000040ULL, 0x000083a0003f0101ULL,
0x0000000000000047ULL, 0x00008510003f0109ULL, 0x0000000000000047ULL, 0x00008e10003f0109ULL,
0x00000000000000ffULL, 0x00008e5000050107ULL, 0x000176a80000004fULL, 0x00008e60003f0101ULL,
0x0001766800000046ULL, 0x00008e80003f0101ULL, 0x0001766800000046ULL, 0x00008ff0003f0109ULL,
0x0001766800000046ULL, 0x000094b0003f0109ULL, 0x000176a800000041ULL, 0x00009620003f0109ULL,
0x000176a800000041ULL, 0x0000a3c0003f0109ULL, 0x000176c800000038ULL, 0x0000a3f0003f0101ULL,
0x000176a000000040ULL, 0x0000b280003f0101ULL, 0x000176000000000eULL, 0x0000d020003f0101ULL,
0x000176000000000eULL, 0x0000d190003f0109ULL, 0x000176000000000eULL, 0x0000d370003f0109ULL,
0x000176000000000eULL, 0x0000d390003f0101ULL, 0x000176000000000eULL, 0x0000d500003f0109ULL,
0x000176000000000eULL, 0x000104d0003f0109ULL, 0x0001768800000009ULL, 0x000106a0003f0101ULL,
0x0001768800000009ULL, 0x00010810003f0109ULL, 0x0001768800000009ULL, 0x00011b50003f0109ULL,
0x000176080000000bULL, 0x00011b60003f0101ULL, 0x000176100000000bULL, 0x00011b70003f0101ULL,
0x000176180000000bULL, 0x00011b80003f0101ULL, 0x000176200000000bULL, 0x00053803003f0101ULL,
0x0000afa000141c04ULL, 0x0000d5300000b220ULL, 0x00011bb00000d5f0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400501903ULL, 0x0050021000000017ULL,
0x00000000000000bcULL, 0x0000001600000002ULL, 0x0000000000011bc0ULL, 0x0000000000000044ULL,
0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001600000002ULL,
0x0000000000000000ULL, 0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008400ff157b82ULL, 0x000ee20000000800ULL,
0x00000400000e7802ULL, 0x000fe20000000f00ULL, 0x0000000000007919ULL, 0x000ea20000002200ULL,
0x000002e000007945ULL, 0x000fe20003800000ULL, 0x0000000000357919ULL, 0x000f280000002100ULL,
0x00008800ff027b82ULL, 0x000f620000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000000000ULL,
0x0000000000147919ULL, 0x000eac0000002600ULL, 0x00008e00ff367b82ULL, 0x000f620000000a00ULL,
0x0000000000087919ULL, 0x000ea20000002700ULL, 0x00000000000f7919ULL, 0x000ea20000008800ULL,
0x0000000815047824ULL, 0x008fc400078e00ffULL, 0x0000000409007c24ULL, 0x004fe2000f8e0200ULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000400057c24ULL, 0x110fe2000f8e0235ULL,
0x00000005ff357819ULL, 0x000fe20000011635ULL, 0x00001fff09007589ULL, 0x000fe600000e0000ULL,
0x0000007f0500780cULL, 0x040fe40003f84070ULL, 0x00001fff35357589ULL, 0x000ea200000e0000ULL,
0x000000ff0500720cULL, 0x040fe20003f05270ULL, 0x0000000814077824ULL, 0x002fe200078e00ffULL,
0x0000000f0500780cULL, 0x000fc40003f24070ULL, 0x000000030500780cULL, 0x040fe20003f64070ULL,
0x0000000804077224ULL, 0x000fe200078e0207ULL, 0x000000010500780cULL, 0x000fe20003f44070ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x000006540f0e7816ULL, 0x000fe4000000000eULL,
0x00000000000bc919ULL, 0x000e620000008800ULL, 0x00000400000ac802ULL, 0x000fe20000000f00ULL,
0x0000000400067824ULL, 0x004fc800078e0235ULL, 0x0000000206067824ULL, 0x000fca00078e00ffULL,
0x0000000806097848ULL, 0x000fca0007fe0000ULL, 0x0000000109097824ULL, 0x000fe200078e0a06ULL,
0x000006540b10c816ULL, 0x002fe2000000000aULL, 0xff317217ff0bc424ULL, 0x000fe200078e00ffULL,
0x00000004ff0a7819ULL, 0x000fca000001160dULL, 0x00000001060c7824ULL, 0x000fe400078e020aULL,
0x000000040506c824ULL, 0x000fe400078e0210ULL, 0x0000000107077824ULL, 0x000fe200078e020cULL,
0x0000000000240947ULL, 0x020fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01760006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x00000004050f7c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x000000000f0612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01760804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x00000004050f7c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x000000000f0612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01768804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0174000b0600c388ULL, 0x0003e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000405067c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000060612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000405057c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000050612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000000e0472caULL, 0x000fe200000e0000ULL, 0x000000010c057824ULL, 0x000fe200078e020dULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000010007027825ULL, 0x000fe200078e0002ULL,
0x000000f004077812ULL, 0x000fe200078ec0ffULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0x000000090a00720cULL, 0x000fe20003f06070ULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000702027210ULL, 0x000fe20007f3e0ffULL, 0x0001760004047890ULL, 0x000fe2000fffe03fULL,
0x0000000408367825ULL, 0x000fc400078e0036ULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x000000ffff037224ULL, 0x000fc600008e0603ULL, 0x0000001005057824ULL, 0x000fca00078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0005e2000c101c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000636367981ULL, 0x000ee2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000007f36347836ULL, 0x008fe40000000000ULL, 0x000000ff36007836ULL, 0x000fc60000000000ULL,
0x00000007ff347819ULL, 0x000fe40000011634ULL, 0x00000008ff0f7819ULL, 0x000fca0000011600ULL,
0x000000a800308947ULL, 0x000fea0003800000ULL, 0x00000003ff577819ULL, 0x000fe20000011635ULL,
0xffffffffff0c7424ULL, 0x000fc600078e00ffULL, 0x01ffffff57577812ULL, 0x000fc800078ec0ffULL,
0x000000345700720cULL, 0x000fda0003f06070ULL, 0x00009000ff068b82ULL, 0x000e620000000800ULL,
0x0000000208058824ULL, 0x004fce00078e00ffULL, 0x00008c00ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000605068224ULL, 0x002fe400078e0206ULL, 0x0000000835057824ULL, 0x000fe400078e020eULL,
0x0000000157078824ULL, 0x000fe400078e0206ULL, 0x00000004ff067424ULL, 0x000fe400078e00ffULL,
0x0000000407028825ULL, 0x004fe400078e0002ULL, 0x0176880605ff79a7ULL, 0x0003e6000850003fULL,
0x00000006020c8981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x00000080140a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc40000011635ULL,
0x0000000135067812ULL, 0x002fc600078ec0ffULL, 0x000000200b097824ULL, 0x000fca00078e00ffULL,
0x000000600a007812ULL, 0x000fe200078ef809ULL, 0x000000150c057224ULL, 0x004fc800078e02ffULL,
0x0000008005137824ULL, 0x000fe200078e00ffULL, 0x0000000400240947ULL, 0x000fec0003800000ULL,
0x00000003ff057819ULL, 0x000fe2000001160dULL, 0x0000001006037824ULL, 0x000fe200078e00ffULL,
0x0000000936027248ULL, 0x000fe20007fe0000ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000070041b7812ULL, 0x000fe200078ec0ffULL, 0x0000000103067824ULL, 0x000fe400078e0205ULL,
0x0000000102027824ULL, 0x000fe400078e0a09ULL, 0x0000000106077824ULL, 0x040fe400078e020dULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0x0000000302027248ULL, 0x000fe20007fe0000ULL,
0x0000000100067824ULL, 0x000fc400078e0206ULL, 0x0000000805117836ULL, 0x000fe20000000000ULL,
0xfffffff810077812ULL, 0x000fe200078ee207ULL, 0x0000000102027824ULL, 0x000fe200078e0a03ULL,
0x0000000613197210ULL, 0x000fe20007f1e0ffULL, 0x0000000405107836ULL, 0x000fe40000000000ULL,
0x0000000c05127836ULL, 0x000fe20000000000ULL, 0x000000021100720cULL, 0x080fe20003f26070ULL,
0x0000000103117824ULL, 0x040fe200078e0211ULL, 0x000000021000720cULL, 0x080fe20003f46070ULL,
0x0000000103107824ULL, 0x000fe200078e0210ULL, 0x000000020500720cULL, 0x000fe20003f66070ULL,
0x0000000103067824ULL, 0x000fe200078e0212ULL, 0x00000004191a7c11ULL, 0x000fe2000f8838ffULL,
0x0000000110057824ULL, 0x000fc400078e020dULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x000000021200720cULL, 0x000fe20003f06070ULL,
0x0000000100107824ULL, 0x040fe200078e0210ULL, 0xfffffff816057812ULL, 0x000fe200078ee205ULL,
0x0000000100027824ULL, 0x040fe200078e0211ULL, 0x0000000519197c11ULL, 0x000fe2000a0f3c14ULL,
0x0000000100037824ULL, 0x000fe200078e0206ULL, 0x0000001013107210ULL, 0x000fe20007f9e0ffULL,
0x0000000111007824ULL, 0x140fe200078e020dULL, 0x0000000213147210ULL, 0x000fe20007fbe0ffULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x0000000313127210ULL, 0x000fe20007fde0ffULL,
0x0000000106027824ULL, 0x000fc400078e020dULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0xfffffff811037812ULL, 0x000fe200078ee200ULL, 0x0000000806117824ULL, 0x000fe200078e00ffULL,
0x0000000410167c11ULL, 0x000fe2000f8838ffULL, 0x000020000b007824ULL, 0x000fc600078e020eULL,
0xfffffff811117812ULL, 0x000fe200078ee202ULL, 0x0001300000007836ULL, 0x000fe20000000000ULL,
0x0000000510187c11ULL, 0x000fe4000a0f3c13ULL, 0x0000001a1b027210ULL, 0x000fe20007f9e0ffULL,
0x0000001007137824ULL, 0x100fe400078e0200ULL, 0x0000001005157824ULL, 0x100fe400078e0200ULL,
0x0000001003177824ULL, 0x100fe400078e0200ULL, 0x000000ffff077224ULL, 0x000fe200028e06ffULL,
0x0000000414067c11ULL, 0x000fe2000f8a38ffULL, 0x000000ffff057224ULL, 0x000fe200030e06ffULL,
0x0000000412107c11ULL, 0x000fe2000f8c38ffULL, 0x000000ffff037224ULL, 0x000fe200020e0619ULL,
0x0000001b16047210ULL, 0x000fe20007f9e0ffULL, 0x0000001011197824ULL, 0x000fe200078e0200ULL,
0x0000000514077c11ULL, 0x000fc4000a8f3c07ULL, 0x0000000512007c11ULL, 0x000fe2000b0f3c05ULL,
0x000000ffff057224ULL, 0x000fe200020e0618ULL, 0x0000001b06067210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002137faeULL, 0x0003e2000d901c46ULL,
0x0000001b10107210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000000004157faeULL, 0x0003e2000d101c46ULL, 0x000000ffff117224ULL, 0x000fc600020e0600ULL,
0x0000000006177faeULL, 0x0003e8000c901c46ULL, 0x0000000010197faeULL, 0x0003e2000c101c46ULL,
0x0000000000f07947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000070041b7812ULL, 0x000fc600078ec0ffULL,
0x000000020d027211ULL, 0x000fca00078fe8ffULL, 0x0000000402057836ULL, 0x000fe40000000000ULL,
0x0000000102037824ULL, 0x140fe400078e020dULL, 0x0000000105067824ULL, 0x040fe400078e020dULL,
0x0000000805117824ULL, 0x000fe400078e00ffULL, 0x0000000802107824ULL, 0x000fe400078e00ffULL,
0x0000000802077836ULL, 0x000fe20000000000ULL, 0xfffffff811067812ULL, 0x000fe200078ee206ULL,
0x0000000c02117836ULL, 0x000fe20000000000ULL, 0xfffffff810037812ULL, 0x000fe200078ee203ULL,
0x0000000100027824ULL, 0x000fc400078e0202ULL, 0x0000000100057824ULL, 0x040fe400078e0205ULL,
0x0000000100107824ULL, 0x040fe200078e0207ULL, 0x0000000213167210ULL, 0x000fe20007f3e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0211ULL, 0x0000000513147210ULL, 0x000fe20007f5e0ffULL,
0x0000000807157824ULL, 0x000fe200078e00ffULL, 0x0000001013127210ULL, 0x000fe20007f7e0ffULL,
0x0000000111027824ULL, 0x000fe200078e020dULL, 0x0000000013057210ULL, 0x000fe20007f1e0ffULL,
0x000020000b137824ULL, 0x000fc400078e020eULL, 0x0000000107007824ULL, 0x000fe400078e020dULL,
0x0000000811117824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x0000000416107c11ULL, 0x040fe2000f8238ffULL, 0x0001300013197836ULL, 0x000fe20000000000ULL,
0xfffffff815007812ULL, 0x000fe400078ee200ULL, 0xfffffff811027812ULL, 0x000fe200078ee202ULL,
0x0000001003137824ULL, 0x000fe200078e0219ULL, 0x0000000516167c11ULL, 0x000fe200088f3c07ULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x0000000414117c11ULL, 0x000fe2000f8238ffULL,
0x0000001006157824ULL, 0x100fe200078e0219ULL, 0x0000000412067c11ULL, 0x000fe2000f8438ffULL,
0x0000001000177824ULL, 0x000fe200078e0219ULL, 0x0000000514147c11ULL, 0x000fe200088f3c03ULL,
0x0000001002197824ULL, 0x000fe200078e0219ULL, 0x000000101b027210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200018e06ffULL, 0x0000000405107c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x000000111b047210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200008e0616ULL, 0x0000000512077c11ULL, 0x000fc400090f3c07ULL,
0x000000061b067210ULL, 0x000fe40007f3e0ffULL, 0x0000000505007c11ULL, 0x000fe200098f3c00ULL,
0x000000ffff057224ULL, 0x000fe200000e0614ULL, 0x000000101b107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002137faeULL, 0x0003e6000b901c46ULL, 0x000000ffff117224ULL, 0x000fe200010e0600ULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0000000006177faeULL, 0x0003e8000b901c46ULL,
0x0000000010197faeULL, 0x0003e4000b901c46ULL, 0x000176a80e007836ULL, 0x000fe20000000000ULL,
0x000000000b0472caULL, 0x000fe200000e0000ULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x000000ffff077224ULL, 0x002fe200078e00ffULL,
0x00000000000572caULL, 0x000fe400000e0000ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000080b387824ULL, 0x000fe200078e0200ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000039ff5279a7ULL, 0x0002a20008500004ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00002039383879a7ULL, 0x002e62000850003fULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000090001c8947ULL, 0x000fec0003800000ULL,
0x00009000ff037b82ULL, 0x000ee20000000800ULL, 0x0000000208087824ULL, 0x000fe400078e00ffULL,
0xff317217ff527424ULL, 0x004fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff307224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fe400078e00ffULL,
0x0000000308087224ULL, 0x008fce00078e0203ULL, 0x0000010006057824ULL, 0x000fca00078e00ffULL,
0x000000360500720cULL, 0x000fda0003f06070ULL, 0x0000008c00e80947ULL, 0x012fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe400078e0057ULL, 0x000000ffff047224ULL, 0x000fce00078e0030ULL,
0x0000000000327805ULL, 0x000fe20000015200ULL, 0x0000000435317824ULL, 0x000fca00078e00ffULL,
0xfffffff831317812ULL, 0x000fca00078ec0ffULL, 0x000000010e387824ULL, 0x002fc800078e0231ULL,
0x0176c839380075a7ULL, 0x000ea2000800017fULL, 0x000176c838477836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff377224ULL, 0x000fce00078e00ffULL,
0x000000103700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a323a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e33ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff317819ULL, 0x000fc8000001143bULL,
0x0000003a31317211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000231317819ULL, 0x000fc8000000123aULL, 0x000000310000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000137377836ULL, 0x000fce0000000000ULL,
0x0176c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000106327836ULL, 0x000fe20000000000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000001035317824ULL, 0x000fe200078e00ffULL, 0x0000000130427812ULL, 0x000fe200078e0cffULL,
0x000000040c0c7c24ULL, 0x000fe2000f8e02ffULL, 0x0000000f3200720cULL, 0x000fe40003f06070ULL,
0xffffffe031337812ULL, 0x000fe200078ec0ffULL, 0x000000800c3d7824ULL, 0x000fc800078e00ffULL,
0x0000010006337824ULL, 0x000fc800078e0233ULL, 0x0000004033337836ULL, 0x000fca0000000000ULL,
0x000000600a397812ULL, 0x000fe200078ef833ULL, 0x00000004002c8947ULL, 0x000fec0003800000ULL,
0x0000001031317812ULL, 0x000fe200078ec0ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000003ff377819ULL, 0x000fe4000001160dULL, 0x00000033360c7248ULL, 0x000fc60007fe0000ULL,
0x0000000137327824ULL, 0x000fe400078e0231ULL, 0x000000010c0c7824ULL, 0x000fe400078e0a33ULL,
0x0000000132337824ULL, 0x040fe400078e020dULL, 0x0000000832387824ULL, 0x000fe200078e00ffULL,
0x000000310c0c7248ULL, 0x000fe20007fe0000ULL, 0x0000000139327824ULL, 0x000fe400078e0232ULL,
0x00000008373a7836ULL, 0x000fe20000000000ULL, 0xfffffff838337812ULL, 0x000fe200078ee233ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a31ULL, 0x000000323d417210ULL, 0x000fe20007f1e0ffULL,
0x0000000437387836ULL, 0x000fc60000000000ULL, 0x0000000c3700720cULL, 0x080fe20003f66070ULL,
0x0000000c37377836ULL, 0x000fe20000000000ULL, 0x0000000c3800720cULL, 0x0c0fe20003f46070ULL,
0x0000000138387824ULL, 0x100fe200078e0231ULL, 0x0000000c3a00720cULL, 0x080fe20003f26070ULL,
0x00000001373c7824ULL, 0x000fe200078e0231ULL, 0x00000004413f7c11ULL, 0x000fe2000f8838ffULL,
0x0000000138327824ULL, 0x040fe400078e020dULL, 0x00000008383b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3e7224ULL, 0x000fe200000e06ffULL, 0x0000000c3700720cULL, 0x000fe20003f06070ULL,
0x000000013a3a7824ULL, 0x000fe200078e0231ULL, 0xfffffff83b377812ULL, 0x000fe200078ee232ULL,
0x0000000139387824ULL, 0x000fe200078e0238ULL, 0x0000000541417c11ULL, 0x000fe2000a0f3c3eULL,
0x0000000139327824ULL, 0x000fc400078e023cULL, 0x00000001390c7824ULL, 0x000fe200078e023aULL,
0x000000383d407210ULL, 0x000fe20007f9e0ffULL, 0x000000013a317824ULL, 0x040fe400078e020dULL,
0x000000083a447824ULL, 0x000fe200078e00ffULL, 0x000000323d3a7210ULL, 0x000fe20007fde0ffULL,
0x000000100d327824ULL, 0x000fe200078e00ffULL, 0x0000000c3d3e7210ULL, 0x000fe20007fbe0ffULL,
0x000020000b3b7824ULL, 0x000fe200078e020eULL, 0xfffffff844397812ULL, 0x000fe200078ee231ULL,
0x000000ffff3d7224ULL, 0x000fe200020e06ffULL, 0x0000000440387c11ULL, 0x000fe2000f8838ffULL,
0x00001000420c7824ULL, 0x000fe200078e023bULL, 0x0000007032447812ULL, 0x000fe200078ec0ffULL,
0x000000013c317824ULL, 0x000fe200078e020dULL, 0x0000000540407c11ULL, 0x000fe2000a0f3c3dULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x000000443f327210ULL, 0x000fe20007f9e0ffULL,
0x000130000c0c7836ULL, 0x000fc40000000000ULL, 0x000000ffff437224ULL, 0x000fe200028e06ffULL,
0xfffffff83c3b7812ULL, 0x000fe200078ee231ULL, 0x0000001033317824ULL, 0x100fe200078e020cULL,
0x000000043e3d7c11ULL, 0x000fe2000f8a38ffULL, 0x00000010393f7824ULL, 0x100fe400078e020cULL,
0x000000ffff397224ULL, 0x000fe200030e06ffULL, 0x000000043a3c7c11ULL, 0x000fe2000f8c38ffULL,
0x000000ffff337224ULL, 0x000fe200020e0641ULL, 0x0000004438387210ULL, 0x000fe20007f9e0ffULL,
0x0000001037377824ULL, 0x000fc400078e020cULL, 0x000000103b417824ULL, 0x000fe200078e020cULL,
0x000000053e3b7c11ULL, 0x000fe2000a8f3c43ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032317faeULL, 0x0003e2000d901c46ULL, 0x000000053a0c7c11ULL, 0x000fe2000b0f3c39ULL,
0x000000ffff397224ULL, 0x000fe200020e0640ULL, 0x000000443d3a7210ULL, 0x000fe40007fbe0ffULL,
0x000000443c3c7210ULL, 0x000fe40007f9e0ffULL, 0x0000000038377faeULL, 0x0003e2000d101c46ULL,
0x000000ffff3b7224ULL, 0x000fc400028e063bULL, 0x000000ffff3d7224ULL, 0x000fc600020e060cULL,
0x000000003a3f7faeULL, 0x0003e8000c901c46ULL, 0x000000003c417faeULL, 0x0003e2000c101c46ULL,
0x0000000000f87947ULL, 0x000fea0003800000ULL, 0x00000010310c7812ULL, 0x000fe200078ec0ffULL,
0x000020000b3f7824ULL, 0x000fe200078e020eULL, 0x00008a0000047ab9ULL, 0x000fe40000000a00ULL,
0x0000000c0d0c7211ULL, 0x000fe200078fe8ffULL, 0x00001000423f7824ULL, 0x000fc800078e023fULL,
0x000000040c327836ULL, 0x000fe40000000000ULL, 0x000000010c317824ULL, 0x140fe400078e020dULL,
0x000000080c387824ULL, 0x000fe400078e00ffULL, 0x0000000132337824ULL, 0x040fe400078e020dULL,
0x00000008323a7824ULL, 0x000fe200078e00ffULL, 0xfffffff838317812ULL, 0x000fe200078ee231ULL,
0x000000080c387836ULL, 0x000fc40000000000ULL, 0x0000000139327824ULL, 0x040fe200078e0232ULL,
0xfffffff83a337812ULL, 0x000fe200078ee233ULL, 0x0000000c0c3a7836ULL, 0x000fe40000000000ULL,
0x00000001390c7824ULL, 0x040fe200078e020cULL, 0x000000323d3e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000139377824ULL, 0x040fe400078e0238ULL, 0x0000000139397824ULL, 0x000fe200078e023aULL,
0x0000000c3d407210ULL, 0x000fe20007f3e0ffULL, 0x00000001380c7824ULL, 0x100fe200078e020dULL,
0x000000373d3b7210ULL, 0x000fe20007f7e0ffULL, 0x000000013a327824ULL, 0x000fe200078e020dULL,
0x000000393d397210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff377224ULL, 0x000fe200008e06ffULL,
0x00000004403c7c11ULL, 0x000fe2000f8238ffULL, 0x00000008383d7824ULL, 0x000fc400078e00ffULL,
0x000000083a437824ULL, 0x000fe200078e00ffULL, 0x0000000540407c11ULL, 0x000fe200088f3c37ULL,
0x000130003f417836ULL, 0x000fe20000000000ULL, 0xfffffff83d0c7812ULL, 0x000fe200078ee20cULL,
0x000000100d387824ULL, 0x000fe200078e00ffULL, 0xfffffff843327812ULL, 0x000fe200078ee232ULL,
0x0000001033377824ULL, 0x100fe200078e0241ULL, 0x000000043e3d7c11ULL, 0x000fe2000f8238ffULL,
0x000000ffff337224ULL, 0x000fe200010e06ffULL, 0x0000007038437812ULL, 0x000fe200078ec0ffULL,
0x0000001031317824ULL, 0x100fe200078e0241ULL, 0x000000043b3a7c11ULL, 0x000fe2000f8438ffULL,
0x000000100c3f7824ULL, 0x000fe200078e0241ULL, 0x000000053e3e7c11ULL, 0x000fe200088f3c33ULL,
0x0000001032417824ULL, 0x000fe200078e0241ULL, 0x000000433c327210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00000004393c7c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff0c7224ULL, 0x000fc400000e06ffULL, 0x000000ffff337224ULL, 0x000fe200008e0640ULL,
0x000000053b3b7c11ULL, 0x000fe400090f3c38ULL, 0x000000433d387210ULL, 0x000fe40007f1e0ffULL,
0x000000433a3a7210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032317faeULL, 0x0003e2000b901c46ULL, 0x00000005390c7c11ULL, 0x000fe200098f3c0cULL,
0x000000ffff397224ULL, 0x000fe200000e063eULL, 0x000000433c3c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3b7224ULL, 0x000fc600008e063bULL, 0x0000000038377faeULL, 0x0003e2000b901c46ULL,
0x000000ffff3d7224ULL, 0x000fc600010e060cULL, 0x000000003a3f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c417faeULL, 0x0003e4000b901c46ULL, 0x0000000157317836ULL, 0x002fe40000000000ULL,
0xffffffffff0c7424ULL, 0x000fc600078e00ffULL, 0x000000343100720cULL, 0x000fda0003f06070ULL,
0x00008c00ff328b82ULL, 0x000e620000000a00ULL, 0x0000000108318810ULL, 0x000fca0007ffe057ULL,
0x0000000431328825ULL, 0x002fc800078e0032ULL, 0x0000000835317824ULL, 0x000fe200078e00ffULL,
0x00000006320c8981ULL, 0x000322000c1e1900ULL, 0x00000001ff3a7424ULL, 0x000fc600078e00ffULL,
0xfffffff031377812ULL, 0x040fe400078ec0ffULL, 0x0000001031387812ULL, 0x040fe400078ec0ffULL,
0x0000000831467812ULL, 0x000fe200078ec0ffULL, 0x000000010e377824ULL, 0x000fc800078e0237ULL,
0x0000000842417824ULL, 0x000fe200078e0237ULL, 0xffffffe031377812ULL, 0x000fc800078ec0ffULL,
0x00000000410472caULL, 0x000fe400000e0000ULL, 0x0000000e38377210ULL, 0x000fe20007ffe037ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000137467824ULL, 0x000fcc00078e0246ULL,
0x000176a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0176a83a415a79a7ULL, 0x0002a4000850003fULL,
0x0176083a463a79a7ULL, 0x0022e4000850003fULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0176083b460075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fce0000015200ULL,
0x0000003832387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e33ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff317819ULL, 0x000fc80000011439ULL, 0x0000003831317211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000231317819ULL, 0x000fc80000001238ULL,
0x000000310000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176083b460075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000002035317824ULL, 0x000fe200078e00ffULL,
0x00000001ff447819ULL, 0x000fe2000001160dULL, 0x000000100d327824ULL, 0x000fe400078e00ffULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0xffffff8031317812ULL, 0x000fe200078ec0ffULL,
0x000000ffff597224ULL, 0x000fe200078e0052ULL, 0x0000007032397812ULL, 0x000fe400078ec0ffULL,
0x0000000c44447812ULL, 0x000fe200078ec0ffULL, 0x000000010e457824ULL, 0x000fca00078e0231ULL,
0x0000004544317210ULL, 0x000fca0007ffe039ULL, 0x0170000031337984ULL, 0x000ee80000000800ULL,
0x0172000031377984ULL, 0x000b620000000800ULL, 0x000000523300720bULL, 0x008fda0003f1d000ULL,
0x0000000000327806ULL, 0x000fc800000e0100ULL, 0x0000ffff32387812ULL, 0x000fda000780c0ffULL,
0x0000000000f48947ULL, 0x026fea0003800000ULL, 0x00000002ff327819ULL, 0x000fe40000011635ULL,
0x000000523300720bULL, 0x000fe40003f14000ULL, 0x000000353200720cULL, 0x000fe40003f25270ULL,
0x0000003352597209ULL, 0x000fd60007810000ULL, 0x0000008035319824ULL, 0x000fca00078e020eULL,
0x0000003144329210ULL, 0x000fe40007ffe039ULL, 0x0000000000397806ULL, 0x000fc600000e0100ULL,
0x0174005932009388ULL, 0x0003e20000000800ULL, 0x0000991039317816ULL, 0x000fc800000000ffULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x8000005952317221ULL, 0x000fe20000010000ULL, 0x000000ff39ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0039ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100327308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x002fcc000001160dULL, 0x00001f3132317589ULL, 0x004e6400000e0000ULL,
0x0000003128287220ULL, 0x082fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003110107220ULL, 0x080fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000003207077220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x000000080d317811ULL, 0x002fcc00078ff0ffULL, 0x00001f3132317589ULL, 0x000e6400000e0000ULL,
0x000000312a2a7220ULL, 0x082fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x0000003112127220ULL, 0x080fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff38ff7812ULL, 0x000fda0007806039ULL, 0x8000005933330221ULL, 0x000fe20000010000ULL,
0x00007610ff3a0816ULL, 0x000fc6000000003aULL, 0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL,
0x0000003300020308ULL, 0x000ea40000000800ULL, 0x0000000237370220ULL, 0x004fce0000410000ULL,
0x0000000737077221ULL, 0x000fce0000010000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x000000100b317824ULL, 0x002fc800078e020eULL, 0x00000008303c7824ULL, 0x000fc800078e0231ULL,
0x0176a8533c0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fce0000015200ULL,
0x0000003832387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e33ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff317819ULL, 0x000fc80000011439ULL, 0x0000003831317211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000231317819ULL, 0x000fc80000001238ULL,
0x000000310000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176a8533c0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000020000b337824ULL, 0x000fe200078e020eULL,
0x000000070d327812ULL, 0x000fe200078ec0ffULL, 0x0000000235407824ULL, 0x040fe200078e00ffULL,
0x000099103a317816ULL, 0x000fe200000000ffULL, 0x0000100030487824ULL, 0x000fe200078e0233ULL,
0x00000008324b7812ULL, 0x000fe200078ef80dULL, 0x0000000435337824ULL, 0x000fe200078e00ffULL,
0x000000ff3100720cULL, 0x000fe20003f05270ULL, 0x0000020035327824ULL, 0x000fe200078e00ffULL,
0x00000004ff527819ULL, 0x000fe2000001160dULL, 0x000000084b387824ULL, 0x000fe200078e00ffULL,
0x0000000440317812ULL, 0x000fe200078ec0ffULL, 0x0001300048487836ULL, 0x000fe20000000000ULL,
0x000000080d307812ULL, 0x000fc400078ec0ffULL, 0x0000000433337812ULL, 0x000fe400078ec0ffULL,
0x000000314b317210ULL, 0x000fe40007ffe052ULL, 0x0000000730517812ULL, 0x000fe200078ef80dULL,
0x0000000152507824ULL, 0x000fe200078e0233ULL, 0xfffff80032377812ULL, 0x000fe400078ec0ffULL,
0xfffffff838307812ULL, 0x000fe200078ee231ULL, 0x0000000851337824ULL, 0x040fe400078e00ffULL,
0x0000000151387824ULL, 0x000fc400078e0250ULL, 0x000000010e377824ULL, 0x000fc600078e0237ULL,
0xfffffff833337812ULL, 0x000fe200078ee238ULL, 0x0000001030437824ULL, 0x000fe200078e0237ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130007589ULL, 0x0002e400000e0000ULL, 0x00000010333c7824ULL, 0x000fe400078e0248ULL,
0x011000004330783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x00000008513a7824ULL, 0x000fe400078e00ffULL,
0x00000002384d7836ULL, 0x000fe40000000000ULL, 0x000000040b527824ULL, 0x000fc600078e0252ULL,
0xfffffff83a4d7812ULL, 0x000fe400078ee24dULL, 0x0000000252527810ULL, 0x000fe20007ffe04bULL,
0x000000084b4b7824ULL, 0x000fe400078e00ffULL, 0x000000104d387824ULL, 0x000fc600078e0248ULL,
0xfffffff84b527812ULL, 0x000fc600078ee252ULL, 0x000000003838783bULL, 0x000f640000004200ULL,
0x0000001052377824ULL, 0x000fe200078e0237ULL, 0x00000018ff5f7819ULL, 0x022fe2000001143cULL,
0x000001003c4f7824ULL, 0x040fe200078e00ffULL, 0x000088803c627816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001143dULL,
0x000001003d537824ULL, 0x040fe200078e00ffULL, 0x000088803d667816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006200627306ULL, 0x000fe20000202400ULL, 0x00000018ff4f7819ULL, 0x000fc4000001144fULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff587819ULL, 0x000fe2000001143fULL, 0x0000003c00647306ULL, 0x0003e20000202400ULL,
0x000088803f617816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x008fe40000011438ULL,
0x00000018ff4e7819ULL, 0x000fc40000011439ULL, 0x0000888038547816ULL, 0x000fe200000000ffULL,
0x0000004f00677306ULL, 0x0007620000202400ULL, 0x000001003f3c7824ULL, 0x042fe200078e00ffULL,
0x000088803e607816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001143eULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x000001003e4f7824ULL, 0x048fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fc4000001143aULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000053006b7306ULL, 0x0002e20000202400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff4a7819ULL, 0x000fca000001143bULL, 0x0000003d00697306ULL, 0x0007e20000202400ULL,
0x0000888039537816ULL, 0x002fce00000000ffULL, 0x0000003c00687306ULL, 0x0003e20000202400ULL,
0x00000100383d7824ULL, 0x04cfe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x00000100393c7824ULL, 0x042fe200078e00ffULL, 0x0000005f005f7306ULL, 0x000e620000202400ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe4000001143cULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000004f00637306ULL, 0x000fe20000202400ULL,
0x000088803a3c7816ULL, 0x000fce00000000ffULL, 0x0000003f005d7306ULL, 0x000ff00000202400ULL,
0x0000005e005e7306ULL, 0x000eb00000202400ULL, 0x00000038004f7306ULL, 0x000bf00000202400ULL,
0x00000039003f7306ULL, 0x0007e20000202400ULL, 0x0000541062387816ULL, 0x020fce0000000067ULL,
0x0000006000607306ULL, 0x000f620000202400ULL, 0x0000541066397816ULL, 0x008fce000000006bULL,
0x0000006100617306ULL, 0x000ee20000202400ULL, 0x000000383028723cULL, 0x000fee0000041828ULL,
0x000001003b397824ULL, 0x000fe200078e00ffULL, 0x0000541064387816ULL, 0x002fe2000000005fULL,
0x0000005c005c7306ULL, 0x000fe60000202400ULL, 0x00000018ff5f7819ULL, 0x000fc40000011439ULL,
0x0000541069397816ULL, 0x004fc6000000005eULL, 0x0000005800587306ULL, 0x000fe80000202400ULL,
0x000000383024723cULL, 0x000fe80000041824ULL, 0x0000003e00657306ULL, 0x0002a60000202400ULL,
0x0000541060387816ULL, 0x020fc40000000063ULL, 0x0000541061397816ULL, 0x008fc60000000068ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x000088803b3e7816ULL, 0x042fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe400078e00ffULL, 0x000000383020723cULL, 0x000fe60000041820ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000003d00557306ULL, 0x0002e60000202400ULL,
0x0000541065387816ULL, 0x004fc4000000005cULL, 0x000054105d397816ULL, 0x000fc60000000058ULL,
0x0000005300537306ULL, 0x000fe20000202400ULL, 0x000001003a3d7824ULL, 0x042fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000038301c723cULL, 0x000fe4000004181cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005600567306ULL, 0x000e620000202400ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000541054387816ULL, 0x008fca0000000055ULL,
0x0000004c004c7306ULL, 0x000ea20000202400ULL, 0x0000541053397816ULL, 0x002fce0000000056ULL,
0x0000004e004e7306ULL, 0x000e620000202400ULL, 0x000000383018723cULL, 0x000fee0000041818ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000054104f387816ULL, 0x004fe4000000004cULL,
0x000054103f397816ULL, 0x002fca000000004eULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x00000010514f7812ULL, 0x000fe200078efcffULL, 0x000000383014723cULL, 0x000fe80000041814ULL,
0x000000084f4b7824ULL, 0x000fe400078e00ffULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x0000000150387824ULL, 0x000fe200078e024fULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000004a004a7306ULL, 0x000fe20000202400ULL, 0xfffffff84b4b7812ULL, 0x000fce00078ee238ULL,
0x0000003e003e7306ULL, 0x000ff00000202400ULL, 0x0000005f005f7306ULL, 0x000e700000202400ULL,
0x0000003a003a7306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000005fULL,
0x0000003b003b7306ULL, 0x000e620000202400ULL, 0x0000003c3010723cULL, 0x000fe20000041810ULL,
0x000054103a3a7816ULL, 0x004fcc0000000049ULL, 0x000000104b3c7824ULL, 0x000fe200078e0248ULL,
0x000054103b3b7816ULL, 0x002fce000000004aULL, 0x0000003a302c723cULL, 0x000fe2000004182cULL,
0x011000003730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x000000084f3a7824ULL, 0x000fe400078e00ffULL, 0x0000000238497836ULL, 0x000fe40000000000ULL,
0x0000000157577836ULL, 0x000fc60000000000ULL, 0xfffffff83a497812ULL, 0x000fca00078ee249ULL,
0x0000001049387824ULL, 0x000fcc00078e0248ULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x00000018ff5d7819ULL, 0x008fe2000001143cULL, 0x000001003c4f7824ULL, 0x040fe200078e00ffULL,
0x000088803c5f7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001143dULL, 0x000001003d527824ULL, 0x040fe200078e00ffULL,
0x000088803d627816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff567819ULL, 0x000fe2000001143fULL,
0x0000003c00647306ULL, 0x0007e20000202400ULL, 0x000088803f607816ULL, 0x000fe400000000ffULL,
0x00000018ff4c7819ULL, 0x022fe40000011438ULL, 0x00000018ff4e7819ULL, 0x000fc40000011439ULL,
0x0000888038537816ULL, 0x000fe200000000ffULL, 0x0000004f00667306ULL, 0x0003620000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x000088803e5e7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001143eULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x000001003e4f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc4000001143aULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x00000052006b7306ULL, 0x0002e20000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff4a7819ULL, 0x000fca000001143bULL,
0x0000003d00677306ULL, 0x0007e20000202400ULL, 0x0000888039527816ULL, 0x002fce00000000ffULL,
0x0000003c00697306ULL, 0x0003e20000202400ULL, 0x00000100383d7824ULL, 0x04cfe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x00000100393c7824ULL, 0x042fe200078e00ffULL,
0x0000005d005d7306ULL, 0x000e620000202400ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe4000001143cULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000004f00617306ULL, 0x000fe20000202400ULL, 0x000088803a3c7816ULL, 0x000fce00000000ffULL,
0x0000003f00657306ULL, 0x000ff00000202400ULL, 0x0000005c005c7306ULL, 0x000eb00000202400ULL,
0x00000038004f7306ULL, 0x000bf00000202400ULL, 0x00000039003f7306ULL, 0x0007e20000202400ULL,
0x000054105f387816ULL, 0x020fce0000000066ULL, 0x0000005e005e7306ULL, 0x000f620000202400ULL,
0x0000541062397816ULL, 0x008fce000000006bULL, 0x0000006000607306ULL, 0x000ee20000202400ULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x000001003b397824ULL, 0x000fe200078e00ffULL,
0x0000541064387816ULL, 0x002fe2000000005dULL, 0x0000005800587306ULL, 0x000fe60000202400ULL,
0x00000018ff5d7819ULL, 0x000fc40000011439ULL, 0x0000541067397816ULL, 0x004fc6000000005cULL,
0x0000005600567306ULL, 0x000fe80000202400ULL, 0x000000383024723cULL, 0x000fe80000041824ULL,
0x0000003e00637306ULL, 0x0002a60000202400ULL, 0x000054105e387816ULL, 0x020fc40000000061ULL,
0x0000541060397816ULL, 0x008fc60000000069ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x000088803b3e7816ULL, 0x042fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe400078e00ffULL,
0x000000383020723cULL, 0x000fe60000041820ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003d00547306ULL, 0x0002e60000202400ULL, 0x0000541063387816ULL, 0x004fe20000000058ULL,
0x00000001ff637424ULL, 0x000fe200078e00ffULL, 0x0000541065397816ULL, 0x000fc60000000056ULL,
0x0000005200527306ULL, 0x000fe20000202400ULL, 0x000001003a3d7824ULL, 0x042fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000038301c723cULL, 0x000fe4000004181cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x00000018ff5c7819ULL, 0x000fe2000001143aULL, 0x000000080b3a7824ULL, 0x000fe200078e020eULL,
0x0000541053387816ULL, 0x008fc40000000054ULL, 0xfffffff840537812ULL, 0x000fc600078ec0ffULL,
0x0000004c004c7306ULL, 0x000ea40000202400ULL, 0x000000010e407824ULL, 0x000fe400078e0253ULL,
0x000000ffff537224ULL, 0x000fe200078e005bULL, 0x0000541052397816ULL, 0x002fc60000000055ULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x000000ffff527224ULL, 0x000fc600078e0059ULL,
0x000000383018723cULL, 0x000fe80000041818ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0176c8633a3879a7ULL, 0x00046e000850003fULL, 0x0000003d003d7306ULL, 0x000ee20000202400ULL,
0x0176886340ff79a7ULL, 0x0003e2000850003fULL, 0x000054104f3a7816ULL, 0x004fcc000000004cULL,
0x0000004800487306ULL, 0x000fe20000202400ULL, 0x000054103c3c7816ULL, 0x008fce000000003dULL,
0x0000004a004a7306ULL, 0x000ff00000202400ULL, 0x0000003e003e7306ULL, 0x000ff00000202400ULL,
0x0000005d005d7306ULL, 0x000eb00000202400ULL, 0x0000005c005f7306ULL, 0x000ee20000202400ULL,
0x000054103e3d7816ULL, 0x004fce000000005dULL, 0x0000003b00617306ULL, 0x0005620000202400ULL,
0x0000003c3010723cULL, 0x000fe20000041810ULL, 0x000054103f3b7816ULL, 0x004fce000000004eULL,
0x0000003a3014723cULL, 0x000fee0000041814ULL, 0x000054105f3a7816ULL, 0x008fe40000000048ULL,
0x00005410613b7816ULL, 0x020fce000000004aULL, 0x0000003a302c723cULL, 0x000fee000004182cULL,
0x0000004006317811ULL, 0x000fe200078e40ffULL, 0x000000ffff307224ULL, 0x000fc600078e0042ULL,
0x000000363100720cULL, 0x000fda0003f06070ULL, 0x0000006800200947ULL, 0x002fea0003800000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x00000039470075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x00000039470075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000106307836ULL, 0x000fe20000000000ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x0000001035317824ULL, 0x000fe400078e00ffULL, 0x000000050c557c24ULL, 0x010fe2000f8e02ffULL,
0x0000000f3000720cULL, 0x000fe40003f06070ULL, 0xffffffe031337812ULL, 0x000fe200078ec0ffULL,
0x0000008055557824ULL, 0x000fc800078e00ffULL, 0x0000010006337824ULL, 0x000fc800078e0233ULL,
0x0000008033337836ULL, 0x000fca0000000000ULL, 0x000000600a3a7812ULL, 0x000fe200078ef833ULL,
0x0000000400308947ULL, 0x000fec0003800000ULL, 0x0000001031327812ULL, 0x000fe200078ec0ffULL,
0x0000100004307824ULL, 0x000fe200078e00ffULL, 0x0000003336317248ULL, 0x000fe20007fe0000ULL,
0x000020000b397824ULL, 0x000fe200078e020eULL, 0x00000003ff387819ULL, 0x000fe2000001160dULL,
0x00008a0000087ab9ULL, 0x000fe20000000a00ULL, 0x0000100030307812ULL, 0x000fe200078ec0ffULL,
0x0000000131317824ULL, 0x000fe400078e0a33ULL, 0x00000001383b7824ULL, 0x000fe200078e0232ULL,
0x0001300039397810ULL, 0x000fe20007ffe030ULL, 0x00000008383c7836ULL, 0x000fe20000000000ULL,
0x0000003132317248ULL, 0x000fe20007fe0000ULL, 0x000000013b337824ULL, 0x000fc400078e020dULL,
0x000000083b4a7824ULL, 0x000fe400078e00ffULL, 0x0000000131317824ULL, 0x000fe400078e0a32ULL,
0x000000013b307824ULL, 0x000fe200078e023aULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee233ULL,
0x0000000438337836ULL, 0x000fe20000000000ULL, 0x000000313800720cULL, 0x080fe20003f46070ULL,
0x0000000c383e7836ULL, 0x000fe20000000000ULL, 0x0000003055307210ULL, 0x000fe20007f7e0ffULL,
0x0000000133387824ULL, 0x140fe200078e0232ULL, 0x000000313c00720cULL, 0x0c0fe20003f06070ULL,
0x000000013c3c7824ULL, 0x100fe200078e0232ULL, 0x000000313300720cULL, 0x000fe20003f26070ULL,
0x000000013e3f7824ULL, 0x000fe200078e0232ULL, 0x00000008303d7c11ULL, 0x000fe2000f8838ffULL,
0x0000000138327824ULL, 0x000fc400078e020dULL, 0x00000008384f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x000000313e00720cULL, 0x000fe20003f66070ULL,
0x000000013c3b7824ULL, 0x040fe200078e020dULL, 0xfffffff84f4c7812ULL, 0x000fe200078ee232ULL,
0x000000013c327824ULL, 0x100fe200078e023aULL, 0x00000009303e7c11ULL, 0x000fe2000a0f3c33ULL,
0x0000000138307824ULL, 0x100fe400078e023aULL, 0x000000083c4e7824ULL, 0x000fe200078e00ffULL,
0x0000003255327210ULL, 0x000fe20007fbe0ffULL, 0x000000100d387824ULL, 0x000fe200078e00ffULL,
0x0000003055307210ULL, 0x000fe20007f9e0ffULL, 0x000000013f3a7824ULL, 0x040fe200078e023aULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee23bULL, 0x000000013f3c7824ULL, 0x040fe200078e020dULL,
0x0000007038387812ULL, 0x000fe200078ec0ffULL, 0x000000083f3f7824ULL, 0x000fc400078e00ffULL,
0x000000ffff337224ULL, 0x000fe200020e06ffULL, 0x0000000830577c11ULL, 0x000fe2000f8838ffULL,
0x000000ffff317224ULL, 0x000fe200028e06ffULL, 0x00000008323b7c11ULL, 0x000fe2000f8a38ffULL,
0x000000104c4f7824ULL, 0x100fe200078e0239ULL, 0xfffffff83f527812ULL, 0x000fe200078ee23cULL,
0x000000104a3f7824ULL, 0x000fe200078e0239ULL, 0x00000009303c7c11ULL, 0x000fe2000a0f3c33ULL,
0x000000104e537824ULL, 0x000fe200078e0239ULL, 0x0000000932487c11ULL, 0x000fe2000a8f3c31ULL,
0x0000001052397824ULL, 0x000fe200078e0239ULL, 0x0000003a553a7210ULL, 0x000fc40007fbe0ffULL,
0x000000383d327210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x000000083a3d7c11ULL, 0x040fe2000f8a38ffULL, 0x000000ffff337224ULL, 0x000fe200020e063eULL,
0x0000003857307210ULL, 0x000fe40007f9e0ffULL, 0x000000093a3e7c11ULL, 0x000fe4000a8f3c31ULL,
0x000000383b3a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200020e063cULL,
0x000000383d3c7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000323f7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff3b7224ULL, 0x000fc400028e0648ULL,
0x000000ffff3d7224ULL, 0x000fe200020e063eULL, 0x00000000304f7faeULL, 0x0003e8000c901c46ULL,
0x000000003a537faeULL, 0x0003e8000c101c46ULL, 0x000000003c397faeULL, 0x0003e2000d901c46ULL,
0x0000000000fc7947ULL, 0x000fea0003800000ULL, 0x0000001031307812ULL, 0x000fe200078ec0ffULL,
0x0000100004317824ULL, 0x000fe200078e00ffULL, 0x00008a0000087ab9ULL, 0x000fe40000000a00ULL,
0x000000300d327211ULL, 0x000fe200078fe8ffULL, 0x000020000b307824ULL, 0x000fe200078e020eULL,
0x0000100031337812ULL, 0x000fc600078ec0ffULL, 0x0000000132317824ULL, 0x000fe200078e020dULL,
0x00013000303e7810ULL, 0x000fe20007ffe033ULL, 0x0000000832387824ULL, 0x040fe400078e00ffULL,
0x0000000132307824ULL, 0x000fe400078e023aULL, 0x0000000832337836ULL, 0x000fe20000000000ULL,
0xfffffff838397812ULL, 0x000fe200078ee231ULL, 0x0000000432317836ULL, 0x000fe20000000000ULL,
0x00000030553c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000c323d7836ULL, 0x000fc40000000000ULL,
0x0000000131307824ULL, 0x140fe400078e023aULL, 0x0000000131387824ULL, 0x140fe400078e020dULL,
0x00000008313f7824ULL, 0x000fe400078e00ffULL, 0x0000000133327824ULL, 0x140fe400078e023aULL,
0x00000001333b7824ULL, 0x040fe200078e020dULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee238ULL,
0x00000008334a7824ULL, 0x000fe200078e00ffULL, 0x0000003255327210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x000000083c337c11ULL, 0x040fe2000f8038ffULL,
0x000000013d3a7824ULL, 0x000fe200078e023aULL, 0xfffffff84a3b7812ULL, 0x000fe200078ee23bULL,
0x000000100d387824ULL, 0x000fe200078e00ffULL, 0x000000093c3c7c11ULL, 0x000fe200080f3c31ULL,
0x000000013d487824ULL, 0x040fe200078e020dULL, 0x0000003055307210ULL, 0x000fe20007f1e0ffULL,
0x000000083d537824ULL, 0x000fe200078e00ffULL, 0x0000007038387812ULL, 0x000fe200078ec0ffULL,
0x000000103b4f7824ULL, 0x100fe200078e023eULL, 0x0000003a553a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x0000000830577c11ULL, 0x040fe2000f8038ffULL,
0x0000001039397824ULL, 0x100fe200078e023eULL, 0xfffffff853537812ULL, 0x000fe200078ee248ULL,
0x000000103f3f7824ULL, 0x100fe200078e023eULL, 0x00000009304a7c11ULL, 0x000fe200080f3c31ULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x00000008323b7c11ULL, 0x000fe2000f8238ffULL,
0x0000001053537824ULL, 0x000fe200078e023eULL, 0x0000003833307210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff337224ULL, 0x000fe200010e06ffULL, 0x000000083a3d7c11ULL, 0x000fc4000f8438ffULL,
0x0000000932487c11ULL, 0x000fe200088f3c31ULL, 0x000000ffff317224ULL, 0x000fe200000e063cULL,
0x0000003857327210ULL, 0x000fe40007f1e0ffULL, 0x000000093a3e7c11ULL, 0x000fe400090f3c33ULL,
0x000000383b3a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e064aULL,
0x000000383d3c7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030397faeULL, 0x0003e4000b901c46ULL, 0x000000ffff3b7224ULL, 0x000fc400008e0648ULL,
0x000000ffff3d7224ULL, 0x000fe200010e063eULL, 0x00000000323f7faeULL, 0x0003e8000b901c46ULL,
0x000000003a4f7faeULL, 0x0003e8000b901c46ULL, 0x000000003c537faeULL, 0x0003e4000b901c46ULL,
0x0000000835317824ULL, 0x002fe400078e00ffULL, 0x0000000804307824ULL, 0x000fc600078e00ffULL,
0xfffffff031317812ULL, 0x000fe400078ec0ffULL, 0x00000008304f7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff307424ULL, 0x000fc600078e00ffULL, 0x0000000e4f4f7210ULL, 0x000fc80007ffe031ULL,
0x000000004f0572caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176a805057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0176a8304f5279a7ULL, 0x0002a4000850003fULL,
0x01762830463079a7ULL, 0x0022e4000850003fULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x01762831460075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3c7224ULL, 0x000fce00078e00ffULL, 0x000000103c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fce0000015200ULL,
0x0000003a323a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e33ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff397819ULL, 0x000fc8000001143bULL, 0x0000003a39397211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000239397819ULL, 0x000fc8000000123aULL,
0x000000390000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013c3c7836ULL, 0x000fce0000000000ULL, 0x01762831460075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000008038317810ULL, 0x000fe20007ffe045ULL,
0x00000001ff397424ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x004fe400078e0059ULL,
0x0000000144317824ULL, 0x000fca00078e0231ULL, 0x0170000031307984ULL, 0x000ea80000000800ULL,
0x0172000031327984ULL, 0x0006e20000000800ULL, 0x000000593000720bULL, 0x004fda0003f1d000ULL,
0x00000000003b7806ULL, 0x000fc800000e0100ULL, 0x0000ffff3bff7812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00afea0003800000ULL, 0x00000001353a7811ULL, 0x000fe400078ff0ffULL,
0x000000593000720bULL, 0x000fe40003f14000ULL, 0x000000353a00720cULL, 0x000fda0003f25270ULL,
0x0000008035339824ULL, 0x000fe200078e020eULL, 0x0000005930319209ULL, 0x000fc80007810000ULL,
0x00000033443a9210ULL, 0x000fe40007ffe038ULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x017400313a009388ULL, 0x0003e20000000800ULL, 0x0000991038337816ULL, 0x000fc800000000ffULL,
0x000000ff3300720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x00000059303a7209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x000000593a317221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL, 0x00000031003a7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x002fcc000001160dULL,
0x00001f313a317589ULL, 0x004e6400000e0000ULL, 0x0000003128287220ULL, 0x082fe20000410000ULL,
0x0000003129297220ULL, 0x080fe20000410000ULL, 0x0000003124247220ULL, 0x080fe20000410000ULL,
0x0000003125257220ULL, 0x080fe20000410000ULL, 0x0000003120207220ULL, 0x080fe20000410000ULL,
0x0000003121217220ULL, 0x080fe20000410000ULL, 0x000000311c1c7220ULL, 0x080fe20000410000ULL,
0x000000311d1d7220ULL, 0x080fe20000410000ULL, 0x0000003118187220ULL, 0x080fe20000410000ULL,
0x0000003119197220ULL, 0x080fe20000410000ULL, 0x0000003114147220ULL, 0x080fe20000410000ULL,
0x0000003115157220ULL, 0x080fe20000410000ULL, 0x0000003110107220ULL, 0x080fe20000410000ULL,
0x0000003111117220ULL, 0x080fe20000410000ULL, 0x000000312c2c7220ULL, 0x080fe20000410000ULL,
0x000000312d2d7220ULL, 0x000fce0000410000ULL, 0x0000003a07077220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080d317811ULL, 0x002fcc00078ff0ffULL,
0x00001f313a317589ULL, 0x000e6400000e0000ULL, 0x000000312a2a7220ULL, 0x082fe20000410000ULL,
0x000000312b2b7220ULL, 0x080fe20000410000ULL, 0x0000003126267220ULL, 0x080fe20000410000ULL,
0x0000003127277220ULL, 0x080fe20000410000ULL, 0x0000003122227220ULL, 0x080fe20000410000ULL,
0x0000003123237220ULL, 0x080fe20000410000ULL, 0x000000311e1e7220ULL, 0x080fe20000410000ULL,
0x000000311f1f7220ULL, 0x080fe20000410000ULL, 0x000000311a1a7220ULL, 0x080fe20000410000ULL,
0x000000311b1b7220ULL, 0x080fe20000410000ULL, 0x0000003116167220ULL, 0x080fe20000410000ULL,
0x0000003117177220ULL, 0x080fe20000410000ULL, 0x0000003112127220ULL, 0x080fe20000410000ULL,
0x0000003113137220ULL, 0x080fe20000410000ULL, 0x000000312e2e7220ULL, 0x080fe20000410000ULL,
0x000000312f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe2000780083bULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000005930527209ULL, 0x000fd60007810000ULL,
0x8000005230300221ULL, 0x000fe20000010000ULL, 0x00007610ff390816ULL, 0x000fc60000000039ULL,
0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL, 0x0000003000020308ULL, 0x000ea40000000800ULL,
0x0000000232320220ULL, 0x004fce0000410000ULL, 0x0000000732077221ULL, 0x000fe20000010000ULL,
0x0000000000307805ULL, 0x002fe20000015200ULL, 0x0176a85b410075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0176a85b410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991039307816ULL, 0x000fe200000000ffULL, 0x000020000b337824ULL, 0x000fe400078e020eULL,
0x0000000151317824ULL, 0x040fe200078e0250ULL, 0x000000ff3000720cULL, 0x000fe20003f05270ULL,
0x0000000851327824ULL, 0x000fe400078e00ffULL, 0x0000100042337824ULL, 0x000fc600078e0233ULL,
0xfffffff832317812ULL, 0x000fe200078ee231ULL, 0x0001300033547836ULL, 0x000fc80000000000ULL,
0x00000010314e7824ULL, 0x000fe400078e0254ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x011800004330783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000004e3c783bULL, 0x000f220000004200ULL, 0x000000104d4c7824ULL, 0x000fca00078e0254ULL,
0x000000004c38783bULL, 0x000f620000004200ULL, 0x00000018ff637819ULL, 0x010fe2000001143cULL,
0x000001003c587824ULL, 0x040fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe2000001143dULL,
0x000001003d597824ULL, 0x040fe200078e00ffULL, 0x000088803c667816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d697816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff577819ULL, 0x022fe40000011438ULL,
0x00008880385b7816ULL, 0x000fe200000000ffULL, 0x00000058006b7306ULL, 0x0003e20000202400ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5e7819ULL, 0x000fe4000001143fULL,
0x000088803f657816ULL, 0x000fc400000000ffULL, 0x00000018ff567819ULL, 0x000fe20000011439ULL,
0x0000003c006a7306ULL, 0x0009e20000202400ULL, 0x000001003e587824ULL, 0x042fe200078e00ffULL,
0x00008880395a7816ULL, 0x000fe400000000ffULL, 0x000088803e647816ULL, 0x040fe400000000ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003d006d7306ULL, 0x0003e20000202400ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe2000001143aULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x00000100383d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff4a7819ULL, 0x000fca000001143bULL, 0x00000059006c7306ULL, 0x000e700000202400ULL,
0x0000005800677306ULL, 0x000ff00000202400ULL, 0x0000003c00687306ULL, 0x0009f00000202400ULL,
0x0000003800587306ULL, 0x000be20000202400ULL, 0x00000100393c7824ULL, 0x010fc400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006200627306ULL, 0x000f220000202400ULL, 0x000001003b387824ULL, 0x028fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fc80000011439ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003f00617306ULL, 0x000ff00000202400ULL, 0x0000003900597306ULL, 0x0003f00000202400ULL,
0x00000038003f7306ULL, 0x0007e20000202400ULL, 0x0000541069397816ULL, 0x002fce000000006cULL,
0x0000006400647306ULL, 0x000e620000202400ULL, 0x0000541066387816ULL, 0x008fe2000000006bULL,
0x000100003b667824ULL, 0x000fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000006500657306ULL, 0x000ee20000202400ULL, 0x000000383028723cULL, 0x000fee0000041828ULL,
0x000054106a387816ULL, 0x000fe20000000063ULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x000054106d397816ULL, 0x010fce0000000062ULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x000000383024723cULL, 0x000fee0000041824ULL, 0x0000003e00607306ULL, 0x0009620000202400ULL,
0x0000541064387816ULL, 0x002fe40000000067ULL, 0x0000541065397816ULL, 0x008fca0000000068ULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x000001003a3e7824ULL, 0x010fe200078e00ffULL,
0x000000383020723cULL, 0x000fe80000041820ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003d005c7306ULL, 0x0002e20000202400ULL, 0x0000541060387816ULL, 0x024fe4000000005fULL,
0x0000541061397816ULL, 0x000fca000000005eULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x000088803a3d7816ULL, 0x042fe200000000ffULL, 0x00000038301c723cULL, 0x000fe2000004181cULL,
0x000100003a3a7824ULL, 0x000fca00078e00ffULL, 0x0000003c005d7306ULL, 0x0002a20000202400ULL,
0x000054105b387816ULL, 0x008fe4000000005cULL, 0x00000018ff3a7819ULL, 0x000fca000001143aULL,
0x0000005700577306ULL, 0x000ee20000202400ULL, 0x000088803b3c7816ULL, 0x002fe400000000ffULL,
0x000054105a397816ULL, 0x004fca000000005dULL, 0x0000005600567306ULL, 0x000e640000202400ULL,
0x000000383018723cULL, 0x000fec0000041818ULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x0000541058387816ULL, 0x008fe40000000057ULL, 0x0000541059397816ULL, 0x002fca0000000056ULL,
0x0000003e003e7306ULL, 0x000e640000202400ULL, 0x000000383014723cULL, 0x000fec0000041814ULL,
0x0000003c003c7306ULL, 0x000ea20000202400ULL, 0x000054103d387816ULL, 0x002fce000000003eULL,
0x0000004800487306ULL, 0x000fe20000202400ULL, 0x000054103c397816ULL, 0x004fce000000003fULL,
0x0000004a004a7306ULL, 0x000fe20000202400ULL, 0x000000383010723cULL, 0x000fee0000041810ULL,
0x0000003a003b7306ULL, 0x000e700000202400ULL, 0x0000006600637306ULL, 0x000ea20000202400ULL,
0x000054103b387816ULL, 0x002fc40000000048ULL, 0x0000541063397816ULL, 0x004fe2000000004aULL,
0x000000104b4a7824ULL, 0x000fcc00078e0254ULL, 0x00000038302c723cULL, 0x000fe2000004182cULL,
0x011800003730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000004a3c783bULL, 0x000ee20000004200ULL,
0x0000001049487824ULL, 0x000fca00078e0254ULL, 0x000000004838783bULL, 0x000f220000004200ULL,
0x00000018ff657819ULL, 0x008fe2000001143cULL, 0x000001003c5a7824ULL, 0x040fe200078e00ffULL,
0x000088803c677816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe2000001143dULL, 0x000001003d5b7824ULL, 0x040fe200078e00ffULL,
0x000088803d6a7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006700677306ULL, 0x000fe20000202400ULL,
0x00000018ff5a7819ULL, 0x000fc4000001145aULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5f7819ULL, 0x000fe2000001143fULL,
0x0000003c006c7306ULL, 0x0007e20000202400ULL, 0x000088803f647816ULL, 0x000fe400000000ffULL,
0x00000018ff597819ULL, 0x010fe40000011438ULL, 0x00000018ff587819ULL, 0x000fc40000011439ULL,
0x00008880385c7816ULL, 0x000fe200000000ffULL, 0x0000005a00687306ULL, 0x0009620000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x000088803e667816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe4000001143eULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x000001003e5a7824ULL, 0x050fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fc4000001143aULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x0000005b006d7306ULL, 0x0007220000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff577819ULL, 0x000fca000001143bULL,
0x0000003d006e7306ULL, 0x0009e20000202400ULL, 0x00008880395b7816ULL, 0x008fce00000000ffULL,
0x0000003c006b7306ULL, 0x0007e20000202400ULL, 0x00000100383d7824ULL, 0x054fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006500657306ULL, 0x000ea20000202400ULL, 0x00000100393c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001143cULL, 0x0000006100617306ULL, 0x000ee20000202400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fca00000000ffULL,
0x0000005a00697306ULL, 0x000ff00000202400ULL, 0x0000003f00627306ULL, 0x000ff00000202400ULL,
0x00000038005a7306ULL, 0x000bf00000202400ULL, 0x00000039003f7306ULL, 0x0009e20000202400ULL,
0x0000541067387816ULL, 0x022fe20000000068ULL, 0x000001003b677824ULL, 0x000fcc00078e00ffULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x000054106a397816ULL, 0x010fce000000006dULL,
0x0000006400647306ULL, 0x000f220000202400ULL, 0x000000383028723cULL, 0x000fee0000041828ULL,
0x000054106c387816ULL, 0x004fe20000000065ULL, 0x0000006000607306ULL, 0x000fe20000202400ULL,
0x000054106e397816ULL, 0x008fc40000000061ULL, 0x00000018ff617819ULL, 0x000fca0000011467ULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x000000383024723cULL, 0x000fee0000041824ULL,
0x0000003e00637306ULL, 0x0004e20000202400ULL, 0x0000541066387816ULL, 0x002fe40000000069ULL,
0x0000541064397816ULL, 0x010fca000000006bULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x000088803b3e7816ULL, 0x044fe200000000ffULL, 0x000000383020723cULL, 0x000fe20000041820ULL,
0x000100003b3b7824ULL, 0x000fca00078e00ffULL, 0x0000003d005d7306ULL, 0x0002a20000202400ULL,
0x0000541063387816ULL, 0x008fe40000000060ULL, 0x0000541062397816ULL, 0x000fe4000000005fULL,
0x00000018ff3b7819ULL, 0x000fc6000001143bULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000001003a3d7824ULL, 0x042fe200078e00ffULL, 0x00000038301c723cULL, 0x000fe2000004181cULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000054105c387816ULL, 0x004fe2000000005dULL, 0x00000001ff5d7424ULL, 0x000fc800078e00ffULL,
0x0000005900597306ULL, 0x000ea20000202400ULL, 0x000054105b397816ULL, 0x002fce000000005eULL,
0x0000005800587306ULL, 0x000e620000202400ULL, 0x000000080b5b7824ULL, 0x000fe200078e020eULL,
0x000000383018723cULL, 0x000fec0000041818ULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x000054105a387816ULL, 0x004fe40000000059ULL, 0x000054103f397816ULL, 0x002fca0000000058ULL,
0x0000005700577306ULL, 0x000fe40000202400ULL, 0x000000383014723cULL, 0x000fec0000041814ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x0176c85d5b3879a7ULL, 0x00026e000850003fULL,
0x0000003d003d7306ULL, 0x000ea20000202400ULL, 0x0176905d40ff79a7ULL, 0x0003ee000850003fULL,
0x0000003e003e7306ULL, 0x000ff00000202400ULL, 0x0000006100617306ULL, 0x000ff00000202400ULL,
0x0000003a00657306ULL, 0x0004f00000202400ULL, 0x0000003b005c7306ULL, 0x0009620000202400ULL,
0x000054103c3a7816ULL, 0x004fc4000000003dULL, 0x0000541065567816ULL, 0x008fe40000000056ULL,
0x000054103e3b7816ULL, 0x010fe40000000061ULL, 0x000054105c577816ULL, 0x020fca0000000057ULL,
0x0000003a3010723cULL, 0x000fec0000041810ULL, 0x00000056302c723cULL, 0x000fee000004182cULL,
0x0000008006317811ULL, 0x000fe200078e40ffULL, 0x0000000105577836ULL, 0x000fe20000000000ULL,
0x0000000104307812ULL, 0x000fc400078ec0ffULL, 0x000000363100720cULL, 0x000fda0003f06070ULL,
0x00000044003c0947ULL, 0x002fea0003800000ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x00000039470075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011433ULL, 0x0000003b0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x000000020c0c7819ULL, 0x000fc80000001233ULL,
0x0000000c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x00000039470075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001060c7836ULL, 0x000fe40000000000ULL,
0x0000001035307824ULL, 0x000fc600078e00ffULL, 0x0000000f0c00720cULL, 0x000fe40003f06070ULL,
0xffffffe030317812ULL, 0x000fca00078ec0ffULL, 0x0000010006317824ULL, 0x000fc800078e0231ULL,
0x000000c031317836ULL, 0x000fca0000000000ULL, 0x000000600a327812ULL, 0x000fe200078ef831ULL,
0x0000000400208947ULL, 0x000fec0003800000ULL, 0x00000031360c7248ULL, 0x000fe20007fe0000ULL,
0x00008a0000087ab9ULL, 0x000fe20000000a00ULL, 0x0000001030337812ULL, 0x000fe400078ec0ffULL,
0x00000003ff307819ULL, 0x000fe2000001160dULL, 0x000000010c0c7824ULL, 0x000fc800078e0a31ULL,
0x0000000130317824ULL, 0x000fe200078e0233ULL, 0x0000000c330c7248ULL, 0x000fe20007fe0000ULL,
0x0000000430397836ULL, 0x000fe40000000000ULL, 0x0000000131387824ULL, 0x040fe400078e020dULL,
0x00000008313d7824ULL, 0x040fe400078e00ffULL, 0x000000010c0c7824ULL, 0x100fe400078e0a33ULL,
0x0000000c303a7836ULL, 0x000fe20000000000ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee238ULL,
0x0000000830387836ULL, 0x000fe20000000000ULL, 0x0000000c3000720cULL, 0x080fe20003f66070ULL,
0x0000000131307824ULL, 0x000fe200078e0232ULL, 0x0000000c3900720cULL, 0x0c0fe20003f46070ULL,
0x0000000139397824ULL, 0x100fe200078e0233ULL, 0x0000000c3800720cULL, 0x0c0fe20003f26070ULL,
0x00000001383b7824ULL, 0x000fe200078e0233ULL, 0x0000003055387210ULL, 0x000fe20007f9e0ffULL,
0x0000000139317824ULL, 0x040fe200078e020dULL, 0x0000000c3a00720cULL, 0x000fe20003f06070ULL,
0x00000008393c7824ULL, 0x000fc400078e00ffULL, 0x000000013a567824ULL, 0x000fe400078e0233ULL,
0x00000001390c7824ULL, 0x100fe200078e0232ULL, 0xfffffff83c3f7812ULL, 0x000fe200078ee231ULL,
0x000000ffff317224ULL, 0x000fe200020e06ffULL, 0x0000000838337c11ULL, 0x000fe2000f8838ffULL,
0x000000013b307824ULL, 0x100fe400078e0232ULL, 0x0000000156327824ULL, 0x000fe200078e0232ULL,
0x0000000938387c11ULL, 0x000fe2000a0f3c31ULL, 0x000000100d3c7824ULL, 0x000fe200078e00ffULL,
0x0000000c553a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000856577824ULL, 0x000fe200078e00ffULL,
0x00000030553e7210ULL, 0x000fe20007fbe0ffULL, 0x000000013b307824ULL, 0x140fe200078e020dULL,
0x00000032550c7210ULL, 0x000fe20007fde0ffULL, 0x000000083b557824ULL, 0x000fe200078e00ffULL,
0x000000703c3c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff317224ULL, 0x000fe200020e06ffULL,
0x000000083a5b7c11ULL, 0x000fe2000f8838ffULL, 0x0000000156327824ULL, 0x000fe200078e020dULL,
0xfffffff855557812ULL, 0x000fe200078ee230ULL, 0x000000ffff597224ULL, 0x000fe200028e06ffULL,
0x000000093a3a7c11ULL, 0x000fe2000a0f3c31ULL, 0x000000103d3d7824ULL, 0x100fe200078e0254ULL,
0x0000003c33307210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff337224ULL, 0x000fe200030e06ffULL,
0xfffffff857577812ULL, 0x000fe200078ee232ULL, 0x000000103f3f7824ULL, 0x000fe200078e0254ULL,
0x000000083e397c11ULL, 0x000fe2000f8a38ffULL, 0x000000ffff317224ULL, 0x000fe200020e0638ULL,
0x000000080c3b7c11ULL, 0x000fe2000f8c38ffULL, 0x0000001055557824ULL, 0x100fe200078e0254ULL,
0x0000003c5b327210ULL, 0x000fe20007f9e0ffULL, 0x0000001057577824ULL, 0x000fe200078e0254ULL,
0x000000093e3e7c11ULL, 0x000fe2000a8f3c59ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303d7faeULL, 0x0003e2000d901c46ULL, 0x000000090c0c7c11ULL, 0x000fe2000b0f3c33ULL,
0x000000ffff337224ULL, 0x000fe200020e063aULL, 0x0000003c39387210ULL, 0x000fc40007fbe0ffULL,
0x0000003c3b3a7210ULL, 0x000fe40007f9e0ffULL, 0x00000000323f7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff397224ULL, 0x000fe400028e063eULL, 0x000000ffff3b7224ULL, 0x000fc600020e060cULL,
0x0000000038557faeULL, 0x0003e8000c901c46ULL, 0x000000003a577faeULL, 0x0003e2000c101c46ULL,
0x0000000000ec7947ULL, 0x000fea0003800000ULL, 0x0000001030307812ULL, 0x000fe200078ec0ffULL,
0x00008a0000087ab9ULL, 0x000fc60000000a00ULL, 0x000000300d307211ULL, 0x000fca00078fe8ffULL,
0x0000000430317836ULL, 0x000fe40000000000ULL, 0x00000001300c7824ULL, 0x140fe400078e020dULL,
0x00000008303d7824ULL, 0x040fe400078e00ffULL, 0x0000000131337824ULL, 0x040fe400078e020dULL,
0x0000000831387824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL,
0x00000001300c7824ULL, 0x000fc400078e0232ULL, 0x0000000c30397836ULL, 0x000fe20000000000ULL,
0xfffffff8383f7812ULL, 0x000fe200078ee233ULL, 0x0000000830337836ULL, 0x000fe20000000000ULL,
0x0000000c55387210ULL, 0x000fe20007f1e0ffULL, 0x00000001310c7824ULL, 0x100fe400078e0232ULL,
0x0000000133307824ULL, 0x100fe400078e0232ULL, 0x00000001393b7824ULL, 0x040fe200078e020dULL,
0x0000000c55317210ULL, 0x000fe20007f3e0ffULL, 0x00000008393c7824ULL, 0x040fe200078e00ffULL,
0x00000030553e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000139327824ULL, 0x000fc400078e0232ULL,
0x00000001333a7824ULL, 0x040fe200078e020dULL, 0xfffffff83c3b7812ULL, 0x000fe200078ee23bULL,
0x0000000833577824ULL, 0x000fe200078e00ffULL, 0x00000032550c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0x0000000838337c11ULL, 0x040fe2000f8038ffULL,
0x000000100d3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff857557812ULL, 0x000fe200078ee23aULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x0000000938327c11ULL, 0x000fe200080f3c39ULL,
0x000000103d3d7824ULL, 0x100fe200078e0254ULL, 0x0000000831597c11ULL, 0x000fe2000f8038ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0254ULL, 0x000000703c3c7812ULL, 0x000fe200078ec0ffULL,
0x0000001055557824ULL, 0x100fe200078e0254ULL, 0x000000083e397c11ULL, 0x000fe2000f8238ffULL,
0x000000103b577824ULL, 0x000fe200078e0254ULL, 0x0000000931547c11ULL, 0x000fe200080f3c30ULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x0000003c33307210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x000000080c3b7c11ULL, 0x000fc4000f8438ffULL,
0x000000093e3e7c11ULL, 0x000fe200088f3c31ULL, 0x000000ffff317224ULL, 0x000fe200000e0632ULL,
0x0000003c59327210ULL, 0x000fe40007f1e0ffULL, 0x000000090c0c7c11ULL, 0x000fe400090f3c33ULL,
0x0000003c39387210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0654ULL,
0x0000003c3b3a7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303d7faeULL, 0x0003e4000b901c46ULL, 0x000000ffff397224ULL, 0x000fc400008e063eULL,
0x000000ffff3b7224ULL, 0x000fe200010e060cULL, 0x00000000323f7faeULL, 0x0003e8000b901c46ULL,
0x0000000038557faeULL, 0x0003e8000b901c46ULL, 0x000000003a577faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000205317836ULL, 0x000fe40000000000ULL,
0x00000001ff327424ULL, 0x000fe400078e00ffULL, 0xffffffffff0c7424ULL, 0x000fe200078e00ffULL,
0x000000343100720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00008c00ff307b82ULL, 0x000e620000000a00ULL, 0x0000000208337810ULL, 0x000fca0007ffe005ULL,
0x0000000433307825ULL, 0x002fca00078e0030ULL, 0x00000006300c7981ULL, 0x000324000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0176a832415879a7ULL, 0x0004e2000850003fULL, 0x01764832463079a7ULL, 0x002464000850003fULL,
0x0000000000327805ULL, 0x004fce0000015200ULL, 0x01764831460075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x00000038323b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e33ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01764831460075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000001003c317810ULL, 0x000fe20007ffe045ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0x000000ffff557224ULL, 0x000fe400078e0052ULL, 0x0000000144317824ULL, 0x000fca00078e0231ULL,
0x0170000031337984ULL, 0x000e680000000800ULL, 0x0172000031307984ULL, 0x0004a20000000800ULL,
0x000000523300720bULL, 0x002fda0003f1d000ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x0000000235327811ULL, 0x000fe400078ff0ffULL, 0x000000523300720bULL, 0x000fe40003f14000ULL,
0x000000353200720cULL, 0x000fd60003f25270ULL, 0x0000000000387806ULL, 0x000fe400000e0100ULL,
0x00000080353b9824ULL, 0x000fe200078e020eULL, 0x0000003352319209ULL, 0x000fe40007810000ULL,
0x0000991038327816ULL, 0x000fe400000000ffULL, 0x0000003b443c9210ULL, 0x000fe40007ffe03cULL,
0x000000ff3200720cULL, 0x000fc60003f05270ULL, 0x017400313c009388ULL, 0x0003f40000000800ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000003352317209ULL, 0x000fe40007810000ULL,
0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL,
0x8000003152317221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100327308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x002fcc000001160dULL, 0x00001f3132317589ULL, 0x004e6400000e0000ULL,
0x0000003128287220ULL, 0x082fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003110107220ULL, 0x080fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000003207077220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x000000080d317811ULL, 0x002fcc00078ff0ffULL, 0x00001f3132317589ULL, 0x000e6400000e0000ULL,
0x000000312a2a7220ULL, 0x082fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x0000003112127220ULL, 0x080fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff38ff7812ULL, 0x000fe20007800839ULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x0000003352557209ULL, 0x000fd60007810000ULL, 0x8000005533330221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL,
0x0000003300020308ULL, 0x000ea40000000800ULL, 0x0000000230300220ULL, 0x004fce0000410000ULL,
0x0000000730077221ULL, 0x000fce0000010000ULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x0176a8534f0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0176a8534f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991038307816ULL, 0x000fe200000000ffULL,
0x0000100004317824ULL, 0x000fe400078e00ffULL, 0x0000000151507824ULL, 0x040fe200078e0250ULL,
0x000000ff3000720cULL, 0x000fe20003f05270ULL, 0x0000000851517824ULL, 0x000fe200078e00ffULL,
0x0000100031337812ULL, 0x000fe200078ec0ffULL, 0x000020000b327824ULL, 0x000fc600078e020eULL,
0xfffffff851317812ULL, 0x000fe400078ee250ULL, 0x0001300032507810ULL, 0x000fca0007ffe033ULL,
0x00000010313c7824ULL, 0x000fe200078e0250ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x012000004330783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000104d387824ULL, 0x000fcc00078e0250ULL,
0x000000003838783bULL, 0x000f640000004200ULL, 0x00000018ff627819ULL, 0x022fe2000001143cULL,
0x000001003c547824ULL, 0x040fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe2000001143dULL,
0x000001003d567824ULL, 0x040fe200078e00ffULL, 0x000088803c657816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d687816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000006200627306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff537819ULL, 0x008fe40000011438ULL,
0x00008880385a7816ULL, 0x000fe200000000ffULL, 0x00000054006a7306ULL, 0x0003e20000202400ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff5c7819ULL, 0x000fe4000001143fULL,
0x000088803f647816ULL, 0x000fc400000000ffULL, 0x00000018ff527819ULL, 0x000fe20000011439ULL,
0x0000003c00677306ULL, 0x0007e20000202400ULL, 0x000001003e547824ULL, 0x042fe200078e00ffULL,
0x000088803e637816ULL, 0x040fe400000000ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001143eULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000003d00697306ULL, 0x0003e20000202400ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc4000001143aULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x00000100383d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe4000001143bULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fce0000011438ULL,
0x00000056006d7306ULL, 0x0002f00000202400ULL, 0x0000005400667306ULL, 0x000fe20000202400ULL,
0x0000888039567816ULL, 0x002fce00000000ffULL, 0x0000003c006b7306ULL, 0x0003f00000202400ULL,
0x0000003800547306ULL, 0x000be20000202400ULL, 0x00000100393c7824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001143cULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x000001003b387824ULL, 0x024fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003f005f7306ULL, 0x000ff00000202400ULL,
0x0000003900577306ULL, 0x0007f00000202400ULL, 0x00000038003f7306ULL, 0x0005e20000202400ULL,
0x0000541068397816ULL, 0x008fce000000006dULL, 0x0000006300637306ULL, 0x000ee20000202400ULL,
0x0000541065387816ULL, 0x004fce000000006aULL, 0x0000006400647306ULL, 0x000ea20000202400ULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x0000541067387816ULL, 0x000fe20000000062ULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x0000541069397816ULL, 0x002fce0000000060ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x000000383024723cULL, 0x000fee0000041824ULL,
0x0000003e00617306ULL, 0x0003620000202400ULL, 0x0000541063387816ULL, 0x008fe40000000066ULL,
0x0000541064397816ULL, 0x004fca000000006bULL, 0x0000003d005b7306ULL, 0x0005e20000202400ULL,
0x000088803b3e7816ULL, 0x042fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383020723cULL, 0x000fe80000041820ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005a005a7306ULL, 0x000e620000202400ULL, 0x000001003a3d7824ULL, 0x044fe200078e00ffULL,
0x0000541061387816ULL, 0x020fe2000000005eULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000054105f397816ULL, 0x000fc4000000005cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005600567306ULL, 0x000fe20000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038301c723cULL, 0x000fea000004181cULL, 0x0000005d005d7306ULL, 0x000ea40000202400ULL,
0x000054105a387816ULL, 0x002fcc000000005bULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541056397816ULL, 0x004fce000000005dULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x000000383018723cULL, 0x000fee0000041818ULL, 0x0000005300537306ULL, 0x000ea20000202400ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000005200527306ULL, 0x000e620000202400ULL,
0x0000541054387816ULL, 0x004fce0000000053ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x0000541057397816ULL, 0x002fce0000000052ULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x000000383014723cULL, 0x000fee0000041814ULL, 0x0000003e003e7306ULL, 0x000e700000202400ULL,
0x0000003a003a7306ULL, 0x000ea20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000003b00607306ULL, 0x000e620000202400ULL, 0x0000003c3010723cULL, 0x000fe20000041810ULL,
0x000054103a3a7816ULL, 0x004fcc000000004dULL, 0x000000104b3c7824ULL, 0x000fe200078e0250ULL,
0x00005410603b7816ULL, 0x002fce0000000051ULL, 0x0000003a302c723cULL, 0x000fe2000004182cULL,
0x012000003730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000001049387824ULL, 0x000fcc00078e0250ULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x00000018ff5f7819ULL, 0x008fe2000001143cULL, 0x000001003c527824ULL, 0x040fe200078e00ffULL,
0x000088803c627816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001143dULL, 0x000001003d537824ULL, 0x040fe200078e00ffULL,
0x000088803d647816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff517819ULL, 0x022fe20000011438ULL,
0x0000003c00667306ULL, 0x0003e20000202400ULL, 0x00000018ff4d7819ULL, 0x000fe40000011439ULL,
0x0000888038567816ULL, 0x000fe400000000ffULL, 0x000088803e607816ULL, 0x000fc400000000ffULL,
0x000088803f637816ULL, 0x040fe200000000ffULL, 0x0000005200677306ULL, 0x0007620000202400ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001143eULL,
0x00000018ff5b7819ULL, 0x000fe2000001143fULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x000001003e527824ULL, 0x048fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc4000001143aULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000005300697306ULL, 0x0002e20000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff4b7819ULL, 0x000fca000001143bULL,
0x0000003d00687306ULL, 0x0007e20000202400ULL, 0x0000888039537816ULL, 0x002fce00000000ffULL,
0x0000003c006a7306ULL, 0x0003e20000202400ULL, 0x00000100383d7824ULL, 0x04cfe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005f005f7306ULL, 0x000ea20000202400ULL, 0x00000100393c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001143cULL, 0x0000005d005d7306ULL, 0x000e620000202400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a3c7816ULL, 0x000fca00000000ffULL,
0x0000005200617306ULL, 0x000ff00000202400ULL, 0x0000003800547306ULL, 0x000bf00000202400ULL,
0x0000003900527306ULL, 0x0007e20000202400ULL, 0x0000541062387816ULL, 0x020fce0000000067ULL,
0x0000006000607306ULL, 0x000f620000202400ULL, 0x0000541064397816ULL, 0x008fce0000000069ULL,
0x0000006300637306ULL, 0x000ee20000202400ULL, 0x000000383028723cULL, 0x000fee0000041828ULL,
0x0000541066387816ULL, 0x004fe2000000005fULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x0000541068397816ULL, 0x002fe2000000005dULL, 0x00000001ff5d7424ULL, 0x000fcc00078e00ffULL,
0x0000003e00657306ULL, 0x0002a20000202400ULL, 0x000000383024723cULL, 0x000fee0000041824ULL,
0x0000003d00577306ULL, 0x0005e20000202400ULL, 0x000088803b3e7816ULL, 0x002fe400000000ffULL,
0x0000541060387816ULL, 0x020fc40000000061ULL, 0x0000541063397816ULL, 0x008fc6000000006aULL,
0x0000003f005e7306ULL, 0x0003e20000202400ULL, 0x000001003a3d7824ULL, 0x044fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000000383020723cULL, 0x000fe40000041820ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005b005b7306ULL, 0x000ea20000202400ULL,
0x000001003b3f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x0000541065387816ULL, 0x000fc4000000005cULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000054105e397816ULL, 0x004fe2000000005bULL,
0x000000080b5b7824ULL, 0x000fcc00078e020eULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x00000038301c723cULL, 0x000fee000004181cULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000004d004d7306ULL, 0x000ff00000202400ULL,
0x0000004900497306ULL, 0x000ff00000202400ULL, 0x0000004b004b7306ULL, 0x000ff00000202400ULL,
0x0000005600567306ULL, 0x000e700000202400ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x0000541056387816ULL, 0x002fce0000000057ULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x0000000205577836ULL, 0x000fce0000000000ULL, 0x0000003e003e7306ULL, 0x000fe20000202400ULL,
0x0000541053397816ULL, 0x002fce000000005aULL, 0x0000003f003f7306ULL, 0x000e620000202400ULL,
0x000000ffff537224ULL, 0x000fe200078e0059ULL, 0x000000383018723cULL, 0x000fec0000041818ULL,
0x0000003a00627306ULL, 0x0004e20000202400ULL, 0x0176c85d5b3879a7ULL, 0x000b62000850003fULL,
0x000054103e3d7816ULL, 0x002fcc000000003fULL, 0x0000003b005c7306ULL, 0x0003620000202400ULL,
0x00005410543a7816ULL, 0x004fe20000000051ULL, 0x0176985d40ff79a7ULL, 0x0005e2000850003fULL,
0x0000003c3010723cULL, 0x000fe20000041810ULL, 0x0000541062627816ULL, 0x008fe40000000049ULL,
0x00005410523b7816ULL, 0x002fe2000000004dULL, 0x000000ffff527224ULL, 0x000fe200078e0055ULL,
0x000054105c637816ULL, 0x020fca000000004bULL, 0x0000003a3014723cULL, 0x000fec0000041814ULL,
0x00000062302c723cULL, 0x000fee000004182cULL, 0x000000c006317811ULL, 0x000fe200078e40ffULL,
0x000000ffff307224ULL, 0x000fc600078e0042ULL, 0x000000363100720cULL, 0x000fda0003f06070ULL,
0x0000002000740947ULL, 0x004fea0003800000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x00000039470075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x00000039470075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000206327836ULL, 0x000fe20000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000010006307824ULL, 0x000fe400078e0209ULL,
0x000000040c317c24ULL, 0x010fe2000f8e02ffULL, 0x0000000f3200720cULL, 0x000fe20003f06070ULL,
0x0000010030337836ULL, 0x000fe40000000000ULL, 0x0000008031307824ULL, 0x000fc600078e00ffULL,
0x000000600a397812ULL, 0x000fce00078ef833ULL, 0x0000000400248947ULL, 0x000fea0003800000ULL,
0x0000003336317248ULL, 0x000fe20007fe0000ULL, 0x0000001035327824ULL, 0x000fe200078e00ffULL,
0x00008a0000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000131317824ULL, 0x000fe200078e0a33ULL,
0x0000001032327812ULL, 0x000fe400078ec0ffULL, 0x00000003ff337819ULL, 0x000fe4000001160dULL,
0x0000003132317248ULL, 0x000fc60007fe0000ULL, 0x0000000133387824ULL, 0x100fe400078e0232ULL,
0x0000000131317824ULL, 0x100fe400078e0a32ULL, 0x00000004333a7836ULL, 0x000fe40000000000ULL,
0x00000008333b7836ULL, 0x000fe20000000000ULL, 0x000000313300720cULL, 0x080fe20003f66070ULL,
0x0000000c333f7836ULL, 0x000fe20000000000ULL, 0x000000313a00720cULL, 0x080fe20003f46070ULL,
0x0000000138337824ULL, 0x000fe200078e0239ULL, 0x000000313b00720cULL, 0x000fe20003f26070ULL,
0x000000013a3c7824ULL, 0x000fc400078e0232ULL, 0x000000013b3e7824ULL, 0x100fe200078e0232ULL,
0x0000003330337210ULL, 0x000fe20007f1e0ffULL, 0x000000013f427824ULL, 0x000fe400078e0232ULL,
0x0000000138327824ULL, 0x040fe200078e020dULL, 0x00000008333d7c11ULL, 0x000fe2000f8838ffULL,
0x00000008383b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0x000000313f00720cULL, 0x000fe20003f06070ULL, 0x000000013c317824ULL, 0x040fe200078e0239ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee232ULL, 0x000000013c3a7824ULL, 0x140fe200078e020dULL,
0x0000000933387c11ULL, 0x000fe2000a0f3c38ULL, 0x000000083c477824ULL, 0x000fe200078e00ffULL,
0x0000003130317210ULL, 0x000fe20007fbe0ffULL, 0x00000001423c7824ULL, 0x000fc400078e020dULL,
0x0000000842497824ULL, 0x000fe200078e00ffULL, 0xfffffff8473f7812ULL, 0x000fe200078ee23aULL,
0x000000100d3a7824ULL, 0x000fe400078e00ffULL, 0x000000013e337824ULL, 0x040fe200078e0239ULL,
0xfffffff849497812ULL, 0x000fe200078ee23cULL, 0x000000013e327824ULL, 0x000fe200078e020dULL,
0x000000703a3a7812ULL, 0x000fe200078ec0ffULL, 0x000000083e477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe200028e06ffULL, 0x00000008314d7c11ULL, 0x000fe2000f8a38ffULL,
0x0000000142397824ULL, 0x000fe200078e0239ULL, 0x0000003330427210ULL, 0x000fe20007f9e0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0250ULL, 0xfffffff847477812ULL, 0x000fe200078ee232ULL,
0x000000103f3f7824ULL, 0x000fe200078e0250ULL, 0x00000009313c7c11ULL, 0x000fe2000a8f3c3cULL,
0x000000ffff4b7224ULL, 0x000fe200020e06ffULL, 0x0000003a3d327210ULL, 0x000fe20007fbe0ffULL,
0x0000001047477824ULL, 0x100fe200078e0250ULL, 0x0000003930397210ULL, 0x000fe20007fde0ffULL,
0x0000001049497824ULL, 0x000fe200078e0250ULL, 0x0000000842317c11ULL, 0x000fe2000f8838ffULL,
0x000000ffff337224ULL, 0x000fe200028e0638ULL, 0x0000003a4d307210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200030e06ffULL, 0x00000008393d7c11ULL, 0x000fc4000f8c38ffULL,
0x0000000942427c11ULL, 0x000fe2000a0f3c4bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000323b7faeULL, 0x0003e2000d901c46ULL, 0x0000003a31387210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e063cULL, 0x00000009393e7c11ULL, 0x000fe4000b0f3c3eULL,
0x0000003a3d3c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff397224ULL, 0x000fe200020e0642ULL,
0x00000000303f7faeULL, 0x0003e6000d101c46ULL, 0x000000ffff3d7224ULL, 0x000fe200028e063eULL,
0x0000000038477faeULL, 0x0003e8000c901c46ULL, 0x000000003c497faeULL, 0x0003e2000c101c46ULL,
0x0000000000f07947ULL, 0x000fea0003800000ULL, 0x0000001035317824ULL, 0x000fe200078e00ffULL,
0x00008a0000087ab9ULL, 0x000fc80000000a00ULL, 0x0000001031327812ULL, 0x000fc800078ec0ffULL,
0x000000320d327211ULL, 0x000fca00078fe8ffULL, 0x0000000432387836ULL, 0x000fe40000000000ULL,
0x0000000132317824ULL, 0x140fe400078e020dULL, 0x00000008323a7824ULL, 0x000fe400078e00ffULL,
0x0000000138337824ULL, 0x040fe400078e020dULL, 0x00000008383c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3b7812ULL, 0x000fe200078ee231ULL, 0x0000000132317824ULL, 0x000fc400078e0239ULL,
0x00000008323a7836ULL, 0x000fe20000000000ULL, 0xfffffff83c3f7812ULL, 0x000fe200078ee233ULL,
0x0000000c323c7836ULL, 0x000fe20000000000ULL, 0x0000003130327210ULL, 0x000fe20007f1e0ffULL,
0x000000013a337824ULL, 0x100fe400078e0239ULL, 0x0000000138317824ULL, 0x000fe400078e0239ULL,
0x000000013a387824ULL, 0x140fe200078e020dULL, 0x0000003330427210ULL, 0x000fe20007f5e0ffULL,
0x000000083a477824ULL, 0x000fe200078e00ffULL, 0x0000003130317210ULL, 0x000fe20007f3e0ffULL,
0x000000013c3a7824ULL, 0x000fc400078e020dULL, 0x000000083c497824ULL, 0x040fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee238ULL, 0x000000013c397824ULL, 0x000fe400078e0239ULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x00000008323d7c11ULL, 0x040fe2000f8038ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0250ULL, 0xfffffff849497812ULL, 0x000fe200078ee23aULL,
0x000000100d3a7824ULL, 0x000fe200078e00ffULL, 0x0000003930397210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x0000000932327c11ULL, 0x000fe200080f3c33ULL,
0x000000103f3f7824ULL, 0x100fe200078e0250ULL, 0x00000008314b7c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x000000703a3a7812ULL, 0x000fe200078ec0ffULL,
0x0000001047477824ULL, 0x000fe200078e0250ULL, 0x00000009314d7c11ULL, 0x000fe200080f3c30ULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x0000000842337c11ULL, 0x000fe2000f8238ffULL,
0x0000001049497824ULL, 0x000fe200078e0250ULL, 0x0000003a3d307210ULL, 0x000fc40007f1e0ffULL,
0x00000008393d7c11ULL, 0x040fe4000f8438ffULL, 0x0000000942427c11ULL, 0x000fe200088f3c31ULL,
0x000000ffff317224ULL, 0x000fe200000e0632ULL, 0x0000003a4b327210ULL, 0x000fe40007f1e0ffULL,
0x00000009393e7c11ULL, 0x000fe400090f3c3eULL, 0x0000003a33387210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e064dULL, 0x0000003a3d3c7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303b7faeULL, 0x0003e4000b901c46ULL,
0x000000ffff397224ULL, 0x000fc400008e0642ULL, 0x000000ffff3d7224ULL, 0x000fe200010e063eULL,
0x00000000323f7faeULL, 0x0003e8000b901c46ULL, 0x0000000038477faeULL, 0x0003e8000b901c46ULL,
0x000000003c497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0176a8384f5279a7ULL, 0x0002a4000850003fULL,
0x01766838463879a7ULL, 0x0022e4000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01766839460075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3c7224ULL, 0x000fce00078e00ffULL, 0x000000103c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013c3c7836ULL, 0x000fce0000000000ULL, 0x01766839460075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000001803a457810ULL, 0x000fe20007ffe045ULL,
0x00000001ff387424ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x004fe400078e0055ULL,
0x0000000144457824ULL, 0x000fca00078e0245ULL, 0x0170000045307984ULL, 0x000ea80000000800ULL,
0x0172000045317984ULL, 0x0006e20000000800ULL, 0x000000553000720bULL, 0x004fda0003f1d000ULL,
0x0000000000337806ULL, 0x000fc800000e0100ULL, 0x0000ffff33ff7812ULL, 0x000fda000780c0ffULL,
0x0000000000f88947ULL, 0x00afea0003800000ULL, 0x0000000335327811ULL, 0x000fe400078ff0ffULL,
0x000000553000720bULL, 0x000fe40003f14000ULL, 0x000000353200720cULL, 0x000fe40003f25270ULL,
0x0000005530527209ULL, 0x000fd20007810000ULL, 0x0000000000387806ULL, 0x000fe400000e0100ULL,
0x0000008035399824ULL, 0x000fe400078e020eULL, 0x0000991038327816ULL, 0x000fc600000000ffULL,
0x0000003944399210ULL, 0x000fe40007ffe03aULL, 0x000000ff3200720cULL, 0x000fc60003f05270ULL,
0x0174005239009388ULL, 0x0003f40000000800ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000005552327221ULL, 0x000fe20000010100ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b32327820ULL, 0x000fc80000410000ULL,
0x00000032003a7308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff397819ULL, 0x000fca000001160dULL, 0x00001f393a327589ULL, 0x006e6400000e0000ULL,
0x0000003228287220ULL, 0x082fe20000410000ULL, 0x0000003229297220ULL, 0x080fe20000410000ULL,
0x0000003224247220ULL, 0x080fe20000410000ULL, 0x0000003225257220ULL, 0x080fe20000410000ULL,
0x0000003220207220ULL, 0x080fe20000410000ULL, 0x0000003221217220ULL, 0x080fe20000410000ULL,
0x000000321c1c7220ULL, 0x080fe20000410000ULL, 0x000000321d1d7220ULL, 0x080fe20000410000ULL,
0x0000003218187220ULL, 0x080fe20000410000ULL, 0x0000003219197220ULL, 0x080fe20000410000ULL,
0x0000003214147220ULL, 0x080fe20000410000ULL, 0x0000003215157220ULL, 0x080fe20000410000ULL,
0x0000003210107220ULL, 0x080fe20000410000ULL, 0x0000003211117220ULL, 0x080fe20000410000ULL,
0x000000322c2c7220ULL, 0x080fe20000410000ULL, 0x000000322d2d7220ULL, 0x000fce0000410000ULL,
0x0000003a07077220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x000000080d397811ULL, 0x000fca00078ff0ffULL, 0x00001f393a327589ULL, 0x002e6400000e0000ULL,
0x000000322a2a7220ULL, 0x082fe20000410000ULL, 0x000000322b2b7220ULL, 0x080fe20000410000ULL,
0x0000003226267220ULL, 0x080fe20000410000ULL, 0x0000003227277220ULL, 0x080fe20000410000ULL,
0x0000003222227220ULL, 0x080fe20000410000ULL, 0x0000003223237220ULL, 0x080fe20000410000ULL,
0x000000321e1e7220ULL, 0x080fe20000410000ULL, 0x000000321f1f7220ULL, 0x080fe20000410000ULL,
0x000000321a1a7220ULL, 0x080fe20000410000ULL, 0x000000321b1b7220ULL, 0x080fe20000410000ULL,
0x0000003216167220ULL, 0x080fe20000410000ULL, 0x0000003217177220ULL, 0x080fe20000410000ULL,
0x0000003212127220ULL, 0x080fe20000410000ULL, 0x0000003213137220ULL, 0x080fe20000410000ULL,
0x000000322e2e7220ULL, 0x080fe20000410000ULL, 0x000000322f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff38ff7812ULL, 0x000fe20007800833ULL, 0x00000001ff387424ULL, 0x000fd800078e00ffULL,
0x0000003052300221ULL, 0x000fe20000010100ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL, 0x0000003000020308ULL, 0x000ea40000000800ULL,
0x0000000231310220ULL, 0x004fce0000410000ULL, 0x0000000731077221ULL, 0x000fce0000010000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x0176a859410075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x002fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0176a859410075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000991038307816ULL, 0x000fc800000000ffULL, 0x000000ff3000720cULL, 0x000fda0003f05270ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0004e800000e0000ULL,
0x00001f3130007589ULL, 0x00046400000e0000ULL, 0x012800004330783bULL, 0x0062a20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000004e3c783bULL, 0x000f280000004200ULL,
0x000000004c38783bULL, 0x000b620000004200ULL, 0x000001003c4b7824ULL, 0x010fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe2000001143dULL, 0x000001003d4c7824ULL, 0x062fe200078e00ffULL,
0x000088803d557816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x000001003e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe2000001143cULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x000088803c4d7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fc4000001143eULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000004b005a7306ULL, 0x0003e20000202400ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff437819ULL, 0x008fe40000011438ULL,
0x00000018ff507819ULL, 0x000fe4000001144eULL, 0x00000018ff467819ULL, 0x000fe2000001143fULL,
0x0000004c00607306ULL, 0x0007e20000202400ULL, 0x000088803e4b7816ULL, 0x042fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000088803f4e7816ULL, 0x000fc400000000ffULL,
0x00000018ff447819ULL, 0x000fe40000011439ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000003d005c7306ULL, 0x0003e20000202400ULL, 0x00008880384c7816ULL, 0x048fe400000000ffULL,
0x00000018ff417819ULL, 0x000fe4000001143aULL, 0x00000018ff427819ULL, 0x000fe4000001143bULL,
0x0000888039517816ULL, 0x000fe200000000ffULL, 0x0000003c00547306ULL, 0x0007e20000202400ULL,
0x00000100383d7824ULL, 0x002fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00567306ULL, 0x0003e20000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004d004d7306ULL, 0x000fe20000202400ULL, 0x000001003a3e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc8000001143fULL, 0x00000018ff5d7819ULL, 0x000fe4000001143eULL,
0x0000005500557306ULL, 0x000e620000202400ULL, 0x000088803b3e7816ULL, 0x000fce00000000ffULL,
0x0000003c005b7306ULL, 0x0007f00000202400ULL, 0x0000003d004f7306ULL, 0x0009e20000202400ULL,
0x00000100393c7824ULL, 0x048fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003800587306ULL, 0x0007e20000202400ULL,
0x000088803a3d7816ULL, 0x050fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fc80000011439ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000004700477306ULL, 0x000f220000202400ULL, 0x000001003b387824ULL, 0x048fe400078e00ffULL,
0x000100003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000003f00577306ULL, 0x000ff00000202400ULL,
0x0000003c005e7306ULL, 0x000ff00000202400ULL, 0x0000003900597306ULL, 0x0003f00000202400ULL,
0x00000038003f7306ULL, 0x0007e20000202400ULL, 0x0000541055397816ULL, 0x002fce0000000060ULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x000054104d387816ULL, 0x008fce000000005aULL,
0x0000005d003c7306ULL, 0x000e620000202400ULL, 0x000000383028723cULL, 0x004fee0000041828ULL,
0x0000004500457306ULL, 0x000ea20000202400ULL, 0x0000541054387816ULL, 0x010fe40000000047ULL,
0x000054105c397816ULL, 0x000fc40000000049ULL, 0x000054103d3c7816ULL, 0x002fc6000000003cULL,
0x0000004600467306ULL, 0x000e640000202400ULL, 0x000000383024723cULL, 0x000fe20000041824ULL,
0x0000541056567816ULL, 0x004fca0000000045ULL, 0x0000004300437306ULL, 0x000ea20000202400ULL,
0x0000541057577816ULL, 0x002fce0000000046ULL, 0x0000004400447306ULL, 0x000e620000202400ULL,
0x00000056301c723cULL, 0x000fe2000004181cULL, 0x0000541058587816ULL, 0x004fcc0000000043ULL,
0x0000004100417306ULL, 0x000fe20000202400ULL, 0x0000541059597816ULL, 0x002fce0000000044ULL,
0x0000004200427306ULL, 0x000fe20000202400ULL, 0x000000583014723cULL, 0x000fee0000041814ULL,
0x0000004b004b7306ULL, 0x000ff00000202400ULL, 0x0000005000507306ULL, 0x000e700000202400ULL,
0x0000004e004e7306ULL, 0x000ea20000202400ULL, 0x000054104b387816ULL, 0x002fce0000000050ULL,
0x0000004c004c7306ULL, 0x000e620000202400ULL, 0x000054104e397816ULL, 0x004fce000000005bULL,
0x0000005100517306ULL, 0x000ea20000202400ULL, 0x000000383020723cULL, 0x000fe20000041820ULL,
0x000054104c4c7816ULL, 0x002fcc000000004fULL, 0x0000003e003e7306ULL, 0x000e620000202400ULL,
0x00005410514d7816ULL, 0x004fce000000005eULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x0000004c3018723cULL, 0x000fe20000041818ULL, 0x000054103e3d7816ULL, 0x002fcc000000003fULL,
0x0000003b003b7306ULL, 0x000e620000202400ULL, 0x0000003c3010723cULL, 0x000fe20000041810ULL,
0x000054103a3a7816ULL, 0x004fe40000000041ULL, 0x000054103b3b7816ULL, 0x002fce0000000042ULL,
0x0000003a302c723cULL, 0x000fe2000004182cULL, 0x012800003730783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000004a3c783bULL, 0x000ee80000004200ULL, 0x000000004838783bULL, 0x0009620000004200ULL,
0x00000018ff467819ULL, 0x008fe2000001143cULL, 0x000001003c487824ULL, 0x050fe200078e00ffULL,
0x000088803c547816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe2000001143dULL, 0x000001003d497824ULL, 0x040fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x000001003e4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x000088803d567816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x000001003a5a7824ULL, 0x022fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fc4000001144aULL, 0x00000018ff447819ULL, 0x000fe2000001143eULL,
0x0000003c00557306ULL, 0x0003e20000202400ULL, 0x00000018ff457819ULL, 0x000fe4000001143fULL,
0x000088803f4a7816ULL, 0x040fe400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff427819ULL, 0x000fe20000011438ULL, 0x0000004800577306ULL, 0x0007220000202400ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011439ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fc4000001143aULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x000088803e487816ULL, 0x048fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001143fULL, 0x00008880393f7816ULL, 0x000fe400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001143eULL, 0x0000004900597306ULL, 0x000e620000202400ULL,
0x00008880383e7816ULL, 0x000fc400000000ffULL, 0x000088803b5b7816ULL, 0x000fe400000000ffULL,
0x00000018ff417819ULL, 0x000fe4000001143bULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000003d00587306ULL, 0x0007f00000202400ULL, 0x0000003c00517306ULL, 0x000be20000202400ULL,
0x00000100383d7824ULL, 0x008fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004600467306ULL, 0x000ee20000202400ULL,
0x00000100393c7824ULL, 0x064fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004700477306ULL, 0x000ea20000202400ULL, 0x00000018ff397819ULL, 0x000fce0000011439ULL,
0x00000038004b7306ULL, 0x0009f00000202400ULL, 0x00000039004c7306ULL, 0x0003e20000202400ULL,
0x0000541054387816ULL, 0x010fe20000000057ULL, 0x000000ffff547224ULL, 0x000fc400078e005bULL,
0x0000000205577836ULL, 0x000fc80000000000ULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x0000541056397816ULL, 0x002fe20000000059ULL, 0x000001003b567824ULL, 0x040fe400078e00ffULL,
0x000100003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000004f004f7306ULL, 0x000e620000202400ULL, 0x000000383028723cULL, 0x000fe20000041828ULL,
0x00000018ff3b7819ULL, 0x000fcc000001143bULL, 0x0000004a004a7306ULL, 0x000f220000202400ULL,
0x0000541055387816ULL, 0x008fe40000000046ULL, 0x0000541058397816ULL, 0x004fca0000000047ULL,
0x0000003e003e7306ULL, 0x000fe40000202400ULL, 0x000000383024723cULL, 0x000fec0000041824ULL,
0x0000003d00497306ULL, 0x0004e20000202400ULL, 0x0000541048387816ULL, 0x002fe4000000004fULL,
0x000054104a397816ULL, 0x010fca0000000051ULL, 0x0000003f003f7306ULL, 0x000fe20000202400ULL,
0x000088803a3d7816ULL, 0x044fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000000383020723cULL, 0x000fe20000041820ULL, 0x000054103e3e7816ULL, 0x008fc80000000049ULL,
0x0000003c00507306ULL, 0x000e620000202400ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x000000080b387824ULL, 0x000fcc00078e020eULL, 0x0000004400447306ULL, 0x000fe20000202400ULL,
0x000054103f3f7816ULL, 0x002fce0000000050ULL, 0x0000004500457306ULL, 0x000fe20000202400ULL,
0x0000003e3018723cULL, 0x000fee0000041818ULL, 0x0000004d004d7306ULL, 0x000e620000202400ULL,
0x00000001ff3f7424ULL, 0x000fce00078e00ffULL, 0x0000004e004e7306ULL, 0x000ea20000202400ULL,
0x0176c83f383879a7ULL, 0x0006e2000850003fULL, 0x000054104d447816ULL, 0x002fcc0000000044ULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x0176a03f40ff79a7ULL, 0x0007e2000850003fULL,
0x000054104e457816ULL, 0x004fcc0000000045ULL, 0x0000005a003c7306ULL, 0x000e620000202400ULL,
0x00000044301c723cULL, 0x000fee000004181cULL, 0x0000004200427306ULL, 0x000ea20000202400ULL,
0x000054103d3c7816ULL, 0x002fce000000003cULL, 0x0000004300437306ULL, 0x000e620000202400ULL,
0x000054104b427816ULL, 0x004fce0000000042ULL, 0x0000003700377306ULL, 0x000fe20000202400ULL,
0x000054104c437816ULL, 0x002fce0000000043ULL, 0x0000004100417306ULL, 0x000fe20000202400ULL,
0x000000423014723cULL, 0x000fee0000041814ULL, 0x0000005400547306ULL, 0x000ff00000202400ULL,
0x0000005600477306ULL, 0x000e700000202400ULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x00005410543d7816ULL, 0x002fce0000000047ULL, 0x0000003b00447306ULL, 0x000e620000202400ULL,
0x0000003c3010723cULL, 0x000fe20000041810ULL, 0x000054103a3a7816ULL, 0x004fe40000000037ULL,
0x00005410443b7816ULL, 0x002fce0000000041ULL, 0x0000003a302c723cULL, 0x000fee000004182cULL,
0x0000000104307812ULL, 0x008fde00078ec0ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000106067836ULL, 0x000fca0000000000ULL, 0x0000000f0600720cULL, 0x000fda0003f06070ULL,
0xffffff7000008947ULL, 0x000fea000383ffffULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x000000ffff307224ULL, 0x000fe400078e0014ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0019ULL,
0x000000ffff0d7224ULL, 0x000fd000078e0018ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000007007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000a65000047802ULL, 0x000fce0000000f00ULL,
0x00000074005c7944ULL, 0x016fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x008fc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009400ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x028ee2000c1e9900ULL, 0x0000000000057919ULL, 0x000f640000000000ULL,
0x00000002ff077819ULL, 0x026fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x008fca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000002804287220ULL, 0x042fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x000fe20000410000ULL, 0x0000002a052a7220ULL, 0x044fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001705177220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000000135357812ULL, 0x000fe400078ec0ffULL, 0x000000301515723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00001000350e7824ULL, 0x000fe200078e020eULL,
0x000000101110723eULL, 0x000fc400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f11723eULL, 0x000fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fe400000010ffULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000ff0b00720cULL, 0x000fc40003f05270ULL, 0x00005410121e7816ULL, 0x140fe4000000002eULL,
0x00007632121f7816ULL, 0x000fe4000000002eULL, 0x00000002ff057819ULL, 0x108fe20000011600ULL,
0x0000000109097824ULL, 0x000fe200078e0200ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x00000008050a7824ULL, 0x040fe200078e00ffULL,
0x0000000502037211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x010fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x0000000807197824ULL, 0x000fc400078e00ffULL,
0x0000000805077824ULL, 0x000fe400078e00ffULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff819087812ULL, 0x000fe200078ee204ULL, 0x0000000800047824ULL, 0x000fe400078e00ffULL,
0x0000001009097824ULL, 0x000fe200078e020eULL, 0xfffffff807067812ULL, 0x000fe200078ee202ULL,
0x0000000805027824ULL, 0x000fe400078e00ffULL, 0x0000000403057836ULL, 0x000fc40000000000ULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0xfffffff802027812ULL, 0x000fe200078ee203ULL,
0x000008000b037824ULL, 0x000fe200078e020eULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000001008147824ULL, 0x100fe200078e0203ULL,
0x0000000804057812ULL, 0x000fe200078ec0ffULL, 0x0000001002047824ULL, 0x100fe200078e0203ULL,
0x000000282902723eULL, 0x000fe200000010ffULL, 0x0000001006087824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x100fe400078e0203ULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x000000242503723eULL, 0x000fe200000010ffULL, 0x0000000104067824ULL, 0x000fe200078e0205ULL,
0x0000000d0f04723eULL, 0x000fe200000010ffULL, 0x0000000105077824ULL, 0x040fe200078e0208ULL,
0x0000541002187816ULL, 0x140fe20000000003ULL, 0x0000000105147824ULL, 0x040fe200078e0214ULL,
0x0000763202197816ULL, 0x000fe20000000003ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x000000202102723eULL, 0x000fe200000010ffULL, 0x00000001050c7824ULL, 0x000fe200078e020cULL,
0x0000001c1d03723eULL, 0x000fe200000010ffULL, 0x0000001806007388ULL, 0x0007e20000000a00ULL,
0x0000002c2d08723eULL, 0x000fc400000010ffULL, 0x00000016170d723eULL, 0x000fe400000010ffULL,
0x0000763210057816ULL, 0x000fe40000000008ULL, 0x000054101a1c7816ULL, 0x140fe4000000000dULL,
0x000076321a1d7816ULL, 0x000fe4000000000dULL, 0x0000541002187816ULL, 0x148fe40000000003ULL,
0x0000763202197816ULL, 0x000fc40000000003ULL, 0x0000002a2b02723eULL, 0x000fe400000010ffULL,
0x000000262703723eULL, 0x000fe200000010ffULL, 0x0000001807007388ULL, 0x0007e40000000a00ULL,
0x0000541004187816ULL, 0x148fe40000000015ULL, 0x0000763204197816ULL, 0x000fe40000000015ULL,
0x0000541010047816ULL, 0x000fc60000000008ULL, 0x000000180a007388ULL, 0x000fe80000000a00ULL,
0x000000040c007388ULL, 0x0007e40000000a00ULL, 0x0000541002047816ULL, 0x148fe40000000003ULL,
0x0000763202057816ULL, 0x000fe40000000003ULL, 0x0000541022027816ULL, 0x000fc40000000011ULL,
0x0000763222037816ULL, 0x000fe20000000011ULL, 0x0000000414007388ULL, 0x000fe80000000a00ULL,
0x0004000207007388ULL, 0x0007e80000000a00ULL, 0x0004001c0a007388ULL, 0x000fe80000000a00ULL,
0x0004001e0c007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff00027306ULL, 0x008ee20000202400ULL, 0x0000000009107984ULL, 0x000ee80000000c00ULL,
0x0004000009147984ULL, 0x000f280000000c00ULL, 0x0008000009047984ULL, 0x000f680000000c00ULL,
0x000c000009187984ULL, 0x000f620000000c00ULL, 0x0000001302137230ULL, 0x008fc40000200800ULL,
0x0000001202127230ULL, 0x040fe40000200800ULL, 0x0000001102117230ULL, 0x040fe40000200800ULL,
0x0000001002107230ULL, 0x040fe40000200800ULL, 0x0000001702177230ULL, 0x054fe40000200800ULL,
0x0000001602167230ULL, 0x040fe40000200800ULL, 0x0000001502157230ULL, 0x000fc40000200800ULL,
0x0000001402027230ULL, 0x000fe40000200800ULL, 0x0000000713137230ULL, 0x022fe40000200000ULL,
0x0000000612127230ULL, 0x000fe40000200000ULL, 0x0000000511117230ULL, 0x000fe40000200000ULL,
0x0000000410107230ULL, 0x000fe40000200000ULL, 0x0000001b17177230ULL, 0x000fc40000200000ULL,
0x0000001a16167230ULL, 0x000fe20000200000ULL, 0x0000001009007388ULL, 0x0003e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000200000ULL, 0x0000001802147230ULL, 0x000fca0000200000ULL,
0x0004001409007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000067836ULL, 0x000fe20000000000ULL,
0x00000003ff117819ULL, 0x002fe20000011600ULL, 0x0000000000107919ULL, 0x000e620000002600ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000003ff057819ULL, 0x000fe20000011606ULL, 0x0000000111027824ULL, 0x000fe200078e0200ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000835137824ULL, 0x040fe400078e00ffULL,
0x0000000106047824ULL, 0x000fe200078e0205ULL, 0x0000000702037812ULL, 0x000fe200078ec0ffULL,
0x0000000835357824ULL, 0x000fc600078e00ffULL, 0x0000000704077812ULL, 0x000fe400078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe400078ef800ULL, 0x0ffffff807077812ULL, 0x000fc600078ef806ULL,
0x0000001003037824ULL, 0x100fe400078e020eULL, 0x0000001007077824ULL, 0x000fc600078e020eULL,
0x0000000003087984ULL, 0x000ee20000000c00ULL, 0x00000005040472a4ULL, 0x004fc6000f8e023fULL,
0x00000000070c7984ULL, 0x0005220000000c00ULL, 0x0000000810027824ULL, 0x042fe400078e00ffULL,
0x0000000810107824ULL, 0x000fc600078e00ffULL, 0xfffffff802027812ULL, 0x000fe400078ee211ULL,
0xfffffff810057812ULL, 0x000fe400078ee205ULL, 0x0000000402117c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe2000ff3e0ffULL, 0x0000860000047ab9ULL, 0x000fe20000000a00ULL,
0xfffffff813077812ULL, 0x004fe200078ee200ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x0000000411027c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc4000f8240ffULL, 0x0000000511037c11ULL, 0x000fe400080f4412ULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0xfffffff835117812ULL, 0x000fe200078ee206ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff057819ULL, 0x004fe20000011635ULL,
0x00009400ff127b82ULL, 0x000e620000000a00ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000340500720cULL, 0x000fe20003f06070ULL, 0xffffffffff077424ULL, 0x000fc600078e00ffULL,
0x0176000b0e0a79a7ULL, 0x0004b2000850003fULL, 0x00009000ff038b82ULL, 0x000ee20000000800ULL,
0x0000000208028824ULL, 0x000fce00078e00ffULL, 0x00008c00ff108b82ULL, 0x000f620000000a00ULL,
0x0000000612067981ULL, 0x002522000c1e9900ULL, 0x0000000302038224ULL, 0x008fc800078e0205ULL,
0x0000000403108825ULL, 0x020fca00078e0010ULL, 0x0000000610078981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000008014007824ULL, 0x000fe400078e00ffULL,
0x0000004035037824ULL, 0x000fe400078e00ffULL, 0x0000008015027824ULL, 0x000fc600078e00ffULL,
0x00000040000c7812ULL, 0x000fe200078ef803ULL, 0x0000000702077224ULL, 0x008fc800078e02ffULL,
0x0000000c00a80947ULL, 0x004fea0003800000ULL, 0x00000003ff117819ULL, 0x000fe2000001160dULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000336107248ULL, 0x000fe40007fe0000ULL,
0x0000007004047812ULL, 0x000fe200078ec0ffULL, 0x000000010c127824ULL, 0x000fe400078e0211ULL,
0x0000000811177836ULL, 0x000fe40000000000ULL, 0x0000000411157836ULL, 0x000fe20000000000ULL,
0x00000012071c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000117137824ULL, 0x000fc400078e020dULL,
0x00000008171a7824ULL, 0x000fe400078e00ffULL, 0x000000010c147824ULL, 0x000fe400078e0215ULL,
0x0000000115097824ULL, 0x040fe200078e020dULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x0000000815187824ULL, 0x000fe200078e00ffULL, 0x0000001407147210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x000000041c1b7c11ULL, 0x000fe2000f8038ffULL,
0x000000010c127824ULL, 0x000fe200078e0217ULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x0000000110107824ULL, 0x000fe200078e0a03ULL, 0x000000051c1c7c11ULL, 0x000fe200080f3c13ULL,
0x0000000c11277836ULL, 0x000fe20000000000ULL, 0x0000001207227210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00000004141f7c11ULL, 0x000fe2000f8238ffULL,
0x000000010c127824ULL, 0x000fe200078e0227ULL, 0x000000101700720cULL, 0x080fe20003fa6070ULL,
0x0000001011137836ULL, 0x000fe20000000000ULL, 0x0000000514207c11ULL, 0x000fe200088f3c09ULL,
0x0000001411177836ULL, 0x000fe20000000000ULL, 0x0000001207127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000000422237c11ULL, 0x000fe2000f8038ffULL,
0x000000010c147824ULL, 0x040fe200078e0213ULL, 0x000000101500720cULL, 0x080fe20003f86070ULL,
0x000000010c167824ULL, 0x000fe200078e0217ULL, 0x0000000522227c11ULL, 0x000fe200080f3c09ULL,
0x000000ffff197224ULL, 0x000fe200008e06ffULL, 0x0000001407147210ULL, 0x000fe20007f5e0ffULL,
0x00000018111d7836ULL, 0x000fe20000000000ULL, 0x0000001607167210ULL, 0x000fe20007f7e0ffULL,
0x00000008131e7824ULL, 0x000fe200078e00ffULL, 0x0000000412217c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x0000000416257c11ULL, 0x000fe2000f8438ffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x00000005122c7c11ULL, 0x000fe200080f3c19ULL,
0x0000000111127824ULL, 0x000fe200078e020dULL, 0x00000004142b7c11ULL, 0x000fe2000f8238ffULL,
0x00000008172e7824ULL, 0x000fe200078e00ffULL, 0x00000005162a7c11ULL, 0x000fe200090f3c15ULL,
0x0000000113157824ULL, 0x000fe200078e020dULL, 0x0000000712167812ULL, 0x000fe200078ec0ffULL,
0x000000010c127824ULL, 0x000fe200078e021dULL, 0x0000000514267c11ULL, 0x000fe200088f3c09ULL,
0x0000000127147824ULL, 0x040fe200078e020dULL, 0x000000102700720cULL, 0x040fe20003f66070ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x0000001207287210ULL, 0x000fe20007fde0ffULL,
0x0000400035097824ULL, 0x000fe200078e020eULL, 0x000000041b127210ULL, 0x000fc40007f3e0ffULL,
0x000000101300720cULL, 0x080fe20003f46070ULL, 0x000000ffff1b7224ULL, 0x000fe200030e06ffULL,
0x000000101100720cULL, 0x000fe20003f06070ULL, 0x000000ffff137224ULL, 0x000fe200008e061cULL,
0x0000000428297c11ULL, 0x040fe2000f8238ffULL, 0x0000100009097836ULL, 0x000fe20000000000ULL,
0xfffffff8271c7812ULL, 0x000fe400078ee214ULL, 0x0000000528287c11ULL, 0x000fe200088f3c1bULL,
0x00000001171b7824ULL, 0x000fe200078e020dULL, 0x0ffffff816167812ULL, 0x000fc400078ef80dULL,
0x000000041f147210ULL, 0x000fe20007f3e0ffULL, 0x0000001c111f7836ULL, 0x000fe20000000000ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee215ULL, 0x0000001016197824ULL, 0x000fe400078e0209ULL,
0x000000ffff157224ULL, 0x000fe200008e0620ULL, 0x0000000423167210ULL, 0x000fe20007f3e0ffULL,
0x000000010c207824ULL, 0x000fe200078e021fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012197faeULL, 0x0003e2000c101c46ULL, 0x000000101700720cULL, 0x000fe40003f06070ULL,
0x000000ffff177224ULL, 0x000fe200008e0622ULL, 0x0000002007277210ULL, 0x000fc40007fde0ffULL,
0x000000101d00720cULL, 0x080fe40003f26070ULL, 0xfffffff82e207812ULL, 0x000fe200078ee21bULL,
0x000000ffff247224ULL, 0x000fe200030e06ffULL, 0x0000000427237c11ULL, 0x000fe2000f8c38ffULL,
0x00000010181b7824ULL, 0x000fe400078e0209ULL, 0x000000011d127824ULL, 0x002fe200078e020dULL,
0x0000000527277c11ULL, 0x000fe2000b0f3c24ULL, 0x000000081d1d7824ULL, 0x000fe200078e00ffULL,
0x00000000141b7faeULL, 0x0003e2000e101c46ULL, 0x000000101f00720cULL, 0x000fc60003f86070ULL,
0xfffffff81d227812ULL, 0x000fe200078ee212ULL, 0x000000101a1d7824ULL, 0x000fe200078e0209ULL,
0x0000000421127210ULL, 0x000fe20007fde0ffULL, 0x0000002011217836ULL, 0x000fe40000000000ULL,
0x000000011f1a7824ULL, 0x000fe200078e020dULL, 0x00000000161d7faeULL, 0x0005e2000e901c46ULL,
0x000000042b187210ULL, 0x000fe20007fbe0ffULL, 0x000000010c247824ULL, 0x000fe400078e0221ULL,
0x000000ffff137224ULL, 0x000fc400030e062cULL, 0x000000ffff197224ULL, 0x000fe200028e0626ULL,
0x0000002407267210ULL, 0x000fe20007fde0ffULL, 0x0000000121147824ULL, 0x042fe200078e020dULL,
0x000000102100720cULL, 0x040fe20003fa6070ULL, 0x000000101e1b7824ULL, 0x100fe400078e0209ULL,
0x0000000821177824ULL, 0x004fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200030e06ffULL,
0x0000000426217c11ULL, 0x000fe2000f8c38ffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff817247812ULL, 0x000fe200078ee214ULL, 0x000000101c177824ULL, 0x000fe200078e0209ULL,
0x0000000526267c11ULL, 0x000fe2000b0f3c15ULL, 0x0000002411157836ULL, 0x000fe20000000000ULL,
0xfffffff81f1a7812ULL, 0x000fc400078ee21aULL, 0x0000000012177faeULL, 0x0003e2000d901c46ULL,
0x000000010c147824ULL, 0x000fe400078e0215ULL, 0x0000000115167824ULL, 0x040fe200078e020dULL,
0x00000000181b7faeULL, 0x0005e2000d101c46ULL, 0x00000008151d7824ULL, 0x040fe200078e00ffULL,
0x00000014071e7210ULL, 0x000fe40007fde0ffULL, 0x0000000425147210ULL, 0x000fe40007f7e0ffULL,
0x000000101500720cULL, 0x000fe20003f46070ULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x000000041e257c11ULL, 0x000fe2000f8c38ffULL, 0x000000ffff157224ULL, 0x000fe200018e062aULL,
0x0000000429127210ULL, 0x002fe20007f7e0ffULL, 0x0000003c11297836ULL, 0x000fe20000000000ULL,
0xfffffff81d1c7812ULL, 0x000fe200078ee216ULL, 0x00000010201d7824ULL, 0x000fe200078e0209ULL,
0x000000051e1b7c11ULL, 0x004fe2000b0f3c1fULL, 0x000000ffff137224ULL, 0x000fc400018e0628ULL,
0x00000010221f7824ULL, 0x100fe200078e0209ULL, 0x00000000141d7faeULL, 0x0003e2000c101c46ULL,
0x0000000423167210ULL, 0x000fe20007f1e0ffULL, 0x0000001024237824ULL, 0x000fe400078e0209ULL,
0x00000000121f7faeULL, 0x0005e2000c901c46ULL, 0x0000000421187210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe400000e0627ULL, 0x000000101a217824ULL, 0x000fe200078e0209ULL,
0x00000004251a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fc400008e0626ULL,
0x0000002c11157836ULL, 0x002fe20000000000ULL, 0x0000000016217faeULL, 0x0003e2000e101c46ULL,
0x000000ffff1b7224ULL, 0x000fe400000e061bULL, 0x0000002811137836ULL, 0x004fe20000000000ULL,
0x0000000018237faeULL, 0x0005e2000e901c46ULL, 0x00000030111d7836ULL, 0x000fe20000000000ULL,
0x000000101500720cULL, 0x080fe20003f86070ULL, 0x000000010c127824ULL, 0x000fe200078e0213ULL,
0x000000101300720cULL, 0x080fe20003fa6070ULL, 0x00000034111f7836ULL, 0x000fe20000000000ULL,
0x000000101d00720cULL, 0x000fe20003f66070ULL, 0x0000003811277836ULL, 0x000fe20000000000ULL,
0x0000001207177210ULL, 0x002fe20007f1e0ffULL, 0x000000101c257824ULL, 0x000fc400078e0209ULL,
0x0000000113117824ULL, 0x100fe200078e020dULL, 0x000000102700720cULL, 0x080fe20003f26070ULL,
0x0000000813147824ULL, 0x000fe200078e00ffULL, 0x0000000417137c11ULL, 0x000fe2000f8c38ffULL,
0x000000ffff187224ULL, 0x004fe200000e06ffULL, 0x000000001a257faeULL, 0x0003e2000d101c46ULL,
0x0000000115127824ULL, 0x040fe200078e020dULL, 0xfffffff814147812ULL, 0x000fe200078ee211ULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x000000101f00720cULL, 0x0c0fe20003f46070ULL,
0x000000081f1e7824ULL, 0x000fe200078e00ffULL, 0x000000102900720cULL, 0x000fe20003f06070ULL,
0x000000010c1c7824ULL, 0x040fe200078e021fULL, 0x0000000517117c11ULL, 0x000fe2000b0f3c18ULL,
0x0000000829247824ULL, 0x000fe200078e00ffULL, 0xfffffff819167812ULL, 0x000fe200078ee212ULL,
0x000000010c127824ULL, 0x000fe200078e0215ULL, 0x0000000413107210ULL, 0x000fe20007fde0ffULL,
0x000000011d137824ULL, 0x000fc400078e020dULL, 0x000000081d1a7824ULL, 0x002fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x0000001207187210ULL, 0x000fe20007fde0ffULL,
0x0000000127127824ULL, 0x140fe200078e020dULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x00000008271b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff197224ULL, 0x000fe200030e06ffULL,
0x0000000418177c11ULL, 0x000fe2000f8c38ffULL, 0x000000011f157824ULL, 0x000fe200078e020dULL,
0xfffffff81b227812ULL, 0x000fe200078ee212ULL, 0x000000010c207824ULL, 0x000fe200078e0227ULL,
0x0000000518137c11ULL, 0x000fe2000b0f3c19ULL, 0x000000010c187824ULL, 0x040fe200078e021dULL,
0x0000000417127210ULL, 0x000fe20007fde0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0229ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee215ULL, 0x0000000129157824ULL, 0x000fc400078e020dULL,
0x00000010140d7824ULL, 0x000fe400078e0209ULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x0000001807187210ULL, 0x000fe20007fde0ffULL, 0x0000001022197824ULL, 0x100fe200078e0209ULL,
0x00000000100d7faeULL, 0x0003e2000e901c46ULL, 0xfffffff824147812ULL, 0x000fe200078ee215ULL,
0x0000001016157824ULL, 0x000fe200078e0209ULL, 0x0000001c071c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0x00000004181f7c11ULL, 0x000fc4000f8c38ffULL,
0x0000000012157faeULL, 0x0005e2000e101c46ULL, 0x000000ffff1b7224ULL, 0x000fe200028e06ffULL,
0x0000000518187c11ULL, 0x000fe2000b0f3c17ULL, 0x000000101e177824ULL, 0x100fe200078e0209ULL,
0x000000041c1d7c11ULL, 0x000fe4000f8a38ffULL, 0x0000002007207210ULL, 0x000fe40007f9e0ffULL,
0x0000000c07167210ULL, 0x000fe20007fde0ffULL, 0x000000101a077824ULL, 0x100fe400078e0209ULL,
0x0000001014097824ULL, 0x000fe200078e0209ULL, 0x000000051c147c11ULL, 0x000fe2000a8f3c1bULL,
0x000000ffff1b7224ULL, 0x000fe200020e06ffULL, 0x000000041f0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x002fe200030e06ffULL, 0x0000000420137c11ULL, 0x004fc4000f8838ffULL,
0x0000000416157c11ULL, 0x000fe2000f8c38ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e0618ULL,
0x000000041d107210ULL, 0x000fe40007fbe0ffULL, 0x0000000520187c11ULL, 0x000fe4000a0f3c1bULL,
0x0000000516167c11ULL, 0x000fe2000b0f3c11ULL, 0x000000ffff117224ULL, 0x000fe200028e0614ULL,
0x0000000413127210ULL, 0x000fe20007f9e0ffULL, 0x000000000c077faeULL, 0x0003e2000d901c46ULL,
0x0000000415147210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0618ULL,
0x0000000010177faeULL, 0x0003e2000d101c46ULL, 0x000000ffff157224ULL, 0x000fc600028e0616ULL,
0x0000000012197faeULL, 0x0003e8000c901c46ULL, 0x0000000014097faeULL, 0x0003e2000c101c46ULL,
0x0000000c00587947ULL, 0x000fea0003800000ULL, 0x000000080d137811ULL, 0x040fe200078fe8ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x000000180d1d7811ULL, 0x040fe400078fe8ffULL,
0x0000001c0d1f7811ULL, 0x000fe200078fe8ffULL, 0x0000000113107824ULL, 0x100fe200078e020dULL,
0x000000140d1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000813097824ULL, 0x000fe200078e00ffULL,
0x0000000c0d157811ULL, 0x000fe200078fe8ffULL, 0x000000011d1e7824ULL, 0x100fe200078e020dULL,
0x000000040d117811ULL, 0x000fe200078fe8ffULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0xfffffff809107812ULL, 0x000fe200078ee210ULL, 0x000000011f1c7824ULL, 0x100fe200078e020dULL,
0x000000280d277811ULL, 0x000fe200078fe8ffULL, 0x000000081f257824ULL, 0x000fe200078e00ffULL,
0xfffffff8231e7812ULL, 0x000fe200078ee21eULL, 0x000000011b207824ULL, 0x100fe200078e020dULL,
0x000000200d237811ULL, 0x000fe200078fe8ffULL, 0x000000081b097824ULL, 0x000fe200078e00ffULL,
0xfffffff8251c7812ULL, 0x000fe200078ee21cULL, 0x0000000115227824ULL, 0x100fe200078e020dULL,
0x000000240d257811ULL, 0x000fe200078fe8ffULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0x0000002c0d297811ULL, 0x000fe200078fe8ffULL, 0x00000001231a7824ULL, 0x140fe200078e020dULL,
0xfffffff809207812ULL, 0x000fe200078ee220ULL, 0x0000000823097824ULL, 0x000fe200078e00ffULL,
0xfffffff817227812ULL, 0x000fe200078ee222ULL, 0x0000000111197824ULL, 0x100fe200078e020dULL,
0x000000100d177811ULL, 0x000fe200078fe8ffULL, 0x0000000811127824ULL, 0x000fe200078e00ffULL,
0xfffffff8091a7812ULL, 0x000fe200078ee21aULL, 0x0000000125187824ULL, 0x100fe200078e020dULL,
0x0000000d0d097211ULL, 0x000fe200078fe8ffULL, 0x00000008252b7824ULL, 0x000fe200078e00ffULL,
0xfffffff812197812ULL, 0x000fe200078ee219ULL, 0x0000000127167824ULL, 0x100fe200078e020dULL,
0x0000003c0d317811ULL, 0x000fe200078fe8ffULL, 0x00000008272d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b187812ULL, 0x000fe200078ee218ULL, 0x0000000129147824ULL, 0x100fe200078e020dULL,
0x000000300d2b7811ULL, 0x000fe200078fe8ffULL, 0x00000008292f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d167812ULL, 0x000fe200078ee216ULL, 0x0000000117217824ULL, 0x000fe200078e020dULL,
0x000000340d2d7811ULL, 0x000fe200078fe8ffULL, 0x0000000817127824ULL, 0x000fe200078e00ffULL,
0xfffffff82f147812ULL, 0x000fe200078ee214ULL, 0x000000010c267824ULL, 0x040fe200078e0211ULL,
0x000000380d2f7811ULL, 0x000fe200078fe8ffULL, 0x000000010c287824ULL, 0x040fe200078e0213ULL,
0x0000000709247812ULL, 0x000fe200078ec0ffULL, 0x000000010c2a7824ULL, 0x040fe200078e0215ULL,
0xfffffff812217812ULL, 0x000fe200078ee221ULL, 0x000000010c2c7824ULL, 0x040fe200078e0217ULL,
0x0000000c0d127211ULL, 0x000fe200078fe8ffULL, 0x000000010c2e7824ULL, 0x040fe200078e021bULL,
0x0000002807287210ULL, 0x000fe20007f5e0ffULL, 0x000000010c307824ULL, 0x040fe200078e021dULL,
0x0000002607267210ULL, 0x000fe20007f3e0ffULL, 0x000000010c327824ULL, 0x000fc400078e021fULL,
0x000000010c387824ULL, 0x040fe400078e0223ULL, 0x000000010c3a7824ULL, 0x040fe400078e0225ULL,
0x000000010c3c7824ULL, 0x040fe400078e0227ULL, 0x000000010c3e7824ULL, 0x040fe200078e0229ULL,
0x0000003a073a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010c407824ULL, 0x040fe400078e022bULL,
0x000000010c427824ULL, 0x000fc400078e022dULL, 0x000000010c447824ULL, 0x040fe400078e022fULL,
0x000000010c467824ULL, 0x000fe200078e0231ULL, 0x0ffffff8240c7812ULL, 0x000fe200078ef80dULL,
0x000000012b097824ULL, 0x100fe200078e020dULL, 0x0000004407447210ULL, 0x000fe20007f9e0ffULL,
0x000000012d117824ULL, 0x100fe200078e020dULL, 0x0000004607467210ULL, 0x000fe20007fbe0ffULL,
0x000000012f137824ULL, 0x100fe400078e020dULL, 0x00000001310d7824ULL, 0x000fc400078e020dULL,
0x0000000831247824ULL, 0x000fe400078e00ffULL, 0x000000082f4c7824ULL, 0x000fe400078e00ffULL,
0x000000082d4a7824ULL, 0x000fe200078e00ffULL, 0xfffffff824457812ULL, 0x000fe200078ee20dULL,
0x000000082b487824ULL, 0x000fe200078e00ffULL, 0x00000012070d7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff497224ULL, 0x000fe200018e06ffULL, 0xfffffff84c437812ULL, 0x000fe200078ee213ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0xfffffff84a417812ULL, 0x000fe200078ee211ULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x0000000428127c11ULL, 0x000fe2000f8438ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x000000040d4e7c11ULL, 0x000fc4000f8038ffULL,
0x0000000426237c11ULL, 0x000fe4000f8238ffULL, 0x0000000528137c11ULL, 0x000fe400090f3c13ULL,
0x000000050d0d7c11ULL, 0x000fe400080f3c24ULL, 0x0000000526117c11ULL, 0x000fe200088f3c11ULL,
0x0000400035267824ULL, 0x000fe200078e020eULL, 0x0000002e072e7210ULL, 0x000fe40007f5e0ffULL,
0x0000002a072a7210ULL, 0x000fe20007f1e0ffULL, 0x00001000264f7836ULL, 0x000fe20000000000ULL,
0x0000002c072c7210ULL, 0x000fc40007f3e0ffULL, 0xfffffff8483f7812ULL, 0x000fe200078ee209ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x000000042e247c11ULL, 0x000fe2000f8438ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x000000042a4d7c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x000000042c257c11ULL, 0x000fe2000f8238ffULL,
0x0000001019277824ULL, 0x000fe200078e024fULL, 0x000000052e097c11ULL, 0x000fe200090f3c09ULL,
0x00000010222b7824ULL, 0x000fe200078e024fULL, 0x000000052a157c11ULL, 0x000fe200080f3c15ULL,
0x00000010212d7824ULL, 0x000fe200078e024fULL, 0x000000052c177c11ULL, 0x000fe200088f3c17ULL,
0x0000001010297824ULL, 0x100fe200078e024fULL, 0x0000003807387210ULL, 0x000fe20007f5e0ffULL,
0x00000010202f7824ULL, 0x100fe200078e024fULL, 0x0000003007307210ULL, 0x000fe20007f1e0ffULL,
0x000000101e317824ULL, 0x100fe200078e024fULL, 0x0000003207327210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e06ffULL, 0x00000004384a7c11ULL, 0x000fe2000f8438ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e06ffULL, 0x00000004304c7c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x00000004324b7c11ULL, 0x000fe2000f8238ffULL,
0x000000101c337824ULL, 0x000fe200078e024fULL, 0x00000005381f7c11ULL, 0x000fe200090f3c1fULL,
0x000000101a377824ULL, 0x000fe200078e024fULL, 0x00000005301b7c11ULL, 0x000fe200080f3c1bULL,
0x0000001018397824ULL, 0x000fe200078e024fULL, 0x00000005321d7c11ULL, 0x000fe200088f3c1dULL,
0x00000010163b7824ULL, 0x100fe200078e024fULL, 0x0000003c073c7210ULL, 0x000fe20007f5e0ffULL,
0x00000010143d7824ULL, 0x100fe200078e024fULL, 0x0000003e073e7210ULL, 0x000fe20007f1e0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e024fULL, 0x0000004007407210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff477224ULL, 0x000fe200010e06ffULL, 0x000000043a487c11ULL, 0x000fe2000f8c38ffULL,
0x000000ffff217224ULL, 0x000fe200000e06ffULL, 0x0000004207427210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e06ffULL, 0x000000043c227c11ULL, 0x000fe2000f8438ffULL,
0x000000100c077824ULL, 0x100fe200078e024fULL, 0x000000043e387c11ULL, 0x000fe2000f8038ffULL,
0x0000001041417824ULL, 0x100fe200078e024fULL, 0x0000000440267c11ULL, 0x000fe2000f8238ffULL,
0x0000001043437824ULL, 0x000fe200078e024fULL, 0x000000053a497c11ULL, 0x000fe2000b0f3c49ULL,
0x0000001045457824ULL, 0x000fe200078e024fULL, 0x000000053c3c7c11ULL, 0x000fe200090f3c47ULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x000000053e3a7c11ULL, 0x000fe200080f3c21ULL,
0x000000ffff217224ULL, 0x000fe200020e06ffULL, 0x0000000540327c11ULL, 0x000fe200088f3c19ULL,
0x000000ffff197224ULL, 0x000fe200028e06ffULL, 0x00000070044f7812ULL, 0x000fc400078ec0ffULL,
0x0000000442287c11ULL, 0x000fe4000f8238ffULL, 0x00000004442a7c11ULL, 0x000fe4000f8438ffULL,
0x00000004462c7c11ULL, 0x000fe4000f8638ffULL, 0x0000004e4f0c7210ULL, 0x000fe40007f1e0ffULL,
0x0000000542307c11ULL, 0x000fe400088f3c47ULL, 0x00000005442e7c11ULL, 0x000fe200090f3c21ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000234f107210ULL, 0x000fc40007f3e0ffULL,
0x0000000546047c11ULL, 0x000fe400098f3c19ULL, 0x000000124f127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000004d4f147210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x000fe2000b901c46ULL,
0x000000254f167210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x000000244f187210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x0000004c4f1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x0000004b4f1c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200020e0609ULL,
0x0000004a4f1e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e061bULL,
0x000000484f207210ULL, 0x000fe20007f7e0ffULL, 0x0000000010277faeULL, 0x0003e2000b901c46ULL,
0x000000224f227210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x000000384f247210ULL, 0x000fe20007f9e0ffULL, 0x0000000012297faeULL, 0x0005e2000b901c46ULL,
0x000000264f267210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x000000284f287210ULL, 0x000fe20007f3e0ffULL, 0x00000000142b7faeULL, 0x0007e2000b901c46ULL,
0x0000002a4f2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200018e0649ULL,
0x0000002c4f2c7210ULL, 0x000fe20007f7e0ffULL, 0x00000000162d7faeULL, 0x000be2000b901c46ULL,
0x000000ffff237224ULL, 0x000fc400028e063cULL, 0x000000ffff257224ULL, 0x000fe200020e063aULL,
0x00000000182f7faeULL, 0x000be2000b901c46ULL, 0x000000ffff277224ULL, 0x002fe400000e0632ULL,
0x000000ffff297224ULL, 0x004fe200008e0630ULL, 0x000000001a317faeULL, 0x0005e2000b901c46ULL,
0x000000ffff2b7224ULL, 0x008fc600010e062eULL, 0x000000001c337faeULL, 0x0005e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x020fc600018e0604ULL, 0x000000001e377faeULL, 0x0005e8000b901c46ULL,
0x0000000020397faeULL, 0x0005e8000b901c46ULL, 0x00000000223b7faeULL, 0x0005e8000b901c46ULL,
0x00000000243d7faeULL, 0x0005e8000b901c46ULL, 0x00000000263f7faeULL, 0x0005e8000b901c46ULL,
0x0000000028417faeULL, 0x0005e8000b901c46ULL, 0x000000002a437faeULL, 0x0005e8000b901c46ULL,
0x000000002c457faeULL, 0x0005e4000b901c46ULL, 0x0000000205057836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff077424ULL, 0x002fc600078e00ffULL,
0x000000340500720cULL, 0x000fda0003f06070ULL, 0x00009000ff098b82ULL, 0x000e620000000800ULL,
0x0000000208048824ULL, 0x000fce00078e00ffULL, 0x00008c00ff0c8b82ULL, 0x000ee20000000a00ULL,
0x0000000904098224ULL, 0x002fc800078e0205ULL, 0x00000004090c8825ULL, 0x008fca00078e000cULL,
0x000000060c078981ULL, 0x000324000c1e1900ULL, 0x00000000000c7805ULL, 0x002fce0000015200ULL,
0x0176000b0e0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff127224ULL, 0x000fce00078e00ffULL, 0x000000101200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x000000100c097210ULL, 0x000fca0007f1e1ffULL, 0x0000000111107824ULL, 0x000fe200000e0e0dULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011410ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0610ULL, 0x0000000204047819ULL, 0x000fc80000001209ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000112127836ULL, 0x000fce0000000000ULL, 0x0176000b0e0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000002035047824ULL, 0x002fca00078e0204ULL, 0x00000003ff097819ULL, 0x000fc80000011604ULL,
0x1ffffffe090b7812ULL, 0x000fe400078ec0ffULL, 0x0000000f04097812ULL, 0x000fc600078ec0ffULL,
0x00000001040b7824ULL, 0x000fe400078e020bULL, 0x00000010090a7824ULL, 0x000fe400078e00ffULL,
0x000000010b047836ULL, 0x000fe20000000000ULL, 0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000001009097824ULL, 0x000fc600078e00ffULL, 0x0000000f04047812ULL, 0x000fe400078ec0ffULL,
0x000000f00a0b7812ULL, 0x000fe400078ee20bULL, 0x000000f009097812ULL, 0x000fc600078ee204ULL,
0x000000100b0b7824ULL, 0x100fe400078e020eULL, 0x0000001009097824ULL, 0x000fc600078e020eULL,
0x000000000b147984ULL, 0x000e680000000c00ULL, 0x0000000009107984ULL, 0x000ee20000000c00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff157224ULL, 0x000fc400078e0017ULL,
0x000000ffff1a7224ULL, 0x00cfe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff167224ULL, 0x000fe400078e0011ULL, 0x000000ffff177224ULL, 0x000fe200078e0013ULL,
0x000000180b007388ULL, 0x0003e20000000c00ULL, 0x00000001ff117424ULL, 0x000fc600078e00ffULL,
0x0000001409007388ULL, 0x0003e60000000c00ULL, 0x017600110e1079a7ULL, 0x0002a4000850003fULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x017600110e0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff127224ULL, 0x000fce00078e00ffULL,
0x000000101200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a097210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e0bULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001140cULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e060cULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000112127836ULL, 0x000fce0000000000ULL,
0x017600110e0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009000ff097b82ULL, 0x000e620000000800ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x3db504f306067820ULL, 0x010fe20000410000ULL, 0xffffffff0f0a7836ULL, 0x000fe40000000000ULL,
0x00000020350b7824ULL, 0x000fe400078e020eULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff147224ULL, 0x000fe400078e00ffULL, 0x0000000908087224ULL, 0x002fc400078e02ffULL,
0x0000000835097824ULL, 0x000fce00078e020eULL, 0x000001000c0d7824ULL, 0x000fca00078e0203ULL,
0x0000000d3600720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x010fea0003800000ULL,
0x000000020c107836ULL, 0x000fe20000000000ULL, 0x0000000114377812ULL, 0x000fe200078e0cffULL,
0x000001000d127836ULL, 0x000fe40000000000ULL, 0x0000000702077224ULL, 0x000fe200078e02ffULL,
0x0000000f1000720cULL, 0x000fe40003f06070ULL, 0x0000004012117812ULL, 0x000fca00078ec0ffULL,
0x0000000100117824ULL, 0x000fcc00078e0211ULL, 0x0000000c00b08947ULL, 0x000fea0003800000ULL,
0x00000003ff167819ULL, 0x004fe20000011604ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000001236137248ULL, 0x000fc60007fe0000ULL, 0x0000000416187836ULL, 0x000fe40000000000ULL,
0x0000000116107824ULL, 0x000fe400078e0211ULL, 0x00000008161a7836ULL, 0x000fe40000000000ULL,
0x0000000118157824ULL, 0x040fe200078e0204ULL, 0x00000010071e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000818267824ULL, 0x000fe400078e00ffULL, 0x0000000113137824ULL, 0x000fc400078e0a12ULL,
0x0000000118107824ULL, 0x100fe200078e0211ULL, 0xfffffff826267812ULL, 0x000fe200078ee215ULL,
0x000000011a127824ULL, 0x040fe200078e0211ULL, 0x000000131a00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x000000041e1b7c11ULL, 0x000fe2000f8038ffULL,
0x000000011a177824ULL, 0x140fe200078e0204ULL, 0x00000010071c7210ULL, 0x000fe20007f3e0ffULL,
0x000000081a2e7824ULL, 0x000fe200078e00ffULL, 0x0000001207127210ULL, 0x000fe20007f5e0ffULL,
0x0000000c161a7836ULL, 0x000fe20000000000ULL, 0x000000051e1e7c11ULL, 0x000fe200080f3c15ULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x000000041c257c11ULL, 0x000fe2000f8038ffULL,
0x000000011a107824ULL, 0x000fe200078e0211ULL, 0x00000004121d7c11ULL, 0x000fe2000f8238ffULL,
0x000000ffff217224ULL, 0x000fe200010e06ffULL, 0x000000051c1c7c11ULL, 0x000fe200080f3c15ULL,
0x0000001016247836ULL, 0x000fe20000000000ULL, 0x0000001007207210ULL, 0x000fe20007f1e0ffULL,
0x0000001416387836ULL, 0x000fe20000000000ULL, 0x0000000512217c11ULL, 0x000fe200088f3c21ULL,
0x0000000124107824ULL, 0x100fe200078e0211ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee217ULL,
0x0000000138127824ULL, 0x100fe200078e0211ULL, 0x000000131800720cULL, 0x080fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00000004202b7c11ULL, 0x000fe2000f8038ffULL,
0x00000018163a7836ULL, 0x000fe20000000000ULL, 0x0000001007227210ULL, 0x000fe20007f3e0ffULL,
0x0000001c163c7836ULL, 0x000fe20000000000ULL, 0x0000001207127210ULL, 0x000fe20007f5e0ffULL,
0x000000013a107824ULL, 0x000fe200078e0211ULL, 0x0000000520207c11ULL, 0x000fe200080f3c15ULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x0000000412297c11ULL, 0x000fe2000f8238ffULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0x00000004221f7c11ULL, 0x000fe2000f8038ffULL,
0x000000013c187824ULL, 0x000fe200078e0211ULL, 0x00000010072a7210ULL, 0x000fe20007f7e0ffULL,
0x000000011a287824ULL, 0x100fe200078e0204ULL, 0x00000005122c7c11ULL, 0x000fe200088f3c17ULL,
0x0000001004127824ULL, 0x000fe200078e00ffULL, 0x0000000522227c11ULL, 0x000fe200080f3c15ULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x000000131a00720cULL, 0x0c0fe20003f66070ULL,
0x000000081a2f7824ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fe200078ec0ffULL,
0x0000000116177824ULL, 0x000fe200078e0204ULL, 0x0000001807187210ULL, 0x000fe20007fde0ffULL,
0x0000400035107824ULL, 0x000fe200078e020eULL, 0x000000121b1a7210ULL, 0x000fe20007f3e0ffULL,
0x00000020163e7836ULL, 0x000fe20000000000ULL, 0x000000042a237c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0x0000000717177812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e061eULL, 0x0000000418277c11ULL, 0x000fe2000f8238ffULL,
0x00000001242d7824ULL, 0x000fe200078e0204ULL, 0x000000052a2a7c11ULL, 0x000fe200080f3c15ULL,
0x0000200037157824ULL, 0x000fe200078e0210ULL, 0x000000131600720cULL, 0x080fe20003f06070ULL,
0x0000000824327824ULL, 0x000fe200078e00ffULL, 0xfffffff82f307812ULL, 0x000fe200078ee228ULL,
0x0000100015157836ULL, 0x000fe20000000000ULL, 0x0000000518287c11ULL, 0x000fe200088f3c19ULL,
0x000000013e1e7824ULL, 0x000fe200078e0211ULL, 0x000000132400720cULL, 0x000fe20003f46070ULL,
0x0000002416407836ULL, 0x000fe20000000000ULL, 0x0000001225187210ULL, 0x000fc40007f3e0ffULL,
0x0ffffff817247812ULL, 0x000fe400078ef804ULL, 0x0000001e071e7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200008e061cULL, 0x000000121d1c7210ULL, 0x000fe20007f3e0ffULL,
0x0000001024177824ULL, 0x000fe200078e0215ULL, 0xfffffff832327812ULL, 0x000fe200078ee22dULL,
0x0000000138247824ULL, 0x000fe400078e0204ULL, 0x000000ffff1d7224ULL, 0x000fe200008e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a177faeULL, 0x0003e2000c101c46ULL,
0x000000083a217824ULL, 0x040fe200078e00ffULL, 0x000000133a00720cULL, 0x080fe20003f26070ULL,
0x00000008382d7824ULL, 0x040fe200078e00ffULL, 0x000000133800720cULL, 0x000fc80003f06070ULL,
0xfffffff82d387812ULL, 0x000fe200078ee224ULL, 0x000000013c247824ULL, 0x140fe400078e0204ULL,
0x000000083c2d7824ULL, 0x000fe400078e00ffULL, 0x000000013a1a7824ULL, 0x002fe400078e0204ULL,
0x000000ffff1b7224ULL, 0x000fe200030e06ffULL, 0x000000041e257c11ULL, 0x000fe2000f8c38ffULL,
0x0000001026177824ULL, 0x100fe200078e0215ULL, 0xfffffff8213a7812ULL, 0x000fe200078ee21aULL,
0x000000102e217824ULL, 0x000fe200078e0215ULL, 0x000000051e267c11ULL, 0x000fc4000b0f3c1bULL,
0x000000122b1a7210ULL, 0x000fe20007fde0ffULL, 0x0000000018177faeULL, 0x0003e2000e101c46ULL,
0x000000133c00720cULL, 0x000fe20003f86070ULL, 0x000000083e3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2e7812ULL, 0x000fe200078ee224ULL, 0x000000ffff1b7224ULL, 0x000fe200030e0620ULL,
0x000000001c217faeULL, 0x0005e2000e901c46ULL, 0x0000000140207824ULL, 0x040fe200078e0211ULL,
0x000000121f1e7210ULL, 0x000fe20007fbe0ffULL, 0x00000008402d7824ULL, 0x000fc600078e00ffULL,
0x0000002007207210ULL, 0x000fe20007fde0ffULL, 0x000000013e177824ULL, 0x042fe400078e0204ULL,
0x000000ffff1f7224ULL, 0x000fe200028e0622ULL, 0x000000133e00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee217ULL,
0x0000001030177824ULL, 0x100fe200078e0215ULL, 0x00000004202b7c11ULL, 0x000fe2000f8c38ffULL,
0x0000002816307836ULL, 0x000fe40000000000ULL, 0x00000010321d7824ULL, 0x004fe200078e0215ULL,
0x0000000520247c11ULL, 0x000fe2000b0f3c19ULL, 0x0000000130187824ULL, 0x000fe200078e0211ULL,
0x000000001a177faeULL, 0x0003e2000d901c46ULL, 0x00000001401c7824ULL, 0x000fc600078e0204ULL,
0x0000001807227210ULL, 0x000fe20007fde0ffULL, 0x000000001e1d7faeULL, 0x0005e2000d101c46ULL,
0x0000001229187210ULL, 0x000fe40007f7e0ffULL, 0x000000134000720cULL, 0x000fe20003f46070ULL,
0x000000ffff217224ULL, 0x000fe200030e06ffULL, 0x0000000422297c11ULL, 0x000fe2000f8c38ffULL,
0x000000ffff197224ULL, 0x000fe200018e062cULL, 0x00000012231a7210ULL, 0x002fe20007f7e0ffULL,
0x0000001038177824ULL, 0x100fe200078e0215ULL, 0xfffffff82d2c7812ULL, 0x000fe200078ee21cULL,
0x000000103a237824ULL, 0x000fe200078e0215ULL, 0x0000000522227c11ULL, 0x000fe2000b0f3c21ULL,
0x000000ffff1b7224ULL, 0x000fe200018e062aULL, 0x0000000018177faeULL, 0x0003e2000c101c46ULL,
0x00000012271c7210ULL, 0x000fe20007f1e0ffULL, 0x00000038162a7836ULL, 0x000fc40000000000ULL,
0x000000001a237faeULL, 0x0007e2000c901c46ULL, 0x00000012251e7210ULL, 0x004fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e0628ULL, 0x000000122b207210ULL, 0x000fe20007f1e0ffULL,
0x0000003416287836ULL, 0x000fe40000000000ULL, 0x000000ffff1f7224ULL, 0x000fe400008e0626ULL,
0x000000ffff217224ULL, 0x000fe400000e0624ULL, 0x0000002c16247836ULL, 0x000fc40000000000ULL,
0x000000102c177824ULL, 0x002fe400078e0215ULL, 0x0000003016267836ULL, 0x000fe40000000000ULL,
0x0000003c162c7836ULL, 0x000fe40000000000ULL, 0x0000000124167824ULL, 0x000fe200078e0211ULL,
0x000000132600720cULL, 0x080fe20003f66070ULL, 0x000000102e257824ULL, 0x100fe400078e0215ULL,
0x000000103c277824ULL, 0x000fe200078e0215ULL, 0x0000001607187210ULL, 0x000fe20007f3e0ffULL,
0x00000001301a7824ULL, 0x008fe200078e0204ULL, 0x0000001229167210ULL, 0x000fe20007f1e0ffULL,
0x000000001c257faeULL, 0x0003e2000e101c46ULL, 0x0000000418197c11ULL, 0x000fe2000f8c38ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e06ffULL, 0x000000133000720cULL, 0x080fe20003f86070ULL,
0x000000001e277faeULL, 0x0005e2000e901c46ULL, 0x000000132400720cULL, 0x000fc40003fa6070ULL,
0x000000132a00720cULL, 0x080fe20003f26070ULL, 0x0000000020177faeULL, 0x0007e2000d101c46ULL,
0x000000132800720cULL, 0x000fe20003f46070ULL, 0x00000008301d7824ULL, 0x002fe400078e00ffULL,
0x00000008241e7824ULL, 0x004fc600078e00ffULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee21aULL,
0x00000001261a7824ULL, 0x000fe400078e0211ULL, 0x000000ffff177224ULL, 0x008fe200000e0622ULL,
0x000000132c00720cULL, 0x000fe20003f06070ULL, 0x00000001261d7824ULL, 0x100fe200078e0204ULL,
0x0000000518137c11ULL, 0x000fe2000b0f3c1bULL, 0x00000001241b7824ULL, 0x100fe200078e0204ULL,
0x0000001219187210ULL, 0x000fe20007fde0ffULL, 0x0000000826207824ULL, 0x000fe400078e00ffULL,
0x0000000828247824ULL, 0x040fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee21bULL,
0x000000ffff197224ULL, 0x000fe200030e0613ULL, 0x0000001a071a7210ULL, 0x000fe20007fde0ffULL,
0x00000001281b7824ULL, 0x000fe200078e0204ULL, 0xfffffff820207812ULL, 0x000fe200078ee21dULL,
0x000000101c137824ULL, 0x000fc400078e0215ULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x000000041a1f7c11ULL, 0x000fe2000f8c38ffULL, 0x000000012a1c7824ULL, 0x000fe200078e0211ULL,
0xfffffff824247812ULL, 0x000fe200078ee21bULL, 0x000000101e1b7824ULL, 0x000fe200078e0215ULL,
0x000000051a227c11ULL, 0x000fe2000b0f3c1dULL, 0x00000001281a7824ULL, 0x100fe200078e0211ULL,
0x0000000016137faeULL, 0x0003e2000e101c46ULL, 0x000000012c1e7824ULL, 0x000fe200078e0211ULL,
0x0000001c071c7210ULL, 0x000fe20007f9e0ffULL, 0x000000012a117824ULL, 0x140fe200078e0204ULL,
0x00000000181b7faeULL, 0x0005e2000e901c46ULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x0000001a071a7210ULL, 0x000fe20007fbe0ffULL, 0x000000012c1d7824ULL, 0x040fe200078e0204ULL,
0x0000001e071e7210ULL, 0x000fe20007fde0ffULL, 0x000000082c2c7824ULL, 0x000fc400078e00ffULL,
0x0000001020077824ULL, 0x100fe200078e0215ULL, 0xfffffff82a167812ULL, 0x002fe200078ee211ULL,
0x000000ffff137224ULL, 0x000fe200028e06ffULL, 0x000000041a217c11ULL, 0x000fe2000f8a38ffULL,
0x0000001024117824ULL, 0x100fe200078e0215ULL, 0xfffffff82c187812ULL, 0x004fe200078ee21dULL,
0x00000010161d7824ULL, 0x000fe200078e0215ULL, 0x000000051a207c11ULL, 0x000fe2000a8f3c13ULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0x000000121f167210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e06ffULL, 0x000000041c1b7c11ULL, 0x000fe2000f8838ffULL,
0x0000001018157824ULL, 0x000fe200078e0215ULL, 0x000000041e137c11ULL, 0x000fe2000f8c38ffULL,
0x000000ffff177224ULL, 0x000fe200028e0622ULL, 0x0000001221187210ULL, 0x000fc40007fbe0ffULL,
0x000000051c1f7c11ULL, 0x000fe4000a0f3c1fULL, 0x000000051e1c7c11ULL, 0x000fe2000b0f3c19ULL,
0x000000ffff197224ULL, 0x000fe200028e0620ULL, 0x000000121b1a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000016077faeULL, 0x0003e2000d901c46ULL, 0x0000001213127210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e061fULL, 0x0000000018117faeULL, 0x0003e2000d101c46ULL,
0x000000ffff137224ULL, 0x000fc600028e061cULL, 0x000000001a1d7faeULL, 0x0003e8000c901c46ULL,
0x0000000012157faeULL, 0x0003e2000c101c46ULL, 0x0000000c00607947ULL, 0x000fea0003800000ULL,
0x0000000404127811ULL, 0x044fe200078fe8ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000804157811ULL, 0x040fe400078fe8ffULL, 0x0000001804217811ULL, 0x000fe200078fe8ffULL,
0x0000000112277824ULL, 0x100fe200078e0204ULL, 0x00000024043a7811ULL, 0x000fe200078fe8ffULL,
0x0000000812107824ULL, 0x000fe200078e00ffULL, 0x00000034043e7811ULL, 0x040fe200078fe8ffULL,
0x00000001152d7824ULL, 0x100fe200078e0204ULL, 0x0000002004327811ULL, 0x040fe200078fe8ffULL,
0x0000000121297824ULL, 0x100fe200078e0204ULL, 0xfffffff810277812ULL, 0x000fe200078ee227ULL,
0x0000000815107824ULL, 0x000fe200078e00ffULL, 0x0000000c04197811ULL, 0x000fe200078fe8ffULL,
0x000000013a287824ULL, 0x100fe200078e0204ULL, 0x0000002c043c7811ULL, 0x000fe200078fe8ffULL,
0x000000083a177824ULL, 0x000fe200078e00ffULL, 0xfffffff8102d7812ULL, 0x000fe200078ee22dULL,
0x0000000821107824ULL, 0x000fe200078e00ffULL, 0x00000028043b7811ULL, 0x000fe200078fe8ffULL,
0x000000013e257824ULL, 0x100fe200078e0204ULL, 0xfffffff817287812ULL, 0x000fe200078ee228ULL,
0x00000001322a7824ULL, 0x100fe200078e0204ULL, 0xfffffff810297812ULL, 0x000fe200078ee229ULL,
0x000000083e107824ULL, 0x000fe200078e00ffULL, 0x00000010041a7811ULL, 0x000fe200078fe8ffULL,
0x0000000832137824ULL, 0x000fe200078e00ffULL, 0x0000001c04237811ULL, 0x040fe200078fe8ffULL,
0x00000001192f7824ULL, 0x140fe200078e0204ULL, 0xfffffff810257812ULL, 0x000fe200078ee225ULL,
0x0000000819167824ULL, 0x000fe200078e00ffULL, 0x0000001104107211ULL, 0x000fe200078fe8ffULL,
0x000000013c2e7824ULL, 0x140fe200078e0204ULL, 0xfffffff8132a7812ULL, 0x000fe200078ee22aULL,
0x000000083c177824ULL, 0x000fe200078e00ffULL, 0x0000001007107210ULL, 0x000fe20007f1e0ffULL,
0x0000000112127824ULL, 0x000fe200078e0211ULL, 0xfffffff8162f7812ULL, 0x000fe200078ee22fULL,
0x000000013b2c7824ULL, 0x140fe200078e0204ULL, 0xfffffff8172e7812ULL, 0x000fe200078ee22eULL,
0x000000083b137824ULL, 0x000fe200078e00ffULL, 0x0000001207177210ULL, 0x000fe20007f3e0ffULL,
0x000000011a317824ULL, 0x100fe200078e0204ULL, 0x00000030043d7811ULL, 0x000fe200078fe8ffULL,
0x000000081a187824ULL, 0x000fe200078e00ffULL, 0xfffffff8132c7812ULL, 0x000fe200078ee22cULL,
0x00000001232b7824ULL, 0x140fe200078e0204ULL, 0x00000014041b7811ULL, 0x000fe200078fe8ffULL,
0x0000000823167824ULL, 0x000fe200078e00ffULL, 0xfffffff818317812ULL, 0x000fe200078ee231ULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x0000000410127c11ULL, 0x040fe2000f8038ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0xfffffff8162b7812ULL, 0x000fe200078ee22bULL,
0x000000013d307824ULL, 0x100fe200078e0204ULL, 0x0000000417167c11ULL, 0x000fe2000f8238ffULL,
0x000000083d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000510137c11ULL, 0x000fe200080f3c13ULL,
0x0000000115107824ULL, 0x100fe200078e0211ULL, 0x0000003804407811ULL, 0x000fe200078fe8ffULL,
0x000000011b337824ULL, 0x000fe200078e0204ULL, 0x0000000517177c11ULL, 0x000fe200088f3c18ULL,
0x0000000119187824ULL, 0x100fe200078e0211ULL, 0xfffffff81d307812ULL, 0x000fe200078ee230ULL,
0x000000081b1c7824ULL, 0x040fe200078e00ffULL, 0x0000001007197210ULL, 0x000fe20007f1e0ffULL,
0x0000000140267824ULL, 0x000fe200078e0204ULL, 0x0000003c043f7811ULL, 0x000fe200078fe8ffULL,
0x00000008401d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c337812ULL, 0x000fe200078ee233ULL,
0x000000011b107824ULL, 0x100fe200078e0211ULL, 0x00000018071b7210ULL, 0x000fe20007f3e0ffULL,
0x000000011a1a7824ULL, 0x100fe200078e0211ULL, 0xfffffff81d267812ULL, 0x000fe200078ee226ULL,
0x000000ffff227224ULL, 0x000fe200000e06ffULL, 0x0000000419187c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff207224ULL, 0x000fe200008e06ffULL, 0x0000001a071d7210ULL, 0x000fe20007f5e0ffULL,
0x000000013e3e7824ULL, 0x100fe200078e0211ULL, 0x000000041b1a7c11ULL, 0x000fe2000f8238ffULL,
0x0000000140407824ULL, 0x100fe200078e0211ULL, 0x0000000519197c11ULL, 0x000fe200080f3c22ULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x00000010071f7210ULL, 0x000fe20007f1e0ffULL,
0x0000000121107824ULL, 0x100fe200078e0211ULL, 0x000000051b1b7c11ULL, 0x000fe200088f3c20ULL,
0x0000000123207824ULL, 0x100fe200078e0211ULL, 0x000000041d1c7c11ULL, 0x040fe2000f8438ffULL,
0x0000000132227824ULL, 0x100fe200078e0211ULL, 0x0000001007217210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x000000051d1d7c11ULL, 0x000fe200090f3c1eULL,
0x000000013f427824ULL, 0x040fe200078e0211ULL, 0x0000002007237210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x0000002207157210ULL, 0x000fe20007f7e0ffULL,
0x000000083f467824ULL, 0x000fe200078e00ffULL, 0x000000041f1e7c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x0000000423227c11ULL, 0x000fe2000f8238ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x000000051f1f7c11ULL, 0x000fc400080f3c24ULL,
0x0000000415247c11ULL, 0x000fe4000f8438ffULL, 0x0000000523237c11ULL, 0x000fe400088f3c32ULL,
0x0000000404327211ULL, 0x000fe400078fe8ffULL, 0x0000000421207c11ULL, 0x000fe4000f8038ffULL,
0x0000000515157c11ULL, 0x000fe200090f3c10ULL, 0x0000400035107824ULL, 0x000fe200078e020eULL,
0x0000000732397812ULL, 0x000fe200078ec0ffULL, 0x000000013a327824ULL, 0x100fe200078e0211ULL,
0x0000000521217c11ULL, 0x000fe200080f3c38ULL, 0x000000013c3a7824ULL, 0x100fe200078e0211ULL,
0x0ffffff839397812ULL, 0x000fe200078ef804ULL, 0x000000013b387824ULL, 0x100fe200078e0211ULL,
0x0000003207327210ULL, 0x000fe20007fde0ffULL, 0x000000013d3c7824ULL, 0x000fe200078e0211ULL,
0x0000003a073a7210ULL, 0x000fe20007f1e0ffULL, 0x0000200037117824ULL, 0x000fe200078e0210ULL,
0x0000003807387210ULL, 0x000fe20007fbe0ffULL, 0x000000013f3b7824ULL, 0x000fe200078e0204ULL,
0x0000003c073c7210ULL, 0x000fe20007f3e0ffULL, 0x0000100011447836ULL, 0x000fe20000000000ULL,
0x0000003e073e7210ULL, 0x000fc40007f5e0ffULL, 0xfffffff8464b7812ULL, 0x000fe200078ee23bULL,
0x0000001027117824ULL, 0x100fe200078e0244ULL, 0x0000004007407210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200030e06ffULL, 0x0000000432487c11ULL, 0x000fe2000f8c38ffULL,
0x0000001025477824ULL, 0x100fe200078e0244ULL, 0x0000004207427210ULL, 0x000fe20007f9e0ffULL,
0x00000010283f7824ULL, 0x100fe200078e0244ULL, 0x00000005324a7c11ULL, 0x000fe2000b0f3c27ULL,
0x000000102c417824ULL, 0x100fe400078e0244ULL, 0x0000001026497824ULL, 0x000fc400078e0244ULL,
0x000000ffff277224ULL, 0x000fe200028e06ffULL, 0x0000000438287c11ULL, 0x000fe2000f8a38ffULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x000000043c2c7c11ULL, 0x000fe2000f8238ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x0000000538467c11ULL, 0x000fe2000a8f3c27ULL,
0x0000001039077824ULL, 0x100fe400078e0244ULL, 0x000000102b3b7824ULL, 0x100fe200078e0244ULL,
0x00000070264d7812ULL, 0x000fe200078ec0ffULL, 0x000000102d2d7824ULL, 0x000fc400078e0244ULL,
0x000000102f2f7824ULL, 0x100fe200078e0244ULL, 0x0000004d1c1c7210ULL, 0x000fe20007fbe0ffULL,
0x0000001031317824ULL, 0x100fe400078e0244ULL, 0x0000001033337824ULL, 0x100fe400078e0244ULL,
0x0000001029397824ULL, 0x100fe400078e0244ULL, 0x000000102a3d7824ULL, 0x100fe400078e0244ULL,
0x000000102e437824ULL, 0x000fc400078e0244ULL, 0x0000001030457824ULL, 0x100fe400078e0244ULL,
0x000000104b4b7824ULL, 0x000fe200078e0244ULL, 0x000000053c447c11ULL, 0x000fe200088f3c25ULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x000000043a2a7c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x000000043e2e7c11ULL, 0x000fe2000f8238ffULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x0000000440307c11ULL, 0x000fe2000f8438ffULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x0000000442327c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e061dULL, 0x000000053a2b7c11ULL, 0x000fc400080f3c2bULL,
0x0000004d12127210ULL, 0x000fe40007f1e0ffULL, 0x000000053e3c7c11ULL, 0x000fe400088f3c29ULL,
0x00000005403a7c11ULL, 0x000fe200090f3c27ULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000004d16167210ULL, 0x000fe40007f3e0ffULL, 0x0000000542387c11ULL, 0x000fe400098f3c25ULL,
0x0000004d18187210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x0000004d1a1a7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012077faeULL, 0x000fe2000b901c46ULL, 0x0000004d1e1e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x0000004d20207210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x0000004d22227210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e061fULL, 0x0000004d24247210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0x0000004d48267210ULL, 0x000fe20007f7e0ffULL,
0x0000000016117faeULL, 0x000fe2000b901c46ULL, 0x0000004d28287210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff237224ULL, 0x000fe200008e0623ULL, 0x0000004d2a2a7210ULL, 0x000fe20007f9e0ffULL,
0x00000000182d7faeULL, 0x0003e2000b901c46ULL, 0x0000004d2c2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200010e0615ULL, 0x0000004d2e2e7210ULL, 0x000fe20007f3e0ffULL,
0x000000001a2f7faeULL, 0x0007e2000b901c46ULL, 0x0000004d30307210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff277224ULL, 0x000fe200018e064aULL, 0x0000004d32327210ULL, 0x000fe20007f7e0ffULL,
0x000000001c317faeULL, 0x0009e2000b901c46ULL, 0x000000ffff297224ULL, 0x000fc400028e0646ULL,
0x000000ffff2b7224ULL, 0x000fe200020e062bULL, 0x000000001e337faeULL, 0x000be2000b901c46ULL,
0x000000ffff2d7224ULL, 0x002fc600000e0644ULL, 0x0000000020397faeULL, 0x0005e2000b901c46ULL,
0x000000ffff2f7224ULL, 0x008fc600008e063cULL, 0x00000000223b7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff317224ULL, 0x010fc600010e063aULL, 0x00000000243d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff337224ULL, 0x020fc600018e0638ULL, 0x00000000263f7faeULL, 0x0005e8000b901c46ULL,
0x0000000028417faeULL, 0x0005e8000b901c46ULL, 0x000000002a437faeULL, 0x0005e8000b901c46ULL,
0x000000002c457faeULL, 0x0005e8000b901c46ULL, 0x000000002e477faeULL, 0x0005e8000b901c46ULL,
0x0000000030497faeULL, 0x0005e8000b901c46ULL, 0x00000000324b7faeULL, 0x0005e4000b901c46ULL,
0x0000000205057836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff077424ULL, 0x002fc600078e00ffULL, 0x000000340500720cULL, 0x000fda0003f06070ULL,
0x00008c00ff128b82ULL, 0x000e620000000a00ULL, 0x0000000208118824ULL, 0x000fe400078e0205ULL,
0x0000200014427824ULL, 0x000fe400078e0210ULL, 0x0000002004107836ULL, 0x000fe20000000000ULL,
0x0000000704437812ULL, 0x004fe200078ec0ffULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x00000004ff417819ULL, 0x000fe40000011604ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000000411128825ULL, 0x002fe200078e0012ULL, 0xfffffff804117812ULL, 0x000fe400078ec0ffULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000612078981ULL, 0x000322000c1e1900ULL, 0x0000100042427836ULL, 0x000fe20000000000ULL,
0x0000000711447812ULL, 0x000fe400078ef804ULL, 0x0000000843457812ULL, 0x000fe400078ef804ULL,
0xfffffff810137812ULL, 0x002fc800078ec0ffULL, 0x0000000713407812ULL, 0x000fce00078ef804ULL,
0x0000000144107824ULL, 0x140fe400078e0247ULL, 0x0000000844117824ULL, 0x000fe400078e00ffULL,
0x0000000140147824ULL, 0x040fe400078e0247ULL, 0x0000000840157824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee210ULL, 0x0000000147497836ULL, 0x000fe40000000000ULL,
0x0000000247607824ULL, 0x000fe200078e0241ULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x0000001011117824ULL, 0x000fc400078e0242ULL, 0x0000000247477836ULL, 0x000fe40000000000ULL,
0x0000001015157824ULL, 0x000fe400078e0242ULL, 0x000000001110783bULL, 0x000e620000000200ULL,
0x000000084700780cULL, 0x000fc60003f05270ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x00000018ff567819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x00008880105a7816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x00008880115d7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x00000018ff657819ULL, 0x000fc40000011412ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00008880125e7816ULL, 0x000fe400000000ffULL, 0x00000018ff677819ULL, 0x000fe20000011413ULL,
0x00000010005f7306ULL, 0x0002e20000202400ULL, 0x0000888013707816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff687819ULL, 0x004fe20000011414ULL, 0x00000011005c7306ULL, 0x0005e20000202400ULL,
0x0001000012107824ULL, 0x002fe200078e00ffULL, 0x00008880146c7816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011415ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x044fe200078e00ffULL, 0x0000001c00797306ULL, 0x000fe20000202400ULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00008880156a7816ULL, 0x000fc400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000001200727306ULL, 0x0003e20000202400ULL, 0x00000018ff587819ULL, 0x000fe40000011416ULL,
0x00000018ff467819ULL, 0x000fe40000011417ULL, 0x0000888016667816ULL, 0x000fe400000000ffULL,
0x0000888017627816ULL, 0x000fe200000000ffULL, 0x0000001100757306ULL, 0x0005e20000202400ULL,
0x0000000844127824ULL, 0x002fce00078e00ffULL, 0x00000013006e7306ULL, 0x0003e20000202400ULL,
0x0000000144117824ULL, 0x104fe400078e0249ULL, 0x0000000140497824ULL, 0x000fca00078e0249ULL,
0x0000001d00747306ULL, 0x0005e20000202400ULL, 0xfffffff812137812ULL, 0x002fe200078ee211ULL,
0x0001000015117824ULL, 0x040fe400078e00ffULL, 0x0000010015157824ULL, 0x000fe400078e00ffULL,
0x0000001013137824ULL, 0x000fe200078e0242ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000001000777306ULL, 0x0003e20000202400ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000000131c783bULL, 0x004eaa0000000200ULL, 0x00000015006d7306ULL, 0x000be20000202400ULL,
0x0001000014107824ULL, 0x002fc400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000001045157824ULL, 0x020fe200078e00ffULL, 0x0000001000737306ULL, 0x0003f00000202400ULL,
0x0000001400717306ULL, 0x000be20000202400ULL, 0x0000000840107824ULL, 0x002fca00078e00ffULL,
0xfffffff810497812ULL, 0x000fe200078ee249ULL, 0x0001000016107824ULL, 0x040fe200078e00ffULL,
0x00000011006f7306ULL, 0x0003e20000202400ULL, 0x0001000017147824ULL, 0x060fe400078e00ffULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011410ULL,
0x0000010017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000001049117824ULL, 0x002fe200078e0242ULL,
0x0000001400637306ULL, 0x0003e20000202400ULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x00000018ff487819ULL, 0x004fe4000001141cULL, 0x000088801c4a7816ULL, 0x040fe200000000ffULL,
0x000000001110783bULL, 0x000ea20000000200ULL, 0x00000018ff507819ULL, 0x000fe2000001141dULL,
0x0000001600697306ULL, 0x000fe20000202400ULL, 0x000100001c147824ULL, 0x042fe200078e00ffULL,
0x000088801d527816ULL, 0x000fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001141eULL, 0x00000018ff517819ULL, 0x000fe20000011414ULL,
0x0000000145147824ULL, 0x000fe200078e0260ULL, 0x0000001700617306ULL, 0x0003e20000202400ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x000088801e547816ULL, 0x000fe400000000ffULL,
0xfffffff015157812ULL, 0x000fe200078ee214ULL, 0x000100001d147824ULL, 0x040fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001141fULL, 0x0000005a005a7306ULL, 0x000f620000202400ULL,
0x000001001d1d7824ULL, 0x000fe400078e00ffULL, 0x0000001015157824ULL, 0x000fe200078e020eULL,
0x00000018ff577819ULL, 0x000fe40000011414ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x0000001c00537306ULL, 0x0007e20000202400ULL, 0x000000001514783bULL, 0x002e6e0000000200ULL,
0x0000001d00557306ULL, 0x0005e20000202400ULL, 0x000100001e1c7824ULL, 0x048fe400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x000054105f1d7816ULL, 0x004fe40000000056ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000018ff4d7819ULL, 0x000fe40000011410ULL,
0x00000018ff4c7819ULL, 0x000fe20000011411ULL, 0x0000001c00597306ULL, 0x000be20000202400ULL,
0x00000018ff4b7819ULL, 0x000fc40000011412ULL, 0x00000018ff497819ULL, 0x000fca0000011413ULL,
0x0000005d005d7306ULL, 0x000ea20000202400ULL, 0x000054105a1c7816ULL, 0x020fe40000000079ULL,
0x000088801f5a7816ULL, 0x000fca00000000ffULL, 0x0000001e00567306ULL, 0x0007e20000202400ULL,
0x0000001c143c723cULL, 0x002fee000004183cULL, 0x000100001f1d7824ULL, 0x000fe200078e00ffULL,
0x000054105d1c7816ULL, 0x004fe20000000074ULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x00008880101e7816ULL, 0x008fe200000000ffULL, 0x0000006500657306ULL, 0x000e620000202400ULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff1f7819ULL, 0x000fca000001141fULL,
0x0000001d005f7306ULL, 0x0005f00000202400ULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x000054105c1d7816ULL, 0x004fe2000000005bULL, 0x00010000105c7824ULL, 0x000fc400078e00ffULL,
0x0000010010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000006700677306ULL, 0x000ea20000202400ULL, 0x0000001c1438723cULL, 0x000fee0000041838ULL,
0x0000007000707306ULL, 0x000ee20000202400ULL, 0x00000018ff1c7819ULL, 0x000fe20000011410ULL,
0x00000010451d7824ULL, 0x040fe200078e00ffULL, 0x0000000245107810ULL, 0x000fc80007ffe060ULL,
0xfffffff01d1d7812ULL, 0x000fe200078ee210ULL, 0x0000001f005d7306ULL, 0x000bf00000202400ULL,
0x0000001e005b7306ULL, 0x0003e20000202400ULL, 0x00008880111f7816ULL, 0x020fca00000000ffULL,
0x000000ffff107224ULL, 0x000fe400078e001fULL, 0x0000006c006c7306ULL, 0x000f620000202400ULL,
0x000000101d1e7824ULL, 0x002fe200078e020eULL, 0x00005410721d7816ULL, 0x000fe20000000065ULL,
0x00010000111f7824ULL, 0x040fe400078e00ffULL, 0x0000010011727824ULL, 0x000fe200078e00ffULL,
0x000054106e117816ULL, 0x004fe20000000067ULL, 0x00010000126e7824ULL, 0x000fe200078e00ffULL,
0x0000001c00607306ULL, 0x0003e20000202400ULL, 0x00000018ff657819ULL, 0x000fc4000001141fULL,
0x00000018ff677819ULL, 0x000fca0000011472ULL, 0x0000006800687306ULL, 0x000ea20000202400ULL,
0x000054105e1c7816ULL, 0x002fce0000000077ULL, 0x00000010005e7306ULL, 0x0007e20000202400ULL,
0x0000001c1430723cULL, 0x000fe20000041830ULL, 0x000000001e1c783bULL, 0x000e6c0000000200ULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x0000541070107816ULL, 0x008fce0000000075ULL,
0x0000006a006a7306ULL, 0x000ee20000202400ULL, 0x00000010142c723cULL, 0x000fee000004182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x000054106c107816ULL, 0x020fe20000000073ULL, 0x0000010012127824ULL, 0x000fc400078e00ffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0011ULL, 0x0000541071117816ULL, 0x004fe40000000068ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000006600667306ULL, 0x000fe80000202400ULL,
0x000000101428723cULL, 0x000fe80000041828ULL, 0x0000006b006b7306ULL, 0x000ea60000202400ULL,
0x000054106a107816ULL, 0x008fc4000000006fULL, 0x000054106d117816ULL, 0x000fe40000000064ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146eULL, 0x0000004600467306ULL, 0x000fe80000202400ULL,
0x000000101424723cULL, 0x000fe80000041824ULL, 0x0000006200627306ULL, 0x000ee60000202400ULL,
0x0000541066107816ULL, 0x004fc4000000006bULL, 0x0000541069117816ULL, 0x000fe40000000058ULL,
0x0000888013587816ULL, 0x000fe200000000ffULL, 0x0000004800487306ULL, 0x000fe80000202400ULL,
0x000000101420723cULL, 0x000fe80000041820ULL, 0x0000004a004a7306ULL, 0x000fe60000202400ULL,
0x0000541062107816ULL, 0x008fc40000000063ULL, 0x0000541061117816ULL, 0x000fe20000000046ULL,
0x000000ffff467224ULL, 0x000fe400078e0058ULL, 0x0000005100517306ULL, 0x000ea80000202400ULL,
0x000000101418723cULL, 0x000fe80000041818ULL, 0x0000005000507306ULL, 0x000ee60000202400ULL,
0x0001000013117824ULL, 0x000fc400078e00ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x000054104a107816ULL, 0x004fe40000000051ULL, 0x0000004e004e7306ULL, 0x000ea20000202400ULL,
0x00000018ff157819ULL, 0x000fe40000011411ULL, 0x0000541053117816ULL, 0x000fe40000000048ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000541055537816ULL, 0x008fe20000000050ULL,
0x0000005a005a7306ULL, 0x000ee40000202400ULL, 0x000000101c3c723cULL, 0x002fe2000004183cULL,
0x000054105d177816ULL, 0x004fca000000004eULL, 0x0000004f004f7306ULL, 0x000e620000202400ULL,
0x000054105a167816ULL, 0x008fce000000005fULL, 0x0000004d004d7306ULL, 0x000ea20000202400ULL,
0x000000161c2c723cULL, 0x000fe2000004182cULL, 0x0000541056557816ULL, 0x002fcc000000004fULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x00005410605d7816ULL, 0x004fce000000004dULL,
0x0000004b004b7306ULL, 0x000ff00000202400ULL, 0x0000004900497306ULL, 0x000ff00000202400ULL,
0x0000005200527306ULL, 0x000ff00000202400ULL, 0x0000005700577306ULL, 0x000e700000202400ULL,
0x0000005400547306ULL, 0x000ea20000202400ULL, 0x0000541052527816ULL, 0x002fce0000000057ULL,
0x0000005c005c7306ULL, 0x000e620000202400ULL, 0x000000521c38723cULL, 0x000fe20000041838ULL,
0x0000541054547816ULL, 0x004fcc0000000059ULL, 0x0000006500657306ULL, 0x000ea20000202400ULL,
0x000000541c30723cULL, 0x000fe20000041830ULL, 0x000054105b5c7816ULL, 0x002fcc000000005cULL,
0x0000006700677306ULL, 0x000e620000202400ULL, 0x0000005c1c28723cULL, 0x000fe20000041828ULL,
0x000054105e5e7816ULL, 0x004fcc0000000065ULL, 0x0000006c00687306ULL, 0x000fe20000202400ULL,
0x00005410675f7816ULL, 0x002fce000000004cULL, 0x0000006d006d7306ULL, 0x000e620000202400ULL,
0x0000005e1c24723cULL, 0x000fee0000041824ULL, 0x0000001200127306ULL, 0x000ea20000202400ULL,
0x00005410684a7816ULL, 0x002fce000000006dULL, 0x0000004600147306ULL, 0x000fe20000202400ULL,
0x00005410124b7816ULL, 0x004fce000000004bULL, 0x0000001500117306ULL, 0x000e620000202400ULL,
0x0000004a1c20723cULL, 0x000fee0000041820ULL, 0x0000001300107306ULL, 0x000ea20000202400ULL,
0x0000541014147816ULL, 0x002fe40000000011ULL, 0x0000541010157816ULL, 0x004fce0000000049ULL,
0x000000141c18723cULL, 0x000fe20000041818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff000240947ULL, 0x000fde000383ffffULL, 0x00000001ff107424ULL, 0x000fe400078e00ffULL,
0x0000000620167220ULL, 0x080fe20000410000ULL, 0x0000000621177220ULL, 0x080fe20000410000ULL,
0x000000063c157220ULL, 0x080fe20000410000ULL, 0x000000063d3d7220ULL, 0x080fe20000410000ULL,
0x000000063e3e7220ULL, 0x080fe20000410000ULL, 0x01768810091079a7ULL, 0x000262000850003fULL,
0x000000063f3f7220ULL, 0x080fe20000410000ULL, 0x0000000638387220ULL, 0x080fe20000410000ULL,
0x0000000639397220ULL, 0x080fe20000410000ULL, 0x000000063a3a7220ULL, 0x080fe20000410000ULL,
0x000000063b3b7220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000632327220ULL, 0x080fe20000410000ULL,
0x0000000633337220ULL, 0x080fe20000410000ULL, 0x000000062c2c7220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x000000062e2e7220ULL, 0x080fe20000410000ULL,
0x000000062f2f7220ULL, 0x080fe20000410000ULL, 0x0000000628147220ULL, 0x080fe20000410000ULL,
0x0000000629297220ULL, 0x080fe20000410000ULL, 0x000000062a2a7220ULL, 0x080fe20000410000ULL,
0x000000062b2b7220ULL, 0x080fe20000410000ULL, 0x0000000624247220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x0000000626267220ULL, 0x080fe20000410000ULL,
0x0000000627277220ULL, 0x080fe20000410000ULL, 0x0000000622227220ULL, 0x080fe20000410000ULL,
0x0000000623237220ULL, 0x080fe20000410000ULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061a207220ULL, 0x080fe20000410000ULL,
0x000000061b217220ULL, 0x002fce0000410000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x01768811090075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x0000001a121d7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e13ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x0000001d1a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x01768811090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000404107824ULL, 0x000fe200078e00ffULL,
0x0000000a0c00720cULL, 0x000fe20003f05270ULL, 0x0000008035117824ULL, 0x000fc600078e020eULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x0000000111287824ULL, 0x000fca00078e0210ULL,
0x0174000028107984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x00000002041a7824ULL, 0x000fe400078e00ffULL, 0x00000001360d7824ULL, 0x000fc600078e0a0dULL,
0x000000061a1a7812ULL, 0x000fc800078ec0ffULL, 0x000000011a1c7812ULL, 0x040fe400078efcffULL,
0x000000081a1e7812ULL, 0x000fe400078efcffULL, 0x0000000d1c00720cULL, 0x080fe40003f26070ULL,
0x000000101a1c7812ULL, 0x000fe400078efcffULL, 0x0000000d1e00720cULL, 0x080fe40003f06070ULL,
0x0000000d1c00720cULL, 0x000fc40003fc6070ULL, 0x000000111a1e7812ULL, 0x040fe400078efcffULL,
0x000000181a1c7812ULL, 0x040fe400078efcffULL, 0x0000000d1a00720cULL, 0x080fe40003f46070ULL,
0x0000000d1e00720cULL, 0x080fe40003fa6070ULL, 0x0000000d1c00720cULL, 0x000fe40003f66070ULL,
0x000000091a3c7812ULL, 0x000fc400078efcffULL, 0x000000191a1e7812ULL, 0x040fe400078efcffULL,
0x000000201a1c7812ULL, 0x000fe400078efcffULL, 0xff8000003e3e7808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40005000000ULL, 0xff8000003f3f7808ULL, 0x000fe40004800000ULL,
0xff8000003d3d7808ULL, 0x000fc40004800000ULL, 0x0000000d3c00720cULL, 0x080fe40003f86070ULL,
0x0000000d1e00720cULL, 0x080fe40003f46070ULL, 0x0000000d1c00720cULL, 0x000fe40003f26070ULL,
0x000000211a1e7812ULL, 0x040fe400078efcffULL, 0x000000281a1c7812ULL, 0x000fe400078efcffULL,
0xff8000003a3a7808ULL, 0x000fc40004000000ULL, 0xff80000038387808ULL, 0x000fe40004000000ULL,
0xff8000003b3b7808ULL, 0x000fe40006000000ULL, 0xff80000039397808ULL, 0x000fe40006000000ULL,
0x0000000d1e00720cULL, 0x080fe40003f06070ULL, 0x0000000d1c00720cULL, 0x000fe40003f86070ULL,
0x000000291a1e7812ULL, 0x000fc400078efcffULL, 0x000000301a1c7812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40007000000ULL, 0xff80000030307808ULL, 0x000fe40007000000ULL,
0xff80000033337808ULL, 0x000fe40006800000ULL, 0xff80000031317808ULL, 0x000fe40006800000ULL,
0x0000000d1e00720cULL, 0x000fc40003fc6070ULL, 0x0000000d1c00720cULL, 0x000fe40003fa6070ULL,
0x000000311a1e7812ULL, 0x040fe400078efcffULL, 0x000000381a1c7812ULL, 0x040fe400078efcffULL,
0x000000391a1a7812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fe40005800000ULL,
0xff8000002c2c7808ULL, 0x000fc40005800000ULL, 0xff8000002f2f7808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40005000000ULL, 0xff8000002a2a7808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fe40004800000ULL, 0x0000000d1e00720cULL, 0x080fe40003f66070ULL,
0x0000000d1c00720cULL, 0x000fc40003f46070ULL, 0x0000000d1a00720cULL, 0x000fe40003f26070ULL,
0xff8000002b2b7808ULL, 0x000fe40004000000ULL, 0xff80000029297808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000024247808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fc40007000000ULL, 0xff80000025257808ULL, 0x000fe40007000000ULL,
0xff80000022227808ULL, 0x000fe40006800000ULL, 0xff80000016167808ULL, 0x000fe40006800000ULL,
0xff80000023237808ULL, 0x000fe40005800000ULL, 0xff80000017177808ULL, 0x000fe40005800000ULL,
0xff80000020207808ULL, 0x000fc40005000000ULL, 0xff80000018187808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0xff80000019197808ULL, 0x000fce0004800000ULL,
0x000000151000720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x000000010c0c7836ULL, 0x000fe40000000000ULL, 0x0000001015107208ULL, 0x000fc80004000000ULL,
0x0000003d1000720bULL, 0x000fc80003f1e000ULL, 0x000000103d0d7208ULL, 0x000fc80004000000ULL,
0x000000380d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d38107208ULL, 0x000fc80004000000ULL,
0x000000391000720bULL, 0x000fc80003f1e000ULL, 0x00000010390d7208ULL, 0x000fc80004000000ULL,
0x000000300d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d30107208ULL, 0x000fc80004000000ULL,
0x000000311000720bULL, 0x000fc80003f1e000ULL, 0x00000010310d7208ULL, 0x000fc80004000000ULL,
0x0000002c0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d2c107208ULL, 0x000fc80004000000ULL,
0x0000002d1000720bULL, 0x000fc80003f1e000ULL, 0x000000102d0d7208ULL, 0x000fc80004000000ULL,
0x000000140d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d14107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x00000010290d7208ULL, 0x000fc80004000000ULL,
0x000000240d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d24107208ULL, 0x000fe40004000000ULL,
0x0000003e1100720bULL, 0x000fe40003f1e000ULL, 0x000000251000720bULL, 0x000fc80003f3e000ULL,
0x00000010250d7208ULL, 0x000fe40004800000ULL, 0x000000113e107208ULL, 0x000fe40004000000ULL,
0x000000160d00720bULL, 0x000fe40003f3e000ULL, 0x0000003f1000720bULL, 0x000fe40003f1e000ULL,
0x0000000d161a7208ULL, 0x000fe40004800000ULL, 0x000000103f0d7208ULL, 0x000fc40004000000ULL,
0x000000171a00720bULL, 0x000fe40003f3e000ULL, 0x0000003a0d00720bULL, 0x000fe40003f1e000ULL,
0x0000001a17117208ULL, 0x000fe40004800000ULL, 0x0000000d3a107208ULL, 0x000fe40004000000ULL,
0x000000181100720bULL, 0x000fe40003f3e000ULL, 0x0000003b1000720bULL, 0x000fc40003f1e000ULL,
0x00000011181a7208ULL, 0x000fe40004800000ULL, 0x000000103b0d7208ULL, 0x000fe40004000000ULL,
0x000000191a00720bULL, 0x000fe40003f3e000ULL, 0x000000320d00720bULL, 0x000fe40003f1e000ULL,
0x0000001a191a7208ULL, 0x000fe40004800000ULL, 0x0000000d32107208ULL, 0x000fc60004000000ULL,
0x0c401f001a117f89ULL, 0x000ee200000e0000ULL, 0x000000331000720bULL, 0x000fc80003f1e000ULL,
0x00000010330d7208ULL, 0x000fc80004000000ULL, 0x0000002e0d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d2e107208ULL, 0x000fc80004000000ULL, 0x0000002f1000720bULL, 0x000fc80003f1e000ULL,
0x000000102f0d7208ULL, 0x000fe40004000000ULL, 0x000000111a00720bULL, 0x008fe40003f3e000ULL,
0x0000002a0d00720bULL, 0x000fe40003f1e000ULL, 0x0000001a11117208ULL, 0x000fe40004800000ULL,
0x0000000d2a107208ULL, 0x000fc60004000000ULL, 0x0c201f00111a7f89ULL, 0x000ee200000e0000ULL,
0x0000002b1000720bULL, 0x000fc80003f1e000ULL, 0x000000102b0d7208ULL, 0x000fc80004000000ULL,
0x000000260d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d26107208ULL, 0x000fc80004000000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x00000010270d7208ULL, 0x000fe40004000000ULL,
0x0000001a1100720bULL, 0x008fe40003f3e000ULL, 0x000000220d00720bULL, 0x000fe40003f1e000ULL,
0x000000111a107208ULL, 0x000fe40004800000ULL, 0x0000000d221a7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b101c7820ULL, 0x000fe20000410000ULL, 0x000000231a00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b141f7823ULL, 0x100fe2000001081cULL, 0x0000001a230d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001081cULL, 0x000000200d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001081cULL, 0x0000000d201a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe2000001081cULL, 0x00000030001b7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001081cULL, 0x000000211a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2c1d7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b292c7823ULL, 0x100fe2000001081cULL, 0x0000001a211a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b16297823ULL, 0x100fe2000001081cULL, 0x0000002d00407308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b17307823ULL, 0x108fe2000001081cULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001081cULL,
0x0c401f001a0d7f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b25257823ULL, 0x000fc8000001081cULL,
0x0000001500157308ULL, 0x000ff00000000800ULL, 0x0000003d001e7308ULL, 0x000ff00000000800ULL,
0x00000018002d7308ULL, 0x000fe20000000800ULL, 0x0000000d1a00720bULL, 0x008fc80003f1e000ULL,
0x0000001a0d117208ULL, 0x000fc60004000000ULL, 0x0000003800387308ULL, 0x000fe40000000800ULL,
0x0c201f0011147f89ULL, 0x000eec00000e0000ULL, 0x0000003900397308ULL, 0x000f700000000800ULL,
0x00000031003c7308ULL, 0x000fe20000000800ULL, 0x000000383916723eULL, 0x020fce00000010ffULL,
0x0000002400317308ULL, 0x000be20000000800ULL, 0x000000141100720bULL, 0x008fc80003f1e000ULL,
0x0000001114117208ULL, 0x000fc60004000000ULL, 0x0000001d003d7308ULL, 0x000fe20000000800ULL,
0x000000151e14723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b11417820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2a1a7823ULL, 0x100fe20000010841ULL, 0x00000004ff2a7e24ULL, 0x000fe2000f8e00ffULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b247823ULL, 0x120fe20000010841ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010841ULL,
0x3f8000002a2a783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b26267823ULL, 0x000fe20000010841ULL,
0x0000003f003f7308ULL, 0x000ee20000000800ULL, 0x000000ffff2b7224ULL, 0x000fc400078e002aULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b20207823ULL, 0x000fc60000010841ULL, 0x0000003a00177308ULL, 0x000fe20000000800ULL,
0x0000003e3f15723eULL, 0x008fce00000010ffULL, 0x0000003b00187308ULL, 0x0007700000000800ULL,
0x0000001f000d7308ULL, 0x000be20000000800ULL, 0x000000ffff3b7224ULL, 0x008fe200078e002aULL,
0x000000171817723eULL, 0x020fcc00000010ffULL, 0x0000001900447308ULL, 0x000fe20000000800ULL,
0x0000001b3c18723eULL, 0x000fe200000010ffULL, 0x0000002a141c723cULL, 0x002fec00000418ffULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x0c401f00122b7f89ULL, 0x000e6e00000e0000ULL,
0x0000003300197308ULL, 0x000ef00000000800ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000321919723eULL, 0x008fce00000010ffULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b22327823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b21417823ULL, 0x000fe20000010841ULL,
0x0c401f0013227f89ULL, 0x000f6200000e0000ULL, 0x0000002b1200720bULL, 0x002fc80003f1e000ULL,
0x0000002500427308ULL, 0x0003e20000000800ULL, 0x000000122b127208ULL, 0x000fe20004000000ULL,
0x00000800352b7824ULL, 0x000fe200078e020eULL, 0x0000002e2f1b723eULL, 0x008fca00000010ffULL,
0x0000001a003a7308ULL, 0x0007e20000000800ULL, 0x000000ffff257224ULL, 0x002fce00078e002aULL,
0x0000002400337308ULL, 0x0003e20000000800ULL, 0x0000003d401a723eULL, 0x008fe400000010ffULL,
0x000000221300720bULL, 0x020fc80003f3e000ULL, 0x0000001322137208ULL, 0x000fe20004800000ULL,
0x0000002600387308ULL, 0x000fe20000000800ULL, 0x000000ffff247224ULL, 0x002fe200078e002aULL,
0x0000002d4422723eULL, 0x000fcc00000010ffULL, 0x0000002700397308ULL, 0x0002f00000000800ULL,
0x0000002c002c7308ULL, 0x000f620000000800ULL, 0x000000241824723cULL, 0x002fee000004181cULL,
0x00000038391f723eULL, 0x008fe200000010ffULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x00000031421e723eULL, 0x000fe200000010ffULL, 0x000000ffff387224ULL, 0x100fe200078e002aULL,
0x0000003a331d723eULL, 0x000fe200000010ffULL, 0x000000ffff397224ULL, 0x100fe200078e002aULL,
0x0000000d2c1c723eULL, 0x020fe200000010ffULL, 0x000000ffff3a7224ULL, 0x000fc400078e002aULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x00000003ff0d7819ULL, 0x000fe20000011604ULL,
0x000110002b2a7836ULL, 0x000fe20000000000ULL, 0xfffffff8ff2c7812ULL, 0x000fe200078ee243ULL,
0x000000ffff337224ULL, 0x000fe200078e0022ULL, 0x000000030d0d7812ULL, 0x000fc600078ec0ffULL,
0x00000020002e7308ULL, 0x000fe20000000800ULL, 0x000000381c24723cULL, 0x000fe20000041824ULL,
0x0c201f0013387f89ULL, 0x000ee200000e0000ULL, 0x000000322321723eULL, 0x002fca00000010ffULL,
0x0000004100417308ULL, 0x000e620000000800ULL, 0x000000ffff397224ULL, 0x000fce00078e0017ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000002e4123723eULL, 0x002fce00000010ffULL,
0x0000003000307308ULL, 0x000e620000000800ULL, 0x000000082c2e7836ULL, 0x000fe20000000000ULL,
0x000000381300720bULL, 0x008fc60003f3e000ULL, 0x000000010d2f7824ULL, 0x000fe400078e022eULL,
0x000000082e327824ULL, 0x000fe200078e00ffULL, 0x0000001338137208ULL, 0x000fe20004800000ULL,
0x000000082e317824ULL, 0x000fe400078e00ffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0018ULL,
0xfffffff8322f7812ULL, 0x000fe200078ee22fULL, 0x000000ffff387224ULL, 0x000fe200078e0015ULL,
0x000000293020723eULL, 0x002fe200000010ffULL, 0x000000082c297824ULL, 0x000fc400078e00ffULL,
0x000000082c307824ULL, 0x000fe400078e00ffULL, 0x000000010d2c7824ULL, 0x000fe400078e022cULL,
0x0c201f00120d7f89ULL, 0x000e6200000e0000ULL, 0x0000003a2024723cULL, 0x000fe20000041824ULL,
0x000000042c2d7836ULL, 0x000fe20000000000ULL, 0xfffffff829297812ULL, 0x000fe200078ee22cULL,
0x0000000c2c2c7836ULL, 0x000fc60000000000ULL, 0x000000ffff327224ULL, 0x000fe200078e0020ULL,
0xfffffff8302d7812ULL, 0x000fe200078ee22dULL, 0x0000001029297824ULL, 0x000fe200078e022aULL,
0xfffffff8312b7812ULL, 0x000fe200078ee22cULL, 0x000000ffff2c7224ULL, 0x000fe400078e0014ULL,
0x000000ffff307224ULL, 0x000fe400078e001cULL, 0x000000ffff317224ULL, 0x000fe400078e001eULL,
0x000000ffff3a7224ULL, 0x000fc400078e0019ULL, 0x000000ffff3b7224ULL, 0x000fe400078e001bULL,
0x000000102b2b7824ULL, 0x100fe400078e022aULL, 0x000000102f277824ULL, 0x100fe200078e022aULL,
0x0000000d1200720bULL, 0x002fe20003f1e000ULL, 0x000000102d257824ULL, 0x000fe400078e022aULL,
0x000000ffff2d7224ULL, 0x000fe200078e0016ULL, 0x000000120d127208ULL, 0x000fe20004000000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e001aULL, 0x0000000304ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff187224ULL, 0x000fc400078e001dULL, 0x000000ffff197224ULL, 0x000fe200078e001fULL,
0x0000002c29007844ULL, 0x000fe20000000200ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0023ULL, 0x0000003025007844ULL, 0x0003e20000000200ULL,
0x00000001ff147424ULL, 0x000fc600078e00ffULL, 0x0000003827007844ULL, 0x0007e80000000200ULL,
0x000000182b007844ULL, 0x0007e80000000200ULL, 0x0170001028008388ULL, 0x0007e20000000c00ULL,
0x000000ffff257224ULL, 0x002fca00078e0026ULL, 0x0172002428008388ULL, 0x0007e20000000a00ULL,
0x0000000f0c00720cULL, 0x000fe20003f06070ULL, 0x017608140bff79a7ULL, 0x000fe2000850003fULL,
0x017610140bff79a7ULL, 0x000fe2000850003fULL, 0x017618140bff79a7ULL, 0x000fe2000850003fULL,
0x017620140bff79a7ULL, 0x0003e4000850003fULL, 0x000000ffff147224ULL, 0x002fce00078e0037ULL,
0xffffffb800888947ULL, 0x00cfea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000007007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000700008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000007027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000700007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffee002b07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000569ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000006e8ULL, 0x0000000000000240ULL, 0x0000001600000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000928ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a5cULL, 0x0000000000000624ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001080ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001080ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000010c8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001100ULL, 0x0000000000011e00ULL, 0x0000001600000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012f00ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012f50ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000012f50ULL, 0x0000000000000260ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000013530ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000013530ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000010c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000011e00ULL,
0x0000000000011e00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000012f00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000012f50ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 79488;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
