/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b3d0ULL, 0x000000000001b050ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000019460ULL, 0x0000000000000190ULL, 0x000b0022000004daULL, 0x00000000000195f0ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000019630ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000019680ULL, 0x0000000000000100ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019780ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001946000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x0063a80400288080ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8e082880808c0828ULL,
0x2880809408288080ULL, 0x8097082880809508ULL, 0x08288080a5082880ULL, 0x8080ad08288080abULL,
0xbd08288080b10828ULL, 0x2880808508288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808085ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001946000000000ULL,
0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL,
0x2880808228808085ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080850828ULL,
0x2880808a08288080ULL, 0x808e082880808c08ULL, 0x0828808094082880ULL, 0x8080970828808095ULL,
0xab08288080a50828ULL, 0x288080ad08288080ULL, 0x80bd08288080b108ULL, 0x1628808088082880ULL,
0x0000031028808280ULL, 0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x000195f000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080850828ULL, 0x2880808c08288080ULL,
0x8094082880808e08ULL, 0x0828808095082880ULL, 0x8080a50828808097ULL, 0xad08288080ab0828ULL,
0x288080b108288080ULL, 0x828016288080bd08ULL, 0x0000000003102880ULL, 0x8080bd9200000000ULL,
0x0000000000220028ULL, 0x0000002cffffffffULL, 0x000001e800000000ULL, 0x0001963000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8094288080bd0900ULL, 0x0000000000002880ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080850828ULL, 0x2880808c08288080ULL,
0x8094082880808e08ULL, 0x0828808097082880ULL, 0x8080ab08288080a5ULL, 0xb108288080ad0828ULL,
0x288080bd08288080ULL, 0x8280162880809508ULL, 0x0000000003102880ULL, 0x8080959200000000ULL,
0x0000000000220028ULL, 0x0000002cffffffffULL, 0x000002a800000000ULL, 0x0001968000000000ULL,
0x0000010000000000ULL, 0x0000080400000000ULL, 0x8094288080950900ULL, 0x0000000000002880ULL,
0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000018ULL, 0x000c170400601903ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL,
0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0x0000090000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000002b001342804ULL, 0x0000058000000480ULL, 0x0000272000002690ULL, 0x000029a000002840ULL,
0x00002e5000002e20ULL, 0x00002f3000002ec0ULL, 0x00005e6000005dd0ULL, 0x000060f000005f90ULL,
0x000065b000006580ULL, 0x0000669000006620ULL, 0x000093a000009300ULL, 0x00009630000094d0ULL,
0x00009af000009ac0ULL, 0x00009bd000009b60ULL, 0x0000c9600000c8c0ULL, 0x0000cbe00000ca80ULL,
0x0000d0900000d060ULL, 0x0000d1700000d100ULL, 0x0000f2900000f280ULL, 0x000179d000017990ULL,
0x000179f0000179e0ULL, 0x00017a6000017a40ULL, 0x00017a9000017a80ULL, 0x0001878000018730ULL,
0x00018850000187f0ULL, 0x00018930000188c0ULL, 0x000189e000018990ULL, 0x00018ab000018a50ULL,
0x00018b9000018b20ULL, 0x00018c4000018bf0ULL, 0x00018d1000018cb0ULL, 0x00018df000018d80ULL,
0x00018ea000018e50ULL, 0x00018f7000018f10ULL, 0x0001905000018fe0ULL, 0x00019140000190c0ULL,
0x00019240000191c0ULL, 0x00019340000192c0ULL, 0x00019440000193c0ULL, 0x0000038004403904ULL,
0x00017600000000ffULL, 0x00000400003f0100ULL, 0x000176080000000dULL, 0x000004f0003f0120ULL,
0x000176880000000dULL, 0x00000510003f0120ULL, 0x000176a80000000dULL, 0x00000530003f0120ULL,
0x000176c80000000dULL, 0x00000910003f0120ULL, 0x00017600000000ffULL, 0x00000b10003f0107ULL,
0x0000000400000009ULL, 0x00000bc0003f0102ULL, 0x0000000000000009ULL, 0x00001400003f0101ULL,
0x000176a800000005ULL, 0x00001550003f0107ULL, 0x000176a800000005ULL, 0x000015b0003f0101ULL,
0x000176c800000007ULL, 0x00001750003f0101ULL, 0x000176cc00000012ULL, 0x00001940003f0105ULL,
0x000176cc00000012ULL, 0x00002290003f0105ULL, 0x000176b000000012ULL, 0x00002340003f0107ULL,
0x000176b000000012ULL, 0x000023a0003f0101ULL, 0x0001760800000007ULL, 0x000023c0003f0101ULL,
0x0001760c00000007ULL, 0x00002590003f0105ULL, 0x0001760c00000007ULL, 0x00002b80003f0105ULL,
0x000176ac00000034ULL, 0x00002d50003f0105ULL, 0x000176ac00000034ULL, 0x00004f40003f0105ULL,
0x0000000000000014ULL, 0x00004fa0003f0101ULL, 0x000176880000006eULL, 0x00004fd0003f0101ULL,
0x0000000400000006ULL, 0x00005190003f0105ULL, 0x0000000400000006ULL, 0x000059e0003f0105ULL,
0x000176a800000016ULL, 0x00005ab0003f0107ULL, 0x000176a800000016ULL, 0x00005b10003f0101ULL,
0x0001762800000007ULL, 0x00005b30003f0101ULL, 0x0001762c00000007ULL, 0x00005d00003f0105ULL,
0x0001762c00000007ULL, 0x000062e0003f0105ULL, 0x000176b40000003cULL, 0x000064b0003f0105ULL,
0x000176b40000003cULL, 0x00008470003f0105ULL, 0x0000000000000012ULL, 0x000084d0003f0101ULL,
0x0001769000000014ULL, 0x00008500003f0101ULL, 0x0000000400000006ULL, 0x000086c0003f0105ULL,
0x0000000400000006ULL, 0x00008f10003f0105ULL, 0x000176b000000014ULL, 0x00008fe0003f0107ULL,
0x000176b000000014ULL, 0x00009040003f0101ULL, 0x0001764800000007ULL, 0x00009060003f0101ULL,
0x0001764c00000007ULL, 0x00009230003f0105ULL, 0x0001764c00000007ULL, 0x00009820003f0105ULL,
0x000176ac0000003cULL, 0x000099f0003f0105ULL, 0x000176ac0000003cULL, 0x0000b9b0003f0105ULL,
0x0000000000000010ULL, 0x0000ba10003f0101ULL, 0x000176980000000cULL, 0x0000ba40003f0101ULL,
0x0000000400000006ULL, 0x0000bc00003f0105ULL, 0x0000000400000006ULL, 0x0000c520003f0105ULL,
0x000176a80000000bULL, 0x0000c5b0003f0107ULL, 0x000176a80000000bULL, 0x0000c610003f0101ULL,
0x0001766800000004ULL, 0x0000c640003f0101ULL, 0x0001766c00000004ULL, 0x0000c810003f0105ULL,
0x0001766c00000004ULL, 0x0000cdc0003f0105ULL, 0x000176b400000017ULL, 0x0000cf90003f0105ULL,
0x000176b400000017ULL, 0x0000f050003f0105ULL, 0x0000000000000006ULL, 0x0000f0d0003f0101ULL,
0x0000000000000010ULL, 0x00010280003f0101ULL, 0x00017600000000ffULL, 0x00011b70003f0101ULL,
0x00017604000000ffULL, 0x00011d40003f0105ULL, 0x00017604000000ffULL, 0x00011f70003f0105ULL,
0x00017600000000ffULL, 0x00011fa0003f0101ULL, 0x00017604000000ffULL, 0x00012160003f0105ULL,
0x00017604000000ffULL, 0x00015f00003f0105ULL, 0x0000000000000077ULL, 0x00015fa0003f0101ULL,
0x0000000400000077ULL, 0x00016170003f0105ULL, 0x0000000400000077ULL, 0x00018570003f0105ULL,
0x000000000000007aULL, 0x000185d0003f0101ULL, 0x000000080000007aULL, 0x00018630003f0101ULL,
0x000000100000007aULL, 0x000186a0003f0101ULL, 0x000000180000007aULL, 0x00053803003f0101ULL,
0x0000fb7000201c04ULL, 0x0000fdb00000fba0ULL, 0x000100a00000ff10ULL, 0x000121c0000101a0ULL,
0x00000401000186f0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000344ULL, 0x0000001b00000002ULL,
0x0000000000000284ULL, 0x0000001b00000002ULL, 0x00000000000001d4ULL, 0x0000001b00000002ULL,
0x0000000000000104ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x000000000000031cULL, 0x0000001b00000002ULL, 0x000000000000025cULL, 0x0000001b00000002ULL,
0x00000000000001aeULL, 0x0000001b00000002ULL, 0x00000000000000dfULL, 0x0000001b00000002ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e0c7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x00000400037d7a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a7dULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x000000017d7d0810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x000000017d7d1810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff7daa12ULL, 0x000fc800078e33ffULL,
0x0000007d00007306ULL, 0x000e620000209000ULL, 0x000000ff7d00720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000037d047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000006037b7227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a7bULL,
0x000000007d007224ULL, 0x000fca00078e0206ULL, 0x0000007d0000720cULL, 0x000fe20003f66070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000fe400000e0000ULL,
0x00000000020d7a24ULL, 0x010fca00078e0207ULL, 0x000000ff0d00720cULL, 0x000fc60003f45270ULL,
0x0000000100003824ULL, 0x000fe200078e0a7dULL, 0x000000017b7b3810ULL, 0x000fe40007ffe0ffULL,
0x0000007f0d00780cULL, 0x040fe40003f04070ULL, 0x0000007d0000720cULL, 0x000fe40003f86070ULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000030d00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL,
0xff317217ff0a8424ULL, 0x000fe400078e00ffULL, 0x000000017b7b4810ULL, 0x000fe20007ffe0ffULL,
0x01760002ff00a388ULL, 0x000fe20000000a00ULL, 0x0000007dff7bd212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f84070ULL,
0x0174000a0d008388ULL, 0x0003e20000004800ULL, 0x7fffffc0ff059424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fc400078e0a7bULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x017608040d009388ULL, 0x0005e20000008a00ULL, 0x000000007d7d7224ULL, 0x000fe200078e0206ULL,
0x00000005ff007819ULL, 0x000fe20000011607ULL, 0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL,
0x0000000000067919ULL, 0x000ee20000002700ULL, 0x000000107d717824ULL, 0x000fe200078e00ffULL,
0x00005a007b0a7a19ULL, 0x002fe200000006ffULL, 0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x0000000471077c10ULL, 0x000fc4000fffe1ffULL, 0x0000000471007c0cULL, 0x000fe2000bf03070ULL,
0x3fffffc0ff04c424ULL, 0x004fe200078e00ffULL, 0x0000001007077817ULL, 0x000fe20003800000ULL,
0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL, 0x017688080d00b388ULL, 0x000fe40000008a00ULL,
0x000000ff077c7207ULL, 0x000fe40000000000ULL, 0x0176a8020d00b388ULL, 0x0003e40000008a00ULL,
0x000000107c00780cULL, 0x000fc40003f05270ULL, 0x0176c8040d00c388ULL, 0x000fe20000008a00ULL,
0x0000580006077a24ULL, 0x008fe400078e02ffULL, 0x000000040b027824ULL, 0x002fe400078e0200ULL,
0x0000000c07077224ULL, 0x000fe400078e020aULL, 0x0000000202027824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x000000027c057217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff097819ULL, 0x002fca0000011603ULL,
0x00000001020a7824ULL, 0x000fe400078e0209ULL, 0x0000000105027824ULL, 0x000fe400078e0a02ULL,
0x0000000171047824ULL, 0x000fc600078e020aULL, 0x000000020900720cULL, 0x000fe20003f06070ULL,
0x000000010a027824ULL, 0x000fe200078e0203ULL, 0x0000000404087c12ULL, 0x000fe2000f8e30ffULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x00005a00ff047a19ULL, 0x000fc60000011604ULL,
0x0000000107077824ULL, 0x000fe200078e0208ULL, 0xfffffff009027812ULL, 0x000fe200078ee202ULL,
0x0000001003087824ULL, 0x000fe400078e00ffULL, 0x0000000c04047224ULL, 0x000fc600078e0207ULL,
0x000000f008077812ULL, 0x000fe200078ec0ffULL, 0x0000010004047825ULL, 0x000fca00078e00ffULL,
0x0000000704077212ULL, 0x000fc800078efcffULL, 0x00005e0007047a10ULL, 0x000fe20007f3e0ffULL,
0x0000001002077824ULL, 0x000fc600078e00ffULL, 0x00005f0005057a10ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000203027211ULL, 0x002fca00078fe0ffULL,
0x0000000171047824ULL, 0x000fca00078e0202ULL, 0x0000000404087c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fc60000011604ULL, 0x0000000107077824ULL, 0x000fe400078e0208ULL,
0x0000001003087824ULL, 0x000fe400078e00ffULL, 0x0000000c04047224ULL, 0x000fe400078e0207ULL,
0x0000000102077824ULL, 0x000fe200078e0203ULL, 0x000000f008097812ULL, 0x000fe200078ec0ffULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000001002027824ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc800078efcffULL, 0xfffffff002077812ULL, 0x000fe400078ee207ULL,
0x00005e0004047a10ULL, 0x000fc60007f1e0ffULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0x00005f0005057a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200047300ULL, 0x000e7000000e0000ULL, 0x0000000200077309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x000000ffff097224ULL, 0x004fc400078e0a07ULL,
0x00000004ff077424ULL, 0x000fc800078e00ffULL, 0x0000660006047625ULL, 0x000fcc00078e0007ULL,
0x01760409ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01760000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000804707981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000003f70767810ULL, 0x044fe40007ffe0ffULL,
0x000000ff70027810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff767819ULL, 0x000fe40000011676ULL,
0x00000008ff787819ULL, 0x000fca0000011602ULL, 0x0000f75000008947ULL, 0x000fea0003800000ULL,
0x00000002ff7a7819ULL, 0x000fe20000011600ULL, 0x00000003ff0c7424ULL, 0x000fc600078e00ffULL,
0x03ffffff7a057812ULL, 0x000fc800078ec0ffULL, 0x000000760500720cULL, 0x000fda0003f06070ULL,
0x0000000206048824ULL, 0x000fe400078e00ffULL, 0x00006800ff098624ULL, 0x002fc800078e00ffULL,
0x00006800040a8624ULL, 0x000fe200078e0209ULL, 0x0001768800097811ULL, 0x000fe200078e18ffULL,
0xffffffffff047424ULL, 0x000fe400078e00ffULL, 0x00000001050a8824ULL, 0x000fe200078e020aULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040c09ff738cULL, 0x0003e20000000000ULL,
0x000064000a0a8625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000080a048981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x000000407b777824ULL, 0x000fe200078e00ffULL, 0x00000001ff737819ULL, 0x000fe20000011600ULL,
0x0000000009ff7f8cULL, 0x0007e8000c80043fULL, 0x00000020730d7824ULL, 0x000fca00078e00ffULL,
0x0000002077027812ULL, 0x000fe200078ef80dULL, 0x00005900040c7a24ULL, 0x006fe200078e02ffULL,
0x0000000100047812ULL, 0x000fc600078ec0ffULL, 0x000000400c1b7824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000000d70097217ULL, 0x008fe20007800000ULL,
0x00000010040a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0b7819ULL, 0x000fe40000011603ULL,
0x000062001b157a11ULL, 0x000fe200078838ffULL, 0x0000000109097824ULL, 0x000fe200078e0a0dULL,
0x000000040b0e7810ULL, 0x040fe20007ffe0ffULL, 0x000000010a0c7824ULL, 0x000fe200078e020bULL,
0x0000000c0b0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a09097217ULL, 0x000fe20007800000ULL,
0x000000010c0d7824ULL, 0x040fe200078e0203ULL, 0x000063001b1b7a11ULL, 0x000fe200020f3cffULL,
0x000000080c127824ULL, 0x000fc400078e00ffULL, 0x0000000109097824ULL, 0x000fe400078e0a0aULL,
0x000000010a107824ULL, 0x000fe200078e020fULL, 0xfffffff812127812ULL, 0x000fe400078ee20dULL,
0x000000080b0d7810ULL, 0x000fe40007ffe0ffULL, 0x000000090e00720cULL, 0x080fe20003f46070ULL,
0x000000010a0e7824ULL, 0x040fe200078e020eULL, 0x000000090d00720cULL, 0x080fe20003f26070ULL,
0x000000010a0d7824ULL, 0x000fe200078e020dULL, 0x000000090b00720cULL, 0x080fe20003f66070ULL,
0x000000010e0a7824ULL, 0x040fe200078e0203ULL, 0x000000090f00720cULL, 0x000fe20003f06070ULL,
0x000000080e117824ULL, 0x000fc400078e00ffULL, 0x00000001020b7824ULL, 0x000fe400078e020cULL,
0x000000010d0c7824ULL, 0x000fe200078e0203ULL, 0xfffffff811147812ULL, 0x000fe200078ee20aULL,
0x000000080d137824ULL, 0x000fe400078e00ffULL, 0x000000800b0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff813167812ULL, 0x000fe200078ee20cULL, 0x00000001020c7824ULL, 0x000fe200078e020eULL,
0x000000700a0a7812ULL, 0x000fe200078ef808ULL, 0x00000001020e7824ULL, 0x040fe400078e020dULL,
0x0000000102117824ULL, 0x000fe200078e0210ULL, 0x0000000a150a7210ULL, 0x000fe20007f9e0ffULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000000110027824ULL, 0x000fe200078e0203ULL,
0x000000700c137812ULL, 0x000fe200078ef808ULL, 0x0000000810097824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff809027812ULL, 0x000fe200078ee202ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x000000700e0c7812ULL, 0x100fe400078ef808ULL,
0x0001300073097811ULL, 0x000fe200078e68ffULL, 0x000000010b0b7824ULL, 0x000fe200020e061bULL,
0x00000070100e7812ULL, 0x000fe400078ef808ULL, 0x0000001513087210ULL, 0x080fe20007f9e0ffULL,
0x0000001012137824ULL, 0x100fe200078e0209ULL, 0x000000150c0c7210ULL, 0x080fe20007fbe0ffULL,
0x0000001016177824ULL, 0x100fe200078e0209ULL, 0x000000150e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001014157824ULL, 0x100fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000d901c48ULL, 0x0000001002197824ULL, 0x000fc400078e0209ULL,
0x000000010d097824ULL, 0x100fe400020e061bULL, 0x000000010f0d7824ULL, 0x100fe400028e061bULL,
0x00000001110f7824ULL, 0x000fe200030e061bULL, 0x0000000008157faeULL, 0x0003e8000d101c48ULL,
0x000000000c177faeULL, 0x0003e8000c901c48ULL, 0x000000000e197faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010040a7824ULL, 0x008fe200078e00ffULL,
0x000062001b137a11ULL, 0x000fc400078038ffULL, 0x0001300073197811ULL, 0x000fe400078e68ffULL,
0x0000000a03097211ULL, 0x000fe400078fe8ffULL, 0x000063001b1b7a11ULL, 0x000fe400000f3cffULL,
0x00000004090c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x040fe200078e0203ULL,
0x00000008090d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008090b7824ULL, 0x000fe400078e00ffULL,
0x000000080c147824ULL, 0x000fc400078e00ffULL, 0x000000010d0e7824ULL, 0x100fe200078e0203ULL,
0xfffffff80b127812ULL, 0x000fe200078ee20aULL, 0x000000010c0b7824ULL, 0x000fe400078e0203ULL,
0x00000001020a7824ULL, 0x000fe200078e0209ULL, 0x0000000c09097810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff80f167812ULL, 0x000fe200078ee20eULL,
0x00000001020c7824ULL, 0x000fe200078e020cULL, 0x000000700a0a7812ULL, 0x000fe200078ef808ULL,
0x00000001020e7824ULL, 0x040fe400078e020dULL, 0x0000000102107824ULL, 0x000fe200078e0209ULL,
0x0000000a130a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000109027824ULL, 0x040fe400078e0203ULL,
0x0000000809097824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff809027812ULL, 0x000fe200078ee202ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c097812ULL, 0x000fc600078ef808ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e0c7812ULL, 0x000fc600078ef808ULL, 0x000000010b0b7824ULL, 0x000fe200000e061bULL,
0x00000070100e7812ULL, 0x000fe200078ef808ULL, 0x0000001014157824ULL, 0x100fe200078e0219ULL,
0x0000000913087210ULL, 0x040fe20007f1e0ffULL, 0x0000001016177824ULL, 0x100fe200078e0219ULL,
0x0000000c130c7210ULL, 0x040fe40007f3e0ffULL, 0x0000000e130e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001012137824ULL, 0x000fe400078e0219ULL, 0x000000010d097824ULL, 0x000fc400000e061bULL,
0x000000010f0d7824ULL, 0x000fe200008e061bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000b901c48ULL, 0x0000001002197824ULL, 0x000fe400078e0219ULL,
0x00000001110f7824ULL, 0x000fe200010e061bULL, 0x0000000008157faeULL, 0x0003e8000b901c48ULL,
0x000000000c177faeULL, 0x0003e8000b901c48ULL, 0x000000000e197faeULL, 0x0003e4000b901c48ULL,
0x0000000105027810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0f7424ULL, 0x002fc600078e00ffULL,
0x000000760200720cULL, 0x000fda0003f06070ULL, 0x0000000206058824ULL, 0x000fe400078e00ffULL,
0x00006800ff088624ULL, 0x000fc800078e00ffULL, 0x0000680005058624ULL, 0x000fc800078e0208ULL,
0x0000000105088824ULL, 0x000fe400078e0202ULL, 0x0000001073057824ULL, 0x040fe400078e00ffULL,
0x0000640008088625ULL, 0x000fe400078e0007ULL, 0x00000000050473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000008080f8981ULL, 0x000522000c1e1900ULL,
0x000000ff7800720cULL, 0x000fe20003f05270ULL, 0x0000000873077824ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000176a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x0176a800050a7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176c80007087f8cULL, 0x000662000c80043fULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000dab000008947ULL, 0x000fea0003800000ULL,
0x0000001005057812ULL, 0x00afe200078ec0ffULL, 0x0000000206797824ULL, 0x000fc400078e00ffULL,
0x00006800ff067624ULL, 0x000fe400078e00ffULL, 0x000000207a057824ULL, 0x000fe400078e0205ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x0000000804047824ULL, 0x000fe400078e0205ULL,
0x0000680079797624ULL, 0x000fe400078e0206ULL, 0xff317217ff0c7424ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff727224ULL, 0x004fca00078e0002ULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x0000000400067824ULL, 0x000fca00078e00ffULL, 0xfffffff806127812ULL, 0x000fc800078ec0ffULL,
0x000176c812137810ULL, 0x000fe20007ffe0ffULL, 0x0176cc0012077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000022000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fe200078e0013ULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000610157210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000001506067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176cc0012077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fc400078e0013ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x0000000105117810ULL, 0x000fe20007ffe0ffULL, 0x000059000f0f7a24ULL, 0x010fc600078e02ffULL,
0xffffffe0070e7812ULL, 0x000fe200078ec0ffULL, 0x000000400f3d7824ULL, 0x000fe200078e00ffULL,
0x000000781100720cULL, 0x000fc60003f26070ULL, 0x00000100050e7824ULL, 0x000fca00078e020eULL,
0x000000400e107810ULL, 0x000fc80007ffe0ffULL, 0x00000020100e7812ULL, 0x000fca00078ec0ffULL,
0x0000000177157824ULL, 0x000fe200078e020eULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x00000010070e7812ULL, 0x000fe400078ec0ffULL, 0x0000001070077217ULL, 0x000fe40007800000ULL,
0x00000003ff117819ULL, 0x000fe40000011603ULL, 0x000062003d177a11ULL, 0x000fe200078a38ffULL,
0x0000000107077824ULL, 0x000fe200078e0a10ULL, 0x0000000811367810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x040fe200078e020eULL, 0x0000000411127810ULL, 0x000fc40007ffe0ffULL,
0x0000000e07077217ULL, 0x000fe20007800000ULL, 0x00000001100f7824ULL, 0x040fe200078e0203ULL,
0x000063003d3d7a11ULL, 0x000fe200028f3cffULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x0000000107077824ULL, 0x000fc600078e0a0eULL, 0xfffffff816167812ULL, 0x000fe400078ee20fULL,
0x000000071100720cULL, 0x0c0fe40003f86070ULL, 0x000000073600720cULL, 0x0c0fe20003f46070ULL,
0x0000000136367824ULL, 0x000fe200078e020eULL, 0x0000000c11117810ULL, 0x000fe40007ffe0ffULL,
0x000000071200720cULL, 0x080fe20003f66070ULL, 0x00000001360f7824ULL, 0x040fe200078e0203ULL,
0x000000071100720cULL, 0x000fe20003f06070ULL, 0x00000008363c7824ULL, 0x000fc400078e00ffULL,
0x0000000112127824ULL, 0x100fe400078e020eULL, 0x00000001113e7824ULL, 0x000fe200078e020eULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL, 0x0000001003117824ULL, 0x000fe400078e00ffULL,
0x00000001150e7824ULL, 0x040fe400078e0210ULL, 0x0000000115147824ULL, 0x000fe200078e0212ULL,
0x0000007011357812ULL, 0x000fe200078ec0ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000112077824ULL, 0x000fe200078e0203ULL, 0x000000350e0e7212ULL, 0x000fe200078efcffULL,
0x0000000812347824ULL, 0x000fe400078e00ffULL, 0x0000000115107824ULL, 0x000fe200078e0236ULL,
0x0000000e170e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000115127824ULL, 0x000fe200078e023eULL,
0xfffffff834347812ULL, 0x000fe200078ee207ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000003514147212ULL, 0x000fc600078efcffULL,
0x000000013e077824ULL, 0x000fe200078e0203ULL, 0x0000003510107212ULL, 0x000fe200078efcffULL,
0x000000083e367824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee207ULL, 0x000000010f0f7824ULL, 0x100fe200028e063dULL,
0x0000001714147210ULL, 0x000fe40007fbe0ffULL, 0x0000003512127212ULL, 0x000fe400078efcffULL,
0x0001400073077811ULL, 0x000fe200078e68ffULL, 0x0000000115157824ULL, 0x000fe200028e063dULL,
0x0000001710107210ULL, 0x080fe40007fbe0ffULL, 0x0000001712127210ULL, 0x000fe20007fde0ffULL,
0x0000001016177824ULL, 0x000fc400078e0207ULL, 0x0000001034357824ULL, 0x100fe400078e0207ULL,
0x000000103c377824ULL, 0x000fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e177faeULL, 0x0003e2000e101c48ULL, 0x0000000111117824ULL, 0x000fe400028e063dULL,
0x0000001036077824ULL, 0x000fe200078e0207ULL, 0x0000000014357faeULL, 0x0003e2000d901c48ULL,
0x0000000113137824ULL, 0x000fc600030e063dULL, 0x0000000010377faeULL, 0x0003e8000d101c48ULL,
0x0000000012077faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x00000010070e7812ULL, 0x000fe200078ec0ffULL, 0x0000001003137824ULL, 0x000fe200078e00ffULL,
0x000062003d377a11ULL, 0x000fe400078038ffULL, 0x0000000e030e7211ULL, 0x000fe400078fe8ffULL,
0x0000007013357812ULL, 0x000fc400078ec0ffULL, 0x000000040e107810ULL, 0x040fe20007ffe0ffULL,
0x000000010e077824ULL, 0x140fe200078e0203ULL, 0x000000080e127810ULL, 0x040fe20007ffe0ffULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0x000063003d3d7a11ULL, 0x000fe200000f3cffULL,
0x00000001100f7824ULL, 0x040fe200078e0203ULL, 0x00014000733f7811ULL, 0x000fe200078e68ffULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0xfffffff814077812ULL, 0x000fe200078ee207ULL,
0x0000000112117824ULL, 0x000fe200078e0203ULL, 0x0000000c0e147810ULL, 0x000fe20007ffe0ffULL,
0x0000000812347824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee20fULL,
0x00000001150f7824ULL, 0x000fc400078e020eULL, 0x0000000115107824ULL, 0x000fe200078e0210ULL,
0xfffffff834347812ULL, 0x000fe200078ee211ULL, 0x000000800f0e7825ULL, 0x000fc800078e00ffULL,
0x0000000115127824ULL, 0x040fe200078e0212ULL, 0x000000350e0e7212ULL, 0x000fe200078efcffULL,
0x0000000115157824ULL, 0x000fe400078e0214ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000e370e7210ULL, 0x000fc60007f1e0ffULL, 0x0000000114177824ULL, 0x000fe200078e0203ULL,
0x0000003510107212ULL, 0x000fe200078efcffULL, 0x0000000814367824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee217ULL,
0x0000008015147825ULL, 0x000fe200078e00ffULL, 0x0000003512127212ULL, 0x000fc600078efcffULL,
0x000000010f0f7824ULL, 0x000fe200000e063dULL, 0x0000003514147212ULL, 0x000fe200078efcffULL,
0x0000001007077824ULL, 0x100fe200078e023fULL, 0x0000001037107210ULL, 0x040fe20007f1e0ffULL,
0x0000001016177824ULL, 0x100fe200078e023fULL, 0x0000001237127210ULL, 0x040fe20007f5e0ffULL,
0x0000001034357824ULL, 0x000fe200078e023fULL, 0x0000001437147210ULL, 0x000fe20007f7e0ffULL,
0x0000000111117824ULL, 0x100fe200000e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000b901c48ULL, 0x0000000113137824ULL, 0x000fc400010e063dULL,
0x0000001036377824ULL, 0x000fe200078e023fULL, 0x0000000010177faeULL, 0x0003e2000b901c48ULL,
0x0000000115157824ULL, 0x000fc600018e063dULL, 0x0000000012357faeULL, 0x0003e8000b901c48ULL,
0x0000000014377faeULL, 0x0003e4000b901c48ULL, 0x0000000800077824ULL, 0x002fe200078e00ffULL,
0x0000000102107810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0f7424ULL, 0x000fc600078e00ffULL,
0xfffffff007127812ULL, 0x040fe400078ec0ffULL, 0x000000761000720cULL, 0x000fe40003f06070ULL,
0x00000000120473c2ULL, 0x000e6200000e0000ULL, 0xffffffe0070e7812ULL, 0x040fe400078ec0ffULL,
0x0000001007137812ULL, 0x040fe400078ec0ffULL, 0x0000000807077812ULL, 0x000fcc00078ec0ffULL,
0x0000000179108824ULL, 0x000fe400078e0210ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0x0000000e07077210ULL, 0x000fe40007ffe013ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640010108625ULL, 0x000fca00078e0011ULL, 0x00000008100f8981ULL, 0x000722000c1e1900ULL,
0x000176b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x008fec0000008000ULL,
0x0176b00012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176080007167f8cULL, 0x0006a4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x01760c0007157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x00cfe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410357210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011415ULL,
0x000000350e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x000000020e0e7819ULL, 0x000fc80000001215ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760c0007157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001003637824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe20000011603ULL,
0x00000020000e7824ULL, 0x000fc600078e00ffULL, 0x0000007063637812ULL, 0x000fe400078ec0ffULL,
0xffffff800e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000c74747812ULL, 0x000fc800078ec0ffULL,
0x0000000e740e7210ULL, 0x000fca0007ffe063ULL, 0x017000000e117984ULL, 0x000ea80000000800ULL,
0x017200000e107984ULL, 0x0006620000000800ULL, 0x0000000c1100720bULL, 0x004fe20003f1d000ULL,
0x000160727f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c177812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff167424ULL, 0x000fe400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fd200078e000cULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000007a00720cULL, 0x000fe40003f05270ULL,
0x0000000c1100720bULL, 0x000fe20003f54000ULL, 0x000160327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000167806ULL, 0x000fc400010e0100ULL, 0x0000008000158824ULL, 0x000fe200078e0263ULL,
0x0000000c110e7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991016147816ULL, 0x000fe200000000ffULL, 0x0000000174158824ULL, 0x000fca00078e0215ULL,
0x0174000e15008388ULL, 0x0005e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000c0e0c7221ULL, 0x004fe20000010100ULL,
0x000000ff16ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00357308ULL, 0x000ea40000000800ULL,
0x000000350d0d7220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe20000011603ULL, 0x00015f727f007947ULL, 0x000fea000b800000ULL,
0x00001f14353c7589ULL, 0x0004e400000e0000ULL, 0x0000003c38387220ULL, 0x08cfe40000410000ULL,
0x0000003c39397220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000003c20207220ULL, 0x080fe40000410000ULL,
0x0000003c21217220ULL, 0x000fc40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c28287220ULL, 0x080fe40000410000ULL,
0x0000003c29297220ULL, 0x080fe40000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000003c2d2d7220ULL, 0x000fc40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x080fe40000410000ULL, 0x0000003c18187220ULL, 0x080fe40000410000ULL,
0x0000003c19197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803147811ULL, 0x000fe200078ff0ffULL, 0x00015e727f007947ULL, 0x000fea000b800000ULL,
0x00001f14353c7589ULL, 0x0004e400000e0000ULL, 0x0000003c3a3a7220ULL, 0x08cfe40000410000ULL,
0x0000003c3b3b7220ULL, 0x080fe40000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c22227220ULL, 0x080fe40000410000ULL,
0x0000003c23237220ULL, 0x000fc40000410000ULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000003c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x080fe40000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe40000410000ULL,
0x0000003c1b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff17ff7812ULL, 0x000fe20007806016ULL, 0x00000001ff167424ULL, 0x000fd800078e00ffULL,
0x8000000e11110221ULL, 0x000fe20000010000ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100080308ULL, 0x000ea40000000800ULL,
0x0000000810100220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d100d7221ULL, 0x002fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x00000008000c7824ULL, 0x000fca00078e00ffULL, 0xfffffff00c347812ULL, 0x000fca00078ec0ffULL,
0x0176ac00340c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011415ULL,
0x000000170c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x000000020c0c7819ULL, 0x000fc80000001215ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac00340c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910160b7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0b00720cULL, 0x000fda0003fc5270ULL, 0x0000016000006947ULL, 0x000fea0003800000ULL,
0x00000008ff09723eULL, 0x000fe400000010ffULL, 0x00000002ff0c7819ULL, 0x000fe40000011603ULL,
0x00005410090b7816ULL, 0x000fe20000000009ULL, 0x00015a527f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0b097589ULL, 0x0002a400000e0000ULL, 0x000000080c147810ULL, 0x000fe20007ffe0ffULL,
0x00015aa27f007947ULL, 0x000fea000b800000ULL, 0x00001f140b0a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100c147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e000bULL, 0x00002ed0003d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0001676000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180c147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e000bULL,
0x00002f40003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x000166f000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002006e7824ULL, 0x040fe200078e00ffULL,
0x00000007030b7812ULL, 0x04afe200078ec0ffULL, 0x00000200004e7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000803107812ULL, 0x000fe400078ec0ffULL,
0x000000046e0c7812ULL, 0x000fe400078ec0ffULL, 0x000000080b507812ULL, 0x000fe400078ef803ULL,
0x0000000c03117211ULL, 0x000fc400078fe0ffULL, 0xfffff8004e4e7812ULL, 0x000fe200078ec0ffULL,
0x00000008506d7824ULL, 0x040fe400078e00ffULL, 0x00000001506a7824ULL, 0x000fca00078e0211ULL,
0xfffffff86d6d7812ULL, 0x000fca00078ee26aULL, 0x000000106d6d7824ULL, 0x000fc800078e00ffULL,
0x000000016d497824ULL, 0x000fc400078e024eULL, 0x0000000400117824ULL, 0x000fe200078e00ffULL,
0x00000004ff6c7819ULL, 0x000fe40000011603ULL, 0x0000000b103c7212ULL, 0x044fe400078efcffULL,
0x0000000411117812ULL, 0x000fe400078ec0ffULL, 0x0001300073657811ULL, 0x000fe400078e68ffULL,
0x0000001010107812ULL, 0x000fe200078efe0bULL, 0x000000016c517824ULL, 0x000fe200078e0211ULL,
0xfffffff86e6e7812ULL, 0x000fe200078ec0ffULL, 0x000000083c117824ULL, 0x000fc400078e00ffULL,
0x000000013c0c7824ULL, 0x000fe400078e0251ULL, 0x0000000810147824ULL, 0x000fe400078e00ffULL,
0x0000000151517824ULL, 0x000fe200078e0210ULL, 0xfffffff811117812ULL, 0x000fe400078ee20cULL,
0x000000020c0c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8140b7812ULL, 0x000fe200078ee251ULL,
0x0000001011407824ULL, 0x000fc800078e0265ULL, 0x000000100b347824ULL, 0x000fe400078e0265ULL,
0x000000004040783bULL, 0x000e680000004200ULL, 0x000000003434783bULL, 0x000ea20000004200ULL,
0x00000018ff157819ULL, 0x002fe20000011440ULL, 0x00000040005b7306ULL, 0x000fe20000009400ULL,
0x00000018ff3f7819ULL, 0x000fe40000011443ULL, 0x00000018ff3d7819ULL, 0x000fc40000011441ULL,
0x00000018ff3e7819ULL, 0x000fe40000011442ULL, 0x00000018ff567819ULL, 0x004fe20000011434ULL,
0x00000015004c7306ULL, 0x000fe20000209400ULL, 0x00000018ff5a7819ULL, 0x000fce0000011435ULL,
0x0000001500557306ULL, 0x000e700000205400ULL, 0x0000001500577306ULL, 0x000eb0000020d400ULL,
0x0000003f00167306ULL, 0x000fe20000209400ULL, 0x000000554c00720bULL, 0x002fce0003fbd000ULL,
0x0000003f00157306ULL, 0x000fec0000205400ULL, 0x0000000157575812ULL, 0x004fe400078efcffULL,
0x0000003f00627306ULL, 0x0003f0000020d400ULL, 0x0000003d004b7306ULL, 0x000fe20000209400ULL,
0x000000083c3f7824ULL, 0x002fca00078e00ffULL, 0xfffffff83f0c7812ULL, 0x000fe400078ee20cULL,
0x0000003d004a7306ULL, 0x000fe60000205400ULL, 0x000000100c3c7824ULL, 0x000fca00078e0265ULL,
0x0000003d00597306ULL, 0x0003f0000020d400ULL, 0x0000003e00177306ULL, 0x000fe20000209400ULL,
0x00000100403d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003e00147306ULL, 0x000ff00000205400ULL, 0x0000003e00667306ULL, 0x0003f0000020d400ULL,
0x0000003d004d7306ULL, 0x000fe20000209400ULL, 0x00000100413e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001143eULL, 0x0000003d005c7306ULL, 0x000e700000205400ULL,
0x0000003d00677306ULL, 0x0004f0000020d400ULL, 0x0000004000547306ULL, 0x000ee20000005400ULL,
0x000000003c3c783bULL, 0x004ea20000004200ULL, 0x0000005c4d00720bULL, 0x002fcc0003f7d000ULL,
0x0000004000527306ULL, 0x00026e000000d400ULL, 0x0000000167673812ULL, 0x008fe200078efcffULL,
0x0000004100587306ULL, 0x000fe20000009400ULL, 0x0001000040407824ULL, 0x002fe200078e00ffULL,
0x000000545b00720bULL, 0x000fc80003f1d000ULL, 0x00000018ff5e7819ULL, 0x000fe40000011440ULL,
0x00000041006b7306ULL, 0x000e6e0000005400ULL, 0x0000000152520812ULL, 0x000fe200078efcffULL,
0x0000004100537306ULL, 0x0006a6000000d400ULL, 0x000000526752723eULL, 0x000fca00000010ffULL,
0x0000005e00407306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x008fe200078e00ffULL,
0x0000006b5800720bULL, 0x002fe20003f5d000ULL, 0x000001003c4d7824ULL, 0x004fca00078e00ffULL,
0x0000005e00697306ULL, 0x000e620000205400ULL, 0x00000018ff717819ULL, 0x000fcc000001144dULL,
0x0000000153532812ULL, 0x000fe200078efcffULL, 0x0000005e00687306ULL, 0x0004e2000020d400ULL,
0x000000141700720bULL, 0x000fce0003f5d000ULL, 0x00000056004f7306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x004fe20000011441ULL, 0x0000010042417824ULL, 0x000fe200078e00ffULL,
0x000000694000720bULL, 0x002fe20003f9d000ULL, 0x000001003d407824ULL, 0x000fe400078e00ffULL,
0x0000000166662812ULL, 0x000fe400078efcffULL, 0x0000005e005f7306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x000fe20000011441ULL, 0x0000010043417824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011441ULL, 0x0000005e00617306ULL, 0x000e620000205400ULL,
0x0000000168684812ULL, 0x008fe400078efcffULL, 0x0000004a4b00720bULL, 0x000fca0003f9d000ULL,
0x0000005600487306ULL, 0x000ff00000205400ULL, 0x0000005600447306ULL, 0x000fe2000020d400ULL,
0x000000615f00720bULL, 0x002fe40003f1d000ULL, 0x0000000159594812ULL, 0x000fca00078efcffULL,
0x0000006000567306ULL, 0x000ff00000209400ULL, 0x00000060005d7306ULL, 0x000e700000205400ULL,
0x0000006f00547306ULL, 0x000ff00000209400ULL, 0x0000006f005b7306ULL, 0x000ea20000205400ULL,
0x0000005d5600720bULL, 0x002fce0003f7d000ULL, 0x0000005a00467306ULL, 0x000ff00000209400ULL,
0x0000005a00477306ULL, 0x000fe20000205400ULL, 0x0000005b5400720bULL, 0x004fce0003fbd000ULL,
0x0000005a00457306ULL, 0x000ff0000020d400ULL, 0x00000060005a7306ULL, 0x000e70000020d400ULL,
0x0000004200697306ULL, 0x000ff00000009400ULL, 0x00000042005f7306ULL, 0x000ea20000005400ULL,
0x000000015a5a3812ULL, 0x002fc800078efcffULL, 0x000000535a53723eULL, 0x000fc600000010ffULL,
0x0000006f00587306ULL, 0x0002f0000020d400ULL, 0x00000043004a7306ULL, 0x000fe20000009400ULL,
0x0000005f6900720bULL, 0x004fe40003f7d000ULL, 0x00000018ff6f7819ULL, 0x002fc40000011440ULL,
0x00000018ff697819ULL, 0x000fc60000011436ULL, 0x00000043004b7306ULL, 0x000e620000005400ULL,
0x0000000158585812ULL, 0x008fce00078efcffULL, 0x0000004200567306ULL, 0x0004f0000000d400ULL,
0x00000071004d7306ULL, 0x000fe20000209400ULL, 0x0000004b4a00720bULL, 0x002fe20003fbd000ULL,
0x0001000042427824ULL, 0x004fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011442ULL,
0x00000071005c7306ULL, 0x000e620000205400ULL, 0x0000000156563812ULL, 0x008fe200078efcffULL,
0x000100003d427824ULL, 0x000fca00078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000005e00647306ULL, 0x000eb0000020d400ULL, 0x0000006b00417306ULL, 0x000fe20000209400ULL,
0x0000005c4d00720bULL, 0x002fc40003f7d000ULL, 0x00000018ff5c7819ULL, 0x000fca000001143cULL,
0x0000006b004c7306ULL, 0x000e620000205400ULL, 0x0000000164640812ULL, 0x004fe400078efcffULL,
0x000000151600720bULL, 0x000fca0003f1d000ULL, 0x0000004300547306ULL, 0x0004f0000000d400ULL,
0x0000003c005b7306ULL, 0x000fe20000009400ULL, 0x0000004c4100720bULL, 0x002fe20003f9d000ULL,
0x0001000043437824ULL, 0x004fe200078e00ffULL, 0x0000000162620812ULL, 0x000fca00078efcffULL,
0x0000003c00147306ULL, 0x000e620000005400ULL, 0x0000000154545812ULL, 0x008fce00078efcffULL,
0x0000007100607306ULL, 0x000eb0000020d400ULL, 0x0000003c00617306ULL, 0x000ee2000000d400ULL,
0x000000145b00720bULL, 0x002fe40003fbd000ULL, 0x00000018ff5b7819ULL, 0x000fca000001143dULL,
0x0000003d00177306ULL, 0x000fe20000009400ULL, 0x0000000160603812ULL, 0x004fce00078efcffULL,
0x0000003d004c7306ULL, 0x000e620000005400ULL, 0x0000000161615812ULL, 0x008fce00078efcffULL,
0x0000005c00157306ULL, 0x000ff00000209400ULL, 0x0000005c00167306ULL, 0x000ea20000205400ULL,
0x0000004c1700720bULL, 0x002fce0003f7d000ULL, 0x0000006b00557306ULL, 0x0002f0000020d400ULL,
0x0000006f00407306ULL, 0x000fe20000209400ULL, 0x000000161500720bULL, 0x004fe40003fbd000ULL,
0x011000004914783bULL, 0x000ea20000000200ULL, 0x00000018ff6b7819ULL, 0x002fc80000011437ULL,
0x0000006f005d7306ULL, 0x000e620000205400ULL, 0x0000000155554812ULL, 0x008fce00078efcffULL,
0x0000003d005f7306ULL, 0x000ee2000000d400ULL, 0x0000005d4000720bULL, 0x002fe20003f9d000ULL,
0x000100003c5d7824ULL, 0x000fcc00078e00ffULL, 0x0000006f005e7306ULL, 0x0002a2000020d400ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x000000015f5f3812ULL, 0x008fca00078efcffULL,
0x0000005d003c7306ULL, 0x000fe20000209400ULL, 0x00000018ff6f7819ULL, 0x002fce000001143fULL,
0x0000005d004b7306ULL, 0x000e620000205400ULL, 0x000000091414e231ULL, 0x084fe200003400ffULL,
0x000000015e5e4812ULL, 0x000fe200078efcffULL, 0x000000091616e231ULL, 0x000fe400003400ffULL,
0x0000000a1515e231ULL, 0x080fe400003400ffULL, 0x0000000a1717e231ULL, 0x000fe200003400ffULL,
0x0000005b00407306ULL, 0x000fec0000209400ULL, 0x000000521438723cULL, 0x000be40000041838ULL,
0x0000005b00417306ULL, 0x000ea20000205400ULL, 0x0000004b3c00720bULL, 0x002fce0003f7d000ULL,
0x0000005d005d7306ULL, 0x000e70000020d400ULL, 0x00000067005a7306ULL, 0x000fe20000209400ULL,
0x000000414000720bULL, 0x004fce0003f9d000ULL, 0x00000067003d7306ULL, 0x000ea20000205400ULL,
0x000000015d5d3812ULL, 0x002fce00078efcffULL, 0x0000005c005c7306ULL, 0x000e70000020d400ULL,
0x00000042003c7306ULL, 0x000fe20000209400ULL, 0x0000003d5a00720bULL, 0x004fe40003f7d000ULL,
0x00000064593d723eULL, 0x000fca00000010ffULL, 0x0000004200537306ULL, 0x020ea20000205400ULL,
0x000000015c5c5812ULL, 0x002fce00078efcffULL, 0x0000006b004d7306ULL, 0x000ff00000209400ULL,
0x0000006b004b7306ULL, 0x000fe20000205400ULL, 0x000000533c00720bULL, 0x004fe40003fbd000ULL,
0x00000068573c723eULL, 0x000fca00000010ffULL, 0x0000006b00407306ULL, 0x0003e4000020d400ULL,
0x0000003c141c723cULL, 0x000b6c000004181cULL, 0x0000004200647306ULL, 0x0004e2000020d400ULL,
0x00000018ff6b7819ULL, 0x002fe4000001143eULL, 0x00000056583c723eULL, 0x020fc400000010ffULL,
0x00000054553d723eULL, 0x000fc600000010ffULL, 0x00000069004a7306ULL, 0x000fe20000209400ULL,
0x00000018ff427819ULL, 0x004fc60000011443ULL, 0x0000003c1420723cULL, 0x000be80000041820ULL,
0x00000069004c7306ULL, 0x000fe20000205400ULL, 0x0000000164645812ULL, 0x008fe400078efcffULL,
0x00000100343c7824ULL, 0x020fca00078e00ffULL, 0x0000006900417306ULL, 0x000fe2000020d400ULL,
0x00000018ff717819ULL, 0x000fce000001143cULL, 0x0000006b00527306ULL, 0x000ff00000209400ULL,
0x0000006b00697306ULL, 0x000e700000205400ULL, 0x0000006b005a7306ULL, 0x000eb0000020d400ULL,
0x0000004200597306ULL, 0x000fe20000209400ULL, 0x000000695200720bULL, 0x002fce0003fbd000ULL,
0x00000042006b7306ULL, 0x000e6c0000205400ULL, 0x000000015a5a5812ULL, 0x004fe400078efcffULL,
0x0000006700677306ULL, 0x000ea2000020d400ULL, 0x000000484f00720bULL, 0x000fe40003fbd000ULL,
0x0000006b5900720bULL, 0x002fe20003f5d000ULL, 0x000001003f6b7824ULL, 0x000fc800078e00ffULL,
0x00000042003d7306ULL, 0x000e62000020d400ULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x0000000167673812ULL, 0x004fca00078efcffULL, 0x0000006f00537306ULL, 0x000fe20000209400ULL,
0x0000000144445812ULL, 0x000fe400078efcffULL, 0x000000474600720bULL, 0x000fca0003fbd000ULL,
0x0000006f00687306ULL, 0x000ea20000205400ULL, 0x000000013d3d2812ULL, 0x002fc800078efcffULL,
0x0000003d623d723eULL, 0x000fc600000010ffULL, 0x0000006f00577306ULL, 0x0002e2000020d400ULL,
0x0000000145455812ULL, 0x000fce00078efcffULL, 0x0000006b00597306ULL, 0x000fe20000209400ULL,
0x000001003e6f7824ULL, 0x002fe200078e00ffULL, 0x000000685300720bULL, 0x004fc80003f7d000ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000006b003c7306ULL, 0x000e6e0000205400ULL,
0x0000000157573812ULL, 0x008fe200078efcffULL, 0x0000006f00547306ULL, 0x000ff00000209400ULL,
0x0000006f00697306ULL, 0x000ea20000205400ULL, 0x0000003c5900720bULL, 0x002fc40003f1d000ULL,
0x00000067663c723eULL, 0x000fca00000010ffULL, 0x0000003400527306ULL, 0x000fe40000009400ULL,
0x0000003c1424723cULL, 0x000b6c0000041824ULL, 0x0000003400537306ULL, 0x000e620000005400ULL,
0x000000695400720bULL, 0x004fe20003f5d000ULL, 0x000100003e3d7824ULL, 0x020fcc00078e00ffULL,
0x0000003400437306ULL, 0x0004f0000000d400ULL, 0x0000003f00697306ULL, 0x000fe20000009400ULL,
0x0001000034347824ULL, 0x004fe200078e00ffULL, 0x000000535200720bULL, 0x002fc80003f7d000ULL,
0x00000018ff757819ULL, 0x000fe40000011434ULL, 0x0000006f00347306ULL, 0x0002ae000020d400ULL,
0x0000000143433812ULL, 0x008fe200078efcffULL, 0x0000003f003c7306ULL, 0x000ee20000005400ULL,
0x00000018ff6f7819ULL, 0x002fc4000001143dULL, 0x0000005f5e3d723eULL, 0x000fca00000010ffULL,
0x0000005b005b7306ULL, 0x000e62000020d400ULL, 0x0000000134342812ULL, 0x004fce00078efcffULL,
0x0000003e00687306ULL, 0x000fe20000009400ULL, 0x0000003c6900720bULL, 0x008fe20003f5d000ULL,
0x000100003f3c7824ULL, 0x000fcc00078e00ffULL, 0x0000003e00667306ULL, 0x000ea20000005400ULL,
0x000000015b5b4812ULL, 0x002fce00078efcffULL, 0x0000006b00627306ULL, 0x000e62000020d400ULL,
0x000000666800720bULL, 0x004fce0003f9d000ULL, 0x0000003e00677306ULL, 0x000ea2000000d400ULL,
0x0000000162620812ULL, 0x002fce00078efcffULL, 0x0000003f00667306ULL, 0x0002f0000000d400ULL,
0x0000006f00687306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x002fe4000001143cULL,
0x00000061603c723eULL, 0x000fc400000010ffULL, 0x0000000167674812ULL, 0x004fc600078efcffULL,
0x0000006f00697306ULL, 0x000e620000205400ULL, 0x0000000166662812ULL, 0x008fe200078efcffULL,
0x0000003c1428723cULL, 0x000b620000041828ULL, 0x000000673434723eULL, 0x000fca00000010ffULL,
0x0000003f006b7306ULL, 0x000fe20000209400ULL, 0x0000005d5c3c723eULL, 0x020fe400000010ffULL,
0x000000645b3d723eULL, 0x000fca00000010ffULL, 0x0000003f005e7306ULL, 0x000ea20000205400ULL,
0x000000696800720bULL, 0x002fe20003f9d000ULL, 0x0000003c142c723cULL, 0x000b6c000004182cULL,
0x0000006f003e7306ULL, 0x000e62000020d400ULL, 0x00000100353c7824ULL, 0x060fe400078e00ffULL,
0x00010000353d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003f003f7306ULL, 0x000ee2000020d400ULL, 0x0000005e6b00720bULL, 0x004fe40003f1d000ULL,
0x00000018ff3d7819ULL, 0x000fca000001143dULL, 0x00000035005c7306ULL, 0x000fe20000009400ULL,
0x000000013e3e4812ULL, 0x002fce00078efcffULL, 0x00000035005b7306ULL, 0x000e620000005400ULL,
0x000000013f3f0812ULL, 0x008fce00078efcffULL, 0x00000035005d7306ULL, 0x0004f0000000d400ULL,
0x0000003c005f7306ULL, 0x000fe20000209400ULL, 0x000000666235723eULL, 0x004fe400000010ffULL,
0x0000005b5c00720bULL, 0x002fca0003f9d000ULL, 0x000000341430723cULL, 0x000b620000041830ULL,
0x0000003c00647306ULL, 0x000e6c0000205400ULL, 0x0000003e5a34723eULL, 0x020fe400000010ffULL,
0x0000003f5735723eULL, 0x000fe200000010ffULL, 0x0000003c005e7306ULL, 0x0004a2000020d400ULL,
0x000000015d5d4812ULL, 0x008fca00078efcffULL, 0x000000341414723cULL, 0x000b620000041818ULL,
0x000000645f00720bULL, 0x002fe20003f7d000ULL, 0x0000003600667306ULL, 0x000fe20000009400ULL,
0x00000100363c7824ULL, 0x004fc800078e00ffULL, 0x0000010037197824ULL, 0x020fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe2000001143cULL, 0x00000008101b7824ULL, 0x000fe200078e00ffULL,
0x0000000251107810ULL, 0x000fe20007ffe0ffULL, 0x0000003600677306ULL, 0x000e620000005400ULL,
0x00000018ff357819ULL, 0x000fe40000011419ULL, 0xfffffff81b107812ULL, 0x000fe200078ee210ULL,
0x00010000361b7824ULL, 0x000fe200078e00ffULL, 0x000000015e5e3812ULL, 0x000fe400078efcffULL,
0x0000004c4a00720bULL, 0x000fe20003f7d000ULL, 0x0000003500197306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x000fe2000001141bULL, 0x00000010103c7824ULL, 0x000fcc00078e0265ULL,
0x00000035001a7306ULL, 0x000ea20000205400ULL, 0x000000676600720bULL, 0x002fc60003f5d000ULL,
0x0000000141413812ULL, 0x000fc800078efcffULL, 0x0000003500517306ULL, 0x0003f0000020d400ULL,
0x0000003600537306ULL, 0x0006e2000000d400ULL, 0x0001000037357824ULL, 0x002fe200078e00ffULL,
0x0000001a1900720bULL, 0x004fcc0003fbd000ULL, 0x0000007100557306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x008fe20000011435ULL, 0x0000000473357824ULL, 0x000fca00078e026cULL,
0x0000000235357810ULL, 0x000fe20007ffe050ULL, 0x0000007100567306ULL, 0x000e620000205400ULL,
0x0000000850507824ULL, 0x000fe200078e00ffULL, 0x0000000153532812ULL, 0x000fe400078efcffULL,
0x0000000151515812ULL, 0x000fe400078efcffULL, 0xfffffff850357812ULL, 0x000fe400078ee235ULL,
0x0000006800577306ULL, 0x000fe60000209400ULL, 0x0000001035487824ULL, 0x000fca00078e024eULL,
0x0000006800187306ULL, 0x000fe20000205400ULL, 0x000000565500720bULL, 0x002fce0003f1d000ULL,
0x00000068005a7306ULL, 0x000ff0000020d400ULL, 0x00000037005c7306ULL, 0x000ff00000009400ULL,
0x00000037006f7306ULL, 0x000ff00000005400ULL, 0x0000003700527306ULL, 0x000ff0000000d400ULL,
0x00000034001b7306ULL, 0x000ff00000209400ULL, 0x0000003400697306ULL, 0x000ff00000205400ULL,
0x0000003400557306ULL, 0x000ff0000020d400ULL, 0x0000003600677306ULL, 0x000ff00000209400ULL,
0x0000003600687306ULL, 0x000ff00000205400ULL, 0x0000003600567306ULL, 0x0003f0000020d400ULL,
0x0000003d00617306ULL, 0x000fe20000209400ULL, 0x011000004834783bULL, 0x002e6e0000000200ULL,
0x0000003d00607306ULL, 0x000eb00000205400ULL, 0x0000003d00627306ULL, 0x000670000020d400ULL,
0x0000007100547306ULL, 0x000e62000020d400ULL, 0x000000003c3c783bULL, 0x008ee20000004200ULL,
0x000000606100720bULL, 0x004fcc0003f9d000ULL, 0x0000007500587306ULL, 0x000fee0000209400ULL,
0x0000000162624812ULL, 0x002fe200078efcffULL, 0x0000007500597306ULL, 0x000e620000205400ULL,
0x0000000154540812ULL, 0x000fe200078efcffULL, 0x000000093434e231ULL, 0x080fe200003400ffULL,
0x0000004b4d00720bULL, 0x000fe20003f9d000ULL, 0x000000093636e231ULL, 0x000fe200003400ffULL,
0x000000624545723eULL, 0x000fe200000010ffULL, 0x0000000a3535e231ULL, 0x000fc400003400ffULL,
0x0000007500427306ULL, 0x000ea2000020d400ULL, 0x0000000a3737e231ULL, 0x000fe200003400ffULL,
0x000000185700720bULL, 0x000fe40003fdd000ULL, 0x000000595800720bULL, 0x002fc80003f1d000ULL,
0x0000000140404812ULL, 0x000fce00078efcffULL, 0x000000015a5a6812ULL, 0x000fe400078efcffULL,
0x00000018ff647819ULL, 0x008fe2000001143eULL, 0x0000003c004b7306ULL, 0x000fe20000009400ULL,
0x000000691b00720bULL, 0x000fe20003fdd000ULL, 0x000001003c4a7824ULL, 0x000fe200078e00ffULL,
0x0000000142420812ULL, 0x004fe200078efcffULL, 0x000001003d187824ULL, 0x000fe200078e00ffULL,
0x0000006f5c00720bULL, 0x000fe20003f1d000ULL, 0x000100003c197824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001144aULL, 0x0000006400597306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x000fc4000001143cULL, 0x00000018ff507819ULL, 0x000fe4000001143dULL,
0x00000018ff717819ULL, 0x000fe4000001143fULL, 0x00000018ff577819ULL, 0x000fe20000011418ULL,
0x00000064005c7306ULL, 0x000fe20000205400ULL, 0x000000424444723eULL, 0x000fe200000010ffULL,
0x000100003f427824ULL, 0x000fe200078e00ffULL, 0x0000000152520812ULL, 0x000fe400078efcffULL,
0x000000686700720bULL, 0x000fc40003f1d000ULL, 0x0000000155556812ULL, 0x000fe200078efcffULL,
0x0000006400477306ULL, 0x000fe2000020d400ULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x00000044341c723cULL, 0x000f62000004181cULL, 0x000000535a5a723eULL, 0x000fca00000010ffULL,
0x0000003c00647306ULL, 0x000e640000005400ULL, 0x0000000156560812ULL, 0x000fcc00078efcffULL,
0x0000003d001a7306ULL, 0x000ff00000009400ULL, 0x0000003d001b7306ULL, 0x000ea20000005400ULL,
0x000000644b00720bULL, 0x002fe40003f5d000ULL, 0x00000018ff4b7819ULL, 0x000fca0000011419ULL,
0x0000005f006f7306ULL, 0x000ff00000209400ULL, 0x0000005f00607306ULL, 0x000e620000205400ULL,
0x0000001b1a00720bULL, 0x004fe20003fbd000ULL, 0x000100003d1a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe2000001141aULL, 0x00000058006b7306ULL, 0x000ff00000209400ULL,
0x00000058006c7306ULL, 0x000ea20000205400ULL, 0x000000606f00720bULL, 0x002fce0003f7d000ULL,
0x00000058004f7306ULL, 0x000e70000020d400ULL, 0x00000050005b7306ULL, 0x000fe20000209400ULL,
0x0000006c6b00720bULL, 0x004fce0003fdd000ULL, 0x0000005000667306ULL, 0x000fec0000205400ULL,
0x000000014f4f6812ULL, 0x002fe400078efcffULL, 0x00000050004e7306ULL, 0x000fe2000020d400ULL,
0x0000005c5900720bULL, 0x000fce0003fdd000ULL, 0x0000007100507306ULL, 0x000fec0000209400ULL,
0x0000000147476812ULL, 0x000fe400078efcffULL, 0x0000007100587306ULL, 0x000ff00000205400ULL,
0x0000007100467306ULL, 0x000ff0000020d400ULL, 0x0000005700187306ULL, 0x000ff00000209400ULL,
0x0000005700717306ULL, 0x000e700000205400ULL, 0x0000004b00197306ULL, 0x000ff00000209400ULL,
0x0000004b00697306ULL, 0x000ea20000205400ULL, 0x000000711800720bULL, 0x002fc40003f1d000ULL,
0x000000435418723eULL, 0x000fe200000010ffULL, 0x000100003e547824ULL, 0x000fc800078e00ffULL,
0x0000005f004c7306ULL, 0x000e62000020d400ULL, 0x00000018ff547819ULL, 0x000fce0000011454ULL,
0x00000061001a7306ULL, 0x000fe20000209400ULL, 0x000000691900720bULL, 0x004fe40003f9d000ULL,
0x0000005d5e19723eULL, 0x000fca00000010ffULL, 0x00000061001b7306ULL, 0x000ea20000205400ULL,
0x000000014c4c3812ULL, 0x002fce00078efcffULL, 0x0000003c005f7306ULL, 0x0002e2000000d400ULL,
0x0000001b1a00720bULL, 0x004fe20003f7d000ULL, 0x000001003e3c7824ULL, 0x002fcc00078e00ffULL,
0x00000057004a7306ULL, 0x000e62000020d400ULL, 0x000000183418723cULL, 0x000b620000041838ULL,
0x00000018ff757819ULL, 0x000fe2000001143cULL, 0x000001003f3c7824ULL, 0x000fe200078e00ffULL,
0x000000015f5f2812ULL, 0x008fc800078efcffULL, 0x0000003f00437306ULL, 0x000fe20000009400ULL,
0x000000564039723eULL, 0x020fe400000010ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001143cULL,
0x0000005f4c4c723eULL, 0x000fc600000010ffULL, 0x0000003f00387306ULL, 0x000ea20000005400ULL,
0x000000014a4a0812ULL, 0x002fce00078efcffULL, 0x0000003d004d7306ULL, 0x000e70000000d400ULL,
0x0000004b00577306ULL, 0x000ee2000020d400ULL, 0x000000384300720bULL, 0x004fe40003f1d000ULL,
0x000000554138723eULL, 0x000fca00000010ffULL, 0x0000007500647306ULL, 0x000fe20000209400ULL,
0x000000014d4d5812ULL, 0x002fe200078efcffULL, 0x000000383424723cULL, 0x000b620000041824ULL,
0x000000665b00720bULL, 0x000fe40003fbd000ULL, 0x00000052515b723eULL, 0x000fe400000010ffULL,
0x0000004d4a4d723eULL, 0x000fe200000010ffULL, 0x0000007500677306ULL, 0x000e620000205400ULL,
0x0000000157574812ULL, 0x008fc600078efcffULL, 0x0000005a3420723cULL, 0x000f640000041820ULL,
0x000000574f38723eULL, 0x020fe400000010ffULL, 0x0000003e00687306ULL, 0x000fe20000009400ULL,
0x000000014e4e5812ULL, 0x000fc600078efcffULL, 0x0000004c3428723cULL, 0x000f680000041828ULL,
0x0000003e005d7306ULL, 0x000ea20000005400ULL, 0x000000676400720bULL, 0x002fce0003f9d000ULL,
0x00000061003d7306ULL, 0x000e70000020d400ULL, 0x00000075004b7306ULL, 0x000ee2000020d400ULL,
0x0000005d6800720bULL, 0x004fce0003f5d000ULL, 0x0000006b00607306ULL, 0x000fe20000209400ULL,
0x000000013d3d3812ULL, 0x002fe400078efcffULL, 0x000000585000720bULL, 0x000fe40003f7d000ULL,
0x0000003d4e39723eULL, 0x000fc600000010ffULL, 0x0000006b00617306ULL, 0x000e620000205400ULL,
0x000000014b4b4812ULL, 0x008fc600078efcffULL, 0x00000038342c723cULL, 0x000b68000004182cULL,
0x0000003e003b7306ULL, 0x000ea2000000d400ULL, 0x0000000146463812ULL, 0x000fce00078efcffULL,
0x0000003f003a7306ULL, 0x000ee2000000d400ULL, 0x000000616000720bULL, 0x002fce0003fbd000ULL,
0x00000054003e7306ULL, 0x000fe20000209400ULL, 0x000000013b3b2812ULL, 0x004fce00078efcffULL,
0x00000054003f7306ULL, 0x000e620000205400ULL, 0x000000013a3a0812ULL, 0x008fce00078efcffULL,
0x0000004200437306ULL, 0x000ff00000209400ULL, 0x0000004200447306ULL, 0x000ea20000205400ULL,
0x0000003f3e00720bULL, 0x002fe40003f9d000ULL, 0x0000003b4b3e723eULL, 0x000fca00000010ffULL,
0x0000006b003c7306ULL, 0x000e70000020d400ULL, 0x0000005400547306ULL, 0x000ee2000020d400ULL,
0x000000444300720bULL, 0x004fce0003f5d000ULL, 0x0000004200417306ULL, 0x000ea2000020d400ULL,
0x000000013c3c5812ULL, 0x002fc800078efcffULL, 0x0000003a3c3f723eULL, 0x000fe400000010ffULL,
0x0000000154544812ULL, 0x008fc800078efcffULL, 0x000000544738723eULL, 0x020fe200000010ffULL,
0x0000003e3430723cULL, 0x000f620000041830ULL, 0x0000000141412812ULL, 0x004fc800078efcffULL,
0x000000414639723eULL, 0x000fce00000010ffULL, 0x000000383434723cULL, 0x000b6e0000041814ULL,
0x000176c873147811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000014147f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017688006eff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff3a7224ULL, 0x000fc600078e00ffULL,
0x0000000000167805ULL, 0x000fc80000015200ULL, 0x0000040006397984ULL, 0x000ee40000000800ULL,
0x8000000039ff7812ULL, 0x00afc40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038163b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e17ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040006397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000167824ULL, 0x000fe400078e00ffULL, 0x000059000f0f7a24ULL, 0x010fc600078e02ffULL,
0xffffffe016147812ULL, 0x000fe200078ec0ffULL, 0x000000400f0f7824ULL, 0x000fc800078e00ffULL,
0x0000010005147824ULL, 0x000fca00078e0214ULL, 0x0000008014157810ULL, 0x000fc80007ffe0ffULL,
0x0000002015147812ULL, 0x000fca00078ec0ffULL, 0x00000001773a7824ULL, 0x000fe200078e0214ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000001570147217ULL, 0x000fe40007800000ULL,
0x0000001016177812ULL, 0x000fe400078ec0ffULL, 0x00000003ff167819ULL, 0x000fe20000011603ULL,
0x0000000114147824ULL, 0x000fe200078e0a15ULL, 0x000062000f3d7a11ULL, 0x000fe400078a38ffULL,
0x0000000416397810ULL, 0x040fe20007ffe0ffULL, 0x0000000116157824ULL, 0x000fe200078e0217ULL,
0x0000001417147217ULL, 0x000fc40007800000ULL, 0x000063000f3f7a11ULL, 0x000fe200028f3cffULL,
0x0000000115387824ULL, 0x040fe400078e0203ULL, 0x00000008153b7824ULL, 0x040fe400078e00ffULL,
0x0000000114147824ULL, 0x000fe400078e0a17ULL, 0x0000000115157824ULL, 0x000fe200078e023aULL,
0xfffffff83b3c7812ULL, 0x000fe400078ee238ULL, 0x0000000816387810ULL, 0x000fc40007ffe0ffULL,
0x0000000c163b7810ULL, 0x040fe40007ffe0ffULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000139167824ULL, 0x140fe200078e0217ULL, 0x000000143800720cULL, 0x0c0fe20003f46070ULL,
0x0000000138387824ULL, 0x100fe200078e0217ULL, 0x000000143900720cULL, 0x080fe20003f66070ULL,
0x000000013b417824ULL, 0x040fe200078e0217ULL, 0x000000143b00720cULL, 0x000fe20003f06070ULL,
0x0000000116177824ULL, 0x040fe400078e0203ULL, 0x00000008163e7824ULL, 0x000fc400078e00ffULL,
0x0000008015147825ULL, 0x000fc600078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee217ULL,
0x0000000116167824ULL, 0x000fe200078e023aULL, 0x0000006314147212ULL, 0x000fe200078efcffULL,
0x0000000138397824ULL, 0x040fe400078e0203ULL, 0x0000000838407824ULL, 0x000fe200078e00ffULL,
0x000000143d147210ULL, 0x000fe20007fbe0ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee239ULL, 0x0000000138387824ULL, 0x100fe200078e023aULL,
0x0000006316167212ULL, 0x000fe200078efcffULL, 0x00000001413a7824ULL, 0x000fe400078e023aULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000006338387212ULL, 0x000fc600078efcffULL, 0x0000000115157824ULL, 0x000fe200028e063fULL,
0x0000003d16167210ULL, 0x000fe20007fbe0ffULL, 0x00000001410f7824ULL, 0x040fe200078e0203ULL,
0x000000633a3a7212ULL, 0x000fe200078efcffULL, 0x0000000841427824ULL, 0x000fe400078e00ffULL,
0x0000000117177824ULL, 0x000fe200028e063fULL, 0x0000003d38387210ULL, 0x080fe40007fbe0ffULL,
0x0000003d3a3a7210ULL, 0x000fe20007fde0ffULL, 0x000000103e3d7824ULL, 0x000fe200078e0265ULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x000000103c0f7824ULL, 0x000fc400078e0265ULL,
0x0000000139397824ULL, 0x100fe400028e063fULL, 0x000000013b3b7824ULL, 0x000fe200030e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140f7faeULL, 0x0003e2000e101c48ULL,
0x00000010403f7824ULL, 0x100fe400078e0265ULL, 0x0000001042417824ULL, 0x000fe200078e0265ULL,
0x00000000163d7faeULL, 0x0003e8000d901c48ULL, 0x00000000383f7faeULL, 0x0003e8000d101c48ULL,
0x000000003a417faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001016167812ULL, 0x000fe400078ec0ffULL, 0x000062000f3f7a11ULL, 0x000fc400078038ffULL,
0x0000001603167211ULL, 0x000fe400078fe8ffULL, 0x000063000f417a11ULL, 0x000fe400000f3cffULL,
0x0000000416177810ULL, 0x040fe20007ffe0ffULL, 0x0000000116157824ULL, 0x040fe200078e0203ULL,
0x0000000816397810ULL, 0x040fe20007ffe0ffULL, 0x00000008163e7824ULL, 0x040fe200078e00ffULL,
0x0000000c163b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000817407824ULL, 0x040fe400078e00ffULL,
0x0000000116147824ULL, 0x000fe200078e023aULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee215ULL,
0x0000000117157824ULL, 0x000fc400078e0203ULL, 0x0000000139387824ULL, 0x140fe400078e023aULL,
0x0000000139167824ULL, 0x040fe200078e0203ULL, 0xfffffff840407812ULL, 0x000fe200078ee215ULL,
0x0000000839397824ULL, 0x000fe400078e00ffULL, 0x00000001173c7824ULL, 0x000fe400078e023aULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff839427812ULL, 0x000fc600078ee216ULL,
0x000000013b3a7824ULL, 0x000fe200078e023aULL, 0x0000006314167212ULL, 0x000fe200078efcffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0x000000163f167210ULL, 0x000fe20007f1e0ffULL,
0x000000013b177824ULL, 0x040fe200078e0203ULL, 0x000000633c147212ULL, 0x080fe200078efcffULL,
0x000000083b447824ULL, 0x000fe400078e00ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000000143f147210ULL, 0x000fe40007f5e0ffULL, 0xfffffff844447812ULL, 0x000fe200078ee217ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000006338387212ULL, 0x000fc600078efcffULL,
0x0000000115177824ULL, 0x100fe200000e0641ULL, 0x000000633a3a7212ULL, 0x000fe200078efcffULL,
0x000000013d157824ULL, 0x000fe200010e0641ULL, 0x000000383f387210ULL, 0x040fe20007f1e0ffULL,
0x000000103e0f7824ULL, 0x100fe200078e0265ULL, 0x0000003a3f3a7210ULL, 0x000fe20007f7e0ffULL,
0x00000010403d7824ULL, 0x000fe400078e0265ULL, 0x0000000139397824ULL, 0x100fe200000e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000160f7faeULL, 0x0003e2000b901c48ULL,
0x000000013b3b7824ULL, 0x000fc400018e0641ULL, 0x00000010423f7824ULL, 0x100fe200078e0265ULL,
0x00000000143d7faeULL, 0x0003e2000b901c48ULL, 0x0000001044417824ULL, 0x000fc600078e0265ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a417faeULL, 0x0003e4000b901c48ULL,
0x0000000800167824ULL, 0x002fe200078e00ffULL, 0x0000000202147810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0f7424ULL, 0x000fc600078e00ffULL, 0xfffffff016167812ULL, 0x000fe400078ec0ffULL,
0x000000761400720cULL, 0x000fe40003f06070ULL, 0x00000000160473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000179148824ULL, 0x000fc400078e0214ULL,
0x00000004ff158424ULL, 0x000fc800078e00ffULL, 0x0000640014148625ULL, 0x000fca00078e0015ULL,
0x00000008140f8981ULL, 0x000722000c1e1900ULL, 0x000176a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x008fec0000008000ULL, 0x0176a80016167f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176280007147f8cULL, 0x0006a4000c80043fULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x01762c00073b7984ULL, 0x000ee40000000800ULL,
0x800000003bff7812ULL, 0x00cfe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01762c00073b7984ULL, 0x000ea40000000800ULL, 0x800000003bff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000147824ULL, 0x000fca00078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000008063157810ULL, 0x000fca0007ffe014ULL,
0x0000000174157824ULL, 0x000fca00078e0215ULL, 0x0170000015397984ULL, 0x000ea80000000800ULL,
0x0172000015387984ULL, 0x0006620000000800ULL, 0x0000000e3900720bULL, 0x004fe20003f1d000ULL,
0x00012b927f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c3b7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3a7424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000017a157810ULL, 0x000fe40007ffe0ffULL, 0x0000000e3900720bULL, 0x000fe40003f54000ULL,
0x000000001500720cULL, 0x000fe20003f05270ULL, 0x00012b527f007947ULL, 0x000fd4000b800000ULL,
0x00000000003a7806ULL, 0x000fc400010e0100ULL, 0x0000008000158824ULL, 0x000fe200078e0263ULL,
0x0000000e39148209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001743d8824ULL, 0x000fe200078e0215ULL, 0x000099103a157816ULL, 0x000fc800000000ffULL,
0x017400143d008388ULL, 0x0005e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000e39157209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff3aff7812ULL, 0x000fc6000780c0ffULL,
0x0000000e15147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400407308ULL, 0x000ea40000000800ULL, 0x000000400d0d7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe20000011603ULL,
0x00012a827f007947ULL, 0x000fea000b800000ULL, 0x00001f14403c7589ULL, 0x0004e400000e0000ULL,
0x0000003c18187220ULL, 0x08cfe40000410000ULL, 0x0000003c19197220ULL, 0x080fe40000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x000fc40000410000ULL,
0x0000003c20207220ULL, 0x080fe40000410000ULL, 0x0000003c21217220ULL, 0x080fe40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x080fe40000410000ULL,
0x0000003c28287220ULL, 0x080fe40000410000ULL, 0x0000003c29297220ULL, 0x000fc40000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000003c30307220ULL, 0x080fe40000410000ULL, 0x0000003c31317220ULL, 0x080fe40000410000ULL,
0x0000003c34347220ULL, 0x080fe40000410000ULL, 0x0000003c35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff003aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803147811ULL, 0x000fe200078ff0ffULL,
0x000129827f007947ULL, 0x000fea000b800000ULL, 0x00001f14403c7589ULL, 0x0004e400000e0000ULL,
0x0000003c1a1a7220ULL, 0x08cfe40000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c22227220ULL, 0x080fe40000410000ULL, 0x0000003c23237220ULL, 0x000fc40000410000ULL,
0x0000003c26267220ULL, 0x080fe40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003c2f2f7220ULL, 0x000fc40000410000ULL,
0x0000003c32327220ULL, 0x080fe40000410000ULL, 0x0000003c33337220ULL, 0x080fe40000410000ULL,
0x0000003c36367220ULL, 0x080fe40000410000ULL, 0x0000003c37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe2000780603aULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000000e390e7209ULL, 0x000fd60007810000ULL,
0x8000000e39390221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL, 0x0000003900080308ULL, 0x000ea40000000800ULL,
0x0000000838380220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d380d7221ULL, 0x002fc40000010000ULL, 0x0000000000147805ULL, 0x000fca0000015200ULL,
0x0000000800387824ULL, 0x000fca00078e00ffULL, 0xfffffff0383c7812ULL, 0x000fca00078ec0ffULL,
0x0176b4003c397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038143b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e15ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176b4003c397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103a127816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1200720cULL, 0x000fda0003f85270ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x00000008ff09723eULL, 0x000fe400000010ffULL, 0x00000002ff137819ULL, 0x000fe40000011603ULL,
0x0000541009127816ULL, 0x000fe20000000009ULL, 0x000125527f007947ULL, 0x000fea000b800000ULL,
0x00001f1312097589ULL, 0x0002a400000e0000ULL, 0x0000000813147810ULL, 0x000fe20007ffe0ffULL,
0x000125a27f007947ULL, 0x000fea000b800000ULL, 0x00001f14120a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001013147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0012ULL, 0x00006630003d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0001300000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001813147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0012ULL,
0x000066a0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x00012f9000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100065697810ULL, 0x000fca0007ffe0ffULL, 0x0000001011647824ULL, 0x100fe400078e0269ULL,
0x000000100c387824ULL, 0x100fe400078e0269ULL, 0x000000100b687824ULL, 0x000fe200078e0269ULL,
0x000000006440783bULL, 0x000ee80000004200ULL, 0x000000003838783bULL, 0x000ea80000004200ULL,
0x00000000683c783bULL, 0x004ea20000004200ULL, 0x00000018ff127819ULL, 0x00afe20000011440ULL,
0x00000040006c7306ULL, 0x000fe20000005400ULL, 0x00000018ff157819ULL, 0x000fe20000011441ULL,
0x0001000040667824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fc40000011439ULL,
0x00000018ff467819ULL, 0x000fe4000001143bULL, 0x00000018ff447819ULL, 0x000fe20000011442ULL,
0x0000001200627306ULL, 0x000fe20000209400ULL, 0x00000018ff6b7819ULL, 0x004fe4000001143cULL,
0x00000018ff6e7819ULL, 0x000fca0000011466ULL, 0x0000001200137306ULL, 0x000e700000205400ULL,
0x0000001500617306ULL, 0x000ff00000209400ULL, 0x0000001500147306ULL, 0x000fe20000205400ULL,
0x000000136200720bULL, 0x002fe20003fbd000ULL, 0x0000010041627824ULL, 0x000fcc00078e00ffULL,
0x0000001500577306ULL, 0x0003f0000020d400ULL, 0x0000004500517306ULL, 0x000fe20000209400ULL,
0x00000018ff157819ULL, 0x002fce0000011438ULL, 0x0000004500547306ULL, 0x000ff00000205400ULL,
0x00000045005d7306ULL, 0x000ff0000020d400ULL, 0x00000015004d7306ULL, 0x000ff00000209400ULL,
0x0000001500527306ULL, 0x000ff00000205400ULL, 0x00000015005e7306ULL, 0x0003f0000020d400ULL,
0x0000004000457306ULL, 0x000ea20000009400ULL, 0x0000010040157824ULL, 0x002fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011415ULL, 0x00000046005c7306ULL, 0x000ff00000209400ULL,
0x00000046005b7306ULL, 0x000fe20000205400ULL, 0x0000006c4500720bULL, 0x004fc40003fdd000ULL,
0x00000018ff6c7819ULL, 0x000fe20000011462ULL, 0x0001000041627824ULL, 0x000fc800078e00ffULL,
0x00000046004e7306ULL, 0x000fe2000020d400ULL, 0x00000018ff717819ULL, 0x000fce0000011462ULL,
0x0000006700507306ULL, 0x000ff00000209400ULL, 0x0000006700557306ULL, 0x000e700000205400ULL,
0x0000004100467306ULL, 0x000ff00000009400ULL, 0x00000041006f7306ULL, 0x000ea20000005400ULL,
0x000000555000720bULL, 0x002fce0003f7d000ULL, 0x0000004400537306ULL, 0x000ff00000209400ULL,
0x00000044005a7306ULL, 0x000fe20000205400ULL, 0x0000006f4600720bULL, 0x004fce0003f5d000ULL,
0x0000004400607306ULL, 0x0003f0000020d400ULL, 0x0000001200567306ULL, 0x0004e2000020d400ULL,
0x00000018ff447819ULL, 0x002fce000001143aULL, 0x0000004400477306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x004fce0000011443ULL, 0x00000044004a7306ULL, 0x000fe20000205400ULL,
0x0000000156565812ULL, 0x008fe400078efcffULL, 0x0000005a5300720bULL, 0x000fca0003fbd000ULL,
0x00000044004f7306ULL, 0x000ff0000020d400ULL, 0x0000006700447306ULL, 0x000e62000020d400ULL,
0x0000000160605812ULL, 0x000fce00078efcffULL, 0x0000004000157306ULL, 0x000eb0000000d400ULL,
0x0000001200597306ULL, 0x000fe20000209400ULL, 0x0000000144443812ULL, 0x002fce00078efcffULL,
0x0000001200587306ULL, 0x000fe20000205400ULL, 0x0000000115156812ULL, 0x004fc800078efcffULL,
0x000000154444723eULL, 0x000fc600000010ffULL, 0x00000012005f7306ULL, 0x000ff0000020d400ULL,
0x0000006c00677306ULL, 0x000ff00000209400ULL, 0x0000006c00407306ULL, 0x000e700000205400ULL,
0x0000006b004c7306ULL, 0x000ff00000209400ULL, 0x0000006b004b7306ULL, 0x000fe20000205400ULL,
0x000000406700720bULL, 0x002fce0003f7d000ULL, 0x0000006b00127306ULL, 0x000ff0000020d400ULL,
0x0000006e00667306ULL, 0x000ff00000209400ULL, 0x0000006e006b7306ULL, 0x000e700000205400ULL,
0x0000007100627306ULL, 0x000ff00000209400ULL, 0x00000071006f7306ULL, 0x000ea20000205400ULL,
0x0000006b6600720bULL, 0x002fce0003f1d000ULL, 0x0000006e00137306ULL, 0x0002f0000020d400ULL,
0x0000004100457306ULL, 0x0006e2000000d400ULL, 0x0000006f6200720bULL, 0x004fe20003fdd000ULL,
0x0000010043627824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001143fULL,
0x00010000386e7824ULL, 0x002fc800078e00ffULL, 0x0000007100507306ULL, 0x000e62000020d400ULL,
0x0000010042417824ULL, 0x008fe200078e00ffULL, 0x0000000113130812ULL, 0x000fe400078efcffULL,
0x000000146100720bULL, 0x000fe40003f1d000ULL, 0x00000018ff6b7819ULL, 0x000fe40000011441ULL,
0x0000004200407306ULL, 0x000fe20000009400ULL, 0x0000000145452812ULL, 0x000fe400078efcffULL,
0x000000135656723eULL, 0x000fc400000010ffULL, 0x00000018ff6e7819ULL, 0x000fc6000001146eULL,
0x0000004200677306ULL, 0x000ea20000005400ULL, 0x0000000150506812ULL, 0x002fe400078efcffULL,
0x0000000157570812ULL, 0x000fc800078efcffULL, 0x000000505757723eULL, 0x000fe200000010ffULL,
0x0000006c00467306ULL, 0x0002f0000020d400ULL, 0x0000006b00667306ULL, 0x000fe20000209400ULL,
0x00000018ff6c7819ULL, 0x002fc40000011462ULL, 0x000000674000720bULL, 0x004fe20003fdd000ULL,
0x0001000042407824ULL, 0x000fe400078e00ffULL, 0x0000010038677824ULL, 0x000fe400078e00ffULL,
0x0000006b00417306ULL, 0x000e620000205400ULL, 0x00000018ff537819ULL, 0x000fe40000011440ULL,
0x0000000146463812ULL, 0x008fe400078efcffULL, 0x000000585900720bULL, 0x000fc40003f7d000ULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000006c00627306ULL, 0x000fe20000209400ULL,
0x000000454645723eULL, 0x000fce00000010ffULL, 0x0000006c00617306ULL, 0x000ea20000205400ULL,
0x000000416600720bULL, 0x002fe40003f5d000ULL, 0x000000015f5f3812ULL, 0x000fca00078efcffULL,
0x0000006b00557306ULL, 0x0002f0000020d400ULL, 0x0000004200587306ULL, 0x0006e2000000d400ULL,
0x000000616200720bULL, 0x004fe40003f1d000ULL, 0x00000018ff6b7819ULL, 0x002fca000001143eULL,
0x0000004300597306ULL, 0x000fe20000009400ULL, 0x0001000043427824ULL, 0x008fe200078e00ffULL,
0x0000000155552812ULL, 0x000fcc00078efcffULL, 0x00000043005a7306ULL, 0x000e620000005400ULL,
0x0000000158586812ULL, 0x000fce00078efcffULL, 0x0000005300407306ULL, 0x000ff00000209400ULL,
0x0000005300417306ULL, 0x000ea20000205400ULL, 0x0000005a5900720bULL, 0x002fe40003f5d000ULL,
0x00000018ff5a7819ULL, 0x000fca0000011442ULL, 0x0000006c00147306ULL, 0x000e70000020d400ULL,
0x0000004300597306ULL, 0x0006e2000000d400ULL, 0x000000414000720bULL, 0x004fe40003fdd000ULL,
0x0000000114140812ULL, 0x002fe200078efcffULL, 0x011800004940783bULL, 0x008e620000000200ULL,
0x000000524d00720bULL, 0x000fc60003f1d000ULL, 0x0000005a00627306ULL, 0x000fe20000209400ULL,
0x0000000159592812ULL, 0x000fe400078efcffULL, 0x000000545100720bULL, 0x000fca0003f5d000ULL,
0x0000005a004d7306ULL, 0x000ea20000205400ULL, 0x00000018ff517819ULL, 0x000fe4000001143dULL,
0x000000015e5e0812ULL, 0x000fca00078efcffULL, 0x0000005300667306ULL, 0x000ee2000020d400ULL,
0x000000015d5d2812ULL, 0x000fe400078efcffULL, 0x0000004d6200720bULL, 0x004fe20003fbd000ULL,
0x0000010039627824ULL, 0x000fc800078e00ffULL, 0x0000005a00617306ULL, 0x000ea2000020d400ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000000166666812ULL, 0x008fca00078efcffULL,
0x0000005100537306ULL, 0x000fe20000209400ULL, 0x0000004a4700720bULL, 0x000fe20003fdd000ULL,
0x000000094040c231ULL, 0x082fe400003400ffULL, 0x000000094242c231ULL, 0x000fc800003400ffULL,
0x00000051004d7306ULL, 0x000fe20000205400ULL, 0x0000000a4141c231ULL, 0x080fe200003400ffULL,
0x0000000161615812ULL, 0x004fe200078efcffULL, 0x0000000a4343c231ULL, 0x000fc600003400ffULL,
0x000000014f4f6812ULL, 0x000fe400078efcffULL, 0x0000005100157306ULL, 0x000fe4000020d400ULL,
0x00000056401c723cULL, 0x040bec000004181cULL, 0x0000006200517306ULL, 0x000fe20000209400ULL,
0x000000585556723eULL, 0x020fe200000010ffULL, 0x000000444018723cULL, 0x000b620000041818ULL,
0x000000591457723eULL, 0x000fca00000010ffULL, 0x00000062005a7306ULL, 0x000e620000205400ULL,
0x0000001010447824ULL, 0x020fe200078e0269ULL, 0x000000564020723cULL, 0x000bec0000041820ULL,
0x0000006700477306ULL, 0x000fe20000209400ULL, 0x000000666056723eULL, 0x020fe200000010ffULL,
0x0001000039607824ULL, 0x000fcc00078e00ffULL, 0x00000067004a7306ULL, 0x000ea20000205400ULL,
0x0000005a5100720bULL, 0x002fce0003f7d000ULL, 0x0000006700677306ULL, 0x000e70000020d400ULL,
0x00000038005a7306ULL, 0x000fe20000009400ULL, 0x0000004a4700720bULL, 0x004fe40003fbd000ULL,
0x000000004444783bULL, 0x000eaa0000004200ULL, 0x00000038006c7306ULL, 0x000eec0000005400ULL,
0x0000000167675812ULL, 0x002fc400078efcffULL, 0x0000006200627306ULL, 0x000e70000020d400ULL,
0x0000006e00147306ULL, 0x000fe20000209400ULL, 0x0000006c5a00720bULL, 0x008fce0003fbd000ULL,
0x0000006e00577306ULL, 0x000ee20000205400ULL, 0x0000000162623812ULL, 0x002fce00078efcffULL,
0x0000006b00527306ULL, 0x000ff00000209400ULL, 0x0000006b00547306ULL, 0x000fe20000205400ULL,
0x000000571400720bULL, 0x008fe40003f7d000ULL, 0x000000615f57723eULL, 0x000fc400000010ffULL,
0x00000018ff5f7819ULL, 0x000fc60000011460ULL, 0x0000006b004a7306ULL, 0x000fe4000020d400ULL,
0x000000564024723cULL, 0x000b6c0000041824ULL, 0x00000038006b7306ULL, 0x000470000000d400ULL,
0x00000039005a7306ULL, 0x000fe20000009400ULL, 0x00000018ff387819ULL, 0x004fce0000011444ULL,
0x0000003900597306ULL, 0x000ea20000005400ULL, 0x000000016b6b5812ULL, 0x002fc800078efcffULL,
0x0000006b6756723eULL, 0x020fe200000010ffULL, 0x000001003a677824ULL, 0x000fe400078e00ffULL,
0x00000039006c7306ULL, 0x000e66000000d400ULL, 0x00000018ff677819ULL, 0x000fca0000011467ULL,
0x0000005f00607306ULL, 0x000fe20000209400ULL, 0x000000595a00720bULL, 0x004fce0003fbd000ULL,
0x0000005f00617306ULL, 0x000eac0000205400ULL, 0x000000016c6c5812ULL, 0x002fe400078efcffULL,
0x0000006e00397306ULL, 0x000e64000020d400ULL, 0x0000006c6257723eULL, 0x000fe200000010ffULL,
0x000100003a627824ULL, 0x000fe200078e00ffULL, 0x000000616000720bULL, 0x004fc80003fbd000ULL,
0x00000067006b7306ULL, 0x000fe20000209400ULL, 0x000000564028723cULL, 0x000b620000041828ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000000139393812ULL, 0x002fc800078efcffULL,
0x0000006700607306ULL, 0x000e620000205400ULL, 0x000001003b577824ULL, 0x020fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011457ULL, 0x0000003b00567306ULL, 0x000fe20000009400ULL,
0x000000606b00720bULL, 0x002fce0003f7d000ULL, 0x0000006f00517306ULL, 0x000ff00000209400ULL,
0x0000003b006b7306ULL, 0x000e700000005400ULL, 0x0000006f00507306ULL, 0x000ff00000205400ULL,
0x0000006f00137306ULL, 0x0005e2000020d400ULL, 0x0000006b5600720bULL, 0x002fe20003f5d000ULL,
0x000100003b6b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000005f005f7306ULL, 0x000e62000020d400ULL, 0x00000018ff6f7819ULL, 0x004fce0000011445ULL,
0x0000006f00597306ULL, 0x000ff00000209400ULL, 0x0000006f005a7306ULL, 0x000fe20000205400ULL,
0x000000015f5f5812ULL, 0x002fce00078efcffULL, 0x0000006f00147306ULL, 0x000ff0000020d400ULL,
0x0000006c00577306ULL, 0x000ff00000209400ULL, 0x0000006c00607306ULL, 0x000e700000205400ULL,
0x0000003a00667306ULL, 0x000ff00000009400ULL, 0x0000003a006f7306ULL, 0x000ea20000005400ULL,
0x000000605700720bULL, 0x002fce0003f1d000ULL, 0x0000003a00567306ULL, 0x0002f0000000d400ULL,
0x0000006700617306ULL, 0x000ee2000020d400ULL, 0x0000006f6600720bULL, 0x004fe40003fbd000ULL,
0x000000395e3a723eULL, 0x002fca00000010ffULL, 0x0000006c00577306ULL, 0x000e6c000020d400ULL,
0x0000000156565812ULL, 0x008fe400078efcffULL, 0x0000006200667306ULL, 0x000fe20000209400ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x0000005b5c00720bULL, 0x000fc40003f7d000ULL,
0x000000566156723eULL, 0x000fc600000010ffULL, 0x0000006200677306ULL, 0x000ea20000205400ULL,
0x0000000157570812ULL, 0x002fce00078efcffULL, 0x0000006b006c7306ULL, 0x000fe20000209400ULL,
0x000000014e4e3812ULL, 0x000fce00078efcffULL, 0x0000006b005e7306ULL, 0x000e620000205400ULL,
0x000000676600720bULL, 0x004fce0003fbd000ULL, 0x0000003b00607306ULL, 0x0004f0000000d400ULL,
0x0000006200627306ULL, 0x000ee2000020d400ULL, 0x0000005e6c00720bULL, 0x002fe40003f1d000ULL,
0x0000005f5d3b723eULL, 0x004fc400000010ffULL, 0x00000018ff5f7819ULL, 0x000fc60000011446ULL,
0x0000006b006b7306ULL, 0x000e62000020d400ULL, 0x0000000160602812ULL, 0x008fe200078efcffULL,
0x0000003a402c723cULL, 0x040fe6000004182cULL, 0x000000605757723eULL, 0x000fe400000010ffULL,
0x00000018ff607819ULL, 0x000fe20000011447ULL, 0x0000005f005d7306ULL, 0x000fe20000209400ULL,
0x0000000162625812ULL, 0x000fe400078efcffULL, 0x0000004b4c00720bULL, 0x000fe20003fbd000ULL,
0x000000564030723cULL, 0x000b620000041830ULL, 0x000000016b6b0812ULL, 0x002fc600078efcffULL,
0x0000005f005b7306ULL, 0x000fe60000205400ULL, 0x000000624f56723eULL, 0x020fe400000010ffULL,
0x0000006b4e57723eULL, 0x000fe200000010ffULL, 0x000001003c4e7824ULL, 0x000fe400078e00ffULL,
0x0000000112125812ULL, 0x000fe200078efcffULL, 0x0000005f00397306ULL, 0x000fe4000020d400ULL,
0x00000018ff627819ULL, 0x000fe2000001144eULL, 0x000000564040723cULL, 0x000b6a0000041834ULL,
0x00000060003b7306ULL, 0x000fe40000209400ULL, 0x000100003c347824ULL, 0x020fc400078e00ffULL,
0x000001003d357824ULL, 0x000fc600078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011434ULL,
0x00000060005c7306ULL, 0x000fe20000205400ULL, 0x00000018ff6b7819ULL, 0x000fce0000011435ULL,
0x00000060003a7306ULL, 0x000ff0000020d400ULL, 0x0000003c005e7306ULL, 0x000ff00000009400ULL,
0x0000003c005f7306ULL, 0x000e700000005400ULL, 0x00000062004e7306ULL, 0x000ff00000209400ULL,
0x0000006200607306ULL, 0x000ea20000205400ULL, 0x0000005f5e00720bULL, 0x002fe20003f5d000ULL,
0x000001003e5f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001145fULL,
0x0000006700347306ULL, 0x000ff00000209400ULL, 0x0000006700617306ULL, 0x000e620000205400ULL,
0x000000604e00720bULL, 0x004fce0003f7d000ULL, 0x0000003c004f7306ULL, 0x000eb0000000d400ULL,
0x00000062003c7306ULL, 0x0006a2000020d400ULL, 0x000000613400720bULL, 0x002fe20003f1d000ULL,
0x000001003f347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000006700577306ULL, 0x000e62000020d400ULL, 0x000100003d627824ULL, 0x008fe200078e00ffULL,
0x000000014f4f2812ULL, 0x004fe400078efcffULL, 0x000000545200720bULL, 0x000fe40003f5d000ULL,
0x00000018ff6c7819ULL, 0x000fe40000011462ULL, 0x0000003d00377306ULL, 0x000fe20000009400ULL,
0x000000013c3c3812ULL, 0x000fc400078efcffULL, 0x0000004d5300720bULL, 0x000fe20003f7d000ULL,
0x000100003e4d7824ULL, 0x000fe200078e00ffULL, 0x0000004f3c3c723eULL, 0x000fc600000010ffULL,
0x0000003d00567306ULL, 0x000ea20000005400ULL, 0x0000000157570812ULL, 0x002fe400078efcffULL,
0x000000014a4a2812ULL, 0x000fe400078efcffULL, 0x0000005a5900720bULL, 0x000fe20003f5d000ULL,
0x00010000465a7824ULL, 0x000fe400078e00ffULL, 0x0000006b00357306ULL, 0x000fe20000209400ULL,
0x0000000115153812ULL, 0x000fe400078efcffULL, 0x00000018ff5a7819ULL, 0x000fca000001145aULL,
0x0000006b00367306ULL, 0x000e620000205400ULL, 0x000000563700720bULL, 0x004fe40003fdd000ULL,
0x0000000114142812ULL, 0x000fca00078efcffULL, 0x0000003d00667306ULL, 0x000eb0000000d400ULL,
0x0000006b003d7306ULL, 0x000ee2000020d400ULL, 0x000000363500720bULL, 0x002fce0003f1d000ULL,
0x0000003f00527306ULL, 0x000fe20000009400ULL, 0x0000000166666812ULL, 0x004fce00078efcffULL,
0x0000003f00537306ULL, 0x000e620000005400ULL, 0x000000013d3d0812ULL, 0x008fc800078efcffULL,
0x000000663d3d723eULL, 0x000fc600000010ffULL, 0x00000034004c7306ULL, 0x000ff00000209400ULL,
0x00000034004e7306ULL, 0x000ea20000205400ULL, 0x000000535200720bULL, 0x002fce0003f1d000ULL,
0x0000003400567306ULL, 0x0002f0000020d400ULL, 0x0000003e00607306ULL, 0x000fe20000009400ULL,
0x011800004834783bULL, 0x002e620000000200ULL, 0x0000004e4c00720bULL, 0x004fcc0003f7d000ULL,
0x0000003e006b7306ULL, 0x000eae0000005400ULL, 0x0000000156563812ULL, 0x008fe200078efcffULL,
0x0000006c00677306ULL, 0x000ff00000209400ULL, 0x0000006c006e7306ULL, 0x000ee20000205400ULL,
0x0000006b6000720bULL, 0x004fce0003fbd000ULL, 0x0000006f00627306ULL, 0x000ff00000209400ULL,
0x0000006f004b7306ULL, 0x000fe20000205400ULL, 0x0000006e6700720bULL, 0x008fe20003fdd000ULL,
0x000000093434c231ULL, 0x002fc400003400ffULL, 0x000000093636c231ULL, 0x000fe400003400ffULL,
0x0000000a3535c231ULL, 0x080fe400003400ffULL, 0x0000006f005f7306ULL, 0x0003e2000020d400ULL,
0x0000000a3737c231ULL, 0x000fe200003400ffULL, 0x000000505100720bULL, 0x000fcc0003f9d000ULL,
0x0000003e00617306ULL, 0x0004e2000000d400ULL, 0x00000018ff6f7819ULL, 0x002fe2000001144dULL,
0x0000003c3418723cULL, 0x000b6a0000041818ULL, 0x0000000113134812ULL, 0x000fe200078efcffULL,
0x0000006f004d7306ULL, 0x000fe20000209400ULL, 0x000100003f3e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000006f00537306ULL, 0x000e620000205400ULL,
0x0000000161615812ULL, 0x008fce00078efcffULL, 0x0000006c005e7306ULL, 0x000eb0000020d400ULL,
0x0000006f00607306ULL, 0x000ee2000020d400ULL, 0x000000534d00720bULL, 0x002fce0003fbd000ULL,
0x0000003e006b7306ULL, 0x000fe20000209400ULL, 0x000000015e5e6812ULL, 0x004fe400078efcffULL,
0x0000004b6200720bULL, 0x000fca0003fdd000ULL, 0x0000003e006c7306ULL, 0x000e620000205400ULL,
0x0000000160605812ULL, 0x008fce00078efcffULL, 0x0000003e00527306ULL, 0x0004e2000020d400ULL,
0x000000015f5f6812ULL, 0x000fce00078efcffULL, 0x00000044004e7306ULL, 0x000fe20000009400ULL,
0x00000100453e7824ULL, 0x004fe200078e00ffULL, 0x0000006c6b00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff627819ULL, 0x000fe4000001143eULL, 0x00000044006f7306ULL, 0x000e6e0000005400ULL,
0x0000000152525812ULL, 0x008fe200078efcffULL, 0x0000003f00547306ULL, 0x0004e6000000d400ULL,
0x000000521313723eULL, 0x000fca00000010ffULL, 0x0000003800557306ULL, 0x000fe20000209400ULL,
0x00000100443f7824ULL, 0x004fe200078e00ffULL, 0x0000006f4e00720bULL, 0x002fe20003f7d000ULL,
0x00010000444e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001143fULL,
0x0000003800587306ULL, 0x000e620000205400ULL, 0x0000000154540812ULL, 0x008fc800078efcffULL,
0x00000054563d723eULL, 0x020fc600000010ffULL, 0x00000045004c7306ULL, 0x000ff00000009400ULL,
0x0000004500757306ULL, 0x000ea20000005400ULL, 0x000000585500720bULL, 0x002fe40003fdd000ULL,
0x00000018ff557819ULL, 0x000fca000001144eULL, 0x00000062003e7306ULL, 0x000ff00000209400ULL,
0x00000062003f7306ULL, 0x000e620000205400ULL, 0x000000754c00720bULL, 0x004fe20003f1d000ULL,
0x00010000454c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff587819ULL, 0x000fe2000001144cULL,
0x0000006e00677306ULL, 0x000ff00000209400ULL, 0x0000006e00517306ULL, 0x000ea20000205400ULL,
0x0000003f3e00720bULL, 0x002fce0003f9d000ULL, 0x0000006e00507306ULL, 0x000e70000020d400ULL,
0x00000062004b7306ULL, 0x000ee2000020d400ULL, 0x000000516700720bULL, 0x004fce0003fbd000ULL,
0x0000005500717306ULL, 0x000fec0000209400ULL, 0x0000000150505812ULL, 0x002fe400078efcffULL,
0x0000005500757306ULL, 0x000e620000205400ULL, 0x000000014b4b4812ULL, 0x008fce00078efcffULL,
0x00000046003e7306ULL, 0x000ff00000009400ULL, 0x00000046004f7306ULL, 0x000ea20000005400ULL,
0x000000757100720bULL, 0x002fce0003fbd000ULL, 0x00000045004d7306ULL, 0x000e70000000d400ULL,
0x00000047003f7306ULL, 0x000fe20000009400ULL, 0x0000004f3e00720bULL, 0x004fe40003f9d000ULL,
0x00000057123e723eULL, 0x000fe200000010ffULL, 0x0001000047127824ULL, 0x000fc800078e00ffULL,
0x00000047003c7306ULL, 0x000ea20000005400ULL, 0x000000014d4d0812ULL, 0x002fc800078efcffULL,
0x0000004d4b4b723eULL, 0x000fc600000010ffULL, 0x0000004400537306ULL, 0x0002f0000000d400ULL,
0x00000055004e7306ULL, 0x000ee2000020d400ULL, 0x0000010046447824ULL, 0x002fe200078e00ffULL,
0x0000003c3f00720bULL, 0x004fc40003f1d000ULL, 0x0000005e153f723eULL, 0x000fe400000010ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011444ULL, 0x0000010047447824ULL, 0x000fe200078e00ffULL,
0x00000058006e7306ULL, 0x000fe20000209400ULL, 0x00000018ff157819ULL, 0x000fe40000011412ULL,
0x0000003e341c723cULL, 0x000b62000004181cULL, 0x00000018ff517819ULL, 0x000fe40000011444ULL,
0x0000000153533812ULL, 0x008fc400078efcffULL, 0x00000058006f7306ULL, 0x000e620000205400ULL,
0x000000014e4e5812ULL, 0x000fe400078efcffULL, 0x000000604a12723eULL, 0x000fe400000010ffULL,
0x000000615f3c723eULL, 0x000fe400000010ffULL, 0x00000053504a723eULL, 0x000fe200000010ffULL,
0x0000006b00627306ULL, 0x000fe40000209400ULL, 0x000000123424723cULL, 0x040b6c0000041824ULL,
0x0000006b00597306ULL, 0x000ea20000205400ULL, 0x0000006f6e00720bULL, 0x002fe20003f7d000ULL,
0x0000003c3420723cULL, 0x040f6c0000041820ULL, 0x0000005800457306ULL, 0x000e64000020d400ULL,
0x0000004a3428723cULL, 0x000f6c0000041828ULL, 0x0000005100587306ULL, 0x000fe20000209400ULL,
0x000000596200720bULL, 0x004fce0003fbd000ULL, 0x0000005100557306ULL, 0x000ea20000205400ULL,
0x0000000145453812ULL, 0x002fe400078efcffULL, 0x0000005c3b00720bULL, 0x000fca0003f7d000ULL,
0x0000005100447306ULL, 0x000e70000020d400ULL, 0x0000004600517306ULL, 0x000ee2000000d400ULL,
0x000000555800720bULL, 0x004fe40003f5d000ULL, 0x000000013a3a3812ULL, 0x000fca00078efcffULL,
0x0000003800387306ULL, 0x000eac000020d400ULL, 0x0000000144442812ULL, 0x002fe400078efcffULL,
0x0000006b004c7306ULL, 0x000e62000020d400ULL, 0x0000000151514812ULL, 0x008fce00078efcffULL,
0x0000004700467306ULL, 0x000ee2000000d400ULL, 0x0000000138386812ULL, 0x004fe400078efcffULL,
0x0000005b5d00720bULL, 0x000fe40003fdd000ULL, 0x0000004e384e723eULL, 0x000fc600000010ffULL,
0x0000005a004f7306ULL, 0x000fe20000209400ULL, 0x000000014c4c5812ULL, 0x002fc800078efcffULL,
0x000000514c4c723eULL, 0x000fc600000010ffULL, 0x0000005a00477306ULL, 0x000e620000205400ULL,
0x0000000146460812ULL, 0x008fe400078efcffULL, 0x0000000139396812ULL, 0x000fe400078efcffULL,
0x00000046444d723eULL, 0x000fc600000010ffULL, 0x0000001500577306ULL, 0x000fe80000209400ULL,
0x0000004c3430723cULL, 0x000f680000041830ULL, 0x00000015003e7306ULL, 0x020ea20000205400ULL,
0x000000474f00720bULL, 0x002fe40003fbd000ULL, 0x00000045144f723eULL, 0x000fe200000010ffULL,
0x0000000200147824ULL, 0x000fc800078e00ffULL, 0x0000005a005a7306ULL, 0x000e62000020d400ULL,
0xfffffff814147812ULL, 0x000fe200078ec0ffULL, 0x0000004e342c723cULL, 0x000f6c000004182cULL,
0x0000001500137306ULL, 0x000ee2000020d400ULL, 0x0000003e5700720bULL, 0x004fe40003f9d000ULL,
0x000000015a5a5812ULL, 0x002fc800078efcffULL, 0x0000005a3912723eULL, 0x000fce00000010ffULL,
0x0000000113134812ULL, 0x008fc800078efcffULL, 0x000000133a13723eULL, 0x000fce00000010ffULL,
0x000000123434723cULL, 0x000b6e0000041840ULL, 0x000176c873127811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176900014ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff3a7224ULL, 0x000fc600078e00ffULL, 0x0000000000147805ULL, 0x004fc80000015200ULL,
0x0000040006397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x006fc40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038143b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e15ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040006397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000147824ULL, 0x000fe400078e00ffULL,
0x000059000f0f7a24ULL, 0x010fc600078e02ffULL, 0xffffffe014127812ULL, 0x000fe200078ec0ffULL,
0x000000400f0f7824ULL, 0x000fc800078e00ffULL, 0x0000010005127824ULL, 0x000fca00078e0212ULL,
0x000000c012137810ULL, 0x000fc80007ffe0ffULL, 0x0000002013127812ULL, 0x000fca00078ec0ffULL,
0x00000001773b7824ULL, 0x000fe200078e0212ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000001014157812ULL, 0x000fe400078ec0ffULL, 0x0000001370127217ULL, 0x000fe40007800000ULL,
0x00000003ff147819ULL, 0x000fc60000011603ULL, 0x0000000112127824ULL, 0x000fe200078e0a13ULL,
0x0000000414397810ULL, 0x040fe20007ffe0ffULL, 0x0000000114387824ULL, 0x040fe200078e0215ULL,
0x0000000c143d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001215127217ULL, 0x000fe20007800000ULL,
0x0000000138137824ULL, 0x040fe400078e0203ULL, 0x00000008383c7824ULL, 0x000fe400078e00ffULL,
0x0000000112127824ULL, 0x000fc400078e0a15ULL, 0x000000013d427824ULL, 0x000fe200078e0215ULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee213ULL, 0x0000000814137810ULL, 0x040fe40007ffe0ffULL,
0x000000121400720cULL, 0x080fe20003f86070ULL, 0x0000000138147824ULL, 0x000fe200078e023bULL,
0x000000123900720cULL, 0x080fe20003f66070ULL, 0x00000001133a7824ULL, 0x140fe200078e0215ULL,
0x000000121300720cULL, 0x080fe20003f46070ULL, 0x0000000139387824ULL, 0x000fe200078e0215ULL,
0x000000123d00720cULL, 0x000fe20003f06070ULL, 0x000000013a127824ULL, 0x040fe200078e0203ULL,
0x000062000f3d7a11ULL, 0x000fe200078a38ffULL, 0x000000083a397824ULL, 0x000fc400078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000063000f3f7a11ULL, 0x000fe400028f3cffULL,
0xfffffff839407812ULL, 0x000fe200078ee212ULL, 0x0000000138137824ULL, 0x000fe200078e0203ULL,
0x0000006314147212ULL, 0x000fe200078efcffULL, 0x00000008383e7824ULL, 0x040fe400078e00ffULL,
0x0000000138387824ULL, 0x100fe200078e023bULL, 0x000000143d147210ULL, 0x000fe20007fbe0ffULL,
0x000000013a3a7824ULL, 0x000fe200078e023bULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x0000000142127824ULL, 0x000fe200078e023bULL,
0x0000006338387212ULL, 0x000fe200078efcffULL, 0x000000803a3a7825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000633a3a7212ULL, 0x000fc600078efcffULL,
0x0000000115157824ULL, 0x000fe200028e063fULL, 0x0000003d38387210ULL, 0x000fe20007fbe0ffULL,
0x00000001420f7824ULL, 0x000fe200078e0203ULL, 0x0000006312127212ULL, 0x000fe200078efcffULL,
0x0000000842427824ULL, 0x000fe400078e00ffULL, 0x0000000139397824ULL, 0x000fe200028e063fULL,
0x0000003d3a3a7210ULL, 0x080fe40007fbe0ffULL, 0x0000003d12127210ULL, 0x000fe20007fde0ffULL,
0x000000103e3d7824ULL, 0x000fe200078e0269ULL, 0xfffffff842427812ULL, 0x000fe200078ee20fULL,
0x000000103c0f7824ULL, 0x000fc400078e0269ULL, 0x000000013b3b7824ULL, 0x100fe400028e063fULL,
0x0000000113137824ULL, 0x000fe200030e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140f7faeULL, 0x0003e2000e101c48ULL, 0x00000010403f7824ULL, 0x100fe400078e0269ULL,
0x0000001042417824ULL, 0x000fe200078e0269ULL, 0x00000000383d7faeULL, 0x0003e8000d901c48ULL,
0x000000003a3f7faeULL, 0x0003e8000d101c48ULL, 0x0000000012417faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001014147812ULL, 0x000fe400078ec0ffULL,
0x000062000f3d7a11ULL, 0x000fc400078038ffULL, 0x0000001403127211ULL, 0x000fe400078fe8ffULL,
0x000063000f3f7a11ULL, 0x000fe400000f3cffULL, 0x0000000412387810ULL, 0x040fe20007ffe0ffULL,
0x0000000112137824ULL, 0x040fe200078e0203ULL, 0x00000008123e7810ULL, 0x040fe20007ffe0ffULL,
0x00000008123c7824ULL, 0x040fe200078e00ffULL, 0x0000000c12407810ULL, 0x040fe20007ffe0ffULL,
0x0000000112147824ULL, 0x100fe400078e023bULL, 0x00000001383a7824ULL, 0x000fe200078e023bULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL, 0x0000000138137824ULL, 0x000fc400078e0203ULL,
0x0000000838427824ULL, 0x000fe400078e00ffULL, 0x000000013e387824ULL, 0x100fe400078e023bULL,
0x0000000140127824ULL, 0x000fe400078e023bULL, 0x000000013e397824ULL, 0x040fe400078e0203ULL,
0x000000083e447824ULL, 0x000fe200078e00ffULL, 0xfffffff8423e7812ULL, 0x000fe200078ee213ULL,
0x00000001403b7824ULL, 0x000fc400078e0203ULL, 0x0000000840467824ULL, 0x000fe200078e00ffULL,
0xfffffff844407812ULL, 0x000fe200078ee239ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff846427812ULL, 0x000fe200078ee23bULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000006314147212ULL, 0x000fc600078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000000143d147210ULL, 0x040fe40007f1e0ffULL, 0x000000633a3a7212ULL, 0x080fe200078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000006338387212ULL, 0x080fe400078efcffULL,
0x0000003a3d3a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000115157824ULL, 0x000fe200000e063fULL,
0x0000006312127212ULL, 0x000fe200078efcffULL, 0x000000103c0f7824ULL, 0x000fe200078e0269ULL,
0x000000383d387210ULL, 0x000fe20007f1e0ffULL, 0x000000013b3b7824ULL, 0x000fe200010e063fULL,
0x000000123d127210ULL, 0x000fe20007f7e0ffULL, 0x000000103e3d7824ULL, 0x000fe200078e0269ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140f7faeULL, 0x0003e2000b901c48ULL,
0x0000000139397824ULL, 0x000fc400000e063fULL, 0x0000000113137824ULL, 0x000fe200018e063fULL,
0x000000003a3d7faeULL, 0x0003e2000b901c48ULL, 0x00000010403f7824ULL, 0x100fe400078e0269ULL,
0x0000001042417824ULL, 0x000fc600078e0269ULL, 0x00000000383f7faeULL, 0x0003e8000b901c48ULL,
0x0000000012417faeULL, 0x0003e4000b901c48ULL, 0x0000000800147824ULL, 0x002fe200078e00ffULL,
0x0000000302127810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0f7424ULL, 0x000fc600078e00ffULL,
0xfffffff014147812ULL, 0x000fe400078ec0ffULL, 0x000000761200720cULL, 0x000fe40003f06070ULL,
0x00000000140473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000179128824ULL, 0x000fc400078e0212ULL, 0x00000004ff138424ULL, 0x000fc800078e00ffULL,
0x0000640012128625ULL, 0x000fca00078e0013ULL, 0x00000008120f8981ULL, 0x000522000c1e1900ULL,
0x000176b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0176b00014127f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176480007147f8cULL, 0x0022e4000c80043fULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01764c00073b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x00afe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01764c00073b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000077824ULL, 0x000fca00078e00ffULL, 0xffffff8007147812ULL, 0x000fc800078ec0ffULL,
0x0000010063077810ULL, 0x000fca0007ffe014ULL, 0x0000000174077824ULL, 0x000fca00078e0207ULL,
0x0170000007397984ULL, 0x000e680000000800ULL, 0x0172000007387984ULL, 0x0006a20000000800ULL,
0x0000000e3900720bULL, 0x002fe20003f1d000ULL, 0x0000f8c27f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c407812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fd200078e000eULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000027a077810ULL, 0x000fe40007ffe0ffULL, 0x0000000e3900720bULL, 0x000fe40003f54000ULL,
0x000000000700720cULL, 0x000fe20003f05270ULL, 0x0000f8727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000077806ULL, 0x000fc400010e0100ULL, 0x0000008000158824ULL, 0x000fe200078e0263ULL,
0x0000000e39148209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001743b8824ULL, 0x000fe200078e0215ULL, 0x0000991007157816ULL, 0x000fc800000000ffULL,
0x017400143b008388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000e39157209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff07ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000e15147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x00000014003a7308ULL, 0x000e640000000800ULL, 0x0000003a0d0d7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe20000011603ULL,
0x0000f7a27f007947ULL, 0x000fea000b800000ULL, 0x00001f143a3c7589ULL, 0x0002e400000e0000ULL,
0x0000003c18187220ULL, 0x08cfe40000410000ULL, 0x0000003c19197220ULL, 0x080fe40000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x000fc40000410000ULL,
0x0000003c20207220ULL, 0x080fe40000410000ULL, 0x0000003c21217220ULL, 0x080fe40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x080fe40000410000ULL,
0x0000003c28287220ULL, 0x080fe40000410000ULL, 0x0000003c29297220ULL, 0x000fc40000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000003c30307220ULL, 0x080fe40000410000ULL, 0x0000003c31317220ULL, 0x080fe40000410000ULL,
0x0000003c34347220ULL, 0x080fe40000410000ULL, 0x0000003c35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0007ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803147811ULL, 0x002fe200078ff0ffULL,
0x0000f6a27f007947ULL, 0x000fea000b800000ULL, 0x00001f143a3c7589ULL, 0x0002e400000e0000ULL,
0x0000003c1a1a7220ULL, 0x08cfe40000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c22227220ULL, 0x080fe40000410000ULL, 0x0000003c23237220ULL, 0x000fc40000410000ULL,
0x0000003c26267220ULL, 0x080fe40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003c2f2f7220ULL, 0x000fc40000410000ULL,
0x0000003c32327220ULL, 0x080fe40000410000ULL, 0x0000003c33337220ULL, 0x080fe40000410000ULL,
0x0000003c36367220ULL, 0x080fe40000410000ULL, 0x0000003c37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff40ff7812ULL, 0x000fe20007806007ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000000e39077209ULL, 0x000fd60007810000ULL,
0x8000000739390221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL, 0x0000003900080308ULL, 0x000e640000000800ULL,
0x0000000838380220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d380d7221ULL, 0x004fc40000010000ULL, 0x0000000000147805ULL, 0x000fca0000015200ULL,
0x00000008000e7824ULL, 0x000fca00078e00ffULL, 0xfffffff00e3c7812ULL, 0x000fca00078ec0ffULL,
0x0176ac003c397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038143b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e15ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011439ULL,
0x0000003b0e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x000000020e0e7819ULL, 0x000fc80000001239ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac003c397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103a0e7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0e00720cULL, 0x000fda0003fc5270ULL, 0x0000016000006947ULL, 0x000fea0003800000ULL,
0x00000008ff09723eULL, 0x000fe400000010ffULL, 0x00000002ff177819ULL, 0x000fe40000011603ULL,
0x00005410090e7816ULL, 0x000fe20000000009ULL, 0x0000f2727f007947ULL, 0x000fea000b800000ULL,
0x00001f170e097589ULL, 0x0002a400000e0000ULL, 0x0000000817147810ULL, 0x000fe20007ffe0ffULL,
0x0000f2c27f007947ULL, 0x000fea000b800000ULL, 0x00001f140e0a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001017147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e000eULL, 0x00009b70003d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000fac000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001817147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00009be0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x0000fa5000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100c147824ULL, 0x108fe200078e0265ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001011407824ULL, 0x100fe400078e0265ULL,
0x000000100b387824ULL, 0x000fe400078e0265ULL, 0x000000001414783bULL, 0x002e680000004200ULL,
0x000000004040783bULL, 0x000ee80000004200ULL, 0x000000003838783bULL, 0x000ea20000004200ULL,
0x00000018ff477819ULL, 0x002fc40000011417ULL, 0x00000018ff467819ULL, 0x000fe40000011415ULL,
0x00000018ff0c7819ULL, 0x008fe20000011440ULL, 0x00000047005b7306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x000fe40000011442ULL, 0x00000018ff5a7819ULL, 0x004fe40000011438ULL,
0x00000018ff117819ULL, 0x000fe40000011441ULL, 0x00000018ff6b7819ULL, 0x000fe20000011439ULL,
0x00000047005c7306ULL, 0x000ff00000205400ULL, 0x0000004700577306ULL, 0x000ff0000020d400ULL,
0x0000004000477306ULL, 0x000ff00000009400ULL, 0x0000004000667306ULL, 0x000e700000005400ULL,
0x0000000c00607306ULL, 0x000ff00000209400ULL, 0x0000000c00457306ULL, 0x000ea20000205400ULL,
0x000000664700720bULL, 0x002fce0003f7d000ULL, 0x0000000c00597306ULL, 0x0002f0000020d400ULL,
0x0000004400517306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x002fe40000011443ULL,
0x000000456000720bULL, 0x004fe20003f9d000ULL, 0x0000010041607824ULL, 0x000fc800078e00ffULL,
0x0000004400527306ULL, 0x000e620000205400ULL, 0x00000018ff717819ULL, 0x000fce0000011460ULL,
0x0000004400507306ULL, 0x000462000020d400ULL, 0x0000000159594812ULL, 0x008fce00078efcffULL,
0x00000041005f7306ULL, 0x000fe20000009400ULL, 0x00000018ff447819ULL, 0x004fe40000011416ULL,
0x000000525100720bULL, 0x002fca0003f9d000ULL, 0x00000041006c7306ULL, 0x000e700000005400ULL,
0x0000004600547306ULL, 0x000fe20000209400ULL, 0x0000000150504812ULL, 0x000fce00078efcffULL,
0x0000004600557306ULL, 0x000fe20000205400ULL, 0x0000006c5f00720bULL, 0x002fe20003f5d000ULL,
0x00010000415f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001145fULL,
0x0000004600617306ULL, 0x0003f0000020d400ULL, 0x0000000c00567306ULL, 0x000fe20000209400ULL,
0x0001000040467824ULL, 0x002fca00078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011446ULL,
0x0000000c00537306ULL, 0x000ff00000205400ULL, 0x0000000c004c7306ULL, 0x000ff0000020d400ULL,
0x00000044000b7306ULL, 0x000ff00000209400ULL, 0x00000044000c7306ULL, 0x000ff00000205400ULL,
0x0000004400587306ULL, 0x0003f0000020d400ULL, 0x0000006e00467306ULL, 0x000fe20000209400ULL,
0x0000010040447824ULL, 0x002fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011444ULL,
0x0000006e00477306ULL, 0x000e700000205400ULL, 0x00000067005d7306ULL, 0x000ff00000209400ULL,
0x00000067005e7306ULL, 0x000ea20000205400ULL, 0x000000474600720bULL, 0x002fce0003fbd000ULL,
0x0000006e00667306ULL, 0x000e70000020d400ULL, 0x0000005a004a7306ULL, 0x000fe20000209400ULL,
0x0000005e5d00720bULL, 0x004fce0003f1d000ULL, 0x0000005a004b7306ULL, 0x000fe20000205400ULL,
0x0000000166665812ULL, 0x002fce00078efcffULL, 0x0000005a004d7306ULL, 0x000ff0000020d400ULL,
0x0000006c005f7306ULL, 0x000ff00000209400ULL, 0x0000006c00607306ULL, 0x000e700000205400ULL,
0x0000006700447306ULL, 0x000eb0000020d400ULL, 0x00000040005a7306ULL, 0x000ee2000000d400ULL,
0x000000605f00720bULL, 0x002fce0003fbd000ULL, 0x0000007100407306ULL, 0x000fe20000209400ULL,
0x0000000144440812ULL, 0x004fce00078efcffULL, 0x00000071006f7306ULL, 0x000e620000205400ULL,
0x000000015a5a3812ULL, 0x008fc800078efcffULL, 0x0000005a4444723eULL, 0x000fc600000010ffULL,
0x0000004100457306ULL, 0x0004f0000000d400ULL, 0x00000011003c7306ULL, 0x000fe20000209400ULL,
0x0000010042417824ULL, 0x004fe200078e00ffULL, 0x0000006f4000720bULL, 0x002fe20003f1d000ULL,
0x0000010043407824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011441ULL,
0x00000011003d7306ULL, 0x000e620000205400ULL, 0x00000018ff6f7819ULL, 0x000fe40000011440ULL,
0x0000000145452812ULL, 0x008fca00078efcffULL, 0x0000006c00677306ULL, 0x000eb0000020d400ULL,
0x0000006e00417306ULL, 0x000fe20000209400ULL, 0x0000003d3c00720bULL, 0x002fce0003f7d000ULL,
0x0000006e005e7306ULL, 0x000e620000205400ULL, 0x0000000167675812ULL, 0x004fce00078efcffULL,
0x00000011000e7306ULL, 0x0004f0000020d400ULL, 0x00000042003c7306ULL, 0x000fe20000009400ULL,
0x00000018ff117819ULL, 0x004fe40000011414ULL, 0x0000005e4100720bULL, 0x002fe20003fbd000ULL,
0x00010000435e7824ULL, 0x000fc800078e00ffULL, 0x00000011003f7306ULL, 0x000fe20000209400ULL,
0x000000010e0e3812ULL, 0x008fe400078efcffULL, 0x00000018ff5e7819ULL, 0x000fca000001145eULL,
0x00000011003e7306ULL, 0x000e700000205400ULL, 0x00000042003d7306ULL, 0x000eb00000005400ULL,
0x0000006e00477306ULL, 0x0006e2000020d400ULL, 0x0000003e3f00720bULL, 0x002fce0003f5d000ULL,
0x0000006f00407306ULL, 0x000fe20000209400ULL, 0x0000003d3c00720bULL, 0x004fe20003f7d000ULL,
0x00000010103c7824ULL, 0x000fe200078e0265ULL, 0x00000018ff6e7819ULL, 0x008fca000001143bULL,
0x0000006f005d7306ULL, 0x000e620000205400ULL, 0x0000000147475812ULL, 0x000fce00078efcffULL,
0x00000042005f7306ULL, 0x0004f0000000d400ULL, 0x0000006f00467306ULL, 0x0006e2000020d400ULL,
0x0001000042427824ULL, 0x004fe200078e00ffULL, 0x0000005d4000720bULL, 0x002fcc0003fbd000ULL,
0x00000043003e7306ULL, 0x000fe20000009400ULL, 0x00000018ff6f7819ULL, 0x008fe40000011442ULL,
0x000000015f5f3812ULL, 0x000fca00078efcffULL, 0x00000043003f7306ULL, 0x000e620000005400ULL,
0x0000000146465812ULL, 0x000fce00078efcffULL, 0x0000006f00417306ULL, 0x000ff00000209400ULL,
0x0000006f00407306ULL, 0x000ea20000205400ULL, 0x0000003f3e00720bULL, 0x002fe40003f7d000ULL,
0x000000003c3c783bULL, 0x000e6a0000004200ULL, 0x0000004300607306ULL, 0x0006e2000000d400ULL,
0x000000404100720bULL, 0x004fce0003fbd000ULL, 0x0000005e006c7306ULL, 0x000fe20000209400ULL,
0x012000004940783bULL, 0x008ea20000000200ULL, 0x0000000160603812ULL, 0x000fcc00078efcffULL,
0x0000001100627306ULL, 0x000ee2000020d400ULL, 0x000000555400720bULL, 0x000fce0003f7d000ULL,
0x0000005e00557306ULL, 0x000e6c0000205400ULL, 0x0000000161613812ULL, 0x000fe400078efcffULL,
0x0000006b004f7306ULL, 0x000fe20000209400ULL, 0x0000000162622812ULL, 0x008fe400078efcffULL,
0x00000018ff757819ULL, 0x002fca000001143fULL, 0x0000006b004e7306ULL, 0x000fe20000205400ULL,
0x000000556c00720bULL, 0x000fe20003f9d000ULL, 0x00000100146c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000006b00117306ULL, 0x000fe2000020d400ULL,
0x000000094040e231ULL, 0x084fe400003400ffULL, 0x000000094242e231ULL, 0x000fe400003400ffULL,
0x0000000a4141e231ULL, 0x080fe400003400ffULL, 0x0000000a4343e231ULL, 0x000fe200003400ffULL,
0x00000071006b7306ULL, 0x0002b0000020d400ULL, 0x0000005e005e7306ULL, 0x000ee2000020d400ULL,
0x00000018ff717819ULL, 0x002fc4000001143dULL, 0x000000016b6b0812ULL, 0x004fca00078efcffULL,
0x0000006c005a7306ULL, 0x000fe20000209400ULL, 0x000000535600720bULL, 0x000fe40003f1d000ULL,
0x000000456b45723eULL, 0x000fe400000010ffULL, 0x00000018ff567819ULL, 0x000fe4000001143aULL,
0x000000015e5e4812ULL, 0x008fe200078efcffULL, 0x0000006c006b7306ULL, 0x000e640000205400ULL,
0x000000444018723cULL, 0x000be80000041818ULL, 0x000000014c4c0812ULL, 0x000fc400078efcffULL,
0x0000006c00497306ULL, 0x0004e2000020d400ULL, 0x000000665944723eULL, 0x020fe400000010ffULL,
0x000000670e45723eULL, 0x000fca00000010ffULL, 0x0000006f005d7306ULL, 0x0006e2000020d400ULL,
0x00000100156c7824ULL, 0x004fe200078e00ffULL, 0x0000006b5a00720bULL, 0x002fe20003f9d000ULL,
0x00000044401c723cULL, 0x000b66000004181cULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000014005a7306ULL, 0x000fe20000009400ULL, 0x00000018ff6f7819ULL, 0x008fcc000001143cULL,
0x0000000149494812ULL, 0x000fe200078efcffULL, 0x00000014006b7306ULL, 0x000e620000005400ULL,
0x000000015d5d5812ULL, 0x000fe400078efcffULL, 0x0000000c0b00720bULL, 0x000fca0003fbd000ULL,
0x0000006c000e7306ULL, 0x000ff00000209400ULL, 0x0000006c00457306ULL, 0x020ea20000205400ULL,
0x0000006b5a00720bULL, 0x002fe40003f1d000ULL, 0x0000000158585812ULL, 0x000fca00078efcffULL,
0x0000001400667306ULL, 0x0002f0000000d400ULL, 0x0000006f00547306ULL, 0x000fe20000209400ULL,
0x0001000014147824ULL, 0x002fe200078e00ffULL, 0x000000450e00720bULL, 0x004fc40003f9d000ULL,
0x000000604645723eULL, 0x000fc800000010ffULL, 0x0000006f00557306ULL, 0x000fe20000205400ULL,
0x0000000166660812ULL, 0x008fce00078efcffULL, 0x0000006f000b7306ULL, 0x0003f0000020d400ULL,
0x0000005600517306ULL, 0x000fe20000209400ULL, 0x00000018ff6f7819ULL, 0x002fce0000011414ULL,
0x0000005600527306ULL, 0x000ff00000205400ULL, 0x0000005600107306ULL, 0x000ff0000020d400ULL,
0x0000006e00537306ULL, 0x000ff00000209400ULL, 0x0000006e00567306ULL, 0x000ff00000205400ULL,
0x0000006e000c7306ULL, 0x000ff0000020d400ULL, 0x0000001500677306ULL, 0x000ff00000009400ULL,
0x0000001500447306ULL, 0x000e700000005400ULL, 0x0000006c006b7306ULL, 0x000eb0000020d400ULL,
0x0000006f00147306ULL, 0x000fe20000209400ULL, 0x000000446700720bULL, 0x002fc40003f1d000ULL,
0x0000005f4744723eULL, 0x000fe200000010ffULL, 0x0001000015477824ULL, 0x000fc800078e00ffULL,
0x0000006f006e7306ULL, 0x000e620000205400ULL, 0x000000016b6b4812ULL, 0x004fce00078efcffULL,
0x00000015006c7306ULL, 0x0004e2000000d400ULL, 0x0000006e1400720bULL, 0x002fe20003f9d000ULL,
0x0000010016147824ULL, 0x000fcc00078e00ffULL, 0x0000006f00677306ULL, 0x000262000020d400ULL,
0x00000018ff157819ULL, 0x004fe40000011447ULL, 0x000000444044723cULL, 0x000be20000041820ULL,
0x000000016c6c0812ULL, 0x008fc800078efcffULL, 0x0000001600237306ULL, 0x020fe20000009400ULL,
0x00000018ff6f7819ULL, 0x002fe40000011414ULL, 0x0000005d5014723eULL, 0x000fca00000010ffULL,
0x0000001600507306ULL, 0x000e620000005400ULL, 0x0000000167674812ULL, 0x000fce00078efcffULL,
0x0000001500607306ULL, 0x000ff00000209400ULL, 0x00000015005f7306ULL, 0x000ea20000205400ULL,
0x000000502300720bULL, 0x002fe20003f5d000ULL, 0x0000010017237824ULL, 0x000fca00078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000006f00217306ULL, 0x000ff00000209400ULL,
0x0000006f006e7306ULL, 0x000e620000205400ULL, 0x0000005f6000720bULL, 0x004fce0003f1d000ULL,
0x0000001500227306ULL, 0x0004f0000020d400ULL, 0x0000006f00207306ULL, 0x0006e2000020d400ULL,
0x0000005e4c15723eULL, 0x004fe400000010ffULL, 0x0000006e2100720bULL, 0x002fc40003f9d000ULL,
0x00000018ff6e7819ULL, 0x000fc6000001143eULL, 0x000000144024723cULL, 0x000b620000041824ULL,
0x00010000166f7824ULL, 0x008fe200078e00ffULL, 0x0000001700147306ULL, 0x020fe20000009400ULL,
0x0000000122220812ULL, 0x000fc600078efcffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000000120204812ULL, 0x000fe400078efcffULL, 0x00000017005d7306ULL, 0x000e700000005400ULL,
0x0000002300157306ULL, 0x000ff00000209400ULL, 0x00000023004c7306ULL, 0x000ea20000205400ULL,
0x0000005d1400720bULL, 0x002fc40003f1d000ULL, 0x000000664914723eULL, 0x000fca00000010ffULL,
0x0000007100597306ULL, 0x000ff00000209400ULL, 0x00000071005a7306ULL, 0x000fe20000205400ULL,
0x0000004c1500720bULL, 0x004fe40003f7d000ULL, 0x0000006c6b15723eULL, 0x000fca00000010ffULL,
0x00000071000e7306ULL, 0x000ff0000020d400ULL, 0x0000001600217306ULL, 0x000e70000000d400ULL,
0x0000006f00167306ULL, 0x000ff00000209400ULL, 0x0000006f00717306ULL, 0x000ea20000205400ULL,
0x0000000121212812ULL, 0x002fc400078efcffULL, 0x0000005c5b00720bULL, 0x000fca0003f5d000ULL,
0x0000006e005f7306ULL, 0x000ff00000209400ULL, 0x0000006e00607306ULL, 0x000fe20000205400ULL,
0x000000711600720bULL, 0x004fe40003f9d000ULL, 0x0000000157572812ULL, 0x000fca00078efcffULL,
0x0000006e00507306ULL, 0x0003f0000020d400ULL, 0x0000002300237306ULL, 0x000ea2000020d400ULL,
0x00010000176e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000001700667306ULL, 0x0002f0000000d400ULL, 0x0000006e006b7306ULL, 0x000fe20000209400ULL,
0x000000144014723cULL, 0x002be20000041828ULL, 0x0000000123233812ULL, 0x004fcc00078efcffULL,
0x0000006e006c7306ULL, 0x000e620000205400ULL, 0x000000676228723eULL, 0x020fe400000010ffULL,
0x000000226129723eULL, 0x000fe200000010ffULL, 0x0000010038227824ULL, 0x000fe200078e00ffULL,
0x0000000166660812ULL, 0x008fc600078efcffULL, 0x0000006f00497306ULL, 0x000ea2000020d400ULL,
0x00000018ff717819ULL, 0x000fe20000011422ULL, 0x000000284028723cULL, 0x000b6c000004182cULL,
0x0000006e00627306ULL, 0x000ee2000020d400ULL, 0x00000021202c723eULL, 0x020fe400000010ffULL,
0x0000006c6b00720bULL, 0x002fc40003f1d000ULL, 0x00000066232d723eULL, 0x000fc600000010ffULL,
0x0000003800207306ULL, 0x000fe20000009400ULL, 0x0000000149494812ULL, 0x004fc600078efcffULL,
0x0000002c402c723cULL, 0x000b680000041830ULL, 0x00000038005c7306ULL, 0x000e620000005400ULL,
0x0000000162620812ULL, 0x008fe400078efcffULL, 0x000000495830723eULL, 0x020fe200000010ffULL,
0x0001000038327824ULL, 0x000fe200078e00ffULL, 0x000000625731723eULL, 0x000fc600000010ffULL,
0x0000003800217306ULL, 0x000ea2000000d400ULL, 0x00000018ff577819ULL, 0x000fc60000011432ULL,
0x000000304030723cULL, 0x000b680000041834ULL, 0x00000039006b7306ULL, 0x000fe20000009400ULL,
0x0000005c2000720bULL, 0x002fe40003f1d000ULL, 0x0000010039347824ULL, 0x060fe400078e00ffULL,
0x0001000039357824ULL, 0x000fc600078e00ffULL, 0x0000003900497306ULL, 0x000e620000005400ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fc60000011435ULL,
0x0000000121210812ULL, 0x004fe400078efcffULL, 0x0000004b4a00720bULL, 0x000fe20003f1d000ULL,
0x0000003900237306ULL, 0x0004e2000000d400ULL, 0x000000496b00720bULL, 0x002fce0003f5d000ULL,
0x0000005700387306ULL, 0x000fe20000209400ULL, 0x012000004848783bULL, 0x000e620000000200ULL,
0x000001003a397824ULL, 0x004fe400078e00ffULL, 0x000000014d4d0812ULL, 0x000fe400078efcffULL,
0x0000004e4f00720bULL, 0x000fe40003f1d000ULL, 0x0000005700437306ULL, 0x000ea20000205400ULL,
0x00000018ff427819ULL, 0x000fe40000011439ULL, 0x0000000123232812ULL, 0x008fca00078efcffULL,
0x0000003a00397306ULL, 0x000fe60000009400ULL, 0x0000000111110812ULL, 0x000fe400078efcffULL,
0x000000565300720bULL, 0x000fc60003f1d000ULL, 0x0000003a00207306ULL, 0x000ee20000005400ULL,
0x000000433800720bULL, 0x004fce0003f7d000ULL, 0x0000007100227306ULL, 0x000fe40000209400ULL,
0x000000010c0c0812ULL, 0x000fcc00078efcffULL, 0x0000007100677306ULL, 0x000ea20000205400ULL,
0x000000203900720bULL, 0x008fe20003fbd000ULL, 0x000100003a207824ULL, 0x000fe200078e00ffULL,
0x000000094848e231ULL, 0x082fe400003400ffULL, 0x000000094a4ae231ULL, 0x000fe400003400ffULL,
0x00000018ff397819ULL, 0x000fe20000011420ULL, 0x0000005700367306ULL, 0x000e62000020d400ULL,
0x000100003b207824ULL, 0x000fe200078e00ffULL, 0x0000000a4949e231ULL, 0x000fc400003400ffULL,
0x0000000a4b4be231ULL, 0x000fe400003400ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011420ULL,
0x0000003400407306ULL, 0x000fe20000209400ULL, 0x000000672200720bULL, 0x004fce0003f9d000ULL,
0x00000034006f7306ULL, 0x000ea20000205400ULL, 0x0000000136363812ULL, 0x002fc800078efcffULL,
0x000000364d36723eULL, 0x000fc600000010ffULL, 0x0000004200627306ULL, 0x000ff00000209400ULL,
0x0000004200667306ULL, 0x000e620000205400ULL, 0x0000006f4000720bULL, 0x004fce0003f7d000ULL,
0x00000035006c7306ULL, 0x000ff00000209400ULL, 0x00000035006e7306ULL, 0x000ea20000205400ULL,
0x000000666200720bULL, 0x002fce0003fdd000ULL, 0x00000034005b7306ULL, 0x0002f0000020d400ULL,
0x0000004200577306ULL, 0x000ee2000020d400ULL, 0x000001003b347824ULL, 0x002fe200078e00ffULL,
0x0000006e6c00720bULL, 0x004fc80003f5d000ULL, 0x00000018ff5c7819ULL, 0x000fe40000011434ULL,
0x0000003b00227306ULL, 0x000fe20000009400ULL, 0x000000015b5b3812ULL, 0x008fe400078efcffULL,
0x000000525100720bULL, 0x000fe20003f7d000ULL, 0x000100003d527824ULL, 0x000fe200078e00ffULL,
0x000000235b23723eULL, 0x000fc600000010ffULL, 0x0000003b00437306ULL, 0x000fe20000005400ULL,
0x0000000157576812ULL, 0x000fe400078efcffULL, 0x00000018ff527819ULL, 0x000fca0000011452ULL,
0x0000003b00427306ULL, 0x0003e2000000d400ULL, 0x0000000110103812ULL, 0x000fe400078efcffULL,
0x000000555400720bULL, 0x000fca0003f7d000ULL, 0x0000007100617306ULL, 0x000ea2000020d400ULL,
0x000001003c3b7824ULL, 0x002fce00078e00ffULL, 0x00000075005d7306ULL, 0x000fe20000209400ULL,
0x000000010b0b3812ULL, 0x000fe400078efcffULL, 0x000000605f00720bULL, 0x000fca0003f7d000ULL,
0x00000075005e7306ULL, 0x000fe20000205400ULL, 0x0000000161614812ULL, 0x004fe400078efcffULL,
0x000000432200720bULL, 0x000fca0003f9d000ULL, 0x00000075004c7306ULL, 0x0003e2000020d400ULL,
0x0000000150503812ULL, 0x000fce00078efcffULL, 0x0000005c00417306ULL, 0x000fe20000209400ULL,
0x00000018ff757819ULL, 0x002fe4000001143bULL, 0x0000000142424812ULL, 0x000fca00078efcffULL,
0x0000005c00347306ULL, 0x000e700000205400ULL, 0x0000003500377306ULL, 0x000eb0000020d400ULL,
0x0000003c003b7306ULL, 0x000fe20000009400ULL, 0x000000344100720bULL, 0x002fe20003fdd000ULL,
0x000001003e347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000003c004e7306ULL, 0x000e620000005400ULL, 0x0000000137372812ULL, 0x004fc800078efcffULL,
0x000000371137723eULL, 0x000fc600000010ffULL, 0x0000005c00357306ULL, 0x000ea8000020d400ULL,
0x00000036481c723cULL, 0x000f68000004181cULL, 0x0000003a00587306ULL, 0x000ee2000000d400ULL,
0x0000004e3b00720bULL, 0x002fe20003f5d000ULL, 0x000100003c3b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x00000039003a7306ULL, 0x000fe20000209400ULL,
0x0000000135356812ULL, 0x004fce00078efcffULL, 0x00000039005c7306ULL, 0x000e620000205400ULL,
0x0000000158585812ULL, 0x008fce00078efcffULL, 0x0000006b00207306ULL, 0x000ff00000209400ULL,
0x0000006b00227306ULL, 0x000ea20000205400ULL, 0x0000005c3a00720bULL, 0x002fce0003fbd000ULL,
0x0000003900437306ULL, 0x0002f0000020d400ULL, 0x0000007500677306ULL, 0x000fe20000209400ULL,
0x000001003d397824ULL, 0x002fe200078e00ffULL, 0x000000222000720bULL, 0x004fe20003fdd000ULL,
0x000001003f227824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000075006f7306ULL, 0x000e620000205400ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000000143435812ULL, 0x008fc800078efcffULL, 0x000000431010723eULL, 0x000fe200000010ffULL,
0x0000003d00517306ULL, 0x000ff00000009400ULL, 0x0000003d006e7306ULL, 0x000ea20000005400ULL,
0x0000006f6700720bULL, 0x002fce0003f9d000ULL, 0x0000006b00387306ULL, 0x000e70000020d400ULL,
0x00000039006b7306ULL, 0x000fe20000209400ULL, 0x0000006e5100720bULL, 0x004fce0003fbd000ULL,
0x0000003900717306ULL, 0x000ea20000205400ULL, 0x0000000138386812ULL, 0x002fc800078efcffULL,
0x000000380c11723eULL, 0x000fc600000010ffULL, 0x0000003b006c7306ULL, 0x000fe80000209400ULL,
0x000000104824723cULL, 0x000b680000041824ULL, 0x0000003b00537306ULL, 0x000e620000205400ULL,
0x000000716b00720bULL, 0x004fe40003fdd000ULL, 0x000176c873107811ULL, 0x020fca00078e18ffULL,
0x0000003c004f7306ULL, 0x000eb0000000d400ULL, 0x0000003f00547306ULL, 0x000fe20000009400ULL,
0x000000536c00720bULL, 0x002fe20003f1d000ULL, 0x000100003e537824ULL, 0x000fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000003f00557306ULL, 0x000e620000005400ULL,
0x000000014f4f2812ULL, 0x004fce00078efcffULL, 0x0000007500407306ULL, 0x000eb0000020d400ULL,
0x0000003d003c7306ULL, 0x000ee2000000d400ULL, 0x000000555400720bULL, 0x002fe20003f5d000ULL,
0x000100003f547824ULL, 0x000fcc00078e00ffULL, 0x0000003e00207306ULL, 0x000fe20000009400ULL,
0x0000000140404812ULL, 0x004fce00078efcffULL, 0x0000003e003d7306ULL, 0x000e620000005400ULL,
0x000000013c3c5812ULL, 0x008fe400078efcffULL, 0x0000005a5900720bULL, 0x000fca0003fbd000ULL,
0x0000003900397306ULL, 0x000eb0000020d400ULL, 0x0000003b004e7306ULL, 0x000ee2000020d400ULL,
0x0000003d2000720bULL, 0x002fe40003f9d000ULL, 0x000000010e0e5812ULL, 0x000fca00078efcffULL,
0x0000005200627306ULL, 0x000fe20000209400ULL, 0x0000000139396812ULL, 0x004fce00078efcffULL,
0x0000005200667306ULL, 0x000e620000205400ULL, 0x000000014e4e0812ULL, 0x008fc800078efcffULL,
0x0000004e0b4e723eULL, 0x000fe200000010ffULL, 0x00000002000b7824ULL, 0x000fe400078e00ffULL,
0x00000052003a7306ULL, 0x000ea6000020d400ULL, 0xfffffff80b0c7812ULL, 0x000fca00078ec0ffULL,
0x0000003400567306ULL, 0x000fe20000209400ULL, 0x000000666200720bULL, 0x002fce0003fdd000ULL,
0x00000034005c7306ULL, 0x000e6c0000205400ULL, 0x000000013a3a6812ULL, 0x004fe400078efcffULL,
0x00000034003b7306ULL, 0x000ea2000020d400ULL, 0x0000005e5d00720bULL, 0x000fce0003fdd000ULL,
0x0000002200527306ULL, 0x000fe20000209400ULL, 0x0000005c5600720bULL, 0x002fca0003f1d000ULL,
0x000000014c4c6812ULL, 0x000fe400078efcffULL, 0x0000002200517306ULL, 0x000e6c0000205400ULL,
0x000000013b3b0812ULL, 0x004fe400078efcffULL, 0x0000002200347306ULL, 0x0005f0000020d400ULL,
0x0000003e00417306ULL, 0x000ee2000000d400ULL, 0x000000216122723eULL, 0x004fc400000010ffULL,
0x000000515200720bULL, 0x002fca0003fbd000ULL, 0x000000224820723cULL, 0x000b620000041818ULL,
0x0000003f003d7306ULL, 0x000e6c000000d400ULL, 0x00000018ff1a7819ULL, 0x020fe40000011454ULL,
0x00000053003e7306ULL, 0x000fe20000209400ULL, 0x0000000141414812ULL, 0x008fc400078efcffULL,
0x000000585718723eULL, 0x000fe400000010ffULL, 0x000000423519723eULL, 0x000fe400000010ffULL,
0x0000000134345812ULL, 0x000fe200078efcffULL, 0x00000053003f7306ULL, 0x000ea20000205400ULL,
0x000000013d3d2812ULL, 0x002fc600078efcffULL, 0x000000184844723cULL, 0x000b620000041844ULL,
0x0000003d343d723eULL, 0x000fc600000010ffULL, 0x0000001a001b7306ULL, 0x000fe60000209400ULL,
0x0000004f4018723eULL, 0x020fe400000010ffULL, 0x0000003c3919723eULL, 0x000fe400000010ffULL,
0x0000003a0e4f723eULL, 0x000fe200000010ffULL, 0x0000001a00367306ULL, 0x000e620000205400ULL,
0x0000003f3e00720bULL, 0x004fe40003f1d000ULL, 0x000000413b3c723eULL, 0x000fc600000010ffULL,
0x0000004e4828723cULL, 0x040b640000041828ULL, 0x0000005300537306ULL, 0x000eac000020d400ULL,
0x0000003c482c723cULL, 0x000b64000004182cULL, 0x0000001a00517306ULL, 0x0006e2000020d400ULL,
0x000000361b00720bULL, 0x002fc40003f9d000ULL, 0x0000000153530812ULL, 0x004fc600078efcffULL,
0x000000184818723cULL, 0x008b620000041814ULL, 0x000000535050723eULL, 0x000fce00000010ffULL,
0x0000000151514812ULL, 0x000fc800078efcffULL, 0x000000514c51723eULL, 0x000fce00000010ffULL,
0x000000504830723cULL, 0x000b620000041830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017698000cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0b7224ULL, 0x000fc600078e00ffULL, 0x0000000000147805ULL, 0x020fc80000015200ULL,
0x0000040006177984ULL, 0x000ee40000000800ULL, 0x8000000017ff7812ULL, 0x00afe40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x004fc80000011417ULL, 0x000000350c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x000000020c0c7819ULL, 0x000fc80000001217ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040006177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000105117810ULL, 0x000fe40007ffe0ffULL,
0x0000000302027810ULL, 0x000fe40007ffe0ffULL, 0x000000781100720cULL, 0x000fda0003f06070ULL,
0x0000086000000947ULL, 0x000fea0003800000ULL, 0x00000002050b7810ULL, 0x000fe20007ffe0ffULL,
0x00000020730c7824ULL, 0x004fe400078e00ffULL, 0x000059000f027a24ULL, 0x010fe200078e02ffULL,
0x000000780b00720cULL, 0x000fe20003f06070ULL, 0x00000100110e7824ULL, 0x000fe400078e020cULL,
0x0000004002027824ULL, 0x000fc600078e00ffULL, 0x000000200e0c7812ULL, 0x000fca00078ec0ffULL,
0x00000001770c7824ULL, 0x000fe400078e020cULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000000e700b7217ULL, 0x000fe20007800000ULL, 0x00000010000f7824ULL, 0x000fc800078e00ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0eULL, 0x000000100f0e7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011603ULL, 0x0000000b0e0b7217ULL, 0x000fe40007800000ULL,
0x000000040f107810ULL, 0x040fe40007ffe0ffULL, 0x000000080f147810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x100fe200078e0a0eULL, 0x0000000c0f167810ULL, 0x000fe20007ffe0ffULL,
0x0000000110117824ULL, 0x000fc400078e020eULL, 0x0000000114157824ULL, 0x100fe200078e020eULL,
0x0000000b0f00720cULL, 0x0c0fe20003f86070ULL, 0x000000010f0f7824ULL, 0x000fe200078e020eULL,
0x0000000b1000720cULL, 0x080fe20003f66070ULL, 0x0000000811377824ULL, 0x000fe200078e00ffULL,
0x0000000b1400720cULL, 0x080fe20003f46070ULL, 0x000000010f107824ULL, 0x140fe200078e0203ULL,
0x0000000b1600720cULL, 0x000fe20003f06070ULL, 0x000000080f357824ULL, 0x000fe400078e00ffULL,
0x0000000111147824ULL, 0x000fc400078e0203ULL, 0x0000000116177824ULL, 0x000fe200078e020eULL,
0xfffffff835347812ULL, 0x000fe200078ee210ULL, 0x000000010f0e7824ULL, 0x000fe200078e020cULL,
0xfffffff837367812ULL, 0x000fe200078ee214ULL, 0x0000000111107824ULL, 0x100fe400078e020cULL,
0x00000001150b7824ULL, 0x040fe400078e0203ULL, 0x0000000815387824ULL, 0x040fe400078e00ffULL,
0x0000000115147824ULL, 0x000fc400078e020cULL, 0x0000000117157824ULL, 0x040fe400078e0203ULL,
0x00000008173a7824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000630e0e7212ULL, 0x000fc600078efcffULL,
0x0000000117167824ULL, 0x000fe200078e020cULL, 0xfffffff8380c7812ULL, 0x000fe200078ee20bULL,
0x0000001036377824ULL, 0x000fe200078e0265ULL, 0x00006200020b7a11ULL, 0x000fe200078a38ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0xfffffff83a387812ULL, 0x000fe400078ee215ULL,
0x0000006310107212ULL, 0x000fe200078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000630002357a11ULL, 0x000fe400028f3cffULL, 0x0000000e0b0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000100c397824ULL, 0x000fe200078e0265ULL, 0x0000000b10107210ULL, 0x000fc40007fde0ffULL,
0x0000006314147212ULL, 0x080fe200078efcffULL, 0x000000010f0f7824ULL, 0x100fe200028e0635ULL,
0x0000006316167212ULL, 0x000fe200078efcffULL, 0x0000000111117824ULL, 0x000fe200030e0635ULL,
0x0000000b14147210ULL, 0x080fe40007fbe0ffULL, 0x0000000b16167210ULL, 0x000fe20007fde0ffULL,
0x00000010340b7824ULL, 0x000fe400078e0265ULL, 0x0000000115157824ULL, 0x000fe400028e0635ULL,
0x0000001038657824ULL, 0x000fe200078e0265ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e2000e101c48ULL, 0x0000000117177824ULL, 0x000fc600030e0635ULL,
0x0000000010377faeULL, 0x0003e8000d901c48ULL, 0x0000000014397faeULL, 0x0003e8000d101c48ULL,
0x0000000016657faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010000b7824ULL, 0x000fca00078e00ffULL, 0x000000100b0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000e030e7211ULL, 0x000fc800078fe8ffULL, 0x000000040e0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0b7824ULL, 0x040fe200078e0203ULL, 0x000000080e117810ULL, 0x040fe20007ffe0ffULL,
0x000000080e347824ULL, 0x040fe200078e00ffULL, 0x0000000c0e157810ULL, 0x040fe20007ffe0ffULL,
0x000000010e107824ULL, 0x100fe400078e020cULL, 0x000000010f0e7824ULL, 0x040fe200078e020cULL,
0xfffffff834347812ULL, 0x000fe200078ee20bULL, 0x000000010f0b7824ULL, 0x040fe400078e0203ULL,
0x000000080f367824ULL, 0x000fc400078e00ffULL, 0x0000000111167824ULL, 0x040fe400078e020cULL,
0x00000001110f7824ULL, 0x040fe400078e0203ULL, 0x0000000811387824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000115177824ULL, 0x040fe200078e0203ULL,
0x0000006310107212ULL, 0x000fe200078efcffULL, 0x00000008153a7824ULL, 0x040fe400078e00ffULL,
0x0000000115147824ULL, 0x000fe200078e020cULL, 0xfffffff8360c7812ULL, 0x000fe400078ee20bULL,
0x00006200020b7a11ULL, 0x000fe200078038ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff838367812ULL, 0x000fe400078ee20fULL, 0xfffffff83a387812ULL, 0x000fe200078ee217ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000630002357a11ULL, 0x000fc400000f3cffULL,
0x000000100b107210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000630e0e7212ULL, 0x080fe400078efcffULL, 0x0000006314147212ULL, 0x080fe200078efcffULL,
0x0000000111117824ULL, 0x000fe200000e0635ULL, 0x0000006316167212ULL, 0x000fe200078efcffULL,
0x000000100c377824ULL, 0x100fe200078e0265ULL, 0x0000000e0b0e7210ULL, 0x040fe20007f1e0ffULL,
0x0000001036397824ULL, 0x000fe200078e0265ULL, 0x000000160b167210ULL, 0x000fc40007f5e0ffULL,
0x000000140b147210ULL, 0x000fe20007f7e0ffULL, 0x00000010340b7824ULL, 0x000fe400078e0265ULL,
0x000000010f0f7824ULL, 0x100fe400000e0635ULL, 0x0000000117177824ULL, 0x000fe200010e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100b7faeULL, 0x0003e2000b901c48ULL,
0x0000001038657824ULL, 0x000fe400078e0265ULL, 0x0000000115157824ULL, 0x000fe200018e0635ULL,
0x000000000e377faeULL, 0x0003e8000b901c48ULL, 0x0000000016397faeULL, 0x0003e8000b901c48ULL,
0x0000000014657faeULL, 0x0003e4000b901c48ULL, 0x0000000472027810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff0f7424ULL, 0x002fc400078e00ffULL,
0x000000760200720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001790e7824ULL, 0x000fe400078e0202ULL, 0x00000004ff0f7424ULL, 0x000fc800078e00ffULL,
0x000064000e0e7625ULL, 0x000fcc00078e000fULL, 0x000000080e0f7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008000b7824ULL, 0x000fca00078e00ffULL,
0xfffffff00b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000000b0473c2ULL, 0x000ee200000e0000ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000176a804047890ULL, 0x008fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a8000b107f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176680004167f8cULL, 0x0002a4000c80043fULL,
0x000000ffff0b7224ULL, 0x00cfc400078e0011ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x01766c0004157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410357210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011415ULL,
0x000000350c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x000000020c0c7819ULL, 0x000fc80000001215ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c0004157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001807a0c7811ULL, 0x000fc800078e38ffULL, 0x0000000c740c7210ULL, 0x000fca0007ffe063ULL,
0x017000000c0e7984ULL, 0x000e680000000800ULL, 0x017200000c107984ULL, 0x0004e20000000800ULL,
0x000000070e00720bULL, 0x002fe20003f1d000ULL, 0x0000c5627f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff3c347812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fd200078e0007ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000037a117810ULL, 0x000fe40007ffe0ffULL, 0x000000070e00720bULL, 0x000fe40003f54000ULL,
0x000000001100720cULL, 0x000fe20003f05270ULL, 0x0000c5127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000117806ULL, 0x000fc400010e0100ULL, 0x0000008000638824ULL, 0x000fe200078e0263ULL,
0x000000070e0c7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991011147816ULL, 0x000fe200000000ffULL, 0x0000000174638824ULL, 0x000fca00078e0263ULL,
0x0174000c63008388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000070c077221ULL, 0x002fe20000010100ULL,
0x000000ff11ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL, 0x0000000700167308ULL, 0x000e640000000800ULL,
0x000000160d0d7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe20000011603ULL, 0x0000c4527f007947ULL, 0x000fea000b800000ULL,
0x00001f14163c7589ULL, 0x0002a400000e0000ULL, 0x0000003c20207220ULL, 0x084fe40000410000ULL,
0x0000003c21217220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000003c44447220ULL, 0x080fe40000410000ULL,
0x0000003c45457220ULL, 0x000fc40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c18187220ULL, 0x080fe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c28287220ULL, 0x080fe40000410000ULL,
0x0000003c29297220ULL, 0x000fc40000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0011ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803147811ULL, 0x002fe200078ff0ffULL, 0x0000c3527f007947ULL, 0x000fea000b800000ULL,
0x00001f14163c7589ULL, 0x0002a400000e0000ULL, 0x0000003c22227220ULL, 0x084fe40000410000ULL,
0x0000003c23237220ULL, 0x080fe40000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c46467220ULL, 0x080fe40000410000ULL,
0x0000003c47477220ULL, 0x000fc40000410000ULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe40000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c2b2b7220ULL, 0x000fc40000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000003c2f2f7220ULL, 0x080fe40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff34ff7812ULL, 0x000fe20007806011ULL, 0x00000001ff167424ULL, 0x000fd800078e00ffULL,
0x0000000e0c0e0221ULL, 0x000fe20000010100ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00080308ULL, 0x000e640000000800ULL,
0x0000000810100220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d100d7221ULL, 0x008fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0000000800077824ULL, 0x000fca00078e00ffULL, 0xfffffff007177812ULL, 0x000fca00078ec0ffULL,
0x0176b40017077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014100e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e11ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011414ULL,
0x0000000e07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0614ULL,
0x0000000207077819ULL, 0x000fc8000000120eULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176b40017077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016077816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0700720cULL, 0x000fda0003f65270ULL, 0x0000016000003947ULL, 0x000fea0003800000ULL,
0x00000008ff07723eULL, 0x000fe400000010ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011603ULL,
0x0000541007077816ULL, 0x000fe20000000007ULL, 0x0000bf327f007947ULL, 0x000fea000b800000ULL,
0x00001f0e07097589ULL, 0x0002a400000e0000ULL, 0x000000080e147810ULL, 0x000fe20007ffe0ffULL,
0x0000bf827f007947ULL, 0x000fea000b800000ULL, 0x00001f14070a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100e147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0007ULL, 0x0000d110003d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000c52000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180e147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0007ULL,
0x0000d180003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x0000c4b000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000008007a147824ULL, 0x048fe200078e026dULL, 0x000000037a137810ULL, 0x000fc40007ffe0ffULL,
0x000000006464783bULL, 0x000ee20000004200ULL, 0x000000026a6a7810ULL, 0x000fc60007ffe0ffULL,
0x000000006834783bULL, 0x000ea20000004200ULL, 0x00000018ff077819ULL, 0x00afe20000011464ULL,
0x0000006400167306ULL, 0x000fe20000009400ULL, 0x00000018ff157819ULL, 0x000fe20000011466ULL,
0x00010000665f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fe20000011467ULL,
0x0000010067527824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x004fe40000011436ULL,
0x00000018ff0e7819ULL, 0x000fe20000011465ULL, 0x0000006400417306ULL, 0x000e620000005400ULL,
0x00000018ff3b7819ULL, 0x000fc40000011435ULL, 0x00000018ff627819ULL, 0x000fe40000011452ULL,
0x00000018ff4f7819ULL, 0x000fc60000011437ULL, 0x0000000700107306ULL, 0x000ff00000209400ULL,
0x00000007006c7306ULL, 0x000ea20000205400ULL, 0x000000411600720bULL, 0x002fce0003fdd000ULL,
0x0000000700427306ULL, 0x0002f0000020d400ULL, 0x0000001500127306ULL, 0x000fe20000209400ULL,
0x00000018ff077819ULL, 0x002fe40000011434ULL, 0x0000006c1000720bULL, 0x004fca0003fbd000ULL,
0x00000007003e7306ULL, 0x000ff00000209400ULL, 0x00000007003f7306ULL, 0x000fe20000205400ULL,
0x0000000142425812ULL, 0x008fce00078efcffULL, 0x00000007005e7306ULL, 0x0003f0000020d400ULL,
0x0000001500117306ULL, 0x000fe20000205400ULL, 0x0000010064077824ULL, 0x002fce00078e00ffULL,
0x0000001500567306ULL, 0x0003f0000020d400ULL, 0x0000001700517306ULL, 0x000fe20000209400ULL,
0x00000018ff157819ULL, 0x002fce0000011407ULL, 0x0000001700557306ULL, 0x000ff00000205400ULL,
0x0000001700577306ULL, 0x0003f0000020d400ULL, 0x0000006400387306ULL, 0x0004e2000000d400ULL,
0x0000010065177824ULL, 0x002fca00078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000066006e7306ULL, 0x000fe20000009400ULL, 0x0001000064647824ULL, 0x004fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000066006f7306ULL, 0x000e620000005400ULL,
0x0000000138386812ULL, 0x008fce00078efcffULL, 0x0000001500407306ULL, 0x000ff00000209400ULL,
0x0000001500597306ULL, 0x000ea20000205400ULL, 0x0000006f6e00720bULL, 0x002fce0003fdd000ULL,
0x0000001500077306ULL, 0x0002f0000020d400ULL, 0x0000001700717306ULL, 0x000fe20000209400ULL,
0x0000010066157824ULL, 0x002fe200078e00ffULL, 0x000000594000720bULL, 0x004fc80003f9d000ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001700727306ULL, 0x000e6e0000205400ULL,
0x0000000107074812ULL, 0x008fe200078efcffULL, 0x0000006400587306ULL, 0x000fe60000209400ULL,
0x000000380738723eULL, 0x000fca00000010ffULL, 0x0000006400757306ULL, 0x000ea20000205400ULL,
0x000000727100720bULL, 0x002fce0003f5d000ULL, 0x0000006400507306ULL, 0x0002f0000020d400ULL,
0x0000006500617306ULL, 0x000fe20000009400ULL, 0x00000018ff647819ULL, 0x002fe2000001145fULL,
0x00010000675f7824ULL, 0x000fe200078e00ffULL, 0x000000755800720bULL, 0x004fe20003f1d000ULL,
0x0000010034587824ULL, 0x000fc800078e00ffULL, 0x0000006500637306ULL, 0x000e620000005400ULL,
0x00000018ff747819ULL, 0x000fce0000011458ULL, 0x0000006500397306ULL, 0x000462000000d400ULL,
0x0000000150500812ULL, 0x008fce00078efcffULL, 0x0000004900437306ULL, 0x000fe20000209400ULL,
0x0001000065657824ULL, 0x004fe200078e00ffULL, 0x000000636100720bULL, 0x002fc80003f9d000ULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000049004c7306ULL, 0x000fee0000205400ULL,
0x0000000139394812ULL, 0x000fe200078efcffULL, 0x00000049004b7306ULL, 0x000ff0000020d400ULL,
0x00000015005c7306ULL, 0x000ff00000209400ULL, 0x00000015005b7306ULL, 0x000ff00000205400ULL,
0x0000001500497306ULL, 0x000ff0000020d400ULL, 0x00000066006d7306ULL, 0x0002b0000000d400ULL,
0x0000006400157306ULL, 0x000fe20000209400ULL, 0x00000018ff667819ULL, 0x002fce000001145fULL,
0x0000006400167306ULL, 0x000e620000205400ULL, 0x000000016d6d6812ULL, 0x004fce00078efcffULL,
0x0000000e004e7306ULL, 0x000ff00000209400ULL, 0x0000000e004d7306ULL, 0x000ea20000205400ULL,
0x000000161500720bULL, 0x002fce0003fdd000ULL, 0x0000003b003d7306ULL, 0x000ff00000209400ULL,
0x0000003b003c7306ULL, 0x000fe20000205400ULL, 0x0000004d4e00720bULL, 0x004fce0003fbd000ULL,
0x0000003b005d7306ULL, 0x000ff0000020d400ULL, 0x00000017003b7306ULL, 0x000e70000020d400ULL,
0x0000006500607306ULL, 0x000ff00000209400ULL, 0x00000065005a7306ULL, 0x000ea20000205400ULL,
0x000000013b3b2812ULL, 0x002fc800078efcffULL, 0x000000393b39723eULL, 0x000fc600000010ffULL,
0x0000006200177306ULL, 0x000ff00000209400ULL, 0x0000006200547306ULL, 0x000fe20000205400ULL,
0x0000005a6000720bULL, 0x004fe20003f5d000ULL, 0x00010000345a7824ULL, 0x000fcc00078e00ffULL,
0x0000006200527306ULL, 0x000ff0000020d400ULL, 0x0000006400417306ULL, 0x000e70000020d400ULL,
0x00000066005f7306ULL, 0x000ff00000209400ULL, 0x0000006600627306ULL, 0x000ea20000205400ULL,
0x0000000141416812ULL, 0x002fce00078efcffULL, 0x0000000e00487306ULL, 0x000e70000020d400ULL,
0x0000004f000e7306ULL, 0x000fe20000209400ULL, 0x000000625f00720bULL, 0x004fce0003fdd000ULL,
0x0000004f003a7306ULL, 0x000fe20000205400ULL, 0x0000000148485812ULL, 0x002fe400078efcffULL,
0x000000541700720bULL, 0x000fe20003fbd000ULL, 0x0000010035177824ULL, 0x000fe200078e00ffULL,
0x0000000703547812ULL, 0x000fc600078ec0ffULL, 0x0000004f004a7306ULL, 0x000fe2000020d400ULL,
0x0000000854547812ULL, 0x000fce00078ef803ULL, 0x00000065004f7306ULL, 0x000e62000020d400ULL,
0x0000000152525812ULL, 0x000fe400078efcffULL, 0x000000111200720bULL, 0x000fca0003fbd000ULL,
0x0000006700687306ULL, 0x000ff00000009400ULL, 0x00000067006b7306ULL, 0x000ea20000005400ULL,
0x000000014f4f2812ULL, 0x002fe400078efcffULL, 0x0000005b5c00720bULL, 0x000fc40003f5d000ULL,
0x0000000156565812ULL, 0x000fe400078efcffULL, 0x0000003f3e00720bULL, 0x000fe20003fbd000ULL,
0x0000006600407306ULL, 0x000e62000020d400ULL, 0x000000415656723eULL, 0x000fce00000010ffULL,
0x0000006700537306ULL, 0x000ee2000000d400ULL, 0x0000006b6800720bULL, 0x004fe40003f1d000ULL,
0x00000018ff687819ULL, 0x000fe20000011417ULL, 0x0000000854177824ULL, 0x000fe200078e00ffULL,
0x0000000149492812ULL, 0x000fe400078efcffULL, 0x000000015e5e5812ULL, 0x000fe200078efcffULL,
0x0000003400677306ULL, 0x000fe20000009400ULL, 0x0000000140406812ULL, 0x002fe400078efcffULL,
0x0000003c3d00720bULL, 0x000fe20003fdd000ULL, 0x00000004003c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8176a7812ULL, 0x000fc400078ee26aULL, 0x012800001414783bULL, 0x000e620000000200ULL,
0x00000034006c7306ULL, 0x000ea20000005400ULL, 0x000000043c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000000153530812ULL, 0x008fe400078efcffULL, 0x000000023c3c7812ULL, 0x000fe400078efcffULL,
0x000000555100720bULL, 0x000fe20003f1d000ULL, 0x0000003500107306ULL, 0x000fe20000009400ULL,
0x0000010036517824ULL, 0x000fe200078e00ffULL, 0x0000003a0e00720bULL, 0x000fc40003fbd000ULL,
0x000000015d5d6812ULL, 0x000fe400078efcffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000003500667306ULL, 0x000ee20000005400ULL, 0x0000006c6700720bULL, 0x004fe40003f9d000ULL,
0x00000018ff677819ULL, 0x000fe4000001145aULL, 0x0000000157570812ULL, 0x000fe400078efcffULL,
0x000000014a4a5812ULL, 0x000fe200078efcffULL, 0x0000003500637306ULL, 0x000462000000d400ULL,
0x000000405757723eULL, 0x000fc400000010ffULL, 0x000000661000720bULL, 0x008fe20003f5d000ULL,
0x0001000035357824ULL, 0x004fc800078e00ffULL, 0x0000007400587306ULL, 0x000fe20000209400ULL,
0x0000008013107824ULL, 0x000fe200078e026aULL, 0x00000008036a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000000091414b231ULL, 0x082fe200003400ffULL,
0x000000076a6a7812ULL, 0x000fe200078ef803ULL, 0x000000091616b231ULL, 0x000fe200003400ffULL,
0x0000003500547306ULL, 0x000fe20000209400ULL, 0x0001100010107811ULL, 0x000fe200078e20ffULL,
0x0000000a1515b231ULL, 0x080fe200003400ffULL, 0x000000086a3d7824ULL, 0x000fe200078e00ffULL,
0x0000000163632812ULL, 0x000fe200078efcffULL, 0x0000000a1717b231ULL, 0x000fc400003400ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x00000035006c7306ULL, 0x000fe80000205400ULL,
0x000000381438723cULL, 0x040b680000041820ULL, 0x0000003500627306ULL, 0x0005e6000020d400ULL,
0x000000504220723eULL, 0x020fe200000010ffULL, 0x000000561424723cULL, 0x000fe20000041824ULL,
0x0000004f4821723eULL, 0x000fc600000010ffULL, 0x0000007400597306ULL, 0x000ee20000205400ULL,
0x0000010037357824ULL, 0x004fc600078e00ffULL, 0x00000020141c723cULL, 0x000b64000004181cULL,
0x00000018ff6b7819ULL, 0x000fe40000011435ULL, 0x0000003c03357211ULL, 0x000fe200078fe0ffULL,
0x00000067005a7306ULL, 0x000fe40000209400ULL, 0x0000006d4920723eULL, 0x020fe400000010ffULL,
0x000000016a3c7824ULL, 0x040fe200078e0235ULL, 0x000000106a6a7812ULL, 0x000fc400078efcffULL,
0x000000595800720bULL, 0x008fe20003f1d000ULL, 0x0000006700607306ULL, 0x000ea20000205400ULL,
0xfffffff83d3c7812ULL, 0x000fe200078ee23cULL, 0x000000016a357824ULL, 0x000fe200078e0235ULL,
0x000000535221723eULL, 0x000fc600000010ffULL, 0x000000103c3c7824ULL, 0x000fe200078e0269ULL,
0x000000091010b231ULL, 0x082fe200003400ffULL, 0x0000006700617306ULL, 0x000e62000020d400ULL,
0x000000091212b231ULL, 0x000fe400003400ffULL, 0x0000000a1111b231ULL, 0x080fe200003400ffULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x0000000a1313b231ULL, 0x000fc600003400ffULL,
0x00000068005b7306ULL, 0x000fe20000209400ULL, 0x000000605a00720bULL, 0x004fce0003f7d000ULL,
0x00000068005c7306ULL, 0x000eac0000205400ULL, 0x0000000161613812ULL, 0x002fe400078efcffULL,
0x0000006800667306ULL, 0x000e62000020d400ULL, 0x0000004c4300720bULL, 0x000fce0003f7d000ULL,
0x0000007400647306ULL, 0x000e62000020d400ULL, 0x0000005c5b00720bULL, 0x004fca0003f5d000ULL,
0x000000014b4b3812ULL, 0x000fe400078efcffULL, 0x0000003400657306ULL, 0x000ea2000000d400ULL,
0x000001003c567824ULL, 0x008fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc8000001143eULL,
0x0000000166662812ULL, 0x002fe400078efcffULL, 0x0000005100677306ULL, 0x000fe20000209400ULL,
0x0000000164640812ULL, 0x000fe400078efcffULL, 0x0000006c5400720bULL, 0x000fe40003f5d000ULL,
0x00000018ff6c7819ULL, 0x000fe40000011456ULL, 0x000000636657723eULL, 0x000fe200000010ffULL,
0x0000005100687306ULL, 0x000e620000205400ULL, 0x0000000165654812ULL, 0x004fe200078efcffULL,
0x000001003d667824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc4000001143dULL,
0x000000656456723eULL, 0x000fe400000010ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000005100597306ULL, 0x000ea2000020d400ULL, 0x0000000162622812ULL, 0x000fe400078efcffULL,
0x00000018ff487819ULL, 0x000fe2000001143fULL, 0x000000561038723cULL, 0x000be80000041838ULL,
0x0000003700347306ULL, 0x000fe20000009400ULL, 0x000000686700720bULL, 0x002fc40003f5d000ULL,
0x000000615e56723eULL, 0x020fe400000010ffULL, 0x000000625d57723eULL, 0x000fc600000010ffULL,
0x0000003700517306ULL, 0x000e680000005400ULL, 0x00000056101c723cULL, 0x000fe4000004181cULL,
0x0000000159592812ULL, 0x004fe400078efcffULL, 0x00000036004e7306ULL, 0x000ff00000009400ULL,
0x00000036004d7306ULL, 0x000ea20000005400ULL, 0x000000513400720bULL, 0x002fe20003f1d000ULL,
0x0001000037347824ULL, 0x000fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011434ULL,
0x000000086a347824ULL, 0x000fe200078e00ffULL, 0x0000006b005f7306ULL, 0x000fe80000209400ULL,
0xfffffff834347812ULL, 0x000fe400078ee235ULL, 0x0000004d4e00720bULL, 0x004fe40003f9d000ULL,
0x0000006b00607306ULL, 0x000e620000205400ULL, 0x00010000364d7824ULL, 0x000fc400078e00ffULL,
0x0000001034347824ULL, 0x000fc600078e0269ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144dULL,
0x0000003600587306ULL, 0x000eb0000000d400ULL, 0x00000037005a7306ULL, 0x0006a2000000d400ULL,
0x000000605f00720bULL, 0x002fe20003fdd000ULL, 0x000100003c607824ULL, 0x000fcc00078e00ffULL,
0x0000005100727306ULL, 0x000fe20000209400ULL, 0x000000003434783bULL, 0x008e620000004200ULL,
0x0000000158584812ULL, 0x004fc800078efcffULL, 0x000000585958723eULL, 0x000fe400000010ffULL,
0x0000005100717306ULL, 0x000ea20000205400ULL, 0x000000015a5a0812ULL, 0x000fce00078efcffULL,
0x0000006b00557306ULL, 0x000ef0000020d400ULL, 0x0000004e006f7306ULL, 0x000fe20000209400ULL,
0x000000717200720bULL, 0x004fce0003f1d000ULL, 0x0000004e006e7306ULL, 0x000ea20000205400ULL,
0x0000000155556812ULL, 0x008fc800078efcffULL, 0x0000005a5559723eULL, 0x000fc600000010ffULL,
0x0000006c00677306ULL, 0x000fe20000209400ULL, 0x00000018ff6d7819ULL, 0x002fe40000011435ULL,
0x00000018ff747819ULL, 0x000fe40000011434ULL, 0x00000018ff757819ULL, 0x000fe40000011436ULL,
0x00000018ff407819ULL, 0x000fe20000011437ULL, 0x0000006c00687306ULL, 0x000e620000205400ULL,
0x0000006e6f00720bULL, 0x004fe40003f9d000ULL, 0x00000018ff6e7819ULL, 0x000fca0000011460ULL,
0x0000004e004d7306ULL, 0x0004f0000020d400ULL, 0x00000051004c7306ULL, 0x000ee2000020d400ULL,
0x00000018ff4e7819ULL, 0x004fe4000001143cULL, 0x000000686700720bULL, 0x002fca0003fdd000ULL,
0x0000004e006b7306ULL, 0x000fe20000209400ULL, 0x000000014d4d4812ULL, 0x008fce00078efcffULL,
0x0000004e006a7306ULL, 0x000e620000205400ULL, 0x000000014c4c0812ULL, 0x000fce00078efcffULL,
0x0000004e00077306ULL, 0x000eb0000020d400ULL, 0x0000002200517306ULL, 0x000fe20000209400ULL,
0x0000006a6b00720bULL, 0x002fce0003f9d000ULL, 0x00000022004e7306ULL, 0x000fec0000205400ULL,
0x0000000107074812ULL, 0x004fe400078efcffULL, 0x0000002200427306ULL, 0x0003f0000020d400ULL,
0x0000006c00637306ULL, 0x000ea2000020d400ULL, 0x000000201420723cULL, 0x002f6e0000041844ULL,
0x0000003c005e7306ULL, 0x000ff00000009400ULL, 0x0000003c00617306ULL, 0x000e620000005400ULL,
0x0000000163636812ULL, 0x004fce00078efcffULL, 0x0000003d005f7306ULL, 0x000fe20000009400ULL,
0x000000581020723cULL, 0x020bee0000041820ULL, 0x0000003d00567306ULL, 0x000ea20000005400ULL,
0x000000615e00720bULL, 0x002fe20003f1d000ULL, 0x000100003f617824ULL, 0x000fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000006600647306ULL, 0x000ff00000209400ULL,
0x0000006600657306ULL, 0x000e620000205400ULL, 0x000000565f00720bULL, 0x004fe20003f5d000ULL,
0x000100003e567824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000003c005d7306ULL, 0x0004f0000000d400ULL, 0x0000004300697306ULL, 0x000fe20000209400ULL,
0x000100003d3c7824ULL, 0x004fe200078e00ffULL, 0x000000656400720bULL, 0x002fc80003fdd000ULL,
0x00000018ff6f7819ULL, 0x000fe2000001143cULL, 0x000001003e3c7824ULL, 0x000fe200078e00ffULL,
0x00000043000e7306ULL, 0x000e620000205400ULL, 0x000000015d5d0812ULL, 0x008fc600078efcffULL,
0x00000018ff727819ULL, 0x000fe4000001143cULL, 0x0000004d4b3c723eULL, 0x000fe400000010ffULL,
0x0000006600667306ULL, 0x000eb0000020d400ULL, 0x0000006f00557306ULL, 0x000fe20000209400ULL,
0x0000000e6900720bULL, 0x002fe20003f9d000ULL, 0x00000100360e7824ULL, 0x000fcc00078e00ffULL,
0x0000006f005a7306ULL, 0x000e620000205400ULL, 0x0000000166666812ULL, 0x004fce00078efcffULL,
0x0000006e00607306ULL, 0x000ff00000209400ULL, 0x0000006e00627306ULL, 0x000ea20000205400ULL,
0x0000005a5500720bULL, 0x002fce0003fdd000ULL, 0x0000006e006c7306ULL, 0x000e70000020d400ULL,
0x0000003d00577306ULL, 0x000662000000d400ULL, 0x000000626000720bULL, 0x004fe20003f1d000ULL,
0x0001000034627824ULL, 0x000fca00078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x0000003e006e7306ULL, 0x000fe20000009400ULL, 0x0000004c4a3d723eULL, 0x008fe200000010ffULL,
0x000001003f4a7824ULL, 0x000fc800078e00ffULL, 0x000000016c6c0812ULL, 0x002fe400078efcffULL,
0x0000003e00717306ULL, 0x000e620000005400ULL, 0x0000003c1024723cULL, 0x000be20000041824ULL,
0x0000000157572812ULL, 0x000fcc00078efcffULL, 0x0000003f005e7306ULL, 0x000ff00000009400ULL,
0x0000003f005f7306ULL, 0x000ea20000005400ULL, 0x000000716e00720bULL, 0x002fce0003f7d000ULL,
0x0000006f00587306ULL, 0x0202f0000020d400ULL, 0x0000004300437306ULL, 0x000ee2000020d400ULL,
0x00000018ff6f7819ULL, 0x002fe4000001144aULL, 0x0000005f5e00720bULL, 0x004fe20003fbd000ULL,
0x00000100345f7824ULL, 0x000fc800078e00ffULL, 0x0000006d00527306ULL, 0x000fe20000209400ULL,
0x0000000158586812ULL, 0x008fe400078efcffULL, 0x00000018ff687819ULL, 0x000fca000001145fULL,
0x0000006d00537306ULL, 0x000fe20000205400ULL, 0x0000000143434812ULL, 0x000fce00078efcffULL,
0x0000006d00447306ULL, 0x000ff0000020d400ULL, 0x0000006f004c7306ULL, 0x000ff00000209400ULL,
0x0000006f004d7306ULL, 0x000e700000205400ULL, 0x00000072006d7306ULL, 0x000ff00000209400ULL,
0x0000007200597306ULL, 0x000ea20000205400ULL, 0x0000004d4c00720bULL, 0x002fce0003f9d000ULL,
0x0000003f003d7306ULL, 0x000e70000000d400ULL, 0x00000061003f7306ULL, 0x000fe20000209400ULL,
0x000000596d00720bULL, 0x004fce0003fdd000ULL, 0x00000061006e7306ULL, 0x000fe20000205400ULL,
0x000000013d3d5812ULL, 0x002fce00078efcffULL, 0x00000061005e7306ULL, 0x000ff0000020d400ULL,
0x0000003500617306ULL, 0x000ff00000009400ULL, 0x00000035005a7306ULL, 0x000e700000005400ULL,
0x0000006f004a7306ULL, 0x000eb0000020d400ULL, 0x0000003400647306ULL, 0x000fe20000009400ULL,
0x0000005a6100720bULL, 0x002fe20003f1d000ULL, 0x0001000035617824ULL, 0x000fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000003400657306ULL, 0x000e620000005400ULL,
0x000000014a4a4812ULL, 0x004fe400078efcffULL, 0x0000006e3f00720bULL, 0x000fe40003f9d000ULL,
0x0000003d4a3d723eULL, 0x000fc600000010ffULL, 0x00000072004b7306ULL, 0x000eb0000020d400ULL,
0x0000003e003c7306ULL, 0x000ee2000000d400ULL, 0x000000656400720bULL, 0x002fe40003f5d000ULL,
0x000000015e5e4812ULL, 0x000fca00078efcffULL, 0x00000056006f7306ULL, 0x000fe20000209400ULL,
0x000000014b4b6812ULL, 0x004fce00078efcffULL, 0x0000005600717306ULL, 0x000e620000205400ULL,
0x000000013c3c3812ULL, 0x008fe400078efcffULL, 0x0000004e5100720bULL, 0x000fe40003f7d000ULL,
0x0000003c4b3c723eULL, 0x000fc600000010ffULL, 0x0000004800507306ULL, 0x000ff00000209400ULL,
0x00000048004f7306ULL, 0x000ea20000205400ULL, 0x000000716f00720bULL, 0x002fe40003fdd000ULL,
0x0000000142423812ULL, 0x000fca00078efcffULL, 0x00000056003e7306ULL, 0x0002f0000020d400ULL,
0x00000074005c7306ULL, 0x000fe20000209400ULL, 0x0000010035567824ULL, 0x002fe200078e00ffULL,
0x0000004f5000720bULL, 0x004fe20003fbd000ULL, 0x0001000036507824ULL, 0x000fca00078e00ffULL,
0x00000074005b7306ULL, 0x000fe20000205400ULL, 0x000000013e3e6812ULL, 0x008fe400078efcffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000003e4242723eULL, 0x000fc600000010ffULL,
0x0000007400497306ULL, 0x0003f0000020d400ULL, 0x0000003500557306ULL, 0x0004e2000000d400ULL,
0x00000018ff747819ULL, 0x002fce0000011456ULL, 0x0000007500477306ULL, 0x000fe20000209400ULL,
0x00000018ff357819ULL, 0x004fe2000001140eULL, 0x00000100370e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001140eULL, 0x0000007500547306ULL, 0x000fe20000205400ULL,
0x0000000155550812ULL, 0x008fe400078efcffULL, 0x000000535200720bULL, 0x000fca0003f1d000ULL,
0x0000007500417306ULL, 0x000ff0000020d400ULL, 0x00000074006a7306ULL, 0x000fe20000209400ULL,
0x0000000144440812ULL, 0x000fce00078efcffULL, 0x00000074006b7306ULL, 0x000e700000205400ULL,
0x0000007400567306ULL, 0x000eb0000020d400ULL, 0x0000003400607306ULL, 0x000ee2000000d400ULL,
0x0000006b6a00720bULL, 0x002fce0003f7d000ULL, 0x0000006800727306ULL, 0x000fec0000209400ULL,
0x0000000156563812ULL, 0x004fe400078efcffULL, 0x0000006800677306ULL, 0x000e620000205400ULL,
0x0000000160602812ULL, 0x008fce00078efcffULL, 0x0000006200747306ULL, 0x000ff00000209400ULL,
0x0000006200757306ULL, 0x000ea20000205400ULL, 0x000000677200720bULL, 0x002fce0003fdd000ULL,
0x0000004800487306ULL, 0x000e70000020d400ULL, 0x0000003500647306ULL, 0x000fe20000209400ULL,
0x000000757400720bULL, 0x004fce0003f5d000ULL, 0x0000003500657306ULL, 0x000fe20000205400ULL,
0x0000000148485812ULL, 0x002fce00078efcffULL, 0x00000035004c7306ULL, 0x000ff0000020d400ULL,
0x0000003600347306ULL, 0x000ff00000009400ULL, 0x0000003600357306ULL, 0x000e700000005400ULL,
0x00000037003f7306ULL, 0x000ff00000009400ULL, 0x00000037006e7306ULL, 0x000ea20000005400ULL,
0x000000353400720bULL, 0x002fc40003f9d000ULL, 0x0000005d6334723eULL, 0x000fe400000010ffULL,
0x000000576635723eULL, 0x000fc600000010ffULL, 0x00000068005f7306ULL, 0x000e68000020d400ULL,
0x000000341418723cULL, 0x000fe80000041818ULL, 0x00000062005a7306ULL, 0x000ee2000020d400ULL,
0x0000006e3f00720bULL, 0x004fe20003fbd000ULL, 0x00010000373f7824ULL, 0x000fcc00078e00ffULL,
0x0000006100687306ULL, 0x000fe20000209400ULL, 0x000000015f5f6812ULL, 0x002fe400078efcffULL,
0x0000005b5c00720bULL, 0x000fca0003fdd000ULL, 0x0000006100697306ULL, 0x000e620000205400ULL,
0x000000015a5a2812ULL, 0x008fe400078efcffULL, 0x000000656400720bULL, 0x000fca0003f5d000ULL,
0x0000006100597306ULL, 0x000ea2000020d400ULL, 0x0000000149496812ULL, 0x000fe400078efcffULL,
0x000000544700720bULL, 0x000fca0003fdd000ULL, 0x0000004d00617306ULL, 0x000fe20000209400ULL,
0x000000696800720bULL, 0x002fe40003f7d000ULL, 0x000000014c4c2812ULL, 0x000fca00078efcffULL,
0x0000004d00627306ULL, 0x000e620000205400ULL, 0x0000000141416812ULL, 0x000fca00078efcffULL,
0x0000000159593812ULL, 0x004fe400078efcffULL, 0x0000004d000e7306ULL, 0x000eb0000020d400ULL,
0x00000036004e7306ULL, 0x0006a2000000d400ULL, 0x000000626100720bULL, 0x002fce0003f1d000ULL,
0x00000037004d7306ULL, 0x000262000000d400ULL, 0x0000006c0736723eULL, 0x008fe400000010ffULL,
0x00000018ff077819ULL, 0x000fe4000001143fULL, 0x0000003c143c723cULL, 0x000b62000004182cULL,
0x000000010e0e0812ULL, 0x004fe400078efcffULL, 0x0000004000457306ULL, 0x000fe20000209400ULL,
0x000000584337723eULL, 0x002fe400000010ffULL, 0x0000005e4843723eULL, 0x000fc400000010ffULL,
0x000000014e4e4812ULL, 0x000fe400078efcffULL, 0x0000005a492c723eULL, 0x020fe200000010ffULL,
0x000000361434723cULL, 0x040b620000041828ULL, 0x0000004000467306ULL, 0x000e620000205400ULL,
0x000000014d4d5812ULL, 0x000fe400078efcffULL, 0x00000059442d723eULL, 0x000fe400000010ffULL,
0x0000004e4c4c723eULL, 0x000fe400000010ffULL, 0x000000421414723cULL, 0x000f620000041830ULL,
0x00000050004f7306ULL, 0x000fe20000209400ULL, 0x000000605f28723eULL, 0x020fc400000010ffULL,
0x000000555629723eULL, 0x000fe400000010ffULL, 0x0000004d0e4d723eULL, 0x000fc600000010ffULL,
0x0000005000517306ULL, 0x000ea20000205400ULL, 0x000000464500720bULL, 0x002fc60003f7d000ULL,
0x0000004c1030723cULL, 0x040f68000004183cULL, 0x0000000700577306ULL, 0x000fe80000209400ULL,
0x0000002c102c723cULL, 0x000f680000041834ULL, 0x00000007002a7306ULL, 0x000e620000205400ULL,
0x000000514f00720bULL, 0x004fce0003f5d000ULL, 0x0000004000407306ULL, 0x000eb0000020d400ULL,
0x0000005000507306ULL, 0x000ee2000020d400ULL, 0x0000002a5700720bULL, 0x002fe40003f9d000ULL,
0x000000281028723cULL, 0x000b6a0000041818ULL, 0x0000000700077306ULL, 0x000e62000020d400ULL,
0x0000000140403812ULL, 0x004fc400078efcffULL, 0x0000000150502812ULL, 0x008fc800078efcffULL,
0x000000504118723eULL, 0x020fe400000010ffULL, 0x0000000107074812ULL, 0x002fc800078efcffULL,
0x000000074019723eULL, 0x000fce00000010ffULL, 0x000000181018723cULL, 0x000b620000041814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000006067f8cULL, 0x000e62000c80043fULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000176a07a107811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000010ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0e7224ULL, 0x002fe200078e0007ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff25f000007947ULL, 0x000fea000383ffffULL, 0x000000ff7800720cULL, 0x008fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000000d027810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000f1a000057802ULL, 0x002fc40000000f00ULL, 0x0000a2c000007944ULL, 0x014fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000d00047308ULL, 0x000ee40000001000ULL,
0xbf80000004027423ULL, 0x008fc8000000000dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x000ee8000c1e9900ULL, 0x0000000000057919ULL, 0x002e680000000000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000808057811ULL, 0x004fe200078ff0ffULL, 0x0000000403067220ULL, 0x008fca0000410000ULL,
0x00001f0706047589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea200000e0000ULL,
0x0000003804387220ULL, 0x042fe40000410000ULL, 0x0000003904397220ULL, 0x040fe40000410000ULL,
0x0000001c041c7220ULL, 0x040fe40000410000ULL, 0x0000001d041d7220ULL, 0x000fc40000410000ULL,
0x0000002004207220ULL, 0x040fe40000410000ULL, 0x0000002104217220ULL, 0x040fe40000410000ULL,
0x0000002404247220ULL, 0x040fe40000410000ULL, 0x0000002504257220ULL, 0x040fe40000410000ULL,
0x0000002804287220ULL, 0x040fe40000410000ULL, 0x0000002904297220ULL, 0x000fc40000410000ULL,
0x0000002c042c7220ULL, 0x040fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000003004307220ULL, 0x040fe40000410000ULL, 0x0000003104317220ULL, 0x040fe40000410000ULL,
0x0000001804187220ULL, 0x040fe40000410000ULL, 0x0000001904197220ULL, 0x000fc40000410000ULL,
0x0000003a053a7220ULL, 0x044fe40000410000ULL, 0x0000003b053b7220ULL, 0x040fe40000410000ULL,
0x0000001e051e7220ULL, 0x040fe40000410000ULL, 0x0000001f051f7220ULL, 0x040fe40000410000ULL,
0x0000002205227220ULL, 0x040fe40000410000ULL, 0x0000002305237220ULL, 0x000fc40000410000ULL,
0x0000002605267220ULL, 0x040fe40000410000ULL, 0x0000002705277220ULL, 0x040fe40000410000ULL,
0x0000002a052a7220ULL, 0x040fe40000410000ULL, 0x0000002b052b7220ULL, 0x040fe40000410000ULL,
0x0000002e052e7220ULL, 0x040fe40000410000ULL, 0x0000002f052f7220ULL, 0x000fc40000410000ULL,
0x0000003205327220ULL, 0x040fe40000410000ULL, 0x0000003305337220ULL, 0x040fe40000410000ULL,
0x0000001a051a7220ULL, 0x040fe40000410000ULL, 0x0000001b051b7220ULL, 0x000fc40000410000ULL,
0x0000000000037919ULL, 0x000ee20000000000ULL, 0x0000100000067824ULL, 0x000fe200078e00ffULL,
0x0000002c2d2c723eULL, 0x000fe200000010ffULL, 0x0000002073167824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000303130723eULL, 0x000fc400000010ffULL,
0x000000181918723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x000000262711723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x0000002e2f15723eULL, 0x000fe400000010ffULL, 0x000000323332723eULL, 0x000fc400000010ffULL,
0x00000002ff077819ULL, 0x008fe40000011603ULL, 0x0000000203027812ULL, 0x040fe400078ec0ffULL,
0x0000000803097811ULL, 0x002fe200078ff0ffULL, 0x00000008070a7824ULL, 0x044fe200078e00ffULL,
0x0000000702047211ULL, 0x040fe200078ff8ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000809087824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fe20007ffe0ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x000054102a147816ULL, 0x000fc40000000015ULL, 0xfffffff8080f7812ULL, 0x010fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe400078ee202ULL,
0x0000100006027812ULL, 0x000fe200078ee2ffULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x0000000404077810ULL, 0x040fe40007ffe0ffULL, 0x0000000604087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff805057812ULL, 0x000fe200078ee204ULL, 0x0000080073047824ULL, 0x000fe200078e0202ULL,
0xfffffff80a0b7812ULL, 0x000fc400078ee207ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL,
0x000000100f107824ULL, 0x100fe200078e0204ULL, 0x0000000806077812ULL, 0x000fe200078ec0ffULL,
0x0000001005067824ULL, 0x100fe200078e0204ULL, 0x0000001c1d05723eULL, 0x000fe200000010ffULL,
0x00000010090a7824ULL, 0x100fe200078e0204ULL, 0x000076322a157816ULL, 0x000fe20000000015ULL,
0x000000100b0c7824ULL, 0x100fe200078e0204ULL, 0x0000001a1b19723eULL, 0x000fe200000010ffULL,
0x000000100d0e7824ULL, 0x000fe200078e0204ULL, 0x000000383904723eULL, 0x000fe200000010ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000282906723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x0000541004127816ULL, 0x140fe20000000005ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x0000763204137816ULL, 0x000fe20000000005ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000202104723eULL, 0x000fe200000010ffULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x000000242505723eULL, 0x000fe200000010ffULL,
0x0000001208007388ULL, 0x0003e20000000a00ULL, 0x0000763230077816ULL, 0x000fc40000000018ULL,
0x0000763204097816ULL, 0x000fe40000000005ULL, 0x00007632320d7816ULL, 0x000fe40000000019ULL,
0x0000541004087816ULL, 0x002fe40000000005ULL, 0x0000003a3b04723eULL, 0x000fe400000010ffULL,
0x0000001e1f05723eULL, 0x000fe200000010ffULL, 0x000000080a007388ULL, 0x0003e40000000a00ULL,
0x0000541006087816ULL, 0x002fc4000000002cULL, 0x0000763206097816ULL, 0x000fe4000000002cULL,
0x0000541030067816ULL, 0x000fc60000000018ULL, 0x000000080c007388ULL, 0x000fe80000000a00ULL,
0x000000060e007388ULL, 0x0003e40000000a00ULL, 0x0000541004067816ULL, 0x142fe40000000005ULL,
0x0000763204077816ULL, 0x000fe20000000005ULL, 0x0000000116057824ULL, 0x000fe200078e0203ULL,
0x000000ff00047306ULL, 0x000fe60000205400ULL, 0x0000000610007388ULL, 0x0003e40000000a00ULL,
0x0000541022107816ULL, 0x142fe20000000011ULL, 0x0000001005077824ULL, 0x000fe200078e0202ULL,
0x0000763222117816ULL, 0x000fe20000000011ULL, 0x000000ff00057306ULL, 0x000e680000209400ULL,
0x000400100a007388ULL, 0x000fe80000000a00ULL, 0x000400140c007388ULL, 0x0005e20000000a00ULL,
0x000000ff00067306ULL, 0x000ee2000020d400ULL, 0x000000040500720bULL, 0x002fc40003f1d000ULL,
0x00005410320c7816ULL, 0x004fca0000000019ULL, 0x0004000c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000106060812ULL, 0x008fc400078efcffULL, 0x000000ff7300720cULL, 0x000fe20003f05270ULL,
0x0004000007147984ULL, 0x000ea20000000c00ULL, 0x000000060604723eULL, 0x000fc600000010ffULL,
0x0008000007107984ULL, 0x000ee80000000c00ULL, 0x000c000007187984ULL, 0x000ee20000000c00ULL,
0x3f803f80040b7831ULL, 0x042fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fc40000200008ULL,
0x3f803f8004177831ULL, 0x044fe40000200017ULL, 0x3f803f8004167831ULL, 0x040fe40000200016ULL,
0x3f803f8004157831ULL, 0x040fe40000200015ULL, 0x3f803f8004147831ULL, 0x000fe40000200014ULL,
0x3f803f800b0b7831ULL, 0x008fe40000200013ULL, 0x3f803f800a0a7831ULL, 0x000fc40000200012ULL,
0x3f803f8009097831ULL, 0x000fe40000200011ULL, 0x3f803f8008087831ULL, 0x000fe40000200010ULL,
0x3f803f8017177831ULL, 0x000fe4000020001bULL, 0x3f803f8016167831ULL, 0x000fe2000020001aULL,
0x0000000807007388ULL, 0x000fe20000000c00ULL, 0x3f803f8015157831ULL, 0x000fe40000200019ULL,
0x3f803f8014147831ULL, 0x000fca0000200018ULL, 0x0004001407007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x000fc80000011603ULL, 0x0000007c0600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x100fe200078e0203ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005900ff1c7624ULL, 0x000fe200078e00ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00005a007b7b7a19ULL, 0x000fe400000006ffULL, 0x0ffffff804057812ULL, 0x000fe200078ef803ULL,
0x000000107d047824ULL, 0x000fe200078e0206ULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00005a001c1c7a19ULL, 0x000fc400000006ffULL, 0x0000001005057824ULL, 0x000fe200078e0202ULL,
0x0000000504067c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff047a19ULL, 0x000fe40000011604ULL,
0x0000000005087984ULL, 0x0004e20000000c00ULL, 0x000000017b077824ULL, 0x000fe200078e0206ULL,
0x00000001000f7812ULL, 0x000fe400078ec0ffULL, 0x0000002003007810ULL, 0x040fe20007ffe0ffULL,
0x0000001c04077224ULL, 0x000fe200078e0207ULL, 0x00000006040472a4ULL, 0x002fe2000f8e023fULL,
0x00000007030e7812ULL, 0x000fc400078ec0ffULL, 0x00000003ff0d7819ULL, 0x000fc60000011600ULL,
0x000000041c067c24ULL, 0x000fca000f8e02ffULL, 0x0000000706077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0007047a11ULL, 0x000fc800078040ffULL,
0x00005d0007057a11ULL, 0x004fe200000f440cULL, 0x000000080f077824ULL, 0x000fe200078e020eULL,
0x0000007c0d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0083ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000100047824ULL, 0x102fe200078e020dULL, 0x00000040030c7810ULL, 0x000fe20007ffe0ffULL,
0x000000107d0d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x000000050d047c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef800ULL,
0x00005a00ff0d7a19ULL, 0x000fe2000001160dULL, 0x000000017b047824ULL, 0x000fe200078e0204ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000001005077824ULL, 0x000fe400078e0202ULL,
0x0000001c0d0d7224ULL, 0x000fc600078e0204ULL, 0x0000000007087984ULL, 0x0002a40000000c00ULL,
0x0000000d060d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000d047a11ULL, 0x000fe200078040ffULL, 0x000000080f077824ULL, 0x002fc600078e0200ULL,
0x00005d000d057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0d7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000007c0d00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c007824ULL, 0x100fe200078e020dULL, 0x0000006003077810ULL, 0x000fe20007ffe0ffULL,
0x000000107d0d7824ULL, 0x000fc600078e020dULL, 0x0000000700057812ULL, 0x002fe400078ec0ffULL,
0x000000050d047c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x00005a00ff0d7a19ULL, 0x000fe2000001160dULL, 0x000000017b047824ULL, 0x000fe200078e0204ULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000001005007824ULL, 0x000fe400078e0202ULL,
0x0000001c0d0d7224ULL, 0x000fc400078e0204ULL, 0x000000080f037824ULL, 0x000fe200078e020cULL,
0x0000000000087984ULL, 0x0002a40000000c00ULL, 0x0000000d060d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000d047a11ULL, 0x040fe400078040ffULL,
0x00000003ff007819ULL, 0x002fe40000011607ULL, 0x00005d000d057a11ULL, 0x000fe400000f440eULL,
0x0000007c0000720cULL, 0x000fe20003f06070ULL, 0x00000001070c7824ULL, 0x000fe400078e0200ULL,
0x0000001003047825ULL, 0x000fc600078e0004ULL, 0x000000070c0c7812ULL, 0x000fc800078ec0ffULL,
0xfffffff80c037812ULL, 0x000fe200078ef807ULL, 0x0000000804007986ULL, 0x0043e4000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x002fe200078e0202ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x000000107d007824ULL, 0x000fc600078e0200ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x000000080f077824ULL, 0x000fe200078e0207ULL,
0x0000000500027c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff007a19ULL, 0x000fc60000011600ULL,
0x000000017b037824ULL, 0x000fc800078e0202ULL, 0x0000001c00037224ULL, 0x000fca00078e0203ULL,
0x0000000306037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000760000720cULL, 0x000fe20003f06070ULL,
0xffffffffff0f7424ULL, 0x000fd800078e00ffULL, 0x0000000206058824ULL, 0x000fc800078e00ffULL,
0x00006800050a8a24ULL, 0x000fc800078e0200ULL, 0x000064000a0a8625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff0c7624ULL, 0x000fe200078e00ffULL,
0x000000080a0f8981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff0d7624ULL, 0x000fc600078e00ffULL,
0x01760000ff047f8cULL, 0x000ee8000c80043fULL, 0x000000080c097981ULL, 0x002322000c1e9900ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x000000400e7c7824ULL, 0x000fe400078e00ffULL,
0x0000004000797824ULL, 0x000fe400078e00ffULL, 0x000000407b027824ULL, 0x000fc400078e00ffULL,
0x0000000f7c127224ULL, 0x004fcc00078e02ffULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x00000079700a7217ULL, 0x00afe40007800000ULL, 0x00000003ff1a7819ULL, 0x000fe40000011603ULL,
0x0000620012137a11ULL, 0x000fe200078438ffULL, 0x000000010a177824ULL, 0x000fe200078e0a79ULL,
0x000000041a0c7810ULL, 0x040fe20007ffe0ffULL, 0x000000407b7b7824ULL, 0x000fe200078e021aULL,
0x000000081a0e7810ULL, 0x000fe40007ffe0ffULL, 0x000000170c00720cULL, 0x0c0fe20003f86070ULL,
0x000000010c0a7824ULL, 0x100fe200078e0203ULL, 0x000000170e00720cULL, 0x000fe20003f06070ULL,
0x000000080c237824ULL, 0x000fe200078e00ffULL, 0x000000047b0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0b7824ULL, 0x000fe200078e0203ULL, 0x0000630012127a11ULL, 0x000fe200010f3cffULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0x0000000c1a0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fc400078ee20aULL,
0xfffffff810277812ULL, 0x000fe200078ee20bULL, 0x000000807b0a7825ULL, 0x040fe200078e00ffULL,
0x000000700c1c7812ULL, 0x100fe400078ef808ULL, 0x000000170e00720cULL, 0x040fe20003f26070ULL,
0x000000010e0f7824ULL, 0x000fe200078e0203ULL, 0x000000700a1e7812ULL, 0x000fe200078ef808ULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0x000000087b0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000131c1c7210ULL, 0x000fc40007f7e0ffULL, 0xfffffff810297812ULL, 0x000fe200078ee20fULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000107b0c7810ULL, 0x040fe40007ffe0ffULL,
0x000000147b107810ULL, 0x000fe20007ffe0ffULL, 0x000000010d1d7824ULL, 0x000fe200018e0612ULL,
0x0000001e131e7210ULL, 0x000fe20007f5e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000c7b0a7810ULL, 0x040fe40007ffe0ffULL, 0x000000700e147812ULL, 0x000fe200078ef808ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000187b207810ULL, 0x000fc40007ffe0ffULL,
0x000000700c0e7812ULL, 0x000fe200078ef808ULL, 0x000000010b1f7824ULL, 0x000fe200010e0612ULL,
0x00000070100c7812ULL, 0x100fe200078ef808ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001314147210ULL, 0x080fe40007f5e0ffULL, 0x000000130e0e7210ULL, 0x080fe20007f7e0ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x000000700a187812ULL, 0x000fe400078ef808ULL,
0x000000130c0c7210ULL, 0x080fe20007fbe0ffULL, 0x000000010f157824ULL, 0x000fe200010e0612ULL,
0x00000070200a7812ULL, 0x000fe200078ef808ULL, 0x000000010d0f7824ULL, 0x100fe200018e0612ULL,
0x0000001318187210ULL, 0x080fe20007f5e0ffULL, 0x00000001110d7824ULL, 0x100fe200028e0612ULL,
0x000000101a207810ULL, 0x040fe20007ffe0ffULL, 0x000000011a117824ULL, 0x140fe200078e0203ULL,
0x000000141a227810ULL, 0x000fe20007ffe0ffULL, 0x000000010b197824ULL, 0x100fe200010e0612ULL,
0x000000130a0a7210ULL, 0x000fe20007fde0ffULL, 0x00000001201b7824ULL, 0x140fe200078e0203ULL,
0x000000172000720cULL, 0x040fe20003f46070ULL, 0x0000000820267824ULL, 0x000fe200078e00ffULL,
0x0000001c7b107810ULL, 0x000fe20007ffe0ffULL, 0x0000000122207824ULL, 0x140fe200078e0203ULL,
0x0000000711247812ULL, 0x000fe200078ec0ffULL, 0x00000008222d7824ULL, 0x000fe200078e00ffULL,
0x0000100000167811ULL, 0x000fe200078e70ffULL, 0x00000001210b7824ULL, 0x000fe200030e0612ULL,
0x0ffffff824217812ULL, 0x000fe200078ef803ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fc400078ee220ULL, 0x000000171a00720cULL, 0x080fe20003fa6070ULL,
0x0000001023257824ULL, 0x100fe200078e0216ULL, 0x000000207b207810ULL, 0x000fe20007ffe0ffULL,
0x0000001027277824ULL, 0x100fe200078e0216ULL, 0xfffffff8262b7812ULL, 0x000fe200078ee21bULL,
0x00000010211b7824ULL, 0x000fe200078e0216ULL, 0x000000172200720cULL, 0x000fe20003f66070ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x000fe400078ef808ULL,
0x000000247b227810ULL, 0x000fe20007ffe0ffULL, 0x0000001029297824ULL, 0x000fe200078e0216ULL,
0x0000001310107210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1b7faeULL, 0x0003e2000e901c48ULL, 0x0000007020207812ULL, 0x000fe200078ef808ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000001c1a287810ULL, 0x040fe20007ffe0ffULL,
0x000000001c257faeULL, 0x0005e2000e101c48ULL, 0x000000181a247810ULL, 0x000fe20007ffe0ffULL,
0x0000000111117824ULL, 0x000fe200030e0612ULL, 0x000000172800720cULL, 0x080fe20003f86070ULL,
0x0000000014277faeULL, 0x0007e2000c101c48ULL, 0x000000172400720cULL, 0x040fe20003fa6070ULL,
0x0000000124267824ULL, 0x100fe200078e0203ULL, 0x00000013201e7210ULL, 0x082fe20007fde0ffULL,
0x00000008241b7824ULL, 0x000fe200078e00ffULL, 0x0000007022207812ULL, 0x000fe200078ef808ULL,
0x0000000128227824ULL, 0x140fe200078e0203ULL, 0x000000287b1c7810ULL, 0x004fe20007ffe0ffULL,
0x0000000828257824ULL, 0x000fe200078e00ffULL, 0x000000241a247810ULL, 0x000fe20007ffe0ffULL,
0x00000001211f7824ULL, 0x000fe200030e0612ULL, 0x0000001320207210ULL, 0x000fe20007fde0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee222ULL,
0x0000000018297faeULL, 0x0003e2000c901c48ULL, 0x000000201a227810ULL, 0x000fe20007ffe0ffULL,
0x0000000123217824ULL, 0x000fe200030e0612ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee226ULL,
0x0000000824157824ULL, 0x008fe200078e00ffULL, 0x000000172200720cULL, 0x0c0fe20003f06070ULL,
0x0000000122237824ULL, 0x100fe200078e0203ULL, 0x000000172400720cULL, 0x000fe20003f26070ULL,
0x0000000822267824ULL, 0x000fe200078e00ffULL, 0x000000701c227812ULL, 0x000fe200078ef808ULL,
0x00000001241c7824ULL, 0x000fe200078e0203ULL, 0x000000381a247810ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0216ULL, 0x0000001322147210ULL, 0x000fe20007fde0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0216ULL, 0xfffffff815197812ULL, 0x002fe200078ee21cULL,
0x000000101b1b7824ULL, 0x000fe200078e0216ULL, 0x0000002c7b1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000000e2b7faeULL, 0x0003e2000d101c48ULL, 0x000000011d157824ULL, 0x000fe200030e0612ULL,
0xfffffff826237812ULL, 0x000fe200078ee223ULL, 0x0000001025257824ULL, 0x100fe200078e0216ULL,
0x000000000c2d7faeULL, 0x0005e2000d901c48ULL, 0x0000001019197824ULL, 0x100fe200078e0216ULL,
0x0000002c1a187810ULL, 0x040fe20007ffe0ffULL, 0x0000001023237824ULL, 0x000fe200078e0216ULL,
0x000000000a1b7faeULL, 0x0007e2000e901c48ULL, 0x000000301a227810ULL, 0x000fc40007ffe0ffULL,
0x0000003c1a267810ULL, 0x040fe20007ffe0ffULL, 0x0000000010257faeULL, 0x0007e2000e101c48ULL,
0x000000281a0e7810ULL, 0x002fe20007ffe0ffULL, 0x00000008221d7824ULL, 0x000fe200078e00ffULL,
0x000000171800720cULL, 0x080fe20003f86070ULL, 0x000000801c0c7825ULL, 0x004fe200078e00ffULL,
0x000000341a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000001e237faeULL, 0x0003e2000c101c48ULL,
0x000000170e00720cULL, 0x040fe20003fa6070ULL, 0x000000080e1a7824ULL, 0x000fe200078e00ffULL,
0x000000700c0a7812ULL, 0x008fe200078ef808ULL, 0x0000000020197faeULL, 0x0005e2000c901c48ULL,
0x000000307b0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010e117824ULL, 0x000fe200078e0203ULL,
0x000000130a0a7210ULL, 0x000fc40007fde0ffULL, 0x000000347b0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000172200720cULL, 0x080fe20003f66070ULL, 0x000000010d0b7824ULL, 0x000fe200030e0612ULL,
0x000000171c00720cULL, 0x080fe20003f46070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000172400720cULL, 0x080fe40003f26070ULL, 0x000000172600720cULL, 0x000fe20003f06070ULL,
0x0000000118197824ULL, 0x104fe200078e0203ULL, 0x000000700c107812ULL, 0x000fe200078ef808ULL,
0x00000001220c7824ULL, 0x000fe200078e0203ULL, 0xfffffff81a177812ULL, 0x000fe200078ee211ULL,
0x0000000818187824ULL, 0x000fe200078e00ffULL, 0x0000001310107210ULL, 0x000fe20007fde0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fc400078ee20cULL,
0xfffffff8181b7812ULL, 0x000fe200078ee219ULL, 0x000000010d117824ULL, 0x000fe200030e0612ULL,
0x000000387b0c7810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1f7824ULL, 0x002fe200078e00ffULL,
0x000000700e187812ULL, 0x000fe200078ef808ULL, 0x000000011c0e7824ULL, 0x100fe200078e0203ULL,
0x0000003c7b7b7810ULL, 0x000fe20007ffe0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000001318187210ULL, 0x000fe40007fde0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20eULL,
0x00000001241a7824ULL, 0x000fe200078e0203ULL, 0x000000700c0c7812ULL, 0x000fe200078ef808ULL,
0x000000010f197824ULL, 0x000fc400030e0612ULL, 0x000000807b0e7825ULL, 0x000fe200078e00ffULL,
0x000000130c0c7210ULL, 0x000fc60007fde0ffULL, 0x0000000824217824ULL, 0x000fe200078e00ffULL,
0x000000700e087812ULL, 0x000fe200078ef808ULL, 0x00000001261c7824ULL, 0x040fe400078e0203ULL,
0x0000000826237824ULL, 0x000fe200078e00ffULL, 0xfffffff821037812ULL, 0x000fe200078ee21aULL,
0x000000010d0d7824ULL, 0x000fe200030e0612ULL, 0x00000013080e7210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x000fe200078e0216ULL, 0xfffffff823217812ULL, 0x000fe200078ee21cULL,
0x000000101b1b7824ULL, 0x000fc400078e0216ULL, 0x000000101d1d7824ULL, 0x100fe200078e0216ULL,
0x0000000014177faeULL, 0x0003e2000e901c48ULL, 0x000000101f1f7824ULL, 0x100fe400078e0216ULL,
0x0000001003037824ULL, 0x100fe200078e0216ULL, 0x000000000a1b7faeULL, 0x0003e2000e101c48ULL,
0x0000001021217824ULL, 0x000fe400078e0216ULL, 0x000000010f0f7824ULL, 0x000fe200030e0612ULL,
0x00000000101d7faeULL, 0x0003e8000d901c48ULL, 0x00000000181f7faeULL, 0x0003e8000d101c48ULL,
0x000000000c037faeULL, 0x0003e8000c901c48ULL, 0x000000000e217faeULL, 0x0003e2000c101c48ULL,
0x00000b5000007947ULL, 0x000fea0003800000ULL, 0x00000004030c7811ULL, 0x04afe400078fe8ffULL,
0x00000008030d7811ULL, 0x000fc400078fe8ffULL, 0x0000001403147811ULL, 0x040fe200078fe8ffULL,
0x000000010c0a7824ULL, 0x140fe200078e0203ULL, 0x0000000c030f7811ULL, 0x040fe200078fe8ffULL,
0x000000080c197824ULL, 0x000fe200078e00ffULL, 0x0000001003137811ULL, 0x000fe200078fe8ffULL,
0x000000080d1b7824ULL, 0x000fe200078e00ffULL, 0x00000020031f7811ULL, 0x000fe200078fe8ffULL,
0x0000000814237824ULL, 0x040fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee20aULL,
0x000000010d0a7824ULL, 0x100fe200078e0203ULL, 0x0000001803157811ULL, 0x000fe200078fe8ffULL,
0x000000010f0b7824ULL, 0x100fe200078e0203ULL, 0x0000001c03177811ULL, 0x000fe200078fe8ffULL,
0x000000080f107824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL,
0x00000001140a7824ULL, 0x100fe200078e0203ULL, 0x0000002c032d7811ULL, 0x000fe200078fe8ffULL,
0x00000001130e7824ULL, 0x040fe200078e0203ULL, 0xfffffff8101d7812ULL, 0x000fe200078ee20bULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee20aULL,
0x000000011f0a7824ULL, 0x100fe200078e0203ULL, 0x0000002403337811ULL, 0x000fe200078fe8ffULL,
0x000000081f2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8110e7812ULL, 0x000fe200078ee20eULL,
0x00000001150b7824ULL, 0x100fe200078e0203ULL, 0x00000028032f7811ULL, 0x000fe200078fe8ffULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20aULL,
0x0000000117107824ULL, 0x000fe200078e0203ULL, 0x0000003003317811ULL, 0x000fe200078fe8ffULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0xfffffff816277812ULL, 0x000fe200078ee20bULL,
0x000000012d0a7824ULL, 0x100fe200078e0203ULL, 0x00000034032e7811ULL, 0x000fe200078fe8ffULL,
0x000000082d217824ULL, 0x000fe200078e00ffULL, 0xfffffff811107812ULL, 0x000fe200078ee210ULL,
0x00000001330b7824ULL, 0x100fe200078e0203ULL, 0x0000003803327811ULL, 0x000fe200078fe8ffULL,
0x0000000833187824ULL, 0x000fe200078e00ffULL, 0xfffffff8211c7812ULL, 0x000fe200078ee20aULL,
0x000000012f117824ULL, 0x000fe200078e0203ULL, 0x00000003030a7211ULL, 0x000fe200078fe8ffULL,
0x000000082f167824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee20bULL,
0x00000001310b7824ULL, 0x040fe200078e0203ULL, 0x000000070a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000831287824ULL, 0x000fe200078e00ffULL, 0xfffffff816117812ULL, 0x000fe200078ee211ULL,
0x000000012e167824ULL, 0x040fe200078e0203ULL, 0x0000003c03307811ULL, 0x000fe200078fe8ffULL,
0x000000082e217824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20bULL,
0x00000001321a7824ULL, 0x100fe200078e0203ULL, 0x0000100000207811ULL, 0x000fe200078e70ffULL,
0x00000001301e7824ULL, 0x100fe200078e0203ULL, 0xfffffff821167812ULL, 0x000fe200078ee216ULL,
0x0000000832217824ULL, 0x000fe200078e00ffULL, 0x0ffffff80a0b7812ULL, 0x000fe200078ef803ULL,
0x0000000830257824ULL, 0x000fe200078e00ffULL, 0x00000002030a7211ULL, 0x000fe200078fe8ffULL,
0x0000001010297824ULL, 0x000fe200078e0220ULL, 0xfffffff821227812ULL, 0x000fe200078ee21aULL,
0x000000100b037824ULL, 0x000fe200078e0220ULL, 0xfffffff8251e7812ULL, 0x000fe200078ee21eULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00006200122a7a11ULL, 0x000fc600078038ffULL,
0x000000100e217824ULL, 0x000fe200078e0220ULL, 0x000000700a257812ULL, 0x000fe200078ef808ULL,
0x00000001020e7824ULL, 0x000fe200078e020dULL, 0x00006300122c7a11ULL, 0x000fe200000f3cffULL,
0x0000000102107824ULL, 0x000fe200078e020fULL, 0x000000252a0a7210ULL, 0x000fe20007f1e0ffULL,
0x00000010111a7824ULL, 0x000fe400078e0220ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000700e357812ULL, 0x000fc600078ef808ULL,
0x0000000102137824ULL, 0x000fe200078e0213ULL, 0x0000007010257812ULL, 0x000fe200078ef808ULL,
0x000000010b0b7824ULL, 0x000fe200000e062cULL, 0x000000352a0e7210ULL, 0x040fe20007f1e0ffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x000000252a107210ULL, 0x000fe40007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a037faeULL, 0x0003e2000b901c48ULL,
0x00000001020c7824ULL, 0x000fe200078e020cULL, 0x0000007012257812ULL, 0x000fe200078ef808ULL,
0x0000000102247824ULL, 0x000fc400078e021fULL, 0x000000010f0f7824ULL, 0x000fe200000e062cULL,
0x000000252a127210ULL, 0x000fe20007f1e0ffULL, 0x0000001019197824ULL, 0x100fe400078e0220ULL,
0x000000101b1b7824ULL, 0x100fe400078e0220ULL, 0x000000101d1d7824ULL, 0x100fe400078e0220ULL,
0x0000001023237824ULL, 0x100fe400078e0220ULL, 0x0000001027277824ULL, 0x000fc400078e0220ULL,
0x000000102b2b7824ULL, 0x100fe400078e0220ULL, 0x0000001018187824ULL, 0x100fe400078e0220ULL,
0x000000101c1c7824ULL, 0x100fe400078e0220ULL, 0x0000001028287824ULL, 0x100fe400078e0220ULL,
0x0000001016267824ULL, 0x100fe400078e0220ULL, 0x0000001022227824ULL, 0x000fc400078e0220ULL,
0x000000101e207824ULL, 0x000fe400078e0220ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x000000700c377812ULL, 0x000fc600078ef808ULL,
0x0000000102147824ULL, 0x000fe200078e0214ULL, 0x0000007024357812ULL, 0x000fe200078ef808ULL,
0x00000001021e7824ULL, 0x000fe200078e0217ULL, 0x000000372a0c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000102167824ULL, 0x000fe200078e0215ULL, 0x000000352a247210ULL, 0x000fe20007f7e0ffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x00000070143b7812ULL, 0x000fc600078ef808ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000701e377812ULL, 0x000fc600078ef808ULL, 0x0000000102337824ULL, 0x000fe200078e0233ULL,
0x0000007016397812ULL, 0x000fe200078ef808ULL, 0x0000000102347824ULL, 0x040fe400078e022fULL,
0x00000001022d7824ULL, 0x040fe400078e022dULL, 0x0000000102357824ULL, 0x040fe400078e0231ULL,
0x0000000102367824ULL, 0x040fe400078e022eULL, 0x00000001023a7824ULL, 0x000fc400078e0230ULL,
0x00000080332e7825ULL, 0x000fc800078e00ffULL, 0x0000000102387824ULL, 0x000fe200078e0232ULL,
0x000000702e477812ULL, 0x000fe200078ef808ULL, 0x0000008034307825ULL, 0x000fc800078e00ffULL,
0x0000000111117824ULL, 0x100fe200010e062cULL, 0x000000372a1e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000113137824ULL, 0x000fe200000e062cULL, 0x0000003b2a147210ULL, 0x000fe20007f1e0ffULL,
0x000000802d327825ULL, 0x000fe200078e00ffULL, 0x0000007030457812ULL, 0x000fc600078ef808ULL,
0x000000010d0d7824ULL, 0x000fe200008e062cULL, 0x000000392a167210ULL, 0x000fe20007f3e0ffULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x0000007032437812ULL, 0x100fe400078ef808ULL,
0x000000000c197faeULL, 0x0003e2000b901c48ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000007034417812ULL, 0x100fe400078ef808ULL, 0x000000000e1b7faeULL, 0x0003e2000b901c48ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x00000070363f7812ULL, 0x000fc400078ef808ULL,
0x00000000101d7faeULL, 0x0003e2000b901c48ULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x00000070383d7812ULL, 0x000fe400078ef808ULL, 0x0000003f2a367210ULL, 0x040fe20007f9e0ffULL,
0x0000000115157824ULL, 0x100fe200000e062cULL, 0x000000472a2e7210ULL, 0x040fe20007f1e0ffULL,
0x0000000117177824ULL, 0x100fe200008e062cULL, 0x000000452a307210ULL, 0x000fe20007f3e0ffULL,
0x000000011f1f7824ULL, 0x000fe200010e062cULL, 0x000000703a2d7812ULL, 0x000fe200078ef808ULL,
0x0000000125257824ULL, 0x100fe200018e062cULL, 0x000000432a327210ULL, 0x040fe20007f5e0ffULL,
0x000000012f2f7824ULL, 0x100fe200000e062cULL, 0x000000412a347210ULL, 0x040fe20007f7e0ffULL,
0x0000000012217faeULL, 0x0003e2000b901c48ULL, 0x0000003d2a387210ULL, 0x040fe20007fbe0ffULL,
0x0000000131317824ULL, 0x100fe200008e062cULL, 0x0000002d2a3a7210ULL, 0x000fe20007fde0ffULL,
0x0000000014237faeULL, 0x0003e2000b901c48ULL, 0x0000000133337824ULL, 0x000fc400010e062cULL,
0x0000000135357824ULL, 0x100fe200018e062cULL, 0x0000000016277faeULL, 0x0003e2000b901c48ULL,
0x0000000137377824ULL, 0x100fe400020e062cULL, 0x0000000139397824ULL, 0x100fe200028e062cULL,
0x000000001e297faeULL, 0x0003e2000b901c48ULL, 0x000000013b3b7824ULL, 0x000fc600030e062cULL,
0x00000000242b7faeULL, 0x0003e8000b901c48ULL, 0x000000002e187faeULL, 0x0003e8000b901c48ULL,
0x00000000301a7faeULL, 0x0003e8000b901c48ULL, 0x00000000321c7faeULL, 0x0003e8000b901c48ULL,
0x0000000034287faeULL, 0x0003e8000b901c48ULL, 0x0000000036267faeULL, 0x0003e8000b901c48ULL,
0x0000000038227faeULL, 0x0003e8000b901c48ULL, 0x000000003a207faeULL, 0x0003e4000b901c48ULL,
0x0000000400677810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff697424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000766700720cULL, 0x000fda0003f06070ULL,
0x00000002060a8824ULL, 0x002fc800078e00ffULL, 0x000068000a0a8a24ULL, 0x000fc800078e0267ULL,
0x000064000a0a8625ULL, 0x000fca00078e0007ULL, 0x000000080a698981ULL, 0x000324000c1e1900ULL,
0x00000000000a7805ULL, 0x002fc40000015200ULL, 0x01760400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a087210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e0bULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140cULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060cULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002000037824ULL, 0x002fca00078e0203ULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04087812ULL, 0x000fe400078ec0ffULL, 0x0000000f03047812ULL, 0x000fc600078ec0ffULL,
0x0000000103087824ULL, 0x000fe400078e0208ULL, 0x00000010040a7824ULL, 0x040fe400078e00ffULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x0000000f08037812ULL, 0x040fe400078ec0ffULL,
0x0000000108087810ULL, 0x000fe40007ffe0ffULL, 0x000000f00a037812ULL, 0x000fe400078ee203ULL,
0x0000000f08087812ULL, 0x000fc600078ec0ffULL, 0x0000000003107984ULL, 0x000e62000000cc00ULL,
0x000000f005087812ULL, 0x000fca00078ee208ULL, 0x00000000080c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001403007388ULL, 0x0003e8000000cc00ULL, 0x0000001008007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff0c7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff077224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01760400ff037984ULL, 0x002e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a04087210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e05ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140aULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060aULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff7800720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000000005b7919ULL, 0x000e620000000000ULL,
0x00005800ff6a7624ULL, 0x000fe200078e00ffULL, 0x8000580070727a10ULL, 0x000fe20007ffe0ffULL,
0x00006800067d7a24ULL, 0x000fe200078e02ffULL, 0x00000100797b7810ULL, 0x000fe20007ffe0ffULL,
0x3db504f309037820ULL, 0x010fe20000410000ULL, 0x0000001f6a047810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff667224ULL, 0x000fe200078e00ffULL, 0xffffffff6a737810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x0001768800777811ULL, 0x040fe400078e18ffULL, 0x00017608007a7811ULL, 0x000fe400078e28ffULL,
0x000000096a6a7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x0ffffffe046f7812ULL, 0x000fc400078ec0ffULL, 0x0000000266057810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000697c697224ULL, 0x010fe200078e02ffULL,
0x0000000163687812ULL, 0x000fc400078e0cffULL, 0x000000780500720cULL, 0x000fda0003f06070ULL,
0x00000cd000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff097819ULL, 0x002fe2000001165bULL,
0x0000010066057824ULL, 0x000fc600078e027bULL, 0x0000000409077810ULL, 0x040fe20007ffe0ffULL,
0x00000001020a7824ULL, 0x000fe200078e0209ULL, 0x00000008090b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000570087217ULL, 0x000fe20007800000ULL, 0x0000000107047824ULL, 0x100fe200078e025bULL,
0x0000001009177810ULL, 0x000fe20007ffe0ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000000c09157810ULL, 0x000fe20007ffe0ffULL, 0x000000010b067824ULL, 0x000fe200078e025bULL,
0x0000001409197810ULL, 0x000fe20007ffe0ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d207812ULL, 0x000fe200078ee204ULL, 0x0000000108087824ULL, 0x000fe200078e0a05ULL,
0x00000018091b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001171e7824ULL, 0x000fe200078e025bULL,
0xfffffff80f247812ULL, 0x000fe200078ee206ULL, 0x00000008170d7824ULL, 0x000fe200078e00ffULL,
0x000000080b00720cULL, 0x080fe20003f06070ULL, 0x000000105b067824ULL, 0x000fe200078e00ffULL,
0x0000001c091d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001020c7824ULL, 0x000fe200078e0207ULL,
0xfffffff80d1e7812ULL, 0x000fe200078ee21eULL, 0x0000000115047824ULL, 0x040fe200078e025bULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000000815057824ULL, 0x000fe200078e00ffULL,
0x000000080700720cULL, 0x000fe20003f26070ULL, 0x00000001020e7824ULL, 0x000fe200078e020bULL,
0x00000020091f7810ULL, 0x000fe20007ffe0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff805267812ULL, 0x000fc400078ee204ULL, 0x0000620069057a11ULL, 0x040fe200078438ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000060a127212ULL, 0x080fe400078efcffULL,
0x0000630069047a11ULL, 0x000fe200010f3cffULL, 0x00000001191a7824ULL, 0x140fe200078e025bULL,
0x000000060c107212ULL, 0x000fe200078efcffULL, 0x00000008190f7824ULL, 0x000fe200078e00ffULL,
0x0000001205127210ULL, 0x000fe20007f5e0ffULL, 0x000000011b167824ULL, 0x040fe200078e025bULL,
0x0000000510107210ULL, 0x000fe20007f7e0ffULL, 0x000000081b117824ULL, 0x000fe200078e00ffULL,
0xfffffff80f1a7812ULL, 0x000fe200078ee21aULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000081700720cULL, 0x000fc40003fa6070ULL, 0xfffffff811167812ULL, 0x000fe200078ee216ULL,
0x000000011d187824ULL, 0x040fe200078e025bULL, 0x000000060e0a7212ULL, 0x000fe200078efcffULL,
0x000000081d077824ULL, 0x000fe400078e00ffULL, 0x00000001020c7824ULL, 0x000fe200078e0215ULL,
0x000000050a0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000102147824ULL, 0x000fe200078e0217ULL,
0xfffffff807187812ULL, 0x000fe200078ee218ULL, 0x00000001090e7824ULL, 0x000fe400078e025bULL,
0x000000010b137824ULL, 0x100fe200010e0604ULL, 0x000000081500720cULL, 0x080fe20003f46070ULL,
0x000000010d117824ULL, 0x000fe200018e0604ULL, 0x000000070e1c7812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000080900720cULL, 0x000fc60003f66070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000060c0e7212ULL, 0x000fc600078efcffULL,
0x0000000200077824ULL, 0x000fe200078e0268ULL, 0x00000006140c7212ULL, 0x000fe200078efcffULL,
0x000000010f0b7824ULL, 0x000fe200020e0604ULL, 0x0ffffff81c147812ULL, 0x100fe200078ef85bULL,
0x000000011f0f7824ULL, 0x000fe200078e025bULL, 0x0000100007077811ULL, 0x000fe200078e68ffULL,
0x000000081f227824ULL, 0x000fe200078e00ffULL, 0x000000050e0e7210ULL, 0x080fe40007f9e0ffULL,
0x000000050c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001014177824ULL, 0x000fe200078e0207ULL,
0xfffffff8221c7812ULL, 0x000fe200078ee20fULL, 0x0000000102147824ULL, 0x000fc400078e0219ULL,
0x000000010d0f7824ULL, 0x100fe200020e0604ULL, 0x000000081900720cULL, 0x080fe20003f86070ULL,
0x00000001150d7824ULL, 0x000fe200030e0604ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012177faeULL, 0x0003e2000d901c48ULL, 0x0000001020197824ULL, 0x000fe200078e0207ULL,
0x000000081b00720cULL, 0x000fe20003f66070ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000000010197faeULL, 0x0005e2000c901c48ULL, 0x0000000102207824ULL, 0x000fe200078e021bULL,
0x0000000614147212ULL, 0x000fe200078efcffULL, 0x0000000102227824ULL, 0x000fe200078e021dULL,
0x00000024091b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000514147210ULL, 0x080fe40007fde0ffULL, 0x000000081d00720cULL, 0x000fe20003f26070ULL,
0x000000011b137824ULL, 0x042fe200078e025bULL, 0x0000000620127212ULL, 0x000fe200078efcffULL,
0x000000081b207824ULL, 0x000fe200078e00ffULL, 0x00000028091d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000115157824ULL, 0x000fe200030e0604ULL, 0x0000000512127210ULL, 0x000fe20007fde0ffULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x0000001024177824ULL, 0x000fe200078e0207ULL,
0xfffffff820247812ULL, 0x000fe200078ee213ULL, 0x0000000102207824ULL, 0x000fe200078e021fULL,
0x0000000622107212ULL, 0x004fe200078efcffULL, 0x0000000121137824ULL, 0x100fe200030e0604ULL,
0x000000000a177faeULL, 0x0003e2000c101c48ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000510107210ULL, 0x000fe40007fde0ffULL, 0x000000081f00720cULL, 0x000fe20003f06070ULL,
0x0000001026197824ULL, 0x000fe200078e0207ULL, 0x0000000620207212ULL, 0x000fe200078efcffULL,
0x000000081d227824ULL, 0x000fe200078e00ffULL, 0x0000002c091f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000123117824ULL, 0x000fe200030e0604ULL, 0x000000000e197faeULL, 0x0005e2000d101c48ULL,
0x000000081b00720cULL, 0x000fe20003f46070ULL, 0x000000011d0b7824ULL, 0x002fc400078e025bULL,
0x00000001020a7824ULL, 0x000fe400078e021bULL, 0x000000101e177824ULL, 0x000fe400078e0207ULL,
0x000000011f1b7824ULL, 0x040fe400078e025bULL, 0x000000081f267824ULL, 0x000fe200078e00ffULL,
0x000000000c177faeULL, 0x0003e2000e901c48ULL, 0x00000005200e7210ULL, 0x004fe20007fde0ffULL,
0x000000101a197824ULL, 0x000fe200078e0207ULL, 0xfffffff822207812ULL, 0x000fe200078ee20bULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff826227812ULL, 0x000fc400078ee21bULL,
0x0000000014197faeULL, 0x0005e2000e101c48ULL, 0x00000001210f7824ULL, 0x100fe200030e0604ULL,
0x000000060a1a7212ULL, 0x000fe200078efcffULL, 0x00000001021e7824ULL, 0x040fe200078e021dULL,
0x000000081f00720cULL, 0x080fe20003f86070ULL, 0x00000001020a7824ULL, 0x000fe200078e021fULL,
0x000000051a1a7210ULL, 0x000fe20007fde0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000081d00720cULL, 0x000fe40003fa6070ULL, 0x00000038091d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b1b7824ULL, 0x000fe200030e0604ULL, 0x00000030090b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001016177824ULL, 0x002fc400078e0207ULL, 0x000000800a0c7825ULL, 0x000fe200078e00ffULL,
0x000000061e0a7212ULL, 0x080fe400078efcffULL, 0x0000000012177faeULL, 0x0003e2000d901c48ULL,
0x000000010b157824ULL, 0x044fe200078e025bULL, 0x000000050a0a7210ULL, 0x080fe20007fde0ffULL,
0x000000080b167824ULL, 0x040fe200078e00ffULL, 0x000000060c0c7212ULL, 0x000fe200078efcffULL,
0x0000000102147824ULL, 0x000fe200078e020bULL, 0x000000080b00720cULL, 0x000fe20003f66070ULL,
0x000000011f0b7824ULL, 0x000fe200030e0604ULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x0000001018157824ULL, 0x000fe200078e0207ULL, 0x000000050c0c7210ULL, 0x000fc40007fde0ffULL,
0x0000003409177810ULL, 0x042fe20007ffe0ffULL, 0x0000008014127825ULL, 0x000fe200078e00ffULL,
0x0000000010157faeULL, 0x0003e2000c901c48ULL, 0x0000003c091f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000102147824ULL, 0x000fe200078e0217ULL, 0x0000000612127212ULL, 0x000fe200078efcffULL,
0x0000000117187824ULL, 0x040fe200078e025bULL, 0x000000081700720cULL, 0x040fe20003f26070ULL,
0x0000000817197824ULL, 0x000fe400078e00ffULL, 0x000000010d0d7824ULL, 0x000fe200030e0604ULL,
0x0000000512127210ULL, 0x000fe20007fde0ffULL, 0x000000101c177824ULL, 0x000fe200078e0207ULL,
0xfffffff819187812ULL, 0x000fe200078ee218ULL, 0x0000008014107825ULL, 0x002fc600078e00ffULL,
0x000000000e177faeULL, 0x0003e2000c101c48ULL, 0x0000000102147824ULL, 0x000fe200078e021dULL,
0x0000000610107212ULL, 0x000fe200078efcffULL, 0x0000001024197824ULL, 0x000fe200078e0207ULL,
0x000000081f00720cULL, 0x000fe20003f06070ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x000000001a197faeULL, 0x0005e2000d101c48ULL, 0x0000000113137824ULL, 0x000fe200030e0604ULL,
0x0000000510107210ULL, 0x000fe20007fde0ffULL, 0x0000000102097824ULL, 0x000fe200078e021fULL,
0x000000081d00720cULL, 0x040fe20003f46070ULL, 0x000000011d0f7824ULL, 0x002fe200078e025bULL,
0x00000006140e7212ULL, 0x000fe200078efcffULL, 0x0000008009087825ULL, 0x000fc800078e00ffULL,
0x0000000111117824ULL, 0x100fe200030e0604ULL, 0x000000050e0e7210ULL, 0x080fe20007fde0ffULL,
0x000000081d1c7824ULL, 0x000fe200078e00ffULL, 0x0000000608067212ULL, 0x000fe200078efcffULL,
0x000000011f147824ULL, 0x040fe400078e025bULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c087812ULL, 0x000fe200078ee20fULL, 0x00000001150f7824ULL, 0x000fe200030e0604ULL,
0x0000000506067210ULL, 0x000fe20007fde0ffULL, 0x0000001020057824ULL, 0x100fe200078e0207ULL,
0xfffffff81f147812ULL, 0x000fe200078ee214ULL, 0x0000001022157824ULL, 0x000fc400078e0207ULL,
0x0000001016177824ULL, 0x100fe200078e0207ULL, 0x000000000a057faeULL, 0x0003e2000e901c48ULL,
0x0000001018197824ULL, 0x104fe400078e0207ULL, 0x00000010081b7824ULL, 0x100fe200078e0207ULL,
0x000000000c157faeULL, 0x0003e2000e101c48ULL, 0x00000010141d7824ULL, 0x000fe400078e0207ULL,
0x0000000109077824ULL, 0x000fe200030e0604ULL, 0x0000000012177faeULL, 0x0003e8000d901c48ULL,
0x0000000010197faeULL, 0x0003e8000c901c48ULL, 0x000000000e1b7faeULL, 0x0003e8000d101c48ULL,
0x00000000061d7faeULL, 0x0003e2000c101c48ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x000000045b067811ULL, 0x042fe200078fe8ffULL, 0x000000105b317824ULL, 0x040fe200078e00ffULL,
0x0000000c5b097811ULL, 0x000fc400078fe8ffULL, 0x000000085b077811ULL, 0x040fe200078fe8ffULL,
0x0000000106047824ULL, 0x140fe200078e025bULL, 0x000000105b0c7811ULL, 0x040fe200078fe8ffULL,
0x00000008062d7824ULL, 0x000fe200078e00ffULL, 0x000000145b0e7811ULL, 0x000fe200078fe8ffULL,
0x0000000109057824ULL, 0x100fe200078e025bULL, 0x000000185b117811ULL, 0x000fe200078fe8ffULL,
0x0000000809107824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee204ULL,
0x0000000107047824ULL, 0x000fe200078e025bULL, 0x000000205b0f7811ULL, 0x000fe200078fe8ffULL,
0x00000008072b7824ULL, 0x000fe200078e00ffULL, 0xfffffff810297812ULL, 0x000fe200078ee205ULL,
0x000000010c087824ULL, 0x140fe200078e025bULL, 0x0000001c5b107811ULL, 0x000fe200078fe8ffULL,
0x000000080c277824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL,
0x000000010e0a7824ULL, 0x140fe200078e025bULL, 0x000000245b167811ULL, 0x040fe200078fe8ffULL,
0x000000080e257824ULL, 0x000fe200078e00ffULL, 0x000000285b2c7811ULL, 0x000fe200078fe8ffULL,
0x0000000111047824ULL, 0x100fe200078e025bULL, 0xfffffff827277812ULL, 0x000fe200078ee208ULL,
0x0000000811237824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee20aULL,
0x0000000110057824ULL, 0x140fe200078e025bULL, 0x0000002c5b177811ULL, 0x040fe200078fe8ffULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0x000000305b267811ULL, 0x000fe200078fe8ffULL,
0x000000010f087824ULL, 0x100fe200078e025bULL, 0xfffffff823237812ULL, 0x000fe200078ee204ULL,
0x000000080f1f7824ULL, 0x000fe200078e00ffULL, 0x000000345b287811ULL, 0x000fe200078fe8ffULL,
0x00000001160a7824ULL, 0x000fe200078e025bULL, 0xfffffff812217812ULL, 0x000fe200078ee205ULL,
0x00000008160b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL,
0x000000012c047824ULL, 0x140fe200078e025bULL, 0x000000385b2a7811ULL, 0x000fe200078fe8ffULL,
0x000000082c1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee20aULL,
0x0000000117057824ULL, 0x100fe200078e025bULL, 0x0000003c5b247811ULL, 0x000fe200078fe8ffULL,
0x0000000817127824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee204ULL,
0x0000000126087824ULL, 0x040fe200078e025bULL, 0x0000005b5b047211ULL, 0x000fe200078fe8ffULL,
0x00000008261b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8120d7812ULL, 0x000fe200078ee205ULL,
0x00000001280a7824ULL, 0x100fe200078e025bULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x0000000828137824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x0000000200057824ULL, 0x000fe200078e0268ULL, 0x0ffffff804197812ULL, 0x100fe200078ef85bULL,
0x000000012a087824ULL, 0x140fe200078e025bULL, 0xfffffff813137812ULL, 0x000fe200078ee20aULL,
0x000000082a157824ULL, 0x000fe200078e00ffULL, 0x0000100005207811ULL, 0x000fe200078e68ffULL,
0x00000001240a7824ULL, 0x040fe200078e025bULL, 0x000000025b047211ULL, 0x000fe200078fe8ffULL,
0x00000008242f7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee208ULL,
0x0000001019197824ULL, 0x100fe200078e0220ULL, 0x0000007031317812ULL, 0x000fe200078ec0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0220ULL, 0xfffffff82f057812ULL, 0x000fe200078ee20aULL,
0x000000102b2b7824ULL, 0x100fe200078e0220ULL, 0x0000620069227a11ULL, 0x000fe200078038ffULL,
0x0000001029297824ULL, 0x000fc400078e0220ULL, 0x0000001027277824ULL, 0x100fe200078e0220ULL,
0x00006300692f7a11ULL, 0x000fe200000f3cffULL, 0x0000001025257824ULL, 0x100fe400078e0220ULL,
0x0000001023237824ULL, 0x100fe400078e0220ULL, 0x0000001021217824ULL, 0x100fe400078e0220ULL,
0x000000101f1f7824ULL, 0x100fe400078e0220ULL, 0x000000100b1e7824ULL, 0x000fc400078e0220ULL,
0x000000101d1d7824ULL, 0x100fe400078e0220ULL, 0x000000100d1c7824ULL, 0x100fe400078e0220ULL,
0x000000101b1b7824ULL, 0x100fe400078e0220ULL, 0x00000010131a7824ULL, 0x100fe400078e0220ULL,
0x0000001015187824ULL, 0x100fe400078e0220ULL, 0x0000001005207824ULL, 0x000fc400078e0220ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000102087824ULL, 0x000fe200078e0207ULL,
0x00000031040d7212ULL, 0x000fe200078efcffULL, 0x00000001020a7824ULL, 0x000fe400078e0209ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000000d22047210ULL, 0x000fc60007f1e0ffULL,
0x0000000102067824ULL, 0x000fe200078e0206ULL, 0x00000031080d7212ULL, 0x000fe200078efcffULL,
0x00000001020c7824ULL, 0x000fe400078e020cULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003106137212ULL, 0x000fc600078efcffULL,
0x0000000105057824ULL, 0x000fe200000e062fULL, 0x0000000d22087210ULL, 0x000fe20007f1e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000310a157212ULL, 0x000fe400078efcffULL,
0x0000001322067210ULL, 0x000fe20007f3e0ffULL, 0x0000000102127824ULL, 0x000fe200078e0211ULL,
0x000000310c117212ULL, 0x000fe200078efcffULL, 0x0000000102147824ULL, 0x000fe200078e020fULL,
0x00000015220a7210ULL, 0x000fe20007f5e0ffULL, 0x00000001020e7824ULL, 0x040fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004197faeULL, 0x0003e2000b901c48ULL,
0x0000000102137824ULL, 0x000fc400078e0210ULL, 0x0000000109097824ULL, 0x000fe200000e062fULL,
0x00000011220c7210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000008012107825ULL, 0x000fe200078e00ffULL, 0x0000003114397212ULL, 0x000fc600078efcffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000003110357212ULL, 0x000fe400078efcffULL,
0x0000003922147210ULL, 0x000fe20007f7e0ffULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x000000310e337212ULL, 0x000fc600078efcffULL, 0x0000000102387824ULL, 0x000fe200078e0216ULL,
0x0000003112377212ULL, 0x000fe200078efcffULL, 0x00000001023a7824ULL, 0x040fe400078e022cULL,
0x00000001023c7824ULL, 0x040fe400078e0217ULL, 0x0000000102367824ULL, 0x040fe400078e0226ULL,
0x0000000102347824ULL, 0x040fe400078e0228ULL, 0x0000000102327824ULL, 0x000fc400078e022aULL,
0x0000000102167824ULL, 0x000fe400078e0224ULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x0000000107077824ULL, 0x100fe200008e062fULL, 0x0000003522107210ULL, 0x040fe20007f3e0ffULL,
0x000000010b0b7824ULL, 0x100fe200010e062fULL, 0x0000003722127210ULL, 0x040fe20007f5e0ffULL,
0x000000010d0d7824ULL, 0x000fe200000e062fULL, 0x00000033220e7210ULL, 0x000fe20007f1e0ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x00000031383f7212ULL, 0x080fe200078efcffULL,
0x00000000062d7faeULL, 0x0003e4000b901c48ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000313a417212ULL, 0x080fe200078efcffULL, 0x00000000082b7faeULL, 0x0003e4000b901c48ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000313c437212ULL, 0x080fe200078efcffULL,
0x000000000a297faeULL, 0x0003e4000b901c48ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000003136457212ULL, 0x080fe200078efcffULL, 0x000000000c277faeULL, 0x0003e4000b901c48ULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000003134477212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003132497212ULL, 0x000fe400078efcffULL,
0x0000004722347210ULL, 0x000fe20007f9e0ffULL, 0x000000010f0f7824ULL, 0x100fe200000e062fULL,
0x0000003116317212ULL, 0x000fe200078efcffULL, 0x0000000111117824ULL, 0x100fe200008e062fULL,
0x0000003f22307210ULL, 0x040fe20007f1e0ffULL, 0x0000000113137824ULL, 0x100fe200010e062fULL,
0x0000004122387210ULL, 0x040fe20007f3e0ffULL, 0x0000000115157824ULL, 0x100fe200018e062fULL,
0x00000043223a7210ULL, 0x040fe20007f5e0ffULL, 0x000000000e257faeULL, 0x0003e2000b901c48ULL,
0x0000004522367210ULL, 0x040fe20007f7e0ffULL, 0x0000000135357824ULL, 0x100fe200020e062fULL,
0x0000003122167210ULL, 0x040fe20007fde0ffULL, 0x0000000139317824ULL, 0x100fe200000e062fULL,
0x0000004922327210ULL, 0x000fe20007fbe0ffULL, 0x000000013b397824ULL, 0x100fe200008e062fULL,
0x0000000010237faeULL, 0x0003e2000b901c48ULL, 0x000000013d3b7824ULL, 0x000fc400010e062fULL,
0x0000000137377824ULL, 0x100fe200018e062fULL, 0x0000000012217faeULL, 0x0003e2000b901c48ULL,
0x0000000133337824ULL, 0x100fe400028e062fULL, 0x0000000117177824ULL, 0x000fe200030e062fULL,
0x00000000141f7faeULL, 0x0003e8000b901c48ULL, 0x00000000301e7faeULL, 0x0003e8000b901c48ULL,
0x00000000381d7faeULL, 0x0003e8000b901c48ULL, 0x000000003a1c7faeULL, 0x0003e8000b901c48ULL,
0x00000000361b7faeULL, 0x0003e8000b901c48ULL, 0x00000000341a7faeULL, 0x0003e8000b901c48ULL,
0x0000000032187faeULL, 0x0003e8000b901c48ULL, 0x0000000016207faeULL, 0x0003e4000b901c48ULL,
0x0000000467677810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff697424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000766700720cULL, 0x000fda0003f06070ULL,
0x000000027d068824ULL, 0x002fe400078e0267ULL, 0x00000004ff078424ULL, 0x000fc800078e00ffULL,
0x0000640006068625ULL, 0x000fe200078e0007ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x0000000806698981ULL, 0x000322000c1e1900ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x002fc80000000000ULL,
0xfffffff85b067812ULL, 0x020fe200078ec0ffULL, 0x00000002003c7824ULL, 0x000fe200078e0263ULL,
0x00000001043d7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000706067812ULL, 0x000fc400078ef85bULL, 0x000010003c3c7811ULL, 0x000fc600078e68ffULL,
0x0000000106057824ULL, 0x040fe400078e0204ULL, 0x0000000806087824ULL, 0x040fe400078e00ffULL,
0x0000000806077824ULL, 0x040fe400078e00ffULL, 0x0000000106067824ULL, 0x000fe200078e023dULL,
0xfffffff808057812ULL, 0x000fc800078ee205ULL, 0xfffffff807077812ULL, 0x000fe200078ee206ULL,
0x0000001005057824ULL, 0x000fc800078e023cULL, 0x0000001007077824ULL, 0x000fe200078e023cULL,
0x000000000510783bULL, 0x000e680000000200ULL, 0x000000000714783bULL, 0x000ea20000000200ULL,
0x00000018ff0b7819ULL, 0x002fe20000011413ULL, 0x00000010005a7306ULL, 0x000fe20000009400ULL,
0x00000018ff057819ULL, 0x000fe40000011410ULL, 0x00000018ff0c7819ULL, 0x004fc40000011414ULL,
0x00000018ff067819ULL, 0x000fe40000011411ULL, 0x00000018ff0d7819ULL, 0x000fe20000011415ULL,
0x0000000b00187306ULL, 0x000fe20000209400ULL, 0x00000018ff077819ULL, 0x000fe40000011412ULL,
0x00000018ff0e7819ULL, 0x000fe40000011416ULL, 0x00000018ff0f7819ULL, 0x000fc60000011417ULL,
0x0000000b00097306ULL, 0x000ff00000205400ULL, 0x0000000b00507306ULL, 0x0003f0000020d400ULL,
0x00000010005d7306ULL, 0x000ea20000005400ULL, 0x00010000100b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x0000001000467306ULL, 0x0002f0000000d400ULL,
0x0000000c00457306ULL, 0x000fe20000209400ULL, 0x0000010010107824ULL, 0x002fe200078e00ffULL,
0x0000005d5a00720bULL, 0x004fe20003fbd000ULL, 0x00010000135a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000000c00407306ULL, 0x000fe20000205400ULL,
0x00000018ff657819ULL, 0x000fcc000001145aULL, 0x0000000146465812ULL, 0x008fe200078efcffULL,
0x0000001000557306ULL, 0x000ff00000209400ULL, 0x0000001000577306ULL, 0x000e700000205400ULL,
0x0000001000437306ULL, 0x0004f0000020d400ULL, 0x0000000c00087306ULL, 0x0007e2000020d400ULL,
0x000000205b107810ULL, 0x004fc40007ffe0ffULL, 0x000000575500720bULL, 0x002fe40003f1d000ULL,
0xfffffff810107812ULL, 0x000fc600078ec0ffULL, 0x0000001100567306ULL, 0x000fe20000009400ULL,
0x00010000110c7824ULL, 0x008fe200078e00ffULL, 0x0000000710107812ULL, 0x000fc800078ef85bULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x00000001103d7824ULL, 0x000fe200078e023dULL,
0x0000001100517306ULL, 0x000e620000005400ULL, 0x0000000143430812ULL, 0x000fce00078efcffULL,
0x00000011006c7306ULL, 0x0004f0000000d400ULL, 0x00000005004d7306ULL, 0x000fe20000209400ULL,
0x0000010011117824ULL, 0x004fe200078e00ffULL, 0x000000515600720bULL, 0x002fe20003f3d000ULL,
0x0000010013517824ULL, 0x000fca00078e00ffULL, 0x00000005004c7306ULL, 0x000e620000205400ULL,
0x00000018ff567819ULL, 0x000fcc0000011451ULL, 0x000000016c6c1812ULL, 0x008fe200078efcffULL,
0x0000000500477306ULL, 0x000ea2000020d400ULL, 0x000000091800720bULL, 0x000fce0003f3d000ULL,
0x0000000d003f7306ULL, 0x000fe20000209400ULL, 0x0000004c4d00720bULL, 0x002fca0003fdd000ULL,
0x0000000150501812ULL, 0x000fe400078efcffULL, 0x0000000d000a7306ULL, 0x000fec0000205400ULL,
0x0000000147476812ULL, 0x004fe400078efcffULL, 0x0000000d00057306ULL, 0x0003e4000020d400ULL,
0x000000434747723eULL, 0x000fcc00000010ffULL, 0x0000000c00197306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x002fce0000011411ULL, 0x0000000c001a7306ULL, 0x000e700000205400ULL,
0x0000000c006e7306ULL, 0x0004f0000020d400ULL, 0x0000000d00117306ULL, 0x000fe20000209400ULL,
0x00000001100c7824ULL, 0x004fe200078e0204ULL, 0x0000001a1900720bULL, 0x002fcc0003f1d000ULL,
0x0000000d00487306ULL, 0x000e6e0000205400ULL, 0x000000016e6e0812ULL, 0x008fe200078efcffULL,
0x0000000d006d7306ULL, 0x0004f0000020d400ULL, 0x0000000b00527306ULL, 0x000fe20000209400ULL,
0x00000008100d7824ULL, 0x004fe200078e00ffULL, 0x000000481100720bULL, 0x002fe20003fdd000ULL,
0x0001000014117824ULL, 0x000fc400078e00ffULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe400078ee20cULL, 0x0000000b00537306ULL, 0x000e640000205400ULL,
0xfffffff8103d7812ULL, 0x000fe200078ee23dULL, 0x000000100d0d7824ULL, 0x000fc800078e023cULL,
0x000000016d6d6812ULL, 0x008fe200078efcffULL, 0x0000000600497306ULL, 0x000fe20000209400ULL,
0x000000103d107824ULL, 0x000fce00078e023cULL, 0x00000006004e7306ULL, 0x000fe20000205400ULL,
0x000000535200720bULL, 0x002fce0003f5d000ULL, 0x00000006006b7306ULL, 0x000ff0000020d400ULL,
0x00000007001b7306ULL, 0x000ff00000209400ULL, 0x0000000700447306ULL, 0x000e700000205400ULL,
0x00000007004a7306ULL, 0x000eb0000020d400ULL, 0x0000000e00417306ULL, 0x000fe20000209400ULL,
0x000000441b00720bULL, 0x002fce0003fbd000ULL, 0x0000000e003e7306ULL, 0x000fec0000205400ULL,
0x000000014a4a5812ULL, 0x004fe400078efcffULL, 0x0000000e00077306ULL, 0x000ff0000020d400ULL,
0x0000000f00607306ULL, 0x000ff00000209400ULL, 0x0000000f005c7306ULL, 0x000ff00000205400ULL,
0x0000000f00067306ULL, 0x0003f0000020d400ULL, 0x0000000b00427306ULL, 0x0004e2000020d400ULL,
0x000000000d0c783bULL, 0x002e6e0000000200ULL, 0x00000012004f7306ULL, 0x000fe20000009400ULL,
0x00010000120b7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001140bULL,
0x0000001200547306ULL, 0x000ea20000005400ULL, 0x0000000142422812ULL, 0x008fe400078efcffULL,
0x0000004e4900720bULL, 0x000fe40003f5d000ULL, 0x000000464246723eULL, 0x000fc600000010ffULL,
0x00000012004b7306ULL, 0x000670000000d400ULL, 0x0000005e000b7306ULL, 0x000fe20000209400ULL,
0x0000010012127824ULL, 0x008fe200078e00ffULL, 0x000000016b6b2812ULL, 0x000fc400078efcffULL,
0x000000544f00720bULL, 0x004fe40003f9d000ULL, 0x00000018ff5f7819ULL, 0x000fe40000011412ULL,
0x0000005e00747306ULL, 0x000ea20000205400ULL, 0x00000018ff557819ULL, 0x002fce000001140eULL,
0x0000001400197306ULL, 0x000fe20000009400ULL, 0x000000014b4b4812ULL, 0x000fce00078efcffULL,
0x00000014001a7306ULL, 0x000e620000005400ULL, 0x000000740b00720bULL, 0x004fe20003fdd000ULL,
0x00010000150b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe2000001140bULL,
0x0000005f00587306ULL, 0x000ff00000209400ULL, 0x0000005f00597306ULL, 0x000ea20000205400ULL,
0x0000001a1900720bULL, 0x002fe20003f1d000ULL, 0x0000010014197824ULL, 0x000fca00078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000001300127306ULL, 0x000ff00000009400ULL,
0x0000001300757306ULL, 0x000e620000005400ULL, 0x000000595800720bULL, 0x004fe20003f5d000ULL,
0x000100000c587824ULL, 0x000fcc00078e00ffULL, 0x0000005e00627306ULL, 0x000eb0000020d400ULL,
0x00000065005a7306ULL, 0x000fe20000209400ULL, 0x000000751200720bULL, 0x002fe40003f7d000ULL,
0x00000018ff127819ULL, 0x000fc4000001140cULL, 0x00000018ff757819ULL, 0x000fc6000001140dULL,
0x00000065005d7306ULL, 0x000e620000205400ULL, 0x0000000162626812ULL, 0x004fce00078efcffULL,
0x0000005f00617306ULL, 0x000eb0000020d400ULL, 0x0000001400487306ULL, 0x000ee2000000d400ULL,
0x0000005d5a00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff5a7819ULL, 0x000fca0000011458ULL,
0x0000000c00147306ULL, 0x000fe20000009400ULL, 0x0000000161612812ULL, 0x004fce00078efcffULL,
0x0000000c00597306ULL, 0x000e620000005400ULL, 0x0000000148480812ULL, 0x008fce00078efcffULL,
0x00000012004f7306ULL, 0x000ff00000209400ULL, 0x0000001200547306ULL, 0x000ea20000205400ULL,
0x000000591400720bULL, 0x002fe20003f5d000ULL, 0x000001000c147824ULL, 0x000fcc00078e00ffULL,
0x00000056005e7306ULL, 0x000ff00000209400ULL, 0x00000056005f7306ULL, 0x000e620000205400ULL,
0x000000544f00720bULL, 0x004fce0003fbd000ULL, 0x0000001300647306ULL, 0x000eb0000000d400ULL,
0x0000005a00587306ULL, 0x000fe20000209400ULL, 0x0000005f5e00720bULL, 0x002fce0003f9d000ULL,
0x0000005a00597306ULL, 0x000e620000205400ULL, 0x0000000164643812ULL, 0x004fce00078efcffULL,
0x0000006500657306ULL, 0x000eb0000020d400ULL, 0x0000005600517306ULL, 0x000ee2000020d400ULL,
0x000000595800720bULL, 0x002fce0003f7d000ULL, 0x0000007500537306ULL, 0x000fe20000209400ULL,
0x0000000165656812ULL, 0x004fce00078efcffULL, 0x0000007500567306ULL, 0x000e620000205400ULL,
0x0000000151514812ULL, 0x008fce00078efcffULL, 0x0000000c005d7306ULL, 0x000eb0000000d400ULL,
0x0000001200527306ULL, 0x0006a2000020d400ULL, 0x000000565300720bULL, 0x002fe20003fdd000ULL,
0x000100000d537824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011453ULL,
0x0000000d000c7306ULL, 0x000fe20000009400ULL, 0x00000018ff127819ULL, 0x008fe4000001140fULL,
0x000000015d5d2812ULL, 0x004fca00078efcffULL, 0x0000000d004f7306ULL, 0x000e620000005400ULL,
0x0000000152525812ULL, 0x000fce00078efcffULL, 0x0000007500577306ULL, 0x0004f0000020d400ULL,
0x00000019001a7306ULL, 0x000fe20000209400ULL, 0x00000018ff757819ULL, 0x004fe40000011411ULL,
0x0000004f0c00720bULL, 0x002fe20003f9d000ULL, 0x000001000d0c7824ULL, 0x000fc800078e00ffULL,
0x00000019001b7306ULL, 0x000fe20000205400ULL, 0x0000000157576812ULL, 0x008fce00078efcffULL,
0x0000001900097306ULL, 0x000ff0000020d400ULL, 0x0000007400187306ULL, 0x000ff00000209400ULL,
0x0000007400197306ULL, 0x000e700000205400ULL, 0x00000074000b7306ULL, 0x0004f0000020d400ULL,
0x0000001200137306ULL, 0x000fe20000209400ULL, 0x00000018ff747819ULL, 0x004fc40000011414ULL,
0x000000191800720bULL, 0x002fca0003f1d000ULL, 0x0000001200447306ULL, 0x000ff00000205400ULL,
0x0000001200497306ULL, 0x000fe2000020d400ULL, 0x000000010b0b0812ULL, 0x008fce00078efcffULL,
0x0000007500117306ULL, 0x000ff00000209400ULL, 0x0000007500127306ULL, 0x000ff00000205400ULL,
0x00000075004e7306ULL, 0x000ff0000020d400ULL, 0x0000005a005f7306ULL, 0x000e70000020d400ULL,
0x00000055004c7306ULL, 0x000ff00000209400ULL, 0x00000055004d7306ULL, 0x000ea20000205400ULL,
0x000000015f5f3812ULL, 0x002fce00078efcffULL, 0x0000007400147306ULL, 0x000ff00000209400ULL,
0x0000007400757306ULL, 0x000e620000205400ULL, 0x0000004d4c00720bULL, 0x004fce0003f3d000ULL,
0x00000074005e7306ULL, 0x0004e2000020d400ULL, 0x000000751400720bULL, 0x002fce0003f7d000ULL,
0x0000005600537306ULL, 0x000fe20000209400ULL, 0x00000018ff747819ULL, 0x004fce000001140cULL,
0x0000005600547306ULL, 0x000e620000205400ULL, 0x000000015e5e3812ULL, 0x008fce00078efcffULL,
0x0000000e00147306ULL, 0x000ff00000009400ULL, 0x0000000e004d7306ULL, 0x000ea20000005400ULL,
0x000000545300720bULL, 0x002fce0003f5d000ULL, 0x00000074004f7306ULL, 0x000ff00000209400ULL,
0x00000074000c7306ULL, 0x000e620000205400ULL, 0x0000004d1400720bULL, 0x004fe20003f7d000ULL,
0x000001000e147824ULL, 0x000fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011414ULL,
0x0000000d00587306ULL, 0x0004f0000000d400ULL, 0x0000007400597306ULL, 0x0006e2000020d400ULL,
0x000100000e0d7824ULL, 0x004fe200078e00ffULL, 0x0000000c4f00720bULL, 0x002fe20003fbd000ULL,
0x000100000f0c7824ULL, 0x000fca00078e00ffULL, 0x00000056005a7306ULL, 0x000e62000020d400ULL,
0x00000018ff747819ULL, 0x008fe4000001140dULL, 0x0000000158584812ULL, 0x000fca00078efcffULL,
0x0000000e00547306ULL, 0x000ea2000000d400ULL, 0x0000000159595812ULL, 0x000fce00078efcffULL,
0x00000074000d7306ULL, 0x000fe20000209400ULL, 0x000000015a5a2812ULL, 0x002fce00078efcffULL,
0x00000074004c7306ULL, 0x000e620000205400ULL, 0x0000000154543812ULL, 0x004fe400078efcffULL,
0x0000000a3f00720bULL, 0x000fca0003f7d000ULL, 0x0000000f000e7306ULL, 0x000ff00000009400ULL,
0x0000000f004f7306ULL, 0x000ea20000005400ULL, 0x0000004c0d00720bULL, 0x002fe40003f5d000ULL,
0x00000018ff4c7819ULL, 0x000fc4000001140cULL, 0x0000000105053812ULL, 0x000fc600078efcffULL,
0x0000007500567306ULL, 0x000ff00000209400ULL, 0x00000075004d7306ULL, 0x000e620000205400ULL,
0x0000004f0e00720bULL, 0x004fe20003fbd000ULL, 0x000001000f0e7824ULL, 0x000fcc00078e00ffULL,
0x0000000f004f7306ULL, 0x000eb0000000d400ULL, 0x0000004c000c7306ULL, 0x000fe20000209400ULL,
0x0000004d5600720bULL, 0x002fce0003f9d000ULL, 0x0000004c000d7306ULL, 0x000e620000205400ULL,
0x000000014f4f5812ULL, 0x004fe400078efcffULL, 0x000000441300720bULL, 0x000fca0003fbd000ULL,
0x0000007400537306ULL, 0x0004f0000020d400ULL, 0x0000007500147306ULL, 0x000ee2000020d400ULL,
0x0000000d0c00720bULL, 0x002fe20003fdd000ULL, 0x00000100150c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x004fc4000001140eULL, 0x0000000149495812ULL, 0x000fe400078efcffULL,
0x0000001b1a00720bULL, 0x000fe20003fbd000ULL, 0x0000004c004d7306ULL, 0x000e62000020d400ULL,
0x0000000153532812ULL, 0x008fe400078efcffULL, 0x000000404500720bULL, 0x000fe40003f5d000ULL,
0x00000018ff407819ULL, 0x000fe4000001140cULL, 0x000000545354723eULL, 0x000fe200000010ffULL,
0x0000001500567306ULL, 0x000fe20000009400ULL, 0x0000000114144812ULL, 0x000fc400078efcffULL,
0x0000003e4100720bULL, 0x000fe40003f9d000ULL, 0x0000000109095812ULL, 0x000fc600078efcffULL,
0x0000001500757306ULL, 0x000ea20000005400ULL, 0x000000014d4d6812ULL, 0x002fe400078efcffULL,
0x0000000108082812ULL, 0x000fca00078efcffULL, 0x00000015000a7306ULL, 0x0002e2000000d400ULL,
0x0000000107074812ULL, 0x000fce00078efcffULL, 0x0000005500557306ULL, 0x000ee2000020d400ULL,
0x0001000016157824ULL, 0x002fe200078e00ffULL, 0x000000755600720bULL, 0x004fe40003fdd000ULL,
0x000000075b567812ULL, 0x000fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe20000011415ULL,
0x0000010016157824ULL, 0x000fe200078e00ffULL, 0x00000074000e7306ULL, 0x000fe20000209400ULL,
0x0000000856567812ULL, 0x000fca00078ef85bULL, 0x0000001056187824ULL, 0x000fe200078e00ffULL,
0x000000010a0a6812ULL, 0x008fe200078efcffULL, 0x00000074000d7306ULL, 0x000e620000205400ULL,
0x0000000155551812ULL, 0x000fe400078efcffULL, 0x0000000a0b0a723eULL, 0x000fe400000010ffULL,
0x000000145555723eULL, 0x000fc600000010ffULL, 0x00000040000f7306ULL, 0x000ff00000209400ULL,
0x00000040003e7306ULL, 0x000ea20000205400ULL, 0x0000000d0e00720bULL, 0x002fce0003f3d000ULL,
0x00000040000c7306ULL, 0x0003f0000020d400ULL, 0x00000074004c7306ULL, 0x000ee2000020d400ULL,
0x00000018ff407819ULL, 0x002fe40000011415ULL, 0x00000004ff157819ULL, 0x000fc4000001165bULL,
0x0000003e0f00720bULL, 0x004fc60003fbd000ULL, 0x0000000204157824ULL, 0x040fe200078e0215ULL,
0x00000016000e7306ULL, 0x000fe20000009400ULL, 0x0000000204047810ULL, 0x000fe40007ffe0ffULL,
0x00000001560f7824ULL, 0x140fe200078e0215ULL, 0x0000000256157810ULL, 0x040fe20007ffe015ULL,
0x0000001056567824ULL, 0x000fe200078e00ffULL, 0x000000014c4c1812ULL, 0x008fe400078efcffULL,
0x00000016003f7306ULL, 0x000e620000005400ULL, 0xfffffff018187812ULL, 0x000fc400078ee20fULL,
0x000000121100720bULL, 0x000fe40003f3d000ULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x000000010c0c5812ULL, 0x000fe200078efcffULL,
0x00000016000d7306ULL, 0x000ee2000000d400ULL, 0xfffffff056157812ULL, 0x000fe400078ee215ULL,
0x0000000c050b723eULL, 0x000fe200000010ffULL, 0x000000001818783bULL, 0x000ea40000000200ULL,
0x0000001015157824ULL, 0x000fc400078e00ffULL, 0x000000014e4e1812ULL, 0x000fe200078efcffULL,
0x0000004000167306ULL, 0x000fe20000209400ULL, 0x0000003f0e00720bULL, 0x002fe40003f3d000ULL,
0x000000484e48723eULL, 0x000fca00000010ffULL, 0x00000040003f7306ULL, 0x000e6c0000205400ULL,
0x000000010d0d1812ULL, 0x008fe400078efcffULL, 0x00000041003c7306ULL, 0x000ff00000209400ULL,
0x00000041003d7306ULL, 0x000ee20000205400ULL, 0x0000003f1600720bULL, 0x002fc40003f1d000ULL,
0x00000018ff457819ULL, 0x004fe20000011410ULL, 0x00000100134e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fc60000011411ULL, 0x00000041000e7306ULL, 0x000e62000020d400ULL,
0x00000018ff757819ULL, 0x000fe20000011412ULL, 0x000000461820723cULL, 0x000be20000041820ULL,
0x00000018ff4e7819ULL, 0x000fca000001144eULL, 0x0000004500417306ULL, 0x000fe20000209400ULL,
0x0000003d3c00720bULL, 0x008fe40003f5d000ULL, 0x0000006c6e46723eULL, 0x020fe200000010ffULL,
0x000000541824723cULL, 0x040be20000041824ULL, 0x0000006d6b47723eULL, 0x000fe200000010ffULL,
0x00010000176d7824ULL, 0x000fe400078e00ffULL, 0x0000004500447306ULL, 0x000ea60000205400ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x000000461838723cULL, 0x000b640000041838ULL,
0x0000004f4d54723eULL, 0x020fe200000010ffULL, 0x00010000134f7824ULL, 0x000fe200078e00ffULL,
0x000000010e0e2812ULL, 0x002fe200078efcffULL, 0x0000001700167306ULL, 0x000fe20000009400ULL,
0x0000004c4955723eULL, 0x000fc400000010ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x000000090849723eULL, 0x000fe400000010ffULL, 0x0000000d0e0e723eULL, 0x000fe200000010ffULL,
0x00000017006c7306ULL, 0x000e620000005400ULL, 0x000000444100720bULL, 0x004fe20003fdd000ULL,
0x00000054181c723cULL, 0x000fec000004181cULL, 0x00000074003d7306ULL, 0x000ff00000209400ULL,
0x00000074003e7306ULL, 0x000fe20000205400ULL, 0x0000006c1600720bULL, 0x002fc40003fbd000ULL,
0x0000004b6216723eULL, 0x000fca00000010ffULL, 0x00000074003f7306ULL, 0x0003f0000020d400ULL,
0x0000006d006b7306ULL, 0x000fe20000209400ULL, 0x00000018ff747819ULL, 0x002fce0000011413ULL,
0x0000006d006e7306ULL, 0x000e700000205400ULL, 0x00000045003c7306ULL, 0x000eb0000020d400ULL,
0x0000007400437306ULL, 0x000fe20000209400ULL, 0x0000006e6b00720bULL, 0x002fce0003f7d000ULL,
0x0000007400447306ULL, 0x000fe20000205400ULL, 0x000000013c3c6812ULL, 0x004fe400078efcffULL,
0x0000005c6000720bULL, 0x000fca0003fdd000ULL, 0x0000007400457306ULL, 0x0003f0000020d400ULL,
0x0000001700477306ULL, 0x0004e2000000d400ULL, 0x0000010017747824ULL, 0x002fe200078e00ffULL,
0x0000000106066812ULL, 0x000fc800078efcffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000040000f7306ULL, 0x000e62000020d400ULL, 0x000000614a17723eULL, 0x004fce00000010ffULL,
0x000000161834723cULL, 0x000b620000041834ULL, 0x0000007500407306ULL, 0x000fe20000209400ULL,
0x0000000147475812ULL, 0x008fca00078efcffULL, 0x0001000010167824ULL, 0x020fe200078e00ffULL,
0x000000515017723eULL, 0x000fe200000010ffULL, 0x0000007500417306ULL, 0x000fe20000205400ULL,
0x000000010f0f0812ULL, 0x002fe400078efcffULL, 0x00000018ff6b7819ULL, 0x000fe40000011416ULL,
0x000000646516723eULL, 0x000fe200000010ffULL, 0x0000010010647824ULL, 0x000fe200078e00ffULL,
0x0000000f070f723eULL, 0x000fe200000010ffULL, 0x0000007500427306ULL, 0x000fe6000020d400ULL,
0x00000018ff507819ULL, 0x000fe20000011464ULL, 0x00000016182c723cULL, 0x000b68000004182cULL,
0x0000007400627306ULL, 0x000fe60000209400ULL, 0x0001000011167824ULL, 0x020fe200078e00ffULL,
0x0000005e5217723eULL, 0x000fc800000010ffULL, 0x0000007400617306ULL, 0x000ff00000205400ULL,
0x00000074004a7306ULL, 0x000ff0000020d400ULL, 0x0000001100747306ULL, 0x000ff00000009400ULL,
0x0000001100757306ULL, 0x000e700000005400ULL, 0x0000006d00467306ULL, 0x000eb0000020d400ULL,
0x00000010006c7306ULL, 0x000fe20000009400ULL, 0x000000757400720bULL, 0x002fe20003f3d000ULL,
0x0000010011747824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fc40000011416ULL,
0x0000005d5f16723eULL, 0x000fe400000010ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000010006d7306ULL, 0x000e620000005400ULL, 0x0000000146463812ULL, 0x004fe400078efcffULL,
0x0000003e3d00720bULL, 0x000fe20003f7d000ULL, 0x000000161828723cULL, 0x000b620000041828ULL,
0x000000474646723eULL, 0x000fc600000010ffULL, 0x00000010004b7306ULL, 0x000ea6000000d400ULL,
0x000000585a16723eULL, 0x020fe400000010ffULL, 0x000000595717723eULL, 0x000fe400000010ffULL,
0x0000006d6c00720bULL, 0x002fe20003f5d000ULL, 0x0000006b006e7306ULL, 0x000fe20000205400ULL,
0x000000013f3f3812ULL, 0x000fc600078efcffULL, 0x000000161830723cULL, 0x000b680000041830ULL,
0x0000006b006d7306ULL, 0x000e660000209400ULL, 0x0001000012167824ULL, 0x020fe200078e00ffULL,
0x000000014b4b2812ULL, 0x004fc800078efcffULL, 0x0000006b00107306ULL, 0x000eb0000020d400ULL,
0x00000050006b7306ULL, 0x000fe20000209400ULL, 0x0000006e6d00720bULL, 0x002fce0003f1d000ULL,
0x00000050006c7306ULL, 0x000e6c0000205400ULL, 0x0000000110100812ULL, 0x004fe400078efcffULL,
0x0000007500647306ULL, 0x000fe20000209400ULL, 0x0000006c6b00720bULL, 0x002fce0003f9d000ULL,
0x0000007500657306ULL, 0x000e620000205400ULL, 0x00000018ff6c7819ULL, 0x000fe40000011416ULL,
0x000000001514783bULL, 0x000eaa0000000200ULL, 0x00000012006d7306ULL, 0x000ff00000009400ULL,
0x0000001200587306ULL, 0x000ee20000005400ULL, 0x000000656400720bULL, 0x002fce0003f5d000ULL,
0x0000001100517306ULL, 0x000e70000000d400ULL, 0x0000007500117306ULL, 0x000ea2000020d400ULL,
0x000000586d00720bULL, 0x008fce0003f1d000ULL, 0x00000074005f7306ULL, 0x000fe20000209400ULL,
0x0000000151511812ULL, 0x002fe200078efcffULL, 0x0000000a1438723cULL, 0x004f620000041838ULL,
0x000000444300720bULL, 0x000fca0003f3d000ULL, 0x00000074005d7306ULL, 0x000e620000205400ULL,
0x0000000111112812ULL, 0x000fe400078efcffULL, 0x000000616200720bULL, 0x000fe20003f5d000ULL,
0x000000481420723cULL, 0x000f620000041820ULL, 0x00000051113e723eULL, 0x000fc600000010ffULL,
0x0000006c00567306ULL, 0x000fe20000209400ULL, 0x0000000145451812ULL, 0x000fc600078efcffULL,
0x0000000e1434723cULL, 0x000f680000041834ULL, 0x0000006c00597306ULL, 0x000ea20000205400ULL,
0x0000005d5f00720bULL, 0x002fe40003fbd000ULL, 0x000000014a4a2812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x000fe40003f5d000ULL, 0x0000004a0647723eULL, 0x000fe200000010ffULL,
0x0000001200577306ULL, 0x0002e2000000d400ULL, 0x0000004b1006723eULL, 0x000fca00000010ffULL,
0x00000046142c723cULL, 0x000f64000004182cULL, 0x0000005000507306ULL, 0x000ee2000020d400ULL,
0x0000010012127824ULL, 0x002fe200078e00ffULL, 0x000000595600720bULL, 0x004fe40003fdd000ULL,
0x0000000142422812ULL, 0x000fe400078efcffULL, 0x00000018ff6d7819ULL, 0x000fe40000011412ULL,
0x0000007400527306ULL, 0x000e62000020d400ULL, 0x0000000157570812ULL, 0x008fc400078efcffULL,
0x000000080400780cULL, 0x000fca0003f05270ULL, 0x0000006c00537306ULL, 0x000ea2000020d400ULL,
0x0000000150504812ULL, 0x000fc800078efcffULL, 0x000000503c07723eULL, 0x000fc600000010ffULL,
0x00000013005e7306ULL, 0x000fe20000009400ULL, 0x0000000152525812ULL, 0x002fc600078efcffULL,
0x000000061428723cULL, 0x000b620000041828ULL, 0x000000523f3f723eULL, 0x000fc600000010ffULL,
0x00000013006b7306ULL, 0x000e620000005400ULL, 0x0000000153536812ULL, 0x004fc600078efcffULL,
0x0000003e1430723cULL, 0x000b640000041830ULL, 0x000000575306723eULL, 0x020fe400000010ffULL,
0x0000006d00587306ULL, 0x000ff00000209400ULL, 0x0000006d005a7306ULL, 0x000ea20000205400ULL,
0x0000006b5e00720bULL, 0x002fce0003f9d000ULL, 0x0000004f004d7306ULL, 0x000ff00000209400ULL,
0x0000004f00087306ULL, 0x000e620000205400ULL, 0x0000005a5800720bULL, 0x004fce0003fbd000ULL,
0x0000004e00057306ULL, 0x000ff00000209400ULL, 0x0000004e000a7306ULL, 0x000ea20000205400ULL,
0x000000084d00720bULL, 0x002fce0003f7d000ULL, 0x0000006d00127306ULL, 0x000e70000020d400ULL,
0x00000013004c7306ULL, 0x000ee2000000d400ULL, 0x0000000a0500720bULL, 0x004fce0003fdd000ULL,
0x0000004f004f7306ULL, 0x000ea2000020d400ULL, 0x0000000112125812ULL, 0x002fc800078efcffULL,
0x000000124207723eULL, 0x000fc600000010ffULL, 0x0000004e004e7306ULL, 0x000e62000020d400ULL,
0x000000014c4c4812ULL, 0x008fc600078efcffULL, 0x000000061424723cULL, 0x000b620000041824ULL,
0x000000014f4f3812ULL, 0x004fc800078efcffULL, 0x0000004c4f44723eULL, 0x000fe400000010ffULL,
0x000000014e4e6812ULL, 0x002fc800078efcffULL, 0x0000004e4545723eULL, 0x000fce00000010ffULL,
0x00000044141c723cULL, 0x000b62000004181cULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe11000007947ULL, 0x000fcc000383ffffULL, 0x000000032d2d7220ULL, 0x080fe40000410000ULL,
0x0000000320207220ULL, 0x080fe40000410000ULL, 0x0000000321217220ULL, 0x080fe40000410000ULL,
0x0000000338387220ULL, 0x080fe40000410000ULL, 0x0000000339397220ULL, 0x080fe40000410000ULL,
0x0000000334347220ULL, 0x000fc40000410000ULL, 0x0000000335357220ULL, 0x080fe40000410000ULL,
0x000000032c2c7220ULL, 0x080fe40000410000ULL, 0x0000000328047220ULL, 0x080fe40000410000ULL,
0x0000000325257220ULL, 0x0a0fe40000410000ULL, 0x000000032f087220ULL, 0x080fe40000410000ULL,
0x000000032a117220ULL, 0x000fc40000410000ULL, 0x000000032b107220ULL, 0x080fe40000410000ULL,
0x0000000322067220ULL, 0x080fe40000410000ULL, 0x0000000323137220ULL, 0x080fe40000410000ULL,
0x000000032e077220ULL, 0x080fe40000410000ULL, 0x00000003302a7220ULL, 0x080fe40000410000ULL,
0x00000003312f7220ULL, 0x000fc40000410000ULL, 0x0000000324127220ULL, 0x080fe40000410000ULL,
0x0000000326167220ULL, 0x080fe40000410000ULL, 0x0000000327177220ULL, 0x080fe40000410000ULL,
0x000000ffff2b7224ULL, 0x000fe400078e002dULL, 0x000000033a3a7220ULL, 0x080fe40000410000ULL,
0x000000033b3b7220ULL, 0x000fc40000410000ULL, 0x0000000336367220ULL, 0x080fe40000410000ULL,
0x0000000337377220ULL, 0x080fe40000410000ULL, 0x0000000329297220ULL, 0x080fe40000410000ULL,
0x00000003321b7220ULL, 0x080fe40000410000ULL, 0x0000000333337220ULL, 0x080fe40000410000ULL,
0x000000031c227220ULL, 0x000fc40000410000ULL, 0x000000031d1a7220ULL, 0x080fe40000410000ULL,
0x000000031e187220ULL, 0x080fe40000410000ULL, 0x000000031f197220ULL, 0x000fe40000410000ULL,
0x000000ffff277224ULL, 0x000fe400078e0020ULL, 0x000000ffff237224ULL, 0x000fe400078e0021ULL,
0x000000ffff247224ULL, 0x000fc400078e0038ULL, 0x000000ffff307224ULL, 0x000fe400078e0039ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0034ULL, 0x000000ffff267224ULL, 0x000fe400078e0035ULL,
0x000000ffff287224ULL, 0x000fe400078e002cULL, 0x000000ffff317224ULL, 0x000fe400078e0004ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000077047f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1e7224ULL, 0x000fc400078e0006ULL,
0x000000ffff1d7224ULL, 0x000fe400078e003aULL, 0x000000ffff2c7224ULL, 0x000fe400078e003bULL,
0x000000ffff207224ULL, 0x000fe400078e0036ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0037ULL,
0x000000ffff217224ULL, 0x000fe400078e0007ULL, 0x000000ffff257224ULL, 0x000fc400078e0008ULL,
0x000000ffff1c7224ULL, 0x000fc400078e0033ULL, 0x0000000000067805ULL, 0x002fca0000015200ULL,
0x0000040077097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040077097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000045b157824ULL, 0x000fe200078e00ffULL, 0x000000726600720cULL, 0x000fc80003f06070ULL,
0xfffffff015057812ULL, 0x000fca00078ec0ffULL, 0x0000008000147824ULL, 0x000fca00078e0205ULL,
0x0174000014047984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0x0000010066097824ULL, 0x000fe200078e0279ULL, 0x000000715b087211ULL, 0x040fe200078ff0ffULL,
0x000000025b337824ULL, 0x000fe400078e00ffULL, 0x00000002ff487424ULL, 0x000fe200078e00ffULL,
0x0000000970327217ULL, 0x000fe40007800000ULL, 0x0000000633337812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff0a7a19ULL, 0x000fe20000011608ULL, 0x0000000132327824ULL, 0x000fe200078e0a09ULL,
0x0000580033357a10ULL, 0x000fe20007ffe0ffULL, 0x000000016a097824ULL, 0x000fe200078e0233ULL,
0x0000000a730a7217ULL, 0x000fc40003800000ULL, 0x000000323500720cULL, 0x080fe20003f06070ULL,
0x00000001090e7824ULL, 0x140fe200078e0a32ULL, 0x000000320900720cULL, 0x000fe20003f26070ULL,
0x00000001350c7824ULL, 0x000fe400078e0a32ULL, 0x0000000a6f4d7224ULL, 0x000fe200078e02ffULL,
0x0000000e730e7217ULL, 0x040fe40003800000ULL, 0x0000000c730c7217ULL, 0x000fe40003800000ULL,
0x00000004ff0e7819ULL, 0x000fc4000001160eULL, 0x000000ff0c407207ULL, 0x000fe40000000000ULL,
0x000000ff0e0e7207ULL, 0x000fe40000800000ULL, 0x0000004d40097211ULL, 0x000fe400078fe0ffULL,
0x00000008080c7810ULL, 0x000fe20007ffe0ffULL, 0x000000014d0b7824ULL, 0x000fe200078e020eULL,
0x0000001033397812ULL, 0x000fe200078efcffULL, 0x0000600009087625ULL, 0x000fe200078e0048ULL,
0x00005a00ff0c7a19ULL, 0x000fc4000001160cULL, 0x0000580039377a10ULL, 0x000fe20007ffe0ffULL,
0x000060000b0a7625ULL, 0x000fe200078e0048ULL, 0x0000000c730c7217ULL, 0x000fe20003800000ULL,
0x0000000808467981ULL, 0x0046a2000c1e9500ULL, 0x00000020333b7812ULL, 0x000fc600078efcffULL,
0x000000080a4b7981ULL, 0x0002a2000c1e9500ULL, 0x0000000c6f4f7224ULL, 0x000fe400078e02ffULL,
0x0000000137087824ULL, 0x148fe400078e0a32ULL, 0x000000016a097824ULL, 0x000fe200078e0239ULL,
0x000000323700720cULL, 0x000fe20003f06070ULL, 0x000000010e0f7824ULL, 0x000fe200078e024fULL,
0x0000000873087217ULL, 0x000fe20003800000ULL, 0x00000001090a7824ULL, 0x002fe200078e0a32ULL,
0x000058003b3f7a10ULL, 0x000fe20007ffe0ffULL, 0x000060000f0e7625ULL, 0x000fe200078e0048ULL,
0x0000004f400d7211ULL, 0x000fc400078fe0ffULL, 0x000000ff08347207ULL, 0x000fe20000000000ULL,
0x000000013f3a7824ULL, 0x000fe200078e0a32ULL, 0x0000000a730a7217ULL, 0x000fe20003800000ULL,
0x000060000d0c7625ULL, 0x000fe200078e0048ULL, 0x000000320900720cULL, 0x080fe20003f26070ULL,
0x000000080e537981ULL, 0x0002e2000c1e9500ULL, 0x0000004d34097211ULL, 0x000fe200078fe0ffULL,
0x000000016a437824ULL, 0x000fe200078e023bULL, 0x00000004ff0a7819ULL, 0x000fe2000001160aULL,
0x000000080c427981ULL, 0x0002e2000c1e9500ULL, 0x000000323f00720cULL, 0x000fc40003f06070ULL,
0x0000003a733a7217ULL, 0x000fe20003800000ULL, 0x0000600009087625ULL, 0x000fc600078e0048ULL,
0x000000ff3a3a7207ULL, 0x000fe20000000000ULL, 0x00000001433c7824ULL, 0x040fe200078e0a32ULL,
0x0000000808367981ULL, 0x0002e4000c1e9500ULL, 0x000000ff0a0c7207ULL, 0x002fe40000800000ULL,
0x000000324300720cULL, 0x000fe40003f26070ULL, 0x0000003033437812ULL, 0x000fe200078efcffULL,
0x000000014d0b7824ULL, 0x000fe200078e020cULL, 0x0000004f340d7211ULL, 0x000fe200078fe0ffULL,
0x000000010c0f7824ULL, 0x000fe200078e024fULL, 0x0000003c733c7217ULL, 0x000fc40003800000ULL,
0x0000004d3a097211ULL, 0x000fe200078fe0ffULL, 0x000000016a517824ULL, 0x000fe200078e0243ULL,
0x00000004ff3c7819ULL, 0x000fe2000001163cULL, 0x000060000b0a7625ULL, 0x000fe200078e0048ULL,
0x0000580043457a10ULL, 0x000fc60007ffe0ffULL, 0x000060000d0c7625ULL, 0x000fc800078e0048ULL,
0x000060000f0e7625ULL, 0x080fe200078e0048ULL, 0x000000ff3c3e7207ULL, 0x000fe20000800000ULL,
0x000000080a3d7981ULL, 0x0002e4000c1e9500ULL, 0x0000600009087625ULL, 0x000fe400078e0048ULL,
0x000000080c387981ULL, 0x0002e4000c1e9500ULL, 0x0000000151447824ULL, 0x000fe400078e0a32ULL,
0x000000080e417981ULL, 0x0002e8000c1e9500ULL, 0x00000008083c7981ULL, 0x0002e2000c1e9500ULL,
0x0000004473447217ULL, 0x000fe20003800000ULL, 0x000000014d0b7824ULL, 0x002fe200078e023eULL,
0x0000004f3a0d7211ULL, 0x000fe200078fe0ffULL, 0x000000013e0f7824ULL, 0x000fc400078e024fULL,
0x0000000145087824ULL, 0x040fe200078e0a32ULL, 0x000000324500720cULL, 0x000fe20003f06070ULL,
0x000060000b0a7625ULL, 0x000fe200078e0048ULL, 0x000000325100720cULL, 0x000fe40003f26070ULL,
0x0000000873087217ULL, 0x000fe20003800000ULL, 0x000060000d0c7625ULL, 0x080fe200078e0048ULL,
0x00000004ff097819ULL, 0x000fe20000011644ULL, 0x000000080a477981ULL, 0x0002e4000c1e9500ULL,
0x000060000f0e7625ULL, 0x000fe200078e0048ULL, 0x000000ff08447207ULL, 0x000fe20000000000ULL,
0x000000080c3e7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff094a7207ULL, 0x000fc60000800000ULL,
0x000000080e497981ULL, 0x0002e2000c1e9500ULL, 0x0000004d44097211ULL, 0x000fe200078fe0ffULL,
0x000000014d0b7824ULL, 0x002fc800078e024aULL, 0x0000600009087625ULL, 0x000fc800078e0048ULL,
0x000060000b0a7625ULL, 0x000fe400078e0048ULL, 0x0000000808087981ULL, 0x0002e2000c1e9500ULL,
0x0000004f440d7211ULL, 0x000fc600078fe0ffULL, 0x000000080a0b7981ULL, 0x0002e2000c1e9500ULL,
0x000000014a0f7824ULL, 0x000fe400078e024fULL, 0x000060000d0c7625ULL, 0x000fc800078e0048ULL,
0x000060000f0e7625ULL, 0x000fe400078e0048ULL, 0x000000080c0c7981ULL, 0x0002e8000c1e9500ULL,
0x000000080e0f7981ULL, 0x0002e2000c1e9500ULL, 0xfffffff0404f7812ULL, 0x000fe400078ec0ffULL,
0x00000001334d7812ULL, 0x000fc600078efcffULL, 0x0000000132487824ULL, 0x000fe200078e024fULL,
0x0000000933097812ULL, 0x002fe200078efcffULL, 0x00000001ff407424ULL, 0x000fe400078e00ffULL,
0x0000000135557824ULL, 0x100fe200078e0a48ULL, 0x000058004d517a10ULL, 0x000fe40007ffe0ffULL,
0x00005800090d7a10ULL, 0x000fe40007ffe0ffULL, 0x0000005540557219ULL, 0x000fe200000006ffULL,
0x0000000151577824ULL, 0x000fc400078e0a48ULL, 0x000000010d5d7824ULL, 0x000fc600078e0a48ULL,
0x0000005740577219ULL, 0x040fe400000006ffULL, 0x0000005d405d7219ULL, 0x000fe400000006ffULL,
0x00000018336d7812ULL, 0x000fc800078efcffULL, 0x000058006d0e7a10ULL, 0x000fe40007ffe0ffULL,
0x0000001133757812ULL, 0x040fe400078efcffULL, 0x00000019336b7812ULL, 0x000fc800078efcffULL,
0x000058006b0a7a10ULL, 0x000fe40007ffe0ffULL, 0x00000021335f7812ULL, 0x000fe400078efcffULL,
0xfffffff044447812ULL, 0x000fe400078ec0ffULL, 0x000058005f657a10ULL, 0x000fc60007ffe0ffULL,
0x00000001325e7824ULL, 0x000fc800078e0244ULL, 0x0000000145507824ULL, 0x000fca00078e0a5eULL,
0x0000005040507219ULL, 0x000fe400000006ffULL, 0x0000541046467816ULL, 0x004fe4000000004bULL,
0x00000008334b7812ULL, 0x000fc800078efcffULL, 0x000058004b4f7a10ULL, 0x000fe40007ffe0ffULL,
0x0000004655ff7212ULL, 0x000fc6000780c0ffULL, 0x000000014f597824ULL, 0x000fe200078e0a48ULL,
0x000000323500720cULL, 0x000fc80000701470ULL, 0x0000005940597219ULL, 0x000fe400000006ffULL,
0x0000004657ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004659ff7212ULL, 0x080fe4000784c0ffULL,
0x000000465dff7212ULL, 0x000fe4000782c0ffULL, 0x000000323300720cULL, 0x000fe40000701070ULL,
0xfffffff034467812ULL, 0x000fc400078ec0ffULL, 0x0000541042427816ULL, 0x008fe40000000053ULL,
0xff80000027277808ULL, 0x000fe20000000000ULL, 0x0000000132467824ULL, 0x000fe200078e0246ULL,
0x0000004255ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004259ff7212ULL, 0x080fe400078cc0ffULL,
0x000000425dff7212ULL, 0x000fe2000780c0ffULL, 0x00000001374a7824ULL, 0x100fe200078e0a46ULL,
0x000000323500720cULL, 0x080fe20002781470ULL, 0x000000010e527824ULL, 0x000fe200078e0a46ULL,
0x000000324f00720cULL, 0x000fc400037c1470ULL, 0x000000320d00720cULL, 0x080fe40000701470ULL,
0xfffffff03a487812ULL, 0x000fe400078ec0ffULL, 0x000000323300720cULL, 0x080fe40002781070ULL,
0x000000324b00720cULL, 0x080fe400037c1070ULL, 0x000000320900720cULL, 0x000fe40000701070ULL,
0x0000004a404a7219ULL, 0x000fc400000006ffULL, 0x0000005240527219ULL, 0x000fe400000006ffULL,
0x0000004257ff7212ULL, 0x000fe400078ac0ffULL, 0x00005410363d7816ULL, 0x000fe2000000003dULL,
0x0000000132487824ULL, 0x000fe200078e0248ULL, 0x0000580075427a10ULL, 0x000fe40007ffe0ffULL,
0x000000320d00720cULL, 0x000fe40000f21470ULL, 0x0000541038417816ULL, 0x000fc40000000041ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff8000001d1d7808ULL, 0x000fe40003000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0x0000003d4aff7212ULL, 0x040fe4000788c0ffULL,
0x000000414aff7212ULL, 0x080fe400078cc0ffULL, 0x0000004152ff7212ULL, 0x000fe2000780c0ffULL,
0x00000001424e7824ULL, 0x100fe200078e0a46ULL, 0x000000320900720cULL, 0x080fe20000f21070ULL,
0x000000010a5a7824ULL, 0x000fe200078e0a46ULL, 0x000000325100720cULL, 0x080fe20001f61470ULL,
0x000000013f587824ULL, 0x000fe200078e0a48ULL, 0x000000325100720cULL, 0x000fc40002fa1470ULL,
0x000000324f00720cULL, 0x080fe40001741470ULL, 0x000000323700720cULL, 0x0c0fe40002781470ULL,
0x000000323700720cULL, 0x080fe400037c1470ULL, 0x000000320e00720cULL, 0x000fe40000701470ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0x00000028335d7812ULL, 0x000fc400078efcffULL,
0x0000002933597812ULL, 0x000fe400078efcffULL, 0x000000324d00720cULL, 0x0c0fe40001f61070ULL,
0x000000324d00720cULL, 0x080fe40002fa1070ULL, 0x000000324b00720cULL, 0x080fe40001741070ULL,
0x000000323900720cULL, 0x0c0fe40002721070ULL, 0x000000323900720cULL, 0x000fc400037c1070ULL,
0x000000326d00720cULL, 0x000fe40000701070ULL, 0x0000004e404e7219ULL, 0x040fe400000006ffULL,
0x0000005a405a7219ULL, 0x040fe400000006ffULL, 0x0000005840587219ULL, 0x000fe400000006ffULL,
0x000054103c477816ULL, 0x000fe40000000047ULL, 0x000054103e497816ULL, 0x000fc40000000049ULL,
0x000058005d637a10ULL, 0x000fe40007ffe0ffULL, 0x0000580059617a10ULL, 0x000fe40007ffe0ffULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff80000013137808ULL, 0x000fe40002800000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fc40000800000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0x0000003d4eff7212ULL, 0x080fe4000786c0ffULL, 0x0000003d52ff7212ULL, 0x080fe400078ac0ffULL,
0x0000003d5aff7212ULL, 0x000fe4000784c0ffULL, 0x000000414eff7212ULL, 0x000fc4000788c0ffULL,
0x000000415aff7212ULL, 0x000fe4000782c0ffULL, 0x0000004758ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004958ff7212ULL, 0x000fe2000780c0ffULL, 0x00000001655c7824ULL, 0x100fe200078e0a48ULL,
0x000000324200720cULL, 0x0c0fe20001f61470ULL, 0x0000000163547824ULL, 0x100fe200078e0a48ULL,
0x000000324200720cULL, 0x080fe20002781470ULL, 0x0000000161567824ULL, 0x000fe200078e0a48ULL,
0x000000320e00720cULL, 0x000fc40002fa1470ULL, 0x000000320a00720cULL, 0x0c0fe40001741470ULL,
0x000000320a00720cULL, 0x080fe40000f21470ULL, 0x000000323f00720cULL, 0x0c0fe400037c1470ULL,
0x000000323f00720cULL, 0x000fe40000701470ULL, 0x0000003133577812ULL, 0x040fe400078efcffULL,
0x0000003833557812ULL, 0x000fc400078efcffULL, 0x0000003933537812ULL, 0x000fe400078efcffULL,
0x000000327500720cULL, 0x0c0fe40001f61070ULL, 0x000000327500720cULL, 0x080fe40002781070ULL,
0x000000326d00720cULL, 0x080fe40002fa1070ULL, 0x000000326b00720cULL, 0x0c0fe40001741070ULL,
0x000000326b00720cULL, 0x000fc40000f21070ULL, 0x000000323b00720cULL, 0x0c0fe400037c1070ULL,
0x000000323b00720cULL, 0x000fe40000701070ULL, 0x0000005c405c7219ULL, 0x040fe400000006ffULL,
0x0000005440547219ULL, 0x040fe400000006ffULL, 0x0000005640567219ULL, 0x000fe400000006ffULL,
0x00005410080b7816ULL, 0x000fc4000000000bULL, 0x0000580057347a10ULL, 0x000fe40007ffe0ffULL,
0x00005800553a7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580053447a10ULL, 0x000fe40007ffe0ffULL,
0xff80000026267808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fc40002800000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff80000031317808ULL, 0x000fe40003000000ULL,
0xff80000011117808ULL, 0x000fe40000000000ULL, 0x000000475cff7212ULL, 0x080fe4000786c0ffULL,
0x0000004754ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004756ff7212ULL, 0x000fe400078ac0ffULL,
0x000000495cff7212ULL, 0x080fe4000784c0ffULL, 0x0000004954ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004956ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000b50ff7212ULL, 0x000fe2000780c0ffULL,
0x00000001344c7824ULL, 0x100fe200078e0a5eULL, 0x000000326500720cULL, 0x0c0fe20001f61470ULL,
0x000000013a467824ULL, 0x100fe200078e0a5eULL, 0x000000326500720cULL, 0x080fe20001741470ULL,
0x0000000144487824ULL, 0x000fe200078e0a5eULL, 0x000000326300720cULL, 0x000fc40002781470ULL,
0x000000326300720cULL, 0x080fe40000f21470ULL, 0x000000326100720cULL, 0x0c0fe40002fa1470ULL,
0x000000326100720cULL, 0x080fe400037c1470ULL, 0x000000324500720cULL, 0x080fe40000701470ULL,
0x000000325f00720cULL, 0x0c0fe40001f61070ULL, 0x000000325f00720cULL, 0x000fc40001741070ULL,
0x000000325d00720cULL, 0x0c0fe40002781070ULL, 0x000000325d00720cULL, 0x080fe40000f21070ULL,
0x000000325900720cULL, 0x0c0fe40002fa1070ULL, 0x000000325900720cULL, 0x080fe400037c1070ULL,
0x000000324300720cULL, 0x000fe40000701070ULL, 0x0000004c404c7219ULL, 0x000fc400000006ffULL,
0x0000004640467219ULL, 0x040fe400000006ffULL, 0x0000004840487219ULL, 0x000fe400000006ffULL,
0x000054100c0f7816ULL, 0x000fe4000000000fULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000010107808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002000000ULL,
0xff8000001b1b7808ULL, 0x000fe40000800000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0xff8000001c1c7808ULL, 0x000fe40003000000ULL, 0xff80000012127808ULL, 0x000fe40000000000ULL,
0x0000000b4cff7212ULL, 0x080fe4000786c0ffULL, 0x0000000b46ff7212ULL, 0x000fc4000784c0ffULL,
0x0000000b48ff7212ULL, 0x000fe4000788c0ffULL, 0x0000000f50ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000f4cff7212ULL, 0x080fe400078ac0ffULL, 0x0000000f46ff7212ULL, 0x080fe400078cc0ffULL,
0x0000000f48ff7212ULL, 0x000fe4000780c0ffULL, 0x000000324500720cULL, 0x000fc40000f21470ULL,
0x000000323400720cULL, 0x0c0fe40001f61470ULL, 0x000000323400720cULL, 0x080fe40002fa1470ULL,
0x000000323a00720cULL, 0x0c0fe40001741470ULL, 0x000000323a00720cULL, 0x080fe400037c1470ULL,
0x000000324400720cULL, 0x0c0fe40002781470ULL, 0x000000324400720cULL, 0x000fc40000701470ULL,
0x000000324300720cULL, 0x080fe40000f21070ULL, 0x000000325700720cULL, 0x0c0fe40001f61070ULL,
0x000000325700720cULL, 0x080fe40002fa1070ULL, 0x000000325500720cULL, 0x0c0fe40001741070ULL,
0x000000325500720cULL, 0x080fe400037c1070ULL, 0x000000325300720cULL, 0x000fc40002781070ULL,
0x000000325300720cULL, 0x000fe40000701070ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff8000001a1a7808ULL, 0x000fe40002000000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff80000017177808ULL, 0x000fc40002800000ULL,
0xff80000018187808ULL, 0x000fe40003000000ULL, 0xff80000019197808ULL, 0x000fc40000000000ULL,
0x000000270400720bULL, 0x004fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fe40003f3e000ULL,
0x0000000427047208ULL, 0x000fe40004000000ULL, 0x000000051e087208ULL, 0x000fe40004800000ULL,
0x000000230400720bULL, 0x000fc40003f1e000ULL, 0x000000130800720bULL, 0x000fe40003f3e000ULL,
0x0000000423057208ULL, 0x000fe40004000000ULL, 0x0000000813087208ULL, 0x000fe40004800000ULL,
0x000000240500720bULL, 0x000fe40003f1e000ULL, 0x0000001d0800720bULL, 0x000fe40003f3e000ULL,
0x0000000524057208ULL, 0x000fc40004000000ULL, 0x000000081d097208ULL, 0x000fe40004800000ULL,
0x000000300500720bULL, 0x000fe40003f1e000ULL, 0x0000002c0900720bULL, 0x000fe40003f3e000ULL,
0x0000000530057208ULL, 0x000fe40004000000ULL, 0x000000092c097208ULL, 0x000fe40004800000ULL,
0x0000002e0500720bULL, 0x000fc40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000052e057208ULL, 0x000fe40004000000ULL, 0x0000000920047208ULL, 0x000fe40004800000ULL,
0x000000260500720bULL, 0x000fe40003f1e000ULL, 0x0000001f0400720bULL, 0x000fe40003f3e000ULL,
0x0000000526057208ULL, 0x000fc40004000000ULL, 0x000000041f047208ULL, 0x000fe40004800000ULL,
0x000000280500720bULL, 0x000fe40003f1e000ULL, 0x000000210400720bULL, 0x000fe40003f3e000ULL,
0x0000000528087208ULL, 0x000fe40004000000ULL, 0x0000000421047208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fc40003f1e000ULL, 0x000000250400720bULL, 0x000fe40003f3e000ULL,
0x000000082b087208ULL, 0x000fe40004000000ULL, 0x0000000425047208ULL, 0x000fe40004800000ULL,
0x000000310800720bULL, 0x000fe40003f1e000ULL, 0x000000110400720bULL, 0x000fe40003f3e000ULL,
0x0000000831087208ULL, 0x000fc40004000000ULL, 0x0000000411057208ULL, 0x000fe40004800000ULL,
0x000000290800720bULL, 0x000fe40003f1e000ULL, 0x000000100500720bULL, 0x000fe40003f3e000ULL,
0x0000000829097208ULL, 0x000fe40004000000ULL, 0x0000000510047208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fc40003f1e000ULL, 0x0000001b0400720bULL, 0x000fe40003f3e000ULL,
0x000000092a087208ULL, 0x000fe40004000000ULL, 0x000000041b057208ULL, 0x000fe40004800000ULL,
0x0000002f0800720bULL, 0x000fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fe40003f3e000ULL,
0x000000082f097208ULL, 0x000fc40004000000ULL, 0x000000051c057208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x000000160500720bULL, 0x000fe40003f3e000ULL,
0x0000000912047208ULL, 0x000fe40004000000ULL, 0x0000000516087208ULL, 0x000fe40004800000ULL,
0x0000002d0400720bULL, 0x000fc40003f1e000ULL, 0x000000170800720bULL, 0x000fe40003f3e000ULL,
0x000000042d057208ULL, 0x000fe40004000000ULL, 0x0000000817097208ULL, 0x000fe40004800000ULL,
0x000000220500720bULL, 0x000fe40003f1e000ULL, 0x000000180900720bULL, 0x000fe40003f3e000ULL,
0x0000000522057208ULL, 0x000fc40004000000ULL, 0x0000000918047208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x000000190400720bULL, 0x000fe40003f3e000ULL,
0x000000051a0a7208ULL, 0x000fe40004000000ULL, 0x00000004190c7208ULL, 0x000fe20004800000ULL,
0x000016f27f007947ULL, 0x000fec000b800000ULL, 0x0c401f000a047f89ULL, 0x0004e400000e0000ULL,
0x000000040a00720bULL, 0x008fc80003f1e000ULL, 0x0000000a040d7208ULL, 0x000fe20004000000ULL,
0x000017227f007947ULL, 0x000fea000b800000ULL, 0x0c401f000c047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000e6800000e0000ULL, 0x0c401f0007327f89ULL, 0x000ea200000e0000ULL,
0x000000040c00720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x002fe40003f3e000ULL,
0x0000000c04087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f000d047f89ULL, 0x000e6200000e0000ULL, 0x000000320700720bULL, 0x004fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000ea200000e0000ULL, 0x0000000732327208ULL, 0x000fc60004000000ULL,
0x0c201f00090a7f89ULL, 0x000ee800000e0000ULL, 0x0c201f0032337f89ULL, 0x0002e400000e0000ULL,
0x000000040d00720bULL, 0x002fe40003f1e000ULL, 0x000000050800720bULL, 0x004fe40003f3e000ULL,
0x0000000d04047208ULL, 0x000fc40004000000ULL, 0x0000000a0900720bULL, 0x008fe40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x000000090a067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x000000035bff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b280e7823ULL, 0x102fe20000010807ULL,
0x000000333200720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b2a287823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b052a7820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b13137823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b2c2c7823ULL, 0x000fe2000001082aULL, 0x0000002700087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b23237823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082aULL,
0x0000002300097308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b21217823ULL, 0x000fe4000001082aULL,
0x3fb8aa3b260d7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x00000024000a7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b12237823ULL, 0x102fe40000010807ULL, 0x00000004ff127e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b25257823ULL, 0x000fe2000001082aULL, 0x00000030000b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2d247823ULL, 0x108fe20000010807ULL, 0x000000080908723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b29277823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b31267823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2f297823ULL, 0x100fe20000010807ULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b22227823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1a077823ULL, 0x000fe20000010807ULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x0000000a0b0a723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b16167823ULL, 0x000fc4000001082aULL, 0x3fb8aa3b17177823ULL, 0x000fc8000001082aULL,
0x0000001d001d7308ULL, 0x000ff00000000800ULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x0000001e1309723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b101e7823ULL, 0x000fcc000001082aULL,
0x00000020000f7308ULL, 0x0005f00000000800ULL, 0x00000021002d7308ULL, 0x0007e20000000800ULL,
0x3f8000001220783eULL, 0x004fe400000010ffULL, 0x0000001d2c0b723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b111d7823ULL, 0x000fe2000001082aULL, 0x00000002ff2c7819ULL, 0x000fe2000001165bULL,
0x000000ffff2f7224ULL, 0x000fc400078e0020ULL, 0x0000002e000c7308ULL, 0x000fe20000000800ULL,
0x000000ffff217224ULL, 0x008fe200078e0020ULL, 0x000000012c1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000082c357824ULL, 0x040fe200078e00ffULL, 0x000000082c377810ULL, 0x000fc80007ffe0ffULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x000000200810723cULL, 0x000f6e00000418ffULL,
0x0000001f002e7308ULL, 0x000eb00000000800ULL, 0x0000002b002b7308ULL, 0x000ee20000000800ULL,
0x0000000c0d0c723eULL, 0x002fce00000010ffULL, 0x0000002500307308ULL, 0x0002620000000800ULL,
0x0000000f2e0d723eULL, 0x004fe200000010ffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0020ULL,
0x0000000e2b0e723eULL, 0x008fca00000010ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000082c2b7824ULL, 0x040fe400078e00ffULL, 0x000000082c257824ULL, 0x002fc600078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe400078ee21aULL, 0x0000002d300f723eULL, 0x000fe200000010ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000082c2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fc800078ee22cULL, 0x000000200c10723cULL, 0x020b640000041810ULL,
0x0000002800287308ULL, 0x000fea0000000800ULL, 0x3fb8aa3b18217823ULL, 0x120fe4000001082aULL,
0x3fb8aa3b192a7823ULL, 0x000fe2000001082aULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x000000262718723eULL, 0x002fe200000010ffULL, 0x000000082c277824ULL, 0x000fc400078e00ffULL,
0x000000082c267824ULL, 0x000fc800078e00ffULL, 0x0000001d001d7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x00000028291a723eULL, 0x004fe200000010ffULL,
0x0000000837287824ULL, 0x000fca00078e00ffULL, 0xfffffff828377812ULL, 0x000fe200078ee237ULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x0000001c001c7308ULL, 0x000ea20000000800ULL,
0x0000001d1e19723eULL, 0x002fc400000010ffULL, 0x000000032c1d7810ULL, 0x040fe40007ffe0ffULL,
0x000000042c1e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff826297812ULL, 0x000fe200078ee21dULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee21eULL,
0x0000001b1c1b723eULL, 0x004fca00000010ffULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x000000022c1c7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff827277812ULL, 0x000fe400078ee21cULL,
0x0000002e181c723cULL, 0x000b620000041810ULL, 0x0000002300237308ULL, 0x000fec0000000800ULL,
0x000000082c2f7824ULL, 0x060fe200078e00ffULL, 0x000000052c107810ULL, 0x040fe20007ffe0ffULL,
0x0000002400247308ULL, 0x000ea20000000800ULL, 0x000000062c117810ULL, 0x000fc40007ffe0ffULL,
0xffffffff2c127810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82f2f7812ULL, 0x000fe400078ee210ULL,
0xfffffff826317812ULL, 0x000fe200078ee211ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0xfffffff835357812ULL, 0x000fe400078ee212ULL, 0x000000212a13723eULL, 0x002fe200000010ffULL,
0x000000ffff217224ULL, 0x000fc800078e0020ULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x000000232410723eULL, 0x004fce00000010ffULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000220712723eULL, 0x002fe400000010ffULL,
0x0001100000227811ULL, 0x000fc400078e58ffULL, 0x0000003233077208ULL, 0x000fc60004800000ULL,
0x0000001025257824ULL, 0x100fe400078e0222ULL, 0x000000102b2b7824ULL, 0x100fe400078e0222ULL,
0x0000001027277824ULL, 0x100fe400078e0222ULL, 0x0000001029297824ULL, 0x100fe200078e0222ULL,
0x000000161711723eULL, 0x004fe200000010ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0222ULL,
0x0000000c15167812ULL, 0x000fe200078ec0ffULL, 0x000000102f2f7824ULL, 0x000fc400078e0222ULL,
0x0000001031317824ULL, 0x000fe400078e0222ULL, 0x00000020101c723cULL, 0x000f62000004181cULL,
0x0000000125257824ULL, 0x000fe400078e0216ULL, 0x00000001162b7824ULL, 0x040fe400078e022bULL,
0x0000000116277824ULL, 0x040fe200078e0227ULL, 0x0000000825007388ULL, 0x0003e20000000800ULL,
0x0000001035357824ULL, 0x100fe400078e0222ULL, 0x0000000116297824ULL, 0x000fe200078e0229ULL,
0x0000000a2b007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x000fc400078e0222ULL,
0x00000001162d7824ULL, 0x040fe200078e022dULL, 0x0000000c27007388ULL, 0x0003e20000000800ULL,
0x00000001162f7824ULL, 0x040fe400078e022fULL, 0x0000000116317824ULL, 0x040fe200078e0231ULL,
0x0000000e29007388ULL, 0x0003e20000000800ULL, 0x0000000116357824ULL, 0x040fe400078e0235ULL,
0x0000000116167824ULL, 0x000fe200078e0237ULL, 0x000000182d007388ULL, 0x0003e40000000800ULL,
0x000000ffff1d7224ULL, 0x020fc400078e001eULL, 0x0000001a2f007388ULL, 0x0003e80000000800ULL,
0x0000001031007388ULL, 0x0003e80000000800ULL, 0x0000001235007388ULL, 0x0003e80000000800ULL,
0x0000000916007388ULL, 0x0003e80000000800ULL, 0x0004000b2b007388ULL, 0x0003e80000000800ULL,
0x0004000d27007388ULL, 0x0003e80000000800ULL, 0x0004000f29007388ULL, 0x0003e80000000800ULL,
0x000400192d007388ULL, 0x0003e80000000800ULL, 0x0004001b2f007388ULL, 0x0003e80000000800ULL,
0x0004001131007388ULL, 0x0003e80000000800ULL, 0x0004001335007388ULL, 0x0003e80000000800ULL,
0x0170000414008388ULL, 0x0003e80000000c00ULL, 0x0172001c14008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007aff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008007aff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010007aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000166667810ULL, 0x000fe20007ffe0ffULL,
0x000018007aff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff637224ULL, 0x000fc400078e0068ULL,
0x000000786600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff9be000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x0001874000157802ULL, 0x000fc40000000f00ULL, 0x00000f4000007944ULL, 0x012fea0003c00000ULL,
0xfffe9f5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x0001879000157802ULL, 0x000fc40000000f00ULL,
0x00000ef000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff167224ULL, 0x000fe200078e003cULL,
0xfffe9f8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0035ULL,
0x00018800003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x012fea0003c00000ULL,
0xfffea04000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0035ULL,
0x00018860003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000dd000007944ULL, 0x012fea0003c00000ULL,
0xfffea14000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000bULL,
0x000188d0003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e000cULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000d6000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xfffea54000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000bULL,
0x00018940003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000cf000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e003cULL, 0xfffea50000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x000189a000157802ULL, 0x000fc40000000f00ULL, 0x00000ce000007944ULL, 0x012fea0003c00000ULL,
0xfffed43000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x000189f000157802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e003cULL,
0xfffed46000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0040ULL,
0x00018a60003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000bd000007944ULL, 0x012fea0003c00000ULL,
0xfffed53000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0040ULL,
0x00018ac0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000b7000007944ULL, 0x012fea0003c00000ULL,
0xfffed63000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0012ULL,
0x00018b30003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0013ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000b0000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xfffeda4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0012ULL,
0x00018ba0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000a9000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e003cULL, 0xfffeda0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00018c0000157802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x014fea0003c00000ULL,
0xffff070000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x00018c5000157802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff077224ULL, 0x000fe200078e003cULL,
0xffff074000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e003aULL,
0x00018cc0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000097000007944ULL, 0x014fea0003c00000ULL,
0xffff081000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e003aULL,
0x00018d20003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000091000007944ULL, 0x014fea0003c00000ULL,
0xffff091000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00018d90003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0017ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xffff0d2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00018e00003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e003cULL, 0xffff0ce000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x004fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00018e6000157802ULL, 0x000fc40000000f00ULL, 0x0000082000007944ULL, 0x018fea0003c00000ULL,
0xffff3a6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x00018eb000157802ULL, 0x000fc40000000f00ULL,
0x000007d000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff117224ULL, 0x000fe200078e003cULL,
0xffff3aa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0x00018f20003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x018fea0003c00000ULL,
0xffff3b6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0x00018f80003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x018fea0003c00000ULL,
0xffff3c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0007ULL,
0x00018ff0003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e000eULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000064000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xffff406000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0007ULL,
0x00019060003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e003cULL, 0xffff402000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x000190d000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000052000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0033ULL,
0xffffe8b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x006fe200078e000cULL,
0x0001915000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x000004a000007944ULL, 0x010fea0003c00000ULL, 0x000000330c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0006ULL, 0x000191d000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c330c7208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x000000330600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0007ULL, 0x0001925000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000633067208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x000000330700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e000dULL, 0x000192d000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000733327208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000330d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e000cULL, 0x0001935000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000d33047208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x000000330c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0006ULL, 0x000193d000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c33057208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000330600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0032ULL, 0x0001945000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000633067208ULL, 0x000fe20004000000ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe6a000007947ULL, 0x000fea000383ffffULL,
0x018000000d027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000d00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0dff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000d037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000d00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe6a1002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000e00007348ULL, 0x000fe80003800000ULL, 0x0c00000b0a337389ULL, 0x0002a200000e0033ULL,
0xfffe69d008007950ULL, 0x000fea0003c3ffffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x00000014153c7389ULL, 0x0002a400000e003eULL, 0x000000ffff147224ULL, 0x002fc400078e003dULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffe698014007950ULL, 0x000fea0003c3ffffULL,
0x000000011400780cULL, 0x000fe20003f45070ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x00000000ff157424ULL, 0x000fce00078e00ffULL,
0x00000000003c7806ULL, 0x000fc800050e0100ULL, 0x0000003d3c3c7212ULL, 0x000fe200078ec0ffULL,
0xfffe691014007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000368ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d60ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e20ULL, 0x00000000000007c0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015e0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001684ULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000019780ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b000ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b050ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b3d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001680ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019980ULL, 0x0000000000019980ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001b000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b3d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_80_cubin_len = 111792;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
