/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000195d0ULL, 0x0000000000019250ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000017760ULL, 0x0000000000000170ULL, 0x000b0022000004daULL, 0x00000000000178d0ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000017910ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000017960ULL, 0x0000000000000120ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000017a80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001776000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x005c680400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080940828808081ULL, 0x8408288080950828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808084920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001776000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x9408288080920828ULL,
0x2880809508288080ULL, 0x8280162880809008ULL, 0x0000000003102880ULL, 0x8080909200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x000178d000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x9508288080940828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808095920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000017800000000ULL, 0x0001791000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8094288080950900ULL, 0x0000000000002880ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x9408288080950828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808094920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000020800000000ULL, 0x0001796000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL,
0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL,
0x0000007b00043704ULL, 0x0000001800080a04ULL, 0x0060190300600160ULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0021f00000500008ULL, 0x00000000000c1704ULL,
0x0011f00000480007ULL, 0x00000000000c1704ULL, 0x0081f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL,
0x0134290400000900ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x000003d0000002c0ULL, 0x0000269000000580ULL, 0x0000286000002740ULL, 0x00002e40000029c0ULL,
0x00002ec000002e70ULL, 0x00005db000002f10ULL, 0x00005f7000005e40ULL, 0x00006560000060d0ULL,
0x000065e000006590ULL, 0x000092a000006630ULL, 0x0000947000009340ULL, 0x00009a60000095d0ULL,
0x00009ae000009a90ULL, 0x0000c80000009b30ULL, 0x0000c9c00000c8a0ULL, 0x0000cfa00000cb20ULL,
0x0000d0200000cfd0ULL, 0x0000f1800000d070ULL, 0x000160100000f190ULL, 0x0001606000016050ULL,
0x0001608000016070ULL, 0x00016100000160e0ULL, 0x00016da000016120ULL, 0x00016e3000016de0ULL,
0x00016ec000016e70ULL, 0x00016f6000016f10ULL, 0x00016ff000016fa0ULL, 0x0001708000017030ULL,
0x00017120000170d0ULL, 0x000171b000017160ULL, 0x00017240000171f0ULL, 0x000172e000017290ULL,
0x0001737000017320ULL, 0x00017400000173b0ULL, 0x000174a000017450ULL, 0x0001756000017500ULL,
0x00017620000175c0ULL, 0x000176e000017680ULL, 0x0440390400017740ULL, 0x000000ff00000390ULL,
0x003f01000000f600ULL, 0x0000000d00000430ULL, 0x003f01200000f608ULL, 0x0000000d000004a0ULL,
0x003f01200000f688ULL, 0x0000000d000004e0ULL, 0x003f01200000f6a8ULL, 0x0000000d00000530ULL,
0x003f01200000f6c8ULL, 0x000000ff00000920ULL, 0x003f01070000f600ULL, 0x0000000300000b10ULL,
0x003f010200000004ULL, 0x0000000300000bc0ULL, 0x003f010100000000ULL, 0x0000000300001400ULL,
0x003f01070000f6a8ULL, 0x0000000300001550ULL, 0x003f01010000f6a8ULL, 0x00000008000015b0ULL,
0x003f01010000f6c8ULL, 0x0000001400001760ULL, 0x003f01050000f6ccULL, 0x0000001400001940ULL,
0x003f01050000f6ccULL, 0x0000000f00002280ULL, 0x003f01070000f6b0ULL, 0x0000000f00002330ULL,
0x003f01010000f6b0ULL, 0x0000000800002390ULL, 0x003f01010000f608ULL, 0x00000008000023b0ULL,
0x003f01050000f60cULL, 0x0000000800002580ULL, 0x003f01050000f60cULL, 0x0000002800002ba0ULL,
0x003f01050000f6acULL, 0x0000002800002d70ULL, 0x003f01050000f6acULL, 0x0000000c00004f20ULL,
0x003f010100000000ULL, 0x0000005c00004f80ULL, 0x003f01010000f688ULL, 0x0000000500004fb0ULL,
0x003f010500000004ULL, 0x0000000500005170ULL, 0x003f010500000004ULL, 0x0000000b000059c0ULL,
0x003f01070000f6a8ULL, 0x0000000b00005a90ULL, 0x003f01010000f6a8ULL, 0x0000000800005af0ULL,
0x003f01010000f628ULL, 0x0000000800005b10ULL, 0x003f01050000f62cULL, 0x0000000800005ce0ULL,
0x003f01050000f62cULL, 0x00000034000062c0ULL, 0x003f01050000f6b4ULL, 0x0000003400006490ULL,
0x003f01050000f6b4ULL, 0x0000001400008410ULL, 0x003f010100000000ULL, 0x0000000e00008470ULL,
0x003f01010000f690ULL, 0x00000005000084a0ULL, 0x003f010500000004ULL, 0x0000000500008660ULL,
0x003f010500000004ULL, 0x0000000b00008eb0ULL, 0x003f01070000f6b0ULL, 0x0000000b00008f80ULL,
0x003f01010000f6b0ULL, 0x0000000800008fe0ULL, 0x003f01010000f648ULL, 0x0000000800009000ULL,
0x003f01050000f64cULL, 0x00000008000091d0ULL, 0x003f01050000f64cULL, 0x00000036000097c0ULL,
0x003f01050000f6acULL, 0x0000003600009990ULL, 0x003f01050000f6acULL, 0x0000000c0000b900ULL,
0x003f010100000000ULL, 0x0000000b0000b960ULL, 0x003f01010000f698ULL, 0x000000050000b990ULL,
0x003f010500000004ULL, 0x000000050000bb50ULL, 0x003f010500000004ULL, 0x000000090000c460ULL,
0x003f01070000f6a8ULL, 0x000000090000c4f0ULL, 0x003f01010000f6a8ULL, 0x000000060000c550ULL,
0x003f01010000f668ULL, 0x000000060000c580ULL, 0x003f01050000f66cULL, 0x000000060000c750ULL,
0x003f01050000f66cULL, 0x000000340000cd00ULL, 0x003f01050000f6b4ULL, 0x000000340000ced0ULL,
0x003f01050000f6b4ULL, 0x000000050000ef50ULL, 0x003f010100000000ULL, 0x0000000a0000efd0ULL,
0x003f010100000000ULL, 0x000000ff00010140ULL, 0x003f01010000f600ULL, 0x000000ff00010d60ULL,
0x003f01050000f604ULL, 0x000000ff00010f30ULL, 0x003f01050000f604ULL, 0x000000ff00011160ULL,
0x003f01010000f600ULL, 0x000000ff00011190ULL, 0x003f01050000f604ULL, 0x000000ff00011350ULL,
0x003f01050000f604ULL, 0x0000007800014540ULL, 0x003f010100000000ULL, 0x0000007800014600ULL,
0x003f010500000004ULL, 0x00000078000147d0ULL, 0x003f010500000004ULL, 0x0000007a00016c00ULL,
0x003f010100000000ULL, 0x0000007a00016c60ULL, 0x003f010100000008ULL, 0x0000007a00016cc0ULL,
0x003f010100000010ULL, 0x0000007a00016d30ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL,
0x0000fa800000fa50ULL, 0x0000fdd00000fc70ULL, 0x000100600000ff60ULL, 0x00016d70000113b0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000274ULL, 0x0000001b00000002ULL,
0x00000000000001e4ULL, 0x0000001b00000002ULL, 0x0000000000000164ULL, 0x0000001b00000002ULL,
0x00000000000000dcULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x000000000000024aULL, 0x0000001b00000002ULL, 0x00000000000001baULL, 0x0000001b00000002ULL,
0x000000000000013cULL, 0x0000001b00000002ULL, 0x00000000000000b2ULL, 0x0000001b00000002ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e7d7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL,
0x00000005ff0a7819ULL, 0x010fc80000011607ULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000400037b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a7bULL,
0x0000040003007624ULL, 0x000fca00078e020eULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x000000017b7b0810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x000000017b7b1810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff7baa12ULL, 0x000fc800078e33ffULL, 0x0000007b00007306ULL, 0x000e620000209000ULL,
0x000000ff7b00720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000037b047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x00000006037a7227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a7aULL, 0x000000007b007224ULL, 0x000fca00078e0206ULL,
0x0000007b0000720cULL, 0x000fe20003f66070ULL, 0x000001000b027a24ULL, 0x008fe400078e0204ULL,
0x00001fff0b0b7589ULL, 0x000fe400000e0000ULL, 0x00000000020d7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0d00720cULL, 0x000fc60003f45270ULL, 0x0000000100003824ULL, 0x000fe200078e0a7bULL,
0x000000017a7a3810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0d00780cULL, 0x040fe40003f04070ULL,
0x0000007b0000720cULL, 0x000fe40003f86070ULL, 0x0000000f0d00780cULL, 0x040fe40003f24070ULL,
0x000000030d00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL, 0xff317217ff0c8424ULL, 0x000fe400078e00ffULL,
0x000000017a7a4810ULL, 0x000fe20007ffe0ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x0000007bff7ad212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f84070ULL, 0x00001fff0a027589ULL, 0x000ea200000e0000ULL,
0x7fffffc0ff059424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fe200078e0a7aULL,
0x00f4000c0d008388ULL, 0x000fe20000004800ULL, 0x7fffff60ff07b424ULL, 0x000fc400078e00ffULL,
0x000000007b7b7224ULL, 0x000fe200078e0206ULL, 0x00f608040d009388ULL, 0x0007e20000008a00ULL,
0x3fffff60ff06b424ULL, 0x000fe400078e00ffULL, 0x000000107b737824ULL, 0x000fe200078e00ffULL,
0x0000000000007919ULL, 0x000f220000002700ULL, 0x3fffff80ff08b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff09b424ULL, 0x000fe200078e00ffULL, 0x0000000473037c10ULL, 0x042fe2000fffe1ffULL,
0x00f688060d00b388ULL, 0x0005e20000008a00ULL, 0x0000000473007c0cULL, 0x000fc4000bf03070ULL,
0x0000001003037817ULL, 0x000fe20003800000ULL, 0x3fffffc0ff04c424ULL, 0x008fe200078e00ffULL,
0x00f6a8080d00b388ULL, 0x000fe20000008a00ULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x000000ff03797207ULL, 0x000fe40000000000ULL, 0x00005a007a037a19ULL, 0x000fe400000006ffULL,
0x000000107900780cULL, 0x000fe20003f05270ULL, 0x00f6c8040d00c388ULL, 0x0003e20000008a00ULL,
0x000000040b077824ULL, 0x004fc400078e0202ULL, 0x0000580000067a24ULL, 0x010fc800078e02ffULL,
0x0000007d06037224ULL, 0x000fe400078e0203ULL, 0x0000000207047824ULL, 0x002fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000457919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fc40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff087819ULL, 0x002fca0000011645ULL, 0x00000001040a7824ULL, 0x000fc800078e0208ULL,
0x0000000173057824ULL, 0x000fca00078e020aULL, 0x00000004050c7c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011605ULL, 0x0000001045057824ULL, 0x000fe400078e00ffULL,
0x00000001030c7824ULL, 0x000fe200078e020cULL, 0x0000000479037217ULL, 0x000fe40007800000ULL,
0x000000f005097812ULL, 0x000fe200078ec0ffULL, 0x0000007d06067224ULL, 0x000fe400078e020cULL,
0x0000000103037824ULL, 0x000fc400078e0a04ULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x000000010a037824ULL, 0x000fe200078e0245ULL,
0x0000000906097212ULL, 0x000fe200078efcffULL, 0x000000100a0a7824ULL, 0x000fc600078e00ffULL,
0x00005e0009067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00a037812ULL, 0x000fe400078ee203ULL,
0x00005f0007077a10ULL, 0x000fc60000ffe4ffULL, 0x0000001003037824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000457919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000445047211ULL, 0x002fca00078fe0ffULL,
0x0000000173057824ULL, 0x000fca00078e0204ULL, 0x0000000405087c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011605ULL, 0x0000001045057824ULL, 0x000fe400078e00ffULL,
0x0000000103087824ULL, 0x000fe400078e0208ULL, 0x0000000104037824ULL, 0x000fe200078e0245ULL,
0x000000f005097812ULL, 0x000fe200078ec0ffULL, 0x0000007d06067224ULL, 0x000fe400078e0208ULL,
0x0000001004047824ULL, 0x000fc400078e00ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0xfffffff004037812ULL, 0x000fe400078ee203ULL, 0x0000000906067212ULL, 0x000fc600078efcffULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x00005e0006067a10ULL, 0x000fc80007f1e0ffULL,
0x00005f0007077a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e8000b901c48ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x0000000000037806ULL, 0x000fe200038e0000ULL, 0x00000004ff097424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000300047300ULL, 0x000e7000000e0000ULL,
0x0000000300067309ULL, 0x000ea20000000000ULL, 0x000000070400720cULL, 0x002fe20003f02070ULL,
0x000000ffff047224ULL, 0x004fc400078e0a06ULL, 0x0000660000067625ULL, 0x000fd400078e0009ULL,
0x00f60404ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008066e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000003f6e6f7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff6e0c7810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff6f7819ULL, 0x000fe4000001166fULL,
0x00000008ff707819ULL, 0x000fca000001160cULL, 0x0000f61000008947ULL, 0x000fea0003800000ULL,
0x00000002ff787819ULL, 0x000fe20000011602ULL, 0x00000003ff087424ULL, 0x000fc600078e00ffULL,
0x03ffffff78047812ULL, 0x002fc800078ec0ffULL, 0x0000006f0400720cULL, 0x000fda0003f06070ULL,
0x0000000200038824ULL, 0x000fe400078e00ffULL, 0x00006800ff068624ULL, 0x000fc800078e00ffULL,
0x0000680003078624ULL, 0x000fe200078e0206ULL, 0x0000f68802037811ULL, 0x000fe200078e18ffULL,
0xffffffffff067424ULL, 0x000fe400078e00ffULL, 0x00000001040a8824ULL, 0x000fe200078e0207ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040803ff738cULL, 0x0003e20000000000ULL,
0x000064000a0a8625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000080a068981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x000000407a757824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe20000011602ULL,
0x0000000003ff7f8cULL, 0x0007e8000c80043fULL, 0x00000020747c7824ULL, 0x000fca00078e00ffULL,
0x0000002075077812ULL, 0x000fe200078ef87cULL, 0x0000590006087a24ULL, 0x006fe200078e02ffULL,
0x0000000102067812ULL, 0x000fc600078ec0ffULL, 0x0000004008157824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x00000003ff0a7819ULL, 0x108fe20000011645ULL,
0x0000001006087824ULL, 0x000fe200078e00ffULL, 0x0000007c6e037217ULL, 0x000fe40007800000ULL,
0x000000040a0d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001080c7824ULL, 0x000fe200078e020aULL,
0x0000000c0a0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a7cULL,
0x0000620015137a11ULL, 0x000fe200078838ffULL, 0x000000010c0b7824ULL, 0x000fc400078e0245ULL,
0x000000080c127824ULL, 0x000fe200078e00ffULL, 0x0000000803037217ULL, 0x000fe20007800000ULL,
0x0000000108107824ULL, 0x000fe200078e020fULL, 0x0000630015157a11ULL, 0x000fe400020f3cffULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x000000080a0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107117824ULL, 0x000fe400078e0210ULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0x000000030b00720cULL, 0x080fe20003f26070ULL,
0x00000001080e7824ULL, 0x000fe200078e020bULL, 0x000000030a00720cULL, 0x080fe20003f66070ULL,
0x00000001070a7824ULL, 0x000fe200078e020cULL, 0x000000030d00720cULL, 0x080fe20003f46070ULL,
0x000000010e0b7824ULL, 0x040fe200078e0245ULL, 0x000000030f00720cULL, 0x000fe20003f06070ULL,
0x000000080e147824ULL, 0x000fc400078e00ffULL, 0x00000001080c7824ULL, 0x000fe400078e020dULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x000000010c087824ULL, 0x040fe400078e0245ULL, 0x000000080c0d7824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff80d087812ULL, 0x000fe200078ee208ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000700a0a7812ULL, 0x000fe200078ef805ULL,
0x0000000110037824ULL, 0x000fe400078e0245ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000a130a7210ULL, 0x000fe40007f9e0ffULL, 0xfffffff816167812ULL, 0x000fe200078ee203ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fc400078ef805ULL,
0x0000b00074037811ULL, 0x000fe200078e68ffULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc600078ef805ULL, 0x000000010b0b7824ULL, 0x000fe200020e0615ULL,
0x0000007010057812ULL, 0x000fe200078ef805ULL, 0x0000001008077824ULL, 0x100fe200078e0203ULL,
0x000000130c0c7210ULL, 0x080fe40007f9e0ffULL, 0x000000130e0e7210ULL, 0x080fe40007fbe0ffULL,
0x0000001305107210ULL, 0x000fe20007fde0ffULL, 0x0000001012057824ULL, 0x000fe400078e0203ULL,
0x000000010d0d7824ULL, 0x000fc400020e0615ULL, 0x0000001014137824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a057faeULL, 0x0003e2000d901c48ULL,
0x000000010f0f7824ULL, 0x000fe400028e0615ULL, 0x0000001016037824ULL, 0x000fe200078e0203ULL,
0x000000000c077faeULL, 0x0003e2000d101c48ULL, 0x0000000111117824ULL, 0x000fc600030e0615ULL,
0x000000000e137faeULL, 0x0003e8000c901c48ULL, 0x0000000010037faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001006087824ULL, 0x008fe200078e00ffULL,
0x0000620015177a11ULL, 0x000fc800078038ffULL, 0x0000000845087211ULL, 0x000fe400078fe8ffULL,
0x0000630015157a11ULL, 0x000fe400000f3cffULL, 0x00000004080c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000108037824ULL, 0x140fe200078e0245ULL, 0x00000008080e7810ULL, 0x040fe20007ffe0ffULL,
0x00000008080a7824ULL, 0x000fe400078e00ffULL, 0x000000010c0b7824ULL, 0x040fe400078e0245ULL,
0x000000080c127824ULL, 0x000fe200078e00ffULL, 0xfffffff80a037812ULL, 0x000fe200078ee203ULL,
0x00000001070a7824ULL, 0x000fe200078e0208ULL, 0x0000000c08087810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x000fe200078e0245ULL, 0xfffffff812127812ULL, 0x000fe200078ee20bULL,
0x000000080e107824ULL, 0x000fc400078e00ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff810137812ULL, 0x000fe200078ee20dULL, 0x00000001070c7824ULL, 0x040fe200078e020cULL,
0x000000700a0a7812ULL, 0x000fe200078ef805ULL, 0x00000001070e7824ULL, 0x040fe400078e020eULL,
0x0000000107107824ULL, 0x000fe200078e0208ULL, 0x0000000a170a7210ULL, 0x000fe20007f1e0ffULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000000108077824ULL, 0x000fe200078e0245ULL,
0x000000700c0c7812ULL, 0x000fe200078ef805ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000808087824ULL, 0x000fe200078e00ffULL, 0x000000700e0e7812ULL, 0x000fe200078ef805ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff808077812ULL, 0x000fe200078ee207ULL,
0x000000010b0b7824ULL, 0x000fe200000e0615ULL, 0x0000007010057812ULL, 0x000fe400078ef805ULL,
0x0000b00074087811ULL, 0x000fe400078e68ffULL, 0x0000000c170c7210ULL, 0x040fe40007f1e0ffULL,
0x0000000e170e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001003037824ULL, 0x100fe200078e0208ULL,
0x0000000517107210ULL, 0x000fe20007f5e0ffULL, 0x0000001012057824ULL, 0x000fc400078e0208ULL,
0x000000010d0d7824ULL, 0x100fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a037faeULL, 0x0003e2000b901c48ULL, 0x0000001013137824ULL, 0x100fe400078e0208ULL,
0x000000010f0f7824ULL, 0x100fe200008e0615ULL, 0x000000000c057faeULL, 0x0003e2000b901c48ULL,
0x0000001007077824ULL, 0x000fe400078e0208ULL, 0x0000000111117824ULL, 0x000fe200010e0615ULL,
0x000000000e137faeULL, 0x0003e8000b901c48ULL, 0x0000000010077faeULL, 0x0003e4000b901c48ULL,
0x0000000104077810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff0e7424ULL, 0x000fc600078e00ffULL,
0x0000006f0700720cULL, 0x000fda0003f06070ULL, 0x0000000200038824ULL, 0x000fe400078e00ffULL,
0x00006800ff048624ULL, 0x000fc800078e00ffULL, 0x0000680003048624ULL, 0x000fe400078e0204ULL,
0x0000001074037824ULL, 0x000fe400078e00ffULL, 0x0000000104048824ULL, 0x000fe400078e0207ULL,
0x00000000030473c2ULL, 0x000e6400000e0000ULL, 0x0000640004048625ULL, 0x000fe400078e0009ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000008040e8981ULL, 0x000522000c1e1900ULL,
0x000000ff7000720cULL, 0x000fe20003f05270ULL, 0x0000000874087824ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6a800030c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6c80008047f8cULL, 0x000662000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000d9b000008947ULL, 0x000fea0003800000ULL,
0x0000001003037812ULL, 0x00afe200078ec0ffULL, 0x0000000200767824ULL, 0x000fc400078e00ffULL,
0x00006800ff097624ULL, 0x000fe400078e00ffULL, 0x0000002078037824ULL, 0x000fe400078e0203ULL,
0x000000ffff0c7224ULL, 0x004fe400078e000dULL, 0x000000ffff0f7224ULL, 0x000fe400078e0005ULL,
0x0000680076767624ULL, 0x000fe400078e0209ULL, 0x0000000806067824ULL, 0x000fc400078e0203ULL,
0xff317217ff0d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff447224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fc400078e00ffULL, 0x000000ffff617224ULL, 0x00afca00078e0007ULL,
0x0000000000087805ULL, 0x000fc40000015200ULL, 0x0000000402057824ULL, 0x000fca00078e00ffULL,
0xfffffff805147812ULL, 0x000fc800078ec0ffULL, 0x0000f6c814057810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc00140a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08157210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x000000150a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc00140a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x000fe200078e00ffULL, 0x00000001440b7810ULL, 0x000fe20007ffe0ffULL,
0x000059000e0e7a24ULL, 0x010fc600078e02ffULL, 0xffffffe008097812ULL, 0x000fe200078ec0ffULL,
0x000000400e2f7824ULL, 0x000fe200078e00ffULL, 0x000000700b00720cULL, 0x000fc60003f26070ULL,
0x0000010044097824ULL, 0x000fca00078e0209ULL, 0x00000040090f7810ULL, 0x000fc80007ffe0ffULL,
0x000000200f0a7812ULL, 0x000fca00078ec0ffULL, 0x0000000175157824ULL, 0x000fe200078e020aULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x0000001008097812ULL, 0x000fe400078ec0ffULL,
0x0000000f6e087217ULL, 0x000fe40007800000ULL, 0x00000003ff0e7819ULL, 0x000fe40000011645ULL,
0x000062002f297a11ULL, 0x000fe200078a38ffULL, 0x0000000108087824ULL, 0x000fe200078e0a0fULL,
0x000000040e0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010e0a7824ULL, 0x040fe200078e0209ULL,
0x000000080e2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000908087217ULL, 0x000fe20007800000ULL,
0x000000010a0b7824ULL, 0x040fe200078e0245ULL, 0x000063002f2f7a11ULL, 0x000fe200028f3cffULL,
0x000000080a167824ULL, 0x000fe400078e00ffULL, 0x0000000108087824ULL, 0x000fc600078e0a09ULL,
0xfffffff816167812ULL, 0x000fe400078ee20bULL, 0x0000000c0e0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000080e00720cULL, 0x080fe20003f86070ULL, 0x000000010f0e7824ULL, 0x140fe200078e0209ULL,
0x000000082a00720cULL, 0x0c0fe20003f46070ULL, 0x000000012a2a7824ULL, 0x100fe200078e0209ULL,
0x000000080f00720cULL, 0x080fe20003f66070ULL, 0x000000010b2e7824ULL, 0x040fe200078e0209ULL,
0x000000080b00720cULL, 0x000fe20003f06070ULL, 0x000000010e097824ULL, 0x000fc400078e0245ULL,
0x000000080e287824ULL, 0x000fe400078e00ffULL, 0x00000010450f7824ULL, 0x000fe400078e00ffULL,
0x0000000115087824ULL, 0x040fe200078e020aULL, 0xfffffff828287812ULL, 0x000fe200078ee209ULL,
0x0000000115147824ULL, 0x000fe200078e020eULL, 0x000000700f2b7812ULL, 0x000fe200078ec0ffULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x00000001150a7824ULL, 0x040fe200078e022aULL,
0x0000002b08087212ULL, 0x000fe200078efcffULL, 0x00000001150e7824ULL, 0x000fe400078e022eULL,
0x000000012a0b7824ULL, 0x040fe200078e0245ULL, 0x0000000829087210ULL, 0x000fe20007fbe0ffULL,
0x000000082a2c7824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20bULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002b14147212ULL, 0x000fc600078efcffULL, 0x000000012e177824ULL, 0x000fe200078e0245ULL,
0x0000002b0a0a7212ULL, 0x000fe200078efcffULL, 0x000000082e2a7824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee217ULL,
0x0000000109097824ULL, 0x100fe200028e062fULL, 0x0000002914147210ULL, 0x000fe40007fbe0ffULL,
0x0000002b0e0e7212ULL, 0x000fe400078efcffULL, 0x0000c00074177811ULL, 0x000fe200078e68ffULL,
0x0000000115157824ULL, 0x000fe200028e062fULL, 0x000000290a0a7210ULL, 0x080fe40007fbe0ffULL,
0x000000290e0e7210ULL, 0x000fe20007fde0ffULL, 0x0000001016297824ULL, 0x000fc400078e0217ULL,
0x00000010282b7824ULL, 0x100fe400078e0217ULL, 0x000000102c2d7824ULL, 0x000fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008297faeULL, 0x0003e2000e101c48ULL,
0x000000010b0b7824ULL, 0x000fe400028e062fULL, 0x000000102a177824ULL, 0x000fe200078e0217ULL,
0x00000000142b7faeULL, 0x0003e2000d901c48ULL, 0x000000010f0f7824ULL, 0x000fc600030e062fULL,
0x000000000a2d7faeULL, 0x0003e8000d101c48ULL, 0x000000000e177faeULL, 0x0003e2000c101c48ULL,
0x0000035000007947ULL, 0x000fea0003800000ULL, 0x0000001008087812ULL, 0x000fe400078ec0ffULL,
0x000062002f2b7a11ULL, 0x000fe400078038ffULL, 0x0000000845087211ULL, 0x000fe400078fe8ffULL,
0x000063002f2f7a11ULL, 0x000fc400000f3cffULL, 0x00000004080a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000108097824ULL, 0x140fe200078e0245ULL, 0x00000008080e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000808167824ULL, 0x040fe200078e00ffULL, 0x0000000c08147810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0245ULL, 0x0000c000742d7811ULL, 0x000fe200078e68ffULL,
0x000000080a287824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee209ULL,
0x0000000115097824ULL, 0x000fe400078e0208ULL, 0x000000010e0f7824ULL, 0x000fe200078e0245ULL,
0xfffffff828287812ULL, 0x000fe200078ee20bULL, 0x00000010450b7824ULL, 0x000fc400078e00ffULL,
0x0000008009087825ULL, 0x000fc600078e00ffULL, 0x000000700b297812ULL, 0x000fe200078ec0ffULL,
0x000000080e2a7824ULL, 0x000fe400078e00ffULL, 0x00000001150a7824ULL, 0x040fe200078e020aULL,
0x0000002908087212ULL, 0x000fe200078efcffULL, 0x00000001150e7824ULL, 0x040fe200078e020eULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee20fULL, 0x0000000115157824ULL, 0x000fe200078e0214ULL,
0x000000082b087210ULL, 0x000fe20007f1e0ffULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x0000000114177824ULL, 0x000fe200078e0245ULL, 0x000000290a0a7212ULL, 0x000fe200078efcffULL,
0x00000008142c7824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee217ULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0x000000290e0e7212ULL, 0x000fc600078efcffULL, 0x0000000109097824ULL, 0x000fe200000e062fULL,
0x0000002914147212ULL, 0x000fe200078efcffULL, 0x0000001016177824ULL, 0x100fe200078e022dULL,
0x0000000a2b0a7210ULL, 0x040fe20007f1e0ffULL, 0x0000001028297824ULL, 0x000fe200078e022dULL,
0x0000000e2b0e7210ULL, 0x040fe40007f5e0ffULL, 0x000000142b147210ULL, 0x000fe20007f7e0ffULL,
0x000000010b0b7824ULL, 0x000fe200000e062fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008177faeULL, 0x0003e2000b901c48ULL, 0x000000102a2b7824ULL, 0x000fc400078e022dULL,
0x000000010f0f7824ULL, 0x000fe200010e062fULL, 0x000000000a297faeULL, 0x0003e2000b901c48ULL,
0x000000102c2d7824ULL, 0x000fe400078e022dULL, 0x0000000115157824ULL, 0x000fe200018e062fULL,
0x000000000e2b7faeULL, 0x0003e8000b901c48ULL, 0x00000000142d7faeULL, 0x0003e4000b901c48ULL,
0x0000000802087824ULL, 0x002fe200078e00ffULL, 0x00000001070a7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff407424ULL, 0x000fc600078e00ffULL, 0xfffffff0080f7812ULL, 0x000fe400078ec0ffULL,
0x0000006f0a00720cULL, 0x000fe40003f06070ULL, 0x000000000f0473c2ULL, 0x000e6200000e0000ULL,
0xffffffe008097812ULL, 0x040fe400078ec0ffULL, 0x00000010080e7812ULL, 0x040fe400078ec0ffULL,
0x0000000808087812ULL, 0x000fcc00078ec0ffULL, 0x00000001760a8824ULL, 0x000fe400078e020aULL,
0x00000004ff0b8424ULL, 0x000fe200078e00ffULL, 0x0000000908087210ULL, 0x000fe40007ffe00eULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000064000a0a8625ULL, 0x000fca00078e000bULL,
0x000000080a408981ULL, 0x000522000c1e1900ULL, 0x0000f6b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6b0000f0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080008167f8cULL, 0x0004e4000c80043fULL,
0x00000000000a7805ULL, 0x000fc40000015200ULL, 0x00f60c0008097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140a147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0bULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011415ULL, 0x0000001409097211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000209097819ULL, 0x000fc80000001214ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c0008097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010454b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff627819ULL, 0x000fe20000011645ULL, 0x0000002002097824ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe200078e00ffULL, 0x000000704b4b7812ULL, 0x000fc400078ec0ffULL,
0xffffff8009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c62627812ULL, 0x000fc800078ec0ffULL,
0x0000000962097210ULL, 0x000fca0007ffe04bULL, 0x00f00000090a7984ULL, 0x000ea80000000800ULL,
0x00f2000009177984ULL, 0x0006620000000800ULL, 0x0000000d0a00720bULL, 0x004fe20003f1d000ULL,
0x000146f27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0b297812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fc400078e000dULL,
0x0000001fff727424ULL, 0x000fe400078e00ffULL, 0xffffffffff717424ULL, 0x000fca00078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000027800720cULL, 0x000fe40003f05270ULL,
0x0000000d0a00720bULL, 0x000fe20003f54000ULL, 0x000146827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000167806ULL, 0x000fc400010e0100ULL, 0x00000080020b8824ULL, 0x000fe200078e024bULL,
0x0000000d0a097209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x0000000162148824ULL, 0x000fe200078e020bULL, 0x00009910160b7816ULL, 0x000fc800000000ffULL,
0x00f4000914008388ULL, 0x0005e20000000800ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000d090b7221ULL, 0x004fe20000010100ULL,
0x000000ff16ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00287308ULL, 0x000ea40000000800ULL,
0x000000283c3c7220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011645ULL, 0x000145b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b280b7589ULL, 0x0004e400000e0000ULL, 0x0000000b24247220ULL, 0x08cfe20000410000ULL,
0x0000000b25257220ULL, 0x080fe20000410000ULL, 0x0000000b38387220ULL, 0x080fe20000410000ULL,
0x0000000b39397220ULL, 0x080fe20000410000ULL, 0x0000000b34347220ULL, 0x080fe20000410000ULL,
0x0000000b35357220ULL, 0x080fe20000410000ULL, 0x0000000b20207220ULL, 0x080fe20000410000ULL,
0x0000000b21217220ULL, 0x080fe20000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x080fe20000410000ULL, 0x0000000b30307220ULL, 0x080fe20000410000ULL,
0x0000000b31317220ULL, 0x080fe20000410000ULL, 0x0000000b10107220ULL, 0x080fe20000410000ULL,
0x0000000b11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008450b7811ULL, 0x000fe200078ff0ffULL, 0x000144927f007947ULL, 0x000fea000b800000ULL,
0x00001f0b280b7589ULL, 0x0004e400000e0000ULL, 0x0000000b26267220ULL, 0x08cfe20000410000ULL,
0x0000000b27277220ULL, 0x080fe20000410000ULL, 0x0000000b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000b36367220ULL, 0x080fe20000410000ULL,
0x0000000b37377220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b32327220ULL, 0x080fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b12127220ULL, 0x080fe20000410000ULL,
0x0000000b13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff29ff7812ULL, 0x000fe20007806016ULL, 0x00000001ff0b7424ULL, 0x000fd800078e00ffULL,
0x800000090a0a0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00040308ULL, 0x000ea40000000800ULL,
0x0000000417170220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003c170a7221ULL, 0x002fc20000010000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x00000008020d7824ULL, 0x000fca00078e00ffULL, 0xfffffff00d287812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00280d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011417ULL,
0x000000160d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x000000020d0d7819ULL, 0x000fc80000001216ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00280d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100b0b7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000004ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011645ULL,
0x00005410000c7816ULL, 0x000fe20000000000ULL, 0x000140527f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c037589ULL, 0x0002a400000e0000ULL, 0x000000080d0b7810ULL, 0x000fe20007ffe0ffULL,
0x000140827f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0c007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e000cULL, 0x00002ed000157802ULL, 0x000fc40000000f00ULL,
0x00014a4000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e000cULL,
0x00002f2000157802ULL, 0x000fc40000000f00ULL, 0x000149f000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002025c7824ULL, 0x040fe200078e00ffULL,
0x00000007450b7812ULL, 0x04cfe200078ec0ffULL, 0x0000020002497824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000845467812ULL, 0x000fc400078ec0ffULL,
0x000000045c0c7812ULL, 0x002fe400078ec0ffULL, 0x000000080b537812ULL, 0x000fe400078ef845ULL,
0x0000000c450c7211ULL, 0x000fe400078fe0ffULL, 0xfffff80049497812ULL, 0x000fe200078ec0ffULL,
0x0000000853607824ULL, 0x040fe400078e00ffULL, 0x0000000153777824ULL, 0x000fca00078e020cULL,
0xfffffff860607812ULL, 0x000fca00078ee277ULL, 0x0000001060607824ULL, 0x000fc800078e00ffULL,
0x00000001604a7824ULL, 0x000fc400078e0249ULL, 0x00000004020c7824ULL, 0x000fe200078e00ffULL,
0x00000004ff5f7819ULL, 0x000fe40000011645ULL, 0x0000000b46297212ULL, 0x000fe400078efcffULL,
0x000000040c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000b000745b7811ULL, 0x000fe200078e68ffULL,
0x0000000829417824ULL, 0x000fe200078e00ffULL, 0x0000001046467812ULL, 0x000fe200078efe0bULL,
0x000000015f0c7824ULL, 0x000fe200078e020cULL, 0xfffffff85c5c7812ULL, 0x000fc600078ec0ffULL,
0x00000001292a7824ULL, 0x000fe400078e020cULL, 0x0000000846487824ULL, 0x000fe400078e00ffULL,
0x000000010c557824ULL, 0x000fe200078e0246ULL, 0xfffffff841417812ULL, 0x000fc800078ee22aULL,
0xfffffff848487812ULL, 0x000fe200078ee255ULL, 0x00000010413c7824ULL, 0x000fc800078e025bULL,
0x00000010482c7824ULL, 0x000fe400078e025bULL, 0x000000003c3c783bULL, 0x000e680000004200ULL,
0x000000002c2c783bULL, 0x000fe20000004200ULL, 0x000001003c287824ULL, 0x002fe200078e00ffULL,
0x0000003c00147306ULL, 0x000fe20000009400ULL, 0x000001003d517824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fc4000001143cULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000003c00157306ULL, 0x000e620000005400ULL,
0x0000002800697245ULL, 0x000fe4000020d400ULL, 0x00000018ff677819ULL, 0x000fca000001143dULL,
0x0000002800167306ULL, 0x000ff00000209400ULL, 0x0000002800177306ULL, 0x000ea20000205400ULL,
0x000000151400720bULL, 0x002fce0003f5d000ULL, 0x0000003d00477306ULL, 0x000ff00000009400ULL,
0x0000003d00647306ULL, 0x000e620000005400ULL, 0x000000171600720bULL, 0x004fe40003f7d000ULL,
0x009000004a14783bULL, 0x000eaa0000000200ULL, 0x0000003c00527306ULL, 0x000eec000000d400ULL,
0x0000000169693812ULL, 0x000fc400078efcffULL, 0x00000051005a7306ULL, 0x000fe20000209400ULL,
0x000000644700720bULL, 0x002fe20003f9d000ULL, 0x0000000829647824ULL, 0x000fe200078e00ffULL,
0x000000022a477810ULL, 0x000fc80007ffe0ffULL, 0xfffffff864477812ULL, 0x000fe200078ee247ULL,
0x00000051002b7306ULL, 0x0002a20000205400ULL, 0x0000000152522812ULL, 0x008fe200078efcffULL,
0x000100003c647824ULL, 0x000fe400078e00ffULL, 0x0000001047297824ULL, 0x000fe200078e025bULL,
0x00000052693c723eULL, 0x000fe200000010ffULL, 0x000100003d697824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000003d00427306ULL, 0x000ee2000000d400ULL,
0x0000005100517245ULL, 0x002fc4000020d400ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x0000002b5a00720bULL, 0x004fc60003fbd000ULL, 0x00000064006a7306ULL, 0x000fe20000205400ULL,
0x000000002928783bULL, 0x000e620000004200ULL, 0x0000000314148231ULL, 0x080fe400003400ffULL,
0x0000000316168231ULL, 0x000fe400003400ffULL, 0x0000000015158231ULL, 0x080fe200003400ffULL,
0x0000000142424812ULL, 0x008fe200078efcffULL, 0x00000064005a7306ULL, 0x000ea20000209400ULL,
0x0000000017178231ULL, 0x000fe200003400ffULL, 0x0000000151515812ULL, 0x000fcc00078efcffULL,
0x00000069006b7306ULL, 0x000fe20000209400ULL, 0x00000042513d723eULL, 0x000fce00000010ffULL,
0x00000069006c7306ULL, 0x000ee20000205400ULL, 0x0000006a5a00720bULL, 0x004fe20003f5d000ULL,
0x000001003e5a7824ULL, 0x000fe200078e00ffULL, 0x0000003c1424723cULL, 0x000b680000041824ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000006700597306ULL, 0x000fe40000209400ULL,
0x00000067003d7245ULL, 0x020fc4000020d400ULL, 0x00000068003c7245ULL, 0x000fc8000020d400ULL,
0x0000006700667306ULL, 0x0004620000205400ULL, 0x0000006c6b00720bULL, 0x008fe20003f9d000ULL,
0x000001003f6c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000006800587306ULL, 0x000fe20000209400ULL, 0x0000006400677245ULL, 0x004fe4000020d400ULL,
0x0000006900647245ULL, 0x000fe4000020d400ULL, 0x0000000167672812ULL, 0x000fe400078efcffULL,
0x0000000164644812ULL, 0x000fe200078efcffULL, 0x0000006800577306ULL, 0x000ea20000205400ULL,
0x000000665900720bULL, 0x002fce0003fbd000ULL, 0x0000003e005d7306ULL, 0x000fec0000009400ULL,
0x000000013d3d5812ULL, 0x000fe400078efcffULL, 0x0000003e005e7306ULL, 0x000e620000005400ULL,
0x000000575800720bULL, 0x004fe40003f7d000ULL, 0x000000643d3d723eULL, 0x000fca00000010ffULL,
0x0000003f00637306ULL, 0x000fec0000009400ULL, 0x000000013c3c3812ULL, 0x000fe400078efcffULL,
0x0000003f00657306ULL, 0x000ea20000005400ULL, 0x0000005e5d00720bULL, 0x002fe40003f5d000ULL,
0x000000673c3c723eULL, 0x000fc400000010ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001143eULL,
0x00000018ff5d7819ULL, 0x000fe2000001143fULL, 0x0000005a00667306ULL, 0x000fe40000209400ULL,
0x0000003c1438723cULL, 0x000bec0000041838ULL, 0x0000005a00687306ULL, 0x000e620000205400ULL,
0x000000656300720bULL, 0x004fc40003f9d000ULL, 0x0000005a003d7245ULL, 0x020fca000020d400ULL,
0x0000006c00697306ULL, 0x000ff00000209400ULL, 0x0000006c006a7306ULL, 0x000ea20000205400ULL,
0x000000686600720bULL, 0x002fe20003f7d000ULL, 0x000100003e667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000003e00567306ULL, 0x000e6c000000d400ULL,
0x000000013d3d3812ULL, 0x000fe400078efcffULL, 0x0000003f00547306ULL, 0x000662000000d400ULL,
0x0000006a6900720bULL, 0x004fe20003fbd000ULL, 0x000100003f6a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000005e00677306ULL, 0x000fe20000209400ULL,
0x0000006c003f7245ULL, 0x008fe4000020d400ULL, 0x0000000156562812ULL, 0x002fc600078efcffULL,
0x000000013f3f5812ULL, 0x000fe400078efcffULL, 0x0000005e00687306ULL, 0x000e620000205400ULL,
0x0000000154544812ULL, 0x000fe400078efcffULL, 0x000000563d3c723eULL, 0x000fe400000010ffULL,
0x000000543f3d723eULL, 0x000fc600000010ffULL, 0x0000002900647306ULL, 0x000fe80000009400ULL,
0x0000003c1434723cULL, 0x000be80000041834ULL, 0x0000002900637306ULL, 0x000ea20000005400ULL,
0x000000686700720bULL, 0x002fe20003fdd000ULL, 0x0000010029677824ULL, 0x040fe200078e00ffULL,
0x0000005e003d7245ULL, 0x020fe2000020d400ULL, 0x0001000029687824ULL, 0x000fe200078e00ffULL,
0x00000066003c7245ULL, 0x000fc4000020d400ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000006a006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff687819ULL, 0x000fca0000011468ULL,
0x000000013d3d6812ULL, 0x000fe400078efcffULL, 0x0000006a00547306ULL, 0x0002e20000205400ULL,
0x000000636400720bULL, 0x004fce0003fdd000ULL, 0x0000006600697306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x002fce000020d400ULL, 0x00000066006b7306ULL, 0x0002a20000205400ULL,
0x000000546c00720bULL, 0x008fce0003fbd000ULL, 0x0000005d00657306ULL, 0x000fe20000209400ULL,
0x0000006700667245ULL, 0x002fca000020d400ULL, 0x000000016a6a5812ULL, 0x000fe400078efcffULL,
0x0000005d003e7306ULL, 0x0002e20000205400ULL, 0x0000006b6900720bULL, 0x004fce0003f9d000ULL,
0x0000006700547306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x002fca000020d400ULL,
0x000000013c3c4812ULL, 0x000fe400078efcffULL, 0x0000006700637306ULL, 0x000e620000205400ULL,
0x0000003e6500720bULL, 0x008fe20003f7d000ULL, 0x0000010028657824ULL, 0x000fe200078e00ffULL,
0x0000003c3d3c723eULL, 0x000fc800000010ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000002800597306ULL, 0x000fec0000009400ULL, 0x000000015d5d3812ULL, 0x000fe400078efcffULL,
0x0000002800587306ULL, 0x000ea20000005400ULL, 0x000000635400720bULL, 0x002fc40003f9d000ULL,
0x0000006a5d3d723eULL, 0x000fe400000010ffULL, 0x00000018ff637819ULL, 0x000fe40000011428ULL,
0x00000018ff547819ULL, 0x000fe2000001142cULL, 0x00000029003f7306ULL, 0x000e64000000d400ULL,
0x0000003c1420723cULL, 0x000b680000041820ULL, 0x0000000166664812ULL, 0x000fc400078efcffULL,
0x0000006500697306ULL, 0x000fe20000209400ULL, 0x000000585900720bULL, 0x004fe40003f5d000ULL,
0x00000065003c7245ULL, 0x020fca000020d400ULL, 0x0000006500567306ULL, 0x000ea20000205400ULL,
0x000000013f3f6812ULL, 0x002fc800078efcffULL, 0x0000003f663d723eULL, 0x000fe200000010ffULL,
0x00010000283f7824ULL, 0x000fe400078e00ffULL, 0x0000002800577306ULL, 0x0002e6000000d400ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000566900720bULL, 0x004fc60003f7d000ULL,
0x0000002a005a7306ULL, 0x000fe20000009400ULL, 0x00000018ff287819ULL, 0x002fe40000011429ULL,
0x0000000157572812ULL, 0x008fca00078efcffULL, 0x0000002a00587306ULL, 0x000e640000005400ULL,
0x000000013c3c3812ULL, 0x000fcc00078efcffULL, 0x0000003f00667306ULL, 0x000fe20000209400ULL,
0x000000573c3c723eULL, 0x000fce00000010ffULL, 0x0000003f00677306ULL, 0x000ea20000205400ULL,
0x0000003c141c723cULL, 0x000b62000004181cULL, 0x000000585a00720bULL, 0x002fe40003f9d000ULL,
0x0000003f00587245ULL, 0x000fc8000020d400ULL, 0x0000002b00597306ULL, 0x000fe20000009400ULL,
0x00000018ff3c7819ULL, 0x020fe4000001142aULL, 0x00000018ff3d7819ULL, 0x000fca000001142bULL,
0x0000002b005e7306ULL, 0x000e620000005400ULL, 0x000000676600720bULL, 0x004fce0003fdd000ULL,
0x0000006300647306ULL, 0x000fec0000209400ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000006300577306ULL, 0x0004e20000205400ULL, 0x0000005e5900720bULL, 0x002fce0003f7d000ULL,
0x0000006800697306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x004fce000020d400ULL,
0x00000068005a7306ULL, 0x000e620000205400ULL, 0x000000576400720bULL, 0x008fe20003fbd000ULL,
0x000001002a577824ULL, 0x000fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000003c00297306ULL, 0x000fec0000209400ULL, 0x0000000163635812ULL, 0x000fe400078efcffULL,
0x0000003c005e7306ULL, 0x000ea20000205400ULL, 0x0000005a6900720bULL, 0x002fe20003fdd000ULL,
0x000001002b5a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000002800657306ULL, 0x000ff00000209400ULL, 0x00000028006a7306ULL, 0x000e620000205400ULL,
0x0000005e2900720bULL, 0x004fc40003fbd000ULL, 0x0000006800297245ULL, 0x000fc8000020d400ULL,
0x0000000129296812ULL, 0x000fe200078efcffULL, 0x0000003d003f7306ULL, 0x000ff00000209400ULL,
0x0000003d00647306ULL, 0x0004e20000205400ULL, 0x0000006a6500720bULL, 0x002fce0003f5d000ULL,
0x0000005700597306ULL, 0x000fe20000209400ULL, 0x0000003d003d7245ULL, 0x004fce000020d400ULL,
0x00000057005e7306ULL, 0x000e620000205400ULL, 0x000000643f00720bULL, 0x008fe20003fdd000ULL,
0x000100002a3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000002a003e7306ULL, 0x0004ec000000d400ULL, 0x000000013d3d6812ULL, 0x000fe400078efcffULL,
0x0000005a00647306ULL, 0x000fe20000209400ULL, 0x00000028002a7245ULL, 0x004fc8000020d400ULL,
0x000000012a2a2812ULL, 0x000fe400078efcffULL, 0x0000005e5900720bULL, 0x002fe20003f5d000ULL,
0x0000005a00657306ULL, 0x000e620000205400ULL, 0x000100002b5e7824ULL, 0x000fe200078e00ffULL,
0x000000013e3e4812ULL, 0x008fe400078efcffULL, 0x000000292a29723eULL, 0x000fe400000010ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000002b005d7306ULL, 0x0004f0000000d400ULL,
0x0000003f00287306ULL, 0x000fe20000209400ULL, 0x00000057002b7245ULL, 0x004fc8000020d400ULL,
0x000000012b2b2812ULL, 0x000fe400078efcffULL, 0x000000656400720bULL, 0x002fe20003f5d000ULL,
0x0000003f00597306ULL, 0x000e620000205400ULL, 0x0000005a00647245ULL, 0x000fe4000020d400ULL,
0x000000015d5d3812ULL, 0x008fe400078efcffULL, 0x0000003e2b2a723eULL, 0x000fc600000010ffULL,
0x0000005e00667306ULL, 0x000fe80000209400ULL, 0x0000000164642812ULL, 0x000fc800078efcffULL,
0x0000005e00657306ULL, 0x000ea20000205400ULL, 0x000000592800720bULL, 0x002fe40003f9d000ULL,
0x000000586328723eULL, 0x000fe200000010ffULL, 0x0000000846637824ULL, 0x000fe200078e00ffULL,
0x0000005d642b723eULL, 0x000fe400000010ffULL, 0x0000000255467810ULL, 0x000fe20007ffe0ffULL,
0x0000002c004e7306ULL, 0x000fe20000009400ULL, 0x00000018ff587819ULL, 0x000fe2000001142dULL,
0x000000281418723cULL, 0x000b620000041818ULL, 0xfffffff863467812ULL, 0x000fc400078ee246ULL,
0x00000018ff5d7819ULL, 0x000fe4000001142eULL, 0x00000018ff647819ULL, 0x000fe2000001142fULL,
0x0000002c00507306ULL, 0x000e620000005400ULL, 0x000000656600720bULL, 0x004fe20003f5d000ULL,
0x0000002a1430723cULL, 0x000f640000041830ULL, 0x0000003c00297245ULL, 0x020fe2000020d400ULL,
0x000001002c657824ULL, 0x000fe200078e00ffULL, 0x0000003f00287245ULL, 0x000fe2000020d400ULL,
0x000001002d667824ULL, 0x000fe200078e00ffULL, 0x0000005e003c7245ULL, 0x000fe2000020d400ULL,
0x0000002d004f7306ULL, 0x000fe20000009400ULL, 0x0000000129295812ULL, 0x000fe200078efcffULL,
0x00000010463e7824ULL, 0x000fe200078e025bULL, 0x0000000128284812ULL, 0x000fc400078efcffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x000000013c3c2812ULL, 0x000fe200078efcffULL,
0x0000002d004d7306ULL, 0x000ea20000005400ULL, 0x000000282928723eULL, 0x000fe400000010ffULL,
0x0000003c3d29723eULL, 0x000fe400000010ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x000000003e3c783bULL, 0x000fe20000004200ULL, 0x000000504e00720bULL, 0x002fe20003f5d000ULL,
0x0000006500687306ULL, 0x000fe40000205400ULL, 0x000000281414723cULL, 0x000b6c0000041810ULL,
0x0000006500117306ULL, 0x0202e20000209400ULL, 0x0000000474127824ULL, 0x000fe200078e025fULL,
0x0000004d4f00720bULL, 0x004fc80003f9d000ULL, 0x0000000212127810ULL, 0x000fe20007ffe053ULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0x00000066006a7306ULL, 0x000fe20000205400ULL,
0x0000006500657245ULL, 0x002fc6000020d400ULL, 0xfffffff853127812ULL, 0x000fc800078ee212ULL,
0x0000006600537306ULL, 0x0002a20000209400ULL, 0x0000001012497824ULL, 0x000fe200078e0249ULL,
0x000000681100720bULL, 0x008fc80003f7d000ULL, 0x009000004928783bULL, 0x000ee40000000200ULL,
0x0000002c004c7306ULL, 0x0004a2000000d400ULL, 0x0000006600667245ULL, 0x002fcc000020d400ULL,
0x0000000165653812ULL, 0x000fe200078efcffULL, 0x0000002d00437306ULL, 0x000e62000000d400ULL,
0x0000006a5300720bULL, 0x004fe20003fbd000ULL, 0x000100002c2c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000005400567306ULL, 0x000fe20000209400ULL,
0x000000014c4c2812ULL, 0x000fc800078efcffULL, 0x0000004c654c723eULL, 0x000fe400000010ffULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x0000005400577306ULL, 0x000ea20000205400ULL,
0x0000000143434812ULL, 0x002fc800078efcffULL, 0x00000043664d723eULL, 0x000fc600000010ffULL,
0x0000005800597306ULL, 0x000fe20000209400ULL, 0x0000000328288231ULL, 0x088fe400003400ffULL,
0x000000032a2a8231ULL, 0x000fca00003400ffULL, 0x00000058005a7306ULL, 0x0002e20000205400ULL,
0x0000000029298231ULL, 0x080fe400003400ffULL, 0x000000002b2b8231ULL, 0x000fe200003400ffULL,
0x000000575600720bULL, 0x004fe20003f1d000ULL, 0x000001002f567824ULL, 0x000fc600078e00ffULL,
0x0000002c00667306ULL, 0x000fe20000205400ULL, 0x0000005800587245ULL, 0x002fe2000020d400ULL,
0x0000004c2824723cULL, 0x000b620000041824ULL, 0x00000018ff567819ULL, 0x000fca0000011456ULL,
0x0000002c004d7306ULL, 0x0202a20000209400ULL, 0x0000005a5900720bULL, 0x008fce0003fdd000ULL,
0x0000002e000b7306ULL, 0x000fe20000009400ULL, 0x0000002c002c7245ULL, 0x002fca000020d400ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x0000002e000c7306ULL, 0x000e620000005400ULL,
0x000000664d00720bULL, 0x004fce0003f7d000ULL, 0x0000005d00557306ULL, 0x000fec0000209400ULL,
0x000000012c2c3812ULL, 0x000fe400078efcffULL, 0x0000005d005e7306ULL, 0x000ea20000205400ULL,
0x0000000c0b00720bULL, 0x002fe20003f9d000ULL, 0x000100002d0c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x00000056004d7306ULL, 0x000ff00000209400ULL,
0x00000056005a7306ULL, 0x000e620000205400ULL, 0x0000005e5500720bULL, 0x004fe20003fbd000ULL,
0x000100002e5e7824ULL, 0x000fc400078e00ffULL, 0x000100002f557824ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000002e000d7306ULL, 0x000ea2000000d400ULL,
0x00000018ff557819ULL, 0x000fce0000011455ULL, 0x0000003d00117306ULL, 0x000fe20000009400ULL,
0x0000005a4d00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff4d7819ULL, 0x000fca000001143dULL,
0x0000003d005f7306ULL, 0x000e620000005400ULL, 0x000000010d0d4812ULL, 0x004fce00078efcffULL,
0x0000002f00427306ULL, 0x000ff00000009400ULL, 0x0000002f00527306ULL, 0x000ea20000005400ULL,
0x0000005f1100720bULL, 0x002fe20003f9d000ULL, 0x000001003c5f7824ULL, 0x000fe200078e00ffULL,
0x0000005600117245ULL, 0x000fc8000020d400ULL, 0x0000000111116812ULL, 0x000fe200078efcffULL,
0x0000000c002d7306ULL, 0x000fe20000209400ULL, 0x00000018ff5f7819ULL, 0x000fce000001145fULL,
0x0000000c00687306ULL, 0x0002e20000205400ULL, 0x000000524200720bULL, 0x004fe20003f5d000ULL,
0x000001002e427824ULL, 0x000fe200078e00ffULL, 0x0000000c002e7245ULL, 0x000fc8000020d400ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000005e00667306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x002fce000001143cULL, 0x0000005e00677306ULL, 0x0002a20000205400ULL,
0x000000682d00720bULL, 0x008fe40003f7d000ULL, 0x00000054002d7245ULL, 0x000fc8000020d400ULL,
0x000000012d2d0812ULL, 0x000fe200078efcffULL, 0x0000002f00517306ULL, 0x000ee2000000d400ULL,
0x0000005e005e7245ULL, 0x002fe4000020d400ULL, 0x0000002c2d2c723eULL, 0x000fc600000010ffULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x0000003e00537306ULL, 0x000fe20000009400ULL,
0x000000676600720bULL, 0x004fe40003fdd000ULL, 0x0000002e582d723eULL, 0x000fe400000010ffULL,
0x0000000c00587245ULL, 0x000fc6000020d400ULL, 0x0000003e004f7306ULL, 0x000e620000005400ULL,
0x0000000151512812ULL, 0x008fc800078efcffULL, 0x000000511111723eULL, 0x000fe400000010ffULL,
0x000000015e5e6812ULL, 0x000fe200078efcffULL, 0x0000005500597306ULL, 0x000ff00000209400ULL,
0x0000005500547306ULL, 0x000ea20000205400ULL, 0x0000004f5300720bULL, 0x002fe20003f5d000ULL,
0x000001003d4f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000004200527306ULL, 0x000ff00000209400ULL, 0x0000004200577306ULL, 0x000e620000205400ULL,
0x000000545900720bULL, 0x004fc40003fdd000ULL, 0x0000005500547245ULL, 0x000fca000020d400ULL,
0x0000006400637306ULL, 0x000fec0000209400ULL, 0x0000000154546812ULL, 0x000fe400078efcffULL,
0x0000006400107306ULL, 0x0004e20000205400ULL, 0x000000575200720bULL, 0x002fce0003f7d000ULL,
0x0000005f00567306ULL, 0x000fe20000209400ULL, 0x0000006400647245ULL, 0x004fce000020d400ULL,
0x0000005f00677306ULL, 0x000e620000205400ULL, 0x000000106300720bULL, 0x008fe40003f1d000ULL,
0x0000005d00637245ULL, 0x000fe4000020d400ULL, 0x0000004200107245ULL, 0x000fe4000020d400ULL,
0x0000000163635812ULL, 0x000fe200078efcffULL, 0x0000003f00657306ULL, 0x000fe20000009400ULL,
0x0000000110103812ULL, 0x000fe400078efcffULL, 0x00000018ff427819ULL, 0x000fc4000001143eULL,
0x0000000d1010723eULL, 0x000fe400000010ffULL, 0x0000000164640812ULL, 0x000fe200078efcffULL,
0x0000003f004c7306ULL, 0x000ea20000005400ULL, 0x000000675600720bULL, 0x002fe20003fdd000ULL,
0x000100003c567824ULL, 0x000fe200078e00ffULL, 0x00000054640d723eULL, 0x000fc800000010ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000003c00127306ULL, 0x000ff00000009400ULL,
0x0000003c00137306ULL, 0x000e620000005400ULL, 0x0000004c6500720bULL, 0x004fe20003fbd000ULL,
0x000100003d657824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc8000001143fULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000004f00597306ULL, 0x000ff00000209400ULL,
0x0000004f00667306ULL, 0x000ea20000205400ULL, 0x000000131200720bULL, 0x002fce0003f7d000ULL,
0x0000000c002f7306ULL, 0x000ff00000209400ULL, 0x0000000c00527306ULL, 0x0002e20000205400ULL,
0x000000665900720bULL, 0x004fe40003f1d000ULL, 0x0000005f00597245ULL, 0x000fc8000020d400ULL,
0x0000000159596812ULL, 0x000fe200078efcffULL, 0x0000003c00507306ULL, 0x000ea2000000d400ULL,
0x0000005e630c723eULL, 0x002fce00000010ffULL, 0x0000004d00577306ULL, 0x000fe20000209400ULL,
0x000000522f00720bULL, 0x008fe20003fdd000ULL, 0x000001003e2f7824ULL, 0x000fe200078e00ffULL,
0x0000004f00527245ULL, 0x000fe2000020d400ULL, 0x000001003f4f7824ULL, 0x000fe200078e00ffULL,
0x0000000c2820723cULL, 0x000b640000041820ULL, 0x0000000152520812ULL, 0x000fe200078efcffULL,
0x0000004d005a7306ULL, 0x000e620000205400ULL, 0x0000000150503812ULL, 0x004fe400078efcffULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x000000505950723eULL, 0x000fe400000010ffULL,
0x0000000158586812ULL, 0x000fe200078efcffULL, 0x0000003d004e7306ULL, 0x000eb0000000d400ULL,
0x00000056003c7306ULL, 0x000fe20000209400ULL, 0x0000005a5700720bULL, 0x002fc40003f7d000ULL,
0x00000018ff5a7819ULL, 0x000fe4000001142fULL, 0x0000002c282c723cULL, 0x000f660000041838ULL,
0x00000056003d7306ULL, 0x0002e20000205400ULL, 0x000000014e4e4812ULL, 0x004fc800078efcffULL,
0x0000004e5251723eULL, 0x000fc600000010ffULL, 0x00000065005f7306ULL, 0x000fe20000209400ULL,
0x0000005600567245ULL, 0x002fc6000020d400ULL, 0x00000050281c723cULL, 0x000f68000004181cULL,
0x0000006500687306ULL, 0x0002a20000205400ULL, 0x0000003d3c00720bULL, 0x008fe20003f1d000ULL,
0x000100003e3c7824ULL, 0x000fe400078e00ffULL, 0x000100003f3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000004200127306ULL, 0x000fe20000209400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006500657245ULL, 0x002fc6000020d400ULL,
0x0000000156560812ULL, 0x000fe400078efcffULL, 0x0000004200137306ULL, 0x000e620000205400ULL,
0x000000685f00720bULL, 0x004fe40003f9d000ULL, 0x00000056580c723eULL, 0x020fca00000010ffULL,
0x0000005a00667306ULL, 0x000fec0000209400ULL, 0x0000000165654812ULL, 0x000fe400078efcffULL,
0x0000005a00677306ULL, 0x0004e20000205400ULL, 0x000000131200720bULL, 0x002fe40003f1d000ULL,
0x000000102810723cULL, 0x000b6a0000041834ULL, 0x0000004f005d7306ULL, 0x000fe20000209400ULL,
0x0000005a005a7245ULL, 0x004fc4000020d400ULL, 0x0000004d00347245ULL, 0x020fe4000020d400ULL,
0x0000004f00367245ULL, 0x000fe4000020d400ULL, 0x0000000134343812ULL, 0x000fe200078efcffULL,
0x0000004f005f7306ULL, 0x000e620000205400ULL, 0x000000676600720bULL, 0x008fe40003fdd000ULL,
0x00000065340d723eULL, 0x000fca00000010ffULL, 0x0000003e00437306ULL, 0x000ea4000000d400ULL,
0x0000000c2818723cULL, 0x000b680000041818ULL, 0x000000015a5a6812ULL, 0x000fe400078efcffULL,
0x0000003f000b7306ULL, 0x000ee2000000d400ULL, 0x0000005f5d00720bULL, 0x002fe40003f7d000ULL,
0x0000003c000c7245ULL, 0x020fc4000020d400ULL, 0x0000003d000d7245ULL, 0x000fc6000020d400ULL,
0x0000004c00537306ULL, 0x000fe20000209400ULL, 0x0000000143432812ULL, 0x004fc800078efcffULL,
0x000000435a34723eULL, 0x000fe400000010ffULL, 0x0000000136363812ULL, 0x000fe200078efcffULL,
0x0000004c00557306ULL, 0x0002a20000205400ULL, 0x000000010b0b5812ULL, 0x008fc800078efcffULL,
0x0000000b3635723eULL, 0x000fe400000010ffULL, 0x00000042000b7245ULL, 0x000fe2000020d400ULL,
0x0000003c003e7306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x002fe4000020d400ULL,
0x000000010b0b0812ULL, 0x000fe200078efcffULL, 0x000000342830723cULL, 0x000f680000041830ULL,
0x0000003c003f7306ULL, 0x000e620000205400ULL, 0x000000555300720bULL, 0x004fce0003f9d000ULL,
0x0000003d00577306ULL, 0x000fec0000209400ULL, 0x000000014c4c4812ULL, 0x000fe400078efcffULL,
0x0000003d00387306ULL, 0x000ea20000205400ULL, 0x0000003f3e00720bULL, 0x002fda0003fdd000ULL,
0x000000010c0c6812ULL, 0x000fe400078efcffULL, 0x000000385700720bULL, 0x004fe40003f5d000ULL,
0x0000000c0b0c723eULL, 0x000fd600000010ffULL, 0x000000010d0d2812ULL, 0x000fc800078efcffULL,
0x0000000d4c0d723eULL, 0x000fce00000010ffULL, 0x0000000c2828723cULL, 0x000b6e0000041814ULL,
0x0000f6c8740c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000c0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688005cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0b7224ULL, 0x000fc600078e00ffULL,
0x0000000000147805ULL, 0x000fc80000015200ULL, 0x0000040005177984ULL, 0x000ee40000000800ULL,
0x8000000017ff7812ULL, 0x00afc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040005177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002147824ULL, 0x000fca00078e00ffULL, 0xffffffe0140b7812ULL, 0x000fca00078ec0ffULL,
0x00000100440b7824ULL, 0x000fca00078e020bULL, 0x000000800b0d7810ULL, 0x000fe20007ffe0ffULL,
0x00005900400b7a24ULL, 0x010fc600078e02ffULL, 0x000000200d0c7812ULL, 0x000fe200078ec0ffULL,
0x000000400b0b7824ULL, 0x000fc800078e00ffULL, 0x0000000175357824ULL, 0x000fe200078e020cULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000001014157812ULL, 0x000fe400078ec0ffULL,
0x0000000d6e0c7217ULL, 0x000fe40007800000ULL, 0x00000003ff147819ULL, 0x000fc60000011645ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0dULL, 0x0000000414177810ULL, 0x040fe20007ffe0ffULL,
0x0000000114167824ULL, 0x040fe200078e0215ULL, 0x0000000c14377810ULL, 0x000fe40007ffe0ffULL,
0x0000000c150c7217ULL, 0x000fe20007800000ULL, 0x00000001160d7824ULL, 0x040fe400078e0245ULL,
0x0000000816367824ULL, 0x000fe400078e00ffULL, 0x000000010c0c7824ULL, 0x000fc400078e0a15ULL,
0x00000001373c7824ULL, 0x000fe200078e0215ULL, 0xfffffff836367812ULL, 0x000fe400078ee20dULL,
0x00000008140d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1400720cULL, 0x080fe20003f86070ULL,
0x0000000116147824ULL, 0x000fe200078e0235ULL, 0x0000000c1700720cULL, 0x080fe20003f66070ULL,
0x000000010d347824ULL, 0x140fe200078e0215ULL, 0x0000000c0d00720cULL, 0x080fe20003f46070ULL,
0x0000000117167824ULL, 0x000fe200078e0215ULL, 0x0000000c3700720cULL, 0x000fe20003f06070ULL,
0x00000001340c7824ULL, 0x040fe200078e0245ULL, 0x000062000b377a11ULL, 0x000fe200078a38ffULL,
0x0000000834177824ULL, 0x000fc400078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000063000b397a11ULL, 0x000fe400028f3cffULL, 0xfffffff8173a7812ULL, 0x000fe200078ee20cULL,
0x00000001160d7824ULL, 0x000fe200078e0245ULL, 0x0000004b14147212ULL, 0x000fe200078efcffULL,
0x0000000816387824ULL, 0x040fe400078e00ffULL, 0x0000000116167824ULL, 0x100fe200078e0235ULL,
0x0000001437147210ULL, 0x000fe20007fbe0ffULL, 0x0000000134347824ULL, 0x000fe200078e0235ULL,
0xfffffff838387812ULL, 0x000fe200078ee20dULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x000000013c0c7824ULL, 0x000fe200078e0235ULL, 0x0000004b16167212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000004b34347212ULL, 0x000fc600078efcffULL, 0x0000000115157824ULL, 0x000fe200028e0639ULL,
0x0000003716167210ULL, 0x000fe20007fbe0ffULL, 0x000000013c0b7824ULL, 0x000fe200078e0245ULL,
0x0000004b0c0c7212ULL, 0x000fe200078efcffULL, 0x000000083c3c7824ULL, 0x000fe400078e00ffULL,
0x0000000117177824ULL, 0x000fe200028e0639ULL, 0x0000003734347210ULL, 0x080fe40007fbe0ffULL,
0x000000370c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001038377824ULL, 0x000fe200078e025bULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL, 0x00000010360b7824ULL, 0x000fc400078e025bULL,
0x0000000135357824ULL, 0x100fe400028e0639ULL, 0x000000010d0d7824ULL, 0x000fe200030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140b7faeULL, 0x0003e2000e101c48ULL,
0x000000103a397824ULL, 0x100fe400078e025bULL, 0x000000103c3b7824ULL, 0x000fe200078e025bULL,
0x0000000016377faeULL, 0x0003e8000d901c48ULL, 0x0000000034397faeULL, 0x0003e8000d101c48ULL,
0x000000000c3b7faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001014147812ULL, 0x000fe400078ec0ffULL, 0x000062000b377a11ULL, 0x000fc400078038ffULL,
0x00000014450c7211ULL, 0x000fe400078fe8ffULL, 0x000063000b397a11ULL, 0x000fe400000f3cffULL,
0x000000040c167810ULL, 0x040fe20007ffe0ffULL, 0x000000010c0d7824ULL, 0x040fe200078e0245ULL,
0x000000080c387810ULL, 0x040fe20007ffe0ffULL, 0x000000080c367824ULL, 0x040fe200078e00ffULL,
0x0000000c0c3a7810ULL, 0x040fe20007ffe0ffULL, 0x000000010c147824ULL, 0x100fe400078e0235ULL,
0x0000000116347824ULL, 0x000fe200078e0235ULL, 0xfffffff836367812ULL, 0x000fe200078ee20dULL,
0x00000001160d7824ULL, 0x000fc400078e0245ULL, 0x00000008163c7824ULL, 0x000fe400078e00ffULL,
0x0000000138167824ULL, 0x100fe400078e0235ULL, 0x000000013a0c7824ULL, 0x000fe400078e0235ULL,
0x0000000138177824ULL, 0x040fe400078e0245ULL, 0x00000008383e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c387812ULL, 0x000fe200078ee20dULL, 0x000000013a357824ULL, 0x000fc400078e0245ULL,
0x000000083a407824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3a7812ULL, 0x000fe200078ee217ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff8403c7812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004b14147212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001437147210ULL, 0x040fe40007f1e0ffULL,
0x0000004b34347212ULL, 0x080fe200078efcffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000004b16167212ULL, 0x080fe400078efcffULL, 0x0000003437347210ULL, 0x000fe20007f5e0ffULL,
0x0000000115157824ULL, 0x000fe200000e0639ULL, 0x0000004b0c0c7212ULL, 0x000fe200078efcffULL,
0x00000010360b7824ULL, 0x000fe200078e025bULL, 0x0000001637167210ULL, 0x000fe20007f1e0ffULL,
0x0000000135357824ULL, 0x000fe200010e0639ULL, 0x0000000c370c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001038377824ULL, 0x000fe200078e025bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140b7faeULL, 0x0003e2000b901c48ULL, 0x0000000117177824ULL, 0x000fc400000e0639ULL,
0x000000010d0d7824ULL, 0x000fe200018e0639ULL, 0x0000000034377faeULL, 0x0003e2000b901c48ULL,
0x000000103a397824ULL, 0x100fe400078e025bULL, 0x000000103c3b7824ULL, 0x000fc600078e025bULL,
0x0000000016397faeULL, 0x0003e8000b901c48ULL, 0x000000000c3b7faeULL, 0x0003e4000b901c48ULL,
0x00000008020b7824ULL, 0x002fe200078e00ffULL, 0x00000002070c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff407424ULL, 0x000fc600078e00ffULL, 0xfffffff00b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000006f0c00720cULL, 0x000fe40003f06070ULL, 0x000000000b0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x00000001760c8824ULL, 0x000fc400078e020cULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000064000c0c8625ULL, 0x000fca00078e000dULL,
0x000000080c408981ULL, 0x000722000c1e1900ULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x008fec0000008000ULL, 0x00f6a8000b0c7f8cULL, 0x0002e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280008147f8cULL, 0x0002a4000c80043fULL,
0x0000000000167805ULL, 0x000fc40000015200ULL, 0x00f62c00080b7984ULL, 0x002e640000000800ULL,
0x800000000bff7812ULL, 0x006fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003416347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011435ULL, 0x000000340b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x000000020b0b7819ULL, 0x000fc80000001234ULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c00080b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020020b7824ULL, 0x000fca00078e00ffULL,
0xffffff800b147812ULL, 0x000fc800078ec0ffULL, 0x000000804b0b7810ULL, 0x000fca0007ffe014ULL,
0x00000001620b7824ULL, 0x000fca00078e020bULL, 0x00f000000b167984ULL, 0x000e680000000800ULL,
0x00f200000b177984ULL, 0x0004e20000000800ULL, 0x000000091600720bULL, 0x002fe20003f1d000ULL,
0x000111927f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0b357812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0b7424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000001780b7810ULL, 0x000fe40007ffe0ffULL, 0x000000091600720bULL, 0x000fe40003f54000ULL,
0x000000020b00720cULL, 0x000fe20003f05270ULL, 0x000111427f007947ULL, 0x000fd4000b800000ULL,
0x0000000000347806ULL, 0x000fc400010e0100ULL, 0x0000008002158824ULL, 0x000fe200078e024bULL,
0x00000009160b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x0000000162368824ULL, 0x000fca00078e0215ULL,
0x00f4000b36008388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000916147209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff34ff7812ULL, 0x000fc6000780c0ffULL,
0x00000009140b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b00377308ULL, 0x000e640000000800ULL, 0x000000370a0a7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011645ULL,
0x000110627f007947ULL, 0x000fea000b800000ULL, 0x00001f0b370b7589ULL, 0x0002a400000e0000ULL,
0x0000000b24247220ULL, 0x084fe20000410000ULL, 0x0000000b25257220ULL, 0x080fe20000410000ULL,
0x0000000b2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000b10107220ULL, 0x080fe20000410000ULL, 0x0000000b11117220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b21217220ULL, 0x080fe20000410000ULL,
0x0000000b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x080fe20000410000ULL,
0x0000000b30307220ULL, 0x080fe20000410000ULL, 0x0000000b31317220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0034ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008450b7811ULL, 0x000fe200078ff0ffULL,
0x00010f427f007947ULL, 0x000fea000b800000ULL, 0x00001f0b370b7589ULL, 0x00046400000e0000ULL,
0x0000000b26267220ULL, 0x086fe20000410000ULL, 0x0000000b27277220ULL, 0x080fe20000410000ULL,
0x0000000b2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000b12127220ULL, 0x080fe20000410000ULL, 0x0000000b13137220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x080fe20000410000ULL, 0x0000000b23237220ULL, 0x080fe20000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000b32327220ULL, 0x080fe20000410000ULL, 0x0000000b33337220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000916097209ULL, 0x000fd60007810000ULL,
0x8000000916160221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600040308ULL, 0x000e640000000800ULL,
0x0000000417170220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000a170a7221ULL, 0x008fc20000010000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000000802167824ULL, 0x000fca00078e00ffULL, 0xfffffff016347812ULL, 0x000fca00078ec0ffULL,
0x00f6b40034177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40034177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100b0b7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000004ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011645ULL,
0x00005410000e7816ULL, 0x000fe20000000000ULL, 0x00010af27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e037589ULL, 0x0002a400000e0000ULL, 0x000000080f0b7810ULL, 0x000fe20007ffe0ffULL,
0x00010b227f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0e007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e000eULL, 0x000065f000157802ULL, 0x000fc40000000f00ULL,
0x0001132000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e000eULL,
0x0000664000157802ULL, 0x000fc40000000f00ULL, 0x000112d000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000010005b0f7810ULL, 0x002fe20007ffe0ffULL, 0x009800004a38783bULL, 0x000e680000000200ULL,
0x00000010414d7824ULL, 0x000fc400078e020fULL, 0x0000001047347824ULL, 0x100fe400078e020fULL,
0x00000010484c7824ULL, 0x000fe200078e020fULL, 0x000000004d3c783bULL, 0x000ee80000004200ULL,
0x000000003434783bULL, 0x000ea40000004200ULL, 0x0000000338388231ULL, 0x086fe400003400ffULL,
0x000000033a3a8231ULL, 0x000fc400003400ffULL, 0x0000000039398231ULL, 0x080fe400003400ffULL,
0x000000003b3b8231ULL, 0x000fe200003400ffULL, 0x000001003c147824ULL, 0x008fe200078e00ffULL,
0x0000003d00647306ULL, 0x000fe20000009400ULL, 0x000001003f6a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011414ULL, 0x000001003d147824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x0000003d00657306ULL, 0x000e640000005400ULL,
0x00000018ff667819ULL, 0x000fe40000011414ULL, 0x000000004c14783bULL, 0x000ea80000004200ULL,
0x0000006600677306ULL, 0x000ff00000209400ULL, 0x0000006600687306ULL, 0x0006e20000205400ULL,
0x000000656400720bULL, 0x002fc40003f9d000ULL, 0x0000004e00657245ULL, 0x000fe4000020d400ULL,
0x00000018ff647819ULL, 0x000fc6000001143dULL, 0x0000003c000e7306ULL, 0x000fe20000009400ULL,
0x0000006600667245ULL, 0x008fce000020d400ULL, 0x0000003c00517306ULL, 0x000e620000005400ULL,
0x000000686700720bULL, 0x000fce0003fbd000ULL, 0x0000004e00537306ULL, 0x000fec0000209400ULL,
0x0000000166665812ULL, 0x000fe400078efcffULL, 0x0000004e00547306ULL, 0x0006a20000205400ULL,
0x000000510e00720bULL, 0x002fce0003f5d000ULL, 0x0000003d00437306ULL, 0x000262000000d400ULL,
0x00000018ff4e7819ULL, 0x008fce000001143cULL, 0x0000003c00427306ULL, 0x0006e2000000d400ULL,
0x000000545300720bULL, 0x004fe20003f7d000ULL, 0x000100003d3d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003e004f7306ULL, 0x000fe20000009400ULL,
0x000100003c3c7824ULL, 0x008fe200078e00ffULL, 0x0000000143434812ULL, 0x000fc800078efcffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e00507306ULL, 0x000e620000005400ULL,
0x0000000142422812ULL, 0x000fe400078efcffULL, 0x0000000165653812ULL, 0x000fe400078efcffULL,
0x000000436643723eULL, 0x000fe400000010ffULL, 0x000000426542723eULL, 0x000fe200000010ffULL,
0x0000003f00587306ULL, 0x000fec0000009400ULL, 0x000000423824723cULL, 0x000b640000041824ULL,
0x0000003f00637306ULL, 0x000ea20000005400ULL, 0x000000504f00720bULL, 0x002fce0003f9d000ULL,
0x0000003c00667306ULL, 0x000ff00000209400ULL, 0x0000003c00677306ULL, 0x0002e20000205400ULL,
0x000000635800720bULL, 0x004fe20003f7d000ULL, 0x000001003e587824ULL, 0x000fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000004e00657306ULL, 0x000fe20000209400ULL,
0x0000003c003c7245ULL, 0x002fce000020d400ULL, 0x0000004e00427306ULL, 0x020e620000205400ULL,
0x000000676600720bULL, 0x008fce0003fbd000ULL, 0x0000006400437306ULL, 0x000fec0000209400ULL,
0x000000013c3c5812ULL, 0x000fe400078efcffULL, 0x0000006400687306ULL, 0x000ea20000205400ULL,
0x000000426500720bULL, 0x002fce0003fdd000ULL, 0x0000003d00507306ULL, 0x000ff00000209400ULL,
0x0000003d00637306ULL, 0x0002e20000205400ULL, 0x000000684300720bULL, 0x004fce0003f5d000ULL,
0x0000006a00437306ULL, 0x000fe20000209400ULL, 0x0000003d003d7245ULL, 0x002fce000020d400ULL,
0x0000006a00687306ULL, 0x0002a20000205400ULL, 0x000000635000720bULL, 0x008fe40003fbd000ULL,
0x0000004e00637245ULL, 0x000fe4000020d400ULL, 0x00000018ff4e7819ULL, 0x000fe4000001143eULL,
0x0000000163636812ULL, 0x000fe200078efcffULL, 0x0000005800657306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x002fe4000020d400ULL, 0x0000003c633c723eULL, 0x000fc400000010ffULL,
0x00000018ff637819ULL, 0x000fe4000001143fULL, 0x000000013d3d5812ULL, 0x000fe200078efcffULL,
0x0000005800667306ULL, 0x000e620000205400ULL, 0x000000684300720bULL, 0x004fe40003fbd000ULL,
0x0000006400687245ULL, 0x000fc8000020d400ULL, 0x0000000168682812ULL, 0x000fe200078efcffULL,
0x0000003e00577306ULL, 0x0004e6000000d400ULL, 0x0000003d683d723eULL, 0x000fc600000010ffULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x0000003f000b7306ULL, 0x0006e2000000d400ULL,
0x000100003e3e7824ULL, 0x004fe200078e00ffULL, 0x000000666500720bULL, 0x002fe20003fdd000ULL,
0x0000003c382c723cULL, 0x000b66000004182cULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000004e00657306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x008fe200078e00ffULL,
0x00000058003c7245ULL, 0x020fc4000020d400ULL, 0x0000000157574812ULL, 0x000fe400078efcffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000004e00667306ULL, 0x000e620000205400ULL,
0x000000010b0b3812ULL, 0x000fe400078efcffULL, 0x000000013c3c6812ULL, 0x000fe400078efcffULL,
0x0000000b6a3d723eULL, 0x000fe400000010ffULL, 0x000000573c3c723eULL, 0x000fe200000010ffULL,
0x0000003e00677306ULL, 0x000fec0000209400ULL, 0x0000003c3810723cULL, 0x000b640000041810ULL,
0x0000003e00697306ULL, 0x0004e20000205400ULL, 0x000000666500720bULL, 0x002fe20003f7d000ULL,
0x0001000034657824ULL, 0x000fc600078e00ffULL, 0x0000004e003d7245ULL, 0x020fe4000020d400ULL,
0x0000003e003c7245ULL, 0x000fe2000020d400ULL, 0x0000006300437306ULL, 0x000fe20000209400ULL,
0x0000003f003e7245ULL, 0x004fe4000020d400ULL, 0x00000018ff657819ULL, 0x000fc60000011465ULL,
0x000000013d3d3812ULL, 0x000fe400078efcffULL, 0x0000006300647306ULL, 0x0002a20000205400ULL,
0x000000696700720bULL, 0x008fe20003f5d000ULL, 0x0000010035677824ULL, 0x000fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000003f00687306ULL, 0x000fe20000209400ULL,
0x0000006300637245ULL, 0x002fca000020d400ULL, 0x000000013c3c2812ULL, 0x000fe400078efcffULL,
0x0000003f006b7306ULL, 0x000e620000205400ULL, 0x000000644300720bULL, 0x004fe40003fbd000ULL,
0x0000003c3d3c723eULL, 0x000fe400000010ffULL, 0x00000018ff647819ULL, 0x000fc60000011434ULL,
0x00000034005c7306ULL, 0x000fec0000009400ULL, 0x0000000163635812ULL, 0x000fe400078efcffULL,
0x0000006b6800720bULL, 0x002fe20003f9d000ULL, 0x0000010034687824ULL, 0x000fe200078e00ffULL,
0x00000034005d7306ULL, 0x000e680000005400ULL, 0x00000018ff687819ULL, 0x000fc80000011468ULL,
0x00000035005e7306ULL, 0x000fe60000009400ULL, 0x000000013e3e4812ULL, 0x000fc800078efcffULL,
0x0000003e633d723eULL, 0x000fe200000010ffULL, 0x00000035005f7306ULL, 0x000ea20000005400ULL,
0x0000005d5c00720bULL, 0x002fe40003f5d000ULL, 0x00000067005c7245ULL, 0x000fc6000020d400ULL,
0x0000003c3820723cULL, 0x000b640000041820ULL, 0x00000068003f7306ULL, 0x000fea0000209400ULL,
0x00000010463c7824ULL, 0x020fc600078e020fULL, 0x0000006800667306ULL, 0x000e620000205400ULL,
0x0000005f5e00720bULL, 0x004fe40003f9d000ULL, 0x00000018ff5f7819ULL, 0x000fc80000011435ULL,
0x0000005f006c7245ULL, 0x000fe2000020d400ULL, 0x00000067003e7306ULL, 0x000ff00000209400ULL,
0x00000067003d7306ULL, 0x000ea20000205400ULL, 0x000000663f00720bULL, 0x002fe20003f7d000ULL,
0x0001000035667824ULL, 0x000fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x00000034005a7306ULL, 0x000e70000000d400ULL, 0x0000003500597306ULL, 0x000662000000d400ULL,
0x0000003d3e00720bULL, 0x004fc40003fbd000ULL, 0x000000003c3c783bULL, 0x000fea0000004200ULL,
0x0000006400637306ULL, 0x000fe20000209400ULL, 0x0000006800357245ULL, 0x008fe4000020d400ULL,
0x000000015a5a2812ULL, 0x002fe400078efcffULL, 0x0000000135353812ULL, 0x000fc400078efcffULL,
0x000000015c5c5812ULL, 0x000fe200078efcffULL, 0x00000064005d7306ULL, 0x000e620000205400ULL,
0x0000000159594812ULL, 0x000fe400078efcffULL, 0x0000005a3534723eULL, 0x000fe400000010ffULL,
0x000000595c35723eULL, 0x000fc600000010ffULL, 0x00000065005e7306ULL, 0x000fe80000209400ULL,
0x00000034381c723cULL, 0x000be8000004181cULL, 0x00000065006b7306ULL, 0x0004e20000205400ULL,
0x0000005d6300720bULL, 0x002fe40003f7d000ULL, 0x0000006400357245ULL, 0x020fe2000020d400ULL,
0x0000010036647824ULL, 0x000fe200078e00ffULL, 0x0000006500347245ULL, 0x000fc4000020d400ULL,
0x00000018ff637819ULL, 0x000fe20000011436ULL, 0x0000005f00697306ULL, 0x000fe20000209400ULL,
0x0000010037657824ULL, 0x004fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fc80000011464ULL,
0x0000000135353812ULL, 0x000fe400078efcffULL, 0x0000005f006a7306ULL, 0x000e620000205400ULL,
0x0000006b5e00720bULL, 0x008fe40003f5d000ULL, 0x00000018ff657819ULL, 0x000fca0000011465ULL,
0x0000006600677306ULL, 0x000fec0000209400ULL, 0x0000000134342812ULL, 0x000fe400078efcffULL,
0x0000006600687306ULL, 0x000ea20000205400ULL, 0x0000006a6900720bULL, 0x002fe40003fbd000ULL,
0x000000343534723eULL, 0x000fc400000010ffULL, 0x0000006600357245ULL, 0x000fc6000020d400ULL,
0x0000003600527306ULL, 0x000fec0000009400ULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x000000686700720bULL, 0x004fe20003f9d000ULL, 0x0000003600567306ULL, 0x000e700000005400ULL,
0x0000006300677306ULL, 0x000fe80000209400ULL, 0x0000000135354812ULL, 0x000fc800078efcffULL,
0x0000006300687306ULL, 0x0004e20000205400ULL, 0x000000356c35723eULL, 0x000fe400000010ffULL,
0x000000565200720bULL, 0x002fe40003fdd000ULL, 0x00000018ff567819ULL, 0x000fc60000011437ULL,
0x0000006500667306ULL, 0x000fe20000209400ULL, 0x000000343818723cULL, 0x000b620000041818ULL,
0x0000006300637245ULL, 0x004fcc000020d400ULL, 0x00000065006b7306ULL, 0x000e620000205400ULL,
0x000000686700720bULL, 0x008fe20003f7d000ULL, 0x0001000037677824ULL, 0x000fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000003700547306ULL, 0x000fec0000009400ULL,
0x0000000163633812ULL, 0x000fe400078efcffULL, 0x0000003700537306ULL, 0x000ea20000005400ULL,
0x0000006b6600720bULL, 0x002fe20003fbd000ULL, 0x0001000036667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000006400697306ULL, 0x000ff00000209400ULL,
0x00000064006a7306ULL, 0x000e620000205400ULL, 0x000000535400720bULL, 0x004fce0003f5d000ULL,
0x0000003600557306ULL, 0x000eb0000000d400ULL, 0x0000005600347306ULL, 0x020fe20000209400ULL,
0x0000006a6900720bULL, 0x002fce0003f9d000ULL, 0x0000005600357306ULL, 0x0002e20000205400ULL,
0x0000000155556812ULL, 0x004fce00078efcffULL, 0x0000003700517306ULL, 0x000ea2000000d400ULL,
0x0000005600567245ULL, 0x002fce000020d400ULL, 0x0000006600547306ULL, 0x000fe20000209400ULL,
0x000000353400720bULL, 0x008fe40003fdd000ULL, 0x0000006400347245ULL, 0x000fe4000020d400ULL,
0x0000006500647245ULL, 0x000fe4000020d400ULL, 0x0000000134344812ULL, 0x000fe200078efcffULL,
0x0000006600377306ULL, 0x000e620000205400ULL, 0x0000000151512812ULL, 0x004fe400078efcffULL,
0x0000000164645812ULL, 0x000fc400078efcffULL, 0x000000553434723eULL, 0x000fe400000010ffULL,
0x000000516435723eULL, 0x000fe200000010ffULL, 0x0000006700687306ULL, 0x000fe20000209400ULL,
0x0000000156566812ULL, 0x000fe200078efcffULL, 0x0000010014647824ULL, 0x000fc800078e00ffULL,
0x000000343830723cULL, 0x000b620000041830ULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000006700697306ULL, 0x000ea20000205400ULL, 0x000000375400720bULL, 0x002fc80003f5d000ULL,
0x0000006600347245ULL, 0x020fe4000020d400ULL, 0x0000006700357245ULL, 0x000fe2000020d400ULL,
0x00000014000e7306ULL, 0x000fec0000009400ULL, 0x0000000134342812ULL, 0x000fe400078efcffULL,
0x000000696800720bULL, 0x004fe20003f9d000ULL, 0x00000014004f7306ULL, 0x000e620000005400ULL,
0x000000346334723eULL, 0x000fe200000010ffULL, 0x0000010016687824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fc80000011414ULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000001500507306ULL, 0x000fe80000009400ULL, 0x0000000135354812ULL, 0x000fc800078efcffULL,
0x0000001500587306ULL, 0x000ea20000005400ULL, 0x000000355635723eULL, 0x000fe400000010ffULL,
0x0000004f0e00720bULL, 0x002fe20003fdd000ULL, 0x00000100154f7824ULL, 0x000fc800078e00ffULL,
0x000000343838723cULL, 0x000b620000041828ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000006400287306ULL, 0x020fea0000209400ULL, 0x00000018ff347819ULL, 0x000fe40000011415ULL,
0x000000585000720bULL, 0x004fe20003f5d000ULL, 0x0000006400297306ULL, 0x000e700000205400ULL,
0x0000004f00677306ULL, 0x000ff00000209400ULL, 0x0000004f00507306ULL, 0x000ea20000205400ULL,
0x000000292800720bULL, 0x002fc40003f7d000ULL, 0x009800004928783bULL, 0x000e6a0000000200ULL,
0x0000001400427306ULL, 0x0006b0000000d400ULL, 0x0000001500577306ULL, 0x0004a2000000d400ULL,
0x0001000014147824ULL, 0x008fe200078e00ffULL, 0x000000506700720bULL, 0x004fc40003fbd000ULL,
0x00000018ff507819ULL, 0x000fe40000011416ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000006300567306ULL, 0x000fe20000209400ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000000142426812ULL, 0x000fc800078efcffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000006300657306ULL, 0x000ea20000205400ULL, 0x0000000157572812ULL, 0x000fce00078efcffULL,
0x0000003400357306ULL, 0x000fe20000209400ULL, 0x0000000328288231ULL, 0x082fe400003400ffULL,
0x000000032a2a8231ULL, 0x000fe400003400ffULL, 0x0000000029298231ULL, 0x000fc600003400ffULL,
0x00000034000e7306ULL, 0x0002e20000205400ULL, 0x000000655600720bULL, 0x004fe20003f9d000ULL,
0x000000002b2b8231ULL, 0x000fe200003400ffULL, 0x0000006400657245ULL, 0x000fe4000020d400ULL,
0x0000004f00647245ULL, 0x000fe4000020d400ULL, 0x0000000165653812ULL, 0x000fe200078efcffULL,
0x0000001400667306ULL, 0x000fe20000209400ULL, 0x0000000164645812ULL, 0x000fe400078efcffULL,
0x0000003400347245ULL, 0x002fc4000020d400ULL, 0x000000426556723eULL, 0x000fe400000010ffULL,
0x00000018ff427819ULL, 0x000fe20000011417ULL, 0x0000001400697306ULL, 0x0002a20000205400ULL,
0x0000000e3500720bULL, 0x008fe40003f7d000ULL, 0x000000576457723eULL, 0x000fca00000010ffULL,
0x0000001500587306ULL, 0x000fe20000209400ULL, 0x0000001400147245ULL, 0x002fe2000020d400ULL,
0x000000562824723cULL, 0x000b680000041824ULL, 0x0000000134343812ULL, 0x000fe400078efcffULL,
0x0000001500677306ULL, 0x0002e20000205400ULL, 0x000000696600720bULL, 0x004fe40003fdd000ULL,
0x00000018ff577819ULL, 0x020fc4000001143cULL, 0x00000018ff567819ULL, 0x000fc6000001143dULL,
0x00000016000b7306ULL, 0x000fe20000009400ULL, 0x0000001500157245ULL, 0x002fca000020d400ULL,
0x0000000114146812ULL, 0x000fe400078efcffULL, 0x000000675800720bULL, 0x008fe20003fbd000ULL,
0x0000001600437306ULL, 0x000e620000005400ULL, 0x0000006300677245ULL, 0x000fc8000020d400ULL,
0x0000000167674812ULL, 0x000fc600078efcffULL, 0x0000003c005d7306ULL, 0x000fe20000009400ULL,
0x000000146714723eULL, 0x000fc600000010ffULL, 0x0000000115155812ULL, 0x000fc800078efcffULL,
0x000000153415723eULL, 0x000fe200000010ffULL, 0x0000003c005e7306ULL, 0x000ea20000005400ULL,
0x000000430b00720bULL, 0x002fe20003fdd000ULL, 0x0000010017437824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fc6000001143eULL, 0x00000014282c723cULL, 0x000b62000004182cULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000001700597306ULL, 0x000ff00000009400ULL,
0x00000017005a7306ULL, 0x000e620000005400ULL, 0x0000005e5d00720bULL, 0x004fce0003f5d000ULL,
0x0000006800347306ULL, 0x000ff00000209400ULL, 0x0000006800157306ULL, 0x020ea20000205400ULL,
0x0000005a5900720bULL, 0x002fe20003fbd000ULL, 0x0001000016597824ULL, 0x000fca00078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000003e00517306ULL, 0x000ff00000009400ULL,
0x0000003e00547306ULL, 0x000e620000005400ULL, 0x000000153400720bULL, 0x004fc40003f1d000ULL,
0x00000018ff347819ULL, 0x000fca000001143fULL, 0x0000003d00527306ULL, 0x000ff00000009400ULL,
0x0000003d00537306ULL, 0x000ea20000005400ULL, 0x000000545100720bULL, 0x002fe20003f7d000ULL,
0x0001000017547824ULL, 0x000fe200078e00ffULL, 0x0000006800517245ULL, 0x000fc8000020d400ULL,
0x0000000151510812ULL, 0x000fe200078efcffULL, 0x00000043005e7306ULL, 0x000fe20000209400ULL,
0x00000018ff547819ULL, 0x000fce0000011454ULL, 0x0000004300697306ULL, 0x0002e20000205400ULL,
0x000000535200720bULL, 0x004fce0003f9d000ULL, 0x00000016004e7306ULL, 0x000ea2000000d400ULL,
0x0000004300437245ULL, 0x002fce000020d400ULL, 0x00000059005d7306ULL, 0x000fe20000209400ULL,
0x000000695e00720bULL, 0x008fce0003f1d000ULL, 0x0000005900527306ULL, 0x000e620000205400ULL,
0x000000014e4e6812ULL, 0x004fc800078efcffULL, 0x0000004e514e723eULL, 0x000fe400000010ffULL,
0x0000000143430812ULL, 0x000fe200078efcffULL, 0x0000003f00557306ULL, 0x000ff00000009400ULL,
0x0000003f00357306ULL, 0x000ea20000005400ULL, 0x000000525d00720bULL, 0x002fc40003fdd000ULL,
0x0000005900527245ULL, 0x000fe4000020d400ULL, 0x0000005000597245ULL, 0x000fc6000020d400ULL,
0x00000017005c7306ULL, 0x000e6c000000d400ULL, 0x0000000152526812ULL, 0x000fe400078efcffULL,
0x00000050004f7306ULL, 0x000fe20000209400ULL, 0x000000355500720bULL, 0x004fe20003f1d000ULL,
0x000001003c357824ULL, 0x000fcc00078e00ffULL, 0x0000005000587306ULL, 0x0004e20000205400ULL,
0x000000015c5c5812ULL, 0x002fce00078efcffULL, 0x0000005400537306ULL, 0x000fe20000209400ULL,
0x0000005400507245ULL, 0x004fce000020d400ULL, 0x00000054005e7306ULL, 0x0002a20000205400ULL,
0x000000584f00720bULL, 0x008fe40003fbd000ULL, 0x00000018ff4f7819ULL, 0x000fca0000011435ULL,
0x0000004200647306ULL, 0x000fe20000209400ULL, 0x000001003e547824ULL, 0x002fca00078e00ffULL,
0x0000000159595812ULL, 0x000fe400078efcffULL, 0x0000004200637306ULL, 0x000e620000205400ULL,
0x0000005e5300720bULL, 0x004fe20003fdd000ULL, 0x000001003d537824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x000100003c5e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000004f00557306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x000fca000001145eULL, 0x0000000150506812ULL, 0x000fe400078efcffULL,
0x0000004f00587306ULL, 0x000ea20000205400ULL, 0x000000636400720bULL, 0x002fce0003fbd000ULL,
0x00000053005d7306ULL, 0x000ff00000209400ULL, 0x0000005300647306ULL, 0x0002e20000205400ULL,
0x000000585500720bULL, 0x004fe20003fdd000ULL, 0x000100003d587824ULL, 0x000fe200078e00ffULL,
0x0000004200557245ULL, 0x000fc4000020d400ULL, 0x0000004f00427245ULL, 0x000fe4000020d400ULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000005700657306ULL, 0x000fe20000209400ULL,
0x0000000155555812ULL, 0x000fe400078efcffULL, 0x0000005300537245ULL, 0x002fe4000020d400ULL,
0x0000005c434f723eULL, 0x000fe400000010ffULL, 0x0000000142426812ULL, 0x000fe200078efcffULL,
0x0000005700667306ULL, 0x000e620000205400ULL, 0x000000645d00720bULL, 0x008fc40003fdd000ULL,
0x0000005e00437245ULL, 0x000fe2000020d400ULL, 0x0000004e2810723cULL, 0x000b620000041810ULL,
0x00000057005c7245ULL, 0x000fc6000020d400ULL, 0x0000005e00357306ULL, 0x000fe60000209400ULL,
0x00000056004f7245ULL, 0x020fc6000020d400ULL, 0x0000000153536812ULL, 0x000fe400078efcffULL,
0x0000005e00687306ULL, 0x000ea20000205400ULL, 0x000000666500720bULL, 0x002fce0003fbd000ULL,
0x0000003c005f7306ULL, 0x000e6c000000d400ULL, 0x000000015c5c5812ULL, 0x000fe400078efcffULL,
0x0000003d00367306ULL, 0x000662000000d400ULL, 0x000000683500720bULL, 0x004fe20003fdd000ULL,
0x000100003e357824ULL, 0x000fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x00000058003c7306ULL, 0x000fe20000209400ULL, 0x000001003f3d7824ULL, 0x008fe200078e00ffULL,
0x000000015f5f2812ULL, 0x002fc800078efcffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005800657306ULL, 0x0002a20000205400ULL, 0x0000000136364812ULL, 0x000fe400078efcffULL,
0x0000000143436812ULL, 0x000fca00078efcffULL, 0x0000005600677306ULL, 0x000fe20000209400ULL,
0x0000005800587245ULL, 0x002fce000020d400ULL, 0x00000056005a7306ULL, 0x000e620000205400ULL,
0x000000653c00720bULL, 0x004fe20003f9d000ULL, 0x000100003f3c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000000b00147306ULL, 0x000fec0000209400ULL,
0x0000000158584812ULL, 0x000fe400078efcffULL, 0x0000000b00157306ULL, 0x0004e20000205400ULL,
0x0000005a6700720bULL, 0x002fce0003f5d000ULL, 0x0000005400637306ULL, 0x000fe20000209400ULL,
0x0000000b000b7245ULL, 0x004fca000020d400ULL, 0x000000014f4f2812ULL, 0x000fe400078efcffULL,
0x0000005400647306ULL, 0x0002a20000205400ULL, 0x000000151400720bULL, 0x008fe40003fdd000ULL,
0x000000525914723eULL, 0x000fe400000010ffULL, 0x000000505515723eULL, 0x000fc600000010ffULL,
0x0000003e00377306ULL, 0x000ee2000000d400ULL, 0x0000005400547245ULL, 0x002fc6000020d400ULL,
0x000000142820723cULL, 0x000b640000041820ULL, 0x000000010b0b6812ULL, 0x000fe400078efcffULL,
0x0000003f000e7306ULL, 0x000e62000000d400ULL, 0x000000646300720bULL, 0x004fe40003fbd000ULL,
0x000000435c14723eULL, 0x020fe400000010ffULL, 0x000000584f15723eULL, 0x000fc600000010ffULL,
0x0000003d005a7306ULL, 0x000fe20000209400ULL, 0x0000000137373812ULL, 0x008fc600078efcffULL,
0x000000142818723cULL, 0x000b640000041818ULL, 0x0000000154545812ULL, 0x000fe400078efcffULL,
0x0000003d005d7306ULL, 0x0004e20000205400ULL, 0x000000010e0e0812ULL, 0x002fe400078efcffULL,
0x0000003500147245ULL, 0x020fe4000020d400ULL, 0x0000003c00157245ULL, 0x000fc6000020d400ULL,
0x0000003400167306ULL, 0x000fe20000209400ULL, 0x0000003d003d7245ULL, 0x004fce000020d400ULL,
0x0000003400177306ULL, 0x0002a20000205400ULL, 0x0000005d5a00720bULL, 0x008fce0003f5d000ULL,
0x00000035003e7306ULL, 0x000fe20000209400ULL, 0x0000003400347245ULL, 0x002fca000020d400ULL,
0x000000013d3d2812ULL, 0x000fe400078efcffULL, 0x00000035003f7306ULL, 0x000e620000205400ULL,
0x000000171600720bULL, 0x004fe40003f9d000ULL, 0x0000005f4216723eULL, 0x000fe400000010ffULL,
0x000000365317723eULL, 0x000fc600000010ffULL, 0x0000003c00517306ULL, 0x000fe80000209400ULL,
0x00000016281c723cULL, 0x000b64000004181cULL, 0x0000000134344812ULL, 0x000fe400078efcffULL,
0x0000003c00527306ULL, 0x000ea20000205400ULL, 0x0000003f3e00720bULL, 0x002fe40003fbd000ULL,
0x000000375416723eULL, 0x020fc400000010ffULL, 0x0000000e3d17723eULL, 0x000fce00000010ffULL,
0x000000162830723cULL, 0x000f640000041830ULL, 0x0000000114145812ULL, 0x000fe400078efcffULL,
0x000000525100720bULL, 0x004fe40003f7d000ULL, 0x000000140b14723eULL, 0x000fe200000010ffULL,
0x00000002020b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fca00078ec0ffULL,
0x0000000115153812ULL, 0x000fc800078efcffULL, 0x000000153415723eULL, 0x000fce00000010ffULL,
0x000000142828723cULL, 0x000b6e0000041838ULL, 0x0000f6c874147811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f690000eff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0b7224ULL, 0x000fc600078e00ffULL, 0x0000000000167805ULL, 0x000fc80000015200ULL,
0x0000040005357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x00afc40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003416377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x004fc80000011435ULL, 0x000000370e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x000000020e0e7819ULL, 0x000fc80000001235ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040005357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002147824ULL, 0x000fca00078e00ffULL,
0xffffffe0140b7812ULL, 0x000fca00078ec0ffULL, 0x00000100440b7824ULL, 0x000fca00078e020bULL,
0x000000c00b157810ULL, 0x000fe20007ffe0ffULL, 0x00005900400b7a24ULL, 0x010fc600078e02ffULL,
0x00000020150e7812ULL, 0x004fe200078ec0ffULL, 0x000000400b0b7824ULL, 0x000fc800078e00ffULL,
0x0000000175367824ULL, 0x000fe200078e020eULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x000000156e0e7217ULL, 0x000fe40007800000ULL, 0x0000001014177812ULL, 0x000fe400078ec0ffULL,
0x00000003ff147819ULL, 0x000fe20000011645ULL, 0x000000010e0e7824ULL, 0x000fe200078e0a15ULL,
0x000062000b397a11ULL, 0x000fe400078a38ffULL, 0x0000000414347810ULL, 0x040fe20007ffe0ffULL,
0x0000000114157824ULL, 0x000fe200078e0217ULL, 0x0000000e170e7217ULL, 0x000fc40007800000ULL,
0x0000000c14377810ULL, 0x000fe20007ffe0ffULL, 0x0000000115167824ULL, 0x000fe200078e0245ULL,
0x000063000b3b7a11ULL, 0x000fe200028f3cffULL, 0x0000000815357824ULL, 0x000fe400078e00ffULL,
0x000000010e0e7824ULL, 0x100fe400078e0a17ULL, 0x00000001373c7824ULL, 0x100fe200078e0217ULL,
0xfffffff835387812ULL, 0x000fe200078ee216ULL, 0x0000000134167824ULL, 0x000fe200078e0217ULL,
0x0000000814357810ULL, 0x000fe20007ffe0ffULL, 0x000000013c0b7824ULL, 0x100fe200078e0245ULL,
0x0000000e1400720cULL, 0x080fe20003f86070ULL, 0x0000000115147824ULL, 0x000fe200078e0236ULL,
0x0000000e3400720cULL, 0x080fe20003f66070ULL, 0x0000000116157824ULL, 0x040fe200078e0245ULL,
0x0000000e3500720cULL, 0x080fe20003f46070ULL, 0x00000008163a7824ULL, 0x000fe200078e00ffULL,
0x0000000e3700720cULL, 0x000fe20003f06070ULL, 0x0000000135347824ULL, 0x000fc400078e0217ULL,
0x0000000116167824ULL, 0x000fe200078e0236ULL, 0xfffffff83a0e7812ULL, 0x000fe200078ee215ULL,
0x0000000134177824ULL, 0x040fe400078e0245ULL, 0x00000008343e7824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83e3a7812ULL, 0x000fe200078ee217ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004b14147212ULL, 0x000fc600078efcffULL,
0x0000000134347824ULL, 0x100fe200078e0236ULL, 0x0000001439147210ULL, 0x000fe20007fbe0ffULL,
0x000000013c367824ULL, 0x000fe200078e0236ULL, 0x0000004b16167212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004b34347212ULL, 0x000fc600078efcffULL, 0x0000000115157824ULL, 0x000fe200028e063bULL,
0x0000003916167210ULL, 0x000fe20007fbe0ffULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x0000004b36367212ULL, 0x000fc600078efcffULL, 0x0000000117177824ULL, 0x000fe200028e063bULL,
0x0000003934347210ULL, 0x080fe40007fbe0ffULL, 0x0000003936367210ULL, 0x000fe20007fde0ffULL,
0x000000100e397824ULL, 0x000fe200078e020fULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL,
0x00000010380b7824ULL, 0x000fe400078e020fULL, 0x0000000135357824ULL, 0x100fe400028e063bULL,
0x0000000137377824ULL, 0x000fe200030e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140b7faeULL, 0x0003e2000e101c48ULL, 0x000000103a3b7824ULL, 0x000fc400078e020fULL,
0x000000103c3d7824ULL, 0x000fe200078e020fULL, 0x0000000016397faeULL, 0x0003e8000d901c48ULL,
0x00000000343b7faeULL, 0x0003e8000d101c48ULL, 0x00000000363d7faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001014147812ULL, 0x000fc800078ec0ffULL,
0x00000014450e7211ULL, 0x000fc800078fe8ffULL, 0x000000040e177810ULL, 0x040fe20007ffe0ffULL,
0x000000010e157824ULL, 0x040fe200078e0245ULL, 0x0000000c0e357810ULL, 0x040fe20007ffe0ffULL,
0x000000080e387824ULL, 0x040fe400078e00ffULL, 0x000000010e147824ULL, 0x100fe400078e0236ULL,
0x0000000117167824ULL, 0x040fe200078e0236ULL, 0xfffffff838387812ULL, 0x000fe200078ee215ULL,
0x0000000817397824ULL, 0x040fe200078e00ffULL, 0x000000080e157810ULL, 0x000fe20007ffe0ffULL,
0x00000001170e7824ULL, 0x000fc400078e0245ULL, 0x0000000135377824ULL, 0x100fe400078e0245ULL,
0x0000000115347824ULL, 0x000fe200078e0236ULL, 0xfffffff8390e7812ULL, 0x000fe200078ee20eULL,
0x0000000115177824ULL, 0x000fe200078e0245ULL, 0x000062000b397a11ULL, 0x000fe200078038ffULL,
0x00000008153a7824ULL, 0x000fe400078e00ffULL, 0x00000008353c7824ULL, 0x000fe200078e00ffULL,
0x000063000b3b7a11ULL, 0x000fe200000f3cffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fc400078ee217ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee237ULL,
0x0000000135367824ULL, 0x000fe200078e0236ULL, 0x0000004b14147212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000001439147210ULL, 0x000fe20007f1e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004b16167212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004b34347212ULL, 0x080fe400078efcffULL,
0x0000001639167210ULL, 0x000fe20007f5e0ffULL, 0x0000000115157824ULL, 0x000fe200000e063bULL,
0x0000004b36367212ULL, 0x000fe200078efcffULL, 0x00000010380b7824ULL, 0x000fe200078e020fULL,
0x0000003439347210ULL, 0x000fe20007f1e0ffULL, 0x0000000117177824ULL, 0x000fe200010e063bULL,
0x0000003639367210ULL, 0x000fe20007f7e0ffULL, 0x000000100e397824ULL, 0x000fe200078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140b7faeULL, 0x0003e2000b901c48ULL,
0x0000000135357824ULL, 0x000fc400000e063bULL, 0x0000000137377824ULL, 0x000fe200018e063bULL,
0x0000000016397faeULL, 0x0003e2000b901c48ULL, 0x000000103a3b7824ULL, 0x100fe400078e020fULL,
0x000000103c3d7824ULL, 0x000fc600078e020fULL, 0x00000000343b7faeULL, 0x0003e8000b901c48ULL,
0x00000000363d7faeULL, 0x0003e4000b901c48ULL, 0x00000008020b7824ULL, 0x002fe200078e00ffULL,
0x0000000307147810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0e7424ULL, 0x000fc600078e00ffULL,
0xfffffff00b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000006f1400720cULL, 0x000fe40003f06070ULL,
0x000000000b0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000176148824ULL, 0x000fc400078e0214ULL, 0x00000004ff158424ULL, 0x000fc800078e00ffULL,
0x0000640014148625ULL, 0x000fca00078e0015ULL, 0x00000008140e8981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b0000b167f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480008147f8cULL, 0x000664000c80043fULL, 0x0000000000347805ULL, 0x000fc40000015200ULL,
0x00f64c00080b7984ULL, 0x002e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634367210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011437ULL,
0x000000360b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e0637ULL,
0x000000020b0b7819ULL, 0x000fc80000001236ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c00080b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002087824ULL, 0x008fca00078e00ffULL, 0xffffff8008087812ULL, 0x000fc800078ec0ffULL,
0x000001004b0b7810ULL, 0x000fca0007ffe008ULL, 0x00000001620b7824ULL, 0x000fca00078e020bULL,
0x00f000000b347984ULL, 0x000e680000000800ULL, 0x00f200000b357984ULL, 0x0006a20000000800ULL,
0x000000093400720bULL, 0x002fe20003f1d000ULL, 0x0000de627f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0b377812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fd200078e0009ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000002780b7810ULL, 0x000fe40007ffe0ffULL, 0x000000093400720bULL, 0x000fe40003f54000ULL,
0x000000020b00720cULL, 0x000fe20003f05270ULL, 0x0000de027f007947ULL, 0x000fd4000b800000ULL,
0x0000000000087806ULL, 0x000fc400010e0100ULL, 0x0000008002158824ULL, 0x000fe200078e024bULL,
0x00000009340b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991008147816ULL, 0x000fe200000000ffULL, 0x0000000162368824ULL, 0x000fca00078e0215ULL,
0x00f4000b36008388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000934147209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL,
0x00000009140b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b00397308ULL, 0x000e640000000800ULL, 0x000000390a0a7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011645ULL,
0x0000dd227f007947ULL, 0x000fea000b800000ULL, 0x00001f0b390b7589ULL, 0x0002e400000e0000ULL,
0x0000000b24247220ULL, 0x08cfe20000410000ULL, 0x0000000b25257220ULL, 0x080fe20000410000ULL,
0x0000000b2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000b10107220ULL, 0x080fe20000410000ULL, 0x0000000b11117220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b21217220ULL, 0x080fe20000410000ULL,
0x0000000b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x080fe20000410000ULL,
0x0000000b30307220ULL, 0x080fe20000410000ULL, 0x0000000b31317220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008450b7811ULL, 0x000fe200078ff0ffULL,
0x0000dc027f007947ULL, 0x000fea000b800000ULL, 0x00001f0b390b7589ULL, 0x00066400000e0000ULL,
0x0000000b26267220ULL, 0x086fe20000410000ULL, 0x0000000b27277220ULL, 0x080fe20000410000ULL,
0x0000000b2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000b12127220ULL, 0x080fe20000410000ULL, 0x0000000b13137220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x080fe20000410000ULL, 0x0000000b23237220ULL, 0x080fe20000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000b32327220ULL, 0x080fe20000410000ULL, 0x0000000b33337220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff37ff7812ULL, 0x000fe20007806008ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000934087209ULL, 0x000fd60007810000ULL,
0x8000000834340221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400040308ULL, 0x000e640000000800ULL,
0x0000000435350220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000a350a7221ULL, 0x004fc20000010000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000000802097824ULL, 0x000fca00078e00ffULL, 0xfffffff009367812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0036097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003414347210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e15ULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011435ULL,
0x0000003409097211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0635ULL,
0x0000000209097819ULL, 0x000fc80000001234ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000137377810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0036097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100b097816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0900720cULL, 0x000fda0003f65270ULL, 0x0000012000003947ULL, 0x000fea0003800000ULL,
0x00000004ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff0c7819ULL, 0x000fe40000011645ULL,
0x0000541000097816ULL, 0x000fe20000000000ULL, 0x0000d7b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c09037589ULL, 0x0002a400000e0000ULL, 0x000000080c0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000d7e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b09007589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100c0b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0009ULL, 0x00009af000157802ULL, 0x000fc40000000f00ULL,
0x0000de2000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180c0b7810ULL, 0x006fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0009ULL,
0x00009b4000157802ULL, 0x000fc40000000f00ULL, 0x0000ddd000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001041417824ULL, 0x100fe200078e025bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000010483a7824ULL, 0x000fc400078e025bULL,
0x0000001047347824ULL, 0x000fe400078e025bULL, 0x000000004140783bULL, 0x000e680000004200ULL,
0x000000003434783bULL, 0x000fe20000004200ULL, 0x0000010040147824ULL, 0x002fe200078e00ffULL,
0x00000041003e7306ULL, 0x000fe20000009400ULL, 0x0000010041487824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x004fc40000011440ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000041003f7306ULL, 0x000e620000005400ULL,
0x00000018ff157819ULL, 0x000fce0000011441ULL, 0x00000014003c7306ULL, 0x000ff00000209400ULL,
0x00000014003d7306ULL, 0x000ea20000205400ULL, 0x0000003f3e00720bULL, 0x002fce0003f1d000ULL,
0x0000000b00097306ULL, 0x000ff00000209400ULL, 0x0000000b000c7306ULL, 0x0002e20000205400ULL,
0x0000003d3c00720bULL, 0x004fe40003f5d000ULL, 0x00a000004a3c783bULL, 0x0004ea0000000200ULL,
0x0000004000387306ULL, 0x000fe20000009400ULL, 0x0000000b000b7245ULL, 0x002fe2000020d400ULL,
0x00000100424a7824ULL, 0x004fcc00078e00ffULL, 0x0000004000397306ULL, 0x008e620000005400ULL,
0x0000000c0900720bULL, 0x000fce0003f9d000ULL, 0x0000004800677306ULL, 0x000fec0000209400ULL,
0x000000010b0b4812ULL, 0x000fe400078efcffULL, 0x00000048006c7306ULL, 0x0004e20000205400ULL,
0x000000393800720bULL, 0x002fe40003fdd000ULL, 0x000000003a38783bULL, 0x000e6a0000004200ULL,
0x0000004000567306ULL, 0x0006e2000000d400ULL, 0x0000004800487245ULL, 0x004fe2000020d400ULL,
0x000000033c3cb231ULL, 0x000fc400003400ffULL, 0x000000033e3eb231ULL, 0x000fe400003400ffULL,
0x000000003d3db231ULL, 0x080fe400003400ffULL, 0x0000004100577306ULL, 0x0004a2000000d400ULL,
0x0001000040407824ULL, 0x008fe200078e00ffULL, 0x0000006c6700720bULL, 0x000fe20003fbd000ULL,
0x000000003f3fb231ULL, 0x000fe200003400ffULL, 0x0000001400677245ULL, 0x000fe4000020d400ULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000015000d7306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x0000000167672812ULL, 0x000fe400078efcffULL,
0x0000000156566812ULL, 0x000fe400078efcffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000001500667306ULL, 0x000ea20000205400ULL, 0x0000000148485812ULL, 0x000fe400078efcffULL,
0x0000000157570812ULL, 0x000fc400078efcffULL, 0x000000566756723eULL, 0x000fe400000010ffULL,
0x000000574857723eULL, 0x000fe200000010ffULL, 0x0000004000657306ULL, 0x000fe20000209400ULL,
0x0000001500487245ULL, 0x000fca000020d400ULL, 0x000000563c24723cULL, 0x000fe40000041824ULL,
0x00000040006a7306ULL, 0x0006620000205400ULL, 0x000000660d00720bULL, 0x004fe20003f5d000ULL,
0x0001000043667824ULL, 0x000fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000004100687306ULL, 0x000fe20000209400ULL, 0x0000004000407245ULL, 0x008fca000020d400ULL,
0x0000000148482812ULL, 0x000fe400078efcffULL, 0x0000004100097306ULL, 0x0004e20000205400ULL,
0x0000006a6500720bULL, 0x002fce0003fdd000ULL, 0x00000042005d7306ULL, 0x000fe20000009400ULL,
0x0000004100417245ULL, 0x004fca000020d400ULL, 0x0000000140406812ULL, 0x000fe400078efcffULL,
0x000000096800720bULL, 0x008fe20003fbd000ULL, 0x00000042005e7306ULL, 0x000e620000005400ULL,
0x000000400b40723eULL, 0x000fce00000010ffULL, 0x0000004300637306ULL, 0x000fe80000009400ULL,
0x0000000141415812ULL, 0x000fc800078efcffULL, 0x000000414841723eULL, 0x000fe200000010ffULL,
0x0000004300647306ULL, 0x000ea20000005400ULL, 0x0000005e5d00720bULL, 0x002fe40003f1d000ULL,
0x00000018ff487819ULL, 0x000fe40000011442ULL, 0x00000018ff5d7819ULL, 0x000fe20000011443ULL,
0x000000403c2c723cULL, 0x000b64000004182cULL, 0x00000042005f7306ULL, 0x000e6a000000d400ULL,
0x00000018ff407819ULL, 0x020fe2000001144aULL, 0x00000100434a7824ULL, 0x000fe200078e00ffULL,
0x000000646300720bULL, 0x004fc40003f9d000ULL, 0x0000004000417306ULL, 0x000fe20000209400ULL,
0x0001000042647824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fc8000001144aULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000004000567306ULL, 0x000ea20000205400ULL,
0x000000015f5f0812ULL, 0x002fce00078efcffULL, 0x0000004a00577306ULL, 0x000ff00000209400ULL,
0x0000004a005e7306ULL, 0x000e620000205400ULL, 0x000000564100720bULL, 0x004fe40003f5d000ULL,
0x0000004000567245ULL, 0x000fe2000020d400ULL, 0x0000001046407824ULL, 0x000fc800078e025bULL,
0x00000043005c7306ULL, 0x0004ec000000d400ULL, 0x0000000156562812ULL, 0x000fe400078efcffULL,
0x0000005e5700720bULL, 0x002fe20003fbd000ULL, 0x0000004800657306ULL, 0x000fe20000209400ULL,
0x0000005f5656723eULL, 0x000fe200000010ffULL, 0x000000004040783bULL, 0x004e620000004200ULL,
0x0000004a00577245ULL, 0x000fc4000020d400ULL, 0x000000015c5c4812ULL, 0x008fc600078efcffULL,
0x0000004800687306ULL, 0x000ea80000205400ULL, 0x0000000157575812ULL, 0x000fc800078efcffULL,
0x00000064005e7306ULL, 0x000fe20000209400ULL, 0x0000005c5757723eULL, 0x000fce00000010ffULL,
0x00000064006b7306ULL, 0x0006620000205400ULL, 0x000000686500720bULL, 0x004fe20003f5d000ULL,
0x000000563c10723cULL, 0x000b620000041810ULL, 0x0000010034687824ULL, 0x000fca00078e00ffULL,
0x0000005d00637306ULL, 0x000fe20000209400ULL, 0x0000004800577245ULL, 0x020fe4000020d400ULL,
0x0000006400567245ULL, 0x000fe4000020d400ULL, 0x0000005d00647245ULL, 0x008fe4000020d400ULL,
0x0000000157572812ULL, 0x000fe200078efcffULL, 0x0000005d00677306ULL, 0x000ea20000205400ULL,
0x0000006b5e00720bULL, 0x002fe40003f1d000ULL, 0x00000018ff687819ULL, 0x000fca0000011468ULL,
0x00000066005f7306ULL, 0x000fec0000209400ULL, 0x0000000156560812ULL, 0x000fe400078efcffULL,
0x0000006600697306ULL, 0x0002e20000205400ULL, 0x000000676300720bULL, 0x004fe20003fbd000ULL,
0x0000010035677824ULL, 0x000fe200078e00ffULL, 0x000000565756723eULL, 0x000fc400000010ffULL,
0x0000006600577245ULL, 0x000fe4000020d400ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000006800637306ULL, 0x000fe20000209400ULL, 0x00000018ff667819ULL, 0x002fe40000011434ULL,
0x00000067006c7245ULL, 0x000fc6000020d400ULL, 0x0000000164645812ULL, 0x000fe400078efcffULL,
0x000000695f00720bULL, 0x008fe20003f9d000ULL, 0x0000003400597306ULL, 0x000ff00000009400ULL,
0x0000003400587306ULL, 0x000e680000005400ULL, 0x0000000157574812ULL, 0x000fc800078efcffULL,
0x000000576457723eULL, 0x000fe200000010ffULL, 0x0000003500557306ULL, 0x000fec0000009400ULL,
0x000000563c20723cULL, 0x000b620000041820ULL, 0x000000585900720bULL, 0x002fe20003f1d000ULL,
0x0000006800647306ULL, 0x000e700000205400ULL, 0x00000035005a7306ULL, 0x000eb00000005400ULL,
0x0000006700657306ULL, 0x000fe20000209400ULL, 0x000000646300720bULL, 0x002fc40003f5d000ULL,
0x00000018ff637819ULL, 0x000fca0000011435ULL, 0x0000006700567306ULL, 0x0202e20000205400ULL,
0x0000005a5500720bULL, 0x004fe40003f9d000ULL, 0x0000006800557245ULL, 0x000fc8000020d400ULL,
0x0000000155552812ULL, 0x000fe200078efcffULL, 0x0000003400547306ULL, 0x0004e2000000d400ULL,
0x0000010037677824ULL, 0x002fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x0000003500537306ULL, 0x000262000000d400ULL, 0x0001000034347824ULL, 0x004fe200078e00ffULL,
0x000000566500720bULL, 0x008fc80003fbd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000006600587306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x002fe200078e00ffULL,
0x0000000154540812ULL, 0x000fc800078efcffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000006600597306ULL, 0x000e620000205400ULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x0000000153534812ULL, 0x000fe400078efcffULL, 0x000000545554723eULL, 0x000fe400000010ffULL,
0x000000536c55723eULL, 0x000fe200000010ffULL, 0x00000063005a7306ULL, 0x000fec0000209400ULL,
0x000000543c1c723cULL, 0x000f64000004181cULL, 0x0000006300647306ULL, 0x000ea20000205400ULL,
0x000000595800720bULL, 0x002fce0003f5d000ULL, 0x0000003400697306ULL, 0x000ff00000209400ULL,
0x00000034006a7306ULL, 0x0002e20000205400ULL, 0x000000645a00720bULL, 0x004fe40003fbd000ULL,
0x00000018ff5a7819ULL, 0x000fca0000011436ULL, 0x0000003500657306ULL, 0x000fe20000209400ULL,
0x0000003400347245ULL, 0x002fce000020d400ULL, 0x0000003500687306ULL, 0x0002a20000205400ULL,
0x0000006a6900720bULL, 0x008fce0003f1d000ULL, 0x0000005a00647306ULL, 0x000fe20000209400ULL,
0x0000003500357245ULL, 0x002fca000020d400ULL, 0x0000000134340812ULL, 0x000fe400078efcffULL,
0x000000686500720bULL, 0x004fe20003f9d000ULL, 0x0000005a00697306ULL, 0x000e620000205400ULL,
0x0000006600657245ULL, 0x000fe4000020d400ULL, 0x0000006300667245ULL, 0x000fe2000020d400ULL,
0x0000010036637824ULL, 0x000fe200078e00ffULL, 0x0000000165652812ULL, 0x000fe400078efcffULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x0000003700507306ULL, 0x000fe20000009400ULL,
0x00000018ff637819ULL, 0x000fc40000011463ULL, 0x000000346534723eULL, 0x000fe400000010ffULL,
0x0000000135354812ULL, 0x000fc600078efcffULL, 0x0000006300657306ULL, 0x000fe20000209400ULL,
0x000000356635723eULL, 0x000fe400000010ffULL, 0x000000696400720bULL, 0x002fe20003f1d000ULL,
0x0001000036647824ULL, 0x000fc800078e00ffULL, 0x0000006300667306ULL, 0x000e620000205400ULL,
0x000000343c18723cULL, 0x000b620000041818ULL, 0x00000018ff647819ULL, 0x000fcc0000011464ULL,
0x0000003700517306ULL, 0x000eb00000005400ULL, 0x0000003600477306ULL, 0x000fe20000009400ULL,
0x000000666500720bULL, 0x002fe20003f5d000ULL, 0x0001000037657824ULL, 0x000fca00078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x00000036004e7306ULL, 0x000e620000005400ULL,
0x000000515000720bULL, 0x004fe40003fbd000ULL, 0x00000018ff517819ULL, 0x000fca0000011437ULL,
0x0000006700687306ULL, 0x000ff00000209400ULL, 0x0000006700357306ULL, 0x020ea20000205400ULL,
0x0000004e4700720bULL, 0x002fce0003fdd000ULL, 0x00000036004f7306ULL, 0x0002f0000000d400ULL,
0x0000003700527306ULL, 0x0006e2000000d400ULL, 0x000000356800720bULL, 0x004fe40003f9d000ULL,
0x0000006300367245ULL, 0x002fc8000020d400ULL, 0x0000000136362812ULL, 0x000fe200078efcffULL,
0x0000006400357306ULL, 0x000fe20000209400ULL, 0x0000006700377245ULL, 0x008fe4000020d400ULL,
0x000000014f4f6812ULL, 0x000fc600078efcffULL, 0x0000000137374812ULL, 0x000fe400078efcffULL,
0x00000064004e7306ULL, 0x000e620000205400ULL, 0x0000000152525812ULL, 0x000fe400078efcffULL,
0x0000004f3636723eULL, 0x000fe400000010ffULL, 0x000000523737723eULL, 0x000fe400000010ffULL,
0x00000018ff4f7819ULL, 0x000fe20000011438ULL, 0x0000005100667306ULL, 0x000fe80000209400ULL,
0x000000363c30723cULL, 0x000b680000041830ULL, 0x0000005100697306ULL, 0x0004e20000205400ULL,
0x0000004e3500720bULL, 0x002fc40003fdd000ULL, 0x0000005a00377245ULL, 0x020fe4000020d400ULL,
0x0000006400367245ULL, 0x000fe4000020d400ULL, 0x00000051005a7245ULL, 0x000fe2000020d400ULL,
0x0000006500507306ULL, 0x000fe20000209400ULL, 0x0000000137370812ULL, 0x000fe400078efcffULL,
0x00000018ff517819ULL, 0x004fe40000011439ULL, 0x00000018ff647819ULL, 0x000fc4000001143bULL,
0x0000000136366812ULL, 0x000fe200078efcffULL, 0x0000006500637306ULL, 0x0002a20000205400ULL,
0x000000696600720bULL, 0x008fe40003f5d000ULL, 0x000000363736723eULL, 0x000fca00000010ffULL,
0x00000038000c7306ULL, 0x000fe20000009400ULL, 0x0000006500657245ULL, 0x002fca000020d400ULL,
0x000000015a5a2812ULL, 0x000fe400078efcffULL, 0x000000635000720bULL, 0x004fe20003f9d000ULL,
0x0000003800147306ULL, 0x000e700000005400ULL, 0x0000003800097306ULL, 0x000ea8000000d400ULL,
0x0000000165654812ULL, 0x000fc800078efcffULL, 0x000000655a37723eULL, 0x000fe200000010ffULL,
0x00000039000d7306ULL, 0x000fe20000009400ULL, 0x000000140c00720bULL, 0x002fe20003f9d000ULL,
0x00000100390c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc60000011440ULL,
0x000000363c3c723cULL, 0x000b620000041828ULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000003900157306ULL, 0x000e6a0000005400ULL, 0x0000010038367824ULL, 0x060fe200078e00ffULL,
0x0000000109094812ULL, 0x004fe200078efcffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x0000003a004a7306ULL, 0x000fe20000009400ULL, 0x00000018ff377819ULL, 0x000fc4000001143aULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000018ff387819ULL, 0x000fc60000011438ULL,
0x0000003600287306ULL, 0x000fe20000209400ULL, 0x000000150d00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff0d7819ULL, 0x000fca0000011441ULL, 0x00000038002a7306ULL, 0x000ff00000209400ULL,
0x00000038002b7306ULL, 0x0002b00000205400ULL, 0x0000003600297306ULL, 0x0006e20000205400ULL,
0x0000003800387245ULL, 0x002fce000020d400ULL, 0x0000003a005c7306ULL, 0x000e620000005400ULL,
0x0000002b2a00720bULL, 0x004fe40003f5d000ULL, 0x0000003600367245ULL, 0x008fca000020d400ULL,
0x0000004f00507306ULL, 0x000fe20000209400ULL, 0x000000292800720bULL, 0x000fe40003fbd000ULL,
0x00a000004928783bULL, 0x000ea60000000200ULL, 0x0000000138382812ULL, 0x000fe400078efcffULL,
0x0000004f00697306ULL, 0x000ee20000205400ULL, 0x0000005c4a00720bULL, 0x002fca0003f1d000ULL,
0x0000000136365812ULL, 0x000fe400078efcffULL, 0x00000040005d7306ULL, 0x000fe40000009400ULL,
0x000000093636723eULL, 0x000fcc00000010ffULL, 0x0000004000577306ULL, 0x000e620000005400ULL,
0x000000695000720bULL, 0x008fce0003f9d000ULL, 0x0000000c00157306ULL, 0x000ff00000209400ULL,
0x0000000c004a7306ULL, 0x000ee20000205400ULL, 0x000000575d00720bULL, 0x002fe40003f5d000ULL,
0x0000004f00577245ULL, 0x000fe2000020d400ULL, 0x000000032828b231ULL, 0x084fe200003400ffULL,
0x0000000c005d7245ULL, 0x000fe2000020d400ULL, 0x000000032a2ab231ULL, 0x000fe200003400ffULL,
0x0000000157574812ULL, 0x000fe200078efcffULL, 0x00000039000b7306ULL, 0x0002a2000000d400ULL,
0x000000002929b231ULL, 0x000fc400003400ffULL, 0x000000002b2bb231ULL, 0x000fe200003400ffULL,
0x000000385738723eULL, 0x000fe400000010ffULL, 0x0000001400577245ULL, 0x000fe4000020d400ULL,
0x0000004a1500720bULL, 0x008fe20003f9d000ULL, 0x0001000039397824ULL, 0x002fe200078e00ffULL,
0x0000005100527306ULL, 0x000fe20000209400ULL, 0x000001003a157824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000039004f7306ULL, 0x000fe20000209400ULL, 0x000000010b0b6812ULL, 0x004fe400078efcffULL,
0x000000015d5d4812ULL, 0x000fca00078efcffULL, 0x00000039004a7306ULL, 0x0002b00000205400ULL,
0x00000051005a7306ULL, 0x000ee20000205400ULL, 0x0000003900397245ULL, 0x002fce000020d400ULL,
0x0000004100587306ULL, 0x000fe20000009400ULL, 0x0000004a4f00720bULL, 0x004fe20003fdd000ULL,
0x000001003b4a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000004100597306ULL, 0x000e620000005400ULL, 0x0000005a5200720bULL, 0x008fe20003f7d000ULL,
0x0000010040527824ULL, 0x000fe200078e00ffULL, 0x00000015005a7245ULL, 0x000fc6000020d400ULL,
0x0000000139396812ULL, 0x000fe400078efcffULL, 0x0000001500497306ULL, 0x000fe20000209400ULL,
0x00000018ff527819ULL, 0x000fce0000011452ULL, 0x00000015000c7306ULL, 0x0004e20000205400ULL,
0x000000595800720bULL, 0x002fe40003f9d000ULL, 0x0000005100587245ULL, 0x000fe4000020d400ULL,
0x0000003700597245ULL, 0x000fe4000020d400ULL, 0x0000000158583812ULL, 0x000fe200078efcffULL,
0x0000004200547306ULL, 0x000fe20000009400ULL, 0x00000018ff157819ULL, 0x004fe40000011443ULL,
0x000000395839723eULL, 0x000fca00000010ffULL, 0x0000004200557306ULL, 0x000e620000005400ULL,
0x0000000c4900720bULL, 0x008fe20003fdd000ULL, 0x00000038282c723cULL, 0x000f62000004182cULL,
0x00000018ff0c7819ULL, 0x000fca0000011442ULL, 0x0000004a004f7306ULL, 0x000fec0000209400ULL,
0x000000015a5a6812ULL, 0x000fe400078efcffULL, 0x0000004a00507306ULL, 0x000ea20000205400ULL,
0x000000555400720bULL, 0x002fe20003f7d000ULL, 0x000100003a557824ULL, 0x000fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000003a00467306ULL, 0x000e70000000d400ULL,
0x0000003b005e7306ULL, 0x000fe20000009400ULL, 0x000000504f00720bULL, 0x004fe20003fdd000ULL,
0x000100003b4f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000003b005f7306ULL, 0x000ea20000005400ULL, 0x0000000146460812ULL, 0x002fc800078efcffULL,
0x000000465a46723eULL, 0x000fc600000010ffULL, 0x0000004300477306ULL, 0x000ff00000009400ULL,
0x00000043004e7306ULL, 0x000e620000005400ULL, 0x0000005f5e00720bULL, 0x004fce0003fbd000ULL,
0x0000003b00487306ULL, 0x000eb0000000d400ULL, 0x00000055003a7306ULL, 0x000fe20000209400ULL,
0x0000004e4700720bULL, 0x002fe40003f1d000ULL, 0x0000004a00477245ULL, 0x000fc8000020d400ULL,
0x0000000147476812ULL, 0x000fe200078efcffULL, 0x00000055003b7306ULL, 0x0002e20000205400ULL,
0x0000000148485812ULL, 0x004fc800078efcffULL, 0x000000484747723eULL, 0x000fc600000010ffULL,
0x0000003700637306ULL, 0x000fe20000209400ULL, 0x0000005500557245ULL, 0x002fc6000020d400ULL,
0x000000462810723cULL, 0x000f680000041810ULL, 0x0000003700687306ULL, 0x000e620000205400ULL,
0x0000003b3a00720bULL, 0x008fe20003fdd000ULL, 0x00000100413b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000004f00507306ULL, 0x000fec0000209400ULL,
0x0000000155556812ULL, 0x000fe400078efcffULL, 0x0000004f00517306ULL, 0x0004e20000205400ULL,
0x000000686300720bULL, 0x002fce0003fbd000ULL, 0x0000006400667306ULL, 0x000fe20000209400ULL,
0x0000004f004f7245ULL, 0x004fca000020d400ULL, 0x0000000159595812ULL, 0x000fe400078efcffULL,
0x0000006400677306ULL, 0x000e620000205400ULL, 0x000000515000720bULL, 0x008fe40003fdd000ULL,
0x0000006400507245ULL, 0x000fca000020d400ULL, 0x00000052003a7306ULL, 0x000fec0000209400ULL,
0x000000014f4f6812ULL, 0x000fe400078efcffULL, 0x0000005200517306ULL, 0x0004e20000205400ULL,
0x000000676600720bULL, 0x002fe20003fbd000ULL, 0x0001000040667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000001400657306ULL, 0x000fe20000209400ULL,
0x0000005200527245ULL, 0x004fca000020d400ULL, 0x0000000150505812ULL, 0x000fe400078efcffULL,
0x00000014005e7306ULL, 0x000e620000205400ULL, 0x000000513a00720bULL, 0x008fe20003fdd000ULL,
0x00000100433a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000003b00377306ULL, 0x000fec0000209400ULL, 0x0000000152526812ULL, 0x000fe400078efcffULL,
0x0000003b00687306ULL, 0x0004e20000205400ULL, 0x0000005e6500720bULL, 0x002fce0003fbd000ULL,
0x0000004100537306ULL, 0x0002e2000000d400ULL, 0x0000003b003b7245ULL, 0x004fca000020d400ULL,
0x0000000157575812ULL, 0x000fe400078efcffULL, 0x0000004000567306ULL, 0x000ea2000000d400ULL,
0x0001000041417824ULL, 0x002fe200078e00ffULL, 0x000000683700720bULL, 0x008fe40003fdd000ULL,
0x0000000b5d37723eULL, 0x000fe400000010ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011441ULL,
0x0000010042417824ULL, 0x000fe200078e00ffULL, 0x0000000d005c7306ULL, 0x000fe20000209400ULL,
0x0000000153534812ULL, 0x000fc400078efcffULL, 0x000000362824723cULL, 0x000b620000041824ULL,
0x00000018ff417819ULL, 0x000fc60000011441ULL, 0x000000013b3b6812ULL, 0x000fe200078efcffULL,
0x0000000d00697306ULL, 0x0002e20000205400ULL, 0x0000000156562812ULL, 0x004fe400078efcffULL,
0x000000555936723eULL, 0x020fe400000010ffULL, 0x0000004f5037723eULL, 0x000fe400000010ffULL,
0x000000565252723eULL, 0x000fe200000010ffULL, 0x0000006600517306ULL, 0x000fe20000209400ULL,
0x0000000d000d7245ULL, 0x002fc4000020d400ULL, 0x000000533b53723eULL, 0x000fe200000010ffULL,
0x000000362820723cULL, 0x000b680000041820ULL, 0x0000006600647306ULL, 0x0002a20000205400ULL,
0x000000695c00720bULL, 0x008fc60003f5d000ULL, 0x00000052281c723cULL, 0x000f68000004181cULL,
0x0000005e00407306ULL, 0x000fe20000209400ULL, 0x0000006600667245ULL, 0x002fca000020d400ULL,
0x000000010d0d2812ULL, 0x000fe400078efcffULL, 0x0000005e00657306ULL, 0x0002e20000205400ULL,
0x000000645100720bULL, 0x004fce0003fdd000ULL, 0x0000004200347306ULL, 0x0004e2000000d400ULL,
0x0000005e005e7245ULL, 0x002fca000020d400ULL, 0x0000000166666812ULL, 0x000fe400078efcffULL,
0x00000041005f7306ULL, 0x000fe20000209400ULL, 0x0001000042427824ULL, 0x004fe200078e00ffULL,
0x000000654000720bULL, 0x008fe40003f9d000ULL, 0x000000665736723eULL, 0x020fe400000010ffULL,
0x00000018ff097819ULL, 0x000fe20000011442ULL, 0x0001000043427824ULL, 0x000fe200078e00ffULL,
0x0000004100637306ULL, 0x0002a20000205400ULL, 0x0000000134343812ULL, 0x000fc600078efcffULL,
0x00000018ff427819ULL, 0x000fc60000011442ULL, 0x000000015e5e4812ULL, 0x000fe200078efcffULL,
0x0000004300357306ULL, 0x000ee2000000d400ULL, 0x0000004100417245ULL, 0x002fe4000020d400ULL,
0x0000005e0d37723eULL, 0x000fe400000010ffULL, 0x00000042000d7245ULL, 0x000fc6000020d400ULL,
0x0000003a00517306ULL, 0x000fe20000209400ULL, 0x000000635f00720bULL, 0x004fe20003fbd000ULL,
0x000000362818723cULL, 0x000f6c0000041818ULL, 0x0000003a005c7306ULL, 0x0002a20000205400ULL,
0x0000000135350812ULL, 0x008fca00078efcffULL, 0x0000000141415812ULL, 0x000fe400078efcffULL,
0x0000000c00497306ULL, 0x000fe20000209400ULL, 0x0000003a003a7245ULL, 0x002fe4000020d400ULL,
0x000000344134723eULL, 0x000fca00000010ffULL, 0x0000000c00547306ULL, 0x0002e20000205400ULL,
0x0000005c5100720bULL, 0x004fce0003f5d000ULL, 0x00000015004a7306ULL, 0x000fe20000209400ULL,
0x0000000c000c7245ULL, 0x002fca000020d400ULL, 0x000000013a3a2812ULL, 0x000fe400078efcffULL,
0x00000015004e7306ULL, 0x000e620000205400ULL, 0x000000544900720bULL, 0x008fe40003fdd000ULL,
0x000000353a35723eULL, 0x000fca00000010ffULL, 0x00000009000b7306ULL, 0x000fe40000209400ULL,
0x000000342830723cULL, 0x000f680000041830ULL, 0x000000010c0c6812ULL, 0x000fe400078efcffULL,
0x0000000900407306ULL, 0x0004e20000205400ULL, 0x0000004e4a00720bULL, 0x002fce0003f9d000ULL,
0x0000004200437306ULL, 0x000fe20000209400ULL, 0x0000000900097245ULL, 0x004fce000020d400ULL,
0x0000004200147306ULL, 0x000e620000205400ULL, 0x000000400b00720bULL, 0x008fda0003fbd000ULL,
0x0000000109095812ULL, 0x000fe400078efcffULL, 0x000000144300720bULL, 0x002fe40003f7d000ULL,
0x0000001500147245ULL, 0x000fe4000020d400ULL, 0x000000090c0c723eULL, 0x000fe200000010ffULL,
0x0000000202097824ULL, 0x000fe200078e00ffULL, 0x0000000114144812ULL, 0x000fc800078efcffULL,
0xfffffff8090b7812ULL, 0x000fc600078ec0ffULL, 0x000000010d0d3812ULL, 0x000fc800078efcffULL,
0x0000000d140d723eULL, 0x000fce00000010ffULL, 0x0000000c2828723cULL, 0x000b6e000004183cULL,
0x0000f6c8740c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000c0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f698000bff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff097224ULL, 0x000fc600078e00ffULL,
0x0000000000147805ULL, 0x000fc80000015200ULL, 0x00000400050b7984ULL, 0x004ea40000000800ULL,
0x800000000bff7812ULL, 0x006fc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003414347210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e15ULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011435ULL,
0x000000340b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0635ULL,
0x000000020b0b7819ULL, 0x000fc80000001234ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400050b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001440b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000307077810ULL, 0x000fe40007ffe0ffULL,
0x000000700b00720cULL, 0x000fda0003f06070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x0000000244097810ULL, 0x000fe20007ffe0ffULL, 0x000001000b0b7824ULL, 0x000fe400078e027cULL,
0x000059000e077a24ULL, 0x010fe200078e02ffULL, 0x000000700900720cULL, 0x000fe40003f06070ULL,
0x000000200b0c7812ULL, 0x000fe200078ec0ffULL, 0x0000004007077824ULL, 0x000fc800078e00ffULL,
0x0000000175367824ULL, 0x000fcc00078e020cULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000000b6e097217ULL, 0x000fe20007800000ULL, 0x00000010020c7824ULL, 0x000fc800078e00ffULL,
0x0000000109097824ULL, 0x000fe200078e0a0bULL, 0x000000100c0c7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0b7819ULL, 0x000fe40000011645ULL, 0x000000090c097217ULL, 0x000fe40007800000ULL,
0x000000040b0d7810ULL, 0x040fe40007ffe0ffULL, 0x000000080b0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x100fe200078e0a0cULL, 0x0000000c0b347810ULL, 0x000fe20007ffe0ffULL,
0x000000010d157824ULL, 0x000fc400078e020cULL, 0x000000010e357824ULL, 0x140fe200078e020cULL,
0x000000090b00720cULL, 0x080fe20003f86070ULL, 0x0000000115147824ULL, 0x100fe200078e0245ULL,
0x000000090d00720cULL, 0x080fe20003f66070ULL, 0x0000000815397824ULL, 0x000fe200078e00ffULL,
0x000000090e00720cULL, 0x080fe20003f46070ULL, 0x000000010b0b7824ULL, 0x100fe200078e020cULL,
0x000000093400720cULL, 0x040fe20003f06070ULL, 0x0000000134377824ULL, 0x000fe200078e020cULL,
0xfffffff839387812ULL, 0x000fe200078ee214ULL, 0x000000010b0d7824ULL, 0x000fc400078e0245ULL,
0x000000080b0e7824ULL, 0x040fe400078e00ffULL, 0x000000010b147824ULL, 0x100fe400078e0236ULL,
0x00000001150c7824ULL, 0x000fe200078e0236ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20dULL,
0x0000000135097824ULL, 0x040fe400078e0245ULL, 0x00000008353a7824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee209ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000620007097a11ULL, 0x000fe400078a38ffULL,
0x0000004b14147212ULL, 0x080fe200078efcffULL, 0x0000000135347824ULL, 0x100fe200078e0236ULL,
0x0000004b0c0c7212ULL, 0x000fe200078efcffULL, 0x0000000137367824ULL, 0x000fe200078e0236ULL,
0x0000630007077a11ULL, 0x000fe200028f3cffULL, 0x00000001370b7824ULL, 0x000fe200078e0245ULL,
0x0000001409147210ULL, 0x000fe20007fbe0ffULL, 0x00000008373c7824ULL, 0x000fe200078e00ffULL,
0x000000090c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004b34347212ULL, 0x000fc600078efcffULL, 0x0000000115157824ULL, 0x100fe200028e0607ULL,
0x0000004b36367212ULL, 0x000fe200078efcffULL, 0x000000010d0d7824ULL, 0x000fe200030e0607ULL,
0x0000000934347210ULL, 0x080fe20007fbe0ffULL, 0x00000010380b7824ULL, 0x100fe200078e025bULL,
0x0000000936367210ULL, 0x000fe20007fde0ffULL, 0x000000100e097824ULL, 0x100fe400078e025bULL,
0x000000103a397824ULL, 0x000fe400078e025bULL, 0x0000000135357824ULL, 0x000fe200028e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014097faeULL, 0x0003e2000e101c48ULL,
0x000000103c5b7824ULL, 0x000fc400078e025bULL, 0x0000000137377824ULL, 0x000fe200030e0607ULL,
0x000000000c0b7faeULL, 0x0003e8000d901c48ULL, 0x0000000034397faeULL, 0x0003e8000d101c48ULL,
0x00000000365b7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001002097824ULL, 0x000fca00078e00ffULL, 0x00000010090c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c45097211ULL, 0x000fc800078fe8ffULL, 0x00000004090d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090b7824ULL, 0x040fe200078e0245ULL, 0x0000000c09357810ULL, 0x040fe20007ffe0ffULL,
0x00000008090e7824ULL, 0x040fe400078e00ffULL, 0x00000001090c7824ULL, 0x100fe400078e0236ULL,
0x000000080d387824ULL, 0x040fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL,
0x000000010d147824ULL, 0x000fe200078e0236ULL, 0x00000008090b7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d097824ULL, 0x000fc400078e0245ULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee209ULL, 0x000000010b157824ULL, 0x000fe200078e0245ULL,
0x0000620007097a11ULL, 0x000fe200078038ffULL, 0x000000080b3a7824ULL, 0x040fe200078e00ffULL,
0x0000004b0c0c7212ULL, 0x000fe200078efcffULL, 0x000000010b347824ULL, 0x100fe200078e0236ULL,
0x0000630007077a11ULL, 0x000fe200000f3cffULL, 0x0000000135367824ULL, 0x040fe200078e0236ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee215ULL, 0x00000001350b7824ULL, 0x000fe200078e0245ULL,
0x0000000c090c7210ULL, 0x000fe20007f1e0ffULL, 0x00000008353c7824ULL, 0x000fc400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004b14147212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004b34347212ULL, 0x000fc600078efcffULL,
0x000000010d0d7824ULL, 0x000fe200000e0607ULL, 0x0000004b36367212ULL, 0x000fe200078efcffULL,
0x00000010380b7824ULL, 0x100fe200078e025bULL, 0x0000001409147210ULL, 0x040fe20007f1e0ffULL,
0x000000103a397824ULL, 0x100fe200078e025bULL, 0x0000003409347210ULL, 0x040fe40007f5e0ffULL,
0x0000003609367210ULL, 0x000fe20007f7e0ffULL, 0x000000100e097824ULL, 0x000fe400078e025bULL,
0x0000000115157824ULL, 0x000fc400000e0607ULL, 0x0000000135357824ULL, 0x000fe200010e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000b901c48ULL,
0x000000103c5b7824ULL, 0x000fe400078e025bULL, 0x0000000137377824ULL, 0x000fe200018e0607ULL,
0x00000000140b7faeULL, 0x0003e8000b901c48ULL, 0x0000000034397faeULL, 0x0003e8000b901c48ULL,
0x00000000365b7faeULL, 0x0003e4000b901c48ULL, 0x0000000461077810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff0e7424ULL, 0x000fc400078e00ffULL,
0x0000006f0700720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001760c7824ULL, 0x002fe400078e0207ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000064000c0c7625ULL, 0x000fca00078e000dULL, 0x000000080c0e7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802097824ULL, 0x002fca00078e00ffULL,
0xfffffff009097812ULL, 0x000fc800078ec0ffULL, 0x00000000090473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800090c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680006147f8cULL, 0x000662000c80043fULL,
0x000000ffff0c7224ULL, 0x004fc600078e000dULL, 0x0000000000347805ULL, 0x000fc80000015200ULL,
0x00f66c0006097984ULL, 0x002e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634367210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011437ULL,
0x0000003609097211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e0637ULL,
0x0000000209097819ULL, 0x000fc80000001236ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c0006097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018078097811ULL, 0x000fc800078e38ffULL, 0x0000000962097210ULL, 0x000fca0007ffe04bULL,
0x00f0000009357984ULL, 0x000e680000000800ULL, 0x00f2000009377984ULL, 0x0004e20000000800ULL,
0x000000083500720bULL, 0x002fe20003f1d000ULL, 0x0000aac27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b347812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fd200078e0008ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000378097810ULL, 0x000fe40007ffe0ffULL, 0x000000083500720bULL, 0x000fe40003f54000ULL,
0x000000020900720cULL, 0x000fe20003f05270ULL, 0x0000aa627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000097806ULL, 0x000fc400010e0100ULL, 0x00000080024b8824ULL, 0x000fe200078e024bULL,
0x00000008350d7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910090b7816ULL, 0x000fe200000000ffULL, 0x0000000162628824ULL, 0x000fca00078e024bULL,
0x00f4000d62008388ULL, 0x0003e20000000800ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000080d087221ULL, 0x002fe20000010100ULL,
0x000000ff09ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800397308ULL, 0x000e640000000800ULL,
0x000000390a0a7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011645ULL, 0x0000a9927f007947ULL, 0x000fea000b800000ULL,
0x00001f0b390b7589ULL, 0x0002a400000e0000ULL, 0x0000000b24247220ULL, 0x084fe20000410000ULL,
0x0000000b25257220ULL, 0x080fe20000410000ULL, 0x0000000b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000b10107220ULL, 0x080fe20000410000ULL,
0x0000000b11117220ULL, 0x080fe20000410000ULL, 0x0000000b20207220ULL, 0x080fe20000410000ULL,
0x0000000b21217220ULL, 0x080fe20000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x080fe20000410000ULL, 0x0000000b30307220ULL, 0x080fe20000410000ULL,
0x0000000b31317220ULL, 0x080fe20000410000ULL, 0x0000000b28287220ULL, 0x080fe20000410000ULL,
0x0000000b29297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008450b7811ULL, 0x000fe200078ff0ffULL, 0x0000a8727f007947ULL, 0x000fea000b800000ULL,
0x00001f0b390b7589ULL, 0x00046400000e0000ULL, 0x0000000b26267220ULL, 0x086fe20000410000ULL,
0x0000000b27277220ULL, 0x080fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b12127220ULL, 0x080fe20000410000ULL,
0x0000000b13137220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b32327220ULL, 0x080fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b2b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff34ff7812ULL, 0x000fe20007806009ULL, 0x00000001ff147424ULL, 0x000fd800078e00ffULL,
0x000000350d350221ULL, 0x000fe20000010100ULL, 0x00007610ff140816ULL, 0x000fc60000000014ULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x0000003500040308ULL, 0x000e640000000800ULL,
0x0000000437370220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000a373c7221ULL, 0x008fc20000010000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008020a7824ULL, 0x000fca00078e00ffULL, 0xfffffff00a347812ULL, 0x000fca00078ec0ffULL,
0x00f6b400340b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08157210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x000000150a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b400340b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991014087816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000004ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff097819ULL, 0x000fe40000011645ULL,
0x0000541000087816ULL, 0x000fe20000000000ULL, 0x0000a4327f007947ULL, 0x000fea000b800000ULL,
0x00001f0908037589ULL, 0x0002a400000e0000ULL, 0x00000008090b7810ULL, 0x000fe20007ffe0ffULL,
0x0000a4627f007947ULL, 0x000fea000b800000ULL, 0x00001f0b08007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010090b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0008ULL, 0x0000d03000157802ULL, 0x000fc40000000f00ULL,
0x0000a8e000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018090b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0008ULL,
0x0000d08000157802ULL, 0x000fc40000000f00ULL, 0x0000a89000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000080078647824ULL, 0x040fe200078e0260ULL, 0x0000000378617810ULL, 0x000fc40007ffe0ffULL,
0x000000004d08783bULL, 0x00ee620000004200ULL, 0x0000000277777810ULL, 0x000fc60007ffe0ffULL,
0x000000004c40783bULL, 0x000ea20000004200ULL, 0x00000009005e7306ULL, 0x002fe20000009400ULL,
0x00000100085d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011408ULL,
0x0001000008627824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011409ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000000900677306ULL, 0x000e620000005400ULL,
0x00000018ff627819ULL, 0x000fc40000011462ULL, 0x00000018ff5f7819ULL, 0x000fe4000001140bULL,
0x00000018ff167819ULL, 0x000fe4000001140aULL, 0x00000018ff4f7819ULL, 0x004fe20000011441ULL,
0x00000008003e7306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x000fe40000011440ULL,
0x00000018ff3d7819ULL, 0x000fca0000011442ULL, 0x0000000800497306ULL, 0x000ea20000005400ULL,
0x000000675e00720bULL, 0x002fe20003f5d000ULL, 0x00000100095e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000000800147306ULL, 0x000e70000000d400ULL,
0x0000005d00487306ULL, 0x000fe20000209400ULL, 0x000000493e00720bULL, 0x004fc40003fdd000ULL,
0x00000018ff3e7819ULL, 0x000fca0000011443ULL, 0x0000005d00657306ULL, 0x0004ec0000205400ULL,
0x0000000114146812ULL, 0x002fe400078efcffULL, 0x0000006200087306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x004fce000020d400ULL, 0x0000006200677306ULL, 0x000e620000205400ULL,
0x000000654800720bULL, 0x008fce0003f7d000ULL, 0x0000000a00687306ULL, 0x000fec0000009400ULL,
0x000000015d5d3812ULL, 0x000fe400078efcffULL, 0x0000000a00697306ULL, 0x000ea20000005400ULL,
0x000000670800720bULL, 0x002fe20003fbd000ULL, 0x0001000009087824ULL, 0x000fe200078e00ffULL,
0x000000145d14723eULL, 0x000fe200000010ffULL, 0x00000100435d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000003900587306ULL, 0x000fe20000209400ULL,
0x00000018ff5d7819ULL, 0x000fce000001145dULL, 0x0000003900177306ULL, 0x0002e20000205400ULL,
0x000000696800720bULL, 0x004fce0003f9d000ULL, 0x0000000b00577306ULL, 0x000fe20000009400ULL,
0x0000003900397245ULL, 0x002fce000020d400ULL, 0x0000000b00387306ULL, 0x000e620000005400ULL,
0x000000175800720bULL, 0x008fce0003fdd000ULL, 0x0000005e00657306ULL, 0x000fec0000209400ULL,
0x0000000139396812ULL, 0x000fe400078efcffULL, 0x0000005e00687306ULL, 0x0004e20000205400ULL,
0x000000385700720bULL, 0x002fe20003f7d000ULL, 0x000001000a577824ULL, 0x040fe200078e00ffULL,
0x0000006200387245ULL, 0x000fe2000020d400ULL, 0x000100000a627824ULL, 0x000fc600078e00ffULL,
0x0000000138385812ULL, 0x000fe200078efcffULL, 0x0000000800677306ULL, 0x000fe20000209400ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000005e005e7245ULL, 0x004fe4000020d400ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x000000383938723eULL, 0x000fe200000010ffULL,
0x00000008006a7306ULL, 0x000e620000205400ULL, 0x000000686500720bULL, 0x008fe20003fbd000ULL,
0x000001000b657824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000005c003b7306ULL, 0x000fec0000209400ULL, 0x000000015e5e5812ULL, 0x000fe400078efcffULL,
0x0000005c00367306ULL, 0x0004e20000205400ULL, 0x0000006a6700720bULL, 0x002fe20003fdd000ULL,
0x00010000406a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000000900157306ULL, 0x000e62000000d400ULL, 0x0000005c005c7245ULL, 0x004fce000020d400ULL,
0x0000004000607306ULL, 0x000fe20000009400ULL, 0x000000363b00720bULL, 0x008fe40003fbd000ULL,
0x00000008003b7245ULL, 0x000fc8000020d400ULL, 0x000000013b3b6812ULL, 0x000fe200078efcffULL,
0x0000004000637306ULL, 0x000ea20000005400ULL, 0x0000000115152812ULL, 0x002fc800078efcffULL,
0x000000155e15723eULL, 0x000fe400000010ffULL, 0x000000015c5c5812ULL, 0x000fe200078efcffULL,
0x0000005700097306ULL, 0x000fe60000209400ULL, 0x0000003b5c39723eULL, 0x000fe200000010ffULL,
0x00000004023b7824ULL, 0x000fc800078e00ffULL, 0x0000005700687306ULL, 0x000e620000205400ULL,
0x000000636000720bULL, 0x004fce0003f5d000ULL, 0x0000000b00357306ULL, 0x0004f0000000d400ULL,
0x0000000a00347306ULL, 0x0006e2000000d400ULL, 0x000100000b0b7824ULL, 0x004fe200078e00ffULL,
0x000000680900720bULL, 0x002fc40003fdd000ULL, 0x0000000845687812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe4000001140bULL, 0x0000004100377306ULL, 0x000fe20000009400ULL,
0x00a800006408783bULL, 0x008e620000000200ULL, 0x0000000135353812ULL, 0x000fe400078efcffULL,
0x0000000768687812ULL, 0x000fc800078ef845ULL, 0x0000004100567306ULL, 0x000ea20000005400ULL,
0x0000000134344812ULL, 0x000fce00078efcffULL, 0x0000006500587306ULL, 0x000ff00000209400ULL,
0x0000006500697306ULL, 0x000ee20000205400ULL, 0x000000563700720bULL, 0x004fe20003fbd000ULL,
0x0000010040567824ULL, 0x000fe200078e00ffULL, 0x0000005700377245ULL, 0x000fc8000020d400ULL,
0x0000000137376812ULL, 0x000fe200078efcffULL, 0x0000001600597306ULL, 0x000fe20000209400ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x000000343734723eULL, 0x000fca00000010ffULL,
0x00000016003a7306ULL, 0x000ea20000205400ULL, 0x000000695800720bULL, 0x008fe20003fdd000ULL,
0x0000000308088231ULL, 0x082fe200003400ffULL, 0x0001000041697824ULL, 0x000fe200078e00ffULL,
0x000000030a0a8231ULL, 0x000fe400003400ffULL, 0x0000000009098231ULL, 0x080fe400003400ffULL,
0x0000006200177306ULL, 0x000fe20000209400ULL, 0x000000000b0b8231ULL, 0x000fe200003400ffULL,
0x00000018ff697819ULL, 0x000fcc0000011469ULL, 0x0000006200367306ULL, 0x000e620000205400ULL,
0x0000003a5900720bULL, 0x004fe20003f9d000ULL, 0x000000140824723cULL, 0x000b620000041824ULL,
0x00000065003a7245ULL, 0x000fe2000020d400ULL, 0x0000010041597824ULL, 0x000fc600078e00ffULL,
0x000000013a3a6812ULL, 0x000fe200078efcffULL, 0x0000005f005b7306ULL, 0x000fe20000209400ULL,
0x000000043b147812ULL, 0x020fe200078ec0ffULL, 0x0000000868157824ULL, 0x000fe200078e00ffULL,
0x000000353a35723eULL, 0x000fe400000010ffULL, 0x0000000214147812ULL, 0x000fe200078efcffULL,
0x000000380838723cULL, 0x000b62000004182cULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000005f005a7306ULL, 0x000ea20000205400ULL, 0x000000361700720bULL, 0x002fc40003f7d000ULL,
0x00000014456b7211ULL, 0x000fe400078fe0ffULL, 0x00000010682c7812ULL, 0x060fe200078efcffULL,
0x000000340834723cULL, 0x000b640000041810ULL, 0x0000006300607306ULL, 0x000fe20000209400ULL,
0x0000000168147824ULL, 0x000fc800078e026bULL, 0x0000001600107245ULL, 0x020fe2000020d400ULL,
0x000000012c127824ULL, 0x000fe200078e026bULL, 0xfffffff815147812ULL, 0x000fe200078ee214ULL,
0x0000006300677306ULL, 0x0002e20000205400ULL, 0x0000000110104812ULL, 0x000fe200078efcffULL,
0x000000082c117824ULL, 0x000fe200078e00ffULL, 0x0000005a5b00720bULL, 0x004fe20003fdd000ULL,
0x0000001014147824ULL, 0x100fe200078e020fULL, 0x0000005f002c7245ULL, 0x000fe4000020d400ULL,
0xfffffff811127812ULL, 0x000fe200078ee212ULL, 0x0000005600577306ULL, 0x000fe20000209400ULL,
0x0000006200117245ULL, 0x000fe2000020d400ULL, 0x000000001414783bULL, 0x000fe20000004200ULL,
0x0000006300637245ULL, 0x002fe2000020d400ULL, 0x00000010122d7824ULL, 0x000fe200078e020fULL,
0x0000000111113812ULL, 0x000fc400078efcffULL, 0x000000676000720bULL, 0x008fe20003f9d000ULL,
0x0000005600587306ULL, 0x000e620000205400ULL, 0x000000012c2c6812ULL, 0x000fe200078efcffULL,
0x0001000043677824ULL, 0x000fe200078e00ffULL, 0x000000111010723eULL, 0x000fc800000010ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000004000517306ULL, 0x000ea8000000d400ULL,
0x0000000163634812ULL, 0x000fc800078efcffULL, 0x000000632c11723eULL, 0x000fe200000010ffULL,
0x00000059005a7306ULL, 0x000fe20000209400ULL, 0x00000007452c7812ULL, 0x000fe400078ec0ffULL,
0x000000585700720bULL, 0x002fe40003fdd000ULL, 0x000000082c2c7812ULL, 0x000fe200078ef845ULL,
0x000000100820723cULL, 0x000b620000041820ULL, 0x0000000151512812ULL, 0x004fe200078efcffULL,
0x00000059005b7306ULL, 0x000e640000205400ULL, 0x000000082c2c7824ULL, 0x000fca00078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee277ULL, 0x0000004f00527306ULL, 0x000fe80000209400ULL,
0x0000008061107824ULL, 0x020fe400078e022cULL, 0x000000002d2c783bULL, 0x000fe40000004200ULL,
0x0000004f00557306ULL, 0x000ea20000205400ULL, 0x0000900010107811ULL, 0x000fc400078e20ffULL,
0x0000005b5a00720bULL, 0x002fc80003f5d000ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x0000004a00537306ULL, 0x000ff00000209400ULL, 0x0000004a00547306ULL, 0x0006e20000205400ULL,
0x000000555200720bULL, 0x004fc40003f9d000ULL, 0x0000005600527245ULL, 0x000fc8000020d400ULL,
0x0000000152526812ULL, 0x000fe200078efcffULL, 0x0000006a006c7306ULL, 0x000fe60000209400ULL,
0x000000515252723eULL, 0x000fe400000010ffULL, 0x0000004a00517245ULL, 0x000fe4000020d400ULL,
0x0000004f004a7245ULL, 0x008fe2000020d400ULL, 0x0000006a00647306ULL, 0x000ea20000205400ULL,
0x000000545300720bULL, 0x000fc40003f7d000ULL, 0x0000005900537245ULL, 0x000fe4000020d400ULL,
0x000000014a4a4812ULL, 0x000fe400078efcffULL, 0x0000000153532812ULL, 0x000fe200078efcffULL,
0x0000006900737306ULL, 0x000fec0000209400ULL, 0x0000000151513812ULL, 0x000fe200078efcffULL,
0x0000000310108231ULL, 0x082fe200003400ffULL, 0x0000006900657306ULL, 0x0002e20000205400ULL,
0x0000000312128231ULL, 0x000fe200003400ffULL, 0x000000646c00720bULL, 0x004fe20003fdd000ULL,
0x0000000011118231ULL, 0x000fc400003400ffULL, 0x0000000013138231ULL, 0x000fc600003400ffULL,
0x0000004100507306ULL, 0x0004e2000000d400ULL, 0x0000006900697245ULL, 0x002fce000020d400ULL,
0x00000042004c7306ULL, 0x000fe20000009400ULL, 0x0000010042417824ULL, 0x004fe200078e00ffULL,
0x000000657300720bULL, 0x008fc80003f1d000ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000042004b7306ULL, 0x000e620000005400ULL, 0x0000000150505812ULL, 0x000fc800078efcffULL,
0x000000505353723eULL, 0x000fe400000010ffULL, 0x0000006a00507245ULL, 0x000fe2000020d400ULL,
0x00000043004d7306ULL, 0x000fe20000009400ULL, 0x0000000169690812ULL, 0x000fe400078efcffULL,
0x0000000150506812ULL, 0x000fe200078efcffULL, 0x000000521024723cULL, 0x000fe60000041824ULL,
0x000000505150723eULL, 0x000fe200000010ffULL, 0x00000043004e7306ULL, 0x000ea20000005400ULL,
0x0000004b4c00720bULL, 0x002fc40003fdd000ULL, 0x000000694a51723eULL, 0x000fca00000010ffULL,
0x0000004100407306ULL, 0x000fe40000209400ULL, 0x000000501038723cULL, 0x000bec0000041838ULL,
0x00000041005c7306ULL, 0x000e620000205400ULL, 0x0000004e4d00720bULL, 0x004fe40003f1d000ULL,
0x00000018ff4e7819ULL, 0x000fc40000011414ULL, 0x00000018ff517819ULL, 0x020fc60000011415ULL,
0x0000005d005e7306ULL, 0x000ff00000209400ULL, 0x0000005d00607306ULL, 0x000ea20000205400ULL,
0x0000005c4000720bULL, 0x002fe40003f7d000ULL, 0x0000004100407245ULL, 0x000fc4000020d400ULL,
0x0000005d00417245ULL, 0x000fc6000020d400ULL, 0x00000042003f7306ULL, 0x0002ec000000d400ULL,
0x0000000140403812ULL, 0x000fe400078efcffULL, 0x0000004300467306ULL, 0x000ee2000000d400ULL,
0x0001000042427824ULL, 0x002fe200078e00ffULL, 0x000000605e00720bULL, 0x004fc40003fbd000ULL,
0x00000018ff607819ULL, 0x000fe40000011417ULL, 0x00000018ff687819ULL, 0x000fe40000011442ULL,
0x0000003d00667306ULL, 0x000fe20000209400ULL, 0x000000013f3f6812ULL, 0x008fc800078efcffULL,
0x0000003f4040723eULL, 0x000fe400000010ffULL, 0x0000000141415812ULL, 0x000fe200078efcffULL,
0x0000003d00477306ULL, 0x0002a20000205400ULL, 0x0000000146460812ULL, 0x000fe400078efcffULL,
0x00000067003f7245ULL, 0x000fe4000020d400ULL, 0x000000464141723eULL, 0x000fc600000010ffULL,
0x0000003e00497306ULL, 0x000fe20000209400ULL, 0x0000003d003d7245ULL, 0x002fc6000020d400ULL,
0x000000401034723cULL, 0x000be80000041834ULL, 0x0000003e00487306ULL, 0x0002e20000205400ULL,
0x000000476600720bULL, 0x004fe40003f5d000ULL, 0x0000003e00407245ULL, 0x020fe4000020d400ULL,
0x00000018ff417819ULL, 0x000fc6000001142cULL, 0x00000068006d7306ULL, 0x000fe20000209400ULL,
0x00000068003e7245ULL, 0x002fca000020d400ULL, 0x000000013d3d2812ULL, 0x000fe400078efcffULL,
0x00000068006b7306ULL, 0x000e620000205400ULL, 0x000000484900720bULL, 0x008fe40003f9d000ULL,
0x00000018ff497819ULL, 0x000fca0000011416ULL, 0x0000006700727306ULL, 0x000fec0000209400ULL,
0x0000000140404812ULL, 0x000fe400078efcffULL, 0x0000006700717306ULL, 0x000ea20000205400ULL,
0x0000006b6d00720bULL, 0x002fe20003fdd000ULL, 0x00000100146b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000001500437306ULL, 0x000fec0000009400ULL,
0x000000013e3e6812ULL, 0x000fe400078efcffULL, 0x000000717200720bULL, 0x004fe20003f1d000ULL,
0x00000015005f7306ULL, 0x000e620000005400ULL, 0x0000003e3d3e723eULL, 0x000fc400000010ffULL,
0x00000018ff3d7819ULL, 0x000fca000001142eULL, 0x0000001700637306ULL, 0x000fe80000009400ULL,
0x000000013f3f0812ULL, 0x000fc800078efcffULL, 0x0000003f403f723eULL, 0x000fe200000010ffULL,
0x0000001700557306ULL, 0x000ea20000005400ULL, 0x0000005f4300720bULL, 0x002fe20003f5d000ULL,
0x00000100155f7824ULL, 0x000fe200078e00ffULL, 0x0000006b00437245ULL, 0x000fe4000020d400ULL,
0x00000018ff407819ULL, 0x000fe2000001142dULL, 0x0000003e1020723cULL, 0x000be20000041820ULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000006b003f7306ULL, 0x020ff00000209400ULL,
0x0000006b00727306ULL, 0x000e620000205400ULL, 0x000000556300720bULL, 0x004fe20003fbd000ULL,
0x0001000014557824ULL, 0x000fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000001400427306ULL, 0x000ff00000009400ULL, 0x00000014000f7306ULL, 0x000ea20000005400ULL,
0x000000723f00720bULL, 0x002fce0003f9d000ULL, 0x0000001600627306ULL, 0x000fec0000009400ULL,
0x0000000143434812ULL, 0x000fe400078efcffULL, 0x0000001600587306ULL, 0x000e620000005400ULL,
0x0000000f4200720bULL, 0x004fe40003fdd000ULL, 0x00000018ff0f7819ULL, 0x000fca000001142fULL,
0x0000002c005b7306ULL, 0x000ff00000009400ULL, 0x0000002c00597306ULL, 0x000ea20000005400ULL,
0x000000586200720bULL, 0x002fe20003f1d000ULL, 0x0000010016587824ULL, 0x000fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000005f006c7306ULL, 0x000ff00000209400ULL,
0x0000005f00637306ULL, 0x000e620000205400ULL, 0x000000595b00720bULL, 0x004fce0003f7d000ULL,
0x0000001400617306ULL, 0x000eb0000000d400ULL, 0x0000004e00507306ULL, 0x000fe20000209400ULL,
0x000000636c00720bULL, 0x002fce0003f9d000ULL, 0x0000004e00477306ULL, 0x000e620000205400ULL,
0x0000000161616812ULL, 0x004fce00078efcffULL, 0x00000055005b7306ULL, 0x000ff00000209400ULL,
0x0000005500627306ULL, 0x0004e20000205400ULL, 0x000000475000720bULL, 0x002fe40003fdd000ULL,
0x0000005f00507245ULL, 0x000fe2000020d400ULL, 0x00000100175f7824ULL, 0x000fc600078e00ffULL,
0x0000000150504812ULL, 0x000fe200078efcffULL, 0x0000001500547306ULL, 0x0002e2000000d400ULL,
0x0000005500557245ULL, 0x004fe4000020d400ULL, 0x00000018ff5f7819ULL, 0x000fca000001145fULL,
0x00000051005c7306ULL, 0x000fe20000209400ULL, 0x0001000015157824ULL, 0x002fe200078e00ffULL,
0x000000625b00720bULL, 0x008fe20003f9d000ULL, 0x00010000165b7824ULL, 0x000fe400078e00ffULL,
0x000001002d627824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000005100487306ULL, 0x0002a20000205400ULL, 0x0000000154542812ULL, 0x000fe400078efcffULL,
0x00000018ff5b7819ULL, 0x000fc4000001145bULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000000155554812ULL, 0x000fe200078efcffULL, 0x0000001500597306ULL, 0x000fe20000209400ULL,
0x0000005100517245ULL, 0x002fce000020d400ULL, 0x00000015006c7306ULL, 0x000e620000205400ULL,
0x000000485c00720bULL, 0x004fce0003f5d000ULL, 0x0000005800477306ULL, 0x000fec0000209400ULL,
0x0000000151512812ULL, 0x000fe400078efcffULL, 0x0000005800487306ULL, 0x000ea20000205400ULL,
0x0000006c5900720bULL, 0x002fe40003f9d000ULL, 0x0000004e00597245ULL, 0x000fc8000020d400ULL,
0x0000000159596812ULL, 0x000fe200078efcffULL, 0x0000002e00537306ULL, 0x000ff00000009400ULL,
0x0000002e004f7306ULL, 0x000e620000005400ULL, 0x000000484700720bULL, 0x004fe20003fdd000ULL,
0x0001000017487824ULL, 0x000fe200078e00ffULL, 0x0000001500477245ULL, 0x000fe2000020d400ULL,
0x000001002c157824ULL, 0x000fc600078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000005f005c7306ULL, 0x000fe20000209400ULL, 0x0000000147474812ULL, 0x000fe400078efcffULL,
0x00000018ff157819ULL, 0x000fca0000011415ULL, 0x0000005f00637306ULL, 0x0004e20000205400ULL,
0x0000004f5300720bULL, 0x002fe40003f5d000ULL, 0x0000005800537245ULL, 0x000fc8000020d400ULL,
0x0000000153536812ULL, 0x000fe200078efcffULL, 0x0000002d00647306ULL, 0x000fe20000009400ULL,
0x0000005f005f7245ULL, 0x004fce000020d400ULL, 0x0000002d00657306ULL, 0x000e620000005400ULL,
0x000000635c00720bULL, 0x008fe20003fdd000ULL, 0x000100002c5c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x00000017005a7306ULL, 0x000eac000000d400ULL,
0x000000015f5f6812ULL, 0x000fe400078efcffULL, 0x0000005b004e7306ULL, 0x000fe20000209400ULL,
0x000000656400720bULL, 0x002fce0003f9d000ULL, 0x0000005b00177306ULL, 0x0002e20000205400ULL,
0x000000015a5a5812ULL, 0x004fce00078efcffULL, 0x0000001600577306ULL, 0x000ea2000000d400ULL,
0x0000005b005b7245ULL, 0x002fce000020d400ULL, 0x00000049005e7306ULL, 0x000fe20000209400ULL,
0x000000174e00720bULL, 0x008fe20003fdd000ULL, 0x000001002e177824ULL, 0x000fe400078e00ffULL,
0x000100002d4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x00000049005d7306ULL, 0x000e620000205400ULL, 0x0000000157570812ULL, 0x004fe400078efcffULL,
0x00000018ff4e7819ULL, 0x000fc6000001144eULL, 0x000000015b5b6812ULL, 0x000fe400078efcffULL,
0x0000004800167306ULL, 0x000ff00000209400ULL, 0x0000004800657306ULL, 0x0004e20000205400ULL,
0x0000005d5e00720bULL, 0x002fc40003f1d000ULL, 0x00000049005d7245ULL, 0x000fe4000020d400ULL,
0x0000001500497245ULL, 0x000fc6000020d400ULL, 0x00000015006b7306ULL, 0x000fe20000209400ULL,
0x0000004800487245ULL, 0x004fca000020d400ULL, 0x000000015d5d0812ULL, 0x000fe400078efcffULL,
0x00000015006c7306ULL, 0x000e620000205400ULL, 0x000000651600720bULL, 0x008fe20003fdd000ULL,
0x000001002f167824ULL, 0x040fe400078e00ffULL, 0x000100002f657824ULL, 0x000fc600078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000006000467306ULL, 0x000fec0000209400ULL,
0x0000000148486812ULL, 0x000fe400078efcffULL, 0x0000006000667306ULL, 0x0004e20000205400ULL,
0x0000006c6b00720bULL, 0x002fce0003f1d000ULL, 0x00000062004f7306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x004fca000020d400ULL, 0x0000000149490812ULL, 0x000fe400078efcffULL,
0x0000006200727306ULL, 0x000e620000205400ULL, 0x000000664600720bULL, 0x008fce0003fbd000ULL,
0x0000004100687306ULL, 0x000fec0000209400ULL, 0x0000000160605812ULL, 0x000fe400078efcffULL,
0x0000004100677306ULL, 0x0004e20000205400ULL, 0x000000724f00720bULL, 0x002fce0003fdd000ULL,
0x0000002f004c7306ULL, 0x000fe20000009400ULL, 0x0000004100417245ULL, 0x004fce000020d400ULL,
0x0000002f004d7306ULL, 0x000e620000005400ULL, 0x000000676800720bULL, 0x008fce0003f1d000ULL,
0x0000002c00567306ULL, 0x000eac000000d400ULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000002d00527306ULL, 0x000ee2000000d400ULL, 0x0000004d4c00720bULL, 0x002fe40003fbd000ULL,
0x00000062004c7245ULL, 0x000fc8000020d400ULL, 0x000000014c4c6812ULL, 0x000fe200078efcffULL,
0x0000004000697306ULL, 0x000fe20000209400ULL, 0x0000000156563812ULL, 0x004fc800078efcffULL,
0x000000564956723eULL, 0x000fc600000010ffULL, 0x00000040006a7306ULL, 0x0002a20000205400ULL,
0x0000000152524812ULL, 0x008fce00078efcffULL, 0x0000005c002c7306ULL, 0x000fe20000209400ULL,
0x0000004000407245ULL, 0x002fce000020d400ULL, 0x0000005c002d7306ULL, 0x0002e20000205400ULL,
0x0000006a6900720bULL, 0x004fce0003f7d000ULL, 0x0000001700587306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x002fca000020d400ULL, 0x0000000140403812ULL, 0x000fe400078efcffULL,
0x00000017005e7306ULL, 0x0002a20000205400ULL, 0x0000002d2c00720bULL, 0x008fe40003fdd000ULL,
0x00000047512d723eULL, 0x000fe400000010ffULL, 0x00000018ff477819ULL, 0x000fe40000011465ULL,
0x00000055592c723eULL, 0x000fe200000010ffULL, 0x0000004e00637306ULL, 0x000fe20000209400ULL,
0x0000001700177245ULL, 0x002fca000020d400ULL, 0x0000002c0818723cULL, 0x000b620000041818ULL,
0x000000015c5c6812ULL, 0x000fe200078efcffULL, 0x0000004e00647306ULL, 0x000e620000205400ULL,
0x0000005e5800720bULL, 0x004fe40003f1d000ULL, 0x0000005c415c723eULL, 0x000fe400000010ffULL,
0x0000005b5d2c723eULL, 0x020fe400000010ffULL, 0x00000048602d723eULL, 0x000fe200000010ffULL,
0x0000002e004a7306ULL, 0x0004e2000000d400ULL, 0x0000004e005d7245ULL, 0x000fca000020d400ULL,
0x0000000117170812ULL, 0x000fe400078efcffULL, 0x0000001600467306ULL, 0x000fe20000209400ULL,
0x000100002e2e7824ULL, 0x004fe200078e00ffULL, 0x000000646300720bULL, 0x002fc80003f9d000ULL,
0x00000018ff157819ULL, 0x000fe4000001142eULL, 0x00000016004f7306ULL, 0x0002a20000205400ULL,
0x00000061432e723eULL, 0x000fe400000010ffULL, 0x000000014a4a2812ULL, 0x008fc800078efcffULL,
0x000000015d5d4812ULL, 0x000fe200078efcffULL, 0x0000002f004b7306ULL, 0x0006a2000000d400ULL,
0x0000001600167245ULL, 0x002fe4000020d400ULL, 0x0000005d405d723eULL, 0x000fe400000010ffULL,
0x0000004a174a723eULL, 0x000fc600000010ffULL, 0x0000003d003e7306ULL, 0x000fe20000209400ULL,
0x00000054502f723eULL, 0x008fe200000010ffULL, 0x0000005c1018723cULL, 0x000fe20000041818ULL,
0x0000004f4600720bULL, 0x004fca0003f7d000ULL, 0x0000003d00427306ULL, 0x000e620000205400ULL,
0x000000014b4b5812ULL, 0x000fe200078efcffULL, 0x0000002e081c723cULL, 0x000b6c000004181cULL,
0x00000015004d7306ULL, 0x000fe20000209400ULL, 0x00000057532e723eULL, 0x020fe400000010ffULL,
0x0000005a5f2f723eULL, 0x000fc400000010ffULL, 0x0000000116163812ULL, 0x000fe400078efcffULL,
0x000000524c57723eULL, 0x000fe200000010ffULL, 0x0000001500437306ULL, 0x0004e20000205400ULL,
0x000000423e00720bULL, 0x002fe20003fdd000ULL, 0x0000002e0830723cULL, 0x000f620000041830ULL,
0x0000004b164b723eULL, 0x000fe400000010ffULL, 0x0000000f00167245ULL, 0x000fc6000020d400ULL,
0x0000000f003f7306ULL, 0x000fe20000209400ULL, 0x0000001500157245ULL, 0x004fe2000020d400ULL,
0x0000002c0808723cULL, 0x000f6c0000041828ULL, 0x0000000f00147306ULL, 0x000e620000205400ULL,
0x000000434d00720bULL, 0x008fe20003f1d000ULL, 0x00000056101c723cULL, 0x040b6c000004181cULL,
0x0000004700507306ULL, 0x000fe40000209400ULL, 0x0000004a1030723cULL, 0x020b680000041830ULL,
0x0000000115150812ULL, 0x000fc400078efcffULL, 0x0000004700517306ULL, 0x0004e20000205400ULL,
0x000000143f00720bULL, 0x002fe40003f9d000ULL, 0x0000003d00147245ULL, 0x000fc8000020d400ULL,
0x0000000114146812ULL, 0x000fe400078efcffULL, 0x0000004700477245ULL, 0x004fe4000020d400ULL,
0x000000151414723eULL, 0x000fc600000010ffULL, 0x0000000116164812ULL, 0x000fe400078efcffULL,
0x000000515000720bULL, 0x008fda0003f5d000ULL, 0x0000000147472812ULL, 0x000fc800078efcffULL,
0x000000471615723eULL, 0x000fce00000010ffULL, 0x000000141010723cULL, 0x000b620000041808ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000005087f8cULL, 0x0202a2000c80043fULL,
0x0000000144447810ULL, 0x000fe40007ffe0ffULL, 0x0000f6a0780a7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000aff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff0f7224ULL, 0x004fe200078e0009ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff270000007947ULL, 0x000fea000383ffffULL, 0x000000ff7000720cULL, 0x008fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000003c007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000f0a000047802ULL, 0x002fc40000000f00ULL, 0x000086c000007944ULL, 0x014fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003c00037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc8000000003cULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff057624ULL, 0x000fe400078e00ffULL, 0x00006c00ff047624ULL, 0x000fca00078e00ffULL,
0x0000000804057981ULL, 0x008ee8000c1e9900ULL, 0x0000000000037919ULL, 0x000e680000000000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011603ULL,
0x0000000808037811ULL, 0x004fe200078ff0ffULL, 0x0000000005067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0306037589ULL, 0x000ea200000e0000ULL,
0x0000002400247220ULL, 0x042fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000001000107220ULL, 0x040fe20000410000ULL, 0x0000001100117220ULL, 0x000fe20000410000ULL,
0x0000002603267220ULL, 0x044fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000003a033a7220ULL, 0x040fe20000410000ULL, 0x0000003b033b7220ULL, 0x040fe20000410000ULL,
0x0000003603367220ULL, 0x040fe20000410000ULL, 0x0000003703377220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000003303337220ULL, 0x040fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001303137220ULL, 0x000fc20000410000ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000100002067824ULL, 0x000fe200078e00ffULL,
0x000000181918723eULL, 0x000fc400000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000303130723eULL, 0x000fe400000010ffULL, 0x000000101110723eULL, 0x000fe400000010ffULL,
0x000000363736723eULL, 0x000fc400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x0000001a1b0f723eULL, 0x000fe400000010ffULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x00000002ff077819ULL, 0x102fe20000011605ULL,
0x000000017c7c7824ULL, 0x000fe200078e0205ULL, 0x0000000205007812ULL, 0x000fc400078ec0ffULL,
0x0000000805097811ULL, 0x000fe200078ff0ffULL, 0x00000008070b7824ULL, 0x040fe200078e00ffULL,
0x0000000700047211ULL, 0x040fe200078ff8ffULL, 0x00000008070c7824ULL, 0x004fe200078e00ffULL,
0x0000000900037211ULL, 0x000fe200078ff8ffULL, 0x00000008090e7824ULL, 0x010fe200078e00ffULL,
0x0000000204007810ULL, 0x000fe20007ffe0ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x000000121319723eULL, 0x000fe400000010ffULL, 0xfffffff80e0e7812ULL, 0x000fc400078ee203ULL,
0x0000100006037812ULL, 0x000fe400078ee2ffULL, 0xfffffff809087812ULL, 0x040fe400078ee200ULL,
0xfffffff809007812ULL, 0x000fe200078ee204ULL, 0x0000080074077824ULL, 0x100fe200078e0203ULL,
0x0000000404067810ULL, 0x000fe20007ffe0ffULL, 0x000000107c7c7824ULL, 0x000fe200078e0203ULL,
0x0000000604097810ULL, 0x000fe20007ffe0ffULL, 0x0000000805047824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0a7812ULL, 0x000fe200078ee206ULL, 0x0000001000067824ULL, 0x000fe200078e0207ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x000000100e0e7824ULL, 0x100fe200078e0207ULL,
0x0000000804097812ULL, 0x000fe200078ec0ffULL, 0x0000001008087824ULL, 0x100fe200078e0207ULL,
0x000000242500723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0207ULL,
0x000000383904723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fc400078e0207ULL,
0x0000000106077824ULL, 0x000fe200078e0209ULL, 0x0000541000147816ULL, 0x040fe20000000004ULL,
0x0000000109087824ULL, 0x040fe200078e0208ULL, 0x0000763200157816ULL, 0x000fe20000000004ULL,
0x00000001090a7824ULL, 0x000fe200078e020aULL, 0x000000343500723eULL, 0x000fe200000010ffULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x000000202104723eULL, 0x000fe200000010ffULL,
0x0000001407007388ULL, 0x0003e20000000a00ULL, 0x0000001c1d06723eULL, 0x000fe200000010ffULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x0000541000147816ULL, 0x002fc40000000004ULL,
0x0000763200157816ULL, 0x000fe40000000004ULL, 0x0000763230077816ULL, 0x000fe40000000010ULL,
0x000000262700723eULL, 0x000fe200000010ffULL, 0x0000001408007388ULL, 0x0003e20000000a00ULL,
0x0000003a3b04723eULL, 0x000fe400000010ffULL, 0x0000541006147816ULL, 0x142fe40000000018ULL,
0x0000763206157816ULL, 0x000fc40000000018ULL, 0x0000541030067816ULL, 0x000fc60000000010ULL,
0x000000140a007388ULL, 0x000fe80000000a00ULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x0000541000067816ULL, 0x142fe40000000004ULL, 0x0000763200077816ULL, 0x000fe40000000004ULL,
0x000000ff00007306ULL, 0x000fe60000205400ULL, 0x000000060e007388ULL, 0x0003e40000000a00ULL,
0x0000541036067816ULL, 0x002fc40000000022ULL, 0x0000763236077816ULL, 0x000fe40000000022ULL,
0x000054101e0e7816ULL, 0x140fe4000000000fULL, 0x000076321e0f7816ULL, 0x000fe2000000000fULL,
0x0004000608007388ULL, 0x0003e80000000a00ULL, 0x0004000e0a007388ULL, 0x0005e20000000a00ULL,
0x000000ff00077306ULL, 0x002e620000209400ULL, 0x00005410320e7816ULL, 0x004fc40000000019ULL,
0x00007632320f7816ULL, 0x000fca0000000019ULL, 0x0004000e0c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000007c107984ULL, 0x000ea20000000c00ULL,
0x000000000700720bULL, 0x002fc40003f1d000ULL, 0x000000ff00007245ULL, 0x000fe2000020d400ULL,
0x000400007c087984ULL, 0x000e680000000c00ULL, 0x000800007c147984ULL, 0x000ee80000000c00ULL,
0x000c00007c187984ULL, 0x000ee40000000c00ULL, 0x0000000100000812ULL, 0x000fc400078efcffULL,
0x000000ff7400720cULL, 0x000fe40003f05270ULL, 0x000000000004723eULL, 0x000fca00000010ffULL,
0x3f803f8004137831ULL, 0x044fe40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x040fe40000200010ULL,
0x3f803f80040b7831ULL, 0x042fe4000020000bULL, 0x3f803f80040a7831ULL, 0x000fc4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fc40000200014ULL,
0x3f803f800b0b7831ULL, 0x000fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x000000107c007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x000400087c007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x000fc80000011605ULL, 0x000000790600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x0000000106007824ULL, 0x000fe200078e0205ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a007a7a7a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000102117812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x0000002005027810ULL, 0x000fc40007ffe0ffULL, 0x0ffffff800007812ULL, 0x000fe400078ef805ULL,
0x00000007050c7812ULL, 0x000fc600078ec0ffULL, 0x0000001000047824ULL, 0x000fe400078e0203ULL,
0x000000107b007824ULL, 0x000fe400078e0206ULL, 0x00000008110d7824ULL, 0x000fe200078e020cULL,
0x0000000004087984ULL, 0x0004e40000000c00ULL, 0x0000000500077c12ULL, 0x000fe2000f8e30ffULL,
0x00000006040472a4ULL, 0x002fe2000f8e023fULL, 0x00005a00ff067a19ULL, 0x000fc60000011600ULL,
0x000000017a077824ULL, 0x000fe400078e0207ULL, 0x000000047d007c24ULL, 0x000fe4000f8e02ffULL,
0x0000007d06077224ULL, 0x000fca00078e0207ULL, 0x0000000700077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x004fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f4404ULL, 0x00000003ff047819ULL, 0x000fc60000011602ULL,
0x000000100d067825ULL, 0x000fe200078e0006ULL, 0x000000790400720cULL, 0x000fc80003f06070ULL,
0x0000000806007986ULL, 0x0083f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102067824ULL, 0x102fe200078e0204ULL, 0x00000040050c7810ULL, 0x000fe20007ffe0ffULL,
0x000000107b047824ULL, 0x000fc600078e0204ULL, 0x0000000706077812ULL, 0x000fc800078ec0ffULL,
0x0ffffff807067812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001006087824ULL, 0x000fe200078e0203ULL, 0x0000000504067c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e0202ULL, 0x00005a00ff047a19ULL, 0x000fc60000011604ULL,
0x0000000008087984ULL, 0x000e620000000c00ULL, 0x000000017a067824ULL, 0x000fc800078e0206ULL,
0x0000007d04077224ULL, 0x000fca00078e0206ULL, 0x0000000700077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f4404ULL, 0x00000003ff047819ULL, 0x000fc6000001160cULL,
0x000000100d067825ULL, 0x000fe200078e0006ULL, 0x000000790400720cULL, 0x000fc80003f06070ULL,
0x0000000806007986ULL, 0x0023f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe400078e0204ULL, 0x000000107b047824ULL, 0x000fc600078e0204ULL,
0x0000000702077812ULL, 0x002fe400078ec0ffULL, 0x0000000504067c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff807027812ULL, 0x000fe400078ef80cULL, 0x00005a00ff047a19ULL, 0x000fe20000011604ULL,
0x000000017a067824ULL, 0x000fe200078e0206ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001002027824ULL, 0x000fe400078e0203ULL, 0x0000007d04077224ULL, 0x000fe200078e0206ULL,
0x0000006005067810ULL, 0x000fc40007ffe0ffULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0007047a11ULL, 0x040fe400078040ffULL, 0x00000003ff027819ULL, 0x002fe40000011606ULL,
0x00005d0007057a11ULL, 0x000fe200000f440eULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x000000790200720cULL, 0x000fe20003f06070ULL, 0x00000001060c7824ULL, 0x000fe400078e0202ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000070c077812ULL, 0x000fc800078ec0ffULL,
0xfffffff8070c7812ULL, 0x000fe200078ef806ULL, 0x0000000804007986ULL, 0x0043e4000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000107b027824ULL, 0x000fc800078e0202ULL,
0x000000000c0c7984ULL, 0x000ea20000000c00ULL, 0x0000000502037c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811057824ULL, 0x002fe200078e0206ULL, 0x00005a00ff027a19ULL, 0x000fc60000011602ULL,
0x000000017a037824ULL, 0x000fc800078e0203ULL, 0x0000007d02037224ULL, 0x000fca00078e0203ULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x004fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000006f0200720cULL, 0x000fda0003f06070ULL,
0x0000000200038824ULL, 0x000fc800078e00ffULL, 0x0000680003088a24ULL, 0x000fe400078e0202ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x0000640008088625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff0a7624ULL, 0x000fe200078e00ffULL,
0x0000000808038981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff0b7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff067f8cULL, 0x000ee8000c80043fULL, 0x000000080a6d7981ULL, 0x000322000c1e9900ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x000000400e757824ULL, 0x000fe400078e00ffULL,
0x0000004002797824ULL, 0x000fe400078e00ffULL, 0x000000407a047824ULL, 0x002fc400078e00ffULL,
0x0000007503217224ULL, 0x004fcc00078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x008fe40000011645ULL, 0x00006200211f7a11ULL, 0x000fe400078038ffULL,
0x000000081d0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000407a7a7824ULL, 0x000fe200078e021dULL,
0x0000630021217a11ULL, 0x000fe400000f3cffULL, 0x00000045450e7211ULL, 0x000fe200078fe8ffULL,
0x000000807a087825ULL, 0x040fe200078e00ffULL, 0x000000087a0a7810ULL, 0x000fc40007ffe0ffULL,
0x000000107a0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000003008107812ULL, 0x100fe200078ef805ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000030e167812ULL, 0x000fe400078ec0ffULL,
0x000000101f107210ULL, 0x000fe20007f1e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a127812ULL, 0x000fe400078ef805ULL, 0x000000796e0a7217ULL, 0x000fe20007800000ULL,
0x0000000109117824ULL, 0x000fe200000e0621ULL, 0x0000001f12127210ULL, 0x000fc40007f3e0ffULL,
0x0000100002187811ULL, 0x000fe200078e68ffULL, 0x000000010a147824ULL, 0x000fe200078e0a79ULL,
0x000000287a0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b137824ULL, 0x000fe200008e0621ULL,
0x0ffffffc16457812ULL, 0x000fe400078ef845ULL, 0x000000140f00720cULL, 0x0c0fe20003f26070ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x000000141d00720cULL, 0x000fe20003f06070ULL,
0x0000001045457824ULL, 0x000fe200078e0218ULL, 0x000000300c087812ULL, 0x000fc400078ef805ULL,
0xfffffffc0f0f7812ULL, 0x000fe400078ee216ULL, 0x0000001f08087210ULL, 0x000fe40007f5e0ffULL,
0x000000207a0c7810ULL, 0x040fe20007ffe0ffULL, 0x000000100f157824ULL, 0x000fe200078e0218ULL,
0x000000187a0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000101d237810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010457faeULL, 0x0003e2000c101c48ULL, 0x000000181d257810ULL, 0x000fe20007ffe0ffULL,
0x000000010d097824ULL, 0x000fe200010e0621ULL, 0x000000300e0e7812ULL, 0x000fe200078ef805ULL,
0x0000000012157faeULL, 0x0005e2000c901c48ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000201d177810ULL, 0x000fc40007ffe0ffULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x100fe400078ef805ULL,
0x000000387a107810ULL, 0x002fe20007ffe0ffULL, 0x0000000419277824ULL, 0x000fe200078e00ffULL,
0x000000300a0a7812ULL, 0x000fe400078ef805ULL, 0x0000001f0e127210ULL, 0x084fe20007fde0ffULL,
0x0000000423157824ULL, 0x000fe200078e00ffULL, 0x000000307a0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001f0c0c7210ULL, 0x000fc40007f7e0ffULL,
0x0000001f0a0a7210ULL, 0x080fe20007f5e0ffULL, 0x000000010f137824ULL, 0x000fe200030e0621ULL,
0x000000301d1b7810ULL, 0x040fe20007ffe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000381d1d7810ULL, 0x000fe40007ffe0ffULL, 0x000000142500720cULL, 0x0c0fe20003f86070ULL,
0x0000000425257824ULL, 0x000fe200078e00ffULL, 0x000000300e0e7812ULL, 0x000fe200078ef805ULL,
0x000000010d0d7824ULL, 0x100fe200018e0621ULL, 0x000000142300720cULL, 0x080fe20003fa6070ULL,
0x0000000417237824ULL, 0x040fe200078e00ffULL, 0x000000141700720cULL, 0x080fe20003f66070ULL,
0x000000010b0b7824ULL, 0x000fe200010e0621ULL, 0x000000141d00720cULL, 0x080fe20003f06070ULL,
0x000000041b297824ULL, 0x000fe200078e00ffULL, 0x0000001f0e0e7210ULL, 0x000fe20007fde0ffULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x000000141900720cULL, 0x000fc40003f46070ULL,
0xfffffffc15157812ULL, 0x100fe200078ee216ULL, 0x000000010f0f7824ULL, 0x000fe200030e0621ULL,
0x000000141b00720cULL, 0x000fe40003f26070ULL, 0xfffffffc25177812ULL, 0x000fe200078ee216ULL,
0x0000001015157824ULL, 0x000fe200078e0218ULL, 0x0000003010107812ULL, 0x000fe400078ef805ULL,
0xfffffffc23197812ULL, 0x000fe200078ee216ULL, 0x0000001017177824ULL, 0x000fe200078e0218ULL,
0xfffffffc271b7812ULL, 0x100fe200078ee216ULL, 0x0000000008157faeULL, 0x0003e2000e901c48ULL,
0xfffffffc29057812ULL, 0x000fe200078ee216ULL, 0x0000001019197824ULL, 0x000fe200078e0218ULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee216ULL, 0x000000101b1b7824ULL, 0x100fe200078e0218ULL,
0x0000001f10107210ULL, 0x000fe20007fde0ffULL, 0x0000001005057824ULL, 0x100fe200078e0218ULL,
0x000000000a177faeULL, 0x0003e2000e101c48ULL, 0x000000101d1d7824ULL, 0x000fc400078e0218ULL,
0x0000000111117824ULL, 0x000fe200030e0621ULL, 0x000000000c197faeULL, 0x0003e8000d901c48ULL,
0x00000000121b7faeULL, 0x0003e8000d101c48ULL, 0x000000000e057faeULL, 0x0003e8000c901c48ULL,
0x00000000101d7faeULL, 0x0003e2000c101c48ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x0000000845177811ULL, 0x048fe400078ff0ffULL, 0x00000010450b7811ULL, 0x000fc400078ff0ffULL,
0x0000004545097211ULL, 0x000fe200078fe8ffULL, 0x0000000417197824ULL, 0x000fe200078e00ffULL,
0x00000018450d7811ULL, 0x000fe200078ff0ffULL, 0x000000040b1b7824ULL, 0x000fe200078e00ffULL,
0x00000020450f7811ULL, 0x040fe400078ff0ffULL, 0x0000002845117811ULL, 0x000fe200078ff0ffULL,
0x000000040d1d7824ULL, 0x000fe200078e00ffULL, 0x0000003045137811ULL, 0x000fe200078ff0ffULL,
0x000000040f1f7824ULL, 0x000fe200078e00ffULL, 0x0000003845157811ULL, 0x000fe200078ff0ffULL,
0x0000000411237824ULL, 0x000fe200078e00ffULL, 0x0000000309167812ULL, 0x000fe200078ec0ffULL,
0x0000000413297824ULL, 0x000fe200078e00ffULL, 0x0000000445087211ULL, 0x000fe200078ff0ffULL,
0x00000004152b7824ULL, 0x000fe200078e00ffULL, 0x0000100002257811ULL, 0x000fc400078e68ffULL,
0xfffffffc190a7812ULL, 0x100fe200078ee216ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc1b0c7812ULL, 0x100fe400078ee216ULL, 0xfffffffc1d0e7812ULL, 0x100fe200078ee216ULL,
0x000000100a197824ULL, 0x100fe200078e0225ULL, 0xfffffffc1f107812ULL, 0x100fe200078ee216ULL,
0x000000100c1b7824ULL, 0x000fe200078e0225ULL, 0x0000620021277a11ULL, 0x000fe200078038ffULL,
0x00000001040a7824ULL, 0x000fe200078e0217ULL, 0xfffffffc23127812ULL, 0x100fe200078ee216ULL,
0x000000100e1d7824ULL, 0x000fe200078e0225ULL, 0x0ffffffc16457812ULL, 0x000fe200078ef845ULL,
0x00000001040c7824ULL, 0x000fe200078e020bULL, 0xfffffffc29147812ULL, 0x100fe200078ee216ULL,
0x00000010101f7824ULL, 0x000fe200078e0225ULL, 0xfffffffc2b167812ULL, 0x000fe200078ee216ULL,
0x00000001040e7824ULL, 0x000fe200078e020dULL, 0x0000630021297a11ULL, 0x000fe200000f3cffULL,
0x0000001012217824ULL, 0x000fe200078e0225ULL, 0x0000003008087812ULL, 0x000fe200078ef805ULL,
0x0000000104107824ULL, 0x000fc400078e020fULL, 0x0000001045457824ULL, 0x100fe200078e0225ULL,
0x0000000827087210ULL, 0x000fe20007f1e0ffULL, 0x0000001014237824ULL, 0x000fe400078e0225ULL,
0x0000000104127824ULL, 0x000fe400078e0211ULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x0000001016257824ULL, 0x000fe200078e0225ULL, 0x000000300a0a7812ULL, 0x000fe200078ef805ULL,
0x0000000104147824ULL, 0x000fe400078e0213ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000000104167824ULL, 0x000fe200078e0215ULL, 0x000000300c0c7812ULL, 0x000fe200078ef805ULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x0000000c270c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000300e0e7812ULL, 0x000fc600078ef805ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000003010107812ULL, 0x100fe400078ef805ULL,
0x0000000e270e7210ULL, 0x040fe20007f5e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003012127812ULL, 0x100fe400078ef805ULL, 0x0000001027107210ULL, 0x040fe20007f7e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003014147812ULL, 0x000fe400078ef805ULL,
0x0000001227127210ULL, 0x000fe20007f9e0ffULL, 0x0000000109097824ULL, 0x100fe200000e0629ULL,
0x0000000a270a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010d0d7824ULL, 0x000fe200008e0629ULL,
0x0000003016057812ULL, 0x000fe200078ef805ULL, 0x000000010f0f7824ULL, 0x100fe200010e0629ULL,
0x0000001427147210ULL, 0x000fe20007fbe0ffULL, 0x000000010b0b7824ULL, 0x100fe200000e0629ULL,
0x0000000527167210ULL, 0x000fe20007fde0ffULL, 0x0000000111117824ULL, 0x100fe200018e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008457faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x000fc400020e0629ULL, 0x0000000115157824ULL, 0x100fe200028e0629ULL,
0x000000000a197faeULL, 0x0003e2000b901c48ULL, 0x0000000117177824ULL, 0x000fc600030e0629ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c48ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c48ULL,
0x00000000101f7faeULL, 0x0003e8000b901c48ULL, 0x0000000012217faeULL, 0x0003e8000b901c48ULL,
0x0000000014237faeULL, 0x0003e8000b901c48ULL, 0x0000000016257faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140bULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002002057824ULL, 0x002fca00078e0205ULL,
0x00000003ff067819ULL, 0x000fc80000011605ULL, 0x1ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000000f05067812ULL, 0x000fc600078ec0ffULL, 0x0000000105087824ULL, 0x000fe400078e0208ULL,
0x00000010060a7824ULL, 0x040fe400078e00ffULL, 0x0000001006077824ULL, 0x000fe200078e00ffULL,
0x0000000f08057812ULL, 0x040fe400078ec0ffULL, 0x0000000108087810ULL, 0x000fe40007ffe0ffULL,
0x000000f00a057812ULL, 0x000fe400078ee205ULL, 0x0000000f08087812ULL, 0x000fc600078ec0ffULL,
0x0000000005107984ULL, 0x000e62000000cc00ULL, 0x000000f007087812ULL, 0x000fca00078ee208ULL,
0x00000000080c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fc400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001405007388ULL, 0x0003e8000000cc00ULL,
0x0000001008007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x00f60400ff057984ULL, 0x002e640000000800ULL,
0x8000000005ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011409ULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00005800ff717624ULL, 0x000fe200078e00ffULL,
0x800058006e767a10ULL, 0x000fe20007ffe0ffULL, 0x0000680000747a24ULL, 0x000fe200078e02ffULL,
0x3db504f36d6d7820ULL, 0x010fe20000410000ULL, 0x0000f68802787811ULL, 0x000fe200078e18ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000001f71007810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200078e0002ULL, 0xffffffff71777810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff007819ULL, 0x000fc40000011600ULL, 0x0000f608027a7811ULL, 0x000fe400078e28ffULL,
0x0000000971717810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff767819ULL, 0x000fe40000011676ULL,
0x0ffffffe00727812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e0007ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x01cfc4000001ff00ULL,
0x000000010a00780cULL, 0x000fe20003f25270ULL, 0x00000c0000007945ULL, 0x000fe20003800000ULL,
0x00000001060c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200078e000aULL,
0x000000010a0d7810ULL, 0x000fe20007ffe0ffULL, 0x00000075033c7224ULL, 0x030fc600078e02ffULL,
0x000000020d00780cULL, 0x040fe20003f06070ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000dULL,
0x000000ff0d007207ULL, 0x000fc60000800000ULL, 0x000000ffff0c1224ULL, 0x000fca00078e0206ULL,
0x000000010c077810ULL, 0x000fc80007ffe0ffULL, 0x000000700700720cULL, 0x000fe40003f46070ULL,
0x0000000109077812ULL, 0x000fd600078e0cffULL, 0x000006000000a947ULL, 0x000fea0003800000ULL,
0x00000010050d7824ULL, 0x002fe200078e00ffULL, 0x00000002ff437819ULL, 0x000fe20000011605ULL,
0x000001000c1b7824ULL, 0x000fe200078e0279ULL, 0x000062003c397a11ULL, 0x000fe200078238ffULL,
0x00000002023b7824ULL, 0x000fe200078e0207ULL, 0x000000300d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001040f7824ULL, 0x000fe200078e0243ULL, 0x00000010433f7810ULL, 0x040fe40007ffe0ffULL,
0x00000008433d7810ULL, 0x040fe20007ffe0ffULL, 0x00000040000c7824ULL, 0x000fe200078e020dULL,
0x0000001b6e1e7217ULL, 0x000fe20007800000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000063003c387a11ULL, 0x000fe200008f3cffULL, 0x00000001041f7824ULL, 0x000fe200078e023fULL,
0x0000001843497810ULL, 0x000fe20007ffe0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x00000020434b7810ULL, 0x000fc40007ffe0ffULL, 0x000010003b3b7811ULL, 0x000fe200078e60ffULL,
0x0000000104197824ULL, 0x000fe200078e023dULL, 0x000000390e1a7210ULL, 0x000fe20007f3e0ffULL,
0x000000011e3a7824ULL, 0x000fe200078e0a1bULL, 0x00000005050e7211ULL, 0x000fe200078fe8ffULL,
0x000000801f1e7825ULL, 0x100fe200078e000cULL, 0x00000028434d7810ULL, 0x000fe40007ffe0ffULL,
0x000000030e3c7812ULL, 0x000fe200078ec0ffULL, 0x0000008019187825ULL, 0x000fe200078e000cULL,
0x00000030434f7810ULL, 0x000fc40007ffe0ffULL, 0x0ffffffc3c3e7812ULL, 0x000fe200078ef805ULL,
0x000000010f1b7824ULL, 0x000fe200008e0638ULL, 0x000000391e1e7210ULL, 0x080fe20007f3e0ffULL,
0x00000001040f7824ULL, 0x000fe200078e0249ULL, 0x00000039181c7210ULL, 0x000fe20007f5e0ffULL,
0x000000043f417824ULL, 0x000fe200078e00ffULL, 0x0000003843517810ULL, 0x000fe20007ffe0ffULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x0000003a4900720cULL, 0x000fc60003fa6070ULL,
0x000000011f1f7824ULL, 0x100fe200008e0638ULL, 0x0000003a4300720cULL, 0x080fe20003f26070ULL,
0x00000001191d7824ULL, 0x000fe200010e0638ULL, 0x0000003a3d00720cULL, 0x0c0fe20003f46070ULL,
0x000000043d3d7824ULL, 0x000fe200078e00ffULL, 0x000000390e0e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000104197824ULL, 0x040fe400078e024bULL, 0x0000000104437824ULL, 0x000fe200078e024dULL,
0xfffffffc3d407812ULL, 0x000fe200078ee23cULL, 0x000000010f0f7824ULL, 0x000fe200018e0638ULL,
0x0000003a3f00720cULL, 0x000fe20003f66070ULL, 0x000000103e3d7824ULL, 0x000fe200078e023bULL,
0xfffffffc413e7812ULL, 0x000fe200078ee23cULL, 0x0000008019187825ULL, 0x000fc600078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a3d7faeULL, 0x0003e2000c901c48ULL,
0x00000010403f7824ULL, 0x000fe200078e023bULL, 0x0000003918187210ULL, 0x000fe20007f9e0ffULL,
0x0000000104457824ULL, 0x000fe200078e024fULL, 0x0000003a5100720cULL, 0x080fe20003f26070ULL,
0x000000103e417824ULL, 0x000fe200078e023bULL, 0x000000001c3f7faeULL, 0x0005e2000d101c48ULL,
0x0000000119197824ULL, 0x000fe200020e0638ULL, 0x0000003a4b00720cULL, 0x080fe20003f86070ULL,
0x0000000104477824ULL, 0x000fe200078e0251ULL, 0x000000001e417faeULL, 0x0007e2000d901c48ULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x0000003a4d00720cULL, 0x080fe20003f66070ULL,
0x00000080431a7825ULL, 0x002fe200078e000cULL, 0x0000003a4f00720cULL, 0x000fc60003f46070ULL,
0x000000044b4b7824ULL, 0x000fe200078e00ffULL, 0x000000391a1a7210ULL, 0x000fe20007fde0ffULL,
0x00000080451c7825ULL, 0x004fe200078e000cULL, 0xfffffffc491e7812ULL, 0x008fc600078ee23cULL,
0x000000011b1b7824ULL, 0x000fe200030e0638ULL, 0x000000391c1c7210ULL, 0x000fe20007fde0ffULL,
0x000000044d4d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc4b3a7812ULL, 0x000fe200078ee23cULL,
0x000000044f4f7824ULL, 0x000fe400078e00ffULL, 0x00000080470c7825ULL, 0x000fe200078e000cULL,
0xfffffffc4d3e7812ULL, 0x100fe400078ee23cULL, 0xfffffffc4f407812ULL, 0x000fe200078ee23cULL,
0x0000000451517824ULL, 0x000fc400078e00ffULL, 0x000000011d1d7824ULL, 0x000fe200030e0638ULL,
0x000000390c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000101e1f7824ULL, 0x100fe200078e023bULL,
0xfffffffc513c7812ULL, 0x000fe200078ee23cULL, 0x000000103a3d7824ULL, 0x100fe400078e023bULL,
0x000000103e397824ULL, 0x100fe200078e023bULL, 0x000000000e1f7faeULL, 0x0003e2000e901c48ULL,
0x00000010403f7824ULL, 0x100fe400078e023bULL, 0x000000103c3b7824ULL, 0x000fe200078e023bULL,
0x00000000183d7faeULL, 0x0003e2000e101c48ULL, 0x000000010d0d7824ULL, 0x000fc600030e0638ULL,
0x000000001a397faeULL, 0x0003e8000d901c48ULL, 0x000000001c3f7faeULL, 0x0003e8000d101c48ULL,
0x000000000c3b7faeULL, 0x0003e2000c901c48ULL, 0x0000053000007947ULL, 0x000fea0003800000ULL,
0x0000000805197811ULL, 0x042fe200078ff0ffULL, 0x00000002020d7824ULL, 0x000fe200078e0207ULL,
0x00000010051d7811ULL, 0x000fc400078ff0ffULL, 0x0000001805397811ULL, 0x000fe200078ff0ffULL,
0x00000004193f7824ULL, 0x000fe200078e00ffULL, 0x00000020054f7811ULL, 0x000fe200078ff0ffULL,
0x000000041d417824ULL, 0x000fe200078e00ffULL, 0x0000002805517811ULL, 0x000fe200078ff0ffULL,
0x0000000439437824ULL, 0x000fe200078e00ffULL, 0x0000003005537811ULL, 0x000fe200078ff0ffULL,
0x000000044f457824ULL, 0x000fe200078e00ffULL, 0x0000003805557811ULL, 0x000fe200078ff0ffULL,
0x0000000451477824ULL, 0x000fe200078e00ffULL, 0x00000005050c7211ULL, 0x000fe200078fe8ffULL,
0x0000000453497824ULL, 0x000fe200078e00ffULL, 0x000010000d0e7811ULL, 0x000fe200078e60ffULL,
0x00000004554b7824ULL, 0x000fe200078e00ffULL, 0x000000030c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000001041f7824ULL, 0x040fe200078e0219ULL, 0x00000004051b7211ULL, 0x000fe200078ff0ffULL,
0x00000001043b7824ULL, 0x040fe200078e021dULL, 0xfffffffc3f3f7812ULL, 0x100fe200078ee20cULL,
0x0000000104397824ULL, 0x040fe200078e0239ULL, 0xfffffffc41417812ULL, 0x100fe200078ee20cULL,
0x00000001041d7824ULL, 0x000fe200078e024fULL, 0xfffffffc43437812ULL, 0x000fe200078ee20cULL,
0x000000103f3f7824ULL, 0x000fe200078e020eULL, 0xfffffffc45457812ULL, 0x000fe200078ee20cULL,
0x0000001041417824ULL, 0x000fe200078e020eULL, 0xfffffffc47477812ULL, 0x000fe200078ee20cULL,
0x0000001043437824ULL, 0x100fe200078e020eULL, 0x0ffffffc0c3d7812ULL, 0x000fe200078ef805ULL,
0x0000001045457824ULL, 0x000fe200078e020eULL, 0xfffffffc49497812ULL, 0x000fe200078ee20cULL,
0x0000001047477824ULL, 0x000fe200078e020eULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee20cULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x000062003c4d7a11ULL, 0x000fe200078238ffULL,
0x000000103d3d7824ULL, 0x000fc400078e020eULL, 0x0000001049497824ULL, 0x100fe200078e020eULL,
0x000000300c0f7812ULL, 0x000fe200078ec0ffULL, 0x000000104b4b7824ULL, 0x000fe200078e020eULL,
0x000063003c4f7a11ULL, 0x000fe200008f3cffULL, 0x0000000104197824ULL, 0x000fe400078e0251ULL,
0x00000040000e7824ULL, 0x000fe400078e020fULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00000001040d7824ULL, 0x000fc400078e0253ULL, 0x000000801b1a7825ULL, 0x000fc800078e000eULL,
0x000000801f1e7825ULL, 0x000fe200078e000eULL, 0x0000004d1a1a7210ULL, 0x000fc60007f3e0ffULL,
0x000000803b3a7825ULL, 0x000fe200078e000eULL, 0x0000004d1e1e7210ULL, 0x000fc60007f5e0ffULL,
0x0000008039387825ULL, 0x000fe200078e000eULL, 0x0000004d3a3a7210ULL, 0x000fc60007f7e0ffULL,
0x0000000104557824ULL, 0x000fe200078e0255ULL, 0x0000004d38387210ULL, 0x000fe20007f9e0ffULL,
0x000000801d1c7825ULL, 0x000fc800078e000eULL, 0x0000008019187825ULL, 0x000fc800078e000eULL,
0x000000800d0c7825ULL, 0x000fc800078e000eULL, 0x00000080550e7825ULL, 0x000fc800078e000eULL,
0x000000011b1b7824ULL, 0x100fe200008e064fULL, 0x0000004d1c1c7210ULL, 0x080fe20007f3e0ffULL,
0x000000011f1f7824ULL, 0x100fe200010e064fULL, 0x0000004d18187210ULL, 0x080fe20007f5e0ffULL,
0x000000013b3b7824ULL, 0x100fe200018e064fULL, 0x0000004d0c0c7210ULL, 0x080fe20007f7e0ffULL,
0x0000000139397824ULL, 0x100fe200020e064fULL, 0x0000004d0e0e7210ULL, 0x000fe20007f9e0ffULL,
0x000000011d1d7824ULL, 0x100fe200008e064fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a3d7faeULL, 0x0003e2000b901c48ULL, 0x0000000119197824ULL, 0x000fc400010e064fULL,
0x000000010d0d7824ULL, 0x100fe200018e064fULL, 0x000000001e3f7faeULL, 0x0003e2000b901c48ULL,
0x000000010f0f7824ULL, 0x000fc600020e064fULL, 0x000000003a417faeULL, 0x0003e8000b901c48ULL,
0x0000000038437faeULL, 0x0003e8000b901c48ULL, 0x000000001c457faeULL, 0x0003e8000b901c48ULL,
0x0000000018477faeULL, 0x0003e8000b901c48ULL, 0x000000000c497faeULL, 0x0003e8000b901c48ULL,
0x000000000e4b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000408087810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x0000006f0800720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x00000002740c7824ULL, 0x002fe400078e0208ULL,
0x00000004ff0d7424ULL, 0x000fc800078e00ffULL, 0x000064000c0c7625ULL, 0x000fca00078e000dULL,
0x000000080c037981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff0c7224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff805007812ULL, 0x040fe200078ec0ffULL,
0x0000000202647824ULL, 0x000fe200078e0209ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000010c507810ULL, 0x000fe40007ffe0ffULL, 0x0000000700007812ULL, 0x000fe400078ef805ULL,
0x0000100064647811ULL, 0x000fe400078e60ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011600ULL,
0x00000004000f7824ULL, 0x040fe200078e00ffULL, 0x0000002005627810ULL, 0x000fe20007ffe0ffULL,
0x0000000400007824ULL, 0x000fc400078e00ffULL, 0x000000010d0e7824ULL, 0x040fe200078e020cULL,
0xfffffff862627812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x000fc600078e0250ULL,
0xfffffffc0f0f7812ULL, 0x000fe400078ee20eULL, 0xfffffffc000d7812ULL, 0x000fe400078ee20dULL,
0x0000000762627812ULL, 0x000fe200078ef805ULL, 0x000000100f0f7824ULL, 0x100fe400078e0264ULL,
0x000000100d0d7824ULL, 0x000fe200078e0264ULL, 0x00000001ff657819ULL, 0x000fe40000011662ULL,
0x000000000f44783bULL, 0x000e660000000200ULL, 0x0000000165007824ULL, 0x040fe200078e020cULL,
0x000000000d1c783bULL, 0x0205e20000000200ULL, 0x0000000165657824ULL, 0x000fc400078e0250ULL,
0x00000004620d7824ULL, 0x044fe400078e00ffULL, 0x0000000462627824ULL, 0x000fc600078e00ffULL,
0xfffffffc0d0d7812ULL, 0x000fca00078ee200ULL, 0x000000100d3c7824ULL, 0x000fcc00078e0264ULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x0000004400677306ULL, 0x002fe20000009400ULL,
0x00010000441a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011444ULL,
0x00000018ff637819ULL, 0x000fe40000011445ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000004400687306ULL, 0x000e620000005400ULL, 0x00000018ff597819ULL, 0x000fc40000011446ULL,
0x00000018ff407819ULL, 0x000fca0000011447ULL, 0x0000004600667306ULL, 0x000ff00000009400ULL,
0x0000004600497306ULL, 0x000ee20000005400ULL, 0x000000686700720bULL, 0x002fe40003fbd000ULL,
0x0000001a00677245ULL, 0x000fe2000020d400ULL, 0x000001003d6a7824ULL, 0x004fc800078e00ffULL,
0x0000004700437306ULL, 0x000fe20000009400ULL, 0x00000018ff6a7819ULL, 0x000fce000001146aULL,
0x00000047004a7306ULL, 0x000e620000005400ULL, 0x000000496600720bULL, 0x008fe20003f5d000ULL,
0x000000040b497824ULL, 0x000fe200078e020cULL, 0x0000000705667812ULL, 0x000fe400078ec0ffULL,
0x000000020c0c7810ULL, 0x000fc60007ffe0ffULL, 0x0000001a00617306ULL, 0x000ff00000209400ULL,
0x0000001a00687306ULL, 0x000ea20000205400ULL, 0x0000004a4300720bULL, 0x002fe20003f3d000ULL,
0x00000002494a7824ULL, 0x000fe200078e00ffULL, 0x0000000866497812ULL, 0x000fc800078ef805ULL,
0x0000004a05667211ULL, 0x000fe200078fe0ffULL, 0x00000045005f7306ULL, 0x000fe20000009400ULL,
0x0000001049437824ULL, 0x040fe200078e00ffULL, 0x000000024a4a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000149667824ULL, 0x000fe400078e0266ULL, 0x0000004a054a7211ULL, 0x000fe400078fe0ffULL,
0x00000045005e7306ULL, 0x000e620000005400ULL, 0x000000686100720bULL, 0x004fe20003f9d000ULL,
0x0001000045617824ULL, 0x000fe200078e00ffULL, 0xfffffff043667812ULL, 0x000fc800078ee266ULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000004e001b7306ULL, 0x000fe20000209400ULL,
0x00000010661a7824ULL, 0x000fe400078e00ffULL, 0x0000010045667824ULL, 0x000fc600078e00ffULL,
0x0000000167674812ULL, 0x000fe400078efcffULL, 0x0000004e00607306ULL, 0x000ea20000205400ULL,
0x0000005e5f00720bULL, 0x002fe40003f7d000ULL, 0x00000018ff667819ULL, 0x000fca0000011466ULL,
0x0000006300187306ULL, 0x000ff00000209400ULL, 0x0000006300197306ULL, 0x000e620000205400ULL,
0x000000601b00720bULL, 0x004fce0003fdd000ULL, 0x0000004400387306ULL, 0x0004e2000000d400ULL,
0x000000191800720bULL, 0x002fe20003f9d000ULL, 0x0000010044447824ULL, 0x004fe200078e00ffULL,
0x000000001a18783bULL, 0x000e6a0000000200ULL, 0x0000006100607306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000000138385812ULL, 0x008fca00078efcffULL,
0x00000044005f7306ULL, 0x000fe20000209400ULL, 0x000000386738723eULL, 0x000fe400000010ffULL,
0x0000006100677245ULL, 0x000fca000020d400ULL, 0x0000004400687306ULL, 0x0004f00000205400ULL,
0x0000006100697306ULL, 0x0006620000205400ULL, 0x0000004400447245ULL, 0x004fe4000020d400ULL,
0x000000685f00720bULL, 0x008fca0003fbd000ULL, 0x0000005900397306ULL, 0x000fe20000209400ULL,
0x0001000046617824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000005900547306ULL, 0x000ea20000205400ULL, 0x0000000144445812ULL, 0x000fe400078efcffULL,
0x000000696000720bULL, 0x002fe40003fbd000ULL, 0x0000004e00697245ULL, 0x000fc6000020d400ULL,
0x0000004500427306ULL, 0x000e62000000d400ULL, 0x0000000169696812ULL, 0x000fe400078efcffULL,
0x000000543900720bULL, 0x004fca0003fdd000ULL, 0x0000006600457306ULL, 0x000fe20000209400ULL,
0x000000446939723eULL, 0x000fe400000010ffULL, 0x0000000167675812ULL, 0x000fe400078efcffULL,
0xfffffffc62697812ULL, 0x000fe400078ee265ULL, 0x00000018ff547819ULL, 0x000fe2000001141cULL,
0x000000381830723cULL, 0x000be20000041830ULL, 0x0000006600687306ULL, 0x000ea20000205400ULL,
0x0000000142423812ULL, 0x002fe200078efcffULL, 0x0000001069647824ULL, 0x000fc800078e0264ULL,
0x0000010046387824ULL, 0x020fe200078e00ffULL, 0x0000006600397245ULL, 0x000fe2000020d400ULL,
0x0000004600587306ULL, 0x0002e2000000d400ULL, 0x000000684500720bULL, 0x004fce0003fbd000ULL,
0x0000006100507306ULL, 0x000fe20000209400ULL, 0x0000006300467245ULL, 0x002fe2000020d400ULL,
0x000100003d687824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe40000011438ULL,
0x000000426738723eULL, 0x000fe200000010ffULL, 0x0001000047427824ULL, 0x000fe200078e00ffULL,
0x0000000146464812ULL, 0x000fe200078efcffULL, 0x0000006300627306ULL, 0x000fe20000209400ULL,
0x0000000158582812ULL, 0x008fe400078efcffULL, 0x00000018ff427819ULL, 0x000fc40000011442ULL,
0x0000000139395812ULL, 0x000fe400078efcffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000006300677306ULL, 0x000e620000205400ULL, 0x000000394639723eULL, 0x000fce00000010ffULL,
0x0000006100657306ULL, 0x0004e20000205400ULL, 0x000000381834723cULL, 0x000bee0000041834ULL,
0x00000040003a7306ULL, 0x000fe20000209400ULL, 0x000000676200720bULL, 0x002fe20003f9d000ULL,
0x0000010047627824ULL, 0x000fe200078e00ffULL, 0x0000006100617245ULL, 0x004fc8000020d400ULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x00000040003b7306ULL, 0x0002a20000205400ULL,
0x000000655000720bULL, 0x008fe40003fbd000ULL, 0x00000018ff507819ULL, 0x000fca000001141dULL,
0x0000004200467306ULL, 0x000fe20000209400ULL, 0x0000004000407245ULL, 0x002fca000020d400ULL,
0x0000000161615812ULL, 0x000fe400078efcffULL, 0x0000004200697306ULL, 0x000e620000205400ULL,
0x0000003b3a00720bULL, 0x004fe40003f7d000ULL, 0x000000006438783bULL, 0x0204e20000000200ULL,
0x000000586158723eULL, 0x000fc800000010ffULL, 0x0000006200667306ULL, 0x000fe20000209400ULL,
0x0000005900647245ULL, 0x004fe4000020d400ULL, 0x0000006300597245ULL, 0x000fe4000020d400ULL,
0x0000000164646812ULL, 0x000fc600078efcffULL, 0x0000006200677306ULL, 0x000ea20000205400ULL,
0x0000000159594812ULL, 0x000fe400078efcffULL, 0x000000694600720bULL, 0x002fe40003f5d000ULL,
0x000000596459723eULL, 0x000fe400000010ffULL, 0x0000000140403812ULL, 0x000fe200078efcffULL,
0x00000047000f7306ULL, 0x000e62000000d400ULL, 0x00000018ff697819ULL, 0x000fe4000001143dULL,
0x00000018ff467819ULL, 0x000fe2000001141eULL, 0x000000581828723cULL, 0x000be20000041828ULL,
0x000000676600720bULL, 0x004fc60003f9d000ULL, 0x0000003c005d7306ULL, 0x000fe60000009400ULL,
0x0000004200587245ULL, 0x020fe4000020d400ULL, 0x0000006200597245ULL, 0x000fe4000020d400ULL,
0x0000000158582812ULL, 0x000fe400078efcffULL, 0x000000010f0f1812ULL, 0x002fe200078efcffULL,
0x0000003c00527306ULL, 0x000e620000005400ULL, 0x0000000159594812ULL, 0x000fc400078efcffULL,
0x0000000f5858723eULL, 0x000fe400000010ffULL, 0x000000594059723eULL, 0x000fc600000010ffULL,
0x0000001c005c7306ULL, 0x000fe80000009400ULL, 0x000000581810723cULL, 0x000b680000041810ULL,
0x0000001c00577306ULL, 0x000ea20000005400ULL, 0x000000525d00720bULL, 0x002fe40003f5d000ULL,
0x000100003c587824ULL, 0x020fca00078e00ffULL, 0x0000001d004f7306ULL, 0x000fe20000009400ULL,
0x00000018ff587819ULL, 0x000fce0000011458ULL, 0x0000001d005a7306ULL, 0x000e620000005400ULL,
0x000000575c00720bULL, 0x004fe20003f3d000ULL, 0x000001003c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fc8000001143cULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000005800597306ULL, 0x000ff00000209400ULL, 0x0000005800527306ULL, 0x000ea20000205400ULL,
0x0000005a4f00720bULL, 0x002fce0003fbd000ULL, 0x0000001e005b7306ULL, 0x000ff00000009400ULL,
0x0000001e00557306ULL, 0x000e620000005400ULL, 0x000000525900720bULL, 0x004fe40003f9d000ULL,
0x0000005800527245ULL, 0x000fe2000020d400ULL, 0x000100003e587824ULL, 0x000fc800078e00ffULL,
0x0000003d00567306ULL, 0x000fe20000009400ULL, 0x00000018ff587819ULL, 0x000fca0000011458ULL,
0x0000000152524812ULL, 0x000fe400078efcffULL, 0x0000003d00517306ULL, 0x000ea20000005400ULL,
0x000000555b00720bULL, 0x002fe20003f7d000ULL, 0x000100001c5b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000005c005d7306ULL, 0x000ff00000209400ULL,
0x0000005c005a7306ULL, 0x0002e20000205400ULL, 0x000000515600720bULL, 0x004fc40003fdd000ULL,
0x0000005c00517245ULL, 0x000fca000020d400ULL, 0x0000003c004b7306ULL, 0x000ea2000000d400ULL,
0x00000018ff5c7819ULL, 0x002fce000001141fULL, 0x00000057003c7306ULL, 0x000fe20000209400ULL,
0x0000005a5d00720bULL, 0x008fe40003f9d000ULL, 0x00000018ff5d7819ULL, 0x000fca000001143eULL,
0x0000005700557306ULL, 0x000e620000205400ULL, 0x000000014b4b2812ULL, 0x004fca00078efcffULL,
0x0000000151514812ULL, 0x000fe400078efcffULL, 0x0000006800567306ULL, 0x000ff00000209400ULL,
0x0000006800597306ULL, 0x0004e20000205400ULL, 0x000000553c00720bULL, 0x002fce0003f5d000ULL,
0x0000003e00537306ULL, 0x000fe20000009400ULL, 0x0000006800687245ULL, 0x004fce000020d400ULL,
0x0000003e005e7306ULL, 0x000fe20000005400ULL, 0x000000595600720bULL, 0x008fe20003f9d000ULL,
0x000001003e597824ULL, 0x000fca00078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000006a003c7306ULL, 0x000fec0000209400ULL, 0x0000000168684812ULL, 0x000fe400078efcffULL,
0x0000006a00557306ULL, 0x0002b00000205400ULL, 0x0000003d00487306ULL, 0x0006a2000000d400ULL,
0x0000006a006a7245ULL, 0x002fce000020d400ULL, 0x00000069004f7306ULL, 0x000fe20000209400ULL,
0x00000057003d7245ULL, 0x008fe2000020d400ULL, 0x000001003f577824ULL, 0x000fe200078e00ffULL,
0x000000553c00720bULL, 0x004fe40003f9d000ULL, 0x000000013d3d2812ULL, 0x000fe400078efcffULL,
0x0000005e5300720bULL, 0x000fe20003f5d000ULL, 0x0000006900567306ULL, 0x0002a20000205400ULL,
0x0000000148486812ULL, 0x000fe200078efcffULL, 0x000100003f5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fc40000011457ULL, 0x000000486848723eULL, 0x000fe400000010ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005800537306ULL, 0x000fe20000209400ULL,
0x000000016a6a4812ULL, 0x000fe400078efcffULL, 0x0000006900697245ULL, 0x002fca000020d400ULL,
0x00000058005a7306ULL, 0x0002e20000205400ULL, 0x000000564f00720bULL, 0x004fce0003fdd000ULL,
0x0000003e00437306ULL, 0x000ea2000000d400ULL, 0x0000005800587245ULL, 0x002fca000020d400ULL,
0x0000000169696812ULL, 0x000fe400078efcffULL, 0x0000005a5300720bULL, 0x008fe20003f9d000ULL,
0x0000005d003c7306ULL, 0x000fe20000209400ULL, 0x0000000143432812ULL, 0x004fce00078efcffULL,
0x00000059003e7306ULL, 0x000fe80000209400ULL, 0x0000000158584812ULL, 0x000fc800078efcffULL,
0x00000059004f7306ULL, 0x0002a20000205400ULL, 0x000000435858723eULL, 0x000fe200000010ffULL,
0x000001003a437824ULL, 0x000fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000005d00537306ULL, 0x0006e20000205400ULL, 0x0000005900597245ULL, 0x002fce000020d400ULL,
0x0000001f004c7306ULL, 0x000fe20000009400ULL, 0x0000004f3e00720bULL, 0x004fe40003f9d000ULL,
0x0000005d005d7245ULL, 0x008fca000020d400ULL, 0x0000001f004d7306ULL, 0x000e620000005400ULL,
0x000000533c00720bULL, 0x000fe20003f5d000ULL, 0x000001001c537824ULL, 0x000fc800078e00ffULL,
0x0000000159594812ULL, 0x000fe400078efcffULL, 0x0000005e00557306ULL, 0x000fe20000209400ULL,
0x00000018ff537819ULL, 0x000fca0000011453ULL, 0x000000015d5d2812ULL, 0x000fe400078efcffULL,
0x0000005e00567306ULL, 0x0004e20000205400ULL, 0x0000004d4c00720bULL, 0x002fe40003f5d000ULL,
0x000000595d59723eULL, 0x000fca00000010ffULL, 0x0000003f005f7306ULL, 0x000fe20000009400ULL,
0x0000005e005e7245ULL, 0x004fe2000020d400ULL, 0x00000058182c723cULL, 0x000bec000004182cULL,
0x0000003f00607306ULL, 0x000e620000005400ULL, 0x000000565500720bULL, 0x008fe20003f9d000ULL,
0x000001003b597824ULL, 0x020fca00078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000003f00447306ULL, 0x0004ec000000d400ULL, 0x000000015e5e4812ULL, 0x000fe400078efcffULL,
0x00000057003c7306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x004fc4000001143fULL,
0x000000605f00720bULL, 0x002fe40003fdd000ULL, 0x0000003f005a7245ULL, 0x000fc6000020d400ULL,
0x00000057004f7306ULL, 0x0002b00000205400ULL, 0x0000003f003e7306ULL, 0x000fe20000209400ULL,
0x0000000144446812ULL, 0x008fe400078efcffULL, 0x0000005700577245ULL, 0x002fca000020d400ULL,
0x0000003f004d7306ULL, 0x000e620000205400ULL, 0x0000004f3c00720bULL, 0x004fce0003f9d000ULL,
0x0000001c00417306ULL, 0x000eac000000d400ULL, 0x0000000157574812ULL, 0x000fe400078efcffULL,
0x00000053004f7306ULL, 0x000fe20000209400ULL, 0x0000004d3e00720bULL, 0x002fe20003fdd000ULL,
0x000100001d3e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000005300567306ULL, 0x0002e20000205400ULL, 0x0000000141411812ULL, 0x004fca00078efcffULL,
0x000000015a5a6812ULL, 0x000fe400078efcffULL, 0x0000005b00557306ULL, 0x000fe20000209400ULL,
0x0000005300537245ULL, 0x002fce000020d400ULL, 0x0000005b001c7306ULL, 0x0002a20000205400ULL,
0x000000564f00720bULL, 0x008fe20003fdd000ULL, 0x000001001d4f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000005400457306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x002fca000020d400ULL, 0x0000000153536812ULL, 0x000fe400078efcffULL,
0x00000054004e7306ULL, 0x0002e20000205400ULL, 0x0000001c5500720bULL, 0x004fe40003f9d000ULL,
0x00000018ff557819ULL, 0x000fca0000011438ULL, 0x0000003e003f7306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x002fca000020d400ULL, 0x000000015b5b4812ULL, 0x000fe400078efcffULL,
0x0000003e00567306ULL, 0x0002a20000205400ULL, 0x0000004e4500720bULL, 0x008fe20003f9d000ULL,
0x000001001e457824ULL, 0x000fe200078e00ffULL, 0x0000003e004e7245ULL, 0x000fc8000020d400ULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000001d000e7306ULL, 0x000ee2000000d400ULL,
0x00000018ff3e7819ULL, 0x002fca0000011439ULL, 0x0000000154544812ULL, 0x000fe400078efcffULL,
0x0000004f001c7306ULL, 0x000fe20000209400ULL, 0x000000563f00720bULL, 0x004fe20003fdd000ULL,
0x000100001e3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000004f001d7306ULL, 0x0002a20000205400ULL, 0x000000010e0e5812ULL, 0x008fca00078efcffULL,
0x000000014e4e6812ULL, 0x000fe400078efcffULL, 0x0000003f00567306ULL, 0x000fe20000209400ULL,
0x0000004f004f7245ULL, 0x002fe4000020d400ULL, 0x0000000e4e4e723eULL, 0x000fca00000010ffULL,
0x0000003f005f7306ULL, 0x0002e20000205400ULL, 0x0000001d1c00720bULL, 0x004fce0003f9d000ULL,
0x0000003800617306ULL, 0x000fe20000009400ULL, 0x0000003f003f7245ULL, 0x002fca000020d400ULL,
0x000000014f4f4812ULL, 0x000fe400078efcffULL, 0x0000003800647306ULL, 0x000e620000005400ULL,
0x0000005f5600720bULL, 0x008fce0003f9d000ULL, 0x0000004600477306ULL, 0x000fec0000209400ULL,
0x000000013f3f4812ULL, 0x000fe400078efcffULL, 0x0000004600637306ULL, 0x0004e20000205400ULL,
0x000000646100720bULL, 0x002fe20003fbd000ULL, 0x0001000038647824ULL, 0x000fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x00000045001c7306ULL, 0x000fe20000209400ULL,
0x0000004600467245ULL, 0x004fce000020d400ULL, 0x00000045001d7306ULL, 0x0002a20000205400ULL,
0x000000634700720bULL, 0x008fce0003fdd000ULL, 0x0000005000657306ULL, 0x000fe20000209400ULL,
0x0000004500457245ULL, 0x002fca000020d400ULL, 0x0000000146466812ULL, 0x000fe400078efcffULL,
0x00000050006b7306ULL, 0x0002e20000205400ULL, 0x0000001d1c00720bULL, 0x004fe40003f9d000ULL,
0x000000513d1d723eULL, 0x000fe400000010ffULL, 0x00000018ff3d7819ULL, 0x000fc6000001143bULL,
0x0000006400477306ULL, 0x000fe20000209400ULL, 0x0000005000507245ULL, 0x002fca000020d400ULL,
0x0000000145454812ULL, 0x000fe400078efcffULL, 0x00000064001c7306ULL, 0x000e620000205400ULL,
0x0000006b6500720bULL, 0x008fce0003f3d000ULL, 0x0000003900667306ULL, 0x000fec0000009400ULL,
0x0000000150501812ULL, 0x000fe400078efcffULL, 0x0000003900677306ULL, 0x000ea20000005400ULL,
0x0000001c4700720bULL, 0x002fe40003f9d000ULL, 0x0000004b521c723eULL, 0x000fc400000010ffULL,
0x00000064004b7245ULL, 0x000fe4000020d400ULL, 0x0000004f504f723eULL, 0x000fe200000010ffULL,
0x0000001e000d7306ULL, 0x0002e4000000d400ULL, 0x0000001c1820723cULL, 0x000be80000041820ULL,
0x000000014b4b4812ULL, 0x000fe400078efcffULL, 0x0000003a00627306ULL, 0x000fe20000009400ULL,
0x00000100381e7824ULL, 0x002fe200078e00ffULL, 0x000000676600720bULL, 0x004fe20003f3d000ULL,
0x000100001f1c7824ULL, 0x020fc600078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000003a006c7306ULL, 0x000e620000005400ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x000000010d0d3812ULL, 0x008fca00078efcffULL, 0x0000001e00667306ULL, 0x000ff00000209400ULL,
0x0000001e00677306ULL, 0x000ea20000205400ULL, 0x0000006c6200720bULL, 0x002fce0003f7d000ULL,
0x0000003b00607306ULL, 0x000ff00000009400ULL, 0x0000003b004c7306ULL, 0x000e620000005400ULL,
0x000000676600720bULL, 0x004fe20003fdd000ULL, 0x000001001f677824ULL, 0x000fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000003800427306ULL, 0x0004f0000000d400ULL,
0x0000005c004d7306ULL, 0x000fe20000209400ULL, 0x0000004c6000720bULL, 0x002fe20003f9d000ULL,
0x0001000039607824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x004fca000001143aULL,
0x0000005c00657306ULL, 0x0002a20000205400ULL, 0x0000000142425812ULL, 0x008fce00078efcffULL,
0x0000001c00627306ULL, 0x000fe20000209400ULL, 0x0000005c005c7245ULL, 0x002fce000020d400ULL,
0x0000001c006b7306ULL, 0x000e620000205400ULL, 0x000000654d00720bULL, 0x004fe40003fbd000ULL,
0x0000001e004d7245ULL, 0x000fe4000020d400ULL, 0x0000001c00657245ULL, 0x000fe4000020d400ULL,
0x000000014d4d6812ULL, 0x000fe200078efcffULL, 0x0000001f00007306ULL, 0x0004ec000000d400ULL,
0x000000015c5c5812ULL, 0x000fc400078efcffULL, 0x00000067001d7306ULL, 0x000fe20000209400ULL,
0x00000001491f7824ULL, 0x044fe200078e024aULL, 0x00000018ff4a7819ULL, 0x000fe20000011460ULL,
0x0000001049607824ULL, 0x000fe200078e00ffULL, 0x0000006b6200720bULL, 0x002fe40003fdd000ULL,
0x0000006a6949723eULL, 0x000fe400000010ffULL, 0x00000067001e7306ULL, 0x0002a20000205400ULL,
0xfffffff0601f7812ULL, 0x000fe200078ee21fULL, 0x000100003a607824ULL, 0x000fe200078e00ffULL,
0x0000000100002812ULL, 0x008fc400078efcffULL, 0x000000481824723cULL, 0x000b620000041824ULL,
0x000000101f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000005500617306ULL, 0x000fe20000209400ULL, 0x0000000165656812ULL, 0x000fe400078efcffULL,
0x0000006700677245ULL, 0x002fe4000020d400ULL, 0x000000445e48723eULL, 0x020fe200000010ffULL,
0x000100003b447824ULL, 0x000fe200078e00ffULL, 0x000000575a49723eULL, 0x000fe200000010ffULL,
0x0000005500637306ULL, 0x000e620000205400ULL, 0x0000001e1d00720bULL, 0x004fc40003fdd000ULL,
0x000000001f1c783bULL, 0x000ea20000000200ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x000000481814723cULL, 0x000b640000041814ULL, 0x0000003900407306ULL, 0x00066a000000d400ULL,
0x000000006518723eULL, 0x020fc400000010ffULL, 0x0000000167676812ULL, 0x000fe200078efcffULL,
0x0000006000647306ULL, 0x000fe20000209400ULL, 0x0000010039397824ULL, 0x008fe200078e00ffULL,
0x000000636100720bULL, 0x002fe40003f5d000ULL, 0x000000675c19723eULL, 0x000fe400000010ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000006000687306ULL, 0x0002e20000205400ULL,
0x00000055001a7245ULL, 0x000fc4000020d400ULL, 0x0000000140401812ULL, 0x000fe400078efcffULL,
0x0000004a001b7245ULL, 0x000fe4000020d400ULL, 0x000000011a1a2812ULL, 0x000fe200078efcffULL,
0x0000003e00567306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x002fe4000020d400ULL,
0x0000004300617245ULL, 0x000fe4000020d400ULL, 0x0000004d1a4d723eULL, 0x000fc600000010ffULL,
0x0000003e005f7306ULL, 0x0002620000205400ULL, 0x000000686400720bULL, 0x008fe20003f3d000ULL,
0x000000181c10723cULL, 0x044b6c0000041810ULL, 0x0000004a006b7306ULL, 0x000fe20000209400ULL,
0x0000003e003e7245ULL, 0x002fe4000020d400ULL, 0x0000000d3f18723eULL, 0x020fe200000010ffULL,
0x0000004e1c34723cULL, 0x000f620000041834ULL, 0x000000454619723eULL, 0x000fc400000010ffULL,
0x0000000160601812ULL, 0x000fe200078efcffULL, 0x0000004a006c7306ULL, 0x000e620000205400ULL,
0x0000005f5600720bULL, 0x000fc60003fbd000ULL, 0x000000181c28723cULL, 0x000f680000041828ULL,
0x0000003900627306ULL, 0x000fec0000209400ULL, 0x000000013e3e5812ULL, 0x000fc400078efcffULL,
0x0000003900667306ULL, 0x000ea20000205400ULL, 0x0000006c6b00720bULL, 0x002fce0003fdd000ULL,
0x0000003a000f7306ULL, 0x0002ec000000d400ULL, 0x000000011b1b6812ULL, 0x000fe400078efcffULL,
0x0000003b003c7306ULL, 0x0006e2000000d400ULL, 0x000000415b3a723eULL, 0x002fe400000010ffULL,
0x000000666200720bULL, 0x004fc40003f5d000ULL, 0x0000003900417245ULL, 0x000fe4000020d400ULL,
0x000000401b40723eULL, 0x000fe200000010ffULL, 0x0000004400577306ULL, 0x000fe20000209400ULL,
0x00000053543b723eULL, 0x008fe400000010ffULL, 0x000000010f0f3812ULL, 0x000fc800078efcffULL,
0x0000000f6060723eULL, 0x000fe200000010ffULL, 0x0000004400007306ULL, 0x000e620000205400ULL,
0x0000003a1c30723cULL, 0x040b620000041830ULL, 0x0000000141412812ULL, 0x000fe400078efcffULL,
0x000000013c3c4812ULL, 0x000fe400078efcffULL, 0x000000413e41723eULL, 0x000fe400000010ffULL,
0x0000003800517306ULL, 0x000fea0000209400ULL, 0x000000401c24723cULL, 0x000b660000041824ULL,
0x0000003800527306ULL, 0x0004e20000205400ULL, 0x000000005700720bULL, 0x002fc40003f3d000ULL,
0x0000003d00007245ULL, 0x000fca000020d400ULL, 0x0000003d00477306ULL, 0x000fe20000209400ULL,
0x0000003800387245ULL, 0x004fce000020d400ULL, 0x0000003d004c7306ULL, 0x0002a20000205400ULL,
0x000000525100720bULL, 0x008fce0003fdd000ULL, 0x00000043005d7306ULL, 0x000fe20000209400ULL,
0x00000059003d7245ULL, 0x002fca000020d400ULL, 0x0000000138386812ULL, 0x000fe400078efcffULL,
0x0000004300587306ULL, 0x000e620000205400ULL, 0x0000004c4700720bULL, 0x004fe40003f5d000ULL,
0x000000424b4c723eULL, 0x000fca00000010ffULL, 0x00000059003a7306ULL, 0x020fe40000209400ULL,
0x0000004c1c20723cULL, 0x000b680000041820ULL, 0x0000000100002812ULL, 0x000fe400078efcffULL,
0x00000059000d7306ULL, 0x000ea20000205400ULL, 0x000000585d00720bULL, 0x002fda0003fbd000ULL,
0x0000000161615812ULL, 0x000fe400078efcffULL, 0x0000000d3a00720bULL, 0x004fe40003f7d000ULL,
0x00000044000d7245ULL, 0x000fe4000020d400ULL, 0x000000613861723eULL, 0x000fe400000010ffULL,
0x000000010d0d1812ULL, 0x000fe400078efcffULL, 0x000000040c00780cULL, 0x000fc40003f25270ULL,
0x0000003c0d3c723eULL, 0x000fe200000010ffULL, 0x000000601c2c723cULL, 0x000b64000004182cULL,
0x000000013d3d3812ULL, 0x000fc800078efcffULL, 0x0000003d003d723eULL, 0x000fce00000010ffULL,
0x0000003c1c14723cULL, 0x000b620000041814ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe0c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff097224ULL, 0x000fe200078e0007ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd37000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000006d31317220ULL, 0x080fe20000410000ULL, 0x0000006d35357220ULL, 0x080fe20000410000ULL,
0x0000006d34347220ULL, 0x080fe20000410000ULL, 0x0000006d28007220ULL, 0x080fe20000410000ULL,
0x0000006d11117220ULL, 0x080fe20000410000ULL, 0x0000006d24247220ULL, 0x080fe20000410000ULL,
0x0000006d2c097220ULL, 0x0a0fe20000410000ULL, 0x0000006d2a0a7220ULL, 0x080fe20000410000ULL,
0x0000006d270f7220ULL, 0x080fe20000410000ULL, 0x0000006d331a7220ULL, 0x080fe20000410000ULL,
0x0000006d102a7220ULL, 0x080fe20000410000ULL, 0x000000ffff277224ULL, 0x000fe200078e0031ULL,
0x0000006d301b7220ULL, 0x080fe20000410000ULL, 0x0000006d2b0b7220ULL, 0x080fe20000410000ULL,
0x0000006d20337220ULL, 0x080fe20000410000ULL, 0x0000006d260e7220ULL, 0x080fe20000410000ULL,
0x0000006d2e107220ULL, 0x080fe20000410000ULL, 0x0000006d2f1c7220ULL, 0x080fe20000410000ULL,
0x000000ffff317224ULL, 0x000fe200078e0035ULL, 0x0000006d32327220ULL, 0x080fe20000410000ULL,
0x0000006d36367220ULL, 0x080fe20000410000ULL, 0x0000006d37377220ULL, 0x080fe20000410000ULL,
0x0000006d29297220ULL, 0x080fe20000410000ULL, 0x0000006d12127220ULL, 0x080fe20000410000ULL,
0x0000006d13137220ULL, 0x080fe20000410000ULL, 0x0000006d212b7220ULL, 0x080fe20000410000ULL,
0x0000006d22197220ULL, 0x080fe20000410000ULL, 0x0000006d23187220ULL, 0x080fe20000410000ULL,
0x0000006d25307220ULL, 0x080fe20000410000ULL, 0x0000006d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000006d14267220ULL, 0x080fe20000410000ULL, 0x0000006d15207220ULL, 0x080fe20000410000ULL,
0x0000006d161d7220ULL, 0x080fe20000410000ULL, 0x0000006d171e7220ULL, 0x000fe20000410000ULL,
0x000000ffff287224ULL, 0x000fc400078e0034ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0000ULL,
0x000000ffff357224ULL, 0x000fe400078e0011ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0024ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000780c7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff227224ULL, 0x000fe400078e0032ULL,
0x000000ffff217224ULL, 0x000fc400078e0036ULL, 0x000000ffff327224ULL, 0x000fe400078e0037ULL,
0x000000ffff247224ULL, 0x000fe400078e000aULL, 0x000000ffff237224ULL, 0x000fe400078e000bULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff347224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x000fc400078e000eULL, 0x000000ffff177224ULL, 0x000fe400078e000fULL,
0x000000ffff097224ULL, 0x000fc400078e0010ULL, 0x00000000000a7805ULL, 0x002fca0000015200ULL,
0x00000400780f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x006fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0a117210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0bULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140fULL,
0x0000001100007211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x0000000200007819ULL, 0x000fc8000000120fULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400780f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004051f7824ULL, 0x000fe200078e00ffULL, 0x000000760600720cULL, 0x000fc80003f06070ULL,
0xfffffff01f0b7812ULL, 0x000fca00078ec0ffULL, 0x0000008002007824ULL, 0x000fca00078e020bULL,
0x00f40000000c7984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0x00000100060b7824ULL, 0x000fe200078e0279ULL, 0x00000073050a7211ULL, 0x040fe200078ff0ffULL,
0x0000000205377824ULL, 0x000fe400078e00ffULL, 0x00000002ff4c7424ULL, 0x000fe200078e00ffULL,
0x0000000b6e367217ULL, 0x000fe40007800000ULL, 0x0000000637377812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff107a19ULL, 0x000fe2000001160aULL, 0x0000000136367824ULL, 0x000fe200078e0a0bULL,
0x0000580037397a10ULL, 0x000fe20007ffe0ffULL, 0x00000001710b7824ULL, 0x000fe200078e0237ULL,
0x0000001077537217ULL, 0x000fc40003800000ULL, 0x000000363900720cULL, 0x080fe20003f06070ULL,
0x000000010b147824ULL, 0x140fe200078e0a36ULL, 0x000000360b00720cULL, 0x000fe20003f26070ULL,
0x0000000139127824ULL, 0x000fe400078e0a36ULL, 0x0000005372537224ULL, 0x000fe200078e02ffULL,
0x0000001477147217ULL, 0x040fe40003800000ULL, 0x0000001277127217ULL, 0x000fe40003800000ULL,
0x00000004ff147819ULL, 0x000fc40000011614ULL, 0x000000ff12447207ULL, 0x000fe40000000000ULL,
0x000000ff14147207ULL, 0x000fe40000800000ULL, 0x00000053440b7211ULL, 0x000fe400078fe0ffULL,
0x000000080a127810ULL, 0x000fe20007ffe0ffULL, 0x0000000153117824ULL, 0x000fe200078e0214ULL,
0x00000010373f7812ULL, 0x000fe200078efcffULL, 0x000060000b0a7625ULL, 0x000fe200078e004cULL,
0x00005a00ff127a19ULL, 0x000fc60000011612ULL, 0x0000600011107625ULL, 0x000fe200078e004cULL,
0x000058003f3b7a10ULL, 0x000fe20007ffe0ffULL, 0x000000080a4a7981ULL, 0x0046a2000c1e9500ULL,
0x0000001277557217ULL, 0x000fc60003800000ULL, 0x0000000810517981ULL, 0x0002a2000c1e9500ULL,
0x00000020373d7812ULL, 0x000fe200078efcffULL, 0x0000005572557224ULL, 0x000fe400078e02ffULL,
0x000000013b0a7824ULL, 0x108fe400078e0a36ULL, 0x00000001710b7824ULL, 0x000fe200078e023fULL,
0x000000363b00720cULL, 0x000fe20003f06070ULL, 0x0000000114157824ULL, 0x000fe200078e0255ULL,
0x0000000a770a7217ULL, 0x000fe20003800000ULL, 0x000000010b107824ULL, 0x002fe200078e0a36ULL,
0x000058003d437a10ULL, 0x000fe20007ffe0ffULL, 0x0000600015147625ULL, 0x000fe200078e004cULL,
0x0000005544137211ULL, 0x000fc400078fe0ffULL, 0x000000ff0a387207ULL, 0x000fe20000000000ULL,
0x00000001433e7824ULL, 0x000fe200078e0a36ULL, 0x0000001077107217ULL, 0x000fe20003800000ULL,
0x0000600013127625ULL, 0x000fe200078e004cULL, 0x000000360b00720cULL, 0x080fe20003f26070ULL,
0x00000008144f7981ULL, 0x0002e2000c1e9500ULL, 0x00000053380b7211ULL, 0x000fe200078fe0ffULL,
0x0000000171477824ULL, 0x000fe200078e023dULL, 0x00000004ff107819ULL, 0x000fe20000011610ULL,
0x0000000812467981ULL, 0x0002e2000c1e9500ULL, 0x000000364300720cULL, 0x000fc40003f06070ULL,
0x0000003e773e7217ULL, 0x000fe20003800000ULL, 0x000060000b0a7625ULL, 0x000fc600078e004cULL,
0x000000ff3e3e7207ULL, 0x000fe20000000000ULL, 0x0000000147407824ULL, 0x040fe200078e0a36ULL,
0x000000080a3a7981ULL, 0x0002e4000c1e9500ULL, 0x000000ff10127207ULL, 0x002fe40000800000ULL,
0x000000364700720cULL, 0x000fe40003f26070ULL, 0x0000003037477812ULL, 0x000fe200078efcffULL,
0x0000000153117824ULL, 0x000fe200078e0212ULL, 0x0000005538137211ULL, 0x000fe200078fe0ffULL,
0x0000000112157824ULL, 0x000fe200078e0255ULL, 0x0000004077407217ULL, 0x000fc40003800000ULL,
0x000000533e0b7211ULL, 0x000fe200078fe0ffULL, 0x0000000171577824ULL, 0x000fe200078e0247ULL,
0x00000004ff407819ULL, 0x000fe20000011640ULL, 0x0000600011107625ULL, 0x000fe200078e004cULL,
0x0000580047497a10ULL, 0x000fc60007ffe0ffULL, 0x0000600013127625ULL, 0x000fc800078e004cULL,
0x0000600015147625ULL, 0x080fe200078e004cULL, 0x000000ff40427207ULL, 0x000fe20000800000ULL,
0x0000000810417981ULL, 0x0002e4000c1e9500ULL, 0x000060000b0a7625ULL, 0x000fe400078e004cULL,
0x00000008123c7981ULL, 0x0002e4000c1e9500ULL, 0x0000000157487824ULL, 0x000fe400078e0a36ULL,
0x0000000814457981ULL, 0x0002e8000c1e9500ULL, 0x000000080a407981ULL, 0x0002e2000c1e9500ULL,
0x0000004877487217ULL, 0x000fe20003800000ULL, 0x0000000153117824ULL, 0x002fe200078e0242ULL,
0x000000553e137211ULL, 0x000fe200078fe0ffULL, 0x0000000142157824ULL, 0x000fc400078e0255ULL,
0x00000001490a7824ULL, 0x040fe200078e0a36ULL, 0x000000364900720cULL, 0x000fe20003f06070ULL,
0x0000600011107625ULL, 0x000fe200078e004cULL, 0x000000365700720cULL, 0x000fe40003f26070ULL,
0x0000000a770a7217ULL, 0x000fe20003800000ULL, 0x0000600013127625ULL, 0x080fe200078e004cULL,
0x00000004ff0b7819ULL, 0x000fe20000011648ULL, 0x00000008104b7981ULL, 0x0002e4000c1e9500ULL,
0x0000600015147625ULL, 0x000fe200078e004cULL, 0x000000ff0a487207ULL, 0x000fe20000000000ULL,
0x0000000812427981ULL, 0x0002e2000c1e9500ULL, 0x000000ff0b4e7207ULL, 0x000fc60000800000ULL,
0x00000008144d7981ULL, 0x0002e2000c1e9500ULL, 0x00000053480b7211ULL, 0x000fe200078fe0ffULL,
0x0000000153117824ULL, 0x002fc800078e024eULL, 0x000060000b0a7625ULL, 0x000fc800078e004cULL,
0x0000600011107625ULL, 0x000fe400078e004cULL, 0x000000080a0a7981ULL, 0x0002e2000c1e9500ULL,
0x0000005548137211ULL, 0x000fc600078fe0ffULL, 0x0000000810117981ULL, 0x0002e2000c1e9500ULL,
0x000000014e157824ULL, 0x000fe400078e0255ULL, 0x0000600013127625ULL, 0x000fc800078e004cULL,
0x0000600015147625ULL, 0x000fe400078e004cULL, 0x0000000812127981ULL, 0x0002e8000c1e9500ULL,
0x0000000814157981ULL, 0x0002e2000c1e9500ULL, 0xfffffff044537812ULL, 0x000fe200078ec0ffULL,
0x00000001ff447424ULL, 0x000fe200078e00ffULL, 0x00000001370b7812ULL, 0x002fc600078efcffULL,
0x00000001364c7824ULL, 0x000fe200078e0253ULL, 0x0000000937557812ULL, 0x000fc600078efcffULL,
0x0000000139597824ULL, 0x100fe200078e0a4cULL, 0x000058000b577a10ULL, 0x000fe40007ffe0ffULL,
0x0000580055137a10ULL, 0x000fe40007ffe0ffULL, 0x0000005944597219ULL, 0x000fe200000006ffULL,
0x00000001575b7824ULL, 0x100fe400078e0a4cULL, 0x00000001135f7824ULL, 0x000fc600078e0a4cULL,
0x0000005b445b7219ULL, 0x040fe400000006ffULL, 0x0000005f445f7219ULL, 0x000fe400000006ffULL,
0x00000011377d7812ULL, 0x040fe400078efcffULL, 0x00000018377b7812ULL, 0x040fe400078efcffULL,
0x00000019376b7812ULL, 0x000fe400078efcffULL, 0x000058007b147a10ULL, 0x000fc40007ffe0ffULL,
0x000058006b107a10ULL, 0x000fe40007ffe0ffULL, 0x0000002137637812ULL, 0x040fe400078efcffULL,
0x0000002837617812ULL, 0x000fe400078efcffULL, 0xfffffff048487812ULL, 0x000fe400078ec0ffULL,
0x0000580063697a10ULL, 0x000fe40007ffe0ffULL, 0x0000580061677a10ULL, 0x000fe20007ffe0ffULL,
0x00000001364e7824ULL, 0x000fc800078e0248ULL, 0x0000000149507824ULL, 0x000fca00078e0a4eULL,
0x0000005044507219ULL, 0x000fe400000006ffULL, 0x000054104a4a7816ULL, 0x004fe40000000051ULL,
0x0000000837517812ULL, 0x000fc800078efcffULL, 0x0000580051537a10ULL, 0x000fe40007ffe0ffULL,
0x0000004a59ff7212ULL, 0x000fc6000780c0ffULL, 0x00000001535d7824ULL, 0x000fe200078e0a4cULL,
0x000000363900720cULL, 0x000fc80000701470ULL, 0x0000005d445d7219ULL, 0x000fe400000006ffULL,
0x0000004a5bff7212ULL, 0x080fe4000786c0ffULL, 0x0000004a5dff7212ULL, 0x080fe4000784c0ffULL,
0x0000004a5fff7212ULL, 0x000fe4000782c0ffULL, 0x000000363700720cULL, 0x000fe40000701070ULL,
0x0000541046467816ULL, 0x008fc4000000004fULL, 0xfffffff0384a7812ULL, 0x000fe400078ec0ffULL,
0xff8000001b1b7808ULL, 0x000fe40000000000ULL, 0x0000004659ff7212ULL, 0x080fe2000788c0ffULL,
0x00000001364a7824ULL, 0x000fe200078e024aULL, 0x000000465bff7212ULL, 0x080fe400078ac0ffULL,
0x000000465dff7212ULL, 0x080fe400078cc0ffULL, 0x000000465fff7212ULL, 0x000fc4000780c0ffULL,
0x000058007d467a10ULL, 0x000fe20007ffe0ffULL, 0x000000013b527824ULL, 0x100fe200078e0a4aULL,
0x000000363900720cULL, 0x080fe20002781470ULL, 0x0000000114567824ULL, 0x100fe200078e0a4aULL,
0x000000365300720cULL, 0x080fe200037c1470ULL, 0x0000000146547824ULL, 0x100fe200078e0a4aULL,
0x000000361300720cULL, 0x000fe20000701470ULL, 0x0000000110587824ULL, 0x000fe200078e0a4aULL,
0x00000052444a7219ULL, 0x000fe400000006ffULL, 0xfffffff03e4c7812ULL, 0x000fc400078ec0ffULL,
0x0000005444527219ULL, 0x040fe400000006ffULL, 0x000000363700720cULL, 0x080fe40002781070ULL,
0x000000365100720cULL, 0x080fe400037c1070ULL, 0x000000365500720cULL, 0x000fe40000701070ULL,
0x0000005644547219ULL, 0x000fe400000006ffULL, 0x000054103a417816ULL, 0x000fe20000000041ULL,
0x00000001364c7824ULL, 0x000fe200078e024cULL, 0x000000361300720cULL, 0x000fc40000f21470ULL,
0x000054103c457816ULL, 0x000fe40000000045ULL, 0xff80000022227808ULL, 0x000fe40002000000ULL,
0xff80000021217808ULL, 0x000fe40003000000ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0x000000414aff7212ULL, 0x040fe4000788c0ffULL, 0x000000454aff7212ULL, 0x000fc400078cc0ffULL,
0x0000004554ff7212ULL, 0x000fe2000780c0ffULL, 0x00000001435a7824ULL, 0x000fe200078e0a4cULL,
0x000000365500720cULL, 0x080fe40000f21070ULL, 0x000000365700720cULL, 0x0c0fe40001f61470ULL,
0x000000365700720cULL, 0x080fe40002fa1470ULL, 0x000000365300720cULL, 0x080fe40001741470ULL,
0x000000363b00720cULL, 0x000fc40002781470ULL, 0x000000363b00720cULL, 0x080fe400037c1470ULL,
0x000000361400720cULL, 0x080fe40000701470ULL, 0xff80000031317808ULL, 0x000fe40000800000ULL,
0x00000029375f7812ULL, 0x000fe400078efcffULL, 0x000000360b00720cULL, 0x0c0fe40001f61070ULL,
0x000000360b00720cULL, 0x000fc40002fa1070ULL, 0x000000365100720cULL, 0x080fe40001741070ULL,
0x000000363f00720cULL, 0x0c0fe40002721070ULL, 0x000000363f00720cULL, 0x080fe400037c1070ULL,
0x000000367b00720cULL, 0x000fe40000701070ULL, 0x0000005844587219ULL, 0x040fe400000006ffULL,
0x0000005a44567219ULL, 0x000fc400000006ffULL, 0x00005410404b7816ULL, 0x000fe4000000004bULL,
0x00005410424d7816ULL, 0x000fe4000000004dULL, 0x000058005f657a10ULL, 0x000fe40007ffe0ffULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff8000001a1a7808ULL, 0x000fe40002800000ULL,
0xff80000028287808ULL, 0x000fc40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff80000024247808ULL, 0x000fe40003000000ULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0x0000004152ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004154ff7212ULL, 0x080fe400078ac0ffULL,
0x0000004158ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004552ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004558ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004b56ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004d56ff7212ULL, 0x000fe2000780c0ffULL, 0x00000001695c7824ULL, 0x100fe200078e0a4cULL,
0x000000364600720cULL, 0x0c0fe20001f61470ULL, 0x00000001675e7824ULL, 0x100fe200078e0a4cULL,
0x000000364600720cULL, 0x080fe20002781470ULL, 0x0000000165607824ULL, 0x000fe200078e0a4cULL,
0x000000361400720cULL, 0x000fc40002fa1470ULL, 0x000000361000720cULL, 0x0c0fe40001741470ULL,
0x000000361000720cULL, 0x080fe40000f21470ULL, 0x000000364300720cULL, 0x0c0fe400037c1470ULL,
0x000000364300720cULL, 0x000fe40000701470ULL, 0x00000031375b7812ULL, 0x040fe400078efcffULL,
0x0000003837597812ULL, 0x000fc400078efcffULL, 0x00000039374f7812ULL, 0x000fe400078efcffULL,
0x0000005c445a7219ULL, 0x000fe400000006ffULL, 0x000000367d00720cULL, 0x0c0fe40001f61070ULL,
0x000000367d00720cULL, 0x080fe40002781070ULL, 0x000000367b00720cULL, 0x080fe40002fa1070ULL,
0x000000366b00720cULL, 0x000fc40001741070ULL, 0x000000366b00720cULL, 0x080fe40000f21070ULL,
0x000000363d00720cULL, 0x0c0fe400037c1070ULL, 0x000000363d00720cULL, 0x000fe40000701070ULL,
0x0000005e445c7219ULL, 0x040fe400000006ffULL, 0x0000006044607219ULL, 0x000fe400000006ffULL,
0x000054100a117816ULL, 0x000fc40000000011ULL, 0x000058005b5d7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580059387a10ULL, 0x000fe40007ffe0ffULL, 0x000058004f3e7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff8000002a2a7808ULL, 0x000fc40002800000ULL, 0xff80000035357808ULL, 0x000fe40001000000ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000033337808ULL, 0x000fe40003000000ULL,
0xff80000019197808ULL, 0x000fe40000000000ULL, 0x0000004b5aff7212ULL, 0x080fe4000786c0ffULL,
0x0000004b5cff7212ULL, 0x000fc4000788c0ffULL, 0x0000004b60ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004d5aff7212ULL, 0x080fe4000784c0ffULL, 0x0000004d5cff7212ULL, 0x080fe4000782c0ffULL,
0x0000004d60ff7212ULL, 0x000fe400078cc0ffULL, 0x0000001150ff7212ULL, 0x000fe2000780c0ffULL,
0x000000015d4c7824ULL, 0x100fe200078e0a4eULL, 0x000000366900720cULL, 0x0c0fe20001f61470ULL,
0x0000000138487824ULL, 0x100fe200078e0a4eULL, 0x000000366900720cULL, 0x080fe20001741470ULL,
0x000000013e4e7824ULL, 0x000fe200078e0a4eULL, 0x000000366700720cULL, 0x000fc40002781470ULL,
0x000000366700720cULL, 0x080fe40000f21470ULL, 0x000000366500720cULL, 0x0c0fe40002fa1470ULL,
0x000000366500720cULL, 0x080fe400037c1470ULL, 0x000000364900720cULL, 0x080fe40000701470ULL,
0x000000366300720cULL, 0x0c0fe40001f61070ULL, 0x000000366300720cULL, 0x000fc40001741070ULL,
0x000000366100720cULL, 0x0c0fe40002781070ULL, 0x000000366100720cULL, 0x080fe40000f21070ULL,
0x000000365f00720cULL, 0x0c0fe40002fa1070ULL, 0x000000365f00720cULL, 0x080fe400037c1070ULL,
0x000000364700720cULL, 0x000fe40000701070ULL, 0x0000004c444c7219ULL, 0x000fc400000006ffULL,
0x0000004844487219ULL, 0x040fe400000006ffULL, 0x0000004e444e7219ULL, 0x000fe400000006ffULL,
0x0000541012157816ULL, 0x000fe40000000015ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000018187808ULL, 0x000fe40001000000ULL, 0xff8000002c2c7808ULL, 0x000fc40002000000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff80000030307808ULL, 0x000fe40002800000ULL,
0xff80000017177808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0x000000114cff7212ULL, 0x080fe4000786c0ffULL, 0x0000001148ff7212ULL, 0x000fc4000784c0ffULL,
0x000000114eff7212ULL, 0x000fe4000788c0ffULL, 0x0000001550ff7212ULL, 0x080fe4000782c0ffULL,
0x000000154cff7212ULL, 0x080fe400078ac0ffULL, 0x0000001548ff7212ULL, 0x080fe400078cc0ffULL,
0x000000154eff7212ULL, 0x000fe4000780c0ffULL, 0x000000364900720cULL, 0x000fc40000f21470ULL,
0x000000365d00720cULL, 0x0c0fe40001f61470ULL, 0x000000365d00720cULL, 0x080fe40002fa1470ULL,
0x000000363800720cULL, 0x0c0fe40001741470ULL, 0x000000363800720cULL, 0x080fe400037c1470ULL,
0x000000363e00720cULL, 0x0c0fe40002781470ULL, 0x000000363e00720cULL, 0x000fc40000701470ULL,
0x000000364700720cULL, 0x080fe40000f21070ULL, 0x000000365b00720cULL, 0x0c0fe40001f61070ULL,
0x000000365b00720cULL, 0x080fe40002fa1070ULL, 0x000000365900720cULL, 0x0c0fe40001741070ULL,
0x000000365900720cULL, 0x080fe400037c1070ULL, 0x000000364f00720cULL, 0x000fc40002781070ULL,
0x000000364f00720cULL, 0x000fe40000701070ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fe40002000000ULL,
0xff80000009097808ULL, 0x000fe40000800000ULL, 0xff8000001c1c7808ULL, 0x000fc40002800000ULL,
0xff8000001d1d7808ULL, 0x000fe40003000000ULL, 0xff8000001e1e7808ULL, 0x000fc40000000000ULL,
0x0000001b0c00720bULL, 0x004fe20003f1e000ULL, 0x0000001fff157424ULL, 0x000fe200078e00ffULL,
0x000000220d00720bULL, 0x000fe20003f3e000ULL, 0xffffffffff387424ULL, 0x000fe200078e00ffULL,
0x0000000c1b0c7208ULL, 0x000fe40004000000ULL, 0x0000000d220d7208ULL, 0x000fe40004800000ULL,
0x000000270c00720bULL, 0x000fc40003f1e000ULL, 0x0000001a0d00720bULL, 0x000fe40003f3e000ULL,
0x0000000c270b7208ULL, 0x000fe40004000000ULL, 0x0000000d1a0a7208ULL, 0x000fe40004800000ULL,
0x000000280b00720bULL, 0x000fe40003f1e000ULL, 0x000000210a00720bULL, 0x000fe40003f3e000ULL,
0x0000000b280c7208ULL, 0x000fc40004000000ULL, 0x0000000a210b7208ULL, 0x000fe40004800000ULL,
0x000000310c00720bULL, 0x000fe40003f1e000ULL, 0x000000320b00720bULL, 0x000fe40003f3e000ULL,
0x0000000c310d7208ULL, 0x000fe40004000000ULL, 0x0000000b320b7208ULL, 0x000fe40004800000ULL,
0x0000002e0d00720bULL, 0x000fc40003f1e000ULL, 0x000000240b00720bULL, 0x000fe40003f3e000ULL,
0x0000000d2e0a7208ULL, 0x000fe40004000000ULL, 0x0000000b240c7208ULL, 0x000fe40004800000ULL,
0x000000290a00720bULL, 0x000fe40003f1e000ULL, 0x000000230c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a290b7208ULL, 0x000fc40004000000ULL, 0x0000000c230c7208ULL, 0x000fe40004800000ULL,
0x0000002a0b00720bULL, 0x000fe40003f1e000ULL, 0x000000250c00720bULL, 0x000fe40003f3e000ULL,
0x0000000b2a0a7208ULL, 0x000fe40004000000ULL, 0x0000000c250b7208ULL, 0x000fe40004800000ULL,
0x000000350a00720bULL, 0x000fc40003f1e000ULL, 0x000000340b00720bULL, 0x000fe40003f3e000ULL,
0x0000000a350a7208ULL, 0x000fe40004000000ULL, 0x0000000b340c7208ULL, 0x000fe40004800000ULL,
0x000000330a00720bULL, 0x000fe40003f1e000ULL, 0x000000190c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a330a7208ULL, 0x000fc40004000000ULL, 0x0000000c190b7208ULL, 0x000fe40004800000ULL,
0x0000002b0a00720bULL, 0x000fe40003f1e000ULL, 0x000000180b00720bULL, 0x000fe40003f3e000ULL,
0x0000000a2b0d7208ULL, 0x000fe40004000000ULL, 0x0000000b180b7208ULL, 0x000fe40004800000ULL,
0x0000002c0d00720bULL, 0x000fc40003f1e000ULL, 0x000000160b00720bULL, 0x000fe40003f3e000ULL,
0x0000000d2c0d7208ULL, 0x000fe40004000000ULL, 0x0000000b160a7208ULL, 0x000fe40004800000ULL,
0x000000300d00720bULL, 0x000fe40003f1e000ULL, 0x000000170a00720bULL, 0x000fe40003f3e000ULL,
0x0000000d300c7208ULL, 0x000fc40004000000ULL, 0x0000000a170a7208ULL, 0x000fe40004800000ULL,
0x0000002f0c00720bULL, 0x000fe40003f1e000ULL, 0x000000090a00720bULL, 0x000fe40003f3e000ULL,
0x0000000c2f0c7208ULL, 0x000fe40004000000ULL, 0x0000000a090b7208ULL, 0x000fe40004800000ULL,
0x0000002d0c00720bULL, 0x000fc40003f1e000ULL, 0x0000001c0b00720bULL, 0x000fe40003f3e000ULL,
0x0000000c2d0d7208ULL, 0x000fe40004000000ULL, 0x0000000b1c0a7208ULL, 0x000fe40004800000ULL,
0x000000260d00720bULL, 0x000fe40003f1e000ULL, 0x0000001d0a00720bULL, 0x000fe40003f3e000ULL,
0x0000000d260d7208ULL, 0x000fc40004000000ULL, 0x0000000a1d0b7208ULL, 0x000fe40004800000ULL,
0x000000200d00720bULL, 0x000fe40003f1e000ULL, 0x0000001e0b00720bULL, 0x000fe40003f3e000ULL,
0x0000000d20127208ULL, 0x000fe40004000000ULL, 0x0000000b1e147208ULL, 0x000fe20004800000ULL,
0x000014727f007947ULL, 0x000fec000b800000ULL, 0x0c401f00120a7f89ULL, 0x0004e400000e0000ULL,
0x0000000a1200720bULL, 0x008fc80003f1e000ULL, 0x000000120a367208ULL, 0x000fe20004000000ULL,
0x000014827f007947ULL, 0x000fea000b800000ULL, 0x0c401f00140a7f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e0b7f89ULL, 0x000e6800000e0000ULL, 0x0c401f000f0c7f89ULL, 0x000ea800000e0000ULL,
0x0c201f00360d7f89ULL, 0x000ea200000e0000ULL, 0x0000000a1400720bULL, 0x008fc40003f1e000ULL,
0x0000000b0e00720bULL, 0x002fe40003f3e000ULL, 0x000000140a107208ULL, 0x000fe40004000000ULL,
0x0000000e0b117208ULL, 0x000fe40004800000ULL, 0x0000000c0f00720bULL, 0x004fe20003f1e000ULL,
0x0c201f0010137f89ULL, 0x000e6600000e0000ULL, 0x0000000f0c0a7208ULL, 0x000fe20004000000ULL,
0x0c201f0011127f89ULL, 0x000ea200000e0000ULL, 0x0000000d3600720bULL, 0x000fc60003f1e000ULL,
0x0c201f000a0b7f89ULL, 0x0006e200000e0000ULL, 0x000000360d0c7208ULL, 0x000fe40004000000ULL,
0x000000131000720bULL, 0x002fe40003f3e000ULL, 0x000000121100720bULL, 0x004fe40003f5e000ULL,
0x00000010130d7208ULL, 0x000fe40004800000ULL, 0x00000011120e7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b0c367820ULL, 0x008fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000305ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010836ULL, 0x0000002a00377308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b2e0f7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b2b2e7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2c2b7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010836ULL, 0x0000001b00107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2a7823ULL, 0x108fe20000010836ULL, 0x3fb8aa3b0d2d7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010836ULL,
0x0000000b0a00720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082dULL, 0x0000002700117308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b09097823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082dULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b33277823ULL, 0x004fe20000010836ULL, 0x3fb8aa3b1e1e7823ULL, 0x000fcc000001082dULL,
0x0000001a00137308ULL, 0x002e620000000800ULL, 0x000000101110723eULL, 0x008fce00000010ffULL,
0x0000002800127308ULL, 0x0005f00000000800ULL, 0x0000003100317308ULL, 0x000ee20000000800ULL,
0x00000004ff287e24ULL, 0x004fe2000f8e00ffULL, 0x000000221311723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b18227823ULL, 0x000fe2000001082dULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x3f8000002828783eULL, 0x000fc400000010ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000123112723eULL, 0x008fce00000010ffULL,
0x0000002900157308ULL, 0x0005e20000000800ULL, 0x000000213213723eULL, 0x002fe200000010ffULL,
0x000000ffff297224ULL, 0x004fe200078e0028ULL, 0x3fb8aa3b19217823ULL, 0x000fca000001082dULL,
0x0000000f00147308ULL, 0x0002a20000000800ULL, 0x00000002ff327819ULL, 0x000fe20000011605ULL,
0x000000281018723cULL, 0x000b6800000418ffULL, 0x0000000832337824ULL, 0x040fe200078e00ffULL,
0x0000000832397810ULL, 0x000fe20007ffe0ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f0f7823ULL, 0x002fe20000010836ULL, 0x3fb8aa3b172f7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b16297823ULL, 0x020fca000001082dULL, 0x0000003400347308ULL, 0x000e620000000800ULL,
0x000000141514723eULL, 0x004fce00000010ffULL, 0x0000003500387308ULL, 0x0004f00000000800ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x000000253417723eULL, 0x002fe200000010ffULL,
0x000000ffff347224ULL, 0x000fc400078e0028ULL, 0x000000ffff357224ULL, 0x004fc800078e0028ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x000000373816723eULL, 0x008fe200000010ffULL,
0x0000000832377824ULL, 0x000fcc00078e00ffULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000242315723eULL, 0x002fce00000010ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0000000832237824ULL, 0x040fe200078e00ffULL, 0x000000341418723cULL, 0x000f6c0000041818ULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000e700000000800ULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x00000022002c7308ULL, 0x0004f00000000800ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000000132227810ULL, 0x004fc80007ffe0ffULL,
0xfffffff8232d7812ULL, 0x000fe400078ee222ULL, 0x0000002b3022723eULL, 0x002fe200000010ffULL,
0x0000002f00247308ULL, 0x000e620000000800ULL, 0x000000212c21723eULL, 0x008fe200000010ffULL,
0x00000008322c7824ULL, 0x040fe400078e00ffULL, 0x00000008322b7824ULL, 0x000fe400078e00ffULL,
0x0000000839307824ULL, 0x000fe400078e00ffULL, 0x0000002000257308ULL, 0x0005e60000000800ULL,
0xfffffff830397812ULL, 0x000fc400078ee239ULL, 0x000000292423723eULL, 0x002fc600000010ffULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000272e20723eULL, 0x004fe200000010ffULL,
0x00000008322e7824ULL, 0x040fe200078e00ffULL, 0x0000000332277810ULL, 0x040fe40007ffe0ffULL,
0x0000000232247810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82c2f7812ULL, 0x000fe200078ee227ULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x000000342018723cULL, 0x020b620000041818ULL,
0xfffffff82b2b7812ULL, 0x000fc400078ee224ULL, 0x0000000632277810ULL, 0x040fe40007ffe0ffULL,
0x0000000532247810ULL, 0x040fe40007ffe0ffULL, 0x0000001c001c7308ULL, 0x000ea20000000800ULL,
0x0000000432297810ULL, 0x000fe40007ffe0ffULL, 0x000000262526723eULL, 0x002fe400000010ffULL,
0xfffffff82e357812ULL, 0x060fe400078ee227ULL, 0xfffffff833337812ULL, 0x000fe200078ee224ULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0xfffffff82e317812ULL, 0x000fe200078ee229ULL,
0x0000000832297824ULL, 0x040fe200078e00ffULL, 0xffffffff322c7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff829297812ULL, 0x000fe200078ee232ULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x000000091c25723eULL, 0x004fe400000010ffULL, 0x0000000c1f1c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1f7224ULL, 0x000fe200078e0028ULL, 0xfffffff837377812ULL, 0x000fc600078ee22cULL,
0x0000000f000f7308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x0000001d1e27723eULL, 0x002fe200000010ffULL, 0x000000ffff1e7224ULL, 0x000fe200078e0028ULL,
0x0000000f2a24723eULL, 0x004fc400000010ffULL, 0x00009000022a7811ULL, 0x000fe400078e58ffULL,
0x0000000a0b0f7208ULL, 0x000fc60004800000ULL, 0x0000001e2418723cULL, 0x000f620000041818ULL,
0x0000001029297824ULL, 0x100fe400078e022aULL, 0x000000102d2d7824ULL, 0x100fe400078e022aULL,
0x000000102b2b7824ULL, 0x100fe400078e022aULL, 0x000000102f2f7824ULL, 0x100fe400078e022aULL,
0x0000001031317824ULL, 0x000fe400078e022aULL, 0x0000000129297824ULL, 0x000fc400078e021cULL,
0x0000001033337824ULL, 0x100fe400078e022aULL, 0x000000011c2d7824ULL, 0x040fe200078e022dULL,
0x0000001029007388ULL, 0x0003e20000000800ULL, 0x0000001035357824ULL, 0x100fe400078e022aULL,
0x000000011c2b7824ULL, 0x040fe200078e022bULL, 0x000000122d007388ULL, 0x0003e20000000800ULL,
0x0000001037377824ULL, 0x100fe400078e022aULL, 0x000000011c2f7824ULL, 0x000fe200078e022fULL,
0x000000142b007388ULL, 0x0003e20000000800ULL, 0x0000001039397824ULL, 0x000fc400078e022aULL,
0x000000011c317824ULL, 0x040fe200078e0231ULL, 0x000000162f007388ULL, 0x0003e20000000800ULL,
0x000000011c337824ULL, 0x040fe400078e0233ULL, 0x000000011c357824ULL, 0x040fe200078e0235ULL,
0x0000002031007388ULL, 0x0003e20000000800ULL, 0x000000011c377824ULL, 0x040fe400078e0237ULL,
0x000000011c1c7824ULL, 0x000fe200078e0239ULL, 0x0000002233007388ULL, 0x0003e20000000800ULL,
0x000000ffff197224ULL, 0x020fc600078e001aULL, 0x0000002435007388ULL, 0x0003e80000000800ULL,
0x0000002637007388ULL, 0x0003e80000000800ULL, 0x000000111c007388ULL, 0x0003e80000000800ULL,
0x000400132d007388ULL, 0x0003e80000000800ULL, 0x000400152b007388ULL, 0x0003e80000000800ULL,
0x000400172f007388ULL, 0x0003e80000000800ULL, 0x0004002131007388ULL, 0x0003e80000000800ULL,
0x0004002333007388ULL, 0x0003e80000000800ULL, 0x0004002535007388ULL, 0x0003e80000000800ULL,
0x0004002737007388ULL, 0x0003e80000000800ULL, 0x00f0000c00008388ULL, 0x0003e80000000c00ULL,
0x00f2001800008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000007aff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008007aff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010007aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000106067810ULL, 0x000fe20007ffe0ffULL, 0x000018007aff7f8cULL, 0x0003e6000c80043fULL,
0x000000700600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffa74000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0b7807ULL, 0x008fe40004000000ULL, 0x00016db000147802ULL, 0x000fc40000000f00ULL,
0x00000bb000007944ULL, 0x012fea0003c00000ULL, 0xfffeb8e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x000fe40005000000ULL, 0x00016df000147802ULL, 0x000fc40000000f00ULL,
0x00000b7000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff167224ULL, 0x000fe200078e000bULL,
0xfffeb94000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0x00016e4000157802ULL, 0x000fc40000000f00ULL, 0x00000ad000007944ULL, 0x012fea0003c00000ULL,
0xfffeba2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0x00016e8000157802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x012fea0003c00000ULL,
0xfffebb4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e000cULL,
0x00016ed000157802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e000dULL,
0x00000a4000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000bULL,
0xfffebf6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e000cULL,
0x00016f2000157802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000bULL, 0xfffebf4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x004fe40004000000ULL, 0x00016f7000147802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x018fea0003c00000ULL, 0xfffeee4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x000fe40005000000ULL, 0x00016fb000147802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff347224ULL, 0x000fe200078e000bULL,
0xfffeee8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0037ULL,
0x0001700000157802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x018fea0003c00000ULL,
0xfffeef7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0037ULL,
0x0001704000157802ULL, 0x000fc40000000f00ULL, 0x000008d000007944ULL, 0x01afea0003c00000ULL,
0xfffef09000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e000eULL,
0x0001709000157802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e000fULL,
0x0000088000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000bULL,
0xfffef4c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e000eULL,
0x000170e000157802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000bULL, 0xfffef4a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x008fe40004000000ULL, 0x0001713000147802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x014fea0003c00000ULL, 0xffff217000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x000fe40005000000ULL, 0x0001717000147802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e000bULL,
0xffff21c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0039ULL,
0x000171c000157802ULL, 0x000fc40000000f00ULL, 0x0000075000007944ULL, 0x014fea0003c00000ULL,
0xffff22b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0039ULL,
0x0001720000157802ULL, 0x000fc40000000f00ULL, 0x0000071000007944ULL, 0x016fea0003c00000ULL,
0xffff23d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0009ULL,
0x0001725000157802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e000cULL,
0x000006c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000bULL,
0xffff280000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0009ULL,
0x000172a000157802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000bULL, 0xffff27e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x004fe40004000000ULL, 0x000172f000147802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x018fea0003c00000ULL, 0xffff551000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x000fe40005000000ULL, 0x0001733000147802ULL, 0x000fc40000000f00ULL,
0x0000063000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff097224ULL, 0x000fe200078e000bULL,
0xffff556000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0039ULL,
0x0001738000157802ULL, 0x000fc40000000f00ULL, 0x0000059000007944ULL, 0x018fea0003c00000ULL,
0xffff564000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0039ULL,
0x000173c000157802ULL, 0x000fc40000000f00ULL, 0x0000055000007944ULL, 0x01afea0003c00000ULL,
0xffff576000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0008ULL,
0x0001741000157802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e0009ULL,
0x0000050000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000bULL,
0xffff5b8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0008ULL,
0x0001746000157802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000bULL, 0xffff5b6000007947ULL, 0x000fea000383ffffULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x000174b000107802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e000bULL,
0xffffeb5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x006fe200078e0014ULL,
0x0001751000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff137424ULL, 0x000fc400078e00ffULL,
0x000003c000007944ULL, 0x010fea0003c00000ULL, 0x0000000b1400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000eULL, 0x0001757000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x000000140b147208ULL, 0x000fc80004000000ULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000fULL, 0x000175d000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x0000000e0b0e7208ULL, 0x000fc80004000000ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e0036ULL, 0x0001763000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000f0b0a7208ULL, 0x000fc80004000000ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x0000000b3600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e0014ULL, 0x0001769000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x000000360b0c7208ULL, 0x000fc80004000000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000eULL, 0x000176f000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x000000140b0d7208ULL, 0x000fc80004000000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000aULL, 0x0001775000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000e0b0e7208ULL, 0x000fc80004000000ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffea2000007947ULL, 0x000fea000383ffffULL,
0x018000003c007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003c00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff3cff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x800000003c037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003c00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe873004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000003800007348ULL, 0x000fe80003800000ULL, 0x0c000013120b7389ULL, 0x0002a200000e0015ULL,
0xfffe86f010007950ULL, 0x000fea0003c3ffffULL, 0x0000007100007348ULL, 0x000fe80003800000ULL,
0x0000000b140b7389ULL, 0x0002a400000e0072ULL, 0x000000ffff147224ULL, 0x002fc400078e0015ULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffe86a014007950ULL, 0x000fea0003c3ffffULL,
0x000000010b00780cULL, 0x000fe20003f45070ULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000006d00007348ULL, 0x000ff60003800000ULL, 0x00000000000b7806ULL, 0x000fc800050e0100ULL,
0x0000006d0b0b7212ULL, 0x000fe200078ec0ffULL, 0xfffe864014007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000288ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c80ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x00000000000007bcULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001500ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001510ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015a0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015a4ULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001780ULL, 0x0000000000017a80ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019200ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019250ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000195d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015a0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017c60ULL, 0x0000000000017c60ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000019200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000195d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_89_cubin_len = 104112;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
