/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000143c0ULL, 0x0000000000014040ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x00000000000129e0ULL, 0x0000000000000220ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000012c00ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000129e000000000ULL, 0x0001080400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x000129e000000000ULL, 0x0000022000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x000823040000007fULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000001c000942804ULL, 0x0000096000000260ULL,
0x0000299000002920ULL, 0x00002ba000002a60ULL, 0x0000313000003120ULL, 0x00004de000004d80ULL,
0x0000502000004ee0ULL, 0x0000543000005420ULL, 0x0000701000006fb0ULL, 0x0000725000007110ULL,
0x0000766000007650ULL, 0x000092b000009250ULL, 0x000094f0000093b0ULL, 0x0000994000009930ULL,
0x0000aa700000aa60ULL, 0x00011e5000011da0ULL, 0x0001210000012070ULL, 0x000123b000012350ULL,
0x0001274000012630ULL, 0x0000047004303904ULL, 0x00017600000000ffULL, 0x0000055000040100ULL,
0x0001760800000000ULL, 0x00000660003f0100ULL, 0x0001768800000000ULL, 0x00000790003f0100ULL,
0x000176a800000005ULL, 0x000008a0003f0100ULL, 0x000176c800000004ULL, 0x00000de0003f0100ULL,
0x000176000000000dULL, 0x00000f70003f0107ULL, 0x0001768800000000ULL, 0x00001840003f0101ULL,
0x0000000000000049ULL, 0x0000197000040107ULL, 0x0000000000000049ULL, 0x000019f000040101ULL,
0x0000002000000002ULL, 0x00001b40003f0101ULL, 0x000176c800000035ULL, 0x00001cc0003f0109ULL,
0x000176c800000035ULL, 0x00002660003f0109ULL, 0x000176b000000056ULL, 0x000026a0003f0107ULL,
0x000176b000000056ULL, 0x000026b0003f0101ULL, 0x0001760800000052ULL, 0x000026d0003f0101ULL,
0x0001760800000052ULL, 0x00002840003f0109ULL, 0x0001760800000052ULL, 0x00002d90003f0109ULL,
0x000176a800000036ULL, 0x00002f00003f0109ULL, 0x000176a800000036ULL, 0x00004010003f0109ULL,
0x000176c800000034ULL, 0x00004030003f0101ULL, 0x000176880000004eULL, 0x000040e0003f0101ULL,
0x0000000000000004ULL, 0x00004250003f0109ULL, 0x0000000000000004ULL, 0x00004ad0003f0109ULL,
0x000176a800000016ULL, 0x00004b40003f0107ULL, 0x000176a800000016ULL, 0x00004b50003f0101ULL,
0x0001762800000052ULL, 0x00004b70003f0101ULL, 0x0001762800000052ULL, 0x00004ce0003f0109ULL,
0x0001762800000052ULL, 0x00005200003f0109ULL, 0x000176b000000037ULL, 0x00005370003f0109ULL,
0x000176b000000037ULL, 0x000062a0003f0109ULL, 0x000176c800000036ULL, 0x000062c0003f0101ULL,
0x000176900000005aULL, 0x00006310003f0101ULL, 0x0000000000000004ULL, 0x00006480003f0109ULL,
0x0000000000000004ULL, 0x00006d00003f0109ULL, 0x000176b000000016ULL, 0x00006d70003f0107ULL,
0x000176b000000016ULL, 0x00006d80003f0101ULL, 0x0001764800000052ULL, 0x00006da0003f0101ULL,
0x0001764800000052ULL, 0x00006f10003f0109ULL, 0x0001764800000052ULL, 0x00007430003f0109ULL,
0x000176a800000037ULL, 0x000075a0003f0109ULL, 0x000176a800000037ULL, 0x00008480003f0109ULL,
0x000176c800000034ULL, 0x000084a0003f0101ULL, 0x000176980000003eULL, 0x00008550003f0101ULL,
0x0000000000000004ULL, 0x000086c0003f0109ULL, 0x0000000000000004ULL, 0x00008fd0003f0109ULL,
0x000176a800000014ULL, 0x00009010003f0107ULL, 0x000176a800000014ULL, 0x00009020003f0101ULL,
0x0001766800000007ULL, 0x00009050003f0101ULL, 0x0001766800000007ULL, 0x000091c0003f0109ULL,
0x0001766800000007ULL, 0x000096d0003f0109ULL, 0x000176b000000037ULL, 0x00009840003f0109ULL,
0x000176b000000037ULL, 0x0000a6c0003f0109ULL, 0x0000000000000004ULL, 0x0000a750003f0101ULL,
0x000176a000000004ULL, 0x0000b9a0003f0101ULL, 0x000176000000000dULL, 0x0000d2f0003f0101ULL,
0x000176000000000dULL, 0x0000d460003f0109ULL, 0x000176000000000dULL, 0x0000d640003f0109ULL,
0x000176000000000dULL, 0x0000d660003f0101ULL, 0x000176000000000dULL, 0x0000d7d0003f0109ULL,
0x000176000000000dULL, 0x00010400003f0109ULL, 0x000176880000000bULL, 0x000105d0003f0101ULL,
0x000176880000000bULL, 0x00010740003f0109ULL, 0x000176880000000bULL, 0x00012980003f0109ULL,
0x000176080000000cULL, 0x00012990003f0101ULL, 0x000176100000000cULL, 0x000129a0003f0101ULL,
0x000176180000000cULL, 0x000129b0003f0101ULL, 0x000176200000000cULL, 0x00053803003f0101ULL,
0x0000b2e000201c04ULL, 0x0000b5000000b340ULL, 0x0000b7f00000b660ULL, 0x0000d8000000b8f0ULL,
0x000c0504000129d0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL,
0x0000001800080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001700000002ULL,
0x00000000000129e0ULL, 0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000097919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000000a7919ULL, 0x000eea0000002200ULL, 0x00000400ff067b82ULL, 0x000f220000000800ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000157919ULL, 0x000f6c0000002700ULL,
0x00008600ff117b82ULL, 0x000f620000000800ULL, 0x0000000300007306ULL, 0x004ea20000209000ULL,
0x000000ff0300720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00047836ULL, 0x004fcc0000000000ULL, 0x0000000400057305ULL, 0x0004e4000021f000ULL,
0x000000ffff047224ULL, 0x004fe400078e00ffULL, 0x000000ffff087224ULL, 0x00afc800078e0a05ULL,
0x0000000308077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002600ULL,
0x0000000705057227ULL, 0x000fe400078e0004ULL, 0x0000000000077919ULL, 0x000ea80000002100ULL,
0x0000000605417227ULL, 0x010fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a41ULL,
0x0000000503007224ULL, 0x000fca00078e0206ULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a03ULL, 0x0000000141410836ULL, 0x000fe20000000000ULL,
0x00000005ff407819ULL, 0x004fe40000011607ULL, 0x000000030000720cULL, 0x000fc80003f26070ULL,
0x00001fff40407589ULL, 0x000f7200000e0000ULL, 0x0000000141411836ULL, 0x000fe20000000000ULL,
0x00000003ff41a212ULL, 0x000fc800078e33ffULL, 0x0000004100007306ULL, 0x000ea20000209000ULL,
0x000000ff4100720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00047836ULL, 0x004fe40000000000ULL, 0x0000000409007c24ULL, 0x000fe2000f8e020aULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000400057305ULL, 0x0004e2000021f000ULL,
0x00001fff09097589ULL, 0x000f6200000e0000ULL, 0x000000ffff047224ULL, 0x004fe400078e00ffULL,
0x0000000541067224ULL, 0x008fc800078e02ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a06ULL,
0x0000000b05057227ULL, 0x000fc800078e0004ULL, 0x0000000400047c24ULL, 0x000fe4000f8e0207ULL,
0x0000000805427227ULL, 0x002fc600078e00ffULL, 0x0000007f0400780cULL, 0x040fe20003f64070ULL,
0x000000ffff057224ULL, 0x000fe200078e0a42ULL, 0x000000030400780cULL, 0x000fc60003f84070ULL,
0x0000000541007224ULL, 0x000fca00078e0208ULL, 0x000000410000720cULL, 0x000fc60003f06070ULL,
0x000000000006b919ULL, 0x000e620000008800ULL, 0x000004000005b802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a41ULL, 0x0000000142420836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000410000720cULL, 0x000fda0003f26070ULL,
0x0000000142421836ULL, 0x000fe20000000000ULL, 0x00000041ff42a212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x000fe40003f24070ULL, 0x000006540605b816ULL, 0x002fe20000000005ULL,
0x000000ffff007224ULL, 0x000fe200078e0a42ULL, 0x000000010400780cULL, 0x000fe20003f44070ULL,
0xff317217ff06b424ULL, 0x000fe400078e00ffULL, 0x0000000041417224ULL, 0x000fc400078e0208ULL,
0x000000040405b824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x020fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01760006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01760804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01768804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x017400060500b388ULL, 0x0003e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000001041007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x0000001102057219ULL, 0x082fe200000006ffULL,
0x0000000215027224ULL, 0x000fe200078e02ffULL, 0x00000011030f7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000500720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x00000010053b7446ULL, 0x000fe20003800004ULL,
0x0000000409057824ULL, 0x000fe200078e0240ULL, 0x0000001142047219ULL, 0x000fc400000006ffULL,
0x000000ff3b3b7207ULL, 0x000fc60000000000ULL, 0x0000000f02027224ULL, 0x000fe200078e0204ULL,
0x000000103b00780cULL, 0x000fe20003f05270ULL, 0x0000000205047824ULL, 0x000fd800078e00ffULL,
0x0000000000808947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000137919ULL, 0x000ea60000008800ULL, 0x0000001106067219ULL, 0x000fe400000006ffULL,
0x00000004ff0b7819ULL, 0x002fca000001160eULL, 0x00000001040d7824ULL, 0x000fc800078e020bULL,
0x0000000100057824ULL, 0x000fca00078e020dULL, 0x0000000605077212ULL, 0x000fe400078e30ffULL,
0x00000011ff067219ULL, 0x000fe20000011605ULL, 0x000000100e057824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e0207ULL, 0x000000043b077248ULL, 0x000fe40007fe0000ULL,
0x000000f005117812ULL, 0x000fe200078ec0ffULL, 0x0000000f06067224ULL, 0x000fe400078e0202ULL,
0x0000000107047824ULL, 0x000fc400078e0a04ULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000040b00720cULL, 0x000fe20003f06070ULL, 0x000000010d027824ULL, 0x040fe200078e020eULL,
0x0000040000047802ULL, 0x000fe20000000f00ULL, 0x000000100d0b7824ULL, 0x000fe200078e00ffULL,
0x0000001106117212ULL, 0x000fe400078efcffULL, 0x00000654130d7816ULL, 0x004fe40000000004ULL,
0xfffffff00b027812ULL, 0x000fe400078ee202ULL, 0x0000000411067c10ULL, 0x000fc6000ff3e0ffULL,
0x00000010020b7824ULL, 0x000fe200078e020dULL, 0x0000000507077c10ULL, 0x000fca0008ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000c101c46ULL,
0x00000000006c7947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000137919ULL, 0x000ea60000008800ULL, 0x0000001106057219ULL, 0x000fe400000006ffULL,
0x000000040e0b7211ULL, 0x002fca00078fe0ffULL, 0x0000000100047824ULL, 0x000fca00078e020bULL,
0x0000000504057212ULL, 0x000fe400078e30ffULL, 0x00000011ff047219ULL, 0x000fc60000011604ULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x000000010b027824ULL, 0x000fe400078e020eULL,
0x0000000f04047224ULL, 0x000fe400078e0205ULL, 0x000000100e057824ULL, 0x000fe400078e00ffULL,
0x0000010004067825ULL, 0x000fe200078e00ffULL, 0x0000040000047802ULL, 0x000fe40000000f00ULL,
0x000000f0050d7812ULL, 0x000fe200078ec0ffULL, 0x000000100b0b7824ULL, 0x000fc600078e00ffULL,
0x0000000d06067212ULL, 0x000fe400078efcffULL, 0x00000654130d7816ULL, 0x004fe40000000004ULL,
0xfffffff00b027812ULL, 0x000fe400078ee202ULL, 0x0000000406067c10ULL, 0x000fc6000ff1e0ffULL,
0x00000010020b7824ULL, 0x000fe200078e020dULL, 0x0000000507077c10ULL, 0x000fca00087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e8000b901c46ULL,
0x000000000d0472caULL, 0x000fe200000e0000ULL, 0x00009200ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001760004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000415067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606397981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe20003f05270ULL,
0x0000003f393a7836ULL, 0x004fe40000000000ULL, 0x000000ff39027836ULL, 0x000fc60000000000ULL,
0x00000006ff3a7819ULL, 0x000fe4000001163aULL, 0x00000008ff387819ULL, 0x000fca0000011602ULL,
0x000000a800948947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011640ULL,
0xffffffffff047424ULL, 0x000fe400078e00ffULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0x03ffffff0c097812ULL, 0x000fc800078ec0ffULL, 0x0000003a0900720cULL, 0x000fda0003f06070ULL,
0x00009400ff078b82ULL, 0x000e620000000800ULL, 0x0000000215008824ULL, 0x000fce00078e00ffULL,
0x00009000ff108b82ULL, 0x000ea20000000a00ULL, 0x0000000700008224ULL, 0x002fc800078e0207ULL,
0x0000000109078824ULL, 0x000fe400078e0200ULL, 0x0000000840007824ULL, 0x000fe400078e020dULL,
0x0000000407108825ULL, 0x004fe400078e0010ULL, 0x0176880b00ff79a7ULL, 0x0003e6000850003fULL,
0x0000000610048981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0200780cULL, 0x000fc40003f04070ULL,
0x00000001ff0a7819ULL, 0x000fe40000011640ULL, 0x0000000140077812ULL, 0x000fe200078ec0ffULL,
0x00000040420b7824ULL, 0x002fe400078e00ffULL, 0x000000200a087824ULL, 0x000fca00078e00ffULL,
0x000000200b007812ULL, 0x000fe200078ef808ULL, 0x0000000304047224ULL, 0x004fc800078e02ffULL,
0x00000040041b7824ULL, 0x000fe200078e00ffULL, 0x0000000400080947ULL, 0x000fec0003800000ULL,
0x0000000839037248ULL, 0x000fe20007fe0000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fe2000001160eULL, 0x00008e00ff207b82ULL, 0x000e640000000a00ULL,
0x0000000103037824ULL, 0x000fe400078e0a08ULL, 0x0000000102117824ULL, 0x000fe400078e0204ULL,
0x0000000404107836ULL, 0x000fe20000000000ULL, 0x0000000203037248ULL, 0x000fe20007fe0000ULL,
0x0000000111067824ULL, 0x000fc400078e020eULL, 0x0000000811137824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a02ULL, 0x0000000804127836ULL, 0x000fe20000000000ULL,
0xfffffff813067812ULL, 0x000fe200078ee206ULL, 0x0000000102137824ULL, 0x000fe200078e0210ULL,
0x000000031000720cULL, 0x080fe20003f46070ULL, 0x0000000c04107836ULL, 0x000fe20000000000ULL,
0x000000030400720cULL, 0x080fe20003f66070ULL, 0x0000000113047824ULL, 0x040fe200078e020eULL,
0x000000031200720cULL, 0x080fe20003f26070ULL, 0x00000008131d7824ULL, 0x000fe200078e00ffULL,
0x000000031000720cULL, 0x000fe20003f06070ULL, 0x0000000102177824ULL, 0x000fc400078e0212ULL,
0x0000000102197824ULL, 0x000fe200078e0210ULL, 0xfffffff81d147812ULL, 0x000fe200078ee204ULL,
0x0000000100027824ULL, 0x040fe400078e0211ULL, 0x0000000100107824ULL, 0x040fe400078e0213ULL,
0x0000000100127824ULL, 0x040fe400078e0217ULL, 0x0000000100167824ULL, 0x000fe400078e0219ULL,
0x0000008002027825ULL, 0x000fc800078e00ffULL, 0x0000000119047824ULL, 0x140fe200078e020eULL,
0x0000007002027812ULL, 0x000fe200078ef805ULL, 0x0000000819117824ULL, 0x000fe200078e00ffULL,
0x000000201b197211ULL, 0x002fe200078838ffULL, 0x0000000117007824ULL, 0x040fe400078e020eULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0xfffffff8111a7812ULL, 0x000fe200078ee204ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000211b217211ULL, 0x000fe400020f3cffULL,
0xfffffff817187812ULL, 0x000fe200078ee200ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000219027210ULL, 0x000fc40007f9e0ffULL, 0x0000007010047812ULL, 0x000fe200078ef805ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007012107812ULL, 0x000fc600078ef805ULL,
0x000020000a007824ULL, 0x000fe200078e020dULL, 0x0000007016127812ULL, 0x000fe200078ef805ULL,
0x0000000103037824ULL, 0x000fe200020e0621ULL, 0x0000001904047210ULL, 0x000fe20007f9e0ffULL,
0x0001300000057836ULL, 0x000fe20000000000ULL, 0x0000001910107210ULL, 0x000fe40007fbe0ffULL,
0x0000001912127210ULL, 0x000fe20007fde0ffULL, 0x0000001006197824ULL, 0x100fe400078e0205ULL,
0x00000010141b7824ULL, 0x000fc400078e0205ULL, 0x00000010181d7824ULL, 0x100fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002197faeULL, 0x0003e2000d901c46ULL,
0x000000101a1f7824ULL, 0x000fe400078e0205ULL, 0x0000000111057824ULL, 0x100fe400020e0621ULL,
0x0000000113117824ULL, 0x100fe400028e0621ULL, 0x0000000117137824ULL, 0x000fe200030e0621ULL,
0x00000000041b7faeULL, 0x0003e8000d101c46ULL, 0x00000000101d7faeULL, 0x0003e8000c901c46ULL,
0x00000000121f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d47947ULL, 0x000fea0003800000ULL,
0x0000001007037824ULL, 0x000fe200078e00ffULL, 0x00008e00ff187b82ULL, 0x000e680000000a00ULL,
0x000000030e037211ULL, 0x000fca00078fe8ffULL, 0x0000000103027824ULL, 0x140fe400078e020eULL,
0x0000000803137824ULL, 0x000fe400078e00ffULL, 0x0000000403117836ULL, 0x000fe40000000000ULL,
0x0000000c03177836ULL, 0x000fe20000000000ULL, 0xfffffff813067812ULL, 0x000fe200078ee202ULL,
0x0000000111047824ULL, 0x040fe400078e020eULL, 0x00000008111d7824ULL, 0x000fc400078e00ffULL,
0x0000000803137836ULL, 0x000fe40000000000ULL, 0x0000000100027824ULL, 0x040fe200078e0203ULL,
0xfffffff81d147812ULL, 0x000fe200078ee204ULL, 0x0000000100117824ULL, 0x040fe200078e0211ULL,
0x000000181b1d7211ULL, 0x042fe200078038ffULL, 0x0000000100127824ULL, 0x040fe400078e0213ULL,
0x0000000100167824ULL, 0x000fe200078e0217ULL, 0x000000191b217211ULL, 0x000fe200000f3cffULL,
0x0000008002027825ULL, 0x000fc800078e00ffULL, 0x0000000113007824ULL, 0x140fe200078e020eULL,
0x0000007002027812ULL, 0x000fe200078ef805ULL, 0x0000000813137824ULL, 0x000fe400078e00ffULL,
0x0000000117047824ULL, 0x040fe200078e020eULL, 0x000000021d027210ULL, 0x000fe20007f1e0ffULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0xfffffff813007812ULL, 0x000fe200078ee200ULL,
0x0000008011107825ULL, 0x000fc600078e00ffULL, 0xfffffff817187812ULL, 0x000fe200078ee204ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007010047812ULL, 0x000fc600078ef805ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007012107812ULL, 0x000fc600078ef805ULL,
0x000020000a197824ULL, 0x000fe200078e020dULL, 0x0000007016057812ULL, 0x000fe200078ef805ULL,
0x0000000103037824ULL, 0x000fe200000e0621ULL, 0x000000041d047210ULL, 0x000fe20007f1e0ffULL,
0x00013000191f7836ULL, 0x000fe20000000000ULL, 0x000000101d107210ULL, 0x000fe40007f3e0ffULL,
0x000000051d127210ULL, 0x000fe20007f5e0ffULL, 0x0000001006197824ULL, 0x100fe400078e021fULL,
0x00000010141b7824ULL, 0x000fc400078e021fULL, 0x0000000111057824ULL, 0x000fe200000e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002197faeULL, 0x0003e2000b901c46ULL,
0x00000010001d7824ULL, 0x000fe400078e021fULL, 0x0000000113117824ULL, 0x000fe200008e0621ULL,
0x00000000041b7faeULL, 0x0003e2000b901c46ULL, 0x00000010181f7824ULL, 0x000fe400078e021fULL,
0x0000000117137824ULL, 0x000fe200010e0621ULL, 0x00000000101d7faeULL, 0x0003e8000b901c46ULL,
0x00000000121f7faeULL, 0x0003e4000b901c46ULL, 0x0000000109097836ULL, 0x000fe40000000000ULL,
0xffffffffff537424ULL, 0x000fc600078e00ffULL, 0x0000003a0900720cULL, 0x000fe20003f06070ULL,
0x000176a80d497836ULL, 0x000fe20000000000ULL, 0x000000000a0472caULL, 0x000fd600000e0000ULL,
0x00009400ff058b82ULL, 0x002e620000000800ULL, 0x00000000490572caULL, 0x000fe200000e0000ULL,
0x0000000215008824ULL, 0x000fcc00078e00ffULL, 0x00009000ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000404047899ULL, 0x000fca000800063fULL, 0x0000000504057290ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000500008224ULL, 0x002fc800078e0205ULL, 0x0000000100058824ULL, 0x000fc800078e0209ULL,
0x0000000405028825ULL, 0x004fca00078e0002ULL, 0x0000000602538981ULL, 0x000322000c1e1900ULL,
0x000000ff3800720cULL, 0x000fe20003f05270ULL, 0x00000001ff007424ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe400078e00ffULL, 0x000000080a027824ULL, 0x002fe200078e0249ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000494879a7ULL, 0x0002a20008500004ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00002000020279a7ULL, 0x0002e2000850003fULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000008c00b88947ULL, 0x000fec0003800000ULL, 0x00009400ff137b82ULL, 0x000f620000000800ULL,
0x00000004ff057e24ULL, 0x000fe4000f8e00ffULL, 0x000000200c007824ULL, 0x002fe400078e020dULL,
0x0000000215067824ULL, 0x000fe200078e00ffULL, 0x0000001005057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff347224ULL, 0x008fe400078e0003ULL, 0xff317217ff557424ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fc400078e0205ULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x0000000807077824ULL, 0x000fe400078e0200ULL, 0x0000001306067224ULL, 0x020fe400078e0213ULL,
0x000000ffff137224ULL, 0x000fce00078e00ffULL, 0x000000ffff457224ULL, 0x000fce00078e0009ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000000440047824ULL, 0x000fca00078e00ffULL,
0xfffffff804047812ULL, 0x000fca00078ec0ffULL, 0x000000010d357824ULL, 0x000fc800078e0204ULL,
0x0176c834350075a7ULL, 0x000e62000800017fULL, 0x000176c835047836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176c834350075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001040147824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000000105157836ULL, 0x000fe40000000000ULL, 0x0000000453347c24ULL, 0x010fe2000f8e02ffULL,
0xffffffe014167812ULL, 0x000fe400078ec0ffULL, 0x000000381500720cULL, 0x000fe20003f26070ULL,
0x0000004034347824ULL, 0x000fe400078e00ffULL, 0x0000010005167824ULL, 0x000fc800078e0216ULL,
0x0000004016357836ULL, 0x000fca0000000000ULL, 0x0000002035167812ULL, 0x000fca00078ec0ffULL,
0x000000010b487824ULL, 0x004fe200078e0216ULL, 0x0000000400109947ULL, 0x000fec0003800000ULL,
0x0000001014177812ULL, 0x000fe400078ec0ffULL, 0x0000003539147248ULL, 0x000fe40007fe0000ULL,
0x00000003ff377819ULL, 0x000fc6000001160eULL, 0x0000000114147824ULL, 0x000fe400078e0a35ULL,
0x0000000137357824ULL, 0x100fe400078e0217ULL, 0x0000000c373c7836ULL, 0x000fe20000000000ULL,
0x0000001714167248ULL, 0x000fe20007fe0000ULL, 0x0000000135367824ULL, 0x040fe200078e020eULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x00000008353d7824ULL, 0x000fe400078e00ffULL,
0x0000000116167824ULL, 0x000fc400078e0a17ULL, 0x000000013c3f7824ULL, 0x140fe200078e0217ULL,
0xfffffff83d3e7812ULL, 0x000fe200078ee236ULL, 0x0000000437367836ULL, 0x000fe20000000000ULL,
0x000000163700720cULL, 0x080fe20003f86070ULL, 0x00000008373d7836ULL, 0x000fe20000000000ULL,
0x000000163c00720cULL, 0x080fe20003f06070ULL, 0x0000000136377824ULL, 0x140fe200078e0217ULL,
0x000000163600720cULL, 0x080fe20003f66070ULL, 0x000000100e367824ULL, 0x000fe200078e00ffULL,
0x000000163d00720cULL, 0x040fe20003f46070ULL, 0x000000013d3d7824ULL, 0x000fc400078e0217ULL,
0x0000000137167824ULL, 0x140fe400078e020eULL, 0x0000000837437824ULL, 0x000fe400078e00ffULL,
0x00000001483c7824ULL, 0x000fe400078e0235ULL, 0x000000013d177824ULL, 0x040fe200078e020eULL,
0xfffffff843447812ULL, 0x000fe200078ee216ULL, 0x000000083d467824ULL, 0x000fe200078e00ffULL,
0x0000007036437812ULL, 0x000fe200078ec0ffULL, 0x0000000148167824ULL, 0x000fc400078e023dULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fc600078ee217ULL,
0x0000000148377824ULL, 0x040fe400078e0237ULL, 0x0000000148357824ULL, 0x000fe400078e023fULL,
0x000000013f177824ULL, 0x040fe400078e020eULL, 0x000000083f487824ULL, 0x000fe200078e00ffULL,
0x00000014343f7211ULL, 0x002fe200078a38ffULL, 0x0000008037367825ULL, 0x000fe200078e00ffULL,
0x000000433c147212ULL, 0x000fe400078efcffULL, 0x00000015344b7211ULL, 0x000fe200028f3cffULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x000000143f147210ULL, 0x000fc40007fbe0ffULL,
0xfffffff8483c7812ULL, 0x000fe200078ee217ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004336367212ULL, 0x080fe400078efcffULL, 0x0000004334347212ULL, 0x080fe200078efcffULL,
0x000000013d157824ULL, 0x000fe200028e064bULL, 0x0000003f36367210ULL, 0x000fe20007fbe0ffULL,
0x000020000a3d7824ULL, 0x000fe200078e020dULL, 0x0000004316167212ULL, 0x000fe400078efcffULL,
0x0000003f34347210ULL, 0x000fe20007fde0ffULL, 0x000140003d3d7836ULL, 0x000fc40000000000ULL,
0x0000000137377824ULL, 0x000fe200028e064bULL, 0x0000003f16167210ULL, 0x000fe20007fbe0ffULL,
0x000000103e3f7824ULL, 0x100fe400078e023dULL, 0x0000001044437824ULL, 0x100fe400078e023dULL,
0x0000001046477824ULL, 0x000fe200078e023dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143f7faeULL, 0x0003e2000e101c46ULL, 0x0000000117177824ULL, 0x000fe400028e064bULL,
0x000000103c3d7824ULL, 0x000fe200078e023dULL, 0x0000000036437faeULL, 0x0003e2000d901c46ULL,
0x0000000135357824ULL, 0x000fc600030e064bULL, 0x0000000016477faeULL, 0x0003e8000d101c46ULL,
0x00000000343d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000dc7947ULL, 0x000fea0003800000ULL,
0x0000001014177812ULL, 0x000fe400078ec0ffULL, 0x00008e00ff147b82ULL, 0x000e640000000a00ULL,
0x000000170e177211ULL, 0x000fca00078fe8ffULL, 0x0000000417357836ULL, 0x000fe40000000000ULL,
0x0000000117167824ULL, 0x140fe400078e020eULL, 0x0000000817377824ULL, 0x000fe400078e00ffULL,
0x0000000135367824ULL, 0x040fe400078e020eULL, 0x0000000835437824ULL, 0x000fe200078e00ffULL,
0xfffffff8373e7812ULL, 0x000fe200078ee216ULL, 0x0000000148167824ULL, 0x000fc400078e0217ULL,
0x0000000817377836ULL, 0x000fe20000000000ULL, 0xfffffff843437812ULL, 0x000fe200078ee236ULL,
0x000000100e367824ULL, 0x000fe400078e00ffULL, 0x0000000c173d7836ULL, 0x000fe20000000000ULL,
0x00000014344b7211ULL, 0x002fe200078038ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007036477812ULL, 0x000fc600078ec0ffULL, 0x00000001373c7824ULL, 0x140fe200078e020eULL,
0x0000004716147212ULL, 0x000fe200078efcffULL, 0x00000008374d7824ULL, 0x000fe400078e00ffULL,
0x0000000148367824ULL, 0x000fe400078e0237ULL, 0x000000013d377824ULL, 0x040fe200078e020eULL,
0xfffffff84d447812ULL, 0x000fe200078ee23cULL, 0x000000083d467824ULL, 0x000fe200078e00ffULL,
0x00000015344d7211ULL, 0x000fe200000f3cffULL, 0x0000000148357824ULL, 0x040fe200078e0235ULL,
0x000000144b147210ULL, 0x000fe20007f1e0ffULL, 0x00000001483f7824ULL, 0x000fe200078e023dULL,
0xfffffff846467812ULL, 0x000fe200078ee237ULL, 0x0000008035347825ULL, 0x000fc800078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004734167212ULL, 0x000fc600078efcffULL,
0x000000803f3c7825ULL, 0x000fe200078e00ffULL, 0x0000004736347212ULL, 0x000fc600078efcffULL,
0x0000000117157824ULL, 0x000fe200000e064dULL, 0x000000473c367212ULL, 0x000fe200078efcffULL,
0x000020000a177824ULL, 0x000fe200078e020dULL, 0x000000164b167210ULL, 0x000fe40007f1e0ffULL,
0x000000344b347210ULL, 0x000fe20007f5e0ffULL, 0x0001400017177836ULL, 0x000fe20000000000ULL,
0x000000364b367210ULL, 0x000fc60007f7e0ffULL, 0x000000103e3f7824ULL, 0x100fe400078e0217ULL,
0x0000001043437824ULL, 0x100fe400078e0217ULL, 0x0000001044477824ULL, 0x100fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143f7faeULL, 0x0003e2000b901c46ULL,
0x00000010464b7824ULL, 0x000fe400078e0217ULL, 0x0000000135177824ULL, 0x100fe400000e064dULL,
0x0000000137357824ULL, 0x000fc400010e064dULL, 0x000000013d377824ULL, 0x000fe200018e064dULL,
0x0000000016437faeULL, 0x0003e8000b901c46ULL, 0x0000000034477faeULL, 0x0003e8000b901c46ULL,
0x00000000364b7faeULL, 0x0003e4000b901c46ULL, 0x0000000109177836ULL, 0x002fe40000000000ULL,
0xffffffffff4c7424ULL, 0x000fc600078e00ffULL, 0x0000003a1700720cULL, 0x000fe20003f06070ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016347812ULL, 0x000fce00078ec0ffULL,
0x00009000ff148b82ULL, 0x000e620000000a00ULL, 0x000000010d567824ULL, 0x000fe400078e0234ULL,
0x0000000106178824ULL, 0x000fc600078e0217ULL, 0x00000000560472caULL, 0x000fe400000e0000ULL,
0xffffffe016347812ULL, 0x000fd600078ec0ffULL, 0x000176b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000417148825ULL, 0x002fe200078e0014ULL, 0x0000001016177812ULL, 0x000fc800078ec0ffULL,
0x0000000d17177210ULL, 0x000fe20007ffe034ULL, 0x00000006144c8981ULL, 0x000322000c1e1900ULL,
0x0000000816527812ULL, 0x000fe200078ec0ffULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000117527824ULL, 0x000fe200078e0252ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0176b035565679a7ULL, 0x0004e4000850003fULL, 0x01760835523479a7ULL, 0x004464000850003fULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x01760835520075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01760835520075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000100e447824ULL, 0x000fe200078e00ffULL, 0x00000001ff477819ULL, 0x000fe2000001160eULL,
0x0000002040147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000007044447812ULL, 0x000fe400078ec0ffULL, 0xffffff8014147812ULL, 0x000fe400078ec0ffULL,
0x0000000c47477812ULL, 0x000fe400078ec0ffULL, 0x0000000d44147210ULL, 0x000fca0007ffe014ULL,
0x0000000114147824ULL, 0x000fca00078e0247ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x000b620000000800ULL, 0x000000551600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000000fc8947ULL, 0x02cfea0003800000ULL, 0x000000400c00720cULL, 0x000fe40003f45270ULL,
0x000000551600720bULL, 0x0c0fe40003f14000ULL, 0x0000005516377209ULL, 0x000fd20007810000ULL,
0x000000804014a824ULL, 0x000fe400078e020dULL, 0x0000000000347806ULL, 0x000fc600000e0100ULL,
0x000000144714a210ULL, 0x000fe40007ffe044ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400371400a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000003755557221ULL, 0x000fe20000010000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b55557820ULL, 0x000fcc0000410000ULL, 0x0000005500557308ULL, 0x000e680000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fcc000001160eULL,
0x00001f1455147589ULL, 0x002e6400000e0000ULL, 0x0000001418187220ULL, 0x082fe20000410000ULL,
0x0000001419197220ULL, 0x080fe20000410000ULL, 0x000000142c2c7220ULL, 0x080fe20000410000ULL,
0x000000142d2d7220ULL, 0x080fe20000410000ULL, 0x0000001430307220ULL, 0x080fe20000410000ULL,
0x0000001431317220ULL, 0x080fe20000410000ULL, 0x0000001428287220ULL, 0x080fe20000410000ULL,
0x0000001429297220ULL, 0x080fe20000410000ULL, 0x0000001424247220ULL, 0x080fe20000410000ULL,
0x0000001425257220ULL, 0x080fe20000410000ULL, 0x0000001420207220ULL, 0x080fe20000410000ULL,
0x0000001421217220ULL, 0x080fe20000410000ULL, 0x000000141c1c7220ULL, 0x080fe20000410000ULL,
0x000000141d1d7220ULL, 0x080fe20000410000ULL, 0x0000001410107220ULL, 0x080fe20000410000ULL,
0x0000001411117220ULL, 0x000fce0000410000ULL, 0x0000005554547220ULL, 0x002fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x000fcc00078ff0ffULL,
0x00001f1455147589ULL, 0x000e6400000e0000ULL, 0x000000141a1a7220ULL, 0x082fe20000410000ULL,
0x000000141b1b7220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x0000001426267220ULL, 0x080fe20000410000ULL,
0x0000001427277220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x000000141e1e7220ULL, 0x080fe20000410000ULL,
0x000000141f1f7220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff557224ULL, 0x000fd400078e0037ULL,
0x8000003716160221ULL, 0x100fe20000010000ULL, 0x000000ffff550224ULL, 0x000fe200078e0037ULL,
0x00007610ff340816ULL, 0x000fe40000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000e640000000800ULL, 0x0000000217170220ULL, 0x002fce0000410000ULL,
0x0000005417547221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d367824ULL, 0x000fc800078e0216ULL, 0x0176a849360075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff377224ULL, 0x000fce00078e00ffULL,
0x000000103700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000137377836ULL, 0x000fce0000000000ULL,
0x0176a849360075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034157816ULL, 0x000fe200000000ffULL, 0x00000002404e7824ULL, 0x000fe200078e00ffULL,
0x000000070e5d7812ULL, 0x000fe200078ec0ffULL, 0x0000020040147824ULL, 0x040fe200078e00ffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x00000004404a7824ULL, 0x000fe200078e00ffULL,
0x000000044e157812ULL, 0x000fe200078ec0ffULL, 0x000020000a4f7824ULL, 0x000fe200078e020dULL,
0xfffff80014167812ULL, 0x000fe400078ec0ffULL, 0x000000085d5b7812ULL, 0x000fe200078ef80eULL,
0x000130004f487836ULL, 0x000fe20000000000ULL, 0x000000150e147211ULL, 0x040fe200078fe0ffULL,
0x000000010d4b7824ULL, 0x000fe200078e0216ULL, 0x000000080e5a7812ULL, 0x000fe200078ec0ffULL,
0x000000085b467824ULL, 0x040fe200078e00ffULL, 0x00000004ff5f7819ULL, 0x000fe2000001160eULL,
0x000000015b437824ULL, 0x000fe200078e0214ULL, 0x000000044a4a7812ULL, 0x000fc400078ec0ffULL,
0x0000005d5a177212ULL, 0x000fe400078efcffULL, 0xfffffff846467812ULL, 0x000fe200078ee243ULL,
0x000000015f4a7824ULL, 0x000fe400078e024aULL, 0x0000000817517824ULL, 0x040fe400078e00ffULL,
0x0000000117147824ULL, 0x040fe400078e024aULL, 0x0000000817347824ULL, 0x000fe400078e00ffULL,
0x00000002144d7836ULL, 0x000fe20000000000ULL, 0xfffffff851517812ULL, 0x000fe200078ee214ULL,
0x0000001046507824ULL, 0x000fe200078e024bULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011000005014783bULL, 0x0022e20000000200ULL, 0x00000010513c7824ULL, 0x000fe200078e0248ULL,
0x0000000000100947ULL, 0x000fec0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0xfffffff8344d7812ULL, 0x000fe400078ee24dULL, 0x000000105a5d7812ULL, 0x000fc600078efe5dULL,
0x000000104d347824ULL, 0x000fcc00078e0248ULL, 0x000000003434783bULL, 0x000f640000004200ULL,
0x00000018ff6a7819ULL, 0x022fe2000001143dULL, 0x000001003d617824ULL, 0x040fe200078e00ffULL,
0x000088803d6e7816ULL, 0x040fe200000000ffULL, 0x000001003c5c7824ULL, 0x040fe200078e00ffULL,
0x000088803c637816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001143cULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff607819ULL, 0x008fe40000011434ULL,
0x0000888034647816ULL, 0x000fe400000000ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000005c00707306ULL, 0x0003e20000202400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff5e7819ULL, 0x000fe40000011435ULL, 0x0000888035627816ULL, 0x000fc400000000ffULL,
0x000088803e687816ULL, 0x040fe200000000ffULL, 0x0000003d00737306ULL, 0x0007e20000202400ULL,
0x000001003e5c7824ULL, 0x042fe200078e00ffULL, 0x000088803f667816ULL, 0x000fe400000000ffULL,
0x00000018ff587819ULL, 0x000fe2000001143eULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x00000100343d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011436ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc40000011437ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006100757306ULL, 0x000e620000202400ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff597819ULL, 0x000fe4000001143fULL,
0x00000018ff3e7819ULL, 0x000fc6000001143eULL, 0x0000005c006f7306ULL, 0x0007f00000202400ULL,
0x0000003400677306ULL, 0x000be20000202400ULL, 0x00000100355c7824ULL, 0x048fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000003c00717306ULL, 0x0007e20000202400ULL, 0x0000010037347824ULL, 0x024fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fc80000011435ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000006c006c7306ULL, 0x000ea20000202400ULL, 0x000001003f3c7824ULL, 0x048fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006a006a7306ULL, 0x000ee20000202400ULL, 0x00000018ff3f7819ULL, 0x000fce000001143fULL,
0x0000003500657306ULL, 0x0003f00000202400ULL, 0x0000003400617306ULL, 0x000be20000202400ULL,
0x000054106e357816ULL, 0x002fce0000000075ULL, 0x0000006800687306ULL, 0x000e620000202400ULL,
0x0000541063347816ULL, 0x020fce0000000070ULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x0000003c006d7306ULL, 0x000a620000202400ULL,
0x0000541071347816ULL, 0x004fe4000000006cULL, 0x0000541073357816ULL, 0x008fca000000006aULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x00000100363c7824ULL, 0x020fe200078e00ffULL,
0x00000034142c723cULL, 0x000fe8000004182cULL, 0x00000018ff727819ULL, 0x000fe4000001143cULL,
0x0000003d00697306ULL, 0x0004e20000202400ULL, 0x0000541068347816ULL, 0x002fe4000000006fULL,
0x0000541066357816ULL, 0x000fc4000000006dULL, 0x00008880373c7816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x00008880363d7816ULL, 0x044fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000018ff377819ULL, 0x000fc60000011437ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000005c006b7306ULL, 0x000e640000202400ULL,
0x0000541064347816ULL, 0x008fcc0000000069ULL, 0x0000005e005e7306ULL, 0x000ea20000202400ULL,
0x0000541062357816ULL, 0x002fce000000006bULL, 0x0000006000607306ULL, 0x000e620000202400ULL,
0x000000341424723cULL, 0x000fee0000041824ULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x0000541065357816ULL, 0x004fe4000000005eULL, 0x0000541067347816ULL, 0x002fca0000000060ULL,
0x00000072005c7306ULL, 0x000e620000202400ULL, 0x000000040a607824ULL, 0x000fe200078e025fULL,
0x000000341420723cULL, 0x000fe80000041820ULL, 0x0000000260607810ULL, 0x000fe40007ffe05bULL,
0x0000003c003c7306ULL, 0x000ea20000202400ULL, 0x000000085b5b7824ULL, 0x000fca00078e00ffULL,
0xfffffff85b607812ULL, 0x000fe400078ee260ULL, 0x0000003e00637306ULL, 0x000fe20000202400ULL,
0x000054103d347816ULL, 0x002fe4000000005cULL, 0x000054103c357816ULL, 0x004fca0000000061ULL,
0x0000005800587306ULL, 0x000e640000202400ULL, 0x00000034141c723cULL, 0x000fec000004181cULL,
0x0000004900497306ULL, 0x000fe20000202400ULL, 0x000000085d357824ULL, 0x000fe200078e00ffULL,
0x0000541063587816ULL, 0x002fcc0000000058ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x000000014a347824ULL, 0x000fe400078e025dULL, 0x00000010604a7824ULL, 0x000fc600078e024bULL,
0xfffffff8354b7812ULL, 0x000fe400078ee234ULL, 0x0000005900597306ULL, 0x000fe60000202400ULL,
0x000000104b3c7824ULL, 0x000fca00078e0248ULL, 0x0000003600367306ULL, 0x000e700000202400ULL,
0x0000003f003e7306ULL, 0x000ea20000202400ULL, 0x0000541036367816ULL, 0x002fce0000000049ULL,
0x00000037005e7306ULL, 0x000e620000202400ULL, 0x000054103e597816ULL, 0x004fce0000000059ULL,
0x000000581428723cULL, 0x000fe20000041828ULL, 0x000054105e377816ULL, 0x002fce0000000053ULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x011000004a14783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x084fe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x000000085d367824ULL, 0x000fe200078e00ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ec0ffULL, 0x0000000234497836ULL, 0x000fc80000000000ULL,
0x000000010d4e7824ULL, 0x000fe200078e024eULL, 0xfffffff836497812ULL, 0x000fca00078ee249ULL,
0x0000001049347824ULL, 0x000fcc00078e0248ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x00000018ff697819ULL, 0x008fe2000001143cULL, 0x000001003c5b7824ULL, 0x040fe200078e00ffULL,
0x000088803c6a7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe2000001143dULL, 0x000001003d5c7824ULL, 0x040fe200078e00ffULL,
0x000088803d6b7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x00000018ff5b7819ULL, 0x000fc4000001145bULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff617819ULL, 0x000fe2000001143eULL,
0x0000003c006c7306ULL, 0x0007e20000202400ULL, 0x000088803e657816ULL, 0x000fe400000000ffULL,
0x00000018ff5a7819ULL, 0x022fe40000011434ULL, 0x00000018ff597819ULL, 0x000fc40000011435ULL,
0x00008880345d7816ULL, 0x000fe200000000ffULL, 0x0000005b006d7306ULL, 0x0003620000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x000088803f647816ULL, 0x040fe400000000ffULL,
0x00000018ff607819ULL, 0x000fe2000001143fULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x000001003e5b7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011437ULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x0000005c006e7306ULL, 0x0002e20000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff537819ULL, 0x000fca0000011436ULL,
0x0000003d006f7306ULL, 0x0007e20000202400ULL, 0x00008880355c7816ULL, 0x002fce00000000ffULL,
0x0000003c00677306ULL, 0x0003e20000202400ULL, 0x00000100343d7824ULL, 0x04cfe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006900697306ULL, 0x000ea20000202400ULL, 0x00000100353c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001143cULL, 0x0000006800687306ULL, 0x000e620000202400ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880363c7816ULL, 0x000fca00000000ffULL,
0x0000005b00667306ULL, 0x000ff00000202400ULL, 0x0000003e00627306ULL, 0x000ff00000202400ULL,
0x00000034005b7306ULL, 0x000bf00000202400ULL, 0x00000035003e7306ULL, 0x0007e20000202400ULL,
0x000054106a347816ULL, 0x020fe2000000006dULL, 0x00000100376a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000006500657306ULL, 0x000f620000202400ULL,
0x000054106b357816ULL, 0x008fce000000006eULL, 0x0000006400647306ULL, 0x000ee20000202400ULL,
0x000000341418723cULL, 0x000fee0000041818ULL, 0x000054106c347816ULL, 0x004fe20000000069ULL,
0x0000006100617306ULL, 0x000ea20000202400ULL, 0x000054106f357816ULL, 0x002fce0000000068ULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x00000034142c723cULL, 0x000fee000004182cULL,
0x0000003f00637306ULL, 0x0002a20000202400ULL, 0x0001000036357824ULL, 0x000fe200078e00ffULL,
0x0000541065347816ULL, 0x020fc80000000066ULL, 0x00000018ff657819ULL, 0x000fe40000011435ULL,
0x0000541064357816ULL, 0x008fe20000000067ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x00008880373f7816ULL, 0x042fe200000000ffULL, 0x0001000037377824ULL, 0x000fc800078e00ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000003d005e7306ULL, 0x0002ea0000202400ULL, 0x0000541062347816ULL, 0x004fe40000000061ULL,
0x0000541063357816ULL, 0x000fe20000000060ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00000100363d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x0000005f005f7306ULL, 0x000e6c0000202400ULL,
0x000054105d347816ULL, 0x008fe4000000005eULL, 0x0000005a005a7306ULL, 0x000ea20000202400ULL,
0x000054105c357816ULL, 0x002fce000000005fULL, 0x0000005900597306ULL, 0x000e620000202400ULL,
0x000000341424723cULL, 0x000fee0000041824ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x000054105b347816ULL, 0x004fe4000000005aULL, 0x000054103e357816ULL, 0x002fca0000000059ULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x00000001ff597424ULL, 0x000fe200078e00ffULL,
0x000000341420723cULL, 0x000fec0000041820ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x000000080a347824ULL, 0x000fe200078e020dULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x0176c859343479a7ULL, 0x00026e000850003fULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x017688594eff79a7ULL, 0x0003ee000850003fULL,
0x0000006a00367306ULL, 0x000eb00000202400ULL, 0x0000006500647306ULL, 0x000ee20000202400ULL,
0x000054103f3d7816ULL, 0x004fce0000000036ULL, 0x0000003700377306ULL, 0x000ea20000202400ULL,
0x0000003c141c723cULL, 0x000fe2000004181cULL, 0x0000541064647816ULL, 0x008fe40000000053ULL,
0x0000541037657816ULL, 0x004fce0000000058ULL, 0x000000641410723cULL, 0x002fde0000041810ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035040075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000001040167824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x000000044c3e7c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe016147812ULL, 0x000fe400078ec0ffULL, 0x000000403e3e7824ULL, 0x000fc600078e00ffULL,
0x0000010005147824ULL, 0x000fc800078e0214ULL, 0x0000008014157836ULL, 0x000fca0000000000ULL,
0x0000002015147812ULL, 0x000fca00078ec0ffULL, 0x000000010b177824ULL, 0x000fe200078e0214ULL,
0x0000000400009947ULL, 0x000fec0003800000ULL, 0x0000001016377812ULL, 0x000fe400078ec0ffULL,
0x00000003ff167819ULL, 0x000fe4000001160eULL, 0x0000001539147248ULL, 0x000fc60007fe0000ULL,
0x0000000116367824ULL, 0x000fe400078e0237ULL, 0x0000000114147824ULL, 0x000fe400078e0a15ULL,
0x0000000136157824ULL, 0x040fe400078e020eULL, 0x0000000836347824ULL, 0x000fe200078e00ffULL,
0x0000001437147248ULL, 0x000fe20007fe0000ULL, 0x00000004163c7836ULL, 0x000fe40000000000ULL,
0x00000008163d7836ULL, 0x000fe20000000000ULL, 0xfffffff834537812ULL, 0x000fe200078ee215ULL,
0x0000000114147824ULL, 0x000fe200078e0a37ULL, 0x00008e00ff347b82ULL, 0x000e620000000a00ULL,
0x0000000136367824ULL, 0x000fc600078e0217ULL, 0x000000143c00720cULL, 0x0c0fe20003f66070ULL,
0x000000013c3c7824ULL, 0x100fe200078e0237ULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000c16167836ULL, 0x000fe20000000000ULL, 0x000000143d00720cULL, 0x0c0fe20003f46070ULL,
0x000000013d3d7824ULL, 0x100fe400078e0237ULL, 0x000000013c157824ULL, 0x000fe200078e020eULL,
0x000000141600720cULL, 0x000fe20003f06070ULL, 0x000000083c4c7824ULL, 0x000fe400078e00ffULL,
0x0000000116377824ULL, 0x000fc400078e0237ULL, 0x000000013c3c7824ULL, 0x100fe200078e0217ULL,
0xfffffff84c597812ULL, 0x000fe200078ee215ULL, 0x000000013d167824ULL, 0x100fe400078e0217ULL,
0x0000000137147824ULL, 0x040fe400078e0217ULL, 0x0000000137177824ULL, 0x140fe200078e020eULL,
0x000000343e3f7211ULL, 0x042fe200078a38ffULL, 0x00000008374e7824ULL, 0x000fe400078e00ffULL,
0x000000013d157824ULL, 0x040fe200078e020eULL, 0x000000353e5b7211ULL, 0x000fe200028f3cffULL,
0x000000083d4c7824ULL, 0x000fe200078e00ffULL, 0xfffffff84e5f7812ULL, 0x000fe200078ee217ULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff84c5d7812ULL, 0x000fe200078ee215ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004436347212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000443c367212ULL, 0x080fe400078efcffULL,
0x000000343f347210ULL, 0x000fe20007fbe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003f36367210ULL, 0x000fe40007fde0ffULL, 0x0000004416167212ULL, 0x080fe200078efcffULL,
0x0000000137357824ULL, 0x100fe200028e065bULL, 0x0000004414147212ULL, 0x000fe200078efcffULL,
0x000000013d377824ULL, 0x000fe200030e065bULL, 0x0000003f16167210ULL, 0x000fe20007fbe0ffULL,
0x00000010533d7824ULL, 0x100fe200078e0248ULL, 0x0000003f14147210ULL, 0x000fe20007fde0ffULL,
0x00000010593f7824ULL, 0x000fc400078e0248ULL, 0x000000105d537824ULL, 0x100fe200078e0248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343d7faeULL, 0x0003e2000e101c46ULL,
0x0000000117177824ULL, 0x100fe400028e065bULL, 0x000000105f597824ULL, 0x000fe200078e0248ULL,
0x00000000363f7faeULL, 0x0003e2000d901c46ULL, 0x0000000115157824ULL, 0x000fc600030e065bULL,
0x0000000016537faeULL, 0x0003e8000d101c46ULL, 0x0000000014597faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x00008e00ff367b82ULL, 0x000e620000000a00ULL,
0x0000001016157812ULL, 0x000fc800078ec0ffULL, 0x000000150e157211ULL, 0x000fca00078fe8ffULL,
0x0000000115147824ULL, 0x040fe400078e020eULL, 0x00000008153f7824ULL, 0x040fe400078e00ffULL,
0x0000000415167836ULL, 0x000fe40000000000ULL, 0x0000000815357836ULL, 0x000fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL, 0x0000000c153d7836ULL, 0x000fe40000000000ULL,
0x00000001153c7824ULL, 0x000fc400078e0217ULL, 0x0000000116347824ULL, 0x140fe400078e0217ULL,
0x0000000116157824ULL, 0x100fe200078e020eULL, 0x000000363e537211ULL, 0x002fe200078038ffULL,
0x00000008164c7824ULL, 0x000fe400078e00ffULL, 0x0000000135167824ULL, 0x100fe200078e0217ULL,
0x000000373e5b7211ULL, 0x000fe200000f3cffULL, 0x000000013d147824ULL, 0x000fe200078e0217ULL,
0xfffffff84c597812ULL, 0x000fe200078ee215ULL, 0x0000000135177824ULL, 0x000fc400078e020eULL,
0x00000008354e7824ULL, 0x000fe400078e00ffULL, 0x000000013d357824ULL, 0x040fe400078e020eULL,
0x000000083d587824ULL, 0x000fe200078e00ffULL, 0xfffffff84e5d7812ULL, 0x000fe200078ee217ULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff8585f7812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000000443c367212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003653367210ULL, 0x000fe40007f1e0ffULL,
0x0000004434347212ULL, 0x080fe200078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004416167212ULL, 0x000fc600078efcffULL, 0x000000013d377824ULL, 0x100fe200000e065bULL,
0x0000004414147212ULL, 0x000fe200078efcffULL, 0x000000103f3d7824ULL, 0x100fe200078e0248ULL,
0x0000003453347210ULL, 0x000fe20007f1e0ffULL, 0x00000010593f7824ULL, 0x100fe200078e0248ULL,
0x0000001653167210ULL, 0x000fe20007f5e0ffULL, 0x000000105f597824ULL, 0x100fe200078e0248ULL,
0x0000001453147210ULL, 0x000fe20007f7e0ffULL, 0x0000000135357824ULL, 0x000fe200000e065bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000363d7faeULL, 0x0003e2000b901c46ULL,
0x000000105d537824ULL, 0x000fc400078e0248ULL, 0x0000000117177824ULL, 0x100fe200010e065bULL,
0x00000000343f7faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc600018e065bULL,
0x0000000016537faeULL, 0x0003e8000b901c46ULL, 0x0000000014597faeULL, 0x0003e4000b901c46ULL,
0x0000000209177836ULL, 0x002fe40000000000ULL, 0xffffffffff537424ULL, 0x000fc600078e00ffULL,
0x0000003a1700720cULL, 0x000fe20003f06070ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d167824ULL, 0x000fe400078e0216ULL,
0x00009000ff148b82ULL, 0x000e620000000a00ULL, 0x0000000106178824ULL, 0x000fe400078e0217ULL,
0x00000000160472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176a804047890ULL, 0x000fe2000fffe03fULL, 0x0000000417148825ULL, 0x002fd000078e0014ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a44ULL, 0x0000000614538981ULL, 0x000322000c1e1900ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0176a817165879a7ULL, 0x0004e2000850003fULL, 0x01762817521479a7ULL, 0x002464000850003fULL,
0x0000000000167805ULL, 0x004fce0000015200ULL, 0x01762815520075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003416377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e17ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01762815520075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002040147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x000000800d147810ULL, 0x000fc80007ffe014ULL,
0x0000001447147210ULL, 0x000fca0007ffe044ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0004a20000000800ULL, 0x000000551600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x000000010c157836ULL, 0x000fe20000000000ULL,
0x000000551600720bULL, 0x000fc80003f14000ULL, 0x000000401500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000804015a824ULL, 0x000fe200078e020dULL,
0x000000551614a209ULL, 0x000fc80007810000ULL, 0x000000154737a210ULL, 0x000fe40007ffe044ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005516147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005514147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160eULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001554547220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005516557209ULL, 0x000fd60007810000ULL,
0x8000005516160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005417547221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d377824ULL, 0x000fc800078e0216ULL,
0x0176b057370075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x000140004f487836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x00000010514e7824ULL, 0x000fd800078e0248ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011800005014783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000004e3c783bULL, 0x000f620000004200ULL, 0x000000104d347824ULL, 0x000fcc00078e0248ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x00000018ff6a7819ULL, 0x022fe2000001143cULL,
0x000001003c5b7824ULL, 0x040fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe2000001143dULL,
0x000001003d5c7824ULL, 0x040fe200078e00ffULL, 0x000088803c6b7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d6c7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5a7819ULL, 0x008fe40000011434ULL,
0x00008880345e7816ULL, 0x000fe200000000ffULL, 0x0000005b006e7306ULL, 0x0003e20000202400ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x00000018ff617819ULL, 0x000fe4000001143fULL,
0x000088803f657816ULL, 0x000fc400000000ffULL, 0x00000018ff577819ULL, 0x000fe20000011435ULL,
0x0000003c006d7306ULL, 0x0007e20000202400ULL, 0x000001003e5b7824ULL, 0x042fe200078e00ffULL,
0x00008880355d7816ULL, 0x000fe400000000ffULL, 0x000088803e667816ULL, 0x040fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x0000003d00707306ULL, 0x0003e20000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe20000011436ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x00000100343d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff567819ULL, 0x000fca0000011437ULL, 0x0000005c006f7306ULL, 0x000e700000202400ULL,
0x0000005b00677306ULL, 0x000ff00000202400ULL, 0x0000003c00687306ULL, 0x0007f00000202400ULL,
0x00000034005b7306ULL, 0x000be20000202400ULL, 0x00000100353c7824ULL, 0x008fc400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006900697306ULL, 0x000ee20000202400ULL, 0x0000010037347824ULL, 0x024fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fc80000011435ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003f00647306ULL, 0x000ff00000202400ULL, 0x00000035005c7306ULL, 0x0003f00000202400ULL,
0x00000034003f7306ULL, 0x0005e20000202400ULL, 0x000054106c357816ULL, 0x002fce000000006fULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x000054106b347816ULL, 0x004fe2000000006eULL,
0x00010000376b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000006500657306ULL, 0x000ea20000202400ULL, 0x000000341418723cULL, 0x000fee0000041818ULL,
0x000054106d347816ULL, 0x000fe2000000006aULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x0000541070357816ULL, 0x008fce0000000069ULL, 0x0000006100617306ULL, 0x000fe20000202400ULL,
0x00000034142c723cULL, 0x000fee000004182cULL, 0x0000003e00637306ULL, 0x0007620000202400ULL,
0x0000541066347816ULL, 0x002fe40000000067ULL, 0x0000541065357816ULL, 0x004fca0000000068ULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x00000100363e7824ULL, 0x008fe200078e00ffULL,
0x000000341430723cULL, 0x000fe80000041830ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003d005f7306ULL, 0x0002a20000202400ULL, 0x0000541063347816ULL, 0x020fe40000000062ULL,
0x0000541064357816ULL, 0x000fca0000000061ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x00008880363d7816ULL, 0x042fe200000000ffULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x0000003c00607306ULL, 0x0002e20000202400ULL,
0x000054105e347816ULL, 0x004fe4000000005fULL, 0x00000018ff367819ULL, 0x000fca0000011436ULL,
0x0000005a005a7306ULL, 0x000ea20000202400ULL, 0x00008880373c7816ULL, 0x002fe400000000ffULL,
0x000054105d357816ULL, 0x008fca0000000060ULL, 0x0000005700577306ULL, 0x000e640000202400ULL,
0x000000341424723cULL, 0x000fec0000041824ULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x000054105b347816ULL, 0x004fe4000000005aULL, 0x000054105c357816ULL, 0x002fca0000000057ULL,
0x0000003e003e7306ULL, 0x000e640000202400ULL, 0x000000341420723cULL, 0x000fec0000041820ULL,
0x0000003c003c7306ULL, 0x000ea20000202400ULL, 0x000054103d347816ULL, 0x002fce000000003eULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x000054103c357816ULL, 0x004fce000000003fULL,
0x0000005600567306ULL, 0x000fe20000202400ULL, 0x00000034141c723cULL, 0x000fee000004181cULL,
0x0000003600377306ULL, 0x000e700000202400ULL, 0x0000006b006b7306ULL, 0x000ea20000202400ULL,
0x0000541037347816ULL, 0x002fe2000000004cULL, 0x000000104b4c7824ULL, 0x000fe200078e0248ULL,
0x000054106b357816ULL, 0x004fce0000000056ULL, 0x000000341410723cULL, 0x000fe20000041810ULL,
0x011800004a14783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000004c3c783bULL, 0x000ee20000004200ULL,
0x0000001049347824ULL, 0x000fcc00078e0248ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x00000018ff6a7819ULL, 0x008fe2000001143cULL, 0x000001003c5c7824ULL, 0x040fe200078e00ffULL,
0x000088803c6b7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe2000001143dULL, 0x000001003d5d7824ULL, 0x040fe200078e00ffULL,
0x000088803d6c7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x00000018ff5c7819ULL, 0x000fc4000001145cULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff617819ULL, 0x000fe2000001143fULL,
0x0000003c006d7306ULL, 0x0007e20000202400ULL, 0x000088803f667816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x022fe40000011434ULL, 0x00000018ff5a7819ULL, 0x000fc40000011435ULL,
0x00008880345e7816ULL, 0x000fe200000000ffULL, 0x0000005c006e7306ULL, 0x0003620000202400ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x000088803e677816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe4000001143eULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x000001003e5c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fc40000011436ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000005d006f7306ULL, 0x0002e20000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff577819ULL, 0x000fca0000011437ULL,
0x0000003d00707306ULL, 0x0007e20000202400ULL, 0x00008880355d7816ULL, 0x002fce00000000ffULL,
0x0000003c00697306ULL, 0x0003e20000202400ULL, 0x00000100343d7824ULL, 0x04cfe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006a006a7306ULL, 0x000ea20000202400ULL, 0x00000100353c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001143cULL, 0x0000006300637306ULL, 0x000e620000202400ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880363c7816ULL, 0x000fca00000000ffULL,
0x0000005c00687306ULL, 0x000ff00000202400ULL, 0x0000003f00647306ULL, 0x000ff00000202400ULL,
0x00000034005c7306ULL, 0x000bf00000202400ULL, 0x00000035003f7306ULL, 0x0007e20000202400ULL,
0x000054106b347816ULL, 0x020fe2000000006eULL, 0x00000100376b7824ULL, 0x000fcc00078e00ffULL,
0x0000006700677306ULL, 0x000f620000202400ULL, 0x000054106c357816ULL, 0x008fce000000006fULL,
0x0000006600667306ULL, 0x000ee20000202400ULL, 0x000000341418723cULL, 0x000fee0000041818ULL,
0x000054106d347816ULL, 0x004fe2000000006aULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x0000541070357816ULL, 0x002fc40000000063ULL, 0x00000018ff637819ULL, 0x000fca000001146bULL,
0x0000006100617306ULL, 0x000fe20000202400ULL, 0x00000034142c723cULL, 0x000fee000004182cULL,
0x0000003e00657306ULL, 0x0002a20000202400ULL, 0x0000541067347816ULL, 0x020fe40000000068ULL,
0x0000541066357816ULL, 0x008fe20000000069ULL, 0x0001000037667824ULL, 0x000fc800078e00ffULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x00008880373e7816ULL, 0x002fe200000000ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000018ff667819ULL, 0x000fca0000011466ULL,
0x0000003d005f7306ULL, 0x0002e20000202400ULL, 0x0000541065347816ULL, 0x004fe40000000062ULL,
0x0000541064357816ULL, 0x000fca0000000061ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x00000100363d7824ULL, 0x042fe200078e00ffULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x000054105e347816ULL, 0x008fe4000000005fULL,
0x00000018ff367819ULL, 0x000fca0000011436ULL, 0x0000005b005b7306ULL, 0x000ea20000202400ULL,
0x000054105d357816ULL, 0x002fce0000000060ULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x00000002405d7824ULL, 0x000fe200078e00ffULL, 0x000000341424723cULL, 0x000fec0000041824ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000054105c347816ULL, 0x004fe4000000005bULL,
0x000054103f357816ULL, 0x002fca000000005aULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0xfffffff85d5a7812ULL, 0x000fe200078ec0ffULL, 0x000000341420723cULL, 0x000fe80000041820ULL,
0x000000010d5a7824ULL, 0x000fe400078e025aULL, 0x0000003e003e7306ULL, 0x000fe20000202400ULL,
0x000054103c347816ULL, 0x002fce000000003dULL, 0x0000006300637306ULL, 0x000e620000202400ULL,
0x00000001ff3d7424ULL, 0x000fce00078e00ffULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x000054103e357816ULL, 0x002fce0000000063ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x00000034141c723cULL, 0x000fee000004181cULL, 0x0000003600377306ULL, 0x0002b00000202400ULL,
0x0000006600667306ULL, 0x000ee20000202400ULL, 0x000000080a367824ULL, 0x002fc800078e020dULL,
0x0176c83d363479a7ULL, 0x000262000850003fULL, 0x0000541037567816ULL, 0x004fe20000000056ULL,
0x0176903d5aff79a7ULL, 0x0005e2000850003fULL, 0x0000541066577816ULL, 0x008fce0000000057ULL,
0x000000561410723cULL, 0x000fde0000041810ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035040075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001040147824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x00000004533e7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe014167812ULL, 0x000fe400078ec0ffULL,
0x000000403e3e7824ULL, 0x000fc600078e00ffULL, 0x0000010005167824ULL, 0x000fc800078e0216ULL,
0x000000c016177836ULL, 0x000fca0000000000ULL, 0x0000002017167812ULL, 0x000fca00078ec0ffULL,
0x000000010b167824ULL, 0x000fe200078e0216ULL, 0x0000000400009947ULL, 0x000fec0003800000ULL,
0x0000001014347812ULL, 0x000fe400078ec0ffULL, 0x0000001739147248ULL, 0x000fe40007fe0000ULL,
0x00000003ff357819ULL, 0x000fc6000001160eULL, 0x0000000114177824ULL, 0x000fe400078e0a17ULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x0000000135377824ULL, 0x000fe400078e0234ULL,
0x0000001734177248ULL, 0x000fe20007fe0000ULL, 0x00000004353c7836ULL, 0x000fe40000000000ULL,
0x0000000137367824ULL, 0x000fe400078e020eULL, 0x0000000117177824ULL, 0x000fc400078e0a34ULL,
0x0000000837537824ULL, 0x000fe400078e00ffULL, 0x00000008353d7836ULL, 0x004fe20000000000ULL,
0x000000173500720cULL, 0x080fe20003f86070ULL, 0x0000000c35567836ULL, 0x000fe20000000000ULL,
0xfffffff853537812ULL, 0x000fe200078ee236ULL, 0x000000013c357824ULL, 0x140fe200078e0234ULL,
0x000000173d00720cULL, 0x0c0fe20003f46070ULL, 0x000000013d3f7824ULL, 0x100fe200078e0234ULL,
0x000000173c00720cULL, 0x080fe20003f66070ULL, 0x00000001565d7824ULL, 0x040fe200078e0234ULL,
0x000000175600720cULL, 0x000fe20003f06070ULL, 0x0000000137367824ULL, 0x000fc400078e0216ULL,
0x0000000135347824ULL, 0x040fe200078e020eULL, 0x000000143e3d7211ULL, 0x002fe200078a38ffULL,
0x0000000835577824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee234ULL, 0x0000000135347824ULL, 0x000fe200078e0216ULL,
0x0000004436367212ULL, 0x000fe200078efcffULL, 0x000000013f177824ULL, 0x040fe400078e020eULL,
0x000000083f3c7824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff83c5b7812ULL, 0x000fe200078ee217ULL, 0x000000013f147824ULL, 0x100fe200078e0216ULL,
0x000000153e3f7211ULL, 0x000fe200028f3cffULL, 0x000000015d167824ULL, 0x000fe200078e0216ULL,
0x000000363d367210ULL, 0x000fe20007fbe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004434347212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004414147212ULL, 0x000fc600078efcffULL, 0x0000000137377824ULL, 0x100fe200028e063fULL,
0x0000003d34347210ULL, 0x000fe20007fbe0ffULL, 0x000000015d3c7824ULL, 0x040fe200078e020eULL,
0x0000004416167212ULL, 0x000fe200078efcffULL, 0x000000085d5d7824ULL, 0x000fe400078e00ffULL,
0x0000000135357824ULL, 0x100fe200028e063fULL, 0x0000003d14147210ULL, 0x000fe20007fbe0ffULL,
0x0000001053537824ULL, 0x100fe200078e0248ULL, 0x0000003d16167210ULL, 0x000fe20007fde0ffULL,
0x0000001057577824ULL, 0x100fe200078e0248ULL, 0xfffffff85d3d7812ULL, 0x000fe200078ee23cULL,
0x0000000115157824ULL, 0x000fe200028e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036537faeULL, 0x0003e2000e101c46ULL, 0x000000105b5b7824ULL, 0x000fc400078e0248ULL,
0x0000000117177824ULL, 0x000fe200030e063fULL, 0x0000000034577faeULL, 0x0003e2000d901c46ULL,
0x000000103d3d7824ULL, 0x000fc600078e0248ULL, 0x00000000145b7faeULL, 0x0003e8000d101c46ULL,
0x00000000163d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x00008e00ff367b82ULL, 0x000e620000000a00ULL, 0x0000001014157812ULL, 0x000fc800078ec0ffULL,
0x000000150e157211ULL, 0x000fca00078fe8ffULL, 0x0000000115147824ULL, 0x040fe400078e020eULL,
0x00000008153f7824ULL, 0x040fe400078e00ffULL, 0x0000000415177836ULL, 0x000fe40000000000ULL,
0x0000000815357836ULL, 0x000fe20000000000ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL,
0x0000000c153d7836ULL, 0x004fe40000000000ULL, 0x00000001153c7824ULL, 0x000fc400078e0216ULL,
0x0000000117147824ULL, 0x040fe400078e0216ULL, 0x0000000117157824ULL, 0x040fe200078e020eULL,
0x000000363e537211ULL, 0x042fe200078038ffULL, 0x0000000817567824ULL, 0x000fe400078e00ffULL,
0x0000000135177824ULL, 0x100fe200078e0216ULL, 0x000000373e577211ULL, 0x000fe200000f3cffULL,
0x000000013d347824ULL, 0x000fe200078e0216ULL, 0xfffffff8565b7812ULL, 0x000fe200078ee215ULL,
0x0000000135167824ULL, 0x000fc400078e020eULL, 0x00000008355d7824ULL, 0x000fe400078e00ffULL,
0x000000013d357824ULL, 0x040fe400078e020eULL, 0x000000083d5a7824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee216ULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff85a5f7812ULL, 0x000fe200078ee235ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000443c367212ULL, 0x000fc600078efcffULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x0000003653367210ULL, 0x000fe40007f1e0ffULL, 0x0000004414147212ULL, 0x080fe200078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004416167212ULL, 0x080fe400078efcffULL,
0x0000001453147210ULL, 0x000fe20007f5e0ffULL, 0x000000013d377824ULL, 0x100fe200000e0657ULL,
0x0000004434347212ULL, 0x000fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e0248ULL,
0x0000001653167210ULL, 0x000fe20007f1e0ffULL, 0x0000000115157824ULL, 0x100fe200010e0657ULL,
0x0000003453347210ULL, 0x000fe20007f7e0ffULL, 0x000000105b5b7824ULL, 0x000fe200078e0248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000363f7faeULL, 0x0003e2000b901c46ULL,
0x0000000117177824ULL, 0x000fc400000e0657ULL, 0x000000105d5d7824ULL, 0x100fe200078e0248ULL,
0x00000000145b7faeULL, 0x0003e2000b901c46ULL, 0x0000000135357824ULL, 0x000fe400018e0657ULL,
0x000000105f5f7824ULL, 0x000fe200078e0248ULL, 0x00000000165d7faeULL, 0x0003e8000b901c46ULL,
0x00000000345f7faeULL, 0x0003e4000b901c46ULL, 0x0000000309177836ULL, 0x002fe40000000000ULL,
0xffffffffff537424ULL, 0x000fc600078e00ffULL, 0x0000003a1700720cULL, 0x000fe20003f06070ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d167824ULL, 0x000fe400078e0216ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x0000000106178824ULL, 0x000fe400078e0217ULL, 0x00000000160472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000417148825ULL, 0x002fd000078e0014ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x0000000614538981ULL, 0x000322000c1e1900ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0176b017165679a7ULL, 0x0004e2000850003fULL,
0x01764817521479a7ULL, 0x002464000850003fULL, 0x0000000000167805ULL, 0x004fce0000015200ULL,
0x01764815520075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003416377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01764815520075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x000001000d147810ULL, 0x000fc80007ffe014ULL, 0x0000001447147210ULL, 0x000fca0007ffe044ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000551600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x000000020c157836ULL, 0x000fe20000000000ULL, 0x000000551600720bULL, 0x000fc80003f14000ULL,
0x000000401500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000804015a824ULL, 0x000fe200078e020dULL, 0x000000551614a209ULL, 0x000fc80007810000ULL,
0x000000154737a210ULL, 0x000fe40007ffe044ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400143700a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005516147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005514147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160eULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001554547220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005516557209ULL, 0x000fd60007810000ULL, 0x8000005516160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005417547221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d377824ULL, 0x000fc800078e0216ULL, 0x0176a859370075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176a859370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x000130004f527836ULL, 0x000fc60000000000ULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x00000010513c7824ULL, 0x000fd800078e0252ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x012000005014783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x000000104d347824ULL, 0x000fcc00078e0252ULL, 0x000000003434783bULL, 0x000f640000004200ULL,
0x00000018ff637819ULL, 0x022fe2000001143cULL, 0x000001003c587824ULL, 0x040fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe2000001143dULL, 0x000001003d597824ULL, 0x040fe200078e00ffULL,
0x000088803c667816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d697816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff517819ULL, 0x008fe40000011434ULL, 0x00008880345b7816ULL, 0x000fe200000000ffULL,
0x00000058006b7306ULL, 0x0003e20000202400ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff5e7819ULL, 0x000fe4000001143fULL, 0x000088803f657816ULL, 0x000fc400000000ffULL,
0x00000018ff507819ULL, 0x000fe20000011435ULL, 0x0000003c006a7306ULL, 0x0007e20000202400ULL,
0x000001003e587824ULL, 0x042fe200078e00ffULL, 0x00008880355a7816ULL, 0x000fe400000000ffULL,
0x000088803e647816ULL, 0x040fe400000000ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000003d006d7306ULL, 0x0003e20000202400ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011436ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x00000100343d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff4f7819ULL, 0x000fca0000011437ULL,
0x00000059006c7306ULL, 0x000e700000202400ULL, 0x0000005800677306ULL, 0x000ff00000202400ULL,
0x0000003c00687306ULL, 0x0007f00000202400ULL, 0x0000003400587306ULL, 0x000be20000202400ULL,
0x00000100353c7824ULL, 0x008fc400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143cULL, 0x0000006200627306ULL, 0x000ee20000202400ULL,
0x0000010037347824ULL, 0x024fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00008880363c7816ULL, 0x000fe400000000ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003f00617306ULL, 0x000ff00000202400ULL, 0x0000003500597306ULL, 0x0003f00000202400ULL,
0x00000034003f7306ULL, 0x0005e20000202400ULL, 0x0000541069357816ULL, 0x002fce000000006cULL,
0x0000006400647306ULL, 0x000e620000202400ULL, 0x0000541066347816ULL, 0x004fce000000006bULL,
0x0000006500657306ULL, 0x000ea20000202400ULL, 0x000000341418723cULL, 0x000fee0000041818ULL,
0x000054106a347816ULL, 0x000fe20000000063ULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x000054106d357816ULL, 0x008fce0000000062ULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x00000034142c723cULL, 0x000fee000004182cULL, 0x0000003e00607306ULL, 0x0007620000202400ULL,
0x0000541064347816ULL, 0x002fe40000000067ULL, 0x0000541065357816ULL, 0x004fca0000000068ULL,
0x0000003d005c7306ULL, 0x0003e20000202400ULL, 0x00008880373e7816ULL, 0x048fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x000000341430723cULL, 0x000fe80000041830ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000005b005b7306ULL, 0x000ea20000202400ULL,
0x00000100363d7824ULL, 0x002fe200078e00ffULL, 0x0000541060347816ULL, 0x020fe2000000005fULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000541061357816ULL, 0x000fc4000000005eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x000000341428723cULL, 0x000fea0000041828ULL,
0x0000005d005d7306ULL, 0x000e640000202400ULL, 0x000054105b347816ULL, 0x004fcc000000005cULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000054105a357816ULL, 0x002fce000000005dULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x000000341424723cULL, 0x000fee0000041824ULL,
0x0000005100517306ULL, 0x000ea20000202400ULL, 0x000054103c3c7816ULL, 0x002fce000000003dULL,
0x0000005000507306ULL, 0x000e620000202400ULL, 0x0000541058347816ULL, 0x004fce0000000051ULL,
0x0000004d004d7306ULL, 0x000fe20000202400ULL, 0x0000541059357816ULL, 0x002fce0000000050ULL,
0x0000004f004f7306ULL, 0x000fe20000202400ULL, 0x000000341420723cULL, 0x000fee0000041820ULL,
0x0000003e003e7306ULL, 0x000e700000202400ULL, 0x0000003600367306ULL, 0x000ea20000202400ULL,
0x000054103e3d7816ULL, 0x002fce000000003fULL, 0x0000003700627306ULL, 0x000e620000202400ULL,
0x0000003c141c723cULL, 0x000fe2000004181cULL, 0x0000541036367816ULL, 0x004fcc000000004dULL,
0x000000104b3c7824ULL, 0x000fe200078e0252ULL, 0x0000541062377816ULL, 0x002fce000000004fULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x012000004a14783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x084fe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x0000001049347824ULL, 0x000fcc00078e0252ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x00000018ff5d7819ULL, 0x008fe2000001143cULL,
0x000001003c4f7824ULL, 0x040fe200078e00ffULL, 0x000088803c597816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001143dULL,
0x000001003d507824ULL, 0x040fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000088803d637816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x00000018ff517819ULL, 0x000fe2000001143fULL,
0x0000004f00667306ULL, 0x0007e20000202400ULL, 0x000088803f5f7816ULL, 0x000fe400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5b7819ULL, 0x000fe4000001143eULL,
0x000088803e5e7816ULL, 0x040fe200000000ffULL, 0x0000003c00627306ULL, 0x000be20000202400ULL,
0x000001003e4f7824ULL, 0x048fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x022fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc40000011435ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000005900597306ULL, 0x000e620000202400ULL,
0x000001003f3c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011437ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x00000018ff647819ULL, 0x000fc4000001143fULL, 0x00008880353f7816ULL, 0x000fe400000000ffULL,
0x0000888037677816ULL, 0x000fe400000000ffULL, 0x00000018ff497819ULL, 0x000fe20000011436ULL,
0x00000050006a7306ULL, 0x000eb00000202400ULL, 0x0000003d00657306ULL, 0x0007f00000202400ULL,
0x0000004f00617306ULL, 0x000be20000202400ULL, 0x00000100343d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00687306ULL, 0x0007e20000202400ULL,
0x00008880344f7816ULL, 0x060fe200000000ffULL, 0x0001000034347824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000005c005c7306ULL, 0x000f620000202400ULL,
0x00000100353c7824ULL, 0x048fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003e00607306ULL, 0x000fe20000202400ULL, 0x00008880363c7816ULL, 0x000fce00000000ffULL,
0x00000034003e7306ULL, 0x0003f00000202400ULL, 0x0000003500507306ULL, 0x0005e20000202400ULL,
0x0000541059347816ULL, 0x002fe20000000066ULL, 0x000000ffff597224ULL, 0x000fcc00078e0067ULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x0000541063357816ULL, 0x004fe2000000006aULL,
0x0000010037637824ULL, 0x040fe400078e00ffULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000005f005f7306ULL, 0x000ea20000202400ULL,
0x000000341418723cULL, 0x000fe20000041818ULL, 0x00000018ff377819ULL, 0x000fcc0000011437ULL,
0x0000541062347816ULL, 0x000fe2000000005dULL, 0x0000005b005b7306ULL, 0x000ee20000202400ULL,
0x0000541065357816ULL, 0x020fce000000005cULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x00000034142c723cULL, 0x000fee000004182cULL, 0x0000006400647306ULL, 0x000f620000202400ULL,
0x0001000036357824ULL, 0x000fe200078e00ffULL, 0x000054105e347816ULL, 0x002fc80000000061ULL,
0x00000018ff5c7819ULL, 0x000fe40000011435ULL, 0x000054105f357816ULL, 0x004fe20000000068ULL,
0x0000004f004f7306ULL, 0x000fec0000202400ULL, 0x000000341430723cULL, 0x000fe40000041830ULL,
0x0000003d00587306ULL, 0x0002aa0000202400ULL, 0x0000541060347816ULL, 0x008fc4000000005bULL,
0x0000541064357816ULL, 0x020fe20000000051ULL, 0x0000003f003f7306ULL, 0x000fe20000202400ULL,
0x00000100363d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x0000005a005a7306ULL, 0x000e6c0000202400ULL,
0x000054104f347816ULL, 0x004fe40000000058ULL, 0x0000004b004b7306ULL, 0x000ea20000202400ULL,
0x000054103f357816ULL, 0x002fce000000005aULL, 0x0000004d004d7306ULL, 0x000e620000202400ULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x000054103e3e7816ULL, 0x004fcc000000004bULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x0000000240347824ULL, 0x000fe200078e00ffULL,
0x00005410503f7816ULL, 0x002fcc000000004dULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x0000003e1420723cULL, 0x000fee0000041820ULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0xfffffff8343e7812ULL, 0x000fe200078ec0ffULL, 0x000000080a347824ULL, 0x000fe200078e020dULL,
0x000054103c3c7816ULL, 0x002fca000000003dULL, 0x0000004a004a7306ULL, 0x000fe20000202400ULL,
0x00000001ff3f7424ULL, 0x000fe400078e00ffULL, 0x000000010d3e7824ULL, 0x000fe400078e023eULL,
0x0176c83f343479a7ULL, 0x000266000850003fULL, 0x0000005900597306ULL, 0x000fe20000202400ULL,
0x0176983f3eff79a7ULL, 0x0003ee000850003fULL, 0x0000006300367306ULL, 0x000eb00000202400ULL,
0x0000005c005c7306ULL, 0x000ee20000202400ULL, 0x00005410593d7816ULL, 0x004fce0000000036ULL,
0x0000003700377306ULL, 0x000ea20000202400ULL, 0x0000003c141c723cULL, 0x000fe2000004181cULL,
0x000054105c5c7816ULL, 0x008fe40000000049ULL, 0x00005410375d7816ULL, 0x004fce000000004aULL,
0x0000005c1410723cULL, 0x002fde0000041810ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035040075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000105157836ULL, 0x000fe40000000000ULL, 0x0000000309097836ULL, 0x000fc60000000000ULL,
0x000000381500720cULL, 0x000fda0003f06070ULL, 0x0000000800180947ULL, 0x000fea0003800000ULL,
0x0000000205097836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000010015157824ULL, 0x000fc600078e0208ULL, 0x000000380900720cULL, 0x000fe20003f06070ULL,
0x0000000453097c24ULL, 0x010fe2000f8e02ffULL, 0x0000002015147812ULL, 0x000fc600078ec0ffULL,
0x0000004009097824ULL, 0x000fe400078e00ffULL, 0x000000010b177824ULL, 0x000fcc00078e0214ULL,
0x0000000400048947ULL, 0x000fea0003800000ULL, 0x0000001539147248ULL, 0x000fe20007fe0000ULL,
0x0000001040167824ULL, 0x000fe200078e00ffULL, 0x00000003ff347819ULL, 0x000fc6000001160eULL,
0x0000000114147824ULL, 0x000fe200078e0a15ULL, 0x0000001016357812ULL, 0x000fe200078ec0ffULL,
0x0000000434367836ULL, 0x000fe40000000000ULL, 0x00000008343c7836ULL, 0x000fe20000000000ULL,
0x0000001435167248ULL, 0x000fe20007fe0000ULL, 0x0000000136377824ULL, 0x100fe200078e0235ULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x0000000c343e7836ULL, 0x000fe40000000000ULL,
0x0000000116167824ULL, 0x000fc400078e0a35ULL, 0x000000013c3d7824ULL, 0x100fe400078e0235ULL,
0x00000008374b7824ULL, 0x040fe200078e00ffULL, 0x000000163400720cULL, 0x0c0fe20003f86070ULL,
0x0000000134347824ULL, 0x100fe200078e0235ULL, 0x000000163c00720cULL, 0x080fe20003f46070ULL,
0x00000001373c7824ULL, 0x100fe200078e020eULL, 0x000000163600720cULL, 0x080fe20003f66070ULL,
0x0000000134367824ULL, 0x000fe200078e020eULL, 0x000000163e00720cULL, 0x000fe20003f06070ULL,
0x0000000834497824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee23cULL,
0x000000013e3f7824ULL, 0x000fc400078e0235ULL, 0x000000013d357824ULL, 0x040fe200078e020eULL,
0xfffffff849497812ULL, 0x000fe200078ee236ULL, 0x000000083d3e7824ULL, 0x000fe400078e00ffULL,
0x00000001343c7824ULL, 0x100fe400078e0217ULL, 0x0000000137347824ULL, 0x100fe200078e0217ULL,
0xfffffff83e4d7812ULL, 0x000fe200078ee235ULL, 0x000000013d167824ULL, 0x100fe400078e0217ULL,
0x000000013f367824ULL, 0x000fc400078e0217ULL, 0x000000013f177824ULL, 0x040fe400078e020eULL,
0x000000083f4a7824ULL, 0x000fe200078e00ffULL, 0x00000014093f7211ULL, 0x002fe200078a38ffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff84a4f7812ULL, 0x000fe200078ee217ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000000443c147212ULL, 0x080fe400078efcffULL,
0x0000001509097211ULL, 0x000fe200028f3cffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004434347212ULL, 0x000fe400078efcffULL, 0x000000143f147210ULL, 0x000fe20007fbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000003f34347210ULL, 0x000fc40007fde0ffULL,
0x0000004416167212ULL, 0x080fe200078efcffULL, 0x000000013d157824ULL, 0x100fe200028e0609ULL,
0x0000004436367212ULL, 0x000fe200078efcffULL, 0x0000000135357824ULL, 0x100fe200030e0609ULL,
0x0000003f16167210ULL, 0x000fe20007fbe0ffULL, 0x0000001049497824ULL, 0x100fe200078e0252ULL,
0x0000003f36367210ULL, 0x000fe20007fde0ffULL, 0x000000104b4b7824ULL, 0x100fe400078e0252ULL,
0x000000104d4d7824ULL, 0x000fe200078e0252ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014497faeULL, 0x0003e2000e101c46ULL, 0x0000000117177824ULL, 0x000fc400028e0609ULL,
0x000000104f4f7824ULL, 0x000fe200078e0252ULL, 0x00000000344b7faeULL, 0x0003e2000d901c46ULL,
0x0000000137377824ULL, 0x000fc600030e0609ULL, 0x00000000164d7faeULL, 0x0003e8000d101c46ULL,
0x00000000364f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x0000001040147824ULL, 0x000fca00078e00ffULL, 0x0000001014157812ULL, 0x000fc800078ec0ffULL,
0x000000150e347211ULL, 0x000fe400078fe8ffULL, 0x00008e00ff147b82ULL, 0x000e660000000a00ULL,
0x0000000134167824ULL, 0x040fe400078e020eULL, 0x00000008343f7824ULL, 0x000fe400078e00ffULL,
0x0000000434357836ULL, 0x000fe40000000000ULL, 0x00000008343d7836ULL, 0x000fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL, 0x0000000c343e7836ULL, 0x000fc40000000000ULL,
0x0000000134167824ULL, 0x100fe400078e0217ULL, 0x0000000135347824ULL, 0x140fe400078e0217ULL,
0x0000000135377824ULL, 0x140fe400078e020eULL, 0x00000008354a7824ULL, 0x000fe400078e00ffULL,
0x000000013d367824ULL, 0x100fe400078e0217ULL, 0x000000013e3c7824ULL, 0x000fe200078e0217ULL,
0x0000001409497211ULL, 0x002fe200078038ffULL, 0x000000013d357824ULL, 0x040fe200078e020eULL,
0xfffffff84a4b7812ULL, 0x000fe200078ee237ULL, 0x000000083d507824ULL, 0x000fe200078e00ffULL,
0x0000001509097211ULL, 0x000fe200000f3cffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff8504d7812ULL, 0x000fe200078ee235ULL, 0x000000013e3d7824ULL, 0x000fe200078e020eULL,
0x0000004416147212ULL, 0x080fe200078efcffULL, 0x000000083e3e7824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000001449147210ULL, 0x000fe40007f1e0ffULL,
0xfffffff83e4f7812ULL, 0x000fe200078ee23dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004434167212ULL, 0x000fc600078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000004436347212ULL, 0x000fc600078efcffULL, 0x0000000117157824ULL, 0x100fe200000e0609ULL,
0x000000443c367212ULL, 0x000fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e0252ULL,
0x0000001649167210ULL, 0x000fe20007f1e0ffULL, 0x000000104b4b7824ULL, 0x100fe200078e0252ULL,
0x0000003449347210ULL, 0x000fe20007f5e0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e0252ULL,
0x0000003649367210ULL, 0x000fe20007f7e0ffULL, 0x0000000135177824ULL, 0x100fe200000e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143f7faeULL, 0x0003e2000b901c46ULL,
0x0000000137357824ULL, 0x000fc400010e0609ULL, 0x000000104f4f7824ULL, 0x000fe200078e0252ULL,
0x00000000164b7faeULL, 0x0003e2000b901c46ULL, 0x000000013d377824ULL, 0x000fc600018e0609ULL,
0x00000000344d7faeULL, 0x0003e8000b901c46ULL, 0x00000000364f7faeULL, 0x0003e4000b901c46ULL,
0x0000000445097836ULL, 0x000fe40000000000ULL, 0xffffffffff537424ULL, 0x000fc600078e00ffULL,
0x0000003a0900720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00009000ff147b82ULL, 0x002e620000000a00ULL, 0x0000000106177824ULL, 0x000fc800078e0209ULL,
0x0000000417147825ULL, 0x002fca00078e0014ULL, 0x0000000614537981ULL, 0x000324000c1e1900ULL,
0x0000000840147824ULL, 0x002fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xfffffff014147812ULL, 0x000fca00078ec0ffULL, 0x000000010d147824ULL, 0x000fca00078e0214ULL,
0x00000000140472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0176a834141479a7ULL, 0x0002a4000850003fULL,
0x01766834073479a7ULL, 0x0022e4000850003fULL, 0x000000ffff497224ULL, 0x006fce00078e0015ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x01766835070075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01766835070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000800c157824ULL, 0x000fe400078e020dULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0x0000018044147810ULL, 0x000fca0007ffe015ULL, 0x0000000147147824ULL, 0x000fca00078e0214ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000551600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x004fea0003800000ULL,
0x000000030c157836ULL, 0x000fe20000000000ULL, 0x000000551600720bULL, 0x000fc80003f14000ULL,
0x000000401500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000804015a824ULL, 0x000fe200078e020dULL, 0x000000551614a209ULL, 0x000fc80007810000ULL,
0x000000154747a210ULL, 0x000fe40007ffe044ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400144700a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005516147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005514147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160eULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001554547220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005516557209ULL, 0x000fd60007810000ULL, 0x8000005516160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005417547221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d377824ULL, 0x000fc800078e0216ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b057370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x0000000440167824ULL, 0x000fe200078e00ffULL,
0x000000080e357812ULL, 0x000fe200078ec0ffULL, 0x000008000c157824ULL, 0x000fe200078e020dULL,
0x000000ff1400720cULL, 0x000fe40003f05270ULL, 0x0000000416167812ULL, 0x000fe200078ec0ffULL,
0x0000001046157824ULL, 0x000fc600078e0215ULL, 0x0000000216457812ULL, 0x000fce00078efcffULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803177836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1714007589ULL, 0x0002e400000e0000ULL, 0x012800001514783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x088fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x0000000735447812ULL, 0x000fe200078ef80eULL,
0x000000004e3c783bULL, 0x000f620000004200ULL, 0x000000450e457211ULL, 0x040fe200078fe0ffULL,
0x0000000243647836ULL, 0x000fe20000000000ULL, 0x000000070e657812ULL, 0x000fe200078ec0ffULL,
0x0000000844357824ULL, 0x040fe400078e00ffULL, 0x0000000144347824ULL, 0x000fe200078e0245ULL,
0x0000000865657812ULL, 0x000fe200078ef80eULL, 0x000000030c667836ULL, 0x000fc60000000000ULL,
0xfffffff835357812ULL, 0x000fe200078ee234ULL, 0x0000000865657824ULL, 0x000fc800078e00ffULL,
0x0000001035357824ULL, 0x000fe200078e0248ULL, 0xfffffff865647812ULL, 0x000fca00078ee264ULL,
0x000000003534783bULL, 0x000f640000004200ULL, 0x000001003c4d7824ULL, 0x068fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe2000001143cULL, 0x000001003d4f7824ULL, 0x000fe200078e00ffULL,
0x000088803c4e7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000005900597306ULL, 0x000fe20000202400ULL, 0x00000018ff5a7819ULL, 0x000fc4000001143dULL,
0x000088803d5e7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001143cULL, 0x00000018ff587819ULL, 0x000fe2000001143eULL,
0x0000004d00617306ULL, 0x0007e20000202400ULL, 0x000088803e3c7816ULL, 0x000fe400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff577819ULL, 0x000fc4000001143fULL,
0x00000018ff4b7819ULL, 0x004fe20000011435ULL, 0x0000004f00637306ULL, 0x0005e20000202400ULL,
0x000001003e4d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000888034517816ULL, 0x000fe400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000003d005f7306ULL, 0x0007e20000202400ULL,
0x000001003f4f7824ULL, 0x044fe200078e00ffULL, 0x000088803f5b7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fc40000011437ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000004d005d7306ULL, 0x0005e20000202400ULL,
0x00000018ff3d7819ULL, 0x008fe2000001143eULL, 0x00000100343e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011436ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000004f00627306ULL, 0x0007e20000202400ULL, 0x00000100354d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc80000011434ULL, 0x00000018ff567819ULL, 0x000fe4000001144dULL,
0x0000004e004e7306ULL, 0x000ea20000202400ULL, 0x00008880354f7816ULL, 0x048fe200000000ffULL,
0x0001000035357824ULL, 0x000fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000005e005e7306ULL, 0x000ef00000202400ULL, 0x0000003500507306ULL, 0x000bf00000202400ULL,
0x00000034004d7306ULL, 0x0005e20000202400ULL, 0x0000010037357824ULL, 0x022fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x0000888037347816ULL, 0x044fe200000000ffULL, 0x0001000037377824ULL, 0x000fcc00078e00ffULL,
0x0000006000607306ULL, 0x000eb00000202400ULL, 0x0000003400437306ULL, 0x000bf00000202400ULL,
0x0000003f005c7306ULL, 0x0003e20000202400ULL, 0x000054104e347816ULL, 0x020fe20000000061ULL,
0x0000080066617824ULL, 0x000fc800078e020dULL, 0x0000001064617824ULL, 0x000fe400078e0261ULL,
0x00000035004e7306ULL, 0x0007e20000202400ULL, 0x00000100363f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003e00527306ULL, 0x0003e20000202400ULL,
0x000054105e357816ULL, 0x008fce0000000063ULL, 0x0000003c003c7306ULL, 0x000ee20000202400ULL,
0x00008880363e7816ULL, 0x042fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x000000341418723cULL, 0x000fe80000041818ULL, 0x00000018ff5e7819ULL, 0x000fe20000011436ULL,
0x0000005800587306ULL, 0x000fe40000202400ULL, 0x000054105f357816ULL, 0x000fc4000000005aULL,
0x00000018ff5a7819ULL, 0x000fe40000011437ULL, 0x0000541060347816ULL, 0x004fe40000000059ULL,
0x0000003d003d7306ULL, 0x000e6a0000202400ULL, 0x00000034142c723cULL, 0x000fe6000004182cULL,
0x0000005700577306ULL, 0x000ea80000202400ULL, 0x000054103c347816ULL, 0x008fc4000000005dULL,
0x000054103d3c7816ULL, 0x002fe40000000058ULL, 0x0000005b005b7306ULL, 0x000e620000202400ULL,
0x000054105c3d7816ULL, 0x004fce0000000057ULL, 0x0000003e003e7306ULL, 0x000fe20000202400ULL,
0x0000003c1428723cULL, 0x000fe20000041828ULL, 0x000054105b357816ULL, 0x002fcc0000000062ULL,
0x0000003f003f7306ULL, 0x000e620000202400ULL, 0x000000341430723cULL, 0x000fee0000041830ULL,
0x0000004a004a7306ULL, 0x000ea20000202400ULL, 0x011000006134783bULL, 0x0006e20000000200ULL,
0x000054103e3e7816ULL, 0x002fcc000000003fULL, 0x0000004b004b7306ULL, 0x000e620000202400ULL,
0x00005410433f7816ULL, 0x000fe4000000004eULL, 0x000054104d4a7816ULL, 0x004fca000000004aULL,
0x0000004600467306ULL, 0x000fe20000202400ULL, 0x0000003e141c723cULL, 0x000fe2000004181cULL,
0x00005410504b7816ULL, 0x002fcc000000004bULL, 0x0000004700477306ULL, 0x000fe20000202400ULL,
0x0000004a1420723cULL, 0x000fee0000041820ULL, 0x0000005100517306ULL, 0x000e700000202400ULL,
0x0000004f004f7306ULL, 0x000fe20000202400ULL, 0x00005410513c7816ULL, 0x002fce0000000052ULL,
0x0000005600567306ULL, 0x000e700000202400ULL, 0x0000005e00597306ULL, 0x000ea20000202400ULL,
0x000054104f3d7816ULL, 0x002fce0000000056ULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x0000003c1424723cULL, 0x000fe20000041824ULL, 0x0000541059467816ULL, 0x004fe40000000046ULL,
0x000054105a477816ULL, 0x002fce0000000047ULL, 0x000000461410723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x008fde0003800000ULL,
0x0000000334347232ULL, 0x080fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x000000004c3c783bULL, 0x000e620000004200ULL, 0x0000001044447812ULL, 0x000fe200078efcffULL,
0x0000000105057836ULL, 0x000fc80000000000ULL, 0x0000000144457824ULL, 0x040fe400078e0245ULL,
0x0000000844447824ULL, 0x000fca00078e00ffULL, 0xfffffff844457812ULL, 0x000fe400078ee245ULL,
0x000088803c147816ULL, 0x042fe200000000ffULL, 0x000001003c157824ULL, 0x040fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001143cULL, 0x000001003d167824ULL, 0x000fe200078e00ffULL,
0x00000014004c7306ULL, 0x0003e20000202400ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x000001003e437824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fc40000011416ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000015004d7306ULL, 0x0004e20000202400ULL, 0x0000001045147824ULL, 0x002fe200078e0248ULL,
0x00000018ff477819ULL, 0x000fe4000001143eULL, 0x00000018ff467819ULL, 0x000fe4000001143fULL,
0x000088803e487816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000003c00587306ULL, 0x0003e20000202400ULL, 0x000000001414783bULL, 0x004ea20000004200ULL,
0x000088803f507816ULL, 0x000fc400000000ffULL, 0x000088803d4e7816ULL, 0x000fe400000000ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001143dULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000004e004e7306ULL, 0x000e620000202400ULL,
0x00000018ff3d7819ULL, 0x000fce000001143dULL, 0x0000003e00567306ULL, 0x000bf00000202400ULL,
0x0000003f00597306ULL, 0x0003e20000202400ULL, 0x00000018ff447819ULL, 0x004fe20000011414ULL,
0x00000100143e7824ULL, 0x060fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011415ULL,
0x00000100153f7824ULL, 0x042fe200078e00ffULL, 0x00008880144f7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000888015527816ULL, 0x040fe200000000ffULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x0000004b004b7306ULL, 0x000e620000202400ULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000010017607824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000004a004a7306ULL, 0x000fe20000202400ULL,
0x00000018ff607819ULL, 0x000fce0000011460ULL, 0x0000003d005b7306ULL, 0x0005700000202400ULL,
0x0000001400577306ULL, 0x0007e20000202400ULL, 0x00000018ff3d7819ULL, 0x004fce0000011417ULL,
0x00000015005c7306ULL, 0x0005e20000202400ULL, 0x000054104c147816ULL, 0x008fce000000004dULL,
0x0000004800487306ULL, 0x000fe20000202400ULL, 0x000054104e157816ULL, 0x004fce000000005dULL,
0x0000004300517306ULL, 0x0004e20000202400ULL, 0x000000143418723cULL, 0x000fee0000041818ULL,
0x0000005000507306ULL, 0x000fe20000202400ULL, 0x00000018ff437819ULL, 0x004fe20000011416ULL,
0x0001000016157824ULL, 0x000fe200078e00ffULL, 0x0000541058147816ULL, 0x002fc8000000004bULL,
0x00000018ff4b7819ULL, 0x000fe20000011415ULL, 0x0000003c005f7306ULL, 0x000e620000202400ULL,
0x000054105b157816ULL, 0x020fce000000004aULL, 0x0000004700477306ULL, 0x000ea20000202400ULL,
0x00000014342c723cULL, 0x000fee000004182cULL, 0x00000043003c7306ULL, 0x000be20000202400ULL,
0x0000541048147816ULL, 0x008fe40000000051ULL, 0x0000541050157816ULL, 0x002fc4000000005fULL,
0x0000541056587816ULL, 0x004fc60000000047ULL, 0x0000004600467306ULL, 0x000e620000202400ULL,
0x0000010016437824ULL, 0x020fe200078e00ffULL, 0x000000143430723cULL, 0x000fe20000041830ULL,
0x00000001ff477424ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011443ULL,
0x00000047041479a7ULL, 0x0004e2000850003fULL, 0x0000888017437816ULL, 0x040fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000003e005a7306ULL, 0x000be80000202400ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000541059597816ULL, 0x002fe20000000046ULL,
0x000000080c047824ULL, 0x004fe200078e020dULL, 0x0000003f00617306ULL, 0x000fe20000202400ULL,
0x00008880163e7816ULL, 0x020fc400000000ffULL, 0x0176a04704ff79a7ULL, 0x0003e4000850003fULL,
0x000000583428723cULL, 0x000fe60000041828ULL, 0x0000003e003e7306ULL, 0x000ff00000202400ULL,
0x0000005e003f7306ULL, 0x000eb00000202400ULL, 0x0000004400447306ULL, 0x000f620000202400ULL,
0x000054103e3e7816ULL, 0x004fce000000003fULL, 0x0000004500457306ULL, 0x000ea20000202400ULL,
0x0000541057447816ULL, 0x020fce0000000044ULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x000054105c457816ULL, 0x004fce0000000045ULL, 0x0000004f004f7306ULL, 0x000ea20000202400ULL,
0x000000443420723cULL, 0x000fee0000041820ULL, 0x0000005200527306ULL, 0x000f620000202400ULL,
0x000054104f5a7816ULL, 0x004fce000000005aULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x00005410525b7816ULL, 0x020fce0000000061ULL, 0x0000006000167306ULL, 0x000ea20000202400ULL,
0x0000005a3424723cULL, 0x000fee0000041824ULL, 0x0000004b004b7306ULL, 0x000f620000202400ULL,
0x00005410433f7816ULL, 0x004fce0000000016ULL, 0x0000001700467306ULL, 0x000ea20000202400ULL,
0x0000003e341c723cULL, 0x000fe2000004181cULL, 0x000054104b3c7816ULL, 0x020fe4000000003cULL,
0x00005410463d7816ULL, 0x004fce000000003dULL, 0x0000003c3410723cULL, 0x000fee0000041810ULL,
0x000000ffff347224ULL, 0x008fe200078e0015ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0xffffff7000789947ULL, 0x002fde000383ffffULL, 0x000000ff3800720cULL, 0x000fda0003f05270ULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x0180000054007836ULL, 0x002fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000a9a000047802ULL, 0x000fce0000000f00ULL, 0x0000008000107944ULL, 0x01cfea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000005400037308ULL, 0x008e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000054ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000001804187220ULL, 0x042fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x000fe20000410000ULL,
0x0000001a051a7220ULL, 0x044fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001305137220ULL, 0x000fce0000410000ULL,
0x0000000000037919ULL, 0x008ee20000000000ULL, 0x0000000140407812ULL, 0x000fe400078ec0ffULL,
0x000000202120723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00001000400d7824ULL, 0x000fe200078e020dULL, 0x0000001c1d1c723eULL, 0x000fc400000010ffULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x000000262726723eULL, 0x000fe400000010ffULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000001e1f1e723eULL, 0x000fe400000010ffULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x000000ff0a00720cULL, 0x000fc40003f05270ULL,
0x000076321e217816ULL, 0x000fe40000000012ULL, 0x00000002ff057819ULL, 0x108fe20000011603ULL,
0x0000000108087824ULL, 0x000fe200078e0203ULL, 0x0000000203007812ULL, 0x042fe400078ec0ffULL,
0x0000000803077811ULL, 0x000fe200078ff0ffULL, 0x00000008050e7824ULL, 0x000fe200078e00ffULL,
0x0000000500027211ULL, 0x000fe200078ff8ffULL, 0x0000001008087824ULL, 0x000fe200078e020dULL,
0x0000000700047211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fc400078e00ffULL,
0x0000000805077824ULL, 0x040fe400078e00ffULL, 0x0000000202007836ULL, 0x000fe20000000000ULL,
0xfffffff809147812ULL, 0x000fe200078ee204ULL, 0x0000000805097824ULL, 0x000fe400078e00ffULL,
0x0000000402047836ULL, 0x000fe20000000000ULL, 0xfffffff807067812ULL, 0x000fe200078ee200ULL,
0x000008000a057824ULL, 0x000fe200078e020dULL, 0xfffffff807007812ULL, 0x000fe200078ee202ULL,
0x0000000602077836ULL, 0x000fe20000000000ULL, 0xfffffff8090c7812ULL, 0x000fe200078ee204ULL,
0x0000000803027824ULL, 0x000fc400078e00ffULL, 0x0000001000047824ULL, 0x100fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x000000181900723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000010ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x0000002a2b19723eULL, 0x000fe200000010ffULL, 0x0000000104057824ULL, 0x000fe200078e0207ULL,
0x0000541000167816ULL, 0x040fe20000000002ULL, 0x0000000107147824ULL, 0x040fe200078e0214ULL,
0x0000763200177816ULL, 0x000fe20000000002ULL, 0x0000000107067824ULL, 0x000fe200078e0206ULL,
0x000000303100723eULL, 0x000fe200000010ffULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000282902723eULL, 0x000fe200000010ffULL, 0x0000000107077824ULL, 0x000fe200078e020eULL,
0x000000242504723eULL, 0x000fe200000010ffULL, 0x0000001605007388ULL, 0x0003e20000000a00ULL,
0x00000010110e723eULL, 0x000fc400000010ffULL, 0x0000541004107816ULL, 0x140fe40000000020ULL,
0x0000763204117816ULL, 0x000fe40000000020ULL, 0x000054101c047816ULL, 0x000fe4000000000eULL,
0x0000541032187816ULL, 0x140fe40000000019ULL, 0x0000763232197816ULL, 0x000fe40000000019ULL,
0x0000541000167816ULL, 0x002fc40000000002ULL, 0x0000763200177816ULL, 0x000fe40000000002ULL,
0x000076321c057816ULL, 0x000fe4000000000eULL, 0x0000001a1b00723eULL, 0x000fe200000010ffULL,
0x0000001606007388ULL, 0x000fe20000000a00ULL, 0x0000002e2f02723eULL, 0x000fe400000010ffULL,
0x000054101e207816ULL, 0x000fe20000000012ULL, 0x000000100c007388ULL, 0x000fe80000000a00ULL,
0x0000000407007388ULL, 0x0003e40000000a00ULL, 0x0000541000047816ULL, 0x002fc40000000002ULL,
0x0000763200057816ULL, 0x000fe40000000002ULL, 0x000000ff00007306ULL, 0x000e660000202400ULL,
0x0000000414007388ULL, 0x0007e80000000a00ULL, 0x0004001806007388ULL, 0x000fe20000000a00ULL,
0x0000541026047816ULL, 0x008fc40000000022ULL, 0x0000763226057816ULL, 0x000fca0000000022ULL,
0x000400040c007388ULL, 0x000fe80000000a00ULL, 0x0004002007007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000008107984ULL, 0x000e680000000c00ULL,
0x0004000008187984ULL, 0x000ee80000000c00ULL, 0x0008000008147984ULL, 0x000f680000000c00ULL,
0x000c0000081c7984ULL, 0x000f620000000c00ULL, 0x0000001300137230ULL, 0x002fc40000200800ULL,
0x0000001200127230ULL, 0x040fe40000200800ULL, 0x0000001100117230ULL, 0x040fe40000200800ULL,
0x0000001000107230ULL, 0x040fe40000200800ULL, 0x0000001b001b7230ULL, 0x048fe40000200800ULL,
0x0000001a001a7230ULL, 0x040fe40000200800ULL, 0x0000001900197230ULL, 0x000fc40000200800ULL,
0x0000001800007230ULL, 0x000fe40000200800ULL, 0x0000001713137230ULL, 0x024fe40000200000ULL,
0x0000001612127230ULL, 0x000fe40000200000ULL, 0x0000001511117230ULL, 0x000fe40000200000ULL,
0x0000001410107230ULL, 0x000fe40000200000ULL, 0x0000001f1b1b7230ULL, 0x000fc40000200000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000200000ULL, 0x0000001008007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000200000ULL, 0x0000001c00187230ULL, 0x000fca0000200000ULL,
0x0004001808007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff067819ULL, 0x000fe20000011603ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x0000003b0600720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00008600ff137b82ULL, 0x002e620000000800ULL,
0x0000000106007824ULL, 0x000fe200078e0203ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x0000000703077812ULL, 0x000fe400078ec0ffULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000000840077824ULL, 0x000fe200078e0207ULL,
0x0ffffff800007812ULL, 0x000fca00078ef803ULL, 0x0000001000027824ULL, 0x000fe400078e020dULL,
0x0000001041007824ULL, 0x000fc600078e0206ULL, 0x0000000002087984ULL, 0x0004e20000000c00ULL,
0x0000001304157219ULL, 0x082fe400000006ffULL, 0x0000001342427219ULL, 0x000fe400000006ffULL,
0x0000001500057212ULL, 0x000fe200078e30ffULL, 0x0000002003027836ULL, 0x004fe20000000000ULL,
0x00000013ff047219ULL, 0x000fe20000011600ULL, 0x000000040f007c24ULL, 0x000fe4000f8e02ffULL,
0x0000000142057824ULL, 0x000fc800078e0205ULL, 0x0000000f04057224ULL, 0x000fca00078e0205ULL,
0x0000000500057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f4406ULL,
0x00000003ff067819ULL, 0x000fe20000011602ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x0000003b0600720cULL, 0x000fe40003f06070ULL, 0x0000000804007986ULL, 0x0083f6000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000102047824ULL, 0x142fe200078e0206ULL,
0x0000000702117812ULL, 0x000fe200078ec0ffULL, 0x0000001041067824ULL, 0x000fc600078e0206ULL,
0x0000000704057812ULL, 0x000fe200078ec0ffULL, 0x0000000840117824ULL, 0x000fc600078e0211ULL,
0x0ffffff805047812ULL, 0x000fca00078ef802ULL, 0x0000001004077824ULL, 0x000fe200078e020dULL,
0x0000001506047212ULL, 0x000fe400078e30ffULL, 0x00000013ff067219ULL, 0x000fe40000011606ULL,
0x0000000007087984ULL, 0x000e620000000c00ULL, 0x0000000142047824ULL, 0x000fc800078e0204ULL,
0x0000000f06057224ULL, 0x000fe400078e0204ULL, 0x0000004003067836ULL, 0x000fc60000000000ULL,
0x0000000500057210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff027819ULL, 0x000fc60000011606ULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f440cULL, 0x0000003b0200720cULL, 0x000fe20003f06070ULL,
0x0000001011047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e0202ULL,
0x0000001041027824ULL, 0x000fe400078e0202ULL, 0x0000006003077836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000001502057212ULL, 0x000fe400078e30ffULL, 0x00000013ff027219ULL, 0x000fe20000011602ULL,
0x0000001004047824ULL, 0x000fe400078e020dULL, 0x0000000142057824ULL, 0x000fc600078e0205ULL,
0x0000000004087984ULL, 0x0002a20000000c00ULL, 0x0000000f02057224ULL, 0x000fca00078e0205ULL,
0x00000005000c7210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff047819ULL, 0x002fe40000011607ULL,
0x0000000706057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x000000080c027c11ULL, 0x000fe2000f8040ffULL, 0x0000000107067824ULL, 0x000fe400078e0204ULL,
0x0000000840057824ULL, 0x000fe200078e0205ULL, 0x000000090c037c11ULL, 0x000fc400080f4403ULL,
0x0000003b0400720cULL, 0x000fe40003f06070ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000001005027825ULL, 0x000fc600078e0002ULL, 0xfffffff806067812ULL, 0x000fe400078ef807ULL,
0x0000000802007986ULL, 0x0043ea000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e020dULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x0000001041047824ULL, 0x000fc600078e0204ULL, 0x0000000006087984ULL, 0x002e620000000c00ULL,
0x0000000840077824ULL, 0x000fe200078e0207ULL, 0x0000001504027212ULL, 0x000fe400078e30ffULL,
0x00000013ff047219ULL, 0x000fc60000011604ULL, 0x0000000142027824ULL, 0x000fc800078e0202ULL,
0x0000000f040f7224ULL, 0x000fca00078e0202ULL, 0x0000000f000f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x000000080f027c11ULL, 0x000fc8000f8040ffULL,
0x000000090f037c11ULL, 0x000fc600080f4400ULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000003a4000720cULL, 0x000fe20003f06070ULL, 0x00009800ff0a7b82ULL, 0x000e620000000a00ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0xffffffffff0f7424ULL, 0x000fd200078e00ffULL,
0x00009400ff048b82ULL, 0x000ea20000000800ULL, 0x0000000215098824ULL, 0x000fce00078e00ffULL,
0x00009000ff068b82ULL, 0x000ee20000000a00ULL, 0x000000060a0a7981ULL, 0x002322000c1e9900ULL,
0x0000000409098224ULL, 0x004fc800078e0240ULL, 0x0000000409068825ULL, 0x008fe400078e0006ULL,
0x017600080d0879a7ULL, 0x000266000850003fULL, 0x00000006060f8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x0000004003027824ULL, 0x000fe400078e00ffULL,
0x0000004040047824ULL, 0x000fe400078e00ffULL, 0x0000004042037824ULL, 0x000fc400078e00ffULL,
0x0000000f022e7224ULL, 0x004fcc00078e02ffULL, 0x0000000c002c0947ULL, 0x002fea0003800000ULL,
0x00000003ff1d7819ULL, 0x000fe2000001160eULL, 0x00008e00ff127b82ULL, 0x000e620000000a00ULL,
0x0000000439077248ULL, 0x000fc60007fe0000ULL, 0x000000041d0b7836ULL, 0x000fe40000000000ULL,
0x0000000107147824ULL, 0x000fe400078e0a04ULL, 0x000000010b067824ULL, 0x140fe400078e020eULL,
0x000000080b0f7824ULL, 0x040fe200078e00ffULL, 0x000000140b00720cULL, 0x080fe20003f86070ULL,
0x000000081d077836ULL, 0x000fe40000000000ULL, 0x0000004042427824ULL, 0x000fe200078e021dULL,
0xfffffff80f1c7812ULL, 0x000fe200078ee206ULL, 0x0000000c1d0f7836ULL, 0x000fe20000000000ULL,
0x000000140700720cULL, 0x040fe20003f06070ULL, 0x00000001070b7824ULL, 0x000fc400078e020eULL,
0x000000010f0c7824ULL, 0x040fe200078e020eULL, 0x000000140f00720cULL, 0x040fe20003f26070ULL,
0x000000080f0f7824ULL, 0x000fe400078e00ffULL, 0x0000000807267824ULL, 0x000fe400078e00ffULL,
0x0000008042067825ULL, 0x000fe200078e00ffULL, 0xfffffff80f287812ULL, 0x000fe400078ee20cULL,
0x000000122e0c7211ULL, 0x002fe200078438ffULL, 0x0000000442107836ULL, 0x000fe20000000000ULL,
0x0000007006217812ULL, 0x000fe200078ef805ULL, 0x0000000842127836ULL, 0x000fe20000000000ULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000132e0b7211ULL, 0x000fc400010f3cffULL, 0x000000210c207210ULL, 0x000fe20007f5e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000070101f7812ULL, 0x000fc600078ef805ULL,
0x0000000c42067836ULL, 0x000fe20000000000ULL, 0x0000007012197812ULL, 0x000fe200078ef805ULL,
0x0000000107217824ULL, 0x000fe200010e060bULL, 0x0000000c1f1e7210ULL, 0x000fe20007f7e0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000c19187210ULL, 0x000fc60007f5e0ffULL,
0x0000001042107836ULL, 0x000fe20000000000ULL, 0x00000070061b7812ULL, 0x000fe200078ef805ULL,
0x0000001442167836ULL, 0x000fe40000000000ULL, 0x0000001842227836ULL, 0x000fe40000000000ULL,
0x00000001111f7824ULL, 0x000fe400018e060bULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007010257812ULL, 0x000fc600078ef805ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x0000000113197824ULL, 0x100fe200010e060bULL,
0x0000000c1b1a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001c1d2d7836ULL, 0x000fe20000000000ULL,
0x0000007016137812ULL, 0x000fe200078ef805ULL, 0x0000001c42167836ULL, 0x000fe20000000000ULL,
0x00000070220f7812ULL, 0x000fe200078ef805ULL, 0x00000001071b7824ULL, 0x100fe200010e060bULL,
0x0000000c25127210ULL, 0x000fe20007f5e0ffULL, 0x000000141d257836ULL, 0x000fe20000000000ULL,
0x0000000c13107210ULL, 0x000fe40007f7e0ffULL, 0x0000000c0f067210ULL, 0x000fe20007fbe0ffULL,
0x0000000111137824ULL, 0x000fc400010e060bULL, 0x0000000117117824ULL, 0x100fe200018e060bULL,
0x000000142500720cULL, 0x080fe20003f66070ULL, 0x0000000123077824ULL, 0x000fe200028e060bULL,
0x000000141d00720cULL, 0x0c0fe20003fa6070ULL, 0x000000011d177824ULL, 0x100fe400078e020eULL,
0x000000101d237836ULL, 0x000fe40000000000ULL, 0x00004000400f7824ULL, 0x000fe200078e020dULL,
0x0000000717297812ULL, 0x000fe200078ec0ffULL, 0x0000000123227824ULL, 0x040fe200078e020eULL,
0x000000142300720cULL, 0x040fe20003f46070ULL, 0x00000008232b7824ULL, 0x000fe200078e00ffULL,
0x0ffffff829247812ULL, 0x000fe200078ef80eULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff82b2a7812ULL, 0x000fe200078ee222ULL, 0x0000000125237824ULL, 0x040fe200078e020eULL,
0x0000007016277812ULL, 0x000fe200078ef805ULL, 0x00000008252c7824ULL, 0x000fe400078e00ffULL,
0x0000002042227836ULL, 0x000fe20000000000ULL, 0x0000000c27167210ULL, 0x000fe20007fde0ffULL,
0x000010000f0f7836ULL, 0x000fe20000000000ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee223ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x0000001024277824ULL, 0x000fe200078e020fULL,
0x00000070222f7812ULL, 0x000fe200078ef805ULL, 0x0000002442247836ULL, 0x000fe40000000000ULL,
0x0000000117177824ULL, 0x000fe200030e060bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e2000e901c46ULL, 0x0000008024247825ULL, 0x000fc800078e00ffULL,
0x000000101c297824ULL, 0x000fe400078e020fULL, 0x000000181d2b7836ULL, 0x000fc60000000000ULL,
0x000000001e297faeULL, 0x0005e2000e101c46ULL, 0x000000142d00720cULL, 0x080fe20003f86070ULL,
0x000000012b1c7824ULL, 0x100fe200078e020eULL, 0x0000000c2f207210ULL, 0x002fe40007fde0ffULL,
0x0000007024277812ULL, 0x000fe200078ef805ULL, 0x000000012d247824ULL, 0x000fe200078e020eULL,
0x000000142b00720cULL, 0x000fe20003fa6070ULL, 0x0000000123217824ULL, 0x000fe200030e060bULL,
0x0000000c27227210ULL, 0x000fe20007fde0ffULL, 0x000000082d2d7824ULL, 0x000fc400078e00ffULL,
0x00000028421e7836ULL, 0x004fe40000000000ULL, 0x0000001026277824ULL, 0x000fe200078e020fULL,
0xfffffff82d247812ULL, 0x000fe200078ee224ULL, 0x000000201d297836ULL, 0x000fe40000000000ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000018277faeULL, 0x0003e4000c101c46ULL,
0x000000142900720cULL, 0x040fe20003f06070ULL, 0x0000000129267824ULL, 0x000fc400078e020eULL,
0x00000008292d7824ULL, 0x000fe200078e00ffULL, 0x000000701e297812ULL, 0x000fe200078ef805ULL,
0x0000000125237824ULL, 0x000fe400030e060bULL, 0x0000001028257824ULL, 0x100fe200078e020fULL,
0xfffffff82d267812ULL, 0x000fe200078ee226ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c29187210ULL, 0x002fe20007fde0ffULL, 0x0000001024277824ULL, 0x100fe200078e020fULL,
0x000000001a257faeULL, 0x0003e2000c901c46ULL, 0x0000001026297824ULL, 0x000fe200078e020fULL,
0xfffffff82b1c7812ULL, 0x000fe200078ee21cULL, 0x000000011f197824ULL, 0x000fc400030e060bULL,
0x000000102c1f7824ULL, 0x100fe400078e020fULL, 0x000000241d2b7836ULL, 0x000fe40000000000ULL,
0x000000381d2d7836ULL, 0x000fe40000000000ULL, 0x000000012b1e7824ULL, 0x040fe200078e020eULL,
0x000000142b00720cULL, 0x000fe20003f26070ULL, 0x000000102a1b7824ULL, 0x002fe400078e020fULL,
0x0000002c421a7836ULL, 0x000fc40000000000ULL, 0x000000101c257824ULL, 0x000fe200078e020fULL,
0x00000000121b7faeULL, 0x0003e2000d101c46ULL, 0x000000082b2b7824ULL, 0x000fc600078e00ffULL,
0x00000000101f7faeULL, 0x0005e4000d901c46ULL, 0xfffffff82b1e7812ULL, 0x000fe400078ee21eULL,
0x0000000006257faeULL, 0x0007e6000e901c46ULL, 0x000000101e2b7824ULL, 0x000fe200078e020fULL,
0x0000000016277faeULL, 0x000be2000e101c46ULL, 0x0000002c1d1b7836ULL, 0x002fe40000000000ULL,
0x000000281d137836ULL, 0x000fe20000000000ULL, 0x0000000020297faeULL, 0x0003e2000c101c46ULL,
0x000000801a107825ULL, 0x004fe200078e00ffULL, 0x000000141b00720cULL, 0x000fc40003f86070ULL,
0x00000000222b7faeULL, 0x0005e2000c901c46ULL, 0x000000301d1f7836ULL, 0x000fe20000000000ULL,
0x0000007010077812ULL, 0x008fe200078ef805ULL, 0x0000003042107836ULL, 0x000fe20000000000ULL,
0x000000141300720cULL, 0x080fe20003fa6070ULL, 0x000000341d257836ULL, 0x000fe20000000000ULL,
0x0000000c07067210ULL, 0x000fe20007fde0ffULL, 0x0000003c1d277836ULL, 0x020fe20000000000ULL,
0x000000141f00720cULL, 0x080fe20003f66070ULL, 0x000000011b177824ULL, 0x000fe200078e020eULL,
0x000000142500720cULL, 0x080fe20003f46070ULL, 0x0000000111077824ULL, 0x000fe200030e060bULL,
0x000000142d00720cULL, 0x080fe20003f26070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000142700720cULL, 0x000fc60003f06070ULL, 0x0000003442127836ULL, 0x000fe40000000000ULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0x00000070101b7812ULL, 0x000fe200078ef805ULL,
0x000000011f107824ULL, 0x100fe400078e020eULL, 0x0000000113147824ULL, 0x040fe200078e020eULL,
0x0000000c1b167210ULL, 0x000fe20007fde0ffULL, 0x00000008131d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL, 0x000000081f1f7824ULL, 0x000fc400078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff81d147812ULL, 0x000fe400078ee214ULL,
0xfffffff81f1e7812ULL, 0x000fe200078ee210ULL, 0x0000003842107836ULL, 0x000fe20000000000ULL,
0x00000070121b7812ULL, 0x000fe200078ef805ULL, 0x0000000111177824ULL, 0x000fe400030e060bULL,
0x0000000125127824ULL, 0x040fe200078e020eULL, 0x0000000c1b1a7210ULL, 0x000fe20007fde0ffULL,
0x0000000825257824ULL, 0x000fc400078e00ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff825207812ULL, 0x002fe200078ee212ULL, 0x0000003c42427836ULL, 0x000fe20000000000ULL,
0x00000070101f7812ULL, 0x000fe200078ef805ULL, 0x00000001131b7824ULL, 0x000fe400030e060bULL,
0x0000008042127825ULL, 0x000fe200078e00ffULL, 0x0000000c1f107210ULL, 0x000fc60007fde0ffULL,
0x000000012d1d7824ULL, 0x140fe200078e020eULL, 0x0000007012057812ULL, 0x000fe200078ef805ULL,
0x000000082d227824ULL, 0x004fe400078e00ffULL, 0x00000001270e7824ULL, 0x040fe400078e020eULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0xfffffff822127812ULL, 0x000fe200078ee21dULL,
0x0000000111117824ULL, 0x000fe400030e060bULL, 0x000000101c1d7824ULL, 0x100fe200078e020fULL,
0xfffffff827227812ULL, 0x000fe200078ee20eULL, 0x000000101e1f7824ULL, 0x100fe200078e020fULL,
0x0000000c050e7210ULL, 0x000fe20007fde0ffULL, 0x0000001014057824ULL, 0x000fc400078e020fULL,
0x0000001020217824ULL, 0x100fe400078e020fULL, 0x0000001012237824ULL, 0x100fe200078e020fULL,
0x0000000018057faeULL, 0x0003e2000e901c46ULL, 0x0000001022257824ULL, 0x000fe400078e020fULL,
0x00000001130f7824ULL, 0x000fe200030e060bULL, 0x00000000061d7faeULL, 0x0003e8000e101c46ULL,
0x00000000161f7faeULL, 0x0003e8000d901c46ULL, 0x000000001a217faeULL, 0x0003e8000d101c46ULL,
0x0000000010237faeULL, 0x0003e8000c901c46ULL, 0x000000000e257faeULL, 0x0003e2000c101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x000000040e0f7811ULL, 0x040fe400078fe8ffULL,
0x000000080e117811ULL, 0x040fe400078fe8ffULL, 0x0000000c0e137811ULL, 0x040fe200078fe8ffULL,
0x000000010f067824ULL, 0x140fe200078e020eULL, 0x000000100e177811ULL, 0x040fe200078fe8ffULL,
0x000000080f1d7824ULL, 0x000fe200078e00ffULL, 0x000000140e167811ULL, 0x040fe200078fe8ffULL,
0x00000008111f7824ULL, 0x000fe200078e00ffULL, 0x000000180e267811ULL, 0x040fe200078fe8ffULL,
0x0000000113077824ULL, 0x100fe200078e020eULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x0000000111067824ULL, 0x100fe200078e020eULL, 0x0000001c0e277811ULL, 0x040fe200078fe8ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x000000240e307811ULL, 0x000fe200078fe8ffULL,
0x00000001170b7824ULL, 0x140fe200078e020eULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x0000000817127824ULL, 0x000fe200078e00ffULL, 0xfffffff810217812ULL, 0x000fe200078ee207ULL,
0x00000001160c7824ULL, 0x100fe200078e020eULL, 0x000000200e2d7811ULL, 0x000fe200078fe8ffULL,
0x0000000816197824ULL, 0x000fe200078e00ffULL, 0xfffffff812237812ULL, 0x000fe200078ee20bULL,
0x0000000126067824ULL, 0x100fe200078e020eULL, 0x000000280e357811ULL, 0x000fe200078fe8ffULL,
0x0000000826297824ULL, 0x000fe200078e00ffULL, 0xfffffff8190c7812ULL, 0x000fe200078ee20cULL,
0x0000000127077824ULL, 0x140fe200078e020eULL, 0x0000002c0e327811ULL, 0x000fe200078fe8ffULL,
0x0000000827107824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee206ULL,
0x0000000130127824ULL, 0x100fe200078e020eULL, 0x000000300e317811ULL, 0x000fe200078fe8ffULL,
0x0000000830197824ULL, 0x000fe200078e00ffULL, 0xfffffff8102b7812ULL, 0x000fe200078ee207ULL,
0x000000012d0b7824ULL, 0x140fe200078e020eULL, 0x000000340e2f7811ULL, 0x040fe200078fe8ffULL,
0x000000082d147824ULL, 0x000fe200078e00ffULL, 0xfffffff819127812ULL, 0x000fe200078ee212ULL,
0x0000000135067824ULL, 0x140fe200078e020eULL, 0x0000003c0e337811ULL, 0x000fe200078fe8ffULL,
0x0000000835197824ULL, 0x000fe200078e00ffULL, 0xfffffff814107812ULL, 0x000fe200078ee20bULL,
0x0000000132077824ULL, 0x100fe200078e020eULL, 0x000000380e347811ULL, 0x000fe200078fe8ffULL,
0x0000000832247824ULL, 0x000fe200078e00ffULL, 0xfffffff819287812ULL, 0x000fe200078ee206ULL,
0x00000001310b7824ULL, 0x000fc400078e020eULL, 0x0000000831227824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x000000012f147824ULL, 0x140fe200078e020eULL,
0x00008e00ff067b82ULL, 0x000e620000000a00ULL, 0x000000082f1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee20bULL, 0x0000400040197824ULL, 0x000fe200078e020dULL,
0x0000000e0e0b7211ULL, 0x000fe200078fe8ffULL, 0x0000000133187824ULL, 0x040fe200078e020eULL,
0xfffffff81b207812ULL, 0x000fe200078ee214ULL, 0x0000000833257824ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000100019197836ULL, 0x000fc40000000000ULL,
0x0000000134147824ULL, 0x040fe200078e020eULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef80eULL,
0x00000008341b7824ULL, 0x000fe200078e00ffULL, 0x000000030e0e7211ULL, 0x000fe200078fe8ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0219ULL, 0xfffffff825187812ULL, 0x000fe200078ee218ULL,
0x000000100c257824ULL, 0x100fe200078e0219ULL, 0xfffffff81b1e7812ULL, 0x000fe200078ee214ULL,
0x00000010100c7824ULL, 0x000fe400078e0219ULL, 0x0000000103107824ULL, 0x000fc400078e020fULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000062e2a7211ULL, 0x002fc600078038ffULL,
0x0000001012147824ULL, 0x000fe200078e0219ULL, 0x000000700e1b7812ULL, 0x000fe200078ef805ULL,
0x0000000103127824ULL, 0x000fe200078e0211ULL, 0x000000072e2e7211ULL, 0x000fe200000f3cffULL,
0x00000010181c7824ULL, 0x000fe200078e0219ULL, 0x0000001b2a067210ULL, 0x000fe20007f1e0ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000103187824ULL, 0x000fe200078e0213ULL,
0x0000007010077812ULL, 0x000fe200078ef805ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x000000072a0e7210ULL, 0x000fe20007f3e0ffULL, 0x000000100b0b7824ULL, 0x100fe200078e0219ULL,
0x00000070121b7812ULL, 0x000fe200078ef805ULL, 0x000000101f1f7824ULL, 0x100fe400078e0219ULL,
0x0000001021217824ULL, 0x100fe400078e0219ULL, 0x0000001023237824ULL, 0x100fe400078e0219ULL,
0x0000001029297824ULL, 0x100fe400078e0219ULL, 0x000000102b2b7824ULL, 0x000fc400078e0219ULL,
0x0000001028287824ULL, 0x100fe400078e0219ULL, 0x0000001024247824ULL, 0x100fe400078e0219ULL,
0x0000001022227824ULL, 0x100fe400078e0219ULL, 0x0000001020207824ULL, 0x100fe400078e0219ULL,
0x000000101e1e7824ULL, 0x000fe400078e0219ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x00000001031a7824ULL, 0x000fe200078e0217ULL, 0x0000007018177812ULL, 0x000fe200078ef805ULL,
0x000000010f077824ULL, 0x000fe200000e062eULL, 0x0000001b2a107210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x000000172a127210ULL, 0x000fe40007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000b901c46ULL,
0x0000000103267824ULL, 0x040fe200078e0226ULL, 0x000000701a177812ULL, 0x000fe200078ef805ULL,
0x00000001032c7824ULL, 0x000fc400078e0227ULL, 0x0000000103367824ULL, 0x000fe400078e022dULL,
0x00000001110f7824ULL, 0x100fe400008e062eULL, 0x0000000113117824ULL, 0x000fe400000e062eULL,
0x0000000103187824ULL, 0x000fe200078e0216ULL, 0x000000172a167210ULL, 0x000fe20007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x000000000e1d7faeULL, 0x0003e6000b901c46ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x00000070263d7812ULL, 0x000fe200078ef805ULL,
0x00000000101f7faeULL, 0x0003e4000b901c46ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000702c3b7812ULL, 0x000fc400078ef805ULL, 0x0000003d2a1a7210ULL, 0x000fe20007f3e0ffULL,
0x000000011b177824ULL, 0x100fe200000e062eULL, 0x00000070361b7812ULL, 0x000fe200078ef805ULL,
0x0000000119137824ULL, 0x100fe200010e062eULL, 0x0000003b2a267210ULL, 0x000fe20007f5e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000001b2a2c7210ULL, 0x000fe40007f7e0ffULL,
0x0000000012217faeULL, 0x0003e2000b901c46ULL, 0x00000001271b7824ULL, 0x000fe200008e062eULL,
0x00000070183f7812ULL, 0x000fe200078ef805ULL, 0x0000000103307824ULL, 0x000fe200078e0230ULL,
0x0000000016237faeULL, 0x0003e2000b901c46ULL, 0x000000012d277824ULL, 0x000fe200010e062eULL,
0x0000003f2a187210ULL, 0x000fe20007f1e0ffULL, 0x0000000103357824ULL, 0x000fc400078e0235ULL,
0x00000001372d7824ULL, 0x000fe400018e062eULL, 0x0000000103367824ULL, 0x040fe400078e0232ULL,
0x0000000103377824ULL, 0x040fe400078e0231ULL, 0x00000001033c7824ULL, 0x040fe400078e022fULL,
0x0000000103427824ULL, 0x000fe400078e0233ULL, 0x0000008030307825ULL, 0x000fc800078e00ffULL,
0x00000001033e7824ULL, 0x000fe200078e0234ULL, 0x0000007030497812ULL, 0x000fe200078ef805ULL,
0x0000008035327825ULL, 0x000fc800078e00ffULL, 0x0000008036347825ULL, 0x000fe200078e00ffULL,
0x0000007032477812ULL, 0x000fc600078ef805ULL, 0x0000008037367825ULL, 0x000fe200078e00ffULL,
0x0000007034457812ULL, 0x000fe400078ef805ULL, 0x000000472a327210ULL, 0x000fe20007f3e0ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000007036417812ULL, 0x000fe400078ef805ULL,
0x000000452a347210ULL, 0x000fe20007f5e0ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000703c3b7812ULL, 0x000fe400078ef805ULL, 0x000000412a367210ULL, 0x000fe20007f7e0ffULL,
0x0000008042427825ULL, 0x000fe200078e00ffULL, 0x000000703e2f7812ULL, 0x000fc400078ef805ULL,
0x0000003b2a3c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000119197824ULL, 0x100fe200000e062eULL,
0x000000492a307210ULL, 0x000fe20007f1e0ffULL, 0x0000000133337824ULL, 0x100fe200008e062eULL,
0x0000007042057812ULL, 0x000fe200078ef805ULL, 0x0000000135357824ULL, 0x100fe200010e062eULL,
0x0000002f2a3e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000131317824ULL, 0x100fe200000e062eULL,
0x000000052a427210ULL, 0x000fe20007fde0ffULL, 0x0000000018257faeULL, 0x0003e2000b901c46ULL,
0x0000000137377824ULL, 0x000fc400018e062eULL, 0x000000013d3d7824ULL, 0x100fe200020e062eULL,
0x000000001a297faeULL, 0x0003e2000b901c46ULL, 0x000000013f3f7824ULL, 0x100fe400028e062eULL,
0x0000000143437824ULL, 0x000fe200030e062eULL, 0x00000000262b7faeULL, 0x0003e8000b901c46ULL,
0x000000002c0c7faeULL, 0x0003e8000b901c46ULL, 0x0000000030147faeULL, 0x0003e8000b901c46ULL,
0x0000000032287faeULL, 0x0003e8000b901c46ULL, 0x0000000034247faeULL, 0x0003e8000b901c46ULL,
0x0000000036227faeULL, 0x0003e8000b901c46ULL, 0x000000003c207faeULL, 0x0003e8000b901c46ULL,
0x000000003e1e7faeULL, 0x0003e8000b901c46ULL, 0x00000000421c7faeULL, 0x0003e4000b901c46ULL,
0x0000000440057836ULL, 0x002fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff077424ULL, 0x000fc600078e00ffULL, 0x0000003a0500720cULL, 0x000fda0003f06070ULL,
0x00009400ff0b8b82ULL, 0x000e620000000800ULL, 0x0000000215068824ULL, 0x000fce00078e00ffULL,
0x00009000ff0e8b82ULL, 0x000ea20000000a00ULL, 0x0000000b060b8224ULL, 0x002fc800078e0205ULL,
0x000000040b0e8825ULL, 0x004fca00078e000eULL, 0x000000060e078981ULL, 0x000324000c1e1900ULL,
0x00000000000e7805ULL, 0x002fce0000015200ULL, 0x017600090d0075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x000000100e0b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000111107824ULL, 0x000fe200000e0e0fULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011410ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0610ULL,
0x0000000206067819ULL, 0x000fc8000000120bULL, 0x000000060000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x017600090d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000097919ULL, 0x000e640000000000ULL, 0x0000002040067824ULL, 0x002fca00078e0209ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL,
0x0000000f06087812ULL, 0x000fc600078ec0ffULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x00000010080c7824ULL, 0x040fe400078e00ffULL, 0x0000000109067836ULL, 0x000fe20000000000ULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x00000010080b7824ULL, 0x000fc600078e00ffULL,
0x0000000f06087812ULL, 0x000fe400078ec0ffULL, 0x000000f00c067812ULL, 0x000fe400078ee209ULL,
0x000000f00b087812ULL, 0x000fc600078ee208ULL, 0x0000001006067824ULL, 0x100fe400078e020dULL,
0x0000001008087824ULL, 0x000fc600078e020dULL, 0x0000000006187984ULL, 0x000e680000000c00ULL,
0x0000000008107984ULL, 0x000ea20000000c00ULL, 0x000000ffff1c7224ULL, 0x002fe400078e0018ULL,
0x000000ffff187224ULL, 0x000fe400078e0019ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000ffff197224ULL, 0x000fc400078e001bULL, 0x000000ffff1e7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0013ULL, 0x0000001c06007388ULL, 0x0003e20000000c00ULL,
0x00000001ff107424ULL, 0x000fc600078e00ffULL, 0x0000001808007388ULL, 0x0003e60000000c00ULL,
0x017600100d1079a7ULL, 0x0002a4000850003fULL, 0x0000000000087805ULL, 0x002fce0000015200ULL,
0x017600110d0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fce0000015200ULL,
0x0000000e080b7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e09ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc8000001140eULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060eULL, 0x0000000206067819ULL, 0x000fc8000000120bULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x017600110d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff3800720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009400ff087b82ULL, 0x000e620000000800ULL,
0x0000000000067919ULL, 0x000ea20000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x3db504f30a097820ULL, 0x010fe20000410000ULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x80000009390e7c36ULL, 0x000fe20008000000ULL, 0xffffffff09057890ULL, 0x000fe2000fffe03fULL,
0x00000100040a7836ULL, 0x000fe20000000000ULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x00000008400b7824ULL, 0x140fe200078e020dULL, 0x00000008ff0e7819ULL, 0x000fe2000001160eULL,
0x00000020400c7824ULL, 0x000fe200078e020dULL, 0x0000000909087890ULL, 0x000fe2000fffe03fULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL,
0x000000ffff187224ULL, 0x000fc400078e00ffULL, 0x0000000815087224ULL, 0x002fd200078e02ffULL,
0x000000020f117836ULL, 0x004fe20000000000ULL, 0x00000001183b7812ULL, 0x000fe200078e0cffULL,
0x0000000702357224ULL, 0x010fc600078e02ffULL, 0x000000381100720cULL, 0x000fda0003f06070ULL,
0x0000000c003c8947ULL, 0x000fea0003800000ULL, 0x00000003ff147819ULL, 0x004fe20000011606ULL,
0x000001000f107824ULL, 0x000fe200078e020aULL, 0x00008e00ff1e7b82ULL, 0x000e660000000a00ULL,
0x00000004141a7836ULL, 0x000fe20000000000ULL, 0x0000001039137248ULL, 0x000fe20007fe0000ULL,
0x0000000c14127836ULL, 0x000fe40000000000ULL, 0x000000011a077824ULL, 0x040fe400078e0206ULL,
0x000000081a167824ULL, 0x000fc400078e00ffULL, 0x0000001414267836ULL, 0x000fe40000000000ULL,
0x00000008141c7836ULL, 0x000fe20000000000ULL, 0xfffffff8162f7812ULL, 0x000fe200078ee207ULL,
0x0000000113137824ULL, 0x000fe400078e0a10ULL, 0x0000000112117824ULL, 0x140fe400078e0206ULL,
0x0000000812207824ULL, 0x000fe200078e00ffULL, 0x000000131a00720cULL, 0x080fe20003f26070ULL,
0x0000000126277824ULL, 0x100fe200078e0206ULL, 0x000000131c00720cULL, 0x000fe20003f06070ULL,
0x0000000826167824ULL, 0x000fe200078e00ffULL, 0xfffffff820377812ULL, 0x000fe200078ee211ULL,
0x000000011c107824ULL, 0x000fc400078e0206ULL, 0x000000081c337824ULL, 0x000fe200078e00ffULL,
0xfffffff816277812ULL, 0x000fe200078ee227ULL, 0x0000001014247836ULL, 0x000fe40000000000ULL,
0x0000001006117824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee210ULL,
0x00000001031a7824ULL, 0x040fe200078e021aULL, 0x000000132400720cULL, 0x000fe20003fa6070ULL,
0x0000000103167824ULL, 0x000fe200078e0214ULL, 0x0000007011117812ULL, 0x000fe200078ec0ffULL,
0x00000018142a7836ULL, 0x000fc40000000000ULL, 0x0000000124297824ULL, 0x040fe400078e0206ULL,
0x0000000824107824ULL, 0x000fe400078e00ffULL, 0x00000001031c7824ULL, 0x000fe400078e021cULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff810297812ULL, 0x000fe400078ee229ULL,
0x0000001e35107211ULL, 0x002fe200078438ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000111a217212ULL, 0x000fc400078efcffULL, 0x0000001f35077211ULL, 0x000fe200010f3cffULL,
0x000000012a157824ULL, 0x000fe200078e0206ULL, 0x0000001116237212ULL, 0x080fe200078efcffULL,
0x000000082a207824ULL, 0x000fe400078e00ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000002310227210ULL, 0x000fe40007f5e0ffULL, 0xfffffff820157812ULL, 0x000fe200078ee215ULL,
0x0000001c142c7836ULL, 0x000fe20000000000ULL, 0x000000111c197212ULL, 0x000fe200078efcffULL,
0x0000000103247824ULL, 0x040fe200078e0224ULL, 0x0000001021207210ULL, 0x000fe20007f7e0ffULL,
0x00000001031c7824ULL, 0x000fe200078e0212ULL, 0x0000001019167210ULL, 0x000fe20007f9e0ffULL,
0x0000000117237824ULL, 0x100fe200010e0607ULL, 0x000000131200720cULL, 0x080fe20003f46070ULL,
0x000000011b217824ULL, 0x000fe200018e0607ULL, 0x000000131400720cULL, 0x040fe20003f66070ULL,
0x00000001141b7824ULL, 0x000fc400078e0206ULL, 0x000000012c1e7824ULL, 0x040fe400078e0206ULL,
0x000000082c1f7824ULL, 0x000fe200078e00ffULL, 0x000000071b2b7812ULL, 0x000fe200078ec0ffULL,
0x000000011d177824ULL, 0x000fe400020e0607ULL, 0x00004000401a7824ULL, 0x000fe200078e020dULL,
0xfffffff81f197812ULL, 0x000fe200078ee21eULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0ffffff82b2b7812ULL, 0x000fc600078ef806ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x00000011241b7212ULL, 0x000fc600078efcffULL, 0x0000002014287836ULL, 0x000fe20000000000ULL,
0x000000111c1f7212ULL, 0x000fe200078efcffULL, 0x000020003b127824ULL, 0x000fe200078e021aULL,
0x000000101b1c7210ULL, 0x000fe20007fde0ffULL, 0x00000001282d7824ULL, 0x040fe200078e0206ULL,
0x000000101f1e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000828247824ULL, 0x000fe400078e00ffULL,
0x0000100012127836ULL, 0x000fe40000000000ULL, 0x000000011d1f7824ULL, 0x000fe200020e0607ULL,
0xfffffff8241b7812ULL, 0x000fe200078ee22dULL, 0x000000102b2d7824ULL, 0x000fe200078e0212ULL,
0x000000132600720cULL, 0x000fe20003f86070ULL, 0x0000000103247824ULL, 0x000fc400078e0226ULL,
0x00000001251d7824ULL, 0x000fe200030e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000222d7faeULL, 0x0003e2000d901c46ULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x000000132a00720cULL, 0x000fc60003f66070ULL, 0x00000001032a7824ULL, 0x000fe200078e022aULL,
0x0000001124317212ULL, 0x000fe200078efcffULL, 0x000000102f2f7824ULL, 0x000fe400078e0212ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001031247210ULL, 0x000fe40007fde0ffULL,
0x00000000202f7faeULL, 0x0005e2000c901c46ULL, 0x000000132c00720cULL, 0x000fe20003f26070ULL,
0x0000002414267836ULL, 0x000fe20000000000ULL, 0x000000112a237212ULL, 0x002fe200078efcffULL,
0x00000001032c7824ULL, 0x000fc400078e022cULL, 0x0000000125257824ULL, 0x000fe200030e0607ULL,
0x0000001023227210ULL, 0x000fe20007fde0ffULL, 0x00000001262e7824ULL, 0x040fe400078e0206ULL,
0x0000000826317824ULL, 0x000fe400078e00ffULL, 0x000000802c2c7825ULL, 0x000fc800078e00ffULL,
0x00000001032a7824ULL, 0x000fe200078e0228ULL, 0x000000112c217212ULL, 0x004fe200078efcffULL,
0x00000010332f7824ULL, 0x100fe200078e0212ULL, 0xfffffff831337812ULL, 0x000fe200078ee22eULL,
0x000000012b237824ULL, 0x000fe200030e0607ULL, 0x0000001021207210ULL, 0x000fe20007fde0ffULL,
0x0000001037317824ULL, 0x000fe200078e0212ULL, 0x00000000162f7faeULL, 0x0003e2000c101c46ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x000000132800720cULL, 0x080fe40003f06070ULL,
0x000000001e317faeULL, 0x0005e2000d101c46ULL, 0x000000132600720cULL, 0x000fe20003f46070ULL,
0x0000000103267824ULL, 0x000fc400078e0226ULL, 0x000000012d217824ULL, 0x000fe400030e0607ULL,
0x00000010292d7824ULL, 0x000fe200078e0212ULL, 0x000000112a177212ULL, 0x002fe200078efcffULL,
0x0000002814287836ULL, 0x000fe40000000000ULL, 0x0000002c142e7836ULL, 0x000fe20000000000ULL,
0x0000001017167210ULL, 0x000fe20007fde0ffULL, 0x00000080261e7825ULL, 0x004fe200078e00ffULL,
0x000000001c2d7faeULL, 0x0003e2000e901c46ULL, 0x000000132800720cULL, 0x000fc40003fa6070ULL,
0x000000012b177824ULL, 0x000fe400030e0607ULL, 0x00000001282c7824ULL, 0x040fe400078e0206ULL,
0x00000008282f7824ULL, 0x000fe400078e00ffULL, 0x00000010272b7824ULL, 0x000fe200078e0212ULL,
0x000000111e277212ULL, 0x000fe200078efcffULL, 0x0000000103287824ULL, 0x000fe200078e0228ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee22cULL, 0x000000012e2a7824ULL, 0x040fe200078e0206ULL,
0x0000001027267210ULL, 0x000fe20007fde0ffULL, 0x000000082e357824ULL, 0x000fe200078e00ffULL,
0x00000000242b7faeULL, 0x0005e2000e101c46ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x000000132e00720cULL, 0x000fc40003f86070ULL, 0xfffffff835317812ULL, 0x000fe200078ee22aULL,
0x00000001031e7824ULL, 0x000fe200078e022eULL, 0x00000011281d7212ULL, 0x002fe200078efcffULL,
0x00000030142a7836ULL, 0x000fe40000000000ULL, 0x000000011f277824ULL, 0x000fe200030e0607ULL,
0x000000101d1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001015157824ULL, 0x000fe400078e0212ULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0x0000000022157faeULL, 0x0003e2000d901c46ULL,
0x0000000103247824ULL, 0x004fe200078e022aULL, 0x000000111e257212ULL, 0x000fe200078efcffULL,
0x00000001291d7824ULL, 0x100fe200030e0607ULL, 0x000000132a00720cULL, 0x040fe20003f66070ULL,
0x000000012a287824ULL, 0x040fe200078e0206ULL, 0x00000010251e7210ULL, 0x000fe20007fde0ffULL,
0x000000082a2b7824ULL, 0x000fe400078e00ffULL, 0x0000001019197824ULL, 0x000fe400078e0212ULL,
0x000000011f1f7824ULL, 0x000fe200030e0607ULL, 0xfffffff82b257812ULL, 0x000fe200078ee228ULL,
0x0000008024227825ULL, 0x002fe200078e00ffULL, 0x0000000020197faeULL, 0x0003e6000c901c46ULL,
0x0000003414247836ULL, 0x000fe20000000000ULL, 0x0000001122157212ULL, 0x000fe200078efcffULL,
0x0000003c142a7836ULL, 0x000fc40000000000ULL, 0x0000000124287824ULL, 0x040fe200078e0206ULL,
0x0000001015227210ULL, 0x000fe20007fde0ffULL, 0x0000000824297824ULL, 0x040fe200078e00ffULL,
0x000000132400720cULL, 0x000fe20003f26070ULL, 0x0000000103157824ULL, 0x000fe400078e0224ULL,
0x000000101b1b7824ULL, 0x000fe200078e0212ULL, 0xfffffff829297812ULL, 0x000fe200078ee228ULL,
0x0000008015207825ULL, 0x002fc600078e00ffULL, 0x00000000161b7faeULL, 0x0003e2000c101c46ULL,
0x0000003814287836ULL, 0x000fe20000000000ULL, 0x0000001120157212ULL, 0x000fe200078efcffULL,
0x0000000123237824ULL, 0x000fe200030e0607ULL, 0x000000132a00720cULL, 0x000fe20003f06070ULL,
0x0000000103147824ULL, 0x000fe200078e0228ULL, 0x0000001015207210ULL, 0x000fe20007fde0ffULL,
0x0000001033197824ULL, 0x000fe400078e0212ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000000026197faeULL, 0x0005e2000d101c46ULL, 0x0000000103247824ULL, 0x000fe200078e022aULL,
0x000000132800720cULL, 0x000fe20003f46070ULL, 0x0000000121217824ULL, 0x000fe200030e0607ULL,
0x0000001114137212ULL, 0x000fe200078efcffULL, 0x0000008024167825ULL, 0x002fc600078e00ffULL,
0x0000001013147210ULL, 0x000fe20007fde0ffULL, 0x00000001281b7824ULL, 0x100fe200078e0206ULL,
0x0000001116117212ULL, 0x000fe200078efcffULL, 0x0000000828287824ULL, 0x000fe400078e00ffULL,
0x000000012a197824ULL, 0x044fe400078e0206ULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff828277812ULL, 0x000fe200078ee21bULL, 0x0000000115157824ULL, 0x000fe200030e0607ULL,
0x0000001011107210ULL, 0x000fe20007fde0ffULL, 0x000000102f137824ULL, 0x100fe200078e0212ULL,
0xfffffff82a2b7812ULL, 0x000fe200078ee219ULL, 0x0000001031197824ULL, 0x000fc400078e0212ULL,
0x00000010251b7824ULL, 0x100fe200078e0212ULL, 0x000000001c137faeULL, 0x0003e2000e901c46ULL,
0x0000001029257824ULL, 0x100fe400078e0212ULL, 0x0000001027277824ULL, 0x100fe200078e0212ULL,
0x000000001e197faeULL, 0x0003e2000e101c46ULL, 0x000000102b297824ULL, 0x000fe400078e0212ULL,
0x0000000117117824ULL, 0x000fe200030e0607ULL, 0x00000000221b7faeULL, 0x0003e8000d901c46ULL,
0x0000000020257faeULL, 0x0003e8000c901c46ULL, 0x0000000014277faeULL, 0x0003e8000d101c46ULL,
0x0000000010297faeULL, 0x0003e2000c101c46ULL, 0x0000000800e87947ULL, 0x000fea0003800000ULL,
0x0000000406137811ULL, 0x004fe200078fe8ffULL, 0x00004000401a7824ULL, 0x000fe200078e020dULL,
0x0000000c06157811ULL, 0x040fe200078fe8ffULL, 0x0000001006377824ULL, 0x040fe200078e00ffULL,
0x0000001006227811ULL, 0x040fe200078fe8ffULL, 0x0000000113077824ULL, 0x140fe200078e0206ULL,
0x0000001806207811ULL, 0x040fe200078fe8ffULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0x0000001c061e7811ULL, 0x040fe200078fe8ffULL, 0x0000000815277824ULL, 0x040fe200078e00ffULL,
0x0000002406367811ULL, 0x000fe200078fe8ffULL, 0x0000000122117824ULL, 0x100fe200078e0206ULL,
0xfffffff810197812ULL, 0x000fe200078ee207ULL, 0x0000000115107824ULL, 0x100fe200078e0206ULL,
0x0000000806147811ULL, 0x000fe200078fe8ffULL, 0x0000000822167824ULL, 0x000fe200078e00ffULL,
0x0000002806347811ULL, 0x000fe200078fe8ffULL, 0x00000008202d7824ULL, 0x040fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee210ULL, 0x0000000120107824ULL, 0x100fe200078e0206ULL,
0xfffffff816297812ULL, 0x000fe200078ee211ULL, 0x000000011e117824ULL, 0x100fe200078e0206ULL,
0x00000030063d7811ULL, 0x000fe200078fe8ffULL, 0x000000081e167824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL, 0x0000000136107824ULL, 0x100fe200078e0206ULL,
0x00000014061f7811ULL, 0x000fe200078fe8ffULL, 0x0000000836177824ULL, 0x000fe200078e00ffULL,
0xfffffff8162f7812ULL, 0x000fe200078ee211ULL, 0x0000000114077824ULL, 0x100fe200078e0206ULL,
0x00000034063e7811ULL, 0x000fe200078fe8ffULL, 0x0000000814127824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee210ULL, 0x0000000134117824ULL, 0x100fe200078e0206ULL,
0x00000038063f7811ULL, 0x000fe200078fe8ffULL, 0x0000000834167824ULL, 0x000fe200078e00ffULL,
0xfffffff8121b7812ULL, 0x000fe200078ee207ULL, 0x000000013d107824ULL, 0x140fe200078e0206ULL,
0x0000002006217811ULL, 0x040fe200078fe8ffULL, 0x000000083d257824ULL, 0x000fe200078e00ffULL,
0xfffffff8161d7812ULL, 0x000fe200078ee211ULL, 0x000000011f077824ULL, 0x140fe200078e0206ULL,
0x0000002c063c7811ULL, 0x000fe200078fe8ffULL, 0x000000081f127824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x000000013e117824ULL, 0x100fe200078e0206ULL,
0x0000003c06417811ULL, 0x000fe200078fe8ffULL, 0x000000083e167824ULL, 0x000fe200078e00ffULL,
0xfffffff8122b7812ULL, 0x000fe200078ee207ULL, 0x000000013f107824ULL, 0x100fe200078e0206ULL,
0x0000007037377812ULL, 0x000fe200078ec0ffULL, 0x000000083f437824ULL, 0x000fe200078e00ffULL,
0xfffffff816337812ULL, 0x000fe200078ee211ULL, 0x0000000121077824ULL, 0x000fc400078e0206ULL,
0x0000000821127824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee210ULL,
0x00000001031c7824ULL, 0x000fe200078e0213ULL, 0x00008e00ff107b82ULL, 0x000e620000000a00ULL,
0x0000000141167824ULL, 0x140fe200078e0206ULL, 0xfffffff812317812ULL, 0x000fe200078ee207ULL,
0x000000013c077824ULL, 0x040fe400078e0206ULL, 0x000000083c127824ULL, 0x000fe400078e00ffULL,
0x0000000841457824ULL, 0x000fc400078e00ffULL, 0x0000000103147824ULL, 0x000fe200078e0214ULL,
0xfffffff812237812ULL, 0x000fe200078ee207ULL, 0x000020003b127824ULL, 0x000fe200078e021aULL,
0xfffffff845457812ULL, 0x000fe200078ee216ULL, 0x0000000103167824ULL, 0x000fe200078e0215ULL,
0x0000000606077211ULL, 0x040fe200078fe8ffULL, 0x0000100012327836ULL, 0x000fe20000000000ULL,
0x0000000306127211ULL, 0x000fe200078fe8ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000707077812ULL, 0x000fc600078ec0ffULL, 0x000000101d287824ULL, 0x000fe200078e0232ULL,
0x0000003714147212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0ffffff807077812ULL, 0x000fc600078ef806ULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x00000010332e7824ULL, 0x000fe200078e0232ULL, 0x0000001035337211ULL, 0x002fe200078038ffULL,
0x0000000103227824ULL, 0x000fe200078e0222ULL, 0x0000003712107212ULL, 0x080fe200078efcffULL,
0x0000001017267824ULL, 0x000fe200078e0232ULL, 0x000000371c127212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001135357211ULL, 0x000fe400000f3cffULL,
0x0000001033107210ULL, 0x000fe20007f1e0ffULL, 0x00000001031f7824ULL, 0x040fe200078e021fULL,
0x0000001233127210ULL, 0x000fe20007f3e0ffULL, 0x0000000103207824ULL, 0x000fe200078e0220ULL,
0x0000003716167212ULL, 0x000fe200078efcffULL, 0x0000000113117824ULL, 0x100fe200000e0635ULL,
0x0000001433147210ULL, 0x000fe20007f1e0ffULL, 0x000000011d137824ULL, 0x000fe200008e0635ULL,
0x0000001633167210ULL, 0x000fe20007f5e0ffULL, 0x00000080221c7825ULL, 0x000fc800078e00ffULL,
0x0000000103227824ULL, 0x040fe200078e021eULL, 0x000000371c1c7212ULL, 0x000fe200078efcffULL,
0x0000000103247824ULL, 0x000fe400078e0221ULL, 0x000000801f1e7825ULL, 0x000fc800078e00ffULL,
0x00000010232a7824ULL, 0x000fe200078e0232ULL, 0x000000371e1e7212ULL, 0x000fe200078efcffULL,
0x0000008020207825ULL, 0x000fc800078e00ffULL, 0x00000010252c7824ULL, 0x000fe200078e0232ULL,
0x0000003720207212ULL, 0x000fe200078efcffULL, 0x0000000115157824ULL, 0x000fe200000e0635ULL,
0x0000001c331c7210ULL, 0x000fe20007f1e0ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000002033207210ULL, 0x000fc60007f3e0ffULL, 0x0000000103447824ULL, 0x000fe200078e0236ULL,
0x0000003722227212ULL, 0x000fe200078efcffULL, 0x0000008024247825ULL, 0x000fc800078e00ffULL,
0x00000001034a7824ULL, 0x000fe200078e0234ULL, 0x0000003724247212ULL, 0x000fe200078efcffULL,
0x0000001007077824ULL, 0x100fe400078e0232ULL, 0x0000001019197824ULL, 0x100fe200078e0232ULL,
0x0000002433247210ULL, 0x000fe20007f7e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0232ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010077faeULL, 0x0003e2000b901c46ULL,
0x0000001027277824ULL, 0x100fe400078e0232ULL, 0x0000001029297824ULL, 0x100fe200078e0232ULL,
0x0000000012197faeULL, 0x0003e2000b901c46ULL, 0x000000102b2b7824ULL, 0x000fc400078e0232ULL,
0x000000102d2d7824ULL, 0x100fe200078e0232ULL, 0x00000000141b7faeULL, 0x0003e2000b901c46ULL,
0x000000102f2f7824ULL, 0x100fe400078e0232ULL, 0x0000001031317824ULL, 0x100fe400078e0232ULL,
0x0000001043307824ULL, 0x000fe400078e0232ULL, 0x0000000103487824ULL, 0x000fe400078e023cULL,
0x0000001045327824ULL, 0x000fc400078e0232ULL, 0x0000000103467824ULL, 0x040fe400078e023dULL,
0x0000000103427824ULL, 0x000fe400078e023eULL, 0x0000008044447825ULL, 0x000fc800078e00ffULL,
0x00000001033f7824ULL, 0x000fe200078e023fULL, 0x0000003744367212ULL, 0x000fe200078efcffULL,
0x000000804a4a7825ULL, 0x000fc800078e00ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0635ULL,
0x0000001e331e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001033c7824ULL, 0x000fe200078e0241ULL,
0x000000374a447212ULL, 0x000fe200078efcffULL, 0x0000008048487825ULL, 0x000fc800078e00ffULL,
0x0000008046467825ULL, 0x000fe200078e00ffULL, 0x0000003748487212ULL, 0x000fc600078efcffULL,
0x0000000117177824ULL, 0x000fe200010e0635ULL, 0x0000002233227210ULL, 0x000fe20007f5e0ffULL,
0x0000008042427825ULL, 0x000fe200078e00ffULL, 0x0000003746467212ULL, 0x080fe400078efcffULL,
0x0000000016277faeULL, 0x0003e2000b901c46ULL, 0x000000803f3e7825ULL, 0x000fe200078e00ffULL,
0x0000003742427212ULL, 0x080fe400078efcffULL, 0x000000001c297faeULL, 0x0003e2000b901c46ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x000000373e3e7212ULL, 0x000fc400078efcffULL,
0x0000004233427210ULL, 0x000fe20007f9e0ffULL, 0x000000011f1f7824ULL, 0x100fe200000e0635ULL,
0x0000003633367210ULL, 0x000fe20007f1e0ffULL, 0x0000000121217824ULL, 0x100fe200008e0635ULL,
0x0000004433447210ULL, 0x000fe20007f3e0ffULL, 0x0000000123237824ULL, 0x100fe200010e0635ULL,
0x000000373c347212ULL, 0x000fe200078efcffULL, 0x0000000125257824ULL, 0x100fe200018e0635ULL,
0x0000004833487210ULL, 0x000fe20007f5e0ffULL, 0x0000000145377824ULL, 0x100fe200000e0635ULL,
0x0000004633467210ULL, 0x000fe20007f7e0ffULL, 0x000000014b457824ULL, 0x100fe200008e0635ULL,
0x0000003e333e7210ULL, 0x000fe20007fbe0ffULL, 0x000000001e2b7faeULL, 0x0003e2000b901c46ULL,
0x0000003433347210ULL, 0x000fe20007fde0ffULL, 0x0000000149497824ULL, 0x000fc400010e0635ULL,
0x00000000202d7faeULL, 0x0003e2000b901c46ULL, 0x0000000147477824ULL, 0x100fe400018e0635ULL,
0x0000000143437824ULL, 0x100fe200020e0635ULL, 0x00000000222f7faeULL, 0x0003e2000b901c46ULL,
0x000000013f3f7824ULL, 0x100fe400028e0635ULL, 0x000000013d357824ULL, 0x000fe200030e0635ULL,
0x0000000024317faeULL, 0x0003e8000b901c46ULL, 0x0000000036267faeULL, 0x0003e8000b901c46ULL,
0x0000000044287faeULL, 0x0003e8000b901c46ULL, 0x00000000482a7faeULL, 0x0003e8000b901c46ULL,
0x00000000462c7faeULL, 0x0003e8000b901c46ULL, 0x00000000422e7faeULL, 0x0003e8000b901c46ULL,
0x000000003e307faeULL, 0x0003e8000b901c46ULL, 0x0000000034327faeULL, 0x0003e4000b901c46ULL,
0x0000000405057836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff077424ULL, 0x002fc600078e00ffULL, 0x0000003a0500720cULL, 0x000fda0003f06070ULL,
0x00009000ff108b82ULL, 0x000e620000000a00ULL, 0x0000000208138824ULL, 0x000fe400078e0205ULL,
0x0000002006417836ULL, 0x000fe20000000000ULL, 0xfffffff806457812ULL, 0x000fe200078ec0ffULL,
0x0000200018447824ULL, 0x000fe200078e021aULL, 0x0000000706437812ULL, 0x000fe200078ec0ffULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x00000004ff427819ULL, 0x000fe40000011606ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000413108825ULL, 0x002fca00078e0010ULL,
0x0000000610078981ULL, 0x000322000c1e1900ULL, 0xfffffff841417812ULL, 0x000fe400078ec0ffULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000100044447836ULL, 0x000fe20000000000ULL, 0x0000000745457812ULL, 0x000fe400078ef806ULL,
0x0000000843467812ULL, 0x000fe400078ef806ULL, 0x0000000741417812ULL, 0x000fce00078ef806ULL,
0x0000000145107824ULL, 0x142fe400078e0248ULL, 0x0000000845117824ULL, 0x000fe400078e00ffULL,
0x0000000141147824ULL, 0x040fe400078e0248ULL, 0x0000000841157824ULL, 0x040fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee210ULL, 0x0000000248617824ULL, 0x000fe400078e0242ULL,
0x0000000841497824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x0000001011117824ULL, 0x000fc800078e0244ULL, 0x0000001015157824ULL, 0x000fe400078e0244ULL,
0x000000001110783bULL, 0x000e680000000200ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x00000018ff577819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x0000888010557816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x0000888011607816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x00000018ff667819ULL, 0x000fc40000011412ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00008880125f7816ULL, 0x000fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe20000011413ULL,
0x00000010005e7306ULL, 0x0003e20000202400ULL, 0x0000888013717816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff677819ULL, 0x004fe20000011414ULL, 0x00000011005d7306ULL, 0x0005e20000202400ULL,
0x0001000012107824ULL, 0x002fe200078e00ffULL, 0x00008880146d7816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011417ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x044fe200078e00ffULL, 0x0000001c005a7306ULL, 0x0003e20000202400ULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x0000888017637816ULL, 0x000fc400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000001200737306ULL, 0x0005e20000202400ULL, 0x00000008451c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011415ULL, 0x00008880156b7816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fc40000011416ULL, 0x0000001100767306ULL, 0x0003e20000202400ULL,
0x0000000148127836ULL, 0x004fe20000000000ULL, 0x0000888016697816ULL, 0x000fe200000000ffULL,
0x0000000248487836ULL, 0x000fca0000000000ULL, 0x00000013006f7306ULL, 0x0005e20000202400ULL,
0x0000000145117824ULL, 0x102fe200078e0212ULL, 0x000000084800780cULL, 0x000fe20003f05270ULL,
0x0000000141127824ULL, 0x000fca00078e0212ULL, 0x0000001d00757306ULL, 0x0003e20000202400ULL,
0xfffffff81c137812ULL, 0x004fe200078ee211ULL, 0x0001000015117824ULL, 0x040fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee212ULL, 0x0000010015157824ULL, 0x000fe400078e00ffULL,
0x0000001013137824ULL, 0x000fe200078e0244ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000001000787306ULL, 0x0005e20000202400ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000000131c783bULL, 0x002e6a0000000200ULL, 0x00000015006e7306ULL, 0x000fe20000202400ULL,
0x0001000014107824ULL, 0x004fc400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000001100707306ULL, 0x0005f00000202400ULL, 0x0000001400727306ULL, 0x0007e20000202400ULL,
0x0000001049117824ULL, 0x004fce00078e0244ULL, 0x0000001000747306ULL, 0x0005e20000202400ULL,
0x0001000017147824ULL, 0x048fe400078e00ffULL, 0x0000010017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0001000016107824ULL, 0x044fe200078e00ffULL, 0x0000001400647306ULL, 0x0005e20000202400ULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x002fe2000001141cULL,
0x000100001c157824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe20000011410ULL,
0x000100001d567824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x000000001110783bULL, 0x000e620000000200ULL, 0x0000001700627306ULL, 0x0007e20000202400ULL,
0x0000000146147824ULL, 0x004fe200078e0261ULL, 0x00000018ff527819ULL, 0x000fe20000011415ULL,
0x000100001e597824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fc4000001141dULL,
0x000088801c4b7816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000016006a7306ULL, 0x0005e20000202400ULL, 0x0000001046177824ULL, 0x008fe200078e00ffULL,
0x000088801d537816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0xfffffff017147812ULL, 0x000fe400078ee214ULL,
0x0000005500557306ULL, 0x000ee20000202400ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x0000001014147824ULL, 0x000fe200078e020dULL, 0x00000018ff587819ULL, 0x000fe40000011456ULL,
0x00000018ff4f7819ULL, 0x000fe4000001141fULL, 0x0000001c00547306ULL, 0x0007e20000202400ULL,
0x000000001414783bULL, 0x004ea20000000200ULL, 0x00000018ff507819ULL, 0x000fe4000001141eULL,
0x000088801e777816ULL, 0x040fe200000000ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x0000001d00567306ULL, 0x000be20000202400ULL, 0x00005410551c7816ULL, 0x008fe4000000005aULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000018ff5a7819ULL, 0x000fe40000011459ULL,
0x00000018ff4e7819ULL, 0x002fe20000011410ULL, 0x0000005c005c7306ULL, 0x000e620000202400ULL,
0x000054105e1d7816ULL, 0x020fe40000000057ULL, 0x000088801f577816ULL, 0x000fc400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011411ULL, 0x00000018ff4c7819ULL, 0x000fe20000011412ULL,
0x0000006000607306ULL, 0x000ee20000202400ULL, 0x00000018ff4a7819ULL, 0x000fce0000011413ULL,
0x0000006600667306ULL, 0x000f700000202400ULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x0000001c143c723cULL, 0x004fee000004183cULL, 0x000100001f1c7824ULL, 0x000fe200078e00ffULL,
0x000054105d1d7816ULL, 0x002fe2000000005cULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x00008880105d7816ULL, 0x000fe200000000ffULL, 0x0000006800687306ULL, 0x000e620000202400ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000018ff1f7819ULL, 0x000fca000001141fULL,
0x0000001c005e7306ULL, 0x0007f00000202400ULL, 0x0000001f005c7306ULL, 0x0005e20000202400ULL,
0x00005410601c7816ULL, 0x008fe40000000075ULL, 0x0000888011757816ULL, 0x000fca00000000ffULL,
0x0000001c1434723cULL, 0x000fe20000041834ULL, 0x00000010461f7824ULL, 0x004fe200078e00ffULL,
0x0000007100717306ULL, 0x000eaa0000202400ULL, 0x00010000101d7824ULL, 0x040fe400078e00ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x0000001e00597306ULL, 0x0007e40000202400ULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff1c7819ULL, 0x000fe40000011410ULL,
0x0000000246107810ULL, 0x000fe40007ffe061ULL, 0x0000001d00607306ULL, 0x000be20000202400ULL,
0x00010000111e7824ULL, 0x008fe200078e00ffULL, 0xfffffff01f107812ULL, 0x000fca00078ee210ULL,
0x0000001010107824ULL, 0x000fe200078e020dULL, 0x0000001c00617306ULL, 0x0007e20000202400ULL,
0x00005410731d7816ULL, 0x020fe20000000066ULL, 0x0000010011737824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe4000001141eULL, 0x000054106f117816ULL, 0x002fe20000000068ULL,
0x00010000126f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011473ULL,
0x0000006d006d7306ULL, 0x000e620000202400ULL, 0x000054105f1c7816ULL, 0x008fc40000000078ULL,
0x00000018ff6f7819ULL, 0x000fca000001146fULL, 0x0000001c1430723cULL, 0x000fe20000041830ULL,
0x0000006700677306ULL, 0x000ee20000202400ULL, 0x00000000101c783bULL, 0x00056e0000000200ULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x0000541071107816ULL, 0x004fce0000000076ULL,
0x0000006b006b7306ULL, 0x000ea20000202400ULL, 0x00000010142c723cULL, 0x000fee000004182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000054106d107816ULL, 0x002fc60000000074ULL, 0x000000ffff6d7224ULL, 0x000fe200078e0011ULL,
0x0000541072117816ULL, 0x008fc60000000067ULL, 0x0000006900697306ULL, 0x000fe80000202400ULL,
0x000000101428723cULL, 0x000fe80000041828ULL, 0x0000006c006c7306ULL, 0x000e660000202400ULL,
0x000054106b107816ULL, 0x004fc40000000070ULL, 0x000054106e117816ULL, 0x000fc60000000065ULL,
0x0000004700477306ULL, 0x000fe80000202400ULL, 0x000000101424723cULL, 0x000fe80000041824ULL,
0x0000006300637306ULL, 0x000ea60000202400ULL, 0x0000010012117824ULL, 0x000fe200078e00ffULL,
0x0000541069107816ULL, 0x002fc4000000006cULL, 0x0000888013697816ULL, 0x000fe400000000ffULL,
0x00000018ff657819ULL, 0x000fe20000011411ULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x000054106a117816ULL, 0x000fce000000005bULL, 0x0000004b004b7306ULL, 0x000fe20000202400ULL,
0x000000101420723cULL, 0x000fee0000041820ULL, 0x0000005200527306ULL, 0x000e620000202400ULL,
0x0000541063107816ULL, 0x004fe40000000064ULL, 0x0000541062117816ULL, 0x000fe20000000047ULL,
0x000000ffff477224ULL, 0x000fc800078e0069ULL, 0x0000005100517306ULL, 0x000fe40000202400ULL,
0x000000101418723cULL, 0x000fec0000041818ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x0001000013117824ULL, 0x000fe200078e00ffULL, 0x000054104b107816ULL, 0x002fe20000000052ULL,
0x0000010013167824ULL, 0x000fc600078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011411ULL,
0x0000005800587306ULL, 0x000e620000202400ULL, 0x0000541054117816ULL, 0x000fe40000000049ULL,
0x00000018ff167819ULL, 0x000fca0000011416ULL, 0x0000004f004f7306ULL, 0x000fe20000202400ULL,
0x000000101c3c723cULL, 0x020fee000004183cULL, 0x0000005700577306ULL, 0x000ea20000202400ULL,
0x0000541053107816ULL, 0x002fe40000000058ULL, 0x0000541056117816ULL, 0x000fca0000000051ULL,
0x0000007700557306ULL, 0x000fe40000202400ULL, 0x000000101c34723cULL, 0x000fec0000041834ULL,
0x0000005a005a7306ULL, 0x000e620000202400ULL, 0x0000541057107816ULL, 0x004fe4000000005eULL,
0x000054105c117816ULL, 0x000fca000000004fULL, 0x0000005000507306ULL, 0x000ea40000202400ULL,
0x000000101c2c723cULL, 0x000fe2000004182cULL, 0x0000541055587816ULL, 0x002fca000000005aULL,
0x0000004e004e7306ULL, 0x000e620000202400ULL, 0x0000541059597816ULL, 0x004fce0000000050ULL,
0x0000004d004d7306ULL, 0x000fe20000202400ULL, 0x000000581c30723cULL, 0x000fe20000041830ULL,
0x0000541061617816ULL, 0x002fcc000000004eULL, 0x0000004c004c7306ULL, 0x000ff00000202400ULL,
0x0000004a004a7306ULL, 0x000ff00000202400ULL, 0x0000005d005d7306ULL, 0x000e700000202400ULL,
0x00000075005f7306ULL, 0x000fe20000202400ULL, 0x000054105d607816ULL, 0x002fce0000000060ULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x000000601c28723cULL, 0x000fee0000041828ULL,
0x0000006800687306ULL, 0x000ea20000202400ULL, 0x000054105f107816ULL, 0x002fce0000000066ULL,
0x0000006d00677306ULL, 0x000fe20000202400ULL, 0x0000541068117816ULL, 0x004fce000000004dULL,
0x0000006f00127306ULL, 0x000e620000202400ULL, 0x000000101c24723cULL, 0x000fee0000041824ULL,
0x00000065005b7306ULL, 0x000ea20000202400ULL, 0x00005410675a7816ULL, 0x002fce0000000012ULL,
0x0000004700147306ULL, 0x000fe20000202400ULL, 0x000054105b5b7816ULL, 0x004fce000000004cULL,
0x0000001500137306ULL, 0x000e620000202400ULL, 0x0000005a1c20723cULL, 0x000fee0000041820ULL,
0x0000001600177306ULL, 0x000ea20000202400ULL, 0x0000541014147816ULL, 0x002fe40000000013ULL,
0x0000541017157816ULL, 0x004fce000000004aULL, 0x000000141c18723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff000280947ULL, 0x000fde000383ffffULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000093c177220ULL, 0x080fe20000410000ULL,
0x00000009203c7220ULL, 0x080fe20000410000ULL, 0x0000000921417220ULL, 0x080fe20000410000ULL,
0x000000093d3d7220ULL, 0x080fe20000410000ULL, 0x000000093e3e7220ULL, 0x080fe20000410000ULL,
0x017688100b1079a7ULL, 0x000262000850003fULL, 0x000000093f3f7220ULL, 0x080fe20000410000ULL,
0x0000000934347220ULL, 0x080fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000936367220ULL, 0x080fe20000410000ULL, 0x0000000937377220ULL, 0x080fe20000410000ULL,
0x0000000930307220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x000000092e2e7220ULL, 0x080fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x0000000928287220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x080fe20000410000ULL,
0x000000092a2a7220ULL, 0x080fe20000410000ULL, 0x000000092b2b7220ULL, 0x080fe20000410000ULL,
0x0000000924167220ULL, 0x080fe20000410000ULL, 0x0000000925257220ULL, 0x080fe20000410000ULL,
0x0000000926267220ULL, 0x080fe20000410000ULL, 0x0000000927277220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x0000000923237220ULL, 0x080fe20000410000ULL,
0x0000000918427220ULL, 0x080fe20000410000ULL, 0x0000000919447220ULL, 0x080fe20000410000ULL,
0x000000091a207220ULL, 0x080fe20000410000ULL, 0x000000091b217220ULL, 0x002fce0000410000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x017688110b0075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001412197210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x017688110b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000406107824ULL, 0x000fe200078e00ffULL, 0x0000000e0f00720cULL, 0x000fe20003f06070ULL,
0x0000008040117824ULL, 0x000fc600078e020dULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x0000000111247824ULL, 0x000fca00078e0210ULL, 0x0174000024107984ULL, 0x0002a20000000c00ULL,
0x0000001000c48947ULL, 0x000fea0003800000ULL, 0x000001000f147824ULL, 0x000fe200078e0204ULL,
0x0000000006187211ULL, 0x040fe200078ff0ffULL, 0x0000000206467824ULL, 0x000fe200078e00ffULL,
0x0000860000097ab9ULL, 0x000fe20000000800ULL, 0x00008400000a7ab9ULL, 0x000fe20000000800ULL,
0x0000001439457248ULL, 0x000fe40007fe0000ULL, 0x0000000646467812ULL, 0x000fe400078ec0ffULL,
0x00000009ff197c19ULL, 0x000fe20008011618ULL, 0x0000000145457824ULL, 0x000fc400078e0a14ULL,
0x00008c00ff147b82ULL, 0x000ee20000000a00ULL, 0x00000008461a7c36ULL, 0x000fe20008000000ULL,
0x0000000519197c48ULL, 0x000fe2000bfe0000ULL, 0x000000ffff577224ULL, 0x000fe400078e0a45ULL,
0x0000000a46487c36ULL, 0x000fe20008000000ULL, 0x000000451a00720cULL, 0x080fe20003f26070ULL,
0x0000000818187836ULL, 0x000fe20000000000ULL, 0x000000051a1a7e46ULL, 0x000fe2000b800057ULL,
0x0000000419607c24ULL, 0x000fe2000f8e02ffULL, 0x000000454800720cULL, 0x000fc40003f06070ULL,
0x0000000548557e46ULL, 0x000fe4000b800057ULL, 0x00000004ff1a7819ULL, 0x000fe4000001161aULL,
0x000000ff55557207ULL, 0x000fe40000000000ULL, 0x000000ff1a197207ULL, 0x000fe40000800000ULL,
0x00000009ff187c19ULL, 0x000fe40008011618ULL, 0x00000060551b7211ULL, 0x000fe200078fe0ffULL,
0x00000001601d7824ULL, 0x000fe200078e0219ULL, 0x0000000518187c48ULL, 0x000fc4000bfe0000ULL,
0x00000010464c7812ULL, 0x000fe200078efcffULL, 0x000000021b1a7825ULL, 0x008fc800078e0014ULL,
0x000000021d1c7825ULL, 0x000fe200078e0014ULL, 0x000000061a597981ULL, 0x0044e6000c1e9500ULL,
0x0000000418627c24ULL, 0x000fe2000f8e02ffULL, 0x000000061c5e7981ULL, 0x000ee2000c1e9500ULL,
0x0000000a4c4a7c36ULL, 0x000fe40008000000ULL, 0x0000000119197824ULL, 0x000fe200078e0262ULL,
0x0000002046507812ULL, 0x000fe200078efcffULL, 0x000000084c1a7c36ULL, 0x004fe20008000000ULL,
0x000000454a00720cULL, 0x000fe20003f06070ULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x000000054a477e46ULL, 0x000fc4000b800057ULL, 0x00000062551f7211ULL, 0x000fe400078fe0ffULL,
0x000000ff47477207ULL, 0x000fe20000000000ULL, 0x0000000a50527c36ULL, 0x000fe20008000000ULL,
0x000000051a1b7e46ULL, 0x000fe2000b800057ULL, 0x00000006185c7981ULL, 0x000562000c1e9500ULL,
0x000000021f1e7825ULL, 0x000fe200078e0014ULL, 0x000000451a00720cULL, 0x080fe40003f26070ULL,
0x00000004ff1b7819ULL, 0x000fe2000001161bULL, 0x0000000850567c36ULL, 0x000fe20008000000ULL,
0x000000455200720cULL, 0x000fe20003f06070ULL, 0x000000061e537981ULL, 0x000564000c1e9500ULL,
0x0000006047197211ULL, 0x004fc400078fe0ffULL, 0x00000005524d7e46ULL, 0x000fe4000b800057ULL,
0x000000ff1b1d7207ULL, 0x002fe20000800000ULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x000000ff4d4d7207ULL, 0x000fe40000000000ULL, 0x00000062471f7211ULL, 0x000fe200078fe0ffULL,
0x00000001601b7824ULL, 0x000fe200078e021dULL, 0x00000005564f7e46ULL, 0x000fe2000b800057ULL,
0x0000000618497981ULL, 0x0002a2000c1e9500ULL, 0x000000011d4b7824ULL, 0x000fe200078e0262ULL,
0x000000455600720cULL, 0x000fe20003f26070ULL, 0x000000021f1c7825ULL, 0x000fe200078e0014ULL,
0x0000003046567812ULL, 0x000fc400078efcffULL, 0x00000004ff4f7819ULL, 0x000fe2000001164fULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x000000604d197211ULL, 0x002fc600078fe0ffULL,
0x000000024b1e7825ULL, 0x100fe200078e0014ULL, 0x000000ff4f517207ULL, 0x000fe20000800000ULL,
0x000000061a4e7981ULL, 0x0002a4000c1e9500ULL, 0x0000000219187825ULL, 0x000fe400078e0014ULL,
0x000000061c4b7981ULL, 0x0002a4000c1e9500ULL, 0x0000000856647c36ULL, 0x000fe40008000000ULL,
0x000000061e547981ULL, 0x0002a2000c1e9500ULL, 0x0000000a56587c36ULL, 0x000fc60008000000ULL,
0x00000006184f7981ULL, 0x0002a4000c1e9500ULL, 0x00000001601b7824ULL, 0x002fe200078e0251ULL,
0x000000624d1d7211ULL, 0x000fe200078fe0ffULL, 0x00000001511f7824ULL, 0x000fe200078e0262ULL,
0x0000000564187e46ULL, 0x000fc6000b800057ULL, 0x000000021f1e7825ULL, 0x100fe200078e0014ULL,
0x000000455800720cULL, 0x080fe40003f06070ULL, 0x0000000558577e46ULL, 0x000fe2000b800057ULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x000000456400720cULL, 0x000fe20003f26070ULL,
0x000000061e1e7981ULL, 0x000ea2000c1e9500ULL, 0x00000004ff187819ULL, 0x000fe20000011618ULL,
0x000000021d1c7825ULL, 0x000fe200078e0014ULL, 0x000000ff57577207ULL, 0x000fe20000000000ULL,
0x000000061a5a7981ULL, 0x0002a2000c1e9500ULL, 0x000000ff185b7207ULL, 0x000fc60000800000ULL,
0x000000061c517981ULL, 0x0002a2000c1e9500ULL, 0x0000006057197211ULL, 0x000fe200078fe0ffULL,
0x00000001601b7824ULL, 0x002fc800078e025bULL, 0x0000000219187825ULL, 0x000fc800078e0014ULL,
0x000000021b1a7825ULL, 0x000fe200078e0014ULL, 0x00000062571d7211ULL, 0x000fe200078fe0ffULL,
0x0000000618187981ULL, 0x0002a8000c1e9500ULL, 0x000000061a1b7981ULL, 0x0002a2000c1e9500ULL,
0x000000015b5b7824ULL, 0x000fe400078e0262ULL, 0x000000021d1c7825ULL, 0x000fc800078e0014ULL,
0x000000025b147825ULL, 0x000fe400078e0014ULL, 0x000000061c1c7981ULL, 0x000ea8000c1e9500ULL,
0x0000000614157981ULL, 0x0002a2000c1e9500ULL, 0xfffffff055607812ULL, 0x000fe200078ec0ffULL,
0x00000001ff1f7424ULL, 0x000fc800078e00ffULL, 0x0000000145197824ULL, 0x002fe200078e0260ULL,
0x0000000846607812ULL, 0x000fc600078efcffULL, 0x0000000148667824ULL, 0x000fe200078e0a19ULL,
0x0000000946627812ULL, 0x000fe200078efcffULL, 0x0000000a601a7c36ULL, 0x000fc60008000000ULL,
0x000000661f667219ULL, 0x040fe200000006ffULL, 0x0000000a62147c36ULL, 0x000fe40008000000ULL,
0x000000011a6a7824ULL, 0x100fe400078e0a19ULL, 0x00000001146c7824ULL, 0x000fe200078e0a19ULL,
0x00000018467c7812ULL, 0x000fe400078efcffULL, 0x0000006a1f6a7219ULL, 0x040fe400000006ffULL,
0x0000006c1f6c7219ULL, 0x000fc400000006ffULL, 0xfffffff047477812ULL, 0x000fe400078ec0ffULL,
0xfffffff0575b7812ULL, 0x000fe400078ec0ffULL, 0x00000019467a7812ULL, 0x000fca00078efcffULL,
0x0000000a7a1d7c36ULL, 0x000fe20008000000ULL, 0x0000002146707812ULL, 0x040fe400078efcffULL,
0x00000028466e7812ULL, 0x000fe200078efcffULL, 0x00000001455b7824ULL, 0x000fe400078e025bULL,
0x0000000a70767c36ULL, 0x000fe40008000000ULL, 0x0000000a6e747c36ULL, 0x000fe40008000000ULL,
0x00000001586b7824ULL, 0x000fca00078e0a5bULL, 0x0000006b1f6b7219ULL, 0x000fe400000006ffULL,
0x0000541059597816ULL, 0x008fe4000000005eULL, 0x00000001465e7812ULL, 0x000fe400078efcffULL,
0x0000005966ff7212ULL, 0x000fc6000780c0ffULL, 0x0000000a5e647c36ULL, 0x000fe20008000000ULL,
0x000000454800720cULL, 0x000fc60000701470ULL, 0x0000000164687824ULL, 0x000fe200078e0a19ULL,
0x000000454600720cULL, 0x000fc800007a1070ULL, 0x000000681f687219ULL, 0x000fe400000006ffULL,
0x000000596aff7212ULL, 0x080fe4000786c0ffULL, 0x0000005968ff7212ULL, 0x080fe4000782c0ffULL,
0x0000541053537816ULL, 0x020fe4000000005cULL, 0x000000596cff7212ULL, 0x000fe4000788c0ffULL,
0xff80000017177808ULL, 0x000fc40002800000ULL, 0xfffffff04d597812ULL, 0x000fe200078ec0ffULL,
0x00000001454d7824ULL, 0x040fe200078e0247ULL, 0x0000005366ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005368ff7212ULL, 0x080fe4000780c0ffULL, 0x000000536aff7212ULL, 0x080fe400078cc0ffULL,
0x000000536cff7212ULL, 0x000fe200078ac0ffULL, 0x0000000a7c537c36ULL, 0x000fe20008000000ULL,
0x000000454800720cULL, 0x080fe20001741470ULL, 0x0000000145577824ULL, 0x000fe200078e0259ULL,
0x000000451a00720cULL, 0x080fe200037c1470ULL, 0x000000014a597824ULL, 0x100fe200078e0a4dULL,
0x000000451400720cULL, 0x000fe20002fa1470ULL, 0x00000001535f7824ULL, 0x000fe200078e0a4dULL,
0x0000001146197812ULL, 0x000fc400078efcffULL, 0x000000454600720cULL, 0x080fe40001741070ULL,
0x000000456000720cULL, 0x080fe400037c1070ULL, 0x000000456200720cULL, 0x000fe40002fa1070ULL,
0x000000591f597219ULL, 0x040fe400000006ffULL, 0x0000005f1f5f7219ULL, 0x000fe400000006ffULL,
0x00005410494e7816ULL, 0x004fc4000000004eULL, 0x000054104b547816ULL, 0x000fe20000000054ULL,
0x0000000a19557c36ULL, 0x000fe20008000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40003000000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0x0000004e59ff7212ULL, 0x040fe4000784c0ffULL, 0x0000005459ff7212ULL, 0x000fc400078cc0ffULL,
0x000000545fff7212ULL, 0x000fe200078ac0ffULL, 0x00000001555d7824ULL, 0x100fe200078e0a4dULL,
0x000000456400720cULL, 0x0c0fe20000f21470ULL, 0x000000011d637824ULL, 0x000fe200078e0a4dULL,
0x000000456400720cULL, 0x080fe20000701470ULL, 0x0000000152617824ULL, 0x000fe200078e0a57ULL,
0x000000451a00720cULL, 0x080fe40001f61470ULL, 0x000000451400720cULL, 0x080fe40002781470ULL,
0x000000454a00720cULL, 0x000fc40001741470ULL, 0x000000454a00720cULL, 0x080fe400037c1470ULL,
0x000000455300720cULL, 0x080fe40002fa1470ULL, 0x00000029466c7812ULL, 0x000fe400078efcffULL,
0x000000455e00720cULL, 0x0c0fe40000f21070ULL, 0x000000455e00720cULL, 0x080fe40000701070ULL,
0x000000456000720cULL, 0x000fc40001f61070ULL, 0x000000456200720cULL, 0x080fe40002781070ULL,
0x000000454c00720cULL, 0x0c0fe40001741070ULL, 0x000000454c00720cULL, 0x080fe400037c1070ULL,
0x000000457c00720cULL, 0x000fe40002fa1070ULL, 0x0000005d1f5d7219ULL, 0x040fe400000006ffULL,
0x000000631f637219ULL, 0x000fc400000006ffULL, 0x000000611f617219ULL, 0x000fe400000006ffULL,
0x000054104f5a7816ULL, 0x000fe4000000005aULL, 0x00005410511e7816ULL, 0x000fe2000000001eULL,
0x0000000a6c727c36ULL, 0x000fe20008000000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000000000ULL, 0xff80000034347808ULL, 0x000fc40001800000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0x0000004e5dff7212ULL, 0x080fe4000782c0ffULL, 0x0000004e5fff7212ULL, 0x000fc4000780c0ffULL,
0x0000004e63ff7212ULL, 0x000fe4000786c0ffULL, 0x000000545dff7212ULL, 0x080fe4000788c0ffULL,
0x0000005463ff7212ULL, 0x000fe4000784c0ffULL, 0x0000005a61ff7212ULL, 0x040fe400078cc0ffULL,
0x0000001e61ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000176657824ULL, 0x100fe200078e0a57ULL,
0x000000455500720cULL, 0x0c0fe20000f21470ULL, 0x0000000174677824ULL, 0x100fe200078e0a57ULL,
0x000000455500720cULL, 0x080fe20002781470ULL, 0x0000000172697824ULL, 0x000fe200078e0a57ULL,
0x000000455300720cULL, 0x000fc40000701470ULL, 0x000000451d00720cULL, 0x0c0fe40001f61470ULL,
0x000000451d00720cULL, 0x080fe40001741470ULL, 0x000000455200720cULL, 0x0c0fe400037c1470ULL,
0x000000455200720cULL, 0x000fe40002fa1470ULL, 0x0000003146687812ULL, 0x040fe400078efcffULL,
0x0000003846667812ULL, 0x000fc400078efcffULL, 0x00000039465c7812ULL, 0x000fe400078efcffULL,
0x000000451900720cULL, 0x0c0fe40000f21070ULL, 0x000000451900720cULL, 0x080fe40002781070ULL,
0x000000457c00720cULL, 0x080fe40000701070ULL, 0x000000457a00720cULL, 0x0c0fe40001f61070ULL,
0x000000457a00720cULL, 0x000fc40001741070ULL, 0x000000455000720cULL, 0x0c0fe400037c1070ULL,
0x000000455000720cULL, 0x000fe40002fa1070ULL, 0x000000651f657219ULL, 0x040fe400000006ffULL,
0x000000671f677219ULL, 0x040fe400000006ffULL, 0x000000691f697219ULL, 0x000fe400000006ffULL,
0x0000541018187816ULL, 0x000fe2000000001bULL, 0x0000000a686a7c36ULL, 0x000fe20008000000ULL,
0xff80000031317808ULL, 0x000fe20000800000ULL, 0x0000000a66787c36ULL, 0x000fe20008000000ULL,
0xff80000033337808ULL, 0x000fe20002000000ULL, 0x0000000a5c477c36ULL, 0x000fe20008000000ULL,
0xff8000002c2c7808ULL, 0x000fc40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x0000005a65ff7212ULL, 0x080fe4000782c0ffULL,
0x0000005a67ff7212ULL, 0x000fc4000788c0ffULL, 0x0000005a69ff7212ULL, 0x000fe4000780c0ffULL,
0x0000001e65ff7212ULL, 0x080fe4000786c0ffULL, 0x0000001e67ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001e69ff7212ULL, 0x000fe400078cc0ffULL, 0x000000186bff7212ULL, 0x000fe200078ac0ffULL,
0x000000016a577824ULL, 0x100fe200078e0a5bULL, 0x000000457600720cULL, 0x080fe20000f21470ULL,
0x00000001784d7824ULL, 0x100fe200078e0a5bULL, 0x000000457600720cULL, 0x080fe20001f61470ULL,
0x00000001475b7824ULL, 0x000fe200078e0a5bULL, 0x000000457400720cULL, 0x000fc40002781470ULL,
0x000000457400720cULL, 0x080fe40001741470ULL, 0x000000457200720cULL, 0x0c0fe40000701470ULL,
0x000000457200720cULL, 0x080fe400037c1470ULL, 0x000000455800720cULL, 0x080fe40002fa1470ULL,
0x000000457000720cULL, 0x0c0fe40000f21070ULL, 0x000000457000720cULL, 0x000fc40001f61070ULL,
0x000000456e00720cULL, 0x0c0fe40002781070ULL, 0x000000456e00720cULL, 0x080fe40001741070ULL,
0x000000456c00720cULL, 0x0c0fe40000701070ULL, 0x000000456c00720cULL, 0x080fe400037c1070ULL,
0x000000455600720cULL, 0x000fe40002fa1070ULL, 0x000000571f577219ULL, 0x000fc400000006ffULL,
0x0000004d1f4d7219ULL, 0x040fe400000006ffULL, 0x0000005b1f5b7219ULL, 0x000fe400000006ffULL,
0x000054101c1c7816ULL, 0x000fe40000000015ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000016167808ULL, 0x000fc40002000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40003000000ULL, 0xff8000003c3c7808ULL, 0x000fe40002800000ULL,
0x0000001857ff7212ULL, 0x080fe4000782c0ffULL, 0x000000184dff7212ULL, 0x000fc4000786c0ffULL,
0x000000185bff7212ULL, 0x000fe4000788c0ffULL, 0x0000001c6bff7212ULL, 0x080fe4000784c0ffULL,
0x0000001c57ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001c4dff7212ULL, 0x080fe400078cc0ffULL,
0x0000001c5bff7212ULL, 0x000fe400078ac0ffULL, 0x000000455800720cULL, 0x000fc40001741470ULL,
0x000000456a00720cULL, 0x0c0fe40000f21470ULL, 0x000000456a00720cULL, 0x080fe40000701470ULL,
0x000000457800720cULL, 0x0c0fe40001f61470ULL, 0x000000457800720cULL, 0x080fe400037c1470ULL,
0x000000454700720cULL, 0x0c0fe40002781470ULL, 0x000000454700720cULL, 0x000fc40002fa1470ULL,
0x000000455600720cULL, 0x080fe40001741070ULL, 0x000000456800720cULL, 0x0c0fe40000f21070ULL,
0x000000456800720cULL, 0x080fe40000701070ULL, 0x000000456600720cULL, 0x0c0fe40001f61070ULL,
0x000000456600720cULL, 0x080fe400037c1070ULL, 0x000000455c00720cULL, 0x000fc40002781070ULL,
0x000000455c00720cULL, 0x000fe40002fa1070ULL, 0xff80000041417808ULL, 0x000fe40000800000ULL,
0xff80000042427808ULL, 0x000fe40001800000ULL, 0xff80000044447808ULL, 0x000fe40002000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fc40000000000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fce0002800000ULL,
0x000000171000720bULL, 0x004fe20003f1e000ULL, 0x3f80000000097882ULL, 0x000fe20000000000ULL,
0x000000010f0f7836ULL, 0x000fe40000000000ULL, 0x0000001017107208ULL, 0x000fc80004000000ULL,
0x0000003d1000720bULL, 0x000fc80003f1e000ULL, 0x000000103d157208ULL, 0x000fc80004000000ULL,
0x000000341500720bULL, 0x000fc80003f1e000ULL, 0x0000001534107208ULL, 0x000fc80004000000ULL,
0x000000351000720bULL, 0x000fc80003f1e000ULL, 0x0000001035157208ULL, 0x000fc80004000000ULL,
0x000000301500720bULL, 0x000fc80003f1e000ULL, 0x0000001530107208ULL, 0x000fc80004000000ULL,
0x000000311000720bULL, 0x000fc80003f1e000ULL, 0x0000001031157208ULL, 0x000fc80004000000ULL,
0x0000002c1500720bULL, 0x000fc80003f1e000ULL, 0x000000152c107208ULL, 0x000fc80004000000ULL,
0x0000002d1000720bULL, 0x000fc80003f1e000ULL, 0x000000102d157208ULL, 0x000fc80004000000ULL,
0x000000281500720bULL, 0x000fc80003f1e000ULL, 0x0000001528107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x0000001029157208ULL, 0x000fc80004000000ULL,
0x000000161500720bULL, 0x000fc80003f1e000ULL, 0x0000001516107208ULL, 0x000fe40004000000ULL,
0x0000003e1100720bULL, 0x000fe40003f1e000ULL, 0x000000251000720bULL, 0x000fc80003f3e000ULL,
0x0000001025157208ULL, 0x000fe40004800000ULL, 0x000000113e107208ULL, 0x000fe40004000000ULL,
0x0000003c1500720bULL, 0x000fe40003f3e000ULL, 0x0000003f1000720bULL, 0x000fe40003f1e000ULL,
0x000000153c147208ULL, 0x000fe40004800000ULL, 0x000000103f117208ULL, 0x000fc40004000000ULL,
0x000000411400720bULL, 0x000fe40003f3e000ULL, 0x000000361100720bULL, 0x000fe40003f1e000ULL,
0x0000001441157208ULL, 0x000fe40004800000ULL, 0x0000001136107208ULL, 0x000fe40004000000ULL,
0x000000421500720bULL, 0x000fe40003f3e000ULL, 0x000000371000720bULL, 0x000fc40003f1e000ULL,
0x0000001542157208ULL, 0x000fe40004800000ULL, 0x0000001037117208ULL, 0x000fe40004000000ULL,
0x000000441500720bULL, 0x000fe40003f3e000ULL, 0x000000321100720bULL, 0x000fe40003f1e000ULL,
0x0000001544157208ULL, 0x000fe40004800000ULL, 0x0000001132107208ULL, 0x000fc60004000000ULL,
0x0c401f0015147f89ULL, 0x000ea200000e0000ULL, 0x000000331000720bULL, 0x000fc80003f1e000ULL,
0x0000001033117208ULL, 0x000fc80004000000ULL, 0x0000002e1100720bULL, 0x000fc80003f1e000ULL,
0x000000112e107208ULL, 0x000fc80004000000ULL, 0x0000002f1000720bULL, 0x000fc80003f1e000ULL,
0x000000102f117208ULL, 0x000fe40004000000ULL, 0x000000141500720bULL, 0x004fe40003f3e000ULL,
0x0000002a1100720bULL, 0x000fe40003f1e000ULL, 0x0000001514187208ULL, 0x000fe40004800000ULL,
0x000000112a107208ULL, 0x000fc60004000000ULL, 0x0c201f0018157f89ULL, 0x000ea200000e0000ULL,
0x0000002b1000720bULL, 0x000fc80003f1e000ULL, 0x000000102b117208ULL, 0x000fc80004000000ULL,
0x000000261100720bULL, 0x000fc80003f1e000ULL, 0x0000001126107208ULL, 0x000fc80004000000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x0000001027117208ULL, 0x000fe40004000000ULL,
0x000000151800720bULL, 0x004fe40003f3e000ULL, 0x000000221100720bULL, 0x000fe40003f1e000ULL,
0x0000001815107208ULL, 0x000fe40004800000ULL, 0x0000001122147208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10157820ULL, 0x000fe20000410000ULL, 0x000000231400720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010815ULL, 0x0000001423117208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010815ULL,
0x00000031001d7308ULL, 0x0005e20000000800ULL, 0x000000201100720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010815ULL, 0x0000001120147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010815ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x000000211400720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b16317823ULL, 0x104fe20000010815ULL, 0x3fb8aa3b25167823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b3c257823ULL, 0x100fe20000010815ULL, 0x0000001421147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010815ULL,
0x0000003d00187308ULL, 0x000fe40000000800ULL, 0x0c401f0014117f89ULL, 0x000eac00000e0000ULL,
0x0000003400197308ULL, 0x0007f00000000800ULL, 0x00000035001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b42347823ULL, 0x008fce0000010815ULL, 0x0000002c001e7308ULL, 0x0007e20000000800ULL,
0x000000111400720bULL, 0x004fc80003f1e000ULL, 0x0000001411117208ULL, 0x000fc60004000000ULL,
0x00000030001c7308ULL, 0x0005620000000800ULL, 0x00000009ff2c7e24ULL, 0x008fe2000f8e00ffULL,
0x0c201f0011147f89ULL, 0x000ee800000e0000ULL, 0x3f8000002c2c783eULL, 0x000fe400000010ffULL,
0x0000002d001f7308ULL, 0x000ae20000000800ULL, 0x3fb8aa3b41307823ULL, 0x104fe20000010815ULL,
0x3fb8aa3b44157823ULL, 0x000fe20000010815ULL, 0x0000001c1d1c723eULL, 0x022fca00000010ffULL,
0x0000001600467308ULL, 0x0003e20000000800ULL, 0x000000ffff2d7224ULL, 0x000fe200078e002cULL,
0x0000001e1f1e723eULL, 0x008fcc00000010ffULL, 0x0000001500357308ULL, 0x000fe20000000800ULL,
0x000000191a16723eULL, 0x002fe400000010ffULL, 0x000000141100720bULL, 0x000fc80003f1e000ULL,
0x0000001114117208ULL, 0x000fe20004000000ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000171814723eULL, 0x000fc600000010ffULL, 0x3fb8aa3b113c7820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe2000001083cULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe2000001083cULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001083cULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001083cULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001083cULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001083cULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001083cULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001083cULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001083cULL,
0x3fb8aa3b2b2b7823ULL, 0x000fc8000001083cULL, 0x0000003f003f7308ULL, 0x000e700000000800ULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x0000003e3f15723eULL, 0x002fce00000010ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000ffff3e7224ULL, 0x100fe400078e002cULL,
0x000000ffff3f7224ULL, 0x000fca00078e002cULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x000000363717723eULL, 0x002fce00000010ffULL, 0x0000003300337308ULL, 0x000e620000000800ULL,
0x3fb8aa3b26367823ULL, 0x100fe4000001083cULL, 0x0c401f0013267f89ULL, 0x000ea200000e0000ULL,
0x0000002c1418723cULL, 0x000fe800000418ffULL, 0x0000002e002e7308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b272d7823ULL, 0x000fe2000001083cULL, 0x00000032331d723eULL, 0x002fc800000010ffULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x0c401f0012277f89ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b22327823ULL, 0x100fe2000001083cULL, 0x3fb8aa3b20337823ULL, 0x000fca000001083cULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000261300720bULL, 0x004fe40003f3e000ULL,
0x0000002e2f1f723eULL, 0x002fca00000010ffULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b232e7823ULL, 0x100fe2000001083cULL, 0x3fb8aa3b213c7823ULL, 0x000fe2000001083cULL,
0x0000001326137208ULL, 0x000fe40004800000ULL, 0xfffffff8ff267812ULL, 0x000fe200078ee243ULL,
0x0000003e1c18723cULL, 0x000fe40000041818ULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x000000271200720bULL, 0x008fc80003f1e000ULL, 0x0000001227127208ULL, 0x000fe40004000000ULL,
0x000000362d23723eULL, 0x002fe200000010ffULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x000000ffff2d7224ULL, 0x000fe200078e002cULL, 0x000000282920723eULL, 0x004fcc00000010ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000314622723eULL, 0x002fce00000010ffULL,
0x0000002b002b7308ULL, 0x000e700000000800ULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000002a2b21723eULL, 0x002fce00000010ffULL, 0x0000003000307308ULL, 0x000e620000000800ULL,
0x0000002c2018723cULL, 0x000fee0000041818ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x00000800402d7824ULL, 0x000fe200078e020dULL, 0x000000253028723eULL, 0x002fcc00000010ffULL,
0x0000002e002f7308ULL, 0x0002a20000000800ULL, 0x00000003ff257819ULL, 0x000fe20000011606ULL,
0x0000000826307824ULL, 0x000fc600078e00ffULL, 0x0000000325257812ULL, 0x000fc600078ec0ffULL,
0x0000003400347308ULL, 0x000ee20000000800ULL, 0x00000008262e7836ULL, 0x002fe40000000000ULL,
0x0000000125277824ULL, 0x000fe400078e0226ULL, 0x000000082e367824ULL, 0x040fe200078e00ffULL,
0x000000322f29723eULL, 0x004fe400000010ffULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x00000001252f7824ULL, 0x000fe400078e022eULL, 0x0c201f0012257f89ULL, 0x000e6200000e0000ULL,
0x000000082e327824ULL, 0x000fc400078e00ffULL, 0x00000004272e7836ULL, 0x000fe20000000000ULL,
0x00000034352a723eULL, 0x008fe200000010ffULL, 0x0000003c003c7308ULL, 0x000ea20000000800ULL,
0x000000ffff347224ULL, 0x100fe400078e002cULL, 0x000000ffff357224ULL, 0x000fe200078e002cULL,
0xfffffff8302c7812ULL, 0x000fe200078ee227ULL, 0x0000000c27317836ULL, 0x000fe20000000000ULL,
0xfffffff832307812ULL, 0x000fe200078ee22fULL, 0x000110002d277836ULL, 0x000fe40000000000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0016ULL, 0xfffffff836367812ULL, 0x000fe200078ee231ULL,
0x000000ffff2f7224ULL, 0x000fc400078e001eULL, 0x000000ffff317224ULL, 0x000fe200078e0022ULL,
0x000000333c2b723eULL, 0x004fe200000010ffULL, 0x0000000826337824ULL, 0x000fe400078e00ffULL,
0x0c201f0013267f89ULL, 0x000ea200000e0000ULL, 0x000000251200720bULL, 0x002fe20003f1e000ULL,
0x000000ffff327224ULL, 0x000fe200078e0028ULL, 0xfffffff8332e7812ULL, 0x000fe200078ee22eULL,
0x000000342818723cULL, 0x000fe20000041818ULL, 0x0000001225127208ULL, 0x000fca0004000000ULL,
0x000000ffff337224ULL, 0x000fe200078e002aULL, 0x0000000306ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x0000001036367824ULL, 0x100fe400078e0227ULL,
0x0000001030347824ULL, 0x000fe400078e0227ULL, 0x000000ffff307224ULL, 0x000fe400078e0020ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0023ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0029ULL,
0x000000102c197824ULL, 0x100fe200078e0227ULL, 0x000000261300720bULL, 0x004fe20003f3e000ULL,
0x000000102e1b7824ULL, 0x000fe400078e0227ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0014ULL,
0x0000001326137208ULL, 0x000fe20004800000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e001cULL,
0x000000ffff147224ULL, 0x000fc400078e0015ULL, 0x000000ffff157224ULL, 0x000fe200078e0017ULL,
0x0000002c19007844ULL, 0x0003e20000000200ULL, 0x000000ffff177224ULL, 0x000fe400078e001fULL,
0x000000ffff1c7224ULL, 0x000fe200078e0021ULL, 0x000000301b007844ULL, 0x0005e20000000200ULL,
0x000000ffff1f7224ULL, 0x000fe400078e002bULL, 0x000000ffff207224ULL, 0x000fe200078e0018ULL,
0x0000001434007844ULL, 0x0005e20000000200ULL, 0x000000ffff217224ULL, 0x000fc400078e001aULL,
0x000000ffff187224ULL, 0x000fe200078e003bULL, 0x0000001c36007844ULL, 0x0005e80000000200ULL,
0x0170001024008388ULL, 0x0005e20000000c00ULL, 0x00000001ff197424ULL, 0x002fc600078e00ffULL,
0x0172002024008388ULL, 0x0005e20000000a00ULL, 0x000000380f00720cULL, 0x000fe20003f06070ULL,
0x017608190cff79a7ULL, 0x0005e2000850003fULL, 0x017610190cff79a7ULL, 0x0005e2000850003fULL,
0x017618190cff79a7ULL, 0x0005e2000850003fULL, 0x017620190cff79a7ULL, 0x0005f2000850003fULL,
0xffffffac00d48947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000054007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000005400008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff54ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000054027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffed402287950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x000000000000057fULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000700ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000958ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a38ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a8cULL,
0x0000000000000660ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001138ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000012c00ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013d80ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013dd0ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000013dd0ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x00000000000143c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000143c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001138ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012c00ULL, 0x0000000000012c00ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013d80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000013dd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_90_cubin_len = 83216;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
