/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001fbc0ULL, 0x000000000001f840ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001dc50ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001ddd0ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001de10ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001de60ULL, 0x0000000000000120ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001df80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001dc5000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x0075a40400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001dc5000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL,
0x2880808608288080ULL, 0x808d082880808c08ULL, 0x082880808e082880ULL, 0x8080a1082880808fULL,
0xa708288080a60828ULL, 0x288080a908288080ULL, 0x80f108288080ec08ULL, 0x08288080f2082880ULL,
0x80809208288080f3ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880809292ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001ddd000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL,
0x2880808608288080ULL, 0x808d082880808c08ULL, 0x082880808e082880ULL, 0x8080a1082880808fULL,
0xa808288080a60828ULL, 0x288080a908288080ULL, 0x80f108288080ec08ULL, 0x08288080f2082880ULL,
0x8080a708288080f3ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a792ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001de1000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80ec288080a70900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808608288080ULL, 0x808d082880808c08ULL,
0x082880808e082880ULL, 0x8080a1082880808fULL, 0xa708288080a60828ULL, 0x288080a908288080ULL,
0x80f108288080ec08ULL, 0x08288080f2082880ULL, 0x8080a808288080f3ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a892ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL,
0x0001de6000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000faULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0060016000000016ULL, 0x000c170400601903ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000b0000043104ULL,
0xffffffff019c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x00000110019c2804ULL, 0x0000058000000310ULL, 0x00002a0000002970ULL, 0x00002c8000002b10ULL,
0x00002f5000002df0ULL, 0x000033e0000033a0ULL, 0x00003420000033f0ULL, 0x000065d000006540ULL,
0x00006860000066f0ULL, 0x00006b30000069d0ULL, 0x00006ff000006fb0ULL, 0x0000703000007000ULL,
0x00009fd000009f30ULL, 0x0000a2500000a0e0ULL, 0x0000a5200000a3c0ULL, 0x0000a9d00000a990ULL,
0x0000aa100000a9e0ULL, 0x0000da900000da00ULL, 0x0000dd100000dba0ULL, 0x0000dfe00000de80ULL,
0x0000e4a00000e460ULL, 0x0000e4e00000e4b0ULL, 0x0001085000010840ULL, 0x0001087000010860ULL,
0x0001b3400001b300ULL, 0x0001b3600001b350ULL, 0x0001b3d00001b370ULL, 0x0001b4100001b3f0ULL,
0x0001c8b00001c850ULL, 0x0001c9800001c920ULL, 0x0001ca400001c9e0ULL, 0x0001cb200001cab0ULL,
0x0001cc000001cb90ULL, 0x0001ccc00001cc60ULL, 0x0001cd900001cd30ULL, 0x0001ce500001cdf0ULL,
0x0001cf300001cec0ULL, 0x0001d0100001cfa0ULL, 0x0001d0d00001d070ULL, 0x0001d1a00001d140ULL,
0x0001d2600001d200ULL, 0x0001d3400001d2d0ULL, 0x0001d4200001d3b0ULL, 0x0001d4e00001d480ULL,
0x0001d5b00001d550ULL, 0x0001d6700001d610ULL, 0x0001d7500001d6e0ULL, 0x0001d8300001d7c0ULL,
0x0001d9300001d8b0ULL, 0x0001da300001d9b0ULL, 0x0001db300001dab0ULL, 0x0001dc300001dbb0ULL,
0x000003e004403904ULL, 0x0001a600000000ffULL, 0x00000440003f0100ULL, 0x0001a6080000000bULL,
0x000004d0003f0120ULL, 0x0001a6880000000bULL, 0x00000530003f0120ULL, 0x0001a6a80000000bULL,
0x00000560003f0120ULL, 0x0001a6c80000000bULL, 0x00000b20003f0120ULL, 0x0001a600000000ffULL,
0x00000d10003f0107ULL, 0x0000000400000006ULL, 0x00000dc0003f0102ULL, 0x0000000000000006ULL,
0x000017d0003f0101ULL, 0x00000000000000ffULL, 0x0000185000040107ULL, 0x00000000000000ffULL,
0x000018b000040101ULL, 0x0000002000000004ULL, 0x00001a60003f0101ULL, 0x0001a6cc00000008ULL,
0x00001c30003f0105ULL, 0x0001a6cc00000008ULL, 0x00002570003f0105ULL, 0x0001a6b00000000aULL,
0x00002620003f0107ULL, 0x0001a6b00000000aULL, 0x00002680003f0101ULL, 0x0001a60800000023ULL,
0x000026a0003f0101ULL, 0x0001a60c00000023ULL, 0x00002870003f0105ULL, 0x0001a60c00000023ULL,
0x00003100003f0105ULL, 0x0001a6ac0000000aULL, 0x000032d0003f0105ULL, 0x0001a6ac0000000aULL,
0x000056b0003f0105ULL, 0x000000000000002aULL, 0x00005710003f0101ULL, 0x0001a68800000025ULL,
0x00005740003f0101ULL, 0x0000000400000013ULL, 0x00005900003f0105ULL, 0x0000000400000013ULL,
0x00006150003f0105ULL, 0x0001a6a800000025ULL, 0x00006220003f0107ULL, 0x0001a6a800000025ULL,
0x00006280003f0101ULL, 0x0001a62800000023ULL, 0x000062a0003f0101ULL, 0x0001a62c00000023ULL,
0x00006470003f0105ULL, 0x0001a62c00000023ULL, 0x00006d20003f0105ULL, 0x0001a6b40000006dULL,
0x00006ef0003f0105ULL, 0x0001a6b40000006dULL, 0x000090a0003f0105ULL, 0x000000000000006eULL,
0x00009100003f0101ULL, 0x0001a69000000028ULL, 0x00009130003f0101ULL, 0x0000000400000013ULL,
0x000092f0003f0105ULL, 0x0000000400000013ULL, 0x00009b40003f0105ULL, 0x0001a6b000000027ULL,
0x00009c10003f0107ULL, 0x0001a6b000000027ULL, 0x00009c70003f0101ULL, 0x0001a64800000023ULL,
0x00009c90003f0101ULL, 0x0001a64c00000023ULL, 0x00009e60003f0105ULL, 0x0001a64c00000023ULL,
0x0000a700003f0105ULL, 0x0001a6ac00000070ULL, 0x0000a8d0003f0105ULL, 0x0001a6ac00000070ULL,
0x0000ca80003f0105ULL, 0x0000000000000027ULL, 0x0000cae0003f0101ULL, 0x0001a69800000002ULL,
0x0000cb10003f0101ULL, 0x0000000400000027ULL, 0x0000cd00003f0105ULL, 0x0000000400000027ULL,
0x0000d660003f0105ULL, 0x0001a6a800000003ULL, 0x0000d6f0003f0107ULL, 0x0001a6a800000003ULL,
0x0000d750003f0101ULL, 0x0001a66800000006ULL, 0x0000d780003f0101ULL, 0x0001a66c00000006ULL,
0x0000d950003f0105ULL, 0x0001a66c00000006ULL, 0x0000e1c0003f0105ULL, 0x0001a6b400000012ULL,
0x0000e390003f0105ULL, 0x0001a6b400000012ULL, 0x000105f0003f0105ULL, 0x0000000000000013ULL,
0x00010670003f0101ULL, 0x0000000000000006ULL, 0x00012430003f0101ULL, 0x0001a600000000ffULL,
0x00013d20003f0101ULL, 0x0001a604000000ffULL, 0x00013ef0003f0105ULL, 0x0001a604000000ffULL,
0x00014270003f0105ULL, 0x0001a600000000ffULL, 0x000142a0003f0101ULL, 0x0001a604000000ffULL,
0x00014460003f0105ULL, 0x0001a604000000ffULL, 0x00018860003f0105ULL, 0x0000000000000008ULL,
0x00018910003f0101ULL, 0x0000000400000008ULL, 0x00018ae0003f0105ULL, 0x0000000400000008ULL,
0x0001c690003f0105ULL, 0x0000000000000009ULL, 0x0001c6f0003f0101ULL, 0x0000000800000009ULL,
0x0001c750003f0101ULL, 0x0000001000000009ULL, 0x0001c7c0003f0101ULL, 0x0000001800000009ULL,
0x00053803003f0101ULL, 0x000117d000301c04ULL, 0x000119e000011800ULL, 0x00011ca000011b40ULL,
0x00011f6000011e00ULL, 0x00012250000120c0ULL, 0x000144c000012350ULL, 0x000004010001c810ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL, 0x000000000000025cULL,
0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL, 0x00000000000000ccULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000308ULL,
0x0000001900000002ULL, 0x0000000000000238ULL, 0x0000001900000002ULL, 0x0000000000000178ULL,
0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL, 0x000000000001a700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ffbc7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000767919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a00bc807a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x0000000000be7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff207819ULL, 0x010fc80000011609ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff20207589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e02bcULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fe400078e0002ULL,
0x0000000000057919ULL, 0x000ee80000002200ULL, 0x0000007603197227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a19ULL, 0x0000000007007224ULL, 0x000fca00078e0276ULL,
0x000000070000720cULL, 0x000fe20003f46070ULL, 0x000001000a027a24ULL, 0x008fc800078e0205ULL,
0x00000000020b7a24ULL, 0x000fd000078e0209ULL, 0x0000000100002824ULL, 0x000fe200078e0a07ULL,
0x0000000119192810ULL, 0x000fe20007ffe0ffULL, 0x00001fff0a097589ULL, 0x000e6200000e0000ULL,
0x000000ff0b00720cULL, 0x040fe40003fa5270ULL, 0x000000070000720cULL, 0x000fe40003f66070ULL,
0x0000007f0b00780cULL, 0x040fe40003f04070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff02d424ULL, 0x000fe400078e00ffULL,
0x0000000119193810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff03d424ULL, 0x000fe200078e00ffULL,
0x00000007ff19c212ULL, 0x000fe200078e33ffULL, 0xff317217ff088424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f64070ULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x01a60002ff00d388ULL, 0x0005e20000000a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a19ULL,
0x00005a0019757a19ULL, 0x000fe200000006ffULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x01a400080b008388ULL, 0x0007e20000004800ULL, 0x0000000007767224ULL, 0x000fc600078e0276ULL,
0x01a608040b009388ULL, 0x0009e20000008a00ULL, 0x0000002076007824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe200078e00ffULL,
0x0000000400087c10ULL, 0x048fe2000fffe1ffULL, 0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL,
0x0000000400007c0cULL, 0x000fe2000bf03070ULL, 0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL,
0x0000002008087817ULL, 0x000fe20003800000ULL, 0x01a688020b00a388ULL, 0x0005e20000008a00ULL,
0x3fffff80ff04a424ULL, 0x010fc400078e00ffULL, 0x000000ff08747207ULL, 0x000fe20000000000ULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x0000000409087824ULL, 0x002fe200078e0220ULL,
0x000000207400780cULL, 0x000fe40003f05270ULL, 0x01a6a8040b00a388ULL, 0x000fe20000008a00ULL,
0x0000000408087824ULL, 0x000fe400078e00ffULL, 0x00005800be027a24ULL, 0x004fe200078e02ffULL,
0x01a6c8060b00b388ULL, 0x000fe60000008a00ULL, 0x0000008002027224ULL, 0x000fe200078e0275ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000874037217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x00000004ff047819ULL, 0x002fc8000001161fULL, 0x0000000204067810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0204ULL, 0x000000030400720cULL, 0x080fe20003f06070ULL,
0x000000101f047824ULL, 0x000fe200078e00ffULL, 0x000000030600720cULL, 0x000fe20003f26070ULL,
0x00000001080b7824ULL, 0x000fe400078e0206ULL, 0x0000000100057824ULL, 0x040fe400078e020aULL,
0x00000001000c7824ULL, 0x000fc600078e020bULL, 0x0000000405077c12ULL, 0x000fe4000f8e30ffULL,
0x000000040c0d7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe20000011605ULL,
0x0000000102077824ULL, 0x040fe400078e0207ULL, 0x0000000102087824ULL, 0x000fe200078e020dULL,
0x00005a00ff0d7a19ULL, 0x000fe2000001160cULL, 0x0000008005027224ULL, 0x000fe200078e0207ULL,
0x000000f004057812ULL, 0x000fc600078ec0ffULL, 0x000000800d077224ULL, 0x000fe400078e0208ULL,
0x0000010002027825ULL, 0x000fc800078e00ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000502027212ULL, 0x000fc600078efcffULL, 0x000000010a087824ULL, 0x100fe200078e021fULL,
0x0000000506057212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e021fULL,
0x00005e0005067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d087812ULL, 0x000fe400078ee208ULL, 0x00005f0003037a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001008057824ULL, 0x000fe200078e00ffULL,
0x00005f0007077a10ULL, 0x000fc60001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000c101c48ULL,
0x00000000060b7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x000000081f087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x00000010080c7824ULL, 0x000fe400078e00ffULL,
0x0000000100047824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fe40000011603ULL, 0x0000000404077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fc800078e0205ULL, 0x0000000102027824ULL, 0x000fe200078e0207ULL,
0x00005a00ff077a19ULL, 0x000fe20000011604ULL, 0x0000008003037224ULL, 0x080fe400078e0205ULL,
0x000000101f047824ULL, 0x000fe400078e00ffULL, 0x0000008007077224ULL, 0x000fe400078e0202ULL,
0x0000010003027825ULL, 0x000fe200078e00ffULL, 0x000000f0040b7812ULL, 0x000fc600078ec0ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000b02027212ULL, 0x000fc600078efcffULL,
0x0000000108057824ULL, 0x100fe200078e021fULL, 0x0000000b06067212ULL, 0x000fe200078efcffULL,
0x000000010a087824ULL, 0x000fe200078e021fULL, 0x00005e0002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee208ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000b901c48ULL,
0x00000000060b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000057806ULL, 0x000fe200038e0000ULL, 0x00000004ff077424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000500027300ULL, 0x000e7000000e0000ULL,
0x0000000500067309ULL, 0x000ea20000000000ULL, 0x000000030200720cULL, 0x002fe20003f02070ULL,
0x00006600be027625ULL, 0x000fc800078e0007ULL, 0x000000ffff067224ULL, 0x004fd000078e0a06ULL,
0x01a60406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008021e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x0000003f1e1d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff1e057810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff1d7819ULL, 0x000fe4000001161dULL,
0x00000008ff1c7819ULL, 0x000fca0000011605ULL, 0x0001170000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1b7819ULL, 0x000fe20000011620ULL, 0x00000003ff097424ULL, 0x000fe200078e00ffULL,
0x0001a68820067811ULL, 0x002fe400078e18ffULL, 0x03ffffff1b187812ULL, 0x000fc800078ec0ffULL,
0x0000001d1800720cULL, 0x000fda0003f06070ULL, 0x00000002be008824ULL, 0x000fe400078e00ffULL,
0x00006800ff038624ULL, 0x000fc800078e00ffULL, 0x0000680000038624ULL, 0x000fe400078e0203ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000118028824ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040906ff738cULL, 0x0003e20000000000ULL,
0x0000640002028625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000802008981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x0000004019197824ULL, 0x000fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011620ULL,
0x0000000006ff7f8cULL, 0x0007e8000c80043fULL, 0x000000201a777824ULL, 0x000fca00078e00ffULL,
0x0000002019057812ULL, 0x000fe200078ef877ULL, 0x0000590000087a24ULL, 0x004fe200078e02ffULL,
0x0000000120007812ULL, 0x000fc600078ec0ffULL, 0x0000004008177824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000001000037824ULL, 0x008fe200078e00ffULL,
0x000000771e007217ULL, 0x000fe40007800000ULL, 0x00000003ff027819ULL, 0x000fe4000001161fULL,
0x0000620017117a11ULL, 0x000fe200078838ffULL, 0x0000000100007824ULL, 0x000fe200078e0a77ULL,
0x0000000402097810ULL, 0x002fe20007ffe0ffULL, 0x0000000103067824ULL, 0x000fe200078e0202ULL,
0x0000630017177a11ULL, 0x000fc400020f3cffULL, 0x0000000300007217ULL, 0x000fe20007800000ULL,
0x0000000106087824ULL, 0x040fe400078e021fULL, 0x00000008060b7824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fc600078e0a03ULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee208ULL,
0x0000000802087810ULL, 0x040fe40007ffe0ffULL, 0x000000000200720cULL, 0x0c0fe40003f66070ULL,
0x0000000c020b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105027824ULL, 0x000fe200078e0206ULL,
0x000000000900720cULL, 0x080fe20003f46070ULL, 0x0000000103067824ULL, 0x040fe200078e0209ULL,
0x000000000800720cULL, 0x080fe20003f26070ULL, 0x00000001030a7824ULL, 0x000fe200078e0208ULL,
0x000000000b00720cULL, 0x000fe20003f06070ULL, 0x00000001030c7824ULL, 0x000fc400078e020bULL,
0x0000000106037824ULL, 0x140fe400078e021fULL, 0x0000000806107824ULL, 0x000fe400078e00ffULL,
0x000000010a087824ULL, 0x040fe400078e021fULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0xfffffff810007812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fc600078e00ffULL,
0xfffffff809107812ULL, 0x000fe200078ee208ULL, 0x0000000105087824ULL, 0x040fe200078e0206ULL,
0x0000007002027812ULL, 0x000fe200078ef804ULL, 0x00000001050a7824ULL, 0x040fe400078e020aULL,
0x00000001050d7824ULL, 0x000fe200078e020cULL, 0x0000000211027210ULL, 0x000fe20007f9e0ffULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x000000010c057824ULL, 0x000fe200078e021fULL,
0x00000070080f7812ULL, 0x000fe200078ef804ULL, 0x000000080c067824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff806067812ULL, 0x000fe200078ee205ULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a087812ULL, 0x100fe400078ef804ULL,
0x000160001a057811ULL, 0x000fe200078e68ffULL, 0x0000000103037824ULL, 0x000fe200020e0617ULL,
0x000000700c0a7812ULL, 0x000fe400078ef804ULL, 0x000000110f047210ULL, 0x080fe20007f9e0ffULL,
0x000000100e0f7824ULL, 0x100fe200078e0205ULL, 0x0000001108087210ULL, 0x080fe20007fbe0ffULL,
0x0000001010137824ULL, 0x100fe200078e0205ULL, 0x000000110a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001000117824ULL, 0x100fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0003e2000d901c48ULL, 0x0000001006157824ULL, 0x000fc400078e0205ULL,
0x0000000109057824ULL, 0x100fe400020e0617ULL, 0x000000010b097824ULL, 0x100fe400028e0617ULL,
0x000000010d0b7824ULL, 0x000fe200030e0617ULL, 0x0000000004117faeULL, 0x0003e8000d101c48ULL,
0x0000000008137faeULL, 0x0003e8000c901c48ULL, 0x000000000a157faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x00006200170f7a11ULL, 0x000fc400078038ffULL, 0x000160001a157811ULL, 0x000fe400078e68ffULL,
0x000000001f007211ULL, 0x000fe400078fe8ffULL, 0x0000630017177a11ULL, 0x000fe400000f3cffULL,
0x0000000400087810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x040fe200078e021fULL,
0x00000008000a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000800037824ULL, 0x000fe400078e00ffULL,
0x00000008080e7824ULL, 0x000fc400078e00ffULL, 0x000000010a097824ULL, 0x102fe200078e021fULL,
0xfffffff803067812ULL, 0x000fe200078ee202ULL, 0x0000000108037824ULL, 0x000fe400078e021fULL,
0x0000000105027824ULL, 0x000fe200078e0200ULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x000000080a107824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee209ULL,
0x0000000105087824ULL, 0x040fe200078e0208ULL, 0x0000007002027812ULL, 0x000fe200078ef804ULL,
0x00000001050a7824ULL, 0x040fe400078e020aULL, 0x00000001050c7824ULL, 0x000fe200078e0200ULL,
0x000000020f027210ULL, 0x000fe20007f1e0ffULL, 0x0000000100057824ULL, 0x040fe400078e021fULL,
0x0000000800007824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff800057812ULL, 0x000fe200078ee205ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008007812ULL, 0x000fc600078ef804ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a087812ULL, 0x000fc600078ef804ULL, 0x0000000103037824ULL, 0x000fe200000e0617ULL,
0x000000700c0a7812ULL, 0x000fe200078ef804ULL, 0x000000100e117824ULL, 0x100fe200078e0215ULL,
0x000000000f047210ULL, 0x040fe20007f1e0ffULL, 0x0000001010137824ULL, 0x100fe200078e0215ULL,
0x000000080f087210ULL, 0x040fe40007f3e0ffULL, 0x0000000a0f0a7210ULL, 0x000fe20007f5e0ffULL,
0x00000010060f7824ULL, 0x100fe400078e0215ULL, 0x0000001005157824ULL, 0x000fc400078e0215ULL,
0x0000000109057824ULL, 0x100fe200000e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0003e2000b901c48ULL, 0x000000010b097824ULL, 0x100fe400008e0617ULL,
0x000000010d0b7824ULL, 0x000fe200010e0617ULL, 0x0000000004117faeULL, 0x0003e8000b901c48ULL,
0x0000000008137faeULL, 0x0003e8000b901c48ULL, 0x000000000a157faeULL, 0x0003e4000b901c48ULL,
0x0000000118187810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0x0000001d1800720cULL, 0x000fda0003f06070ULL, 0x0000006000000947ULL, 0x000fea0003800000ULL,
0x00000002be007824ULL, 0x000fe400078e00ffULL, 0x00006800ff037624ULL, 0x002fc800078e00ffULL,
0x0000680000037624ULL, 0x000fc800078e0203ULL, 0x0000000103247824ULL, 0x000fc800078e0218ULL,
0x0000640024247625ULL, 0x000fcc00078e0007ULL, 0x0000000824247981ULL, 0x000324000c1e1900ULL,
0x000000001a0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x0001a6a81a047811ULL, 0x002fe200078e18ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0001a6a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff597224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff027f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200004047f8cULL, 0x000ea2000c80043fULL,
0x000000ffff587224ULL, 0x000fe200078e00ffULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x00000000006a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000ed5000008947ULL, 0x000fea0003800000ULL,
0x00000002be177824ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x002fc400078e00ffULL,
0x000000101a157824ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fe400078e0003ULL,
0x0000680017177624ULL, 0x000fe200078e0202ULL, 0x0000001015157812ULL, 0x000fe200078ee2ffULL,
0x000000ffff037224ULL, 0x004fe400078e0005ULL, 0xff317217ff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff167224ULL, 0x000fc400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fc400078e00ffULL,
0x000000ffff147224ULL, 0x000fe400078e0018ULL, 0x000000ffff0a7224ULL, 0x00afc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x0000000420067824ULL, 0x000fca00078e00ffULL,
0xfffffff806087812ULL, 0x000fc800078ec0ffULL, 0x0001a6c808137810ULL, 0x000fe20007ffe0ffULL,
0x01a6cc0008067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020037824ULL, 0x000fe200078e00ffULL,
0x0000000116077810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x010fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000004024247824ULL, 0x000fe200078e00ffULL,
0x0000001c0700720cULL, 0x000fc60003f26070ULL, 0x0000010016057824ULL, 0x000fca00078e0205ULL,
0x0000004005057810ULL, 0x000fc80007ffe0ffULL, 0x0000002005047812ULL, 0x000fca00078ec0ffULL,
0x00000001190b7824ULL, 0x000fe200078e0204ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe400078ec0ffULL, 0x000000051e037217ULL, 0x000fe40007800000ULL,
0x00000003ff077819ULL, 0x000fe4000001161fULL, 0x0000620024257a11ULL, 0x040fe200078a38ffULL,
0x0000000103037824ULL, 0x000fe200078e0a05ULL, 0x0000000407087810ULL, 0x040fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe200078e0204ULL, 0x0000630024277a11ULL, 0x000fc400028f3cffULL,
0x0000000403037217ULL, 0x000fe20007800000ULL, 0x0000000106057824ULL, 0x040fe400078e021fULL,
0x00000008060a7824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fc600078e0a04ULL,
0xfffffff80a117812ULL, 0x000fe400078ee205ULL, 0x00000008070a7810ULL, 0x040fe40007ffe0ffULL,
0x000000030700720cULL, 0x0c0fe40003f86070ULL, 0x000000030a00720cULL, 0x0c0fe20003f46070ULL,
0x000000010a0a7824ULL, 0x000fe200078e0204ULL, 0x0000000c07077810ULL, 0x000fe40007ffe0ffULL,
0x000000030800720cULL, 0x080fe20003f66070ULL, 0x000000010a057824ULL, 0x040fe200078e021fULL,
0x000000030700720cULL, 0x000fe20003f06070ULL, 0x000000080a287824ULL, 0x000fc400078e00ffULL,
0x0000000108087824ULL, 0x100fe400078e0204ULL, 0x0000000107127824ULL, 0x000fe200078e0204ULL,
0xfffffff828217812ULL, 0x000fe200078ee205ULL, 0x000000101f077824ULL, 0x000fe400078e00ffULL,
0x000000010b047824ULL, 0x040fe400078e0206ULL, 0x000000010b067824ULL, 0x000fe200078e0208ULL,
0x0000007007297812ULL, 0x000fe200078ec0ffULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000002904047212ULL, 0x000fc600078efcffULL,
0x0000000108037824ULL, 0x040fe200078e021fULL, 0x0000000425047210ULL, 0x000fe20007fbe0ffULL,
0x0000000808267824ULL, 0x000fe200078e00ffULL, 0x0000002906067212ULL, 0x000fe200078efcffULL,
0x000000010b087824ULL, 0x040fe400078e020aULL, 0x000000010b0a7824ULL, 0x000fe200078e0212ULL,
0xfffffff826037812ULL, 0x000fe200078ee203ULL, 0x0000000112237824ULL, 0x000fe400078e021fULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x0000000812127824ULL, 0x000fe200078e00ffULL,
0x0000002908087212ULL, 0x000fe200078efcffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff812237812ULL, 0x000fe200078ee223ULL, 0x0000000105057824ULL, 0x100fe200028e0627ULL,
0x0000002506067210ULL, 0x000fe40007fbe0ffULL, 0x000000290a0a7212ULL, 0x000fe400078efcffULL,
0x000170001a127811ULL, 0x000fe200078e68ffULL, 0x0000000107077824ULL, 0x000fe200028e0627ULL,
0x0000002508087210ULL, 0x080fe40007fbe0ffULL, 0x000000250a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001011117824ULL, 0x000fc400078e0212ULL, 0x0000001003037824ULL, 0x100fe400078e0212ULL,
0x0000001021217824ULL, 0x100fe200078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e2000e101c48ULL, 0x0000000109097824ULL, 0x100fe400028e0627ULL,
0x0000001023237824ULL, 0x000fe200078e0212ULL, 0x0000000006037faeULL, 0x0003e2000d901c48ULL,
0x000000010b0b7824ULL, 0x000fc600030e0627ULL, 0x0000000008217faeULL, 0x0003e8000d101c48ULL,
0x000000000a237faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101f097824ULL, 0x040fe200078e00ffULL,
0x0000620024277a11ULL, 0x000fe400078038ffULL, 0x000000041f047211ULL, 0x000fe400078fe8ffULL,
0x0000007009257812ULL, 0x000fc400078ec0ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104037824ULL, 0x140fe200078e021fULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x000fe200078e00ffULL, 0x0000630024297a11ULL, 0x000fe200000f3cffULL,
0x0000000106057824ULL, 0x040fe400078e021fULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0xfffffff80a037812ULL, 0x000fe200078ee203ULL, 0x0000000108077824ULL, 0x040fe400078e021fULL,
0x00000008080a7824ULL, 0x000fe200078e00ffULL, 0xfffffff812117812ULL, 0x000fe200078ee205ULL,
0x000000010b057824ULL, 0x000fc400078e0204ULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0xfffffff80a127812ULL, 0x000fe200078ee207ULL, 0x000000010b087824ULL, 0x000fe200078e0208ULL,
0x0000000c040a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008005047825ULL, 0x000fc800078e00ffULL,
0x000000010b0b7824ULL, 0x000fe200078e020aULL, 0x0000002504047212ULL, 0x000fe200078efcffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0x0000000427047210ULL, 0x000fe20007f1e0ffULL,
0x000000010a217824ULL, 0x000fe200078e021fULL, 0x0000002506067212ULL, 0x000fe200078efcffULL,
0x000000080a247824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff824237812ULL, 0x000fe200078ee221ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000002508087212ULL, 0x080fe400078efcffULL, 0x000170001a247811ULL, 0x000fe200078e68ffULL,
0x0000000105057824ULL, 0x100fe200000e0629ULL, 0x000000250a0a7212ULL, 0x000fe400078efcffULL,
0x0000000627067210ULL, 0x000fe20007f1e0ffULL, 0x0000001003037824ULL, 0x100fe200078e0224ULL,
0x0000000827087210ULL, 0x000fe20007f5e0ffULL, 0x0000001011117824ULL, 0x100fe200078e0224ULL,
0x0000000a270a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000107077824ULL, 0x000fe200000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c48ULL,
0x0000001012217824ULL, 0x000fc400078e0224ULL, 0x0000000109097824ULL, 0x100fe200010e0629ULL,
0x0000000006117faeULL, 0x0003e2000b901c48ULL, 0x0000001023237824ULL, 0x000fe400078e0224ULL,
0x000000010b0b7824ULL, 0x000fe200018e0629ULL, 0x0000000008217faeULL, 0x0003e8000b901c48ULL,
0x000000000a237faeULL, 0x0003e4000b901c48ULL, 0x0000000820037824ULL, 0x002fe200078e00ffULL,
0x0000000118047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001d0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0473c2ULL, 0x000e6200000e0000ULL, 0xffffffe003237812ULL, 0x040fe400078ec0ffULL,
0x0000001003067812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000117048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002303237210ULL, 0x000fe40007ffe006ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640004048625ULL, 0x000fca00078e0005ULL, 0x0000000804248981ULL, 0x000522000c1e1900ULL,
0x0001a6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b0000a6e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6080023087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01a60c0023037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60c0023037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101f127824ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe2000001161fULL,
0x0000002020037824ULL, 0x000fc600078e00ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0xffffff8003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c11117812ULL, 0x000fc800078ec0ffULL,
0x0000000311037210ULL, 0x000fca0007ffe012ULL, 0x01a0000003057984ULL, 0x000e680000000800ULL,
0x01a2000003077984ULL, 0x0006a20000000800ULL, 0x000000020500720bULL, 0x002fe20003f1d000ULL,
0x00019eb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x008fc800000e0100ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x000fd200078e0002ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000201b00720cULL, 0x000fe40003f05270ULL,
0x000000020500720bULL, 0x000fe20003f54000ULL, 0x00019e827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000047806ULL, 0x000fc400010e0100ULL, 0x0000008020088824ULL, 0x000fe200078e0212ULL,
0x0000000205217209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000111088824ULL, 0x000fca00078e0208ULL, 0x01a4002108008388ULL, 0x0003e20000000800ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000000221027221ULL, 0x002fe20000010100ULL, 0x000000ff04ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL,
0x0000000200027308ULL, 0x000e640000000800ULL, 0x0000000222227220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161fULL,
0x00019dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2902287589ULL, 0x0002e400000e0000ULL,
0x0000002868687220ULL, 0x08cfe40000410000ULL, 0x0000002869697220ULL, 0x080fe40000410000ULL,
0x0000002864647220ULL, 0x080fe40000410000ULL, 0x0000002865657220ULL, 0x000fc40000410000ULL,
0x0000002860607220ULL, 0x080fe40000410000ULL, 0x0000002861617220ULL, 0x080fe40000410000ULL,
0x000000285c5c7220ULL, 0x080fe40000410000ULL, 0x000000285d5d7220ULL, 0x080fe40000410000ULL,
0x0000002858587220ULL, 0x080fe40000410000ULL, 0x0000002859597220ULL, 0x000fc40000410000ULL,
0x0000002854547220ULL, 0x080fe40000410000ULL, 0x0000002855557220ULL, 0x080fe40000410000ULL,
0x0000002850507220ULL, 0x080fe40000410000ULL, 0x0000002851517220ULL, 0x080fe40000410000ULL,
0x000000284c4c7220ULL, 0x080fe40000410000ULL, 0x000000284d4d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0004ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081f297811ULL, 0x002fe200078ff0ffULL, 0x00019cc27f007947ULL, 0x000fea000b800000ULL,
0x00001f2902287589ULL, 0x0002e400000e0000ULL, 0x000000286a6a7220ULL, 0x08cfe40000410000ULL,
0x000000286b6b7220ULL, 0x080fe40000410000ULL, 0x0000002866667220ULL, 0x080fe40000410000ULL,
0x0000002867677220ULL, 0x080fe40000410000ULL, 0x0000002862627220ULL, 0x080fe40000410000ULL,
0x0000002863637220ULL, 0x000fc40000410000ULL, 0x000000285e5e7220ULL, 0x080fe40000410000ULL,
0x000000285f5f7220ULL, 0x080fe40000410000ULL, 0x000000285a5a7220ULL, 0x080fe40000410000ULL,
0x000000285b5b7220ULL, 0x080fe40000410000ULL, 0x0000002856567220ULL, 0x080fe40000410000ULL,
0x0000002857577220ULL, 0x000fc40000410000ULL, 0x0000002852527220ULL, 0x080fe40000410000ULL,
0x0000002853537220ULL, 0x080fe40000410000ULL, 0x000000284e4e7220ULL, 0x080fe40000410000ULL,
0x000000284f4f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000004ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101f297811ULL, 0x002fe200078ff0ffULL,
0x00019bb27f007947ULL, 0x000fea000b800000ULL, 0x00001f2902287589ULL, 0x0002e400000e0000ULL,
0x0000002848487220ULL, 0x08cfe40000410000ULL, 0x0000002849497220ULL, 0x080fe40000410000ULL,
0x0000002844447220ULL, 0x080fe40000410000ULL, 0x0000002845457220ULL, 0x080fe40000410000ULL,
0x0000002840407220ULL, 0x080fe40000410000ULL, 0x0000002841417220ULL, 0x000fc40000410000ULL,
0x000000283c3c7220ULL, 0x080fe40000410000ULL, 0x000000283d3d7220ULL, 0x080fe40000410000ULL,
0x0000002838387220ULL, 0x080fe40000410000ULL, 0x0000002839397220ULL, 0x080fe40000410000ULL,
0x0000002834347220ULL, 0x080fe40000410000ULL, 0x0000002835357220ULL, 0x000fc40000410000ULL,
0x0000002830307220ULL, 0x080fe40000410000ULL, 0x0000002831317220ULL, 0x080fe40000410000ULL,
0x000000282c2c7220ULL, 0x080fe40000410000ULL, 0x000000282d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000004ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181f297811ULL, 0x002fe200078ff0ffULL,
0x00019ab27f007947ULL, 0x000fea000b800000ULL, 0x00001f2902287589ULL, 0x0002e400000e0000ULL,
0x000000284a4a7220ULL, 0x08cfe40000410000ULL, 0x000000284b4b7220ULL, 0x080fe40000410000ULL,
0x0000002846467220ULL, 0x080fe40000410000ULL, 0x0000002847477220ULL, 0x080fe40000410000ULL,
0x0000002842427220ULL, 0x080fe40000410000ULL, 0x0000002843437220ULL, 0x000fc40000410000ULL,
0x000000283e3e7220ULL, 0x080fe40000410000ULL, 0x000000283f3f7220ULL, 0x080fe40000410000ULL,
0x000000283a3a7220ULL, 0x080fe40000410000ULL, 0x000000283b3b7220ULL, 0x080fe40000410000ULL,
0x0000002836367220ULL, 0x080fe40000410000ULL, 0x0000002837377220ULL, 0x000fc40000410000ULL,
0x0000002832327220ULL, 0x080fe40000410000ULL, 0x0000002833337220ULL, 0x080fe40000410000ULL,
0x000000282e2e7220ULL, 0x080fe40000410000ULL, 0x000000282f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000403ff7212ULL, 0x000fda00078030ffULL,
0x8000002105050221ULL, 0x000fe20000010000ULL, 0x00007610ff060816ULL, 0x000fc60000000006ULL,
0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL, 0x0000000500100308ULL, 0x000e640000000800ULL,
0x0000001007070220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002207227221ULL, 0x004fc40000010000ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x01a6ac000a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6ac000a057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991006007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000010ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe4000001161fULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000196c27f007947ULL, 0x000fea000b800000ULL,
0x00001f03000f7589ULL, 0x0002a400000e0000ULL, 0x0000000803297810ULL, 0x000fe20007ffe0ffULL,
0x000197127f007947ULL, 0x000fea000b800000ULL, 0x00000010030d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f29000e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d000d7589ULL, 0x0006a400000e0000ULL,
0x0000001803297810ULL, 0x008fe20007ffe0ffULL, 0x000197a27f007947ULL, 0x000fea000b800000ULL,
0x00001f29000c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000220257824ULL, 0x040fe200078e00ffULL, 0x000000081f007812ULL, 0x00afe200078ec0ffULL,
0x0000000420047824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100020057824ULL, 0x000fe200078e00ffULL, 0x0000000425027812ULL, 0x000fe200078ec0ffULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x00000007000b7812ULL, 0x000fc400078ef81fULL,
0x000000021f007211ULL, 0x000fe400078fe0ffULL, 0x000000100b0a7812ULL, 0x040fe200078efcffULL,
0x000000080b067824ULL, 0x040fe200078e00ffULL, 0x0000000404047812ULL, 0x000fe200078ec0ffULL,
0x000000010b097824ULL, 0x000fe200078e0200ULL, 0xffffe00005057812ULL, 0x000fe200078ec0ffULL,
0x0000000100087824ULL, 0x000fe400078e020aULL, 0x0000040020007824ULL, 0x000fe200078e00ffULL,
0xfffffff806097812ULL, 0x000fe200078ee209ULL, 0x000000080a037824ULL, 0x000fe200078e00ffULL,
0x0001600005057810ULL, 0x000fe20007ffe0ffULL, 0x000000080b077824ULL, 0x040fe200078e00ffULL,
0xfffff00000007812ULL, 0x000fe200078ec0ffULL, 0x000000080b277824ULL, 0x000fe200078e00ffULL,
0xfffffff803087812ULL, 0x000fc400078ee208ULL, 0x000000041f037211ULL, 0x000fe400078fe0ffULL,
0x0001200000007810ULL, 0x000fc60007ffe0ffULL, 0x000000010b047824ULL, 0x000fe400078e0203ULL,
0x0000001009707824ULL, 0x100fe400078e0200ULL, 0x0000001008287824ULL, 0x000fe200078e0200ULL,
0xfffffff807077812ULL, 0x000fe400078ee204ULL, 0x0000000204067810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000e640000000200ULL, 0x0000001007787824ULL, 0x000fc400078e0205ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707231ULL, 0x086fe400003400ffULL, 0x0000000f72727231ULL, 0x000fe400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fe400003400ffULL,
0x0000000d28287231ULL, 0x088fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fc400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff827067812ULL, 0x000fe200078ee206ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x0000000202027812ULL, 0x000fe200078efcffULL,
0x0000105000007945ULL, 0x000fe40003800000ULL, 0x00000010067c7824ULL, 0x000fe200078e0205ULL,
0x000000021f027211ULL, 0x000fca00078fe0ffULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x0000007800047306ULL, 0x008fe20000009400ULL, 0x00000018ff6d7819ULL, 0x000fe20000011478ULL,
0x0000010078957824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011479ULL,
0x0000010079987824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001147bULL,
0x000001007aa97824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001147aULL,
0x0000007800937306ULL, 0x000ee20000005400ULL, 0x00000018ff9e7819ULL, 0x000fe20000011498ULL,
0x000001007bac7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x004fe2000001147eULL,
0x000001007cbb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe2000001147fULL,
0x000001007dbe7824ULL, 0x000fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fe2000001147dULL,
0x0000007800947306ULL, 0x000462000000d400ULL, 0x00000018ff957819ULL, 0x000fc40000011495ULL,
0x00000018ffa97819ULL, 0x000fe400000114a9ULL, 0x00000018ffb27819ULL, 0x000fe400000114acULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x0000006d009a7306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x004fe200078e00ffULL, 0x000000930400720bULL, 0x008fe20003f7d000ULL,
0x000001007e047824ULL, 0x000fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fe400000114beULL,
0x00000018ff787819ULL, 0x000fc40000011478ULL, 0x0000006d009d7306ULL, 0x000fe20000205400ULL,
0x00000018ff047819ULL, 0x000fcc0000011404ULL, 0x0000000194943812ULL, 0x002fe200078efcffULL,
0x0000006d00267306ULL, 0x0003f0000020d400ULL, 0x0000008200a57306ULL, 0x000fe20000209400ULL,
0x00000018ff6d7819ULL, 0x002fce000001147cULL, 0x0000008200a87306ULL, 0x000ff00000205400ULL,
0x0000008200277306ULL, 0x000ff0000020d400ULL, 0x0000009b00897306ULL, 0x000ff00000209400ULL,
0x0000009b008c7306ULL, 0x000ff00000205400ULL, 0x0000009b00827306ULL, 0x000ff0000020d400ULL,
0x0000008a00b77306ULL, 0x000ff00000209400ULL, 0x0000008a00ba7306ULL, 0x000ff00000205400ULL,
0x0000008a00877306ULL, 0x000ff0000020d400ULL, 0x0000006d00c07306ULL, 0x000ff00000209400ULL,
0x0000006d00c17306ULL, 0x000ff00000205400ULL, 0x0000006d00857306ULL, 0x000ff0000020d400ULL,
0x0000007800987306ULL, 0x000ff00000209400ULL, 0x00000078009b7306ULL, 0x000e700000205400ULL,
0x000000a3008d7306ULL, 0x000ff00000209400ULL, 0x000000a3008a7306ULL, 0x000fe20000205400ULL,
0x0000009b9800720bULL, 0x002fce0003fdd000ULL, 0x000000a3006d7306ULL, 0x0003f0000020d400ULL,
0x0000008300ae7306ULL, 0x000fe20000209400ULL, 0x0001000079a37824ULL, 0x002fca00078e00ffULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x0000008300af7306ULL, 0x000ff00000205400ULL,
0x00000083008f7306ULL, 0x000ff0000020d400ULL, 0x0000009600917306ULL, 0x000ff00000209400ULL,
0x0000009600927306ULL, 0x000ff00000205400ULL, 0x0000009600837306ULL, 0x000ff0000020d400ULL,
0x0000009500967306ULL, 0x000ff00000209400ULL, 0x0000009500977306ULL, 0x000e700000205400ULL,
0x0000009500997306ULL, 0x000eb0000020d400ULL, 0x0000009e00a07306ULL, 0x000fe20000209400ULL,
0x000000979600720bULL, 0x002fce0003f5d000ULL, 0x0000009e00a17306ULL, 0x000e6c0000205400ULL,
0x0000000199992812ULL, 0x004fe400078efcffULL, 0x000000a300957306ULL, 0x000fe20000209400ULL,
0x0000009d9a00720bULL, 0x000fce0003f5d000ULL, 0x000000a300a47306ULL, 0x000ea20000205400ULL,
0x000000a1a000720bULL, 0x002fca0003fbd000ULL, 0x0000000126262812ULL, 0x000fe400078efcffULL,
0x00000079009c7306ULL, 0x000ff00000009400ULL, 0x00000079009f7306ULL, 0x000e620000005400ULL,
0x000000a49500720bULL, 0x004fce0003f7d000ULL, 0x0000007900057306ULL, 0x000eb0000000d400ULL,
0x0000009e00a27306ULL, 0x000ee2000020d400ULL, 0x0000009f9c00720bULL, 0x002fce0003f9d000ULL,
0x0000007800797306ULL, 0x000e6c000020d400ULL, 0x0000000105054812ULL, 0x004fe400078efcffULL,
0x000000a9009e7306ULL, 0x000fe20000209400ULL, 0x00000001a2a25812ULL, 0x008fe400078efcffULL,
0x000000a8a500720bULL, 0x000fc40003f9d000ULL, 0x00000005a205723eULL, 0x000fc600000010ffULL,
0x000000a900ab7306ULL, 0x000ea20000205400ULL, 0x0000000179796812ULL, 0x002fc800078efcffULL,
0x000000792626723eULL, 0x000fc600000010ffULL, 0x000000a300a67306ULL, 0x000e62000020d400ULL,
0x0000000127274812ULL, 0x000fce00078efcffULL, 0x0000007a00a77306ULL, 0x000fe20000009400ULL,
0x000000ab9e00720bULL, 0x004fce0003fdd000ULL, 0x0000007a00aa7306ULL, 0x000ea20000005400ULL,
0x00000001a6a63812ULL, 0x002fc800078efcffULL, 0x000000a62727723eULL, 0x000fc600000010ffULL,
0x0000007b00b07306ULL, 0x000fe80000009400ULL, 0x000000267064723cULL, 0x000f680000041864ULL,
0x0000007b00b17306ULL, 0x000e620000005400ULL, 0x000000aaa700720bULL, 0x004fc60003fbd000ULL,
0x000000262844723cULL, 0x000b680000041844ULL, 0x000000a900ad7306ULL, 0x000ea6000020d400ULL,
0x000000080b267824ULL, 0x020fe400078e00ffULL, 0x000000080a277824ULL, 0x000fc600078e00ffULL,
0x0000007b008e7306ULL, 0x0006a2000000d400ULL, 0x000000b1b000720bULL, 0x002fce0003f7d000ULL,
0x0000007a00907306ULL, 0x000262000000d400ULL, 0x000100007b7b7824ULL, 0x008fe200078e00ffULL,
0x00000001adad6812ULL, 0x004fe400078efcffULL, 0x000000afae00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000b200b37306ULL, 0x000fe20000209400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x000000018e8e3812ULL, 0x000fc800078efcffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x000000b200b47306ULL, 0x000e620000205400ULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x000000018f8f6812ULL, 0x000fca00078efcffULL,
0x000000b200b57306ULL, 0x000eb0000020d400ULL, 0x0000007b00a97306ULL, 0x000fe20000209400ULL,
0x000000b4b300720bULL, 0x002fce0003f5d000ULL, 0x0000007b00b67306ULL, 0x000e6c0000205400ULL,
0x00000001b5b52812ULL, 0x004fe400078efcffULL, 0x000000bb00b27306ULL, 0x000fe20000209400ULL,
0x000000bab700720bULL, 0x000fe40003f5d000ULL, 0x0000008eb579723eULL, 0x000fca00000010ffULL,
0x000000bb00bd7306ULL, 0x000ea20000205400ULL, 0x000000b6a900720bULL, 0x002fca0003fbd000ULL,
0x0000000187872812ULL, 0x000fe400078efcffULL, 0x0000007a00787306ULL, 0x000ff00000209400ULL,
0x0000007a00a37306ULL, 0x000e620000205400ULL, 0x000000bdb200720bULL, 0x004fce0003f7d000ULL,
0x000000c400c57306ULL, 0x000ff00000209400ULL, 0x000000c400c67306ULL, 0x000ea20000205400ULL,
0x000000a37800720bULL, 0x002fe40003f9d000ULL, 0x00000090ad78723eULL, 0x000fca00000010ffULL,
0x0000007c00b97306ULL, 0x000fe40000009400ULL, 0x000000787060723cULL, 0x080f6c0000041860ULL,
0x0000007c00bc7306ULL, 0x000fe20000005400ULL, 0x000000c6c500720bULL, 0x004fe20003fdd000ULL,
0x000000782840723cULL, 0x000f6c0000041840ULL, 0x0000007c00867306ULL, 0x0003f0000000d400ULL,
0x0000007d00c27306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00c37306ULL, 0x000ff00000005400ULL,
0x0000007d00847306ULL, 0x0003f0000000d400ULL, 0x0000007a00ac7306ULL, 0x000ea2000020d400ULL,
0x000100007d7d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007b00b87306ULL, 0x000e70000020d400ULL, 0x000000bb00bf7306ULL, 0x000ee2000020d400ULL,
0x00000001acac4812ULL, 0x004fc400078efcffULL, 0x000000bcb900720bULL, 0x000fca0003f9d000ULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x00000001b8b85812ULL, 0x002fe400078efcffULL,
0x000000c3c200720bULL, 0x000fca0003fbd000ULL, 0x0000007c007b7306ULL, 0x000e620000205400ULL,
0x00000001bfbf3812ULL, 0x008fe400078efcffULL, 0x0000000186864812ULL, 0x000fe400078efcffULL,
0x000000c1c000720bULL, 0x000fe40003f9d000ULL, 0x00000086bf86723eULL, 0x000fe200000010ffULL,
0x000000c400c77306ULL, 0x000ea2000020d400ULL, 0x0000000184845812ULL, 0x000fe400078efcffULL,
0x000000929100720bULL, 0x000fca0003fbd000ULL, 0x0000007d00bb7306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x002fe40003f7d000ULL, 0x000000b8877b723eULL, 0x000fe400000010ffULL,
0x0000000185854812ULL, 0x000fe400078efcffULL, 0x000000ac8f7a723eULL, 0x000fe200000010ffULL,
0x0000007d00c87306ULL, 0x000e620000205400ULL, 0x00000001c7c76812ULL, 0x004fe400078efcffULL,
0x0000000183835812ULL, 0x000fc400078efcffULL, 0x00000084c787723eULL, 0x000fe200000010ffULL,
0x0000007a705c723cULL, 0x040f62000004185cULL, 0x0000008c8900720bULL, 0x000fe20003fbd000ULL,
0x0000007d00967306ULL, 0x0004ec000020d400ULL, 0x000000867058723cULL, 0x000f640000041858ULL,
0x0000007c00be7306ULL, 0x000ee2000020d400ULL, 0x000001007f7d7824ULL, 0x004fe200078e00ffULL,
0x000000c8bb00720bULL, 0x002fc40003fdd000ULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x00000018ff957819ULL, 0x000fe2000001147dULL, 0x0000007a283c723cULL, 0x040f62000004183cULL,
0x00000004007c7306ULL, 0x000fee0000209400ULL, 0x0000000196966812ULL, 0x008fe200078efcffULL,
0x0000000400937306ULL, 0x000e620000205400ULL, 0x00000001bebe3812ULL, 0x000fe200078efcffULL,
0x000000862838723cULL, 0x000f620000041838ULL, 0x0000009683bf723eULL, 0x000fc400000010ffULL,
0x000000be85be723eULL, 0x000fc600000010ffULL, 0x0000007e00c97306ULL, 0x000fe80000009400ULL,
0x000000be7054723cULL, 0x000f680000041854ULL, 0x0000007e00ca7306ULL, 0x000ea20000005400ULL,
0x000000937c00720bULL, 0x002fc60003f7d000ULL, 0x000000be2834723cULL, 0x000f680000041834ULL,
0x0000009500977306ULL, 0x000ff00000209400ULL, 0x00000095009a7306ULL, 0x000e620000205400ULL,
0x000000cac900720bULL, 0x004fce0003f5d000ULL, 0x0000007e00817306ULL, 0x0004f0000000d400ULL,
0x0000007f00887306ULL, 0x000fe20000009400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x0000009a9700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f008b7306ULL, 0x000e620000005400ULL, 0x0000000181812812ULL, 0x008fce00078efcffULL,
0x0000007f006c7306ULL, 0x0004f0000000d400ULL, 0x00000095009b7306ULL, 0x0006e2000020d400ULL,
0x000100007f7f7824ULL, 0x004fe200078e00ffULL, 0x0000008b8800720bULL, 0x002fcc0003f9d000ULL,
0x0000000400987306ULL, 0x0002a2000020d400ULL, 0x00000018ff957819ULL, 0x008fcc000001147fULL,
0x000000016c6c4812ULL, 0x000fe200078efcffULL, 0x0000007e007d7306ULL, 0x000fe20000209400ULL,
0x000000949904723eULL, 0x002fe400000010ffULL, 0x000000019b9b6812ULL, 0x000fc800078efcffULL,
0x0000006c9b99723eULL, 0x000fe200000010ffULL, 0x0000007e00947306ULL, 0x000e620000205400ULL,
0x0000000198983812ULL, 0x004fe200078efcffULL, 0x000000047068723cULL, 0x000f620000041868ULL,
0x0000008a8d00720bULL, 0x000fe40003f7d000ULL, 0x000000819898723eULL, 0x000fc600000010ffULL,
0x0000009500917306ULL, 0x000fe40000209400ULL, 0x000000042848723cULL, 0x000b6c0000041848ULL,
0x00000095007c7306ULL, 0x000ea20000205400ULL, 0x000000947d00720bULL, 0x002fe20003f5d000ULL,
0x000000010b057824ULL, 0x120fe200078e0202ULL, 0x000000016d6d3812ULL, 0x000fe200078efcffULL,
0x000000010a047824ULL, 0x000fe200078e0202ULL, 0x000000987050723cULL, 0x000f640000041850ULL,
0xfffffff826057812ULL, 0x000fe200078ee205ULL, 0x0000007e007f7306ULL, 0x000e62000020d400ULL,
0xfffffff827047812ULL, 0x000fe200078ee204ULL, 0x000000010a267824ULL, 0x000fe200078e0203ULL,
0x000160001a037811ULL, 0x000fc400078e68ffULL, 0x000000982830723cULL, 0x000f660000041830ULL,
0x0000009500847306ULL, 0x000ee2000020d400ULL, 0x0000007c9100720bULL, 0x004fe40003fdd000ULL,
0x000000017f7f2812ULL, 0x002fc800078efcffULL, 0x0000007f826c723eULL, 0x000fce00000010ffULL,
0x0000000184846812ULL, 0x008fc800078efcffULL, 0x000000846d6d723eULL, 0x000fce00000010ffULL,
0x0000006c704c723cULL, 0x080b6e000004184cULL, 0x000000080a717824ULL, 0x020fe200078e00ffULL,
0x0000006c282c723cULL, 0x000b62000004182cULL, 0x0000001005707824ULL, 0x100fe400078e0200ULL,
0x0000001004007824ULL, 0x000fe200078e0200ULL, 0xfffffff871027812ULL, 0x000fc400078ee226ULL,
0x0000000226267810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000e640000000200ULL,
0x0000001002787824ULL, 0x000fe400078e0203ULL, 0x000000000028783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fce0003800000ULL, 0x0000000f70707231ULL, 0x082fe400003400ffULL,
0x0000000f72727231ULL, 0x000fe400003400ffULL, 0x0000000e71717231ULL, 0x000fc400003400ffULL,
0x0000000e73737231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x088fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fe400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff827007812ULL, 0x004fe200078ee226ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0xfffffff825257812ULL, 0x000fc600078ec0ffULL, 0x00000010007c7824ULL, 0x000fcc00078e0203ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x0000007800967306ULL, 0x004fe20000009400ULL,
0x00000018ff827819ULL, 0x000fe20000011478ULL, 0x0000010078987824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011479ULL, 0x00000100799d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe2000001147aULL, 0x000001007aae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x0000007800997306ULL, 0x000ea20000005400ULL,
0x00000018ff8a7819ULL, 0x000fe2000001147bULL, 0x000001007bb27824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x008fe2000001147dULL, 0x000001007cc07824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe2000001147eULL, 0x000001007dc47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe2000001149dULL, 0x0000007800937306ULL, 0x000662000000d400ULL,
0x00000018ffa77819ULL, 0x000fe2000001147fULL, 0x000001007ece7824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fc400000114aeULL, 0x00000018ffb57819ULL, 0x000fe400000114b2ULL,
0x00000018ffc07819ULL, 0x000fe200000114c0ULL, 0x00000082009f7306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x000000999600720bULL, 0x004fe40003fdd000ULL,
0x00000018ffc77819ULL, 0x000fe400000114c4ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000008200a07306ULL, 0x000fe20000205400ULL, 0x00000018ffce7819ULL, 0x000fcc00000114ceULL,
0x0000000193936812ULL, 0x002fe200078efcffULL, 0x00000082006c7306ULL, 0x0003f0000020d400ULL,
0x0000008400aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff827819ULL, 0x002fce000001147cULL,
0x0000008400ab7306ULL, 0x000ff00000205400ULL, 0x00000084006d7306ULL, 0x000ff0000020d400ULL,
0x0000008500b17306ULL, 0x000ff00000209400ULL, 0x0000008500b47306ULL, 0x000ff00000205400ULL,
0x00000085008d7306ULL, 0x000ff0000020d400ULL, 0x0000009a00917306ULL, 0x000ff00000209400ULL,
0x0000009a00927306ULL, 0x000ff00000205400ULL, 0x0000009a00857306ULL, 0x000ff0000020d400ULL,
0x0000009e008e7306ULL, 0x000ff00000209400ULL, 0x0000009e008f7306ULL, 0x000ff00000205400ULL,
0x0000009e00847306ULL, 0x000ff0000020d400ULL, 0x0000007900a17306ULL, 0x000ff00000009400ULL,
0x0000007900a27306ULL, 0x000e700000005400ULL, 0x00000098009a7306ULL, 0x000ff00000209400ULL,
0x00000098009b7306ULL, 0x000ea20000205400ULL, 0x000000a2a100720bULL, 0x002fce0003f5d000ULL,
0x00000078009d7306ULL, 0x000ff00000209400ULL, 0x00000078009e7306ULL, 0x000e620000205400ULL,
0x0000009b9a00720bULL, 0x004fce0003fbd000ULL, 0x0000008a00bc7306ULL, 0x000ff00000209400ULL,
0x0000008a00bd7306ULL, 0x000fe20000205400ULL, 0x0000009e9d00720bULL, 0x002fce0003f9d000ULL,
0x0000008a00897306ULL, 0x000ff0000020d400ULL, 0x0000008200c37306ULL, 0x000ff00000209400ULL,
0x0000008200c87306ULL, 0x000ff00000205400ULL, 0x0000008200877306ULL, 0x000ff0000020d400ULL,
0x000000a7008a7306ULL, 0x000ff00000209400ULL, 0x000000a7008b7306ULL, 0x000ff00000205400ULL,
0x000000a700827306ULL, 0x0003f0000020d400ULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x0001000079a77824ULL, 0x002fca00078e00ffULL, 0x00000018ffa77819ULL, 0x000fe400000114a7ULL,
0x000000a300a57306ULL, 0x000e700000205400ULL, 0x0000007900277306ULL, 0x000eb0000000d400ULL,
0x00000098009c7306ULL, 0x000ee2000020d400ULL, 0x000000a5a400720bULL, 0x002fce0003f1d000ULL,
0x000000a300a67306ULL, 0x000e62000020d400ULL, 0x0000000127272812ULL, 0x004fce00078efcffULL,
0x0000007800797306ULL, 0x000ea2000020d400ULL, 0x000000019c9c5812ULL, 0x008fe400078efcffULL,
0x000000a09f00720bULL, 0x000fca0003fbd000ULL, 0x000000a700987306ULL, 0x000fe20000209400ULL,
0x00000001a6a60812ULL, 0x002fe400078efcffULL, 0x000000abaa00720bULL, 0x000fe40003f1d000ULL,
0x00000027a627723eULL, 0x000fc600000010ffULL, 0x000000a700a97306ULL, 0x000e620000205400ULL,
0x0000000179794812ULL, 0x004fe400078efcffULL, 0x000000016c6c5812ULL, 0x000fc800078efcffULL,
0x000000796c6c723eULL, 0x000fe200000010ffULL, 0x000000ae00a37306ULL, 0x000fe20000209400ULL,
0x000000016d6d0812ULL, 0x000fe400078efcffULL, 0x000000b4b100720bULL, 0x000fca0003f1d000ULL,
0x000000ae00b07306ULL, 0x000ea20000205400ULL, 0x000000a99800720bULL, 0x002fce0003fdd000ULL,
0x000000b500b77306ULL, 0x000fe20000209400ULL, 0x000000018d8d0812ULL, 0x000fce00078efcffULL,
0x000000b500b87306ULL, 0x000e620000205400ULL, 0x000000b0a300720bULL, 0x004fce0003f5d000ULL,
0x0000007a00ac7306ULL, 0x000ff00000009400ULL, 0x0000007a00ad7306ULL, 0x000ea20000005400ULL,
0x000000b8b700720bULL, 0x002fce0003f9d000ULL, 0x0000007a00907306ULL, 0x0002f0000000d400ULL,
0x0000007b00b37306ULL, 0x000fe20000009400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x000000adac00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007b00b67306ULL, 0x000e6e0000005400ULL, 0x0000000190903812ULL, 0x008fe200078efcffULL,
0x0000007b008c7306ULL, 0x0004e2000000d400ULL, 0x000000bdbc00720bULL, 0x000fce0003f7d000ULL,
0x000000a700a87306ULL, 0x000ee2000020d400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x000000b6b300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000ae00af7306ULL, 0x000e62000020d400ULL, 0x0000000189893812ULL, 0x000fcc00078efcffULL,
0x000000018c8c5812ULL, 0x008fe200078efcffULL, 0x000000b500b97306ULL, 0x000ea2000020d400ULL,
0x00000001a8a86812ULL, 0x000fc800078efcffULL, 0x000000a86d6d723eULL, 0x000fc600000010ffULL,
0x0000007c00be7306ULL, 0x000fe20000009400ULL, 0x00000001afaf2812ULL, 0x002fc600078efcffULL,
0x0000006c7064723cULL, 0x000f680000041864ULL, 0x0000007c00bf7306ULL, 0x000e620000005400ULL,
0x00000001b9b94812ULL, 0x004fc600078efcffULL, 0x0000006c2844723cULL, 0x000f620000041844ULL,
0x0000008cb979723eULL, 0x000fc600000010ffULL, 0x0000007a00787306ULL, 0x000ff00000209400ULL,
0x0000007a00a77306ULL, 0x000ea20000205400ULL, 0x000000bfbe00720bULL, 0x002fce0003f9d000ULL,
0x0000007b00ae7306ULL, 0x000ff00000209400ULL, 0x0000007b00bb7306ULL, 0x000e620000205400ULL,
0x000000a77800720bULL, 0x004fe40003fdd000ULL, 0x00000090af78723eULL, 0x000fca00000010ffULL,
0x0000007c00887306ULL, 0x0004e4000000d400ULL, 0x000000787060723cULL, 0x080f6c0000041860ULL,
0x0000007a00b27306ULL, 0x0006e2000020d400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000bbae00720bULL, 0x002fe20003f5d000ULL, 0x000000782840723cULL, 0x000f6a0000041840ULL,
0x0000007b00ba7306ULL, 0x000e62000020d400ULL, 0x00000018ff7a7819ULL, 0x008fc4000001147cULL,
0x0000000188884812ULL, 0x000fca00078efcffULL, 0x0000007d00c57306ULL, 0x000fe20000009400ULL,
0x00000001b2b26812ULL, 0x000fce00078efcffULL, 0x0000007d00ca7306ULL, 0x000ea20000005400ULL,
0x00000001baba2812ULL, 0x002fce00078efcffULL, 0x000000c000b57306ULL, 0x000ff00000209400ULL,
0x000000c000c27306ULL, 0x000e620000205400ULL, 0x000000cac500720bULL, 0x004fce0003fdd000ULL,
0x000000c700c97306ULL, 0x000ff00000209400ULL, 0x000000c700cc7306ULL, 0x000ea20000205400ULL,
0x000000c2b500720bULL, 0x002fce0003fbd000ULL, 0x0000007a007b7306ULL, 0x000ff00000209400ULL,
0x0000007a00c47306ULL, 0x000e620000205400ULL, 0x000000ccc900720bULL, 0x004fce0003f5d000ULL,
0x0000007d00867306ULL, 0x0004f0000000d400ULL, 0x0000007f00957306ULL, 0x000fe20000009400ULL,
0x000100007d7d7824ULL, 0x004fe200078e00ffULL, 0x000000c47b00720bULL, 0x002fc40003f9d000ULL,
0x000000ba897b723eULL, 0x000fe400000010ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007f00267306ULL, 0x000e620000005400ULL, 0x0000000186866812ULL, 0x008fe400078efcffULL,
0x000000929100720bULL, 0x000fca0003fdd000ULL, 0x0000007e00977306ULL, 0x000ff00000009400ULL,
0x0000007e00947306ULL, 0x000ea20000005400ULL, 0x000000269500720bULL, 0x002fe40003f7d000ULL,
0x000000939c26723eULL, 0x000fc400000010ffULL, 0x0000000185856812ULL, 0x000fc600078efcffULL,
0x000000c000c17306ULL, 0x000e64000020d400ULL, 0x000000267068723cULL, 0x080f6c0000041868ULL,
0x000000c700cb7306ULL, 0x000ee2000020d400ULL, 0x000000949700720bULL, 0x004fe20003f1d000ULL,
0x000000262848723cULL, 0x000f6c0000041848ULL, 0x0000007a00c67306ULL, 0x0004e2000020d400ULL,
0x00000001c1c15812ULL, 0x002fc400078efcffULL, 0x000000c8c300720bULL, 0x000fe40003fbd000ULL,
0x00000088c188723eULL, 0x000fc600000010ffULL, 0x0000007d00c07306ULL, 0x000fe20000209400ULL,
0x000001007f7a7824ULL, 0x004fe200078e00ffULL, 0x00000001cbcb2812ULL, 0x008fc800078efcffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007d00cd7306ULL, 0x000e620000205400ULL,
0x00000001c6c64812ULL, 0x000fe400078efcffULL, 0x0000000187875812ULL, 0x000fe400078efcffULL,
0x0000008f8e00720bULL, 0x000fe40003fbd000ULL, 0x00000086cb89723eULL, 0x000fe200000010ffULL,
0x000000ce00967306ULL, 0x000fe20000209400ULL, 0x000000c687c6723eULL, 0x000fca00000010ffULL,
0x000000887058723cULL, 0x000f640000041858ULL, 0x000000ce00997306ULL, 0x000ea20000205400ULL,
0x000000cdc000720bULL, 0x002fe40003f5d000ULL, 0x0000000184845812ULL, 0x000fc600078efcffULL,
0x000000882838723cULL, 0x000f640000041838ULL, 0x0000007e00837306ULL, 0x0002f0000000d400ULL,
0x0000007f00817306ULL, 0x0006e2000000d400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x000000999600720bULL, 0x004fc80003f9d000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007d007c7306ULL, 0x000e62000020d400ULL, 0x000100007f7f7824ULL, 0x008fe200078e00ffULL,
0x0000000183830812ULL, 0x000fc800078efcffULL, 0x00000018ff937819ULL, 0x000fe4000001147fULL,
0x000000ce00987306ULL, 0x000ea2000020d400ULL, 0x0000000181813812ULL, 0x000fce00078efcffULL,
0x0000007a009a7306ULL, 0x000fe20000209400ULL, 0x000000017c7c2812ULL, 0x002fe400078efcffULL,
0x0000008b8a00720bULL, 0x000fe40003f5d000ULL, 0x0000007c85c7723eULL, 0x000fc600000010ffULL,
0x0000007a009b7306ULL, 0x000e620000205400ULL, 0x0000000198984812ULL, 0x004fc600078efcffULL,
0x000000c67054723cULL, 0x000f620000041854ULL, 0x000000839898723eULL, 0x000fc600000010ffULL,
0x0000007e007d7306ULL, 0x000fe20000209400ULL, 0x0000000182822812ULL, 0x000fc600078efcffULL,
0x000000c62834723cULL, 0x000f680000041834ULL, 0x0000007e00947306ULL, 0x000ea20000205400ULL,
0x0000009b9a00720bULL, 0x002fce0003fdd000ULL, 0x0000009300957306ULL, 0x000ff00000209400ULL,
0x00000093008c7306ULL, 0x000e620000205400ULL, 0x000000947d00720bULL, 0x004fce0003f9d000ULL,
0x0000007a009e7306ULL, 0x0004f0000020d400ULL, 0x0000007e007f7306ULL, 0x000ee2000020d400ULL,
0x0000008c9500720bULL, 0x002fe40003f1d000ULL, 0x000000b28d7a723eULL, 0x004fca00000010ffULL,
0x0000009300937306ULL, 0x000e62000020d400ULL, 0x000000019e9e6812ULL, 0x008fe200078efcffULL,
0x0000007a705c723cULL, 0x000f66000004185cULL, 0x000000819e99723eULL, 0x000fe400000010ffULL,
0x000000017f7f4812ULL, 0x000fc600078efcffULL, 0x0000007a283c723cULL, 0x000f62000004183cULL,
0x0000007f8484723eULL, 0x000fe400000010ffULL, 0x0000000193930812ULL, 0x002fca00078efcffULL,
0x000000987050723cULL, 0x000f620000041850ULL, 0x000000938285723eULL, 0x000fce00000010ffULL,
0x000000982830723cULL, 0x000f700000041830ULL, 0x00000084704c723cULL, 0x080f70000004184cULL,
0x00000084282c723cULL, 0x000b6e000004182cULL, 0x0001a6c81a2a7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000002a2a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6c7224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x000fc80000015200ULL,
0x0000040013257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780482bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040013257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020267824ULL, 0x000fca00078e00ffULL,
0xffffffe026257812ULL, 0x000fca00078ec0ffULL, 0x0000010016257824ULL, 0x000fca00078e0225ULL,
0x0000008025277810ULL, 0x000fe20007ffe0ffULL, 0x0000590024257a24ULL, 0x010fc600078e02ffULL,
0x0000002027247812ULL, 0x000fe200078ec0ffULL, 0x0000004025717824ULL, 0x000fc800078e00ffULL,
0x00000001192a7824ULL, 0x000fe200078e0224ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x000000271e247217ULL, 0x000fe40007800000ULL, 0x0000001026297812ULL, 0x000fe400078ec0ffULL,
0x00000003ff257819ULL, 0x000fe2000001161fULL, 0x0000000124247824ULL, 0x000fe200078e0a27ULL,
0x00006200716d7a11ULL, 0x000fe400078a38ffULL, 0x0000000425287810ULL, 0x040fe20007ffe0ffULL,
0x0000000125267824ULL, 0x000fe200078e0229ULL, 0x0000002429247217ULL, 0x000fc40007800000ULL,
0x0000000c252b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000126277824ULL, 0x040fe200078e021fULL,
0x0000630071717a11ULL, 0x000fe200028f3cffULL, 0x00000008266c7824ULL, 0x000fe400078e00ffULL,
0x0000000124247824ULL, 0x100fe400078e0a29ULL, 0x000000012b737824ULL, 0x000fe200078e0229ULL,
0xfffffff86c6c7812ULL, 0x000fe400078ee227ULL, 0x0000000825277810ULL, 0x000fe20007ffe0ffULL,
0x0000000173787824ULL, 0x000fe200078e021fULL, 0x000000242500720cULL, 0x080fe20003f86070ULL,
0x0000000126257824ULL, 0x000fe200078e022aULL, 0x000000242800720cULL, 0x0c0fe20003f66070ULL,
0x0000000128267824ULL, 0x100fe200078e0229ULL, 0x000000242700720cULL, 0x0c0fe20003f46070ULL,
0x0000000127287824ULL, 0x000fe200078e0229ULL, 0x000000242b00720cULL, 0x000fe20003f06070ULL,
0x0000000126277824ULL, 0x000fc400078e021fULL, 0x0000000826707824ULL, 0x000fe400078e00ffULL,
0x0000008025247825ULL, 0x000fc600078e00ffULL, 0xfffffff870707812ULL, 0x000fe200078ee227ULL,
0x0000000126267824ULL, 0x000fe200078e022aULL, 0x0000001224247212ULL, 0x000fe200078efcffULL,
0x0000000128297824ULL, 0x040fe400078e021fULL, 0x0000000828727824ULL, 0x000fe200078e00ffULL,
0x000000246d247210ULL, 0x000fe20007fbe0ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff872727812ULL, 0x000fe200078ee229ULL, 0x0000000128287824ULL, 0x100fe200078e022aULL,
0x0000001226267212ULL, 0x000fe200078efcffULL, 0x00000001732a7824ULL, 0x000fe400078e022aULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001228287212ULL, 0x000fc600078efcffULL, 0x0000000125257824ULL, 0x000fe200028e0671ULL,
0x0000006d26267210ULL, 0x000fe20007fbe0ffULL, 0x0000000873737824ULL, 0x000fe200078e00ffULL,
0x000000122a2a7212ULL, 0x000fc600078efcffULL, 0x0000000127277824ULL, 0x000fe200028e0671ULL,
0x0000006d28287210ULL, 0x080fe40007fbe0ffULL, 0x0000006d2a2a7210ULL, 0x000fe20007fde0ffULL,
0x000000106c6d7824ULL, 0x000fe200078e0203ULL, 0xfffffff873787812ULL, 0x000fe200078ee278ULL,
0x0000000129297824ULL, 0x100fe400028e0671ULL, 0x000000012b2b7824ULL, 0x000fe200030e0671ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000246d7faeULL, 0x0003e2000e101c48ULL,
0x0000001070717824ULL, 0x000fc400078e0203ULL, 0x0000001072737824ULL, 0x100fe400078e0203ULL,
0x0000001078797824ULL, 0x000fe200078e0203ULL, 0x0000000026717faeULL, 0x0003e8000d901c48ULL,
0x0000000028737faeULL, 0x0003e8000d101c48ULL, 0x000000002a797faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001026267812ULL, 0x000fe400078ec0ffULL,
0x00006200716d7a11ULL, 0x000fc400078038ffULL, 0x000000261f267211ULL, 0x000fe400078fe8ffULL,
0x0000630071717a11ULL, 0x000fe400000f3cffULL, 0x0000000426277810ULL, 0x040fe20007ffe0ffULL,
0x0000000126257824ULL, 0x040fe200078e021fULL, 0x0000000826297810ULL, 0x040fe20007ffe0ffULL,
0x00000008266c7824ULL, 0x040fe200078e00ffULL, 0x0000000c262b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000827707824ULL, 0x040fe400078e00ffULL, 0x0000000126247824ULL, 0x000fe200078e022aULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee225ULL, 0x0000000127257824ULL, 0x000fc400078e021fULL,
0x0000000127267824ULL, 0x100fe400078e022aULL, 0x0000000129287824ULL, 0x040fe200078e022aULL,
0xfffffff870707812ULL, 0x000fe200078ee225ULL, 0x0000000129277824ULL, 0x140fe400078e021fULL,
0x0000000829727824ULL, 0x000fe400078e00ffULL, 0x000000012b297824ULL, 0x040fe400078e021fULL,
0x000000082b787824ULL, 0x000fe200078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee227ULL,
0x0000008024247825ULL, 0x000fc600078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee229ULL,
0x000000012b2a7824ULL, 0x000fe200078e022aULL, 0x0000001224247212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0x000000246d247210ULL, 0x000fe20007f1e0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000001226267212ULL, 0x000fc600078efcffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001228287212ULL, 0x000fe400078efcffULL,
0x000000266d267210ULL, 0x000fe20007f5e0ffULL, 0x0000000125257824ULL, 0x000fe200000e0671ULL,
0x000000122a2a7212ULL, 0x000fe200078efcffULL, 0x0000001072737824ULL, 0x000fe200078e0203ULL,
0x000000286d287210ULL, 0x000fe20007f1e0ffULL, 0x0000000127277824ULL, 0x000fe200010e0671ULL,
0x0000002a6d2a7210ULL, 0x000fe20007f7e0ffULL, 0x000000106c6d7824ULL, 0x000fc400078e0203ULL,
0x0000000129297824ULL, 0x100fe400000e0671ULL, 0x000000012b2b7824ULL, 0x000fe200018e0671ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000246d7faeULL, 0x0003e2000b901c48ULL,
0x0000001070717824ULL, 0x100fe400078e0203ULL, 0x0000001078797824ULL, 0x000fc600078e0203ULL,
0x0000000026717faeULL, 0x0003e8000b901c48ULL, 0x0000000028737faeULL, 0x0003e8000b901c48ULL,
0x000000002a797faeULL, 0x0003e4000b901c48ULL, 0x0000000820257824ULL, 0x002fe200078e00ffULL,
0x0000000218267810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff025257812ULL, 0x000fe400078ec0ffULL, 0x0000001d2600720cULL, 0x000fe40003f06070ULL,
0x00000000250473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000117268824ULL, 0x000fc400078e0226ULL, 0x00000004ff278424ULL, 0x000fc800078e00ffULL,
0x0000640026268625ULL, 0x000fca00078e0027ULL, 0x0000000826248981ULL, 0x000522000c1e1900ULL,
0x0001a6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6a800252a7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a62800236c7f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x01a62c0023257984ULL, 0x002e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a62c0023257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002020257824ULL, 0x000fca00078e00ffULL, 0xffffff8025257812ULL, 0x000fc800078ec0ffULL,
0x0000008012267810ULL, 0x000fca0007ffe025ULL, 0x0000000111267824ULL, 0x000fca00078e0226ULL,
0x01a0000026707984ULL, 0x000e680000000800ULL, 0x01a2000026257984ULL, 0x0006a20000000800ULL,
0x000000217000720bULL, 0x002fe20003f1d000ULL, 0x000166f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000267806ULL, 0x008fc800000e0100ULL, 0x000000ff2600720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6c7424ULL, 0x000fd600078e00ffULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x000000011b277810ULL, 0x000fe40007ffe0ffULL,
0x000000217000720bULL, 0x000fe40003f54000ULL, 0x000000202700720cULL, 0x000fe20003f05270ULL,
0x000166c27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000717806ULL, 0x000fc400010e0100ULL,
0x0000008020288824ULL, 0x000fe200078e0212ULL, 0x0000002170278209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000111288824ULL, 0x000fca00078e0228ULL,
0x01a4002728008388ULL, 0x0003e20000000800ULL, 0x000000ff7100720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002170287209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff71ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002128277221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b27277820ULL, 0x000fc80000410000ULL,
0x0000002700737308ULL, 0x000e640000000800ULL, 0x0000007322227220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161fULL,
0x000166027f007947ULL, 0x000fea000b800000ULL, 0x00001f2973287589ULL, 0x0002e400000e0000ULL,
0x0000002868687220ULL, 0x08cfe40000410000ULL, 0x0000002869697220ULL, 0x080fe40000410000ULL,
0x0000002864647220ULL, 0x080fe40000410000ULL, 0x0000002865657220ULL, 0x000fc40000410000ULL,
0x0000002860607220ULL, 0x080fe40000410000ULL, 0x0000002861617220ULL, 0x080fe40000410000ULL,
0x000000285c5c7220ULL, 0x080fe40000410000ULL, 0x000000285d5d7220ULL, 0x080fe40000410000ULL,
0x0000002858587220ULL, 0x080fe40000410000ULL, 0x0000002859597220ULL, 0x000fc40000410000ULL,
0x0000002854547220ULL, 0x080fe40000410000ULL, 0x0000002855557220ULL, 0x080fe40000410000ULL,
0x0000002850507220ULL, 0x080fe40000410000ULL, 0x0000002851517220ULL, 0x080fe40000410000ULL,
0x000000284c4c7220ULL, 0x080fe40000410000ULL, 0x000000284d4d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081f297811ULL, 0x002fe200078ff0ffULL, 0x000164f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2973287589ULL, 0x0002e400000e0000ULL, 0x000000286a6a7220ULL, 0x08cfe40000410000ULL,
0x000000286b6b7220ULL, 0x080fe40000410000ULL, 0x0000002866667220ULL, 0x080fe40000410000ULL,
0x0000002867677220ULL, 0x080fe40000410000ULL, 0x0000002862627220ULL, 0x080fe40000410000ULL,
0x0000002863637220ULL, 0x000fc40000410000ULL, 0x000000285e5e7220ULL, 0x080fe40000410000ULL,
0x000000285f5f7220ULL, 0x080fe40000410000ULL, 0x000000285a5a7220ULL, 0x080fe40000410000ULL,
0x000000285b5b7220ULL, 0x080fe40000410000ULL, 0x0000002856567220ULL, 0x080fe40000410000ULL,
0x0000002857577220ULL, 0x000fc40000410000ULL, 0x0000002852527220ULL, 0x080fe40000410000ULL,
0x0000002853537220ULL, 0x080fe40000410000ULL, 0x000000284e4e7220ULL, 0x080fe40000410000ULL,
0x000000284f4f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101f297811ULL, 0x002fe200078ff0ffULL,
0x000163e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2973287589ULL, 0x0002e400000e0000ULL,
0x0000002848487220ULL, 0x08cfe40000410000ULL, 0x0000002849497220ULL, 0x080fe40000410000ULL,
0x0000002844447220ULL, 0x080fe40000410000ULL, 0x0000002845457220ULL, 0x080fe40000410000ULL,
0x0000002840407220ULL, 0x080fe40000410000ULL, 0x0000002841417220ULL, 0x000fc40000410000ULL,
0x000000283c3c7220ULL, 0x080fe40000410000ULL, 0x000000283d3d7220ULL, 0x080fe40000410000ULL,
0x0000002838387220ULL, 0x080fe40000410000ULL, 0x0000002839397220ULL, 0x080fe40000410000ULL,
0x0000002834347220ULL, 0x080fe40000410000ULL, 0x0000002835357220ULL, 0x000fc40000410000ULL,
0x0000002830307220ULL, 0x080fe40000410000ULL, 0x0000002831317220ULL, 0x080fe40000410000ULL,
0x000000282c2c7220ULL, 0x080fe40000410000ULL, 0x000000282d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000071ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181f297811ULL, 0x002fe200078ff0ffULL,
0x000162e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2973287589ULL, 0x0002e400000e0000ULL,
0x000000284a4a7220ULL, 0x08cfe40000410000ULL, 0x000000284b4b7220ULL, 0x080fe40000410000ULL,
0x0000002846467220ULL, 0x080fe40000410000ULL, 0x0000002847477220ULL, 0x080fe40000410000ULL,
0x0000002842427220ULL, 0x080fe40000410000ULL, 0x0000002843437220ULL, 0x000fc40000410000ULL,
0x000000283e3e7220ULL, 0x080fe40000410000ULL, 0x000000283f3f7220ULL, 0x080fe40000410000ULL,
0x000000283a3a7220ULL, 0x080fe40000410000ULL, 0x000000283b3b7220ULL, 0x080fe40000410000ULL,
0x0000002836367220ULL, 0x080fe40000410000ULL, 0x0000002837377220ULL, 0x000fc40000410000ULL,
0x0000002832327220ULL, 0x080fe40000410000ULL, 0x0000002833337220ULL, 0x080fe40000410000ULL,
0x000000282e2e7220ULL, 0x080fe40000410000ULL, 0x000000282f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007126ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff6c7424ULL, 0x000fe200078e00ffULL, 0x0000002170217209ULL, 0x000fd60007810000ULL,
0x8000002170700221ULL, 0x000fe20000010000ULL, 0x00007610ff6c0816ULL, 0x000fc6000000006cULL,
0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL, 0x0000007000100308ULL, 0x000e640000000800ULL,
0x0000001025250220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002225227221ULL, 0x004fc40000010000ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x0000000820257824ULL, 0x000fca00078e00ffULL, 0xfffffff0256d7812ULL, 0x000fca00078ec0ffULL,
0x01a6b4006d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b4006d257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106c257816ULL, 0x000fc800000000ffULL, 0x000000ff2500720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000010ff0c723eULL, 0x000fe400000010ffULL,
0x00000002ff257819ULL, 0x000fe4000001161fULL, 0x000054100c0c7816ULL, 0x000fe2000000000cULL,
0x00015ec27f007947ULL, 0x000fea000b800000ULL, 0x00001f250c0f7589ULL, 0x0002a400000e0000ULL,
0x0000000825297810ULL, 0x000fe20007ffe0ffULL, 0x00015f127f007947ULL, 0x000fea000b800000ULL,
0x00000010250d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f290c0e7589ULL, 0x00066a00000e0000ULL,
0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL, 0x0000001825297810ULL, 0x008fe20007ffe0ffULL,
0x00015fa27f007947ULL, 0x000fea000b800000ULL, 0x00001f290c0c7589ULL, 0x0022e400000e0000ULL,
0x0000040020257824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100020267824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00025257812ULL, 0x000fc400078ec0ffULL, 0xffffe00026277812ULL, 0x000fe400078ec0ffULL,
0x0001300025267810ULL, 0x000fe40007ffe0ffULL, 0x0001700027257810ULL, 0x000fc60007ffe0ffULL,
0x0000001009707824ULL, 0x100fe400078e0226ULL, 0x00000010086c7824ULL, 0x000fe400078e0226ULL,
0x0000001007787824ULL, 0x000fe400078e0225ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000006c6c783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707231ULL, 0x086fe400003400ffULL, 0x0000000f72727231ULL, 0x000fc400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fe400003400ffULL,
0x0000000d6c6c7231ULL, 0x088fe400003400ffULL, 0x0000000d6e6e7231ULL, 0x000fe400003400ffULL,
0x0000000c6d6d7231ULL, 0x080fe400003400ffULL, 0x0000000c6f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010067c7824ULL, 0x000fe200078e0225ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000f9000007945ULL, 0x000fe80003800000ULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x0000007800987306ULL, 0x008fe20000009400ULL,
0x00000018ff257819ULL, 0x000fe20000011478ULL, 0x00000100789a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011479ULL, 0x00000100799f7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x004fe2000001147eULL, 0x000001007ab07824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001147bULL, 0x00000078009b7306ULL, 0x000ea20000005400ULL,
0x00000018ffa57819ULL, 0x000fe2000001149fULL, 0x000001007bb47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fe2000001147fULL, 0x000001007cc27824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe2000001147aULL, 0x000001007dc67824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe2000001147dULL, 0x0000007800957306ULL, 0x000662000000d400ULL,
0x00000018ff9a7819ULL, 0x000fc4000001149aULL, 0x00000018ffb07819ULL, 0x000fe400000114b0ULL,
0x00000018ffb77819ULL, 0x000fe400000114b4ULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0000007900a37306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x008fe200078e00ffULL,
0x0000009b9800720bULL, 0x004fe20003f7d000ULL, 0x000001007e9b7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe400000114c6ULL, 0x00000018ff787819ULL, 0x000fc40000011478ULL,
0x0000007900a47306ULL, 0x000ea20000005400ULL, 0x00000018ff9b7819ULL, 0x000fcc000001149bULL,
0x0000000195953812ULL, 0x002fe200078efcffULL, 0x0000002500a17306ULL, 0x000ff00000209400ULL,
0x0000002500a27306ULL, 0x000fe20000205400ULL, 0x000000a4a300720bULL, 0x004fce0003f9d000ULL,
0x0000002500947306ULL, 0x0003f0000020d400ULL, 0x0000008200ac7306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x002fce000001147cULL, 0x0000008200ad7306ULL, 0x000ff00000205400ULL,
0x0000008200917306ULL, 0x000ff0000020d400ULL, 0x000000a000897306ULL, 0x000ff00000209400ULL,
0x000000a0008c7306ULL, 0x000ff00000205400ULL, 0x000000a000827306ULL, 0x000ff0000020d400ULL,
0x00000078009f7306ULL, 0x000ff00000209400ULL, 0x0000007800a07306ULL, 0x000e700000205400ULL,
0x0000008a00be7306ULL, 0x000ff00000209400ULL, 0x0000008a00bf7306ULL, 0x000fe20000205400ULL,
0x000000a09f00720bULL, 0x002fe20003fdd000ULL, 0x000100007f9f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe2000001149fULL, 0x0000008a00877306ULL, 0x000ff0000020d400ULL,
0x0000002500c57306ULL, 0x000ff00000209400ULL, 0x0000002500c87306ULL, 0x000ff00000205400ULL,
0x0000002500857306ULL, 0x000ff0000020d400ULL, 0x000000a9008d7306ULL, 0x000ff00000209400ULL,
0x000000a9008a7306ULL, 0x000ff00000205400ULL, 0x000000a900257306ULL, 0x0003f0000020d400ULL,
0x0000007900297306ULL, 0x000ea2000000d400ULL, 0x0001000079a97824ULL, 0x002fca00078e00ffULL,
0x00000018ffa97819ULL, 0x000fe400000114a9ULL, 0x000000a500a67306ULL, 0x000ff00000209400ULL,
0x000000a500a77306ULL, 0x000e620000205400ULL, 0x0000000129294812ULL, 0x004fc400078efcffULL,
0x000000adac00720bULL, 0x000fca0003f9d000ULL, 0x0000008300b37306ULL, 0x000ff00000209400ULL,
0x0000008300b67306ULL, 0x000fe20000205400ULL, 0x000000a7a600720bULL, 0x002fe40003fbd000ULL,
0x0000000191914812ULL, 0x000fca00078efcffULL, 0x00000083008f7306ULL, 0x000ff0000020d400ULL,
0x0000009c00927306ULL, 0x000ff00000209400ULL, 0x0000009c00937306ULL, 0x000ff00000205400ULL,
0x0000009c00837306ULL, 0x000ff0000020d400ULL, 0x0000009a009c7306ULL, 0x000ff00000209400ULL,
0x0000009a009d7306ULL, 0x000e700000205400ULL, 0x0000009a009e7306ULL, 0x000eb0000020d400ULL,
0x000000a500a87306ULL, 0x000ee2000020d400ULL, 0x0000009d9c00720bULL, 0x002fce0003f5d000ULL,
0x0000007800797306ULL, 0x000e6c000020d400ULL, 0x000000019e9e2812ULL, 0x004fe400078efcffULL,
0x000000a9009a7306ULL, 0x000fe20000209400ULL, 0x00000001a8a85812ULL, 0x008fe400078efcffULL,
0x000000a2a100720bULL, 0x000fc40003f5d000ULL, 0x00000029a829723eULL, 0x000fc600000010ffULL,
0x000000a900ab7306ULL, 0x000ea20000205400ULL, 0x0000000179796812ULL, 0x002fce00078efcffULL,
0x000000b000a57306ULL, 0x000fe20000209400ULL, 0x0000000194942812ULL, 0x000fce00078efcffULL,
0x000000b000b27306ULL, 0x000e620000205400ULL, 0x000000ab9a00720bULL, 0x004fce0003f7d000ULL,
0x0000007a00ae7306ULL, 0x000ff00000009400ULL, 0x0000007a00af7306ULL, 0x000ea20000005400ULL,
0x000000b2a500720bULL, 0x002fce0003fdd000ULL, 0x0000007a00907306ULL, 0x0002f0000000d400ULL,
0x000000a900aa7306ULL, 0x000ee2000020d400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x000000afae00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x000000b000b17306ULL, 0x000e6e000020d400ULL, 0x0000000190905812ULL, 0x008fe200078efcffULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x00000001aaaa3812ULL, 0x000fce00078efcffULL,
0x0000007a00a97306ULL, 0x000ea20000205400ULL, 0x00000001b1b16812ULL, 0x002fe400078efcffULL,
0x000000b6b300720bULL, 0x000fca0003fdd000ULL, 0x0000007b00b57306ULL, 0x000ff00000009400ULL,
0x0000007b00b87306ULL, 0x000e620000005400ULL, 0x000000a97800720bULL, 0x004fe40003f9d000ULL,
0x000000018f8f6812ULL, 0x000fc400078efcffULL, 0x000000799478723eULL, 0x000fe400000010ffULL,
0x000000aa9179723eULL, 0x000fe200000010ffULL, 0x0000007b008e7306ULL, 0x0004ec000000d400ULL,
0x000000787064723cULL, 0x000f640000041864ULL, 0x0000007a00b47306ULL, 0x000ee2000020d400ULL,
0x000100007b7b7824ULL, 0x004fe200078e00ffULL, 0x000000b8b500720bULL, 0x002fc80003f7d000ULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x000000786c44723cULL, 0x000f620000041844ULL,
0x0000007c00c07306ULL, 0x000fee0000009400ULL, 0x000000018e8e3812ULL, 0x008fe200078efcffULL,
0x0000007b00b07306ULL, 0x000fe20000209400ULL, 0x00000001b4b44812ULL, 0x000fce00078efcffULL,
0x0000007b00bd7306ULL, 0x000e700000205400ULL, 0x0000007c00c17306ULL, 0x000eb00000005400ULL,
0x000000b700b97306ULL, 0x000fe20000209400ULL, 0x000000bdb000720bULL, 0x002fce0003fbd000ULL,
0x000000b700ba7306ULL, 0x000e620000205400ULL, 0x000000c1c000720bULL, 0x004fce0003f9d000ULL,
0x000000b700bb7306ULL, 0x000eb0000020d400ULL, 0x000000c200b77306ULL, 0x000fe20000209400ULL,
0x000000bab900720bULL, 0x002fce0003f5d000ULL, 0x000000c200c47306ULL, 0x000e6c0000205400ULL,
0x00000001bbbb2812ULL, 0x004fe400078efcffULL, 0x000000c700c97306ULL, 0x000fe20000209400ULL,
0x000000bfbe00720bULL, 0x000fce0003f5d000ULL, 0x000000c700ca7306ULL, 0x000ea20000205400ULL,
0x000000c4b700720bULL, 0x002fca0003f7d000ULL, 0x0000000187872812ULL, 0x000fe400078efcffULL,
0x0000007c00867306ULL, 0x0002f0000000d400ULL, 0x0000007d00967306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x002fe200078e00ffULL, 0x000000cac900720bULL, 0x004fc80003fdd000ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00997306ULL, 0x000fe20000005400ULL,
0x0000000186864812ULL, 0x008fe400078efcffULL, 0x000000c8c500720bULL, 0x000fca0003f9d000ULL,
0x0000007d00847306ULL, 0x0003f0000000d400ULL, 0x0000007b00bc7306ULL, 0x000ea2000020d400ULL,
0x000100007d7d7824ULL, 0x002fe200078e00ffULL, 0x0000000185854812ULL, 0x000fc800078efcffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x000000c200c37306ULL, 0x000e70000020d400ULL,
0x000000c700cb7306ULL, 0x000ee2000020d400ULL, 0x00000001bcbc5812ULL, 0x004fc400078efcffULL,
0x000000999600720bULL, 0x000fca0003fbd000ULL, 0x0000007c007a7306ULL, 0x000fe20000209400ULL,
0x00000001c3c33812ULL, 0x002fc800078efcffULL, 0x00000086c386723eULL, 0x000fc600000010ffULL,
0x0000007c007b7306ULL, 0x000e620000205400ULL, 0x00000001cbcb6812ULL, 0x008fe400078efcffULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x000000939200720bULL, 0x000fc60003fbd000ULL,
0x0000007d00c27306ULL, 0x000ff00000209400ULL, 0x0000007d00cd7306ULL, 0x000ea20000205400ULL,
0x0000007b7a00720bULL, 0x002fe40003f7d000ULL, 0x0000000183835812ULL, 0x000fc400078efcffULL,
0x0000008c8900720bULL, 0x000fe40003fbd000ULL, 0x00000090b17a723eULL, 0x000fe200000010ffULL,
0x0000007d00987306ULL, 0x0002e2000020d400ULL, 0x0000008ebb7b723eULL, 0x000fce00000010ffULL,
0x0000007f00887306ULL, 0x000fe20000009400ULL, 0x000001007f7d7824ULL, 0x002fe200078e00ffULL,
0x000000cdc200720bULL, 0x004fe20003fdd000ULL, 0x0000007a7060723cULL, 0x080f620000041860ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007f008b7306ULL, 0x000e660000005400ULL, 0x0000007a6c40723cULL, 0x000f680000041840ULL,
0x0000000198986812ULL, 0x008fe200078efcffULL, 0x0000007c00c67306ULL, 0x000ea6000020d400ULL,
0x0000009883c7723eULL, 0x000fca00000010ffULL, 0x0000009b007c7306ULL, 0x000fe20000209400ULL,
0x0000008b8800720bULL, 0x002fce0003f9d000ULL, 0x0000009b009d7306ULL, 0x000e620000205400ULL,
0x00000001c6c63812ULL, 0x004fc800078efcffULL, 0x000000c685c6723eULL, 0x000fc600000010ffULL,
0x0000009b009a7306ULL, 0x000ea8000020d400ULL, 0x000000c67054723cULL, 0x080f680000041854ULL,
0x0000007e00977306ULL, 0x000fe20000009400ULL, 0x0000009d7c00720bULL, 0x002fe40003f7d000ULL,
0x000000b48f7c723eULL, 0x000fe200000010ffULL, 0x000000c66c34723cULL, 0x000f680000041834ULL,
0x0000007e00287306ULL, 0x000e6c0000005400ULL, 0x000000019a9a3812ULL, 0x004fc400078efcffULL,
0x0000007d009c7306ULL, 0x000fe20000209400ULL, 0x0000008a8d00720bULL, 0x000fce0003f7d000ULL,
0x0000007d009b7306ULL, 0x000ea20000205400ULL, 0x000000289700720bULL, 0x002fe40003f5d000ULL,
0x000000959e28723eULL, 0x000fc600000010ffULL, 0x0000000125253812ULL, 0x000fe400078efcffULL,
0x0000007e00817306ULL, 0x0002e4000000d400ULL, 0x000000287068723cULL, 0x080f6c0000041868ULL,
0x0000007f00277306ULL, 0x000ee2000000d400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x0000009b9c00720bULL, 0x004fe20003fdd000ULL, 0x000000286c48723cULL, 0x000f660000041848ULL,
0x00000018ff7e7819ULL, 0x000fc4000001147eULL, 0x0000007d00a07306ULL, 0x0002a2000020d400ULL,
0x0000000181812812ULL, 0x008fc800078efcffULL, 0x000000819a9a723eULL, 0x000fc600000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x000000bc877d723eULL, 0x002fe400000010ffULL,
0x00000084cb87723eULL, 0x000fe400000010ffULL, 0x0000000127274812ULL, 0x000fc600078efcffULL,
0x0000007e00967306ULL, 0x000e620000205400ULL, 0x00000001a0a06812ULL, 0x004fe200078efcffULL,
0x0000007c705c723cULL, 0x040f66000004185cULL, 0x00000027a09b723eULL, 0x000fe200000010ffULL,
0x0000001004277824ULL, 0x000fe400078e0226ULL, 0x0000009f00917306ULL, 0x000fe40000209400ULL,
0x000000867058723cULL, 0x040f6c0000041858ULL, 0x0000009f00887306ULL, 0x000ea20000205400ULL,
0x000000967f00720bULL, 0x002fe20003f5d000ULL, 0x0000009a7050723cULL, 0x000f6c0000041850ULL,
0x0000007e00897306ULL, 0x000e64000020d400ULL, 0x0000007c6c3c723cULL, 0x040f6c000004183cULL,
0x0000009f00847306ULL, 0x000ee2000020d400ULL, 0x000000889100720bULL, 0x004fe20003fdd000ULL,
0x000000866c38723cULL, 0x000f620000041838ULL, 0x0000000189892812ULL, 0x002fce00078efcffULL,
0x0000009a6c30723cULL, 0x000f620000041830ULL, 0x000000898282723eULL, 0x000fc600000010ffULL,
0x0000000184846812ULL, 0x008fc800078efcffULL, 0x000000842583723eULL, 0x000fe400000010ffULL,
0x0000100003257810ULL, 0x000fca0007ffe0ffULL, 0x00000082704c723cULL, 0x080b6e000004184cULL,
0x0000001005707824ULL, 0x020fe200078e0226ULL, 0x000000826c2c723cULL, 0x000b62000004182cULL,
0x0000001002267824ULL, 0x000fe200078e0225ULL, 0x00000000276c783bULL, 0x0202a80000000200ULL,
0x000000007070783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fd80003800000ULL,
0x0000000f70707231ULL, 0x088fe400003400ffULL, 0x0000000f72727231ULL, 0x000fc400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fe400003400ffULL,
0x0000000d6c6c7231ULL, 0x084fe400003400ffULL, 0x0000000d6e6e7231ULL, 0x000fe400003400ffULL,
0x0000000c6d6d7231ULL, 0x080fe400003400ffULL, 0x0000000c6f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010007c7824ULL, 0x000fe200078e0225ULL,
0x000000002678783bULL, 0x000e6a0000004200ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000078009c7306ULL, 0x002fe20000009400ULL, 0x00000018ff817819ULL, 0x000fe20000011478ULL,
0x00000100789e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011479ULL,
0x0000010079a27824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe2000001147aULL,
0x000001007ab27824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x008fe2000001147dULL,
0x00000078009d7306ULL, 0x000e620000005400ULL, 0x00000018ffa37819ULL, 0x000fe2000001147eULL,
0x000001007bb57824ULL, 0x000fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe2000001149eULL,
0x000001007dc77824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe200000114a2ULL,
0x000001007cc47824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe2000001147bULL,
0x0000007800947306ULL, 0x0006a2000000d400ULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x000001007ecf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fc4000001147fULL,
0x00000018ffbb7819ULL, 0x000fe400000114b5ULL, 0x00000018ffc97819ULL, 0x000fe200000114c7ULL,
0x0000007900a77306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x008fe200078e00ffULL,
0x0000009d9c00720bULL, 0x002fe40003fdd000ULL, 0x00000018ffc47819ULL, 0x000fe400000114c4ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900a87306ULL, 0x000e620000005400ULL,
0x00000018ffcf7819ULL, 0x000fcc00000114cfULL, 0x0000000194946812ULL, 0x004fe200078efcffULL,
0x0000008200ae7306ULL, 0x000ff00000209400ULL, 0x0000008200b17306ULL, 0x000fe20000205400ULL,
0x000000a8a700720bULL, 0x002fce0003f5d000ULL, 0x0000008200907306ULL, 0x000ff0000020d400ULL,
0x0000008400b77306ULL, 0x000ff00000209400ULL, 0x0000008400b87306ULL, 0x000ff00000205400ULL,
0x00000084008c7306ULL, 0x000ff0000020d400ULL, 0x0000009f00917306ULL, 0x000ff00000209400ULL,
0x0000009f00927306ULL, 0x000ff00000205400ULL, 0x0000009f00847306ULL, 0x000ff0000020d400ULL,
0x000000a3008e7306ULL, 0x000ff00000209400ULL, 0x000000a3008f7306ULL, 0x000ff00000205400ULL,
0x000000a300827306ULL, 0x000ff0000020d400ULL, 0x0000009e009f7306ULL, 0x000ff00000209400ULL,
0x0000009e00a07306ULL, 0x000e700000205400ULL, 0x0000007800a27306ULL, 0x000ff00000209400ULL,
0x0000007800a37306ULL, 0x000ea20000205400ULL, 0x000000a09f00720bULL, 0x002fce0003fbd000ULL,
0x0000007900297306ULL, 0x0002f0000000d400ULL, 0x0000008100a57306ULL, 0x000fe20000209400ULL,
0x0001000079797824ULL, 0x002fe200078e00ffULL, 0x000000a3a200720bULL, 0x004fc80003f9d000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000008100a67306ULL, 0x000fe20000205400ULL,
0x0000000129292812ULL, 0x008fce00078efcffULL, 0x0000008100937306ULL, 0x0003f0000020d400ULL,
0x000000a900aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff817819ULL, 0x002fce000001147cULL,
0x000000a900ab7306ULL, 0x000e700000205400ULL, 0x000000a900ac7306ULL, 0x000eb0000020d400ULL,
0x000000b200a97306ULL, 0x000fe20000209400ULL, 0x000000abaa00720bULL, 0x002fce0003f1d000ULL,
0x000000b200b47306ULL, 0x000e6c0000205400ULL, 0x00000001acac0812ULL, 0x004fe400078efcffULL,
0x0000008900c07306ULL, 0x000fe20000209400ULL, 0x000000b1ae00720bULL, 0x000fe40003f1d000ULL,
0x00000029ac29723eULL, 0x000fca00000010ffULL, 0x0000008900c37306ULL, 0x000fe20000205400ULL,
0x000000b4a900720bULL, 0x002fca0003f5d000ULL, 0x0000000190900812ULL, 0x000fe400078efcffULL,
0x0000008900887306ULL, 0x000fe2000020d400ULL, 0x000000b8b700720bULL, 0x000fce0003f1d000ULL,
0x00000081009b7306ULL, 0x000fec0000209400ULL, 0x000000018c8c0812ULL, 0x000fe400078efcffULL,
0x00000081009a7306ULL, 0x000ff00000205400ULL, 0x0000008100867306ULL, 0x000ff0000020d400ULL,
0x000000a400897306ULL, 0x000ff00000209400ULL, 0x000000a4008a7306ULL, 0x000ff00000205400ULL,
0x000000a400817306ULL, 0x000ff0000020d400ULL, 0x0000009e00a17306ULL, 0x000e70000020d400ULL,
0x0000007800a47306ULL, 0x000eb0000020d400ULL, 0x0000007b00b97306ULL, 0x000fe20000009400ULL,
0x00000001a1a15812ULL, 0x002fc400078efcffULL, 0x000000a6a500720bULL, 0x000fe20003fbd000ULL,
0x000100007fa57824ULL, 0x000fc800078e00ffULL, 0x0000007b00ba7306ULL, 0x000e620000005400ULL,
0x00000001a4a44812ULL, 0x004fe400078efcffULL, 0x00000018ffa57819ULL, 0x000fca00000114a5ULL,
0x0000007b008b7306ULL, 0x0004e2000000d400ULL, 0x0000000193935812ULL, 0x000fce00078efcffULL,
0x00000079009e7306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x000000bab900720bULL, 0x002fc80003fbd000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000007900ad7306ULL, 0x000e6e0000205400ULL, 0x000000018b8b5812ULL, 0x008fe200078efcffULL,
0x000000bb00bc7306ULL, 0x000ff00000209400ULL, 0x000000bb00bd7306ULL, 0x000ea20000205400ULL,
0x000000ad9e00720bULL, 0x002fce0003fdd000ULL, 0x0000007a00b07306ULL, 0x000ff00000009400ULL,
0x0000007a00b37306ULL, 0x000e620000005400ULL, 0x000000bdbc00720bULL, 0x004fce0003f9d000ULL,
0x0000007a008d7306ULL, 0x0004f0000000d400ULL, 0x000000b200b67306ULL, 0x000ee2000020d400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x000000b3b000720bULL, 0x002fc80003f7d000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007b00b27306ULL, 0x000fee0000209400ULL,
0x000000018d8d3812ULL, 0x008fe200078efcffULL, 0x0000007b00bf7306ULL, 0x000e620000205400ULL,
0x00000001b6b62812ULL, 0x000fc400078efcffULL, 0x000000c3c000720bULL, 0x000fca0003f7d000ULL,
0x0000007900af7306ULL, 0x000eb0000020d400ULL, 0x000000bb00be7306ULL, 0x000ee2000020d400ULL,
0x000000bfb200720bULL, 0x002fe40003f5d000ULL, 0x0000000188883812ULL, 0x000fca00078efcffULL,
0x0000007c00c27306ULL, 0x000fe20000009400ULL, 0x00000001afaf6812ULL, 0x004fce00078efcffULL,
0x0000007c00c57306ULL, 0x000e620000005400ULL, 0x00000001bebe4812ULL, 0x008fce00078efcffULL,
0x0000007a00787306ULL, 0x000ff00000209400ULL, 0x0000007a00797306ULL, 0x000ea20000205400ULL,
0x000000c5c200720bULL, 0x002fce0003f9d000ULL, 0x0000007c00877306ULL, 0x0002f0000000d400ULL,
0x0000007b00c17306ULL, 0x000ee2000020d400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000797800720bULL, 0x004fc40003fdd000ULL, 0x000000af9079723eULL, 0x000fe400000010ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x000000c900ca7306ULL, 0x000fe20000209400ULL,
0x0000000187874812ULL, 0x008fe400078efcffULL, 0x000000a49378723eULL, 0x000fca00000010ffULL,
0x000000c900cb7306ULL, 0x000e620000205400ULL, 0x00000001c1c12812ULL, 0x000fe200078efcffULL,
0x000000787064723cULL, 0x080f6c0000041864ULL, 0x0000007a00b57306ULL, 0x000ea4000020d400ULL,
0x000000786c44723cULL, 0x000f6c0000041844ULL, 0x0000007d00987306ULL, 0x000fe20000009400ULL,
0x000000cbca00720bULL, 0x002fce0003f5d000ULL, 0x0000007d00997306ULL, 0x000e620000005400ULL,
0x00000001b5b56812ULL, 0x004fc800078efcffULL, 0x000000b58c8c723eULL, 0x000fc600000010ffULL,
0x0000007d00857306ULL, 0x0004f0000000d400ULL, 0x000000c400bb7306ULL, 0x000fe20000209400ULL,
0x000100007d7d7824ULL, 0x004fe200078e00ffULL, 0x000000999800720bULL, 0x002fcc0003fdd000ULL,
0x000000c400c67306ULL, 0x000e6e0000205400ULL, 0x0000000185856812ULL, 0x008fe200078efcffULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x000000929100720bULL, 0x000fce0003fdd000ULL,
0x0000007c007b7306ULL, 0x000ea20000205400ULL, 0x000000c6bb00720bULL, 0x002fca0003fbd000ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x000000c400c87306ULL, 0x0002f0000020d400ULL,
0x000000c900cc7306ULL, 0x000ee2000020d400ULL, 0x00000018ffc47819ULL, 0x002fc4000001147dULL,
0x0000007b7a00720bULL, 0x004fe40003f9d000ULL, 0x0000008bbe7b723eULL, 0x000fe400000010ffULL,
0x0000008db67a723eULL, 0x000fe200000010ffULL, 0x000000c400cd7306ULL, 0x000fe20000209400ULL,
0x00000001c8c85812ULL, 0x008fe400078efcffULL, 0x0000009a9b00720bULL, 0x000fe40003fbd000ULL,
0x000000c1888d723eULL, 0x000fe200000010ffULL, 0x0000007a7060723cULL, 0x000f620000041860ULL,
0x00000087c8c8723eULL, 0x000fe200000010ffULL, 0x000000c400ce7306ULL, 0x000e620000205400ULL,
0x00000001cccc2812ULL, 0x000fc800078efcffULL, 0x00000085ccc9723eULL, 0x000fe200000010ffULL,
0x0000008c705c723cULL, 0x000f64000004185cULL, 0x0000007c00c77306ULL, 0x0004e2000020d400ULL,
0x0000000186865812ULL, 0x000fe400078efcffULL, 0x0000008f8e00720bULL, 0x000fc60003fbd000ULL,
0x000000c87058723cULL, 0x000f640000041858ULL, 0x0000007e00977306ULL, 0x000fe20000009400ULL,
0x000001007f7c7824ULL, 0x004fe200078e00ffULL, 0x000000cecd00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff9f7819ULL, 0x000fe2000001147cULL, 0x0000007a6c40723cULL, 0x000f620000041840ULL,
0x0000007e00967306ULL, 0x000e620000005400ULL, 0x00000001c7c74812ULL, 0x008fe400078efcffULL,
0x0000000182825812ULL, 0x000fc800078efcffULL, 0x0000008c6c3c723cULL, 0x040f62000004183cULL,
0x000000cf009c7306ULL, 0x000fee0000209400ULL, 0x000000c86c38723cULL, 0x000f620000041838ULL,
0x000000cf009d7306ULL, 0x000ea20000205400ULL, 0x000000969700720bULL, 0x002fce0003f1d000ULL,
0x0000007e00837306ULL, 0x0002f0000000d400ULL, 0x000000c4007d7306ULL, 0x000ee2000020d400ULL,
0x000100007e7e7824ULL, 0x002fe200078e00ffULL, 0x0000009d9c00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007f00957306ULL, 0x000fe20000009400ULL,
0x0000000183830812ULL, 0x008fce00078efcffULL, 0x0000007f00287306ULL, 0x000e620000005400ULL,
0x000000017d7d2812ULL, 0x000fe400078efcffULL, 0x0000008a8900720bULL, 0x000fe40003f5d000ULL,
0x0000007d847d723eULL, 0x000fc600000010ffULL, 0x0000007f00277306ULL, 0x000eb0000000d400ULL,
0x000000cf009e7306ULL, 0x000ee2000020d400ULL, 0x000000289500720bULL, 0x002fe40003f7d000ULL,
0x0000000181812812ULL, 0x000fc400078efcffULL, 0x00000094a128723eULL, 0x000fc600000010ffULL,
0x0000009f00a07306ULL, 0x000fe80000209400ULL, 0x000000287068723cULL, 0x000f640000041868ULL,
0x0000000127273812ULL, 0x004fe400078efcffULL, 0x0000009f00a37306ULL, 0x000e620000205400ULL,
0x000000019e9e4812ULL, 0x008fc600078efcffULL, 0x000000286c48723cULL, 0x000b620000041848ULL,
0x000000839e9e723eULL, 0x000fc600000010ffULL, 0x0000007e007c7306ULL, 0x000ff00000209400ULL,
0x0000007e007f7306ULL, 0x000ea20000205400ULL, 0x000000a3a000720bULL, 0x002fce0003fdd000ULL,
0x000000a500907306ULL, 0x000ff00000209400ULL, 0x000000a5008b7306ULL, 0x000e620000205400ULL,
0x0000007f7c00720bULL, 0x004fe40003f9d000ULL, 0x000000c7867c723eULL, 0x000fca00000010ffULL,
0x0000009f00a27306ULL, 0x000ea4000020d400ULL, 0x0000007c7054723cULL, 0x080f6c0000041854ULL,
0x0000007e00897306ULL, 0x000ee2000020d400ULL, 0x0000008b9000720bULL, 0x002fe20003f1d000ULL,
0x0000007c6c34723cULL, 0x000f6c0000041834ULL, 0x000000a500887306ULL, 0x000e62000020d400ULL,
0x00000001a2a26812ULL, 0x004fc800078efcffULL, 0x00000027a29f723eULL, 0x000fe200000010ffULL,
0x0000000220277824ULL, 0x000fe200078e00ffULL, 0x0000000189894812ULL, 0x008fc800078efcffULL,
0xfffffff827287812ULL, 0x020fe200078ec0ffULL, 0x0000009e7050723cULL, 0x000f620000041850ULL,
0x000000898282723eULL, 0x000fe400000010ffULL, 0x0000000188880812ULL, 0x002fc800078efcffULL,
0x000000888183723eULL, 0x000fe200000010ffULL, 0x0000009e6c30723cULL, 0x000f700000041830ULL,
0x00000082704c723cULL, 0x080f70000004184cULL, 0x000000826c2c723cULL, 0x000b6e000004182cULL,
0x0001a6c81a6e7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6900028ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff277224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x004fc80000015200ULL, 0x00000400136d7984ULL, 0x000ea40000000800ULL,
0x800000006dff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c28717210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e29ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff6c7819ULL, 0x000fc8000001146dULL,
0x000000716c6c7211ULL, 0x000fca00078110ffULL, 0x000000ffff6d7224ULL, 0x000fca00000e066dULL,
0x000000026c6c7819ULL, 0x000fc8000000126dULL, 0x0000006c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000127277810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400136d7984ULL, 0x000e640000000800ULL,
0x800000006dff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001020287824ULL, 0x000fca00078e00ffULL, 0xffffffe028277812ULL, 0x000fca00078ec0ffULL,
0x0000010016277824ULL, 0x000fca00078e0227ULL, 0x000000c027297810ULL, 0x000fe20007ffe0ffULL,
0x0000590024277a24ULL, 0x010fc600078e02ffULL, 0x0000002029247812ULL, 0x000fe200078ec0ffULL,
0x0000004027737824ULL, 0x000fc800078e00ffULL, 0x0000000119707824ULL, 0x000fe200078e0224ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x000000291e247217ULL, 0x000fe40007800000ULL,
0x0000001028277812ULL, 0x000fe400078ec0ffULL, 0x00000003ff287819ULL, 0x000fe2000001161fULL,
0x0000000124247824ULL, 0x000fc600078e0a29ULL, 0x00000004286d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000128297824ULL, 0x040fe200078e0227ULL, 0x0000002427247217ULL, 0x000fe40007800000ULL,
0x00000008286e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001296c7824ULL, 0x040fe400078e021fULL,
0x00000008296f7824ULL, 0x000fe400078e00ffULL, 0x0000000124247824ULL, 0x000fc600078e0a27ULL,
0xfffffff86f727812ULL, 0x000fe200078ee26cULL, 0x000000016d6c7824ULL, 0x100fe200078e0227ULL,
0x0000000c286f7810ULL, 0x040fe40007ffe0ffULL, 0x000000242800720cULL, 0x080fe20003f86070ULL,
0x0000000129287824ULL, 0x000fe200078e0270ULL, 0x000000246e00720cULL, 0x0c0fe20003f46070ULL,
0x000000016e6e7824ULL, 0x100fe200078e0227ULL, 0x000000246d00720cULL, 0x080fe20003f66070ULL,
0x000000016f797824ULL, 0x040fe200078e0227ULL, 0x000000246f00720cULL, 0x000fe20003f06070ULL,
0x000000016c277824ULL, 0x000fc400078e021fULL, 0x000000086c787824ULL, 0x000fe400078e00ffULL,
0x000000016e6d7824ULL, 0x040fe400078e021fULL, 0x000000086e7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff878247812ULL, 0x000fe200078ee227ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000620073277a11ULL, 0x040fe400078a38ffULL, 0xfffffff87a787812ULL, 0x000fe200078ee26dULL,
0x000000016c6c7824ULL, 0x100fe200078e0270ULL, 0x0000001228287212ULL, 0x000fe200078efcffULL,
0x000000016e6e7824ULL, 0x000fe200078e0270ULL, 0x0000630073737a11ULL, 0x000fe200028f3cffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000002827287210ULL, 0x000fc60007fbe0ffULL,
0x0000000179707824ULL, 0x000fe200078e0270ULL, 0x000000126c6c7212ULL, 0x000fe200078efcffULL,
0x000000806e6e7825ULL, 0x000fc800078e00ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000126e6e7212ULL, 0x000fc600078efcffULL, 0x0000000129297824ULL, 0x000fe200028e0673ULL,
0x000000276c6c7210ULL, 0x080fe20007fbe0ffULL, 0x00000001797a7824ULL, 0x040fe200078e021fULL,
0x0000001270707212ULL, 0x000fe200078efcffULL, 0x0000000879797824ULL, 0x000fe400078e00ffULL,
0x000000016d6d7824ULL, 0x000fe200028e0673ULL, 0x000000276e6e7210ULL, 0x080fe40007fbe0ffULL,
0x0000002770707210ULL, 0x000fe20007fde0ffULL, 0x0000001072277824ULL, 0x000fe200078e0225ULL,
0xfffffff8797a7812ULL, 0x000fe200078ee27aULL, 0x000000016f6f7824ULL, 0x000fc400028e0673ULL,
0x0000000171717824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028277faeULL, 0x0003e2000e101c48ULL, 0x0000001024737824ULL, 0x100fe400078e0225ULL,
0x0000001078797824ULL, 0x100fe400078e0225ULL, 0x000000107a7b7824ULL, 0x000fe200078e0225ULL,
0x000000006c737faeULL, 0x0003e8000d901c48ULL, 0x000000006e797faeULL, 0x0003e8000d101c48ULL,
0x00000000707b7faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001028287812ULL, 0x000fc800078ec0ffULL, 0x000000281f247211ULL, 0x000fc800078fe8ffULL,
0x0000000424297810ULL, 0x040fe20007ffe0ffULL, 0x0000000124277824ULL, 0x040fe200078e021fULL,
0x0000000c246f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000824727824ULL, 0x040fe400078e00ffULL,
0x0000000124287824ULL, 0x100fe400078e0270ULL, 0x00000001296c7824ULL, 0x000fe200078e0270ULL,
0xfffffff872727812ULL, 0x000fe200078ee227ULL, 0x000000086f7a7824ULL, 0x000fe200078e00ffULL,
0x0000000824277810ULL, 0x000fe20007ffe0ffULL, 0x0000000129247824ULL, 0x000fc400078e021fULL,
0x0000000829297824ULL, 0x000fe400078e00ffULL, 0x00000001276e7824ULL, 0x040fe400078e0270ULL,
0x00000001276d7824ULL, 0x100fe200078e021fULL, 0xfffffff829247812ULL, 0x000fe200078ee224ULL,
0x0000000827787824ULL, 0x000fe400078e00ffULL, 0x000000016f277824ULL, 0x000fe400078e021fULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fc400078ee26dULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee227ULL, 0x000000016f707824ULL, 0x000fe200078e0270ULL,
0x0000620073277a11ULL, 0x040fe200078038ffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000001228287212ULL, 0x000fe400078efcffULL, 0x0000630073737a11ULL, 0x000fe200000f3cffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x0000002827287210ULL, 0x000fe40007f1e0ffULL,
0x000000126c6c7212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000126e6e7212ULL, 0x000fc400078efcffULL, 0x0000006c276c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000129297824ULL, 0x000fe200000e0673ULL, 0x0000001270707212ULL, 0x000fe200078efcffULL,
0x0000001078797824ULL, 0x000fe200078e0225ULL, 0x0000006e276e7210ULL, 0x000fe20007f1e0ffULL,
0x000000016d6d7824ULL, 0x000fe200010e0673ULL, 0x0000007027707210ULL, 0x000fe20007f7e0ffULL,
0x0000001072277824ULL, 0x000fe400078e0225ULL, 0x000000016f6f7824ULL, 0x100fe400000e0673ULL,
0x0000000171717824ULL, 0x000fe200018e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028277faeULL, 0x0003e2000b901c48ULL, 0x0000001024737824ULL, 0x000fc400078e0225ULL,
0x000000107a7b7824ULL, 0x000fc600078e0225ULL, 0x000000006c737faeULL, 0x0003e8000b901c48ULL,
0x000000006e797faeULL, 0x0003e8000b901c48ULL, 0x00000000707b7faeULL, 0x0003e4000b901c48ULL,
0x0000000820277824ULL, 0x002fe200078e00ffULL, 0x0000000318287810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff247424ULL, 0x000fc600078e00ffULL, 0xfffffff027277812ULL, 0x000fe400078ec0ffULL,
0x0000001d2800720cULL, 0x000fe40003f06070ULL, 0x00000000270473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000117288824ULL, 0x000fc400078e0228ULL,
0x00000004ff298424ULL, 0x000fc800078e00ffULL, 0x0000640028288625ULL, 0x000fca00078e0029ULL,
0x0000000828248981ULL, 0x000522000c1e1900ULL, 0x0001a6b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x01a6b000276e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6480023707f8cULL, 0x000664000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x01a64c0023277984ULL, 0x002e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c286c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e29ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff277819ULL, 0x000fc8000001146dULL, 0x0000006c27277211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000227277819ULL, 0x000fc8000000126cULL,
0x000000270000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a64c0023277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002020237824ULL, 0x008fca00078e00ffULL,
0xffffff8023237812ULL, 0x000fc800078ec0ffULL, 0x0000010012287810ULL, 0x000fca0007ffe023ULL,
0x0000000111287824ULL, 0x000fca00078e0228ULL, 0x01a0000028707984ULL, 0x000e680000000800ULL,
0x01a2000028717984ULL, 0x0006a20000000800ULL, 0x000000217000720bULL, 0x002fe20003f1d000ULL,
0x000131127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000727806ULL, 0x008fc800000e0100ULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff277424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0021ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x000000021b237810ULL, 0x000fe40007ffe0ffULL,
0x000000217000720bULL, 0x000fe40003f54000ULL, 0x000000202300720cULL, 0x000fe20003f05270ULL,
0x000130d27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000737806ULL, 0x000fc400010e0100ULL,
0x0000008020288824ULL, 0x000fe200078e0212ULL, 0x0000002170237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000111288824ULL, 0x000fca00078e0228ULL,
0x01a4002328008388ULL, 0x0003e20000000800ULL, 0x000000ff7300720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000002123217221ULL, 0x002fe20000010100ULL,
0x000000ff73ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b21217820ULL, 0x000fcc0000410000ULL, 0x0000002100217308ULL, 0x000e640000000800ULL,
0x0000002122227220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x000130227f007947ULL, 0x000fea000b800000ULL,
0x00001f2921287589ULL, 0x0002e400000e0000ULL, 0x0000002868687220ULL, 0x08cfe40000410000ULL,
0x0000002869697220ULL, 0x080fe40000410000ULL, 0x0000002864647220ULL, 0x080fe40000410000ULL,
0x0000002865657220ULL, 0x000fc40000410000ULL, 0x0000002860607220ULL, 0x080fe40000410000ULL,
0x0000002861617220ULL, 0x080fe40000410000ULL, 0x000000285c5c7220ULL, 0x080fe40000410000ULL,
0x000000285d5d7220ULL, 0x080fe40000410000ULL, 0x0000002858587220ULL, 0x080fe40000410000ULL,
0x0000002859597220ULL, 0x000fc40000410000ULL, 0x0000002854547220ULL, 0x080fe40000410000ULL,
0x0000002855557220ULL, 0x080fe40000410000ULL, 0x0000002850507220ULL, 0x080fe40000410000ULL,
0x0000002851517220ULL, 0x080fe40000410000ULL, 0x000000284c4c7220ULL, 0x080fe40000410000ULL,
0x000000284d4d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0073ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x002fe200078ff0ffULL,
0x00012f127f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002e400000e0000ULL,
0x000000286a6a7220ULL, 0x08cfe40000410000ULL, 0x000000286b6b7220ULL, 0x080fe40000410000ULL,
0x0000002866667220ULL, 0x080fe40000410000ULL, 0x0000002867677220ULL, 0x080fe40000410000ULL,
0x0000002862627220ULL, 0x080fe40000410000ULL, 0x0000002863637220ULL, 0x000fc40000410000ULL,
0x000000285e5e7220ULL, 0x080fe40000410000ULL, 0x000000285f5f7220ULL, 0x080fe40000410000ULL,
0x000000285a5a7220ULL, 0x080fe40000410000ULL, 0x000000285b5b7220ULL, 0x080fe40000410000ULL,
0x0000002856567220ULL, 0x080fe40000410000ULL, 0x0000002857577220ULL, 0x000fc40000410000ULL,
0x0000002852527220ULL, 0x080fe40000410000ULL, 0x0000002853537220ULL, 0x080fe40000410000ULL,
0x000000284e4e7220ULL, 0x080fe40000410000ULL, 0x000000284f4f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000073ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x002fe200078ff0ffULL, 0x00012e027f007947ULL, 0x000fea000b800000ULL,
0x00001f2921287589ULL, 0x0002e400000e0000ULL, 0x0000002848487220ULL, 0x08cfe40000410000ULL,
0x0000002849497220ULL, 0x080fe40000410000ULL, 0x0000002844447220ULL, 0x080fe40000410000ULL,
0x0000002845457220ULL, 0x080fe40000410000ULL, 0x0000002840407220ULL, 0x080fe40000410000ULL,
0x0000002841417220ULL, 0x000fc40000410000ULL, 0x000000283c3c7220ULL, 0x080fe40000410000ULL,
0x000000283d3d7220ULL, 0x080fe40000410000ULL, 0x0000002838387220ULL, 0x080fe40000410000ULL,
0x0000002839397220ULL, 0x080fe40000410000ULL, 0x0000002834347220ULL, 0x080fe40000410000ULL,
0x0000002835357220ULL, 0x000fc40000410000ULL, 0x0000002830307220ULL, 0x080fe40000410000ULL,
0x0000002831317220ULL, 0x080fe40000410000ULL, 0x000000282c2c7220ULL, 0x080fe40000410000ULL,
0x000000282d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000073ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x002fe200078ff0ffULL, 0x00012d027f007947ULL, 0x000fea000b800000ULL,
0x00001f2921287589ULL, 0x0002e400000e0000ULL, 0x000000284a4a7220ULL, 0x08cfe40000410000ULL,
0x000000284b4b7220ULL, 0x080fe40000410000ULL, 0x0000002846467220ULL, 0x080fe40000410000ULL,
0x0000002847477220ULL, 0x080fe40000410000ULL, 0x0000002842427220ULL, 0x080fe40000410000ULL,
0x0000002843437220ULL, 0x000fc40000410000ULL, 0x000000283e3e7220ULL, 0x080fe40000410000ULL,
0x000000283f3f7220ULL, 0x080fe40000410000ULL, 0x000000283a3a7220ULL, 0x080fe40000410000ULL,
0x000000283b3b7220ULL, 0x080fe40000410000ULL, 0x0000002836367220ULL, 0x080fe40000410000ULL,
0x0000002837377220ULL, 0x000fc40000410000ULL, 0x0000002832327220ULL, 0x080fe40000410000ULL,
0x0000002833337220ULL, 0x080fe40000410000ULL, 0x000000282e2e7220ULL, 0x080fe40000410000ULL,
0x000000282f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007372ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff277424ULL, 0x000fd800078e00ffULL,
0x8000002370700221ULL, 0x000fe20000010000ULL, 0x00007610ff270816ULL, 0x000fc60000000027ULL,
0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL, 0x0000007000100308ULL, 0x000e640000000800ULL,
0x0000001071710220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002271227221ULL, 0x004fc40000010000ULL, 0x0000000000287805ULL, 0x000fca0000015200ULL,
0x0000000820217824ULL, 0x000fca00078e00ffULL, 0xfffffff021707812ULL, 0x000fca00078ec0ffULL,
0x01a6ac0070217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c286c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e29ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc8000001146dULL,
0x0000006c21217211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000221217819ULL, 0x000fc8000000126cULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000171717810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6ac0070217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991027217816ULL, 0x000fc800000000ffULL, 0x000000ff2100720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000010ff0c723eULL, 0x000fe400000010ffULL,
0x00000002ff217819ULL, 0x000fe4000001161fULL, 0x000054100c0c7816ULL, 0x000fe2000000000cULL,
0x000128f27f007947ULL, 0x000fea000b800000ULL, 0x00001f210c0f7589ULL, 0x0002a400000e0000ULL,
0x0000000821297810ULL, 0x000fe20007ffe0ffULL, 0x000129427f007947ULL, 0x000fea000b800000ULL,
0x00000010210d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f290c0e7589ULL, 0x00066a00000e0000ULL,
0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL, 0x0000001821297810ULL, 0x008fe20007ffe0ffULL,
0x000129d27f007947ULL, 0x000fea000b800000ULL, 0x00001f290c0c7589ULL, 0x0022e400000e0000ULL,
0x0000040020217824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100020277824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00021217812ULL, 0x000fc400078ec0ffULL, 0xffffe00027277812ULL, 0x000fe400078ec0ffULL,
0x0001400021217810ULL, 0x000fe40007ffe0ffULL, 0x0001600027277810ULL, 0x000fc60007ffe0ffULL,
0x0000001009097824ULL, 0x100fe400078e0221ULL, 0x0000001008087824ULL, 0x000fe400078e0221ULL,
0x0000001007787824ULL, 0x000fe200078e0227ULL, 0x000000000970783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0022a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707231ULL, 0x08cfe400003400ffULL, 0x0000000f72727231ULL, 0x000fc400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fe400003400ffULL,
0x0000000d28287231ULL, 0x080fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010067c7824ULL, 0x000fe200078e0227ULL,
0x000000007878783bULL, 0x000e620000004200ULL, 0x00000f8000007945ULL, 0x000fe80003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x0000007800087306ULL, 0x002fe20000009400ULL,
0x00000018ff277819ULL, 0x000fe20000011478ULL, 0x0000010078957824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011479ULL, 0x0000010079987824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x008fe2000001147eULL, 0x000001007aa97824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001147bULL, 0x0000007800937306ULL, 0x000e620000005400ULL,
0x00000018ffa37819ULL, 0x000fe2000001147fULL, 0x000001007bac7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe20000011498ULL, 0x000001007cbb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe2000001147aULL, 0x000001007dbe7824ULL, 0x000fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fe2000001147dULL, 0x0000007800947306ULL, 0x0006a2000000d400ULL,
0x00000018ff957819ULL, 0x000fc40000011495ULL, 0x00000018ffa97819ULL, 0x000fe400000114a9ULL,
0x00000018ffb27819ULL, 0x000fe400000114acULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x00000027009a7306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x008fe200078e00ffULL,
0x000000930800720bULL, 0x002fe20003f7d000ULL, 0x000001007e087824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fe400000114beULL, 0x00000018ff787819ULL, 0x000fc40000011478ULL,
0x00000027009d7306ULL, 0x000fe20000205400ULL, 0x00000018ff087819ULL, 0x000fcc0000011408ULL,
0x0000000194943812ULL, 0x004fe200078efcffULL, 0x00000027006c7306ULL, 0x0003f0000020d400ULL,
0x0000008200a57306ULL, 0x000fe20000209400ULL, 0x00000018ff277819ULL, 0x002fce000001147cULL,
0x0000008200a87306ULL, 0x000ff00000205400ULL, 0x00000082006d7306ULL, 0x000ff0000020d400ULL,
0x0000009b00897306ULL, 0x000ff00000209400ULL, 0x0000009b008c7306ULL, 0x000ff00000205400ULL,
0x0000009b00827306ULL, 0x000ff0000020d400ULL, 0x0000008a00b77306ULL, 0x000ff00000209400ULL,
0x0000008a00ba7306ULL, 0x000ff00000205400ULL, 0x0000008a00877306ULL, 0x000ff0000020d400ULL,
0x0000002700c07306ULL, 0x000ff00000209400ULL, 0x0000002700c17306ULL, 0x000ff00000205400ULL,
0x0000002700857306ULL, 0x000ff0000020d400ULL, 0x0000007800987306ULL, 0x000ff00000209400ULL,
0x00000078009b7306ULL, 0x000e700000205400ULL, 0x000000a3008d7306ULL, 0x000ff00000209400ULL,
0x000000a3008a7306ULL, 0x000fe20000205400ULL, 0x0000009b9800720bULL, 0x002fce0003fdd000ULL,
0x000000a300277306ULL, 0x0003f0000020d400ULL, 0x0000008300ae7306ULL, 0x000fe20000209400ULL,
0x0001000079a37824ULL, 0x002fca00078e00ffULL, 0x00000018ffa37819ULL, 0x000fe400000114a3ULL,
0x0000008300af7306ULL, 0x000ff00000205400ULL, 0x00000083008f7306ULL, 0x000ff0000020d400ULL,
0x0000009600917306ULL, 0x000ff00000209400ULL, 0x0000009600927306ULL, 0x000ff00000205400ULL,
0x0000009600837306ULL, 0x000ff0000020d400ULL, 0x0000009500967306ULL, 0x000ff00000209400ULL,
0x0000009500977306ULL, 0x000e700000205400ULL, 0x0000009500997306ULL, 0x000eb0000020d400ULL,
0x0000009e00a07306ULL, 0x000fe20000209400ULL, 0x000000979600720bULL, 0x002fce0003f5d000ULL,
0x0000009e00a17306ULL, 0x000e6c0000205400ULL, 0x0000000199992812ULL, 0x004fe400078efcffULL,
0x000000a300957306ULL, 0x000fe20000209400ULL, 0x0000009d9a00720bULL, 0x000fce0003f5d000ULL,
0x000000a300a47306ULL, 0x000ea20000205400ULL, 0x000000a1a000720bULL, 0x002fca0003fbd000ULL,
0x000000016c6c2812ULL, 0x000fe400078efcffULL, 0x00000079009c7306ULL, 0x000ff00000009400ULL,
0x00000079009f7306ULL, 0x000e620000005400ULL, 0x000000a49500720bULL, 0x004fce0003f7d000ULL,
0x0000007900097306ULL, 0x000eb0000000d400ULL, 0x0000009e00a27306ULL, 0x000ee2000020d400ULL,
0x0000009f9c00720bULL, 0x002fce0003f9d000ULL, 0x0000007800797306ULL, 0x000e6c000020d400ULL,
0x0000000109094812ULL, 0x004fe400078efcffULL, 0x000000a9009e7306ULL, 0x000fe20000209400ULL,
0x00000001a2a25812ULL, 0x008fe400078efcffULL, 0x000000a8a500720bULL, 0x000fc40003f9d000ULL,
0x00000009a209723eULL, 0x000fc600000010ffULL, 0x000000a900ab7306ULL, 0x000ea20000205400ULL,
0x0000000179796812ULL, 0x002fc800078efcffULL, 0x000000796c6c723eULL, 0x000fc600000010ffULL,
0x000000a300a67306ULL, 0x000e62000020d400ULL, 0x000000016d6d4812ULL, 0x000fce00078efcffULL,
0x0000007a00a77306ULL, 0x000fe20000009400ULL, 0x000000ab9e00720bULL, 0x004fce0003fdd000ULL,
0x0000007a00aa7306ULL, 0x000ea20000005400ULL, 0x00000001a6a63812ULL, 0x002fc800078efcffULL,
0x000000a66d6d723eULL, 0x000fc600000010ffULL, 0x0000007b00b07306ULL, 0x000fe80000009400ULL,
0x0000006c7064723cULL, 0x000f680000041864ULL, 0x0000007b00b17306ULL, 0x000e620000005400ULL,
0x000000aaa700720bULL, 0x004fc60003fbd000ULL, 0x0000006c2844723cULL, 0x000f680000041844ULL,
0x000000a900ad7306ULL, 0x000eb0000020d400ULL, 0x0000007b008e7306ULL, 0x0006a2000000d400ULL,
0x000000b1b000720bULL, 0x002fce0003f7d000ULL, 0x0000007a00907306ULL, 0x000262000000d400ULL,
0x000100007b7b7824ULL, 0x008fe200078e00ffULL, 0x00000001adad6812ULL, 0x004fe400078efcffULL,
0x000000afae00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000b200b37306ULL, 0x000fe20000209400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x000000018e8e3812ULL, 0x000fc800078efcffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x000000b200b47306ULL, 0x000e620000205400ULL, 0x0000000190905812ULL, 0x000fe400078efcffULL,
0x000000018f8f6812ULL, 0x000fca00078efcffULL, 0x000000b200b57306ULL, 0x000eb0000020d400ULL,
0x0000007b00a97306ULL, 0x000fe20000209400ULL, 0x000000b4b300720bULL, 0x002fce0003f5d000ULL,
0x0000007b00b67306ULL, 0x000e6c0000205400ULL, 0x00000001b5b52812ULL, 0x004fe400078efcffULL,
0x000000bb00b27306ULL, 0x000fe20000209400ULL, 0x000000bab700720bULL, 0x000fe40003f5d000ULL,
0x0000008eb579723eULL, 0x000fca00000010ffULL, 0x000000bb00bd7306ULL, 0x000ea20000205400ULL,
0x000000b6a900720bULL, 0x002fca0003fbd000ULL, 0x0000000187872812ULL, 0x000fe400078efcffULL,
0x0000007a00787306ULL, 0x000ff00000209400ULL, 0x0000007a00a37306ULL, 0x000e620000205400ULL,
0x000000bdb200720bULL, 0x004fce0003f7d000ULL, 0x000000c400c57306ULL, 0x000ff00000209400ULL,
0x000000c400c67306ULL, 0x000ea20000205400ULL, 0x000000a37800720bULL, 0x002fe40003f9d000ULL,
0x00000090ad78723eULL, 0x000fca00000010ffULL, 0x0000007c00b97306ULL, 0x000fe40000009400ULL,
0x000000787060723cULL, 0x080f6c0000041860ULL, 0x0000007c00bc7306ULL, 0x000fe20000005400ULL,
0x000000c6c500720bULL, 0x004fe20003fdd000ULL, 0x000000782840723cULL, 0x000b6c0000041840ULL,
0x0000007c00867306ULL, 0x0003e2000000d400ULL, 0x0000001002787824ULL, 0x020fce00078e0203ULL,
0x0000007d00c27306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00c37306ULL, 0x000ff00000005400ULL,
0x0000007d00847306ULL, 0x0003f0000000d400ULL, 0x0000007a00ac7306ULL, 0x000ea2000020d400ULL,
0x000100007d7d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007b00b87306ULL, 0x000e70000020d400ULL, 0x000000bb00bf7306ULL, 0x000ee2000020d400ULL,
0x00000001acac4812ULL, 0x004fc400078efcffULL, 0x000000bcb900720bULL, 0x000fca0003f9d000ULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x00000001b8b85812ULL, 0x002fe400078efcffULL,
0x000000c3c200720bULL, 0x000fca0003fbd000ULL, 0x0000007c007b7306ULL, 0x000e620000205400ULL,
0x00000001bfbf3812ULL, 0x008fe400078efcffULL, 0x0000000186864812ULL, 0x000fe400078efcffULL,
0x000000c1c000720bULL, 0x000fe40003f9d000ULL, 0x00000086bf86723eULL, 0x000fe200000010ffULL,
0x000000c400c77306ULL, 0x000ea2000020d400ULL, 0x0000000184845812ULL, 0x000fe400078efcffULL,
0x000000929100720bULL, 0x000fca0003fbd000ULL, 0x0000007d00bb7306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x002fe40003f7d000ULL, 0x000000b8877b723eULL, 0x000fe400000010ffULL,
0x0000000185854812ULL, 0x000fe400078efcffULL, 0x000000ac8f7a723eULL, 0x000fe200000010ffULL,
0x0000007d00c87306ULL, 0x000e620000205400ULL, 0x00000001c7c76812ULL, 0x004fe400078efcffULL,
0x0000000183835812ULL, 0x000fc400078efcffULL, 0x00000084c787723eULL, 0x000fe200000010ffULL,
0x0000007a705c723cULL, 0x040f62000004185cULL, 0x0000008c8900720bULL, 0x000fe20003fbd000ULL,
0x0000007d00967306ULL, 0x0004ec000020d400ULL, 0x000000867058723cULL, 0x000f640000041858ULL,
0x0000007c00be7306ULL, 0x000ee2000020d400ULL, 0x000001007f7d7824ULL, 0x004fe200078e00ffULL,
0x000000c8bb00720bULL, 0x002fc40003fdd000ULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x00000018ff957819ULL, 0x000fe2000001147dULL, 0x0000007a283c723cULL, 0x040f62000004183cULL,
0x00000008007c7306ULL, 0x000fee0000209400ULL, 0x0000000196966812ULL, 0x008fe200078efcffULL,
0x0000000800937306ULL, 0x000e620000205400ULL, 0x00000001bebe3812ULL, 0x000fe200078efcffULL,
0x000000862838723cULL, 0x000f620000041838ULL, 0x0000009683bf723eULL, 0x000fc400000010ffULL,
0x000000be85be723eULL, 0x000fc600000010ffULL, 0x0000007e00c97306ULL, 0x000fe80000009400ULL,
0x000000be7054723cULL, 0x000f680000041854ULL, 0x0000007e00ca7306ULL, 0x000ea20000005400ULL,
0x000000937c00720bULL, 0x002fc60003f7d000ULL, 0x000000be2834723cULL, 0x000f680000041834ULL,
0x0000009500977306ULL, 0x000ff00000209400ULL, 0x00000095009a7306ULL, 0x000e620000205400ULL,
0x000000cac900720bULL, 0x004fce0003f5d000ULL, 0x0000007e00817306ULL, 0x0004f0000000d400ULL,
0x0000007f00887306ULL, 0x000fe20000009400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x0000009a9700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f008b7306ULL, 0x000e620000005400ULL, 0x0000000181812812ULL, 0x008fce00078efcffULL,
0x0000007f00067306ULL, 0x0004f0000000d400ULL, 0x00000095009b7306ULL, 0x0006e2000020d400ULL,
0x000100007f7f7824ULL, 0x004fe200078e00ffULL, 0x0000008b8800720bULL, 0x002fcc0003f9d000ULL,
0x0000000800987306ULL, 0x0002a2000020d400ULL, 0x00000018ff957819ULL, 0x008fcc000001147fULL,
0x0000000106064812ULL, 0x000fe200078efcffULL, 0x0000007e007d7306ULL, 0x000fe20000209400ULL,
0x000000949908723eULL, 0x002fe400000010ffULL, 0x000000019b9b6812ULL, 0x000fc800078efcffULL,
0x000000069b99723eULL, 0x000fe200000010ffULL, 0x0000007e00947306ULL, 0x000e620000205400ULL,
0x0000000198983812ULL, 0x004fe200078efcffULL, 0x000000087068723cULL, 0x000f620000041868ULL,
0x0000008a8d00720bULL, 0x000fe40003f7d000ULL, 0x000000819898723eULL, 0x000fc600000010ffULL,
0x0000009500917306ULL, 0x000fe40000209400ULL, 0x000000082848723cULL, 0x000f6c0000041848ULL,
0x00000095007c7306ULL, 0x000ea20000205400ULL, 0x000000947d00720bULL, 0x002fe20003f5d000ULL,
0x000000987050723cULL, 0x000f620000041850ULL, 0x0000000127273812ULL, 0x000fca00078efcffULL,
0x0000007e007f7306ULL, 0x000e64000020d400ULL, 0x000000982830723cULL, 0x000f6c0000041830ULL,
0x0000009500847306ULL, 0x000ee2000020d400ULL, 0x0000007c9100720bULL, 0x004fe40003fdd000ULL,
0x000000017f7f2812ULL, 0x002fc800078efcffULL, 0x0000007f8282723eULL, 0x000fce00000010ffULL,
0x0000000184846812ULL, 0x008fc800078efcffULL, 0x000000842783723eULL, 0x000fce00000010ffULL,
0x00000082704c723cULL, 0x080b6e000004184cULL, 0x0000001005707824ULL, 0x120fe200078e0221ULL,
0x000000822828723cULL, 0x000b62000004182cULL, 0x0000001004217824ULL, 0x000fc800078e0221ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x00000000212c783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fd20003800000ULL, 0x0000000f70707231ULL, 0x082fe400003400ffULL,
0x0000000f72727231ULL, 0x000fe400003400ffULL, 0x0000000e71717231ULL, 0x080fe400003400ffULL,
0x0000000e73737231ULL, 0x000fc400003400ffULL, 0x0000000d2c2c7231ULL, 0x088fe400003400ffULL,
0x0000000d2e2e7231ULL, 0x000fe400003400ffULL, 0x0000000c2d2d7231ULL, 0x080fe400003400ffULL,
0x0000000c2f2f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010007c7824ULL, 0x000fe200078e0203ULL, 0x000000007878783bULL, 0x000eaa0000004200ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x0000007800087306ULL, 0x004fe20000009400ULL,
0x00000018ff027819ULL, 0x000fe20000011478ULL, 0x00000100788e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011479ULL, 0x0000010079927824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x008fe2000001147eULL, 0x000001007bac7824ULL, 0x040fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe2000001147aULL, 0x0000007800097306ULL, 0x000ea20000005400ULL,
0x00000018ff8f7819ULL, 0x000fe2000001147dULL, 0x000001007aa57824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011492ULL, 0x000100007baf7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001148eULL, 0x000001007cb77824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe2000001147bULL, 0x00000078006c7306ULL, 0x000662000000d400ULL,
0x00000018ff9d7819ULL, 0x000fe2000001147fULL, 0x000001007dbe7824ULL, 0x040fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x000001007ec57824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x000100007dc17824ULL, 0x000fe200078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000002100a17306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x000000090800720bULL, 0x004fe20003fdd000ULL,
0x000001007f087824ULL, 0x000fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fc400000114b7ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000002100a27306ULL, 0x000fe20000205400ULL,
0x00000018ffbe7819ULL, 0x000fe400000114beULL, 0x00000018ffc57819ULL, 0x000fe400000114c5ULL,
0x00000018ffc17819ULL, 0x000fe400000114c1ULL, 0x000000016c6c6812ULL, 0x002fe200078efcffULL,
0x00000021006d7306ULL, 0x000fe2000020d400ULL, 0x00000018ff087819ULL, 0x000fce0000011408ULL,
0x00000093008a7306ULL, 0x000ff00000209400ULL, 0x00000093008b7306ULL, 0x000ff00000205400ULL,
0x0000009300217306ULL, 0x000ff0000020d400ULL, 0x0000000200947306ULL, 0x000ff00000209400ULL,
0x0000000200957306ULL, 0x000ff00000205400ULL, 0x0000000200967306ULL, 0x0003f0000020d400ULL,
0x0000007800927306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x002fce000001147cULL,
0x0000007800937306ULL, 0x000e700000205400ULL, 0x0000002700a87306ULL, 0x000ff00000209400ULL,
0x0000002700a97306ULL, 0x000fe20000205400ULL, 0x000000939200720bULL, 0x002fe20003f9d000ULL,
0x000100007f927824ULL, 0x000fca00078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011492ULL,
0x0000002700887306ULL, 0x000ff0000020d400ULL, 0x0000008f008c7306ULL, 0x000ff00000209400ULL,
0x0000008f008d7306ULL, 0x000ff00000205400ULL, 0x0000008f00277306ULL, 0x000ff0000020d400ULL,
0x0000007900977306ULL, 0x000ff00000009400ULL, 0x0000007900987306ULL, 0x000e700000005400ULL,
0x0000008e008f7306ULL, 0x000ff00000209400ULL, 0x0000008e00907306ULL, 0x000ea20000205400ULL,
0x000000989700720bULL, 0x002fce0003f5d000ULL, 0x0000008500b37306ULL, 0x000ff00000209400ULL,
0x0000008500b47306ULL, 0x000fe20000205400ULL, 0x000000908f00720bULL, 0x004fce0003fbd000ULL,
0x0000008500847306ULL, 0x000ff0000020d400ULL, 0x0000000200ba7306ULL, 0x000ff00000209400ULL,
0x0000000200bb7306ULL, 0x000ff00000205400ULL, 0x0000000200827306ULL, 0x000ff0000020d400ULL,
0x0000009d00857306ULL, 0x000ff00000209400ULL, 0x0000009d00867306ULL, 0x000ff00000205400ULL,
0x0000009d00027306ULL, 0x0003f0000020d400ULL, 0x0000007900997306ULL, 0x000ea2000000d400ULL,
0x00010000799d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe4000001149dULL,
0x0000007800797306ULL, 0x000e70000020d400ULL, 0x000000ac00ad7306ULL, 0x000fe20000209400ULL,
0x0000000199992812ULL, 0x004fce00078efcffULL, 0x000000ac00ae7306ULL, 0x000ea20000205400ULL,
0x0000000179794812ULL, 0x002fce00078efcffULL, 0x0000008e00917306ULL, 0x000e70000020d400ULL,
0x0000009a009b7306ULL, 0x000fe20000209400ULL, 0x000000aead00720bULL, 0x004fce0003f9d000ULL,
0x0000009a009c7306ULL, 0x000ea20000205400ULL, 0x0000000191915812ULL, 0x002fe400078efcffULL,
0x000000959400720bULL, 0x000fca0003fbd000ULL, 0x0000009a009e7306ULL, 0x000e70000020d400ULL,
0x0000009d008e7306ULL, 0x000fe20000209400ULL, 0x0000009c9b00720bULL, 0x004fe40003f1d000ULL,
0x0000000196965812ULL, 0x000fca00078efcffULL, 0x0000009d009f7306ULL, 0x000eac0000205400ULL,
0x000000019e9e0812ULL, 0x002fe400078efcffULL, 0x000000a5009a7306ULL, 0x000fe20000209400ULL,
0x000000a2a100720bULL, 0x000fe40003f1d000ULL, 0x000000999e09723eULL, 0x000fca00000010ffULL,
0x000000a500a77306ULL, 0x000e620000205400ULL, 0x0000009f8e00720bULL, 0x004fca0003fdd000ULL,
0x000000016d6d0812ULL, 0x000fe400078efcffULL, 0x0000007a00a37306ULL, 0x000fe20000009400ULL,
0x000000a9a800720bULL, 0x000fce0003f1d000ULL, 0x0000007a00a47306ULL, 0x000ea20000005400ULL,
0x000000a79a00720bULL, 0x002fca0003f5d000ULL, 0x0000000188880812ULL, 0x000fe400078efcffULL,
0x0000007a00897306ULL, 0x0002f0000000d400ULL, 0x000000ac00b07306ULL, 0x000ee2000020d400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x000000a4a300720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007c00b57306ULL, 0x000fee0000009400ULL,
0x0000000189893812ULL, 0x008fe200078efcffULL, 0x0000007c00b67306ULL, 0x000e620000005400ULL,
0x00000001b0b04812ULL, 0x000fc400078efcffULL, 0x000000b4b300720bULL, 0x000fca0003f7d000ULL,
0x0000009d00a07306ULL, 0x000eb0000020d400ULL, 0x000000a500a67306ULL, 0x000ee2000020d400ULL,
0x000000b6b500720bULL, 0x002fe40003f9d000ULL, 0x0000000184843812ULL, 0x000fca00078efcffULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x00000001a0a06812ULL, 0x004fc800078efcffULL,
0x000000a06d6d723eULL, 0x000fc600000010ffULL, 0x0000007a009d7306ULL, 0x000e620000205400ULL,
0x00000001a6a62812ULL, 0x008fce00078efcffULL, 0x0000007b00aa7306ULL, 0x000ff00000009400ULL,
0x0000007b00ab7306ULL, 0x000ea20000005400ULL, 0x0000009d7800720bULL, 0x002fe40003fdd000ULL,
0x00000089a678723eULL, 0x000fca00000010ffULL, 0x0000007c00837306ULL, 0x0002f0000000d400ULL,
0x000000af00a57306ULL, 0x000fe20000209400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000abaa00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x000000af00b27306ULL, 0x000e620000205400ULL, 0x0000000183834812ULL, 0x008fce00078efcffULL,
0x0000007b00877306ULL, 0x000eb0000000d400ULL, 0x0000007a007b7306ULL, 0x000ee2000020d400ULL,
0x000000b2a500720bULL, 0x002fce0003f5d000ULL, 0x000000af00b17306ULL, 0x000e62000020d400ULL,
0x0000000187875812ULL, 0x004fce00078efcffULL, 0x0000007c007a7306ULL, 0x000fe20000209400ULL,
0x000000017b7b6812ULL, 0x008fc800078efcffULL, 0x0000007b8888723eULL, 0x000fc600000010ffULL,
0x0000007c00af7306ULL, 0x000ea20000205400ULL, 0x00000001b1b12812ULL, 0x002fc800078efcffULL,
0x000000b18489723eULL, 0x000fc600000010ffULL, 0x0000007d00bc7306ULL, 0x000fe80000009400ULL,
0x000000882c3c723cULL, 0x000b68000004183cULL, 0x0000007d00bd7306ULL, 0x000e620000005400ULL,
0x000000af7a00720bULL, 0x004fc60003f9d000ULL, 0x00000088705c723cULL, 0x000b68000004185cULL,
0x000000b700ac7306ULL, 0x000ff00000209400ULL, 0x000000b700b97306ULL, 0x000ea20000205400ULL,
0x000000bdbc00720bULL, 0x002fce0003fdd000ULL, 0x000000be00bf7306ULL, 0x000ff00000209400ULL,
0x000000be00c07306ULL, 0x000e620000205400ULL, 0x000000b9ac00720bULL, 0x004fce0003fbd000ULL,
0x0000007d00817306ULL, 0x000eb0000000d400ULL, 0x0000007c007d7306ULL, 0x000ee2000020d400ULL,
0x000000c0bf00720bULL, 0x002fce0003f5d000ULL, 0x000000c5008f7306ULL, 0x000fe20000209400ULL,
0x0000000181816812ULL, 0x004fe400078efcffULL, 0x0000008d8c00720bULL, 0x000fca0003fdd000ULL,
0x000000c5007c7306ULL, 0x000e620000205400ULL, 0x000000017d7d4812ULL, 0x008fce00078efcffULL,
0x000000b700b87306ULL, 0x000ea2000020d400ULL, 0x0000000127276812ULL, 0x000fce00078efcffULL,
0x000000be00c27306ULL, 0x000ee2000020d400ULL, 0x0000007c8f00720bULL, 0x002fce0003f9d000ULL,
0x0000007e00c37306ULL, 0x000fe20000009400ULL, 0x00000001b8b85812ULL, 0x004fe400078efcffULL,
0x000000bbba00720bULL, 0x000fe40003fbd000ULL, 0x00000083b8b8723eULL, 0x000fc600000010ffULL,
0x0000007e00c87306ULL, 0x000e620000005400ULL, 0x00000001c2c22812ULL, 0x008fc800078efcffULL,
0x00000081c2b9723eULL, 0x000fc600000010ffULL, 0x0000007e00067306ULL, 0x0004e2000000d400ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x0000008b8a00720bULL, 0x000fe20003fbd000ULL,
0x000000b82c38723cULL, 0x000b620000041838ULL, 0x0000007d8282723eULL, 0x000fc600000010ffULL,
0x000000c100b77306ULL, 0x000fe20000209400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x000000c8c300720bULL, 0x002fe40003f1d000ULL, 0x000000b87058723cULL, 0x000b640000041858ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x000000c100c47306ULL, 0x000e620000205400ULL,
0x0000000121215812ULL, 0x000fcc00078efcffULL, 0x0000000106060812ULL, 0x008fe200078efcffULL,
0x0000007f00c77306ULL, 0x000ff00000009400ULL, 0x0000007f00ca7306ULL, 0x000ea20000005400ULL,
0x000000c4b700720bULL, 0x002fce0003f5d000ULL, 0x0000007f00007306ULL, 0x000e70000000d400ULL,
0x000000c500937306ULL, 0x000ee2000020d400ULL, 0x000000cac700720bULL, 0x004fce0003f7d000ULL,
0x0000000800907306ULL, 0x000fec0000209400ULL, 0x0000000100003812ULL, 0x002fe400078efcffULL,
0x0000000800957306ULL, 0x000e620000205400ULL, 0x0000000193934812ULL, 0x008fce00078efcffULL,
0x0000000800977306ULL, 0x0004f0000020d400ULL, 0x0000007e007f7306ULL, 0x000fe20000209400ULL,
0x0000006c9108723eULL, 0x004fe400000010ffULL, 0x00000079966c723eULL, 0x000fc400000010ffULL,
0x00000087b079723eULL, 0x000fe400000010ffULL, 0x000000959000720bULL, 0x002fe20003fdd000ULL,
0x0000007e008e7306ULL, 0x000e620000205400ULL, 0x000000082c48723cULL, 0x040b6e0000041848ULL,
0x000000c100c67306ULL, 0x000ea2000020d400ULL, 0x0000006c2c44723cULL, 0x000b660000041844ULL,
0x0000000197976812ULL, 0x008fc800078efcffULL, 0x00000092007a7306ULL, 0x000fe20000209400ULL,
0x0000008e7f00720bULL, 0x002fe20003f9d000ULL, 0x000000782c40723cULL, 0x000b620000041840ULL,
0x00000000977b723eULL, 0x000fe200000010ffULL, 0x0000000220007824ULL, 0x000fc800078e00ffULL,
0x0000009200877306ULL, 0x000e620000205400ULL, 0x00000001c6c62812ULL, 0x004fe200078efcffULL,
0x000000087068723cULL, 0x040b620000041868ULL, 0x000000868500720bULL, 0x000fe40003f5d000ULL,
0x000000c62783723eULL, 0x000fe400000010ffULL, 0x0001a6c81a277811ULL, 0x000fe200078e18ffULL,
0x0000007e007e7306ULL, 0x000ea4000020d400ULL, 0x0000006c7064723cULL, 0x000b6c0000041864ULL,
0x00000092007f7306ULL, 0x000ee2000020d400ULL, 0x000000877a00720bULL, 0x002fe20003f1d000ULL,
0x000000822c34723cULL, 0x000b620000041834ULL, 0x0000000102022812ULL, 0x000fc400078efcffULL,
0x00000006937a723eULL, 0x000fe400000010ffULL, 0x000000017e7e4812ULL, 0x004fc600078efcffULL,
0x000000787060723cULL, 0x000b620000041860ULL, 0x0000007e217e723eULL, 0x000fc600000010ffULL,
0x000000017f7f0812ULL, 0x008fc800078efcffULL, 0x0000007a2c30723cULL, 0x000b620000041830ULL,
0x0000007f027f723eULL, 0x000fe400000010ffULL, 0xfffffff800027812ULL, 0x000fca00078ec0ffULL,
0x000000827054723cULL, 0x040b700000041854ULL, 0x0000007a7050723cULL, 0x040b700000041850ULL,
0x0000007e704c723cULL, 0x080b70000004184cULL, 0x0000007e2c2c723cULL, 0x000b620000041828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000272a7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6980002ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x0000040027097984ULL, 0x000e620000000800ULL,
0x000000031b027810ULL, 0x008fc40007ffe0ffULL, 0x8000000009ff7812ULL, 0x006fe2000780482bULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e0002ULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000828217210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e29ULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011409ULL, 0x0000002106067211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000206067819ULL, 0x000fc80000001209ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000100007810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000040027097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff097224ULL, 0x000fc400078e0002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000116277810ULL, 0x000fe40007ffe0ffULL,
0x0000000318187810ULL, 0x000fe40007ffe0ffULL, 0x0000001c2700720cULL, 0x000fda0003f06070ULL,
0x0000085000000947ULL, 0x000fea0003800000ULL, 0x0000000216217810ULL, 0x000fe20007ffe0ffULL,
0x0000010027277824ULL, 0x000fe400078e0277ULL, 0x0000590024247a24ULL, 0x010fe200078e02ffULL,
0x0000001c2100720cULL, 0x000fe40003f06070ULL, 0x0000002027007812ULL, 0x000fe200078ec0ffULL,
0x0000004024247824ULL, 0x000fc800078e00ffULL, 0x0000000119707824ULL, 0x000fcc00078e0200ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x000000271e007217ULL, 0x000fe20007800000ULL,
0x0000001020027824ULL, 0x000fc800078e00ffULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000001002217812ULL, 0x000fe400078ec0ffULL, 0x00000003ff027819ULL, 0x000fe4000001161fULL,
0x0000000021007217ULL, 0x000fe40007800000ULL, 0x0000000402067810ULL, 0x040fe40007ffe0ffULL,
0x0000000802087810ULL, 0x000fe20007ffe0ffULL, 0x0000000100007824ULL, 0x100fe200078e0a21ULL,
0x0000000c02277810ULL, 0x000fe20007ffe0ffULL, 0x00000001062a7824ULL, 0x000fc400078e0221ULL,
0x0000000108187824ULL, 0x100fe200078e0221ULL, 0x000000000200720cULL, 0x0c0fe20003f86070ULL,
0x0000000102027824ULL, 0x100fe200078e0221ULL, 0x000000000600720cULL, 0x080fe20003f66070ULL,
0x0000000127217824ULL, 0x040fe200078e0221ULL, 0x000000000800720cULL, 0x080fe20003f46070ULL,
0x0000000102067824ULL, 0x140fe200078e021fULL, 0x000000002700720cULL, 0x000fe20003f06070ULL,
0x0000000802297824ULL, 0x000fe400078e00ffULL, 0x000000012a087824ULL, 0x000fc400078e021fULL,
0x000000082a2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff829067812ULL, 0x000fe200078ee206ULL,
0x0000000102287824ULL, 0x100fe400078e0270ULL, 0x000000012a2a7824ULL, 0x000fe200078e0270ULL,
0xfffffff82b087812ULL, 0x000fe200078ee208ULL, 0x00000001186c7824ULL, 0x100fe400078e0270ULL,
0x0000000121707824ULL, 0x040fe400078e0270ULL, 0x0000000121027824ULL, 0x000fc400078e021fULL,
0x0000000821217824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc800078e00ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001228287212ULL, 0x000fc600078efcffULL,
0x0000000118007824ULL, 0x000fe200078e021fULL, 0x000000122a2a7212ULL, 0x000fe200078efcffULL,
0x0000000818277824ULL, 0x000fe200078e00ffULL, 0xfffffff821187812ULL, 0x000fe200078ee202ULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000620024217a11ULL, 0x000fe400078a38ffULL,
0xfffffff827007812ULL, 0x000fe200078ee200ULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x0000630024277a11ULL, 0x000fe400028f3cffULL, 0x0000002821287210ULL, 0x000fe20007fbe0ffULL,
0x0000001008737824ULL, 0x100fe200078e0203ULL, 0x000000212a2a7210ULL, 0x080fe20007fde0ffULL,
0x0000001000797824ULL, 0x000fe200078e0203ULL, 0x000000126c027212ULL, 0x080fe200078efcffULL,
0x0000000129297824ULL, 0x100fe200028e0627ULL, 0x00000012706c7212ULL, 0x000fe200078efcffULL,
0x000000012b2b7824ULL, 0x000fe200030e0627ULL, 0x0000002102027210ULL, 0x080fe20007fbe0ffULL,
0x00000010187b7824ULL, 0x100fe200078e0203ULL, 0x000000216c6c7210ULL, 0x000fe20007fde0ffULL,
0x0000001006217824ULL, 0x000fc400078e0203ULL, 0x000000016d037824ULL, 0x100fe400028e0627ULL,
0x00000001716d7824ULL, 0x000fe200030e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028217faeULL, 0x0003e8000e101c48ULL, 0x000000002a737faeULL, 0x0003e8000d901c48ULL,
0x0000000002797faeULL, 0x0003e8000d101c48ULL, 0x000000006c7b7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001020007824ULL, 0x000fca00078e00ffULL,
0x0000001000007812ULL, 0x000fc800078ec0ffULL, 0x000000001f007211ULL, 0x000fc800078fe8ffULL,
0x0000000400087810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e021fULL,
0x0000000c00187810ULL, 0x040fe20007ffe0ffULL, 0x0000000800217824ULL, 0x040fe400078e00ffULL,
0x0000000100287824ULL, 0x100fe400078e0270ULL, 0x00000001082a7824ULL, 0x040fe200078e0270ULL,
0xfffffff821067812ULL, 0x000fe200078ee202ULL, 0x0000000808217824ULL, 0x000fe200078e00ffULL,
0x0000000800027810ULL, 0x000fe20007ffe0ffULL, 0x0000000108007824ULL, 0x000fc400078e021fULL,
0x00000008182b7824ULL, 0x000fe400078e00ffULL, 0x00000001026c7824ULL, 0x040fe200078e0270ULL,
0xfffffff821007812ULL, 0x000fe200078ee200ULL, 0x0000000102087824ULL, 0x100fe200078e021fULL,
0x0000620024217a11ULL, 0x000fe200078038ffULL, 0x0000000802277824ULL, 0x000fe400078e00ffULL,
0x0000000118027824ULL, 0x000fe400078e021fULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0xfffffff827087812ULL, 0x000fc400078ee208ULL, 0x0000630024277a11ULL, 0x000fe200000f3cffULL,
0x0000000118707824ULL, 0x000fe200078e0270ULL, 0xfffffff82b187812ULL, 0x000fe200078ee202ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001228287212ULL, 0x000fc600078efcffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000002821287210ULL, 0x000fe40007f1e0ffULL,
0x000000122a027212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000126c2a7212ULL, 0x000fc600078efcffULL, 0x0000000129297824ULL, 0x000fe200000e0627ULL,
0x00000012706c7212ULL, 0x000fe200078efcffULL, 0x0000001000737824ULL, 0x100fe200078e0203ULL,
0x0000000221027210ULL, 0x040fe20007f1e0ffULL, 0x0000001008797824ULL, 0x100fe200078e0203ULL,
0x0000002a212a7210ULL, 0x040fe20007f5e0ffULL, 0x00000010187b7824ULL, 0x100fe200078e0203ULL,
0x0000006c216c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001006217824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fc400000e0627ULL, 0x000000016d2b7824ULL, 0x100fe200010e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028217faeULL, 0x0003e2000b901c48ULL,
0x00000001716d7824ULL, 0x000fc600018e0627ULL, 0x0000000002737faeULL, 0x0003e8000b901c48ULL,
0x000000002a797faeULL, 0x0003e8000b901c48ULL, 0x000000006c7b7faeULL, 0x0003e4000b901c48ULL,
0x0000000414187810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0xffffffffff247424ULL, 0x000fc400078e00ffULL, 0x0000001d1800720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000117027824ULL, 0x002fe400078e0218ULL,
0x00000004ff037424ULL, 0x000fc800078e00ffULL, 0x0000640002027625ULL, 0x000fca00078e0003ULL,
0x0000000802247981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000820027824ULL, 0x002fe400078e00ffULL, 0x000000201b007824ULL, 0x000fc600078e0215ULL,
0xfffffff002037812ULL, 0x040fe400078ec0ffULL, 0x0000000802217812ULL, 0x000fe400078ec0ffULL,
0x00000000030473c2ULL, 0x000e6600000e0000ULL, 0x0000000121067824ULL, 0x000fe400078e0200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0001a6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6a80003027f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a66800062a7f8cULL, 0x0004e2000c80043fULL,
0x000000ffff007224ULL, 0x002fc600078e0003ULL, 0x0000000000027805ULL, 0x000fc80000015200ULL,
0x01a66c0006217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x00afe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002802217210ULL, 0x000fca0007f1e1ffULL,
0x0000000129287824ULL, 0x000fe200000e0e03ULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011428ULL,
0x0000002108087211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0628ULL,
0x0000000208087819ULL, 0x000fc80000001221ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a66c0006217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008009027824ULL, 0x000fc800078e0212ULL, 0x0000000111027824ULL, 0x000fca00078e0202ULL,
0x01a0000002147984ULL, 0x000e680000000800ULL, 0x01a2000002037984ULL, 0x0006a20000000800ULL,
0x000000231400720bULL, 0x002fe20003f1d000ULL, 0x0000fa527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000067806ULL, 0x00cfc800000e0100ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x0000074000007945ULL, 0x000fe20003800000ULL, 0x00000001ff087424ULL, 0x000fe400078e00ffULL,
0x000000ffff027224ULL, 0x000fd200078e0023ULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x000000200900720cULL, 0x000fe40003f05270ULL, 0x000000231400720bULL, 0x000fe20003f54000ULL,
0x0000fa227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x000fc400010e0100ULL,
0x0000008020128824ULL, 0x000fe200078e0212ULL, 0x0000002314027209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000111118824ULL, 0x000fca00078e0212ULL,
0x01a4000211008388ULL, 0x0003e20000000800ULL, 0x000000ff2100720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000002302117221ULL, 0x002fe20000010100ULL,
0x000000ff21ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b11117820ULL, 0x000fcc0000410000ULL, 0x0000001100117308ULL, 0x000e640000000800ULL,
0x0000001122227220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x0000f9727f007947ULL, 0x000fea000b800000ULL,
0x00001f2911287589ULL, 0x0002a400000e0000ULL, 0x0000002868687220ULL, 0x084fe40000410000ULL,
0x0000002869697220ULL, 0x080fe40000410000ULL, 0x0000002864647220ULL, 0x080fe40000410000ULL,
0x0000002865657220ULL, 0x000fc40000410000ULL, 0x0000002860607220ULL, 0x080fe40000410000ULL,
0x0000002861617220ULL, 0x080fe40000410000ULL, 0x000000285c5c7220ULL, 0x080fe40000410000ULL,
0x000000285d5d7220ULL, 0x080fe40000410000ULL, 0x0000002858587220ULL, 0x080fe40000410000ULL,
0x0000002859597220ULL, 0x000fc40000410000ULL, 0x0000002854547220ULL, 0x080fe40000410000ULL,
0x0000002855557220ULL, 0x080fe40000410000ULL, 0x0000002850507220ULL, 0x080fe40000410000ULL,
0x0000002851517220ULL, 0x080fe40000410000ULL, 0x000000284c4c7220ULL, 0x080fe40000410000ULL,
0x000000284d4d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0021ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x002fe200078ff0ffULL,
0x0000f8627f007947ULL, 0x000fea000b800000ULL, 0x00001f2911287589ULL, 0x0002a400000e0000ULL,
0x000000286a6a7220ULL, 0x084fe40000410000ULL, 0x000000286b6b7220ULL, 0x080fe40000410000ULL,
0x0000002866667220ULL, 0x080fe40000410000ULL, 0x0000002867677220ULL, 0x080fe40000410000ULL,
0x0000002862627220ULL, 0x080fe40000410000ULL, 0x0000002863637220ULL, 0x000fc40000410000ULL,
0x000000285e5e7220ULL, 0x080fe40000410000ULL, 0x000000285f5f7220ULL, 0x080fe40000410000ULL,
0x000000285a5a7220ULL, 0x080fe40000410000ULL, 0x000000285b5b7220ULL, 0x080fe40000410000ULL,
0x0000002856567220ULL, 0x080fe40000410000ULL, 0x0000002857577220ULL, 0x000fc40000410000ULL,
0x0000002852527220ULL, 0x080fe40000410000ULL, 0x0000002853537220ULL, 0x080fe40000410000ULL,
0x000000284e4e7220ULL, 0x080fe40000410000ULL, 0x000000284f4f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000021ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x002fe200078ff0ffULL, 0x0000f7527f007947ULL, 0x000fea000b800000ULL,
0x00001f2911287589ULL, 0x0002a400000e0000ULL, 0x0000002848487220ULL, 0x084fe40000410000ULL,
0x0000002849497220ULL, 0x080fe40000410000ULL, 0x0000002844447220ULL, 0x080fe40000410000ULL,
0x0000002845457220ULL, 0x080fe40000410000ULL, 0x0000002840407220ULL, 0x080fe40000410000ULL,
0x0000002841417220ULL, 0x000fc40000410000ULL, 0x000000283c3c7220ULL, 0x080fe40000410000ULL,
0x000000283d3d7220ULL, 0x080fe40000410000ULL, 0x0000002838387220ULL, 0x080fe40000410000ULL,
0x0000002839397220ULL, 0x080fe40000410000ULL, 0x0000002834347220ULL, 0x080fe40000410000ULL,
0x0000002835357220ULL, 0x000fc40000410000ULL, 0x0000002830307220ULL, 0x080fe40000410000ULL,
0x0000002831317220ULL, 0x080fe40000410000ULL, 0x000000282c2c7220ULL, 0x080fe40000410000ULL,
0x000000282d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000021ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x002fe200078ff0ffULL, 0x0000f6527f007947ULL, 0x000fea000b800000ULL,
0x00001f2911287589ULL, 0x0002a400000e0000ULL, 0x000000284a4a7220ULL, 0x084fe40000410000ULL,
0x000000284b4b7220ULL, 0x080fe40000410000ULL, 0x0000002846467220ULL, 0x080fe40000410000ULL,
0x0000002847477220ULL, 0x080fe40000410000ULL, 0x0000002842427220ULL, 0x080fe40000410000ULL,
0x0000002843437220ULL, 0x000fc40000410000ULL, 0x000000283e3e7220ULL, 0x080fe40000410000ULL,
0x000000283f3f7220ULL, 0x080fe40000410000ULL, 0x000000283a3a7220ULL, 0x080fe40000410000ULL,
0x000000283b3b7220ULL, 0x080fe40000410000ULL, 0x0000002836367220ULL, 0x080fe40000410000ULL,
0x0000002837377220ULL, 0x000fc40000410000ULL, 0x0000002832327220ULL, 0x080fe40000410000ULL,
0x0000002833337220ULL, 0x080fe40000410000ULL, 0x000000282e2e7220ULL, 0x080fe40000410000ULL,
0x000000282f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002106ff7212ULL, 0x000fda00078030ffULL, 0x0000001402060221ULL, 0x000fe20000010100ULL,
0x00007610ff080816ULL, 0x000fc60000000008ULL, 0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL,
0x0000000600100308ULL, 0x000e640000000800ULL, 0x0000001003030220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002203227221ULL, 0x000fe20000010000ULL,
0x000000011a037812ULL, 0x000fc400078ec0ffULL, 0x0000000000287805ULL, 0x000fca0000015200ULL,
0x0000000820067824ULL, 0x000fca00078e00ffULL, 0xfffffff006127812ULL, 0x000fca00078ec0ffULL,
0x01a6b40012117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28117210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc8000001142aULL,
0x0000001106067211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e062aULL,
0x0000000206067819ULL, 0x000fc80000001211ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b40012117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991008067816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000010ff06723eULL, 0x000fe400000010ffULL, 0x00000002ff117819ULL, 0x000fe4000001161fULL,
0x0000541006067816ULL, 0x000fe20000000006ULL, 0x0000f2327f007947ULL, 0x000fea000b800000ULL,
0x00001f11060f7589ULL, 0x0002a400000e0000ULL, 0x0000000811297810ULL, 0x000fe20007ffe0ffULL,
0x0000f2827f007947ULL, 0x000fea000b800000ULL, 0x00000010110d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f29060e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d060d7589ULL, 0x0006a400000e0000ULL,
0x0000001811297810ULL, 0x008fe20007ffe0ffULL, 0x0000f3127f007947ULL, 0x000fea000b800000ULL,
0x00001f29060c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff067819ULL, 0x00afe2000001161fULL, 0x000000080b117824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000420087824ULL, 0x000fe200078e00ffULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x0000000403037824ULL, 0x000fc400078e0206ULL,
0x000000080a127824ULL, 0x000fe200078e00ffULL, 0x0000000408087812ULL, 0x000fe200078ec0ffULL,
0x000000010b067824ULL, 0x100fe400078e0203ULL, 0x000000010a037824ULL, 0x000fe200078e0203ULL,
0x0000000208087812ULL, 0x000fe200078efcffULL, 0x0000001007707824ULL, 0x000fe200078e0225ULL,
0xfffffff811117812ULL, 0x000fe400078ee206ULL, 0x0001200009067811ULL, 0x000fe400078e60ffULL,
0xfffffff812097812ULL, 0x000fc400078ee203ULL, 0x000000081f037211ULL, 0x000fe200078fe0ffULL,
0x0000001011117824ULL, 0x100fe400078e0206ULL, 0x0000001009097824ULL, 0x000fe400078e0206ULL,
0x000000080b087824ULL, 0x040fe200078e00ffULL, 0x00000000116c783bULL, 0x0002e20000000200ULL,
0x000000010b0b7824ULL, 0x000fc600078e0203ULL, 0x000000000928783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7231ULL, 0x08cfe400003400ffULL,
0x0000000f6e6e7231ULL, 0x000fe400003400ffULL, 0x0000000e6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000e6f6f7231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x080fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fc400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff808087812ULL, 0x000fe200078ee20bULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x0000001004047824ULL, 0x000fe200078e0206ULL, 0x00000fa000007945ULL, 0x000fe20003800000ULL,
0x000000010a037824ULL, 0x000fe400078e0203ULL, 0x0000001008087824ULL, 0x000fca00078e0225ULL,
0x000000000878783bULL, 0x0002e40000004200ULL, 0x00000018ff087819ULL, 0x002fe20000011470ULL,
0x0000007000857306ULL, 0x000fe20000009400ULL, 0x0000010070887824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011473ULL, 0x00000100718b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe20000011471ULL, 0x0000010072a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe20000011472ULL, 0x0000010073a47824ULL, 0x000fe200078e00ffULL,
0x0000007000867306ULL, 0x000e620000005400ULL, 0x00000018ff8e7819ULL, 0x008fe2000001147bULL,
0x0000010078b17824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe2000001148bULL,
0x0000010079b37824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fc40000011479ULL,
0x00000018ff887819ULL, 0x000fe20000011488ULL, 0x0000007000877306ULL, 0x0006a2000000d400ULL,
0x00000018ff8d7819ULL, 0x000fe4000001147aULL, 0x00000018ffa07819ULL, 0x000fe400000114a0ULL,
0x00000018ffa77819ULL, 0x000fe400000114a4ULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x00000008008f7306ULL, 0x000fe20000209400ULL, 0x0001000070707824ULL, 0x008fe200078e00ffULL,
0x000000868500720bULL, 0x002fe20003f7d000ULL, 0x000001007a867824ULL, 0x000fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fc400000114b3ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000000800907306ULL, 0x000fe20000205400ULL, 0x00000018ff867819ULL, 0x000fcc0000011486ULL,
0x0000000187873812ULL, 0x004fe200078efcffULL, 0x0000000800927306ULL, 0x0003f0000020d400ULL,
0x0000007100917306ULL, 0x000fe20000009400ULL, 0x00000018ff087819ULL, 0x002fce0000011478ULL,
0x0000007100947306ULL, 0x000e700000005400ULL, 0x0000007d00ad7306ULL, 0x000ff00000209400ULL,
0x0000007d00b07306ULL, 0x000fe20000205400ULL, 0x000000949100720bULL, 0x002fce0003f9d000ULL,
0x0000007d00237306ULL, 0x000ff0000020d400ULL, 0x0000000800b57306ULL, 0x000ff00000209400ULL,
0x0000000800b87306ULL, 0x000ff00000205400ULL, 0x0000000800147306ULL, 0x000ff0000020d400ULL,
0x0000008e00827306ULL, 0x000ff00000209400ULL, 0x0000008e007d7306ULL, 0x000ff00000205400ULL,
0x0000008e00087306ULL, 0x000ff0000020d400ULL, 0x0000007100937306ULL, 0x0002b0000000d400ULL,
0x00000070008b7306ULL, 0x000fe20000209400ULL, 0x0001000071717824ULL, 0x002fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x00000070008e7306ULL, 0x000e620000205400ULL,
0x0000000193934812ULL, 0x004fce00078efcffULL, 0x0000001200a37306ULL, 0x000ff00000209400ULL,
0x0000001200a67306ULL, 0x000fe20000205400ULL, 0x0000008e8b00720bULL, 0x002fce0003fdd000ULL,
0x0000001200837306ULL, 0x000ff0000020d400ULL, 0x0000008900bd7306ULL, 0x000ff00000209400ULL,
0x0000008900c27306ULL, 0x000ff00000205400ULL, 0x0000008900127306ULL, 0x000ff0000020d400ULL,
0x0000008800897306ULL, 0x000ff00000209400ULL, 0x00000088008a7306ULL, 0x000e700000205400ULL,
0x00000088008c7306ULL, 0x000eb0000020d400ULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x0000008a8900720bULL, 0x002fce0003f5d000ULL, 0x0000009500977306ULL, 0x000e6c0000205400ULL,
0x000000018c8c2812ULL, 0x004fe400078efcffULL, 0x0000007100887306ULL, 0x000fe20000209400ULL,
0x000000908f00720bULL, 0x000fe20003f5d000ULL, 0x000100007b8f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0000007100997306ULL, 0x000ea20000205400ULL,
0x000000979600720bULL, 0x002fca0003fbd000ULL, 0x0000000192922812ULL, 0x000fe400078efcffULL,
0x0000000b009b7306ULL, 0x000ff00000209400ULL, 0x0000000b009c7306ULL, 0x000e620000205400ULL,
0x000000998800720bULL, 0x004fce0003f7d000ULL, 0x0000000b009d7306ULL, 0x000eb0000020d400ULL,
0x0000008d007c7306ULL, 0x000fe20000209400ULL, 0x0000009c9b00720bULL, 0x002fce0003f9d000ULL,
0x0000008d007f7306ULL, 0x000fec0000205400ULL, 0x000000019d9d4812ULL, 0x004fe400078efcffULL,
0x0000008d000b7306ULL, 0x000ff0000020d400ULL, 0x0000009500987306ULL, 0x000e70000020d400ULL,
0x00000070008d7306ULL, 0x000eb0000020d400ULL, 0x000000a000957306ULL, 0x000fe20000209400ULL,
0x0000000198985812ULL, 0x002fce00078efcffULL, 0x000000a000a27306ULL, 0x000e620000205400ULL,
0x000000018d8d6812ULL, 0x004fce00078efcffULL, 0x00000072009e7306ULL, 0x000ff00000009400ULL,
0x00000072009f7306ULL, 0x000ea20000005400ULL, 0x000000a29500720bULL, 0x002fce0003fdd000ULL,
0x0000007200847306ULL, 0x0002f0000000d400ULL, 0x00000071009a7306ULL, 0x000ee2000020d400ULL,
0x0001000072727824ULL, 0x002fe200078e00ffULL, 0x0000009f9e00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000007300a57306ULL, 0x000fee0000009400ULL,
0x0000000184845812ULL, 0x008fe200078efcffULL, 0x0000007300a87306ULL, 0x000e620000005400ULL,
0x000000019a9a3812ULL, 0x000fce00078efcffULL, 0x0000007200707306ULL, 0x000ff00000209400ULL,
0x0000007200717306ULL, 0x000ea20000205400ULL, 0x000000a8a500720bULL, 0x002fce0003f7d000ULL,
0x000000a000a17306ULL, 0x000e70000020d400ULL, 0x0000007300817306ULL, 0x000662000000d400ULL,
0x000000717000720bULL, 0x004fe40003f9d000ULL, 0x000000878c70723eULL, 0x000fc400000010ffULL,
0x000000939871723eULL, 0x000fc600000010ffULL, 0x000000a700a97306ULL, 0x000fe20000209400ULL,
0x0001000073737824ULL, 0x008fe200078e00ffULL, 0x00000001a1a16812ULL, 0x002fe400078efcffULL,
0x000000a6a300720bULL, 0x000fe20003fdd000ULL, 0x000000706c68723cULL, 0x000b620000041868ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x000000a700aa7306ULL, 0x000e620000205400ULL,
0x0000000181813812ULL, 0x000fc800078efcffULL, 0x000000702848723cULL, 0x000b660000041848ULL,
0x000000a700ac7306ULL, 0x000ea2000020d400ULL, 0x0000000183836812ULL, 0x000fce00078efcffULL,
0x0000007200a47306ULL, 0x000ee2000020d400ULL, 0x000000aaa900720bULL, 0x002fce0003f5d000ULL,
0x0000007300a07306ULL, 0x000fec0000209400ULL, 0x00000001acac2812ULL, 0x004fe400078efcffULL,
0x0000007300ab7306ULL, 0x000e620000205400ULL, 0x00000001a4a44812ULL, 0x008fe400078efcffULL,
0x000000b0ad00720bULL, 0x000fc40003f5d000ULL, 0x000000a483a4723eULL, 0x000fc600000010ffULL,
0x000000b100a77306ULL, 0x000ff00000209400ULL, 0x000000b100b47306ULL, 0x000ea20000205400ULL,
0x000000aba000720bULL, 0x002fe40003fbd000ULL, 0x0000000123232812ULL, 0x000fca00078efcffULL,
0x0000007800af7306ULL, 0x000ff00000009400ULL, 0x0000007800b27306ULL, 0x000e620000005400ULL,
0x000000b4a700720bULL, 0x004fce0003f7d000ULL, 0x0000007800217306ULL, 0x0004f0000000d400ULL,
0x000000b900bb7306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x004fe200078e00ffULL,
0x000000b2af00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x000000b900bc7306ULL, 0x000e6e0000205400ULL, 0x0000000121214812ULL, 0x008fe200078efcffULL,
0x0000007900b77306ULL, 0x000fe20000009400ULL, 0x000000b8b500720bULL, 0x000fce0003f9d000ULL,
0x0000007900ba7306ULL, 0x000fe20000005400ULL, 0x000000bcbb00720bULL, 0x002fca0003fdd000ULL,
0x0000000114144812ULL, 0x000fe400078efcffULL, 0x0000007900117306ULL, 0x0003f0000000d400ULL,
0x0000007300ae7306ULL, 0x000ea2000020d400ULL, 0x0001000079797824ULL, 0x002fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x000000b100b67306ULL, 0x000e70000020d400ULL,
0x0000007800727306ULL, 0x000fe20000209400ULL, 0x00000001aeae5812ULL, 0x004fc400078efcffULL,
0x000000bab700720bULL, 0x000fe40003fbd000ULL, 0x000000ae23a5723eULL, 0x000fc600000010ffULL,
0x0000007800737306ULL, 0x000ea20000205400ULL, 0x00000001b6b63812ULL, 0x002fc600078efcffULL,
0x000000a46c5c723cULL, 0x000b62000004185cULL, 0x00000021b6b6723eULL, 0x000fc600000010ffULL,
0x000000b900be7306ULL, 0x000e62000020d400ULL, 0x0000000111115812ULL, 0x000fe400078efcffULL,
0x000000c2bd00720bULL, 0x000fe20003fbd000ULL, 0x000000a4283c723cULL, 0x000b68000004183cULL,
0x0000007900b17306ULL, 0x000fe20000209400ULL, 0x000000737200720bULL, 0x004fe40003f7d000ULL,
0x0000008d9272723eULL, 0x000fc400000010ffULL, 0x0000009a9d73723eULL, 0x000fc600000010ffULL,
0x0000007900c07306ULL, 0x000ea20000205400ULL, 0x00000001bebe6812ULL, 0x002fe400078efcffULL,
0x0000000112125812ULL, 0x000fe200078efcffULL, 0x000000726c64723cULL, 0x080b620000041864ULL,
0x0000007f7c00720bULL, 0x000fe40003fbd000ULL, 0x00000011beb7723eULL, 0x000fe200000010ffULL,
0x0000007900857306ULL, 0x0002e8000020d400ULL, 0x000000722844723cULL, 0x000b680000041844ULL,
0x0000007800b37306ULL, 0x000ee2000020d400ULL, 0x000001007b797824ULL, 0x002fe200078e00ffULL,
0x000000c0b100720bULL, 0x004fc40003fdd000ULL, 0x000000010b0b5812ULL, 0x000fe200078efcffULL,
0x000000b66c58723cULL, 0x080b620000041858ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008600787306ULL, 0x000fea0000209400ULL, 0x000000b62838723cULL, 0x000b640000041838ULL,
0x0000000185856812ULL, 0x008fe200078efcffULL, 0x0000008600897306ULL, 0x000e620000205400ULL,
0x00000001b3b33812ULL, 0x000fce00078efcffULL, 0x0000007b00277306ULL, 0x000ff00000009400ULL,
0x0000007b007e7306ULL, 0x000ea20000005400ULL, 0x000000897800720bULL, 0x002fe40003f7d000ULL,
0x00000084a178723eULL, 0x000fca00000010ffULL, 0x0000007a00bf7306ULL, 0x000ff00000009400ULL,
0x0000007a00c47306ULL, 0x000e620000005400ULL, 0x0000007e2700720bULL, 0x004fce0003f9d000ULL,
0x00000079008a7306ULL, 0x000ff00000209400ULL, 0x00000079008b7306ULL, 0x000ea20000205400ULL,
0x000000c4bf00720bULL, 0x002fce0003f5d000ULL, 0x0000007a00097306ULL, 0x0002f0000000d400ULL,
0x0000008600887306ULL, 0x000ee2000020d400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x0000008b8a00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007b00077306ULL, 0x000e62000000d400ULL, 0x0000000109092812ULL, 0x008fce00078efcffULL,
0x00000079008e7306ULL, 0x0004e2000020d400ULL, 0x0000000188883812ULL, 0x000fe400078efcffULL,
0x0000007d8200720bULL, 0x000fe40003f7d000ULL, 0x000000098888723eULL, 0x000fc600000010ffULL,
0x0000007a007b7306ULL, 0x000fe20000209400ULL, 0x0000000107074812ULL, 0x002fe400078efcffULL,
0x00000081ac79723eULL, 0x004fca00000010ffULL, 0x0000007a00867306ULL, 0x000e620000205400ULL,
0x000000018e8e6812ULL, 0x008fe200078efcffULL, 0x000000786c60723cULL, 0x000b620000041860ULL,
0x0000000108083812ULL, 0x000fe400078efcffULL, 0x000000078e89723eULL, 0x000fc600000010ffULL,
0x0000008f00877306ULL, 0x000fe40000209400ULL, 0x000000782840723cULL, 0x000b6c0000041840ULL,
0x0000008f007e7306ULL, 0x000ea20000205400ULL, 0x000000867b00720bULL, 0x002fe20003f5d000ULL,
0x000000886c50723cULL, 0x000b620000041850ULL, 0x00000085127b723eULL, 0x000fe200000010ffULL,
0x000000080a127824ULL, 0x000fc800078e00ffULL, 0x0000007a007c7306ULL, 0x0002e4000020d400ULL,
0x000000882830723cULL, 0x000b6c0000041830ULL, 0x0000008f007d7306ULL, 0x000ee2000020d400ULL,
0x0000007e8700720bULL, 0x004fe40003fdd000ULL, 0x000000b3147a723eULL, 0x002fc400000010ffULL,
0x000000017c7c2812ULL, 0x008fca00078efcffULL, 0x0000007a6c54723cULL, 0x000b620000041854ULL,
0x0000007c0b7c723eULL, 0x000fc600000010ffULL, 0x000000017d7d6812ULL, 0x000fc800078efcffULL,
0x0000007a2834723cULL, 0x000b620000041834ULL, 0x0000007d087d723eULL, 0x000fe200000010ffULL,
0x0000001005087824ULL, 0x000fe400078e0206ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x0000007c6c4c723cULL, 0x080b62000004184cULL, 0x000000000808783bULL, 0x000eae0000000200ULL,
0x0000007c282c723cULL, 0x000b62000004182cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f08087231ULL, 0x084fe400003400ffULL,
0x0000000f0a0a7231ULL, 0x000fc400003400ffULL, 0x0000000e09097231ULL, 0x080fe400003400ffULL,
0x0000000e0b0b7231ULL, 0x000fe400003400ffULL, 0x0000000d04047231ULL, 0x082fe400003400ffULL,
0x0000000d06067231ULL, 0x000fe400003400ffULL, 0x0000000c05057231ULL, 0x080fe400003400ffULL,
0x0000000c07077231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x000000002628783bULL, 0x020ee80000004200ULL,
0x0000001012127824ULL, 0x000fca00078e0225ULL, 0x00000000126c783bULL, 0x000ea20000004200ULL,
0x00000018ff267819ULL, 0x008fe2000001142bULL, 0x0000002800277306ULL, 0x000fe20000009400ULL,
0x00000018ff117819ULL, 0x000fe20000011428ULL, 0x00000100297d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011429ULL, 0x000001002a947824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe2000001142aULL, 0x000001002b997824ULL, 0x040fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe2000001147dULL, 0x0000002600a37306ULL, 0x000fe20000209400ULL,
0x00000018ff7b7819ULL, 0x004fe2000001146dULL, 0x000100002b9f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe2000001146eULL, 0x000001006ca77824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe2000001146fULL, 0x000001006daa7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x0000002600a47306ULL, 0x000fe20000205400ULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x000001006eb77824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fc4000001149fULL, 0x00000018ffa77819ULL, 0x000fe400000114a7ULL,
0x00000018ffaf7819ULL, 0x000fe200000114aaULL, 0x0000002600717306ULL, 0x0005e2000020d400ULL,
0x00000018ffb77819ULL, 0x000fce00000114b7ULL, 0x00000028007a7306ULL, 0x000ee20000005400ULL,
0x0000010028267824ULL, 0x004fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000002800797306ULL, 0x000470000000d400ULL, 0x00000011007f7306ULL, 0x000fe20000209400ULL,
0x0001000028287824ULL, 0x004fe200078e00ffULL, 0x0000007a2700720bULL, 0x008fc80003fdd000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000001100847306ULL, 0x000fee0000205400ULL,
0x0000000179796812ULL, 0x002fe200078efcffULL, 0x0000001100867306ULL, 0x0003f0000020d400ULL,
0x00000014008e7306ULL, 0x000fe20000209400ULL, 0x00000018ff117819ULL, 0x002fce000001146cULL,
0x00000014008f7306ULL, 0x000ff00000205400ULL, 0x0000001400907306ULL, 0x000ff0000020d400ULL,
0x0000002100957306ULL, 0x000ff00000209400ULL, 0x00000021009a7306ULL, 0x000ff00000205400ULL,
0x00000021009c7306ULL, 0x000ff0000020d400ULL, 0x0000001100ab7306ULL, 0x000ff00000209400ULL,
0x0000001100ac7306ULL, 0x000ff00000205400ULL, 0x0000001100257306ULL, 0x000ff0000020d400ULL,
0x0000007b00b37306ULL, 0x000ff00000209400ULL, 0x0000007b00b87306ULL, 0x000ff00000205400ULL,
0x0000007b00217306ULL, 0x000ff0000020d400ULL, 0x0000008200b97306ULL, 0x000ff00000209400ULL,
0x0000008200bc7306ULL, 0x000ff00000205400ULL, 0x0000008200147306ULL, 0x000ff0000020d400ULL,
0x0000002900817306ULL, 0x000ff00000009400ULL, 0x0000002900887306ULL, 0x000e700000005400ULL,
0x0000008900727306ULL, 0x000ff00000209400ULL, 0x0000008900737306ULL, 0x000fe20000205400ULL,
0x000000888100720bULL, 0x002fe20003f5d000ULL, 0x000100006f817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000008900117306ULL, 0x0003f0000020d400ULL,
0x00000026007b7306ULL, 0x000fe20000209400ULL, 0x0001000029897824ULL, 0x002fca00078e00ffULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x00000026007c7306ULL, 0x000e700000205400ULL,
0x00000028007d7306ULL, 0x000ff00000209400ULL, 0x0000002800827306ULL, 0x000ea20000205400ULL,
0x0000007c7b00720bULL, 0x002fce0003fbd000ULL, 0x00000026007e7306ULL, 0x000e70000020d400ULL,
0x0000008900267306ULL, 0x000fe20000209400ULL, 0x000000827d00720bULL, 0x004fce0003f9d000ULL,
0x00000089008b7306ULL, 0x000ea20000205400ULL, 0x000000017e7e5812ULL, 0x002fe400078efcffULL,
0x000000847f00720bULL, 0x000fca0003fbd000ULL, 0x0000002900837306ULL, 0x000e70000000d400ULL,
0x0000008500877306ULL, 0x000fe20000209400ULL, 0x0000008b2600720bULL, 0x004fe20003fdd000ULL,
0x000001006f267824ULL, 0x000fe200078e00ffULL, 0x0000000186865812ULL, 0x000fc800078efcffULL,
0x00000018ff7c7819ULL, 0x000fe20000011426ULL, 0x00000085008a7306ULL, 0x000ea20000205400ULL,
0x0000000183832812ULL, 0x002fe400078efcffULL, 0x000000797e26723eULL, 0x000fca00000010ffULL,
0x00000085008c7306ULL, 0x000e70000020d400ULL, 0x0000002800297306ULL, 0x000ee2000020d400ULL,
0x0000008a8700720bULL, 0x004fce0003f1d000ULL, 0x0000002a00917306ULL, 0x000fec0000009400ULL,
0x000000018c8c0812ULL, 0x002fe400078efcffULL, 0x0000002a00927306ULL, 0x000e620000005400ULL,
0x0000000129294812ULL, 0x008fe400078efcffULL, 0x0000008f8e00720bULL, 0x000fc40003f1d000ULL,
0x000000838c27723eULL, 0x000fc600000010ffULL, 0x0000002a00937306ULL, 0x0004e8000000d400ULL,
0x000000260868723cULL, 0x000b680000041868ULL, 0x0000009400857306ULL, 0x000fe20000209400ULL,
0x000100002a2a7824ULL, 0x004fe200078e00ffULL, 0x0000000190900812ULL, 0x000fc400078efcffULL,
0x000000929100720bULL, 0x002fe20003f7d000ULL, 0x000000260448723cULL, 0x000b620000041848ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000009400967306ULL, 0x000e620000205400ULL,
0x0000009a9500720bULL, 0x000fce0003f1d000ULL, 0x00000099009b7306ULL, 0x000fe20000209400ULL,
0x0000000193933812ULL, 0x008fe400078efcffULL, 0x000000a4a300720bULL, 0x000fc60003f7d000ULL,
0x000000019c9c0812ULL, 0x000fe400078efcffULL, 0x0000009900a07306ULL, 0x000ea20000205400ULL,
0x000000968500720bULL, 0x002fce0003f5d000ULL, 0x00000089008d7306ULL, 0x000e62000020d400ULL,
0x0000000171713812ULL, 0x000fce00078efcffULL, 0x0000002a00287306ULL, 0x000fe20000209400ULL,
0x000000a09b00720bULL, 0x004fce0003f9d000ULL, 0x0000002a00897306ULL, 0x000ea20000205400ULL,
0x000000018d8d6812ULL, 0x002fce00078efcffULL, 0x0000009400987306ULL, 0x000e70000020d400ULL,
0x00000099009d7306ULL, 0x000ee2000020d400ULL, 0x000000892800720bULL, 0x004fe40003fdd000ULL,
0x000000298628723eULL, 0x000fc400000010ffULL, 0x0000008d9029723eULL, 0x000fc600000010ffULL,
0x0000002b00977306ULL, 0x000fe20000009400ULL, 0x0000000198982812ULL, 0x002fc600078efcffULL,
0x000000280864723cULL, 0x000b620000041864ULL, 0x000000939898723eULL, 0x000fc600000010ffULL,
0x0000002b009e7306ULL, 0x000e620000005400ULL, 0x000000019d9d4812ULL, 0x008fc600078efcffULL,
0x000000280444723cULL, 0x000b680000041844ULL, 0x0000006c00a57306ULL, 0x000ff00000009400ULL,
0x0000006c00a67306ULL, 0x000ea20000005400ULL, 0x0000009e9700720bULL, 0x002fce0003fbd000ULL,
0x0000009f00947306ULL, 0x000ff00000209400ULL, 0x0000009f00a17306ULL, 0x000e620000205400ULL,
0x000000a6a500720bULL, 0x004fce0003f9d000ULL, 0x0000006c00707306ULL, 0x0004f0000000d400ULL,
0x0000002b00787306ULL, 0x000ee2000000d400ULL, 0x000100006c6c7824ULL, 0x004fe200078e00ffULL,
0x000000a19400720bULL, 0x002fc80003f5d000ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000002a002b7306ULL, 0x000e62000020d400ULL, 0x0000000170704812ULL, 0x008fce00078efcffULL,
0x0000006d00ad7306ULL, 0x000fe20000009400ULL, 0x0000000178785812ULL, 0x000fce00078efcffULL,
0x0000006d00ae7306ULL, 0x000ea20000005400ULL, 0x000000012b2b6812ULL, 0x002fc800078efcffULL,
0x0000002b9c9c723eULL, 0x000fc600000010ffULL, 0x0000009f00a27306ULL, 0x000e70000020d400ULL,
0x000000a700997306ULL, 0x000fe20000209400ULL, 0x000000aead00720bULL, 0x004fce0003fdd000ULL,
0x000000a700a87306ULL, 0x000ea20000205400ULL, 0x00000001a2a22812ULL, 0x002fce00078efcffULL,
0x000000af00b07306ULL, 0x000ff00000209400ULL, 0x000000af00b17306ULL, 0x000e620000205400ULL,
0x000000a89900720bULL, 0x004fe40003fbd000ULL, 0x000000789d99723eULL, 0x000fc400000010ffULL,
0x000000a2719d723eULL, 0x000fc600000010ffULL, 0x0000006c002a7306ULL, 0x000fe40000209400ULL,
0x000000980860723cULL, 0x040b6c0000041860ULL, 0x0000006c009f7306ULL, 0x000ea20000205400ULL,
0x000000b1b000720bULL, 0x002fe20003f5d000ULL, 0x0000009c085c723cULL, 0x000b6c000004185cULL,
0x0000006d00237306ULL, 0x0002e4000000d400ULL, 0x000000980440723cULL, 0x040b6c0000041840ULL,
0x0000006e00b57306ULL, 0x000fe20000009400ULL, 0x000100006d6d7824ULL, 0x002fe200078e00ffULL,
0x0000009f2a00720bULL, 0x004fe20003f9d000ULL, 0x0000009c043c723cULL, 0x000b66000004183cULL,
0x00000018ff6d7819ULL, 0x000fc4000001146dULL, 0x0000006e00ba7306ULL, 0x000e620000005400ULL,
0x0000000123236812ULL, 0x008fe400078efcffULL, 0x000000b8b300720bULL, 0x000fca0003fdd000ULL,
0x0000006e00127306ULL, 0x0004f0000000d400ULL, 0x000000a700a97306ULL, 0x000ee2000020d400ULL,
0x000100006e6e7824ULL, 0x004fe200078e00ffULL, 0x000000bab500720bULL, 0x002fc40003f1d000ULL,
0x0000000121216812ULL, 0x000fe400078efcffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x000000af00b27306ULL, 0x000e6e000020d400ULL, 0x0000000112120812ULL, 0x008fe200078efcffULL,
0x0000006c00aa7306ULL, 0x000ea2000020d400ULL, 0x00000001a9a95812ULL, 0x000fc400078efcffULL,
0x000000acab00720bULL, 0x000fe40003fbd000ULL, 0x00000070a970723eULL, 0x000fc600000010ffULL,
0x0000006d00a77306ULL, 0x000fe20000209400ULL, 0x00000001b2b22812ULL, 0x002fc800078efcffULL,
0x00000023b271723eULL, 0x000fc600000010ffULL, 0x0000006d00b47306ULL, 0x000e620000205400ULL,
0x00000001aaaa4812ULL, 0x004fe400078efcffULL, 0x0000000125255812ULL, 0x000fe200078efcffULL,
0x000000700858723cULL, 0x080b620000041858ULL, 0x000000bcb900720bULL, 0x000fe40003fbd000ULL,
0x000000aa25aa723eULL, 0x000fe200000010ffULL, 0x000000b7007a7306ULL, 0x000fe80000209400ULL,
0x000000700438723cULL, 0x000b680000041838ULL, 0x000000b7007b7306ULL, 0x000ea20000205400ULL,
0x000000b4a700720bULL, 0x002fc40003f5d000ULL, 0x0000000114145812ULL, 0x000fca00078efcffULL,
0x0000006f00bb7306ULL, 0x000ff00000009400ULL, 0x0000006f00be7306ULL, 0x000e620000005400ULL,
0x0000007b7a00720bULL, 0x004fce0003f9d000ULL, 0x0000006f00037306ULL, 0x000eb0000000d400ULL,
0x0000006e006c7306ULL, 0x000fe20000209400ULL, 0x000000bebb00720bULL, 0x002fce0003f7d000ULL,
0x0000006e006f7306ULL, 0x000fec0000205400ULL, 0x0000000103033812ULL, 0x004fe400078efcffULL,
0x0000006e007d7306ULL, 0x000ff0000020d400ULL, 0x0000007c007f7306ULL, 0x000ff00000209400ULL,
0x0000007c006e7306ULL, 0x000e700000205400ULL, 0x0000006d00b67306ULL, 0x000eb0000020d400ULL,
0x000000b7006d7306ULL, 0x000ee2000020d400ULL, 0x0000006e7f00720bULL, 0x002fce0003fdd000ULL,
0x00000081002a7306ULL, 0x000fe20000209400ULL, 0x00000001b6b62812ULL, 0x004fe400078efcffULL,
0x000000737200720bULL, 0x000fe40003f5d000ULL, 0x000000b621ab723eULL, 0x000fc600000010ffULL,
0x0000008100797306ULL, 0x000e620000205400ULL, 0x000000016d6d4812ULL, 0x008fe400078efcffULL,
0x0000006f6c00720bULL, 0x000fe20003f9d000ULL, 0x000000aa0854723cULL, 0x000b680000041854ULL,
0x0000007c007c7306ULL, 0x000ea2000020d400ULL, 0x0000000111112812ULL, 0x000fc600078efcffULL,
0x000000aa0434723cULL, 0x000b680000041834ULL, 0x00000081006e7306ULL, 0x000ee2000020d400ULL,
0x000000792a00720bULL, 0x002fe40003f1d000ULL, 0x000000017d7d4812ULL, 0x000fe400078efcffULL,
0x000000126d2a723eULL, 0x000fe400000010ffULL, 0x0000007d146c723eULL, 0x000fc400000010ffULL,
0x000000017c7c6812ULL, 0x004fc800078efcffULL, 0x000000037c2b723eULL, 0x000fe400000010ffULL,
0x000000016e6e0812ULL, 0x008fc800078efcffULL, 0x0000006e116d723eULL, 0x000fe200000010ffULL,
0x0000002a0850723cULL, 0x040b700000041850ULL, 0x0000006c084c723cULL, 0x000b70000004184cULL,
0x0000002a0430723cULL, 0x040b700000041830ULL, 0x0000006c042c723cULL, 0x000b62000004182cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000013047f8cULL, 0x0202a2000c80043fULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0001a6a01b067811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000006ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff037224ULL, 0x004fe200078e0005ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff135000007947ULL, 0x000fea000383ffffULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0001074000047802ULL, 0x004fc40000000f00ULL, 0x0000d51000007944ULL, 0x01afea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002200037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000022ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000e680000000000ULL,
0x0000000000047919ULL, 0x004ea20000000000ULL, 0x0000001808057811ULL, 0x042fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x004fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000006800687220ULL, 0x002fc40000410000ULL, 0x0000006900697220ULL, 0x040fe40000410000ULL,
0x0000006400647220ULL, 0x040fe40000410000ULL, 0x0000006500657220ULL, 0x040fe40000410000ULL,
0x0000006000607220ULL, 0x040fe40000410000ULL, 0x0000006100617220ULL, 0x040fe40000410000ULL,
0x0000005c005c7220ULL, 0x000fc40000410000ULL, 0x0000005d005d7220ULL, 0x040fe40000410000ULL,
0x0000005800587220ULL, 0x040fe40000410000ULL, 0x0000005900597220ULL, 0x040fe40000410000ULL,
0x0000005400547220ULL, 0x040fe40000410000ULL, 0x0000005500557220ULL, 0x040fe40000410000ULL,
0x0000005000507220ULL, 0x000fc40000410000ULL, 0x0000005100517220ULL, 0x040fe40000410000ULL,
0x0000004c004c7220ULL, 0x040fe40000410000ULL, 0x0000004d004d7220ULL, 0x000fe40000410000ULL,
0x0000004a054a7220ULL, 0x044fe40000410000ULL, 0x0000004b054b7220ULL, 0x040fe40000410000ULL,
0x0000004605467220ULL, 0x000fc40000410000ULL, 0x0000004705477220ULL, 0x040fe40000410000ULL,
0x0000004205427220ULL, 0x040fe40000410000ULL, 0x0000004305437220ULL, 0x040fe40000410000ULL,
0x0000003e053e7220ULL, 0x040fe40000410000ULL, 0x0000003f053f7220ULL, 0x040fe40000410000ULL,
0x0000003a053a7220ULL, 0x000fc40000410000ULL, 0x0000003b053b7220ULL, 0x040fe40000410000ULL,
0x0000003605367220ULL, 0x040fe40000410000ULL, 0x0000003705377220ULL, 0x040fe40000410000ULL,
0x0000003205327220ULL, 0x040fe40000410000ULL, 0x0000003305337220ULL, 0x040fe40000410000ULL,
0x0000002e052e7220ULL, 0x000fc40000410000ULL, 0x0000002f052f7220ULL, 0x000fe40000410000ULL,
0x000000046a6a7220ULL, 0x088fe40000410000ULL, 0x000000046b6b7220ULL, 0x080fe40000410000ULL,
0x0000000466667220ULL, 0x080fe40000410000ULL, 0x0000000467677220ULL, 0x080fe40000410000ULL,
0x0000000462627220ULL, 0x000fc40000410000ULL, 0x0000000463637220ULL, 0x080fe40000410000ULL,
0x000000045e5e7220ULL, 0x080fe40000410000ULL, 0x000000045f5f7220ULL, 0x080fe40000410000ULL,
0x000000045a5a7220ULL, 0x080fe40000410000ULL, 0x000000045b5b7220ULL, 0x080fe40000410000ULL,
0x0000000456567220ULL, 0x000fc40000410000ULL, 0x0000000457577220ULL, 0x080fe40000410000ULL,
0x0000000452527220ULL, 0x080fe40000410000ULL, 0x0000000453537220ULL, 0x080fe40000410000ULL,
0x000000044e4e7220ULL, 0x080fe40000410000ULL, 0x000000044f4f7220ULL, 0x000fe40000410000ULL,
0x0000000248487220ULL, 0x000fc40000410000ULL, 0x0000000249497220ULL, 0x080fe40000410000ULL,
0x0000000244447220ULL, 0x080fe40000410000ULL, 0x0000000245457220ULL, 0x080fe40000410000ULL,
0x0000000240407220ULL, 0x080fe40000410000ULL, 0x0000000241417220ULL, 0x080fe40000410000ULL,
0x000000023c3c7220ULL, 0x000fc40000410000ULL, 0x000000023d3d7220ULL, 0x080fe40000410000ULL,
0x0000000238387220ULL, 0x080fe40000410000ULL, 0x0000000239397220ULL, 0x080fe40000410000ULL,
0x0000000234347220ULL, 0x080fe40000410000ULL, 0x0000000235357220ULL, 0x080fe40000410000ULL,
0x0000000230307220ULL, 0x000fc40000410000ULL, 0x0000000231317220ULL, 0x080fe40000410000ULL,
0x000000022c2c7220ULL, 0x080fe40000410000ULL, 0x000000022d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000006a6b6a723eULL, 0x000fe400000010ffULL,
0x000000666766723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000626362723eULL, 0x000fc400000010ffULL, 0x0000005e5f5e723eULL, 0x000fe400000010ffULL,
0x0000005a5b5a723eULL, 0x000fe400000010ffULL, 0x000000565756723eULL, 0x000fe400000010ffULL,
0x000000525352723eULL, 0x000fe400000010ffULL, 0x0000004e4f29723eULL, 0x000fe400000010ffULL,
0x000000484948723eULL, 0x000fc400000010ffULL, 0x0000000800057811ULL, 0x04cfe400078ff0ffULL,
0x0000000200027812ULL, 0x042fe400078ec0ffULL, 0x0000001800097811ULL, 0x000fe200078ff0ffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fe400078ff8ffULL,
0x0000001000057811ULL, 0x000fe200078ff0ffULL, 0x0000000809147824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fc400078ee203ULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe400078ff8ffULL,
0x0000000902057211ULL, 0x040fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x040fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x0000200020037824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fc40007ffe0ffULL, 0x0000200003037812ULL, 0x000fe400078ee2ffULL,
0xfffffff809087812ULL, 0x000fe400078ee202ULL, 0xfffffff805027812ULL, 0x000fe200078ee204ULL,
0x000010001a057824ULL, 0x000fe200078e0203ULL, 0x0000000404067810ULL, 0x040fe40007ffe0ffULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090c7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x000000100a107824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x000000686902723eULL, 0x000fe200000010ffULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0x000000646504723eULL, 0x000fe200000010ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000545506723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x0000541002167816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x0000763202177816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x000000606102723eULL, 0x000fe200000010ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x0000005c5d04723eULL, 0x000fe200000010ffULL, 0x0000001608007388ULL, 0x0003e20000000a00ULL,
0x000000585905723eULL, 0x000fe200000010ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x000000444524723eULL, 0x010fe200000010ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000404140723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x0000003c3d3c723eULL, 0x000fe200000010ffULL, 0x00000001070c7824ULL, 0x040fe200078e020cULL,
0x0000541052287816ULL, 0x000fe20000000029ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000505107723eULL, 0x000fc400000010ffULL, 0x0000541002167816ULL, 0x142fe40000000004ULL,
0x0000763202177816ULL, 0x000fe40000000004ULL, 0x0000541005047816ULL, 0x100fe40000000006ULL,
0x0000004c4d08723eULL, 0x000fe200000010ffULL, 0x000000160a007388ULL, 0x000fe20000000a00ULL,
0x0000763205057816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040c007388ULL, 0x0003e20000000a00ULL,
0x0000763252297816ULL, 0x000fe40000000029ULL, 0x0000541040087816ULL, 0x140fe2000000003cULL,
0x000000060e007388ULL, 0x0005e20000000a00ULL, 0x0000763240097816ULL, 0x000fe4000000003cULL,
0x000000383938723eULL, 0x000fe400000010ffULL, 0x00000034351c723eULL, 0x000fc400000010ffULL,
0x000000303130723eULL, 0x000fe400000010ffULL, 0x000054106a047816ULL, 0x142fe40000000066ULL,
0x000076326a057816ULL, 0x000fe40000000066ULL, 0x0000541048067816ULL, 0x144fe40000000024ULL,
0x0000763248077816ULL, 0x000fe20000000024ULL, 0x0000000410007388ULL, 0x0003e20000000a00ULL,
0x0000002c2d18723eULL, 0x000fc400000010ffULL, 0x0000004a4b02723eULL, 0x000fe400000010ffULL,
0x0000541062047816ULL, 0x142fe4000000005eULL, 0x0000763262057816ULL, 0x000fca000000005eULL,
0x000400040a007388ULL, 0x0003e40000000a00ULL, 0x000054105a047816ULL, 0x142fe40000000056ULL,
0x000076325a057816ULL, 0x000fca0000000056ULL, 0x000400040c007388ULL, 0x0003e80000000a00ULL,
0x000400280e007388ULL, 0x000fe80000000a00ULL, 0x0000000612007388ULL, 0x0005e80000000a00ULL,
0x000800080a007388ULL, 0x0007e20000000a00ULL, 0x000000464704723eULL, 0x002fc400000010ffULL,
0x000000424305723eULL, 0x000fe400000010ffULL, 0x0000003e3f06723eULL, 0x004fe400000010ffULL,
0x0000541038087816ULL, 0x148fe4000000001cULL, 0x0000763238097816ULL, 0x000fca000000001cULL,
0x000800080c007388ULL, 0x0003e40000000a00ULL, 0x0000541030087816ULL, 0x142fe40000000018ULL,
0x0000763230097816ULL, 0x000fca0000000018ULL, 0x000800080e007388ULL, 0x0003e40000000a00ULL,
0x0000541002087816ULL, 0x142fe40000000004ULL, 0x0000763202097816ULL, 0x000fe40000000004ULL,
0x0000003a3b02723eULL, 0x000fe400000010ffULL, 0x000000363704723eULL, 0x000fe200000010ffULL,
0x0000000814007388ULL, 0x0003e60000000a00ULL, 0x0000763202157816ULL, 0x000fc40000000004ULL,
0x0000541005087816ULL, 0x142fe40000000006ULL, 0x0000763205097816ULL, 0x000fe40000000006ULL,
0x0000541002147816ULL, 0x000fe20000000004ULL, 0x0000000177027824ULL, 0x000fe200078e0200ULL,
0x000000323305723eULL, 0x000fe200000010ffULL, 0x000c00080a007388ULL, 0x000fe20000000a00ULL,
0x0000002e2f06723eULL, 0x000fe200000010ffULL, 0x000000ff00047306ULL, 0x000fe40000205400ULL,
0x000c00140c007388ULL, 0x0003e20000000a00ULL, 0x00007632050d7816ULL, 0x000fc40000000006ULL,
0x00005410050c7816ULL, 0x002fe20000000006ULL, 0x0000001002067824ULL, 0x000fe400078e0203ULL,
0x000000ff00057306ULL, 0x000e640000209400ULL, 0x000c000c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000006087984ULL, 0x000ea20000000c00ULL,
0x000000ff00027306ULL, 0x000ee2000020d400ULL, 0x000000040500720bULL, 0x002fc40003f1d000ULL,
0x0004000006147984ULL, 0x000e680000000c00ULL, 0x0008000006247984ULL, 0x000e680000000c00ULL,
0x000c0000060c7984ULL, 0x000e680000000c00ULL, 0x0010000006107984ULL, 0x000e620000000c00ULL,
0x0000000102020812ULL, 0x008fc400078efcffULL, 0x000000ff1a00720cULL, 0x000fe20003f05270ULL,
0x00140000061c7984ULL, 0x000ee20000000c00ULL, 0x000000020204723eULL, 0x000fc600000010ffULL,
0x0018000006287984ULL, 0x000ee80000000c00ULL, 0x001c0000062c7984ULL, 0x000ee20000000c00ULL,
0x3f803f80040b7831ULL, 0x044fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x000fc40000200008ULL,
0x3f803f8004177831ULL, 0x042fe40000200017ULL, 0x3f803f8004167831ULL, 0x040fe40000200016ULL,
0x3f803f8004157831ULL, 0x040fe40000200015ULL, 0x3f803f8004147831ULL, 0x040fe40000200014ULL,
0x3f803f8004277831ULL, 0x040fe40000200027ULL, 0x3f803f8004267831ULL, 0x000fc40000200026ULL,
0x3f803f8004257831ULL, 0x040fe40000200025ULL, 0x3f803f8004247831ULL, 0x040fe40000200024ULL,
0x3f803f80040f7831ULL, 0x040fe4000020000fULL, 0x3f803f80040e7831ULL, 0x040fe4000020000eULL,
0x3f803f80040d7831ULL, 0x040fe4000020000dULL, 0x3f803f80040c7831ULL, 0x000fc4000020000cULL,
0x3f803f800b0b7831ULL, 0x000fe40000200013ULL, 0x3f803f800a0a7831ULL, 0x000fe40000200012ULL,
0x3f803f8009097831ULL, 0x000fe40000200011ULL, 0x3f803f8008087831ULL, 0x000fe40000200010ULL,
0x3f803f8017177831ULL, 0x008fe4000020001fULL, 0x3f803f8016167831ULL, 0x000fe2000020001eULL,
0x0000000806007388ULL, 0x000fe20000000c00ULL, 0x3f803f8015157831ULL, 0x000fc4000020001dULL,
0x3f803f8014147831ULL, 0x000fe4000020001cULL, 0x3f803f8027277831ULL, 0x000fe4000020002bULL,
0x3f803f8026267831ULL, 0x000fe2000020002aULL, 0x0004001406007388ULL, 0x000fe20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200029ULL, 0x3f803f8024247831ULL, 0x000fe40000200028ULL,
0x3f803f800f0f7831ULL, 0x000fc4000020002fULL, 0x3f803f800e0e7831ULL, 0x000fe2000020002eULL,
0x0008002406007388ULL, 0x000fe20000000c00ULL, 0x3f803f800d0d7831ULL, 0x000fe4000020002dULL,
0x3f803f800c0c7831ULL, 0x000fca000020002cULL, 0x000c000c06007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000740700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x100fe200078e0200ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000000120117812ULL, 0x000fe200078ec0ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000702057812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007000e7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe200078ef800ULL,
0x0000580000067ab9ULL, 0x000fc80000000800ULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000002076027824ULL, 0x000fe400078e0207ULL, 0x0000000811077824ULL, 0x000fe200078e020eULL,
0x0000000004087984ULL, 0x0004e40000000c00ULL, 0x0000000502067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe20000011602ULL, 0x00000006040472a4ULL, 0x002fc4000f8e023fULL,
0x0000000175067824ULL, 0x000fc800078e0206ULL, 0x0000008005057224ULL, 0x000fe200078e0206ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x0000000480027c24ULL, 0x000fc6000f8e02ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011606ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x004fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440cULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe200078e020dULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020760d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fe400078e0204ULL, 0x0000000811077824ULL, 0x002fc600078e0206ULL,
0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000d047a11ULL, 0x000fc800078040ffULL, 0x00005d000d057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0d7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000740d00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x00000060000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x0000008000077810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000800f0f7224ULL, 0x000fca00078e0204ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x00000003ff0f7819ULL, 0x000fc60000011607ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000740f00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107047824ULL, 0x102fe200078e020fULL,
0x000000a0000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0d7819ULL, 0x000fe4000001160cULL,
0x0ffffff804047812ULL, 0x000fe400078ef807ULL, 0x0000000707077812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e0207ULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800f0f7224ULL, 0x000fca00078e0204ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440eULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x000000c0000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x000000e000007810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff077819ULL, 0x000fe40000011600ULL,
0x0ffffff804047812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800f0f7224ULL, 0x000fe400078e0204ULL, 0x0000000100067824ULL, 0x002fc600078e0207ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x000000740700720cULL, 0x000fc60003f06070ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x00000007060d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff80d067812ULL, 0x000fe200078ef800ULL,
0x0000000804007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000002076077824ULL, 0x000fc600078e0207ULL, 0x0000000006087984ULL, 0x002e620000000c00ULL,
0x0000000811057824ULL, 0x000fe200078e0200ULL, 0x0000000507047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fc60000011607ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x0000008007077224ULL, 0x000fca00078e0204ULL, 0x0000000702077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fc800078040ffULL,
0x00005d0007037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000001d2000720cULL, 0x000fe20003f06070ULL, 0xffffffffff0f7424ULL, 0x000fd800078e00ffULL,
0x00000002be038824ULL, 0x000fc800078e00ffULL, 0x00006800030c8a24ULL, 0x000fc800078e0220ULL,
0x000064000c0c8625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006c00ff0a7624ULL, 0x000fe200078e00ffULL, 0x000000080c0f8981ULL, 0x000ea2000c1e1900ULL,
0x00006d00ff0b7624ULL, 0x000fc600078e00ffULL, 0x01a60000ff087f8cULL, 0x000ee8000c80043fULL,
0x000000080a0a7981ULL, 0x000322000c1e9900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x00000040bcbc7824ULL, 0x000fe400078e00ffULL, 0x0000004020027824ULL, 0x000fe400078e00ffULL,
0x0000004019037824ULL, 0x000fc400078e00ffULL, 0x0000000fbc2d7224ULL, 0x004fcc00078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x000000021e057217ULL, 0x00afe40007800000ULL,
0x00000003ff327819ULL, 0x100fe4000001161fULL, 0x000062002d2b7a11ULL, 0x000fe200078438ffULL,
0x0000000105057824ULL, 0x000fe200078e0a02ULL, 0x00000004320c7810ULL, 0x040fe20007ffe0ffULL,
0x0000004019067824ULL, 0x000fe200078e0232ULL, 0x00000008320e7810ULL, 0x000fe40007ffe0ffULL,
0x000000050c00720cULL, 0x0c0fe20003f86070ULL, 0x000000010c0b7824ULL, 0x100fe200078e021fULL,
0x0000000c32107810ULL, 0x000fe20007ffe0ffULL, 0x000000080c267824ULL, 0x000fe200078e00ffULL,
0x000000050e00720cULL, 0x0c0fe20003f06070ULL, 0x000000010e0c7824ULL, 0x000fe200078e021fULL,
0x000000051000720cULL, 0x000fe20003f26070ULL, 0x000000080e0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x00000001100b7824ULL, 0x000fe200078e021fULL,
0x00000004060e7810ULL, 0x000fe20007ffe0ffULL, 0x00000008102a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d287812ULL, 0x000fe200078ee20cULL, 0x00000080060c7825ULL, 0x040fe200078e00ffULL,
0x0000000806107810ULL, 0x000fc40007ffe0ffULL, 0x000063002d2d7a11ULL, 0x000fe200010f3cffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c167812ULL, 0x100fe400078ef804ULL,
0x0000000c060c7810ULL, 0x000fe20007ffe0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000162b167210ULL, 0x000fe40007f5e0ffULL, 0x000000700e187812ULL, 0x100fe400078ef804ULL,
0x0000007010107812ULL, 0x000fe200078ef804ULL, 0x000000010d177824ULL, 0x000fe200010e062dULL,
0x0000002b18187210ULL, 0x080fe20007f7e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000002b10107210ULL, 0x000fc40007f5e0ffULL, 0x00000010060e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f197824ULL, 0x100fe200018e062dULL, 0x000000700c1a7812ULL, 0x100fe200078ef804ULL,
0x0000000111117824ULL, 0x000fe200010e062dULL, 0x0000001806147810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000002b1a1a7210ULL, 0x000fe40007f5e0ffULL,
0x0000001406127810ULL, 0x000fe20007ffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000700e227812ULL, 0x000fc400078ef804ULL, 0x0000001c060c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d1b7824ULL, 0x000fe200010e062dULL, 0x0000002b22227210ULL, 0x000fe20007f7e0ffULL,
0x00000001320d7824ULL, 0x040fe200078e021fULL, 0x00000010320e7810ULL, 0x000fe20007ffe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007014147812ULL, 0x000fe400078ef804ULL,
0x000000070d2c7812ULL, 0x000fe200078ec0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000001432247810ULL, 0x000fc40007ffe0ffULL, 0x0000007012127812ULL, 0x100fe200078ef804ULL,
0x000000010f237824ULL, 0x000fe200018e062dULL, 0x0000002b14147210ULL, 0x080fe20007fde0ffULL,
0x000000010e0f7824ULL, 0x100fe200078e021fULL, 0x000000700c257812ULL, 0x000fe200078ef804ULL,
0x000000080e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002b12127210ULL, 0x000fe20007fbe0ffULL,
0x00000001240c7824ULL, 0x100fe200078e021fULL, 0x000000050e00720cULL, 0x080fe20003f46070ULL,
0x0000000824277824ULL, 0x000fe200078e00ffULL, 0x0ffffff82c0e7812ULL, 0x000fe200078ef81fULL,
0x0000000115157824ULL, 0x100fe200030e062dULL, 0x000000052400720cULL, 0x000fe20003f66070ULL,
0x0000000113137824ULL, 0x000fe200028e062dULL, 0xfffffff82e2c7812ULL, 0x000fc400078ee20fULL,
0xfffffff82a2a7812ULL, 0x000fe400078ee20bULL, 0x0000002b25247210ULL, 0x000fe40007fde0ffULL,
0xfffffff8272e7812ULL, 0x000fe400078ee20cULL, 0x00002000200b7811ULL, 0x000fe200078e70ffULL,
0x000000010d257824ULL, 0x000fe200030e062dULL, 0x00000020060c7810ULL, 0x000fe40007ffe0ffULL,
0x000000053200720cULL, 0x000fe20003fa6070ULL, 0x0000001026277824ULL, 0x000fe200078e020bULL,
0x0000001832267810ULL, 0x000fe20007ffe0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000001c32307810ULL, 0x000fc60007ffe0ffULL, 0x000000100e217824ULL, 0x000fe200078e020bULL,
0x000000700c297812ULL, 0x100fe200078ef804ULL, 0x00000001260c7824ULL, 0x000fe200078e021fULL,
0x00000024060e7810ULL, 0x000fe20007ffe0ffULL, 0x00000008262f7824ULL, 0x040fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016217faeULL, 0x0003e2000e901c48ULL,
0x000000052600720cULL, 0x080fe20003fa6070ULL, 0x000000800e0e7825ULL, 0x000fe400078e00ffULL,
0x0000000018277faeULL, 0x0005e2000e101c48ULL, 0x000000053000720cULL, 0x040fe20003f86070ULL,
0x0000000830267824ULL, 0x000fe200078e00ffULL, 0x000000700e0e7812ULL, 0x000fc400078ef804ULL,
0x0000002b29167210ULL, 0x002fe20007fde0ffULL, 0x0000000130217824ULL, 0x000fe200078e021fULL,
0xfffffff82f187812ULL, 0x004fc600078ee20cULL, 0x000000010d177824ULL, 0x000fe200030e062dULL,
0x00000028060c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001028197824ULL, 0x000fe200078e020bULL,
0x0000002032287810ULL, 0x000fe40007ffe0ffULL, 0xfffffff826267812ULL, 0x000fe200078ee221ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000002b0e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000000010197faeULL, 0x0003e2000c101c48ULL, 0x000000052800720cULL, 0x080fe20003f06070ULL,
0x000000102a217824ULL, 0x000fe200078e020bULL, 0x00000024322a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128277824ULL, 0x000fe200078e021fULL, 0x000000700c0c7812ULL, 0x000fe200078ef804ULL,
0x0000000828307824ULL, 0x000fe200078e00ffULL, 0x000000001a217faeULL, 0x0005e2000c901c48ULL,
0x000000010f0f7824ULL, 0x000fe200030e062dULL, 0x000000052a00720cULL, 0x040fe20003f26070ULL,
0x000000012a287824ULL, 0x000fc400078e021fULL, 0x000000082a117824ULL, 0x002fe200078e00ffULL,
0x0000002b0c107210ULL, 0x000fe20007fde0ffULL, 0x000000102c197824ULL, 0x000fe200078e020bULL,
0xfffffff8300c7812ULL, 0x000fe400078ee227ULL, 0xfffffff811287812ULL, 0x000fe200078ee228ULL,
0x000000010d117824ULL, 0x000fe200030e062dULL, 0x0000000022197faeULL, 0x0003e2000d101c48ULL,
0x000000102e0d7824ULL, 0x100fe200078e020bULL, 0x0000002c321a7810ULL, 0x004fe20007ffe0ffULL,
0x000000100c277824ULL, 0x100fe200078e020bULL, 0x0000002c060c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010181b7824ULL, 0x100fe200078e020bULL, 0x00000000120d7faeULL, 0x0005e2000d901c48ULL,
0x0000001026217824ULL, 0x100fe200078e020bULL, 0x0000002832187810ULL, 0x000fe20007ffe0ffULL,
0x0000001028297824ULL, 0x000fe200078e020bULL, 0x00000000141b7faeULL, 0x0007e2000e901c48ULL,
0x0000003432267810ULL, 0x000fc40007ffe0ffULL, 0x0000003032227810ULL, 0x042fe20007ffe0ffULL,
0x0000000024217faeULL, 0x0003e2000e101c48ULL, 0x0000003832287810ULL, 0x000fe40007ffe0ffULL,
0x000000051a00720cULL, 0x080fe20003f86070ULL, 0x000000800c0c7825ULL, 0x004fe200078e00ffULL,
0x0000000016277faeULL, 0x0005e2000c101c48ULL, 0x000000051800720cULL, 0x000fe40003fa6070ULL,
0x000000011a157824ULL, 0x008fe200078e021fULL, 0x000000700c127812ULL, 0x000fe200078ef804ULL,
0x000000000e297faeULL, 0x0007e2000c901c48ULL, 0x00000030060c7810ULL, 0x000fe20007ffe0ffULL,
0x000000081a1a7824ULL, 0x000fe200078e00ffULL, 0x0000002b12127210ULL, 0x000fc40007fde0ffULL,
0x0000003c32247810ULL, 0x002fe20007ffe0ffULL, 0x0000000822177824ULL, 0x044fe200078e00ffULL,
0x000000052200720cULL, 0x080fe20003f66070ULL, 0x000000010d137824ULL, 0x000fe200030e062dULL,
0x000000052600720cULL, 0x080fe20003f46070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x00000034060e7810ULL, 0x008fe40007ffe0ffULL, 0x000000052800720cULL, 0x080fe40003f26070ULL,
0x000000700c147812ULL, 0x000fe200078ef804ULL, 0x00000001220c7824ULL, 0x000fe200078e021fULL,
0x000000052400720cULL, 0x000fe20003f06070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000002b14147210ULL, 0x000fc40007fde0ffULL, 0xfffffff817227812ULL, 0x000fe200078ee20cULL,
0x0000000118057824ULL, 0x000fe200078e021fULL, 0x00000038060c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000818187824ULL, 0x000fe200078e00ffULL, 0x000000700e167812ULL, 0x000fe400078ef804ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee215ULL, 0x000000010d157824ULL, 0x000fe200030e062dULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000002b16167210ULL, 0x000fc40007fde0ffULL, 0x0000003c060e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000126057824ULL, 0x000fe200078e021fULL, 0x000000700c0c7812ULL, 0x000fe200078ef804ULL,
0x0000000826267824ULL, 0x000fe400078e00ffULL, 0x000000010f177824ULL, 0x000fe200030e062dULL,
0x0000002b0c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff826067812ULL, 0x000fc600078ee205ULL, 0x0000000128057824ULL, 0x100fe200078e021fULL,
0x000000700e047812ULL, 0x000fe200078ef804ULL, 0x0000000828287824ULL, 0x000fe400078e00ffULL,
0x00000001241f7824ULL, 0x040fe400078e021fULL, 0x0000000824247824ULL, 0x000fe200078e00ffULL,
0xfffffff8280e7812ULL, 0x000fe200078ee205ULL, 0x000000010d0d7824ULL, 0x000fe200030e062dULL,
0x0000002b04047210ULL, 0x000fe20007fde0ffULL, 0x0000001018197824ULL, 0x000fe200078e020bULL,
0xfffffff824247812ULL, 0x000fe200078ee21fULL, 0x000000101a1b7824ULL, 0x000fc400078e020bULL,
0x00000010221f7824ULL, 0x100fe200078e020bULL, 0x0000000010197faeULL, 0x0003e2000e901c48ULL,
0x0000001006217824ULL, 0x100fe400078e020bULL, 0x000000100e237824ULL, 0x100fe200078e020bULL,
0x00000000121b7faeULL, 0x0003e2000e101c48ULL, 0x00000010240b7824ULL, 0x000fe400078e020bULL,
0x000000010f057824ULL, 0x000fe200030e062dULL, 0x00000000141f7faeULL, 0x0003e8000d901c48ULL,
0x0000000016217faeULL, 0x0003e8000d101c48ULL, 0x000000000c237faeULL, 0x0003e8000c901c48ULL,
0x00000000040b7faeULL, 0x0003e2000c101c48ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x000000041f0e7811ULL, 0x04afe400078fe8ffULL, 0x000000081f107811ULL, 0x000fc400078fe8ffULL,
0x000000101f147811ULL, 0x040fe200078fe8ffULL, 0x000000010e057824ULL, 0x140fe200078e021fULL,
0x0000000c1f127811ULL, 0x040fe200078fe8ffULL, 0x000000080e067824ULL, 0x000fe200078e00ffULL,
0x000000141f167811ULL, 0x040fe200078fe8ffULL, 0x00000008100c7824ULL, 0x000fe200078e00ffULL,
0x0000001c1f287811ULL, 0x040fe200078fe8ffULL, 0x00000001140b7824ULL, 0x000fe200078e021fULL,
0xfffffff8060d7812ULL, 0x000fe200078ee205ULL, 0x0000000110057824ULL, 0x100fe200078e021fULL,
0x000000201f2a7811ULL, 0x040fe200078fe8ffULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0x000000241f327811ULL, 0x040fe200078fe8ffULL, 0x0000000112067824ULL, 0x000fe200078e021fULL,
0xfffffff80c0f7812ULL, 0x000fe200078ee205ULL, 0x0000000812117824ULL, 0x000fe200078e00ffULL,
0xfffffff818137812ULL, 0x000fe200078ee20bULL, 0x0000000116057824ULL, 0x140fe200078e021fULL,
0x000000181f187811ULL, 0x000fe200078fe8ffULL, 0x00000008160c7824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x00000001280b7824ULL, 0x040fe200078e021fULL,
0x000000281f347811ULL, 0x040fe200078fe8ffULL, 0x00000008281a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c157812ULL, 0x000fe200078ee205ULL, 0x0000000118067824ULL, 0x040fe200078e021fULL,
0x0000002c1f367811ULL, 0x040fe200078fe8ffULL, 0x0000000818177824ULL, 0x000fe200078e00ffULL,
0xfffffff81a197812ULL, 0x000fe200078ee20bULL, 0x000000012a057824ULL, 0x140fe200078e021fULL,
0x000000301f387811ULL, 0x000fe200078fe8ffULL, 0x000000082a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee206ULL, 0x0000000132067824ULL, 0x040fe200078e021fULL,
0x000000341f3a7811ULL, 0x040fe200078fe8ffULL, 0x00000008321b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL, 0x00000001340b7824ULL, 0x140fe200078e021fULL,
0x000000381f3c7811ULL, 0x000fe200078fe8ffULL, 0x0000000834227824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x0000000136057824ULL, 0x040fe200078e021fULL,
0x0000003c1f3e7811ULL, 0x040fe200078fe8ffULL, 0x00000008360c7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee20bULL, 0x0000000138067824ULL, 0x000fe200078e021fULL,
0x00002000202c7811ULL, 0x000fe200078e70ffULL, 0x0000000838217824ULL, 0x000fe200078e00ffULL,
0xfffffff80c237812ULL, 0x000fe200078ee205ULL, 0x000000013a0b7824ULL, 0x140fe200078e021fULL,
0x0000001f1f057211ULL, 0x000fe200078fe8ffULL, 0x000000083a0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff821247812ULL, 0x000fe200078ee206ULL, 0x000000083e267824ULL, 0x000fe200078e00ffULL,
0x0000000705067812ULL, 0x000fe200078ec0ffULL, 0x000000013c057824ULL, 0x000fe200078e021fULL,
0xfffffff80c257812ULL, 0x000fe200078ee20bULL, 0x000000083c0c7824ULL, 0x000fe200078e00ffULL,
0x0ffffff806067812ULL, 0x100fe200078ef81fULL, 0x000000013e0b7824ULL, 0x000fe200078e021fULL,
0x000062002d4d7a11ULL, 0x000fe200078038ffULL, 0x00000001030e7824ULL, 0x040fe200078e020eULL,
0xfffffff80c057812ULL, 0x000fe200078ee205ULL, 0x0000000103107824ULL, 0x000fe200078e0210ULL,
0x000000031f0c7211ULL, 0x000fe200078fe8ffULL, 0x000000100d1f7824ULL, 0x100fe200078e022cULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x000000101a3d7824ULL, 0x000fe200078e022cULL,
0x000063002d4f7a11ULL, 0x000fe200000f3cffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000000103127824ULL, 0x000fe200078e0212ULL, 0x000000700c1a7812ULL, 0x000fe200078ef804ULL,
0x000000100f217824ULL, 0x100fe400078e022cULL, 0x0000001011337824ULL, 0x000fe200078e022cULL,
0x0000001a4d1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000001013357824ULL, 0x000fe400078e022cULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000001022417824ULL, 0x000fe200078e022cULL,
0x000000700e227812ULL, 0x000fe200078ef804ULL, 0x0000001024457824ULL, 0x000fe200078e022cULL,
0x0000007010247812ULL, 0x000fe200078ef804ULL, 0x00000001030c7824ULL, 0x000fe200078e0214ULL,
0x000000224d227210ULL, 0x000fe20007f3e0ffULL, 0x00000010264b7824ULL, 0x000fe200078e022cULL,
0x0000007012267812ULL, 0x000fe200078ef804ULL, 0x000000101b3f7824ULL, 0x000fe400078e022cULL,
0x000000010d1b7824ULL, 0x000fe200000e064fULL, 0x000000244d247210ULL, 0x040fe20007f1e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000264d267210ULL, 0x000fc60007f5e0ffULL,
0x00000001030e7824ULL, 0x040fe200078e0216ULL, 0x000000700c297812ULL, 0x000fe200078ef804ULL,
0x0000000103107824ULL, 0x000fe400078e0218ULL, 0x0000001023437824ULL, 0x000fe400078e022cULL,
0x0000000103127824ULL, 0x000fe400078e0228ULL, 0x0000001025477824ULL, 0x000fe400078e022cULL,
0x000000010f237824ULL, 0x000fc400008e064fULL, 0x0000000103147824ULL, 0x000fe400078e022aULL,
0x0000000111257824ULL, 0x000fe200000e064fULL, 0x000000294d287210ULL, 0x000fe20007f1e0ffULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000113277824ULL, 0x000fe200010e064fULL,
0x000000700e2a7812ULL, 0x000fe200078ef804ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000001015377824ULL, 0x000fe400078e022cULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000070122e7812ULL, 0x000fc600078ef804ULL,
0x00000010060b7824ULL, 0x000fe200078e022cULL, 0x0000007014307812ULL, 0x000fe200078ef804ULL,
0x0000001017397824ULL, 0x100fe200078e022cULL, 0x0000002e4d2e7210ULL, 0x000fe20007f5e0ffULL,
0x00000010193b7824ULL, 0x100fe200078e022cULL, 0x000000304d307210ULL, 0x000fe20007f7e0ffULL,
0x0000001005497824ULL, 0x000fe200078e022cULL, 0x00000070102c7812ULL, 0x000fe200078ef804ULL,
0x000000010d297824ULL, 0x000fe200000e064fULL, 0x0000002a4d2a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001030c7824ULL, 0x000fe200078e0232ULL, 0x0000002c4d2c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001030e7824ULL, 0x040fe200078e0234ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a0b7faeULL, 0x0003e2000b901c48ULL, 0x0000000103107824ULL, 0x000fc400078e0236ULL,
0x0000000103127824ULL, 0x000fe200078e0238ULL, 0x00000000221f7faeULL, 0x0003e2000b901c48ULL,
0x000000010f2b7824ULL, 0x000fe400000e064fULL, 0x0000000103147824ULL, 0x000fe200078e023aULL,
0x0000000024217faeULL, 0x0003e2000b901c48ULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x0000000026337faeULL, 0x0003e2000b901c48ULL, 0x00000001112d7824ULL, 0x000fe200008e064fULL,
0x000000700c057812ULL, 0x000fe200078ef804ULL, 0x0000000103167824ULL, 0x000fe200078e023cULL,
0x0000000028357faeULL, 0x0003e2000b901c48ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x000000002a377faeULL, 0x0003e2000b901c48ULL, 0x00000001132f7824ULL, 0x100fe200010e064fULL,
0x000000700e0c7812ULL, 0x000fe200078ef804ULL, 0x0000000103187824ULL, 0x000fe200078e023eULL,
0x000000002c397faeULL, 0x0003e2000b901c48ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000c4d0c7210ULL, 0x000fe40007f3e0ffULL, 0x000000002e3b7faeULL, 0x0003e2000b901c48ULL,
0x0000000115317824ULL, 0x000fe200018e064fULL, 0x00000070100e7812ULL, 0x000fe200078ef804ULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000000e4d0e7210ULL, 0x040fe20007f5e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000007012107812ULL, 0x100fe200078ef804ULL,
0x00000000303d7faeULL, 0x0003e4000b901c48ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007014127812ULL, 0x100fe400078ef804ULL, 0x000000104d107210ULL, 0x000fe20007f7e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000007016147812ULL, 0x000fc400078ef804ULL,
0x000000124d127210ULL, 0x040fe40007f9e0ffULL, 0x0000007018167812ULL, 0x000fe400078ef804ULL,
0x000000054d047210ULL, 0x040fe40007f1e0ffULL, 0x000000144d147210ULL, 0x040fe40007fbe0ffULL,
0x000000164d167210ULL, 0x000fe20007fde0ffULL, 0x000000010d057824ULL, 0x100fe400000e064fULL,
0x000000010f0d7824ULL, 0x000fc400008e064fULL, 0x00000001110f7824ULL, 0x100fe200010e064fULL,
0x00000000043f7faeULL, 0x0003e2000b901c48ULL, 0x0000000113117824ULL, 0x100fe400018e064fULL,
0x0000000115137824ULL, 0x100fe200020e064fULL, 0x000000000c417faeULL, 0x0003e2000b901c48ULL,
0x0000000117157824ULL, 0x100fe400028e064fULL, 0x0000000119177824ULL, 0x000fe200030e064fULL,
0x000000000e437faeULL, 0x0003e8000b901c48ULL, 0x0000000010457faeULL, 0x0003e8000b901c48ULL,
0x0000000012477faeULL, 0x0003e8000b901c48ULL, 0x0000000014497faeULL, 0x0003e8000b901c48ULL,
0x00000000164b7faeULL, 0x0003e4000b901c48ULL, 0x0000000420047810ULL, 0x002fe20007ffe0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x0000001d0400720cULL, 0x000fda0003f06070ULL,
0x00000002be058824ULL, 0x000fc800078e00ffULL, 0x0000680005068a24ULL, 0x000fe400078e0204ULL,
0xffffffffff057424ULL, 0x000fe400078e00ffULL, 0x0000640006068625ULL, 0x000fca00078e0007ULL,
0x0000000806058981ULL, 0x000324000c1e1900ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01a60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c060c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e07ULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc8000001140dULL,
0x0000000c0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x000000020b0b7819ULL, 0x000fc8000000120cULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x0000002020067824ULL, 0x002fca00078e0207ULL,
0x00000004ff077819ULL, 0x000fe40000011606ULL, 0x0000000106087810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe07097812ULL, 0x000fe400078ec0ffULL, 0x0000001f06077812ULL, 0x000fc600078ec0ffULL,
0x00000001090c7824ULL, 0x040fe400078e0208ULL, 0x00000001060b7824ULL, 0x000fe200078e0209ULL,
0x0000000809097810ULL, 0x000fe20007ffe0ffULL, 0x00000010070d7824ULL, 0x040fe200078e00ffULL,
0x0000000f0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00000010070e7824ULL, 0x000fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x100fe200078e0209ULL,
0x000001f00d0c7812ULL, 0x000fe200078ee20cULL, 0x0000000106067824ULL, 0x000fe200078e0209ULL,
0x000001f00e0b7812ULL, 0x000fe200078ee20bULL, 0x0000001007097824ULL, 0x040fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x000000000c107984ULL, 0x000e62000000cc00ULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x0000000f06067812ULL, 0x000fc400078ec0ffULL,
0x000000000b147984ULL, 0x000ea4000000cc00ULL, 0x000001f007087812ULL, 0x000fe400078ee208ULL,
0x000001f009067812ULL, 0x000fe200078ee206ULL, 0x000000ffff1a7224ULL, 0x002fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff187224ULL, 0x004fe400078e0014ULL,
0x000000ffff197224ULL, 0x000fc400078e0016ULL, 0x000000ffff267224ULL, 0x000fe400078e0011ULL,
0x000000ffff277224ULL, 0x000fe200078e0013ULL, 0x000000180b007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff247224ULL, 0x000fe400078e0015ULL, 0x000000ffff257224ULL, 0x000fca00078e0017ULL,
0x000000240c007388ULL, 0x000fe8000000cc00ULL, 0x0000000008107984ULL, 0x000e68000000cc00ULL,
0x0000000006147984ULL, 0x000ea2000000cc00ULL, 0x000000ffff2b7224ULL, 0x002fe400078e0012ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff287224ULL, 0x004fe400078e0014ULL, 0x000000ffff297224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x0000002806007388ULL, 0x0003e8000000cc00ULL, 0x0000001008007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a60000ff0c7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0e7224ULL, 0x000fc600078e00ffULL, 0x0000000000067805ULL, 0x002fc80000015200ULL,
0x01a60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0x00005800ff0d7624ULL, 0x000fe200078e00ffULL, 0x800058001e0e7a10ULL, 0x000fe20007ffe0ffULL,
0x3db504f30a077820ULL, 0x010fe20000410000ULL, 0x0000010002bb7810ULL, 0x000fe20007ffe0ffULL,
0x00006800bebe7a24ULL, 0x000fe200078e02ffULL, 0x0000001f0d0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0001a68820087811ULL, 0x000fe400078e18ffULL,
0x00000004ff0f7819ULL, 0x000fc4000001160cULL, 0xffffffff0d0c7810ULL, 0x040fe40007ffe0ffULL,
0x0001a60820097811ULL, 0x000fe400078e28ffULL, 0x000000090d0d7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff0e7819ULL, 0x000fe4000001160eULL, 0x0ffffffe0f0f7812ULL, 0x000fc400078ec0ffULL,
0x000000020a117810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000005bc2b7224ULL, 0x010fe200078e02ffULL, 0x000000010b107812ULL, 0x000fc400078e0cffULL,
0x0000001c1100720cULL, 0x000fda0003f06070ULL, 0x00000cd000008947ULL, 0x00cfea0003800000ULL,
0x00000003ff287819ULL, 0x102fe20000011606ULL, 0x000001000a057824ULL, 0x000fe200078e02bbULL,
0x000062002b297a11ULL, 0x000fe400078438ffULL, 0x0000000428147810ULL, 0x040fe40007ffe0ffULL,
0x0000000828167810ULL, 0x000fe40007ffe0ffULL, 0x000000051e127217ULL, 0x000fe20007800000ULL,
0x0000000114117824ULL, 0x100fe200078e0206ULL, 0x0000000c28247810ULL, 0x000fe20007ffe0ffULL,
0x00000008142a7824ULL, 0x000fe200078e00ffULL, 0x0000001028267810ULL, 0x000fe20007ffe0ffULL,
0x0000000116137824ULL, 0x100fe200078e0206ULL, 0x0000001428327810ULL, 0x000fe20007ffe0ffULL,
0x00000008162c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL,
0x0000000112057824ULL, 0x000fe200078e0a05ULL, 0x0000001828367810ULL, 0x000fe20007ffe0ffULL,
0x0000000124117824ULL, 0x100fe200078e0206ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee213ULL,
0x00000008242e7824ULL, 0x000fe200078e00ffULL, 0x000000051600720cULL, 0x080fe20003f06070ULL,
0x0000000126127824ULL, 0x100fe200078e0206ULL, 0x000000051400720cULL, 0x080fe20003f26070ULL,
0x0000000826177824ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee211ULL,
0x0000000132137824ULL, 0x000fe200078e0206ULL, 0x0000001c283a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000832347824ULL, 0x000fe200078e00ffULL, 0xfffffff817307812ULL, 0x000fe200078ee212ULL,
0x0000001006117824ULL, 0x000fe200078e00ffULL, 0x000063002b2b7a11ULL, 0x000fe200010f3cffULL,
0x0000000103127824ULL, 0x040fe200078e0228ULL, 0xfffffff834347812ULL, 0x000fe200078ee213ULL,
0x0000000103167824ULL, 0x000fe200078e0216ULL, 0x00000070112d7812ULL, 0x000fe200078ec0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000052600720cULL, 0x000fc40003fa6070ULL,
0x00000020283e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000136157824ULL, 0x000fe200078e0206ULL,
0x0000002d12187212ULL, 0x080fe200078efcffULL, 0x0000000836387824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001829187210ULL, 0x000fe40007f5e0ffULL,
0xfffffff838387812ULL, 0x000fe200078ee215ULL, 0x0000000103147824ULL, 0x000fe200078e0214ULL,
0x0000002d16227212ULL, 0x000fe200078efcffULL, 0x000000013a117824ULL, 0x000fc400078e0206ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000002922227210ULL, 0x000fc60007f9e0ffULL,
0x000000083a3c7824ULL, 0x000fe200078e00ffULL, 0x0000002d141a7212ULL, 0x000fe200078efcffULL,
0x0000000103127824ULL, 0x000fe400078e0224ULL, 0x0000000128167824ULL, 0x000fe200078e0206ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x0000000113197824ULL, 0x000fe200010e062bULL,
0x000000291a1a7210ULL, 0x000fe20007f7e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000052400720cULL, 0x000fc60003f46070ULL, 0x0000000117237824ULL, 0x100fe200020e062bULL,
0x0000000716177812ULL, 0x000fe200078ec0ffULL, 0x0000000220117824ULL, 0x000fe200078e0210ULL,
0x0000002d12247212ULL, 0x000fe200078efcffULL, 0x0000000103147824ULL, 0x000fe200078e0226ULL,
0x0ffffff817127812ULL, 0x000fe200078ef806ULL, 0x00000001151b7824ULL, 0x000fe200018e062bULL,
0x0000200011117811ULL, 0x000fe200078e68ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000002924247210ULL, 0x000fe40007f9e0ffULL, 0x000000052800720cULL, 0x000fe20003f66070ULL,
0x0000001012177824ULL, 0x000fe200078e0211ULL, 0x0000002d14267212ULL, 0x000fe200078efcffULL,
0x0000000103127824ULL, 0x000fc400078e0232ULL, 0x0000000113257824ULL, 0x100fe200020e062bULL,
0x0000002926267210ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000053200720cULL, 0x000fe40003f86070ULL, 0x0000002c28327810ULL, 0x000fe20007ffe0ffULL,
0x0000000103147824ULL, 0x000fe200078e0236ULL, 0x0000002d12127212ULL, 0x000fe200078efcffULL,
0x000000013e167824ULL, 0x040fe200078e0206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018177faeULL, 0x0003e2000d901c48ULL, 0x000000083e1f7824ULL, 0x000fe200078e00ffULL,
0x000000053600720cULL, 0x000fe20003f66070ULL, 0x0000000115277824ULL, 0x000fc400030e062bULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff81f407812ULL, 0x000fc600078ee216ULL,
0x000000102a1f7824ULL, 0x000fe200078e0211ULL, 0x00000024282a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103167824ULL, 0x000fe200078e023aULL, 0x0000002912187210ULL, 0x002fe40007fde0ffULL,
0x0000002d14127212ULL, 0x000fe200078efcffULL, 0x000000001a1f7faeULL, 0x0003e2000c901c48ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000053a00720cULL, 0x000fc60003f26070ULL,
0x0000000113197824ULL, 0x000fe200030e062bULL, 0x0000002d16167212ULL, 0x000fe200078efcffULL,
0x000000012a217824ULL, 0x040fe400078e0206ULL, 0x000000082a147824ULL, 0x000fe200078e00ffULL,
0x00000029121a7210ULL, 0x082fe20007fde0ffULL, 0x0000000103127824ULL, 0x000fe400078e023eULL,
0x000000102c1f7824ULL, 0x000fe200078e0211ULL, 0xfffffff8142c7812ULL, 0x000fe200078ee221ULL,
0x00000001151b7824ULL, 0x000fe200030e062bULL, 0x0000002916167210ULL, 0x000fe20007fde0ffULL,
0x000000102e157824ULL, 0x000fe200078e0211ULL, 0x00000028282e7810ULL, 0x000fe20007ffe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000000221f7faeULL, 0x0003e2000c101c48ULL,
0x000000053e00720cULL, 0x000fc40003f06070ULL, 0x0000000103147824ULL, 0x000fe200078e022aULL,
0x0000000024157faeULL, 0x0005e2000d101c48ULL, 0x000000052a00720cULL, 0x000fe20003f46070ULL,
0x000000082e2a7824ULL, 0x000fe400078e00ffULL, 0x0000000117177824ULL, 0x000fe400030e062bULL,
0x0000000832217824ULL, 0x000fe200078e00ffULL, 0x0000002d12227212ULL, 0x002fe200078efcffULL,
0x000000012e1f7824ULL, 0x100fe400078e0206ULL, 0x0000000132127824ULL, 0x000fe200078e0206ULL,
0x0000002922227210ULL, 0x000fc40007fde0ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee21fULL,
0x00000010301f7824ULL, 0x000fe200078e0211ULL, 0xfffffff821307812ULL, 0x000fe200078ee212ULL,
0x0000000113237824ULL, 0x000fe400030e062bULL, 0x0000008014127825ULL, 0x000fe200078e00ffULL,
0x00000000261f7faeULL, 0x0003e2000e901c48ULL, 0x000000052e00720cULL, 0x000fe40003fa6070ULL,
0x0000000103147824ULL, 0x040fe200078e022eULL, 0x0000002d12247212ULL, 0x004fe200078efcffULL,
0x0000000103127824ULL, 0x000fe200078e0232ULL, 0x00000030282e7810ULL, 0x000fe20007ffe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000002924247210ULL, 0x000fc60007fde0ffULL,
0x0000001034217824ULL, 0x000fe200078e0211ULL, 0x0000002d14147212ULL, 0x000fe200078efcffULL,
0x0000000113257824ULL, 0x000fe200030e062bULL, 0x0000003828347810ULL, 0x000fe20007ffe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000018217faeULL, 0x0005e2000e101c48ULL,
0x000000053200720cULL, 0x000fe40003f86070ULL, 0x00000010381f7824ULL, 0x002fe200078e0211ULL,
0x0000002d12267212ULL, 0x000fe200078efcffULL, 0x000000082e327824ULL, 0x000fe200078e00ffULL,
0x0000003428127810ULL, 0x000fc40007ffe0ffULL, 0x000000001a1f7faeULL, 0x0003e2000d901c48ULL,
0x000000052e00720cULL, 0x000fe40003f66070ULL, 0x0000003c28287810ULL, 0x000fe20007ffe0ffULL,
0x000000012e217824ULL, 0x004fe200078e0206ULL, 0x0000002914187210ULL, 0x000fe20007fde0ffULL,
0x0000000103147824ULL, 0x000fc600078e022eULL, 0xfffffff8322e7812ULL, 0x000fe200078ee221ULL,
0x0000000115197824ULL, 0x000fe200030e062bULL, 0x0000002926267210ULL, 0x000fe20007fde0ffULL,
0x000000103c217824ULL, 0x000fe400078e0211ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000000016217faeULL, 0x0005e2000c901c48ULL, 0x0000000113277824ULL, 0x000fe200030e062bULL,
0x000000051200720cULL, 0x040fe20003f26070ULL, 0x0000000112137824ULL, 0x000fe200078e0206ULL,
0x0000002d141a7212ULL, 0x002fe200078efcffULL, 0x0000000812327824ULL, 0x000fe400078e00ffULL,
0x0000000103127824ULL, 0x040fe200078e0212ULL, 0x000000291a1a7210ULL, 0x000fe20007fde0ffULL,
0x0000000103147824ULL, 0x000fe200078e0234ULL, 0xfffffff832327812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x00000001151b7824ULL, 0x000fe200030e062bULL,
0x0000002d12167212ULL, 0x004fe200078efcffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000002916167210ULL, 0x000fe20007fde0ffULL, 0x00000010401f7824ULL, 0x100fe200078e0211ULL,
0x0000002d14147212ULL, 0x000fe200078efcffULL, 0x000000102c217824ULL, 0x000fe400078e0211ULL,
0x0000000103127824ULL, 0x000fe200078e0228ULL, 0x00000000221f7faeULL, 0x0003e2000c101c48ULL,
0x0000000113177824ULL, 0x000fe200030e062bULL, 0x000000052800720cULL, 0x080fe20003f06070ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000024217faeULL, 0x0005e2000d101c48ULL,
0x000000053400720cULL, 0x000fc40003f46070ULL, 0x0000000134057824ULL, 0x100fe200078e0206ULL,
0x0000002914147210ULL, 0x000fe40007fde0ffULL, 0x0000002d12127212ULL, 0x000fe200078efcffULL,
0x0000000834227824ULL, 0x002fe400078e00ffULL, 0x00000001281f7824ULL, 0x040fe400078e0206ULL,
0x0000000828247824ULL, 0x004fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee205ULL,
0x0000000115157824ULL, 0x000fe200030e062bULL, 0x0000002912127210ULL, 0x000fe20007fde0ffULL,
0x000000102a057824ULL, 0x000fe200078e0211ULL, 0xfffffff824247812ULL, 0x000fe200078ee21fULL,
0x00000010301f7824ULL, 0x000fc400078e0211ULL, 0x000000102e217824ULL, 0x100fe200078e0211ULL,
0x0000000018057faeULL, 0x0003e2000e901c48ULL, 0x0000001032237824ULL, 0x100fe400078e0211ULL,
0x0000001022257824ULL, 0x100fe200078e0211ULL, 0x00000000261f7faeULL, 0x0003e2000e101c48ULL,
0x0000001024117824ULL, 0x000fe400078e0211ULL, 0x0000000113137824ULL, 0x000fe200030e062bULL,
0x000000001a217faeULL, 0x0003e8000d901c48ULL, 0x0000000016237faeULL, 0x0003e8000c901c48ULL,
0x0000000014257faeULL, 0x0003e8000d101c48ULL, 0x0000000012117faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x0000000406157811ULL, 0x042fe400078fe8ffULL,
0x00000010061a7811ULL, 0x000fc400078fe8ffULL, 0x0000000c06187811ULL, 0x040fe200078fe8ffULL,
0x0000000115057824ULL, 0x140fe200078e0206ULL, 0x0000001406227811ULL, 0x040fe200078fe8ffULL,
0x0000000815127824ULL, 0x000fe200078e00ffULL, 0x0000002006277811ULL, 0x000fe200078fe8ffULL,
0x000000081a397824ULL, 0x000fe200078e00ffULL, 0x0000001c06257811ULL, 0x000fe200078fe8ffULL,
0x0000000118117824ULL, 0x100fe200078e0206ULL, 0xfffffff812177812ULL, 0x000fe200078ee205ULL,
0x000000011a127824ULL, 0x100fe200078e0206ULL, 0x00000024062a7811ULL, 0x000fe200078fe8ffULL,
0x0000000818247824ULL, 0x000fe200078e00ffULL, 0x0000000806167811ULL, 0x000fe200078fe8ffULL,
0x0000000122137824ULL, 0x040fe200078e0206ULL, 0xfffffff839397812ULL, 0x000fe200078ee212ULL,
0x0000000822267824ULL, 0x000fe200078e00ffULL, 0xfffffff824217812ULL, 0x000fe200078ee211ULL,
0x0000000127127824ULL, 0x140fe200078e0206ULL, 0x00000030062f7811ULL, 0x000fe200078fe8ffULL,
0x0000000827417824ULL, 0x000fe200078e00ffULL, 0xfffffff8263b7812ULL, 0x000fe200078ee213ULL,
0x0000000125117824ULL, 0x140fe200078e0206ULL, 0x0000002c062d7811ULL, 0x040fe200078fe8ffULL,
0x0000000825247824ULL, 0x000fe200078e00ffULL, 0x0000003406317811ULL, 0x000fe200078fe8ffULL,
0x000000012a137824ULL, 0x040fe200078e0206ULL, 0xfffffff841417812ULL, 0x000fe200078ee212ULL,
0x000000082a267824ULL, 0x000fe200078e00ffULL, 0x0000001806237811ULL, 0x000fe200078fe8ffULL,
0x0000000116057824ULL, 0x100fe200078e0206ULL, 0xfffffff8243f7812ULL, 0x000fe200078ee211ULL,
0x0000000816147824ULL, 0x000fe200078e00ffULL, 0xfffffff826437812ULL, 0x000fe200078ee213ULL,
0x000000012f127824ULL, 0x140fe200078e0206ULL, 0x0000003806337811ULL, 0x040fe200078fe8ffULL,
0x000000082f497824ULL, 0x000fe200078e00ffULL, 0x0000003c06357811ULL, 0x000fe200078fe8ffULL,
0x000000012d117824ULL, 0x040fe200078e0206ULL, 0xfffffff8141f7812ULL, 0x000fe200078ee205ULL,
0x000000082d247824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee212ULL,
0x0000000131137824ULL, 0x140fe200078e0206ULL, 0x00000028062c7811ULL, 0x000fe200078fe8ffULL,
0x0000000831267824ULL, 0x000fe200078e00ffULL, 0xfffffff824477812ULL, 0x000fe200078ee211ULL,
0x0000000123057824ULL, 0x100fe200078e0206ULL, 0x000062002b537a11ULL, 0x000fe200078038ffULL,
0x0000000823147824ULL, 0x000fe200078e00ffULL, 0xfffffff8264b7812ULL, 0x000fe200078ee213ULL,
0x0000000133127824ULL, 0x100fe200078e0206ULL, 0x000063002b557a11ULL, 0x000fe200000f3cffULL,
0x00000008334d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8143d7812ULL, 0x000fe200078ee205ULL,
0x0000000135137824ULL, 0x000fc400078e0206ULL, 0x0000000835247824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee212ULL, 0x000000012c057824ULL, 0x040fe400078e0206ULL,
0x000000082c147824ULL, 0x000fe200078e00ffULL, 0xfffffff8244f7812ULL, 0x000fe200078ee213ULL,
0x0000001006127824ULL, 0x040fe200078e00ffULL, 0x0000000306137211ULL, 0x000fe200078fe8ffULL,
0x0000000220117824ULL, 0x000fe200078e0210ULL, 0xfffffff814457812ULL, 0x000fe200078ee205ULL,
0x0000000103167824ULL, 0x040fe200078e0216ULL, 0x0000000606057211ULL, 0x000fe200078fe8ffULL,
0x00000001031a7824ULL, 0x000fe200078e021aULL, 0x0000007012517812ULL, 0x000fe200078ec0ffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x0000200011147811ULL, 0x000fc400078e68ffULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x0000000103157824ULL, 0x000fe200078e0215ULL,
0x0000005112127212ULL, 0x000fe200078efcffULL, 0x0000001017117824ULL, 0x000fe200078e0214ULL,
0x0ffffff805057812ULL, 0x000fe200078ef806ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001253127210ULL, 0x000fc60007f1e0ffULL, 0x0000000103187824ULL, 0x000fe200078e0218ULL,
0x0000005116167212ULL, 0x000fe200078efcffULL, 0x0000001005057824ULL, 0x100fe400078e0214ULL,
0x000000101f1f7824ULL, 0x100fe400078e0214ULL, 0x0000001021217824ULL, 0x100fe400078e0214ULL,
0x0000001039397824ULL, 0x100fe400078e0214ULL, 0x000000103b3b7824ULL, 0x000fc400078e0214ULL,
0x000000103d3d7824ULL, 0x100fe400078e0214ULL, 0x000000103f3f7824ULL, 0x100fe400078e0214ULL,
0x0000001041417824ULL, 0x100fe400078e0214ULL, 0x0000001043437824ULL, 0x100fe400078e0214ULL,
0x0000001045457824ULL, 0x100fe400078e0214ULL, 0x0000001047477824ULL, 0x000fc400078e0214ULL,
0x0000001049497824ULL, 0x100fe400078e0214ULL, 0x000000104b4b7824ULL, 0x100fe400078e0214ULL,
0x000000104d4d7824ULL, 0x100fe400078e0214ULL, 0x000000104f4f7824ULL, 0x000fe400078e0214ULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0x000000511a1a7212ULL, 0x000fc600078efcffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000005114147212ULL, 0x000fc600078efcffULL, 0x0000000113137824ULL, 0x000fe200000e0655ULL,
0x0000001653167210ULL, 0x000fe20007f1e0ffULL, 0x0000000103227824ULL, 0x040fe200078e0222ULL,
0x0000005118187212ULL, 0x000fe200078efcffULL, 0x0000000103247824ULL, 0x000fe200078e0223ULL,
0x0000001453147210ULL, 0x000fe20007f3e0ffULL, 0x0000000103267824ULL, 0x000fe200078e0225ULL,
0x0000001853187210ULL, 0x000fe20007f5e0ffULL, 0x0000000103287824ULL, 0x000fe200078e0227ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012057faeULL, 0x0003e2000b901c48ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000005122227212ULL, 0x000fc600078efcffULL, 0x0000000117177824ULL, 0x000fe200000e0655ULL,
0x0000001a531a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000005124247212ULL, 0x000fc600078efcffULL, 0x00000001032a7824ULL, 0x000fe200078e022aULL,
0x0000005126267212ULL, 0x000fe200078efcffULL, 0x0000008028287825ULL, 0x000fc800078e00ffULL,
0x00000001032c7824ULL, 0x040fe200078e022cULL, 0x0000005128287212ULL, 0x000fe200078efcffULL,
0x00000001032e7824ULL, 0x040fe400078e022dULL, 0x0000000103307824ULL, 0x000fe200078e022fULL,
0x0000002853287210ULL, 0x000fe20007f7e0ffULL, 0x0000000103327824ULL, 0x000fe400078e0231ULL,
0x000000802a2a7825ULL, 0x000fc800078e00ffULL, 0x0000000103347824ULL, 0x000fe200078e0233ULL,
0x000000512a2a7212ULL, 0x000fe200078efcffULL, 0x000000802c2c7825ULL, 0x000fc800078e00ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0655ULL, 0x0000002253227210ULL, 0x000fe20007f1e0ffULL,
0x0000000103367824ULL, 0x000fe200078e0235ULL, 0x000000512c2c7212ULL, 0x000fe200078efcffULL,
0x000000802e2e7825ULL, 0x000fc800078e00ffULL, 0x0000000115157824ULL, 0x100fe200008e0655ULL,
0x0000002453247210ULL, 0x000fe20007f3e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x000000512e2e7212ULL, 0x080fe400078efcffULL, 0x0000000014117faeULL, 0x0003e2000b901c48ULL,
0x0000000119197824ULL, 0x100fe200010e0655ULL, 0x0000002653267210ULL, 0x040fe20007f5e0ffULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000005130307212ULL, 0x080fe200078efcffULL,
0x00000000161f7faeULL, 0x0003e4000b901c48ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005132327212ULL, 0x080fe200078efcffULL, 0x0000000018217faeULL, 0x0003e4000b901c48ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000005134347212ULL, 0x080fe200078efcffULL,
0x000000001a397faeULL, 0x0003e2000b901c48ULL, 0x0000003253327210ULL, 0x000fe20007f9e0ffULL,
0x0000000123237824ULL, 0x100fe200000e0655ULL, 0x0000002a532a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000125257824ULL, 0x100fe200008e0655ULL, 0x0000002c532c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000127277824ULL, 0x100fe200010e0655ULL, 0x0000005136367212ULL, 0x000fe200078efcffULL,
0x0000000129297824ULL, 0x100fe200018e0655ULL, 0x0000002e532e7210ULL, 0x000fe20007f5e0ffULL,
0x000000012b2b7824ULL, 0x100fe200000e0655ULL, 0x0000003053307210ULL, 0x000fe20007f7e0ffULL,
0x000000012d2d7824ULL, 0x100fe200008e0655ULL, 0x0000003453347210ULL, 0x040fe20007fbe0ffULL,
0x00000000223b7faeULL, 0x0003e2000b901c48ULL, 0x0000003653367210ULL, 0x000fe20007fde0ffULL,
0x000000012f2f7824ULL, 0x000fc400010e0655ULL, 0x00000000243d7faeULL, 0x0003e2000b901c48ULL,
0x0000000131317824ULL, 0x100fe400018e0655ULL, 0x0000000133337824ULL, 0x100fe200020e0655ULL,
0x00000000263f7faeULL, 0x0003e2000b901c48ULL, 0x0000000135357824ULL, 0x100fe400028e0655ULL,
0x0000000137377824ULL, 0x000fe200030e0655ULL, 0x0000000028417faeULL, 0x0003e8000b901c48ULL,
0x000000002a437faeULL, 0x0003e8000b901c48ULL, 0x000000002c457faeULL, 0x0003e8000b901c48ULL,
0x000000002e477faeULL, 0x0003e8000b901c48ULL, 0x0000000030497faeULL, 0x0003e8000b901c48ULL,
0x00000000324b7faeULL, 0x0003e8000b901c48ULL, 0x00000000344d7faeULL, 0x0003e8000b901c48ULL,
0x00000000364f7faeULL, 0x0003e4000b901c48ULL, 0x0000000404047810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff057424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000001d0400720cULL, 0x000fda0003f06070ULL, 0x00000002be128824ULL, 0x000fe400078e0204ULL,
0x00000004ff138424ULL, 0x000fc800078e00ffULL, 0x0000640012128625ULL, 0x000fe200078e0013ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x0000000812058981ULL, 0x000322000c1e1900ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000727805ULL, 0x000fe2000001ff00ULL, 0x0000000000707805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x002fc80000000000ULL, 0xfffffff806137812ULL, 0x000fe200078ec0ffULL,
0x0000000220237824ULL, 0x000fe200078e020bULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000111757810ULL, 0x000fc40007ffe0ffULL, 0x0000000713127812ULL, 0x000fe400078ef806ULL,
0x0000200023237811ULL, 0x000fe400078e68ffULL, 0x0000002006157810ULL, 0x000fe20007ffe0ffULL,
0x0000000112137824ULL, 0x040fe400078e0211ULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fc800078ec0ffULL, 0xfffffff814147812ULL, 0x000fe200078ee213ULL,
0x0000000812137824ULL, 0x040fe200078e00ffULL, 0x0000000715747812ULL, 0x000fe200078ef806ULL,
0x0000000112127824ULL, 0x000fe400078e0275ULL, 0x0000001014147824ULL, 0x000fe400078e0223ULL,
0x0000000174157824ULL, 0x040fe200078e0211ULL, 0xfffffff813127812ULL, 0x000fe200078ee212ULL,
0x00000008741a7824ULL, 0x040fe200078e00ffULL, 0x00000000142c783bULL, 0x000e620000000200ULL,
0x0000000174757824ULL, 0x000fc400078e0275ULL, 0x0000001012127824ULL, 0x000fca00078e0223ULL,
0x000000001234783bULL, 0x020ea20000000200ULL, 0x00000018ff167819ULL, 0x002fe2000001142cULL,
0x0000002c00f67306ULL, 0x000fe20000009400ULL, 0x00000018ff177819ULL, 0x000fe4000001142dULL,
0x00000018ff187819ULL, 0x000fe4000001142eULL, 0x00000018ff197819ULL, 0x000fe4000001142fULL,
0x00000018ff217819ULL, 0x004fe20000011435ULL, 0x0000001600927306ULL, 0x000fe20000209400ULL,
0x00000018ff227819ULL, 0x000fc40000011436ULL, 0x00000018ff1b7819ULL, 0x000fe40000011434ULL,
0x00000018ff767819ULL, 0x000fc60000011437ULL, 0x0000001600937306ULL, 0x000e700000205400ULL,
0x00000016006d7306ULL, 0x0004f0000020d400ULL, 0x00000021008a7306ULL, 0x000fe20000209400ULL,
0xfffffff81a167812ULL, 0x004fc400078ee215ULL, 0x000000939200720bULL, 0x002fc60003f7d000ULL,
0x0000001016167824ULL, 0x000fe400078e0223ULL, 0x00000021008b7306ULL, 0x000fe60000205400ULL,
0x000000001630783bULL, 0x0002aa0000000200ULL, 0x0000002c00e37306ULL, 0x000e620000005400ULL,
0x000000016d6d3812ULL, 0x008fce00078efcffULL, 0x0000002100167306ULL, 0x0023f0000020d400ULL,
0x0000002c006c7306ULL, 0x0006a2000000d400ULL, 0x000100002c217824ULL, 0x002fe200078e00ffULL,
0x000000e3f600720bULL, 0x000fc80003f1d000ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000001700c47306ULL, 0x000fe20000209400ULL, 0x000001002c2c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002100917306ULL, 0x000fe20000209400ULL,
0x000000016c6c0812ULL, 0x004fce00078efcffULL, 0x0000002100f27306ULL, 0x000e700000205400ULL,
0x0000002100a17306ULL, 0x0004f0000020d400ULL, 0x0000001700c57306ULL, 0x000ee20000205400ULL,
0x000100002e217824ULL, 0x004fe200078e00ffULL, 0x000000f29100720bULL, 0x002fc80003f3d000ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000017006f7306ULL, 0x000e6e000020d400ULL,
0x00000001a1a11812ULL, 0x008fe200078efcffULL, 0x0000001800c67306ULL, 0x000fe20000209400ULL,
0x000000c5c400720bULL, 0x000fc40003f3d000ULL, 0x0000000806c57812ULL, 0x000fe400078ec0ffULL,
0x0000006ca16c723eULL, 0x000fe400000010ffULL, 0x00000007c5c57812ULL, 0x000fe200078ef806ULL,
0x0000001800cf7306ULL, 0x000eac0000205400ULL, 0x000000016f6f1812ULL, 0x002fc400078efcffULL,
0x0000001800b17306ULL, 0x000e70000020d400ULL, 0x0000001900bf7306ULL, 0x000fe20000209400ULL,
0x000000cfc600720bULL, 0x004fe40003f1d000ULL, 0x00000004ffc67819ULL, 0x000fca0000011606ULL,
0x0000001900c27306ULL, 0x000ea20000205400ULL, 0x0000000211c67824ULL, 0x040fe200078e02c6ULL,
0x0000000211117810ULL, 0x000fc80007ffe0ffULL, 0x00000001b1b10812ULL, 0x002fe400078efcffULL,
0x0000001900b47306ULL, 0x000e70000020d400ULL, 0x0000002200177306ULL, 0x000fe20000209400ULL,
0x000000c2bf00720bULL, 0x004fc40003f7d000ULL, 0x00000010c5bf7812ULL, 0x000fca00078efcffULL,
0x0000002200187306ULL, 0x000fec0000205400ULL, 0x00000001b4b43812ULL, 0x002fe400078efcffULL,
0x0000002200197306ULL, 0x0003f0000020d400ULL, 0x0000002c00ce7306ULL, 0x000fe20000209400ULL,
0x000100002d227824ULL, 0x002fca00078e00ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000002c00f37306ULL, 0x000e700000205400ULL, 0x0000002c00a07306ULL, 0x0004f0000020d400ULL,
0x0000002d00e47306ULL, 0x000fe20000009400ULL, 0x00000018ff2c7819ULL, 0x004fc40000011431ULL,
0x000000f3ce00720bULL, 0x002fca0003f5d000ULL, 0x0000002d00f77306ULL, 0x000e700000005400ULL,
0x0000002d006e7306ULL, 0x000462000000d400ULL, 0x00000001a0a02812ULL, 0x008fc800078efcffULL,
0x000000a06d6d723eULL, 0x000fc600000010ffULL, 0x0000002e00c17306ULL, 0x000fe20000009400ULL,
0x000001002d2d7824ULL, 0x004fe200078e00ffULL, 0x000000f7e400720bULL, 0x002fc80003f9d000ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002e00f47306ULL, 0x000e6e0000005400ULL,
0x000000016e6e4812ULL, 0x000fe200078efcffULL, 0x0000002e00dc7306ULL, 0x0004f0000000d400ULL,
0x0000002100947306ULL, 0x000fe20000209400ULL, 0x000001002e2e7824ULL, 0x004fe200078e00ffULL,
0x000000f4c100720bULL, 0x002fc80003fdd000ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000002100957306ULL, 0x000e6e0000205400ULL, 0x00000001dcdc6812ULL, 0x008fe200078efcffULL,
0x0000002100df7306ULL, 0x0004f0000020d400ULL, 0x0000002c00b77306ULL, 0x000fe20000209400ULL,
0x00000018ff217819ULL, 0x004fc40000011430ULL, 0x000000959400720bULL, 0x002fca0003f9d000ULL,
0x0000002c00d67306ULL, 0x000ff00000205400ULL, 0x0000002c00997306ULL, 0x0003e2000020d400ULL,
0x00000001dfdf4812ULL, 0x008fce00078efcffULL, 0x0000002200d37306ULL, 0x000fe20000209400ULL,
0x00000008742c7824ULL, 0x002fe400078e00ffULL, 0x0001000037747824ULL, 0x000fc600078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe400078ee275ULL, 0x0000002200f07306ULL, 0x000e660000205400ULL,
0x000000102c2c7824ULL, 0x000fca00078e0223ULL, 0x0000002200a37306ULL, 0x0004f0000020d400ULL,
0x0000002f00907306ULL, 0x000fe20000009400ULL, 0x000100002f227824ULL, 0x004fe200078e00ffULL,
0x000000f0d300720bULL, 0x002fc80003f5d000ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000002f00f57306ULL, 0x000e6e0000005400ULL, 0x00000001a3a32812ULL, 0x008fe200078efcffULL,
0x0000002f00d07306ULL, 0x0004e6000000d400ULL, 0x0000006ea36e723eULL, 0x000fca00000010ffULL,
0x0000002100e17306ULL, 0x000fe20000209400ULL, 0x000001002f2f7824ULL, 0x004fe200078e00ffULL,
0x000000f59000720bULL, 0x002fc80003fbd000ULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000002100e27306ULL, 0x000e6e0000205400ULL, 0x00000001d0d05812ULL, 0x008fe200078efcffULL,
0x00000021009f7306ULL, 0x0004f0000020d400ULL, 0x0000002d00d47306ULL, 0x000fe20000209400ULL,
0x0001000034217824ULL, 0x004fe200078e00ffULL, 0x000000e2e100720bULL, 0x002fcc0003fbd000ULL,
0x0000002d00f17306ULL, 0x000e6e0000205400ULL, 0x000000019f9f5812ULL, 0x008fe200078efcffULL,
0x0000002d00e87306ULL, 0x0004f0000020d400ULL, 0x0000002e00967306ULL, 0x000fe20000209400ULL,
0x00000018ff2d7819ULL, 0x004fc40000011433ULL, 0x000000f1d400720bULL, 0x002fca0003f5d000ULL,
0x0000002e00ef7306ULL, 0x000e700000205400ULL, 0x0000002e00de7306ULL, 0x000462000020d400ULL,
0x00000001e8e82812ULL, 0x008fc800078efcffULL, 0x000000e86f6f723eULL, 0x000fc600000010ffULL,
0x0000002f00a27306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x004fe40000011421ULL,
0x000000ef9600720bULL, 0x002fca0003f5d000ULL, 0x0000002f00eb7306ULL, 0x000e700000205400ULL,
0x0000002f00d57306ULL, 0x000ea2000020d400ULL, 0x00000001dede2812ULL, 0x000fce00078efcffULL,
0x0000002d00cc7306ULL, 0x000fe20000209400ULL, 0x000000eba200720bULL, 0x002fce0003f5d000ULL,
0x0000002d00cd7306ULL, 0x000fec0000205400ULL, 0x00000001d5d52812ULL, 0x004fe400078efcffULL,
0x0000002d009b7306ULL, 0x000ff0000020d400ULL, 0x0000002e00b97306ULL, 0x000ff00000209400ULL,
0x0000002e00ba7306ULL, 0x000ff00000205400ULL, 0x0000002e008d7306ULL, 0x0003f0000020d400ULL,
0x0000003400b67306ULL, 0x000fe20000009400ULL, 0x000000002c2c783bULL, 0x002e6e0000000200ULL,
0x0000003400b57306ULL, 0x000ff00000005400ULL, 0x00000034008c7306ULL, 0x0005f0000000d400ULL,
0x0000002200ed7306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x004fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000002200ee7306ULL, 0x000eb00000205400ULL,
0x0000003400b37306ULL, 0x000fe20000209400ULL, 0x000100002ca27824ULL, 0x002fca00078e00ffULL,
0x00000018ffeb7819ULL, 0x000fe400000114a2ULL, 0x0000003400b27306ULL, 0x000fe20000205400ULL,
0x000000eeed00720bULL, 0x004fce0003fdd000ULL, 0x0000003400217306ULL, 0x0003f0000020d400ULL,
0x0000002200d77306ULL, 0x0004e2000020d400ULL, 0x0001000036347824ULL, 0x002fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500ab7306ULL, 0x000fe20000009400ULL,
0x00000018ff227819ULL, 0x004fce0000011432ULL, 0x0000002200bd7306ULL, 0x000fe20000209400ULL,
0x00000001d7d76812ULL, 0x008fce00078efcffULL, 0x0000002200c07306ULL, 0x000ff00000205400ULL,
0x00000022009a7306ULL, 0x0003f0000020d400ULL, 0x0000003500a97306ULL, 0x000fe20000005400ULL,
0x0001000035227824ULL, 0x002fce00078e00ffULL, 0x0000003500127306ULL, 0x0003f0000000d400ULL,
0x00000034008e7306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000034008f7306ULL, 0x000ff00000205400ULL,
0x0000003400777306ULL, 0x0003f0000020d400ULL, 0x0000003000ec7306ULL, 0x000fe20000009400ULL,
0x00000018ff347819ULL, 0x002fce000001142cULL, 0x00000034007d7306ULL, 0x000ff00000209400ULL,
0x00000034007e7306ULL, 0x000ff00000205400ULL, 0x00000034007a7306ULL, 0x0003f0000020d400ULL,
0x0000003000977306ULL, 0x000ea20000005400ULL, 0x0001000030347824ULL, 0x002fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000030009e7306ULL, 0x0002f0000000d400ULL,
0x0000003500a77306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x002fe200078e00ffULL,
0x00000097ec00720bULL, 0x004fc80003f3d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003500a87306ULL, 0x000fee0000205400ULL, 0x000000019e9e1812ULL, 0x008fe200078efcffULL,
0x0000003500237306ULL, 0x0003e2000020d400ULL, 0x000000d6b700720bULL, 0x000fce0003f3d000ULL,
0x0000003000e57306ULL, 0x000fe20000209400ULL, 0x00000018ff357819ULL, 0x002fca0000011474ULL,
0x0000000199991812ULL, 0x000fe400078efcffULL, 0x0000003500797306ULL, 0x000ff00000209400ULL,
0x0000003500747306ULL, 0x000ff00000205400ULL, 0x0000003500887306ULL, 0x0003f0000020d400ULL,
0x0000003000e67306ULL, 0x000ea20000205400ULL, 0x00000018ff357819ULL, 0x002fce000001142eULL,
0x0000003000ca7306ULL, 0x0002f0000020d400ULL, 0x0000003500857306ULL, 0x000fe20000209400ULL,
0x0001000032307824ULL, 0x002fe200078e00ffULL, 0x000000e6e500720bULL, 0x004fc80003f5d000ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003500867306ULL, 0x000fee0000205400ULL,
0x00000001caca2812ULL, 0x008fe200078efcffULL, 0x0000003500817306ULL, 0x0003e6000020d400ULL,
0x000000ca9f9f723eULL, 0x000fca00000010ffULL, 0x00000031009d7306ULL, 0x000fe20000009400ULL,
0x0001000031357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000031009c7306ULL, 0x000e700000005400ULL, 0x0000003100987306ULL, 0x0004f0000000d400ULL,
0x0000003000db7306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x004fe200078e00ffULL,
0x0000009c9d00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000da7306ULL, 0x000e6e0000205400ULL, 0x0000000198984812ULL, 0x008fe200078efcffULL,
0x0000003000c77306ULL, 0x0004e2000020d400ULL, 0x000000cdcc00720bULL, 0x000fce0003f9d000ULL,
0x0000003300e37306ULL, 0x000fe20000009400ULL, 0x0001000033307824ULL, 0x004fe200078e00ffULL,
0x000000dadb00720bULL, 0x002fc80003fbd000ULL, 0x000000019b9b4812ULL, 0x000fe400078efcffULL,
0x0000003300e47306ULL, 0x000e6e0000005400ULL, 0x00000001c7c75812ULL, 0x008fe200078efcffULL,
0x0000003300c17306ULL, 0x0004f0000000d400ULL, 0x0000003100d97306ULL, 0x000fe20000209400ULL,
0x0000010033337824ULL, 0x004fe200078e00ffULL, 0x000000e4e300720bULL, 0x002fc80003f7d000ULL,
0x00000018fff07819ULL, 0x000fe20000011433ULL, 0x00000010c5337824ULL, 0x000fe200078e00ffULL,
0x0000003100d87306ULL, 0x000e6e0000205400ULL, 0x00000001c1c13812ULL, 0x008fe200078efcffULL,
0x0000003100c87306ULL, 0x0004e2000020d400ULL, 0x000000a9ab00720bULL, 0x000fce0003f7d000ULL,
0x0000003400e77306ULL, 0x000fe20000209400ULL, 0x00000018ff317819ULL, 0x004fe20000011430ULL,
0x00000001c5307824ULL, 0x000fe200078e02c6ULL, 0x000000d8d900720bULL, 0x002fc60003f5d000ULL,
0x0000000112123812ULL, 0x000fe400078efcffULL, 0x0000003400ea7306ULL, 0x000e620000205400ULL,
0xfffffff033307812ULL, 0x000fce00078ee230ULL, 0x0000003400cb7306ULL, 0x000462000020d400ULL,
0x00000001c8c82812ULL, 0x008fc800078efcffULL, 0x000000c89999723eULL, 0x000fc600000010ffULL,
0x0000003600ad7306ULL, 0x000fe20000009400ULL, 0x0000010032347824ULL, 0x004fe200078e00ffULL,
0x000000eae700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003600ac7306ULL, 0x000e6e0000005400ULL, 0x00000001cbcb6812ULL, 0x000fe200078efcffULL,
0x0000003600137306ULL, 0x0004e6000000d400ULL, 0x0000009ecb9e723eULL, 0x000fca00000010ffULL,
0x0000003700aa7306ULL, 0x000fe20000009400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x000000acad00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003700ae7306ULL, 0x000fee0000005400ULL, 0x0000000113134812ULL, 0x008fe200078efcffULL,
0x0000003700147306ULL, 0x0003f0000000d400ULL, 0x0000003200a67306ULL, 0x000fe20000009400ULL,
0x0000010037377824ULL, 0x002fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003200e97306ULL, 0x000e700000005400ULL, 0x0000003200b87306ULL, 0x0004f0000000d400ULL,
0x0000003100ce7306ULL, 0x000fe20000209400ULL, 0x00000010bf327824ULL, 0x004fe200078e00ffULL,
0x000000e9a600720bULL, 0x002fcc0003f1d000ULL, 0x0000003100cf7306ULL, 0x000e6e0000205400ULL,
0x00000001b8b80812ULL, 0x008fe200078efcffULL, 0x0000003100c47306ULL, 0x0004e2000020d400ULL,
0x000000bab900720bULL, 0x000fce0003f1d000ULL, 0x0000001b00af7306ULL, 0x000fe20000209400ULL,
0x00000001bf317824ULL, 0x004fe200078e02c6ULL, 0x000000cfce00720bULL, 0x002fe40003f3d000ULL,
0x00000002c6c67810ULL, 0x000fe40007ffe0ffULL, 0xfffffff032317812ULL, 0x000fe400078ee231ULL,
0x0000001b00b07306ULL, 0x000fe20000205400ULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000001031317824ULL, 0x000fc800078e00ffULL, 0x00000001c4c41812ULL, 0x008fe200078efcffULL,
0x0000001b00157306ULL, 0x000fe2000020d400ULL, 0x000000b5b600720bULL, 0x000fce0003f3d000ULL,
0x00000076001a7306ULL, 0x000fec0000209400ULL, 0x000000018c8c1812ULL, 0x000fe400078efcffULL,
0x00000076001b7306ULL, 0x000e620000205400ULL, 0x000000a8a700720bULL, 0x000fe40003f3d000ULL,
0x0000008c8d8c723eULL, 0x000fca00000010ffULL, 0x00000076001f7306ULL, 0x0004ec000020d400ULL,
0x0000000123231812ULL, 0x000fe400078efcffULL, 0x0000003600757306ULL, 0x000fe20000205400ULL,
0x00000018ff767819ULL, 0x004fe40000011422ULL, 0x0000001b1a00720bULL, 0x002fca0003f3d000ULL,
0x0000007600a47306ULL, 0x000ff00000209400ULL, 0x0000007600a57306ULL, 0x000e620000205400ULL,
0x000000011f1f1812ULL, 0x008fce00078efcffULL, 0x0000007600227306ULL, 0x000eb0000020d400ULL,
0x0000003600767306ULL, 0x000ee20000209400ULL, 0x000000a5a400720bULL, 0x002fce0003f1d000ULL,
0x0000003600787306ULL, 0x0002ec000020d400ULL, 0x0000000122220812ULL, 0x004fe400078efcffULL,
0x0000003700897306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x002fe4000001142dULL,
0x000000757600720bULL, 0x008fc40003f7d000ULL, 0x000000181700720bULL, 0x000fe40003f1d000ULL,
0x000000122222723eULL, 0x000fe200000010ffULL, 0x00000037007f7306ULL, 0x000e700000205400ULL,
0x00000037007c7306ULL, 0x0004e2000020d400ULL, 0x0000000178783812ULL, 0x000fc400078efcffULL,
0x0000000119190812ULL, 0x000fc800078efcffULL, 0x000000781919723eULL, 0x000fe200000010ffULL,
0x0000003400d17306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x004fe4000001142fULL,
0x0000007f8900720bULL, 0x002fca0003f7d000ULL, 0x0000003400d27306ULL, 0x000e700000205400ULL,
0x0000003400c37306ULL, 0x000462000020d400ULL, 0x000000017c7c3812ULL, 0x008fce00078efcffULL,
0x00000036007b7306ULL, 0x000fe20000209400ULL, 0x0000001030347824ULL, 0x004fe200078e00ffULL,
0x000000d2d100720bULL, 0x002fe20003f5d000ULL, 0x000000003130783bULL, 0x000e6a0000000200ULL,
0x0000003600877306ULL, 0x000fee0000205400ULL, 0x00000001c3c32812ULL, 0x000fe200078efcffULL,
0x0000003600827306ULL, 0x000fe2000020d400ULL, 0x000000b2b300720bULL, 0x000fce0003f5d000ULL,
0x0000003700837306ULL, 0x000fec0000209400ULL, 0x0000000121212812ULL, 0x000fe400078efcffULL,
0x0000003700847306ULL, 0x000fe20000205400ULL, 0x0000008b8a00720bULL, 0x000fce0003f5d000ULL,
0x0000003700807306ULL, 0x000fe2000020d400ULL, 0x0000006e305c723cULL, 0x042fea000004185cULL,
0x0000000116162812ULL, 0x000fe400078efcffULL, 0x0000003500dd7306ULL, 0x000fe40000209400ULL,
0x000000231623723eULL, 0x000fe200000010ffULL, 0x0000006c3064723cULL, 0x040fea0000041864ULL,
0x0000003500e07306ULL, 0x000e660000205400ULL, 0x0000009e303c723cULL, 0x000fea000004183cULL,
0x0000003500c97306ULL, 0x0004f0000020d400ULL, 0x000000f000d37306ULL, 0x000fe20000209400ULL,
0x000000003434783bULL, 0x004ea20000000200ULL, 0x000000e0dd00720bULL, 0x002fcc0003fdd000ULL,
0x000000f000d47306ULL, 0x000e6e0000205400ULL, 0x00000001c9c96812ULL, 0x008fe200078efcffULL,
0x000000f000c27306ULL, 0x000ee2000020d400ULL, 0x000000c0bd00720bULL, 0x000fe40003fdd000ULL,
0x00000098c998723eULL, 0x000fc400000010ffULL, 0x000000d4d300720bULL, 0x002fc60003fbd000ULL,
0x0000002c00907306ULL, 0x000fe40000009400ULL, 0x000000983038723cULL, 0x000fe80000041838ULL,
0x000000019a9a6812ULL, 0x000fe400078efcffULL, 0x000000b0af00720bULL, 0x000fe20003fdd000ULL,
0x0000002c00917306ULL, 0x000e620000005400ULL, 0x00000001c2c25812ULL, 0x008fc400078efcffULL,
0x000000aeaa00720bULL, 0x000fe20003fbd000ULL, 0x0000006e3460723cULL, 0x004be80000041860ULL,
0x0000002c00927306ULL, 0x0004e2000000d400ULL, 0x000000c29b9b723eULL, 0x000fc600000010ffULL,
0x0000000115156812ULL, 0x000fe400078efcffULL, 0x0000008f8e00720bULL, 0x000fe40003fdd000ULL,
0x000000d0d76e723eULL, 0x020fe200000010ffULL, 0x0000006c3468723cULL, 0x000be20000041868ULL,
0x000000d5b46f723eULL, 0x000fe200000010ffULL, 0x000001002c2c7824ULL, 0x004fe200078e00ffULL,
0x0000002d00937306ULL, 0x000fe20000009400ULL, 0x0000000114145812ULL, 0x000fe400078efcffULL,
0x000000919000720bULL, 0x002fc40003f5d000ULL, 0x000000dcdf6c723eULL, 0x020fe200000010ffULL,
0x0000006e3450723cULL, 0x080fe20000041850ULL, 0x000000deb16d723eULL, 0x000fe200000010ffULL,
0x0000002d00947306ULL, 0x000e620000005400ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000000177776812ULL, 0x000fe400078efcffULL, 0x000000747900720bULL, 0x000fe20003fdd000ULL,
0x0000006e304c723cULL, 0x000be2000004184cULL, 0x0000007e7d00720bULL, 0x000fe20003fbd000ULL,
0x0000002d00957306ULL, 0x0005e2000000d400ULL, 0x000000137718723eULL, 0x000fc400000010ffULL,
0x00000021158d723eULL, 0x000fe400000010ffULL, 0x00000010c56e7824ULL, 0x060fe200078e00ffULL,
0x0000006c3458723cULL, 0x080fe20000041858ULL, 0x00000001c5c57824ULL, 0x100fe200078e02c6ULL,
0x0000002c00b17306ULL, 0x000fe20000209400ULL, 0x00000001bfc67824ULL, 0x040fe200078e02c6ULL,
0x0000000188886812ULL, 0x000fe200078efcffULL, 0x00000010bfbf7824ULL, 0x000fe200078e00ffULL,
0xfffffff06ec57812ULL, 0x000fe400078ee2c5ULL, 0x0000006c3054723cULL, 0x000b620000041854ULL,
0x0000000192922812ULL, 0x008fe200078efcffULL, 0x0000002c00b77306ULL, 0x000ee20000205400ULL,
0xfffffff0bfc67812ULL, 0x000fc400078ee2c6ULL, 0x000000017a7a5812ULL, 0x000fe400078efcffULL,
0x000100002d6c7824ULL, 0x060fe200078e00ffULL, 0x0000009e3448723cULL, 0x040f620000041848ULL,
0x000001002d6d7824ULL, 0x000fe200078e00ffULL, 0x0000002c00b47306ULL, 0x0006e2000020d400ULL,
0x000000c39a2d723eULL, 0x004fe400000010ffULL, 0x000000c1c49a723eULL, 0x000fe400000010ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x000000983444723cULL, 0x000b620000041844ULL,
0x000000949300720bULL, 0x002fe20003f9d000ULL, 0x000000eb00a27306ULL, 0x000fe20000209400ULL,
0x000000b8c72c723eULL, 0x008fc400000010ffULL, 0x00000018ffc77819ULL, 0x000fe4000001146dULL,
0x000000b7b100720bULL, 0x000fe20003f7d000ULL, 0x0000009a3470723cULL, 0x040fe20000041870ULL,
0x000100002f987824ULL, 0x020fe200078e00ffULL, 0x0000006c00bd7306ULL, 0x000fe20000209400ULL,
0x000000148814723eULL, 0x000fe400000010ffULL, 0x0000007c1f15723eULL, 0x000fe400000010ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x0000002c3440723cULL, 0x000b620000041840ULL,
0x0000000195954812ULL, 0x000fe200078efcffULL, 0x0000006c00c07306ULL, 0x000e620000205400ULL,
0x000000848300720bULL, 0x000fc40003f9d000ULL, 0x00000001b4b43812ULL, 0x000fe400078efcffULL,
0x000100002e357824ULL, 0x020fe200078e00ffULL, 0x0000002c3024723cULL, 0x040b620000041824ULL,
0x00000010c6347824ULL, 0x000fe200078e00ffULL, 0x0000006c00b87306ULL, 0x0004e2000020d400ULL,
0x000000877b00720bULL, 0x000fe40003f7d000ULL, 0x00000018ffb57819ULL, 0x000fe40000011435ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000009a3028723cULL, 0x000f620000041828ULL,
0x0000000180804812ULL, 0x000fe200078efcffULL, 0x000000eb00a37306ULL, 0x000ee20000205400ULL,
0x00000010c56c7824ULL, 0x004fe200078e00ffULL, 0x000000c0bd00720bULL, 0x002fc40003f3d000ULL,
0x000000b47a93723eULL, 0x000fe400000010ffULL, 0x0000000182823812ULL, 0x000fe200078efcffULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x000000c700c37306ULL, 0x000fee0000209400ULL,
0x00000001b8b81812ULL, 0x008fe200078efcffULL, 0x000000c700c27306ULL, 0x000ea20000205400ULL,
0x000000a3a200720bULL, 0x000fc40003fdd000ULL, 0x000000868500720bULL, 0x000fe40003f3d000ULL,
0x00000095b8b8723eULL, 0x000fc600000010ffULL, 0x000000b5009e7306ULL, 0x000ff00000209400ULL,
0x000000b500997306ULL, 0x000ee20000205400ULL, 0x000000c2c300720bULL, 0x004fe40003f5d000ULL,
0x0000000181811812ULL, 0x000fe200078efcffULL, 0x000000183454723cULL, 0x040f680000041854ULL,
0x0000002e00967306ULL, 0x000fe80000009400ULL, 0x0000008c3464723cULL, 0x000f680000041864ULL,
0x0000002e00977306ULL, 0x000ea20000005400ULL, 0x000000999e00720bULL, 0x008fc60003fbd000ULL,
0x000000186c58723cULL, 0x042b680000041858ULL, 0x0000002e009c7306ULL, 0x0002e8000000d400ULL,
0x0000008c6c68723cULL, 0x000b680000041868ULL, 0x0000002f009d7306ULL, 0x000fe20000009400ULL,
0x000001002e2e7824ULL, 0x002fe200078e00ffULL, 0x000000979600720bULL, 0x004fc40003f1d000ULL,
0x000000226c60723cULL, 0x080b640000041860ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000002f00a07306ULL, 0x000fe80000005400ULL, 0x00000022345c723cULL, 0x000b66000004185cULL,
0x000000019c9c0812ULL, 0x008fe200078efcffULL, 0x0000002f00a17306ULL, 0x0003e2000000d400ULL,
0x000000081100780cULL, 0x000fc60003f05270ULL, 0x000000146c50723cULL, 0x000b680000041850ULL,
0x000000eb00a67306ULL, 0x000ea2000020d400ULL, 0x000001002f2f7824ULL, 0x002fc600078e00ffULL,
0x00000014344c723cULL, 0x000b64000004184cULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x000000c700bf7306ULL, 0x000e70000020d400ULL, 0x000000b5002d7306ULL, 0x020ee2000020d400ULL,
0x00000001a6a66812ULL, 0x004fc400078efcffULL, 0x000000a09d00720bULL, 0x000fe40003fdd000ULL,
0x00000092a692723eULL, 0x000fc600000010ffULL, 0x0000002e00217306ULL, 0x000fe20000209400ULL,
0x00000001bfbf2812ULL, 0x002fc600078efcffULL, 0x000000926c48723cULL, 0x000b620000041848ULL,
0x000000bf82b9723eULL, 0x000fc600000010ffULL, 0x0000002e001a7306ULL, 0x000e620000205400ULL,
0x000000012d2d5812ULL, 0x008fe400078efcffULL, 0x00000001a1a16812ULL, 0x000fe200078efcffULL,
0x000000b86c44723cULL, 0x000b620000041844ULL, 0x0000009c2d9c723eULL, 0x000fc600000010ffULL,
0x0000009800167306ULL, 0x000fe80000209400ULL, 0x00000092343c723cULL, 0x000b68000004183cULL,
0x0000009800137306ULL, 0x000ea20000205400ULL, 0x0000001a2100720bULL, 0x002fc60003f5d000ULL,
0x000000b83438723cULL, 0x000b680000041838ULL, 0x0000002f00177306ULL, 0x000ff00000209400ULL,
0x0000002f00187306ULL, 0x000e620000205400ULL, 0x000000131600720bULL, 0x004fce0003f7d000ULL,
0x0000002e00127306ULL, 0x000eb0000020d400ULL, 0x0000009800987306ULL, 0x000ee2000020d400ULL,
0x000000181700720bULL, 0x002fce0003fbd000ULL, 0x0000002f00997306ULL, 0x000e62000020d400ULL,
0x0000000112122812ULL, 0x004fc800078efcffULL, 0x00000012819d723eULL, 0x000fe400000010ffULL,
0x0000000198983812ULL, 0x008fc800078efcffULL, 0x000000a19898723eULL, 0x000fe200000010ffULL,
0x0000009c6c40723cULL, 0x000b620000041840ULL, 0x0000000199995812ULL, 0x002fc800078efcffULL,
0x000000998099723eULL, 0x000fc600000010ffULL, 0x0000009c3424723cULL, 0x000b700000041824ULL,
0x000000986c70723cULL, 0x080b700000041870ULL, 0x000000983428723cULL, 0x000b620000041828ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffdf5000007947ULL, 0x000fcc000383ffffULL,
0x0000000759597220ULL, 0x080fe40000410000ULL, 0x0000000760607220ULL, 0x000fc40000410000ULL,
0x0000000761617220ULL, 0x080fe40000410000ULL, 0x0000000758587220ULL, 0x080fe40000410000ULL,
0x0000000750507220ULL, 0x080fe40000410000ULL, 0x0000000744447220ULL, 0x0a0fe40000410000ULL,
0x0000000751517220ULL, 0x080fe40000410000ULL, 0x0000000748487220ULL, 0x000fc40000410000ULL,
0x0000000749497220ULL, 0x080fe40000410000ULL, 0x000000074b4b7220ULL, 0x080fe40000410000ULL,
0x0000000745457220ULL, 0x080fe40000410000ULL, 0x0000000741417220ULL, 0x080fe40000410000ULL,
0x0000000742427220ULL, 0x080fe40000410000ULL, 0x0000000743437220ULL, 0x000fc40000410000ULL,
0x000000073c3c7220ULL, 0x080fe40000410000ULL, 0x000000073d3d7220ULL, 0x080fe40000410000ULL,
0x0000000768687220ULL, 0x080fe40000410000ULL, 0x0000000769697220ULL, 0x080fe40000410000ULL,
0x000000076a6a7220ULL, 0x080fe40000410000ULL, 0x000000076b6b7220ULL, 0x000fc40000410000ULL,
0x0000000762627220ULL, 0x080fe40000410000ULL, 0x0000000763637220ULL, 0x080fe40000410000ULL,
0x000000075a0b7220ULL, 0x080fe40000410000ULL, 0x000000075b117220ULL, 0x080fe40000410000ULL,
0x0000000752127220ULL, 0x080fe40000410000ULL, 0x0000000753137220ULL, 0x000fc40000410000ULL,
0x000000074a147220ULL, 0x080fe40000410000ULL, 0x0000000746157220ULL, 0x080fe40000410000ULL,
0x0000000747167220ULL, 0x080fe40000410000ULL, 0x0000000740407220ULL, 0x080fe40000410000ULL,
0x0000000772727220ULL, 0x080fe40000410000ULL, 0x0000000773737220ULL, 0x000fc40000410000ULL,
0x000000074c177220ULL, 0x080fe40000410000ULL, 0x000000074d187220ULL, 0x080fe40000410000ULL,
0x0000000738197220ULL, 0x080fe40000410000ULL, 0x00000007391a7220ULL, 0x080fe40000410000ULL,
0x0000000724247220ULL, 0x080fe40000410000ULL, 0x000000075c347220ULL, 0x000fc40000410000ULL,
0x000000075d357220ULL, 0x080fe40000410000ULL, 0x0000000757217220ULL, 0x080fe40000410000ULL,
0x000000ffff5a7224ULL, 0x000fe400078e0059ULL, 0x0000000754367220ULL, 0x080fe40000410000ULL,
0x00000007561f7220ULL, 0x080fe40000410000ULL, 0x000000073a227220ULL, 0x000fc40000410000ULL,
0x000000073b237220ULL, 0x000fe40000410000ULL, 0x000000ffff5d7224ULL, 0x000fe400078e0060ULL,
0x000000ffff5c7224ULL, 0x000fe400078e0061ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0058ULL,
0x000000ffff597224ULL, 0x000fe400078e0050ULL, 0x000000ffff577224ULL, 0x000fc400078e0044ULL,
0x0000000764337220ULL, 0x080fe40000410000ULL, 0x0000000765327220ULL, 0x080fe40000410000ULL,
0x000000075e1b7220ULL, 0x080fe40000410000ULL, 0x000000075f307220ULL, 0x080fe40000410000ULL,
0x0000000755377220ULL, 0x080fe40000410000ULL, 0x000000074e2f7220ULL, 0x000fc40000410000ULL,
0x000000074f2d7220ULL, 0x080fe40000410000ULL, 0x000000073e2e7220ULL, 0x080fe40000410000ULL,
0x000000073f2c7220ULL, 0x000fe40000410000ULL, 0x000000ffff607224ULL, 0x000fe400078e0051ULL,
0x000000ffff617224ULL, 0x000fe400078e0048ULL, 0x000000ffff587224ULL, 0x000fc400078e0049ULL,
0x000000ffff567224ULL, 0x000fe400078e0045ULL, 0x000000ffff547224ULL, 0x000fe400078e0041ULL,
0x000000ffff507224ULL, 0x000fe400078e004bULL, 0x000000ffff4c7224ULL, 0x000fe400078e0042ULL,
0x000000ffff447224ULL, 0x000fe400078e0043ULL, 0x000000ffff3a7224ULL, 0x000fc400078e003cULL,
0x000000ffff3b7224ULL, 0x000fe400078e003dULL, 0x0000000770537220ULL, 0x080fe40000410000ULL,
0x0000000771527220ULL, 0x080fe40000410000ULL, 0x0000000766667220ULL, 0x080fe40000410000ULL,
0x0000000767317220ULL, 0x080fe40000410000ULL, 0x00000007253e7220ULL, 0x000fc40000410000ULL,
0x0000000726647220ULL, 0x080fe40000410000ULL, 0x0000000727657220ULL, 0x080fe40000410000ULL,
0x00000007283f7220ULL, 0x080fe40000410000ULL, 0x0000000729297220ULL, 0x080fe40000410000ULL,
0x000000072a2a7220ULL, 0x080fe40000410000ULL, 0x000000072b2b7220ULL, 0x000fc40000410000ULL,
0x000000ffff5f7224ULL, 0x000fe400078e0068ULL, 0x000000ffff5e7224ULL, 0x000fe400078e0069ULL,
0x000000ffff557224ULL, 0x000fe400078e0040ULL, 0x000000ffff4e7224ULL, 0x000fe400078e006aULL,
0x000000ffff4d7224ULL, 0x000fe400078e006bULL, 0x000000ffff457224ULL, 0x000fc400078e0062ULL,
0x000000ffff477224ULL, 0x000fe400078e0063ULL, 0x000000ffff467224ULL, 0x000fe400078e000bULL,
0x000000ffff517224ULL, 0x000fe400078e0011ULL, 0x000000ffff487224ULL, 0x000fe400078e0012ULL,
0x000000ffff4a7224ULL, 0x000fe400078e0013ULL, 0x000000ffff497224ULL, 0x000fc400078e0014ULL,
0x000000ffff4b7224ULL, 0x000fe400078e0015ULL, 0x000000ffff4f7224ULL, 0x000fe400078e0016ULL,
0x000000ffff437224ULL, 0x000fe400078e0072ULL, 0x000000ffff427224ULL, 0x000fe400078e0073ULL,
0x000000ffff387224ULL, 0x000fe400078e0017ULL, 0x000000ffff397224ULL, 0x000fc400078e0018ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0019ULL, 0x000000ffff3d7224ULL, 0x000fe400078e001aULL,
0x000000ffff417224ULL, 0x000fe200078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000008167f8cULL, 0x0002a2000c80043fULL, 0x000000ffff407224ULL, 0x000fe400078e0029ULL,
0x000000ffff257224ULL, 0x000fe400078e001fULL, 0x000000ffff277224ULL, 0x000fc400078e0021ULL,
0x000000ffff247224ULL, 0x000fe400078e0066ULL, 0x000000ffff267224ULL, 0x000fe400078e001bULL,
0x000000ffff1f7224ULL, 0x000fe400078e0022ULL, 0x000000ffff217224ULL, 0x000fe400078e0023ULL,
0x000000ffff287224ULL, 0x000fe400078e0064ULL, 0x000000ffff297224ULL, 0x000fc400078e0065ULL,
0x0000000000127805ULL, 0x002fca0000015200ULL, 0x00000400080b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x006fc40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011415ULL, 0x000000140b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x000000020b0b7819ULL, 0x000fc80000001214ULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400080b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000406117824ULL, 0x000fe200078e00ffULL,
0x0000000e0a00720cULL, 0x000fc80003f06070ULL, 0xfffffff0110b7812ULL, 0x000fca00078ec0ffULL,
0x00000080200b7824ULL, 0x000fca00078e020bULL, 0x01a400000b147984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x000001000a137824ULL, 0x000fe200078e0202ULL,
0x0000000006127211ULL, 0x040fe200078ff0ffULL, 0x0000000206677824ULL, 0x000fe400078e00ffULL,
0x00000002ff7a7424ULL, 0x000fe200078e00ffULL, 0x000000131e667217ULL, 0x000fe40007800000ULL,
0x0000000667677812ULL, 0x000fe400078ec0ffULL, 0x0000000812187810ULL, 0x000fe20007ffe0ffULL,
0x0000000166667824ULL, 0x000fe200078e0a13ULL, 0x00005a00ff137a19ULL, 0x000fe20000011612ULL,
0x000000010d197824ULL, 0x000fe200078e0267ULL, 0x0000580067697a10ULL, 0x000fc40007ffe0ffULL,
0x00000010121a7810ULL, 0x040fe40007ffe0ffULL, 0x000000661900720cULL, 0x0c0fe20003f26070ULL,
0x0000000119197824ULL, 0x100fe200078e0a66ULL, 0x0000001812627810ULL, 0x000fe40007ffe0ffULL,
0x000000130c127217ULL, 0x040fe20003800000ULL, 0x0000000169137824ULL, 0x040fe200078e0a66ULL,
0x000000190c197217ULL, 0x040fe40003800000ULL, 0x000000666900720cULL, 0x000fe20003f06070ULL,
0x000000120f897224ULL, 0x000fe200078e02ffULL, 0x000000130c137217ULL, 0x000fc40003800000ULL,
0x00000004ff197819ULL, 0x000fe40000011619ULL, 0x00005a00ff1b7a19ULL, 0x000fe40000011618ULL,
0x000000ff13787207ULL, 0x000fe40000000000ULL, 0x000000ff19227207ULL, 0x000fe40000800000ULL,
0x0000001b0c187217ULL, 0x000fe40003800000ULL, 0x00005a00ff237a19ULL, 0x000fe2000001161aULL,
0x0000000189197824ULL, 0x000fe200078e0222ULL, 0x0000008978137211ULL, 0x000fe200078fe0ffULL,
0x000000180f8f7224ULL, 0x000fe200078e02ffULL, 0x00005a00ff637a19ULL, 0x000fe20000011662ULL,
0x0000600019187625ULL, 0x000fe200078e007aULL, 0x000000230c627217ULL, 0x000fc40003800000ULL,
0x000000630c647217ULL, 0x000fe20003800000ULL, 0x0000600013127625ULL, 0x000fe200078e007aULL,
0x00000008186b7981ULL, 0x0046a2000c1e9500ULL, 0x0000008f781b7211ULL, 0x000fe400078fe0ffULL,
0x000000620f917224ULL, 0x040fe200078e02ffULL, 0x0000000812687981ULL, 0x0002a2000c1e9500ULL,
0x000000640f937224ULL, 0x000fe200078e02ffULL, 0x0000001067757812ULL, 0x000fe200078efcffULL,
0x0000000122237824ULL, 0x000fe200078e028fULL, 0x0000009178637211ULL, 0x000fe200078fe0ffULL,
0x00000001226d7824ULL, 0x000fc400078e0291ULL, 0x000060001b1a7625ULL, 0x000fe200078e007aULL,
0x0000580075737a10ULL, 0x000fc60007ffe0ffULL, 0x00000001226f7824ULL, 0x000fe200078e0293ULL,
0x000000081a6a7981ULL, 0x0006a2000c1e9500ULL, 0x0000600063627625ULL, 0x000fc800078e007aULL,
0x0000600023227625ULL, 0x080fe200078e007aULL, 0x00000008626c7981ULL, 0x0006a6000c1e9500ULL,
0x000060006d127625ULL, 0x002fc800078e007aULL, 0x000000010d777824ULL, 0x000fe200078e0275ULL,
0x0000000812717981ULL, 0x0002a2000c1e9500ULL, 0x000060006f1a7625ULL, 0x008fc600078e007aULL,
0x00000008226f7981ULL, 0x0006a2000c1e9500ULL, 0x0000000177797824ULL, 0x100fe400078e0a66ULL,
0x0000000173197824ULL, 0x040fe200078e0a66ULL, 0x0000009378657211ULL, 0x000fe200078fe0ffULL,
0x000000081a6e7981ULL, 0x0002a2000c1e9500ULL, 0x000000790c797217ULL, 0x040fe40003800000ULL,
0x000000667300720cULL, 0x000fe40003f06070ULL, 0x000000190c197217ULL, 0x000fe20003800000ULL,
0x0000600065647625ULL, 0x000fe200078e007aULL, 0x000000667700720cULL, 0x000fc40003f26070ULL,
0x00000004ff797819ULL, 0x000fe40000011679ULL, 0x000000ff19807207ULL, 0x000fe20000000000ULL,
0x00000008646d7981ULL, 0x0002a2000c1e9500ULL, 0x000000ff79227207ULL, 0x008fe40000800000ULL,
0x0000008980137211ULL, 0x042fe400078fe0ffULL, 0x0000008f801b7211ULL, 0x000fe200078fe0ffULL,
0x0000000189197824ULL, 0x000fe200078e0222ULL, 0x00000020677d7812ULL, 0x000fe200078efcffULL,
0x0000000122237824ULL, 0x000fc400078e028fULL, 0x0000600013127625ULL, 0x000fc800078e007aULL,
0x0000000122797824ULL, 0x040fe200078e0291ULL, 0x0000000812707981ULL, 0x0002e2000c1e9500ULL,
0x00000001227b7824ULL, 0x000fe400078e0293ULL, 0x000060001b1a7625ULL, 0x000fe200078e007aULL,
0x000058007d7f7a10ULL, 0x000fc60007ffe0ffULL, 0x0000600019187625ULL, 0x080fe200078e007aULL,
0x000000081a727981ULL, 0x0002e6000c1e9500ULL, 0x0000600023227625ULL, 0x080fe200078e007aULL,
0x0000000818777981ULL, 0x0002e6000c1e9500ULL, 0x000000010d837824ULL, 0x000fe400078e027dULL,
0x0000600079127625ULL, 0x002fc400078e007aULL, 0x0000000822797981ULL, 0x0002e4000c1e9500ULL,
0x0000000183857824ULL, 0x100fe200078e0a66ULL, 0x0000009180637211ULL, 0x040fe200078fe0ffULL,
0x000000017f197824ULL, 0x000fe200078e0a66ULL, 0x0000009380657211ULL, 0x000fe400078fe0ffULL,
0x000000850c857217ULL, 0x040fe20003800000ULL, 0x0000600063627625ULL, 0x000fe200078e007aULL,
0x000000667f00720cULL, 0x000fe40003f06070ULL, 0x000000190c197217ULL, 0x000fe20003800000ULL,
0x0000600065647625ULL, 0x000fe200078e007aULL, 0x000000668300720cULL, 0x000fe20003f26070ULL,
0x0000000862747981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff857819ULL, 0x000fe20000011685ULL,
0x000060007b1a7625ULL, 0x000fe200078e007aULL, 0x000000ff19867207ULL, 0x000fe20000000000ULL,
0x0000000864767981ULL, 0x0002e2000c1e9500ULL, 0x000000ff85187207ULL, 0x000fc60000800000ULL,
0x00000008127b7981ULL, 0x0002e8000c1e9500ULL, 0x000000081a817981ULL, 0x0002e4000c1e9500ULL,
0x0000008f86657211ULL, 0x042fe400078fe0ffULL, 0x0000008986137211ULL, 0x000fe200078fe0ffULL,
0x00000001181b7824ULL, 0x000fe400078e028fULL, 0x0000600065647625ULL, 0x000fc800078e007aULL,
0x000060001b1a7625ULL, 0x080fe200078e007aULL, 0x00000008647e7981ULL, 0x0002e6000c1e9500ULL,
0x0000600013127625ULL, 0x080fe200078e007aULL, 0x000000081ad17981ULL, 0x0002e6000c1e9500ULL,
0x0000000118857824ULL, 0x000fe200078e0293ULL, 0x00000008127c7981ULL, 0x0002e2000c1e9500ULL,
0x0000000189837824ULL, 0x000fe200078e0218ULL, 0x0000009186637211ULL, 0x000fe200078fe0ffULL,
0x0000000118197824ULL, 0x000fe200078e0291ULL, 0x0000009386237211ULL, 0x000fe200078fe0ffULL,
0x0000600083827625ULL, 0x000fc800078e007aULL, 0x0000600085127625ULL, 0x082fe200078e007aULL,
0x0000003067857812ULL, 0x000fe200078efcffULL, 0x0000000882837981ULL, 0x0002e4000c1e9500ULL,
0x0000600063627625ULL, 0x080fe200078e007aULL, 0x0000580085877a10ULL, 0x000fe20007ffe0ffULL,
0x0000000812d97981ULL, 0x0002e4000c1e9500ULL, 0x0000600023227625ULL, 0x000fc800078e007aULL,
0x0000600019187625ULL, 0x000fe200078e007aULL, 0x0000000862827981ULL, 0x0022e6000c1e9500ULL,
0x000000010d8b7824ULL, 0x000fe200078e0285ULL, 0x0000000822847981ULL, 0x0002e6000c1e9500ULL,
0x000000018b8d7824ULL, 0x100fe200078e0a66ULL, 0x0000000818d57981ULL, 0x0002e2000c1e9500ULL,
0x0000000187657824ULL, 0x000fc600078e0a66ULL, 0x0000008d0c8d7217ULL, 0x040fe40003800000ULL,
0x000000668b00720cULL, 0x080fe40003f26070ULL, 0x000000668700720cULL, 0x000fe40003f06070ULL,
0x000000650c657217ULL, 0x000fe40003800000ULL, 0x00000004ff8d7819ULL, 0x000fe4000001168dULL,
0x000000ff65887207ULL, 0x000fc40000000000ULL, 0x000000ff8d8a7207ULL, 0x000fe40000800000ULL,
0x0000008988637211ULL, 0x042fe400078fe0ffULL, 0x0000009188197211ULL, 0x000fe200078fe0ffULL,
0x0000000189657824ULL, 0x000fe400078e028aULL, 0x000000018a237824ULL, 0x000fe400078e0291ULL,
0x0000600063627625ULL, 0x000fc800078e007aULL, 0x0000600065647625ULL, 0x080fe200078e007aULL,
0x0000000862b97981ULL, 0x0002e6000c1e9500ULL, 0x0000600019187625ULL, 0x080fe200078e007aULL,
0x00000008648c7981ULL, 0x0002e6000c1e9500ULL, 0x0000600023227625ULL, 0x000fe200078e007aULL,
0x0000000818d77981ULL, 0x0002e2000c1e9500ULL, 0x0000008f88137211ULL, 0x000fc600078fe0ffULL,
0x0000000822907981ULL, 0x0002e2000c1e9500ULL, 0x000000018a1b7824ULL, 0x000fe400078e028fULL,
0x0000600013127625ULL, 0x000fc800078e007aULL, 0x000060001b1a7625ULL, 0x080fe200078e007aULL,
0x0000000812d37981ULL, 0x0002e4000c1e9500ULL, 0x0000009388637211ULL, 0x002fe400078fe0ffULL,
0x000000081a8e7981ULL, 0x0002e2000c1e9500ULL, 0x000000018a657824ULL, 0x000fe400078e0293ULL,
0x0000600063627625ULL, 0x000fc800078e007aULL, 0x0000600065647625ULL, 0x000fe200078e007aULL,
0x0000000862db7981ULL, 0x0002e8000c1e9500ULL, 0x0000000864927981ULL, 0x0002e2000c1e9500ULL,
0xfffffff078137812ULL, 0x000fe200078ec0ffULL, 0x00000001ffcf7424ULL, 0x000fc800078e00ffULL,
0x0000000166127824ULL, 0x000fc800078e0213ULL, 0x0000000169137824ULL, 0x000fe200078e0a12ULL,
0x0000000167897812ULL, 0x000fc800078efcffULL, 0x00000013cf137219ULL, 0x000fe400000006ffULL,
0x0000580089197a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0801b7812ULL, 0x002fc600078ec0ffULL,
0x0000000119187824ULL, 0x100fe200078e0a12ULL, 0x00000008678b7812ULL, 0x040fe200078efcffULL,
0x0000000166227824ULL, 0x000fe200078e021bULL, 0x00000009678d7812ULL, 0x000fe400078efcffULL,
0x00000018cf1b7219ULL, 0x000fe400000006ffULL, 0x000058008b237a10ULL, 0x000fe40007ffe0ffULL,
0x000058008d657a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff086637812ULL, 0x000fe200078ec0ffULL,
0x00000001231a7824ULL, 0x100fe200078e0a12ULL, 0xfffffff0888f7812ULL, 0x000fe200078ec0ffULL,
0x0000000165127824ULL, 0x000fe200078e0a12ULL, 0x0000001167937812ULL, 0x000fe200078efcffULL,
0x0000000166627824ULL, 0x040fe200078e0263ULL, 0x0000001acf637219ULL, 0x040fe200000006ffULL,
0x0000000166807824ULL, 0x000fe200078e028fULL, 0x00000012cf8f7219ULL, 0x000fc400000006ffULL,
0x0000541068687816ULL, 0x004fc8000000006bULL, 0x0000006813ff7212ULL, 0x000fc800078ac0ffULL,
0x000000666900720cULL, 0x000fc80002fa1470ULL, 0x000000666700720cULL, 0x000fe40002fa1070ULL,
0x000000681bff7212ULL, 0x000fe4000782c0ffULL, 0xff8000005f5f7808ULL, 0x000fe40002800000ULL,
0x000000661900720cULL, 0x000fe40000f21470ULL, 0x000054106c6c7816ULL, 0x000fe40000000071ULL,
0x000054106a6a7816ULL, 0x000fc4000000006fULL, 0x0000006c13ff7212ULL, 0x040fe4000788c0ffULL,
0x0000006a13ff7212ULL, 0x080fe4000784c0ffULL, 0x0000006a1bff7212ULL, 0x000fe400078ac0ffULL,
0x000000666900720cULL, 0x0c0fe40001741470ULL, 0x000000666900720cULL, 0x080fe40002781470ULL,
0x000000661900720cULL, 0x000fc40002fa1470ULL, 0x000000666700720cULL, 0x0c0fe40001741070ULL,
0x000000666700720cULL, 0x080fe40002781070ULL, 0x000000668900720cULL, 0x0c0fe40000f21070ULL,
0x000000668900720cULL, 0x000fe40002fa1070ULL, 0x000054106d6e7816ULL, 0x000fe4000000006eULL,
0x0000580093957a10ULL, 0x000fc40007ffe0ffULL, 0xff8000004e4e7808ULL, 0x000fe40001000000ULL,
0xff80000033337808ULL, 0x000fe40002000000ULL, 0xff8000005e5e7808ULL, 0x000fe40000800000ULL,
0xff8000004d4d7808ULL, 0x000fe40002800000ULL, 0x0000006863ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006e13ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006c1bff7212ULL, 0x040fe4000784c0ffULL,
0x0000006e1bff7212ULL, 0x000fe4000788c0ffULL, 0x0000006a8fff7212ULL, 0x000fe4000782c0ffULL,
0x0000006c63ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000173127824ULL, 0x100fe200078e0a22ULL,
0x000000666900720cULL, 0x080fe20000701470ULL, 0x0000000195187824ULL, 0x000fe200078e0a22ULL,
0x000000661900720cULL, 0x000fc40001741470ULL, 0x000000661900720cULL, 0x080fe40002781470ULL,
0x000000662300720cULL, 0x0c0fe40001f61470ULL, 0x000000662300720cULL, 0x080fe40002fa1470ULL,
0x000000666500720cULL, 0x000fe40000f21470ULL, 0x0000001867997812ULL, 0x040fe400078efcffULL,
0x00000019679f7812ULL, 0x000fc400078efcffULL, 0x000000666700720cULL, 0x080fe40000701070ULL,
0x000000668900720cULL, 0x0c0fe40001741070ULL, 0x000000668900720cULL, 0x080fe40002781070ULL,
0x000000668b00720cULL, 0x0c0fe40001f61070ULL, 0x000000668b00720cULL, 0x080fe40002fa1070ULL,
0x000000668d00720cULL, 0x000fc40000f21070ULL, 0x00000012cf917219ULL, 0x040fe400000006ffULL,
0x00000018cf977219ULL, 0x000fe400000006ffULL, 0x0000541070707816ULL, 0x008fe40000000077ULL,
0x0000541072727816ULL, 0x000fe40000000079ULL, 0x00005800999b7a10ULL, 0x000fe40007ffe0ffULL,
0x000058009fa17a10ULL, 0x000fc40007ffe0ffULL, 0xff80000024247808ULL, 0x000fe40000000000ULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000005d5d7808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0xff80000047477808ULL, 0x000fc40000800000ULL, 0x0000006a63ff7212ULL, 0x000fe4000780c0ffULL,
0x0000006c8fff7212ULL, 0x000fe4000784c0ffULL, 0x0000006e63ff7212ULL, 0x080fe4000788c0ffULL,
0x0000006e8fff7212ULL, 0x000fe4000786c0ffULL, 0x0000007097ff7212ULL, 0x000fe400078ac0ffULL,
0x0000007291ff7212ULL, 0x000fe2000782c0ffULL, 0x000000019b1a7824ULL, 0x100fe200078e0a22ULL,
0x000000662300720cULL, 0x080fe20000701470ULL, 0x00000001a1227824ULL, 0x000fe200078e0a22ULL,
0x000000662300720cULL, 0x000fc40002781470ULL, 0x000000666500720cULL, 0x0c0fe40001741470ULL,
0x000000666500720cULL, 0x080fe40001f61470ULL, 0x000000667300720cULL, 0x080fe40000f21470ULL,
0x000000669500720cULL, 0x080fe40002fa1470ULL, 0x000000668b00720cULL, 0x0c0fe40000701070ULL,
0x000000668b00720cULL, 0x000fc40002781070ULL, 0x000000668d00720cULL, 0x0c0fe40001741070ULL,
0x000000668d00720cULL, 0x080fe40001f61070ULL, 0x000000667500720cULL, 0x080fe40000f21070ULL,
0x000000669300720cULL, 0x000fe40002fa1070ULL, 0x0000001acf9d7219ULL, 0x040fe400000006ffULL,
0x00000022cfa37219ULL, 0x000fc400000006ffULL, 0x0000541074747816ULL, 0x000fe4000000007bULL,
0x0000541076767816ULL, 0x000fe40000000081ULL, 0xff80000045457808ULL, 0x000fe40000000000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0xff80000035357808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fc40001800000ULL, 0xff80000046467808ULL, 0x000fe40000800000ULL,
0xff8000005a5a7808ULL, 0x000fe40002800000ULL, 0x0000007091ff7212ULL, 0x080fe4000780c0ffULL,
0x000000709dff7212ULL, 0x000fe4000788c0ffULL, 0x0000007491ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007691ff7212ULL, 0x000fc4000786c0ffULL, 0x0000007497ff7212ULL, 0x000fe4000782c0ffULL,
0x00000072a3ff7212ULL, 0x000fe200078ac0ffULL, 0x000000017f647824ULL, 0x000fe200078e0a62ULL,
0x000000667300720cULL, 0x0c0fe40000701470ULL, 0x000000667300720cULL, 0x0c0fe40001741470ULL,
0x000000667300720cULL, 0x080fe40001f61470ULL, 0x000000669500720cULL, 0x000fc40000f21470ULL,
0x000000669b00720cULL, 0x080fe40002781470ULL, 0x00000066a100720cULL, 0x080fe40002fa1470ULL,
0x0000002167a77812ULL, 0x000fe400078efcffULL, 0x000000667500720cULL, 0x0c0fe40000701070ULL,
0x000000667500720cULL, 0x0c0fe40001741070ULL, 0x000000667500720cULL, 0x000fc40001f61070ULL,
0x000000669300720cULL, 0x080fe40000f21070ULL, 0x000000669900720cULL, 0x080fe40002781070ULL,
0x000000669f00720cULL, 0x000fe40002fa1070ULL, 0x00000064cfa57219ULL, 0x000fe400000006ffULL,
0x000054107e7e7816ULL, 0x000fe400000000d1ULL, 0x00005800a7a97a10ULL, 0x000fc40007ffe0ffULL,
0xff8000005b5b7808ULL, 0x000fe40000000000ULL, 0xff80000036367808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40000800000ULL,
0xff80000059597808ULL, 0x000fe40002000000ULL, 0xff8000004a4a7808ULL, 0x000fc40002800000ULL,
0x0000007297ff7212ULL, 0x040fe4000780c0ffULL, 0x0000007697ff7212ULL, 0x000fe4000784c0ffULL,
0x000000729dff7212ULL, 0x000fe4000786c0ffULL, 0x00000074a3ff7212ULL, 0x040fe4000782c0ffULL,
0x00000076a3ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007ea5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a9787824ULL, 0x000fe200078e0a62ULL, 0x000000669500720cULL, 0x000fc40000701470ULL,
0x000000669500720cULL, 0x080fe40001741470ULL, 0x000000669b00720cULL, 0x080fe40001f61470ULL,
0x00000066a100720cULL, 0x0c0fe40000f21470ULL, 0x00000066a100720cULL, 0x080fe40002781470ULL,
0x000000667f00720cULL, 0x000fe40002fa1470ULL, 0x0000002867ad7812ULL, 0x000fc400078efcffULL,
0x0000002967b37812ULL, 0x000fe400078efcffULL, 0x000000669300720cULL, 0x0c0fe40000701070ULL,
0x000000669300720cULL, 0x080fe40001741070ULL, 0x000000669900720cULL, 0x080fe40001f61070ULL,
0x000000669f00720cULL, 0x0c0fe40000f21070ULL, 0x000000669f00720cULL, 0x000fc40002781070ULL,
0x000000667d00720cULL, 0x000fe40002fa1070ULL, 0x00000078cfab7219ULL, 0x000fe400000006ffULL,
0x000054107c7c7816ULL, 0x000fe40000000083ULL, 0x0000541082827816ULL, 0x000fe400000000d5ULL,
0x0000541084847816ULL, 0x000fe400000000d9ULL, 0x00005800adaf7a10ULL, 0x000fc40007ffe0ffULL,
0x00005800b3b57a10ULL, 0x000fe40007ffe0ffULL, 0xff80000051517808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000039397808ULL, 0x000fe40000800000ULL, 0xff8000002d2d7808ULL, 0x000fc40002000000ULL,
0xff80000049497808ULL, 0x000fe40002800000ULL, 0x000000688fff7212ULL, 0x000fe400078cc0ffULL,
0x000000749dff7212ULL, 0x040fe4000780c0ffULL, 0x000000769dff7212ULL, 0x000fe4000784c0ffULL,
0x0000007ca5ff7212ULL, 0x040fe4000786c0ffULL, 0x00000082a5ff7212ULL, 0x000fc4000782c0ffULL,
0x00000084a5ff7212ULL, 0x000fe4000788c0ffULL, 0x00000082abff7212ULL, 0x000fe200078ac0ffULL,
0x00000001af7a7824ULL, 0x100fe200078e0a62ULL, 0x000000666500720cULL, 0x080fe200037c1470ULL,
0x00000001b5627824ULL, 0x000fe200078e0a62ULL, 0x000000669b00720cULL, 0x0c0fe40000701470ULL,
0x000000669b00720cULL, 0x080fe40001741470ULL, 0x000000667f00720cULL, 0x000fc40001f61470ULL,
0x000000667f00720cULL, 0x0c0fe40000f21470ULL, 0x000000667f00720cULL, 0x080fe40002781470ULL,
0x00000066a900720cULL, 0x080fe40002fa1470ULL, 0x000000668d00720cULL, 0x080fe400037c1070ULL,
0x000000669900720cULL, 0x0c0fe40000701070ULL, 0x000000669900720cULL, 0x000fc40001741070ULL,
0x000000667d00720cULL, 0x0c0fe40001f61070ULL, 0x000000667d00720cULL, 0x0c0fe40000f21070ULL,
0x000000667d00720cULL, 0x080fe40002781070ULL, 0x00000066a700720cULL, 0x000fe40002fa1070ULL,
0x0000007acfb17219ULL, 0x040fe400000006ffULL, 0x00000062cfb77219ULL, 0x000fc400000006ffULL,
0xff8000005c5c7808ULL, 0x000fe40003000000ULL, 0xff80000038387808ULL, 0x000fe40000000000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000061617808ULL, 0x000fe40001800000ULL,
0xff8000003a3a7808ULL, 0x000fe40000800000ULL, 0xff8000002e2e7808ULL, 0x000fc40002000000ULL,
0xff8000003b3b7808ULL, 0x000fe40002800000ULL, 0x00000070a3ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007cabff7212ULL, 0x080fe4000780c0ffULL, 0x0000007cb1ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007eabff7212ULL, 0x040fe4000786c0ffULL, 0x00000084abff7212ULL, 0x000fc4000782c0ffULL,
0x0000007eb1ff7212ULL, 0x000fe4000788c0ffULL, 0x00000082b7ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000187867824ULL, 0x000fe200078e0a80ULL, 0x00000066a100720cULL, 0x080fe400037c1470ULL,
0x00000066a900720cULL, 0x0c0fe40000701470ULL, 0x00000066a900720cULL, 0x0c0fe40001f61470ULL,
0x00000066a900720cULL, 0x000fc40000f21470ULL, 0x00000066af00720cULL, 0x0c0fe40001741470ULL,
0x00000066af00720cULL, 0x080fe40002781470ULL, 0x00000066b500720cULL, 0x000fe40002fa1470ULL,
0x0000003167bf7812ULL, 0x040fe400078efcffULL, 0x0000003867c57812ULL, 0x040fe400078efcffULL,
0x0000003967cb7812ULL, 0x000fc400078efcffULL, 0x000000669f00720cULL, 0x080fe400037c1070ULL,
0x00000066a700720cULL, 0x0c0fe40000701070ULL, 0x00000066a700720cULL, 0x0c0fe40001f61070ULL,
0x00000066a700720cULL, 0x080fe40000f21070ULL, 0x00000066ad00720cULL, 0x0c0fe40001741070ULL,
0x00000066ad00720cULL, 0x000fc40002781070ULL, 0x00000066b300720cULL, 0x000fe40002fa1070ULL,
0x00000086cfbd7219ULL, 0x000fe400000006ffULL, 0x00005410b98c7816ULL, 0x000fe4000000008cULL,
0x00005410d7907816ULL, 0x000fe40000000090ULL, 0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c5c77a10ULL, 0x000fc40007ffe0ffULL, 0x00005800cbcd7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000060607808ULL, 0x000fe40003000000ULL, 0xff80000058587808ULL, 0x000fe40000000000ULL,
0xff80000050507808ULL, 0x000fe40001800000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000057577808ULL, 0x000fc40001000000ULL, 0xff8000004b4b7808ULL, 0x000fe40002000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x0000007cb7ff7212ULL, 0x040fe400078cc0ffULL,
0x0000007eb7ff7212ULL, 0x000fe4000780c0ffULL, 0x00000082b1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000084b1ff7212ULL, 0x000fc4000782c0ffULL, 0x00000084b7ff7212ULL, 0x000fe4000784c0ffULL,
0x0000008cbdff7212ULL, 0x040fe4000788c0ffULL, 0x00000090bdff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c1887824ULL, 0x100fe200078e0a80ULL, 0x00000066af00720cULL, 0x080fe20001f61470ULL,
0x00000001c78a7824ULL, 0x100fe200078e0a80ULL, 0x00000066af00720cULL, 0x080fe20000f21470ULL,
0x00000001cd807824ULL, 0x000fe200078e0a80ULL, 0x00000066b500720cULL, 0x000fc400037c1470ULL,
0x00000066b500720cULL, 0x0c0fe40000701470ULL, 0x00000066b500720cULL, 0x080fe40001741470ULL,
0x000000668700720cULL, 0x0c0fe40002781470ULL, 0x000000668700720cULL, 0x000fe40002fa1470ULL,
0x00000088cfc37219ULL, 0x040fe400000006ffULL, 0x0000008acfc97219ULL, 0x000fc400000006ffULL,
0x00000066ad00720cULL, 0x0c0fe40001f61070ULL, 0x00000066ad00720cULL, 0x080fe40000f21070ULL,
0x00000066b300720cULL, 0x0c0fe400037c1070ULL, 0x00000066b300720cULL, 0x0c0fe40000701070ULL,
0x00000066b300720cULL, 0x080fe40001741070ULL, 0x000000668500720cULL, 0x000fc40002781070ULL,
0x000000668500720cULL, 0x000fe40002fa1070ULL, 0x00000080cfcf7219ULL, 0x000fe400000006ffULL,
0x00005410d38e7816ULL, 0x000fe4000000008eULL, 0xff8000003c3c7808ULL, 0x000fe40001800000ULL,
0xff8000001f1f7808ULL, 0x000fe40000800000ULL, 0xff80000056567808ULL, 0x000fc40003000000ULL,
0xff8000004f4f7808ULL, 0x000fe40000000000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000055557808ULL, 0x000fe40002000000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0x0000008cc3ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008cc9ff7212ULL, 0x000fc4000782c0ffULL,
0x0000008ccfff7212ULL, 0x000fe400078cc0ffULL, 0x0000008ebdff7212ULL, 0x080fe4000780c0ffULL,
0x0000008ec3ff7212ULL, 0x080fe4000784c0ffULL, 0x0000008ec9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000090c3ff7212ULL, 0x000fe400078ac0ffULL, 0x000000668700720cULL, 0x000fc40000701470ULL,
0x00000066c100720cULL, 0x0c0fe40001f61470ULL, 0x00000066c100720cULL, 0x0c0fe40001741470ULL,
0x00000066c100720cULL, 0x080fe40002fa1470ULL, 0x00000066c700720cULL, 0x080fe40000f21470ULL,
0x00000066cd00720cULL, 0x080fe400037c1470ULL, 0x00000066c700720cULL, 0x000fc40002781470ULL,
0x000000668500720cULL, 0x080fe40000701070ULL, 0x00000066bf00720cULL, 0x0c0fe40001f61070ULL,
0x00000066bf00720cULL, 0x0c0fe40001741070ULL, 0x00000066bf00720cULL, 0x080fe40002fa1070ULL,
0x00000066c500720cULL, 0x080fe40000f21070ULL, 0x00000066cb00720cULL, 0x000fc400037c1070ULL,
0x00000066c500720cULL, 0x000fe40002781070ULL, 0x00005410db927816ULL, 0x000fe40000000092ULL,
0xff8000004c4c7808ULL, 0x000fe40000000000ULL, 0xff80000054547808ULL, 0x000fe40001800000ULL,
0xff80000044447808ULL, 0x000fe40001000000ULL, 0xff8000003e3e7808ULL, 0x000fc40002800000ULL,
0xff80000053537808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fe40003000000ULL,
0xff80000043437808ULL, 0x000fe40002000000ULL, 0x0000008ecfff7212ULL, 0x000fe4000780c0ffULL,
0x00000090c9ff7212ULL, 0x080fe4000786c0ffULL, 0x00000090cfff7212ULL, 0x000fc4000784c0ffULL,
0x00000092bdff7212ULL, 0x080fe400078ac0ffULL, 0x00000092c3ff7212ULL, 0x080fe4000782c0ffULL,
0x00000092c9ff7212ULL, 0x080fe400078cc0ffULL, 0x00000092cfff7212ULL, 0x000fe4000788c0ffULL,
0x000000668700720cULL, 0x080fe40002fa1470ULL, 0x00000066c100720cULL, 0x000fc40000f21470ULL,
0x00000066c700720cULL, 0x0c0fe40001f61470ULL, 0x00000066c700720cULL, 0x080fe400037c1470ULL,
0x00000066cd00720cULL, 0x0c0fe40000701470ULL, 0x00000066cd00720cULL, 0x0c0fe40001741470ULL,
0x00000066cd00720cULL, 0x080fe40002781470ULL, 0x000000668500720cULL, 0x000fc40002fa1070ULL,
0x00000066bf00720cULL, 0x080fe40000f21070ULL, 0x00000066cb00720cULL, 0x080fe40000701070ULL,
0x00000066c500720cULL, 0x0c0fe40001f61070ULL, 0x00000066c500720cULL, 0x080fe400037c1070ULL,
0x00000066cb00720cULL, 0x0c0fe40001741070ULL, 0x00000066cb00720cULL, 0x000fc40002781070ULL,
0xff80000042427808ULL, 0x000fe40000000000ULL, 0xff8000003f3f7808ULL, 0x000fe40001800000ULL,
0xff80000040407808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40002800000ULL,
0xff80000029297808ULL, 0x000fe40000800000ULL, 0xff8000002a2a7808ULL, 0x000fc40003000000ULL,
0xff8000002b2b7808ULL, 0x000fc40002000000ULL, 0x0000005f1400720bULL, 0x004fe40003f1e000ULL,
0x0000004e1500720bULL, 0x000fe40003f3e000ULL, 0x000000331600720bULL, 0x000fe40003f5e000ULL,
0x000000241700720bULL, 0x000fe40003f7e000ULL, 0x000000145f137208ULL, 0x000fe40004000000ULL,
0x000000154e127208ULL, 0x000fc40004800000ULL, 0x0000001633157208ULL, 0x000fe40005000000ULL,
0x0000001724147208ULL, 0x000fe40005800000ULL, 0x0000005e1300720bULL, 0x000fe40003f1e000ULL,
0x0000004d1200720bULL, 0x000fe40003f3e000ULL, 0x000000321500720bULL, 0x000fe40003f5e000ULL,
0x000000311400720bULL, 0x000fc40003f7e000ULL, 0x000000135e167208ULL, 0x000fe40004000000ULL,
0x000000124d127208ULL, 0x000fe40004800000ULL, 0x0000001532157208ULL, 0x000fe40005000000ULL,
0x0000001431137208ULL, 0x000fe40005800000ULL, 0x0000005d1600720bULL, 0x000fe40003f1e000ULL,
0x000000451200720bULL, 0x000fc40003f3e000ULL, 0x000000341500720bULL, 0x000fe40003f5e000ULL,
0x000000261300720bULL, 0x000fe40003f7e000ULL, 0x000000165d177208ULL, 0x000fe40004000000ULL,
0x0000001245127208ULL, 0x000fe40004800000ULL, 0x0000001534147208ULL, 0x000fe40005000000ULL,
0x0000001326137208ULL, 0x000fc40005800000ULL, 0x0000005c1700720bULL, 0x000fe40003f1e000ULL,
0x000000471200720bULL, 0x000fe40003f3e000ULL, 0x000000351400720bULL, 0x000fe40003f5e000ULL,
0x000000301300720bULL, 0x000fe40003f7e000ULL, 0x000000175c167208ULL, 0x000fe40004000000ULL,
0x0000001247157208ULL, 0x000fc40004800000ULL, 0x0000001435177208ULL, 0x000fe40005000000ULL,
0x0000001330127208ULL, 0x000fe40005800000ULL, 0x0000005b1600720bULL, 0x000fe40003f1e000ULL,
0x000000461500720bULL, 0x000fe40003f3e000ULL, 0x000000361700720bULL, 0x000fe40003f5e000ULL,
0x000000251200720bULL, 0x000fc40003f7e000ULL, 0x000000165b137208ULL, 0x000fe40004000000ULL,
0x0000001546147208ULL, 0x000fe40004800000ULL, 0x0000001736167208ULL, 0x000fe40005000000ULL,
0x0000001225127208ULL, 0x000fe40005800000ULL, 0x0000005a1300720bULL, 0x000fe40003f1e000ULL,
0x000000511400720bULL, 0x000fc40003f3e000ULL, 0x000000371600720bULL, 0x000fe40003f5e000ULL,
0x000000271200720bULL, 0x000fe40003f7e000ULL, 0x000000135a187208ULL, 0x000fe40004000000ULL,
0x0000001451137208ULL, 0x000fe40004800000ULL, 0x0000001637157208ULL, 0x000fe40005000000ULL,
0x0000001227127208ULL, 0x000fc40005800000ULL, 0x000000481300720bULL, 0x000fe40003f3e000ULL,
0x000000591800720bULL, 0x000fe40003f1e000ULL, 0x000000381500720bULL, 0x000fe40003f5e000ULL,
0x0000002f1200720bULL, 0x000fe40003f7e000ULL, 0x0000001348137208ULL, 0x000fe40004800000ULL,
0x0000001859177208ULL, 0x000fc40004000000ULL, 0x0000001538147208ULL, 0x000fe40005000000ULL,
0x000000122f127208ULL, 0x000fe40005800000ULL, 0x0000004a1300720bULL, 0x000fe40003f3e000ULL,
0x000000601700720bULL, 0x000fe40003f1e000ULL, 0x000000391400720bULL, 0x000fe40003f5e000ULL,
0x0000002d1200720bULL, 0x000fc40003f7e000ULL, 0x000000134a187208ULL, 0x000fe40004800000ULL,
0x0000001760167208ULL, 0x000fe40004000000ULL, 0x0000001439137208ULL, 0x000fe40005000000ULL,
0x000000122d157208ULL, 0x000fe40005800000ULL, 0x000000611600720bULL, 0x000fe40003f1e000ULL,
0x000000491800720bULL, 0x000fc40003f3e000ULL, 0x0000003a1300720bULL, 0x000fe40003f5e000ULL,
0x0000002e1500720bULL, 0x000fe40003f7e000ULL, 0x0000001661177208ULL, 0x000fe40004000000ULL,
0x0000001849197208ULL, 0x000fe40004800000ULL, 0x000000133a127208ULL, 0x000fe40005000000ULL,
0x000000152e157208ULL, 0x000fc40005800000ULL, 0x000000581700720bULL, 0x000fe40003f1e000ULL,
0x000000501900720bULL, 0x000fe40003f3e000ULL, 0x0000003b1200720bULL, 0x000fe40003f5e000ULL,
0x0000002c1500720bULL, 0x000fe40003f7e000ULL, 0x0000001758147208ULL, 0x000fe40004000000ULL,
0x0000001950167208ULL, 0x000fc40004800000ULL, 0x000000123b137208ULL, 0x000fe40005000000ULL,
0x000000152c127208ULL, 0x000fe40005800000ULL, 0x000000571400720bULL, 0x000fe40003f1e000ULL,
0x0000004b1600720bULL, 0x000fe40003f3e000ULL, 0x0000003c1300720bULL, 0x000fe40003f5e000ULL,
0x0000001f1200720bULL, 0x000fc40003f7e000ULL, 0x0000001457157208ULL, 0x000fe40004000000ULL,
0x000000164b167208ULL, 0x000fe40004800000ULL, 0x000000133c147208ULL, 0x000fe40005000000ULL,
0x000000121f127208ULL, 0x000fe40005800000ULL, 0x000000561500720bULL, 0x000fe40003f1e000ULL,
0x0000004f1600720bULL, 0x000fc40003f3e000ULL, 0x0000003d1400720bULL, 0x000fe40003f5e000ULL,
0x000000211200720bULL, 0x000fe40003f7e000ULL, 0x0000001556187208ULL, 0x000fe40004000000ULL,
0x000000164f137208ULL, 0x000fe40004800000ULL, 0x000000143d147208ULL, 0x000fe40005000000ULL,
0x0000001221157208ULL, 0x000fc40005800000ULL, 0x0000004c1300720bULL, 0x000fe40003f3e000ULL,
0x000000551800720bULL, 0x000fe40003f1e000ULL, 0x000000411400720bULL, 0x000fe40003f5e000ULL,
0x000000281500720bULL, 0x000fe40003f7e000ULL, 0x000000134c137208ULL, 0x000fe40004800000ULL,
0x0000001855177208ULL, 0x000fc40004000000ULL, 0x0000001441197208ULL, 0x000fe40005000000ULL,
0x0000001528127208ULL, 0x000fe40005800000ULL, 0x000000441300720bULL, 0x000fe40003f3e000ULL,
0x000000541700720bULL, 0x000fe40003f1e000ULL, 0x0000003e1900720bULL, 0x000fe40003f5e000ULL,
0x000000291200720bULL, 0x000fc40003f7e000ULL, 0x0000001344167208ULL, 0x000fe40004800000ULL,
0x0000001754147208ULL, 0x000fe40004000000ULL, 0x000000193e187208ULL, 0x000fe40005000000ULL,
0x0000001229137208ULL, 0x000fe40005800000ULL, 0x000000531400720bULL, 0x000fe40003f1e000ULL,
0x000000431600720bULL, 0x000fc40003f3e000ULL, 0x0000003f1800720bULL, 0x000fe40003f5e000ULL,
0x0000002a1300720bULL, 0x000fe40003f7e000ULL, 0x0000001453157208ULL, 0x000fe40004000000ULL,
0x0000001643177208ULL, 0x000fe40004800000ULL, 0x000000183f197208ULL, 0x000fe40005000000ULL,
0x000000132a127208ULL, 0x000fc40005800000ULL, 0x000000521500720bULL, 0x000fe40003f1e000ULL,
0x000000421700720bULL, 0x000fe40003f3e000ULL, 0x000000401900720bULL, 0x000fe40003f5e000ULL,
0x0000002b1200720bULL, 0x000fe40003f7e000ULL, 0x0000001552157208ULL, 0x000fe40004000000ULL,
0x0000001742177208ULL, 0x000fc40004800000ULL, 0x00000019401b7208ULL, 0x000fe40005000000ULL,
0x000000122b237208ULL, 0x000fe20005800000ULL, 0x000025627f007947ULL, 0x000fea000b800000ULL,
0x0c401f0015127f89ULL, 0x0004e400000e0000ULL, 0x000000121500720bULL, 0x008fc80003f1e000ULL,
0x0000001512227208ULL, 0x000fe20004000000ULL, 0x000025a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0017127f89ULL, 0x000ee800000e0000ULL, 0x0c401f001b137f89ULL, 0x000e6800000e0000ULL,
0x0c401f0023147f89ULL, 0x000ea800000e0000ULL, 0x0c201f0022157f89ULL, 0x004ea200000e0000ULL,
0x000000121700720bULL, 0x008fc40003f1e000ULL, 0x000000131b00720bULL, 0x002fe40003f3e000ULL,
0x0000001712127208ULL, 0x000fe40004000000ULL, 0x0000001b13137208ULL, 0x000fe40004800000ULL,
0x000000142300720bULL, 0x000fe20003f1e000ULL, 0x0c201f0012197f89ULL, 0x000e6600000e0000ULL,
0x0000002314177208ULL, 0x000fe20004000000ULL, 0x0c201f0013167f89ULL, 0x000ee200000e0000ULL,
0x000000152200720bULL, 0x004fc60003f1e000ULL, 0x0c201f0017187f89ULL, 0x0004a200000e0000ULL,
0x0000002215147208ULL, 0x000fe40004000000ULL, 0x000000191200720bULL, 0x002fe40003f3e000ULL,
0x000000161300720bULL, 0x008fe40003f5e000ULL, 0x0000001219157208ULL, 0x000fe40004800000ULL,
0x0000001316167208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b14127820ULL, 0x004fe20000410000ULL,
0x000000181700720bULL, 0x000fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x00000002ff657819ULL, 0x000fe20000011606ULL, 0x3fb8aa3b59197823ULL, 0x102fe20000010812ULL,
0x0000001718177208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b5f5f7823ULL, 0x100fe20000010812ULL,
0x0000000165187810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b5e5e7823ULL, 0x100fe20000010812ULL,
0x0000001065707810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b5d5d7823ULL, 0x100fe20000010812ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b5c5c7823ULL, 0x100fe20000010812ULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b5b5b7823ULL, 0x100fe20000010812ULL,
0x0000000306ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b5a5a7823ULL, 0x000fc40000010812ULL,
0x3fb8aa3b60607823ULL, 0x100fe20000010812ULL, 0x0000005c00137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b61597823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b58587823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b57577823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010812ULL,
0x0000005d001a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b55227823ULL, 0x000fc40000010812ULL,
0x3fb8aa3b54237823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b53537823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b52527823ULL, 0x000fe20000010812ULL, 0x0000006000607308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b15127820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b45457823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010812ULL, 0x0000005f005f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010812ULL, 0x0000001a131a723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010812ULL, 0x00000045001b7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b48487823ULL, 0x000fc40000010812ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b49497823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010812ULL,
0x0000004600557308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b4c457823ULL, 0x002fc40000010812ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010812ULL, 0x00000051005c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b43437823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b42467823ULL, 0x004fe40000010812ULL,
0x3fb8aa3b16127820ULL, 0x000fc60000410000ULL, 0x0000004f00627308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b33337823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b32327823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b34347823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010812ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b36367823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b37377823ULL, 0x000fc40000010812ULL, 0x3fb8aa3b38387823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010812ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010812ULL,
0x0000003800427308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b41417823ULL, 0x000fc40000010812ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b40127823ULL, 0x000fe20000010812ULL, 0x0000003d00517308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b17407820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b24247823ULL, 0x100fe40000010840ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010840ULL, 0x0000003b004f7308ULL, 0x0005e20000000800ULL,
0x00000008653d7824ULL, 0x002fe400078e00ffULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010840ULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010840ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe20000010840ULL,
0x0000002400387308ULL, 0x0003e20000000800ULL, 0x00000008653b7824ULL, 0x004fc400078e00ffULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe40000010840ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe40000010840ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010840ULL, 0x0000003c004c7308ULL, 0x000fe20000000800ULL,
0x0000000465247810ULL, 0x002fe20007ffe0ffULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe40000010840ULL,
0x3fb8aa3b21217823ULL, 0x000fe20000010840ULL, 0xfffffff83d6e7812ULL, 0x000fc600078ee224ULL,
0x0000005e005e7308ULL, 0x000ff00000000800ULL, 0x0000004e004e7308ULL, 0x000ff00000000800ULL,
0x0000004d004d7308ULL, 0x000ff00000000800ULL, 0x0000004700547308ULL, 0x000e700000000800ULL,
0x0000001200667308ULL, 0x0005f00000000800ULL, 0x00000026003c7308ULL, 0x0007e20000000800ULL,
0x0000000365127810ULL, 0x004fc40007ffe0ffULL, 0x0000001b541b723eULL, 0x002fe400000010ffULL,
0xfffffff83b6c7812ULL, 0x000fe200078ee212ULL, 0x00000004ff127e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000030003d7308ULL, 0x0002a20000000800ULL,
0x000000196026723eULL, 0x008fe400000010ffULL, 0x3f8000001212783eULL, 0x000fe400000010ffULL,
0x0000004e4d19723eULL, 0x000fe200000010ffULL, 0x00000008654d7824ULL, 0x040fe200078e00ffULL,
0x0000000865607810ULL, 0x000fe20007ffe0ffULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x000000333230723eULL, 0x002fe200000010ffULL, 0x000000ffff137224ULL, 0x000fc400078e0012ULL,
0x000000ffff547224ULL, 0x000fc800078e0012ULL, 0x0000003500357308ULL, 0x000e620000000800ULL,
0x0000003c3d33723eULL, 0x004fe200000010ffULL, 0x000000ffff3c7224ULL, 0x100fe400078e0012ULL,
0x000000ffff3d7224ULL, 0x000fc800078e0012ULL, 0x0000003100317308ULL, 0x000eb00000000800ULL,
0x0000003900477308ULL, 0x0007e20000000800ULL, 0x000000343532723eULL, 0x002fe400000010ffULL,
0xffffffff65357810ULL, 0x000fc40007ffe0ffULL, 0x0000000665347810ULL, 0x000fc60007ffe0ffULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x0000000865397824ULL, 0x008fe200078e00ffULL,
0x000000383131723eULL, 0x004fc800000010ffULL, 0xfffffff839687812ULL, 0x000fe400078ee218ULL,
0x0000004a005d7308ULL, 0x000e620000000800ULL, 0x0000000265187810ULL, 0x000fc80007ffe0ffULL,
0xfffffff8396a7812ULL, 0x000fe200078ee218ULL, 0x3fb8aa3b25397823ULL, 0x000fe20000010840ULL,
0x0000005f5e18723eULL, 0x000fe200000010ffULL, 0x0000003e00647308ULL, 0x0005e20000000800ULL,
0x00000008655e7824ULL, 0x000fe200078e00ffULL, 0x000000555c25723eULL, 0x000fe200000010ffULL,
0x000000ffff557224ULL, 0x000fe200078e0012ULL, 0xfffffff84d5c7812ULL, 0x000fe200078ee234ULL,
0x3fb8aa3b2a4d7823ULL, 0x100fe20000010840ULL, 0xfffffff85e5e7812ULL, 0x000fe400078ee235ULL,
0x0000004100617308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b273e7823ULL, 0x004fe20000010840ULL,
0x000000485d27723eULL, 0x002fcc00000010ffULL, 0x0000003a004a7308ULL, 0x000ff00000000800ULL,
0x0000003900417308ULL, 0x0003f00000000800ULL, 0x0000003f00637308ULL, 0x000fe20000000800ULL,
0x000000121838723cULL, 0x002b6e00000418ffULL, 0x0000003e00487308ULL, 0x0002a20000000800ULL,
0x0000000565137810ULL, 0x020fce0007ffe0ffULL, 0x0000005b005b7308ULL, 0x000fe20000000800ULL,
0x0000003c303c723cULL, 0x002f6e00000418ffULL, 0x0000005a005a7308ULL, 0x000e620000000800ULL,
0x000000414835723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b28417823ULL, 0x000fc40000010840ULL,
0x3fb8aa3b29487823ULL, 0x000fe40000010840ULL, 0x000000ffff287224ULL, 0x100fe400078e0012ULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000ffff297224ULL, 0x000fce00078e0012ULL,
0x0000003700377308ULL, 0x000ea20000000800ULL, 0x0000005b5a24723eULL, 0x002fe200000010ffULL,
0x00000008655a7824ULL, 0x000fca00078e00ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee213ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x000000542438723cULL, 0x000b6e0000041838ULL,
0x0000002d004e7308ULL, 0x0002e20000000800ULL, 0x000000363734723eULL, 0x004fe200000010ffULL,
0x0000000865547824ULL, 0x020fe200078e00ffULL, 0x000000424736723eULL, 0x000fc800000010ffULL,
0xfffffff854547812ULL, 0x000fe200078ee265ULL, 0x0000005700577308ULL, 0x000fe20000000800ULL,
0x00000008602d7824ULL, 0x002fe200078e00ffULL, 0x0000001865657810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82d607812ULL, 0x000fe400078ee260ULL, 0x0000002f4e37723eULL, 0x008fe200000010ffULL,
0x0000005600567308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2b4e7823ULL, 0x000fe40000010840ULL,
0x00000008702f7824ULL, 0x000fc600078e00ffULL, 0x00000028343c723cULL, 0x000b64000004183cULL,
0x0000005900597308ULL, 0x000fe20000000800ULL, 0xfffffff82f707812ULL, 0x000fce00078ee270ULL,
0x0000005800587308ULL, 0x000ea20000000800ULL, 0x00000057562a723eULL, 0x002fe200000010ffULL,
0x000000ffff567224ULL, 0x100fe400078e0012ULL, 0x000000ffff577224ULL, 0x000fc800078e0012ULL,
0x0000004900497308ULL, 0x000ff00000000800ULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x000000595828723eULL, 0x024fce00000010ffULL, 0x0000004b004b7308ULL, 0x000eb00000000800ULL,
0x0000002e00137308ULL, 0x0007e20000000800ULL, 0x000000495029723eULL, 0x002fe200000010ffULL,
0x0000000865507824ULL, 0x000fca00078e00ffULL, 0xfffffff850507812ULL, 0x000fe200078ee265ULL,
0x0000002c00427308ULL, 0x0002620000000800ULL, 0x0000004b622b723eULL, 0x004fe200000010ffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0012ULL, 0x0000004c512e723eULL, 0x008fca00000010ffULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x0000004a4f2c723eULL, 0x002fe200000010ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0012ULL, 0x000000562838723cULL, 0x000f6a0000041838ULL,
0x0000002100407308ULL, 0x000e620000000800ULL, 0x00000013422d723eULL, 0x000fe400000010ffULL,
0x0001200020137811ULL, 0x000fca00078e60ffULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x0000001054547824ULL, 0x100fe400078e0213ULL, 0x0000001068687824ULL, 0x100fe400078e0213ULL,
0x000000106a6a7824ULL, 0x100fe400078e0213ULL, 0x000000106c6c7824ULL, 0x100fe200078e0213ULL,
0x0000001f402f723eULL, 0x002fe200000010ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x000000106e6e7824ULL, 0x000fc400078e0213ULL, 0x00000001541f7824ULL, 0x000fe400078e0211ULL,
0x000000105a5a7824ULL, 0x100fe200078e0213ULL, 0x0000004a2c3c723cULL, 0x000fe2000004183cULL,
0x0000000111687824ULL, 0x040fe200078e0268ULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x000000105c5c7824ULL, 0x100fe200078e0213ULL, 0x000000181f007388ULL, 0x0005e20000000800ULL,
0x00000001116a7824ULL, 0x040fe400078e026aULL, 0x000000105e5e7824ULL, 0x000fe200078e0213ULL,
0x0000001a68007388ULL, 0x0005e20000000800ULL, 0x00000001116c7824ULL, 0x000fe200078e026cULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x000000222340723eULL, 0x002fe200000010ffULL,
0x000000ffff227224ULL, 0x100fe200078e0012ULL, 0x000000246a007388ULL, 0x0005e20000000800ULL,
0x000000ffff237224ULL, 0x000fc400078e0012ULL, 0x0000001060607824ULL, 0x100fe200078e0213ULL,
0x000000266c007388ULL, 0x0005e20000000800ULL, 0x0000005300537308ULL, 0x000fe20000000800ULL,
0x00000001116e7824ULL, 0x040fe400078e026eULL, 0x00000001115a7824ULL, 0x040fe400078e025aULL,
0x00000001115c7824ULL, 0x040fe200078e025cULL, 0x000000286e007388ULL, 0x0005e20000000800ULL,
0x00000001115e7824ULL, 0x040fe200078e025eULL, 0x0000005200527308ULL, 0x000e620000000800ULL,
0x0000000111607824ULL, 0x000fe200078e0260ULL, 0x0000002a5a007388ULL, 0x0005e20000000800ULL,
0x0000001070707824ULL, 0x000fc400078e0213ULL, 0x0000001050507824ULL, 0x000fe200078e0213ULL,
0x000000405c007388ULL, 0x0005e20000000800ULL, 0x0000000111137824ULL, 0x040fe200078e0270ULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x0000000111507824ULL, 0x000fce00078e0250ULL,
0x0000004600467308ULL, 0x000ee20000000800ULL, 0x000000535242723eULL, 0x002fca00000010ffULL,
0x000000425e007388ULL, 0x0005e40000000800ULL, 0x0000004100477308ULL, 0x0003e40000000800ULL,
0x0000001960007388ULL, 0x0005e80000000800ULL, 0x0004001b68007388ULL, 0x0005e40000000800ULL,
0x0000004800487308ULL, 0x000ea20000000800ULL, 0x000000454441723eULL, 0x002fe200000010ffULL,
0x000400256a007388ULL, 0x0003e20000000800ULL, 0x000000434643723eULL, 0x008fc400000010ffULL,
0x000000616444723eULL, 0x000fe200000010ffULL, 0x000400276c007388ULL, 0x0003e20000000800ULL,
0x000000636646723eULL, 0x000fe200000010ffULL, 0x0000004d004d7308ULL, 0x000fe40000000800ULL,
0x000000224038723cULL, 0x020f620000041838ULL, 0x000400296e007388ULL, 0x0003e80000000800ULL,
0x0004002b5a007388ULL, 0x0003e20000000800ULL, 0x0000004e004e7308ULL, 0x000ee20000000800ULL,
0x000000474845723eULL, 0x004fc400000010ffULL, 0x000400415c007388ULL, 0x0003e80000000800ULL,
0x000400435e007388ULL, 0x0003e80000000800ULL, 0x0000003013007388ULL, 0x0003e80000000800ULL,
0x0008003268007388ULL, 0x0003e20000000800ULL, 0x0000004d4e47723eULL, 0x008fc400000010ffULL,
0x000000ffff397224ULL, 0x020fe200078e003aULL, 0x000800346a007388ULL, 0x0003e80000000800ULL,
0x00000022443c723cULL, 0x000f62000004183cULL, 0x000800366c007388ULL, 0x0003e80000000800ULL,
0x0008002c6e007388ULL, 0x0003e80000000800ULL, 0x0008002e5a007388ULL, 0x0003e80000000800ULL,
0x000800445c007388ULL, 0x0003e80000000800ULL, 0x000800465e007388ULL, 0x0003e80000000800ULL,
0x0000003150007388ULL, 0x0003e60000000800ULL, 0x000000ffff3a7224ULL, 0x020fe200078e003cULL,
0x000c003368007388ULL, 0x0003e20000000800ULL, 0x000000ffff3b7224ULL, 0x000fc600078e003eULL,
0x000c00356a007388ULL, 0x0003e80000000800ULL, 0x000c00376c007388ULL, 0x0003e80000000800ULL,
0x000c002d6e007388ULL, 0x0003e80000000800ULL, 0x000c002f5a007388ULL, 0x0003e80000000800ULL,
0x000c00455c007388ULL, 0x0003e80000000800ULL, 0x000c00475e007388ULL, 0x0003e80000000800ULL,
0x01a000140b008388ULL, 0x0003e80000000c00ULL, 0x01a200380b008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000009ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080009ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100009ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000010a0a7810ULL, 0x000fe20007ffe0ffULL,
0x0000180009ff7f8cULL, 0x0003e4000c80043fULL, 0x000000ffff0b7224ULL, 0x002fe200078e0010ULL,
0x0000001c0a00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff7db000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff277807ULL, 0x008fe20004000000ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x0001c86000287802ULL, 0x000fc40000000f00ULL, 0x0000160000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0027ULL, 0xfffe610000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x000fe20005000000ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x0001c8c000287802ULL, 0x000fc40000000f00ULL, 0x000015a000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e0027ULL, 0xfffe613000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0002ULL, 0x0001c93000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000014e000007944ULL, 0x014fea0003c00000ULL, 0xfffe61e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0002ULL, 0x0001c99000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000148000007944ULL, 0x014fea0003c00000ULL, 0xfffe62f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0002ULL, 0x0001c9f000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000142000007944ULL, 0x014fea0003c00000ULL, 0xfffe640000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0002ULL, 0x0001ca5000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000013c000007944ULL, 0x014fea0003c00000ULL, 0xfffe650000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0000ULL, 0x0001cac000277802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0003ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000135000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0028ULL, 0xfffe68d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0000ULL, 0x0001cb3000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000012e000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0028ULL,
0x0000001003297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200078e0000ULL,
0x0001cba000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000127000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0028ULL, 0xfffe684000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0000ULL, 0x0001cc1000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000120000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0028ULL,
0xfffe680000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x008fe20004000000ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0001cc7000287802ULL, 0x000fc40000000f00ULL,
0x000011f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff267224ULL, 0x000fe200078e0027ULL,
0xfffe98c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe20005000000ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0001ccd000287802ULL, 0x000fc40000000f00ULL,
0x0000119000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0027ULL,
0xfffe98f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0073ULL,
0x0001cd4000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000010d000007944ULL, 0x014fea0003c00000ULL,
0xfffe99b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0073ULL,
0x0001cda000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000107000007944ULL, 0x014fea0003c00000ULL,
0xfffe9ac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0073ULL,
0x0001ce0000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000101000007944ULL, 0x014fea0003c00000ULL,
0xfffe9bd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0073ULL,
0x0001ce6000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000fb000007944ULL, 0x014fea0003c00000ULL,
0xfffe9cd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0001ced000277802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e0025ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000f4000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0028ULL,
0xfffea0d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0001cf4000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000ed000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0028ULL, 0x0000001025297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff287224ULL, 0x000fe200078e000cULL, 0x0001cfb000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000e6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0028ULL,
0xfffea04000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0001d02000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000df000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0028ULL, 0xfffea00000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x008fe20004000000ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x0001d08000287802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0027ULL, 0xfffecea000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x000fe20005000000ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x0001d0e000287802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff737224ULL, 0x000fe200078e0027ULL, 0xfffecee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0001d15000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000cc000007944ULL, 0x014fea0003c00000ULL, 0xfffecf9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0001d1b000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000c6000007944ULL, 0x014fea0003c00000ULL, 0xfffed0a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0001d21000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000c0000007944ULL, 0x014fea0003c00000ULL, 0xfffed1b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0001d27000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000ba000007944ULL, 0x014fea0003c00000ULL, 0xfffed2b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000cULL, 0x0001d2e000277802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0021ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000b3000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0028ULL, 0xfffed6a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000cULL, 0x0001d35000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000ac000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0028ULL,
0x0000001021297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0001d3c000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0028ULL, 0xfffed61000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000cULL, 0x0001d43000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000009e000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0028ULL,
0xfffed5d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x008fe20004000000ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0001d49000287802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff067224ULL, 0x000fe200078e0027ULL,
0xffff056000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe20005000000ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0001d4f000287802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff217224ULL, 0x000fe200078e0027ULL,
0xffff059000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0011ULL,
0x0001d56000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000008b000007944ULL, 0x010fea0003c00000ULL,
0xffff064000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0011ULL,
0x0001d5c000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000085000007944ULL, 0x010fea0003c00000ULL,
0xffff075000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0011ULL,
0x0001d62000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000007f000007944ULL, 0x010fea0003c00000ULL,
0xffff086000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0011ULL,
0x0001d68000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000079000007944ULL, 0x010fea0003c00000ULL,
0xffff096000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0006ULL,
0x0001d6f000277802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e0011ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000072000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0028ULL,
0xffff0d6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0006ULL,
0x0001d76000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0028ULL, 0x0000001011297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff287224ULL, 0x000fe200078e0006ULL, 0x0001d7d000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000064000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0028ULL,
0xffff0cd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0006ULL,
0x0001d84000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0028ULL, 0xffff0c9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff197224ULL, 0x000fe200078e0015ULL, 0x0001d8c000127802ULL, 0x000fe20000000f00ULL,
0x00000002ff1a7424ULL, 0x000fe400078e00ffULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff637424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0018ULL, 0xffffda3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff197224ULL, 0x002fe200078e0017ULL, 0x0001d94000127802ULL, 0x000fe20000000f00ULL,
0x00000002ff1a7424ULL, 0x000fe400078e00ffULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff637424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x014fea0003c00000ULL,
0x000000181700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e001bULL,
0x0001d9c000127802ULL, 0x000fe20000000f00ULL, 0x00000002ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001718157208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff637424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000181b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e0023ULL,
0x0001da4000127802ULL, 0x000fe20000000f00ULL, 0x00000002ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001b181b7208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff637424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000182300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e0022ULL,
0x0001dac000127802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000002318177208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff637424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000182200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e0015ULL,
0x0001db4000127802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000002218147208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff637424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000181500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e001bULL,
0x0001dbc000127802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001518157208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff637424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000181b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e0017ULL,
0x0001dc4000127802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001b18167208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff637424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffd82000007947ULL, 0x000fea000383ffffULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000022027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe223002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff137424ULL, 0x000fe200078e00ffULL,
0x0000006300007348ULL, 0x000fe80003800000ULL, 0x0c00001a19187389ULL, 0x0002a200000e0018ULL,
0xfffe21f012007950ULL, 0x000fea0003c3ffffULL, 0x0000006c00007348ULL, 0x000fe80003800000ULL,
0x0000002928287389ULL, 0x0002a400000e006dULL, 0x000000ffff6c7224ULL, 0x002fc400078e0027ULL,
0x00000000ff6d7424ULL, 0x000fc800078e00ffULL, 0xfffe21a06c007950ULL, 0x000fea0003c3ffffULL,
0x000000012700780cULL, 0x000fe20003f45070ULL, 0x0000002900007348ULL, 0x000fd80003800000ULL,
0x0000000000277806ULL, 0x000fc800050e0100ULL, 0x0000002927277212ULL, 0x000fe200078ec0ffULL,
0x00000000ff297424ULL, 0x000fc800078e00ffULL, 0xfffe214028007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x00000000000008a0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001678ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000167cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001df80ULL, 0xfa00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001f800ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001f840ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001fbc0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001678ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001e188ULL,
0x000000000001e188ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001f800ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001fbc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_80_cubin_len = 130208;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
