/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001de40ULL, 0x000000000001dac0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001bef0ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001c070ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001c0b0ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001c100ULL, 0x0000000000000100ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001c200ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001bef000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x006e4c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001bef000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL, 0x8608288080840828ULL,
0x2880808908288080ULL, 0x808d082880808c08ULL, 0x082880808e082880ULL, 0x8080a1082880808fULL,
0xa708288080a60828ULL, 0x288080a908288080ULL, 0x80ec08288080b308ULL, 0x08288080ee082880ULL,
0x8080f208288080f1ULL, 0x8208288080f30828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808082920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL,
0x0001c07000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080830828808081ULL, 0x8608288080840828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL,
0x082880808f082880ULL, 0x8080a608288080a1ULL, 0xa908288080a80828ULL, 0x288080b308288080ULL,
0x80ee08288080ec08ULL, 0x08288080f1082880ULL, 0x8080f308288080f2ULL, 0x8016288080a70828ULL,
0x0000000310288082ULL, 0x80a7920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL,
0x000001c000000000ULL, 0x0001c0b000000000ULL, 0x0000005000000000ULL, 0x0000040400000000ULL,
0x80ec288080a70900ULL, 0x0000000000002880ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL,
0x8608288080840828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL,
0x8080a608288080a1ULL, 0xa908288080a70828ULL, 0x288080b308288080ULL, 0x80ee08288080ec08ULL,
0x08288080f1082880ULL, 0x8080f308288080f2ULL, 0x8016288080a80828ULL, 0x0000000310288082ULL,
0x80a8920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000029800000000ULL,
0x0001c10000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000f7ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x0000001600080a04ULL, 0x0060190300600160ULL, 0x00000000000c1704ULL, 0x0021f00000580009ULL,
0x00000000000c1704ULL, 0x0021f00000500008ULL, 0x00000000000c1704ULL, 0x0011f00000480007ULL,
0x00000000000c1704ULL, 0x0081f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x019c290400000b00ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x019c2804ffffffffULL,
0x000002d000000100ULL, 0x0000298000000580ULL, 0x00002b4000002a30ULL, 0x00002e2000002cb0ULL,
0x000033d000002f80ULL, 0x0000342000003410ULL, 0x0000657000003450ULL, 0x0000672000006600ULL,
0x00006a0000006890ULL, 0x00006fe000006b60ULL, 0x0000703000007020ULL, 0x00009f6000007060ULL,
0x0000a1100000a000ULL, 0x0000a3f00000a280ULL, 0x0000a9c00000a550ULL, 0x0000aa100000aa00ULL,
0x0000da300000aa40ULL, 0x0000dbd00000dac0ULL, 0x0000deb00000dd40ULL, 0x0000e4900000e010ULL,
0x0000e4e00000e4d0ULL, 0x000108700000e510ULL, 0x0001089000010880ULL, 0x00019b50000108a0ULL,
0x00019ba000019b90ULL, 0x00019bc000019bb0ULL, 0x00019c4000019c20ULL, 0x0001b07000019c60ULL,
0x0001b1100001b0c0ULL, 0x0001b1900001b150ULL, 0x0001b2200001b1d0ULL, 0x0001b2c00001b270ULL,
0x0001b3600001b310ULL, 0x0001b4000001b3b0ULL, 0x0001b4800001b440ULL, 0x0001b5100001b4c0ULL,
0x0001b5b00001b560ULL, 0x0001b6500001b600ULL, 0x0001b6f00001b6a0ULL, 0x0001b7700001b730ULL,
0x0001b8000001b7b0ULL, 0x0001b8a00001b850ULL, 0x0001b9400001b8f0ULL, 0x0001b9e00001b990ULL,
0x0001ba600001ba20ULL, 0x0001baf00001baa0ULL, 0x0001bb900001bb40ULL, 0x0001bc300001bbe0ULL,
0x0001bcf00001bc90ULL, 0x0001bdb00001bd50ULL, 0x0001be700001be10ULL, 0x044039040001bed0ULL,
0x000000ff000003a0ULL, 0x003f010000012600ULL, 0x0000000d00000460ULL, 0x003f012000012608ULL,
0x0000000d00000490ULL, 0x003f012000012688ULL, 0x0000000d00000540ULL, 0x003f0120000126a8ULL,
0x0000000d00000560ULL, 0x003f0120000126c8ULL, 0x000000ff00000b20ULL, 0x003f010700012600ULL,
0x0000000600000d10ULL, 0x003f010200000004ULL, 0x0000000600000dc0ULL, 0x003f010100000000ULL,
0x000000ff000017d0ULL, 0x0004010700000000ULL, 0x000000ff00001850ULL, 0x0004010100000000ULL,
0x00000006000018b0ULL, 0x003f010100000020ULL, 0x0000000800001a60ULL, 0x003f0105000126ccULL,
0x0000000800001c30ULL, 0x003f0105000126ccULL, 0x0000000a00002570ULL, 0x003f0107000126b0ULL,
0x0000000a00002620ULL, 0x003f0101000126b0ULL, 0x0000002300002680ULL, 0x003f010100012608ULL,
0x00000023000026a0ULL, 0x003f01050001260cULL, 0x0000002300002870ULL, 0x003f01050001260cULL,
0x0000000a00003130ULL, 0x003f0105000126acULL, 0x0000000a00003300ULL, 0x003f0105000126acULL,
0x0000002a000056e0ULL, 0x003f010100000000ULL, 0x0000002500005740ULL, 0x003f010100012688ULL,
0x0000001300005770ULL, 0x003f010500000004ULL, 0x0000001300005930ULL, 0x003f010500000004ULL,
0x0000002500006180ULL, 0x003f0107000126a8ULL, 0x0000002500006250ULL, 0x003f0101000126a8ULL,
0x00000023000062b0ULL, 0x003f010100012628ULL, 0x00000023000062d0ULL, 0x003f01050001262cULL,
0x00000023000064a0ULL, 0x003f01050001262cULL, 0x0000006d00006d50ULL, 0x003f0105000126b4ULL,
0x0000006d00006f20ULL, 0x003f0105000126b4ULL, 0x0000006e000090d0ULL, 0x003f010100000000ULL,
0x0000002800009130ULL, 0x003f010100012690ULL, 0x0000001300009160ULL, 0x003f010500000004ULL,
0x0000001300009320ULL, 0x003f010500000004ULL, 0x0000002700009b70ULL, 0x003f0107000126b0ULL,
0x0000002700009c40ULL, 0x003f0101000126b0ULL, 0x0000002300009ca0ULL, 0x003f010100012648ULL,
0x0000002300009cc0ULL, 0x003f01050001264cULL, 0x0000002300009e90ULL, 0x003f01050001264cULL,
0x000000700000a730ULL, 0x003f0105000126acULL, 0x000000700000a900ULL, 0x003f0105000126acULL,
0x000000270000cab0ULL, 0x003f010100000000ULL, 0x000000020000cb10ULL, 0x003f010100012698ULL,
0x000000270000cb40ULL, 0x003f010500000004ULL, 0x000000270000cd30ULL, 0x003f010500000004ULL,
0x000000030000d690ULL, 0x003f0107000126a8ULL, 0x000000030000d720ULL, 0x003f0101000126a8ULL,
0x000000060000d780ULL, 0x003f010100012668ULL, 0x000000060000d7b0ULL, 0x003f01050001266cULL,
0x000000060000d980ULL, 0x003f01050001266cULL, 0x000000120000e1f0ULL, 0x003f0105000126b4ULL,
0x000000120000e3c0ULL, 0x003f0105000126b4ULL, 0x0000001300010620ULL, 0x003f010100000000ULL,
0x00000006000106a0ULL, 0x003f010100000000ULL, 0x000000ff00012460ULL, 0x003f010100012600ULL,
0x000000ff00013080ULL, 0x003f010500012604ULL, 0x000000ff00013250ULL, 0x003f010500012604ULL,
0x000000ff000135d0ULL, 0x003f010100012600ULL, 0x000000ff00013600ULL, 0x003f010500012604ULL,
0x000000ff000137c0ULL, 0x003f010500012604ULL, 0x0000006100017040ULL, 0x003f010100000000ULL,
0x0000006100017140ULL, 0x003f010500000004ULL, 0x0000006100017310ULL, 0x003f010500000004ULL,
0x000000620001aed0ULL, 0x003f010100000000ULL, 0x000000620001af30ULL, 0x003f010100000008ULL,
0x000000620001af90ULL, 0x003f010100000010ULL, 0x000000620001b000ULL, 0x003f010100000018ULL,
0x00301c0400053803ULL, 0x0001183000011800ULL, 0x00011b7000011a10ULL, 0x00011e3000011cd0ULL,
0x000120f000011f90ULL, 0x0001238000012280ULL, 0x0001b04000013820ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000034cULL, 0x0000001900000002ULL, 0x0000000000000274ULL,
0x0000001900000002ULL, 0x00000000000001acULL, 0x0000001900000002ULL, 0x00000000000000ccULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000325ULL,
0x0000001900000002ULL, 0x000000000000024dULL, 0x0000001900000002ULL, 0x0000000000000182ULL,
0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL, 0x0000000000012700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff5c7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000767919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a005c827a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL,
0x00000005ff207819ULL, 0x010fc80000011609ULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x00001fff20207589ULL, 0x000fe200000e0000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x010fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e025cULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007603197227ULL, 0x004fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a19ULL,
0x0000000007007224ULL, 0x000fca00078e0276ULL, 0x000000070000720cULL, 0x000fe20003f46070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000e6400000e0000ULL,
0x00000000020d7a24ULL, 0x000fca00078e0209ULL, 0x000000ff0d00720cULL, 0x000fc60003fa5270ULL,
0x0000000100002824ULL, 0x000fe200078e0a07ULL, 0x0000000119192810ULL, 0x000fe40007ffe0ffULL,
0x0000007f0d00780cULL, 0x040fe40003f04070ULL, 0x000000070000720cULL, 0x000fe40003f66070ULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000030d00780cULL, 0x000fe20003f44070ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL,
0xff317217ff0a8424ULL, 0x000fe400078e00ffULL, 0x0000000119193810ULL, 0x000fe20007ffe0ffULL,
0x01260002ff00d388ULL, 0x0005e20000000a00ULL, 0x00000007ff19c212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f64070ULL,
0x0124000a0d008388ULL, 0x0003e20000004800ULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x00005a0019757a19ULL, 0x000fe200000006ffULL, 0x000000ffff007224ULL, 0x000fc400078e0a19ULL,
0x3fffff60ff06a424ULL, 0x000fe200078e00ffULL, 0x0000000000027919ULL, 0x004ea20000002700ULL,
0x0000000007767224ULL, 0x000fe400078e0276ULL, 0x7fffff60ff07a424ULL, 0x000fe200078e00ffULL,
0x012608040d009388ULL, 0x0007e20000008a00ULL, 0x0000002076007824ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff08b424ULL, 0x000fe200078e00ffULL, 0x012688060d00a388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff09b424ULL, 0x000fe200078e00ffULL, 0x0000000400037c10ULL, 0x040fe2000fffe1ffULL,
0x000000040b0a7824ULL, 0x002fe200078e0220ULL, 0x0000000400007c0cULL, 0x000fc4000bf03070ULL,
0x0000002003037817ULL, 0x000fe20003800000ULL, 0x000000040a0a7824ULL, 0x000fe400078e00ffULL,
0x3fffff80ff04a424ULL, 0x008fe200078e00ffULL, 0x000000ff03747207ULL, 0x000fe20000000000ULL,
0x7fffff80ff05a424ULL, 0x000fc600078e00ffULL, 0x000000207400780cULL, 0x000fe40003f05270ULL,
0x0126a8040d00a388ULL, 0x000fe20000008a00ULL, 0x0000580002037a24ULL, 0x004fc600078e02ffULL,
0x0126c8080d00b388ULL, 0x000fe20000008a00ULL, 0x0000008203037224ULL, 0x000fc600078e0275ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000a74057217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fc4000800063fULL, 0x0000000105057824ULL, 0x000fe200078e0a0aULL,
0x00000004ff047819ULL, 0x002fc8000001161fULL, 0x0000000204097810ULL, 0x000fe20007ffe0ffULL,
0x000000010a087824ULL, 0x000fe200078e0204ULL, 0x000000050400720cULL, 0x080fe40003f06070ULL,
0x000000050900720cULL, 0x000fe20003f26070ULL, 0x000000010a0d7824ULL, 0x000fe400078e0209ULL,
0x0000000100067824ULL, 0x040fe400078e0208ULL, 0x00000001000e7824ULL, 0x000fe400078e020dULL,
0x00000001080a7824ULL, 0x000fe200078e021fULL, 0x00000004060c7c12ULL, 0x000fc4000f8e30ffULL,
0x000000040e107c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fe20000011606ULL,
0x00000001030c7824ULL, 0x040fe200078e020cULL, 0x00005a00ff0f7a19ULL, 0x000fe2000001160eULL,
0x0000000103107824ULL, 0x000fe400078e0210ULL, 0x0000008207047224ULL, 0x080fe400078e020cULL,
0x000000101f037824ULL, 0x000fe400078e00ffULL, 0x000000820f067224ULL, 0x000fc400078e0210ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f003097812ULL, 0x000fc600078ec0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000904047212ULL, 0x000fc600078efcffULL,
0x00000010080f7824ULL, 0x000fe200078e00ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x000000010d087824ULL, 0x040fe200078e021fULL, 0x00005e0004047a10ULL, 0x000fe20007f5e0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff00f0a7812ULL, 0x000fe400078ee20aULL,
0x00005e0006067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00d087812ULL, 0x000fe200078ee208ULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x00005f0005057a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000c101c48ULL,
0x00000000060d7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000a1f0a7211ULL, 0x002fc800078fe0ffULL, 0x000000020a097810ULL, 0x000fe20007ffe0ffULL,
0x0000000100047824ULL, 0x000fe400078e020aULL, 0x000000100a0f7824ULL, 0x000fe400078e00ffULL,
0x0000000100077824ULL, 0x000fe200078e0209ULL, 0x0000000404067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe40000011604ULL, 0x0000000407087c12ULL, 0x000fe2000f8e30ffULL,
0x0000000103067824ULL, 0x000fe200078e0206ULL, 0x00005a00ff077a19ULL, 0x000fc60000011607ULL,
0x0000000103087824ULL, 0x000fe400078e0208ULL, 0x0000008205057224ULL, 0x080fe400078e0206ULL,
0x000000101f037824ULL, 0x000fe400078e00ffULL, 0x0000008207077224ULL, 0x000fe400078e0208ULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f0030d7812ULL, 0x000fc600078ec0ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000d04047212ULL, 0x000fc600078efcffULL,
0x000000010a087824ULL, 0x100fe200078e021fULL, 0x0000000d06067212ULL, 0x000fe200078efcffULL,
0x00000001090a7824ULL, 0x040fe200078e021fULL, 0x00005e0004047a10ULL, 0x000fe20007f1e0ffULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0xfffffff00f087812ULL, 0x000fe400078ee208ULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff0090a7812ULL, 0x000fe200078ee20aULL,
0x0000001008097824ULL, 0x000fe200078e00ffULL, 0x00005f0005057a10ULL, 0x000fc400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x000000100a0d7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000b901c48ULL,
0x00000000060d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff257424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600047300ULL, 0x000e7000000e0000ULL,
0x0000000600077309ULL, 0x000ea20000000000ULL, 0x000000050400720cULL, 0x002fe20003f02070ULL,
0x0000660002047625ULL, 0x000fc800078e0025ULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01260407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01260000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008041e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000003f1e1d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff1e087810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff1d7819ULL, 0x000fe4000001161dULL,
0x00000008ff1c7819ULL, 0x000fca0000011608ULL, 0x0001173000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1b7819ULL, 0x000fe20000011620ULL, 0x00000003ff077424ULL, 0x002fe200078e00ffULL,
0x0001268820067811ULL, 0x000fe400078e18ffULL, 0x03ffffff1b187812ULL, 0x000fc800078ec0ffULL,
0x0000001d1800720cULL, 0x000fda0003f06070ULL, 0x0000000202008824ULL, 0x000fe400078e00ffULL,
0x00006800ff058624ULL, 0x000fc800078e00ffULL, 0x0000680000058624ULL, 0x000fe400078e0205ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000118058824ULL, 0x000fe200078e0205ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040706ff738cULL, 0x0003e20000000000ULL,
0x0000640005048625ULL, 0x000fe200078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000804008981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x0000004019197824ULL, 0x000fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011620ULL,
0x0000000006ff7f8cULL, 0x0007e8000c80043fULL, 0x000000201a777824ULL, 0x000fca00078e00ffULL,
0x0000002019077812ULL, 0x002fe200078ef877ULL, 0x0000590000087a24ULL, 0x004fe200078e02ffULL,
0x0000000120007812ULL, 0x000fc600078ec0ffULL, 0x0000004008137824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x008fe200078e00ffULL,
0x000000771e007217ULL, 0x000fe40007800000ULL, 0x00000003ff047819ULL, 0x000fe4000001161fULL,
0x00006200130f7a11ULL, 0x000fe200078838ffULL, 0x0000000100007824ULL, 0x000fe200078e0a77ULL,
0x0000000404097810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x000fe200078e0204ULL,
0x0000000c040a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000500007217ULL, 0x000fe20007800000ULL,
0x0000000106087824ULL, 0x040fe200078e021fULL, 0x0000630013137a11ULL, 0x000fe200020f3cffULL,
0x00000008060b7824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a05ULL,
0x0000000105107824ULL, 0x000fe200078e020aULL, 0xfffffff80b0c7812ULL, 0x000fe400078ee208ULL,
0x0000000804087810ULL, 0x000fe20007ffe0ffULL, 0x00000001100d7824ULL, 0x000fe200078e021fULL,
0x000000000400720cULL, 0x080fe20003f66070ULL, 0x0000000107047824ULL, 0x000fe200078e0206ULL,
0x000000000800720cULL, 0x080fe20003f26070ULL, 0x0000000105067824ULL, 0x000fe200078e0209ULL,
0x000000000900720cULL, 0x080fe20003f46070ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x000000000a00720cULL, 0x000fe20003f06070ULL, 0x0000000106057824ULL, 0x000fc400078e021fULL,
0x00000008060e7824ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x040fe400078e021fULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0xfffffff80e007812ULL, 0x000fe200078ee205ULL,
0x0000008004047825ULL, 0x000fc600078e00ffULL, 0xfffffff8120e7812ULL, 0x000fe200078ee209ULL,
0x0000000107067824ULL, 0x040fe200078e0206ULL, 0x0000007004047812ULL, 0x000fe200078ef803ULL,
0x0000000107087824ULL, 0x040fe400078e0208ULL, 0x00000001070a7824ULL, 0x000fe200078e0210ULL,
0x000000040f047210ULL, 0x000fe20007f9e0ffULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fc600078ef803ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef803ULL,
0x0000000810107824ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x0000000105057824ULL, 0x000fe200020e0613ULL, 0x0000e0001a037811ULL, 0x000fe400078e68ffULL,
0x0000000f06067210ULL, 0x080fe40007f9e0ffULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000100e117824ULL, 0x000fe200078e0203ULL, 0xfffffff810107812ULL, 0x000fe200078ee20dULL,
0x000000100c0d7824ULL, 0x100fe200078e0203ULL, 0x0000000f0a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010000f7824ULL, 0x000fc400078e0203ULL, 0x0000000107077824ULL, 0x100fe200020e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000d901c48ULL,
0x0000000109097824ULL, 0x000fe400028e0613ULL, 0x0000001010037824ULL, 0x000fe200078e0203ULL,
0x00000000060f7faeULL, 0x0003e2000d101c48ULL, 0x000000010b0b7824ULL, 0x000fc600030e0613ULL,
0x0000000008117faeULL, 0x0003e8000c901c48ULL, 0x000000000a037faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x0000620013117a11ULL, 0x000fe400078038ffULL, 0x0000e0001a157811ULL, 0x000fe400078e68ffULL,
0x000000001f007211ULL, 0x000fc400078fe8ffULL, 0x0000630013137a11ULL, 0x000fe400000f3cffULL,
0x0000000400067810ULL, 0x040fe20007ffe0ffULL, 0x0000000100047824ULL, 0x140fe200078e021fULL,
0x0000000800087810ULL, 0x040fe20007ffe0ffULL, 0x0000000800057824ULL, 0x000fe400078e00ffULL,
0x00000008060a7824ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x100fe200078e021fULL,
0xfffffff8050c7812ULL, 0x000fe200078ee204ULL, 0x0000000106057824ULL, 0x000fc400078e021fULL,
0x0000000107047824ULL, 0x000fe200078e0200ULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x00000008080e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0d7812ULL, 0x000fe200078ee205ULL,
0x0000008004047825ULL, 0x000fc600078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x0000000107067824ULL, 0x040fe200078e0206ULL, 0x0000007004047812ULL, 0x000fe200078ef803ULL,
0x0000000107087824ULL, 0x040fe400078e0208ULL, 0x00000001070a7824ULL, 0x000fe200078e0200ULL,
0x0000000411047210ULL, 0x000fe20007f1e0ffULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fc600078ef803ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef803ULL,
0x00000001000f7824ULL, 0x000fe200078e021fULL, 0x000000700a037812ULL, 0x000fe200078ef803ULL,
0x0000000800007824ULL, 0x000fe200078e00ffULL, 0x0000000811087210ULL, 0x000fe20007f3e0ffULL,
0x0000000105057824ULL, 0x000fe200000e0613ULL, 0x0000000611067210ULL, 0x000fe20007f1e0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0215ULL, 0xfffffff800007812ULL, 0x000fe200078ee20fULL,
0x000000100e0f7824ULL, 0x100fe200078e0215ULL, 0x00000003110a7210ULL, 0x000fe20007f5e0ffULL,
0x000000100c037824ULL, 0x000fc400078e0215ULL, 0x0000000107077824ULL, 0x100fe400000e0613ULL,
0x0000000109097824ULL, 0x000fe200008e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000b901c48ULL, 0x0000001000117824ULL, 0x000fe400078e0215ULL,
0x000000010b0b7824ULL, 0x000fe200010e0613ULL, 0x00000000060d7faeULL, 0x0003e8000b901c48ULL,
0x00000000080f7faeULL, 0x0003e8000b901c48ULL, 0x000000000a117faeULL, 0x0003e4000b901c48ULL,
0x0000000118187810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0x0000001d1800720cULL, 0x000fda0003f06070ULL, 0x0000006000000947ULL, 0x000fea0003800000ULL,
0x0000000202007824ULL, 0x000fe400078e00ffULL, 0x00006800ff037624ULL, 0x002fc800078e00ffULL,
0x0000680000037624ULL, 0x000fc800078e0203ULL, 0x0000000103247824ULL, 0x000fc800078e0218ULL,
0x0000640024247625ULL, 0x000fcc00078e0025ULL, 0x0000000824247981ULL, 0x000324000c1e1900ULL,
0x000000001a0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000126a81a067811ULL, 0x002fe200078e18ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x000126a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff597224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff047f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff587224ULL, 0x000fe200078e00ffULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x00000000006a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000ed8000008947ULL, 0x000fea0003800000ULL,
0x0000000202177824ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fc400078e00ffULL,
0x000000101a157824ULL, 0x000fe400078e00ffULL, 0x0000680017177624ULL, 0x000fe400078e0202ULL,
0x000000ffff007224ULL, 0x002fe200078e0005ULL, 0x0000001015157812ULL, 0x000fe200078ee2ffULL,
0x000000ffff037224ULL, 0x004fe400078e0007ULL, 0xff317217ff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff167224ULL, 0x000fc400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fc400078e00ffULL,
0x000000ffff147224ULL, 0x000fe400078e0018ULL, 0x000000ffff0a7224ULL, 0x00afc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x0000000420067824ULL, 0x000fca00078e00ffULL,
0xfffffff806087812ULL, 0x000fc800078ec0ffULL, 0x000126c808137810ULL, 0x000fe20007ffe0ffULL,
0x0126cc0008067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020037824ULL, 0x000fe200078e00ffULL,
0x0000000116077810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x010fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000004024247824ULL, 0x000fe200078e00ffULL,
0x0000001c0700720cULL, 0x000fc60003f26070ULL, 0x0000010016057824ULL, 0x000fca00078e0205ULL,
0x0000004005057810ULL, 0x000fc80007ffe0ffULL, 0x0000002005047812ULL, 0x000fca00078ec0ffULL,
0x00000001190b7824ULL, 0x000fe200078e0204ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe400078ec0ffULL, 0x000000051e037217ULL, 0x000fe40007800000ULL,
0x00000003ff077819ULL, 0x000fe4000001161fULL, 0x0000620024257a11ULL, 0x040fe200078a38ffULL,
0x0000000103037824ULL, 0x000fe200078e0a05ULL, 0x0000000407087810ULL, 0x040fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe200078e0204ULL, 0x0000630024277a11ULL, 0x000fc400028f3cffULL,
0x0000000403037217ULL, 0x000fe20007800000ULL, 0x0000000106057824ULL, 0x040fe400078e021fULL,
0x00000008060a7824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fc600078e0a04ULL,
0xfffffff80a117812ULL, 0x000fe400078ee205ULL, 0x00000008070a7810ULL, 0x040fe40007ffe0ffULL,
0x000000030700720cULL, 0x0c0fe40003f86070ULL, 0x000000030a00720cULL, 0x0c0fe20003f46070ULL,
0x000000010a0a7824ULL, 0x000fe200078e0204ULL, 0x0000000c07077810ULL, 0x000fe40007ffe0ffULL,
0x000000030800720cULL, 0x080fe20003f66070ULL, 0x000000010a057824ULL, 0x040fe200078e021fULL,
0x000000030700720cULL, 0x000fe20003f06070ULL, 0x000000080a287824ULL, 0x000fc400078e00ffULL,
0x0000000108087824ULL, 0x100fe400078e0204ULL, 0x0000000107127824ULL, 0x000fe200078e0204ULL,
0xfffffff828217812ULL, 0x000fe200078ee205ULL, 0x000000101f077824ULL, 0x000fe400078e00ffULL,
0x000000010b047824ULL, 0x040fe400078e0206ULL, 0x000000010b067824ULL, 0x000fe200078e0208ULL,
0x0000007007297812ULL, 0x000fe200078ec0ffULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000002904047212ULL, 0x000fc600078efcffULL,
0x0000000108037824ULL, 0x040fe200078e021fULL, 0x0000000425047210ULL, 0x000fe20007fbe0ffULL,
0x0000000808267824ULL, 0x000fe200078e00ffULL, 0x0000002906067212ULL, 0x000fe200078efcffULL,
0x000000010b087824ULL, 0x040fe400078e020aULL, 0x000000010b0a7824ULL, 0x000fe200078e0212ULL,
0xfffffff826037812ULL, 0x000fe200078ee203ULL, 0x0000000112237824ULL, 0x000fe400078e021fULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x0000000812127824ULL, 0x000fe200078e00ffULL,
0x0000002908087212ULL, 0x000fe200078efcffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff812237812ULL, 0x000fe200078ee223ULL, 0x0000000105057824ULL, 0x100fe200028e0627ULL,
0x0000002506067210ULL, 0x000fe40007fbe0ffULL, 0x000000290a0a7212ULL, 0x000fe400078efcffULL,
0x0000f0001a127811ULL, 0x000fe200078e68ffULL, 0x0000000107077824ULL, 0x000fe200028e0627ULL,
0x0000002508087210ULL, 0x080fe40007fbe0ffULL, 0x000000250a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001011117824ULL, 0x000fc400078e0212ULL, 0x0000001003037824ULL, 0x100fe400078e0212ULL,
0x0000001021217824ULL, 0x100fe200078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e2000e101c48ULL, 0x0000000109097824ULL, 0x100fe400028e0627ULL,
0x0000001023237824ULL, 0x000fe200078e0212ULL, 0x0000000006037faeULL, 0x0003e2000d901c48ULL,
0x000000010b0b7824ULL, 0x000fc600030e0627ULL, 0x0000000008217faeULL, 0x0003e8000d101c48ULL,
0x000000000a237faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101f097824ULL, 0x040fe200078e00ffULL,
0x0000620024277a11ULL, 0x000fe400078038ffULL, 0x000000041f047211ULL, 0x000fe400078fe8ffULL,
0x0000007009257812ULL, 0x000fc400078ec0ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104037824ULL, 0x140fe200078e021fULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x000fe200078e00ffULL, 0x0000630024297a11ULL, 0x000fe200000f3cffULL,
0x0000000106057824ULL, 0x040fe400078e021fULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0xfffffff80a037812ULL, 0x000fe200078ee203ULL, 0x0000000108077824ULL, 0x040fe400078e021fULL,
0x00000008080a7824ULL, 0x000fe200078e00ffULL, 0xfffffff812117812ULL, 0x000fe200078ee205ULL,
0x000000010b057824ULL, 0x000fc400078e0204ULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0xfffffff80a127812ULL, 0x000fe200078ee207ULL, 0x000000010b087824ULL, 0x000fe200078e0208ULL,
0x0000000c040a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008005047825ULL, 0x000fc800078e00ffULL,
0x000000010b0b7824ULL, 0x000fe200078e020aULL, 0x0000002504047212ULL, 0x000fe200078efcffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0x0000000427047210ULL, 0x000fe20007f1e0ffULL,
0x000000010a217824ULL, 0x000fe200078e021fULL, 0x0000002506067212ULL, 0x000fe200078efcffULL,
0x000000080a247824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff824237812ULL, 0x000fe200078ee221ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000002508087212ULL, 0x080fe400078efcffULL, 0x0000f0001a247811ULL, 0x000fe200078e68ffULL,
0x0000000105057824ULL, 0x100fe200000e0629ULL, 0x000000250a0a7212ULL, 0x000fe400078efcffULL,
0x0000000627067210ULL, 0x000fe20007f1e0ffULL, 0x0000001003037824ULL, 0x100fe200078e0224ULL,
0x0000000827087210ULL, 0x000fe20007f5e0ffULL, 0x0000001011117824ULL, 0x100fe200078e0224ULL,
0x0000000a270a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000107077824ULL, 0x000fe200000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c48ULL,
0x0000001012217824ULL, 0x000fc400078e0224ULL, 0x0000000109097824ULL, 0x100fe200010e0629ULL,
0x0000000006117faeULL, 0x0003e2000b901c48ULL, 0x0000001023237824ULL, 0x000fe400078e0224ULL,
0x000000010b0b7824ULL, 0x000fe200018e0629ULL, 0x0000000008217faeULL, 0x0003e8000b901c48ULL,
0x000000000a237faeULL, 0x0003e4000b901c48ULL, 0x0000000820037824ULL, 0x002fe200078e00ffULL,
0x0000000118047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001d0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0473c2ULL, 0x000e6200000e0000ULL, 0xffffffe003237812ULL, 0x040fe400078ec0ffULL,
0x0000001003067812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000117048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002303237210ULL, 0x000fe40007ffe006ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640004048625ULL, 0x000fca00078e0005ULL, 0x0000000804248981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b0000a6e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080023087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01260c0023037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0023037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101f127824ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe2000001161fULL,
0x0000002020037824ULL, 0x000fe400078e00ffULL, 0xffffffffff807424ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc400078ec0ffULL, 0xffffff8003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c11117812ULL, 0x000fc800078ec0ffULL, 0x0000000311037210ULL, 0x000fca0007ffe012ULL,
0x0120000003057984ULL, 0x000e680000000800ULL, 0x0122000003077984ULL, 0x0006a20000000800ULL,
0x000000020500720bULL, 0x002fe20003f1d000ULL, 0x000186d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x008fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fc400078e0002ULL, 0x0000001fff847424ULL, 0x000fe400078e00ffULL,
0xffffffffff817424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x000000201b00720cULL, 0x000fe40003f05270ULL, 0x000000020500720bULL, 0x000fe20003f54000ULL,
0x000186727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000047806ULL, 0x000fc400010e0100ULL,
0x0000008020088824ULL, 0x000fe200078e0212ULL, 0x0000000205217209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000111088824ULL, 0x000fca00078e0208ULL,
0x0124002108008388ULL, 0x0003e20000000800ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000000221027221ULL, 0x002fe20000010100ULL,
0x000000ff04ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL, 0x0000000200027308ULL, 0x000e640000000800ULL,
0x0000000222227220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x000185b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2902287589ULL, 0x0002e400000e0000ULL, 0x0000002868687220ULL, 0x08cfe20000410000ULL,
0x0000002869697220ULL, 0x080fe20000410000ULL, 0x0000002864647220ULL, 0x080fe20000410000ULL,
0x0000002865657220ULL, 0x080fe20000410000ULL, 0x0000002860607220ULL, 0x080fe20000410000ULL,
0x0000002861617220ULL, 0x080fe20000410000ULL, 0x000000285c5c7220ULL, 0x080fe20000410000ULL,
0x000000285d5d7220ULL, 0x080fe20000410000ULL, 0x0000002858587220ULL, 0x080fe20000410000ULL,
0x0000002859597220ULL, 0x080fe20000410000ULL, 0x0000002854547220ULL, 0x080fe20000410000ULL,
0x0000002855557220ULL, 0x080fe20000410000ULL, 0x0000002850507220ULL, 0x080fe20000410000ULL,
0x0000002851517220ULL, 0x080fe20000410000ULL, 0x000000284c4c7220ULL, 0x080fe20000410000ULL,
0x000000284d4d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0004ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x002fe200078ff0ffULL,
0x000184827f007947ULL, 0x000fea000b800000ULL, 0x00001f2902287589ULL, 0x0002e400000e0000ULL,
0x000000286a6a7220ULL, 0x08cfe20000410000ULL, 0x000000286b6b7220ULL, 0x080fe20000410000ULL,
0x0000002866667220ULL, 0x080fe20000410000ULL, 0x0000002867677220ULL, 0x080fe20000410000ULL,
0x0000002862627220ULL, 0x080fe20000410000ULL, 0x0000002863637220ULL, 0x080fe20000410000ULL,
0x000000285e5e7220ULL, 0x080fe20000410000ULL, 0x000000285f5f7220ULL, 0x080fe20000410000ULL,
0x000000285a5a7220ULL, 0x080fe20000410000ULL, 0x000000285b5b7220ULL, 0x080fe20000410000ULL,
0x0000002856567220ULL, 0x080fe20000410000ULL, 0x0000002857577220ULL, 0x080fe20000410000ULL,
0x0000002852527220ULL, 0x080fe20000410000ULL, 0x0000002853537220ULL, 0x080fe20000410000ULL,
0x000000284e4e7220ULL, 0x080fe20000410000ULL, 0x000000284f4f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000004ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x002fe200078ff0ffULL, 0x000183527f007947ULL, 0x000fea000b800000ULL,
0x00001f2902287589ULL, 0x0002e400000e0000ULL, 0x0000002848487220ULL, 0x08cfe20000410000ULL,
0x0000002849497220ULL, 0x080fe20000410000ULL, 0x0000002844447220ULL, 0x080fe20000410000ULL,
0x0000002845457220ULL, 0x080fe20000410000ULL, 0x0000002840407220ULL, 0x080fe20000410000ULL,
0x0000002841417220ULL, 0x080fe20000410000ULL, 0x000000283c3c7220ULL, 0x080fe20000410000ULL,
0x000000283d3d7220ULL, 0x080fe20000410000ULL, 0x0000002838387220ULL, 0x080fe20000410000ULL,
0x0000002839397220ULL, 0x080fe20000410000ULL, 0x0000002834347220ULL, 0x080fe20000410000ULL,
0x0000002835357220ULL, 0x080fe20000410000ULL, 0x0000002830307220ULL, 0x080fe20000410000ULL,
0x0000002831317220ULL, 0x080fe20000410000ULL, 0x000000282c2c7220ULL, 0x080fe20000410000ULL,
0x000000282d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000004ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x002fe200078ff0ffULL, 0x000182327f007947ULL, 0x000fea000b800000ULL,
0x00001f2902287589ULL, 0x0002e400000e0000ULL, 0x000000284a4a7220ULL, 0x08cfe20000410000ULL,
0x000000284b4b7220ULL, 0x080fe20000410000ULL, 0x0000002846467220ULL, 0x080fe20000410000ULL,
0x0000002847477220ULL, 0x080fe20000410000ULL, 0x0000002842427220ULL, 0x080fe20000410000ULL,
0x0000002843437220ULL, 0x080fe20000410000ULL, 0x000000283e3e7220ULL, 0x080fe20000410000ULL,
0x000000283f3f7220ULL, 0x080fe20000410000ULL, 0x000000283a3a7220ULL, 0x080fe20000410000ULL,
0x000000283b3b7220ULL, 0x080fe20000410000ULL, 0x0000002836367220ULL, 0x080fe20000410000ULL,
0x0000002837377220ULL, 0x080fe20000410000ULL, 0x0000002832327220ULL, 0x080fe20000410000ULL,
0x0000002833337220ULL, 0x080fe20000410000ULL, 0x000000282e2e7220ULL, 0x080fe20000410000ULL,
0x000000282f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000403ff7212ULL, 0x000fda00078030ffULL, 0x8000002105050221ULL, 0x000fe20000010000ULL,
0x00007610ff060816ULL, 0x000fc60000000006ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x0000000500100308ULL, 0x000e640000000800ULL, 0x0000001007070220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002207227221ULL, 0x004fc20000010000ULL,
0x0000000000027805ULL, 0x000fcc0000015200ULL, 0x0126ac000a057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac000a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991006007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000010ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe4000001161fULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x00017e227f007947ULL, 0x000fea000b800000ULL, 0x00001f03000f7589ULL, 0x0002a400000e0000ULL,
0x0000000803297810ULL, 0x002fe20007ffe0ffULL, 0x00017e527f007947ULL, 0x000fea000b800000ULL,
0x00000010030d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f29000e7589ULL, 0x0002ea00000e0000ULL,
0x00001f0d000d7589ULL, 0x0002a400000e0000ULL, 0x0000001803297810ULL, 0x002fe20007ffe0ffULL,
0x00017ea27f007947ULL, 0x000fea000b800000ULL, 0x00001f29000c7589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000220257824ULL, 0x040fe200078e00ffULL,
0x000000081f007812ULL, 0x002fe200078ec0ffULL, 0x0000000420047824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100020057824ULL, 0x000fe200078e00ffULL,
0x0000000425027812ULL, 0x000fe200078ec0ffULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x00000007000b7812ULL, 0x000fc400078ef81fULL, 0x000000021f007211ULL, 0x000fe400078fe0ffULL,
0x000000100b0a7812ULL, 0x040fe200078efcffULL, 0x000000080b067824ULL, 0x040fe200078e00ffULL,
0x0000000404047812ULL, 0x000fe200078ec0ffULL, 0x000000010b097824ULL, 0x000fe200078e0200ULL,
0xffffe00005057812ULL, 0x000fe200078ec0ffULL, 0x0000000100087824ULL, 0x000fe400078e020aULL,
0x0000040020007824ULL, 0x000fe200078e00ffULL, 0xfffffff806097812ULL, 0x000fe200078ee209ULL,
0x000000080a037824ULL, 0x000fe200078e00ffULL, 0x0000e00005057810ULL, 0x000fe20007ffe0ffULL,
0x000000080b077824ULL, 0x040fe200078e00ffULL, 0xfffff00000007812ULL, 0x000fe200078ec0ffULL,
0x000000080b277824ULL, 0x000fe200078e00ffULL, 0xfffffff803087812ULL, 0x000fc400078ee208ULL,
0x000000041f037211ULL, 0x000fe400078fe0ffULL, 0x0000a00000007810ULL, 0x000fc60007ffe0ffULL,
0x000000010b047824ULL, 0x000fe400078e0203ULL, 0x0000001009707824ULL, 0x100fe400078e0200ULL,
0x0000001008287824ULL, 0x000fe200078e0200ULL, 0xfffffff807077812ULL, 0x000fe400078ee204ULL,
0x0000000204067810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000e640000000200ULL,
0x0000001007787824ULL, 0x000fc400078e0205ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707231ULL, 0x086fe400003400ffULL,
0x0000000f72727231ULL, 0x000fe400003400ffULL, 0x0000000e71717231ULL, 0x088fe400003400ffULL,
0x0000000e73737231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x080fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fc400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0xfffffff827067812ULL, 0x000fe200078ee206ULL,
0x0000106000007945ULL, 0x000fe20003800000ULL, 0x0000000202027812ULL, 0x000fc600078efcffULL,
0x00000010067c7824ULL, 0x000fe200078e0205ULL, 0x000000021f027211ULL, 0x000fca00078fe0ffULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x0000010078277824ULL, 0x008fe200078e00ffULL,
0x0000007800047306ULL, 0x000fe20000009400ULL, 0x00000018ff957819ULL, 0x000fe20000011478ULL,
0x0000010079947824ULL, 0x040fe200078e00ffULL, 0x00000018ffa17819ULL, 0x000fe20000011479ULL,
0x00010000799e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x000001007aa67824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011494ULL,
0x0000007800057306ULL, 0x000ee20000005400ULL, 0x000001007ba97824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe2000001147aULL, 0x000001007dc17824ULL, 0x004fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe200000114a6ULL, 0x000001007cba7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fc400000114a9ULL, 0x0000002700927306ULL, 0x000fe20000209400ULL,
0x00000018ffb57819ULL, 0x000fe4000001147bULL, 0x00000018ffc17819ULL, 0x000fe400000114c1ULL,
0x00000018ff9e7819ULL, 0x000fe4000001149eULL, 0x00000018ff917819ULL, 0x000fe2000001147cULL,
0x0000002700937306ULL, 0x0004620000205400ULL, 0x000000050400720bULL, 0x008fe40003f9d000ULL,
0x00000018ff8c7819ULL, 0x000fc4000001147dULL, 0x00000018ff6c7819ULL, 0x000fe4000001147fULL,
0x0000009b00057245ULL, 0x000fe2000020d400ULL, 0x0000007800267306ULL, 0x000662000000d400ULL,
0x0000002700277245ULL, 0x004fe4000020d400ULL, 0x00000018ff6d7819ULL, 0x000fe4000001147eULL,
0x00000018ffba7819ULL, 0x000fc600000114baULL, 0x0000007900987306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x000000939200720bULL, 0x002fe20003fdd000ULL,
0x000100007d927824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007900997306ULL, 0x000e620000005400ULL, 0x00000018ff927819ULL, 0x000fe40000011492ULL,
0x0000000126264812ULL, 0x000fc800078efcffULL, 0x0000000127276812ULL, 0x000fe200078efcffULL,
0x00000079009a7306ULL, 0x000eb0000000d400ULL, 0x0000007800947306ULL, 0x000fe20000209400ULL,
0x000000999800720bULL, 0x002fe20003f5d000ULL, 0x000100007e987824ULL, 0x000fca00078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x0000007800797306ULL, 0x0002ec0000205400ULL,
0x000000019a9a2812ULL, 0x004fe400078efcffULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fce000020d400ULL, 0x0000009500977306ULL, 0x0002a20000205400ULL,
0x000000799400720bULL, 0x008fe40003fdd000ULL, 0x000000a600797245ULL, 0x000fca000020d400ULL,
0x000000a600a77306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x002fca000020d400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x000000a600a87306ULL, 0x000e620000205400ULL,
0x000000979600720bULL, 0x004fce0003fbd000ULL, 0x000000a100a27306ULL, 0x000fec0000209400ULL,
0x0000000195955812ULL, 0x000fe400078efcffULL, 0x000000a100a37306ULL, 0x0004e20000205400ULL,
0x000000a8a700720bULL, 0x002fce0003fdd000ULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a100a17245ULL, 0x004fca000020d400ULL, 0x0000000179796812ULL, 0x000fe400078efcffULL,
0x000000b000b27306ULL, 0x0002a20000205400ULL, 0x000000a3a200720bULL, 0x008fce0003f5d000ULL,
0x0000007a00a47306ULL, 0x000fe20000009400ULL, 0x000000b000b07245ULL, 0x002fca000020d400ULL,
0x00000001a1a12812ULL, 0x000fe400078efcffULL, 0x0000007a00a57306ULL, 0x000e620000005400ULL,
0x000000b2b100720bULL, 0x004fce0003fbd000ULL, 0x0000007a008e7306ULL, 0x0004ec000000d400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x0000007b00ae7306ULL, 0x000fe20000009400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x000000a5a400720bULL, 0x002fc80003f9d000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007b00af7306ULL, 0x000fee0000005400ULL,
0x000000018e8e4812ULL, 0x008fe200078efcffULL, 0x0000007b008d7306ULL, 0x0003f0000000d400ULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000ab00ad7306ULL, 0x0002b00000205400ULL,
0x0000009b009c7306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fce000020d400ULL,
0x0000009b009d7306ULL, 0x000e620000205400ULL, 0x000000adac00720bULL, 0x004fce0003fdd000ULL,
0x0000007a00a97306ULL, 0x000fec0000209400ULL, 0x00000001abab6812ULL, 0x000fe400078efcffULL,
0x0000007a00aa7306ULL, 0x0004e20000205400ULL, 0x0000009d9c00720bULL, 0x002fe20003f7d000ULL,
0x000001007f9c7824ULL, 0x000fc400078e00ffULL, 0x000100007f9d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe2000001149cULL, 0x0000007b00b37306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x004fe4000020d400ULL, 0x00000018ff9d7819ULL, 0x000fc6000001149dULL,
0x0000000105053812ULL, 0x000fe400078efcffULL, 0x0000007b00b47306ULL, 0x0002a20000205400ULL,
0x000000aaa900720bULL, 0x008fe40003f5d000ULL, 0x0000009a0505723eULL, 0x000fca00000010ffULL,
0x000000c100c27306ULL, 0x000fe20000209400ULL, 0x0000007b007b7245ULL, 0x002fca000020d400ULL,
0x000000017a7a2812ULL, 0x000fe400078efcffULL, 0x000000c100937306ULL, 0x0002e20000205400ULL,
0x000000b4b300720bULL, 0x004fe40003fbd000ULL, 0x0000007aab7a723eULL, 0x000fca00000010ffULL,
0x0000007c00b87306ULL, 0x000fe20000009400ULL, 0x000000c100c17245ULL, 0x002fca000020d400ULL,
0x000000017b7b5812ULL, 0x000fe400078efcffULL, 0x0000007c00b97306ULL, 0x000e620000005400ULL,
0x00000093c200720bULL, 0x008fce0003fdd000ULL, 0x0000007d00bf7306ULL, 0x000fec0000009400ULL,
0x00000001c1c16812ULL, 0x000fe400078efcffULL, 0x0000007d00c07306ULL, 0x000ea20000005400ULL,
0x000000b9b800720bULL, 0x002fce0003f5d000ULL, 0x0000009e009f7306ULL, 0x000ff00000209400ULL,
0x0000009e00a07306ULL, 0x0002e20000205400ULL, 0x000000c0bf00720bULL, 0x004fce0003fbd000ULL,
0x0000007c00877306ULL, 0x0004e2000000d400ULL, 0x0000009e009e7245ULL, 0x002fce000020d400ULL,
0x0000007d00867306ULL, 0x000262000000d400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000a09f00720bULL, 0x008fcc0003f7d000ULL, 0x0000007f00c57306ULL, 0x000fe20000009400ULL,
0x00000018ff7d7819ULL, 0x002fe2000001147cULL, 0x000001007e7c7824ULL, 0x000fe200078e00ffULL,
0x0000000187872812ULL, 0x000fc800078efcffULL, 0x00000018ff947819ULL, 0x000fe2000001147cULL,
0x0000007f00c67306ULL, 0x000fe20000005400ULL, 0x000000019e9e3812ULL, 0x000fe400078efcffULL,
0x0000000186865812ULL, 0x000fe400078efcffULL, 0x000000afae00720bULL, 0x000fe40003f7d000ULL,
0x000000b5007c7245ULL, 0x000fe2000020d400ULL, 0x0000007f00837306ULL, 0x000ff0000000d400ULL,
0x0000007d00047306ULL, 0x000fe40000209400ULL, 0x000000018d8d3812ULL, 0x000fcc00078efcffULL,
0x0000007d007f7306ULL, 0x000e700000205400ULL, 0x0000007e00c37306ULL, 0x000ff00000009400ULL,
0x0000007e00c47306ULL, 0x000fe20000005400ULL, 0x0000007f0400720bULL, 0x002fc40003fdd000ULL,
0x000000262704723eULL, 0x000fe400000010ffULL, 0x00000092007f7245ULL, 0x000fe4000020d400ULL,
0x000000789526723eULL, 0x000fe200000010ffULL, 0x0000007e00857306ULL, 0x000fe2000000d400ULL,
0x0000008e7978723eULL, 0x000fe200000010ffULL, 0x000000047068723cULL, 0x000f620000041868ULL,
0x0000009ea127723eULL, 0x000fe400000010ffULL, 0x0000008db079723eULL, 0x000fc600000010ffULL,
0x000000b500b67306ULL, 0x000fe40000209400ULL, 0x000000267064723cULL, 0x000f6c0000041864ULL,
0x000000b500b77306ULL, 0x000e640000205400ULL, 0x000000042848723cULL, 0x040b6c0000041848ULL,
0x0000009100bd7306ULL, 0x000fe20000209400ULL, 0x000000010b057824ULL, 0x120fe200078e0202ULL,
0x000000262844723cULL, 0x000b620000041844ULL, 0x000000010a047824ULL, 0x000fca00078e0202ULL,
0x0000009100be7306ULL, 0x0004e20000205400ULL, 0x000000b7b600720bULL, 0x002fe20003f9d000ULL,
0x000000080b267824ULL, 0x020fe200078e00ffULL, 0x000000787060723cULL, 0x000f620000041860ULL,
0x000000080a277824ULL, 0x000fc600078e00ffULL, 0xfffffff826057812ULL, 0x000fe200078ee205ULL,
0x00000092007e7306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x004fe2000020d400ULL,
0x000000010a267824ULL, 0x000fe200078e0203ULL, 0xfffffff827047812ULL, 0x000fe200078ee204ULL,
0x000000782840723cULL, 0x000b620000041840ULL, 0x0000e0001a037811ULL, 0x000fe400078e68ffULL,
0x000000017c7c4812ULL, 0x000fe200078efcffULL, 0x0000009200977306ULL, 0x000e620000205400ULL,
0x000000bebd00720bULL, 0x008fc40003f5d000ULL, 0x000000c4c300720bULL, 0x000fe40003f9d000ULL,
0x0000007b7c7b723eULL, 0x000fc600000010ffULL, 0x0000008c008f7306ULL, 0x000fe80000209400ULL,
0x0000007a705c723cULL, 0x080f64000004185cULL, 0x0000000191912812ULL, 0x000fe400078efcffULL,
0x0000008c00907306ULL, 0x0004e20000205400ULL, 0x000000977e00720bULL, 0x002fe40003fbd000ULL,
0x0000007d007e7245ULL, 0x000fe2000020d400ULL, 0x0000007a283c723cULL, 0x000f62000004183cULL,
0x0000000185854812ULL, 0x000fc400078efcffULL, 0x000000017e7e6812ULL, 0x000fe200078efcffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x004fe4000020d400ULL,
0x00000086c17d723eULL, 0x000fe400000010ffULL, 0x0000007e917e723eULL, 0x000fe400000010ffULL,
0x000000017f7f5812ULL, 0x000fe200078efcffULL, 0x000000ba00bc7306ULL, 0x0002a20000205400ULL,
0x000000908f00720bULL, 0x008fce0003fdd000ULL, 0x0000009400967306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x000000018c8c6812ULL, 0x000fe400078efcffULL,
0x0000009400997306ULL, 0x0002e20000205400ULL, 0x000000bcbb00720bULL, 0x004fe40003f7d000ULL,
0x0000007f8c7f723eULL, 0x000fca00000010ffULL, 0x0000009c009b7306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fe2000020d400ULL, 0x0000007e7054723cULL, 0x080f680000041854ULL,
0x00000001baba3812ULL, 0x000fe400078efcffULL, 0x0000009c00a07306ULL, 0x0002a20000205400ULL,
0x000000999600720bULL, 0x008fe20003f5d000ULL, 0x0000007e2834723cULL, 0x000f620000041834ULL,
0x000000c6c500720bULL, 0x000fc40003f7d000ULL, 0x0000009d00997245ULL, 0x000fe4000020d400ULL,
0x00000087ba7c723eULL, 0x000fe200000010ffULL, 0x0000006d00887306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fca000020d400ULL, 0x0000000194942812ULL, 0x000fe200078efcffULL,
0x0000007c7058723cULL, 0x080f620000041858ULL, 0x0000006d008b7306ULL, 0x0002e20000205400ULL,
0x000000a09b00720bULL, 0x004fe40003fbd000ULL, 0x0000000183833812ULL, 0x000fe400078efcffULL,
0x000000859494723eULL, 0x000fe400000010ffULL, 0x0000007c2838723cULL, 0x000f620000041838ULL,
0x0000006c008a7306ULL, 0x000fe20000209400ULL, 0x0000006d006d7245ULL, 0x002fca000020d400ULL,
0x000000019c9c5812ULL, 0x000fe400078efcffULL, 0x0000006c00897306ULL, 0x0002a20000205400ULL,
0x0000008b8800720bULL, 0x008fe40003fdd000ULL, 0x000000839c95723eULL, 0x000fca00000010ffULL,
0x0000009800937306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fe2000020d400ULL,
0x000000947050723cULL, 0x080f680000041850ULL, 0x000000016d6d6812ULL, 0x000fe400078efcffULL,
0x00000098009a7306ULL, 0x0002e20000205400ULL, 0x000000898a00720bULL, 0x004fe20003f5d000ULL,
0x000000942830723cULL, 0x000f6c0000041830ULL, 0x0000009d008f7306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fca000020d400ULL, 0x000000016c6c2812ULL, 0x000fe400078efcffULL,
0x0000009d008e7306ULL, 0x000e620000205400ULL, 0x0000009a9300720bULL, 0x008fda0003f9d000ULL,
0x0000000198984812ULL, 0x000fe400078efcffULL, 0x0000008e8f00720bULL, 0x002fe40003fbd000ULL,
0x000000986d98723eULL, 0x000fe200000010ffULL, 0x000000080a6d7824ULL, 0x000fca00078e00ffULL,
0xfffffff86d027812ULL, 0x000fe400078ee226ULL, 0x0000000226267810ULL, 0x000fc60007ffe0ffULL,
0x0000000199995812ULL, 0x000fe200078efcffULL, 0x0000001002787824ULL, 0x020fc600078e0203ULL,
0x000000996c99723eULL, 0x000fce00000010ffULL, 0x00000098704c723cULL, 0x080b6e000004184cULL,
0x0000001005707824ULL, 0x120fe200078e0200ULL, 0x00000098282c723cULL, 0x000b62000004182cULL,
0x0000001004007824ULL, 0x000fc800078e0200ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000000028783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000000f70707231ULL, 0x082fe400003400ffULL, 0x0000000f72727231ULL, 0x000fe400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fc400003400ffULL,
0x0000000d28287231ULL, 0x088fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000ea40000004200ULL,
0xfffffff827007812ULL, 0x004fe400078ee226ULL, 0xfffffff825257812ULL, 0x000fc600078ec0ffULL,
0x00000010007c7824ULL, 0x000fcc00078e0203ULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x00000100786d7824ULL, 0x000fe200078e00ffULL, 0x0000007800267306ULL, 0x000fe20000009400ULL,
0x0000010079927824ULL, 0x040fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011478ULL,
0x00010000799c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x000001007aa47824ULL, 0x000fe200078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011492ULL,
0x000001007ba77824ULL, 0x000fe200078e00ffULL, 0x0000006d00907306ULL, 0x000fe20000209400ULL,
0x00000018ff9f7819ULL, 0x000fc40000011479ULL, 0x00000018ff9c7819ULL, 0x000fe2000001149cULL,
0x000001007cb87824ULL, 0x004fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe200000114a4ULL,
0x000001007dbf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe2000001147aULL,
0x0000006d00917306ULL, 0x0004e20000205400ULL, 0x00000018ffae7819ULL, 0x000fe200000114a7ULL,
0x000100007fc97824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe400000114b8ULL,
0x00000018ff8f7819ULL, 0x000fc4000001147cULL, 0x00000018ffb37819ULL, 0x000fe2000001147bULL,
0x0000007800277306ULL, 0x000e620000005400ULL, 0x0000006d006d7245ULL, 0x004fe4000020d400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001147dULL, 0x00000018ff877819ULL, 0x000fe4000001147fULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x00000078006c7306ULL, 0x000462000000d400ULL,
0x000000919000720bULL, 0x008fe20003f5d000ULL, 0x000100007d907824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fc4000001147eULL, 0x00000018ffc97819ULL, 0x000fe400000114c9ULL,
0x00000018ff907819ULL, 0x000fe20000011490ULL, 0x00000099009a7306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x004fe200078e00ffULL, 0x000000272600720bULL, 0x002fe40003fbd000ULL,
0x0000009900277245ULL, 0x000fe4000020d400ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000099009b7306ULL, 0x000e620000205400ULL, 0x000000016d6d2812ULL, 0x000fcc00078efcffULL,
0x000000016c6c5812ULL, 0x000fe200078efcffULL, 0x0000007900967306ULL, 0x000ff00000009400ULL,
0x0000007900977306ULL, 0x000ea20000005400ULL, 0x0000009b9a00720bULL, 0x002fe20003f1d000ULL,
0x000001007f9a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x0000007900987306ULL, 0x000e6c000000d400ULL, 0x0000000127270812ULL, 0x000fe400078efcffULL,
0x0000007800927306ULL, 0x000fe20000209400ULL, 0x000000979600720bULL, 0x004fce0003fdd000ULL,
0x0000007800797306ULL, 0x0004ec0000205400ULL, 0x0000000198986812ULL, 0x002fe400078efcffULL,
0x0000009c009d7306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x004fe4000020d400ULL,
0x000000982727723eULL, 0x000fca00000010ffULL, 0x0000009c009e7306ULL, 0x0002a20000205400ULL,
0x000000799200720bULL, 0x008fe40003f5d000ULL, 0x000000a400797245ULL, 0x000fca000020d400ULL,
0x0000007b00ac7306ULL, 0x000fe20000009400ULL, 0x0000009c009c7245ULL, 0x002fca000020d400ULL,
0x0000000178782812ULL, 0x000fe400078efcffULL, 0x0000007b00ad7306ULL, 0x000e620000005400ULL,
0x0000009e9d00720bULL, 0x004fce0003f1d000ULL, 0x0000009300947306ULL, 0x000fec0000209400ULL,
0x000000019c9c0812ULL, 0x000fe400078efcffULL, 0x0000009300957306ULL, 0x0004e20000205400ULL,
0x000000adac00720bULL, 0x002fce0003fbd000ULL, 0x000000a400a57306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x004fce000020d400ULL, 0x000000a400a67306ULL, 0x000e620000205400ULL,
0x000000959400720bULL, 0x008fce0003f9d000ULL, 0x0000007c00b67306ULL, 0x000fec0000009400ULL,
0x0000000193934812ULL, 0x000fe400078efcffULL, 0x0000007c00b77306ULL, 0x000ea20000005400ULL,
0x000000a6a500720bULL, 0x002fce0003f5d000ULL, 0x0000007b008d7306ULL, 0x0002ec000000d400ULL,
0x0000000179792812ULL, 0x000fe400078efcffULL, 0x0000009f00a07306ULL, 0x000fe20000209400ULL,
0x000100007b7b7824ULL, 0x002fe200078e00ffULL, 0x000000b7b600720bULL, 0x004fc80003f1d000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x0000009f00a17306ULL, 0x0002a20000205400ULL,
0x000000018d8d5812ULL, 0x008fce00078efcffULL, 0x000000a900aa7306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fce000020d400ULL, 0x000000a900ab7306ULL, 0x0002e20000205400ULL,
0x000000a1a000720bULL, 0x004fce0003fdd000ULL, 0x000000ae00af7306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fca000020d400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000ae00b07306ULL, 0x0002a20000205400ULL, 0x000000abaa00720bULL, 0x008fce0003f5d000ULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x00000001a9a92812ULL, 0x000fe400078efcffULL, 0x000000b800ba7306ULL, 0x0002e20000205400ULL,
0x000000b0af00720bULL, 0x004fce0003f9d000ULL, 0x0000007c00897306ULL, 0x0004e2000000d400ULL,
0x000000b800b87245ULL, 0x002fca000020d400ULL, 0x00000001aeae4812ULL, 0x000fe400078efcffULL,
0x0000007a00a27306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000bab900720bULL, 0x008fcc0003fbd000ULL, 0x0000007a00a37306ULL, 0x000e620000005400ULL,
0x0000000189890812ULL, 0x000fcc00078efcffULL, 0x00000001b8b85812ULL, 0x000fe200078efcffULL,
0x0000007a008e7306ULL, 0x0004f0000000d400ULL, 0x0000007d00bd7306ULL, 0x000fe20000009400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x000000a3a200720bULL, 0x002fc80003f7d000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007d00be7306ULL, 0x000fee0000005400ULL,
0x000000018e8e3812ULL, 0x008fe200078efcffULL, 0x0000007d00887306ULL, 0x0003f0000000d400ULL,
0x0000007f00c77306ULL, 0x000fe20000009400ULL, 0x00000018ff7d7819ULL, 0x002fe2000001147cULL,
0x000001007e7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff947819ULL, 0x000fe2000001147cULL,
0x0000007f00c87306ULL, 0x000fe20000005400ULL, 0x000000b3007c7245ULL, 0x000fce000020d400ULL,
0x0000007f00857306ULL, 0x000ff0000000d400ULL, 0x0000007d00267306ULL, 0x000ff00000209400ULL,
0x0000007d007f7306ULL, 0x000e700000205400ULL, 0x0000008f00bb7306ULL, 0x000ff00000209400ULL,
0x0000008f00bc7306ULL, 0x0004e20000205400ULL, 0x0000007f2600720bULL, 0x002fc40003f1d000ULL,
0x0000006c6d26723eULL, 0x000fe400000010ffULL, 0x00000078936c723eULL, 0x000fe400000010ffULL,
0x0000008e7978723eULL, 0x000fe200000010ffULL, 0x0000007a00a77306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x004fe2000020d400ULL, 0x000000267068723cULL, 0x000f620000041868ULL,
0x0000008dae79723eULL, 0x000fe400000010ffULL, 0x00000090007f7245ULL, 0x000fc4000020d400ULL,
0x0000009c9f6d723eULL, 0x000fe200000010ffULL, 0x0000007a00a87306ULL, 0x0002a20000205400ULL,
0x000000bcbb00720bULL, 0x008fe20003fbd000ULL, 0x000000787060723cULL, 0x040f6c0000041860ULL,
0x0000007b00b17306ULL, 0x000fe20000209400ULL, 0x0000007a007a7245ULL, 0x002fe2000020d400ULL,
0x0000006c7064723cULL, 0x000f680000041864ULL, 0x000000018f8f5812ULL, 0x000fc400078efcffULL,
0x0000007b00b27306ULL, 0x0002e20000205400ULL, 0x000000a8a700720bULL, 0x004fe20003fdd000ULL,
0x000000262848723cULL, 0x040f6c0000041848ULL, 0x000000bf00c07306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fe2000020d400ULL, 0x0000006c2844723cULL, 0x000f680000041844ULL,
0x000000017a7a6812ULL, 0x000fc400078efcffULL, 0x000000bf00917306ULL, 0x0002a20000205400ULL,
0x000000b2b100720bULL, 0x008fe20003f9d000ULL, 0x000000782840723cULL, 0x000f620000041840ULL,
0x000000bebd00720bULL, 0x000fe40003fdd000ULL, 0x0000007aa97a723eULL, 0x000fc600000010ffULL,
0x0000009000927306ULL, 0x000fe20000209400ULL, 0x000000bf00bf7245ULL, 0x002fca000020d400ULL,
0x000000017b7b4812ULL, 0x000fe400078efcffULL, 0x0000009000957306ULL, 0x000fe20000205400ULL,
0x00000091c000720bULL, 0x004fe40003f5d000ULL, 0x0000000188886812ULL, 0x000fca00078efcffULL,
0x0000007e00c37306ULL, 0x000fec0000009400ULL, 0x00000001bfbf2812ULL, 0x000fe400078efcffULL,
0x0000007e00c47306ULL, 0x000e700000005400ULL, 0x000000b300b47306ULL, 0x000ff00000209400ULL,
0x000000b300b57306ULL, 0x000ea20000205400ULL, 0x000000c4c300720bULL, 0x002fce0003f9d000ULL,
0x0000008c00c17306ULL, 0x000ff00000209400ULL, 0x0000008c00c27306ULL, 0x0002e20000205400ULL,
0x000000b5b400720bULL, 0x004fce0003f7d000ULL, 0x0000009400967306ULL, 0x000fe20000209400ULL,
0x0000008c008c7245ULL, 0x002fca000020d400ULL, 0x000000017c7c3812ULL, 0x000fe400078efcffULL,
0x0000009400977306ULL, 0x0002a20000205400ULL, 0x000000c2c100720bULL, 0x008fe40003f5d000ULL,
0x000000c8c700720bULL, 0x000fe40003f7d000ULL, 0x0000007b7c7b723eULL, 0x000fe400000010ffULL,
0x00000089b87c723eULL, 0x000fe200000010ffULL, 0x0000007e00837306ULL, 0x0006a2000000d400ULL,
0x0000009400947245ULL, 0x002fc6000020d400ULL, 0x0000007a705c723cULL, 0x080f64000004185cULL,
0x000000018c8c2812ULL, 0x000fe400078efcffULL, 0x0000008600c57306ULL, 0x000fe20000209400ULL,
0x000100007e7e7824ULL, 0x008fe200078e00ffULL, 0x000000979600720bULL, 0x004fe40003fbd000ULL,
0x0000000185853812ULL, 0x000fe200078efcffULL, 0x0000007a283c723cULL, 0x000f62000004183cULL,
0x00000018ff917819ULL, 0x000fc4000001147eULL, 0x0000007d007e7245ULL, 0x000fe2000020d400ULL,
0x0000008600c67306ULL, 0x0002a20000205400ULL, 0x0000000183834812ULL, 0x000fe400078efcffULL,
0x000000017e7e0812ULL, 0x000fe400078efcffULL, 0x000000959200720bULL, 0x000fe40003f1d000ULL,
0x0000000194945812ULL, 0x000fe200078efcffULL, 0x00000087008a7306ULL, 0x000fe20000209400ULL,
0x00000088bf7d723eULL, 0x000fc400000010ffULL, 0x0000008700887245ULL, 0x000fe4000020d400ULL,
0x0000008600867245ULL, 0x002fe4000020d400ULL, 0x0000007e8f7e723eULL, 0x000fe200000010ffULL,
0x00000087008b7306ULL, 0x0002e20000205400ULL, 0x000000c6c500720bULL, 0x004fe20003fdd000ULL,
0x0000007c7058723cULL, 0x000f620000041858ULL, 0x000000017f7f0812ULL, 0x000fe400078efcffULL,
0x000000839494723eULL, 0x000fc400000010ffULL, 0x0000007f8c7f723eULL, 0x000fe200000010ffULL,
0x0000009a009b7306ULL, 0x000fe20000209400ULL, 0x000000c900877245ULL, 0x002fe2000020d400ULL,
0x0000007c2838723cULL, 0x000f680000041838ULL, 0x0000000186866812ULL, 0x000fe400078efcffULL,
0x0000009a009e7306ULL, 0x0002a20000205400ULL, 0x0000008b8a00720bULL, 0x008fe20003f5d000ULL,
0x0000007e7054723cULL, 0x080f6c0000041854ULL, 0x0000009100997306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fe2000020d400ULL, 0x0000007e2834723cULL, 0x000f680000041834ULL,
0x0000000188882812ULL, 0x000fc400078efcffULL, 0x0000009100987306ULL, 0x0002e20000205400ULL,
0x0000009e9b00720bULL, 0x004fce0003f1d000ULL, 0x000000c900927306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x002fca000020d400ULL, 0x000000019a9a0812ULL, 0x000fe400078efcffULL,
0x000000c9008d7306ULL, 0x000e620000205400ULL, 0x000000989900720bULL, 0x008fe40003fbd000ULL,
0x000000859a95723eULL, 0x000fce00000010ffULL, 0x000000947050723cULL, 0x080f680000041850ULL,
0x0000000191915812ULL, 0x000fe400078efcffULL, 0x0000008d9200720bULL, 0x002fe40003f9d000ULL,
0x000000918686723eULL, 0x000fe200000010ffULL, 0x000000942830723cULL, 0x000f740000041830ULL,
0x0000000187874812ULL, 0x000fc800078efcffULL, 0x000000878887723eULL, 0x000fce00000010ffULL,
0x00000086704c723cULL, 0x080f70000004184cULL, 0x00000086282c723cULL, 0x000b6e000004182cULL,
0x000126c81a2a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000002a2a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126880025ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff6c7224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x000fc80000015200ULL, 0x0000040013257984ULL, 0x004ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040013257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001020267824ULL, 0x000fca00078e00ffULL, 0xffffffe026257812ULL, 0x000fca00078ec0ffULL,
0x0000010016257824ULL, 0x000fca00078e0225ULL, 0x0000008025277810ULL, 0x000fe20007ffe0ffULL,
0x0000590024257a24ULL, 0x010fc600078e02ffULL, 0x0000002027247812ULL, 0x000fe200078ec0ffULL,
0x0000004025717824ULL, 0x000fc800078e00ffULL, 0x00000001192a7824ULL, 0x000fe200078e0224ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x000000271e247217ULL, 0x000fe40007800000ULL,
0x0000001026297812ULL, 0x000fe400078ec0ffULL, 0x00000003ff257819ULL, 0x000fe2000001161fULL,
0x0000000124247824ULL, 0x000fe200078e0a27ULL, 0x00006200716d7a11ULL, 0x000fe400078a38ffULL,
0x0000000425287810ULL, 0x040fe20007ffe0ffULL, 0x0000000125267824ULL, 0x000fe200078e0229ULL,
0x0000002429247217ULL, 0x000fc40007800000ULL, 0x0000000c252b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000126277824ULL, 0x040fe200078e021fULL, 0x0000630071717a11ULL, 0x000fe200028f3cffULL,
0x00000008266c7824ULL, 0x000fe400078e00ffULL, 0x0000000124247824ULL, 0x100fe400078e0a29ULL,
0x000000012b737824ULL, 0x000fe200078e0229ULL, 0xfffffff86c6c7812ULL, 0x000fe400078ee227ULL,
0x0000000825277810ULL, 0x000fe20007ffe0ffULL, 0x0000000173787824ULL, 0x000fe200078e021fULL,
0x000000242500720cULL, 0x080fe20003f86070ULL, 0x0000000126257824ULL, 0x000fe200078e022aULL,
0x000000242800720cULL, 0x0c0fe20003f66070ULL, 0x0000000128267824ULL, 0x100fe200078e0229ULL,
0x000000242700720cULL, 0x0c0fe20003f46070ULL, 0x0000000127287824ULL, 0x000fe200078e0229ULL,
0x000000242b00720cULL, 0x000fe20003f06070ULL, 0x0000000126277824ULL, 0x000fc400078e021fULL,
0x0000000826707824ULL, 0x000fe400078e00ffULL, 0x0000008025247825ULL, 0x000fc600078e00ffULL,
0xfffffff870707812ULL, 0x000fe200078ee227ULL, 0x0000000126267824ULL, 0x000fe200078e022aULL,
0x0000001224247212ULL, 0x000fe200078efcffULL, 0x0000000128297824ULL, 0x040fe400078e021fULL,
0x0000000828727824ULL, 0x000fe200078e00ffULL, 0x000000246d247210ULL, 0x000fe20007fbe0ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee229ULL,
0x0000000128287824ULL, 0x100fe200078e022aULL, 0x0000001226267212ULL, 0x000fe200078efcffULL,
0x00000001732a7824ULL, 0x000fe400078e022aULL, 0x0000008028287825ULL, 0x000fc800078e00ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001228287212ULL, 0x000fc600078efcffULL,
0x0000000125257824ULL, 0x000fe200028e0671ULL, 0x0000006d26267210ULL, 0x000fe20007fbe0ffULL,
0x0000000873737824ULL, 0x000fe200078e00ffULL, 0x000000122a2a7212ULL, 0x000fc600078efcffULL,
0x0000000127277824ULL, 0x000fe200028e0671ULL, 0x0000006d28287210ULL, 0x080fe40007fbe0ffULL,
0x0000006d2a2a7210ULL, 0x000fe20007fde0ffULL, 0x000000106c6d7824ULL, 0x000fe200078e0203ULL,
0xfffffff873787812ULL, 0x000fe200078ee278ULL, 0x0000000129297824ULL, 0x100fe400028e0671ULL,
0x000000012b2b7824ULL, 0x000fe200030e0671ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000246d7faeULL, 0x0003e2000e101c48ULL, 0x0000001070717824ULL, 0x000fc400078e0203ULL,
0x0000001072737824ULL, 0x100fe400078e0203ULL, 0x0000001078797824ULL, 0x000fe200078e0203ULL,
0x0000000026717faeULL, 0x0003e8000d901c48ULL, 0x0000000028737faeULL, 0x0003e8000d101c48ULL,
0x000000002a797faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001026267812ULL, 0x000fe400078ec0ffULL, 0x00006200716d7a11ULL, 0x000fc400078038ffULL,
0x000000261f267211ULL, 0x000fe400078fe8ffULL, 0x0000630071717a11ULL, 0x000fe400000f3cffULL,
0x0000000426277810ULL, 0x040fe20007ffe0ffULL, 0x0000000126257824ULL, 0x040fe200078e021fULL,
0x0000000826297810ULL, 0x040fe20007ffe0ffULL, 0x00000008266c7824ULL, 0x040fe200078e00ffULL,
0x0000000c262b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000827707824ULL, 0x040fe400078e00ffULL,
0x0000000126247824ULL, 0x000fe200078e022aULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee225ULL,
0x0000000127257824ULL, 0x000fc400078e021fULL, 0x0000000127267824ULL, 0x100fe400078e022aULL,
0x0000000129287824ULL, 0x040fe200078e022aULL, 0xfffffff870707812ULL, 0x000fe200078ee225ULL,
0x0000000129277824ULL, 0x140fe400078e021fULL, 0x0000000829727824ULL, 0x000fe400078e00ffULL,
0x000000012b297824ULL, 0x040fe400078e021fULL, 0x000000082b787824ULL, 0x000fe200078e00ffULL,
0xfffffff872727812ULL, 0x000fe200078ee227ULL, 0x0000008024247825ULL, 0x000fc600078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee229ULL, 0x000000012b2a7824ULL, 0x000fe200078e022aULL,
0x0000001224247212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0x000000246d247210ULL, 0x000fe20007f1e0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000001226267212ULL, 0x000fc600078efcffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001228287212ULL, 0x000fe400078efcffULL, 0x000000266d267210ULL, 0x000fe20007f5e0ffULL,
0x0000000125257824ULL, 0x000fe200000e0671ULL, 0x000000122a2a7212ULL, 0x000fe200078efcffULL,
0x0000001072737824ULL, 0x000fe200078e0203ULL, 0x000000286d287210ULL, 0x000fe20007f1e0ffULL,
0x0000000127277824ULL, 0x000fe200010e0671ULL, 0x0000002a6d2a7210ULL, 0x000fe20007f7e0ffULL,
0x000000106c6d7824ULL, 0x000fc400078e0203ULL, 0x0000000129297824ULL, 0x100fe400000e0671ULL,
0x000000012b2b7824ULL, 0x000fe200018e0671ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000246d7faeULL, 0x0003e2000b901c48ULL, 0x0000001070717824ULL, 0x100fe400078e0203ULL,
0x0000001078797824ULL, 0x000fc600078e0203ULL, 0x0000000026717faeULL, 0x0003e8000b901c48ULL,
0x0000000028737faeULL, 0x0003e8000b901c48ULL, 0x000000002a797faeULL, 0x0003e4000b901c48ULL,
0x0000000820257824ULL, 0x002fe200078e00ffULL, 0x0000000218267810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff247424ULL, 0x000fc600078e00ffULL, 0xfffffff025257812ULL, 0x000fe400078ec0ffULL,
0x0000001d2600720cULL, 0x000fe40003f06070ULL, 0x00000000250473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000117268824ULL, 0x000fc400078e0226ULL,
0x00000004ff278424ULL, 0x000fc800078e00ffULL, 0x0000640026268625ULL, 0x000fca00078e0027ULL,
0x0000000826248981ULL, 0x000522000c1e1900ULL, 0x000126a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x0126a800252a7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01262800236c7f8cULL, 0x000664000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x01262c0023257984ULL, 0x002e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01262c0023257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002020257824ULL, 0x000fca00078e00ffULL,
0xffffff8025257812ULL, 0x000fc800078ec0ffULL, 0x0000008012267810ULL, 0x000fca0007ffe025ULL,
0x0000000111267824ULL, 0x000fca00078e0226ULL, 0x0120000026707984ULL, 0x000e680000000800ULL,
0x0122000026257984ULL, 0x0006a20000000800ULL, 0x000000217000720bULL, 0x002fe20003f1d000ULL,
0x00014dd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000267806ULL, 0x008fc800000e0100ULL,
0x000000ff2600720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6c7424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x000000011b277810ULL, 0x000fe40007ffe0ffULL, 0x000000217000720bULL, 0x000fe40003f54000ULL,
0x000000202700720cULL, 0x000fe20003f05270ULL, 0x00014d927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000717806ULL, 0x000fc400010e0100ULL, 0x0000008020288824ULL, 0x000fe200078e0212ULL,
0x0000002170278209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000111288824ULL, 0x000fca00078e0228ULL, 0x0124002728008388ULL, 0x0003e20000000800ULL,
0x000000ff7100720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002170287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff71ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002128277221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b27277820ULL, 0x000fc80000410000ULL, 0x0000002700737308ULL, 0x000e640000000800ULL,
0x0000007322227220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x00014cc27f007947ULL, 0x000fea000b800000ULL,
0x00001f2973287589ULL, 0x0002e400000e0000ULL, 0x0000002868687220ULL, 0x08cfe20000410000ULL,
0x0000002869697220ULL, 0x080fe20000410000ULL, 0x0000002864647220ULL, 0x080fe20000410000ULL,
0x0000002865657220ULL, 0x080fe20000410000ULL, 0x0000002860607220ULL, 0x080fe20000410000ULL,
0x0000002861617220ULL, 0x080fe20000410000ULL, 0x000000285c5c7220ULL, 0x080fe20000410000ULL,
0x000000285d5d7220ULL, 0x080fe20000410000ULL, 0x0000002858587220ULL, 0x080fe20000410000ULL,
0x0000002859597220ULL, 0x080fe20000410000ULL, 0x0000002854547220ULL, 0x080fe20000410000ULL,
0x0000002855557220ULL, 0x080fe20000410000ULL, 0x0000002850507220ULL, 0x080fe20000410000ULL,
0x0000002851517220ULL, 0x080fe20000410000ULL, 0x000000284c4c7220ULL, 0x080fe20000410000ULL,
0x000000284d4d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x002fe200078ff0ffULL,
0x00014b927f007947ULL, 0x000fea000b800000ULL, 0x00001f2973287589ULL, 0x0002e400000e0000ULL,
0x000000286a6a7220ULL, 0x08cfe20000410000ULL, 0x000000286b6b7220ULL, 0x080fe20000410000ULL,
0x0000002866667220ULL, 0x080fe20000410000ULL, 0x0000002867677220ULL, 0x080fe20000410000ULL,
0x0000002862627220ULL, 0x080fe20000410000ULL, 0x0000002863637220ULL, 0x080fe20000410000ULL,
0x000000285e5e7220ULL, 0x080fe20000410000ULL, 0x000000285f5f7220ULL, 0x080fe20000410000ULL,
0x000000285a5a7220ULL, 0x080fe20000410000ULL, 0x000000285b5b7220ULL, 0x080fe20000410000ULL,
0x0000002856567220ULL, 0x080fe20000410000ULL, 0x0000002857577220ULL, 0x080fe20000410000ULL,
0x0000002852527220ULL, 0x080fe20000410000ULL, 0x0000002853537220ULL, 0x080fe20000410000ULL,
0x000000284e4e7220ULL, 0x080fe20000410000ULL, 0x000000284f4f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x002fe200078ff0ffULL, 0x00014a627f007947ULL, 0x000fea000b800000ULL,
0x00001f2973287589ULL, 0x0002e400000e0000ULL, 0x0000002848487220ULL, 0x08cfe20000410000ULL,
0x0000002849497220ULL, 0x080fe20000410000ULL, 0x0000002844447220ULL, 0x080fe20000410000ULL,
0x0000002845457220ULL, 0x080fe20000410000ULL, 0x0000002840407220ULL, 0x080fe20000410000ULL,
0x0000002841417220ULL, 0x080fe20000410000ULL, 0x000000283c3c7220ULL, 0x080fe20000410000ULL,
0x000000283d3d7220ULL, 0x080fe20000410000ULL, 0x0000002838387220ULL, 0x080fe20000410000ULL,
0x0000002839397220ULL, 0x080fe20000410000ULL, 0x0000002834347220ULL, 0x080fe20000410000ULL,
0x0000002835357220ULL, 0x080fe20000410000ULL, 0x0000002830307220ULL, 0x080fe20000410000ULL,
0x0000002831317220ULL, 0x080fe20000410000ULL, 0x000000282c2c7220ULL, 0x080fe20000410000ULL,
0x000000282d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000071ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x002fe200078ff0ffULL, 0x000149427f007947ULL, 0x000fea000b800000ULL,
0x00001f2973287589ULL, 0x0002e400000e0000ULL, 0x000000284a4a7220ULL, 0x08cfe20000410000ULL,
0x000000284b4b7220ULL, 0x080fe20000410000ULL, 0x0000002846467220ULL, 0x080fe20000410000ULL,
0x0000002847477220ULL, 0x080fe20000410000ULL, 0x0000002842427220ULL, 0x080fe20000410000ULL,
0x0000002843437220ULL, 0x080fe20000410000ULL, 0x000000283e3e7220ULL, 0x080fe20000410000ULL,
0x000000283f3f7220ULL, 0x080fe20000410000ULL, 0x000000283a3a7220ULL, 0x080fe20000410000ULL,
0x000000283b3b7220ULL, 0x080fe20000410000ULL, 0x0000002836367220ULL, 0x080fe20000410000ULL,
0x0000002837377220ULL, 0x080fe20000410000ULL, 0x0000002832327220ULL, 0x080fe20000410000ULL,
0x0000002833337220ULL, 0x080fe20000410000ULL, 0x000000282e2e7220ULL, 0x080fe20000410000ULL,
0x000000282f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007126ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6c7424ULL, 0x000fe200078e00ffULL,
0x0000002170217209ULL, 0x000fd60007810000ULL, 0x8000002170700221ULL, 0x000fe20000010000ULL,
0x00007610ff6c0816ULL, 0x000fc6000000006cULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000100308ULL, 0x000e640000000800ULL, 0x0000001025250220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002225227221ULL, 0x004fc20000010000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000000820257824ULL, 0x000fca00078e00ffULL,
0xfffffff0256d7812ULL, 0x000fca00078ec0ffULL, 0x0126b4006d257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b4006d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106c257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000010ff0c723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x000145027f007947ULL, 0x000fea000b800000ULL,
0x00001f250c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000825297810ULL, 0x002fe20007ffe0ffULL,
0x000145327f007947ULL, 0x000fea000b800000ULL, 0x00000010250d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001825297810ULL, 0x002fe20007ffe0ffULL, 0x000145827f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x0000040020257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100020267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026277812ULL, 0x000fe400078ec0ffULL, 0x0000b00025267810ULL, 0x000fe40007ffe0ffULL,
0x0000f00027257810ULL, 0x000fc60007ffe0ffULL, 0x0000001009707824ULL, 0x100fe400078e0226ULL,
0x00000010086c7824ULL, 0x000fe400078e0226ULL, 0x0000001007787824ULL, 0x000fe400078e0225ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000006c6c783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707231ULL, 0x086fe400003400ffULL,
0x0000000f72727231ULL, 0x000fc400003400ffULL, 0x0000000e71717231ULL, 0x088fe400003400ffULL,
0x0000000e73737231ULL, 0x000fe400003400ffULL, 0x0000000d6c6c7231ULL, 0x080fe400003400ffULL,
0x0000000d6e6e7231ULL, 0x000fe400003400ffULL, 0x0000000c6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000c6f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000010067c7824ULL, 0x000fe200078e0225ULL,
0x00000f9000007945ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x0000010078937824ULL, 0x008fe200078e00ffULL, 0x0000007800287306ULL, 0x000fe20000009400ULL,
0x00000018ff977819ULL, 0x000fe20000011478ULL, 0x0000010079967824ULL, 0x040fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011479ULL, 0x0001000079a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011493ULL, 0x000001007aa87824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011496ULL, 0x0000007800297306ULL, 0x002e620000005400ULL,
0x000001007bab7824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe2000001147aULL,
0x000001007fcb7824ULL, 0x044fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x000100007fcc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fc400000114abULL,
0x0000009300947306ULL, 0x000fe20000209400ULL, 0x00000018ffb97819ULL, 0x000fe4000001147bULL,
0x00000018ffa07819ULL, 0x000fe400000114a0ULL, 0x00000018ff837819ULL, 0x000fe4000001147eULL,
0x00000018ff917819ULL, 0x000fe2000001147cULL, 0x0000009300957306ULL, 0x0004e20000205400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001147dULL, 0x000000292800720bULL, 0x002fc40003f9d000ULL,
0x0000009d00297245ULL, 0x000fe4000020d400ULL, 0x00000018ff857819ULL, 0x000fe2000001147fULL,
0x0000007800927306ULL, 0x0002e2000000d400ULL, 0x0000009300937245ULL, 0x004fe4000020d400ULL,
0x00000018ffcb7819ULL, 0x000fe400000114cbULL, 0x00000018ffcc7819ULL, 0x000fc600000114ccULL,
0x00000079009a7306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x000000959400720bULL, 0x008fc80003fdd000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000079009b7306ULL, 0x000e620000005400ULL, 0x0000000192924812ULL, 0x000fcc00078efcffULL,
0x0000000193936812ULL, 0x000fe200078efcffULL, 0x00000079009c7306ULL, 0x000eb0000000d400ULL,
0x0000007800967306ULL, 0x000fe20000209400ULL, 0x0000009b9a00720bULL, 0x002fce0003f5d000ULL,
0x0000007800797306ULL, 0x0002ec0000205400ULL, 0x000000019c9c2812ULL, 0x004fe400078efcffULL,
0x0000009700987306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x002fce000020d400ULL,
0x0000009700997306ULL, 0x0002a20000205400ULL, 0x000000799600720bULL, 0x008fe40003fdd000ULL,
0x000000a000797245ULL, 0x000fca000020d400ULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fca000020d400ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x000000a800aa7306ULL, 0x000e620000205400ULL, 0x000000999800720bULL, 0x004fce0003fbd000ULL,
0x0000007a00a67306ULL, 0x000fec0000009400ULL, 0x0000000197975812ULL, 0x000fe400078efcffULL,
0x0000007a00a77306ULL, 0x000ea20000005400ULL, 0x000000aaa900720bULL, 0x002fe40003fdd000ULL,
0x000000789778723eULL, 0x000fca00000010ffULL, 0x0000007a008e7306ULL, 0x0002f0000000d400ULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x000000a7a600720bULL, 0x004fc80003f9d000ULL, 0x00000018ffab7819ULL, 0x000fe2000001147aULL,
0x000001007c7a7824ULL, 0x000fe200078e00ffULL, 0x000000a300a57306ULL, 0x000e680000205400ULL,
0x00000018ffbe7819ULL, 0x000fe2000001147aULL, 0x000001007d7a7824ULL, 0x000fe400078e00ffULL,
0x000000018e8e4812ULL, 0x008fe200078efcffULL, 0x000000b300b47306ULL, 0x000fe40000209400ULL,
0x00000018ffc57819ULL, 0x000fc4000001147aULL, 0x000000a3007a7245ULL, 0x000fc8000020d400ULL,
0x000000b300b57306ULL, 0x000ea20000205400ULL, 0x000000a5a400720bULL, 0x002fce0003f5d000ULL,
0x0000007b00b17306ULL, 0x000fec0000009400ULL, 0x000000017a7a2812ULL, 0x000fe400078efcffULL,
0x0000007b00b27306ULL, 0x000fe20000005400ULL, 0x000000b5b400720bULL, 0x004fce0003fbd000ULL,
0x0000007b008d7306ULL, 0x0003f0000000d400ULL, 0x0000009d009e7306ULL, 0x000fe20000209400ULL,
0x000100007b7b7824ULL, 0x002fca00078e00ffULL, 0x00000018ffb67819ULL, 0x000fe2000001147bULL,
0x000001007e7b7824ULL, 0x000fe200078e00ffULL, 0x0000009d009f7306ULL, 0x000e680000205400ULL,
0x00000018ff9a7819ULL, 0x000fe4000001147bULL, 0x000000a8007b7245ULL, 0x000fe4000020d400ULL,
0x000000ae00af7306ULL, 0x000fe40000209400ULL, 0x000000017b7b6812ULL, 0x000fcc00078efcffULL,
0x000000ae00b07306ULL, 0x000ea20000205400ULL, 0x0000009f9e00720bULL, 0x002fe20003f7d000ULL,
0x000100007e9f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe2000001149fULL,
0x000000ab00ac7306ULL, 0x000fec0000209400ULL, 0x0000000129293812ULL, 0x000fe400078efcffULL,
0x000000ab00ad7306ULL, 0x000e620000205400ULL, 0x000000b0af00720bULL, 0x004fc40003fdd000ULL,
0x0000009c2929723eULL, 0x000fca00000010ffULL, 0x000000b600b77306ULL, 0x000ff00000209400ULL,
0x000000b600b87306ULL, 0x0005e20000205400ULL, 0x000000adac00720bULL, 0x002fce0003f5d000ULL,
0x000000a000a17306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x004fce000020d400ULL,
0x000000a000a27306ULL, 0x000e700000205400ULL, 0x000000c500c67306ULL, 0x000ff00000209400ULL,
0x000000c500957306ULL, 0x0005e20000205400ULL, 0x000000a2a100720bULL, 0x002fce0003f7d000ULL,
0x0000007e00c77306ULL, 0x000fe20000009400ULL, 0x000000c500c57245ULL, 0x004fca000020d400ULL,
0x0000000179793812ULL, 0x000fe400078efcffULL, 0x0000007e00c87306ULL, 0x000fe20000005400ULL,
0x000000b2b100720bULL, 0x000fe40003f7d000ULL, 0x000000797a79723eULL, 0x000fe400000010ffULL,
0x0000008e7b7a723eULL, 0x000fc600000010ffULL, 0x0000007e00257306ULL, 0x0003e4000000d400ULL,
0x000000787064723cULL, 0x080f680000041864ULL, 0x000000018d8d3812ULL, 0x000fe400078efcffULL,
0x0000007c00bc7306ULL, 0x000fe20000009400ULL, 0x000000b3007e7245ULL, 0x002fe2000020d400ULL,
0x000000786c44723cULL, 0x000f660000041844ULL, 0x000000017e7e5812ULL, 0x000fc400078efcffULL,
0x000000b8b700720bULL, 0x000fe20003fbd000ULL, 0x0000007c00bd7306ULL, 0x000e620000005400ULL,
0x0000008d7e7b723eULL, 0x000fce00000010ffULL, 0x0000007c00877306ULL, 0x0005e2000000d400ULL,
0x0000007a7060723cULL, 0x000f660000041860ULL, 0x00000001b6b65812ULL, 0x000fc800078efcffULL,
0x0000007d00c37306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x0000007a6c40723cULL, 0x000f680000041840ULL, 0x00000018ff947819ULL, 0x000fe4000001147cULL,
0x0000007d00c47306ULL, 0x000ea20000005400ULL, 0x000000ab007c7245ULL, 0x000fc8000020d400ULL,
0x000000017c7c2812ULL, 0x000fe400078efcffULL, 0x000000bdbc00720bULL, 0x002fe20003f5d000ULL,
0x0000007d00867306ULL, 0x0002f0000000d400ULL, 0x0000007f00c97306ULL, 0x000fe20000009400ULL,
0x000100007d7d7824ULL, 0x002fe200078e00ffULL, 0x000000c4c300720bULL, 0x004fc40003fbd000ULL,
0x0000000187872812ULL, 0x000fe400078efcffULL, 0x00000018ff967819ULL, 0x000fe4000001147dULL,
0x000000ae007d7245ULL, 0x000fe2000020d400ULL, 0x0000007f00ca7306ULL, 0x000fe60000005400ULL,
0x000000017d7d6812ULL, 0x000fe400078efcffULL, 0x00000095c600720bULL, 0x000fc40003fdd000ULL,
0x0000000186865812ULL, 0x008fe200078efcffULL, 0x0000007f00277306ULL, 0x000fe2000000d400ULL,
0x0000009600957245ULL, 0x000fe4000020d400ULL, 0x0000007c7d7c723eULL, 0x000fca00000010ffULL,
0x0000009400287306ULL, 0x000fe40000209400ULL, 0x00000001c5c56812ULL, 0x000fcc00078efcffULL,
0x00000094007f7306ULL, 0x0002b00000205400ULL, 0x000000b900ba7306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fce000020d400ULL, 0x000000b900bb7306ULL, 0x0002e20000205400ULL,
0x0000007f2800720bULL, 0x004fe40003fdd000ULL, 0x000000929328723eULL, 0x000fe400000010ffULL,
0x00000086c57f723eULL, 0x000fe400000010ffULL, 0x0000008300867245ULL, 0x000fe2000020d400ULL,
0x0000009100c17306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fe2000020d400ULL,
0x000000287068723cULL, 0x000f680000041868ULL, 0x0000000194946812ULL, 0x000fc400078efcffULL,
0x0000009100c27306ULL, 0x0002a20000205400ULL, 0x000000bbba00720bULL, 0x008fe20003f9d000ULL,
0x000000286c48723cULL, 0x000f6c0000041848ULL, 0x0000009600987306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x002fca000020d400ULL, 0x00000001b9b94812ULL, 0x000fe400078efcffULL,
0x0000009600997306ULL, 0x000e620000205400ULL, 0x000000c2c100720bULL, 0x004fe40003f5d000ULL,
0x000000c8c700720bULL, 0x000fe40003f9d000ULL, 0x000000b6b97d723eULL, 0x000fc600000010ffULL,
0x000000be00bf7306ULL, 0x000fe80000209400ULL, 0x0000007c705c723cULL, 0x080f64000004185cULL,
0x0000000191912812ULL, 0x000fe400078efcffULL, 0x000000be00c07306ULL, 0x0004e20000205400ULL,
0x000000999800720bULL, 0x002fe40003fbd000ULL, 0x0000000125254812ULL, 0x000fe200078efcffULL,
0x0000007c6c3c723cULL, 0x000f62000004183cULL, 0x000000949194723eULL, 0x000fc600000010ffULL,
0x0000008c00907306ULL, 0x000fe20000209400ULL, 0x000000be00be7245ULL, 0x004fca000020d400ULL,
0x0000000195955812ULL, 0x000fe400078efcffULL, 0x0000008c008f7306ULL, 0x0002a20000205400ULL,
0x000000c0bf00720bULL, 0x008fce0003f7d000ULL, 0x0000009a009b7306ULL, 0x000fe20000209400ULL,
0x0000008c008c7245ULL, 0x002fca000020d400ULL, 0x00000001bebe3812ULL, 0x000fe400078efcffULL,
0x0000009a009e7306ULL, 0x0002e20000205400ULL, 0x0000008f9000720bULL, 0x004fe40003fdd000ULL,
0x000000cac900720bULL, 0x000fe40003f7d000ULL, 0x00000087be7e723eULL, 0x000fe400000010ffULL,
0x000000cc00877245ULL, 0x000fe2000020d400ULL, 0x000000cb00a07306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fc6000020d400ULL, 0x0000007e7058723cULL, 0x080f640000041858ULL,
0x000000018c8c6812ULL, 0x000fe400078efcffULL, 0x000000cb00a17306ULL, 0x000e620000205400ULL,
0x0000009e9b00720bULL, 0x008fe40003f5d000ULL, 0x0000000127273812ULL, 0x000fe200078efcffULL,
0x0000007e6c38723cULL, 0x000f620000041838ULL, 0x000000958c95723eULL, 0x000fc600000010ffULL,
0x0000008300887306ULL, 0x000fe80000209400ULL, 0x000000947054723cULL, 0x080f640000041854ULL,
0x000000019a9a2812ULL, 0x000fe400078efcffULL, 0x00000083008b7306ULL, 0x000ea20000205400ULL,
0x000000a1a000720bULL, 0x002fe40003fbd000ULL, 0x000000259a9a723eULL, 0x000fe200000010ffULL,
0x000000946c34723cULL, 0x000f620000041834ULL, 0x0000100003257810ULL, 0x000fc60007ffe0ffULL,
0x00000085008a7306ULL, 0x000ff00000209400ULL, 0x0000008500897306ULL, 0x000e620000205400ULL,
0x0000008b8800720bULL, 0x004fe40003fdd000ULL, 0x000000cb00887245ULL, 0x000fc8000020d400ULL,
0x0000000188885812ULL, 0x000fe200078efcffULL, 0x0000009f009d7306ULL, 0x000fe60000209400ULL,
0x00000027889b723eULL, 0x000fe200000010ffULL, 0x0000001004277824ULL, 0x000fe200078e0226ULL,
0x0000008500887245ULL, 0x000fe4000020d400ULL, 0x0000000186866812ULL, 0x000fe200078efcffULL,
0x0000009f00927306ULL, 0x0004e20000205400ULL, 0x000000898a00720bULL, 0x002fe20003f5d000ULL,
0x0000009a7050723cULL, 0x080f6c0000041850ULL, 0x000000cc008f7306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x004fe2000020d400ULL, 0x0000009a6c30723cULL, 0x000f680000041830ULL,
0x0000000188882812ULL, 0x000fc400078efcffULL, 0x000000cc008e7306ULL, 0x000e620000205400ULL,
0x000000929d00720bULL, 0x008fda0003f9d000ULL, 0x000000019f9f4812ULL, 0x000fe400078efcffULL,
0x0000008e8f00720bULL, 0x002fe40003fbd000ULL, 0x0000009f8686723eULL, 0x000fd600000010ffULL,
0x0000000187875812ULL, 0x000fc800078efcffULL, 0x000000878887723eULL, 0x000fce00000010ffULL,
0x00000086704c723cULL, 0x080b6e000004184cULL, 0x0000001005707824ULL, 0x020fe200078e0226ULL,
0x000000866c2c723cULL, 0x000b62000004182cULL, 0x0000001002267824ULL, 0x000fe200078e0225ULL,
0x00000000276c783bULL, 0x0202a80000000200ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fd80003800000ULL, 0x0000000f70707231ULL, 0x088fe400003400ffULL,
0x0000000f72727231ULL, 0x000fc400003400ffULL, 0x0000000e71717231ULL, 0x080fe400003400ffULL,
0x0000000e73737231ULL, 0x000fe400003400ffULL, 0x0000000d6c6c7231ULL, 0x084fe400003400ffULL,
0x0000000d6e6e7231ULL, 0x000fe400003400ffULL, 0x0000000c6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000c6f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000002678783bULL, 0x000e620000004200ULL, 0x00000010007c7824ULL, 0x000fcc00078e0225ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x0000010078907824ULL, 0x002fe200078e00ffULL,
0x0000007800287306ULL, 0x000fe20000009400ULL, 0x0000010079937824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe20000011478ULL, 0x000001007aa57824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011490ULL, 0x000001007ba87824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe40000011493ULL, 0x0000009000917306ULL, 0x000fe20000209400ULL,
0x00000018ffa07819ULL, 0x000fc40000011479ULL, 0x00000018ffa57819ULL, 0x000fe400000114a5ULL,
0x00000018ffab7819ULL, 0x000fe4000001147aULL, 0x00000018ffb07819ULL, 0x000fe200000114a8ULL,
0x0000009000927306ULL, 0x000e620000205400ULL, 0x00000018ff8e7819ULL, 0x008fe4000001147cULL,
0x00000018ffb67819ULL, 0x000fe4000001147bULL, 0x00000018ff867819ULL, 0x000fc4000001147eULL,
0x00000018ff857819ULL, 0x000fe2000001147fULL, 0x0000007800297306ULL, 0x000ee20000005400ULL,
0x00000018ff8b7819ULL, 0x000fce000001147dULL, 0x00000078008f7306ULL, 0x0004e2000000d400ULL,
0x000000929100720bULL, 0x002fce0003f5d000ULL, 0x0000009b009c7306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x004fe200078e00ffULL, 0x000000292800720bULL, 0x008fe40003fbd000ULL,
0x0000009000287245ULL, 0x000fe4000020d400ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000009b009d7306ULL, 0x000e620000205400ULL, 0x0000000128282812ULL, 0x000fe400078efcffULL,
0x0000009b00297245ULL, 0x000fc8000020d400ULL, 0x000000018f8f5812ULL, 0x000fe200078efcffULL,
0x0000007800937306ULL, 0x000fe60000209400ULL, 0x0000008f2828723eULL, 0x000fca00000010ffULL,
0x0000007800947306ULL, 0x0004e20000205400ULL, 0x0000009d9c00720bULL, 0x002fe20003f1d000ULL,
0x000001007f9c7824ULL, 0x040fe400078e00ffULL, 0x000100007f9d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe2000001149cULL, 0x0000007900987306ULL, 0x000fe20000009400ULL,
0x0000007800787245ULL, 0x004fe4000020d400ULL, 0x00000018ff9d7819ULL, 0x000fc6000001149dULL,
0x0000000129290812ULL, 0x000fe400078efcffULL, 0x0000007900997306ULL, 0x000e620000005400ULL,
0x000000949300720bULL, 0x008fce0003f5d000ULL, 0x00000079009a7306ULL, 0x0004ec000000d400ULL,
0x0000000178782812ULL, 0x000fe400078efcffULL, 0x0000007a00a37306ULL, 0x000fe20000009400ULL,
0x0001000079797824ULL, 0x004fe200078e00ffULL, 0x000000999800720bULL, 0x002fe20003fdd000ULL,
0x000100007e997824ULL, 0x000fc600078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000007a00a47306ULL, 0x000e620000005400ULL, 0x00000018ff997819ULL, 0x000fcc0000011499ULL,
0x000000019a9a6812ULL, 0x008fe200078efcffULL, 0x00000079009e7306ULL, 0x000fe60000209400ULL,
0x0000009a2929723eULL, 0x000fca00000010ffULL, 0x00000079009f7306ULL, 0x0004e20000205400ULL,
0x000000a4a300720bULL, 0x002fe20003f7d000ULL, 0x000000287068723cULL, 0x080f6c0000041868ULL,
0x0000007a008d7306ULL, 0x0002e2000000d400ULL, 0x0000007900797245ULL, 0x004fe2000020d400ULL,
0x000000286c48723cULL, 0x000b6c0000041848ULL, 0x0000007b00ae7306ULL, 0x000fe20000009400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x0000009f9e00720bULL, 0x008fc80003f1d000ULL,
0x00000018ffa87819ULL, 0x000fe2000001147aULL, 0x000001007c7a7824ULL, 0x000fe200078e00ffULL,
0x0000007b00af7306ULL, 0x000e620000005400ULL, 0x000000018d8d3812ULL, 0x000fc600078efcffULL,
0x00000018ffbb7819ULL, 0x000fe2000001147aULL, 0x000001007d7a7824ULL, 0x000fe400078e00ffULL,
0x0000000179790812ULL, 0x000fe200078efcffULL, 0x0000009500967306ULL, 0x000fe40000209400ULL,
0x00000018ffc27819ULL, 0x000fe2000001147aULL, 0x000001007e7a7824ULL, 0x000fca00078e00ffULL,
0x0000009500977306ULL, 0x0004e20000205400ULL, 0x000000afae00720bULL, 0x002fce0003fbd000ULL,
0x000000a500a67306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x004fce000020d400ULL,
0x000000a500a77306ULL, 0x000e620000205400ULL, 0x000000979600720bULL, 0x008fe40003f9d000ULL,
0x00000018ff967819ULL, 0x000fe4000001147aULL, 0x000000a5007a7245ULL, 0x000fc6000020d400ULL,
0x0000007c00b97306ULL, 0x000fec0000009400ULL, 0x0000000195954812ULL, 0x000fe400078efcffULL,
0x0000007c00ba7306ULL, 0x000ea20000005400ULL, 0x000000a7a600720bULL, 0x002fe40003f5d000ULL,
0x000000789578723eULL, 0x000fca00000010ffULL, 0x0000007b008c7306ULL, 0x0002ec000000d400ULL,
0x000000017a7a2812ULL, 0x000fe400078efcffULL, 0x000000a000a17306ULL, 0x000fe20000209400ULL,
0x000100007b7b7824ULL, 0x002fe200078e00ffULL, 0x000000bab900720bULL, 0x004fc40003f1d000ULL,
0x0000008d7a7a723eULL, 0x000fe400000010ffULL, 0x00000018ffb37819ULL, 0x000fe4000001147bULL,
0x000000a000a27306ULL, 0x0002a20000205400ULL, 0x000000018c8c5812ULL, 0x008fe400078efcffULL,
0x000000b0007b7245ULL, 0x000fca000020d400ULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x002fce000020d400ULL, 0x000000ab00ad7306ULL, 0x0002e20000205400ULL,
0x000000a2a100720bULL, 0x004fce0003fdd000ULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fca000020d400ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x000000b000b27306ULL, 0x000e620000205400ULL, 0x000000adac00720bULL, 0x008fe40003f5d000ULL,
0x00000079a079723eULL, 0x000fca00000010ffULL, 0x000000bb00bc7306ULL, 0x000fe40000209400ULL,
0x000000787064723cULL, 0x080f680000041864ULL, 0x00000001abab2812ULL, 0x000fe400078efcffULL,
0x000000bb00bd7306ULL, 0x0004e20000205400ULL, 0x000000b2b100720bULL, 0x002fe20003f9d000ULL,
0x000000786c44723cULL, 0x000f6c0000041844ULL, 0x0000007c00887306ULL, 0x0002e2000000d400ULL,
0x000000bb00bb7245ULL, 0x004fca000020d400ULL, 0x000000017b7b4812ULL, 0x000fe400078efcffULL,
0x0000007e00c67306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000bdbc00720bULL, 0x008fe40003fbd000ULL, 0x0000008c7b7b723eULL, 0x000fe400000010ffULL,
0x00000018ff917819ULL, 0x000fe4000001147cULL, 0x0000007e00c77306ULL, 0x000fe20000005400ULL,
0x0000000188880812ULL, 0x000fc400078efcffULL, 0x000000a8007c7245ULL, 0x000fe2000020d400ULL,
0x0000007a7060723cULL, 0x080f660000041860ULL, 0x00000001bbbb5812ULL, 0x000fe200078efcffULL,
0x0000007e00837306ULL, 0x000fe6000000d400ULL, 0x00000088bb88723eULL, 0x000fe200000010ffULL,
0x0000007a6c40723cULL, 0x000f680000041840ULL, 0x0000007f00ca7306ULL, 0x000ff00000009400ULL,
0x0000007f00cb7306ULL, 0x000ff00000005400ULL, 0x0000007f00277306ULL, 0x000ff0000000d400ULL,
0x00000091007e7306ULL, 0x000ff00000209400ULL, 0x00000091007f7306ULL, 0x0002b00000205400ULL,
0x0000008e00be7306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x002fce000020d400ULL,
0x0000008e00bf7306ULL, 0x0002e20000205400ULL, 0x0000007f7e00720bULL, 0x004fe40003f1d000ULL,
0x0000008b007e7245ULL, 0x000fca000020d400ULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x0000008e008e7245ULL, 0x002fca000020d400ULL, 0x0000000191910812ULL, 0x000fe400078efcffULL,
0x000000a800aa7306ULL, 0x000e620000205400ULL, 0x000000bfbe00720bULL, 0x008fce0003fbd000ULL,
0x000000b300b47306ULL, 0x000fec0000209400ULL, 0x000000018e8e5812ULL, 0x000fe400078efcffULL,
0x000000b300b57306ULL, 0x000ea20000205400ULL, 0x000000aaa900720bULL, 0x002fe40003fdd000ULL,
0x000000918e8e723eULL, 0x000fca00000010ffULL, 0x000000c200c37306ULL, 0x000fec0000209400ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x000000c200927306ULL, 0x0002e20000205400ULL,
0x000000b5b400720bULL, 0x004fe40003f9d000ULL, 0x0000007cab7c723eULL, 0x000fca00000010ffULL,
0x0000007d00c07306ULL, 0x000fe20000009400ULL, 0x000000c200c27245ULL, 0x002fce000020d400ULL,
0x0000007d00c17306ULL, 0x000e620000005400ULL, 0x00000092c300720bULL, 0x008fce0003f5d000ULL,
0x0000007d00877306ULL, 0x0004ec000000d400ULL, 0x00000001c2c22812ULL, 0x000fe400078efcffULL,
0x000000b600b77306ULL, 0x000fe20000209400ULL, 0x000100007d7d7824ULL, 0x004fe200078e00ffULL,
0x000000c1c000720bULL, 0x002fc80003fdd000ULL, 0x00000018ff907819ULL, 0x000fe4000001147dULL,
0x000000b600b87306ULL, 0x0002a20000205400ULL, 0x000000b3007d7245ULL, 0x000fe4000020d400ULL,
0x00000090008f7245ULL, 0x000fe4000020d400ULL, 0x000000017d7d4812ULL, 0x000fe400078efcffULL,
0x000000c7c600720bULL, 0x000fe20003f9d000ULL, 0x0000009000937306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x002fc4000020d400ULL, 0x0000000187876812ULL, 0x008fca00078efcffULL,
0x0000009000947306ULL, 0x000e620000205400ULL, 0x000000b8b700720bULL, 0x004fc60003f7d000ULL,
0x0000000183834812ULL, 0x000fc800078efcffULL, 0x0000008b00c47306ULL, 0x000fec0000209400ULL,
0x00000001b6b63812ULL, 0x000fe400078efcffULL, 0x0000008b00c57306ULL, 0x000ea20000205400ULL,
0x000000949300720bULL, 0x002fe40003f1d000ULL, 0x000000cbca00720bULL, 0x000fc40003f7d000ULL,
0x0000007db67d723eULL, 0x000fc600000010ffULL, 0x0000009600977306ULL, 0x000fe80000209400ULL,
0x0000007c705c723cULL, 0x080f64000004185cULL, 0x000000018f8f0812ULL, 0x000fe400078efcffULL,
0x0000009600987306ULL, 0x0002e20000205400ULL, 0x000000c5c400720bULL, 0x004fe40003f5d000ULL,
0x0000000127273812ULL, 0x000fe200078efcffULL, 0x0000007c6c3c723cULL, 0x000f68000004183cULL,
0x0000008600c87306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fca000020d400ULL,
0x000000017e7e2812ULL, 0x000fe400078efcffULL, 0x0000008600c97306ULL, 0x0002a20000205400ULL,
0x000000989700720bULL, 0x008fe40003fbd000ULL, 0x0000008f7e8f723eULL, 0x000fe400000010ffULL,
0x00000085007e7245ULL, 0x000fc6000020d400ULL, 0x0000008500897306ULL, 0x000fe20000209400ULL,
0x0000008600867245ULL, 0x002fe2000020d400ULL, 0x0000008e7054723cULL, 0x080f680000041854ULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x00000085008a7306ULL, 0x000e620000205400ULL,
0x000000c9c800720bULL, 0x004fe20003fdd000ULL, 0x0000008e6c34723cULL, 0x000f620000041834ULL,
0x000000839696723eULL, 0x000fca00000010ffULL, 0x0000009c009b7306ULL, 0x000fec0000209400ULL,
0x0000000186866812ULL, 0x000fe400078efcffULL, 0x0000009c009e7306ULL, 0x0004e20000205400ULL,
0x0000008a8900720bULL, 0x002fe40003f5d000ULL, 0x00000087c289723eULL, 0x000fc400000010ffULL,
0x0000009d00877245ULL, 0x000fc6000020d400ULL, 0x00000099007f7306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x004fe2000020d400ULL, 0x000000887058723cULL, 0x080f680000041858ULL,
0x000000017e7e2812ULL, 0x000fe400078efcffULL, 0x0000009900927306ULL, 0x0002a20000205400ULL,
0x0000009e9b00720bULL, 0x008fe20003f1d000ULL, 0x000000886c38723cULL, 0x000f6c0000041838ULL,
0x0000009d00937306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x000000019c9c0812ULL, 0x000fe400078efcffULL, 0x0000009d008c7306ULL, 0x000e620000205400ULL,
0x000000927f00720bULL, 0x004fe40003fbd000ULL, 0x000000279c97723eULL, 0x000fe200000010ffULL,
0x0000000220277824ULL, 0x000fca00078e00ffULL, 0xfffffff827287812ULL, 0x020fe200078ec0ffULL,
0x000000967050723cULL, 0x080f680000041850ULL, 0x0000000199995812ULL, 0x000fe400078efcffULL,
0x0000008c9300720bULL, 0x002fe40003f9d000ULL, 0x000000998686723eULL, 0x000fe200000010ffULL,
0x000000966c30723cULL, 0x000f740000041830ULL, 0x0000000187874812ULL, 0x000fc800078efcffULL,
0x000000877e87723eULL, 0x000fce00000010ffULL, 0x00000086704c723cULL, 0x080f70000004184cULL,
0x000000866c2c723cULL, 0x000b6e000004182cULL, 0x000126c81a6e7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006e6e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126900028ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff277224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x004fc80000015200ULL,
0x00000400136d7984ULL, 0x000ea40000000800ULL, 0x800000006dff7812ULL, 0x006fc4000780486fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c28717210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e29ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff6c7819ULL, 0x000fc8000001146dULL, 0x000000716c6c7211ULL, 0x000fca00078110ffULL,
0x000000ffff6d7224ULL, 0x000fca00000e066dULL, 0x000000026c6c7819ULL, 0x000fc8000000126dULL,
0x0000006c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000127277810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400136d7984ULL, 0x000e640000000800ULL, 0x800000006dff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020287824ULL, 0x000fca00078e00ffULL,
0xffffffe028277812ULL, 0x000fca00078ec0ffULL, 0x0000010016277824ULL, 0x000fca00078e0227ULL,
0x000000c027297810ULL, 0x000fe20007ffe0ffULL, 0x0000590024277a24ULL, 0x010fc600078e02ffULL,
0x0000002029247812ULL, 0x000fe200078ec0ffULL, 0x0000004027737824ULL, 0x000fc800078e00ffULL,
0x0000000119707824ULL, 0x000fe200078e0224ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x000000291e247217ULL, 0x000fe40007800000ULL, 0x0000001028277812ULL, 0x000fe400078ec0ffULL,
0x00000003ff287819ULL, 0x000fe2000001161fULL, 0x0000000124247824ULL, 0x000fc600078e0a29ULL,
0x00000004286d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000128297824ULL, 0x040fe200078e0227ULL,
0x0000002427247217ULL, 0x000fe40007800000ULL, 0x00000008286e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001296c7824ULL, 0x040fe400078e021fULL, 0x00000008296f7824ULL, 0x000fe400078e00ffULL,
0x0000000124247824ULL, 0x000fc600078e0a27ULL, 0xfffffff86f727812ULL, 0x000fe200078ee26cULL,
0x000000016d6c7824ULL, 0x100fe200078e0227ULL, 0x0000000c286f7810ULL, 0x040fe40007ffe0ffULL,
0x000000242800720cULL, 0x080fe20003f86070ULL, 0x0000000129287824ULL, 0x000fe200078e0270ULL,
0x000000246e00720cULL, 0x0c0fe20003f46070ULL, 0x000000016e6e7824ULL, 0x100fe200078e0227ULL,
0x000000246d00720cULL, 0x080fe20003f66070ULL, 0x000000016f797824ULL, 0x040fe200078e0227ULL,
0x000000246f00720cULL, 0x000fe20003f06070ULL, 0x000000016c277824ULL, 0x000fc400078e021fULL,
0x000000086c787824ULL, 0x000fe400078e00ffULL, 0x000000016e6d7824ULL, 0x040fe400078e021fULL,
0x000000086e7a7824ULL, 0x000fe200078e00ffULL, 0xfffffff878247812ULL, 0x000fe200078ee227ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000620073277a11ULL, 0x040fe400078a38ffULL,
0xfffffff87a787812ULL, 0x000fe200078ee26dULL, 0x000000016c6c7824ULL, 0x100fe200078e0270ULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000016e6e7824ULL, 0x000fe200078e0270ULL,
0x0000630073737a11ULL, 0x000fe200028f3cffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002827287210ULL, 0x000fc60007fbe0ffULL, 0x0000000179707824ULL, 0x000fe200078e0270ULL,
0x000000126c6c7212ULL, 0x000fe200078efcffULL, 0x000000806e6e7825ULL, 0x000fc800078e00ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000126e6e7212ULL, 0x000fc600078efcffULL,
0x0000000129297824ULL, 0x000fe200028e0673ULL, 0x000000276c6c7210ULL, 0x080fe20007fbe0ffULL,
0x00000001797a7824ULL, 0x040fe200078e021fULL, 0x0000001270707212ULL, 0x000fe200078efcffULL,
0x0000000879797824ULL, 0x000fe400078e00ffULL, 0x000000016d6d7824ULL, 0x000fe200028e0673ULL,
0x000000276e6e7210ULL, 0x080fe40007fbe0ffULL, 0x0000002770707210ULL, 0x000fe20007fde0ffULL,
0x0000001072277824ULL, 0x000fe200078e0225ULL, 0xfffffff8797a7812ULL, 0x000fe200078ee27aULL,
0x000000016f6f7824ULL, 0x000fc400028e0673ULL, 0x0000000171717824ULL, 0x000fe200030e0673ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e2000e101c48ULL,
0x0000001024737824ULL, 0x100fe400078e0225ULL, 0x0000001078797824ULL, 0x100fe400078e0225ULL,
0x000000107a7b7824ULL, 0x000fe200078e0225ULL, 0x000000006c737faeULL, 0x0003e8000d901c48ULL,
0x000000006e797faeULL, 0x0003e8000d101c48ULL, 0x00000000707b7faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001028287812ULL, 0x000fc800078ec0ffULL,
0x000000281f247211ULL, 0x000fc800078fe8ffULL, 0x0000000424297810ULL, 0x040fe20007ffe0ffULL,
0x0000000124277824ULL, 0x040fe200078e021fULL, 0x0000000c246f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000824727824ULL, 0x040fe400078e00ffULL, 0x0000000124287824ULL, 0x100fe400078e0270ULL,
0x00000001296c7824ULL, 0x000fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee227ULL,
0x000000086f7a7824ULL, 0x000fe200078e00ffULL, 0x0000000824277810ULL, 0x000fe20007ffe0ffULL,
0x0000000129247824ULL, 0x000fc400078e021fULL, 0x0000000829297824ULL, 0x000fe400078e00ffULL,
0x00000001276e7824ULL, 0x040fe400078e0270ULL, 0x00000001276d7824ULL, 0x100fe200078e021fULL,
0xfffffff829247812ULL, 0x000fe200078ee224ULL, 0x0000000827787824ULL, 0x000fe400078e00ffULL,
0x000000016f277824ULL, 0x000fe400078e021fULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fc400078ee26dULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee227ULL,
0x000000016f707824ULL, 0x000fe200078e0270ULL, 0x0000620073277a11ULL, 0x040fe200078038ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000001228287212ULL, 0x000fe400078efcffULL,
0x0000630073737a11ULL, 0x000fe200000f3cffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x0000002827287210ULL, 0x000fe40007f1e0ffULL, 0x000000126c6c7212ULL, 0x080fe200078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000126e6e7212ULL, 0x000fc400078efcffULL,
0x0000006c276c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000129297824ULL, 0x000fe200000e0673ULL,
0x0000001270707212ULL, 0x000fe200078efcffULL, 0x0000001078797824ULL, 0x000fe200078e0225ULL,
0x0000006e276e7210ULL, 0x000fe20007f1e0ffULL, 0x000000016d6d7824ULL, 0x000fe200010e0673ULL,
0x0000007027707210ULL, 0x000fe20007f7e0ffULL, 0x0000001072277824ULL, 0x000fe400078e0225ULL,
0x000000016f6f7824ULL, 0x100fe400000e0673ULL, 0x0000000171717824ULL, 0x000fe200018e0673ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e2000b901c48ULL,
0x0000001024737824ULL, 0x000fc400078e0225ULL, 0x000000107a7b7824ULL, 0x000fc600078e0225ULL,
0x000000006c737faeULL, 0x0003e8000b901c48ULL, 0x000000006e797faeULL, 0x0003e8000b901c48ULL,
0x00000000707b7faeULL, 0x0003e4000b901c48ULL, 0x0000000820277824ULL, 0x002fe200078e00ffULL,
0x0000000318287810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff027277812ULL, 0x000fe400078ec0ffULL, 0x0000001d2800720cULL, 0x000fe40003f06070ULL,
0x00000000270473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000117288824ULL, 0x000fc400078e0228ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000640028288625ULL, 0x000fca00078e0029ULL, 0x0000000828248981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b000276e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480023707f8cULL, 0x000664000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x01264c0023277984ULL, 0x002e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c286c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e29ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff277819ULL, 0x000fc8000001146dULL,
0x0000006c27277211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000227277819ULL, 0x000fc8000000126cULL, 0x000000270000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c0023277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002020237824ULL, 0x008fca00078e00ffULL, 0xffffff8023237812ULL, 0x000fc800078ec0ffULL,
0x0000010012287810ULL, 0x000fca0007ffe023ULL, 0x0000000111287824ULL, 0x000fca00078e0228ULL,
0x0120000028707984ULL, 0x000e680000000800ULL, 0x0122000028717984ULL, 0x0006a20000000800ULL,
0x000000217000720bULL, 0x002fe20003f1d000ULL, 0x000116d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000727806ULL, 0x008fc800000e0100ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff277424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e0021ULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x000000021b237810ULL, 0x000fe40007ffe0ffULL, 0x000000217000720bULL, 0x000fe40003f54000ULL,
0x000000202300720cULL, 0x000fe20003f05270ULL, 0x000116827f007947ULL, 0x000fd4000b800000ULL,
0x0000000000737806ULL, 0x000fc400010e0100ULL, 0x0000008020288824ULL, 0x000fe200078e0212ULL,
0x0000002170237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000111288824ULL, 0x000fca00078e0228ULL, 0x0124002328008388ULL, 0x0003e20000000800ULL,
0x000000ff7300720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000002123217221ULL, 0x002fe20000010100ULL, 0x000000ff73ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b21217820ULL, 0x000fcc0000410000ULL,
0x0000002100217308ULL, 0x000e640000000800ULL, 0x0000002122227220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161fULL,
0x000115c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002e400000e0000ULL,
0x0000002868687220ULL, 0x08cfe20000410000ULL, 0x0000002869697220ULL, 0x080fe20000410000ULL,
0x0000002864647220ULL, 0x080fe20000410000ULL, 0x0000002865657220ULL, 0x080fe20000410000ULL,
0x0000002860607220ULL, 0x080fe20000410000ULL, 0x0000002861617220ULL, 0x080fe20000410000ULL,
0x000000285c5c7220ULL, 0x080fe20000410000ULL, 0x000000285d5d7220ULL, 0x080fe20000410000ULL,
0x0000002858587220ULL, 0x080fe20000410000ULL, 0x0000002859597220ULL, 0x080fe20000410000ULL,
0x0000002854547220ULL, 0x080fe20000410000ULL, 0x0000002855557220ULL, 0x080fe20000410000ULL,
0x0000002850507220ULL, 0x080fe20000410000ULL, 0x0000002851517220ULL, 0x080fe20000410000ULL,
0x000000284c4c7220ULL, 0x080fe20000410000ULL, 0x000000284d4d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0073ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081f297811ULL, 0x002fe200078ff0ffULL, 0x000114927f007947ULL, 0x000fea000b800000ULL,
0x00001f2921287589ULL, 0x0002e400000e0000ULL, 0x000000286a6a7220ULL, 0x08cfe20000410000ULL,
0x000000286b6b7220ULL, 0x080fe20000410000ULL, 0x0000002866667220ULL, 0x080fe20000410000ULL,
0x0000002867677220ULL, 0x080fe20000410000ULL, 0x0000002862627220ULL, 0x080fe20000410000ULL,
0x0000002863637220ULL, 0x080fe20000410000ULL, 0x000000285e5e7220ULL, 0x080fe20000410000ULL,
0x000000285f5f7220ULL, 0x080fe20000410000ULL, 0x000000285a5a7220ULL, 0x080fe20000410000ULL,
0x000000285b5b7220ULL, 0x080fe20000410000ULL, 0x0000002856567220ULL, 0x080fe20000410000ULL,
0x0000002857577220ULL, 0x080fe20000410000ULL, 0x0000002852527220ULL, 0x080fe20000410000ULL,
0x0000002853537220ULL, 0x080fe20000410000ULL, 0x000000284e4e7220ULL, 0x080fe20000410000ULL,
0x000000284f4f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000073ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101f297811ULL, 0x002fe200078ff0ffULL,
0x000113627f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002e400000e0000ULL,
0x0000002848487220ULL, 0x08cfe20000410000ULL, 0x0000002849497220ULL, 0x080fe20000410000ULL,
0x0000002844447220ULL, 0x080fe20000410000ULL, 0x0000002845457220ULL, 0x080fe20000410000ULL,
0x0000002840407220ULL, 0x080fe20000410000ULL, 0x0000002841417220ULL, 0x080fe20000410000ULL,
0x000000283c3c7220ULL, 0x080fe20000410000ULL, 0x000000283d3d7220ULL, 0x080fe20000410000ULL,
0x0000002838387220ULL, 0x080fe20000410000ULL, 0x0000002839397220ULL, 0x080fe20000410000ULL,
0x0000002834347220ULL, 0x080fe20000410000ULL, 0x0000002835357220ULL, 0x080fe20000410000ULL,
0x0000002830307220ULL, 0x080fe20000410000ULL, 0x0000002831317220ULL, 0x080fe20000410000ULL,
0x000000282c2c7220ULL, 0x080fe20000410000ULL, 0x000000282d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000073ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181f297811ULL, 0x002fe200078ff0ffULL,
0x000112427f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002e400000e0000ULL,
0x000000284a4a7220ULL, 0x08cfe20000410000ULL, 0x000000284b4b7220ULL, 0x080fe20000410000ULL,
0x0000002846467220ULL, 0x080fe20000410000ULL, 0x0000002847477220ULL, 0x080fe20000410000ULL,
0x0000002842427220ULL, 0x080fe20000410000ULL, 0x0000002843437220ULL, 0x080fe20000410000ULL,
0x000000283e3e7220ULL, 0x080fe20000410000ULL, 0x000000283f3f7220ULL, 0x080fe20000410000ULL,
0x000000283a3a7220ULL, 0x080fe20000410000ULL, 0x000000283b3b7220ULL, 0x080fe20000410000ULL,
0x0000002836367220ULL, 0x080fe20000410000ULL, 0x0000002837377220ULL, 0x080fe20000410000ULL,
0x0000002832327220ULL, 0x080fe20000410000ULL, 0x0000002833337220ULL, 0x080fe20000410000ULL,
0x000000282e2e7220ULL, 0x080fe20000410000ULL, 0x000000282f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007372ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff277424ULL, 0x000fd800078e00ffULL, 0x8000002370700221ULL, 0x000fe20000010000ULL,
0x00007610ff270816ULL, 0x000fc60000000027ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000100308ULL, 0x000e640000000800ULL, 0x0000001071710220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002271227221ULL, 0x004fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000000820217824ULL, 0x000fca00078e00ffULL,
0xfffffff021707812ULL, 0x000fca00078ec0ffULL, 0x0126ac0070217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c286c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e29ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc8000001146dULL, 0x0000006c21217211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000221217819ULL, 0x000fc8000000126cULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac0070217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991027217816ULL, 0x000fc800000000ffULL,
0x000000ff2100720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000010ff0c723eULL, 0x000fe400000010ffULL, 0x00000002ff217819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x00010e127f007947ULL, 0x000fea000b800000ULL,
0x00001f210c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000821297810ULL, 0x002fe20007ffe0ffULL,
0x00010e427f007947ULL, 0x000fea000b800000ULL, 0x00000010210d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001821297810ULL, 0x002fe20007ffe0ffULL, 0x00010e927f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x0000040020217824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100020277824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00021217812ULL, 0x000fc400078ec0ffULL,
0xffffe00027277812ULL, 0x000fe400078ec0ffULL, 0x0000c00021217810ULL, 0x000fe40007ffe0ffULL,
0x0000e00027277810ULL, 0x000fc60007ffe0ffULL, 0x0000001009097824ULL, 0x100fe400078e0221ULL,
0x0000001008087824ULL, 0x000fe400078e0221ULL, 0x0000001007787824ULL, 0x000fe200078e0227ULL,
0x000000000970783bULL, 0x0002e80000000200ULL, 0x000000000828783bULL, 0x0022a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707231ULL, 0x08cfe400003400ffULL,
0x0000000f72727231ULL, 0x000fc400003400ffULL, 0x0000000e71717231ULL, 0x080fe400003400ffULL,
0x0000000e73737231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x080fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fe400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000e620000004200ULL, 0x00000010067c7824ULL, 0x000fe200078e0227ULL,
0x00000f8000007945ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000100786d7824ULL, 0x002fe200078e00ffULL, 0x0000007800087306ULL, 0x000fe20000009400ULL,
0x00000018ff957819ULL, 0x000fe20000011478ULL, 0x0000010079947824ULL, 0x040fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe20000011479ULL, 0x00010000799e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x000001007aa67824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011494ULL, 0x0000007800097306ULL, 0x000e620000005400ULL,
0x000001007ba97824ULL, 0x000fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe2000001147aULL,
0x000001007dc17824ULL, 0x008fe200078e00ffULL, 0x00000018ffa67819ULL, 0x000fe200000114a6ULL,
0x000001007cba7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb07819ULL, 0x000fc400000114a9ULL,
0x0000006d00927306ULL, 0x000fe20000209400ULL, 0x00000018ffb57819ULL, 0x000fe4000001147bULL,
0x00000018ffc17819ULL, 0x000fe400000114c1ULL, 0x00000018ff9e7819ULL, 0x000fe4000001149eULL,
0x00000018ff917819ULL, 0x000fe2000001147cULL, 0x0000006d00937306ULL, 0x0006a20000205400ULL,
0x000000090800720bULL, 0x002fe40003f9d000ULL, 0x00000018ff8c7819ULL, 0x000fc4000001147dULL,
0x00000018ff067819ULL, 0x000fe4000001147fULL, 0x0000009b00097245ULL, 0x000fe2000020d400ULL,
0x00000078006c7306ULL, 0x0002a2000000d400ULL, 0x0000006d006d7245ULL, 0x008fe4000020d400ULL,
0x00000018ff277819ULL, 0x000fe4000001147eULL, 0x00000018ffba7819ULL, 0x000fc600000114baULL,
0x0000007900987306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x000000939200720bULL, 0x004fe20003fdd000ULL, 0x000100007d927824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900997306ULL, 0x000e620000005400ULL,
0x00000018ff927819ULL, 0x000fe40000011492ULL, 0x000000016c6c4812ULL, 0x000fc800078efcffULL,
0x000000016d6d6812ULL, 0x000fe200078efcffULL, 0x00000079009a7306ULL, 0x000eb0000000d400ULL,
0x0000007800947306ULL, 0x000fe20000209400ULL, 0x000000999800720bULL, 0x002fe20003f5d000ULL,
0x000100007e987824ULL, 0x000fca00078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011498ULL,
0x0000007800797306ULL, 0x0002ec0000205400ULL, 0x000000019a9a2812ULL, 0x004fe400078efcffULL,
0x0000009500967306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x002fce000020d400ULL,
0x0000009500977306ULL, 0x0002a20000205400ULL, 0x000000799400720bULL, 0x008fe40003fdd000ULL,
0x000000a600797245ULL, 0x000fca000020d400ULL, 0x000000a600a77306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x002fca000020d400ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x000000a600a87306ULL, 0x000e620000205400ULL, 0x000000979600720bULL, 0x004fce0003fbd000ULL,
0x000000a100a27306ULL, 0x000fec0000209400ULL, 0x0000000195955812ULL, 0x000fe400078efcffULL,
0x000000a100a37306ULL, 0x0004e20000205400ULL, 0x000000a8a700720bULL, 0x002fce0003fdd000ULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x004fca000020d400ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x000000b000b27306ULL, 0x0002a20000205400ULL,
0x000000a3a200720bULL, 0x008fce0003f5d000ULL, 0x0000007a00a47306ULL, 0x000fe20000009400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x00000001a1a12812ULL, 0x000fe400078efcffULL,
0x0000007a00a57306ULL, 0x000e620000005400ULL, 0x000000b2b100720bULL, 0x004fce0003fbd000ULL,
0x0000007a008e7306ULL, 0x0004ec000000d400ULL, 0x00000001b0b05812ULL, 0x000fe400078efcffULL,
0x0000007b00ae7306ULL, 0x000fe20000009400ULL, 0x000100007a7a7824ULL, 0x004fe200078e00ffULL,
0x000000a5a400720bULL, 0x002fc80003f9d000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007b00af7306ULL, 0x000fee0000005400ULL, 0x000000018e8e4812ULL, 0x008fe200078efcffULL,
0x0000007b008d7306ULL, 0x0003f0000000d400ULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x000100007b7b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000ab00ad7306ULL, 0x0002b00000205400ULL, 0x0000009b009c7306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fce000020d400ULL, 0x0000009b009d7306ULL, 0x000e620000205400ULL,
0x000000adac00720bULL, 0x004fce0003fdd000ULL, 0x0000007a00a97306ULL, 0x000fec0000209400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x0000007a00aa7306ULL, 0x0004e20000205400ULL,
0x0000009d9c00720bULL, 0x002fe20003f7d000ULL, 0x000001007f9c7824ULL, 0x000fc400078e00ffULL,
0x000100007f9d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe2000001149cULL,
0x0000007b00b37306ULL, 0x000fe20000209400ULL, 0x0000007a007a7245ULL, 0x004fe4000020d400ULL,
0x00000018ff9d7819ULL, 0x000fc6000001149dULL, 0x0000000109093812ULL, 0x000fe400078efcffULL,
0x0000007b00b47306ULL, 0x0002a20000205400ULL, 0x000000aaa900720bULL, 0x008fe40003f5d000ULL,
0x0000009a0909723eULL, 0x000fca00000010ffULL, 0x000000c100c27306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x000000017a7a2812ULL, 0x000fe400078efcffULL,
0x000000c100937306ULL, 0x0002e20000205400ULL, 0x000000b4b300720bULL, 0x004fe40003fbd000ULL,
0x0000007aab7a723eULL, 0x000fca00000010ffULL, 0x0000007c00b87306ULL, 0x000fe20000009400ULL,
0x000000c100c17245ULL, 0x002fca000020d400ULL, 0x000000017b7b5812ULL, 0x000fe400078efcffULL,
0x0000007c00b97306ULL, 0x000e620000005400ULL, 0x00000093c200720bULL, 0x008fce0003fdd000ULL,
0x0000007d00bf7306ULL, 0x000fec0000009400ULL, 0x00000001c1c16812ULL, 0x000fe400078efcffULL,
0x0000007d00c07306ULL, 0x000ea20000005400ULL, 0x000000b9b800720bULL, 0x002fce0003f5d000ULL,
0x0000009e009f7306ULL, 0x000ff00000209400ULL, 0x0000009e00a07306ULL, 0x0002e20000205400ULL,
0x000000c0bf00720bULL, 0x004fce0003fbd000ULL, 0x0000007c00877306ULL, 0x0004e2000000d400ULL,
0x0000009e009e7245ULL, 0x002fce000020d400ULL, 0x0000007d00867306ULL, 0x000262000000d400ULL,
0x000100007c7c7824ULL, 0x004fe200078e00ffULL, 0x000000a09f00720bULL, 0x008fcc0003f7d000ULL,
0x0000007f00c57306ULL, 0x000fe20000009400ULL, 0x00000018ff7d7819ULL, 0x002fe2000001147cULL,
0x000001007e7c7824ULL, 0x000fe200078e00ffULL, 0x0000000187872812ULL, 0x000fc800078efcffULL,
0x00000018ff947819ULL, 0x000fe2000001147cULL, 0x0000007f00c67306ULL, 0x000fe20000005400ULL,
0x000000019e9e3812ULL, 0x000fe400078efcffULL, 0x0000000186865812ULL, 0x000fe400078efcffULL,
0x000000afae00720bULL, 0x000fe40003f7d000ULL, 0x000000b5007c7245ULL, 0x000fe2000020d400ULL,
0x0000007f00837306ULL, 0x000ff0000000d400ULL, 0x0000007d00087306ULL, 0x000fe40000209400ULL,
0x000000018d8d3812ULL, 0x000fcc00078efcffULL, 0x0000007d007f7306ULL, 0x000e700000205400ULL,
0x0000007e00c37306ULL, 0x000ff00000009400ULL, 0x0000007e00c47306ULL, 0x000fe20000005400ULL,
0x0000007f0800720bULL, 0x002fc40003fdd000ULL, 0x0000006c6d08723eULL, 0x000fe400000010ffULL,
0x00000092007f7245ULL, 0x000fe4000020d400ULL, 0x00000078956c723eULL, 0x000fe200000010ffULL,
0x0000007e00857306ULL, 0x000fe2000000d400ULL, 0x0000008e7978723eULL, 0x000fe200000010ffULL,
0x000000087068723cULL, 0x000f620000041868ULL, 0x0000009ea16d723eULL, 0x000fe400000010ffULL,
0x0000008db079723eULL, 0x000fc600000010ffULL, 0x000000b500b67306ULL, 0x000fe40000209400ULL,
0x0000006c7064723cULL, 0x040f6c0000041864ULL, 0x000000b500b77306ULL, 0x000e640000205400ULL,
0x000000787060723cULL, 0x000f6c0000041860ULL, 0x0000009100bd7306ULL, 0x000fe40000209400ULL,
0x000000082848723cULL, 0x040f6c0000041848ULL, 0x0000009100be7306ULL, 0x0004e20000205400ULL,
0x000000b7b600720bULL, 0x002fe20003f9d000ULL, 0x0000006c2844723cULL, 0x040f6c0000041844ULL,
0x00000092007e7306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x004fe2000020d400ULL,
0x000000782840723cULL, 0x000b680000041840ULL, 0x000000017c7c4812ULL, 0x000fc400078efcffULL,
0x0000009200977306ULL, 0x000e620000205400ULL, 0x000000bebd00720bULL, 0x008fe20003f5d000ULL,
0x0000001002787824ULL, 0x020fe200078e0203ULL, 0x000000c4c300720bULL, 0x000fe40003f9d000ULL,
0x0000007b7c7b723eULL, 0x000fc600000010ffULL, 0x0000008c008f7306ULL, 0x000fe80000209400ULL,
0x0000007a705c723cULL, 0x080f64000004185cULL, 0x0000000191912812ULL, 0x000fe400078efcffULL,
0x0000008c00907306ULL, 0x0004e20000205400ULL, 0x000000977e00720bULL, 0x002fe40003fbd000ULL,
0x0000007d007e7245ULL, 0x000fe2000020d400ULL, 0x0000007a283c723cULL, 0x000f62000004183cULL,
0x0000000185854812ULL, 0x000fc400078efcffULL, 0x000000017e7e6812ULL, 0x000fe200078efcffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x004fe4000020d400ULL,
0x00000086c17d723eULL, 0x000fe400000010ffULL, 0x0000007e917e723eULL, 0x000fe400000010ffULL,
0x000000017f7f5812ULL, 0x000fe200078efcffULL, 0x000000ba00bc7306ULL, 0x0002a20000205400ULL,
0x000000908f00720bULL, 0x008fce0003fdd000ULL, 0x0000009400967306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x000000018c8c6812ULL, 0x000fe400078efcffULL,
0x0000009400997306ULL, 0x0002e20000205400ULL, 0x000000bcbb00720bULL, 0x004fe40003f7d000ULL,
0x0000007f8c7f723eULL, 0x000fca00000010ffULL, 0x0000009c009b7306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fe2000020d400ULL, 0x0000007e7054723cULL, 0x080f680000041854ULL,
0x00000001baba3812ULL, 0x000fe400078efcffULL, 0x0000009c00a07306ULL, 0x0002a20000205400ULL,
0x000000999600720bULL, 0x008fe20003f5d000ULL, 0x0000007e2834723cULL, 0x000f620000041834ULL,
0x000000c6c500720bULL, 0x000fc40003f7d000ULL, 0x0000009d00997245ULL, 0x000fe4000020d400ULL,
0x00000087ba7c723eULL, 0x000fe200000010ffULL, 0x0000002700887306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fca000020d400ULL, 0x0000000194942812ULL, 0x000fe200078efcffULL,
0x0000007c7058723cULL, 0x080f620000041858ULL, 0x00000027008b7306ULL, 0x0002e20000205400ULL,
0x000000a09b00720bULL, 0x004fe40003fbd000ULL, 0x0000000183833812ULL, 0x000fe400078efcffULL,
0x000000859494723eULL, 0x000fe400000010ffULL, 0x0000007c2838723cULL, 0x000f620000041838ULL,
0x00000006008a7306ULL, 0x000fe20000209400ULL, 0x0000002700277245ULL, 0x002fca000020d400ULL,
0x000000019c9c5812ULL, 0x000fe400078efcffULL, 0x0000000600897306ULL, 0x0002a20000205400ULL,
0x0000008b8800720bULL, 0x008fe40003fdd000ULL, 0x000000839c95723eULL, 0x000fca00000010ffULL,
0x0000009800937306ULL, 0x000fe20000209400ULL, 0x0000000600067245ULL, 0x002fe2000020d400ULL,
0x000000947050723cULL, 0x080f680000041850ULL, 0x0000000127276812ULL, 0x000fe400078efcffULL,
0x00000098009a7306ULL, 0x0002e20000205400ULL, 0x000000898a00720bULL, 0x004fe20003f5d000ULL,
0x000000942830723cULL, 0x000f6c0000041830ULL, 0x0000009d008f7306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fca000020d400ULL, 0x0000000106062812ULL, 0x000fe400078efcffULL,
0x0000009d008e7306ULL, 0x000e620000205400ULL, 0x0000009a9300720bULL, 0x008fda0003f9d000ULL,
0x0000000198984812ULL, 0x000fe400078efcffULL, 0x0000008e8f00720bULL, 0x002fe40003fbd000ULL,
0x000000982798723eULL, 0x000fd600000010ffULL, 0x0000000199995812ULL, 0x000fc800078efcffULL,
0x000000990699723eULL, 0x000fce00000010ffULL, 0x00000098704c723cULL, 0x080b6e000004184cULL,
0x0000001005707824ULL, 0x120fe200078e0221ULL, 0x000000982828723cULL, 0x000b62000004182cULL,
0x0000001004217824ULL, 0x000fc800078e0221ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x00000000212c783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000000f70707231ULL, 0x082fe400003400ffULL, 0x0000000f72727231ULL, 0x000fe400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fc400003400ffULL,
0x0000000d2c2c7231ULL, 0x088fe400003400ffULL, 0x0000000d2e2e7231ULL, 0x000fe400003400ffULL,
0x0000000c2d2d7231ULL, 0x080fe400003400ffULL, 0x0000000c2f2f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x00000010007c7824ULL, 0x000fcc00078e0203ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000100786d7824ULL, 0x004fe200078e00ffULL, 0x0000007800087306ULL, 0x000fe20000009400ULL,
0x00000018ff8f7819ULL, 0x000fe20000011478ULL, 0x00000100798d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011479ULL, 0x000001007a9f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x000001007ba27824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe2000001148dULL, 0x0000007800097306ULL, 0x000ea20000005400ULL,
0x00000018ff9f7819ULL, 0x000fe2000001149fULL, 0x000100007fc67824ULL, 0x008fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fc4000001147aULL, 0x00000018ffaa7819ULL, 0x000fe400000114a2ULL,
0x00000018ff8a7819ULL, 0x000fe2000001147cULL, 0x0000006d008b7306ULL, 0x000fe20000209400ULL,
0x00000018ffb07819ULL, 0x000fe4000001147bULL, 0x00000018ff877819ULL, 0x000fe4000001147dULL,
0x00000018ff067819ULL, 0x000fe4000001147fULL, 0x00000018ff217819ULL, 0x000fe2000001147eULL,
0x0000006d008c7306ULL, 0x0006620000205400ULL, 0x000000090800720bULL, 0x004fc40003fbd000ULL,
0x0000009500097245ULL, 0x000fe4000020d400ULL, 0x00000018ffc67819ULL, 0x000fc600000114c6ULL,
0x00000078006c7306ULL, 0x000462000000d400ULL, 0x0000006d006d7245ULL, 0x008fce000020d400ULL,
0x0000009500967306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x004fe200078e00ffULL,
0x0000008c8b00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000009500977306ULL, 0x000e620000205400ULL, 0x000000016c6c5812ULL, 0x000fcc00078efcffULL,
0x000000016d6d2812ULL, 0x000fe200078efcffULL, 0x00000078008d7306ULL, 0x000ff00000209400ULL,
0x00000078008e7306ULL, 0x0004e20000205400ULL, 0x000000979600720bULL, 0x002fce0003f1d000ULL,
0x0000007900927306ULL, 0x000fe20000009400ULL, 0x0000007800787245ULL, 0x004fca000020d400ULL,
0x0000000109090812ULL, 0x000fe400078efcffULL, 0x0000007900937306ULL, 0x000e620000005400ULL,
0x0000008e8d00720bULL, 0x008fce0003f5d000ULL, 0x0000007900947306ULL, 0x0004ec000000d400ULL,
0x0000000178782812ULL, 0x000fe400078efcffULL, 0x0000007a009d7306ULL, 0x000fe20000009400ULL,
0x0001000079797824ULL, 0x004fe200078e00ffULL, 0x000000939200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007a009e7306ULL, 0x000e6e0000005400ULL,
0x0000000194946812ULL, 0x008fe200078efcffULL, 0x0000007a00897306ULL, 0x0004e6000000d400ULL,
0x000000940909723eULL, 0x000fca00000010ffULL, 0x0000007900987306ULL, 0x000fe20000209400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x0000009e9d00720bULL, 0x002fc80003f7d000ULL,
0x00000018ffa27819ULL, 0x000fe2000001147aULL, 0x000001007c7a7824ULL, 0x000fe200078e00ffULL,
0x0000007900997306ULL, 0x0002a80000205400ULL, 0x00000018ffb57819ULL, 0x000fe2000001147aULL,
0x000001007d7a7824ULL, 0x000fe400078e00ffULL, 0x0000000189893812ULL, 0x008fe200078efcffULL,
0x0000007b00a87306ULL, 0x000fe20000009400ULL, 0x0000007900797245ULL, 0x002fc4000020d400ULL,
0x00000018ffbc7819ULL, 0x000fe2000001147aULL, 0x000100007d7a7824ULL, 0x000fc800078e00ffULL,
0x0000007b00a97306ULL, 0x000e620000005400ULL, 0x000000999800720bULL, 0x004fe40003f1d000ULL,
0x00000018ff8b7819ULL, 0x000fe4000001147aULL, 0x0000009f007a7245ULL, 0x000fc6000020d400ULL,
0x0000008f00907306ULL, 0x000fec0000209400ULL, 0x0000000179790812ULL, 0x000fe400078efcffULL,
0x0000008f00917306ULL, 0x0004e20000205400ULL, 0x000000a9a800720bULL, 0x002fce0003fbd000ULL,
0x0000009f00a07306ULL, 0x000fe20000209400ULL, 0x0000008f008f7245ULL, 0x004fce000020d400ULL,
0x0000009f00a17306ULL, 0x000e620000205400ULL, 0x000000919000720bULL, 0x008fce0003f9d000ULL,
0x0000007b00887306ULL, 0x0004ec000000d400ULL, 0x000000018f8f4812ULL, 0x000fe400078efcffULL,
0x0000007c00b37306ULL, 0x000fe20000009400ULL, 0x000000a1a000720bULL, 0x002fe20003f5d000ULL,
0x000100007b7b7824ULL, 0x004fca00078e00ffULL, 0x00000018ffad7819ULL, 0x000fe2000001147bULL,
0x0000007c00b47306ULL, 0x000e620000005400ULL, 0x0000000188885812ULL, 0x008fe200078efcffULL,
0x000001007e7b7824ULL, 0x000fc800078e00ffULL, 0x000000017a7a2812ULL, 0x000fe400078efcffULL,
0x0000009a009b7306ULL, 0x000fe20000209400ULL, 0x00000018ff907819ULL, 0x000fe4000001147bULL,
0x000000aa007b7245ULL, 0x000fca000020d400ULL, 0x0000009a009c7306ULL, 0x0004e20000205400ULL,
0x000000b4b300720bULL, 0x002fce0003f1d000ULL, 0x000000a500a67306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x004fce000020d400ULL, 0x000000a500a77306ULL, 0x0002a20000205400ULL,
0x0000009c9b00720bULL, 0x008fce0003fdd000ULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x002fca000020d400ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x000000aa00ac7306ULL, 0x000e620000205400ULL, 0x000000a7a600720bULL, 0x004fce0003f5d000ULL,
0x000000b500b67306ULL, 0x000fec0000209400ULL, 0x00000001a5a52812ULL, 0x000fe400078efcffULL,
0x000000b500b77306ULL, 0x000ea20000205400ULL, 0x000000acab00720bULL, 0x002fce0003f9d000ULL,
0x0000007c00857306ULL, 0x0002ec000000d400ULL, 0x000000017b7b4812ULL, 0x000fe400078efcffULL,
0x0000007d00ba7306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000b7b600720bULL, 0x004fcc0003fbd000ULL, 0x0000007d00bb7306ULL, 0x000fe20000005400ULL,
0x0000000185850812ULL, 0x008fce00078efcffULL, 0x0000007d00277306ULL, 0x0003f0000000d400ULL,
0x0000007f00c47306ULL, 0x000fe20000009400ULL, 0x00000018ff7d7819ULL, 0x002fe2000001147cULL,
0x000001007f7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff957819ULL, 0x000fe2000001147cULL,
0x0000007f00c57306ULL, 0x000fe20000005400ULL, 0x000000b5007c7245ULL, 0x000fc8000020d400ULL,
0x000000017c7c5812ULL, 0x000fc600078efcffULL, 0x0000007f00027306ULL, 0x000fe2000000d400ULL,
0x000000857c7c723eULL, 0x000fce00000010ffULL, 0x0000007d00087306ULL, 0x000ff00000209400ULL,
0x0000007d007f7306ULL, 0x000e700000205400ULL, 0x0000008a00b87306ULL, 0x000ff00000209400ULL,
0x0000008a00b97306ULL, 0x000ea20000205400ULL, 0x0000007f0800720bULL, 0x002fc40003f1d000ULL,
0x0000006c6d08723eULL, 0x000fe400000010ffULL, 0x0000008a007f7245ULL, 0x000fe4000020d400ULL,
0x000000788f6c723eULL, 0x000fe200000010ffULL, 0x000000a200a37306ULL, 0x000fe20000209400ULL,
0x000000897a78723eULL, 0x000fe200000010ffULL, 0x000000082c48723cULL, 0x000b620000041848ULL,
0x000000799a6d723eULL, 0x000fe400000010ffULL, 0x000000887b79723eULL, 0x000fc400000010ffULL,
0x0000008700887245ULL, 0x000fe2000020d400ULL, 0x000000a200a47306ULL, 0x0002e20000205400ULL,
0x000000b9b800720bULL, 0x004fe20003fbd000ULL, 0x0000006c2c44723cULL, 0x040b6c0000041844ULL,
0x000000ad00ae7306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fe2000020d400ULL,
0x000000782c40723cULL, 0x000b680000041840ULL, 0x000000017f7f5812ULL, 0x000fc400078efcffULL,
0x000000ad00af7306ULL, 0x0002a20000205400ULL, 0x000000a4a300720bULL, 0x008fe20003fdd000ULL,
0x000000087068723cULL, 0x040b6c0000041868ULL, 0x000000bc00bd7306ULL, 0x000fe20000209400ULL,
0x000000ad00ad7245ULL, 0x002fe2000020d400ULL, 0x0000006c7064723cULL, 0x000b680000041864ULL,
0x00000001a2a26812ULL, 0x000fc400078efcffULL, 0x000000bc008c7306ULL, 0x0002e20000205400ULL,
0x000000afae00720bULL, 0x004fe20003f9d000ULL, 0x000000787060723cULL, 0x000b620000041860ULL,
0x000000bbba00720bULL, 0x000fe40003fdd000ULL, 0x000000a2a57a723eULL, 0x000fc600000010ffULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x000000bc00bc7245ULL, 0x002fca000020d400ULL,
0x00000001adad4812ULL, 0x000fe400078efcffULL, 0x000000b000b27306ULL, 0x0002a20000205400ULL,
0x0000008cbd00720bULL, 0x008fe40003f5d000ULL, 0x0000000127276812ULL, 0x000fca00078efcffULL,
0x0000008b008d7306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fca000020d400ULL,
0x00000001bcbc2812ULL, 0x000fe400078efcffULL, 0x0000008b008e7306ULL, 0x0003e20000205400ULL,
0x000000b2b100720bULL, 0x004fce0003f7d000ULL, 0x0000007e00c07306ULL, 0x000fe20000009400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x00000001b0b03812ULL, 0x000fe400078efcffULL,
0x0000007e00c17306ULL, 0x000e620000005400ULL, 0x000000c5c400720bULL, 0x000fe40003f7d000ULL,
0x000000adb07b723eULL, 0x000fca00000010ffULL, 0x0000008700be7306ULL, 0x000fe40000209400ULL,
0x0000007a2c3c723cULL, 0x080b68000004183cULL, 0x0000000102023812ULL, 0x000fe400078efcffULL,
0x0000008700bf7306ULL, 0x0004e20000205400ULL, 0x000000c1c000720bULL, 0x002fe20003f9d000ULL,
0x0000007a705c723cULL, 0x000b6c000004185cULL, 0x0000009000917306ULL, 0x000fe20000209400ULL,
0x0000009000877245ULL, 0x004fce000020d400ULL, 0x0000009000927306ULL, 0x000e620000205400ULL,
0x000000bfbe00720bULL, 0x008fce0003f5d000ULL, 0x0000007e00007306ULL, 0x0004ec000000d400ULL,
0x0000000188882812ULL, 0x000fe400078efcffULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x000100007e7e7824ULL, 0x004fe200078e00ffULL, 0x000000929100720bULL, 0x002fc80003fbd000ULL,
0x00000018ff8c7819ULL, 0x000fe4000001147eULL, 0x0000007d007e7245ULL, 0x000fe2000020d400ULL,
0x0000009500977306ULL, 0x0002a20000205400ULL, 0x0000000100004812ULL, 0x008fe400078efcffULL,
0x000000017e7e0812ULL, 0x000fe400078efcffULL, 0x0000008e8d00720bULL, 0x000fe40003f1d000ULL,
0x0000000187875812ULL, 0x000fe200078efcffULL, 0x0000002100c27306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x002fc4000020d400ULL, 0x000000c6008d7245ULL, 0x000fe4000020d400ULL,
0x0000007e7f7e723eULL, 0x000fe400000010ffULL, 0x00000027bc7d723eULL, 0x000fe200000010ffULL,
0x0000002100c37306ULL, 0x0002e20000205400ULL, 0x000126c81a277811ULL, 0x000fe400078e18ffULL,
0x000000018b8b0812ULL, 0x000fe400078efcffULL, 0x000000979600720bULL, 0x004fe20003f1d000ULL,
0x0000007c2c38723cULL, 0x000b620000041838ULL, 0x0000008b887f723eULL, 0x000fe200000010ffULL,
0x0000000600867306ULL, 0x000fe20000209400ULL, 0x0000002100217245ULL, 0x002fca000020d400ULL,
0x0000007e2c34723cULL, 0x000b640000041834ULL, 0x0000000600837306ULL, 0x0002a20000205400ULL,
0x000000c3c200720bULL, 0x008fe40003fdd000ULL, 0x0000000195950812ULL, 0x000fc600078efcffULL,
0x0000007c7058723cULL, 0x000b640000041858ULL, 0x0000008c00937306ULL, 0x000fe20000209400ULL,
0x0000000600067245ULL, 0x002fca000020d400ULL, 0x0000000121216812ULL, 0x000fe200078efcffULL,
0x0000007e7054723cULL, 0x000b620000041854ULL, 0x0000008c00947306ULL, 0x0002e20000205400ULL,
0x000000838600720bULL, 0x004fe40003f5d000ULL, 0x000000008786723eULL, 0x000fe200000010ffULL,
0x0000000220007824ULL, 0x000fe200078e00ffULL, 0x000000029587723eULL, 0x000fc600000010ffULL,
0x000000c6008a7306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x002fe4000020d400ULL,
0xfffffff800027812ULL, 0x000fe200078ec0ffULL, 0x000000862c30723cULL, 0x000b640000041830ULL,
0x0000000106062812ULL, 0x000fe400078efcffULL, 0x000000c600897306ULL, 0x000e620000205400ULL,
0x000000949300720bULL, 0x008fc60003fbd000ULL, 0x000000867050723cULL, 0x000b740000041850ULL,
0x000000018c8c5812ULL, 0x000fc400078efcffULL, 0x000000898a00720bULL, 0x002fe40003f9d000ULL,
0x0000008c218c723eULL, 0x000fd600000010ffULL, 0x000000018d8d4812ULL, 0x000fc800078efcffULL,
0x0000008d068d723eULL, 0x000fce00000010ffULL, 0x0000008c704c723cULL, 0x080b70000004184cULL,
0x0000008c2c2c723cULL, 0x000b620000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x00000000272a7f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126980002ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x0000040027097984ULL, 0x000e620000000800ULL, 0x000000031b027810ULL, 0x008fc40007ffe0ffULL,
0x8000000009ff7812ULL, 0x006fe2000780482bULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x000000ffff097224ULL, 0x000fe200078e0002ULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000828217210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e29ULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011409ULL,
0x0000002106067211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000206067819ULL, 0x000fc80000001209ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000100007810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000040027097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fc400078e0002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000116277810ULL, 0x000fe40007ffe0ffULL, 0x0000000318187810ULL, 0x000fe40007ffe0ffULL,
0x0000001c2700720cULL, 0x000fda0003f06070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x0000000216217810ULL, 0x000fe20007ffe0ffULL, 0x0000010027277824ULL, 0x000fe400078e0277ULL,
0x0000590024247a24ULL, 0x010fe200078e02ffULL, 0x0000001c2100720cULL, 0x000fe40003f06070ULL,
0x0000002027007812ULL, 0x000fe200078ec0ffULL, 0x0000004024247824ULL, 0x000fc800078e00ffULL,
0x0000000119707824ULL, 0x000fcc00078e0200ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x000000271e007217ULL, 0x000fe20007800000ULL, 0x0000001020027824ULL, 0x000fc800078e00ffULL,
0x0000000100007824ULL, 0x000fe200078e0a27ULL, 0x0000001002217812ULL, 0x000fe400078ec0ffULL,
0x00000003ff027819ULL, 0x000fe4000001161fULL, 0x0000000021007217ULL, 0x000fe40007800000ULL,
0x0000000402067810ULL, 0x040fe40007ffe0ffULL, 0x0000000802087810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x100fe200078e0a21ULL, 0x0000000c02277810ULL, 0x000fe20007ffe0ffULL,
0x00000001062a7824ULL, 0x000fc400078e0221ULL, 0x0000000108187824ULL, 0x100fe200078e0221ULL,
0x000000000200720cULL, 0x0c0fe20003f86070ULL, 0x0000000102027824ULL, 0x100fe200078e0221ULL,
0x000000000600720cULL, 0x080fe20003f66070ULL, 0x0000000127217824ULL, 0x040fe200078e0221ULL,
0x000000000800720cULL, 0x080fe20003f46070ULL, 0x0000000102067824ULL, 0x140fe200078e021fULL,
0x000000002700720cULL, 0x000fe20003f06070ULL, 0x0000000802297824ULL, 0x000fe400078e00ffULL,
0x000000012a087824ULL, 0x000fc400078e021fULL, 0x000000082a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff829067812ULL, 0x000fe200078ee206ULL, 0x0000000102287824ULL, 0x100fe400078e0270ULL,
0x000000012a2a7824ULL, 0x000fe200078e0270ULL, 0xfffffff82b087812ULL, 0x000fe200078ee208ULL,
0x00000001186c7824ULL, 0x100fe400078e0270ULL, 0x0000000121707824ULL, 0x040fe400078e0270ULL,
0x0000000121027824ULL, 0x000fc400078e021fULL, 0x0000000821217824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001228287212ULL, 0x000fc600078efcffULL, 0x0000000118007824ULL, 0x000fe200078e021fULL,
0x000000122a2a7212ULL, 0x000fe200078efcffULL, 0x0000000818277824ULL, 0x000fe200078e00ffULL,
0xfffffff821187812ULL, 0x000fe200078ee202ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000620024217a11ULL, 0x000fe400078a38ffULL, 0xfffffff827007812ULL, 0x000fe200078ee200ULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x0000630024277a11ULL, 0x000fe400028f3cffULL,
0x0000002821287210ULL, 0x000fe20007fbe0ffULL, 0x0000001008737824ULL, 0x100fe200078e0203ULL,
0x000000212a2a7210ULL, 0x080fe20007fde0ffULL, 0x0000001000797824ULL, 0x000fe200078e0203ULL,
0x000000126c027212ULL, 0x080fe200078efcffULL, 0x0000000129297824ULL, 0x100fe200028e0627ULL,
0x00000012706c7212ULL, 0x000fe200078efcffULL, 0x000000012b2b7824ULL, 0x000fe200030e0627ULL,
0x0000002102027210ULL, 0x080fe20007fbe0ffULL, 0x00000010187b7824ULL, 0x100fe200078e0203ULL,
0x000000216c6c7210ULL, 0x000fe20007fde0ffULL, 0x0000001006217824ULL, 0x000fc400078e0203ULL,
0x000000016d037824ULL, 0x100fe400028e0627ULL, 0x00000001716d7824ULL, 0x000fe200030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028217faeULL, 0x0003e8000e101c48ULL,
0x000000002a737faeULL, 0x0003e8000d901c48ULL, 0x0000000002797faeULL, 0x0003e8000d101c48ULL,
0x000000006c7b7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001020007824ULL, 0x000fca00078e00ffULL, 0x0000001000007812ULL, 0x000fc800078ec0ffULL,
0x000000001f007211ULL, 0x000fc800078fe8ffULL, 0x0000000400087810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x140fe200078e021fULL, 0x0000000c00187810ULL, 0x040fe20007ffe0ffULL,
0x0000000800217824ULL, 0x040fe400078e00ffULL, 0x0000000100287824ULL, 0x100fe400078e0270ULL,
0x00000001082a7824ULL, 0x040fe200078e0270ULL, 0xfffffff821067812ULL, 0x000fe200078ee202ULL,
0x0000000808217824ULL, 0x000fe200078e00ffULL, 0x0000000800027810ULL, 0x000fe20007ffe0ffULL,
0x0000000108007824ULL, 0x000fc400078e021fULL, 0x00000008182b7824ULL, 0x000fe400078e00ffULL,
0x00000001026c7824ULL, 0x040fe200078e0270ULL, 0xfffffff821007812ULL, 0x000fe200078ee200ULL,
0x0000000102087824ULL, 0x100fe200078e021fULL, 0x0000620024217a11ULL, 0x000fe200078038ffULL,
0x0000000802277824ULL, 0x000fe400078e00ffULL, 0x0000000118027824ULL, 0x000fe400078e021fULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0xfffffff827087812ULL, 0x000fc400078ee208ULL,
0x0000630024277a11ULL, 0x000fe200000f3cffULL, 0x0000000118707824ULL, 0x000fe200078e0270ULL,
0xfffffff82b187812ULL, 0x000fe200078ee202ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001228287212ULL, 0x000fc600078efcffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002821287210ULL, 0x000fe40007f1e0ffULL, 0x000000122a027212ULL, 0x080fe200078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000126c2a7212ULL, 0x000fc600078efcffULL,
0x0000000129297824ULL, 0x000fe200000e0627ULL, 0x00000012706c7212ULL, 0x000fe200078efcffULL,
0x0000001000737824ULL, 0x100fe200078e0203ULL, 0x0000000221027210ULL, 0x040fe20007f1e0ffULL,
0x0000001008797824ULL, 0x100fe200078e0203ULL, 0x0000002a212a7210ULL, 0x040fe20007f5e0ffULL,
0x00000010187b7824ULL, 0x100fe200078e0203ULL, 0x0000006c216c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001006217824ULL, 0x000fe400078e0203ULL, 0x000000012b037824ULL, 0x000fc400000e0627ULL,
0x000000016d2b7824ULL, 0x100fe200010e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028217faeULL, 0x0003e2000b901c48ULL, 0x00000001716d7824ULL, 0x000fc600018e0627ULL,
0x0000000002737faeULL, 0x0003e8000b901c48ULL, 0x000000002a797faeULL, 0x0003e8000b901c48ULL,
0x000000006c7b7faeULL, 0x0003e4000b901c48ULL, 0x0000000414187810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000001d1800720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000117027824ULL, 0x002fe400078e0218ULL, 0x00000004ff037424ULL, 0x000fc800078e00ffULL,
0x0000640002027625ULL, 0x000fca00078e0003ULL, 0x0000000802247981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000820027824ULL, 0x002fe400078e00ffULL,
0x000000201b007824ULL, 0x000fc600078e0215ULL, 0xfffffff002037812ULL, 0x040fe400078ec0ffULL,
0x0000000802217812ULL, 0x000fe400078ec0ffULL, 0x00000000030473c2ULL, 0x000e6600000e0000ULL,
0x0000000121067824ULL, 0x000fe400078e0200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000126a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126a80003027f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01266800062a7f8cULL, 0x0004e2000c80043fULL, 0x000000ffff007224ULL, 0x002fc600078e0003ULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01266c0006217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x00afe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002802217210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e03ULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011428ULL, 0x0000002108087211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0628ULL, 0x0000000208087819ULL, 0x000fc80000001221ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c0006217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008009027824ULL, 0x000fc800078e0212ULL,
0x0000000111027824ULL, 0x000fca00078e0202ULL, 0x0120000002147984ULL, 0x000e680000000800ULL,
0x0122000002037984ULL, 0x0006a20000000800ULL, 0x000000231400720bULL, 0x002fe20003f1d000ULL,
0x0000def27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000067806ULL, 0x00cfc800000e0100ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fd200078e0023ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000200900720cULL, 0x000fe40003f05270ULL,
0x000000231400720bULL, 0x000fe20003f54000ULL, 0x0000deb27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000217806ULL, 0x000fc400010e0100ULL, 0x0000008020128824ULL, 0x000fe200078e0212ULL,
0x0000002314027209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000111118824ULL, 0x000fca00078e0212ULL, 0x0124000211008388ULL, 0x0003e20000000800ULL,
0x000000ff2100720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000002302117221ULL, 0x002fe20000010100ULL, 0x000000ff21ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b11117820ULL, 0x000fcc0000410000ULL,
0x0000001100117308ULL, 0x000e640000000800ULL, 0x0000001122227220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161fULL,
0x0000ddf27f007947ULL, 0x000fea000b800000ULL, 0x00001f2911287589ULL, 0x0002a400000e0000ULL,
0x0000002868687220ULL, 0x084fe20000410000ULL, 0x0000002869697220ULL, 0x080fe20000410000ULL,
0x0000002864647220ULL, 0x080fe20000410000ULL, 0x0000002865657220ULL, 0x080fe20000410000ULL,
0x0000002860607220ULL, 0x080fe20000410000ULL, 0x0000002861617220ULL, 0x080fe20000410000ULL,
0x000000285c5c7220ULL, 0x080fe20000410000ULL, 0x000000285d5d7220ULL, 0x080fe20000410000ULL,
0x0000002858587220ULL, 0x080fe20000410000ULL, 0x0000002859597220ULL, 0x080fe20000410000ULL,
0x0000002854547220ULL, 0x080fe20000410000ULL, 0x0000002855557220ULL, 0x080fe20000410000ULL,
0x0000002850507220ULL, 0x080fe20000410000ULL, 0x0000002851517220ULL, 0x080fe20000410000ULL,
0x000000284c4c7220ULL, 0x080fe20000410000ULL, 0x000000284d4d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0021ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081f297811ULL, 0x002fe200078ff0ffULL, 0x0000dcc27f007947ULL, 0x000fea000b800000ULL,
0x00001f2911287589ULL, 0x0002a400000e0000ULL, 0x000000286a6a7220ULL, 0x084fe20000410000ULL,
0x000000286b6b7220ULL, 0x080fe20000410000ULL, 0x0000002866667220ULL, 0x080fe20000410000ULL,
0x0000002867677220ULL, 0x080fe20000410000ULL, 0x0000002862627220ULL, 0x080fe20000410000ULL,
0x0000002863637220ULL, 0x080fe20000410000ULL, 0x000000285e5e7220ULL, 0x080fe20000410000ULL,
0x000000285f5f7220ULL, 0x080fe20000410000ULL, 0x000000285a5a7220ULL, 0x080fe20000410000ULL,
0x000000285b5b7220ULL, 0x080fe20000410000ULL, 0x0000002856567220ULL, 0x080fe20000410000ULL,
0x0000002857577220ULL, 0x080fe20000410000ULL, 0x0000002852527220ULL, 0x080fe20000410000ULL,
0x0000002853537220ULL, 0x080fe20000410000ULL, 0x000000284e4e7220ULL, 0x080fe20000410000ULL,
0x000000284f4f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000021ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101f297811ULL, 0x002fe200078ff0ffULL,
0x0000db927f007947ULL, 0x000fea000b800000ULL, 0x00001f2911287589ULL, 0x0002a400000e0000ULL,
0x0000002848487220ULL, 0x084fe20000410000ULL, 0x0000002849497220ULL, 0x080fe20000410000ULL,
0x0000002844447220ULL, 0x080fe20000410000ULL, 0x0000002845457220ULL, 0x080fe20000410000ULL,
0x0000002840407220ULL, 0x080fe20000410000ULL, 0x0000002841417220ULL, 0x080fe20000410000ULL,
0x000000283c3c7220ULL, 0x080fe20000410000ULL, 0x000000283d3d7220ULL, 0x080fe20000410000ULL,
0x0000002838387220ULL, 0x080fe20000410000ULL, 0x0000002839397220ULL, 0x080fe20000410000ULL,
0x0000002834347220ULL, 0x080fe20000410000ULL, 0x0000002835357220ULL, 0x080fe20000410000ULL,
0x0000002830307220ULL, 0x080fe20000410000ULL, 0x0000002831317220ULL, 0x080fe20000410000ULL,
0x000000282c2c7220ULL, 0x080fe20000410000ULL, 0x000000282d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000021ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181f297811ULL, 0x002fe200078ff0ffULL,
0x0000da727f007947ULL, 0x000fea000b800000ULL, 0x00001f2911287589ULL, 0x0002a400000e0000ULL,
0x000000284a4a7220ULL, 0x084fe20000410000ULL, 0x000000284b4b7220ULL, 0x080fe20000410000ULL,
0x0000002846467220ULL, 0x080fe20000410000ULL, 0x0000002847477220ULL, 0x080fe20000410000ULL,
0x0000002842427220ULL, 0x080fe20000410000ULL, 0x0000002843437220ULL, 0x080fe20000410000ULL,
0x000000283e3e7220ULL, 0x080fe20000410000ULL, 0x000000283f3f7220ULL, 0x080fe20000410000ULL,
0x000000283a3a7220ULL, 0x080fe20000410000ULL, 0x000000283b3b7220ULL, 0x080fe20000410000ULL,
0x0000002836367220ULL, 0x080fe20000410000ULL, 0x0000002837377220ULL, 0x080fe20000410000ULL,
0x0000002832327220ULL, 0x080fe20000410000ULL, 0x0000002833337220ULL, 0x080fe20000410000ULL,
0x000000282e2e7220ULL, 0x080fe20000410000ULL, 0x000000282f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000002106ff7212ULL, 0x000fda00078030ffULL,
0x0000001402060221ULL, 0x000fe20000010100ULL, 0x00007610ff080816ULL, 0x000fc60000000008ULL,
0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL, 0x0000000600100308ULL, 0x000e640000000800ULL,
0x0000001003030220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002203227221ULL, 0x000fe20000010000ULL, 0x000000011a037812ULL, 0x000fc400078ec0ffULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0000000820067824ULL, 0x000fca00078e00ffULL,
0xfffffff006127812ULL, 0x000fca00078ec0ffULL, 0x0126b40012117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a28117210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2a7824ULL, 0x000fe200000e0e29ULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc8000001142aULL, 0x0000001106067211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e062aULL, 0x0000000206067819ULL, 0x000fc80000001211ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b40012117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991008067816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000010ff06723eULL, 0x000fe400000010ffULL,
0x00000002ff117819ULL, 0x000fe4000001161fULL, 0x0000541006067816ULL, 0x000fe20000000006ULL,
0x0000d6327f007947ULL, 0x000fea000b800000ULL, 0x00001f11060f7589ULL, 0x0002a400000e0000ULL,
0x0000000811297810ULL, 0x002fe20007ffe0ffULL, 0x0000d6627f007947ULL, 0x000fea000b800000ULL,
0x00000010110d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f29060e7589ULL, 0x0002ea00000e0000ULL,
0x00001f0d060d7589ULL, 0x0002a400000e0000ULL, 0x0000001811297810ULL, 0x002fe20007ffe0ffULL,
0x0000d6b27f007947ULL, 0x000fea000b800000ULL, 0x00001f29060c7589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff067819ULL, 0x002fe2000001161fULL,
0x000000080b117824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000420087824ULL, 0x000fe200078e00ffULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x0000000403037824ULL, 0x000fc400078e0206ULL, 0x000000080a127824ULL, 0x000fe200078e00ffULL,
0x0000000408087812ULL, 0x000fe200078ec0ffULL, 0x000000010b067824ULL, 0x100fe400078e0203ULL,
0x000000010a037824ULL, 0x000fe200078e0203ULL, 0x0000000208087812ULL, 0x000fe200078efcffULL,
0x0000001007707824ULL, 0x000fe200078e0225ULL, 0xfffffff811117812ULL, 0x000fe400078ee206ULL,
0x0000a00009067811ULL, 0x000fe400078e60ffULL, 0xfffffff812097812ULL, 0x000fc400078ee203ULL,
0x000000081f037211ULL, 0x000fe200078fe0ffULL, 0x0000001011117824ULL, 0x100fe400078e0206ULL,
0x0000001009097824ULL, 0x000fe400078e0206ULL, 0x000000080b087824ULL, 0x040fe200078e00ffULL,
0x00000000116c783bULL, 0x0002e20000000200ULL, 0x000000010b0b7824ULL, 0x000fc600078e0203ULL,
0x000000000928783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7231ULL, 0x08cfe400003400ffULL, 0x0000000f6e6e7231ULL, 0x000fe400003400ffULL,
0x0000000e6d6d7231ULL, 0x080fe400003400ffULL, 0x0000000e6f6f7231ULL, 0x000fe400003400ffULL,
0x0000000d28287231ULL, 0x080fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fc400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0xfffffff808087812ULL, 0x000fe200078ee20bULL, 0x0000001004047824ULL, 0x000fe200078e0206ULL,
0x00000fa000007945ULL, 0x000fe20003800000ULL, 0x000000010a037824ULL, 0x000fe400078e0203ULL,
0x0000001008087824ULL, 0x000fca00078e0225ULL, 0x000000000878783bULL, 0x000ee20000004200ULL,
0x0000010070817824ULL, 0x002fe200078e00ffULL, 0x00000070007e7306ULL, 0x000fe20000009400ULL,
0x00000018ff877819ULL, 0x000fe20000011470ULL, 0x0000010071857824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe40000011471ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff8d7819ULL, 0x000fe20000011485ULL, 0x00000070007f7306ULL, 0x000e620000005400ULL,
0x00000018ff9f7819ULL, 0x000fc40000011472ULL, 0x00000018ffaa7819ULL, 0x000fe40000011473ULL,
0x00000018ffb27819ULL, 0x008fe40000011478ULL, 0x00000018ff277819ULL, 0x000fe20000011479ULL,
0x0000008100837306ULL, 0x000fe20000209400ULL, 0x00000018ff0b7819ULL, 0x000fe4000001147aULL,
0x00000018ff097819ULL, 0x000fca000001147bULL, 0x0000008100847306ULL, 0x0006a20000205400ULL,
0x0000007f7e00720bULL, 0x002fce0003f9d000ULL, 0x0000007000807306ULL, 0x0002a2000000d400ULL,
0x0000008100817245ULL, 0x008fce000020d400ULL, 0x00000071008a7306ULL, 0x000fe20000009400ULL,
0x0001000070707824ULL, 0x002fe200078e00ffULL, 0x000000848300720bULL, 0x004fe20003fdd000ULL,
0x000001007a847824ULL, 0x000fc600078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000071008b7306ULL, 0x000e620000005400ULL, 0x0000000180804812ULL, 0x000fcc00078efcffULL,
0x0000000181816812ULL, 0x000fe200078efcffULL, 0x00000071008c7306ULL, 0x0004f0000000d400ULL,
0x0000008700887306ULL, 0x000fe20000209400ULL, 0x0001000071717824ULL, 0x004fe200078e00ffULL,
0x0000008b8a00720bULL, 0x002fe20003f5d000ULL, 0x000100007a8a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011471ULL, 0x0000010072717824ULL, 0x000fe200078e00ffULL,
0x0000008700897306ULL, 0x0002a20000205400ULL, 0x00000018ff8a7819ULL, 0x000fc6000001148aULL,
0x00000018ff997819ULL, 0x000fe20000011471ULL, 0x0000010073717824ULL, 0x000fe400078e00ffULL,
0x000000018c8c2812ULL, 0x008fe200078efcffULL, 0x0000007000857306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fe4000020d400ULL, 0x00000018ffa47819ULL, 0x000fe20000011471ULL,
0x0000010078717824ULL, 0x000fc800078e00ffULL, 0x0000007000867306ULL, 0x000e620000205400ULL,
0x000000898800720bULL, 0x004fe40003fbd000ULL, 0x00000018ffaf7819ULL, 0x000fe20000011471ULL,
0x0000010079717824ULL, 0x000fc800078e00ffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x00000018ffb77819ULL, 0x000fe40000011471ULL, 0x0000008d00717245ULL, 0x000fc6000020d400ULL,
0x0000000187875812ULL, 0x000fe400078efcffULL, 0x0000009300957306ULL, 0x000ea20000205400ULL,
0x000000868500720bULL, 0x002fe40003fdd000ULL, 0x00000018ff867819ULL, 0x000fe40000011484ULL,
0x000000b700847245ULL, 0x000fc6000020d400ULL, 0x0000007200967306ULL, 0x000ff00000009400ULL,
0x0000007200977306ULL, 0x000e620000005400ULL, 0x000000959400720bULL, 0x004fce0003f5d000ULL,
0x0000007200987306ULL, 0x0004f0000000d400ULL, 0x00000099009a7306ULL, 0x000fe20000209400ULL,
0x0001000072727824ULL, 0x004fe200078e00ffULL, 0x000000979600720bULL, 0x002fc80003f9d000ULL,
0x00000018ff9c7819ULL, 0x000fe20000011472ULL, 0x0001000079727824ULL, 0x000fe200078e00ffULL,
0x00000099009b7306ULL, 0x0002a80000205400ULL, 0x00000018ff857819ULL, 0x000fe40000011472ULL,
0x0000007000727245ULL, 0x000fe4000020d400ULL, 0x000000a400a57306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fc4000020d400ULL, 0x0000000172726812ULL, 0x000fe400078efcffULL,
0x0000000198984812ULL, 0x008fe400078efcffULL, 0x000000728772723eULL, 0x000fe200000010ffULL,
0x000000a400a67306ULL, 0x0002e20000205400ULL, 0x0000009b9a00720bULL, 0x004fce0003fdd000ULL,
0x0000007300a27306ULL, 0x000fe20000009400ULL, 0x000000a400a47245ULL, 0x002fca000020d400ULL,
0x0000000199996812ULL, 0x000fe400078efcffULL, 0x0000007300a37306ULL, 0x000fe20000005400ULL,
0x000000a6a500720bULL, 0x008fce0003fbd000ULL, 0x00000073007d7306ULL, 0x0003ec000000d400ULL,
0x00000001a4a45812ULL, 0x000fe400078efcffULL, 0x0000009c009d7306ULL, 0x000fe20000209400ULL,
0x0001000073737824ULL, 0x002fca00078e00ffULL, 0x00000018ffa77819ULL, 0x000fe40000011473ULL,
0x0000009c009e7306ULL, 0x000fe20000205400ULL, 0x0000009000737245ULL, 0x000fce000020d400ULL,
0x0000009f00a07306ULL, 0x000ff00000209400ULL, 0x0000009f00a17306ULL, 0x0002b00000205400ULL,
0x0000008d008e7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fce000020d400ULL,
0x0000008d008f7306ULL, 0x000e620000205400ULL, 0x000000a1a000720bULL, 0x004fce0003fdd000ULL,
0x000000a700a87306ULL, 0x000fec0000209400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000a700a97306ULL, 0x000ea20000205400ULL, 0x0000008f8e00720bULL, 0x002fe20003f7d000ULL,
0x000001007b8e7824ULL, 0x000fc400078e00ffULL, 0x000100007b8f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001148eULL, 0x0000007800ad7306ULL, 0x000fe20000009400ULL,
0x00000018ff8f7819ULL, 0x000fca000001148fULL, 0x0000000171713812ULL, 0x000fe400078efcffULL,
0x0000007800ae7306ULL, 0x000fe20000005400ULL, 0x000000a9a800720bULL, 0x004fe40003fbd000ULL,
0x0000008c7171723eULL, 0x000fca00000010ffULL, 0x0000007800127306ULL, 0x0003f0000000d400ULL,
0x0000007900b57306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x002fce00078e00ffULL,
0x0000007900b67306ULL, 0x000ff00000005400ULL, 0x0000007900117306ULL, 0x0003f0000000d400ULL,
0x0000009000917306ULL, 0x000fe20000209400ULL, 0x00000018ff797819ULL, 0x002fc40000011478ULL,
0x0000009300787245ULL, 0x000fc8000020d400ULL, 0x0000000178782812ULL, 0x000fe200078efcffULL,
0x0000009000927306ULL, 0x000e620000205400ULL, 0x0000009e9d00720bULL, 0x000fce0003f5d000ULL,
0x000000b700b87306ULL, 0x000ff00000209400ULL, 0x000000b700837306ULL, 0x000ea20000205400ULL,
0x000000929100720bULL, 0x002fce0003f7d000ULL, 0x0000007a00bb7306ULL, 0x000fec0000009400ULL,
0x0000000173733812ULL, 0x000fe400078efcffULL, 0x0000007a00bc7306ULL, 0x000fe20000005400ULL,
0x00000083b800720bULL, 0x004fe40003fdd000ULL, 0x000000a3a200720bULL, 0x000fc40003f7d000ULL,
0x000000737873723eULL, 0x000fe400000010ffULL, 0x000000989978723eULL, 0x000fe200000010ffULL,
0x0000007a00087306ULL, 0x0003e8000000d400ULL, 0x000000726c64723cULL, 0x000b640000041864ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x0000007b00bd7306ULL, 0x000fe20000009400ULL,
0x0000009c007a7245ULL, 0x002fc4000020d400ULL, 0x000000017d7d3812ULL, 0x000fe200078efcffULL,
0x000000722844723cULL, 0x000b620000041844ULL, 0x000000017a7a2812ULL, 0x000fe400078efcffULL,
0x000000aead00720bULL, 0x000fe20003f5d000ULL, 0x0000007b00be7306ULL, 0x000fe20000005400ULL,
0x0000007a9f7a723eULL, 0x000fce00000010ffULL, 0x0000007b00077306ULL, 0x0003e8000000d400ULL,
0x0000000112122812ULL, 0x000fc800078efcffULL, 0x000000b200b37306ULL, 0x000fe20000209400ULL,
0x000000a7007b7245ULL, 0x002fc8000020d400ULL, 0x000000017b7b5812ULL, 0x000fe400078efcffULL,
0x000000b6b500720bULL, 0x000fe20003fbd000ULL, 0x000000b200b47306ULL, 0x000e700000205400ULL,
0x000000aa00ab7306ULL, 0x000fe80000209400ULL, 0x0000000111115812ULL, 0x000fc800078efcffULL,
0x000000aa00ac7306ULL, 0x0004e20000205400ULL, 0x000000b4b300720bULL, 0x002fce0003f5d000ULL,
0x00000079007e7306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x004fce000020d400ULL,
0x00000079007f7306ULL, 0x000e620000205400ULL, 0x000000acab00720bULL, 0x008fce0003f9d000ULL,
0x0000008500707306ULL, 0x000fec0000209400ULL, 0x00000001aaaa4812ULL, 0x000fe400078efcffULL,
0x0000008500897306ULL, 0x0004e20000205400ULL, 0x0000007f7e00720bULL, 0x002fe40003fdd000ULL,
0x000000b2007f7245ULL, 0x000fc4000020d400ULL, 0x00000079007e7245ULL, 0x000fe4000020d400ULL,
0x000000017f7f2812ULL, 0x000fe200078efcffULL, 0x0000008600887306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x004fe4000020d400ULL, 0x000000bcbb00720bULL, 0x000fe40003f9d000ULL,
0x0000007da479723eULL, 0x000fe400000010ffULL, 0x000000017e7e6812ULL, 0x000fe200078efcffULL,
0x00000086008b7306ULL, 0x000e620000205400ULL, 0x000000897000720bULL, 0x008fc40003fbd000ULL,
0x000000808170723eULL, 0x000fe200000010ffULL, 0x000000786c60723cULL, 0x040b620000041860ULL,
0x0000002700807245ULL, 0x000fe4000020d400ULL, 0x0000007e7f7e723eULL, 0x000fe200000010ffULL,
0x0000002700b97306ULL, 0x000fe20000209400ULL, 0x0000000108084812ULL, 0x000fe400078efcffULL,
0x0000007baa7b723eULL, 0x000fe200000010ffULL, 0x000000706c68723cULL, 0x000b620000041868ULL,
0x00000011847d723eULL, 0x000fc400000010ffULL, 0x0000000185855812ULL, 0x000fe200078efcffULL,
0x0000002700ba7306ULL, 0x0004e20000205400ULL, 0x0000008b8800720bULL, 0x002fe40003f5d000ULL,
0x0000008f008b7245ULL, 0x000fe2000020d400ULL, 0x0000007a6c5c723cULL, 0x000b68000004185cULL,
0x000000af00b07306ULL, 0x000fe20000209400ULL, 0x0000008600277245ULL, 0x004fc6000020d400ULL,
0x000000702848723cULL, 0x000b640000041848ULL, 0x0000000127272812ULL, 0x000fe400078efcffULL,
0x000000af00b17306ULL, 0x0002a20000205400ULL, 0x000000bab900720bULL, 0x008fc60003fdd000ULL,
0x000000782840723cULL, 0x000b680000041840ULL, 0x0000008e008d7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fc6000020d400ULL, 0x0000007a283c723cULL, 0x000b64000004183cULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x0000008e00907306ULL, 0x0002e20000205400ULL,
0x000000b1b000720bULL, 0x004fe40003f7d000ULL, 0x00000085807f723eULL, 0x000fe400000010ffULL,
0x000000082780723eULL, 0x000fe400000010ffULL, 0x0000000900087245ULL, 0x000fe2000020d400ULL,
0x0000000b00147306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x002fe2000020d400ULL,
0x0000007e6c54723cULL, 0x000b680000041854ULL, 0x00000001afaf3812ULL, 0x000fc400078efcffULL,
0x0000000b00237306ULL, 0x0002a20000205400ULL, 0x000000908d00720bULL, 0x008fe20003fbd000ULL,
0x0000007e2834723cULL, 0x000b620000041834ULL, 0x000000bebd00720bULL, 0x000fca0003f7d000ULL,
0x00000009007c7306ULL, 0x000fe20000209400ULL, 0x0000000b000b7245ULL, 0x002fca000020d400ULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x0000000900217306ULL, 0x000e620000205400ULL,
0x000000231400720bULL, 0x004fe40003fdd000ULL, 0x0000000107073812ULL, 0x000fca00078efcffULL,
0x0000008a00837306ULL, 0x000fec0000209400ULL, 0x000000010b0b6812ULL, 0x000fe400078efcffULL,
0x0000008a008c7306ULL, 0x0004e20000205400ULL, 0x000000217c00720bULL, 0x002fe40003f5d000ULL,
0x00000012af7c723eULL, 0x000fe200000010ffULL, 0x000000080a127824ULL, 0x000fc800078e00ffULL,
0x0000008f00817306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x004fe2000020d400ULL,
0x0000007c6c58723cULL, 0x080b680000041858ULL, 0x0000000108082812ULL, 0x000fe400078efcffULL,
0x0000008f00887306ULL, 0x000e620000205400ULL, 0x0000008c8300720bULL, 0x008fe20003f9d000ULL,
0x0000007c2838723cULL, 0x000b580000041838ULL, 0x000000018a8a4812ULL, 0x000fe400078efcffULL,
0x000000888100720bULL, 0x002fe40003fbd000ULL, 0x000000078e81723eULL, 0x000fe400000010ffULL,
0x0000008a0b8a723eULL, 0x000fca00000010ffULL, 0x000000806c50723cULL, 0x000b680000041850ULL,
0x000000018b8b5812ULL, 0x000fc800078efcffULL, 0x0000008b088b723eULL, 0x000fe200000010ffULL,
0x0000001005087824ULL, 0x000fe200078e0206ULL, 0x000000802830723cULL, 0x000b620000041830ULL,
0x000000000404783bULL, 0x000e680000000200ULL, 0x000000000808783bULL, 0x000ea60000000200ULL,
0x0000008a6c4c723cULL, 0x080b70000004184cULL, 0x0000008a282c723cULL, 0x000b62000004182cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f08087231ULL, 0x084fe400003400ffULL, 0x0000000f0a0a7231ULL, 0x000fc400003400ffULL,
0x0000000e09097231ULL, 0x080fe400003400ffULL, 0x0000000e0b0b7231ULL, 0x000fe400003400ffULL,
0x0000000d04047231ULL, 0x082fe400003400ffULL, 0x0000000d06067231ULL, 0x000fe400003400ffULL,
0x0000000c05057231ULL, 0x080fe400003400ffULL, 0x0000000c07077231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000002628783bULL, 0x020ee20000004200ULL,
0xfffffff812127812ULL, 0x000fca00078ee203ULL, 0x0000001012127824ULL, 0x000fca00078e0225ULL,
0x00000000126c783bULL, 0x000ea20000004200ULL, 0x0000010028267824ULL, 0x008fe200078e00ffULL,
0x0000002800277306ULL, 0x000fe20000009400ULL, 0x0000010029797824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe20000011428ULL, 0x000001002a8d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x000001002b907824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe40000011479ULL, 0x0000002600737306ULL, 0x000fe20000209400ULL,
0x00000018ff877819ULL, 0x000fc40000011429ULL, 0x00000018ff937819ULL, 0x000fe4000001142aULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff997819ULL, 0x000fe20000011490ULL,
0x0000002600787306ULL, 0x0006620000205400ULL, 0x00000018ffa77819ULL, 0x004fe4000001146cULL,
0x00000018ff9f7819ULL, 0x000fe4000001142bULL, 0x00000018ffae7819ULL, 0x000fc4000001146dULL,
0x00000018ff147819ULL, 0x000fe2000001146eULL, 0x0000002800727306ULL, 0x000ea20000005400ULL,
0x0000002600267245ULL, 0x008fe4000020d400ULL, 0x00000018ff037819ULL, 0x000fca000001146fULL,
0x0000002800717306ULL, 0x0006a2000000d400ULL, 0x000000787300720bULL, 0x002fce0003f5d000ULL,
0x0000008100837306ULL, 0x000fe20000209400ULL, 0x0001000028287824ULL, 0x008fe200078e00ffULL,
0x000000722700720bULL, 0x004fe40003fbd000ULL, 0x0000008100277245ULL, 0x000fe4000020d400ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000008100847306ULL, 0x000e620000205400ULL,
0x0000000126262812ULL, 0x000fcc00078efcffULL, 0x0000000171715812ULL, 0x000fe200078efcffULL,
0x00000029007e7306ULL, 0x000fe60000009400ULL, 0x000000712626723eULL, 0x000fca00000010ffULL,
0x00000029007f7306ULL, 0x000ea20000005400ULL, 0x000000848300720bULL, 0x002fe20003f1d000ULL,
0x000001006f837824ULL, 0x040fe400078e00ffULL, 0x000100006f847824ULL, 0x000fc600078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0000002900807306ULL, 0x0002e2000000d400ULL,
0x00000018ff847819ULL, 0x000fca0000011484ULL, 0x0000000127270812ULL, 0x000fe400078efcffULL,
0x0000002800797306ULL, 0x000fe20000209400ULL, 0x0001000029297824ULL, 0x002fe200078e00ffULL,
0x0000007f7e00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000028007a7306ULL, 0x0002ae0000205400ULL, 0x0000000180806812ULL, 0x008fe200078efcffULL,
0x0000002900857306ULL, 0x000fe20000209400ULL, 0x0000002800287245ULL, 0x002fc4000020d400ULL,
0x000000802727723eULL, 0x000fca00000010ffULL, 0x0000002900867306ULL, 0x0002e20000205400ULL,
0x0000007a7900720bULL, 0x004fe20003f5d000ULL, 0x000000260868723cULL, 0x080b6c0000041868ULL,
0x0000002a008a7306ULL, 0x000fe20000009400ULL, 0x0000002900297245ULL, 0x002fe2000020d400ULL,
0x000000260448723cULL, 0x000b680000041848ULL, 0x0000000128282812ULL, 0x000fc400078efcffULL,
0x0000002a008b7306ULL, 0x000e620000005400ULL, 0x000000868500720bULL, 0x008fce0003f1d000ULL,
0x0000002a008c7306ULL, 0x0004ec000000d400ULL, 0x0000000129290812ULL, 0x000fe400078efcffULL,
0x0000008d008e7306ULL, 0x000fe20000209400ULL, 0x000100002a2a7824ULL, 0x004fe200078e00ffULL,
0x0000008b8a00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff907819ULL, 0x000fe2000001142aULL,
0x000001006c2a7824ULL, 0x000fe200078e00ffULL, 0x0000008d008f7306ULL, 0x0002a80000205400ULL,
0x00000018ffa47819ULL, 0x000fe2000001142aULL, 0x000001006d2a7824ULL, 0x000fe400078e00ffULL,
0x000000018c8c3812ULL, 0x008fe200078efcffULL, 0x0000002b00967306ULL, 0x000fe20000009400ULL,
0x0000008d008d7245ULL, 0x002fc4000020d400ULL, 0x00000018ffac7819ULL, 0x000fe2000001142aULL,
0x000100006d2a7824ULL, 0x000fc800078e00ffULL, 0x0000002b00977306ULL, 0x000e620000005400ULL,
0x0000008f8e00720bULL, 0x004fe40003f5d000ULL, 0x00000018ff737819ULL, 0x000fe4000001142aULL,
0x00000087002a7245ULL, 0x000fc6000020d400ULL, 0x0000007b007c7306ULL, 0x000fec0000209400ULL,
0x000000018d8d2812ULL, 0x000fe400078efcffULL, 0x0000007b007d7306ULL, 0x0004e20000205400ULL,
0x000000979600720bULL, 0x002fce0003fbd000ULL, 0x0000006c00a27306ULL, 0x000fe20000009400ULL,
0x0000007b007b7245ULL, 0x004fce000020d400ULL, 0x0000006c00a37306ULL, 0x000e620000005400ULL,
0x0000007d7c00720bULL, 0x008fce0003f9d000ULL, 0x0000006c00257306ULL, 0x0005ec000000d400ULL,
0x000000017b7b4812ULL, 0x000fe400078efcffULL, 0x0000002b00987306ULL, 0x0006e2000000d400ULL,
0x000100006c6c7824ULL, 0x004fe200078e00ffULL, 0x000000a3a200720bULL, 0x002fc40003f1d000ULL,
0x000000287b28723eULL, 0x000fc800000010ffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x000100002b2b7824ULL, 0x008fca00078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe2000001142bULL,
0x000001006e2b7824ULL, 0x000fe200078e00ffULL, 0x0000009300957306ULL, 0x0002a20000205400ULL,
0x0000000198985812ULL, 0x000fe400078efcffULL, 0x0000000125250812ULL, 0x000fe400078efcffULL,
0x00000018ff7a7819ULL, 0x000fe4000001142bULL, 0x00000099002b7245ULL, 0x000fe2000020d400ULL,
0x0000006d00aa7306ULL, 0x000fe20000009400ULL, 0x0000009300937245ULL, 0x002fc4000020d400ULL,
0x0000007a00717245ULL, 0x000fca000020d400ULL, 0x0000006d00ab7306ULL, 0x000fe20000005400ULL,
0x000000959400720bULL, 0x004fce0003f5d000ULL, 0x0000006d00217306ULL, 0x0003ec000000d400ULL,
0x0000000193932812ULL, 0x000fe400078efcffULL, 0x0000008700887306ULL, 0x000fe20000209400ULL,
0x00000018ff6d7819ULL, 0x002fe2000001146cULL, 0x000100006e6c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001146cULL, 0x0000008700897306ULL, 0x000e620000205400ULL,
0x0000009f006c7245ULL, 0x000fce000020d400ULL, 0x00000099009a7306ULL, 0x000ff00000209400ULL,
0x00000099009b7306ULL, 0x000ea20000205400ULL, 0x000000898800720bULL, 0x002fce0003fdd000ULL,
0x000000a400a57306ULL, 0x000fec0000209400ULL, 0x000000012a2a6812ULL, 0x000fe400078efcffULL,
0x000000a400a67306ULL, 0x0002e20000205400ULL, 0x0000009b9a00720bULL, 0x004fe40003f9d000ULL,
0x000000292a29723eULL, 0x000fc400000010ffULL, 0x0000008c8d2a723eULL, 0x000fc600000010ffULL,
0x0000006e00b17306ULL, 0x000fe20000009400ULL, 0x000000a400a47245ULL, 0x002fe2000020d400ULL,
0x000000280864723cULL, 0x080b680000041864ULL, 0x000000012b2b4812ULL, 0x000fe400078efcffULL,
0x0000006e00b27306ULL, 0x000fe20000005400ULL, 0x000000a6a500720bULL, 0x008fe20003fbd000ULL,
0x000000280444723cULL, 0x000b620000041844ULL, 0x000000982b2b723eULL, 0x000fca00000010ffULL,
0x0000006e00127306ULL, 0x000fe4000000d400ULL, 0x0000002a0860723cULL, 0x080b680000041860ULL,
0x00000001a4a45812ULL, 0x000fe400078efcffULL, 0x0000006f00b57306ULL, 0x000fe40000009400ULL,
0x00000025a4a4723eULL, 0x000fe200000010ffULL, 0x0000002a0440723cULL, 0x000b6a0000041840ULL,
0x0000006f00b67306ULL, 0x000ff00000005400ULL, 0x0000006f00117306ULL, 0x000ff0000000d400ULL,
0x0000006d006e7306ULL, 0x000ff00000209400ULL, 0x0000006d006f7306ULL, 0x0002b00000205400ULL,
0x000000ac00ad7306ULL, 0x000fe20000209400ULL, 0x0000006d006d7245ULL, 0x002fce000020d400ULL,
0x000000ac00727306ULL, 0x0002e20000205400ULL, 0x0000006f6e00720bULL, 0x004fe40003f1d000ULL,
0x000000a7006e7245ULL, 0x000fe4000020d400ULL, 0x00000073006f7245ULL, 0x000fc6000020d400ULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x002fca000020d400ULL,
0x000000016d6d0812ULL, 0x000fe400078efcffULL, 0x000000a700a97306ULL, 0x000e620000205400ULL,
0x00000072ad00720bULL, 0x008fce0003f5d000ULL, 0x0000009000917306ULL, 0x000fec0000209400ULL,
0x00000001acac2812ULL, 0x000fe400078efcffULL, 0x0000009000927306ULL, 0x0004e20000205400ULL,
0x000000a9a800720bULL, 0x002fce0003fbd000ULL, 0x0000009c009d7306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x004fca000020d400ULL, 0x000000016e6e5812ULL, 0x000fe400078efcffULL,
0x0000009c009e7306ULL, 0x000e620000205400ULL, 0x000000929100720bULL, 0x008fe40003fdd000ULL,
0x0000009c00917245ULL, 0x000fe4000020d400ULL, 0x0000006d6e6e723eULL, 0x000fc600000010ffULL,
0x0000009f00a07306ULL, 0x000fec0000209400ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x0000009f00a17306ULL, 0x000ea20000205400ULL, 0x0000009e9d00720bULL, 0x002fe40003f9d000ULL,
0x000000abaa00720bULL, 0x000fc40003fdd000ULL, 0x000000909390723eULL, 0x000fc600000010ffULL,
0x0000007300787306ULL, 0x000fec0000209400ULL, 0x0000000191914812ULL, 0x000fe400078efcffULL,
0x0000007300797306ULL, 0x000e620000205400ULL, 0x000000a1a000720bULL, 0x004fe40003f7d000ULL,
0x000000b2b100720bULL, 0x000fc40003f9d000ULL, 0x0000000121216812ULL, 0x000fc600078efcffULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x00000021aca5723eULL, 0x000fca00000010ffULL,
0x000000016c6c3812ULL, 0x000fe400078efcffULL, 0x000000ae00b07306ULL, 0x0004e20000205400ULL,
0x000000797800720bULL, 0x002fe20003f1d000ULL, 0x000000a40858723cULL, 0x080b620000041858ULL,
0x000000b6b500720bULL, 0x000fe40003f7d000ULL, 0x0000000112124812ULL, 0x000fe400078efcffULL,
0x000000916c91723eULL, 0x000fe200000010ffULL, 0x0000007a007c7306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x004fe2000020d400ULL, 0x000000a40438723cULL, 0x000b680000041838ULL,
0x000000016f6f0812ULL, 0x000fc400078efcffULL, 0x0000007a007d7306ULL, 0x000e620000205400ULL,
0x000000b0af00720bULL, 0x008fe20003f5d000ULL, 0x00000090085c723cULL, 0x000b62000004185cULL,
0x0000000111113812ULL, 0x000fca00078efcffULL, 0x0000008300817306ULL, 0x000fe40000209400ULL,
0x00000090043c723cULL, 0x000b68000004183cULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x0000008300807306ULL, 0x000ea20000205400ULL, 0x0000007d7c00720bULL, 0x002fe40003fbd000ULL,
0x0000006fae6f723eULL, 0x000fca00000010ffULL, 0x0000000300237306ULL, 0x000fe40000209400ULL,
0x0000006e0854723cULL, 0x080b680000041854ULL, 0x0000000171715812ULL, 0x000fe400078efcffULL,
0x0000000300707306ULL, 0x000e620000205400ULL, 0x000000808100720bULL, 0x004fe20003f1d000ULL,
0x0000006e0434723cULL, 0x000b620000041834ULL, 0x00000012716c723eULL, 0x000fc400000010ffULL,
0x0000000300127245ULL, 0x000fc6000020d400ULL, 0x0000001400b37306ULL, 0x000ff00000209400ULL,
0x0000001400b47306ULL, 0x000ea20000205400ULL, 0x000000702300720bULL, 0x002fe40003f5d000ULL,
0x0000008300707245ULL, 0x000fc8000020d400ULL, 0x0000000170700812ULL, 0x000fe200078efcffULL,
0x0000007e007f7306ULL, 0x000fe60000209400ULL, 0x00000011706d723eULL, 0x000fe400000010ffULL,
0x0000001400117245ULL, 0x000fe4000020d400ULL, 0x0000000112122812ULL, 0x000fe200078efcffULL,
0x0000007e00727306ULL, 0x0002e20000205400ULL, 0x000000b4b300720bULL, 0x004fe20003fdd000ULL,
0x0000006c0850723cULL, 0x080b6c0000041850ULL, 0x0000008400787306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fe2000020d400ULL, 0x0000006c0430723cULL, 0x000b680000041830ULL,
0x0000000111116812ULL, 0x000fc400078efcffULL, 0x0000008400797306ULL, 0x000e620000205400ULL,
0x000000727f00720bULL, 0x008fe40003fbd000ULL, 0x00000084007f7245ULL, 0x000fd6000020d400ULL,
0x000000017e7e5812ULL, 0x000fe400078efcffULL, 0x000000797800720bULL, 0x002fe40003f9d000ULL,
0x0000007e117e723eULL, 0x000fd600000010ffULL, 0x000000017f7f4812ULL, 0x000fc800078efcffULL,
0x0000007f127f723eULL, 0x000fce00000010ffULL, 0x0000007e084c723cULL, 0x080b70000004184cULL,
0x0000007e042c723cULL, 0x000b62000004182cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000013047f8cULL, 0x0202a2000c80043fULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x000126a01b067811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff037224ULL, 0x004fe200078e0005ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff132000007947ULL, 0x000fea000383ffffULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0001077000047802ULL, 0x002fc40000000f00ULL,
0x0000b78000007944ULL, 0x01cfea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002200037308ULL, 0x000ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc80000000022ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000087919ULL, 0x000ea80000000000ULL, 0x0000000000047919ULL, 0x002e620000000000ULL,
0x0000001808057811ULL, 0x044fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x002fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x008fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f0b06027589ULL, 0x000ea200000e0000ULL, 0x0000006800687220ULL, 0x042fe20000410000ULL,
0x0000006900697220ULL, 0x040fe20000410000ULL, 0x0000006400647220ULL, 0x040fe20000410000ULL,
0x0000006500657220ULL, 0x040fe20000410000ULL, 0x0000006000607220ULL, 0x040fe20000410000ULL,
0x0000006100617220ULL, 0x040fe20000410000ULL, 0x0000005c005c7220ULL, 0x040fe20000410000ULL,
0x0000005d005d7220ULL, 0x040fe20000410000ULL, 0x0000005800587220ULL, 0x040fe20000410000ULL,
0x0000005900597220ULL, 0x040fe20000410000ULL, 0x0000005400547220ULL, 0x040fe20000410000ULL,
0x0000005500557220ULL, 0x040fe20000410000ULL, 0x0000005000507220ULL, 0x040fe20000410000ULL,
0x0000005100517220ULL, 0x040fe20000410000ULL, 0x0000004c004c7220ULL, 0x040fe20000410000ULL,
0x0000004d004d7220ULL, 0x000fe20000410000ULL, 0x0000004a054a7220ULL, 0x044fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004605467220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x000fe20000410000ULL, 0x000000046a6a7220ULL, 0x088fe20000410000ULL,
0x000000046b6b7220ULL, 0x080fe20000410000ULL, 0x0000000466667220ULL, 0x080fe20000410000ULL,
0x0000000467677220ULL, 0x080fe20000410000ULL, 0x0000000462627220ULL, 0x080fe20000410000ULL,
0x0000000463637220ULL, 0x080fe20000410000ULL, 0x000000045e5e7220ULL, 0x080fe20000410000ULL,
0x000000045f5f7220ULL, 0x080fe20000410000ULL, 0x000000045a5a7220ULL, 0x080fe20000410000ULL,
0x000000045b5b7220ULL, 0x080fe20000410000ULL, 0x0000000456567220ULL, 0x080fe20000410000ULL,
0x0000000457577220ULL, 0x080fe20000410000ULL, 0x0000000452527220ULL, 0x080fe20000410000ULL,
0x0000000453537220ULL, 0x080fe20000410000ULL, 0x000000044e4e7220ULL, 0x080fe20000410000ULL,
0x000000044f4f7220ULL, 0x000fe20000410000ULL, 0x0000000248487220ULL, 0x080fe20000410000ULL,
0x0000000249497220ULL, 0x080fe20000410000ULL, 0x0000000244447220ULL, 0x080fe20000410000ULL,
0x0000000245457220ULL, 0x080fe20000410000ULL, 0x0000000240407220ULL, 0x080fe20000410000ULL,
0x0000000241417220ULL, 0x080fe20000410000ULL, 0x000000023c3c7220ULL, 0x080fe20000410000ULL,
0x000000023d3d7220ULL, 0x080fe20000410000ULL, 0x0000000238387220ULL, 0x080fe20000410000ULL,
0x0000000239397220ULL, 0x080fe20000410000ULL, 0x0000000234347220ULL, 0x080fe20000410000ULL,
0x0000000235357220ULL, 0x080fe20000410000ULL, 0x0000000230307220ULL, 0x080fe20000410000ULL,
0x0000000231317220ULL, 0x080fe20000410000ULL, 0x000000022c2c7220ULL, 0x080fe20000410000ULL,
0x000000022d2d7220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000006a6b6a723eULL, 0x000fc400000010ffULL, 0x000000666766723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000626362723eULL, 0x000fe400000010ffULL,
0x0000005e5f5e723eULL, 0x000fe400000010ffULL, 0x0000005a5b5a723eULL, 0x000fc400000010ffULL,
0x000000565756723eULL, 0x000fe400000010ffULL, 0x000000525352723eULL, 0x000fe400000010ffULL,
0x0000004e4f29723eULL, 0x000fe400000010ffULL, 0x000000484948723eULL, 0x000fe400000010ffULL,
0x0000000800057811ULL, 0x04afe400078ff0ffULL, 0x0000000200027812ULL, 0x000fc400078ec0ffULL,
0x0000001800097811ULL, 0x000fe200078ff0ffULL, 0x00000008050a7824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x000fe200078ff0ffULL,
0x0000000809147824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee203ULL,
0x00000002ff077819ULL, 0x004fe20000011600ULL, 0x0000000805127824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fc400078ff8ffULL, 0x0000000902057211ULL, 0x040fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000702047211ULL, 0x000fe200078ff8ffULL,
0x00000008070e7824ULL, 0x040fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee203ULL,
0x0000200020037824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x000fe40007ffe0ffULL,
0x0000200003037812ULL, 0x000fc400078ee2ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff805027812ULL, 0x000fe200078ee204ULL, 0x000010001a057824ULL, 0x000fe200078e0203ULL,
0x0000000404067810ULL, 0x040fe40007ffe0ffULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x000000100a107824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x00000010080a7824ULL, 0x100fe200078e0205ULL, 0x000000686902723eULL, 0x000fe200000010ffULL,
0x0000001012127824ULL, 0x000fe200078e0205ULL, 0x000000646504723eULL, 0x000fe200000010ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000545506723eULL, 0x000fe200000010ffULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x0000541002167816ULL, 0x100fe20000000004ULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x0000763202177816ULL, 0x000fe20000000004ULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0x000000606102723eULL, 0x000fe200000010ffULL,
0x0000000107107824ULL, 0x000fe200078e0210ULL, 0x0000005c5d04723eULL, 0x000fe200000010ffULL,
0x0000001608007388ULL, 0x0003e20000000a00ULL, 0x000000585905723eULL, 0x000fe200000010ffULL,
0x0000000107127824ULL, 0x000fe200078e0212ULL, 0x000000444524723eULL, 0x010fe200000010ffULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x000000404140723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x0000003c3d3c723eULL, 0x000fe200000010ffULL,
0x00000001070c7824ULL, 0x040fe200078e020cULL, 0x0000541052287816ULL, 0x000fe20000000029ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x000000505107723eULL, 0x000fc400000010ffULL,
0x0000541002167816ULL, 0x142fe40000000004ULL, 0x0000763202177816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x100fe40000000006ULL, 0x0000004c4d08723eULL, 0x000fe200000010ffULL,
0x000000160a007388ULL, 0x000fe20000000a00ULL, 0x0000763205057816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x000fc40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000040c007388ULL, 0x0003e20000000a00ULL, 0x0000763252297816ULL, 0x000fe40000000029ULL,
0x0000541040087816ULL, 0x140fe2000000003cULL, 0x000000060e007388ULL, 0x0005e20000000a00ULL,
0x0000763240097816ULL, 0x000fe4000000003cULL, 0x000000383938723eULL, 0x000fe400000010ffULL,
0x00000034351c723eULL, 0x000fc400000010ffULL, 0x000000303130723eULL, 0x000fe400000010ffULL,
0x000054106a047816ULL, 0x142fe40000000066ULL, 0x000076326a057816ULL, 0x000fe40000000066ULL,
0x0000541048067816ULL, 0x144fe40000000024ULL, 0x0000763248077816ULL, 0x000fe20000000024ULL,
0x0000000410007388ULL, 0x0003e20000000a00ULL, 0x0000002c2d18723eULL, 0x000fc400000010ffULL,
0x0000004a4b02723eULL, 0x000fe400000010ffULL, 0x0000541062047816ULL, 0x142fe4000000005eULL,
0x0000763262057816ULL, 0x000fca000000005eULL, 0x000400040a007388ULL, 0x0003e40000000a00ULL,
0x000054105a047816ULL, 0x142fe40000000056ULL, 0x000076325a057816ULL, 0x000fca0000000056ULL,
0x000400040c007388ULL, 0x0003e80000000a00ULL, 0x000400280e007388ULL, 0x000fe80000000a00ULL,
0x0000000612007388ULL, 0x0005e80000000a00ULL, 0x000800080a007388ULL, 0x0007e20000000a00ULL,
0x000000464704723eULL, 0x002fc400000010ffULL, 0x000000424305723eULL, 0x000fe400000010ffULL,
0x0000003e3f06723eULL, 0x004fe400000010ffULL, 0x0000541038087816ULL, 0x148fe4000000001cULL,
0x0000763238097816ULL, 0x000fca000000001cULL, 0x000800080c007388ULL, 0x0003e40000000a00ULL,
0x0000541030087816ULL, 0x142fe40000000018ULL, 0x0000763230097816ULL, 0x000fca0000000018ULL,
0x000800080e007388ULL, 0x0003e40000000a00ULL, 0x0000541002087816ULL, 0x142fe40000000004ULL,
0x0000763202097816ULL, 0x000fe40000000004ULL, 0x0000003a3b02723eULL, 0x000fe400000010ffULL,
0x000000363704723eULL, 0x000fe200000010ffULL, 0x0000000814007388ULL, 0x0003e60000000a00ULL,
0x0000763202157816ULL, 0x000fc40000000004ULL, 0x0000541005087816ULL, 0x142fe40000000006ULL,
0x0000763205097816ULL, 0x000fe40000000006ULL, 0x0000541002147816ULL, 0x000fe20000000004ULL,
0x0000000177027824ULL, 0x000fe200078e0200ULL, 0x000000323305723eULL, 0x000fe200000010ffULL,
0x000c00080a007388ULL, 0x000fe20000000a00ULL, 0x0000002e2f06723eULL, 0x000fe200000010ffULL,
0x000000ff00047306ULL, 0x000fe40000205400ULL, 0x000c00140c007388ULL, 0x0003e20000000a00ULL,
0x00007632050d7816ULL, 0x000fc40000000006ULL, 0x00005410050c7816ULL, 0x002fe20000000006ULL,
0x0000001002067824ULL, 0x000fe400078e0203ULL, 0x000000ff00057306ULL, 0x000e620000209400ULL,
0x000000ff00027245ULL, 0x000fe2000020d400ULL, 0x000c000c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000006087984ULL, 0x000ea20000000c00ULL,
0x000000040500720bULL, 0x002fc60003f1d000ULL, 0x0004000006147984ULL, 0x000e680000000c00ULL,
0x0008000006247984ULL, 0x000ee80000000c00ULL, 0x000c0000062c7984ULL, 0x000ee80000000c00ULL,
0x0010000006107984ULL, 0x000ee20000000c00ULL, 0x0000000102020812ULL, 0x000fc400078efcffULL,
0x000000ff1a00720cULL, 0x000fe20003f05270ULL, 0x00140000061c7984ULL, 0x000ee20000000c00ULL,
0x000000020204723eULL, 0x000fc600000010ffULL, 0x0018000006287984ULL, 0x000ee80000000c00ULL,
0x001c0000060c7984ULL, 0x000ee20000000c00ULL, 0x3f803f80040b7831ULL, 0x044fe4000020000bULL,
0x3f803f80040a7831ULL, 0x040fe4000020000aULL, 0x3f803f8004097831ULL, 0x040fe40000200009ULL,
0x3f803f8004087831ULL, 0x000fc40000200008ULL, 0x3f803f8004177831ULL, 0x042fe40000200017ULL,
0x3f803f8004167831ULL, 0x040fe40000200016ULL, 0x3f803f8004157831ULL, 0x040fe40000200015ULL,
0x3f803f8004147831ULL, 0x040fe40000200014ULL, 0x3f803f8004277831ULL, 0x048fe40000200027ULL,
0x3f803f8004267831ULL, 0x000fc40000200026ULL, 0x3f803f8004257831ULL, 0x040fe40000200025ULL,
0x3f803f8004247831ULL, 0x040fe40000200024ULL, 0x3f803f80042f7831ULL, 0x040fe4000020002fULL,
0x3f803f80042e7831ULL, 0x040fe4000020002eULL, 0x3f803f80042d7831ULL, 0x040fe4000020002dULL,
0x3f803f80042c7831ULL, 0x000fc4000020002cULL, 0x3f803f800b0b7831ULL, 0x000fe40000200013ULL,
0x3f803f800a0a7831ULL, 0x000fe40000200012ULL, 0x3f803f8009097831ULL, 0x000fe40000200011ULL,
0x3f803f8008087831ULL, 0x000fe40000200010ULL, 0x3f803f8017177831ULL, 0x000fe4000020001fULL,
0x3f803f8016167831ULL, 0x000fe2000020001eULL, 0x0000000806007388ULL, 0x000fe20000000c00ULL,
0x3f803f8015157831ULL, 0x000fc4000020001dULL, 0x3f803f8014147831ULL, 0x000fe4000020001cULL,
0x3f803f8027277831ULL, 0x000fe4000020002bULL, 0x3f803f8026267831ULL, 0x000fe2000020002aULL,
0x0004001406007388ULL, 0x000fe20000000c00ULL, 0x3f803f8025257831ULL, 0x000fe40000200029ULL,
0x3f803f8024247831ULL, 0x000fe40000200028ULL, 0x3f803f802f2f7831ULL, 0x000fc4000020000fULL,
0x3f803f802e2e7831ULL, 0x000fe2000020000eULL, 0x0008002406007388ULL, 0x000fe20000000c00ULL,
0x3f803f802d2d7831ULL, 0x000fe4000020000dULL, 0x3f803f802c2c7831ULL, 0x000fca000020000cULL,
0x000c002c06007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fc80000011600ULL,
0x000000740700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107027824ULL, 0x100fe200078e0200ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000000120117812ULL, 0x000fe200078ec0ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000702057812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x00000007000e7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff805027812ULL, 0x000fe200078ef800ULL, 0x0000580000067ab9ULL, 0x000fc80000000800ULL,
0x0000001002047824ULL, 0x000fe400078e0203ULL, 0x0000002076027824ULL, 0x000fe400078e0207ULL,
0x0000000811077824ULL, 0x000fe200078e020eULL, 0x0000000004087984ULL, 0x0004e40000000c00ULL,
0x0000000502067c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe20000011602ULL,
0x00000006040472a4ULL, 0x002fc4000f8e023fULL, 0x0000000175067824ULL, 0x000fc800078e0206ULL,
0x0000008205057224ULL, 0x000fe200078e0206ULL, 0x0000002000067810ULL, 0x000fe20007ffe0ffULL,
0x0000000482027c24ULL, 0x000fc6000f8e02ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011606ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x004fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440cULL,
0x000000740d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0083ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106047824ULL, 0x102fe200078e020dULL, 0x00000040000c7810ULL, 0x000fe20007ffe0ffULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820d0d7224ULL, 0x000fe400078e0204ULL,
0x0000000811077824ULL, 0x002fc600078e0206ULL, 0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000d047a11ULL, 0x000fc800078040ffULL,
0x00005d000d057a11ULL, 0x000fe400000f440eULL, 0x00000003ff0d7819ULL, 0x000fc6000001160cULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000740d00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0043f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe400078e020dULL, 0x00000020760d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820d0d7224ULL, 0x000fca00078e0204ULL,
0x0000000d02057210ULL, 0x000fe40007f1e0ffULL, 0x00000060000d7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x040fe400078040ffULL,
0x00000003ff0f7819ULL, 0x000fe4000001160dULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000740f00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e020fULL, 0x0000008000077810ULL, 0x000fe20007ffe0ffULL,
0x00000020760f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000820f0f7224ULL, 0x000fca00078e0204ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440cULL, 0x00000003ff0f7819ULL, 0x000fc60000011607ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x000000740f00720cULL, 0x000fc80003f06070ULL,
0x0000000804007986ULL, 0x0023f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107047824ULL, 0x102fe200078e020fULL, 0x000000a0000c7810ULL, 0x000fe20007ffe0ffULL,
0x00000020760f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0d7819ULL, 0x000fe4000001160cULL, 0x0ffffff804047812ULL, 0x000fe400078ef807ULL,
0x0000000707077812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e0207ULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820f0f7224ULL, 0x000fca00078e0204ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440eULL,
0x000000740d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c047824ULL, 0x102fe400078e020dULL, 0x00000020760d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820d0d7224ULL, 0x000fca00078e0204ULL,
0x0000000d02057210ULL, 0x000fe40007f1e0ffULL, 0x000000c0000d7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x040fe400078040ffULL,
0x00000003ff0f7819ULL, 0x000fe4000001160dULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000740f00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d047824ULL, 0x102fe200078e020fULL, 0x000000e000007810ULL, 0x000fe20007ffe0ffULL,
0x00000020760f7824ULL, 0x000fc600078e020fULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x00000003ff077819ULL, 0x000fe40000011600ULL, 0x0ffffff804047812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820f0f7224ULL, 0x000fe400078e0204ULL,
0x0000000100067824ULL, 0x002fc600078e0207ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440cULL, 0x000000740700720cULL, 0x000fc60003f06070ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x00000007060d7812ULL, 0x000fc800078ec0ffULL,
0xfffffff80d067812ULL, 0x000fe200078ef800ULL, 0x0000000804007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000002076077824ULL, 0x000fc600078e0207ULL,
0x0000000006087984ULL, 0x002e620000000c00ULL, 0x0000000811057824ULL, 0x000fe200078e0200ULL,
0x0000000507047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fc60000011607ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x0000008207077224ULL, 0x000fca00078e0204ULL,
0x0000000702077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0007027a11ULL, 0x000fc800078040ffULL, 0x00005d0007037a11ULL, 0x000fca00000f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000001d2000720cULL, 0x000fe20003f06070ULL,
0xffffffffff217424ULL, 0x000fd800078e00ffULL, 0x0000000202058824ULL, 0x000fc800078e00ffULL,
0x0000680005068a24ULL, 0x000fc800078e0220ULL, 0x0000640006068625ULL, 0x002fe200078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff607624ULL, 0x000fe200078e00ffULL,
0x0000000806218981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff617624ULL, 0x000fc600078e00ffULL,
0x01260000ff047f8cULL, 0x000e68000c80043fULL, 0x0000000860607981ULL, 0x000722000c1e9900ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x000000405c5c7824ULL, 0x000fe400078e00ffULL,
0x00000040205d7824ULL, 0x000fe400078e00ffULL, 0x00000040195e7824ULL, 0x000fc400078e00ffULL,
0x0000005c21277224ULL, 0x004fcc00078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff237819ULL, 0x00afe4000001161fULL, 0x0000620027257a11ULL, 0x000fe400078038ffULL,
0x0000001f1f107211ULL, 0x000fe200078fe8ffULL, 0x0000004019197824ULL, 0x000fe200078e0223ULL,
0x0000630027277a11ULL, 0x000fe400000f3cffULL, 0x0000000310167812ULL, 0x000fe200078ec0ffULL,
0x0000008019067825ULL, 0x040fe200078e00ffULL, 0x00000010190a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000819087810ULL, 0x000fe40007ffe0ffULL, 0x00000030060c7812ULL, 0x100fe200078ef803ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000005d1e067217ULL, 0x000fe40007800000ULL,
0x0000000c250c7210ULL, 0x000fe20007f1e0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000300a0a7812ULL, 0x000fe400078ef803ULL, 0x0000000823117810ULL, 0x000fe20007ffe0ffULL,
0x00000001070d7824ULL, 0x000fe200000e0627ULL, 0x0000001819077810ULL, 0x000fe20007ffe0ffULL,
0x0000000106147824ULL, 0x000fe200078e0a5dULL, 0x00000030080e7812ULL, 0x000fe200078ef803ULL,
0x0000000411157824ULL, 0x000fe200078e00ffULL, 0x000000250a0a7210ULL, 0x080fe20007f5e0ffULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x000000250e0e7210ULL, 0x000fc40007f3e0ffULL,
0x0000002019087810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200010e0627ULL,
0x0000003006107812ULL, 0x000fe200078ef803ULL, 0x00000001090f7824ULL, 0x000fe200008e0627ULL,
0x000000142300720cULL, 0x000fe20003f06070ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000002510107210ULL, 0x000fe40007f5e0ffULL, 0x0000002819067810ULL, 0x000fe40007ffe0ffULL,
0x0000200020187811ULL, 0x000fc400078e68ffULL, 0x000000141100720cULL, 0x000fe20003f26070ULL,
0x0000000107117824ULL, 0x000fe200010e0627ULL, 0x0ffffffc161f7812ULL, 0x000fe200078ef81fULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000003008127812ULL, 0x100fe400078ef803ULL,
0xfffffffc15157812ULL, 0x000fe200078ee216ULL, 0x000000101f1f7824ULL, 0x100fe200078e0218ULL,
0x0000003006067812ULL, 0x000fe400078ef803ULL, 0x0000002512127210ULL, 0x000fe20007f7e0ffULL,
0x0000001015157824ULL, 0x000fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1f7faeULL, 0x0003e2000c101c48ULL, 0x0000001023297810ULL, 0x000fc40007ffe0ffULL,
0x0000000109137824ULL, 0x000fe200018e0627ULL, 0x0000002023097810ULL, 0x040fe20007ffe0ffULL,
0x000000000e157faeULL, 0x0005e2000c901c48ULL, 0x00000018232b7810ULL, 0x000fe40007ffe0ffULL,
0x0000003819087810ULL, 0x000fe40007ffe0ffULL, 0x0000002823177810ULL, 0x000fe40007ffe0ffULL,
0x00000025060c7210ULL, 0x002fe20007fde0ffULL, 0x00000004091f7824ULL, 0x000fe200078e00ffULL,
0x0000003019067810ULL, 0x000fc40007ffe0ffULL, 0x00000030231b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001070d7824ULL, 0x000fe200030e0627ULL, 0x0000003823237810ULL, 0x000fe20007ffe0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000140900720cULL, 0x080fe40003f66070ULL,
0x000000142900720cULL, 0x0c0fe20003fa6070ULL, 0x00000004290f7824ULL, 0x004fe200078e00ffULL,
0x0000003006067812ULL, 0x000fe200078ef803ULL, 0x000000042b157824ULL, 0x040fe200078e00ffULL,
0x000000142b00720cULL, 0x080fe20003f86070ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000141b00720cULL, 0x000fc40003f26070ULL, 0x000000142300720cULL, 0x080fe20003f06070ULL,
0x0000000417297824ULL, 0x000fe200078e00ffULL, 0x0000002506067210ULL, 0x000fe20007fde0ffULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x000000141700720cULL, 0x000fe20003f46070ULL,
0x0000000423237824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f0f7812ULL, 0x100fe200078ee216ULL,
0x0000000107077824ULL, 0x000fe200030e0627ULL, 0xfffffffc15157812ULL, 0x000fe400078ee216ULL,
0x0000003008087812ULL, 0x000fe200078ef803ULL, 0x000000100f0f7824ULL, 0x000fe200078e0218ULL,
0xfffffffc1f177812ULL, 0x000fe200078ee216ULL, 0x0000001015157824ULL, 0x000fe200078e0218ULL,
0xfffffffc29197812ULL, 0x000fc400078ee216ULL, 0xfffffffc1b037812ULL, 0x000fe200078ee216ULL,
0x0000001017177824ULL, 0x000fe200078e0218ULL, 0xfffffffc231b7812ULL, 0x000fe200078ee216ULL,
0x0000001019197824ULL, 0x100fe200078e0218ULL, 0x0000002508087210ULL, 0x000fe20007fde0ffULL,
0x0000001003037824ULL, 0x100fe200078e0218ULL, 0x000000000a0f7faeULL, 0x0003e2000e901c48ULL,
0x000000101b1b7824ULL, 0x000fe400078e0218ULL, 0x0000000109097824ULL, 0x000fe200030e0627ULL,
0x0000000010157faeULL, 0x0003e8000e101c48ULL, 0x0000000012177faeULL, 0x0003e8000d901c48ULL,
0x000000000c197faeULL, 0x0003e8000d101c48ULL, 0x0000000006037faeULL, 0x0003e8000c901c48ULL,
0x00000000081b7faeULL, 0x0003e2000c101c48ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x0000005e1f067211ULL, 0x04afe400078ff0ffULL, 0x0000001f1f077211ULL, 0x000fc400078fe8ffULL,
0x000000301f0f7811ULL, 0x040fe400078ff0ffULL, 0x000000081f2f7811ULL, 0x040fe400078ff0ffULL,
0x000000181f337811ULL, 0x000fe200078ff0ffULL, 0x000000040f237824ULL, 0x000fe200078e00ffULL,
0x000000101f317811ULL, 0x000fe200078ff0ffULL, 0x000000042f097824ULL, 0x000fe200078e00ffULL,
0x000000201f0b7811ULL, 0x000fe200078ff0ffULL, 0x0000000433177824ULL, 0x000fe200078e00ffULL,
0x000000281f0d7811ULL, 0x000fe200078ff0ffULL, 0x0000000431157824ULL, 0x000fe200078e00ffULL,
0x0000000307107812ULL, 0x000fe200078ec0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000381f117811ULL, 0x000fc400078ff0ffULL, 0x0000620027297a11ULL, 0x000fe200078038ffULL,
0x000000040b197824ULL, 0x000fe200078e00ffULL, 0x0000003006147812ULL, 0x000fe200078ef803ULL,
0x000000040d1b7824ULL, 0x000fe200078e00ffULL, 0x0000200020137811ULL, 0x000fe200078e68ffULL,
0x0000000411257824ULL, 0x000fe200078e00ffULL, 0xfffffffc23067812ULL, 0x100fe200078ee210ULL,
0x000000015e127824ULL, 0x000fe200078e0211ULL, 0xfffffffc09087812ULL, 0x000fe400078ee210ULL,
0x0ffffffc101f7812ULL, 0x000fc400078ef81fULL, 0xfffffffc170a7812ULL, 0x100fe200078ee210ULL,
0x0000001008177824ULL, 0x100fe200078e0213ULL, 0xfffffffc15097812ULL, 0x100fe200078ee210ULL,
0x000000101f2d7824ULL, 0x000fe200078e0213ULL, 0xfffffffc190c7812ULL, 0x100fe200078ee210ULL,
0x000000015e087824ULL, 0x000fe200078e0231ULL, 0xfffffffc1b0e7812ULL, 0x100fe200078ee210ULL,
0x000000100a1b7824ULL, 0x100fe200078e0213ULL, 0x00006300272b7a11ULL, 0x000fe200000f3cffULL,
0x000000100c1f7824ULL, 0x100fe200078e0213ULL, 0xfffffffc25107812ULL, 0x000fe200078ee210ULL,
0x0000001006257824ULL, 0x000fe200078e0213ULL, 0x0000001429147210ULL, 0x000fe20007f1e0ffULL,
0x000000015e067824ULL, 0x000fc400078e022fULL, 0x000000015e0a7824ULL, 0x000fe400078e0233ULL,
0x000000100e237824ULL, 0x000fe400078e0213ULL, 0x0000000107157824ULL, 0x000fe400000e062bULL,
0x000000015e0c7824ULL, 0x000fe400078e020bULL, 0x0000001009197824ULL, 0x100fe200078e0213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000142d7faeULL, 0x0003e2000b901c48ULL,
0x0000001010277824ULL, 0x000fc400078e0213ULL, 0x000000015e0e7824ULL, 0x000fe400078e020dULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x000000015e107824ULL, 0x000fe200078e020fULL,
0x0000003006067812ULL, 0x000fe200078ef803ULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0x0000000629067210ULL, 0x000fe20007f1e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003008087812ULL, 0x000fc600078ef803ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a0a7812ULL, 0x100fe400078ef803ULL, 0x0000000829087210ULL, 0x040fe20007f3e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x100fe400078ef803ULL,
0x0000000a290a7210ULL, 0x040fe20007f5e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300e0e7812ULL, 0x100fe400078ef803ULL, 0x0000000c290c7210ULL, 0x000fe20007f7e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000003010107812ULL, 0x000fc400078ef803ULL,
0x0000000e290e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000107077824ULL, 0x000fe200000e062bULL,
0x0000003012037812ULL, 0x000fe200078ef803ULL, 0x0000000109097824ULL, 0x100fe200008e062bULL,
0x0000001029107210ULL, 0x000fe20007fbe0ffULL, 0x000000010b0b7824ULL, 0x100fe200010e062bULL,
0x0000000329127210ULL, 0x000fe20007fde0ffULL, 0x000000010d0d7824ULL, 0x100fe200018e062bULL,
0x0000000006177faeULL, 0x0003e2000b901c48ULL, 0x000000010f0f7824ULL, 0x100fe400020e062bULL,
0x0000000111117824ULL, 0x100fe200028e062bULL, 0x0000000008197faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x000fc600030e062bULL, 0x000000000a1b7faeULL, 0x0003e8000b901c48ULL,
0x000000000c1f7faeULL, 0x0003e8000b901c48ULL, 0x000000000e237faeULL, 0x0003e8000b901c48ULL,
0x0000000010257faeULL, 0x0003e8000b901c48ULL, 0x0000000012277faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01260400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002020037824ULL, 0x002fca00078e0203ULL,
0x00000004ff047819ULL, 0x000fe40000011603ULL, 0x0000000103057810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe04067812ULL, 0x000fe400078ec0ffULL, 0x0000001f03047812ULL, 0x000fc600078ec0ffULL,
0x0000000106087824ULL, 0x040fe400078e0205ULL, 0x0000000103077824ULL, 0x000fe200078e0206ULL,
0x0000000806067810ULL, 0x000fe20007ffe0ffULL, 0x0000001004097824ULL, 0x000fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x00000010040a7824ULL, 0x000fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x000001f009087812ULL, 0x000fe200078ee208ULL, 0x0000000103037824ULL, 0x000fe200078e0206ULL,
0x000001f00a077812ULL, 0x000fe200078ee207ULL, 0x0000001004067824ULL, 0x040fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fe200078ec0ffULL, 0x00000000080c7984ULL, 0x000e62000000cc00ULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x0000000f03037812ULL, 0x000fc400078ec0ffULL,
0x0000000007107984ULL, 0x000ea4000000cc00ULL, 0x000001f004057812ULL, 0x000fe400078ee205ULL,
0x000001f006037812ULL, 0x000fe200078ee203ULL, 0x000000ffff167224ULL, 0x002fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001407007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x0000001808007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000003107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002403007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01260000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01260400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000000001f7919ULL, 0x000e620000000000ULL,
0x00005800ff677624ULL, 0x000fe200078e00ffULL, 0x800058001e687a10ULL, 0x000fe20007ffe0ffULL,
0x00006800025f7a24ULL, 0x000fe200078e02ffULL, 0x3db504f360607820ULL, 0x010fe20000410000ULL,
0x0001268820617811ULL, 0x000fe200078e18ffULL, 0x000000ffff637224ULL, 0x000fe200078e00ffULL,
0x0000001f67027810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff657224ULL, 0x000fe200078e00ffULL,
0xffffffff67667810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff647224ULL, 0x000fe200078e0020ULL,
0x00000004ff027819ULL, 0x000fc40000011602ULL, 0x0001260820627811ULL, 0x000fe400078e28ffULL,
0x0000000967677810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x0ffffffe02697812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x000fe200078e0065ULL, 0x0000000000067805ULL, 0x004fe2000001ff00ULL,
0x000000ffff6a7224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x018fc4000001ff00ULL,
0x000000016a00780cULL, 0x040fe20003f25270ULL, 0x00000c0000007945ULL, 0x000fe20003800000ULL,
0x0000000163227810ULL, 0x020fe20007ffe0ffULL, 0x000000ffff797224ULL, 0x000fe200078e006aULL,
0x000000016a037810ULL, 0x000fe20007ffe0ffULL, 0x0000005c215a7224ULL, 0x010fe200078e02ffULL,
0x000000016b657812ULL, 0x000fc400078e0cffULL, 0x000000020300780cULL, 0x040fe20003f06070ULL,
0x000000ffff6a7224ULL, 0x000fe200078e0003ULL, 0x000000ff03027207ULL, 0x000fc60000800000ULL,
0x000000ffff221224ULL, 0x000fca00078e0263ULL, 0x0000000122237810ULL, 0x000fc80007ffe0ffULL,
0x0000001c2300720cULL, 0x000fda0003f46070ULL, 0x000006000000a947ULL, 0x000fea0003800000ULL,
0x000000101f037824ULL, 0x002fe200078e00ffULL, 0x00000002ff6c7819ULL, 0x000fe4000001161fULL,
0x000062005a737a11ULL, 0x000fe400078238ffULL, 0x0000003003237812ULL, 0x000fe200078ec0ffULL,
0x0000010022037824ULL, 0x000fe200078e025dULL, 0x000000086c577810ULL, 0x000fe20007ffe0ffULL,
0x000000015e2d7824ULL, 0x000fe200078e026cULL, 0x000000106c6d7810ULL, 0x000fe20007ffe0ffULL,
0x0000004002227824ULL, 0x000fe200078e0223ULL, 0x000063005a757a11ULL, 0x000fe200008f3cffULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x000000031e507217ULL, 0x000fe20007800000ULL,
0x000000015e2f7824ULL, 0x000fe200078e0257ULL, 0x000000186c707810ULL, 0x040fe20007ffe0ffULL,
0x000000802d2c7825ULL, 0x000fe200078e0022ULL, 0x000000206c727810ULL, 0x000fc40007ffe0ffULL,
0x000000286c747810ULL, 0x000fe20007ffe0ffULL, 0x000000802f2e7825ULL, 0x000fe200078e0022ULL,
0x000000732c527210ULL, 0x000fe40007f3e0ffULL, 0x0000001f1f2c7211ULL, 0x000fe200078fe8ffULL,
0x000000015e517824ULL, 0x000fe200078e026dULL, 0x000000732e547210ULL, 0x000fe20007f5e0ffULL,
0x0000000150037824ULL, 0x000fe200078e0a03ULL, 0x000000032c6e7812ULL, 0x000fe200078ec0ffULL,
0x000000012d537824ULL, 0x000fe200008e0675ULL, 0x000000306c767810ULL, 0x000fe20007ffe0ffULL,
0x0000008051507825ULL, 0x000fe200078e0022ULL, 0x0ffffffc6e5b7812ULL, 0x000fc400078ef81fULL,
0x000000037000720cULL, 0x000fe20003fa6070ULL, 0x000000015e2d7824ULL, 0x000fe200078e0270ULL,
0x0000007350507210ULL, 0x000fe20007f3e0ffULL, 0x000000012f557824ULL, 0x000fe200010e0675ULL,
0x000000035700720cULL, 0x000fe20003f46070ULL, 0x000000802d2c7825ULL, 0x000fc800078e0022ULL,
0x000000015e2f7824ULL, 0x000fe200078e0272ULL, 0x000000732c567210ULL, 0x000fe20007f7e0ffULL,
0x00000002205a7824ULL, 0x000fe400078e0265ULL, 0x000000802f2e7825ULL, 0x000fc600078e0022ULL,
0x000020005a5a7811ULL, 0x000fe200078e60ffULL, 0x0000000151517824ULL, 0x100fe200008e0675ULL,
0x000000036c00720cULL, 0x000fe20003f26070ULL, 0x00000004576f7824ULL, 0x000fe200078e00ffULL,
0x000000732e587210ULL, 0x000fe20007f9e0ffULL, 0x000000012d577824ULL, 0x100fe200018e0675ULL,
0x000000036d00720cULL, 0x080fe20003f66070ULL, 0x000000105b2d7824ULL, 0x000fe200078e025aULL,
0x000000386c6c7810ULL, 0x000fe20007ffe0ffULL, 0x000000046d5b7824ULL, 0x000fe400078e00ffULL,
0x000000012f597824ULL, 0x000fe200020e0675ULL, 0xfffffffc6f2f7812ULL, 0x000fe200078ee26eULL,
0x000000015e6d7824ULL, 0x040fe200078e0274ULL, 0xfffffffc5b5b7812ULL, 0x000fe200078ee26eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000522d7faeULL, 0x0003e2000c901c48ULL,
0x000000015e6f7824ULL, 0x000fe200078e0276ULL, 0x000000037200720cULL, 0x080fe20003f86070ULL,
0x000000102f2f7824ULL, 0x100fe200078e025aULL, 0x000000036c00720cULL, 0x000fe20003f26070ULL,
0x000000105b5b7824ULL, 0x000fc400078e025aULL, 0x000000015e717824ULL, 0x000fe200078e026cULL,
0x00000000542f7faeULL, 0x0005e2000d101c48ULL, 0x000000037600720cULL, 0x080fe20003f46070ULL,
0x000000806d2c7825ULL, 0x102fe400078e0022ULL, 0x00000000505b7faeULL, 0x0003e2000d901c48ULL,
0x000000037400720cULL, 0x000fe20003f66070ULL, 0x0000000470037824ULL, 0x000fe200078e00ffULL,
0x000000732c2c7210ULL, 0x000fe20007fde0ffULL, 0x0000000474537824ULL, 0x000fe400078e00ffULL,
0x000000806f2e7825ULL, 0x004fe200078e0022ULL, 0xfffffffc03037812ULL, 0x000fc400078ee26eULL,
0xfffffffc53537812ULL, 0x000fe200078ee26eULL, 0x000000012d2d7824ULL, 0x000fe200030e0675ULL,
0x000000732e2e7210ULL, 0x000fe20007fde0ffULL, 0x0000000472517824ULL, 0x002fe400078e00ffULL,
0x0000000476557824ULL, 0x000fe400078e00ffULL, 0x0000008071227825ULL, 0x000fe200078e0022ULL,
0xfffffffc51517812ULL, 0x100fe400078ee26eULL, 0xfffffffc55557812ULL, 0x000fe200078ee26eULL,
0x000000046c5b7824ULL, 0x000fc400078e00ffULL, 0x000000012f2f7824ULL, 0x100fe200030e0675ULL,
0x0000007322227210ULL, 0x000fe20007fde0ffULL, 0x0000001003037824ULL, 0x000fe200078e025aULL,
0xfffffffc5b5b7812ULL, 0x000fe200078ee26eULL, 0x0000001051517824ULL, 0x100fe400078e025aULL,
0x0000001053537824ULL, 0x100fe200078e025aULL, 0x0000000056037faeULL, 0x0003e2000e901c48ULL,
0x0000001055557824ULL, 0x100fe400078e025aULL, 0x000000105b5b7824ULL, 0x000fe200078e025aULL,
0x0000000058517faeULL, 0x0003e2000e101c48ULL, 0x0000000123237824ULL, 0x000fc600030e0675ULL,
0x000000002c537faeULL, 0x0003e8000d901c48ULL, 0x000000002e557faeULL, 0x0003e8000d101c48ULL,
0x00000000225b7faeULL, 0x0003e2000c901c48ULL, 0x0000053000007947ULL, 0x000fea0003800000ULL,
0x0000000220237824ULL, 0x000fe200078e0265ULL, 0x000000081f2d7811ULL, 0x002fc400078ff0ffULL,
0x000000101f2f7811ULL, 0x040fe400078ff0ffULL, 0x000000181f517811ULL, 0x040fe400078ff0ffULL,
0x000000201f537811ULL, 0x000fe200078ff0ffULL, 0x000000042f5b7824ULL, 0x000fe200078e00ffULL,
0x000000281f557811ULL, 0x000fe200078ff0ffULL, 0x00000004516d7824ULL, 0x000fe200078e00ffULL,
0x000000301f577811ULL, 0x000fe200078ff0ffULL, 0x00000004536f7824ULL, 0x000fe200078e00ffULL,
0x000000381f7b7811ULL, 0x000fe200078ff0ffULL, 0x0000000455717824ULL, 0x000fe200078e00ffULL,
0x0000001f1f037211ULL, 0x000fe200078fe8ffULL, 0x0000000457737824ULL, 0x000fe200078e00ffULL,
0x00002000232c7811ULL, 0x000fe200078e60ffULL, 0x000000042d237824ULL, 0x000fe200078e00ffULL,
0x0000000303227812ULL, 0x000fe200078ec0ffULL, 0x000000047b757824ULL, 0x000fe200078e00ffULL,
0x000062005a777a11ULL, 0x000fe200078238ffULL, 0x000000015e2d7824ULL, 0x040fe200078e022dULL,
0xfffffffc23237812ULL, 0x100fe200078ee222ULL, 0x000000015e2f7824ULL, 0x040fe200078e022fULL,
0xfffffffc5b5b7812ULL, 0x100fe200078ee222ULL, 0x000000015e517824ULL, 0x040fe200078e0251ULL,
0xfffffffc6d6d7812ULL, 0x100fe200078ee222ULL, 0x000000015e537824ULL, 0x040fe200078e0253ULL,
0xfffffffc6f6f7812ULL, 0x100fe200078ee222ULL, 0x000000015e557824ULL, 0x040fe200078e0255ULL,
0xfffffffc71717812ULL, 0x100fe200078ee222ULL, 0x000000015e577824ULL, 0x000fe200078e0257ULL,
0x0ffffffc22037812ULL, 0x000fe200078ef81fULL, 0x000000015e7b7824ULL, 0x000fe200078e027bULL,
0xfffffffc73737812ULL, 0x000fe200078ee222ULL, 0x000000105b5b7824ULL, 0x000fe200078e022cULL,
0xfffffffc75757812ULL, 0x000fe200078ee222ULL, 0x000000101f227824ULL, 0x000fc400078e00ffULL,
0x00000010037d7824ULL, 0x100fe400078e022cULL, 0x0000001023037824ULL, 0x100fe200078e022cULL,
0x0000003022597812ULL, 0x000fe200078ec0ffULL, 0x000000106d6d7824ULL, 0x100fe200078e022cULL,
0x0000005e1f237211ULL, 0x000fe200078ff0ffULL, 0x000000106f6f7824ULL, 0x000fe400078e022cULL,
0x0000004002587824ULL, 0x000fe400078e0259ULL, 0x000000ffff597224ULL, 0x000fc400078e00ffULL,
0x0000001071717824ULL, 0x100fe400078e022cULL, 0x0000001073737824ULL, 0x100fe400078e022cULL,
0x0000001075757824ULL, 0x000fe400078e022cULL, 0x0000008023227825ULL, 0x000fc800078e0058ULL,
0x000000802d2c7825ULL, 0x000fc800078e0058ULL, 0x000000802f2e7825ULL, 0x000fe200078e0058ULL,
0x000000772c2c7210ULL, 0x000fc60007f5e0ffULL, 0x0000008051507825ULL, 0x000fe200078e0058ULL,
0x000000772e2e7210ULL, 0x000fc60007f7e0ffULL, 0x0000008053527825ULL, 0x000fe200078e0058ULL,
0x0000007750507210ULL, 0x000fc60007f9e0ffULL, 0x0000008055547825ULL, 0x000fc800078e0058ULL,
0x0000008057567825ULL, 0x000fc800078e0058ULL, 0x000000807b587825ULL, 0x000fe200078e0058ULL,
0x000063005a7b7a11ULL, 0x000fe400008f3cffULL, 0x0000007722227210ULL, 0x000fc60007f3e0ffULL,
0x000000012d2d7824ULL, 0x100fe200010e067bULL, 0x0000007754547210ULL, 0x080fe20007f5e0ffULL,
0x0000000123237824ULL, 0x100fe200008e067bULL, 0x0000007752527210ULL, 0x080fe20007f3e0ffULL,
0x000000012f2f7824ULL, 0x100fe200018e067bULL, 0x0000007756567210ULL, 0x080fe20007f7e0ffULL,
0x0000000151517824ULL, 0x100fe200020e067bULL, 0x0000007758587210ULL, 0x000fe20007f9e0ffULL,
0x0000000153537824ULL, 0x100fe200008e067bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000227d7faeULL, 0x0003e2000b901c48ULL, 0x0000000155557824ULL, 0x000fc400010e067bULL,
0x0000000157577824ULL, 0x100fe200018e067bULL, 0x000000002c037faeULL, 0x0003e2000b901c48ULL,
0x0000000159597824ULL, 0x000fc600020e067bULL, 0x000000002e5b7faeULL, 0x0003e8000b901c48ULL,
0x00000000506d7faeULL, 0x0003e8000b901c48ULL, 0x00000000526f7faeULL, 0x0003e8000b901c48ULL,
0x0000000054717faeULL, 0x0003e8000b901c48ULL, 0x0000000056737faeULL, 0x0003e8000b901c48ULL,
0x0000000058757faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010200780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000464647810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff217424ULL, 0x000fc600078e00ffULL, 0x0000001d6400720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000025f027824ULL, 0x000fe400078e0264ULL,
0x00000004ff037424ULL, 0x002fc800078e00ffULL, 0x0000640002027625ULL, 0x000fca00078e0003ULL,
0x0000000802217981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008796d7824ULL, 0x002fe400078e00ffULL,
0x000000ffffde7224ULL, 0x000fe400078e00ffULL, 0x00000010ff6e7424ULL, 0x000fe200078e00ffULL,
0x000000126d6f7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff6c7224ULL, 0x000fe200078e00ffULL,
0x000000026d6d7810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff81f027812ULL, 0x000fe200078ec0ffULL, 0x0000000220237824ULL, 0x020fe200078e026bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000016c527810ULL, 0x000fc40007ffe0ffULL,
0x0000000702027812ULL, 0x000fe400078ef81fULL, 0x0000200023237811ULL, 0x000fe400078e60ffULL,
0x00000001ff037819ULL, 0x000fe20000011602ULL, 0x00000004022d7824ULL, 0x040fe400078e00ffULL,
0x0000000402027824ULL, 0x000fe400078e00ffULL, 0x0000000103227824ULL, 0x040fe400078e026cULL,
0x0000000103037824ULL, 0x000fc600078e0252ULL, 0xfffffffc2d227812ULL, 0x000fe400078ee222ULL,
0xfffffffc02027812ULL, 0x000fc600078ee203ULL, 0x0000001022547824ULL, 0x100fe400078e0223ULL,
0x0000001002027824ULL, 0x000fc800078e0223ULL, 0x000000005454783bULL, 0x000e680000000200ULL,
0x00000000022c783bULL, 0x0004e40000000200ULL, 0x000000201f027810ULL, 0x004fc80007ffe0ffULL,
0xfffffff802027812ULL, 0x000fc800078ec0ffULL, 0x0000000702027812ULL, 0x000fc800078ef81fULL,
0x00000001ff037819ULL, 0x000fe20000011602ULL, 0x0000000402517824ULL, 0x040fe400078e00ffULL,
0x0000000402027824ULL, 0x000fe400078e00ffULL, 0x0000000103507824ULL, 0x040fe200078e026cULL,
0x000000026c6c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fc600078e0252ULL,
0xfffffffc51507812ULL, 0x000fe400078ee250ULL, 0xfffffffc02027812ULL, 0x000fc600078ee203ULL,
0x0000001050507824ULL, 0x000fe200078e0223ULL, 0x00000054008a7306ULL, 0x002fe20000009400ULL,
0x0001000054df7824ULL, 0x040fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe20000011454ULL,
0x0000010054da7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe20000011455ULL,
0x0001000055d27824ULL, 0x040fe200078e00ffULL, 0x00000018ffdf7819ULL, 0x000fe200000114dfULL,
0x0000010055ea7824ULL, 0x000fe200078e00ffULL, 0x0000005400897306ULL, 0x000e620000005400ULL,
0x00000018ffda7819ULL, 0x000fe200000114daULL, 0x000000005058783bULL, 0x000ea20000000200ULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x0000010056c67824ULL, 0x000fe200078e00ffULL,
0x00000018ffea7819ULL, 0x000fe200000114eaULL, 0x0000010057dd7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fe20000011456ULL, 0x000000df00d77306ULL, 0x000fe20000209400ULL,
0x00000018ffc67819ULL, 0x000fe200000114c6ULL, 0x0000001002027824ULL, 0x000fe200078e0223ULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x0001000057dc7824ULL, 0x000fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011457ULL, 0x000100002e977824ULL, 0x008fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe2000001142eULL, 0x000000df00f47306ULL, 0x0006e20000205400ULL,
0x000000898a00720bULL, 0x002fe20003fbd000ULL, 0x000001002e937824ULL, 0x000fe200078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x000100002cb37824ULL, 0x040fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe2000001142cULL, 0x000001002ca27824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe2000001142dULL, 0x000000db00a17306ULL, 0x000fe20000209400ULL,
0x000000df00df7245ULL, 0x008fe2000020d400ULL, 0x000100002da07824ULL, 0x040fe200078e00ffULL,
0x000000000250783bULL, 0x000e620000000200ULL, 0x000001002d9a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fc4000001142fULL, 0x00000018ffb37819ULL, 0x000fe200000114b3ULL,
0x000000db00947306ULL, 0x0006a20000205400ULL, 0x000000f4d700720bULL, 0x000fe40003f7d000ULL,
0x00000018ffa27819ULL, 0x000fe400000114a2ULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x000000da00a57306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x008fe2000020d400ULL, 0x0001000058d97824ULL, 0x004fe200078e00ffULL,
0x00000018ffcc7819ULL, 0x000fc40000011458ULL, 0x00000018ffc07819ULL, 0x000fe40000011459ULL,
0x00000001dfdf3812ULL, 0x000fe200078efcffULL, 0x000000da00f07306ULL, 0x0004e20000205400ULL,
0x00000094a100720bULL, 0x000fe40003fdd000ULL, 0x00000018ffd97819ULL, 0x000fe400000114d9ULL,
0x00000018ffba7819ULL, 0x000fe4000001145aULL, 0x00000018ffb27819ULL, 0x000fe2000001145bULL,
0x0000005400227306ULL, 0x000662000000d400ULL, 0x000000da00da7245ULL, 0x004fc4000020d400ULL,
0x00000018ff977819ULL, 0x000fe40000011497ULL, 0x00000018ff9a7819ULL, 0x000fe4000001149aULL,
0x00000001dbdb6812ULL, 0x000fe200078efcffULL, 0x000000d200d57306ULL, 0x000fe20000209400ULL,
0x0001000056547824ULL, 0x008fe200078e00ffULL, 0x000000f0a500720bULL, 0x000fe40003f7d000ULL,
0x00000018ff837819ULL, 0x002fe40000011450ULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x000000d200f27306ULL, 0x0002a20000205400ULL, 0x0000000122225812ULL, 0x000fe400078efcffULL,
0x00000018ff867819ULL, 0x000fe40000011451ULL, 0x00000022df22723eULL, 0x000fe400000010ffULL,
0x00000001dada3812ULL, 0x000fe200078efcffULL, 0x000000d000cd7306ULL, 0x000fe20000209400ULL,
0x000000d200d27245ULL, 0x002fe4000020d400ULL, 0x00000018ff897819ULL, 0x000fca0000011452ULL,
0x000000d000e87306ULL, 0x0002e20000205400ULL, 0x000000f2d500720bULL, 0x004fe20003fbd000ULL,
0x0000010058d57824ULL, 0x000fca00078e00ffULL, 0x00000018ffd57819ULL, 0x000fe200000114d5ULL,
0x000000ea00cb7306ULL, 0x000fe20000209400ULL, 0x000000d000d07245ULL, 0x002fca000020d400ULL,
0x00000001d2d25812ULL, 0x000fe400078efcffULL, 0x000000ea00ee7306ULL, 0x000e620000205400ULL,
0x000000e8cd00720bULL, 0x008fe40003fdd000ULL, 0x000000ea00cd7245ULL, 0x000fca000020d400ULL,
0x0000005400ec7306ULL, 0x000fec0000209400ULL, 0x00000001d0d06812ULL, 0x000fe400078efcffULL,
0x0000005400ed7306ULL, 0x000ea20000205400ULL, 0x000000eecb00720bULL, 0x002fe20003f7d000ULL,
0x0001000059cb7824ULL, 0x000fca00078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x00000055008d7306ULL, 0x000fec0000009400ULL, 0x00000001cdcd3812ULL, 0x000fe400078efcffULL,
0x00000055008c7306ULL, 0x000e620000005400ULL, 0x000000edec00720bULL, 0x004fce0003fbd000ULL,
0x0000005500c97306ULL, 0x000eb0000000d400ULL, 0x0000005600e27306ULL, 0x000fe20000009400ULL,
0x0000008c8d00720bULL, 0x002fe40003f9d000ULL, 0x00000018ff8c7819ULL, 0x000fca0000011453ULL,
0x00000056008b7306ULL, 0x000e6c0000005400ULL, 0x00000001c9c94812ULL, 0x004fe400078efcffULL,
0x0000005600c17306ULL, 0x000eb0000000d400ULL, 0x0000002d00c57306ULL, 0x000fe20000009400ULL,
0x0000008be200720bULL, 0x002fce0003f3d000ULL, 0x0000002d00c87306ULL, 0x000e6c0000005400ULL,
0x00000001c1c11812ULL, 0x004fe400078efcffULL, 0x000000c600557306ULL, 0x000ff00000209400ULL,
0x000000c600567306ULL, 0x0004e20000205400ULL, 0x000000c8c500720bULL, 0x002fc40003f7d000ULL,
0x0000005400c87245ULL, 0x000fc8000020d400ULL, 0x00000001c8c85812ULL, 0x000fe200078efcffULL,
0x000000c200e67306ULL, 0x000fe20000209400ULL, 0x000000c600c67245ULL, 0x004fce000020d400ULL,
0x000000c200e97306ULL, 0x000e620000205400ULL, 0x000000565500720bULL, 0x008fce0003fdd000ULL,
0x00000057008e7306ULL, 0x000fec0000009400ULL, 0x00000001c6c66812ULL, 0x000fe400078efcffULL,
0x00000057008f7306ULL, 0x000ea20000005400ULL, 0x000000e9e600720bULL, 0x002fce0003fbd000ULL,
0x000000dd00e07306ULL, 0x000ff00000209400ULL, 0x000000dd00e37306ULL, 0x000e620000205400ULL,
0x0000008f8e00720bULL, 0x004fe20003f5d000ULL, 0x000100002f8f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0000002300d87306ULL, 0x000ff00000209400ULL,
0x0000002300d37306ULL, 0x000ea20000205400ULL, 0x000000e3e000720bULL, 0x002fc40003fdd000ULL,
0x000000c200e37245ULL, 0x000fe4000020d400ULL, 0x000000dc00c27245ULL, 0x000fe4000020d400ULL,
0x00000001e3e35812ULL, 0x000fe200078efcffULL, 0x0000005700bb7306ULL, 0x0002f0000000d400ULL,
0x0000005800d17306ULL, 0x000fe20000009400ULL, 0x000000d3d800720bULL, 0x004fe20003fbd000ULL,
0x0000000879577824ULL, 0x002fcc00078e026eULL, 0x0000005800d67306ULL, 0x000e620000005400ULL,
0x00000001bbbb2812ULL, 0x008fce00078efcffULL, 0x0000002e00b57306ULL, 0x000ff00000009400ULL,
0x0000002e00b47306ULL, 0x000fe20000005400ULL, 0x000000d6d100720bULL, 0x002fe40003f5d000ULL,
0x0000002300d67245ULL, 0x000fc4000020d400ULL, 0x000000dadb23723eULL, 0x000fe400000010ffULL,
0x00000001d6d65812ULL, 0x000fe200078efcffULL, 0x0000002e007c7306ULL, 0x0003f0000000d400ULL,
0x000000dc00e47306ULL, 0x000fe20000209400ULL, 0x000000081f2e7812ULL, 0x002fce00078ec0ffULL,
0x000000dc00e77306ULL, 0x0002b00000205400ULL, 0x0000002c00ce7306ULL, 0x000fe20000009400ULL,
0x000001005bdc7824ULL, 0x002fca00078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe400000114dcULL,
0x0000002c00eb7306ULL, 0x000e620000005400ULL, 0x000000e7e400720bULL, 0x004fe20003f3d000ULL,
0x000100005be47824ULL, 0x000fca00078e00ffULL, 0x00000018ffd37819ULL, 0x000fe200000114e4ULL,
0x0000002c00807306ULL, 0x0004ec000000d400ULL, 0x00000001c2c21812ULL, 0x000fe400078efcffULL,
0x0000002d007f7306ULL, 0x0007e2000000d400ULL, 0x0000002e1f2c7211ULL, 0x004fc400078fe0ffULL,
0x000000072e2e7812ULL, 0x000fe400078ef81fULL, 0x000000ebce00720bULL, 0x002fc60003f9d000ULL,
0x000000cc00cf7306ULL, 0x000fe20000209400ULL, 0x000000071f2d7812ULL, 0x008fe200078ec0ffULL,
0x000000102ef07824ULL, 0x040fe400078e00ffULL, 0x000000102ef27824ULL, 0x040fe200078e00ffULL,
0x000000102e2e7812ULL, 0x000fe200078efcffULL, 0x000000012d2c7824ULL, 0x000fe400078e022cULL,
0x000000cc00d47306ULL, 0x0002a20000205400ULL, 0x00000008792d7824ULL, 0x000fe200078e02deULL,
0x0000000180804812ULL, 0x000fc400078efcffULL, 0x0000006d2ca57210ULL, 0x140fe20007ffe0deULL,
0x000000012c2d7824ULL, 0x040fe200078e022dULL, 0x0000006f2ca17210ULL, 0x040fe20007ffe0deULL,
0x000000012c2c7824ULL, 0x000fe200078e0257ULL, 0x0000005900ca7306ULL, 0x000fe20000009400ULL,
0x000000102e577824ULL, 0x000fe200078e00ffULL, 0xfffffff0f02d7812ULL, 0x000fe200078ee22dULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x000000cc00cc7245ULL, 0x002fe4000020d400ULL,
0xfffffff0572c7812ULL, 0x000fe200078ee22cULL, 0x000000102d577824ULL, 0x000fe200078e00ffULL,
0x0000005900037306ULL, 0x000fe20000005400ULL, 0x000000d4cf00720bULL, 0x004fc40003fbd000ULL,
0x000000102c2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff02ea17812ULL, 0x000fe200078ee2a1ULL,
0x000000005754783bULL, 0x000e620000000200ULL, 0x000000d500cf7245ULL, 0x000fe4000020d400ULL,
0x0000005900b07306ULL, 0x0005e2000000d400ULL, 0x000000017f7f3812ULL, 0x000fe400078efcffULL,
0xfffffff0f2a57812ULL, 0x000fc600078ee2a5ULL, 0x00000001cccc5812ULL, 0x000fe400078efcffULL,
0x000000d900e27306ULL, 0x000fe20000209400ULL, 0x0000010059597824ULL, 0x004fca00078e00ffULL,
0x00000018ffc57819ULL, 0x000fe20000011459ULL, 0x000100005a597824ULL, 0x000fe200078e00ffULL,
0x000000d900e57306ULL, 0x000ea80000205400ULL, 0x00000018ff597819ULL, 0x000fc80000011459ULL,
0x000000c500ce7306ULL, 0x000ff00000209400ULL, 0x000000c500e97306ULL, 0x0006e20000205400ULL,
0x000000e5e200720bULL, 0x004fe20003f3d000ULL, 0x000000225430723cULL, 0x002fec0000041830ULL,
0x000000cb00d77306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x008fce000020d400ULL,
0x000000cb00e87306ULL, 0x0003e20000205400ULL, 0x000000e9ce00720bULL, 0x000fce0003fbd000ULL,
0x0000005800b17306ULL, 0x0004e2000000d400ULL, 0x000000cb00cb7245ULL, 0x002fca000020d400ULL,
0x00000001c5c55812ULL, 0x000fe400078efcffULL, 0x0000002f00ae7306ULL, 0x000fe20000009400ULL,
0x000001002f587824ULL, 0x004fce00078e00ffULL, 0x0000002f00af7306ULL, 0x000fe20000005400ULL,
0x00000001b1b12812ULL, 0x008fe400078efcffULL, 0x00000003ca00720bULL, 0x000fe40003f5d000ULL,
0x000000cdd003723eULL, 0x000fc600000010ffULL, 0x0000002f007e7306ULL, 0x0003f0000000d400ULL,
0x0000005a00027306ULL, 0x000fe20000009400ULL, 0x000000002c2c783bULL, 0x002e620000000200ULL,
0x00000001b0b02812ULL, 0x000fcc00078efcffULL, 0x0000005a00c77306ULL, 0x000ff00000005400ULL,
0x0000005a00aa7306ULL, 0x0005f0000000d400ULL, 0x0000005b00be7306ULL, 0x000fe20000009400ULL,
0x000001005a5a7824ULL, 0x004fca00078e00ffULL, 0x00000018ffd17819ULL, 0x000fe4000001145aULL,
0x0000005b00bf7306ULL, 0x000ea20000005400ULL, 0x000000d9005a7245ULL, 0x000fc8000020d400ULL,
0x000000015a5a1812ULL, 0x000fe400078efcffULL, 0x000000e8d700720bULL, 0x000fe20003f3d000ULL,
0x000000d500de7306ULL, 0x000fe20000209400ULL, 0x000000222c34723cULL, 0x002be20000041834ULL,
0x000000b15a5a723eULL, 0x000fcc00000010ffULL, 0x000000d500e17306ULL, 0x000fe20000205400ULL,
0x000000bfbe00720bULL, 0x004fe40003fbd000ULL, 0x000000c1c822723eULL, 0x020fe400000010ffULL,
0x00000001cbcb1812ULL, 0x000fe400078efcffULL, 0x000000c6e323723eULL, 0x000fe200000010ffULL,
0x000000c000c37306ULL, 0x000fec0000209400ULL, 0x000000225440723cULL, 0x080fe40000041840ULL,
0x000000c000c47306ULL, 0x0002ac0000205400ULL, 0x000000222c44723cULL, 0x000fe40000041844ULL,
0x0000005b00a77306ULL, 0x0006a2000000d400ULL, 0x000000c000c07245ULL, 0x002fce000020d400ULL,
0x000000b300b87306ULL, 0x000fe20000209400ULL, 0x000000dd005b7245ULL, 0x008fe4000020d400ULL,
0x000000c4c300720bULL, 0x004fe40003f3d000ULL, 0x000000015b5b6812ULL, 0x000fe400078efcffULL,
0x000000e1de00720bULL, 0x000fe20003fdd000ULL, 0x000000b300b97306ULL, 0x0002a20000205400ULL,
0x00000001a7a75812ULL, 0x000fe400078efcffULL, 0xfffffff46ede7810ULL, 0x000fca0007ffe0ffULL,
0x0000005900e07306ULL, 0x000fe20000209400ULL, 0x00000001c0c01812ULL, 0x000fe400078efcffULL,
0x000000b300b37245ULL, 0x002fe4000020d400ULL, 0x00000001cfcf6812ULL, 0x000fe400078efcffULL,
0x000000c70200720bULL, 0x000fe20003fdd000ULL, 0x0000005900e57306ULL, 0x0002e20000205400ULL,
0x000000b9b800720bULL, 0x004fe40003fbd000ULL, 0x000000c9d202723eULL, 0x000fca00000010ffULL,
0x000000d100d87306ULL, 0x000fe20000209400ULL, 0x0000005900597245ULL, 0x002fe2000020d400ULL,
0x000000025438723cULL, 0x080fe40000041838ULL, 0x00000001aaaa6812ULL, 0x000fe400078efcffULL,
0x00000001b3b35812ULL, 0x000fe400078efcffULL, 0x000000d100d77306ULL, 0x0002a20000205400ULL,
0x000000e5e000720bULL, 0x008fe20003f5d000ULL, 0x000000022c3c723cULL, 0x000be2000004183cULL,
0x00000080b380723eULL, 0x000fca00000010ffULL, 0x000000a200ac7306ULL, 0x000fe20000209400ULL,
0x000000d100d17245ULL, 0x002fe4000020d400ULL, 0x000000bbc202723eULL, 0x020fe400000010ffULL,
0x0000005bd603723eULL, 0x000fe400000010ffULL, 0x0000000159592812ULL, 0x000fe200078efcffULL,
0x000000a200ad7306ULL, 0x0002e20000205400ULL, 0x000000d7d800720bULL, 0x004fe40003f3d000ULL,
0x000000aa5922723eULL, 0x000fe200000010ffULL, 0x0001000051aa7824ULL, 0x000fe200078e00ffULL,
0x000000025448723cULL, 0x000fe20000041848ULL, 0x000000cfcc5b723eULL, 0x000fc400000010ffULL,
0x000000ba00bc7306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fe4000020d400ULL,
0x00000018ffaa7819ULL, 0x000fe400000114aaULL, 0x000000022c4c723cULL, 0x000b62000004184cULL,
0x00000001d1d11812ULL, 0x000fe400078efcffULL, 0x000000ba00bd7306ULL, 0x0002a20000205400ULL,
0x000000adac00720bULL, 0x008fe20003fbd000ULL, 0x0000010051ad7824ULL, 0x000fe200078e00ffULL,
0x000000b4b500720bULL, 0x000fe20003f3d000ULL, 0x0001000050b57824ULL, 0x000fe200078e00ffULL,
0x000000b0cb02723eULL, 0x020fe200000010ffULL, 0x0000005a5428723cULL, 0x000fe20000041828ULL,
0x000000c5c003723eULL, 0x000fe200000010ffULL, 0x000000d300c77306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fe2000020d400ULL, 0x0000010052b07824ULL, 0x000fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fc400000114b5ULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x000000025424723cULL, 0x080fe20000041824ULL, 0x00000001a2a25812ULL, 0x000fe200078efcffULL,
0x000000d300ca7306ULL, 0x000e620000205400ULL, 0x000000bdbc00720bULL, 0x004fe40003f5d000ULL,
0x00000018ffbc7819ULL, 0x000fe40000011458ULL, 0x000000d300587245ULL, 0x000fe2000020d400ULL,
0x000000022c0c723cULL, 0x000be2000004180cULL, 0x000000017c7c1812ULL, 0x000fe200078efcffULL,
0x00000090009f7306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fc800000114b0ULL,
0x0000007300027245ULL, 0x020fe2000020d400ULL, 0x0000005a2c10723cULL, 0x000f620000041810ULL,
0x00000001baba2812ULL, 0x000fe200078efcffULL, 0x00000090009e7306ULL, 0x0004e20000205400ULL,
0x000000cac700720bULL, 0x002fe40003fdd000ULL, 0x000000d1ba23723eULL, 0x000fca00000010ffULL,
0x000000dc00c17306ULL, 0x000fe20000209400ULL, 0x0000009000907245ULL, 0x004fe2000020d400ULL,
0x000000225414723cULL, 0x080fe80000041814ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x000000dc00be7306ULL, 0x0002a20000205400ULL, 0x0000009e9f00720bULL, 0x008fe20003fbd000ULL,
0x000000222c08723cULL, 0x000b620000041808ULL, 0x000000a75858723eULL, 0x000fe200000010ffULL,
0x0000010053a77824ULL, 0x000fc800078e00ffULL, 0x000000b200b67306ULL, 0x000fe20000209400ULL,
0x000000dc00dc7245ULL, 0x002fe4000020d400ULL, 0x000000b500227245ULL, 0x020fe4000020d400ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x0000000190905812ULL, 0x000fe200078efcffULL,
0x000000b200b77306ULL, 0x000e620000205400ULL, 0x000000bec100720bULL, 0x004fce0003f5d000ULL,
0x0000008f00947306ULL, 0x000fec0000209400ULL, 0x00000001dcdc2812ULL, 0x000fe400078efcffULL,
0x0000008f00bb7306ULL, 0x0004e20000205400ULL, 0x000000b7b600720bULL, 0x002fe40003fdd000ULL,
0x000000afae00720bULL, 0x000fc40003f5d000ULL, 0x000000b200af7245ULL, 0x000fe2000020d400ULL,
0x0001000053b27824ULL, 0x000fe400078e00ffULL, 0x0000009300987306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x004fe4000020d400ULL, 0x00000018ffb27819ULL, 0x000fc600000114b2ULL,
0x00000001afaf6812ULL, 0x000fe400078efcffULL, 0x0000009300997306ULL, 0x0002a20000205400ULL,
0x000000bb9400720bULL, 0x008fe40003f3d000ULL, 0x000000017e7e2812ULL, 0x000fe400078efcffULL,
0x000000dcaf59723eULL, 0x000fe200000010ffULL, 0x0001000052af7824ULL, 0x000fe400078e00ffULL,
0x000000a000a67306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fc4000020d400ULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x000000582c04723cULL, 0x080fe40000041804ULL,
0x000000018f8f1812ULL, 0x000fe400078efcffULL, 0x000000a000a97306ULL, 0x0002e20000205400ULL,
0x000000999800720bULL, 0x004fe40003fbd000ULL, 0x0000007e8f7e723eULL, 0x000fe200000010ffULL,
0x000000585418723cULL, 0x000b680000041818ULL, 0x0000009d00ab7306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x002fc4000020d400ULL, 0x00000010a1547824ULL, 0x020fe200078e00ffULL,
0x0000009a00a17245ULL, 0x000fe4000020d400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x0000009d00a87306ULL, 0x0002a20000205400ULL, 0x000000a9a600720bULL, 0x008fe20003f9d000ULL,
0x000000005454783bULL, 0x000eec0000000200ULL, 0x0000007300777306ULL, 0x000fe20000209400ULL,
0x0000009d009d7245ULL, 0x002fca000020d400ULL, 0x00000001a0a04812ULL, 0x000fe400078efcffULL,
0x0000007300767306ULL, 0x0002620000205400ULL, 0x000000a8ab00720bULL, 0x004fe40003fdd000ULL,
0x0000007fa0a0723eULL, 0x000fe400000010ffULL, 0x000000bc007f7245ULL, 0x000fc6000020d400ULL,
0x000000bc00b47306ULL, 0x000fe20000209400ULL, 0x000000ad00737245ULL, 0x002fca000020d400ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x000000bc00b77306ULL, 0x000e620000205400ULL,
0x000000767700720bULL, 0x000fce0003f3d000ULL, 0x0000005000917306ULL, 0x000fec0000009400ULL,
0x0000000102021812ULL, 0x000fe400078efcffULL, 0x0000005000927306ULL, 0x000fe20000005400ULL,
0x000000b7b400720bULL, 0x002fce0003fbd000ULL, 0x00000050007b7306ULL, 0x0003ec000000d400ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x000000b500b17306ULL, 0x000fe20000209400ULL,
0x0000010050507824ULL, 0x002fe200078e00ffULL, 0x0000007f027f723eULL, 0x000fc400000010ffULL,
0x0000008300027245ULL, 0x000fe4000020d400ULL, 0x00000018ffa87819ULL, 0x000fe20000011450ULL,
0x00000010a5507824ULL, 0x000fe200078e00ffULL, 0x000000b500ae7306ULL, 0x000e620000205400ULL,
0x0000007e544c723cULL, 0x008b62000004184cULL, 0x000000a800237245ULL, 0x000fcc000020d400ULL,
0x00000097009b7306ULL, 0x000ff00000209400ULL, 0x00000097009c7306ULL, 0x0004e20000205400ULL,
0x000000aeb100720bULL, 0x002fce0003f5d000ULL, 0x0000008300847306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x004fca000020d400ULL, 0x0000000122222812ULL, 0x000fe400078efcffULL,
0x0000008300857306ULL, 0x000e620000205400ULL, 0x0000009c9b00720bULL, 0x008fce0003f9d000ULL,
0x000000a800ab7306ULL, 0x000fec0000209400ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x000000a800ac7306ULL, 0x000ea20000205400ULL, 0x000000858400720bULL, 0x002fe40003f3d000ULL,
0x0000007c977c723eULL, 0x000fca00000010ffULL, 0x0000007000967306ULL, 0x000fec0000209400ULL,
0x0000000102021812ULL, 0x000fe400078efcffULL, 0x0000007000957306ULL, 0x0002e20000205400ULL,
0x000000acab00720bULL, 0x004fce0003fbd000ULL, 0x0000009a00a37306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fca000020d400ULL, 0x0000000123235812ULL, 0x000fe400078efcffULL,
0x0000009a00a47306ULL, 0x000e620000205400ULL, 0x000000959600720bULL, 0x008fe40003f7d000ULL,
0x000000230223723eULL, 0x000fe400000010ffULL, 0x0000008900027245ULL, 0x000fc6000020d400ULL,
0x000000aa00a67306ULL, 0x000fec0000209400ULL, 0x0000000170703812ULL, 0x000fe400078efcffULL,
0x000000aa009f7306ULL, 0x000ea20000205400ULL, 0x000000a4a300720bULL, 0x002fce0003fdd000ULL,
0x0000005100827306ULL, 0x000fec0000009400ULL, 0x00000001a1a16812ULL, 0x000fe400078efcffULL,
0x0000005100817306ULL, 0x000e620000005400ULL, 0x0000009fa600720bULL, 0x004fe40003f5d000ULL,
0x000000929100720bULL, 0x000fc40003fdd000ULL, 0x000000a190a1723eULL, 0x000fc600000010ffULL,
0x0000008600877306ULL, 0x000fe80000209400ULL, 0x000000a0543c723cULL, 0x000b68000004183cULL,
0x0000008600887306ULL, 0x0004e20000205400ULL, 0x000000818200720bULL, 0x002fe40003f9d000ULL,
0x000000017b7b6812ULL, 0x000fc400078efcffULL, 0x000000a29d81723eULL, 0x000fe400000010ffULL,
0x0000007b2222723eULL, 0x000fe200000010ffULL, 0x000000ad005a7306ULL, 0x000fe20000209400ULL,
0x0000008600867245ULL, 0x004fc6000020d400ULL, 0x000000805434723cULL, 0x000b680000041834ULL,
0x000000ad00037306ULL, 0x000e620000205400ULL, 0x000000888700720bULL, 0x008fc60003f3d000ULL,
0x000000225410723cULL, 0x000b680000041810ULL, 0x0000005200717306ULL, 0x000fec0000009400ULL,
0x0000000186861812ULL, 0x000fc400078efcffULL, 0x0000005200787306ULL, 0x000ea20000005400ULL,
0x000000035a00720bULL, 0x002fe40003fbd000ULL, 0x000000aa00037245ULL, 0x000fc8000020d400ULL,
0x0000000103032812ULL, 0x000fe200078efcffULL, 0x000000af005b7306ULL, 0x000fec0000209400ULL,
0x0000000173735812ULL, 0x000fe400078efcffULL, 0x000000af002c7306ULL, 0x000e620000205400ULL,
0x000000787100720bULL, 0x004fc40003f7d000ULL, 0x000000738673723eULL, 0x000fca00000010ffULL,
0x0000005100727306ULL, 0x000eb0000000d400ULL, 0x00000089008a7306ULL, 0x000fe20000209400ULL,
0x0000002c5b00720bULL, 0x002fe40003f5d000ULL, 0x000000af002c7245ULL, 0x000fca000020d400ULL,
0x00000089008b7306ULL, 0x000e620000205400ULL, 0x0000000172724812ULL, 0x004fc800078efcffULL,
0x000000720372723eULL, 0x000fe400000010ffULL, 0x000000012c2c2812ULL, 0x000fe200078efcffULL,
0x000000b0002d7306ULL, 0x000fe20000209400ULL, 0x000000b200037245ULL, 0x000fc6000020d400ULL,
0x00000072540c723cULL, 0x000b68000004180cULL, 0x000000b0002e7306ULL, 0x000ea20000205400ULL,
0x0000008b8a00720bULL, 0x002fce0003f9d000ULL, 0x0000005200757306ULL, 0x000e6c000000d400ULL,
0x0000000102024812ULL, 0x000fe400078efcffULL, 0x00000053007a7306ULL, 0x000fe20000009400ULL,
0x0000002e2d00720bULL, 0x004fe40003f3d000ULL, 0x000000b0002d7245ULL, 0x000fca000020d400ULL,
0x00000053007d7306ULL, 0x000ea20000005400ULL, 0x0000000175753812ULL, 0x002fc800078efcffULL,
0x000000752c2c723eULL, 0x000fe400000010ffULL, 0x000000012d2d1812ULL, 0x000fe200078efcffULL,
0x0000005300747306ULL, 0x0002e2000000d400ULL, 0x000000a700757245ULL, 0x000fe4000020d400ULL,
0x0000002d022d723eULL, 0x000fe400000010ffULL, 0x000000046e027810ULL, 0x000fc60007ffe0ffULL,
0x0000008c008d7306ULL, 0x000fe20000209400ULL, 0x000000005050783bULL, 0x002e620000000200ULL,
0x0000007d7a00720bULL, 0x004fe20003fdd000ULL, 0x0000002c5408723cULL, 0x040b620000041808ULL,
0x000000180200780cULL, 0x000fe20003f25270ULL, 0x000000ffff6e7224ULL, 0x000fe200078e0002ULL,
0x00000093707d723eULL, 0x000fe400000010ffULL, 0x0000008c008e7306ULL, 0x0004aa0000205400ULL,
0x0000007c5444723cULL, 0x000b640000041844ULL, 0x0000000174746812ULL, 0x008fe200078efcffULL,
0x000000b2002f7306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x004fce000020d400ULL,
0x000000b200587306ULL, 0x000ea20000205400ULL, 0x0000008e8d00720bULL, 0x000fce0003fbd000ULL,
0x000000a700597306ULL, 0x000fec0000209400ULL, 0x000000018c8c5812ULL, 0x000fe400078efcffULL,
0x000000a7005a7306ULL, 0x000ee20000205400ULL, 0x000000582f00720bULL, 0x004fe20003f5d000ULL,
0x000000805030723cULL, 0x042b700000041830ULL, 0x000000a05038723cULL, 0x000b680000041838ULL,
0x0000000103032812ULL, 0x000fc400078efcffULL, 0x0000005a5900720bULL, 0x008fe40003f7d000ULL,
0x000000740374723eULL, 0x000fe200000010ffULL, 0x0000007e5048723cULL, 0x040b700000041848ULL,
0x0000007c5040723cULL, 0x000b640000041840ULL, 0x0000000175753812ULL, 0x000fc800078efcffULL,
0x000000758c75723eULL, 0x000fe400000010ffULL, 0x000000225028723cULL, 0x040b700000041828ULL,
0x000000725024723cULL, 0x040b700000041824ULL, 0x0000002c5014723cULL, 0x040b700000041814ULL,
0x000000745018723cULL, 0x080b700000041818ULL, 0x000000745404723cULL, 0x000b620000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffdee000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff6b7224ULL, 0x000fe200078e0065ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd14000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x000000603b3b7220ULL, 0x0a0fe20000410000ULL,
0x0000006038517220ULL, 0x080fe20000410000ULL, 0x0000006040407220ULL, 0x080fe20000410000ULL,
0x0000006042427220ULL, 0x080fe20000410000ULL, 0x0000006043437220ULL, 0x080fe20000410000ULL,
0x0000006049547220ULL, 0x080fe20000410000ULL, 0x0000006032327220ULL, 0x080fe20000410000ULL,
0x0000006033337220ULL, 0x080fe20000410000ULL, 0x0000006041417220ULL, 0x080fe20000410000ULL,
0x0000006048487220ULL, 0x080fe20000410000ULL, 0x0000006028557220ULL, 0x080fe20000410000ULL,
0x0000006029297220ULL, 0x080fe20000410000ULL, 0x000000602a2a7220ULL, 0x080fe20000410000ULL,
0x000000602b2b7220ULL, 0x080fe20000410000ULL, 0x0000006026267220ULL, 0x080fe20000410000ULL,
0x0000006027277220ULL, 0x080fe20000410000ULL, 0x0000006014497220ULL, 0x080fe20000410000ULL,
0x0000006017387220ULL, 0x080fe20000410000ULL, 0x000000604a027220ULL, 0x080fe20000410000ULL,
0x000000604b037220ULL, 0x080fe20000410000ULL, 0x0000006015157220ULL, 0x080fe20000410000ULL,
0x0000006016167220ULL, 0x080fe20000410000ULL, 0x0000006018187220ULL, 0x080fe20000410000ULL,
0x0000006019197220ULL, 0x080fe20000410000ULL, 0x000000601a1a7220ULL, 0x080fe20000410000ULL,
0x000000601b1b7220ULL, 0x080fe20000410000ULL, 0x0000006034347220ULL, 0x080fe20000410000ULL,
0x0000006035147220ULL, 0x080fe20000410000ULL, 0x000000603c287220ULL, 0x080fe20000410000ULL,
0x000000603d177220ULL, 0x080fe20000410000ULL, 0x0000006044227220ULL, 0x080fe20000410000ULL,
0x0000006045237220ULL, 0x080fe20000410000ULL, 0x0000006009097220ULL, 0x080fe20000410000ULL,
0x0000006004047220ULL, 0x080fe20000410000ULL, 0x0000006039507220ULL, 0x080fe20000410000ULL,
0x00000060244b7220ULL, 0x080fe20000410000ULL, 0x000000604f5b7220ULL, 0x080fe20000410000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e003bULL, 0x0000006030537220ULL, 0x080fe20000410000ULL,
0x000000603a397220ULL, 0x080fe20000410000ULL, 0x00000060254a7220ULL, 0x080fe20000410000ULL,
0x0000006036247220ULL, 0x080fe20000410000ULL, 0x000000603e567220ULL, 0x080fe20000410000ULL,
0x000000604c2c7220ULL, 0x080fe20000410000ULL, 0x000000604d2d7220ULL, 0x080fe20000410000ULL,
0x000000604e5a7220ULL, 0x080fe20000410000ULL, 0x000000ffff4f7224ULL, 0x000fe200078e0040ULL,
0x0000006031527220ULL, 0x080fe20000410000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0042ULL,
0x0000006037257220ULL, 0x080fe20000410000ULL, 0x000000ffff447224ULL, 0x000fe200078e0043ULL,
0x000000603f577220ULL, 0x080fe20000410000ULL, 0x0000006046587220ULL, 0x080fe20000410000ULL,
0x0000006047597220ULL, 0x080fe20000410000ULL, 0x00000060102e7220ULL, 0x080fe20000410000ULL,
0x00000060112f7220ULL, 0x080fe20000410000ULL, 0x000000600c307220ULL, 0x080fe20000410000ULL,
0x0000006008367220ULL, 0x080fe20000410000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e0041ULL,
0x0000006012127220ULL, 0x080fe20000410000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e0048ULL,
0x0000006013137220ULL, 0x080fe20000410000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0029ULL,
0x000000600d317220ULL, 0x080fe20000410000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0032ULL,
0x000000600e107220ULL, 0x080fe20000410000ULL, 0x000000ffff457224ULL, 0x000fe200078e0033ULL,
0x000000600f117220ULL, 0x080fe20000410000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e002aULL,
0x000000600a0a7220ULL, 0x080fe20000410000ULL, 0x000000ffff437224ULL, 0x000fe200078e002bULL,
0x000000600b0b7220ULL, 0x080fe20000410000ULL, 0x000000ffff407224ULL, 0x000fe200078e0026ULL,
0x0000006005057220ULL, 0x080fe20000410000ULL, 0x000000ffff427224ULL, 0x000fe200078e0027ULL,
0x0000006006087220ULL, 0x080fe20000410000ULL, 0x00000060070c7220ULL, 0x000fe20000410000ULL,
0x000000ffff487224ULL, 0x000fc400078e0015ULL, 0x000000ffff477224ULL, 0x000fe400078e0018ULL,
0x000000ffff467224ULL, 0x000fe400078e0019ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0002ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0003ULL, 0x000000ffff417224ULL, 0x000fe400078e0016ULL,
0x000000ffff377224ULL, 0x000fc400078e001aULL, 0x000000ffff357224ULL, 0x000fe400078e001bULL,
0x000000ffff277224ULL, 0x000fe400078e0034ULL, 0x000000ffff267224ULL, 0x000fe400078e0014ULL,
0x000000ffff297224ULL, 0x000fe400078e0017ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0022ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0023ULL, 0x000000ffff327224ULL, 0x000fe400078e0009ULL,
0x000000ffff337224ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000061067f8cULL, 0x0002a2000c80043fULL, 0x000000ffff227224ULL, 0x000fe400078e0024ULL,
0x000000ffff187224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0013ULL,
0x000000ffff347224ULL, 0x000fc400078e0005ULL, 0x000000ffff237224ULL, 0x000fe400078e0056ULL,
0x000000ffff247224ULL, 0x000fe400078e0057ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0058ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0059ULL, 0x000000ffff197224ULL, 0x000fe400078e005aULL,
0x000000ffff177224ULL, 0x000fc400078e005bULL, 0x000000ffff127224ULL, 0x000fe400078e000aULL,
0x000000ffff137224ULL, 0x000fe400078e000bULL, 0x000000ffff147224ULL, 0x000fe400078e0008ULL,
0x000000ffff157224ULL, 0x000fc400078e000cULL, 0x0000000000027805ULL, 0x006fca0000015200ULL,
0x0000040061057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040061057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000041f0f7824ULL, 0x000fe200078e00ffULL, 0x000000686300720cULL, 0x000fc80003f06070ULL,
0xfffffff00f037812ULL, 0x000fca00078ec0ffULL, 0x00000080200e7824ULL, 0x000fca00078e0203ULL,
0x012400000e047984ULL, 0x0002a20000000c00ULL, 0x00001f6000008947ULL, 0x000fea0003800000ULL,
0x0000010063037824ULL, 0x000fe200078e025dULL, 0x000000001f027211ULL, 0x040fe200078ff0ffULL,
0x000000021f577824ULL, 0x000fe400078e00ffULL, 0x00000002ff7c7424ULL, 0x000fe200078e00ffULL,
0x000000031e567217ULL, 0x000fe40007800000ULL, 0x0000000657577812ULL, 0x000fe400078ec0ffULL,
0x0000000802087810ULL, 0x000fe20007ffe0ffULL, 0x0000000156567824ULL, 0x000fe200078e0a03ULL,
0x00005a00ff037a19ULL, 0x000fe20000011602ULL, 0x0000000167097824ULL, 0x000fe200078e0257ULL,
0x0000580057597a10ULL, 0x000fc40007ffe0ffULL, 0x00000010020a7810ULL, 0x040fe40007ffe0ffULL,
0x000000560900720cULL, 0x0c0fe20003f26070ULL, 0x0000000109097824ULL, 0x100fe200078e0a56ULL,
0x0000001802587810ULL, 0x000fe40007ffe0ffULL, 0x0000000366027217ULL, 0x040fe20003800000ULL,
0x0000000159037824ULL, 0x040fe200078e0a56ULL, 0x0000000966097217ULL, 0x040fe40003800000ULL,
0x000000565900720cULL, 0x000fe20003f06070ULL, 0x00000002698b7224ULL, 0x000fe200078e02ffULL,
0x0000000366037217ULL, 0x000fc40003800000ULL, 0x00000004ff097819ULL, 0x000fe40000011609ULL,
0x00005a00ff0b7a19ULL, 0x000fe40000011608ULL, 0x000000ff037a7207ULL, 0x000fe40000000000ULL,
0x000000ff090c7207ULL, 0x000fe40000800000ULL, 0x0000000b66087217ULL, 0x000fe40003800000ULL,
0x00005a00ff0d7a19ULL, 0x000fe2000001160aULL, 0x000000018b097824ULL, 0x000fe200078e020cULL,
0x0000008b7a037211ULL, 0x000fe200078fe0ffULL, 0x0000000869917224ULL, 0x000fe200078e02ffULL,
0x00005a00ff5b7a19ULL, 0x000fe20000011658ULL, 0x0000600009087625ULL, 0x000fe200078e007cULL,
0x0000000d66587217ULL, 0x000fc40003800000ULL, 0x0000005b665a7217ULL, 0x000fe20003800000ULL,
0x0000600003027625ULL, 0x000fe200078e007cULL, 0x00000008085b7981ULL, 0x0046a2000c1e9500ULL,
0x000000917a0b7211ULL, 0x000fe400078fe0ffULL, 0x0000005869937224ULL, 0x040fe400078e02ffULL,
0x0000000802587981ULL, 0x0002a2000c1e9500ULL, 0x0000005a69957224ULL, 0x000fe200078e02ffULL,
0x0000001057777812ULL, 0x000fe200078efcffULL, 0x000000010c0d7824ULL, 0x000fe200078e0291ULL,
0x000000937a6b7211ULL, 0x000fe200078fe0ffULL, 0x000000010c6f7824ULL, 0x000fc400078e0293ULL,
0x000060000b0a7625ULL, 0x000fe200078e007cULL, 0x0000580077757a10ULL, 0x000fc60007ffe0ffULL,
0x000000010c717824ULL, 0x000fe200078e0295ULL, 0x000000080a5a7981ULL, 0x0006a2000c1e9500ULL,
0x000060006b6a7625ULL, 0x000fc800078e007cULL, 0x000060000d0c7625ULL, 0x080fe200078e007cULL,
0x000000086a6e7981ULL, 0x0006a6000c1e9500ULL, 0x000060006f027625ULL, 0x002fc800078e007cULL,
0x0000000167797824ULL, 0x000fe200078e0277ULL, 0x0000000802737981ULL, 0x0002a2000c1e9500ULL,
0x00006000710a7625ULL, 0x008fc600078e007cULL, 0x000000080c717981ULL, 0x0006a2000c1e9500ULL,
0x00000001797b7824ULL, 0x100fe400078e0a56ULL, 0x0000000175097824ULL, 0x040fe200078e0a56ULL,
0x000000957a6d7211ULL, 0x000fe200078fe0ffULL, 0x000000080a707981ULL, 0x0002a2000c1e9500ULL,
0x0000007b667b7217ULL, 0x040fe40003800000ULL, 0x000000567500720cULL, 0x000fe40003f06070ULL,
0x0000000966097217ULL, 0x000fe20003800000ULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x000000567900720cULL, 0x000fc40003f26070ULL, 0x00000004ff7b7819ULL, 0x000fe4000001167bULL,
0x000000ff09827207ULL, 0x000fe20000000000ULL, 0x000000086c6f7981ULL, 0x0002a2000c1e9500ULL,
0x000000ff7b0c7207ULL, 0x008fe40000800000ULL, 0x0000008b82037211ULL, 0x042fe400078fe0ffULL,
0x00000091820b7211ULL, 0x000fe200078fe0ffULL, 0x000000018b097824ULL, 0x000fe200078e020cULL,
0x00000020577f7812ULL, 0x000fe200078efcffULL, 0x000000010c0d7824ULL, 0x000fc400078e0291ULL,
0x0000600003027625ULL, 0x000fc800078e007cULL, 0x000000010c7b7824ULL, 0x040fe200078e0293ULL,
0x0000000802727981ULL, 0x0002e2000c1e9500ULL, 0x000000010c7d7824ULL, 0x000fe400078e0295ULL,
0x000060000b0a7625ULL, 0x000fe200078e007cULL, 0x000058007f817a10ULL, 0x000fc60007ffe0ffULL,
0x0000600009087625ULL, 0x080fe200078e007cULL, 0x000000080a747981ULL, 0x0002e6000c1e9500ULL,
0x000060000d0c7625ULL, 0x080fe200078e007cULL, 0x0000000808797981ULL, 0x0002e6000c1e9500ULL,
0x0000000167857824ULL, 0x000fe400078e027fULL, 0x000060007b027625ULL, 0x002fc400078e007cULL,
0x000000080c7b7981ULL, 0x0002e4000c1e9500ULL, 0x0000000185877824ULL, 0x100fe200078e0a56ULL,
0x00000093826b7211ULL, 0x040fe200078fe0ffULL, 0x0000000181097824ULL, 0x000fe200078e0a56ULL,
0x00000095826d7211ULL, 0x000fe400078fe0ffULL, 0x0000008766877217ULL, 0x040fe20003800000ULL,
0x000060006b6a7625ULL, 0x000fe200078e007cULL, 0x000000568100720cULL, 0x000fe40003f06070ULL,
0x0000000966097217ULL, 0x000fe20003800000ULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x000000568500720cULL, 0x000fe20003f26070ULL, 0x000000086a767981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff877819ULL, 0x000fe20000011687ULL, 0x000060007d0a7625ULL, 0x000fe200078e007cULL,
0x000000ff09887207ULL, 0x000fe20000000000ULL, 0x00000008027d7981ULL, 0x0002e8000c1e9500ULL,
0x000000086c787981ULL, 0x0002e8000c1e9500ULL, 0x000000080a837981ULL, 0x0002e4000c1e9500ULL,
0x000000ff87027207ULL, 0x002fc40000800000ULL, 0x0000008b88097211ULL, 0x000fc600078fe0ffULL,
0x0000000102037824ULL, 0x000fe200078e0291ULL, 0x00000091880b7211ULL, 0x000fe200078fe0ffULL,
0x000000018b6d7824ULL, 0x000fe400078e0202ULL, 0x0000000102877824ULL, 0x040fe400078e0293ULL,
0x0000000102897824ULL, 0x000fe400078e0295ULL, 0x000060000b0a7625ULL, 0x000fc800078e007cULL,
0x0000600003027625ULL, 0x080fe200078e007cULL, 0x000000080a807981ULL, 0x0002e6000c1e9500ULL,
0x0000600009087625ULL, 0x000fe200078e007cULL, 0x0000000802d17981ULL, 0x0002e2000c1e9500ULL,
0x00000093886b7211ULL, 0x000fc600078fe0ffULL, 0x00000008087e7981ULL, 0x0002e2000c1e9500ULL,
0x00000095880d7211ULL, 0x000fe200078fe0ffULL, 0x000060006d6c7625ULL, 0x000fc800078e007cULL,
0x0000600087087625ULL, 0x082fe200078e007cULL, 0x0000003057877812ULL, 0x000fe200078efcffULL,
0x000000086c857981ULL, 0x0002e4000c1e9500ULL, 0x000060006b6a7625ULL, 0x080fe400078e007cULL,
0x0000000808d57981ULL, 0x0002e4000c1e9500ULL, 0x000060000d0c7625ULL, 0x080fe400078e007cULL,
0x000000086a847981ULL, 0x0002e4000c1e9500ULL, 0x00006000890a7625ULL, 0x000fe200078e007cULL,
0x0000580087897a10ULL, 0x000fe20007ffe0ffULL, 0x000000080c867981ULL, 0x0002e4000c1e9500ULL,
0x00000001678d7824ULL, 0x000fc400078e0287ULL, 0x000000080ad97981ULL, 0x0002e4000c1e9500ULL,
0x000000018d8f7824ULL, 0x100fe400078e0a56ULL, 0x00000001896d7824ULL, 0x002fc600078e0a56ULL,
0x0000008f668f7217ULL, 0x040fe40003800000ULL, 0x000000568d00720cULL, 0x080fe40003f26070ULL,
0x000000568900720cULL, 0x000fe40003f06070ULL, 0x0000006d666d7217ULL, 0x000fe40003800000ULL,
0x00000004ff8f7819ULL, 0x000fe4000001168fULL, 0x000000ff6d8a7207ULL, 0x000fc40000000000ULL,
0x000000ff8f8c7207ULL, 0x000fe40000800000ULL, 0x0000008b8a6b7211ULL, 0x040fe400078fe0ffULL,
0x000000938a097211ULL, 0x000fe200078fe0ffULL, 0x000000018b6d7824ULL, 0x000fe400078e028cULL,
0x000000018c0d7824ULL, 0x000fe400078e0293ULL, 0x000060006b6a7625ULL, 0x000fc800078e007cULL,
0x000060006d6c7625ULL, 0x080fe200078e007cULL, 0x000000086abb7981ULL, 0x0002e6000c1e9500ULL,
0x0000600009087625ULL, 0x080fe200078e007cULL, 0x000000086c8e7981ULL, 0x0002e6000c1e9500ULL,
0x000060000d0c7625ULL, 0x000fe200078e007cULL, 0x0000000808d77981ULL, 0x0002e2000c1e9500ULL,
0x000000918a037211ULL, 0x000fc600078fe0ffULL, 0x000000080c927981ULL, 0x0002e2000c1e9500ULL,
0x000000018c0b7824ULL, 0x000fe400078e0291ULL, 0x0000600003027625ULL, 0x000fc800078e007cULL,
0x000060000b0a7625ULL, 0x080fe200078e007cULL, 0x0000000802d37981ULL, 0x0002e4000c1e9500ULL,
0x000000958a6b7211ULL, 0x002fe400078fe0ffULL, 0x000000080a907981ULL, 0x0002e2000c1e9500ULL,
0x000000018c6d7824ULL, 0x000fe400078e0295ULL, 0x000060006b6a7625ULL, 0x000fc800078e007cULL,
0x000060006d6c7625ULL, 0x000fe200078e007cULL, 0x000000086adb7981ULL, 0x0002e8000c1e9500ULL,
0x000000086c947981ULL, 0x0002e2000c1e9500ULL, 0xfffffff07a037812ULL, 0x000fe200078ec0ffULL,
0x00000001ffcf7424ULL, 0x000fc800078e00ffULL, 0x0000000156027824ULL, 0x000fc800078e0203ULL,
0x0000000159037824ULL, 0x000fe200078e0a02ULL, 0x00000001578b7812ULL, 0x000fc800078efcffULL,
0x00000003cf037219ULL, 0x000fe400000006ffULL, 0x000058008b097a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff0820b7812ULL, 0x002fc600078ec0ffULL, 0x0000000109087824ULL, 0x100fe200078e0a02ULL,
0x00000008578d7812ULL, 0x040fe200078efcffULL, 0x00000001560c7824ULL, 0x000fe200078e020bULL,
0x00000009578f7812ULL, 0x000fe400078efcffULL, 0x00000008cf0b7219ULL, 0x000fe400000006ffULL,
0x000058008d0d7a10ULL, 0x000fe40007ffe0ffULL, 0x000058008f6d7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff0886b7812ULL, 0x000fe200078ec0ffULL, 0x000000010d0a7824ULL, 0x100fe200078e0a02ULL,
0xfffffff08a917812ULL, 0x000fe200078ec0ffULL, 0x000000016d027824ULL, 0x000fe200078e0a02ULL,
0x0000001157957812ULL, 0x000fe200078efcffULL, 0x00000001566a7824ULL, 0x040fe200078e026bULL,
0x0000000acf6b7219ULL, 0x000fe200000006ffULL, 0x0000000156827824ULL, 0x000fe200078e0291ULL,
0x0000541058587816ULL, 0x004fc8000000005bULL, 0x0000005803ff7212ULL, 0x000fc800078ac0ffULL,
0x000000565900720cULL, 0x000fc80002fa1470ULL, 0x000000565700720cULL, 0x000fe40002fa1070ULL,
0x000000580bff7212ULL, 0x000fe4000782c0ffULL, 0xff80000053537808ULL, 0x000fe40002800000ULL,
0x000000560900720cULL, 0x000fe40000f21470ULL, 0x000054106e6e7816ULL, 0x000fe40000000073ULL,
0x000054105a5a7816ULL, 0x000fc40000000071ULL, 0x0000006e03ff7212ULL, 0x040fe4000788c0ffULL,
0x0000005a03ff7212ULL, 0x080fe4000784c0ffULL, 0x0000005a0bff7212ULL, 0x000fe400078ac0ffULL,
0x000000565900720cULL, 0x0c0fe40001741470ULL, 0x000000565900720cULL, 0x080fe40002781470ULL,
0x000000560900720cULL, 0x000fc40002fa1470ULL, 0x000000565700720cULL, 0x0c0fe40001741070ULL,
0x000000565700720cULL, 0x080fe40002781070ULL, 0x000000568b00720cULL, 0x0c0fe40000f21070ULL,
0x000000568b00720cULL, 0x000fe40002fa1070ULL, 0x00000002cf917219ULL, 0x000fe400000006ffULL,
0x000054106f707816ULL, 0x000fc40000000070ULL, 0x0000580095977a10ULL, 0x000fe40007ffe0ffULL,
0xff8000003a3a7808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40002000000ULL,
0xff80000052527808ULL, 0x000fe40000800000ULL, 0xff80000045457808ULL, 0x000fe40002800000ULL,
0x000000586bff7212ULL, 0x000fc4000786c0ffULL, 0x0000007003ff7212ULL, 0x000fe4000780c0ffULL,
0x0000006e0bff7212ULL, 0x040fe4000784c0ffULL, 0x000000700bff7212ULL, 0x000fe4000788c0ffULL,
0x0000005a91ff7212ULL, 0x000fe4000782c0ffULL, 0x0000006e6bff7212ULL, 0x000fe200078ac0ffULL,
0x0000000175027824ULL, 0x100fe200078e0a0cULL, 0x000000565900720cULL, 0x080fe20000701470ULL,
0x0000000197087824ULL, 0x000fe200078e0a0cULL, 0x000000560900720cULL, 0x000fc40001741470ULL,
0x000000560900720cULL, 0x080fe40002781470ULL, 0x000000560d00720cULL, 0x0c0fe40001f61470ULL,
0x000000560d00720cULL, 0x080fe40002fa1470ULL, 0x000000566d00720cULL, 0x000fe40000f21470ULL,
0x00000018579b7812ULL, 0x040fe400078efcffULL, 0x0000001957a17812ULL, 0x000fc400078efcffULL,
0x000000565700720cULL, 0x080fe40000701070ULL, 0x000000568b00720cULL, 0x0c0fe40001741070ULL,
0x000000568b00720cULL, 0x080fe40002781070ULL, 0x000000568d00720cULL, 0x0c0fe40001f61070ULL,
0x000000568d00720cULL, 0x080fe40002fa1070ULL, 0x000000568f00720cULL, 0x000fc40000f21070ULL,
0x00000002cf937219ULL, 0x040fe400000006ffULL, 0x00000008cf997219ULL, 0x000fe400000006ffULL,
0x0000541072727816ULL, 0x008fe40000000079ULL, 0x0000541074747816ULL, 0x000fe4000000007bULL,
0x000058009b9d7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800a1a37a10ULL, 0x000fc40007ffe0ffULL,
0xff80000022227808ULL, 0x000fe40000000000ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40002000000ULL, 0xff80000051517808ULL, 0x000fe40001800000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0xff8000003c3c7808ULL, 0x000fc40000800000ULL,
0x0000005a6bff7212ULL, 0x000fe4000780c0ffULL, 0x0000006e91ff7212ULL, 0x000fe4000784c0ffULL,
0x000000706bff7212ULL, 0x080fe4000788c0ffULL, 0x0000007091ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007299ff7212ULL, 0x000fe400078ac0ffULL, 0x0000007493ff7212ULL, 0x000fe2000782c0ffULL,
0x000000019d0a7824ULL, 0x100fe200078e0a0cULL, 0x000000560d00720cULL, 0x080fe20000701470ULL,
0x00000001a30c7824ULL, 0x000fe200078e0a0cULL, 0x000000560d00720cULL, 0x000fc40002781470ULL,
0x000000566d00720cULL, 0x0c0fe40001741470ULL, 0x000000566d00720cULL, 0x080fe40001f61470ULL,
0x000000567500720cULL, 0x080fe40000f21470ULL, 0x000000569700720cULL, 0x080fe40002fa1470ULL,
0x000000568d00720cULL, 0x0c0fe40000701070ULL, 0x000000568d00720cULL, 0x000fc40002781070ULL,
0x000000568f00720cULL, 0x0c0fe40001741070ULL, 0x000000568f00720cULL, 0x080fe40001f61070ULL,
0x000000567700720cULL, 0x080fe40000f21070ULL, 0x000000569500720cULL, 0x000fe40002fa1070ULL,
0x0000000acf9f7219ULL, 0x040fe400000006ffULL, 0x0000000ccfa57219ULL, 0x000fc400000006ffULL,
0x0000541076767816ULL, 0x000fe4000000007dULL, 0x0000541078787816ULL, 0x000fe40000000083ULL,
0xff80000039397808ULL, 0x000fe40000000000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff80000029297808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fc40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fe40002800000ULL,
0x0000007293ff7212ULL, 0x080fe4000780c0ffULL, 0x000000729fff7212ULL, 0x000fe4000788c0ffULL,
0x0000007693ff7212ULL, 0x040fe4000784c0ffULL, 0x0000007893ff7212ULL, 0x000fc4000786c0ffULL,
0x0000007699ff7212ULL, 0x000fe4000782c0ffULL, 0x00000074a5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001816c7824ULL, 0x000fe200078e0a6aULL, 0x000000567500720cULL, 0x0c0fe40000701470ULL,
0x000000567500720cULL, 0x0c0fe40001741470ULL, 0x000000567500720cULL, 0x080fe40001f61470ULL,
0x000000569700720cULL, 0x000fc40000f21470ULL, 0x000000569d00720cULL, 0x080fe40002781470ULL,
0x00000056a300720cULL, 0x080fe40002fa1470ULL, 0x0000002157a97812ULL, 0x000fe400078efcffULL,
0x000000567700720cULL, 0x0c0fe40000701070ULL, 0x000000567700720cULL, 0x0c0fe40001741070ULL,
0x000000567700720cULL, 0x000fc40001f61070ULL, 0x000000569500720cULL, 0x080fe40000f21070ULL,
0x000000569b00720cULL, 0x080fe40002781070ULL, 0x00000056a100720cULL, 0x000fe40002fa1070ULL,
0x0000006ccfa77219ULL, 0x000fe400000006ffULL, 0x0000541080807816ULL, 0x000fe400000000d1ULL,
0x00005800a9ab7a10ULL, 0x000fc40007ffe0ffULL, 0xff8000004f4f7808ULL, 0x000fe40000000000ULL,
0xff8000002a2a7808ULL, 0x000fe40001000000ULL, 0xff8000001b1b7808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40000800000ULL, 0xff8000004d4d7808ULL, 0x000fe40002000000ULL,
0xff8000003f3f7808ULL, 0x000fc40002800000ULL, 0x0000007499ff7212ULL, 0x040fe4000780c0ffULL,
0x0000007899ff7212ULL, 0x000fe4000784c0ffULL, 0x000000749fff7212ULL, 0x000fe4000786c0ffULL,
0x00000076a5ff7212ULL, 0x040fe4000782c0ffULL, 0x00000078a5ff7212ULL, 0x000fe4000788c0ffULL,
0x00000080a7ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ab7a7824ULL, 0x000fe200078e0a6aULL,
0x000000569700720cULL, 0x000fc40000701470ULL, 0x000000569700720cULL, 0x080fe40001741470ULL,
0x000000569d00720cULL, 0x080fe40001f61470ULL, 0x00000056a300720cULL, 0x0c0fe40000f21470ULL,
0x00000056a300720cULL, 0x080fe40002781470ULL, 0x000000568100720cULL, 0x000fe40002fa1470ULL,
0x0000002857af7812ULL, 0x000fc400078efcffULL, 0x0000002957b57812ULL, 0x000fe400078efcffULL,
0x000000569500720cULL, 0x0c0fe40000701070ULL, 0x000000569500720cULL, 0x080fe40001741070ULL,
0x000000569b00720cULL, 0x080fe40001f61070ULL, 0x00000056a100720cULL, 0x0c0fe40000f21070ULL,
0x00000056a100720cULL, 0x000fc40002781070ULL, 0x000000567f00720cULL, 0x000fe40002fa1070ULL,
0x0000007acfad7219ULL, 0x000fe400000006ffULL, 0x000054107e7e7816ULL, 0x000fe40000000085ULL,
0x0000541084847816ULL, 0x000fe400000000d5ULL, 0x0000541086867816ULL, 0x000fe400000000d9ULL,
0x00005800afb17a10ULL, 0x000fc40007ffe0ffULL, 0x00005800b5b77a10ULL, 0x000fe40007ffe0ffULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff8000001a1a7808ULL, 0x000fe40001000000ULL,
0xff8000003d3d7808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40000800000ULL,
0xff80000017177808ULL, 0x000fc40002000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x0000005891ff7212ULL, 0x000fe400078cc0ffULL, 0x000000769fff7212ULL, 0x040fe4000780c0ffULL,
0x000000789fff7212ULL, 0x000fe4000784c0ffULL, 0x0000007ea7ff7212ULL, 0x040fe4000786c0ffULL,
0x00000084a7ff7212ULL, 0x000fc4000782c0ffULL, 0x00000086a7ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084adff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b17c7824ULL, 0x100fe200078e0a6aULL,
0x000000566d00720cULL, 0x080fe200037c1470ULL, 0x00000001b76a7824ULL, 0x000fe200078e0a6aULL,
0x000000569d00720cULL, 0x0c0fe40000701470ULL, 0x000000569d00720cULL, 0x080fe40001741470ULL,
0x000000568100720cULL, 0x000fc40001f61470ULL, 0x000000568100720cULL, 0x0c0fe40000f21470ULL,
0x000000568100720cULL, 0x080fe40002781470ULL, 0x00000056ab00720cULL, 0x080fe40002fa1470ULL,
0x000000568f00720cULL, 0x080fe400037c1070ULL, 0x000000569b00720cULL, 0x0c0fe40000701070ULL,
0x000000569b00720cULL, 0x000fc40001741070ULL, 0x000000567f00720cULL, 0x0c0fe40001f61070ULL,
0x000000567f00720cULL, 0x0c0fe40000f21070ULL, 0x000000567f00720cULL, 0x080fe40002781070ULL,
0x00000056a900720cULL, 0x000fe40002fa1070ULL, 0x0000007ccfb37219ULL, 0x040fe400000006ffULL,
0x0000006acfb97219ULL, 0x000fc400000006ffULL, 0xff80000050507808ULL, 0x000fe40003000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0xff80000019197808ULL, 0x000fe40001000000ULL,
0xff80000055557808ULL, 0x000fe40001800000ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff80000018187808ULL, 0x000fc40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x00000072a5ff7212ULL, 0x000fe400078cc0ffULL, 0x0000007eadff7212ULL, 0x080fe4000780c0ffULL,
0x0000007eb3ff7212ULL, 0x000fe4000784c0ffULL, 0x00000080adff7212ULL, 0x040fe4000786c0ffULL,
0x00000086adff7212ULL, 0x000fc4000782c0ffULL, 0x00000080b3ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084b9ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000189887824ULL, 0x000fe200078e0a82ULL,
0x00000056a300720cULL, 0x080fe400037c1470ULL, 0x00000056ab00720cULL, 0x0c0fe40000701470ULL,
0x00000056ab00720cULL, 0x0c0fe40001f61470ULL, 0x00000056ab00720cULL, 0x000fc40000f21470ULL,
0x00000056b100720cULL, 0x0c0fe40001741470ULL, 0x00000056b100720cULL, 0x080fe40002781470ULL,
0x00000056b700720cULL, 0x000fe40002fa1470ULL, 0x0000003157bf7812ULL, 0x040fe400078efcffULL,
0x0000003857c57812ULL, 0x040fe400078efcffULL, 0x0000003957cb7812ULL, 0x000fc400078efcffULL,
0x00000056a100720cULL, 0x080fe400037c1070ULL, 0x00000056a900720cULL, 0x0c0fe40000701070ULL,
0x00000056a900720cULL, 0x0c0fe40001f61070ULL, 0x00000056a900720cULL, 0x080fe40000f21070ULL,
0x00000056af00720cULL, 0x0c0fe40001741070ULL, 0x00000056af00720cULL, 0x000fc40002781070ULL,
0x00000056b500720cULL, 0x000fe40002fa1070ULL, 0x00000088cfbd7219ULL, 0x000fe400000006ffULL,
0x00005410bb8e7816ULL, 0x000fe4000000008eULL, 0x00005410d7927816ULL, 0x000fe40000000092ULL,
0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL, 0x00005800c5c77a10ULL, 0x000fc40007ffe0ffULL,
0x00005800cbcd7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000054547808ULL, 0x000fe40003000000ULL,
0xff8000004c4c7808ULL, 0x000fe40000000000ULL, 0xff80000043437808ULL, 0x000fe40001800000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff8000004b4b7808ULL, 0x000fc40001000000ULL,
0xff80000040407808ULL, 0x000fe40002000000ULL, 0xff80000031317808ULL, 0x000fe40002800000ULL,
0x0000007eb9ff7212ULL, 0x040fe400078cc0ffULL, 0x00000080b9ff7212ULL, 0x000fe4000780c0ffULL,
0x00000084b3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000086b3ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086b9ff7212ULL, 0x000fe4000784c0ffULL, 0x0000008ebdff7212ULL, 0x040fe4000788c0ffULL,
0x00000092bdff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c18a7824ULL, 0x100fe200078e0a82ULL,
0x00000056b100720cULL, 0x080fe20001f61470ULL, 0x00000001c78c7824ULL, 0x100fe200078e0a82ULL,
0x00000056b100720cULL, 0x080fe20000f21470ULL, 0x00000001cd827824ULL, 0x000fe200078e0a82ULL,
0x00000056b700720cULL, 0x000fc400037c1470ULL, 0x00000056b700720cULL, 0x0c0fe40000701470ULL,
0x00000056b700720cULL, 0x080fe40001741470ULL, 0x000000568900720cULL, 0x0c0fe40002781470ULL,
0x000000568900720cULL, 0x000fe40002fa1470ULL, 0x0000008acfc37219ULL, 0x040fe400000006ffULL,
0x0000008ccfc97219ULL, 0x000fc400000006ffULL, 0x00000056af00720cULL, 0x0c0fe40001f61070ULL,
0x00000056af00720cULL, 0x080fe40000f21070ULL, 0x00000056b500720cULL, 0x0c0fe400037c1070ULL,
0x00000056b500720cULL, 0x0c0fe40000701070ULL, 0x00000056b500720cULL, 0x080fe40001741070ULL,
0x000000568700720cULL, 0x000fc40002781070ULL, 0x000000568700720cULL, 0x000fe40002fa1070ULL,
0x00000082cfcf7219ULL, 0x000fe400000006ffULL, 0x00005410d3907816ULL, 0x000fe40000000090ULL,
0xff80000030307808ULL, 0x000fe40001800000ULL, 0xff80000010107808ULL, 0x000fe40000800000ULL,
0xff8000004a4a7808ULL, 0x000fc40003000000ULL, 0xff80000042427808ULL, 0x000fe40000000000ULL,
0xff80000011117808ULL, 0x000fe40001000000ULL, 0xff80000049497808ULL, 0x000fe40002000000ULL,
0xff80000036367808ULL, 0x000fe40002800000ULL, 0x0000008ec3ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008ec9ff7212ULL, 0x000fc4000782c0ffULL, 0x0000008ecfff7212ULL, 0x000fe400078cc0ffULL,
0x00000090bdff7212ULL, 0x080fe4000780c0ffULL, 0x00000090c3ff7212ULL, 0x080fe4000784c0ffULL,
0x00000090c9ff7212ULL, 0x000fe4000788c0ffULL, 0x00000092c3ff7212ULL, 0x000fe400078ac0ffULL,
0x000000568900720cULL, 0x000fc40000701470ULL, 0x00000056c100720cULL, 0x0c0fe40001f61470ULL,
0x00000056c100720cULL, 0x0c0fe40001741470ULL, 0x00000056c100720cULL, 0x080fe40002fa1470ULL,
0x00000056c700720cULL, 0x080fe40000f21470ULL, 0x00000056cd00720cULL, 0x080fe400037c1470ULL,
0x00000056c700720cULL, 0x000fc40002781470ULL, 0x000000568700720cULL, 0x080fe40000701070ULL,
0x00000056bf00720cULL, 0x0c0fe40001f61070ULL, 0x00000056bf00720cULL, 0x0c0fe40001741070ULL,
0x00000056bf00720cULL, 0x080fe40002fa1070ULL, 0x00000056c500720cULL, 0x080fe40000f21070ULL,
0x00000056cb00720cULL, 0x000fc400037c1070ULL, 0x00000056c500720cULL, 0x000fe40002781070ULL,
0x00005410db947816ULL, 0x000fe40000000094ULL, 0xff80000041417808ULL, 0x000fe40000000000ULL,
0xff80000048487808ULL, 0x000fe40001800000ULL, 0xff80000038387808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fc40002800000ULL, 0xff80000047477808ULL, 0x000fe40000800000ULL,
0xff80000046467808ULL, 0x000fe40003000000ULL, 0xff80000037377808ULL, 0x000fe40002000000ULL,
0x00000090cfff7212ULL, 0x000fe4000780c0ffULL, 0x00000092c9ff7212ULL, 0x080fe4000786c0ffULL,
0x00000092cfff7212ULL, 0x000fc4000784c0ffULL, 0x00000094bdff7212ULL, 0x080fe400078ac0ffULL,
0x00000094c3ff7212ULL, 0x080fe4000782c0ffULL, 0x00000094c9ff7212ULL, 0x080fe400078cc0ffULL,
0x00000094cfff7212ULL, 0x000fe4000788c0ffULL, 0x000000568900720cULL, 0x080fe40002fa1470ULL,
0x00000056c100720cULL, 0x000fc40000f21470ULL, 0x00000056c700720cULL, 0x0c0fe40001f61470ULL,
0x00000056c700720cULL, 0x080fe400037c1470ULL, 0x00000056cd00720cULL, 0x0c0fe40000701470ULL,
0x00000056cd00720cULL, 0x0c0fe40001741470ULL, 0x00000056cd00720cULL, 0x080fe40002781470ULL,
0x000000568700720cULL, 0x000fc40002fa1070ULL, 0x00000056bf00720cULL, 0x080fe40000f21070ULL,
0x00000056cb00720cULL, 0x080fe40000701070ULL, 0x00000056c500720cULL, 0x0c0fe40001f61070ULL,
0x00000056c500720cULL, 0x080fe400037c1070ULL, 0x00000056cb00720cULL, 0x0c0fe40001741070ULL,
0x00000056cb00720cULL, 0x000fc40002781070ULL, 0xff80000035357808ULL, 0x000fe40000000000ULL,
0xff80000033337808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000012127808ULL, 0x000fe40002800000ULL, 0xff80000013137808ULL, 0x000fe40000800000ULL,
0xff80000014147808ULL, 0x000fc40003000000ULL, 0xff80000015157808ULL, 0x000fc40002000000ULL,
0x000000530400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff577424ULL, 0x000fe200078e00ffULL,
0x0000003a0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff587424ULL, 0x000fe200078e00ffULL,
0x000000270600720bULL, 0x000fe40003f5e000ULL, 0x000000220700720bULL, 0x000fe40003f7e000ULL,
0x0000000453037208ULL, 0x000fe40004000000ULL, 0x000000053a027208ULL, 0x000fc40004800000ULL,
0x0000000627057208ULL, 0x000fe40005000000ULL, 0x0000000722047208ULL, 0x000fe40005800000ULL,
0x000000520300720bULL, 0x000fe40003f1e000ULL, 0x000000450200720bULL, 0x000fe40003f3e000ULL,
0x000000260500720bULL, 0x000fe40003f5e000ULL, 0x000000250400720bULL, 0x000fc40003f7e000ULL,
0x0000000352067208ULL, 0x000fe40004000000ULL, 0x0000000245027208ULL, 0x000fe40004800000ULL,
0x0000000526057208ULL, 0x000fe40005000000ULL, 0x0000000425047208ULL, 0x000fe40005800000ULL,
0x000000510600720bULL, 0x000fe40003f1e000ULL, 0x000000390200720bULL, 0x000fc40003f3e000ULL,
0x000000280500720bULL, 0x000fe40003f5e000ULL, 0x000000230400720bULL, 0x000fe40003f7e000ULL,
0x0000000651037208ULL, 0x000fe40004000000ULL, 0x0000000239077208ULL, 0x000fe40004800000ULL,
0x0000000528027208ULL, 0x000fe40005000000ULL, 0x0000000423057208ULL, 0x000fc40005800000ULL,
0x000000500300720bULL, 0x000fe40003f1e000ULL, 0x0000003c0700720bULL, 0x000fe40003f3e000ULL,
0x000000290200720bULL, 0x000fe40003f5e000ULL, 0x000000240500720bULL, 0x000fe40003f7e000ULL,
0x0000000350047208ULL, 0x000fe40004000000ULL, 0x000000073c067208ULL, 0x000fc40004800000ULL,
0x0000000229037208ULL, 0x000fe40005000000ULL, 0x0000000524027208ULL, 0x000fe40005800000ULL,
0x0000004f0400720bULL, 0x000fe40003f1e000ULL, 0x0000003b0600720bULL, 0x000fe40003f3e000ULL,
0x0000002a0300720bULL, 0x000fe40003f5e000ULL, 0x0000001b0200720bULL, 0x000fc40003f7e000ULL,
0x000000044f057208ULL, 0x000fe40004000000ULL, 0x000000063b077208ULL, 0x000fe40004800000ULL,
0x000000032a047208ULL, 0x000fe40005000000ULL, 0x000000021b037208ULL, 0x000fe40005800000ULL,
0x0000004e0500720bULL, 0x000fe40003f1e000ULL, 0x000000440700720bULL, 0x000fc40003f3e000ULL,
0x0000002b0400720bULL, 0x000fe40003f5e000ULL, 0x0000001a0300720bULL, 0x000fe40003f7e000ULL,
0x000000054e027208ULL, 0x000fe40004000000ULL, 0x0000000744067208ULL, 0x000fe40004800000ULL,
0x000000042b057208ULL, 0x000fe40005000000ULL, 0x000000031a047208ULL, 0x000fc40005800000ULL,
0x0000004d0200720bULL, 0x000fe40003f1e000ULL, 0x0000003d0600720bULL, 0x000fe40003f3e000ULL,
0x0000002c0500720bULL, 0x000fe40003f5e000ULL, 0x000000190400720bULL, 0x000fe40003f7e000ULL,
0x000000024d037208ULL, 0x000fe40004000000ULL, 0x000000063d067208ULL, 0x000fc40004800000ULL,
0x000000052c027208ULL, 0x000fe40005000000ULL, 0x0000000419047208ULL, 0x000fe40005800000ULL,
0x000000540300720bULL, 0x000fe40003f1e000ULL, 0x0000003f0600720bULL, 0x000fe40003f3e000ULL,
0x0000002d0200720bULL, 0x000fe40003f5e000ULL, 0x000000170400720bULL, 0x000fc40003f7e000ULL,
0x0000000354087208ULL, 0x000fe40004000000ULL, 0x000000063f037208ULL, 0x000fe40004800000ULL,
0x000000022d057208ULL, 0x000fe40005000000ULL, 0x0000000417077208ULL, 0x000fe40005800000ULL,
0x0000003e0300720bULL, 0x000fe40003f3e000ULL, 0x0000002e0500720bULL, 0x000fc40003f5e000ULL,
0x000000550800720bULL, 0x000fe40003f1e000ULL, 0x000000180700720bULL, 0x000fe40003f7e000ULL,
0x000000033e027208ULL, 0x000fe40004800000ULL, 0x000000052e047208ULL, 0x000fe40005000000ULL,
0x0000000855097208ULL, 0x000fe40004000000ULL, 0x0000000718077208ULL, 0x000fc40005800000ULL,
0x000000430200720bULL, 0x000fe40003f3e000ULL, 0x0000002f0400720bULL, 0x000fe40003f5e000ULL,
0x0000004c0900720bULL, 0x000fe40003f1e000ULL, 0x000000160700720bULL, 0x000fe40003f7e000ULL,
0x0000000243037208ULL, 0x000fe40004800000ULL, 0x000000042f057208ULL, 0x000fc40005000000ULL,
0x000000094c067208ULL, 0x000fe40004000000ULL, 0x0000000716077208ULL, 0x000fe40005800000ULL,
0x000000400300720bULL, 0x000fe40003f3e000ULL, 0x000000300500720bULL, 0x000fe40003f5e000ULL,
0x0000004b0600720bULL, 0x000fe40003f1e000ULL, 0x000000100700720bULL, 0x000fc40003f7e000ULL,
0x0000000340037208ULL, 0x000fe40004800000ULL, 0x0000000530027208ULL, 0x000fe40005000000ULL,
0x000000064b097208ULL, 0x000fe40004000000ULL, 0x0000000710047208ULL, 0x000fe40005800000ULL,
0x000000420300720bULL, 0x000fe40003f3e000ULL, 0x000000310200720bULL, 0x000fc40003f5e000ULL,
0x0000004a0900720bULL, 0x000fe40003f1e000ULL, 0x000000110400720bULL, 0x000fe40003f7e000ULL,
0x0000000342087208ULL, 0x000fe40004800000ULL, 0x0000000231037208ULL, 0x000fe40005000000ULL,
0x000000094a067208ULL, 0x000fe40004000000ULL, 0x0000000411057208ULL, 0x000fc40005800000ULL,
0x000000360300720bULL, 0x000fe40003f5e000ULL, 0x000000490600720bULL, 0x000fe40003f1e000ULL,
0x000000410800720bULL, 0x000fe40003f3e000ULL, 0x000000120500720bULL, 0x000fe40003f7e000ULL,
0x0000000336037208ULL, 0x000fe40005000000ULL, 0x0000000649077208ULL, 0x000fc40004000000ULL,
0x0000000841097208ULL, 0x000fe40004800000ULL, 0x0000000512027208ULL, 0x000fe40005800000ULL,
0x000000320300720bULL, 0x000fe40003f5e000ULL, 0x000000480700720bULL, 0x000fe40003f1e000ULL,
0x000000380900720bULL, 0x000fe40003f3e000ULL, 0x000000130200720bULL, 0x000fc40003f7e000ULL,
0x0000000332087208ULL, 0x000fe40005000000ULL, 0x0000000748047208ULL, 0x000fe40004000000ULL,
0x0000000938067208ULL, 0x000fe40004800000ULL, 0x0000000213037208ULL, 0x000fe40005800000ULL,
0x000000470400720bULL, 0x000fe40003f1e000ULL, 0x000000370600720bULL, 0x000fc40003f3e000ULL,
0x000000330800720bULL, 0x000fe40003f5e000ULL, 0x000000140300720bULL, 0x000fe40003f7e000ULL,
0x0000000447057208ULL, 0x000fe40004000000ULL, 0x0000000637067208ULL, 0x000fe40004800000ULL,
0x0000000833077208ULL, 0x000fe40005000000ULL, 0x0000000314027208ULL, 0x000fc40005800000ULL,
0x000000460500720bULL, 0x000fe40003f1e000ULL, 0x000000350600720bULL, 0x000fe40003f3e000ULL,
0x000000340700720bULL, 0x000fe40003f5e000ULL, 0x000000150200720bULL, 0x000fe40003f7e000ULL,
0x0000000546097208ULL, 0x000fe40004000000ULL, 0x00000006350b7208ULL, 0x000fc40004800000ULL,
0x00000007340c7208ULL, 0x000fe40005000000ULL, 0x00000002150d7208ULL, 0x000fe20005800000ULL,
0x000020c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009027f89ULL, 0x0004e400000e0000ULL,
0x000000020900720bULL, 0x008fc80003f1e000ULL, 0x0000000902567208ULL, 0x000fe20004000000ULL,
0x000020d27f007947ULL, 0x000fea000b800000ULL, 0x0c401f000b027f89ULL, 0x000ee800000e0000ULL,
0x0c401f000c037f89ULL, 0x000e6800000e0000ULL, 0x0c401f000d047f89ULL, 0x000ea800000e0000ULL,
0x0c201f0056057f89ULL, 0x000ea200000e0000ULL, 0x000000020b00720bULL, 0x008fc40003f1e000ULL,
0x000000030c00720bULL, 0x002fe40003f3e000ULL, 0x0000000b02027208ULL, 0x000fe40004000000ULL,
0x0000000c03037208ULL, 0x000fe40004800000ULL, 0x000000040d00720bULL, 0x004fe20003f1e000ULL,
0x0c201f0002097f89ULL, 0x000e6600000e0000ULL, 0x0000000d04077208ULL, 0x000fe20004000000ULL,
0x0c201f0003067f89ULL, 0x000ea200000e0000ULL, 0x000000055600720bULL, 0x000fc60003f1e000ULL,
0x0c201f0007087f89ULL, 0x0006e200000e0000ULL, 0x0000005605047208ULL, 0x000fe40004000000ULL,
0x000000090200720bULL, 0x002fe40003f3e000ULL, 0x000000060300720bULL, 0x004fe40003f5e000ULL,
0x0000000209057208ULL, 0x000fe40004800000ULL, 0x0000000306067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04027820ULL, 0x008fe20000410000ULL, 0x000000080700720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x00000002ff727819ULL, 0x000fe2000001161fULL,
0x3fb8aa3b4d097823ULL, 0x102fe20000010802ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b554d7823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b490c7823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b480d7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b46467823ULL, 0x000fe20000010802ULL,
0x3fb8aa3b05027820ULL, 0x000fe20000410000ULL, 0x0000000708077208ULL, 0x000fe20004000000ULL,
0x0000005000037308ULL, 0x000fe20000000800ULL, 0x00000008726d7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010802ULL,
0x00000039000b7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b41397823ULL, 0x102fe20000010802ULL,
0x3fb8aa3b35027823ULL, 0x000fe20000010802ULL, 0x3fb8aa3b06357820ULL, 0x000fe20000410000ULL,
0x0000003f00487308ULL, 0x000fe20000000800ULL, 0x00000008726f7824ULL, 0x040fe200078e00ffULL,
0x0000000372087810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b34347823ULL, 0x000fe20000010835ULL, 0x3fb8aa3b07357820ULL, 0x000fe20000410000ULL,
0x0000000200507308ULL, 0x0003e20000000800ULL, 0x0000000872737824ULL, 0x000fe200078e00ffULL,
0x000000031fff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010835ULL,
0x0000000872717824ULL, 0x040fe200078e00ffULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010835ULL,
0x00000027003f7308ULL, 0x0005e20000000800ULL, 0x0000000172027810ULL, 0x002fe20007ffe0ffULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010835ULL, 0xfffffff871717812ULL, 0x000fe200078ee208ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010835ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee202ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010835ULL, 0x0000000272027810ULL, 0x000fe20007ffe0ffULL,
0x00000051000a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b24277823ULL, 0x104fe20000010835ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010835ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee202ULL,
0x00000004ff027e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b10107823ULL, 0x000fc40000010835ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x3f8000000202783eULL, 0x000fce00000010ffULL, 0x0000005400547308ULL, 0x000fe20000000800ULL,
0x0000000a030a723eULL, 0x002fe200000010ffULL, 0x000000ffff037224ULL, 0x000fcc00078e0002ULL,
0x0000003000597308ULL, 0x000ff00000000800ULL, 0x0000005300537308ULL, 0x000ff00000000800ULL,
0x0000005200527308ULL, 0x000e700000000800ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x000000535208723eULL, 0x002fe200000010ffULL,
0x0000000872537824ULL, 0x000fcc00078e00ffULL, 0x0000003c003c7308ULL, 0x000e700000000800ULL,
0x0000004200497308ULL, 0x000ff00000000800ULL, 0x0000002900567308ULL, 0x000fe20000000800ULL,
0x0000000b3c0b723eULL, 0x002fe200000010ffULL, 0x000000ffff3c7224ULL, 0x000fcc00078e0002ULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002700307308ULL, 0x000ff00000000800ULL,
0x0000002600427308ULL, 0x0002b00000000800ULL, 0x0000002800417308ULL, 0x0005e20000000800ULL,
0x0000000472267810ULL, 0x002fc80007ffe0ffULL, 0xfffffff873737812ULL, 0x000fe400078ee226ULL,
0x000000095426723eULL, 0x000fe200000010ffULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x0000003a4509723eULL, 0x000fe200000010ffULL, 0x0000000872457824ULL, 0x000fe200078e00ffULL,
0x0000003f4228723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b153f7823ULL, 0x100fe20000010835ULL,
0x00000006723a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff427224ULL, 0x100fe400078e0002ULL,
0x0000002500297308ULL, 0x000e700000000800ULL, 0x0000002b00587308ULL, 0x0005f00000000800ULL,
0x0000002a00517308ULL, 0x0006e20000000800ULL, 0x00000023302b723eULL, 0x004fe200000010ffULL,
0x000000ffff307224ULL, 0x000fe200078e0002ULL, 0x000000222929723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b18237823ULL, 0x000fc80000010835ULL, 0x00000031006c7308ULL, 0x0003e20000000800ULL,
0x00000041562a723eULL, 0x008fe200000010ffULL, 0x0000000872417824ULL, 0x000fca00078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee272ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x000000ffff317224ULL, 0x002fe200078e0002ULL, 0x000000515818723eULL, 0x000fe400000010ffULL,
0x0000000872517810ULL, 0x000fc80007ffe0ffULL, 0x0000004e004e7308ULL, 0x000e700000000800ULL,
0x0000002c00557308ULL, 0x000ff00000000800ULL, 0x0000002d005a7308ULL, 0x000fe20000000800ULL,
0x0000004f4e24723eULL, 0x002fe200000010ffULL, 0x00000008724f7824ULL, 0x000fca00078e00ffULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee23aULL, 0x0000002e00577308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b133a7823ULL, 0x000fe20000010835ULL, 0x000000ffff137224ULL, 0x000fcc00078e0002ULL,
0x0000002f006a7308ULL, 0x0003f00000000800ULL, 0x0000003d003d7308ULL, 0x000ea20000000800ULL,
0x00000002082c723cULL, 0x002b6e00000418ffULL, 0x00000032006e7308ULL, 0x000ff00000000800ULL,
0x00000033006b7308ULL, 0x0003e20000000800ULL, 0x0000003d4827723eULL, 0x004fe200000010ffULL,
0x000000ffff3d7224ULL, 0x000fcc00078e0002ULL, 0x0000003400707308ULL, 0x000fe20000000800ULL,
0x000000302830723cULL, 0x002f6e00000418ffULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000e700000000800ULL, 0x0000001b001b7308ULL, 0x000ff00000000800ULL,
0x0000001a00347308ULL, 0x0004e20000000800ULL, 0x0000003b4425723eULL, 0x002fce00000010ffULL,
0x0000001900037308ULL, 0x0207e20000000800ULL, 0xffffffff721a7810ULL, 0x004fe20007ffe0ffULL,
0x0000003c242c723cULL, 0x000b66000004182cULL, 0xfffffff853537812ULL, 0x000fe400078ee21aULL,
0x000000555a1a723eULL, 0x000fe200000010ffULL, 0x0000001700227308ULL, 0x000e620000000800ULL,
0x0000001b3419723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b143d7823ULL, 0x020fe20000010835ULL,
0x0000001072557810ULL, 0x000fc40007ffe0ffULL, 0x000000576a14723eULL, 0x000fc600000010ffULL,
0x00000036005b7308ULL, 0x0005e20000000800ULL, 0x00000008553c7824ULL, 0x000fca00078e00ffULL,
0xfffffff83c557812ULL, 0x000fe400078ee255ULL, 0x00000003221b723eULL, 0x002fe200000010ffULL,
0x0000000851227824ULL, 0x000fe200078e00ffULL, 0x0000000572367810ULL, 0x044fe20007ffe0ffULL,
0x3fb8aa3b11037823ULL, 0x100fe20000010835ULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x0000001872727810ULL, 0x000fe40007ffe0ffULL, 0xfffffff845457812ULL, 0x000fe200078ee236ULL,
0x3fb8aa3b12367823ULL, 0x000fe20000010835ULL, 0x000000ffff127224ULL, 0x100fe200078e0002ULL,
0xfffffff822517812ULL, 0x000fe200078ee251ULL, 0x0000000872157824ULL, 0x000fe200078e00ffULL,
0x0000004300437308ULL, 0x000e680000000800ULL, 0x000000121830723cULL, 0x000b680000041830ULL,
0x0000004d004d7308ULL, 0x000ff00000000800ULL, 0x0000004c004c7308ULL, 0x000fe20000000800ULL,
0x0000003e4311723eULL, 0x002fe200000010ffULL, 0x000000ffff437224ULL, 0x000fe200078e0002ULL,
0x0000000c0f3e7812ULL, 0x000fca00078ec0ffULL, 0x0000004b004b7308ULL, 0x000ff00000000800ULL,
0x0000004a004a7308ULL, 0x000e700000000800ULL, 0x0000004000407308ULL, 0x000eb00000000800ULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x0000004b4a12723eULL, 0x022fce00000010ffULL,
0x0000001600347308ULL, 0x0002e20000000800ULL, 0x000000404913723eULL, 0x004fce00000010ffULL,
0x0000001000177308ULL, 0x0005e20000000800ULL, 0x000000596c16723eULL, 0x002fce00000010ffULL,
0x0000000300227308ULL, 0x0002e20000000800ULL, 0x0000004d4c10723eULL, 0x004fce00000010ffULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0xfffffff815037812ULL, 0x002fe200078ee272ULL,
0x00000042102c723cULL, 0x000f62000004182cULL, 0x000000233415723eULL, 0x008fca00000010ffULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x000000172217723eULL, 0x000fe400000010ffULL,
0x0000a00020227811ULL, 0x000fca00078e60ffULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x000000421430723cULL, 0x000f620000041830ULL, 0x0000001041417824ULL, 0x100fe400078e0222ULL,
0x000000106d6d7824ULL, 0x100fe400078e0222ULL, 0x000000106f6f7824ULL, 0x100fe400078e0222ULL,
0x0000003800387308ULL, 0x000ea20000000800ULL, 0x0000000c0d34723eULL, 0x002fe200000010ffULL,
0x0000001071717824ULL, 0x000fc400078e0222ULL, 0x0000001073737824ULL, 0x000fe400078e0222ULL,
0x0000000141417824ULL, 0x000fe400078e023eULL, 0x00000036003b7308ULL, 0x000fe20000000800ULL,
0x0000001045457824ULL, 0x000fe400078e0222ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0002ULL,
0x0000000841007388ULL, 0x0003e20000000800ULL, 0x000000013e6d7824ULL, 0x000fe400078e026dULL,
0x000000104f4f7824ULL, 0x100fe200078e0222ULL, 0x0000003a003c7308ULL, 0x0006620000000800ULL,
0x000000393835723eULL, 0x004fe200000010ffULL, 0x000000013e6f7824ULL, 0x000fe200078e026fULL,
0x0000005b6e38723eULL, 0x000fe200000010ffULL, 0x0000001053537824ULL, 0x000fe200078e0222ULL,
0x0000000a6d007388ULL, 0x0005e20000000800ULL, 0x000000013e717824ULL, 0x000fc400078e0271ULL,
0x0000004700477308ULL, 0x000fe20000000800ULL, 0x0000006b703a723eULL, 0x008fe200000010ffULL,
0x0000001051517824ULL, 0x000fe200078e0222ULL, 0x000000246f007388ULL, 0x0005e20000000800ULL,
0x000000013e737824ULL, 0x040fe400078e0273ULL, 0x000000013e457824ULL, 0x000fe200078e0245ULL,
0x0000002671007388ULL, 0x0005e20000000800ULL, 0x0000004600467308ULL, 0x000ee20000000800ULL,
0x0000003b3c39723eULL, 0x002fe200000010ffULL, 0x000000013e4f7824ULL, 0x040fe200078e024fULL,
0x0000001073007388ULL, 0x0005e20000000800ULL, 0x000000013e537824ULL, 0x000fc400078e0253ULL,
0x0000001055557824ULL, 0x100fe200078e0222ULL, 0x0000001245007388ULL, 0x0005e20000000800ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x0000001003037824ULL, 0x000fe400078e0222ULL,
0x000000344f007388ULL, 0x0005e20000000800ULL, 0x000000013e557824ULL, 0x000fc800078e0255ULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0x000000474636723eULL, 0x008fca00000010ffULL,
0x0000003653007388ULL, 0x0005e40000000800ULL, 0x0000003f000c7308ULL, 0x000ee20000000800ULL,
0x000000375037723eULL, 0x002fce00000010ffULL, 0x00000042342c723cULL, 0x020f62000004182cULL,
0x0000003d0c3b723eULL, 0x008fe200000010ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e0002ULL,
0x000000013e027824ULL, 0x040fe400078e0251ULL, 0x000000013e3e7824ULL, 0x000fc600078e0203ULL,
0x0000000c3830723cULL, 0x000f620000041830ULL, 0x0000000902007388ULL, 0x0005e80000000800ULL,
0x0004000b6d007388ULL, 0x0005f40000000800ULL, 0x000000ffff2d7224ULL, 0x020fe200078e002eULL,
0x000400256f007388ULL, 0x0005e80000000800ULL, 0x0004002771007388ULL, 0x0005e80000000800ULL,
0x0004001173007388ULL, 0x0005e80000000800ULL, 0x0004001345007388ULL, 0x0005e20000000800ULL,
0x000000ffff2e7224ULL, 0x000fc600078e0030ULL, 0x000400354f007388ULL, 0x0005e20000000800ULL,
0x000000ffff2f7224ULL, 0x000fc600078e0032ULL, 0x0004003753007388ULL, 0x0005e80000000800ULL,
0x0000002855007388ULL, 0x0005e80000000800ULL, 0x0008002a6d007388ULL, 0x0005e80000000800ULL,
0x000800186f007388ULL, 0x0005e80000000800ULL, 0x0008001a71007388ULL, 0x0005e80000000800ULL,
0x0008001473007388ULL, 0x0005e80000000800ULL, 0x0008001645007388ULL, 0x0005e80000000800ULL,
0x000800384f007388ULL, 0x0005e80000000800ULL, 0x0008003a53007388ULL, 0x0005e80000000800ULL,
0x000000293e007388ULL, 0x0005e80000000800ULL, 0x000c002b6d007388ULL, 0x0005e80000000800ULL,
0x000c00196f007388ULL, 0x0005e80000000800ULL, 0x000c001b71007388ULL, 0x0005e80000000800ULL,
0x000c001573007388ULL, 0x0005e80000000800ULL, 0x000c001745007388ULL, 0x0005e80000000800ULL,
0x000c00394f007388ULL, 0x0005e80000000800ULL, 0x000c003b53007388ULL, 0x0005e80000000800ULL,
0x012000040e008388ULL, 0x0005e80000000c00ULL, 0x0122002c0e008388ULL, 0x0005e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000062ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080062ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100062ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000163637810ULL, 0x000fe20007ffe0ffULL,
0x0000180062ff7f8cULL, 0x0003e6000c80043fULL, 0x0000001c6300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff88f000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff277807ULL, 0x008fe40004000000ULL,
0x0001b08000287802ULL, 0x000fc40000000f00ULL, 0x0000108000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0027ULL, 0xfffe78f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x000fe40005000000ULL, 0x0001b0d000287802ULL, 0x000fc40000000f00ULL,
0x0000103000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e0027ULL,
0xfffe795000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0002ULL,
0x0001b12000277802ULL, 0x000fc40000000f00ULL, 0x00000f9000007944ULL, 0x014fea0003c00000ULL,
0xfffe7a2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0002ULL,
0x0001b16000277802ULL, 0x000fc40000000f00ULL, 0x00000f5000007944ULL, 0x014fea0003c00000ULL,
0xfffe7b5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0002ULL,
0x0001b1a000277802ULL, 0x000fc40000000f00ULL, 0x00000f1000007944ULL, 0x014fea0003c00000ULL,
0xfffe7c8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0002ULL,
0x0001b1e000277802ULL, 0x000fc40000000f00ULL, 0x00000ed000007944ULL, 0x014fea0003c00000ULL,
0xfffe7da000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0000ULL,
0x0001b23000277802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0003ULL,
0x00000e8000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0028ULL,
0xfffe819000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0000ULL,
0x0001b28000277802ULL, 0x000fc40000000f00ULL, 0x00000e3000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0028ULL, 0x0000001003297810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff287224ULL, 0x000fe200078e0000ULL, 0x0001b2d000277802ULL, 0x000fc40000000f00ULL,
0x00000de000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0028ULL,
0xfffe814000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0000ULL,
0x0001b32000277802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0028ULL, 0xfffe812000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x008fe40004000000ULL, 0x0001b37000287802ULL, 0x000fc40000000f00ULL,
0x00000d9000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff267224ULL, 0x000fe200078e0027ULL,
0xfffeb1f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe40005000000ULL,
0x0001b3c000287802ULL, 0x000fc40000000f00ULL, 0x00000d4000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff717224ULL, 0x000fe200078e0027ULL, 0xfffeb23000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0073ULL, 0x0001b41000277802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x014fea0003c00000ULL, 0xfffeb31000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0073ULL, 0x0001b45000277802ULL, 0x000fc40000000f00ULL,
0x00000c6000007944ULL, 0x014fea0003c00000ULL, 0xfffeb44000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0073ULL, 0x0001b49000277802ULL, 0x000fc40000000f00ULL,
0x00000c2000007944ULL, 0x014fea0003c00000ULL, 0xfffeb57000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0073ULL, 0x0001b4d000277802ULL, 0x000fc40000000f00ULL,
0x00000be000007944ULL, 0x014fea0003c00000ULL, 0xfffeb69000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000cULL, 0x0001b52000277802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0025ULL, 0x00000b9000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0028ULL, 0xfffebab000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000cULL, 0x0001b57000277802ULL, 0x000fc40000000f00ULL,
0x00000b4000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0028ULL,
0x0000001025297810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0001b5c000277802ULL, 0x000fc40000000f00ULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0028ULL, 0xfffeba6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000cULL, 0x0001b61000277802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0028ULL,
0xfffeba4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x008fe40004000000ULL,
0x0001b66000287802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0027ULL, 0xfffee8f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x000fe40005000000ULL, 0x0001b6b000287802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff737224ULL, 0x000fe200078e0027ULL,
0xfffee94000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0001b70000277802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x014fea0003c00000ULL,
0xfffeea1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0001b74000277802ULL, 0x000fc40000000f00ULL, 0x0000097000007944ULL, 0x014fea0003c00000ULL,
0xfffeeb4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0001b78000277802ULL, 0x000fc40000000f00ULL, 0x0000093000007944ULL, 0x014fea0003c00000ULL,
0xfffeec7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0001b7c000277802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x014fea0003c00000ULL,
0xfffeed9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0001b81000277802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0021ULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0028ULL,
0xfffef1a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0001b86000277802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0028ULL, 0x0000001021297810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff287224ULL, 0x000fe200078e000cULL, 0x0001b8b000277802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0028ULL,
0xfffef15000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e000cULL,
0x0001b90000277802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0028ULL, 0xfffef13000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x008fe40004000000ULL, 0x0001b95000287802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff067224ULL, 0x000fe200078e0027ULL,
0xffff20d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe40005000000ULL,
0x0001b9a000287802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0027ULL, 0xffff211000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0011ULL, 0x0001b9f000277802ULL, 0x000fc40000000f00ULL,
0x000006c000007944ULL, 0x010fea0003c00000ULL, 0xffff21e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0011ULL, 0x0001ba3000277802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x010fea0003c00000ULL, 0xffff231000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0011ULL, 0x0001ba7000277802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x010fea0003c00000ULL, 0xffff244000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0011ULL, 0x0001bab000277802ULL, 0x000fc40000000f00ULL,
0x0000060000007944ULL, 0x010fea0003c00000ULL, 0xffff256000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0006ULL, 0x0001bb0000277802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0011ULL, 0x000005b000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0028ULL, 0xffff298000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0006ULL, 0x0001bb5000277802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0028ULL,
0x0000001011297810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200078e0006ULL,
0x0001bba000277802ULL, 0x000fc40000000f00ULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0028ULL, 0xffff293000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0006ULL, 0x0001bbf000277802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0028ULL,
0xffff291000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0a7424ULL, 0x000fe200078e00ffULL,
0x0001bc4000027802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0008ULL, 0xffffdf0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff097224ULL, 0x006fe200078e000bULL, 0x0001bca000027802ULL, 0x000fe20000000f00ULL,
0x00000002ff0a7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x000000080b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e000cULL,
0x0001bd0000027802ULL, 0x000fe20000000f00ULL, 0x00000002ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000000b08057208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000080c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e000dULL,
0x0001bd6000027802ULL, 0x000fe20000000f00ULL, 0x00000002ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000000c080b7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000080d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e0056ULL,
0x0001bdc000027802ULL, 0x000fe20000000f00ULL, 0x00000001ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000000d08077208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000085600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e0005ULL,
0x0001be2000027802ULL, 0x000fe20000000f00ULL, 0x00000001ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000005608047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000080500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e000bULL,
0x0001be8000027802ULL, 0x000fe20000000f00ULL, 0x00000001ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000000508057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000080b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff097224ULL, 0x002fe200078e0007ULL,
0x0001bee000027802ULL, 0x000fe20000000f00ULL, 0x00000001ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000000b08067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffddd000007947ULL, 0x000fea000383ffffULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000022027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe3f9002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff037424ULL, 0x000fe200078e00ffULL,
0x0000005800007348ULL, 0x000fe80003800000ULL, 0x0c00000a09087389ULL, 0x0002a200000e0057ULL,
0xfffe3f5002007950ULL, 0x000fea0003c3ffffULL, 0x000000ffff6c7224ULL, 0x000fe200078e0027ULL,
0x0000008100007348ULL, 0x000fe80003800000ULL, 0x00000000ff6d7424ULL, 0x000fe200078e00ffULL,
0x0000002928287389ULL, 0x0002a600000e0084ULL, 0xfffe3f006c007950ULL, 0x000fea0003c3ffffULL,
0x000000012700780cULL, 0x000fe20003f45070ULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000008000007348ULL, 0x000ff60003800000ULL, 0x0000000000277806ULL, 0x000fc800050e0100ULL,
0x0000008027277212ULL, 0x000fe200078ec0ffULL, 0xfffe3ea028007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000360ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c98ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d58ULL,
0x000000000000089cULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001608ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001698ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000169cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001c200ULL, 0xf700001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001da80ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001dac0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001de40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001698ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001c3e8ULL,
0x000000000001c3e8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001da80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001de40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_89_cubin_len = 122656;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
