/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001abd0ULL, 0x000000000001a850ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x0000000000018c20ULL,
0x0000000000000180ULL, 0x000b0022000004c4ULL, 0x0000000000018da0ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000018de0ULL, 0x0000000000000040ULL, 0x000b002200000519ULL,
0x0000000000018e20ULL, 0x0000000000000160ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000018f80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00018c2000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x0061c80400288080ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080820828ULL, 0x2880808d08288080ULL,
0x809d082880809808ULL, 0x082880809f082880ULL, 0x8080a408288080a0ULL, 0xaa08288080a90828ULL,
0x288080b708288080ULL, 0x80bc08288080b808ULL, 0x08288080bd082880ULL, 0x8080c008288080beULL,
0xc408288080c30828ULL, 0x2880808408288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808084ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00018c2000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8c08288080820828ULL,
0x2880809008288080ULL, 0x809d082880809808ULL, 0x082880809f082880ULL, 0x8080a408288080a0ULL,
0xaa08288080a90828ULL, 0x288080b708288080ULL, 0x80bc08288080b808ULL, 0x08288080bd082880ULL,
0x8080c008288080beULL, 0x8808288080c40828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808088920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL,
0x00018da000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8c08288080820828ULL, 0x2880809008288080ULL, 0x809d082880809808ULL,
0x082880809f082880ULL, 0x8080a408288080a0ULL, 0xaa08288080a90828ULL, 0x288080b708288080ULL,
0x80bc08288080b808ULL, 0x08288080bd082880ULL, 0x8080c308288080c0ULL, 0xbe08288080c40828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080be920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000022800000000ULL, 0x00018de000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8c08288080820828ULL,
0x2880809008288080ULL, 0x809d082880809808ULL, 0x082880809f082880ULL, 0x8080a408288080a0ULL,
0xaa08288080a90828ULL, 0x288080b708288080ULL, 0x80bc08288080b808ULL, 0x08288080bd082880ULL,
0x8080c008288080beULL, 0xc308288080c40828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080c3920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL, 0x000002f800000000ULL,
0x00018e2000000000ULL, 0x0000016000000000ULL, 0x0000140400000000ULL, 0x80be288080c30900ULL,
0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x00082304000000eaULL, 0x0000000000000016ULL,
0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL,
0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0050016000000017ULL,
0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001342804ULL,
0x000003f000000110ULL, 0x00002430000023a0ULL, 0x000026b000002540ULL, 0x00002b5000002b20ULL,
0x00002c3000002bc0ULL, 0x00005df000005d50ULL, 0x0000607000005f10ULL, 0x00006510000064e0ULL,
0x000065f000006580ULL, 0x000094b000009410ULL, 0x00009740000095e0ULL, 0x00009be000009bb0ULL,
0x00009cc000009c50ULL, 0x0000cbe00000cb40ULL, 0x0000ce600000cd00ULL, 0x0000d2f00000d2c0ULL,
0x0000d3d00000d360ULL, 0x0000f4800000f470ULL, 0x000170b000017070ULL, 0x000170d0000170c0ULL,
0x0001714000017120ULL, 0x0001717000017160ULL, 0x00017e7000017e10ULL, 0x00017f7000017ef0ULL,
0x0001807000017ff0ULL, 0x00018130000180d0ULL, 0x00018210000181a0ULL, 0x0001830000018290ULL,
0x000183c000018360ULL, 0x0001849000018420ULL, 0x0001858000018510ULL, 0x00018640000185e0ULL,
0x00018720000186b0ULL, 0x00018810000187a0ULL, 0x0001890000018880ULL, 0x00018a0000018980ULL,
0x00018b0000018a80ULL, 0x00018c0000018b80ULL, 0x000001f004403904ULL, 0x00017600000000ffULL,
0x00000290003f0100ULL, 0x000176080000000dULL, 0x00000370003f0120ULL, 0x000176880000000dULL,
0x000003a0003f0120ULL, 0x000176a80000000dULL, 0x000003d0003f0120ULL, 0x000176c80000000dULL,
0x00000460003f0120ULL, 0x00017600000000ffULL, 0x00000600003f0107ULL, 0x0000000400000009ULL,
0x000006b0003f0102ULL, 0x0000000000000009ULL, 0x000010a0003f0101ULL, 0x00000000000000ffULL,
0x0000112000040107ULL, 0x00000000000000ffULL, 0x0000118000040101ULL, 0x0000002000000026ULL,
0x00001340003f0101ULL, 0x000176cc00000024ULL, 0x00001520003f0105ULL, 0x000176cc00000024ULL,
0x00001ee0003f0105ULL, 0x000176a800000028ULL, 0x00002050003f0107ULL, 0x000176a800000028ULL,
0x000020b0003f0101ULL, 0x0001760800000026ULL, 0x000020d0003f0101ULL, 0x0001760c00000026ULL,
0x000022a0003f0105ULL, 0x0001760c00000026ULL, 0x00002880003f0105ULL, 0x000176ac00000040ULL,
0x00002a50003f0105ULL, 0x000176ac00000040ULL, 0x00004c40003f0105ULL, 0x000176c80000003cULL,
0x00004cc0003f0101ULL, 0x0001768800000053ULL, 0x00004d50003f0101ULL, 0x000000040000002aULL,
0x00004f20003f0105ULL, 0x000000040000002aULL, 0x00005920003f0105ULL, 0x000176a800000054ULL,
0x00005a50003f0107ULL, 0x000176a800000054ULL, 0x00005ab0003f0101ULL, 0x0001762800000026ULL,
0x00005ad0003f0101ULL, 0x0001762c00000026ULL, 0x00005ca0003f0105ULL, 0x0001762c00000026ULL,
0x00006240003f0105ULL, 0x000176ac00000028ULL, 0x00006410003f0105ULL, 0x000176ac00000028ULL,
0x00008400003f0105ULL, 0x000000000000003cULL, 0x00008470003f0101ULL, 0x0001769000000053ULL,
0x000084e0003f0101ULL, 0x000000040000002aULL, 0x000086b0003f0105ULL, 0x000000040000002aULL,
0x00008fb0003f0105ULL, 0x0000000000000052ULL, 0x00009110003f0107ULL, 0x000176a800000028ULL,
0x00009170003f0101ULL, 0x0001764800000026ULL, 0x00009190003f0101ULL, 0x0001764c00000026ULL,
0x00009360003f0105ULL, 0x0001764c00000026ULL, 0x00009910003f0105ULL, 0x000176ac00000054ULL,
0x00009ae0003f0105ULL, 0x000176ac00000054ULL, 0x0000bb10003f0105ULL, 0x000000000000003cULL,
0x0000bb80003f0101ULL, 0x0001769800000053ULL, 0x0000bc10003f0101ULL, 0x000000040000002aULL,
0x0000bde0003f0105ULL, 0x000000040000002aULL, 0x0000c6e0003f0105ULL, 0x0000000000000055ULL,
0x0000c840003f0107ULL, 0x000176a800000054ULL, 0x0000c8a0003f0101ULL, 0x0001766800000026ULL,
0x0000c8c0003f0101ULL, 0x0001766c00000026ULL, 0x0000ca90003f0105ULL, 0x0001766c00000026ULL,
0x0000d020003f0105ULL, 0x000176ac00000028ULL, 0x0000d1f0003f0105ULL, 0x000176ac00000028ULL,
0x0000f140003f0105ULL, 0x0000000000000026ULL, 0x0000f1a0003f0101ULL, 0x000176a000000053ULL,
0x000100a0003f0101ULL, 0x00017600000000ffULL, 0x00011d70003f0101ULL, 0x00017604000000ffULL,
0x00011f40003f0105ULL, 0x00017604000000ffULL, 0x00012170003f0105ULL, 0x00017600000000ffULL,
0x000121a0003f0101ULL, 0x00017604000000ffULL, 0x00012360003f0105ULL, 0x00017604000000ffULL,
0x000164a0003f0105ULL, 0x000000000000003fULL, 0x000165c0003f0101ULL, 0x000000040000003fULL,
0x00016790003f0105ULL, 0x000000040000003fULL, 0x00017c50003f0105ULL, 0x0000000000000041ULL,
0x00017cb0003f0101ULL, 0x0000000800000041ULL, 0x00017d10003f0101ULL, 0x0000001000000041ULL,
0x00017d80003f0101ULL, 0x0000001800000041ULL, 0x00053803003f0101ULL, 0x0000fd4000141c04ULL,
0x000123c00000ffc0ULL, 0x00017dd000012470ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000003b4ULL, 0x0000001a00000002ULL, 0x00000000000002e4ULL, 0x0000001a00000002ULL,
0x0000000000000214ULL, 0x0000001a00000002ULL, 0x000000000000012cULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x000000000000038aULL, 0x0000001a00000002ULL,
0x00000000000002baULL, 0x0000001a00000002ULL, 0x00000000000001eaULL, 0x0000001a00000002ULL,
0x0000000000000107ULL, 0x0000001a00000002ULL, 0x0000000000017700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff247624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001000047300ULL, 0x000ee200000e0000ULL, 0x0000000824067824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000f280000002200ULL, 0x0000000000157919ULL, 0x000ee20000002600ULL,
0x0000001000107309ULL, 0x000ea60000000000ULL, 0x00000000003c7919ULL, 0x000ee80000002700ULL,
0x0000000000337919ULL, 0x000ee20000000000ULL, 0x00000005ff257819ULL, 0x002fc6000001160dULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x00001fff03007589ULL, 0x0045e200000e0000ULL,
0x0000010003027a24ULL, 0x010fc600078e0202ULL, 0x00001fff25257589ULL, 0x000f2200000e0000ULL,
0x00000000020d7a24ULL, 0x000fe400078e020dULL, 0x0000000815077824ULL, 0x008fc600078e00ffULL,
0x000000ff0d00720cULL, 0x040fe20003f45270ULL, 0x0000003c06077224ULL, 0x000fe200078e0207ULL,
0x0000007f0d00780cULL, 0x040fe40003f84070ULL, 0x0000000f0d00780cULL, 0x040fe40003f64070ULL,
0x00000004ff0f7819ULL, 0x000fe40000011633ULL, 0x000000030d00780cULL, 0x000fe40003f24070ULL,
0x000000050400720cULL, 0x002fc60003f02070ULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x004fe400078e00ffULL, 0x0000000400087824ULL, 0x010fe400078e0225ULL,
0xff317217ff0ec424ULL, 0x000fe200078e00ffULL, 0x01760002ff00a388ULL, 0x0003e20000000a00ULL,
0x0000000208067824ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f44070ULL,
0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL, 0x0174000e0d00c388ULL, 0x0005e20000004800ULL,
0x00000001060a7824ULL, 0x040fe200078e020fULL, 0x00000008060b7817ULL, 0x000fe20007800000ULL,
0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL, 0x3fffff60ff089424ULL, 0x000fe400078e00ffULL,
0x000000010b0c7824ULL, 0x000fe200078e0a06ULL, 0x017608040d00b388ULL, 0x0007e20000008a00ULL,
0x0000001033067824ULL, 0x000fe400078e00ffULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x0000000c0f00720cULL, 0x000fe20003f66070ULL, 0x0000000107027824ULL, 0x000fe200078e020aULL,
0x000000f006117812ULL, 0x000fe200078ec0ffULL, 0x000000010a077824ULL, 0x000fc400078e0233ULL,
0x000000100a0e7824ULL, 0x004fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0003ULL,
0xfffffff00e0c7812ULL, 0x000fe200078ee207ULL, 0x7fffff60ff099424ULL, 0x000fe200078e00ffULL,
0x0000001102027210ULL, 0x000fe20007f9e0ffULL, 0x3fffff80ff049424ULL, 0x008fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe200078e00ffULL, 0x017688080d009388ULL, 0x0003e20000008a00ULL,
0x3fffffc0ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x0176a8040d009388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fc400020e0603ULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0x0176c80a0d00a388ULL, 0x000fe20000008a00ULL,
0x000000100c097824ULL, 0x002fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff087224ULL, 0x000fe200078e0a10ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000d901c46ULL, 0x000062003c047625ULL, 0x000fc600078e0007ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01760408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fc40003f05270ULL,
0x0000003f03027810ULL, 0x044fe40007ffe0ffULL, 0x000000ff03087810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff027819ULL, 0x000fe40000011602ULL, 0x00000008ff007819ULL, 0x000fca0000011608ULL,
0x0000fa8000008947ULL, 0x000fea0003800000ULL, 0x00000002ff367819ULL, 0x000fe20000011625ULL,
0x00000003ff0c7424ULL, 0x000fe200078e00ffULL, 0x0001768825097811ULL, 0x000fe200078e18ffULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x03ffffff365b7812ULL, 0x000fc800078ec0ffULL,
0x000000025b00720cULL, 0x000fda0003f06070ULL, 0x000000023c048824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640004048624ULL, 0x000fc800078e0205ULL,
0x000000015b048824ULL, 0x000fe200078e0204ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040c09ff738cULL, 0x0003e20000000000ULL, 0x0000600004048625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006040a8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000004015317824ULL, 0x000fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fe20000011625ULL, 0x0000000009ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000125087812ULL, 0x000fc600078ec0ffULL, 0x0000002034327824ULL, 0x000fe400078e00ffULL,
0x000058000a0b7a24ULL, 0x004fc600078e02ffULL, 0x00000020310a7812ULL, 0x000fe200078ef832ULL,
0x000000400b117824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000003203057217ULL, 0x008fe20007800000ULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fe40000011633ULL, 0x0000007006197812ULL, 0x000fe200078ec0ffULL,
0x0000000105057824ULL, 0x000fe200078e0a32ULL, 0x00000004040c7810ULL, 0x002fe20007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0204ULL, 0x00000008040d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000805057217ULL, 0x000fe20007800000ULL, 0x00000001090b7824ULL, 0x040fe400078e0233ULL,
0x00000008090e7824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x000fe400078e0a08ULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0xfffffff80e0b7812ULL, 0x000fe400078ee20bULL,
0x000000050c00720cULL, 0x000fe20003f46070ULL, 0x00000001080c7824ULL, 0x000fe200078e020cULL,
0x0000000911097210ULL, 0x000fc40007f1e0ffULL, 0x000000050400720cULL, 0x080fe20003f66070ULL,
0x000000080c137824ULL, 0x000fe200078e00ffULL, 0x0000000c040e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c047824ULL, 0x000fe200078e0233ULL, 0x000000050d00720cULL, 0x080fe20003f26070ULL,
0x00000001080d7824ULL, 0x000fe200078e020dULL, 0x00005e0009147a11ULL, 0x000fe200078838ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x000000050e00720cULL, 0x000fe20003f06070ULL,
0x000000010a0c7824ULL, 0x040fe200078e020cULL, 0xfffffff813057812ULL, 0x000fe200078ee204ULL,
0x000000010a047824ULL, 0x000fe200078e020dULL, 0x00005f0009157a11ULL, 0x000fe200020f3c10ULL,
0x00000001080f7824ULL, 0x000fe200078e020eULL, 0x0000000c110c7210ULL, 0x000fe20007f9e0ffULL,
0x000000010d087824ULL, 0x000fe200078e0233ULL, 0x00000004110e7210ULL, 0x000fe20007fbe0ffULL,
0x000000080d097824ULL, 0x000fc400078e00ffULL, 0x000000010a0a7824ULL, 0x000fe400078e020fULL,
0x000000010f047824ULL, 0x000fe200078e0233ULL, 0xfffffff809097812ULL, 0x000fe200078ee208ULL,
0x000000080f0d7824ULL, 0x000fe200078e00ffULL, 0x0001300034087811ULL, 0x000fe200078e68ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e06ffULL, 0x00005e000c107a11ULL, 0x040fe200078838ffULL,
0x000000ffff177224ULL, 0x000fe200028e06ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee204ULL,
0x0000001009137824ULL, 0x100fe200078e0208ULL, 0x00005f000c127a11ULL, 0x000fe200020f3c0fULL,
0x000000100b0f7824ULL, 0x000fe200078e0208ULL, 0x0000001419047210ULL, 0x000fc40007f9e0ffULL,
0x0000000a110a7210ULL, 0x000fe20007fde0ffULL, 0x0000001005117824ULL, 0x100fe200078e0208ULL,
0x00005e000e0b7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff057224ULL, 0x000fe400020e0615ULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005e000a0c7a11ULL, 0x000fe200078c38ffULL,
0x000000100d157824ULL, 0x000fe200078e0208ULL, 0x0000001910087210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000d901c46ULL,
0x00005f000e0d7a11ULL, 0x000fc400028f3c17ULL, 0x00005f000a067a11ULL, 0x000fe200030f3c09ULL,
0x000000ffff097224ULL, 0x000fe200020e0612ULL, 0x000000190b0a7210ULL, 0x080fe40007fbe0ffULL,
0x000000190c0c7210ULL, 0x000fe40007f9e0ffULL, 0x0000000008117faeULL, 0x0003e2000d101c46ULL,
0x000000ffff0b7224ULL, 0x000fe400028e060dULL, 0x000000ffff0d7224ULL, 0x000fc600020e0606ULL,
0x000000000a137faeULL, 0x0003e8000c901c46ULL, 0x000000000c157faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001008047824ULL, 0x008fe200078e00ffULL,
0x0001300034157811ULL, 0x000fe400078e68ffULL, 0x0000007006177812ULL, 0x000fe400078ec0ffULL,
0x0000000433047211ULL, 0x000fc800078fe8ffULL, 0x0000000404087810ULL, 0x040fe20007ffe0ffULL,
0x0000000104057824ULL, 0x140fe200078e0233ULL, 0x00000008040b7810ULL, 0x040fe20007ffe0ffULL,
0x00000008040c7824ULL, 0x042fe200078e00ffULL, 0x0000000c040d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a047824ULL, 0x000fe400078e0204ULL, 0x0000000108097824ULL, 0x000fe200078e0233ULL,
0xfffffff80c057812ULL, 0x000fe200078ee205ULL, 0x00000008080e7824ULL, 0x000fe200078e00ffULL,
0x0000000411147210ULL, 0x000fe20007f3e0ffULL, 0x000000010a087824ULL, 0x000fc400078e0208ULL,
0x000000010a0c7824ULL, 0x000fe200078e020bULL, 0xfffffff80e097812ULL, 0x000fe200078ee209ULL,
0x000000010b047824ULL, 0x000fe200078e0233ULL, 0x0000000811127210ULL, 0x000fe20007f5e0ffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x0000000c110e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x00005e00140c7a11ULL, 0x000fe200078238ffULL,
0x000000010a0a7824ULL, 0x000fe200078e020dULL, 0xfffffff80f047812ULL, 0x000fe200078ee204ULL,
0x000000010d087824ULL, 0x000fe200078e0233ULL, 0x00005f0014147a11ULL, 0x000fe200008f3c0bULL,
0x00000010050f7824ULL, 0x100fe200078e0215ULL, 0x0000000a110a7210ULL, 0x000fe20007f1e0ffULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0x00005e0012107a11ULL, 0x000fe200078238ffULL,
0x000000ffff057224ULL, 0x000fe200010e06ffULL, 0x00005e000e0b7a11ULL, 0x000fe200078438ffULL,
0x0000001009117824ULL, 0x100fe200078e0215ULL, 0xfffffff80d087812ULL, 0x000fe200078ee208ULL,
0x0000001004137824ULL, 0x000fe200078e0215ULL, 0x00005f0012127a11ULL, 0x000fe200008f3c05ULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x0000000c17047210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e000a0c7a11ULL, 0x000fe200078638ffULL,
0x0000001008157824ULL, 0x000fe200078e0215ULL, 0x0000001017087210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0614ULL, 0x00005f000a067a11ULL, 0x000fc400018f3c09ULL,
0x00005f000e0d7a11ULL, 0x000fe200010f3c0dULL, 0x000000ffff097224ULL, 0x000fe200000e0612ULL,
0x0000000b170a7210ULL, 0x040fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e2000b901c46ULL, 0x0000000c170c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060dULL, 0x0000000008117faeULL, 0x0003e2000b901c46ULL,
0x000000ffff0d7224ULL, 0x000fc600010e0606ULL, 0x000000000a137faeULL, 0x0003e8000b901c46ULL,
0x000000000c157faeULL, 0x0003e4000b901c46ULL, 0x000000015b5b7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff307424ULL, 0x000fc600078e00ffULL, 0x000000025b00720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x000000023c047824ULL, 0x002fe400078e00ffULL,
0x00006400ff057624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0205ULL,
0x0000000104047824ULL, 0x000fc800078e025bULL, 0x0000600004047625ULL, 0x000fca00078e0007ULL,
0x0000000604307981ULL, 0x000324000c1e1900ULL, 0x00000000340473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000176a834267811ULL, 0x000fe200078e18ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x002fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x000176a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff5c7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200026267f8cULL, 0x000ea2000c80043fULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000dff000008947ULL, 0x000fea0003800000ULL, 0x000000023c2f7824ULL, 0x000fe400078e00ffULL,
0x00006400ff247624ULL, 0x000fc400078e00ffULL, 0x000000ffff407224ULL, 0x004fe400078e0027ULL,
0x000064002f2f7624ULL, 0x000fe400078e0224ULL, 0xff317217ff5f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fc400078e00ffULL, 0x000001002d247824ULL, 0x000fca00078e00ffULL,
0x000000032400720cULL, 0x000fda0003f06070ULL, 0x0000df0000000947ULL, 0x004fea0003800000ULL,
0x000000ffff2c7224ULL, 0x000fe400078e005bULL, 0x000000ffff2b7224ULL, 0x000fc400078e003dULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x0000000425247824ULL, 0x000fca00078e00ffULL,
0xfffffff824247812ULL, 0x000fc800078ec0ffULL, 0x000176c8242a7810ULL, 0x000fe20007ffe0ffULL,
0x0176cc0024297984ULL, 0x000ea40000000800ULL, 0x8000000029ff7812ULL, 0x004fe40007804840ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826397210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000003928287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176cc0024297984ULL, 0x000ea40000000800ULL, 0x8000000029ff7812ULL, 0x004fe40007804840ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001025247824ULL, 0x000fe200078e00ffULL, 0x000000012d277810ULL, 0x000fe20007ffe0ffULL,
0x0000580030307a24ULL, 0x010fe200078e02ffULL, 0x000000013d297812ULL, 0x000fe400078e0cffULL,
0x000000002700720cULL, 0x000fe20003f06070ULL, 0x0000004030457824ULL, 0x000fe200078e00ffULL,
0xffffffe024267812ULL, 0x000fca00078ec0ffULL, 0x000001002d267824ULL, 0x000fca00078e0226ULL,
0x0000004026287810ULL, 0x000fc80007ffe0ffULL, 0x0000002031437812ULL, 0x000fe200078ef828ULL,
0x0000049000008947ULL, 0x000fea0003800000ULL, 0x0000001024397812ULL, 0x000fe200078ec0ffULL,
0x00000002343f7824ULL, 0x000fe200078e0229ULL, 0x00000003ff407819ULL, 0x000fc80000011633ULL,
0x0000000440427810ULL, 0x040fe20007ffe0ffULL, 0x0000000140267824ULL, 0x140fe200078e0239ULL,
0x000130003f3f7811ULL, 0x000fe400078e60ffULL, 0x0000000c40447810ULL, 0x000fe20007ffe0ffULL,
0x0000000143247824ULL, 0x000fe400078e0226ULL, 0x0000000142307824ULL, 0x000fe400078e0239ULL,
0x00000008263c7824ULL, 0x000fe200078e00ffULL, 0x00000024453e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000830497824ULL, 0x000fe200078e00ffULL, 0x0000002803247217ULL, 0x000fc60007800000ULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x00005e003e3a7a11ULL, 0x000fe200078038ffULL,
0x0000000124247824ULL, 0x000fe400078e0a28ULL, 0x0000000143287824ULL, 0x000fe200078e0230ULL,
0x00005f003e3e7a11ULL, 0x000fe200000f3c27ULL, 0x0000001033277824ULL, 0x000fe200078e00ffULL,
0x0000003924247217ULL, 0x000fe40007800000ULL, 0x00000028453b7210ULL, 0x000fe40007fde0ffULL,
0x0000007027477812ULL, 0x000fe200078ec0ffULL, 0x0000000124247824ULL, 0x000fc400078e0a39ULL,
0x0000000126277824ULL, 0x000fe200078e0233ULL, 0x000000473a267210ULL, 0x000fe40007fbe0ffULL,
0x000000244000720cULL, 0x080fe40003f06070ULL, 0xfffffff83c287812ULL, 0x000fe200078ee227ULL,
0x000000ffff277224ULL, 0x000fe200028e063eULL, 0x000000244200720cULL, 0x000fe20003fa6070ULL,
0x000000ffff3c7224ULL, 0x000fe200030e06ffULL, 0x00005e003b3a7a11ULL, 0x040fe200078c38ffULL,
0x0000001028417824ULL, 0x000fe200078e023fULL, 0x0000000840427810ULL, 0x000fe20007ffe0ffULL,
0x0000000130287824ULL, 0x000fe200078e0233ULL, 0x00005f003b3b7a11ULL, 0x000fe200030f3c3cULL,
0x00000001443e7824ULL, 0x000fc400078e0239ULL, 0x00000001423c7824ULL, 0x000fe200078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026417faeULL, 0x0005e2000c101c46ULL,
0x000000473a3a7210ULL, 0x000fe40007f1e0ffULL, 0x0000000143307824ULL, 0x000fe200078e023cULL,
0xfffffff849287812ULL, 0x000fe400078ee228ULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x000000244200720cULL, 0x000fe40003f06070ULL, 0x0000003045407210ULL, 0x000fe20007fde0ffULL,
0x0000001028397824ULL, 0x000fc400078e023fULL, 0x0000000143267824ULL, 0x004fe400078e023eULL,
0x000000ffff417224ULL, 0x000fe200030e06ffULL, 0x000000003a397faeULL, 0x0005e2000e901c46ULL,
0x00005e0040277a11ULL, 0x000fe200078a38ffULL, 0x000000083c437824ULL, 0x000fe200078e00ffULL,
0x0000002645307210ULL, 0x000fe40007fde0ffULL, 0x00005f0040287a11ULL, 0x000fe400028f3c41ULL,
0x000000244400720cULL, 0x000fe20003fa6070ULL, 0x000000ffff417224ULL, 0x000fe200030e06ffULL,
0x0000004727267210ULL, 0x000fe20007fde0ffULL, 0x000000013c247824ULL, 0x000fc400078e0233ULL,
0x000000083e397824ULL, 0x004fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe200030e0628ULL,
0x00005e00303a7a11ULL, 0x000fe200078c38ffULL, 0x000000013e287824ULL, 0x000fe200078e0233ULL,
0xfffffff843247812ULL, 0x000fe400078ee224ULL, 0x00005f0030307a11ULL, 0x000fe400030f3c41ULL,
0x000000473a3a7210ULL, 0x000fe40007fde0ffULL, 0xfffffff839287812ULL, 0x000fe200078ee228ULL,
0x0000001024397824ULL, 0x000fc400078e023fULL, 0x000000ffff3b7224ULL, 0x000fe400030e0630ULL,
0x00000010283f7824ULL, 0x000fe200078e023fULL, 0x0000000026397faeULL, 0x0005e8000c101c46ULL,
0x000000003a3f7faeULL, 0x0005e2000e901c46ULL, 0x000003c000007947ULL, 0x000fea0003800000ULL,
0x0000001024247812ULL, 0x000fe200078ec0ffULL, 0x0000001033407824ULL, 0x040fe400078e00ffULL,
0x0000000234447824ULL, 0x000fe200078e0229ULL, 0x0000002433247211ULL, 0x000fc800078fe8ffULL,
0x0000000424307810ULL, 0x040fe20007ffe0ffULL, 0x0000000143267824ULL, 0x000fe200078e0224ULL,
0x0000000c243a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000124277824ULL, 0x100fe200078e0233ULL,
0x0001300044477811ULL, 0x000fe200078e60ffULL, 0x0000000130397824ULL, 0x040fe200078e0233ULL,
0x0000002645427210ULL, 0x000fe20007f1e0ffULL, 0x00000008303c7824ULL, 0x000fe200078e00ffULL,
0x0000000824267810ULL, 0x040fe20007ffe0ffULL, 0x0000000824287824ULL, 0x000fe400078e00ffULL,
0x0000000143307824ULL, 0x040fe200078e0230ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee239ULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0x00005e0042417a11ULL, 0x000fe200078038ffULL,
0x0000000143247824ULL, 0x040fe200078e0226ULL, 0xfffffff828287812ULL, 0x000fe200078ee227ULL,
0x0000000143277824ULL, 0x000fe200078e023aULL, 0x00005f0042427a11ULL, 0x000fe200000f3c39ULL,
0x0000000826437824ULL, 0x000fe200078e00ffULL, 0x0000003045397210ULL, 0x000fc40007fde0ffULL,
0x00000024453f7210ULL, 0x040fe20007fbe0ffULL, 0x0000000126247824ULL, 0x100fe200078e0233ULL,
0x0000002745277210ULL, 0x000fe20007f1e0ffULL, 0x000000013a267824ULL, 0x040fe400078e0233ULL,
0x000000083a457824ULL, 0x000fe200078e00ffULL, 0xfffffff843247812ULL, 0x000fe200078ee224ULL,
0x000000ffff3a7224ULL, 0x000fe200030e06ffULL, 0x00005e00393b7a11ULL, 0x000fe400078c38ffULL,
0xfffffff845307812ULL, 0x000fe200078ee226ULL, 0x000000ffff267224ULL, 0x000fe200028e06ffULL,
0x00005f0039397a11ULL, 0x000fe200030f3c3aULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078a38ffULL, 0x0000001024457824ULL, 0x000fe200078e0247ULL,
0x0000007040437812ULL, 0x000fc400078ec0ffULL, 0x00005e0027407a11ULL, 0x000fe400078c38ffULL,
0x00005f003f3f7a11ULL, 0x000fe400028f3c26ULL, 0x0000004341267210ULL, 0x080fe40007f1e0ffULL,
0x00005f0027417a11ULL, 0x000fe400030f3c3aULL, 0x000000433b3a7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0642ULL, 0x000000433e3e7210ULL, 0x000fc60007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200028e0639ULL, 0x0000004340407210ULL, 0x000fe20007fbe0ffULL,
0x0000001028397824ULL, 0x100fe400078e0247ULL, 0x000000103c437824ULL, 0x000fe400078e0247ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026397faeULL, 0x0005e2000b901c46ULL, 0x0000001030477824ULL, 0x000fe400078e0247ULL,
0x000000ffff417224ULL, 0x000fe200028e0641ULL, 0x000000003a437faeULL, 0x0005e8000b901c46ULL,
0x000000003e457faeULL, 0x0005e8000b901c46ULL, 0x0000000040477faeULL, 0x0005e4000b901c46ULL,
0x0000000825247824ULL, 0x000fe200078e00ffULL, 0x000000015b3a7810ULL, 0x004fe20007ffe0ffULL,
0xffffffffff307424ULL, 0x000fc600078e00ffULL, 0xfffffff024287812ULL, 0x000fe400078ec0ffULL,
0x000000023a00720cULL, 0x000fc60003f06070ULL, 0x0000000829287824ULL, 0x000fca00078e0228ULL,
0x0000000000007918ULL, 0x000fea0000000000ULL, 0x000000012f3a8824ULL, 0x000fe400078e023aULL,
0x00000004ff3b8424ULL, 0x000fe200078e00ffULL, 0xffffffe024267812ULL, 0x040fe400078ec0ffULL,
0x0000001024277812ULL, 0x000fe200078ec0ffULL, 0x000060003a3a8625ULL, 0x000fe200078e003bULL,
0x0000000824247812ULL, 0x000fe200078ec0ffULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000176a828527810ULL, 0x000fc40007ffe0ffULL, 0x000000063a308981ULL, 0x000522000c1e1900ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000002624267210ULL, 0x000fd60007ffe027ULL,
0x00000000520403c2ULL, 0x000ee40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a800284c7f8cULL, 0x0006a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176080026407f8cULL, 0x0006a4000c80043fULL,
0x00000000003a7805ULL, 0x004fc40000015200ULL, 0x01760c0026277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fc40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3a277210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3e7824ULL, 0x000fe200000e0e3bULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff3e00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff3e00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001143eULL, 0x0000002724247211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e063eULL, 0x0000000224247819ULL, 0x000fc80000001227ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000139397810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760c0026277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001033397824ULL, 0x000fe200078e00ffULL,
0x00000001ff247819ULL, 0x000fe20000011633ULL, 0x0000002025277824ULL, 0x000fc600078e00ffULL,
0x00000070393c7812ULL, 0x000fe400078ec0ffULL, 0xffffff8027277812ULL, 0x000fe400078ec0ffULL,
0x0000000c24247812ULL, 0x000fc800078ec0ffULL, 0x0000002724397210ULL, 0x000fca0007ffe03cULL,
0x01700000393a7984ULL, 0x000ea80000000800ULL, 0x01720000393b7984ULL, 0x0006620000000800ULL,
0x0000005f3a00720bULL, 0x004fe20003f1d000ULL, 0x00015a427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000397806ULL, 0x008fc800000e0100ULL, 0x0000ffff39407812ULL, 0x000fe2000780c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x00000001ff937424ULL, 0x000fe400078e00ffULL,
0x000000ffff567224ULL, 0x000fd200078e005fULL, 0x0000043000008947ULL, 0x000fea0003800000ULL,
0x000000253600720cULL, 0x000fe40003fa5270ULL, 0x0000005f3a00720bULL, 0x000fe20003f14000ULL,
0x00015a127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400000e0100ULL,
0x00000080253fd824ULL, 0x000fe200078e023cULL, 0x0000003a5f567209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910393c7816ULL, 0x000fe200000000ffULL,
0x00000001243fd824ULL, 0x000fc600078e023fULL, 0x000000ff3c00720cULL, 0x000fe40003f05270ULL,
0x017400563f00d388ULL, 0x0005f60000000800ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000565f3c7221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b3c3c7820ULL, 0x000fc80000410000ULL,
0x0000003c00417308ULL, 0x0004ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff3c7819ULL, 0x004fe20000011633ULL, 0x000159627f007947ULL, 0x000fea000b800000ULL,
0x00001f3c413c7589ULL, 0x0084e400000e0000ULL, 0x0000003c20207220ULL, 0x088fe40000410000ULL,
0x0000003c21217220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x000fc40000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000003c18187220ULL, 0x080fe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c14147220ULL, 0x080fe40000410000ULL,
0x0000003c15157220ULL, 0x080fe40000410000ULL, 0x0000003c10107220ULL, 0x000fc40000410000ULL,
0x0000003c11117220ULL, 0x080fe40000410000ULL, 0x0000003c0c0c7220ULL, 0x080fe40000410000ULL,
0x0000003c0d0d7220ULL, 0x080fe40000410000ULL, 0x0000003c08087220ULL, 0x080fe40000410000ULL,
0x0000003c09097220ULL, 0x080fe40000410000ULL, 0x0000003c04047220ULL, 0x000fc40000410000ULL,
0x0000003c05057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fe2000780c0ffULL, 0x000000412e2e7220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008333c7811ULL, 0x004fe200078ff0ffULL,
0x000158727f007947ULL, 0x000fea000b800000ULL, 0x00001f3c413c7589ULL, 0x0004e400000e0000ULL,
0x0000003c22227220ULL, 0x088fe40000410000ULL, 0x0000003c23237220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe40000410000ULL, 0x0000003c1b1b7220ULL, 0x000fc40000410000ULL,
0x0000003c16167220ULL, 0x080fe40000410000ULL, 0x0000003c17177220ULL, 0x080fe40000410000ULL,
0x0000003c12127220ULL, 0x080fe40000410000ULL, 0x0000003c13137220ULL, 0x080fe40000410000ULL,
0x0000003c0e0e7220ULL, 0x080fe40000410000ULL, 0x0000003c0f0f7220ULL, 0x000fc40000410000ULL,
0x0000003c0a0a7220ULL, 0x080fe40000410000ULL, 0x0000003c0b0b7220ULL, 0x080fe40000410000ULL,
0x0000003c06067220ULL, 0x080fe40000410000ULL, 0x0000003c07077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff40ff7812ULL, 0x000fda0007806039ULL,
0x800000563a3a0221ULL, 0x000fe20000010000ULL, 0x00007610ff930816ULL, 0x000fc60000000093ULL,
0x3fb8aa3b3a3a0820ULL, 0x000fc80000410000ULL, 0x0000003a00350308ULL, 0x000ea40000000800ULL,
0x000000353b3b0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002e3b2e7221ULL, 0x002fc40000010000ULL, 0x00000000003a7805ULL, 0x000fca0000015200ULL,
0x0000000234397824ULL, 0x000fc800078e023dULL, 0x0000000839407824ULL, 0x000fca00078e00ffULL,
0x0176ac00403c7984ULL, 0x000e640000000800ULL, 0x800000003cff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3a3c7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3e7824ULL, 0x000fe200000e0e3bULL, 0x003d09003c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff397819ULL, 0x000fc8000001143eULL,
0x0000003c39397211ULL, 0x000fca00078110ffULL, 0x000000ffff3c7224ULL, 0x000fca00000e063eULL,
0x0000000239397819ULL, 0x000fc8000000123cULL, 0x000000390000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000141417810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac00403c7984ULL, 0x000e640000000800ULL,
0x800000003cff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991093397816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff3900720cULL, 0x000fda0003fc5270ULL, 0x0000016000006947ULL, 0x000fea0003800000ULL,
0x00000035ff37723eULL, 0x000fe400000010ffULL, 0x00000002ff3a7819ULL, 0x000fe40000011633ULL,
0x0000541037397816ULL, 0x000fe20000000037ULL, 0x000154827f007947ULL, 0x000fea000b800000ULL,
0x00001f3a39377589ULL, 0x0002a400000e0000ULL, 0x000000083a387810ULL, 0x000fe20007ffe0ffULL,
0x000154d27f007947ULL, 0x000fea000b800000ULL, 0x00001f3839387589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000103a447810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200078e0039ULL, 0x00002bd0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0001621000007944ULL, 0x01cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000183a447810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x004fe200078e0039ULL,
0x00002c40003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000161a000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007333a7812ULL, 0x002fe200078ec0ffULL,
0x00000002255f7824ULL, 0x040fe200078e00ffULL, 0x00000004ff9d7819ULL, 0x100fe20000011633ULL,
0x0000020025a07824ULL, 0x000fe200078e00ffULL, 0x000000083a3a7812ULL, 0x000fe200078ef833ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000045f397812ULL, 0x008fe400078ec0ffULL,
0xfffff800a0a07812ULL, 0x000fe200078ec0ffULL, 0x000000083a3c7824ULL, 0x040fe200078e00ffULL,
0x000000393a397210ULL, 0x000fc40007ffe09dULL, 0x0000000833507812ULL, 0x000fe400078ec0ffULL,
0xfffffff83c397812ULL, 0x000fca00078ee239ULL, 0x0000001039397824ULL, 0x000fc400078e02a0ULL,
0x00000004253c7824ULL, 0x000fe200078e00ffULL, 0x0000000750507812ULL, 0x000fe200078ef833ULL,
0x0000000234577824ULL, 0x000fe200078e023dULL, 0x0000991093937816ULL, 0x000fe400000000ffULL,
0x000000043c3c7812ULL, 0x000fe400078ec0ffULL, 0x0001300057577811ULL, 0x000fe400078e60ffULL,
0x0000001050427812ULL, 0x000fe200078efcffULL, 0x000000019d517824ULL, 0x000fc400078e023cULL,
0x00000008503c7824ULL, 0x040fe400078e00ffULL, 0x00000001503b7824ULL, 0x000fe400078e0251ULL,
0x00000008424e7824ULL, 0x000fe400078e00ffULL, 0x00000001513f7824ULL, 0x000fe200078e0242ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee23bULL, 0x00000004349d7824ULL, 0x000fe200078e029dULL,
0x000000023b4f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee23fULL,
0x000000103c3c7824ULL, 0x000fe200078e0257ULL, 0x000000023f3b7810ULL, 0x000fc40007ffe0ffULL,
0x000000029d9d7810ULL, 0x000fe20007ffe03aULL, 0x000000104e487824ULL, 0x000fe200078e0257ULL,
0x000000003c44783bULL, 0x000e620000004200ULL, 0x000000083a3a7824ULL, 0x000fc800078e00ffULL,
0x000000004848783bULL, 0x000ee20000004200ULL, 0xfffffff83a9d7812ULL, 0x000fca00078ee29dULL,
0x000000109d3a7824ULL, 0x000fe200078e02a0ULL, 0x00000018ff3c7819ULL, 0x002fe20000011444ULL,
0x00000044006e7306ULL, 0x000fe20000009400ULL, 0x0000010044667824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe20000011445ULL, 0x0000010045677824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe40000011446ULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x00000044006f7306ULL, 0x000e620000005400ULL, 0x00000018ff677819ULL, 0x000fc40000011467ULL,
0x00000018ff547819ULL, 0x000fe40000011447ULL, 0x00000018ff557819ULL, 0x008fe40000011448ULL,
0x00000018ff597819ULL, 0x000fe2000001144bULL, 0x0000003c00717306ULL, 0x000ff00000209400ULL,
0x0000003c00727306ULL, 0x000fe20000205400ULL, 0x0000006f6e00720bULL, 0x002fce0003fbd000ULL,
0x0000003c00927306ULL, 0x0003f0000020d400ULL, 0x0000004400987306ULL, 0x0006a2000000d400ULL,
0x00000008503c7824ULL, 0x002fca00078e00ffULL, 0xfffffff83c4f7812ULL, 0x000fe200078ee24fULL,
0x00000008423c7824ULL, 0x000fe200078e00ffULL, 0x0000006600dd7306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x008fe400078e00ffULL, 0x000000104f407824ULL, 0x000fe200078e0257ULL,
0xfffffff83c3b7812ULL, 0x000fe400078ee23bULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000006600707306ULL, 0x000e620000205400ULL, 0x000000004040783bULL, 0x004fe20000004200ULL,
0x0000000198985812ULL, 0x000fe200078efcffULL, 0x000000103b3c7824ULL, 0x000fe200078e0257ULL,
0x000000727100720bULL, 0x000fc40003fbd000ULL, 0x00000018ff577819ULL, 0x000fe40000011449ULL,
0x0000006600a97306ULL, 0x000eb0000020d400ULL, 0x0000004500767306ULL, 0x000fe20000009400ULL,
0x00000070dd00720bULL, 0x002fc40003f1d000ULL, 0x0000000192925812ULL, 0x000fca00078efcffULL,
0x0000004500977306ULL, 0x000e6c0000005400ULL, 0x00000001a9a90812ULL, 0x004fe400078efcffULL,
0x0000004400d87306ULL, 0x000ff00000209400ULL, 0x0000004400737306ULL, 0x000ea20000205400ULL,
0x000000977600720bULL, 0x002fce0003fbd000ULL, 0x0000004500947306ULL, 0x0002f0000000d400ULL,
0x0000004400957306ULL, 0x000ee2000020d400ULL, 0x0001000045457824ULL, 0x002fe200078e00ffULL,
0x00000073d800720bULL, 0x004fc80003f1d000ULL, 0x00000018ff667819ULL, 0x000fe20000011445ULL,
0x0000010046457824ULL, 0x000fe200078e00ffULL, 0x0000003d00b87306ULL, 0x000fe20000209400ULL,
0x0000000194945812ULL, 0x008fc600078efcffULL, 0x00000018ff697819ULL, 0x000fc80000011445ULL,
0x0000003d00bd7306ULL, 0x000e620000205400ULL, 0x0000000195950812ULL, 0x000fce00078efcffULL,
0x0000006700db7306ULL, 0x000ff00000209400ULL, 0x0000006700d67306ULL, 0x000ea20000205400ULL,
0x000000bdb800720bULL, 0x002fce0003fbd000ULL, 0x0000003d008d7306ULL, 0x000e70000020d400ULL,
0x0000003e00bb7306ULL, 0x000fe20000209400ULL, 0x000000d6db00720bULL, 0x004fce0003f1d000ULL,
0x0000003e00b67306ULL, 0x000fe20000205400ULL, 0x000000018d8d5812ULL, 0x002fce00078efcffULL,
0x0000003e00847306ULL, 0x0003f0000020d400ULL, 0x0000004600b47306ULL, 0x000fe20000009400ULL,
0x000000003c3c783bULL, 0x002e6e0000004200ULL, 0x0000004600b97306ULL, 0x000eb00000005400ULL,
0x00000046008c7306ULL, 0x0007f0000000d400ULL, 0x0000006700ab7306ULL, 0x000462000020d400ULL,
0x0001000046467824ULL, 0x008fe200078e00ffULL, 0x000000b9b400720bULL, 0x004fc80003fbd000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004700ad7306ULL, 0x000fe20000009400ULL,
0x0000010047677824ULL, 0x000fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x0000004700a87306ULL, 0x000ea20000005400ULL, 0x00000001abab0812ULL, 0x002fe400078efcffULL,
0x000000018c8c5812ULL, 0x000fe400078efcffULL, 0x000000b6bb00720bULL, 0x000fe40003fbd000ULL,
0x00000018ffda7819ULL, 0x000fe2000001143cULL, 0x0000004700867306ULL, 0x0002e2000000d400ULL,
0x00000018ffdc7819ULL, 0x000fc4000001143dULL, 0x00000018ff727819ULL, 0x000fca000001143fULL,
0x0000006600d97306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x002fe200078e00ffULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x000000a8ad00720bULL, 0x004fe40003fbd000ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000006600d47306ULL, 0x000e700000205400ULL,
0x00000066008e7306ULL, 0x000462000020d400ULL, 0x0000000186865812ULL, 0x008fce00078efcffULL,
0x0000004600457306ULL, 0x000fe20000209400ULL, 0x00000018ff667819ULL, 0x004fe40000011440ULL,
0x000000d4d900720bULL, 0x002fca0003f1d000ULL, 0x0000004600447306ULL, 0x000ff00000205400ULL,
0x0000004600877306ULL, 0x0003e2000020d400ULL, 0x000000018e8e0812ULL, 0x000fce00078efcffULL,
0x0000006600d37306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x002fce0000011441ULL,
0x0000006600ce7306ULL, 0x000ff00000205400ULL, 0x0000006600837306ULL, 0x0003f0000020d400ULL,
0x0000004600d17306ULL, 0x000fe20000209400ULL, 0x0000010048667824ULL, 0x002fce00078e00ffULL,
0x0000004600cc7306ULL, 0x000ff00000205400ULL, 0x00000046007e7306ULL, 0x0003f0000020d400ULL,
0x00000049009e7306ULL, 0x000fe20000009400ULL, 0x0000010049467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004900a17306ULL, 0x000ff00000005400ULL,
0x0000004900537306ULL, 0x0003f0000000d400ULL, 0x0000004700d07306ULL, 0x000fe20000209400ULL,
0x0001000049497824ULL, 0x002fce00078e00ffULL, 0x0000004700d57306ULL, 0x000ff00000205400ULL,
0x0000004700887306ULL, 0x0003f0000020d400ULL, 0x0000006900d77306ULL, 0x000fe20000209400ULL,
0x00000018ff477819ULL, 0x002fce0000011443ULL, 0x0000006900d27306ULL, 0x000e700000205400ULL,
0x00000069008f7306ULL, 0x0004f0000020d400ULL, 0x0000004700c47306ULL, 0x000fe20000209400ULL,
0x00000018ff697819ULL, 0x004fc40000011466ULL, 0x000000d2d700720bULL, 0x002fca0003f1d000ULL,
0x0000004700c97306ULL, 0x000ff00000205400ULL, 0x00000047006a7306ULL, 0x0003e2000020d400ULL,
0x000000018f8f0812ULL, 0x008fe400078efcffULL, 0x000000444500720bULL, 0x000fc40003f1d000ULL,
0x0000008c8f8c723eULL, 0x000fc600000010ffULL, 0x0000006900c67306ULL, 0x000fe20000209400ULL,
0x00000018ff477819ULL, 0x002fe20000011449ULL, 0x000001004a497824ULL, 0x000fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011449ULL, 0x0000006900cb7306ULL, 0x000fe20000205400ULL,
0x0000000187870812ULL, 0x000fc800078efcffULL, 0x000000878484723eULL, 0x000fc600000010ffULL,
0x0000006900747306ULL, 0x000ff0000020d400ULL, 0x0000004700c77306ULL, 0x000ff00000209400ULL,
0x0000004700c07306ULL, 0x000ff00000205400ULL, 0x0000004700697306ULL, 0x0003f0000020d400ULL,
0x0000004800a27306ULL, 0x000fe20000009400ULL, 0x000100004b477824ULL, 0x002fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000004800a37306ULL, 0x000ff00000005400ULL,
0x0000004800657306ULL, 0x0003f0000000d400ULL, 0x0000004600c37306ULL, 0x000fe20000209400ULL,
0x0001000048487824ULL, 0x002fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004600be7306ULL, 0x000ff00000205400ULL, 0x0000004600667306ULL, 0x0003f0000020d400ULL,
0x0000006700ca7306ULL, 0x000fe20000209400ULL, 0x000100004a467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000006700cf7306ULL, 0x000e700000205400ULL,
0x0000006700897306ULL, 0x0004f0000020d400ULL, 0x0000004700997306ULL, 0x000fe20000209400ULL,
0x00000018ff677819ULL, 0x004fc40000011442ULL, 0x000000cfca00720bULL, 0x002fca0003f1d000ULL,
0x0000004700967306ULL, 0x000ff00000205400ULL, 0x00000047006d7306ULL, 0x0003e2000020d400ULL,
0x0000000189890812ULL, 0x008fe400078efcffULL, 0x000000d5d000720bULL, 0x000fca0003f1d000ULL,
0x0000006700cd7306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x002fce000001143eULL,
0x0000006700c87306ULL, 0x000fe20000205400ULL, 0x0000000188880812ULL, 0x000fce00078efcffULL,
0x0000006700777306ULL, 0x000ff0000020d400ULL, 0x0000004800c27306ULL, 0x000ff00000209400ULL,
0x0000004800c57306ULL, 0x000ff00000205400ULL, 0x0000004800677306ULL, 0x0003f0000020d400ULL,
0x0000004b009a7306ULL, 0x000fe20000009400ULL, 0x000001004b487824ULL, 0x002fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011448ULL, 0x0000004b009b7306ULL, 0x000ff00000005400ULL,
0x0000004b005d7306ULL, 0x000ff0000000d400ULL, 0x0000004600bc7306ULL, 0x000ff00000209400ULL,
0x0000004600bf7306ULL, 0x000ff00000205400ULL, 0x00000046004b7306ULL, 0x0003f0000020d400ULL,
0x00000047006f7306ULL, 0x000fe20000209400ULL, 0x0000010040467824ULL, 0x002fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004700707306ULL, 0x000ff00000205400ULL,
0x0000004700717306ULL, 0x0003f0000020d400ULL, 0x0000005400ae7306ULL, 0x000fe20000209400ULL,
0x0000010041477824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000005400b57306ULL, 0x000e700000205400ULL, 0x0000004600d67306ULL, 0x000ff00000209400ULL,
0x0000004600db7306ULL, 0x000ea20000205400ULL, 0x000000b5ae00720bULL, 0x002fe20003fbd000ULL,
0x0000010043ae7824ULL, 0x000fca00078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x0000004600977306ULL, 0x000e70000020d400ULL, 0x0000004700bd7306ULL, 0x000fe20000209400ULL,
0x000000dbd600720bULL, 0x004fce0003f1d000ULL, 0x0000004700d47306ULL, 0x000fec0000205400ULL,
0x0000000197970812ULL, 0x002fe400078efcffULL, 0x0000004700b87306ULL, 0x0003f0000020d400ULL,
0x0000005400857306ULL, 0x0004e2000020d400ULL, 0x011000003944783bULL, 0x002e6e0000000200ULL,
0x0000004000b77306ULL, 0x000fe20000009400ULL, 0x00000018ff547819ULL, 0x004fce000001144aULL,
0x0000004000b27306ULL, 0x000ea20000005400ULL, 0x0000000185855812ULL, 0x008fc800078efcffULL,
0x000000888585723eULL, 0x000fc600000010ffULL, 0x00000040007a7306ULL, 0x000662000000d400ULL,
0x000000b2b700720bULL, 0x004fe20003fbd000ULL, 0x0001000040407824ULL, 0x008fcc00078e00ffULL,
0x0000004100b37306ULL, 0x000fe20000009400ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x000000374444e231ULL, 0x002fcc00003400ffULL, 0x0000004000b97306ULL, 0x000fe20000209400ULL,
0x000000374646e231ULL, 0x000fe400003400ffULL, 0x000000384545e231ULL, 0x080fe200003400ffULL,
0x000000017a7a5812ULL, 0x000fe200078efcffULL, 0x000000384747e231ULL, 0x000fe200003400ffULL,
0x000000d4bd00720bULL, 0x000fe40003fdd000ULL, 0x0000004000d27306ULL, 0x000e620000205400ULL,
0x0000007a977a723eULL, 0x000fc600000010ffULL, 0x000000844414723cULL, 0x000fe80000041814ULL,
0x0000004000b47306ULL, 0x0004e6000020d400ULL, 0x00000001b8b86812ULL, 0x000fe400078efcffULL,
0x000000ced300720bULL, 0x000fc60003fdd000ULL, 0x0000004100b07306ULL, 0x000ee20000005400ULL,
0x000000d2b900720bULL, 0x002fe20003fbd000ULL, 0x0000010042407824ULL, 0x004fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x00000041007b7306ULL, 0x0002a4000000d400ULL,
0x0000000183836812ULL, 0x000fc800078efcffULL, 0x00000001b4b45812ULL, 0x008fe400078efcffULL,
0x0000004000ca7306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x002fe200078e00ffULL,
0x000000b0b300720bULL, 0x000fe40003f1d000ULL, 0x000000ccd100720bULL, 0x000fe40003fbd000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004000cf7306ULL, 0x000e6e0000205400ULL,
0x000000017b7b0812ULL, 0x004fe200078efcffULL, 0x0000004100b67306ULL, 0x000fe20000209400ULL,
0x000000017e7e5812ULL, 0x000fc400078efcffULL, 0x0000007bb87b723eULL, 0x000fca00000010ffULL,
0x0000004100bb7306ULL, 0x000ea20000205400ULL, 0x000000cfca00720bULL, 0x002fe20003fdd000ULL,
0x0000007a4410723cULL, 0x000fec0000041810ULL, 0x000000ae00d07306ULL, 0x000ff00000209400ULL,
0x000000ae00d57306ULL, 0x000e620000205400ULL, 0x000000bbb600720bULL, 0x004fce0003f1d000ULL,
0x0000004200ac7306ULL, 0x000ff00000009400ULL, 0x0000004200b17306ULL, 0x000fe20000005400ULL,
0x000000d5d000720bULL, 0x002fce0003fbd000ULL, 0x0000004200757306ULL, 0x0003f0000000d400ULL,
0x0000004100ad7306ULL, 0x000ea2000020d400ULL, 0x0001000042427824ULL, 0x002fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000004000a87306ULL, 0x000e70000020d400ULL,
0x000000ae00b57306ULL, 0x000ee2000020d400ULL, 0x00000001adad0812ULL, 0x004fc400078efcffULL,
0x000000b1ac00720bULL, 0x000fe40003f1d000ULL, 0x000000ad7ead723eULL, 0x000fc600000010ffULL,
0x0000004300af7306ULL, 0x000fe20000009400ULL, 0x00000001a8a86812ULL, 0x002fce00078efcffULL,
0x0000004300aa7306ULL, 0x000e620000005400ULL, 0x00000001b5b55812ULL, 0x008fe400078efcffULL,
0x0000000175750812ULL, 0x000fe400078efcffULL, 0x000000c8cd00720bULL, 0x000fe40003f1d000ULL,
0x00000075a8a8723eULL, 0x000fe200000010ffULL, 0x0000004200407306ULL, 0x000ff00000209400ULL,
0x0000004200417306ULL, 0x000ea20000205400ULL, 0x000000aaaf00720bULL, 0x002fc40003fdd000ULL,
0x0000000177770812ULL, 0x000fe400078efcffULL, 0x000000cbc600720bULL, 0x000fc60003f1d000ULL,
0x0000004300687306ULL, 0x0002f0000000d400ULL, 0x0000004200ae7306ULL, 0x0006e2000020d400ULL,
0x0001000043437824ULL, 0x002fe200078e00ffULL, 0x000000414000720bULL, 0x004fe20003fbd000ULL,
0x000001003d407824ULL, 0x000fe200078e00ffULL, 0x0000000174740812ULL, 0x000fc400078efcffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000000168686812ULL, 0x008fe200078efcffULL,
0x000001003c427824ULL, 0x000fe200078e00ffULL, 0x0000004300b07306ULL, 0x000fe80000209400ULL,
0x00000018ffac7819ULL, 0x000fe40000011442ULL, 0x00000001aeae5812ULL, 0x000fc400078efcffULL,
0x0000004300b37306ULL, 0x000e620000205400ULL, 0x000000c9c400720bULL, 0x000fe40003fbd000ULL,
0x000000ae77ae723eULL, 0x000fca00000010ffULL, 0x0000004300b17306ULL, 0x0004ec000020d400ULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x000000b3b000720bULL, 0x002fe20003fdd000ULL,
0x0000005500a77306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fc40000011440ULL,
0x000000c5c200720bULL, 0x000fe20003fbd000ULL, 0x011000003a40783bULL, 0x004e680000000200ULL,
0x0000005500a67306ULL, 0x000ea80000205400ULL, 0x00000001b1b16812ULL, 0x008fe400078efcffULL,
0x000000a3a200720bULL, 0x000fc40003fdd000ULL, 0x0000005500647306ULL, 0x000ee2000020d400ULL,
0x0000000167675812ULL, 0x000fe400078efcffULL, 0x000000a19e00720bULL, 0x000fca0003fbd000ULL,
0x0000005700a57306ULL, 0x000fe20000209400ULL, 0x000000a6a700720bULL, 0x004fe40003f1d000ULL,
0x0000000165656812ULL, 0x000fe400078efcffULL, 0x000000bec300720bULL, 0x000fe40003fdd000ULL,
0x000000657474723eULL, 0x000fe200000010ffULL, 0x0000005700a47306ULL, 0x000ea20000205400ULL,
0x0000000153535812ULL, 0x000fca00078efcffULL, 0x0000000164640812ULL, 0x008fe400078efcffULL,
0x0000005700587306ULL, 0x000ee2000020d400ULL, 0x000000ff9300720cULL, 0x000fe40003f05270ULL,
0x0000000166666812ULL, 0x000fe400078efcffULL, 0x000000c0c700720bULL, 0x000fe40003fdd000ULL,
0x000000536675723eULL, 0x000fe200000010ffULL, 0x0000004a009c7306ULL, 0x000fe20000009400ULL,
0x000000a4a500720bULL, 0x004fc40003fbd000ULL, 0x000000676464723eULL, 0x000fc600000010ffULL,
0x0000003740408231ULL, 0x082fe400003400ffULL, 0x0000004a009f7306ULL, 0x000e620000005400ULL,
0x0000003742428231ULL, 0x000fe200003400ffULL, 0x0000000169696812ULL, 0x000fe200078efcffULL,
0x0000003841418231ULL, 0x080fe400003400ffULL, 0x0000003843438231ULL, 0x000fe200003400ffULL,
0x0000000158585812ULL, 0x008fe400078efcffULL, 0x0000006c00ba7306ULL, 0x000fe40000209400ULL,
0x000000695865723eULL, 0x000fcc00000010ffULL, 0x0000006c00497306ULL, 0x000ea20000205400ULL,
0x0000009f9c00720bULL, 0x002fce0003fdd000ULL, 0x0000007800c17306ULL, 0x000ff00000209400ULL,
0x0000007800487306ULL, 0x000e620000205400ULL, 0x00000049ba00720bULL, 0x004fe40003f1d000ULL,
0x0000008e8d49723eULL, 0x000fc400000010ffULL, 0x00000086898d723eULL, 0x000fc600000010ffULL,
0x0000004a005e7306ULL, 0x000ea8000000d400ULL, 0x0000008c4418723cULL, 0x000fe80000041818ULL,
0x0000006c006b7306ULL, 0x000ee2000020d400ULL, 0x00000048c100720bULL, 0x002fe40003fbd000ULL,
0x000000959248723eULL, 0x000fca00000010ffULL, 0x00000078004a7306ULL, 0x000e62000020d400ULL,
0x000000015e5e6812ULL, 0x004fe200078efcffULL, 0x00000048441c723cULL, 0x000f62000004181cULL,
0x000000bfbc00720bULL, 0x000fca0003fdd000ULL, 0x0000005400917306ULL, 0x000fe20000209400ULL,
0x000000016b6b0812ULL, 0x008fe400078efcffULL, 0x0000009b9a00720bULL, 0x000fca0003f1d000ULL,
0x0000005400907306ULL, 0x000ea20000205400ULL, 0x000000014a4a5812ULL, 0x002fe400078efcffULL,
0x000000014b4b6812ULL, 0x000fe400078efcffULL, 0x000000969900720bULL, 0x000fc60003fdd000ULL,
0x0000005400627306ULL, 0x000e62000020d400ULL, 0x000000015d5d0812ULL, 0x000fe200078efcffULL,
0x00000064401c723cULL, 0x020fec000004181cULL, 0x00000059008a7306ULL, 0x000fe20000209400ULL,
0x000000909100720bULL, 0x004fe40003fbd000ULL, 0x000000016d6d6812ULL, 0x000fca00078efcffULL,
0x00000059008b7306ULL, 0x000eac0000205400ULL, 0x0000000162625812ULL, 0x002fe400078efcffULL,
0x000000ac00aa7306ULL, 0x000fe40000209400ULL, 0x0000004b6262723eULL, 0x000fcc00000010ffULL,
0x000000ac00af7306ULL, 0x000e620000205400ULL, 0x0000008b8a00720bULL, 0x004fce0003f1d000ULL,
0x00000059005a7306ULL, 0x000eb0000020d400ULL, 0x000000ac009d7306ULL, 0x0006e2000020d400ULL,
0x000000afaa00720bULL, 0x002fe40003fbd000ULL, 0x000000b16aaf723eULL, 0x000fca00000010ffULL,
0x0000003c00817306ULL, 0x000fe20000009400ULL, 0x000000015a5a0812ULL, 0x004fe200078efcffULL,
0x000000ae4404723cULL, 0x000fe20000041804ULL, 0x000000b483ac723eULL, 0x008fca00000010ffULL,
0x0000003c00827306ULL, 0x000e620000005400ULL, 0x000000019d9d5812ULL, 0x000fe200078efcffULL,
0x000000ac440c723cULL, 0x000fec000004180cULL, 0x0000003d007c7306ULL, 0x000ff00000009400ULL,
0x0000003d007d7306ULL, 0x000ea20000005400ULL, 0x000000828100720bULL, 0x002fce0003fdd000ULL,
0x000000b000b27306ULL, 0x000ff00000209400ULL, 0x000000b000a37306ULL, 0x000e620000205400ULL,
0x0000007d7c00720bULL, 0x004fce0003f1d000ULL, 0x0000003c00607306ULL, 0x0004f0000000d400ULL,
0x0000003d00597306ULL, 0x0006e2000000d400ULL, 0x000100003c3c7824ULL, 0x004fe200078e00ffULL,
0x000000a3b200720bULL, 0x002fc80003fbd000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000000b000a07306ULL, 0x000e62000020d400ULL, 0x000100003d3d7824ULL, 0x008fe200078e00ffULL,
0x0000000160606812ULL, 0x000fc800078efcffULL, 0x00000018ff9e7819ULL, 0x000fe4000001143dULL,
0x0000003c00a27306ULL, 0x000fe20000209400ULL, 0x00000094ab3d723eULL, 0x000fe400000010ffULL,
0x0000000159590812ULL, 0x000fe400078efcffULL, 0x000000609d58723eULL, 0x000fc600000010ffULL,
0x0000003c00a17306ULL, 0x000ea20000205400ULL, 0x00000001a0a05812ULL, 0x002fc800078efcffULL,
0x00000059a059723eULL, 0x000fc600000010ffULL, 0x0000003c00937306ULL, 0x0002e8000020d400ULL,
0x000000584010723cULL, 0x000fe80000041810ULL, 0x000000da007f7306ULL, 0x000fe20000209400ULL,
0x000001003e3c7824ULL, 0x002fe200078e00ffULL, 0x000000a1a200720bULL, 0x004fc80003fdd000ULL,
0x00000018ff9a7819ULL, 0x000fe4000001143cULL, 0x000000da00807306ULL, 0x000e620000205400ULL,
0x00000098a93c723eULL, 0x000fe400000010ffULL, 0x00000068b5a9723eULL, 0x000fc800000010ffULL,
0x0000000193936812ULL, 0x008fe200078efcffULL, 0x0000009e00a47306ULL, 0x000fe20000209400ULL,
0x0000003c4420723cULL, 0x040b6e0000041820ULL, 0x0000009e00a57306ULL, 0x000ea20000205400ULL,
0x000000807f00720bULL, 0x002fe20003fbd000ULL, 0x000001003f3c7824ULL, 0x020fe200078e00ffULL,
0x000000a84408723cULL, 0x000b680000041808ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000000da006c7306ULL, 0x000e70000020d400ULL, 0x0000009e009f7306ULL, 0x000ee2000020d400ULL,
0x000000a5a400720bULL, 0x004fe20003f1d000ULL, 0x000000744020723cULL, 0x000f6c0000041820ULL,
0x0000003e00547306ULL, 0x000fe20000009400ULL, 0x000000016c6c5812ULL, 0x002fc800078efcffULL,
0x000000936c6c723eULL, 0x000fc600000010ffULL, 0x0000003e00637306ULL, 0x000e620000005400ULL,
0x000000019f9f0812ULL, 0x008fce00078efcffULL, 0x000000dc00787306ULL, 0x000ff00000209400ULL,
0x000000dc00797306ULL, 0x000ea20000205400ULL, 0x000000635400720bULL, 0x002fe40003fbd000ULL,
0x0000006d5a63723eULL, 0x000fca00000010ffULL, 0x0000009a00947306ULL, 0x000fe40000209400ULL,
0x000000624014723cULL, 0x000f6c0000041814ULL, 0x0000009a003d7306ULL, 0x000e620000205400ULL,
0x000000797800720bULL, 0x004fce0003fdd000ULL, 0x0000003e00577306ULL, 0x0004f0000000d400ULL,
0x000000dc006e7306ULL, 0x000ee2000020d400ULL, 0x000100003e3e7824ULL, 0x004fe200078e00ffULL,
0x0000003d9400720bULL, 0x002fc40003f1d000ULL, 0x0000005d4a3d723eULL, 0x000fe400000010ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000009a00487306ULL, 0x000e62000020d400ULL,
0x0000000157575812ULL, 0x008fce00078efcffULL, 0x0000003f005c7306ULL, 0x000fe20000009400ULL,
0x000000016e6e6812ULL, 0x000fc800078efcffULL, 0x0000009f6e6d723eULL, 0x000fc600000010ffULL,
0x0000003f00617306ULL, 0x000ea20000005400ULL, 0x0000000148480812ULL, 0x002fc600078efcffULL,
0x0000006c400c723cULL, 0x000f62000004180cULL, 0x000000574848723eULL, 0x000fc600000010ffULL,
0x0000003c00867306ULL, 0x000ff00000209400ULL, 0x0000003c007d7306ULL, 0x000e620000205400ULL,
0x000000615c00720bULL, 0x004fce0003f1d000ULL, 0x0000003e00497306ULL, 0x000ff00000209400ULL,
0x0000003e00687306ULL, 0x000ea20000205400ULL, 0x0000007d8600720bULL, 0x002fce0003fdd000ULL,
0x0000003f00557306ULL, 0x0002f0000000d400ULL, 0x0000003c007a7306ULL, 0x0006e2000020d400ULL,
0x000100003f3f7824ULL, 0x002fe200078e00ffULL, 0x000000684900720bULL, 0x004fc80003fbd000ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003e00447306ULL, 0x020e62000020d400ULL,
0x0000000155550812ULL, 0x008fe400078efcffULL, 0x0000005e6b3c723eULL, 0x000fca00000010ffULL,
0x0000007200737306ULL, 0x000fe20000209400ULL, 0x000000017a7a6812ULL, 0x000fe200078efcffULL,
0x0000003c4018723cULL, 0x000b620000041818ULL, 0x000000706f00720bULL, 0x000fe40003fdd000ULL,
0x000000557a49723eULL, 0x000fc600000010ffULL, 0x0000007200767306ULL, 0x000ea20000205400ULL,
0x0000000144445812ULL, 0x002fe200078efcffULL, 0x00000008343c7824ULL, 0x020fe400078e00ffULL,
0x000000484008723cULL, 0x000b680000041808ULL, 0x0000003f00457306ULL, 0x000fe20000209400ULL,
0x0000000171716812ULL, 0x000fc800078efcffULL, 0x000000447144723eULL, 0x000fc600000010ffULL,
0x0000003f003e7306ULL, 0x000e620000205400ULL, 0x000000767300720bULL, 0x004fce0003f1d000ULL,
0x0000007200727306ULL, 0x000eb0000020d400ULL, 0x0000003f003f7306ULL, 0x000ee2000020d400ULL,
0x0000003e4500720bULL, 0x002fe40003fbd000ULL, 0x0000000172720812ULL, 0x004fd600078efcffULL,
0x000000013f3f5812ULL, 0x008fc800078efcffULL, 0x0000003f7245723eULL, 0x000fce00000010ffULL,
0x000000444004723cULL, 0x000b620000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0176c8003c3c7f8cULL, 0x000e62000c80043fULL, 0xfffffff85f537812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000402d3c7811ULL, 0x002fe200078e40ffULL,
0x0176880053ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff407224ULL, 0x020fe200078e003dULL,
0x000000015b5b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5f7224ULL, 0x000fe200078e0056ULL,
0x000000033c00720cULL, 0x000fe20003f06070ULL, 0x000000ffff5d7224ULL, 0x000fe400078e004dULL,
0x000000ffff3d7224ULL, 0x000fd400078e0029ULL, 0x0000a4a000000947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x002fc40000015200ULL, 0x000004002a3f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x002fe40007804840ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000413e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000142427810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004002a3f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe40007804840ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010253e7824ULL, 0x000fe200078e00ffULL,
0x000000012d3d7810ULL, 0x000fe20007ffe0ffULL, 0x0000580030307a24ULL, 0x010fc600078e02ffULL,
0x000000003d00720cULL, 0x000fe20003f06070ULL, 0x0000004030477824ULL, 0x000fe200078e00ffULL,
0xffffffe03e3c7812ULL, 0x000fca00078ec0ffULL, 0x000001002d3c7824ULL, 0x000fca00078e023cULL,
0x000000803c3c7810ULL, 0x000fc80007ffe0ffULL, 0x0000002031457812ULL, 0x000fe200078ef83cULL,
0x000004b000008947ULL, 0x000fea0003800000ULL, 0x000000103e437812ULL, 0x000fe200078ec0ffULL,
0x00000010333d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff447819ULL, 0x000fc80000011633ULL,
0x0000000444467810ULL, 0x040fe20007ffe0ffULL, 0x0000000144427824ULL, 0x040fe200078e0243ULL,
0x000000703d577812ULL, 0x000fe400078ec0ffULL, 0x00000008444a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000142307824ULL, 0x000fe400078e0245ULL, 0x0000000146487824ULL, 0x000fe400078e0243ULL,
0x00000001423f7824ULL, 0x000fe200078e0233ULL, 0x0000003047417210ULL, 0x000fe20007f1e0ffULL,
0x000000014a547824ULL, 0x000fe200078e0243ULL, 0x0000003c03307217ULL, 0x000fc60007800000ULL,
0x000000ffff407224ULL, 0x000fe200000e06ffULL, 0x00005e00413e7a11ULL, 0x000fe200078038ffULL,
0x00000001303c7824ULL, 0x000fe400078e0a3cULL, 0x000010002b307824ULL, 0x000fe200078e00ffULL,
0x00005f0041417a11ULL, 0x000fe200000f3c40ULL, 0x0000000842407824ULL, 0x000fe200078e00ffULL,
0x0000003c433c7217ULL, 0x000fe40007800000ULL, 0x00001000303d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff840497812ULL, 0x000fe200078ee23fULL, 0x000000013c307824ULL, 0x000fc400078e0a43ULL,
0x00000001483c7824ULL, 0x000fe400078e0245ULL, 0x00002000343d7824ULL, 0x000fe200078e023dULL,
0x000000304400720cULL, 0x000fe40003f06070ULL, 0x0000003c47427210ULL, 0x000fe40007fde0ffULL,
0x000000573e3c7210ULL, 0x000fe40007fbe0ffULL, 0x000130003d407810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e06ffULL, 0x00005e00423e7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff3d7224ULL, 0x000fe200028e0641ULL, 0x000000304600720cULL, 0x000fe20003fa6070ULL,
0x0000001049417824ULL, 0x000fe200078e0240ULL, 0x00005f0042427a11ULL, 0x000fe200030f3c3fULL,
0x0000000148467824ULL, 0x000fc400078e0233ULL, 0x0000000848497824ULL, 0x000fe200078e00ffULL,
0x0000000c44487810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c417faeULL, 0x0003e2000c101c46ULL, 0x00000001543f7824ULL, 0x000fe200078e0245ULL,
0x000000573e3e7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff849497812ULL, 0x000fe200078ee246ULL,
0x0000000148467824ULL, 0x000fe200078e0243ULL, 0x0000003f47447210ULL, 0x000fe20007fde0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e0642ULL, 0x000000304a00720cULL, 0x000fc60003f06070ULL,
0x000000ffff437224ULL, 0x000fe400030e06ffULL, 0x0000001049417824ULL, 0x002fe400078e0240ULL,
0x00000001463c7824ULL, 0x000fe400078e0245ULL, 0x0000000854457824ULL, 0x000fe200078e00ffULL,
0x000000003e417faeULL, 0x0003e2000e901c46ULL, 0x00005e00443d7a11ULL, 0x000fe400078a38ffULL,
0x0000003c47427210ULL, 0x000fc40007fde0ffULL, 0x00005f0044447a11ULL, 0x000fe400028f3c43ULL,
0x000000304800720cULL, 0x000fe20003fa6070ULL, 0x000000ffff437224ULL, 0x000fe200030e06ffULL,
0x000000573d3c7210ULL, 0x000fe20007fde0ffULL, 0x0000000154307824ULL, 0x100fe400078e0233ULL,
0x00000001463f7824ULL, 0x002fe400078e0233ULL, 0x000000ffff3d7224ULL, 0x000fe200030e0644ULL,
0x00005e00423e7a11ULL, 0x000fe200078c38ffULL, 0x0000000846467824ULL, 0x000fe200078e00ffULL,
0xfffffff845417812ULL, 0x000fc400078ee230ULL, 0x00005f0042307a11ULL, 0x000fe400030f3c43ULL,
0x000000573e3e7210ULL, 0x000fe20007fde0ffULL, 0x0000001041417824ULL, 0x000fe200078e0240ULL,
0xfffffff846437812ULL, 0x000fc600078ee23fULL, 0x000000ffff3f7224ULL, 0x000fe200030e0630ULL,
0x000000003c417faeULL, 0x0003e2000c101c46ULL, 0x0000001043437824ULL, 0x000fca00078e0240ULL,
0x000000003e437faeULL, 0x0003e2000e901c46ULL, 0x000003e000007947ULL, 0x000fea0003800000ULL,
0x000000103e3e7812ULL, 0x000fe200078ec0ffULL, 0x0000001033577824ULL, 0x000fc600078e00ffULL,
0x0000003e333e7211ULL, 0x000fe400078fe8ffULL, 0x0000007057577812ULL, 0x000fe400078ec0ffULL,
0x000000043e407810ULL, 0x040fe20007ffe0ffULL, 0x000000013e307824ULL, 0x040fe200078e0245ULL,
0x000000083e427810ULL, 0x040fe20007ffe0ffULL, 0x000000013e3c7824ULL, 0x140fe400078e0233ULL,
0x000000083e3f7824ULL, 0x000fe200078e00ffULL, 0x0000003047447210ULL, 0x000fe20007f1e0ffULL,
0x00000001403d7824ULL, 0x000fe200078e0233ULL, 0x0000000c3e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000840487824ULL, 0x040fe200078e00ffULL, 0xfffffff83f467812ULL, 0x000fe200078ee23cULL,
0x0000000140307824ULL, 0x000fc400078e0245ULL, 0x000000ffff3f7224ULL, 0x000fe200000e06ffULL,
0xfffffff848487812ULL, 0x000fe200078ee23dULL, 0x0000000142417824ULL, 0x000fe200078e0233ULL,
0x00005e0044437a11ULL, 0x000fe200078038ffULL, 0x00000008424a7824ULL, 0x000fe200078e00ffULL,
0x0000003047307210ULL, 0x000fe20007fde0ffULL, 0x000010002b407824ULL, 0x000fe200078e00ffULL,
0x00005f0044447a11ULL, 0x000fe200000f3c3fULL, 0x00000001423c7824ULL, 0x000fe200078e0245ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee241ULL, 0x000000013e3d7824ULL, 0x000fe200078e0245ULL,
0x0000100040417812ULL, 0x000fe200078ec0ffULL, 0x000000013e427824ULL, 0x040fe200078e0233ULL,
0x0000003c473c7210ULL, 0x040fe20007fbe0ffULL, 0x000000083e457824ULL, 0x000fe200078e00ffULL,
0x0000003d473d7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e06ffULL,
0x00005e00303e7a11ULL, 0x000fc400078c38ffULL, 0xfffffff845547812ULL, 0x000fe200078ee242ULL,
0x0000200034457824ULL, 0x000fe200078e0241ULL, 0x00005f00303f7a11ULL, 0x000fe200030f3c3fULL,
0x000000ffff417224ULL, 0x000fe200028e06ffULL, 0x00005e003d427a11ULL, 0x000fe200078a38ffULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x00005e003c407a11ULL, 0x040fe400078038ffULL,
0x00013000454b7810ULL, 0x000fe40007ffe0ffULL, 0x00005f003c417a11ULL, 0x000fc400000f3c41ULL,
0x00005f003d307a11ULL, 0x000fe200028f3c30ULL, 0x0000001046457824ULL, 0x100fe200078e024bULL,
0x00000057433c7210ULL, 0x080fe20007f1e0ffULL, 0x0000001048477824ULL, 0x100fe200078e024bULL,
0x000000573e3e7210ULL, 0x080fe20007fbe0ffULL, 0x000000104a497824ULL, 0x000fe400078e024bULL,
0x000000ffff3d7224ULL, 0x000fe200000e0644ULL, 0x0000005740407210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e063fULL, 0x0000005742427210ULL, 0x000fe20007fbe0ffULL,
0x00000010544b7824ULL, 0x000fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e2000b901c46ULL, 0x000000ffff417224ULL, 0x000fc400000e0641ULL,
0x000000ffff437224ULL, 0x000fe200028e0630ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x0000000040497faeULL, 0x0003e8000b901c46ULL, 0x00000000424b7faeULL, 0x0003e4000b901c46ULL,
0x00000008253f7824ULL, 0x002fe200078e00ffULL, 0x000000022c3d7810ULL, 0x000fe20007ffe0ffULL,
0x000000082b3e7824ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe200078e00ffULL,
0xfffffff03f3f7812ULL, 0x000fe400078ec0ffULL, 0x000000083e3e7812ULL, 0x000fe400078ec0ffULL,
0x000000023d00720cULL, 0x000fc60003f06070ULL, 0x000000013f547824ULL, 0x000fca00078e023eULL,
0x0000000000007918ULL, 0x000fea0000000000ULL, 0x000000022f3c8810ULL, 0x000fe20007ffe02cULL,
0x00000004ff3d8424ULL, 0x000fc800078e00ffULL, 0x000060003c3c8625ULL, 0x000fe200078e003dULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000176a854557810ULL, 0x000fc60007ffe0ffULL,
0x000000063c308981ULL, 0x000322000c1e1900ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000550403c2ULL, 0x000ea40000040000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000170f070ULL, 0xffffff8000002947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a800545c7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176280026407f8cULL, 0x0002a4000c80043fULL,
0x00000000003c7805ULL, 0x002fc40000015200ULL, 0x01762c00263f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x006fe40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000433e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000142427810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01762c00263f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000080573d7810ULL, 0x000fca0007ffe027ULL,
0x00000001243d7824ULL, 0x000fca00078e023dULL, 0x017000003d417984ULL, 0x000e680000000800ULL,
0x017200003d3c7984ULL, 0x0004e20000000800ULL, 0x000000564100720bULL, 0x002fe20003f1d000ULL,
0x000123527f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x004fc800000e0100ULL,
0x0000ffff3dff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff407424ULL, 0x000fe400078e00ffULL, 0x000000ffff5f7224ULL, 0x000fd200078e0056ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x00000001363e7810ULL, 0x000fe40007ffe0ffULL,
0x000000564100720bULL, 0x000fe40003f14000ULL, 0x000000253e00720cULL, 0x000fe20003fa5270ULL,
0x000123127f007947ULL, 0x000fd4000b800000ULL, 0x0000000000407806ULL, 0x000fc400000e0100ULL,
0x000000802557d824ULL, 0x000fe200078e0257ULL, 0x00000056413f7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910403e7816ULL, 0x000fe200000000ffULL,
0x000000012442d824ULL, 0x000fc600078e0257ULL, 0x000000ff3e00720cULL, 0x000fe40003f05270ULL,
0x0174003f4200d388ULL, 0x0003f60000000800ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000003f563e7221ULL, 0x002fe20000010000ULL, 0x000000ff40ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b3e3e7820ULL, 0x000fc80000410000ULL,
0x0000003e00477308ULL, 0x000e640000000800ULL, 0x000000472e2e7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff447819ULL, 0x000fe20000011633ULL,
0x000122527f007947ULL, 0x000fea000b800000ULL, 0x00001f44473e7589ULL, 0x0002a400000e0000ULL,
0x0000003e20207220ULL, 0x084fe40000410000ULL, 0x0000003e21217220ULL, 0x080fe40000410000ULL,
0x0000003e1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003e1d1d7220ULL, 0x080fe40000410000ULL,
0x0000003e18187220ULL, 0x080fe40000410000ULL, 0x0000003e19197220ULL, 0x000fc40000410000ULL,
0x0000003e14147220ULL, 0x080fe40000410000ULL, 0x0000003e15157220ULL, 0x080fe40000410000ULL,
0x0000003e10107220ULL, 0x080fe40000410000ULL, 0x0000003e11117220ULL, 0x080fe40000410000ULL,
0x0000003e0c0c7220ULL, 0x080fe40000410000ULL, 0x0000003e0d0d7220ULL, 0x000fc40000410000ULL,
0x0000003e08087220ULL, 0x080fe40000410000ULL, 0x0000003e09097220ULL, 0x080fe40000410000ULL,
0x0000003e04047220ULL, 0x080fe40000410000ULL, 0x0000003e05057220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0040ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000833447811ULL, 0x002fe200078ff0ffULL,
0x000121627f007947ULL, 0x000fea000b800000ULL, 0x00001f44473e7589ULL, 0x0002a400000e0000ULL,
0x0000003e22227220ULL, 0x084fe40000410000ULL, 0x0000003e23237220ULL, 0x080fe40000410000ULL,
0x0000003e1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003e1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003e1a1a7220ULL, 0x080fe40000410000ULL, 0x0000003e1b1b7220ULL, 0x000fc40000410000ULL,
0x0000003e16167220ULL, 0x080fe40000410000ULL, 0x0000003e17177220ULL, 0x080fe40000410000ULL,
0x0000003e12127220ULL, 0x080fe40000410000ULL, 0x0000003e13137220ULL, 0x080fe40000410000ULL,
0x0000003e0e0e7220ULL, 0x080fe40000410000ULL, 0x0000003e0f0f7220ULL, 0x000fc40000410000ULL,
0x0000003e0a0a7220ULL, 0x080fe40000410000ULL, 0x0000003e0b0b7220ULL, 0x080fe40000410000ULL,
0x0000003e06067220ULL, 0x080fe40000410000ULL, 0x0000003e07077220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff40ff7812ULL, 0x000fe2000780083dULL,
0x00000001ff407424ULL, 0x000fe200078e00ffULL, 0x00000056415f7209ULL, 0x000fd60007810000ULL,
0x8000005f41410221ULL, 0x000fe20000010000ULL, 0x00007610ff400816ULL, 0x000fc60000000040ULL,
0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL, 0x0000004100350308ULL, 0x000e640000000800ULL,
0x000000353c3c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002e3c2e7221ULL, 0x008fc40000010000ULL, 0x00000000003c7805ULL, 0x000fca0000015200ULL,
0x0176ac00283f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000413e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac00283f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x002fe4000780484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910403c7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff3c00720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000035ff37723eULL, 0x000fe400000010ffULL, 0x00000002ff3d7819ULL, 0x000fe40000011633ULL,
0x00005410373c7816ULL, 0x000fe20000000037ULL, 0x00011d627f007947ULL, 0x000fea000b800000ULL,
0x00001f3d3c377589ULL, 0x0002a400000e0000ULL, 0x000000083d447810ULL, 0x002fe20007ffe0ffULL,
0x00011db27f007947ULL, 0x000fea000b800000ULL, 0x00001f443c387589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000103d447810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200078e003cULL, 0x00006590003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0001285000007944ULL, 0x01cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000183d447810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x004fe200078e003cULL,
0x00006600003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000127e000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001503c7824ULL, 0x042fe200078e0251ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008504d7824ULL, 0x000fe400078e00ffULL,
0x0000000234587824ULL, 0x000fc600078e0229ULL, 0xfffffff84d4d7812ULL, 0x000fe400078ee23cULL,
0x0001300058587811ULL, 0x000fca00078e60ffULL, 0x000000104d4d7824ULL, 0x100fe400078e0258ULL,
0x000000104f567824ULL, 0x100fe400078e0258ULL, 0x000000104e577824ULL, 0x100fe200078e0258ULL,
0x000000004d44783bULL, 0x000e620000004200ULL, 0x000000103b4c7824ULL, 0x000fc600078e0258ULL,
0x000000005640783bULL, 0x004ea80000004200ULL, 0x000000005748783bULL, 0x000fe80000004200ULL,
0x000000004c3c783bULL, 0x000ee20000004200ULL, 0x0000010044967824ULL, 0x002fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011446ULL, 0x00000044009f7306ULL, 0x000fe20000009400ULL,
0x00000018ff5c7819ULL, 0x000fe20000011445ULL, 0x0000010047a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x0000010040d27824ULL, 0x004fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc40000011444ULL, 0x00000018ff627819ULL, 0x000fe20000011447ULL,
0x0000004400a27306ULL, 0x000e620000005400ULL, 0x00000018ffcd7819ULL, 0x000fe400000114a0ULL,
0x00000018ff997819ULL, 0x008fe4000001143dULL, 0x00000018ff9b7819ULL, 0x000fe4000001143eULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x0000006100be7306ULL, 0x000fe20000209400ULL,
0x00000018ff637819ULL, 0x000fc40000011443ULL, 0x00000018ff6a7819ULL, 0x000fe4000001143cULL,
0x00000018ff6c7819ULL, 0x000fc6000001143fULL, 0x0000006100bb7306ULL, 0x000fe20000205400ULL,
0x000000a29f00720bULL, 0x002fce0003fbd000ULL, 0x0000006100847306ULL, 0x0003f0000020d400ULL,
0x0000009600c17306ULL, 0x000fe20000209400ULL, 0x00000018ff617819ULL, 0x002fce0000011442ULL,
0x0000009600c27306ULL, 0x000e700000205400ULL, 0x00000044008c7306ULL, 0x0004f0000000d400ULL,
0x0000006100ae7306ULL, 0x000fe20000209400ULL, 0x0001000044447824ULL, 0x004fe200078e00ffULL,
0x000000c2c100720bULL, 0x002fc80003fdd000ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000006100ad7306ULL, 0x000fe20000205400ULL, 0x000000018c8c5812ULL, 0x008fce00078efcffULL,
0x0000006100787306ULL, 0x0003f0000020d400ULL, 0x0000005c00ac7306ULL, 0x000fe20000209400ULL,
0x00000018ff617819ULL, 0x002fce000001144aULL, 0x0000005c00bf7306ULL, 0x000ff00000205400ULL,
0x0000005c00897306ULL, 0x0003f0000020d400ULL, 0x0000006100917306ULL, 0x000fe20000209400ULL,
0x00000018ff5c7819ULL, 0x002fce0000011441ULL, 0x0000005c00b67306ULL, 0x000ff00000209400ULL,
0x0000005c00b37306ULL, 0x000ff00000205400ULL, 0x0000005c007b7306ULL, 0x0003f0000020d400ULL,
0x0000006100907306ULL, 0x000fe20000205400ULL, 0x00000018ff5c7819ULL, 0x002fce0000011449ULL,
0x00000061006e7306ULL, 0x000ff0000020d400ULL, 0x0000009900737306ULL, 0x000ff00000209400ULL,
0x0000009900727306ULL, 0x000ff00000205400ULL, 0x0000009900617306ULL, 0x000ff0000020d400ULL,
0x0000009600997306ULL, 0x0002b0000020d400ULL, 0x0000005900c57306ULL, 0x000fe20000209400ULL,
0x0000010046967824ULL, 0x002fca00078e00ffULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x0000005900c67306ULL, 0x000e620000205400ULL, 0x0000000199996812ULL, 0x004fce00078efcffULL,
0x0000004400c37306ULL, 0x000ff00000209400ULL, 0x0000004400c47306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fce0003fbd000ULL, 0x0000006200bc7306ULL, 0x000ff00000209400ULL,
0x0000006200b97306ULL, 0x000fe20000205400ULL, 0x000000c4c300720bULL, 0x004fce0003fdd000ULL,
0x0000006200837306ULL, 0x000ff0000020d400ULL, 0x0000005c00987306ULL, 0x000ff00000209400ULL,
0x0000005c00957306ULL, 0x000ff00000205400ULL, 0x0000005c00627306ULL, 0x000ff0000020d400ULL,
0x0000009b00657306ULL, 0x000ff00000209400ULL, 0x0000009b005c7306ULL, 0x000ff00000205400ULL,
0x0000009b00697306ULL, 0x0003f0000020d400ULL, 0x00000059008b7306ULL, 0x0004e2000020d400ULL,
0x00000100459b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe4000001149bULL,
0x00000044009e7306ULL, 0x000e62000020d400ULL, 0x00000018ff597819ULL, 0x004fce0000011440ULL,
0x0000004500af7306ULL, 0x000fe20000009400ULL, 0x000000018b8b5812ULL, 0x008fce00078efcffULL,
0x0000004500c07306ULL, 0x000ea20000005400ULL, 0x000000019e9e6812ULL, 0x002fce00078efcffULL,
0x0000009b00c77306ULL, 0x000ff00000209400ULL, 0x0000009b00c87306ULL, 0x000e620000205400ULL,
0x000000c0af00720bULL, 0x004fce0003fbd000ULL, 0x00000045008a7306ULL, 0x0004f0000000d400ULL,
0x0000009b00a17306ULL, 0x000ee2000020d400ULL, 0x0001000045457824ULL, 0x004fe200078e00ffULL,
0x000000c8c700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004600bd7306ULL, 0x000fe20000009400ULL, 0x000000018a8a5812ULL, 0x008fe400078efcffULL,
0x000000bfac00720bULL, 0x000fe20003fbd000ULL, 0x0000010042bf7824ULL, 0x000fc800078e00ffULL,
0x0000004500c97306ULL, 0x000fe20000209400ULL, 0x00000001a1a16812ULL, 0x000fe400078efcffULL,
0x00000018ffbf7819ULL, 0x000fca00000114bfULL, 0x0000004500ca7306ULL, 0x000e620000205400ULL,
0x0000000189895812ULL, 0x000fce00078efcffULL, 0x00000045009c7306ULL, 0x000eb0000020d400ULL,
0x0000004600ba7306ULL, 0x000ee20000005400ULL, 0x000000cac900720bULL, 0x002fce0003fdd000ULL,
0x0000009600447306ULL, 0x000fec0000209400ULL, 0x000000019c9c6812ULL, 0x004fe400078efcffULL,
0x0000009600cb7306ULL, 0x000e620000205400ULL, 0x000000babd00720bULL, 0x008fce0003fbd000ULL,
0x0000004600887306ULL, 0x0004f0000000d400ULL, 0x00000096009d7306ULL, 0x000ee2000020d400ULL,
0x000000cb4400720bULL, 0x002fe20003fdd000ULL, 0x0001000046467824ULL, 0x004fc400078e00ffULL,
0x0000010043447824ULL, 0x000fc600078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000004700b87306ULL, 0x000fe20000009400ULL, 0x0000000188885812ULL, 0x008fe400078efcffULL,
0x00000018ffba7819ULL, 0x000fca0000011444ULL, 0x0000004700b77306ULL, 0x000e620000005400ULL,
0x000000019d9d6812ULL, 0x000fce00078efcffULL, 0x000000cd00ce7306ULL, 0x000ff00000209400ULL,
0x000000cd00cf7306ULL, 0x000ea20000205400ULL, 0x000000b7b800720bULL, 0x002fce0003fbd000ULL,
0x0000004700877306ULL, 0x0002f0000000d400ULL, 0x000000cd00a07306ULL, 0x000ee2000020d400ULL,
0x000000cfce00720bULL, 0x004fe20003fdd000ULL, 0x0001000047477824ULL, 0x002fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000004600457306ULL, 0x000fe20000209400ULL,
0x0000000187875812ULL, 0x008fe400078efcffULL, 0x000000bbbe00720bULL, 0x000fca0003fbd000ULL,
0x0000004600cc7306ULL, 0x000e620000205400ULL, 0x00000001a0a06812ULL, 0x000fce00078efcffULL,
0x00000046009b7306ULL, 0x0004e2000020d400ULL, 0x0000000184845812ULL, 0x000fe400078efcffULL,
0x000000b9bc00720bULL, 0x000fe20003fbd000ULL, 0x0000010048b97824ULL, 0x000fc800078e00ffULL,
0x0000004700d07306ULL, 0x000fe20000209400ULL, 0x000000cc4500720bULL, 0x002fe20003fdd000ULL,
0x0000010041467824ULL, 0x004fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fc800000114b9ULL,
0x00000018ffc17819ULL, 0x000fe20000011446ULL, 0x0000004700d17306ULL, 0x000e620000205400ULL,
0x0000000183835812ULL, 0x000fca00078efcffULL, 0x000000019b9b6812ULL, 0x008fe400078efcffULL,
0x0000004700967306ULL, 0x000eb0000020d400ULL, 0x0000004000b27306ULL, 0x000fe20000009400ULL,
0x000000d1d000720bULL, 0x002fce0003fdd000ULL, 0x0000004000b17306ULL, 0x000e6c0000005400ULL,
0x0000000196966812ULL, 0x004fe400078efcffULL, 0x000000d200cd7306ULL, 0x000ff00000209400ULL,
0x000000d200d47306ULL, 0x000ea20000205400ULL, 0x000000b1b200720bULL, 0x002fce0003fbd000ULL,
0x0000004000807306ULL, 0x0002f0000000d400ULL, 0x000000d2009f7306ULL, 0x000ee2000020d400ULL,
0x000000d4cd00720bULL, 0x004fe20003fdd000ULL, 0x0001000040407824ULL, 0x002fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000004100b07306ULL, 0x000fe20000009400ULL,
0x0000000180805812ULL, 0x008fce00078efcffULL, 0x0000004100ab7306ULL, 0x000e620000005400ULL,
0x000000019f9f6812ULL, 0x000fc800078efcffULL, 0x000000809f80723eULL, 0x000fc600000010ffULL,
0x000000c100c27306ULL, 0x000ff00000209400ULL, 0x000000c100d37306ULL, 0x000ea20000205400ULL,
0x000000abb000720bULL, 0x002fce0003fbd000ULL, 0x00000041007f7306ULL, 0x0002f0000000d400ULL,
0x000000c100a27306ULL, 0x000ee2000020d400ULL, 0x000000d3c200720bULL, 0x004fe20003fdd000ULL,
0x0001000041417824ULL, 0x002fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000005900b57306ULL, 0x000fe20000209400ULL, 0x000000017f7f5812ULL, 0x008fce00078efcffULL,
0x0000005900b47306ULL, 0x000e620000205400ULL, 0x00000001a2a26812ULL, 0x000fce00078efcffULL,
0x0000004000467306ULL, 0x000ff00000209400ULL, 0x0000004000477306ULL, 0x000ea20000205400ULL,
0x000000b4b500720bULL, 0x002fce0003fbd000ULL, 0x00000059007e7306ULL, 0x0002f0000020d400ULL,
0x0000004000af7306ULL, 0x000ee2000020d400ULL, 0x000000474600720bULL, 0x004fe20003fdd000ULL,
0x000001004a467824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x002fc80000011448ULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000004100c07306ULL, 0x000fe20000209400ULL,
0x000000017e7e5812ULL, 0x008fe400078efcffULL, 0x000000b3b600720bULL, 0x000fca0003fbd000ULL,
0x0000004100c17306ULL, 0x000e620000205400ULL, 0x00000001afaf6812ULL, 0x000fc800078efcffULL,
0x000000af7e7e723eULL, 0x000fc600000010ffULL, 0x0000004100ac7306ULL, 0x000ea2000020d400ULL,
0x000000017b7b5812ULL, 0x000fce00078efcffULL, 0x0000004200a87306ULL, 0x000fe20000009400ULL,
0x000000c1c000720bULL, 0x002fce0003fdd000ULL, 0x0000004200a77306ULL, 0x000e6c0000005400ULL,
0x00000001acac6812ULL, 0x004fe400078efcffULL, 0x000000bf00407306ULL, 0x000ff00000209400ULL,
0x000000bf00c37306ULL, 0x000ea20000205400ULL, 0x000000a7a800720bULL, 0x002fce0003fbd000ULL,
0x00000042007a7306ULL, 0x0002f0000000d400ULL, 0x000000bf00bd7306ULL, 0x000ee2000020d400ULL,
0x000000c34000720bULL, 0x004fe20003fdd000ULL, 0x0001000042427824ULL, 0x002fc400078e00ffULL,
0x000001004b407824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000004300a67306ULL, 0x000fe20000009400ULL, 0x000000017a7a5812ULL, 0x008fce00078efcffULL,
0x0000004300a57306ULL, 0x000e620000005400ULL, 0x00000001bdbd6812ULL, 0x000fc800078efcffULL,
0x0000007abd7a723eULL, 0x000fc600000010ffULL, 0x000000ba00c47306ULL, 0x000ff00000209400ULL,
0x000000ba00c57306ULL, 0x000ea20000205400ULL, 0x000000a5a600720bULL, 0x002fce0003fbd000ULL,
0x0000004300777306ULL, 0x0002f0000000d400ULL, 0x000000ba00b87306ULL, 0x000ee2000020d400ULL,
0x000000c5c400720bULL, 0x004fe20003fdd000ULL, 0x0001000043437824ULL, 0x002fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000004200417306ULL, 0x000fe20000209400ULL,
0x0000000177775812ULL, 0x008fe400078efcffULL, 0x000000adae00720bULL, 0x000fca0003fbd000ULL,
0x0000004200447306ULL, 0x000e620000205400ULL, 0x00000001b8b86812ULL, 0x000fce00078efcffULL,
0x0000004200b77306ULL, 0x000ea2000020d400ULL, 0x0000000178785812ULL, 0x000fce00078efcffULL,
0x0000006300aa7306ULL, 0x000fe20000209400ULL, 0x000000444100720bULL, 0x002fe20003fdd000ULL,
0x000100004b417824ULL, 0x000fca00078e00ffULL, 0x00000018ffa57819ULL, 0x000fe20000011441ULL,
0x0000006300a97306ULL, 0x000e620000205400ULL, 0x000001003c417824ULL, 0x000fca00078e00ffULL,
0x00000001b7b76812ULL, 0x004fe400078efcffULL, 0x0000004300457306ULL, 0x000fe40000209400ULL,
0x000000b77878723eULL, 0x000fcc00000010ffULL, 0x0000004300be7306ULL, 0x000ea20000205400ULL,
0x000000a9aa00720bULL, 0x002fe40003fbd000ULL, 0x00000018ffa97819ULL, 0x000fca0000011441ULL,
0x0000006300757306ULL, 0x0002f0000020d400ULL, 0x0000004300ba7306ULL, 0x0006e2000020d400ULL,
0x000000be4500720bULL, 0x004fe40003fdd000ULL, 0x00000018ff637819ULL, 0x002fca000001144bULL,
0x0000004800a47306ULL, 0x000fe20000009400ULL, 0x0000010049437824ULL, 0x008fe200078e00ffULL,
0x0000000175755812ULL, 0x000fc800078efcffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004800a37306ULL, 0x000e620000005400ULL, 0x00000001baba6812ULL, 0x000fce00078efcffULL,
0x000000b900427306ULL, 0x000ff00000209400ULL, 0x000000b900bb7306ULL, 0x000ea20000205400ULL,
0x000000a3a400720bULL, 0x002fce0003fbd000ULL, 0x0000004800747306ULL, 0x0002f0000000d400ULL,
0x000000b900b17306ULL, 0x000ee2000020d400ULL, 0x0001000048487824ULL, 0x002fe200078e00ffULL,
0x000000bb4200720bULL, 0x004fc80003fdd000ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000059009a7306ULL, 0x000fe20000209400ULL, 0x0000000174745812ULL, 0x008fce00078efcffULL,
0x0000005900977306ULL, 0x000e620000205400ULL, 0x00000001b1b16812ULL, 0x000fc800078efcffULL,
0x00000074b174723eULL, 0x000fc600000010ffULL, 0x0000004800b27306ULL, 0x000ff00000209400ULL,
0x0000004800bf7306ULL, 0x000ea20000205400ULL, 0x000000979a00720bULL, 0x002fce0003fbd000ULL,
0x0000004900947306ULL, 0x000ff00000009400ULL, 0x0000004900937306ULL, 0x000fe20000005400ULL,
0x000000bfb200720bULL, 0x004fce0003fdd000ULL, 0x00000049005a7306ULL, 0x0003f0000000d400ULL,
0x0000004300b97306ULL, 0x000fe20000209400ULL, 0x0001000049497824ULL, 0x002fca00078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000004300bc7306ULL, 0x000ff00000205400ULL,
0x0000004300ab7306ULL, 0x0003f0000020d400ULL, 0x0000005900717306ULL, 0x000ea2000020d400ULL,
0x00000018ff437819ULL, 0x002fe20000011440ULL, 0x000100004a407824ULL, 0x000fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000004800b07306ULL, 0x000e70000020d400ULL,
0x0000004a00927306ULL, 0x000fe20000009400ULL, 0x0000000171715812ULL, 0x004fc400078efcffULL,
0x000000939400720bULL, 0x000fca0003fbd000ULL, 0x0000004a008f7306ULL, 0x000fe20000005400ULL,
0x00000001b0b06812ULL, 0x002fe400078efcffULL, 0x000000bcb900720bULL, 0x000fe40003fdd000ULL,
0x000000b071b0723eULL, 0x000fc600000010ffULL, 0x0000004a00687306ULL, 0x000fe2000000d400ULL,
0x000000015a5a5812ULL, 0x000fce00078efcffULL, 0x0000004b008e7306ULL, 0x000fe20000009400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x000000959800720bULL, 0x000fca0003fdd000ULL,
0x0000004b008d7306ULL, 0x000ff00000005400ULL, 0x0000004b00677306ULL, 0x000fe2000000d400ULL,
0x0000000162626812ULL, 0x000fce00078efcffULL, 0x0000004900487306ULL, 0x000ff00000209400ULL,
0x0000004900b57306ULL, 0x000e700000205400ULL, 0x0000004900b37306ULL, 0x000eb0000020d400ULL,
0x0000004600b47306ULL, 0x000fe20000209400ULL, 0x000000b54800720bULL, 0x002fce0003fbd000ULL,
0x0000004600c17306ULL, 0x000fec0000205400ULL, 0x00000001b3b35812ULL, 0x004fe400078efcffULL,
0x0000004600a77306ULL, 0x0003e2000020d400ULL, 0x0000008f9200720bULL, 0x000fe40003fbd000ULL,
0x000000b362b1723eULL, 0x000fca00000010ffULL, 0x0000004300b67306ULL, 0x000fe20000209400ULL,
0x011800003944783bULL, 0x002e6a0000000200ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x0000004300c37306ULL, 0x000eb00000205400ULL, 0x00000043004a7306ULL, 0x000ef0000020d400ULL,
0x0000004000497306ULL, 0x000fe20000209400ULL, 0x000000c3b600720bULL, 0x004fce0003fdd000ULL,
0x0000004000a87306ULL, 0x000eac0000205400ULL, 0x000000014a4a6812ULL, 0x008fe400078efcffULL,
0x00000040004b7306ULL, 0x0006a2000020d400ULL, 0x0000003744448231ULL, 0x082fe200003400ffULL,
0x000000909100720bULL, 0x000fe20003fdd000ULL, 0x0000003746468231ULL, 0x000fc400003400ffULL,
0x0000003845458231ULL, 0x080fe400003400ffULL, 0x0000003847478231ULL, 0x000fe200003400ffULL,
0x0000006300867306ULL, 0x000fe20000209400ULL, 0x011800003a40783bULL, 0x008e620000000200ULL,
0x000000a84900720bULL, 0x004fe40003fbd000ULL, 0x0000009c8949723eULL, 0x000fc600000010ffULL,
0x000000016e6e6812ULL, 0x000fe200078efcffULL, 0x0000006300857306ULL, 0x000eae0000205400ULL,
0x000000014b4b5812ULL, 0x000fe200078efcffULL, 0x000000a500ad7306ULL, 0x000fe60000209400ULL,
0x0000004b6e6e723eULL, 0x000fca00000010ffULL, 0x000000a500aa7306ULL, 0x000fe20000205400ULL,
0x000000858600720bULL, 0x004fce0003fbd000ULL, 0x000000a900a37306ULL, 0x000ff00000209400ULL,
0x000000a900ae7306ULL, 0x000ea20000205400ULL, 0x0000003740408231ULL, 0x082fe400003400ffULL,
0x0000003742428231ULL, 0x000fc400003400ffULL, 0x0000003841418231ULL, 0x080fe400003400ffULL,
0x0000003843438231ULL, 0x000fe200003400ffULL, 0x000000c1b400720bULL, 0x000fe20003f1d000ULL,
0x000000a500a67306ULL, 0x0003e2000020d400ULL, 0x000000aea300720bULL, 0x004fce0003fdd000ULL,
0x0000006300597306ULL, 0x000ea2000020d400ULL, 0x000001003da57824ULL, 0x002fc600078e00ffULL,
0x00000001a7a70812ULL, 0x000fe400078efcffULL, 0x0000008d8e00720bULL, 0x000fe40003f1d000ULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x000000a900a47306ULL, 0x000e62000020d400ULL,
0x0000000159595812ULL, 0x004fce00078efcffULL, 0x0000003c00827306ULL, 0x000fe40000009400ULL,
0x0000000167670812ULL, 0x000fe400078efcffULL, 0x000000aaad00720bULL, 0x000fc80003f1d000ULL,
0x0000003c00817306ULL, 0x000ea20000005400ULL, 0x00000001a4a46812ULL, 0x002fce00078efcffULL,
0x0000003d007c7306ULL, 0x000fe20000009400ULL, 0x00000001a6a60812ULL, 0x000fce00078efcffULL,
0x0000003d007d7306ULL, 0x000e620000005400ULL, 0x000000818200720bULL, 0x004fe40003f1d000ULL,
0x0000007fa281723eULL, 0x000fe400000010ffULL, 0x000000ac7b7f723eULL, 0x000fe400000010ffULL,
0x00000077b87b723eULL, 0x000fe200000010ffULL, 0x000000a500b27306ULL, 0x000fe40000209400ULL,
0x000000804410723cULL, 0x040fec0000041810ULL, 0x000000a500bb7306ULL, 0x000ea20000205400ULL,
0x0000007d7c00720bULL, 0x002fe20003fbd000ULL, 0x0000007e440c723cULL, 0x040fec000004180cULL,
0x0000003c006d7306ULL, 0x0002e4000000d400ULL, 0x0000007a4408723cULL, 0x000fec0000041808ULL,
0x0000003d00647306ULL, 0x0006e2000000d400ULL, 0x000100003c3c7824ULL, 0x002fe200078e00ffULL,
0x000000bbb200720bULL, 0x004fc80003fdd000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000000a500977306ULL, 0x000e62000020d400ULL, 0x000100003d3d7824ULL, 0x008fe200078e00ffULL,
0x000000016d6d0812ULL, 0x000fc800078efcffULL, 0x00000018ff487819ULL, 0x000fe2000001143dULL,
0x000001003e3d7824ULL, 0x000fe200078e00ffULL, 0x0000003c00937306ULL, 0x000fe20000209400ULL,
0x0000000164645812ULL, 0x000fce00078efcffULL, 0x0000003c009a7306ULL, 0x000ea20000205400ULL,
0x0000000197976812ULL, 0x002fc800078efcffULL, 0x000000649797723eULL, 0x000fc600000010ffULL,
0x0000003c00947306ULL, 0x0002f0000020d400ULL, 0x0000006a00767306ULL, 0x000fe20000209400ULL,
0x0000008c993c723eULL, 0x002fe400000010ffULL, 0x00000018ff8c7819ULL, 0x000fc4000001143dULL,
0x0000008aa13d723eULL, 0x000fe400000010ffULL, 0x0000009a9300720bULL, 0x004fe20003f1d000ULL,
0x0000006a00797306ULL, 0x000e680000205400ULL, 0x0000003c4420723cULL, 0x000b680000041820ULL,
0x0000004800957306ULL, 0x000fe60000209400ULL, 0x000000889d3c723eULL, 0x020fc400000010ffULL,
0x00000087a03d723eULL, 0x000fe400000010ffULL, 0x0000000194940812ULL, 0x008fe200078efcffULL,
0x0000004800987306ULL, 0x000ea20000205400ULL, 0x000000797600720bULL, 0x002fe40003fdd000ULL,
0x000000ba7579723eULL, 0x000fe200000010ffULL, 0x0000003c4418723cULL, 0x040fe20000041818ULL,
0x000000727300720bULL, 0x000fe40003f1d000ULL, 0x0000005aab75723eULL, 0x000fe200000010ffULL,
0x0000004800927306ULL, 0x0003e8000020d400ULL, 0x000000784404723cULL, 0x000fe80000041804ULL,
0x0000006a006b7306ULL, 0x000ee2000020d400ULL, 0x0000009e8b48723eULL, 0x002fc400000010ffULL,
0x000000989500720bULL, 0x004fe20003fbd000ULL, 0x000000744020723cULL, 0x000fe20000041820ULL,
0x0000000161610812ULL, 0x000fc600078efcffULL, 0x0000003e005b7306ULL, 0x000fe80000009400ULL,
0x00000048441c723cULL, 0x000b68000004181cULL, 0x0000003e00707306ULL, 0x000e620000005400ULL,
0x000000016b6b6812ULL, 0x008fe400078efcffULL, 0x000001003f497824ULL, 0x020fe200078e00ffULL,
0x0000009b8448723eULL, 0x000fc400000010ffULL, 0x0000000192925812ULL, 0x000fe400078efcffULL,
0x0000008c008a7306ULL, 0x000fe20000209400ULL, 0x00000018ff3c7819ULL, 0x000fe40000011449ULL,
0x000000968349723eULL, 0x000fe400000010ffULL, 0x000000926195723eULL, 0x000fe400000010ffULL,
0x0000006da496723eULL, 0x000fe200000010ffULL, 0x0000008c00897306ULL, 0x000ea20000205400ULL,
0x000000705b00720bULL, 0x002fe20003fdd000ULL, 0x000000484414723cULL, 0x000b620000041814ULL,
0x000000946b94723eULL, 0x000fca00000010ffULL, 0x0000003e00607306ULL, 0x0002e4000000d400ULL,
0x000000b0401c723cULL, 0x040f6c000004181cULL, 0x0000003c003d7306ULL, 0x000fe20000209400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000898a00720bULL, 0x004fe20003fbd000ULL,
0x000000964010723cULL, 0x000f660000041810ULL, 0x00000018ff3e7819ULL, 0x000fc4000001143eULL,
0x0000003c007c7306ULL, 0x000e620000205400ULL, 0x0000000160606812ULL, 0x008fe400078efcffULL,
0x00000094400c723cULL, 0x000f6a000004180cULL, 0x0000003c00497306ULL, 0x0204f0000020d400ULL,
0x0000003f00667306ULL, 0x000fe20000009400ULL, 0x000100003f3c7824ULL, 0x004fe200078e00ffULL,
0x0000007c3d00720bULL, 0x002fc40003f1d000ULL, 0x000000674a3d723eULL, 0x000fe400000010ffULL,
0x00000018ff457819ULL, 0x000fe4000001143cULL, 0x0000003f006f7306ULL, 0x000fe20000005400ULL,
0x00000068a73c723eULL, 0x000fcc00000010ffULL, 0x0000000149490812ULL, 0x008fe200078efcffULL,
0x0000003f005e7306ULL, 0x000fe2000000d400ULL, 0x0000005c6500720bULL, 0x000fe20003f1d000ULL,
0x0000003c4018723cULL, 0x000b6c0000041818ULL, 0x0000008c00857306ULL, 0x000e62000020d400ULL,
0x000176c8343c7811ULL, 0x020fca00078e18ffULL, 0x0000000169690812ULL, 0x000fe400078efcffULL,
0x0000003e00487306ULL, 0x000ff00000209400ULL, 0x0000003e003f7306ULL, 0x000ea20000205400ULL,
0x0000000185855812ULL, 0x002fc400078efcffULL, 0x0000006f6600720bULL, 0x000fe40003fbd000ULL,
0x000000a6596f723eULL, 0x000fe400000010ffULL, 0x000000608560723eULL, 0x000fe200000010ffULL,
0x0000003e00447306ULL, 0x000e68000020d400ULL, 0x0000006e4014723cULL, 0x000b680000041814ULL,
0x0000006c00637306ULL, 0x000fe20000209400ULL, 0x0000003f4800720bULL, 0x004fc40003fdd000ULL,
0x000000015e5e5812ULL, 0x000fc800078efcffULL, 0x0000005e4961723eULL, 0x000fe200000010ffULL,
0x0000006c006a7306ULL, 0x000eac0000205400ULL, 0x0000000144446812ULL, 0x002fe200078efcffULL,
0x000000604008723cULL, 0x000b620000041808ULL, 0x0000004500467306ULL, 0x000fe40000209400ULL,
0x000000446944723eULL, 0x000fcc00000010ffULL, 0x0000004500477306ULL, 0x000e620000205400ULL,
0x0000006a6300720bULL, 0x004fce0003fbd000ULL, 0x0000006c006c7306ULL, 0x000eb0000020d400ULL,
0x0000004500457306ULL, 0x000ee2000020d400ULL, 0x000000474600720bULL, 0x002fe40003fdd000ULL,
0x000000016c6c5812ULL, 0x004fd600078efcffULL, 0x0000000145456812ULL, 0x008fc800078efcffULL,
0x000000456c45723eULL, 0x000fce00000010ffULL, 0x000000444004723cULL, 0x000b620000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000003c3c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000802d3c7811ULL, 0x002fe200078e40ffULL, 0x0176900053ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff407224ULL, 0x020fe200078e003dULL, 0x000000022c5b7810ULL, 0x000fe40007ffe0ffULL,
0x000000033c00720cULL, 0x000fe40003f06070ULL, 0x000000012b3d7812ULL, 0x000fd600078ec0ffULL,
0x00006d1000000947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x002fc40000015200ULL,
0x000004002a3f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe40007804840ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000413e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000142427810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004002a3f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x002fe40007804840ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010253c7824ULL, 0x000fe200078e00ffULL, 0x000000012d3d7810ULL, 0x000fe20007ffe0ffULL,
0x0000580030307a24ULL, 0x010fc600078e02ffULL, 0x000000003d00720cULL, 0x000fe20003f06070ULL,
0x0000004030477824ULL, 0x000fe200078e00ffULL, 0xffffffe03c3e7812ULL, 0x000fca00078ec0ffULL,
0x000001002d3e7824ULL, 0x000fca00078e023eULL, 0x000000c03e3e7810ULL, 0x000fc80007ffe0ffULL,
0x0000002031457812ULL, 0x000fe200078ef83eULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000103c437812ULL, 0x000fe200078ec0ffULL, 0x0000001033407824ULL, 0x000fe200078e00ffULL,
0x00000003ff427819ULL, 0x000fe40000011633ULL, 0x0000003e03307217ULL, 0x000fe40007800000ULL,
0x0000000442487810ULL, 0x040fe20007ffe0ffULL, 0x0000000142447824ULL, 0x000fe200078e0243ULL,
0x0000007040467812ULL, 0x000fe200078ec0ffULL, 0x0000000130307824ULL, 0x000fc400078e0a3eULL,
0x00000001443c7824ULL, 0x000fe400078e0245ULL, 0x00000001484a7824ULL, 0x100fe200078e0243ULL,
0x0000003043307217ULL, 0x000fe40007800000ULL, 0x0000003c473c7210ULL, 0x000fe20007f1e0ffULL,
0x000000084a497824ULL, 0x000fe400078e00ffULL, 0x0000000130307824ULL, 0x000fe400078e0a43ULL,
0x000000ffff3f7224ULL, 0x000fe200000e06ffULL, 0x00005e003c3d7a11ULL, 0x000fc800078038ffULL,
0x00005f003c3e7a11ULL, 0x000fe200000f3c3fULL, 0x000000014a3c7824ULL, 0x000fe200078e0245ULL,
0x000000304200720cULL, 0x000fe20003f06070ULL, 0x00000001443f7824ULL, 0x040fe400078e0233ULL,
0x0000000844447824ULL, 0x000fe200078e00ffULL, 0x0000003c47407210ULL, 0x000fe40007fde0ffULL,
0x000000463d3c7210ULL, 0x000fe40007fbe0ffULL, 0xfffffff844417812ULL, 0x000fe200078ee23fULL,
0x000000ffff3f7224ULL, 0x000fc400030e06ffULL, 0x000000ffff3d7224ULL, 0x000fe200028e063eULL,
0x000000304800720cULL, 0x000fe20003fa6070ULL, 0x0000001041417824ULL, 0x000fe200078e0258ULL,
0x0000000842487810ULL, 0x000fe20007ffe0ffULL, 0x000000014a447824ULL, 0x000fe200078e0233ULL,
0x00005e00403e7a11ULL, 0x000fe400078c38ffULL, 0x0000000c424a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001485a7824ULL, 0x000fe200078e0243ULL, 0x00005f0040407a11ULL, 0x000fe200030f3c3fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c417faeULL, 0x0003e2000c101c46ULL,
0x000000463e3e7210ULL, 0x000fe20007f1e0ffULL, 0x000000015a3f7824ULL, 0x000fe200078e0245ULL,
0xfffffff849497812ULL, 0x000fe200078ee244ULL, 0x000000014a447824ULL, 0x000fc600078e0243ULL,
0x0000003f47427210ULL, 0x000fe20007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e0640ULL,
0x000000304800720cULL, 0x000fe20003f06070ULL, 0x0000001049417824ULL, 0x002fe400078e0258ULL,
0x00000001443c7824ULL, 0x000fe400078e0245ULL, 0x000000ffff437224ULL, 0x000fe200030e06ffULL,
0x000000003e417faeULL, 0x0003e2000e901c46ULL, 0x00005e00423d7a11ULL, 0x000fe200078a38ffULL,
0x000000085a457824ULL, 0x000fe200078e00ffULL, 0x0000003c47407210ULL, 0x000fc40007fde0ffULL,
0x00005f0042427a11ULL, 0x000fe400028f3c43ULL, 0x000000304a00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff437224ULL, 0x000fe200030e06ffULL, 0x000000463d3c7210ULL, 0x000fe20007fde0ffULL,
0x000000015a307824ULL, 0x100fe400078e0233ULL, 0x00000001443f7824ULL, 0x002fe400078e0233ULL,
0x000000ffff3d7224ULL, 0x000fe200030e0642ULL, 0x00005e00403e7a11ULL, 0x000fe200078c38ffULL,
0x0000000844447824ULL, 0x000fe200078e00ffULL, 0xfffffff845417812ULL, 0x000fc400078ee230ULL,
0x00005f0040307a11ULL, 0x000fe400030f3c43ULL, 0x000000463e3e7210ULL, 0x000fe20007fde0ffULL,
0x0000001041417824ULL, 0x000fe200078e0258ULL, 0xfffffff844437812ULL, 0x000fc600078ee23fULL,
0x000000ffff3f7224ULL, 0x000fe200030e0630ULL, 0x000000003c417faeULL, 0x0003e2000c101c46ULL,
0x0000001043437824ULL, 0x000fca00078e0258ULL, 0x000000003e437faeULL, 0x0003e2000e901c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x000000103c3c7812ULL, 0x000fc800078ec0ffULL,
0x0000003c333c7211ULL, 0x000fc800078fe8ffULL, 0x000000043c3e7810ULL, 0x040fe20007ffe0ffULL,
0x000000013c307824ULL, 0x040fe400078e0245ULL, 0x000000013c3d7824ULL, 0x140fe400078e0233ULL,
0x000000083c407824ULL, 0x000fe200078e00ffULL, 0x0000003047447210ULL, 0x000fe20007f1e0ffULL,
0x000000013e3f7824ULL, 0x040fe400078e0233ULL, 0x000000083e427824ULL, 0x000fe200078e00ffULL,
0xfffffff840497812ULL, 0x000fe200078ee23dULL, 0x000000ffff3d7224ULL, 0x000fe200000e06ffULL,
0x00005e0044437a11ULL, 0x000fe200078038ffULL, 0x000000013e307824ULL, 0x000fe200078e0245ULL,
0xfffffff8424b7812ULL, 0x000fc400078ee23fULL, 0x000000083c407810ULL, 0x040fe40007ffe0ffULL,
0x0000000c3c427810ULL, 0x000fe40007ffe0ffULL, 0x00005f0044447a11ULL, 0x000fe200000f3c3dULL,
0x00000001403c7824ULL, 0x100fe200078e0245ULL, 0x00000030473f7210ULL, 0x040fe20007f1e0ffULL,
0x0000000142307824ULL, 0x000fe400078e0245ULL, 0x00000001403d7824ULL, 0x040fe200078e0233ULL,
0x0000003c473c7210ULL, 0x040fe20007fbe0ffULL, 0x0000000840467824ULL, 0x000fe200078e00ffULL,
0x0000003047307210ULL, 0x000fe20007fde0ffULL, 0x000000ffff407224ULL, 0x000fe200000e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078038ffULL, 0x000000ffff417224ULL, 0x000fe200028e06ffULL,
0xfffffff846597812ULL, 0x000fe200078ee23dULL, 0x0000001033467824ULL, 0x000fe200078e00ffULL,
0x00005f003f3f7a11ULL, 0x000fe200000f3c40ULL, 0x0000000142457824ULL, 0x000fe200078e0233ULL,
0x00005e003c407a11ULL, 0x000fe200078038ffULL, 0x0000000842487824ULL, 0x000fe200078e00ffULL,
0x00005e0030427a11ULL, 0x000fe200078a38ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e06ffULL,
0x0000007046467812ULL, 0x000fe200078ec0ffULL, 0x000000104b477824ULL, 0x000fe200078e0258ULL,
0x00005f003c417a11ULL, 0x000fc400000f3c41ULL, 0x00005f0030307a11ULL, 0x000fe400028f3c3dULL,
0x00000046433c7210ULL, 0x080fe40007f1e0ffULL, 0x000000463e3e7210ULL, 0x080fe40007fbe0ffULL,
0xfffffff8485b7812ULL, 0x000fe200078ee245ULL, 0x000000ffff3d7224ULL, 0x000fe200000e0644ULL,
0x0000004640407210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e063fULL,
0x0000004642427210ULL, 0x000fe20007fbe0ffULL, 0x0000001049457824ULL, 0x000fc400078e0258ULL,
0x0000001059497824ULL, 0x100fe400078e0258ULL, 0x000000ffff417224ULL, 0x000fe200000e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x000000105b4b7824ULL, 0x000fe400078e0258ULL, 0x000000ffff437224ULL, 0x000fe200028e0630ULL,
0x000000003e477faeULL, 0x0003e8000b901c46ULL, 0x0000000040497faeULL, 0x0003e8000b901c46ULL,
0x00000000424b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000032c3c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff307424ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x000000023c00720cULL, 0x000fda0003fa6070ULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x000000012f3c7824ULL, 0x000fe400078e023cULL,
0x00000004ff3d7424ULL, 0x000fc800078e00ffULL, 0x000060003c3c7625ULL, 0x000fca00078e003dULL,
0x000000063c307981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000520403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80028587f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176480026407f8cULL, 0x0002a4000c80043fULL,
0x00000000003c7805ULL, 0x002fc40000015200ULL, 0x01764c00263f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x006fe40007804841ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000433e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000142427810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c00263f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000100463d7810ULL, 0x000fca0007ffe027ULL,
0x00000001243d7824ULL, 0x000fca00078e023dULL, 0x017000003d3c7984ULL, 0x000e680000000800ULL,
0x017200003d407984ULL, 0x0004e20000000800ULL, 0x0000005f3c00720bULL, 0x002fe20003f1d000ULL,
0x0000ef227f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x004fc800000e0100ULL,
0x0000ffff3dff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff937424ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x000fd200078e005fULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000002363e7810ULL, 0x000fe40007ffe0ffULL,
0x0000005f3c00720bULL, 0x000fe40003f14000ULL, 0x000000253e00720cULL, 0x000fe20003fa5270ULL,
0x0000eee27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000427806ULL, 0x000fc400000e0100ULL,
0x00000080253fd824ULL, 0x000fe200078e0246ULL, 0x0000003c5f3ed209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x000000012441d824ULL, 0x000fe200078e023fULL,
0x00009910423f7816ULL, 0x000fc800000000ffULL, 0x0174003e4100d388ULL, 0x0003e20000000800ULL,
0x000000ff3f00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000003c5f3e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff42ff7812ULL, 0x000fc6000780c0ffULL, 0x8000003e5f3e7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b3e3e7820ULL, 0x000fc80000410000ULL, 0x0000003e00417308ULL, 0x000e640000000800ULL,
0x000000412e2e7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff447819ULL, 0x000fe20000011633ULL, 0x0000ee027f007947ULL, 0x000fea000b800000ULL,
0x00001f44413e7589ULL, 0x0002a400000e0000ULL, 0x0000003e20207220ULL, 0x084fe40000410000ULL,
0x0000003e21217220ULL, 0x080fe40000410000ULL, 0x0000003e1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003e1d1d7220ULL, 0x000fc40000410000ULL, 0x0000003e18187220ULL, 0x080fe40000410000ULL,
0x0000003e19197220ULL, 0x080fe40000410000ULL, 0x0000003e14147220ULL, 0x080fe40000410000ULL,
0x0000003e15157220ULL, 0x080fe40000410000ULL, 0x0000003e10107220ULL, 0x080fe40000410000ULL,
0x0000003e11117220ULL, 0x000fc40000410000ULL, 0x0000003e0c0c7220ULL, 0x080fe40000410000ULL,
0x0000003e0d0d7220ULL, 0x080fe40000410000ULL, 0x0000003e08087220ULL, 0x080fe40000410000ULL,
0x0000003e09097220ULL, 0x080fe40000410000ULL, 0x0000003e04047220ULL, 0x080fe40000410000ULL,
0x0000003e05057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0042ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000833447811ULL, 0x002fe200078ff0ffULL, 0x0000ed127f007947ULL, 0x000fea000b800000ULL,
0x00001f44413e7589ULL, 0x0002a400000e0000ULL, 0x0000003e22227220ULL, 0x084fe40000410000ULL,
0x0000003e23237220ULL, 0x080fe40000410000ULL, 0x0000003e1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003e1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003e1a1a7220ULL, 0x080fe40000410000ULL,
0x0000003e1b1b7220ULL, 0x000fc40000410000ULL, 0x0000003e16167220ULL, 0x080fe40000410000ULL,
0x0000003e17177220ULL, 0x080fe40000410000ULL, 0x0000003e12127220ULL, 0x080fe40000410000ULL,
0x0000003e13137220ULL, 0x080fe40000410000ULL, 0x0000003e0e0e7220ULL, 0x080fe40000410000ULL,
0x0000003e0f0f7220ULL, 0x000fc40000410000ULL, 0x0000003e0a0a7220ULL, 0x080fe40000410000ULL,
0x0000003e0b0b7220ULL, 0x080fe40000410000ULL, 0x0000003e06067220ULL, 0x080fe40000410000ULL,
0x0000003e07077220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff42ff7812ULL, 0x000fe2000780083dULL, 0x00000001ff937424ULL, 0x000fe200078e00ffULL,
0x0000003c5f527209ULL, 0x000fd60007810000ULL, 0x800000523c3c0221ULL, 0x000fe20000010000ULL,
0x00007610ff930816ULL, 0x000fc60000000093ULL, 0x3fb8aa3b3c3c0820ULL, 0x000fc80000410000ULL,
0x0000003c00350308ULL, 0x000e640000000800ULL, 0x0000003540400220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002e402e7221ULL, 0x008fc40000010000ULL,
0x00000000003c7805ULL, 0x000fca0000015200ULL, 0x0176ac00543e7984ULL, 0x000e640000000800ULL,
0x800000003eff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3e7819ULL, 0x000fc8000001143fULL, 0x000000413e3e7211ULL, 0x000fca00078110ffULL,
0x000000ffff3f7224ULL, 0x000fca00000e063fULL, 0x000000023e3e7819ULL, 0x000fc8000000123fULL,
0x0000003e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000140407810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac00543e7984ULL, 0x000e640000000800ULL, 0x800000003eff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910933c7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff3c00720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000035ff37723eULL, 0x000fe400000010ffULL,
0x00000002ff3d7819ULL, 0x000fe40000011633ULL, 0x00005410373c7816ULL, 0x000fe20000000037ULL,
0x0000e9127f007947ULL, 0x000fea000b800000ULL, 0x00001f3d3c377589ULL, 0x0002a400000e0000ULL,
0x000000083d447810ULL, 0x002fe20007ffe0ffULL, 0x0000e9627f007947ULL, 0x000fea000b800000ULL,
0x00001f443c387589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000103d447810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe200078e003cULL,
0x00009c60003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000f18000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000183d447810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x004fe200078e003cULL, 0x00009cd0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000f11000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000010002b3c7824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000150517824ULL, 0x040fe400078e0251ULL, 0x0000000850507824ULL, 0x000fe200078e00ffULL,
0x000010003c3d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff850517812ULL, 0x000fe200078ee251ULL,
0x00002000343d7824ULL, 0x000fca00078e023dULL, 0x000130003d507810ULL, 0x000fca0007ffe0ffULL,
0x0000001051407824ULL, 0x100fe400078e0250ULL, 0x000000104f447824ULL, 0x100fe400078e0250ULL,
0x000000104e487824ULL, 0x100fe400078e0250ULL, 0x000000004040783bULL, 0x004e620000004200ULL,
0x000000103b3c7824ULL, 0x000fc600078e0250ULL, 0x000000004444783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x00000018ff5b7819ULL, 0x002fe20000011441ULL, 0x0000010040777824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011442ULL, 0x0000004000c67306ULL, 0x000fe20000009400ULL,
0x00000018ff4f7819ULL, 0x000fe20000011440ULL, 0x00000100427e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fc40000011477ULL, 0x00000018ff607819ULL, 0x004fe4000001144aULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000005b00c27306ULL, 0x000fe20000209400ULL,
0x00000018ff787819ULL, 0x008fe4000001143dULL, 0x00000018ff5d7819ULL, 0x000fe40000011443ULL,
0x00000018ff797819ULL, 0x000fe4000001143eULL, 0x00000018ff667819ULL, 0x000fe2000001143cULL,
0x0000005b008f7306ULL, 0x000fe20000205400ULL, 0x00000018ff677819ULL, 0x000fce000001143fULL,
0x0000005b00927306ULL, 0x0003f0000020d400ULL, 0x0000005c00bc7306ULL, 0x000fe20000209400ULL,
0x00000018ff5b7819ULL, 0x002fce0000011445ULL, 0x0000005c00bf7306ULL, 0x000ff00000205400ULL,
0x0000005c008b7306ULL, 0x0003f0000020d400ULL, 0x0000005b00b67306ULL, 0x000fe20000209400ULL,
0x00000018ff5c7819ULL, 0x002fce0000011446ULL, 0x0000005b00b97306ULL, 0x000ff00000205400ULL,
0x0000005b00757306ULL, 0x0003f0000020d400ULL, 0x0000004000c77306ULL, 0x000ea20000005400ULL,
0x00000018ff5b7819ULL, 0x002fce0000011449ULL, 0x0000004000a47306ULL, 0x0002f0000000d400ULL,
0x0000005c00b37306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x002fe200078e00ffULL,
0x000000c7c600720bULL, 0x004fcc0003fdd000ULL, 0x0000005c00ae7306ULL, 0x000fee0000205400ULL,
0x00000001a4a46812ULL, 0x008fe200078efcffULL, 0x0000005c00737306ULL, 0x000ff0000020d400ULL,
0x0000005b00a77306ULL, 0x000ff00000209400ULL, 0x0000005b00a27306ULL, 0x000ff00000205400ULL,
0x0000005b005c7306ULL, 0x000ff0000020d400ULL, 0x00000078006e7306ULL, 0x000ff00000209400ULL,
0x00000078006d7306ULL, 0x000ff00000205400ULL, 0x00000078005b7306ULL, 0x0003f0000020d400ULL,
0x0000007700d37306ULL, 0x000fe20000209400ULL, 0x00000018ff787819ULL, 0x002fe20000011440ULL,
0x0000010041407824ULL, 0x000fcc00078e00ffULL, 0x0000007700d07306ULL, 0x000e700000205400ULL,
0x0000004100c57306ULL, 0x000ff00000009400ULL, 0x0000004100887306ULL, 0x000fe20000005400ULL,
0x000000d0d300720bULL, 0x002fce0003fbd000ULL, 0x00000041009b7306ULL, 0x0003f0000000d400ULL,
0x0000007800cd7306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x002fce00078e00ffULL,
0x0000007800ca7306ULL, 0x000ff00000205400ULL, 0x00000078009d7306ULL, 0x0003f0000020d400ULL,
0x0000004200c07306ULL, 0x000fe20000009400ULL, 0x0000010043787824ULL, 0x002fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000004200c37306ULL, 0x000ff00000005400ULL,
0x0000004200917306ULL, 0x0003f0000000d400ULL, 0x0000007700ab7306ULL, 0x0004e2000020d400ULL,
0x0001000042427824ULL, 0x002fce00078e00ffULL, 0x0000004f00c47306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x004fce0000011441ULL, 0x0000004f007f7306ULL, 0x000e620000205400ULL,
0x00000001abab5812ULL, 0x008fe400078efcffULL, 0x000000cacd00720bULL, 0x000fca0003fbd000ULL,
0x0000004f00987306ULL, 0x0004f0000020d400ULL, 0x0000007700417306ULL, 0x000fe20000209400ULL,
0x00000018ff4f7819ULL, 0x004fe40000011444ULL, 0x0000007fc400720bULL, 0x002fe20003fdd000ULL,
0x0000010049c47824ULL, 0x000fe200078e00ffULL, 0x000000019d9d5812ULL, 0x000fc600078efcffULL,
0x0000007700c87306ULL, 0x000e620000205400ULL, 0x00000018ffca7819ULL, 0x000fce00000114c4ULL,
0x0000007700977306ULL, 0x000462000020d400ULL, 0x0000000198986812ULL, 0x008fe400078efcffULL,
0x00000088c500720bULL, 0x000fca0003fdd000ULL, 0x0000007e00cc7306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x004fce0000011442ULL, 0x0000007e00cb7306ULL, 0x000fe20000205400ULL,
0x000000019b9b6812ULL, 0x000fe400078efcffULL, 0x000000c84100720bULL, 0x002fe20003fdd000ULL,
0x000001004a417824ULL, 0x000fc800078e00ffULL, 0x0000007e00947306ULL, 0x0003e2000020d400ULL,
0x00000018ff417819ULL, 0x000fce0000011441ULL, 0x0000007800cf7306ULL, 0x000fe20000209400ULL,
0x00000100447e7824ULL, 0x002fe200078e00ffULL, 0x0000000197976812ULL, 0x000fe400078efcffULL,
0x000000c3c000720bULL, 0x000fe40003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007800ce7306ULL, 0x000ff00000205400ULL, 0x0000007800957306ULL, 0x0003e2000020d400ULL,
0x0000000191916812ULL, 0x000fce00078efcffULL, 0x0000004400bb7306ULL, 0x000fe20000009400ULL,
0x0000010045787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000004400b87306ULL, 0x000ff00000005400ULL, 0x0000004400827306ULL, 0x0003f0000000d400ULL,
0x0000004f00b57306ULL, 0x000fe20000209400ULL, 0x0001000044447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004f00b47306ULL, 0x000ff00000205400ULL,
0x0000004f007d7306ULL, 0x0003f0000020d400ULL, 0x0000007700427306ULL, 0x000fe20000209400ULL,
0x00000018ff4f7819ULL, 0x002fce0000011448ULL, 0x0000007700d17306ULL, 0x000e700000205400ULL,
0x00000077008e7306ULL, 0x0004f0000020d400ULL, 0x0000004500bd7306ULL, 0x000fe20000009400ULL,
0x0000010046777824ULL, 0x004fe200078e00ffULL, 0x000000d14200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff777819ULL, 0x000fe40000011477ULL, 0x0000004500ba7306ULL, 0x000fee0000005400ULL,
0x000000018e8e6812ULL, 0x008fe200078efcffULL, 0x00000045007a7306ULL, 0x0003f0000000d400ULL,
0x0000004600b27306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x002fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600b77306ULL, 0x000ff00000005400ULL,
0x0000004600767306ULL, 0x0003f0000000d400ULL, 0x0000004f00a87306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004f00a17306ULL, 0x000ff00000205400ULL, 0x0000004f006c7306ULL, 0x000ff0000020d400ULL,
0x00000060009a7306ULL, 0x000ff00000209400ULL, 0x0000006000997306ULL, 0x000ff00000205400ULL,
0x0000006000697306ULL, 0x000ff0000020d400ULL, 0x0000005d00af7306ULL, 0x000ff00000209400ULL,
0x0000005d00be7306ULL, 0x000e700000205400ULL, 0x0000005d00837306ULL, 0x0004f0000020d400ULL,
0x0000007900607306ULL, 0x000fe20000209400ULL, 0x00000018ff5d7819ULL, 0x004fc40000011447ULL,
0x000000beaf00720bULL, 0x002fca0003fdd000ULL, 0x00000079004f7306ULL, 0x000ff00000205400ULL,
0x0000007900647306ULL, 0x0003e2000020d400ULL, 0x0000000183836812ULL, 0x008fce00078efcffULL,
0x0000007800d77306ULL, 0x000fe20000209400ULL, 0x00000018ff797819ULL, 0x002fce0000011440ULL,
0x0000007800d67306ULL, 0x000e700000205400ULL, 0x0000007800877306ULL, 0x0004f0000020d400ULL,
0x0000004700b07306ULL, 0x000fe20000009400ULL, 0x0000010047787824ULL, 0x004fe200078e00ffULL,
0x000000d6d700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000004700b17306ULL, 0x000fee0000005400ULL, 0x0000000187876812ULL, 0x008fe200078efcffULL,
0x0000004700727306ULL, 0x0003e2000000d400ULL, 0x000000b4b500720bULL, 0x000fce0003fdd000ULL,
0x0000004400d97306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x002fca00078e00ffULL,
0x00000018ffe67819ULL, 0x000fe40000011447ULL, 0x0000004400d87306ULL, 0x000fe20000205400ULL,
0x000000017d7d6812ULL, 0x000fce00078efcffULL, 0x0000004400867306ULL, 0x0003f0000020d400ULL,
0x0000007900407306ULL, 0x000fe20000209400ULL, 0x0000010048447824ULL, 0x002fca00078e00ffULL,
0x00000018ffe77819ULL, 0x000fe40000011444ULL, 0x0000007900c97306ULL, 0x000e700000205400ULL,
0x0000007e00d47306ULL, 0x000ff00000209400ULL, 0x0000007e00d57306ULL, 0x000fe20000205400ULL,
0x000000c94000720bULL, 0x002fce0003fbd000ULL, 0x0000007e00897306ULL, 0x000ff0000020d400ULL,
0x0000004500db7306ULL, 0x000ff00000209400ULL, 0x0000004500da7306ULL, 0x000ff00000205400ULL,
0x0000004500807306ULL, 0x000ff0000020d400ULL, 0x0000004600e07306ULL, 0x000ff00000209400ULL,
0x0000004600e17306ULL, 0x000ff00000205400ULL, 0x00000046007e7306ULL, 0x0003f0000020d400ULL,
0x0000007900aa7306ULL, 0x000ea2000020d400ULL, 0x012000003944783bULL, 0x002e6e0000000200ULL,
0x0000004300967306ULL, 0x000fe20000009400ULL, 0x00000001aaaa5812ULL, 0x004fce00078efcffULL,
0x0000004300c17306ULL, 0x000ea20000005400ULL, 0x0000008fc200720bULL, 0x000fce0003fbd000ULL,
0x0000004300907306ULL, 0x00066c000000d400ULL, 0x0000000192925812ULL, 0x000fe400078efcffULL,
0x000000cecf00720bULL, 0x000fe20003fbd000ULL, 0x0001000043437824ULL, 0x008fe200078e00ffULL,
0x0000007700dd7306ULL, 0x000fe80000209400ULL, 0x00000018ff797819ULL, 0x000fe20000011443ULL,
0x0000003744448231ULL, 0x002fc400003400ffULL, 0x0000003746468231ULL, 0x000fe200003400ffULL,
0x0000007900d27306ULL, 0x000fe20000209400ULL, 0x0000003845458231ULL, 0x080fe400003400ffULL,
0x0000000195955812ULL, 0x000fe200078efcffULL, 0x0000003847478231ULL, 0x000fe200003400ffULL,
0x000000cbcc00720bULL, 0x000fe40003f1d000ULL, 0x000000bfbc00720bULL, 0x000fe20003fbd000ULL,
0x0000007900437306ULL, 0x000e700000205400ULL, 0x00000079008a7306ULL, 0x000fe4000020d400ULL,
0x0000000194940812ULL, 0x000fc400078efcffULL, 0x000000c19600720bULL, 0x004fe40003f1d000ULL,
0x000000018b8b5812ULL, 0x000fe400078efcffULL, 0x000000d5d400720bULL, 0x000fe20003fbd000ULL,
0x0000007700dc7306ULL, 0x000ea20000205400ULL, 0x000000919494723eULL, 0x000fce00000010ffULL,
0x0000000190900812ULL, 0x000fe200078efcffULL, 0x0000007700817306ULL, 0x000ee2000020d400ULL,
0x00000043d200720bULL, 0x002fe40003f1d000ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x000000babd00720bULL, 0x000fe40003fbd000ULL, 0x000000dcdd00720bULL, 0x004fe20003fdd000ULL,
0x0000007800df7306ULL, 0x000fe20000209400ULL, 0x000000909595723eULL, 0x000fca00000010ffULL,
0x000000018a8a0812ULL, 0x000fe400078efcffULL, 0x000000b8bb00720bULL, 0x000fe20003f1d000ULL,
0x0000007800de7306ULL, 0x000e620000205400ULL, 0x000000017a7a5812ULL, 0x000fe200078efcffULL,
0x000000944418723cULL, 0x000f620000041818ULL, 0x000000dadb00720bULL, 0x000fe40003fbd000ULL,
0x0000000181816812ULL, 0x008fe400078efcffULL, 0x000000b1b000720bULL, 0x000fe20003fdd000ULL,
0x0000004900a97306ULL, 0x000fe80000009400ULL, 0x0000000182820812ULL, 0x000fc400078efcffULL,
0x000000d8d900720bULL, 0x000fe40003f1d000ULL, 0x0000000180805812ULL, 0x000fe200078efcffULL,
0x00000049009c7306ULL, 0x000fe20000005400ULL, 0x000000b7b200720bULL, 0x000fe40003fbd000ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000828982723eULL, 0x000fc600000010ffULL,
0x00000049003b7306ULL, 0x0005e4000000d400ULL, 0x0000000186860812ULL, 0x000fe400078efcffULL,
0x000000b9b600720bULL, 0x000fe40003f1d000ULL, 0x0000000176765812ULL, 0x000fe400078efcffULL,
0x0000007800797306ULL, 0x000ee2000020d400ULL, 0x0001000049497824ULL, 0x004fe200078e00ffULL,
0x000000e1e000720bULL, 0x000fc40003fbd000ULL, 0x000000867d86723eULL, 0x000fe400000010ffULL,
0x00000018ff407819ULL, 0x000fe40000011449ULL, 0x0000005d00ad7306ULL, 0x000fe20000209400ULL,
0x0000000175750812ULL, 0x000fe400078efcffULL, 0x000000dedf00720bULL, 0x002fc80003f1d000ULL,
0x000000017e7e5812ULL, 0x000fe200078efcffULL, 0x0000005d00ac7306ULL, 0x000e700000205400ULL,
0x000000e600e37306ULL, 0x000fe20000209400ULL, 0x0000000179790812ULL, 0x008fc400078efcffULL,
0x000000aeb300720bULL, 0x000fca0003f1d000ULL, 0x000000e600e27306ULL, 0x000ea20000205400ULL,
0x000000acad00720bULL, 0x002fce0003fbd000ULL, 0x0000004800a07306ULL, 0x000fe20000009400ULL,
0x0000000173730812ULL, 0x000fce00078efcffULL, 0x0000004800a37306ULL, 0x000fe20000005400ULL,
0x000000e2e300720bULL, 0x004fce0003fdd000ULL, 0x00000048006f7306ULL, 0x0003f0000000d400ULL,
0x0000004000c67306ULL, 0x000fe20000209400ULL, 0x0001000048487824ULL, 0x002fca00078e00ffULL,
0x00000018ffd07819ULL, 0x000fe40000011448ULL, 0x0000004000497306ULL, 0x000ff00000205400ULL,
0x00000040008f7306ULL, 0x0003f0000020d400ULL, 0x0000004a00a67306ULL, 0x000fe20000009400ULL,
0x000001004b407824ULL, 0x002fca00078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011440ULL,
0x0000004a009f7306ULL, 0x000ff00000005400ULL, 0x0000004a00637306ULL, 0x0003f0000000d400ULL,
0x0000005d00707306ULL, 0x0004e2000020d400ULL, 0x000100004a4a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe4000001144aULL, 0x000000e600777306ULL, 0x000e62000020d400ULL,
0x00000018ff5d7819ULL, 0x004fce000001144bULL, 0x000000e700e57306ULL, 0x000fe20000209400ULL,
0x0000000170705812ULL, 0x008fce00078efcffULL, 0x000000e700e47306ULL, 0x000ea20000205400ULL,
0x0000000177776812ULL, 0x002fe400078efcffULL, 0x000000a3a000720bULL, 0x000fe40003fdd000ULL,
0x000000777077723eULL, 0x000fc600000010ffULL, 0x000000d000c77306ULL, 0x000ff00000209400ULL,
0x000000d000487306ULL, 0x000e620000205400ULL, 0x000000e4e500720bULL, 0x004fe40003f1d000ULL,
0x000000016f6f6812ULL, 0x000fca00078efcffULL, 0x0000004000b87306ULL, 0x000ff00000209400ULL,
0x0000004000bb7306ULL, 0x000fe20000205400ULL, 0x00000048c700720bULL, 0x002fe40003fbd000ULL,
0x0000991093487816ULL, 0x000fca00000000ffULL, 0x00000040004a7306ULL, 0x0003f0000020d400ULL,
0x000000e700787306ULL, 0x000ea2000020d400ULL, 0x000001003c407824ULL, 0x002fca00078e00ffULL,
0x00000018ffb67819ULL, 0x000fe20000011440ULL, 0x000001003d407824ULL, 0x000fe200078e00ffULL,
0x000000d0007f7306ULL, 0x000e68000020d400ULL, 0x00000018ffae7819ULL, 0x000fc80000011440ULL,
0x000000ca00c47306ULL, 0x000fe20000209400ULL, 0x0000000178780812ULL, 0x004fe400078efcffULL,
0x000000a1a800720bULL, 0x000fe40003f1d000ULL, 0x0000006f7878723eULL, 0x000fc600000010ffULL,
0x000000ca00cd7306ULL, 0x000ea20000205400ULL, 0x000000017f7f5812ULL, 0x002fe400078efcffULL,
0x0000009ca900720bULL, 0x000fca0003fbd000ULL, 0x0000004100c27306ULL, 0x000fe20000209400ULL,
0x000000016c6c0812ULL, 0x000fe400078efcffULL, 0x000000ff4800720cULL, 0x000fe40003f05270ULL,
0x000000a4ab48723eULL, 0x000fe400000010ffULL, 0x0000007f6c6c723eULL, 0x000fe200000010ffULL,
0x0000004100c37306ULL, 0x000fe20000205400ULL, 0x000000cdc400720bULL, 0x004fe40003fdd000ULL,
0x000000013b3b5812ULL, 0x000fc400078efcffULL, 0x000000a2a700720bULL, 0x000fc60003fbd000ULL,
0x0000004100967306ULL, 0x000ff0000020d400ULL, 0x0000004200bc7306ULL, 0x000fe40000209400ULL,
0x000000015c5c5812ULL, 0x000fcc00078efcffULL, 0x0000004200bf7306ULL, 0x000e700000205400ULL,
0x0000004200af7306ULL, 0x0004f0000020d400ULL, 0x000000ca00887306ULL, 0x000ee2000020d400ULL,
0x012000003a40783bULL, 0x004ea20000000200ULL, 0x000000bfbc00720bULL, 0x002fcc0003fbd000ULL,
0x0000004b00a57306ULL, 0x000fee0000009400ULL, 0x00000001afaf5812ULL, 0x008fe200078efcffULL,
0x0000004b009e7306ULL, 0x000e620000005400ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x00000049c600720bULL, 0x000fc40003fdd000ULL, 0x000000999a00720bULL, 0x000fe40003fbd000ULL,
0x0000009baa49723eULL, 0x000fe200000010ffULL, 0x0000004b00627306ULL, 0x0007ec000000d400ULL,
0x000000484420723cULL, 0x000f640000041820ULL, 0x000000018f8f6812ULL, 0x000fe200078efcffULL,
0x000100004b4b7824ULL, 0x008fe200078e00ffULL, 0x0000009fa600720bULL, 0x000fe20003fdd000ULL,
0x0000005d008d7306ULL, 0x000fe20000209400ULL, 0x0000000169695812ULL, 0x000fc400078efcffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000003740408231ULL, 0x084fe400003400ffULL,
0x0000003742428231ULL, 0x000fe400003400ffULL, 0x0000005d008c7306ULL, 0x000ea20000205400ULL,
0x0000003841418231ULL, 0x080fe400003400ffULL, 0x0000003843438231ULL, 0x000fe200003400ffULL,
0x000000c3c200720bULL, 0x000fe40003f1d000ULL, 0x0000000163636812ULL, 0x000fc400078efcffULL,
0x0000004b00b47306ULL, 0x000fe20000209400ULL, 0x000000bbb800720bULL, 0x000fce0003fdd000ULL,
0x0000004b00b57306ULL, 0x000ee20000205400ULL, 0x0000000196960812ULL, 0x000fe400078efcffULL,
0x0000009ea500720bULL, 0x002fe40003f1d000ULL, 0x000000639696723eULL, 0x000fe400000010ffULL,
0x000000014a4a6812ULL, 0x000fe200078efcffULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x0000008c8d00720bULL, 0x004fce0003fdd000ULL, 0x000000b600b07306ULL, 0x000e620000205400ULL,
0x0000000162620812ULL, 0x000fe400078efcffULL, 0x000000b5b400720bULL, 0x008fca0003f1d000ULL,
0x0000003c00857306ULL, 0x000ff00000009400ULL, 0x0000003c00847306ULL, 0x000fe20000005400ULL,
0x000000b0b700720bULL, 0x002fce0003fbd000ULL, 0x0000003c00687306ULL, 0x0003f0000000d400ULL,
0x0000004b00b27306ULL, 0x000ea2000020d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005d005f7306ULL, 0x000e70000020d400ULL,
0x000000b6004b7306ULL, 0x000ee2000020d400ULL, 0x00000001b2b20812ULL, 0x004fc400078efcffULL,
0x000000848500720bULL, 0x000fca0003f1d000ULL, 0x0000003d007b7306ULL, 0x000fe20000009400ULL,
0x000000015f5f6812ULL, 0x002fce00078efcffULL, 0x0000003d007c7306ULL, 0x000e620000005400ULL,
0x000000014b4b5812ULL, 0x008fe400078efcffULL, 0x0000000168680812ULL, 0x000fc800078efcffULL,
0x000000684b68723eULL, 0x000fe200000010ffULL, 0x000000ae00ac7306ULL, 0x000ff00000209400ULL,
0x000000ae00ad7306ULL, 0x000ea20000205400ULL, 0x0000007c7b00720bULL, 0x002fce0003fdd000ULL,
0x0000003d005e7306ULL, 0x0002f0000000d400ULL, 0x0000003c00a17306ULL, 0x000fe20000209400ULL,
0x000100003d3d7824ULL, 0x002fe200078e00ffULL, 0x000000adac00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00a87306ULL, 0x000e620000205400ULL,
0x000000015e5e6812ULL, 0x008fce00078efcffULL, 0x0000003c009c7306ULL, 0x0004f0000020d400ULL,
0x0000003d00937306ULL, 0x000fe20000209400ULL, 0x000001003e3c7824ULL, 0x004fe200078e00ffULL,
0x000000a8a100720bULL, 0x002fc80003f1d000ULL, 0x00000018ff9e7819ULL, 0x000fe4000001143cULL,
0x0000003d00a27306ULL, 0x000e620000205400ULL, 0x0000009d983c723eULL, 0x000fcc00000010ffULL,
0x000000019c9c0812ULL, 0x008fe200078efcffULL, 0x0000003d00a07306ULL, 0x0005e2000020d400ULL,
0x0000006d6e00720bULL, 0x000fe40003f1d000ULL, 0x0000008f5c6d723eULL, 0x000fca00000010ffULL,
0x000000ae00a37306ULL, 0x000ee2000020d400ULL, 0x00000097923d723eULL, 0x004fe400000010ffULL,
0x000000a29300720bULL, 0x002fe40003fdd000ULL, 0x00000062af97723eULL, 0x000fe400000010ffULL,
0x000000015b5b0812ULL, 0x000fe200078efcffULL, 0x0000006600717306ULL, 0x000fe20000209400ULL,
0x0000003c441c723cULL, 0x000b6e000004181cULL, 0x0000006600747306ULL, 0x000e620000205400ULL,
0x000001003f3d7824ULL, 0x020fe200078e00ffULL, 0x0000008e8b3c723eULL, 0x000fe200000010ffULL,
0x000000964018723cULL, 0x000fe20000041818ULL, 0x00000001a3a35812ULL, 0x008fc400078efcffULL,
0x00000018ff8b7819ULL, 0x000fe4000001143dULL, 0x0000008a833d723eULL, 0x000fe200000010ffULL,
0x0000006600657306ULL, 0x000ea2000020d400ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x0000007a8783723eULL, 0x000fe400000010ffULL, 0x000000807587723eULL, 0x000fe200000010ffULL,
0x0000003c4414723cULL, 0x000be20000041814ULL, 0x000000747100720bULL, 0x002fe20003fbd000ULL,
0x0000003e004e7306ULL, 0x000fe20000009400ULL, 0x000000a05b9d723eULL, 0x000fc800000010ffULL,
0x00000076813c723eULL, 0x020fe200000010ffULL, 0x000000824410723cULL, 0x040fe20000041810ULL,
0x00000072793d723eULL, 0x000fe200000010ffULL, 0x0000003e006b7306ULL, 0x000e620000005400ULL,
0x0000007e7376723eULL, 0x000fe400000010ffULL, 0x0000003b8879723eULL, 0x000fe400000010ffULL,
0x0000000165655812ULL, 0x004fe200078efcffULL, 0x0000003c4408723cULL, 0x000be40000041808ULL,
0x0000009e009b7306ULL, 0x000fe20000209400ULL, 0x0000009c659c723eULL, 0x000fc800000010ffULL,
0x000000b25f3d723eULL, 0x020fe200000010ffULL, 0x00000086440c723cULL, 0x000f64000004180cULL,
0x0000009e00487306ULL, 0x000ea20000205400ULL, 0x0000006b4e00720bULL, 0x002fca0003fbd000ULL,
0x000000764404723cULL, 0x000f640000041804ULL, 0x0000003e005a7306ULL, 0x0002ec000000d400ULL,
0x000000784020723cULL, 0x000f640000041820ULL, 0x0000009e00497306ULL, 0x000ee2000020d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000489b00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000006c401c723cULL, 0x000f62000004181cULL,
0x0000003f00617306ULL, 0x000fe20000009400ULL, 0x000000015a5a5812ULL, 0x008fcc00078efcffULL,
0x0000009c400c723cULL, 0x020f62000004180cULL, 0x0000003f006a7306ULL, 0x000e620000005400ULL,
0x0000000149496812ULL, 0x000fc800078efcffULL, 0x0000005a495a723eULL, 0x000fc600000010ffULL,
0x0000008b008a7306ULL, 0x000ff00000209400ULL, 0x0000008b007b7306ULL, 0x000ea20000205400ULL,
0x0000006a6100720bULL, 0x002fce0003fdd000ULL, 0x0000003e00717306ULL, 0x000ff00000209400ULL,
0x0000003e003c7306ULL, 0x000e620000205400ULL, 0x0000007b8a00720bULL, 0x004fce0003f1d000ULL,
0x0000003f00517306ULL, 0x0004f0000000d400ULL, 0x0000008b007a7306ULL, 0x000ee2000020d400ULL,
0x000100003f3f7824ULL, 0x004fe200078e00ffULL, 0x0000003c7100720bULL, 0x002fc40003fbd000ULL,
0x0000004a693c723eULL, 0x000fe400000010ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000003e003b7306ULL, 0x000e62000020d400ULL, 0x0000000151516812ULL, 0x008fe400078efcffULL,
0x0000005ea369723eULL, 0x000fe200000010ffULL, 0x0000003c4014723cULL, 0x000b680000041814ULL,
0x00000067005d7306ULL, 0x000fe20000209400ULL, 0x000000017a7a0812ULL, 0x000fc400078efcffULL,
0x0000004f6000720bULL, 0x000fe20003f1d000ULL, 0x000000684010723cULL, 0x000b620000041810ULL,
0x000000517a5b723eULL, 0x000fe400000010ffULL, 0x000176c8343c7811ULL, 0x020fe200078e18ffULL,
0x0000006700667306ULL, 0x000ea20000205400ULL, 0x000000013b3b5812ULL, 0x002fc600078efcffULL,
0x0000005a4008723cULL, 0x000b680000041808ULL, 0x0000003f00447306ULL, 0x000fe20000209400ULL,
0x0000000164640812ULL, 0x000fc800078efcffULL, 0x0000003b6464723eULL, 0x000fc600000010ffULL,
0x0000003f00457306ULL, 0x000e620000205400ULL, 0x000000665d00720bULL, 0x004fce0003fdd000ULL,
0x00000067003e7306ULL, 0x000eb0000020d400ULL, 0x0000003f003f7306ULL, 0x000ee2000020d400ULL,
0x000000454400720bULL, 0x002fe40003fbd000ULL, 0x000000013e3e6812ULL, 0x004fd600078efcffULL,
0x000000013f3f5812ULL, 0x008fc800078efcffULL, 0x0000003f3e65723eULL, 0x000fce00000010ffULL,
0x000000644004723cULL, 0x000b620000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000003c3c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c02d3c7811ULL, 0x002fe200078e40ffULL,
0x0176980053ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff407224ULL, 0x020fe200078e003dULL,
0x000000032c5b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e0029ULL,
0x000000033c00720cULL, 0x000fe20003f06070ULL, 0x000000ffff5f7224ULL, 0x000fe400078e0052ULL,
0x000000ffff5d7224ULL, 0x000fd400078e0059ULL, 0x000035e000000947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x002fc40000015200ULL, 0x000004002a297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804840ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fcc0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff297819ULL, 0x000fc8000001143fULL, 0x0000003e29297211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x0000000229297819ULL, 0x000fc8000000123eULL,
0x000000290000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004002a297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe40007804840ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000022d3b7810ULL, 0x040fe20007ffe0ffULL,
0x000001002d297824ULL, 0x000fe400078e0232ULL, 0x00005800302a7a24ULL, 0x010fe200078e02ffULL,
0x000000003b00720cULL, 0x000fe40003f06070ULL, 0x0000010029307810ULL, 0x000fe20007ffe0ffULL,
0x000000402a437824ULL, 0x000fc600078e00ffULL, 0x0000002031407812ULL, 0x000fce00078ef830ULL,
0x0000048000008947ULL, 0x000fea0003800000ULL, 0x0000001025297824ULL, 0x000fe200078e00ffULL,
0x00000003ff417819ULL, 0x000fe20000011633ULL, 0x00000010333d7824ULL, 0x000fc600078e00ffULL,
0x0000001029427812ULL, 0x000fe400078ec0ffULL, 0x0000003003297217ULL, 0x000fe40007800000ULL,
0x0000000441447810ULL, 0x040fe20007ffe0ffULL, 0x00000001413e7824ULL, 0x000fe200078e0242ULL,
0x000000703d497812ULL, 0x000fe200078ec0ffULL, 0x0000000129297824ULL, 0x000fe400078e0a30ULL,
0x000000013e2a7824ULL, 0x000fe400078e0240ULL, 0x0000000144457824ULL, 0x000fe200078e0242ULL,
0x0000002942297217ULL, 0x000fc40007800000ULL, 0x0000002a432a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000845477824ULL, 0x000fe400078e00ffULL, 0x0000000129297824ULL, 0x000fe400078e0a42ULL,
0x000000ffff3b7224ULL, 0x000fe200000e06ffULL, 0x00005e002a3c7a11ULL, 0x000fc800078038ffULL,
0x00005f002a307a11ULL, 0x000fe200000f3c3bULL, 0x00000001452a7824ULL, 0x000fe200078e0240ULL,
0x000000493c3c7210ULL, 0x000fe20007fbe0ffULL, 0x000000013e3b7824ULL, 0x140fe200078e0233ULL,
0x000000294100720cULL, 0x080fe20003f06070ULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0x0000002a432a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200028e0630ULL,
0x000000294400720cULL, 0x000fe20003fa6070ULL, 0x0000000145307824ULL, 0x000fe200078e0233ULL,
0xfffffff83e3b7812ULL, 0x000fe200078ee23bULL, 0x000000ffff3f7224ULL, 0x000fe200030e06ffULL,
0x0000000841447810ULL, 0x000fc40007ffe0ffULL, 0x00005e002a3e7a11ULL, 0x000fe200078c38ffULL,
0x000000103b3b7824ULL, 0x000fe200078e0250ULL, 0x0000000c41457810ULL, 0x000fe20007ffe0ffULL,
0x0000000144467824ULL, 0x000fe200078e0242ULL, 0x00005f002a3f7a11ULL, 0x000fe400030f3c3fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3b7faeULL, 0x0003e2000c101c46ULL,
0x00000001462a7824ULL, 0x000fe200078e0240ULL, 0x000000493e3e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000145427824ULL, 0x000fe200078e0242ULL, 0xfffffff847417812ULL, 0x000fc400078ee230ULL,
0x0000002a43307210ULL, 0x000fe20007fde0ffULL, 0x00000001422a7824ULL, 0x000fe400078e0240ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063fULL, 0x000000294400720cULL, 0x000fe20003f06070ULL,
0x00000010413b7824ULL, 0x002fe400078e0250ULL, 0x000000ffff3d7224ULL, 0x000fe200030e06ffULL,
0x0000002a432a7210ULL, 0x000fe40007fde0ffULL, 0x000000003e3b7faeULL, 0x0003e2000e901c46ULL,
0x00005e00303c7a11ULL, 0x000fc400078a38ffULL, 0x000000ffff417224ULL, 0x000fe400030e06ffULL,
0x00005f0030307a11ULL, 0x000fe400028f3c3dULL, 0x000000493c3c7210ULL, 0x000fe40007fde0ffULL,
0x000000294500720cULL, 0x000fe20003fa6070ULL, 0x0000000146297824ULL, 0x140fe400078e0233ULL,
0x0000000846467824ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0630ULL,
0x00005e002a3e7a11ULL, 0x002fe200078c38ffULL, 0x0000000142307824ULL, 0x000fe200078e0233ULL,
0xfffffff846297812ULL, 0x000fe200078ee229ULL, 0x00000008423b7824ULL, 0x000fe200078e00ffULL,
0x00005f002a2a7a11ULL, 0x000fc400030f3c41ULL, 0x000000493e3e7210ULL, 0x000fe20007fde0ffULL,
0x0000001029297824ULL, 0x000fe200078e0250ULL, 0xfffffff83b3b7812ULL, 0x000fc600078ee230ULL,
0x000000ffff3f7224ULL, 0x000fe200030e062aULL, 0x000000003c297faeULL, 0x0003e2000c101c46ULL,
0x000000103b3b7824ULL, 0x000fca00078e0250ULL, 0x000000003e3b7faeULL, 0x0003e2000e901c46ULL,
0x000003b000007947ULL, 0x000fea0003800000ULL, 0x0000001025297824ULL, 0x000fe400078e00ffULL,
0x0000001033497824ULL, 0x000fc600078e00ffULL, 0x00000010292a7812ULL, 0x000fe400078ec0ffULL,
0x0000007049497812ULL, 0x000fe400078ec0ffULL, 0x0000002a33307211ULL, 0x000fc800078fe8ffULL,
0x00000004303b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000130297824ULL, 0x040fe200078e0240ULL,
0x0000000c30427810ULL, 0x040fe20007ffe0ffULL, 0x00000001302a7824ULL, 0x140fe400078e0233ULL,
0x0000000830457824ULL, 0x000fe200078e00ffULL, 0x0000002943417210ULL, 0x000fe20007f1e0ffULL,
0x000000013b3c7824ULL, 0x040fe400078e0233ULL, 0x000000083b477824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee22aULL, 0x000000ffff2a7224ULL, 0x000fe200000e06ffULL,
0x00005e00413d7a11ULL, 0x000fe200078038ffULL, 0x000000013b297824ULL, 0x000fe200078e0240ULL,
0xfffffff847477812ULL, 0x000fe200078ee23cULL, 0x00000008424b7824ULL, 0x000fe200078e00ffULL,
0x00000008303c7810ULL, 0x000fc40007ffe0ffULL, 0x00005f0041417a11ULL, 0x000fe400000f3c2aULL,
0x00000029433f7210ULL, 0x040fe20007f1e0ffULL, 0x000000013c2a7824ULL, 0x100fe400078e0240ULL,
0x0000000142297824ULL, 0x000fe400078e0240ULL, 0x000000013c3b7824ULL, 0x040fe200078e0233ULL,
0x0000002a43307210ULL, 0x040fe20007fbe0ffULL, 0x000000083c407824ULL, 0x000fe200078e00ffULL,
0x0000002943297210ULL, 0x000fe20007fde0ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x00005e003f3e7a11ULL, 0x000fc400078038ffULL, 0xfffffff840437812ULL, 0x000fe200078ee23bULL,
0x000000ffff3b7224ULL, 0x000fe200028e06ffULL, 0x00005f003f3f7a11ULL, 0x000fe200000f3c3cULL,
0x00000001423c7824ULL, 0x000fe200078e0233ULL, 0x00005e0030407a11ULL, 0x040fe200078038ffULL,
0x000000ffff2a7224ULL, 0x000fe200030e06ffULL, 0x00005e0029427a11ULL, 0x000fe400078a38ffULL,
0xfffffff84b4b7812ULL, 0x000fe400078ee23cULL, 0x00005f0030307a11ULL, 0x000fe200000f3c3bULL,
0x00000010473b7824ULL, 0x000fe200078e0250ULL, 0x00005f00292a7a11ULL, 0x000fe200028f3c2aULL,
0x0000001045297824ULL, 0x100fe200078e0250ULL, 0x000000493d3c7210ULL, 0x080fe20007f1e0ffULL,
0x0000001043457824ULL, 0x100fe200078e0250ULL, 0x000000493e3e7210ULL, 0x000fe20007fbe0ffULL,
0x000000104b477824ULL, 0x000fc400078e0250ULL, 0x000000ffff3d7224ULL, 0x000fe200000e0641ULL,
0x0000004940407210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e063fULL,
0x0000004942427210ULL, 0x000fe40007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c297faeULL, 0x0003e2000b901c46ULL, 0x000000ffff417224ULL, 0x000fe400000e0630ULL,
0x000000ffff437224ULL, 0x000fe200028e062aULL, 0x000000003e3b7faeULL, 0x0003e8000b901c46ULL,
0x0000000040457faeULL, 0x0003e8000b901c46ULL, 0x0000000042477faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000042c3c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff307424ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x000000023c00720cULL, 0x000fda0003fa6070ULL, 0x0000004000005947ULL, 0x000fea0003800000ULL,
0x000000012f3c7824ULL, 0x000fe400078e023cULL, 0x00000004ff3d7424ULL, 0x000fc800078e00ffULL,
0x000060003c3c7625ULL, 0x000fca00078e003dULL, 0x000000063c307981ULL, 0x000324000c1e1900ULL,
0x0000009000007945ULL, 0x000fe40003800000ULL, 0x00000000550403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a800545c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176680026407f8cULL, 0x0002a4000c80043fULL, 0x00000000003c7805ULL, 0x002fc40000015200ULL,
0x01766c0026297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x006fe40007804841ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c2a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3e7824ULL, 0x000fe200000e0e3dULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff297819ULL, 0x000fc8000001143eULL,
0x0000002a29297211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e063eULL,
0x0000000229297819ULL, 0x000fc8000000122aULL, 0x000000290000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c0026297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018049277810ULL, 0x000fca0007ffe027ULL, 0x0000000124277824ULL, 0x000fca00078e0227ULL,
0x0170000027297984ULL, 0x000e680000000800ULL, 0x0172000027267984ULL, 0x0004e20000000800ULL,
0x000000522900720bULL, 0x002fe20003f1d000ULL, 0x0000ba727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000277806ULL, 0x004fc800000e0100ULL, 0x0000ffff27ff7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff5f7224ULL, 0x000fd200078e0052ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x00000003362a7810ULL, 0x000fe40007ffe0ffULL, 0x000000522900720bULL, 0x000fe40003f14000ULL,
0x000000252a00720cULL, 0x000fe20003fa5270ULL, 0x0000ba327f007947ULL, 0x000fd4000b800000ULL,
0x00000000002a7806ULL, 0x000fc400000e0100ULL, 0x000000802549d824ULL, 0x000fe200078e0249ULL,
0x00000052295f7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x00000001243cd824ULL, 0x000fe200078e0249ULL, 0x000099102a247816ULL, 0x000fc800000000ffULL,
0x0174005f3c00d388ULL, 0x0003e20000000800ULL, 0x000000ff2400720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000525f247221ULL, 0x002fe20000010100ULL,
0x000000ff2aff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL, 0x00000024003b7308ULL, 0x000e640000000800ULL,
0x0000003b2e2e7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff447819ULL, 0x000fe20000011633ULL, 0x0000b9727f007947ULL, 0x000fea000b800000ULL,
0x00001f443b247589ULL, 0x0002a400000e0000ULL, 0x0000002420207220ULL, 0x084fe40000410000ULL,
0x0000002421217220ULL, 0x080fe40000410000ULL, 0x000000241c1c7220ULL, 0x080fe40000410000ULL,
0x000000241d1d7220ULL, 0x080fe40000410000ULL, 0x0000002418187220ULL, 0x080fe40000410000ULL,
0x0000002419197220ULL, 0x000fc40000410000ULL, 0x0000002414147220ULL, 0x080fe40000410000ULL,
0x0000002415157220ULL, 0x080fe40000410000ULL, 0x0000002410107220ULL, 0x080fe40000410000ULL,
0x0000002411117220ULL, 0x080fe40000410000ULL, 0x000000240c0c7220ULL, 0x080fe40000410000ULL,
0x000000240d0d7220ULL, 0x000fc40000410000ULL, 0x0000002408087220ULL, 0x080fe40000410000ULL,
0x0000002409097220ULL, 0x080fe40000410000ULL, 0x0000002404047220ULL, 0x080fe40000410000ULL,
0x0000002405057220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff002aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000833447811ULL, 0x002fe200078ff0ffULL, 0x0000b8827f007947ULL, 0x000fea000b800000ULL,
0x00001f443b247589ULL, 0x0002a400000e0000ULL, 0x0000002422227220ULL, 0x084fe40000410000ULL,
0x0000002423237220ULL, 0x080fe40000410000ULL, 0x000000241e1e7220ULL, 0x080fe40000410000ULL,
0x000000241f1f7220ULL, 0x080fe40000410000ULL, 0x000000241a1a7220ULL, 0x080fe40000410000ULL,
0x000000241b1b7220ULL, 0x000fc40000410000ULL, 0x0000002416167220ULL, 0x080fe40000410000ULL,
0x0000002417177220ULL, 0x080fe40000410000ULL, 0x0000002412127220ULL, 0x080fe40000410000ULL,
0x0000002413137220ULL, 0x080fe40000410000ULL, 0x000000240e0e7220ULL, 0x080fe40000410000ULL,
0x000000240f0f7220ULL, 0x000fc40000410000ULL, 0x000000240a0a7220ULL, 0x080fe40000410000ULL,
0x000000240b0b7220ULL, 0x080fe40000410000ULL, 0x0000002406067220ULL, 0x080fe40000410000ULL,
0x0000002407077220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2aff7812ULL, 0x000fe20007800827ULL, 0x00000001ff2a7424ULL, 0x000fd800078e00ffULL,
0x000000295f290221ULL, 0x000fe20000010100ULL, 0x00007610ff2a0816ULL, 0x000fc6000000002aULL,
0x3fb8aa3b29290820ULL, 0x000fc80000410000ULL, 0x0000002900350308ULL, 0x000e640000000800ULL,
0x0000003526260220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002e262e7221ULL, 0x008fc40000010000ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x0176ac0028297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c26297210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3c7824ULL, 0x000fe200000e0e27ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff3c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff3c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc8000001143cULL,
0x0000002924247211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e063cULL,
0x0000000224247819ULL, 0x000fc80000001229ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0028297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099102a247816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000035ff24723eULL, 0x000fe400000010ffULL, 0x00000002ff277819ULL, 0x000fe40000011633ULL,
0x0000541024247816ULL, 0x000fe20000000024ULL, 0x0000b4927f007947ULL, 0x000fea000b800000ULL,
0x00001f2724377589ULL, 0x0002a400000e0000ULL, 0x0000000827447810ULL, 0x002fe20007ffe0ffULL,
0x0000b4e27f007947ULL, 0x000fea000b800000ULL, 0x00001f4424387589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001027447810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200078e0024ULL, 0x0000d370003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000ba7000007944ULL, 0x01cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001827447810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x004fe200078e0024ULL,
0x0000d3e0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000ba0000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004d40783bULL, 0x004ea80000004200ULL, 0x000000005644783bULL, 0x002e680000004200ULL,
0x000000005748783bULL, 0x000ee80000004200ULL, 0x000000004c3c783bULL, 0x000ee20000004200ULL,
0x0000010040877824ULL, 0x004fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011441ULL,
0x0000004000907306ULL, 0x000fe20000009400ULL, 0x00000018ff527819ULL, 0x000fe20000011442ULL,
0x0000010043917824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011487ULL,
0x0000010044bf7824ULL, 0x002fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fc40000011440ULL,
0x00000018ff557819ULL, 0x008fe2000001144aULL, 0x0000004000a17306ULL, 0x000e620000005400ULL,
0x00000018ffba7819ULL, 0x000fe40000011491ULL, 0x00000018ff887819ULL, 0x000fe4000001143dULL,
0x00000018ff897819ULL, 0x000fe4000001143eULL, 0x00000018ff547819ULL, 0x000fe20000011443ULL,
0x0000005100b27306ULL, 0x000fe20000209400ULL, 0x00000018ffbf7819ULL, 0x000fc400000114bfULL,
0x00000018ff597819ULL, 0x000fe4000001143cULL, 0x00000018ff5a7819ULL, 0x000fc6000001143fULL,
0x0000005100b37306ULL, 0x000fe20000205400ULL, 0x000000a19000720bULL, 0x002fce0003fbd000ULL,
0x0000005100767306ULL, 0x0003f0000020d400ULL, 0x0000008700967306ULL, 0x000fe20000209400ULL,
0x00000018ff517819ULL, 0x002fce0000011445ULL, 0x0000008700a37306ULL, 0x000e700000205400ULL,
0x0000004000797306ULL, 0x0004f0000000d400ULL, 0x0000005200a77306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x004fe200078e00ffULL, 0x000000a39600720bULL, 0x002fc80003fdd000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000005200aa7306ULL, 0x000fe20000205400ULL,
0x0000000179795812ULL, 0x008fce00078efcffULL, 0x0000005200717306ULL, 0x0003f0000020d400ULL,
0x0000005100a27306ULL, 0x000fe20000209400ULL, 0x00000018ff527819ULL, 0x002fce0000011446ULL,
0x00000051009d7306ULL, 0x000ff00000205400ULL, 0x0000005100687306ULL, 0x0003f0000020d400ULL,
0x0000005000a67306ULL, 0x000fe20000209400ULL, 0x00000018ff517819ULL, 0x002fce0000011449ULL,
0x0000005000ab7306ULL, 0x000e700000205400ULL, 0x0000005000787306ULL, 0x0004f0000020d400ULL,
0x00000052009b7306ULL, 0x000fe20000209400ULL, 0x00000018ff507819ULL, 0x004fc40000011444ULL,
0x000000aba600720bULL, 0x002fca0003fbd000ULL, 0x00000052009a7306ULL, 0x000ff00000205400ULL,
0x0000005200667306ULL, 0x000fe2000020d400ULL, 0x0000000178785812ULL, 0x008fce00078efcffULL,
0x00000050009f7306ULL, 0x000ff00000209400ULL, 0x0000005000a07306ULL, 0x000ff00000205400ULL,
0x00000050006c7306ULL, 0x0003f0000020d400ULL, 0x0000005100857306ULL, 0x000fe20000209400ULL,
0x00000018ff507819ULL, 0x002fce0000011448ULL, 0x0000005100827306ULL, 0x000ff00000205400ULL,
0x0000005100527306ULL, 0x000ff0000020d400ULL, 0x0000008800617306ULL, 0x000ff00000209400ULL,
0x0000008800607306ULL, 0x000ff00000205400ULL, 0x0000008800517306ULL, 0x000ff0000020d400ULL,
0x0000008700887306ULL, 0x0002b0000020d400ULL, 0x0000004000a47306ULL, 0x000fe20000209400ULL,
0x0000010042877824ULL, 0x002fca00078e00ffULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x0000004000a97306ULL, 0x000e620000205400ULL, 0x0000000188886812ULL, 0x004fce00078efcffULL,
0x0000005000847306ULL, 0x000ff00000209400ULL, 0x0000005000837306ULL, 0x000fe20000205400ULL,
0x000000a9a400720bULL, 0x002fe20003fdd000ULL, 0x0000010046a47824ULL, 0x000fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114a4ULL, 0x00000050005c7306ULL, 0x000ff0000020d400ULL,
0x0000005500817306ULL, 0x000ff00000209400ULL, 0x0000005500807306ULL, 0x000ff00000205400ULL,
0x00000055005b7306ULL, 0x000ff0000020d400ULL, 0x0000008900557306ULL, 0x000ff00000209400ULL,
0x0000008900507306ULL, 0x000ff00000205400ULL, 0x0000008900577306ULL, 0x0003f0000020d400ULL,
0x0000004100ac7306ULL, 0x000fe20000009400ULL, 0x0000010041897824ULL, 0x002fca00078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe40000011489ULL, 0x0000004100ad7306ULL, 0x000e700000005400ULL,
0x00000040008b7306ULL, 0x000eb0000020d400ULL, 0x0000008c00ae7306ULL, 0x000fe20000209400ULL,
0x000000adac00720bULL, 0x002fce0003fbd000ULL, 0x0000008c00af7306ULL, 0x000e620000205400ULL,
0x000000018b8b6812ULL, 0x004fc800078efcffULL, 0x0000008b7878723eULL, 0x000fc600000010ffULL,
0x0000004100777306ULL, 0x0004f0000000d400ULL, 0x0000008c00947306ULL, 0x000ee2000020d400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000afae00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004200b47306ULL, 0x000fe20000009400ULL,
0x0000000177775812ULL, 0x008fe400078efcffULL, 0x000000b3b200720bULL, 0x000fca0003fbd000ULL,
0x0000004100b07306ULL, 0x000fe20000209400ULL, 0x0000000194946812ULL, 0x000fce00078efcffULL,
0x0000004100b17306ULL, 0x000e620000205400ULL, 0x0000000176765812ULL, 0x000fce00078efcffULL,
0x0000004200b57306ULL, 0x000eb00000005400ULL, 0x0000004100897306ULL, 0x000ee2000020d400ULL,
0x000000b1b000720bULL, 0x002fce0003fdd000ULL, 0x0000008700407306ULL, 0x000fe20000209400ULL,
0x000000b5b400720bULL, 0x004fce0003fbd000ULL, 0x0000008700b77306ULL, 0x000e620000205400ULL,
0x0000000189896812ULL, 0x008fce00078efcffULL, 0x0000004200757306ULL, 0x0004f0000000d400ULL,
0x0000004300b87306ULL, 0x000fe20000009400ULL, 0x000000b74000720bULL, 0x002fe20003fdd000ULL,
0x0001000042427824ULL, 0x004fc400078e00ffULL, 0x0000010047407824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000004300b97306ULL, 0x000e620000005400ULL,
0x0000000175755812ULL, 0x008fe400078efcffULL, 0x00000018ffae7819ULL, 0x000fca0000011440ULL,
0x00000087008a7306ULL, 0x000eb0000020d400ULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x000000b9b800720bULL, 0x002fce0003fbd000ULL, 0x000000ba00bc7306ULL, 0x000e620000205400ULL,
0x000000018a8a6812ULL, 0x004fc800078efcffULL, 0x000000758a8a723eULL, 0x000fc600000010ffULL,
0x0000004300747306ULL, 0x0004f0000000d400ULL, 0x000000ba00917306ULL, 0x000ee2000020d400ULL,
0x000000bcbb00720bULL, 0x002fe20003fdd000ULL, 0x0001000043437824ULL, 0x004fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000004200417306ULL, 0x000fe20000209400ULL,
0x0000000174745812ULL, 0x008fe400078efcffULL, 0x000000aaa700720bULL, 0x000fca0003fbd000ULL,
0x0000004200b67306ULL, 0x000e620000205400ULL, 0x0000000191916812ULL, 0x000fc800078efcffULL,
0x00000074918b723eULL, 0x000fc600000010ffULL, 0x0000005400a87306ULL, 0x000fe20000209400ULL,
0x0000000171715812ULL, 0x000fce00078efcffULL, 0x0000005400a57306ULL, 0x000ea20000205400ULL,
0x000000b64100720bULL, 0x002fce0003fdd000ULL, 0x00000042008c7306ULL, 0x0002f0000020d400ULL,
0x0000004300bd7306ULL, 0x000fe20000209400ULL, 0x000000a5a800720bULL, 0x004fe20003fbd000ULL,
0x0000010045427824ULL, 0x002fc400078e00ffULL, 0x0000010048a87824ULL, 0x000fc600078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011442ULL, 0x0000004300be7306ULL, 0x000e620000205400ULL,
0x000000018c8c6812ULL, 0x008fe400078efcffULL, 0x00000018ffa87819ULL, 0x000fca00000114a8ULL,
0x0000005400707306ULL, 0x0004f0000020d400ULL, 0x00000044009e7306ULL, 0x000fe20000009400ULL,
0x000000bebd00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff547819ULL, 0x004fca0000011447ULL,
0x0000004400977306ULL, 0x000e620000005400ULL, 0x0000000170705812ULL, 0x008fce00078efcffULL,
0x0000004300877306ULL, 0x000eb0000020d400ULL, 0x000000bf00ba7306ULL, 0x000fe20000209400ULL,
0x000000979e00720bULL, 0x002fce0003fbd000ULL, 0x000000bf00c17306ULL, 0x000e620000205400ULL,
0x0000000187876812ULL, 0x004fc800078efcffULL, 0x000000877087723eULL, 0x000fc600000010ffULL,
0x00000044006d7306ULL, 0x0004f0000000d400ULL, 0x0000004500987306ULL, 0x000fe20000009400ULL,
0x000000c1ba00720bULL, 0x002fe20003fdd000ULL, 0x0001000044447824ULL, 0x004fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000004500957306ULL, 0x000e620000005400ULL,
0x000000016d6d5812ULL, 0x008fce00078efcffULL, 0x000000bf00907306ULL, 0x000eb0000020d400ULL,
0x000000a300c07306ULL, 0x000fe20000209400ULL, 0x000000959800720bULL, 0x002fce0003fbd000ULL,
0x000000a300c37306ULL, 0x000e620000205400ULL, 0x0000000190906812ULL, 0x004fc800078efcffULL,
0x0000006d9090723eULL, 0x000fc600000010ffULL, 0x0000004500697306ULL, 0x0004f0000000d400ULL,
0x000000a300967306ULL, 0x000ee2000020d400ULL, 0x000000c3c000720bULL, 0x002fe20003fdd000ULL,
0x0001000045457824ULL, 0x004fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000004400427306ULL, 0x000fe20000209400ULL, 0x0000000169695812ULL, 0x008fe400078efcffULL,
0x000000a09f00720bULL, 0x000fca0003fbd000ULL, 0x0000004400437306ULL, 0x000e620000205400ULL,
0x0000000196966812ULL, 0x000fc800078efcffULL, 0x000000699691723eULL, 0x000fc600000010ffULL,
0x0000004400a17306ULL, 0x000ea2000020d400ULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x0000009da200720bULL, 0x000fca0003fbd000ULL, 0x0000004500a97306ULL, 0x000fe20000209400ULL,
0x000000434200720bULL, 0x002fe20003fdd000ULL, 0x0001000049427824ULL, 0x000fe400078e00ffULL,
0x000001004a437824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000004500ac7306ULL, 0x000e620000205400ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x00000018ff437819ULL, 0x000fc60000011443ULL, 0x00000001a1a16812ULL, 0x004fe400078efcffULL,
0x0000004600937306ULL, 0x000fe40000009400ULL, 0x000000a16c6c723eULL, 0x000fcc00000010ffULL,
0x0000004600927306ULL, 0x000ea20000005400ULL, 0x000000aca900720bULL, 0x002fce0003fdd000ULL,
0x0000004500a37306ULL, 0x000e70000020d400ULL, 0x000000ab00447306ULL, 0x000fe20000209400ULL,
0x000000929300720bULL, 0x004fce0003fbd000ULL, 0x000000ab00ad7306ULL, 0x000ea20000205400ULL,
0x00000001a3a36812ULL, 0x002fc800078efcffULL, 0x000000a3686d723eULL, 0x000fc600000010ffULL,
0x0000004600677306ULL, 0x0002f0000000d400ULL, 0x00000047008f7306ULL, 0x000fe20000009400ULL,
0x000000ad4400720bULL, 0x004fe20003fdd000ULL, 0x0001000046467824ULL, 0x002fc400078e00ffULL,
0x000001004b447824ULL, 0x000fc600078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x00000047008e7306ULL, 0x000e620000005400ULL, 0x0000000167675812ULL, 0x008fe400078efcffULL,
0x00000018ff447819ULL, 0x000fca0000011444ULL, 0x000000ab00a47306ULL, 0x000eb0000020d400ULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x0000008e8f00720bULL, 0x002fce0003fbd000ULL,
0x000000ae00b07306ULL, 0x000e620000205400ULL, 0x00000001a4a46812ULL, 0x004fce00078efcffULL,
0x0000004700637306ULL, 0x0004f0000000d400ULL, 0x000000ae00a67306ULL, 0x000ee2000020d400ULL,
0x000000b0af00720bULL, 0x002fe20003fdd000ULL, 0x0001000047477824ULL, 0x004fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000004600407306ULL, 0x000fe20000209400ULL,
0x0000000163635812ULL, 0x008fe400078efcffULL, 0x0000009a9b00720bULL, 0x000fca0003fbd000ULL,
0x0000004600457306ULL, 0x000e620000205400ULL, 0x00000001a6a66812ULL, 0x000fce00078efcffULL,
0x00000054009c7306ULL, 0x000fe20000209400ULL, 0x0000000166665812ULL, 0x000fce00078efcffULL,
0x0000005400997306ULL, 0x000ea20000205400ULL, 0x000000454000720bULL, 0x002fe20003fdd000ULL,
0x000001003c407824ULL, 0x000fcc00078e00ffULL, 0x0000004600a77306ULL, 0x000e70000020d400ULL,
0x0000004700417306ULL, 0x000fe20000209400ULL, 0x000000999c00720bULL, 0x004fe40003fbd000ULL,
0x00000018ff997819ULL, 0x000fca0000011440ULL, 0x0000004700aa7306ULL, 0x000ea20000205400ULL,
0x00000001a7a76812ULL, 0x002fc800078efcffULL, 0x000000a76666723eULL, 0x000fc600000010ffULL,
0x0000005400627306ULL, 0x0002f0000020d400ULL, 0x00000048008d7306ULL, 0x000fe20000009400ULL,
0x000000aa4100720bULL, 0x004fe40003fdd000ULL, 0x00000018ff547819ULL, 0x002fca000001144bULL,
0x0000004800867306ULL, 0x000e620000005400ULL, 0x0000000162625812ULL, 0x008fce00078efcffULL,
0x0000004700a57306ULL, 0x0004f0000020d400ULL, 0x000000a800467306ULL, 0x000fe20000209400ULL,
0x000000868d00720bULL, 0x002fe20003fbd000ULL, 0x0000010049477824ULL, 0x004fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x000000a800ab7306ULL, 0x000e620000205400ULL,
0x00000001a5a56812ULL, 0x008fce00078efcffULL, 0x00000048005e7306ULL, 0x0004f0000000d400ULL,
0x000000a800977306ULL, 0x000ee2000020d400ULL, 0x0001000048487824ULL, 0x004fe200078e00ffULL,
0x000000ab4600720bULL, 0x002fc80003fdd000ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004a007f7306ULL, 0x000fe20000009400ULL, 0x000000015e5e5812ULL, 0x008fe400078efcffULL,
0x000000838400720bULL, 0x000fca0003fbd000ULL, 0x00000048009e7306ULL, 0x000fe20000209400ULL,
0x0000000197976812ULL, 0x000fce00078efcffULL, 0x0000004800b17306ULL, 0x000e620000205400ULL,
0x000000015c5c5812ULL, 0x000fce00078efcffULL, 0x0000004a007c7306ULL, 0x000ff00000005400ULL,
0x0000004a00267306ULL, 0x0005e2000000d400ULL, 0x000000b19e00720bULL, 0x002fce0003fdd000ULL,
0x00000042009f7306ULL, 0x000fe20000209400ULL, 0x000100004a4a7824ULL, 0x004fce00078e00ffULL,
0x0000004200a07306ULL, 0x000ff00000205400ULL, 0x00000042009d7306ULL, 0x0003f0000020d400ULL,
0x00000049007e7306ULL, 0x000fe20000009400ULL, 0x00000018ff427819ULL, 0x002fce000001144aULL,
0x00000049007b7306ULL, 0x000e700000005400ULL, 0x0000004900247306ULL, 0x000eb0000000d400ULL,
0x0000004800957306ULL, 0x000ee2000020d400ULL, 0x0000007b7e00720bULL, 0x002fce0003fbd000ULL,
0x0000004700987306ULL, 0x000fec0000209400ULL, 0x0000000124245812ULL, 0x004fe400078efcffULL,
0x0000004700b37306ULL, 0x000e620000205400ULL, 0x0000000195956812ULL, 0x008fe400078efcffULL,
0x000000a09f00720bULL, 0x000fca0003fbd000ULL, 0x0000004700497306ULL, 0x000eb0000020d400ULL,
0x0000004300a27306ULL, 0x000fe20000209400ULL, 0x000000b39800720bULL, 0x002fe40003fdd000ULL,
0x000000019d9d5812ULL, 0x000fc400078efcffULL, 0x0000007c7f00720bULL, 0x000fc60003fbd000ULL,
0x0000004300a97306ULL, 0x000fec0000205400ULL, 0x0000000149496812ULL, 0x004fe400078efcffULL,
0x0000004300937306ULL, 0x000fe2000020d400ULL, 0x000000828500720bULL, 0x000fe40003fdd000ULL,
0x0000000126265812ULL, 0x000fca00078efcffULL, 0x0000004400927306ULL, 0x000fec0000209400ULL,
0x0000000152526812ULL, 0x000fe400078efcffULL, 0x0000004400ad7306ULL, 0x000e640000205400ULL,
0x0000009d529d723eULL, 0x000fcc00000010ffULL, 0x0000004400487306ULL, 0x0004f0000020d400ULL,
0x00000042008e7306ULL, 0x000fe20000209400ULL, 0x012800003944783bULL, 0x004ea20000000200ULL,
0x000000ad9200720bULL, 0x002fcc0003fdd000ULL, 0x00000042008f7306ULL, 0x000e6e0000205400ULL,
0x0000000148486812ULL, 0x008fe200078efcffULL, 0x00000042004a7306ULL, 0x0006a2000020d400ULL,
0x000000808100720bULL, 0x000fce0003fdd000ULL, 0x0000004b007d7306ULL, 0x000fe20000009400ULL,
0x012800003a40783bULL, 0x008ee20000000200ULL, 0x0000008f8e00720bULL, 0x002fc80003fbd000ULL,
0x000000015b5b6812ULL, 0x000fe400078efcffULL, 0x0000004b007a7306ULL, 0x000fee0000005400ULL,
0x000000014a4a5812ULL, 0x004fe200078efcffULL, 0x0000004b00277306ULL, 0x0003e2000000d400ULL,
0x0000003744448231ULL, 0x000fc400003400ffULL, 0x0000003746468231ULL, 0x000fe200003400ffULL,
0x0000004a5b4a723eULL, 0x000fe200000010ffULL, 0x0000003845458231ULL, 0x080fe400003400ffULL,
0x0000003847478231ULL, 0x000fe200003400ffULL, 0x0000005400737306ULL, 0x000fe20000209400ULL,
0x000100004b4b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001144bULL,
0x0000008a4418723cULL, 0x040f620000041818ULL, 0x0000005400727306ULL, 0x000e6e0000205400ULL,
0x000000904410723cULL, 0x000fe20000041810ULL, 0x0000009a009b7306ULL, 0x000fe20000209400ULL,
0x0000003740408231ULL, 0x008fc400003400ffULL, 0x0000003742428231ULL, 0x000fe400003400ffULL,
0x0000003841418231ULL, 0x080fe400003400ffULL, 0x0000003843438231ULL, 0x000fe200003400ffULL,
0x000000a9a200720bULL, 0x000fe20003f1d000ULL, 0x0000009a009c7306ULL, 0x000ea20000205400ULL,
0x000000727300720bULL, 0x002fe20003fbd000ULL, 0x0000006c440c723cULL, 0x000fec000004180cULL,
0x0000009900867306ULL, 0x000fe80000209400ULL, 0x0000000193930812ULL, 0x000fc400078efcffULL,
0x0000007a7d00720bULL, 0x000fe40003f1d000ULL, 0x0000009900ab7306ULL, 0x000e620000205400ULL,
0x000000269326723eULL, 0x000fce00000010ffULL, 0x0000009a004b7306ULL, 0x000666000020d400ULL,
0x0000000127270812ULL, 0x000fe400078efcffULL, 0x0000009c9b00720bULL, 0x004fe40003f1d000ULL,
0x000000274827723eULL, 0x000fe200000010ffULL, 0x0000005400567306ULL, 0x000ea2000020d400ULL,
0x000001003d9a7824ULL, 0x008fe200078e00ffULL, 0x000000ab8600720bULL, 0x002fc40003fdd000ULL,
0x0000008c7186723eULL, 0x000fe400000010ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x000000264018723cULL, 0x020fe20000041818ULL, 0x0000003c006f7306ULL, 0x000fe20000009400ULL,
0x000000955c9c723eULL, 0x000fe400000010ffULL, 0x000000014b4b0812ULL, 0x000fc800078efcffULL,
0x000000864414723cULL, 0x000f620000041814ULL, 0x0000003c006e7306ULL, 0x000e620000005400ULL,
0x0000000156565812ULL, 0x004fc800078efcffULL, 0x0000004b564b723eULL, 0x000fc600000010ffULL,
0x0000003d006a7306ULL, 0x000ff00000009400ULL, 0x0000003d006b7306ULL, 0x000ea20000005400ULL,
0x0000006e6f00720bULL, 0x002fcc0003f1d000ULL, 0x0000004a4014723cULL, 0x020fe20000041814ULL,
0x00000099008d7306ULL, 0x000e70000020d400ULL, 0x0000009a00837306ULL, 0x000fe20000209400ULL,
0x0000006b6a00720bULL, 0x004fce0003fbd000ULL, 0x0000009a00847306ULL, 0x000ea20000205400ULL,
0x000000018d8d6812ULL, 0x002fce00078efcffULL, 0x0000003c00287306ULL, 0x0002f0000000d400ULL,
0x0000003d00297306ULL, 0x0006e2000000d400ULL, 0x000100003c3c7824ULL, 0x002fe200078e00ffULL,
0x000000848300720bULL, 0x004fc80003fdd000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000009a00987306ULL, 0x000e62000020d400ULL, 0x000100003d3d7824ULL, 0x008fe200078e00ffULL,
0x0000000128280812ULL, 0x000fc800078efcffULL, 0x00000018ff7e7819ULL, 0x000fe2000001143dULL,
0x000001003e3d7824ULL, 0x000fe200078e00ffULL, 0x0000003c00397306ULL, 0x000fe20000209400ULL,
0x0000000129295812ULL, 0x000fe400078efcffULL, 0x000000288d28723eULL, 0x000fe400000010ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001143dULL, 0x00000077943d723eULL, 0x000fe200000010ffULL,
0x0000003c003a7306ULL, 0x000ea20000205400ULL, 0x0000000198986812ULL, 0x002fc800078efcffULL,
0x000000299829723eULL, 0x000fc600000010ffULL, 0x0000007e00827306ULL, 0x000fe80000209400ULL,
0x000000284010723cULL, 0x000fe80000041810ULL, 0x0000007e00857306ULL, 0x000e620000205400ULL,
0x0000003a3900720bULL, 0x004fce0003f1d000ULL, 0x0000005900647306ULL, 0x000ff00000209400ULL,
0x0000005900657306ULL, 0x000ea20000205400ULL, 0x000000858200720bULL, 0x002fce0003fbd000ULL,
0x0000003c007b7306ULL, 0x0002f0000020d400ULL, 0x0000007e007c7306ULL, 0x000ee2000020d400ULL,
0x00000079883c723eULL, 0x002fe400000010ffULL, 0x000000897679723eULL, 0x000fc400000010ffULL,
0x000000656400720bULL, 0x004fc60003fdd000ULL, 0x0000007a00777306ULL, 0x000fe20000209400ULL,
0x0000003c4420723cULL, 0x000be20000041820ULL, 0x000000017b7b0812ULL, 0x008fe400078efcffULL,
0x000000606100720bULL, 0x000fc80003f1d000ULL, 0x0000007a00767306ULL, 0x000e620000205400ULL,
0x000001003f3c7824ULL, 0x020fe200078e00ffULL, 0x000000017c7c5812ULL, 0x000fe200078efcffULL,
0x00000078441c723cULL, 0x000f62000004181cULL, 0x00000063a63d723eULL, 0x000fe400000010ffULL,
0x00000018ff717819ULL, 0x000fe4000001143cULL, 0x0000005900587306ULL, 0x000ea2000020d400ULL,
0x00000067a43c723eULL, 0x000fe400000010ffULL, 0x0000000151510812ULL, 0x000fc400078efcffULL,
0x000000a56267723eULL, 0x000fe400000010ffULL, 0x0000007c5151723eULL, 0x000fe200000010ffULL,
0x0000003e002a7306ULL, 0x000fe20000009400ULL, 0x000000767700720bULL, 0x002fe20003fbd000ULL,
0x0000003c4408723cULL, 0x040b6c0000041808ULL, 0x0000003e003b7306ULL, 0x000e620000005400ULL,
0x0000000158586812ULL, 0x004fe200078efcffULL, 0x000000664404723cULL, 0x000f640000041804ULL,
0x00000024493d723eULL, 0x020fc400000010ffULL, 0x0000005e973c723eULL, 0x000fe400000010ffULL,
0x0000003e004c7306ULL, 0x0004e4000000d400ULL, 0x0000009c401c723cULL, 0x040f6c000004181cULL,
0x0000007a00737306ULL, 0x000ee2000020d400ULL, 0x000100003e3e7824ULL, 0x004fe200078e00ffULL,
0x0000003b2a00720bULL, 0x002fe20003fdd000ULL, 0x0000003c4020723cULL, 0x000f660000041820ULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x0000003f004d7306ULL, 0x000fee0000009400ULL,
0x000000014c4c6812ULL, 0x008fe200078efcffULL, 0x0000003f004e7306ULL, 0x000e620000005400ULL,
0x0000000173735812ULL, 0x000fc800078efcffULL, 0x0000004c734c723eULL, 0x000fc600000010ffULL,
0x0000007100707306ULL, 0x000ff00000209400ULL, 0x0000007100697306ULL, 0x000ea20000205400ULL,
0x0000004e4d00720bULL, 0x002fce0003fbd000ULL, 0x0000003e00397306ULL, 0x000ff00000209400ULL,
0x0000003e003a7306ULL, 0x000e620000205400ULL, 0x000000697000720bULL, 0x004fce0003f1d000ULL,
0x0000003f004f7306ULL, 0x0004f0000000d400ULL, 0x0000007100687306ULL, 0x000ee2000020d400ULL,
0x000100003f3f7824ULL, 0x004fe200078e00ffULL, 0x0000003a3900720bULL, 0x002fc80003fdd000ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003e00247306ULL, 0x000e62000020d400ULL,
0x000000014f4f5812ULL, 0x008fce00078efcffULL, 0x0000005a00547306ULL, 0x000fe20000209400ULL,
0x0000000168680812ULL, 0x000fe400078efcffULL, 0x000000505500720bULL, 0x000fe40003f1d000ULL,
0x0000007b5850723eULL, 0x000fe400000010ffULL, 0x0000004f684d723eULL, 0x000fe200000010ffULL,
0x0000005a00597306ULL, 0x000ea20000205400ULL, 0x0000000124246812ULL, 0x002fc600078efcffULL,
0x00000050400c723cULL, 0x000f68000004180cULL, 0x0000003f002a7306ULL, 0x000fe20000209400ULL,
0x0000000157570812ULL, 0x000fc600078efcffULL, 0x0000004c4008723cULL, 0x000f620000041808ULL,
0x000000245726723eULL, 0x000fc600000010ffULL, 0x0000003f003b7306ULL, 0x000e620000205400ULL,
0x000000595400720bULL, 0x004fce0003fbd000ULL, 0x0000005a005a7306ULL, 0x000eb0000020d400ULL,
0x0000003f00277306ULL, 0x000ee2000020d400ULL, 0x0000003b2a00720bULL, 0x002fe40003fdd000ULL,
0x000000015a5a5812ULL, 0x004fd600078efcffULL, 0x0000000127276812ULL, 0x008fc800078efcffULL,
0x000000275a27723eULL, 0x000fce00000010ffULL, 0x000000264004723cULL, 0x000b6e0000041804ULL,
0x000176c834267811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000026267f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a00053ff7f8cULL, 0x0005e2000c80043fULL, 0x000000042c5b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff407224ULL, 0x002fe200078e0027ULL, 0x000000012b3d7812ULL, 0x000fc400078ec0ffULL,
0x000000012d2d7810ULL, 0x002fc80007ffe0ffULL, 0x000000002d00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff209000007947ULL, 0x000fea000383ffffULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x000000ffff247224ULL, 0x000fe400078e000fULL,
0x000000ffff287224ULL, 0x000fe400078e000bULL, 0x000000ffff267224ULL, 0x004fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe400078e000dULL, 0x000000ffff2c7224ULL, 0x000fe400078e0007ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0006ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0005ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0004ULL, 0x000000ffff2b7224ULL, 0x000fe400078e000aULL,
0x000000ffff297224ULL, 0x000fe400078e0008ULL, 0x000000ffff277224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000cULL, 0x000000ffff0b7224ULL, 0x000fe400078e0011ULL,
0x000000ffff097224ULL, 0x000fe200078e0010ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000002e007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000f39000047802ULL, 0x000fc40000000f00ULL,
0x0000989000007944ULL, 0x012fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002e00037308ULL, 0x000ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc8000000002eULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000ea80000000000ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x00000002ff067819ULL, 0x004fe40000011604ULL, 0x0000000807047811ULL, 0x002fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000002000207220ULL, 0x042fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x040fe40000410000ULL,
0x0000001d001d7220ULL, 0x000fc40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x040fe40000410000ULL, 0x0000001400147220ULL, 0x040fe40000410000ULL,
0x0000001500157220ULL, 0x040fe40000410000ULL, 0x0000000900097220ULL, 0x040fe40000410000ULL,
0x0000000b000b7220ULL, 0x000fc40000410000ULL, 0x0000000d000d7220ULL, 0x040fe40000410000ULL,
0x0000000f000f7220ULL, 0x040fe40000410000ULL, 0x0000002900297220ULL, 0x040fe40000410000ULL,
0x0000002600267220ULL, 0x040fe40000410000ULL, 0x0000002d002d7220ULL, 0x040fe40000410000ULL,
0x0000002a002a7220ULL, 0x000fc40000410000ULL, 0x0000002204227220ULL, 0x044fe40000410000ULL,
0x0000002304237220ULL, 0x040fe40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x000fc40000410000ULL, 0x0000001604167220ULL, 0x040fe40000410000ULL,
0x0000001704177220ULL, 0x040fe40000410000ULL, 0x0000001204127220ULL, 0x040fe40000410000ULL,
0x0000001304137220ULL, 0x040fe40000410000ULL, 0x0000002704277220ULL, 0x040fe40000410000ULL,
0x0000002404247220ULL, 0x000fc40000410000ULL, 0x0000002b042b7220ULL, 0x040fe40000410000ULL,
0x0000002804287220ULL, 0x040fe40000410000ULL, 0x0000002f042f7220ULL, 0x040fe40000410000ULL,
0x0000002c042c7220ULL, 0x000fc40000410000ULL, 0x0000000000317919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000831057811ULL, 0x044fe200078ff0ffULL,
0x0000000132327824ULL, 0x000fe200078e0231ULL, 0x0000000231007812ULL, 0x000fc400078ec0ffULL,
0x00000002ff077819ULL, 0x000fe20000011631ULL, 0x0000000805087824ULL, 0x000fe200078e00ffULL,
0x0000000500037211ULL, 0x040fe200078ff8ffULL, 0x0000100025057824ULL, 0x000fe200078e00ffULL,
0x0000000700027211ULL, 0x000fe200078ff8ffULL, 0x0000000807117824ULL, 0x040fe200078e00ffULL,
0xfffffff808087812ULL, 0x000fe200078ee203ULL, 0x0000000807037824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0x0000100005057812ULL, 0x000fc400078ee2ffULL, 0xfffffff811067812ULL, 0x000fe400078ee200ULL,
0xfffffff803007812ULL, 0x000fe200078ee202ULL, 0x0000080034037824ULL, 0x100fe200078e0205ULL,
0x0000000402047810ULL, 0x000fe20007ffe0ffULL, 0x0000001032327824ULL, 0x000fe200078e0205ULL,
0x0000000602077810ULL, 0x000fe20007ffe0ffULL, 0x0000000831027824ULL, 0x000fe200078e00ffULL,
0xfffffff8110a7812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e0203ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x00000010080e7824ULL, 0x100fe200078e0203ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x0000001006087824ULL, 0x100fe200078e0203ULL,
0x000000202100723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0x0000001c1d02723eULL, 0x000fe200000010ffULL, 0x0000000104067824ULL, 0x000fe200078e0207ULL,
0x0000000d0f04723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x0000541000107816ULL, 0x040fe20000000002ULL, 0x00000001070e7824ULL, 0x040fe200078e020eULL,
0x0000763200117816ULL, 0x000fe20000000002ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x000000181900723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x000000141502723eULL, 0x000fe200000010ffULL, 0x0000001006007388ULL, 0x0005e20000000a00ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000090b03723eULL, 0x000fc400000010ffULL,
0x0000763200077816ULL, 0x140fe40000000002ULL, 0x0000541000067816ULL, 0x004fe40000000002ULL,
0x000000292600723eULL, 0x000fe400000010ffULL, 0x0000002d2a02723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x0005e40000000a00ULL, 0x0000541003067816ULL, 0x144fe40000000004ULL,
0x0000763203077816ULL, 0x000fc40000000004ULL, 0x000000222303723eULL, 0x000fe400000010ffULL,
0x0000001e1f04723eULL, 0x000fe200000010ffULL, 0x000000060a007388ULL, 0x0005e40000000a00ULL,
0x0000541000067816ULL, 0x144fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x0000001a1b00723eULL, 0x000fe400000010ffULL, 0x000000161702723eULL, 0x000fe200000010ffULL,
0x000000060c007388ULL, 0x0005e40000000a00ULL, 0x0000541003067816ULL, 0x004fc40000000004ULL,
0x0000763203077816ULL, 0x000fe40000000004ULL, 0x000000121303723eULL, 0x000fe400000010ffULL,
0x000000272404723eULL, 0x000fe200000010ffULL, 0x000000060e007388ULL, 0x0005e40000000a00ULL,
0x0000541000067816ULL, 0x144fe40000000002ULL, 0x0000763200077816ULL, 0x000fe40000000002ULL,
0x0000002b2800723eULL, 0x000fc400000010ffULL, 0x0000002f2c02723eULL, 0x000fe200000010ffULL,
0x0004000608007388ULL, 0x0005e40000000a00ULL, 0x0000541003067816ULL, 0x144fe40000000004ULL,
0x0000763203077816ULL, 0x000fe40000000004ULL, 0x000000ff00037306ULL, 0x000fe60000205400ULL,
0x000400060a007388ULL, 0x0005e40000000a00ULL, 0x0000541000067816ULL, 0x004fc40000000002ULL,
0x0000763200077816ULL, 0x000fe40000000002ULL, 0x000000ff00007306ULL, 0x000ea60000209400ULL,
0x000400060c007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000032107984ULL, 0x000ee20000000c00ULL, 0x000000ff00027306ULL, 0x000e62000020d400ULL,
0x000000030000720bULL, 0x004fc40003f1d000ULL, 0x0004000032087984ULL, 0x000ea80000000c00ULL,
0x0008000032147984ULL, 0x000ea80000000c00ULL, 0x000c000032187984ULL, 0x000ea60000000c00ULL,
0x0000000102020812ULL, 0x002fc400078efcffULL, 0x000000ff3400720cULL, 0x000fe40003f05270ULL,
0x000000020204723eULL, 0x000fca00000010ffULL, 0x3f803f8004137831ULL, 0x048fe40000200013ULL,
0x3f803f8004127831ULL, 0x040fe40000200012ULL, 0x3f803f8004117831ULL, 0x040fe40000200011ULL,
0x3f803f8004107831ULL, 0x040fe40000200010ULL, 0x3f803f80040b7831ULL, 0x044fe4000020000bULL,
0x3f803f80040a7831ULL, 0x000fc4000020000aULL, 0x3f803f8004097831ULL, 0x040fe40000200009ULL,
0x3f803f8004087831ULL, 0x000fe40000200008ULL, 0x3f803f8013137831ULL, 0x000fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fe40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fc40000200014ULL, 0x3f803f800b0b7831ULL, 0x000fe4000020001bULL,
0x3f803f800a0a7831ULL, 0x000fe2000020001aULL, 0x0000001032007388ULL, 0x000fe20000000c00ULL,
0x3f803f8009097831ULL, 0x000fe40000200019ULL, 0x3f803f8008087831ULL, 0x000fca0000200018ULL,
0x0004000832007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002031067810ULL, 0x000fe20007ffe0ffULL,
0x0000000000047919ULL, 0x000e620000002600ULL, 0x00000003ff107819ULL, 0x100fe20000011631ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff037819ULL, 0x000fe20000011606ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000125257812ULL, 0x000fe200078ec0ffULL,
0x0000000110007824ULL, 0x000fe200078e0231ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000106027824ULL, 0x000fc400078e0203ULL, 0x0000000825127824ULL, 0x040fe200078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000000825117824ULL, 0x000fe200078e00ffULL,
0x0000000702077812ULL, 0x000fe400078ec0ffULL, 0x0ffffff800007812ULL, 0x000fe400078ef831ULL,
0x0ffffff807027812ULL, 0x100fe400078ef806ULL, 0xfffffff811117812ULL, 0x000fe200078ee206ULL,
0x0000001000007824ULL, 0x000fc400078e0205ULL, 0x0000001002057824ULL, 0x000fe400078e0205ULL,
0x0000000804077824ULL, 0x042fe200078e00ffULL, 0x0000000000087984ULL, 0x0002e20000000c00ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0x00000000050c7984ULL, 0x0004e20000000c00ULL, 0xfffffff807027812ULL, 0x000fe400078ee210ULL,
0xfffffff804037812ULL, 0x000fc400078ee203ULL, 0x0000000402077c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000403007c10ULL, 0x002fc6000ff3e0ffULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005a0007027a11ULL, 0x040fe200078040ffULL, 0x000000ffff057224ULL, 0x004fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fe400078240ffULL, 0x00005b0007037a11ULL, 0x000fe400000f4410ULL,
0xfffffff812077812ULL, 0x000fe400078ee231ULL, 0x00005b0000057a11ULL, 0x000fc600008f4405ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000022500720cULL, 0x000fe20003f06070ULL,
0xffffffffff097424ULL, 0x000fd800078e00ffULL, 0x000000023c0a8824ULL, 0x000fc800078e00ffULL,
0x000064000a0a8a24ULL, 0x000fc800078e0225ULL, 0x000060000a0a8625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff3e7624ULL, 0x000fe200078e00ffULL,
0x000000060a098981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff3f7624ULL, 0x000fc600078e00ffULL,
0x01760000ff047f8cULL, 0x000e68000c80043fULL, 0x000000063e3e7981ULL, 0x000722000c1e9900ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000004024247824ULL, 0x000fe400078e00ffULL,
0x0000004025387824ULL, 0x000fe400078e00ffULL, 0x00000040153a7824ULL, 0x000fc400078e00ffULL,
0x0000000924087224ULL, 0x004fcc00078e02ffULL, 0x00000e8000000947ULL, 0x000fea0003800000ULL,
0x00000003ff287819ULL, 0x10afe40000011633ULL, 0x0000003803097217ULL, 0x000fe40007800000ULL,
0x00000004280c7810ULL, 0x040fe20007ffe0ffULL, 0x0000004015157824ULL, 0x000fe200078e0228ULL,
0x00000008280e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000109097824ULL, 0x000fe200078e0a38ULL,
0x0000000c28207810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0a7824ULL, 0x040fe200078e0233ULL,
0x00000004150b7810ULL, 0x040fe20007ffe0ffULL, 0x000000080c137824ULL, 0x000fe200078e00ffULL,
0x0000001415117810ULL, 0x000fe20007ffe0ffULL, 0x000000080e177824ULL, 0x000fe200078e00ffULL,
0x0000000b080b7210ULL, 0x000fe20007f7e0ffULL, 0x00000008201b7824ULL, 0x000fe200078e00ffULL,
0x0000001508197210ULL, 0x000fc40007f5e0ffULL, 0x0000000c150d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00005e000b147a11ULL, 0x040fe400078638ffULL,
0x000000090c00720cULL, 0x000fe20003f06070ULL, 0x000000010e0c7824ULL, 0x000fe200078e0233ULL,
0x00005f000b1c7a11ULL, 0x000fe400018f3c1cULL, 0x00000008150b7810ULL, 0x000fe40007ffe0ffULL,
0x0000001108117210ULL, 0x000fc40007f7e0ffULL, 0x0000000b080b7210ULL, 0x000fe40007f9e0ffULL,
0x000000090e00720cULL, 0x000fe20003f26070ULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffff813137812ULL, 0x000fe200078ee20aULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x0000000d080d7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x00005e0019107a11ULL, 0x000fe400078438ffULL, 0x00005e0011227a11ULL, 0x000fc400078638ffULL,
0x00000010150f7810ULL, 0x000fe40007ffe0ffULL, 0x00005e000b127a11ULL, 0x000fe400078838ffULL,
0xfffffff817177812ULL, 0x000fe200078ee20cULL, 0x000000ffff0c7224ULL, 0x000fe200028e06ffULL,
0x00005f0019197a11ULL, 0x000fe400010f3c0eULL, 0x00005f0011237a11ULL, 0x000fe200018f3c0aULL,
0x00000001280a7824ULL, 0x000fe200078e0233ULL, 0x0000000f080f7210ULL, 0x000fc40007f5e0ffULL,
0x00005e000d167a11ULL, 0x000fe400078a38ffULL, 0x00005f000b1a7a11ULL, 0x000fe200020f3c1aULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x0000007006277812ULL, 0x000fe400078ec0ffULL,
0x00000018150b7810ULL, 0x000fe40007ffe0ffULL, 0x00005f000d217a11ULL, 0x000fe200028f3c0cULL,
0x00000001200c7824ULL, 0x000fe200078e0233ULL, 0x000000070a1e7812ULL, 0x000fc400078ec0ffULL,
0x000000092000720cULL, 0x000fe40003fa6070ULL, 0x00005e000f187a11ULL, 0x040fe400078438ffULL,
0x0000000b08207210ULL, 0x000fe40007fde0ffULL, 0x00000027100a7210ULL, 0x000fe40007f7e0ffULL,
0x00005f000f267a11ULL, 0x000fe200010f3c26ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x00000010280e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e0619ULL,
0x0ffffff81e117812ULL, 0x000fc400078ef833ULL, 0x00005e00201e7a11ULL, 0x000fe200078638ffULL,
0x000000010e0d7824ULL, 0x000fe200078e0233ULL, 0x000000092800720cULL, 0x080fe40003f46070ULL,
0x000000090e00720cULL, 0x040fe20003f86070ULL, 0x000000080e0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b197812ULL, 0x000fe400078ee20cULL, 0x00005f0020207a11ULL, 0x000fe400018f3c0fULL,
0x0000100025067811ULL, 0x000fc400078e70ffULL, 0x00000027140c7210ULL, 0x080fe40007f7e0ffULL,
0x0000001c151d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e0206ULL,
0xfffffff80e1b7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0d7224ULL, 0x000fe200018e061cULL,
0x0000001428107810ULL, 0x040fe20007ffe0ffULL, 0x0000001013137824ULL, 0x000fe200078e0206ULL,
0x0000001828147810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a117faeULL, 0x0003e2000d101c46ULL, 0x00000027120e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000110127824ULL, 0x100fe200078e0233ULL, 0x0000001d081c7210ULL, 0x000fe20007fde0ffULL,
0x00000008101f7824ULL, 0x040fe200078e00ffULL, 0x000000000c137faeULL, 0x0005e2000c101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200018e061aULL, 0x000000091000720cULL, 0x000fe20003f46070ULL,
0x0000001017177824ULL, 0x000fe200078e0206ULL, 0xfffffff81f1d7812ULL, 0x000fe200078ee212ULL,
0x0000001019197824ULL, 0x000fe200078e0206ULL, 0x0000001c28127810ULL, 0x000fe20007ffe0ffULL,
0x00000001140a7824ULL, 0x042fe200078e0233ULL, 0x000000000e177faeULL, 0x0003e2000c901c46ULL,
0x0000000814117824ULL, 0x000fe200078e00ffULL, 0x0000002718107210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0x00005e001c1a7a11ULL, 0x000fe200078c38ffULL,
0x0000000812297824ULL, 0x000fe200078e00ffULL, 0xfffffff8111f7812ULL, 0x000fe200078ee20aULL,
0x000000ffff117224ULL, 0x000fe200008e0626ULL, 0x00005f001c1c7a11ULL, 0x000fe200030f3c0bULL,
0x000000101b1b7824ULL, 0x100fe200078e0206ULL, 0x00000027160a7210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0206ULL, 0x0000002028167810ULL, 0x000fe20007ffe0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0206ULL, 0x000000091400720cULL, 0x080fe20003f66070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0621ULL, 0x0000002015217810ULL, 0x000fe20007ffe0ffULL,
0x00000001160c7824ULL, 0x144fe200078e0233ULL, 0x000000091600720cULL, 0x000fe20003f26070ULL,
0x0000000112147824ULL, 0x000fe200078e0233ULL, 0x0000002108187210ULL, 0x000fe20007fde0ffULL,
0x0000000816217824ULL, 0x000fe200078e00ffULL, 0x000000000a197faeULL, 0x0005e2000e901c46ULL,
0x00000024280e7810ULL, 0x002fc40007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x00005e0018167a11ULL, 0x000fe200078c38ffULL, 0x00000000101b7faeULL, 0x0003e2000e101c46ULL,
0xfffffff821217812ULL, 0x000fe200078ee20cULL, 0x000000010e0f7824ULL, 0x000fe200078e0233ULL,
0x00005f0018187a11ULL, 0x000fe400030f3c0dULL, 0x00000024150d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e0206ULL, 0x00000027220c7210ULL, 0x000fe40007fbe0ffULL,
0xfffffff829137812ULL, 0x000fc400078ee214ULL, 0x000000090e00720cULL, 0x040fe20003f86070ULL,
0x000000080e0e7824ULL, 0x000fe200078e00ffULL, 0x0000000d08147210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e0623ULL, 0x000000271e0a7210ULL, 0x004fe40007fbe0ffULL,
0x000000091200720cULL, 0x000fe20003f06070ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0xfffffff80e197812ULL, 0x000fe200078ee20fULL, 0x000000000c1d7faeULL, 0x0005e2000d101c46ULL,
0x00005e0014127a11ULL, 0x000fe200078c38ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0620ULL,
0x000000271a0e7210ULL, 0x080fe20007f5e0ffULL, 0x0000001019197824ULL, 0x100fe200078e0206ULL,
0x00005f0014147a11ULL, 0x000fe200030f3c17ULL, 0x0000001013177824ULL, 0x000fe200078e0206ULL,
0x000000000a1f7faeULL, 0x0007e2000d901c46ULL, 0x000000ffff0f7224ULL, 0x000fe200010e061cULL,
0x0000002716107210ULL, 0x002fc40007f7e0ffULL, 0x0000002712127210ULL, 0x000fe40007f5e0ffULL,
0x000000000e177faeULL, 0x0003e2000c101c46ULL, 0x000000ffff117224ULL, 0x000fe200018e0618ULL,
0x0000003028167810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0614ULL,
0x0000002c28147810ULL, 0x040fe40007ffe0ffULL, 0x00000028150b7810ULL, 0x008fe20007ffe0ffULL,
0x0000000010217faeULL, 0x0007e2000c901c46ULL, 0x00000028280a7810ULL, 0x000fc40007ffe0ffULL,
0x0000003428187810ULL, 0x000fe20007ffe0ffULL, 0x0000000012197faeULL, 0x0007e2000e101c46ULL,
0x0000000b080e7210ULL, 0x002fe20007fde0ffULL, 0x000000010a0c7824ULL, 0x144fe200078e0233ULL,
0x000000090a00720cULL, 0x0c0fe20003fa6070ULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0x00000038281a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x00005e000e0a7a11ULL, 0x000fe200078c38ffULL, 0x00000001140b7824ULL, 0x000fe200078e0233ULL,
0x0000003c281c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000816117824ULL, 0x008fe200078e00ffULL,
0x000000091400720cULL, 0x040fe20003f86070ULL, 0x0000000814147824ULL, 0x000fe200078e00ffULL,
0x00005f000e0e7a11ULL, 0x000fc400030f3c0dULL, 0x000000270a0a7210ULL, 0x000fe40007fde0ffULL,
0x000000091600720cULL, 0x080fe40003f66070ULL, 0x000000091800720cULL, 0x080fe40003f46070ULL,
0x000000091a00720cULL, 0x080fe40003f26070ULL, 0x000000091c00720cULL, 0x000fe40003f06070ULL,
0x0000002c150d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80f097812ULL, 0x000fe200078ee20cULL,
0x00000001160c7824ULL, 0x000fe200078e0233ULL, 0xfffffff8140f7812ULL, 0x000fe200078ee20bULL,
0x000000ffff0b7224ULL, 0x000fe200030e060eULL, 0x0000000d080e7210ULL, 0x000fe20007fde0ffULL,
0x00000001180d7824ULL, 0x040fe200078e0233ULL, 0xfffffff811117812ULL, 0x000fe200078ee20cULL,
0x0000000818187824ULL, 0x000fe400078e00ffULL, 0x0000001009097824ULL, 0x100fe400078e0206ULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0xfffffff818137812ULL, 0x000fe200078ee20dULL,
0x000000100f0f7824ULL, 0x100fe200078e0206ULL, 0x00000030150d7810ULL, 0x000fe20007ffe0ffULL,
0x000000000a097faeULL, 0x0003e2000e901c46ULL, 0x00005e000e147a11ULL, 0x000fe200078c38ffULL,
0x0000001011117824ULL, 0x100fe200078e0206ULL, 0x0000000d080d7210ULL, 0x000fe20007fbe0ffULL,
0x0000001013137824ULL, 0x000fe200078e0206ULL, 0x00005f000e167a11ULL, 0x000fe200030f3c17ULL,
0x000000011a0e7824ULL, 0x040fe200078e0233ULL, 0x00005e000d107a11ULL, 0x000fe200078c38ffULL,
0x000000081a177824ULL, 0x000fc400078e00ffULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x00000027140c7210ULL, 0x000fe20007fbe0ffULL, 0x000000011c337824ULL, 0x040fe200078e0233ULL,
0x0000003415097810ULL, 0x002fe20007ffe0ffULL, 0x000000081c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe400078ee20eULL, 0x00005f000d0e7a11ULL, 0x000fe200030f3c12ULL,
0x000000ffff0d7224ULL, 0x000fe200028e0616ULL, 0x0000000908097210ULL, 0x000fe20007fbe0ffULL,
0x0000001017177824ULL, 0x000fe200078e0206ULL, 0x00000038150b7810ULL, 0x000fc40007ffe0ffULL,
0x0000003c15157810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x00005e00090a7a11ULL, 0x040fe200078a38ffULL, 0x000000000c0f7faeULL, 0x0003e2000e101c46ULL,
0x0000000b080b7210ULL, 0x040fe40007f9e0ffULL, 0x0000001508157210ULL, 0x000fe40007fde0ffULL,
0x00005f0009127a11ULL, 0x000fe400028f3c12ULL, 0x0000002710087210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0xfffffff81c337812ULL, 0x000fc600078ee233ULL,
0x000000ffff097224ULL, 0x000fe200028e060eULL, 0x00005e000b0c7a11ULL, 0x002fe200078838ffULL,
0x0000001033337824ULL, 0x000fe200078e0206ULL, 0x000000270a0a7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff067224ULL, 0x000fe200030e06ffULL, 0x00005e00150e7a11ULL, 0x000fe200078c38ffULL,
0x0000000008117faeULL, 0x0003e2000d901c46ULL, 0x00005f000b0d7a11ULL, 0x000fe200020f3c10ULL,
0x000000ffff0b7224ULL, 0x000fe200028e0612ULL, 0x000000270c0c7210ULL, 0x000fe40007f9e0ffULL,
0x00005f0015067a11ULL, 0x000fc400030f3c06ULL, 0x000000270e0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e060dULL, 0x000000000a137faeULL, 0x0003e6000d101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200028e0606ULL, 0x000000000c177faeULL, 0x0003e8000c901c46ULL,
0x000000000e337faeULL, 0x0003e2000c101c46ULL, 0x00000d4000007947ULL, 0x000fea0003800000ULL,
0x00000004330a7811ULL, 0x04afe400078fe8ffULL, 0x0000000c330f7811ULL, 0x000fc400078fe8ffULL,
0x00000008330d7811ULL, 0x040fe200078fe8ffULL, 0x000000010a097824ULL, 0x140fe200078e0233ULL,
0x0000001033117811ULL, 0x040fe200078fe8ffULL, 0x000000080a0c7824ULL, 0x000fe200078e00ffULL,
0x0000001833157811ULL, 0x000fe200078fe8ffULL, 0x000000010f107824ULL, 0x000fe200078e0233ULL,
0x0000001c33177811ULL, 0x000fe200078fe8ffULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x000000010d0b7824ULL, 0x100fe200078e0233ULL,
0x00000024331b7811ULL, 0x000fe200078fe8ffULL, 0x000000080d0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff813107812ULL, 0x000fe200078ee210ULL, 0x0000000111097824ULL, 0x000fe200078e0233ULL,
0x0000001433137811ULL, 0x000fe200078fe8ffULL, 0x0000000811127824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL, 0x0000000115167824ULL, 0x000fe200078e0233ULL,
0x00000028331d7811ULL, 0x000fe200078fe8ffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee209ULL, 0x00000001130b7824ULL, 0x100fe200078e0233ULL,
0x0000003033217811ULL, 0x000fe200078fe8ffULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0xfffffff819167812ULL, 0x000fe200078ee216ULL, 0x0000000117097824ULL, 0x000fe200078e0233ULL,
0x0000002033197811ULL, 0x000fe200078fe8ffULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20bULL, 0x000000011b1c7824ULL, 0x000fe200078e0233ULL,
0x0000003433237811ULL, 0x000fe200078fe8ffULL, 0x000000081b1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee209ULL, 0x00000001190b7824ULL, 0x100fe200078e0233ULL,
0x0000100025417811ULL, 0x000fe200078e70ffULL, 0x00000008191a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL, 0x000000011d097824ULL, 0x000fe200078e0233ULL,
0x0000002c331f7811ULL, 0x000fe200078fe8ffULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL, 0x0000000121227824ULL, 0x100fe200078e0233ULL,
0x00000070064c7812ULL, 0x000fe200078ec0ffULL, 0x000000011f0b7824ULL, 0x040fe200078e0233ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL, 0x000000081f207824ULL, 0x000fe200078e00ffULL,
0x0000003a33097211ULL, 0x000fe200078fe8ffULL, 0x0000000821277824ULL, 0x000fc400078e00ffULL,
0x0000000123267824ULL, 0x040fe200078e0233ULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x000000013a0b7824ULL, 0x000fe200078e020aULL, 0x00000009084a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000823297824ULL, 0x000fe200078e00ffULL, 0xfffffff827227812ULL, 0x000fe200078ee222ULL,
0x000000013a0d7824ULL, 0x000fe200078e020dULL, 0x0000000b08487210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x00005e004a497a11ULL, 0x000fe200078038ffULL,
0x000000013a117824ULL, 0x040fe200078e0211ULL, 0x0000003833277811ULL, 0x000fe200078fe8ffULL,
0x000000013a0f7824ULL, 0x000fe200078e020fULL, 0xfffffff829267812ULL, 0x000fe200078ee226ULL,
0x000000ffff297224ULL, 0x000fe200008e06ffULL, 0x00005f004a4a7a11ULL, 0x000fe200000f3c2bULL,
0x0000000127097824ULL, 0x040fe200078e0233ULL, 0x0000000d080d7210ULL, 0x000fe20007f1e0ffULL,
0x00000008270a7824ULL, 0x000fe200078e00ffULL, 0x00005e0048477a11ULL, 0x000fe200078238ffULL,
0x000000013a137824ULL, 0x000fe200078e0213ULL, 0x0000001108427210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff467224ULL, 0x000fe200000e06ffULL, 0x00005f0048487a11ULL, 0x000fe200008f3c29ULL,
0x000000013a157824ULL, 0x000fe200078e0215ULL, 0x0000000f080f7210ULL, 0x000fe20007f3e0ffULL,
0x000000013a177824ULL, 0x040fe200078e0217ULL, 0x00005e000d457a11ULL, 0x040fe200078038ffULL,
0x000000013a197824ULL, 0x000fe200078e0219ULL, 0xfffffff80a0b7812ULL, 0x000fe200078ee209ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005f000d467a11ULL, 0x000fe200000f3c46ULL,
0x000000ffff447224ULL, 0x000fe200008e06ffULL, 0x00005e0042117a11ULL, 0x000fe200078438ffULL,
0x000000013a1b7824ULL, 0x000fe200078e021bULL, 0x0000001308407210ULL, 0x000fe20007f1e0ffULL,
0x000000013a217824ULL, 0x040fe200078e0221ULL, 0x00005e000f437a11ULL, 0x040fe200078238ffULL,
0x000000013a1d7824ULL, 0x000fe200078e021dULL, 0x00005f0042427a11ULL, 0x000fe200010f3c09ULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005f000f447a11ULL, 0x000fe200008f3c44ULL,
0x000000013a1f7824ULL, 0x000fe200078e021fULL, 0x00005e0040137a11ULL, 0x000fe200078038ffULL,
0x000000013a237824ULL, 0x000fe200078e0223ULL, 0x0000001508367210ULL, 0x000fe20007f3e0ffULL,
0x000000013a277824ULL, 0x000fe200078e0227ULL, 0x0000001708347210ULL, 0x040fe20007f5e0ffULL,
0x000000100b3f7824ULL, 0x000fe200078e0241ULL, 0x0000001908327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x00005f0040407a11ULL, 0x000fe200000f3c09ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e0034177a11ULL, 0x000fe200078238ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x00005e0032197a11ULL, 0x000fe200078438ffULL,
0x0000001020397824ULL, 0x000fe200078e0241ULL, 0x00005f0034347a11ULL, 0x000fe200008f3c09ULL,
0x000000101c357824ULL, 0x100fe200078e0241ULL, 0x0000003333097211ULL, 0x040fe200078fe8ffULL,
0x000000101e377824ULL, 0x000fe200078e0241ULL, 0x00005f0032327a11ULL, 0x000fe200010f3c0dULL,
0x00000010223b7824ULL, 0x100fe200078e0241ULL, 0x0000003c330d7811ULL, 0x000fe200078fe8ffULL,
0x00000010263d7824ULL, 0x100fe200078e0241ULL, 0x00000007090a7812ULL, 0x000fe200078ec0ffULL,
0x0000001010297824ULL, 0x000fe200078e0241ULL, 0x00005e0036157a11ULL, 0x000fe200078038ffULL,
0x000000013a097824ULL, 0x000fe200078e020dULL, 0x0000001b08307210ULL, 0x040fe20007f9e0ffULL,
0x000000080d287824ULL, 0x040fe200078e00ffULL, 0x00000021082e7210ULL, 0x000fe20007f3e0ffULL,
0x00000010122b7824ULL, 0x000fe200078e0241ULL, 0x0ffffff80a0a7812ULL, 0x100fe200078ef833ULL,
0x000000010d337824ULL, 0x000fe200078e0233ULL, 0x0000001d081d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0x00005f0036367a11ULL, 0x000fe200000f3c0fULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x0000001f081f7210ULL, 0x000fe20007f1e0ffULL,
0x000000100a217824ULL, 0x100fe200078e0241ULL, 0x00000023082c7210ULL, 0x000fe20007f5e0ffULL,
0x000000100c237824ULL, 0x100fe200078e0241ULL, 0x00005e00301b7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x00000027082a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005e002e207a11ULL, 0x000fe200078238ffULL,
0x000000100e277824ULL, 0x100fe200078e0241ULL, 0x0000000908097210ULL, 0x000fe20007fbe0ffULL,
0x00000010142d7824ULL, 0x100fe200078e0241ULL, 0x00005e001d1c7a11ULL, 0x000fe200078638ffULL,
0x00000010162f7824ULL, 0x000fe200078e0241ULL, 0xfffffff828087812ULL, 0x000fe200078ee233ULL,
0x000000ffff067224ULL, 0x000fe200028e06ffULL, 0x00005f0030307a11ULL, 0x000fe200030f3c0dULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe200078038ffULL,
0x0000001018317824ULL, 0x000fe200078e0241ULL, 0x00005f002e2e7a11ULL, 0x000fe200008f3c0bULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0x00005e002c227a11ULL, 0x000fe200078238ffULL,
0x000000101a337824ULL, 0x100fe200078e0241ULL, 0x00005f001d1d7a11ULL, 0x000fe200018f3c0cULL,
0x0000001008417824ULL, 0x000fe200078e0241ULL, 0x00005e002a267a11ULL, 0x000fc400078438ffULL,
0x00005e0009287a11ULL, 0x000fe400078638ffULL, 0x00005f001f1f7a11ULL, 0x000fe400000f3c0aULL,
0x000000494c087210ULL, 0x000fe40007f1e0ffULL, 0x00005f002c2c7a11ULL, 0x000fe400008f3c0dULL,
0x00005f002a2a7a11ULL, 0x000fe400010f3c0bULL, 0x000000474c0a7210ULL, 0x000fc40007f3e0ffULL,
0x00005f0009067a11ULL, 0x000fe200018f3c06ULL, 0x000000ffff097224ULL, 0x000fe200000e064aULL,
0x000000454c0c7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0648ULL,
0x000000434c0e7210ULL, 0x040fe40007f7e0ffULL, 0x000000114c107210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0646ULL, 0x000000134c127210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0644ULL, 0x000000154c147210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e0642ULL, 0x000000174c167210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200020e0640ULL, 0x000000194c187210ULL, 0x040fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008217faeULL, 0x0003e2000b901c46ULL,
0x0000001b4c1a7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0636ULL,
0x0000001c4c1c7210ULL, 0x040fe20007fbe0ffULL, 0x000000000a237faeULL, 0x0005e2000b901c46ULL,
0x0000001e4c1e7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0634ULL,
0x000000204c207210ULL, 0x040fe20007f1e0ffULL, 0x000000000c277faeULL, 0x0007e2000b901c46ULL,
0x000000224c227210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0632ULL,
0x000000264c267210ULL, 0x040fe20007f5e0ffULL, 0x000000000e297faeULL, 0x0007e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fe200018e0630ULL, 0x000000284c287210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e061dULL, 0x00000000102b7faeULL, 0x0007e2000b901c46ULL,
0x000000ffff1f7224ULL, 0x000fc400020e061fULL, 0x000000ffff217224ULL, 0x002fe200000e062eULL,
0x00000000122d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x004fe400008e062cULL,
0x000000ffff277224ULL, 0x008fe200010e062aULL, 0x00000000142f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fc600018e0606ULL, 0x0000000016317faeULL, 0x0003e8000b901c46ULL,
0x0000000018337faeULL, 0x0003e8000b901c46ULL, 0x000000001a357faeULL, 0x0003e8000b901c46ULL,
0x000000001c377faeULL, 0x0003e8000b901c46ULL, 0x000000001e397faeULL, 0x0003e8000b901c46ULL,
0x00000000203b7faeULL, 0x0003e8000b901c46ULL, 0x00000000223d7faeULL, 0x0003e8000b901c46ULL,
0x00000000263f7faeULL, 0x0003e8000b901c46ULL, 0x0000000028417faeULL, 0x0003e4000b901c46ULL,
0x0000000425397810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff3b7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000023900720cULL, 0x000fda0003f06070ULL,
0x000000023c068824ULL, 0x000fc800078e00ffULL, 0x0000640006068a24ULL, 0x000fc800078e0239ULL,
0x0000600006068625ULL, 0x000fca00078e0007ULL, 0x00000006063b8981ULL, 0x000324000c1e1900ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01760400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000002025047824ULL, 0x002fca00078e0204ULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05077812ULL, 0x000fe400078ec0ffULL, 0x0000000f04057812ULL, 0x000fc600078ec0ffULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x0000001005097824ULL, 0x040fe400078e00ffULL,
0x0000001005067824ULL, 0x000fe200078e00ffULL, 0x0000000f07047812ULL, 0x040fe400078ec0ffULL,
0x0000000107077810ULL, 0x000fe40007ffe0ffULL, 0x000000f009047812ULL, 0x000fe400078ee204ULL,
0x0000000f07077812ULL, 0x000fc600078ec0ffULL, 0x00000000040c7984ULL, 0x000e62000000cc00ULL,
0x000000f006077812ULL, 0x000fca00078ee207ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001004007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01760400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000000003d7919ULL, 0x000e620000000000ULL,
0x000064003c3c7a24ULL, 0x000fe200078e02ffULL, 0x00017688253f7811ULL, 0x040fe200078e18ffULL,
0x3db504f33e3e7820ULL, 0x010fe20000410000ULL, 0xffffffff00407810ULL, 0x000fe20007ffe0ffULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0001760825417811ULL, 0x000fca00078e28ffULL,
0x0000010043447824ULL, 0x000fe200078e0238ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000440300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x0000000243057810ULL, 0x000fe20007ffe0ffULL, 0x0000003b243b7224ULL, 0x000fe200078e02ffULL,
0x0000000142467812ULL, 0x000fe400078e0cffULL, 0x000000000500720cULL, 0x000fda0003f06070ULL,
0x00000eb000008947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x002fe4000001163dULL,
0x0000010044047810ULL, 0x000fe40007ffe0ffULL, 0x0000000419077810ULL, 0x000fe20007ffe0ffULL,
0x000000013a067824ULL, 0x040fe200078e0219ULL, 0x0000000403057217ULL, 0x000fe40007800000ULL,
0x0000000819097810ULL, 0x000fe20007ffe0ffULL, 0x0000000107087824ULL, 0x000fe200078e023dULL,
0x000000063b067210ULL, 0x000fe20007f1e0ffULL, 0x00000001050a7824ULL, 0x000fe200078e0a04ULL,
0x0000000c19057810ULL, 0x040fe20007ffe0ffULL, 0x000000013a047824ULL, 0x000fe200078e0207ULL,
0x0000001819157810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e00060c7a11ULL, 0x040fe200078038ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x000000043b047210ULL, 0x000fe20007f3e0ffULL, 0x00000001090b7824ULL, 0x000fe200078e023dULL,
0x00005f0006117a11ULL, 0x000fe200000f3c11ULL, 0x000000013a067824ULL, 0x040fe200078e0209ULL,
0xfffffff80d1a7812ULL, 0x000fe200078ee208ULL, 0x000000013a087824ULL, 0x000fe200078e0205ULL,
0x0000000a0900720cULL, 0x040fe20003f46070ULL, 0x00000008091c7824ULL, 0x000fe200078e00ffULL,
0x000000063b067210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000000a0700720cULL, 0x000fe20003f66070ULL, 0x00000008051e7824ULL, 0x000fe200078e00ffULL,
0x00005e00040f7a11ULL, 0x000fe200078238ffULL, 0x000000ffff077224ULL, 0x000fe200028e06ffULL,
0x00005e00060d7a11ULL, 0x000fe200078a38ffULL, 0x0000000815267824ULL, 0x000fe200078e00ffULL,
0x000000083b087210ULL, 0x000fc40007f1e0ffULL, 0x00005f0004107a11ULL, 0x000fe200008f3c09ULL,
0x000000103d047824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL,
0x00000001050b7824ULL, 0x040fe200078e023dULL, 0x00005f00060e7a11ULL, 0x000fe400028f3c07ULL,
0x0000000a0500720cULL, 0x000fe20003f86070ULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x0000001019077810ULL, 0x000fe40007ffe0ffULL, 0x00005e0008177a11ULL, 0x000fc400078038ffULL,
0x00000070041b7812ULL, 0x000fe200078ec0ffULL, 0x000000013a047824ULL, 0x000fe200078e0207ULL,
0x00005f0008187a11ULL, 0x000fe200000f3c05ULL, 0x0000000119057824ULL, 0x000fe200078e023dULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x00000002250b7824ULL, 0x000fe200078e0246ULL,
0x000000043b167210ULL, 0x000fe20007fde0ffULL, 0x0000000107087824ULL, 0x040fe200078e023dULL,
0x0000001b0c047210ULL, 0x000fe20007f3e0ffULL, 0x0000000807137824ULL, 0x000fe200078e00ffULL,
0x0000000705067812ULL, 0x000fc400078ec0ffULL, 0x000010000b0b7811ULL, 0x000fe200078e68ffULL,
0x000000ffff057224ULL, 0x000fe200008e0611ULL, 0x0ffffff806067812ULL, 0x000fe400078ef83dULL,
0x0000001419117810ULL, 0x000fe40007ffe0ffULL, 0x0000000a0700720cULL, 0x080fe20003fa6070ULL,
0x000000ffff077224ULL, 0x000fe200030e06ffULL, 0x00005e0016147a11ULL, 0x000fe200078238ffULL,
0x0000001006097824ULL, 0x000fe200078e020bULL, 0x0000000a1900720cULL, 0x000fe20003f06070ULL,
0x000000013a067824ULL, 0x040fe200078e0211ULL, 0xfffffff813207812ULL, 0x000fe200078ee208ULL,
0x000000013a087824ULL, 0x000fe200078e0215ULL, 0x00005f0016167a11ULL, 0x000fe200008f3c07ULL,
0x0000000111077824ULL, 0x000fe200078e023dULL, 0x000000063b137210ULL, 0x000fe20007f3e0ffULL,
0x0000000811227824ULL, 0x000fe200078e00ffULL, 0x00000020191d7810ULL, 0x000fc40007ffe0ffULL,
0x00005e0013127a11ULL, 0x000fe200078c38ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000001b0f067210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e2000c101c46ULL, 0x0000000a1100720cULL, 0x000fe20003f06070ULL,
0x000000101c0f7824ULL, 0x000fe200078e020bULL, 0x00005f0013137a11ULL, 0x000fe400030f3c0cULL,
0x000000083b087210ULL, 0x000fe40007fde0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee207ULL,
0x000000ffff077224ULL, 0x000fc400008e0610ULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x00005e0008107a11ULL, 0x000fe200078c38ffULL, 0x0000000115097824ULL, 0x002fe200078e023dULL,
0x0000001b0d047210ULL, 0x000fe20007f3e0ffULL, 0x000000101a0d7824ULL, 0x000fe200078e020bULL,
0x00005f0008117a11ULL, 0x000fe400030f3c11ULL, 0xfffffff826267812ULL, 0x000fe200078ee209ULL,
0x000000ffff057224ULL, 0x000fe200008e060eULL, 0x0000001c19097810ULL, 0x000fe20007ffe0ffULL,
0x00000000060d7faeULL, 0x0003e2000d901c46ULL, 0x0000000a1500720cULL, 0x000fc60003f26070ULL,
0x000000013a087824ULL, 0x040fe200078e0209ULL, 0x00000000040f7faeULL, 0x0005e2000d101c46ULL,
0x00000001091a7824ULL, 0x040fe200078e023dULL, 0x0000000a0900720cULL, 0x040fe20003f46070ULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x000000083b157210ULL, 0x000fe20007f7e0ffULL,
0x000000013a067824ULL, 0x002fc600078e021dULL, 0x00005e00150e7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x0000001b17087210ULL, 0x080fe20007f7e0ffULL,
0x000000011d077824ULL, 0x000fe200078e023dULL, 0xfffffff8091a7812ULL, 0x000fe200078ee21aULL,
0x000000101e0d7824ULL, 0x100fe200078e020bULL, 0x00005f0015157a11ULL, 0x000fe200030f3c0cULL,
0x000000ffff097224ULL, 0x000fe200018e0618ULL, 0x000000063b067210ULL, 0x000fe20007fde0ffULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0x0000001b14047210ULL, 0x004fe20007f7e0ffULL,
0x00000010200f7824ULL, 0x000fe200078e020bULL, 0x00000000080d7faeULL, 0x0003e2000e101c46ULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0xfffffff818187812ULL, 0x000fe200078ee207ULL,
0x000000ffff057224ULL, 0x000fe200018e0616ULL, 0x00005e00060c7a11ULL, 0x000fc400078c38ffULL,
0x0000002419077810ULL, 0x000fe40007ffe0ffULL, 0x00005f0006177a11ULL, 0x000fe200030f3c17ULL,
0x00000000040f7faeULL, 0x0005e2000e901c46ULL, 0x0000000a1d00720cULL, 0x080fe20003f66070ULL,
0x000000013a067824ULL, 0x040fe200078e0207ULL, 0x00000028191d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001071c7824ULL, 0x040fe200078e023dULL, 0x0000000a0700720cULL, 0x040fe20003fa6070ULL,
0x00000008071f7824ULL, 0x000fe200078e00ffULL, 0x000000063b167210ULL, 0x000fe20007f9e0ffULL,
0x000000013a087824ULL, 0x002fc400078e021dULL, 0x000000011d097824ULL, 0x040fe200078e023dULL,
0x00005e0016147a11ULL, 0x000fe200078c38ffULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x0000001b12067210ULL, 0x080fe20007f9e0ffULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0x0000002c190f7810ULL, 0x004fe40007ffe0ffULL, 0x00005f0016167a11ULL, 0x000fe200030f3c07ULL,
0x000000ffff077224ULL, 0x000fe200020e0613ULL, 0x000000083b087210ULL, 0x000fe20007fde0ffULL,
0x000000080f207824ULL, 0x000fe200078e00ffULL, 0x0000001b10047210ULL, 0x000fc40007f9e0ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x00005e0008107a11ULL, 0x000fe200078c38ffULL, 0x0000001022097824ULL, 0x000fe200078e020bULL,
0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff057224ULL, 0x000fe200020e0611ULL,
0x00005f0008127a11ULL, 0x000fe200030f3c0dULL, 0x00000010260d7824ULL, 0x000fe200078e020bULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000013a087824ULL, 0x000fe200078e020fULL,
0x0000000a1d00720cULL, 0x000fe20003f86070ULL, 0x000000010f1d7824ULL, 0x000fe200078e023dULL,
0x00000000040d7faeULL, 0x0005e2000c901c46ULL, 0x00000030191f7810ULL, 0x000fc40007ffe0ffULL,
0x000000083b087210ULL, 0x000fe40007f3e0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee21dULL,
0x000000081f227824ULL, 0x000fe200078e00ffULL, 0x00005e0008117a11ULL, 0x000fe200078c38ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000001b0e067210ULL, 0x082fe40007f3e0ffULL,
0x00000034191d7810ULL, 0x000fe20007ffe0ffULL, 0x000000101a0d7824ULL, 0x004fe200078e020bULL,
0x0000000a0f00720cULL, 0x080fe20003f06070ULL, 0x000000ffff077224ULL, 0x000fe200008e0615ULL,
0x00005f0008137a11ULL, 0x000fe200030f3c13ULL, 0x000000013a047824ULL, 0x000fe200078e021fULL,
0x0000000a1f00720cULL, 0x040fe20003f26070ULL, 0x000000011f0f7824ULL, 0x100fe200078e023dULL,
0x00000000060d7faeULL, 0x0003e2000d101c46ULL, 0x000000011d087824ULL, 0x000fe200078e023dULL,
0x000000043b157210ULL, 0x000fe20007fde0ffULL, 0x000000081d097824ULL, 0x000fe200078e00ffULL,
0x0000001b0c047210ULL, 0x000fc40007f5e0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20fULL,
0x000000ffff0e7224ULL, 0x000fe200030e06ffULL, 0x00005e00150c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff057224ULL, 0x000fe200010e0617ULL, 0x0000003819177810ULL, 0x000fe20007ffe0ffULL,
0x00000010180f7824ULL, 0x000fe200078e020bULL, 0xfffffff809187812ULL, 0x000fe200078ee208ULL,
0x000000013a067824ULL, 0x002fe200078e021dULL, 0x0000001b14087210ULL, 0x080fe20007f5e0ffULL,
0x000000101c0d7824ULL, 0x000fe200078e020bULL, 0x00005f0015157a11ULL, 0x000fe200030f3c0eULL,
0x00000000040f7faeULL, 0x0003e2000d901c46ULL, 0x000000063b147210ULL, 0x000fe20007fde0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0616ULL, 0x0000001b10067210ULL, 0x000fe20007f7e0ffULL,
0x00000001170e7824ULL, 0x000fe200078e023dULL, 0x0000003c19197810ULL, 0x000fc40007ffe0ffULL,
0x00000000080d7faeULL, 0x0005e2000e901c46ULL, 0x000000ffff077224ULL, 0x000fe200018e0612ULL,
0x0000000a1d00720cULL, 0x080fe20003f46070ULL, 0x0000000819167824ULL, 0x000fe200078e00ffULL,
0x0000000a1700720cULL, 0x080fe20003fa6070ULL, 0x000000ffff057224ULL, 0x002fe200030e06ffULL,
0x00005e0014127a11ULL, 0x000fe200078c38ffULL, 0x000000013a047824ULL, 0x000fe200078e0217ULL,
0x0000000a1900720cULL, 0x000fe20003f66070ULL, 0x00000008170f7824ULL, 0x000fe200078e00ffULL,
0x00005f0014147a11ULL, 0x000fe200030f3c05ULL, 0x000000101e097824ULL, 0x004fe200078e020bULL,
0x000000043b107210ULL, 0x000fe20007fde0ffULL, 0x000000013a087824ULL, 0x000fe200078e0219ULL,
0xfffffff80f0e7812ULL, 0x000fe200078ee20eULL, 0x00000010200d7824ULL, 0x000fe200078e020bULL,
0x0000000006097faeULL, 0x0003e2000e101c46ULL, 0x0000001b11047210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x00005e00100a7a11ULL, 0x000fe200078c38ffULL,
0x0000000119117824ULL, 0x000fc400078e023dULL, 0x000000ffff057224ULL, 0x000fe200020e0613ULL,
0x000000083b3b7210ULL, 0x000fe20007f9e0ffULL, 0x000000100e137824ULL, 0x000fe200078e020bULL,
0x00005f0010107a11ULL, 0x000fe200030f3c0fULL, 0x00000010220f7824ULL, 0x000fe200078e020bULL,
0x00000000040d7faeULL, 0x0005e2000c101c46ULL, 0x0000001b0c067210ULL, 0x082fe20007fde0ffULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x00005e003b0c7a11ULL, 0x040fe400078038ffULL,
0xfffffff816167812ULL, 0x000fe200078ee211ULL, 0x000000ffff077224ULL, 0x000fe200030e0615ULL,
0x0000001b12087210ULL, 0x080fe20007fde0ffULL, 0x0000001018117824ULL, 0x100fe200078e020bULL,
0x0000001b0a0a7210ULL, 0x080fe20007f9e0ffULL, 0x0000001016157824ULL, 0x000fe200078e020bULL,
0x00000000060f7faeULL, 0x0003e2000c901c46ULL, 0x00005f003b057a11ULL, 0x004fe200000f3c0eULL,
0x000000ffff097224ULL, 0x000fe200030e0614ULL, 0x0000001b0c047210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fc600020e0610ULL, 0x0000000008117faeULL, 0x0003e2000d101c46ULL,
0x000000ffff057224ULL, 0x000fc600000e0605ULL, 0x000000000a137faeULL, 0x0003e8000e901c46ULL,
0x0000000004157faeULL, 0x0003e2000d901c46ULL, 0x00000d6000007947ULL, 0x000fea0003800000ULL,
0x0000000c3d087811ULL, 0x042fe400078fe8ffULL, 0x000000043d047811ULL, 0x040fe400078fe8ffULL,
0x000000083d067811ULL, 0x040fe200078fe8ffULL, 0x0000000108097824ULL, 0x140fe200078e023dULL,
0x000000103d0a7811ULL, 0x040fe200078fe8ffULL, 0x00000008081a7824ULL, 0x000fe200078e00ffULL,
0x0000001c3d117811ULL, 0x040fe200078fe8ffULL, 0x0000000104057824ULL, 0x040fe200078e023dULL,
0x000000203d127811ULL, 0x040fe200078fe8ffULL, 0x0000000804167824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL, 0x0000000106077824ULL, 0x040fe200078e023dULL,
0x000000143d097811ULL, 0x040fe200078fe8ffULL, 0x0000000806187824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee205ULL, 0x000000010a057824ULL, 0x040fe200078e023dULL,
0x000000183d0e7811ULL, 0x000fe200078fe8ffULL, 0x000000080a1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee207ULL, 0x0000000109077824ULL, 0x000fe200078e023dULL,
0x000000283d197811ULL, 0x000fe200078fe8ffULL, 0x00000008091e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL, 0x0000000111057824ULL, 0x000fe200078e023dULL,
0x0000002c3d1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000811227824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL, 0x0000000112077824ULL, 0x040fe200078e023dULL,
0x000000243d177811ULL, 0x040fe200078fe8ffULL, 0x0000000812487824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x000000010e0b7824ULL, 0x040fe200078e023dULL,
0x000000343d1f7811ULL, 0x000fe200078fe8ffULL, 0x000000080e207824ULL, 0x000fe200078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee207ULL, 0x0000000119057824ULL, 0x100fe200078e023dULL,
0x000000383d217811ULL, 0x000fe200078fe8ffULL, 0x00000008194c7824ULL, 0x000fe200078e00ffULL,
0x0000003a3d367211ULL, 0x000fe200078fe8ffULL, 0x000000011b077824ULL, 0x040fe200078e023dULL,
0xfffffff820207812ULL, 0x000fe200078ee20bULL, 0x000000081b4e7824ULL, 0x000fe200078e00ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee205ULL, 0x000000013a327824ULL, 0x000fe200078e0204ULL,
0x000000303d1d7811ULL, 0x000fe200078fe8ffULL, 0x00000001170b7824ULL, 0x040fe200078e023dULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee207ULL, 0x00000008174a7824ULL, 0x000fe200078e00ffULL,
0x0000003b32327210ULL, 0x080fe20007f3e0ffULL, 0x000000011f057824ULL, 0x040fe200078e023dULL,
0x0000003b36367210ULL, 0x000fe20007f1e0ffULL, 0x000000081f527824ULL, 0x000fe200078e00ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee20bULL, 0x0000000121077824ULL, 0x000fc400078e023dULL,
0x0000000821567824ULL, 0x000fe200078e00ffULL, 0xfffffff852527812ULL, 0x000fe200078ee205ULL,
0x000000011d0b7824ULL, 0x040fe400078e023dULL, 0x000000081d507824ULL, 0x000fe200078e00ffULL,
0xfffffff856567812ULL, 0x000fe200078ee207ULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005e0032307a11ULL, 0x000fe200078238ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e0036347a11ULL, 0x000fe200078038ffULL, 0x000000013a087824ULL, 0x000fe200078e0208ULL,
0xfffffff850507812ULL, 0x000fe200078ee20bULL, 0x000000013a2e7824ULL, 0x000fe200078e0206ULL,
0x00005f0032327a11ULL, 0x000fe200008f3c05ULL, 0x000000013a067824ULL, 0x000fe200078e020aULL,
0x00005f0036367a11ULL, 0x000fe200000f3c07ULL, 0x000000013a0c7824ULL, 0x000fe200078e0209ULL,
0x0000003b080b7210ULL, 0x080fe20007f3e0ffULL, 0x000000013a107824ULL, 0x000fe200078e020eULL,
0x0000003b2e2e7210ULL, 0x080fe20007f1e0ffULL, 0x000000013a127824ULL, 0x000fe200078e0212ULL,
0x0000003b060d7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff047224ULL, 0x000fe200008e06ffULL,
0x00005e000b0a7a11ULL, 0x040fe200078238ffULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x00005e002e087a11ULL, 0x000fe200078038ffULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0x00005f000b0b7a11ULL, 0x000fe200008f3c04ULL, 0x000000013a2c7824ULL, 0x000fe200078e021dULL,
0x00005f002e2e7a11ULL, 0x000fe200000f3c05ULL, 0x000000013a287824ULL, 0x000fe200078e021bULL,
0x0000003b0c0f7210ULL, 0x080fe20007f3e0ffULL, 0x000000013a267824ULL, 0x040fe200078e0219ULL,
0x00005e000d0c7a11ULL, 0x040fe200078038ffULL, 0x000000013a2a7824ULL, 0x000fe200078e021fULL,
0x0000003b12157210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff047224ULL, 0x000fe200008e06ffULL,
0x00005f000d0d7a11ULL, 0x000fe200000f3c06ULL, 0x000000013a067824ULL, 0x040fe200078e0211ULL,
0x00005e000f0e7a11ULL, 0x000fe200078238ffULL, 0x000000013a547824ULL, 0x000fe200078e0221ULL,
0x0000003b10117210ULL, 0x000fc40007f1e0ffULL, 0x00005f000f0f7a11ULL, 0x000fe400008f3c04ULL,
0x0000003b06137210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005e0011107a11ULL, 0x000fe400078038ffULL, 0x0000003d3d057211ULL, 0x000fe200078fe8ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0013127a11ULL, 0x000fe400078238ffULL,
0x00005f0011117a11ULL, 0x000fe200000f3c04ULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x00005f0013137a11ULL, 0x000fe200008f3c06ULL, 0x0000000225067824ULL, 0x000fe200078e0246ULL,
0x00005e0015147a11ULL, 0x000fc400078038ffULL, 0x0000003c3d077811ULL, 0x000fe400078fe8ffULL,
0x00005f0015157a11ULL, 0x000fe400000f3c04ULL, 0x0000100006477811ULL, 0x000fe200078e68ffULL,
0x000000013a067824ULL, 0x000fe200078e0217ULL, 0x0000000705047812ULL, 0x000fe200078ec0ffULL,
0x0000000107057824ULL, 0x140fe200078e023dULL, 0x0000003b2c2c7210ULL, 0x080fe20007f3e0ffULL,
0x00000008075a7824ULL, 0x000fe200078e00ffULL, 0x0ffffff804047812ULL, 0x000fe200078ef83dULL,
0x000000013a587824ULL, 0x000fe200078e0207ULL, 0x0000003b06177210ULL, 0x080fe20007fde0ffULL,
0x00000010161f7824ULL, 0x100fe200078e0247ULL, 0x0000003b281b7210ULL, 0x080fe20007f1e0ffULL,
0x00000010041d7824ULL, 0x000fe200078e0247ULL, 0xfffffff85a067812ULL, 0x000fe200078ee205ULL,
0x000000ffff047224ULL, 0x000fe200030e06ffULL, 0x00005e0017167a11ULL, 0x000fe200078c38ffULL,
0x000000101c277824ULL, 0x100fe200078e0247ULL, 0x0000003b26197210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x0000003b2a2a7210ULL, 0x080fe20007f5e0ffULL,
0x000000103d077824ULL, 0x000fe200078e00ffULL, 0x0000003b54287210ULL, 0x080fe20007f7e0ffULL,
0x0000001018217824ULL, 0x100fe200078e0247ULL, 0x00005e002c1c7a11ULL, 0x000fe200078238ffULL,
0x000000101a237824ULL, 0x100fe200078e0247ULL, 0x0000003b58267210ULL, 0x000fe20007f9e0ffULL,
0x000000101e297824ULL, 0x100fe200078e0247ULL, 0x00005f0017177a11ULL, 0x000fe200030f3c04ULL,
0x00000010202b7824ULL, 0x000fe200078e0247ULL, 0x00005f002c2c7a11ULL, 0x000fe200008f3c05ULL,
0x00000010222d7824ULL, 0x100fe200078e0247ULL, 0x0000007007497812ULL, 0x000fe200078ec0ffULL,
0x00000010482f7824ULL, 0x100fe200078e0247ULL, 0x00005e002a1e7a11ULL, 0x000fe200078238ffULL,
0x000000104a317824ULL, 0x000fc400078e0247ULL, 0x000000104c337824ULL, 0x100fe400078e0247ULL,
0x000000104e357824ULL, 0x100fe400078e0247ULL, 0x0000001050377824ULL, 0x100fe400078e0247ULL,
0x00000010523b7824ULL, 0x100fe400078e0247ULL, 0x0000001056457824ULL, 0x100fe400078e0247ULL,
0x0000001006477824ULL, 0x000fc400078e0247ULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078038ffULL, 0x000000ffff067224ULL, 0x000fe200028e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078a38ffULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00005e0028207a11ULL, 0x000fe200078438ffULL, 0x000000ffff077224ULL, 0x000fe200018e06ffULL,
0x00005e0026227a11ULL, 0x000fe200078638ffULL, 0x000000ffff057224ULL, 0x000fe200020e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe400000f3c04ULL, 0x00005f0019197a11ULL, 0x000fc400028f3c06ULL,
0x0000004934047210ULL, 0x080fe40007f1e0ffULL, 0x00005f002a2a7a11ULL, 0x000fe400008f3c09ULL,
0x00005f0028287a11ULL, 0x000fe400010f3c07ULL, 0x0000004930067210ULL, 0x080fe40007f3e0ffULL,
0x00005f0026267a11ULL, 0x000fe200018f3c05ULL, 0x000000ffff057224ULL, 0x000fe200000e0636ULL,
0x0000004908087210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0632ULL,
0x000000490a0a7210ULL, 0x000fc40007f7e0ffULL, 0x000000490c0c7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200010e062eULL, 0x000000490e0e7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e060bULL, 0x0000004910107210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000004912127210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e060fULL, 0x0000004914147210ULL, 0x080fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041d7faeULL, 0x0003e2000b901c46ULL,
0x0000004916167210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000004918187210ULL, 0x080fe20007fbe0ffULL, 0x00000000061f7faeULL, 0x0005e2000b901c46ULL,
0x000000491a1a7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x000000491c1c7210ULL, 0x080fe20007f1e0ffULL, 0x0000000008217faeULL, 0x0007e2000b901c46ULL,
0x000000491e1e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x0000004920207210ULL, 0x080fe20007f5e0ffULL, 0x000000000a237faeULL, 0x0009e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fe200018e0617ULL, 0x0000004922227210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x000000000c277faeULL, 0x0009e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fc400020e061bULL, 0x000000ffff1d7224ULL, 0x002fe200000e062cULL,
0x000000000e297faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x004fe400008e062aULL,
0x000000ffff217224ULL, 0x008fe200010e0628ULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x010fc600018e0626ULL, 0x00000000122d7faeULL, 0x0003e8000b901c46ULL,
0x00000000142f7faeULL, 0x0003e8000b901c46ULL, 0x0000000016317faeULL, 0x0003e8000b901c46ULL,
0x0000000018337faeULL, 0x0003e8000b901c46ULL, 0x000000001a357faeULL, 0x0003e8000b901c46ULL,
0x000000001c377faeULL, 0x0003e8000b901c46ULL, 0x000000001e3b7faeULL, 0x0003e8000b901c46ULL,
0x0000000020457faeULL, 0x0003e8000b901c46ULL, 0x0000000022477faeULL, 0x0003e4000b901c46ULL,
0x0000000439397810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff3b7424ULL, 0x002fc400078e00ffULL, 0x000000023900720cULL, 0x000fe20003f06070ULL,
0x000000ffff457224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fd4000001ff00ULL, 0x000000023c048824ULL, 0x000fe400078e0239ULL,
0x00000004ff058424ULL, 0x000fc800078e00ffULL, 0x0000600004048625ULL, 0x000fe200078e0005ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000006043b8981ULL, 0x000322000c1e1900ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x002fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83d267812ULL, 0x000fe200078ec0ffULL, 0x00000002252c7824ULL, 0x020fe200078e0242ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000203d2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000726267812ULL, 0x000fe400078ef83dULL, 0x000010002c2c7811ULL, 0x000fe400078e68ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000126277824ULL, 0x040fe200078e0245ULL,
0x0000000145337810ULL, 0x000fe20007ffe0ffULL, 0x0000000826287824ULL, 0x000fe200078e00ffULL,
0x000000072e2e7812ULL, 0x000fe200078ef83dULL, 0x0000000826297824ULL, 0x040fe200078e00ffULL,
0x000000073de47812ULL, 0x000fe200078ec0ffULL, 0x0000000126267824ULL, 0x000fe200078e0233ULL,
0xfffffff828277812ULL, 0x000fe200078ee227ULL, 0x000000082e307824ULL, 0x000fe200078e00ffULL,
0x00000004ffe27819ULL, 0x000fc4000001163dULL, 0xfffffff829297812ULL, 0x000fe200078ee226ULL,
0x0000001027277824ULL, 0x000fe200078e022cULL, 0x00000008e4e37812ULL, 0x000fc600078ef83dULL,
0x0000001029297824ULL, 0x000fe200078e022cULL, 0x000000002734783bULL, 0x000e6a0000000200ULL,
0x000000002928783bULL, 0x000ea20000000200ULL, 0x00000018ff2d7819ULL, 0x002fe20000011434ULL,
0x0000003400af7306ULL, 0x000fe20000009400ULL, 0x00000018ff317819ULL, 0x000fe20000011436ULL,
0x0001000034577824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe20000011435ULL,
0x0001000035587824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fc40000011437ULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000002d00a97306ULL, 0x000fe20000209400ULL,
0x00000018ff487819ULL, 0x004fe40000011428ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff4e7819ULL, 0x000fe4000001142aULL, 0x00000018ff497819ULL, 0x000fe20000011429ULL,
0x0000002d00a87306ULL, 0x000e620000205400ULL, 0x00000018ff4f7819ULL, 0x000fce000001142bULL,
0x0000002d00277306ULL, 0x0004f0000020d400ULL, 0x00000031009f7306ULL, 0x000fe20000209400ULL,
0x000000012e2d7824ULL, 0x004fe200078e0245ULL, 0x000000a8a900720bULL, 0x002fc80003f9d000ULL,
0xfffffff8302d7812ULL, 0x000fe400078ee22dULL, 0x0000003100a07306ULL, 0x000fe60000205400ULL,
0x000000102d307824ULL, 0x000fe400078e022cULL, 0x000000012e2d7824ULL, 0x040fe400078e0233ULL,
0x000000082e2e7824ULL, 0x000fe200078e00ffULL, 0x0000003100847306ULL, 0x0003e2000020d400ULL,
0x0000000127274812ULL, 0x008fc600078efcffULL, 0xfffffff82e2d7812ULL, 0x000fc800078ee22dULL,
0x0000003400ac7306ULL, 0x000ea20000005400ULL, 0x000000003030783bULL, 0x002e620000000200ULL,
0x000000102d2d7824ULL, 0x000fcc00078e022cULL, 0x0000003400907306ULL, 0x0006b0000000d400ULL,
0x0000003500a27306ULL, 0x000fe20000009400ULL, 0x0000010034347824ULL, 0x008fe200078e00ffULL,
0x000000acaf00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500a77306ULL, 0x000eae0000005400ULL, 0x0000000190905812ULL, 0x000fe200078efcffULL,
0x00000035008e7306ULL, 0x000670000000d400ULL, 0x0000005700b67306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x008fe200078e00ffULL, 0x000000a7a200720bULL, 0x004fc80003f7d000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000005700b97306ULL, 0x000eae0000205400ULL,
0x000000018e8e3812ULL, 0x002fe200078efcffULL, 0x00000057009d7306ULL, 0x0002e2000020d400ULL,
0x000000a09f00720bULL, 0x000fce0003f7d000ULL, 0x0000003600a37306ULL, 0x000fe20000009400ULL,
0x0001000036577824ULL, 0x002fe200078e00ffULL, 0x000000b9b600720bULL, 0x004fe20003fdd000ULL,
0x00000010e3b97824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000036009e7306ULL, 0x000e620000005400ULL, 0x0000000184843812ULL, 0x000fcc00078efcffULL,
0x000000019d9d6812ULL, 0x008fe200078efcffULL, 0x0000003600887306ULL, 0x0004f0000000d400ULL,
0x0000003400bb7306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x0000009ea300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003400b87306ULL, 0x000e6e0000205400ULL, 0x0000000188885812ULL, 0x008fe200078efcffULL,
0x0000003400a67306ULL, 0x0004f0000020d400ULL, 0x0000003500bc7306ULL, 0x000fe20000209400ULL,
0x0001000037347824ULL, 0x004fe200078e00ffULL, 0x000000b8bb00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500c17306ULL, 0x000e6e0000205400ULL,
0x00000001a6a60812ULL, 0x008fe200078efcffULL, 0x00000035008f7306ULL, 0x0004e6000020d400ULL,
0x000000a62727723eULL, 0x000fca00000010ffULL, 0x0000003700a17306ULL, 0x000fe20000009400ULL,
0x00000018ff357819ULL, 0x004fe40000011430ULL, 0x000000c1bc00720bULL, 0x002fca0003fdd000ULL,
0x00000037009c7306ULL, 0x000e700000005400ULL, 0x00000037007c7306ULL, 0x000462000000d400ULL,
0x000000018f8f6812ULL, 0x008fce00078efcffULL, 0x0000002f00aa7306ULL, 0x000fe20000209400ULL,
0x0000010037377824ULL, 0x004fe200078e00ffULL, 0x0000009ca100720bULL, 0x002fc80003f9d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000002f00ab7306ULL, 0x000e6e0000205400ULL,
0x000000017c7c4812ULL, 0x000fe200078efcffULL, 0x0000002f008c7306ULL, 0x0004f0000020d400ULL,
0x0000003500d07306ULL, 0x000fe20000209400ULL, 0x000000002d2c783bULL, 0x004ea20000000200ULL,
0x000000abaa00720bULL, 0x002fcc0003f3d000ULL, 0x0000003500d37306ULL, 0x000fee0000205400ULL,
0x000000018c8c1812ULL, 0x008fe200078efcffULL, 0x0000003500767306ULL, 0x0003f0000020d400ULL,
0x0000002800967306ULL, 0x000fe20000009400ULL, 0x0001000028357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000002800977306ULL, 0x000ff00000005400ULL,
0x0000002800567306ULL, 0x0003e2000000d400ULL, 0x00000018ff607819ULL, 0x004fe2000001142cULL,
0x000100002ca87824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fc4000001142fULL,
0x00000018ff647819ULL, 0x000fe4000001142eULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000003600ca7306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000003600cd7306ULL, 0x000ff00000205400ULL,
0x0000003600897306ULL, 0x0003f0000020d400ULL, 0x0000003400cc7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fce0000011431ULL, 0x0000003400cf7306ULL, 0x000e700000205400ULL,
0x0000003400877306ULL, 0x0004f0000020d400ULL, 0x0000005700c47306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fc40000011432ULL, 0x000000cfcc00720bULL, 0x002fca0003f3d000ULL,
0x0000005700c77306ULL, 0x000e700000205400ULL, 0x00000057008d7306ULL, 0x000462000020d400ULL,
0x0000000187871812ULL, 0x008fc800078efcffULL, 0x0000007c877c723eULL, 0x000fc600000010ffULL,
0x0000003700ce7306ULL, 0x000fe20000209400ULL, 0x000100002a577824ULL, 0x004fe200078e00ffULL,
0x000000c7c400720bULL, 0x002fcc0003f1d000ULL, 0x0000003700d17306ULL, 0x000e6e0000205400ULL,
0x000000018d8d0812ULL, 0x000fe200078efcffULL, 0x00000037007d7306ULL, 0x0004e6000020d400ULL,
0x000000888d88723eULL, 0x000fca00000010ffULL, 0x0000003600d57306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x004fe40000011433ULL, 0x000000d1ce00720bULL, 0x002fca0003f1d000ULL,
0x0000003600d27306ULL, 0x000ff00000205400ULL, 0x0000003600717306ULL, 0x0003e2000020d400ULL,
0x000000017d7d0812ULL, 0x008fe400078efcffULL, 0x000000d3d000720bULL, 0x000fca0003f1d000ULL,
0x0000003400c97306ULL, 0x000fe20000209400ULL, 0x0001000029367824ULL, 0x002fce00078e00ffULL,
0x0000003400c87306ULL, 0x000fe20000205400ULL, 0x0000000176760812ULL, 0x000fce00078efcffULL,
0x00000034006e7306ULL, 0x000ff0000020d400ULL, 0x0000002a00937306ULL, 0x000ff00000009400ULL,
0x0000002a00947306ULL, 0x000ff00000005400ULL, 0x0000002a00517306ULL, 0x0003f0000000d400ULL,
0x0000002800cb7306ULL, 0x000fe20000209400ULL, 0x000001002a2a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002800c67306ULL, 0x000ff00000205400ULL,
0x0000002800347306ULL, 0x0003f0000020d400ULL, 0x0000003700c57306ULL, 0x000fe20000209400ULL,
0x00000018ff287819ULL, 0x002fce0000011457ULL, 0x0000003700c07306ULL, 0x000ff00000205400ULL,
0x0000003700637306ULL, 0x0003f0000020d400ULL, 0x0000005800bd7306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x002fce0000011436ULL, 0x0000005800ba7306ULL, 0x000e700000205400ULL,
0x0000005800ad7306ULL, 0x000eb0000020d400ULL, 0x00000028007f7306ULL, 0x000fe20000209400ULL,
0x000000babd00720bULL, 0x002fce0003f5d000ULL, 0x0000002800827306ULL, 0x000fec0000205400ULL,
0x00000001adad2812ULL, 0x004fe400078efcffULL, 0x0000002800587306ULL, 0x0003e2000020d400ULL,
0x000000cdca00720bULL, 0x000fce0003f5d000ULL, 0x0000003700bf7306ULL, 0x000fe20000209400ULL,
0x000100002b287824ULL, 0x002fca00078e00ffULL, 0x0000000189892812ULL, 0x000fe400078efcffULL,
0x0000003700be7306ULL, 0x000fe40000205400ULL, 0x000000898489723eULL, 0x000fcc00000010ffULL,
0x0000003700367306ULL, 0x000ff0000020d400ULL, 0x0000002a00867306ULL, 0x000ff00000209400ULL,
0x0000002a00857306ULL, 0x000ff00000205400ULL, 0x0000002a00377306ULL, 0x0003f0000020d400ULL,
0x0000003000b57306ULL, 0x000fe20000009400ULL, 0x00000018ff2a7819ULL, 0x002fe20000011428ULL,
0x0001000030287824ULL, 0x000fcc00078e00ffULL, 0x0000003000b27306ULL, 0x000e700000005400ULL,
0x0000003000757306ULL, 0x0004f0000000d400ULL, 0x0000003100b07306ULL, 0x000fe20000009400ULL,
0x0000010030307824ULL, 0x004fe200078e00ffULL, 0x000000b2b500720bULL, 0x002fc80003fbd000ULL,
0x00000018ffd67819ULL, 0x000fe20000011430ULL, 0x0001000031307824ULL, 0x000fe200078e00ffULL,
0x0000003100b17306ULL, 0x000e680000005400ULL, 0x00000018ffd97819ULL, 0x000fc60000011430ULL,
0x0000000175755812ULL, 0x008fe200078efcffULL, 0x0000003100727306ULL, 0x0004f0000000d400ULL,
0x0000002900957306ULL, 0x000fe20000009400ULL, 0x0000010031317824ULL, 0x004fe200078e00ffULL,
0x000000b1b000720bULL, 0x002fc80003f7d000ULL, 0x00000018ffde7819ULL, 0x000fe20000011431ULL,
0x0001000032317824ULL, 0x000fe200078e00ffULL, 0x0000002900927306ULL, 0x000fe80000005400ULL,
0x00000018ffe07819ULL, 0x000fc60000011431ULL, 0x0000000172723812ULL, 0x008fe200078efcffULL,
0x0000002900537306ULL, 0x0003e2000000d400ULL, 0x000000c8c900720bULL, 0x000fce0003f7d000ULL,
0x0000003200b37306ULL, 0x000fe20000009400ULL, 0x0000010029297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000003200ae7306ULL, 0x000e620000005400ULL,
0x000000016e6e3812ULL, 0x000fce00078efcffULL, 0x00000032006c7306ULL, 0x0004f0000000d400ULL,
0x0000004700a47306ULL, 0x000fe20000209400ULL, 0x0000010032327824ULL, 0x004fe200078e00ffULL,
0x000000aeb300720bULL, 0x002fc80003f3d000ULL, 0x00000018ffe17819ULL, 0x000fe20000011432ULL,
0x0001000033327824ULL, 0x000fe200078e00ffULL, 0x0000004700a57306ULL, 0x000e6e0000205400ULL,
0x000000016c6c1812ULL, 0x008fe200078efcffULL, 0x0000003500c27306ULL, 0x000ff00000209400ULL,
0x0000003500c37306ULL, 0x000fe20000205400ULL, 0x000000a5a400720bULL, 0x002fce0003fdd000ULL,
0x0000003500697306ULL, 0x000ff0000020d400ULL, 0x0000002900b77306ULL, 0x000ff00000209400ULL,
0x0000002900b47306ULL, 0x000ff00000205400ULL, 0x0000002900357306ULL, 0x0003f0000020d400ULL,
0x00000060006f7306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x002fce000001142dULL,
0x0000006000707306ULL, 0x000ff00000205400ULL, 0x0000006000577306ULL, 0x000ff0000020d400ULL,
0x00000077005f7306ULL, 0x000ff00000209400ULL, 0x0000007700607306ULL, 0x000ff00000205400ULL,
0x0000007700617306ULL, 0x0003f0000020d400ULL, 0x000000de00da7306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x002fce0000011428ULL, 0x000000de00dd7306ULL, 0x000e700000205400ULL,
0x000000de00307306ULL, 0x0005f0000020d400ULL, 0x0000004700787306ULL, 0x000ee2000020d400ULL,
0x00000018ffde7819ULL, 0x004fe20000011432ULL, 0x0000010033327824ULL, 0x000fe200078e00ffULL,
0x000000ddda00720bULL, 0x002fca0003fbd000ULL, 0x0000002b00267306ULL, 0x000ff00000009400ULL,
0x0000002b00917306ULL, 0x000e620000005400ULL, 0x0000000178786812ULL, 0x008fe400078efcffULL,
0x000000d2d500720bULL, 0x000fc40003fdd000ULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x0000007d787d723eULL, 0x000fe200000010ffULL, 0x0000002b00507306ULL, 0x0004f0000000d400ULL,
0x0000002900597306ULL, 0x000fe20000209400ULL, 0x000001002b2b7824ULL, 0x004fe200078e00ffULL,
0x0000000171716812ULL, 0x000fc400078efcffULL, 0x000000912600720bULL, 0x002fe40003f7d000ULL,
0x00000018ff797819ULL, 0x000fe4000001142bULL, 0x00000029005a7306ULL, 0x000fe20000205400ULL,
0x000000909d26723eULL, 0x000fe200000010ffULL, 0x000100002e907824ULL, 0x000fca00078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011490ULL, 0x00000029005b7306ULL, 0x000fe2000020d400ULL,
0x0000000150503812ULL, 0x008fce00078efcffULL, 0x0000007700297306ULL, 0x000ff00000209400ULL,
0x0000007700287306ULL, 0x000e700000205400ULL, 0x00000077007a7306ULL, 0x000eb0000020d400ULL,
0x000000e000db7306ULL, 0x000fe20000209400ULL, 0x000000282900720bULL, 0x002fe20003f5d000ULL,
0x000100002d297824ULL, 0x000fca00078e00ffULL, 0x00000018ffa37819ULL, 0x000fe20000011429ULL,
0x000000e000d87306ULL, 0x000fec0000205400ULL, 0x000000017a7a2812ULL, 0x004fe400078efcffULL,
0x000000e000777306ULL, 0x0003e4000020d400ULL, 0x000000757a7a723eULL, 0x000fcc00000010ffULL,
0x0000002a00687306ULL, 0x000fe20000209400ULL, 0x00000018ffe07819ULL, 0x002fe20000011432ULL,
0x0000000245327824ULL, 0x040fe200078e02e2ULL, 0x0000000245457810ULL, 0x000fc60007ffe0ffULL,
0x00000001e3b67824ULL, 0x140fe200078e0232ULL, 0x00000002e3327810ULL, 0x040fe20007ffe032ULL,
0x0000002a006b7306ULL, 0x000fe20000205400ULL, 0x00000010e3e37824ULL, 0x000fe400078e00ffULL,
0xfffffff0b9b67812ULL, 0x000fc600078ee2b6ULL, 0xfffffff0e3ac7812ULL, 0x000fe400078ee232ULL,
0x0000002a00657306ULL, 0x000fe2000020d400ULL, 0x00000010b6287824ULL, 0x000fce00078e00ffULL,
0x000000d6002a7306ULL, 0x000ff00000209400ULL, 0x000000d6002b7306ULL, 0x000e700000205400ULL,
0x00000064005c7306ULL, 0x000ff00000209400ULL, 0x00000064005d7306ULL, 0x000fe20000205400ULL,
0x0000002b2a00720bULL, 0x002fc40003f9d000ULL, 0x000000002828783bULL, 0x000e6a0000000200ULL,
0x00000064005e7306ULL, 0x000ff0000020d400ULL, 0x0000007900647306ULL, 0x000ff00000209400ULL,
0x0000007900677306ULL, 0x000ff00000205400ULL, 0x0000007900667306ULL, 0x000ff0000020d400ULL,
0x00000033009a7306ULL, 0x000fe20000009400ULL, 0x000000262808723cULL, 0x042bee0000041808ULL,
0x00000033009b7306ULL, 0x000e620000005400ULL, 0x000000882820723cULL, 0x040fee0000041820ULL,
0x0000003300627306ULL, 0x000ea2000000d400ULL, 0x0000007c281c723cULL, 0x000fee000004181cULL,
0x000000d6007b7306ULL, 0x000ee2000020d400ULL, 0x0000009b9a00720bULL, 0x002fce0003fbd000ULL,
0x000000d900d47306ULL, 0x000fec0000209400ULL, 0x0000000162625812ULL, 0x004fe400078efcffULL,
0x000000d900d77306ULL, 0x000e620000205400ULL, 0x000000017b7b4812ULL, 0x008fe400078efcffULL,
0x000000d8db00720bULL, 0x000fc40003f9d000ULL, 0x000000c3c200720bULL, 0x000fe40003fbd000ULL,
0x0000007b767b723eULL, 0x000fe200000010ffULL, 0x000000d900797306ULL, 0x000eac000020d400ULL,
0x0000007a2818723cULL, 0x000fe40000041818ULL, 0x000000e100df7306ULL, 0x000fe20000209400ULL,
0x000000d7d400720bULL, 0x002fc40003f5d000ULL, 0x0000000177774812ULL, 0x000fe400078efcffULL,
0x000000929500720bULL, 0x000fe40003f9d000ULL, 0x0000000169695812ULL, 0x000fe200078efcffULL,
0x000000e100dc7306ULL, 0x000e620000205400ULL, 0x000000bebf00720bULL, 0x000fca0003fbd000ULL,
0x0000000179792812ULL, 0x004fe400078efcffULL, 0x000000e100317306ULL, 0x000ea2000020d400ULL,
0x000000979600720bULL, 0x000fe20003f5d000ULL, 0x000001002f967824ULL, 0x000fe200078e00ffULL,
0x0000000153534812ULL, 0x000fe400078efcffULL, 0x000000827f00720bULL, 0x000fe40003f9d000ULL,
0x000000727972723eULL, 0x000fe200000010ffULL, 0x000000de00d67306ULL, 0x000fe20000209400ULL,
0x000000dcdf00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x0000000136365812ULL, 0x000fe400078efcffULL, 0x0000000156562812ULL, 0x000fe200078efcffULL,
0x000000de00d97306ULL, 0x000e640000205400ULL, 0x0000000158584812ULL, 0x000fc800078efcffULL,
0x0000000131310812ULL, 0x004fe400078efcffULL, 0x000000de00337306ULL, 0x000ea2000020d400ULL,
0x000000949300720bULL, 0x000fe20003f1d000ULL, 0x000100002f947824ULL, 0x000fe200078e00ffULL,
0x000000316e31723eULL, 0x000fc800000010ffULL, 0x00000018ff947819ULL, 0x000fe20000011494ULL,
0x000000e000e17306ULL, 0x000fe20000209400ULL, 0x000000d9d600720bULL, 0x002fca0003fdd000ULL,
0x0000000151510812ULL, 0x000fe400078efcffULL, 0x000000e000de7306ULL, 0x000e6c0000205400ULL,
0x0000000133336812ULL, 0x004fe400078efcffULL, 0x000000e000327306ULL, 0x000ea2000020d400ULL,
0x000000c0c500720bULL, 0x000fc40003fdd000ULL, 0x000000623362723eULL, 0x000fe400000010ffULL,
0x000000dee100720bULL, 0x002fc60003f3d000ULL, 0x0000004800987306ULL, 0x000fec0000209400ULL,
0x0000000163636812ULL, 0x000fe400078efcffULL, 0x0000004800997306ULL, 0x000e640000205400ULL,
0x0000000132321812ULL, 0x004fc400078efcffULL, 0x000000c6cb00720bULL, 0x000fc80003f3d000ULL,
0x0000004f00477306ULL, 0x000fe20000209400ULL, 0x000000326363723eULL, 0x000fce00000010ffULL,
0x0000004f00527306ULL, 0x000fe20000205400ULL, 0x000000999800720bULL, 0x002fe20003fdd000ULL,
0x00000062280c723cULL, 0x000fe2000004180cULL, 0x0000000134341812ULL, 0x000fe400078efcffULL,
0x000000b4b700720bULL, 0x000fc60003f3d000ULL, 0x0000004f004b7306ULL, 0x000ff0000020d400ULL,
0x0000002c00837306ULL, 0x000fe40000009400ULL, 0x0000000135351812ULL, 0x000fc400078efcffULL,
0x000000858600720bULL, 0x000fc80003f3d000ULL, 0x0000002c007e7306ULL, 0x000e700000005400ULL,
0x0000002c004f7306ULL, 0x0004e2000000d400ULL, 0x0000000137371812ULL, 0x000fce00078efcffULL,
0x0000004e00807306ULL, 0x000fe20000209400ULL, 0x000001002c2c7824ULL, 0x004fe200078e00ffULL,
0x0000007e8300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000004e00817306ULL, 0x000fee0000205400ULL, 0x000000014f4f5812ULL, 0x008fe200078efcffULL,
0x0000004e004c7306ULL, 0x000ff0000020d400ULL, 0x0000002d00747306ULL, 0x000ff00000009400ULL,
0x0000002d00737306ULL, 0x000ff00000005400ULL, 0x0000002d004e7306ULL, 0x0003f0000000d400ULL,
0x00000048004d7306ULL, 0x000ea2000020d400ULL, 0x000001002d2d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff917819ULL, 0x000fe4000001142dULL, 0x0000002c009f7306ULL, 0x000fe20000209400ULL,
0x0000008f8c2d723eULL, 0x000fce00000010ffULL, 0x0000002c00a07306ULL, 0x000e620000205400ULL,
0x000000014d4d6812ULL, 0x004fe400078efcffULL, 0x000000818000720bULL, 0x000fe40003fdd000ULL,
0x000000344d27723eULL, 0x020fe400000010ffULL, 0x000000533634723eULL, 0x000fe200000010ffULL,
0x0000002c009e7306ULL, 0x0004e2000020d400ULL, 0x000000515836723eULL, 0x000fce00000010ffULL,
0x00000049008a7306ULL, 0x000fe20000209400ULL, 0x0000008ead2c723eULL, 0x004fe400000010ffULL,
0x000000014c4c6812ULL, 0x000fe400078efcffULL, 0x000000a09f00720bULL, 0x002fe40003f3d000ULL,
0x000000706f00720bULL, 0x000fe20003fdd000ULL, 0x00000049008b7306ULL, 0x000e620000205400ULL,
0x0000002c2804723cULL, 0x000b620000041804ULL, 0x000000374c37723eULL, 0x000fcc00000010ffULL,
0x00000049004a7306ULL, 0x000ea2000020d400ULL, 0x00000010ac2c7824ULL, 0x020fe200078e00ffULL,
0x000000019e9e1812ULL, 0x008fe400078efcffULL, 0x0000000157576812ULL, 0x000fe400078efcffULL,
0x0000006b6800720bULL, 0x000fe40003f3d000ULL, 0x0000002e006a7306ULL, 0x000fe20000009400ULL,
0x0000008b8a00720bULL, 0x002fe40003f5d000ULL, 0x000000524700720bULL, 0x000fc40003fdd000ULL,
0x0000009e5757723eULL, 0x000fc600000010ffULL, 0x0000002e006d7306ULL, 0x000e660000005400ULL,
0x0000000165651812ULL, 0x000fe400078efcffULL, 0x0000005a5900720bULL, 0x000fe40003f3d000ULL,
0x000000014a4a2812ULL, 0x004fe200078efcffULL, 0x0000002e00497306ULL, 0x0004e2000000d400ULL,
0x000000737400720bULL, 0x000fe40003f5d000ULL, 0x000000307173723eULL, 0x000fc400000010ffULL,
0x0000006c7730723eULL, 0x000fe400000010ffULL, 0x000000014b4b6812ULL, 0x000fe200078efcffULL,
0x0000002f00547306ULL, 0x000fe20000009400ULL, 0x000001002e2e7824ULL, 0x004fe200078e00ffULL,
0x0000006d6a00720bULL, 0x002fe20003f1d000ULL, 0x000000722814723cULL, 0x000f620000041814ULL,
0x000000015b5b1812ULL, 0x000fe400078efcffULL, 0x00000018ff267819ULL, 0x000fe4000001142eULL,
0x0000002f00557306ULL, 0x000e620000005400ULL, 0x000000014e4e2812ULL, 0x000fc400078efcffULL,
0x000000302810723cULL, 0x000b620000041810ULL, 0x000000605f00720bULL, 0x000fe40003f5d000ULL,
0x000000354a35723eULL, 0x000fe400000010ffULL, 0x0000002f00487306ULL, 0x000462000000d400ULL,
0x0000000149490812ULL, 0x008fe400078efcffULL, 0x000000084500780cULL, 0x000fe40003f05270ULL,
0x00000050654a723eULL, 0x000fc600000010ffULL, 0x000000a800a27306ULL, 0x000fe20000209400ULL,
0x000000002c2c783bULL, 0x004ea20000000200ULL, 0x000000555400720bULL, 0x002fe40003fbd000ULL,
0x0000000161612812ULL, 0x000fc800078efcffULL, 0x000000a800a17306ULL, 0x000e6e0000205400ULL,
0x0000000148485812ULL, 0x000fe200078efcffULL, 0x000000a8009c7306ULL, 0x000ef0000020d400ULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x000000a1a200720bULL, 0x002fce0003f9d000ULL,
0x000000a300977306ULL, 0x000e6c0000205400ULL, 0x000000019c9c4812ULL, 0x008fe400078efcffULL,
0x000000a300937306ULL, 0x000ee2000020d400ULL, 0x000000342c04723cULL, 0x044f6e0000041804ULL,
0x0000009100927306ULL, 0x000fe20000209400ULL, 0x00000097a400720bULL, 0x002fe20003f9d000ULL,
0x000000362c20723cULL, 0x000f6c0000041820ULL, 0x0000009100957306ULL, 0x000e6c0000205400ULL,
0x0000000193934812ULL, 0x008fc400078efcffULL, 0x00000090008a7306ULL, 0x000fe20000209400ULL,
0x000000676400720bULL, 0x000fe40003f9d000ULL, 0x0000004e934e723eULL, 0x000fca00000010ffULL,
0x0000009000817306ULL, 0x000ea20000205400ULL, 0x000000959200720bULL, 0x002fca0003f7d000ULL,
0x0000000166664812ULL, 0x000fe400078efcffULL, 0x0000002600747306ULL, 0x000fe20000209400ULL,
0x0000005d5c00720bULL, 0x000fe40003f9d000ULL, 0x000000664b4b723eULL, 0x000fca00000010ffULL,
0x00000026006d7306ULL, 0x000fe20000205400ULL, 0x000000818a00720bULL, 0x004fe20003fdd000ULL,
0x0000004a2c1c723cULL, 0x000f68000004181cULL, 0x000000015e5e4812ULL, 0x000fe400078efcffULL,
0x0000002600797306ULL, 0x0003f0000020d400ULL, 0x00000091008e7306ULL, 0x000ea2000020d400ULL,
0x000000566926723eULL, 0x002fc400000010ffULL, 0x0000004f9c56723eULL, 0x000fca00000010ffULL,
0x0000009000787306ULL, 0x000e62000020d400ULL, 0x000000262c08723cULL, 0x040b6e0000041808ULL,
0x0000009400307306ULL, 0x020fe20000209400ULL, 0x000000018e8e3812ULL, 0x004fe200078efcffULL,
0x000000562c18723cULL, 0x000b620000041818ULL, 0x0000006d7400720bULL, 0x000fc40003f7d000ULL,
0x0000008e5b4f723eULL, 0x000fc600000010ffULL, 0x0000009400297306ULL, 0x000ea20000205400ULL,
0x0000000178786812ULL, 0x002fc600078efcffULL, 0x0000004e2c14723cULL, 0x000b620000041814ULL,
0x000000497878723eULL, 0x000fc600000010ffULL, 0x0000009600267306ULL, 0x000fe20000209400ULL,
0x0000000179793812ULL, 0x000fc800078efcffULL, 0x000000795e79723eULL, 0x000fc600000010ffULL,
0x00000096002b7306ULL, 0x000e620000205400ULL, 0x000000293000720bULL, 0x004fc60003f3d000ULL,
0x000000782c10723cULL, 0x000b680000041810ULL, 0x0000009400277306ULL, 0x000eb0000020d400ULL,
0x0000009600967306ULL, 0x000ee2000020d400ULL, 0x0000002b2600720bULL, 0x002fc40003fdd000ULL,
0x0000000127271812ULL, 0x004fc800078efcffULL, 0x000000482748723eULL, 0x000fce00000010ffULL,
0x0000000196966812ULL, 0x008fc800078efcffULL, 0x000000966149723eULL, 0x000fce00000010ffULL,
0x000000482c0c723cULL, 0x000b62000004180cULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe11000007947ULL, 0x000fcc000383ffffULL, 0x0000003e06287220ULL, 0x080fe40000410000ULL,
0x0000003e07297220ULL, 0x080fe40000410000ULL, 0x0000003e18187220ULL, 0x0a0fe40000410000ULL,
0x0000003e19197220ULL, 0x080fe40000410000ULL, 0x0000003e08087220ULL, 0x080fe40000410000ULL,
0x0000003e09097220ULL, 0x000fc40000410000ULL, 0x0000003e04047220ULL, 0x080fe40000410000ULL,
0x0000003e05057220ULL, 0x080fe40000410000ULL, 0x0000003e20207220ULL, 0x080fe40000410000ULL,
0x0000003e21217220ULL, 0x080fe40000410000ULL, 0x0000003e1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003e1d1d7220ULL, 0x000fc40000410000ULL, 0x0000003e14147220ULL, 0x080fe40000410000ULL,
0x0000003e15157220ULL, 0x080fe40000410000ULL, 0x0000003e10067220ULL, 0x080fe40000410000ULL,
0x0000003e11077220ULL, 0x080fe40000410000ULL, 0x0000003e1a2c7220ULL, 0x080fe40000410000ULL,
0x0000003e1b2d7220ULL, 0x000fc40000410000ULL, 0x0000003e12307220ULL, 0x080fe40000410000ULL,
0x0000003e13317220ULL, 0x080fe40000410000ULL, 0x0000003e0a267220ULL, 0x080fe40000410000ULL,
0x0000003e0b277220ULL, 0x080fe40000410000ULL, 0x0000003e162e7220ULL, 0x080fe40000410000ULL,
0x0000003e172f7220ULL, 0x000fc40000410000ULL, 0x0000003e0c1a7220ULL, 0x080fe40000410000ULL,
0x0000003e0d1b7220ULL, 0x080fe40000410000ULL, 0x0000003e0e327220ULL, 0x080fe40000410000ULL,
0x0000003e0f337220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fe400078e0018ULL,
0x000000ffff137224ULL, 0x000fc400078e0019ULL, 0x0000003e22227220ULL, 0x080fe40000410000ULL,
0x0000003e23237220ULL, 0x080fe40000410000ULL, 0x0000003e1e2a7220ULL, 0x080fe40000410000ULL,
0x0000003e1f2b7220ULL, 0x000fe40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0009ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0005ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff107224ULL, 0x000fe400078e001cULL,
0x000000ffff117224ULL, 0x000fc400078e001dULL, 0x000000ffff167224ULL, 0x000fe400078e0014ULL,
0x000000ffff177224ULL, 0x000fe400078e0015ULL, 0x000000ffff187224ULL, 0x000fe400078e0006ULL,
0x000000ffff197224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003f087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe400078e0026ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0027ULL, 0x000000ffff207224ULL, 0x000fe400078e0022ULL,
0x000000ffff217224ULL, 0x000fe400078e0023ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0029ULL, 0x000000ffff227224ULL, 0x000fe400078e002aULL,
0x000000ffff237224ULL, 0x000fc400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0031ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0033ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004003f077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604157210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003f077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000043d157824ULL, 0x000fe200078e00ffULL, 0x000000404300720cULL, 0x000fc80003f05270ULL,
0xfffffff015147812ULL, 0x000fca00078ec0ffULL, 0x0000008025147824ULL, 0x000fca00078e0214ULL,
0x0174000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000023d087824ULL, 0x000fe400078e00ffULL, 0x0000000103447824ULL, 0x000fc600078e0a44ULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x00000001092f7812ULL, 0x040fe400078efcffULL,
0x0000000809317812ULL, 0x000fe400078efcffULL, 0x000000442f00720cULL, 0x080fe40003f26070ULL,
0x00000010092f7812ULL, 0x000fe400078efcffULL, 0x000000443100720cULL, 0x080fe40003f06070ULL,
0x000000442f00720cULL, 0x000fc40003fc6070ULL, 0x0000001109317812ULL, 0x040fe400078efcffULL,
0x00000018092f7812ULL, 0x040fe400078efcffULL, 0x000000440900720cULL, 0x080fe40003f46070ULL,
0x000000443100720cULL, 0x080fe40003fa6070ULL, 0x000000442f00720cULL, 0x000fe40003f66070ULL,
0x0000000909337812ULL, 0x000fc400078efcffULL, 0x0000001909317812ULL, 0x040fe400078efcffULL,
0x00000020092f7812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x000000443300720cULL, 0x080fe40003f86070ULL,
0x000000443100720cULL, 0x080fe40003f46070ULL, 0x000000442f00720cULL, 0x000fe40003f26070ULL,
0x0000002109317812ULL, 0x040fe400078efcffULL, 0x00000028092f7812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000443100720cULL, 0x080fe40003f06070ULL, 0x000000442f00720cULL, 0x000fe40003f86070ULL,
0x0000002909317812ULL, 0x000fc400078efcffULL, 0x00000030092f7812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000443100720cULL, 0x000fc40003fc6070ULL, 0x000000442f00720cULL, 0x000fe40003fa6070ULL,
0x0000003109317812ULL, 0x040fe400078efcffULL, 0x00000038092f7812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000026267808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000443100720cULL, 0x080fe40003f66070ULL,
0x000000442f00720cULL, 0x000fc40003f46070ULL, 0x000000440900720cULL, 0x000fe40003f26070ULL,
0xff80000027277808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff80000028287808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000029297808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff8000002b2b7808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000002c2c7808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fe40003f3e000ULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000090c047208ULL, 0x000fe40004000000ULL, 0x000000051e087208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x000000040d057208ULL, 0x000fe40004000000ULL, 0x000000081f097208ULL, 0x000fc40004800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fc40003f3e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x0000000821097208ULL, 0x000fe40004800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fe40003f3e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x0000000922087208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fe40004800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fc40003f3e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x0000000926087208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fe40003f3e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x0000000827097208ULL, 0x000fc40004800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x0000000516047208ULL, 0x000fe40004000000ULL, 0x0000000928087208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000290800720bULL, 0x000fc40003f3e000ULL,
0x0000000417057208ULL, 0x000fe40004000000ULL, 0x0000000829097208ULL, 0x000fe40004800000ULL,
0x000000180500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000518047208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x0000000419057208ULL, 0x000fe40004000000ULL, 0x000000082b097208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x0000002c0900720bULL, 0x000fc40003f3e000ULL,
0x000000051a047208ULL, 0x000fe40004000000ULL, 0x000000092c087208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002d0800720bULL, 0x000fe40003f3e000ULL,
0x000000041b307208ULL, 0x000fe40004000000ULL, 0x000000082d327208ULL, 0x000fe20004800000ULL,
0x000017d27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0030047f89ULL, 0x0004e400000e0000ULL,
0x000000043000720bULL, 0x008fc80003f1e000ULL, 0x0000003004337208ULL, 0x000fe20004000000ULL,
0x000018027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0032047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000e6800000e0000ULL, 0x0c401f00072e7f89ULL, 0x000ea200000e0000ULL,
0x000000043200720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x002fe40003f3e000ULL,
0x0000003204087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f0033047f89ULL, 0x000e6200000e0000ULL, 0x0000002e0700720bULL, 0x004fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000ea200000e0000ULL, 0x000000072e2e7208ULL, 0x000fc60004000000ULL,
0x0c201f0009307f89ULL, 0x000ee800000e0000ULL, 0x0c201f002e2f7f89ULL, 0x0002e400000e0000ULL,
0x000000043300720bULL, 0x002fe40003f1e000ULL, 0x000000050800720bULL, 0x004fe40003f3e000ULL,
0x0000003304047208ULL, 0x000fc40004000000ULL, 0x000000300900720bULL, 0x008fe40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x0000000930067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b05307820ULL, 0x002fe20000410000ULL, 0x00000002ff317819ULL, 0x000fe2000001163dULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x000000033dff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x0000002f2e00720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b0d0d7823ULL, 0x000fe20000010807ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fc40000010830ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010830ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe40000010830ULL,
0x00000004ff347e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3f8000003434783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b10107823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b11117823ULL, 0x000fe40000010807ULL,
0x000000ffff357224ULL, 0x000fe400078e0034ULL, 0x0000000d000d7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b20207823ULL, 0x000fc40000010830ULL, 0x3fb8aa3b21217823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b22227823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b23237823ULL, 0x000fe20000010830ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x000000080908723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b16167823ULL, 0x000fc40000010807ULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b17177823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010830ULL,
0x0000001e000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b29297823ULL, 0x000fc40000010830ULL, 0x3fb8aa3b18187823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL, 0x0000001f00327308ULL, 0x000ea20000000800ULL,
0x0000001c1d09723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b2b2b7823ULL, 0x000fe40000010830ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b077823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fe40000010830ULL,
0x0000000831307824ULL, 0x040fe200078e00ffULL, 0x0000000b320b723eULL, 0x004fe200000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000000831337824ULL, 0x040fe400078e00ffULL,
0x0000000831377824ULL, 0x000fc600078e00ffULL, 0x00000034081c723cULL, 0x000f6400000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fe400000010ffULL,
0x0000000131107810ULL, 0x000fca0007ffe0ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x00000020210d723eULL, 0x002fe200000010ffULL,
0x0000000831217824ULL, 0x040fe200078e00ffULL, 0x0000000431207810ULL, 0x000fc80007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000022230f723eULL, 0x004fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000000831237824ULL, 0x040fe400078e00ffULL, 0x0000000831227824ULL, 0x000fe200078e00ffULL,
0x000000340c1c723cULL, 0x020f68000004181cULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000161712723eULL, 0x004fe400000010ffULL, 0x0000000231167810ULL, 0x000fc40007ffe0ffULL,
0x0000000331177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee216ULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x000000262711723eULL, 0x002fc400000010ffULL, 0xfffffff822277812ULL, 0x000fe400078ee217ULL,
0x0000000631227810ULL, 0x040fe40007ffe0ffULL, 0xffffffff31267810ULL, 0x000fe20007ffe0ffULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0xfffffff830177812ULL, 0x000fe400078ee231ULL,
0x000000282913723eULL, 0x004fca00000010ffULL, 0x0000001900197308ULL, 0x000e620000000800ULL,
0x0000000831297824ULL, 0x040fe200078e00ffULL, 0x0000000831287810ULL, 0x000fe20007ffe0ffULL,
0x00000034101c723cULL, 0x020b66000004181cULL, 0xfffffff829297812ULL, 0x000fe400078ee220ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x0000000531207810ULL, 0x000fe20007ffe0ffULL,
0x0000000828457824ULL, 0x000fc400078e00ffULL, 0x0000000831357824ULL, 0x020fe200078e00ffULL,
0xfffffff833317812ULL, 0x000fc600078ee220ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x000000181918723eULL, 0x002fe400000010ffULL, 0x0001100025207811ULL, 0x000fe400078e58ffULL,
0xfffffff835337812ULL, 0x000fe400078ee222ULL, 0xfffffff837357812ULL, 0x000fe200078ee226ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000001017177824ULL, 0x100fe400078e0220ULL,
0x0000001021217824ULL, 0x000fc400078e0220ULL, 0x0000001023237824ULL, 0x100fe400078e0220ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x0000002a2b19723eULL, 0x004fe200000010ffULL, 0x000000ffff2a7224ULL, 0x100fe400078e0034ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0034ULL, 0x0000001029297824ULL, 0x100fe400078e0220ULL,
0x0000002c001b7308ULL, 0x000fe20000000800ULL, 0x0000001031317824ULL, 0x000fc400078e0220ULL,
0x0000001033337824ULL, 0x100fe400078e0220ULL, 0x0000001035357824ULL, 0x000fc600078e0220ULL,
0x0000002d00167308ULL, 0x0004e20000000800ULL, 0x0000001a071a723eULL, 0x002fe400000010ffULL,
0x0000002e2f077208ULL, 0x000fe40004800000ULL, 0xfffffff8452d7812ULL, 0x004fca00078ee228ULL,
0x000000102d2d7824ULL, 0x000fe200078e0220ULL, 0x0000001b161b723eULL, 0x008fe400000010ffULL,
0x0000000c15167812ULL, 0x000fca00078ec0ffULL, 0x0000002a181c723cULL, 0x000f62000004181cULL,
0x0000000117177824ULL, 0x000fe400078e0216ULL, 0x0000000116217824ULL, 0x040fe400078e0221ULL,
0x0000000116237824ULL, 0x040fe200078e0223ULL, 0x0000000817007388ULL, 0x0003e20000000800ULL,
0x0000000116277824ULL, 0x040fe400078e0227ULL, 0x0000000116297824ULL, 0x040fe200078e0229ULL,
0x0000000a21007388ULL, 0x0003e20000000800ULL, 0x0000000116317824ULL, 0x000fc400078e0231ULL,
0x0000000116337824ULL, 0x040fe200078e0233ULL, 0x0000000c23007388ULL, 0x0003e20000000800ULL,
0x0000000116357824ULL, 0x040fe400078e0235ULL, 0x0000000116167824ULL, 0x000fe200078e022dULL,
0x0000000e27007388ULL, 0x0003e80000000800ULL, 0x0000001029007388ULL, 0x0003e40000000800ULL,
0x000000ffff1d7224ULL, 0x020fc400078e001eULL, 0x0000001231007388ULL, 0x0003e80000000800ULL,
0x0000001833007388ULL, 0x0003e80000000800ULL, 0x0000001a35007388ULL, 0x0003e80000000800ULL,
0x0000000916007388ULL, 0x0003e80000000800ULL, 0x0004000b21007388ULL, 0x0003e80000000800ULL,
0x0004000d23007388ULL, 0x0003e80000000800ULL, 0x0004000f27007388ULL, 0x0003e80000000800ULL,
0x0004001129007388ULL, 0x0003e80000000800ULL, 0x0004001331007388ULL, 0x0003e80000000800ULL,
0x0004001933007388ULL, 0x0003e80000000800ULL, 0x0004001b35007388ULL, 0x0003e80000000800ULL,
0x0170000414008388ULL, 0x0003e80000000c00ULL, 0x0172001c14008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000041ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080041ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100041ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000143437810ULL, 0x000fe20007ffe0ffULL,
0x0000180041ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff427224ULL, 0x000fc400078e0046ULL,
0x000000004300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffa67000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff3e7807ULL, 0x008fe20004000000ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x00017e2000437802ULL, 0x000fc40000000f00ULL, 0x0000100000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff397224ULL, 0x000fe200078e0042ULL, 0xfffea57000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x000fe20004000000ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x00017e8000437802ULL, 0x000fc40000000f00ULL, 0x00000fa000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff397224ULL, 0x000fe200078e0042ULL, 0xfffea5a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff447224ULL, 0x000fe200078e003cULL, 0x00017f00003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff437224ULL, 0x008fe400078e0041ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000ee000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x004fe200078e0043ULL, 0xfffea63000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e0041ULL, 0x00017f80003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff447224ULL, 0x002fe400078e003cULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000e6000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x004fe200078e0043ULL, 0xfffea72000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e0039ULL, 0x00018000003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff447224ULL, 0x000fc400078e003aULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000de000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff377224ULL, 0x004fe200078e0043ULL, 0xfffeab1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff447224ULL, 0x002fe200078e0038ULL, 0x00018080003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff437224ULL, 0x000fe400078e0039ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000d6000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff387224ULL, 0x004fe200078e0043ULL, 0xfffeaac000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x004fe20004000000ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x000180e000437802ULL, 0x000fc40000000f00ULL, 0x00000d4000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e0042ULL, 0xfffedc6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff3e7807ULL, 0x000fe20004000000ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x0001814000437802ULL, 0x000fc40000000f00ULL, 0x00000ce000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff407224ULL, 0x000fe200078e0042ULL, 0xfffedca000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e0047ULL, 0x000181b0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000c3000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e0043ULL,
0xfffedd5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff437224ULL, 0x000fe200078e0047ULL,
0x00018220003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000bc000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e0043ULL, 0xfffede4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e003cULL, 0x000182a0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff447224ULL, 0x000fe400078e003dULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x00000b4000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff377224ULL, 0x004fe200078e0043ULL, 0xfffee23000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e003cULL, 0x00018310003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x00000ad000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e0043ULL,
0xfffee1f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x004fe20004000000ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x0001837000437802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0042ULL,
0xffff109000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x000fe20004000000ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x000183d000437802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x018fea0003c00000ULL, 0xffff10e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e0041ULL, 0x00018430003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x000009b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e0043ULL,
0xffff11a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff437224ULL, 0x000fe200078e0041ULL,
0x000184a0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000094000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e0043ULL, 0xffff129000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e003cULL, 0x00018520003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff447224ULL, 0x000fe400078e003dULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000008c000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff377224ULL, 0x004fe200078e0043ULL, 0xffff168000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e003cULL, 0x00018590003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000085000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e0043ULL,
0xffff164000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x004fe20004000000ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x000185f000437802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff277224ULL, 0x000fe200078e0042ULL,
0xffff454000007947ULL, 0x000fea000383ffffULL, 0x00000001ff3e7807ULL, 0x000fe20004000000ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x0001865000437802ULL, 0x000fc40000000f00ULL,
0x000007d000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0042ULL,
0xffff458000007947ULL, 0x000fea000383ffffULL, 0x000000ffff437224ULL, 0x000fe200078e003bULL,
0x000186c0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fc400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0043ULL, 0xffff463000007947ULL, 0x000fea000383ffffULL,
0x000000ffff437224ULL, 0x000fe200078e003bULL, 0x00018730003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff457424ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0043ULL,
0xffff472000007947ULL, 0x000fea000383ffffULL, 0x000000ffff437224ULL, 0x000fe200078e0024ULL,
0x000187b0003e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff447224ULL, 0x000fe400078e0027ULL,
0x0000001fff457424ULL, 0x000fc400078e00ffULL, 0xffffffffff467424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e0043ULL,
0xffff4b0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff437224ULL, 0x000fe200078e0024ULL,
0x00018820003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff457424ULL, 0x000fe400078e00ffULL,
0xffffffffff467424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff387224ULL, 0x004fe200078e0043ULL, 0xffff4ac000007947ULL, 0x000fea000383ffffULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x0001889000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002fULL,
0xffffe7d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x006fe200078e0032ULL,
0x0001891000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fc400078e00ffULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x010fea0003c00000ULL, 0x0000002f3200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e0006ULL, 0x0001899000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x000000322f327208ULL, 0x000fe20004000000ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e0007ULL, 0x00018a1000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x000000062f067208ULL, 0x000fe20004000000ULL,
0x0000001fff2f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e0033ULL, 0x00018a9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x000000072f2e7208ULL, 0x000fe20004000000ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000002f3300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e0032ULL, 0x00018b1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x000000332f047208ULL, 0x000fe20004000000ULL,
0x0000001fff2f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x0000002f3200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e0006ULL, 0x00018b9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x000000322f057208ULL, 0x000fe20004000000ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e002eULL, 0x00018c1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x000000062f067208ULL, 0x000fe20004000000ULL,
0x0000001fff2f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe5c000007947ULL, 0x000fea000383ffffULL,
0x018000002e007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002e00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff2eff7812ULL, 0x040fe4000780c0ffULL, 0x800000002e027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002e00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe726002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003400007348ULL, 0x000fe80003800000ULL,
0x0c000031302f7389ULL, 0x0002a200000e002fULL, 0xfffe722008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000004600007348ULL, 0x000fe80003800000ULL,
0x0000004443437389ULL, 0x0002a200000e0045ULL, 0xfffe71e03e007950ULL, 0x000fea0003c3ffffULL,
0x000000013e00780cULL, 0x000fe20003f05070ULL, 0x0000003f00007348ULL, 0x000fd80003800000ULL,
0x00000000003e7806ULL, 0x000fc800040e0100ULL, 0x0000003f3e427212ULL, 0x000fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe400078e0043ULL, 0x00000000ff3f7424ULL, 0x000fc800078e00ffULL,
0xfffe71703e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x00000000000003d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000da8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e68ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001600ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001690ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001694ULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000018f80ULL, 0xea00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a800ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a850ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001abd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001690ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019170ULL, 0x0000000000019170ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001a800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001abd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 109744;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
