/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018b50ULL, 0x00000000000187d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x386a4c4536316a4cULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL,
0x5f30326d735f6164ULL, 0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL,
0x7265746e695f5f24ULL, 0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL,
0x796c66625f636e79ULL, 0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL,
0x68735f30376d735fULL, 0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL,
0x75635f5f245f335fULL, 0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL,
0x632e766e2e006675ULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL,
0x756265642e006d61ULL, 0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL,
0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL,
0x000000000000006eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b8ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000406ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044bULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000491ULL, 0x0000000000016c30ULL,
0x0000000000000180ULL, 0x000b0022000004c4ULL, 0x0000000000016db0ULL, 0x0000000000000040ULL,
0x000b0022000004efULL, 0x0000000000016df0ULL, 0x0000000000000050ULL, 0x000b002200000519ULL,
0x0000000000016e40ULL, 0x0000000000000140ULL, 0x000a000300000587ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005a7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005d7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000016f80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00016c3000000000ULL,
0x0000040400000000ULL, 0x810c000001340400ULL, 0x0059cc0400288080ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9708288080820828ULL, 0x2880809b08288080ULL,
0x80b508288080a408ULL, 0x08288080ba082880ULL, 0x8080c008288080bbULL, 0xc708288080c20828ULL,
0x288080c808288080ULL, 0x808408288080c908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080849200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00016c3000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9308288080820828ULL,
0x2880809708288080ULL, 0x80a4082880809a08ULL, 0x08288080b2082880ULL, 0x8080ba08288080b5ULL,
0xc008288080bb0828ULL, 0x288080c208288080ULL, 0x80c908288080c808ULL, 0x1628808088082880ULL,
0x0000031028808280ULL, 0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000013800000000ULL, 0x00016db000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9308288080820828ULL, 0x2880809708288080ULL,
0x80a4082880809a08ULL, 0x08288080b5082880ULL, 0x8080bb08288080baULL, 0xc208288080c00828ULL,
0x288080c708288080ULL, 0x80c808288080c908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080c89200ULL, 0x0000002cffffffffULL, 0x000001f000000000ULL, 0x00016df000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x80c2288080c80900ULL, 0x0000000000002880ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9308288080820828ULL, 0x2880809708288080ULL,
0x80a4082880809a08ULL, 0x08288080b5082880ULL, 0x8080bb08288080baULL, 0xc708288080c00828ULL,
0x288080c808288080ULL, 0x80c208288080c908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080c29200ULL, 0x0000001cffffffffULL, 0x000002b000000000ULL, 0x00016e4000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001a00082f04ULL, 0x00082304000000dcULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x0134290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x0000012000000100ULL, 0x000023d000000400ULL, 0x0000259000002480ULL, 0x00002b7000002700ULL,
0x00002bf000002ba0ULL, 0x00005d6000002c40ULL, 0x00005f2000005e00ULL, 0x000064f000006080ULL,
0x0000657000006520ULL, 0x000093d0000065c0ULL, 0x000095a000009470ULL, 0x00009b7000009700ULL,
0x00009bf000009ba0ULL, 0x0000cac000009c40ULL, 0x0000cc800000cb60ULL, 0x0000d2400000cde0ULL,
0x0000d2c00000d270ULL, 0x0000f4800000d310ULL, 0x000154300000f490ULL, 0x0001548000015470ULL,
0x000154e000015490ULL, 0x0001552000015500ULL, 0x000161b000015530ULL, 0x0001625000016200ULL,
0x00016300000162a0ULL, 0x000163b000016360ULL, 0x0001645000016400ULL, 0x00016500000164a0ULL,
0x000165a000016550ULL, 0x00016630000165f0ULL, 0x000166e000016680ULL, 0x0001678000016730ULL,
0x00016820000167d0ULL, 0x000168d000016870ULL, 0x0001697000016920ULL, 0x00016a30000169d0ULL,
0x00016af000016a90ULL, 0x00016bb000016b50ULL, 0x0440390400016c10ULL, 0x000000ff00000220ULL,
0x003f01000000f600ULL, 0x0000000b000002b0ULL, 0x003f01200000f608ULL, 0x0000000b000002e0ULL,
0x003f01200000f688ULL, 0x0000000b000003b0ULL, 0x003f01200000f6a8ULL, 0x0000000b000003e0ULL,
0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000000700000600ULL,
0x003f010200000004ULL, 0x00000007000006b0ULL, 0x003f010100000000ULL, 0x000000ff000010a0ULL,
0x0004010700000000ULL, 0x000000ff00001120ULL, 0x0004010100000000ULL, 0x0000002c00001180ULL,
0x003f010100000020ULL, 0x0000003400001340ULL, 0x003f01050000f6ccULL, 0x0000003400001530ULL,
0x003f01050000f6ccULL, 0x0000003100001f40ULL, 0x003f01070000f6a8ULL, 0x0000003100002070ULL,
0x003f01010000f6a8ULL, 0x00000033000020d0ULL, 0x003f01010000f608ULL, 0x00000033000020f0ULL,
0x003f01050000f60cULL, 0x00000033000022c0ULL, 0x003f01050000f60cULL, 0x00000044000028d0ULL,
0x003f01050000f6acULL, 0x0000004400002aa0ULL, 0x003f01050000f6acULL, 0x0000004000004c50ULL,
0x003f01010000f6c8ULL, 0x0000005600004cd0ULL, 0x003f01010000f688ULL, 0x0000003000004d60ULL,
0x003f010500000004ULL, 0x0000003000004f30ULL, 0x003f010500000004ULL, 0x0000005700005930ULL,
0x003f01070000f6a8ULL, 0x0000005700005a60ULL, 0x003f01010000f6a8ULL, 0x0000003300005ac0ULL,
0x003f01010000f628ULL, 0x0000003300005ae0ULL, 0x003f01050000f62cULL, 0x0000003300005cb0ULL,
0x003f01050000f62cULL, 0x0000003100006250ULL, 0x003f01050000f6acULL, 0x0000003100006420ULL,
0x003f01050000f6acULL, 0x00000040000083c0ULL, 0x003f010100000000ULL, 0x0000005600008430ULL,
0x003f01010000f690ULL, 0x00000030000084a0ULL, 0x003f010500000004ULL, 0x0000003000008670ULL,
0x003f010500000004ULL, 0x0000005300008f70ULL, 0x003f010700000000ULL, 0x00000031000090d0ULL,
0x003f01010000f6a8ULL, 0x0000003300009130ULL, 0x003f01010000f648ULL, 0x0000003300009150ULL,
0x003f01050000f64cULL, 0x0000003300009320ULL, 0x003f01050000f64cULL, 0x00000057000098d0ULL,
0x003f01050000f6acULL, 0x0000005700009aa0ULL, 0x003f01050000f6acULL, 0x000000400000ba90ULL,
0x003f010100000000ULL, 0x000000560000bb00ULL, 0x003f01010000f698ULL, 0x000000300000bb90ULL,
0x003f010500000004ULL, 0x000000300000bd60ULL, 0x003f010500000004ULL, 0x000000580000c660ULL,
0x003f010700000000ULL, 0x000000570000c7c0ULL, 0x003f01010000f6a8ULL, 0x000000330000c820ULL,
0x003f01010000f668ULL, 0x000000330000c840ULL, 0x003f01050000f66cULL, 0x000000330000ca10ULL,
0x003f01050000f66cULL, 0x000000310000cfa0ULL, 0x003f01050000f6acULL, 0x000000310000d170ULL,
0x003f01050000f6acULL, 0x000000300000f080ULL, 0x003f010100000000ULL, 0x000000560000f0e0ULL,
0x003f01010000f6a0ULL, 0x000000ff000100b0ULL, 0x003f01010000f600ULL, 0x000000ff00010eb0ULL,
0x003f01050000f604ULL, 0x000000ff00011080ULL, 0x003f01050000f604ULL, 0x000000ff000112b0ULL,
0x003f01010000f600ULL, 0x000000ff000112e0ULL, 0x003f01050000f604ULL, 0x000000ff000114a0ULL,
0x003f01050000f604ULL, 0x0000003f00014830ULL, 0x003f010100000000ULL, 0x0000003f00014960ULL,
0x003f010500000004ULL, 0x0000003f00014b30ULL, 0x003f010500000004ULL, 0x0000004100016010ULL,
0x003f010100000000ULL, 0x0000004100016070ULL, 0x003f010100000008ULL, 0x00000041000160d0ULL,
0x003f010100000010ULL, 0x0000004100016140ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL,
0x0000ffd00000fd50ULL, 0x000115c000011500ULL, 0x0000040100016180ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000034cULL, 0x0000001a00000002ULL, 0x000000000000028cULL, 0x0000001a00000002ULL,
0x00000000000001dcULL, 0x0000001a00000002ULL, 0x000000000000010cULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x0000000000000329ULL, 0x0000001a00000002ULL,
0x0000000000000269ULL, 0x0000001a00000002ULL, 0x00000000000001b6ULL, 0x0000001a00000002ULL,
0x00000000000000e9ULL, 0x0000001a00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff277624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001000047300ULL, 0x000ee200000e0000ULL, 0x0000000827077824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000f220000002200ULL, 0x00000004ff2b7424ULL, 0x000fc600078e00ffULL,
0x0000000000247919ULL, 0x000ee20000000000ULL, 0x0000001000107309ULL, 0x000ea60000000000ULL,
0x0000000000287919ULL, 0x000ee80000002600ULL, 0x00000000003d7919ULL, 0x000ee20000002700ULL,
0x00000005ff257819ULL, 0x002fc6000001160bULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x00001fff03007589ULL, 0x0045e200000e0000ULL, 0x0000010003027a24ULL, 0x010fc600078e0202ULL,
0x00001fff25257589ULL, 0x000f2200000e0000ULL, 0x00000000020b7a24ULL, 0x000fe200078e020bULL,
0x00000004ff0c7819ULL, 0x008fe20000011624ULL, 0x00000010240d7824ULL, 0x000fe400078e00ffULL,
0x0000000828067824ULL, 0x000fe200078e00ffULL, 0x000000ff0b00720cULL, 0x040fe40003f45270ULL,
0x0000007f0b00780cULL, 0x000fe20003f84070ULL, 0x0000003d07087224ULL, 0x000fe200078e0206ULL,
0x0000000f0b00780cULL, 0x000fc40003f64070ULL, 0x000000030b00780cULL, 0x000fe40003f24070ULL,
0x000000050400720cULL, 0x002fe40003f02070ULL, 0x000000f00d0f7812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x004fe400078e00ffULL,
0x0000000400097824ULL, 0x010fe400078e0225ULL, 0xff317217ff0ec424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x0000000209097824ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f44070ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f4000e0b00c388ULL, 0x0005e20000004800ULL, 0x7fffffc0ff05b424ULL, 0x000fe200078e00ffULL,
0x00000008090a7817ULL, 0x000fe20007800000ULL, 0x3fffff60ff069424ULL, 0x000fc400078e00ffULL,
0x7fffff60ff079424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0007e20000008a00ULL,
0x000000010a0a7824ULL, 0x000fe400078e0a09ULL, 0x0000000109097824ULL, 0x000fe200078e020cULL,
0x00f688060b009388ULL, 0x0009e20000008a00ULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x0000000a0c00720cULL, 0x000fe20003f66070ULL, 0x0000000108027824ULL, 0x000fe400078e0209ULL,
0x00000001090e7824ULL, 0x004fc400078e0224ULL, 0x0000001009117824ULL, 0x000fe400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0xfffffff0110e7812ULL, 0x000fe200078ee20eULL,
0x3fffff80ff049424ULL, 0x008fe200078e00ffULL, 0x0000000f02027210ULL, 0x000fe20007f9e0ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x00f6a8040b009388ULL, 0x000fe20000008a00ULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100e077824ULL, 0x010fe200078e00ffULL,
0x00f6c8080b00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff067224ULL, 0x000fc600078e0a10ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e2000d901c46ULL, 0x000062003d047625ULL, 0x000fc600078e002bULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fc40003f05270ULL,
0x0000003f03027810ULL, 0x044fe40007ffe0ffULL, 0x000000ff03087810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff027819ULL, 0x000fe40000011602ULL, 0x00000008ff007819ULL, 0x000fca0000011608ULL,
0x0000fa9000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011625ULL,
0x00000003ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000f68825077811ULL, 0x000fe200078e18ffULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x03ffffff265b7812ULL, 0x000fc800078ec0ffULL,
0x000000025b00720cULL, 0x000fda0003f06070ULL, 0x000000023d048824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640004048624ULL, 0x000fc800078e0205ULL,
0x000000015b048824ULL, 0x000fe200078e0204ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040a07ff738cULL, 0x0003e20000000000ULL, 0x0000600004048625ULL, 0x000fe200078e002bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000604068981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000004028287824ULL, 0x000fe200078e00ffULL,
0x00000001ff277819ULL, 0x000fe20000011625ULL, 0x0000000007ff7f8cULL, 0x0007e8000c80043fULL,
0x0000002027297824ULL, 0x000fca00078e00ffULL, 0x0000002028087812ULL, 0x000fe200078ef829ULL,
0x0000580006097a24ULL, 0x004fe200078e02ffULL, 0x0000000125067812ULL, 0x000fc600078ec0ffULL,
0x0000004009137824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000001006057824ULL, 0x008fe200078e00ffULL, 0x0000002903047217ULL, 0x000fe40007800000ULL,
0x00000003ff067819ULL, 0x000fe40000011624ULL, 0x000000700d177812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a29ULL, 0x00000004060a7810ULL, 0x042fe20007ffe0ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x0000000c060e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000504047217ULL, 0x000fe20007800000ULL, 0x0000000107097824ULL, 0x040fe400078e0224ULL,
0x00000008070c7824ULL, 0x000fe400078e00ffULL, 0x0000000108077824ULL, 0x000fe400078e0207ULL,
0x0000000104047824ULL, 0x000fe200078e0a05ULL, 0xfffffff80c097812ULL, 0x000fe200078ee209ULL,
0x00000001050b7824ULL, 0x040fe200078e020aULL, 0x00000008060c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001050f7824ULL, 0x000fe200078e020eULL, 0x0000000713127210ULL, 0x000fe20007f1e0ffULL,
0x000000080b157824ULL, 0x000fe200078e00ffULL, 0x000000040600720cULL, 0x080fe20003f66070ULL,
0x0000000105077824ULL, 0x000fe200078e020cULL, 0x000000040a00720cULL, 0x080fe20003f46070ULL,
0x000000010b067824ULL, 0x000fe200078e0224ULL, 0x00005e00120a7a11ULL, 0x000fe200078838ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x000000040c00720cULL, 0x080fe20003f26070ULL,
0x00000001080b7824ULL, 0x000fe200078e020bULL, 0x000000040e00720cULL, 0x000fe20003f06070ULL,
0x0000000108047824ULL, 0x000fe200078e0207ULL, 0x00005f0012127a11ULL, 0x000fe200020f3c11ULL,
0x0000000108087824ULL, 0x000fe200078e020fULL, 0x0000000b13107210ULL, 0x000fe20007f9e0ffULL,
0x000000080f0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff815057812ULL, 0x000fe200078ee206ULL,
0x0000000107067824ULL, 0x100fe200078e0224ULL, 0x00000004130c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000000813087210ULL, 0x000fe20007fde0ffULL,
0x000000010f047824ULL, 0x000fc400078e0224ULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0x00005e00100e7a11ULL, 0x040fe200078838ffULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0xfffffff807077812ULL, 0x000fe400078ee206ULL, 0x0000b00027067811ULL, 0x000fe400078e68ffULL,
0xfffffff80b0b7812ULL, 0x000fe400078ee204ULL, 0x00005f0010107a11ULL, 0x000fe200020f3c0fULL,
0x00000010050f7824ULL, 0x100fe200078e0206ULL, 0x0000000a17047210ULL, 0x000fe20007f9e0ffULL,
0x0000001007117824ULL, 0x000fc400078e0206ULL, 0x00000010090d7824ULL, 0x000fe200078e0206ULL,
0x00005e000c097a11ULL, 0x000fe200078a38ffULL, 0x000000ffff077224ULL, 0x000fe200030e06ffULL,
0x00005e00080a7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff057224ULL, 0x000fe200020e0612ULL,
0x00005f000c0c7a11ULL, 0x000fe200028f3c15ULL, 0x000000100b137824ULL, 0x000fe200078e0206ULL,
0x000000170e067210ULL, 0x080fe40007f9e0ffULL, 0x00005f00080b7a11ULL, 0x000fe200030f3c07ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000d901c46ULL,
0x0000001709087210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200020e0610ULL,
0x000000170a0a7210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e060cULL,
0x00000000060f7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff0b7224ULL, 0x000fc600020e060bULL,
0x0000000008117faeULL, 0x0003e8000c901c46ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001006057824ULL, 0x008fe200078e00ffULL,
0x0000b00027157811ULL, 0x000fe400078e68ffULL, 0x000000700d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000524057211ULL, 0x000fc800078fe8ffULL, 0x0000000405077810ULL, 0x042fe20007ffe0ffULL,
0x0000000105047824ULL, 0x140fe400078e0224ULL, 0x0000000805097824ULL, 0x000fe400078e00ffULL,
0x0000000107067824ULL, 0x040fe400078e0224ULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0xfffffff809047812ULL, 0x000fe200078ee204ULL, 0x0000000108077824ULL, 0x000fe200078e0207ULL,
0x0000000805097810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80b067812ULL, 0x000fe200078ee206ULL,
0x00000010040f7824ULL, 0x000fe200078e0215ULL, 0x0000000c050b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108057824ULL, 0x040fe200078e0205ULL, 0x00000007130e7210ULL, 0x000fe20007f5e0ffULL,
0x00000001080a7824ULL, 0x000fe400078e0209ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000000513107210ULL, 0x000fe20007f3e0ffULL, 0x0000000109057824ULL, 0x100fe200078e0224ULL,
0x0000000a130c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b077824ULL, 0x000fc400078e0224ULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0xfffffff812057812ULL, 0x000fe200078ee205ULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e00100a7a11ULL, 0x000fe200078238ffULL,
0x0000000108087824ULL, 0x000fe200078e020bULL, 0xfffffff814077812ULL, 0x000fe200078ee207ULL,
0x0000001006117824ULL, 0x000fe200078e0215ULL, 0x00005f0010107a11ULL, 0x000fe200008f3c09ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x0000000813087210ULL, 0x000fe20007f1e0ffULL,
0x0000001005137824ULL, 0x100fe200078e0215ULL, 0x00005e000e067a11ULL, 0x000fe200078238ffULL,
0x0000001007157824ULL, 0x000fc400078e0215ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x00005f000e077a11ULL, 0x000fe200008f3c09ULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005e000c097a11ULL, 0x000fe400078438ffULL, 0x0000000a0d047210ULL, 0x040fe40007f3e0ffULL,
0x00005e00080a7a11ULL, 0x000fe400078638ffULL, 0x00005f000c0c7a11ULL, 0x000fe200010f3c05ULL,
0x000000ffff057224ULL, 0x000fe200008e0610ULL, 0x000000060d067210ULL, 0x000fc40007f1e0ffULL,
0x00005f00080b7a11ULL, 0x000fe400018f3c0bULL, 0x000000090d087210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000a0d0a7210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e4000b901c46ULL,
0x000000ffff097224ULL, 0x000fe400008e060cULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000006117faeULL, 0x0003e8000b901c46ULL, 0x0000000008137faeULL, 0x0003e8000b901c46ULL,
0x000000000a157faeULL, 0x0003e4000b901c46ULL, 0x000000015b5b7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff2a7424ULL, 0x000fc600078e00ffULL, 0x000000025b00720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x000000023d047824ULL, 0x002fe400078e00ffULL,
0x00006400ff057624ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0205ULL,
0x00000001042a7824ULL, 0x000fc800078e025bULL, 0x000060002a2a7625ULL, 0x000fcc00078e002bULL,
0x000000062a2a7981ULL, 0x000324000c1e1900ULL, 0x00000000270473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x000000ffff2b7224ULL, 0x002fe200078e00ffULL,
0x0000f6a8272c7811ULL, 0x000fe200078e18ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff5c7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020002c2c7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000df3000008947ULL, 0x000fea0003800000ULL, 0x000000023d2c7824ULL, 0x004fe400078e00ffULL,
0x00006400ff237624ULL, 0x000fc400078e00ffULL, 0x000000ffff447224ULL, 0x000fe400078e002dULL,
0x000064002c2c7624ULL, 0x000fe400078e0223ULL, 0xff317217ff5c7424ULL, 0x002fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff407224ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e00ffULL, 0x000001002d2e7824ULL, 0x000fca00078e00ffULL,
0x000000032e00720cULL, 0x000fda0003f06070ULL, 0x0000de4000000947ULL, 0x004fea0003800000ULL,
0x000000ffff2f7224ULL, 0x000fe400078e005bULL, 0x000000ffff2e7224ULL, 0x000fc400078e0040ULL,
0x0000000000327805ULL, 0x000fca0000015200ULL, 0x0000000425307824ULL, 0x000fca00078e00ffULL,
0xfffffff830347812ULL, 0x000fc800078ec0ffULL, 0x0000f6c834357810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc0034317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000022000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe400078e00ffULL, 0x000000ffff307224ULL, 0x000fe200078e0035ULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003032377210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e33ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff307819ULL, 0x000fc80000011431ULL,
0x0000003730307211ULL, 0x000fca00078110ffULL, 0x000000ffff317224ULL, 0x000fca00000e0631ULL,
0x0000000230307819ULL, 0x000fc80000001231ULL, 0x000000300000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc0034317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff307224ULL, 0x000fc400078e0035ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001025317824ULL, 0x000fe200078e00ffULL, 0x000000012d337810ULL, 0x000fe20007ffe0ffULL,
0x000058002a2a7a24ULL, 0x010fc600078e02ffULL, 0x000000003300720cULL, 0x000fe20003f06070ULL,
0x000000402a457824ULL, 0x000fe200078e00ffULL, 0xffffffe031327812ULL, 0x000fca00078ec0ffULL,
0x000001002d327824ULL, 0x000fca00078e0232ULL, 0x0000004032357810ULL, 0x000fe40007ffe0ffULL,
0x0000000140327812ULL, 0x000fe400078e0cffULL, 0x0000002028427812ULL, 0x000fe200078ef835ULL,
0x0000049000008947ULL, 0x000fea0003800000ULL, 0x0000001031317812ULL, 0x000fe200078ec0ffULL,
0x0000000227387824ULL, 0x000fe200078e0232ULL, 0x00000003ff3e7819ULL, 0x000fc80000011624ULL,
0x000000043e3f7810ULL, 0x040fe20007ffe0ffULL, 0x000000013e337824ULL, 0x000fe200078e0231ULL,
0x0000b00038387811ULL, 0x000fe400078e60ffULL, 0x000000083e447810ULL, 0x000fe20007ffe0ffULL,
0x00000001422a7824ULL, 0x000fe200078e0233ULL, 0x0000000c3e467810ULL, 0x000fe20007ffe0ffULL,
0x000000013f377824ULL, 0x000fe400078e0231ULL, 0x00000008333c7824ULL, 0x000fe200078e00ffULL,
0x0000002a453d7210ULL, 0x000fc40007f1e0ffULL, 0x00000035032a7217ULL, 0x000fc60007800000ULL,
0x000000ffff347224ULL, 0x000fe200000e06ffULL, 0x00005e003d367a11ULL, 0x000fe200078038ffULL,
0x000000012a2a7824ULL, 0x000fe400078e0a35ULL, 0x0000000133357824ULL, 0x000fe200078e0224ULL,
0x00005f003d3d7a11ULL, 0x000fe200000f3c34ULL, 0x0000001024347824ULL, 0x000fe200078e00ffULL,
0x000000312a2a7217ULL, 0x000fe40007800000ULL, 0xfffffff83c337812ULL, 0x000fe400078ee235ULL,
0x0000007034437812ULL, 0x000fe200078ec0ffULL, 0x0000000142347824ULL, 0x000fc400078e0237ULL,
0x000000012a2a7824ULL, 0x000fe400078e0a31ULL, 0x0000001033337824ULL, 0x000fe200078e0238ULL,
0x0000003445417210ULL, 0x000fe40007fde0ffULL, 0x0000002a3e00720cULL, 0x000fe40003f06070ULL,
0x0000004336347210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3c7224ULL, 0x000fe200030e06ffULL,
0x00005e0041367a11ULL, 0x000fc600078c38ffULL, 0x000000ffff357224ULL, 0x000fe200028e063dULL,
0x0000002a3f00720cULL, 0x000fe20003fa6070ULL, 0x00000001443f7824ULL, 0x000fe200078e0231ULL,
0x00005f0041417a11ULL, 0x000fe200030f3c3cULL, 0x00000001373c7824ULL, 0x040fe400078e0224ULL,
0x00000008373d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034337faeULL, 0x0003e2000c101c46ULL, 0x0000000142377824ULL, 0x000fe200078e023fULL,
0x0000004336367210ULL, 0x000fe20007f1e0ffULL, 0x0000000146317824ULL, 0x000fe200078e0231ULL,
0xfffffff83d3d7812ULL, 0x000fc400078ee23cULL, 0x00000037453e7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff377224ULL, 0x000fe200000e0641ULL, 0x0000002a4400720cULL, 0x000fe20003f06070ULL,
0x000000103d3d7824ULL, 0x000fe400078e0238ULL, 0x0000000142337824ULL, 0x002fe400078e0231ULL,
0x000000ffff357224ULL, 0x000fe200030e06ffULL, 0x00000000363d7faeULL, 0x0003e2000e901c46ULL,
0x00005e003e347a11ULL, 0x000fe400078a38ffULL, 0x00000033453c7210ULL, 0x000fc40007fde0ffULL,
0x00005f003e337a11ULL, 0x000fe200028f3c35ULL, 0x00000008313e7824ULL, 0x000fe200078e00ffULL,
0x0000002a4600720cULL, 0x000fe20003fa6070ULL, 0x000000ffff417224ULL, 0x000fe200030e06ffULL,
0x0000004334347210ULL, 0x000fe20007fde0ffULL, 0x000000013f2a7824ULL, 0x140fe400078e0224ULL,
0x000000083f3f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fe200030e0633ULL,
0x00005e003c367a11ULL, 0x002fe200078c38ffULL, 0x0000000131337824ULL, 0x000fe200078e0224ULL,
0xfffffff83f317812ULL, 0x000fc400078ee22aULL, 0x00005f003c2a7a11ULL, 0x000fe400030f3c41ULL,
0x0000004336367210ULL, 0x000fe20007fde0ffULL, 0x0000001031317824ULL, 0x000fe200078e0238ULL,
0xfffffff83e337812ULL, 0x000fc600078ee233ULL, 0x000000ffff377224ULL, 0x000fe200030e062aULL,
0x0000000034317faeULL, 0x0003e2000c101c46ULL, 0x0000001033337824ULL, 0x000fca00078e0238ULL,
0x0000000036337faeULL, 0x0003e2000e901c46ULL, 0x000003c000007947ULL, 0x000fea0003800000ULL,
0x0000001031317812ULL, 0x000fc800078ec0ffULL, 0x0000003124317211ULL, 0x000fc800078fe8ffULL,
0x0000000431357810ULL, 0x040fe20007ffe0ffULL, 0x00000001422a7824ULL, 0x040fe200078e0231ULL,
0x0000000c313d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000131337824ULL, 0x100fe400078e0224ULL,
0x0000000135347824ULL, 0x000fe200078e0224ULL, 0x0000002a45447210ULL, 0x000fe20007f1e0ffULL,
0x0000000835377824ULL, 0x000fe400078e00ffULL, 0x0000000142357824ULL, 0x040fe400078e0235ULL,
0x000000ffff3f7224ULL, 0x000fe200000e06ffULL, 0xfffffff8372a7812ULL, 0x000fe200078ee234ULL,
0x0000000142347824ULL, 0x000fe200078e023dULL, 0x0000000831377810ULL, 0x040fe20007ffe0ffULL,
0x0000000831367824ULL, 0x000fe200078e00ffULL, 0x00005e0044437a11ULL, 0x000fc400078038ffULL,
0x0000003545357210ULL, 0x000fe20007fde0ffULL, 0x0000000142317824ULL, 0x000fe200078e0237ULL,
0x00005f0044447a11ULL, 0x000fe200000f3c3fULL, 0x0000000837387824ULL, 0x000fe200078e00ffULL,
0x00000034453f7210ULL, 0x000fe20007f1e0ffULL, 0x000000013d347824ULL, 0x100fe200078e0224ULL,
0x0000003145427210ULL, 0x000fe20007fbe0ffULL, 0x000000083d3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff836337812ULL, 0x000fe200078ee233ULL, 0x0000000137317824ULL, 0x000fe400078e0224ULL,
0x000000ffff367224ULL, 0x000fe200030e06ffULL, 0x00005e0035377a11ULL, 0x000fc400078c38ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee234ULL, 0x0000001024347824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee231ULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x00005f0035417a11ULL, 0x000fe200030f3c36ULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x00005e00423c7a11ULL, 0x000fe400078a38ffULL, 0x0000007034457812ULL, 0x000fe400078ec0ffULL,
0x00005e003f3e7a11ULL, 0x000fc400078c38ffULL, 0x00005f0042427a11ULL, 0x000fe200028f3c31ULL,
0x0000000227317824ULL, 0x000fe200078e0232ULL, 0x0000004543347210ULL, 0x080fe40007f1e0ffULL,
0x00005f003f3f7a11ULL, 0x000fe400030f3c36ULL, 0x0000004537367210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe200000e0644ULL, 0x0000b00031437811ULL, 0x000fe400078e60ffULL,
0x000000453c3c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff377224ULL, 0x000fe200028e0641ULL,
0x000000453e3e7210ULL, 0x000fe20007fbe0ffULL, 0x0000001033337824ULL, 0x000fc400078e0243ULL,
0x000000102a317824ULL, 0x100fe400078e0243ULL, 0x0000001038417824ULL, 0x100fe200078e0243ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034337faeULL, 0x0003e2000b901c46ULL,
0x000000103d437824ULL, 0x000fe400078e0243ULL, 0x000000ffff3d7224ULL, 0x000fe200000e0642ULL,
0x0000000036317faeULL, 0x0003e2000b901c46ULL, 0x000000ffff3f7224ULL, 0x000fc600028e063fULL,
0x000000003c417faeULL, 0x0003e8000b901c46ULL, 0x000000003e437faeULL, 0x0003e4000b901c46ULL,
0x000000015b317810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff2a7424ULL, 0x000fc600078e00ffULL,
0x000000023100720cULL, 0x000fe20003f06070ULL, 0x0000000825337824ULL, 0x000fd800078e00ffULL,
0x000000012c348824ULL, 0x000fe200078e0231ULL, 0xfffffff033317812ULL, 0x000fe200078ec0ffULL,
0x00000004ff358424ULL, 0x000fc800078e00ffULL, 0x0000000832317824ULL, 0x000fe200078e0231ULL,
0xffffffe033367812ULL, 0x000fe200078ec0ffULL, 0x0000600034348625ULL, 0x000fc600078e0035ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000001033377812ULL, 0x040fe400078ec0ffULL,
0x0000000833337812ULL, 0x000fe200078ec0ffULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x00000006342a8981ULL, 0x000322000c1e1900ULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000003633337210ULL, 0x000fe40007ffe037ULL, 0x0000f6a831537810ULL, 0x000fd20007ffe0ffULL,
0x00000000530403c2ULL, 0x000ea40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800313e7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60800333c7f8cULL, 0x0002a4000c80043fULL,
0x0000000000347805ULL, 0x002fc40000015200ULL, 0x00f60c0033377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x006fc4000780483dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634417210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000004136367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c0033377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001024367824ULL, 0x000fe200078e00ffULL,
0x00000001ff357819ULL, 0x000fe20000011624ULL, 0x0000002025347824ULL, 0x000fc600078e00ffULL,
0x0000007036467812ULL, 0x000fe200078ec0ffULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c35357812ULL, 0x000fc800078ec0ffULL,
0x0000003435377210ULL, 0x000fca0007ffe046ULL, 0x00f00000373d7984ULL, 0x000e680000000800ULL,
0x00f20000373c7984ULL, 0x0004e20000000800ULL, 0x0000005c3d00720bULL, 0x002fe20003f1d000ULL,
0x00013dc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000377806ULL, 0x004fc800000e0100ULL,
0x0000ffff37447812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff597224ULL, 0x000fc400078e005cULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fca00078e00ffULL,
0x0000043000008947ULL, 0x000fea0003800000ULL, 0x000000252600720cULL, 0x000fe40003fa5270ULL,
0x0000005c3d00720bULL, 0x000fe20003f14000ULL, 0x00013d627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000417806ULL, 0x000fc400000e0100ULL, 0x000000802542d824ULL, 0x000fe200078e0246ULL,
0x0000003d5c597209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991041437816ULL, 0x000fe200000000ffULL, 0x000000013542d824ULL, 0x000fc600078e0242ULL,
0x000000ff4300720cULL, 0x000fe40003f05270ULL, 0x00f400594200d388ULL, 0x0003f60000000800ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000595c427221ULL, 0x002fe20000010000ULL,
0x000000ff41ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x0000004200457308ULL, 0x0002ac0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff427819ULL, 0x002fe20000011624ULL,
0x00013ca27f007947ULL, 0x000fea000b800000ULL, 0x00001f4245427589ULL, 0x0042a400000e0000ULL,
0x0000004208087220ULL, 0x084fe20000410000ULL, 0x0000004209097220ULL, 0x080fe20000410000ULL,
0x0000004214147220ULL, 0x080fe20000410000ULL, 0x0000004215157220ULL, 0x080fe20000410000ULL,
0x0000004204047220ULL, 0x080fe20000410000ULL, 0x0000004205057220ULL, 0x080fe20000410000ULL,
0x0000004218187220ULL, 0x080fe20000410000ULL, 0x0000004219197220ULL, 0x080fe20000410000ULL,
0x000000421c1c7220ULL, 0x080fe20000410000ULL, 0x000000421d1d7220ULL, 0x080fe20000410000ULL,
0x0000004210107220ULL, 0x080fe20000410000ULL, 0x0000004211117220ULL, 0x080fe20000410000ULL,
0x000000420c0c7220ULL, 0x080fe20000410000ULL, 0x000000420d0d7220ULL, 0x080fe20000410000ULL,
0x0000004220207220ULL, 0x080fe20000410000ULL, 0x0000004221217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0041ff7812ULL, 0x000fe2000780c0ffULL,
0x000000452b2b7220ULL, 0x004fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000824427811ULL, 0x002fe200078ff0ffULL, 0x00013b827f007947ULL, 0x000fea000b800000ULL,
0x00001f4245427589ULL, 0x0002a400000e0000ULL, 0x000000420a0a7220ULL, 0x084fe20000410000ULL,
0x000000420b0b7220ULL, 0x080fe20000410000ULL, 0x0000004216167220ULL, 0x080fe20000410000ULL,
0x0000004217177220ULL, 0x080fe20000410000ULL, 0x0000004206067220ULL, 0x080fe20000410000ULL,
0x0000004207077220ULL, 0x080fe20000410000ULL, 0x000000421a1a7220ULL, 0x080fe20000410000ULL,
0x000000421b1b7220ULL, 0x080fe20000410000ULL, 0x000000421e1e7220ULL, 0x080fe20000410000ULL,
0x000000421f1f7220ULL, 0x080fe20000410000ULL, 0x0000004212127220ULL, 0x080fe20000410000ULL,
0x0000004213137220ULL, 0x080fe20000410000ULL, 0x000000420e0e7220ULL, 0x080fe20000410000ULL,
0x000000420f0f7220ULL, 0x080fe20000410000ULL, 0x0000004222227220ULL, 0x080fe20000410000ULL,
0x0000004223237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff44ff7812ULL, 0x000fda0007806041ULL, 0x800000593d3d0221ULL, 0x000fe20000010000ULL,
0x00007610ff6a0816ULL, 0x000fc6000000006aULL, 0x3fb8aa3b3d3d0820ULL, 0x000fc80000410000ULL,
0x0000003d00390308ULL, 0x000e640000000800ULL, 0x000000393c3c0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002b3c2b7221ULL, 0x008fc40000010000ULL,
0x00000000003c7805ULL, 0x000fca0000015200ULL, 0x0000000227417824ULL, 0x000fc800078e0240ULL,
0x0000000841447824ULL, 0x000fca00078e00ffULL, 0x00f6ac0044427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x000000423c427210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e3dULL,
0x003d09004200780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404200780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff417819ULL, 0x000fc80000011443ULL, 0x0000004241417211ULL, 0x000fca00078110ffULL,
0x000000ffff427224ULL, 0x000fca00000e0643ULL, 0x0000000241417819ULL, 0x000fc80000001242ULL,
0x000000410000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000145457810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0044427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106a3c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff3c00720cULL, 0x000fda0003fc5270ULL,
0x0000012000006947ULL, 0x000fea0003800000ULL, 0x00000039ff3a723eULL, 0x000fe400000010ffULL,
0x00000002ff3c7819ULL, 0x000fe40000011624ULL, 0x000054103a3d7816ULL, 0x000fe2000000003aULL,
0x000137627f007947ULL, 0x000fea000b800000ULL, 0x00001f3c3d3b7589ULL, 0x0002a400000e0000ULL,
0x000000083c3a7810ULL, 0x000fe20007ffe0ffULL, 0x000137927f007947ULL, 0x000fea000b800000ULL,
0x00001f3a3d3a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000103c427810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff477224ULL, 0x000fe200078e003dULL,
0x00002c0000487802ULL, 0x000fc40000000f00ULL, 0x000141f000007944ULL, 0x01efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000183c427810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff477224ULL, 0x004fe200078e003dULL, 0x00002c5000487802ULL, 0x000fc40000000f00ULL,
0x000141a000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000724937812ULL, 0x000fe200078ec0ffULL, 0x0000000225617824ULL, 0x040fe200078e00ffULL,
0x00000004ff947819ULL, 0x100fe20000011624ULL, 0x00000200253d7824ULL, 0x00afe200078e00ffULL,
0x0000000893937812ULL, 0x000fe200078ef824ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004613c7812ULL, 0x000fc400078ec0ffULL, 0xfffff8003d3d7812ULL, 0x000fe200078ec0ffULL,
0x0000000893417824ULL, 0x040fe200078e00ffULL, 0x0000003c933c7210ULL, 0x000fc80007ffe094ULL,
0xfffffff8413c7812ULL, 0x000fe400078ee23cULL, 0x0000000824417812ULL, 0x000fc600078ec0ffULL,
0x000000103c3c7824ULL, 0x000fc400078e023dULL, 0x0000000425557824ULL, 0x000fe200078e00ffULL,
0x0000000741547812ULL, 0x000fe200078ef824ULL, 0x00000002274a7824ULL, 0x000fe200078e0240ULL,
0x000099106a6a7816ULL, 0x000fe400000000ffULL, 0x0000000455557812ULL, 0x000fe200078ec0ffULL,
0x0000000854417824ULL, 0x000fe200078e00ffULL, 0x0000b0004a4a7811ULL, 0x000fe400078e60ffULL,
0x0000001054487812ULL, 0x000fe200078efcffULL, 0x0000000194557824ULL, 0x000fc400078e0255ULL,
0x0000000427947824ULL, 0x000fe400078e0294ULL, 0x0000000154407824ULL, 0x000fe400078e0255ULL,
0x0000000848427824ULL, 0x000fe200078e00ffULL, 0x0000000294947810ULL, 0x000fe20007ffe093ULL,
0x0000000155497824ULL, 0x000fe200078e0248ULL, 0xfffffff841417812ULL, 0x000fe200078ee240ULL,
0x00000008484b7824ULL, 0x000fe200078e00ffULL, 0x0000000240527810ULL, 0x000fe40007ffe0ffULL,
0xfffffff842517812ULL, 0x000fe200078ee249ULL, 0x0000001041417824ULL, 0x000fe200078e024aULL,
0x0000000249507810ULL, 0x000fc60007ffe0ffULL, 0x00000010514c7824ULL, 0x000fe200078e024aULL,
0x000000004144783bULL, 0x0042a20000004200ULL, 0xfffffff84b507812ULL, 0x000fc800078ee250ULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0x0000001050487824ULL, 0x000fe400078e024aULL,
0x0000000854417824ULL, 0x002fca00078e00ffULL, 0xfffffff841527812ULL, 0x000fca00078ee252ULL,
0x0000001052407824ULL, 0x000fe400078e024aULL, 0x000000004848783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000e620000004200ULL, 0x0000010044787824ULL, 0x004fe200078e00ffULL,
0x0000004400727306ULL, 0x000fe20000009400ULL, 0x00000018ff9f7819ULL, 0x000fe20000011444ULL,
0x00000100457c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe20000011445ULL,
0x0000010047c27824ULL, 0x040fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0001000047c17824ULL, 0x000fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe2000001147cULL,
0x0000004400797306ULL, 0x000ea20000005400ULL, 0x0000007800987245ULL, 0x000fe2000020d400ULL,
0x00010000457c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe20000011446ULL,
0x000001004c997824ULL, 0x048fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x000100004c957824ULL, 0x000fe200078e00ffULL, 0x00000018ffca7819ULL, 0x000fe2000001147cULL,
0x00000078007a7306ULL, 0x000fe20000209400ULL, 0x00000100467c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe20000011447ULL, 0x000001004e807824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fc400000114c1ULL, 0x00000018ffd07819ULL, 0x000fe2000001147cULL,
0x00010000467c7824ULL, 0x000fe200078e00ffULL, 0x00000078007f7306ULL, 0x0006e20000205400ULL,
0x000000797200720bULL, 0x004fe20003f1d000ULL, 0x000100004f727824ULL, 0x040fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x002fe40000011440ULL, 0x00000018ffd27819ULL, 0x000fe2000001147cULL,
0x000001004f7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fe20000011441ULL,
0x0000004400817306ULL, 0x0002a2000000d400ULL, 0x00000018ffb17819ULL, 0x000fe20000011442ULL,
0x000100004e787824ULL, 0x008fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x000fc40000011443ULL,
0x00000018ff997819ULL, 0x000fe40000011499ULL, 0x00000018ff957819ULL, 0x000fe20000011495ULL,
0x0000009f009c7306ULL, 0x000fe20000209400ULL, 0x0001000044447824ULL, 0x002fe200078e00ffULL,
0x0000007f7a00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff897819ULL, 0x000fe4000001144cULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000009f00c97306ULL, 0x0002e20000205400ULL,
0x0000000181810812ULL, 0x004fc400078efcffULL, 0x00000018ff827819ULL, 0x000fe4000001144dULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000000198985812ULL, 0x000fe200078efcffULL,
0x00000044007e7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fe4000020d400ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x00000018ff717819ULL, 0x000fc4000001144eULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000004400977306ULL, 0x0002a20000205400ULL,
0x000000c99c00720bULL, 0x008fe40003f1d000ULL, 0x00000044009c7245ULL, 0x000fe4000020d400ULL,
0x00000018ff6f7819ULL, 0x000fe4000001144fULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000004500a67306ULL, 0x000fe20000009400ULL, 0x0000010040447824ULL, 0x002fca00078e00ffULL,
0x000000019f9f0812ULL, 0x000fe400078efcffULL, 0x0000004500cb7306ULL, 0x000e620000005400ULL,
0x000000977e00720bULL, 0x004fce0003fbd000ULL, 0x00000045006b7306ULL, 0x000eac000000d400ULL,
0x000000019c9c5812ULL, 0x000fe400078efcffULL, 0x000000aa00c87306ULL, 0x000fe20000209400ULL,
0x000000cba600720bULL, 0x002fe40003f1d000ULL, 0x000000ca00a67245ULL, 0x000fca000020d400ULL,
0x000000aa00457306ULL, 0x0002ec0000205400ULL, 0x000000016b6b0812ULL, 0x004fe400078efcffULL,
0x000000ca00cc7306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fce000020d400ULL,
0x000000ca00cd7306ULL, 0x000e620000205400ULL, 0x00000045c800720bULL, 0x008fe40003fbd000ULL,
0x00000018ffc87819ULL, 0x000fe20000011444ULL, 0x0000010041447824ULL, 0x000fc800078e00ffULL,
0x000000a900ce7306ULL, 0x000fe20000209400ULL, 0x00000018ffcb7819ULL, 0x000fca0000011444ULL,
0x00000001aaaa5812ULL, 0x000fe400078efcffULL, 0x000000a900cf7306ULL, 0x0004e20000205400ULL,
0x000000cdcc00720bULL, 0x002fce0003fbd000ULL, 0x0000004600b87306ULL, 0x000fe20000009400ULL,
0x000000a900a97245ULL, 0x004fca000020d400ULL, 0x00000001a6a65812ULL, 0x000fe400078efcffULL,
0x0000004600c37306ULL, 0x000e620000005400ULL, 0x000000cfce00720bULL, 0x008fce0003f1d000ULL,
0x00000046007d7306ULL, 0x000eac000000d400ULL, 0x00000001a9a90812ULL, 0x000fe400078efcffULL,
0x000000d000d17306ULL, 0x000fe20000209400ULL, 0x000000c3b800720bULL, 0x002fe40003f1d000ULL,
0x000000d000b87245ULL, 0x000fca000020d400ULL, 0x000000d000467306ULL, 0x000e6c0000205400ULL,
0x000000017d7d0812ULL, 0x004fe400078efcffULL, 0x000000d200d37306ULL, 0x000ff00000209400ULL,
0x000000d200d47306ULL, 0x000ea20000205400ULL, 0x00000046d100720bULL, 0x002fce0003fbd000ULL,
0x000000b200ad7306ULL, 0x000fec0000209400ULL, 0x00000001b8b85812ULL, 0x000fe400078efcffULL,
0x000000b200c07306ULL, 0x0002e20000205400ULL, 0x000000d4d300720bULL, 0x004fce0003fbd000ULL,
0x000000c200c67306ULL, 0x000fe20000209400ULL, 0x000000b200b27245ULL, 0x002fce000020d400ULL,
0x000000c200c77306ULL, 0x000e620000205400ULL, 0x000000c0ad00720bULL, 0x008fe40003f1d000ULL,
0x000000d200ad7245ULL, 0x000fe4000020d400ULL, 0x000000c200c07245ULL, 0x000fe4000020d400ULL,
0x00000001adad5812ULL, 0x000fe200078efcffULL, 0x0000004700b07306ULL, 0x000fec0000009400ULL,
0x00000001b2b20812ULL, 0x000fc400078efcffULL, 0x0000004700b37306ULL, 0x000ea20000005400ULL,
0x000000c7c600720bULL, 0x002fe40003fbd000ULL, 0x000000adb2b2723eULL, 0x000fca00000010ffULL,
0x00000047007b7306ULL, 0x0002ec000000d400ULL, 0x00000001c0c05812ULL, 0x000fe400078efcffULL,
0x000000c100c47306ULL, 0x000fe20000209400ULL, 0x009000003c44783bULL, 0x002e620000000200ULL,
0x000000b3b000720bULL, 0x004fc40003f1d000ULL, 0x000000c100b07245ULL, 0x000fe4000020d400ULL,
0x000000b400b37245ULL, 0x000fe4000020d400ULL, 0x000000c100c57306ULL, 0x000eae0000205400ULL,
0x000000017b7b0812ULL, 0x008fe200078efcffULL, 0x000000b400b67306ULL, 0x000ff00000209400ULL,
0x000000b400b57306ULL, 0x0006620000205400ULL, 0x000000c5c400720bULL, 0x004fce0003fbd000ULL,
0x000000c800c97306ULL, 0x000fe20000209400ULL, 0x000000bd00b47245ULL, 0x008fca000020d400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x000000c800ca7306ULL, 0x000ea20000205400ULL,
0x000000b5b600720bULL, 0x002fe20003f1d000ULL, 0x0000003b4444e231ULL, 0x080fe200003400ffULL,
0x0000010042b67824ULL, 0x000fe200078e00ffULL, 0x0000003b4646e231ULL, 0x000fe400003400ffULL,
0x0000003a4545e231ULL, 0x080fe400003400ffULL, 0x0000004000af7306ULL, 0x000fe20000009400ULL,
0x0000003a4747e231ULL, 0x000fe200003400ffULL, 0x00000018ffb67819ULL, 0x000fc800000114b6ULL,
0x00000001b3b30812ULL, 0x000fe400078efcffULL, 0x0000004000ae7306ULL, 0x000e620000005400ULL,
0x000000cac900720bULL, 0x004fe40003fbd000ULL, 0x000000b0b3b3723eULL, 0x000fca00000010ffULL,
0x000000cb00cc7306ULL, 0x000fe40000209400ULL, 0x000000b24418723cULL, 0x000fec0000041818ULL,
0x000000cb00cd7306ULL, 0x000ea20000205400ULL, 0x000000aeaf00720bULL, 0x002fe20003f1d000ULL,
0x0000010043af7824ULL, 0x000fe200078e00ffULL, 0x000000c800ae7245ULL, 0x000fc8000020d400ULL,
0x00000001aeae5812ULL, 0x000fe200078efcffULL, 0x00000040006d7306ULL, 0x0002e2000000d400ULL,
0x00000018ffc57819ULL, 0x000fce00000114afULL, 0x0000004100ab7306ULL, 0x000fe20000009400ULL,
0x0001000040407824ULL, 0x002fe200078e00ffULL, 0x000000cdcc00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000004100a87306ULL, 0x000e620000005400ULL,
0x000000016d6d0812ULL, 0x008fe400078efcffULL, 0x0000004000af7245ULL, 0x000fca000020d400ULL,
0x00000041006e7306ULL, 0x0004f0000000d400ULL, 0x000000bd00bf7306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000a8ab00720bULL, 0x002fc40003fbd000ULL,
0x000000cb00ab7245ULL, 0x000fe4000020d400ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x000000bd00be7306ULL, 0x000e620000205400ULL, 0x00000001abab6812ULL, 0x000fe400078efcffULL,
0x0000004100a87245ULL, 0x000fc8000020d400ULL, 0x000000016e6e5812ULL, 0x008fe200078efcffULL,
0x0000004000c37306ULL, 0x000fe60000209400ULL, 0x0000006eabab723eULL, 0x000fca00000010ffULL,
0x0000004000c67306ULL, 0x000ea20000205400ULL, 0x000000bebf00720bULL, 0x002fce0003fdd000ULL,
0x0000004100c27306ULL, 0x000fec0000209400ULL, 0x00000001b4b46812ULL, 0x000fe400078efcffULL,
0x0000004100b57306ULL, 0x000e620000205400ULL, 0x000000c6c300720bULL, 0x004fce0003f1d000ULL,
0x000000b900bb7306ULL, 0x000fec0000209400ULL, 0x00000001afaf0812ULL, 0x000fe400078efcffULL,
0x000000b900bc7306ULL, 0x0004e20000205400ULL, 0x000000b5c200720bULL, 0x002fce0003fbd000ULL,
0x000000b600c17306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x004fca000020d400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x000000b600c47306ULL, 0x000e620000205400ULL,
0x000000bcbb00720bULL, 0x008fce0003f1d000ULL, 0x0000004200a37306ULL, 0x000fec0000009400ULL,
0x00000001b9b90812ULL, 0x000fe400078efcffULL, 0x0000004200a27306ULL, 0x000ea20000005400ULL,
0x000000c4c100720bULL, 0x002fe40003fdd000ULL, 0x000000a8b9b9723eULL, 0x000fca00000010ffULL,
0x0000004200667306ULL, 0x0002f0000000d400ULL, 0x0000004300a07306ULL, 0x000fe20000009400ULL,
0x0001000042427824ULL, 0x002fe200078e00ffULL, 0x000000a2a300720bULL, 0x004fc40003fbd000ULL,
0x000000b600a37245ULL, 0x000fe4000020d400ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000004300a17306ULL, 0x000e620000005400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x000000c500b67245ULL, 0x000fc8000020d400ULL, 0x0000000166665812ULL, 0x008fe200078efcffULL,
0x000000c500c77306ULL, 0x000fe60000209400ULL, 0x00000066a366723eULL, 0x000fca00000010ffULL,
0x000000c500c67306ULL, 0x000ea20000205400ULL, 0x000000a1a000720bULL, 0x002fe40003fdd000ULL,
0x00000018ffa07819ULL, 0x000fca000001144aULL, 0x0000004300677306ULL, 0x0002f0000000d400ULL,
0x0000004200407306ULL, 0x000fe20000209400ULL, 0x0001000043437824ULL, 0x002fe200078e00ffULL,
0x000000c6c700720bULL, 0x004fc80003f1d000ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004200417306ULL, 0x000e620000205400ULL, 0x0000000167676812ULL, 0x008fcc00078efcffULL,
0x00000001b6b60812ULL, 0x000fe200078efcffULL, 0x000000b100ba7306ULL, 0x000fe60000209400ULL,
0x00000067b667723eULL, 0x000fca00000010ffULL, 0x000000b100b77306ULL, 0x000ea20000205400ULL,
0x000000414000720bULL, 0x002fe20003fbd000ULL, 0x0000000893417824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011449ULL, 0x00000066440c723cULL, 0x000fe6000004180cULL,
0xfffffff841407812ULL, 0x000fe200078ee294ULL, 0x0000004300b57306ULL, 0x000fe80000209400ULL,
0x00000010403d7824ULL, 0x000fc800078e023dULL, 0x0000004300bc7306ULL, 0x000e620000205400ULL,
0x000000b7ba00720bULL, 0x004fe40003f1d000ULL, 0x000000b100ba7245ULL, 0x000fca000020d400ULL,
0x0000009e00a77306ULL, 0x000fec0000209400ULL, 0x00000001baba0812ULL, 0x000fe400078efcffULL,
0x0000009e00a47306ULL, 0x000ea20000205400ULL, 0x000000bcb500720bULL, 0x002fe40003fdd000ULL,
0x0000004200b57245ULL, 0x000fc8000020d400ULL, 0x00000001b5b55812ULL, 0x000fe200078efcffULL,
0x0000009900a57306ULL, 0x000fe60000209400ULL, 0x000000b5baba723eULL, 0x000fca00000010ffULL,
0x0000009900ac7306ULL, 0x000e620000205400ULL, 0x000000a4a700720bULL, 0x004fe40003fbd000ULL,
0x0000004300a47245ULL, 0x000fe4000020d400ULL, 0x009000003d40783bULL, 0x000ea40000000200ULL,
0x00000001a4a46812ULL, 0x000fe200078efcffULL, 0x0000004c008c7306ULL, 0x000ff00000009400ULL,
0x0000004c008d7306ULL, 0x000ee20000005400ULL, 0x000000aca500720bULL, 0x002fc40003f1d000ULL,
0x0000009e00a57245ULL, 0x000fe4000020d400ULL, 0x00000099009e7245ULL, 0x000fe4000020d400ULL,
0x00000001a5a55812ULL, 0x000fe200078efcffULL, 0x00000095009a7306ULL, 0x000fe60000209400ULL,
0x000000a4a5bb723eULL, 0x000fc600000010ffULL, 0x000000019e9e0812ULL, 0x000fe400078efcffULL,
0x00000095009b7306ULL, 0x0002a20000205400ULL, 0x0000008d8c00720bULL, 0x008fe20003fdd000ULL,
0x000000ba4420723cULL, 0x000fec0000041820ULL, 0x0000004c00637306ULL, 0x0006a2000000d400ULL,
0x0000009500957245ULL, 0x002fce000020d400ULL, 0x00000089008e7306ULL, 0x000fe20000209400ULL,
0x000001004d4c7824ULL, 0x008fe200078e00ffULL, 0x0000009b9a00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000089008f7306ULL, 0x000e620000205400ULL,
0x0000000163636812ULL, 0x000fcc00078efcffULL, 0x0000000195955812ULL, 0x000fe200078efcffULL,
0x0000004d00887306ULL, 0x000ff00000009400ULL, 0x0000004d00877306ULL, 0x000ea20000005400ULL,
0x0000008f8e00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff8e7819ULL, 0x000fca000001144bULL,
0x0000004c00967306ULL, 0x000ff00000209400ULL, 0x0000004c009d7306ULL, 0x0002e20000205400ULL,
0x000000878800720bULL, 0x004fe40003fbd000ULL, 0x0000004c00877245ULL, 0x000fca000020d400ULL,
0x0000004d00647306ULL, 0x0004e2000000d400ULL, 0x00000081984c723eULL, 0x002fce00000010ffULL,
0x0000008200857306ULL, 0x000fe20000209400ULL, 0x000100004d4d7824ULL, 0x004fe200078e00ffULL,
0x0000009d9600720bULL, 0x008fe40003fdd000ULL, 0x0000008900967245ULL, 0x000fe4000020d400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000008200847306ULL, 0x0002a20000205400ULL,
0x0000000196960812ULL, 0x000fe400078efcffULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x00000100486a7824ULL, 0x000fe200078e00ffULL, 0x0000000164645812ULL, 0x000fc400078efcffULL,
0x0000000187876812ULL, 0x000fe200078efcffULL, 0x0000004d00907306ULL, 0x000fe20000209400ULL,
0x00000018ff8f7819ULL, 0x000fe2000001146aULL, 0x00000100496a7824ULL, 0x000fe200078e00ffULL,
0x0000004d00817245ULL, 0x000fe4000020d400ULL, 0x0000008200827245ULL, 0x002fe4000020d400ULL,
0x000000648787723eULL, 0x000fe200000010ffULL, 0x0000004d00917306ULL, 0x0002e20000205400ULL,
0x000000848500720bULL, 0x004fe20003fdd000ULL, 0x0000003b40408231ULL, 0x000fc400003400ffULL,
0x0000003b42428231ULL, 0x000fe400003400ffULL, 0x0000003a41418231ULL, 0x080fe400003400ffULL,
0x0000004e00867306ULL, 0x000fe20000009400ULL, 0x0000003a43438231ULL, 0x000fe200003400ffULL,
0x0000006baa4d723eULL, 0x002fe400000010ffULL, 0x000000a6a96b723eULL, 0x000fe400000010ffULL,
0x0000000182826812ULL, 0x000fc400078efcffULL, 0x0000004e00837306ULL, 0x000e620000005400ULL,
0x000000919000720bULL, 0x008fe20003fbd000ULL, 0x0000004c4408723cULL, 0x000be20000041808ULL,
0x0000006daeaa723eULL, 0x000fca00000010ffULL, 0x00000080008a7306ULL, 0x000fe20000209400ULL,
0x0000007bc04d723eULL, 0x020fe200000010ffULL, 0x000000aa441c723cULL, 0x040fe2000004181cULL,
0x00000080007b7245ULL, 0x000fe4000020d400ULL, 0x0000007db84c723eULL, 0x000fe400000010ffULL,
0x0000000181815812ULL, 0x000fe200078efcffULL, 0x00000080008b7306ULL, 0x0004e20000205400ULL,
0x000000838600720bULL, 0x002fe40003f1d000ULL, 0x00000018ff837819ULL, 0x000fe2000001146aULL,
0x0000004c4404723cULL, 0x000fe20000041804ULL, 0x0000009c9f6a723eULL, 0x000fc400000010ffULL,
0x000000afb4b8723eULL, 0x000fe200000010ffULL, 0x0000007c00927306ULL, 0x000fe20000209400ULL,
0x000000959680723eULL, 0x004fe400000010ffULL, 0x000000818281723eULL, 0x000fe200000010ffULL,
0x0000006a4414723cULL, 0x000b680000041814ULL, 0x0000007c00977306ULL, 0x000e620000205400ULL,
0x0000008b8a00720bULL, 0x008fc40003fbd000ULL, 0x0000007c006b7245ULL, 0x020fe2000020d400ULL,
0x000000b84410723cULL, 0x000b680000041810ULL, 0x0000004e005a7306ULL, 0x0004e6000000d400ULL,
0x0000009300467245ULL, 0x020fc6000020d400ULL, 0x000000017b7b5812ULL, 0x000fe400078efcffULL,
0x0000004f00757306ULL, 0x000fe20000009400ULL, 0x000000979200720bULL, 0x002fe40003fdd000ULL,
0x00000018ff4e7819ULL, 0x004fe20000011448ULL, 0x000000804014723cULL, 0x000f680000041814ULL,
0x0000004f00747306ULL, 0x000e620000005400ULL, 0x000000015a5a0812ULL, 0x008fc800078efcffULL,
0x0000005a7b44723eULL, 0x000fe400000010ffULL, 0x000000016b6b6812ULL, 0x000fe200078efcffULL,
0x0000007100777306ULL, 0x000ff00000209400ULL, 0x0000007100767306ULL, 0x0004e20000205400ULL,
0x000000747500720bULL, 0x002fe20003fbd000ULL, 0x000001004a747824ULL, 0x000fc400078e00ffULL,
0x000100004a757824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000078007e7306ULL, 0x000fe20000209400ULL, 0x0000007100717245ULL, 0x004fe4000020d400ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x0000007400477245ULL, 0x000fc6000020d400ULL,
0x00000078007f7306ULL, 0x0002a20000205400ULL, 0x000000767700720bULL, 0x008fe20003f1d000ULL,
0x000001004b767824ULL, 0x040fe400078e00ffULL, 0x000100004b777824ULL, 0x000fc600078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000004f00587306ULL, 0x000ee2000000d400ULL,
0x0000007800787245ULL, 0x002fe4000020d400ULL, 0x00000018ff777819ULL, 0x000fc60000011477ULL,
0x0000000171710812ULL, 0x000fe400078efcffULL, 0x0000006f00707306ULL, 0x000fe20000209400ULL,
0x0000007f7e00720bULL, 0x004fce0003fdd000ULL, 0x0000006f00737306ULL, 0x000e620000205400ULL,
0x0000000158585812ULL, 0x008fc800078efcffULL, 0x000000586b45723eULL, 0x000fe400000010ffULL,
0x0000000178786812ULL, 0x000fe200078efcffULL, 0x00000072007a7306ULL, 0x000fe60000209400ULL,
0x000000787178723eULL, 0x000fe200000010ffULL, 0x000000444004723cULL, 0x000b680000041804ULL,
0x0000007200797306ULL, 0x000ea20000205400ULL, 0x000000737000720bULL, 0x002fce0003fdd000ULL,
0x0000008f00997306ULL, 0x000ff00000209400ULL, 0x0000008f00847306ULL, 0x000e620000205400ULL,
0x000000797a00720bULL, 0x004fe40003fbd000ULL, 0x0000007200797245ULL, 0x000fca000020d400ULL,
0x00000048006c7306ULL, 0x000fec0000009400ULL, 0x0000000179795812ULL, 0x000fe400078efcffULL,
0x0000004800697306ULL, 0x000ea20000005400ULL, 0x000000849900720bULL, 0x002fce0003f1d000ULL,
0x0000004800577306ULL, 0x0002f0000000d400ULL, 0x0000004900687306ULL, 0x000fe20000009400ULL,
0x0001000048487824ULL, 0x002fe200078e00ffULL, 0x000000696c00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff7d7819ULL, 0x000fe20000011448ULL, 0x0001000049487824ULL, 0x000fe200078e00ffULL,
0x0000004900657306ULL, 0x000fe80000005400ULL, 0x00000018ff4c7819ULL, 0x000fe40000011448ULL,
0x0000006f00487245ULL, 0x000fe4000020d400ULL, 0x0000008300857306ULL, 0x000fe20000209400ULL,
0x0000000157575812ULL, 0x008fc400078efcffULL, 0x0000000148486812ULL, 0x000fc800078efcffULL,
0x000000794879723eULL, 0x000fe200000010ffULL, 0x0000008300867306ULL, 0x000e6c0000205400ULL,
0x000000784018723cULL, 0x000f640000041818ULL, 0x0000004a00607306ULL, 0x000ff00000009400ULL,
0x0000004a005d7306ULL, 0x000fe20000005400ULL, 0x000000868500720bULL, 0x002fc40003fdd000ULL,
0x000000639e86723eULL, 0x000fca00000010ffULL, 0x0000004a005c7306ULL, 0x0003e4000000d400ULL,
0x000000864008723cULL, 0x000f6c0000041808ULL, 0x0000004900567306ULL, 0x000ea2000000d400ULL,
0x0000008f004a7245ULL, 0x002fc8000020d400ULL, 0x000000014a4a0812ULL, 0x000fe400078efcffULL,
0x000000656800720bULL, 0x000fe20003f1d000ULL, 0x0000004e004f7306ULL, 0x000fe20000209400ULL,
0x000000574a4a723eULL, 0x000fce00000010ffULL, 0x0000004e00a27306ULL, 0x0002e80000205400ULL,
0x0000000156560812ULL, 0x004fc800078efcffULL, 0x0000007d006a7306ULL, 0x000fe20000209400ULL,
0x0000004e004e7245ULL, 0x002fce000020d400ULL, 0x0000007d00497306ULL, 0x0003e20000205400ULL,
0x000000a24f00720bULL, 0x008fe40003fbd000ULL, 0x0000004c004f7245ULL, 0x000fca000020d400ULL,
0x0000004c004d7306ULL, 0x000fe20000209400ULL, 0x0000007d007d7245ULL, 0x002fca000020d400ULL,
0x000000014e4e5812ULL, 0x000fe400078efcffULL, 0x0000004c00707306ULL, 0x000e700000205400ULL,
0x0000004b005e7306ULL, 0x000ff00000009400ULL, 0x0000004b005f7306ULL, 0x000fe20000005400ULL,
0x000000704d00720bULL, 0x002fce0003f1d000ULL, 0x0000004b00627306ULL, 0x0003ec000000d400ULL,
0x000000014f4f0812ULL, 0x000fe400078efcffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x00000083004b7245ULL, 0x002fe4000020d400ULL, 0x0000005d6000720bULL, 0x000fc40003f1d000ULL,
0x000000014b4b6812ULL, 0x000fe400078efcffULL, 0x000000496a00720bULL, 0x000fe20003fdd000ULL,
0x0000009300a17306ULL, 0x000e620000205400ULL, 0x00000076005d7245ULL, 0x000fe4000020d400ULL,
0x000000564b4b723eULL, 0x000fca00000010ffULL, 0x00000074006d7306ULL, 0x000fe20000209400ULL,
0x000000015c5c0812ULL, 0x000fe200078efcffULL, 0x0000004a401c723cULL, 0x000f64000004181cULL,
0x000000017d7d6812ULL, 0x000fc800078efcffULL, 0x00000074006c7306ULL, 0x000ea20000205400ULL,
0x000000a19400720bULL, 0x002fe40003fdd000ULL, 0x0000007700a17245ULL, 0x000fe4000020d400ULL,
0x0000007d4e4e723eULL, 0x000fc600000010ffULL, 0x0000007600657306ULL, 0x000fec0000209400ULL,
0x0000000146466812ULL, 0x000fe400078efcffULL, 0x0000007600667306ULL, 0x000e620000205400ULL,
0x0000006c6d00720bULL, 0x004fe40003fbd000ULL, 0x0000004f464f723eULL, 0x000fca00000010ffULL,
0x0000007500497306ULL, 0x000fe40000209400ULL, 0x0000004e4010723cULL, 0x000f680000041810ULL,
0x0000000147475812ULL, 0x000fe400078efcffULL, 0x00000075004c7306ULL, 0x0004e20000205400ULL,
0x000000666500720bULL, 0x002fe40003fdd000ULL, 0x0000005f5e00720bULL, 0x000fc40003fbd000ULL,
0x0000005c475c723eULL, 0x000fc600000010ffULL, 0x000000a0008c7306ULL, 0x000fe20000209400ULL,
0x0000007500757245ULL, 0x004fca000020d400ULL, 0x000000015d5d6812ULL, 0x000fe400078efcffULL,
0x000000a0008d7306ULL, 0x0002a20000205400ULL, 0x0000004c4900720bULL, 0x008fe40003f1d000ULL,
0x0000000162625812ULL, 0x000fc800078efcffULL, 0x000000625d5d723eULL, 0x000fe200000010ffULL,
0x0000008e00897306ULL, 0x000fe20000209400ULL, 0x000000a000a07245ULL, 0x002fca000020d400ULL,
0x0000000175750812ULL, 0x000fe200078efcffULL, 0x0000005c400c723cULL, 0x000f62000004180cULL,
0x0000008e00887306ULL, 0x0002e20000205400ULL, 0x0000008d8c00720bULL, 0x004fce0003fdd000ULL,
0x00000077004d7306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x002fca000020d400ULL,
0x00000001a0a06812ULL, 0x000fe400078efcffULL, 0x0000007700447306ULL, 0x020e620000205400ULL,
0x000000888900720bULL, 0x008fe40003fbd000ULL, 0x00000075a0a0723eULL, 0x000fd600000010ffULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x000000444d00720bULL, 0x002fda0003f1d000ULL,
0x00000001a1a10812ULL, 0x000fc800078efcffULL, 0x000000a18ea1723eULL, 0x000fce00000010ffULL,
0x000000a04020723cULL, 0x000b6e0000041820ULL, 0x0000000827407824ULL, 0x020fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd00000008000ULL, 0x00f6c80040407f8cULL, 0x000e62000c80043fULL,
0xfffffff861567812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000402d407811ULL, 0x002fe200078e40ffULL, 0x00f6880056ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff447224ULL, 0x000fe200078e0041ULL, 0x000000015b5b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5c7224ULL, 0x000fe200078e0059ULL, 0x000000034000720cULL, 0x000fe20003f06070ULL,
0x000000ffff5d7224ULL, 0x000fc400078e003fULL, 0x000000ffff407224ULL, 0x000fd400078e0032ULL,
0x0000a3d000000947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x002fc40000015200ULL,
0x0000040030437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240457210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004542427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040030437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001025407824ULL, 0x000fe200078e00ffULL, 0x000000012d417810ULL, 0x000fe20007ffe0ffULL,
0x000058002a2a7a24ULL, 0x010fc600078e02ffULL, 0x000000004100720cULL, 0x000fe20003f06070ULL,
0x000000402a4b7824ULL, 0x000fe200078e00ffULL, 0xffffffe040427812ULL, 0x000fca00078ec0ffULL,
0x000001002d427824ULL, 0x000fca00078e0242ULL, 0x0000008042437810ULL, 0x000fc80007ffe0ffULL,
0x0000002028497812ULL, 0x000fe200078ef843ULL, 0x000004b000008947ULL, 0x000fea0003800000ULL,
0x0000001040477812ULL, 0x000fe400078ec0ffULL, 0x00000003ff487819ULL, 0x000fc80000011624ULL,
0x00000004484a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000148447824ULL, 0x040fe200078e0247ULL,
0x00000008484e7810ULL, 0x000fc60007ffe0ffULL, 0x00000001442a7824ULL, 0x000fe400078e0249ULL,
0x000000014a4c7824ULL, 0x100fe400078e0247ULL, 0x000000014e4f7824ULL, 0x000fe200078e0247ULL,
0x0000002a4b457210ULL, 0x000fe40007f1e0ffULL, 0x00000043032a7217ULL, 0x000fc60007800000ULL,
0x000000ffff427224ULL, 0x000fe200000e06ffULL, 0x00005e0045417a11ULL, 0x040fe200078038ffULL,
0x000000012a407824ULL, 0x000fe400078e0a43ULL, 0x000010002e2a7824ULL, 0x000fe200078e00ffULL,
0x00005f0045457a11ULL, 0x000fe200000f3c42ULL, 0x0000001024437824ULL, 0x000fe200078e00ffULL,
0x0000004047407217ULL, 0x000fe40007800000ULL, 0x000010002a427812ULL, 0x000fe400078ec0ffULL,
0x00000070435b7812ULL, 0x000fe200078ec0ffULL, 0x00000001402a7824ULL, 0x000fc400078e0a47ULL,
0x0000000144437824ULL, 0x000fe400078e0224ULL, 0x000000014c407824ULL, 0x000fe200078e0249ULL,
0x0000002a4800720cULL, 0x000fe20003f06070ULL, 0x0000000844447824ULL, 0x000fe400078e00ffULL,
0x0000200027427824ULL, 0x000fe200078e0242ULL, 0x000000404b467210ULL, 0x000fe40007fde0ffULL,
0x0000005b41407210ULL, 0x000fe40007fbe0ffULL, 0xfffffff8444d7812ULL, 0x000fe200078ee243ULL,
0x000000ffff437224ULL, 0x000fe200030e06ffULL, 0x0000b00042447810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff417224ULL, 0x000fe200028e0645ULL, 0x00005e0046427a11ULL, 0x000fc400078c38ffULL,
0x0000002a4a00720cULL, 0x080fe20003fa6070ULL, 0x000000104d457824ULL, 0x000fe200078e0244ULL,
0x00005f0046467a11ULL, 0x000fe200030f3c43ULL, 0x000000014c4a7824ULL, 0x040fe400078e0224ULL,
0x000000084c4d7824ULL, 0x000fe200078e00ffULL, 0x0000000c484c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040457faeULL, 0x0003e2000c101c46ULL,
0x000000014f437824ULL, 0x000fe200078e0249ULL, 0x0000005b42427210ULL, 0x000fe40007f1e0ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee24aULL, 0x000000014c4a7824ULL, 0x000fe200078e0247ULL,
0x000000434b487210ULL, 0x000fe20007fde0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0646ULL,
0x0000002a4e00720cULL, 0x000fc60003f06070ULL, 0x000000ffff477224ULL, 0x000fe400030e06ffULL,
0x000000104d457824ULL, 0x002fe400078e0244ULL, 0x000000014a407824ULL, 0x000fc600078e0249ULL,
0x0000000042457faeULL, 0x0003e2000e901c46ULL, 0x00005e0048417a11ULL, 0x040fe400078a38ffULL,
0x000000404b467210ULL, 0x000fe40007fde0ffULL, 0x00005f0048487a11ULL, 0x000fe400028f3c47ULL,
0x0000002a4c00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff477224ULL, 0x000fe200030e06ffULL,
0x0000005b41407210ULL, 0x000fe20007fde0ffULL, 0x000000014f2a7824ULL, 0x000fc400078e0224ULL,
0x000000084f4f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff417224ULL, 0x000fe200030e0648ULL,
0x00005e0046427a11ULL, 0x002fe200078c38ffULL, 0x000000014a437824ULL, 0x040fe200078e0224ULL,
0xfffffff84f457812ULL, 0x000fe200078ee22aULL, 0x000000084a4a7824ULL, 0x000fe200078e00ffULL,
0x00005f00462a7a11ULL, 0x000fe400030f3c47ULL, 0x0000005b42427210ULL, 0x000fe20007fde0ffULL,
0x0000001045457824ULL, 0x000fe200078e0244ULL, 0xfffffff84a477812ULL, 0x000fc600078ee243ULL,
0x000000ffff437224ULL, 0x000fe200030e062aULL, 0x0000000040457faeULL, 0x0003e2000c101c46ULL,
0x0000001047477824ULL, 0x000fca00078e0244ULL, 0x0000000042477faeULL, 0x0003e2000e901c46ULL,
0x000003e000007947ULL, 0x000fea0003800000ULL, 0x0000001040417812ULL, 0x000fe200078ec0ffULL,
0x000010002e447824ULL, 0x000fe400078e00ffULL, 0x00000010245b7824ULL, 0x040fe200078e00ffULL,
0x0000004124417211ULL, 0x000fe400078fe8ffULL, 0x0000100044447812ULL, 0x000fe400078ec0ffULL,
0x0000000441427810ULL, 0x040fe20007ffe0ffULL, 0x00000001412a7824ULL, 0x040fe200078e0249ULL,
0x0000000c414d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000141407824ULL, 0x100fe200078e0224ULL,
0x000000705b5b7812ULL, 0x000fe200078ec0ffULL, 0x0000000841457824ULL, 0x000fe200078e00ffULL,
0x0000002a4b487210ULL, 0x000fe20007f1e0ffULL, 0x0000000142437824ULL, 0x000fc400078e0224ULL,
0x00000008424c7824ULL, 0x040fe200078e00ffULL, 0xfffffff8454a7812ULL, 0x000fe200078ee240ULL,
0x00000001422a7824ULL, 0x100fe200078e0249ULL, 0x0000000841457810ULL, 0x000fe20007ffe0ffULL,
0x000000014d417824ULL, 0x000fe200078e0249ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee243ULL,
0x000000ffff437224ULL, 0x000fe200000e06ffULL, 0x00005e0048477a11ULL, 0x040fe200078038ffULL,
0x0000000145407824ULL, 0x000fe200078e0249ULL, 0x0000002a4b2a7210ULL, 0x000fe20007fde0ffULL,
0x0000000145467824ULL, 0x140fe200078e0224ULL, 0x00005f0048487a11ULL, 0x000fe200000f3c43ULL,
0x0000000845497824ULL, 0x000fe200078e00ffULL, 0x000000404b407210ULL, 0x000fe20007fbe0ffULL,
0x000000014d457824ULL, 0x000fe200078e0224ULL, 0x000000414b417210ULL, 0x000fe20007f1e0ffULL,
0x000000084d587824ULL, 0x000fe200078e00ffULL, 0xfffffff8494e7812ULL, 0x000fe200078ee246ULL,
0x000000ffff437224ULL, 0x000fe200030e06ffULL, 0x00005e002a427a11ULL, 0x000fe200078c38ffULL,
0x0000200027497824ULL, 0x000fe200078e0244ULL, 0xfffffff858587812ULL, 0x000fe200078ee245ULL,
0x000000ffff457224ULL, 0x000fe200028e06ffULL, 0x00005f002a437a11ULL, 0x000fe200030f3c43ULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x00005e0040447a11ULL, 0x000fc400078038ffULL,
0x00005e0041467a11ULL, 0x040fe400078a38ffULL, 0x00005f0040457a11ULL, 0x000fe400000f3c45ULL,
0x00005f00412a7a11ULL, 0x000fe400028f3c2aULL, 0x0000005b47407210ULL, 0x080fe40007f1e0ffULL,
0x0000005b42427210ULL, 0x080fe40007fbe0ffULL, 0x0000b000494f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff417224ULL, 0x000fe200000e0648ULL, 0x0000005b44447210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff437224ULL, 0x000fe200028e0643ULL, 0x0000005b46467210ULL, 0x000fe20007fbe0ffULL,
0x000000104a497824ULL, 0x000fc400078e024fULL, 0x000000104c4b7824ULL, 0x100fe400078e024fULL,
0x000000104e4d7824ULL, 0x000fe200078e024fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040497faeULL, 0x0003e2000b901c46ULL, 0x000000ffff457224ULL, 0x000fe400000e0645ULL,
0x00000010584f7824ULL, 0x000fe200078e024fULL, 0x00000000424b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff477224ULL, 0x000fc600028e062aULL, 0x00000000444d7faeULL, 0x0003e8000b901c46ULL,
0x00000000464f7faeULL, 0x0003e4000b901c46ULL, 0x0000000825437824ULL, 0x002fe200078e00ffULL,
0x000000022f417810ULL, 0x000fe20007ffe0ffULL, 0x000000082e427824ULL, 0x000fe400078e00ffULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0xfffffff043437812ULL, 0x000fe400078ec0ffULL,
0x0000000842427812ULL, 0x000fc400078ec0ffULL, 0x000000024100720cULL, 0x000fc60003f06070ULL,
0x0000000143577824ULL, 0x000fca00078e0242ULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x000000022c408810ULL, 0x000fe20007ffe02fULL, 0x00000004ff418424ULL, 0x000fc800078e00ffULL,
0x0000600040408625ULL, 0x000fe200078e0041ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x0000f6a857587810ULL, 0x000fc60007ffe0ffULL, 0x00000006402a8981ULL, 0x000322000c1e1900ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000580403c2ULL, 0x000ea40000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800575c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280033447f8cULL, 0x0002a4000c80043fULL, 0x0000000000407805ULL, 0x002fc40000015200ULL,
0x00f62c0033437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x006fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240477210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004742427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c0033437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000805b407810ULL, 0x000fca0007ffe034ULL, 0x0000000135407824ULL, 0x000fca00078e0240ULL,
0x00f0000040447984ULL, 0x000e680000000800ULL, 0x00f2000040467984ULL, 0x0004e20000000800ULL,
0x000000594400720bULL, 0x002fe20003f1d000ULL, 0x000106327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000407806ULL, 0x004fc800000e0100ULL, 0x0000ffff40ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff457424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x008fd200078e0059ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x0000000126427810ULL, 0x000fe40007ffe0ffULL, 0x000000594400720bULL, 0x000fe40003f14000ULL,
0x000000254200720cULL, 0x000fe20003fa5270ULL, 0x000105e27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000417806ULL, 0x000fc400000e0100ULL, 0x000000802542d824ULL, 0x000fe200078e025bULL,
0x0000005944487209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000013543d824ULL, 0x000fe200078e0242ULL, 0x0000991041427816ULL, 0x000fc800000000ffULL,
0x00f400484300d388ULL, 0x0003e20000000800ULL, 0x000000ff4200720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000004859427221ULL, 0x002fe20000010000ULL,
0x000000ff41ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x00000042004a7308ULL, 0x000e640000000800ULL,
0x0000004a2b2b7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff427819ULL, 0x000fe20000011624ULL, 0x000105127f007947ULL, 0x000fea000b800000ULL,
0x00001f424a427589ULL, 0x0002a400000e0000ULL, 0x0000004208087220ULL, 0x084fe20000410000ULL,
0x0000004209097220ULL, 0x080fe20000410000ULL, 0x0000004214147220ULL, 0x080fe20000410000ULL,
0x0000004215157220ULL, 0x080fe20000410000ULL, 0x0000004204047220ULL, 0x080fe20000410000ULL,
0x0000004205057220ULL, 0x080fe20000410000ULL, 0x0000004218187220ULL, 0x080fe20000410000ULL,
0x0000004219197220ULL, 0x080fe20000410000ULL, 0x000000421c1c7220ULL, 0x080fe20000410000ULL,
0x000000421d1d7220ULL, 0x080fe20000410000ULL, 0x0000004210107220ULL, 0x080fe20000410000ULL,
0x0000004211117220ULL, 0x080fe20000410000ULL, 0x000000420c0c7220ULL, 0x080fe20000410000ULL,
0x000000420d0d7220ULL, 0x080fe20000410000ULL, 0x0000004220207220ULL, 0x080fe20000410000ULL,
0x0000004221217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0041ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000824427811ULL, 0x000fe200078ff0ffULL, 0x000104027f007947ULL, 0x000fea000b800000ULL,
0x00001f424a427589ULL, 0x0004e400000e0000ULL, 0x000000420a0a7220ULL, 0x088fe20000410000ULL,
0x000000420b0b7220ULL, 0x080fe20000410000ULL, 0x0000004216167220ULL, 0x080fe20000410000ULL,
0x0000004217177220ULL, 0x080fe20000410000ULL, 0x0000004206067220ULL, 0x080fe20000410000ULL,
0x0000004207077220ULL, 0x080fe20000410000ULL, 0x000000421a1a7220ULL, 0x080fe20000410000ULL,
0x000000421b1b7220ULL, 0x080fe20000410000ULL, 0x000000421e1e7220ULL, 0x080fe20000410000ULL,
0x000000421f1f7220ULL, 0x080fe20000410000ULL, 0x0000004212127220ULL, 0x080fe20000410000ULL,
0x0000004213137220ULL, 0x080fe20000410000ULL, 0x000000420e0e7220ULL, 0x080fe20000410000ULL,
0x000000420f0f7220ULL, 0x080fe20000410000ULL, 0x0000004222227220ULL, 0x080fe20000410000ULL,
0x0000004223237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff41ff7812ULL, 0x000fe20007800840ULL, 0x00000001ff457424ULL, 0x000fe200078e00ffULL,
0x00000059445c7209ULL, 0x000fd60007810000ULL, 0x8000005c44440221ULL, 0x000fe20000010000ULL,
0x00007610ff450816ULL, 0x000fc60000000045ULL, 0x3fb8aa3b44440820ULL, 0x000fc80000410000ULL,
0x0000004400390308ULL, 0x000e640000000800ULL, 0x0000003946460220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002b462b7221ULL, 0x000fc20000010000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x00f6ac0031437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240477210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004742427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0031437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910453e7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff3e00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000039ff3a723eULL, 0x000fe400000010ffULL,
0x00000002ff3f7819ULL, 0x000fe40000011624ULL, 0x000054103a3e7816ULL, 0x000fe2000000003aULL,
0x0000ffe27f007947ULL, 0x000fea000b800000ULL, 0x00001f3f3e3b7589ULL, 0x0002e400000e0000ULL,
0x000000083f427810ULL, 0x000fe20007ffe0ffULL, 0x000100127f007947ULL, 0x000fea000b800000ULL,
0x00001f423e3a7589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000103f427810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff477224ULL, 0x000fe200078e003eULL,
0x0000658000487802ULL, 0x000fc40000000f00ULL, 0x0001087000007944ULL, 0x01cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000183f427810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff477224ULL, 0x004fe200078e003eULL, 0x000065d000487802ULL, 0x000fc40000000f00ULL,
0x0001082000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001543e7824ULL, 0x042fe200078e0255ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008543f7824ULL, 0x000fc400078e00ffULL, 0x00000002275f7824ULL, 0x000fc600078e0232ULL,
0xfffffff83f3e7812ULL, 0x000fe400078ee23eULL, 0x0000b0005f5f7811ULL, 0x000fca00078e60ffULL,
0x000000103e3f7824ULL, 0x100fe400078e025fULL, 0x0000001052597824ULL, 0x100fe400078e025fULL,
0x00000010515a7824ULL, 0x100fe200078e025fULL, 0x000000003f40783bULL, 0x000e620000004200ULL,
0x00000010503e7824ULL, 0x000fc600078e025fULL, 0x000000005944783bULL, 0x004ea80000004200ULL,
0x000000005a4c783bULL, 0x000ee80000004200ULL, 0x000000003e48783bULL, 0x000ea20000004200ULL,
0x0000010040a07824ULL, 0x042fe200078e00ffULL, 0x0000004000947306ULL, 0x000fe20000009400ULL,
0x00000018ffb27819ULL, 0x000fe20000011440ULL, 0x0001000040ab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe20000011441ULL, 0x0000010041b77824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x0001000041b97824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x00000040009b7306ULL, 0x000e620000005400ULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x0000010042c17824ULL, 0x000fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000010043c97824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fc40000011442ULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000004000897306ULL, 0x000ee2000000d400ULL, 0x00000018ffc97819ULL, 0x000fe400000114c9ULL,
0x00000018ffb07819ULL, 0x000fe40000011443ULL, 0x00000018ffa67819ULL, 0x004fe40000011444ULL,
0x00000018ffa37819ULL, 0x000fe20000011445ULL, 0x000000a000a97306ULL, 0x000fe20000209400ULL,
0x0000009b9400720bULL, 0x002fc40003fbd000ULL, 0x000000a000947245ULL, 0x000fe4000020d400ULL,
0x000000ab009b7245ULL, 0x000fe4000020d400ULL, 0x00000018ff907819ULL, 0x008fe2000001144cULL,
0x000000a000407306ULL, 0x0002a20000205400ULL, 0x00000018ff9a7819ULL, 0x000fe40000011446ULL,
0x00000018ff977819ULL, 0x000fe40000011447ULL, 0x00000018ff8b7819ULL, 0x000fc4000001144dULL,
0x0000000189895812ULL, 0x000fe200078efcffULL, 0x000000b200b37306ULL, 0x000fe20000209400ULL,
0x0001000043a07824ULL, 0x002fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001144fULL,
0x00000018ff7f7819ULL, 0x000fe4000001144eULL, 0x00000018ffcc7819ULL, 0x000fe400000114a0ULL,
0x000000b200b47306ULL, 0x0002e20000205400ULL, 0x00000040a900720bULL, 0x004fe20003fdd000ULL,
0x0000010044a97824ULL, 0x000fe200078e00ffULL, 0x000000b200a07245ULL, 0x000fc4000020d400ULL,
0x00000018ff6e7819ULL, 0x000fe40000011448ULL, 0x00000018ff607819ULL, 0x000fe20000011449ULL,
0x000000ab00ae7306ULL, 0x000fe20000209400ULL, 0x000000c100b27245ULL, 0x002fe4000020d400ULL,
0x00000018ff627819ULL, 0x000fe4000001144aULL, 0x00000018ff5e7819ULL, 0x000fe4000001144bULL,
0x0000000194946812ULL, 0x000fe200078efcffULL, 0x000000ab00b17306ULL, 0x0002a20000205400ULL,
0x000000b4b300720bULL, 0x008fe20003fbd000ULL, 0x0000010046b47824ULL, 0x000fcc00078e00ffULL,
0x0000004100b57306ULL, 0x000fe20000009400ULL, 0x000000b700ab7245ULL, 0x002fca000020d400ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x0000004100b67306ULL, 0x000e620000005400ULL,
0x000000b1ae00720bULL, 0x004fe20003fdd000ULL, 0x0000010045ae7824ULL, 0x000fe200078e00ffULL,
0x000000c900b17245ULL, 0x000fca000020d400ULL, 0x0000004100887306ULL, 0x000eac000000d400ULL,
0x000000019b9b6812ULL, 0x000fe400078efcffULL, 0x000000b700b87306ULL, 0x000fe20000209400ULL,
0x000000b6b500720bULL, 0x002fe40003fbd000ULL, 0x000000cc00b57245ULL, 0x000fca000020d400ULL,
0x000000b700417306ULL, 0x0002ec0000205400ULL, 0x0000000188885812ULL, 0x004fe400078efcffULL,
0x000000bc00bd7306ULL, 0x000fe20000209400ULL, 0x00000018ffb77819ULL, 0x002fe400000114a9ULL,
0x000000b900a97245ULL, 0x000fca000020d400ULL, 0x000000bc00be7306ULL, 0x000e620000205400ULL,
0x00000041b800720bULL, 0x008fce0003fdd000ULL, 0x000000b900ba7306ULL, 0x000fec0000209400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x000000b900bb7306ULL, 0x000ea20000205400ULL,
0x000000bebd00720bULL, 0x002fe20003fbd000ULL, 0x0000010047be7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fc400000114aeULL, 0x000000bc00ae7245ULL, 0x000fe4000020d400ULL,
0x00000018ffbe7819ULL, 0x000fe200000114beULL, 0x0000004200bf7306ULL, 0x000fec0000009400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x0000004200c07306ULL, 0x000e620000005400ULL,
0x000000bbba00720bULL, 0x004fce0003fdd000ULL, 0x000000c100c27306ULL, 0x000fec0000209400ULL,
0x00000001a9a96812ULL, 0x000fe400078efcffULL, 0x000000c100c37306ULL, 0x000ea20000205400ULL,
0x000000c0bf00720bULL, 0x002fce0003fbd000ULL, 0x0000004200837306ULL, 0x0002f0000000d400ULL,
0x0000004300c77306ULL, 0x000fe20000009400ULL, 0x000000c3c200720bULL, 0x004fe20003fdd000ULL,
0x0001000042427824ULL, 0x002fca00078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000004300c87306ULL, 0x000e620000005400ULL, 0x0000000183835812ULL, 0x008fe400078efcffULL,
0x0000004200b37245ULL, 0x000fc6000020d400ULL, 0x00000001b2b26812ULL, 0x000fe400078efcffULL,
0x000000c900ca7306ULL, 0x000ff00000209400ULL, 0x000000c900cb7306ULL, 0x000ea20000205400ULL,
0x000000c8c700720bULL, 0x002fce0003fbd000ULL, 0x0000004300827306ULL, 0x000e70000000d400ULL,
0x000000c400c57306ULL, 0x000fe20000209400ULL, 0x000000cbca00720bULL, 0x004fce0003fdd000ULL,
0x000000c400c67306ULL, 0x000ea20000205400ULL, 0x0000000182825812ULL, 0x002fca00078efcffULL,
0x00000001b1b16812ULL, 0x000fe400078efcffULL, 0x0000004200407306ULL, 0x000ff00000209400ULL,
0x0000004200437306ULL, 0x0002e20000205400ULL, 0x000000c6c500720bULL, 0x004fce0003fbd000ULL,
0x000000b000cd7306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x002fe400000114b4ULL,
0x000000c400b47245ULL, 0x000fc8000020d400ULL, 0x00000001b4b45812ULL, 0x000fe200078efcffULL,
0x000000b000ce7306ULL, 0x0002a20000205400ULL, 0x000000434000720bULL, 0x008fce0003fdd000ULL,
0x000000cc00417306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fca000020d400ULL,
0x00000001b3b36812ULL, 0x000fe400078efcffULL, 0x000000cc00b67306ULL, 0x000e620000205400ULL,
0x000000cecd00720bULL, 0x004fce0003fbd000ULL, 0x0000004400af7306ULL, 0x000fec0000009400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x0000004400ac7306ULL, 0x000ea20000005400ULL,
0x000000b64100720bULL, 0x002fce0003fdd000ULL, 0x000000b700b87306ULL, 0x000fec0000209400ULL,
0x00000001b5b56812ULL, 0x000fe400078efcffULL, 0x000000b700bb7306ULL, 0x000e620000205400ULL,
0x000000acaf00720bULL, 0x004fe40003fbd000ULL, 0x000000b700af7245ULL, 0x000fca000020d400ULL,
0x00000044007e7306ULL, 0x0004f0000000d400ULL, 0x0000004500ad7306ULL, 0x000fe20000009400ULL,
0x000000bbb800720bULL, 0x002fe20003fdd000ULL, 0x0001000044447824ULL, 0x004fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000004500aa7306ULL, 0x000e620000005400ULL,
0x000000017e7e5812ULL, 0x008fca00078efcffULL, 0x00000001afaf6812ULL, 0x000fe400078efcffULL,
0x000000bd00bc7306ULL, 0x000fe40000209400ULL, 0x0000007eaf7e723eULL, 0x000fcc00000010ffULL,
0x000000bd00bf7306ULL, 0x000ea20000205400ULL, 0x000000aaad00720bULL, 0x002fe20003fbd000ULL,
0x0001000047ad7824ULL, 0x000fe200078e00ffULL, 0x000000bd00aa7245ULL, 0x000fc8000020d400ULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x00000045007d7306ULL, 0x0002f0000000d400ULL,
0x000000a600a87306ULL, 0x000fe20000209400ULL, 0x000000bfbc00720bULL, 0x004fe20003fdd000ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x000000a600a77306ULL, 0x0002a20000205400ULL, 0x000000017d7d5812ULL, 0x008fca00078efcffULL,
0x00000001aaaa6812ULL, 0x000fe400078efcffULL, 0x0000004400b97306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fce000020d400ULL, 0x0000004400ba7306ULL, 0x0002e20000205400ULL,
0x000000a7a800720bULL, 0x004fe40003fbd000ULL, 0x0000004400a77245ULL, 0x000fca000020d400ULL,
0x000000a300a57306ULL, 0x000fe20000209400ULL, 0x000100004c447824ULL, 0x002fca00078e00ffULL,
0x00000001a6a65812ULL, 0x000fe400078efcffULL, 0x000000a300a47306ULL, 0x0002a20000205400ULL,
0x000000bab900720bULL, 0x008fe20003fdd000ULL, 0x000001004cb97824ULL, 0x000fca00078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000004500407306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x00000001a7a76812ULL, 0x000fe400078efcffULL,
0x0000004500437306ULL, 0x000e620000205400ULL, 0x000000a4a500720bULL, 0x004fe40003fbd000ULL,
0x00000018ffa47819ULL, 0x000fca0000011444ULL, 0x0000004600a27306ULL, 0x000fec0000009400ULL,
0x00000001a3a35812ULL, 0x000fe400078efcffULL, 0x0000004600a17306ULL, 0x000ea20000005400ULL,
0x000000434000720bULL, 0x002fce0003fdd000ULL, 0x0000004200417306ULL, 0x000ff00000209400ULL,
0x0000004200b67306ULL, 0x000e620000205400ULL, 0x000000a1a200720bULL, 0x004fe40003fbd000ULL,
0x0000004200a17245ULL, 0x000fca000020d400ULL, 0x0000004c00967306ULL, 0x000ff00000009400ULL,
0x0000004c00957306ULL, 0x000ff00000005400ULL, 0x0000004c00727306ULL, 0x0005f0000000d400ULL,
0x0000004600787306ULL, 0x0006e2000000d400ULL, 0x00000045004c7245ULL, 0x004fc8000020d400ULL,
0x000000014c4c6812ULL, 0x000fe400078efcffULL, 0x000000b64100720bULL, 0x002fe20003fdd000ULL,
0x00000047009f7306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x008fe200078e00ffULL,
0x0000004ca3a3723eULL, 0x000fe200000010ffULL, 0x000001004d417824ULL, 0x000fc600078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000047009e7306ULL, 0x000e620000005400ULL,
0x0000000178785812ULL, 0x000fe400078efcffULL, 0x00000018ffb67819ULL, 0x000fe20000011441ULL,
0x000100004d417824ULL, 0x000fe200078e00ffULL, 0x00000001a1a16812ULL, 0x000fc600078efcffULL,
0x000000be00b87306ULL, 0x000fe20000209400ULL, 0x00000078a14c723eULL, 0x000fce00000010ffULL,
0x000000be00bb7306ULL, 0x000ea20000205400ULL, 0x0000009e9f00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff9e7819ULL, 0x000fe20000011441ULL, 0x000001004e417824ULL, 0x000fc800078e00ffULL,
0x0000004700767306ULL, 0x000e62000000d400ULL, 0x00000018ffba7819ULL, 0x000fe20000011441ULL,
0x000001004f417824ULL, 0x000fcc00078e00ffULL, 0x0000009a009d7306ULL, 0x000fe20000209400ULL,
0x000000bbb800720bULL, 0x004fce0003fdd000ULL, 0x0000009a009c7306ULL, 0x000ea20000205400ULL,
0x0000000176765812ULL, 0x002fce00078efcffULL, 0x0000004600ac7306ULL, 0x000ff00000209400ULL,
0x0000004600477306ULL, 0x000e620000205400ULL, 0x0000009c9d00720bULL, 0x004fe40003fbd000ULL,
0x0000009a009d7245ULL, 0x000fc4000020d400ULL, 0x00000046009c7245ULL, 0x000fc6000020d400ULL,
0x0000004d008e7306ULL, 0x000fec0000009400ULL, 0x000000019d9d5812ULL, 0x000fe400078efcffULL,
0x0000004d00917306ULL, 0x000ff00000005400ULL, 0x0000004d00737306ULL, 0x0005f0000000d400ULL,
0x0000009700997306ULL, 0x000fe20000209400ULL, 0x000000be004d7245ULL, 0x004fc8000020d400ULL,
0x000000014d4d6812ULL, 0x000fe400078efcffULL, 0x00000047ac00720bULL, 0x002fe20003fdd000ULL,
0x0000009700987306ULL, 0x0002a20000205400ULL, 0x009800003c44783bULL, 0x000ee20000000200ULL,
0x000000764d4d723eULL, 0x000fcc00000010ffULL, 0x000000ad00b77306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fc6000020d400ULL, 0x000000019c9c6812ULL, 0x000fc800078efcffULL,
0x000000ad00a87306ULL, 0x000e620000205400ULL, 0x000000989900720bULL, 0x004fe40003fbd000ULL,
0x000000ad00987245ULL, 0x000fca000020d400ULL, 0x000000b900407306ULL, 0x000fec0000209400ULL,
0x0000000197975812ULL, 0x000fe400078efcffULL, 0x000000b900437306ULL, 0x000ea20000205400ULL,
0x000000a8b700720bULL, 0x002fe40003fdd000ULL, 0x000000959600720bULL, 0x000fc40003fbd000ULL,
0x000000b900957245ULL, 0x000fe4000020d400ULL, 0x00000018ffa87819ULL, 0x000fe20000011441ULL,
0x0000009000927306ULL, 0x000fe20000209400ULL, 0x0000003b44448231ULL, 0x088fe400003400ffULL,
0x0000003b46468231ULL, 0x000fe400003400ffULL, 0x0000003a45458231ULL, 0x080fe200003400ffULL,
0x0000000198986812ULL, 0x000fe200078efcffULL, 0x0000003a47478231ULL, 0x000fe200003400ffULL,
0x0000009000937306ULL, 0x000e620000205400ULL, 0x000000434000720bULL, 0x004fc40003fdd000ULL,
0x0000000172725812ULL, 0x000fe200078efcffULL, 0x009800003d40783bULL, 0x000ea20000000200ULL,
0x000000989797723eULL, 0x000fe200000010ffULL, 0x0000004c440c723cULL, 0x000fe4000004180cULL,
0x000000a400a57306ULL, 0x000fec0000209400ULL, 0x0000000195956812ULL, 0x000fc400078efcffULL,
0x000000a400a27306ULL, 0x000ee20000205400ULL, 0x000000939200720bULL, 0x002fe40003fbd000ULL,
0x000000729572723eULL, 0x000fca00000010ffULL, 0x000000b600b87306ULL, 0x000ff00000209400ULL,
0x000000b6009f7306ULL, 0x000fe20000205400ULL, 0x000000a2a500720bULL, 0x008fce0003fdd000ULL,
0x0000004f00867306ULL, 0x000fe20000009400ULL, 0x0000003b40408231ULL, 0x084fe400003400ffULL,
0x0000003b42428231ULL, 0x000fca00003400ffULL, 0x0000004f00877306ULL, 0x000fe20000005400ULL,
0x0000003a41418231ULL, 0x080fe400003400ffULL, 0x0000003a43438231ULL, 0x000fca00003400ffULL,
0x0000004f006b7306ULL, 0x0003f0000000d400ULL, 0x0000004e008a7306ULL, 0x000fe20000009400ULL,
0x000100004f4f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff927819ULL, 0x000fe4000001144fULL,
0x0000004e008d7306ULL, 0x000e620000005400ULL, 0x00000090004f7245ULL, 0x000fc8000020d400ULL,
0x000000014f4f5812ULL, 0x000fe400078efcffULL, 0x000000918e00720bULL, 0x000fe20003fbd000ULL,
0x0000004e006c7306ULL, 0x0004e2000000d400ULL, 0x000000b6008e7245ULL, 0x000fe2000020d400ULL,
0x000100004ab67824ULL, 0x000fca00078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000009e00ac7306ULL, 0x000fe20000209400ULL, 0x000100004e4e7824ULL, 0x004fe200078e00ffULL,
0x0000008d8a00720bULL, 0x002fe20003f1d000ULL, 0x000100004b8a7824ULL, 0x000fe200078e00ffULL,
0x0000000173735812ULL, 0x000fe400078efcffULL, 0x00000018ff967819ULL, 0x000fe4000001144eULL,
0x000000a4004e7245ULL, 0x000fe2000020d400ULL, 0x0000009e00bb7306ULL, 0x000e620000205400ULL,
0x000000ba008d7245ULL, 0x000fc4000020d400ULL, 0x000000014e4e6812ULL, 0x000fe400078efcffULL,
0x0000009fb800720bULL, 0x000fe20003fdd000ULL, 0x00000100489f7824ULL, 0x000fe200078e00ffULL,
0x000000016c6c0812ULL, 0x008fe200078efcffULL, 0x0000008b008c7306ULL, 0x000fe20000209400ULL,
0x000001004bb87824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001148aULL,
0x00000018ff9f7819ULL, 0x000fe4000001149fULL, 0x00000018ffb87819ULL, 0x000fc400000114b8ULL,
0x0000008b008f7306ULL, 0x0004e20000205400ULL, 0x000000bbac00720bULL, 0x002fe20003fbd000ULL,
0x000001004aac7824ULL, 0x000fe200078e00ffULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x0000004e4f4e723eULL, 0x000fe400000010ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x000000ba009a7306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x004fe4000020d400ULL,
0x000000738e73723eULL, 0x000fca00000010ffULL, 0x000000ba00997306ULL, 0x000e620000205400ULL,
0x0000008f8c00720bULL, 0x008fe20003fdd000ULL, 0x00000100498c7824ULL, 0x000fca00078e00ffULL,
0x00000018ffa57819ULL, 0x000fe2000001148cULL, 0x000000a800ad7306ULL, 0x000fe20000209400ULL,
0x0000009e008c7245ULL, 0x000fe4000020d400ULL, 0x000000a500767245ULL, 0x000fe4000020d400ULL,
0x000000018c8c5812ULL, 0x000fe400078efcffULL, 0x000000018b8b6812ULL, 0x000fe200078efcffULL,
0x000000a800bc7306ULL, 0x0004e20000205400ULL, 0x000000999a00720bULL, 0x002fe20003fbd000ULL,
0x00010000499a7824ULL, 0x000fe200078e00ffULL, 0x0000008c8b4f723eULL, 0x000fc800000010ffULL,
0x00000018ff9a7819ULL, 0x000fe2000001149aULL, 0x0000007f00857306ULL, 0x000fe20000209400ULL,
0x000000a800a87245ULL, 0x004fca000020d400ULL, 0x000000018d8d5812ULL, 0x000fe400078efcffULL,
0x0000007f00847306ULL, 0x000e620000205400ULL, 0x000000bcad00720bULL, 0x008fe40003fdd000ULL,
0x000000878600720bULL, 0x000fe40003fbd000ULL, 0x0000006c8d6c723eULL, 0x000fc600000010ffULL,
0x0000009600a27306ULL, 0x000fec0000209400ULL, 0x00000001a8a86812ULL, 0x000fe400078efcffULL,
0x0000009600937306ULL, 0x000ea20000205400ULL, 0x000000848500720bULL, 0x002fe40003fdd000ULL,
0x000000016b6b5812ULL, 0x000fca00078efcffULL, 0x0000007b00817306ULL, 0x000ff00000209400ULL,
0x0000007b00807306ULL, 0x000e620000205400ULL, 0x00000093a200720bULL, 0x004fe40003f1d000ULL,
0x000000a7a6a2723eULL, 0x000fca00000010ffULL, 0x00000048007c7306ULL, 0x000fe40000009400ULL,
0x000000a24410723cULL, 0x000fec0000041810ULL, 0x0000004800797306ULL, 0x000fe20000005400ULL,
0x000000808100720bULL, 0x002fe40003fbd000ULL, 0x0000007f00817245ULL, 0x000fc4000020d400ULL,
0x0000007daa7f723eULL, 0x000fe400000010ffULL, 0x0000000181816812ULL, 0x000fe200078efcffULL,
0x00000048005b7306ULL, 0x0003e8000000d400ULL, 0x0000007e441c723cULL, 0x000fe8000004181cULL,
0x0000009200907306ULL, 0x000fe20000209400ULL, 0x0001000048487824ULL, 0x002fca00078e00ffULL,
0x00000018ff997819ULL, 0x000fe40000011448ULL, 0x0000009200917306ULL, 0x000fe20000205400ULL,
0x000000899448723eULL, 0x000fce00000010ffULL, 0x0000009f008f7306ULL, 0x000ff00000209400ULL,
0x0000009f00a47306ULL, 0x000e700000205400ULL, 0x00000049007a7306ULL, 0x000ff00000009400ULL,
0x0000004900777306ULL, 0x000fe20000005400ULL, 0x000000a48f00720bULL, 0x002fce0003fdd000ULL,
0x0000004900717306ULL, 0x0003f0000000d400ULL, 0x0000004a006d7306ULL, 0x000fe20000009400ULL,
0x00000088ab49723eULL, 0x002fce00000010ffULL, 0x0000004a00647306ULL, 0x000fe20000005400ULL,
0x000000484408723cULL, 0x000b6e0000041808ULL, 0x0000004a00637306ULL, 0x0003e2000000d400ULL,
0x00000082b149723eULL, 0x020fe400000010ffULL, 0x0000009600827245ULL, 0x000fc4000020d400ULL,
0x00000083b248723eULL, 0x000fe400000010ffULL, 0x0000000182820812ULL, 0x000fe200078efcffULL,
0x0000004b00697306ULL, 0x000fe20000009400ULL, 0x0000009ba04a723eULL, 0x002fe400000010ffULL,
0x000000919000720bULL, 0x000fe20003f1d000ULL, 0x000000484404723cULL, 0x000be20000041804ULL,
0x0000009200837245ULL, 0x000fe4000020d400ULL, 0x0000009c9d96723eULL, 0x000fe200000010ffULL,
0x0000004b006a7306ULL, 0x000fe20000005400ULL, 0x000000828182723eULL, 0x000fc400000010ffULL,
0x0000007b00487245ULL, 0x020fe2000020d400ULL, 0x000000724008723cULL, 0x000fe60000041808ULL,
0x0000000148485812ULL, 0x000fe200078efcffULL, 0x0000004b006f7306ULL, 0x0003e2000000d400ULL,
0x0000000183830812ULL, 0x000fe400078efcffULL, 0x000000797c00720bULL, 0x000fe20003f1d000ULL,
0x000000964420723cULL, 0x000fe20000041820ULL, 0x000000834883723eULL, 0x000fc600000010ffULL,
0x000000a5009e7306ULL, 0x000fe20000209400ULL, 0x000000a9ae4b723eULL, 0x002fce00000010ffULL,
0x000000a500b77306ULL, 0x000e620000205400ULL, 0x0000004a4414723cULL, 0x000b620000041814ULL,
0x000000015b5b0812ULL, 0x000fcc00078efcffULL, 0x000000b3b44a723eULL, 0x020fe200000010ffULL,
0x0000006e00757306ULL, 0x000fe20000209400ULL, 0x000000b5b04b723eULL, 0x000fe400000010ffULL,
0x000000b79e00720bULL, 0x002fca0003fbd000ULL, 0x0000004a4418723cULL, 0x000b620000041818ULL,
0x0000006e00747306ULL, 0x0002a20000205400ULL, 0x0000008a00b77245ULL, 0x000fca000020d400ULL,
0x0000009f004a7245ULL, 0x020fe2000020d400ULL, 0x0000004e4014723cULL, 0x000f620000041814ULL,
0x0000009900887306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x002fe4000020d400ULL,
0x000000014a4a6812ULL, 0x000fe400078efcffULL, 0x000000777a00720bULL, 0x000fe40003fdd000ULL,
0x0000000176765812ULL, 0x000fe200078efcffULL, 0x0000009900877306ULL, 0x0002e20000205400ULL,
0x000000747500720bULL, 0x004fc40003f1d000ULL, 0x0000009a00457245ULL, 0x000fe4000020d400ULL,
0x0000005b4a4a723eULL, 0x000fe400000010ffULL, 0x000000824018723cULL, 0x000f620000041818ULL,
0x0000009a00847306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fe4000020d400ULL,
0x0000000171716812ULL, 0x000fc600078efcffULL, 0x000000016e6e0812ULL, 0x000fe400078efcffULL,
0x0000009a00497306ULL, 0x000e620000205400ULL, 0x000000878800720bULL, 0x008fce0003fbd000ULL,
0x0000006000617306ULL, 0x000fec0000209400ULL, 0x0000000199995812ULL, 0x000fe400078efcffULL,
0x0000006000707306ULL, 0x0004e20000205400ULL, 0x000000498400720bULL, 0x002fce0003fdd000ULL,
0x000000ac004b7306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x004fca000020d400ULL,
0x0000000145456812ULL, 0x000fe400078efcffULL, 0x000000ac007c7306ULL, 0x0002a20000205400ULL,
0x000000706100720bULL, 0x008fe40003fbd000ULL, 0x000000646d00720bULL, 0x000fe40003fdd000ULL,
0x0000006ba86d723eULL, 0x000fc600000010ffULL, 0x000000b800777306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fc6000020d400ULL, 0x0000006c4004723cULL, 0x000f640000041804ULL,
0x0000000160605812ULL, 0x000fe400078efcffULL, 0x000000b8004c7306ULL, 0x0002e20000205400ULL,
0x0000007c4b00720bULL, 0x004fe40003f1d000ULL, 0x0000000163636812ULL, 0x000fe400078efcffULL,
0x000000456045723eULL, 0x000fe400000010ffULL, 0x00000071764b723eULL, 0x000fe200000010ffULL,
0x000000b600447306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x002fca000020d400ULL,
0x00000001acac0812ULL, 0x000fe200078efcffULL, 0x0000004a401c723cULL, 0x000f62000004181cULL,
0x000000b600477306ULL, 0x0002a20000205400ULL, 0x0000004c7700720bULL, 0x008fe40003fbd000ULL,
0x0000006a6900720bULL, 0x000fca0003f1d000ULL, 0x0000006200677306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x002fca000020d400ULL, 0x00000001b8b85812ULL, 0x000fe400078efcffULL,
0x0000006200687306ULL, 0x000e620000205400ULL, 0x000000474400720bULL, 0x004fe40003fdd000ULL,
0x000000016f6f0812ULL, 0x000fe400078efcffULL, 0x000000996e44723eULL, 0x000fe400000010ffULL,
0x00000063ac6e723eULL, 0x000fe200000010ffULL, 0x0000005e00657306ULL, 0x000fe20000209400ULL,
0x0000006fb86f723eULL, 0x000fc600000010ffULL, 0x000000444010723cULL, 0x040b640000041810ULL,
0x00000001b6b66812ULL, 0x000fe400078efcffULL, 0x0000005e00667306ULL, 0x0004e20000205400ULL,
0x000000686700720bULL, 0x002fe40003fbd000ULL, 0x0000006200457245ULL, 0x020fe2000020d400ULL,
0x0000006e400c723cULL, 0x000f68000004180cULL, 0x0000008a00467306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x004fca000020d400ULL, 0x0000000145455812ULL, 0x000fe400078efcffULL,
0x0000008a00497306ULL, 0x000e620000205400ULL, 0x000000666500720bULL, 0x008fe40003f1d000ULL,
0x000000b645b6723eULL, 0x000fd600000010ffULL, 0x000000015e5e0812ULL, 0x000fe400078efcffULL,
0x000000494600720bULL, 0x002fda0003fdd000ULL, 0x00000001b7b76812ULL, 0x000fc800078efcffULL,
0x000000b75eb7723eULL, 0x000fce00000010ffULL, 0x000000b64020723cULL, 0x000b6e0000041820ULL,
0x0000f6c827407811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000040407f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000802d407811ULL, 0x002fe200078e40ffULL, 0x00f6900056ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff447224ULL, 0x000fe200078e0041ULL, 0x000000022f5b7810ULL, 0x000fc40007ffe0ffULL,
0x000000034000720cULL, 0x000fe40003f06070ULL, 0x000000012e407812ULL, 0x000fd600078ec0ffULL,
0x00006c9000000947ULL, 0x000fea0003800000ULL, 0x0000000000407805ULL, 0x002fc40000015200ULL,
0x0000040030437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000104600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240457210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff427819ULL, 0x000fc80000011443ULL,
0x0000004542427211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000242427819ULL, 0x000fc80000001243ULL, 0x000000420000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000146467810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040030437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001025407824ULL, 0x000fe200078e00ffULL, 0x000000012d417810ULL, 0x000fe20007ffe0ffULL,
0x000058002a2a7a24ULL, 0x010fc600078e02ffULL, 0x000000004100720cULL, 0x000fe20003f06070ULL,
0x000000402a4b7824ULL, 0x000fe200078e00ffULL, 0xffffffe040427812ULL, 0x000fca00078ec0ffULL,
0x000001002d427824ULL, 0x000fca00078e0242ULL, 0x000000c042417810ULL, 0x000fc80007ffe0ffULL,
0x0000002028497812ULL, 0x000fe200078ef841ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000001040477812ULL, 0x000fe200078ec0ffULL, 0x0000001024447824ULL, 0x000fe200078e00ffULL,
0x00000003ff467819ULL, 0x000fe40000011624ULL, 0x00000041032a7217ULL, 0x000fe40007800000ULL,
0x00000004464a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000146457824ULL, 0x000fe200078e0247ULL,
0x00000070444f7812ULL, 0x000fe200078ec0ffULL, 0x000000012a2a7824ULL, 0x000fc400078e0a41ULL,
0x0000000145407824ULL, 0x000fe400078e0249ULL, 0x000000014a4c7824ULL, 0x100fe200078e0247ULL,
0x0000002a472a7217ULL, 0x000fe20007800000ULL, 0x0000000845487824ULL, 0x000fe200078e00ffULL,
0x000000404b407210ULL, 0x000fe20007f1e0ffULL, 0x000000084c5b7824ULL, 0x000fe400078e00ffULL,
0x000000012a2a7824ULL, 0x000fe400078e0a47ULL, 0x000000ffff437224ULL, 0x000fe200000e06ffULL,
0x00005e0040417a11ULL, 0x000fc800078038ffULL, 0x00005f0040427a11ULL, 0x000fe200000f3c43ULL,
0x000000014c407824ULL, 0x000fe200078e0249ULL, 0x0000002a4600720cULL, 0x000fe20003f06070ULL,
0x0000000145437824ULL, 0x000fc600078e0224ULL, 0x000000404b447210ULL, 0x000fe40007fde0ffULL,
0x0000004f41407210ULL, 0x000fe40007fbe0ffULL, 0xfffffff848487812ULL, 0x000fe200078ee243ULL,
0x000000ffff437224ULL, 0x000fe400030e06ffULL, 0x000000ffff417224ULL, 0x000fe200028e0642ULL,
0x0000002a4a00720cULL, 0x000fe20003fa6070ULL, 0x0000001048457824ULL, 0x000fe200078e025fULL,
0x00000008464a7810ULL, 0x000fe20007ffe0ffULL, 0x000000014c487824ULL, 0x000fe200078e0224ULL,
0x00005e0044427a11ULL, 0x000fc400078c38ffULL, 0x0000000c464c7810ULL, 0x000fe20007ffe0ffULL,
0x000000014a4d7824ULL, 0x000fe200078e0247ULL, 0x00005f0044447a11ULL, 0x000fe200030f3c43ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040457faeULL, 0x0003e2000c101c46ULL,
0x0000004f42427210ULL, 0x000fe20007f1e0ffULL, 0x000000014d437824ULL, 0x000fe200078e0249ULL,
0xfffffff85b487812ULL, 0x000fe200078ee248ULL, 0x000000014c4e7824ULL, 0x000fc600078e0247ULL,
0x000000434b467210ULL, 0x040fe20007fde0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0644ULL,
0x0000002a4a00720cULL, 0x000fe20003f06070ULL, 0x0000001048457824ULL, 0x002fe400078e025fULL,
0x000000014e407824ULL, 0x000fe400078e0249ULL, 0x000000ffff477224ULL, 0x000fe200030e06ffULL,
0x0000000042457faeULL, 0x0003e2000e901c46ULL, 0x00005e0046417a11ULL, 0x000fe400078a38ffULL,
0x000000404b447210ULL, 0x000fc40007fde0ffULL, 0x00005f0046467a11ULL, 0x000fe400028f3c47ULL,
0x0000002a4c00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff477224ULL, 0x000fe200030e06ffULL,
0x0000004f41407210ULL, 0x000fe20007fde0ffULL, 0x000000014d2a7824ULL, 0x040fe400078e0224ULL,
0x000000084d4d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff417224ULL, 0x000fe200030e0646ULL,
0x00005e0044427a11ULL, 0x002fe200078c38ffULL, 0x000000014e437824ULL, 0x040fe200078e0224ULL,
0xfffffff84d467812ULL, 0x000fe200078ee22aULL, 0x000000084e4e7824ULL, 0x000fe200078e00ffULL,
0x00005f00442a7a11ULL, 0x000fc400030f3c47ULL, 0x0000004f42427210ULL, 0x000fe20007fde0ffULL,
0x0000001046457824ULL, 0x000fe200078e025fULL, 0xfffffff84e447812ULL, 0x000fc600078ee243ULL,
0x000000ffff437224ULL, 0x000fe200030e062aULL, 0x0000000040457faeULL, 0x0003e2000c101c46ULL,
0x00000010445f7824ULL, 0x000fca00078e025fULL, 0x00000000425f7faeULL, 0x0003e2000e901c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001040417812ULL, 0x000fe200078ec0ffULL,
0x00000010244f7824ULL, 0x000fc600078e00ffULL, 0x0000004124407211ULL, 0x000fe400078fe8ffULL,
0x000000704f4f7812ULL, 0x000fe400078ec0ffULL, 0x0000000440427810ULL, 0x040fe20007ffe0ffULL,
0x00000001402a7824ULL, 0x040fe200078e0249ULL, 0x0000000840447810ULL, 0x040fe20007ffe0ffULL,
0x0000000140417824ULL, 0x140fe200078e0224ULL, 0x0000000c40457810ULL, 0x040fe20007ffe0ffULL,
0x00000008404a7824ULL, 0x000fe200078e00ffULL, 0x0000002a4b487210ULL, 0x000fe20007f1e0ffULL,
0x0000000142437824ULL, 0x000fc400078e0224ULL, 0x00000008424c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee241ULL, 0x000000ffff417224ULL, 0x000fe200000e06ffULL,
0x00005e0048477a11ULL, 0x000fe200078038ffULL, 0x00000001422a7824ULL, 0x000fe200078e0249ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee243ULL, 0x0000000144407824ULL, 0x000fe200078e0249ULL,
0x00005f0048487a11ULL, 0x000fe200000f3c41ULL, 0x0000000144417824ULL, 0x040fe200078e0224ULL,
0x0000002a4b437210ULL, 0x000fe20007f1e0ffULL, 0x00000001452a7824ULL, 0x000fe200078e0249ULL,
0x000000404b407210ULL, 0x000fe20007fbe0ffULL, 0x00000008444e7824ULL, 0x000fc400078e00ffULL,
0x000000ffff447224ULL, 0x000fe200000e06ffULL, 0x00005e0043427a11ULL, 0x000fe200078038ffULL,
0x0000000145497824ULL, 0x000fe200078e0224ULL, 0x0000002a4b2a7210ULL, 0x000fe20007fde0ffULL,
0x00000008455e7824ULL, 0x000fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee241ULL,
0x000000ffff457224ULL, 0x000fe200028e06ffULL, 0x00005f0043437a11ULL, 0x000fe200000f3c44ULL,
0x000000ffff417224ULL, 0x000fe200030e06ffULL, 0x00005e0040447a11ULL, 0x000fe200078038ffULL,
0x000000104c4b7824ULL, 0x100fe200078e025fULL, 0x00005e002a467a11ULL, 0x000fe200078a38ffULL,
0x000000104e4d7824ULL, 0x000fe200078e025fULL, 0x00005f0040457a11ULL, 0x000fc400000f3c45ULL,
0x00005f002a2a7a11ULL, 0x000fe400028f3c41ULL, 0x0000004f47407210ULL, 0x080fe40007f1e0ffULL,
0x0000004f42427210ULL, 0x080fe40007fbe0ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee249ULL,
0x000000ffff417224ULL, 0x000fe200000e0648ULL, 0x0000004f44447210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff437224ULL, 0x000fe200028e0643ULL, 0x0000004f46467210ULL, 0x000fe20007fbe0ffULL,
0x000000104a497824ULL, 0x000fc400078e025fULL, 0x000000ffff457224ULL, 0x000fe400000e0645ULL,
0x000000105e5f7824ULL, 0x000fe200078e025fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040497faeULL, 0x0003e2000b901c46ULL, 0x000000ffff477224ULL, 0x000fc600028e062aULL,
0x00000000424b7faeULL, 0x0003e8000b901c46ULL, 0x00000000444d7faeULL, 0x0003e8000b901c46ULL,
0x00000000465f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000032f417810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x000000024100720cULL, 0x000fda0003fa6070ULL,
0x0000004000005947ULL, 0x000fea0003800000ULL, 0x000000012c407824ULL, 0x000fe400078e0241ULL,
0x00000004ff417424ULL, 0x000fc800078e00ffULL, 0x0000600040407625ULL, 0x000fca00078e0041ULL,
0x00000006402a7981ULL, 0x000324000c1e1900ULL, 0x0000009000007945ULL, 0x000fe40003800000ULL,
0x00000000530403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800315e7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480033447f8cULL, 0x0002a4000c80043fULL,
0x0000000000407805ULL, 0x002fc40000015200ULL, 0x00f64c0033437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x006fe40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240477210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004742427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c0033437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001004f407810ULL, 0x000fca0007ffe034ULL,
0x0000000135407824ULL, 0x000fca00078e0240ULL, 0x00f0000040417984ULL, 0x000e680000000800ULL,
0x00f2000040447984ULL, 0x0004e20000000800ULL, 0x0000005c4100720bULL, 0x002fe20003f1d000ULL,
0x0000d1b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000407806ULL, 0x004fc800000e0100ULL,
0x0000ffff40ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff7d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff537224ULL, 0x000fd200078e005cULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000226427810ULL, 0x000fe40007ffe0ffULL,
0x0000005c4100720bULL, 0x000fe40003f14000ULL, 0x000000254200720cULL, 0x000fe20003fa5270ULL,
0x0000d1627f007947ULL, 0x000fd4000b800000ULL, 0x0000000000457806ULL, 0x000fc400000e0100ULL,
0x000000802546d824ULL, 0x000fe200078e024fULL, 0x000000415c42d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991045437816ULL, 0x000fe200000000ffULL,
0x000000013547d824ULL, 0x000fc600078e0246ULL, 0x000000ff4300720cULL, 0x000fe40003f05270ULL,
0x00f400424700d388ULL, 0x0003f60000000800ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000415c437209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff45ff7812ULL, 0x000fc6000780c0ffULL, 0x800000435c427221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x0000004200467308ULL, 0x000e640000000800ULL,
0x000000462b2b7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff427819ULL, 0x000fe20000011624ULL, 0x0000d0727f007947ULL, 0x000fea000b800000ULL,
0x00001f4246427589ULL, 0x0002a400000e0000ULL, 0x0000004208087220ULL, 0x084fe20000410000ULL,
0x0000004209097220ULL, 0x080fe20000410000ULL, 0x0000004214147220ULL, 0x080fe20000410000ULL,
0x0000004215157220ULL, 0x080fe20000410000ULL, 0x0000004204047220ULL, 0x080fe20000410000ULL,
0x0000004205057220ULL, 0x080fe20000410000ULL, 0x0000004218187220ULL, 0x080fe20000410000ULL,
0x0000004219197220ULL, 0x080fe20000410000ULL, 0x000000421c1c7220ULL, 0x080fe20000410000ULL,
0x000000421d1d7220ULL, 0x080fe20000410000ULL, 0x0000004210107220ULL, 0x080fe20000410000ULL,
0x0000004211117220ULL, 0x080fe20000410000ULL, 0x000000420c0c7220ULL, 0x080fe20000410000ULL,
0x000000420d0d7220ULL, 0x080fe20000410000ULL, 0x0000004220207220ULL, 0x080fe20000410000ULL,
0x0000004221217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0045ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000824427811ULL, 0x000fe200078ff0ffULL, 0x0000cf627f007947ULL, 0x000fea000b800000ULL,
0x00001f4246427589ULL, 0x00046400000e0000ULL, 0x000000420a0a7220ULL, 0x082fe20000410000ULL,
0x000000420b0b7220ULL, 0x080fe20000410000ULL, 0x0000004216167220ULL, 0x080fe20000410000ULL,
0x0000004217177220ULL, 0x080fe20000410000ULL, 0x0000004206067220ULL, 0x080fe20000410000ULL,
0x0000004207077220ULL, 0x080fe20000410000ULL, 0x000000421a1a7220ULL, 0x080fe20000410000ULL,
0x000000421b1b7220ULL, 0x080fe20000410000ULL, 0x000000421e1e7220ULL, 0x080fe20000410000ULL,
0x000000421f1f7220ULL, 0x080fe20000410000ULL, 0x0000004212127220ULL, 0x080fe20000410000ULL,
0x0000004213137220ULL, 0x080fe20000410000ULL, 0x000000420e0e7220ULL, 0x080fe20000410000ULL,
0x000000420f0f7220ULL, 0x080fe20000410000ULL, 0x0000004222227220ULL, 0x080fe20000410000ULL,
0x0000004223237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff45ff7812ULL, 0x000fe20007800840ULL, 0x00000001ff7d7424ULL, 0x000fe200078e00ffULL,
0x000000415c537209ULL, 0x000fd60007810000ULL, 0x8000005341410221ULL, 0x000fe20000010000ULL,
0x00007610ff7d0816ULL, 0x000fc6000000007dULL, 0x3fb8aa3b41410820ULL, 0x000fc80000410000ULL,
0x0000004100390308ULL, 0x000e640000000800ULL, 0x0000003944440220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002b442b7221ULL, 0x008fc20000010000ULL,
0x0000000000407805ULL, 0x000fcc0000015200ULL, 0x00f6ac0057427984ULL, 0x000e640000000800ULL,
0x8000000042ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff427819ULL, 0x000fc80000011443ULL, 0x0000004542427211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000242427819ULL, 0x000fc80000001243ULL,
0x000000420000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000144447810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0057427984ULL, 0x000e640000000800ULL, 0x8000000042ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099107d407816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff4000720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000039ff3a723eULL, 0x000fe400000010ffULL,
0x00000002ff417819ULL, 0x000fe40000011624ULL, 0x000054103a407816ULL, 0x000fe2000000003aULL,
0x0000cb427f007947ULL, 0x000fea000b800000ULL, 0x00001f41403b7589ULL, 0x0002e400000e0000ULL,
0x0000000841427810ULL, 0x000fe20007ffe0ffULL, 0x0000cb727f007947ULL, 0x000fea000b800000ULL,
0x00001f42403a7589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001041427810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff477224ULL, 0x000fe200078e0040ULL,
0x00009c0000487802ULL, 0x000fc40000000f00ULL, 0x0000d1f000007944ULL, 0x01cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001841427810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff477224ULL, 0x004fe200078e0040ULL, 0x00009c5000487802ULL, 0x000fc40000000f00ULL,
0x0000d1a000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000010002e407824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000154557824ULL, 0x000fc400078e0255ULL, 0x0000000854447824ULL, 0x000fe200078e00ffULL,
0x0000100040407812ULL, 0x000fc800078ec0ffULL, 0xfffffff844447812ULL, 0x000fe200078ee255ULL,
0x0000200027407824ULL, 0x000fca00078e0240ULL, 0x0000b00040557810ULL, 0x000fca0007ffe0ffULL,
0x0000001044447824ULL, 0x100fe400078e0255ULL, 0x0000001052407824ULL, 0x100fe400078e0255ULL,
0x0000001051487824ULL, 0x100fe400078e0255ULL, 0x000000004444783bULL, 0x004e620000004200ULL,
0x00000010504c7824ULL, 0x000fc600078e0255ULL, 0x000000004040783bULL, 0x000ea80000004200ULL,
0x000000004848783bULL, 0x000ee80000004200ULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0x0000010044ae7824ULL, 0x002fe200078e00ffULL, 0x0000004400a07306ULL, 0x000fe20000009400ULL,
0x00000018ffbd7819ULL, 0x000fe20000011444ULL, 0x0001000047b57824ULL, 0x000fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe20000011445ULL, 0x0000010040b17824ULL, 0x004fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x0000010041b47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe20000011446ULL, 0x0000004400ab7306ULL, 0x000e620000005400ULL,
0x00000018ffa57819ULL, 0x000fc40000011447ULL, 0x00000018ffb57819ULL, 0x000fe400000114b5ULL,
0x00000018ffb17819ULL, 0x000fe400000114b1ULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0000004400857306ULL, 0x0004e2000000d400ULL, 0x00000018ff9d7819ULL, 0x000fe40000011440ULL,
0x00000018ff9c7819ULL, 0x000fe40000011441ULL, 0x00000018ff957819ULL, 0x000fc40000011442ULL,
0x00000018ff927819ULL, 0x000fe20000011443ULL, 0x000000ae00b27306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x000000aba000720bULL, 0x002fe40003fbd000ULL,
0x000000ae00a07245ULL, 0x000fe4000020d400ULL, 0x00000018ffba7819ULL, 0x000fe20000011444ULL,
0x0000010045447824ULL, 0x000fe200078e00ffULL, 0x000000ae00b37306ULL, 0x0002a20000205400ULL,
0x00000018ff8c7819ULL, 0x008fc40000011448ULL, 0x000000ba00ab7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc37819ULL, 0x000fe20000011444ULL, 0x0000010046447824ULL, 0x000fe200078e00ffULL,
0x0000000185855812ULL, 0x000fe200078efcffULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x000000bd00ae7245ULL, 0x002fe4000020d400ULL, 0x00000018ffce7819ULL, 0x000fe20000011444ULL,
0x0000010047447824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fc40000011449ULL,
0x00000018ff7a7819ULL, 0x000fe2000001144aULL, 0x000000ba00be7306ULL, 0x0002e20000205400ULL,
0x000000b3b200720bULL, 0x004fe20003fdd000ULL, 0x0000010043b37824ULL, 0x000fe200078e00ffULL,
0x00000018ffd47819ULL, 0x000fe40000011444ULL, 0x000000c300b27245ULL, 0x000fe4000020d400ULL,
0x00000018ff777819ULL, 0x000fe2000001144bULL, 0x0000004500c17306ULL, 0x000fe20000009400ULL,
0x000000c900ba7245ULL, 0x002fc4000020d400ULL, 0x00000018ff697819ULL, 0x000fe4000001144cULL,
0x00000018ff5d7819ULL, 0x000fe4000001144eULL, 0x00000001a0a06812ULL, 0x000fe200078efcffULL,
0x0000004500c27306ULL, 0x000fe20000005400ULL, 0x000000bebb00720bULL, 0x008fe40003fdd000ULL,
0x000000ce00bb7245ULL, 0x000fe4000020d400ULL, 0x00000018ff5b7819ULL, 0x000fc4000001144dULL,
0x00000018ff547819ULL, 0x000fe2000001144fULL, 0x0000004500837306ULL, 0x0003ec000000d400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x0000004600cc7306ULL, 0x000fe20000009400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ffc67819ULL, 0x000fe40000011445ULL,
0x0000004600cd7306ULL, 0x000ff00000005400ULL, 0x0000004600807306ULL, 0x0003f0000000d400ULL,
0x000000bd00bf7306ULL, 0x000fe20000209400ULL, 0x0001000046467824ULL, 0x002fca00078e00ffULL,
0x00000018ffd17819ULL, 0x000fe40000011446ULL, 0x000000bd00c07306ULL, 0x0002b00000205400ULL,
0x0000004700af7306ULL, 0x000fe20000009400ULL, 0x0000010042bd7824ULL, 0x002fca00078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe400000114bdULL, 0x0000004700b07306ULL, 0x000fe20000005400ULL,
0x000000c0bf00720bULL, 0x004fce0003fbd000ULL, 0x00000047007e7306ULL, 0x0003ec000000d400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x000000c300c47306ULL, 0x000fe20000209400ULL,
0x00a000003c44783bULL, 0x002e620000000200ULL, 0x000000c2c100720bULL, 0x000fcc0003fbd000ULL,
0x000000c300c57306ULL, 0x0004ee0000205400ULL, 0x0000000183835812ULL, 0x000fe200078efcffULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x00000018ffc37819ULL, 0x004fe400000114b3ULL,
0x000000c600b37245ULL, 0x000fca000020d400ULL, 0x000000c600c87306ULL, 0x000ea20000205400ULL,
0x000000c5c400720bULL, 0x008fce0003fdd000ULL, 0x000000c900ca7306ULL, 0x000fec0000209400ULL,
0x00000001b2b26812ULL, 0x000fe400078efcffULL, 0x000000c900cb7306ULL, 0x000ee20000205400ULL,
0x000000c8c700720bULL, 0x004fe20003fdd000ULL, 0x0000003b44448231ULL, 0x082fe200003400ffULL,
0x0000010048c77824ULL, 0x000fe200078e00ffULL, 0x0000003b46468231ULL, 0x000fc400003400ffULL,
0x0000003a45458231ULL, 0x080fe400003400ffULL, 0x000000ce00cf7306ULL, 0x000fe20000209400ULL,
0x0000003a47478231ULL, 0x000fe200003400ffULL, 0x00000018ffc77819ULL, 0x000fc800000114c7ULL,
0x00000001b3b36812ULL, 0x000fe400078efcffULL, 0x000000ce00d07306ULL, 0x000e620000205400ULL,
0x000000cbca00720bULL, 0x008fe40003fbd000ULL, 0x000000cdcc00720bULL, 0x000fca0003fdd000ULL,
0x000000d400d57306ULL, 0x000fec0000209400ULL, 0x00000001baba5812ULL, 0x000fe400078efcffULL,
0x000000d400d67306ULL, 0x000ea20000205400ULL, 0x000000d0cf00720bULL, 0x002fe40003f1d000ULL,
0x0000000180806812ULL, 0x000fca00078efcffULL, 0x000000d100d27306ULL, 0x000fec0000209400ULL,
0x00000001bbbb0812ULL, 0x000fe400078efcffULL, 0x000000d100d37306ULL, 0x000e620000205400ULL,
0x000000d6d500720bULL, 0x004fe40003fbd000ULL, 0x000000b0af00720bULL, 0x000fe20003f1d000ULL,
0x0001000043af7824ULL, 0x000fe200078e00ffULL, 0x00000080bb80723eULL, 0x000fc600000010ffULL,
0x000000a800ad7306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fe400000114afULL,
0x000000d400af7245ULL, 0x000fc8000020d400ULL, 0x00000001afaf5812ULL, 0x000fe200078efcffULL,
0x000000a800ac7306ULL, 0x000ea20000205400ULL, 0x000000d3d200720bULL, 0x002fe40003fdd000ULL,
0x000000017e7e0812ULL, 0x000fca00078efcffULL, 0x000000b500d77306ULL, 0x000ff00000209400ULL,
0x000000b500d87306ULL, 0x0002e20000205400ULL, 0x000000acad00720bULL, 0x004fe40003fbd000ULL,
0x000000d100ac7245ULL, 0x000fc8000020d400ULL, 0x00000001acac6812ULL, 0x000fe200078efcffULL,
0x000000a500a97306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fce000020d400ULL,
0x000000a500aa7306ULL, 0x000e620000205400ULL, 0x000000d8d700720bULL, 0x008fce0003f1d000ULL,
0x000000b100b67306ULL, 0x000fec0000209400ULL, 0x00000001b5b50812ULL, 0x000fe400078efcffULL,
0x000000b100b77306ULL, 0x0004e20000205400ULL, 0x000000aaa900720bULL, 0x002fe40003fdd000ULL,
0x000000a800a97245ULL, 0x000fc4000020d400ULL, 0x000000b100a87245ULL, 0x000fe4000020d400ULL,
0x00000001a9a95812ULL, 0x000fe200078efcffULL, 0x0000004000a67306ULL, 0x000fe20000009400ULL,
0x0000010049b17824ULL, 0x004fe400078e00ffULL, 0x000000aca9ac723eULL, 0x000fc600000010ffULL,
0x00000018ffb17819ULL, 0x000fe400000114b1ULL, 0x0000004000a77306ULL, 0x000e620000005400ULL,
0x000000b7b600720bULL, 0x008fce0003fbd000ULL, 0x0000004000797306ULL, 0x0004ec000000d400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000004100a47306ULL, 0x000fe20000009400ULL,
0x0001000040407824ULL, 0x004fe200078e00ffULL, 0x000000a7a600720bULL, 0x002fc40003f1d000ULL,
0x000000a500a67245ULL, 0x000fe4000020d400ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004100a37306ULL, 0x000e620000005400ULL, 0x00000001a6a66812ULL, 0x000fcc00078efcffULL,
0x0000000179790812ULL, 0x008fe200078efcffULL, 0x000000b400b87306ULL, 0x000ff00000209400ULL,
0x000000b400b97306ULL, 0x000ea20000205400ULL, 0x000000a3a400720bULL, 0x002fc40003fbd000ULL,
0x000000b400a37245ULL, 0x000fca000020d400ULL, 0x0000004100787306ULL, 0x0002f0000000d400ULL,
0x0000004000bc7306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x002fe200078e00ffULL,
0x000000b9b800720bULL, 0x004fc80003fdd000ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004000d97306ULL, 0x000e620000205400ULL, 0x0000000178785812ULL, 0x008fcc00078efcffULL,
0x00000001a3a36812ULL, 0x000fe200078efcffULL, 0x0000009d00a17306ULL, 0x000fe60000209400ULL,
0x00000078a3a3723eULL, 0x000fca00000010ffULL, 0x0000009d00a27306ULL, 0x000ea20000205400ULL,
0x000000d9bc00720bULL, 0x002fce0003f1d000ULL, 0x0000004100be7306ULL, 0x000ff00000209400ULL,
0x0000004100bf7306ULL, 0x000e620000205400ULL, 0x000000a2a100720bULL, 0x004fe40003fdd000ULL,
0x0000004000a17245ULL, 0x000fe2000020d400ULL, 0x0001000049407824ULL, 0x000fc600078e00ffULL,
0x00000001a1a10812ULL, 0x000fe200078efcffULL, 0x0000009c009e7306ULL, 0x000ff00000209400ULL,
0x0000009c009f7306ULL, 0x0004e20000205400ULL, 0x000000bfbe00720bULL, 0x002fce0003fbd000ULL,
0x00000042009a7306ULL, 0x000fe20000009400ULL, 0x0000009c009c7245ULL, 0x004fce000020d400ULL,
0x00000042009b7306ULL, 0x000e620000005400ULL, 0x0000009f9e00720bULL, 0x008fe40003f1d000ULL,
0x0000009d009e7245ULL, 0x000fe4000020d400ULL, 0x00000041009d7245ULL, 0x000fe4000020d400ULL,
0x000000019e9e6812ULL, 0x000fe200078efcffULL, 0x000000bd00c07306ULL, 0x000fe20000209400ULL,
0x000000019d9d5812ULL, 0x000fe400078efcffULL, 0x00000018ff9f7819ULL, 0x000fe20000011440ULL,
0x000001004a407824ULL, 0x000fe200078e00ffULL, 0x000000a19e9e723eULL, 0x000fc400000010ffULL,
0x000000019c9c0812ULL, 0x000fe200078efcffULL, 0x000000bd00c17306ULL, 0x0004e20000205400ULL,
0x0000009b9a00720bULL, 0x002fe40003fbd000ULL, 0x00000018ff9a7819ULL, 0x000fe20000011440ULL,
0x000001004b407824ULL, 0x000fc800078e00ffULL, 0x0000004200727306ULL, 0x0002e2000000d400ULL,
0x000000bd00bd7245ULL, 0x004fce000020d400ULL, 0x000000c300c47306ULL, 0x000fe20000209400ULL,
0x0001000042427824ULL, 0x002fe200078e00ffULL, 0x000000c1c000720bULL, 0x008fc80003fdd000ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x000000c300c57306ULL, 0x000e620000205400ULL,
0x0000000172725812ULL, 0x000fcc00078efcffULL, 0x00000001bdbd6812ULL, 0x000fe200078efcffULL,
0x0000004300987306ULL, 0x000fe60000009400ULL, 0x00000072bd72723eULL, 0x000fca00000010ffULL,
0x0000004300997306ULL, 0x000ea20000005400ULL, 0x000000c5c400720bULL, 0x002fce0003f1d000ULL,
0x0000004300737306ULL, 0x000e70000000d400ULL, 0x0000004200c27306ULL, 0x000fe20000209400ULL,
0x000000999800720bULL, 0x004fe40003fdd000ULL, 0x000000c300987245ULL, 0x000fc8000020d400ULL,
0x0000000198980812ULL, 0x000fe200078efcffULL, 0x0000004200437306ULL, 0x000eac0000205400ULL,
0x0000000173736812ULL, 0x002fe400078efcffULL, 0x0000009500967306ULL, 0x000fe40000209400ULL,
0x000000739873723eULL, 0x000fcc00000010ffULL, 0x0000009500977306ULL, 0x0002e20000205400ULL,
0x00000043c200720bULL, 0x004fe20003fbd000ULL, 0x00000072440c723cULL, 0x000fec000004180cULL,
0x0000009200947306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x002fce000020d400ULL,
0x0000009200937306ULL, 0x0002a20000205400ULL, 0x000000979600720bULL, 0x008fe40003f1d000ULL,
0x0000004200967245ULL, 0x000fe4000020d400ULL, 0x00000018ff977819ULL, 0x000fe40000011440ULL,
0x0000000196965812ULL, 0x000fe200078efcffULL, 0x000000b000c67306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fe2000020d400ULL, 0x00a000003d40783bULL, 0x000e680000000200ULL,
0x0000000195950812ULL, 0x000fc400078efcffULL, 0x000000b000ad7306ULL, 0x000ee20000205400ULL,
0x000000939400720bULL, 0x004fe40003fbd000ULL, 0x000000b000937245ULL, 0x000fe4000020d400ULL,
0x000000969596723eULL, 0x000fc600000010ffULL, 0x0000004800907306ULL, 0x000fec0000009400ULL,
0x0000000192925812ULL, 0x000fe400078efcffULL, 0x0000004800917306ULL, 0x000ea20000005400ULL,
0x000000adc600720bULL, 0x008fce0003fdd000ULL, 0x00000048006e7306ULL, 0x00066c000000d400ULL,
0x0000000193936812ULL, 0x000fe400078efcffULL, 0x000000c700aa7306ULL, 0x000fe20000209400ULL,
0x0001000048487824ULL, 0x008fe200078e00ffULL, 0x000000919000720bULL, 0x004fe20003fdd000ULL,
0x000100004b907824ULL, 0x000fe200078e00ffULL, 0x000000c700917245ULL, 0x000fc4000020d400ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x000000c700a57306ULL, 0x000ea20000205400ULL,
0x00000018ff907819ULL, 0x000fcc0000011490ULL, 0x000000016e6e6812ULL, 0x002fe200078efcffULL,
0x0000004800a77306ULL, 0x000ff00000209400ULL, 0x0000004800a47306ULL, 0x000e620000205400ULL,
0x000000a5aa00720bULL, 0x004fe20003f1d000ULL, 0x000001004fa57824ULL, 0x000fca00078e00ffULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x0000008c008e7306ULL, 0x000fec0000209400ULL,
0x0000000191910812ULL, 0x000fe400078efcffULL, 0x0000008c008f7306ULL, 0x000ea20000205400ULL,
0x000000a4a700720bULL, 0x002fe20003fbd000ULL, 0x000100004ea47824ULL, 0x000fe200078e00ffULL,
0x0000006e916e723eULL, 0x000fc800000010ffULL, 0x00000018ffa47819ULL, 0x000fe200000114a4ULL,
0x00000049008d7306ULL, 0x000ff00000009400ULL, 0x00000049008a7306ULL, 0x000e620000005400ULL,
0x0000008f8e00720bULL, 0x004fc40003f1d000ULL, 0x00000048008e7245ULL, 0x000fe4000020d400ULL,
0x000099107d487816ULL, 0x000fe400000000ffULL, 0x000000018e8e5812ULL, 0x000fe200078efcffULL,
0x00000049006d7306ULL, 0x000ea2000000d400ULL, 0x0000008c007d7245ULL, 0x000fca000020d400ULL,
0x000000017d7d0812ULL, 0x000fe400078efcffULL, 0x000000b100a27306ULL, 0x000fe20000209400ULL,
0x0000008a8d00720bULL, 0x002fe40003fdd000ULL, 0x000000b1008a7245ULL, 0x000fca000020d400ULL,
0x000000b100497306ULL, 0x000e6c0000205400ULL, 0x000000016d6d6812ULL, 0x004fe400078efcffULL,
0x00000087008b7306ULL, 0x000ff00000209400ULL, 0x0000008700887306ULL, 0x0004e20000205400ULL,
0x00000049a200720bULL, 0x002fe20003fbd000ULL, 0x000000ffff497224ULL, 0x000fc400078e0048ULL,
0x000001004c487824ULL, 0x000fc600078e00ffULL, 0x000000ff4900720cULL, 0x000fe20003f05270ULL,
0x0000009f00b47306ULL, 0x000fe20000209400ULL, 0x0000008700877245ULL, 0x004fe4000020d400ULL,
0x00000018ff8d7819ULL, 0x000fe20000011448ULL, 0x000001004d487824ULL, 0x000fe200078e00ffULL,
0x00000083b249723eULL, 0x000fe400000010ffULL, 0x000000018a8a5812ULL, 0x000fe200078efcffULL,
0x0000009f009b7306ULL, 0x0002a20000205400ULL, 0x000000888b00720bULL, 0x008fc40003fdd000ULL,
0x0000009f00887245ULL, 0x000fe2000020d400ULL, 0x0000003b40408231ULL, 0x080fe400003400ffULL,
0x0000003b42428231ULL, 0x000fe400003400ffULL, 0x0000004a00867306ULL, 0x000fe20000009400ULL,
0x0000003a41418231ULL, 0x080fe200003400ffULL, 0x000001004e9f7824ULL, 0x002fe200078e00ffULL,
0x0000003a43438231ULL, 0x000fc600003400ffULL, 0x0000000187876812ULL, 0x000fe400078efcffULL,
0x0000004a00897306ULL, 0x000e620000005400ULL, 0x0000009bb400720bULL, 0x004fe40003fbd000ULL,
0x00000018ff9b7819ULL, 0x000fe40000011448ULL, 0x00000085a048723eULL, 0x000fe400000010ffULL,
0x00000018ff787819ULL, 0x000fe2000001149fULL, 0x0000009a00997306ULL, 0x000fe20000209400ULL,
0x0000009d9c9f723eULL, 0x000fc600000010ffULL, 0x000000484408723cULL, 0x040be40000041808ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x0000009a00b67306ULL, 0x000ea20000205400ULL,
0x000000898600720bULL, 0x002fe40003f1d000ULL, 0x0000007a00497245ULL, 0x020fe2000020d400ULL,
0x0000009e4410723cULL, 0x000fe20000041810ULL, 0x000000888787723eULL, 0x000fc600000010ffULL,
0x0000009700ad7306ULL, 0x000ff00000209400ULL, 0x0000009700aa7306ULL, 0x000e620000205400ULL,
0x000000b69900720bULL, 0x004fe20003fbd000ULL, 0x000100004d997824ULL, 0x000fca00078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x0000004a00527306ULL, 0x0004f0000000d400ULL,
0x0000004b00817306ULL, 0x000fe20000009400ULL, 0x000100004a4a7824ULL, 0x004fe200078e00ffULL,
0x000000aaad00720bULL, 0x002fc40003fdd000ULL, 0x000000b5a6ad723eULL, 0x000fe400000010ffULL,
0x00000018ff947819ULL, 0x000fe4000001144aULL, 0x0000004b00847306ULL, 0x000fe20000005400ULL,
0x0000000152520812ULL, 0x008fe400078efcffULL, 0x000000ac4418723cULL, 0x000f6a0000041818ULL,
0x0000004b00517306ULL, 0x000ff0000000d400ULL, 0x0000007a00827306ULL, 0x000ff00000209400ULL,
0x0000007a007f7306ULL, 0x000ff00000205400ULL, 0x00000094004a7306ULL, 0x000ff00000209400ULL,
0x00000094004b7306ULL, 0x0002b00000205400ULL, 0x0000004c00767306ULL, 0x000fe20000009400ULL,
0x0000009400947245ULL, 0x002fce000020d400ULL, 0x0000004c00757306ULL, 0x000fe20000005400ULL,
0x0000004b4a00720bULL, 0x004fe40003f1d000ULL, 0x000000abae4a723eULL, 0x000fe400000010ffULL,
0x000000b3ba4b723eULL, 0x000fc600000010ffULL, 0x0000004c00507306ULL, 0x0003e8000000d400ULL,
0x0000004a4414723cULL, 0x000fe40000041814ULL, 0x0000000194940812ULL, 0x000fe400078efcffULL,
0x0000004e00687306ULL, 0x000fe20000009400ULL, 0x000100004c4c7824ULL, 0x002fce00078e00ffULL,
0x0000004e00617306ULL, 0x000ff00000005400ULL, 0x0000004e00607306ULL, 0x0003f0000000d400ULL,
0x0000004d00747306ULL, 0x000fe20000009400ULL, 0x00000018ff4e7819ULL, 0x002fc4000001144cULL,
0x00000097004c7245ULL, 0x000fe4000020d400ULL, 0x000000939297723eULL, 0x000fe400000010ffULL,
0x000000014c4c6812ULL, 0x000fe200078efcffULL, 0x0000004d00717306ULL, 0x000fe20000005400ULL,
0x0000007f8200720bULL, 0x000fc60003fdd000ULL, 0x000000964420723cULL, 0x000fe80000041820ULL,
0x0000004d006c7306ULL, 0x0003ec000000d400ULL, 0x0000000149496812ULL, 0x000fc400078efcffULL,
0x00000077007c7306ULL, 0x000fe20000209400ULL, 0x0000009a004d7245ULL, 0x002fe4000020d400ULL,
0x000000944994723eULL, 0x000fe400000010ffULL, 0x000000014d4d5812ULL, 0x000fe400078efcffULL,
0x000000848100720bULL, 0x000fe20003fbd000ULL, 0x00000077007b7306ULL, 0x0002a20000205400ULL,
0x0000007eaf81723eULL, 0x000fce00000010ffULL, 0x00000090008f7306ULL, 0x000fe20000209400ULL,
0x0000007700777245ULL, 0x002fe2000020d400ULL, 0x000000804404723cULL, 0x000f640000041804ULL,
0x0000000151515812ULL, 0x000fc800078efcffULL, 0x00000090008c7306ULL, 0x0002e20000205400ULL,
0x0000007b7c00720bULL, 0x004fce0003fbd000ULL, 0x0000008d00a27306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x002fca000020d400ULL, 0x0000000177775812ULL, 0x000fe400078efcffULL,
0x0000008d008b7306ULL, 0x0002a20000205400ULL, 0x0000008c8f00720bULL, 0x008fce0003f1d000ULL,
0x0000009b00867306ULL, 0x000fe20000209400ULL, 0x0000008d008d7245ULL, 0x002fca000020d400ULL,
0x0000000190900812ULL, 0x000fe400078efcffULL, 0x0000009b00897306ULL, 0x0002e20000205400ULL,
0x0000008ba200720bULL, 0x004fe40003fdd000ULL, 0x000000757600720bULL, 0x000fe40003f1d000ULL,
0x00000079a8a2723eULL, 0x000fe400000010ffULL, 0x000000907795723eULL, 0x000fe200000010ffULL,
0x0000006900707306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fc6000020d400ULL,
0x000000a2441c723cULL, 0x000b64000004181cULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x00000069006f7306ULL, 0x0002a20000205400ULL, 0x000000898600720bULL, 0x008fe40003fbd000ULL,
0x000000717400720bULL, 0x000fe20003fdd000ULL, 0x000000944018723cULL, 0x020f620000041818ULL,
0x0000000150500812ULL, 0x000fe400078efcffULL, 0x000000524d44723eULL, 0x000fe200000010ffULL,
0x0000004e00837306ULL, 0x000fe20000209400ULL, 0x0000006900697245ULL, 0x002fc4000020d400ULL,
0x000000514c45723eULL, 0x000fe400000010ffULL, 0x0000005b00467245ULL, 0x000fe4000020d400ULL,
0x000000019b9b5812ULL, 0x000fe200078efcffULL, 0x0000004e00487306ULL, 0x0002e20000205400ULL,
0x000000016c6c6812ULL, 0x000fe200078efcffULL, 0x000000444004723cULL, 0x000b620000041804ULL,
0x0000006f7000720bULL, 0x004fe40003f1d000ULL, 0x0000007800477245ULL, 0x000fc4000020d400ULL,
0x0000006d8a6f723eULL, 0x000fe200000010ffULL, 0x00000099004a7306ULL, 0x000fe20000209400ULL,
0x0000004e004e7245ULL, 0x002fe4000020d400ULL, 0x0000008e7d86723eULL, 0x000fe400000010ffULL,
0x000000508d50723eULL, 0x000fe200000010ffULL, 0x0000006e4008723cULL, 0x000f620000041808ULL,
0x0000006c9b51723eULL, 0x000fe200000010ffULL, 0x00000099004b7306ULL, 0x0002a20000205400ULL,
0x000000488300720bULL, 0x008fc40003fbd000ULL, 0x0000000169690812ULL, 0x000fc600078efcffULL,
0x000000864014723cULL, 0x000f640000041814ULL, 0x0000005b005c7306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fca000020d400ULL, 0x000000014e4e5812ULL, 0x000fe200078efcffULL,
0x00000050401c723cULL, 0x000f62000004181cULL, 0x0000005b006b7306ULL, 0x000e620000205400ULL,
0x0000004b4a00720bULL, 0x004fe40003fdd000ULL, 0x0000004e694e723eULL, 0x000fca00000010ffULL,
0x0000007800797306ULL, 0x000fec0000209400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x0000007800767306ULL, 0x000ea20000205400ULL, 0x0000006b5c00720bULL, 0x002fe40003fbd000ULL,
0x000000616800720bULL, 0x000fc40003fdd000ULL, 0x000000a500617245ULL, 0x000fc6000020d400ULL,
0x0000004f00667306ULL, 0x000fec0000009400ULL, 0x0000000146465812ULL, 0x000fe400078efcffULL,
0x0000004f00677306ULL, 0x000e620000005400ULL, 0x000000767900720bULL, 0x004fe40003f1d000ULL,
0x0000000160606812ULL, 0x000fca00078efcffULL, 0x000000a500717306ULL, 0x000fec0000209400ULL,
0x0000000147470812ULL, 0x000fe400078efcffULL, 0x000000a500707306ULL, 0x000ea20000205400ULL,
0x000000676600720bULL, 0x002fe40003f1d000ULL, 0x000000604760723eULL, 0x000fca00000010ffULL,
0x000000a400487306ULL, 0x000ff00000209400ULL, 0x000000a4004b7306ULL, 0x0002e20000205400ULL,
0x000000707100720bULL, 0x004fce0003fbd000ULL, 0x0000004f006a7306ULL, 0x0004e2000000d400ULL,
0x000000a400a47245ULL, 0x002fca000020d400ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x0000005d00647306ULL, 0x000fe20000209400ULL, 0x000100004f4f7824ULL, 0x004fe200078e00ffULL,
0x0000004b4800720bULL, 0x008fc80003fdd000ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144fULL,
0x0000005d00657306ULL, 0x0002a20000205400ULL, 0x000000016a6a0812ULL, 0x000fe400078efcffULL,
0x0000004a00a57245ULL, 0x000fe4000020d400ULL, 0x00000099464f723eULL, 0x000fe400000010ffULL,
0x00000001a4a46812ULL, 0x000fe200078efcffULL, 0x0000005400627306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x002fc4000020d400ULL, 0x0000006a6161723eULL, 0x000fe200000010ffULL,
0x0000004e4010723cULL, 0x000f680000041810ULL, 0x0000005400637306ULL, 0x0002e20000205400ULL,
0x000000656400720bULL, 0x004fc60003fbd000ULL, 0x00000060400c723cULL, 0x000f68000004180cULL,
0x0000004a004c7306ULL, 0x000fe20000209400ULL, 0x0000005400547245ULL, 0x002fca000020d400ULL,
0x000000015d5d5812ULL, 0x000fe400078efcffULL, 0x0000004a00457306ULL, 0x020e620000205400ULL,
0x000000636200720bULL, 0x008fe40003f1d000ULL, 0x000000a45da4723eULL, 0x000fd600000010ffULL,
0x0000000154540812ULL, 0x000fe400078efcffULL, 0x000000454c00720bULL, 0x002fda0003fdd000ULL,
0x00000001a5a56812ULL, 0x000fc800078efcffULL, 0x000000a554a5723eULL, 0x000fce00000010ffULL,
0x000000a44020723cULL, 0x000b6e0000041820ULL, 0x0000f6c827407811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000040407f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c02d407811ULL, 0x002fe200078e40ffULL,
0x00f6980056ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff447224ULL, 0x000fe200078e0041ULL,
0x000000032f5b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5c7224ULL, 0x000fe200078e0053ULL,
0x000000034000720cULL, 0x000fe20003f06070ULL, 0x000000ffff407224ULL, 0x000fc400078e0032ULL,
0x000000ffff5d7224ULL, 0x000fd400078e005fULL, 0x000035a000000947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x002fc40000015200ULL, 0x0000040030437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804844ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000104600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000427805ULL, 0x000fcc0000015200ULL,
0x0000004240457210ULL, 0x000fca0007f1e1ffULL, 0x0000000143437824ULL, 0x000fe200000e0e41ULL,
0x003d09004500780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404500780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011443ULL, 0x0000004532327211ULL, 0x000fca00078110ffULL,
0x000000ffff437224ULL, 0x000fca00000e0643ULL, 0x0000000232327819ULL, 0x000fc80000001243ULL,
0x000000320000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000146467810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040030437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x002fe40007804844ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000022d417810ULL, 0x040fe20007ffe0ffULL,
0x000001002d307824ULL, 0x000fe400078e0229ULL, 0x000058002a2a7a24ULL, 0x010fe200078e02ffULL,
0x000000004100720cULL, 0x000fe40003f06070ULL, 0x0000010030417810ULL, 0x000fe20007ffe0ffULL,
0x000000402a477824ULL, 0x000fc600078e00ffULL, 0x0000002028447812ULL, 0x000fce00078ef841ULL,
0x0000048000008947ULL, 0x000fea0003800000ULL, 0x00000010252a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff467819ULL, 0x000fe20000011624ULL, 0x0000001024427824ULL, 0x000fc600078e00ffULL,
0x000000102a497812ULL, 0x000fe400078ec0ffULL, 0x00000041032a7217ULL, 0x000fe40007800000ULL,
0x00000004464a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000146437824ULL, 0x000fe200078e0249ULL,
0x00000070424f7812ULL, 0x000fe200078ec0ffULL, 0x000000012a2a7824ULL, 0x000fe400078e0a41ULL,
0x0000000143307824ULL, 0x000fe400078e0244ULL, 0x000000014a4b7824ULL, 0x000fe200078e0249ULL,
0x0000002a492a7217ULL, 0x000fe20007800000ULL, 0x0000000843487824ULL, 0x000fe200078e00ffULL,
0x0000003047307210ULL, 0x000fc60007f1e0ffULL, 0x000000012a2a7824ULL, 0x000fe400078e0a49ULL,
0x000000ffff417224ULL, 0x000fe200000e06ffULL, 0x00005e0030407a11ULL, 0x000fc800078038ffULL,
0x00005f0030327a11ULL, 0x000fe200000f3c41ULL, 0x0000000143417824ULL, 0x000fe200078e0224ULL,
0x0000002a4600720cULL, 0x000fe20003f06070ULL, 0x000000014b307824ULL, 0x000fe200078e0244ULL,
0x0000004f40407210ULL, 0x080fe40007fbe0ffULL, 0xfffffff848487812ULL, 0x000fe400078ee241ULL,
0x0000003047307210ULL, 0x000fe20007fde0ffULL, 0x000000ffff417224ULL, 0x000fe200028e0632ULL,
0x0000002a4a00720cULL, 0x000fe20003fa6070ULL, 0x0000001048457824ULL, 0x000fe200078e0255ULL,
0x0000000846487810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe200030e06ffULL,
0x00005e0030427a11ULL, 0x000fe200078c38ffULL, 0x000000014b327824ULL, 0x040fe200078e0224ULL,
0x0000000c464a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001484d7824ULL, 0x000fe200078e0249ULL,
0x00005f0030437a11ULL, 0x000fe200030f3c43ULL, 0x000000084b4b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040457faeULL, 0x0003e2000c101c46ULL,
0x000000014d307824ULL, 0x000fe200078e0244ULL, 0x0000004f42427210ULL, 0x000fe20007f1e0ffULL,
0x000000014a497824ULL, 0x000fe200078e0249ULL, 0xfffffff84b467812ULL, 0x000fc400078ee232ULL,
0x0000003047327210ULL, 0x000fe20007fde0ffULL, 0x0000000149307824ULL, 0x040fe400078e0244ULL,
0x000000ffff437224ULL, 0x000fe200000e0643ULL, 0x0000002a4800720cULL, 0x000fe20003f06070ULL,
0x0000000849447824ULL, 0x000fe400078e00ffULL, 0x0000001046457824ULL, 0x002fe400078e0255ULL,
0x000000ffff417224ULL, 0x000fe200030e06ffULL, 0x0000003047307210ULL, 0x000fc40007fde0ffULL,
0x0000000042457faeULL, 0x0003e2000e901c46ULL, 0x00005e0032407a11ULL, 0x040fe400078a38ffULL,
0x000000ffff477224ULL, 0x000fe400030e06ffULL, 0x00005f0032327a11ULL, 0x000fe400028f3c41ULL,
0x0000004f40407210ULL, 0x000fe40007fde0ffULL, 0x0000002a4a00720cULL, 0x000fe20003fa6070ULL,
0x000000014d2a7824ULL, 0x000fc400078e0224ULL, 0x000000084d4d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff417224ULL, 0x000fe200030e0632ULL, 0x00005e0030427a11ULL, 0x042fe200078c38ffULL,
0x0000000149437824ULL, 0x000fe200078e0224ULL, 0xfffffff84d327812ULL, 0x000fe400078ee22aULL,
0x00005f00302a7a11ULL, 0x000fe400030f3c47ULL, 0x0000004f42427210ULL, 0x000fe20007fde0ffULL,
0x0000001032457824ULL, 0x000fe200078e0255ULL, 0xfffffff844307812ULL, 0x000fc600078ee243ULL,
0x000000ffff437224ULL, 0x000fe200030e062aULL, 0x0000000040457faeULL, 0x0003e2000c101c46ULL,
0x0000001030557824ULL, 0x000fca00078e0255ULL, 0x0000000042557faeULL, 0x0003e2000e901c46ULL,
0x000003b000007947ULL, 0x000fea0003800000ULL, 0x00000010252a7824ULL, 0x000fe400078e00ffULL,
0x00000010244f7824ULL, 0x000fc600078e00ffULL, 0x000000102a417812ULL, 0x000fe400078ec0ffULL,
0x000000704f4f7812ULL, 0x000fe400078ec0ffULL, 0x0000004124417211ULL, 0x000fc800078fe8ffULL,
0x0000000441437810ULL, 0x040fe20007ffe0ffULL, 0x00000001412a7824ULL, 0x040fe400078e0244ULL,
0x0000000141307824ULL, 0x140fe400078e0224ULL, 0x0000000841497824ULL, 0x000fe200078e00ffULL,
0x0000002a47457210ULL, 0x000fe20007f1e0ffULL, 0x0000000143327824ULL, 0x040fe400078e0224ULL,
0x00000008434b7824ULL, 0x000fe200078e00ffULL, 0xfffffff849487812ULL, 0x000fe200078ee230ULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x00005e0045407a11ULL, 0x000fe200078038ffULL,
0x00000001432a7824ULL, 0x000fe200078e0244ULL, 0xfffffff84b4a7812ULL, 0x000fc400078ee232ULL,
0x0000000841497810ULL, 0x040fe40007ffe0ffULL, 0x0000000c414b7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0045457a11ULL, 0x000fe200000f3c30ULL, 0x0000000149307824ULL, 0x100fe200078e0244ULL,
0x0000002a47327210ULL, 0x000fe20007f1e0ffULL, 0x000000014b2a7824ULL, 0x000fe400078e0244ULL,
0x0000000149437824ULL, 0x100fe200078e0224ULL, 0x0000003047307210ULL, 0x000fe20007fbe0ffULL,
0x00000008494c7824ULL, 0x000fe200078e00ffULL, 0x0000002a472a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff417224ULL, 0x000fe200000e06ffULL, 0x00005e0032427a11ULL, 0x000fe200078038ffULL,
0x000000014b477824ULL, 0x040fe200078e0224ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee243ULL,
0x000000ffff437224ULL, 0x000fe200028e06ffULL, 0x00005f0032327a11ULL, 0x000fe200000f3c41ULL,
0x000000ffff417224ULL, 0x000fe200030e06ffULL, 0x00005e0030447a11ULL, 0x000fe200078038ffULL,
0x000000084b4e7824ULL, 0x000fe200078e00ffULL, 0x00005e002a467a11ULL, 0x000fe200078a38ffULL,
0x0000001048497824ULL, 0x000fe200078e0255ULL, 0x00005f0030307a11ULL, 0x000fe200000f3c43ULL,
0x000000104a4b7824ULL, 0x000fe200078e0255ULL, 0x00005f002a2a7a11ULL, 0x000fe200028f3c41ULL,
0x000000104c4d7824ULL, 0x000fe200078e0255ULL, 0x0000004f40407210ULL, 0x000fc40007f1e0ffULL,
0x0000004f42427210ULL, 0x080fe40007fbe0ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee247ULL,
0x000000ffff417224ULL, 0x000fe200000e0645ULL, 0x0000004f44447210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff437224ULL, 0x000fe200028e0632ULL, 0x0000004f46467210ULL, 0x000fe20007fbe0ffULL,
0x000000104e557824ULL, 0x000fe200078e0255ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040497faeULL, 0x0003e2000b901c46ULL, 0x000000ffff457224ULL, 0x000fe400000e0630ULL,
0x000000ffff477224ULL, 0x000fe200028e062aULL, 0x00000000424b7faeULL, 0x0003e8000b901c46ULL,
0x00000000444d7faeULL, 0x0003e8000b901c46ULL, 0x0000000046557faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000042f417810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x000000024100720cULL, 0x000fda0003fa6070ULL, 0x0000004000005947ULL, 0x000fea0003800000ULL,
0x000000012c407824ULL, 0x000fe400078e0241ULL, 0x00000004ff417424ULL, 0x000fc800078e00ffULL,
0x0000600040407625ULL, 0x000fca00078e0041ULL, 0x00000006402a7981ULL, 0x000324000c1e1900ULL,
0x0000009000007945ULL, 0x000fe40003800000ULL, 0x00000000580403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800575c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680033447f8cULL, 0x0002a4000c80043fULL, 0x0000000000407805ULL, 0x002fc40000015200ULL,
0x00f66c0033437984ULL, 0x000e640000000800ULL, 0x8000000043ff7812ULL, 0x006fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000427805ULL, 0x000fcc0000015200ULL, 0x0000004240477210ULL, 0x000fca0007f1e1ffULL,
0x0000000143437824ULL, 0x000fe200000e0e41ULL, 0x003d09004700780cULL, 0x000fc80003f06070ULL,
0x000000ff4300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404700780cULL, 0x000fc80003f06070ULL, 0x000000ff4300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff307819ULL, 0x000fc80000011443ULL,
0x0000004730307211ULL, 0x000fca00078110ffULL, 0x000000ffff437224ULL, 0x000fca00000e0643ULL,
0x0000000230307819ULL, 0x000fc80000001243ULL, 0x000000300000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c0033437984ULL, 0x000e640000000800ULL,
0x8000000043ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001804f347810ULL, 0x000fca0007ffe034ULL, 0x0000000135347824ULL, 0x000fca00078e0234ULL,
0x00f0000034307984ULL, 0x000e680000000800ULL, 0x00f2000034327984ULL, 0x0004e20000000800ULL,
0x000000533000720bULL, 0x002fe20003f1d000ULL, 0x00009ca27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000337806ULL, 0x004fc800000e0100ULL, 0x0000ffff33ff7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff407424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x008fd200078e0053ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000326347810ULL, 0x000fe40007ffe0ffULL, 0x000000533000720bULL, 0x000fe40003f14000ULL,
0x000000253400720cULL, 0x000fe20003fa5270ULL, 0x00009c527f007947ULL, 0x000fd4000b800000ULL,
0x0000000000347806ULL, 0x000fc400000e0100ULL, 0x000000802536d824ULL, 0x000fe200078e024fULL,
0x00000053305c7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000013541d824ULL, 0x000fe200078e0236ULL, 0x0000991034357816ULL, 0x000fc800000000ffULL,
0x00f4005c4100d388ULL, 0x0003e20000000800ULL, 0x000000ff3500720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000535c357221ULL, 0x002fe20000010100ULL,
0x000000ff34ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b35357820ULL, 0x000fc80000410000ULL, 0x0000003500367308ULL, 0x000e640000000800ULL,
0x000000362b2b7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff427819ULL, 0x000fe20000011624ULL, 0x00009b827f007947ULL, 0x000fea000b800000ULL,
0x00001f4236357589ULL, 0x0002a400000e0000ULL, 0x0000003508087220ULL, 0x084fe20000410000ULL,
0x0000003509097220ULL, 0x080fe20000410000ULL, 0x0000003514147220ULL, 0x080fe20000410000ULL,
0x0000003515157220ULL, 0x080fe20000410000ULL, 0x0000003504047220ULL, 0x080fe20000410000ULL,
0x0000003505057220ULL, 0x080fe20000410000ULL, 0x0000003518187220ULL, 0x080fe20000410000ULL,
0x0000003519197220ULL, 0x080fe20000410000ULL, 0x000000351c1c7220ULL, 0x080fe20000410000ULL,
0x000000351d1d7220ULL, 0x080fe20000410000ULL, 0x0000003510107220ULL, 0x080fe20000410000ULL,
0x0000003511117220ULL, 0x080fe20000410000ULL, 0x000000350c0c7220ULL, 0x080fe20000410000ULL,
0x000000350d0d7220ULL, 0x080fe20000410000ULL, 0x0000003520207220ULL, 0x080fe20000410000ULL,
0x0000003521217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0034ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000824427811ULL, 0x002fe200078ff0ffULL, 0x00009a727f007947ULL, 0x000fea000b800000ULL,
0x00001f4236357589ULL, 0x0002a400000e0000ULL, 0x000000350a0a7220ULL, 0x084fe20000410000ULL,
0x000000350b0b7220ULL, 0x080fe20000410000ULL, 0x0000003516167220ULL, 0x080fe20000410000ULL,
0x0000003517177220ULL, 0x080fe20000410000ULL, 0x0000003506067220ULL, 0x080fe20000410000ULL,
0x0000003507077220ULL, 0x080fe20000410000ULL, 0x000000351a1a7220ULL, 0x080fe20000410000ULL,
0x000000351b1b7220ULL, 0x080fe20000410000ULL, 0x000000351e1e7220ULL, 0x080fe20000410000ULL,
0x000000351f1f7220ULL, 0x080fe20000410000ULL, 0x0000003512127220ULL, 0x080fe20000410000ULL,
0x0000003513137220ULL, 0x080fe20000410000ULL, 0x000000350e0e7220ULL, 0x080fe20000410000ULL,
0x000000350f0f7220ULL, 0x080fe20000410000ULL, 0x0000003522227220ULL, 0x080fe20000410000ULL,
0x0000003523237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff34ff7812ULL, 0x000fe20007800833ULL, 0x00000001ff407424ULL, 0x000fd800078e00ffULL,
0x000000305c300221ULL, 0x000fe20000010100ULL, 0x00007610ff400816ULL, 0x000fc60000000040ULL,
0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL, 0x0000003000390308ULL, 0x000e640000000800ULL,
0x0000003932320220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002b322b7221ULL, 0x000fc40000010000ULL, 0x0000000000327805ULL, 0x000fca0000015200ULL,
0x00f6ac0031357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe4000780485fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003432417210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e33ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff307819ULL, 0x000fc80000011435ULL,
0x0000004130307211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000230307819ULL, 0x000fc80000001235ULL, 0x000000300000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0031357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780485fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991040307816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff3000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000039ff30723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe40000011624ULL,
0x0000541030307816ULL, 0x000fe20000000030ULL, 0x000096627f007947ULL, 0x000fea000b800000ULL,
0x00001f31303b7589ULL, 0x0002a400000e0000ULL, 0x0000000831427810ULL, 0x000fe20007ffe0ffULL,
0x000096927f007947ULL, 0x000fea000b800000ULL, 0x00001f42303a7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001031427810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff477224ULL, 0x000fe200078e0030ULL, 0x0000d2d000487802ULL, 0x000fc40000000f00ULL,
0x00009b2000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001831427810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff477224ULL, 0x004fe200078e0030ULL,
0x0000d32000487802ULL, 0x000fc40000000f00ULL, 0x00009ad000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003f30783bULL, 0x00ae680000004200ULL, 0x000000005934783bULL, 0x000ee80000004200ULL,
0x000000005a40783bULL, 0x000ea80000004200ULL, 0x000000003e44783bULL, 0x004ea20000004200ULL,
0x00000100308c7824ULL, 0x002fe200078e00ffULL, 0x0000003000867306ULL, 0x000fe20000009400ULL,
0x00000018ff927819ULL, 0x000fe20000011430ULL, 0x0000010031977824ULL, 0x040fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011431ULL, 0x0001000031997824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000010032a17824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011497ULL, 0x00000030008d7306ULL, 0x000e620000005400ULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x0000010033a47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fc400000114a1ULL, 0x00000018ffa57819ULL, 0x000fe40000011432ULL,
0x00000018ffaa7819ULL, 0x000fe200000114a4ULL, 0x0000008c008e7306ULL, 0x000fe20000209400ULL,
0x00000018ffad7819ULL, 0x000fe40000011433ULL, 0x00000018ffb27819ULL, 0x008fe40000011434ULL,
0x00000018ff8b7819ULL, 0x000fe40000011435ULL, 0x00000018ff767819ULL, 0x000fe20000011440ULL,
0x0000008c008f7306ULL, 0x000ee20000205400ULL, 0x0000008d8600720bULL, 0x002fe20003fbd000ULL,
0x00010000338d7824ULL, 0x000fe200078e00ffULL, 0x0000008c00867245ULL, 0x000fc4000020d400ULL,
0x00000018ff837819ULL, 0x000fe40000011436ULL, 0x00000018ff807819ULL, 0x000fe20000011437ULL,
0x0000003000717306ULL, 0x0002e2000000d400ULL, 0x00000018ff797819ULL, 0x000fe40000011441ULL,
0x00000018ff667819ULL, 0x000fe40000011443ULL, 0x00000018ff697819ULL, 0x000fe40000011442ULL,
0x00000018ff547819ULL, 0x004fe20000011444ULL, 0x0000009200937306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x002fe200078e00ffULL, 0x0000008f8e00720bULL, 0x008fe20003fdd000ULL,
0x00000100358f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011446ULL,
0x00000100348e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fc40000011430ULL,
0x0000009200947306ULL, 0x000e620000205400ULL, 0x0000000171715812ULL, 0x000fe400078efcffULL,
0x00000030008c7245ULL, 0x000fe4000020d400ULL, 0x00000018ff387819ULL, 0x000fe40000011447ULL,
0x0000000186866812ULL, 0x000fe200078efcffULL, 0x0000003000907306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x000fe40000011445ULL, 0x000000718686723eULL, 0x000fca00000010ffULL,
0x0000003000917306ULL, 0x000ea20000205400ULL, 0x000000949300720bULL, 0x002fe40003fbd000ULL,
0x00000018ff947819ULL, 0x000fe4000001148dULL, 0x00000092008d7245ULL, 0x000fe2000020d400ULL,
0x0001000035927824ULL, 0x000fe200078e00ffULL, 0x000000aa00937245ULL, 0x000fe2000020d400ULL,
0x0000003100957306ULL, 0x000fec0000009400ULL, 0x000000018d8d5812ULL, 0x000fc400078efcffULL,
0x0000003100967306ULL, 0x000e620000005400ULL, 0x000000919000720bULL, 0x004fe40003fdd000ULL,
0x0000009700907245ULL, 0x000fe4000020d400ULL, 0x000000a100917245ULL, 0x000fc6000020d400ULL,
0x0000003100737306ULL, 0x000eac000000d400ULL, 0x000000018c8c6812ULL, 0x000fe400078efcffULL,
0x0000009700987306ULL, 0x000fe20000209400ULL, 0x000000969500720bULL, 0x002fe20003fbd000ULL,
0x0000010036957824ULL, 0x000fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fc4000001148eULL,
0x00000099008e7245ULL, 0x000fe4000020d400ULL, 0x0000008c8d8c723eULL, 0x000fe200000010ffULL,
0x0000009700317306ULL, 0x0002ec0000205400ULL, 0x0000000173735812ULL, 0x004fe400078efcffULL,
0x0000009c009d7306ULL, 0x000fe20000209400ULL, 0x0000010037977824ULL, 0x002fce00078e00ffULL,
0x0000009c009e7306ULL, 0x000e620000205400ULL, 0x000000319800720bULL, 0x008fce0003fdd000ULL,
0x00000099009a7306ULL, 0x000fec0000209400ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x00000099009b7306ULL, 0x0004e20000205400ULL, 0x0000009e9d00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff9d7819ULL, 0x000fc4000001148fULL, 0x0000009c008f7245ULL, 0x000fe4000020d400ULL,
0x00000018ff9e7819ULL, 0x000fe20000011492ULL, 0x00000032009f7306ULL, 0x000fe20000009400ULL,
0x0000009600997245ULL, 0x004fca000020d400ULL, 0x000000018f8f5812ULL, 0x000fe400078efcffULL,
0x0000003200a07306ULL, 0x000e620000005400ULL, 0x0000009b9a00720bULL, 0x008fce0003fdd000ULL,
0x000000a100a27306ULL, 0x000fec0000209400ULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x000000a100a37306ULL, 0x0004e20000205400ULL, 0x000000a09f00720bULL, 0x002fe40003fbd000ULL,
0x0000008e8f8d723eULL, 0x000fca00000010ffULL, 0x00000032006e7306ULL, 0x000262000000d400ULL,
0x00000018ffa17819ULL, 0x004fe40000011497ULL, 0x000000ad00977245ULL, 0x000fca000020d400ULL,
0x0000003300a87306ULL, 0x000fe20000009400ULL, 0x000000a3a200720bULL, 0x008fe20003fdd000ULL,
0x0001000032327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000003300a97306ULL, 0x000e620000005400ULL, 0x000000016e6e5812ULL, 0x000fe400078efcffULL,
0x0000003200927245ULL, 0x000fc6000020d400ULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x000000aa00ab7306ULL, 0x000fe40000209400ULL, 0x0000006e916e723eULL, 0x000fcc00000010ffULL,
0x000000aa00ac7306ULL, 0x000ea20000205400ULL, 0x000000a9a800720bULL, 0x002fce0003fbd000ULL,
0x00000033006c7306ULL, 0x000e70000000d400ULL, 0x000000a500a67306ULL, 0x000fe20000209400ULL,
0x000000acab00720bULL, 0x004fce0003fdd000ULL, 0x000000a500a77306ULL, 0x000ea20000205400ULL,
0x000000016c6c5812ULL, 0x002fca00078efcffULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x0000003200a47306ULL, 0x000ff00000209400ULL, 0x0000003200337306ULL, 0x0002e20000205400ULL,
0x000000a7a600720bULL, 0x004fce0003fbd000ULL, 0x000000ad00ae7306ULL, 0x000fe20000209400ULL,
0x00000018ff327819ULL, 0x002fe40000011495ULL, 0x000000a500957245ULL, 0x000fc8000020d400ULL,
0x0000000195955812ULL, 0x000fe200078efcffULL, 0x000000ad00af7306ULL, 0x000e620000205400ULL,
0x00000033a400720bULL, 0x008fce0003fdd000ULL, 0x0000009400307306ULL, 0x000fec0000209400ULL,
0x0000000192926812ULL, 0x000fe400078efcffULL, 0x0000009400317306ULL, 0x0004e20000205400ULL,
0x000000afae00720bULL, 0x002fe40003fbd000ULL, 0x000000929592723eULL, 0x000fca00000010ffULL,
0x0000003400b07306ULL, 0x000fe20000009400ULL, 0x0000009400947245ULL, 0x004fca000020d400ULL,
0x0000000197975812ULL, 0x000fe400078efcffULL, 0x0000003400b17306ULL, 0x000e620000005400ULL,
0x000000313000720bULL, 0x008fce0003fdd000ULL, 0x0000009600987306ULL, 0x000fec0000209400ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x00000096009b7306ULL, 0x0004e20000205400ULL,
0x000000b1b000720bULL, 0x002fce0003fbd000ULL, 0x0000003400687306ULL, 0x000262000000d400ULL,
0x0001000037967824ULL, 0x004fce00078e00ffULL, 0x0000003500b57306ULL, 0x000fe20000009400ULL,
0x0000009b9800720bULL, 0x008fe20003fdd000ULL, 0x0001000034347824ULL, 0x002fe200078e00ffULL,
0x0000009d00987245ULL, 0x000fe2000020d400ULL, 0x00000100409b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000003500b67306ULL, 0x000e620000005400ULL,
0x0000000168685812ULL, 0x000fca00078efcffULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x0000009d009c7306ULL, 0x000fe40000209400ULL, 0x000000689968723eULL, 0x000fcc00000010ffULL,
0x0000009d009f7306ULL, 0x0004e20000205400ULL, 0x000000b6b500720bULL, 0x002fce0003fbd000ULL,
0x0000003500677306ULL, 0x000e62000000d400ULL, 0x00000018ff9d7819ULL, 0x004fe40000011496ULL,
0x0000003400967245ULL, 0x000fca000020d400ULL, 0x000000b200b37306ULL, 0x000fe20000209400ULL,
0x0000009f9c00720bULL, 0x008fe20003fdd000ULL, 0x00010000409f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe2000001149fULL, 0x000000b200b47306ULL, 0x000ea20000205400ULL,
0x0000000167675812ULL, 0x002fca00078efcffULL, 0x0000000198986812ULL, 0x000fe400078efcffULL,
0x00000034009a7306ULL, 0x000ff00000209400ULL, 0x0000003400357306ULL, 0x0002e20000205400ULL,
0x000000b4b300720bULL, 0x004fce0003fbd000ULL, 0x0000008b00b77306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x002fe4000001149bULL, 0x000000b2009b7245ULL, 0x000fc8000020d400ULL,
0x000000019b9b5812ULL, 0x000fe200078efcffULL, 0x0000008b00b87306ULL, 0x0002a20000205400ULL,
0x000000359a00720bULL, 0x008fce0003fdd000ULL, 0x0000009e00337306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x0000000196966812ULL, 0x000fe400078efcffULL,
0x0000009e00a07306ULL, 0x000e620000205400ULL, 0x000000b8b700720bULL, 0x004fce0003fbd000ULL,
0x00000036008a7306ULL, 0x000fec0000009400ULL, 0x000000018b8b5812ULL, 0x000fe400078efcffULL,
0x0000003600897306ULL, 0x000ea20000005400ULL, 0x000000a03300720bULL, 0x002fce0003fdd000ULL,
0x0000003200307306ULL, 0x000ff00000209400ULL, 0x0000003200317306ULL, 0x000fe20000205400ULL,
0x000000898a00720bULL, 0x004fe40003fbd000ULL, 0x0000003200897245ULL, 0x000fca000020d400ULL,
0x0000003600607306ULL, 0x0002b0000000d400ULL, 0x00000040007f7306ULL, 0x000fe20000009400ULL,
0x0001000036367824ULL, 0x002fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x00000040007e7306ULL, 0x000fe20000005400ULL, 0x0000000160605812ULL, 0x004fce00078efcffULL,
0x00000040005a7306ULL, 0x0003f0000000d400ULL, 0x0000003700887306ULL, 0x000fe20000009400ULL,
0x0000009e00407245ULL, 0x002fc8000020d400ULL, 0x0000000140406812ULL, 0x000fe400078efcffULL,
0x000000313000720bULL, 0x000fe20003fdd000ULL, 0x0000003700877306ULL, 0x000e620000005400ULL,
0x0000010041307824ULL, 0x000fe200078e00ffULL, 0x000000408b8b723eULL, 0x000fc800000010ffULL,
0x00000018ff8a7819ULL, 0x000fe20000011430ULL, 0x0000010042307824ULL, 0x000fe200078e00ffULL,
0x000000a100a27306ULL, 0x000fe80000209400ULL, 0x0000000189896812ULL, 0x000fc800078efcffULL,
0x000000a100a37306ULL, 0x000ea20000205400ULL, 0x000000878800720bULL, 0x002fe40003fbd000ULL,
0x000000a100887245ULL, 0x000fe4000020d400ULL, 0x000000608960723eULL, 0x000fc600000010ffULL,
0x0000003700617306ULL, 0x000e70000000d400ULL, 0x0000008300857306ULL, 0x000fe20000209400ULL,
0x000000a3a200720bULL, 0x004fe40003fdd000ULL, 0x00000018ffa37819ULL, 0x000fe20000011430ULL,
0x0000010043307824ULL, 0x000fc800078e00ffULL, 0x0000008300847306ULL, 0x000ea20000205400ULL,
0x0000000161615812ULL, 0x002fca00078efcffULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x00000036009c7306ULL, 0x000fe40000209400ULL, 0x000000618861723eULL, 0x000fcc00000010ffULL,
0x0000003600377306ULL, 0x000e620000205400ULL, 0x000000848500720bULL, 0x004fe40003fbd000ULL,
0x0000008300847245ULL, 0x000fca000020d400ULL, 0x0000008000827306ULL, 0x000fec0000209400ULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x0000008000817306ULL, 0x0004e20000205400ULL,
0x000000379c00720bULL, 0x002fce0003fdd000ULL, 0x0000009d00357306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x004fce000020d400ULL, 0x0000009d009a7306ULL, 0x0002a20000205400ULL,
0x000000818200720bULL, 0x008fe40003fbd000ULL, 0x0000009d00817245ULL, 0x000fca000020d400ULL,
0x0000004100747306ULL, 0x000fe20000009400ULL, 0x00000018ff9d7819ULL, 0x002fca0000011430ULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x0000004100777306ULL, 0x000fe20000005400ULL,
0x0000007e7f00720bULL, 0x000fe40003fbd000ULL, 0x00000034007f7245ULL, 0x000fca000020d400ULL,
0x00000041005b7306ULL, 0x0003ec000000d400ULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x0000003400337306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x002fca00078e00ffULL,
0x00000018ffa17819ULL, 0x000fe40000011441ULL, 0x0000003600417245ULL, 0x000fe2000020d400ULL,
0x0000003400a07306ULL, 0x0002e60000205400ULL, 0x0000000141416812ULL, 0x000fe400078efcffULL,
0x0000009a3500720bULL, 0x004fe40003fdd000ULL, 0x000000418484723eULL, 0x000fe200000010ffULL,
0x00000076007c7306ULL, 0x000fe20000209400ULL, 0x00a800003d34783bULL, 0x0022ae0000000200ULL,
0x00000076007d7306ULL, 0x000ee20000205400ULL, 0x00000100443d7824ULL, 0x002fe200078e00ffULL,
0x0000000181816812ULL, 0x000fc400078efcffULL, 0x000000a03300720bULL, 0x008fe40003fdd000ULL,
0x00a800003c30783bULL, 0x0002e40000000200ULL, 0x0000009f009e7306ULL, 0x000fe20000209400ULL,
0x0000009f003c7245ULL, 0x002fce000020d400ULL, 0x0000009f00a57306ULL, 0x000e620000205400ULL,
0x0000007d7c00720bULL, 0x000fe40003fbd000ULL, 0x000000017f7f6812ULL, 0x000fc800078efcffULL,
0x0000005a7f5a723eULL, 0x000fe200000010ffULL, 0x0000008a00a27306ULL, 0x000ff00000209400ULL,
0x0000008a00877306ULL, 0x000ee20000205400ULL, 0x000000a59e00720bULL, 0x002fe20003fdd000ULL,
0x0000003b34348231ULL, 0x084fe200003400ffULL, 0x00010000479e7824ULL, 0x000fe200078e00ffULL,
0x0000003b36368231ULL, 0x000fc400003400ffULL, 0x0000003a35358231ULL, 0x080fe400003400ffULL,
0x0000004300727306ULL, 0x000fe20000009400ULL, 0x0000003a37378231ULL, 0x000fe200003400ffULL,
0x00000018ff9e7819ULL, 0x000fc8000001149eULL, 0x000000013c3c6812ULL, 0x000fe200078efcffULL,
0x0000003b30308231ULL, 0x088fe200003400ffULL, 0x00000043006f7306ULL, 0x000fe20000005400ULL,
0x00000087a200720bULL, 0x000fe20003fdd000ULL, 0x0000003b32328231ULL, 0x000fe200003400ffULL,
0x000000739087723eULL, 0x000fe200000010ffULL, 0x0000003a31318231ULL, 0x080fe400003400ffULL,
0x0000003a33338231ULL, 0x000fe400003400ffULL, 0x0000004300527306ULL, 0x0003ea000000d400ULL,
0x000000863008723cULL, 0x000f660000041808ULL, 0x000000a1009c7306ULL, 0x000fe20000209400ULL,
0x0001000043437824ULL, 0x002fc800078e00ffULL, 0x0000008c3014723cULL, 0x040f620000041814ULL,
0x00000018ff7c7819ULL, 0x000fe40000011443ULL, 0x0000007600437245ULL, 0x000fe2000020d400ULL,
0x000000a100857306ULL, 0x000e660000205400ULL, 0x0000000143435812ULL, 0x000fe200078efcffULL,
0x00000060300c723cULL, 0x000fe2000004180cULL, 0x000000777400720bULL, 0x000fe40003fbd000ULL,
0x00000018ff747819ULL, 0x000fe2000001143dULL, 0x0000007900787306ULL, 0x000fe20000209400ULL,
0x00000100453d7824ULL, 0x000fe200078e00ffULL, 0x0000003c433c723eULL, 0x000fcc00000010ffULL,
0x00000079007b7306ULL, 0x000fe40000205400ULL, 0x000000015b5b5812ULL, 0x000fe400078efcffULL,
0x000000859c00720bULL, 0x002fe20003fbd000ULL, 0x00000100479c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe4000001143dULL, 0x0000004200757306ULL, 0x000fe20000009400ULL,
0x000000a1003d7245ULL, 0x000fe4000020d400ULL, 0x0000008500407245ULL, 0x000fc4000020d400ULL,
0x00000018ff9c7819ULL, 0x000fc6000001149cULL, 0x00000042007a7306ULL, 0x000e620000005400ULL,
0x000000013d3d5812ULL, 0x000fce00078efcffULL, 0x0000004200537306ULL, 0x0004f0000000d400ULL,
0x000000a300837306ULL, 0x000fe20000209400ULL, 0x0001000042427824ULL, 0x004fe200078e00ffULL,
0x0000007a7500720bULL, 0x002fe20003f1d000ULL, 0x0001000044757824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011442ULL, 0x000000a300827306ULL, 0x000e620000205400ULL,
0x0000008a00427245ULL, 0x000fe4000020d400ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x0000000142426812ULL, 0x000fe400078efcffULL, 0x0000007b7800720bULL, 0x000fe20003fdd000ULL,
0x0000009d00a07306ULL, 0x000fe20000209400ULL, 0x0000000153530812ULL, 0x008fc400078efcffULL,
0x000000969b8a723eULL, 0x000fe400000010ffULL, 0x0000005b425b723eULL, 0x000fc600000010ffULL,
0x0000009d00a77306ULL, 0x000ea20000205400ULL, 0x000000828300720bULL, 0x002fe20003fbd000ULL,
0x0000010046827824ULL, 0x040fe200078e00ffULL, 0x0000008a3010723cULL, 0x000fe20000041810ULL,
0x0001000046837824ULL, 0x000fc600078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0000004400657306ULL, 0x000fe20000009400ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000005a3408723cULL, 0x020fea0000041808ULL, 0x0000004400647306ULL, 0x000ff00000005400ULL,
0x00000044004f7306ULL, 0x0003f0000000d400ULL, 0x0000007e009a7306ULL, 0x000fe20000209400ULL,
0x0000007900447245ULL, 0x002fc8000020d400ULL, 0x0000000144446812ULL, 0x000fe400078efcffULL,
0x000000a7a000720bULL, 0x004fe20003fdd000ULL, 0x0000007e007d7306ULL, 0x0002a20000205400ULL,
0x0000003d443d723eULL, 0x000fce00000010ffULL, 0x0000006900707306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fe2000020d400ULL, 0x0000003c3414723cULL, 0x000fec0000041814ULL,
0x00000069006d7306ULL, 0x000e620000205400ULL, 0x0000007d9a00720bULL, 0x004fce0003f1d000ULL,
0x0000004600557306ULL, 0x000fec0000009400ULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x00000046004a7306ULL, 0x000ff00000005400ULL, 0x0000004600497306ULL, 0x0005f0000000d400ULL,
0x0000004700507306ULL, 0x000fe20000009400ULL, 0x000000a300467245ULL, 0x004fc8000020d400ULL,
0x0000000146465812ULL, 0x000fe400078efcffULL, 0x0000006f7200720bULL, 0x000fe20003fbd000ULL,
0x0000004700517306ULL, 0x000fe20000005400ULL, 0x0000006c936f723eULL, 0x000fe400000010ffULL,
0x000000949793723eULL, 0x000fe400000010ffULL, 0x000000534646723eULL, 0x000fc600000010ffULL,
0x0000004700577306ULL, 0x0005e2000000d400ULL, 0x0000006e3004723cULL, 0x000f660000041804ULL,
0x0000000152525812ULL, 0x000fc800078efcffULL, 0x00000066006b7306ULL, 0x000fe20000209400ULL,
0x0000009d00477245ULL, 0x004fe2000020d400ULL, 0x000000923018723cULL, 0x000f660000041818ULL,
0x0000000147476812ULL, 0x000fe400078efcffULL, 0x0000006d7000720bULL, 0x002fe20003fdd000ULL,
0x00000066006a7306ULL, 0x000e620000205400ULL, 0x000000524747723eULL, 0x000fce00000010ffULL,
0x0000007c00767306ULL, 0x000fe20000209400ULL, 0x000000463404723cULL, 0x020fee0000041804ULL,
0x0000007c00777306ULL, 0x0004e20000205400ULL, 0x0000006a6b00720bULL, 0x002fce0003fbd000ULL,
0x0000007400787306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x004fce000020d400ULL,
0x00000074007b7306ULL, 0x0002a20000205400ULL, 0x000000777600720bULL, 0x008fce0003f1d000ULL,
0x0000004500627306ULL, 0x000fe20000009400ULL, 0x0000007400747245ULL, 0x002fca000020d400ULL,
0x000000017c7c0812ULL, 0x000fe400078efcffULL, 0x0000004500637306ULL, 0x000fe20000005400ULL,
0x000000646500720bULL, 0x000fce0003f1d000ULL, 0x0000004500597306ULL, 0x0003ec000000d400ULL,
0x000000014f4f0812ULL, 0x000fe400078efcffULL, 0x00000085007a7306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x002fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011445ULL,
0x0000008500797306ULL, 0x0002e20000205400ULL, 0x0000006900457245ULL, 0x000fe4000020d400ULL,
0x000000679869723eULL, 0x000fe400000010ffULL, 0x0000000145456812ULL, 0x000fe400078efcffULL,
0x0000007b7800720bULL, 0x004fe20003fdd000ULL, 0x00000054005e7306ULL, 0x000fe20000209400ULL,
0x0000006600677245ULL, 0x000fe2000020d400ULL, 0x00000068301c723cULL, 0x000f62000004181cULL,
0x000000818085723eULL, 0x002fc400000010ffULL, 0x0000000167675812ULL, 0x000fe400078efcffULL,
0x0000007e457e723eULL, 0x000fe200000010ffULL, 0x00000054005f7306ULL, 0x0002a20000205400ULL,
0x000000797a00720bULL, 0x008fe20003fbd000ULL, 0x000000843020723cULL, 0x000b620000041820ULL,
0x0000007c677f723eULL, 0x000fe400000010ffULL, 0x0000000174746812ULL, 0x000fe400078efcffULL,
0x000000636200720bULL, 0x000fe20003fdd000ULL, 0x0000007500717306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x002fe2000020d400ULL, 0x0000007e3418723cULL, 0x000f680000041818ULL,
0x0000000140405812ULL, 0x000fc400078efcffULL, 0x0000007500727306ULL, 0x0002e20000205400ULL,
0x0000005f5e00720bULL, 0x004fc60003f1d000ULL, 0x0000000159596812ULL, 0x000fc800078efcffULL,
0x0000006c006d7306ULL, 0x000fe20000209400ULL, 0x0000007500757245ULL, 0x002fe4000020d400ULL,
0x000000594059723eULL, 0x000fc600000010ffULL, 0x0000000154540812ULL, 0x000fe400078efcffULL,
0x0000006c006a7306ULL, 0x0002a20000205400ULL, 0x000000727100720bULL, 0x008fce0003fbd000ULL,
0x0000003e003f7306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fca000020d400ULL,
0x0000000175755812ULL, 0x000fe400078efcffULL, 0x0000003e00587306ULL, 0x000e620000205400ULL,
0x0000006a6d00720bULL, 0x004fe40003fdd000ULL, 0x000000755454723eULL, 0x000fca00000010ffULL,
0x0000008200667306ULL, 0x000fec0000209400ULL, 0x000000016c6c6812ULL, 0x000fe400078efcffULL,
0x0000008200657306ULL, 0x0004e20000205400ULL, 0x000000583f00720bULL, 0x002fe40003fbd000ULL,
0x0000004a5500720bULL, 0x000fc40003fdd000ULL, 0x0000003e00557245ULL, 0x000fe4000020d400ULL,
0x0000004f7458723eULL, 0x000fe200000010ffULL, 0x0000009c00627306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x004fca000020d400ULL, 0x0000000155555812ULL, 0x000fe200078efcffULL,
0x00000058341c723cULL, 0x020f62000004181cULL, 0x0000009c00417306ULL, 0x0002a20000205400ULL,
0x000000656600720bULL, 0x008fe40003f1d000ULL, 0x0000000149496812ULL, 0x000fe400078efcffULL,
0x0000006c5555723eULL, 0x000fc600000010ffULL, 0x0000008300307306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fc6000020d400ULL, 0x000000543410723cULL, 0x000f640000041810ULL,
0x0000000182820812ULL, 0x000fe400078efcffULL, 0x0000008300317306ULL, 0x000e620000205400ULL,
0x000000416200720bULL, 0x004fe40003fbd000ULL, 0x000000515000720bULL, 0x000fe40003f1d000ULL,
0x000000498282723eULL, 0x000fc600000010ffULL, 0x00000048004d7306ULL, 0x000fec0000209400ULL,
0x000000019c9c5812ULL, 0x000fe400078efcffULL, 0x00000048004e7306ULL, 0x000ea20000205400ULL,
0x000000313000720bULL, 0x002fe40003fdd000ULL, 0x0000008300307245ULL, 0x000fc4000020d400ULL,
0x0000000157570812ULL, 0x000fe400078efcffULL, 0x0000004800317245ULL, 0x000fe2000020d400ULL,
0x00000038004b7306ULL, 0x000fe20000209400ULL, 0x000000579c83723eULL, 0x000fca00000010ffULL,
0x0000000130306812ULL, 0x000fe400078efcffULL, 0x00000038004c7306ULL, 0x000e620000205400ULL,
0x0000004e4d00720bULL, 0x004fe20003fbd000ULL, 0x00000082340c723cULL, 0x000f6c000004180cULL,
0x0000009e00327306ULL, 0x000fec0000209400ULL, 0x0000000131315812ULL, 0x000fc400078efcffULL,
0x0000009e00337306ULL, 0x0004e20000205400ULL, 0x0000004c4b00720bULL, 0x002fe40003f1d000ULL,
0x000000303130723eULL, 0x000fe400000010ffULL, 0x0000009e009e7245ULL, 0x004fe4000020d400ULL,
0x000000333200720bULL, 0x008fe40003fdd000ULL, 0x0000003800337245ULL, 0x000fca000020d400ULL,
0x0000000133330812ULL, 0x000fcc00078efcffULL, 0x000000019e9e6812ULL, 0x000fc800078efcffULL,
0x0000009e3331723eULL, 0x000fce00000010ffULL, 0x000000303420723cULL, 0x000b6e0000041820ULL,
0x0000f6c827307811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000030307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00056ff7f8cULL, 0x0005e2000c80043fULL, 0x000000042f5b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff447224ULL, 0x002fe200078e0031ULL, 0x000000012e407812ULL, 0x000fc400078ec0ffULL,
0x000000012d2d7810ULL, 0x002fc80007ffe0ffULL, 0x000000002d00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff215000007947ULL, 0x000fea000383ffffULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x000000ffff317224ULL, 0x000fe400078e0020ULL,
0x000000ffff207224ULL, 0x000fe400078e001fULL, 0x000000ffff1f7224ULL, 0x000fe400078e001eULL,
0x000000ffff1e7224ULL, 0x000fe400078e001dULL, 0x000000ffff1d7224ULL, 0x000fe400078e001cULL,
0x000000ffff1c7224ULL, 0x000fc400078e001bULL, 0x000000ffff1b7224ULL, 0x000fe400078e001aULL,
0x000000ffff1a7224ULL, 0x000fe400078e0019ULL, 0x000000ffff2c7224ULL, 0x004fe400078e0023ULL,
0x000000ffff267224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fe400078e0018ULL,
0x000000ffff337224ULL, 0x000fc400078e0022ULL, 0x000000ffff2a7224ULL, 0x010fe400078e0021ULL,
0x000000ffff287224ULL, 0x000fe400078e000fULL, 0x000000ffff247224ULL, 0x000fe400078e0013ULL,
0x000000ffff237224ULL, 0x000fe400078e0012ULL, 0x000000ffff187224ULL, 0x000fe400078e0007ULL,
0x000000ffff0d7224ULL, 0x000fc400078e000bULL, 0x000000ffff2f7224ULL, 0x000fe400078e000eULL,
0x000000ffff2d7224ULL, 0x000fe400078e000cULL, 0x000000ffff227224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fe400078e0010ULL, 0x000000ffff137224ULL, 0x000fe400078e0006ULL,
0x000000ffff127224ULL, 0x000fc400078e0005ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0b7224ULL, 0x000fe400078e000aULL, 0x000000ffff077224ULL, 0x000fe200078e0008ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000002b007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000f3a000047802ULL, 0x000fc40000000f00ULL, 0x0000789000007944ULL, 0x002fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002b00007308ULL, 0x000ea40000001000ULL,
0xbf80000000027423ULL, 0x004fc8000000002bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x000ee80000000000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x00000002ff067819ULL, 0x008fe40000011604ULL,
0x0000000808047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x010fca0000410000ULL,
0x00001f0605007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000000700077220ULL, 0x044fe20000410000ULL, 0x0000000900097220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x040fe20000410000ULL,
0x0000000f000f7220ULL, 0x040fe20000410000ULL, 0x0000001200127220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000001a001a7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001e001e7220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000002200227220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002600267220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002a002a7220ULL, 0x000fe20000410000ULL,
0x0000000b040b7220ULL, 0x048fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x000fc20000410000ULL,
0x00000000002b7919ULL, 0x002e620000000000ULL, 0x0000100025067824ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000100006067812ULL, 0x000fe400078ee2ffULL,
0x000000082b117811ULL, 0x002fe200078ff0ffULL, 0x0000000129297824ULL, 0x000fe200078e022bULL,
0x000000022b007812ULL, 0x000fc400078ec0ffULL, 0x00000002ff057819ULL, 0x000fe2000001162bULL,
0x00000008110e7824ULL, 0x000fe200078e00ffULL, 0x0000001100037211ULL, 0x040fe200078ff8ffULL,
0x0000001029297824ULL, 0x000fe200078e0206ULL, 0x0000000500027211ULL, 0x000fe200078ff8ffULL,
0x0000000805117824ULL, 0x040fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000000805037824ULL, 0x040fe200078e00ffULL, 0x0000000202007810ULL, 0x040fe20007ffe0ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000402047810ULL, 0x000fc40007ffe0ffULL,
0xfffffff811087812ULL, 0x000fe400078ee200ULL, 0xfffffff803007812ULL, 0x000fe200078ee202ULL,
0x0000080027037824ULL, 0x000fe200078e0206ULL, 0x0000000602057810ULL, 0x000fe20007ffe0ffULL,
0x000000082b027824ULL, 0x000fe200078e00ffULL, 0xfffffff8110a7812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x000fe200078e0203ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x0000001008087824ULL, 0x100fe200078e0203ULL, 0x0000000802057812ULL, 0x000fe200078ec0ffULL,
0x000000100e0e7824ULL, 0x100fe200078e0203ULL, 0x000000070900723eULL, 0x000fe200000010ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0x000000141502723eULL, 0x000fe200000010ffULL,
0x0000000104077824ULL, 0x000fe200078e0205ULL, 0x000000212204723eULL, 0x000fe200000010ffULL,
0x0000000105087824ULL, 0x040fe200078e0208ULL, 0x0000541000107816ULL, 0x100fe20000000002ULL,
0x000000100c0c7824ULL, 0x000fe200078e0203ULL, 0x0000763200117816ULL, 0x000fe20000000002ULL,
0x00000001050a7824ULL, 0x040fe200078e020aULL, 0x0000000f1200723eULL, 0x000fe200000010ffULL,
0x00000001050c7824ULL, 0x040fe200078e020cULL, 0x000000191a02723eULL, 0x000fe200000010ffULL,
0x0000001007007388ULL, 0x0003e20000000a00ULL, 0x0000001d1e03723eULL, 0x000fe200000010ffULL,
0x00000001050e7824ULL, 0x000fe200078e020eULL, 0x0000541000107816ULL, 0x002fc40000000002ULL,
0x0000763200117816ULL, 0x000fe40000000002ULL, 0x0000002d2600723eULL, 0x000fe400000010ffULL,
0x000000312a02723eULL, 0x000fe200000010ffULL, 0x0000001008007388ULL, 0x0003e40000000a00ULL,
0x0000541003107816ULL, 0x142fe40000000004ULL, 0x0000763203117816ULL, 0x000fe40000000004ULL,
0x0000000b0d03723eULL, 0x000fc400000010ffULL, 0x000000161704723eULL, 0x000fe200000010ffULL,
0x000000100a007388ULL, 0x0003e40000000a00ULL, 0x0000541000107816ULL, 0x142fe40000000002ULL,
0x0000763200117816ULL, 0x000fe40000000002ULL, 0x000000131800723eULL, 0x000fe400000010ffULL,
0x0000001b1c02723eULL, 0x000fe200000010ffULL, 0x000000100c007388ULL, 0x0003e60000000a00ULL,
0x00007632000f7816ULL, 0x000fc40000000002ULL, 0x0000541003107816ULL, 0x142fe40000000004ULL,
0x0000763203117816ULL, 0x000fe40000000004ULL, 0x0000001f2003723eULL, 0x000fe400000010ffULL,
0x000000232404723eULL, 0x000fe200000010ffULL, 0x000000100e007388ULL, 0x0003e60000000a00ULL,
0x0000763203097816ULL, 0x000fc40000000004ULL, 0x00005410000e7816ULL, 0x002fe40000000002ULL,
0x0000002f2800723eULL, 0x000fe400000010ffULL, 0x000000332c02723eULL, 0x000fe200000010ffULL,
0x0004000e08007388ULL, 0x0003e60000000a00ULL, 0x0000763200057816ULL, 0x000fe40000000002ULL,
0x0000541003087816ULL, 0x002fc40000000004ULL, 0x0000541000047816ULL, 0x000fe20000000002ULL,
0x000000ff00037306ULL, 0x000fe40000205400ULL, 0x000400080a007388ULL, 0x000fe80000000a00ULL,
0x000400040c007388ULL, 0x000fe40000000a00ULL, 0x000000ff00007306ULL, 0x000e640000209400ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000029107984ULL, 0x000ea80000000c00ULL,
0x0004000029087984ULL, 0x000ee80000000c00ULL, 0x0008000029147984ULL, 0x000f220000000c00ULL,
0x000000030000720bULL, 0x002fc40003f1d000ULL, 0x000000ff00007245ULL, 0x000fe2000020d400ULL,
0x000c000029187984ULL, 0x000e740000000c00ULL, 0x0000000100000812ULL, 0x000fc400078efcffULL,
0x000000ff2700720cULL, 0x000fe40003f05270ULL, 0x000000000000723eULL, 0x000fca00000010ffULL,
0x3f803f8000137831ULL, 0x044fe40000200013ULL, 0x3f803f8000127831ULL, 0x040fe40000200012ULL,
0x3f803f8000117831ULL, 0x040fe40000200011ULL, 0x3f803f8000107831ULL, 0x040fe40000200010ULL,
0x3f803f80000b7831ULL, 0x048fe4000020000bULL, 0x3f803f80000a7831ULL, 0x000fc4000020000aULL,
0x3f803f8000097831ULL, 0x040fe40000200009ULL, 0x3f803f8000087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x010fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fc40000200014ULL,
0x3f803f800b0b7831ULL, 0x002fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x0000001029007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x0004000829007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000202b0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000047919ULL, 0x000e620000002600ULL,
0x00000003ff0e7819ULL, 0x100fe2000001162bULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff057819ULL, 0x000fe2000001160cULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000125257812ULL, 0x000fe200078ec0ffULL, 0x000000010e007824ULL, 0x000fe200078e022bULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x000000010c027824ULL, 0x000fc600078e0205ULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0000000702077812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800037812ULL, 0x000fe400078ef82bULL, 0x0ffffff807077812ULL, 0x000fc600078ef80cULL,
0x0000001003037824ULL, 0x100fe400078e0206ULL, 0x0000001007077824ULL, 0x000fe400078e0206ULL,
0x00000008040d7824ULL, 0x042fe200078e00ffULL, 0x0000000003087984ULL, 0x000e620000000c00ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0x0000000007107984ULL, 0x0004e20000000c00ULL, 0xfffffff80d007812ULL, 0x000fe200078ee20eULL,
0x00000008250e7824ULL, 0x040fe200078e00ffULL, 0xfffffff804057812ULL, 0x000fe200078ee205ULL,
0x00000008250d7824ULL, 0x000fe200078e00ffULL, 0x0000000400067c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff80e077812ULL, 0x004fe200078ee22bULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0006027a11ULL, 0x040fe200078040ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x040fe400078240ffULL,
0x00005b0006037a11ULL, 0x000fe400000f4403ULL, 0x00005b0005057a11ULL, 0x000fc400008f4400ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000022500720cULL, 0x000fe20003f06070ULL, 0xffffffffff267424ULL, 0x000fd800078e00ffULL,
0x000000023d068824ULL, 0x000fc800078e00ffULL, 0x0000640006068a24ULL, 0x000fc800078e0225ULL,
0x0000600006068625ULL, 0x000fe200078e002bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff3e7624ULL, 0x000fe200078e00ffULL, 0x0000000606268981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff3f7624ULL, 0x000fc600078e00ffULL, 0x00f60000ff047f8cULL, 0x000e68000c80043fULL,
0x000000063e3e7981ULL, 0x000722000c1e9900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x0000004027277824ULL, 0x000fe400078e00ffULL, 0x0000004025387824ULL, 0x000fe400078e00ffULL,
0x0000004028397824ULL, 0x000fc400078e00ffULL, 0x0000002726217224ULL, 0x004fcc00078e02ffULL,
0x0000071000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011624ULL,
0x000000300d1f7812ULL, 0x000fe400078ec0ffULL, 0x00001000250f7811ULL, 0x000fe200078e68ffULL,
0x00000040280e7824ULL, 0x000fe200078e021dULL, 0x000000181d237810ULL, 0x040fe40007ffe0ffULL,
0x000000201d177810ULL, 0x000fe40007ffe0ffULL, 0x000000180e087810ULL, 0x000fc40007ffe0ffULL,
0x000000100e077810ULL, 0x040fe40007ffe0ffULL, 0x0000000821087210ULL, 0x040fe40007f7e0ffULL,
0x000000080e067810ULL, 0x000fe40007ffe0ffULL, 0x0000000721127210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff077224ULL, 0x000fe200018e06ffULL, 0x0000000e21137210ULL, 0x040fe40007f1e0ffULL,
0x0000000621067210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00005e0008147a11ULL, 0x040fe200078638ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005e00130a7a11ULL, 0x000fe200078038ffULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x00005f0008167a11ULL, 0x000fc400018f3c07ULL, 0x0000003803077217ULL, 0x000fe40007800000ULL,
0x00005e0006107a11ULL, 0x000fe400078238ffULL, 0x00005e00120b7a11ULL, 0x000fe400078438ffULL,
0x00005f0013137a11ULL, 0x000fe200000f3c0cULL, 0x00000001070c7824ULL, 0x000fe200078e0a38ULL,
0x00005f0006157a11ULL, 0x000fe400008f3c15ULL, 0x0000002424067211ULL, 0x000fc400078fe8ffULL,
0x000000081d077810ULL, 0x040fe40007ffe0ffULL, 0x00005f0012127a11ULL, 0x000fe400010f3c09ULL,
0x000000101d097810ULL, 0x000fe20007ffe0ffULL, 0x0000000407087824ULL, 0x000fe200078e00ffULL,
0x00000003060d7812ULL, 0x000fe400078ec0ffULL, 0x0000000a1f067210ULL, 0x000fe20007f7e0ffULL,
0x0000000409187824ULL, 0x000fe200078e00ffULL, 0x0000000c1d00720cULL, 0x000fc40003f06070ULL,
0x0000000c0700720cULL, 0x080fe20003f26070ULL, 0x000000ffff077224ULL, 0x000fe200018e0613ULL,
0xfffffffc080a7812ULL, 0x000fe400078ee20dULL, 0x0ffffffc0d247812ULL, 0x000fe400078ef824ULL,
0x0000001f10087210ULL, 0x080fe20007f7e0ffULL, 0x000000100a137824ULL, 0x000fe200078e020fULL,
0xfffffffc18107812ULL, 0x000fe200078ee20dULL, 0x0000001024117824ULL, 0x000fe200078e020fULL,
0x0000000c0900720cULL, 0x000fe20003f46070ULL, 0x000000ffff097224ULL, 0x000fe200018e0615ULL,
0x0000001f0b0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001010157824ULL, 0x000fe200078e020fULL,
0x000000200e107810ULL, 0x000fe20007ffe0ffULL, 0x0000000423187824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200020e0612ULL, 0x0000001021107210ULL, 0x000fc40007f1e0ffULL,
0x0000000008137faeULL, 0x0005e2000c901c46ULL, 0x0000000c2300720cULL, 0x000fe40003f86070ULL,
0x00005e0010127a11ULL, 0x000fe200078c38ffULL, 0x000000000a157faeULL, 0x0007e2000d101c46ULL,
0x000000281d197810ULL, 0x040fe40007ffe0ffULL, 0x000000301d1b7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x002fe200000e06ffULL, 0x0000001f14067210ULL, 0x000fe40007fbe0ffULL,
0x000000381d1d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffffc18087812ULL, 0x004fe400078ee20dULL,
0x00005f0010147a11ULL, 0x000fe200030f3c07ULL, 0x000000ffff077224ULL, 0x000fe200028e0616ULL,
0x000000300e0a7810ULL, 0x008fe20007ffe0ffULL, 0x0000001008097824ULL, 0x000fe200078e020fULL,
0x000000280e087810ULL, 0x000fe20007ffe0ffULL, 0x000000041d167824ULL, 0x000fe200078e00ffULL,
0x0000000c1700720cULL, 0x000fe40003f66070ULL, 0x0000000821107210ULL, 0x000fe20007fbe0ffULL,
0x0000000417087824ULL, 0x000fe200078e00ffULL, 0x0000000006097faeULL, 0x0003e2000e101c46ULL,
0x0000000c1900720cULL, 0x000fc40003f46070ULL, 0x0000000c1b00720cULL, 0x080fe40003f26070ULL,
0x0000000c1d00720cULL, 0x000fe20003f06070ULL, 0x000000041b0c7824ULL, 0x000fe200078e00ffULL,
0x0000000a210b7210ULL, 0x000fe20007f9e0ffULL, 0x00000004190a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc08087812ULL, 0x100fe400078ee20dULL, 0xfffffffc0c0c7812ULL, 0x100fe200078ee20dULL,
0x000000ffff097224ULL, 0x002fe200028e06ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee20dULL,
0x0000001008117824ULL, 0x000fe200078e020fULL, 0xfffffffc16067812ULL, 0x000fe200078ee20dULL,
0x000000100c157824ULL, 0x100fe200078e020fULL, 0x00005e0010087a11ULL, 0x000fe200078a38ffULL,
0x000000100a137824ULL, 0x100fe200078e020fULL, 0x000000380e0e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010060f7824ULL, 0x000fe200078e020fULL, 0x00005f0010097a11ULL, 0x000fe200028f3c09ULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x0000001f12067210ULL, 0x000fc40007fbe0ffULL,
0x0000000e210e7210ULL, 0x000fe40007fde0ffULL, 0x00005e000b0a7a11ULL, 0x040fe200078838ffULL,
0x000000ffff077224ULL, 0x000fe200028e0614ULL, 0x0000001f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x00005e000e0c7a11ULL, 0x000fe400078c38ffULL,
0x00005f000b0b7a11ULL, 0x000fe200020f3c10ULL, 0x000000ffff097224ULL, 0x000fe200028e0609ULL,
0x0000001f0a0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000006117faeULL, 0x0003e2000d901c46ULL,
0x00005f000e0d7a11ULL, 0x000fc400030f3c0dULL, 0x0000001f0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x0000000008137faeULL, 0x0003e6000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x000000000a157faeULL, 0x0003e8000c901c46ULL,
0x000000000c0f7faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000003924067211ULL, 0x04afe400078ff0ffULL, 0x00000020240c7811ULL, 0x000fc400078ff0ffULL,
0x0000000621067210ULL, 0x000fe40007f1e0ffULL, 0x0000003024107811ULL, 0x040fe200078ff0ffULL,
0x00000001390b7824ULL, 0x040fe200078e020cULL, 0x0000000824167811ULL, 0x000fe200078ff0ffULL,
0x000000ffff297224ULL, 0x000fe200000e06ffULL, 0x00005e0006287a11ULL, 0x000fe200078038ffULL,
0x0000000139117824ULL, 0x040fe200078e0210ULL, 0x00000018240a7811ULL, 0x000fe200078ff0ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x0000001024087811ULL, 0x000fe200078ff0ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x0000002424147211ULL, 0x000fe200078fe8ffULL,
0x0000000139097824ULL, 0x040fe200078e020aULL, 0x00005f0006297a11ULL, 0x000fe200000f3c29ULL,
0x0000000139067824ULL, 0x040fe200078e0216ULL, 0x00000028240e7811ULL, 0x040fe200078ff0ffULL,
0x0000000139077824ULL, 0x040fe200078e0208ULL, 0x0000003824127811ULL, 0x000fe200078ff0ffULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x0000000314177812ULL, 0x000fe200078ec0ffULL,
0x00000001390f7824ULL, 0x000fe200078e020eULL, 0x0000000b211a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000139137824ULL, 0x000fe200078e0212ULL, 0x0000000621227210ULL, 0x040fe20007fde0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x00000009211c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000416067824ULL, 0x000fe200078e00ffULL, 0x0000100025237811ULL, 0x000fe200078e68ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc100b7812ULL, 0x100fe200078ee217ULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x00000007211e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200030e06ffULL, 0xfffffffc0c097812ULL, 0x000fc400078ee217ULL,
0xfffffffc08077812ULL, 0x000fe400078ee217ULL, 0x0000000f210f7210ULL, 0x000fe20007f5e0ffULL,
0x00000010091d7824ULL, 0x100fe200078e0223ULL, 0x0000001121117210ULL, 0x000fe20007f7e0ffULL,
0x0000001007197824ULL, 0x100fe200078e0223ULL, 0x0000001321137210ULL, 0x000fe20007f9e0ffULL,
0x000000100b217824ULL, 0x000fe200078e0223ULL, 0xfffffffc0a087812ULL, 0x100fe200078ee217ULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0xfffffffc06067812ULL, 0x000fe200078ee217ULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0022207a11ULL, 0x000fe200078c38ffULL,
0x00000010081b7824ULL, 0x000fe200078e0223ULL, 0xfffffffc0e0a7812ULL, 0x000fe200078ee217ULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x00005e001c097a11ULL, 0x000fe200078038ffULL,
0x000000ffff087224ULL, 0x000fe200020e06ffULL, 0x000000300d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000100a1f7824ULL, 0x000fe200078e0223ULL, 0x00005e001a0e7a11ULL, 0x000fe200078238ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x0ffffffc17247812ULL, 0x000fc400078ef824ULL,
0xfffffffc120c7812ULL, 0x000fe200078ee217ULL, 0x0000001006177824ULL, 0x000fe200078e0223ULL,
0x00005f0022227a11ULL, 0x000fe200030f3c15ULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x00005f001c1c7a11ULL, 0x000fe200000f3c0bULL, 0x00000010242b7824ULL, 0x100fe200078e0223ULL,
0x00005e001e0a7a11ULL, 0x000fe200078a38ffULL, 0x000000100c237824ULL, 0x000fe200078e0223ULL,
0x000000280d067210ULL, 0x000fe40007f1e0ffULL, 0x00005f001a1a7a11ULL, 0x000fc400008f3c07ULL,
0x00005e0013147a11ULL, 0x000fe200078638ffULL, 0x000000ffff077224ULL, 0x000fe200000e0629ULL,
0x00005e000f107a11ULL, 0x000fe400078238ffULL, 0x00005e0011127a11ULL, 0x000fe400078438ffULL,
0x00005f001e1e7a11ULL, 0x000fe200028f3c15ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000062b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0013157a11ULL, 0x000fe400018f3c08ULL,
0x00005f000f187a11ULL, 0x000fc400008f3c18ULL, 0x000000200d087210ULL, 0x000fe40007f1e0ffULL,
0x00005f0011167a11ULL, 0x000fe400010f3c16ULL, 0x0000000a0d0a7210ULL, 0x040fe40007f3e0ffULL,
0x000000090d0c7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0622ULL,
0x0000000e0d0e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e061eULL,
0x000000100d107210ULL, 0x000fc40007f9e0ffULL, 0x000000120d127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e061aULL, 0x000000140d147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061cULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fe400020e0618ULL, 0x000000ffff137224ULL, 0x000fe200028e0616ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc600000e0615ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000002025047824ULL, 0x002fca00078e0204ULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05077812ULL, 0x000fe400078ec0ffULL, 0x0000000f04057812ULL, 0x000fc600078ec0ffULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x0000001005097824ULL, 0x040fe400078e00ffULL,
0x0000001005067824ULL, 0x000fe200078e00ffULL, 0x0000000f07047812ULL, 0x040fe400078ec0ffULL,
0x0000000107077810ULL, 0x000fe40007ffe0ffULL, 0x000000f009047812ULL, 0x000fe400078ee204ULL,
0x0000000f07077812ULL, 0x000fc600078ec0ffULL, 0x00000000040c7984ULL, 0x000e62000000cc00ULL,
0x000000f006077812ULL, 0x000fca00078ee207ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001004007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000e620000000000ULL,
0x000064003d3d7a24ULL, 0x000fe200078e02ffULL, 0x3db504f33e3e7820ULL, 0x010fe20000410000ULL,
0x0000f688253f7811ULL, 0x040fe200078e18ffULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0xffffffff00407810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff447224ULL, 0x000fe200078e0025ULL,
0x0000f60825417811ULL, 0x000fc600078e28ffULL, 0x0000010043467824ULL, 0x000fe200078e0238ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000460300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff487224ULL, 0x000fe200078e0042ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fc4000001ff00ULL, 0x0000000145287810ULL, 0x020fe20007ffe0ffULL,
0x00000d6000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e0045ULL,
0x0000000148427812ULL, 0x000fe200078e0cffULL, 0x0000002726377224ULL, 0x010fe200078e02ffULL,
0x00000043282b7211ULL, 0x040fe200078ff8ffULL, 0x000000ffff457224ULL, 0x000fe200078e0028ULL,
0x000000022800780cULL, 0x000fc40003f06070ULL, 0x000000012b297810ULL, 0x000fe40007ffe0ffULL,
0x0000000128587812ULL, 0x000fe400078ec0ffULL, 0x000000002900720cULL, 0x000fda0003f26070ULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff337819ULL, 0x002fe20000011624ULL,
0x000001002b2e7824ULL, 0x000fe400078e0238ULL, 0x0000000458557824ULL, 0x000fe200078e00ffULL,
0x00000008333b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000139287824ULL, 0x000fe200078e0233ULL,
0x00000010334f7810ULL, 0x000fe20007ffe0ffULL, 0x00000002253c7824ULL, 0x000fe200078e0242ULL,
0x0000002e03297217ULL, 0x000fe20007800000ULL, 0x00000001392a7824ULL, 0x000fe200078e023bULL,
0x0000002837317210ULL, 0x000fe20007f3e0ffULL, 0x00000001392b7824ULL, 0x000fe200078e024fULL,
0x0000001833507810ULL, 0x000fe20007ffe0ffULL, 0x00000001293a7824ULL, 0x000fe200078e0a2eULL,
0x0000002a372f7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x0000002b372d7210ULL, 0x000fe20007f7e0ffULL, 0x00000001392e7824ULL, 0x000fe200078e0250ULL,
0x0000002033517810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x00005e002f2a7a11ULL, 0x000fe200078438ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005e002d2c7a11ULL, 0x000fc400078638ffULL, 0x0000002833527810ULL, 0x000fe40007ffe0ffULL,
0x00005e0031287a11ULL, 0x000fe400078238ffULL, 0x0000003033537810ULL, 0x000fe40007ffe0ffULL,
0x00005f002f2b7a11ULL, 0x000fe200010f3c32ULL, 0x00000001392f7824ULL, 0x000fe200078e0251ULL,
0x00005f002d2d7a11ULL, 0x000fe200018f3c30ULL, 0x0000000139307824ULL, 0x000fe200078e0252ULL,
0x0000003833547810ULL, 0x000fc40007ffe0ffULL, 0x00005f0031297a11ULL, 0x000fe200008f3c34ULL,
0x0000000139317824ULL, 0x000fe200078e0253ULL, 0x0000002e37367210ULL, 0x000fe20007f3e0ffULL,
0x0000000139327824ULL, 0x000fe200078e0254ULL, 0x0000003a3300720cULL, 0x000fe40003f46070ULL,
0x0000002f37347210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e06ffULL,
0x0000003037337210ULL, 0x000fe40007fde0ffULL, 0x0000002424307211ULL, 0x000fc400078fe8ffULL,
0x00005e00362e7a11ULL, 0x000fe200078238ffULL, 0x000000ffff4e7224ULL, 0x000fe200030e06ffULL,
0x0000003137357210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x0000003237377210ULL, 0x000fe20007f7e0ffULL, 0x000000043b327824ULL, 0x040fe200078e00ffULL,
0x00000003304d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005f00362f7a11ULL, 0x000fe200008f3c2fULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x0000003a3b00720cULL, 0x000fc40003f26070ULL, 0x000010003c3c7811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4d497812ULL, 0x100fe400078ef824ULL, 0xfffffffc553b7812ULL, 0x000fe400078ee224ULL,
0xfffffffc324b7812ULL, 0x000fe200078ee24dULL, 0x0000001049497824ULL, 0x000fe200078e023cULL,
0x00005e0034307a11ULL, 0x000fe200078a38ffULL, 0x000000103b287825ULL, 0x000fe200078e0028ULL,
0x00005e0037367a11ULL, 0x000fc400078638ffULL, 0x00005f0034317a11ULL, 0x000fe200028f3c31ULL,
0x000000104b4b7824ULL, 0x000fe200078e023cULL, 0x00005e0033327a11ULL, 0x000fe200078a38ffULL,
0x000000103b2a7825ULL, 0x000fe200078e002aULL, 0x00005e0035347a11ULL, 0x000fe200078838ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028497faeULL, 0x0003e2000d101c46ULL,
0x00005f0033337a11ULL, 0x000fe400028f3c4eULL, 0x00005f0035357a11ULL, 0x000fe200020f3c4cULL,
0x000000002a4b7faeULL, 0x0005e2000c901c46ULL, 0x00005f0037377a11ULL, 0x000fe200018f3c4aULL,
0x00000004514a7824ULL, 0x000fe200078e00ffULL, 0x0000003a4f00720cULL, 0x000fc40003f26070ULL,
0x0000003a5000720cULL, 0x0c0fe20003f46070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x0000003a5100720cULL, 0x080fe20003f66070ULL, 0x0000000453287824ULL, 0x042fe200078e00ffULL,
0x0000003a5200720cULL, 0x0c0fe20003f86070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x0000003a5300720cULL, 0x080fe20003fa6070ULL, 0x000000103b2a7825ULL, 0x004fe200078e002eULL,
0x0000003a5400720cULL, 0x000fe40003fc6070ULL, 0xfffffffc4a297812ULL, 0x100fe200078ee24dULL,
0x000000044f3a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc504b7812ULL, 0x100fe200078ee24dULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc524f7812ULL, 0x000fe200078ee24dULL,
0x000000103b2e7825ULL, 0x000fe200078e0032ULL, 0xfffffffc3a497812ULL, 0x000fc400078ee24dULL,
0xfffffffc28517812ULL, 0x100fe200078ee24dULL, 0x000000104b4b7824ULL, 0x100fe200078e023cULL,
0xfffffffc54537812ULL, 0x000fe200078ee24dULL, 0x00000010294d7824ULL, 0x100fe400078e023cULL,
0x0000001049497824ULL, 0x000fe400078e023cULL, 0x000000103b287825ULL, 0x000fc800078e002cULL,
0x000000103b2c7825ULL, 0x000fe200078e0030ULL, 0x0000000028497faeULL, 0x0003e6000c901c46ULL,
0x000000104f4f7824ULL, 0x100fe200078e023cULL, 0x000000002a4b7faeULL, 0x0003e2000d101c46ULL,
0x0000001051517824ULL, 0x000fe400078e023cULL, 0x000000103b307825ULL, 0x000fe200078e0034ULL,
0x000000002c4d7faeULL, 0x0003e6000d901c46ULL, 0x0000001053537824ULL, 0x000fe200078e023cULL,
0x000000002e4f7faeULL, 0x0003e2000e101c46ULL, 0x000000103b327825ULL, 0x000fc600078e0036ULL,
0x0000000030517faeULL, 0x0003e8000e901c46ULL, 0x0000000032537faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000824307811ULL, 0x002fe200078ff0ffULL,
0x0000000458557824ULL, 0x000fe200078e00ffULL, 0x0000003924287211ULL, 0x040fe400078ff0ffULL,
0x0000001024327811ULL, 0x000fe200078ff0ffULL, 0x00000001392a7824ULL, 0x040fe200078e0230ULL,
0x0000003728297210ULL, 0x080fe20007f3e0ffULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0x0000001824367811ULL, 0x000fe200078ff0ffULL, 0x0000000139347824ULL, 0x000fe200078e0232ULL,
0x000000372a2b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078238ffULL, 0x00000001393a7824ULL, 0x000fe200078e0236ULL,
0x00000020243c7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078438ffULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0x00005f0029297a11ULL, 0x000fe200008f3c2eULL, 0x00000001394a7824ULL, 0x000fe200078e023cULL,
0x00000024242e7211ULL, 0x000fc400078fe8ffULL, 0x00005f002b2b7a11ULL, 0x000fe200010f3c2cULL,
0x00000002252c7824ULL, 0x000fe200078e0242ULL, 0x00000028244c7811ULL, 0x040fe400078ff0ffULL,
0x0000003024507811ULL, 0x040fe400078ff0ffULL, 0x0000003824547811ULL, 0x000fe200078ff0ffULL,
0x00000001394e7824ULL, 0x040fe200078e024cULL, 0x000000032e3b7812ULL, 0x000fe200078ec0ffULL,
0x0000000139527824ULL, 0x000fe200078e0250ULL, 0x00000037342d7210ULL, 0x080fe20007fde0ffULL,
0x0000000432347824ULL, 0x000fe200078e00ffULL, 0x000000373a2f7210ULL, 0x080fe20007fbe0ffULL,
0x000000043c3a7824ULL, 0x000fe200078e00ffULL, 0x000000374a317210ULL, 0x080fe20007f9e0ffULL,
0x000000044c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc30327812ULL, 0x100fe200078ee23bULL,
0x00000004504a7824ULL, 0x000fe200078e00ffULL, 0x000010002c537811ULL, 0x000fe200078e60ffULL,
0x00000004544c7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc3b307812ULL, 0x000fe200078ef824ULL,
0x000000ffff2e7224ULL, 0x000fe200030e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078c38ffULL,
0x0000000139567824ULL, 0x000fe200078e0254ULL, 0xfffffffc34347812ULL, 0x000fe200078ee23bULL,
0x0000001030577824ULL, 0x000fe200078e0253ULL, 0xfffffffc36367812ULL, 0x100fe200078ee23bULL,
0x000000ffff307224ULL, 0x000fe200028e06ffULL, 0xfffffffc3a3a7812ULL, 0x000fe200078ee23bULL,
0x0000001034497824ULL, 0x000fe200078e0253ULL, 0xfffffffc3c3c7812ULL, 0x000fe200078ee23bULL,
0x00000010364b7824ULL, 0x000fe200078e0253ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee23bULL,
0x000000103a4d7824ULL, 0x000fe200078e0253ULL, 0xfffffffc4c4c7812ULL, 0x000fe200078ee23bULL,
0x00000010323b7824ULL, 0x100fe200078e0253ULL, 0x00005f002d2d7a11ULL, 0x000fe200030f3c2eULL,
0x000000103c4f7824ULL, 0x100fe200078e0253ULL, 0x000000374e337210ULL, 0x080fe20007f3e0ffULL,
0x000000104a517824ULL, 0x100fe200078e0253ULL, 0x00005e002f2e7a11ULL, 0x040fe200078a38ffULL,
0x000000104c537824ULL, 0x000fe200078e0253ULL, 0x0000003752357210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000003756377210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200008e06ffULL, 0x00005f002f2f7a11ULL, 0x000fe200028f3c30ULL,
0x000000ffff3c7224ULL, 0x000fe200010e06ffULL, 0xfffffffc55557812ULL, 0x000fe200078ee224ULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e0031307a11ULL, 0x000fc400078838ffULL,
0x00005e0033327a11ULL, 0x000fe200078238ffULL, 0x0000001055287825ULL, 0x000fe200078e0028ULL,
0x00005e0035347a11ULL, 0x000fe400078438ffULL, 0x00005e0037367a11ULL, 0x000fe200078638ffULL,
0x00000010552a7825ULL, 0x000fe200078e002aULL, 0x00005f0031317a11ULL, 0x000fe200020f3c4cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028577faeULL, 0x0003e2000b901c46ULL,
0x00005f0033337a11ULL, 0x000fe200008f3c4aULL, 0x00000010552c7825ULL, 0x000fe200078e002cULL,
0x00005f0035357a11ULL, 0x000fe200010f3c3cULL, 0x000000002a3b7faeULL, 0x0003e2000b901c46ULL,
0x00005f0037377a11ULL, 0x000fe200018f3c3aULL, 0x00000010552e7825ULL, 0x000fc400078e002eULL,
0x000000002c497faeULL, 0x0003e4000b901c46ULL, 0x0000001055307825ULL, 0x040fe400078e0030ULL,
0x000000002e4b7faeULL, 0x0003e4000b901c46ULL, 0x0000001055327825ULL, 0x040fe400078e0032ULL,
0x00000000304d7faeULL, 0x0003e4000b901c46ULL, 0x0000001055347825ULL, 0x000fc400078e0034ULL,
0x00000000324f7faeULL, 0x0003e4000b901c46ULL, 0x0000001055367825ULL, 0x000fe400078e0036ULL,
0x0000000034517faeULL, 0x0003e8000b901c46ULL, 0x0000000036537faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5800720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x0000000444447810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff267424ULL, 0x000fc600078e00ffULL,
0x000000024400720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000023d287824ULL, 0x002fe400078e0244ULL, 0x00000004ff297424ULL, 0x000fc800078e00ffULL,
0x0000600028287625ULL, 0x000fca00078e0029ULL, 0x0000000628267981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff824297812ULL, 0x022fe200078ec0ffULL, 0x00000002252d7824ULL, 0x000fe200078e0248ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014a2e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000729297812ULL, 0x000fe400078ef824ULL, 0x000010002d2d7811ULL, 0x000fe400078e60ffULL,
0x00000001ff2b7819ULL, 0x000fe20000011629ULL, 0x00000004292f7824ULL, 0x000fe200078e00ffULL,
0x0000000724bf7812ULL, 0x000fc600078ec0ffULL, 0x000000012b287824ULL, 0x000fe200078e024aULL,
0x00000008bfd27812ULL, 0x000fe200078ef824ULL, 0x000000012b2b7824ULL, 0x000fc600078e022eULL,
0xfffffffc2f287812ULL, 0x000fe200078ee228ULL, 0x00000010d2d47824ULL, 0x000fe200078e00ffULL,
0x00000020242f7810ULL, 0x000fc60007ffe0ffULL, 0x0000001028347824ULL, 0x000fe200078e022dULL,
0xfffffff82f2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000429287824ULL, 0x000fc600078e00ffULL,
0x000000072f2f7812ULL, 0x000fe200078ef824ULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0xfffffffc28287812ULL, 0x000fe400078ee22bULL, 0x00000001ff497819ULL, 0x000fe2000001162fULL,
0x000000042f317824ULL, 0x000fe400078e00ffULL, 0x0000001028287824ULL, 0x000fe400078e022dULL,
0x00000001492c7824ULL, 0x040fe400078e024aULL, 0x00000001492e7824ULL, 0x000fc400078e022eULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0xfffffffc312c7812ULL, 0x000fe200078ee22cULL,
0x000000042f2f7824ULL, 0x000fc800078e00ffULL, 0x000000102c2c7824ULL, 0x000fe200078e022dULL,
0xfffffffc2f2e7812ULL, 0x000fc800078ee22eULL, 0x000000002c30783bULL, 0x000ee20000000200ULL,
0x000000102e2e7824ULL, 0x000fcc00078e022dULL, 0x000000002e2c783bULL, 0x000ee20000000200ULL,
0x0000003400b67306ULL, 0x002fe20000009400ULL, 0x00000018ffac7819ULL, 0x000fe20000011434ULL,
0x0001000034507824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe20000011435ULL,
0x0001000035bd7824ULL, 0x040fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011436ULL,
0x0000010035c27824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe20000011450ULL,
0x0000003400b57306ULL, 0x000e620000005400ULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x0001000036b87824ULL, 0x040fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0000010036af7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x004fe2000001142bULL,
0x0001000037ae7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x0000003400687306ULL, 0x0004e2000000d400ULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000010037ab7824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x000100002a797824ULL, 0x040fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe2000001142aULL,
0x000001002a787824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x008fe20000011431ULL,
0x000000c300c47306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x004fe200078e00ffULL,
0x000000b5b600720bULL, 0x002fe20003f9d000ULL, 0x0001000031bf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0001000030bb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe20000011434ULL, 0x0001000029877824ULL, 0x040fe200078e00ffULL,
0x000000c300c57306ULL, 0x000e620000205400ULL, 0x00000018ff6c7819ULL, 0x000fe20000011429ULL,
0x0000010029897824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0000010028887824ULL, 0x040fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe20000011437ULL,
0x0001000028827824ULL, 0x000fe200078e00ffULL, 0x0000000168684812ULL, 0x000fe200078efcffULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x00000018ff8e7819ULL, 0x000fc40000011433ULL,
0x00000018ffbf7819ULL, 0x000fe400000114bfULL, 0x00000018ff9f7819ULL, 0x000fe40000011430ULL,
0x00000018ff967819ULL, 0x000fe20000011432ULL, 0x000000c600c87306ULL, 0x000ea20000205400ULL,
0x000000c5c400720bULL, 0x002fe20003f5d000ULL, 0x000100002bc47824ULL, 0x040fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe20000011488ULL, 0x000001002bc57824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fc40000011428ULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0000003500b07306ULL, 0x000fe20000009400ULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x00000018ff347819ULL, 0x000fe4000001142cULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0000003500ad7306ULL, 0x000e620000005400ULL,
0x000000c8c700720bULL, 0x004fc40003f7d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000018ff507819ULL, 0x000fe4000001142eULL, 0x00000018ff537819ULL, 0x000fe2000001142fULL,
0x000000ac00b97306ULL, 0x000ff00000209400ULL, 0x000000ac00bc7306ULL, 0x0004e20000205400ULL,
0x000000adb000720bULL, 0x002fc40003f3d000ULL, 0x000000c600ad7245ULL, 0x000fc8000020d400ULL,
0x00000001adad3812ULL, 0x000fe200078efcffULL, 0x000000bd00c97306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x004fce000020d400ULL, 0x000000bd00ca7306ULL, 0x000e620000205400ULL,
0x000000bcb900720bULL, 0x008fce0003fdd000ULL, 0x000000c200cb7306ULL, 0x000fec0000209400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000c200cc7306ULL, 0x000ea20000205400ULL,
0x000000cac900720bULL, 0x002fce0003fbd000ULL, 0x0000003600a67306ULL, 0x000ff00000009400ULL,
0x0000003600a57306ULL, 0x000fe20000005400ULL, 0x000000cccb00720bULL, 0x004fce0003f7d000ULL,
0x0000003100847306ULL, 0x000ff00000009400ULL, 0x0000003100817306ULL, 0x000ff00000005400ULL,
0x00000031005e7306ULL, 0x0003f0000000d400ULL, 0x0000003700a37306ULL, 0x000fe20000009400ULL,
0x0000010031317824ULL, 0x002fce00078e00ffULL, 0x0000003700a27306ULL, 0x000e700000005400ULL,
0x000000a400b37306ULL, 0x000ff00000209400ULL, 0x000000a400ba7306ULL, 0x000ea20000205400ULL,
0x000000a2a300720bULL, 0x002fc40003fdd000ULL, 0x000000c200a27245ULL, 0x000fe4000020d400ULL,
0x000000b800a37245ULL, 0x000fe4000020d400ULL, 0x00000001a2a23812ULL, 0x000fe200078efcffULL,
0x000000b800cd7306ULL, 0x000ff00000209400ULL, 0x000000b800ce7306ULL, 0x000e620000205400ULL,
0x000000bab300720bULL, 0x004fe20003f9d000ULL, 0x0001000032b37824ULL, 0x000fca00078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000002b00697306ULL, 0x000ff00000009400ULL,
0x0000002b006a7306ULL, 0x000ff00000005400ULL, 0x0000002b004d7306ULL, 0x0005f0000000d400ULL,
0x000000af00c17306ULL, 0x000fe20000209400ULL, 0x00000018ff2b7819ULL, 0x004fc40000011431ULL,
0x000000c300317245ULL, 0x000fc8000020d400ULL, 0x0000000131312812ULL, 0x000fe200078efcffULL,
0x000000af00be7306ULL, 0x0004e20000205400ULL, 0x000000a5a600720bULL, 0x000fe40003f5d000ULL,
0x000000bd00a67245ULL, 0x000fe4000020d400ULL, 0x000000683168723eULL, 0x000fe400000010ffULL,
0x00000001a6a65812ULL, 0x000fe200078efcffULL, 0x0000003500677306ULL, 0x0006e2000000d400ULL,
0x000000cecd00720bULL, 0x002fc40003fbd000ULL, 0x000000af00af7245ULL, 0x004fca000020d400ULL,
0x0000002800a07306ULL, 0x000fe20000009400ULL, 0x000000bec100720bULL, 0x008fe40003f7d000ULL,
0x00000018ff357819ULL, 0x000fc6000001142dULL, 0x00000001a3a35812ULL, 0x000fe400078efcffULL,
0x0000002800a17306ULL, 0x000e620000005400ULL, 0x0000000167671812ULL, 0x000fca00078efcffULL,
0x00000001afaf3812ULL, 0x000fe400078efcffULL, 0x0000009a00a77306ULL, 0x000ff00000209400ULL,
0x0000009a00aa7306ULL, 0x0004e20000205400ULL, 0x000000a1a000720bULL, 0x002fc40003f3d000ULL,
0x000000a400a17245ULL, 0x000fc8000020d400ULL, 0x00000001a1a14812ULL, 0x000fe200078efcffULL,
0x000000ae00b47306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x004fe4000020d400ULL,
0x000000a2a1a1723eULL, 0x000fca00000010ffULL, 0x000000ae00b77306ULL, 0x000e620000205400ULL,
0x000000aaa700720bULL, 0x008fe20003f9d000ULL, 0x0001000033a77824ULL, 0x040fe400078e00ffULL,
0x0000010033aa7824ULL, 0x000fc600078e00ffULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x000000ab00b27306ULL, 0x000fe20000209400ULL, 0x00000018ffaa7819ULL, 0x000fca00000114aaULL,
0x000000019a9a4812ULL, 0x000fe400078efcffULL, 0x000000ab00b17306ULL, 0x0004e20000205400ULL,
0x000000b7b400720bULL, 0x002fce0003fbd000ULL, 0x0000002a006e7306ULL, 0x000fe20000009400ULL,
0x000000ab00ab7245ULL, 0x004fce000020d400ULL, 0x0000002a006b7306ULL, 0x000fe20000005400ULL,
0x000000b1b200720bULL, 0x008fce0003f7d000ULL, 0x0000002a003b7306ULL, 0x0003ec000000d400ULL,
0x00000001abab3812ULL, 0x000fe400078efcffULL, 0x00000029006d7306ULL, 0x000fe20000009400ULL,
0x00000100302a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002900707306ULL, 0x000ff00000005400ULL, 0x00000029003c7306ULL, 0x0003f0000000d400ULL,
0x0000003000907306ULL, 0x000fe20000009400ULL, 0x0000000447297824ULL, 0x002fe200078e024aULL,
0x000000024a4a7810ULL, 0x000fc60007ffe0ffULL, 0x0000000229297824ULL, 0x000fc600078e00ffULL,
0x00000030008f7306ULL, 0x000fe40000005400ULL, 0x0000000229d37810ULL, 0x000fe40007ffe0ffULL,
0x0000002924297211ULL, 0x040fe400078fe0ffULL, 0x000000d324d37211ULL, 0x000fe400078fe0ffULL,
0x000000bb00cf7306ULL, 0x000fe20000209400ULL, 0x00000001d2297824ULL, 0x000fca00078e0229ULL,
0xfffffff0d4297812ULL, 0x000fe400078ee229ULL, 0x000000bb00d07306ULL, 0x000e660000205400ULL,
0x0000001029297824ULL, 0x000fca00078e00ffULL, 0x0000003600647306ULL, 0x000eb0000000d400ULL,
0x0000008d009c7306ULL, 0x000fe20000209400ULL, 0x000000d0cf00720bULL, 0x002fce0003f9d000ULL,
0x0000008d00977306ULL, 0x000e620000205400ULL, 0x0000000164642812ULL, 0x004fce00078efcffULL,
0x0000002a00c07306ULL, 0x000ff00000209400ULL, 0x0000002a00d17306ULL, 0x000ea20000205400ULL,
0x000000979c00720bULL, 0x002fce0003f5d000ULL, 0x00000033007b7306ULL, 0x000ff00000009400ULL,
0x00000033007c7306ULL, 0x000fe20000005400ULL, 0x000000d1c000720bULL, 0x004fce0003f7d000ULL,
0x00000033005a7306ULL, 0x0003f0000000d400ULL, 0x00000030005f7306ULL, 0x0004e2000000d400ULL,
0x000000ae00337245ULL, 0x002fc8000020d400ULL, 0x0000000133335812ULL, 0x000fe400078efcffULL,
0x0000008f9000720bULL, 0x000fe20003fbd000ULL, 0x0000002b00b07306ULL, 0x000fe20000209400ULL,
0x00000001d2307824ULL, 0x044fe200078e02d3ULL, 0x0000008d00907245ULL, 0x000fe2000020d400ULL,
0x00000010d2d37824ULL, 0x000fc600078e00ffULL, 0x0000000190902812ULL, 0x000fe400078efcffULL,
0x0000002b00a57306ULL, 0x000e620000205400ULL, 0xfffffff0d3307812ULL, 0x000fe400078ee230ULL,
0x000000ab90ab723eULL, 0x000fe400000010ffULL, 0x000000015f5f5812ULL, 0x008fc600078efcffULL,
0x00000032007f7306ULL, 0x000ff00000009400ULL, 0x0000003200807306ULL, 0x000ea20000005400ULL,
0x000000a5b000720bULL, 0x002fce0003fbd000ULL, 0x00000032005d7306ULL, 0x0003f0000000d400ULL,
0x000000bf00d27306ULL, 0x000fe20000209400ULL, 0x0000010032327824ULL, 0x002fca00078e00ffULL,
0x00000018ffa07819ULL, 0x000fe40000011432ULL, 0x000000bf00b57306ULL, 0x000e620000205400ULL,
0x000000bb00327245ULL, 0x000fc8000020d400ULL, 0x0000000132324812ULL, 0x000fe400078efcffULL,
0x000000818400720bULL, 0x000fe20003f9d000ULL, 0x0000009600997306ULL, 0x000fe20000209400ULL,
0x0000002a00847245ULL, 0x000fe4000020d400ULL, 0x000000bf00817245ULL, 0x000fe4000020d400ULL,
0x0000000184843812ULL, 0x000fe400078efcffULL, 0x000000807f00720bULL, 0x004fe20003f7d000ULL,
0x0000009600987306ULL, 0x0004e20000205400ULL, 0x000000b5d200720bULL, 0x002fc40003f5d000ULL,
0x0000002b00807245ULL, 0x000fe4000020d400ULL, 0x000000015e5e4812ULL, 0x000fe400078efcffULL,
0x0000000180805812ULL, 0x000fe200078efcffULL, 0x000000b300b67306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x004fe4000020d400ULL, 0x00000018ff7f7819ULL, 0x000fe400000114c4ULL,
0x000000015d5d3812ULL, 0x000fc400078efcffULL, 0x0000000181812812ULL, 0x000fe200078efcffULL,
0x000000b300b97306ULL, 0x000e620000205400ULL, 0x000000989900720bULL, 0x008fe40003fbd000ULL,
0x000000b300987245ULL, 0x000fe4000020d400ULL, 0x000000a000997245ULL, 0x000fe4000020d400ULL,
0x0000005f3232723eULL, 0x000fe200000010ffULL, 0x0000003700607306ULL, 0x000ea2000000d400ULL,
0x0000005e815e723eULL, 0x000fca00000010ffULL, 0x0000000196965812ULL, 0x000fe400078efcffULL,
0x000000aa002a7306ULL, 0x000fe20000209400ULL, 0x000000b9b600720bULL, 0x002fe40003f5d000ULL,
0x0000006b6e00720bULL, 0x000fe40003fbd000ULL, 0x000000aa006b7245ULL, 0x000fc6000020d400ULL,
0x000000aa008d7306ULL, 0x0002e20000205400ULL, 0x0000000160606812ULL, 0x004fca00078efcffULL,
0x0000000198982812ULL, 0x000fe400078efcffULL, 0x0000009f00a87306ULL, 0x000fe20000209400ULL,
0x0000007c7b00720bULL, 0x000fe40003f5d000ULL, 0x0000006033aa723eULL, 0x002fe400000010ffULL,
0x0000006300607245ULL, 0x000fe4000020d400ULL, 0x000000013b3b5812ULL, 0x000fe200078efcffULL,
0x0000009f00a97306ULL, 0x0002a20000205400ULL, 0x0000008d2a00720bULL, 0x008fe20003f7d000ULL,
0x000001002e8d7824ULL, 0x000fe200078e00ffULL, 0x0000005d9898723eULL, 0x000fc600000010ffULL,
0x000000015a5a2812ULL, 0x000fe400078efcffULL, 0x00000028004f7306ULL, 0x000ee2000000d400ULL,
0x0000009f009f7245ULL, 0x002fe4000020d400ULL, 0x00000018ff8d7819ULL, 0x000fc6000001148dULL,
0x000000016b6b3812ULL, 0x000fe400078efcffULL, 0x0000008800917306ULL, 0x000fe20000209400ULL,
0x000000a9a800720bULL, 0x004fce0003fdd000ULL, 0x0000008800287306ULL, 0x0002a20000205400ULL,
0x000000014f4f1812ULL, 0x008fca00078efcffULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x0000009b009d7306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fe4000020d400ULL,
0x000000849f33723eULL, 0x000fca00000010ffULL, 0x0000009b009e7306ULL, 0x0002e20000205400ULL,
0x000000289100720bULL, 0x004fe20003f7d000ULL, 0x000001002f917824ULL, 0x000fe200078e00ffULL,
0x000000002928783bULL, 0x000ea80000000200ULL, 0x00000018ff917819ULL, 0x000fe20000011491ULL,
0x0000008200927306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fca000020d400ULL,
0x0000000188883812ULL, 0x000fe400078efcffULL, 0x0000008200957306ULL, 0x0002620000205400ULL,
0x0000009e9d00720bULL, 0x008fce0003fdd000ULL, 0x000000a000a47306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x002fca000020d400ULL, 0x000000019b9b6812ULL, 0x000fe400078efcffULL,
0x000000a000977306ULL, 0x0002e20000205400ULL, 0x000000959200720bULL, 0x000fe40003f5d000ULL,
0x000000809b5f723eULL, 0x000fca00000010ffULL, 0x000000a7008f7306ULL, 0x000fe20000209400ULL,
0x00000067a6a0723eULL, 0x002fe200000010ffULL, 0x000000322810723cULL, 0x044be80000041810ULL,
0x0000000182822812ULL, 0x000fe400078efcffULL, 0x000000a7009c7306ULL, 0x0002a20000205400ULL,
0x00000097a400720bULL, 0x008fe40003f9d000ULL, 0x0000007f00327245ULL, 0x020fe2000020d400ULL,
0x000000aa2814723cULL, 0x000fe20000041814ULL, 0x0000004f8282723eULL, 0x000fc600000010ffULL,
0x0000008700857306ULL, 0x000fe20000209400ULL, 0x000000a700a77245ULL, 0x002fc6000020d400ULL,
0x000000a02820723cULL, 0x040f640000041820ULL, 0x0000000199994812ULL, 0x000fe400078efcffULL,
0x00000087008a7306ULL, 0x0002e20000205400ULL, 0x0000009c8f00720bULL, 0x004fe20003fdd000ULL,
0x000100002f8f7824ULL, 0x000fe200078e00ffULL, 0x000000706d00720bULL, 0x000fe20003f9d000ULL,
0x000100002c707824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe200000114c5ULL,
0x0000005e280c723cULL, 0x000fe2000004180cULL, 0x000000999699723eULL, 0x000fe200000010ffULL,
0x0000007700717306ULL, 0x000fe20000209400ULL, 0x0000008700877245ULL, 0x002fc4000020d400ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000006d00337245ULL, 0x000fe2000020d400ULL,
0x000000982808723cULL, 0x000fe20000041808ULL, 0x00000001a7a76812ULL, 0x000fe200078efcffULL,
0x0000007700727306ULL, 0x0002a20000205400ULL, 0x0000008a8500720bULL, 0x008fe20003f3d000ULL,
0x000100002d8a7824ULL, 0x000fe200078e00ffULL, 0x000000013c3c4812ULL, 0x000fe400078efcffULL,
0x00000018ff8f7819ULL, 0x000fc4000001148fULL, 0x00000018ff8a7819ULL, 0x000fe2000001148aULL,
0x0000008e00937306ULL, 0x000fe20000209400ULL, 0x0000007700777245ULL, 0x002fca000020d400ULL,
0x0000000187871812ULL, 0x000fe400078efcffULL, 0x0000008e00947306ULL, 0x0002e20000205400ULL,
0x000000727100720bULL, 0x004fce0003f5d000ULL, 0x00000089008b7306ULL, 0x000fe20000209400ULL,
0x0000008e008e7245ULL, 0x002fca000020d400ULL, 0x0000000177772812ULL, 0x000fe400078efcffULL,
0x00000089008c7306ULL, 0x0002a20000205400ULL, 0x000000949300720bULL, 0x008fce0003fdd000ULL,
0x0000006300767306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fca000020d400ULL,
0x000000018e8e6812ULL, 0x000fe400078efcffULL, 0x0000006300737306ULL, 0x000e620000205400ULL,
0x0000008c8b00720bULL, 0x004fe20003f7d000ULL, 0x000001002d8b7824ULL, 0x000fe200078e00ffULL,
0x0000006a6900720bULL, 0x000fe20003fdd000ULL, 0x000100002e8c7824ULL, 0x000fe200078e00ffULL,
0x000000adac69723eULL, 0x000fe400000010ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x0000006c00747306ULL, 0x000fe20000209400ULL, 0x00000018ff8c7819ULL, 0x000fc4000001148cULL,
0x0000006b8e31723eULL, 0x000fe200000010ffULL, 0x000000682818723cULL, 0x000f640000041818ULL,
0x0000000189893812ULL, 0x000fe400078efcffULL, 0x0000006c006f7306ULL, 0x0004e20000205400ULL,
0x000000737600720bULL, 0x002fe40003f3d000ULL, 0x000000014d4d6812ULL, 0x000fca00078efcffULL,
0x0000002c00757306ULL, 0x000fe20000009400ULL, 0x0000006c006c7245ULL, 0x004fca000020d400ULL,
0x0000000160601812ULL, 0x000fe400078efcffULL, 0x0000002c007a7306ULL, 0x000e620000005400ULL,
0x0000006f7400720bULL, 0x008fce0003f5d000ULL, 0x0000002c003a7306ULL, 0x0004ec000000d400ULL,
0x000000016c6c2812ULL, 0x000fe400078efcffULL, 0x0000007900837306ULL, 0x000fe20000209400ULL,
0x000001002c2c7824ULL, 0x004fe200078e00ffULL, 0x0000007a7500720bULL, 0x002fc80003f9d000ULL,
0x00000018ff727819ULL, 0x000fe4000001142cULL, 0x0000007900867306ULL, 0x000e620000205400ULL,
0x00000064a32c723eULL, 0x000fe400000010ffULL, 0x0000007900647245ULL, 0x000fc8000020d400ULL,
0x000000013a3a4812ULL, 0x008fe200078efcffULL, 0x0000002d00667306ULL, 0x000ff00000009400ULL,
0x0000002d00657306ULL, 0x000ea20000005400ULL, 0x000000868300720bULL, 0x002fc40003f7d000ULL,
0x000000887783723eULL, 0x000fca00000010ffULL, 0x0000002d004c7306ULL, 0x0002ec000000d400ULL,
0x0000000164643812ULL, 0x000fe400078efcffULL, 0x0000007f00977306ULL, 0x000fe20000209400ULL,
0x000000af9a2d723eULL, 0x002fe400000010ffULL, 0x000000656600720bULL, 0x004fc40003f7d000ULL,
0x0000007800657245ULL, 0x000fe4000020d400ULL, 0x0000003b6464723eULL, 0x000fe200000010ffULL,
0x0000007f007c7306ULL, 0x000e620000205400ULL, 0x0000002c281c723cULL, 0x000b6e000004181cULL,
0x00000078007d7306ULL, 0x000fe20000209400ULL, 0x00000010302c7824ULL, 0x020fe200078e00ffULL,
0x0000005aa730723eULL, 0x000fc400000010ffULL, 0x000000014c4c3812ULL, 0x008fc800078efcffULL,
0x00000078007e7306ULL, 0x000ea20000205400ULL, 0x0000007c9700720bULL, 0x002fe20003f3d000ULL,
0x000000302804723cULL, 0x000b6c0000041804ULL, 0x00000070006a7306ULL, 0x000fe20000209400ULL,
0x00000034002b7245ULL, 0x020fe4000020d400ULL, 0x00000035002a7245ULL, 0x000fc4000020d400ULL,
0x0000008a00317245ULL, 0x000fe4000020d400ULL, 0x0000000132321812ULL, 0x000fe200078efcffULL,
0x0000007000717306ULL, 0x000e620000205400ULL, 0x0000007e7d00720bULL, 0x004fe40003f5d000ULL,
0x0000004d3232723eULL, 0x000fe400000010ffULL, 0x0000008b004d7245ULL, 0x000fe4000020d400ULL,
0x0000003c8728723eULL, 0x000fe200000010ffULL, 0x0000002e00627306ULL, 0x000fe20000009400ULL,
0x000000896c29723eULL, 0x000fca00000010ffULL, 0x0000000165652812ULL, 0x000fe400078efcffULL,
0x0000002e00617306ULL, 0x000ea20000005400ULL, 0x000000716a00720bULL, 0x002fe40003fbd000ULL,
0x000000656065723eULL, 0x000fca00000010ffULL, 0x0000002e004b7306ULL, 0x000e70000000d400ULL,
0x0000002f00587306ULL, 0x000fe20000009400ULL, 0x000000616200720bULL, 0x004fe40003f5d000ULL,
0x0000007000617245ULL, 0x000fc8000020d400ULL, 0x0000000161615812ULL, 0x000fe200078efcffULL,
0x0000002f00577306ULL, 0x000fe60000005400ULL, 0x0000003a613a723eULL, 0x000fc600000010ffULL,
0x000000014b4b2812ULL, 0x002fe400078efcffULL, 0x0000002f00497306ULL, 0x0003f0000000d400ULL,
0x0000004e00567306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x002e6e0000000200ULL,
0x0000004e00597306ULL, 0x0004f00000205400ULL, 0x0000006d006e7306ULL, 0x000fe20000209400ULL,
0x0000004e004e7245ULL, 0x004fce000020d400ULL, 0x0000006d007b7306ULL, 0x000ea20000205400ULL,
0x000000595600720bULL, 0x008fce0003f3d000ULL, 0x0000007200857306ULL, 0x000fec0000209400ULL,
0x000000014e4e1812ULL, 0x000fe400078efcffULL, 0x0000007200747306ULL, 0x0006e20000205400ULL,
0x0000007b6e00720bULL, 0x004fe20003f9d000ULL, 0x000000282c20723cULL, 0x042b6c0000041820ULL,
0x00000034005b7306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x008fe2000020d400ULL,
0x000000822c18723cULL, 0x000f640000041818ULL, 0x0000008f00287245ULL, 0x020fc4000020d400ULL,
0x0000009100297245ULL, 0x000fe4000020d400ULL, 0x0000000133334812ULL, 0x000fe200078efcffULL,
0x00000034005c7306ULL, 0x000e620000205400ULL, 0x000000748500720bULL, 0x000fe20003fbd000ULL,
0x000000642c1c723cULL, 0x000f62000004181cULL, 0x000000334e33723eULL, 0x000fca00000010ffULL,
0x0000003500367306ULL, 0x000fe40000209400ULL, 0x000000322c14723cULL, 0x000b680000041814ULL,
0x0000000172725812ULL, 0x000fe400078efcffULL, 0x0000003500377306ULL, 0x000ea20000205400ULL,
0x0000005c5b00720bULL, 0x002fe40003fdd000ULL, 0x000000575800720bULL, 0x000fca0003fbd000ULL,
0x0000008a006f7306ULL, 0x000fec0000209400ULL, 0x000000012b2b6812ULL, 0x000fe400078efcffULL,
0x0000008a00687306ULL, 0x000e620000205400ULL, 0x000000373600720bULL, 0x004fe40003f3d000ULL,
0x0000000149495812ULL, 0x000fc400078efcffULL, 0x000000722b3b723eULL, 0x000fc600000010ffULL,
0x0000008b00667306ULL, 0x000fe80000209400ULL, 0x0000003a2c10723cULL, 0x000b640000041810ULL,
0x000000012a2a1812ULL, 0x000fe400078efcffULL, 0x0000008b00637306ULL, 0x000ea20000205400ULL,
0x000000686f00720bULL, 0x002fce0003f9d000ULL, 0x0000008c00627306ULL, 0x000fec0000209400ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x0000008c00677306ULL, 0x0002e20000205400ULL,
0x000000636600720bULL, 0x004fe40003fdd000ULL, 0x0000004c314c723eULL, 0x000fca00000010ffULL,
0x0000008d005d7306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x002fca000020d400ULL,
0x000000014d4d6812ULL, 0x000fe400078efcffULL, 0x0000008d00567306ULL, 0x0002a20000205400ULL,
0x000000676200720bULL, 0x008fe40003f7d000ULL, 0x0000004d2a4d723eULL, 0x000fe400000010ffULL,
0x00000053002a7245ULL, 0x000fc6000020d400ULL, 0x0000005000517306ULL, 0x000fe20000209400ULL,
0x0000008d008d7245ULL, 0x002fe2000020d400ULL, 0x0000004c2c0c723cULL, 0x000b68000004180cULL,
0x000000018c8c3812ULL, 0x000fe400078efcffULL, 0x0000005000527306ULL, 0x0002e20000205400ULL,
0x000000565d00720bULL, 0x004fe40003f3d000ULL, 0x0000004b8c8c723eULL, 0x000fca00000010ffULL,
0x0000005300547306ULL, 0x000fe20000209400ULL, 0x0000005000507245ULL, 0x002fca000020d400ULL,
0x000000018d8d1812ULL, 0x000fe400078efcffULL, 0x0000005300557306ULL, 0x000e620000205400ULL,
0x000000525100720bULL, 0x008fe40003f9d000ULL, 0x000000044a00780cULL, 0x000fca0003f25270ULL,
0x0000008f00577306ULL, 0x000fec0000209400ULL, 0x0000000150504812ULL, 0x000fe400078efcffULL,
0x0000008f00307306ULL, 0x000ea20000205400ULL, 0x000000555400720bULL, 0x002fe40003fdd000ULL,
0x0000008d508d723eULL, 0x000fca00000010ffULL, 0x0000009100347306ULL, 0x000fe40000209400ULL,
0x0000008c2c08723cULL, 0x000b680000041808ULL, 0x000000012a2a6812ULL, 0x000fe400078efcffULL,
0x0000009100337306ULL, 0x020e620000205400ULL, 0x000000305700720bULL, 0x004fda0003f7d000ULL,
0x0000000128283812ULL, 0x000fe400078efcffULL, 0x000000333400720bULL, 0x002fe40003f5d000ULL,
0x000000492828723eULL, 0x000fd600000010ffULL, 0x0000000129292812ULL, 0x000fc800078efcffULL,
0x000000292a29723eULL, 0x000fce00000010ffULL, 0x000000282c04723cULL, 0x000b620000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff487224ULL, 0x000fe200078e0042ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd21000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000003e162c7220ULL, 0x0a0fe20000410000ULL,
0x0000003e1a287220ULL, 0x080fe20000410000ULL, 0x0000003e172d7220ULL, 0x080fe20000410000ULL,
0x0000003e10167220ULL, 0x080fe20000410000ULL, 0x0000003e18187220ULL, 0x080fe20000410000ULL,
0x0000003e19197220ULL, 0x080fe20000410000ULL, 0x0000003e1b297220ULL, 0x080fe20000410000ULL,
0x0000003e11177220ULL, 0x080fe20000410000ULL, 0x0000003e0c1a7220ULL, 0x080fe20000410000ULL,
0x0000003e20207220ULL, 0x080fe20000410000ULL, 0x0000003e21217220ULL, 0x080fe20000410000ULL,
0x0000003e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003e14147220ULL, 0x080fe20000410000ULL, 0x0000003e15157220ULL, 0x080fe20000410000ULL,
0x0000003e0d1b7220ULL, 0x080fe20000410000ULL, 0x0000003e08087220ULL, 0x080fe20000410000ULL,
0x0000003e09097220ULL, 0x080fe20000410000ULL, 0x0000003e04047220ULL, 0x080fe20000410000ULL,
0x0000003e122e7220ULL, 0x080fe20000410000ULL, 0x0000003e132f7220ULL, 0x080fe20000410000ULL,
0x0000003e0a327220ULL, 0x080fe20000410000ULL, 0x0000003e0b337220ULL, 0x080fe20000410000ULL,
0x000000ffff127224ULL, 0x000fe200078e0016ULL, 0x0000003e0e307220ULL, 0x080fe20000410000ULL,
0x0000003e0f317220ULL, 0x080fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0018ULL,
0x0000003e22227220ULL, 0x080fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0019ULL,
0x0000003e23237220ULL, 0x080fe20000410000ULL, 0x000000ffff137224ULL, 0x000fe200078e0017ULL,
0x0000003e1e2a7220ULL, 0x080fe20000410000ULL, 0x000000ffff167224ULL, 0x000fe200078e001aULL,
0x0000003e1f2b7220ULL, 0x080fe20000410000ULL, 0x0000003e05057220ULL, 0x080fe20000410000ULL,
0x0000003e06067220ULL, 0x080fe20000410000ULL, 0x0000003e07077220ULL, 0x000fe20000410000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0020ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0021ULL,
0x000000ffff0e7224ULL, 0x000fe400078e001cULL, 0x000000ffff0f7224ULL, 0x000fe400078e001dULL,
0x000000ffff107224ULL, 0x000fe400078e0014ULL, 0x000000ffff117224ULL, 0x000fe400078e0015ULL,
0x000000ffff177224ULL, 0x000fc400078e001bULL, 0x000000ffff187224ULL, 0x000fe400078e0008ULL,
0x000000ffff197224ULL, 0x000fe400078e0009ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003f087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0028ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0029ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0022ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0023ULL,
0x000000ffff207224ULL, 0x000fe400078e002aULL, 0x000000ffff217224ULL, 0x000fe400078e002bULL,
0x000000ffff227224ULL, 0x000fe400078e002cULL, 0x000000ffff237224ULL, 0x000fe400078e002dULL,
0x000000ffff287224ULL, 0x000fc400078e002eULL, 0x000000ffff297224ULL, 0x000fe400078e002fULL,
0x000000ffff1b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0031ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0033ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004003f077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604157210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004003f077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000424157824ULL, 0x000fe200078e00ffULL, 0x000000404300720cULL, 0x000fc80003f05270ULL,
0xfffffff015147812ULL, 0x000fca00078ec0ffULL, 0x0000008025147824ULL, 0x000fca00078e0214ULL,
0x00f4000014047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000224087824ULL, 0x000fe400078e00ffULL, 0x0000000103467824ULL, 0x000fc600078e0a46ULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109317812ULL, 0x040fe400078efcffULL,
0x0000000809337812ULL, 0x000fe400078efcffULL, 0x000000463100720cULL, 0x080fe40003f26070ULL,
0x0000001009317812ULL, 0x000fe400078efcffULL, 0x000000463300720cULL, 0x080fe40003f06070ULL,
0x000000463100720cULL, 0x000fc40003fc6070ULL, 0x0000001109337812ULL, 0x040fe400078efcffULL,
0x0000001809317812ULL, 0x040fe400078efcffULL, 0x000000460900720cULL, 0x080fe40003f46070ULL,
0x000000463300720cULL, 0x080fe40003fa6070ULL, 0x000000463100720cULL, 0x000fe40003f66070ULL,
0x0000000909357812ULL, 0x000fc400078efcffULL, 0x0000001909337812ULL, 0x040fe400078efcffULL,
0x0000002009317812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0xff8000000a0a7808ULL, 0x000fc40004800000ULL, 0x000000463500720cULL, 0x080fe40003f86070ULL,
0x000000463300720cULL, 0x080fe40003f46070ULL, 0x000000463100720cULL, 0x000fe40003f26070ULL,
0x0000002109337812ULL, 0x040fe400078efcffULL, 0x0000002809317812ULL, 0x000fe400078efcffULL,
0xff8000001e1e7808ULL, 0x000fc40004000000ULL, 0xff8000000c0c7808ULL, 0x000fe40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40006000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006000000ULL,
0x000000463300720cULL, 0x080fe40003f06070ULL, 0x000000463100720cULL, 0x000fe40003f86070ULL,
0x0000002909337812ULL, 0x000fc400078efcffULL, 0x0000003009317812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40007000000ULL, 0xff8000000e0e7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000000f0f7808ULL, 0x000fe40006800000ULL,
0x000000463300720cULL, 0x000fc40003fc6070ULL, 0x000000463100720cULL, 0x000fe40003fa6070ULL,
0x0000003109337812ULL, 0x040fe400078efcffULL, 0x0000003809317812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005800000ULL,
0xff80000010107808ULL, 0x000fc40005800000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000028287808ULL, 0x000fe40004800000ULL,
0xff80000012127808ULL, 0x000fe40004800000ULL, 0x000000463300720cULL, 0x080fe40003f66070ULL,
0x000000463100720cULL, 0x000fc40003f46070ULL, 0x000000460900720cULL, 0x000fe40003f26070ULL,
0xff80000029297808ULL, 0x000fe40004000000ULL, 0xff80000013137808ULL, 0x000fe40004000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff8000002b2b7808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff8000002c2c7808ULL, 0x000fe40006800000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff8000002d2d7808ULL, 0x000fe40005800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000002e2e7808ULL, 0x000fc40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff8000001b1b7808ULL, 0x000fc40004800000ULL,
0x0000000b0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff367424ULL, 0x000fe200078e00ffULL,
0x0000001c0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x000000040b097208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fc40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x000000090a097208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000000c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000090c047208ULL, 0x000fe40004000000ULL, 0x000000051e087208ULL, 0x000fe40004800000ULL,
0x0000000d0400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x000000040d057208ULL, 0x000fe40004000000ULL, 0x000000081f097208ULL, 0x000fc40004800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fe40004800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fc40003f3e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x0000000821097208ULL, 0x000fe40004800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fe40003f3e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x0000000922087208ULL, 0x000fc40004800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fe40004800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fc40003f3e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x0000000928087208ULL, 0x000fe40004800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000290800720bULL, 0x000fe40003f3e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x0000000829097208ULL, 0x000fc40004800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000516047208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fe40004800000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fc40003f3e000ULL,
0x0000000417057208ULL, 0x000fe40004000000ULL, 0x000000082b097208ULL, 0x000fe40004800000ULL,
0x000000180500720bULL, 0x000fe40003f1e000ULL, 0x0000002c0900720bULL, 0x000fe40003f3e000ULL,
0x0000000518047208ULL, 0x000fe40004000000ULL, 0x000000092c087208ULL, 0x000fc40004800000ULL,
0x000000190400720bULL, 0x000fe40003f1e000ULL, 0x0000002d0800720bULL, 0x000fe40003f3e000ULL,
0x0000000419057208ULL, 0x000fe40004000000ULL, 0x000000082d097208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x0000002e0900720bULL, 0x000fc40003f3e000ULL,
0x000000051a047208ULL, 0x000fe40004000000ULL, 0x000000092e087208ULL, 0x000fe40004800000ULL,
0x0000001b0400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0800720bULL, 0x000fe40003f3e000ULL,
0x000000041b327208ULL, 0x000fe40004000000ULL, 0x000000082f347208ULL, 0x000fe20004800000ULL,
0x000015227f007947ULL, 0x000fec000b800000ULL, 0x0c401f0032047f89ULL, 0x0004e400000e0000ULL,
0x000000043200720bULL, 0x008fc80003f1e000ULL, 0x0000003204357208ULL, 0x000fe20004000000ULL,
0x000015327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0034047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000e6800000e0000ULL, 0x0c401f0007307f89ULL, 0x000ea200000e0000ULL,
0x000000043400720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x002fe40003f3e000ULL,
0x0000003404087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f0035047f89ULL, 0x000e6200000e0000ULL, 0x000000300700720bULL, 0x004fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000ea200000e0000ULL, 0x0000000730307208ULL, 0x000fc60004000000ULL,
0x0c201f0009327f89ULL, 0x000ee800000e0000ULL, 0x0c201f0030317f89ULL, 0x0002e400000e0000ULL,
0x000000043500720bULL, 0x002fe40003f1e000ULL, 0x000000050800720bULL, 0x004fe40003f3e000ULL,
0x0000003504047208ULL, 0x000fc40004000000ULL, 0x000000320900720bULL, 0x008fe40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x0000000932067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05327820ULL, 0x002fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x00000002ff337819ULL, 0x000fe20000011624ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010832ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x00000004ff367e24ULL, 0x000fe2000f8e00ffULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3f8000003636783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010832ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b22227823ULL, 0x000fe20000010832ULL, 0x000000ffff377224ULL, 0x000fe200078e0036ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010832ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1b077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010832ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe20000010832ULL,
0x0000000833327824ULL, 0x040fe200078e00ffULL, 0x0000000324ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000833357824ULL, 0x040fe200078e00ffULL, 0x000000313000720bULL, 0x004fe20003f3e000ULL,
0x00000008333b7824ULL, 0x000fc400078e00ffULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000010ffULL, 0x0000001e000b7308ULL, 0x000ff00000000800ULL,
0x0000001f00347308ULL, 0x000ea20000000800ULL, 0x0000001c1d09723eULL, 0x002fce00000010ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b340b723eULL, 0x004fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x00000036081c723cULL, 0x000f6e00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fe400000010ffULL,
0x0000000133107810ULL, 0x000fca0007ffe0ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x00000020210d723eULL, 0x002fe200000010ffULL,
0x0000000833217824ULL, 0x040fe200078e00ffULL, 0x0000000433207810ULL, 0x000fc80007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000022230f723eULL, 0x004fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000000833237824ULL, 0x040fe400078e00ffULL, 0x0000000833227824ULL, 0x000fe200078e00ffULL,
0x000000360c1c723cULL, 0x020f68000004181cULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000161712723eULL, 0x004fe400000010ffULL, 0x0000000233167810ULL, 0x000fc40007ffe0ffULL,
0x0000000333177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee216ULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x000000282911723eULL, 0x002fc400000010ffULL, 0xfffffff822297812ULL, 0x000fe400078ee217ULL,
0x0000000633227810ULL, 0x040fe40007ffe0ffULL, 0xffffffff33287810ULL, 0x000fe20007ffe0ffULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0xfffffff832177812ULL, 0x000fe400078ee233ULL,
0x0000002a2b13723eULL, 0x004fca00000010ffULL, 0x0000001900197308ULL, 0x000e620000000800ULL,
0x00000008332b7824ULL, 0x040fe200078e00ffULL, 0x00000008332a7810ULL, 0x000fe20007ffe0ffULL,
0x00000036101c723cULL, 0x020b66000004181cULL, 0xfffffff82b2b7812ULL, 0x000fe400078ee220ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x0000000533207810ULL, 0x000fe20007ffe0ffULL,
0x000000082a457824ULL, 0x000fc400078e00ffULL, 0x0000000833377824ULL, 0x020fe200078e00ffULL,
0xfffffff835337812ULL, 0x000fc600078ee220ULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x000000181918723eULL, 0x002fe400000010ffULL, 0x0000900025207811ULL, 0x000fe400078e58ffULL,
0xfffffff837357812ULL, 0x000fe400078ee222ULL, 0xfffffff83b377812ULL, 0x000fe200078ee228ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000001017177824ULL, 0x100fe400078e0220ULL,
0x0000001021217824ULL, 0x000fc400078e0220ULL, 0x0000001023237824ULL, 0x100fe400078e0220ULL,
0x0000001029297824ULL, 0x000fe200078e0220ULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x0000002c2d19723eULL, 0x004fe200000010ffULL, 0x000000ffff2c7224ULL, 0x100fe400078e0036ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0036ULL, 0x000000102b2b7824ULL, 0x100fe400078e0220ULL,
0x0000002e001b7308ULL, 0x000fe20000000800ULL, 0x0000001033337824ULL, 0x000fc400078e0220ULL,
0x0000001035357824ULL, 0x100fe400078e0220ULL, 0x0000001037377824ULL, 0x000fc600078e0220ULL,
0x0000002f00167308ULL, 0x0004e20000000800ULL, 0x0000001a071a723eULL, 0x002fe400000010ffULL,
0x0000003031077208ULL, 0x000fe40004800000ULL, 0xfffffff8452f7812ULL, 0x004fca00078ee22aULL,
0x000000102f2f7824ULL, 0x000fe200078e0220ULL, 0x0000001b161b723eULL, 0x008fe400000010ffULL,
0x0000000c15167812ULL, 0x000fca00078ec0ffULL, 0x0000002c181c723cULL, 0x000f62000004181cULL,
0x0000000117177824ULL, 0x000fe400078e0216ULL, 0x0000000116217824ULL, 0x040fe400078e0221ULL,
0x0000000116237824ULL, 0x040fe200078e0223ULL, 0x0000000817007388ULL, 0x0003e20000000800ULL,
0x0000000116297824ULL, 0x040fe400078e0229ULL, 0x00000001162b7824ULL, 0x040fe200078e022bULL,
0x0000000a21007388ULL, 0x0003e20000000800ULL, 0x0000000116337824ULL, 0x000fc400078e0233ULL,
0x0000000116357824ULL, 0x040fe200078e0235ULL, 0x0000000c23007388ULL, 0x0003e20000000800ULL,
0x0000000116377824ULL, 0x040fe400078e0237ULL, 0x0000000116167824ULL, 0x000fe200078e022fULL,
0x0000000e29007388ULL, 0x0003e80000000800ULL, 0x000000102b007388ULL, 0x0003e40000000800ULL,
0x000000ffff1d7224ULL, 0x020fc400078e001eULL, 0x0000001233007388ULL, 0x0003e80000000800ULL,
0x0000001835007388ULL, 0x0003e80000000800ULL, 0x0000001a37007388ULL, 0x0003e80000000800ULL,
0x0000000916007388ULL, 0x0003e80000000800ULL, 0x0004000b21007388ULL, 0x0003e80000000800ULL,
0x0004000d23007388ULL, 0x0003e80000000800ULL, 0x0004000f29007388ULL, 0x0003e80000000800ULL,
0x000400112b007388ULL, 0x0003e80000000800ULL, 0x0004001333007388ULL, 0x0003e80000000800ULL,
0x0004001935007388ULL, 0x0003e80000000800ULL, 0x0004001b37007388ULL, 0x0003e80000000800ULL,
0x00f0000414008388ULL, 0x0003e80000000c00ULL, 0x00f2001c14008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000041ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080041ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100041ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000143437810ULL, 0x000fe20007ffe0ffULL,
0x0000180041ff7f8cULL, 0x0003e6000c80043fULL, 0x000000004300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb41000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff437807ULL, 0x004fe40004000000ULL,
0x000161c000427802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff377224ULL, 0x000fe200078e0045ULL, 0xfffec20000007947ULL, 0x000fea000383ffffULL,
0x00000001ff437807ULL, 0x000fe40004000000ULL, 0x0001621000427802ULL, 0x000fc40000000f00ULL,
0x00000c3000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff417224ULL, 0x000fe200078e0045ULL,
0xfffec26000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x004fe200078e0045ULL,
0x0001626000487802ULL, 0x000fc40000000f00ULL, 0x00000b9000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0047ULL, 0xfffec32000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0045ULL, 0x000162b000487802ULL, 0x000fc40000000f00ULL,
0x00000b4000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0047ULL,
0xfffec44000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e003dULL,
0x0001631000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff427224ULL, 0x000fc400078e003cULL,
0x00000ae000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x004fe200078e0047ULL,
0xfffec85000007947ULL, 0x000fea000383ffffULL, 0x000000ffff427224ULL, 0x000fe200078e003aULL,
0x0001637000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fc400078e003dULL,
0x00000a8000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0047ULL,
0xfffec82000007947ULL, 0x000fea000383ffffULL, 0x00000001ff437807ULL, 0x004fe40004000000ULL,
0x000163c000427802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff407224ULL, 0x000fe200078e0045ULL, 0xfffef99000007947ULL, 0x000fea000383ffffULL,
0x00000001ff437807ULL, 0x000fe40004000000ULL, 0x0001641000427802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff417224ULL, 0x000fe200078e0045ULL,
0xfffef9e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e004aULL,
0x0001646000487802ULL, 0x000fc40000000f00ULL, 0x0000099000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0047ULL, 0xfffefab000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e004aULL, 0x000164b000487802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0047ULL,
0xfffefbc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e003eULL,
0x0001651000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff427224ULL, 0x000fc400078e003fULL,
0x000008e000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x004fe200078e0047ULL,
0xfffeffd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e003eULL,
0x0001656000487802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0047ULL, 0xfffeffb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff437807ULL, 0x004fe40004000000ULL, 0x000165b000427802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff407224ULL, 0x000fe200078e0045ULL,
0xffff2e1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff437807ULL, 0x000fe40004000000ULL,
0x0001660000427802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x018fea0003c00000ULL,
0xffff2e7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0046ULL,
0x0001664000487802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff427224ULL, 0x004fe200078e0047ULL, 0xffff2f5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0046ULL, 0x0001669000487802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff427224ULL, 0x004fe200078e0047ULL,
0xffff306000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0040ULL,
0x000166f000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff427224ULL, 0x000fc400078e0041ULL,
0x0000070000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x004fe200078e0047ULL,
0xffff347000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0040ULL,
0x0001674000487802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0047ULL, 0xffff345000007947ULL, 0x000fea000383ffffULL,
0x00000001ff437807ULL, 0x004fe40004000000ULL, 0x0001679000427802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff337224ULL, 0x000fe200078e0045ULL,
0xffff632000007947ULL, 0x000fea000383ffffULL, 0x00000001ff437807ULL, 0x000fe40004000000ULL,
0x000167e000427802ULL, 0x000fc40000000f00ULL, 0x0000066000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff347224ULL, 0x000fe200078e0045ULL, 0xffff637000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0036ULL, 0x0001683000487802ULL, 0x000fc40000000f00ULL,
0x000005c000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0047ULL,
0xffff644000007947ULL, 0x000fea000383ffffULL, 0x000000ffff477224ULL, 0x000fe200078e0036ULL,
0x0001688000487802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e0047ULL, 0xffff655000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0030ULL, 0x000168e000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff427224ULL, 0x000fc400078e0031ULL, 0x0000051000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff3b7224ULL, 0x004fe200078e0047ULL, 0xffff695000007947ULL, 0x000fea000383ffffULL,
0x000000ffff477224ULL, 0x000fe200078e0030ULL, 0x0001693000487802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0047ULL,
0xffff693000007947ULL, 0x000fea000383ffffULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0001698000087802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0031ULL, 0xffffeaa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0034ULL, 0x000169e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x000000313400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x00016a4000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000003431347208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000310600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0007ULL,
0x00016aa000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000000631067208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000310700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0035ULL,
0x00016b0000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000000731307208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000313500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0034ULL,
0x00016b6000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000003531047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000313400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x00016bc000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000003431057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000310600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0030ULL,
0x00016c2000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x0000000631067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe97000007947ULL, 0x000fea000383ffffULL, 0x018000002b007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002b00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff2bff7812ULL, 0x040fe4000780c0ffULL,
0x800000002b027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002b00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe925002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x0c00003332317389ULL, 0x0002a200000e0036ULL,
0xfffe921008007950ULL, 0x000fea0003c3ffffULL, 0x0000003800007348ULL, 0x000fe80003800000ULL,
0x0000004247477389ULL, 0x0002a200000e0037ULL, 0x00000000ff437424ULL, 0x000fc400078e00ffULL,
0x000000ffff427224ULL, 0x002fc800078e0048ULL, 0xfffe91c042007950ULL, 0x000fea0003c3ffffULL,
0x000000014300780cULL, 0x000fe20003f05070ULL, 0x0000003600007348ULL, 0x000fd80003800000ULL,
0x0000000000437806ULL, 0x000fc800040e0100ULL, 0x0000003643457212ULL, 0x000fe200078ec0ffULL,
0x00000000ff437424ULL, 0x000fc800078e00ffULL, 0xfffe916042007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005e6ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000748ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009d0ULL, 0x0000000000000360ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d30ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000df0ULL, 0x0000000000000780ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001570ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001610ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001614ULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000016f80ULL, 0xdc00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018780ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000187d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018b50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001610ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017170ULL, 0x0000000000017170ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018780ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018b50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 101424;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
