/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000136b0ULL, 0x0000000000013330ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454536316a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL,
0x326a4c4545326a4cULL, 0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x324545386a4c4538ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL,
0x4536316a4c454534ULL, 0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x5f5f240000000000ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x756265642e006675ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x632e766e2e00656dULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL,
0x000000000061686dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000376ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000b0001000003bcULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b00010000040aULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b00010000044fULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a0022000004aaULL, 0x0000000000011d20ULL, 0x0000000000000260ULL,
0x0004000300000520ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000011f80ULL, 0x000d000300000550ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00011d2000000000ULL, 0x0000ac0400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x00011d2000000000ULL, 0x0000026000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001600082f04ULL, 0x000823040000007cULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000013000942804ULL, 0x000007e000000150ULL,
0x00002630000025b0ULL, 0x00002830000026f0ULL, 0x00002d6000002d50ULL, 0x00004c3000004bd0ULL,
0x00004e7000004d30ULL, 0x000052a000005290ULL, 0x00006f5000006ef0ULL, 0x0000719000007050ULL,
0x000075d0000075c0ULL, 0x000092b000009240ULL, 0x000094d000009390ULL, 0x0000988000009870ULL,
0x0000a8d00000a8c0ULL, 0x00011190000110e0ULL, 0x00011440000113c0ULL, 0x00011710000116c0ULL,
0x00011a6000011830ULL, 0x0000030004303904ULL, 0x00017600000000ffULL, 0x000003e000040100ULL,
0x000176080000000cULL, 0x000004f0003f0100ULL, 0x000176880000000cULL, 0x00000610003f0100ULL,
0x000176a800000006ULL, 0x00000720003f0100ULL, 0x000176c800000000ULL, 0x000008c0003f0100ULL,
0x000176000000000dULL, 0x00000a30003f0107ULL, 0x0001768800000003ULL, 0x000014d0003f0101ULL,
0x00000000000000ffULL, 0x0000150000040107ULL, 0x00000000000000ffULL, 0x0000158000040101ULL,
0x0000002000000038ULL, 0x000016d0003f0101ULL, 0x000176c800000038ULL, 0x00001850003f0109ULL,
0x000176c800000038ULL, 0x000022d0003f0109ULL, 0x000176a80000003eULL, 0x00002320003f0107ULL,
0x000176a80000003eULL, 0x00002330003f0101ULL, 0x0001760800000047ULL, 0x00002350003f0101ULL,
0x0001760800000047ULL, 0x000024c0003f0109ULL, 0x0001760800000047ULL, 0x000029e0003f0109ULL,
0x000176a800000040ULL, 0x00002b50003f0109ULL, 0x000176a800000040ULL, 0x00003c10003f0109ULL,
0x000176c80000003aULL, 0x00003c40003f0101ULL, 0x000176880000003dULL, 0x00003d90003f0101ULL,
0x0000000000000048ULL, 0x00003f00003f0109ULL, 0x0000000000000048ULL, 0x00004960003f0109ULL,
0x000176a800000050ULL, 0x000049a0003f0107ULL, 0x000176a800000050ULL, 0x000049b0003f0101ULL,
0x0001762800000047ULL, 0x000049d0003f0101ULL, 0x0001762800000047ULL, 0x00004b40003f0109ULL,
0x0001762800000047ULL, 0x00005020003f0109ULL, 0x000176a80000003eULL, 0x00005190003f0109ULL,
0x000176a80000003eULL, 0x000060a0003f0109ULL, 0x000176c80000005bULL, 0x000060d0003f0101ULL,
0x000176900000003dULL, 0x00006190003f0101ULL, 0x0000000000000048ULL, 0x00006300003f0109ULL,
0x0000000000000048ULL, 0x00006c00003f0109ULL, 0x00000000000000ffULL, 0x00006cc000040107ULL,
0x000176a80000003eULL, 0x00006cd0003f0101ULL, 0x0001764800000047ULL, 0x00006cf0003f0101ULL,
0x0001764800000047ULL, 0x00006e60003f0109ULL, 0x0001764800000047ULL, 0x00007340003f0109ULL,
0x000176a800000050ULL, 0x000074b0003f0109ULL, 0x000176a800000050ULL, 0x000083c0003f0109ULL,
0x000176c80000005cULL, 0x00008400003f0101ULL, 0x000176980000003dULL, 0x000084e0003f0101ULL,
0x0000000000000048ULL, 0x00008650003f0109ULL, 0x0000000000000048ULL, 0x00008f50003f0109ULL,
0x00000000000000ffULL, 0x0000901000050107ULL, 0x000176a800000050ULL, 0x00009020003f0101ULL,
0x0001766800000047ULL, 0x00009040003f0101ULL, 0x0001766800000047ULL, 0x000091b0003f0109ULL,
0x0001766800000047ULL, 0x00009670003f0109ULL, 0x000176a80000003eULL, 0x000097e0003f0109ULL,
0x000176a80000003eULL, 0x0000a530003f0109ULL, 0x000176c800000038ULL, 0x0000a550003f0101ULL,
0x000176a00000003dULL, 0x0000b420003f0101ULL, 0x000176000000000dULL, 0x0000d1b0003f0101ULL,
0x000176000000000dULL, 0x0000d320003f0109ULL, 0x000176000000000dULL, 0x0000d500003f0109ULL,
0x000176000000000dULL, 0x0000d520003f0101ULL, 0x000176000000000dULL, 0x0000d690003f0109ULL,
0x000176000000000dULL, 0x00010630003f0109ULL, 0x0001768800000008ULL, 0x00010800003f0101ULL,
0x0001768800000008ULL, 0x00010970003f0109ULL, 0x0001768800000008ULL, 0x00011cb0003f0109ULL,
0x000176080000000bULL, 0x00011cc0003f0101ULL, 0x000176100000000bULL, 0x00011cd0003f0101ULL,
0x000176180000000bULL, 0x00011ce0003f0101ULL, 0x000176200000000bULL, 0x00053803003f0101ULL,
0x0000b15000141c04ULL, 0x0000d6c00000b3d0ULL, 0x00011d100000d780ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400501903ULL, 0x0050021000000017ULL,
0x00000000000000bcULL, 0x0000001600000002ULL, 0x0000000000011d20ULL, 0x0000000000000044ULL,
0x0000001600000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001600000002ULL,
0x0000000000000000ULL, 0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000087919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008400ff137b82ULL, 0x000ee20000000800ULL,
0x00000400000d7802ULL, 0x000fe20000000f00ULL, 0x0000000000057919ULL, 0x000ea20000002200ULL,
0x000002e000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000f280000002100ULL,
0x00008e00ff367b82ULL, 0x000f620000000a00ULL, 0x00000000000e7919ULL, 0x000ea20000000000ULL,
0x0000000000107919ULL, 0x000ea20000002600ULL, 0x0000000000307919ULL, 0x000ea20000002700ULL,
0x00000000000c7919ULL, 0x000ea20000008800ULL, 0x0000000813027824ULL, 0x008fc400078e00ffULL,
0x0000000408007c24ULL, 0x004fe2000f8e0205ULL, 0x0000000000047ab9ULL, 0x000fe20000000800ULL,
0x00008800ff047b82ULL, 0x000f640000000a00ULL, 0x0000000400007c24ULL, 0x110fe2000f8e0203ULL,
0x00000005ff3c7819ULL, 0x000fe40000011603ULL, 0x00001fff08037589ULL, 0x0005e400000e0000ULL,
0x0000007f0000780cULL, 0x040fe40003f84070ULL, 0x00001fff3c3c7589ULL, 0x000ee200000e0000ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x0000000810077824ULL, 0x002fe200078e00ffULL,
0x0000000f0000780cULL, 0x000fc40003f24070ULL, 0x00000004ff087819ULL, 0x004fe2000001160eULL,
0x0000003002077224ULL, 0x000fe200078e0207ULL, 0x000000030000780cULL, 0x000fe20003f64070ULL,
0x000000100e027824ULL, 0x000fe200078e00ffULL, 0x000006540c0d7816ULL, 0x000fe4000000000dULL,
0x00000000000ac919ULL, 0x000e620000008800ULL, 0x000004000009c802ULL, 0x000fe20000000f00ULL,
0xff317217ff0bc424ULL, 0x000fe200078e00ffULL, 0x000000010000780cULL, 0x000fe20003f44070ULL,
0x0000000403067824ULL, 0x008fc800078e023cULL, 0x0000000206067824ULL, 0x000fe200078e00ffULL,
0x000006540a0fc816ULL, 0x002fc60000000009ULL, 0x00000001060a7824ULL, 0x000fe200078e0208ULL,
0x0000000806097848ULL, 0x000fc60007fe0000ULL, 0x0000000107077824ULL, 0x000fe400078e020aULL,
0x0000000109097824ULL, 0x000fe400078e0a06ULL, 0x000000040006c824ULL, 0x000fe200078e020fULL,
0x0000000000240947ULL, 0x020fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01760006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x00000004000c7c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x000000000c0612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01760804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x00000004000c7c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x000000000c0612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01768804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0174000b0600c388ULL, 0x0003e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000400067c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000060612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000400007c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000000d0472caULL, 0x000fe200000e0000ULL, 0x0000010007047825ULL, 0x000fe200078e0004ULL,
0x000000f002077812ULL, 0x000fe200078ec0ffULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000010a007824ULL, 0x000fe200078e020eULL,
0x000000090800720cULL, 0x000fe20003f06070ULL, 0x000000100a0b7824ULL, 0x002fe200078e00ffULL,
0x0000000704047210ULL, 0x000fe20007f3e0ffULL, 0x0001760004047890ULL, 0x000fe2000fffe03fULL,
0x0000000430367825ULL, 0x000fc400078e0036ULL, 0xfffffff00b007812ULL, 0x000fe400078ee200ULL,
0x000000ffff057224ULL, 0x000fc600008e0605ULL, 0x0000001000077824ULL, 0x000fca00078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000636367981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x0000003f36357836ULL, 0x004fe40000000000ULL, 0x000000ff36007836ULL, 0x000fc60000000000ULL,
0x00000006ff357819ULL, 0x000fe40000011635ULL, 0x00000008ff0f7819ULL, 0x000fca0000011600ULL,
0x000000a8009c8947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe2000001163cULL,
0x00000004ff087424ULL, 0x000fc600078e00ffULL, 0x03ffffff0c547812ULL, 0x000fc800078ec0ffULL,
0x000000355400720cULL, 0x000fda0003f06070ULL, 0x00009000ff068b82ULL, 0x000ea20000000800ULL,
0x0000000230038824ULL, 0x000fce00078e00ffULL, 0x00008c00ff048b82ULL, 0x002e620000000a00ULL,
0x0000000603038224ULL, 0x004fe400078e0206ULL, 0xffffffffff067424ULL, 0x000fe400078e00ffULL,
0x0000000154078824ULL, 0x000fe400078e0203ULL, 0x000000083c037824ULL, 0x000fe400078e020dULL,
0x0000000407048825ULL, 0x002fe400078e0004ULL, 0x0176880803ff79a7ULL, 0x0003e6000850003fULL,
0x0000000604068981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x00000040100a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff347819ULL, 0x000fc4000001163cULL,
0x000000013c037812ULL, 0x002fc600078ec0ffULL, 0x00000020340b7824ULL, 0x000fca00078e00ffULL,
0x000000200a007812ULL, 0x000fe200078ef80bULL, 0x0000001306067224ULL, 0x004fc800078e02ffULL,
0x0000004006187824ULL, 0x000fe200078e00ffULL, 0x0000000400240947ULL, 0x000fec0003800000ULL,
0x0000000b36047248ULL, 0x000fe20007fe0000ULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x100fe2000001160eULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000070021b7812ULL, 0x000fe200078ec0ffULL, 0x0000000104047824ULL, 0x000fe400078e0a0bULL,
0x0000000103077824ULL, 0x000fe400078e0205ULL, 0x0000000405087836ULL, 0x000fe20000000000ULL,
0x0000000304047248ULL, 0x000fe20007fe0000ULL, 0x0000000107067824ULL, 0x000fc400078e020eULL,
0x0000000807097824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe400078e0a03ULL,
0x0000000100077824ULL, 0x000fe200078e0207ULL, 0xfffffff809067812ULL, 0x000fe200078ee206ULL,
0x0000000805097836ULL, 0x000fe20000000000ULL, 0x000000040500720cULL, 0x080fe20003f66070ULL,
0x0000000c05107836ULL, 0x000fe20000000000ULL, 0x0000000718177210ULL, 0x000fe20007f1e0ffULL,
0x0000000103057824ULL, 0x000fe200078e0208ULL, 0x000000040900720cULL, 0x080fe20003f26070ULL,
0x0000000103097824ULL, 0x000fe200078e0209ULL, 0x000000040800720cULL, 0x000fe20003f46070ULL,
0x0000000105077824ULL, 0x000fe200078e020eULL, 0x0000000417167c11ULL, 0x000fe2000f8838ffULL,
0x0000000805127824ULL, 0x000fc400078e00ffULL, 0x0000000103117824ULL, 0x000fe400078e0210ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x000000041000720cULL, 0x000fe20003f06070ULL,
0x0000000100057824ULL, 0x040fe200078e0205ULL, 0xfffffff812047812ULL, 0x000fe200078ee207ULL,
0x0000000100037824ULL, 0x040fe200078e0209ULL, 0x0000000517177c11ULL, 0x000fe2000a0f3c08ULL,
0x0000000100077824ULL, 0x000fe200078e0211ULL, 0x0000000518147210ULL, 0x000fe20007f9e0ffULL,
0x0000000109007824ULL, 0x140fe200078e020eULL, 0x0000000318107210ULL, 0x000fe20007fbe0ffULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x0000000718077210ULL, 0x000fe20007fde0ffULL,
0x0000000111037824ULL, 0x000fc400078e020eULL, 0x0000000811187824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x000fe200078ee200ULL, 0x000000ffff097224ULL, 0x000fe200020e06ffULL,
0x0000000414127c11ULL, 0x000fe2000f8838ffULL, 0x0000200034007824ULL, 0x000fe400078e020dULL,
0x000000ffff197224ULL, 0x000fe200028e06ffULL, 0x0000000514147c11ULL, 0x000fe2000a0f3c09ULL,
0x0001300000057836ULL, 0x000fe20000000000ULL, 0x000000161b027210ULL, 0x000fe40007f9e0ffULL,
0xfffffff818007812ULL, 0x000fe200078ee203ULL, 0x0000001006117824ULL, 0x100fe200078e0205ULL,
0x0000000410097c11ULL, 0x000fe2000f8a38ffULL, 0x0000001004137824ULL, 0x000fc400078e0205ULL,
0x0000001008157824ULL, 0x000fe200078e0205ULL, 0x0000000510107c11ULL, 0x000fe2000a8f3c19ULL,
0x000000ffff067224ULL, 0x000fe200030e06ffULL, 0x0000000407087c11ULL, 0x040fe2000f8c38ffULL,
0x000000ffff037224ULL, 0x000fe200020e0617ULL, 0x0000001b12047210ULL, 0x000fe20007f9e0ffULL,
0x0000001000177824ULL, 0x000fe200078e0205ULL, 0x0000000507007c11ULL, 0x000fe4000b0f3c06ULL,
0x0000001b09067210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0614ULL,
0x0000001b08087210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002117faeULL, 0x0003e4000d901c46ULL, 0x000000ffff077224ULL, 0x000fc400028e0610ULL,
0x000000ffff097224ULL, 0x000fe200020e0600ULL, 0x0000000004137faeULL, 0x0003e8000d101c46ULL,
0x0000000006157faeULL, 0x0003e8000c901c46ULL, 0x0000000008177faeULL, 0x0003e2000c101c46ULL,
0x0000000000f07947ULL, 0x000fea0003800000ULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000200034117824ULL, 0x000fe200078e020dULL,
0x0000007002197812ULL, 0x000fe400078ec0ffULL, 0x000000030e037211ULL, 0x000fe200078fe8ffULL,
0x0001300011177836ULL, 0x000fc80000000000ULL, 0x0000000403057836ULL, 0x000fe40000000000ULL,
0x0000000103047824ULL, 0x140fe400078e020eULL, 0x0000000803077824ULL, 0x000fe400078e00ffULL,
0x0000000105067824ULL, 0x040fe400078e020eULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0xfffffff807047812ULL, 0x000fe200078ee204ULL, 0x0000000803077836ULL, 0x000fc40000000000ULL,
0x0000000100057824ULL, 0x040fe200078e0205ULL, 0xfffffff809067812ULL, 0x000fe200078ee206ULL,
0x0000000c03097836ULL, 0x000fe40000000000ULL, 0x0000000100037824ULL, 0x040fe200078e0203ULL,
0x0000000518127210ULL, 0x000fe20007f5e0ffULL, 0x0000000100087824ULL, 0x040fe400078e0207ULL,
0x0000000100007824ULL, 0x000fe200078e0209ULL, 0x0000000318147210ULL, 0x000fe20007f3e0ffULL,
0x0000000807137824ULL, 0x000fe200078e00ffULL, 0x0000000818107210ULL, 0x000fe20007f7e0ffULL,
0x0000000109037824ULL, 0x100fe200078e020eULL, 0x0000000018057210ULL, 0x000fe20007f1e0ffULL,
0x0000000107007824ULL, 0x000fc400078e020eULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x0000000414087c11ULL, 0x000fe2000f8238ffULL, 0x0000000809167824ULL, 0x000fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fe200078ee200ULL, 0x0000001004117824ULL, 0x000fe200078e0217ULL,
0x0000000514147c11ULL, 0x000fe200088f3c07ULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x0000000412047c11ULL, 0x000fe2000f8238ffULL, 0x0000001006137824ULL, 0x100fe200078e0217ULL,
0xfffffff816037812ULL, 0x000fe200078ee203ULL, 0x0000001000157824ULL, 0x000fe200078e0217ULL,
0x0000000512097c11ULL, 0x000fe200088f3c09ULL, 0x000000ffff077224ULL, 0x000fe200018e06ffULL,
0x0000000819027210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000000410067c11ULL, 0x000fe2000f8438ffULL, 0x0000001003177824ULL, 0x000fe200078e0217ULL,
0x0000000405087c11ULL, 0x000fe2000f8638ffULL, 0x000000ffff037224ULL, 0x000fe200008e0614ULL,
0x0000000419047210ULL, 0x000fc40007f1e0ffULL, 0x0000000510077c11ULL, 0x000fe400090f3c07ULL,
0x0000000619067210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002117faeULL, 0x0003e2000b901c46ULL, 0x0000000505007c11ULL, 0x000fe200098f3c00ULL,
0x000000ffff057224ULL, 0x000fe200000e0609ULL, 0x0000000819087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff077224ULL, 0x000fc600008e0607ULL, 0x0000000004137faeULL, 0x0003e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fc600010e0600ULL, 0x0000000006157faeULL, 0x0003e8000b901c46ULL,
0x0000000008177faeULL, 0x0003e4000b901c46ULL, 0x0000000154547836ULL, 0x000fe40000000000ULL,
0xffffffffff097424ULL, 0x002fc600078e00ffULL, 0x000000355400720cULL, 0x000fda0003f06070ULL,
0x00009000ff058b82ULL, 0x000e620000000800ULL, 0x0000000230008824ULL, 0x000fce00078e00ffULL,
0x00008c00ff028b82ULL, 0x000ea20000000a00ULL, 0x00000000340472caULL, 0x000fe200000e0000ULL,
0x0000000500058224ULL, 0x002fc800078e0205ULL, 0x0000000105058824ULL, 0x000fc800078e0254ULL,
0x0000000405028825ULL, 0x004fc800078e0002ULL, 0x000176a80d057836ULL, 0x000fe20000000000ULL,
0x0000000602098981ULL, 0x000322000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000050572caULL, 0x000fe200000e0000ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x0000000834387824ULL, 0x000fe200078e0205ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x00000039ff0279a7ULL, 0x0002a20008500004ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00002039383879a7ULL, 0x002e62000850003fULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000009000648947ULL, 0x000fec0003800000ULL,
0x00009000ff057b82ULL, 0x000ee20000000800ULL, 0x0000000230087824ULL, 0x000fe400078e00ffULL,
0x000000ffff557224ULL, 0x004fe400078e0003ULL, 0xff317217ff537424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff307224ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fc400078e00ffULL, 0x0000000508087224ULL, 0x008fce00078e0205ULL,
0x0000010006057824ULL, 0x000fca00078e00ffULL, 0x000000360500720cULL, 0x000fda0003f06070ULL,
0x00000090002c0947ULL, 0x002fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe400078e0054ULL,
0x000000ffff047224ULL, 0x000fce00078e0030ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x000000043c317824ULL, 0x000fca00078e00ffULL, 0xfffffff831387812ULL, 0x002fca00078ec0ffULL,
0x000000010d387824ULL, 0x000fc800078e0238ULL, 0x0176c839380075a7ULL, 0x000e62000800017fULL,
0x000176c838487836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fce0000015200ULL,
0x0000003a323a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e33ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff317819ULL, 0x000fc8000001143bULL, 0x0000003a31317211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000231317819ULL, 0x000fc8000000123aULL,
0x000000310000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176c839380075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000106327836ULL, 0x000fe20000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000103c317824ULL, 0x000fe200078e00ffULL,
0x00000001303f7812ULL, 0x000fe200078e0cffULL, 0x0000000409097c24ULL, 0x010fe2000f8e02ffULL,
0x0000000f3200720cULL, 0x000fe40003f06070ULL, 0xffffffe031337812ULL, 0x000fe200078ec0ffULL,
0x0000004009407824ULL, 0x000fc800078e00ffULL, 0x0000010006337824ULL, 0x000fc800078e0233ULL,
0x0000004033337836ULL, 0x000fca0000000000ULL, 0x000000200a3e7812ULL, 0x000fe200078ef833ULL,
0x00000004002c8947ULL, 0x000fec0003800000ULL, 0x0000003336097248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000001031327812ULL, 0x000fe400078ec0ffULL,
0x00000003ff377819ULL, 0x000fe2000001160eULL, 0x0000000109097824ULL, 0x000fc800078e0a33ULL,
0x0000000137317824ULL, 0x000fe200078e0232ULL, 0x0000003209097248ULL, 0x000fe20007fe0000ULL,
0x0000000837397836ULL, 0x000fe40000000000ULL, 0x0000000131337824ULL, 0x040fe400078e020eULL,
0x0000000831387824ULL, 0x000fe400078e00ffULL, 0x000000013e317824ULL, 0x000fe400078e0231ULL,
0x0000000109097824ULL, 0x100fe200078e0a32ULL, 0xfffffff838337812ULL, 0x000fe200078ee233ULL,
0x0000000437387836ULL, 0x000fe20000000000ULL, 0x00000031403d7210ULL, 0x000fe20007f1e0ffULL,
0x0000000c37417836ULL, 0x000fe20000000000ULL, 0x000000093700720cULL, 0x080fe20003f66070ULL,
0x0000000138377824ULL, 0x140fe200078e0232ULL, 0x000000093900720cULL, 0x0c0fe20003f26070ULL,
0x0000000139397824ULL, 0x000fe200078e0232ULL, 0x000000093800720cULL, 0x080fe20003f46070ULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x000000094100720cULL, 0x000fe20003f06070ULL,
0x0000000137317824ULL, 0x000fe200078e020eULL, 0x000000043d3a7c11ULL, 0x000fe2000f8838ffULL,
0x0000000837427824ULL, 0x000fc400078e00ffULL, 0x00000001413b7824ULL, 0x000fe200078e0232ULL,
0x000000053d3d7c11ULL, 0x000fe2000a0f3c38ULL, 0x000000013e377824ULL, 0x040fe200078e0237ULL,
0xfffffff842317812ULL, 0x000fe200078ee231ULL, 0x000000013e097824ULL, 0x000fe400078e0239ULL,
0x0000000139327824ULL, 0x040fe200078e020eULL, 0x0000003740447210ULL, 0x000fe20007f9e0ffULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x0000000940417210ULL, 0x000fe20007fbe0ffULL,
0x0000200034427824ULL, 0x000fc400078e020dULL, 0x000000013e387824ULL, 0x000fe200078e023bULL,
0xfffffff839377812ULL, 0x000fe200078ee232ULL, 0x000000100e397824ULL, 0x000fe400078e00ffULL,
0x000000013b327824ULL, 0x040fe200078e020eULL, 0x00000038403e7210ULL, 0x000fe20007fde0ffULL,
0x000000083b477824ULL, 0x000fe200078e00ffULL, 0x0000007039457812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e06ffULL, 0x0000000444437c11ULL, 0x040fe2000f8838ffULL,
0x000010003f097824ULL, 0x000fe200078e0242ULL, 0xfffffff847397812ULL, 0x000fe200078ee232ULL,
0x000000ffff427224ULL, 0x000fe200028e06ffULL, 0x0000000544447c11ULL, 0x000fe2000a0f3c3bULL,
0x0001300009387836ULL, 0x000fe20000000000ULL, 0x000000453a327210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e06ffULL, 0x00000004413a7c11ULL, 0x000fe2000f8a38ffULL,
0x0000001033097824ULL, 0x000fe200078e0238ULL, 0x000000043e407c11ULL, 0x040fe2000f8c38ffULL,
0x000000ffff337224ULL, 0x000fe200020e063dULL, 0x0000000541417c11ULL, 0x000fe2000a8f3c42ULL,
0x0000001031317824ULL, 0x100fe200078e0238ULL, 0x000000453a3a7210ULL, 0x000fe20007fbe0ffULL,
0x0000001037377824ULL, 0x100fe200078e0238ULL, 0x000000053e3e7c11ULL, 0x000fe2000b0f3c3bULL,
0x00000010393d7824ULL, 0x000fe200078e0238ULL, 0x0000004543387210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200028e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032097faeULL, 0x0003e6000d901c46ULL, 0x000000ffff397224ULL, 0x000fe200020e0644ULL,
0x0000004540407210ULL, 0x000fc80007f9e0ffULL, 0x0000000038317faeULL, 0x0003e2000d101c46ULL,
0x000000ffff417224ULL, 0x000fc600020e063eULL, 0x000000003a377faeULL, 0x0003e8000c901c46ULL,
0x00000000403d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000f87947ULL, 0x000fea0003800000ULL,
0x0000001031097812ULL, 0x000fe200078ec0ffULL, 0x0000200034447824ULL, 0x000fe200078e020dULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x000000100e3b7824ULL, 0x040fe200078e00ffULL,
0x000000090e097211ULL, 0x000fe200078fe8ffULL, 0x000010003f447824ULL, 0x000fc600078e0244ULL,
0x000000703b457812ULL, 0x000fe200078ec0ffULL, 0x0000000409337836ULL, 0x000fe40000000000ULL,
0x0000000109317824ULL, 0x100fe400078e020eULL, 0x0000000133327824ULL, 0x040fe400078e020eULL,
0x0000000833377824ULL, 0x000fe400078e00ffULL, 0x0000000809387824ULL, 0x000fe400078e00ffULL,
0x0000000c09397836ULL, 0x000fe20000000000ULL, 0xfffffff837327812ULL, 0x000fe200078ee232ULL,
0x0000000809377836ULL, 0x000fe20000000000ULL, 0xfffffff838317812ULL, 0x000fe200078ee231ULL,
0x000000013e097824ULL, 0x000fc400078e0209ULL, 0x000000013e387824ULL, 0x040fe400078e0237ULL,
0x000000013e337824ULL, 0x040fe200078e0233ULL, 0x0000000940437210ULL, 0x000fe20007f3e0ffULL,
0x000000013e3a7824ULL, 0x000fe200078e0239ULL, 0x0000003840417210ULL, 0x000fe20007f7e0ffULL,
0x0000000137097824ULL, 0x140fe200078e020eULL, 0x0000003340427210ULL, 0x000fe20007f5e0ffULL,
0x0000000837387824ULL, 0x000fe200078e00ffULL, 0x0000003a403a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000139377824ULL, 0x000fc400078e020eULL, 0x0000000839467824ULL, 0x000fe200078e00ffULL,
0xfffffff838337812ULL, 0x000fe200078ee209ULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x0000000443407c11ULL, 0x040fe2000f8238ffULL, 0x0001300044447836ULL, 0x000fe20000000000ULL,
0xfffffff846387812ULL, 0x000fe200078ee237ULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x0000000543437c11ULL, 0x000fe200088f3c3eULL, 0x0000001032097824ULL, 0x100fe200078e0244ULL,
0x00000004423e7c11ULL, 0x000fe2000f8238ffULL, 0x00000010383d7824ULL, 0x100fe200078e0244ULL,
0x00000004413b7c11ULL, 0x000fe2000f8438ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x0000000542427c11ULL, 0x000fe200088f3c39ULL, 0x000000ffff397224ULL, 0x000fe200000e06ffULL,
0x0000004540327210ULL, 0x000fe20007f3e0ffULL, 0x0000001033377824ULL, 0x100fe200078e0244ULL,
0x000000043a407c11ULL, 0x000fe2000f8638ffULL, 0x0000001031317824ULL, 0x000fe200078e0244ULL,
0x0000000541417c11ULL, 0x000fe200090f3c38ULL, 0x000000ffff337224ULL, 0x000fe200008e0643ULL,
0x000000453e387210ULL, 0x000fc40007f1e0ffULL, 0x000000053a3e7c11ULL, 0x000fe400098f3c39ULL,
0x000000453b3a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff397224ULL, 0x000fe200000e0642ULL,
0x0000004540407210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032317faeULL, 0x0003e4000b901c46ULL, 0x000000ffff3b7224ULL, 0x000fe400008e0641ULL,
0x000000ffff417224ULL, 0x000fe200010e063eULL, 0x0000000038097faeULL, 0x0003e8000b901c46ULL,
0x000000003a377faeULL, 0x0003e8000b901c46ULL, 0x00000000403d7faeULL, 0x0003e4000b901c46ULL,
0x0000000154317836ULL, 0x002fe40000000000ULL, 0xffffffffff097424ULL, 0x000fc600078e00ffULL,
0x000000353100720cULL, 0x000fda0003f06070ULL, 0x00008c00ff328b82ULL, 0x000e620000000a00ULL,
0x0000000108318824ULL, 0x000fc800078e0231ULL, 0x0000000431328825ULL, 0x002fc800078e0032ULL,
0x000000083c317824ULL, 0x000fe200078e00ffULL, 0x0000000632098981ULL, 0x000322000c1e1900ULL,
0x00000001ff3a7424ULL, 0x000fc600078e00ffULL, 0xfffffff031387812ULL, 0x040fe400078ec0ffULL,
0x0000001031377812ULL, 0x000fc600078ec0ffULL, 0x000000010d387824ULL, 0x000fe200078e0238ULL,
0x0000000831327812ULL, 0x002fc600078ec0ffULL, 0x000000083f3e7824ULL, 0x000fe200078e0238ULL,
0xffffffe031387812ULL, 0x000fc800078ec0ffULL, 0x000000003e0472caULL, 0x000fe400000e0000ULL,
0x0000000d37377210ULL, 0x000fe20007ffe038ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000137477824ULL, 0x000fcc00078e0232ULL, 0x000176a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a83a3e5879a7ULL, 0x0002a4000850003fULL, 0x0176083a473a79a7ULL, 0x0022e4000850003fULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x0176083b470075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff377224ULL, 0x000fce00078e00ffULL,
0x000000103700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x0000003832387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e33ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff317819ULL, 0x000fc80000011439ULL,
0x0000003831317211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x0000000231317819ULL, 0x000fc80000001238ULL, 0x000000310000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000137377836ULL, 0x000fce0000000000ULL,
0x0176083b470075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000203c317824ULL, 0x000fe200078e00ffULL, 0x00000001ff457819ULL, 0x000fe2000001160eULL,
0x000000100e327824ULL, 0x000fe400078e00ffULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0xffffff8031467812ULL, 0x000fe200078ec0ffULL, 0x000000ffff567224ULL, 0x000fe200078e0053ULL,
0x00000070323b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c45457812ULL, 0x000fe200078ec0ffULL,
0x000000010d467824ULL, 0x000fca00078e0246ULL, 0x0000004645317210ULL, 0x000fca0007ffe03bULL,
0x0170000031327984ULL, 0x000ee80000000800ULL, 0x0172000031377984ULL, 0x000b620000000800ULL,
0x000000533200720bULL, 0x008fda0003f1d000ULL, 0x0000000000337806ULL, 0x000fc800000e0100ULL,
0x0000ffff33397812ULL, 0x000fda000780c0ffULL, 0x0000000000f08947ULL, 0x026fea0003800000ULL,
0x0000003c0c00720cULL, 0x000fe40003f25270ULL, 0x000000533200720bULL, 0x000fe40003f14000ULL,
0x0000003253567209ULL, 0x000fd20007810000ULL, 0x000000803c389824ULL, 0x000fca00078e020dULL,
0x0000003845319210ULL, 0x000fe40007ffe03bULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x0174005631009388ULL, 0x0003e20000000800ULL, 0x0000991038337816ULL, 0x000fc800000000ffULL,
0x000000ff3300720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x8000005653317221ULL, 0x000fe20000010000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100407308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x002fcc000001160eULL, 0x00001f3140317589ULL, 0x004e6400000e0000ULL,
0x0000003128287220ULL, 0x082fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003110107220ULL, 0x080fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000004007077220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x000000080e317811ULL, 0x002fcc00078ff0ffULL, 0x00001f3140317589ULL, 0x000e6400000e0000ULL,
0x000000312a2a7220ULL, 0x082fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x0000003112127220ULL, 0x080fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff39ff7812ULL, 0x000fda0007806038ULL, 0x8000005632320221ULL, 0x000fe20000010000ULL,
0x00007610ff3a0816ULL, 0x000fc6000000003aULL, 0x3fb8aa3b32320820ULL, 0x000fc80000410000ULL,
0x0000003200020308ULL, 0x000ea40000000800ULL, 0x0000000237370220ULL, 0x004fce0000410000ULL,
0x0000000737077221ULL, 0x000fce0000010000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000001034317824ULL, 0x002fc800078e020dULL, 0x0000000830407824ULL, 0x000fc800078e0231ULL,
0x0176a855400075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fce0000015200ULL,
0x0000003832387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e33ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff317819ULL, 0x000fc80000011439ULL, 0x0000003831317211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000231317819ULL, 0x000fc80000001238ULL,
0x000000310000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176a855400075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000099103a327816ULL, 0x000fe200000000ffULL,
0x000000043c387824ULL, 0x000fe200078e00ffULL, 0x000000070e317812ULL, 0x000fe200078ec0ffULL,
0x0000200034497824ULL, 0x000fe200078e020dULL, 0x000000ff3200720cULL, 0x000fe20003f05270ULL,
0x000000023c3d7824ULL, 0x000fe200078e00ffULL, 0x00000008314c7812ULL, 0x000fe200078ef80eULL,
0x0000100030497824ULL, 0x000fe200078e0249ULL, 0x00000004ff537819ULL, 0x000fe2000001160eULL,
0x000002003c327824ULL, 0x000fe200078e00ffULL, 0x000000080e317812ULL, 0x000fe200078ec0ffULL,
0x000000084c337824ULL, 0x000fe200078e00ffULL, 0x0000000438387812ULL, 0x000fe200078ec0ffULL,
0x0001300049497836ULL, 0x000fe20000000000ULL, 0x000000043d307812ULL, 0x000fc400078ec0ffULL,
0x0000000731527812ULL, 0x000fe200078ef80eULL, 0x0000000153517824ULL, 0x000fe200078e0238ULL,
0x000000304c307210ULL, 0x000fe40007ffe053ULL, 0xfffff80032327812ULL, 0x000fe200078ec0ffULL,
0x0000000852317824ULL, 0x040fe200078e00ffULL, 0xfffffff833307812ULL, 0x000fe200078ee230ULL,
0x0000000152387824ULL, 0x000fe400078e0251ULL, 0x000000010d377824ULL, 0x000fc600078e0232ULL,
0xfffffff831327812ULL, 0x000fe200078ee238ULL, 0x0000001030447824ULL, 0x000fe200078e0237ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130007589ULL, 0x0002e400000e0000ULL, 0x0000001032407824ULL, 0x000fe400078e0249ULL,
0x011000004430783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x0000000852397824ULL, 0x000fe400078e00ffULL,
0x00000002384e7836ULL, 0x000fe40000000000ULL, 0x0000000434537824ULL, 0x000fc600078e0253ULL,
0xfffffff8394e7812ULL, 0x000fe400078ee24eULL, 0x0000000253537810ULL, 0x000fe20007ffe04cULL,
0x000000084c4c7824ULL, 0x000fe400078e00ffULL, 0x000000104e387824ULL, 0x000fcc00078e0249ULL,
0x000000003838783bULL, 0x000f640000004200ULL, 0x00000018ff617819ULL, 0x022fe20000011440ULL,
0x0000010040507824ULL, 0x040fe200078e00ffULL, 0x0000888040637816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011441ULL,
0x0000010041557824ULL, 0x040fe200078e00ffULL, 0x0000888041677816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff5d7819ULL, 0x000fe20000011442ULL, 0x0000004000667306ULL, 0x0003e20000202400ULL,
0x0000888042627816ULL, 0x000fe400000000ffULL, 0x00000018ff4d7819ULL, 0x008fe40000011438ULL,
0x00000018ff4f7819ULL, 0x000fc40000011439ULL, 0x0000888038577816ULL, 0x000fe200000000ffULL,
0x0000005000687306ULL, 0x0007620000202400ULL, 0x0000010043407824ULL, 0x042fe200078e00ffULL,
0x0000888043647816ULL, 0x040fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011443ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006700677306ULL, 0x000fe20000202400ULL, 0x0000010042507824ULL, 0x048fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001143aULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000055006c7306ULL, 0x0002e20000202400ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff4b7819ULL, 0x000fca000001143bULL, 0x00000041006a7306ULL, 0x0007e20000202400ULL,
0x0000888039557816ULL, 0x002fce00000000ffULL, 0x0000004000697306ULL, 0x0003e20000202400ULL,
0x0000010038417824ULL, 0x04cfe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000010039407824ULL, 0x042fe200078e00ffULL, 0x0000006100617306ULL, 0x000e620000202400ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011440ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000005000657306ULL, 0x000fe20000202400ULL,
0x000088803a407816ULL, 0x000fce00000000ffULL, 0x0000004200607306ULL, 0x000ff00000202400ULL,
0x0000005f005f7306ULL, 0x000eb00000202400ULL, 0x0000003800507306ULL, 0x000bf00000202400ULL,
0x0000003900427306ULL, 0x0007e20000202400ULL, 0x0000541063387816ULL, 0x020fce0000000068ULL,
0x0000006200627306ULL, 0x000f620000202400ULL, 0x0000541067397816ULL, 0x008fce000000006cULL,
0x0000006400647306ULL, 0x000ee20000202400ULL, 0x000000383028723cULL, 0x000fee0000041828ULL,
0x000001003b397824ULL, 0x000fe200078e00ffULL, 0x0000541066387816ULL, 0x002fe20000000061ULL,
0x0000005d005d7306ULL, 0x000e660000202400ULL, 0x00000018ff617819ULL, 0x000fc40000011439ULL,
0x000054106a397816ULL, 0x004fe2000000005fULL, 0x000100003a5f7824ULL, 0x000fe400078e00ffULL,
0x0000005b005b7306ULL, 0x000fe60000202400ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x000000383024723cULL, 0x000fe80000041824ULL, 0x00000043005e7306ULL, 0x0004660000202400ULL,
0x0000541062387816ULL, 0x020fe20000000065ULL, 0x000100003b627824ULL, 0x000fe200078e00ffULL,
0x0000541064397816ULL, 0x008fc60000000069ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x000088803b437816ULL, 0x004fe400000000ffULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x000000383020723cULL, 0x000fe80000041820ULL, 0x00000041005a7306ULL, 0x0004e60000202400ULL,
0x0000541060387816ULL, 0x002fc4000000005dULL, 0x000054105e397816ULL, 0x000fc6000000005bULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000001003a417824ULL, 0x004fc600078e00ffULL,
0x00000038301c723cULL, 0x000fe4000004181cULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000005c005c7306ULL, 0x000e660000202400ULL, 0x0000541057387816ULL, 0x008fca000000005aULL,
0x0000004d004d7306ULL, 0x000ea20000202400ULL, 0x0000541055397816ULL, 0x002fce000000005cULL,
0x0000004f004f7306ULL, 0x000e620000202400ULL, 0x000000383018723cULL, 0x000fee0000041818ULL,
0x0000004000407306ULL, 0x000fe20000202400ULL, 0x0000541050387816ULL, 0x004fe4000000004dULL,
0x0000541042397816ULL, 0x002fca000000004fULL, 0x0000004100417306ULL, 0x000e620000202400ULL,
0x0000001052507812ULL, 0x000fe200078efcffULL, 0x000000383014723cULL, 0x000fec0000041814ULL,
0x0000004a004a7306ULL, 0x000fe20000202400ULL, 0xfffffff84c387812ULL, 0x000fe200078ee253ULL,
0x0000000151397824ULL, 0x000fe200078e0250ULL, 0x0000541040407816ULL, 0x002fca0000000041ULL,
0x0000004b004b7306ULL, 0x000fe20000202400ULL, 0x00000008504c7824ULL, 0x000fe400078e00ffULL,
0x0000001038377824ULL, 0x000fc600078e0237ULL, 0xfffffff84c4c7812ULL, 0x000fe400078ee239ULL,
0x0000004300437306ULL, 0x000ff00000202400ULL, 0x00000061003a7306ULL, 0x000e700000202400ULL,
0x0000005f003b7306ULL, 0x000ea20000202400ULL, 0x0000541043417816ULL, 0x002fce000000003aULL,
0x0000006200627306ULL, 0x000e620000202400ULL, 0x000000403010723cULL, 0x000fe20000041810ULL,
0x000054103b4a7816ULL, 0x004fcc000000004aULL, 0x000000104c407824ULL, 0x000fe200078e0249ULL,
0x00005410624b7816ULL, 0x002fce000000004bULL, 0x0000004a302c723cULL, 0x000fe2000004182cULL,
0x011000003730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0x00000008503b7824ULL, 0x000fe400078e00ffULL, 0x00000002394a7836ULL, 0x000fe40000000000ULL,
0x0000000154547836ULL, 0x000fc60000000000ULL, 0xfffffff83b4a7812ULL, 0x000fca00078ee24aULL,
0x000000104a387824ULL, 0x000fcc00078e0249ULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x00000018ff5f7819ULL, 0x008fe20000011440ULL, 0x0000010040507824ULL, 0x040fe200078e00ffULL,
0x0000888040607816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011441ULL, 0x0000010041537824ULL, 0x040fe200078e00ffULL,
0x0000888041637816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000006000607306ULL, 0x000fe20000202400ULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff5b7819ULL, 0x000fe20000011442ULL,
0x0000004000687306ULL, 0x0007e20000202400ULL, 0x0000888042617816ULL, 0x000fe400000000ffULL,
0x00000018ff4f7819ULL, 0x022fe40000011438ULL, 0x00000018ff4d7819ULL, 0x000fc40000011439ULL,
0x0000888038557816ULL, 0x000fe200000000ffULL, 0x0000005000657306ULL, 0x0003620000202400ULL,
0x0000010043407824ULL, 0x048fe200078e00ffULL, 0x0000888043627816ULL, 0x040fe400000000ffULL,
0x00000018ff577819ULL, 0x000fe20000011443ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x0000010042507824ULL, 0x042fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc4000001143aULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000053006c7306ULL, 0x0002e20000202400ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff4b7819ULL, 0x000fca000001143bULL,
0x00000041006a7306ULL, 0x0007e20000202400ULL, 0x0000888039537816ULL, 0x002fce00000000ffULL,
0x0000004000677306ULL, 0x0003e20000202400ULL, 0x0000010038417824ULL, 0x04cfe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000010039407824ULL, 0x042fe200078e00ffULL,
0x0000005000647306ULL, 0x000fe20000202400ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011440ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000004200667306ULL, 0x000fe20000202400ULL, 0x000088803a407816ULL, 0x000fce00000000ffULL,
0x0000005f005f7306ULL, 0x000e700000202400ULL, 0x0000005d005d7306ULL, 0x000eb00000202400ULL,
0x0000003800507306ULL, 0x000bf00000202400ULL, 0x0000003900427306ULL, 0x0007e20000202400ULL,
0x0000541060387816ULL, 0x020fce0000000065ULL, 0x0000006100617306ULL, 0x000f620000202400ULL,
0x0000541063397816ULL, 0x008fce000000006cULL, 0x0000006200627306ULL, 0x000ee20000202400ULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x000001003b397824ULL, 0x000fe200078e00ffULL,
0x0000541068387816ULL, 0x002fe2000000005fULL, 0x0000005b005b7306ULL, 0x000e660000202400ULL,
0x00000018ff607819ULL, 0x000fc40000011439ULL, 0x000054106a397816ULL, 0x004fc6000000005dULL,
0x0000005700577306ULL, 0x000fe80000202400ULL, 0x000000383024723cULL, 0x000fe80000041824ULL,
0x00000043005e7306ULL, 0x0004660000202400ULL, 0x0000541061387816ULL, 0x020fc40000000064ULL,
0x0000541062397816ULL, 0x008fc60000000067ULL, 0x00000041005a7306ULL, 0x0007e20000202400ULL,
0x000088803b437816ULL, 0x044fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe400078e00ffULL,
0x000000383020723cULL, 0x000fe60000041820ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005500557306ULL, 0x000ea20000202400ULL, 0x000001003a417824ULL, 0x048fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541066387816ULL, 0x002fc4000000005bULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x00000018ff5d7819ULL, 0x000fe2000001143aULL, 0x00000008343a7824ULL, 0x000fe200078e020dULL,
0x000054105e397816ULL, 0x000fca0000000057ULL, 0x0000005c005c7306ULL, 0x000e640000202400ULL,
0x00000038301c723cULL, 0x000fec000004181cULL, 0x0000004000407306ULL, 0x000fe20000202400ULL,
0x0000541055387816ULL, 0x004fe2000000005aULL, 0x00000001ff557424ULL, 0x000fe200078e00ffULL,
0xfffffff83d5a7812ULL, 0x000fc400078ec0ffULL, 0x0000541053397816ULL, 0x002fc6000000005cULL,
0x0000004100417306ULL, 0x000e620000202400ULL, 0x000000010d3d7824ULL, 0x000fe400078e025aULL,
0x000000ffff537224ULL, 0x000fe200078e0056ULL, 0x000000383018723cULL, 0x000fe80000041818ULL,
0x0000004f004f7306ULL, 0x000ea20000202400ULL, 0x0176c8553a3879a7ULL, 0x0004e2000850003fULL,
0x0000541040407816ULL, 0x002fcc0000000041ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x017688553dff79a7ULL, 0x0003e2000850003fULL, 0x00005410503a7816ULL, 0x004fcc000000004fULL,
0x0000004900497306ULL, 0x000fe20000202400ULL, 0x000000ffff557224ULL, 0x002fce00078e0059ULL,
0x0000004b004b7306ULL, 0x000ff00000202400ULL, 0x0000004300437306ULL, 0x000ff00000202400ULL,
0x0000006000607306ULL, 0x000e700000202400ULL, 0x0000005d00627306ULL, 0x000ea20000202400ULL,
0x0000541043417816ULL, 0x002fce0000000060ULL, 0x0000003b005e7306ULL, 0x0003620000202400ULL,
0x000000403010723cULL, 0x000fe20000041810ULL, 0x0000541062627816ULL, 0x004fe40000000049ULL,
0x00005410423b7816ULL, 0x002fe4000000004dULL, 0x000054105e637816ULL, 0x020fca000000004bULL,
0x0000003a3014723cULL, 0x000fec0000041814ULL, 0x00000062302c723cULL, 0x000fee000004182cULL,
0x0000004006317811ULL, 0x000fe200078e40ffULL, 0x000000ffff307224ULL, 0x000fc600078e003fULL,
0x000000363100720cULL, 0x000fda0003f06070ULL, 0x0000006800680947ULL, 0x008fea0003800000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x00000039480075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x00000039480075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000106307836ULL, 0x000fe20000000000ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x000000103c317824ULL, 0x000fe400078e00ffULL, 0x0000000509097c24ULL, 0x010fe2000f8e02ffULL,
0x0000000f3000720cULL, 0x000fe40003f06070ULL, 0xffffffe031337812ULL, 0x000fe200078ec0ffULL,
0x0000004009097824ULL, 0x000fc800078e00ffULL, 0x0000010006337824ULL, 0x000fc800078e0233ULL,
0x0000008033337836ULL, 0x000fca0000000000ULL, 0x000000200a397812ULL, 0x000fe200078ef833ULL,
0x0000000400308947ULL, 0x000fec0003800000ULL, 0x0000001031387812ULL, 0x000fe200078ec0ffULL,
0x0000100004307824ULL, 0x000fe200078e00ffULL, 0x0000003336317248ULL, 0x000fe20007fe0000ULL,
0x00008a0000087ab9ULL, 0x000fe20000000a00ULL, 0x00000003ff3a7819ULL, 0x000fe4000001160eULL,
0x0000100030307812ULL, 0x000fe200078ec0ffULL, 0x0000000131317824ULL, 0x000fe400078e0a33ULL,
0x000000013a3b7824ULL, 0x000fe400078e0238ULL, 0x0000200034337824ULL, 0x000fe200078e020dULL,
0x0000003138317248ULL, 0x000fe20007fe0000ULL, 0x000000013b407824ULL, 0x000fc400078e020eULL,
0x000000083b417824ULL, 0x000fe200078e00ffULL, 0x0001300033327810ULL, 0x000fe20007ffe030ULL,
0x0000000131317824ULL, 0x100fe400078e0a38ULL, 0x000000043a307836ULL, 0x000fe20000000000ULL,
0xfffffff841337812ULL, 0x000fe200078ee240ULL, 0x000000083a407836ULL, 0x000fe20000000000ULL,
0x000000313a00720cULL, 0x080fe20003f66070ULL, 0x0000000c3a437836ULL, 0x000fe20000000000ULL,
0x000000313000720cULL, 0x0c0fe20003f46070ULL, 0x00000001303a7824ULL, 0x100fe200078e0238ULL,
0x000000314000720cULL, 0x0c0fe20003f26070ULL, 0x000000013b307824ULL, 0x000fe200078e0239ULL,
0x000000314300720cULL, 0x000fe20003f06070ULL, 0x0000000140427824ULL, 0x000fc400078e0238ULL,
0x000000013a3b7824ULL, 0x040fe200078e020eULL, 0x0000003009417210ULL, 0x000fe20007f9e0ffULL,
0x000000083a407824ULL, 0x040fe400078e00ffULL, 0x0000000143497824ULL, 0x000fe400078e0238ULL,
0x000000013a307824ULL, 0x100fe200078e0239ULL, 0xfffffff8403b7812ULL, 0x000fe200078ee23bULL,
0x000000ffff407224ULL, 0x000fe200020e06ffULL, 0x0000000841317c11ULL, 0x000fe2000f8838ffULL,
0x0000000142387824ULL, 0x000fc400078e0239ULL, 0x00000001493a7824ULL, 0x000fe200078e0239ULL,
0x0000000941417c11ULL, 0x000fe2000a0f3c40ULL, 0x0000000149397824ULL, 0x140fe200078e020eULL,
0x0000003009307210ULL, 0x000fe20007f9e0ffULL, 0x0000000849407824ULL, 0x000fe200078e00ffULL,
0x00000038094b7210ULL, 0x000fe20007fbe0ffULL, 0x000000100e387824ULL, 0x000fe200078e00ffULL,
0x0000003a093a7210ULL, 0x000fe20007fde0ffULL, 0x0000000142097824ULL, 0x000fe200078e020eULL,
0xfffffff840497812ULL, 0x000fe200078ee239ULL, 0x000000ffff4f7224ULL, 0x000fe200020e06ffULL,
0x00000008304d7c11ULL, 0x000fe2000f8838ffULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0x0000007038387812ULL, 0x000fe200078ec0ffULL, 0x000000103b397824ULL, 0x100fe200078e0232ULL,
0x00000009304f7c11ULL, 0x000fe2000a0f3c4fULL, 0x000000ffff407224ULL, 0x000fe200028e06ffULL,
0xfffffff842437812ULL, 0x000fe200078ee209ULL, 0x0000001033097824ULL, 0x100fe200078e0232ULL,
0x0000003831307210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff337224ULL, 0x000fe200030e06ffULL,
0x000000084b3b7c11ULL, 0x000fe2000f8a38ffULL, 0x0000001043437824ULL, 0x000fc400078e0232ULL,
0x000000ffff317224ULL, 0x000fe200020e0641ULL, 0x000000083a417c11ULL, 0x040fe2000f8c38ffULL,
0x0000001049497824ULL, 0x000fe200078e0232ULL, 0x000000384d327210ULL, 0x000fe40007f9e0ffULL,
0x000000094b4b7c11ULL, 0x000fe2000a8f3c40ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030097faeULL, 0x0003e2000d901c46ULL, 0x000000093a427c11ULL, 0x000fe2000b0f3c33ULL,
0x000000ffff337224ULL, 0x000fe200020e064fULL, 0x000000383b3a7210ULL, 0x000fe40007fbe0ffULL,
0x0000003841407210ULL, 0x000fc40007f9e0ffULL, 0x0000000032397faeULL, 0x0003e2000d101c46ULL,
0x000000ffff3b7224ULL, 0x000fe400028e064bULL, 0x000000ffff417224ULL, 0x000fc600020e0642ULL,
0x000000003a437faeULL, 0x0003e8000c901c46ULL, 0x0000000040497faeULL, 0x0003e2000c101c46ULL,
0x0000000000fc7947ULL, 0x000fea0003800000ULL, 0x0000001031317812ULL, 0x000fe200078ec0ffULL,
0x0000200034307824ULL, 0x000fe200078e020dULL, 0x00008a0000087ab9ULL, 0x000fe40000000a00ULL,
0x000000310e327211ULL, 0x000fe200078fe8ffULL, 0x0000100004317824ULL, 0x000fc800078e00ffULL,
0x0000000432387836ULL, 0x000fe20000000000ULL, 0x0000100031337812ULL, 0x000fe200078ec0ffULL,
0x0000000132317824ULL, 0x100fe400078e020eULL, 0x00000001383a7824ULL, 0x000fe200078e020eULL,
0x0001300030407810ULL, 0x000fe20007ffe033ULL, 0x0000000838417824ULL, 0x000fe400078e00ffULL,
0x0000000832427824ULL, 0x040fe400078e00ffULL, 0x0000000132307824ULL, 0x100fe200078e0239ULL,
0xfffffff841417812ULL, 0x000fe200078ee23aULL, 0x0000000c32337836ULL, 0x000fe20000000000ULL,
0xfffffff8423b7812ULL, 0x000fe200078ee231ULL, 0x0000000832317836ULL, 0x000fe20000000000ULL,
0x00000030093a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000138307824ULL, 0x000fc400078e0239ULL,
0x0000000133387824ULL, 0x100fe400078e0239ULL, 0x0000000131327824ULL, 0x000fe200078e0239ULL,
0x0000003009307210ULL, 0x000fe20007f3e0ffULL, 0x0000000133497824ULL, 0x140fe200078e020eULL,
0x0000003809427210ULL, 0x000fe20007f7e0ffULL, 0x0000000833547824ULL, 0x000fe200078e00ffULL,
0x0000003209327210ULL, 0x000fe20007f5e0ffULL, 0x0000000131397824ULL, 0x040fe400078e020eULL,
0x0000000831507824ULL, 0x000fe200078e00ffULL, 0xfffffff854497812ULL, 0x000fe200078ee249ULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x000000083a317c11ULL, 0x000fe2000f8038ffULL,
0x000000100e387824ULL, 0x000fe200078e00ffULL, 0xfffffff850437812ULL, 0x000fe200078ee239ULL,
0x000000ffff4f7224ULL, 0x000fe200008e06ffULL, 0x000000093a3a7c11ULL, 0x000fe200080f3c33ULL,
0x000000103b097824ULL, 0x100fe200078e0240ULL, 0x00000008304d7c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff4b7224ULL, 0x000fe200010e06ffULL, 0x0000007038387812ULL, 0x000fe200078ec0ffULL,
0x0000001041397824ULL, 0x100fe200078e0240ULL, 0x00000009304f7c11ULL, 0x000fe200080f3c4fULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x0000003831307210ULL, 0x000fe20007f1e0ffULL,
0x0000001043437824ULL, 0x100fe200078e0240ULL, 0x00000008323b7c11ULL, 0x000fe2000f8238ffULL,
0x0000001049497824ULL, 0x000fe200078e0240ULL, 0x0000000842417c11ULL, 0x000fe2000f8438ffULL,
0x000000ffff317224ULL, 0x000fe200000e063aULL, 0x00000009324b7c11ULL, 0x000fc400088f3c4bULL,
0x000000384d327210ULL, 0x000fe40007f1e0ffULL, 0x0000000942427c11ULL, 0x000fe200090f3c33ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030097faeULL, 0x0003e2000b901c46ULL,
0x000000383b3a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e064fULL,
0x0000003841407210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e064bULL,
0x0000000032397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff417224ULL, 0x000fc600010e0642ULL,
0x000000003a437faeULL, 0x0003e8000b901c46ULL, 0x0000000040497faeULL, 0x0003e4000b901c46ULL,
0x0000000205307836ULL, 0x002fe40000000000ULL, 0xffffffffff097424ULL, 0x000fc600078e00ffULL,
0x000000353000720cULL, 0x000fda0003f06070ULL, 0x00008c00ff308b82ULL, 0x000e620000000a00ULL,
0x0000000208338810ULL, 0x000fe20007ffe005ULL, 0x0000000804327824ULL, 0x000fca00078e00ffULL,
0x0000000832327812ULL, 0x000fe200078ec0ffULL, 0x0000000433308825ULL, 0x002fc800078e0030ULL,
0x000000083c337824ULL, 0x000fe200078e00ffULL, 0x0000000630098981ULL, 0x000328000c1e1900ULL,
0xfffffff033337812ULL, 0x000fc800078ec0ffULL, 0x0000000d32507210ULL, 0x000fe20007ffe033ULL,
0x00000001ff327424ULL, 0x000fc600078e00ffULL, 0x00000000500572caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176a805057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x0176a832505479a7ULL, 0x0002a2000850003fULL, 0x01762832473079a7ULL, 0x0002e4000850003fULL,
0x0000000000327805ULL, 0x002fce0000015200ULL, 0x01762831470075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fce0000015200ULL, 0x0000003a323a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e33ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff397819ULL, 0x000fc8000001143bULL,
0x0000003a39397211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000239397819ULL, 0x000fc8000000123aULL, 0x000000390000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x01762831470075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000008038307810ULL, 0x000fe20007ffe046ULL, 0x00000001ff397424ULL, 0x000fe400078e00ffULL,
0x000000ffff537224ULL, 0x000fe400078e0056ULL, 0x0000000145307824ULL, 0x000fca00078e0230ULL,
0x0170000030317984ULL, 0x000e680000000800ULL, 0x0172000030327984ULL, 0x0006e20000000800ULL,
0x000000563100720bULL, 0x002fda0003f1d000ULL, 0x00000000003a7806ULL, 0x000fc800000e0100ULL,
0x0000ffff3aff7812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x000000010c337836ULL, 0x000fe20000000000ULL, 0x000000563100720bULL, 0x000fc80003f14000ULL,
0x0000003c3300720cULL, 0x000fd20003f25270ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x000000803c339824ULL, 0x000fe200078e020dULL, 0x0000005631309209ULL, 0x000fc80007810000ULL,
0x00000033453b9210ULL, 0x000fe40007ffe038ULL, 0x0000991039337816ULL, 0x000fc600000000ffULL,
0x017400303b009388ULL, 0x0003e20000000800ULL, 0x000000ff3300720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005631337209ULL, 0x000fe40007810000ULL,
0x000000ff39ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0039ff7812ULL, 0x000fe2000782c0ffULL,
0x0000005633307221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x0000003000387308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff337819ULL, 0x000fca000001160eULL, 0x00001f3338307589ULL, 0x006e6400000e0000ULL,
0x0000003028287220ULL, 0x082fe20000410000ULL, 0x0000003029297220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x0000003014147220ULL, 0x080fe20000410000ULL, 0x0000003015157220ULL, 0x080fe20000410000ULL,
0x0000003010107220ULL, 0x080fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x000000302c2c7220ULL, 0x080fe20000410000ULL, 0x000000302d2d7220ULL, 0x000fce0000410000ULL,
0x0000003807077220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x000000080e337811ULL, 0x000fca00078ff0ffULL, 0x00001f3338307589ULL, 0x002e6400000e0000ULL,
0x000000302a2a7220ULL, 0x082fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x0000003016167220ULL, 0x080fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x0000003012127220ULL, 0x080fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff39ff7812ULL, 0x000fe2000780083aULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000005631537209ULL, 0x000fd60007810000ULL, 0x8000005331310221ULL, 0x000fe20000010000ULL,
0x00007610ff390816ULL, 0x000fc60000000039ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100020308ULL, 0x000ea40000000800ULL, 0x0000000232320220ULL, 0x004fce0000410000ULL,
0x0000000732077221ULL, 0x000fce0000010000ULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x0176a8593e0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x0176a8593e0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991039307816ULL, 0x000fe200000000ffULL,
0x0000200034327824ULL, 0x000fe400078e020dULL, 0x0000000152317824ULL, 0x000fe200078e0251ULL,
0x000000ff3000720cULL, 0x000fe20003f05270ULL, 0x0000000852387824ULL, 0x000fe400078e00ffULL,
0x000010003f327824ULL, 0x000fc600078e0232ULL, 0xfffffff838307812ULL, 0x000fe200078ee231ULL,
0x0001300032577836ULL, 0x000fc80000000000ULL, 0x00000010304f7824ULL, 0x000fe400078e0257ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130007589ULL, 0x0002e400000e0000ULL, 0x011800004430783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000004f40783bULL, 0x000f620000004200ULL,
0x000000104e4d7824ULL, 0x000fca00078e0257ULL, 0x000000004d38783bULL, 0x000f640000004200ULL,
0x00000018ff627819ULL, 0x022fe20000011440ULL, 0x0000010040587824ULL, 0x040fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011441ULL, 0x0000010041597824ULL, 0x040fe200078e00ffULL,
0x0000888040667816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00008880416a7816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff567819ULL, 0x008fe40000011438ULL, 0x00008880385a7816ULL, 0x000fe200000000ffULL,
0x00000058006b7306ULL, 0x0003e20000202400ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff5c7819ULL, 0x000fe40000011443ULL, 0x0000888043657816ULL, 0x000fc400000000ffULL,
0x00000018ff547819ULL, 0x000fe20000011439ULL, 0x0000004000697306ULL, 0x0007e20000202400ULL,
0x0000010042587824ULL, 0x042fe200078e00ffULL, 0x0000888042647816ULL, 0x040fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe20000011442ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000041006d7306ULL, 0x0003e20000202400ULL,
0x0000010043407824ULL, 0x048fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc4000001143aULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x0000010038417824ULL, 0x042fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001143bULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x00000018ff387819ULL, 0x000fce0000011438ULL, 0x00000059006f7306ULL, 0x000e700000202400ULL,
0x0000005800677306ULL, 0x0007f00000202400ULL, 0x0000004000687306ULL, 0x000be20000202400ULL,
0x0000888039587816ULL, 0x008fce00000000ffULL, 0x00000038005b7306ULL, 0x0007e20000202400ULL,
0x0000010039407824ULL, 0x064fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000006000607306ULL, 0x000ea20000202400ULL,
0x000001003b387824ULL, 0x008fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc80000011439ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004300617306ULL, 0x000ff00000202400ULL,
0x0000003900597306ULL, 0x0003f00000202400ULL, 0x0000003800437306ULL, 0x0007e20000202400ULL,
0x000054106a397816ULL, 0x002fce000000006fULL, 0x0000006400647306ULL, 0x000e620000202400ULL,
0x0000541066387816ULL, 0x008fce000000006bULL, 0x0000006500657306ULL, 0x000ee20000202400ULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x0000541069387816ULL, 0x000fe20000000062ULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x000054106d397816ULL, 0x004fce0000000060ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x000000383024723cULL, 0x000fee0000041824ULL,
0x0000004200637306ULL, 0x0005620000202400ULL, 0x0000541064387816ULL, 0x002fe40000000067ULL,
0x0000541065397816ULL, 0x008fca0000000068ULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x000001003a427824ULL, 0x004fe200078e00ffULL, 0x000000383020723cULL, 0x000fe80000041820ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000041005d7306ULL, 0x0002a20000202400ULL,
0x0000541063387816ULL, 0x020fe4000000005eULL, 0x0000541061397816ULL, 0x000fca000000005cULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x000088803a417816ULL, 0x042fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000038301c723cULL, 0x000fe8000004181cULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x00000040005f7306ULL, 0x0002e40000202400ULL,
0x000054105a387816ULL, 0x004fcc000000005dULL, 0x0000005600567306ULL, 0x000ea20000202400ULL,
0x000088803b407816ULL, 0x042fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000005400547306ULL, 0x000e620000202400ULL,
0x0000541058397816ULL, 0x008fce000000005fULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x000000383018723cULL, 0x000fee0000041818ULL, 0x0000004b004b7306ULL, 0x000fe20000202400ULL,
0x000054105b387816ULL, 0x004fe40000000056ULL, 0x0000541059397816ULL, 0x002fca0000000054ULL,
0x0000004100417306ULL, 0x000fe40000202400ULL, 0x000000383014723cULL, 0x000fec0000041814ULL,
0x0000004200427306ULL, 0x000e700000202400ULL, 0x0000004000407306ULL, 0x000ea20000202400ULL,
0x0000541041387816ULL, 0x002fce0000000042ULL, 0x0000003a003a7306ULL, 0x000e620000202400ULL,
0x0000541040397816ULL, 0x004fce0000000043ULL, 0x0000003b00607306ULL, 0x000ea20000202400ULL,
0x000000383010723cULL, 0x000fe20000041810ULL, 0x000054103a3a7816ULL, 0x002fe40000000049ULL,
0x00005410603b7816ULL, 0x004fe2000000004bULL, 0x000000104c4b7824ULL, 0x000fcc00078e0257ULL,
0x0000003a302c723cULL, 0x000fe2000004182cULL, 0x011800003730783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000004b40783bULL, 0x000ee20000004200ULL, 0x000000104a497824ULL, 0x000fca00078e0257ULL,
0x000000004938783bULL, 0x000f620000004200ULL, 0x00000018ff657819ULL, 0x008fe20000011440ULL,
0x00000100405a7824ULL, 0x040fe200078e00ffULL, 0x0000888040677816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011441ULL,
0x00000100415b7824ULL, 0x040fe200078e00ffULL, 0x00008880416a7816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006700677306ULL, 0x000fe20000202400ULL, 0x00000018ff5a7819ULL, 0x000fc4000001145aULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff5f7819ULL, 0x000fe20000011443ULL, 0x00000040006c7306ULL, 0x0007e20000202400ULL,
0x0000888043647816ULL, 0x000fe400000000ffULL, 0x00000018ff597819ULL, 0x022fe40000011438ULL,
0x00000018ff587819ULL, 0x000fc40000011439ULL, 0x00008880385c7816ULL, 0x000fe200000000ffULL,
0x0000005a00687306ULL, 0x0003620000202400ULL, 0x0000010043407824ULL, 0x048fe200078e00ffULL,
0x0000888042667816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe40000011442ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x00000100425a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc4000001143aULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000005b006d7306ULL, 0x0002e20000202400ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff567819ULL, 0x000fca000001143bULL, 0x00000041006e7306ULL, 0x0007e20000202400ULL,
0x00008880395b7816ULL, 0x002fce00000000ffULL, 0x00000040006b7306ULL, 0x0003e20000202400ULL,
0x0000010038417824ULL, 0x04cfe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000006500657306ULL, 0x000ea20000202400ULL,
0x0000010039407824ULL, 0x042fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011440ULL,
0x0000006100617306ULL, 0x000e620000202400ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a407816ULL, 0x000fca00000000ffULL, 0x0000005a00697306ULL, 0x000ff00000202400ULL,
0x0000004300627306ULL, 0x000ff00000202400ULL, 0x00000038005a7306ULL, 0x000bf00000202400ULL,
0x0000003900437306ULL, 0x0007e20000202400ULL, 0x0000541067387816ULL, 0x020fe20000000068ULL,
0x000001003b677824ULL, 0x000fcc00078e00ffULL, 0x0000006600667306ULL, 0x000f620000202400ULL,
0x000054106a397816ULL, 0x008fce000000006dULL, 0x0000006400647306ULL, 0x000ee20000202400ULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x000054106c387816ULL, 0x004fe20000000065ULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x000054106e397816ULL, 0x002fc40000000061ULL,
0x00000018ff617819ULL, 0x000fca0000011467ULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x000000383024723cULL, 0x000fee0000041824ULL, 0x0000004200637306ULL, 0x0002a20000202400ULL,
0x0000541066387816ULL, 0x020fe40000000069ULL, 0x0000541064397816ULL, 0x008fca000000006bULL,
0x00000041005d7306ULL, 0x0007e20000202400ULL, 0x000088803b427816ULL, 0x042fe200000000ffULL,
0x000000383020723cULL, 0x000fe20000041820ULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x0000005c005c7306ULL, 0x000e620000202400ULL, 0x000001003a417824ULL, 0x048fe200078e00ffULL,
0x0000541063387816ULL, 0x004fe20000000060ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541062397816ULL, 0x000fe4000000005fULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x00000038301c723cULL, 0x000fe8000004181cULL,
0x0000005e005e7306ULL, 0x000ea60000202400ULL, 0x000054105c387816ULL, 0x002fe2000000005dULL,
0x00000001ff5c7424ULL, 0x000fc800078e00ffULL, 0x0000004000407306ULL, 0x000fe20000202400ULL,
0x000054105b397816ULL, 0x004fce000000005eULL, 0x0000004100417306ULL, 0x000fe20000202400ULL,
0x00000008345b7824ULL, 0x000fe200078e020dULL, 0x000000383018723cULL, 0x000fec0000041818ULL,
0x0000004200427306ULL, 0x000ff00000202400ULL, 0x0000006100617306ULL, 0x000ff00000202400ULL,
0x0000005900597306ULL, 0x000e700000202400ULL, 0x0000005800587306ULL, 0x000ea20000202400ULL,
0x000054105a387816ULL, 0x002fce0000000059ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541043397816ULL, 0x004fce0000000058ULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x000000383014723cULL, 0x000fee0000041814ULL, 0x0000003a00657306ULL, 0x0002a20000202400ULL,
0x0176c85c5b3879a7ULL, 0x0006ee000850003fULL, 0x0000003b005d7306ULL, 0x000aa20000202400ULL,
0x00005410403a7816ULL, 0x002fe20000000041ULL, 0x0176905c3dff79a7ULL, 0x0007e2000850003fULL,
0x00005410423b7816ULL, 0x020fce0000000061ULL, 0x0000003a3010723cULL, 0x000fee0000041810ULL,
0x00005410653a7816ULL, 0x004fe20000000054ULL, 0x0000000205547836ULL, 0x000fe20000000000ULL,
0x000054105d3b7816ULL, 0x000fce0000000056ULL, 0x0000003a302c723cULL, 0x000fee000004182cULL,
0x0000008006317811ULL, 0x000fe400078e40ffULL, 0x0000000104307812ULL, 0x000fe400078ec0ffULL,
0x000000363100720cULL, 0x000fda0003f06070ULL, 0x0000004400680947ULL, 0x008fea0003800000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x00000039480075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x00000039480075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000106307836ULL, 0x000fe20000000000ULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x000000103c327824ULL, 0x000fe400078e00ffULL, 0x0000000809097c24ULL, 0x010fe2000f8e02ffULL,
0x0000000f3000720cULL, 0x000fe40003f06070ULL, 0xffffffe032317812ULL, 0x000fe200078ec0ffULL,
0x0000004009097824ULL, 0x000fc800078e00ffULL, 0x0000010006317824ULL, 0x000fc800078e0231ULL,
0x000000c031317836ULL, 0x000fca0000000000ULL, 0x000000200a387812ULL, 0x000fe200078ef831ULL,
0x0000000400208947ULL, 0x000fec0003800000ULL, 0x0000003136307248ULL, 0x000fe20007fe0000ULL,
0x00008a0000087ab9ULL, 0x000fe20000000a00ULL, 0x0000001032337812ULL, 0x000fe400078ec0ffULL,
0x00000003ff327819ULL, 0x000fe2000001160eULL, 0x0000000130307824ULL, 0x000fc800078e0a31ULL,
0x0000000132317824ULL, 0x100fe200078e0233ULL, 0x0000003033307248ULL, 0x000fe20007fe0000ULL,
0x00000004323a7836ULL, 0x000fe40000000000ULL, 0x0000000131397824ULL, 0x040fe400078e020eULL,
0x0000000130307824ULL, 0x100fe400078e0a33ULL, 0x0000000831427824ULL, 0x040fe400078e00ffULL,
0x00000008323b7836ULL, 0x000fe20000000000ULL, 0x000000303200720cULL, 0x080fe20003f66070ULL,
0x0000000c32407836ULL, 0x000fe20000000000ULL, 0xfffffff842427812ULL, 0x000fe200078ee239ULL,
0x0000000131327824ULL, 0x000fe200078e0238ULL, 0x000000303b00720cULL, 0x0c0fe20003f26070ULL,
0x000000013a397824ULL, 0x140fe200078e0233ULL, 0x000000303a00720cULL, 0x080fe20003f46070ULL,
0x000000013b417824ULL, 0x000fe200078e0233ULL, 0x00000032093b7210ULL, 0x000fe20007f9e0ffULL,
0x0000000139317824ULL, 0x040fe200078e020eULL, 0x000000304000720cULL, 0x000fe20003f06070ULL,
0x0000000839567824ULL, 0x000fc400078e00ffULL, 0x000000ffff3a7224ULL, 0x000fe400020e06ffULL,
0x0000000140337824ULL, 0x000fe200078e0233ULL, 0xfffffff856567812ULL, 0x000fe200078ee231ULL,
0x0000000139307824ULL, 0x100fe200078e0238ULL, 0x000000083b317c11ULL, 0x000fe2000f8838ffULL,
0x0000000141327824ULL, 0x100fe400078e0238ULL, 0x0000000133387824ULL, 0x000fe200078e0238ULL,
0x000000093b3b7c11ULL, 0x000fe2000a0f3c3aULL, 0x000000100e407824ULL, 0x000fe200078e00ffULL,
0x0000003009307210ULL, 0x000fe20007f9e0ffULL, 0x0000000133397824ULL, 0x100fe200078e020eULL,
0x0000003209547210ULL, 0x000fe20007fbe0ffULL, 0x0000000141327824ULL, 0x040fe200078e020eULL,
0x0000003809387210ULL, 0x000fe20007fde0ffULL, 0x000000ffff097224ULL, 0x000fe200020e06ffULL,
0x00000008305b7c11ULL, 0x000fe2000f8838ffULL, 0x0000000841417824ULL, 0x000fe200078e00ffULL,
0x0000007040407812ULL, 0x000fe200078ec0ffULL, 0x0000000833587824ULL, 0x000fe200078e00ffULL,
0x00000009303a7c11ULL, 0x000fe2000a0f3c09ULL, 0x000000ffff597224ULL, 0x000fe200028e06ffULL,
0xfffffff841327812ULL, 0x000fe200078ee232ULL, 0x000000ffff337224ULL, 0x000fe200030e06ffULL,
0x0000004031307210ULL, 0x000fe20007f9e0ffULL, 0x0000001042097824ULL, 0x100fe200078e0257ULL,
0xfffffff858587812ULL, 0x000fe200078ee239ULL, 0x0000001032437824ULL, 0x000fe200078e0257ULL,
0x0000000854397c11ULL, 0x000fe2000f8a38ffULL, 0x000000ffff317224ULL, 0x000fe200020e063bULL,
0x00000008383b7c11ULL, 0x000fe2000f8c38ffULL, 0x0000001056417824ULL, 0x100fe200078e0257ULL,
0x000000405b327210ULL, 0x000fe20007f9e0ffULL, 0x0000001058577824ULL, 0x000fe200078e0257ULL,
0x0000000954547c11ULL, 0x000fe2000a8f3c59ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030097faeULL, 0x0003e2000d901c46ULL, 0x0000000938427c11ULL, 0x000fe2000b0f3c33ULL,
0x000000ffff337224ULL, 0x000fe200020e063aULL, 0x0000004039387210ULL, 0x000fc40007fbe0ffULL,
0x000000403b3a7210ULL, 0x000fe40007f9e0ffULL, 0x0000000032417faeULL, 0x0003e2000d101c46ULL,
0x000000ffff397224ULL, 0x000fe400028e0654ULL, 0x000000ffff3b7224ULL, 0x000fc600020e0642ULL,
0x0000000038437faeULL, 0x0003e8000c901c46ULL, 0x000000003a577faeULL, 0x0003e2000c101c46ULL,
0x0000000000ec7947ULL, 0x000fea0003800000ULL, 0x0000001032317812ULL, 0x000fe200078ec0ffULL,
0x00008a0000087ab9ULL, 0x000fe20000000a00ULL, 0x000000100e407824ULL, 0x040fe400078e00ffULL,
0x000000310e317211ULL, 0x000fc600078fe8ffULL, 0x0000007040407812ULL, 0x000fe400078ec0ffULL,
0x0000000131307824ULL, 0x040fe400078e020eULL, 0x0000000831397824ULL, 0x000fe400078e00ffULL,
0x0000000431337836ULL, 0x000fc60000000000ULL, 0xfffffff839427812ULL, 0x000fe200078ee230ULL,
0x0000000131307824ULL, 0x000fe400078e0238ULL, 0x0000000133327824ULL, 0x040fe400078e020eULL,
0x00000008333b7824ULL, 0x040fe200078e00ffULL, 0x00000030093a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000831397836ULL, 0x000fe40000000000ULL, 0x0000000c31317836ULL, 0x000fe20000000000ULL,
0xfffffff83b547812ULL, 0x000fe200078ee232ULL, 0x0000000133307824ULL, 0x000fc400078e0238ULL,
0x0000000139327824ULL, 0x040fe400078e0238ULL, 0x00000001393b7824ULL, 0x040fe200078e020eULL,
0x0000003009307210ULL, 0x000fe20007f3e0ffULL, 0x0000000839567824ULL, 0x000fe200078e00ffULL,
0x0000003209327210ULL, 0x000fe20007f5e0ffULL, 0x0000000131387824ULL, 0x040fe400078e0238ULL,
0x0000000131397824ULL, 0x040fe200078e020eULL, 0xfffffff856567812ULL, 0x000fe200078ee23bULL,
0x0000000831587824ULL, 0x000fe200078e00ffULL, 0x0000003809387210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x000000083a337c11ULL, 0x000fe2000f8038ffULL,
0x0000001056437824ULL, 0x100fe200078e0257ULL, 0xfffffff858587812ULL, 0x000fe200078ee239ULL,
0x0000001054417824ULL, 0x000fe200078e0257ULL, 0x000000093a3a7c11ULL, 0x000fe200080f3c31ULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x0000000830597c11ULL, 0x000fe2000f8038ffULL,
0x0000001042097824ULL, 0x100fe200078e0257ULL, 0x0000000832397c11ULL, 0x000fe2000f8238ffULL,
0x0000001058577824ULL, 0x000fe200078e0257ULL, 0x0000000930567c11ULL, 0x000fe200080f3c31ULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x0000004033307210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x00000008383b7c11ULL, 0x000fc4000f8438ffULL,
0x0000000932547c11ULL, 0x000fe200088f3c31ULL, 0x000000ffff317224ULL, 0x000fe200000e063aULL,
0x0000004059327210ULL, 0x000fe40007f1e0ffULL, 0x0000000938427c11ULL, 0x000fe400090f3c33ULL,
0x0000004039387210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0656ULL,
0x000000403b3a7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030097faeULL, 0x0003e4000b901c46ULL, 0x000000ffff397224ULL, 0x000fc400008e0654ULL,
0x000000ffff3b7224ULL, 0x000fe200010e0642ULL, 0x0000000032417faeULL, 0x0003e8000b901c46ULL,
0x0000000038437faeULL, 0x0003e8000b901c46ULL, 0x000000003a577faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000305327836ULL, 0x000fe40000000000ULL,
0x00000001ff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x000000353200720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00008c00ff307b82ULL, 0x000e620000000a00ULL, 0x0000000108097824ULL, 0x000fc800078e0232ULL,
0x0000000409307825ULL, 0x002fca00078e0030ULL, 0x0000000630097981ULL, 0x000324000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0176a8333e5879a7ULL, 0x0004e2000850003fULL, 0x01764833473079a7ULL, 0x002464000850003fULL,
0x0000000000327805ULL, 0x004fce0000015200ULL, 0x01764831470075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x00000038323b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e33ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01764831470075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000010040307810ULL, 0x000fe20007ffe046ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0x000000ffff567224ULL, 0x000fe400078e0053ULL, 0x0000000145307824ULL, 0x000fca00078e0230ULL,
0x0170000030327984ULL, 0x000e680000000800ULL, 0x0172000030317984ULL, 0x0004a20000000800ULL,
0x000000533200720bULL, 0x002fda0003f1d000ULL, 0x0000000000397806ULL, 0x000fc800000e0100ULL,
0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x000000020c337836ULL, 0x000fe20000000000ULL, 0x000000533200720bULL, 0x000fc80003f14000ULL,
0x0000003c3300720cULL, 0x000fd20003f25270ULL, 0x0000000000387806ULL, 0x000fc800000e0100ULL,
0x000000803c339824ULL, 0x000fe200078e020dULL, 0x0000003253309209ULL, 0x000fc80007810000ULL,
0x00000033453b9210ULL, 0x000fe40007ffe040ULL, 0x0000991038337816ULL, 0x000fc600000000ffULL,
0x017400303b009388ULL, 0x0003e20000000800ULL, 0x000000ff3300720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000003253307209ULL, 0x040fe40007810000ULL,
0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL,
0x8000003053307221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x00000030003a7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff337819ULL, 0x000fca000001160eULL, 0x00001f333a307589ULL, 0x006e6400000e0000ULL,
0x0000003028287220ULL, 0x082fe20000410000ULL, 0x0000003029297220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x0000003014147220ULL, 0x080fe20000410000ULL, 0x0000003015157220ULL, 0x080fe20000410000ULL,
0x0000003010107220ULL, 0x080fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x000000302c2c7220ULL, 0x080fe20000410000ULL, 0x000000302d2d7220ULL, 0x000fce0000410000ULL,
0x0000003a07077220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x000000080e337811ULL, 0x000fca00078ff0ffULL, 0x00001f333a307589ULL, 0x002e6400000e0000ULL,
0x000000302a2a7220ULL, 0x082fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x0000003016167220ULL, 0x080fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x0000003012127220ULL, 0x080fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff38ff7812ULL, 0x000fe20007800839ULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x0000003253567209ULL, 0x000fd60007810000ULL, 0x8000005632320221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b32320820ULL, 0x000fc80000410000ULL,
0x0000003200020308ULL, 0x000ea40000000800ULL, 0x0000000231310220ULL, 0x004fce0000410000ULL,
0x0000000731077221ULL, 0x000fce0000010000ULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x0176a855500075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0176a855500075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991038307816ULL, 0x000fe200000000ffULL,
0x0000100004327824ULL, 0x000fe400078e00ffULL, 0x0000000152517824ULL, 0x000fe200078e0251ULL,
0x000000ff3000720cULL, 0x000fe20003f05270ULL, 0x0000000852407824ULL, 0x000fe200078e00ffULL,
0x0000100032327812ULL, 0x000fe200078ec0ffULL, 0x0000200034317824ULL, 0x000fc600078e020dULL,
0xfffffff840407812ULL, 0x000fe400078ee251ULL, 0x0001300031517810ULL, 0x000fca0007ffe032ULL,
0x0000001040407824ULL, 0x000fe200078e0251ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160eULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x012000004430783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x000000104e387824ULL, 0x000fcc00078e0251ULL,
0x000000003838783bULL, 0x000f640000004200ULL, 0x00000018ff637819ULL, 0x022fe20000011440ULL,
0x0000010040557824ULL, 0x040fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011441ULL,
0x0000010041577824ULL, 0x040fe200078e00ffULL, 0x0000888040667816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x0000888041697816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff547819ULL, 0x008fe40000011438ULL,
0x00008880385b7816ULL, 0x000fe200000000ffULL, 0x00000055006b7306ULL, 0x0003e20000202400ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff5d7819ULL, 0x000fe40000011443ULL,
0x0000888043657816ULL, 0x000fc400000000ffULL, 0x00000018ff537819ULL, 0x000fe20000011439ULL,
0x00000040006a7306ULL, 0x0007e20000202400ULL, 0x0000010042557824ULL, 0x042fe200078e00ffULL,
0x0000888042647816ULL, 0x040fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011442ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000041006c7306ULL, 0x0003e20000202400ULL, 0x0000010043407824ULL, 0x048fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc4000001143aULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000010038417824ULL, 0x042fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe4000001143bULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fce0000011438ULL,
0x00000057006e7306ULL, 0x0002f00000202400ULL, 0x0000005500677306ULL, 0x000fe20000202400ULL,
0x0000888039577816ULL, 0x002fce00000000ffULL, 0x0000004000687306ULL, 0x0003f00000202400ULL,
0x0000003800557306ULL, 0x000be20000202400ULL, 0x0000010039407824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011440ULL,
0x0000006100617306ULL, 0x000e620000202400ULL, 0x000001003b387824ULL, 0x024fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a407816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004300607306ULL, 0x000ff00000202400ULL,
0x00000039005a7306ULL, 0x0007f00000202400ULL, 0x0000003800437306ULL, 0x0005e20000202400ULL,
0x0000541069397816ULL, 0x008fce000000006eULL, 0x0000006400647306ULL, 0x000ee20000202400ULL,
0x0000541066387816ULL, 0x004fe2000000006bULL, 0x000100003b667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000006500657306ULL, 0x000ea20000202400ULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x000054106a387816ULL, 0x000fe20000000063ULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x000054106c397816ULL, 0x002fce0000000061ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x000000383024723cULL, 0x000fee0000041824ULL,
0x0000004200627306ULL, 0x0003620000202400ULL, 0x0000541064387816ULL, 0x008fe40000000067ULL,
0x0000541065397816ULL, 0x004fca0000000068ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000088803b427816ULL, 0x002fe200000000ffULL, 0x000000383020723cULL, 0x000fec0000041820ULL,
0x00000041005c7306ULL, 0x0002a20000202400ULL, 0x0000541062387816ULL, 0x020fe4000000005fULL,
0x0000541060397816ULL, 0x000fca000000005dULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x000001003a417824ULL, 0x042fe200078e00ffULL, 0x00000038301c723cULL, 0x000fe2000004181cULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000054105b387816ULL, 0x004fca000000005cULL, 0x0000005400547306ULL, 0x000ea20000202400ULL,
0x0000541057397816ULL, 0x002fce000000005eULL, 0x0000005300537306ULL, 0x000e620000202400ULL,
0x000000383018723cULL, 0x000fee0000041818ULL, 0x0000004000407306ULL, 0x000fe20000202400ULL,
0x0000541055387816ULL, 0x004fe40000000054ULL, 0x000054105a397816ULL, 0x002fca0000000053ULL,
0x0000004100417306ULL, 0x000e640000202400ULL, 0x000000383014723cULL, 0x000fec0000041814ULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x0000541040407816ULL, 0x002fce0000000041ULL,
0x0000005200527306ULL, 0x000ff00000202400ULL, 0x0000004200427306ULL, 0x000e700000202400ULL,
0x0000003a003b7306ULL, 0x000ea20000202400ULL, 0x0000541042417816ULL, 0x002fce0000000043ULL,
0x0000006600617306ULL, 0x000e620000202400ULL, 0x000000403010723cULL, 0x000fe20000041810ULL,
0x000054103b387816ULL, 0x004fcc000000004eULL, 0x000000104c407824ULL, 0x000fe200078e0251ULL,
0x0000541061397816ULL, 0x002fce0000000052ULL, 0x00000038302c723cULL, 0x000fe2000004182cULL,
0x012000003730783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0x000000104a387824ULL, 0x000fcc00078e0251ULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x00000018ff617819ULL, 0x008fe20000011440ULL, 0x0000010040537824ULL, 0x040fe200078e00ffULL,
0x0000888040557816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011441ULL, 0x0000010041547824ULL, 0x040fe200078e00ffULL,
0x0000888041657816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x000001003b6b7824ULL, 0x022fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff5c7819ULL, 0x000fe20000011443ULL, 0x0000004000687306ULL, 0x0003e20000202400ULL,
0x0000888043647816ULL, 0x040fe400000000ffULL, 0x00000018ff527819ULL, 0x000fe40000011438ULL,
0x00000018ff4e7819ULL, 0x000fe40000011439ULL, 0x0000888038577816ULL, 0x000fe200000000ffULL,
0x0000005300667306ULL, 0x0007620000202400ULL, 0x0000010043407824ULL, 0x042fe200078e00ffULL,
0x0000888042627816ULL, 0x000fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fc40000011442ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x0000010042537824ULL, 0x048fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001143aULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x00000054006a7306ULL, 0x0002e20000202400ULL, 0x00000018ff427819ULL, 0x000fc40000011442ULL,
0x00000018ff4c7819ULL, 0x000fca000001143bULL, 0x0000004100677306ULL, 0x0007e20000202400ULL,
0x0000888039547816ULL, 0x002fce00000000ffULL, 0x0000004000697306ULL, 0x0003e20000202400ULL,
0x0000010038417824ULL, 0x04cfe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000006100617306ULL, 0x000ea20000202400ULL,
0x0000010039407824ULL, 0x042fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011440ULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a407816ULL, 0x000fca00000000ffULL, 0x0000005300637306ULL, 0x000ff00000202400ULL,
0x00000043005f7306ULL, 0x000ff00000202400ULL, 0x0000003800537306ULL, 0x000bf00000202400ULL,
0x0000003900437306ULL, 0x0007e20000202400ULL, 0x0000541055387816ULL, 0x020fc40000000066ULL,
0x00000018ff557819ULL, 0x000fca000001146bULL, 0x0000006200627306ULL, 0x000f620000202400ULL,
0x0000541065397816ULL, 0x008fce000000006aULL, 0x0000006400647306ULL, 0x000ee20000202400ULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x0000541068387816ULL, 0x004fe20000000061ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x0000541067397816ULL, 0x002fce0000000060ULL,
0x00000042005e7306ULL, 0x0002a20000202400ULL, 0x000000383024723cULL, 0x000fee0000041824ULL,
0x00000041005a7306ULL, 0x0005e20000202400ULL, 0x000088803b427816ULL, 0x042fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x0000541062387816ULL, 0x020fc40000000063ULL,
0x0000541064397816ULL, 0x008fe40000000069ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005c005c7306ULL, 0x000e620000202400ULL, 0x000001003a417824ULL, 0x044fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000000383020723cULL, 0x000fe40000041820ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000005200527306ULL, 0x000fe20000202400ULL,
0x00000018ff3a7819ULL, 0x000fc4000001143aULL, 0x000054105e387816ULL, 0x000fe2000000005dULL,
0x00000001ff5e7424ULL, 0x000fe200078e00ffULL, 0x000054105f397816ULL, 0x002fc6000000005cULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x00000008345c7824ULL, 0x000fc600078e020dULL,
0x00000038301c723cULL, 0x000fe8000004181cULL, 0x0000004000407306ULL, 0x000ff00000202400ULL,
0x0000004100417306ULL, 0x000e700000202400ULL, 0x0000004a004a7306ULL, 0x000fe20000202400ULL,
0x0000541040407816ULL, 0x002fce0000000041ULL, 0x0000004c004c7306ULL, 0x000ff00000202400ULL,
0x0000005700577306ULL, 0x000e700000202400ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541057387816ULL, 0x002fce000000005aULL, 0x0000005b005b7306ULL, 0x000e700000202400ULL,
0x0000004200427306ULL, 0x000fe20000202400ULL, 0x0000541054397816ULL, 0x002fce000000005bULL,
0x0000005500557306ULL, 0x000e620000202400ULL, 0x0000000305547836ULL, 0x000fe20000000000ULL,
0x000000383018723cULL, 0x000fec0000041818ULL, 0x0000003a00617306ULL, 0x0004e20000202400ULL,
0x0176c85e5c3879a7ULL, 0x000b62000850003fULL, 0x0000541042417816ULL, 0x002fcc0000000055ULL,
0x0000003b005d7306ULL, 0x0002e20000202400ULL, 0x00005410533a7816ULL, 0x004fe20000000052ULL,
0x0176985e3dff79a7ULL, 0x000be2000850003fULL, 0x000000ffff537224ULL, 0x000fe400078e0056ULL,
0x000000ffff557224ULL, 0x000fe200078e0059ULL, 0x000000403010723cULL, 0x000fe20000041810ULL,
0x00005410433b7816ULL, 0x002fce000000004eULL, 0x0000003a3014723cULL, 0x000fee0000041814ULL,
0x00005410613a7816ULL, 0x008fe4000000004aULL, 0x000054105d3b7816ULL, 0x000fce000000004cULL,
0x0000003a302c723cULL, 0x000fee000004182cULL, 0x000000c006317811ULL, 0x000fe200078e40ffULL,
0x000000ffff307224ULL, 0x000fc600078e003fULL, 0x000000363100720cULL, 0x000fda0003f06070ULL,
0x0000002000940947ULL, 0x020fea0003800000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x00000039480075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x00000039480075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000206327836ULL, 0x000fe20000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000010006307824ULL, 0x000fe400078e020bULL,
0x0000000409097c24ULL, 0x010fe2000f8e02ffULL, 0x0000000f3200720cULL, 0x000fe20003f06070ULL,
0x0000010030317836ULL, 0x000fe40000000000ULL, 0x0000004009097824ULL, 0x000fc600078e00ffULL,
0x000000200a387812ULL, 0x000fce00078ef831ULL, 0x0000000400248947ULL, 0x000fea0003800000ULL,
0x0000003136307248ULL, 0x000fe20007fe0000ULL, 0x000000103c327824ULL, 0x000fe200078e00ffULL,
0x00008a0000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000130307824ULL, 0x000fe200078e0a31ULL,
0x0000001032317812ULL, 0x000fe400078ec0ffULL, 0x00000003ff327819ULL, 0x000fe4000001160eULL,
0x0000003031307248ULL, 0x000fc60007fe0000ULL, 0x0000000132337824ULL, 0x100fe400078e0231ULL,
0x0000000130307824ULL, 0x100fe400078e0a31ULL, 0x0000000432397836ULL, 0x000fe40000000000ULL,
0x00000008323a7836ULL, 0x000fe20000000000ULL, 0x000000303200720cULL, 0x080fe20003f66070ULL,
0x0000000c32407836ULL, 0x000fe20000000000ULL, 0x000000303900720cULL, 0x080fe20003f46070ULL,
0x0000000133327824ULL, 0x000fe200078e0238ULL, 0x000000303a00720cULL, 0x000fe20003f26070ULL,
0x0000000139397824ULL, 0x000fc400078e0231ULL, 0x000000013a3f7824ULL, 0x100fe200078e0231ULL,
0x0000003209327210ULL, 0x000fe20007f1e0ffULL, 0x0000000140437824ULL, 0x000fe400078e0231ULL,
0x0000000133317824ULL, 0x040fe400078e020eULL, 0x00000008333a7824ULL, 0x000fe200078e00ffULL,
0x0000000832337c11ULL, 0x000fe2000f8838ffULL, 0x000000ffff417224ULL, 0x000fe200000e06ffULL,
0x000000304000720cULL, 0x000fe20003f06070ULL, 0x0000000139307824ULL, 0x040fe200078e0238ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee231ULL, 0x00000001393b7824ULL, 0x040fe200078e020eULL,
0x0000000932417c11ULL, 0x000fe2000a0f3c41ULL, 0x0000000839427824ULL, 0x000fe200078e00ffULL,
0x0000003009307210ULL, 0x000fe20007fbe0ffULL, 0x000000013f327824ULL, 0x000fc400078e0238ULL,
0x0000000143387824ULL, 0x000fe200078e0238ULL, 0xfffffff842407812ULL, 0x000fe200078ee23bULL,
0x000000100e317824ULL, 0x000fe400078e00ffULL, 0x000000013f397824ULL, 0x140fe200078e020eULL,
0x0000003809427210ULL, 0x000fe20007fde0ffULL, 0x000000083f487824ULL, 0x000fe200078e00ffULL,
0x0000007031387812ULL, 0x000fe200078ec0ffULL, 0x00000001433b7824ULL, 0x040fe400078e020eULL,
0x00000008434a7824ULL, 0x000fe200078e00ffULL, 0x0000003209437210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e06ffULL, 0xfffffff848327812ULL, 0x000fe200078ee239ULL,
0x0000001040397824ULL, 0x100fe200078e0251ULL, 0x0000000830537c11ULL, 0x000fe2000f8a38ffULL,
0x000000103a097824ULL, 0x100fe200078e0251ULL, 0xfffffff84a487812ULL, 0x000fe200078ee23bULL,
0x00000010323f7824ULL, 0x000fe200078e0251ULL, 0x0000000930407c11ULL, 0x000fe2000a8f3c31ULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000003833327210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff317224ULL, 0x000fe200030e06ffULL, 0x00000008433b7c11ULL, 0x000fe2000f8838ffULL,
0x0000001048517824ULL, 0x000fc400078e0251ULL, 0x000000ffff337224ULL, 0x000fe200028e0641ULL,
0x0000000842417c11ULL, 0x040fe4000f8c38ffULL, 0x0000003853307210ULL, 0x000fe40007fbe0ffULL,
0x0000000943437c11ULL, 0x000fe2000a0f3c3aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032097faeULL, 0x0003e2000d901c46ULL, 0x0000000942427c11ULL, 0x000fe2000b0f3c31ULL,
0x000000ffff317224ULL, 0x000fe200028e0640ULL, 0x000000383b3a7210ULL, 0x000fe40007f9e0ffULL,
0x0000003841407210ULL, 0x000fc40007fbe0ffULL, 0x0000000030397faeULL, 0x0003e2000d101c46ULL,
0x000000ffff3b7224ULL, 0x000fe400020e0643ULL, 0x000000ffff417224ULL, 0x000fc600028e0642ULL,
0x000000003a3f7faeULL, 0x0003e8000c901c46ULL, 0x0000000040517faeULL, 0x0003e2000c101c46ULL,
0x0000000000f07947ULL, 0x000fea0003800000ULL, 0x000000103c307824ULL, 0x000fe200078e00ffULL,
0x00008a0000087ab9ULL, 0x000fc80000000a00ULL, 0x0000001030317812ULL, 0x000fc800078ec0ffULL,
0x000000310e317211ULL, 0x000fca00078fe8ffULL, 0x0000000131307824ULL, 0x040fe400078e020eULL,
0x0000000831397824ULL, 0x000fe400078e00ffULL, 0x0000000431337836ULL, 0x000fc60000000000ULL,
0xfffffff839407812ULL, 0x000fe200078ee230ULL, 0x0000000133327824ULL, 0x040fe400078e020eULL,
0x00000008333b7824ULL, 0x000fe400078e00ffULL, 0x0000000131307824ULL, 0x100fe400078e0238ULL,
0x0000000831397836ULL, 0x000fe20000000000ULL, 0xfffffff83b487812ULL, 0x000fe200078ee232ULL,
0x0000000c31317836ULL, 0x000fe20000000000ULL, 0x00000030093a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000133307824ULL, 0x000fc400078e0238ULL, 0x0000000139327824ULL, 0x100fe400078e0238ULL,
0x0000000131387824ULL, 0x000fe200078e0238ULL, 0x0000003009307210ULL, 0x000fe20007f3e0ffULL,
0x00000001393b7824ULL, 0x140fe200078e020eULL, 0x0000003209327210ULL, 0x000fe20007f5e0ffULL,
0x00000008394a7824ULL, 0x000fe200078e00ffULL, 0x0000003809427210ULL, 0x000fe20007f7e0ffULL,
0x0000000131397824ULL, 0x040fe400078e020eULL, 0x00000008314c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee23bULL, 0x000000ffff317224ULL, 0x000fe200000e06ffULL,
0x000000083a337c11ULL, 0x000fe2000f8038ffULL, 0x000000100e387824ULL, 0x000fe200078e00ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee239ULL, 0x0000001048397824ULL, 0x000fe200078e0251ULL,
0x000000093a3a7c11ULL, 0x000fe200080f3c31ULL, 0x000000ffff317224ULL, 0x000fe200008e06ffULL,
0x0000000830537c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff437224ULL, 0x000fe200010e06ffULL,
0x0000007038387812ULL, 0x000fe200078ec0ffULL, 0x0000001040097824ULL, 0x000fe200078e0251ULL,
0x0000000930487c11ULL, 0x000fe200080f3c31ULL, 0x000000104a3f7824ULL, 0x100fe200078e0251ULL,
0x0000003833307210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x00000008323b7c11ULL, 0x000fe2000f8238ffULL, 0x000000104c517824ULL, 0x000fe200078e0251ULL,
0x0000000842417c11ULL, 0x000fe2000f8438ffULL, 0x000000ffff317224ULL, 0x000fe200000e063aULL,
0x0000000932437c11ULL, 0x000fc400088f3c43ULL, 0x0000003853327210ULL, 0x000fe40007f1e0ffULL,
0x0000000942427c11ULL, 0x000fe200090f3c33ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030097faeULL, 0x0003e2000b901c46ULL, 0x000000383b3a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e0648ULL, 0x0000003841407210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200008e0643ULL, 0x0000000032397faeULL, 0x0003e2000b901c46ULL,
0x000000ffff417224ULL, 0x000fc600010e0642ULL, 0x000000003a3f7faeULL, 0x0003e8000b901c46ULL,
0x0000000040517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000405327836ULL, 0x000fe40000000000ULL, 0x00000001ff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x000000353200720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00008c00ff307b82ULL, 0x000e620000000a00ULL,
0x0000000108097824ULL, 0x000fc800078e0232ULL, 0x0000000409307825ULL, 0x002fca00078e0030ULL,
0x0000000630097981ULL, 0x000324000c1e1900ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0176a83a505479a7ULL, 0x0004e4000850003fULL,
0x0176683a473a79a7ULL, 0x004464000850003fULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x0176683b470075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3f7224ULL, 0x000fce00078e00ffULL, 0x000000103f00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013f3f7836ULL, 0x000fce0000000000ULL, 0x0176683b470075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000018038467810ULL, 0x000fe20007ffe046ULL,
0x00000001ff397424ULL, 0x000fe400078e00ffULL, 0x000000ffff537224ULL, 0x000fe400078e0056ULL,
0x0000000145467824ULL, 0x000fca00078e0246ULL, 0x0170000046317984ULL, 0x000e680000000800ULL,
0x0172000046307984ULL, 0x000b620000000800ULL, 0x000000563100720bULL, 0x002fda0003f1d000ULL,
0x00000000003a7806ULL, 0x000fc800000e0100ULL, 0x0000ffff3aff7812ULL, 0x000fda000780c0ffULL,
0x0000000000f88947ULL, 0x02cfea0003800000ULL, 0x000000030c337836ULL, 0x000fe20000000000ULL,
0x000000563100720bULL, 0x0c0fe40003f14000ULL, 0x0000005631537209ULL, 0x000fe40007810000ULL,
0x0000003c3300720cULL, 0x000fd20003f25270ULL, 0x0000000000337806ULL, 0x000fc800000e0100ULL,
0x000000803c329824ULL, 0x000fca00078e020dULL, 0x0000003245389210ULL, 0x000fe40007ffe038ULL,
0x0000991033327816ULL, 0x000fc600000000ffULL, 0x0174005338009388ULL, 0x0003e20000000800ULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000005653327221ULL, 0x000fe20000010100ULL, 0x000000ff33ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0033ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b32327820ULL, 0x000fc80000410000ULL,
0x0000003200387308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff397819ULL, 0x000fca000001160eULL, 0x00001f3938327589ULL, 0x006e6400000e0000ULL,
0x0000003228287220ULL, 0x082fe20000410000ULL, 0x0000003229297220ULL, 0x080fe20000410000ULL,
0x0000003224247220ULL, 0x080fe20000410000ULL, 0x0000003225257220ULL, 0x080fe20000410000ULL,
0x0000003220207220ULL, 0x080fe20000410000ULL, 0x0000003221217220ULL, 0x080fe20000410000ULL,
0x000000321c1c7220ULL, 0x080fe20000410000ULL, 0x000000321d1d7220ULL, 0x080fe20000410000ULL,
0x0000003218187220ULL, 0x080fe20000410000ULL, 0x0000003219197220ULL, 0x080fe20000410000ULL,
0x0000003214147220ULL, 0x080fe20000410000ULL, 0x0000003215157220ULL, 0x080fe20000410000ULL,
0x0000003210107220ULL, 0x080fe20000410000ULL, 0x0000003211117220ULL, 0x080fe20000410000ULL,
0x000000322c2c7220ULL, 0x080fe20000410000ULL, 0x000000322d2d7220ULL, 0x000fce0000410000ULL,
0x0000003807077220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x000000080e397811ULL, 0x000fca00078ff0ffULL, 0x00001f3938327589ULL, 0x002e6400000e0000ULL,
0x000000322a2a7220ULL, 0x082fe20000410000ULL, 0x000000322b2b7220ULL, 0x080fe20000410000ULL,
0x0000003226267220ULL, 0x080fe20000410000ULL, 0x0000003227277220ULL, 0x080fe20000410000ULL,
0x0000003222227220ULL, 0x080fe20000410000ULL, 0x0000003223237220ULL, 0x080fe20000410000ULL,
0x000000321e1e7220ULL, 0x080fe20000410000ULL, 0x000000321f1f7220ULL, 0x080fe20000410000ULL,
0x000000321a1a7220ULL, 0x080fe20000410000ULL, 0x000000321b1b7220ULL, 0x080fe20000410000ULL,
0x0000003216167220ULL, 0x080fe20000410000ULL, 0x0000003217177220ULL, 0x080fe20000410000ULL,
0x0000003212127220ULL, 0x080fe20000410000ULL, 0x0000003213137220ULL, 0x080fe20000410000ULL,
0x000000322e2e7220ULL, 0x080fe20000410000ULL, 0x000000322f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff33ff7812ULL, 0x000fe2000780083aULL, 0x00000001ff397424ULL, 0x000fd800078e00ffULL,
0x0000003153310221ULL, 0x000fe20000010100ULL, 0x00007610ff390816ULL, 0x000fc60000000039ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100020308ULL, 0x000ea40000000800ULL,
0x0000000230300220ULL, 0x004fce0000410000ULL, 0x0000000730077221ULL, 0x000fce0000010000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x0176a8593e0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x002fce0000015200ULL, 0x00000032303b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003b32327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0176a8593e0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000991039307816ULL, 0x000fc800000000ffULL, 0x000000ff3000720cULL, 0x000fda0003f05270ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0004e800000e0000ULL,
0x00001f3130007589ULL, 0x00046400000e0000ULL, 0x012800004430783bULL, 0x0062a20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000004f40783bULL, 0x000f680000004200ULL,
0x000000004d38783bULL, 0x000b640000004200ULL, 0x00000018ff4a7819ULL, 0x022fe20000011441ULL,
0x00000100414d7824ULL, 0x048fe200078e00ffULL, 0x0000888041547816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011440ULL,
0x00000100404c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x00000100424f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00008880404e7816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x004fc40000011438ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000004d00637306ULL, 0x0003e20000202400ULL, 0x00000018ff517819ULL, 0x000fe4000001144fULL,
0x00000018ff477819ULL, 0x000fe40000011443ULL, 0x00008880434f7816ULL, 0x000fe400000000ffULL,
0x00000018ff467819ULL, 0x000fe20000011442ULL, 0x00000041005f7306ULL, 0x0005e20000202400ULL,
0x00008880384d7816ULL, 0x002fc400000000ffULL, 0x00000018ff457819ULL, 0x000fe40000011439ULL,
0x0000888039527816ULL, 0x000fe400000000ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143aULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x0000010038417824ULL, 0x044fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143bULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004c005d7306ULL, 0x0002a20000202400ULL,
0x00000018ff387819ULL, 0x000fce0000011438ULL, 0x0000004000577306ULL, 0x0007e20000202400ULL,
0x00008880424c7816ULL, 0x042fe200000000ffULL, 0x0001000042427824ULL, 0x000fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x00000038005b7306ULL, 0x0003e20000202400ULL,
0x0000010043407824ULL, 0x048fe400078e00ffULL, 0x0001000043437824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x000001003b387824ULL, 0x002fe200078e00ffULL, 0x00000040005a7306ULL, 0x0003e80000202400ULL,
0x00000018ff387819ULL, 0x000fc80000011438ULL, 0x0000004300567306ULL, 0x000fe20000202400ULL,
0x0000010039407824ULL, 0x042fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000004200597306ULL, 0x0003e20000202400ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000003800437306ULL, 0x0005e20000202400ULL,
0x000001003a427824ULL, 0x002fca00078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011442ULL,
0x0000004100507306ULL, 0x0003e20000202400ULL, 0x000054104e387816ULL, 0x004fe2000000005dULL,
0x000100003b4e7824ULL, 0x040fe200078e00ffULL, 0x000088803b427816ULL, 0x000fc800000000ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000004800487306ULL, 0x000ea20000202400ULL,
0x000088803a417816ULL, 0x042fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000004a004a7306ULL, 0x000e700000202400ULL,
0x0000003900587306ULL, 0x0007f00000202400ULL, 0x0000004000617306ULL, 0x000fe20000202400ULL,
0x0000541054397816ULL, 0x008fce0000000063ULL, 0x0000004c004c7306ULL, 0x000fe20000202400ULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x0000005100517306ULL, 0x000ee20000202400ULL,
0x0000541057387816ULL, 0x004fe40000000048ULL, 0x000054105f397816ULL, 0x002fca000000004aULL,
0x0000004100417306ULL, 0x000fe40000202400ULL, 0x000000383024723cULL, 0x000fec0000041824ULL,
0x0000005c00407306ULL, 0x000e620000202400ULL, 0x000054104c387816ULL, 0x008fce0000000051ULL,
0x0000004600467306ULL, 0x000ea20000202400ULL, 0x0000541041407816ULL, 0x002fce0000000040ULL,
0x0000004700477306ULL, 0x000e620000202400ULL, 0x0000541059467816ULL, 0x004fce0000000046ULL,
0x0000004400447306ULL, 0x000ea20000202400ULL, 0x0000541056477816ULL, 0x002fce0000000047ULL,
0x0000004500457306ULL, 0x000e620000202400ULL, 0x00000046301c723cULL, 0x000fe2000004181cULL,
0x000054105b447816ULL, 0x004fcc0000000044ULL, 0x0000003e003e7306ULL, 0x000fe20000202400ULL,
0x0000541058457816ULL, 0x002fce0000000045ULL, 0x0000003f003f7306ULL, 0x000fe20000202400ULL,
0x000000443014723cULL, 0x000fee0000041814ULL, 0x0000004f004f7306ULL, 0x000e700000202400ULL,
0x0000004d004d7306ULL, 0x000ea20000202400ULL, 0x000054104f397816ULL, 0x002fce000000005aULL,
0x0000005200527306ULL, 0x000e620000202400ULL, 0x000000383020723cULL, 0x000fe20000041820ULL,
0x000054104d507816ULL, 0x004fcc0000000050ULL, 0x0000004200427306ULL, 0x000ea20000202400ULL,
0x0000541052517816ULL, 0x002fce0000000061ULL, 0x0000003a003b7306ULL, 0x000e620000202400ULL,
0x000000503018723cULL, 0x000fe20000041818ULL, 0x0000541042417816ULL, 0x004fcc0000000043ULL,
0x0000004e004e7306ULL, 0x000ea20000202400ULL, 0x000000403010723cULL, 0x000fe20000041810ULL,
0x000054103b3e7816ULL, 0x002fe4000000003eULL, 0x000054104e3f7816ULL, 0x004fce000000003fULL,
0x0000003e302c723cULL, 0x000fe2000004182cULL, 0x012800003730783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000004b40783bULL, 0x000ee80000004200ULL, 0x000000004938783bULL, 0x000b620000004200ULL,
0x00000018ff477819ULL, 0x008fe20000011440ULL, 0x0000010040497824ULL, 0x062fe200078e00ffULL,
0x00008880404a7816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011441ULL, 0x00000100414b7824ULL, 0x040fe200078e00ffULL,
0x0000888041587816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x00000100424c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000004a004a7306ULL, 0x000fe20000202400ULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x000001003a5a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fc40000011441ULL, 0x00000018ff457819ULL, 0x000fe40000011442ULL,
0x00000018ff467819ULL, 0x000fe20000011443ULL, 0x0000004000567306ULL, 0x0003e20000202400ULL,
0x00008880434d7816ULL, 0x040fe400000000ffULL, 0x00000018ff3f7819ULL, 0x000fe40000011438ULL,
0x00000018ff447819ULL, 0x000fe40000011439ULL, 0x00000018ff377819ULL, 0x000fe2000001143aULL,
0x0000004900577306ULL, 0x0005e20000202400ULL, 0x0000010043407824ULL, 0x042fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143bULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x000088803b5c7816ULL, 0x000fc400000000ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x0000888042497816ULL, 0x044fe200000000ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011443ULL,
0x0000888039437816ULL, 0x000fe400000000ffULL, 0x00000018ff507819ULL, 0x000fe20000011442ULL,
0x0000004b005b7306ULL, 0x000fe20000202400ULL, 0x0000888038427816ULL, 0x000fc400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff5a7819ULL, 0x000fc6000001145aULL,
0x0000004100597306ULL, 0x0003f00000202400ULL, 0x0000004000547306ULL, 0x0005e20000202400ULL,
0x0000010038417824ULL, 0x042fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004700477306ULL, 0x000fe20000202400ULL,
0x0000010039407824ULL, 0x044fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004800487306ULL, 0x000fe20000202400ULL, 0x00000018ff397819ULL, 0x000fce0000011439ULL,
0x0000004200427306ULL, 0x000ff00000202400ULL, 0x00000041004b7306ULL, 0x0002b00000202400ULL,
0x0000004300437306ULL, 0x000fe20000202400ULL, 0x000088803a417816ULL, 0x042fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541042427816ULL, 0x004fca000000004bULL,
0x0000004000527306ULL, 0x000e620000202400ULL, 0x00000018ff3a7819ULL, 0x000fce000001143aULL,
0x00000038004e7306ULL, 0x0005e20000202400ULL, 0x0000541043437816ULL, 0x002fce0000000052ULL,
0x00000039004f7306ULL, 0x0003e20000202400ULL, 0x000054104a387816ULL, 0x004fe20000000057ULL,
0x000001003b577824ULL, 0x040fe400078e00ffULL, 0x000100003b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e005cULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x000000423018723cULL, 0x000fe20000041818ULL, 0x0000541058397816ULL, 0x002fe2000000005bULL,
0x0000004100417306ULL, 0x000fe20000202400ULL, 0x00000018ff3b7819ULL, 0x000fc8000001143bULL,
0x00000001ff427424ULL, 0x000fe200078e00ffULL, 0x000000383028723cULL, 0x000fe40000041828ULL,
0x0000005a00407306ULL, 0x000e6a0000202400ULL, 0x0000541056387816ULL, 0x000fe40000000047ULL,
0x0000541059397816ULL, 0x000fe20000000048ULL, 0x0000004500457306ULL, 0x000fec0000202400ULL,
0x000000383024723cULL, 0x000fe20000041824ULL, 0x0000541041407816ULL, 0x002fe20000000040ULL,
0x0000004600467306ULL, 0x000fea0000202400ULL, 0x0000000834387824ULL, 0x000fc600078e020dULL,
0x0000003f003f7306ULL, 0x000e660000202400ULL, 0x0176c842383879a7ULL, 0x0004aa000850003fULL,
0x0000004400447306ULL, 0x000ee20000202400ULL, 0x0176a0423dff79a7ULL, 0x0005e2000850003fULL,
0x000054104e4e7816ULL, 0x002fcc000000003fULL, 0x0000003700377306ULL, 0x000fe20000202400ULL,
0x000054104f4f7816ULL, 0x008fce0000000044ULL, 0x0000003e003e7306ULL, 0x000fe20000202400ULL,
0x0000004e3014723cULL, 0x000fee0000041814ULL, 0x0000004900497306ULL, 0x000ff00000202400ULL,
0x0000004c004c7306ULL, 0x000e700000202400ULL, 0x0000004d004d7306ULL, 0x000ee20000202400ULL,
0x00005410494c7816ULL, 0x002fce000000004cULL, 0x0000005000507306ULL, 0x000e620000202400ULL,
0x000054104d4d7816ULL, 0x008fce0000000054ULL, 0x0000005100517306ULL, 0x000ee20000202400ULL,
0x0000000405547836ULL, 0x000fe20000000000ULL, 0x0000004c3020723cULL, 0x000fe20000041820ULL,
0x0000541050507816ULL, 0x002fca0000000045ULL, 0x0000004a004a7306ULL, 0x000fe20000202400ULL,
0x0000541051517816ULL, 0x008fce0000000046ULL, 0x0000005700577306ULL, 0x000e620000202400ULL,
0x00000050301c723cULL, 0x000fee000004181cULL, 0x0000003a003a7306ULL, 0x000ee20000202400ULL,
0x000054104a417816ULL, 0x002fce0000000057ULL, 0x0000003b003b7306ULL, 0x000e620000202400ULL,
0x000000403010723cULL, 0x000fe20000041810ULL, 0x000054103a3a7816ULL, 0x008fe40000000037ULL,
0x000054103b3b7816ULL, 0x002fce000000003eULL, 0x0000003a302c723cULL, 0x000fee000004182cULL,
0x0000000104307812ULL, 0x004fde00078ec0ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000106067836ULL, 0x000fca0000000000ULL, 0x0000000f0600720cULL, 0x000fda0003f06070ULL,
0xffffff6c00bc8947ULL, 0x000fea000383ffffULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0019ULL, 0x000000ffff097224ULL, 0x010fd400078e0018ULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x0180000007007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000a80000047802ULL, 0x000fce0000000f00ULL, 0x0000007400487944ULL, 0x006fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00cfc80000000007ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009400ff027b82ULL, 0x000f240000000a00ULL, 0x0000000602037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x000f640000000000ULL, 0x00000002ff077819ULL, 0x02efe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x010fca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000002804287220ULL, 0x042fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000000f040f7220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x000fe20000410000ULL,
0x0000002a052a7220ULL, 0x044fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001305137220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x000000013c3c7812ULL, 0x000fe400078ec0ffULL,
0x000000141515723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000010003c0d7824ULL, 0x000fe200078e020dULL, 0x000000101110723eULL, 0x000fc400000010ffULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000001e1f11723eULL, 0x000fe400000010ffULL,
0x0000001a1b1a723eULL, 0x000fe400000010ffULL, 0x000000161716723eULL, 0x000fe400000010ffULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x000000ff3400720cULL, 0x000fc40003f05270ULL,
0x00000002ff057819ULL, 0x008fe40000011600ULL, 0x0000000200027812ULL, 0x044fe400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x00000008050a7824ULL, 0x040fe200078e00ffULL,
0x0000000502037211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x0000000807197824ULL, 0x000fe400078e00ffULL,
0x0000000805077824ULL, 0x000fc400078e00ffULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff819087812ULL, 0x000fe200078ee204ULL, 0x0000000800047824ULL, 0x000fc600078e00ffULL,
0xfffffff807067812ULL, 0x000fe200078ee202ULL, 0x0000000805027824ULL, 0x000fe400078e00ffULL,
0x0000000403057836ULL, 0x000fe40000000000ULL, 0x0000000603077836ULL, 0x000fe20000000000ULL,
0xfffffff802027812ULL, 0x000fe200078ee203ULL, 0x0000080034037824ULL, 0x000fe200078e020dULL,
0xfffffff80a0a7812ULL, 0x000fe400078ee205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x00000010080e7824ULL, 0x100fe200078e0203ULL, 0x0000000804057812ULL, 0x000fe200078ec0ffULL,
0x0000001002047824ULL, 0x100fe200078e0203ULL, 0x000000282902723eULL, 0x000fe200000010ffULL,
0x0000001006087824ULL, 0x000fc400078e0203ULL, 0x000000100a0a7824ULL, 0x100fe400078e0203ULL,
0x000000100c0c7824ULL, 0x000fe200078e0203ULL, 0x000000242503723eULL, 0x000fe200000010ffULL,
0x0000000104067824ULL, 0x000fe200078e0205ULL, 0x000000090f04723eULL, 0x000fe200000010ffULL,
0x0000000105077824ULL, 0x040fe200078e0208ULL, 0x0000541002187816ULL, 0x140fe20000000003ULL,
0x00000001050e7824ULL, 0x040fe200078e020eULL, 0x0000763202197816ULL, 0x000fe20000000003ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x000000202102723eULL, 0x000fe200000010ffULL,
0x00000001050c7824ULL, 0x000fe200078e020cULL, 0x0000001c1d03723eULL, 0x000fe200000010ffULL,
0x0000001806007388ULL, 0x0005e20000000a00ULL, 0x0000002c2d08723eULL, 0x000fc400000010ffULL,
0x0000541004147816ULL, 0x140fe40000000015ULL, 0x0000763204157816ULL, 0x000fe40000000015ULL,
0x0000541010047816ULL, 0x140fe40000000008ULL, 0x0000763210057816ULL, 0x000fe40000000008ULL,
0x0000002e2f09723eULL, 0x000fe400000010ffULL, 0x0000541002187816ULL, 0x004fc40000000003ULL,
0x0000763202197816ULL, 0x000fe40000000003ULL, 0x0000002a2b02723eULL, 0x000fe400000010ffULL,
0x000000262703723eULL, 0x000fe200000010ffULL, 0x0000001807007388ULL, 0x000fe20000000a00ULL,
0x000076321a0f7816ULL, 0x000fe40000000016ULL, 0x0000541012087816ULL, 0x140fe20000000009ULL,
0x000000140a007388ULL, 0x000fe20000000a00ULL, 0x0000763212097816ULL, 0x000fc60000000009ULL,
0x000000040c007388ULL, 0x0005e40000000a00ULL, 0x0000541002047816ULL, 0x144fe40000000003ULL,
0x0000763202057816ULL, 0x000fe20000000003ULL, 0x000000010b027824ULL, 0x000fc800078e0200ULL,
0x000000040e007388ULL, 0x0005e20000000a00ULL, 0x0000001002037824ULL, 0x000fe400078e020dULL,
0x000000ff00027306ULL, 0x000ee20000202400ULL, 0x0000541022047816ULL, 0x144fe40000000011ULL,
0x0000763222057816ULL, 0x000fe40000000011ULL, 0x000054101a0e7816ULL, 0x000fc60000000016ULL,
0x0004000407007388ULL, 0x000fe80000000a00ULL, 0x0004000e0a007388ULL, 0x000fe80000000a00ULL,
0x000400080c007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000003107984ULL, 0x000ee80000000c00ULL, 0x0004000003147984ULL, 0x000ea80000000c00ULL,
0x0008000003047984ULL, 0x000f280000000c00ULL, 0x000c000003187984ULL, 0x000f620000000c00ULL,
0x0000001302137230ULL, 0x008fc40000200800ULL, 0x0000001202127230ULL, 0x040fe40000200800ULL,
0x0000001102117230ULL, 0x040fe40000200800ULL, 0x0000001002107230ULL, 0x040fe40000200800ULL,
0x0000001702177230ULL, 0x044fe40000200800ULL, 0x0000001602167230ULL, 0x040fe40000200800ULL,
0x0000001502157230ULL, 0x000fc40000200800ULL, 0x0000001402027230ULL, 0x000fe40000200800ULL,
0x0000000713137230ULL, 0x010fe40000200000ULL, 0x0000000612127230ULL, 0x000fe40000200000ULL,
0x0000000511117230ULL, 0x000fe40000200000ULL, 0x0000000410107230ULL, 0x000fe40000200000ULL,
0x0000001b17177230ULL, 0x022fc40000200000ULL, 0x0000001a16167230ULL, 0x000fe20000200000ULL,
0x0000001003007388ULL, 0x0003e20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000200000ULL,
0x0000001802147230ULL, 0x000fca0000200000ULL, 0x0004001403007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002000067836ULL, 0x000fe20000000000ULL, 0x00000003ff117819ULL, 0x002fe20000011600ULL,
0x0000000000107919ULL, 0x000e620000002600ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000003ff057819ULL, 0x000fe20000011606ULL,
0x0000000111027824ULL, 0x000fe200078e0200ULL, 0x0000000304047899ULL, 0x000fc6000800063fULL,
0x0000000106047824ULL, 0x000fe200078e0205ULL, 0x0000000702037812ULL, 0x000fc800078ec0ffULL,
0x0000000704077812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803027812ULL, 0x000fe400078ef800ULL,
0x0ffffff807047812ULL, 0x000fe200078ef806ULL, 0x000000083c077824ULL, 0x000fe400078e00ffULL,
0x0000001002027824ULL, 0x100fe400078e020dULL, 0x0000001004047824ULL, 0x000fe200078e020dULL,
0xfffffff807077812ULL, 0x000fc400078ee200ULL, 0x0000000002087984ULL, 0x0007220000000c00ULL,
0x00000005040472a4ULL, 0x004fc6000f8e023fULL, 0x00000000040c7984ULL, 0x0005620000000c00ULL,
0x0000000810127824ULL, 0x042fe400078e00ffULL, 0x0000000810107824ULL, 0x000fc600078e00ffULL,
0xfffffff812037812ULL, 0x000fe200078ee211ULL, 0x000000083c117824ULL, 0x000fe200078e00ffULL,
0xfffffff810057812ULL, 0x000fe400078ee205ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe2000ff3e0ffULL, 0x0000860000047ab9ULL, 0x000fe20000000a00ULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x008fe2000f8040ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x004fc4000f8240ffULL, 0x0000000503037c11ULL, 0x000fe400080f4412ULL,
0x0000000505057c11ULL, 0x000fe200088f4410ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000353c00720cULL, 0x000fe20003f06070ULL, 0x00009400ff067b82ULL, 0x002e620000000a00ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0xffffffffff117424ULL, 0x000fc800078e00ffULL,
0x017600080d0879a7ULL, 0x0004aa000850003fULL, 0x0000000230038824ULL, 0x000fe200078e00ffULL,
0x00009000ff048b82ULL, 0x000ef00000000800ULL, 0x00008c00ff0a8b82ULL, 0x000f620000000a00ULL,
0x0000000606067981ULL, 0x002522000c1e9900ULL, 0x0000000403038224ULL, 0x008fc800078e023cULL,
0x00000004030a8825ULL, 0x020fca00078e000aULL, 0x000000060a118981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000004013007824ULL, 0x000fe400078e00ffULL,
0x000000403c037824ULL, 0x000fe400078e00ffULL, 0x0000004010057824ULL, 0x000fe400078e00ffULL,
0x0000001100047224ULL, 0x008fcc00078e02ffULL, 0x0000000c00a80947ULL, 0x004fea0003800000ULL,
0x00000003ff117819ULL, 0x100fe2000001160eULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000003360a7248ULL, 0x000fe40007fe0000ULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x00000004110b7836ULL, 0x000fe40000000000ULL, 0x000000010a0a7824ULL, 0x000fe400078e0a03ULL,
0x000000010b077824ULL, 0x040fe400078e020eULL, 0x000000080b0c7824ULL, 0x040fe200078e00ffULL,
0x0000000a0b00720cULL, 0x000fe20003f86070ULL, 0x00000040100b7824ULL, 0x000fc400078e0211ULL,
0x0000000811137836ULL, 0x000fe20000000000ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000040b077836ULL, 0x000fe20000000000ULL, 0x0000000b04187210ULL, 0x000fe20007f1e0ffULL,
0x0000000113107824ULL, 0x140fe200078e020eULL, 0x0000000a1300720cULL, 0x040fe20003fa6070ULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000000704167210ULL, 0x000fe20007f3e0ffULL,
0x000000080b077836ULL, 0x000fe40000000000ULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0000000418197c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x00000004161b7c11ULL, 0x000fe2000f8238ffULL, 0x0000000111127824ULL, 0x000fe200078e020eULL,
0x00000007041e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000c0b077836ULL, 0x000fe20000000000ULL,
0x0000000518187c11ULL, 0x000fe200080f3c15ULL, 0x000000140b157836ULL, 0x000fe20000000000ULL,
0x0000000516167c11ULL, 0x000fe200088f3c13ULL, 0x000000100b137836ULL, 0x000fe20000000000ULL,
0xfffffff817107812ULL, 0x000fe200078ee210ULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000001504157210ULL, 0x000fc40007f7e0ffULL, 0x0000001304137210ULL, 0x000fe40007f5e0ffULL,
0x0000000704077210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x000000041e1d7c11ULL, 0x040fe2000f8038ffULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x0000000415257c11ULL, 0x000fe2000f8438ffULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0x000000051e1e7c11ULL, 0x000fe200080f3c17ULL, 0x000000180b177836ULL, 0x000fe20000000000ULL,
0x0000000413217c11ULL, 0x000fc4000f8238ffULL, 0x0000000515287c11ULL, 0x000fe200090f3c28ULL,
0x0000000c11157836ULL, 0x000fe20000000000ULL, 0x0000000513207c11ULL, 0x000fe200088f3c20ULL,
0x0000001011137836ULL, 0x000fe20000000000ULL, 0x0000000712237812ULL, 0x000fe200078ec0ffULL,
0x0000000115147824ULL, 0x140fe200078e020eULL, 0x0000001704177210ULL, 0x000fe20007fde0ffULL,
0x0000000815297824ULL, 0x000fe200078e00ffULL, 0x0000000219127210ULL, 0x000fe20007f3e0ffULL,
0x00000008131c7824ULL, 0x000fe200078e00ffULL, 0x0000000a1500720cULL, 0x080fe20003f66070ULL,
0x0000000113157824ULL, 0x040fe200078e020eULL, 0x0000000a1300720cULL, 0x000fe20003f46070ULL,
0x000000ffff267224ULL, 0x000fe200030e06ffULL, 0xfffffff8291a7812ULL, 0x000fe200078ee214ULL,
0x000000ffff137224ULL, 0x000fe200008e0618ULL, 0x0000000417277c11ULL, 0x000fc4000f8238ffULL,
0x00000004071f7c11ULL, 0x000fe4000f8038ffULL, 0x0000000517267c11ULL, 0x000fe200088f3c26ULL,
0x0000001411177836ULL, 0x000fe20000000000ULL, 0x000000021b147210ULL, 0x000fe20007f3e0ffULL,
0x00000018111b7836ULL, 0x000fe20000000000ULL, 0x0000000507227c11ULL, 0x000fe200080f3c22ULL,
0x000040003c077824ULL, 0x000fe200078e020dULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL,
0x000000ffff157224ULL, 0x000fe200008e0616ULL, 0x0000000a1100720cULL, 0x000fe20003f06070ULL,
0x0000100007077836ULL, 0x000fe20000000000ULL, 0x000000021d167210ULL, 0x000fe20007f3e0ffULL,
0x0000001c0b1d7836ULL, 0x000fe20000000000ULL, 0x0ffffff823247812ULL, 0x000fe200078ef80eULL,
0x0000000117187824ULL, 0x000fc400078e020eULL, 0x0000000817297824ULL, 0x000fe200078e00ffULL,
0x0000001d041d7210ULL, 0x000fe20007fde0ffULL, 0x0000001024197824ULL, 0x000fc800078e0207ULL,
0x000000ffff247224ULL, 0x000fe200030e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012197faeULL, 0x0003e2000c101c46ULL, 0x000000041d237c11ULL, 0x000fe4000f8c38ffULL,
0x0000000a1700720cULL, 0x080fe20003f06070ULL, 0x000000ffff177224ULL, 0x000fe200008e061eULL,
0x0000000a1b00720cULL, 0x000fe40003f26070ULL, 0x000000051d247c11ULL, 0x000fe2000b0f3c24ULL,
0x00000010101d7824ULL, 0x000fe200078e0207ULL, 0xfffffff8291e7812ULL, 0x000fe200078ee218ULL,
0x000000011b127824ULL, 0x002fc400078e020eULL, 0x000000081b137824ULL, 0x000fe400078e00ffULL,
0x000000100c1b7824ULL, 0x000fe400078e0207ULL, 0x0000001c11197836ULL, 0x000fe20000000000ULL,
0xfffffff8130c7812ULL, 0x000fe400078ee212ULL, 0x00000000141b7faeULL, 0x0003e2000e101c46ULL,
0x000000021f127210ULL, 0x000fe20007fde0ffULL, 0x00000020111f7836ULL, 0x000fe20000000000ULL,
0x0000000a1900720cULL, 0x000fe20003f86070ULL, 0x00000000161d7faeULL, 0x0005e2000e901c46ULL,
0x0000000221187210ULL, 0x000fe20007fbe0ffULL, 0x000000200b217836ULL, 0x000fc40000000000ULL,
0x000000ffff137224ULL, 0x000fe400030e0622ULL, 0x0000000119107824ULL, 0x040fe200078e020eULL,
0x0000002104227210ULL, 0x000fe20007fde0ffULL, 0x0000000819297824ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x000fe200028e0620ULL, 0x0000000a1f00720cULL, 0x040fe20003fa6070ULL,
0x000000011f147824ULL, 0x042fe200078e020eULL, 0xfffffff829107812ULL, 0x000fe200078ee210ULL,
0x000000ffff157224ULL, 0x000fe200030e06ffULL, 0x0000000422217c11ULL, 0x000fe2000f8c38ffULL,
0x000000081f1f7824ULL, 0x000fc400078e00ffULL, 0x000000101a177824ULL, 0x004fe200078e0207ULL,
0x0000000522227c11ULL, 0x000fe2000b0f3c15ULL, 0x000000240b1d7836ULL, 0x000fe20000000000ULL,
0xfffffff81f1a7812ULL, 0x000fe200078ee214ULL, 0x000000101c1b7824ULL, 0x000fe200078e0207ULL,
0x0000000012177faeULL, 0x0003e2000d901c46ULL, 0x0000002411157836ULL, 0x000fe20000000000ULL,
0x0000001d041f7210ULL, 0x000fe20007fde0ffULL, 0x0000003c11297836ULL, 0x000fe20000000000ULL,
0x0000000225147210ULL, 0x000fe20007f7e0ffULL, 0x00000000181b7faeULL, 0x0005e2000d101c46ULL,
0x0000000a1500720cULL, 0x040fe20003f46070ULL, 0x0000000115167824ULL, 0x000fc400078e020eULL,
0x00000008151d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x000000041f257c11ULL, 0x040fe2000f8c38ffULL, 0x000000ffff157224ULL, 0x000fe200018e0628ULL,
0x0000000227127210ULL, 0x002fe20007f7e0ffULL, 0x0000003811277836ULL, 0x000fe20000000000ULL,
0xfffffff81d1c7812ULL, 0x000fe200078ee216ULL, 0x000000101e1d7824ULL, 0x000fe200078e0207ULL,
0x000000051f1b7c11ULL, 0x004fe2000b0f3c20ULL, 0x000000ffff137224ULL, 0x000fc400018e0626ULL,
0x000000100c1f7824ULL, 0x100fe200078e0207ULL, 0x00000000141d7faeULL, 0x0003e2000c101c46ULL,
0x0000000223167210ULL, 0x000fe20007f1e0ffULL, 0x000000101a237824ULL, 0x100fe400078e0207ULL,
0x00000000121f7faeULL, 0x0005e2000c901c46ULL, 0x0000000221187210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe200000e0624ULL, 0x00000002251a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001010217824ULL, 0x000fe400078e0207ULL, 0x000000ffff197224ULL, 0x000fe200008e0622ULL,
0x0000000a2700720cULL, 0x000fe20003f26070ULL, 0x0000002c11157836ULL, 0x002fe20000000000ULL,
0x0000000016217faeULL, 0x0003e2000e101c46ULL, 0x00000030111d7836ULL, 0x000fc40000000000ULL,
0x0000002811137836ULL, 0x004fe20000000000ULL, 0x0000000018237faeULL, 0x0005e2000e901c46ULL,
0x00000034111f7836ULL, 0x000fe20000000000ULL, 0x0000000a1500720cULL, 0x080fe20003f86070ULL,
0x000000280b117836ULL, 0x000fe20000000000ULL, 0x0000000a1300720cULL, 0x0c0fe20003fa6070ULL,
0x00000001130c7824ULL, 0x000fe200078e020eULL, 0x0000000a1d00720cULL, 0x000fe20003f66070ULL,
0x000000101c257824ULL, 0x000fe200078e0207ULL, 0x0000001104147210ULL, 0x000fe20007fde0ffULL,
0x0000000813177824ULL, 0x002fc400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e061bULL,
0x0000000a2900720cULL, 0x080fe20003f06070ULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0000000414117c11ULL, 0x040fe2000f8c38ffULL, 0x000000081f187824ULL, 0x044fe200078e00ffULL,
0x000000001a257faeULL, 0x000fe2000d101c46ULL, 0x0000000a1f00720cULL, 0x000fe20003f46070ULL,
0x00000001150a7824ULL, 0x140fe200078e020eULL, 0x0000000514147c11ULL, 0x000fe2000b0f3c13ULL,
0x0000002c0b137836ULL, 0x000fe20000000000ULL, 0x0000000211107210ULL, 0x000fe20007fde0ffULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0xfffffff8170c7812ULL, 0x000fe200078ee20cULL,
0x000000011d127824ULL, 0x000fc400078e020eULL, 0x000000ffff117224ULL, 0x000fe200030e0614ULL,
0x0000001304197210ULL, 0x000fe20007fde0ffULL, 0x000000011f137824ULL, 0x000fe200078e020eULL,
0xfffffff8150a7812ULL, 0x000fe200078ee20aULL, 0x000000100c157824ULL, 0x000fe400078e0207ULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8180c7812ULL, 0x000fe200078ee213ULL,
0x000000300b137836ULL, 0x000fe20000000000ULL, 0x0000000010157faeULL, 0x0003e2000e901c46ULL,
0x000000ffff167224ULL, 0x000fe200030e06ffULL, 0x0000000419177c11ULL, 0x000fc4000f8c38ffULL,
0x0000001304137210ULL, 0x000fe40007fbe0ffULL, 0xfffffff81d147812ULL, 0x000fe400078ee212ULL,
0x0000000519197c11ULL, 0x000fe2000b0f3c16ULL, 0x000000ffff187224ULL, 0x000fe200028e06ffULL,
0x00000004131d7c11ULL, 0x000fe2000f8c38ffULL, 0x0000000127167824ULL, 0x000fe200078e020eULL,
0x0000000217127210ULL, 0x000fe20007fbe0ffULL, 0x000000340b157836ULL, 0x002fe20000000000ULL,
0x0000000513107c11ULL, 0x000fe2000b0f3c18ULL, 0x0000000827277824ULL, 0x000fc400078e00ffULL,
0x00000001290e7824ULL, 0x040fe400078e020eULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff827167812ULL, 0x000fe200078ee216ULL, 0x000000ffff137224ULL, 0x000fe200028e0619ULL,
0x0000001504157210ULL, 0x000fe20007fbe0ffULL, 0x000000100a117824ULL, 0x100fe200078e0207ULL,
0xfffffff8290e7812ULL, 0x000fe200078ee20eULL, 0x000000380b177836ULL, 0x000fe40000000000ULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0x0000000012117faeULL, 0x0003e2000e101c46ULL,
0x0000003c0b0b7836ULL, 0x000fe20000000000ULL, 0x00000004151f7c11ULL, 0x000fe2000f8a38ffULL,
0x000000100c197824ULL, 0x100fe200078e0207ULL, 0x0000001704187210ULL, 0x000fe20007f9e0ffULL,
0x0000001014177824ULL, 0x100fe200078e0207ULL, 0x0000000b04047210ULL, 0x000fe20007fde0ffULL,
0x00000010161b7824ULL, 0x000fc400078e0207ULL, 0x000000100e077824ULL, 0x000fe200078e0207ULL,
0x00000005150e7c11ULL, 0x000fe4000a8f3c0aULL, 0x000000021d0a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e06ffULL, 0x0000000418137c11ULL, 0x002fe2000f8838ffULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x0000000404157c11ULL, 0x000fe2000f8c38ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e0610ULL, 0x000000021f107210ULL, 0x000fe40007fbe0ffULL,
0x00000005180c7c11ULL, 0x000fc4000a0f3c1dULL, 0x0000000504047c11ULL, 0x000fe2000b0f3c11ULL,
0x000000ffff117224ULL, 0x000fe200028e060eULL, 0x0000000213127210ULL, 0x000fe20007f9e0ffULL,
0x000000000a177faeULL, 0x0003e2000d901c46ULL, 0x0000000215147210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200020e060cULL, 0x0000000010197faeULL, 0x0003e2000d101c46ULL,
0x000000ffff157224ULL, 0x000fc600028e0604ULL, 0x00000000121b7faeULL, 0x0003e8000c901c46ULL,
0x0000000014077faeULL, 0x0003e2000c101c46ULL, 0x0000000c00587947ULL, 0x000fea0003800000ULL,
0x000000040e0a7811ULL, 0x040fe200078fe8ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000080e0c7811ULL, 0x000fe200078fe8ffULL, 0x000040003c2f7824ULL, 0x000fe200078e020dULL,
0x0000000c0e117811ULL, 0x000fe200078fe8ffULL, 0x000000010a2a7824ULL, 0x100fe200078e020eULL,
0x000000100e127811ULL, 0x000fe200078fe8ffULL, 0x000000080a077824ULL, 0x000fe200078e00ffULL,
0x000000140e157811ULL, 0x000fe200078fe8ffULL, 0x000000010c297824ULL, 0x100fe200078e020eULL,
0x000000180e187811ULL, 0x000fe200078fe8ffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0xfffffff8072a7812ULL, 0x000fe200078ee22aULL, 0x0000000111287824ULL, 0x140fe200078e020eULL,
0x0000001c0e197811ULL, 0x000fe200078fe8ffULL, 0x0000000811077824ULL, 0x000fe200078e00ffULL,
0xfffffff810297812ULL, 0x000fe200078ee229ULL, 0x0000000112277824ULL, 0x100fe200078e020eULL,
0x000000200e1a7811ULL, 0x000fe200078fe8ffULL, 0x0000000812107824ULL, 0x000fe200078e00ffULL,
0xfffffff807287812ULL, 0x000fe200078ee228ULL, 0x0000000115267824ULL, 0x140fe200078e020eULL,
0x000000240e2e7811ULL, 0x000fe200078fe8ffULL, 0x0000000815077824ULL, 0x000fe200078e00ffULL,
0xfffffff810277812ULL, 0x000fe200078ee227ULL, 0x0000000118257824ULL, 0x100fe200078e020eULL,
0x000000280e317811ULL, 0x000fe200078fe8ffULL, 0x0000000818107824ULL, 0x000fe200078e00ffULL,
0xfffffff807267812ULL, 0x000fe200078ee226ULL, 0x0000000119247824ULL, 0x140fe200078e020eULL,
0x0000002c0e327811ULL, 0x000fe200078fe8ffULL, 0x0000000819077824ULL, 0x000fe200078e00ffULL,
0xfffffff810257812ULL, 0x000fe200078ee225ULL, 0x000000011a237824ULL, 0x100fe200078e020eULL,
0x000000300e347811ULL, 0x000fe200078fe8ffULL, 0x000000081a107824ULL, 0x000fe200078e00ffULL,
0xfffffff807247812ULL, 0x000fe200078ee224ULL, 0x000000012e227824ULL, 0x100fe200078e020eULL,
0x000000380e3a7811ULL, 0x000fe200078fe8ffULL, 0x000000082e077824ULL, 0x000fe200078e00ffULL,
0xfffffff810237812ULL, 0x000fe200078ee223ULL, 0x0000000131217824ULL, 0x140fe200078e020eULL,
0x000000340e387811ULL, 0x000fe200078fe8ffULL, 0x0000000831107824ULL, 0x000fe200078e00ffULL,
0xfffffff807227812ULL, 0x000fe200078ee222ULL, 0x0000000132207824ULL, 0x100fe200078e020eULL,
0x0000000e0e2c7211ULL, 0x000fe200078fe8ffULL, 0x0000000832077824ULL, 0x000fe200078e00ffULL,
0xfffffff810217812ULL, 0x000fe200078ee221ULL, 0x00000001341f7824ULL, 0x100fe200078e020eULL,
0x0000003c0e3d7811ULL, 0x000fe200078fe8ffULL, 0x0000000834107824ULL, 0x000fe200078e00ffULL,
0xfffffff807207812ULL, 0x000fe200078ee220ULL, 0x000000013a2b7824ULL, 0x000fe200078e020eULL,
0x000000050e077211ULL, 0x000fe200078fe8ffULL, 0x000000083a147824ULL, 0x000fe200078e00ffULL,
0xfffffff8101f7812ULL, 0x000fe200078ee21fULL, 0x00000001050b7824ULL, 0x040fe200078e020aULL,
0x0000000704167210ULL, 0x000fe20007f1e0ffULL, 0x00000001381d7824ULL, 0x040fe200078e020eULL,
0xfffffff8142b7812ULL, 0x000fe200078ee22bULL, 0x0000000838107824ULL, 0x000fe200078e00ffULL,
0x0000000b04147210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00000004160a7c11ULL, 0x000fe2000f8038ffULL, 0x0000000105077824ULL, 0x040fe200078e020cULL,
0xfffffff8101d7812ULL, 0x000fe200078ee21dULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x0000000414107c11ULL, 0x000fe2000f8238ffULL, 0x0000000105137824ULL, 0x040fe200078e0211ULL,
0x00000005160b7c11ULL, 0x000fe200080f3c0bULL, 0x000010002f407836ULL, 0x000fe20000000000ULL,
0x0000000514117c11ULL, 0x000fe200088f3c17ULL, 0x0000000105177824ULL, 0x040fe200078e0215ULL,
0x0000000704167210ULL, 0x000fe20007f1e0ffULL, 0x0000000105077824ULL, 0x040fe200078e0212ULL,
0x00000013040c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001052f7824ULL, 0x040fe200078e022eULL,
0x00000070024d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00000007041b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200008e06ffULL,
0x000000040c147c11ULL, 0x000fe2000f8238ffULL, 0x0000000105077824ULL, 0x040fe200078e0218ULL,
0x0000000416127c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x000000050c157c11ULL, 0x000fe200088f3c2dULL, 0x0000000105377824ULL, 0x040fe200078e0234ULL,
0x0000000516137c11ULL, 0x000fe200080f3c13ULL, 0x0000000105317824ULL, 0x040fe200078e0231ULL,
0x00000017040c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000105337824ULL, 0x000fe200078e0232ULL,
0x000000041b167c11ULL, 0x000fe2000f8038ffULL, 0x00000001053f7824ULL, 0x000fe200078e023dULL,
0x0000002f042f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200008e06ffULL,
0x000000051b177c11ULL, 0x000fe200080f3c1cULL, 0x00000001051b7824ULL, 0x040fe200078e0219ULL,
0x000000040c187c11ULL, 0x040fe2000f8238ffULL, 0x0000000105397824ULL, 0x040fe200078e0238ULL,
0x00000007041e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000105077824ULL, 0x040fe200078e021aULL,
0x000000050c197c11ULL, 0x000fe200088f3c2dULL, 0x00000001053b7824ULL, 0x000fe200078e023aULL,
0x0000001b040c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e06ffULL,
0x0000000704077210ULL, 0x000fe20007f5e0ffULL, 0x000000102b497824ULL, 0x100fe200078e0240ULL,
0x000000041e1a7c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff2d7224ULL, 0x000fe200008e06ffULL,
0x000000040c1c7c11ULL, 0x000fe2000f8238ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x000000051e1b7c11ULL, 0x000fe200080f3c1bULL, 0x000000101f457824ULL, 0x100fe200078e0240ULL,
0x000000050c0c7c11ULL, 0x000fe200088f3c2dULL, 0x000000101d477824ULL, 0x100fe200078e0240ULL,
0x000000072c2d7812ULL, 0x000fe200078ec0ffULL, 0x0000001029297824ULL, 0x100fe200078e0240ULL,
0x00000004071e7c11ULL, 0x000fe2000f8038ffULL, 0x0000001020437824ULL, 0x000fe200078e0240ULL,
0x0ffffff82d2d7812ULL, 0x000fe200078ef80eULL, 0x000000013d0e7824ULL, 0x040fe200078e020eULL,
0x00000037042c7210ULL, 0x000fe20007f3e0ffULL, 0x000000083d3d7824ULL, 0x000fe200078e00ffULL,
0x0000000507077c11ULL, 0x000fe200080f3c3eULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x0000003104387210ULL, 0x000fe20007f7e0ffULL, 0x0000001026377824ULL, 0x100fe200078e0240ULL,
0x0000003304347210ULL, 0x000fe20007f1e0ffULL, 0x0000001027337824ULL, 0x100fe200078e0240ULL,
0x0000003904327210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x0000003b042e7210ULL, 0x000fe20007f9e0ffULL, 0x0000001025397824ULL, 0x100fe200078e0240ULL,
0xfffffff83d0e7812ULL, 0x000fe200078ee20eULL, 0x00000010233d7824ULL, 0x100fe200078e0240ULL,
0x000000042f3a7c11ULL, 0x040fe2000f8c38ffULL, 0x000000ffff237224ULL, 0x000fe200018e06ffULL,
0x0000003f04047210ULL, 0x000fe20007fbe0ffULL, 0x00000010223f7824ULL, 0x100fe200078e0240ULL,
0x000000042c267c11ULL, 0x000fe2000f8238ffULL, 0x00000010243b7824ULL, 0x000fe200078e0240ULL,
0x0000000438227c11ULL, 0x000fe2000f8638ffULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x000000052f3e7c11ULL, 0x000fe2000b0f3c3eULL, 0x0000001028317824ULL, 0x100fe200078e0240ULL,
0x0000000434247c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e06ffULL,
0x000000052c277c11ULL, 0x000fe200088f3c27ULL, 0x000000102a2f7824ULL, 0x100fe200078e0240ULL,
0x0000000432287c11ULL, 0x000fe2000f8238ffULL, 0x000000ffff1f7224ULL, 0x000fe200020e06ffULL,
0x0000000538237c11ULL, 0x000fe200098f3c23ULL, 0x000000ffff1d7224ULL, 0x000fe200028e06ffULL,
0x000000042e2a7c11ULL, 0x000fe2000f8438ffULL, 0x000000100e4b7824ULL, 0x100fe200078e0240ULL,
0x00000004042c7c11ULL, 0x000fe2000f8638ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0240ULL,
0x0000000534257c11ULL, 0x000fe200080f3c25ULL, 0x0000001021417824ULL, 0x000fe200078e0240ULL,
0x0000000a4d0a7210ULL, 0x000fc40007f1e0ffULL, 0x00000005322b7c11ULL, 0x000fe400088f3c2bULL,
0x000000052e0e7c11ULL, 0x000fe200090f3c1fULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000104d107210ULL, 0x000fe40007f3e0ffULL, 0x0000000504027c11ULL, 0x000fe400098f3c1dULL,
0x000000124d127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x000000144d147210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2d7faeULL, 0x000fe2000b901c46ULL, 0x000000164d167210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x000000184d187210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x0000001a4d1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x0000001c4d1c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200020e0619ULL, 0x0000001e4d1e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x0000003a4d207210ULL, 0x000fe20007f7e0ffULL,
0x00000000102f7faeULL, 0x000fe2000b901c46ULL, 0x000000224d227210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e060cULL, 0x000000244d247210ULL, 0x000fe20007f9e0ffULL,
0x0000000012297faeULL, 0x0003e2000b901c46ULL, 0x000000264d267210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e0607ULL, 0x000000284d287210ULL, 0x000fe20007f3e0ffULL,
0x0000000014317faeULL, 0x0005e2000b901c46ULL, 0x0000002a4d2a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff217224ULL, 0x000fe200018e063eULL, 0x0000002c4d2c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000016337faeULL, 0x0005e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc400028e0623ULL,
0x000000ffff257224ULL, 0x000fe200020e0625ULL, 0x0000000018377faeULL, 0x0005e2000b901c46ULL,
0x000000ffff277224ULL, 0x000fe400000e0627ULL, 0x000000ffff297224ULL, 0x002fe200008e062bULL,
0x000000001a397faeULL, 0x0005e2000b901c46ULL, 0x000000ffff2b7224ULL, 0x000fe400010e060eULL,
0x000000ffff2d7224ULL, 0x000fe200018e0602ULL, 0x000000001c3b7faeULL, 0x0005e8000b901c46ULL,
0x000000001e3d7faeULL, 0x0005e8000b901c46ULL, 0x00000000203f7faeULL, 0x0005e8000b901c46ULL,
0x0000000022417faeULL, 0x0005e8000b901c46ULL, 0x0000000024437faeULL, 0x0005e8000b901c46ULL,
0x0000000026457faeULL, 0x0005e8000b901c46ULL, 0x0000000028477faeULL, 0x0005e8000b901c46ULL,
0x000000002a497faeULL, 0x0005e8000b901c46ULL, 0x000000002c4b7faeULL, 0x0005e4000b901c46ULL,
0x000000043c027836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff077424ULL, 0x002fc600078e00ffULL, 0x000000350200720cULL, 0x000fda0003f06070ULL,
0x00009000ff048b82ULL, 0x000e620000000800ULL, 0x0000000230118824ULL, 0x004fce00078e00ffULL,
0x00008c00ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000411118224ULL, 0x002fc800078e0202ULL,
0x00000004110a8825ULL, 0x004fca00078e000aULL, 0x000000060a078981ULL, 0x000324000c1e1900ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x017600090d0075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x000000100a137210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0bULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011411ULL,
0x0000001304047211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000204047819ULL, 0x000fc80000001211ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x017600090d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000097919ULL, 0x000e640000000000ULL, 0x000000203c047824ULL, 0x002fca00078e0209ULL,
0x00000003ff087819ULL, 0x000fc80000011604ULL, 0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL,
0x0000000f04087812ULL, 0x000fc600078ec0ffULL, 0x0000000104097824ULL, 0x000fe400078e0209ULL,
0x00000010080a7824ULL, 0x040fe400078e00ffULL, 0x0000000109047836ULL, 0x000fe20000000000ULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x00000010080b7824ULL, 0x000fc600078e00ffULL,
0x0000000f04087812ULL, 0x000fe400078ec0ffULL, 0x000000f00a047812ULL, 0x000fe400078ee209ULL,
0x000000f00b087812ULL, 0x000fc600078ee208ULL, 0x0000001004047824ULL, 0x100fe400078e020dULL,
0x0000001008087824ULL, 0x000fc600078e020dULL, 0x0000000004147984ULL, 0x000e680000000c00ULL,
0x0000000008107984ULL, 0x000ea20000000c00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fc400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001804007388ULL, 0x0003e20000000c00ULL,
0x00000001ff107424ULL, 0x000fc600078e00ffULL, 0x0000001408007388ULL, 0x0003e60000000c00ULL,
0x017600100d1079a7ULL, 0x0002a4000850003fULL, 0x0000000000087805ULL, 0x002fce0000015200ULL,
0x017600110d0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a08137210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140bULL, 0x0000001304047211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000204047819ULL, 0x000fc8000000120bULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x017600110d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009000ff097b82ULL, 0x000e620000000800ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x3db504f306067820ULL, 0x010fe20000410000ULL,
0x000000083c087824ULL, 0x140fe400078e020dULL, 0xffffffff0f0a7836ULL, 0x000fe40000000000ULL,
0x000000203c0b7824ULL, 0x000fe400078e020dULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff147224ULL, 0x000fc400078e00ffULL, 0x0000000930097224ULL, 0x002fce00078e02ffULL,
0x000001000c377824ULL, 0x000fca00078e0203ULL, 0x000000373600720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x010fea0003800000ULL, 0x000000020c0e7836ULL, 0x000fe40000000000ULL,
0x0000000700077224ULL, 0x000fc600078e02ffULL, 0x0000000f0e00720cULL, 0x000fe40003f06070ULL,
0x00000001140e7812ULL, 0x000fd600078e0cffULL, 0x0000000c00b48947ULL, 0x000fea0003800000ULL,
0x00000003ff167819ULL, 0x004fe20000011604ULL, 0x0000010037137836ULL, 0x000fe20000000000ULL,
0x00008a0000047ab9ULL, 0x000fc60000000a00ULL, 0x00000008161c7836ULL, 0x000fe20000000000ULL,
0x0000001336107248ULL, 0x000fe20007fe0000ULL, 0x0000000105127824ULL, 0x000fe400078e0216ULL,
0x000000011c177824ULL, 0x140fe400078e0204ULL, 0x000000081c1e7824ULL, 0x000fe200078e00ffULL,
0x0000001207127210ULL, 0x000fe20007f1e0ffULL, 0x0000000416187836ULL, 0x000fe40000000000ULL,
0x0000000110137824ULL, 0x000fe200078e0a13ULL, 0xfffffff81e297812ULL, 0x000fe200078ee217ULL,
0x0000000118157824ULL, 0x000fc400078e0204ULL, 0x00000008181a7824ULL, 0x040fe200078e00ffULL,
0x000000131800720cULL, 0x080fe20003f66070ULL, 0x0000000c161e7836ULL, 0x000fe20000000000ULL,
0x000000131c00720cULL, 0x080fe20003f46070ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x0000000412197c11ULL, 0x040fe2000f8038ffULL, 0x0000000105107824ULL, 0x040fe200078e0218ULL,
0xfffffff81a277812ULL, 0x000fe200078ee215ULL, 0x0000000105187824ULL, 0x040fe200078e021eULL,
0x00000005121a7c11ULL, 0x000fe200080f3c11ULL, 0x0000000105127824ULL, 0x040fe200078e021cULL,
0x0000001007107210ULL, 0x000fe20007f3e0ffULL, 0x000000011e177824ULL, 0x100fe200078e0204ULL,
0x0000001807187210ULL, 0x000fe20007f1e0ffULL, 0x00000010161c7836ULL, 0x000fe20000000000ULL,
0x0000001207127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x00000004101b7c11ULL, 0x000fe2000f8238ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x000000131e00720cULL, 0x0c0fe20003f86070ULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0x0000000418257c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x0000000510217c11ULL, 0x000fe200088f3c21ULL, 0x0000001004107824ULL, 0x000fe200078e00ffULL,
0x00000004121d7c11ULL, 0x000fe2000f8a38ffULL, 0x000000011c227824ULL, 0x000fe200078e0204ULL,
0x0000000518267c11ULL, 0x000fe200080f3c11ULL, 0x0000000105187824ULL, 0x000fe200078e021cULL,
0xfffffff81e2b7812ULL, 0x000fe200078ee217ULL, 0x000040003c117824ULL, 0x000fe200078e020dULL,
0x00000005121e7c11ULL, 0x000fe2000a8f3c15ULL, 0x0000000116157824ULL, 0x000fe200078e0204ULL,
0x0000007010107812ULL, 0x000fe200078ec0ffULL, 0x000000081c2d7824ULL, 0x000fe200078e00ffULL,
0x0000001807207210ULL, 0x000fe20007fde0ffULL, 0x000020000e127824ULL, 0x000fe200078e0211ULL,
0x0000001019187210ULL, 0x000fe20007f3e0ffULL, 0x0000001816287836ULL, 0x000fe20000000000ULL,
0x000000131c00720cULL, 0x080fe20003fa6070ULL, 0x00000014161c7836ULL, 0x000fe20000000000ULL,
0x0000000715157812ULL, 0x000fe200078ec0ffULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x000000131600720cULL, 0x000fe20003f06070ULL, 0x000000ffff197224ULL, 0x000fe200008e061aULL,
0x0ffffff815157812ULL, 0x000fe200078ef804ULL, 0x00000001051a7824ULL, 0x000fe200078e021cULL,
0x00000004201f7c11ULL, 0x000fe2000f8238ffULL, 0x0000100012127836ULL, 0x000fe20000000000ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee222ULL, 0x000000011c227824ULL, 0x000fe200078e0204ULL,
0x0000000520207c11ULL, 0x000fe200088f3c17ULL, 0x0000001015157824ULL, 0x000fe200078e0212ULL,
0x0000001a07247210ULL, 0x000fe20007f3e0ffULL, 0x000000081c2f7824ULL, 0x000fc400078e00ffULL,
0x00000020162a7836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018157faeULL, 0x0003e2000c101c46ULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x000000131c00720cULL, 0x000fe20003f06070ULL, 0x00000001051c7824ULL, 0x000fe200078e0228ULL,
0x000000101b1a7210ULL, 0x000fe40007f3e0ffULL, 0x0000000424237c11ULL, 0x040fe4000f8c38ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee222ULL, 0x000000ffff1b7224ULL, 0x000fe200008e0621ULL,
0x0000000524247c11ULL, 0x000fe2000b0f3c17ULL, 0x0000000828227824ULL, 0x040fe200078e00ffULL,
0x0000001c071c7210ULL, 0x000fe20007fde0ffULL, 0x0000000128157824ULL, 0x002fe200078e0204ULL,
0x000000101d187210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x000000041c217c11ULL, 0x000fe2000f8c38ffULL, 0x000000ffff197224ULL, 0x000fe200008e061eULL,
0x000000132800720cULL, 0x000fe20003f26070ULL, 0x0000001c16287836ULL, 0x000fe20000000000ULL,
0xfffffff822317812ULL, 0x000fe200078ee215ULL, 0x0000001027157824ULL, 0x000fe200078e0212ULL,
0x000000051c1e7c11ULL, 0x000fe2000b0f3c17ULL, 0x00000001051c7824ULL, 0x000fe400078e0228ULL,
0x0000001029177824ULL, 0x000fe200078e0212ULL, 0x000000001a157faeULL, 0x0003e2000d901c46ULL,
0x0000000128277824ULL, 0x000fe200078e0204ULL, 0x0000001c07227210ULL, 0x000fc40007f7e0ffULL,
0x0000000018177faeULL, 0x0005e2000d101c46ULL, 0x000000132800720cULL, 0x040fe20003f46070ULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000000422297c11ULL, 0x040fe2000f8c38ffULL,
0x000000ffff1d7224ULL, 0x000fe200018e06ffULL, 0x00000010251c7210ULL, 0x000fe40007f7e0ffULL,
0xfffffff828337812ULL, 0x000fe200078ee227ULL, 0x00000001051a7824ULL, 0x002fe200078e022aULL,
0x0000000522227c11ULL, 0x000fe2000b0f3c1dULL, 0x000000ffff1d7224ULL, 0x000fc400018e0626ULL,
0x000000012a157824ULL, 0x040fe200078e0204ULL, 0x0000001a071a7210ULL, 0x000fe20007fde0ffULL,
0x000000082a267824ULL, 0x000fe200078e00ffULL, 0x000000101f187210ULL, 0x004fe20007f7e0ffULL,
0x000000102d177824ULL, 0x000fe400078e0212ULL, 0x000000ffff257224ULL, 0x000fe200030e06ffULL,
0x000000041a1f7c11ULL, 0x040fe2000f8c38ffULL, 0x000000ffff197224ULL, 0x000fe200018e0620ULL,
0xfffffff826397812ULL, 0x000fe200078ee215ULL, 0x0000002416267836ULL, 0x000fe20000000000ULL,
0x000000051a257c11ULL, 0x000fe2000b0f3c25ULL, 0x000000102b157824ULL, 0x000fe200078e0212ULL,
0x000000132a00720cULL, 0x000fe20003f66070ULL, 0x00000001051a7824ULL, 0x000fc400078e0226ULL,
0x00000028162a7836ULL, 0x000fe20000000000ULL, 0x000000001c157faeULL, 0x0003e2000e101c46ULL,
0x0000000126287824ULL, 0x040fe200078e0204ULL, 0x0000001a07207210ULL, 0x000fe20007f9e0ffULL,
0x00000008262b7824ULL, 0x040fe200078e00ffULL, 0x0000000018177faeULL, 0x0005e2000e901c46ULL,
0x000000132600720cULL, 0x000fe40003fa6070ULL, 0x000000ffff1b7224ULL, 0x000fe200020e06ffULL,
0x0000000420277c11ULL, 0x040fe4000f8c38ffULL, 0x00000010231a7210ULL, 0x000fe20007f9e0ffULL,
0x00000001051c7824ULL, 0x002fe200078e022aULL, 0x0000000520207c11ULL, 0x000fe2000b0f3c1bULL,
0x000000012a157824ULL, 0x040fe200078e0204ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee228ULL,
0x000000ffff1b7224ULL, 0x000fe200020e0624ULL, 0x0000001c071c7210ULL, 0x000fe20007fde0ffULL,
0x000000082a247824ULL, 0x000fe200078e00ffULL, 0x0000001021187210ULL, 0x004fe20007f9e0ffULL,
0x0000003016287836ULL, 0x000fc40000000000ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x000000041c217c11ULL, 0x040fe2000f8c38ffULL, 0x000000ffff197224ULL, 0x000fe200020e061eULL,
0xfffffff8242d7812ULL, 0x000fe200078ee215ULL, 0x0000002c16247836ULL, 0x000fe20000000000ULL,
0x000000051c1e7c11ULL, 0x000fe2000b0f3c17ULL, 0x000000102f157824ULL, 0x100fe200078e0212ULL,
0x000000132a00720cULL, 0x080fe20003f86070ULL, 0x0000001031177824ULL, 0x000fe400078e0212ULL,
0x00000001051c7824ULL, 0x000fe200078e0224ULL, 0x000000001a157faeULL, 0x0003e2000c101c46ULL,
0x0000000124267824ULL, 0x140fe200078e0204ULL, 0x000000132400720cULL, 0x040fe20003f06070ULL,
0x00000008242f7824ULL, 0x000fe200078e00ffULL, 0x0000000018177faeULL, 0x0005e2000c901c46ULL,
0x0000001c071c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000128247824ULL, 0x000fc400078e0204ULL,
0x0000000828317824ULL, 0x000fe200078e00ffULL, 0x000000041c237c11ULL, 0x040fe2000f8c38ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x00000010291a7210ULL, 0x002fe20007f3e0ffULL,
0x0000001033157824ULL, 0x000fe200078e0212ULL, 0xfffffff82f297812ULL, 0x000fe200078ee226ULL,
0x0000003416267836ULL, 0x000fe20000000000ULL, 0xfffffff8312f7812ULL, 0x000fe200078ee224ULL,
0x000000ffff1b7224ULL, 0x000fe200008e0622ULL, 0x000000051c247c11ULL, 0x000fe2000b0f3c1dULL,
0x0000000105187824ULL, 0x004fe200078e0228ULL, 0x000000132800720cULL, 0x000fe20003f26070ULL,
0x00000001261c7824ULL, 0x040fe200078e0204ULL, 0x000000001a157faeULL, 0x0003e2000d101c46ULL,
0x0000000826317824ULL, 0x000fe200078e00ffULL, 0x0000001807227210ULL, 0x000fe20007fde0ffULL,
0x0000003816287836ULL, 0x000fe20000000000ULL, 0x000000101f187210ULL, 0x000fe20007f5e0ffULL,
0x00000010391f7824ULL, 0x000fe200078e0212ULL, 0xfffffff831317812ULL, 0x000fe200078ee21cULL,
0x000000ffff177224ULL, 0x000fc400030e06ffULL, 0x000000ffff197224ULL, 0x000fe200010e0625ULL,
0x00000010271c7210ULL, 0x000fe40007f5e0ffULL, 0x0000000422257c11ULL, 0x040fe2000f8c38ffULL,
0x00000001051a7824ULL, 0x002fe200078e0226ULL, 0x00000000181f7faeULL, 0x0003e2000d901c46ULL,
0x000000ffff1d7224ULL, 0x000fe200010e0620ULL, 0x0000000522227c11ULL, 0x000fe2000b0f3c17ULL,
0x00000001281b7824ULL, 0x000fe200078e0204ULL, 0x000000132600720cULL, 0x000fe20003f46070ULL,
0x0000003c16267836ULL, 0x000fe20000000000ULL, 0x0000001a071a7210ULL, 0x000fe20007fde0ffULL,
0x000000102b157824ULL, 0x000fe200078e0212ULL, 0x0000001021167210ULL, 0x000fe20007f7e0ffULL,
0x0000000826277824ULL, 0x000fc400078e00ffULL, 0x0000000828187824ULL, 0x002fe200078e00ffULL,
0x000000001c157faeULL, 0x0003e2000e901c46ULL, 0x000000ffff197224ULL, 0x000fe200030e06ffULL,
0x000000041a217c11ULL, 0x000fe2000f8c38ffULL, 0x000000ffff177224ULL, 0x000fe200018e061eULL,
0xfffffff8181f7812ULL, 0x000fe200078ee21bULL, 0x0000000105187824ULL, 0x000fe200078e0228ULL,
0x000000132800720cULL, 0x080fe40003fa6070ULL, 0x000000132600720cULL, 0x000fe20003f66070ULL,
0x000000102d137824ULL, 0x000fe200078e0212ULL, 0x000000051a207c11ULL, 0x000fe2000b0f3c19ULL,
0x00000001051a7824ULL, 0x000fe200078e0226ULL, 0x00000018071e7210ULL, 0x000fe20007fde0ffULL,
0x00000001261c7824ULL, 0x002fe200078e0204ULL, 0x0000000016137faeULL, 0x0003e2000e101c46ULL,
0x0000001023187210ULL, 0x000fe20007f9e0ffULL, 0x0000001029157824ULL, 0x000fc400078e0212ULL,
0x000000ffff1d7224ULL, 0x000fe200030e06ffULL, 0x000000041e237c11ULL, 0x040fe2000f8c38ffULL,
0x000000ffff197224ULL, 0x000fe200020e0624ULL, 0x0000001a071b7210ULL, 0x000fe20007f9e0ffULL,
0x000000102f077824ULL, 0x100fe200078e0212ULL, 0x000000051e1e7c11ULL, 0x000fe2000b0f3c1dULL,
0x00000010311d7824ULL, 0x100fe200078e0212ULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x0000000018157faeULL, 0x0005e2000c101c46ULL, 0x0000001025167210ULL, 0x002fe20007fde0ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x000000041b137c11ULL, 0x000fe2000f8038ffULL,
0x000000101f1f7824ULL, 0x000fc400078e0212ULL, 0x000000ffff177224ULL, 0x000fe200030e0622ULL,
0x00000010211a7210ULL, 0x000fe20007fde0ffULL, 0x0000001027217824ULL, 0x000fe200078e0212ULL,
0x0000001023127210ULL, 0x000fe40007f9e0ffULL, 0x0000000016077faeULL, 0x0003e2000c901c46ULL,
0x000000051b157c11ULL, 0x004fe200080f3c1cULL, 0x000000ffff1b7224ULL, 0x000fe200030e0620ULL,
0x0000001013187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fc600020e061eULL,
0x000000001a1d7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff197224ULL, 0x000fc600000e0615ULL,
0x00000000121f7faeULL, 0x0003e8000e901c46ULL, 0x0000000018217faeULL, 0x0003e2000d901c46ULL,
0x0000000c00607947ULL, 0x000fea0003800000ULL, 0x0000000404117811ULL, 0x044fe200078fe8ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000804197811ULL, 0x040fe400078fe8ffULL,
0x0000000c041a7811ULL, 0x040fe200078fe8ffULL, 0x0000000111157824ULL, 0x140fe200078e0204ULL,
0x0000001c04237811ULL, 0x040fe200078fe8ffULL, 0x0000000811107824ULL, 0x000fe200078e00ffULL,
0x0000001804217811ULL, 0x040fe200078fe8ffULL, 0x00000001192d7824ULL, 0x140fe200078e0204ULL,
0x0000002404347811ULL, 0x000fe200078fe8ffULL, 0x000000011a2f7824ULL, 0x100fe200078e0204ULL,
0xfffffff810157812ULL, 0x000fe200078ee215ULL, 0x0000000819107824ULL, 0x000fe200078e00ffULL,
0x0000002c043a7811ULL, 0x000fe200078fe8ffULL, 0x000000081a127824ULL, 0x000fe200078e00ffULL,
0x0000002004247811ULL, 0x040fe200078fe8ffULL, 0x00000001232b7824ULL, 0x140fe200078e0204ULL,
0xfffffff8102d7812ULL, 0x000fe200078ee22dULL, 0x0000000823107824ULL, 0x000fe200078e00ffULL,
0xfffffff8122f7812ULL, 0x000fe200078ee22fULL, 0x00000001212c7824ULL, 0x140fe200078e0204ULL,
0x0000002804387811ULL, 0x000fe200078fe8ffULL, 0x0000000821137824ULL, 0x000fe200078e00ffULL,
0xfffffff8102b7812ULL, 0x000fe200078ee22bULL, 0x0000000134297824ULL, 0x100fe200078e0204ULL,
0x00000034043d7811ULL, 0x000fe200078fe8ffULL, 0x0000000834127824ULL, 0x000fe200078e00ffULL,
0xfffffff8132c7812ULL, 0x000fe200078ee22cULL, 0x000000013a277824ULL, 0x100fe200078e0204ULL,
0x00000014041c7811ULL, 0x000fe200078fe8ffULL, 0x000000083a107824ULL, 0x000fe200078e00ffULL,
0xfffffff812297812ULL, 0x000fe200078ee229ULL, 0x00000001242a7824ULL, 0x100fe200078e0204ULL,
0x00000030043b7811ULL, 0x000fe200078fe8ffULL, 0x0000000824177824ULL, 0x000fe200078e00ffULL,
0xfffffff810277812ULL, 0x000fe200078ee227ULL, 0x0000000138287824ULL, 0x100fe200078e0204ULL,
0x0000000504107211ULL, 0x000fe200078fe8ffULL, 0x0000000838137824ULL, 0x000fe200078e00ffULL,
0xfffffff8172a7812ULL, 0x000fe200078ee22aULL, 0x000000013d257824ULL, 0x140fe200078e0204ULL,
0x00000010041b7811ULL, 0x000fe200078fe8ffULL, 0x000000083d127824ULL, 0x000fe200078e00ffULL,
0xfffffff813287812ULL, 0x000fe200078ee228ULL, 0x000000011c337824ULL, 0x140fe200078e0204ULL,
0x0000000710137210ULL, 0x000fe20007f1e0ffULL, 0x000000081c187824ULL, 0x000fe200078e00ffULL,
0xfffffff812257812ULL, 0x000fe200078ee225ULL, 0x000000013b267824ULL, 0x040fe200078e0204ULL,
0x00000038043f7811ULL, 0x000fe200078fe8ffULL, 0x000000083b177824ULL, 0x000fe200078e00ffULL,
0xfffffff818337812ULL, 0x000fe200078ee233ULL, 0x0000000105127824ULL, 0x000fc400078e0211ULL,
0x000000011b317824ULL, 0x040fe200078e0204ULL, 0xfffffff817267812ULL, 0x000fe200078ee226ULL,
0x000000081b167824ULL, 0x000fe200078e00ffULL, 0x0000000712177210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x0000000413127c11ULL, 0x000fe2000f8038ffULL,
0x00000001051a7824ULL, 0x000fe200078e021aULL, 0xfffffff816317812ULL, 0x000fe200078ee231ULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000513137c11ULL, 0x000fe200080f3c18ULL,
0x0000000105187824ULL, 0x000fe200078e0219ULL, 0x0000000417167c11ULL, 0x000fe2000f8238ffULL,
0x0000000105227824ULL, 0x000fc400078e021cULL, 0x0000000105247824ULL, 0x000fe200078e0224ULL,
0x0000000517177c11ULL, 0x000fe200088f3c10ULL, 0x0000000105107824ULL, 0x000fe200078e021bULL,
0x0000000718197210ULL, 0x000fe20007f1e0ffULL, 0x000000013f2e7824ULL, 0x040fe200078e0204ULL,
0x000000071a1b7210ULL, 0x000fe20007f3e0ffULL, 0x000000083f117824ULL, 0x000fe200078e00ffULL,
0x00000007101d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x0000000419187c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x000000041b1a7c11ULL, 0x000fe2000f8238ffULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x0000000519197c11ULL, 0x000fe200080f3c20ULL, 0x0000000105207824ULL, 0x000fe200078e0221ULL,
0x000000041d1c7c11ULL, 0x000fe2000f8438ffULL, 0x0000000105427824ULL, 0x040fe200078e0234ULL,
0x00000007221f7210ULL, 0x000fe20007f1e0ffULL, 0x0000000105227824ULL, 0x000fe200078e0223ULL,
0x000000051d1d7c11ULL, 0x000fe200090f3c10ULL, 0x00000001053e7824ULL, 0x000fe200078e023bULL,
0x000000051b1b7c11ULL, 0x000fe200088f3c1eULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x000000041f1e7c11ULL, 0x000fe2000f8038ffULL, 0x0000000105407824ULL, 0x040fe200078e0238ULL,
0x0000000720217210ULL, 0x000fe20007f3e0ffULL, 0x00000001053a7824ULL, 0x000fe200078e023aULL,
0x000000051f1f7c11ULL, 0x000fe200080f3c10ULL, 0x0000000105347824ULL, 0x040fe200078e023dULL,
0x0000000722237210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x0000000724107210ULL, 0x000fe20007f7e0ffULL, 0x0000000105387824ULL, 0x000fe200078e023fULL,
0xfffffff8112e7812ULL, 0x000fe200078ee22eULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x0000000423227c11ULL, 0x000fe2000f8238ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x0000000410247c11ULL, 0x000fc4000f8438ffULL, 0x0000000421207c11ULL, 0x000fe4000f8038ffULL,
0x0000000523237c11ULL, 0x000fe400088f3c30ULL, 0x0000000404307211ULL, 0x000fe400078fe8ffULL,
0x0000000510107c11ULL, 0x000fe200090f3c11ULL, 0x000040003c117824ULL, 0x000fe200078e020dULL,
0x0000000521217c11ULL, 0x000fe400080f3c32ULL, 0x0000003c04327811ULL, 0x000fc400078fe8ffULL,
0x0000000730397812ULL, 0x000fe200078ec0ffULL, 0x000020000e307824ULL, 0x000fe200078e0211ULL,
0x0000000742427210ULL, 0x000fe20007fde0ffULL, 0x0000000105447824ULL, 0x000fe200078e0232ULL,
0x0ffffff839397812ULL, 0x000fe200078ef804ULL, 0x00000001323b7824ULL, 0x040fe200078e0204ULL,
0x0000000740407210ULL, 0x000fe20007fbe0ffULL, 0x0000000832467824ULL, 0x000fe200078e00ffULL,
0x000000073e3e7210ULL, 0x000fe20007f3e0ffULL, 0x0000100030327836ULL, 0x000fe20000000000ULL,
0x000000073a307210ULL, 0x000fc40007f1e0ffULL, 0x00000007343a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001027437824ULL, 0x100fe200078e0232ULL, 0x0000000738387210ULL, 0x000fe20007f7e0ffULL,
0x0000001026457824ULL, 0x100fe200078e0232ULL, 0x0000000744347210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff277224ULL, 0x000fe200030e06ffULL, 0x0000000442267c11ULL, 0x040fe2000f8c38ffULL,
0x00000010293f7824ULL, 0x100fe200078e0232ULL, 0xfffffff8464b7812ULL, 0x000fe200078ee23bULL,
0x0000001039077824ULL, 0x100fe200078e0232ULL, 0x0000000542427c11ULL, 0x000fe2000b0f3c27ULL,
0x0000001025477824ULL, 0x000fc400078e0232ULL, 0x0000001004297824ULL, 0x000fe400078e00ffULL,
0x000000102c397824ULL, 0x100fe400078e0232ULL, 0x000000102b3b7824ULL, 0x100fe200078e0232ULL,
0x00000070294d7812ULL, 0x000fe200078ec0ffULL, 0x0000001028417824ULL, 0x100fe400078e0232ULL,
0x000000ffff277224ULL, 0x000fe200028e06ffULL, 0x0000000440287c11ULL, 0x000fe2000f8a38ffULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x000000043e2c7c11ULL, 0x000fe2000f8238ffULL,
0x000000102a3d7824ULL, 0x100fe200078e0232ULL, 0x0000000540407c11ULL, 0x000fe2000a8f3c27ULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x00000004302a7c11ULL, 0x000fe2000f8038ffULL,
0x000000102e497824ULL, 0x100fe200078e0232ULL, 0x000000053e3e7c11ULL, 0x000fe200088f3c25ULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x00000005302b7c11ULL, 0x000fe200080f3c2bULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x000000043a2e7c11ULL, 0x000fe2000f8238ffULL,
0x0000001015157824ULL, 0x100fe200078e0232ULL, 0x0000000438307c11ULL, 0x000fe2000f8438ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0232ULL, 0x0000004d12127210ULL, 0x000fe20007f1e0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0232ULL, 0x000000053a3a7c11ULL, 0x000fe200088f3c29ULL,
0x0000001031317824ULL, 0x100fe200078e0232ULL, 0x0000000538387c11ULL, 0x000fe200090f3c27ULL,
0x0000001033337824ULL, 0x100fe200078e0232ULL, 0x0000004d16167210ULL, 0x000fe20007f3e0ffULL,
0x000000104b4b7824ULL, 0x000fe200078e0232ULL, 0x0000000434327c11ULL, 0x040fe2000f8638ffULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x0000004d18187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000004d1c1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x0000000534347c11ULL, 0x000fe200098f3c25ULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x0000004d1a1a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e061dULL, 0x0000004d1e1e7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012077faeULL, 0x000fe2000b901c46ULL,
0x0000004d20207210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x0000004d22227210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200020e061fULL,
0x0000004d24247210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x0000004d26267210ULL, 0x000fe20007f7e0ffULL, 0x0000000016157faeULL, 0x000fe2000b901c46ULL,
0x0000004d28287210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff237224ULL, 0x000fe200008e0623ULL,
0x0000004d2a2a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000182d7faeULL, 0x0003e2000b901c46ULL,
0x0000004d2c2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff257224ULL, 0x000fe200010e0610ULL,
0x0000004d2e2e7210ULL, 0x000fe20007f3e0ffULL, 0x000000001a2f7faeULL, 0x0007e2000b901c46ULL,
0x0000004d30307210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff277224ULL, 0x000fe200018e0642ULL,
0x0000004d32327210ULL, 0x000fe20007f7e0ffULL, 0x000000001c317faeULL, 0x0009e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fc400028e0640ULL, 0x000000ffff2b7224ULL, 0x000fe200020e062bULL,
0x000000001e337faeULL, 0x000be2000b901c46ULL, 0x000000ffff2d7224ULL, 0x002fc600000e063eULL,
0x0000000020397faeULL, 0x0005e2000b901c46ULL, 0x000000ffff2f7224ULL, 0x008fc600008e063aULL,
0x00000000223b7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff317224ULL, 0x010fc600010e0638ULL,
0x00000000243d7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff337224ULL, 0x020fc600018e0634ULL,
0x00000000263f7faeULL, 0x0005e8000b901c46ULL, 0x0000000028417faeULL, 0x0005e8000b901c46ULL,
0x000000002a437faeULL, 0x0005e8000b901c46ULL, 0x000000002c457faeULL, 0x0005e8000b901c46ULL,
0x000000002e477faeULL, 0x0005e8000b901c46ULL, 0x0000000030497faeULL, 0x0005e8000b901c46ULL,
0x00000000324b7faeULL, 0x0005e4000b901c46ULL, 0x0000000402027836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff077424ULL, 0x002fc600078e00ffULL,
0x000000350200720cULL, 0x000fda0003f06070ULL, 0x00008c00ff128b82ULL, 0x000e620000000a00ULL,
0x0000000209158824ULL, 0x000fe400078e0202ULL, 0x0000002004107836ULL, 0x000fe20000000000ULL,
0x00000007043f7812ULL, 0x004fe200078ec0ffULL, 0x00002000143e7824ULL, 0x000fe200078e0211ULL,
0xfffffff804117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x00000004ff3d7819ULL, 0x000fe40000011604ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000415128825ULL, 0x002fe200078e0012ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000612078981ULL, 0x000322000c1e1900ULL,
0x000010003e3e7836ULL, 0x000fe20000000000ULL, 0x0000000711447812ULL, 0x000fe400078ef804ULL,
0x000000083f457812ULL, 0x000fe400078ef804ULL, 0xfffffff810137812ULL, 0x002fc800078ec0ffULL,
0x0000000713347812ULL, 0x000fce00078ef804ULL, 0x0000000144107824ULL, 0x140fe400078e0247ULL,
0x0000000844117824ULL, 0x000fe400078e00ffULL, 0x0000000134147824ULL, 0x040fe400078e0247ULL,
0x0000000834157824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee210ULL,
0x0000000147497836ULL, 0x000fe40000000000ULL, 0x0000000247607824ULL, 0x000fe200078e023dULL,
0xfffffff815157812ULL, 0x000fe200078ee214ULL, 0x0000001011117824ULL, 0x000fc400078e023eULL,
0x0000000247477836ULL, 0x000fe40000000000ULL, 0x0000001015157824ULL, 0x000fe400078e023eULL,
0x000000001110783bULL, 0x000e620000000200ULL, 0x000000084700780cULL, 0x000fc60003f05270ULL,
0x000000001514783bULL, 0x000ea20000000200ULL, 0x00000018ff567819ULL, 0x002fe20000011410ULL,
0x00010000101c7824ULL, 0x040fe200078e00ffULL, 0x00008880105a7816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011411ULL,
0x00010000111d7824ULL, 0x040fe200078e00ffULL, 0x00008880115d7816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005600567306ULL, 0x000fe20000202400ULL, 0x00000018ff657819ULL, 0x000fc40000011412ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880125e7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe20000011413ULL, 0x00000010005f7306ULL, 0x0002e20000202400ULL,
0x0000888013707816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff687819ULL, 0x004fe20000011414ULL,
0x00000011005c7306ULL, 0x0005e20000202400ULL, 0x0001000012107824ULL, 0x002fe200078e00ffULL,
0x00008880146c7816ULL, 0x000fe200000000ffULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011415ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000013117824ULL, 0x044fe200078e00ffULL,
0x0000001c00797306ULL, 0x000fe20000202400ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00008880156a7816ULL, 0x000fc400000000ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000001200727306ULL, 0x0003e20000202400ULL,
0x00000018ff587819ULL, 0x000fe40000011416ULL, 0x00000018ff467819ULL, 0x000fe40000011417ULL,
0x0000888016667816ULL, 0x000fe400000000ffULL, 0x0000888017627816ULL, 0x000fe200000000ffULL,
0x0000001100757306ULL, 0x0005e20000202400ULL, 0x0000000844127824ULL, 0x002fce00078e00ffULL,
0x00000013006e7306ULL, 0x0003e20000202400ULL, 0x0000000144117824ULL, 0x104fe400078e0249ULL,
0x0000000134497824ULL, 0x000fca00078e0249ULL, 0x0000001d00747306ULL, 0x0005e20000202400ULL,
0xfffffff812137812ULL, 0x002fe200078ee211ULL, 0x0001000015117824ULL, 0x040fe400078e00ffULL,
0x0000010015157824ULL, 0x000fe400078e00ffULL, 0x0000001013137824ULL, 0x000fe200078e023eULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000001000777306ULL, 0x0003e20000202400ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000000131c783bULL, 0x004eaa0000000200ULL,
0x00000015006d7306ULL, 0x000be20000202400ULL, 0x0001000014107824ULL, 0x002fc400078e00ffULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001045157824ULL, 0x020fe200078e00ffULL,
0x0000001000737306ULL, 0x0003f00000202400ULL, 0x0000001400717306ULL, 0x000be20000202400ULL,
0x0000000834107824ULL, 0x002fca00078e00ffULL, 0xfffffff810497812ULL, 0x000fe200078ee249ULL,
0x0001000016107824ULL, 0x040fe200078e00ffULL, 0x00000011006f7306ULL, 0x0003e20000202400ULL,
0x0001000017147824ULL, 0x060fe400078e00ffULL, 0x0000010016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011410ULL, 0x0000010017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000001049117824ULL, 0x002fe200078e023eULL, 0x0000001400637306ULL, 0x0003e20000202400ULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x00000018ff487819ULL, 0x004fe4000001141cULL,
0x000088801c4a7816ULL, 0x040fe200000000ffULL, 0x000000001110783bULL, 0x000ea20000000200ULL,
0x00000018ff507819ULL, 0x000fe2000001141dULL, 0x0000001600697306ULL, 0x000fe20000202400ULL,
0x000100001c147824ULL, 0x042fe200078e00ffULL, 0x000088801d527816ULL, 0x000fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001141eULL,
0x00000018ff517819ULL, 0x000fe20000011414ULL, 0x0000000145147824ULL, 0x000fe200078e0260ULL,
0x0000001700617306ULL, 0x0003e20000202400ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x000088801e547816ULL, 0x000fe400000000ffULL, 0xfffffff015147812ULL, 0x000fe200078ee214ULL,
0x000100001d157824ULL, 0x040fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001141fULL,
0x0000005a005a7306ULL, 0x000f620000202400ULL, 0x000001001d1d7824ULL, 0x000fe400078e00ffULL,
0x0000001014147824ULL, 0x000fe200078e020dULL, 0x00000018ff577819ULL, 0x000fe40000011415ULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x0000001c00537306ULL, 0x0007e20000202400ULL,
0x000000001414783bULL, 0x002e6e0000000200ULL, 0x0000001d00557306ULL, 0x0005e20000202400ULL,
0x000100001e1c7824ULL, 0x048fe400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000054105f1d7816ULL, 0x004fe40000000056ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff4d7819ULL, 0x000fe40000011410ULL, 0x00000018ff4c7819ULL, 0x000fe20000011411ULL,
0x0000001c00597306ULL, 0x000be20000202400ULL, 0x00000018ff4b7819ULL, 0x000fc40000011412ULL,
0x00000018ff497819ULL, 0x000fca0000011413ULL, 0x0000005d005d7306ULL, 0x000ea20000202400ULL,
0x000054105a1c7816ULL, 0x020fe40000000079ULL, 0x000088801f5a7816ULL, 0x000fca00000000ffULL,
0x0000006500657306ULL, 0x000ee20000202400ULL, 0x0000001c1440723cULL, 0x002fee0000041840ULL,
0x000100001f1d7824ULL, 0x000fe200078e00ffULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x000054105d1c7816ULL, 0x004fe20000000074ULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000888011747816ULL, 0x000fc400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000001e00567306ULL, 0x0003f00000202400ULL,
0x0000001d005f7306ULL, 0x0005e20000202400ULL, 0x00008880101e7816ULL, 0x002fce00000000ffULL,
0x0000006700677306ULL, 0x000e620000202400ULL, 0x000054105c1d7816ULL, 0x004fe2000000005bULL,
0x00010000105c7824ULL, 0x040fe400078e00ffULL, 0x0000010010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000001c1438723cULL, 0x000fe20000041838ULL,
0x0000007000707306ULL, 0x000eac0000202400ULL, 0x00000018ff1c7819ULL, 0x000fe20000011410ULL,
0x00000010451d7824ULL, 0x040fe200078e00ffULL, 0x0000000245107810ULL, 0x000fe20007ffe060ULL,
0x0000001e005b7306ULL, 0x000be60000202400ULL, 0xfffffff01d107812ULL, 0x000fc400078ee210ULL,
0x00005410721d7816ULL, 0x008fe20000000065ULL, 0x0000010011727824ULL, 0x040fe400078e00ffULL,
0x0000001c00607306ULL, 0x0007e20000202400ULL, 0x00010000111e7824ULL, 0x020fe200078e00ffULL,
0x000054106e117816ULL, 0x002fe20000000067ULL, 0x0000001010107824ULL, 0x000fe200078e020dULL,
0x00000018ff677819ULL, 0x000fe20000011472ULL, 0x00010000126e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe4000001141eULL, 0x0000006c006c7306ULL, 0x000e620000202400ULL,
0x000054105e1c7816ULL, 0x008fce0000000077ULL, 0x0000001f005d7306ULL, 0x0007e20000202400ULL,
0x0000001c1430723cULL, 0x000fee0000041830ULL, 0x0000006800687306ULL, 0x000f620000202400ULL,
0x00000000101c783bULL, 0x0084ee0000000200ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x0000541070107816ULL, 0x004fce0000000075ULL, 0x0000006a006a7306ULL, 0x000ea20000202400ULL,
0x00000010142c723cULL, 0x000fee000004182cULL, 0x0000888012117816ULL, 0x000fe200000000ffULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x000054106c107816ULL, 0x002fe20000000073ULL,
0x0000010012127824ULL, 0x000fc400078e00ffULL, 0x000000ffff6c7224ULL, 0x000fe200078e0011ULL,
0x0000541071117816ULL, 0x020fe40000000068ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000006600667306ULL, 0x000fe80000202400ULL, 0x000000101428723cULL, 0x000fe80000041828ULL,
0x0000006b006b7306ULL, 0x000e660000202400ULL, 0x000054106a107816ULL, 0x004fc4000000006fULL,
0x000054106d117816ULL, 0x000fe40000000064ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146eULL,
0x0000004600467306ULL, 0x000fe80000202400ULL, 0x000000101424723cULL, 0x000fe80000041824ULL,
0x0000006200627306ULL, 0x000ea60000202400ULL, 0x0000541066107816ULL, 0x002fc4000000006bULL,
0x0000541069117816ULL, 0x000fe40000000058ULL, 0x0000888013587816ULL, 0x000fe200000000ffULL,
0x0000004800487306ULL, 0x000fe80000202400ULL, 0x000000101420723cULL, 0x000fe80000041820ULL,
0x0000004a004a7306ULL, 0x000fe60000202400ULL, 0x0000541062107816ULL, 0x004fc40000000063ULL,
0x0000541061117816ULL, 0x000fe20000000046ULL, 0x000000ffff467224ULL, 0x000fe400078e0058ULL,
0x0000005100517306ULL, 0x000e680000202400ULL, 0x000000101418723cULL, 0x000fe80000041818ULL,
0x0000005000507306ULL, 0x000ea60000202400ULL, 0x0001000013117824ULL, 0x000fc400078e00ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x000054104a107816ULL, 0x002fe40000000051ULL,
0x0000004e004e7306ULL, 0x000e620000202400ULL, 0x00000018ff157819ULL, 0x000fe40000011411ULL,
0x0000541053117816ULL, 0x000fe40000000048ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000541055537816ULL, 0x004fe20000000050ULL, 0x0000005a005a7306ULL, 0x000ea40000202400ULL,
0x000000101c40723cULL, 0x008fe20000041840ULL, 0x000054105d177816ULL, 0x002fca000000004eULL,
0x0000004f004f7306ULL, 0x000e620000202400ULL, 0x000054105a167816ULL, 0x004fce000000005fULL,
0x0000004d004d7306ULL, 0x000ea20000202400ULL, 0x000000161c2c723cULL, 0x000fe2000004182cULL,
0x0000541056557816ULL, 0x002fcc000000004fULL, 0x0000004c004c7306ULL, 0x000fe20000202400ULL,
0x00005410605d7816ULL, 0x004fce000000004dULL, 0x0000004b004b7306ULL, 0x000ff00000202400ULL,
0x0000004900497306ULL, 0x000ff00000202400ULL, 0x0000005200527306ULL, 0x000ff00000202400ULL,
0x0000005700577306ULL, 0x000e700000202400ULL, 0x0000005400547306ULL, 0x000ea20000202400ULL,
0x0000541052527816ULL, 0x002fce0000000057ULL, 0x0000005c005c7306ULL, 0x000e620000202400ULL,
0x000000521c38723cULL, 0x000fe20000041838ULL, 0x0000541054547816ULL, 0x004fcc0000000059ULL,
0x00000074005e7306ULL, 0x000fe20000202400ULL, 0x000000541c30723cULL, 0x000fe20000041830ULL,
0x000054105b5c7816ULL, 0x002fcc000000005cULL, 0x0000006500657306ULL, 0x000e620000202400ULL,
0x0000005c1c28723cULL, 0x000fee0000041828ULL, 0x0000006700677306ULL, 0x000ea20000202400ULL,
0x000054105e5e7816ULL, 0x002fce0000000065ULL, 0x0000006c00687306ULL, 0x000fe20000202400ULL,
0x00005410675f7816ULL, 0x004fce000000004cULL, 0x0000006d006d7306ULL, 0x000e620000202400ULL,
0x0000005e1c24723cULL, 0x000fee0000041824ULL, 0x0000001200127306ULL, 0x000ea20000202400ULL,
0x00005410684a7816ULL, 0x002fce000000006dULL, 0x0000004600147306ULL, 0x000fe20000202400ULL,
0x00005410124b7816ULL, 0x004fce000000004bULL, 0x0000001500117306ULL, 0x000e620000202400ULL,
0x0000004a1c20723cULL, 0x000fee0000041820ULL, 0x0000001300107306ULL, 0x000ea20000202400ULL,
0x0000541014147816ULL, 0x002fe40000000011ULL, 0x0000541010157816ULL, 0x004fce0000000049ULL,
0x000000141c18723cULL, 0x000fe20000041818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff000280947ULL, 0x000fde000383ffffULL, 0x00000001ff117424ULL, 0x000fe400078e00ffULL,
0x0000000620167220ULL, 0x080fe20000410000ULL, 0x0000000621177220ULL, 0x080fe20000410000ULL,
0x0000000640157220ULL, 0x080fe20000410000ULL, 0x0000000641417220ULL, 0x080fe20000410000ULL,
0x0000000642427220ULL, 0x080fe20000410000ULL, 0x01768811081079a7ULL, 0x000262000850003fULL,
0x0000000643437220ULL, 0x080fe20000410000ULL, 0x0000000638387220ULL, 0x080fe20000410000ULL,
0x0000000639397220ULL, 0x080fe20000410000ULL, 0x000000063a3a7220ULL, 0x080fe20000410000ULL,
0x000000063b3b7220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000632327220ULL, 0x080fe20000410000ULL,
0x0000000633337220ULL, 0x080fe20000410000ULL, 0x000000062c2c7220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x000000062e2e7220ULL, 0x080fe20000410000ULL,
0x000000062f2f7220ULL, 0x080fe20000410000ULL, 0x0000000628147220ULL, 0x080fe20000410000ULL,
0x0000000629297220ULL, 0x080fe20000410000ULL, 0x000000062a2a7220ULL, 0x080fe20000410000ULL,
0x000000062b2b7220ULL, 0x080fe20000410000ULL, 0x0000000624247220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x0000000626267220ULL, 0x080fe20000410000ULL,
0x0000000627277220ULL, 0x080fe20000410000ULL, 0x0000000622227220ULL, 0x080fe20000410000ULL,
0x0000000623237220ULL, 0x080fe20000410000ULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061a207220ULL, 0x080fe20000410000ULL,
0x000000061b217220ULL, 0x002fce0000410000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x01768811080075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x0000001a121d7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e13ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x0000001d1a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x01768811080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000404107824ULL, 0x000fe200078e00ffULL,
0x0000000a0c00720cULL, 0x000fe20003f05270ULL, 0x000000803c117824ULL, 0x000fc600078e020dULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x0000000111287824ULL, 0x000fca00078e0210ULL,
0x0174000028107984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x00000002041a7824ULL, 0x000fe400078e00ffULL, 0x0000000136377824ULL, 0x000fc600078e0a37ULL,
0x000000061a1a7812ULL, 0x000fc800078ec0ffULL, 0x000000011a1c7812ULL, 0x040fe400078efcffULL,
0x000000081a1e7812ULL, 0x000fe400078efcffULL, 0x000000371c00720cULL, 0x080fe40003f26070ULL,
0x000000101a1c7812ULL, 0x000fe400078efcffULL, 0x000000371e00720cULL, 0x080fe40003f06070ULL,
0x000000371c00720cULL, 0x000fc40003fc6070ULL, 0x000000111a1e7812ULL, 0x040fe400078efcffULL,
0x000000181a1c7812ULL, 0x040fe400078efcffULL, 0x000000371a00720cULL, 0x080fe40003f46070ULL,
0x000000371e00720cULL, 0x080fe40003fa6070ULL, 0x000000371c00720cULL, 0x000fe40003f66070ULL,
0x000000091a347812ULL, 0x000fc400078efcffULL, 0x000000191a1e7812ULL, 0x040fe400078efcffULL,
0x000000201a1c7812ULL, 0x000fe400078efcffULL, 0xff80000042427808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40005000000ULL, 0xff80000043437808ULL, 0x000fe40004800000ULL,
0xff80000041417808ULL, 0x000fc40004800000ULL, 0x000000373400720cULL, 0x080fe40003f86070ULL,
0x000000371e00720cULL, 0x080fe40003f46070ULL, 0x000000371c00720cULL, 0x000fe40003f26070ULL,
0x000000211a1e7812ULL, 0x040fe400078efcffULL, 0x000000281a1c7812ULL, 0x000fe400078efcffULL,
0xff8000003a3a7808ULL, 0x000fc40004000000ULL, 0xff80000038387808ULL, 0x000fe40004000000ULL,
0xff8000003b3b7808ULL, 0x000fe40006000000ULL, 0xff80000039397808ULL, 0x000fe40006000000ULL,
0x000000371e00720cULL, 0x080fe40003f06070ULL, 0x000000371c00720cULL, 0x000fe40003f86070ULL,
0x000000291a1e7812ULL, 0x000fc400078efcffULL, 0x000000301a1c7812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40007000000ULL, 0xff80000030307808ULL, 0x000fe40007000000ULL,
0xff80000033337808ULL, 0x000fe40006800000ULL, 0xff80000031317808ULL, 0x000fe40006800000ULL,
0x000000371e00720cULL, 0x000fc40003fc6070ULL, 0x000000371c00720cULL, 0x000fe40003fa6070ULL,
0x000000311a1e7812ULL, 0x040fe400078efcffULL, 0x000000381a1c7812ULL, 0x040fe400078efcffULL,
0x000000391a1a7812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fe40005800000ULL,
0xff8000002c2c7808ULL, 0x000fc40005800000ULL, 0xff8000002f2f7808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40005000000ULL, 0xff8000002a2a7808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fe40004800000ULL, 0x000000371e00720cULL, 0x080fe40003f66070ULL,
0x000000371c00720cULL, 0x000fc40003f46070ULL, 0x000000371a00720cULL, 0x000fe40003f26070ULL,
0xff8000002b2b7808ULL, 0x000fe40004000000ULL, 0xff80000029297808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000024247808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fc40007000000ULL, 0xff80000025257808ULL, 0x000fe40007000000ULL,
0xff80000022227808ULL, 0x000fe40006800000ULL, 0xff80000016167808ULL, 0x000fe40006800000ULL,
0xff80000023237808ULL, 0x000fe40005800000ULL, 0xff80000017177808ULL, 0x000fe40005800000ULL,
0xff80000020207808ULL, 0x000fc40005000000ULL, 0xff80000018187808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0xff80000019197808ULL, 0x000fce0004800000ULL,
0x000000151000720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x000000010c0c7836ULL, 0x000fe40000000000ULL, 0x0000001015107208ULL, 0x000fc80004000000ULL,
0x000000411000720bULL, 0x000fc80003f1e000ULL, 0x00000010411b7208ULL, 0x000fc80004000000ULL,
0x000000381b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b38107208ULL, 0x000fc80004000000ULL,
0x000000391000720bULL, 0x000fc80003f1e000ULL, 0x00000010391b7208ULL, 0x000fc80004000000ULL,
0x000000301b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b30107208ULL, 0x000fc80004000000ULL,
0x000000311000720bULL, 0x000fc80003f1e000ULL, 0x00000010311b7208ULL, 0x000fc80004000000ULL,
0x0000002c1b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b2c107208ULL, 0x000fc80004000000ULL,
0x0000002d1000720bULL, 0x000fc80003f1e000ULL, 0x000000102d1b7208ULL, 0x000fc80004000000ULL,
0x000000141b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b14107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x00000010291b7208ULL, 0x000fc80004000000ULL,
0x000000241b00720bULL, 0x000fc80003f1e000ULL, 0x0000001b24107208ULL, 0x000fe40004000000ULL,
0x000000421100720bULL, 0x000fe40003f1e000ULL, 0x000000251000720bULL, 0x000fc80003f3e000ULL,
0x00000010251b7208ULL, 0x000fe40004800000ULL, 0x0000001142107208ULL, 0x000fe40004000000ULL,
0x000000161b00720bULL, 0x000fe40003f3e000ULL, 0x000000431000720bULL, 0x000fe40003f1e000ULL,
0x0000001b161a7208ULL, 0x000fe40004800000ULL, 0x0000001043117208ULL, 0x000fc40004000000ULL,
0x000000171a00720bULL, 0x000fe40003f3e000ULL, 0x0000003a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001a171b7208ULL, 0x000fe40004800000ULL, 0x000000113a107208ULL, 0x000fe40004000000ULL,
0x000000181b00720bULL, 0x000fe40003f3e000ULL, 0x0000003b1000720bULL, 0x000fc40003f1e000ULL,
0x0000001b181a7208ULL, 0x000fe40004800000ULL, 0x000000103b117208ULL, 0x000fe40004000000ULL,
0x000000191a00720bULL, 0x000fe40003f3e000ULL, 0x000000321100720bULL, 0x000fe40003f1e000ULL,
0x0000001a191a7208ULL, 0x000fe40004800000ULL, 0x0000001132107208ULL, 0x000fc60004000000ULL,
0x0c401f001a1b7f89ULL, 0x000ee200000e0000ULL, 0x000000331000720bULL, 0x000fc80003f1e000ULL,
0x0000001033117208ULL, 0x000fc80004000000ULL, 0x0000002e1100720bULL, 0x000fc80003f1e000ULL,
0x000000112e107208ULL, 0x000fc80004000000ULL, 0x0000002f1000720bULL, 0x000fc80003f1e000ULL,
0x000000102f117208ULL, 0x000fe40004000000ULL, 0x0000001b1a00720bULL, 0x008fe40003f3e000ULL,
0x0000002a1100720bULL, 0x000fe40003f1e000ULL, 0x0000001a1b1b7208ULL, 0x000fe40004800000ULL,
0x000000112a107208ULL, 0x000fc60004000000ULL, 0x0c201f001b1a7f89ULL, 0x000ee200000e0000ULL,
0x0000002b1000720bULL, 0x000fc80003f1e000ULL, 0x000000102b117208ULL, 0x000fc80004000000ULL,
0x000000261100720bULL, 0x000fc80003f1e000ULL, 0x0000001126107208ULL, 0x000fc80004000000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x0000001027117208ULL, 0x000fe40004000000ULL,
0x0000001a1b00720bULL, 0x008fe40003f3e000ULL, 0x000000221100720bULL, 0x000fe40003f1e000ULL,
0x0000001b1a107208ULL, 0x000fe40004800000ULL, 0x00000011221a7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b101c7820ULL, 0x000fe20000410000ULL, 0x000000231a00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b2c1d7823ULL, 0x100fe2000001081cULL, 0x0000001a23117208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b142c7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b41417823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL, 0x000000201100720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001081cULL, 0x00000041001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081cULL, 0x00000011201a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001081cULL, 0x000000211a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081cULL, 0x00000030001b7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2d1f7823ULL, 0x100fe2000001081cULL, 0x0000001a211a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b292d7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b16297823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001081cULL,
0x0c401f001a117f89ULL, 0x000f6200000e0000ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b17307823ULL, 0x008fce000001081cULL, 0x00000018003d7308ULL, 0x000ff00000000800ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x000000111a00720bULL, 0x020fce0003f1e000ULL,
0x0000003900397308ULL, 0x000ee20000000800ULL, 0x0000001a11117208ULL, 0x000fca0004000000ULL,
0x0c201f0011147f89ULL, 0x000f6400000e0000ULL, 0x0000003100347308ULL, 0x000fe20000000800ULL,
0x000000383916723eULL, 0x008fce00000010ffULL, 0x0000002400317308ULL, 0x0007f00000000800ULL,
0x0000001d00377308ULL, 0x000fe20000000800ULL, 0x000000141100720bULL, 0x020fce0003f1e000ULL,
0x0000001f003e7308ULL, 0x000fe20000000800ULL, 0x0000001114117208ULL, 0x000fe40004000000ULL,
0x000000151e14723eULL, 0x000fc600000010ffULL, 0x3fb8aa3b11417820ULL, 0x000fe40000410000ULL,
0x0000001900447308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2a1a7823ULL, 0x100fe20000010841ULL,
0x00000004ff2a7e24ULL, 0x000fe2000f8e00ffULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b247823ULL, 0x108fe20000010841ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010841ULL, 0x3f8000002a2a783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b26267823ULL, 0x000fe20000010841ULL, 0x0000004300437308ULL, 0x000ee20000000800ULL,
0x000000ffff2b7224ULL, 0x000fc400078e002aULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b20207823ULL, 0x000fc60000010841ULL,
0x0000003a00177308ULL, 0x000fe20000000800ULL, 0x000000424315723eULL, 0x008fce00000010ffULL,
0x0000003b00187308ULL, 0x0007700000000800ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x000000ffff3b7224ULL, 0x008fe200078e002aULL, 0x000000171817723eULL, 0x020fcc00000010ffULL,
0x0000003300197308ULL, 0x000ee20000000800ULL, 0x0000001b3418723eULL, 0x000fe200000010ffULL,
0x0000002a141c723cULL, 0x000fec00000418ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0c401f00122b7f89ULL, 0x000f6200000e0000ULL, 0x000000321919723eULL, 0x008fcc00000010ffULL,
0x0000002f002f7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b22327823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b21417823ULL, 0x000fe20000010841ULL, 0x0c401f0013227f89ULL, 0x000f6200000e0000ULL,
0x000000ffff427224ULL, 0x000fc800078e0019ULL, 0x0000002500407308ULL, 0x000b620000000800ULL,
0x0000002e2f1b723eULL, 0x008fce00000010ffULL, 0x0000001a003a7308ULL, 0x0007e20000000800ULL,
0x000000ffff257224ULL, 0x020fe200078e002aULL, 0x0000002b1200720bULL, 0x000fe20003f1e000ULL,
0x000000ffff437224ULL, 0x000fc600078e001bULL, 0x000000122b127208ULL, 0x000fe20004000000ULL,
0x000008003c2b7824ULL, 0x000fe200078e020dULL, 0x0000002400337308ULL, 0x000b620000000800ULL,
0x000000373e1a723eULL, 0x008fe400000010ffULL, 0x000000221300720bULL, 0x002fe20003f3e000ULL,
0x000110002b2b7836ULL, 0x000fc60000000000ULL, 0x0000001322137208ULL, 0x000fe20004800000ULL,
0x0000002600387308ULL, 0x000fe20000000800ULL, 0x000000ffff247224ULL, 0x120fe200078e002aULL,
0x0000003d4422723eULL, 0x000fe400000010ffULL, 0x0c201f0013347f89ULL, 0x000e6800000e0000ULL,
0x0000002700397308ULL, 0x0007700000000800ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x000000241824723cULL, 0x008fee000004181cULL, 0x0000002d002d7308ULL, 0x000ee20000000800ULL,
0x00000031401e723eULL, 0x000fe200000010ffULL, 0x000000ffff407224ULL, 0x000fe200078e0015ULL,
0x0000003a331d723eULL, 0x000fe200000010ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e002aULL,
0x00000038391f723eULL, 0x020fe200000010ffULL, 0x000000ffff337224ULL, 0x000fe200078e0022ULL,
0x000000341300720bULL, 0x002fe20003f3e000ULL, 0x0000002900297308ULL, 0x000fe40000000800ULL,
0x000000ffff197224ULL, 0x000fe200078e001fULL, 0x0000001334137208ULL, 0x000fc40004800000ULL,
0x0000002c2d1c723eULL, 0x008fc600000010ffULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000ffff2c7224ULL, 0x100fe400078e002aULL, 0x000000ffff2d7224ULL, 0x000fca00078e002aULL,
0x0000003200327308ULL, 0x000fe40000000800ULL, 0x0000002c1c24723cULL, 0x000fec0000041824ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0xfffffff8ff2c7812ULL, 0x000fca00078ee23fULL,
0x000000082c2d7824ULL, 0x000fe400078e00ffULL, 0x00000020002e7308ULL, 0x0007e20000000800ULL,
0x000000322321723eULL, 0x002fce00000010ffULL, 0x0000004100417308ULL, 0x000e620000000800ULL,
0x000000293020723eULL, 0x008fe200000010ffULL, 0x000000082c327824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x000fc80000011604ULL, 0x0000000329297812ULL, 0x000fe400078ec0ffULL,
0x0000002e4123723eULL, 0x002fe200000010ffULL, 0x000000082c2e7836ULL, 0x000fe40000000000ULL,
0x00000001292c7824ULL, 0x040fe400078e022cULL, 0x00000001292f7824ULL, 0x000fe400078e022eULL,
0x0c201f0012297f89ULL, 0x000e6200000e0000ULL, 0x0000003a2024723cULL, 0x000fe20000041824ULL,
0xfffffff82d2a7812ULL, 0x000fe200078ee22cULL, 0x000000082e387824ULL, 0x000fc400078e00ffULL,
0x000000042c2d7836ULL, 0x000fe40000000000ULL, 0x000000082e317824ULL, 0x000fe200078e00ffULL,
0xfffffff8382e7812ULL, 0x000fe200078ee22fULL, 0x0000000c2c307836ULL, 0x000fe20000000000ULL,
0xfffffff8322c7812ULL, 0x000fe200078ee22dULL, 0x000000102a2a7824ULL, 0x000fe400078e022bULL,
0x000000ffff2d7224ULL, 0x000fe200078e0016ULL, 0xfffffff831387812ULL, 0x000fe200078ee230ULL,
0x000000ffff2f7224ULL, 0x000fc400078e001aULL, 0x000000ffff307224ULL, 0x000fe400078e001cULL,
0x000000ffff317224ULL, 0x000fe400078e001eULL, 0x000000102e277824ULL, 0x100fe400078e022bULL,
0x000000102c257824ULL, 0x000fe200078e022bULL, 0x000000291200720bULL, 0x002fe20003f1e000ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0014ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0018ULL,
0x0000001229127208ULL, 0x000fe20004000000ULL, 0x000000ffff327224ULL, 0x000fe200078e0020ULL,
0x0000000304ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff417224ULL, 0x000fe200078e0017ULL,
0x0000002c2a007844ULL, 0x000fe20000000200ULL, 0x0000001038387824ULL, 0x000fc400078e022bULL,
0x000000ffff187224ULL, 0x000fe200078e001dULL, 0x0000003025007844ULL, 0x0003e20000000200ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff1b7224ULL, 0x000fe200078e0023ULL,
0x0000004027007844ULL, 0x0007e20000000200ULL, 0x00000001ff147424ULL, 0x000fc600078e00ffULL,
0x0000001838007844ULL, 0x0007e80000000200ULL, 0x0170001028008388ULL, 0x0007e20000000c00ULL,
0x000000ffff257224ULL, 0x002fca00078e0026ULL, 0x0172002428008388ULL, 0x0007e20000000a00ULL,
0x0000000f0c00720cULL, 0x000fe20003f06070ULL, 0x017608140bff79a7ULL, 0x000fe2000850003fULL,
0x017610140bff79a7ULL, 0x000fe2000850003fULL, 0x017618140bff79a7ULL, 0x000fe2000850003fULL,
0x017620140bff79a7ULL, 0x0003e4000850003fULL, 0x000000ffff147224ULL, 0x002fce00078e000eULL,
0xffffffb800948947ULL, 0x00cfea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000007007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000700008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000007027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000700007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffee002587950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000569ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000006e8ULL, 0x0000000000000240ULL, 0x0000001600000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000928ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a5cULL, 0x0000000000000624ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001080ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001080ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000010c8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001100ULL, 0x0000000000011f80ULL, 0x0000001600000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013080ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000130d0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000130d0ULL, 0x0000000000000260ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000136b0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000136b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000010c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000011f80ULL,
0x0000000000011f80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000013080ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000130d0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 79872;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
